﻿USE sofia;
DROP TABLE IF EXISTS sofia.nheBl_vpl;
CREATE TABLE nheBl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nheBl_vpl WRITE;
INSERT INTO nheBl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Quema pejqui nochi tlen onca, Toteco Dios quichijqui elhuicactli huan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pero tlaltepactli ax quejatza nesiyaya, san cactoya, niyon ax tlacualtlalili. San oncayaya se hueyi tzintlayohuilotl tlen quiixtzactoya nopa atl tlen tlahuel huejcatla. Huan Itonal Toteco Dios nemiyaya aixco. ");
INSERT INTO nheBl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Huan Toteco Dios quiijto: “¡Ma onca tlahuili!” Huan oncac tlahuili. ");
INSERT INTO nheBl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Huan Toteco Dios quitlachili nopa tlahuili tlen quichijtoya huan quiitac para cuali. Teipa quiiyocatlali nopa tlahuili ica nopa tzintlayohuilotl. ");
INSERT INTO nheBl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Huan Toteco Dios quitocajti nopa tlahuili “tonaya” huan nopa tzintlayohuilotl quitocajti “tlayohua”. Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa achtohui tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Huan Toteco Dios quiijto: “Ma onca ajacatl tlen quixelos nopa atl para mocahuas iyoca.” Huan queja nopa elqui. ");
INSERT INTO nheBl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Huajca Toteco Dios quichijqui nopa ajacatl tlen quixelo nopa atl para tlajco nopa atl mocajqui tlatzintla huan ne seyoc tlajco mocajqui huejcapa. ");
INSERT INTO nheBl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Huan campa oncac ajacatl quitocajti “elhuicactli”. Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa ompa tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Huan Toteco Dios quiijto: “Ma mosejcotili nopa atl tlen eltoc tlatzintla elhuicactli para ma mopannexti tlen huactoc.” Huan queja nopa elqui. ");
INSERT INTO nheBl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Huan Toteco Dios quitocajti tlen huactoc “tlali”. Huan nopa atl tlen mosejcotilijtoya quitocajti “hueyi atl”. Huan Toteco Dios quitlachili tlen quichijtoya huan quiitac para cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Huan Toteco Dios quiijto: “Ma temaca nopa tlali nochi tlamantli xihuitl tlen xoxohuic huan sesen icone ma eli queja ya. Ma onca xihuitl tlen temaca ininyol huan cuatini tlen temacaj inintlajca. Huan sesen tlamantli ma quincahua iconehua tlen queja ya.” Huan queja nopa elqui. ");
INSERT INTO nheBl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Huajca nopa tlali temacac nochi tlamantli xihuitl tlen xoxohuic. Temacac xihuitl tlen temacaj ininyol huan cuatini tlen temacaj inintlajca. Huan sesen ininconehua elqui queja nopa xihuitl o nopa cuahuitl tlen temacac. Huan Toteco Dios quitlachili tlen quichijtoya huan elqui cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa expa tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Huan Toteco Dios quiijto: “Ma onca tlahuili nepa elhuicactli para ma tlatlanexti ipan tlaltepactli para quiiyocatlalis tonaya huan tlayohua. Huan para ma tenextilise tlaque tonal, huan tlaque xihuitl huan tlaque ipohual ipan se xihuitl onca. ");
INSERT INTO nheBl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Huan ma cahuanica nepa ipan elhuicactli para tlahuise ipan tlaltepactli.” Huan queja nopa elqui. ");
INSERT INTO nheBl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Huajca queja nopa Toteco Dios quichijqui nopa ome huejhueyi tlahuili. Quichijqui tonati tlen más hueyi para tlatlanextis tonaya huan nopa metztli para tlatlanextis tlayohua. Huan Toteco Dios nojquiya quinchijchijqui sitlalime. ");
INSERT INTO nheBl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Huan Toteco Dios quintlali nopa tlahuili ipan elhuicactli para ma tlatlanextica ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Nopa hueyi tlahuili para tlahuis tonaya huan tlen ax más hueyi tlahuis tlayohua para queja ni moiyocatlalise tlahuili huan tzintlayohuilotl. Huan quiyolpacti Toteco Dios nochi tlen quichijtoya pampa elqui cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa najpa tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Huan Toteco Dios quiijto: “Ma temi nopa atl ica miyac tlamantli tlen yoltoque. Huan ma temi nochi elhuicactli ica miyac tlamantli totome tlen patlanij.” ");
INSERT INTO nheBl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Huajca Toteco Dios quinchijchijqui nochi huejhueyi tlapiyalime tlen itztoque ipan hueyi atl huan nochi tlamantli michime. Huan quichijqui para sesen ma quinpiyaca ininconehua queja inijuanti. Huan quinchijchijqui nochi totome huan quichijqui para ma quinpiyaca ininconehua queja inijuanti. Huan Toteco Dios quitlachili nochi tlen quichijtoya huan elqui cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Huan Toteco Dios quitiochijqui sesen tlamantli tlen quinchijtoya huan quinilhui: “Ximomiyaquilica huan xijtemitica nopa hueyi atl.” Huan Toteco Dios quinnahuati nopa totome: “Xijpiyaca miyac imoconehua huan xijtemitica campa hueli ipan tlaltepactli.” ");
INSERT INTO nheBl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa macuilpa tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Huan Toteco Dios quiijto: “Ma onca ipan tlaltepactli nochi tlamantli tlapiyalime. Ma onca tlapiyalime tlen mosisiníaj huan tlen maxojtzitzi huan nojquiya tlen mohuahuatatzaj tlalchi.” Huan queja nopa elqui. ");
INSERT INTO nheBl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Huajca queja nopa Toteco Dios quinchijchijqui nochi tlapiyalime huan quintlachili huan nochi quiyolpacti. ");
INSERT INTO nheBl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Teipa Toteco Dios quiijto: “Ama ma tiquinchihuaca tlacame. Tiquinchihuase ma elica queja tojuanti huan quipiyase totlachiyalis. Huan inijuanti quipiyase tlanahuatili ica michime, huan totome, huan ica tlapiyalime tlen mosisiníaj, huan ica tlen maxojtzitzi huan ica nochi tlen nemij ipan tlaltepactli.” ");
INSERT INTO nheBl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Huajca Toteco Dios quinchijqui tlacame ica itlachiyalis. Quena, queja yajaya itlachiyalis Toteco Dios quinchijqui. Quinchijchijqui tlacatl huan sihuatl. ");
INSERT INTO nheBl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Huan Toteco Dios quintiochijqui huan quinilhui: “Xiquinpiyaca miyac imoconehua para inijuanti itztose campa hueli ipan nochi tlaltepactli para ma tlanahuatica. Nojquiya nimechtlalía xiquinnahuatica nochi michime, totome huan nochi tlen nemij ipan tlaltepactli.” ");
INSERT INTO nheBl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Huan teipa Toteco Dios quinilhui nopa tlacatl huan sihuatl: “Xiquitaca, nimechmaca nochi tlamantli xihuitl tlen quipiya iyol huan nochi cuahuitl tlen quipiya itlajca para inquicuase. ");
INSERT INTO nheBl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Huan nopa tlapiyalime, totome huan nochi sequinoc tlamantli tlen nemij ipan tlaltepactli niquinmaca nochi sacatl huan xihuitl tlen xoxohuixtoc para inintlacualis.” Huan queja nopa elqui. ");
INSERT INTO nheBl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Huan Toteco Dios quitlachili nochi tlen quichijtoya huan eltoya cuali. Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa chicuasempa tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Huajca queja nopa Toteco Dios quitlamisencajqui nochi elhuicactli, huan nochi tlaltepactli huan nochi tlen onca nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Quema ajsic nopa chicompa tonal, ya tlantoya tlen Toteco Dios quichihuayaya huan mosiyajcajqui. ");
INSERT INTO nheBl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Huan Toteco Dios quitiochijqui nopa chicompa tonali huan quiijto para elis tlatzejtzeloltic pampa ipan nopa tonali ya tlantoya itequi huan mosiyajcajqui. ");
INSERT INTO nheBl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Huajca queja nopa TOTECO Dios quichijqui tlaltepactli huan elhuicactli. Nica techilhuía quejatza TOTECO Dios quichijqui elhuicactli huan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Achtohui ax oncayaya xihuitl niyon ax tleno panquistoya pampa TOTECO Dios aya quichijtoya ma huetzi atl ipan tlaltepactli. Nojquiya axaca itztoya para tequitis. ");
INSERT INTO nheBl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pero yonque TOTECO Dios ax quichijtoya ma tlaahuetzi ipan tlaltepactli, tlen tlaltitla tlejcoyaya apoctli huan quiatequiyaya tlali. ");
INSERT INTO nheBl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Huan TOTECO Dios quicuic tlali huan quisencajqui itlacayo se tlacatl. Huan quiyacailpitzqui huan quimacac yolistli. Huan nopa tlacatl pejqui quipiya yolistli. ");
INSERT INTO nheBl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Teipa TOTECO Dios quitojqui se xochimili tlen itoca Edén nepa imelac campa quisa tonati. Huan nopano quicajqui nopa tlacatl tlen quichijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Huan TOTECO Dios quichijqui ma moscalti xochimilijtic nochi tlamantli cuatini tlen yejyectzitzi nesiyaya huan nochi tlamantli cuatini tlen temacaj cuatlajcayotl para quicuase. Huan tlatlajco nopa xochimili TOTECO Dios quitojqui se cuahuitl tlen temaca itlajca huan itoca cuahuitl tlen temaca yolistli. Nojquiya quitojqui seyoc cuahuitl ica itlajca huan itoca nopa cuahuitl tlen temachiltía tlen cuali huan tlen ax cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ipan Edén oncayaya se atemitl tlen quiatequiyaya nopa xochimili. Huan quema quisayaya, moxelohuayaya ica najcac. ");
INSERT INTO nheBl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nopa achtohui amaxali tlen nopa atemitl itoca Pisón huan ya ni tlen tlayahualohuayaya campa hueli ipan nochi nopa tlali tlen itoca Havila campa onca oro. ");
INSERT INTO nheBl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nopa oro tlen nopa tlali eliyaya senquistoc cuali. Nojquiya nopano oncayaya se tlaajhuiyacayotl tlen patiyo huan piltetzitzi tlen yejyectzitzi tlen itoca ónice. ");
INSERT INTO nheBl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Huan nopa ompa amaxali tlen nopa atemitl itoca Gihón huan tlayahualohuayaya campa hueli ipan nopa tlali tlen itoca Cus. ");
INSERT INTO nheBl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Huan nopa expa amaxali tlen nopa atemitl itoca Tigris huan pano iteno tlali Asiria imelac campa quisa tonati. Huan nopa najpa amaxali tlen nopa atemitl itoca Éufrates. ");
INSERT INTO nheBl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Huajca TOTECO Dios quihuicac nopa tlacatl huan quicajqui ipan nopa xochimili tlen itoca Edén para ma quimocuitlahui, ");
INSERT INTO nheBl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","huan TOTECO Dios quinahuati: “Huelis tijcuas itlajca tlen hueli cuahuitl ipan ni xochimili, ");
INSERT INTO nheBl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","pero ne cuahuitl tlen itoca ‘cuahuitl tlen temachiltía tlen cuali huan tlen ax cuali’, axtle. Amo xijcua itlajca, pampa ipan nopa tonal quema tijcuas itlajca, melahuac timiquis.” ");
INSERT INTO nheBl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Teipa TOTECO Dios quiijto: “Ax cuali para itztos iselti ni tlacatl. Para ma ax cuesihuis, nijchihuilis se acajya tlen quinamiquis huan tlen quipalehuis.” ");
INSERT INTO nheBl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Huan ica tlali TOTECO Dios quinchijtoya nochi tlapiyalime huan nochi totome. Teipa quihuiquili nopa tlacatl para ma quintocajtlali. Huan tlen nopa tlacatl quintocajtlali, ya nopa elqui inintoca. ");
INSERT INTO nheBl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Huajca nopa tlacatl quintocajtlali nochi tlamantli tlapiyalime tlen maxojtzitzi, huan nochi totome huan nochi tlapiyalime tlen mosisiníaj. Pero niyon se tlen nopa tlapiyalime ax quinamijqui para quipalehuis nopa tlacatl para ax cuesihuis. ");
INSERT INTO nheBl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Huajca TOTECO Dios quichijqui ma tlahuel cochi Adán. Huan quema cochtoya, quiquixtili se ielchiqui omiyo huan sampa quimotzquilti inacayo queja eltoya. ");
INSERT INTO nheBl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Huan ica nopa tlacatl ielchiqui, TOTECO Dios quisencajqui se sihuatl huan quihuicac campa nopa tlacatl. ");
INSERT INTO nheBl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Huan quema nopa tlacatl quiitac nopa sihuatl, quiijto: “¡Ama quena! Ya ni san se ica na, pampa inacayo quisqui nonacayotipa, huan iomiyo quisqui noomiyotipa. Itoca elis ‘sihuatl’, pampa TOTECO Dios nechquixtili tlen na, nitlacatl.” ");
INSERT INTO nheBl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Huan yeca se tlacatl quicahuas itata huan inana para mosejcotilis ihuaya isihua huan nopa ome mochihuase san se inintlacayo. ");
INSERT INTO nheBl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Huan yonque nopa tlacatl huan isihua xolome nemiyayaj, ax mopinahuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nopa cohuatl eliyaya tlen más tlalnamiqui huan más quimatiyaya quejatza tlacajcayahuas que nochi sequinoc tlapiyalime tlen TOTECO Dios quinchijtoya. Huan se tonal nopa cohuatl quitlajtlani nopa sihuatl: ―¿Ax inmechilhuijtoc Dios para amo xijcuaca itlajca niyon se cuahuitl ipan ni xochimili? ");
INSERT INTO nheBl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Huan nopa sihuatl quinanquili: ―Huelis tijcuase itlajca tlen hueli cuahuitl, ");
INSERT INTO nheBl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","pero iyojtzi ne tlen eltoc tlatlajco xochimili Dios techilhuijtoc ax cuali tijcuase, niyon tiquitzquise itlajca ne cuahuitl pampa intla tijchihuase, timiquise. ");
INSERT INTO nheBl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Pero nopa cohuatl quiilhui nopa sihuatl: ―Ax neli, ax inmiquise. ");
INSERT INTO nheBl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Cuali quimati Dios intla inquicuase itlajca nopa cuahuitl elis queja inmechtlapohuilis imoixtiyol huan imotlalnamiquilis huan inquimatise tlen cuali huan tlen ax cuali. Queja nopa inelise queja ya. ");
INSERT INTO nheBl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Teipa nopa sihuatl momacac cuenta para yejyectzi itlajca nopa cuahuitl huan nesiyaya cuali para quicuas. Huajca quiixtocac pampa nojquiya quinejqui quipiyas tlalnamiquistli. Yeca quitejqui se huan quicuajqui. Huan teipa quimacac ihuehue huan ya nojquiya quicuajqui. ");
INSERT INTO nheBl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Huan ipan nopa tlalochtli elqui queja tlapojqui iniixtiyol huan nochi ome momacaque cuenta para xolome itztoyaj huan mopinajque. Huajca quiijtzonque ixihuiyo nopa cuahuitl tlen itoca higuera para quichihuase iniixpantzajca huan ica ya nopa motzajque. ");
INSERT INTO nheBl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Huan teipa ica tiotlac quema tlasesestoc, nopa tlacatl huan isihua quicajque TOTECO Dios nemiyaya xochimilijtic. Huan motlalojque motlatitoj iica nopa cuatini para TOTECO Dios ma ax quinita. ");
INSERT INTO nheBl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pero TOTECO Dios quinojnotzqui nopa tlacatl huan quitlajtlani: ―¿Canque tiitztoc? ");
INSERT INTO nheBl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Huan nopa tlacatl tlananquili: ―Nijcajqui para tinemiyaya xochimilijtic huan nimajmajqui pampa nixolotl. Huan yeca nimotlati. ");
INSERT INTO nheBl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Huajca Toteco Dios quitlajtlani: ―Huan ¿ajqueya mitzilhuijtoc para tixolotl? ¿Tijcuajtoc itlajca nopa cuahuitl tlen nimitzilhui amo xijcua? ");
INSERT INTO nheBl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Huan nopa tlacatl tlananquili: ―Nopa sihuatl tlen tinechmacac para notlahuical, yajaya nechmacac se itlajca nopa cuahuitl huan yeca nijcuajqui. ");
INSERT INTO nheBl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Huajca TOTECO Dios quitlajtlani nopa sihuatl: ―¿Para tlen tijchijqui ya ni? Huan nopa sihuatl quinanquili: ―Nopa cohuatl nechcajcayajqui huan yeca nijcuajqui itlajca nopa cuahuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Huan teipa TOTECO Dios quiilhui nopa cohuatl: ―Ica ya ni tlen tijchijtoc, tielis más titlatelchihuali que nochi sequinoc tlapiyalime. Huan san timohuahuatatztinemis ipan tlali huan tlaltejpoctli tijcuas nochi moyolis. ");
INSERT INTO nheBl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nijchihuas ximocualancaitaca ta ica nopa sihuatl. Huan mocualancaitase moixhui ica ya iixhui. Iixhui mitztzonxamanis huan ta tijcotztlantzacanis. ");
INSERT INTO nheBl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Huan TOTECO Dios quiilhui nopa sihuatl: ―Nijchihuas xineltlaijiyohui quema ticonepiyas huan ica tlacuajcualocayotl titlatlacatiltis. Pero ta tijnequis mohuehue, huan yajaya mitznahuatis. ");
INSERT INTO nheBl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Huan TOTECO Dios quiilhui nopa tlacatl: ―Pampa tijneltoquili mosihua huan tijcuajqui itlajca nopa cuahuitl tlen nimitzilhui amo xijcua, tlatelchihuali elis nochi tlali mopampa ta motlajtlacol. Huan ica miyac tequitl tijpiyas tlen tijcuas nochi moyolis. ");
INSERT INTO nheBl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nopa tlali quiixhualtis huitztli huan sahua mecatl. Huan tijcuas nopa cuali xihuitl tlen moscaltis nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Huan timitonis miyac para tijpantis tlacualistli tlen ica timopanoltis hasta quema timiquis huan timocuepas tlali sampa. Na nijchijqui motlacayo ica tlali, huan quema timiquis, sampa timocuepas tlali. ");
INSERT INTO nheBl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Huan Adán quitocajti isihua Eva. (Eva quinequi quiijtos Yolistli.) Huan Eva elqui ininnana nochi tlacame tlen itztoque. ");
INSERT INTO nheBl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Huan TOTECO Dios quinchihuili Adán huan Eva ininyoyo ica inincuetlaxo tlapiyalime huan quinyoyonti. ");
INSERT INTO nheBl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Huan TOTECO Dios moilhui: “Ama ni tlacame mocueptoque queja tojuanti pampa quimatij tlen cuali huan tlen ax cuali. Intla quitequise itlajca nopa Cuahuitl Tlen Temaca Yolistli, itztose para nochipa queja ni.” ");
INSERT INTO nheBl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Huajca TOTECO quinquixti tlen nopa xochimili tlen itoca Edén. Huan quintitlanqui ma tequiti ipan nopa tlali tlen ica quisencajtoya itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Huan teipa quema TOTECO Dios quintojtocatoya, quintlali sequin ielhuicac ejcahua tlen inintoca querubines para itztose imelac nopa xochimili ica campa quisa tonati para ma quimocuitlahuica nopa xochimili. Huan TOTECO Dios nojquiya quitlali nopano se machete tlen lementoya huan moyahualohuayaya campa hueli para axaca ma ajsi campa nopa Cuahuitl Tlen Temaca Yolistli. ");
INSERT INTO nheBl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Huan Adán cochqui ihuaya isihua, huan isihua conecuic huan quitlacatilti se oquichpil tlen quitocajti Caín. (Caín quinequi quiijtos Nijpixtoc.) Queja nopa quitocajti pampa Eva quiijto: “Ica itlapalehuil TOTECO nijpixtoc se tlacatl.” ");
INSERT INTO nheBl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Huan teipa Eva quitlacatilti seyoc oquichpil tlen quitocajtlali Abel. Huan quema nopa ome moscaltijque, Abel quinmocuitlahui borregojme, huan Caín miltequitqui. ");
INSERT INTO nheBl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Huan se tonal Caín quihualiquili TOTECO se tlacajcahualistli tlen quipixcatoya. ");
INSERT INTO nheBl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Huan Abel nojquiya quihualiquili TOTECO sequin borregojme tlen más tomahuaque huan tlen achtohui tlacatque. Huan quinmicti huan quimacac TOTECO. Huan TOTECO quicualitac Abel ica itlacajcahualis huan quiseli. ");
INSERT INTO nheBl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Pero ica Caín huan itlacajcahualis ax quicualitac. Yeca Caín cualanqui miyac huan fiero tlachixtinenqui. ");
INSERT INTO nheBl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Huajca TOTECO quiilhui Caín: “¿Para tlen ticualani huan fiero titlachixtinemi? ");
INSERT INTO nheBl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","¿Ax tijmati intla tijchihuas tlen cuali, nimitzselis huan tipaquis? Pero intla ax tijchihua tlen cuali, mitztlanis tlajtlacoli. Nopa tlajtlacoli eltoc queja se tecuani tlen mitzchiya mocalteno huan quinequi mitztlanis, pero monequi ta xijtlanis ya.” ");
INSERT INTO nheBl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Huan panoc se ome tonali huan Caín quinotztejqui iicni Abel huan quiilhui: ―Ma tiyaca cuatitla. Huan quema ajsitoj cuatitla, Caín quitehuijqui iicni Abel huan quimicti. ");
INSERT INTO nheBl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Huajca TOTECO quitlajtlani Caín: ―¿Canque itztoc moicni Abel? Huan Caín quinanquili: ―Ax nijmati na. Ax notequi para nijmocuitlahuis noicni. ");
INSERT INTO nheBl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Huan TOTECO quiilhui: ―¿Para tlen tijchijtoc ya ni? Tijmicti moicni huan ieso tijtoyajtoc ipan tlali. Huan ama eltoc queja ieso nechtlajtlanía chicahuac ma nimitztlatzacuilti. ");
INSERT INTO nheBl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Huajca ama, ipampa tlen tijchijtoc, nimitztelchihuas. Ayoc huelis titequitis ipan tlali pampa tijnenpolojtoc ica ieso moicni. ");
INSERT INTO nheBl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Huan yonque titlatojtocas, ayoc tleno tiqueliltis. Monequi san tinentinemis campa hueli ipan tlaltepactli huan ax cana tijpiyas para timochantlalis. ");
INSERT INTO nheBl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Huajca Caín quinanquili TOTECO: ―Nelchicahuac ni tlatzacuiltili huan ax huelis niquijiyohuis. ");
INSERT INTO nheBl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ama tinechtojtoca huejca tlen ni tlali huan ayoc huelis nimitznechcahuis ta. Nielis se ninejnenquetl campa hueli tlali huan ax huelis nimosiyajcahuas. Queja ni aqui hueli nechpantis, nechmictis. ");
INSERT INTO nheBl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Pero TOTECO quinanquili: ―¡Axtle! Intla acajya mitzmictis, nijtlatzacuiltis chicome huelta más para nijcuepilis. Huajca TOTECO quitlalili Caín se tlanextilijcayotl para nochi quiixmatisquíaj para yajaya huan ax quimictisquíaj. ");
INSERT INTO nheBl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Huan Caín quistejqui campa ihuaya camatiyaya TOTECO huan yajqui itztoti ipan se tlali itoca Nod tlen mocahua imelac Edén para campa quisa tonati. ");
INSERT INTO nheBl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Huan Caín ihuaya cochqui isihua, huan yajaya conecuic huan quitlacatilti se oquichpil tlen itoca Enoc. Teipa Caín quichijqui se altepetl huan quitocajti nopa altepetl Enoc queja itoca icone. ");
INSERT INTO nheBl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Huan Enoc motlacachijqui huan elqui itata Irad. Huan teipa Irad moscalti huan elqui itata Mehujael. Huan teipa Mehujael motlacachijqui huan elqui itata Metusael. Huan Metusael moscalti huan elqui itata Lamec. ");
INSERT INTO nheBl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Huan Lamec quinpixqui ome isihuajhua; se itoca Ada huan ne seyoc Zila. ");
INSERT INTO nheBl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Huan Ada quitlacatilti Jabal. Huan Jabal motlacachijqui huan elqui inintata tlacame tlen mocajque ipan caltini tlen yoyomitl huan quinxinajchohuayayaj huan quiniscaltiyayaj tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Huan Jabal quipixqui se iicni tlen itoca Jubal. Huan Jubal moscalti huan quiyoliti tlapitzali huan nopa tlatzotzonali tlen itoca arpa. Huan yajaya elqui inintata tlacame tlen tlatzotzonaj. ");
INSERT INTO nheBl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Huan Zila, nopa seyoc isihua Lamec, quitlacatilti se oquichpil tlen itoca Tubal Caín tlen elqui se teposchijquetl. Huan Tubal Caín quitejtzonqui nopa tepostli tlen itoca bronce huan tlen itoca hierro huan ica nopa tepostli quisencahuayaya miyac tlamantli. Huan Tubal Caín quipixqui se isihua icni tlen itoca Naama. ");
INSERT INTO nheBl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Huan se tonal Lamec quinilhui iome sihuajhua Ada huan Zila: “Xijtlacaquilica cuali tlen nimechilhuis. Nijmicti se tlacatl pampa nechcoco. Huan elqui se telpocatl tlen nechmaquilijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Intla se acajya quichihuilisquía se tlenijqui Caín, quiselisquía se tlatzacuiltilistli chicome huelta más chicahuac. Pero intla se acajya nechcuepilisquía tlen nijchijtoc na, niLamec, monequisquía quiselis se tlatzacuiltili tlen ax san chicome hueltas, nelpano más chicahuac.” ");
INSERT INTO nheBl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Huan Adán cochqui ihuaya isihua, huan isihua sampa conepixqui huan quitlacatilti seyoc oquichpil tlen quitocajti Set. (Set quinequi quiijtos Nechmacatoc.) Queja nopa quitocajti pampa quiijto: “Toteco Dios nechmacatoc seyoc conetl ipatlaca Abel tlen Caín quimicti.” ");
INSERT INTO nheBl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Huan quema Set motlacachijqui, quipixqui se icone tlen quitocajti Enós. Huajca ipan nopa tonali tlacame pejque quihueyichihuaj TOTECO san sejco. ");
INSERT INTO nheBl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ya ni inintoca iteipa ixhuihua Adán: Quema Toteco Dios quinchijqui tlacame, quinsencajqui queja ya itlachiyalis. ");
INSERT INTO nheBl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Quinsencajqui tlacame huan sihuame huan ipan nopa tonal quema quinchijqui, quintiochijqui huan quintocajti “tlacame”. ");
INSERT INTO nheBl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Huan quema Adán quipixqui 130 xihuitl, tlacatqui icone tlen elqui queja ya huan san se inintlachiyalis huan quitocajti Set. ");
INSERT INTO nheBl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Huan quema ya tlacajtoya Set, Adán noja itztoya seyoc 800 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Huan mijqui Adán quema quipixqui 930 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Huan Set quipiyayaya 105 xihuitl quema tlacatqui icone, Enós. ");
INSERT INTO nheBl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Teipa Set noja itztoya seyoc 807 xihuitl huan noja quinpixqui sequinoc iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Huan mijqui Set quema quipixqui 912 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Huan Enós quipiyayaya 90 xihuitl quema tlacatqui icone, Cainán. ");
INSERT INTO nheBl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Teipa Enós noja itztoya seyoc 815 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Huan Enós mijqui quema quipixqui 905 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Huan Cainán quipiyayaya 70 xihuitl quema tlacatqui icone, Mahalaleel. ");
INSERT INTO nheBl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Teipa Cainán itztoya seyoc 840 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Huan Cainán mijqui quema quipixqui 910 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Huan Mahalaleel quipiyayaya 65 xihuitl quema tlacatqui icone, Jared. ");
INSERT INTO nheBl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Teipa Mahalaleel itztoya seyoc 830 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Huan mijqui Mahalaleel quema quipixqui 895 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Huan Jared quipiyayaya 162 xihuitl quema tlacatqui icone, Enoc. ");
INSERT INTO nheBl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Teipa, Jared itztoya seyoc 800 xihuitl más huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Huajca nochi xihuitl tlen itztoya Jared quiaxiti 962 xihuitl huan huajca mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Huan Enoc quipiyayaya 65 xihuitl quema tlacatqui icone, Matusalén. ");
INSERT INTO nheBl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Huan Enoc nochipa quichijqui ipaquilis Toteco Dios. Huan teipa quema Matusalén ya tlacajtoya, Enoc itztoya seyoc 300 xihuitl más huan noja quinpixqui sequinoc iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Huajca ica nochi Enoc quiaxiti 365 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Huan pampa Enoc nochipa nejnentoya queja Toteco Dios ipaquilis, se tonal polijqui pampa Toteco Dios quihuicac. ");
INSERT INTO nheBl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Huan Matusalén quipiyayaya 187 xihuitl quema tlacatqui icone tlen quitocajti Lamec. ");
INSERT INTO nheBl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Huan teipa Matusalén itztoya seyoc 782 xihuitl más huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Huajca ica nochi Matusalén quiaxiti 969 xihuitl huan huajca mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec quipiyayaya 182 xihuitl quema tlacatqui icone, ");
INSERT INTO nheBl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","huan quitocajti Noé. (Noé quinequi quiijtos Techyoltlalis.) Queja nopa quitocajti pampa quiijto: “TOTECO quitelchijqui ni tlali, huan monequi titequitise tlahuel chicahuac para titlaeliltise, pero ni conetl techyoltlalis.” ");
INSERT INTO nheBl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Huan teipa quema Noé ya tlacajtoya, Lamec noja itztoya seyoc 595 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Huajca nochi xihuitl tlen itztoya Lamec quiaxiti 777 huan huajca mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Huan Noé quipiyayaya 500 xihuitl quema tlacatque iconehua, Sem, Cam huan Jafet. ");
INSERT INTO nheBl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Huan tlacame pejque momiyaquilíaj ipan ni tlaltepactli huan quinpixque iniichpocahua. ");
INSERT INTO nheBl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Huan ipan nopa tonali sequin tlen quintocajtiyayaj “itelpocahua Toteco Dios 6:2 Sequin tlacame tlen miyac momachtijtoque Itlajtol Toteco moilhuíaj para “itelpocahua Toteco Dios” camati tlen ielhuicac ejcahua Toteco. Nica moilhuíaj camati tlen nopa ielhuicac ejcahua tlen mosisinijque ica Toteco huan quitoquilijque Axcualtlacatl, huan yeca mocuepque tlen tiquintocajtíaj ajacame. Sequinoc tlacame moilhuíaj para “itelpocahua Toteco Dios” camati tlen iteipa ixhuihua Set tlen achtohui quitoquilijque Toteco, pero teipa miyac tlen inijuanti pejque mosihuajtíaj ica iniichpocahua tlacame tlen ax quiixmatiyayaj Toteco.” quinitaque para yejyectzitzi iniichpocahua tlacame ipan ni tlaltepactli. Huajca quintlapejpenijque tlen quinixtocayayaj huan quincuique para ininsihuajhua. ");
INSERT INTO nheBl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Huan TOTECO quiijto: “Notonal ax quinijiyohuis tlacame huan inintlajtlacolhua para nochipa pampa tlacame san panoni. Huajca ama niquincahuilis ni tlacame ma itztoca san se 120 xihuitl.” ");
INSERT INTO nheBl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Huan ipan nopa tonali huan nojquiya teipa itztoyaj huejcapantique tlacame ipan tlaltepactli. Inijuanti nesque quema nopa “itelpocahua Toteco Dios” mosejcotilijque ihuaya iniichpocahua tlacame para quinpiyase coneme ininhuaya. Huejcajquiya inijuanti itztoyaj huejhueyi tlacame tlen nochi quinixmatiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Huan TOTECO quiitac para nelmiyac inintlaixpanolhua tlacame ipan tlaltepactli huan nochipa moilhuiyayaj tlen ax cuali quichihuase. ");
INSERT INTO nheBl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yeca ica cuesoli TOTECO pejqui moyolpatla. Moyolilhui intla cuali elqui para quinchijtoya tlacame o axtle huan nelía quiyolcoco. ");
INSERT INTO nheBl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Huan TOTECO quiijto: “Niquinpolihuiltis tlacame tlen niquinsencajtoc ipan tlaltepactli. Nojquiya niquinmictis nochi tlapiyalime, totome huan tlen mohuahuatatzaj tlalchi. Nimocuesohua huan nimoilhuía: ¿Para tlen niquinsencajqui?” ");
INSERT INTO nheBl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero Noé quipanti tlen cuali pampa TOTECO quicualitac. ");
INSERT INTO nheBl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ama nimechpohuilis tlen panoc ica Noé. Noé eliyaya se cuali tlacatl iixtla Toteco Dios. Niyon se ipan nopa tonali ax huelqui quiteilhui ica niyon se tlamantli. Yajaya nejnenqui queja Toteco Dios quinequiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Huan Noé quinpixqui eyi itelpocahua. Inintoca elque Sem, Cam huan Jafet. ");
INSERT INTO nheBl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Huan ipan nochi tlaltepactli campa hueli oncac tlen fiero iixtla Toteco Dios huan nochi tlacame san mosisiniyayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Huan Toteco Dios quiitac para nelfiero eltoya, huan nochi tlacame san mocuapolojtoyaj ipan tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Huajca Toteco Dios quiilhui Noé: “Niquinpolihuiltis nochi tlacame campa hueli ipan tlaltepactli pampa nochi san mosisiníaj, yeca niquinixpolos ica nochi tlen onca. ");
INSERT INTO nheBl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Huajca xijchihua se cuacanahua ica nopa cuahuitl tlen itoca resina huan calijtic xijchihuili pilcuartojtzitzi. Xijtzacua ica chapopojtli campa hueli iijtic huan ipani para ma ax calaquis atl. ");
INSERT INTO nheBl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Queja ni xijchihua nopa cuacanahua. Xijchihua 135 metros ihuehueyaca, 22 metros huan tlajco ipatlajca huan 13 metros huan tlajco ihuejcapanca. ");
INSERT INTO nheBl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Xijchihua nopa cuacanahua ica eyi pisos huan xijtlali se ventana nechca tlapamitl. Huan xijtlali se puerta ipan se lado. ");
INSERT INTO nheBl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nijtitlanis tlahuel miyac atl tlen momanas huejcapa hasta quitzonpolihuiltis nochi tlali huan nochi tlen quipiyaj yolistli campa hueli ipan tlaltepactli. Nochi tlen onca ipan tlali polihuis. ");
INSERT INTO nheBl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pero nijcahua notlajtol mohuaya para nimechmocuitlahuis ipan nopa cuacanahua. Huan ta ticalaquis ipan cuacanahua huan calaquise mohuaya mosihua, motelpocahua huan moyexhua. ");
INSERT INTO nheBl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nojquiya tiquinhuicas mohuaya ome tlapiyalime, se oquichtli huan se sihuatzi tlen nochi tlamantli tlapiyalime tlen itztoque ipan tlaltepactli para ma noja itztoca mohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mohuaya calaquise ome tlen nochi tlamantli totome, tlapiyalime huan tlen mohuahuatatzaj para ma ax miquica. ");
INSERT INTO nheBl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nojquiya xijhuica mohuaya nochi tlamantli tlacualistli tlen monequis inquicuase imojuanti huan nochi nopa tlapiyalime.” ");
INSERT INTO nheBl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Huan Noé quichijqui nochi queja Toteco Dios quiilhuijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Teipa TOTECO quiilhui Noé: “San ta tlen nochi tlacame tlen ama itztoque tijchihua tlen xitlahuac. Yeca xicalaqui ipan cuacanahua ininhuaya mosihua huan moconehua. ");
INSERT INTO nheBl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Xiquinhuica mohuaya chicome oquichme huan chicome sihuatzitzi tlen nochi tlamantli tlapiyalime tlen cuali para tlacajcahualistli. Pero xijhuica san se oquichtli huan se sihuatzi tlen nopa tlapiyalime tlen ax motequihuíaj para tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nojquiya xiquinhuica chicome oquichme huan chicome sihuatzitzi tlen nochi tlamantli totome para ax polihuis ininxinajcho ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pampa ica chicome tonali nijchihuas ma huetzi atl, huan tlaahuetzis para 40 tonali huan 40 yohuali. Queja nopa niquinpolihuiltis nochi tlen yoltoque tlen niquinsencajtoc ipan ni tlaltepactli.” ");
INSERT INTO nheBl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Huan Noé quichijqui nochi queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Huan Noé quipiyayaya 600 xihuitl quema momanqui nochi nopa miyac atl para quiatzonpolihuiltis tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Huan Noé calajqui ipan cuacanahua ininhuaya iconehua, isihua huan iyexhua para momanahuise tlen nopa miyac atl tlen hualas. ");
INSERT INTO nheBl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Huajca ojome hualajque nochi nopa tlapiyalime campa Noé. Hualajque tlapiyalime tlen cuali para tlacajcahualistli huan tlen ax cuali para tlacajcahualistli, tlen patlanij huan tlen mohuahuatatzaj. ");
INSERT INTO nheBl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Ojome nochi hualajque campa Noé huan calajque ipan cuacanahua. Calajque se oquichtli huan se sihuatzi tlen sesen tlamantli tlapiyali queja Toteco Dios tlanahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Huan ica chicome tonali hualajqui tlahuel miyac atl ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Quema Noé quipiyayaya 600 xihuitl, ipan nopa 17 tonali tlen nopa ompa metztli tlapojqui nochi ameltini campa meyayaya nopa atl tlen onca tlatzintla huan tlahuel pejqui toponi atl. Huan pejqui huetzi nelía miyac atl tlen ax moquetzqui. ");
INSERT INTO nheBl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Huan para 40 tonali huan 40 yohuali huetziyaya atl ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Quena, ipan san se nopa tonal quema pejqui huetzi atl, Noé calajqui ipan cuacanahua ihuaya iconehua, Sem, Cam huan Jafet. Huan ihuaya isihua huan eyi iyexhua. ");
INSERT INTO nheBl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Huan ininhuaya calajque nochi tlamantli tecuanime tlen mosisiníaj, huan tlapiyalime tlen maxojtzitzi, huan nochi tlen mohuahuatatzaj tlalchi huan nochi tlamantli totome. ");
INSERT INTO nheBl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nochi tlapiyalime calajque ihuaya Noé ipan cuacanahua ica ininhuical. ");
INSERT INTO nheBl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Calajqui se oquichtli huan se sihuatzi queja Toteco Dios quinahuatijtoya Noé. Teipa TOTECO quitzajqui ipuerta nopa cuacanahua. ");
INSERT INTO nheBl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Huan para 40 tonali san atl hualayaya. Huan quema pejqui tlejco nopa atl, nopa cuacanahua motlalanqui huan pejqui aixco nemi. ");
INSERT INTO nheBl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Huan nopa atl noja más tlejcoc huan tlahuel huejcatla mochijqui, pero nopa cuacanahua nejnentiyajqui aixco. ");
INSERT INTO nheBl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Huan teipa noja más tlejcotiyajqui hasta quinatzonpolihuilti nopa tepetini tlen más huejcapantique ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Huan teipa quema ya quitzactoya nopa tepetini noja tlejcoc nopa atl seyoc chicueyi metros iixco nopa tepetini. ");
INSERT INTO nheBl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yeca queja nopa mijque nochi tlen itztoyaj ipan tlaltepactli. Mijque nochi totome, huan tecuanime tlen mosisiníaj huan tlapiyalime tlen maxojtzitzi. Nojquiya mijque nochi tlamantli piltlapiyaltzitzi tlen mohuahuatatzaj tlalchi huan nochi tlacame. ");
INSERT INTO nheBl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nochi tlen itztoyaj ipan tlaltepactli tlen tlaijiyotilanayayaj mijque. ");
INSERT INTO nheBl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","San Noé huan nochi tlen itztoyaj ipan cuacanahua mocajque. Nochi sequinoc quinpolihuilti. Nochi tlacame, tlapiyalime, totome huan nochi tlen mohuahuatatzaj mijque. ");
INSERT INTO nheBl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Huan nopa atl quitzonpolihuilti nochi tlaltepactli para 150 tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Huajca Toteco Dios quiilnamijqui Noé ica nochi nopa tlapiyalime tlen itztoyaj iijtic cuacanahua. Huan Toteco Dios quichijqui ma tlaajaca ipan tlali, huan nopa atl pejqui temo. ");
INSERT INTO nheBl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Huan motzajque nopa ameltini campa meyayaya atl tlatzintla tlaltepactli, huan motzajqui nepa elhuicac huan ayoc huetzqui atl. ");
INSERT INTO nheBl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Huan nopa atl pejqui iyolic temoti. Huan ica seyoc 150 tonali miyac temotoya nopa atl. ");
INSERT INTO nheBl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Huan quema ajsic nopa 17 tonali tlen nopa chicompa metztli, nopa cuacanahua motlalito ipan se tepetl ipan nopa tepetini tlen itoca Ararat. ");
INSERT INTO nheBl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Huan mojmostla más temotiyohuiyaya nopa atl. Huan quema ajsic nopa achtohui tonal tlen nopa majtlacpa metztli, nesqui inintzonatipa nopa tepetini tlen más huejcapantique. ");
INSERT INTO nheBl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Huajca Noé quichixqui seyoc 40 tonali huan quitlapo nopa ventana tlen quichijtoya ipan nopa cuacanahua. ");
INSERT INTO nheBl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Huan quimajcajqui se cacalotl. Huan nopa cacalotl san patlantinenqui campa hueli hasta huajqui tlali. ");
INSERT INTO nheBl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Teipa nojquiya quimajcajqui se paloma para quiitasquía intla ya huajqui nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pero nopa paloma mocuepqui ipan cuacanahua pampa ax cana quipanti para mosehuis, pampa nopa tlali noja temitoya ica atl. Huajca Noé quiquixti ima, quiitzqui nopa paloma huan quicalaqui. ");
INSERT INTO nheBl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Huajca Noé quichixqui seyoc chicueyi tonali huan sampa quititlanqui nopa paloma calteno tlen nopa cuacanahua. ");
INSERT INTO nheBl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Huan ica tiotlac quema pejtoya tzintlayohuaya, nopa paloma mocuepqui huan quihualicayaya ipan itenchopich imaxihuiyo se cuahuitl tlen itoca olivo. Queja nopa Noé momacac cuenta para nopa tlali huactiyohuiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Huan Noé sampa quichixqui seyoc chicome tonal huan sampa quititlanqui nopa paloma, pero ama quena, nopa paloma ayoc mocuepqui. ");
INSERT INTO nheBl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Huajca quema Noé quipiyayaya 601 xihuitl ipan nopa achtohui tonal tlen nopa achtohui metztli, tlantoya nopa atl. Huan Noé quiquixtili ipantzajca nopa cuacanahua huan quiitac nochi huactinemiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Huan ipan nopa tonal 27 itequi nopa ompa metztli, ya tlami huactoya nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Huajca Toteco Dios quiilhui Noé: ");
INSERT INTO nheBl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Xiquisa tlen nopa cuacanahua ihuaya mosihua, moconehua huan moyexhua. ");
INSERT INTO nheBl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nojquiya xiquinquixti nochi tlapiyalime tlen itztoque mohuaya. Xiquinquixti nopa totome huan nochi tlapiyalime para ma yaca huan ma quinpiyaca miyac ininconehua huan ma quitemitica ni tlaltepactli.” ");
INSERT INTO nheBl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Huajca Noé, isihua, iconehua huan iyexhua quisque tlen nopa cuacanahua. ");
INSERT INTO nheBl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nojquiya quisque nochi totome, huan nochi tlapiyalime tlen mosisiníaj, huan tlen maxojtzitzi huan nochi tlen mohuahuatatzaj. Huan sesen tlamantli tlapiyali quisqui ica iconehua tlen quitoquiliyayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Teipa Noé quichijqui se tlaixpamitl para TOTECO. Huan quicuic tlen sesen tlamantli tlapiyali huan sesen tlamantli tototl tlen cuali para tlacajcahualistli. Huan quinmicti huan quintlati ipan nopa tlaixpamitl para se tlacajcahualistli para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Quema TOTECO quiijnejqui ipocyo tlen ajhuiyac, yajaya moilhui: “Ax quema más nijtlatzacuiltis tlaltepactli ipampa inintlajtlacolhua tlacame pampa se tlacatl hasta quema tlacati san moilhuía tlen ax cuali para quichihuas. Nojquiya ayoc quema niquinpolihuiltis nochi tlapiyalime queja nijchijqui ni huelta. ");
INSERT INTO nheBl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Nochi tonali quema eltos ni tlaltepactli, oncas toquistli huan pixquistli. Nochipa oncas tlatotonilotl huan tlasesecayotl. Oncas metztli quema tlahuaquis huan metztli quema huetzis miyac atl, nochipa oncas tonaya huan tlayohua. Ni tlamantli ax quema tlamis quema noja eltos tlaltepactli.” ");
INSERT INTO nheBl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Huan Toteco Dios quitiochijqui Noé huan iconehua ica ni tlajtoli: “Xiquinpiyaca miyac imoconehua huan xijtemitica ni tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nochi tlapiyalime ipan tlaltepactli inmechimacasise. Inquipiyase tlanahuatili ica nochi totome ipan ajacatl, huan nochi tlapiyalime ipan tlali huan nochi tlen itztoque ipan hueyi atl. ");
INSERT INTO nheBl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Huelis inquincuase nochi tlapiyalime pampa nimechmaca nochi tlen itztoque para imotlacualis queja nojquiya nimechmacatoc nochi xihuitl tlen xoxohuic. ");
INSERT INTO nheBl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pero onca se tlamantli tlen ax cuali para inquicuase. Amo xijcuaca nacatl ica ieso pampa iyolis se tlapiyali eltoc ipan ieso. ");
INSERT INTO nheBl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Amo xitemicti. Intla se acajya quimictis se tlacatl, monequi miquis. Huan intla se tlapiyali quimictis se tlacatl, monequi miquis. Quena, monequi se tlacatl nechmacas cuenta tlaque quinchihuilijtoc sequinoc tlacame. ");
INSERT INTO nheBl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Intla acajya quimictía se tlacatl, monequi sequinoc quimictise nopa temictijquetl. Pampa Toteco Dios quichijchijtoc se tlacatl queja ya itlachiyalis. ");
INSERT INTO nheBl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Pero imojuanti, xiquinpiyaca miyac imoconehua. Quena, ximomiyaquilica huan xijtemitica ni tlaltepactli, ica imoixhuihua huan imoteipa ixhuihua.” ");
INSERT INTO nheBl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Teipa Toteco Dios quinilhui Noé huan iconehua: ");
INSERT INTO nheBl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ama nijcahua notlajtol ica imojuanti huan imoteipa ixhuihua, ");
INSERT INTO nheBl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","huan ica nochi totome, huan nochi tlapiyalime tlen itztoque ipan tlaltepactli huan ica nochi tlen quisque ipan cuacanahua imohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nijcahua notlajtol para ayoc quema niquinpolihuiltis sampa nochi tlacame huan nochi tlapiyalime ica miyac atl campa hueli. Ayoc quema oncas tlahuel miyac atl tlen momanas campa hueli ipan nochi tlaltepactli para quixolehuas. ");
INSERT INTO nheBl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ya ni elis nopa tlanextilijcayotl tlen nopa tlajtoli tlen nijchihua imohuaya huan ininhuaya nochi tlapiyalime para nochipa. Quinextis ayoc quema oncas tlahuel miyac atl hasta quinmictis nochi tlacame huan tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nijtlalijtoc noacosamalo ipan mixtli huan eltos queja se tlanextilijcayotl tlen nopa tlen nijtencahuilía ni tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Huan quema nijchihuas ma huala mixtli ipan tlaltepactli, noacosamalo monextis ipan nopa mixtli, ");
INSERT INTO nheBl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","huan huajca niquilnamiquis notlajtol tlen nijcajqui imohuaya huan ininhuaya nochi tlamantli tlapiyalime. Ayoc quema oncas tlahuel miyac atl campa hueli hasta quinpolos nochi tlamantli tlen itztoque. ");
INSERT INTO nheBl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pampa quema nopa acosamalotl monextis ipan mixtli, niquitas huan niquilnamiquis nopa tlajtoli tlen na, niimoTeco Dios, nijchijtoc para nochipa imohuaya huan ininhuaya nochi tlacame huan nochi tlapiyalime tlen itztoque ipan ni tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ni acosamalotl elis nopa tlanextilijcayotl tlen nopa tlajtoli tlen nijcajtoc ininhuaya nochi tlacame huan tlapiyalime ipan tlaltepactli.” Queja nopa Toteco Dios quiilhui Noé. ");
INSERT INTO nheBl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Iconehua Noé tlen ihuaya quisque ipan cuacanahua elque Sem, Cam huan Jafet. Huan Cam elqui itata Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Tlen ni ieyi telpocahua Noé quisque nochi tlacame tlen teipa momoyajque campa hueli ipan tlaltepactli para quitemitise. ");
INSERT INTO nheBl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Huan Noé tlen momatqui miltequiti, quitojqui se xocomeca mili. ");
INSERT INTO nheBl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Huan teipa se tonal quiic miyac xocomeca atl huan ihuintic. Huan huetzqui xolotl icalijtic ipan ichaj tlen tlasencahuali ica yoyomitl. ");
INSERT INTO nheBl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Huan quema Cam, tlen eliyaya itata Canaán, quiitac para itata huetztoya xolotl, yajqui quinpohuilito iicnihua. ");
INSERT INTO nheBl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Huajca Sem huan Jafet quicuique se yoyomitl huan quitlalijque iniajcolpa huan icanejnentiyajque para ax quiitase inintata xolotl. Huan quema calajque ipan icalijtic, tlachixtiyajque seyoc lado para ax quiitase Noé huan quitzajque Noé ica nopa yoyomitl. ");
INSERT INTO nheBl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Huan quema Noé isac huan ayoc ihuintitoya, quimatqui tlen Cam, icone teipa ejquetl, quichijtoya huan quimatqui para ax quitlepanitztoya. ");
INSERT INTO nheBl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Huajca quiijto: “¡Toteco Dios ma quitelchihua Canaán! ¡Ma elis inintlatequipanojca sequinoc, huan axaca ma quitlepanitas!” ");
INSERT INTO nheBl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Huan Noé nojquiya quiijto: “Ma tijhueyitlalica TOTECO tlen Sem quihueyimati. Huan Canaán ma elis itlatequipanojca Sem.” Huan nojquiya quiijto: ");
INSERT INTO nheBl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","“Toteco Dios más ma quihueyili itlal Jafet. Huan iteipa ixhuihua Jafet ma itztoca ininhuaya iteipa ixhuihua Sem. Huan Canaán ma eli inintlatequipanojca.” ");
INSERT INTO nheBl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Huan quema tlanqui nopa miyac atl, Noé noja itztoya seyoc 350 xihuitl, ");
INSERT INTO nheBl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","huan mijqui quema quipiyayaya 950 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Sem, Cam huan Jafet eliyayaj iconehua Noé huan ya ni iniixhuihua tlen quinpixque quema ya tlantoya nopa miyac atl tlen momanqui ipan nochi tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Itelpocahua Jafet elque: Gomer, Magog, Madai, Javán, Tubal, Mesec huan Tiras. ");
INSERT INTO nheBl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Itelpocahua Gomer elque: Askenaz, Rifat huan Togarma. ");
INSERT INTO nheBl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Itelpocahua Javán elque: Elisa, Tarsis, Quitim huan Dodanim. ");
INSERT INTO nheBl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Huan iixhuihua Jafet teipa momiyaquilijque huan mocajque nechca hueyi atl ipan campa hueli tlaltini campa camatiyayaj ica sese inintlajtol. ");
INSERT INTO nheBl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Itelpocahua Cam elque: Cus, Mizraim, Fut huan Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Itelpocahua Cus elque: Seba, Havila, Sabta, Raama huan Sabteca. Itelpocahua Raama elque: Seba huan Dedán. ");
INSERT INTO nheBl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Huan Cus nojquiya elqui itata Nimrod tlen quipixqui miyac chicahualistli campa hueli ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nochi tlacame quitocajmatiyayaj Nimrod huan quimatiyayaj para ica itlapalehuil TOTECO elqui se cuali tlapejquetl. Yeca quema tlacame quihueyitlaliyayaj se tlacatl, quiijtosquíaj: “yajaya itztoc queja Nimrod, se cuali tlapejquetl ica itlapalehuil TOTECO.” ");
INSERT INTO nheBl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nopa achtohui altepetini tlen moscaltijque ipan itlanahuatil Nimrod elqui Babel, Erec, Acad huan Calne ipan tlali Sinar. ");
INSERT INTO nheBl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Huan itlanahuatil Nimrod pejqui ipan tlali Sinar huan momoyajqui hasta tlali Asiria. Yajaya quichijqui nopa altepetini tlen itoca Nínive, Rehobot huan Cala. ");
INSERT INTO nheBl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Huan quichijqui Resén tlen eltoya tlatlajco nopa hueyi altepetl Nínive huan Cala. ");
INSERT INTO nheBl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Huan Mizraim elqui inintata: Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO nheBl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Caftorim huan Casluhim tlen elqui ininhueyi tata nopa filisteos. ");
INSERT INTO nheBl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Huan Canaán elqui itata iachtohui ejca tlen itoca: Sidón huan quipixqui se iteipa ejca tlen itoca eliyaya Het. ");
INSERT INTO nheBl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Huan Canaán nojquiya itztoya ininhuejcapan tata nopa tlacame: jebuseos, amorreos, gergeseos, ");
INSERT INTO nheBl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveos, araceos, sineos, ");
INSERT INTO nheBl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeos, zemareos huan hamateos. Teipa nochi ni tlacame tlen eliyayaj iteipa ixhuihua Canaán momoyajque campa hueli. ");
INSERT INTO nheBl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Inintlal elqui tlen tlali Sidón hasta nopa piltlaltzi tlen itoca Gaza tlen eltoya ipan ojtli para Gerar. Huan neca campa quisa tonati inintlal yajqui hasta altepetl Lasa ipan ojtli para nopa altepetini Sodoma, Gomorra, Adma huan Zeboim. ");
INSERT INTO nheBl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nochi ya ni elque iteipa ixhuihua Cam. Huan nica ijcuilijtoc inintoca ininfamilias, huan inintlajtol tlen sesen camatiyayaj. Huan ijcuilijtoc iniestados huan inintlal ipan tlen sese itztoya. ");
INSERT INTO nheBl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Huan Sem elqui ininhueyi tata Heber huan iconehua. Sem elqui tlen achtohui tlacatqui tlen inana huan teipa tlacatqui iicni Jafet. ");
INSERT INTO nheBl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Huan Sem quinpixqui itelpocahua tlen inintoca eliyayaj: Elam, Asur, Arfaxad, Lud huan Aram. ");
INSERT INTO nheBl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Itelpocahua Aram elque: Uz, Hul, Geter huan Mas. ");
INSERT INTO nheBl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Huan Arfaxad elqui itata Sala, huan Sala elqui itata Heber. ");
INSERT INTO nheBl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Teipa Heber quinpixqui ome itelpocahua: Se motocajtiyaya Peleg. (Peleg quinequi quiijtos Motlajcoitac.) Queja nopa itoca pampa ipan nopa tonali tlaltepactli motlajcoitac. Huan iicni Peleg motocajtiyaya Joctán. ");
INSERT INTO nheBl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Huan Joctán elqui itata: Almodad, Selef, Hazar Mavet, Jera, ");
INSERT INTO nheBl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO nheBl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO nheBl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila huan Jobab. Nochi ya ni itztoyaj iconehua Joctán. ");
INSERT INTO nheBl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Huan iteipa ixhuihua Joctán itztoyaj ipan nopa tlali tlatlajco Mesa huan nopa tepetini campa quisa tonati imelac Sefar. ");
INSERT INTO nheBl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nochi ya ni elque iteipa ixhuihua Sem ica sese ininhuejhueyi familias, huan sese inintlajtol, huan sese ininpiltlal huan nochi nopa tlaltini ica sese inintlanahuatijca campa mocahuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Huajca ni tlen nimitzpohuilijtoc eltoya inintoca itlayacanca teipa ixhuihua Noé. Huan sese inijuanti mochijqui se hueyi familia ica iniixhuihua teipa ehuani. Nojquiya nica quiijtohua nopa tlaltini campa mocajque. Huan quema panotoya nopa miyac atl, nochi xinachtli tlen tlacame quisque tlen iixhuihua Noé huan campa hueli momoyajque ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ipan nopa tonali nochi tlacame tlen itztoyaj ipan tlaltepactli quipixque san se inintlajtol huan camatiyayaj san se. ");
INSERT INTO nheBl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Huan quema tlacame pejque momoyahuaj, miyac yajque para campa quisa tonati. Nepa quipantijque se tlamayamitl ipan tlali Sinar huan nopano nelía miyac tlacame mocajque huan ayoc quinejque momoyahuase. ");
INSERT INTO nheBl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Huan se tonal inijuanti moilhuijque se ica seyoc: “Xihualaca ma tijchihuaca se hueyi altepetl huan se torre tlen ajsis hasta elhuicac. Huan queja ni nochi techixmatise huan ax monequis timoxelose huan tiyase campa hueli ipan tlaltepactli. Ma tijchihuaca ladrillos huan ma tiquicxitica cuali ipan tlitl.” Huan quitequihuijque soquitl ladrillos huan ax tetl huan quitequihuijque chapopojtli para quitlatzquiltise huan ax soquitl. ");
INSERT INTO nheBl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pero TOTECO temoc huan quiitaco nopa altepetl huan nopa torre tlen nopa tlacame quisencahuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Huan yajaya moilhui: “Nopa tlacame itztoque san sejco huan san se inintlajtol. Yeca ni tlamantli tlen ama quichihuaj san ipejya tlen san sejco hueli quichihuase. Teipa huelis quisencahuase san tlen inijuanti quinequise. ");
INSERT INTO nheBl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Achi más cuali titemose para tiquinpatilise inintlajtol para ayoc ma quimachilica tlen mocamahuise.” ");
INSERT INTO nheBl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Huajca queja nopa TOTECO quichijqui huan yeca quiquetzqui inintequi huan ayoc quichijque nopa altepetl. Queja nopa TOTECO quinsemanqui nopa tlacame campa hueli ipan tlaltepactli para ma momoyahuaca queja ya quinequiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Huan nopa lugar itoca elqui Babel. (Babel quinequi quiijtos Campa Ax Huelque Momachilíaj Se Ica Seyoc.) Queja nopa itoca pampa nopano TOTECO quipatlac inintlajtol nochi tlacame tlen itztoyaj ipan ni tlaltepactli para ayoc huelque momachilíaj. Huan tlen nopano TOTECO quinsemanqui campa hueli ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ya ni eltoc inintoca iteipa ixhuihua Sem. Tlanqui nopa miyac atl huan ome xihuitl teipa quema Sem quipiyayaya 100 xihuitl, tlacatqui ioquichpil Arfaxad. ");
INSERT INTO nheBl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Teipa Sem noja itztoya seyoc 500 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Huan quema Arfaxad quipixqui 35 xihuitl, tlacatqui ioquichpil Sala. ");
INSERT INTO nheBl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Teipa Arfaxad noja itztoya seyoc 403 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala quipiyayaya 30 xihuitl quema tlacatqui ioquichpil Heber. ");
INSERT INTO nheBl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Huan teipa Sala noja itztoya seyoc 403 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heber quipiyayaya 34 xihuitl quema tlacatqui ioquichpil tlen itoca Peleg. ");
INSERT INTO nheBl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Teipa Heber noja itztoya seyoc 430 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Huan quema Peleg quipixqui 30 xihuitl, tlacatqui ioquichpil Reu. ");
INSERT INTO nheBl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Huan teipa Peleg noja itztoya seyoc 209 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu quipiyayaya 32 xihuitl quema tlacatqui ioquichpil Serug. ");
INSERT INTO nheBl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Teipa Reu noja itztoya seyoc 206 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Huan quema Serug quipixqui 30 xihuitl, tlacatqui ioquichpil Nacor. ");
INSERT INTO nheBl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Huan teipa Serug noja itztoya seyoc 200 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacor quipiyayaya 29 xihuitl quema tlacatqui ioquichpil Taré. ");
INSERT INTO nheBl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teipa Nacor noja itztoya seyoc 119 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Huan Taré ya quipixtoya 70 xihuitl quema tlacatque ioquichpilhua Abram, Nacor huan Harán. ");
INSERT INTO nheBl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ama ya ni inintoca iteipa ixhuihua Taré. Taré elqui itata Abram, Nacor huan Harán. Huan teipa Harán elqui itata Lot. ");
INSERT INTO nheBl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Huan Harán nojquiya quinpixqui ome iichpocahua. Se itoca Isca huan ne se itoca Milca. Pero Harán mijqui quema aya miquiyaya itata huan quema nochi inijuanti noja mocahuayayaj para itztose nopano campa tlacatque ipan nopa altepetl itoca Ur ipan nopa tlali campa itztoyaj nopa caldeos. ");
INSERT INTO nheBl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Huan Abram mosihuajti ihuaya Sarai. Huan Nacor mosihuajti ihuaya imachcone, Milca, tlen elqui iichpoca Harán. ");
INSERT INTO nheBl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Huan Sarai ax hueliyaya quinpiya coneme. ");
INSERT INTO nheBl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taré itztoya ipan altepetl Ur ipan nopa tlali campa itztoyaj nopa caldeos huan quisqui para yasquía tlali Canaán. Huan Taré quinhuicac itelpoca, Abram, huan iyex, Sarai, huan iixhui, Lot, tlen eliyaya itelpoca nopa mijcatzi Harán. Pero quema inijuanti ajsitoj ipan altepetl Harán, mocajque nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Huan nopano mijqui Taré quema quipiyayaya 205 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","TOTECO ya quiilhuijtoya Abram: “Xijcajtehua motlal, huan moteixmatcahua huan ichaj motata. Huan xiya hasta se tlali tlen nimitznextilis. ");
INSERT INTO nheBl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Huan nimitzmacas miyac moixhuihua, huan niquinmiyaquilis moteipa ixhuihua hasta elise tlahuel miyac tlacame ipan inintlal. Nimitztiochihuas huan nijchihuas para campa hueli nochi ma mitzixmatise. Huan tielis se tlatiochihualistli para sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Niquintiochihuas inijuanti tlen mitztiochihuase. Huan inijuanti tlen mitztelchihuase, niquintelchihuas. Huan niquintiochihuas nochi tlacame ipan tlaltepactli ipan ta.” ");
INSERT INTO nheBl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Huajca Abram quisqui queja TOTECO quinahuatijtoya huan quipiyayaya 75 xihuitl quema quisqui altepetl Harán para yas tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Huan quihuicac isihua Sarai huan imachcone Lot. Nojquiya Abram quihuicac nochi nopa miyac tlamantli huan tlapiyalime tlen quinpiyayaya huan nochi itlatequipanojcahua tlen hualajtoyaj ihuaya tlen altepetl Harán pampa quincojtoya para iaxcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Huan quema inijuanti ajsitoj tlali Canaán, Abram quipanoc nopa tlali hasta ajsitoj campa eltoc nopa hueyi ahua cuahuitl tlen itoca More nechca altepetl Siquem. Ipan nopa tonali itztoyaj cananeos ipan nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Huan nopano TOTECO monexti ica Abram huan quiilhui: “Ni tlali niquinmacas moteipa ixhuihua.” Huajca Abram quichijqui se tlaixpamitl nopano para TOTECO tlen monextijtoya ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Teipa yajqui itztoti campa tepeco tlatlajco altepetl Betel huan campa quisa tonati huan nopano quiquetzqui ichaj tlen yoyomitl. Altepetl Betel mocahuayaya ica iarraves para campa temo tonati. Huan altepetl Hai mocajqui ica inejmatl para campa quisa tonati. Huan nopano Abram quichijqui seyoc tlaixpamitl huan quihueyichijqui TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Teipa sampa pejqui nejnemi hasta nopa tlali tlen itoca Neguev. ");
INSERT INTO nheBl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ipan nopa tonali ax oncayaya tlacualistli ipan nopa tlali pampa ax tlaahuetztoya. Huajca Abram yajqui para itztoti ipan tlali Egipto para se ome xihuitl, pampa nelía ax tleno oncayaya para quicuase campa itztoyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Huan quema ajsitiyohuiyayaj Egipto, Abram quiilhui isihua Sarai: “Xiquita, cuali nijmati para nelía tiyejyectzi, ");
INSERT INTO nheBl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","huan quema nopa egiptome mitzitase, quiijtose: ‘Ni sihuatl, ya isihua ni tlacatl. Huajca ma tijmictica huan nopa sihuatl elis toaxca.’ ");
INSERT INTO nheBl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Yeca para ma ax tleno nopantis, xiquijtos para tinoicni. Queja nopa techselise ica yejyectzi mopampa ta, huan ax nimiquis.” ");
INSERT INTO nheBl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Huajca queja nopa mocajque huan quema ajsitoj tlali Egipto, nopa egiptome quiitaque para Sarai eliyaya nelyejyectzi. ");
INSERT INTO nheBl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Huan nojquiya quiitaque nopa huejhueyi tlacame tlen itztoyaj ichaj nopa hueyi Tlanahuatijquetl Faraón huan quiilhuitoj nopa tlanahuatijquetl para nopa sihuatl eliyaya nelyejyectzi. Huajca Faraón quinnahuati ma quihuicaca ichaj para quicualtlalis para teipa elis isihua. ");
INSERT INTO nheBl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Huan pampa quiixtocac Sarai, Faraón quiseli Abram ica cuali. Huan Faraón quimacac Abram borregojme, huacaxme, burrojme, camellos huan tlatequipanohuani tlen tlacame huan sihuame para ma elise iaxcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pero TOTECO quitlatzacuilti nopa Faraón ininhuaya nochi tlen itztoyaj ipan ichaj ica cocolistli tlen más fiero pampa Sarai itztoya ipan ichaj. ");
INSERT INTO nheBl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yeca nopa Faraón quinotzqui Abram iixtla huan quiajhuac. Quiilhui: “¿Para tlen techchihuilijtoc ni tlamantli? ¿Para tlen ax techilhui para ni sihuatl eliyaya mosihua? ");
INSERT INTO nheBl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ta tiquijto para ya moicni huan yeca nimocuili para nosihua. Xiquita, nica itztoc. ¡Xijhuica huan ya xiya!” ");
INSERT INTO nheBl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Huajca nopa Faraón quinnahuati itlacajhua ma quicahuilica Abram ma quisa ipan nopa tlali ihuaya isihua huan ica nochi tlen quipixtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Huajca Abram quisqui tlali Egipto ihuaya isihua, huan ihuaya Lot huan ica nochi tlen quipixtoyaj. Huan nejnenque para norte huan sampa calajque ipan nopa tlali Canaán ipan nopa tlahuel huactoc tlali tlen itoca Neguev. ");
INSERT INTO nheBl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Huan Abram nelía moricojchijtoya. Quipiyayaya miyac oro, plata huan tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Quema quisque Neguev, yajque ica iyolic huan ajsitoj campa nopa pilaltepetzi Betel. Huan teipa ajsitoj campa mocajtoyaj achtohui, tlatlajco Betel huan Hai. ");
INSERT INTO nheBl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nopano eliyaya campa quichijtoya se tlaixpamitl. Huan nopano sampa quihueyichijqui TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Huan Lot tlen nemiyaya ihuaya Abram nojquiya moricojchijtoya. Quipixqui san se imiyaca tlapiyalime queja itlayi Abram. Quinpixqui miyac borregojme, chivojme, huacaxme huan miyac tlatequipanohuani tlen itztoyaj ipan miyac caltini tlen yoyomitl. ");
INSERT INTO nheBl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Huan nopa tlali campa mocahuayayaj Abram huan Lot ax quinaxiliyaya para quintlamacase nochi inintlapiyalhua. Huan yeca ayoc hueliyaya itztoque san sejco pampa nelmiyac itztoyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Huan itlatequipanojcahua Abram tlen quinmocuitlahuiyayaj itlapiyalhua motehuiyayaj ininhuaya tlen quinmocuitlahuiyayaj Lot itlapiyalhua. Huan ipan nopa tonali nojquiya itztoyaj cananeos huan ferezeos campa inijuanti huan eliyayaj mahuilili. ");
INSERT INTO nheBl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Huajca se tonal Abram quiilhui Lot: “Tojuanti tiicnime. Ax cuali para motlatequipanojcahua ma monajnanquilica ihuaya notlatequipanojcahua huan pehuas timocualanise tiome. ");
INSERT INTO nheBl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ma timoxeloca. Xiquita, nopano eltoc nochi ni tlali para tijtlapejpenis campa tijnequis. Intla tijnequi tiyas nepa ica tonejmatl, huajca na niyas ica toarraves. Huan intla tiyas ica toarraves, huajca na niyas ica tonejmatl.” ");
INSERT INTO nheBl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Huan Lot quitlajtlachili nochi nopa yejyectzi tlali tlen nopa atemitl Jordán hasta nopa pilaltepetzi Zoar. Quiitac para quipiyayaya miyac atl huan eliyaya queja se xochimili. Nesiyaya tlahuel yejyectzi queja nopa tlali Egipto. Ya ni panoc quema TOTECO aya quitlamiltiyaya nopa altepetini Sodoma huan Gomorra. ");
INSERT INTO nheBl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Huajca Lot quitlapejpeni nochi nopa tlamayamitl nechca atemitl Jordán huan yajqui para campa quisa tonati. Queja ni moxelojque Abram huan Lot. ");
INSERT INTO nheBl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Huajca Abram mocajqui ipan tlali Canaán huan Lot yajqui itztoti ipan nopa altepetini campa tlamayamitl. Huan Lot iyolic quiijcuenijtiyajqui ichaj tlen yoyomitl hasta ajsito campa nopa altepetl Sodoma ");
INSERT INTO nheBl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","campa tlacame quipixque ininyolis tlahuel fiero. Tlahuel tlajtlacolchihuayayaj iixpa TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Teipa quema Lot ya quistoya, TOTECO quiilhui Abram: “Abram, xitlachiya huejca ica norte huan ica sur, huan ica campa quisa tonati huan ica campa ontemo. ");
INSERT INTO nheBl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nochi ni tlali tlen hueli tiquita, na nimitzmacas. Huan para nochipa elis moaxca huan iniaxca moteipa ixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nijchihuas ma elica tlahuel miyac moteipa ixhuihua queja imiyaca tlaltejpoctli. Huan intla se huelisquía quipohuasquía tlaltejpoctli, nojquiya huelis quinpohuasquía nochi moteipa ixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Huajca ximoquetza, xinejnemi huan xijtlachiliti ihuehueyaca huan ipatlajca, pampa na nimitzmacas.” ");
INSERT INTO nheBl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Huajca Abram quitlalanqui ichaj tlen yoyomitl huan quiquetzqui hasta campa oncayaya miyac ahua cuatini tlen eltoya iaxca se tlacatl tlen itoca Mamre nechca altepetl Hebrón. Huan nopano Abram quichijqui se tlaixpamitl para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","4","Para 12 xihuitl nopa Tlanahuatijquetl Quedorlaomer tlen tlali Elam quinfuerzajhuiyaya macuilti tlanahuatiani huan inintlacajhua ma quitequipanoca, pero ipan nopa 13 xihuitl, nopa macuilti tlanahuatiani quinyolaxitijque huan mosisinijque. Huajca mosentilijque ipan nopa tlamayamitl Sidim nopa macuilti tlanahuatiani tlen inintoca Tlanahuatijquetl Bera tlen altepetl Sodoma, Tlanahuatijquetl Birsa tlen altepetl Gomorra, Tlanahuatijquetl Sinab tlen altepetl Adma, Tlanahuatijquetl Semeber tlen altepetl Zeboim huan seyoc tlen elqui tlanahuatijquetl tlen altepetl Bela tlen nojquiya itoca Zoar. Sidim campa mosentilijque mocahua tlatlajco tepetini nechca campa eltoc nopa Hueyi Atl Tlen Mictoc. Mosentilijque para momanahuise tlen Quedorlaomer para ayoc monequi quitequipanose. Huan seyoc eyi tlanahuatiani mosentilijque ihuaya Quedorlaomer para quipalehuise tlatehuise. Ni eyi elque Tlanahuatijquetl Amrafel tlen altepetl Sinar, Tlanahuatijquetl Arioc tlen altepetl Elasar huan Tlanahuatijquetl Tidal tlen altepetl Goim. ");
INSERT INTO nheBl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Huajca ipan nopa 14 xihuitl, Quedorlaomer huan eyi tlanahuatiani tlen quipalehuiyayaj quisque huan nimantzi quintlanque nopa refaitame ipan tlali Astarot Karnaim, huan nopa zuzitame ipan tlali Ham huan nopa emitame ipan Save Quiriataim. ");
INSERT INTO nheBl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Huan quintojtocatiyajque nopa horeos campa nopa cuatitlamitl Seir hasta nopa tlamaya ipan tlali Parán tlen eltoc nechca nopa huactoc tlali campa ax tleno eli. Nochi ni tlacame nopa Quedorlaomer quintlanqui. ");
INSERT INTO nheBl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Huan quema mocuepayayaj Quedorlaomer huan tlen ihuaya itztoyaj, ajsitoj ipan tlali En Mispat tlen nojquiya itoca Cades. Huan quintlanque nochi nopa amalecitame huan amorreos tlen itztoyaj ipan nopa altepetl Hazezon Tamar. ");
INSERT INTO nheBl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Huajca nopa macuilti tlanahuatiani tlen altepetini Sodoma, Gomorra, Adma, Zeboim huan Bela o Zoar yajque ipan nopa tlamayamitl itoca Sidim huan mocualtlalijque para motehuise ininhuaya nopa nahui tlanahuatiani tlen eliyaya Tlanahuatijquetl Quedorlaomer tlen tlali Elam, huan ihuampoyohua tlen inintoca: Tlanahuatijquetl Tidal tlen altepetl Goim, Tlanahuatijquetl Amrafel tlen altepetl Sinar huan Tlanahuatijquetl Arioc tlen altepetl Elasar. ");
INSERT INTO nheBl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Pero nopa macuilti ax huelque tlatlanij. Huan ipan tlamayamitl Sidim oncayaya miyac tlacoyoctli ica chapopojtli. Huajca quema nopa tlanahuatiani tlen Sodoma huan Gomorra huan ininhuampoyohua quinequiyayaj cholose ipan nopa tlatehuilistli sequin inijuanti huetzque ipan nopa tlacoyoctli huan sequinoc cholojque campa tepetini. ");
INSERT INTO nheBl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Huajca tlatlanqui Quedorlaomer huan ihuampoyohua. Huan quicuique nochi tlacualistli huan tlamantli tlen ipati tlen oncayaya ipan altepetini Sodoma huan Gomorra huan quistejque. ");
INSERT INTO nheBl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Huan pampa Lot, imachcone Abram, itztoya ipan altepetl Sodoma, nojquiya quihuicaque ilpitoc ica nochi tlen quipixtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Pero cholo se tlacatl huan quipohuilico Abram, nopa hebreo tlacatl quema mocahuayaya ipan iahuamil se amorreo tlacatl tlen itoca Mamre. Mamre eliyaya iicni Escol huan Aner tlen nojquiya quimapalehuiyayaj Abram. ");
INSERT INTO nheBl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Huajca quema Abram quimatqui para imachcone Lot quihuicatoyaj ilpitoc, quinsentili 318 itlatequipanojcahua tlen tlacajtoyaj ipan ichaj, huan momachtijtoyaj tlatehuise huan yajque para quipantitij Quedorlaomer huan quimanahuise Lot. Huan quintepotztocaque hasta nopa pilaltepetzi tlen itoca Dan. ");
INSERT INTO nheBl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Huan ica tlayohua Abram quinpanti huan quintlajcoitac itlatequipanojcahua huan quinyahualojque huan pejque quintehuíaj quema ax quinchiyayayaj. Huan quintehuijtiyajque hasta altepetl Hoba tlen mocahua ica norte tlen altepetl Damasco. ");
INSERT INTO nheBl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Huan Abram quintlanqui, huan quimanahui imachcone, Lot, huan nopa sequinoc tlacame huan sihuame tlen quinhuicatoyaj. Huan quincuili nochi tlen quiixtectoyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Huan quema Abram ya quitlantoya Quedorlaomer huan tlen quipalehuiyayaj, mocuepqui ipan ojtli para ichaj. Huan ipan nopa tlamayamitl tlatlajco tepetini campa itoca Save o Inintlamaya Tlanahuatiani, hualajqui quinamiquico nopa tlanahuatijquetl tlen altepetl Sodoma. ");
INSERT INTO nheBl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Huan nojquiya hualajqui quinamiquico Melquisedec, nopa tlanahuatijquetl tlen altepetl Salem 14:18 Salem teipa motocajtis Jerusalén.. Yajaya nojquiya eliyaya Itotajtzi Toteco Tlen Más Hueyi. Huan Melquisedec quinmacac Abram huan itlatequipanojcahua pantzi huan xocomeca atl. ");
INSERT INTO nheBl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Huan quitiochijqui Abram ica ni tlajtoli: “Abram, ma mitztiochihua Toteco Tlen Más Hueyi, yajaya tlen quichijqui elhuicactli huan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Quena, ma tijhueyichihuaca Toteco Tlen Más Hueyi, pampa quichijqui xiquintlani mocualancaitacahua.” Huajca Abram quimacac Melquisedec se diezmo tlen nochi tlen quitlantoya. ");
INSERT INTO nheBl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Teipa nopa tlanahuatijquetl tlen Sodoma quiilhui Abram: ―San xinechmactili nopa tlacame tlen ehuaj noaltepe tlen tiquinmanahuijtoc huan ximocahui nochi tlamantzitzi tlen eliyaya iniaxca. ");
INSERT INTO nheBl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Pero Abram quinanquili: ―Niquilhuijtoc TOTECO tlen quichijqui elhuicactli huan tlaltepactli, ");
INSERT INTO nheBl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","para ax tleno nijselis tlen eltoya imoaxca. Ax nijcuis niyon se icpatl, niyon se lazo tlen ica nimotecac ilpis para ax quema huelis tiquijtos tinechricojchijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ax tleno nijnequi para na. San tijselise tlen quicuajque notlatequipanojcahua. Pero nopa tlacame tlen yajque nohuaya, Aner, Escol huan Mamre, xiquincahuili ma quicuica tlen quintocarohua. ");
INSERT INTO nheBl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Teipa TOTECO quinotzqui Abram ipan se tlanextili tlen elqui queja se temictli huan quiilhui: “Amo ximajmahui, Abram, pampa na nimitzmocuitlahuis. Motlaxtlahuil elis nelhueyi.” ");
INSERT INTO nheBl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Pero Abram quinanquili: ―TOTECO, Ta Tlen Más Tijpiya Tlanahuatili, san tlapic para tinechmacas miyac tlamantli pampa ax nijpiya se conetl para nijcahuilijtehuas. Ax tinechmacatoc niyon se nocone. Huan notlatequipanojca Eliezer tlen ehua altepetl Damasco quiselis nochi tlen nijpiya quema nimiquis. ");
INSERT INTO nheBl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Huan TOTECO quinanquili: ―Ax yaja quiselis tlen tijcajtehuas. Elis se mocone tlen quiselis tlen tijpiyas teipa huan quipiyas ta moeso. ");
INSERT INTO nheBl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Huajca TOTECO quihuicac Abram calteno huan quiilhui: ―Xijtlachili elhuicac huan xijchihua fuerza xiquinpohua nopa sitlalime. Queja nopa elis ininmiyaca moteipa ixhuihua. Itztose tlahuel miyac hasta axaca huelis quinpohuas. ");
INSERT INTO nheBl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Huajca Abram quineltocac tlen TOTECO quiijto huan TOTECO quiijcuilo nepa elhuicac para Abram itztoya xitlahuac iixpa. ");
INSERT INTO nheBl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Huan TOTECO quiilhui: ―Na nimoTECO. Nimitzhualicac tlen altepetl Ur campa itztoque nopa caldeos para nimitzmacas ni tlali para timoaxcatis. ");
INSERT INTO nheBl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Pero Abram quiilhui: ―TOTECO Tlen Más Tijpiya Tlanahuatili, ¿quejatza huelis nijmatis intla melahuac nijselis ni tlali? ");
INSERT INTO nheBl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Huan Toteco Dios quinanquili: ―Xinechhualiquili se becerra, se chivo huan se oquich borrego tlen quipiyaj eyi xihuitl. Nojquiya xinechhualiquili se pichontzi huan se paloma. ");
INSERT INTO nheBl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Huajca Abram quihualiquili Toteco Dios nochi ni tlapiyalime. Quinmicti, huan quintlajcoitac huan quinijixnamicti, pero nopa totome ax quintlajcoitac. ");
INSERT INTO nheBl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Huan tzopilome temoyayaj ipan nopa tlapiyalime tlen mictoyaj, pero Abram quinmajmatiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Huan quema ya tlatlayohuatoya, Abram nelcochqui huan quimatqui para hualajqui ipan ya se tzintlayohuilotl huan tlahuel majmahuiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Huajca TOTECO quiilhui: ―Moteipa ixhuihua yase itztotij ipan seyoc tlali queja sejcoyoc ehuani. Huan tlacame tlen nopano ehuaj quintequihuise chicahuac huan quinitase queja iniaxcahua huan nopano moteipa ixhuihua tlaijiyohuise para 400 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pero teipa na nijtlatzacuiltis nopa tlali huan itlacajhua tlen quintequihuise. Huan moteipa ixhuihua quisase ica miyac tlamantli tlen tlahuel ipati. ");
INSERT INTO nheBl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pero ta timiquis quema ya tihuehuejtitos, quema noja oncas tlasehuilistli. Mitztlalpachose quema aya ajsitos nopa tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nopano ipan nopa tlali mocahuase hasta miquise moteipa ixhuihua tlen achtohui calajque ipan nopa tlali. Mocahuase hasta miquise ininconehua, huan iniixhuihua huan ininconehua iniixhuihua. Huan huajca quena, nopa tlacame huan ininconehua mocuepase sampa nica ipan ni tlali. Pero para amantzi aya ajsi tonali para hualase pampa aya tlahuel fiero quichihuaj nopa amorreos tlen ama itztoque nica ipan ni tlali. Huajca aya ajsi nopa tonali para niquintlatzacuiltis queja nijchihuas teipa ipan nopa tonali quema mocuepase moteipa ixhuihua nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Huan quema ya temotoya tonati huan nochi ya tzintlayohuatoya, nesqui queja se comitl tlen quipixtoya tlilelemectli huan popocayaya. Huan nopa comitl panoc tlatlajco campa nopa tlapiyalime tlen Abram quintejtectoya. ");
INSERT INTO nheBl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Huan queja nopa ipan nopa tonal, TOTECO quicajqui itlajtol ihuaya Abram huan quiilhui: ―Nochi ni tlali niquinmacas moteipa ixhuihua. Quiselise nochi ni tlali tlen campa pehua ica nopa hueyi atemitl ipan tlali Egipto ica campa temo tonati huan noja quiselise hasta nopa hueyi atemitl tlen itoca Éufrates campa quisa tonati. ");
INSERT INTO nheBl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Nochi ni tlali elis iniaxca campa ama mocahuaj tlacame ceneos, cenezeos, cadmoneos, ");
INSERT INTO nheBl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","heteos, ferezeos, refaitame, ");
INSERT INTO nheBl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreos, cananeos, gergeseos huan jebuseos. Nochi elis iniaxca moteipa ixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, isihua Abram, ax huelqui conepiya, pero quipiyayaya se itlatequipanojca tlen tlali Egipto tlen itoca Agar. ");
INSERT INTO nheBl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Huajca Sarai moilhui quichihuas queja momajtoyaj quichihuaj ipan nopa tonali huan quimactilis ihuehue itlatequipanojca. Yeca quiilhui Abram: ―Xiquita, TOTECO ax nechcahuilijtoc ma niconepiyas, huajca xicochi ihuaya notlatequipanojca Agar para yajaya huelis quinpiyas coneme tlen elise queja na noconehua. Huan Abram quitlacaquili tlen Sarai quiilhui. ");
INSERT INTO nheBl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Huan Sarai quinotzqui Agar, nopa egipto ejquetl, huan quimactili Abram para ihuaya ma cochi. Quema panoc ya ni, Abram ya quipixqui majtlactli xihuitl para itztoc ipan tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Huan Abram quiixmatqui Agar, huan Agar conecuic. Huan quema Agar momacac cuenta para ya conepiya, mohueyimatqui huan pejqui quicualancaita Sarai. ");
INSERT INTO nheBl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Huajca Sarai quiilhui Abram: ―Ta motlajtlacol para nechcualancaita Agar. Na nimitzmactili para ihuaya ximoteca, pero quema quimatqui para conepiyas, mohueyimatqui. Ma TOTECO quiijto ajqueya quipiya tlajtlacoli, intla ta o na. ");
INSERT INTO nheBl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Huan Abram quinanquili: ―Xiquita, Sarai, motlatequipanojca Agar itztoc momaco para tijtlatzacuiltis queja tiquitas cuali. Huajca Sarai pejqui quitlaijiyohuiltía Agar, huan yeca Agar cholojtejqui. ");
INSERT INTO nheBl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Pero ielhuicac ejca TOTECO quipanti Agar campa meyayaya atl ipan nopa huactoc tlali campa ax tleno eli. Itztoya ipan nopa ojtli tlen yohui para Shur. ");
INSERT INTO nheBl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Huan ielhuicac ejca TOTECO quitlajtlani: ―Agar, tiitlatequipanojca Sarai, ¿canque tihuala huan canque tiya? Huan Agar quinanquili: ―Nicholohua imaco noteco, Sarai. ");
INSERT INTO nheBl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Huajca ielhuicac ejca TOTECO quiilhui: ―Ximocuepa campa moteco huan xijneltoquili nochi tlen mitznahuatis. ");
INSERT INTO nheBl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Huan nojquiya ielhuicac ejca TOTECO quiilhui: “Na niquinmiyaquilis moteipa ixhuihua hasta axaca huelis quinpohuas. ");
INSERT INTO nheBl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ya ticonecuitoc huan tijpiyas se oquichpil huan tijtocajtis Ismael, pampa TOTECO quicajqui quema timocuesohuayaya. (Ismael quinequi quiijtos TOTECO Tlacaqui.) ");
INSERT INTO nheBl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Huan mocone elis se tlacatl tlen mosisinía. Motehuis ininhuaya nochi, huan nochi quinequise quitehuise. Huan yajaya itztos ica cualantli mojmostla ica nochi iicnihua.” ");
INSERT INTO nheBl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Huan Agar quitocajtlali TOTECO tlen ihuaya mocamahuijtoya “yaja Toteco Dios Tlen Nochi Quiita”. Queja nopa quitocajti pampa moilhuiyaya: “Niquitztoc Toteco Dios tlen nechita huan noja niitztoc.” ");
INSERT INTO nheBl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Huan yeca nopa ameli tlen mocahua tlatlajco Cades huan Bered ama quitocajtijtoque Beer Lahai Roi. (Ya ni quinequi quiijtos Iamel Yajaya Tlen Itztoc Huan Tlen Nechita.) ");
INSERT INTO nheBl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Huan Agar quitlacatilti icone Abram, huan Abram quitocajti Ismael. ");
INSERT INTO nheBl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Huan Abram quipiyayaya 86 xihuitl quema tlacatqui Ismael. ");
INSERT INTO nheBl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Huan quema Abram quipiyayaya 99 xihuitl, Toteco Tlen Quipiya Nochi Chicahualistli monexti campa ya huan quiilhui: ―Na nimoTeco Tlen Nijpiya Nochi Chicahualistli. Ximotemachi ipan na huan xijchihua san tlen xitlahuac noixtla. ");
INSERT INTO nheBl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Huan na nijcahuas notlajtol mohuaya para temachtli nijchihuas para tiquinpiyas tlahuel miyac moteipa ixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Huan Abram motlancuaquetzqui huan mopacho hasta tlalchi quema Toteco Dios quicamahuiyaya. Huan Toteco Dios nojquiya quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","―Nijcahua notlajtol mohuaya para ta tielis tiinintata tlahuel miyac tlacame tlen itztose ipan tlahuel miyac tlaltini. ");
INSERT INTO nheBl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Huan motoca ayoc elis Abram. (Abram quinequi quiijtos Se Tetat Tlen Nochi Quitlepanitaj.) Ama motoca elis Abraham. (Abraham quinequi quiijtos Inintata Miyac Tlacame Tlen Itztoque Ipan Miyac Tlaltini.) Queja nopa elis motoca pampa nimitzchihuas tiinintata miyac tlacame ipan miyac tlaltini. ");
INSERT INTO nheBl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Quena, nijchihuas para moteipa ixhuihua ma elica nelía miyac. Ipan ta quisase huejhueyi tlanahuatiani tlen quinnahuatise inintlacajhua ipan miyac tlaltini. ");
INSERT INTO nheBl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Huan na nijtlamichihuas nochi tlen nijcajtoc notlajtol para nijchihuas ica ta huan moteipa ixhuihua teipa para nochipa. Ni elis se tlajtolsencahuali tlen ax quema tlamis. Nochipa nielis nimoDios huan niininDios moteipa ixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Huan nochi ni tlali tlen itoca Canaán campa ama tiitztoc, nimitzmacas ta huan moteipa ixhuihua. Huan elis iniaxca para nochipa, huan na nielis niininDios. ");
INSERT INTO nheBl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Huan Toteco Dios sampa quiilhui Abraham: ―Huan ya ni tlen ta huan nochi moteipa ixhuihua monequi xijchihuaca. Monequi xijneltocaca nochi tlen quiijtohua ni tlajtoli tlen nijchihua mohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Huan ya ni nopa tlajtoli tlen monequi xijchihuaca. Monequi nochi oquichpilme huan tlacame ma motequilica queja nimitzilhuía. ");
INSERT INTO nheBl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ma quitzontequilica iyacapa nopa cuetlaxtli ipan ininpiltlacayohua. Ya nopa itoca circuncisión. Huan ya nopa elis nopa tlanextilijcayotl tlen ni tlajtolsencahuali tlen nijchihua imohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Huajca ama monequi ta huan nochi tlacame tlen mitztequipanohuaj, yonque tijcojqui nopa tlacatl para moaxca quema ya hueyi, o quitlacatilti se motlatequipanojca, monequi nochi motequilise. Huan nojquiya monequi inquintequilise nochi imooquichpilhua tlen tlacajtiyase teipa. Xijchihuaca quema quipiyas chicueyi tonati ica tlacajtoc. Queja nopa monequis ica moteipa ixhuihua, huan ininteipa ixhuihua motlatequipanojcahua huan ica nochi tlatequipanohuani tlen tiquincohuas tlen sequinoc tlaltini. ");
INSERT INTO nheBl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Nochi tlacame huan oquichpilme monequi motequilise. Huan queja nopa elis queja inquihuicase se tlanextilijcayotl tlen notlajtol ipan imonacayo huan nopa tlajtoli tlen nijchihua imohuaya huejcahuas para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Huan tlen ax motequilis monequi xijquixtica para ayoc quema itztos ininhuaya motlacajhua pampa ax quitlepanitac nopa tlajtoli tlen nijchijtoc ica imojuanti. ");
INSERT INTO nheBl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nojquiya Toteco Dios quiilhui Abraham: ―Huan mosihua, ayoc elis itoca Sarai. Ama itoca elis Sara. (Sara quinequi quiijtos Iichpoca Se Tlanahuatijquetl.) ");
INSERT INTO nheBl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Huan Sara nijtiochihuas huan temachtli nimitzmacas se mocone ipan ya. Huan yajaya elis ininnana miyac tlacame ipan miyac tlaltini, huan miyac iteipa ixhuihua elise huejhueyi tlanahuatiani. ");
INSERT INTO nheBl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Huan Abraham motlancuaquetzqui huan mopacho tlalchi para quihueyichihuas Toteco Dios, pero yolhuetzcayaya pampa ax quineltocayaya. San moilhuiyaya: “¿Quejatza huelis nijpiyas se conetl quema ya nijpiya 100 xihuitl? Huan ¿quejatza huelis Sara conepiyas quema ya quiaxiti 90 xihuitl?” ");
INSERT INTO nheBl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Huajca Abraham quiilhui Toteco Dios: ―Intla huelis, san xijcahua nooquichpil Ismael ma itztos ica motlatiochihualis. ");
INSERT INTO nheBl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Huan Toteco Dios quinanquili: ―¡Axtle! Ax ya nopa tlen nimitzilhuía. Niquijto mosihua Sara quipiyas se icone tlen tijtocajtis Isaac. Huan ihuaya ya nicompahuis nopa tlajtoli huan ininhuaya iteipa ixhuihua para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Pero nojquiya nijcactoc tlen tinechtlajtlanijtoc para Ismael huan quena, nijtiochihuas. Nijchihuas ma quinpiya miyac iconehua huan para ma momiyaquilica iixhuihua. Huan yajaya elis inintata 12 huejhueyi tlacame. Ica ya huan iteipa ixhuihua niquinchihuas ma elica se xinach tlacame ica miyac itlacajhua huan quipiyase se hueyi tlali. ");
INSERT INTO nheBl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pero nopa tlajtolsencahuali nijchihuas ica Isaac, nopa conetl tlen Sara quitlacatiltis ne se xihuitl, queja ama. ");
INSERT INTO nheBl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Huan quema Toteco Dios tlanqui camati ihuaya Abraham, quistejqui. ");
INSERT INTO nheBl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Huan nimantzi ipan nopa tonal Abraham quitzontequili iyacapa nopa cuetlaxtli ipan ipiltlacayo Ismael. Huan nojquiya quintzontequili inincuetlaxo nochi itlatequipanojcahua tlen tlacajtoyaj ipan ichaj huan nochi tlacame tlen quincojtoya. Quena, nochi tlacame tlen itztoyaj ipan ichaj huan tlen quitequipanohuayayaj motequilijque queja Toteco Dios tlanahuati. ");
INSERT INTO nheBl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Huan Abraham quipiyayaya 99 xihuitl, huan icone, Ismael, quipiyayaya 13 xihuitl quema quintzontequilijque inincuetlaxo. ");
INSERT INTO nheBl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Huajca ipan nopa tonal quema Toteco Dios quicamahui Abraham, Abraham huan icone, Ismael, motequilijque. ");
INSERT INTO nheBl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Huan nojquiya motequilijque nochi nopa itlatequipanojcahua, tlacame huan oquichpilme, tlen itztoyaj ipan ichaj, yonque tlacatque nopano o quincojtoya ipan sequinoc tlaltini. ");
INSERT INTO nheBl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Huan TOTECO monexti campa Abraham quema itztoya ipan nopa ahuatitla campa nopa huejhueyi cuatini tlen iaxca Mamre. Queja ni panoc. Se tonal Abraham mosehuijtoya calteno nechca ichaj tlen yoyomitl ipan nopa hora quema más tlatotoniya. ");
INSERT INTO nheBl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Huan Abraham ajcoitac huan quinitac eyi tlacame ajsitihualayayaj nechca ichaj. Huan quema quinitac, moquetzqui huan motlalo para quinnamiquis huan motlancuaquetzqui huan mopacho hasta tlalchi, ");
INSERT INTO nheBl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","huan quiijto: ―Tatame, xinechchihuilica se favor, xipanoca xitechpaxaloca. ");
INSERT INTO nheBl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Huan intla inquiitaj cuali, nitlajtlanis se quentzi atl para inmoicxipajpacase huan inmosiyajcahuase se quentzi itzintla ni cuahuitl campa tlaecahuía. ");
INSERT INTO nheBl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nojquiya nimechhualiquilis se quentzi tlacualistli para xijpiyaca fuerza huan teipa sampa huelis inyase ipan imoojhui. Para na se paquilistli inhualajtoque huan nijnequi nimechtequipanos intla innechcahuilise. Huan inijuanti quinanquilijque: ―Cualtitoc. ");
INSERT INTO nheBl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Huan Abraham calajqui ipan ichaj tlen yoyomitl huan quiilhui Sara: ―Nimantzi xijcui eyi tlatlamachihuali tlen harina tlen más cuali huan xijchihua pantzi. ");
INSERT INTO nheBl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Teipa Abraham motlalo campa itztoyaj itlapiyalhua huan quitlapejpeni se becerro tlen nelía yejyectzi. Huan quimacac se itlatequipanojca, huan ya nimantzi quisencajqui se tlacualistli. ");
INSERT INTO nheBl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Huan teipa Abraham quinhualiquili mantequilla, lechi huan nopa becerro tlacacatzoli huan quinmacac ma quicuaca. Huan Abraham moquetzqui nechcatzi cuatzintla para quintequipanos quema inijuanti tlacuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Huan quema tlanque tlacuaj, nopa paxalohuani quitlajtlanijque Abraham: ―¿Canque itztoc mosihua Sara? Huan Abraham tlananquili: ―Itztoc nepa calijtic. ");
INSERT INTO nheBl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Huajca se tlen nopa tlacame quiijto: ―Ne se xihuitl queja ama sampa nimitzpaxaloqui, huan mosihua Sara ya quitlacatiltijtos icone. Huan Sara moquetztoya icalixpa, quintlacaquilijtoya tlen camatiyayaj ihuaya Abraham. ");
INSERT INTO nheBl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Huan Abraham huan Sara eliyayaj huehuentzitzi, huan ya panotoya nopa xihuitl para Sara quipiyasquía se icone. ");
INSERT INTO nheBl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Huan yeca ax huelqui moijiyohui para ax huetzcas huan moilhui: “¿Quejatza huelis nijpiyas ni paquilistli ama quema nohuehue huan na ya tihuehuentzitzi?” ");
INSERT INTO nheBl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Pero TOTECO quiilhui Abraham: ―¿Para tlen huetzcac Sara? ¿Para tlen quiijto: ‘Quejatza huelis nijpiyas ni paquilistli ama quema nohuehue huan na ya tihuehuentzitzi?’ ");
INSERT INTO nheBl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Timoilhuía para onca se tlamantli tlen na, nimoTeco Dios, ax hueli nijchihuas? Ne se xihuitl sampa nimechpaxaloqui huan Sara quipixtos icone. ");
INSERT INTO nheBl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Huan quema Sara quicajqui tlen quiijto, majmajqui huan istlacatqui huan quiijto: ―Na ax nihuetzcac. Pero TOTECO quinanquili: ―Na nijmati para tihuetzcac. ");
INSERT INTO nheBl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Teipa nopa paxalohuani moquetzque huan pejque nejnentiyohuij ipan ojtli para altepetl Sodoma. Huan Abraham ininhuaya yajqui para quinnahuatijtehuas. ");
INSERT INTO nheBl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Huajca TOTECO moilhui: “Monequi niquilhuis Abraham tlen nijchihuas, ");
INSERT INTO nheBl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","pampa yajaya elis inintata miyac tlacame huan sihuame tlen mochihuase se hueyi xinach tlacame tlen quipiyase miyac chicahualistli. Huan niquilhuijtoc para niquintiochihuas nochi tlacame ipan nochi tlaltini ipan tlaltepactli ica ya. ");
INSERT INTO nheBl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Na nijtlapejpenijtoc para ma quinnextilis iconehua ma quineltocaca notlamachtil huan ma quichihuaca nochi tlen cuali huan tlen xitlahuac. Huan na niquinchihuilis nochi tlen cuali niquilhuijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Huajca TOTECO quiilhui Abraham: ―Nechyolmelajtoque para nopa tlacame ipan altepetini Sodoma huan Gomorra nelmosisiníaj. Nelfiero ininyolis huan tlahuel miyac inintlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ama niya nepa para niquitas intla nelía inintlajtlacolhua nelhueyi queja nechilhuijtoque. Huan queja nopa nijmatis. ");
INSERT INTO nheBl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Huan ne seyoc ome paxalohuani quisque para Sodoma, pero TOTECO mocajqui ihuaya Abraham. ");
INSERT INTO nheBl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Huan Abraham quinechcahui huan quitlajtlani: ―¿Tiquinpolos tlacame tlen itztoque xitlahuaque ininhuaya tlen tlajtlacolejque? ");
INSERT INTO nheBl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","¿Intla itztoque 50 tlacame tlen cuajcualme ipan nopa altepetl, noja tijtlatzacuiltis nopa altepetl? ¿Ax tijtlapojpolhuis nopa altepetl ipampa nopa 50 tlacame? ");
INSERT INTO nheBl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ax cuali intla tiquinmictis cuajcualme ininhuaya tlen tlahuel tlajtlacolchijtoque pampa queja nopa nesi para nochi ome quipiyaj san se inintlajtlacolhua. ¡Amo xijchihua ya nopa! Ta, tijuez tlen más tihueyi ipan nochi ni tlaltepactli, huan nijmati ta tijchihuas tlen xitlahuac. ");
INSERT INTO nheBl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Huan TOTECO quinanquili: ―Intla niquinpantis 50 tlacame tlen itztoque xitlahuaque ipan nopa altepetl, huajca niquintlapojpolhuis nochi ininpampa nopa 50 tlacame tlen itztoque xitlahuaque. ");
INSERT INTO nheBl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Pero Abraham sampa quiilhui: ―Xinechtlapojpolhui Toteco, intla sampa nimitzcamahuía, pampa ta, tiToteco Dios, huan na san nise tlacatl. ");
INSERT INTO nheBl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Pero nohueli polihuij macuili tlacame para ajsis 50 tlen itztoque xitlahuaque. ¿Tiquinmictis nochi ipan nopa altepetl intla san polihui nopa macuilme? Huan TOTECO quinanquili: ―Intla niquinpantis 45 tlacame tlen xitlahuaque, ax nijpolos nopa altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Huan Abraham sampa quiilhui: ―Pero nohueli san itztoque 40 tlacame tlen xitlahuaque. Huan TOTECO quiijto: ―Intla itztoque 40 tlen xitlahuaque, ax nijtlamiltis nopa altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Pero Abraham sampa quiilhui: ―Nimitztlajtlanía amo xicualani nohuaya pampa nimitztlajtlanía miyac hueltas, pero nohueli tiquinpantis san 30 tlacame tlen itztoque xitlahuaque. Huan Toteco sampa quiilhui: ―Intla itztoque 30 tlacame tlen itztoque xitlahuaque, ax nijpolos nopa altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Huan Abraham noja quitlajtlani: ―Toteco, nijmati para nimitznelcuatotonía pampa nimitznojnotza queja ni, pero ¿tlaque panos intla san 20 tlacame tlen itztoque xitlahuaque tiquinpantis? Huan Toteco quiilhui: ―Intla itztoque 20 tlen xitlahuaque, ax niquinmictis tlen itztoque ipan nopa altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Huan Abraham sampa quitlajtlani: ―NoTeco, amo xicualani nohuaya, pero nimitztlajtlanis san ni huelta: ¿Tlaque tijchihuas intla san majtlactli tlacame tlen itztoque xitlahuaque tiquinpantis? Huan Toteco quiilhui: ―Intla itztoque majtlactli tlacame tlen xitlahuaque, ax nijxolehuas nopa altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Huan quema TOTECO tlanqui camati ihuaya Abraham, quistejqui. Huan Abraham mocuepqui ichaj. ");
INSERT INTO nheBl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Huan quema ya tlayohuayaya nopa ome ielhuicac ehuani ajsitoj altepetl Sodoma. Huan Lot mosehuijtoya nechca ipuerta nopa altepetl campa tlayacanani momajtoyaj mosentilíaj. Huan quema Lot quinitac, moquetztiquisqui para quinnamiquiti huan quinseli ica yejyectzi. Huan motlancuaquetzqui huan mopacho hasta tlalchi, ");
INSERT INTO nheBl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","huan quinilhui: ―Tatame, xinechchihuilica se favor, ximocahuaca ni tlayohua ipan nochaj. Nopano inmoicxipajpacase huan intonilise. Huan mostla cualca huelis sampa inyase ipan imoojhui. Pero quiijtojque: ―¡Axtle! Tlascamati. Tojuanti san ticochise nica calteno ipan calle. ");
INSERT INTO nheBl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pero Lot quinnelchihualti para ma cochica ichaj hasta quiijtojque para quena, huan yajque ichaj. Huan quema ajsitoj, Lot tlanahuati ma quinsencahuilica se cuali tlacualistli ica pantzi tlen ax quipiya tlasonejcayotl. Huan nopa paxalohuani tlacuajque. ");
INSERT INTO nheBl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Huan teipa quema aya motecayayaj, nochi nopa tlacame tlen altepetl Sodoma quiyahualocoj ichaj Lot. Hualajque tlen más telpocame hasta tlen más huehuentzitzi, ");
INSERT INTO nheBl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","huan pejque quitzajtzilíaj Lot: ―¿Canque itztoque nopa tlacame tlen hualajque mochaj ni tlayohua? ¡Xiquinquixti para timotecase ininhuaya! ");
INSERT INTO nheBl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Huajca Lot quisqui calteno para quincamahuis huan cuali quitzajqui nopa puerta iica 19:6 Ipan nopa tonali tlahuel monejqui se tlacatl quinmanahuis ipaxalojcahua intla ya quinselijtoya ipan ichaj.. ");
INSERT INTO nheBl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Huajca Lot quinilhui nopa fiero tlacame: ―Axtle, nohuampoyohua, nimechtlajtlanía amo xijchihuaca nopa tlamantli tlen fiero. ");
INSERT INTO nheBl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Niquinpiya ome noichpocahua tlen aya quiixmajtoque niyon se tlacatl, niquinquixtis huan nimechmacas para xijchihuaca ininhuaya tlen inquinequij, pero ax tleno xiquinchihuilica ni tlacame pampa nopaxalojcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Pero quinanquilijque: ―¡Ximijcueni tisejcoyoc ejquetl! ¿San tiajsico nica huan tijnequi titechnahuatis? ¡Ama timitzchihuilise más fiero que inijuanti! Huan nimantzi pejque quitemajmatíaj Lot huan monechcahuijque campa puerta para quicuamajcahuase. ");
INSERT INTO nheBl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pero ipaxalojcahua quitlapojque cuapuerta huan nimantzi quiitzquijque Lot huan quicalaquijque calijtic. Teipa sampa quitzajque puerta. ");
INSERT INTO nheBl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Huan ipaxalojcahua quinchijque ma popoyotiyaca nopa tlacame tlen itztoyaj calteno. Huan nochi hasta tlen más telpocatl huan hasta tlen más huehuentzi, mocajque popoyotzitzi. Huan cuatque quitemohuaj nopa puerta. ");
INSERT INTO nheBl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Huajca nopa paxalohuani quiilhuijque Lot: ―Intla tiquinpiya más moteixmatcahua nica ipan ni altepetl, motlaca conehua, mosihua conehua, momonticahua o sequinoc moteixmatcahua, monequi xiquinquixti huan huejca xiquinhuica. ");
INSERT INTO nheBl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pampa tijtlamiltise ni altepetl huan miquise nochi tlen itztoque nica pampa tlahuel miyac tlajtlacoli quichijtoque. TOTECO quitlacaquilijtoc hasta ayoc quiijiyohuía tlen fiero quichihuaj nica ehuani. Huajca techtitlantoc para ma tijtlamiltica ica nochi tlen nica itztoque. ");
INSERT INTO nheBl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Huajca Lot yajqui quinitato tlen teipa elisquíaj imonticahua pampa ya quinijtlantoyaj iichpocahua huan quinilhui: ―¡Ximoisihuiltica, xiquisaca huan huejca xiyaca pampa TOTECO quitlamiltis ni altepetl! Pero imonticahua ax quineltocaque. Moilhuijque san ahuilcamatiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Huan quema ya tlanestihualayaya, nopa elhuicac ehuani quiisihuiltijque Lot huan quiilhuijque: ―Nimantzi ximoisihuilti huan xiquinhuica mosihua huan ne ome moichpocahua huejca para ax inmiquise quema tijtlamiltise ni altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Huan Lot huejcahuayaya. Pero pampa TOTECO quitlasojtlac, ielhuicac ejcahua TOTECO quimaitzquijque, huan quinitzquijque isihua huan iichpocahua huan quinquixtijque ipan nopa altepetl para quinmanahuise. ");
INSERT INTO nheBl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Huan quema nochi ifamilia Lot quistoyaj tlen nopa altepetl, nopa elhuicac ehuani quinilhuijque: ―¡Ximotlaloca para ax inmiquise! Amo ximoicantlachilica, niyon amo ximoquetztiyaca campa tlamaya. Ximotlaloca hasta campa tepeco, intla inquinequij inmomanahuise huan ax inmiquise. ");
INSERT INTO nheBl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Pero Lot quinilhui: ―¡Axtle, tetatme! ¡Nelía nimechtlajtlanía, xinechtlacaquilica se tlalochtli! ");
INSERT INTO nheBl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nelía innechchihuilijtoque se hueyi favor huan inquimanahuijque noyolis, pero na ax nihueli nicholos hasta campa tepeco pampa huejca. Nopa tlatzacuiltili huelis techajsiti ipan ojtli, huan huajca, quena, timiquise. ");
INSERT INTO nheBl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nechca nica onca se pilaltepetzi campa huelis ticholose. ¡Xitechcahuili tiyase nepa para timomanahuise pampa nelía se altepetl tlen pilsiltzi! ");
INSERT INTO nheBl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Huajca se tlen inijuanti quiijto: ―Cualtitoc, nijchihuas tlen titlajtlantoc. Ax nijtlamiltis nopa altepetl tlen tiquijtohua. ");
INSERT INTO nheBl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pero xiyaca, xicholojtehuaca nimantzi pampa ax tleno huelis nijchihuas hasta inajsitij nepa. Huan yeca Lot quitocajti nopa pilaltepetzi Zoar. (Zoar quinequi quiijtos Pilsiltzi.) ");
INSERT INTO nheBl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Huan quema ya tlanestoya cuali, Lot ya ajsitoya ipan pilaltepetzi Zoar. ");
INSERT INTO nheBl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Huan TOTECO quichijqui ma huetzi tlen elhuicac ipan altepetini Sodoma huan Gomorra se tlamantli tlitl ica azufre tlen tlahuel tlatla. ");
INSERT INTO nheBl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Huan nojquiya quintlamilti nochi sequinoc pilaltepetzitzi ipan nopa tlamayamitl ica nochi tlen itztoyaj nopano huan ica nochi xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pero isihua Lot tlen hualayaya iica, ican tlachixqui huan itlacayo mocuepqui istatl huan mocajqui ijcatoc queja se teteyotl. ");
INSERT INTO nheBl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Huan hualmostla ica ijnaloc, Abraham yajqui campa mocamahuijtoya ihuaya TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Huan tlen nopano tlachixqui ipan altepetini Sodoma huan Gomorra huan ipan nochi nopa pilaltepetzitzi tlen eltoya ipan nopa tlamayamitl. Huan quiitac para tlahuel tlejcoyaya poctli queja elisquía se horno. ");
INSERT INTO nheBl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Huajca queja nopa Toteco Dios quintlatzacuilti nopa altepetini campa Lot itztoya. Pero Toteco Dios quiilnamijqui Abraham huan tlen quitlajtlanijtoya huan quiijcueni Lot tlen nopa fiero tlatzacuiltilistli. ");
INSERT INTO nheBl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Teipa Lot majmajqui para mocahuas ipan pilaltepetzi Zoar huan yajqui tepeixco ihuaya iichpocahua huan nochi eyi inijuanti mocajque nepa ipan se tlacacahuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Huan se tonal nopa iichpoca tlen achtohui ejquetl quiilhui nopa teipa ejquetl: ―Totata ya huehuentzi, huan ax aqui nica niyon se tlacatl ipan nochi ni lugar tlen huelis timonamictise ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yeca ma tiquihuintica totata huan ma tiquixmatise para tiquinpiyase tlen ya iconehua para ax polihuis itoca. ");
INSERT INTO nheBl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Huan ipan nopa tlayohua quimacaque inintata xocomeca atl tlen nelcococ huan nopa achtohui ejquetl motejqui ihuaya. Pero itata ax momacac cuenta tlen panoc, niyon quema motejqui, niyon quema mejqui. ");
INSERT INTO nheBl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Huan hualmostla nopa achtohui ejquetl quiilhui nopa teipa ejquetl: ―Xiquita, tlayohua nimotejqui ihuaya totata, huajca ni tlayohua nojquiya tiquihuintise para ta timotecas ihuaya. Huan queja nopa tiome tijpiyase tlen ya iconehua. ");
INSERT INTO nheBl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Huajca ipan nopa tlayohua sampa quimacaque inintata xocomeca atl huan nopa teipa ejquetl motejqui ihuaya. Pero Lot ax momacac cuenta intla itztoya, niyon quema motejqui, niyon quema mejqui. ");
INSERT INTO nheBl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Queja nopa nochi ome iichpocahua conecuique tlen inintata. ");
INSERT INTO nheBl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Huan nopa achtohui ejquetl quipixqui se icone tlen quitocajti Moab. Quema moscalti Moab, elqui inintata nochi tlacame tlen ama inintoca moabitame. ");
INSERT INTO nheBl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Huan nopa teipa ejquetl quipixqui icone tlen quitocajti Ben Ammi. Quema moscalti Ben Ammi yajaya elqui inintata nochi tlacame tlen ama inintoca amonitame. ");
INSERT INTO nheBl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Teipa Abraham quisqui ipan Mamre huan yajqui tlali Neguev huan mocajqui ipan altepetl Gerar tlen mocahua tlatlajco Cades huan Shur. ");
INSERT INTO nheBl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Huan quema itztoya nopano, quiijtohuayaya para isihua Sara eliyaya iicni. Huajca Abimelec, nopa tlanahuatijquetl tlen Gerar, tlatitlanqui ma quicuitij Sara para teipa quichihuas isihua. ");
INSERT INTO nheBl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pero se tlayohua Toteco Dios quinojnotzqui Abimelec ipan temictli huan quiilhui: “Abimelec, timiquis pampa nopa sihuatl tlen tijcuitoc ya monamictijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Pero Abimelec aya quinechcahuijtoya nopa sihuatl huan quinanquili: “Toteco, ¿tinechmictis yonque ax tleno nijchijtoc? ");
INSERT INTO nheBl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Yajaya Abraham tlen nechilhui para nopa sihuatl eliyaya iicni, huan Sara nojquiya quiijto para Abraham eliyaya itlaca icni. Huajca nochi nijchijqui ica cuali noyolo. Huan na ax tleno tlen ax cuali nijchijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Huan Toteco quinanquili ipan temictli: “Na cuali nijmati para tijchijqui ica cuali moyolo huan yeca ax nimitzcahuili xijnechcahui para amo xitlajtlacolchihua noca na. ");
INSERT INTO nheBl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Huajca ama, xijcuepili isihua nopa tlacatl pampa yajaya se tiocamanalojquetl huan momaijtos huan tlajtlanis para xiitzto. Pero intla ax tijcuepilis, ta huan nochi tlen itztoque mohuaya inmiquise.” ");
INSERT INTO nheBl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Huajca hualmostla, Abimelec mejqui cualca huan quinnotzqui itlatequipanojcahua huan quinpohuili nochi tlen quitemictoya. Huan quema quicajque, nelía momajmatijque. ");
INSERT INTO nheBl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Teipa Abimelec quinotzqui Abraham huan quiilhui: ―¡Tlaque tijchijtoc! ¿Tlaque tlamantli ax cuali nimitzchihuilijtoc para tinechhualiquilijtoc na huan notlacajhua ni hueyi tlajtlacoli? Titechchihuilijtoc se tlamantli tlen ax quinamiqui titechchihuilijtosquía. ");
INSERT INTO nheBl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Tlaque timoilhuiyaya quema tijsencajqui ni tlamantli? ");
INSERT INTO nheBl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Huan Abraham quinanquili: ―Na nimoilhui para nica huelis axaca tlen quitlepanita Toteco Dios huan nimoilhui nechmictisquíaj pampa quinequisquíaj nosihua. ");
INSERT INTO nheBl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Huan melahuac yonque yajaya nosihua, nojquiya noicni pampa yajaya iichpoca notata, pero ax icone nonana. Yeca huelqui nimosihuajti ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Huan quema Toteco Dios nechnahuati ma nijcajtehua ichaj notata para campa hueli tiyase, niquilhui Sara intla nechicnelía ma quiijto ipan sesen lugar campa tiajsisquíaj para na niiicni. ");
INSERT INTO nheBl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Huajca Tlanahuatijquetl Abimelec quicuepili Abraham isihua Sara. Nojquiya quinsentili borregojme, huacaxme, huan tlaca tlatequipanohuani, huan sihua tlatequipanohuani huan quimacac Abraham, ");
INSERT INTO nheBl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","huan quiilhui: ―Xijtlachiliti nochi notlal huan xijtlapejpeni campa más mitzpactis para tiitztos. ");
INSERT INTO nheBl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Huan Tlanahuatijquetl Abimelec quiilhui Sara: ―Nijmacatoc tlen tijnotza ‘moicni’ se mil plata tomi huan queja nopa nelcuali nimitztlaxtlahuía pampa nimitzpinahualti iniixtla nochi tlen itztoque mohuaya. Huan axaca huelis camatis fiero tlen ta ipampa tlen panoc. Nochi elis xitlahuac. ");
INSERT INTO nheBl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Huan Toteco Dios quichijtoya para niyon se sihuatl tlen itztoya ichaj Tlanahuatijquetl Abimelec ma ax conepiya quema Sara itztoya ichaj. Huajca Abraham quitlajtlani TOTECO para ma quichicahua Abimelec huan isihua, huan nopa sequinoc isihua tlatequipanojcahua para sampa huelise conepiyase. Huan inijuanti mochicajque ");
INSERT INTO nheBl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","TOTECO quipixqui hueyi iyolo ica Sara huan quitiochijqui queja mocajtoya ihuaya Abraham para quichihuas. ");
INSERT INTO nheBl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Huan Sara conecuic huan quimacac Abraham se icone quema ya eliyaya nelhuehuentzi. Huan nopa oquichpil tlacatqui ipan nopa metztli tlen Toteco Dios quiilhuijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Huan Abraham quitocajtlali icone, Isaac. ");
INSERT INTO nheBl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Huan Abraham quitzontequili iyacapa nopa cuetlaxtli ipan ipiltlacayo quema quipiyayaya chicueyi tonali tlacajtoya queja Toteco Dios quinahuatijtoya ma quichihua. ");
INSERT INTO nheBl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Huan Abraham quipiyayaya 100 xihuitl quema tlacatqui Isaac. (Isaac quinequi quiijtos Huetzquistli.) ");
INSERT INTO nheBl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Huajca Sara quiijto: “Toteco Dios quichijtoc ma nihuetzca, huan nochi tlen quimatise para nijpixtoc se nocone huetzcase nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Ajqueya quiilhuijtosquía Abraham para na nijchichitisquía icone? Pero ama nijmacatoc se icone quema ya huehuentzi.” ");
INSERT INTO nheBl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Huan nopa oquichpil Isaac moscalti huan teipa ipan nopa tonal quema Sara quichiinquixtili, Abraham ilhuichijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Huan Sara quiitac para Ismael tlen Abraham quipixqui ica Agar nopa Egipto ejquetl, quihuihuiitayaya Isaac. ");
INSERT INTO nheBl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Huajca Sara yajqui quiilhuito Abraham: “¡Xijquixti nopa tlatequipanojquetl, Agar, ihuaya icone! Ax quinamiqui para icone ma quiselis san se ihuaya nocone Isaac quema timiquis.” ");
INSERT INTO nheBl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Huan ni tlamantli tlen Sara quiijto nelía quiyolcoco Abraham pampa nopa oquichpil Ismael nojquiya eliyaya icone. ");
INSERT INTO nheBl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pero Toteco Dios quiilhui: “Amo ximocueso ica nopa oquichpil huan motlatequipanojca. Xijchihua nochi tlen Sara mitztlajtlanía pampa moteipa ixhuihua hualase ipan Isaac. ");
INSERT INTO nheBl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Huan nojquiya ica mocone tlen nopa sihua tequitiquetl quitlacatilti niquinmiyaquilis iteipa ixhuihua huan mochihuase seyoc xinachtli tlacame ica nelía miyac itlacajhua pampa yajaya nojquiya mocone.” ");
INSERT INTO nheBl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Huajca hualmostla nelcualca, Abraham quicuic tlacualistli huan se cuetlaxtli temitoc ica atl huan quimamalti Agar huan quiilhui ma quisa ihuaya ioquichpil Ismael. Huan nopa sihuatl yajqui huan san nentinemiyaya ipan nopa huactoc tlali Beerseba campa ax tleno eli pampa ax quimatiyaya canque yas. ");
INSERT INTO nheBl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Huan quema tlanqui atl tlen eltoya ipan nopa cuetlaxtli, quicajtejqui nopa oquichpil cuatzintla, ");
INSERT INTO nheBl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","huan yajqui mosehuito ica huejca pampa ax quinequiyaya quiitas quema miquisquía. Huan quema Agar mosehuijtoya imelac, nopa oquichpil pejqui choca chicahuac. ");
INSERT INTO nheBl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Huan Toteco Dios quicajqui para chocayaya nopa oquichpil, huan ielhuicac ejca Toteco Dios quinojnotzqui Agar tlen elhuicac huan quiilhui: “¿Tlaque tijpiya Agar? Amo ximajmahui pampa Toteco Dios quicactoc queja choca ne oquichpil nopano campa itztoc. ");
INSERT INTO nheBl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Xiya, xijtlalana nopa oquichpil huan xijmatilana. Amo ximajmahuica. Na nijchihuas ma itzto huan iteipa ixhuihua momiyaquilise huan mochihuase se xinachtli tlacame tlen nelía miyac itlacajhua.” ");
INSERT INTO nheBl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Huajca Toteco Dios queja quiixtlapo Agar para ma quiita se ameli ica atl. Huan yajaya yajqui huan quitemitito nopa cuetlaxtli ica atl huan quiamacac Ismael. ");
INSERT INTO nheBl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Huan Toteco Dios itztoya ihuaya nopa oquichpil huan quipalehui ma moscalti ipan nopa huactoc tlali tlen itoca Parán. Huan yajaya elqui se cuali tlapejquetl ica cuatlamintli. Huan teipa inana quisihuajti ica se ichpocatl tlen ejqui tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nojquiya ipan nopa tonali Tlanahuatijquetl Abimelec yajqui ihuaya Ficol, nopa tlayacanquetl tlen isoldados para quicamahuise Abraham. Huan Tlanahuatijquetl Abimelec quiilhui Abraham: ―Nochi quiitaj para Toteco Dios mitzpalehuía ipan nochi tlamantli tlen tijchihua. ");
INSERT INTO nheBl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Huajca ama xijtestigojquetza Toteco Dios para ax titechtehuis, niyon na, niyon noconehua, niyon noteipa ixhuihua. San titechchihuilis tlen cuali queja nimitzchihuili. Nojquiya xijchihua san se ica ni tlacame tlen ni altepetl campa ama tiitztoc queja se seyoc tlali ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Huan Abraham quinanquili: ―Cualtitoc, nijtestigojquetza Toteco Dios. ");
INSERT INTO nheBl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Teipa Abraham quiyolmelajqui Abimelec tlen se ameli tlen itlatequipanojcahua Abimelec quiquixtilijtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Huan Abimelec quinanquili: ―Ax nijmati ajqueya huelqui quichijqui ya nopa. Ax tleno nijmatiyaya tlen ni tlamantli hasta amantzi pampa axaca nechyolmelajtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Huajca Abraham quincuic borregojme huan huacaxme huan quimacac Tlanahuatijquetl Abimelec para quiijtos para temachtli ax moixpanose queja quiijto nopa tlajtoli tlen quisencahuayaya ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Pero teipa Abraham quiniyocaquixti chicome sihua pilborregojtzitzi tlen iaxcahua, ");
INSERT INTO nheBl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","huan Abimelec quitlajtlani: ―¿Para tlen tiquiniyocaquixtijtoc ne chicome pilsihua borregojtzitzi? ");
INSERT INTO nheBl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Huan Abraham quinanquili: ―Xiquinseli ni chicome pilsihua borregojtzitzi tlen nimitzmaca para ma nesis ta tijmati para na nijchijqui nopa ameli. ");
INSERT INTO nheBl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Huajca yeca quitocajtijque campa itztoyaj Beerseba. (Beerseba quinequi quiijtos Ameli Campa Quitestigojquetzque Toteco Dios.) Queja nopa quitocajtijque pampa nopano nopa ome quitestigojquetzque Toteco Dios tlen quichihuasquíaj. ");
INSERT INTO nheBl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Huan nopano ipan Beerseba, quema tlanque quichihuaj nopa tlajtoli para ax moixpanose, Abimelec ihuaya Ficol tlen quinyacanqui isoldados, mocuepque campa itztoyaj ipan nopa tlali tlen nojquiya inintlal nopa filisteos. ");
INSERT INTO nheBl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Huan ipan Beerseba, Abraham quitojqui se cuahuitl tlen itoca tamarisco. Huan nopano quihueyichijqui TOTECO, Nopa Dios Tlen Nochipa Itztoc. ");
INSERT INTO nheBl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Huan para miyac xihuitl Abraham mocajqui nopano ipan inintlal nopa filisteos. ");
INSERT INTO nheBl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Teipa panoc tonali huan Toteco Dios quiyejyeco Abraham para quiitas intla nelía quineltoquilía. Huan Toteco Dios quiilhui: ―Abraham. Huan Abraham quinanquili: ―Quena, nica niitztoc. ");
INSERT INTO nheBl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Huan Toteco Dios quiilhui: ―Xijcui Isaac moiyojtzi cone tlen nelía tiquicnelía huan xiya hasta nopa tlali tlen itoca Moriah. Nopano xinechmaca queja se tlacajcahualistli ipan se tepetl tlen nimitznextilis. ");
INSERT INTO nheBl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Huajca hualmostla nelcualca, Abraham mejqui huan quisiyajti iburro, huan quitzontejqui cuahuitl para ipan quitlatis tlacajcahualistli. Huan quistejqui huan yajqui ihuaya icone, Isaac, huan ome itlatequipanojcahua hasta nopa lugar campa Toteco Dios quiilhui. ");
INSERT INTO nheBl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Huan hualhuiptla, Abraham quihuejcaitac nopa lugar, ");
INSERT INTO nheBl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","huajca quinilhui itlatequipanojcahua: ―Ximocahuaca nica ica ni pilburrojtzi. Nooquichpil huan na tiyase achi nepa huan tijhueyichihuatij Toteco Dios huan teipa timocuepase. ");
INSERT INTO nheBl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Huan Abraham quicuic nopa cuahuitl para nopa tlacajcahualistli huan quitlali iajcolpa Isaac. Huan quicuic nopa cuchillo huan tlitl huan queja nopa nochi ome yajque san sejco. ");
INSERT INTO nheBl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Teipa Isaac quiilhui Abraham: ―¡Papá! Huan Abraham quinanquili: ―¿Tlaque tijnequi, nocone? Huan Isaac quiijto: ―Xiquita, tijpiyaj cuahuitl huan tlitl, pero ¿canque itztoc nopa pilborregojtzi para nopa tlacajcahualistli? ");
INSERT INTO nheBl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Huan Abraham quinanquili: ―Nocone, Toteco Dios quichihuas para ma onca se pilborregojtzi para nopa tlacajcahualistli. Huan noja nejnentiyajque san sejco. ");
INSERT INTO nheBl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Huan quema ajsitoj ipan nopa lugar tlen Toteco Dios quiilhuijtoya, Abraham quisencajqui se tlaixpamitl huan quicualtlali nopa cuahuitl. Teipa quiilpi icone, Isaac, huan quitlali ipan tlaixpamitl iixco nopa cuahuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Huan Abraham quitlalanqui nopa cuchillo para quimictis icone. ");
INSERT INTO nheBl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Huan ipan nopa tlalochtli ielhuicac ejca TOTECO quihualnojnotzqui tlen nepa elhuicac: ―¡Abraham! ¡Abraham! Huan Abraham tlananquili: ―Nica niitztoc. ");
INSERT INTO nheBl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Huan ielhuicac ejca Toteco Dios quiilhui: ―Ax tleno xijchihuili nopa oquichpil. Ya niquita para tiquimacasi huan tijneltoca Toteco Dios huan ax tijtlasomatqui para tinechmacas moiyojtzi cone. ");
INSERT INTO nheBl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Huan Abraham tlachixtejqui huan quiitac se borrego tlen cuatacantoya ica icuacua ipan imacuayo se huitzcuahuitl. Huajca yajqui huan quicuito huan ya nopa quimacac Toteco Dios queja se tlacajcahualistli tlen ica quipatla icone. ");
INSERT INTO nheBl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Teipa Abraham quitocajtlali nopa lugar: “TOTECO Temaca Tlen Monequi.” Huan yeca noja moijtohua hasta ama: “Ipan ni itepe TOTECO, yajaya temacas tlen monequi.” ");
INSERT INTO nheBl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Huan ielhuicac ejca TOTECO quinotzqui Abraham ica ompa, ");
INSERT INTO nheBl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","huan quiilhui para queja ni TOTECO quiijtohua: ―Pampa tijchijtoc ni tlamantli huan ax tijtlasomatqui moiyojtzi cone, nimotestigojquetza noselti ");
INSERT INTO nheBl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","para nimitztiochihuas tlahuel miyac. Nijchihuas para moteipa ixhuihua ma elica onpano miyac miles tlacame hasta axaca huelis quinpohuas. Elise queja ininmiyaca nopa sitlalime nepa elhuicactli huan queja imiyaca xali tlen onca iteno hueyi atl. Nojquiya inijuanti nochipa quintlanise inincualancaitacahua. ");
INSERT INTO nheBl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Huan niquintiochihuas nochi tlacame ipan nochi tlaltini ipan tlaltepactli ica moixhui pampa tinechneltoquilijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Huan Abraham mocuepqui hasta nopa lugar campa mocajtoyaj itlatequipanojcahua, huan teipa san sejco mocuepque Beerseba. Huan Abraham mocajqui nopano para itztos. ");
INSERT INTO nheBl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Teipa panoc miyac tonali huan ajsico tlajtoli para nopa sihuatl Milca nojquiya quimacatoya coneme Nacor, itlaca icni Abraham. ");
INSERT INTO nheBl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Huan iniachtohui ejca elqui Uz, huan teipa tlacatqui Buz. Teipa tlacatqui Kemuel tlen teipa elqui itata Aram. ");
INSERT INTO nheBl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Huan teipa tlacatque Quesed, Hazo, Pildas, Jidlaf huan Betuel. ");
INSERT INTO nheBl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Huan Betuel moscalti huan elqui itata Rebeca. Ni nopa chicueyi telpocame tlen Milca quimacac Nacor tlen eliyaya iicni Abraham. ");
INSERT INTO nheBl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Huan nojquiya Nacor quinpixqui telpocame ica Reúma, itlatequipanojca. Ininconehua elqui Teba, Gaham, Tahas huan Maaca. ");
INSERT INTO nheBl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara itztoya para 127 xihuitl, ");
INSERT INTO nheBl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","huan mijqui ipan altepetl Quiriat Arba tlen nojquiya itoca Hebrón huan mocahua ipan tlali Canaán. Huan Abraham mocueso huan quichoquili Sara pampa mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Teipa quisqui campa huilantoya itlacayo Sara huan yajqui campa nopa heteo tlacame tlen itztoyaj ipan nopa lugar huan quinilhui: ");
INSERT INTO nheBl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","―Yonque nise sejcoyoc ejquetl nica campa imojuanti, xinechnamaquiltica se quentzi imotlal campa nijtocas nomijcatzi. ");
INSERT INTO nheBl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Huan nopa heteo tlacame quinanquilijque: ");
INSERT INTO nheBl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","―¡Nohuampo, xinechtlacaquili! Tojuanti timitzitaj para tise hueyi tlacatl tlen Dios quitlapejpenijtoc. Ayoc más ximocueso. Xijtlalpacho momijcatzi ipan nopa tlacacahuaya tlen más cuali tijpiyaj nica. Ax tleno timitztlasomatilise tlen mitzmonequilis. ");
INSERT INTO nheBl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Huajca Abraham moquetzqui huan mopacho ica tlatlepanitacayotl iniixtla nopa heteos, ");
INSERT INTO nheBl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","huan quinilhui: ―Intla nelía inquiitaj cuali para nijtlalpachos nica nomijcatzi, xinechchihuilica se favor. Xijtlajtlanica Efrón, icone Zohar, ");
INSERT INTO nheBl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ma nechnamaquilti nopa tlacacahuaya tlen itoca Macpela tlen eltoc imiltlateno. Na nijtlaxtlahuis queja quinamiqui para nopa tlali huan queja nopa elis noaxca se tlacacahuaya nica para ipan nitetlalpachos. ");
INSERT INTO nheBl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Huan Efrón nopa heteo itztoya nopano ininhuaya. Huan Abraham camatiyaya chicahuac para ma quicaquica nochi ihuampoyohua huan nochi tlen mosehuiyayaj nechca ipuerta nopa altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Huan Efrón quiijto: ―¡Axtle, tate! Na san tlapic nimitzmaca nopa tlali huan nopa tlacacahuaya tlen eltoc nopano. Iniixtla nohuampoyohua nica nimitzmaca para nopano xijtoca momijcatzi. ");
INSERT INTO nheBl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Pero Abraham mopacho ica tlatlepanitacayotl iniixtla nopa tlacame tlen nopano ehuani. ");
INSERT INTO nheBl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Huan quiilhui: ―¡Se favor, xinechtlacaquili! Nimitztlajtlanía xijseli nopa tomi para nopa tlali huan teipa nijtlalpachos nopano nomijcatzi. ");
INSERT INTO nheBl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Huajca Efrón quinanquili: ");
INSERT INTO nheBl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","―Xinechtlacaquili, tate. Nopa tlali ipati nahui kilos huan tlajco tlen plata tomi, pero nopa ax quenijqui. San xijseli huan nopano xijtlalpacho momijcatzi. ");
INSERT INTO nheBl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Huan Abraham quiitac cuali ipati tlen Efrón quiijtojtoya iniixtla nopa heteo tlacame. Yeca quiyejyeco ietica nopa tomi huan quimacac, huan nochi quimatiyayaj para xitlahuac. ");
INSERT INTO nheBl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Huan queja ni mochijqui iaxca Abraham nopa tlali tlen quiyahualo nopa tlacacahuaya Macpela tlen mocajqui imelac campa quisa tonati ipan tlali Mamre ihuaya nochi cuatini tlen eltoya nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Nochi mochijqui iaxca Abraham iniixtla nopa heteos huan nochi tlen mosehuiyayaj nechca ipuerta nopa altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Huan Abraham quitlalpacho Sara ipan nopa tlacacahuaya Macpela ipan nopa mili Mamre nechca altepetl Hebrón tlen eltoc ipan tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Huajca nopa heteo tlacame quimacaque Abraham se amatlajcuiloli para nopa tlali tlen quinamaquiltijque para ipan quitlalpacho Sara. ");
INSERT INTO nheBl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Huan Abraham ya eliyaya nelhuehuentzi, huan TOTECO quitiochijtoya ica nochi tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Huan se tonal quinotzqui itlayacanca tlatequipanojca tlen quimocuitlahui nochi tlen iaxca huan quiilhui: ―Xijtlali moma itzintla nometztomahuiya, ");
INSERT INTO nheBl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","huan ica ya nopa tijtestigojquetzas TOTECO, nopa Dios tlen quinahuatía elhuicac huan tlaltepactli para ax tijcahuas nocone Isaac ma mocuili se sihuatl tlen ni tlali Canaán campa tiitztoque. ");
INSERT INTO nheBl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Monequi xiya ipan notlal campa nihualajqui huan xijtlapejpeni se isihua campa noteixmatcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Huan itlatequipanojca quinanquili: ―Pero ¿tlaque nijchihuas intla nopa sihuatl ax quinequis hualas nohuaya? ¿Tijnequi ma nijhuicas mocone ipan nopa tlali campa tiquisqui? ");
INSERT INTO nheBl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Huan Abraham quiijto: ―¡Axtle! Amo xijhuica nocone nepa. ");
INSERT INTO nheBl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","TOTECO Dios tlen tlanahuatía ipan elhuicac huan tlen nechquixti ichaj notata huan noteixmatcahua mitzpalehuis. Yajaya tlen nohuaya mocajtoc para quinmacas ni tlali noteipa ixhuihua, quititlanis ielhuicac ejcahua ma mitzyacana para tijhualicas tlen nepa se ichpocatl para nocone. ");
INSERT INTO nheBl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Huan intla nopa ichpocatl ax quinequis hualas mohuaya, huajca ta timocahuas timajcajtos tlen ni tlajtoli, pero amo xijhuica nocone nepa. ");
INSERT INTO nheBl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Huajca itlatequipanojca Abraham quitlali ima itzintla imetzcuayo huan quitestigojquetzqui Toteco Dios para temachtli quichihuasquía tlen quinequiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Teipa quitlapejpeni miyac tlamantli tlen más cuali tlen iteco quipiyayaya para temajmacati. Huan quincuic majtlactli camellos tlen iaxca Abraham huan yajqui altepetl Nacor ipan tlali Mesopotamia. ");
INSERT INTO nheBl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Quema itlatequipanojca ajsitinemiyaya nechca nopa altepetl, ya pejtoya tzintlayohuaya. Huan ipan nopa hora miyac sihuame huan ichpocame hualayayaj atlacuiquij. Huajca quinsiyajcajque nopa camellos nechca se ameli, ");
INSERT INTO nheBl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","huan pejqui momaijtohua ica TOTECO. Quiilhui: “TOTECO Dios, ta tiiTeco noteco, Abraham, xijchihua para ama ma quisa cuali notequi nica pampa tiquicnelía noteco Abraham. ");
INSERT INTO nheBl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nimocahuas nica nechca ni ameli campa ichpocame hualahuij atlacuiquij. ");
INSERT INTO nheBl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Xinechcahuili para nopa ichpocatl tlen niquilhuis para ma nechtemohuili ico para ma niatlis, ma nechnanquili: ‘Xiatli, huan nojquiya niquinamacas mocamellos’. Huan queja nopa nijmatis para ya nopa tlen tijtlapejpenijtoc para isihua Isaac. Huan queja nopa nijmatis para tijtlasojtlatoc noteco, Abraham.” ");
INSERT INTO nheBl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Huan aya tlamiyaya momaijtohua quema quiitac se ichpocatl quiquechpanojtihualayaya ico. Huan nopa ichpocatl itoca eliyaya Rebeca huan yajaya elqui se iixhui Nacor tlen elqui iicni Abraham. Nacor huan isihua, Milca, quipixque se telpoca tlacatl tlen itoca Betuel tlen elqui itata nopa ichpocatl. ");
INSERT INTO nheBl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Huan Rebeca eliyaya nelyejyectzi huan ax quema itztoya ihuaya se tlacatl. Huan Rebeca temotoya hasta campa eltoc ameli quitemitito ico huan ixtlejcoyaya hasta tlalpani ica atl, ");
INSERT INTO nheBl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","quema nopa tequitiquetl motlalo quiajsito huan quiilhui: ―Xinechcahuili ma niqui se quentzi atl ipan moco. ");
INSERT INTO nheBl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Huan nopa ichpocatl quinanquili: ―Xiatli, tate. Huan nimantzi quitemohui ico tlen iajcolpa huan quiamacac. ");
INSERT INTO nheBl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Huan quema nopa tequitiquetl tlanqui atli, Rebeca quiijto: ―Nojquiya nijquixtis atl para mocamellos hasta tlami atlise. ");
INSERT INTO nheBl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Huan nimantzi atejqui campa atlij tlapiyalime. Huan motlalo miyac huelta huan temoc campa ameli atlacuiti hasta quintlamiamacac nochi nopa camellos. ");
INSERT INTO nheBl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Huan nopa tequitiquetl san quisentlachiliyaya huan ax tleno quiijtohuayaya. San moilhuiyaya quejatza TOTECO quipalehuijtoya ipan iojhui. ");
INSERT INTO nheBl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Huan quema nopa camellos tlanque atlij, nopa tlacatl quiquixti se anillo tlen oro tlen quipixqui chicuase gramos ietica huan quimacac para quitlalis ipan iyacatzol. Nojquiya quimacac ome maquechcostli tlen oro tlen quipixqui ietica chicuase gramos, ");
INSERT INTO nheBl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","huan quiilhui: ―Xinechilhui ajqueya motata huan intla onca ipan mochaj campa notlacajhua huan na huelis timocahuase. ");
INSERT INTO nheBl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Huan yajaya tlananquili: ―Niiichpoca Betuel, yajaya tlen elqui icone Milca huan Nacor. ");
INSERT INTO nheBl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ipan tochaj onca se lugar campa timocahuas huan nojquiya onca miyac sacatl huan tlacualistli para mocamellos. ");
INSERT INTO nheBl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Huajca nopa tequitiquetl motlancuaquetzqui huan quihueyichijqui TOTECO, ");
INSERT INTO nheBl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","huan quiijto: “Nimitzhueyichihua, TOTECO, ta tlen tiiTeco noteco, Abraham. Ta titemachtli huan nelía tijtlasojtlatoc noteco huan tinechyacantoc ipan ojtli hasta nica campa ininchaj iteixmatcahua.” ");
INSERT INTO nheBl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Huan Rebeca motlalojtiyajqui hasta ichaj inana huan quiilhuito nochi tlen quipanotoya. ");
INSERT INTO nheBl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Huan Rebeca quipiyayaya se itlaca icni tlen itoca Labán. Huan Labán motlalo hasta campa ameli quitemoco nopa tlacatl, ");
INSERT INTO nheBl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","pampa quiitztoya nopa anillo, huan nopa maquechcostli tlen iicni quihuicayaya ipan ima huan quicactoya tlen panoc. Huan Labán monechcahui campa itlatequipanojca Abraham tlen noja itztoya ihuaya icamellos nechca ameli, ");
INSERT INTO nheBl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","huan quiilhui: ―Xihuala nochaj, ta tlen TOTECO mitztiochijtoc. ¿Para tlen tiitztoc nica huejcatzi? Nijcualtlalijtoc nochaj para ta huan nojquiya onca campa mocahuase mocamellos. ");
INSERT INTO nheBl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Huajca itlatequipanojca Abraham yajqui ihuaya. Huan nopano Labán quintlatemohuili nopa camellos huan quintlamacac. Teipa quihualicac atl huan quinmacac nopa tlatequipanojquetl huan nopa tlacame tlen ihuaya hualayayaj para ma moicxipajpacaca. ");
INSERT INTO nheBl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Huan quema quintlalilijque tlacualistli para tlacuase, itlatequipanojca Abraham quiijto: ―Na ax nitlacuas hasta niquijtos tlen monequi niquijtos. Huan Labán quiijto: ―Huajca xitechilhui. ");
INSERT INTO nheBl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Huan nopa tlatequipanojquetl quiijto: ―Na niitlatequipanojca Abraham. ");
INSERT INTO nheBl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","TOTECO miyac quitiochijtoc noteco huan quiricojchijtoc. Quimacatoc tlahuel miyac borregojme, huacaxme, camellos huan burrojme. Quimacatoc miyac tlaca tlatequipanohuani huan sihua tequipanohuani, huan iyoca quimacatoc tlahuel miyac oro huan plata. ");
INSERT INTO nheBl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nojquiya Sara, isihua Abraham, quimacac se icone quema eliyaya neltenantzi. Huan noteco quicahuilijtehuas icone nochi tlen quipiya. ");
INSERT INTO nheBl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pero ya nechchihualti ma nijtestigojquetza Toteco Dios para ax nijcahuas para icone ma mocuili se sihuatl tlen ehua ipan nopa tlali Canaán campa tiitztoque. ");
INSERT INTO nheBl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Nechilhui ma nihuala nica campa iteixmatcahua itata huan ma nijtemo tlen imojuanti se sihuatl para icone. ");
INSERT INTO nheBl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Huan na nijtlajtlani noteco tlaque monequi nijchihuas intla nopa sihuatl ax quinequis hualas nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Huan ya nechnanquili: ‘Na ninentoc ipan iojhui TOTECO huan nijmati yajaya quititlanis ielhuicac ejca huan mitzyacanas para nochi quisas cuali ipan moojhui. Huan temachtli tijpantis se sihuatl para nocone nepa campa noteixmatcahua huan iteixmatcahua notata.’ Queja nopa nechilhui. ");
INSERT INTO nheBl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Pero nechilhui intla noteixmatcahua ax quinequise mitzmacase nopa ichpocatl, nopano tlamis ni tlajtoli tlen tijtestigojquetztoc Toteco Dios para tijchihuas. ");
INSERT INTO nheBl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Huajca ama quema niajsico campa ameli, niquilhui TOTECO Dios, yajaya tlen iTeco noteco, Abraham: ‘Intla mopaquilis ta, xijchihua nochi ma quisa cuali ipan ni noojhui. ");
INSERT INTO nheBl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ama niitztoc nechca ni ameli. Huajca xijchihua para quema hualas se ichpocatl atlacuiqui huan niquilhuis: Se favor, xinechcahuili niquis se quentzi atl ipan moco, ");
INSERT INTO nheBl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","para ma nechnanquili: Xiatli, huan nojquiya nijquixtis atl para mocamellos. Huan queja nopa nijmatis para yajaya nopa ichpocatl tlen tijtlapejpenijtoc para icone noteco.’ Queja nopa niquilhui TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Huan aya nitlamiyaya nimomaijtohua quema niquitac Rebeca quiquechpanojtiyohuiyaya ico. Huan Rebeca temoc campa ameli para atlacuis huan niquilhui: ‘Se favor, xinechcahuili niquis se quentzi atl ipan moco.’ ");
INSERT INTO nheBl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Huan Rebeca nimantzi quitemohui ico para ma niatli huan nechilhui: ‘Xiatli huan nojquiya nijquixtis atl para mocamellos.’ ");
INSERT INTO nheBl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Huan teipa nijtlajtlani: ‘¿Ajqueya tiiichpoca?’ Huan ya nechnanquili para yajaya iichpoca Betuel tlen elqui icone Nacor huan Milca. Huajca nijtlalili se anillo ipan iyacatzol huan se maquechcostli ipan ima. ");
INSERT INTO nheBl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Huan nimotlancuaquetzqui huan nijhueyichijqui huan nijpaquilismacac TOTECO Dios, yajaya tlen iTeco noteco Abraham pampa nechyacanqui ipan ojtli tlen xitlahuac para nijpantis para icone se ichpocatl tlen itztoc se iteixmatca noteco. ");
INSERT INTO nheBl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Huajca ama xinechilhuica intla inquichihuase tlen cuali huan xitlahuac ihuaya noteco huan inquicahuilise Rebeca ma yas nohuaya. Huan intla axtle, xinechilhuica nojquiya para nijmatis tlaque monequis nijchihuas.” ");
INSERT INTO nheBl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Huajca Labán huan Betuel quinanquilijque: ―Nochi ya ni huala tlen TOTECO huan tiquitaj para yajaya ipaquilis. Huajca ax huelis tojuanti timitzilhuise quena o axtle. ");
INSERT INTO nheBl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Xiquita, nica itztoc Rebeca. Huelis tijhuicas para ma eli isihua icone moteco queja TOTECO quitlalijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Huajca quema itlatequipanojca Abraham quicajqui ya nopa, motlancuaquetzqui iixtla TOTECO huan mopacho hasta tlalchi para quitlascamatis. ");
INSERT INTO nheBl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Teipa quiquixti miyac tlamantli tlen oro, plata huan miyac yoyomitl huan quimacac Rebeca. Nojquiya itlaca icni huan inana quintlamajmacac. ");
INSERT INTO nheBl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Huan quema tlanqui, ya ihuaya nopa tlacame tlen ihuaya yahuiyayaj tlacuajque huan tlaique huan nopano mocajque nopa yohuali. Huan hualmostla nopa tlatequipanojquetl quiijto: ―Xinechcahuilica nimantzi ma nimocuepas ichaj noteco. ");
INSERT INTO nheBl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pero itlaca icni huan inana Rebeca quiilhuijque: ―Noja ma mocahua ni ichpocatl majtlactli tonali tohuaya huan teipa yas mohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Pero nopa tlatequipanojquetl quinilhui: ―Amo xinechtzacuilica más pampa TOTECO quichijtoc ma quisa cuali noojhui, yeca xinechcahuilica nimantzi ma nimocuepa ichaj noteco. ");
INSERT INTO nheBl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Huajca inijuanti quinanquilijque: ―Tijnotzase nopa ichpocatl huan tiquitase tlaque quiijtos. ");
INSERT INTO nheBl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Huajca quinotzque Rebeca huan quitlajtlanijque: ―¿Tijnequi tiyas ihuaya ni tlacatl amantzi? Huan Rebeca tlananquili: ―Quena, niyas. ");
INSERT INTO nheBl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Huajca quicahuilijque Rebeca ma yohui ihuaya itlatequipanojca Abraham huan inijuanti tlen hualajtoyaj ihuaya. Huan nopa sihua tlatequipanojquetl tlen nochipa quimocuitlahuijtoya Rebeca nojquiya yajqui ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Huan iteixmatcahua quitiochijque Rebeca queja ni: “Toicni, ¡xieli ininnana tlahuel miyac tlacame! ¡Moteipa ixhuihua nochipa ma tlatlanica, ica inincualancaitacahua!” ");
INSERT INTO nheBl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Huajca Rebeca ihuaya itlatequipanojcahua tlejcoque ipan camellos huan quitoquilijque itlatequipanojca Abraham. Huan queja nopa ne tlatequipanojquetl quicuitejqui Rebeca. ");
INSERT INTO nheBl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Teipa ipan tlali Canaán Isaac tlen mochantijtoya ipan Neguev, mocuepayaya tlen nopa ameli tlen itoca “Iamel Toteco Tlen Itztoc Huan Nechita”. ");
INSERT INTO nheBl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Huan se tonal ica tiotlac Isaac quistoya ichaj para nejnemis huan momaijtos huan tlachixqui huan quinitac sequin camellos tlen monechcahuiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Huan Rebeca nojquiya huejca tlachixqui huan quema quiitac Isaac, temoc tlen nopa camello, ");
INSERT INTO nheBl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","huan quiilhui nopa tlatequipanojquetl: ―¿Ajqueya ne tlacatl tlen quistinemi ipan ne mili huan toixmelac huala? Huan nopa tlatequipanojquetl tlananquili: ―Yajaya noteco. Huajca Rebeca moixtzajqui ica itzontzajcayo. ");
INSERT INTO nheBl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Huan quema ajsitoj, nopa tlatequipanojquetl quipohuili Isaac nochi tlen quichijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Huan teipa Isaac quihuicac Rebeca ipan ichaj tlen yoyomitl tlen achtohui elqui iaxca Sara huan quichijqui isihua. Huan Isaac quiicneli Rebeca huan queja nopa moyoltlali pampa inana mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Huan Abraham mocuili seyoc isihua tlen itoca Cetura. ");
INSERT INTO nheBl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Huan iconehua tlen quinpixqui ihuaya elque Zimram, Jocsán, Medán, Madián, Isbac huan Súa. ");
INSERT INTO nheBl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Huan teipa Jocsán quinpixqui itelpocahua tlen inintoca Seba huan Dedán. Huan iteipa ixhuihua Dedán elque nopa asureos, letuseos huan leumeos. ");
INSERT INTO nheBl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Huan iconehua Madián elque Efa, Efer, Hanoc, Abida huan Elda. Nochi ya ni elque iteipa ixhuihua Cetura. ");
INSERT INTO nheBl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Huan Isaac quiseli nochi tlen Abraham quipiyayaya quema mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Pero quema aya miquiyaya, quintlamajmacac iconehua tlen tlacajtoyaj ica isihua tlatequipanojcahua huan quintitlanqui neca quentzi más para campa quisa tonati huan queja nopa quiniyocatlali ica icone Isaac. ");
INSERT INTO nheBl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Huan Abraham itztoya 175 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Huan mijqui san pampa eliyaya nelhuehuentzi huan yajqui mosejcotilito ininhuaya ihuejcapan tatahua. ");
INSERT INTO nheBl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Huan Isaac huan Ismael, itelpocahua Abraham, quitlalpachojque ipan nopa tlacacahuaya tlen itoca Macpela tlen mocahua más campa quisa tonati tlen altepetl Mamre. Nopa tlacacahuaya elqui ipan itlal se heteo tlacatl itoca Efrón tlen elqui icone Zohar. ");
INSERT INTO nheBl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Huan Abraham quincohuilijtoya nopa heteos nopa tlali para ipan quitocas isihua, Sara. ");
INSERT INTO nheBl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Teipa quema Abraham mijqui, Toteco Dios miyac quitiochijqui Isaac. Huan Isaac mocahuayaya nechca nopa ameli tlen itoca “Iamel yajaya Tlen Itztoc Huan Tlen Nechita”. ");
INSERT INTO nheBl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nica eltoc inintoca iconehua Ismael tlen elqui icone Abraham ihuaya Agar, isihua tlatequipanojca Sara tlen hualajqui tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ya ni inintoca queja tlacajtiyajque: Nebaiot, tlen elqui achtohui ejquetl, teipa Cedar, Adbeel, Mibsam, ");
INSERT INTO nheBl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO nheBl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis huan Cedema. ");
INSERT INTO nheBl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nochi ya ni inintoca nopa 12 iconehua Ismael. Sesen mochijqui tlayacanquetl ipan se hueyi familia tlen iixhuihua. Huan nica quipiya campa mochansehuijtiyajqui huan nopa pilaltepetzitzi tlen mochijqui quihuicayaya sesen hueyi familia itoca. ");
INSERT INTO nheBl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Huan Ismael quipiyayaya 137 xihuitl quema mijqui huan mosejcotilito ininhuaya ihuejcapan tatahua. ");
INSERT INTO nheBl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Teipa iteipa ixhuihua Ismael mosemanque campa hueli ipan nopa tlali tlen Havila hasta Shur nechca iteno tlali Egipto ipan ojtli para Asiria. Nopano iteipa ixhuihua Ismael mocajque huan nochipa motehuiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Amantzi nimechpohuilis tlen panoc ica Isaac, icone Abraham. ");
INSERT INTO nheBl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac quipiyayaya 40 xihuitl quema mosihuajti ihuaya Rebeca tlen eliyaya iichpoca Betuel huan iicni Labán. Labán huan Betuel eliyayaj nopa arameos tlen itztoyaj ipan tlali Aram. ");
INSERT INTO nheBl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Huan Rebeca ax hueliyaya conepiya huan Isaac quitlajtlani TOTECO ipampa ya. Huan TOTECO quicajqui tlen quitlajtlani huan Rebeca conecuic. ");
INSERT INTO nheBl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Pero quinpixqui cuateme tlen motehuiyayaj iijtico huan moilhui: “Intla queja ni elis noyolis, ax huelis niquijiyohuis.” Huajca yajqui quitlajtlanito TOTECO para tlen queja nopa ipantiyaya, ");
INSERT INTO nheBl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","huan TOTECO quinanquili: “Ome coneme itztoque ipan moijti. Huan inijuanti huan ininteipa ixhuihua mochihuase ome xinach tlacame. Huan sesen quinpiyas miyac itlacajhua huan itztose ipan ome tlaltini. Ya pejtoque motehuíaj quema aya tlacatij, huan para nochipa ininteipa ixhuihua nojquiya motehuise. Se elis más tetic que ne seyoc. Huan nopa teipa ejquetl quipiyas más tlanahuatili que nopa achtohui ejquetl.” ");
INSERT INTO nheBl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Huan quema ajsic nopa tonali para Rebeca conepiyas, nelía quinpixqui cuateme. ");
INSERT INTO nheBl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Nopa achtohui ejquetl nesiyaya chichiltic huan quipixqui miyac itzoyo ipan nochi itlacayo. Huan quitocajtijque Esaú. (Esaú quinequi quiijtos Tlen Quipiya Miyac Itzoyo.) ");
INSERT INTO nheBl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Huan nimantzi tlacatqui ne seyoc tlen quiitzquilijtoya icotztla iachtohui ejca icni ica se ima. Yeca quitocajtijque Jacob. (Jacob quinequi quiijtos Tlen Tlaitzquía o Tlen Tlacajcayahua.) Huan Isaac quipiyayaya 60 xihuitl quema Rebeca conepixqui. ");
INSERT INTO nheBl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Huan nopa oquichpilme moscaltijque. Huan Esaú elqui se tlacatl tlen quipactía nejnemi cuatitla huan elqui se cuali tlapejquetl. Pero Jacob eliyaya se tlacatl tlen quipixqui iyolo huan quipactiyaya mocahuas ichaj. ");
INSERT INTO nheBl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Huan Isaac más quiicneli Esaú pampa quipactiyaya quicuas tlen quinmictiyaya quema tlapehuayaya, pero Rebeca quiicneli Jacob. ");
INSERT INTO nheBl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Huan se tonal quema Jacob quichihuayaya tlacualistli, Esaú mocuepqui tlen cuatitla nelsiyajtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Huan quiilhui iicni: ―Xinechchihuili se favor, xinechmaca se quentzi nopa tlacuali chichiltic tlen tijpiya nopano pampa ya niapismiqui. (Yeca Esaú nojquiya quitocajtiyayaj Edom tlen quinequi quiijtos Chichiltic.) ");
INSERT INTO nheBl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Huan Jacob quiilhui: ―Achtohui xinechmaca motequihuejcayo pampa tiachtohui ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Huajca Esaú quiilhui: ―Tiquita ya niapismiqui huan nopa tequihuejcayotl tlen nijpiya pampa niachtohui ejquetl ax nechpalehuis quema nimiquis. ");
INSERT INTO nheBl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Huajca Jacob quiilhui: ―Xijtestigojquetza Toteco Dios amantzi para noaxca. Huan Esaú quitestigojquetzqui Toteco huan queja nopa quipanoltili Jacob nopa tequihuejcayotl tlen eliyaya iaxca pampa achtohui ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Huajca Jacob quimacac Esaú pantzi huan se tlacualistli tlen nopa etl tlen siltic. Huan quema Esaú tlanqui tlacua, moquetzqui huan yajqui, niyon ax quichijqui cuenta intla quipolojtoya itequihuejcayo tlen achtohui ejquetl pampa ax quipatiitayaya. ");
INSERT INTO nheBl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ipan nopa tonali oncayaya se hueyi mayantli pampa ax oncayaya tlacualistli ipan nochi nopa tlali. Queja ni nojquiya panotoya achtohuiya quema Abraham noja itztoya. Huan yeca Isaac yajqui altepetl Gerar campa tlanahuatiyaya Abimelec, inintlanahuatijca filisteos. ");
INSERT INTO nheBl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nopano TOTECO monexti ica Isaac huan quiilhui: “Amo xiya tlali Egipto, ximocahua campa na nimitzilhuis ");
INSERT INTO nheBl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","nica ipan ni tlali. Huan na niitztos mohuaya huan nimitztiochihuas. Huan se tonal nimitzmacas ta ihuaya moteipa ixhuihua nochi ni tlaltini. Queja nopa nijtlamichihuas tlen nijtencahuili motata Abraham para temachtli nijchihuas. ");
INSERT INTO nheBl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Huan nijchihuas ma elica nelmiyac moteipa ixhuihua queja sitlalime ipan elhuicac. Huan niquinmacas nochi ni tlaltini. Nojquiya niquintiochihuas nochi tlacame ipan nochi tlaltini ipan tlaltepactli ipampa moixhui. ");
INSERT INTO nheBl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nochi ya ni nijchihuas pampa Abraham nechneltoquili huan quichijqui tlen niquilhui. Quitoquili nochi tlen niquilhui para monequi quichihuas. Quitoquili notlanahuatil, notlamachtil huan nochi noleyes.” ");
INSERT INTO nheBl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Huajca Isaac mocajqui ipan altepetl Gerar. ");
INSERT INTO nheBl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Huan quema nopa tlacame tlen nopano ehuaj quitlajtlanijque quejatza quiitayaya Rebeca, Isaac majmajqui quiijtos eliyaya isihua huan istlacatqui huan quiijto para eliyaya iicni. Isaac moilhui nopa tlacame tlen nopano ehuaj quimictisquíaj huan mocuilisquíaj Rebeca pampa eliyaya nelyejyectzi. ");
INSERT INTO nheBl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Huan quema Isaac mocajtoya nopano miyac tonali, se tonal Abimelec tlachixtoya ipan iventana huan quiitac para Isaac quinajnahuayaya isihua Rebeca. ");
INSERT INTO nheBl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Huajca tlatitlanqui ma quinotzatij huan quiilhui: ―Yajaya mosihua, ¿Ax que? Huajca, ¿para tlen tiquijto para eliyaya moicni? Huan Isaac tlananquili: ―Na nimoilhui nohueli nechmictisquíaj ipampa ya. ");
INSERT INTO nheBl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Huajca Abimelec quiilhui: ―¿Para tlen tinechcajcayajtoc ica ni tlamantli? San se quentzi huan se tlen ehua nica hueltosquía motectosquía ihuaya mosihua huan topani huetztosquía se tlatzacuiltilistli. ");
INSERT INTO nheBl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Huajca Tlanahuatijquetl Abimelec quinilhui nochi itlacajhua: ―Intla acajya quicuatotonis ni tlacatl o isihua, quipantis miquistli. ");
INSERT INTO nheBl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Huan ipan nopa xihuitl nopano ipan nopa tlali, Isaac tojqui huan quisentili miyac pixquistli hasta 100 hueltas tlen quitoctoya pampa TOTECO quitiochijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Huan Isaac moricojchijqui. Huan nochi tlen iaxca más momiyaquili hasta nelnelía mochijqui se hueyi tlacatl ica miyac chicahualistli. ");
INSERT INTO nheBl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Quinpixqui tlahuel miyac borregojme, chivojme, huacaxme huan tlatequipanohuani. Huajca nopa filisteos pejque quicualancaitaj. ");
INSERT INTO nheBl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Huan quitemitijque ica tlali nochi iamel Isaac. Ni ameltini quiixaltijtoyaj itlatequipanojcahua Abraham, itata Isaac, huejcajquiya quema noja itztoyaj ipan nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Huajca teipa Tlanahuatijquetl Abimelec quiilhui Isaac: ―Xiya seyoc lado pampa ica nochi motlatequipanojcahua huan motlapiyalhua nelía inmiyaquij huan initztoque más intetique que tojuanti. ");
INSERT INTO nheBl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Huajca Isaac huan nochi tlen itztoyaj ihuaya yajque. Huan quiquetzque ininchajchaj tlen yoyomitl ipan nopa tlamayamitl tlatlajco nopa tepetini nechca altepetl Gerar. Huan nopano mocajqui. ");
INSERT INTO nheBl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Huan Isaac sampa quitlapo nochi nopa ameli tlen itata quiixaltijtoya tlen filisteos quitzactoyaj quema ya mijqui. Huan sampa quitocajti sesen ameli queja itata quintocajtlalijtoya achtohuiya. ");
INSERT INTO nheBl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Huan se tonal itlatequipanojcahua Isaac quichihuayayaj se ameli ipan nopa tlamayamitl huan quipantijque campa meyayaya se yejyectzi atl. ");
INSERT INTO nheBl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Pero altepetl Gerar ehuani tlen quinmocuitlahuiyayaj borregojme pejque monajnanquilíaj ininhuaya tlen quinmocuitlahuiyayaj iborregojhua Isaac. Quinilhuiyayaj para nopa atl eliyaya iniaxca. Yeca Isaac quitocajti nopa ameli Esek pampa ica monajnanquilijque. (Esek quinequi quiijtos Tlanajnanquilistli.) ");
INSERT INTO nheBl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Huan teipa itlatequipanojcahua Isaac quitlapojque seyoc ameli, pero sampa ica motehuijque. Huan nopa ameli quitocajti Sitna. (Sitna quinequi quiijtos Cualancaitali.) ");
INSERT INTO nheBl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Huajca Isaac quincajtejqui huan moiyocaquixti huejca. Nopano quiixalti seyoc ameli, pero axaca yajqui nepa para quitehuis. Huajca quitocajti Rehobot. (Rehobot quinequi quiijtos Hueyi Tlali.) Queja nopa quitocajti pampa Isaac quiijto para ama TOTECO quitiochijtoc huan quimacatoc se hueyi tlali tlen quiaxili para nochi itlapiyalhua ma moscaltica. ");
INSERT INTO nheBl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Huan Isaac yajqui campa itoca Beerseba, ");
INSERT INTO nheBl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","huan nopa tlayohua TOTECO monexti ica ya huan quiilhui: “Na niDios tlen niiTeco motata, Abraham. Amo ximajmahui, na niitztoc mohuaya. Nimitztiochihuas huan niquinmiyaquilis moteipa ixhuihua, pampa niquilnamiqui tlen nijtencahuili notlatequipanojca Abraham.” ");
INSERT INTO nheBl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Huajca Isaac quisencajqui se tlaixpamitl nopano huan quihueyichijqui TOTECO. Huan nopano quiquetzqui ichaj tlen yoyomitl, huan itlatequipanojcahua quiixaltijque se ameli. ");
INSERT INTO nheBl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Se tonal Abimelec hualajqui tlen altepetl Gerar para mocamahuis ihuaya Isaac. Ihuaya hualayaya ihuampo Ahusat tlen quitlalnamictiyaya huan Ficol tlen quinnahuatiyaya isoldados. ");
INSERT INTO nheBl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Huan Isaac quintlajtlani: ―¿Para tlen inhualajque innechitaquij? Innechtojtocaque ipan imotlal pampa innechcualancaitayayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Huan quiilhuijque: ―Tiquitztoque para TOTECO itztoc mohuaya, huan timoilhuíaj cuali ma tijchihuaca se tlajtoli. Nopa tlajtoli elis ya ni: ");
INSERT INTO nheBl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Xijtestigojquetza para ax quema titechcocos pampa tojuanti ax quema timitzcocojtoque. Nochipa timitzchihuilijtoque tlen cuali huan quema monejqui timoiyocaquixtis tlen tojuanti, timitzmajcajque ica cuali queja titohuampo. Huan ama xiquita quejatza TOTECO mitztiochijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Huajca Isaac quinchihuili se hueyi tlacualistli, huan san sejco inijuanti tlacuajque huan tlaique. ");
INSERT INTO nheBl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Huan hualmostla ica ijnaloc, mejque huan quitestigojquetzque Toteco para ax quema moixpanosquíaj se ica seyoc. Teipa Isaac quinnahuatijtejqui ica cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ipan nopa tonal, itlatequipanojcahua Isaac quiyolmelahuacoj para quipantijtoyaj atl campa tlaxahuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Huan Isaac quitocajti nopa ameli Seba. (Seba quinequi quiijtos Campa Tlatestigojquetzque.) Huan yeca nopa altepetl hasta ama itoca Beerseba. (Beerseba quinequi quiijtos Ameli Campa Tlatestigojquetzque.) ");
INSERT INTO nheBl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Huan quema Esaú quipiyayaya 40 xihuitl mosihuajti ihuaya Judit tlen eliyaya iichpoca Beeri se heteo tlacatl. Huan nojquiya Esaú mosihuajti ihuaya Basemat iichpoca seyoc heteo tlacatl tlen itoca Elón. ");
INSERT INTO nheBl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Huan ni ome sihuame quinmacaque Isaac huan Rebeca miyac cuesoli. ");
INSERT INTO nheBl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Huan Isaac eliyaya nelhuehuentzi huan ayoc tlachiyayaya. Huan se tonal quinotzqui Esaú, icone tlen achtohui ejquetl huan quiilhui: ―¡Nocone! Huan Esaú quinanquili: ―Xinechilhui tlaque tijnequi, Papá. ");
INSERT INTO nheBl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Huan Isaac quiijto: ―Ya tiquita para ninelhuehuentzi huan tlen hueli tonali hueli nimiquis. ");
INSERT INTO nheBl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yeca nijnequi xiya cuatitla ica mocuahuitol huan cuatlamintli para xijmictiti se masatl. ");
INSERT INTO nheBl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Teipa xijsencahua se tlacualistli ajhuiyac queja na nechpactía huan xijhualica para nijcuas. Huan huajca nimitzmacas notlatiochihual iixtla Toteco quema aya nimiqui. ");
INSERT INTO nheBl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Pero Rebeca quitlacaquilijtoya tlen Isaac quiilhuiyaya Esaú. Huan teipa quema Esaú yajqui cuatitla para quiitzquiti se masatl para itata, ");
INSERT INTO nheBl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca quinotzqui Jacob, iteipa ejca huan quiilhui: ―Nijcajqui para motata mocamahuiyaya ihuaya moicni Esaú huan quiilhuiyaya, ");
INSERT INTO nheBl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","para ma quiitzquiti se masatl huan quisencahuilis se tlacualistli tlen ajhuiyac para quicuas. Quiijto para teipa quimacas itlatiochihual iixtla TOTECO quema aya miqui. ");
INSERT INTO nheBl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Huajca nocone, xijtlacaquili cuali tlen nimitzilhuis: ");
INSERT INTO nheBl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Xiya campa itztoque totlapiyalhua huan xinechhualiquili ome oquich chivojme tlen más cuali. Huan nijsencahuilis motata se tlacualistli ajhuiyac queja ya quipactía. ");
INSERT INTO nheBl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Huan teipa tijhuiquilis ma quicua, huan queja nopa mitztiochihuas iixtla Toteco quema aya miqui. ");
INSERT INTO nheBl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Pero Jacob quiilhui inana: ―Noicni quipiya miyac itzoyo ipan nochi itlacayo, huan na, axtle. ");
INSERT INTO nheBl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Intla notata nechpanitzquis, quimatis ax niEsaú. Huan moilhuis para san ica nimahuiltía, huajca nijchihuas ma nechtelchihuas huan ax nechtiochihuas. ");
INSERT INTO nheBl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Pero inana quinanquili: ―Nocone, na nopani ma huetzi nopa tlatelchihuali. Ta xijchihua tlen nimitzilhuía huan xinechhualiquili nopa oquich chivojme. ");
INSERT INTO nheBl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Huajca Jacob quincuito nopa oquich chivojme huan quinhuicac campa inana. Huan inana quisencajqui se tlacualistli ajhuiyac queja Isaac quipactiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Huan Rebeca quiquixti nopa yoyomitl tlen más cuali tlen Esaú, iachtohui cone, quiajcoctoya ipan ichaj. Huan nopa yoyomitl quitlalili Jacob tlen elqui iteipa cone. ");
INSERT INTO nheBl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Huan quinquixtili inincuetlaxo nopa chivojme ica nochi iniijhuiyo huan ica quipijqui Jacob ipan ima huan iquechtla campa ax quipiyayaya itzoyo. ");
INSERT INTO nheBl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Teipa quimacac nopa tlacualistli huan nopa pantzi tlen quisencajtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Huajca Jacob calajqui campa itztoya itata huan quiilhui: ―¡Papá! Huan Isaac quinanquili: ―Nica niitztoc. ¿Ajqueya ta, nocone? ");
INSERT INTO nheBl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Huan Jacob quiilhui: ―Na niEsaú, moachtohui ejca cone. Ya nijchijtoc tlen tinechilhui. Ximehua, ximosehui huan xijcua ni masatl tlen nijmictito huan xinechmaca motlatiochihual. ");
INSERT INTO nheBl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Huajca Isaac quitlajtlani: ―¿Quejatza huelqui tijpanti nelnimantzi, nocone? Huan Jacob quinanquili: ―TOTECO, moDios, nechpalehui para nijpanti. ");
INSERT INTO nheBl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Pero Isaac quiilhui: ―Ximonechcahui huan xinechcahuili ma nimitzijitzquis intla nelía tinocone Esaú. ");
INSERT INTO nheBl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Huan Jacob monechcahui para ma quiitzqui itata. Huan Isaac quiijto: “Nijcaqui motos queja Jacob, pero moma eltoc queja tiEsaú.” ");
INSERT INTO nheBl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Huan Isaac ax quimatqui intla eliyaya Jacob pampa ima quipiyayaya miyac itzoyo queja iicni, Esaú. Huajca quema quimacasquía itlatiochihual iixtla Toteco, ");
INSERT INTO nheBl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","sampa quitlajtlani: ―¿Nelía ta tinocone Esaú? Huan Jacob quiilhui: ―Quena, na niEsaú. ");
INSERT INTO nheBl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Huajca itata quiilhui: ―Xinechtequili, nocone, para nijcuas tlen tijmictito, huan teipa nimitzmacas notlatiochihual. Huajca Jacob quitequili para ma tlacua itata huan nojquiya quihualiquili xocomeca atl. Huan Isaac tlacuajqui, ");
INSERT INTO nheBl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","huan teipa quiilhui: ―Ximonechcahui, nocone huan xinechtzoponi. ");
INSERT INTO nheBl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Huan quema Jacob monechcahui para quitzoponis, Isaac quiijnejqui iyoyo huan moilhui huelis nelía iachtohui ejca cone. Huajca quitiochijqui ica ni tlajtoli: “Ajhuiyac tlen niquijnecui tlen nocone. Mijmiyotía queja cuatitlamitl tlen TOTECO quitiochijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Toteco Dios ma mitzmaca atl tlen elhuicac, para tijpiyas pixquistli tlen más cuali ipan motlal. Ma mitzmaca miyac trigo, huan miyac xocomeca atl. ");
INSERT INTO nheBl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Miyac tlacame ma mitztequipanoca. Ma motlancuaquetzaca moixpa, tlacame tlen miyac tlaltini. Xiquinnahuati moicnihua. ¡Huan ma motlancuaquetzaca moixtla nochi tlen monana quintlacatilti! Tlen mitztelchihuase elise tlatelchihualme. Huan tlen mitztiochihuase elise tlatiochihualme.” ");
INSERT INTO nheBl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Teipa Isaac tlanqui quitiochihua Jacob huan quema Jacob quisayaya tlen campa itata, Esaú mocuepqui tlen tlapehuato. ");
INSERT INTO nheBl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Huan Esaú nojquiya quisencajqui se tlacualistli ajhuiyac huan quihuiquili itata. Huan quiilhui: ―Ximoquetza, Papá. Xijcua ni tlen nijpehuato huan xinechmaca motlatiochihual iixtla Toteco. ");
INSERT INTO nheBl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Huajca Isaac quitlajtlani: ―¿Ajqueya ta? Huan ya tlananquili: ―Na niEsaú, moachtohui ejca. ");
INSERT INTO nheBl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Huan Isaac ax quimatiyaya tlaque quiijtos. Huan ica itos huihuipicayaya, quiijto: ―Huajca, ¿ajqueya nechhualiquili nopa tlacualistli tlen quicuito ipan cuatitlamitl? Na nijcuajqui quema aya tiajsiyaya huan nijmacac nopa tlatiochihualistli, huan ya nelía elis tlatiochihuali. ");
INSERT INTO nheBl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Quema Esaú quicajqui tlen itata quiijto, tzajtzic tlahuel chicahuac ica miyac cuesoli huan teipa quiijto: ―¡Xinechtiochihua nojquiya, Papá! ");
INSERT INTO nheBl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Pero Isaac quinanquili: ―Ya hualajqui moicni, huan nechcajcayajqui. Quihuicac nopa tlatiochihuali tlen eliyaya para ta. ");
INSERT INTO nheBl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Huan Esaú quiijto: ―¡Yeca quitocajtijque Jacob! (Jacob quinequi quiijtos Tlacajcayajquetl.) ¡Ica ni mochihua ome hueltas nechcajcayajtoc! Achtohui nechquixtili notequihuejcayo tlen nechtocaro pampa niachtohui ejquetl. Huan ama nechquixtilijtoc notlatiochihual. ¿Ax ticajcoctoc seyoc tlatiochihuali para na? ");
INSERT INTO nheBl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Huajca Isaac quinanquili: ―Xiquita, na nijmacatoc Jacob tlanahuatili para mitznahuatis. Niquijtojtoc para iteixmatcahua elise itlatequipanojcahua. Niquilhuijtoc para quipiyas miyac trigo huan miyac xocomeca atl. ¿Tlaque mocahuas para huelis nimitzchihuilis, nocone? ");
INSERT INTO nheBl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Huan Esaú noja quiilhui: ―¿San hueli titemaca san se tlatiochihuali, Papá? ¡Xinechtiochihua nojquiya! Huan Esaú sampa tlahuejchijqui huan chocac. ");
INSERT INTO nheBl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Huajca Isaac quiilhui: “Tiitztos huejca ipan tlali tlen ax hueli tlaixhualtía, huan campa ax tlaahuetzis. ");
INSERT INTO nheBl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Huan monequis timomanahuis ica momachete. Tielis tiitlatequipanojca moicni, pero quema ayoc huelis tiquijiyohuis más, timoquixtis imaco.” ");
INSERT INTO nheBl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Huajca Esaú quicualancaitac Jacob pampa quiixtequilijtoya itlatiochihual huan pejqui moilhuía: “Ya nechca para miquis notata. Quema ya panotos nopa cuesoli, nijmictis noicni, Jacob.” ");
INSERT INTO nheBl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Huan Rebeca quimatqui tlen Esaú moilhuiyaya quichihuas, huajca Rebeca tlatitlanqui ma quinotzatij Jacob. Huan quema ajsico, Rebeca quiilhui: ―Xiquita, ica nopa tlen tijchihuili moicni, Esaú, yajaya ama quinequi mitzmictis. ");
INSERT INTO nheBl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Yeca, nocone, xinechtlacaquili; xicholo nimantzi hasta tlali Harán hasta ichaj noicni, Labán. ");
INSERT INTO nheBl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ximocahua nopano se ome xihuitl hasta quema ayoc cualantos moicni. ");
INSERT INTO nheBl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Huan quema ya quiilcajtos tlen tijchihuilijtoc, nitlatitlanis ma mitzyolmelahuaca para ximocuepa. ¡Ax nijnequi niquinpolos ome noconehua ipan san se tonal! ");
INSERT INTO nheBl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Huan teipa Rebeca quiilhui Isaac: ―Ya nisiyajtoc ipampa ni heteo ichpocame tlen Esaú mocuilijtoc. Intla Jacob mocuilis se ichpocatl tlen ehua nica ipan tlali Canaán, más cuali ma nimiqui. ");
INSERT INTO nheBl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Huajca Isaac quinotzqui Jacob, huan quitiochijqui huan quiilhui: “Amo ximosihuajti ica se sihuatl tlen ni tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Xiya tlali Aram campa ichaj mohueyi tata Betuel huan ximosihuajti ihuaya se iichpoca motlayi Labán. ");
INSERT INTO nheBl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Toteco Tlen Quipiya Nochi Chicahualistli ma mitztiochihua huan ma mitzmaca miyac moixhuihua para ipan ta ma quisaca nelmiyac tlacame tlen itztose ipan miyac tlaltini. ");
INSERT INTO nheBl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Toteco ma mitzmaca ta huan moteipa ixhuihua nopa tlatiochihuali tlen quitencahuili Abraham. Ma inmechaxcati ni tlali campa ipan tiitztoque ama queja tiseyoc tlali ehuani pampa ya ni nopa tlali tlen quitlajtolcahuili Abraham para quinmacas iteipa ixhuihua.” ");
INSERT INTO nheBl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Huajca queja nopa Isaac quititlanqui Jacob ipan tlali Aram. Huan Jacob ajsito ichaj Labán tlen eliyaya icone Betuel tlen ehua tlali Aram. Huan Labán eliyaya iicni Rebeca tlen eliyaya inana Jacob huan Esaú. ");
INSERT INTO nheBl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú quimatqui para Isaac quimacac itlatiochihual Jacob huan quititlanqui ipan tlali Aram para ma mosihuajtiti nepa. Huan quinahuatijtoya ma ax mosihuajti ica se sihuatl tlen ehua tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nojquiya quimatqui para Jacob quistoya para tlali Aram queja itata huan inana quiilhuijtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Huajca Esaú momacac cuenta para itata ax quipactiyayaj sihuame tlen ehuaj tlali Canaán campa inijuanti itztoyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Yeca yajqui quiitato itlayi, Ismael, tlen nojquiya icone Abraham. Nopano mosihuajti ihuaya se iichpoca tlen itoca eliyaya Mahalat huan tlen eliyaya iicni Nevaiot. Huajca Mahalat mochijqui isihua Esaú ininhuaya nopa sequinoc sihuame cananeos tlen ya mocuilijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Huan Jacob quistoya altepetl Beerseba huan yajqui ipan nopa ojtli tlen yohui altepetl Harán. ");
INSERT INTO nheBl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Huan ajsic ipan se lugar huan nopano panoc nopa tlayohua pampa ya temotoya tonati. Huan quicuic se tetl huan quitequihui para itzonteto. Huan motejqui huan cochqui. ");
INSERT INTO nheBl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Huan quipixqui se temictli huan quiitayaya se escalera tlen ijcatoya tlalchi huan ajsiyaya hasta elhuicac. Huan ielhuicac ejcahua TOTECO ipan temoyayaj huan tlejcoyayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nojquiya quiitayaya para TOTECO Dios itztoya huejcapa huan quiilhuiyaya: “Na niininTeco mohueyi tata Abraham huan motata Isaac. Ta huan moteipa ixhuihua niquinmacas ni tlali campa amantzi tiitztoc. ");
INSERT INTO nheBl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Moteipa ixhuihua elise nelmiyac queja imiyaca tlalpotectli tlen axaca huelis quinpohuas. Huan mosemanase campa hueli. Yase hasta sur, huan norte, huan hasta campa quisa tonati huan hasta campa oncalaqui. Huan niquintiochihuas nochi familias ipan tlaltepactli ica ta huan moixhui. ");
INSERT INTO nheBl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na niitztoc mohuaya. Nimitzmocuitlahuis campa hueli campa tiyas huan nijchihuas ximocuepa ipan ni tlali. Ax nimitztlahuelcahuas. Nijchihuas nochi tlen mohuaya nimocajtoc nijchihuas.” ");
INSERT INTO nheBl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Huan quema Jacob isac, moilhui: “Nelía TOTECO itztoc ipan ni lugar huan ax nijmatiyaya.” ");
INSERT INTO nheBl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Huan Jacob majmajqui miyac huan moilhui: “¡Nica neltlatzejtzeloltic! ¡Nica eltoc ichaj Toteco! ¡Ni ipuerta elhuicac!” ");
INSERT INTO nheBl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Huan hualmostla Jacob mejqui cualca huan quicuic nopa tetl tlen quitequihuijtoya para itzonteto. Huan quiquetzqui queja se tlanextilijcayotl para nopano campa Toteco quicamahui. Huan nopa tetl quitequili aceite para quiiyocatlalis para Toteco. ");
INSERT INTO nheBl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Huan nechca nopano eltoya se altepetl tlen itoca Tlahuili, pero Jacob quipatili itoca huan quitlalili Betel. (Betel quinequi quiijtos Ichaj Toteco.) ");
INSERT INTO nheBl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Huan nopano Jacob quitestigojquetzqui Toteco Dios tlaque quichihuasquía huan quiijto: “Toteco, intla ta nohuaya tiitztos huan tinechmocuitlahuis ipan ni noojhui tlen nijchihua, huan intla tinechtlamacas huan tinechmacas tlen nimoquentis, huajca na nimitztequipanos. ");
INSERT INTO nheBl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Huan intla ax nimococos huan nimocuepas ica cuali ipan ichaj notata, huajca san ta, TOTECO, nimitzixmatis para noTeco. ");
INSERT INTO nheBl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Huan nica campa nijtlalijtoc ni tetl, elis mochaj, Toteco, campa nimitztencahuilis tlacajcahualistli. Huan nochipa nimitzmactilis se diezmo tlen nochi tlen tinechmacas.” ");
INSERT INTO nheBl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob sampa quiitzqui iojhui huan yajqui ipan se tlali nechca campa quisa tonati. ");
INSERT INTO nheBl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Huan nopano ipan potrero quiitac se ameli huan nechca mosentiliyayaj borregojme ipan eyi pamitl pampa nopa tlapiyalime momatque atlij ipan nopa ameli. Huan quitzactoyaj nopa ameli ica se tetl tlen nelhueyi. ");
INSERT INTO nheBl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Huan momajtoyaj nopa tlamocuitlahuiani ma mochiyase hasta quema ya mosentilijtose nochi nopa borregojme tlen sesen inijuanti iaxcahua huan san sejco quiijcueniyayaj nopa hueyi tetl. Teipa quinamacayayaj ininborregojhua huan teipa san sejco sampa quitzacuayayaj ica nopa hueyi tetl. ");
INSERT INTO nheBl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Huajca Jacob quintlajtlani nopa tlamocuitlahuiani: ―¿Canque imochaj, nohuampoyohua? Huan inijuanti tlananquilijque: ―Tihualahuij altepetl Harán. ");
INSERT INTO nheBl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Huajca quinilhui: ―¿Inquiixmatij Labán iixhui Nacor? Huan quiilhuijque: ―Quena, tiquixmatij. ");
INSERT INTO nheBl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Huan Jacob quinilhui: ―¿San cuali itztoc? Huan nopa tlamocuitlahuiani quiijtojque: ―Quena, itztoc cuali. Xiquita, ne huala iichpoca, Raquel, ihuaya iborregojhua. ");
INSERT INTO nheBl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Huajca Jacob quiijto: ―Noja cualca para inquintzacuase borregojme. ¿Para tlen ax inquinamacaj huan inquinhuicaj sampa ma tlacuajcuatij? ");
INSERT INTO nheBl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Pero nopa tlamocuitlahuiani quiijtojque: ―Ax hueli tijchihuaj. Monequi tijchiyase ma hualaca nochi borregojme huan tlamocuitlahuiani para sentic tiquijcuenise ni tetl tlen ica quitzacuaj ni ameli para tiquinamacase toborregojhua. ");
INSERT INTO nheBl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Huan quema Jacob noja camatiyaya ininhuaya, ajsico Raquel ihuaya iborregojhua itata pampa eltoya itequi para quinmocuitlahuis. ");
INSERT INTO nheBl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Huan nimantzi quema Jacob quiitac Raquel, iichpoca itlayi Labán, ica iborregojhua, yajqui huan iselti quiijcueni nopa tetl tlen ica quitzactoyaj nopa ameli. Huan quinamacac iborregojhua. ");
INSERT INTO nheBl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Teipa quitlajpalo huan quitzoponi huan pejqui choca chicahuac. ");
INSERT INTO nheBl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Huan Jacob quipohuili para yajaya eliyaya icone Rebeca tlen iicni Labán. Huajca Raquel motlalojtiyajqui huan quipohuilito itata. ");
INSERT INTO nheBl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Huan quema Labán quicajqui tlen Raquel quipohuili, para Jacob eliyaya icone isihua icni, motlalojtejqui para quiseliti. Huan quinajnahuajqui, huan quitzoponi huan quihuicac ichaj. Teipa Jacob quipohuili para tlen hualajqui. ");
INSERT INTO nheBl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Huan Labán quiilhui: “Melahuac ta huan na san se toeso.” Huan Jacob mocajqui ihuaya Labán se metztli. ");
INSERT INTO nheBl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Teipa Labán quiilhui: ―Ax hueli tinechtequipanos san tlapic san pampa nimoteixmatca. Xinechilhui quesqui tijnequi ma nimitztlaxtlahui. ");
INSERT INTO nheBl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Huan Labán quinpiyayaya ome iichpocahua. Nopa achtohui ejquetl itoca Lea huan nopa teipa ejquetl, Raquel. ");
INSERT INTO nheBl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Huan iixtiyolhua Lea ax quipiyayaya miyac fuerza, pero Raquel eliyaya senquistoc yejyectzi. ");
INSERT INTO nheBl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Huan Jacob quiixtocayaya Raquel huan huajca quinanquili: ―Nimitztequipanos chicome xihuitl intla tinechmacas Raquel para elis nosihua. ");
INSERT INTO nheBl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Huajca Labán tlananquili: ―Cualtitoc, más cuali nimitzmacas ta, huan ax se tlen ax niquixmati. Huajca ximocahua nohuaya huan nimitzmacas. ");
INSERT INTO nheBl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Huan queja nopa Jacob tequitqui chicome xihuitl para Raquel, pero ya ax quimatqui intla nelmiyac tonali pampa tlahuel quiicneliyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Huan quema tlanqui nopa chicome xihuitl, Jacob quiilhui Labán: ―Xinechmaca nosihua para ma nimosihuajti ihuaya pampa ya tlanqui nopa tonali tlen ica nimocajqui mohuaya para nitequitis. ");
INSERT INTO nheBl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Huajca Labán quinnotzqui nochi tlen itztoyaj nopano para ma hualaca ipan nopa ilhuitl tlen nenamictili. ");
INSERT INTO nheBl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pero ica tlayohua Labán quicuic Lea huan quihuiquili Jacob. Queja nopa quimacac Lea para elis isihua huan Jacob cochqui ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Nojquiya Labán quimacac Lea se sihua tlatequipanojquetl tlen itoca Zilpa para ma quipalehui. ");
INSERT INTO nheBl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Huan quema tlanesqui, Jacob momacac cuenta para cochtoya ihuaya Lea. Huajca yajqui quiilhuito Labán: ―¿Tlaque tinechchihuilijtoc? ¿Ax nimitztequipano para Raquel? Huajca ¿para tlen tinechcajcayajtoc? ");
INSERT INTO nheBl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Huan Labán quiilhui: ―Nica ax timomajtoque para monamictis nopa teipa ejquetl intla aya monamictía nopa achtohui ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Xicaxiti se samano ihuaya Lea, huan teipa nojquiya timitzmacase Raquel intla timotemacas titequitis nohuaya seyoc chicome xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Huan Jacob motemacac. Huan quema tlanqui se samano inenamictilis ihuaya Lea, Labán quimactili Raquel para isihua. ");
INSERT INTO nheBl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labán nojquiya quimacac Raquel se sihua tlatequipanojquetl tlen itoca Bilha para ma quipalehui. ");
INSERT INTO nheBl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Huan Jacob mosejcotili ihuaya Raquel huan más quiicneli que Lea, yonque monequiyaya quitequipanos Labán seyoc chicome xihuitl ipampa ya. ");
INSERT INTO nheBl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Huan quema TOTECO quiitac para Jacob ax quiicneliyaya Lea, quichijqui ma conepiya, pero Raquel quichijqui ma ax conepiya. ");
INSERT INTO nheBl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Huan Lea conecuic huan quipixqui se icone tlen quitocajti Rubén. (Rubén quinequi quiijtos Quiitac Nocuesol.) Queja nopa quitocajti pampa quiijto: “TOTECO quiitac quejatza tlahuel nimocuesohuayaya huan nechmacatoc se conetl, yeca ama nohuehue nechnequis.” ");
INSERT INTO nheBl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Teipa Lea quipixqui seyoc icone tlen quitocajti Simeón. (Simeón quinequi quiijtos Se Tlen Tlacaqui.) Queja nopa quitocajti pampa Lea quiijto: “TOTECO quicactoc para ax nechicnelía huan yeca nechmacac seyoc nocone.” ");
INSERT INTO nheBl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Huan seyoc huelta Lea quipixqui seyoc icone huan quitocajti Leví. (Leví quinequi quiijtos Motlatzquilijtoc.) Queja nopa quitocajti pampa quiijto: “Ama nohuehue itztos más nohuaya pampa ya nijmacatoc eyi oquichpilme.” ");
INSERT INTO nheBl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Huan Lea quipixqui seyoc icone tlen quitocajti Judá. (Judá quinequi quiijtos Nijpaquilismacas.) Queja nopa quitocajti pampa quiijto: “Ni huelta, quena, nijpaquilismacas TOTECO.” Teipa ayoc conepixqui. ");
INSERT INTO nheBl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Quema Raquel quiitac para ax hueliyaya quimaca coneme Jacob, pejqui quicualancaita iachtohui ejca icni, Lea, huan quiilhui ihuehue: ―Xinechmaca coneme pampa intla axtle, nimiquis. ");
INSERT INTO nheBl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Pero Jacob cualanqui ihuaya huan quiilhui: ―¡Ax na niDios! yajaya TOTECO tlen ax mitzcahuilía xiconecui. ");
INSERT INTO nheBl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Huajca Raquel quiilhui ihuehue: ―Huajca xijcui notlatequipanojca Bilha huan ximocahua ihuaya. Huan quema yajaya quinpiyas coneme, elis queja na noconehua. ");
INSERT INTO nheBl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Queja ni Raquel quimacac Jacob itlatequipanojca, Bilha, para ma quinpiya coneme ihuaya. Huan Jacob mosejcotili ihuaya Bilha, ");
INSERT INTO nheBl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","huan ya quimacac Jacob se icone. ");
INSERT INTO nheBl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Huajca Raquel quiijto: “Toteco quichijtoc tlen xitlahuac para na pampa quicajqui tlen nijtlajtlani huan nechmacac se nocone. Yeca ni oquichpil itoca elis Dan.” (Dan quinequi quiijtos Yajaya Quichijtoc Tlen Xitlahuac Para Na.) ");
INSERT INTO nheBl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Teipa Bilha, itlatequipanojca Raquel, quimacac Jacob seyoc icone. ");
INSERT INTO nheBl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Huajca Raquel quiijto: “Nimotehuijtoc ihuaya noachtohui ejca icni huan nijtlantoc. Yeca ni oquichpil itoca elis Neftalí.” (Neftalí quinequi quiijtos Notlatehuilis.) ");
INSERT INTO nheBl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Quema Lea quiitac para ayoc hueliyaya conepiya, quimacac Jacob itlatequipanojca, Zilpa para ma conepiya ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Huan quema Zilpa quimacac se icone Jacob, ");
INSERT INTO nheBl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea quiijto: “¡Se suerte! Yeca nopa oquichpil itoca elis Gad.” (Gad quinequi quiijtos Suerte.) ");
INSERT INTO nheBl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Teipa Zilpa quimacac Jacob seyoc icone, ");
INSERT INTO nheBl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","huan Lea quiijto: “¡Paquilistli! Ama sihuame quiijtose para nipaqui. Yeca nopa oquichpil itoca elis Aser.” (Aser quinequi quiijtos Paquilistli.) ");
INSERT INTO nheBl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Se tonal Rubén yajqui mila quema eliyaya trigo pixquistli huan nopano quipanti se tlamantli xihui pajtli huan quihuiquili inana, Lea. Nopa xihui pajtli itoca eliyaya mandrágoras huan nochi quiijtohuayayaj para nopa xihuitl quichihua se tlacatl más ma quiicneli isihua. Huan quema Raquel quiitac nopa cuali xihui pajtli, quiilhui Lea: ―Xinechchihuili se favor, xinechmaca se ome nopa xihui pajtli tlen mocone quihualicac. ");
INSERT INTO nheBl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Pero Lea quiilhui: ―¿Timoilhuía se quentzi tlamantli para tinechcuilijtoc nohuehue, huan nojquiya tijnequi tinechcuilis ni cuali xihui pajtli tlen nocone nechhualiquili? Huan Raquel quiijto: ―Intla tinechmacas se quentzi ixihui pajyo mocone, nijcahuilis Jacob ma cochi mohuaya ni tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Huajca ica tiotlac Lea quinamiquito Jacob quema hualayaya tlen imil huan quiilhui: ―Ama ticochis nohuaya pampa nimitzpatlatoc ica se cuali xihui pajtli tlen nocone nechhualiquili. Huajca nopa tlayohua Jacob cochqui ihuaya Lea. ");
INSERT INTO nheBl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Huan Toteco Dios quitlacaquili tlen Lea quitlajtlani, huan conecuic huan quimacac Jacob imacuilpa cone. ");
INSERT INTO nheBl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Huajca Lea quiijto: “Ni oquichpil itoca elis Isacar.” (Isacar quinequi quiijtos Se Tlaxtlahuili.) “Queja nopa nijtocajtis pampa Toteco Dios nechmacatoc notlaxtlahuil pampa nijmacac nohuehue notlatequipanojca.” ");
INSERT INTO nheBl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Teipa Lea conecuic huan quimacac Jacob ichicuasempa cone, ");
INSERT INTO nheBl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","huan quiijto: “Dios nechmacatoc se cuali regalo. Ama nohuehue nechtlepanitas pampa ya nijmacatoc chicuaseme oquichpilme. Yeca ni oquichpil itoca elis Zabulón.” (Zabulón quinequi quiijtos Tlatlepanitacayotl.) ");
INSERT INTO nheBl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Teipa Lea quipixqui se sihuapil tlen quitocajti Dina. ");
INSERT INTO nheBl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Pero Toteco Dios nojquiya quiilnamijqui Raquel. Quicajqui tlen quitlajtlaniyaya huan quicahuili ma conecui. ");
INSERT INTO nheBl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Huan Raquel conecuic huan quitlacatilti se oquichpil huan quiijto: “Toteco Dios nechquixtilijtoc nopa pinahualistli para ax hueli niconepiya. ");
INSERT INTO nheBl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ma TOTECO nechcahuili nijpiyas seyoc.” Yeca quitocajti José. (José quinequi quiijtos Seyoc.) ");
INSERT INTO nheBl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Teipa quema Raquel quitlacatiltijtoya José, Jacob quiilhui Labán: ―Xinechcahuili nimocuepas ipan notlal ");
INSERT INTO nheBl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ininhuaya noconehua huan nosihuajhua pampa nimitztequipanojtoc ininpampa inijuanti. Huajca ama xinechcahuili ma niya. Cuali tijmati queja nimitztequipanojtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Pero Labán quinanquili: ―Intla tinohuampo, ximocahua nohuaya pampa se tiocamanalojquetl tlen quimati tlaita para TOTECO nechilhui yajaya nechtiochijtoc mopampa ta. ");
INSERT INTO nheBl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","San xinechilhui quesqui tijnequi tijtlanis huan nimitztlaxtlahuis. ");
INSERT INTO nheBl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Huajca Jacob quiilhui: ―Cuali tijmati quejatza nimitztequipanojtoc huan quejatza niquinmocuitlahuijtoc motlapiyalhua. ");
INSERT INTO nheBl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nelquentzi tiquinpiyayaya quema aya nihualayaya huan ama tijpiya tlahuel miyac. TOTECO mitztiochijtoc campa hueli niitztoya, pero ¿hasta quema nipehuas nitequitis para nofamilia? ");
INSERT INTO nheBl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Huan Labán quiilhui: ―¿Quesqui tijnequi ma nimitztlaxtlahui? Huan Jacob quinanquili: ―Ax tleno xinechtlaxtlahui. Noja niquinmocuitlahuis moborregojhua intla tijselis tlen nimitzilhuis. ");
INSERT INTO nheBl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ma tiyaca campa moborregojhua huan ama niquiniyocaquixtis nochi chivojme huan borregojme tlen cuicuiltique huan pijpintojtique. Nochi chivojme tlen ax senquistoc chocoxtique huan nochi borregojme tlen ax senquistoc chipahuaque elise noaxcahua. Ya nopa elis notlaxtlahuil. ");
INSERT INTO nheBl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Queja nopa mostla huiptla, huelis tijtlachiliqui tlen nijtlantoc huan nimantzi tijmatis intla nijchihua tlen cuali mohuaya o axtle. Pampa intla ipan notlapiyalhua oncas chivojme tlen chocoxtique huan borregojme tlen chipahuaque, huajca tijmatis ya nopa nimitzixtequilijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Huan Labán quiijto: ―Cualtitoc, queja nopa ma eli. ");
INSERT INTO nheBl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Huan ipan nopa tonal Labán quiniyocaquixti nochi pilborregojtzitzi tlen cuicuiltique, huan nochi chivojme tlen pintojtique o tlen quipixtoya quentzi chipahuac, huan quinmacac iconehua Jacob para ma quinmocuitlahuica. ");
INSERT INTO nheBl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Teipa iconehua quinhuicaque huejca queja eyi tonali tlen ojtli ihuejcaca tlen ichaj Jacob. Huan Jacob noja mocajqui huan quinmocuitlahui iborregojhua Labán. ");
INSERT INTO nheBl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Huan Jacob quitzontejqui cuamacuayotl xoxohuic tlen nopa cuatini álamo, almendro huan castaño, huan iyocatzitzi quixixinqui para ma nesi cuicuiltic, chipahuac huan chocoxtic. ");
INSERT INTO nheBl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Teipa nopa pitzajcuahuitl quitlali campa atliyayaj nopa tlapiyalime pampa nopano momatque momamaj. Huan ya nopa quichihuayaya para ininconehua ma tlacatica cuicuiltique, majmanchadojtique huan pijpintojtique. ");
INSERT INTO nheBl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Huan Jacob quiniyocaquixtiyaya nopa sihua borregojme tlen senquistoc chipahuaque tlen eliyaya iaxcahua Labán huan ax quincahuiliyaya ioquich borregojhua Labán tlen chipahuaque ma quinnechcahuica para ma quinconemacaca. San quincahuiliyaya ma quinmamaltica oquich borregojme tlen yayahuique tlen ya iaxcahua para ma quinpiyaca ininconehua tlen cuicuiltique huan yeca ininconehua elise iaxcahua ya. Queja nopa Jacob quisencajqui tlen ya itlapiyalhua iyoca tlen itlapiyalhua Labán. ");
INSERT INTO nheBl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nojquiya mojmostla quema nopa tlapiyalime tlen tomahuaque huan tetique momamayayaj, Jacob quitlaliyaya nopa pitzajcuahuitl tlen iyocatzitzi quixixintoya campa atliyayaj para ma quiitaca. ");
INSERT INTO nheBl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pero quema hualayayaj tlapiyalime tlen cocoxquetique, ax quitlaliyaya nopa pitzajcuahuitl. Yeca nopa tlapiyalime tlen más cocoxquetique mocajque para Labán huan tlen más tomahuaque para Jacob. ");
INSERT INTO nheBl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Queja nopa Jacob moricojchijqui huan quinpixqui tlahuel miyac borregojme. Nojquiya quinpixqui miyac tlaca tlatequipanohuani huan sihua tlatequipanohuani huan tlahuel miyac camellos huan burrojme. ");
INSERT INTO nheBl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Pero Jacob quimatqui para iconehua Labán quiijtojtinemiyayaj para yajaya quicuitoya nochi tlen iaxca inintata, Labán huan ica ya nopa Jacob moricojchijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nojquiya momacac cuenta para Labán ayoc quitlachiliyaya cuali queja achtohuiya. ");
INSERT INTO nheBl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Huajca TOTECO quiilhui Jacob: “Ximocuepa itlal motatahua campa itztoque moteixmatcahua huan na niyas mohuaya.” ");
INSERT INTO nheBl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Huajca Jacob tlatitlanqui ma quinnotzatij Raquel huan Lea para ma hualaca ipan nopa potrero campa yajaya itztoya ihuaya iborregojhua. ");
INSERT INTO nheBl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Huan Jacob quinilhui: ―Nimomaca cuenta para imotata ayoc nechita san se queja achtohuiya, pero noTeco Dios tlen notata quitequipanohua nochipa nohuaya nemi. ");
INSERT INTO nheBl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Cuali inquimatij nijtequipanojtoc imotata hasta campa nihueltoc, ");
INSERT INTO nheBl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","huan ya nechcajcayajtoc huan nechpatilijtoc notlaxtlahuil majtlactli hueltas. Pero yonque ya nopa, Toteco Dios ax quicahuilijtoc ma nechcoco. ");
INSERT INTO nheBl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Quema Labán quiijto nechtlaxtlahuis ica tlapiyalime tlen manchadojtique, nochi tlacatiyayaj manchadojtique. Huan quema quiijto nechtlaxtlahuis ica tlen cuicuiltique, nochi tlacatiyayaj cuicuiltique. ");
INSERT INTO nheBl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Queja nopa Toteco Dios quicuili itlapiyalhua para nechmacas. ");
INSERT INTO nheBl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Se tonal quema nopa tlapiyalime momamayayaj, nijpixqui se temictli. Huan ipan temictli niquitac para nochi oquich chivojme tlen tlamamayayaj elque cuicuiltique, manchadojtique huan pijpintojtique. ");
INSERT INTO nheBl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ipan nopa temictli ielhuicac ejca Toteco Dios nechnojnotzqui ica notoca huan nijnanquili: ‘Nica niitztoc.’ ");
INSERT INTO nheBl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Huajca yajaya nechilhui: ‘Xijtlachili cuali huan tiquitas para nochi oquichme tlen quinconemacaj nopa sihua borregojme itztoque cuicuiltique, manchadojtique huan pijpintojtique. Queja nopa eltoc pampa niquitztoc nochi tlen ax xitlahuac mitzchihuilijtoc Labán. ");
INSERT INTO nheBl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Na nimoTeco tlen nimonexti ipan Betel campa ta tijquetzqui nopa tetl queja se tlanextilijcayotl, huan tinechtlajtolcahuili tlen tinechchihuilisquía. ¡Xiisihui huan xiquisa tlen nica huan ximocuepa ipan nopa tlali campa titlacatqui!’ Queja nopa Toteco nechilhui.” ");
INSERT INTO nheBl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Huajca Raquel huan Lea tlananquilijque: ―Tojuanti ayoc tleno tijpiyaj ipan ichaj totata. ");
INSERT INTO nheBl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Techchihua queja ax techixmati. Technamacac huan nochi tlen quiseli topampa tojuanti ya quitlamilti. ");
INSERT INTO nheBl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nelía nochi ricojyotl tlen Toteco Dios quiquixtilijtoc totata eltoc toaxca huan iniaxca toconehua. Huajca xijchihua nochi tlen Toteco Dios mitznahuatijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Huajca Jacob mocualtlali para mocuepas ipan tlali Canaán campa itztoya itata, Isaac. Quinilhui iconehua huan isihuajhua ma tlejcoca ipan camellos. Huan quicuic nochi tlen iniaxca huan quistejque ipan ojtli. Nojquiya quinhuicac nochi tlapiyalime tlen quinselijtoya ipampa itequi ipan tlali Aram. Queja nopa quisqui para mocuepas tlali Canaán campa itztoya itata, Isaac. ");
INSERT INTO nheBl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Huan Labán yajtoya huejca para quinximas iborregojhua huan Raquel quiixtequili itiotzitzi para quihuicas ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nojquiya Jacob quicajcayajqui Labán nopa Aram ejquetl pampa ax quiilhui intla quisasquía. ");
INSERT INTO nheBl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","San cholojtejqui ica nochi tlen iaxca, huan quipanoc nopa atemitl Éufrates huan yajqui campa nopa tepetini ipan tlali Galaad. ");
INSERT INTO nheBl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Eyi tonali teipa, quiilhuijque Labán para Jacob cholojtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Huajca Labán ihuaya iteixmatcahua yajqui quintepotztocatiyajqui huan ica chicome tonali quinajsitoj ipan cuatitla ipan tlali Galaad. ");
INSERT INTO nheBl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Pero nopa tlayohua Toteco Dios monexti ica Labán nopa tlali Aram ejquetl, ipan se temictli huan quiilhui: “Ximotlachili para amo xijnojnotza Jacob ica cualantli.” ");
INSERT INTO nheBl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Huan Jacob quiquetztoya ichaj tlen yoyomitl campa tepetini ipan tlali Galaad huan nopano Labán quiajsito. Huan nojquiya nopano Labán quiquetzqui ichaj tlen yoyomitl. ");
INSERT INTO nheBl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Huan Labán quitlajtlani Jacob: ―¿Tlaque tijchijtoc? ¿Para tlen tinechcajcayajtoc? ¡Tiquinhualicatoc nica noichpocahua queja itztosquíaj ipan se tlatehuilistli! ");
INSERT INTO nheBl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Para tlen tinechcajcayajtoc huan ticholojtejqui huan ax tleno tinechilhui? Intla nijmajtosquía, na nimitzmacajtosquía ica paquilistli, huan ica tlapitzali, huan tambores huan arpa. ");
INSERT INTO nheBl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Niyon ax tinechcahuili ma niquintzoponi noichpocahua huan noixhuihua. ¡Tijchijqui se huihuiyotl! ");
INSERT INTO nheBl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Na nihueltosquía nimechchihuilijtosquía tlen fiero, pero tlayohua nechnojnotzqui Toteco Dios tlen motata quitequipanohua huan nechilhui ma nimotlachili para ax nimitznojnotzas ica cualantli. ");
INSERT INTO nheBl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Intla nelía tiquistoc pampa tijnequi timocuepas ichaj motata, cualtitoc. Pero ¿para tlen tinechixtequili nototiotzitzi? ");
INSERT INTO nheBl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Huajca Jacob quinanquili Labán: ―Nelía nimajmajqui. Nimoilhui para nohueli tinechquixtilisquía moichpocahua yonque ax nijnequisquía. ");
INSERT INTO nheBl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pero intla se tlen nica itztoc quipiya motiotzitzi, ¡ma miqui! Toteixmatcahua nica itztoque testigos. Huajca xijtemo intla tijhualicaj se tlamantli tlen moaxca huan intla tijpantía, xijhuica. Pero Jacob ax quimatiyaya intla Raquel quiixtectoya nopa itotiotzitzi. ");
INSERT INTO nheBl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Huajca Labán calajqui ipan ichaj Jacob huan ipan ininchaj nopa ome sihua tlatequipanohuani. Teipa calajqui ipan ichaj Lea, pero ax quinpanti itotiotzitzi. Huan quema quisayaya ipan ichaj Lea para calaquis ipan ichaj Raquel, ");
INSERT INTO nheBl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raquel quincuic nopa totiotzitzi huan quitlali iijtic tlen ica quipejpechtía icamello huan ipan mosehui. Huan Labán quintemo nochi calijtic huan ax quinpanti. ");
INSERT INTO nheBl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Huan Raquel quiilhui: ―Papá, amo xicualani intla ax nimotlalana moixtla pampa ama nijpiya nococolis tlen totequijya tisihuame. Huan Labán quintemo itotiotzitzi campa hueli, pero ax quinpanti. ");
INSERT INTO nheBl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Huan Jacob cualanqui huan quiajhuac Labán ica ni tlajtoli: ―¿Tlaque ax cuali nijchijtoc? ¿Catlía notlajtlacol tlen ica miyac cualantli tinechtepotztocatoc? ");
INSERT INTO nheBl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tijtlajtlachilijtoc nochi tlamantli tlen noaxca huan ¿tlaque tijpantijtoc tlen mochaj? ¡Xijtlali nica iixtla moteixmatcahua huan noteixmatcahua para ma quiijtoca ajqueya tlen tiome quiijtohua tlen melahuac! ");
INSERT INTO nheBl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ica nopa 20 xihuitl tlen nitequitqui mohuaya, ax quema moconetlahuisojque moborregojhua, niyon mochivojhua huan ax quema nijcuajqui niyon se. ");
INSERT INTO nheBl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ax quema nimitzhualiquili tlapiyalime tlen quinmictiyayaj tecuanime. San na nitlaxtlahuayaya ipampa tlen polihuiyaya. Intla tonaya o tlayohua sequinoc nechtlaxtequiliyayaj, ta tinechinamayaya. ");
INSERT INTO nheBl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tonaya nitonalmiquiyaya huan tlayohua nisecmiquiyaya huan nimocochsolohuayaya. ");
INSERT INTO nheBl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Queja nopa eltoya para 20 xihuitl ipan mochaj. Para sesen moichpocahua nimitztequipano chicome xihuitl huan para notlapiyalhua nitequitqui chicuasen xihuitl. Huan majtlactli hueltas tinechpatili notlaxtlahuil. ");
INSERT INTO nheBl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Intla ax itztosquía nohuaya noTeco Dios tlen iTeco nohueyi tata Abraham huan notata Isaac, nelía tinechtitlanisquía san noma. Pero Toteco Dios quiitac quejatza nitequitqui hasta tlahuel nisiyajqui. Quiitac miyac nimocuesohuayaya huan yeca tlayohua mitzajhuac. ");
INSERT INTO nheBl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Huajca Labán quinanquili Jacob: ―Ni ichpocame noichpocahua, ni ixhuime noixhuihua. Ni tlapiyalime notlapiyalhua. Nochi tlen nica tiquita noaxca. Ax tleno ax cuali huelis niquinchihuilis noichpocahua o ininconehua. ");
INSERT INTO nheBl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yeca xihuala huan ma tijchihuaca se tlajtolsencahuali tlen elis queja se testigo tlen techitase tiome para ma tijchihuaca nochi tlen quiijtohua. ");
INSERT INTO nheBl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Huajca Jacob quicuic se tetl huan quiquetzqui queja se tlanextilijcayotl, ");
INSERT INTO nheBl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","huan quinilhui iteixmatcahua: ―¡Xijsentilica tetini! Huan nochi quisentilijque tetini huan quimontonojque huan nopano tlacuajque nechca nopa temontomitl. ");
INSERT INTO nheBl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Huan Labán quitocajti nopa lugar Jegar Sahaduta ipan ya itlajtol. (Jegar Sahaduta quinequi quiijtos Testigo.) Huan Jacob quitocajti Galaad ipan tlen ya itlajtol. (Galaad ipan itlajtol Jacob quinequi quiijtos Testigo.) ");
INSERT INTO nheBl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Huajca Labán quiilhui: ―Ni temontomitl mocahuas queja se testigo tlen techitas tiome para ma tijtlamichihuaca tlen tiquijtojque. Huan yeca teipa motocajti Galaad nopano, ");
INSERT INTO nheBl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","huan nojquiya itoca elqui Mizpa. (Mizpa quinequi quiijtos Se Torre Tlen Tlachiya.) Pampa Labán quiijto: ―Ma TOTECO techtlachili tiome quema ayoc huelis timoitase. ");
INSERT INTO nheBl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Huan intla tiquincualancaitas noichpocahua o timocuilis sequinoc sihuame, yonque ax niaqui para niquitas, xijmati para san yajaya Toteco Dios quitlachilis. ");
INSERT INTO nheBl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Huan Labán noja quiilhui Jacob: ―Xiquita, nica nijtlalijtoc ni temontomitl tlen elis se tlanextilijcayotl tlatlajco tiome. ");
INSERT INTO nheBl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ni tetini elise testigos para niyon ta, niyon na, ax quema tijpanose ni nepamitl para timoixpanose. ");
INSERT INTO nheBl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Toteco Dios tlen iTeco mohueyi tata, Abraham, huan nohueyi tata, Nacor, ma quiijto ajqueya tlen tojuanti quichihua tlen cuali. Huajca Jacob quitestigojquetzqui Toteco tlen itata, Isaac, quihueyichihua. ");
INSERT INTO nheBl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Teipa nopano quimacac tlacajcahualistli Toteco huan quinnotzqui iteixmatcahua ma tlacuaquij. Huan nochi tlacuajque huan mocajque nopa tlayohua campa nopa tepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Hualmostla ica ijnaloc, Labán mejqui, huan quintzoponi iixhuihua, huan iichpocahua huan quintiochijqui. Teipa mocuepqui para itlal. ");
INSERT INTO nheBl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Huan Jacob quiitzqui iojhui huan yajqui, huan sequin ielhuicac ejcahua Toteco Dios quinamiquicoj. ");
INSERT INTO nheBl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Quema Jacob quinitac, quiijto: “Nica tonilijque Toteco Dios huan ielhuicac ejcahua.” Yeca quitocajti nopa lugar Mahanaim. (Mahanaim quinequi quiijtos Campa Ompamitl Tonilijque.) ");
INSERT INTO nheBl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Huan Jacob quintitlanqui itlayolmelajcahua imelac hasta Seir ipan tlali Edom para quiitatij iicni, Esaú. ");
INSERT INTO nheBl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Huan Jacob quinilhui: “Xiquilhuitij Esaú para niitlatequipanojca niitztoya ihuaya Labán nochi ni xihuitl, ");
INSERT INTO nheBl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","huan para niquinpiya huacaxme, burrojme, borregojme huan chivojme. Nojquiya niquinpiya tlatequipanohuani tlacame huan sihuame. Xiquilhuitij nimechtitlani innotlayolmelajcahua para inquiitase para yajaya ma quimati nihuala huan ma nechselis ica cuali.” ");
INSERT INTO nheBl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Huan quema nopa tlayolmelahuani mocuepque, quiilhuijque Jacob: ―Tiyajque tiquitatoj moicni, Esaú huan ya huala para mitzseliqui ininhuaya 400 tlacame. ");
INSERT INTO nheBl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Huan quema Jacob quicajqui ya nopa, majmajqui miyac huan pejqui tlahuel mocuesohua. Huajca quintlajcoxelo nopa tlacame tlen itztoyaj ihuaya huan san se quichijqui ica nopa borregojme, huacaxme huan camellos, ");
INSERT INTO nheBl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","pampa moilhui: “Intla Esaú huala ica imiyaca huan quintehuis se tlajco notlatequipanojcahua, huajca ne seyoc tlajco huelis cholose.” ");
INSERT INTO nheBl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Huan pejqui momaijtohua ica TOTECO huan quiilhui: “Toteco Dios, ta tlen tiiTeco nohueyi tata Abraham huan notata Isaac. Ta tinechilhui ma nimocuepa campa noteixmatcahua ipan notlal huan tijchihuasquía nochi ma quisa cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ax quinamiqui tinechtlasojtlas huan tinechchihuilis tlen timocajtoc para tijchihuas. Quema niquisqui notlal huan nijpanoc ni atemitl Jordán, san nocuatopil nijpiyayaya, huan ama niquinpiya miyac noconehua hasta mochihuaj ome hueyi pamitl pampa hueyi tinechtiochijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Toteco Dios, ama se favor, xinechmanahui imaco noicni, Esaú. Niquimacasi para hualas nechmictis huan quinmictiqui ni sihuame huan coneme. ");
INSERT INTO nheBl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Pero ta tiquijtojtoc tijchihuas para nochi ma quisa cuali huan para noteipa ixhuihua elise nelmiyac queja xali nepa ipan hueyi atl tlen ax hueli mopohua.” ");
INSERT INTO nheBl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Huan nopa tlayohua Jacob quitlapejpeni tlen quipixtoya para quitlamajmacas iicni, Esaú. ");
INSERT INTO nheBl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Huan quiniyocatlali 200 sihua chivojme, 20 oquich chivojme, 200 sihua borregojme, 20 oquich borregojme, ");
INSERT INTO nheBl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","huan 30 sihua camellos ininhuaya ininconehua. Nojquiya quiniyocatlali 40 huacaxme, 10 torojme, 20 sihua burrojme huan 10 oquich burrojme. ");
INSERT INTO nheBl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Teipa quinmactili itlatequipanojcahua huan quinxejxelo sesen tlamantli tlapiyalime huan quinilhui: ―Xitlayacanaca huan amo xiquincahuilica ma mosejcotilica sequinoc tlamantli tlapiyalime. Se pamitl tlen se tlamantli tlapiyalime ma tlayacana, huan teipa ica quentzi ma huala seyoc pamitl ica seyoc tlamantli tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Huan Jacob quinilhui itlatequipanojcahua tlen tlayacanayayaj: ―Quema inquipantise noicni, Esaú, huan inmechtlajtlanis ajqueya imoteco huan canque inyohuij huan ajqueya iaxca nopa tlapiyalime tlen inquinhuicaj, ");
INSERT INTO nheBl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","xijnanquilica: ‘Ni se regalo para ta, toteco Esaú. Jacob, motlatequipanojca, mitztitlanilía huan ya huala totepotzco.’ ");
INSERT INTO nheBl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nojquiya Jacob san se quiilhui itlatequipanojca tlen teipa hualayaya ica más tlapiyalime huan nopa sequinoc tlen inintepotzco hualayayaj. Quinilhui: ―Quema inquipantise Esaú, xiquilhuica san se. ");
INSERT INTO nheBl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Nojquiya xiquilhuica: ‘Motlatequipanojca, Jacob, huala totepotzco.’ Queja nopa quichijqui Jacob pampa moilhui: “Nijyoltlalis ica tlen nijtitlani ma quihuiquilica, huan teipa nechitas na huan cuali nechselis.” ");
INSERT INTO nheBl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Huajca tlayacanque nopa tlatequipanohuani ica nopa tlapiyalime tlen quimacayaya iicni. Huan nopa tlayohua Jacob mocajqui ipan ichaj tlen yoyomitl. ");
INSERT INTO nheBl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ipan nopa tlayohua Jacob mejqui huan quincuitejqui nopa ome isihuajhua, nopa ome isihua tlatequipanojcahua, huan nopa 11 iconehua, huan quinchihualti ma apanoca nopa pilatentzi Jaboc. ");
INSERT INTO nheBl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Huan quinchihualti itlatequipanojcahua ma quinpanoltica nochi tlapiyalime huan tlamantli tlen iaxca ipan nopa seyoc nali. ");
INSERT INTO nheBl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Huan Jacob mocajqui iselti. Huan monexti se tlacatl tlen motehuijqui ihuaya hasta tlanesqui. ");
INSERT INTO nheBl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Pero quema nopa tlacatl quiitac para ax hueliyaya quitlanis, quiitzqui Jacob campa imetzomiyo tlatzquía ipan itzinpan omiyo huan quilecueni. ");
INSERT INTO nheBl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Huan nopa tlacatl quiilhui: ―Xinechmajcahua pampa ya tlanesi. Huan Jacob quiilhui: ―Intla ax tinechtiochihuas, ax nimitzmajcahuas. ");
INSERT INTO nheBl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Huan nopa tlacatl quiilhui: ―¿Tlaque motoca? Huan ya quinanquili: ―Notoca Jacob. (Jacob quinequi quiijtos Tlacajcayajquetl.) ");
INSERT INTO nheBl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Huajca nopa tlacatl quiilhui: ―Motoca ayoc elis Jacob. Motoca elis Israel. (Israel quinequi quiijtos Se Tlen Motehuía Ica Toteco.) ―Queja nopa motoca pampa timotehuijtoc ihuaya Toteco Dios huan ihuaya tlacame huan titlatlantoc. ");
INSERT INTO nheBl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Huajca Jacob quiilhui: ―Xinechilhui tlaque motoca ta. Pero nopa tlacatl quinanquili: ―¿Para tlen tinechtlajtlanía notoca? Teipa nopa tlacatl quitiochijqui Jacob. ");
INSERT INTO nheBl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Huan Jacob quitocajti nopa lugar Peniel. (Peniel quinequi quiijtos Ixayac Toteco.) Queja nopa quitocajti pampa quiijto: “Niquixtlachilijtoc Toteco Dios huan noja niitztoc.” ");
INSERT INTO nheBl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Huan Jacob quistejqui Peniel quema quisqui tonati, pero metzxocuetiyaya pampa imetztomahuiya omiyo lecuentoya. ");
INSERT INTO nheBl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yeca hasta ama iteipa ixhuihua Israel ax quicuaj ilejleto imetztomahuiya se tlapiyali pampa nopano ielhuicac ejca Toteco quimaquili Jacob. ");
INSERT INTO nheBl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Huan quema Jacob quiitac para Esaú hualayaya imelac ica 400 tlacame, quinxejxelo nopa coneme ihuaya Lea, Raquel huan nopa ome sihua tlatequipanohuani. ");
INSERT INTO nheBl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Quintlali ma tlayacanaca nopa sihua tlatequipanohuani ihuaya ininconehua. Teipa quitlali Lea ihuaya iconehua huan hasta teipa quintlali Raquel huan José. ");
INSERT INTO nheBl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jacob tlayacanqui huan mopacho hasta tlalchi chicome huelta para quitlepanitas iicni quema monechcahuiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Pero Esaú motlalo quinamiquito. Huan quicuanajnahuajqui, huan quitzoponi, huan nochi ome chocaque. ");
INSERT INTO nheBl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Teipa Esaú quinitac nopa sihuame huan coneme tlen hualayayaj huan tlajtlanqui: ―Huan ¿ajqueya inijuanti ni tlen hualahui mohuaya? Huan Jacob quinanquili: ―Ni tlen Toteco Dios nechmacatoc. ");
INSERT INTO nheBl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Huajca nopa sihua tlatequipanohuani ihuaya ininconehua monechcahuijque huan mopachojque. ");
INSERT INTO nheBl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Teipa monechcahuijque Lea huan iconehua huan san se quichijque. Huan más teipa ajsicoj José huan Raquel huan nojquiya mopachojque. ");
INSERT INTO nheBl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Huan Esaú quiilhui Jacob: ―¿Tlaque timoilhuía tijchihuas ica nochi nopa tlapiyalime tlen niquinpantijtihualajqui? Huan Jacob quiilhui: ―Nijnequi nimitzmacas ta, noicni, para ma tinechselis ica cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Huan Esaú quiijto: ―Axtle, noicni. Na ya niquinpiya miyac. Ximocahua ica tlen moaxca. ");
INSERT INTO nheBl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Pero Jacob quiilhui: ―Axtle, xijchihua se favor, xiquinseli pampa nimitzmaca. Para na nimitzita, eltoc queja niquita ixayac Toteco pampa tinechselijtoc ica cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Xijseli tlen nimitzhualiquilijtoc pampa Toteco Dios tlahuel nechricojchijtoc huan nochi tlen tiquita, noaxcahua. Huan pampa Jacob quinelchihualti ma quiseli, Esaú quiseli. ");
INSERT INTO nheBl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Teipa Esaú quiijto: ―Ma ya tiyaca huan san sejco tiajsise. ");
INSERT INTO nheBl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Pero Jacob quiilhui: ―Noicni, ta tijmati para coneme ax quipiyaj fuerza, niyon ax quipiyaj fuerza nopa piltlapiyaltzitzi. Intla tiquintojtocase chicahuac san se tonal, tlaxicose huan nochi miquise. ");
INSERT INTO nheBl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Más cuali para timotlayacanaltis huan na niyas ica yolic queja nejnemij ni tlapiyalime huan coneme hasta timosejcotilise ipan tlali Seir. ");
INSERT INTO nheBl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Huan Esaú quiijto: ―¡Cualtitoc! Xinechcahuili ma nimitzcahuilijtehua se ome tlacame tlen hualahuij nohuaya. Pero Jacob quiilhui: ―¡Axtle! Amo ximocuatotoni. Tlen ipati eltoc para tojuanti tiome ma tiitztoca ica cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Huan nopa tonal Esaú mocuepqui Seir. ");
INSERT INTO nheBl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Huan Jacob yajqui altepetl Sucot huan nopano quichijqui se cali huan quinchihuili pilxajcaltzitzi itlapiyalhua. Yeca quitocajti nopa lugar Sucot. (Sucot quinequi quiijtos Pilxajcaltzitzi.) ");
INSERT INTO nheBl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Teipa quema Jacob hualayaya tlen tlali Aram, ajsico ica cuali ipan tlali Canaán huan quiquetzque ininyoyoncalhua nechca altepetl Siquem. ");
INSERT INTO nheBl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Huan teipa ica 100 plata tomi quicojqui nopa tlali tlen iteixmatcahua Hamor tlen elqui itata Siquem. ");
INSERT INTO nheBl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Huan nopano quichijqui se tlaixpamitl huan quitocajti El Elohe Israel. (El Elohe Israel quinequi quiijtos Tlahuel Hueyi Toteco Dios Tlen ToTeco Tiisraelitame.) ");
INSERT INTO nheBl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Huan Dina, nopa ichpocatl tlen Lea quimacac Jacob, yajqui quinpaxaloto nopa ichpocame tlen nopano ehuaj. ");
INSERT INTO nheBl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Pero nopano itztoya se telpocatl tlen itoca Siquem. Yajaya eliyaya icone Hamor, se heveo tlacatl tlen quinyacanqui nopa heveos nopano. Huan Siquem quifuerzajhui Dina ma moteca ihuaya huan quipinahualti. ");
INSERT INTO nheBl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pero yonque ya nopa quichihuili, nopa telpocatl nelía quiixtocac huan quiicneli huan quicamahui Dina ica nochi iyolo para nojquiya ma quiicneli. ");
INSERT INTO nheBl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Huajca mocamahui ihuaya itata, Hamor, huan quiilhui: ―Xiya xiquijtlaniti nopa ichpocatl. Nijnequi nimosihuajtis ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Huan Jacob quimatqui para Siquem quipinahualtijtoya iichpoca, pero itelpocahua noja itztoyaj potrero ica inintlapiyalhua huan yeca ax tleno quiijto hasta ajsique. ");
INSERT INTO nheBl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Huan ipan nopa tonali Hamor, itata Siquem, quicamahuito Jacob tlen Dina. ");
INSERT INTO nheBl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Huan quema itelpocahua Jacob mocuepque, huan quimatque tlen panotoya, nelía cualanque pampa eliyaya se hueyi pinahualistli para nochi iteixmatcahua Jacob para se tlacatl san queja hueli motecasquía ihuaya iichpoca. ¡Elqui se tlamantli tlen ax quema mochijtosquía ica israelitame! ");
INSERT INTO nheBl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Pero Hamor hualajqui quincamahuico Jacob huan itelpocahua huan quinilhui: ―Nocone Siquem nelía quiicnelía imosihua icni. Se favor, xijcahuilica ma mocuili. ");
INSERT INTO nheBl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nojquiya ma timohuampochihuase huan queja nopa timosihuajtise ihuaya imoichpocahua, huan imojuanti ihuaya toichpocahua. ");
INSERT INTO nheBl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ximocahuaca ipan totlal. Xijtlapejpenica nopa tlali tlen más inquinequise huan nopano xiitztoca. Nica huelis intlanamacase, intlacohuase huan inmoaxcatise tlaltini. ");
INSERT INTO nheBl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Huan nopa telpocatl Siquem nojquiya quinilhui Jacob huan iicnihua Dina: ―Nimechtlajtlanía ma tiitztoca ica yejyectzi. ");
INSERT INTO nheBl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Xinechilhuica quesqui tomi huan tlamantli inquinequij para nopa ichpocatl huan nimechmacas. Para na ax tleno intla innechtlajtlanise tlen patiyo. San nijnequi xijcahuilica nopa ichpocatl ma monamicti nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pero pampa Siquem quipinahualtijtoya Dina, itelpocahua Jacob quinejque quincajcayahuase Siquem huan itata, Hamor, ");
INSERT INTO nheBl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","huan huajca quinilhuijque: ―Ax hueli tijnamacase toicni ica se tlacatl tlen ax motzontequilijtoc iyacapa nopa cuetlaxtli ipan itlacayo pampa ya nopa elisquía se pinahualistli para tojuanti. ");
INSERT INTO nheBl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","San huelis tijselise se tlacatl intla elis queja tojuanti. Huajca achtohui nochi tlacame tlen imotlal monequi ma motzontequilica inincuetlaxo para quipiyase nopa tlanextilijcayotl tlen itoca circuncisión. ");
INSERT INTO nheBl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Huan huajca, quena, huelis inmosihuajtise ihuaya toichpocahua huan tojuanti ihuaya imoichpocahua. Huan tiitztose tlatlajco imojuanti huan tielise san se altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pero intla ax inquiselíaj tlen timechtlajtlaníaj huan ax inmotequilíaj nopa tlanextilijcayotl, huajca tiquistehuase huan tijhuicase tosihua icni. ");
INSERT INTO nheBl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Huajca Hamor huan itelpoca quicualcajque nopa tlajtoli. ");
INSERT INTO nheBl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Huan nimantzi yajqui nopa telpocatl huan motzontequili icuetlaxo pampa tlahuel quiixtocayaya iichpoca Jacob. Huan Siquem elqui tlen más quipixqui tlatlepanitacayotl ica itata iteixmatcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Huajca ya huan itata, Hamor, yajque ipuertajteno nopa altepetl campa nochi momatque mosentilíaj huan quinilhuijque tlen nopano ehuani: ");
INSERT INTO nheBl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","―Ni tlacame quinequij elise tohuampoyohua. Ma mocahuaca nica tohuaya huan tlanamacase pampa onca miyac tlali para inijuanti. Huelis timosihuajtise ihuaya iniichpocahua, huan inijuanti ihuaya toichpocahua. ");
INSERT INTO nheBl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Pero ax mocahuase para ma tielica san se altepetl intla nochi tojuanti tlen titlacame ax timotzontequilise iyacapa cuetlaxo ipan totlacayohua queja inijuanti momajtoque quichihuaj. ");
INSERT INTO nheBl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Pero intla quena, teipa nochi tlen quipiyaj huan nochi inintlapiyalhua elise toaxca. Huajca ma tijchihuaca tlen quiijtohuaj. ");
INSERT INTO nheBl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Huan nochi tlacame ipan nopa altepetl tlen ya quipixtoyaj xihuitl para elise soldados quicualcajque tlen quiijtojque huan motzontequilijque nopa cuetlaxtli. ");
INSERT INTO nheBl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pero ica ihuiptlatica quema nopa tlacame noja xoxocoxtoyaj pampa motequilijtoyaj, Simeón huan Leví, nopa ome itelpocahua Jacob tlen eltoyaj itlaca icnihua Dina, yajque campa nopa altepetl huan ica ininmachete quinmictijque nochi nopa tlacame pampa ax quiijiyohuijque tlen quichijque. ");
INSERT INTO nheBl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Quimictijque Hamor ihuaya icone, Siquem, huan quiquixtijtejque Dina ipan ichaj Siquem huan quistejque. ");
INSERT INTO nheBl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Huan ajsicoj nopa sequinoc itelpocahua Jacob, huan panoque campa nopa mijcatzitzi huan quinixtequilijque nochi tlen quipixtoyaj ipan nopa pilaltepetzi pampa quipinahualtijtoyaj iniicni. ");
INSERT INTO nheBl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Quinhuicaque nochi borregojme, huacaxme, burrojme huan nochi tlen oncayaya ipan nopa altepetl huan ipan mila. ");
INSERT INTO nheBl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Quiixtejque nochi tlen oncayaya ipan caltini huan quinhuicaque nochi coneme huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Huajca quema Jacob quimatqui, quinilhui Simeón huan Leví: ―Inquichijtoque ma nimocahua fiero. Ama nopa cananeos huan nopa ferezeos tlen itztoque ipan ni tlali nechcualancaitase, huan mosejcotilise, huan techtehuise huan techmictise, na huan nochi noteixmatcahua pampa ax timiyaqui. ");
INSERT INTO nheBl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pero itelpocahua Jacob quiilhuijque: ―Pero ax hueli quichihuilise toicni queja se ahuilnenca sihuatl huan ax tleno oncas. ");
INSERT INTO nheBl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Teipa Toteco Dios quiilhui Jacob: “Ximoquetza huan xiya xiitztoti Betel. Nopano xijchihua se tlaixpamitl para xinechhueyimatis pampa nopano nimonexti ica ta quema ticholohuayaya tlen moicni, Esaú.” ");
INSERT INTO nheBl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Huajca Jacob quiilhui ifamilia huan nochi tlen ihuaya yohuiyayaj: ―Xijquixtica nochi totiotzitzi tlen inquipiyaj, huan ximaltica huan xijpatlaca imoyoyo. ");
INSERT INTO nheBl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Teipa xihualaca, ma tiyaca Betel pampa nepa nijsencahuas se tlaixpamitl huan tijhueyichihuase Toteco Dios tlen nechpalehui quema nimocuesohuayaya, yajaya tlen nohuaya yajtoc campa hueli campa ninentinentoc. ");
INSERT INTO nheBl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Huajca quimactilijque Jacob nochi inintotiotzitzi huan nochi pijpiloli ica tiotzitzi tlen quihuicayayaj ipan ininnacas, huan Jacob quintlalpacho itzintla se ahuatl tlen eltoya nechca altepetl Siquem. ");
INSERT INTO nheBl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Huan quema quisque nopano, Toteco Dios quichijqui para nochi nopa pilaltepetzitzi tlen nejnechca ma quinimacasica miyac, huan yeca ax quintepotztocaque. ");
INSERT INTO nheBl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Huan Jacob huan nochi tlacame tlen ihuaya nejnemiyayaj ajsitoj ipan Luz tlen nojquiya itoca Betel ipan tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Huan nopano quisencajqui se tlaixpamitl huan quitocajti El Betel. (El Betel quinequi quiijtos Itlaixpa Toteco Dios Tlen Nechnamijqui Nica Betel.) Pampa quema mochololtiyaya tlen iicni, Toteco Dios monextijtoya ihuaya nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nojquiya nopano mijqui Débora, nopa sihuatl tlen quimocuitlahuijtoya Rebeca. Huan quitlalpachojque itzintla se ahua cuahuitl nechca Belén. Huan Jacob quitocajti nopa cuahuitl Alónbacut. (Alónbacut quinequi quiijtos Ahuatl Campa Nochi Chocaque.) ");
INSERT INTO nheBl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nojquiya Toteco Dios ya monextijtoya sampa ica Jacob quema mocuepayaya tlen tlali Aram huan quitiochijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Huan Toteco Dios quiilhuijtoya: “Ta motoca Jacob.” (Jacob quinequi quiijtos Tlacajcayajquetl.) “Pero ayoc mitztocajtise Jacob. Ama motoca elis Israel.” (Israel quinequi quiijtos Se Tlen Moquetza Ica Chicahualistli Iixtla Toteco.) ");
INSERT INTO nheBl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Huan nojquiya quema Toteco Dios quipatili itoca, Toteco quiilhui: “Na nimoTeco Tlen Nijpiya Nochi Chicahualistli. Nijchihuas ma xiquinpiya miyac moconehua huan moteipa ixhuihua. Huan miyac tlacame quisase ipan moteipa ixhuihua, huan mochihuase miyac altepetini ipan inintlal. Ipan moteipa ixhuihua oncas tlanahuatiani huan sesen quinnahuatis itlacajhua ipan itlal. ");
INSERT INTO nheBl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nopa tlali tlen nijmacac Abraham huan Isaac, mohuejcapan tatahua, nojquiya nimitzmacas ta huan teipa niquinmacas moteipa ixhuihua.” ");
INSERT INTO nheBl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Huan Toteco Dios quistejqui ipan nopa lugar campa quicamahui Jacob. ");
INSERT INTO nheBl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Huan Jacob quicuic se tetl huan quiquetzqui queja se tlanextilijcayotl para quiilnamiquis campa camatitoya ihuaya Toteco. Huan quitequili aceite huan xocomeca atl nopa tetl para quiiyocatlalis para Toteco. ");
INSERT INTO nheBl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Huan quitocajti nopa lugar Betel. (Betel quinequi quiijtos Ichaj Toteco Dios.) ");
INSERT INTO nheBl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Teipa Jacob huan ifamilia quistejque tlen Betel. Huan quema noja huejca itztoyaj para ajsitij altepetl Efrata, Raquel ajsic hora para conepiyas huan nelía tlaijiyohuiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Huan ipan nopa hora tlen más ohui, nopa sihuatl tlen quipalehuiyaya para ma conepiya quiilhui: “Amo ximajmahui pampa tijtlacatiltijtoc seyoc oquichpil.” ");
INSERT INTO nheBl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Pero Raquel ya miquiyaya huan quema tlantinemiyaya iijiyo, quitocajti ioquichpil Benoni. (Benoni quinequi quiijtos Oquichpil Tlen Tlacatqui Ica Tlaohuijcayotl.) Pero teipa itata quitocajti nopa ipiloquichpil Benjamín. (Benjamín quinequi quiijtos Oquichpil Tlen Más Quipiya Tequihuejcayotl.) ");
INSERT INTO nheBl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Queja nopa Raquel mijqui huan quitlalpachojque ipan ojtli para altepetl Efrata tlen ama itoca Belén. ");
INSERT INTO nheBl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Huan Jacob quiquetzqui se tetl campa quitoctoyaj Raquel huan nopa tetl hasta ama quejipa quinextía campa quitojque. ");
INSERT INTO nheBl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Huan Israel, tlen achtohui itoca eliyaya Jacob, quistejqui ipan ojtli huan quiquetzato ichaj tlen yoyomitl ipan seyoc lado altepetl Migdal Edar. ");
INSERT INTO nheBl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Huan quema Israel mocahuayaya nopano, Rubén motecato ihuaya Bilha, se itlatequipanojca itata. Huan itata quimatqui huan tlahuel cualanqui. Huan Israel quinpixqui 12 itelpocahua. ");
INSERT INTO nheBl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Nopa coneme tlen quinpixqui ihuaya Lea elque: Rubén iachtohui ejca, Simeón, Leví, Judá, Isacar huan Zabulón. ");
INSERT INTO nheBl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Tlen quinpixqui ihuaya Raquel elque: José huan Benjamín. ");
INSERT INTO nheBl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Huan tlen quinpixqui ihuaya Bilha tlen eliyaya itlatequipanojca Raquel elque: Dan huan Neftalí. ");
INSERT INTO nheBl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Huan nopa coneme tlen quinpixqui ihuaya Zilpa, tlen eliyaya itlatequipanojca Lea, elque: Gad huan Aser. Ya ni nochi ioquichpilhua Jacob tlen tlacatque ipan tlali Aram. ");
INSERT INTO nheBl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Huan Jacob ajsito ichaj campa itztoya itata, Isaac, ipan Mamre, nopa altepetl nechca Arba o Hebrón, campa huejcajquiya mochantijtoyaj Abraham huan Isaac. ");
INSERT INTO nheBl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Huan Isaac quipiyayaya 180 xihuitl quema mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Quena, quema eliyaya nelhuehuentzi, yajqui mosejcotilito ihuaya ihuejcapan tatahua. Huan iconehua Esaú huan Jacob quitlalpachojque. ");
INSERT INTO nheBl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Huan ya ni iteipa ixhuihua Esaú tlen nojquiya itoca Edom. ");
INSERT INTO nheBl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú mosihuajti ininhuaya sihuame tlen ehuaj tlali Canaán. Isihuajhua inintoca eltoya Ada, iichpoca Elón nopa heteo tlacatl, huan Aholibama, iichpoca Aná huan iixhui Zibeón nopa heveo tlacatl. ");
INSERT INTO nheBl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Huan nojquiya mosihuajti ihuaya Basemat, iichpoca Ismael, huan isihua icni Nebaiot. ");
INSERT INTO nheBl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Huan Ada quimacac Esaú se icone tlen itoca Elifaz. Huan Basemat quitlacatilti Reuel, ");
INSERT INTO nheBl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","huan Aholibama quintlacatilti Jeús, Jaalam huan Coré. Ya ni iconehua Esaú tlen tlacatque quema noja itztoya ipan tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Huan Esaú quincuitejqui isihuajhua, itlaca conehua huan isihua conehua huan itlatequipanojcahua huan yajqui ipan seyoc tlali para moiyocaquixtis tlen iicni, Jacob. Quinhuicac ihuaya nochi itlapiyalhua huan nochi tlamantzitzi tlen quisejcotilijtoya ipan Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nelmiyac quipiyayayaj nochi ome icnime hasta ayoc hueliyayaj itztoque san sejco. Nopa tlali tlen ipan itztoyaj ax quinaxiliyaya para quintlamacase inintlapiyalhua. ");
INSERT INTO nheBl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yeca Esaú tlen nojquiya quitocajtiyayaj Edom yajqui itztoti campa tepeyo ipan tlali Seir. ");
INSERT INTO nheBl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nica eltoc inintoca iteipa ixhuihua Esaú tlen quintocajtijque edomitame. Inijuanti itztoyaj campa tepeyo ipan nopa tlali tlen itoca Seir. ");
INSERT INTO nheBl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Inintoca iconehua Esaú elque Elifaz huan Reuel. Elifaz elqui icone isihua, Ada, huan Reuel elqui icone isihua, Basemat. ");
INSERT INTO nheBl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Iconehua Elifaz elque Temán, Omar, Zefo, Gatam huan Senaz. ");
INSERT INTO nheBl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz quipixqui se isihua tlatequipanojca tlen itoca Timna tlen quimacac se icone tlen quitocajti Amalec. Huan iconehua Elifaz elque iixhuihua Esaú huan isihua, Ada. ");
INSERT INTO nheBl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Huan iconehua Reuel elque: Nahat, Zera, Sama huan Miza. Inijuanti elque iixhuihua Basemat nopa seyoc isihua Esaú. ");
INSERT INTO nheBl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Huan Esaú quinpixqui iconehua ica isihua tlen itoca eliyaya Aholibama tlen elqui iichpoca Aná huan iixhui Zibeón. Inintoca ininconehua elque: Jeús, Jaalam huan Coré. ");
INSERT INTO nheBl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ama nimitzilhuis nopa tlayacanani ipan iteipa ixhuihua Esaú. Ipan iconehua Elifaz, iachtohui ejca Esaú, elque: Tlayacanani Temar, Omar, Zefo, Cenaz, ");
INSERT INTO nheBl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam huan Amalec. Nochi ya ni elque tlayacanani ipan iteipa ixhuihua Elifaz ipan tlali Edom. Huan nochi inijuanti elque iteipa ixhuihua Ada, isihua Esaú. ");
INSERT INTO nheBl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Huan iconehua Reuel, icone Esaú, elque: Tlayacanani Nahat, Zera, Sama huan Miza. Inijuanti tlayacanque ipan iconehua Reuel ipan tlali Edom huan elque iixhuihua Basemat, isihua Esaú. ");
INSERT INTO nheBl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iconehua Esaú ica isihua Aholibama, iichpoca Aná, elque: Tlayacanani Jeús, Jaalam huan Coré. Inijuanti quinyacanque iniixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Nochi inijuanti elque nopa tlayacanani ipan iteipa ixhuihua Esaú o Edom. Huan sesen inijuanti mochijqui se hueyi familia ica miyac tlacame. ");
INSERT INTO nheBl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Iconehua Seir, nopa horeo tlacatl tlen itztoyaj ipan nopa tlali, elque: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO nheBl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer huan Disán. Ya ni elque tlayacanani tlen horeos tlen elque iixhuihua Seir ipan tlali Edom. ");
INSERT INTO nheBl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Iconehua Lotán elque: Hori huan Hemam. Huan Timna elqui isihua icni Lotán. ");
INSERT INTO nheBl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Iconehua Sobal elque: Alván, Manahat, Ebal, Sefo huan Onam. ");
INSERT INTO nheBl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Iconehua Zibeón elque: Aja huan Aná. Aná elqui tlen quipanti campa meya atl totonic ipan nopa huactoc tlali quema quinmocuitlahuiyaya iburrojhua itata. ");
INSERT INTO nheBl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Iconehua Aná elque: Disón huan se isihuapil tlen itoca Aholibama. ");
INSERT INTO nheBl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Iconehua Disón elque: Hemdán, Esbán, Itrán huan Querán. ");
INSERT INTO nheBl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Iconehua Ezer elque: Bilhán, Zaaván huan Acán. ");
INSERT INTO nheBl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Iconehua Disán elque: Uz huan Arán. ");
INSERT INTO nheBl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Nopa tlayacanani tlen horeos elque: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO nheBl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer huan Disán. Ya ni elque inintlayacancahua nopa horeos ipan sesen pilaltepetzitzi ipan tlali Seir. ");
INSERT INTO nheBl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nica quiijtohua inintoca nopa huejhueyi tlanahuatiani tlen tlanahuatijque ipan tlali Edom achtohuiya quema israelitame aya quipiyayayaj se tlanahuatijquetl: ");
INSERT INTO nheBl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, icone Beor, elqui tlanahuatijquetl ipan Edom huan ialtepe itoca eliyaya Dinaba. ");
INSERT INTO nheBl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Quema Bela mijqui, pejqui tlanahuatía Jobab, icone Zera, tlen hualayaya pilaltepetzi Bosra. ");
INSERT INTO nheBl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Quema Jobab mijqui, tlanahuati Husam tlen hualajqui altepetl Temán. ");
INSERT INTO nheBl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Quema Husam mijqui, pejqui tlanahuatía Hadad, icone Bedad, tlen quintlanqui nopa tlali Madián ehuani quema quinamiquicoj ipan tlali Moab. Yajaya hualajqui altepetl Avit. ");
INSERT INTO nheBl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Quema mijqui Hadad, pejqui tlanahuatía Samla tlen hualayaya Masreca. ");
INSERT INTO nheBl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Quema Samla mijqui, pejqui tlanahuatía Saúl tlen hualayaya Rehobot, nopa pilaltepetzi tlen eltoc nechca ateno. ");
INSERT INTO nheBl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Quema Saúl mijqui, tlanahuati Baal Hanán tlen eliyaya icone Acbor. ");
INSERT INTO nheBl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Huan quema mijqui Baal Hanán, tlanahuati Hadad. Ialtepe Hanán itoca eliyaya Pau huan Mehetabel tlen eliyaya iichpoca Matred huan iixhui Mezaab elqui isihua. ");
INSERT INTO nheBl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Nica eltoc inintoca itlayacanca teipa ixhuihua Esaú huan sesen inijuanti quiyacanque ihueyi familia huan campa sesen tlayacanque ipan nopa altepetl tlen quihuicac inintoca. Inintoca eltoc: Timna, Alva, Jetet, ");
INSERT INTO nheBl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO nheBl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO nheBl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel huan Iram. Nochi ni tlacame tlayacanque ipan tlali Edom tlen quihuicac itoca ininhuejcapan tata, Esaú. Huan sese altepetl tlen iniaxcahua quihuicac itoca itlayacanca ixhui tlen tlayacanqui nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob mocajqui para itztos ipan tlali Canaán campa itztoya itata quema aya miquiyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Huan ya ni tlen panoc ica Jacob 37:2 O Israel. huan iconehua. Quema José, icone Israel, eliyaya se telpocatl tlen quipiyayaya 16 xihuitl, quinmocuitlahuiyaya borregojme ininhuaya itepotz icnihua tlen eliyayaj ininconehua Bilha huan Zilpa, ne sequinoc isihuajhua itata. Huan teipa José quiilhuico itata nochi tlen ax cuali quichihuayayaj iicnihua. ");
INSERT INTO nheBl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Huan Israel más quiicneli José que ne sequinoc itelpocahua pampa tlacatqui quema eliyaya nelhuehuentzi. Huan yeca quichihuili se iyoyo tlen huehueyac huan tlahuel yejyectzi. ");
INSERT INTO nheBl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Pero quema iicnihua quiitaque para inintata más quiicneliyaya José que inijuanti, pejque quicualancaitaj huan niyon quentzi ax quinequiyayaj quiitase. ");
INSERT INTO nheBl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Se tonal José quipixqui se temictli huan quinpohuili iicnihua, pero ya nopa quichijqui más ma quicualancaitaca. ");
INSERT INTO nheBl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Huan ya ni tlen quinilhui: ―Xijtlacaquilica huan nimechpohuilis nopa temictli tlen nijpixqui. ");
INSERT INTO nheBl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nijtemijqui para nochi tojuanti tiitztoyaj mila, tijsentiliyayaj tlamontomitl tlen trigo tzontli. Huan nimantzi tlen na nijsentilijtoya motlalanqui huan moquetzqui xitlahuac huan tlen inquisentilijtoyaj nechyahualojque huan queja motlancuaquetzque para nechtlepanitase. ");
INSERT INTO nheBl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Huajca iicnihua quiilhuijque: ―¿Tijnequi tiquijtos para tielis tihueyi tlanahuatijquetl huan titechnahuatis? Huajca más quicualancaitaque ipampa itemic huan tlen quinpohuilijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Teipa José quipixqui seyoc temictli huan nojquiya quinpohuili iicnihua. Quinilhui: ―Xijtlacaquilica, nijpixqui seyoc temictli huan niquitayaya para tonati huan metztli huan 11 sitlalime nechhueyitlepanitayayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Huan José nojquiya quipohuili ni temictli itata huan iicnihua; huan itata quiajhuac huan quiilhui: ―¿Tlaque tiquijtosnequi ica ni temictli tlen tijpixqui? ¿Timoilhuía para monana, moicnihua huan na monequis timitzhueyitlepanitase? ");
INSERT INTO nheBl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Huan iicnihua quicualancaitaque, pero itata miyac moilhuiyaya tlen ni tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Se tonal iicnihua José quinhuicaque iborregojhua inintata para quitemojtiyase sacatl huan ajsitoj nechca altepetl Siquem. ");
INSERT INTO nheBl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Huan ipan ichaj inintata quiilhui José: ―Xiquita, moicnihua quintlacuajcualtíaj noborregojhua nechca Siquem. Nijnequi xiya xiquinitati. Huan José quinanquili: ―¡Cualtitoc! ");
INSERT INTO nheBl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Huajca itata quiilhui: ―Xiquitati quejatza itztoque moicnihua huan nopa borregojme. Huan teipa xihuala xinechyolmelahuaqui. Huajca queja nopa, Israel quititlanqui José ma yohui campa nopa tlamayamitl nechca Hebrón. Huan quema José ajsito Siquem, ");
INSERT INTO nheBl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","quintemohuayaya iicnihua campa hueli. Huan quipanti se tlacatl huan quitlajtlani: ―¿Tlaque tijtemojtinemi? ");
INSERT INTO nheBl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Huan José tlananquili: ―Na niquintemojtinemi noicnihua. ¿Huelis tinechilhuis canque quinmocuitlahuíaj ininborregojhua? ");
INSERT INTO nheBl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Huan nopa tlacatl quiijto: ―Ya mijcuenijtejque nica. Nijcajqui quiijtohuaj para yohuij Dotán. Huajca José quintemojtiyajqui huan quinpanti ipan Dotán. ");
INSERT INTO nheBl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Huan inijuanti quihuejcaitaque, huan quema aya onajsiyaya, quisencajque quejatza quimictise. ");
INSERT INTO nheBl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Quiijtojque: ―¡Xiquitaca ne huala tlen tlatemiqui! ");
INSERT INTO nheBl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Xihualaca, ma tijmictica huan tijcalaquise ipan se tlen ni ostome campa achtohui eltoya atl huan tiquijtose para se tecuani quicuajqui. Huan tiquitase tlaque panos ica itemic. ");
INSERT INTO nheBl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Pero quema Rubén quicajqui ni tlamantli, quinejqui quimanahuis José tlen ne sequinoc iicnihua. Huajca quiijto: ―Ma ax tijmictica, ");
INSERT INTO nheBl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","huan tijtoyahuase estli. San ma tijmajcahuase ipan ne tlacoyoctli tlen eltoc ipan ni huactoc tlali, pero ax tleno tijchihuilise. Rubén quiijto ya ni pampa quinequiyaya para teipa quimanahuisquía José huan quihuicasquía campa itata. ");
INSERT INTO nheBl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Pero quema José ajsito campa itztoyaj iicnihua, inijuanti quiquixtilijque iyoyo tlen nelyejyectzi tlen moquentijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Huan quiitzquijque huan quimajcajque ipan nopa tlacoyoctli tlen ax quipiyayaya atl pampa huactoya. ");
INSERT INTO nheBl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Teipa quema mosehuijque para tlacuase, quinitaque sequin ismaelitame tlen hualayayaj Galaad ica inincamellos tlen quimamayayaj tlacualpajtli huan tlaajhuiyacayotl tlen bálsamo huan mirra, huan yohuiyayaj para tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Huajca Judá quinilhui iicnihua: ―¿Tlaque tijtlanise intla tijmictise toicni huan tijtlatise imiquilis? ");
INSERT INTO nheBl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Más cuali ma tiquinnamaquiltica ne ismaelitame huan ma ax tijmictica pampa yajaya toicni. Huan iicnihua quicualcajque tlen quinilhui. ");
INSERT INTO nheBl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Huajca teipa quema nopa tlanamacani tlen tlali Madián ehuani panoque nopano, iicnihua José quiquixtijque ipan tlacoyoctli huan quinnamaquiltijque ica 20 plata tomi. Huan nopa tlanamacani tlen eliyaya iteipa ixhuihua Ismael quihuicaque para tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Huan teipa Rubén mocuepqui campa ameli huan ax quipanti José osto ijtic, huajca quitzayanqui iyoyo pampa neltlahuel mocuesohuayaya. ");
INSERT INTO nheBl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Teipa mocuepqui campa itztoyaj iicnihua huan quinilhui: ―¡Nopa telpocatl ayoc aqui! ¿Tlaque huelis nijchihuas? ");
INSERT INTO nheBl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Huan nopa icnime quicuique iyoyo José huan quipolojque ieso se chivo tlen quimictijque, ");
INSERT INTO nheBl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","huan quihuiquilijque inintata huan quiilhuijque: “Tijpantijque ni yoyomitl. Xiquita intla iyoyo mocone o axtle.” ");
INSERT INTO nheBl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Huan quema Jacob quiixmatqui, quiijto: “¡Quena, yajaya nopa iyoyo nocone! Se tecuani quicocototzqui huan quicuajqui.” ");
INSERT INTO nheBl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Huajca Jacob quitzayanqui iyoyo huan moyoyonti ica yoyomitl tlen cuesoli huan chocac para miyac tonali pampa mijqui icone. ");
INSERT INTO nheBl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Huan nochi iconehua quicajcahualtiyayaj para quiyoltlalise, pero ax huelqui moyoltlalía. Tlahuel chocayaya ipampa icone huan quiijtohuayaya: “Nimocuesos ipampa nocone hasta quema nimiquis.” ");
INSERT INTO nheBl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Huan ipan tlali Egipto nopa madianitame tlacame quinamacaque José ica se tlacatl tlen itoca Potifar tlen quipixtoya se hueyi tequitl ihuaya nopa hueyi tlanahuatijquetl Faraón nopano. Yajaya elqui tlayacanquetl tlen nopa tlacame tlen quimocuitlahuiyaya iyolis Faraón. ");
INSERT INTO nheBl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ipan nopa tonali Judá moiyocaquixti tlen iicnihua huan yajqui itztoti ipan pilaltepetzi Adulam huan mocajqui ichaj se tlacatl tlen itoca Hira. ");
INSERT INTO nheBl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nopano quiixmatqui iichpoca se cananeo tlacatl tlen itoca Súa huan mosihuajti ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Huan conecuic huan quipixqui se icone tlen quitocajti Er. ");
INSERT INTO nheBl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sampa conecuic huan quipixqui seyoc icone tlen quitocajti Onán. ");
INSERT INTO nheBl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Huan noja quipixqui seyoc icone tlen quitocajti Sela tlen tlacatqui quema inijuanti itztoyaj ipan altepetl Quezib. ");
INSERT INTO nheBl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judá quisihuajti Er, iachtohui ejca, ica se sihuatl tlen itoca Tamar. ");
INSERT INTO nheBl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pero TOTECO ax quipactiyaya iyolis Er pampa eliyaya nelfiero, yeca quimicti. ");
INSERT INTO nheBl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Huajca Judá quiilhui itelpoca Onán: ―Ximosejcotili ihuaya icahual moicni queja mitztocarohua tijchihuas pampa tiihuejpol huan xijpiya se conetl para quiselis tlen eliyaya iaxca moicni. ");
INSERT INTO nheBl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Pero Onán quimatiyaya intla tlacatisquía se conetl nochi tlacame quiitasquíaj para icone iicni huan ax ya icone. Yeca quema quinechcahuiyaya ihuejpol, quitoyahuayaya ixinajcho tlalchi para ma ax conecui pampa ax quinejqui quimacas iicni tlen mijqui iteipa ixhuihua queja monejqui quichihuase. ");
INSERT INTO nheBl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Huan TOTECO quiitac para fiero tlen quichijqui Onán pampa ax quichijqui tlen monejqui. Yeca Toteco nojquiya quimicti. ");
INSERT INTO nheBl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Huajca Judá quiilhui iyex Tamar: ―Ximocahua ticahuali huan xiitztoti ichaj motata hasta moscaltis nocone Sela. Pero ax ya nopa tlen Judá moilhuiyaya. Yajaya majmahuiyaya para Sela mocuilis Tamar pampa moilhui huelis miquisquía queja iicnihua mijque intla itztos ihuaya. Huan Tamar yajqui itztoti ichaj itata queja quinahuati. ");
INSERT INTO nheBl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Huan panoc miyac xihuitl huan nojquiya mijqui isihua Judá tlen elqui iichpoca Súa. Huan teipa quema Judá ayoc mocuesoyaya, yajqui pilaltepetzi Timnat campa itlatequipanojcahua quinximayayaj iborregojhua. Nojquiya ihuaya yajqui ihuampo, Hira, tlen ejqui altepetl Adulam. ");
INSERT INTO nheBl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Huan Tamar quimatqui para iyextat yohuiyaya Timnat quinximati iborregojhua, ");
INSERT INTO nheBl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","huajca moquixtili iyoyo queja tlen moquentíaj cahual sihuame huan moixtzajqui ica se yoyomitl queja quichihuaj ahuilnenca sihuame huan mosehui iteno pilaltepetzi Enaim tlen eltoc ipan ojtli para Timnat. Quichijqui ya ni pampa quiitac Sela ya motlacachijtoya huan Judá ax quisihuajtijtoya ihuaya. Huajca noja aya quipiyayaya se conetl queja monejqui para quihuicas ieso huan itoca ihuehue tlen mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Huan Judá quiitac ipan ojtli huan moilhui para eliyaya se ahuilnenca sihuatl pampa moixtzactoya. ");
INSERT INTO nheBl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Huajca quicajqui iojhui para quinechcahuis, niyon ax quimatqui para eliyaya iyex huan quiilhui: ―Xinechcahuili ma nimoteca mohuaya. Huan yajaya quinanquili: ―¿Tlaque tinechmacas intla nimotecas mohuaya? ");
INSERT INTO nheBl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Huan Judá quinanquili: ―Nimitztitlanilis se pilchivojtzi. Huan ya quiijto: ―Cualtitoc, pero xinechcahuilijtehua tlen moaxca hasta tinechtitlanilis. ");
INSERT INTO nheBl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Huan Judá quiilhui: ―¿Tlaque tijnequi ma nimitzcahuilijtehua? Huan Tamar quiijto: ―Xinechmaca mosello ihuaya imecayo huan mocuatopil tlen tijpiya momaco. Huan Judá quimacac huan motejqui ihuaya, huan yajaya quiconemacac. ");
INSERT INTO nheBl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Teipa Tamar moquixtilito tlen ica moixtzactoya huan sampa motlalili iyoyo queja tlen cahual sihuame moquentíaj. ");
INSERT INTO nheBl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Teipa Judá quititlanqui nopa pilchivojtzi ica ihuampo tlen ejqui altepetl Adulam para quiilhuiti nopa sihuatl ma quicuepili tlen iaxca. Pero ihuampo ayoc quipanti. ");
INSERT INTO nheBl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Huajca quintlajtlani tlen nopano ehuaj: ―¿Canque itztoc nopa ahuilnenca sihuatl tlen ehua Enaim tlen itztoya ojteno? Huan quinanquilijque: ―Nica axaca niyon se ahuilnenca sihuatl. ");
INSERT INTO nheBl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Huajca ihuampo mocuepqui campa Judá huan quiilhui: ―Ax nijpanti nopa sihuatl. Huan nopa tlacame tlen nopano ehuaj nechilhuijque para axaca niyon se ahuilnenca sihuatl nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Huan Judá quiilhui: ―Techhuihuiitase intla sampa tiyas tijtemoti. Nijchijqui tlen niquijto huan nijtitlanqui nopa pilchivojtzi huan ax tijpanti. Huajca ma mocahui nopa sihuatl tlen nijmacac. ");
INSERT INTO nheBl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Huan quema panotoya eyi metztli, se hualajqui campa Judá huan quiilhui: ―Huelis moyex Tamar tlacanentoc pampa quinemiltía se conetl ipan itlacayo. Huan Judá quiilhui: ―¡Xijquixtica tlen nopa altepetl huan xijtlatica! ");
INSERT INTO nheBl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pero quema quiquixtiyayaj, Tamar tlatitlanqui ma quiilhuitij iyextat: “Nechconemacac yajaya tlen iaxca ni tlamantli. Xiquita cuali ajqueya iaxca ni sello, ihuaya imecayo huan ni cuatopili.” ");
INSERT INTO nheBl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Huan Judá quiixmatqui nopa tlamantli huan quiijto: “Yajaya quichijtoc tlen cuali huan na, axtle. Yajaya quinejqui se conetl para quihuicas itoca ihuehue tlen mijqui huan ax nijnamicti ihuaya nocone Sela queja monequiyaya.” Huan Judá ayoc quema motejqui ihuaya Tamar. ");
INSERT INTO nheBl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Huan quema ajsic tonal para conepiyas, quinpixqui cuateme. ");
INSERT INTO nheBl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Huan ipan nopa tlalochtli quema tlacatiyayaj, se tlen inijuanti quiquixti ima, huan nopa cocoxcaitaquetl quiilpi se icpatl chichiltic huan quiijto: “Ya ni quisqui achtohui.” ");
INSERT INTO nheBl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pero teipa nopa pilconetzi quicalaqui ima huan iicni nelía tlacatqui achtohui. Yeca nopa cocoxcaitaquetl quitocajti nopa conetl Fares. (Fares quinequi quiijtos Tlen Moojtlapojtoc.) Queja nopa quitocajti pampa quiijto: “Yajaya moojtlapo para quisqui achtohui.” ");
INSERT INTO nheBl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Huan teipa tlacatqui nopa seyoc oquichpil tlen quipiyayaya nopa icpatl chichiltic imaco huan quitocajti Zara. (Zara quinequi quiijtos Chichiltic.) ");
INSERT INTO nheBl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Huan nopa ismaelita tlanamacani quihuicaque José hasta tlali Egipto. Nopano quicojqui se tlacatl itoca Potifar tlen quipixtoya se hueyi tequitl ica Tlanahuatijquetl Faraón. Elqui inintlayacanca nopa tlacame tlen quimocuitlahuiyaya iyolis. ");
INSERT INTO nheBl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Pero TOTECO itztoya ihuaya José huan quichijqui para nochi ma quisa cuali tlen José quichijqui ipan ichaj iteco. ");
INSERT INTO nheBl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Huan iteco momacac cuenta para TOTECO itztoya ihuaya José huan quitiochihuayaya huan nochi tlen quichijqui quisqui cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Huan iteco quiicneli huan quitlali ma eli tlen más quipalehui. Nojquiya quichijqui ma quinnahuati nochi tlatequipanohuani ipan ichaj huan quitlali imaco nochi tlen quipixqui. ");
INSERT INTO nheBl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Huan tlen nopa tonali quema Potifar quicajqui imaco José ichaj huan nochi tlen quipixqui, TOTECO pejqui más quitiochihua Potifar, huan iteixmatcahua huan nochi tlen quipixqui ipan ichaj huan ipan mila. ");
INSERT INTO nheBl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Huan Potifar ayoc mocuatotoniyayaya ica tleno, san para tlacuas pampa motemachi ipan José. Huan nochi eltoya imaco huan nochi quisayaya cuali. Huan José eliyaya yejyectzi huan nesiyaya se cuali telpocatl. ");
INSERT INTO nheBl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Huan quema panoc tonali, isihua iteco pejqui quiixtoca. Huan se tonal quiilhui: ―Ximoteca nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pero José ax quinejqui huan quiilhui: ―Xiquita, mohuehue quicajtoc nomaco nochi tlen quipiya huan quimati intla nica niitztoc, ax quipiya tleno para ica mocuatotonis. ");
INSERT INTO nheBl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ipan ni cali axaca más tlayacana que na. Noteco nechmacatoc nomaco nochi para nijchihuas tlen na niquitas para cuali. San ica ta ax nijpiya tlanahuatili pampa tiisihua. Huajca, ¿quejatza huelis nitlajtlacolchihuas ica Toteco Dios huan mohuaya nijchihuas se tlamantli tlen tlahuel fiero? ");
INSERT INTO nheBl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Huan yonque nopa sihuatl mojmostla quinotzayaya José ma moteca ihuaya, José ax quichijqui, niyon ax quinechcahui campa itztoya. ");
INSERT INTO nheBl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pero se tonal José monejqui calaquis ichaj iteco para quichihuas itequi huan axacayaya niyon se más tlatequipanojquetl nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Huan nopa sihuatl quiitzqui ipan iyoyo huan quiilhui: ―Ximoteca nohuaya. Pero José motlalojtejqui huan quicajtejqui iyoyo ipan ima. ");
INSERT INTO nheBl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Huan quema nopa sihuatl momacac cuenta para quicahuilijtejqui iyoyo imaco, ");
INSERT INTO nheBl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tzajtzic chicahuac, huan quinnotzqui itlatequipanojcahua huan quinilhui: ―Xiquitaca, nopa hebreo tlacatl tlen nohuehue techhualiquili san nechpinahualtía. Calajqui nica para nechfuerzajhuis ma nimoteca ihuaya, pero na nitzajtzic chicahuac. ");
INSERT INTO nheBl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Huan quema nechcajqui para nitzajtzic ica nochi nochicahualis, motlalojtejqui hasta quicajtejqui iyoyo nica. ");
INSERT INTO nheBl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Teipa nopa sihuatl quiajcojqui José iyoyo hasta ajsico ihuehue. ");
INSERT INTO nheBl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Huan quipohuili queja quinpohuilijtoya nopa tlatequipanohuani huan quiilhui: ―Nopa hebreo tlen tijcojqui huan titechhualiquili calajqui ipan nocuarto huan quinequiyaya ma nimoteca ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Pero quema nitzajtzic chicahuac, motlalojtejqui huan quicajtejqui iyoyo nica. ");
INSERT INTO nheBl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Queja nopa nechchijqui motlatequipanojca tlen tijcojqui. Huan iteco José cualanqui miyac quema quicajqui tlen isihua quipohuiliyaya. ");
INSERT INTO nheBl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Huan quiitzqui José huan tlanahuati ma quicalaquica ipan tlatzactli campa mocahuayayaj nochi tlacame tlen nopa hueyi tlanahuatijquetl quintzactoya. ");
INSERT INTO nheBl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Pero TOTECO noja itztoya ihuaya José huan quinextili quejatza quiicnelía pampa quichijqui para nopa tlayacanca tetzajquetl ma quicualita. ");
INSERT INTO nheBl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Huan nopa tlayacanca tetzajquetl quincajqui imaco José nochi sequinoc tlen tzactoque. Huan José tlanahuatiyaya nochi tlen nopano mochihuayaya. ");
INSERT INTO nheBl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Huan nopa tlayacanquetl ax monequiyaya mocuatotonis ica tleno tlen eltoya imaco José pampa TOTECO itztoya ihuaya huan quichihuayaya para nochi ma quisa cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Panoc miyac tonali huan yajaya tlen itequi para quiyecos nochi itlailis nopa tlanahuatijquetl tlen Egipto para quiitas intla quipixqui ipajyo quichijqui tlen ax quipacti iteco. Huan nojquiya tlaixpanoc itlayacanca panchijca nopa tlanahuatijquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Huajca Faraón cualanqui ininhuaya ni ome itlatequipanojcahua, ");
INSERT INTO nheBl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","huan quintitlanqui ipan tlatzactli tlen eltoya ipan ichaj inintlayacanca nopa tlacame tlen quimocuitlahui. Huan eltoya san sejco campa José tzactoya. ");
INSERT INTO nheBl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Huan nopa tlayacanca tetzajquetl quiilhui José ma quinmocuitlahui. Huan panoque miyac tonali ipan tlatzactli san sejco. ");
INSERT INTO nheBl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Huan se tlayohua yajaya tlen quiyeco itlailis Faraón huan ne se tlen quichijqui ipantzi quipixque sesen temictli. Huan sesen temictli quiijtosnequiyaya sesen tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Huan ica ijnaloc José quinpantico nelmocuesohuayayaj, ");
INSERT INTO nheBl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","huan quinilhui: ―¿Para tlen inmocuesohuaj? ");
INSERT INTO nheBl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Huan quiilhuijque: ―Tijpixque sesen temictli huan ax tijpiyaj ajqueya techpohuilis tlaque quiijtosnequi. Huan José quinilhui: ―Yajaya Toteco Dios tlen temachiltía tlaque quiijtosnequi se tlamantli. Huajca xinechpohuilica tlaque inquitemijque. ");
INSERT INTO nheBl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Huajca nopa tlacatl tlen itequi para quiyecos itlailis Faraón quiilhui: ―Ipan notemic niquitayaya se xocomeca tzontli, ");
INSERT INTO nheBl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","tlen quipixqui eyi imacuayo. Huan nopa xocomeca cuahuitl chamanqui, huan cahuanqui ixochiyo, huan temacac itlajca. Huan teipa itlajca ecsic. ");
INSERT INTO nheBl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Huan nijpiyayaya nomaco icaxi Faraón. Huan nijcuiyaya nopa xocomecatl itlajca huan nijpatzcayaya ipan icaxi. Teipa nijtlaliyaya imaco Faraón. ");
INSERT INTO nheBl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Huan José quiilhui: ―Nopa motemic queja ni quinequi quiijtos. Nopa eyi imacuayo elis eyi tonali, ");
INSERT INTO nheBl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","pampa ica eyi tonali Faraón mitzquixtis nica, huan mitztlalis sampa ipan motequi. Huan sampa tijmacas icaxi imaco queja achtohuiya tijchihuayaya. ");
INSERT INTO nheBl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Quema panos ya nopa, xinechilnamiqui huan xijchihua se favor, xijcamahui Faraón tlen na para ma nechquixti ipan ni tlatzactli. ");
INSERT INTO nheBl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nechixtejque ipan nopa tlali campa itztoque hebreos. Ax quinamiqui niitztos nica pampa ax tleno tlen ax cuali nijchijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Huan quema nopa tlayacanquetl tlen panchihuani quiitac tlen José quiijtojtoya, quiilhui: ―Nojquiya nijpixqui se temictli huan niquitayaya para niquicpahuiyaya eyi chiquihuitl tlen pantzi. ");
INSERT INTO nheBl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Huan nopa chiquihuitl tlen huejcapa quipiyayaya nochi tlamantli pantzi para Faraón, pero totome hualayayaj huan quicuayayaj tlen eltoya ipan nochiqui tlen niquicpahuijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Huajca José quinanquili: ―Ya ni tlen motemic quinequi quiijtos; nopa eyi chiquihuitl tlen pantzi elis eyi tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Huan ica eyi tonali Faraón mitzquixtis tlen nica huan quichihuas ma mitzcuahuiyonica ipan se cuahuitl huan totome quicuase monacayo. ");
INSERT INTO nheBl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Huan hualhuiptla quiaxiti ixihui Faraón huan quichijqui se hueyi ilhuitl para nochi tlen quihuicayayaj tequitl ipan ichaj. Huan iniixtla nochi itlanotzalhua, Faraón tlatitlanqui ma quinquixtica ipan tlatzactli yajaya tlen achtohuiya quiyecohuayaya itlailis huan nojquiya nopa tlayacanca panchijquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Huan tlen quiyecoyaya itlailis sampa quitlali ipan itequi huan sampa pejqui quimaca icaxi queja achtohuiya. ");
INSERT INTO nheBl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pero ica nopa panchijquetl tlatitlanqui ma quicuahuiyonica ipan se cuahuitl queja José quiijtojtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Pero yonque ya nopa panoc, nopa tlen quiyeco itlailis Faraón ax quiilnamijqui José. ");
INSERT INTO nheBl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Quema panotoya ome xihuitl, se tonal Faraón quipixqui se temictli. Quitemijqui para ijcatoya iteno nopa atemitl Nilo, ");
INSERT INTO nheBl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","huan chicome huacaxme tlen yejyectzitzi huan tomahuaque quisayayaj ipan nopa atemitl huan tlacuajtinemiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Huan iniica quisque chicome huacaxme tlen fierojtique huan cocoxquetique. Quisque ipan nopa atemitl huan moquetzque iteno nechca nopa sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Teipa nopa huacaxme fierojtique huan cocoxquetique quincuajque nopa chicome huacaxme yejyectzitzi huan tomahuaque. Huan Faraón isac. ");
INSERT INTO nheBl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Teipa sampa cochqui huan quipixqui seyoc temictli. Quiitayaya chicome imacuayo trigo yejyectzitzi tlen temitoya ica iyol huan moscaltiyaya ipan san se tzontli. ");
INSERT INTO nheBl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Huan iniica chamanqui seyoc chicome imacuayo trigo tlen huactoc huan pitzantzitzi tlen quitlatijtoya nopa huac ajacatl tlen huala campa quisa tonati. ");
INSERT INTO nheBl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Huan nopa chicome imacuayo trigo tlen huactoc quincuajque nopa chicome imacuayo tlen tomahuac huan temitoc. Huan Faraón isac huan momacac cuenta para eliyaya se temictli. ");
INSERT INTO nheBl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pero ica ijnaloc nelmocuesohuayaya huan tlanahuati ma hualaca nochi tetonalitani huan nochi tlalnamijca tlacame ipan tlali Egipto. Huan Faraón quinpohuili itemic, pero niyon se tlen inijuanti ax huelqui quiilhui tlaque quinequiyaya quiijtos. ");
INSERT INTO nheBl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Huajca nopa tlacatl tlen quipixqui itequi para quiyecos itlailis Faraón quiilnamijqui José huan quiilhui Faraón: ―Ama niquilnamiqui tlen ax cuali nijchijtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Quema ticualanqui nohuaya huan ihuaya nopa tlayacanca panchijquetl, techtitlanqui tiome ipan nopa tlatzactli ipan ichaj nopa tlayacanquetl tlen nopa tlacame tlen mitzmocuitlahuíaj. ");
INSERT INTO nheBl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Huan se tlayohua nopa panchijquetl huan na, tijpixque sesen temictli. Huan sesen temictli quipixqui tlen quinequiyaya quiijtos. ");
INSERT INTO nheBl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Huan nopano ipan nopa tlatzactli itztoya tohuaya se hebreo telpocatl tlen quitequipanojtoya nopa tlayacanquetl. Huan tijpohuilijque totemic huan nopa hebreo techilhui tlaque quiijtosnequi. ");
INSERT INTO nheBl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Huan nochi panoc san queja techilhui. Na nimocuepqui sampa ipan notequi huan nopa seyoc quicuapilojque. ");
INSERT INTO nheBl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Huajca Faraón tlatitlanqui ma quinotzatij José huan nimantzi quiquixtijque tlen nopa tlatzactli. Huan José malti, huan motentzonxinqui, huan quipatlac iyoyo huan monexti iixtla Faraón. ");
INSERT INTO nheBl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Huan Faraón quiilhui: ―Nijpixqui se temictli huan axaca hueltoc quiixtoma, pero nijcactoc quema tijcaqui se temictli, hueli tiquixtoma. ");
INSERT INTO nheBl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Huan José quinanquili: ―Ax nihueli na, pero Toteco Dios, quena. Yajaya mitznextilis tlaque quinequi quiijtos motemic. ");
INSERT INTO nheBl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Huan Faraón quiilhui José: ―Ipan notemic, niquitayaya para niijcatoya iteno nopa atemitl Nilo, ");
INSERT INTO nheBl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","huan ipan nopa atemitl quisque chicome huacaxme tomahuaque huan yejyectzitzi tlen tlacuajtinemiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Huan iniica quisque seyoc chicome huacaxme tlen fierojtique huan cocoxquetique. ¡Ax quema niquinitztoya huacaxme nelfierojtique ipan nochi tlali Egipto! ");
INSERT INTO nheBl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Huan ni huacaxme cocoxquetique huan fierojtique quincuajque nopa achtohui huacaxme tlen tomahuaque. ");
INSERT INTO nheBl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pero yonque quincuajtoyaj, ax tomahuixque. Noja eliyayaj cocoxquetique queja achtohui. “Huan teipa niisac. ");
INSERT INTO nheBl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Teipa nijtemijqui chicome imacuayo trigo yejyectzitzi huan tomahuaque tlen temitoya ica iyol huan moscaltiyayaj ipan san se tzontli. ");
INSERT INTO nheBl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Huan iniica moscaltiyaya seyoc chicome imacuayo tlen tzocoyoltique, huan pitzantzitzi, huan huactoque ica nopa huac ajacatl tlen huala campa quisa tonati. ");
INSERT INTO nheBl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Huan ni chicome imacuayo tlen pitzantzitzi quincuajque nopa chicome imacuayo tlen tomahuaque. Na niquinpohuili notemic nopa tlacame tlen tetonalitaj, pero niyon se ax huelqui nechilhuis tlaque quiijtosnequi.” ");
INSERT INTO nheBl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Huajca José quiilhui Faraón: ―Nopa ome temictli tlen tijpixqui, san se. Toteco Dios mitzyolmelajtoc tlen yajaya quichihuas. ");
INSERT INTO nheBl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nopa chicome huacaxme tlen yejyectzitzi quinequi quiijtos chicome xihuitl. Huan san se quiijtosnequi nopa chicome imacuayo trigo tlen yejyectzitzi. ");
INSERT INTO nheBl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Huan nopa chicome huacaxme cocoxquetique huan fierojtique tlen quisque iniica nopa sequinoc, quinequi quiijtos seyoc chicome xihuitl. Huan san se quiijtosnequi nopa chicome imacuayo trigo tlen ax moscalti huan tlen quihuatzqui nopa huac ajacatl tlen huala campa quisa tonati. Quinequi quiijtos chicome xihuitl quema ax tleno oncas. ");
INSERT INTO nheBl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ya ni panos san queja nimitzilhuijtoc pampa Toteco Dios mitznextilijtoc tlen ya quichihuas. ");
INSERT INTO nheBl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hualas chicome xihuitl quema oncas tlahuel miyac pixquistli ipan nochi tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Huan teipa hualas chicome xihuitl tlen ax tleno oncas. Huan nopa mayantli ajsis campa hueli ipan nochi tlali Egipto hasta axaca quiilnamiquis nopa xihuitl tlen cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Elis nelhueyi nopa mayantli hasta ax nesis tlen achtohuiya oncac. ");
INSERT INTO nheBl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ta tijpixqui nopa temictli ompa pampa Toteco Dios motlalijtoc quichihuas ni tlamantli huan quichihuas nimantzi. ");
INSERT INTO nheBl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Huajca xijtemo se tlacatl tlen cuali iyolo huan tlen tlalnamiqui para tlayacanas ipan ni tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Huan ya ni xijchihua, totlanahuatijca. Xijnahuati ma quintlali gobernadores campa hueli ipan nochi ni tlali para ma quiajcocuise se coxtali tlen sesen macuili coxtali tlen quipixcase ipan tlali Egipto ipan nochi nopa chicome xihuitl quema tlahuel tlaoncas. ");
INSERT INTO nheBl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ma quisentilica nopa trigo ipan nochi altepetini ipan nopa chicome cuali xihuitl tlen huala huan ma quitlalica campa ta tijnahuatis, totlanahuatijca. Huan teipa oncas tlacualistli para nochi tlacame. ");
INSERT INTO nheBl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Queja nopa, mocahuas ajcoctoc nopa trigo ipan totlal para tlacame ax apismiquise ipan nopa chicome xihuitl quema oncas mayantli.” ");
INSERT INTO nheBl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Huajca Faraón huan itlapalehuijcahua quicualcajque tlen José quiijto, ");
INSERT INTO nheBl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","huan Faraón quinilhui: ―¿Canque tijpantise seyoc tlacatl queja ya ni tlen quipiya itonal Toteco Dios? ");
INSERT INTO nheBl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Huan teipa Faraón quiilhui José: ―Axaca tlen más tlalnamiqui huan tlen más quimati que ta. San ta mitzmatiltijtoc Toteco Dios nochi ni tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Huajca momaco mocahuas nochi tlen noaxca huan nochi notlacajhua quineltocase tlen tiquinilhuis. San na nielis más hueyi que ta pampa na nihueyi tlanahuatijquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Xiquita, na nimitztlalía tigobernador ipan nochi ni tlali Egipto. Quema quiijto ya ni, ");
INSERT INTO nheBl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Faraón moquixtili ipan ima ianillo tlen quipixqui nopa sello tlen quinexti itequihuejcayo huan quitlalili imaco José. Teipa tlanahuati ma quiyoyontica ica lino yoyomitl tlen nelcuali huan ma quitlalilica iquechtla se costli tlen oro. ");
INSERT INTO nheBl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Quichijqui nopa ompa tlanahuatijquetl huan quiilhui ma tlejco ipan iompa carro. Huan quinnahuati itlatequipanojcahua ma quiyacantiyaca huan chicahuac ma teyolmelahuase: “¡Ximotlancuaquetzaca! ¡Huala tlanahuatijquetl!” Queja nopa Faraón quitlali José para ma tlanahuati ipan nochi nopa tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Huan teipa Faraón quiilhui: ―Na nimitzmaca motequihuejcayo huan niyon se ipan nochi Egipto huelis quiolinis imacpil intla ax tijmaca tlanahuatili. ");
INSERT INTO nheBl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Huan Faraón quitocajtlali José, Zafnat Panea, huan quisihuajti ihuaya Asenat, iichpoca Potifera nopa totajtzi ipan altepetl On. Huan campa hueli ipan tlali Egipto nochi quiixmatque José. ");
INSERT INTO nheBl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Huan José quipiyayaya 30 xihuitl quema pejqui quitequipanohua Faraón, nopa tlanahuatijquetl ipan tlali Egipto. Teipa José quinahuatijtejqui Faraón huan pejqui yohui campa hueli ipan nochi tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Huan nopa tlali temacac miyac pixquistli ipan nopa chicome xihuitl quema tlahuel oncac, ");
INSERT INTO nheBl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","huan José quiajcojqui miyac trigo ipan nopa altepetini. Quicajtiyajqui ipan sese altepetl nopa trigo tlen quisentilijque ipan nopa pilaltepetzitzi nechca. ");
INSERT INTO nheBl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Huan José quisentili miyac trigo queja imiyaca xali iteno hueyi atl. Nelmiyac eliyaya nopa trigo hasta ayoc quiijcuilo quesqui coxtali pampa ax hueliyaya quinpohuaj. ");
INSERT INTO nheBl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Huan quema aya pehuayaya nopa xihuitl tlen mayantli, José quinpixqui ome iconehua ihuaya isihua, Asenat. ");
INSERT INTO nheBl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nopa achtohui quitocajti Manasés. (Manasés quinequi quiijtos Niquinilcajtoc.) Queja nopa quitocajti pampa quiijto: “Toteco Dios quichijtoc ma niquilcahua noteixmatcahua huan nochi tlen nitlaijiyohuijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Huan iompa cone quitocajti Efraín. (Efraín quinequi quiijtos Temaca Itlajca.) Queja nopa quitocajti pampa quiijto: “Toteco Dios quichijtoc ma niquinpiya noconehua ipan ni tlali campa nitlaijiyohuijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Huan tlanqui nopa chicome xihuitl quema tlahuel oncac pixquistli ipan tlali Egipto, ");
INSERT INTO nheBl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","huan pejqui nopa chicome xihuitl quema ax oncac pixquistli queja José quiijto. Huan oncac mayantli ipan nochi tlaltini nechca, pero ipan tlali Egipto oncayaya tlacualistli. ");
INSERT INTO nheBl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Huan quema Egipto ehuani pejque mayanaj, yajque quitlajtlanitoj trigo Faraón huan Faraón quinilhui nochi egiptome: “Xiyaca xiquitatij José huan xijchihuaca tlen ya inmechilhuis.” ");
INSERT INTO nheBl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Huan quema nopa mayantli ajsic campa hueli ipan nochi nopa tlali, José quitlapo nochi nopa huejhueyi caltini campa quiajcocuiyaya trigo para quinnamaquiltis nopa egiptome pampa nopa mayantli eliyaya tlahuel chicahuac. ");
INSERT INTO nheBl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Huan tlacame tlen ehuani tlen campa hueli tlaltini ajsiyayaj ipan tlali Egipto para quicohuase trigo ica José pampa ipan nochi nopa tlaltini, ax oncayaya tlaque quicuase. ");
INSERT INTO nheBl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Quema Jacob quimatqui para oncayaya trigo ipan tlali Egipto, quinilhui itelpocahua: “¿Para tlen inmochiyaj se ica seyoc para inquiitase ajqueya techpalehuis? ");
INSERT INTO nheBl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nechilhuijtoque para ipan tlali Egipto onca trigo. Xiyaca nepa huan xijcohuatij para noja tiitztose.” ");
INSERT INTO nheBl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Huajca majtlactli tlen iicnihua José yajque tlali Egipto quicohuatij trigo. ");
INSERT INTO nheBl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pero Jacob ax quicahuili ma yohui Benjamín, inelicni José pampa moilhui nohueli ipantisquía se tlamantli tlen fiero. ");
INSERT INTO nheBl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Huajca itelpocahua Israel yajque ininhuaya nochi sequinoc tlen yohuiyayaj tlacohuatij pampa campa hueli ipan nochi tlali Canaán oncayaya mayantli. ");
INSERT INTO nheBl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Huan José eliyaya gobernador ipan tlali Egipto huan yajaya tlen quinnamaquiltiyaya trigo nochi tlacame tlen ajsiyayaj tlen campa hueli tlaltini. Huan quema iicnihua José monextijque iixpa, motlancuaquetzque huan mopachojque tlalchi queja momatque tlatlepanitaj. ");
INSERT INTO nheBl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Huan José quinixmatqui iicnihua quema quinitac, pero quichijqui queja ax quinixmatiyaya. Quincamahui ica cualantli huan quinilhui: ―¿Canque inhualahuij? Huan quiilhuijque: ―Tihualahuij tlali Canaán para titlacohuaquij. ");
INSERT INTO nheBl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Huan yonque José quinixmatqui iicnihua, inijuanti ax quiixmatque. ");
INSERT INTO nheBl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Huan quiilnamijqui nopa temictli tlen quipixqui tlen iicnihua achtohuiya huan quinilhui: ―Ax neli inhualahuij para intlacohuase. Inhualajtoque inquiitaquij quejatza eltoc totlal huan canica huelis intechtlanise. ");
INSERT INTO nheBl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Huan inijuanti quinanquilijque: ―¡Axtle, tate! Timotequipanojcahua tihualajtoque tijcohuaquij trigo. ");
INSERT INTO nheBl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nochi tojuanti tiiconehua san se tlacatl. Ticuajcualme. Ax quema tiyajtoque ipan se altepetl para tijtlachilise quejatza hueli tijtlanise. ");
INSERT INTO nheBl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Huan José quiijto: ―¡Ax neli! Inhualahuij inquiitaquij quejatza huan canica huelis intechtlanise ipan totlal. ");
INSERT INTO nheBl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Pero inijuanti tlananquilijque: ―Timotlatequipanojcahua tiitztoque 12 tiicnime ica san se tlacatl huan tiitztoque ipan tlali Canaán. Toicni teipa ejquetl mocajqui ihuaya totata huan se ayoc aqui tohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Pero José sampa quinilhui: ―Temachtli imojuanti intlapijpiyani, ");
INSERT INTO nheBl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","pero ica ya ni tiquitase. Ica itequihuejcayo Faraón, nitlanahuatía para ax hueli inquisase nica hasta ma huala imoicni teipa ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ma yohui se tlen imojuanti para quicuiti. Nopa sequin mocahuase tzactoque. Tiquitase intla nelía tlen inquiijtojtoque. Intla axtle, huajca nijmatis melahuac intlapijpiyaj pampa inquinequij intechtlanise. ");
INSERT INTO nheBl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Huan José quintzajqui nochi inijuanti para eyi tonali, ");
INSERT INTO nheBl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","pero ica ihualhuiptlatica quinilhui: ―Na nijtlepanita Toteco Dios, huajca xijchihuaca ya ni huan nimechcahuilis initztose. ");
INSERT INTO nheBl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Intla nelía incuajcualme, ma mocahua tzactoc san se tlen imojuanti. Huan sequinoc imojuanti xijhuicaca trigo para ma tlacuaca imofamilia. ");
INSERT INTO nheBl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pero monequi xinechhualiquilica imoicni teipa ejquetl para tiquitase intla inquiijtojtoque tlen melahuac. Pero intla axtle, huajca inmiquise. Huan inijuanti quicualcajque, ");
INSERT INTO nheBl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","pero moilhuiyayaj se ica seyoc: ―Melahuac fiero tijchihuilijque toicni. Ax tijchihuilijque cuenta quema tlahuel mocuesohuayaya huan techtlajtlaniyaya ma tijtlasojtlaca. Huan yeca ama topani eltoc ni cuesoli. ");
INSERT INTO nheBl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Huan Rubén quinilhui: ―Na nimechilhui para ax tleno xijchihuilica, pero ax innechcajque huan ama monequi titlaxtlahuase ipampa imiquilis. ");
INSERT INTO nheBl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Pero ax quimatiyayaj intla José quimachiliyaya inintlajtol pampa José quinnojnotzayaya ica inintlajtol egiptome huan seyoc quinixtomiliyaya tlen quiijtohua. ");
INSERT INTO nheBl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Huan José mohuejcatlali tlen iicnihua para ax huelis quiitase huan pejqui choca. Teipa moyoltlali huan mocuepqui campa itztoyaj para quincamahui. Huan quiiyocaquixti Simeón huan iniixtla quinnahuati itequipanojcahua ma quiilpica. ");
INSERT INTO nheBl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Teipa tlanahuati ma quintemitilica inincoxtalhua iicnihua huan ma quincuepilica sese inintomi ipan inincoxtal. Nojquiya tlanahuati ma quinmacaca tlacualistli para ipan ojtli. Huan itlatequipanojcahua queja nopa quichijque. ");
INSERT INTO nheBl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Huan quintlamamaltijque ininburrojhua huan quistejque. ");
INSERT INTO nheBl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Huan quema ajsitoj campa tonilisquíaj, se tlen inijuanti quitlapo icoxtal para quitlamacas iburro huan quiitac itomi eltoya icoxtal ijtic. ");
INSERT INTO nheBl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Huajca quinilhui iicnihua: ―¡Xiquitaca nechcuepilijque notomi! ¡Nica eltoc ipan nocoxtal! Huan nochi momajmatijque miyac, huan huihuipicayayaj huan moilhuiyayaj se ica seyoc: ―¿Tlaque techchihuilijtoc Toteco Dios? ");
INSERT INTO nheBl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Huan quema ajsitoj tlali Canaán, quipohuilijque inintata, Jacob, nochi tlen quinpanotoya, quiilhuijque: ");
INSERT INTO nheBl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","―Nopa tlacatl tlen tlanahuatía ipan nopa tlali technojnotzqui ica cualantli huan techilhui para san tiyajtoyaj titlachijchiyatij ipan itlal para huelis tijtlanisquíaj. ");
INSERT INTO nheBl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pero tiquilhuijque para ticuali tlacame huan ax quema titlapijpixtoque. ");
INSERT INTO nheBl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tiquilhuijque para tieliyayaj 12 tiicnime tlen san se tlacatl, huan se ayoc itztoc tohuaya. Nojquiya tiquilhuijque para nopa teipa ejquetl mocajtoya mohuaya ta nica ipan Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Huajca yaja techilhui para monequi quiitas intla nelía ticuajcualme. Quiijto monequi se tlen tojuanti ma mocahua nopano huan para nopa sequinoc tojuanti ma tihualaca tijhualicaca trigo para tofamilias tlen mayanaj, ");
INSERT INTO nheBl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","pero quiijto teipa monequi tijhuiquilise toicni teipa ejquetl. Queja nopa quiijto para melahuac quimatis intla ticuali tlacame o san titlapijpiyani. Huan quiijto para queja nopa quimajcahuas toicni huan huelis titlacohuase ipan itlal ica cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Huan quema iicnihua José quiixcuepque inincoxtal, quiitaque para ipan sese inincoxtal oncayaya ininpilbolsa ica nopa tomi tlen quihuicatoyaj. Huajca inijuanti huan inintata momajmatijque. ");
INSERT INTO nheBl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Huan Jacob quinilhui: ―Innechquixtilise nochi noconehua. José ayoc aqui tohuaya, Simeón nojquiya, huan ama innechquixtilise Benjamín. Ax tleno quisa cuali para na. ");
INSERT INTO nheBl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Huajca Rubén quiilhui itata: ―Xijcahua Benjamín ma yohui. Huan nijmocuitlahuis huan nimitzcuepilis. Intla ax nimitzcuepilis, huelis tiquinmictis nochi ome noconehua. ");
INSERT INTO nheBl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pero Jacob quiilhui: ―Nocone ax yas imohuaya. Iicni ya mijqui huan san ya mocahua. Intla ipantis tlen fiero ipan ojtli, innechchihuilise ma nihuehuejmiquis ica cuesoli. ");
INSERT INTO nheBl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Huan nopa mayantli más eliyaya ipan inintlal. ");
INSERT INTO nheBl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Huan Jacob huan iteixmatcahua quitlamicuajque nochi nopa trigo tlen quicuitoj ipan tlali Egipto, huajca quinilhui itelpocahua: ―Xiyaca sampa xijcohuatij trigo. ");
INSERT INTO nheBl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pero Judá quiilhui: ―Nopa tlacatl ya techilhuijtoc para ax huelis tiquitase intla ax tijhuicase toicni teipa ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Huajca intla tijcahuas ma yohui tohuaya Benjamín, tiyase tijcohuatij trigo. ");
INSERT INTO nheBl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pero intla ax tijcahuas ma yohui, ax tiyase pampa san tlapic. Nopa tlacatl techilhui intla ax tijhuicaj nepa toicni teipa ejquetl, ax huelis tiquitase. ");
INSERT INTO nheBl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Huajca Israel quiijto: ―¿Para tlen innechchihuilíaj tlen fiero huan inquiilhuijque nopa tlacatl para inquipiyayayaj seyoc imoicni? ");
INSERT INTO nheBl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Huan inijuanti quiilhuijque: ―Tiquilhuijque pampa yajaya techtlajtlaniyaya miyac tlen tojuanti huan tofamilias. Techtlajtlani intla noja itztoc totata, huan intla tijpiyaj seyoc toicni. Huan san tijnanquiliyayaj tlen techtlajtlaniyaya. ¿Quejatza tijmatisquíaj para techilhuisquía ma tijhuiquilisquíaj toicni? ");
INSERT INTO nheBl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Huan Judá quiilhui Israel, itata: ―Intla tijnequi ma tiitztoca, xijcahuili ma yohui Benjamín, huan na nijmocuitlahuis huan tiyase nimantzi. Queja nopa ax timiquise, niyon ta, niyon tojuanti, niyon toconehua. ");
INSERT INTO nheBl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Huan intla tlen hueli ipantis, na notlajtlacol. Intla ax nimitzcuepilis, huajca nijhuicas tlajtlacoli moixtla para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Intla ax tihuejcajtosquíaj, ya tiyajtosquíaj huan ya tihualajtosquíaj ompa. ");
INSERT INTO nheBl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Huajca itata quinilhui: ―Ayoc onca seyoc tlamantli tlen hueli tijchihuase, huajca ama xijchihuaca ya ni. Xijtemilica imocoxtal tlamantli tlen más cuali tlen temaca ni totlal para xijtlamajmacatij nopa tlacatl. Xijhuiquilica quentzi bálsamo, sayolnectli, tlaajhuiyacayotl, mirra, huan almendras huan nopa nueces tlen itoca pistache tlen nelía ajhuiyac. ");
INSERT INTO nheBl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Xijhuicaca nojquiya ome huelta imiyaca nopa tomi tlen inmechcuepilijque ipan imocoxtal. Nohueli mocuapolojque. ");
INSERT INTO nheBl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Huan xijhuicaca imoicni Benjamín huan sampa xiquitatij nopa tlacatl. ");
INSERT INTO nheBl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Toteco Tlen Quipiya Nochi Chicahualistli ma inmechtlasojtla. Ma inmechpalehui iixtla nopa tlacatl para ma quimajcahua nopa seyoc imoicni huan Benjamín para ma mocuepaca imohuaya. Huan ica na, intla monequi niquinpolos noconehua, huajca queja nopa ma eli. ");
INSERT INTO nheBl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Huajca itelpocahua Jacob quihuicaque iniicni, Benjamín, huan tlamantli tlen temajmacatij, huan ome hueltas imiyaca tomi. Teipa quistejque, moisihuiltijque yajque tlali Egipto huan monextitoj iixtla José. ");
INSERT INTO nheBl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Huan quema José quiitac Benjamín ininhuaya hualayaya, quiilhui itequipanojca tlen más tlayacana ipan ichaj: ―Xiquinhuica ni tlacame nochaj, huan xijmicti se huacax huan xijcualtlali pampa tlacuase nohuaya tlajcotona. ");
INSERT INTO nheBl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Huan nopa tlatequipanojquetl quichijqui queja José quinahuati huan quinhuicac ichaj. ");
INSERT INTO nheBl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Pero inijuanti momajmatijque pampa quinhuicayaya ichaj José huan moilhuijque: ―Techhualicatoc nica ipampa nopa tomi tlen techcuepilijque quema achtohui tihualajque. Ama quiijtos tiquixtequilijque, huan techquixtilis totlapiyalhua huan techitzquise. Techchihualtise ma titequitica queja titequipanohuani tlen quincojtoc. ");
INSERT INTO nheBl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Huajca quema ajsitoj campa calaquij ipan ichaj José, monechcahuijque campa nopa tlayacanca tlatequipanojquetl, ");
INSERT INTO nheBl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","huan quiilhuijque: ―¡Tate, xitechtlacaquili! Quema achtohui tihualajque tijcohuacoj trigo, ");
INSERT INTO nheBl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","tiquistejque ica totrigo huan tiajsitoj campa ticochisquíaj ipan ojtli. Huan tijtlapojque tocoxtalhua, huan icamaco sesen coxtali eltoya totomi sesen tojuanti. Eltoya ajsitoc totomi tlen ica tijcojtoyaj nopa trigo. Huan ama tijhualicatoque para tijcuepase. ");
INSERT INTO nheBl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Huan iyoca tijhualicaque más tomi para tijcohuase más trigo. Pero ax tijmatij ajqueya quitlali totomi ipan tocoxtalhua. ");
INSERT INTO nheBl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Huan nopa tlayacanca tlatequipanojquetl quinilhui: ―Amo ximocuesoca. Dios imoTeco huan iTeco imotata, huelis yajaya quitlali nopa tomi ipan imocoxtalhua pampa na nijseli nopa tomi tlen intechmacaque. Huan nopa tlatequipanojquetl quiquixti Simeón huan quihualicac campa itztoyaj nopa icnime. ");
INSERT INTO nheBl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Teipa quinhuicac san sejco hasta ichaj José. Huan quinmacac atl para ma moicxipajpacaca huan nojquiya quintlamacac ininburrojhua. ");
INSERT INTO nheBl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Huan inijuanti quicualtlalijque tlen quimacasquíaj José huan quichixque para ma ajsi tlajcotona pampa quicactoyaj para tlacuasquía ininhuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Huan quema José ajsito ichaj, quimacaque tlen quihuiquilijtoyaj, huan motlancuaquetzque huan mopachojque hasta tlalchi para quitlepanitase. ");
INSERT INTO nheBl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Huan José quintlajtlani quejatza itztoyaj huan nojquiya quinilhui: ―¿Quejatza itztoc imotata, nopa tatatzi tlen innechcamahuijque? ¿Noja itztoc? ");
INSERT INTO nheBl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Huan inijuanti quiilhuijque: ―Totata, motequipanojca, noja itztoc huan itztoc cuali. ");
INSERT INTO nheBl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Huan José quiixtemo Benjamín hasta quipanti. Elqui inelicni tlen quitlacatilti inana. Huan José quiijto: ―¿Ya ni imoicni teipa ejquetl tlen innechcamahuijque? Huan José quiilhui Benjamín: ―¡Ma Toteco Dios mitztiochihua, nocone! ");
INSERT INTO nheBl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Huan quema José quiijto ya ni, monejqui moyoltetilis para ax chocas iniixtla pampa sampa quiitac iicni. Huan nimantzi quistihuetzqui, huan calajqui ipan icuarto huan nopano tlahuel miyac chocac. ");
INSERT INTO nheBl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Teipa quema huelqui moyoltlali, mixami huan mocuepqui campa iicnihua itztoyaj. Teipa quinilhui itlatequipanojcahua: “¡Xijtecaca ne tlacualistli!” ");
INSERT INTO nheBl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Huan quitequilijque José itlacualis iselti ipan se mesa, huan iicnihua ipan seyoc. Huan ipan seyoc mesa quintequilijque nopa egiptome tlen tlacuayayaj ihuaya José. Pampa tlali Egipto ehuani quinijiyayayaj hebreo tlacame huan ax tlacuayayaj ininhuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Huan José quinilhui sese iicnihua canque mosehuise. Quinsehui queja tlacajtiyajque tlen achtohui ejquetl hasta tlen teipa ejquetl. Pejqui ica tlen más hueyi hasta tlen más pilsiltzi. Huan nopa icnime mosentlachilijque. ");
INSERT INTO nheBl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Huan quema quintequilijque nopa tlacualistli tlen eltoya ipan imesa José, Benjamín quitequilijque macuili hueltas más imiyaca que tlen quintequilijque ne sequinoc. Huan queja nopa san sejco tlaique huan tlacuajque. ");
INSERT INTO nheBl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Teipa José quiilhui itlayacanca tlatequipanojca: ―Xijtemiti inincoxtal ni tlacame ica nochi trigo tlen hueli quihuicase huan xijtlali sese inintomi ipan icamac inincoxtal. ");
INSERT INTO nheBl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nojquiya xijtlali nocaxi tlen plata ipan icoxtal iniicni tlen teipa ejquetl, ihuaya nopa tomi tlen tlaxtlajqui para trigo. Huan nopa tlatequipanojquetl quichijqui queja José quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Huan quema san ontlatlanesqui, José quincahuili iicnihua ma yaca ihuaya ininburrojhua. ");
INSERT INTO nheBl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pero aya huejca yajtoyaj tlen nopa altepetl quema José quiilhui itlatequipanojca: ―Xiya xiquintoquili nopa tlacame huan quema tiquinajsiti, xiquinilhui: ‘¿Para tlen inquicueptoque tlen cuali ica tlen ax cuali? ¿Para tlen inquiixtectoque nopa caxitl tlen plata ");
INSERT INTO nheBl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","tlen noteco quitequihuía para ipan atlis huan para quiitas tlen panos teipa? ¡Inquichijtoque tlen fiero!’ ");
INSERT INTO nheBl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Huan quema nopa tlatequipanojquetl quinajsito, quinilhui nochi ya ni. ");
INSERT INTO nheBl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Huan nopa icnime quiilhuijque: ―¿Para tlen tinechcamahuía queja nopa? ¡Ax quema tijchihuasquíaj nopa tlamantli! ");
INSERT INTO nheBl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Xiquita sampa tijhualicaque tlen tlali Canaán nopa tomi tlen eltoya ipan tocoxtal. ¿Quejatza tiquixtequise oro o plata tlen ichaj moteco? ");
INSERT INTO nheBl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","¡Ma miqui aqui hueli tlen tojuanti tlen tijpantilis nopa caxitl huan nochi tojuanti timitztequipanose san tlapic! ");
INSERT INTO nheBl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Huajca nopa tlatequipanojquetl quiijto: ―Cualtitoc tlen inquiijtohuaj, pero san yajaya tlen quipiya nopa caxitl techtequipanos san tlapic. Nopa sequin ax quipiyase tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Huan sesen tlen inijuanti nimantzi quitemohui icoxtal huan quitlapo. ");
INSERT INTO nheBl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Huan nopa tlatequipanojquetl quitemo ipan sesen coxtali. Pejqui ica tlen achtohui ejquetl hasta nopa teipa ejquetl huan quipanti nopa caxitl ipan Benjamín icoxtal. ");
INSERT INTO nheBl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Huajca quitzayanque ininyoyo ica hueyi cuesoli. Huan teipa quintlamamaltijque ininburrojhua huan mocuepque ipan nopa altepetl. ");
INSERT INTO nheBl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Huan quema Judá huan iicnihua ajsitoj ichaj José, ya noja itztoya nopano. Huan motlancuaquetzque iixtla huan mopachojque tlalchi, ");
INSERT INTO nheBl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","huan José quinilhui: ―¿Tlaque inquichijtoque? ¿Ax inquimatij para se tlacatl queja na quimati tlen quichihuaj sequinoc? ");
INSERT INTO nheBl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Huan Judá quiijto: ―¿Tlaque huelis timitznanquilise? ¿Quejatza huelis tijnextise para ax tijchijtoque? Toteco Dios techpantijtoc titlajtlacolchijtoque. Huajca nica tiitztoque huan timitztequipanose san tlapic ihuaya tlen quipixtoya nopa caxitl. ");
INSERT INTO nheBl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Pero José quiijto: ―Axtle, ax queja nopa. San ya ne tlen quipiyayaya nopa caxitl nechtequipanos san tlapic. Huan ne sequinoc imojuanti huelis inmocuepase ica cuali hasta ichaj imotata. ");
INSERT INTO nheBl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Huajca Judá monechcahui campa José huan quiilhui: ―Na nimitztlajtlanía, noteco, para xinechcahuili nimitzilhuis se tlamantli tlen axaca quimati. Xijchihua se favor, amo xicualani nohuaya pampa tieltoc queja Faraón. ");
INSERT INTO nheBl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Achtohui ta titechtlajtlani intla tijpiyayayaj totata huan tlen seyoc totlaca icni. ");
INSERT INTO nheBl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Huan timitzilhuijque para tijpiyaj totata tlen huehuentzi huan tijpiyaj se toicni tlen neltelpocatl tlen tlacatqui quema totata eliyaya nelhuehuentzi. Huan timitzilhuijque para totata quiicnelía miyac. San ya mocahua tlen inana. Nopa seyoc iicni ya mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Huajca titechtlajtlani ma tijhualicaca pampa tijnequiyaya tiquixmatis. ");
INSERT INTO nheBl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Huan timitzilhuijque nopa telpocatl ax hueli quicajtehua itata. Intla quicajtehuasquía, itata miquisquía. ");
INSERT INTO nheBl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Pero ta titechilhui intla ya ax hualayaya tohuaya, ayoc titechselisquía. ");
INSERT INTO nheBl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Huajca quema timocuepque campa totata, tijpohuilijque nochi tlen titechilhuijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Huan teipa totata techilhui ma tihualaca tijcohuaquij se quentzi trigo. ");
INSERT INTO nheBl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Pero tiquilhuijque para ax hueli tihualase hasta toicni teipa ejquetl hualas tohuaya. Intla ax tohuaya huala, ax huelis timitzitase. ");
INSERT INTO nheBl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Huan totata techilhui: ‘Inquimatij nosihua nechmacac ome noconehua. ");
INSERT INTO nheBl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Huan se tlen nopa ome quisqui huan nimoilhuía se tecuani quicuajqui pampa hasta ama ayoc niquitztoc. ");
INSERT INTO nheBl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Intla inquihuicaj huejca ni seyoc nocone huan intla ipantis se tlamantli tlen fiero, innechchihualtise ma nihuehuejmiqui ica cuesoli.’ ");
INSERT INTO nheBl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Yeca intla toicni ax mocuepas tohuaya, ");
INSERT INTO nheBl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","totata tlen ya nelhuehuentzi nimantzi miquis ica cuesoli pampa ax quiitas. Huan tijhuicase tlajtlacoli ipampa imiquilis. ");
INSERT INTO nheBl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na niquilhui notata para ma quicahua nomaco huan nijmocuitlahuisquía. Nojquiya niquilhui para intla ax nijcuepilis, huajca nijhuicas tlajtlacoli iixtla para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Yeca nimitztlajtlanía, xinechcahuili ma nimocahuas nimitztequipanos na huan ax ya. Xijcahuili ma mocuepa ihuaya iicnihua. ");
INSERT INTO nheBl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Pampa quejatza huelis nimocuepas huan niquitas notata, intla noicni ax yohui nohuaya? Ax nijnequi niquitas quejatza tlaijiyohuis notata.” ");
INSERT INTO nheBl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Huan José ayoc huelqui moijiyohuía para ax chocas iniixtla itlatequipanojcahua tlen itztoyaj nopano. Huan chicahuac quinilhui: “¡Xiquisaca nochi imojuanti tlen initztoque nica!” Huajca nochi itlapalehuijcahua quisque pampa José quinequiyaya itztos iselti ica iicnihua quema quinilhui ajqueya ya. ");
INSERT INTO nheBl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Huan yajaya pejqui choca chicahuac hasta nochi nopa egiptome ipan ichaj quicajque. Huan ajsic nopa tlajtoli hasta nopa hueyi tequicali campa itztoc Faraón. ");
INSERT INTO nheBl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Huan José quinilhui iicnihua: ―Na niJosé. ¿Noja itztoc notata? Huan iicnihua tlahuel momajmatijque iixtla hasta ax hueliyayaj camatij. ");
INSERT INTO nheBl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Pero ya quinilhui: ―Ximonechcahuica campa na. Huan quema monechcahuijque campa ya, yajaya quinilhui: ―Na niimoicni José tlen innechnamacaque para ma nechhualicaca tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Amo ximocuesoca, niyon amo ximocualanica pampa innechnamacaque. Toteco Dios nechtitlanqui achtohui ma nitlayacanas nica para ax timiquise. ");
INSERT INTO nheBl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ya panoc ome xihuitl ica mayantli ipan ni tlali, pero noja polihui seyoc macuili xihuitl quema ax oncas niyon quentzi pixquistli huan axaca huelis tlatojtocas. ");
INSERT INTO nheBl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Toteco Dios nechtitlanqui nica achtohui para nijmanahuis imoyolis para ma mocahuaca imoteipa ixhuihua para mochihuase tlahuel miyac tlacame ipan tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Huajca ax elqui imojuanti tlen innechtitlanque nica. ¡Axtle! Elqui Toteco tlen nechtitlanqui, huan nechtlalijtoc niitlapalehuijca Faraón huan na tlen nijconsejomaca. Yajaya nechtlalijtoc ma nitlanahuati ipan ichaj huan ma nieli nigobernador ipan nochi ni tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Huajca xiyaca nimantzi campa itztoc notata huan xiquilhuica para icone, José, quiijtohua para Toteco Dios nechtlalijtoc ma nitlanahuati ipan nochi tlali Egipto. Huajca nimantzi ma huala nechitaqui. Ma ax huejcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Huelis itztos nonechca, nopano campa itoca Gosén nica ipan tlali Egipto ihuaya imojuanti, huan imoconehua, huan imoixhuihua, huan nochi imotlapiyalhua huan nochi tlen inquipiyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nica nimechmacas tlacualistli para nochi imofamilia huan nochi tlen itztoque imohuaya para ma ax tleno inmechpolos. Noja oncas ni mayantli para seyoc macuili xihuitl. Intla ax hualas, imojuanti huan nochi tlen inquipiyaj tlahuel intlaijiyohuise. ");
INSERT INTO nheBl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Teipa José quiijto: ―Xiquitaca imojuanti huan Benjamín para nelía na niJosé. ");
INSERT INTO nheBl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Huajca xijpohuilica notata tlaque tequihuejcayotl nijpiya nica ipan Egipto huan nochi tlen inquiitztoque nica. San monequi nimantzi xijhualicatij notata. ");
INSERT INTO nheBl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Huan José ica nochi iyolo quicuanajnahuajqui iicni Benjamín huan chocac miyac iquechpa. Huan Benjamín quicuanajnahuajtoc chocac ipan José. ");
INSERT INTO nheBl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Teipa José quintzoponi nochi iicnihua huan chocac quema quincuanajnahuajqui. Huan teipa iicnihua pejque quicamahuíaj. ");
INSERT INTO nheBl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Huan ipan ichaj Faraón quicajque para ajsicoj iicnihua José huan nelía pajque Faraón huan nochi itlapalehuijcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Huan Faraón quiilhui José: ―Xiquinilhui moicnihua ma quintlamamaltica inintlapiyalhua huan ma mocuepaca ipan tlali Canaán, ");
INSERT INTO nheBl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","huan ma nechhualiquilica imotata huan nochi ininteixmatcahua. Na niquinmacas nopa tlali tlen más cuali ipan nochi ni tlali Egipto. Huan quicuase tlen más cuali tlen ni tlali temaca. ");
INSERT INTO nheBl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Xiquinilhui ma quihuicaca cuacarros tlen tlali Egipto para ma quinhualicaca ininsihuajhua ihuaya ininconehua huan imotata. ");
INSERT INTO nheBl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ma ax mocuesoca ica tlen ama quipiyaj. Nochi tlen cuali tlen onca ipan ni tlali Egipto teipa elis iniaxca. ");
INSERT INTO nheBl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Huan queja nopa quichijque itelpocahua Israel. Huan José quinmacac cuacarros queja Faraón tlanahuatijtoya huan quinmacac tlacualistli para ipan ojtli. ");
INSERT INTO nheBl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nojquiya quinmacac yoyomitl yancuic para ma mopatlase, pero Benjamín quimacac 300 tomi tlen plata huan macuili iyoyo para mopatlas. ");
INSERT INTO nheBl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Huan para itata José quititlanili majtlactli burrojme tlamamajtoque ica tlamantli tlen onca ipan tlali Egipto huan nojquiya quinmacac seyoc majtlactli burrojme tlamamajtoque ica trigo, pantzi huan tlacualistli para ma tlacua itata ipan ojtli. ");
INSERT INTO nheBl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Huan quema José quinmajcajqui iicnihua, quinilhui: ―Amo ximonajnanquilica ipan ojtli. Huan inijuanti yajque. ");
INSERT INTO nheBl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Huan quisque ipan tlali Egipto huan ajsitoj tlali Canaán campa itztoya inintata, Jacob. ");
INSERT INTO nheBl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Huan quema quipohuilijque Jacob para José noja itztoya huan yajaya tlen tlanahuatiyaya ipan nochi tlali Egipto, ax quimatiyaya tlaque quiijtos, niyon tlaque quichihuas pampa ax hueliyaya quineltoca. ");
INSERT INTO nheBl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pero quema quipohuilijque nochi tlen José quiijtojtoya huan quema quinitac nopa cuacarros tlen José quintitlantoya para quinhuicase, nelía pajqui miyac. ");
INSERT INTO nheBl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Huan huajca quiijto: “Nelía temachtli, nocone José noja itztoc huan ax nimiquis hasta niyas niquitati.” ");
INSERT INTO nheBl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Huan Israel, tlen nojquiya itoca eliyaya Jacob, quisqui ipan ojtli ica nochi tlen quipiyayaya. Huan quema ajsito ipan Beerseba, quimacac se tlacajcahualistli Toteco Dios, yajaya tlen nojquiya iTeco itata, Isaac. ");
INSERT INTO nheBl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Huan nopa tlayohua Toteco quicamahui Israel ipan se temictli, huan quinotzqui ica itoca Jacob. Huan Jacob quinanquili: ―Nica niitztoc, noTeco. ");
INSERT INTO nheBl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Huajca Toteco Dios quiilhui: ―Na niDios nimoTeco. Na niiTeco motata. Amo ximajmahui para tiyas tlali Egipto pampa nopano nijchihuas para moteipa ixhuihua tlahuel momiyaquilise hasta mochihuase se altepetl ica tlahuel miyac tlacame ica san se inieso. ");
INSERT INTO nheBl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Na niyas mohuaya ipan Egipto huan teipa niquinquixtis moteipa ixhuihua nopano. Quema timiquis, motelpoca José itztos monechca. ");
INSERT INTO nheBl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Huan itelpocahua Jacob quitlalijque inintata, huan ininconehua huan ininsihuajhua ipan nopa cuacarros tlen Faraón quintitlantoya huan yajque. Huan queja nopa Israel quistejqui tlen Beerseba. ");
INSERT INTO nheBl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Huan Jacob huan itelpocahua quinhuicaque ipan tlali Egipto inintlapiyalhua huan nochi tlen quipixtoyaj ipan tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yajque nochi iconehua huan iixhuihua; tlacame huan sihuame. ");
INSERT INTO nheBl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nica nimitzilhuis inintoca itelpocahua huan iteipa ixhuihua Israel o Jacob tlen yajque tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Yajqui Rubén iachtohui ejca cone Jacob. Yajque iconehua Rubén: Hanoc, Falú, Hezrón huan Carmi. ");
INSERT INTO nheBl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Yajque Simeón huan iconehua: Jemuel, Jamín, Ohad, Jaquín, Zohar huan Saúl tlen eliyaya icone se sihuatl cananea. ");
INSERT INTO nheBl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Yajque Leví huan iconehua tlen itoca eliyaya: Gersón, Coat huan Merari. ");
INSERT INTO nheBl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yajque Judá huan iconehua: Sela, Fares huan Zara. Pero iconehua tlen inintoca Er huan Onán ya mictoyaj ipan tlali Canaán. Huan iconehua Fares elque: Hezrón huan Hamul. ");
INSERT INTO nheBl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yajque Isacar huan iconehua: Tola, Fúa, Job huan Simrón. ");
INSERT INTO nheBl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Yajque Zabulón huan iconehua tlen inintoca eliyayaj: Sered, Elón huan Jahleel. ");
INSERT INTO nheBl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nochi ni tlacame tlen nimitzilhuijtoc nica elque iconehua Jacob ihuaya Lea huan yajque tlali Egipto ica Jacob. Huan nochi ni ininconehua tlacatque quema itztoyaj ipan tlali Aram. Nojquiya Jacob huan Lea quipixque se iniichpoca tlen itoca Dina. Ininconehua huan iniixhuihua Jacob huan Lea mochijque 33. ");
INSERT INTO nheBl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Nojquiya yajque tlali Egipto Gad huan iconehua: Zifión, Hagui, Ezbón, Suni, Eri, Arodi huan Areli. ");
INSERT INTO nheBl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Yajque Aser huan iconehua: Imna, Isúa, Isúi, Bería huan ininsihua icni tlen itoca Sera. Huan Bería ya quinpixqui iconehua: Heber huan Malquiel. ");
INSERT INTO nheBl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tlen nimitzilhuijtoc nica elque iconehua Jacob ica Zilpa huan yajque tlali Egipto ininhuaya. Zilpa elqui nopa tlatequipanojquetl tlen Labán quimacac iichpoca, Lea, huan teipa Lea quimacac ihuehue para ma eli isihua. Huan ininconehua huan iniixhuihua Jacob ihuaya Zilpa elque 16 tlacame ica nochi. ");
INSERT INTO nheBl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Huan nojquiya yajque tlen eltoyaj iconehua Raquel, isihua Jacob huan inintoca ininconehua elque: José huan Benjamín. ");
INSERT INTO nheBl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Huan ipan Egipto José quinpixqui coneme ihuaya isihua Asena. Asena elqui iichpoca Potifera, tlen eliyaya se totajtzi nopano ipan altepetl On. Ininconehua elque: Manasés huan Efraín. ");
INSERT INTO nheBl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Huan iconehua Benjamín elque: Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim huan Ard. ");
INSERT INTO nheBl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tlen nimitzilhuijtoc nica elque iconehua huan iixhuihua Raquel huan Jacob. Huan mochijque 14 tlacame para nochi. ");
INSERT INTO nheBl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Huan nojquiya yajque tlali Egipto Dan, icone Jacob, huan icone: Husim. ");
INSERT INTO nheBl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Huan nojquiya yajque Neftalí huan iconehua: Jahzeel, Guni, Jeser huan Silem. ");
INSERT INTO nheBl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Huan inijuanti elque iconehua Bilha, nopa tlatequipanojquetl tlen Labán quimacac iichpoca, Raquel, huan teipa Raquel quimacac Jacob para ma eli isihua. Huan iconehua huan iixhuihua Jacob ica Bilha elque chicome para nochi. ");
INSERT INTO nheBl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Huan para nochi nopa tlacame tlen yajque Egipto ihuaya Jacob tlen nelía san se inieso elque 66, huan ax quinpojque inintelpocahua ininsihuajhua. ");
INSERT INTO nheBl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Huan ica nopa ome iconehua José tlen tlacatque ipan Egipto mochijque 70 tlacame ipan ifamilia Jacob quema ajsitoj nopano. ");
INSERT INTO nheBl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Huan Jacob quititlanqui Judá ma tlayacana para quiitati José huan quimatiltis ma quinamiquiqui ipan tlali Gosén. Huan quema Judá ajsito campa José, ");
INSERT INTO nheBl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","tlanahuati ma quicualtlalica icarro para yas quinamiquiti itata. Huan quema ajsito iixtla itata, quinajnahuajqui huan huejcajqui choca ipan iajcol. ");
INSERT INTO nheBl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Huan Israel quiilhui José: ―Ama ya huelis nimiquis pampa nelía nimitzitztoc ica noixtiyol huan nimitzpanti noja tiyoltoc. ");
INSERT INTO nheBl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Huan José quinilhui iicnihua huan nochi ifamilia itata: ―Niyas niquitati Faraón para nijyolmelahuati para ya inajsitoque. Niquilhuis para noicnihua huan iteixmatcahua notata tlen itztoyaj ipan tlali Canaán ya hualajtoque para mocahuase nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Huan quinhualicatoque ininborregojhua, ininhuacaxhua huan nochi tlen quipiyaj pampa inintequi eli quinmocuitlahuíaj borregojme huan quiniscaltíaj tlapiyalime. Queja nopa niquilhuis. ");
INSERT INTO nheBl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Huajca quema nopa Faraón inmechnotzas huan inmechtlajtlanis ipan tlaque intequitij, ");
INSERT INTO nheBl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","xiquilhuica para nochipa inquiniscaltijtoque borregojme, san se queja imohuejcapan tatahua. Queja nopa inmechcahuilis inmocahuase ipan tlali Gosén pampa egiptome quinijiyaj tlen quinmocuitlahuíaj borregojme huan ax quinequij itztose ininhuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Huan José yajqui quiyolmelahuato Faraón huan quiilhui para itata huan iicnihua ya ajsicoj tlen tlali Canaán huan itztoyaj ipan tlali Gosén ihuaya ininborregojhua, huan ininhuacaxhua huan nochi tlen quipiyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Huan quintlapejpeni macuilti iicnihua huan quinhuicac iixtla Faraón para ma quinixmatica. ");
INSERT INTO nheBl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Huan Faraón quintlajtlani: ―¿Tlaque tequitl inquichihuaj? Huan inijuanti quiilhuijque: ―Tojuanti, timotlatequipanojcahua, tiquinmocuitlahuíaj borregojme queja tohuejcapan tatahua quichijque. ");
INSERT INTO nheBl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Huan tihualajtoque para timocahuase ipan ni tlali pampa ax onca sacatl para toborregojhua nepa ipan tlali Canaán pampa nopa mayantli tlahuel chicahuac nopano. Se favor, totlanahuatijca, xitechcahuili ma timocahuaca ipan tlali Gosén. ");
INSERT INTO nheBl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Huan Faraón quiilhui José: ―Motata huan moicnihua hualajtoque para mocahuase nica mohuaya. ");
INSERT INTO nheBl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Huajca huelis quitequihuise campa más cuali ipan ni tlali Egipto. Xiquinmaca nopa tlali Gosén para nopano ma mocahuaca pampa nelcuali. Huan intla tijmati sequin tlen inijuanti tlen más quimatij nopa tequitl, huajca xiquintlali nochi notlapiyalhua ininmaco. ");
INSERT INTO nheBl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Teipa José quihuicac itata, Jacob, iixtla Faraón para ma quiixmati. Huan Jacob quitiochijqui Faraón, ");
INSERT INTO nheBl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","huan Faraón quiilhui: ―¿Quesqui xihuitl tijpiya? ");
INSERT INTO nheBl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Huan Jacob quinanquili: ―Nijpanotoc 130 xihuitl tlen nelohui. Pero ya nopa nelquentzi pampa aya nicajsi nopa xihuitl tlen nohuejcapan tatahua itztoyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Teipa Jacob quinahuatijtejqui Faraón huan quisqui. ");
INSERT INTO nheBl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Huan José quinmacac itata huan iicnihua nopa tlaltini tlen más cuali ipan tlali Egipto, nopa tlali itoca Ramesés, para ma itztoca nopano queja Faraón tlanahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nojquiya José quinmacayaya tlacualistli nochi iteixmatcahua queja sese inijuanti monejqui para quitequihuise. ");
INSERT INTO nheBl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Huan teipa ipan niyon se tlali ayoc oncac tlacualistli pampa nopa mayantli más motlalanqui. Ipan tlali Egipto huan ipan tlali Canaán nochi tlahuajqui. ");
INSERT INTO nheBl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Huan nochi tomi ipan tlali Egipto huan ipan tlali Canaán ajsico imaco José pampa quinamacayaya trigo. Huan yajaya quihuicac nopa tomi tequicalco campa itztoya Faraón. ");
INSERT INTO nheBl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Huan quema ayoc aca quipixqui tomi ipan tlali Egipto huan ipan tlali Canaán, nopa egiptome yajque quiilhuitoj José: ―¡Xitechmaca tlen tijcuase! Amo xitechcahuili ma tiapismiquica moixtla san pampa ya tlanqui totomi. ");
INSERT INTO nheBl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Huan José quinnanquili: ―Intla ayoc inquipiyaj tomi, huajca xiquinhualicaca imotlapiyalhua huan nimechpatilis ica trigo. ");
INSERT INTO nheBl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Huan nopa egiptome quinhuicaque inincahuayojhua, ininborregojhua, ininchivojhua, ininhuacaxhua huan ininburrojhua, huan José quinpatili ica trigo. Queja nopa quinpanolti nochi nopa xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Huan quema panoc nopa xihuitl, inijuanti sampa yajque quiilhuitoj José: ―Ta tijmati ayoc tijpiyaj tomi huan ama nochi totlapiyalhua imoaxcahua. Ayoc tijpiyaj seyoc tlamantli tlen huelis timitzmacase, san totlal mocahua huan totlacayohua. ");
INSERT INTO nheBl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pero amo xitechcahuili ma timiquica moixtla ica mayantli. Xitechcohua tojuanti ihuaya totlalhua ica trigo. Huan tijtequipanose Faraón san tlapic huan totlalhua elis iaxca, pero xitechmaca trigo para tiitztose huan para ni tlali ma ax nenpolihuis. ");
INSERT INTO nheBl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Huajca José quicojqui para Faraón nochi piltlaltzitzi ipan tlali Egipto pampa nochi nopa egiptome quinamacaque inintlalhua pampa ax huelque quiijiyohuíaj nopa mayantli. Queja nopa nochi nopa tlali panoc imaco Faraón. ");
INSERT INTO nheBl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Huan José quinchijqui nopa egiptome campa hueli ma elica tlatequipanohuani tlen tequitique san tlapic. ");
INSERT INTO nheBl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Pero ax quicojqui inintlal nopa totajtzitzi pampa Faraón quinmacayaya trigo san tlapic. Huan ax monejqui quinamacase inintlalhua. ");
INSERT INTO nheBl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Teipa José quinilhui nopa egiptome: ―Ama imojuanti ihuaya imotlalhua inmocahuaj iaxca Faraón pampa nimechcojtoc para inelise iaxca ya. Nica inquipiyaj xinachtli para xijtocaca. ");
INSERT INTO nheBl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pero quema inpixcase, monequi inquixelose nopa pixquistli tlen oncas ica macuili partes. Se parte elis iaxca Faraón huan nopa seyoc nahui partes elise imoaxcahua para inquitocase, huan para inquicuase imojuanti huan imoconehua huan tlen itztoque ipan imochajchaj. ");
INSERT INTO nheBl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Huan inijuanti tlananquilijque: ―Titechmanahuijtoc para ax timiquise. Ica paquilistli tijtequipanose Faraón san tlapic. ");
INSERT INTO nheBl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Huajca José quichijqui nopa tlanahuatili ipan nochi tlali Egipto para ipan sesen macuili coxtali tlen pixcase monequi quimacase Faraón se coxtali. Huan ni tlanahuatili noja quitoquilíaj. Pero nopa totajtzitzi ax tleno monejqui tlaxtlahuase pampa inintlalhua ax quema elqui iaxca Faraón. ");
INSERT INTO nheBl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Huan nopa israelitame mocajque ipan nopa piltlaltzi Gosén ipan tlali Egipto huan nopano nochi quisqui cuali para inijuanti. Huan inijuanti tlahuel momiyaquilijque. ");
INSERT INTO nheBl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Huan Jacob itztoya 17 xihuitl ipan Egipto huan quiaxiti 147 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Huan se tonal Israel quimatqui ayoc huejcahuas para miquis, huajca tlatitlanqui ma quinotzatij José huan quiilhui: ―Se favor, xijtlali moma itzintla nometztomahuiya huan xijtestigojquetza Toteco para tijchihuas tlen nimitztlajtlanis. Amo xinechtocas nica ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Quema nimiquis huan nimosiyajcahuati ihuaya nohuejcapan tatahua, xinechhuica huan xinechtoca campa inijuanti toctoque. Huan José quiilhui: ―Quena, queja nopa nijchihuas. ");
INSERT INTO nheBl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Huan itata sampa quiilhui: ―¡Xijtestigojquetza Toteco Dios! Huan José quitestigojquetzqui Toteco Dios para temachtli quichihuas. Huan huajca Israel mopacho huan quitlali itzonteco ipan icuatopil huan quihueyichijqui Toteco. ");
INSERT INTO nheBl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Teipa quema panotoya se quentzi tonali quiilhuijque José para itata mococohua. Huajca José yajqui quiitato huan quinhuicac iome telpocahua, Manasés huan Efraín. ");
INSERT INTO nheBl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Huan quema quiyolmelajque Jacob para icone, José, ajsitoya para quiitati, quichijqui fuerza huan mosehui ipan itlapech. ");
INSERT INTO nheBl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Huan quiilhui José: ―Toteco Tlen Quipiya Nochi Chicahualistli monexti campa niitztoya nechca altepetl Luz ipan tlali Canaán huan nechtiochijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Huan nechilhui para quinmiyaquilis noconehua huan noteipa ixhuihua hasta mochihuase tlahuel miyac tlacame. Nojquiya nechilhui para noteipa ixhuihua quinmacasquía nopa tlali huan elis iniaxca para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Huajca ama huan teipa ni ome moconehua, Efraín huan Manasés, tlen tlacatque nica ipan tlali Egipto quema aya niajsiyaya elise queja noaxcahua para quiselise san se queja Rubén huan Simeón quiselise. ");
INSERT INTO nheBl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pero nopa moconehua tlen tlacatise teipa elise moaxcahua ta. Huan inijuanti quiselise tlen quintocaros ipan nopa tlali tlen elis iniaxca Efraín huan Manasés. ");
INSERT INTO nheBl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Quema nimocuepayaya tlen tlali Aram, mijqui monana Raquel ipan Canaán quema tinejnemiyayaj ipan ojtli huan san quentzi polihuiyaya para tiajsitij altepetl Efrata. Huan nijtojqui nopano ipan ojtli para altepetl Efrata tlen ama itoca Belén. ");
INSERT INTO nheBl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Huan Israel quinitac itelpocahua José huan quiijto: ―Huan ¿ni telpocame? ");
INSERT INTO nheBl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Huan ya quiilhui: ―Ni noconehua tlen Toteco Dios nechmacatoc nica ipan tlali Egipto. Huan itata quiilhui: ―Xijchihua se favor, xiquinnechcahuilti campa na para niquinmacas notlatiochihual. ");
INSERT INTO nheBl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Huan Israel eliyaya nelhuehuentzi huan ayoc cuali iixtiyol, huan yeca ayoc hueliyaya tlachiya cuali. Huan José quinnechcahuilti itelpocahua campa itata, huan Jacob quintzoponi huan quinnajnahuajqui. ");
INSERT INTO nheBl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Teipa Jacob quiilhui José: ―Ayoc nijchiyayaya para sampa nimitzitas huan yonque ya nopa, Toteco Dios nechcahuilijtoc nojquiya ma niquinita moconehua. ");
INSERT INTO nheBl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Huan José quinijcueni itelpocahua tlen itztoyaj nechca itlancuaco itata, huan motlancuaquetzqui huan mopacho tlalchi ica hueyi tlatlepanitacayotl iixtla itata. ");
INSERT INTO nheBl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Huan teipa José quinmatilanqui nopa ome itelpocahua huan quitlali Efraín ica inejmatl huan Manasés ica iarraves, huan quinnechcahuilti campa itata, Israel. Queja nopa Efraín mocajqui ica iarraves Israel huan Manasés ica inejmatl. ");
INSERT INTO nheBl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pero quema Israel quixitlajqui ima, momanepano huan quitlali inejmatl ipan itzonteco Efraín tlen eliyaya teipa ejquetl, huan quitlali iarraves ipan itzonteco Manasés tlen eliyaya achtohui ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Huajca Israel quintiochijqui queja ni: “Toteco Dios ma quintiochihua ni telpocame. Yajaya nopa Dios tlen ihuaya nejnenque notatahua Abraham huan Isaac, huan tlen nechmocuitlahuijtoc nochi noyolis. ");
INSERT INTO nheBl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Yajaya tlen quititlantoc ielhuicac ejca tlen nechmanahuijtinentoc ica nochi tlen fiero. yajaya ma quintiochihua ni telpocame. Huan nochi tlacame ma quimatica inijuanti noaxcahua, huan iniaxcahua notatahua, Abraham huan Isaac. Ma quinpiyaca miyac ininconehua huan ma momiyaquilica ininteipa ixhuihua miyac ipan tlaltepactli.” ");
INSERT INTO nheBl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pero José ax quipacti para itata quitlalijtoya inejmatl ipan itzonteco Efraín huan quiitzquili ima para quiijcuenis huan quitlalis ipan itzonteco Manasés. ");
INSERT INTO nheBl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Quiilhui: ―¡Axtle, Papá! Ya ni tlen achtohui ejquetl. Xijtlali monejmatl ipan itzonteco. ");
INSERT INTO nheBl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pero itata ax quinejqui quichihuas huan quiilhui: ―Nijmati, nocone, ya nijmati. Nojquiya iteipa ixhuihua mochihuase nelía miyac tlacame tlen nochi quintlepanitase. Pero iicni teipa ejquetl elis más hueyi que ya huan iteipa ixhuihua iicni más momiyaquilise huan mochihuase miyac tlaltini. ");
INSERT INTO nheBl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Huajca ipan nopa tonal Jacob quintiochijqui Efraín huan Manasés huan quinilhui: “Nochi sequinoc noteipa ixhuihua quitequihuise imotoca para tlatiochihuase huan quiijtose: ‘Toteco Dios ma mitzchihua hueyi queja quinchijqui Efraín huan Manasés.’” Queja nopa Israel quitlali para Efraín elis más hueyi huan teipa Manasés. ");
INSERT INTO nheBl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Teipa Israel quiilhui itelpoca, José: ―Xiquita, ya ajsitinemi nopa tonal para nimiquis, pero Toteco Dios itztos imohuaya huan quichihuas para sampa xiyaca ipan inintlal mohuejcapan tatahua. ");
INSERT INTO nheBl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Huan nimitzmacatoc ta nopa tlali tlen más cuali que nopa tlen niquinmacac moicnihua pampa más tihueyi. Yeca nimitzmaca tlen niquinquixtili nopa amorreo tlacame ica nomachete huan nocuahuitol. ");
INSERT INTO nheBl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Huan Jacob quinnotzqui itelpocahua huan quinilhui: “Ximonechcahuica campa na huan nimechilhuis tlen inmechpanos teipa. ");
INSERT INTO nheBl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Noconehua, ximonechcahuica huan xinechcaquica. Na niJacob huan innoconehua. Xinechtlacaquilica niimotata, Israel. ");
INSERT INTO nheBl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ta Rubén, tinoachtohui cone. Tieliyaya tinochicahualis huan quema titlacatqui eltoya queja nopa achtohui iselca nofuerza. Tijpiyas miyac chicahualistli huan tlatlepanitacayotl. ");
INSERT INTO nheBl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Pero ayoc tielis tlen más tihueyi, pampa tiitztoc queja atl tlen tehuahuatatza. Queja nopa eltoc pampa tinechpinahualti quema timotejqui ipan notlapech ihuaya notlatequipanojca. ");
INSERT INTO nheBl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeón huan Leví nelía inicnime pampa san se imonemilis. Imomachetes inquitequihuíaj san para tlatehuilistli. ");
INSERT INTO nheBl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","¡Ax quema nijnequi nijcaquis imotlajtol, niyon ax quema nimosentilis imohuaya! Pampa quema incualaniyayaj, intemictijque, huan san pampa inquinejque, inquinmetzpostejque torojme. ");
INSERT INTO nheBl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","¡Tlatelchihualtic, quena, tlatelchihualtic imocualancayo, pampa innelfierojtique huan ax intetlasojtlaj! ¡Nimechsemanas huan initztose campa hueli ipan nochi tlali Israel! ");
INSERT INTO nheBl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ta tiJudá, moicnihua mitzpaquilismacase. Huan tiquinitzquis mocualancaitacahua ininquechtla huan tiquintlanis. Hasta moicnihua motlancuaquetzase para mitztlepanitase. ");
INSERT INTO nheBl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ta tiJudá, tielis queja icone se tecuani tlen mocuepa pactoc ipampa nopa tlapiyali tlen quimictijtoc. Tielis queja se león tlen mopachohua huan moteca tlalchi, huan quichiya tlaque quiitzquis. Tielis queja se sihua león tlen nelía quipiya fuerza. Axaca mitzcuesolmacas. ");
INSERT INTO nheBl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Axaca huelis quiquixtilis nopa tlanahuatili tlen moteipa ixhuihua quipiyase. Niyon quinquixtilis nopa tepos cuatopili tlen quipiyase para ica tetlatzacuiltise. Quipiyase tlanahuatili para nochipa. Huan teipa hualas moteipa ixhui tlen temacas tlasehuilistli. Yajaya tlen nelía iaxca nopa tepos cuatopili huan nopa tlanahuatili para tlanahuatis. Huan tlacame ipan nochi tlaltini campa hueli quichihuase tlen yajaya quinilhuía. ");
INSERT INTO nheBl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Elis nelrico huan campa hueli oncas xocomeca mili tlen iaxca. Quiilpis iburro ipan tlen hueli xocomeca macuayotl tlen quinequis, huan intla quinequi, quiilpis ipilconeburrojtzi ipan nopa xocomeca cuamayitl tlen más cuali. Quipiyas miyac xocomeca atl hasta nesis queja huelis ica quichicuenis iyoyo. Quena, hasta mocahuas quipiyas iayo xocomecatl tlen temacas nochi imil. ");
INSERT INTO nheBl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iixtiyol elis más yayahuic que xocomeca atl, huan itlancochhua más chipahuac que lechi. ");
INSERT INTO nheBl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Ta tiZabulón, moteipa ixhuihua itztose iteno hueyi atl, huan nopano ajsise miyac barcos. Motlal ajsis hasta tlali Sidón. ");
INSERT INTO nheBl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ta tiIsacar, moteipa ixhuihua elise tejtetique queja se tlapiyali tlen quimati tlamama etic. Mosiyajcahuase campa quintzacuaj borregojme. ");
INSERT INTO nheBl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Quema quiitase quejatza nelía cuali imotlal para ipan inmosehuise huan quejatza nelía yejyectzi, huajca motlancuaquetzase huan mocuitlapantise para tlamamase. Huan niyon ax molinise moteipa ixhuihua quema quinchihuase ma tlatequipanoca san tlapic. ");
INSERT INTO nheBl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ta tiDan, ta huan moixhuihua intetlajtolsencahuase queja quinamiqui pampa inelise se hueyi familia ipan tlali Israel. ");
INSERT INTO nheBl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Moteipa ixhuihua elise queja se cohuatl tlen itztoc ojtipa, huan quintzacanía inincotztla cahuayojme huan quincuamajcahua tlen tlejcotoque ipan cahuayojme. ");
INSERT INTO nheBl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","¡TOTECO! Nijchiya para tinechmanahuis. ");
INSERT INTO nheBl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ta tiGad, miyac soldados hualase huan quintehuise moteipa ixhuihua, pero teipa quintojtocatiyase. ");
INSERT INTO nheBl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ta tiAser, moteipa ixhuihua quipiyase tlacualistli tlen cuali. Quena, temacase tlacualistli tlen ajhuiyac queja tlen quicuaj huejhueyi tlanahuatiani. ");
INSERT INTO nheBl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ta tiNeftalí, moteipa ixhuihua elise queja se masatl tlen nemi campa quinequi huan tlen quintlacatiltía yejyectzitzi pilconemasatzitzi. ");
INSERT INTO nheBl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ta tiJosé, moteipa ixhuihua elise queja se cuali cuahuitl tlen quitoctoque campa ameli. Temaca miyac itlajca huan imacuayohua moscaltía miyac hasta quionpano nopa tepamitl tlen tilahuac. ");
INSERT INTO nheBl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Tlacame quincualancaitase moteipa ixhuihua, huan quinmajcahuilise cuatlamintli huan nochipa quinmacase cuesoli. ");
INSERT INTO nheBl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pero moteipa ixhuihua quiquetzase inincuahuitol xitlahuac, huan ax huihuipicase ininma quema quitequihuise pampa elise tejtetique. Quena, tlatlanise pampa noTeco Dios, yajaya tlen quipiya nochi chicahualistli quinpalehuis. Yajaya quinmocuitlahuis pampa yajaya totlamocuitlahuijca tiisraelitame. Yajaya nopa Hueyi Tetl tlen techmanahuijtoc miyac huelta. ");
INSERT INTO nheBl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Quena, ma inmechpalehuis ininTeco mohuejcapan tatahua. Ma inmechtiochihua ta huan imoteipa ixhuihua yajaya Toteco Tlen Quipiya Nochi Chicahualistli. Ma quintiochihuas moteipa ixhuihua ica miyac tlatiochihualistli queja atl tlen huala tlen huejcapa ipan elhuicac, huan tlen huala huejcatla ipan hueyi atl huan quichihuas ma moscaltis imomilhua. Ma mitztiochihuas ta huan moteipa ixhuihua huan imosihuajhua. Ma inmechmacas miyac imoconehua tlen moscaltise ica cuali. Ma tlahuel momiyaquilica imotlapiyalhua. ");
INSERT INTO nheBl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Quena, José, Toteco ma mitztiochihua, yajaya tlen noTeco na, nimotata. Ni tlatiochihuali momiyaquilis hasta ajsis ipan nopa tlachiquili tlen huejcahuase para nochipa. Nochi ya ni elis nopa tlatiochihualistli tlen ta tijpiyas, José, pampa Toteco mitziyocatlali tlen moicnihua para tielis tiinintlanahuatijca. ");
INSERT INTO nheBl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ta tiBenjamín, moteipa ixhuihua tlatlanise queja se tepechichi. Ica ijnaloc quicuase tlen quimictijtoque, huan hasta tiotlac quipiyase tlen mocajtoc para temajmacase.” ");
INSERT INTO nheBl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ya ni nopa 12 itelpocahua Israel huan nopa tlatiochihuali tlen inintata quinmacac. Quinilhui tlen quinamiqui para sesen quiselis pampa Toteco quinextili tlen panos ica ininteipa ixhuihua sese inijuanti. ");
INSERT INTO nheBl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nojquiya Jacob quinmacac itelpocahua ni tlanahuatili: “San quentzi polihui para nimiquis. Xinechtlalpachoca ihuaya nohuejcapan tatahua ipan nopa tlacacahuaya tlen eltoc ipan itlal Efrón nopa heteo. ");
INSERT INTO nheBl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Quena, xinechtlalitij nopano ipan tlali Canaán ipan nopa tlacacahuaya ipan nopa mila tlen itoca Macpela, iixtla Mamre. Nopa tlen Abraham quicohuili Efrón para ipan ma quintlalpachoca nochi iteixmatcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nopano quintoctoque Abraham ihuaya isihua, Sara, huan Isaac huan isihua, Rebeca, huan nopano nijtlalpacho Lea. ");
INSERT INTO nheBl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nopa tlali huan nopa tlacacahuaya tlen eltoc nopano quincohuili nopa heteo tlacame.” ");
INSERT INTO nheBl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Huan quema Jacob tlanqui quinnahuatía itelpocahua, motejqui ipan itlapech huan mijqui. ");
INSERT INTO nheBl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Huajca José quinajnahuajqui itlacayo itata huan chicahuac chocac huan quitzoponi. ");
INSERT INTO nheBl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Teipa quinnahuati nopa itepajtijcahua ma quitlalilica tlaajhuiyacayotl tlen pajyo ipan itlacayo itata para ma ax palani. Huan queja nopa quichijque. ");
INSERT INTO nheBl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Huan quitlalilijque nopa pajtlaajhuiyacayotl 40 tonali pampa monejqui quitlamiltise nopa tonali para ax palanis. Huan nopa egiptome quichoquilijque Israel 70 tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Teipa quema panoc nopa choquistli, José quincamahui itlapalehuijcahua ipan ichaj Faraón huan quinilhui: ―Se favor, xijcamahuica Faraón tlen na huan xiquilhuica ");
INSERT INTO nheBl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","para quema notata miquiyaya, nechchijqui ma nijtestigojquetza Toteco Dios para nijtlalpachosquía ipan se tlacacahuaya tlacoyoctli tlen iaxca tofamilia ipan tlali Canaán. Huajca xijtlajtlanica ma nechcahuili ma niya tlali Canaán nijtlalpachoti notata. Huan quema nijtlalpachos, nimocuepas. ");
INSERT INTO nheBl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Huan nopa Faraón tlananquili para quena huan quiilhui José: ―Xiya xijtlalpachoti motata queja ya mitzilhui. ");
INSERT INTO nheBl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Huan José yajqui quitlalpachoto itata. Huan ihuaya yajque nochi nopa tlacame tlen quihuicaque tequihuejcayotl para tlanahuatise ihuaya José. Huan nojquiya yajque tlen quipixque tlanahuatili ipan ichaj Faraón huan ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Huan yajque nochi iicnihua José ininhuaya nochi iteixmatcahua itata. Ipan tlali Gosén san quincajtejque ininconehua huan inintlapiyalhua. ");
INSERT INTO nheBl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nojquiya yajque miyac tlacame ipan cuacarros huan ipan cahuayojme ihuaya José. Elque tlahuel miyac tlacame tlen yajque. ");
INSERT INTO nheBl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Huan quema ajsitoj campa quiyolquixtíaj trigo ipan Atad nechca nopa atemitl Jordán, nochi quipixque se hueyi choquistli huan ica miyac cuesoli José quichoquili itata para chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Huan quema nopa cananeos tlen ejque nopano quiitaque para nelía chocayayaj campa tlayolquixtía campa itoca Atad, quiijtojque: “Tlahuel hueyi inincuesol nopa egiptome.” Huan yeca quitocajtijque Abel Mizraim. (Abel Mizraim quinequi quiijtos Campa Nopa Egiptome Chocaque.) Abel Mizraim mocahua nechca atemitl Jordán para campa temo tonati. ");
INSERT INTO nheBl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Huan itelpocahua Jacob quichijque ica inintata nochi tlen ya quintlajtlanijtoya. ");
INSERT INTO nheBl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Quihuicaque ipan tlali Canaán huan quitlalpachojque ipan nopa tlacacahuaya tlen eltoc ipan mila Macpela nechca Mamre tlen Abraham quicohuilijtoya Efrón, nopa heteo tlacatl, para ipan quintlalpachosquíaj nochi iteixmatcahua. ");
INSERT INTO nheBl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Teipa quema ya quitlalpachojtoyaj inintata, José mocuepqui tlali Egipto ihuaya iicnihua huan nochi sequinoc tlen ihuaya yajtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Quema iicnihua José momacaque cuenta para inintata Jacob ya mictoya, moilhuijque: “Nohueli José techcualancaitas huan quinequis techcuepilis ica tlen fiero tijchihuilijque huejcajquiya.” ");
INSERT INTO nheBl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Huajca tlatitlanque ma quiilhuitij: “Quema totata aya miquiyaya, ");
INSERT INTO nheBl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","technahuati ma timitzilhuica, xijchihuili se favor huan xitechtlapojpolhui totlajtlacol timoicnihua quema timitzchihuilijque tlen fiero. Huan tojuanti nojquiya timitztlajtlaníaj xitechtlapojpolhui tlen timitzchihuilijque. Ama tijtequipanohuaj Toteco Dios tlen totata quitoquili.” Huan José chocac quema quicajqui ni tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Huan teipa ajsicoj iicnihua huan mopachojque iixtla ica tlatlepanitacayotl huan quiilhuijque: ―Nica titechpixtoc para timoaxcahua. Timitztequipanose san tlapic. ");
INSERT INTO nheBl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pero José quinilhui: ―Amo ximajmahuica. Na ax niDios para nimechtlatzacuiltis. ");
INSERT INTO nheBl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Melahuac inquinequiyayaj innechchihuilise tlen nelía ax cuali, pero Toteco Dios quisencajqui para ica tlen fiero innechchihuilijque, yajaya quichihuasquía se tlamantli tlen onpano cuali. Yajaya quinequiyaya quimanahuis ininyolis miyac tlacame huan ya nopa tlen ama inquiitaj pano. ");
INSERT INTO nheBl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Huajca amo ximajmahuica. Nimechmacas imojuanti huan imoconehua tlen inquicuase. Huan José quincamahui ica teicnelijcayotl huan queja nopa quinyoltlali. ");
INSERT INTO nheBl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Huan José ihuaya nochi iteixmatcahua noja mocajque ipan tlali Egipto huan yajaya ax mijqui hasta quipixqui 110 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","José itztoya hasta iconehua Efraín quinpixque iniixhuihua. Nojquiya itztoya hasta Maquir, icone Manasés, quinpixqui iconehua. Quena, iixhuihua Manasés mahuiltijque iicxitla ininhueyi tata José. ");
INSERT INTO nheBl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Huan se tonal José quinilhui iicnihua: “San nechpolohua quentzi para nimiquis, pero teipa Toteco Dios hualas inmechpalehuis huan inmechquixtis tlen ni tlali para inmechhuicas ipan nopa tlali tlen quintencahuili Abraham, Isaac huan Jacob para quinmacas.” ");
INSERT INTO nheBl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Huajca José quincamahui iicnihua tlen nojquiya itztoyaj itelpocahua Israel queja ya. Huan quinchihualti ma quitestigojquetzaca Toteco para quihuicase iomiyohua ininhuaya quema ajsis tonal para quisase tlen tlali Egipto. Quinilhui: “Quema Toteco Dios hualas huan inmechhuicas sampa ipan tlali Canaán, monequi inquihuicase noomiyo imohuaya.” ");
INSERT INTO nheBl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Huajca José mijqui ipan tlali Egipto quema quipiyayaya 110 xihuitl huan itlacayo quipajtijque ica pajtlaajhuiyacayotl para ax palanisquía. Huan quitlalijque ipan se cuacajo ipan tlali Egipto.");
INSERT INTO nheBl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Nopa tlacatl tlen itoca Israel yajqui ipan tlali Egipto ihuaya 12 itelpocahua, huan sese inijuanti nojquiya quihuicac ifamilia. Huan ya ni inintoca itelpocahua Jacob tlen ihuaya yajque tlali Egipto: ");
INSERT INTO nheBl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví, Judá, ");
INSERT INTO nheBl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón, Benjamín, ");
INSERT INTO nheBl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftalí, Gad huan Aser. ");
INSERT INTO nheBl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Huan nochi iteixmatcahua Jacob tlen yajque mochijque 70 tlacame. Pero seyoc itelpoca tlen itoca José ya itztoya ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Huan ica miyac xihuitl mijqui José, huan iicnihua huan nochi nopa tlacame tlen achtohui hualajtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Pero teipa iniixhuihua quinpixque miyac ininconehua huan motocajtiyayaj israelitame. Huan nopa israelitame tlahuel momiyaquilijtiyajque hasta mochijque tlahuel miyac tlacame huan campa hueli itztoyaj ipan Gosén ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Huan teipa panoc miyac xihuitl huan pejqui tequiti se yancuic tlanahuatijquetl ipan tlali Egipto tlen ax quema quiixmajtoya José. Huan nopa yancuic tlanahuatijquetl quinilhui nopa egiptome: ");
INSERT INTO nheBl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“Xiquitaca, nopa israelitame mochijtoque nelmiyac tlacame huan más quipiyaj chicahualistli que tojuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Huajca monequi tijchihuase se tlenijqui para ayoc ma momiyaquilica, pampa intla oncas se tlatehuijcayotl, huelis mosejcotilise ica tocualancaitacahua para techtehuise huan teipa cholose tlen ni tlali.” ");
INSERT INTO nheBl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Huan yeca nopa egiptome quintlalijque tlacame tlen tetique para ma quinfuerzajhuica israelitame ma tequitica tlahuel chicahuac. Quinchihualtijque ma quisencahuaca nopa altepetini Pitón huan Ramesés para nopa hueyi tlanahuatijquetl Faraón. Huan quintequihuijque nopa altepetini para ipan quiajcocuise tlacualistli. ");
INSERT INTO nheBl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero quema noja más quintlaijiyohuiltiyayaj israelitame, noja más momiyaquiliyayaj. Yeca nopa egiptome pejque más quinimacasij. ");
INSERT INTO nheBl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Huajca nopa egiptome tlahuel quintequihuijque nopa israelitame huan ax quintlasojtlaque. ");
INSERT INTO nheBl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tlahuel ax quinpatiitayayaj. San quintequihuiyayaj chicahuac huan quintlaijiyohuiltiyayaj miyac. Quinchihualtijque ma quicualtlalica soquitl huan ma quichihuaca ladrillos huan nojquiya ma quichihuaca miyac tlamantli miltequitl. Huan quema tlahuel tlaijiyohuiyayaj nopa israelitame ipan nochi ni tequitl, noja más nopa egiptome quinchihuilijque fiero. ");
INSERT INTO nheBl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nojquiya nopa hueyi tlanahuatijquetl quincamahui Sifra huan Fúa, nopa sihuame tlen quinitayayaj israelita sihuame quema conepiyayayaj huan quinilhui: ");
INSERT INTO nheBl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","―Quema inquipalehuise se hebreo sihuatl tlen conepiyas, xiquita tlaque tlacajtoc. Intla tlacajtoc se sihuapil, xijcahuaca ma itzto, pero intla se oquichpil, xijmictica. ");
INSERT INTO nheBl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pero yonque queja nopa quinilhui nopa tlanahuatijquetl, nopa sihuame quiimacasque Toteco Dios huan ax quichijque tlen nopa tlanahuatijquetl quinnahuatijtoya. Quincajque ma itztoca nopa oquichpilme. ");
INSERT INTO nheBl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Huajca nopa tlanahuatijquetl tlen Egipto tlatitlanqui ma quinnotzatij nopa ome sihuame huan quintlajtlani: ―¿Para tlen inquincahuilíaj ma itztoca hebreo oquichpilme? ¿Para tlen ax inquinmictíaj? ");
INSERT INTO nheBl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Huan nopa sihuame quinanquilijque Faraón: ―Nopa hebreo sihuame ax tlatlacaltitíaj yolic queja egipto sihuame. Más cuali inintlacayohua huan nimantzi quintlacaltitíaj ininconehua quema tojuanti aya tionajsij para tiquinpalehuise. ");
INSERT INTO nheBl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Huan pampa nopa sihuame quitlepanitaque Toteco Dios, yajaya quintiochijqui huan quinchijqui nojquiya ma quinpiyaca ininconehua. Huan nopa hebreos o israelitame más momiyaquilijque hasta mochijtoyaj tlahuel miyac. ");
INSERT INTO nheBl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Huajca Faraón quinmacac se tlanahuatili nochi itlacajhua: “Nochi hebreo oquichpilme tlen tlacatise monequi xiquinmajcahuaca ipan atemitl, pero sihuapilme xiquincahuaca ma itztoca.” ");
INSERT INTO nheBl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Se tonal se tlacatl tlen eliyaya se iteipa ixhui nopa huejcapan tata Leví mosihuajti ihuaya se sihuatl tlen nojquiya eliyaya se iteipa ixhui, pero ipan seyoc familia. ");
INSERT INTO nheBl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Huan isihua conecuic huan quipixqui se icone. Huan quema quiitaque para nopa oquichpil eliyaya yejyectzi, quitlatijque para eyi metztli. ");
INSERT INTO nheBl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pero quema itatahua ayoc huelque quitlatíaj más tonali, quicuique se chiquihuitl tlen quichijtoya ica acatl, huan inana quitzajtzajqui ica chapopojtli para ma ax calaqui atl. Teipa quitlali nopa pilconetzi iijtic nopa chiquihuitl huan quicahuato acatzala iteno nopa atemitl Nilo. ");
INSERT INTO nheBl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nojquiya quiilhui ihuelti nopa pilconetzi ma quihuejcaita para ma quimati tlaque panosquía. ");
INSERT INTO nheBl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Huan más tiotlac, iichpoca Faraón ininhuaya itlatequipanojcahua temoque para maltitij ateno. Huan quema nejnemiyayaj nechca atemitl, quiitaque nopa chiquihuitl tlatlajco acame. Huajca nopa ichpocatl quititlanqui se isihua tlatequipanojca ma quihualiquili nopa chiquihuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Huan quitlapo nopa aca chiquihuitl, huan quitlachili iijtic huan nopona itztoya se piloquichpiltzi tlen chocayaya. Huan iichpoca Faraón quitlasojtlac huan quiijto: ―Ni se piloquichpiltzi hebreo. ");
INSERT INTO nheBl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Huajca iicni nopa pilconetzi monechcahui campa iichpoca Faraón huan quiilhui: ―¿Tijnequi ma nijnotzati se hebreo sihuatl tlen tlachichitía para ma quiiscalti ni oquichpil? Huan iichpoca Faraón tlananquili: ");
INSERT INTO nheBl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","―Quena, xijnotzati. Huajca iicni nopa pilconetzi yajqui quinotzato inana, ");
INSERT INTO nheBl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","huan iichpoca Faraón quiilhui: ―Xijhuica ni oquichpil huan xinechchichitili, huan na nimitztlaxtlahuis motequi. Huajca inana nopa piloquichpiltzi quihuicac huan quiiscalti. ");
INSERT INTO nheBl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Huan quema ya moscaltijtoya, quimactili iichpoca Faraón. Huan nopa ichpocatl quichijqui icone huan quitocajti Moisés. (Moisés quinequi quiijtos Tlaquixtili.) Queja nopa quitocajti pampa quiijto: ―Na nijquixti ipan atl. ");
INSERT INTO nheBl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Se tonal quema Moisés ya motlacachijtoya, quisqui para quinpaxaloti nopa hebreos pampa quimatqui para san se estli quipixqui ininhuaya huan momacac cuenta para nelohui inintequi. Huan quiitac se tlacatl Egipto ejquetl quihuitequiyaya se tlacatl hebreo huan quitlasojtlac, pampa eliyaya san se inieso. ");
INSERT INTO nheBl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Huajca Moisés tlachixqui campa hueli huan quema axaca quiitac, quimicti nopa tlacatl Egipto ejquetl huan quitlati itlacayo ipan xali. ");
INSERT INTO nheBl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Huan hualmostla sampa quisqui Moisés huan quiitac para ome hebreo tlacame motehuiyayaj, huajca quitlajtlani tlen tlatehuiyaya: ―¿Para tlen tijmaquilía mohuampo huan san se imoeso inquipiyaj? ");
INSERT INTO nheBl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Huan nopa hebreo tlacatl quinanquili: ―¿Ajqueya mitztlalijtoc ta queja titlayacanquetl o tijuez ica tojuanti? ¿Huelis timoilhuía tinechmictis queja yalohua tijmicti nopa Egipto ejquetl? Quema Moisés quicajqui ni tlamantli, majmajqui, pampa momacac cuenta para sequin quimatiyayaj para quimictijtoya nopa tlacatl Egipto ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Huan quema Faraón quimatqui para Moisés quimictijtoya se tlacatl Egipto ejquetl, tlatitlanqui ma quitemotij para quimictis, pero Moisés cholojtejqui huan yajqui itztoti ipan tlali Madián. Huan quema ajsito nepa mosehuito nechca se ameli. ");
INSERT INTO nheBl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Huan nopona ipan tlali Madián itztoya se totajtzi tlen itoca Reuel huan quinpixtoya chicome iichpocahua. Huan ipan nopa tonal inijuanti ajsitoyaj campa nopa ameli para quiquixtise atl huan quitemitise campa atlij tlapiyalime huan quinamacase inintata iborregojhua. ");
INSERT INTO nheBl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Pero hualajque sequinoc borrego tlamocuitlahuiani huan quintojtocaque nopa ichpocame. Huajca Moisés motlalanqui, huan quinmanahui huan teipa quinamacac ininborregojhua. ");
INSERT INTO nheBl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Huan quema nopa ichpocame mocuepque campa itztoya inintata Reuel, yajaya quintlajtlani: ―¿Quejatza ama inmocuepque nimantzi? ");
INSERT INTO nheBl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Huan tlananquilijque: ―Se Egipto ejquetl techmanahui ininmaco nopa sequinoc tlamocuitlahuiani. Huan teipa yajaya quiquixti atl para tojuanti huan quinamacac toborregojhua. ");
INSERT INTO nheBl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Huan inintata quintlajtlani: ―Huan ¿canque itztoc nopa tlacatl? ¿Para tlen inquicajtejque iselti? Xiyaca xijnotzati ma tlacuaqui. ");
INSERT INTO nheBl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Huan Moisés hualajqui huan mocajqui ipan ichaj Reuel. Huan teipa Reuel quimacac Moisés iichpoca tlen itoca Séfora para isihua. ");
INSERT INTO nheBl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Huan teipa Séfora quipixqui icone huan Moisés quitocajti Gersón. (Gersón quinequi quiijtos Sejcoyoc Ejquetl.) Pampa quiijto: “Ama nise sejcoyoc ejquetl ipan ni tlali tlen ax niquixmati.” ");
INSERT INTO nheBl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Huan Moisés itztoya para miyac xihuitl ipan tlali Madián. Huan ipan nopa tonali ipan tlali Egipto mijqui nopa tlanahuatijquetl. Pero nopa israelitame noja tlahuel tlaijiyohuiyayaj huan mocuesohuayayaj pampa tlatequipanohuayayaj san tlapic. Huan ajachica quitlajtlaniyayaj Toteco Dios ma quinpalehui ipan inintlaijiyohuilis. ");
INSERT INTO nheBl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Huan Toteco quincajqui. Quena, quichihuili cuenta tlen quinequiyayaj pampa ax quiilcajqui tlen ininca mocajtoya Abraham, Isaac huan Jacob para quinmacas iniixhuihua se tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Huajca Toteco Dios quinitac nopa israelitame huan quintlasojtlac. ");
INSERT INTO nheBl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Se tonal Moisés quinmocuitlahuiyaya iborregojhua imontat, Jetro 3:1 Jetro nojquiya itoca Reuel., tlen eliyaya se totajtzi ipan tlali Madián. Huan Moisés quinhuicac nopa borregojme hasta ne seyoc lado nopa huactoc tlali hasta se tepetl itoca Horeb 3:1 Nopa tepetl Horeb nojquiya itoca tepetl Sinaí.. (Horeb quinequi quiijtos Nopa Tepetl Campa Toteco Itztoc.) ");
INSERT INTO nheBl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Huan nopona ielhuicac ejca TOTECO monexti ipan se tlilelemectli tlen tlatlayaya tlatlajco se xihuitzontli. Huan Moisés momacac cuenta para nopa xihuitzontli lemeniyaya, pero ax tlamiyaya. ");
INSERT INTO nheBl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Huajca moilhui: “Ax quema niquitztoc se tlamantli quej ni. Niyas niquitati para tlen ax tlamitlatla nopa xihuitzontli.” ");
INSERT INTO nheBl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Huan quema TOTECO quiitac para Moisés monechcahuiyaya para quitlachilis, quinojnotzqui tlatlajco tlen nopa xihuitzontli huan quiilhui: ―¡Moisés! ¡Moisés! Huan Moisés quiijto: ―Nica niitztoc. ");
INSERT INTO nheBl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Huajca TOTECO quiilhui: ―Amo ximonechcahui. Ximotecacquixti pampa tlatzejtzeloltic ni tlali campa timoquetza, pampa nica nojquiya niitztoc na. ");
INSERT INTO nheBl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Huan TOTECO nojquiya quiilhui: ―Na niininTeco mohuejcapan tatahua Abraham, Isaac huan Jacob. Huajca Moisés moixtzajqui pampa majmajqui para quitlachilis Toteco Dios, ");
INSERT INTO nheBl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","huan TOTECO sampa quiijto: ―Niquitztoc quejatza tlaijiyohuíaj notlacajhua tlen itztoque ipan tlali Egipto. Nijcactoc queja chocaj pampa inintlayacancahua fiero quinchihuilíaj. Niquintlasojtla pampa tlahuel tlaijiyohuíaj. ");
INSERT INTO nheBl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Yeca nitemotoc para niquinmaquixtis ininmaco nopa egiptome. Huajca niquinquixtis ipan nopa tlali huan niquinhuicas hasta se tlali tlen hueyi huan cuali tlen nochi temaca hasta mocahua itlajca. Ipan nopa tlali ama itztoque nopa cananeos, heteos, amorreos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nheBl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Huajca pampa nijtlacaquilijtoc queja nechtzajtzilíaj nopa israelitame, huan niquitztoc queja nopa egiptome fiero quinchihuilíaj, ");
INSERT INTO nheBl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ama nimitztitlanis tiquitati Faraón. Nijnequi tiyas para tiquinquixtis nopa israelitame tlen tlali Egipto pampa inijuanti notlacajhua. ");
INSERT INTO nheBl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Huajca Moisés quiilhui Toteco Dios: ―¿Pero ajqueya na para niyas nijcamahuiti Faraón huan niquinquixtiti tlen tlali Egipto nopa israelitame? ");
INSERT INTO nheBl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Huan Toteco Dios quinanquili: ―Na niitztos mohuaya. Huan ya ni elis se tlanextilijcayotl para huelis tijmatis temachtli para naja tlen nimitztitlani. Quema ya tiquinquixtijtos notlacajhua ipan tlali Egipto, inmocuepase nica huan nochi imojuanti innechhueyichihuase ipan ni tepetl Horeb. ");
INSERT INTO nheBl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Pero Moisés quinanquili: ―Pero intla niyas huan niquinilhuis nopa israelitame para yajaya tlen ininTeco ininhuejcapan tatahua nechtitlantoc campa inijuanti, nechtlajtlanise ¿quejatza motoca? Huan huajca, ¿tlaque niquinilhuis? ");
INSERT INTO nheBl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Huan Toteco Dios quinanquili: ― NAJA NIITZTOC TLEN NOCHIPA NIITZTOC. Huan tiquinilhuis nopa israelitame: Yajaya tlen itoca YAJAYA TLEN NOCHIPA ITZTOC nechtitlantoc campa imojuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Huan nojquiya Toteco Dios quiilhui Moisés: ―Nojquiya xiquinilhui nopa israelitame para na tlen niininTECO imohuejcapan tatahua, Abraham, Isaac huan Jacob, nimitztitlantoc campa inijuanti. Xiquinilhui ya ni elis notoca para nochipa. Ya ni nochipa eliyaya notoca huan nochipa elis notoca. Ica ni notoca nechnotzase para nochipa nochi tlacame tlen tlacajtiyase. ");
INSERT INTO nheBl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Xiya huan xiquinsentili nochi huehue tlacame ipan nopa israelitame. Xiquinilhui para na niDIOS tlen niininTeco imohuejcapan tatahua, Abraham, Isaac huan Jacob, nimonexti campa ta. Huan nimitzilhui para niquinhualtlachilijtoc huan niquitztoc quejatza fiero quinchihuilíaj ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Huan nojquiya xiquinilhui para niquintencahuilía niquinquixtis tlen nopa tlaijiyohuilistli ipan Egipto, huan niquinhuicas ipan nopa tlali campa itztoque nopa cananeos, heteos, amorreos, ferezeos, heveos huan jebuseos. Campa niquinhuicas eltoc se tlali tlen nochi temaca hasta mocahua itlajca. ");
INSERT INTO nheBl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Huan temachtli nopa huehue tlacame mitzneltocase. Huan teipa monequi tiyas ininhuaya nopa huehue tlacame para inquiitatij nopa hueyi tlanahuatijquetl tlen tlali Egipto. Huan tiquilhuis para na niDIOS tlen niimoTECO inhebreo tlacame huan para na nimonexti mohuaya. Xiquilhui monequi quincahuas ma yaca israelitame ipan nopa huactoc tlali campa ax tleno eli. Xiquilhui monequi inyase eyi tonali ipan ojtli para innechmacatij tlacajcahualistli na, niimoTECO Dios. Queja nopa xiquilhuiti. ");
INSERT INTO nheBl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pero na cuali nijmati para nopa tlanahuatijquetl tlen tlali Egipto ax inmechcahuas inquisase hasta nijnextilis para nelía hueyi nochicahualis. ");
INSERT INTO nheBl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Yeca na nimomaxitlahuas huan niquincocos nopa egiptome ica miyac huejhueyi chicahualnescayotl tlen nijchihuas ipan inintlal para niquinnextilis nohueyi chicahualis. Huan teipa, quena, Faraón inmechcahuas para inquisase. ");
INSERT INTO nheBl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nojquiya nijchihuas para nopa egiptome ma quinequica inmechpalehuise huan inmechmajmacase tlamantli quema inquisase. Yeca quema inquisase, ax inyase san ica imoma. ");
INSERT INTO nheBl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Huan monequi sesen sihuatl quitlajtlanis tlen icalnechca o seyoc tlen ihuaya itztoc para ma quimaca yoyomitl tlen cuali huan tlamantli tlen oro huan plata. Huan xiquinyoyontica imoconehua para queja nopa inquintlaquijquixtilijtehuase Egipto ehuani nochi tlen quipixtoque.” ");
INSERT INTO nheBl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Huan Moisés tlananquili: ―¿Tlaque nijchihuas intla nopa israelitame ax nechneltoquilise, niyon ax nechchihuilise cuenta? Huelis san quiijtose para ta, TOTECO, ax timonextijtoc nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Huajca TOTECO quiilhui Moisés: ―¿Tlaque tijpiya momaco? Huan Moisés tlananquili: ―Se cuatopili. Huan TOTECO quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","―Xijmajcahua tlalchi. Huan Moisés quimajcajqui tlalchi huan ipan nopa tlalochtli nopa cuatopili mochijqui se cohuatl. Huan Moisés motlalojtejqui pampa quiimacasiyaya, ");
INSERT INTO nheBl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","pero TOTECO quiilhui: ―Xiquitzqui ipan icuitlapil. Huan Moisés quiitzqui nopa cohuatl huan mocuepqui sampa cuatopili. ");
INSERT INTO nheBl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Huan TOTECO quiilhui: ―Queja nopa tijchihuas iniixpa nopa israelitame para ma quineltocaca para na tlen niininTeco imohuejcapan tatahua, Abraham, Isaac huan Jacob, nimonextijtoc moixpa para nimitztequimacas. ");
INSERT INTO nheBl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Huan TOTECO quiilhui: ―Huan ama, xijcalaqui moma moyolixco. Huan Moisés quicalaqui ima iyolixco huan quema quiquixti, quiitac para quipiyayaya nopa fiero tlacayo palanca cocolistli tlen itoca lepra huan eliyaya chipahuac queja sitlal setl. ");
INSERT INTO nheBl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Huajca TOTECO quiilhui: ―Sampa xijcalaqui moma moyolixco. Huan Moisés queja nopa quichijqui. Huan quema sampa quiquixti ima, ya mochicajtoya huan eltoya cuali queja nochi itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Huajca TOTECO quiilhui: ―Intla ica nopa achtohui tlanextilijcayotl, ax mitzneltoquilise, huajca mitzneltocase ica nopa tlen ompa. ");
INSERT INTO nheBl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Pero intla ax mitzneltocase ica ni ome tlanextili, xijquixti atl tlen nopa atemitl huan xijtoyahua tlalchi. Huan quema nopa atl tlen tijquixtis ipan atemitl toyahuis tlalchi, mocuepas estli. Huan Moisés quiilhui TOTECO: ");
INSERT INTO nheBl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","―¡Ay, Toteco! Na ax hueli nitlatenquixtía cuali. Huan ax san ama o yalohua ax nihueli. Ni tlen huejcajquiya. Nochipa quema nicamati, ohui quisa tlajtoli ipan nonenepil, pampa nitlajtolcuatacani. ");
INSERT INTO nheBl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Pero TOTECO quiilhui: ―Najaya niquinmacatoc inincamac tlacame. Naja nijchihua para se ma ax huelis camatis, o ma ax huelis tlacaquis. Nijchihua para se ma tlachiyas, o ma ax tlachiyas. ");
INSERT INTO nheBl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Huajca xiya huan na niitztos mohuaya quema ticamatis, huan nimitznextilis tlen monequi tiquijtos. ");
INSERT INTO nheBl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Huan Moisés sampa quiijto: ―¡Ay, Toteco! Xijchihua se favor, xijtitlani seyoc huan ax na. ");
INSERT INTO nheBl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Huajca TOTECO cualanqui ihuaya Moisés huan quiilhui: ―¿Tiquita cualtitoc para yas mohuaya moicni Aarón tlen nojquiya iixhui mohueyi tata Leví? Na nijmati para ya cuali camati. Huan ama huala ipan ojtli mitznamiquiqui. Yajaya paquis miyac quema mitzitas. ");
INSERT INTO nheBl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Huajca xijcamahui huan xijpohuili nochi tlen monequi quiijtos, huan yajaya camatis tlen tijpohuilis. Huan na niitztos imohuaya quema incamatise huan nimechnextilis tlen monequis inquichihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ta tiquilhuis Aarón tlen monequi quiijtos huan Aarón quinilhuijtiyas sequinoc tlen ta tiquilhuis. Yajaya camatis tlen ta ticamatisquía huan mitztlepanitas queja tiitztosquía ta tiDios. ");
INSERT INTO nheBl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Pero xijhuica ni cuatopili ipan moma pampa ica ya ni tijchihuas tlanextilijcayotl tlen huejhueyi. ");
INSERT INTO nheBl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Huajca Moisés mocuepqui ichaj imontat Jetro, huan quiilhui: ―Xinechcahuili ma nimocuepa tlali Egipto campa itztoque noicnihua tlen san se estli tijhuicaj. Nijnequi niquitas intla noja itztoque. Huan Jetro tlananquili: ―Xiya ica cuali. ");
INSERT INTO nheBl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","TOTECO quiilhui Moisés quema noja itztoya ipan tlali Madián: ―Amo ximajmahui ximocuepa ipan tlali Egipto pampa ya mijque nochi tlen quinequiyayaj mitzmictise. ");
INSERT INTO nheBl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Huajca Moisés quincuitejqui isihua huan icone huan quintlecolti ipan se burro huan mocuepqui tlali Egipto. Huan ipan ima quihuicayaya nopa cuatopili tlen Toteco Dios quimacac. ");
INSERT INTO nheBl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Huan teipa TOTECO quiilhui Moisés: ―Quema tiajsiti tlali Egipto, xiquita para tijchihuas iixtla Faraón nochi nopa tlanextilijcayotl tlen nimitzmacatoc chicahualistli xijchihua. Pero na nijyoltetilis para ax quincahuas ma quisaca israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Huajca tiquilhuis Faraón para na niimoTECO niquijtohua para nopa israelita tlacame niquinicnelía queja se quiicnelía icone achtohui ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Huan xiquilhui para niquilhuía ma quincahuili ma quisaca para yase nechhueyichihuatij. Pero intla ax quincahuas ma quisaca, na nijmictis icone achtohui ejquetl. Queja nopa xiquilhuiti Faraón. ");
INSERT INTO nheBl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Huan quema moquetztoya Moisés huan iteixmatcahua nopa tlayohua ipan ojtli para tlali Egipto, TOTECO monexti ica Moisés, huan quinequiyaya quimictis pampa ax quichijqui queja quiijtohua tlanahuatili. Ax quipiltzontequilijtoya iyecapa nopa cuetlaxtli tlen eltoc ipan ipiltlacayo ioquichpil. ");
INSERT INTO nheBl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Huajca isihua Moisés tlen itoca Séfora quicuic se cuchillo tlen tetl huan quipiltzontequili tlen monequi ipan ipiltlacayo icone huan quitoxonqui ipan iicxi Moisés huan quiilhui: “Nelía, ta tise nohuehue tlen espoltic.” ");
INSERT INTO nheBl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Huajca TOTECO ayoc cualanqui ica Moisés huan quicahuili ma yohui. Huan Séfora quitocajti Moisés “nohuehue tlen espoltic” pampa monejqui yajaya quitzontequilis icuetlaxo icone. ");
INSERT INTO nheBl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nojquiya TOTECO quiilhuijtoya Aarón para ma yas ipan nopa huactoc tlali para mopantiti ihuaya Moisés. Huajca Aarón yajqui quinamiquito Moisés ipan nopa tepetl campa monextijtoya Toteco Dios. Huan nopona Aarón quitlajpalo huan quitzoponi. ");
INSERT INTO nheBl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Huan Moisés quipohuili Aarón nochi tlamantli tlen TOTECO quiilhuijtoya ma quiijto huan nojquiya quinextili nopa huejhueyi tlanextilijcayotl tlen quinahuatijtoya ma quichihua. ");
INSERT INTO nheBl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Huajca Moisés huan Aarón ajsitoj tlali Egipto huan quinsentilijque nopa huehue israelita tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Huan Aarón quinpohuili nochi tlen TOTECO quiilhuijtoya Moisés huan quichijqui nopa tlanextilijcayotl tlen TOTECO quinextilijtoya ma quichihua. ");
INSERT INTO nheBl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Huan nochi nopa tlacame quineltocaque para TOTECO quintitlantoya. Huan quema quimatque israelita tlacame para TOTECO quinchihuilijtoya cuenta huan quinitztoya queja tlaijiyohuiyayaj, motlancuaquetzque iixpa TOTECO huan quihueyichijque. ");
INSERT INTO nheBl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Teipa Moisés huan Aarón yajque quicamahuito Faraón huan quiilhuijque: ―TOTECO Dios tlen tiisraelitame tijhueyichihuaj mitzilhuía para xiquincahua itlacajhua ma yaca campa huactoc tlali para ma quiilhuichihuilitij. ");
INSERT INTO nheBl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pero Faraón tlananquili: ―¿Huan ajqueya ‘imoTECO’ para na ma nijneltoquili huan ma niquincahua ma yaca ne israelitame? Ax niquixmati imoTECO, niyon ax niquincahuas ma yaca. ");
INSERT INTO nheBl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Huajca Moisés huan Aarón quiijtojque: ―Toteco Dios tlen toTeco tihebreos hualajtoc technamiquiqui huan techilhuijtoc tlen monequi ma tijchihuaca. Huajca xitechcahuili ma tiyaca eyi tonali ipan ojtli ipan nopa huactoc tlali para tijmacatij tlacajcahualistli TOTECO Dios, pampa intla amo, nohueli timiquise ica se hueyi cocolistli o ica machete. ");
INSERT INTO nheBl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pero nopa tlanahuatijquetl tlen tlali Egipto quinilhui Moisés huan Aarón: ―¿Para tlen inquintequipolohuaj ni tlacame? Ma mocuepaca ipan inintequi. ");
INSERT INTO nheBl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Huan nojquiya Faraón quinilhui: ―Ama itztoque tlahuel miyac israelitame ipan ni tlali, huan san inquintequipolohuaj. ");
INSERT INTO nheBl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Huajca ipan nopa tonal Faraón quinmacac se yancuic tlanahuatili nopa tlayacanani tlen quinnahuatiyayaj huan quinhuijhuitequiyayaj nopa israelita tlatequipanohuani. Quinilhui: ");
INSERT INTO nheBl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","―Ayoc xiquinmacaca sacatl israelitame para ma quichihuaca soqui ladrillos queja mochijtihualajtoc. Ma yaca inijuanti para quisentilitij nopa sacatl tlen monequi. ");
INSERT INTO nheBl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pero xiquinfuerzajhuica ma temactilica san se imiyaca ladrillos queja achtohui. Niyon se ladrillo ma ax polihui. Pampa nopa israelitame tlatzcacalactoque huan yeca tlahuejchihuaj huan quiijtohuaj quinequij yase quimacatij tlacajcahualistli ininTeco. ");
INSERT INTO nheBl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Huajca xiquinchihualtica ma tequitica más chicahuac nopa tlacame. Xiquintequihuica para ma ax quitlacaquilica ni istlacatili tlen Moisés huan Aarón quinilhuíaj. ");
INSERT INTO nheBl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Huajca nopa tlayacanani huan tecojme quisque huan yajque quinilhuitoj nopa israelitame: ―Nopa Faraón tlanahuatijtoc ma ayoc timechmacaca sacatl. ");
INSERT INTO nheBl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ama monequi inyase inquitemotij. Pero monequi inquitlamichihuase san se imiyaca ladrillos queja inquichihuayayaj achtohuiya. ");
INSERT INTO nheBl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Huajca nopa israelitame campa hueli yajque ipan tlali Egipto quitemotoj sacatzomitl tlen mocajtoya quema tlacame quitzontectoyaj sacatl, huan ya nopa quitequihuijque pampa ayoc oncayaya sacatl. ");
INSERT INTO nheBl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","14","Huan mojmostla itlayacancahua Faraón quinisihuiltiyayaj más huan quinilhuiyayaj: ―Xijtlamichihuaca san se imiyaca nopa soqui ladrillos ipan se tonal queja quema inmechmacayayaj sacatl. Huan nojquiya nopa Egipto tecojme quinmaquiliyayaj israelita tlayacanani huan quinilhuiyayaj: ―¿Quejatza, niyon yalohua, niyon ama, ax inquiaxitijtoque san se imiyaca ladrillos queja achtohuiya inquichihuayayaj? ");
INSERT INTO nheBl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Huan nopa israelita tlayacanani yajque tlajtlanitoj tlapalehuili ica tlanahuatijquetl Faraón, huan quiilhuijque: ―¿Para tlen quej ni titechchihuilía? ");
INSERT INTO nheBl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nopa Egipto tecojme ayoc techmacaj sacatl. Huan ax san ya nopa, nojquiya technahuatíaj ma tijchihuaca san se imiyaca soqui ladrillos, huan hasta techmaquilíaj pampa ax tihuelij. Pero inijuanti inintlajtlacol, pampa ax techmacaj sacatl. ");
INSERT INTO nheBl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Huajca Faraón quinnanquili: ―¡San intlatzihuini! ¡Quena, intlatzihuij! Huan yeca inquiijtojtinemij inyase inquimacatij tlacajcahualistli imoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Xiyaca xitequititij, huan yonque ayoc inmechmacase sacatl, monequi intemactilise san se imiyaca ladrillos. ");
INSERT INTO nheBl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Huan nopa tlayacanani tlen israelitame mocuesojque quema quinilhuijque para monequi ma ax temosquía imiyaca nopa soqui ladrillos queja achtohuiya quichihuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Huan quema quisque iixtla Faraón, quinpantitoj Moisés huan Aarón quinchixtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Huan nopa israelita tlayacanani quinilhuijque: ―TOTECO ma quiita tlen ax cuali inquichijtoque ica tojuanti, huan ma inmechtlatzacuilti. Imojuanti imotlajtlacol para itequihuejcahua Faraón ma techtlachilica fiero. Eltoc queja inquitlalijtoque machete ipan ininma para ma techmictica ica tlen inquiilhuijtoque nopa tlanahuatijquetl. ");
INSERT INTO nheBl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Huajca Moisés momaijto huan quiilhui TOTECO: ―Toteco, ¿para tlen tiquinchihuilía tlen ax cuali ni tlacame? ¿Para tlen titechtitlanqui? ");
INSERT INTO nheBl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Hasta nopa tonal quema nihualajqui nijcamahuico Faraón queja tinechilhui, yajaya noja más quintlaijiyohuiltijtoc motlacajhua, huan ta ax tleno tijchijtoc para tiquinmaquixtis. ");
INSERT INTO nheBl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Huan TOTECO quinanquili: ―Ama tiquitas tlen nijchihuas ica Faraón. Ax quincahuas notlacajhua ma quisaca ipan ni tlali hasta quiitas queja onpano hueyi nochicahualis. Pero quema quiitas nochicahualis, yajaya quintojtocas ma quisaca. ");
INSERT INTO nheBl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Huan noja Toteco Dios quicamahui Moisés huan quiilhui: ―NiimoTECO Tlen Nochipa Niitztoc. ");
INSERT INTO nheBl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nimonexti ica Abraham, Isaac huan Jacob huan niquinmatilti queja niitztoc pampa niquinilhui notoca: NimoTeco Tlen Nijpiya Nochi Chicahualistli, pero ax niquinilhui ni seyoc notoca: Na Tlen Nochipa Niitztoc. ");
INSERT INTO nheBl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nojquiya ininhuaya nijchijqui nopa tlajtoli para niquinmacas nopa tlali Canaán campa achtohui itztoyaj queja sejcoyoc ehuani. ");
INSERT INTO nheBl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Huan na nijcactoc quejatza chocaj nopa israelitame pampa nopa egiptome quintequipanoltíaj tlahuel chicahuac huan ax niquilcajtoc tlen niquintencahuilijtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ama xiquinilhui nochi israelitame para na niimoTECO niquinmaquixtis tlen inintequi tlen tlahuel ohui ipan ni tlali Egipto. Quena, ica na nochicahualis huan ica huejhueyi tlanextilijcayotl, niquinmanahuis. Nijchihuas huejhueyi tlanextilijcayotl para niquintlatzacuiltis nopa egiptome pampa quej nopa xitlahuac. ");
INSERT INTO nheBl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Huan xiquinilhuiti na nimoaxcatis nopa israelitame huan itztose notlacajhua. Huan na nielis niininTeco. Queja nopa quimatise para na niininTeco Dios tlen niquinmocuitlahuía, huan naja tlen niquinquixtis tlen nopa tequitl tlen tlahuel etic ipan ni tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Huan xiquinilhuiti niquinhuicas ipan nopa cuali tlali tlen niquintencahuili niquinmacas Abraham, Isaac huan Jacob. Huan niquinmacas nopa israelitame nopa tlali para elis iniaxca. Xiquinilhui na niininTECO niquijtohua. ");
INSERT INTO nheBl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Huajca Moisés quinpohuili israelitame nochi ya ni, pero ax quichihuilijque cuenta pampa mocuesohuayayaj ica inintequi tlen tlahuel chicahuac. ");
INSERT INTO nheBl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","―Xiya xiquilhuiti Faraón nopa tlanahuatijquetl ipan tlali Egipto para ma quincahua ma quisaca nopa israelitame tlen itlal. ");
INSERT INTO nheBl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pero Moisés quinanquili TOTECO: ―Niyon nopa israelitame ax nechtlacaquilise, ¿huajca quejatza nechtlacaquilis Faraón? Eltoc pampa ax cuali nitlatenquixtía quema nicamati. ");
INSERT INTO nheBl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Huajca queja nopa TOTECO quincamahui Moisés ihuaya Aarón huan quinilhui tlen monequi quinilhuise nopa israelitame huan Faraón. Huan quintequimacac ma quinquixtica israelitame ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Huan ya ni inintoca nochi inintlayacanca tatahua israelitame huan ajqueya inijuanti tlen tlacatque teipa tlen sesen hueyi tata tlen eliyaya itelpocahua Israel. Rubén tlen elqui iachtohui ejca cone Israel huejcajquiya quinpixqui iconehua tlen inintoca: Hanoc, Falú, Hezrón huan Carmi. Huan sesen ni tlacame quinpixqui miyac iixhuihua huan sesen mochijque se hueyi familia, pero nochi hualajque tlen Rubén huejcajquiya. ");
INSERT INTO nheBl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Huan Simeón itelpoca Israel huejcajquiya quinpixqui iconehua tlen inintoca: Jenuel, Jamín, Ohad, Jaquín, Zohar huan Saún tlen elqui icone se cananea sihuatl. Sesen ni tlacame quinpixqui miyac iixhuihua huan sesen mochijqui se hueyi familia, pero nochi hualajque tlen Simeón. ");
INSERT INTO nheBl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Huan Leví, tlen eliyaya itelpoca Israel huejcajquiya, itztoya 137 xihuitl. Huan ipan iyolis quinpixqui itelpocahua tlen inintoca: Gersón, Coat huan Merari. ");
INSERT INTO nheBl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Huan iconehua Gersón tlen mochijque huejhueyi familias elque: Libni huan Simei. ");
INSERT INTO nheBl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Huan Coat itztoya 133 xihuitl huan iconehua elque: Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nheBl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Huan iconehua Merari elque Mahli huan Musi. Nochi ya ni mochijque huejhueyi familias huan hualajque tlen ininhueyi tata Leví. Nicani eltoc inintoca ica tlen achtohui ejquetl huan quejatza yajtiyajque hasta tlen teipa ejquetl. ");
INSERT INTO nheBl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Huan ipan iconehua Coat, Amram mosihuajti ihuaya iahui tlen elqui iicni itata huan itoca eliyaya Jocabed, huan ya quintlacatilti Aarón huan Moisés. Huan Amram itztoya 137 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Huan Izhar quinpixqui itelpocahua tlen inintoca: Coré, Nefeg huan Zicri. ");
INSERT INTO nheBl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Huan iconehua Uziel elque: Misael, Elzafán huan Sitri. ");
INSERT INTO nheBl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Huan Aarón mosihuajti ihuaya Elisabet tlen eliyaya iichpoca Aminadab huan isihua icni Naasón, huan quintlacatilti Nadab, Abiú, Eleazar huan Itamar. ");
INSERT INTO nheBl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Huan iconehua Coré elque Asir, Elcana huan Abiasaf. Nochi ya ni mochijque huejhueyi familias huan hualajque tlen Coré. ");
INSERT INTO nheBl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Huan Eleazar, icone Aarón, mosihuajti ica se iichpoca Futiel huan yajaya quitlacatilti Finees. Nochi ni lista huajca eliyaya inintoca nopa tlacame tlen quinyacanque nopa huejhueyi familias tlen ininteixmatcahua. Huan nochi hualajque tlen ininhueyi tata Leví. ");
INSERT INTO nheBl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Huan ni Aarón huan Moisés tlen mopantía inintoca ipan ni lista eltoc san se nopa tlacame tlen TOTECO quinilhui ma quinchihuaca israelitame ma motecpanaca ica pamitl huan ma quinquixtica ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Huan nojquiya elque Moisés huan Aarón tlen quicamahuitoj Faraón, nopa tlanahuatijquetl ipan tlali Egipto para ma quinmaca caquihuili quinquixtise nopa israelitame. Huan teipa elque Moisés huan Aarón tlen quinyacanque nopa israelitame tlen nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Huan nopa tonal quema TOTECO quinojnotztoya Moisés ipan tlali Egipto, ");
INSERT INTO nheBl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","quiilhuijtoya: ―Na niDIOS. Xiquilhui Faraón, nopa tlanahuatijquetl ipan tlali Egipto, nochi nopa tlamantli tlen nimitzilhuía. ");
INSERT INTO nheBl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Huan Moisés quinanquili TOTECO: ―Na ax hueli cuali nitlatenquixtía quema nicamati, huajca ¿quejatza nechchihuilis cuenta Faraón? ");
INSERT INTO nheBl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Huan huajca TOTECO quiilhui Moisés: ―Xiquita, nimitzchihuas queja tielisquía se Dios quema timoquetzas iixpa Faraón. Huan moicni Aarón elis queja motiocamanalojca huan yajaya camatis mopampa ta. ");
INSERT INTO nheBl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Huan monequi tiquilhuis Aarón nochi tlen nimitznahuatis huan teipa yajaya camatis ihuaya Faraón para ma quincahua ma quisaca tlen itlal nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pero na nijchihuas para Faraón ma moyoltetilis huan ax quinequis. Huan nijchihuas ipan tlali Egipto miyac tlanextilijcayotl huan tlamantli tlen ax quema quiitztoque. ");
INSERT INTO nheBl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pero Faraón ax inmechtlacaquilis. Huan na nijtlalis noma ipan Egipto huan nijtlatzacuiltis. Huan nijchihuas miyac huejhueyi tlamantli para niquintlajtolxitlahuas hasta niquinquixtis notlacajhua tlen motecpanase ica miyac huejhueyi pamitl queja soldados. ");
INSERT INTO nheBl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Huan quema ya nijnextijtos nochicahualis ipan tlali Egipto huan ya niquinquixtijtos nopa israelitame nopona, nopa egiptome quimatise para na tlen niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Huan Moisés huan Aarón quichijque nochi queja TOTECO quinnahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Huan Moisés quipiyayaya 80 xihuitl huan Aarón 83 xihuitl quema camatque ihuaya Faraón. ");
INSERT INTO nheBl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Huan TOTECO quinilhui Moisés huan Aarón: ");
INSERT INTO nheBl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","―Quema Faraón inmechilhuis para xijchihuaca se tlanextilijcayotl, xijcui mocuatopil huan xijmajcahua tlalchi iixtla para ma mocuepa se cohuatl. ");
INSERT INTO nheBl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Huajca Moisés huan Aarón yajque quiitatoj Faraón, huan quichijque senquistoc tlen TOTECO quinnahuatijtoya. Aarón quimajcajqui tlalchi icuatopil iixtla Faraón huan itlapalehuijcahua, huan nopa cuatopili mocuepqui se cohuatl. ");
INSERT INTO nheBl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Huajca Faraón quinnotzqui nopa tlalnamiquini huan tetlajchihuiani huan tlen quimatque tecajcayahuaj huan sesen inijuanti nojquiya quichijque tlen Aarón quichijtoya ica inintetlajchihuijcayo. ");
INSERT INTO nheBl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Sesen inijuanti quimajcajque inincuatopil tlalchi huan nochi inincuatopilhua mocuepque cohuame. Pero icuatopil Aarón quincuajqui inincuatopil nopa sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pero yonque ya nopa quichijqui, Faraón moyoltetili queja TOTECO quiijtojtoya para quichihuasquía huan ax quineltoquili Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Teipa TOTECO quiilhui Moisés: ―Faraón moyoltetilijtoc huan ax quincahuas ma quisaca nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pero mostla cualca xiya xiquitati quema temos campa atl. Xijchiya iteno nopa atemitl Nilo huan xijhuica nopa cuatopili tlen mocuepqui cohuatl. ");
INSERT INTO nheBl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Huan nopona tiquilhuis Faraón para na niDios huan niimoTECO nochi inhebreo tlacame. Huan nimitztitlantoc tiquilhuis para ma quincahuilis ma yaca notlacajhua para ma nechhueyichihuatij ipan huactoc tlali, huan niquita para hasta ama, ax nechchihuilijtoc cuenta. ");
INSERT INTO nheBl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Huajca xiquilhui para niimoTECO niquijtohua para ama yajaya quimatis para najaya tlen nelía niDIOS huan niininTECO nopa israelitame. Huan xiquilhui para quema tijmaquilis nopa atl ica nopa cuatopili tlen tijpiya momaco, nopa atl mocuepas estli. ");
INSERT INTO nheBl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Huan xiquilhui para michime miquise, huan nopa atemitl mijmiyotis hasta egiptome quiijiyase para quiise tlen nopa atl. Quej nopa tiquilhuis Faraón. ");
INSERT INTO nheBl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nojquiya TOTECO quiilhui Moisés: ―Xiquilhui Aarón ma quicui icuatopil huan ma quixitlahua ima imelac nopa atemitl huan nopa atlajtli. Ma quixitlahua ima ipan campa meya huan campa quitecaj atl ipan tlali Egipto, huan nochi mocuepas estli. Huan nojquiya nopa atl ipan nochi comitl huan tlamantli tlen quipiyaj atl ipan ininchaj mocuepas estli hasta nopa atl ipan cuatecomitl huan comitl tlen quichijtoque tlen tetl nojquiya mochihuas estli. ");
INSERT INTO nheBl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Huajca Moisés huan Aarón quichijque nochi senquistoc queja TOTECO quinnahuatijtoya. Huan quitlalanqui icuatopil huan quimaquili nopa atemitl Nilo iixtla Faraón huan itequihuejcahua, huan nochi atl mocuepqui estli. ");
INSERT INTO nheBl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Huan nochi michime mijque, huan nochi nopa atemitl nelía mijmiyotiyaya hasta axaca hueliyaya atli. Oncayaya estli ipan nochi tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pero nopa tlalnamiquini huan tetlajchihuiani ipan tlali Egipto quichijque san se tlamantli ica inintetlajchihuijcayo, huan huajca Faraón moyoltetili huan ax quintlacaquili Moisés huan Aarón, queja TOTECO quiijtojtoya para panos. ");
INSERT INTO nheBl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Huan Faraón mocueptiquisqui huan yajqui icaltlanahuatil, niyon ax quichihuili cuenta ni tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Huan nochi nopa egiptome monejqui quichihuase ameli iteno atemitl para quiquixtise atl tlen cuali pampa nopa atl ipan atemitl ax hueliyaya moi. ");
INSERT INTO nheBl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Huan TOTECO quichijqui ma mocuepa estli nopa atl ipan atemitl Nilo, huan teipa panoc chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Huan TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón huan xiquilhuiti para niimoTECO niquijtohua para ma quincahuili ma yaca notlacajhua para nechhueyichihuatij. ");
INSERT INTO nheBl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Pampa intla ax quincahuilis ma yaca, na tlahuel nijtlatzacuiltis nochi itlal ica temasolime. ");
INSERT INTO nheBl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nopa atemitl Nilo quinyolitis tlahuel miyac temasolime. Huan nopa temasolime calaquise ipan ichaj, huan calaquise ipan itlapech campa cochi. Huan calaquise ipan ininchajchaj itlapalehuijcahua huan itlacajhua. Huan hasta calaquise campa quixacualohuaj harina huan campa quicacatzohuaj pantzi. ");
INSERT INTO nheBl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Huan nopa temasolime huitonise ipani, huan ininpan itlatequipanojcahua huan ininpan nochi itlacajhua. ");
INSERT INTO nheBl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Huan nojquiya TOTECO quiilhui Moisés: ―Teipa xiquilhui Aarón ma tlamanextis ica icuatopil ipan nopa atentli, huan campa mantoc atl para nopona ma quisaca temasolime huan ma quitemitica ni tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Huajca queja nopa Aarón tlamanexti ica icuatopil ipan nopa atl tlen eltoya ipan tlali Egipto, huan nopona quisque temasolime tlen quitemitijque nochi nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pero nopa tetlajchihuiani nojquiya san se quichijque ica inintetlajchihuijcayo. Nojquiya quichijque ma hualaca temasolime ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Teipa Faraón tlatitlanqui ma quinnotzatij Moisés ihuaya Aarón huan quinilhui: ―Xijtlajtlanica imoTECO para ma techijcuenili ni temasolime na ihuaya notlacajhua. Huan huajca niquincahuas itlacajhua ma yaca quimacatij tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Huan Moisés quinanquili Faraón: ―Nimitzcahuilis para xinechilhui nopa hora quema tijnequi ma nimomaijtos mopampa ta, huan ininpampa tlen mitzpalehuíaj, huan ininpampa motlacajhua. Huan ipan nopa hora quema ta tiquijtos, nimomaijtos ica TOTECO para nopa temasolime ma mitztlalcahuica, huan ma quitlalcahuica imochajchaj. Huan tiquitas para ipan nopa hora inmechtlalcahuise huan mocahuase san ipan atemitl. ");
INSERT INTO nheBl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Huajca Faraón quiijto: ―Xijchihua mostla. Huan Moisés tlananquili: ―Queja nopa elis, huan yeca tijmatis para axaca itztoc queja TOTECO Dios, ");
INSERT INTO nheBl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","pampa nopa temasolime ayoc itztose ipan imochajchaj. Mitztlalcahuise huan quintlalcahuise motequipanojcahua huan motlacajhua. San mocahuase ipan nopa atemitl Nilo. ");
INSERT INTO nheBl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Huajca Moisés huan Aarón quisque ipan ichaj Faraón. Huan teipa Moisés quitlajtlani TOTECO ma quinijcueni nopa temasolime tlen quintitlantoya ipan Faraón. ");
INSERT INTO nheBl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Huan TOTECO quichijqui tlen Moisés quitlajtlani, huan mijque nopa temasolime tlen itztoyaj ipan caltini huan calixpamitl huan ipan mila. ");
INSERT INTO nheBl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Huan nopa tlacame quinsentiliyayaj nopa temasolime tlen mictoyaj huan quinmontonojque campa hueli huan mijmiyotiyayaj tlahuel potehui. ");
INSERT INTO nheBl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero yonque queja nopa elqui, quema Faraón quiitac para ayoc oncac nopa tlamantli, moyoltetili huan ayoc quinchihuili cuenta Moisés huan Aarón, queja TOTECO quiijtojtoya para quichihuasquía. ");
INSERT INTO nheBl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Huajca TOTECO quiilhui Moisés: ―Xiquilhui Aarón ma quixitlahuas icuatopil huan ma quimaquili nopa tlaltejpoctli para ma mocuepaca atime. ");
INSERT INTO nheBl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Huajca queja nopa quichijqui. Huan Aarón quimaquili nopa tlaltejpoctli tlen tlalchi ica icuatopil, huan mocuepqui atime tlen quinajsic nochi tlacame huan tlapiyalime pampa nochi tlaltejpoctli mochijque atime. ");
INSERT INTO nheBl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Huan inijuanti tlen tetlajchihuíaj quichijque campeca para quinchihuase atime ica inintetlajchihuijcayo, pero ax huelque. Huan oncac atime ipan tlacame huan ipan tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Huajca nopa tetlajchihuiani quiilhuijque Faraón: ―¡Ni tlamantli san Dios hueli quichihua! Pero Faraón moyoltetili huan ax quintlacaquili, queja TOTECO quiijtojtoya para quichihuasquía. ");
INSERT INTO nheBl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Huan TOTECO quiilhui Moisés: ―Mostla ximehua cualca huan xiya xijnamiquiti Faraón quema temos ateno para maltiti huan xijcamahui. Xiquilhui para nimoTECO niquijtohua ma quincahua ma yaca notlacajhua para ma nechhueyichihuatij. ");
INSERT INTO nheBl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pampa intla ax quincahuas ma yaca, na nijtitlanis miyac pamitl tlen pilsayoltzitzi ipan ya, ipan itequihuejcahua huan ipan nochi itlacajhua. Quena, temis ica pilsayoltzitzi ininchajchaj nochi Egipto ehuani, huan hasta tlalchi nojquiya temis. ");
INSERT INTO nheBl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pero quema quej ni panos niquiyocaquixtis tlali Gosén campa itztoque notlacajhua. Nopona ax oncas niyon se pilsayoltzi. Quej nopa yajaya quimatis para na, niimoTECO, tlen niitztoc ipan ni tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nijchihuas ya ni para nesis catlía notlacajhua huan catlía ax notlacajhua. Quej ni elis mostla. ");
INSERT INTO nheBl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Huan TOTECO queja nopa quichijqui. Huan hualajque nochi tlamantli sayolime ipan Faraón huan ipan ininchajchaj itlatequipanojcahua. Nochi tlali Egipto temic ica sayolime. ");
INSERT INTO nheBl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Huajca Faraón tlanahuati ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Xiyaca xijmacatij tlacajcahualistli imoTeco Dios, pero amo xiquisaca tlen ni tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Huan Moisés tlananquili: ―Ax cuali tijchihuase queja nopa, pampa inEgipto ehuani inquinijiyaj nopa tlapiyalime tlen tijmacaj TOTECO Dios. Huan intla inEgipto ehuani intechitasquíaj, na cuali nijmati intechmictisquíaj ica tetl. ");
INSERT INTO nheBl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Monequi tiyase ipan huactoc tlali hasta campa hueli tiajsise ipan eyi tonali, huan nopona tijmacase tlacajcahualistli TOTECO Dios tlen tijtequipanohuaj pampa queja nopa yajaya technahuatía. ");
INSERT INTO nheBl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Huajca Faraón quiijto: ―Na nimechcahuas xiyaca ipan huactoc tlali para xijmacaca itlacajcahualis imoTECO Dios, pero amo xiyaca nelhuejca. Huan xijtlajtlanica imoTECO Dios nopampa na. ");
INSERT INTO nheBl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Huan Moisés tlananquili: ―Quema na niquisas nica, nijtlajtlanis TOTECO para mostla ma mitztlalcahuica nopa sayolime. Huan nojquiya quintlalcahuise tlen mitzpalehuíaj huan nochi Egipto ehuani. Pero xijpiya cuidado amo xitechcajcayahua, niyon ayoc xiquintzacuili israelitame para ma yaca quimacatij tlacajcahualistli TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Huan quema Moisés quisqui ichaj Faraón, quitlajtlani TOTECO, ma tlamica nopa sayolime, ");
INSERT INTO nheBl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","huan TOTECO quichijqui tlen Moisés quitlajtlani. Huan nopa sayolime quitlalcahuijque Faraón, huan itlayacancahua huan nochi Egipto ehuani. ");
INSERT INTO nheBl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pero Faraón sampa moyoltetili, huan ax quincahuili ma yaca nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Huajca TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón huan xiquilhuiti para na niDIOS, niininTECO hebreo tlacame, huan na niquilhuía ma quincahua notlacajhua ma yaca nechhueyichihuatij. ");
INSERT INTO nheBl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Huan xiquilhui intla ax quincahuas ma yaca huan noja quintzacuilijtos, ");
INSERT INTO nheBl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","huajca na, niininTECO, nijtlalis noma ipan itlapiyalhua tlen itztoque campa potrero, huan niquinmacas se hueyi cocolistli tlen nelfiero. Nopa cocolistli quinajsis icahuayojhua, iburrojhua, icamellos, ihuacaxhua, huan iborregojhua. ");
INSERT INTO nheBl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pero na niininTECO niquiniyocatlalis inintlapiyalhua israelitame ica tlen iniaxcahua nopa Egipto ehuani, pampa ax nijcahuas ma miquis niyon se tlapiyali tlen israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nojquiya TOTECO tlayolmelajqui nopa tonal quema quichihuas pampa quiijto: ―Na nijchihuas ni tlamantli mostla. ");
INSERT INTO nheBl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Huan hualmostla TOTECO ya nopa quichijqui. Nochi inintlapiyalhua Egipto ehuani mijque, pero ax mijqui niyon se inintlapiyal israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Huan Faraón tlatitlanqui ma yaca quinitatij inintlapiyalhua nopa israelitame huan quipantitoj niyon se tlapiyali ax mictoya. Pero yonque ya nopa elqui, Faraón moyoltetili huan ax quincahuili ma yaca nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Huajca TOTECO quinilhui Moisés huan Aarón: ―Xijcuica ome tlamojtzoli cuanextli campa quicacatzohuaj pantzi huan xijmajcahua ica huejcapa ipan ajacatl iixtla Faraón. ");
INSERT INTO nheBl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Huan nopa cuanextli mocuepas tlaltejpoctli tlen más cuechtic huan mosemanas ipan nochi tlali Egipto huan quichihuas ma quisaca miyac tlaxhuisme ipan nochi tlacame huan tlapiyalime ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Huajca Moisés ihuaya Aarón quicuique cuanextli campa quicacatzohuaj pantzi huan yajque quiitatoj Faraón. Nopona Moisés quimajcajqui nopa cuanextli ica huejcapa, huan ya nopa quichijqui ma quisaca tlaxhuisme tlen temalohuayayaj ipan nochi tlacame huan tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Huan nopa tetlajchihuiani ax huelque monextijque iixtla Moisés pampa inijuanti nojquiya quinpixque tlaxhuisme campa hueli queja nochi Egipto ehuani. ");
INSERT INTO nheBl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pero TOTECO quichijqui para Faraón ma moyoltetili huan ma ax quinchihuili cuenta Moisés huan Aarón, queja TOTECO quiilhuijtoya Moisés para quichihuasquía. ");
INSERT INTO nheBl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Huajca TOTECO quiilhui Moisés: ―Mostla ximehua cualca huan xiya xiquilhuiti Faraón para na tlen niininTECO nopa hebreo tlacame huan niquijtohua ma quincahua ma yaca notlacajhua para nechhueyichihuatij. ");
INSERT INTO nheBl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Pampa ni huelta nijtitlanis se tlatzacuiltili tlen ajsis ipan iyolo Faraón, huan ipan ininyolo nochi tlen quipalehuíaj huan nochi itlacajhua. Huan ica ya ni yajaya quimatis para axaca seyoc Dios ipan nochi tlaltepactli, san na. ");
INSERT INTO nheBl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Xiquilhui Faraón para na nihueltosquía nijmictijtosquía ica se cocolistli ihuaya nochi itlacajhua. ");
INSERT INTO nheBl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Pero xiquilhui na nijtlali ipan itequi huan nijcajtoc ma itzto hasta ama para nijnextilis nohueyi chicahualis huan para nochi tlacame ipan tlaltepactli ma quicaquica ajqueya na. ");
INSERT INTO nheBl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pero yonque quiitztoc nochi tlen nijchijtoc iixtla, noja quintzacuilía notlacajhua huan ax quincahua ma yaca. ");
INSERT INTO nheBl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Huajca xiquilhui para mostla ipan ni hora nijchihuas ma huetzi tesihuitl nelchicahuac queja ax quema huetztoc ipan nochi tlali Egipto hasta quema pejqui ni tlali huan hasta ama. ");
INSERT INTO nheBl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Huajca xiquilhui para nimantzi ma tlanahuati ma quintzacuaca inintlapiyalhua, pampa nopa tesihuitl quinmictis nochi tlacame huan nochi tlapiyalime tlen ax quintzacuase calijtic. ");
INSERT INTO nheBl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Huan sequin itlapalehuijcahua Faraón quineltocaque tlen TOTECO quiijto huan moisihuiltijque quintlalijque calijtic nochi inintlapiyalhua huan inintequipanojcahua tlen quincojtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pero itztoyaj sequin tlen san quiahuilmatque itlajtol TOTECO tlen Moisés quinilhuijtoya, huan quincajque ipan cuatitlamitl huan ax quintzajque calijtic. ");
INSERT INTO nheBl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Huajca TOTECO quiilhui Moisés: ―Xijtlalana moma huan xijmanexti elhuicac para ma huetzi tesihuitl campa hueli ipan nochi tlali Egipto. Huetzis ipan nochi tlacame huan tlapiyalime huan huetzis ipan nochi tlatoctli ipan ininmil Egipto ehuani. ");
INSERT INTO nheBl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Huajca Moisés quitlalanqui icuatopil hasta elhuicac huan TOTECO quititlanqui tlatomonilotl, tlapetlanilotl huan tesihuitl ipan nochi tlali Egipto. Huan nelía fiero elqui. ");
INSERT INTO nheBl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tlahuel chicahuac huetzqui nopa tesihuitl huan tlapetlaniyaya huan ax moquetzayaya. Hasta ipejya Egipto ax quema huetztoya se tesihuitl queja nopa. ");
INSERT INTO nheBl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Huan nopa tesihuitl quipolo nochi tlen oncayaya ipan tlali Egipto. Quinmicti nochi tlacame huan tlapiyalime tlen ax itztoyaj calijtic, huan quipolo nochi tlatoctli ipan mili huan nochi cuatini ipan inintlal. ");
INSERT INTO nheBl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","San ipan tlali Gosén campa itztoyaj israelitame, ax huetzqui niyon se tesihuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Huajca Faraón tlatitlanqui ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Ama nitlajtlacolchijtoc. Tlen imoTECO quichihua, ya nopa xitlahuac huan tlen na huan notlacajhua tijchihuaj, ax cuali. ");
INSERT INTO nheBl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Nelmiyac tlatomonilotl huan tesihuitl techajsitoc, huajca ayoc niquintzacuilis más nopa israelitame. Xijtlajtlanica, imoTECO, topampa tojuanti para ma ayoc huetzi tesihuitl, huan na niquincahuas ma yaca israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Huan Moisés quinanquili: ―Nimantzi quema niquisas tlen ni altepetl, nijtlalanas noma huan nimomaijtos ica TOTECO. Huan ayoc huetzis nopa tesihuitl huan ayoc tlatomonis, huan queja nopa tijmatis para ni tlaltepactli iaxca TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero na cuali nijmati para niyon ta, niyon tlen mitzpalehuíaj, ax inquitlepanitaj TOTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Huan nochi nopa tlatoctli tlen itoca lino huan cebada nenpolijque pampa nopa cebada ya eltoya para xitinis huan nopa lino xochiyojtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pero nopa trigo ihuaya nopa centeno ax tleno ipantic, pampa xitini teipa. ");
INSERT INTO nheBl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Huan quema Moisés quisqui campa Faraón huan campa nopa altepetl, quitlalanqui ima ica TOTECO huan momaijto. Huan nimantzi nochi moquetzqui. Ayoc huetzqui tesihuitl, niyon ayoc tlaahuetzqui huan ayoc tlatomonqui. ");
INSERT INTO nheBl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pero quema Faraón quiitac para ayoc huetziyaya atl, niyon ayoc huetziyaya tesihuitl, niyon ayoc tlatomoniyaya, sampa tlajtlacolchijqui. Huan ax san ya moyoltetili, pero nojquiya san se quichijque nochi tlen quipalehuiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Huan pampa moyoltetili, Faraón ax quincahuili ma yaca nopa israelitame queja TOTECO teyolmelajtoya ica Moisés para quichihuasquía. ");
INSERT INTO nheBl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Huan TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón pampa na nijchijtoc para ya ihuaya itequihuejcahua ma moyoltetilica para huelis nijchihuas ni huejhueyi tlanextilijcayotl tlen nijchihua iniixpa. ");
INSERT INTO nheBl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Huan yeca se tonal ta huelis tiquinpohuilis moconehua huan moixhuihua nopa huejhueyi tlamantli tlen nijchijqui iniixpa Egipto ehuani. Quena, niquinyoltetilijtoc para xijmatica para na niDIOS, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Huajca Moisés huan Aarón yajque quiitatoj Faraón huan quiilhuijque: ―TOTECO Dios tlen tihebreo tlacame tiquixmatij mitztlajtlanía hasta quema timoechcapanos iixtla. Quiijtohua monequi xiquincahua ma yaca itlacajhua para ma quihueyichihuatij. ");
INSERT INTO nheBl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Quiijtohua intla ax tijchihuas, mostla quichihuas ma hualaca chapolime ipan motlal. ");
INSERT INTO nheBl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Huan nopa chapolime quitemitise ni tlali hasta ayoc nesis tlalchi. Quicuase tlen quentzi mocahua ama tlen inquitojque tlen ax nenpolijqui ica tesihuitl. Huan nopa chapolime quicuase nochi cuatini tlen mocahua. ");
INSERT INTO nheBl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Temise ipan mochaj huan ininchajchaj motequipanojcahua huan nochi sequinoc Egipto ehuani. Ipan nochi ininyolis, imotatahua niyon imohuejcapan tatahua tlen huejcajquiya itztoyaj ax quema quiitztoque se tlamantli queja tlen ama nijchihuas. Quema Moisés tlanqui camati, moicancuepqui huan quisqui tlen ichaj Faraón. ");
INSERT INTO nheBl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Huan itequihuejcahua Faraón quiilhuijque: ―¿Hasta quema ni tlacatl noja techcuesolmacas? Xiquincahua ma yaca nopa tlacame ma quihueyichihuatij ininTECO Dios. ¡Ay Tlanahuatijquetl! ¿Aya tiquita para totlal Egipto ya tlamixolejtoc? ");
INSERT INTO nheBl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Huan Faraón tlatitlanqui sampa ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Xiyaca xijhueyichihuatij imoTECO Dios. Pero achtohui xinechilhuica ajqueya inijuanti tlen yase. ");
INSERT INTO nheBl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Huan Moisés tlananquili: ―Monequi nochi tiyase. Yase topilconehua hasta tohuehue tlacajhua. Yase totelpocahua, toichpocahua, nochi toborregojhua huan nochi tohuacaxhua, pampa tijchihuase se hueyi ilhuitl para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pero Faraón quinilhui: ―Tlanemijya nesi para ax ya nopa tlen inquichihuase. ¿Inmoilhuíaj para na nimechcahuas inyase ininhuaya nochi imosihuajhua huan imoconehua huan para imoTeco yas imohuaya? ");
INSERT INTO nheBl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","¡Axtle! ¡Ax quej nopa elis! Xiyaca san intlacame para xijhueyichihuatij imoTECO, pampa ya nopa tlen inquiijtohuaj inquinequij. Huan itlapalehuijcahua quintojtocaque Moisés huan Aarón iixtla Faraón. ");
INSERT INTO nheBl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Huan TOTECO quiilhui Moisés: ―Xijxitlahua moma ipan tlali Egipto para ma hualaca chapolime huan ma quitemitica. Ma quicuaca nochi tlatoctli huan nochi tlen mocajqui quema huetzqui tesihuitl campa hueli ipan inintlal. ");
INSERT INTO nheBl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Huan yeca Moisés quixitlajqui ima ipan tlali Egipto, huan TOTECO quichijqui ma huala se ajacatl campa quisa tonati huan quiilpitzqui nopa tlali se tonal huan se yohuali. Huan hualmostla nopa ajacatl ya quinhualicatoya chapolime. ");
INSERT INTO nheBl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Huan nopa chapolime calajque campa hueli ipan inintlal. Ax quema oncatoya imiyaca chapolime queja nopa ipan se tlali, niyon ayoc quema oncas. ");
INSERT INTO nheBl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Quitemitijque nopa tlali hasta ax nesiyaya tlalchi, huan quicuajque nochi tlatojtoctli huan nochi cuatlactli tlen mocajtoya ipan cuatini tlen momanahuijtoya quema huetzqui tesihuitl. Ax tleno tlen xoxohuic mocajqui ipan nochi tlali Egipto, niyon ipan cuatini, niyon ipan mila. ");
INSERT INTO nheBl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Huajca Faraón tlatitlanqui nimantzi ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Nitlajtlacolchijtoc ica imoTECO Dios huan ica imojuanti, ");
INSERT INTO nheBl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","pero nimechtlajtlanía para san ni huelta xinechtlapojpolhuica notlajtlacol. Huan ximomaijtoca ica imoTECO Dios nopampa na para ma nechtlalcahui ni tlatzacuiltili tlen techmictía. ");
INSERT INTO nheBl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Huan Moisés quisqui ichaj Faraón huan momaijto ica TOTECO ipampa ya. ");
INSERT INTO nheBl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Huan TOTECO quipatlac iojhui nopa ajacatl, huan mocuepqui se chicahuac ajacatl campa temo tonati huan quinhuicac nopa chapolime huan quinmajcajqui ipan Hueyi Atl tlen itoca Chichiltic. Huan ax mocajqui ipan Egipto niyon se chapoli. ");
INSERT INTO nheBl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero TOTECO quichijqui para Faraón ma moyoltetili huan ma ax quincahuili ma yaca nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Huajca TOTECO quiilhui Moisés: ―Xijxitlahua moma para elhuicac, huan ipan nochi tlali Egipto ma onca se tzintlayohuilotl tlen nelyayahuic huan tilahuac hasta huelis tiquitzquis. ");
INSERT INTO nheBl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Huajca Moisés quitlalanqui ima para elhuicac, huan oncac se tzintlayohuilotl nelhueyi ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Para eyi tonali axaca hueliyaya moitaj se ica seyoc ipan nopa tzintlayohuilotl huan axaca quisqui ipan ichaj. Pero ipan nochi ininchajchaj israelitame oncayaya tlahuili. ");
INSERT INTO nheBl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Huajca Faraón tlatitlanqui ma quinotzatij Moisés huan quiilhui: ―Xiyaca xijhueyichihuatij imoTECO, huan xiquinhuicaca nojquiya imoconehua, pero ma mocahuaca nica imoborregojhua ininhuaya imohuacaxhua. ");
INSERT INTO nheBl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pero Moisés tlananquili: ―¡Ax tihuelise! Monequi titechcahuilis ma tiquinhuicaca nopa tlapiyalime para nopa tlacajcahualistli tlen tijtlatise para tijmacase TOTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Huajca nojquiya totlapiyalhua yase tohuaya. Niyon se tlapiyali ax hueli tijcajtehuase pampa monequi tiquintlapejpenise sequin inijuanti tlen titemacase quema tijhueyichihuase TOTECO Dios. Huan ax tijmatise tlaque tlapiyalime tiquintequihuise hasta tiajsise nepa. ");
INSERT INTO nheBl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero TOTECO quichijqui para Faraón ma moyoltetili huan ma amo quincahuili ma yaca. ");
INSERT INTO nheBl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Nojquiya Faraón quiilhui Moisés: ―Xinechtlalcahui huan xijpiya cuidado para ayoc tinechixtlachiliqui sampa. Ipan nopa tonal quema timonextiqui noixtla, timiquis. ");
INSERT INTO nheBl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Huan Moisés tlananquili: ―Cuali tlen tiquijtojtoc. Ayoc quema nimitzitas sampa. ");
INSERT INTO nheBl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Huan TOTECO quiilhui Moisés: ―Noja nijhualicas seyoc tlatzacuiltili ipan Faraón huan nopa egiptome. Huan teipa ax san inmechcahuas xiyaca, pero quena, hasta inmechtojtocas. ");
INSERT INTO nheBl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ama xiquinilhui israelitame para monequi nochi tlacame huan sihuame ma quintlajtlanica inincalnechcahua tlamantli tlen oro huan plata. ");
INSERT INTO nheBl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Huan TOTECO quichijtoya para nopa egiptome ma quincualitaca israelitame. Huajca quinmajmacaque nopa israelitame tlen quintlajtlaniyayaj. Nojquiya nopa tequihuejme tlen quipalehuiyayaj Faraón quitlepanitayayaj Moisés huan nochi egiptome nojquiya quicualitayayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Huajca Moisés quiilhui Faraón: ―TOTECO quiijtohua para tlajco yohual yajaya panos ipan nochi tlali Egipto, ");
INSERT INTO nheBl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","huan quinmictis nochi imoachtohui ejca conehua ipan nochi imochajchaj nochi inEgipto ehuani. Miquis moachtohui ejca ta tiFaraón tlen timosehuía ipan nopa siya yejyectzi campa titlanahuatía huan hasta miquis iachtohui ejca sesen sihua tlatequipanojquetl tlen tisi para iteco. Nojquiya miquise nochi iniachtohui ejcahua imotlapiyalhua. ");
INSERT INTO nheBl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ipan nochi tlali Egipto, tlacame ayijtise chicahuac queja ax quema quichijtoque, huan queja ayoc quema quichihuase sampa. ");
INSERT INTO nheBl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero campa itztoque israelitame, niyon se chichi ax tlaajhuas huan ax miquis niyon se tlacatl o tlapiyali. Huajca Faraón ta tijmatis para TOTECO nelía quinicnelía israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Huan hualase nechitaquij nochi ni tequihuejme tlen mitzpalehuíaj huan motlancuaquetzase noixtla para nechilhuise chicahuac para ma tiyaca ininhuaya nochi totlacajhua. Huan quema panos ya nopa, huajca quena, niyas. Huan Moisés quisqui iixtla Faraón nelcualantoc. ");
INSERT INTO nheBl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Huan TOTECO ya quiilhuijtoya Moisés: ―Nopa Faraón ax inmechtlacaquilis, huan yeca queja nopa nijchihuas noja más huejhueyi chicahualnescayotl ipan Egipto para niquinnextilis nohueyi chicahualis. ");
INSERT INTO nheBl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Huajca yonque Moisés ihuaya Aarón quichijque nochi ni huejhueyi chicahualnescayotl iixtla Faraón, TOTECO quichijtoya ma moyoltetili Faraón huan yeca ax quincahuili ma quisaca nopa israelitame tlen tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Huan ipan tlali Egipto TOTECO camatqui ihuaya Moisés huan Aarón, huan quinilhui: ");
INSERT INTO nheBl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ama huan para nochipa ni metztli elis nopa achtohui metztli tlen imoxihui inisraelitame. Huan ni metztli elis tlen más ipati para imojuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Xiquinilhuica nochi israelitame para ama huan teipa sesen xihuitl ipan 10 itequi ni metztli, sesen imojuanti ma quicui se pilborregojtzi o se oquich chivo para ifamilia. Sese familia quicuis san para ichaj. ");
INSERT INTO nheBl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Huan intla ax hueyi se familia huan ax hueli quicuase nochi se pilborregojtzi, ma quitlajcoitase se pilborregojtzi ihuaya tlen itztoque icalnechca huan quicuase san sejco. Monequi quinpohuase quesqui ininmiyaca nopa tlacame tlen itztoque huan quesqui ininmiyaca tlen sesen huelis quicuas para quimatise quejatza ihuexca se pilborregojtzi huelise quitlamise. ");
INSERT INTO nheBl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Huan xiquinilhuica monequi quitlapejpenise se oquich tlapiyali tlen quipiya se xihuitl, huan tlen ax tleno tlen ax cuali quipiya itlacayo. Huelis quitequihuise se pilborregojtzi o se chivo. ");
INSERT INTO nheBl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Monequi quiajcocuise nopa tlapiyali tlen quitlapejpenise hasta 14 itequi ni metztli. Huan ipan nopa tonal quema tiotlaquixtos, sesen familia tlen israelitame quimictise inintlapiyal. ");
INSERT INTO nheBl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Huan teipa quicuise ieso nopa tlapiyali huan quipolose nopa caltencuahuitl itzonpac icuapuerta nopa cali campa quicuase inacayo. Nojquiya quipolose nopa caltencuahuitl ipan inejmatl huan iarraves. ");
INSERT INTO nheBl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Huan ipan nopa tlayohua quicuase nopa nacatl tlahuatztli. Huan quicuase ica quilitl tlen chichic huan pantzi tlen ax quipiya tlasonejcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ma ax quicuaca nopa nacatl xoxohuic, niyon tlamolontli. Monequi inquitlihuatzase nopa tlapiyali nejmajtic ica itzonteco, imetz huan nochi tlen quipixtoc iijtico. ");
INSERT INTO nheBl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Huan ax tleno hueli inquicahuase para seyoc tonal. Intla se tlamantli mocahua nopa tlayohua huan ax inquitlamicuase, monequi inquitlatise. ");
INSERT INTO nheBl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“Quej ni intlacuase. Achtohui ximoyoyontica ica imotlaque huan ximoilpica. Ximotecactica huan xijpixtoca imocuatopil imomaco. Huan huajca, quena, xijcuaca nimantzi nopa tlapiyali, pampa ya nopa noPascua, niimoTECO, quema na nimechpanos para axaca tlen imojuanti miquis. ");
INSERT INTO nheBl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pero ipan nopa tlayohua nipanos ipan nochi tlali Egipto huan niquinmictis nopa oquichpilme tlen achtohui ehuani ipan sesen familia tlen egiptome huan nopa oquichtli tlen achtohui tlacatqui tlen inintlapiyalhua. Huan niquintlamiltis nochi inintlaixcopincayohua nopa Egipto ehuani. Na niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","“Huan nopa estli elis queja se tlanextilijcayotl ipan caltini para xijnextica campa initztoque. Huajca queja nopa quema niquitas nopa estli, san nimechcalpanos huan ax tleno ininpantis imoconehua quema niquinmictis nopa Egipto ehuani ininconehua. ");
INSERT INTO nheBl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Huan ni tonal quema niquintlatzacuiltis egiptome monequi inquiilnamiquise sesen xihuitl. Ipan ni tonal monequi xinechchihuilica se hueyi ilhuitl na, niimoTECO. Inquichihuase ni ilhuitl para nochipa huan ni ilhuitl panos tlen tetajme hasta ininconehua. ");
INSERT INTO nheBl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Huan ipan nopa ilhuitl inquicuase pantzi tlen ax quipiya tlasonejcayotl para chicome tonali. Huajca ipan nopa achtohui tonal monequi xijquixtica nochi tlasonejcayotl ipan imochajchaj. Intla acajya quicuas pantzi tlen quipiya tlasonejcayotl ipan nopa chicome tonali ipan nopa ilhuitl, monequi xijquixtica tlen israelitame para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ipan nopa achtohui tonal ximosentilica san sejco ipan se tlasentilistli tlen tlatzejtzeloltic huan sampa ximosentilica ipan nopa chicompa tonal. Ma amo aca tequitis ipan nopa tonal. San huelis inquisencahuase tlacualistli para nochi ma tlacuaca. ");
INSERT INTO nheBl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Quena, xijchihuaca nopa ilhuitl tlen pantzi tlen ax quipiya tlasonejcayotl sesen xihuitl ipan ni tonal quema nimechquixti nochi imojuanti ipan tlali Egipto. Huajca xiilhuichihuaca ipan ni tonal para nochipa. Huan ni ilhuitl panos tlen tetajme hasta ininconehua para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Quena, sesen xihuitl ica tiotlac ipan 14 itequi nopa achtohui metztli, xipehuaca xijcuaca pantzi tlen ax quipiya tlasonejcayotl huan san ya nopa xijcuaca hasta tiotlac ipan 21 itequi nopa metztli. ");
INSERT INTO nheBl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","“Monequi ax oncas tlasonejcayotl ipan imochajchaj para nopa chicome tonali. Pampa intla acajya quicuas pantzi ica tlasonejcayotl, monequi inquiquixtise tlen israelitame. San se inquichihuase yonque quicuas se tlen ehua seyoc tlali, o se israelita tlen nopona ehua. ");
INSERT INTO nheBl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ax tleno xijcuaca tlen quipiya tlasonejcayotl, yonque campa hueli initztoque. Monequi xijcuaca san nopa pantzi tlen ax quipiya tlasonejcayotl.” Queja nopa TOTECO quiilhui Moisés huan Aarón ma quinilhuitij israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Huajca Moisés quinnotzqui nochi nopa huehue tlacame tlen tlayacanayayaj ipan israelitame huan quinilhui: “Xiyaca nimantzi huan xijtlapejpenica sesen imojuanti se pilborregojtzi o se chivo para imofamilias, huan xiquinmictica para inilhuichihuase para nopa Pascua. ");
INSERT INTO nheBl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Xijcuica se tlaitzquili tlen nopa xihuitl itoca hisopo huan xijxolonica ipan nopa estli tlen eltoc ipan huajcali. Huan xijpoloca itzonpac huan ipan nochi inejmatl huan iarraves nopa caltencuahuitl tlen imocalpuerta. Huan niyon se imojuanti ax hueli quisas calteno hasta quema tlanesis. ");
INSERT INTO nheBl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Huan quema TOTECO panos para quinmictis nopa egiptome, intla quiitas nopa estli itzonpac huan ipan nochi ome iteno se puerta, huajca san quipanos nopa cali. Queja nopa, TOTECO ax quicahuilis nopa tlaxolejquetl ma calaqui ipan imochajchaj para quinmictis imoconehua. ");
INSERT INTO nheBl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Monequi imojuanti ihuaya imoixhuihua, xijtlepanitaca ni tlanahuatili para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Huan quema ya incalactose ipan nopa cuali tlali tlen TOTECO inmechmacas queja inmechtencahuilijtoc, monequi inquichihuase ni tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Huan quema imoconehua inmechtlajtlanise tlaque quiijtosnequi ni ilhuitl tlen inquichihuaj, ");
INSERT INTO nheBl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","xiquinilhuica para ni tlapiyali tlen Pascua tlen tijmictíaj eltoc se tlacajcahualistli para TOTECO. Techilnamiquiltía quejatza elqui quema TOTECO quinmicti nopa egiptome, pero san quipanoc tochajchaj tiisraelitame tlen nojquiya tiitztoyaj ipan tlali Egipto huan ax quimicti niyon se tlen tofamilias.” Queja nopa Moisés quinpohuili nopa israelita tlayacanani. Huan nopa tlayacanani motlancuaquetzque huan mohuijtzonque tlalchi huan quihueyichijque TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Huan teipa yajque huan quichijque tlen TOTECO quinnahuatijtoya Moisés ihuaya Aarón. ");
INSERT INTO nheBl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Huan tlajco yohual TOTECO quinmicti sese achtohui ejquetl ipan sesen familia tlen Egipto ehuani. Quimicti iachtohui ejca Faraón tlen mosehuía ipan nopa yejyectzi siya para tlanahuatis, hasta iniachtohui ejca tlen itztoya ipan tlatzactli, huan nojquiya quinmicti iniachtohui conehua nochi tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Huajca nopa tlayohua mejque Faraón huan nochi itequihuejcahua tlen quipalehuiyayaj, huan nochi sequinoc egiptome, huan campa hueli ipan nochi nopa tlali Egipto nochi chocayayaj huan tlahuejchihuayayaj. Ax oncayaya niyon se cali tlen Egipto ehuani campa ax oncayaya se mijcatzi. ");
INSERT INTO nheBl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Huajca ipan nopa tlayohua Faraón tlatitlanqui ma quinnotzatij Moisés ihuaya Aarón, huan quinilhui: ―Amantzi xiquisaca. Xiyaca imojuanti ininhuaya nochi nopa israelitame. Xiquincahuaca notlacajhua. Xiyaca xijhueyichihuatij imoTECO queja inquiijtojque. ");
INSERT INTO nheBl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Xiquinhuicaca nojquiya imoborregojhua huan imohuacaxhua queja inquiijtojtoyaj, huan xiyaca. Huan xijtlajtlanica imoTECO nopampa na. ");
INSERT INTO nheBl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Huan nopa Egipto ehuani quinisihuiltijque nopa israelitame para ma quisaca tlen nopa tlali pampa moilhuiyayaj huelis nochi egiptome miquisquíaj. ");
INSERT INTO nheBl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Huajca nopa israelitame quicuique inintix, yonque aya quipiyayaya tlasonejcayotl para mosonehuas. Huan quitlalijque ipan tixhuapali, huan quiquimilojque ica yoyomitl huan quitlalijque iniajcolpa. ");
INSERT INTO nheBl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Nojquiya quichijque tlen Moisés quinnahuatijtoya huan quintlajtlanijque nopa egiptome yoyomitl huan tlamantli tlen oro huan plata. ");
INSERT INTO nheBl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Huan TOTECO quichijqui para nopa Egipto ehuani ma quincualitaca nopa israelitame huan quinmacaque nochi tlen tlajtlaniyayaj, huan yeca nopa israelitame nelía quintlaquijquixtilijque egiptome. ");
INSERT INTO nheBl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Huan nopa israelitame quisque Ramesés huan nejnenque hasta Sucot. Huan intla mopohuasquía san inijuanti tlen ya quipixque xihuitl para tlatehuise, mochihuayayaj nechca 600 mil, pero ax quinpojque sihuame huan coneme. Huan nochi icxinejnemiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Huan ininhuaya yajque miyac tlamantli tlacame tlen ax israelitame huan nojquiya miyac borregojme huan huacaxme. ");
INSERT INTO nheBl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Huan quichijque pantzi ica nopa tixtli tlen quiquixtijtoyaj. Huan nopa tixtli ax quipixqui tlasonejcayotl pampa nopa egiptome quintojtocaque huan ax quiaxilijque para quisencahuase inintlacualis. ");
INSERT INTO nheBl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Nopa israelitame itztoyaj ipan tlali Egipto para 430 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Huan ipan nopa tonal quema quiaxitijque nopa 430 xihuitl, nochi itlacajhua TOTECO quisque ipan nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","TOTECO quitlapejpeni nopa tlayohua huan quiiyocatlali para ya iselti pampa elqui ipan nopa tlayohua quema quinquixtiyayaj israelitame ipan tlali Egipto. Huajca ipan nopa tlayohua sesen xihuitl monequi nochi israelitame tlen ama itztoque huan tlen teipa tlacajtiyase neltlachixtose para quitlepanitase TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Huan TOTECO quinilhui Moisés huan Aarón: “Ya ni nochi nopa tlanahuatili para nopa Pascua Ilhuitl. Niyon se tlen ehua seyoc tlali ax huelis quicuas tlen nopa tlapiyali tlen inquimictijtoque. ");
INSERT INTO nheBl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Pero se tequitiquetl tlen inquicojtoque, quena, huelis quicuas intla ya inquitzontequilijtoque iyecapa cuetlaxo ipan itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Pero se tlen ehua seyoc tlali tlen san panotinemi, o se tlatequipanojquetl tlen inquitlaxtlahuíaj pampa ax imoaxca ax hueli quicuas tlen nopa tlapiyali. ");
INSERT INTO nheBl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Monequi xijcuaca sesen tlapiyali calijtic ipan san se cali. Amo xijquixtica niyon se quentzi nopa nacatl calteno. Amo xijtlapanilica niyon se iomiyo nopa tlapiyali. ");
INSERT INTO nheBl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Nochi israelita tlacame sentic monequi ilhuichihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Huan intla itztoc se sejcoyoc ejquetl imohuaya tlen quinequi ilhuichihuas imohuaya para quinextis tlen TOTECO quichijqui ipan Pascua, monequi ma motzontequili nopa cuetlaxtli ipan itlacayo, huan san se quichihuas ica nochi ioquichpilhua huan nochi itlaca tlatequipanojcahua. Teipa quena, huelis quichihuas nopa ilhuitl huan quicuas nopa nacatl queja nochi sequinoc tlen tlacatque ipan imotlal quichihuaj. Pero niyon se oquichpil huan niyon se tlacatl ax huelis quicuas inacayo nopa tlapiyali intla ax motzontequilijtoc iyecapan nopa cuetlaxtli ipan itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Se tlen ax motequilijtoc queja monequi ax hueli quicuas yonque tlacatqui se israelita, o tlacatqui ipan seyoc tlali huan ama itztoc tlatlajco imojuanti.” ");
INSERT INTO nheBl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Huan nochi nopa israelitame quichijque senquistoc queja TOTECO quinnahuatijtoya Moisés huan Aarón. ");
INSERT INTO nheBl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Huajca ipan nopa tonal TOTECO quinquixti itlacajhua tlen tlali Egipto motecpantoyaj ica miyac pamitl queja soldados. ");
INSERT INTO nheBl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Xinechiyocacahuili nochi oquichpilme tlen achtohui ehuaj, pampa nochi oquichpilme tlen achtohui ehuaj tlen israelitame huan nochi inioquich tlapiyalhua tlen achtohui ehuaj, nochi elise noaxcahua.” ");
INSERT INTO nheBl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Huajca Moisés quinilhui nochi tlacame: “Xiquilnamiquica ni tonal huan xiilhuichihuaca ipan ni tonal sesen xihuitl, pampa ipan ni tonal ica hueyi chicahualistli TOTECO techquixti tlen tlali Egipto campa titequipanohuayayaj queja titlacohualme tlen techcojtoyaj para tiiniaxcahua. Huan ipan ni tonal ax quema xijcuaca pantzi tlen quipiya tlasonejcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ama ni tonal inquisaj. ");
INSERT INTO nheBl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Huajca sesen xihuitl ipan ni metztli monequi inquiilnamiquise ni tonal. Huan teipa san se inquichihuase quema TOTECO inmechhuicatos ipan nopa cuali tlali campa itztoque nopa cananeos, heteos, amorreos, heveos huan jebuseos tlen quintencahuili tohuejcapan tatahua para techmacas. Nopa tlali quipiya miyac itlajca hasta mocahua. Nopona nojquiya monequi xiilhuichihuaca ipan ni metztli. ");
INSERT INTO nheBl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Para chicome tonali inquicuase pantzi tlen ax quipiya tlasonejcayotl, huan ipan nopa tlayacapan tonali monequi inilhuichihuase para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Para chicome tonali inquicuase pantzi tlen ax quipiya tlasonejcayotl. Ma ax oncas niyon se tlamantli tlasonejcayotl ipan imochaj. Huan niyon se pantzi ica tlasonejcayotl ax oncas ipan imotlal. ");
INSERT INTO nheBl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Huan teipa ipan nopa tonal inquinilhuise imoconehua para ya ni tijchihuaj pampa TOTECO techchihuili nochi nopa tiochicahualnescayotl quema techquixti ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Huan queja inquitlalisquíaj se tlanextilijcayotl ipan imoma o ipan imocuajtol tlen inmechilnamiquiltisquía se tlenijqui, ya ni inmechilnamiquiltis para monequi inquitoquilise nochi nopa tlanahuatili tlen techmacac TOTECO para nochipa, pampa nelía elqui TOTECO tlen techquixti tlen tlali Egipto ica ihueyi chicahualis. ");
INSERT INTO nheBl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Huan yeca monequi tiilhuichihuase sesen xihuitl ipan ni tonal queja ni tlanahuatili quiijtohua. ");
INSERT INTO nheBl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Huan teipa ajsis nopa tonal quema TOTECO inmechhuicas ipan nopa tlali campa ama itztoque nopa cananeos huan yajaya inmechmactilis nopa cuali tlali queja inmechtencahuili imojuanti huan imohuejcapan tatahua para quichihuas. ");
INSERT INTO nheBl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Huan quema inajsise nopona, nojquiya monequi inquimacase TOTECO nochi oquichpilme tlen achtohui ehuani huan nochi oquich tlapiyalime tlen achtohui tlacatij pampa inijuanti nelía iaxcahua. ");
INSERT INTO nheBl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Huelis inquicohuilise TOTECO iachtohui cone se burra para elis imoaxca intla inquinequij. Para inquicohuilise Toteco, monequi inquimacase TOTECO se pilborregojtzi queja se tlacajcahualistli para inquimanahuise nopa pilburrojtzi. Pero intla ax inquitemactilise se pilborregojtzi queja se tlacajcahualistli para inquipatlase ica nopa pilburrojtzi, huajca monequi inquiquechpostequise nopa pilburrojtzi. Nojquiya monequi inquicohuilise TOTECO imooquichpilhua tlen achtohui ehuani ica se tlacajcahualistli tlen inquitemactilise. ");
INSERT INTO nheBl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Huan teipa quema imoconehua inmechtlajtlanise tlaque quiijtosnequi ni tlamantli tlen tijchihuaj, inquinilhuise para TOTECO techquixti ica hueyi chicahualistli ipan tlali Egipto campa titlatequipanojtoyaj queja techcojtosquíaj para tiiniaxcahua. ");
INSERT INTO nheBl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Huan quema Faraón moyoltetili huan ax techcahuayaya ma tiquisaca, TOTECO quinmicti nopa tlacatl o conetl tlen achtohui tlacatqui ipan sesen familia tlen nopa Egipto ehuani. Huan nojquiya quinmicti nochi inioquich tlapiyalhua tlen achtohui tlacatque. Huan yeca tijmacaj TOTECO nochi oquich tlapiyalime tlen tlacatij achtohui queja se tlacajcahualistli. Nojquiya tijcohuilise TOTECO tooquichpilhua tlen achtohui ehuaj. ");
INSERT INTO nheBl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Huan ni ilhuitl techilnamiquiltía tlen TOTECO queja tijpixtosquíaj se tlajcuiloli ipan toma o ipan tocuajtol para techilnamiquiltisquía se tlenijqui. Techilnamiquiltía para TOTECO techquixti tlen tlali Egipto ica hueyi chicahualistli. Quena, quej nopa inquinilhuise.” ");
INSERT INTO nheBl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Huajca teipa, quena, Faraón quincajqui ma quisaca nopa israelitame, huan quisque Egipto ica tepostli para tlatehuise. Pero Toteco Dios ax quinhuicac ipan ojtli tlen pano ipan inintlal nopa filisteos, yonque eliyaya se ojtli más xitlahuac. Yajaya moilhui: Intla nimantzi monequi tlatehuise, nopa israelitame sampa quinequise mocuepase tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Yeca Toteco Dios quinchijqui nopa israelitame ma temoca huan ma quimacaca se huelta campa hueli ipan nopa huactoc tlali tlen yohui campa nopa Hueyi Atl Chichiltic. Huan nopa israelitame quisque motecpantoque ica miyac pamitl queja soldados huan ica tepostli queja yahuiyayaj para tlatehuitij. ");
INSERT INTO nheBl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Huan Moisés nojquiya quihuicayaya iomiyohua José, pampa José quichijtoya para iixhuihua Israel ma quitestigojquetzaca Toteco para quihuicasquíaj iomiyohua. Quinilhuijtoya: “Melahuac, Toteco Dios teipa hualas inmechpalehuiqui, huan quema ya nopa panos, monequi inquihuicase noomiyohua tlen tlali Egipto.” Huajca yeca quihuicaque. ");
INSERT INTO nheBl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Huan nopa israelitame quistejque ipan Sucot huan yajque hasta Etam campa pehua nopa huactoc tlali, huan nopona quiquetzque ininyoyoncalhua tlen tlaxinepaloli ica iniijhuiyo chivojme. ");
INSERT INTO nheBl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Huan ica tonaya TOTECO itztoya ininhuaya ipan se mixtli tlen quinyacanayaya ipan ojtli huan ica tlayohua quinyacanayaya ica se tlilelemectli tlen quintlatlanextiliyaya. Yeca inijuanti huelque nejnemij tonaya huan tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Huajca mojmostla nopa mixtli tlayacantiyajqui tonaya huan nopa tlilelemectli ica tlayohua huan ax quema quincajtejqui. ");
INSERT INTO nheBl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Xiquinilhui nopa israelitame ma mocuepaca huan ma quiquetzaca ininyoyoncalhua ipan Pi Hahirot, tlatlajco Migdol huan nopa hueyi atl. Nopona mocahuase ateno iixmelac Baal Zefón. ");
INSERT INTO nheBl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Queja Faraón moilhuis para inmomasiltijtoque pampa initztoque tlatlajco huactoc tlali huan hueyi atl huan ax huelis incholose. Moilhuis ax inquimatij canica inyase huan san inmocuapolojtinemij ipan huactoc tlali. Queja nopa moilhuis. ");
INSERT INTO nheBl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Huan nijchihuas Faraón ma moyoltetili huan ma inmechtepotztoca. Huan huajca nijnextis nochicahualis ipan ya ininhuaya isoldados para nopa egiptome ma quimatica na niitztoc niimoTECO.” Huan nopa israelitame quichijque queja TOTECO quiijto. ");
INSERT INTO nheBl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Huajca quema nopa tlanahuatijquetl tlen tlali Egipto quicajqui para israelitame cholojtoyaj, yajaya ininhuaya tlen quipalehuiyayaj moyolcuepque, huan moilhuijque: “¿Para tlen tiquincahuilijque ma yaca nopa israelitame huan ayoc ma techtequipanoca?” ");
INSERT INTO nheBl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Huan nimantzi Faraón tlanahuati para ma quicualtlalica itlatehuijca carro huan quisqui quinyacantiyajqui isoldados. ");
INSERT INTO nheBl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Huan iica hualajque 600 tlatehuijca carros tlen más cuajcualme ihuaya nochi sequinoc tlatehuijca carros tlen Egipto, huan itlayacanca soldados itztoyaj ipan sesen carro. ");
INSERT INTO nheBl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Huan TOTECO quichijqui Faraón ma moyoltetili huan ma quintoquili nopa israelitame yonque inijuanti ya quistoyaj ica hueyi chicahualistli. ");
INSERT INTO nheBl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Huan nopa egiptome ica nochi ininsoldados huan tlatehuijca carros huan cahuayojme quisque quintepotztocaque israelitame, huan quinajsitoj iteno nopa hueyi atl nechca Pi Hahirot huan iixtla Baal Zefón campa quiquetztoyaj ininyoyoncalhua. ");
INSERT INTO nheBl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Huan quema nopa israelitame quiitaque para Faraón ihuaya nopa egiptome monechcahuiyayaj, tlahuel majmajque huan quitlajtlanijque TOTECO ma quinpalehui. ");
INSERT INTO nheBl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Huan nopa israelitame quiilhuijque Moisés: ―¿Para tlen titechhualicatoc nica para ma timiquica ipan ni huactoc tlali? Intla tijnequiyaya titechmictis, oncayaya campa titechtlalpachojtosquía ipan tlali Egipto. ¿Para tlen titechquixti tlen nopona? ");
INSERT INTO nheBl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ipan Egipto timitzilhuijque para san xitechcahua para ma tiquintequipanoca egiptome. Más cuali elisquía noja tiquintequipanosquíaj huan ax timiquise nica ipan huactoc tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Pero Moisés quinnanquili: ―Amo ximajmahuica. San ximoquetzaca huan amo ximolinica huan xiquitaca quejatza TOTECO inmechmaquixtis, pampa nopa egiptome tlen ama inquinitaj ayoc quema inquinitase sampa. ");
INSERT INTO nheBl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Niyon ax monequi intlatehuise, TOTECO tlatehuis topampa. ");
INSERT INTO nheBl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Huajca TOTECO quiilhui Moisés: ―¿Para tlen san innechtlajtlaníaj tlapalehuili? ¡Xiquinnahuati nopa israelitame ma quiitzquica iniojhui! ");
INSERT INTO nheBl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Huan ta xijtlalana mocuatopil huan xijxitlahua moma para tijtlajcoitas nopa hueyi atl ica ome, huan huajca nopa israelitame huelis apanose ipan se ojtli huactoc. ");
INSERT INTO nheBl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Huan na nijchihuas nopa egiptome ma moyoltetilica huan ma inmechtoquilica ipan hueyi atl. Huan huajca nijnextis nochicahualis iixtla Faraón, huan isoldados, huan inintlatehuijca carros, huan inijuanti tlen yohuij cahuajtipa. ");
INSERT INTO nheBl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Huan quema ya nijnextijtos nochicahualis ipan Faraón, huan itlatehuijca carros, huan ipan inijuanti tlen yohuij cahuajtipa, nopa egiptome quimatise para na niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Huan ielhuicac ejca Toteco Dios tlen itztoya ininhuaya ipan nopa mixtli tlen nejnemiyaya iniixpa, mopatlac campa itztoya huan motlali iniica. ");
INSERT INTO nheBl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Huan yeca nopa mixtli mocajqui tlatlajco nopa soldados tlen Egipto huan nopa israelitame. Huan iica nopa mixtli nesiyaya yayahuic iniixpa nopa egiptome, pero iixtla nopa mixtli quintlahuiliyaya nopa israelitame. Huajca yeca nopa egiptome ax huelque quinajsij nopa israelitame nochi nopa tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Huan Moisés quixitlajqui ima ipan nopa hueyi atl, huan TOTECO quititlanqui se ajacatl chicahuac tlen hualajqui campa quisa tonati huan tlaajacac nochi tlayohua huan quitlajcoitac nopa hueyi atl. Huajca queja nopa TOTECO quicuepqui nopa hueyi atl ica huactoc tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Huan nesqui ipan hueyi atl se huactoc ojtli huan ipan nopa ojtli nopa israelitame panoque tlatlajco campa motlapojtoya huan moquetztoya nopa atl tlahuel huejcapa queja eliyaya ome tepamitl, se ipan ininnejmatl huan seyoc ipan iniarraves. ");
INSERT INTO nheBl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Huan teipa nopa tlali Egipto ehuani quintoquilijque. Quena, nochi nopa cahuayos ica icarros Faraón huan inijuanti tlen yahuiyayaj ipan cahuayos calajque inintepotzco huan quintoquilijtiyajque hasta tlajco nopa hueyi atl. ");
INSERT INTO nheBl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Huan tlajco yohual, TOTECO tlen itztoya ipan nopa hueyi mixtli huan ipan nopa tlilelemectli quinitac nopa soldados egiptome huan quinhuihuichijqui para ma ax quimatica tlaque quichihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Huan quinquixtili nopa tepos llantas ipan inincarros para ma ayoc huelica quinhuicase inincarrojhua. Huajca nopa egiptome quiijtojque: ―Ma timochololtica tlen ni israelitame, pampa DIOS, ininTECO techtehuía huan quinmanahuía. ");
INSERT INTO nheBl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Huan teipa quema nopa israelitame ajsitoj seyoc nali, TOTECO quiilhui Moisés: ―Xijxitlahua moma ipan nopa hueyi atl para nopa atl ma mosentili huan ma quinatzonpolihuilti nopa egiptome ipan inintlatehuijca carros ininhuaya tlen tlejcotoque ipan cahuayojme. ");
INSERT INTO nheBl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Huan Moisés quixitlajqui ima ipan nopa hueyi atl, huan quema tlanestihualayaya, nopa atl mocuepqui campa ipa eltoya. Huan quema nopa egiptome quinejque cholose, nopa hueyi atl quinhuicac, huan queja nopa TOTECO quinisahui. ");
INSERT INTO nheBl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Huan quema nopa atl mocuepqui campa ipa eltoya, quinatzonpolihuilti nochi nopa soldados, carros huan cahuayojme tlen calactoyaj ipan hueyi atl para quintoquilise israelitame. Niyon se tlen isoldados Faraón mocajqui yoltoc. ");
INSERT INTO nheBl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pero nopa israelitame ya quiixcotontoyaj nopa hueyi atl ipan se ojtli huactoc tlatlajco campa moquetztoya nopa atl queja ipan ome tepamitl tlen atl, se ipan ininnejmatl huan se ipan iniarraves. ");
INSERT INTO nheBl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Huajca nopa tonal TOTECO quinmaquixti nopa israelitame tlen nopa egiptome huan nopa israelitame quiitaque inintlacayohua nopa egiptome iteno nopa hueyi atl. ");
INSERT INTO nheBl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Huan quema nopa israelitame quiitaque nopa hueyi chicahualistli tlen TOTECO quinextijtoya ica nopa egiptome, quihueyitlepanitaque, huan motemachijque ipan ya huan ipan itlatequipanojca Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Huajca Moisés ininhuaya nopa israelitame huicaque ni huicatl para TOTECO: “Nihuicas para TOTECO pampa tlatlanqui ica ihueyi chicahualis. Quinisahui ipan hueyi atl nopa cahuayojme ininhuaya tlen ininpan tlejcotoyaj. ");
INSERT INTO nheBl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","TOTECO nechchijtoc ma nihuica ica paquilistli. Yajaya Notemaquixtijca tlen nechfuerzajmaca. Yajaya Dios noTeco tlen nijtlepanita, huan nijpaquilismacas. Yajaya nopa Dios tlen notata quihueyichijqui, huan nijhueyitlalis. ");
INSERT INTO nheBl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","TOTECO ya nopa tlatehuijquetl tlen más quipiya chicahualistli. Quena, TOTECO, ya nopa itoca. ");
INSERT INTO nheBl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Quinisahui ipan hueyi atl nopa tlatehuijca carros, ininhuaya isoldados Faraón. Nopa soldados tlen más cuajcualme ipan nochi tlali Egipto, misahuijque ipan hueyi atl tlen itoca Chichiltic. ");
INSERT INTO nheBl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Huetzque hasta atzintla queja tetini. Huan nopa atl tlen huejcatla quinatzonpolihuilti. ");
INSERT INTO nheBl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","¡Ay, TOTECO! Tijpiya hueyi chicahualistli, huan tiquintlamilti tocualancaitacahua. ");
INSERT INTO nheBl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Huan ica mohueyi chicahualis tiquinpolo tlen motlalijque moixtla. Tlejcoc mocualancayo queja se hueyi tlitl, huan quinpolihuilti. Inijuanti tlami tlatlaque queja sacatl. ");
INSERT INTO nheBl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Chicahuac tiquilpitzqui nopa hueyi atl, huan nopa atl motlajcoitac. Nopa hueyi atl motlalanqui huan moquetzqui oncac, queja moquetzaj ome huejcapantique tepamitl. Nopa hueyi atl tlen huejcatla motetictlali. ");
INSERT INTO nheBl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Tocualancaitacahua mohueyimatque huan quiijtojque: ‘Tiquintoquilise hasta tiquinajsitij, huan tiquinquixtilise nochi tlen quipiyaj, huan timochihuase tiricos ica tlen iniaxca. Teipa tijquixtise tomachete huan tiquintzontlamiltise ica toma.’ Queja nopa moilhuijque. ");
INSERT INTO nheBl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pero ta, TOTECO, titlailpitzqui, huan nopa hueyi atl quintolo. Misahuijque queja tepostli ipan atl tlen huejcatla. ");
INSERT INTO nheBl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","¡Ay TOTECO! Axaca seyoc Dios tlen ica huelis timitzhuicalotise. Axaca tlatzejtzeloltic queja ta. Axaca quipiya mohueyi chicahualis. Tlen ta tijchihua temajmatía. Huajca quinamiqui para timitzhueyichihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Titenextili mochicahualis, huan quintolo nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ica moteicnelijcayo titechyacanas tojuanti timotlacajhua tlen titechmaquixtijtoc. Ica mochicahualis titechhuicas hasta mochaj tlen tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Nochi tlacame ipan nochi tlaltini huihuipicase quema quimatise tlen tijchijtoc. Nopa filisteos majmahuise pampa quinitzquis majmajtli. ");
INSERT INTO nheBl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Huan nopa tlayacanani tlen soldados ipan tlali Edom, niyon ax huelis tlaijiyotilanase. Nopa tlanahuatiani tlen tlali Moab huihuipicase ica majmajtli. Huan ayoc quipiyase chicahualistli inijuanti tlen mooquichmatiyayaj ipan tlali Canaán. ");
INSERT INTO nheBl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Hueyi majmajtli quinajsis. Quena, quinamiqui ma majmahuica. Tocualancaitacahua ayoc techtehuise, san majmahuise ica mohueyi chicahualis, TOTECO, huan mocahuase queja tetini. Tojuanti tlen titechcojtoc para timoaxcahua tijpanoque nopa atl ica temachili. Inijuanti ax tleno huelqui techchihuilise pampa ta titechmanahuijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","¡Ay TOTECO! Xitechhuica para tiitztotij ipan motepe tlen tlatzejtzeloltic. Xitechyacana hasta nopa tlali campa tijtlapejpeni para tiitztose, nopona ipan mochaj tlen ta tijchijchijqui. ");
INSERT INTO nheBl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","TOTECO, titlanahuatis para nochipa.” ");
INSERT INTO nheBl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Quema itlatehuijca carros Faraón huan icahuayojhua huan tlen ipan tlejcotoyaj calajque ipan hueyi atl, TOTECO quichijqui nopa hueyi atl ma quinhuica. Pero nopa israelitame quiixcotonque nopa hueyi atl ipan se ojtli huactoc. ");
INSERT INTO nheBl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Huajca nopa sihua tiocamanalojquetl María, ihuelti Aarón, quicuic se tepos tlatzilintli, huan nochi israelita sihuame quitoquilijque quitzilinijtiyahuiyayaj tepos tlatzilintli, huan huicayayaj huan mijtotiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Huan María huicayaya huan quinnanquiliyaya ica ni tlajtoli: “Xihuicaca para TOTECO, pampa tlatlanqui ica ihueyi chicahualis. Quinisahui ipan hueyi atl nopa cahuayojme, huan inijuanti tlen ipan tlejcotoyaj.” ");
INSERT INTO nheBl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Huan Moisés quinyacanqui nopa israelitame huan quistejque tlen nopa Hueyi Atl Chichiltic, huan yajque ipan nopa huactoc tlali itoca Shur. Huan nejnenque para eyi tonali pero ax quipantiyayaj atl. ");
INSERT INTO nheBl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Huan quema quiajsique se ameli itoca Mara, ax huelque quiique nopa atl tlen oncayaya nopona pampa eliyaya chichic. Yeca nopa ameli quitocajtijque Mara tlen quinequi quiijtos “chichic”. ");
INSERT INTO nheBl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Huan nopa israelitame pejque cualancacamatij ica Moisés huan quiijtohuayayaj: “¿Tlaque huelis tiquise?” ");
INSERT INTO nheBl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Huajca Moisés quitlajtlani TOTECO itlapalehuil para quimatis tlaque quichihuas, huan TOTECO quinextili se cuamacuayotl. Huan Moisés quimajcajqui nopa cuahuitl ipan atl, huan nopa atl mocuepqui se cuali atl. Huajca nopona TOTECO quincamahui israelitame para quinyejyecos intla quitoquilisquíaj huan ya ni tlen quintencahuili. ");
INSERT INTO nheBl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Quinilhui: “Intla inquitlacaquilise tlen niimoTECO Dios nimechilhuía, huan inquichihuase tlen xitlahuac noixtla huan inquineltocase notlanahuatil, ax nimechtitlanilis niyon se cocolistli tlen nijtitlanqui ipan nopa egiptome pampa na niimoTECO Tlen Nimechchicahua.” ");
INSERT INTO nheBl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Huan teipa nopa israelitame ajsitoj Elim campa oncayaya majtlactli huan ome ameli huan 70 apach cuatini, huan nopona nechca atl quiquetzque ininyoyoncalhua. ");
INSERT INTO nheBl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Huan nochi israelitame quisque Elim huan ajsique ipan nopa huactoc tlali tlen itoca Sin tlen mocahua tlatlajco Elim huan Sinaí. Huan ajsitoj nopona ipan 15 itequi nopa ompa metztli ipan ininxihui. ");
INSERT INTO nheBl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Huan nopona ipan nopa huactoc tlali, nochi pejque quintlaijilhuíaj Moisés huan Aarón. ");
INSERT INTO nheBl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Huan nopa tlacame quinilhuiyayaj: ―Más cuali eltosquía intla TOTECO techcahuilijtosquía ma timiquica ipan tlali Egipto. Nepa timosehuiyayaj nechca nopa chachapali tlen temitoya ica nacatl huan titlacuayayaj hasta tiixhuiyayaj, pero ama intechhualicatoque ipan ni huactoc tlali para intechapismictise. ");
INSERT INTO nheBl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Huajca TOTECO quiilhui Moisés: ―Nijchihuas para tlacualistli ma huetzi tlen elhuicac queja quema tlaahuetzi. Huan mojmostla nopa israelitame monequi quisentilitij san tlen quitequihuise ipan nopa tonal. Nijnequi niquitas ajqueya quineltocas tlen niquilhuis huan ajqueya, axtle. ");
INSERT INTO nheBl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Huan sesen samano ipan nopa chicuasempa tonal quema quisentilise imiyaca tlen quihuicase ininchaj, ma quisentilica tlen monequi para ome tonali. ");
INSERT INTO nheBl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Huan Moisés huan Aarón quinilhuijque nopa israelitame: ―Ica tiotlac inquimatise para yajaya TOTECO tlen inmechquixti ipan tlali Egipto, ");
INSERT INTO nheBl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","huan ica ijnaloc inquiitase itlatlanex, pampa quicajqui para inquitlaijilhuiyayaj. Pampa ax na huan Aarón tlen intechtlaijilhuíaj, ¿tiajqueyame? Tojuanti ax titlanahuatíaj. ");
INSERT INTO nheBl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Huan Moisés quiijto: ―Ica tiotlac TOTECO inmechmacas nacatl para intlacuase, huan ica ijnaloc inmechmacas pantzi hasta mocahuas, pampa quicactoc para imojuanti inquitlaijilhuijque. Ax tojuanti tlen intechtlaijilhuijtoque. Tojuanti ax tleno topati. Pero quena, inquitlaijilhuijque TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Huan teipa Moisés quiilhui Aarón ma quinilhui nochi israelitame: ―Ximonechcahuica iixtla TOTECO pampa ya quicactoc tlen ica inquitlaijilhuijque. ");
INSERT INTO nheBl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Huan ipan nopa tlalochtli quema Aarón quincamahuiyaya nopa israelitame, nochi tlachixque ica campa nopa huactoc tlali, huan itlatlanex TOTECO monexti ipan se mixtli. ");
INSERT INTO nheBl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","―Nijcactoc queja noca camatij huan nechtlaijilhuíaj ni israelitame. ‘Xiquinilhui para quema tiotlaquiyas, quicuase nacatl, huan ica ijnaloc quicuase pantzi hasta ixhuise. Queja nopa quimatise para na niDIOS, niininTECO.’ ");
INSERT INTO nheBl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Huan nopa tiotlac hualajque miyac totome tlen inintoca codornices, huan quitemitijque campa nopa israelitame itztoyaj. Huan ica ijnaloc huetztoya ajhuechtli huan quinyahualojtoya campa mocahuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Huan teipa quema nopa ajhuechtli ya pojquejtoya, mocajqui ipan nopa tlali se tlamantli chipahuac queja ichcatl. ");
INSERT INTO nheBl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Huan nopa israelitame ax quimatiyayaj tlaque eliyaya, huajca quema quiitaque moilhuiyayaj se ica seyoc: “¿Huan ya ni tlaque?” Huan Moisés quinilhui: ―Ya ni nopa pantzi tlen TOTECO inmechmacatoc para imotlacualis. ");
INSERT INTO nheBl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Huan ya ni nochi nopa tlanahuatili tlen techmacatoc TOTECO: Xijsentilica sesen imojuanti tlen monequi para quicuase tlen itztoque ipan imochaj. Xijcuica queja ome litros para sesen tlacatl ipan imofamilia ma quicuas. ");
INSERT INTO nheBl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Huan nopa israelitame quichijque queja quinilhuijtoya. Huan sequin miyac quisentilijque huan sequinoc ax más. ");
INSERT INTO nheBl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Huan quiyejyecojque ica se tlayejyecoli itoca gomer tlen quicui nechca ome litros. Huan ax mocajqui tlen quisentilijtoya miyac, niyon ax quipolo tlen quisentilijtoya quentzi. Sesen inijuanti quipixqui san tlen monequiyaya para quicuase ichampoyohua. ");
INSERT INTO nheBl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Huan teipa Moisés quinilhui: ―Axaca ma quicahua niyon se quentzi ni tlacualistli para hualmostla. ");
INSERT INTO nheBl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pero sequin ax quichihuilijque cuenta Moisés huan quiajcojque nopa tlacualistli para ne seyoc tonal. Huan hualmostla quipantijque ocuilojtoya huan mijmiyotiyaya. Huajca Moisés cualanqui ininhuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Huajca sesen israelita quisentiliyaya ica ijnaloc tlen monequiyaya para quicuase, huan tlajcotona quema tlatotoniyayaya atiyayaya tlen mocahuayaya tlalchi. ");
INSERT INTO nheBl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Pero ipan chicuasempa tonal quisentiliyayaj tlen quicuasquíaj para ome tonali, quiijtosnequi se nahui litro para sesen tlacatl. Huan nopa israelita tlayacanani yajque quipohuilitoj Moisés tlen quichihuayayaj, ");
INSERT INTO nheBl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","huan Moisés quinilhui: ―¡Cuali! Ya nopa tlen TOTECO tlanahuatijtoc pampa mostla elis nopa tonal para ma ax titequitica. Timosehuise pampa se tonal tlatzejtzeloltic. Nopa tonal tlaiyocatlalili san para TOTECO huan ax titequitise. Huajca xijmolonaltica tlen inquinequij huan xiquicxitica tlen inquinequij ama huan xijtequihuica tlen monequi ama, pero xicajcocuica tlen mocahuas para mostla. ");
INSERT INTO nheBl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Huan queja tlanahuati Moisés, quiajcojque tlacualistli para hualmostla, tlen elis nopa chicompa tonal. Huan hualmostla noja elqui cuali. Ax potehui, niyon ax quinpixqui ocuilime. ");
INSERT INTO nheBl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Huajca ipan sábado Moisés quiijto: ―Ama xijcuaca tlen mocahua pampa ama ni tonal para timosiyajcahuase ica TOTECO huan ax inquipantise tlacualistli. ");
INSERT INTO nheBl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mojmostla para chicuasen tonali huelis inquisentilise, pero ipan nopa chicompa tonal, san ximosehuica huan ax tleno oncas calteno para inquisentilise. ");
INSERT INTO nheBl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pero sequin tlacame quisque ipan nopa chicompa tonal para quisentilise, pero ax tleno quipantijque. ");
INSERT INTO nheBl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Huajca TOTECO quiilhui Moisés: ―¿Hasta quema inquineltocase tlen nimechnahuatía huan tlen nimechmachtía? ");
INSERT INTO nheBl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Xiquitaca para na, niimoTECO, nimechmacatoc ni tonal para ximosehuica. Yeca ipan nopa chicuasempa tonal nimechmacas tlacualistli para ome tonali. Huan ipan nopa chicompa tonal nochi monequi mocahuase ipan ininchajchaj huan ma amo quisaca. ");
INSERT INTO nheBl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Huajca nopa israelitame mosiyajcajque ipan nopa chicompa tonal. ");
INSERT INTO nheBl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Huan quitocajtijque “maná” nopa chipahuac pantzi tlen quisentiliyayaj. (Maná quinequi quiijtos: ¿Tlaque Ya Ni?) Eliyaya chipahuac queja colanto iyol, huan iajhuiyaca elqui queja pantzi tlen quichijtoque ica nectli. ");
INSERT INTO nheBl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Huan Moisés quiijto: ―TOTECO nechmacatoc tlanahuatili ma tijtemitica ome litros ica maná huan ticajcocuise para toixhuihua tlen teipa tlacajtiyase ma quiitaca nopa tlacualistli tlen TOTECO techmacac ipan ni huactoc tlali quema techquixti ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Huajca Moisés quiilhui Aarón para ma quicui se chiquihuitl huan ma quitema nopona ome litros tlen maná. Huan quiilhui para teipa ma quitlali iixtla TOTECO huan ma quiajcocui para iniixhuihua quiitase. ");
INSERT INTO nheBl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Huajca Aarón quichijqui tlen TOTECO quinahuati Moisés huan teipa quitlali nopa chiquihuitl ipan icaxa TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Huan nopa israelitame quicuajque maná para 40 xihuitl hasta ajsitoj ipan tlali Canaán campa sequinoc tlatoctoyaj huan oncayaya tlen quicuase. ");
INSERT INTO nheBl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Huan inijuanti quitequihuijque se tlayejyecoli itoca gomer tlen elqui queja ome litros. Huan monequiyaya majtlactli gomer para elis se tlayejyecoli tlen itoca efa tlen quicui queja 20 litros. ");
INSERT INTO nheBl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Huan nochi nopa miyac israelitame quisque tlen tlali Sin huan yajque ica yolic queja TOTECO quinnahuatiyaya. Huan nejnentiyajque huan quiijcuenijtiyajque ininyoyoncalhua mojmostla hasta ajsitoj campa itoca Refidim. Pero nopona ax oncayaya atl para atlise, ");
INSERT INTO nheBl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","huajca cualanque ica Moisés huan quiilhuijque: ―¡Xitechmaca atl para tiatlise! Huan Moisés quinnanquili: ―¿Para tlen incualanij noca na? San inquicualancamacaj huan inquiyejyecohuaj TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Pero nochi inijuanti amiquiyayaj huan quitlaijilhuiyayaj Moisés, huan quiilhuijque: ―¿Para tlen titechchihuili ma tiquisaca ipan tlali Egipto? ¿Para tlen titechhualicac nica? San titechamictis ica toconehua huan totlapiyalhua. ");
INSERT INTO nheBl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Huajca Moisés quinojnotzqui TOTECO huan quiilhui: ―¿Tlaque nijchihuas ica ni tlacame? ¡San se quentzi más huan nechtepachose! ");
INSERT INTO nheBl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Huan TOTECO quinanquili: ―Xijhuica nopa cuatopili tlen ica tijmaquili nopa atemitl Nilo. Huan xiya huan ximotlali iniixtla ni tlacame para titlayacanas. Huan xiquinhuica mohuaya sequin nopa huehue tlacame tlen quihuicaj tequitl ica israelitame, huan xiya. ");
INSERT INTO nheBl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Huan na nimitzchixtos campa nopa tetl nechca tepetl Horeb. Huan xijmaquili nopa tetl huan nopona quisas atl para ma atlica nochi ni israelitame. Huajca Moisés queja nopa quichijqui iniixpa nopa huehue tlacame tlen nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Huan quitocajti nopa lugar Masah. (Masah quinequi quiijtos Campa Quiyejyecojque TOTECO Para Ma Quinmicti.) Huan nojquiya quitocajti Meriba. (Meriba quinequi quiijtos Tlanajnanquilistli.) Queja nopa quitocajti pampa nopona nopa israelitame tlanajnanquilijque huan quiyejyecojque TOTECO huan quiijtojque: “¿Itztoc TOTECO tohuaya o axaca?” ");
INSERT INTO nheBl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Huan hualajque nopa amalecitame huan pejque quintehuíaj nopa israelitame ipan Refidim. ");
INSERT INTO nheBl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Huan Moisés quiilhui Josué: ―Xiquintlapejpeni tlacame huan xiquintehuitij nopa amalecitame. Huan mostla na nimoquetzas tlachiquiltipa ica icuatopil Toteco nomaco. ");
INSERT INTO nheBl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Huan Josué huan nopa tlacame quichijque tlen Moisés quinnahuati, huan quintehuitoj nopa amalecitame. Huajca Moisés, Aarón huan Hur tlejcoque tlachiquiltipa para quintlachilise. ");
INSERT INTO nheBl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Huan quema Moisés quitlalanayaya ima, nopa israelitame tlatlaniyayaj, pero quema quitemohuiyaya ima, nopa amalecitame tlatlaniyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Huan teipa Moisés macuatic. Huajca quicuique se tetl para ipan mosehuis huan Aarón ihuaya Hur quimatlanantoyaj. Se moquetzqui ica inejmatl huan se ica iarraves. Huajca san queja nopa Moisés huelqui quiijiyohui ica ima huejcapa hasta quema calajqui tonati. ");
INSERT INTO nheBl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Huan yeca Josué quintlamimicti nopa amalecita soldados ica imachete. ");
INSERT INTO nheBl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Huan TOTECO quiilhui Moisés: ―Xiquijcuilo ni tlajtoli ipan se amatl tlen huejcahuas para ma quiilnamiquica nopa israelitame para nochipa, huan nojquiya xijyolmelahua Josué tlen ya ni. Na niquintlamiltis nochi nopa amalecitame ipan ni tlaltepactli huan axaca quinilnamiquis. ");
INSERT INTO nheBl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Huan Moisés quichijqui se tlaixpamitl tlen quitocajti: “TOTECO Itztoc Queja Se Bandera Tlen Techyacana.” ");
INSERT INTO nheBl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Huan Moisés quiijto: “Queja se bandera tomaco, Toteco techyacana ma titlatlanica. Pampa nopa amalecita tlacame motlalantoque iixtla TOTECO, yajaya quintehuis para nochipa.” ");
INSERT INTO nheBl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Huan Jetro, nopa totajtzi tlen tlali Madián tlen elqui imontat Moisés, quicajqui quejatza TOTECO quinquixtijtoya nopa israelitame tlen tlali Egipto. Nojquiya quicajqui nochi nopa yejyectzi tlamantli tlen quinchihuilijtoya Moisés huan itlacajhua. ");
INSERT INTO nheBl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Moisés quititlantoya isihua, Séfora, ma yohui ichaj quema quinmanahuiyaya nopa israelitame. Huan Jetro imontat Moisés sampa quiselijtoya iichpoca ininhuaya iome conehua. Se tlen nopa coneme itoca eliyaya Gersón. (Gersón quinequi quiijtos Sejcoyoc Ejquetl.) Queja nopa Moisés quitocajti pampa quiijtojtoya: “Nielqui nise sejcoyoc ejquetl ipan se tlali tlen ax niquixmati”. ");
INSERT INTO nheBl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Huan nopa seyoc icone itoca eliyaya Eliezer. (Eliezer quinequi quiijtos Toteco Dios Yajaya Notlapalehuijca.) Queja nopa quitocajti pampa quiijtojtoya: “Toteco Dios tlen notata quitoquili hualajqui nechpalehuico huan nechmaquixti tlen imachete Faraón.” ");
INSERT INTO nheBl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Huajca se tonal quema nopa israelitame ya ajsitoyaj ipan huactoc tlali, Jetro quincuitejqui isihua huan iconehua Moisés huan yajque campa Moisés quiquetztoya ichaj tlen yoyomitl nechca itepe Toteco. ");
INSERT INTO nheBl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Huan Jetro tlatitlanqui ma quiyolmelahuati Moisés para ajsiyayaj. Quiilhui: ―Na niJetro, momontat. Nihualajtoc nimitzitaqui huan niquinhualica mosihua huan moconehua. ");
INSERT INTO nheBl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Huan Moisés quisqui quiselito imontat, huan quitlajpalo ica yejyectzi huan quitzoponi. Huan teipa quema motlajpalojque, calajque ipan se cali tlen yoyomitl. ");
INSERT INTO nheBl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Huan nopona Moisés quipohuili imontat nochi tlen TOTECO quinchihuilijtoya Faraón huan nopa egiptome pampa quinicneli nopa israelitame. Huan quipohuili nochi tlamantli tlen ininpantijtoya ipan ojtli huan quejatza TOTECO quinmaquixtijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Huan Jetro pajqui quema quicajqui quejatza TOTECO quinpalehuijtoya nopa israelitame huan quinmaquixtijtoya tlen nopa egiptome. ");
INSERT INTO nheBl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Huan Jetro quiijto: ―Ma tijhueyichihuaca TOTECO tlen inmechmanahuijtoc ininmaco Faraón huan nochi egiptome, huan nochi tlen fiero inijuanti inmechchihuiliyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ama nijmachilía para TOTECO, yajaya más hueyi tlen nochi sequinoc tlen quintocajtlalíaj dioses, pampa inmechmanahuijtoc ininmaco tlacame tlen mohueyimatiyayaj huan tlen fiero inmechchihuiliyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Teipa Jetro quimacac Toteco sequin tlacajcahualistli huan quitlati se tlapiyali iixtla. Huan Aarón ihuaya nochi nopa huehue tlacame tlen nopa israelitame yajque tlacuatoj ihuaya imontat Moisés iixtla Toteco Dios. ");
INSERT INTO nheBl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Hualmostla Moisés mosehui queja juez para quintlacaquilis nopa israelitame tlen moteilhuiyayaj se ica seyoc. Huan nochi nopa tonal miyac tlacame ijcatoyaj iixtla hasta nochi cuatiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Huajca quema Jetro imontat Moisés quiitac nochi nopa tequitl tlen Moisés iselti quichihuayaya iniixpa nopa israelitame, quiilhui: ―¿Tlaque tiquinchihuilía ni tlacame? Ax cuali para san ta timosehuía para titetlajtolsencahuas huan nochi inijuanti se tonal moquetztoque. ");
INSERT INTO nheBl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Huan Moisés quinanquili imontat: ―Nochi hualahuij nechitaquij para ma nijtlajtlani Toteco Dios tlaque ipaquilis. ");
INSERT INTO nheBl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Huan quema mocualaníaj se ica seyoc, hualahuij nechitaquij para ma niquinilhui ajqueya quichijtoc tlen melahuac. Huajca na niquinilhuía tlaque quiijtohua Toteco Dios huan tlaque itlamachtil. ");
INSERT INTO nheBl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Huajca Jetro, imontat Moisés, quiilhui: ―Ax cuali tlen tijchihua. ");
INSERT INTO nheBl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tisiyajcamiquis huan nojquiya tlaxicose nochi nopa tlacame tlen hualahuij campa ta. Ni tequitl nel tetic para ta. Moselti ax huelis tijtlamichihuas. ");
INSERT INTO nheBl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Huajca ama xijcaqui huan nimitzilhuis tlen monequi tijchihuas huan Toteco mitztiochihuas. Ta motequi timonextis iixtla Toteco ipampa nochi ni tlacame huan xijtlali iixtla nopa tlamantli tlen quincuesohua. ");
INSERT INTO nheBl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Nojquiya monequi xiquinmachti itlanahuatilhua huan tlen yajaya quiijtohua huan xiquinilhui quejatza monequi itztose huan tlaque monequi quichihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Nojquiya monequi xiquintlapejpeni tlen nochi nopa tlacame sequin tlayacanca tlacame tlen temachme huan tlen quitlepanitaj Toteco Dios. Xiquintlapejpeni tlen ax istlacatij huan tlen ax quinequij tlen seyoc iaxca. Xiquintlali sequin nopa tlayacanca tlacame ma quipiyaca tlanahuatili ica mil tlacame. Huan tlatzintla sese inijuanti, xiquintlali 10 tlacame tlen quipiyase tlanahuatili ica san 100 tlacame. Huan tlatzintla sesen nopa 100 tlacame, xiquintlali 2 tlacame tlen quipiyase tlanahuatili ica san 50 tlacame. Huan tlatzintla sesen nopa 50 tlacame, xiquintlali 5 tlacame tlen san quipiyase tlanahuatili ica 10 tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Huan inijuanti quisencahuase tlen quincuesos ni tlacame ipan tlen hueli tlalochtli. Huan san nopa tlamantli tlen más huejhueyi mitzhualiquilise huan inijuanti quisencahuase nochi tlamantli tlen ax ohui. Queja nopa ax elis tlahuel ohui nopa tequitl pampa inquichihuase san sejco. ");
INSERT INTO nheBl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Intla Toteco mitznahuatis para tinechtlacaquilis, huajca huelis tiquijiyohuis motequi, huan nochi nopa tlacame paquise. ");
INSERT INTO nheBl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Huajca Moisés quitlacaquili imontat huan quichijqui nochi tlen quiilhuijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Quintlapejpeni tlayacanca tlacame tlen más temachme ipan nopa israelitame huan quinmacac sequin inijuanti tlanahuatili ica sesen mil tlacame. Huan tlatzintla tlen sesen nopa tlayacanani, quinmacac 10 tlacame tlanahuatili ica 100 tlacame. Huan tlatzintla sesen nopa tlacame, quinmacac 2 tlacame tlanahuatili ica 50 tlacame. Huan tlatzintla sesen inijuanti, quinmacac 5 tlacame tlanahuatili ica 10 tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Huan inijuanti quintlajtolsencahuayayaj tlacame ipan tlen hueli hora. Huan san nopa tlamantli tlen huejhueyi quihuiquiliyayaj Moisés, pero nochi tlajtoli tlen ax más ohui quisencahuayayaj inijuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Huan teipa Moisés quinahuatijtejqui imontat, Jetro, huan yajaya mocuepqui itlal. ");
INSERT INTO nheBl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ipan nopa tonal quema quiaxitijque eyi metztli para quistoyaj nopa israelitame tlen tlali Egipto, inijuanti ajsitoj ipan nopa huactoc tlali nechca tepetl Sinaí. ");
INSERT INTO nheBl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Huan teipa quistejque ipan Refidim huan ajsitoj campa tepetl Sinaí huan nopona quiquetzque ininyoyoncalhua iixtla nopa tepetl ipan nopa huactoc tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Huan nopona Moisés tlejcoc ipan nopa tepetl para mopantis ihuaya Toteco Dios. Huan TOTECO quinojnotzqui Moisés tlen nopa tepetl huan quiilhui ma quinilhui nopa israelitame 19:3 Iixhuihua Jacob. ni tlajtoli: ");
INSERT INTO nheBl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","―Imojuanti ya inquiitztoque tlen nijchijqui ica nopa egiptome. Inquimatij nimechmocuitlahuijtoc. Quena, queja se hueyi cuajtli quinhuica iconehua ipan ieltlapal para ax tleno huelis quinajsis, queja nopa nimechhualicatoc campa na. ");
INSERT INTO nheBl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Huajca ama intla inquicaquise tlen nimechilhuijtoc huan inquichihuase nopa tlajtoli tlen nijpiya imohuaya, huajca inelise innotlapejpenilhua tlen nochi tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Huan inelise se altepetl ica seyoc xinachtli tlacame tlen iyoca tlen nochi sequinoc. Nochi initztose totajtzitzi huan tlatzejtzeloltique noixtla. Queja nopa TOTECO quiilhui Moisés ma quinilhui nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Huajca Moisés yajqui huan quinnotzato nopa huehue tlacame tlen quipiyayayaj tlanahuatili ica nopa israelitame huan quinilhui nochi tlen TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Huajca nochi nopa israelitame tlananquilijque san se: ―Nochi tlen TOTECO tlanahuatijtoc, tijchihuase. Huajca Moisés yajqui quiilhuito TOTECO tlaque nopa israelitame tlananquilijtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Huan TOTECO quiilhui: ―Xiquita, naja nimonextis imoixtla ipan se mixtli tlen tilahuac para nopa tlacame ma nechcaquica quema nimitzcamahuis. Queja nopa motemachise mopan ta para nochipa. Huan Moisés quiilhui TOTECO tlaque quinanquilijtoyaj nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Huan TOTECO quiijto: ―Xiya xiquincualtlaliti nopa tlacame ama huan mostla, huan xiquintlapajpacchihua huan xiquiniyocacahua senquistoc para na. Monequi quichicuenise ininyoyo, ");
INSERT INTO nheBl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","huan ma mocualtlalise para huiptla, pampa huiptla nitemos na niimoTECO, huan niitztos ipan tepetl Sinaí iniixpa nochi nopa tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Huajca xijchihua se nepamitl tlen quiyahualos nopa tepetl huan xiquinnahuati nopa tlacame ma amo quipanoca. Huan xiquinilhui ma motlachilica ma ax tlejcoca, niyon ma ax ajsica campa nopa nepamitl, pampa tlen quiajsis nopa tepetl o nopa nepamitl temachtli monequi inquimictise. ");
INSERT INTO nheBl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Huan axaca huelis quitlalis ima ipan nopa tlacatl o nopa tlapiyali tlen monequi miquis. Monequi inquimictise ica tetl o ica cuatlamintli, yonque se tlacatl o se tlapiyali, pero ax huelis inquicahuase ma itzto. Tlacame san huelise monechcahuise itzintla nopa tepetl quema quicaquise quipitzaj icuacua se oquich borrego. ");
INSERT INTO nheBl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Huajca Moisés temoc tlen nopa tepetl huan quincualtlali nopa tlacame para quihueyichihuase Toteco. Huan nochi quichicuenijque ininyoyo. ");
INSERT INTO nheBl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Huan Moisés quinilhui: ―Monequi inmocualtlalise para huiptla. Huan tlacame huan sihuame ma amo motecaca san sejco ipan ni tonal. ");
INSERT INTO nheBl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Huan ihuiptlaca quema tlanesqui, pejqui tlatomoni huan tlapetlani, huan se mixtli tlen nelía tilahuac motlali ipan nopa tepetl. Huan quicajque se tlapitzali tlen nelía chicahuac hasta nochi nopa israelitame pejque huihuipicaj. ");
INSERT INTO nheBl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Huan Moisés quinyacanqui nochi nopa israelitame, huan inijuanti quisque campa quiquetztoyaj ininchajchaj para mopantise ihuaya Toteco Dios. Huan moquetzatoj itzintla nopa tepetl. ");
INSERT INTO nheBl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Huan nochi nopa tepetl Sinaí popocayaya pampa TOTECO temotoya ipan se tlitl ipani. Nopa poctli tlejcoyaya queja campa tlacacatzohuaj, huan nochi nopa tepetl mojmoliniyaya tlahuel chicahuac. ");
INSERT INTO nheBl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Huan quema nopa tlapitzali tlahuel chicahuac eltiyajqui, Moisés camatqui, huan Toteco Dios quinanquili ica itos tlen elqui queja se tlatomonilotl. ");
INSERT INTO nheBl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Huan TOTECO temoc hasta itzonpac nopa tepetl Sinaí huan quinotzqui Moisés ma tlejco. Huan Moisés tlejcoc, ");
INSERT INTO nheBl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","huan TOTECO quiilhui: ―Xitemo huan xiquinilnamiquiltiti nopa tlacame para ma amo quiixpanoca nopa nepamitl campa niquinilhuijtoc. Niyon ma amo mocuatopejtiyaca pampa quinequise nechitase para ax miquise. ");
INSERT INTO nheBl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hasta nojquiya nopa totajtzitzi tlen quipiyaj inintequi para nechnechcahuise monequi mocualchijchihuase huan motlapajpacchihuase huan moiyocacahuase san para na para ax niquintzontlamiltis. ");
INSERT INTO nheBl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Huan Moisés quinanquili TOTECO: ―Nopa tlacame ax motemacase tlejcose ipan ni tepetl Sinaí, pampa ta titlanahuati ma nijtlali se nepamitl huan ma niquiyocacahua ni tepetl san para ta, huan ya nopa nijchijtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Pero TOTECO quiilhui: ―Xitemo sampa huan xijcuiti Aarón. Pero amo xiquincahuili nopa totajtzitzi, niyon nopa tlacame, ma mocuatopehuaca huan ma quiixpanoca nopa nepamitl para tlejcose campa niitztoc, pampa intla quichihuase, niquincocototzas. ");
INSERT INTO nheBl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Huajca Moisés temoc sampa huan quinilhuito israelitame tlen TOTECO quiilhui. ");
INSERT INTO nheBl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Huan Toteco Dios camatqui huan quiijto nochi ni tlajtoli: ");
INSERT INTO nheBl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Na niDIOS, niimoTECO tlen nimechquixti ipan tlali Egipto campa intlatequipanohuayayaj san tlapic queja inmechcojtosquíaj. ");
INSERT INTO nheBl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Amo xijtlepanitaca seyoc queja imoTeco, san na. ");
INSERT INTO nheBl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Amo xijchihuaca itlachiyalis niyon se tlamantli para inquitlepanitase. Amo xiquixcopinaca tlen eltoc ipan elhuicac, niyon tlen eltoc ipan ni tlaltepactli, niyon tlen onca ipan atemitl para inquihueyichihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Amo ximotlancuaquetzaca iniixpa tlaixcopincayome tlen tlamachijchihuali, niyon amo xiquinhueyichihuaca, pampa na niDIOS, niimoTECO, huan nimechtlasomati huan nijnequi san na xinechhueyimatica. Huan quema niquintlatzacuiltía tetajme tlen ax quinequij nechitase, nopa tlatzacuiltili nojquiya quinajsis ininconehua, huan iniixhuihua huan ipan ininteipa ixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pero ica tlen nechicnelíaj huan tlen quichihuaj notlanahuatil, niquinicnelis huan niquintlasojtlas ininconehua, huan iniixhuihua huan hasta iniixhuihua quinpiyase iniixhuihua mil huelta. Quena, notlasojtlacayo quinajsis para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Amo xicahuilmatica notoca, niimoTECO Dios, pampa ax quinamiqui. Temachtli nijtlatzacuiltis tlen san quej hueli quitequihuía notoca. ");
INSERT INTO nheBl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Xiquilnamiquica sábado, nopa tonal para inmosiyajcahuase, huan xijtlepanitaca. Ma elis tlaiyocatlalili tlen nochi sequinoc tonali. ");
INSERT INTO nheBl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ipan chicuasen tonali xijchihuase nochi tlen monequi inquichihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Pero nopa chicompa tonal elis se tonal para ximosehuica huan xinechhueyitlalica na niimoTECO Dios. Ipan nopa tonal ax hueli intequitise, niyon amo xijcahuilica ma tequiti imotelpoca, niyon imoichpoca, niyon imotequipanojca, niyon imosihua tlatequipanojca, niyon imotlapiyalhua, niyon nopa sejcoyoc ejquetl tlen itztoc ipan imochaj. ");
INSERT INTO nheBl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pampa ica chicuasen tonali TOTECO quichijqui elhuicactli, tlaltepactli, hueyi atl huan nochi tlen quipiya. Huan mosiyajcajqui ipan nopa chicompa tonal. Yeca TOTECO quitiochijqui nopa chicompa tonal huan quiiyocatlali para ipan ma timosehuica. ");
INSERT INTO nheBl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Xijtlepanitaca imotata huan imonana para initztose miyac xihuitl ipan nopa tlali tlen TOTECO Dios inmechmacas. ");
INSERT INTO nheBl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Amo xitemictica. ");
INSERT INTO nheBl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Amo ximomecatica. ");
INSERT INTO nheBl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Amo xitlaxtequica. ");
INSERT INTO nheBl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Axaca xiquistlacahuica. ");
INSERT INTO nheBl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Amo xiquixtocaca seyoc ichaj, niyon amo xiquixtoca seyoc isihua, niyon itlaca tlatequipanojca, niyon isihua tlatequipanojca, niyon itoro tlen tlapoxonía, niyon iburro. Amo xiquixtocaca niyon se tlamantli tlen seyoc iaxca.” ");
INSERT INTO nheBl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nochi israelitame quicajque nopa tlatomonilotl huan nopa tlapitzali. Quiitaque nopa tlapetlanilotl huan nopa tepetl tlen popocayaya. Huan tlahuel majmajque, huan huihuipicaque huan mohuejcachijque. ");
INSERT INTO nheBl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Huan quiilhuijque Moisés: ―Xitechcamahui ta huan timitzneltoquilise. Pero ma ax techcamahui Toteco Dios pampa huelis timiquise. ");
INSERT INTO nheBl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Huan Moisés quinnanquili: ―Amo ximomajmatica. Toteco Dios hualajtoc quej ni para inmechnextilis ihueyi chicahualis para xiquimacasica para nochipa huan para queja nopa ax intlajtlacolchihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Huan nochi nopa tlacame más mohuejcachijque. Huan Moisés monechcahui campa nopa mixtli tlen yayahuic campa itztoya Dios. ");
INSERT INTO nheBl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Huan TOTECO quiilhui Moisés: “Queja ni xiquinilhui nopa israelitame: ‘Ya inquiitztoque para nimechnojnotztoc tlen elhuicac. ");
INSERT INTO nheBl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Amo xijchihuaca tlamantli tlen oro, o tlen plata o ica niyon se tlamantli para inquihueyimatise. Monequi xinechtlepanitaca san na. ");
INSERT INTO nheBl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Xinechchihuilica se tlaixpamitl ica soquitl huan ipani xinechmacase tlacajcahualistli. Nopona xiquintencahuaca nopa tlacajcahualistli tlen tlatlatili huan nopa tlacajcahualistli para inquipiyase tlayoltlalili ica na, niimoTECO. Huan nopona inquintencahuase pilborregojtzitzi huan huacaxme queja imotlacajcahualis. Huan campa hueli campa na nimechchihualtis para inmoilhuise tlen na, nopona xijchihuaca se tlaixpamitl. Huan nopona na niyas huan nimechtiochihuas. ");
INSERT INTO nheBl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Intla innechchihuilise se tlaixpamitl tlen tetl, amo xijtequica nopa tetl. Pampa intla inquitequise ica tepostli, ax quinamiqui para elis ipan notlaixpa. ");
INSERT INTO nheBl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Huan nijnequi notlaixpa ma amo quipiyas escalera campa tlacame monequi tlejcose para quiajsise. Ax nijnequi para seyoc hueli quiitas tlatzintla icuej tlen tlejcosquía nopona.’ ");
INSERT INTO nheBl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ya ni nochi nopa tlanahuatili tlen tiquinmacas israelitame: ");
INSERT INTO nheBl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Intla tijcohuas se tequitiquetl hebreo para moaxca, san monequi mitztequipanos chicuasen xihuitl. Ipan nopa chicompa xihuitl, monequi tijmajcahuas para ayoc elis moaxca. Huan ax tleno monequi mitztlaxtlahuis para quisas huan elis malacantoc o majcajtoc para yas campa quinequis. ");
INSERT INTO nheBl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Intla ajsico iselti, yas iselti. Pero intla ajsico ica isihua, monequi isihua yas ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Intla iteco quimacas se sihuatl huan nopa sihuatl quinpiyas oquichpilme huan sihuapilme; nopa sihuatl huan iconehua mocahuase iaxcahua iteco huan nopa tlaca tequitiquetl yas iselti. ");
INSERT INTO nheBl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Pero intla nopa tlaca tequitiquetl quiijtos para ax quinequi itztos malacantoc para yas campa ya quinequis huan quiijtohua quinicnelía iteco, isihua, huan iconehua huan quinequi mocahuas ininhuaya, huajca yajaya huelis mocahuas para noja elis iaxca iteco. ");
INSERT INTO nheBl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Huan iteco quihuicas iniixpa jueces, huan nopona quinechcahuiltise puertajteno, huan ica se hueyi tepos huitzmalotl quicoyonilis inacas. Queja nopa yajaya mochihuas itlatequipanojca nopa iteco para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Intla se tlacatl quinamacas iichpoca para ma tlatequipano san tlapic, nopa ichpocatl ax hueli mochihuas malacantoc o majcajtoc queja mochihuaj malacantoque tlaca tlatequipanohuani. ");
INSERT INTO nheBl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Pero intla iteco nopa ichpocatl ax quiixtocac huan yeca ax quichijqui isihua, yonque quitlapejpeni para se tonal elisquía isihua, huajca seyoc huelis quicohuas nopa ichpocatl sampa. Pero nopa tecojtli ax huelis quinamaquiltis nopa ichpocatl ica se sejcoyoc ejquetl pampa ax quichihuilijtoc cuali. Ax mosihuajti ihuaya queja quiijto quichihuas quema quicojqui. ");
INSERT INTO nheBl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Huan intla nopa tecojtli quitlapejpeni se sihua tlatequipanojquetl hebreo para quimacas itelpoca para ma quichihua isihua, monequi nopa tecojtli ayoc quiitas para se tlatequipanojquetl, monequi quiitas queja elisquía iichpoca. ");
INSERT INTO nheBl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Huan intla nopa tecojtli quicuis se hebreo ichpoca tlatequipanojquetl para isihua huan teipa quicuis seyoc isihua, ax hueli quiquixtilis niyon quentzi itlacualis nopa tlen achtohui. Noja monequi quitlamacas cuali, huan quiyoyontis cuali huan itztos ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Huan intla ax quinequi quichihuilis nochi ni eyi tlamantli, nopa sihuatl huelis mochihuas malacantoc o majcajtoc para yas campa yajaya quinequis huan ax tleno monequis tlaxtlahuas para hueli quisas. ");
INSERT INTO nheBl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Intla acajya quimaquilis seyoc huan yajaya miquis, monequi inquimictise nopa temictijquetl. ");
INSERT INTO nheBl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Pero intla tlen temicti ax quinequiyaya quicocos, san panoc pampa huelis queja nopa Toteco Dios quicahuili ma eli, na nimitznextilis teipa canque huelis yas nopa tlacatl para momanahuiti para axaca quiitzquis huan quimictis. ");
INSERT INTO nheBl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Pero intla nopa temictijquetl mocualanis ihuaya seyoc huan quisencahuas quejatza huelis quicajcayahuas huan quimictis, monequi xijmictica. Yonque nopa temictijquetl motlatiti tiopan calijtic huan quiitzquis notlaixpa para momanahuis, monequi tijquixtis, huan xitlanahuatis ma quimictica. ");
INSERT INTO nheBl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Intla se quimaquilis inana o itata, monequi inquimictise. ");
INSERT INTO nheBl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Intla se teichtequis, yonque quinamacas nopa tlacatl tlen quihuicac para ma tlatequipano, o noja quipixtos imaco quema inquipantise, monequi inquimictise. ");
INSERT INTO nheBl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Intla se quitelchihuas itata o inana, monequi inquimictise. ");
INSERT INTO nheBl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Intla tlacame motehuíaj huan se quimaquilis ne se ica se tetl, o ica se ima, pero ax miquis, san huetztos ipan itlapech, nopa tlen quicoco ax monequi miquis. ");
INSERT INTO nheBl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Intla nopa cocoxquetl huelis motlalanas huan huelis quisas calteno ica icuatopil, huajca san monequi tlaxtlahuas nopa tecocojquetl tlen ica mopajtis huan tlaxtlahuas nochi nopa tonali tequitl tlen quipolos hasta cuali mochicahuas. ");
INSERT INTO nheBl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Intla se acajya quihuitequi itlaca o isihua tlatequipanojca ica se cuahuitl, huan yajaya miquis pampa quicoco, monequi inquitlatzacuiltise iteco ipampa tlen quichijtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Pero intla nopa tequitiquetl itztos para se ome tonali huan teipa miquis, ax monequi xijtlatzacuiltica iteco pampa nopa tlatequipanojquetl iaxca. ");
INSERT INTO nheBl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Intla ome tlacame motehuíaj huan quicocose se sihuatl tlen conehue huan ica ya nopa quichihuilise ma tlacatis icone quema aya ajsi tonali, ya ni tlen inquichihuase. Intla ax miqui nopa conetl, huajca tlen quipiya tlajtlacoli monequi tlaxtlahuas imiyaca tlen quiijtos ihuehue nopa sihuatl huan nopa jueces. ");
INSERT INTO nheBl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero intla miquis nopa conetl, monequi inquimictise tlen quicoco nopa sihuatl. ");
INSERT INTO nheBl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Huan intla se teixtiyolcocos, xiquixtiyolcococa tlen tecoco. Intla tetlancochtepehuas, xijtlancochtepehuaca. Intla se quicocos ipan ima o imetz se acajya, monequi nojquiya san se inquicocose tlen tecocohua. ");
INSERT INTO nheBl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Intla se tetlatía, nojquiya xijtlatica. Huan intla se tetzontequis, xijtzontequica. Intla se quitepachos seyoc, nojquiya xijtepacho yajaya tlen tetepachojtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Intla se tecojtli quimaquilis itlaca o isihua tlatequipanojca ipan iixtiyol, huan quicahuas ixpitzitic huan ayoc huelis tlachiyas ica nopa iixtiyol, monequi quimajcahuas nopa tlatequipanojquetl para ma eli majcajtoc pampa quiixtiyolcoco. ");
INSERT INTO nheBl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Huan intla se quitlancochtepehua itlaca o isihua tlatequipanojca, monequi quimajcahuas nopa tequitiquetl para ma eli majcajtoc ipampa quitlancochtepejqui. ");
INSERT INTO nheBl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Intla se toro quitompojhuis se tlacatl ica icuacua huan yajaya miquis, monequi inquimictise nopa toro ica tetl huan amo xijcuaca inacayo. Pero amo xijtlatzacuiltica tlen iaxca nopa tlapiyali. ");
INSERT INTO nheBl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero intla nopa toro ya momajtoya tetompojhuía huan iteco quimati huan ax quitzacua cuali nopa toro, huan intla teipa quimictis se acajya, monequi inquitzontepachose nopa toro huan iteco hasta miquise. ");
INSERT INTO nheBl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Pero intla iteixmatcahua tlen nopa toro quimicti, achi más paquise ica tomi huan ax quinequise ma miqui iteco nopa toro, monequi nopa tecojtli ma quintlaxtlahuis ica tomi tlen quiijtose para quimanahuis iyolis. ");
INSERT INTO nheBl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Nojquiya queja ni elis intla nopa toro quitompojhuis se sihuapil o se oquichpil. ");
INSERT INTO nheBl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Pero intla nopa toro quitompojhuía se tlaca o sihua tlatequipanojquetl, monequi inquimictise nopa toro ica tetl, huan tlen iaxca nopa tlapiyali monequi quitlaxtlahuis iteco nopa sihua o tlaca tlatequipanojquetl 30 plata tomi. ");
INSERT INTO nheBl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Intla acajya quitlapojtehua se ameli huan ax quitzacua huan teipa iijtic huetzis se toro o se pilburrojtzi, ");
INSERT INTO nheBl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","huajca tlen iaxca nopa ameli monequi quitlaxtlahuis queja ipati nopa toro tlen quipolo. Inacayo nopa tlapiyali tlen mictoc elis iaxca tlen tlaxtlajqui. ");
INSERT INTO nheBl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Intla itoro se tlacatl quicocos itoro seyoc tlacatl hasta miquis, huajca quinamacase nopa toro tlen itztoc huan quitlajcoitase nopa tomi. Nojquiya quitlajcoitase nopa toro tlen mictoc. ");
INSERT INTO nheBl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pero intla nopa tecojtli ya quimajtoya para nopa tlapiyali ipa tetompojhuiyaya huan ax quichihuiliyaya cuenta, monequi ax san quitlaxtlahuis tlajco. Monequi quitlaxtlahuis nochi tlen ipati nopa tlapiyali tlen quimicti, huan nopa toro tlen mictoc elis iaxca. ");
INSERT INTO nheBl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Intla se acajya quiichtequis se toro o se borrego huan quimictis o quinamacas, monequi tlaxtlahuas macuili torojme para sesen toro, o nahui borregojme para sesen borrego. ");
INSERT INTO nheBl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Intla acajya quipantis se tlaxtejquetl quema calaqui techaj tlayohua para tlaxtequis huan nopa caltecojtli quicocos nopa tlaxtejquetl huan yajaya miquis, nopa caltecojtli ax quihuicas tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Pero intla ica tonaya quimictis se tlaxtejquetl, quena, quipiyas tlajtlacoli tlen temictijtoc. “Tlen tlaxtequi monequi quiixtlahuas tlen ipati tlen quiichtectoc. Huan intla ax quipiya tomi, monequi monamacas para tequipanos huan queja nopa ma quiixtlahuas tlen quiichtectoc. ");
INSERT INTO nheBl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Intla tlacame quipantise se toro, se burro, o se borrego tlaxtectli tlen noja itztoc imaco nopa tlaxtejquetl, monequi tlaxtlahuas ompa tlen ipati. ");
INSERT INTO nheBl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Intla acajya quinmajcahuas itlapiyalhua huan tlacuajcuatij temila o texocomeca mila, monequi quicuepilis nopa tlaltecojtli se tlaxtlahuili queja ipati nopa pixquistli tlen más cuali quipixtoya ipan imil o ipan nopa ixocomecamil para tlaxtlahuas tlen itlapiyalhua quinenpolojque. ");
INSERT INTO nheBl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Intla acajya tlajchinohua huan nopa tlitl pano ipan seyoc imila, huan quitlatía nopa trigo tlen quimontonojtoque, o tlen ya eltoc para pixquistli o quitlatía nochi tlatoctli, yajaya tlen quitlati monequi tlaxtlahuas ipampa nochi tlen quitlati nopa tlitl. ");
INSERT INTO nheBl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Intla se tlacatl quimactilis tomi o tlamantli tlen ipati se ihuampo para ma quimocuitlahuili, huan se tlaxtejquetl calaquis ipan nopa cali huan quitlaxtequilis, intla quipantise, monequi nopa tlaxtejquetl tlaxtlahuas ompa tlen quicuitoc. ");
INSERT INTO nheBl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pero intla ax quipantise nopa tlaxtejquetl, huajca tlen quimocuitlahuía nopa tlamantli quihuicase iniixpa jueces para quiitase intla yajaya quicuitoc tlen eltoya iaxca ihuampo tlen ipan motemachi. ");
INSERT INTO nheBl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Quema se quipolos se toro, o se burro, o se borrego, o se yoyomitl, o tlen hueli tlamantli huan teipa quipantis imaco seyoc, huan intla ne se quiijtohua para iaxca, huajca nochi ome tlen quiijtohuaj para iniaxca monequi yase iniixpa jueces, huan nopa jueces quiijtose ajqueya iaxca. Huan yajaya tlen tecuilijtoc monequi quicuepas ompa. ");
INSERT INTO nheBl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Intla acajya quimactilis seyoc ma quimocuitlahuili se burro, se toro, se borrego o seyoc tlapiyali huan nopa tlapiyali miquis, o mococos, o cholos huan axaca quiitac tlaque panoc, ");
INSERT INTO nheBl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","nopa tlacatl tlen quimocuitlahuiyaya monequi quitestigojquetzas TOTECO para ax tleno tlen ax cuali quichijtoc ica tlen quicahuilijtoyaj. Huan tlen iaxca nopa tlapiyali monequi quineltoquilis itlajtol ihuampo tlen quitestigojquetztoc TOTECO. Huan tlen tlamocuitlahuiyaya ax tleno monequi tlaxtlahuas. ");
INSERT INTO nheBl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pero intla iixpa quiichtequilijque nopa tlapiyali, huajca tlen tlamocuitlahuiyaya monequi quitlaxtlahuis iteco nopa tlapiyali queja ipati. ");
INSERT INTO nheBl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Huan intla nopa tlapiyali quicocototzqui se tecuani, ya tlen quimocuitlahuiyaya monequi quinextis iomiyo nopa tlapiyali tlen mijqui huan queja nopa ax monequi tlaxtlahuas. ");
INSERT INTO nheBl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Intla acajya motlanehui se tlapiyali, huan ne tlapiyali ipantis se tlenijqui, o miquis, huan ax quiitac iteco, huajca yajaya tlen motlanejqui monequi tlaxtlahuas. ");
INSERT INTO nheBl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pero intla nopa tecojtli noja itztoc ihuaya itlapiyal quema ipantis se tlenijqui, nopa tlen motlanejtoc ax monequi tlaxtlahuas. Huan intla se motlanehui se tlapiyali huan tlaxtlahua para quitequihuis huan ipantis se tlenijqui, ax monequi tlaxtlahuas pampa ya tlaxtlajtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Intla se tlacatl quicajcayahuas se ichpocatl tlen ax quiijtlantoque huan quichihualtis ihuaya cochis, monequi quitlaxtlahuis itata san se queja tlen quitlaxtlahuisquía se tlacatl tlen quinequisquía mosihuajtis ihuaya nopa ichpocatl. Huan quema ya quitlaxtlahuijtos itata nopa ichpocatl, huelis mosihuajtis ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Huan yonque itata nopa ichpocatl ax quinequis quimactilis para ma eli isihua, nopa tlacatl monequi tlaxtlahuas imiyaca tomi tlen momajtoque tetlamajmacase para se ichpocatl. ");
INSERT INTO nheBl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Amo xijcahuilica ma itzto se tetlajchihuijquetl. Monequi xijmictica. ");
INSERT INTO nheBl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Intla acajya quichihuas se tlamantli ica se tlapiyali queja elisquía inamic, monequi inquimictise. ");
INSERT INTO nheBl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Intla se quimacas se tlacajcahualistli se tlaixcopincayotl o seyoc tlamantli tlen quiita para tecojtli, xijmictica. San na, niimoTECO, xinechmacase tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Amo xijcajcayahuaca, niyon amo xijchihuilica tlen fiero se sejcoyoc ejquetl, pampa imojuanti nojquiya ineltoyaj insejcoyoc ehuani ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Amo xijtlaijiyohuiltica se sihuatl tlen cahualtzi, niyon se icnotzi. ");
INSERT INTO nheBl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Pampa intla inquinchihuilíaj tlen fiero, inijuanti nechtlajtlanise ma niquinpalehui huan na nijcaquis huan niquinpalehuis. ");
INSERT INTO nheBl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Huan nicualanis miyac huan nimechmictis ica machete, huan imosihuajhua nojquiya mocahuase cahualtzitzi huan imoconehua icnotzitzi. ");
INSERT INTO nheBl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Intla inquitlanejtise tomi se teicneltzi tlen nojquiya se israelita queja imojuanti, amo ximochihuaca queja se tetlanejtijquetl. Amo xiquinamaca itlapanca. ");
INSERT INTO nheBl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Intla teicneltzi se tlacatl tlen inquitlanejtíaj huan monequi inmechprendajcahuilis itlaque, monequi xijcuepilica quema tiotlaquiyas, ");
INSERT INTO nheBl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","pampa huelis san se itlaque quipiya para moquentis quema tlaseseya. Huan san ya nopa quipiya para ica mopiquis quema cochis. Huan intla ya tlaijiyohuis huan nechtlajtlanis ma nijpalehui, nijtlacaquilis huan nijpalehuis pampa na nitetlasojtla. ");
INSERT INTO nheBl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Amo xiquintlaijilhuica imotequihuejcahua, niyon amo xijtlaijilhuica yajaya tlen tlanahuatía ipan imotlal. ");
INSERT INTO nheBl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Amo xihuejcahuaca para xinechhualiquilise nopa ofrendas tlen noaxca tlen nochi imopixquis huan tlen nochi imoxocomecamil. “Monequi xinechtemactilica imoachtohui oquichpil. ");
INSERT INTO nheBl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Nojquiya monequi xinechmacaca iniachtohui conehua imohuacaxhua huan imoborregojhua. Huelis mocahuase chicome tonati ihuaya ininnana, pero ipan nopa chicueyi tonal xinechmacaca. ");
INSERT INTO nheBl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Monequi inelise notlatzejtzeloltijca tlacajhua. “Amo xiquincuaca tlapiyalime tlen tecuanime quinmictijtoque cuatitla. Nopa nacatl monequi xiquinmacaca chichime. ");
INSERT INTO nheBl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Amo xijmoyahuaca se tlajtoli tlen ax neli tlen sequinoc. Amo xijpalehuica se fiero tlacatl huan xijtestigojquetzaca se tlamantli tlen ax neli ipampa ya. ");
INSERT INTO nheBl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Quema itztoque miyac tlen quichihuasnequij tlen ax cuali, amo ximocalaquica ininhuaya. “Quema inmochihuase intestigos para inquiijtose tlamiyacapa tlen melahuac panotoc, amo xiquijtoca tlen ax neli queja miyac tlacame quinequise xijchihuaca, pampa ax xitlahuac intla inquichihuase queja nopa. ");
INSERT INTO nheBl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Niyon amo xijtestigojquetzaca ica tlen ax melahuac pampa tijchicoicnelía se tlen teicneltzi huan tijnequi tijpalehuis. ");
INSERT INTO nheBl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Intla inquipantilise imocualancaitaca itoro o iburro tlen cholojtoc, monequi xijhuiquilica. ");
INSERT INTO nheBl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Intla tijpanti mocualancaitaca huan quitlalanasnequi iburro tlen huetztoc ica itlamamal tlen etic, amo xijcajtehua hasta tijpalehuis ma quitlalanas. ");
INSERT INTO nheBl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Xiquinchihuili nochi teicneltzitzi tlen xitlahuac quema onca se cualantli. ");
INSERT INTO nheBl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Xijtlalcahui se tlen quinequi quiteilhuis seyoc ica tlen ax melahuac. Amo xijcahua ma quimictica se tlen ax tleno quichijtoc. Pampa nojquiya na nijtlatzacuiltis aqui quicahuas se ma quimicti se tlacatl tlen xitlahuac. ");
INSERT INTO nheBl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Quema titetlajtolsencahua, amo xijseli se tlaxtlahuili ixtacatzi. Tlen quiselía tlaxtlahuili ixtacatzi ayoc huelis quiitas tlen melahuac, huan ax quicahuilía ma camati tlen quiijtohua tlen xitlahuac. ");
INSERT INTO nheBl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Amo xijtlaijiyohuilti se sejcoyoc ejquetl, pampa nojquiya ineltoyaj insejcoyoc ehuani ipan tlali Egipto. Huan inquimatij quejatza inquimatiyayaj quema initztoyaj ipan se tlali tlen ax imoaxca. ");
INSERT INTO nheBl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“San chicuasen xihuitl intlatojtocase huan inpixcase ipan imotlal. ");
INSERT INTO nheBl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Huan quema ajsis nopa chicompa xihuitl, ax tleno xijtocaca. San xijcahuaca imotlal ma mosiyajcahua. Huan intla moscaltis iselti se quentzi toctli, xiquincahuilica tlen teicneltzitzi ipan imotlal ma mopixquilica para ica mopanoltise. Huan tlen mocahua ma quicuaca tlapiyalime tlen cuatitla. Nojquiya queja nopa inquichihuase ica imoxocomecamil huan ica imoolivomil. ");
INSERT INTO nheBl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Para chicuasen tonali inquichihuase nochi tlen monequi inquichihuase, pero ipan nopa chicompa tonal monequi ximosehuica. Nojquiya ma mosiyajcahuaca imotorojhua huan imoburrojhua. Ma mosiyajcahuaca imotlatequipanojcahua tlen inquincojtoque huan nopa sejcoyoc ehuani tlen inmechpaxalohuaj. Quema inmosiyajcahuaj o inmosehuíaj, inmechpalehuis nochi imojuanti para sampa xijpiyaca fuerza. ");
INSERT INTO nheBl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Ximotlachilica huan xijchihuaca nochi ya ni tlen nimechilhuijtoc. Ax quema xiquintestigojquetzaca inintoca tlaixcopincayome tlen ne sequinoc quinhueyimatij. Niyon ax quema xijtenquixtis inintoca. ");
INSERT INTO nheBl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Eyi huelta ipan se xihuitl xinechilhuichihuilica. ");
INSERT INTO nheBl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Xijchihuaca nopa ilhuitl tlen pantzi tlen ax quipiya tlasonejcayotl queja nimechnahuatijtoc. Xijcuaca pantzi tlen ax quipiya tlasonejcayotl chicome tonali queja nimechilhuijtoc. Inquicuase ipan metztli Abib ipan nopa tonal tlen nimitzilhui, pampa ipan nopa metztli inquistejque tlali Egipto. Huan axaca hueli nechnechcahuis intla ax nechhualiquilis se tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Nojquiya xijchihuaca nopa ilhuitl tlen ipejya pixquistli huan xinechhualiquilica tlen achtohui inquipixcatoque tlen inquitojque ipan imomil. Huan nojquiya sesen xihuitl xijchihuaca nopa ilhuitl tlen itlamiya pixquistli quema inquisentilijtoquejya nochi nopa pixquistli tlen nopa toctli tlen inquitojque temacac. ");
INSERT INTO nheBl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Expa ipan se xihuitl monequi nochi intlacame ximonextica noixtla, na niimoTECO Tlen Más Nijpiya Tlanahuatili. ");
INSERT INTO nheBl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Quema innechmacase ieso se tlapiyali para se tlacajcahualistli, amo xinechmacaca ieso san sejco ihuaya pantzi tlen quipiya tlasonejcayotl. Niyon amo xicajcocuica ichiyajca nopa tlapiyali para innechmacase ipan seyoc tonal. ");
INSERT INTO nheBl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ipan nopa achtohui tonal tlen nopa achtohui pixquistli, xijtlapejpenica tlen más cuali tlen itlajca tlen temaca imotlal huan xinechmactilica, na niimoTECO Dios. “Amo xiquicxitica se pilcone chivojtzi ipan inana ilechi queja quichihuaj tetlajchihuiani. ");
INSERT INTO nheBl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Xiquita, na nijtitlanis noelhuicac ejca ma inmechyacana, huan ma inmechmocuitlahui ipan ojtli huan ma inmechhuica hasta nopa tlali tlen nimechcualtlalilijtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Xijtlacaquilica cuali tlen yajaya inmechilhuis huan xijneltoquilica. Amo xijhuejcamajcahuaca, pampa yajaya quihuica nochi nopa tlanahuatili tlen nijhuica na huan ax inmechtlapojpolhuis imotlajtlacolhua intla inquihuejcamajcahuase. ");
INSERT INTO nheBl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Pero intla nelía inquicaquise cuali nochi tlen nimechilhuía huan inquichihuase nochi tlen nimechnahuatijtoc, na nielis niinincualancaitaca imocualancaitacahua huan niquintlaijiyohuiltis tlen inmechtlaijiyohuiltise. ");
INSERT INTO nheBl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Noelhuicac ejca inmechyacanas huan inmechhuicas ipan inintlal nopa amorreos, heteos, ferezeos, cananeos, heveos huan jebuseos. Huan na niquintzontlamiltis imoixtla. ");
INSERT INTO nheBl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Amo ximotlancuaquetzaca iniixpa inintlaixcopincayohua o inintiotzitzi nopa tlacame, niyon amo xiquinhueyichihuaca. Ax quema xijtoquilica nopa fiero tlamantli tlen nopa tlacame quichihuaj. Monequi xiquintzontlamiltica nochi nopa tlacame huan xijpapayatzaca nochi nopa tetini tlen quinhueyichihuaj. ");
INSERT INTO nheBl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","San xinechhueyichihuaca na, niimoTECO Dios, huan nijtiochihuas imotlacualis ihuaya imoa. “Huan nijchihuas para ma ax inmechajsi cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ax oncas niyon se sihuatl ipan imotlal tlen elis tetzacatl o tlen conehuetzis. Huan nijchihuas para initztose miyac xihuitl ipan ni tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Na nijtitlanis se hueyi majmajtli ipan nochi nopa fiero tlacame campa inajsise hasta ax quimatise tlaque quichihuase. Huan nijchihuas ma cholojtehuaca imoixtla nochi imocualancaitacahua. ");
INSERT INTO nheBl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Niquintitlanilis mecapaletzame ma tlayacanaca huan ma quintojtocaca nopa heveos, nopa cananeos huan nopa heteos imoixtla. ");
INSERT INTO nheBl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Pero ax niquintojtocas para nochi ma quisaca ipan san se xihuitl. Intla queja nopa nijchihuasquía, polihuisquía nochi tlen tlatojtoctoque, huan momiyaquilisquíaj tecuanime tlen itztoque cuatitla tlen huelis inmechcocose. ");
INSERT INTO nheBl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pero ica yolic niquintojtocatiyas imoixtla queja nojquiya yolic inquinpixtiyase más imoconehua huan inmomiyaquilijtiyase para inmoaxcatise nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Queja ni nijquetztoc inepa imotlal: pejtehuas imotlal ipan nopa Hueyi Atl Chichiltic huan yas hasta nopa Hueyi Atl Mediterráneo 23:31 Hueyi atl tlen nopa filisteos.. Nojquiya pejtehuas ipan huactoc tlali ica sur huan tlamis ipan nopa atemitl Éufrates ica campa huala tonati. Na nijtlalijtoc imomaco nochi tlacame tlen ehuaj ipan nopa tlali para xiquintojtocaca. ");
INSERT INTO nheBl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“Amo xijchihuaca niyon se tlajtoli ininhuaya, niyon ica inintlaixcopincayohua. ");
INSERT INTO nheBl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Amo xiquincahuilica ma mocahuaca ipan imotlal para ax inmechchihuase xitlajtlacolchihuaca ica na. Intla inquihueyichihuase inintlaixcopincayohua, huajca nelía inmechmasiltise.” ");
INSERT INTO nheBl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Huan TOTECO quiilhui Moisés: ―Xitlejco campa na niitztoc, ta ihuaya Aarón, Nadab, Abiú huan nopa 70 huehue tlacame tlen mohuaya quinyacanaj ni israelitame. Inijuanti ma motlancuaquetzaca ica huejca para nechhueyimatise. ");
INSERT INTO nheBl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","San ta, Moisés, huelis tinechnechcahuis campa na, niimoTECO, niitztoc. Nopa sequinoc tlayacanani ax huelise nechnechcahuise, huan nopa sequinoc israelitame ax huelis tlejcose nica imohuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Huan Moisés yajqui quinpohuilito nopa israelitame nochi tlen TOTECO quiijtojtoya huan tlen tlanahuatijtoya. Huan nochi israelitame san se huelta tlananquilijque: ―Nochi tlen TOTECO quiijtojtoc, tijchihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Huajca Moisés quiijcuilo nochi tlen TOTECO quiilhuijtoya. Huan hualmostla cualca mejqui huan quisencajqui se tlaixpamitl itzintla nopa tepetl, huan quiquetzqui nopa tlaixpamitl ipan majtlactli huan ome tetini queja imiyaca itelpocahua Israel tlen ica pejqui nopa majtlactli huan ome huejhueyi familias tlen israelitame tlen ama onca. ");
INSERT INTO nheBl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Teipa quintitlanqui sequin israelita telpocame ma quimacaca TOTECO tlacajcahualistli tlatlatili. Huan quinmictijque huan quintlatijque torojme para tlacajcahualistli para ma quipiyaca tlayoltlalili ihuaya TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Huan Moisés quicuic tlajco nopa estli, huan quitejqui ipan huajcaltini huan nopa seyoc tlajco quiijtzelo ipan tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Teipa quicuic nopa amatlapohuali tlen quipixtoya itlanahuatil TOTECO, o nopa tlajtolsencahuali tlen TOTECO quichijqui ininhuaya israelitame huan tlen monequi quineltocase. Huan quinpohuili nochi nopa amatlapohuali huan inijuanti quiijtojque: ―Quena, tijneltoquilise TOTECO huan tijchihuase nochi tlen yajaya techilhuijtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Huajca Moisés quicuic nopa estli ipan huajcaltini, huan quinijtzelhuili nochi israelitame, huan quiijto: ―Ya ni nopa estli tlen quipehualtía nopa tlajtolsencahuali tlen TOTECO quichijtoc imohuaya quema inmechmacac nochi ni tlanahuatili. ");
INSERT INTO nheBl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Huan teipa Moisés tlejcoc ipan nopa tepetl ihuaya Aarón, Nadab, Abiú huan nopa 70 huehue tlacame tlen quinyacanayayaj nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Huan nopa israelita tlayacanani quiitaque Dios, ininTeco israelitame. Huan tlatzintla iicxihua quipixqui se piso azultic queja nopa yejyectzi tetl tlen itoca zafiro, huan eliyaya tlahuel tzalintic queja elhuicactli. ");
INSERT INTO nheBl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Huan yonque nopa tlayacanca israelitame quiitaque Toteco Dios huan san sejco tlacuajque huan atlique iixtla, ax quinmicti. ");
INSERT INTO nheBl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Huan TOTECO quiilhui Moisés: ―Xitlejco campa niitztoc ipan ni tepetl huan ximocahua nica. Huan nimitzmacas nopa tepatlactli campa niquijcuilojtoc nopa ley huan nochi nopa tlanahuatili para tiquinmachtis israelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Huan Moisés tlejcoc ipan itepe Toteco ica Josué itlapalehuijca. ");
INSERT INTO nheBl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Huan quinilhui nopa huehue tlacame: ―Xinechchiyaca nica hasta quema timocuepase. Nica mocahuase Aarón huan Hur imohuaya, huan intla acajya quipiya se cualantli quema ax niaca, ma quinilhuica inijuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Huan Moisés tlejcoc ipan nopa tepetl huan se mixtli quitzajqui. ");
INSERT INTO nheBl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Huan itlatlanex TOTECO temoc ipan tepetl Sinaí, huan nopa mixtli quitzajqui nopa tepetl para chicuasen tonali. Huan quema ajsic nopa chicompa tonal, TOTECO quinotzqui Moisés tlatlajco ipan nopa mixtli. ");
INSERT INTO nheBl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Huan nopa israelitame tlen itztoyaj tlatzintla quiajcotlachilijque huan quiitaque itlatlanex TOTECO, huan para inijuanti elqui queja se tlilelemectli tlen nochi quitlatiyaya tepeixco. ");
INSERT INTO nheBl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Huajca Moisés tlejcotiyajqui ipan nopa tepetl, huan calajqui ipan nopa mixtli huan nopona mocajqui para 40 tonali huan 40 yohuali. ");
INSERT INTO nheBl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Huan nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Xiquinilhui nopa israelitame para hueli nechmacase tlacajcahualistli intla quinequij. Xijsentilica nochi nopa tlamantli tlen sese israelita quinequi nechmacas ica nochi iyolo. ");
INSERT INTO nheBl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Intla quinequij nechmacase se tlenijqui, huelis xiquinselili tlamantli tlen oro, plata huan cobre. ");
INSERT INTO nheBl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Nojquiya huelis tiquinselilis icpatl tlen nopa tzontli tlen itoca lino tlen tlamalintli nelcanactzi, huan nojquiya icpatl tlen iniijhuiyo borregojme tlen quipajtoque azultic, moradojtic, o chichiltic. Nojquiya xijseli inincuitlapa ijhuiyo chivojme, ");
INSERT INTO nheBl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","huan inincuetlaxo pesojme huan nopa cuahuitl tlen itoca acacia. ");
INSERT INTO nheBl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Xijseli aceite para ica quitlatise tlahuili. Xijseli tlaajhuiyacayotl para aceite tlen quitequihuíaj para tlaiyocacahuase para na, huan nojquiya para ica inquisencahuase copali tlen ajhuiyac. ");
INSERT INTO nheBl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Nojquiya huelis nechmacase tetini tlen pajpatiyo. Huelis nechmacase nopa tetl ónice huan sequinoc tetini tlen yejyectzitzi para inquitlatzquiltise ipan nopa pantzajcayotl huan nopa yolixpantzajcayotl para nopa hueyi totajtzi iyoyo. ");
INSERT INTO nheBl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Teipa xinechchihuilica se cali para ipan niitztos tlatlajco imojuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pero monequi xijsencahua nochaj ica nochi cuamesas huan tlamantzitzi senquistoc queja ni tlaixcopinali tlen ama nimitznextilis. ");
INSERT INTO nheBl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ma quichihuaca se caxa yejyectzi ica nopa cuahuitl tlen itoca acacia. Huan nopa caxa quipiyas 1 metro 10 centímetros ihuehueyaca huan 65 centímetros ipatlajca huan ihuejcapanca. ");
INSERT INTO nheBl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Xijxahuaca ica senquistoc oro iijtic huan ipani. Huan xijtlatzquiltilica iixteno se corona tlen oro tlen inquiyecchijtoque. ");
INSERT INTO nheBl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Xijchihuili nahui huejhueyi anillos tlen oro. Xijtlalica nopa anillos najcac campa iicxicuayohua, ome ipan se lado huan ome ipan ne seyoc. ");
INSERT INTO nheBl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Huan xijsencahuaca ome cuahuitl tlen huehueyac huan pitzahuac para ica inquiquechpanose. Huan xijxahuaca nopa cuahuitl ica oro, ");
INSERT INTO nheBl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","huan ma pano se tlen nopa cuahuitl huehueyac ipan nopa ome anillos ipan sesen lado ipan inacastla nopa caxa para queja nopa huelis inquitlalanase. ");
INSERT INTO nheBl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Huan ayoc xijquixtilica nopa cuahuitl tlen ica inquihuicase. Ma mocahua nopa cuahuitl ipan ianillos nopa caxa. ");
INSERT INTO nheBl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Huan quema inquitlamiltise nopa caxa, xijtlalica iijtico nopa tepatlactli ica nopa tlanahuatili tlen nimitzmacas. ");
INSERT INTO nheBl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Huan xijchihuaca nopa caxa itzajca tlen senquistoc oro tlen quipiyas se metro 10 centímetros ihuehueyaca huan 65 centímetros ipatlajca. Nopona iixco nopa caxa timopantise huan nimechtlasojtlas quema intlajtlacolchihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Xiquinchihuaca nojquiya ome elhuicac ehuani tlen inintoca querubines tlen ijcatose ipan ome lados iixco itzajca nopa caxa ica iniicxihua ipan itzajca. ");
INSERT INTO nheBl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Xiquinsencahuaca nopa ome querubines ica san se tlatectli oro tlen tlatejtzontli ica itzajca nopa caxa. Se querubín moquetzas ipan se iteno huan ne se ipan seyoc iteno ica ihuehueyaca. ");
INSERT INTO nheBl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Huan nopa querubines monequi quipatlajtose inieltlapal itzonpac nopa caxa para ma quiecahuilica. Huan moixnamictose nopa querubín elhuicac ehuani huan tlachixtose tlatzintla ipan itzajca nopa caxa, pampa nopona nitetlasojtlas. ");
INSERT INTO nheBl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Quema ya tlasencahuali itzajca, xijtlalica caxa ijtic nopa tepatlactli ica nopa tlanahuatili tlen nimitzmacas. ");
INSERT INTO nheBl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Huan nopona tlatlajco nopa querubines tlen mocahuaj iixco itzontzajca nopa caxa, nimechnamiquis huan nimechtlasojtlas. Quena, nopona itzonixco nopa caxa campa mocahuas nopa tepatlactli tlen quipiya nopa tlajtolsencahuali tlen ica nimocajtoc imohuaya, nimechmatiltis nochi notlanahuatilhua tlen nijpiya para inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Xijchihuaca se cuamesa ica nopa cuahuitl acacia, huan quipiyas 90 centímetros ihuehueyaca, 45 centímetros ipatlajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nheBl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Xijxahuaca nopa cuamesa ica senquistoc oro. Nojquiya xijchihuilica icorona tlen oro iixteno tlen inquiyecchijtoque. ");
INSERT INTO nheBl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Nojquiya yahualtic iixteno nopa cuamesa ma quipiya se icorona tlen chicome centímetros huan tlajco ihuejcapanca. Xijxahuaca nopa corona ica senquistoc oro tlen inquiyecchijtoque. ");
INSERT INTO nheBl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Nojquiya xijchihuilica nahui anillos tlen senquistoc oro tlen inquitlalilise ipan sese inacastla campa iicxicuayohua. ");
INSERT INTO nheBl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Monequi nopa anillos tlatzquitos itzala nopa corona nechca nopa cuamesa campa pehua iicxicuayo, huan ipan nopa anillos calaquis nopa cuahuitl huehueyac para ica inquihuicase nopa cuamesa. ");
INSERT INTO nheBl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Huan nopa cuahuitl huehueyac tlen ica inquiquechpanose nopa cuamesa monequi xijchihuaca ica acacia cuahuitl, huan xijxahuaca ica senquistoc oro. ");
INSERT INTO nheBl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Nojquiya xijsencahuaca platos, huejhueyi cucharas tlen oro, tepos huitzcucharas huan huejhueyi xarros para ipan inatecase. Huan ica nopa xarros xinechmacaca, na niimoTeco, nopa tlacajcahualistli tlen inquitoyahuase noixtla. ");
INSERT INTO nheBl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Huan iixco nopa mesa, monequi mojmostla inquitlalise noixpa nopa pantzi tlen tenextilía niitztoc imohuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Huan nojquiya xijsencahuaca se tlahuil quetzali tlen senquistoc oro tlen tlatejtepacholi ica martillo. Quipiyas se icuayo huan chicuase imacuayohua. Huan sesen pilcaxitzitzi tlen ipan tlatlatise quipiyas iyejyejca. Nesis queja se xochitl mimilijtoc huan se xochitl tlen cahuantoc, huan nochi iyejyejca monequi elis san se tlatectli oro. ");
INSERT INTO nheBl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Huan ica nopa chicuase imacuayohua tlen nopa tlahuil quetzali quipiyas, eyi imacuayohua quisas se lado huan ne seyoc eyi imacuayohua quisas ne seyoc lado. ");
INSERT INTO nheBl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Huan ipan sese imacuayo quipiyas eyi pilcaxitzitzi tlen quiyecchijtoque para nesis queja eyi ixochiyo nopa almendra. Sesen quipiyas se xochitl mimilijtoc huan se xochitl cahuantoc. Nochi chicuase imacuayo tlen quisase ipan icuayo nopa tlahuil quetzali quipiyase san se nopa xochitl. ");
INSERT INTO nheBl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Huan icuayo tlen eltoc tlatlajco nopa tlahuil quetzali quipiyas nahui pilcaxitzitzi ica inintlachiyalis queja ixochiyo se almendra. Sesen quipiyas se xochitl mimilijtoc huan se xochitl cahuantoc. ");
INSERT INTO nheBl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Campa quisa nopa achtohui ome imacuayohua ipan sesen lado icuayo, oncas se xochitl mimilijtoc itzala imacuayo. Huan nojquiya itzala ipan sesen lado nopa ompa huan expa imacuayohua oncas se xochitl mimilijtoc. Huajca quipiyas se xochitl mimilijtoc itzala nochi chicuase imacuayohua ipan nopa tlahuil quetzali. ");
INSERT INTO nheBl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ixochiyo huan imacuayohua elis tlasencahuali ica san se tlatectli tlen senquistoc oro tlen tlatejtzontli ica martillo. ");
INSERT INTO nheBl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Huan xijsencahuilica chicome piltlahuiltzitzi tlen inquitlatise para ma tlahuica ica iixmelac. ");
INSERT INTO nheBl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Nojquiya xijsencahuaca nopa cucharas para ica inquisehuise tlahuili ihuaya ipilplatotzitzi, huan nochi xiquinsencahuaca ica senquistoc oro. ");
INSERT INTO nheBl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Monequis queja 33 kilos tlen senquistoc oro para inquisencahuase huan inquiyectlalise nopa tlahuil quetzali. ");
INSERT INTO nheBl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“Ximotlachili para xijchihua nochi san queja na nimitznextilía amantzi nica ipan ni tepetl. ");
INSERT INTO nheBl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Xijsencahuili nopa yoyon tiopamitl majtlactli cortinas ica icpatl tlen lino tlamalintli hasta nelía canactzi, huan icpatl tlen iniijhuiyo borregojme tlen quipajtoque azultic, moradojtic huan chichiltic. Huan ma quixinepalo se tlen tlahuel quimati itequi para nesis iniixcopinca nopa elhuicac ehuani tlen inintoca querubines. ");
INSERT INTO nheBl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Huan sesen cortina quipiyas 12 metros huan tlajco ihuehueyaca, huan ipatlajca elis ome metro. Huan nochi nopa cortinas elis san se ininhuejhuexca. ");
INSERT INTO nheBl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Huan xijsalo nopa macuili cortinas san sejco. Huan nojquiya xijsalo nopa sequinoc macuili cortinas san sejco. Queja nopa quisas ome cortinas tlen nelía huehueyac. ");
INSERT INTO nheBl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Huan ipan se iteno nopa achtohui macuili cortinas tlen tijsalojtoc, xijchihuili tlailpili ica iojal tlen tijtenyahualos ica icpatl tlen azultic. Nojquiya san se tijchihuas ipan se iteno nopa sequinoc macuili cortinas tlen tijsalojtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ipan nopa achtohui tlasaloli tlen cortinas, xijchihuili 50 tlailpili huan ipan sesen xijcahua iojal. Teipa xijtenyahualos campa tijcahuili iojal ica icpatl azultic. Xijchihuili seyoc 50 ipan ne seyoc cortina tlen tijsalojtoc para ma moixnamiquica nopa 50 tlailpili ipan se cortina ica tlen eltoc ipan ne seyoc. ");
INSERT INTO nheBl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Huan xijsencahua 50 tepos chijcoli tlen senquistoc oro tlen ica tijsojsos nopa ome cortinas tlen tijsalojtoc, huan queja nopa elis san se tlamantli para itzonixco nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Huan nojquiya tijchihuas 11 cortinas ica se yoyomitl tetic tlen tlaxinepaloli ica iniijhuiyo oquich chivojme para elis queja se hueyi cuetlaxtli para tijtzontzacuas nopa yejyectzi yoyomitl tlen tijtlalijtoc itzonpac nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Monequi nopa tzontzajcayotl tlen eltoc queja se hueyi cuetlaxtli tlen iniijhuiyo chivojme elis 13 metros huan tlajco ihuehueyaca, huan ome metro ipatlajca. Nochi nopa 11 cortinas monequi elis san se ihuejhuexca. ");
INSERT INTO nheBl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Huan inquisalose macuili cortinas san sejco, huan iyoca inquisalose nopa seyoc chicuase cortinas san sejco. Huan quema inajsitij ipan nopa chicuasempa cortina, xijcuelpachoca para inquihuiyonise iixmelac nopa yoyon tiopamitl campa ticalaquis. ");
INSERT INTO nheBl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Huan nojquiya ipan iteno nopa cortinas, xijchihuilica 50 tlailpili, sese ica iojal. Xijchihuilica 50 tlailpili ica iojal ipan se cortina, huan ipan ne se nojquiya san se xijchihua, 50 tlailpili sese ica iojal. Huan moixnamiquise nopa achtohui tlasaloli cortinas huan ne seyoc tlasaloli cortinas itejteno campa iojal. ");
INSERT INTO nheBl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Huan nojquiya xijsencahuas 50 tepos chijcoli tlen senquistoc bronce tlen ica quisojsos iojal nopa 50 tlailpili ipan iteno se cortina ica iojal nopa 50 tlailpili ipan iteno seyoc cortina, huan queja nopa elis san se itzontzajca queja se hueyi cuetlaxtli. ");
INSERT INTO nheBl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Huan tlajco se cortina mocahuas cuapilijtos iica nopa tiopamitl huan seyoc tlajco iixtla. ");
INSERT INTO nheBl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Huan nopa yoyomitl tlen mocahuas cuapilijtoc oncac quitzacuas nopa tiopamitl. Tlajco metro cuapilijtos se lado huan seyoc tlajco metro tlen cuapilijtos seyoc lado nopa tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Huan nojquiya tijchihuilis seyoc itzontzajca para yas itzonixco nopa itzontzajca tlen eltoc queja se hueyi cuetlaxtli. Huan ya ni tijchihuas ica inincuetlaxo borregojme tlen quipiyaj se xihuitl huan tijpas inincuetlaxo ica chichiltic. Huan nopa najpa itzontzajca, xijchihua ica inincuetlaxo pesojme huan quitzacuas nopa itzontzajca tlen borregojme inincuetlaxo. ");
INSERT INTO nheBl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Huan nojquiya xijchihuaca nopa miyac huapali tlen moquetztose xitlahuaque para mochihuase nopa caltechtli tlen nopa tiopamitl. Xiquinchihuaca nopa miyac huapali ica acacia cuahuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Huan nochi huapali monequi elis nahui metro huan tlajco ihuehueyaca, huan 65 centímetros ipatlajca. ");
INSERT INTO nheBl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Huan sesen huapali quihuicas ome ima tlen huelis calaquis ipan seyoc huapali tlen moquetza inechca. Xiquinchihua nopa miyac huapali para nopa yoyon tiopamitl queja ni. ");
INSERT INTO nheBl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Xiquinsencahua 20 huapali tlen motequihuise ipan nopa caltechtli tlen eltoc ica sur. ");
INSERT INTO nheBl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Huan xiquinsencahua 40 icuatetoyo tlen senquistoc plata, huan nopa 20 huapali calaquise ipan nopa cuatetomitl para moquetzase xitlahuac. Sese huapali monequi quipiyas ome icuatetoyo tlatzintla para nopa ome ima. ");
INSERT INTO nheBl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","“Huan nopa caltechtli tlen eltoc ica norte ipan nopa yoyon tiopamitl nojquiya quinpiyas 20 huapali. ");
INSERT INTO nheBl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Huan quinpiyas 40 icuatetoyo tlen plata. Ome icuatetoyo mocahuase tlatzintla se huapali, se ipan sese ima. ");
INSERT INTO nheBl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Huan para iica tiopamitl campa temo tonati xiquinchihuili chicuase huapali. ");
INSERT INTO nheBl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Nojquiya xiquinchihuili ome huapali para yas iica tiopamitl oncac ipan icalnacastla. ");
INSERT INTO nheBl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Nopa huapali tlen yas icalnacastla, monequi tlatzquis ica tepos chijcoli tlatzintla huan huejcapa. ");
INSERT INTO nheBl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Huajca para iica oncas chicueyi huapali huan 16 icuatetoyo tlen plata, ome icuatetoyo para sesen huapali. ");
INSERT INTO nheBl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Nojquiya xiquinchihuili cuaixtlapali tlen cuahuitl acacia. Xiquinchihua macuili cuaixtlapali para nopa huapali ipan se caltechtli, ");
INSERT INTO nheBl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","huan seyoc macuili cuaixtlapali para nopa huapali ipan seyoc caltechtli. Huan xijchihua seyoc macuili para nopa huapali tlen yas campa temo tonati, iica tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Huan nopa cuaixtlapali tlen panos tlajco ipan ihuejcapanca nopa huapali monequi elis san se tlatectli cuahuitl huehueyac tlen ajsis se inacastla caltechtli hasta seyoc inacastla. ");
INSERT INTO nheBl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Huan xijxahua nopa miyac huapali huan nopa cuaixtlapali ica oro, huan xijchihua nopa anillos calteno campa calaquise nopa cuaixtlapali ica senquistoc oro. ");
INSERT INTO nheBl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Huan xijquetza nopa yoyon tiopamitl senquistoc queja nimitznextili nica tepeixco. ");
INSERT INTO nheBl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Nojquiya xijchihua se cortina ica lino icpatl tlen nelía canactzi huan icpatl tlen quipajtoque azultic, moradojtic huan chichiltic. Huan quema quixinepalohua nopa yoyomitl se yoyonchijquetl tlen cuali quimati itequi, ma ipan quixinepalos noelhuicac ejcahua na niimoTECO tlen inintoca querubines. ");
INSERT INTO nheBl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Huan xijpatlahuas nopa cortina huan tijcuapilos ica tepos chijcoli tlen oro ipan nahui tlaquetzali tlen cuahuitl acacia tlen tlaxahuali ica oro. Huan nopa tlaquetzali moquetzase ipan nahui cuatetomitl tlen plata. ");
INSERT INTO nheBl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Xijcuapilo nopa cortina itzala nopa tepos chijcoli. Huan iica nopa cortina xijtlali nopa caxa tlen quipiya notlanahuatilhua. Huan ni cortina quiiyocatlalis nopa achtohui cuarto Campa Tlatzejtzeloltic ica nopa seyoc cuarto tlen más calijtic tlen itoca Campa Más Tlatzejtzeloltic tlen quipiya nocaxa. ");
INSERT INTO nheBl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Huan ipan nopa caxa xijtlali itzajca campa nimechtlasojtlas quema innechixtzacuilise imotlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Huan ipan nopa achtohui cuarto tlen más calteno quema aya ticajsi campa nopa cortina, xijtlali nopa cuamesa ica norte. Huan ipan san se nopa cuarto ica sur, xijtlali nopa tlahuil quetzali iixmelac nopa cuamesa ");
INSERT INTO nheBl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Huan para campa ticalaquis ipan nopa achtohui cuarto ipan yoyon tiopamitl, xijchihua se cortina tlen tlaxinepaloli ica lino icpatl nelcanactzi huan ihuaya icpatl tlen azultic, moradojtic huan chichiltic. Ma quichihua se yoyonchijquetl tlen cuali quimati. ");
INSERT INTO nheBl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Huan nojquiya ni cortina xijcuapilo ica tepos chijcoli tlen senquistoc oro ipan macuili tlaquetzali tlen cuahuitl acacia tlen tijxahuas ica oro. Huan xijchihua macuili icuatetoyo tlen bronce tlen yas itzintla nopa macuili tlaquetzali. ");
INSERT INTO nheBl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Xijchihua se tlaixpamitl ica cuahuitl tlen itoca acacia. Huan elis cuadrado ica 2 metros huan 25 centímetros ihuehueyaca huan ipatlajca, huan quipiyas 1 metro huan 25 centímetros ihuejcapanca. ");
INSERT INTO nheBl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Huan ipan najcac iesquinajyo xijchihuili nahui icuacua tlen san se ininhuejhuexca. Xijsencahua ica san se tlatectli cuahuitl huan xijxahua ica nopa tepostli bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Nojquiya xijchihuili nochi tlen quitequihuise nopona. Xijchihuili tlen ipan quitemase cuanextli, huan itepos palas, huan nopa huajcali para quiselis estli, huan nopa tepos chijcoli para ica quiitzquise nopa nacatl, huan nopa tepostli para tlicoli. Huan nochi tijsencahuas ica bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Huan xijsencahuili se tlixictli tlen bronce ica ivarillas. Xijtlalili se anillo ipan sese inacastla para ica inquihuicase. ");
INSERT INTO nheBl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Huan xijsehui nopa tlixictli ipan nopa iteno tlen tlajco mocahua iijtico nopa tlaixpamitl, pampa ya nopa para ipan mosehuis tlixictli itzonpac campa oncas tlitl. ");
INSERT INTO nheBl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Nojquiya xijsencahua cuahuitl huehueyac para nopa tlaixpamitl para ica inquihuicase. Xijchihua ica cuahuitl acacia huan xijxahua ica bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Huan nopa cuahuitl huehueyac tlen inquisencahuase, xijcalaqui ipan nopa anillos ipan sesen lado tlen nopa tlaixpamitl para huelis inquihuicase. ");
INSERT INTO nheBl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Xijsencahua nopa tlaixpamitl ica huapali, huan ma mocahua cacahuatic iijtic campa tlipitzase. Huan xijsencahua nochi senquistoc queja nimitznextili nica ipan ni tepetl. ");
INSERT INTO nheBl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Nojquiya tijsencahuilis tlen elis queja se calixpamitl tlen quiyahualos nopa yoyon tiopamitl. Huan xijchihuili se tlatzactli tlen cortinas tlen lino yoyomitl. Huan ihuehueyaca nopa lado ica sur elis 45 metros. ");
INSERT INTO nheBl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Huan nopa lado quipiyas 20 itlaquetzalo tlen moquetzas ipan 20 inincuatetoyo tlen nopa tepostli bronce. Huan xijtatacatzos nochi nopa tlaquetzali ica plata tlen quipiya se ianillo. Huan nojquiya xijchihua tepos chijcoli ica plata para ica tijtlatzquiltis nopa anillos ipan tlaquetzali ica nopa icuatetoyohua. ");
INSERT INTO nheBl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Nopa tlatzactli tlen cortinas ica norte elis san se, 45 metros ihuehueyaca. Huan xijcuapilo nopa cortinas ipan 20 tlaquetzali tlen tijtatacatzos ica plata tlen quipiya se ianillo, huan moquetzas nopa tlaquetzali ipan 20 cuatetomitl. Huan nopa tepos chijcoli nojquiya xijchihua ica plata. ");
INSERT INTO nheBl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Huan nopa cortinas tlen quitzacuas iica nopa yoyon tiopamitl campa huetzi tonati quipiyas 22 metros huan tlajco ihuehueyaca. Huan xijcuapilo ipan 10 tlaquetzali tlen moquetzas ipan 10 cuatetomitl. ");
INSERT INTO nheBl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Huan iixmelac nopa yoyon tiopamitl campa quisa tonati, nojquiya tijpatlahuas cortinas tlen ihuehueyaca 22 metros huan tlajco. ");
INSERT INTO nheBl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Huan oncas cortinas ipan sesen lado campa tlapojtoc para calaquise. Ipan se lado nopa cortinas quipiyase 7 metros huan quicuapilose ipan eyi tlaquetzali tlen moquetzas ipan eyi cuatetomitl. ");
INSERT INTO nheBl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Huan ipan ne seyoc lado nojquiya nopa cortina quipiyas 7 metros huan quicuapilojtose ipan eyi tlaquetzali tlen moquetzas ipan eyi cuatetomitl. ");
INSERT INTO nheBl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Huan tlajco, campa tlapojtoc para calaquise, xijtlali se cortina tlen quipiyas 9 metros ihuehueyaca. Huan xijcuapilo nopa cortina ipan nahui tlaquetzali tlen moquetzas ipan nahui cuatetomitl. Huan nopa cortinas campa incalaquise monequi elis tlaxinepaloli ica lino icpatl tlen nelía canactzi ihuaya icpatl tlen azultic, moradojtic huan chichiltic. Huan quixinepalos se tlen tlahuel quimati itequi. ");
INSERT INTO nheBl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Huan tiquinixaltis ica plata nochi nopa tlaquetzali ipan nopa tlatzactli tlen cortinas yahualtic tlen nopa calixpamitl. Huan xijtatacatzos sesen tlaquetzali ica se tlatectli plata tlen quipiya ianillo. Nojquiya nochi nopa tlaquetzali quipiyase tepos chijcoli tlen plata, huan icuatetoyo tlen bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Huan nopa tlatzactli tlen quitzacuas nopa calixpamitl tlen quiyahualohua nopa yoyon tiopamitl quipiyas 45 metros ihuehueyaca, huan 22 metros huan tlajco ipatlajca. Huan nopa tlatzactli tlen cortinas quipiyas 2 metros huan 25 centímetros ihuejcapanca. Huan nopa cortinas xijchihua ica lino tlamalintli nelcanactzi. ");
INSERT INTO nheBl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Nochi tlamantzitzi tlen quitequihuise ipan nopa tequitl tiopan calijtic huan nochi tepos chijcoli para ipan quicuapilose nopa tlamantzitzi elis tlen bronce. Huan nopa estacas para nopa yoyon tiopamitl huan nopa tlatzactli tlen cortinas monequi xijchihua ica bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Huan xiquinnahuati nopa israelitame ma quihualicaca aceite tlen más cuali tlen quisa quema quitisij olivas. Huan inquitequihuise para tlahuili nochipa ma tlatlatos. ");
INSERT INTO nheBl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Huan nopa tlahuil quetzali moquetzas ipan nopa achtohui cuarto ipan nopa yoyon tiopamitl campa timopantise. Nopa cuarto eltoc iixmelac nopa cortina tlen quitzacua campa mocahua nopa caxa ipan nopa cuarto Campa Más Tlatzejtzeloltic. Huan Aarón huan itelpocahua quitlatise nopa tlahuili noixtla, na niimoTECO, sesen tiotlac. Huan tlatlatos hasta ica ijnaloc. Huan ni tlanahuatili monequi quichihuase israelitame huan iniixhuihua ama huan teipa. ");
INSERT INTO nheBl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Xijnotza ma huala moicni Aarón huan itelpocahua Nadab, Abiú, Eleazar huan Itamar para huelis tiquiniyocatlalis para na. Pampa niquintlapejpenijtoc ipan nochi israelitame para ma elica totajtzitzi tlen nechtequipanose. ");
INSERT INTO nheBl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Huan xijsencahuili moicni Aarón iyoyo tlen tlatzejtzeloltic para ica nechtequipanos. Huan iyoyo monequi elis nelía yejyectzi para nochi quitlepanitase pampa queja nopa quinamiqui ihueyitilis nopa hueyi tequitl tlen quichihuas noixtla. ");
INSERT INTO nheBl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Huan nochi tlacame tlen tlalnamiquij para tlasencahuase huan tlen niquinmacatoc yajatili, xiquinilhui ma hualaca para quichihuaquij Aarón iyoyo tlen quinextis para yajaya itztoc iyoca tlen sequinoc totajtzitzi, pampa yajaya elis nototajtzi para nechtequipanos. ");
INSERT INTO nheBl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","“Huan ya ni nopa yoyomitl tlen monequi quisencahuilise Aarón para moquentis: iyolixpantzajca, ipantzajca tlen ax quipiya imangas, iyoyo tlen huehueyac, ipaniyoyo ica itlachijchihualo, icuatzajca huan itzinquechilpica. Ma quichihuaca ni yoyomitl para moicni Aarón huan nojquiya ma quinchihuilica ininyoyo itelpocahua para huelis nechtequipanose queja nototajtzitzi. ");
INSERT INTO nheBl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Huan tlen quipiyaj tlalnamiquistli quichihuase ininyoyo ica piltepos cadenatzitzi tlen oro huan ica icpatl tlen azultic, moradojtic, huan chichiltic, huan quixinepalose ica lino icpatl tlen tlamalintli nelía canactzi. ");
INSERT INTO nheBl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Huan quichihuase nopa ixpantzajcayotl ica miyac piltlajco ilpicayotl tlen tlaxinepaloli tlen oro tlen nelcanactzi, huan icpatl tlen azultic, moradojtic huan chichiltic, huan ica lino icpatl tlamalintli nelcanactzi. Huan monequi quichihuase tlacame tlen nelía cuali quimatij tlasencahuaj. ");
INSERT INTO nheBl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Monequi iixpantzajcayo elis ome tlatectli tlen yoyomitl tlen moixnamiquis iajcolpa, huan iyolixco huan iica mocahuas se iyoyo. ");
INSERT INTO nheBl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Huan iixpantzajcayo huan itzinquechilpica monequi elis tlen san se tlaxinepaloli yoyomitl. Huan itzinquechilpica ica tlen quiilpis iyoyo elis yejyectzi tlasencahuali. Xijxinepaloca nopa yoyomitl ica piltlajco ilpicayotl tlen tlaxinepaloli ica oro tlen canactzi, huan icpatl tlen lino tlen tlamalintli nelía canactzi, huan icpatl tlen quipajtoque azultic, moradojtic huan chichiltic. ");
INSERT INTO nheBl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Huan xijcui ome piltetzitzi tlen itoca ónice huan ipani xijtejtequi huan xiquijcuilo inintoca nochi itelpocahua Israel. ");
INSERT INTO nheBl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Chicuase inintoca xijtejtequi ipan se tetl huan chicuase ipan ne seyoc tetl. Huan xiquijcuilo inintoca queja tlacajtiyajque. ");
INSERT INTO nheBl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Quema quitlalise nopa tocayotl ipan nopa tetl, monequi quitejtequise queja elisquía se sello. Huajca nopa ome tetini quipiyase nochi inintoca itelpocahua Israel. Huan itejteno sesen tetl xijsencahua ipiltencuayo tlen senquistoc oro tlen inquiyectlalijtoque. ");
INSERT INTO nheBl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Huan xijtlali nopa ome tetl iajcolpa nopa ixpantzajcayotl para nopa totajtzi nochipa quihuicas inintoca itelpocahua Israel iajcolpa para ma nechilnamiquiltijtinemi na, niimoTECO tlen inijuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Huan xijtlatzquiltis nopa piltetzitzi ipan oro. ");
INSERT INTO nheBl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Huan xijchihua ome piltlajco ilpicayotzitzi tlen tlaxinepaloli tlen oro tlen nelía canactzi. Huan nopa piltlajcoilpicayotzitzi quitlatzquiltise ipan ipiltencuayohua nopa ónice tetini iajcolpa. ");
INSERT INTO nheBl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Teipa ica miyac cuidado, xijchihuaca nopa yolixpantzajcayotl tlen quipiyas tlen inmechnextilis tlaque nopaquilis na, niimoTECO Dios. Huan xijtequihui nopa piltepos cadenatzitzi tlen oro, huan lino icpatl tlamalintli nelcanactzi, huan icpatl tlen quipajtoque azultic, moradojtic huan chichiltic queja tijtequihui ipan nopa ixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Monequi tijcuelpachos para tijchihuas se bolsa tlen ompamitl. Ihuehueyaca huan ipatlajca nopa bolsa elis 22 centímetros huan tlajco, pampa cuadradojtic. ");
INSERT INTO nheBl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Huan iixtla xijtlatzquiltili nahui pamitl ica piltetzitzi tlen yejyectzitzi. Ipan nopa achtohui pamitl xijtlatzquiltili se piltetzi tlen itoca rubí, se topacio huan se sardónice. Ya ni elis nopa achtohui pamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ipan nopa ompa pamitl, xijtlatzquiltili se esmeralda, se zafiro huan se diamante. ");
INSERT INTO nheBl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Huan ipan nopa expa pamitl xijtlatzquiltili se jacinto, se ágata huan se amatista. ");
INSERT INTO nheBl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Huan ipan nopa najpa pamitl xijtlatzquiltili se berilo, se ónice huan se jaspe. Nochi ni piltetzitzi monequi tlatzquitose ipan ininpiltencuayotzitzi tlen oro tlen mocahuas inintejteno huan inquiyecchihuase. ");
INSERT INTO nheBl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Huan imiyaca nopa piltetzitzi monequi elis queja imiyaca itelpocahua Israel, majtlactli huan ome. Huan sesen piltetzi quiixnextis se itelpoca Israel huan inquitejtequise ipan sesen tetl queja se pilsellojtzi tlen quipiyas san se itoca se itelpoca Israel. ");
INSERT INTO nheBl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Huan para quitatacatzos nopa yolixpantzajcayotl ipan nopa ixpantzajcayotl, xijchihuili piltlajco ilpicayotzitzi tlen tlaxinepaloli ica piltepos cadenatzitzi tlen canactzi huan senquistoc oro. ");
INSERT INTO nheBl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Huan teipa xijchihua ome anillos tlen oro, se ipan sesen iesquinajyo ica huejcapa ipan nopa yolixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Nopa ome piltlajco ilpicayotzitzi panose ipan nopa ome anillos tlen eltoc iajcoltipa nopa ixpantzajcayotl. Queja nopa xijtlatzquiltis nopa yolixpantzajcayotl ica nopa ixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Nojquiya ininyecapa nopa piltlajco ilpicayotzitzi moilpise ipan nopa anillos tlen eltoc iajcoltipa nopa ixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Teipa xijchihua seyoc ome anillos tlen oro huan xiquintatacatzo nopa ome esquinas tlen tlatzintla ipan nopa yolixpantzajcayotl, pero xiquintatacatzos nopa ome anillos itzala nopa yolixpantzajcayotl campa moteca ipan tlen quipantzacua. ");
INSERT INTO nheBl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Huan teipa xijchihua seyoc ome anillos ipan nopa ixpantzajcayotl, se ipan sesen lado iijtic nechca itzinquechilpica. ");
INSERT INTO nheBl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Huan teipa xiquilpi nopa anillos tlen tlatzintla ipan nopa yolixpantzajcayotl ipan ni anillos ipan nopa ixpantzajcayotl ica se listón azultic para nopa yolixpantzajcayotl ma motlali huan ma mocahua cuali ipan nopa ixpantzajcayotl campa itlajcoya huan ax papatlaca. ");
INSERT INTO nheBl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Huan yeca quema calaquis Campa Tlatzejtzeloltic Aarón nochipa huelis quihuicas inintoca itelpocahua Israel iyolixco ipan nopa iyolixpantzajcayo huan nechilnamiquiltis na, niimoTECO, tlen inijuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","“Huan iijtic nopa yolixpantzajcayotl campa ibolsa, xijtlali nopa Urim huan nopa Tumim, nopa dados tlatzejtzeloltic tlen na niimoTECO, tlen inquitequihuise quema monequis inquimatise ‘quena’ nopaquilis se tlamantli, o ‘axtle’. Huan Aarón quihuicas iyolixpa nopa Urim huan Tumim, nopa dados tlatzejtzeloltic tlen na niimoTECO, quema calaquis noixtla. ");
INSERT INTO nheBl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Huan xijchihua iyoyo huehueyac tlen senquistoc azultic tlen moquentis itzala nopa ixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Huan monequi xijquechtequis campa calaquis itzonteco nopa totajtzi. Huan campa quiquechtequise monequi quicuelpachose se quentzi huan quiyahualose ica icpatl para mochihuas se yejyectzi tlajtzontli tlayahualoli para ax tzayanis iquechtla. ");
INSERT INTO nheBl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Huan icuejtejteno nopa iyoyo huehueyac monequi xijchihua se tlajtzontli yejyectzi campa xiquixcopina nopa cuatlactli granada ica icpatl azultic, moradojtic huan chichiltic para ma quiyahualo icuejteno. Huan tlajco nopa granadas monequi xijcuapilojtiyas pilcampanajtzitzi tlen oro. ");
INSERT INTO nheBl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Monequi elis se pilcampanajtzi tlen oro huan teipa se granada tlajtzontli, teipa seyoc pilcampanajtzi tlen oro huan seyoc granada tlajtzontli, huan queja nopa yajtiyas ipan nochi itejteno. ");
INSERT INTO nheBl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Huan ya nopa moquentis Aarón quema nechtequipanos na, niimoTECO, calijtic Campa Más Tlatzejtzeloltic. Huan quema Aarón calaquis o quisas ipan nopa cuarto tzilinis nopa pilcampanajtzitzi tlen oro para ax miquis. ");
INSERT INTO nheBl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Nojquiya xijsencahua se tlatectli oro tlen canactzi queja se piltepos patlactzi queja se credencial huan ipan xijtejtequi se tlajcuiloli queja campa quisencahuaj se sello huan quiijtos: TLAIYOCATLALILI PARA TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Huan xiquilpi nopa piltepos patlactzi ica se listón azultic iixtla ipan icuatzajcayo. ");
INSERT INTO nheBl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Huan nopa piltepos patlactzi mocahuas cuapilijtos ipan icuaixco Aarón. Huan quema nopa israelitame quiiyocatlalise tlacajcahualistli para na huan quihualicase, intla aya senquistoc tlapajpactic nopa tlacajcahualistli noixtla na, niimoTECO, huajca Aarón ica nopa piltepos patlactzi huelis quihuicas inintlaixpanolhua tlen quiajsitoque nopa tlacajcahualistli. Huan niquitas nopa tlacajcahualistli tlen nopa israelitame nechmacase para tlatzejtzeloltic huan nijselis. Yeca Aarón monequi motlalilis nopa cuatzajcayotl ica nopa piltepos patlactzi nochipa quema calaquis tiopan calijtic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Huan xijchihuili ipaniyoyo nopa hueyi totajtzi tlen tlaxinepaloli ica icpatl tlen lino tlamalintli nelía canactzi. Huan nojquiya icuatzajcayo quichihuase ica lino, huan xijchihua itzinquechilpica huan ma quipiya itlachijchihualo tlen yejyectzi. ");
INSERT INTO nheBl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Huan nojquiya xiquinchihuili itelpocahua Aarón ininpaniyoyo, huan inintzinquechilpijca ica itlachijchihualo huan inincuatzajca. Huan ica nopa ininyoyo yejyectzi, nochi tlacame quintlepanitase. Nelía quinamiqui quipiyase ininhueyitilis ipampa nopa hueyi tequitl tlen quichihuase noixtla. ");
INSERT INTO nheBl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","“Huajca ica nochi ni yoyomitl xiquinyoyonti moicni Aarón huan itelpocahua. Teipa xiquinajalti ica aceite ipan inintzonteco huan xiquiniyocatlali para na. Huan queja nopa xiquintequimaca ma nechtequipanoca queja totajtzitzi. ");
INSERT INTO nheBl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Huan nojquiya xiquinchihuili inintlatzintlanyoyo ica nopa cuali yoyomitl lino para ma motlalilica tlatzintla nopa sequinoc ininyoyo. Huan quintzacuas tlen inintzinquechtla hasta ininmetztomahuiya. ");
INSERT INTO nheBl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Huan Aarón huan itelpocahua monequi moquentise quema calaquise tiopan calijtic para nechtequipanose, o quema monechcahuise campa nopa tlaixpamitl ipan nopa cuarto Campa Tlatzejtzeloltic. Huan intla moquentise tlen nimechilhuía, ax motlajtlacoltise huan miquise. Nochi ni tlanahuatili elis para Aarón huan itelpocahua para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Huan ya ni tlen monequi xijchihua para tiquiyocatlalis Aarón huan itelpocahua ma elica nototajtzitzi. Xijcui se becerro huan ome oquich borregojme tlen nelía cuajcualme huan ax tleno ax cuali quipiyaj. ");
INSERT INTO nheBl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Huan ica harina tlen trigo tlen ax quipiya tlasonejcayotl, xijchihua pantzi. Huan nojquiya xijchihua tortas tlen quipiya aceite. Huan xijchihua seyoc pantzi tlen nesis queja tlaxcali huactoc tlen tiquixajalos ica aceite. ");
INSERT INTO nheBl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Huan xijtema nochi ni pantzi ipan se chiquihuitl, huan xinechmaca na niimoTeco ipan tlaixpamitl ica nopa becerro huan nopa ome oquich borregojme. ");
INSERT INTO nheBl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Huan xijhualica Aarón huan itelpocahua ipan icalixpa nopa yoyon tiopamitl campa timopantise nechca campa calaquise, huan nopona xiquinpajpacas ica atl. ");
INSERT INTO nheBl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","“Huan xijcui nopa yejyectzi yoyomitl tlen inquisencahuilijtoque huan xijyoyonti Aarón ica nopa ixpantzajcayotl, nopa yolixpantzajcayotl, huan ica ipaniyoyo. Huan xiquilpi ipan nopa ixpantzajcayotl ica nopa tlajco ilpicayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Huan xijtlalis ipan itzonteco nopa cuatzajcayotl. Huan ipan nopa cuatzajcayotl xijtlali nopa piltepos patlactzi tlen oro tlen quiijtohua: TLAIYOCATLALILI PARA TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Huan xijcuis nopa aceite para tiquinajaltis tlacame huan tlamantli para tiquiniyocatlalis para na, niimoTECO, huan xicajalti ipan itzonteco Aarón para xiquiyocatlali para nechtequipanos na, niimoTeco. ");
INSERT INTO nheBl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Huan xiquinhualica itelpocahua huan xiquinyoyonti ica nopa yoyomitl tlen inquisencajque para inijuanti. ");
INSERT INTO nheBl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Huan xiquintlajcoilpi huan xiquintlalili inincuatzajca, huan inijuanti quiselise nopa tequitl ica nochi nopa tlanahuatili huan elise totajtzitzi noixtla para nochipa. Queja ni, huajca xiquiniyocatlali Aarón huan itelpocahua. ");
INSERT INTO nheBl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Xijhuica nopa becerro iixtla nopa yoyon tiopamitl, huan Aarón huan itelpocahua ma quitlalica ininma ipan itzonteco nopa becerro. ");
INSERT INTO nheBl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Teipa xijmicti nopa becerro noixtla na, niimoTECO, ipan nopa calixpamitl ipuertajteno campa calaquise nopa yoyon tiopamitl campa timopantise. ");
INSERT INTO nheBl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Huan xijcui se quentzi ieso nopa becerro huan xijtlali ica momacpil ipan nochi nahui icuacua nopa tlaixpamitl campa quitlatise tlacajcahualistli. Huan nopa estli tlen mocahuas, xijtoyahua nechca itzintla nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Teipa xijcui nochi nopa tlachiyajcayotl iijtico nopa becerro, huan tlen eltoc ipan ieltapach huan ipan ieyo, huan nochi ni tlachiyajcayotl huan nojquiya ieyo xijtlati ipan nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero inacayo nopa becerro, ica icuetlaxo huan icuitl, xijhuica huejca, campa ax onca caltini huan xijtlatiti. Huan ni becerro elis se tlacajcahualistli para tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Huan nojquiya xijcui se tlen nopa oquich borregojme, huan Aarón ihuaya itelpocahua ma quitlalica ininma ipan itzonteco. ");
INSERT INTO nheBl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Huan xijmicti nopa oquich chivo huan ieso xijtzejtzelo yahualtic tlaixpamitl ipan iquespa. ");
INSERT INTO nheBl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Huan inacayo nopa oquich borrego, xijhuejhuelos. Huan xijpajpaca icuitlaxcol huan imetz, huan xijtencahua ipan tlaixpamitl ihuaya itzonteco huan nopa sequin tlen tijhuejhuelojtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Huan xijtlatis nochi nopa oquich borrego ipan nopa tlaixpamitl. Huan ya ni elis se tlacajcahualistli tlatlatili para na, niimoTECO. Huan nelía ajhuiyac mijmiyotis huan nechpactis, pampa elis se tlacajcahualistli tlatlatili tlen innechmacaj ica tlitl. ");
INSERT INTO nheBl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Teipa xijcui nopa seyoc oquich borrego, huan Aarón huan itelpocahua quitlalise ininma ipan itzonteco. ");
INSERT INTO nheBl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Huan xijmicti nopa oquich borrego, huan xijcui quentzi ieso huan xijpolo itzintla ininnacas tlen ininnejmatl Aarón huan itelpocahua. Nojquiya xijpolo quentzi nopa estli ipan ininhueyi macpil huan ininhueyi xocpil tlen ininnejmatl. Huan xijtzejtzelo nopa estli yahualtic itejteno nopa tlaixpamitl Campa Quitlatise Tlacajcahualistli campa iquejquespa. ");
INSERT INTO nheBl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Huan xijcui quentzi nopa estli ipan tlaixpamitl huan quentzi nopa aceite tlen ica titlaiyocatlalía, huan xiquijtzelo ipan Aarón huan ipan iyoyo, huan ipan itelpocahua huan ipan ininyoyo nojquiya. Huan ica ya nopa Aarón huan itelpocahua huan ininyoyo elis tlatzejtzeloltic huan tlaiyocatlalili para na, niimoTeco. ");
INSERT INTO nheBl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Teipa xijquixtili ichiyajca nopa oquich borrego. Xijcui nopa tlachiyajcayotl campa icuitlapil, icuitlaxcol huan ieltapach. Huan xijcui nopa ome ieyo huan ininchiyajca, huan nopa imetz tlen inejmatl, pampa ica nopa tlacajcahualistli tlen nopa oquich borrego tiquintequitlalis Aarón huan itelpocahua para nechtequipanose. ");
INSERT INTO nheBl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Nojquiya xijcui se pantzi tlen nopa chiquihuitl tlen quipiya pantzi tlen ax quipiya tlasonejcayotl tlen eltoc noixtla na, niimoTECO. Huan nojquiya xijcui se torta tlen quipiya aceite huan se ne seyoc pantzi tlen nesi queja tlaxcali huactoc tlen inquiixajalojtoque ica aceite. ");
INSERT INTO nheBl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Huan nochi ni pantzi huan ichiyajca nopa borrego, xijtlali imaco Aarón huan ininmaco itelpocahua. Huan inijuanti quihuisose noixtla, niimoTECO, pampa ya nopa elis se tlacajcahualistli tlen inquihuisose noixtla para innechmacase. ");
INSERT INTO nheBl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Teipa xijcui tlen ininma nochi tlen quihuisojque noixtla huan xijtlali ipan nopa tlaixpamitl noixtla para se tlacajcahualistli tlatlatili. Huan nopa tlacajcahualistli mijmiyotis ajhuiyac huan nechpactis na niimoTECO. Ya ni elis se tlacajcahualistli tlatlatili tlen innechmacaj ipan tlitl. ");
INSERT INTO nheBl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Huan teipa xijcui iyolix nopa oquich borrego tlen ica tijtequitlalía Aarón para nechtequipanos, huan xijhuisos noixtla, nimoTECO, huan teipa nopa iyolix elis para ta, Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Huan nochipa quema tiquiniyocatlalis tlacame para ma elica totajtzitzi, Aarón huan itelpocahua quiselise iyolix huan imetz nopa borrego tlen quihuisojque noixtla para nechmacase. ");
INSERT INTO nheBl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Quena, ya ni elis se tlanahuatili para nochipa para xiquinmaca Aarón huan itelpocahua iyolix huan imetz se tlacajcahualistli. Amo quema ma quiilcahuaca israelitame para quinmacase ni nacatl nopa totajtzitzi, yonque temacaj se tlacajcahualistli para moyoltlalise nohuaya, niimoTECO, o temacaj se tlacajcahualistli para nechtlascamatilise. Ya ni quinamiqui quiselise totajtzitzi para iniaxca. ");
INSERT INTO nheBl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Huan nochi ni iyoyo Aarón tlen tlatzejtzeloltic teipa elis para nopa itelpoca tlen quitoquilis ipan itequi queja nopa hueyi totajtzi tlen más quipiya tequihuejcayotl. Huan queja nopa, ni yoyomitl panos tlen se itelpoca hasta se iixhui, huan hasta se iixhui itelpoca. Sesen tlen quiselis ni tequitl para elis hueyi totajtzi tlen ama quitocarohua Aarón, nojquiya quiselis ni yoyomitl tlen ihuaya yohui ni tequitl. Quiselise quema quiniyocatlalise sese ica aceite para quintequitlalise para nechtequipanose, niimoTeco. ");
INSERT INTO nheBl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Huan nopa itelpoca Aarón tlen quitocaros quiselis itequi teipa, monequi moquentis ni yoyomitl tlatzejtzeloltic para chicome tonali, huan teipa quena, huelis pehuas tequitis ipan nopa achtohui cuarto Campa Tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Huan xijcui inacayo nopa oquich borrego tlen tijtequihuijtoc para tiquiniyocatlalis Aarón huan itelpocahua, huan xijcacatzo campa tlapajpactic noixtla niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Huan Aarón huan itelpocahua quicuase inacayo nopa oquich borrego ihuaya nopa pantzi tlen eltos ipan nopa chiquihuitl ipan calixpamitl nechca campa calaquise ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Quena, san inijuanti huelis quicuase ni tlacajcahualistli tlen tijtequihui quema tiquiniyocatlali para ma nechtequipanoca na, niimoTECO. Axaca más hueli quicuas, san inijuanti, pampa nopa nacatl huan nopa pantzi tlaiyocatlalili, huan tlatzejtzeloltic para na. ");
INSERT INTO nheBl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Huan intla mocahuas quentzi pantzi o quentzi nacatl hasta hualmostla, monequi xijtlatis, ayoc huelis quicuase pampa tlaiyocatlalili para na. ");
INSERT INTO nheBl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Huajca para chicome tonali tiquinchihuilijtiyas Aarón huan itelpocahua nochi tlen nimitznahuatía para tiquiniyocatlalis ma nechtequipanoca. ");
INSERT INTO nheBl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ipan sesen tonal xinechmaca, niimoTECO, se becerro queja se tlacajcahualistli para nechixtzacuilis inintlajtlacolhua. Nojquiya xijpajpaca nopa tlaixpamitl noixtla ica se tlacajcahualistli tlen inquitencahuase ipani. Mojmostla xicalti nopa tlaixpamitl ica aceite para tiquiyocacahuas para na, niimoTeco. ");
INSERT INTO nheBl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Para chicome tonali xijtencahua tlacajcahualistli huan xijpajpacas nopa tlaixpamitl para elis tlahuel tlatzejtzeloltic, huan nochi tlen quiajsis nopa tlaixpamitl elis tlatzejtzeloltic, tlaiyocatlalili para na. ");
INSERT INTO nheBl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Huan teipa mojmostla xiquintencahua ipan nopa tlaixpamitl ome pilborregojtzitzi tlen quipiyaj sese xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Xijtencahua se pilborregojtzi ica ijnaloc huan se pilborregojtzi xinechmaca quema oncalaqui tonati. ");
INSERT INTO nheBl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Huan ica nopa pilborregojtzi ica ijnaloc, xijtencahua ome litros huan tlajco harina tlen más cuali tlaxacualoli ica se litro aceite tlen tlatejtejtzontli tlen olivas. Huan nojquiya xijtecas ipan tlaixpamitl se litro xocomeca atl. Ya nopa se tlacajcahualistli tlen quitoyahuase para nechmacase. ");
INSERT INTO nheBl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Huan ne seyoc pilborregojtzi xinechmaca, niimoTECO, ica tiotlac quema oncalaqui tonati. Huan nojquiya ma nechmacaca nopa harina queja quichijque ica nopa tlacajcahualistli tlen ica ijnaloc, huan ma nechmacaca xocomeca atl queja quitoyajque ipan tlaixpamitl ijnaloc. Huan ya ni elis se tlacajcahualistli para na tlen innechmacase ipan tlitl huan mijmiyotis ajhuiyac huan nechpactis. ");
INSERT INTO nheBl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ya ni elis nopa ome tlacajcahualistli tlen monequi inquichihuase mojmostla para ama huan teipa. Huan inquitencahuase noixtla na, niimoTECO, ni tlacajcahualistli ipan nopa tlaixpamitl campa tlatlatise ipan nopa calixpamitl nechca campa ipuerta ipan nopa yoyon tiopamitl campa timopantise. Huan nopona nimechcamahuis. ");
INSERT INTO nheBl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Quena, nopona nojquiya niquinnamiquis nopa israelitame. Huan nopa yoyon tiopamitl elis tlatzejtzeloltic pampa quipiyas notlatlanex. ");
INSERT INTO nheBl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Huajca niquiyocatlalis para na nopa tiopamitl campa timopantise, huan nopa tlaixpamitl campa tlatlatise. Huan niquiniyocatlalis Aarón huan itelpocahua para ma elica nototajtzitzi huan nochi elise tlatzejtzeloltique. ");
INSERT INTO nheBl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Huan na nimocahuas para niitztos tlatlajco israelitame huan na nielis niininTeco. ");
INSERT INTO nheBl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Huan inijuanti nechixmatise para na niDIOS niininTECO tlen niquinquixti ipan tlali Egipto para nimocahuas huan niitztos ininhuaya. Quena, na niDIOS, niininTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Nojquiya xijchihua se tlaixpamitl para ipan inquitlatise copali. Xijchihua ica nopa cuahuitl tlen itoca acacia. ");
INSERT INTO nheBl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Huan ihuehueyaca iixtla monequi elis 45 centímetros huan ipatlajca nojquiya 45 centímetros para elis cuadradojtic, huan ihuejcapanca elis 90 centímetros. Huan iixco nopa tlaixpamitl huan icuacua monequi elis san se tlatectli cuahuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Huan tiquixaltis ica oro ipani, huan ipan iquespa huan icuacua. Xijchihuili se icorona iixteno tlen senquistoc oro. ");
INSERT INTO nheBl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Nojquiya xijchihuili nahui anillos tlen oro, ome ipan sesen lado campa inacastla huan ne ome seyoc lado ipan seyoc inacastla. Huan ipan nopa anillos inquicalaquise nopa cuahuitl huehueyac para ica inquihuicase. ");
INSERT INTO nheBl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Huan xijsencahua nopa huehueyac cuahuitl ica nopa cuahuitl tlen itoca acacia, huan xiquixalti ica oro. ");
INSERT INTO nheBl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Huan ipan nopa achtohui cuarto Campa Tlatzejtzeloltic, xijtlali ni tlaixpamitl para copali. Xijquetza ni tlaixpamitl iixmelac nopa cortina tlen quitzacua nopa cuarto Campa Más Tlatzejtzeloltic campa eltoc nopa caxa ica nopa tlanahuatili huan itzajca campa timopantise. ");
INSERT INTO nheBl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Huan sese ijnaloc quema ajsis hora para Aarón quitejtequis imecha nopa tlahuili, monequi quitlatis copali tlen ajhuiyac ipan nopa tlaixpamitl para copali. ");
INSERT INTO nheBl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Huan nojquiya mojmostla quema tlayohuas huan Aarón quisencahuas nochi nopa tlahuili, quitlatis copali noixtla na, niimoTECO. Queja nopa oncas copali tlen tlatlas noixtla mojmostla para nochipa hasta imoixhuihua quipiyase iniixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ipan nopa tlaixpamitl para copali, amo xijtlati seyoc tlamantli copali, niyon amo xiquintlali tlapiyalime para tlatlase. Amo xijtlali tlacajcahualistli tlen harina, niyon amo xijtoyahua ipani nopa tlacajcahualistli tlen monequi tijtoyahuas. ");
INSERT INTO nheBl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Huan se huelta ipan se xihuitl Aarón quitlapajpacchihuas nopa tlaixpamitl para copali quema quitlalis ipan icuacua se quentzi ieso nopa tlacajcahualistli para nechixtzacuilis imotlajtlacolhua. Huan imoixhuihua huan iniixhuihua queja ni nojquiya quichihuase ipan ni tlaixpamitl para copali se huelta ipan se xihuitl. Ni tlaixpamitl para copali nelía tlatzejtzeloltic para na niimoTECO.” ");
INSERT INTO nheBl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Quema tijchihua se censo para tiquinpohuas nopa israelitame, sesen monequi quitlaxtlahuis TOTECO para quimanahuis iyolis. Queja nopa monequi para axaca miquis pampa tiquinpohua. ");
INSERT INTO nheBl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Quema mopohuase, sesen tlacatl monequi temacas se plata tomi tlen quipiya chicuase gramos ietica huan ya nopa elis se tlacajcahualistli para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Quena, nochi tlen ya quiaxitijtoque 20 xihuitl, monequi moijcuilose huan monequi temacase nopa tomi. ");
INSERT INTO nheBl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Yajaya tlen rico ax tlaxtlahuas más, niyon tlen teicneltzi ax tlaxtlahuas pilquentzi. Nochi nechmacase na, niimoTECO, nopa plata tomi tlen quipiya chicuase gramos ietica para quimanahuise ininyolis. ");
INSERT INTO nheBl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Huan tijcuis nopa tomi tlen temacatose israelitame para momanahuise, huan xijtequihui ipan itequi nopa yoyon tiopamitl campa timopantise. Ica ya ni, niimoTECO nimechilnamiquis huan innechixtzacuilise imotlajtlacolhua para huelis initztose.” ");
INSERT INTO nheBl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Nojquiya xijchihua se hueyi paila ica nopa tepostli bronce para ipan momajtequise totajtzitzi. Nojquiya xijchihuili ica bronce se tlen ipan moquetzas nopa hueyi paila. Huan xijquetza ipan nopa calixpamitl tlajco nopa tlaixpamitl campa quitlatise tlacajcahualistli huan nopa cortina tlen quitzacua nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Huan nopona momajtequise huan moicxipajpacase Aarón huan itelpocahua. ");
INSERT INTO nheBl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Huan sesen huelta quema calaquise ipan nopa yoyon tiopamitl campa timopantise, monequi momajtequise huan moicxipajpacase para ax miquise. Nojquiya quema monequis monechcahuise campa nopa tlaixpamitl para quichihuase inintequi huan quitlatise nopa tlacajcahualistli tlen nechtencahuilise na, niininTECO, ");
INSERT INTO nheBl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","monequi momajtequise huan moicxipajpacase para ma ax miquica. Huan ni tlanahuatili monequi mocahuas para nochipa para Aarón, iixhuihua huan ininteipa ixhuihua quineltoquilise.” ");
INSERT INTO nheBl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Xijsentili ni tlaajhuiyacayotl tlen nimitzilhuía tlen más cuali: Chicuase kilos tlen senquistoc mirra, eyi kilo canela, eyi kilo cálamo tlen mijmiyotía ajhuiyac, ");
INSERT INTO nheBl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","chicuase kilos tlen casia huan nahui litros aceite tlen itoca oliva. ");
INSERT INTO nheBl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Huan ma quisencahua nochi ya ni se tlaajhuiyacasencajquetl tlen cuali quimati itequi para ma elis nopa aceite tlen tlatzejtzeloltic tlen ica tlapojpohuase para tlaiyocatlalise para notequi na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Huan xijtequihui ni aceite para ticajaltis nopa yoyon tiopamitl campa timopantise, huan nopa caxa ica nopa tlanahuatili. ");
INSERT INTO nheBl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Nojquiya xicajalti nopa cuamesas huan nochi nopa tlamantzitzi tlen motequihuis nopona, huan xicajalti nopa tlahuil quetzali ihuaya nochi tlen motequihuis nopona, huan xicajalti nopa tlaixpamitl para copali. ");
INSERT INTO nheBl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Xicajalti nopa tlaixpamitl campa quitlatise tlacajcahualistli huan nochi tlamantli tlen motequihuía nopona. Nojquiya xicajalti nopa hueyi paila tlen bronce ihuaya tlen ipan moquetztoc. ");
INSERT INTO nheBl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Monequi tiquinajaltis para tiquiniyocatlalis para na huan queja nopa nochi elis tlahuel tlatzejtzeloltic, huan nochi tlen quiitzquise nopa tlamantzitzi elise tlatzejtzeloltique. ");
INSERT INTO nheBl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Nojquiya tiquinajaltis Aarón huan itelpocahua ica aceite, huan tiquiniyocatlalis para ma elica nototajtzitzi. ");
INSERT INTO nheBl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Huan xiquinilhui nopa israelitame: ‘Ni aceite elis para tlaajaltise quema quiiyocatlalise tlamantli o tlacame para elise para TOTECO. Ni aceite imotequilise para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Amo xijteca ipan tlen hueli tlacatl itlacayo. Huan axaca ma quisencahua seyoc tlaajhuiyacayotl senquistoc san se queja tlasencahuali ya ni. Ni aceite tlatzejtzeloltic, huan monequi inquiitase para se tlamantli tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Intla se acajya quisencahuas se tlaajhuiyacayotl queja ni, o intla se acajya quipolos se tlen ax se nototajtzi, monequi inquiquixtise tlen israelitame para nochipa.’” ");
INSERT INTO nheBl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Nojquiya TOTECO quicamahui Moisés huan quiilhui: “Xijmanelo se tlaajhuiyacayotl ica san se imiyaca tlachipimitl tlen aceite tlen resina, tlen istitl huan tlen gálbano tlen ajhuiyac mijmiyotía, huan nochi xijmanelo ihuaya nopa copali tlen senquistoc cuali. ");
INSERT INTO nheBl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Huan ica ni tlamantli ma quisencahua se copali tlen senquistoc cuali. Ma quimanelo nelía cuali queja quimati quichihua se tlaajhuiyacasencajquetl tlen cuali quimati itequi. Huan ni copali elis tlatzejtzeloltic san para na, niimoTeco. ");
INSERT INTO nheBl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Xijtijtisi cuali se quentzi ni tlamaneloli hasta nelía cuechtic mocahuas, huan xijtlali iixtla nopa caxa tlen quipiya notlanahuatil ipan nopa yoyon tiopamitl campa timopantise. Huan monequi xijmatica ni tlamaneloli copali eltoc tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Axaca ma quisencahua seyoc copali tlen senquistoc san se tlasencahuali queja ni pampa ni tlamaneloli copali tlatzejtzeloltic para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Intla se acajya quichihuas seyoc queja ni san para quiijnecuis, monequi inquimictise.” ");
INSERT INTO nheBl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Huajca TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Xiquita, na nijtlapejpenijtoc Bezaleel tlen icone Uri huan iixhui Hur tlen tlacatqui ipan nopa hueyi familia tlen iixhuihua Judá. ");
INSERT INTO nheBl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nijtemitijtoc Bezaleel ica Notonal. Huan nijmacatoc miyac yajatili huan tlamachilistli para huelis quichihuas nopa yoyon tiopamitl ica nochi tlamantli tlen monequi. ");
INSERT INTO nheBl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Yajaya cuali quimati quitepachos oro, plata huan bronce para quichihuas tlen hueli tlen monequi. ");
INSERT INTO nheBl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Nojquiya hueli quiyejyectlalis piltetzitzi tlen patiyo para ma tlahuía huan quimati quejatza quiquejquetzas piltetzitzi sese ipan se piltencuayotl para mocahuas yejyectzitzi. Nojquiya ya hueli quitejtequis cuahuitl huan quiyectlalis para elis queja tlen hueli tlamantli tlen tiquilhuis. ");
INSERT INTO nheBl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Nojquiya nijtlapejpenijtoc Aholiab, icone Ahisamac ipan nopa hueyi familia tlen iixhuihua Dan, para elis itlapalehuijca. Huan nochi sequinoc tlen achi más quipiyaj inintlalnamiquilis para quichihuase tlamantzitzi tlen yejyectzitzi, nojquiya niquinmacatoc ininyajatil para ma quichihuaca nochi tlen nimitznahuatijtoc. ");
INSERT INTO nheBl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Huajca inijuanti hueli quichihuase nopa yoyon tiopamitl campa timopantise, huan nopa caxa campa eltoc notlanahuatilhua, huan itzajca nopa caxa campa nimechtlasojtlas huan innechixtzacuilise imotlajtlacolhua. Nojquiya quichihuase nochi nopa tlamantzitzi tlen motequihuis ipan nopa tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Quichihuase nopa cuamesas huan tlen motequihuis nopona. Nojquiya quichihuase nopa tlahuil quetzali tlen senquistoc oro ica nochi tlen motequihuis ihuaya, huan quisencahuase nopa tlaixpamitl para copali. ");
INSERT INTO nheBl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Quichihuase nopa tlaixpamitl campa quitlatise tlacajcahualistli ica nochi tlamantzitzi tlen motequihuis. Nojquiya quichihuase nopa hueyi paila huan tlen ipan quiquetzase huan nochi tlen motequihuis ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Nojquiya quixinepalose iyoyo tlatzejtzeloltic nopa totajtzi Aarón huan quichihuase ininyoyo itelpocahua. ");
INSERT INTO nheBl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Huan quema quichihuase nopa aceite tlen ica intlaajaltise para intlaiyocatlalise para na huan quema quichihuase nopa copali tlen ajhuiyac mijmiyotía para quitlatise ipan nopa tlaixpamitl para copali, monequi nochi mochihuas senquistoc queja nimitznahuatijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Xiquinilhui nopa israelitame para monequi ma ax tequitica ipan nopa tonal tlen nimechnahuati. Pampa nopa tonal elis queja se tlanextilijcayotl para inmechilnamiquiltis imojuanti huan imoixhuihua tlen imohuaya nimocajtoc. Huan queja nopa elis para nochipa hasta imoixhuihua teipa ehuani quipiyase iniixhuihua. Queja nopa inquimatise para na niimoTECO tlen nimechchihua intlatzejtzeloltique. ");
INSERT INTO nheBl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Huajca monequi ma mosehuica ipan nopa tonal tlen nimechilhui pampa nopa tonal tlatzejtzeloltic huan tlaiyocatlalili para na. Intla se ax quitlepanita ni tlanahuatili, monequi inquimictise. Intla se tequitis ipan se tonal para inmosiyajcahuase, xijmictica. ");
INSERT INTO nheBl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Chicuase tonali intequitise, pero ipan nopa chicompa tonal monequi inmosehuise pampa tlatzejtzeloltic huan tlaiyocatlalili para na, niimoTECO. Intla se acajya tequitis ipan nopa tonal, monequi miquis. ");
INSERT INTO nheBl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Nochi israelitame ama huan ininteipa ixhuihua ma ax tequitica ipan nopa tonali para mosiyajcahuase. Monequi quitlepanitase nopa tonali pampa quinextía nopa tlajtoli tlen nijchijtoc imohuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ni tlamantli elis se tlanextilijcayotl para nochipa ica inisraelitame huan na, pampa ica chicuase tonali na, niimoTECO, nijchijqui elhuicactli huan tlaltepactli, huan ipan nopa chicompa tonal, ayoc nitequitqui, san nimosehuijqui.” ");
INSERT INTO nheBl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Huan quema TOTECO tlanqui camati ihuaya Moisés ipan nopa tepetl Sinaí, quimacac ome tepatlactli campa ijcuilijtoc itlanahuatilhua. Huan Toteco Dios quiijcuilojtoya ica ya ima. ");
INSERT INTO nheBl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Quema nopa israelitame quiitaque para Moisés huejcahuayaya huan ax nimantzi temoyaya tlen nopa tepetl, mosentilijque campa Aarón huan quiilhuijque: ―Xitechchihuili se tlaixcopincayotl para ma techyacana pampa ax tijmatij tlaque ipantitoc Moisés tlen techquixti ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Huan Aarón quinilhui: ―Ma moquixtilica ininpijpilolhua imosihuajhua, imotelpocahua huan imoichpocahua; huan ma nechhualiquilica nica. ");
INSERT INTO nheBl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Huajca nochi moquixtilijque ininpijpilolhua huan quihuiquilijque Aarón. ");
INSERT INTO nheBl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Huan yajaya quiseli huan quiatili nopa oro, huan quema quiquixti ipan tlitl, quitejtzonqui ica se martillo huan quichijqui queja se becerro. Huajca nopa israelitame quiijtojque: ―¡Xitlacaquica inisraelitame, ya ni todios tlen techquixti ipan tlali Egipto! ");
INSERT INTO nheBl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Huan quema Aarón quiitac quejatza paquiyayaj nopa israelitame, quisencajqui se tlaixpamitl iixtla nopa becerro, huan teyolmelajqui: ―Mostla tijpiyase se ilhuitl para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Huan hualmostla nochi israelitame mejque cualca huan quinmictijque tlapiyalime huan quintlatijque ipan nopa tlaixpamitl, huan quimacaque tlacajcahualistli para Toteco ma moyoltlali ininhuaya. Teipa nochi mosehuijque ipan se hueyi tlacualistli huan tlacuajque huan tlaique queja ax monequi. Huan teipa nochi quichihuayayaj tlen fiero queja tlen quichihuaj tlen hueli tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Huajca TOTECO quiilhui Moisés: ―Xitemo amantzi tlen ni tepetl, pampa motlacajhua tlen tiquinquixti tlen tlali Egipto monenpolojtoque. ");
INSERT INTO nheBl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nimantzi quicajtejque nopa tlanahuatili tlen niquinnahuati ma quitoquilica. Quiatilijque oro huan mochihuilijque se becerro huan amantzi quihueyichihuaj huan quimactilíaj tlacajcahualistli, huan quiijtohuaj: ‘Inisraelitame, ya ni imodios tlen inmechquixti ipan tlali Egipto.’ ");
INSERT INTO nheBl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nojquiya TOTECO quiilhui Moisés: ―Nimomacatoc cuenta quejatza itztoque ni tlacame huan niquita para nelyoltetique. ");
INSERT INTO nheBl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Huajca ama xinechcahua, pampa nelía tlahuel nicualani ininhuaya huan niquintzontlamiltis, pero tlen ta, Moisés, niquinchihuas sequinoc tlacame tlen momiyaquilise tlahuel miyac huan itztose ipan se hueyi tlali. ");
INSERT INTO nheBl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pero Moisés chicahuac quitlajtlani ITECO Dios ma amo quichihua, quiijto: ―¡Ay TOTECO! ¿Para tlen ticualanis ica motlacajhua tlen ta tiquinquixti ipan tlali Egipto ica mohueyi chicahualis? ");
INSERT INTO nheBl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nopa egiptome quiijtose para ta tlen tiininTeco tiquinquixti ipan tlali Egipto, pampa ya timoilhuiyaya para tiquinmictis ipan tepetini, pampa tijnequiyaya tiquinixpolihuiltis tlen ni tlaltepactli. TOTECO, ax hueli tiquincahuilise egiptome ma quiijtoca ya nopa. Yeca ayoc xicualani. Ximoyolcuepa ica tlen timoilhuijtoc tijchihuas huan amo xiquincoco motlacajhua. ");
INSERT INTO nheBl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Xiquinilnamiqui Abraham, Isaac, huan Israel motequipanojcahua tlen ta timotestigojquetzqui ica moselti huan tiquinilhui tiquinmiyaquilis iniixhuihua para ma elica tlahuel miyaqui hasta axaca huelis quinpohuas. Tiquijto itztose queja imiyaca sitlalime nepa elhuicac. Huan nochi ni tlali tiquinmacas iniixhuihua. Huan tiquijto quiselise huan elis iniaxca para nochipa. Quena, queja nopa tiquintencahuili motequipanojcahua. ");
INSERT INTO nheBl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Huajca TOTECO moyolcuepqui ica tlen moilhuijtoya quinchihuilisquía itlacajhua. ");
INSERT INTO nheBl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Huan Moisés pejqui temo tlen nopa tepetl, huan quihualicayaya imaco nopa ome tepatlactli tlen quipixtoya nopa tlanahuatili. Huan itlanahuatilhua Toteco ijcuilijtoya iixtla huan iica nopa tepatlactli. ");
INSERT INTO nheBl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Yajaya Toteco Dios tlen quitejtejqui nopa tetl huan quichijqui nopa tepatlactli huan yajaya tlen ipan tlajcuilo. ");
INSERT INTO nheBl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Huan quema Josué quicajqui tlahuejchihuayayaj nopa israelitame nopona tlatzintla, quiilhui Moisés: ―Nijcaqui tlahuejchihuaj campa itztoque nopa tlacame queja onca se tlatehuijcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pero Moisés quinanquili: ―Ax tlahuejchihuaj pampa tlatlantoque, niyon ax quichihuaj pampa sequinoc quintlantoque. Nijcaqui tlen huicaj seyoc tlamantli huicatl. ");
INSERT INTO nheBl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Huan quema Moisés monechcahuiyaya campa itztoyaj nopa israelitame, quiitac nopa becerro huan quejatza mijtotiyayaj, huan nelía cualanqui. Huan quimajcajqui itzintla tepetl nopa tepatlactli tlen quihuicayaya imaco huan cuechtic mocajqui. ");
INSERT INTO nheBl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Huan quicuic nopa becerro tlen quichijtoyaj huan quitlati, huan quitisqui hasta quichijqui tlatixtic. Huan nopa itlatixo quiijtzelo ipan atl, huan quinchihualti nopa israelitame ma quiica nopa atl. ");
INSERT INTO nheBl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Huan Moisés quiilhui Aarón: ―¿Tlaque mitzchihuilijque ni tlacame para tiquinyacantoc ma quichihuaca ni tlajtlacoli nelhueyi? ");
INSERT INTO nheBl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Huan Aarón tlananquili: ―Amo xicualani nohuaya, tata. Ta cuali tijmati ni tlacame quinpactía quichihuase tlen ax cuali. ");
INSERT INTO nheBl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Inijuanti nechilhuijque ma niquinchihuili se tlaixcopincayotl para ma techyacanas pampa ax tijmatque tlaque mopantic ta tlen titechquixti ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Huan na niquinnanquili para intla quipiyaj tlamantli tlen oro, ma quiquixtica huan inijuanti nechmacaque. Huan nijtlali nopa oro ipan tlitl huan quisqui ni becerro. ");
INSERT INTO nheBl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Huan Moisés quiitac para nochi quipolojtoyaj ininpinahualis. Huan Aarón quincahuilijtoya ma quichihuaca tlen hueli tlen quinequiyayaj quichihuase. Huan quiitac inincualancaitacahua quinhuetzquiliyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Huajca moquetzqui iixmelac campa calaquiyayaj ipan ipejya nopa altepetl tlen ininyoyoncalhua. Huan Moisés quiijto: ―Nochi tlen itztoque ica TOTECO ma hualaca nica nohuaya. Huan nochi iixhuihua Leví mosentilijque ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Huajca Moisés quinilhui tlen moiyocatlalijtoyaj ica ya: ―TOTECO Dios tlen tiisraelitame quiijtohua para sesen imojuanti monequi xijcuica imomachete, huan xipehuaca ipan nopa achtohui caltini huan xipanotiyaca hasta campa ontlami nochi ni yoyoncaltini. Huan xicalaquica ipan sesen yoyoncali huan xiquinmijmictijtiyaca yonque imoicnihua, imohuampoyohua o imocalnechcahua pampa tlahuel fiero quichijtoque. ");
INSERT INTO nheBl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Huan iixhuihua Leví quichijque queja Moisés tlanahuatijtoya huan ipan nopa tonal mijque nechca eyi mil tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Huajca Moisés quinilhui: ―Ama inmoiyocatlalijque para itequi TOTECO pampa inquineltocatoque tlen inmechnahuatijtoc, yonque monejqui inquintzontlamiltijque imoconehua huan imoicnihua. Huajca ama TOTECO inmechtiochihuas. ");
INSERT INTO nheBl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Huan hualmostla Moisés quinilhui ne sequinoc israelitame: ―Inquichijtoque se hueyi tlajtlacoli. Ama monequi niyas huan nitlejcos campa itztoc TOTECO huan intla nihuelis nimechixtzacuilis imotlajtlacol. ");
INSERT INTO nheBl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Huajca Moisés mocuepqui campa itztoya TOTECO, huan quiilhui: ―Melahuac nopa tlacame quichijtoque se hueyi tlajtlacoli huan mochihuilijque se tlaixcopincayotl tlen oro. ");
INSERT INTO nheBl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Na nimitztlajtlanía chicahuac xiquintlapojpolhui. Intla axtle, nojquiya xinechmicti na, huan xiquixpolo notoca ipan nopa amatlapohuali tlen tiquijcuilo. ");
INSERT INTO nheBl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Pero TOTECO quinanquili Moisés: ―San niquixpolos itoca huan nijmictis tlen noca na tlajtlacolchihua. ");
INSERT INTO nheBl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Huajca xiya xiquinhuica nopa tlacame hasta campa nimitzilhui. Huan xijmati para temachtli noelhuicac ejca mitzyacanas. Pero quema ajsis nopa tonali quema nitetlatzacuiltis, niquintlatzacuiltis ni tlacame ipampa inintlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Huan TOTECO quititlanqui se tlatzacuiltijca cocolistli ipan nopa tlacame pampa quihueyichijque nopa becerro tlen Aarón quichijqui. ");
INSERT INTO nheBl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Huan TOTECO quiilhui Moisés: ―Xiquisa tlen nica huan xiquinyacana nopa tlacame tlen tiquinquixti tlali Egipto, huan xiquinhuica hasta nopa tlali tlen niquintencahuili Abraham, Isaac huan Jacob para niquinmacas iniixhuihua. ");
INSERT INTO nheBl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Huan nijtitlanis se elhuicac ejquetl ma mitzyacana, huan yajaya quinquixtis tlen nopa tlali nopa cananeos, amorreos, heteos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nheBl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Huan inmechhuicas ipan nopa tlali tlen nochi temaca hasta mocahua itlajca. Pero na ax niyas imohuaya, pampa nohueli nimechixpolihuiltis ipan ojtli, pampa tlahuel tetic imoyolo. ");
INSERT INTO nheBl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","5","Huan TOTECO quiilhui Moisés: ―Xiquinilhui nopa israelitame para inijuanti nelía yoltetique. Xiquinilhui intla niitztosquía ininhuaya seyoc tlalochtli, huelis niquintlamiixpolihuiltijtosquía. Huajca xiquinilhui ma moquixtilica nochi nopa tlayejyecchijchijcayotl tlen oro tlen quihualicaj queja pactoque, huan niquitas tlaque nijchihuas ica inijuanti. Huan tlahuel miyac mocuesojque nopa israelitame quema quicajque ni tlajtoli tlen chicahuac. Huan nochi moquixtilijque ininyejyecchijchijca tlen oro huan ininyoyo tlen yejyectzitzi para ma ax nesis queja pactoque, pampa ayoc paquiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Huajca ipan tepetl Horeb nopa israelitame moquixtilijque ininpijpilolhua, inincoshua, huan nochi tlen ica mocualtlaliyayaj para moyejyecchijchihuase. Huan ayoc quitequihuijque. ");
INSERT INTO nheBl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Huan Moisés ya momajtoya quiiyocaquetza se yoyoncali se quentzi huejca tlen ininyoyoncalhua nopa israelitame. Huan quitocajti nopa yoyoncali campa timopantise ihuaya TOTECO. Huan quema acajya quinequiyaya quitlajtlanis TOTECO se tlenijqui para quimatis ipaquilis, yahuiyaya ipan nopa yoyoncali campa mopantis ihuaya TOTECO tlen eltoya iyoca tlen ne sequinoc yoyoncaltini. ");
INSERT INTO nheBl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Huan tlen hueli hora quema Moisés yahuiyaya para mopantiti ihuaya TOTECO, nochi tlacame momatque quisaj ininchajchaj huan moquetzaj ininpuertajteno huan quitlachilíaj Moisés hasta quema oncalaquiyaya ipan nopa yoyoncali. ");
INSERT INTO nheBl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Huan sesen huelta quema Moisés calaquiyaya ipan nopa cali, nopa mixtli hualtemoyaya huan motlaliyaya ipuertajteno quema TOTECO camatiyaya ihuaya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Huajca quema nopa israelitame quiitaque nopa mixtli moquetztoya ipuertajteno nopa yoyoncali, sese inijuanti motlancuaquetzayaya icalixpa huan quihueyichijque Toteco. ");
INSERT INTO nheBl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Huan TOTECO quicamahui Moisés moixtlachiliyayaj queja se tlen camati ihuaya ihuampo. Huan teipa Moisés mocuepayaya campa ne sequinoc yoyon caltini. Pero nopa telpoca tlacatl Josué, itelpoca Nun tlen quipalehuiyaya Moisés, mocahuayaya nopona ipan nopa yoyoncali campa mopantíaj ihuaya TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Huan Moisés quiilhui TOTECO: ―Xiquita, tinechilhuía ma niquinyacana ni israelitame hasta nopa cuali tlali, pero ax tinechilhuía ajqueya tijtitlanis nohuaya. Nojquiya tiquijtohua para cuali tinechixmati huan tinechcualitztoc. ");
INSERT INTO nheBl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ama nimitztlajtlanía se favor. Intla nelía tinechcualitztoc, xinechilhui tlaque mopaquilis para nijchihuas huan queja nopa más huelis nimitzixmatis. Huan na nimitzneltocas huan noja tinechcualitztinemis. Huan xiquilnamiqui para ni tlacame tlen niquinyacana, nochi timoaxcahua. ");
INSERT INTO nheBl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Huan TOTECO quinanquili: ―Na, niimoTECO, niyas mohuaya huan nijchihuas para ximosiyajcahua. ");
INSERT INTO nheBl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Huan Moisés quiijto: ―Intla ax tohuaya tiyas, amo xitechchihua ma tiquisaca tlen nica. ");
INSERT INTO nheBl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Pampa intla ax tohuaya tiyas, sequinoc tlacame ax quimatise para titechicnelía, na huan ni motlacajhua. Intla ta ax tohuaya tiyas, huajca san se tiitztose queja tlen hueli tlacame. Pero intla ta tiyas tohuaya, nesis titechtlapejpenijtoc huan titechiyocatlalijtoc tlen nochi sequinoc tlacame ipan ni tlaltepactli. ");
INSERT INTO nheBl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Huan TOTECO quiilhui Moisés: ―Huajca nijchihuas tlen tiquijtojtoc pampa nijmati tijchihuas tlen cuali, huan ta nimitzitas para tinonelhuampo. ");
INSERT INTO nheBl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Huajca Moisés quiijto: ―Huajca nimitztlajtlanía, xinechcahuili ma nimitzitas ta ica nochi motlatlanex tlen yejyectzi. ");
INSERT INTO nheBl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Huan TOTECO quinanquili: ―Na nijchihuas ma panos moixtla nochi tlen cuali tlen na. Huan quema nipanos, niquijtos tlen quiijtosnequi notoca, TOTECO. Na nijtlapejpenía catlía nijtlasojtlas huan catlía ihuaya nijpiyas hueyi noyolo. ");
INSERT INTO nheBl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pero noxayac ax huelis tiquitas, pampa niyon se tlacatl ax huelis quiitas noxayac huan itztos. ");
INSERT INTO nheBl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Huajca TOTECO quiilhui: ―Nica nonechca eltoc se hueyi tetl, nopona ximoquetza ipani. ");
INSERT INTO nheBl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Huan na nimitztlalis campa tlacoyontoc ipan nopa hueyi tetl, huan quema nipanos huan nesis notlatlanex nimitzixtzacuas ica noma hasta ya nipanotos. ");
INSERT INTO nheBl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Teipa niquijcuenis noma, huan huelis tiquitas nocuitlapa, pero noxayac ax tiquitas. ");
INSERT INTO nheBl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Huan TOTECO quiilhui Moisés: ―Xijtejtequi ome tepatlactli tlen san cuali ihuejhuexca queja nopa achtohui tepatlactli tlen nimitzmacac. Huan ipani niquijcuilos nopa tlajtoli tlen quipixtoya nopa sequin tlen tijtlatlapatzqui. ");
INSERT INTO nheBl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Nojquiya ximocualtlali para mostla cualca titlejcos ipan tepetl Sinaí. Xihuala ximonextiqui noixtla itzonpac nopa tepetl. ");
INSERT INTO nheBl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ma amo aca tlejcos mohuaya huan ma amo aca más itztos ipan nopa tepetl. Niyon se tlapiyali ax hueli tlacuajcuajtinemis iteno nopa tepetl. ");
INSERT INTO nheBl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Huajca Moisés quitejtejqui nopa ome tepatlactli san se queja nopa tlen achtohui. Huan hualmostla cualca mejqui, huan quicuic nopa ome tepatlactli imaco huan tlejcoc ipan tepetl Sinaí queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Huajca TOTECO temoc ipan se mixtli huan moquetzqui ihuaya Moisés, huan quiyolmelajqui tlaque quinequi quiijtos itoca, TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Huan TOTECO panoc iixtla Moisés huan quiijtojtiyajqui: ―Na niDIOS, moTECO. Na tlen nitetlasojtla huan nijpiya hueyi noyolo ica tlacame. Ohui para nicualanis, pampa tlahuel niteicnelía. Huelis timotemachis ipan na pampa senquistoc nitemachtli. ");
INSERT INTO nheBl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Niquinnextilis tlahuel onpano miyac tlacame quejatza niquinicnelía, pampa niquintlapojpolhuía inintlajtlacolhua quema nechhuejcamajcahuaj huan nechixpanoj. Pero intla se acajya tlajtlacolchihua, ax niquijtohua para ax tleno quichijtoc. Nijtlatzacuiltía ipampa itlajtlacol, huan nojquiya niquintlatzacuiltis iconehua, huan iixhuihua, huan hasta iixhuihua ininconehua ipampa nopa tlen fiero yajaya quichijqui. ");
INSERT INTO nheBl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Huajca Moisés nimantzi mohuijtzonqui tlalchi, huan quihueyichijqui TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Huan Moisés quiijto: ―Toteco, intla ama tinechcualitztoc, xiya tohuaya huan xitechyacana, pampa nelía ni tlacame yoltetique. Pero xitechtlapojpolhui totlaixpanolhua huan totlajtlacolhua, huan xitechseli para ma tielica timoaxcahua para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Huan TOTECO quinanquili: “¡Cualtitoc! Ya ni nopa tlajtolsencahuali tlen ica nimocahuas imohuaya. Imoixtla nochi innotlacajhua nijchihuas huejhueyi tlanextilijcayotl queja tlen ax quema mochijtoc ipan niyon se tlali ipan nochi ni tlaltepactli. Huan quiitase nohueyi chicahualis nochi nopa tlacame tlen mohuaya itztoque. Quiitase tlen na, niimoTECO, hueli nijchihua pampa temajmati nopa hueyi tlamantli tlen nijchihuas ica ta. ");
INSERT INTO nheBl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Mitztocarohua ta ipan ni tlajtolsencahuali tlen tijchihuaj san sejco para ta xijchihua tlen nimitznahuatijtoc ama, huan na imoixtla niquinquixtijtiyas tlen imotlal nopa amorreos, cananeos, heteos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nheBl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","“Pero ximomocuitlahuica para amo xijchihuaca niyon se tlajtoli ininhuaya tlacame tlen itztoque ipan nopa tlali campa incalaquise para initztotij. Intla inmomatise ininhuaya, inmechmajcahuase ipan tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Pero quena, xijhuelonica nochi nopa tlaixpamitl tlen iniaxca, huan xijtlamitlatlapatzaca ininteteyohua. Huan xijtzontequica nopa fiero tlaquetzali ica nopa tlaixcopincayotl Asera tlen inijuanti quinhueyichihuaj. ");
INSERT INTO nheBl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Ax quema ximotlancuaquetzaca o xijhueyichihuaca seyoc queja elisquía se dios. Na niimoTECO huan nechtocajtíaj nopa DIOS TLEN TETLASOMATI, pampa nimechtlasomati huan nijnequi san na xinechhueyichihuaca. ");
INSERT INTO nheBl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Yeca amo xijchihuaca niyon se tlajtoli ica nopa tlacame tlen itztoque ipan nopa tlali. Huan quema inijuanti quinhueyichihuase huan quintencahuilise tlacajcahualistli inintlaixcopincayohua, huan motemacase iniixpa queja tlacanenca sihuame, nojquiya inmechnotzase para xiyaca ininhuaya. Pero nimechilhuía, amo xiyaca. Amo ximomatica ica inijuanti pampa huelis inquinhueyichihuase inintlaixcopincayohua huan inquicuase inintlacajcahualis. ");
INSERT INTO nheBl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Imotelpocahua ax hueli mosihuajtise ica iniichpocahua pampa nopa ichpocame quinhueyichihuase inintlaixcopincayohua tlen ax neli dios huan quinchihualtise imotelpocahua nojquiya san se ma quichihuaca. ");
INSERT INTO nheBl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Ax quema xijchihuaca niyon se tlaixcopincayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Monequi xiilhuichihuaca ipan nopa ilhuitl tlen pantzi tlen ax quipiya tlasonejcayotl. Monequi para chicome tonali inquicuase nopa pantzi tlen ax quipiya tlasonejcayotl queja nimitznahuatijtoc. Xijchihuaca ni ilhuitl ipan nopa tonal tlen nimitzilhui ipan metztli Abib, pampa ipan nopa metztli inquisque tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Nochi tlen achtohui ehua elis noaxca. Elis noaxcahua nochi iniachtohui oquich conehua imotlapiyalhua, yonque imohuacaxhua, imoborregojhua o imochivojhua. ");
INSERT INTO nheBl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Pero intla tlacatis se pilburrojtzi, huelis innechcohuilise para inquitequihuise intla innechmacase se pilborregojtzi. Pero intla ax innechcohuilise nopa pilburrojtzi, monequi inquiquechpostequise. Nojquiya monequi innechcohuilise imoachtohui oquichpilhua ica se tlacajcahualistli. Huan axaca huelis hualas nechitaqui san ima. Monequi nechhualiquilis se tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Xitequitica para chicuasen tonali, pero ipan nopa chicompa tonal, amo xitequitica. Yonque intlapoxoníaj o inpixcaj, monequi inmosehuise. ");
INSERT INTO nheBl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Nojquiya xiilhuichihuaca ipan nopa ilhuitl tlen ipejya pixquistli quema achtohui inpehuaj inquipixcase trigo. Nojquiya xiilhuichihuaca ipan nopa ilhuitl tlen itlamiya pixquistli quema nechca itlamiya se xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Eyi huelta ipan se xihuitl monequi nochi tlacame huan oquichpilme ma monextica noixtla, na niimoTECO, niimoDios inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Huan na niquinquixtijtiyas nopa tlacame tlen ax nechixmatij ipan nopa tlali imoixtla, huan nijhueyilijtiyas imotlal. Huan quema inyase inmonextitij noixtla na, niimoTECO Dios, eyi huelta ipan se xihuitl, axaca huelis quiixtocas o moaxcatis imotlal. ");
INSERT INTO nheBl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Quema innechmacase tlacajcahualistli, amo xinechmacaca ica niyon se tlamantli tlen quipiya tlasonejcayotl. Nojquiya ax huelis inquiajcocuise hasta hualmostla niyon quentzi nopa tlacajcahualistli para Pascua. ");
INSERT INTO nheBl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Nopa tlen achtohui tlaquis ipan imomil, huan nopa tlen más cuali itlajca monequi inquihuicase ipan nochaj, na niDIOS, niimoTECO. “Amo xijtzoyonica se pilconechivojtzi ipan inana ilechi queja quichihuaj tetlajchihuiani.” ");
INSERT INTO nheBl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Huan TOTECO quiilhui Moisés: “Xiquijcuilo ni tlanahuatili tlen nimitzmaca, pampa ica ni tlanahuatili nijchihuas ni tlajtoli mohuaya huan ininhuaya nopa israelitame.” ");
INSERT INTO nheBl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Huan Moisés itztoya ihuaya TOTECO ipan nopa tepetl para 40 tonali huan 40 yohuali. Huan ipan nochi nopa tonali ax tlacuajqui, niyon ax atlic. Huan huajca TOTECO quiijcuilo ipan nopa tepatlacme nochi nopa majtlactli tlanahuatili tlen quintocarohua ma quichihuaca israelitame ipan nopa tlajtoli tlen TOTECO quichihuayaya ininhuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Huan Moisés temoc tlen tepetl Sinaí ica nopa ome tepatlactli tlen quipixqui nopa tlanahuatili. Huan petlaniyaya ixayac pampa camatitoya ihuaya Toteco Dios, pero yajaya ax quimatiyaya. ");
INSERT INTO nheBl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Huan quema Aarón huan nochi nopa israelitame quiitaque ixayac Moisés petlaniyaya, tlahuel majmajque huan ax quinejque quinechcahuise. ");
INSERT INTO nheBl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Huajca Moisés quinnotzqui ma quinechcahuica huan Aarón ica nochi tlayacanani monechcahuicoj huan Moisés quincamahui. ");
INSERT INTO nheBl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Huan teipa monechcahuijque nochi nopa sequinoc israelitame, huan Moisés quinilhui nochi nopa tlanahuatili tlen TOTECO quimacac ipan tepetl Sinaí. ");
INSERT INTO nheBl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Huan quema Moisés tlanqui quincamahuía, moixtzajqui ica se yoyomitl. ");
INSERT INTO nheBl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pero sesen huelta quema Moisés calaquiyaya ipan nopa tiopamitl iixtla TOTECO para mocamahuis ihuaya, moquixtiliyaya nopa yoyomitl tlen ica moixtzacuayaya huan queja nopa mocahuayaya hasta quema quisayaya. Huan quema quisayaya para quinyolmelahuas israelitame tlen TOTECO quinnahuatijtoya, ");
INSERT INTO nheBl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","nopa israelitame sampa quiitayayaj para petlaniyaya ixayac, huajca Moisés sampa moixtzacuayaya. Huan queja nopa mocahuayaya moixtzactoc hasta sampa oncalaquiyaya para camatis ihuaya Toteco Dios. ");
INSERT INTO nheBl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Huan Moisés quinsentili nochi israelitame huan quinilhui: “Ya ni nopa tlanahuatili tlen TOTECO quiijtojtoc ma tijchihuaca. ");
INSERT INTO nheBl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Quiijto para huelis titequitise chicuasen tonali, pero nopa chicompa tonal elis para tojuanti se tonal tlatzejtzeloltic, huan ipan nopa tonal monequi ximosehuica para TOTECO. Intla acajya tequitis ipan nopa tonal, monequi miquis. ");
INSERT INTO nheBl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Niyon amo xijtlatica se tlitl ipan imochajchaj ipan se tonali para timosiyajcahuase.” ");
INSERT INTO nheBl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Huan Moisés quincamahui nochi israelitame, huan quinilhui: “Ya ni tlen TOTECO tlanahuatijtoc ma tijchihuaca. ");
INSERT INTO nheBl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Nochi imojuanti tlen inquinequij inquimacase TOTECO se tlenijqui ica imopaquilis huan ica nochi imoyolo, huelis inquimacase huan tijsentilise nopa tlamantli. Huelis inquihualicase tlen inquipiyaj tlen oro, plata o bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Huelis inquihualicase icpatl tlen lino tlen tlamalintli nelcanactzi. Xijhualicaca nojquiya icpatl tlen tlapali azultic, moradojtic huan chichiltic. Nojquiya xijhualicaca nopa yoyomitl tlen tetic queja se cuetlaxtli tlen tlaxinepaloli ica oquich chivo iijhuiyo. ");
INSERT INTO nheBl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Xijhualicaca inincuetlaxo borregojme huan pesojme tlen tlapali chichiltic. Nojquiya xijhualicaca nopa cuahuitl tlen itoca acacia, ");
INSERT INTO nheBl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","huan oliva aceite para nochi tlahuili. Nojquiya monequi nopa tlaajhuiyacayotl tlen quimanelose ica nopa aceite para quinajaltise tlamantli huan tlacame para quiniyocatlalise para itequi TOTECO. Huan monequi quisencahuase nopa tlaajhuiyacayotl para nopa copali tlen ajhuiyac mijmiyotía. ");
INSERT INTO nheBl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Nojquiya xijhualicaca nopa piltetzitzi tlen yejyectzitzi tlen inintoca ónice huan sequinoc piltetzitzi tlen yejyectzitzi para tijtlalise ipan nopa ixpantzajcayotl huan nopa yolixpantzajcayotl para nopa hueyi totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“TOTECO tlanahuatijtoc para nochi imojuanti tlen inquipiyaj tlalnamiquistli huan yajatili para inquichihuase se cuali tequitl, xihualaca para inquichihuase nochi ni tequitl tlen tlanahuatijtoc TOTECO ma tijchihuaca. ");
INSERT INTO nheBl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Monequi tijsencahuase nopa yoyon tiopamitl ihuaya itzontzajca, itepos chijcolhua, ihuapalhua, icuaixtlapalhua, itlaquetzalo huan itepos cuatetoyo. ");
INSERT INTO nheBl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Tijsencahuase nopa caxa ica cuahuitl huehueyac para tijhuicase huan itzajca campa Toteco techtlasojtlas huan nopa cortina tlen quitzacuas. ");
INSERT INTO nheBl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Nojquiya tijchihuase nopa cuamesas huan cuahuitl huehueyac para tijhuicase huan nochi tlen motequihuía ica nopa cuamesas, ihuaya nopa pantzi tlen tenextilía para TOTECO itztoc tohuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Quichihuase nopa tlahuil quetzali tlen elis para tlahuili, huan nochi tlen motequihuía nopona huan itlahuilhua, huan iaceite. ");
INSERT INTO nheBl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Quisencahuase nopa tlaixpamitl para copali huan nopa cuahuitl huehueyac tlen ica quihuicase. Quisencahuase nopa aceite para titlaiyocatlalise para Toteco huan nopa tlamaneloli copali tlen ajhuiyac mijmiyotía. Nojquiya quisencahuase icortina para tijcuahuiyonise nopa puerta campa calaquise ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Quichihuase nopa tlaixpamitl campa quitlatise tlacajcahualistli ica itlixic ica itepos ixtlapalhua. Nojquiya quichihuase nopa cuahuitl huehueyac para ica tijhuicase huan nochi nopa tlamantzitzi tlen motequihuis nopona. Huan quichihuase nopa hueyi paila tlen bronce ihuaya tlen ipan moquetzas. ");
INSERT INTO nheBl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Quisencahuase nopa tlatzactli tlen cortina tlen quiyahualos nopa calixpamitl. Huan nopa calixpamitl quiyahualos nochi nopa yoyon tiopamitl. Nojquiya quichihuase itlaquetzalhua nopa cortina tlatzactli, huan itepos cuatetoyo sesen nopa tlaquetzali. Nojquiya quichihuase nopa cortinas tlen tijcuahuiyonise tlen quitzacuas campa incalaquise ipan calixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Quisencahuase estacas, huan mecatl para moilpis huan motetzilos nopa yoyon tiopamitl, huan nopa tlaquetzali. ");
INSERT INTO nheBl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Quichihuase nopa yoyomitl tlen moquentise totajtzitzi tlen tequitise tiopan calijtic. Quena, monequi quisencahuase nopa yoyomitl tlatzejtzeloltic para Aarón, huan nojquiya quichihuase tlen moquentise itelpocahua.” ");
INSERT INTO nheBl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Huan nochi israelitame motlanantejque campa itztoya Moisés huan yajque ininchajchaj. ");
INSERT INTO nheBl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Huan nochi tlen quimachilijque para TOTECO quinyoltilana ma quimacaca se tlenijqui huan ipan ininyolo quinequiyayaj quimacase, temacaque. Huan nopa israelitame quihuicaque nochi nopa ofrendas para nopa yoyoncali campa mopantise ihuaya TOTECO, huan nochi nopa tlamantzitzi tlen monequiyaya para quichihuase nopa tequitl tiopan calijtic. Nojquiya quihualicaque tlen monequiyaya para iyoyo tlatzejtzeloltic nopa totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Huan hualajque tlacame huan sihuame tlen ica nochi ininyolo quinequiyayaj quimacase se tlenijqui. Huan miyac quihualicayayaj tlamantli tlen oro tlen quitequihuijtoyaj para moyecchijchihuase. Quihualicaque pijpilolme, anillos, maquechcostli huan tlen hueli tlatectli oro. Huan nochi ni oro quitencahuilijque TOTECO queja se ofrenda. ");
INSERT INTO nheBl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Sequinoc quihuicaque icpatl azultic, moradojtic huan chichiltic huan lino icpatl tlen tlamalintli nelcanactzi, huan nojquiya quihualicaque yoyomitl tlen tetic queja se cuetlaxtli tlen tlaxinepaloli ica iniijhuiyo oquich chivojme. Quihualicaque inincuetlaxo pesojme huan ininpochquiyo borregojme tlen tlapali chichiltic. ");
INSERT INTO nheBl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Huan nochi tlen quinequiyayaj temacase se ofrenda tlen plata, o bronce, quihuicaque campa TOTECO. Huan tlen quipiyayayaj nopa cuahuitl acacia tlen monequi motequihuis ipan ichaj TOTECO, quihualicaque. ");
INSERT INTO nheBl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Huan miyac sihuame tlen hueliyaya tlamalinaj cuali huan tlen ica nochi ininyolo tequitiyayaj, quihualicaque icpatl tlen tlapali azultic, moradojtic huan chichiltic. Nojquiya quihualicaque lino icpatl tlen nelcanactzi. ");
INSERT INTO nheBl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Huan sequinoc sihuame tlen cuali hueliyaya tlamalinaj, quimalinque iniijhuiyo oquich chivojme huan quichijque yoyomitl tlen tetic. ");
INSERT INTO nheBl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Huan nopa tlayacanani quihuicaque piltetzitzi tlen itoca ónice huan sequinoc piltetzitzi tlen pajpatiyo para quitlatzquiltise ipan nopa ixpantzajcayotl huan yolixpantzajcayotl para nopa totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Huan nojquiya quihualicaque xihuitl tlen ajhuiyac mijmiyotía huan aceite para tlahuili. Nojquiya quihualicaque aceite para nopa tlamaneloli tlen tlaajaltise quema tlaiyocatlalise para Toteco, huan nopa copali tlen ajhuiyac mijmiyotía. ");
INSERT INTO nheBl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Huan nochi israelita sihuame huan tlacame tlen quimachilijque ipan ininyolo para hueli quichihuase se tlen nopa tlamantli tequitl tlen TOTECO quinahuatijtoya Moisés, quichijque huan quihuicaque tlen quisencajtoyaj para ma eli queja se ofrenda para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Huan Moisés quinilhui nopa israelitame: “Xiquitaca para TOTECO quitlapejpenijtoc Bezaleel, icone Uri huan iixhui Hur tlen tlacatqui ipan nopa hueyi familia tlen iixhuihua Judá, para elis tlen tlayacanas ipan nochi ni tequitl. ");
INSERT INTO nheBl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Huan Toteco Dios quitlali Itonal ica ihueyi chicahualis ipan Bezaleel para tlayacanas. Huan Toteco quimacatoc tlalnamiquistli huan yajatili para quimatis miyac tlamantli tequitl para huelis quisencahuas nochi tlen monequi, ");
INSERT INTO nheBl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","huan para huelis quichihuas tlamantli yejyectzitzi ica oro, plata huan bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Cuali quimati quitequis huan quinalaxos piltetzitzi para tlahuise. Nojquiya quimacatoc para elis se cuali cuaxinquetl tlen hueli quitejtequi huan quiyectlalía cuahuitl para quisencahuas tlen yejyectzi. ");
INSERT INTO nheBl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Nojquiya Toteco Dios quimacac tlalnamiquistli Bezaleel ihuaya Aholiab para ma quinmachtica sequinoc nochi tlen inijuanti quimatij. Aholiab eliyaya icone Ahisamac huan tlacatqui ipan nopa hueyi familia tlen iixhuihua Dan. ");
INSERT INTO nheBl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Huan Toteco Dios quinmacatoc nochi ome tlahuel miyac inintlalnamiquilis para ma quichihuaca miyac tlamantli tequitl. Quimatij quejatza quicualtlalise oro, huan quejatza cuatequise. Quimatij quejatza quichihuase yoyomitl yejyectzi tlajtzontli ica icpatl tlen tlapali azultic, moradojtic, huan chichiltic, tlaxinepaloli ica lino icpatl nelcanactzi. Quipiyaj yajatili para quichihuase nochi ni tequitl, huan para ma quiyolitica nochi nopa tlamantzitzi tlen monequi quichihuase, huan quisencahuase sese ica itlachiyalis tlen monequi. ");
INSERT INTO nheBl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Huajca Bezaleel huan Aholiab huan nochi sequinoc tlacame tlen TOTECO quinmacatoya tlalnamiquistli para ni tequitl, huan quipixque ipan ininyolo para tlapalehuise, monejqui tequitise huan quisencahuase nopa yoyon tiopamitl senquistoc queja TOTECO tlanahuatijtoya.” ");
INSERT INTO nheBl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Huajca Moisés quinnotzqui Bezaleel huan Aholiab, huan nochi tlacame tlen TOTECO quinmacatoya tlalnamiquistli huan tlen motemacayayaj ica nochi ininyolo para tequitise, huan nochi hualajque. ");
INSERT INTO nheBl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Huan Moisés quinmactili nochi tlamantli tlen nopa israelitame quihualicatoyaj tlen monequi quitequihuise ipan nopa yoyon tiopamitl. Huan mojmostla nopa israelitame noja quihualicayayaj ofrendas para quitequihuise. ");
INSERT INTO nheBl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Huajca teipa nochi inijuanti tlen quisencahuayayaj tlamantli quiquetzque inintequi, ");
INSERT INTO nheBl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","huan quicamahuitoj Moisés huan quiilhuijque: “Nochi quihualicatoque tlahuel miyac tlamantli hasta conpano tlen monequi para tijchihuase nochi tlen TOTECO tlanahuatijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Huajca Moisés tlanahuati ma quinyolmelahuatij nochi israelitame ipan ininchajchaj para niyon se tlacatl o sihuatl ayoc ma quisencahua seyoc tlamantli para nopa tiopamitl, niyon ayoc ma tlahuajhualicaca. ");
INSERT INTO nheBl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Pampa ya quipixtoyaj tlahuel miyac tlen quitequihuise huan hasta miyac mocahuayaya. ");
INSERT INTO nheBl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Huan nopa tlacame tlen Toteco quinmacatoya tlalnamiquistli para ma tequitica nopona, quichijque itzontzajca nopa tiopamitl. Quichijque ica 10 cortinas ica lino tlamalintli nelcanactzi huan tlaxinepaloli ica icpatl tlen tlapali azultic, moradojtic, huan chichiltic huan ipani nesiyaya inintlachiyalis nopa elhuicac ehuani tlen inintoca querubines. ");
INSERT INTO nheBl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Huan sesen nopa cortinas eliyaya 12 metros huan tlajco ihuehueyaca, huan ome metro ipatlajca. ");
INSERT INTO nheBl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Huan quisalojque itlamiya se cortina ica itlamiya seyoc nopa macuili cortinas para mochijqui san se cortina tlen huehueyac. Huan nopa seyoc macuili cortinas nojquiya quiijtzonque para mochijqui san se cortina tlen huehueyac huan nopa ome cortinas huehueyac elqui para sesen lado itzontzajca nopa tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Huan ipan se iteno sesen nopa ome huehueyac cortinas tlen quimojmotzquiltijtoyaj, quichihuilijque tlailpili ica iojal campa mosojsos, huan quitenyahualojque sese iojal ica icpatl azultic. ");
INSERT INTO nheBl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Para nochi quichihuilijque 50 tlailpili sese ica iojal para mosojsos ipan se lado nopa ome huehueyac cortinas tlen achtohui tlasaloli. Huan teipa quinchijque nopa tlailpili ipan sese para ma moixnamictica ica nopa tlailpili ipan seyoc. ");
INSERT INTO nheBl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Nojquiya quichijque 50 tepos chijcoli tlen oro para quisalos nopa 50 tlailpili ipan sesen nopa ome cortinas tlasaloli. Queja nopa quisencajque para quitzacuas huejcapa ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nojquiya quisencajque 11 cortinas tlen nopa tetic yoyomitl tlen tlaxinepaloli ica iniijhuiyo oquich chivojme para quisencajque iompa tzontzajca nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Huan sesen cortina ihuehueyaca eliyaya 13 metros huan tlajco, huan ome metro ipatlajca, huan nochi 11 cortinas quipixqui san se ininhuejhuexca. ");
INSERT INTO nheBl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Huan quisalojque macuili cortinas san sejco huan iyoca quisalojque seyoc chicuase cortinas. ");
INSERT INTO nheBl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Huan iteno se lado sesen nopa ome huehueyac cortinas quichihuilijque 50 tlailpili ica inintenhuaxo. ");
INSERT INTO nheBl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Nojquiya quichihuilijque 50 tepos chijcoli tlen bronce para ipan tijchihuas inintzojhuaso nopa tlailpili ipan se cortina ica nopa tlailpili ipan seyoc cortina para iompa tzontzajca nopa yoyon tiopamitl elis tlasaloli san sejco. ");
INSERT INTO nheBl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Huan nopa expa itzontzajca quichijque ica inincuetlaxo oquich chivojme tlen quipajque chichiltic, huan nopa najpa itzontzajca tlen elqui más calpani quichijque ica inincuetlaxo pesojme. ");
INSERT INTO nheBl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Huan para icaltepanyo nopa tiopamitl quiquejquetzque nochi nopa huapali tlen cuahuitl acacia. ");
INSERT INTO nheBl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Huan sese huapali quipixqui nahui metros huan tlajco ihuehueyaca, huan 65 centímetros ipatlajca. ");
INSERT INTO nheBl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Sese huapali quipixqui ome tepos chijcoli para quisalos ica ne sequinoc huapali ipan sesen lado. ");
INSERT INTO nheBl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Huan moquetzayayaj 20 huapali ipan nopa caltechtli ica sur. ");
INSERT INTO nheBl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Huan itzintla sesen nopa huapali calaquiyayaj ipan ome itepos cuatetoyo tlen plata para ma moquetzas cuali. Oncayaya 40 tepos cuatetomitl, ome cuatetomitl ipan sesen huapali. Huan sesen huapali quipixtoya ome tepos chijcoli para quitlatzquiltis ipan itepos cuatetoyo. ");
INSERT INTO nheBl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ipan nopa caltechtli ica norte oncayaya seyoc 20 huapali, ");
INSERT INTO nheBl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","huan 20 itepos cuatetoyo. Itzintla sese huapali oncayaya ome itepos cuatetoyo. ");
INSERT INTO nheBl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Iica nopa tiopamitl ipan nopa lado campa temo tonati quipixqui chicuase huapali. ");
INSERT INTO nheBl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Huan quitlalilijque seyoc huapali iica tiopamitl campa sese icalnacastla. ");
INSERT INTO nheBl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Huan queja nochi más huapali, nopa huapali campa inincalnacastla quipixque tepos chijcoli ica tlatzintla huan ica huejcapa para quisojsos ica nopa huapali tlen inechca. ");
INSERT INTO nheBl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Huajca campa temo tonati oncayaya chicueyi huapali huan 16 tepos cuatetomitl tlen ipan moquetzayayaj, ome cuatetomitl tlatzintla sesen huapali. ");
INSERT INTO nheBl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Quisencajque cuaixtlapali huejhuehueyac tlen cuahuitl acacia huan quitlalijque iixtla nopa huapali ipan nopa caltechtli tlen quiyahualojque nopa tiopamitl. Quichijque macuili cuaixtlapali para iixtla nopa huapali ipan se lado nopa tiopamitl, ");
INSERT INTO nheBl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","huan seyoc macuili cuaixtlapali para iixtla nopa huapali ipan ne seyoc lado, huan seyoc macuili cuaixtlapali para iixtla huapali tlen moquetzque iica nopa tiopamitl ica campa temo tonati. ");
INSERT INTO nheBl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Huan nopa cuaixtlapali tlen panoc tlajco iixtlapal nopa huapali tlen moquetztoyaj pejque ica se icalnacastla tiopamitl huan ajsic hasta seyoc icalnacastla nopa tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Huan quiixaltijque nopa huapali ica oro, huan nopa anillos campa calaquiyayaj nopa cuaixtlapali elqui senquistoc oro. Nojquiya quiixaltijque ica oro nopa cuaixtlapali tlen huejhuehueyac. ");
INSERT INTO nheBl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Huan nopa cortina tlen quitzajqui nopa cuarto tlen más calijtic quichijque ica lino tlen tlamalintli nelcanactzi huan tlaxinepaloli ica icpatl tlen quipajtoyaj azultic, moradojtic huan chichiltic. Huan ipan nopa tlaxinepaloli nesiyayaj ome elhuicac ehuani tlen inintoca querubines. ");
INSERT INTO nheBl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Huan para ipan mohuiyonis nopa cortina quichijque nahui tlaquetzali ica cuahuitl acacia huan quinxajqui ica oro. Huan ipan nopa tlaquetzali quitlalijque tepos chijcoli tlen oro. Huan sesen nopa nahui tlaquetzali moquetzayaya ipan inincuatetoyo tlen plata. ");
INSERT INTO nheBl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nojquiya quichijque se cortina para quitzacuase campa calaquise ipan yoyon tiopamitl. Quichijque ica lino nelcanactzi tlen tlaxinepaloli ica icpatl azultic, moradojtic, huan chichiltic huan quiijtzonque yejyectzi ica itlachijchihualo. ");
INSERT INTO nheBl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Huan ni cortina tlatzquitoya ipan macuili tlaquetzali ica macuili tepos chijcoli. Huan inintzonatipa nopa macuili tlaquetzali huan tepos chijcoli quiixaltijque ica oro, huan nopa macuili icuatetoyo tlen ipan moquetzqui nopa tlaquetzali quichijque ica bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Huan teipa Bezaleel quisencajqui nopa caxa ica cuahuitl acacia huan quipixqui 110 centímetros ihuehueyaca, huan 65 centímetros ipatlajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nheBl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Iijtic huan ipani quiixaltijqui ica senquistoc oro, huan yahualtic quipixtoya itejteno tlen oro. ");
INSERT INTO nheBl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Huan quichihuili nahui anillos tlen oro huan quitlalili najcac ipan inacastla. ");
INSERT INTO nheBl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Nojquiya quisencajqui cuahuitl huehueyac huan quiixaltijqui ica oro. ");
INSERT INTO nheBl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Huan ipan nopa anillos quicalaqui nopa cuahuitl huehueyac para queja nopa huelis quihuicase nopa caxa. ");
INSERT INTO nheBl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Teipa quichijqui itzajca nopa caxa campa Toteco quintlasojtlas tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Nojquiya iixco itzajca quisencahuili ome ielhuicac ejcahua Toteco tlen inintoca querubines tlen tlatejtzontli ica martillo. Huan nopa elhuicac ehuani huan itzajca nopa caxa elqui san se tlatectli oro. Huan nopa elhuicac ehuani moquetztoyaj ipan sese iteno itzajca. ");
INSERT INTO nheBl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Se ielhuicac ejca Toteco moquetztoc ipan se iteno huan ne seyoc ipan seyoc iteno. Nopa querubines huan itzajca nopa caxa elqui san se tlatectli oro tlatejtzontli. ");
INSERT INTO nheBl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nopa elhuicac ehuani moixnamictoyaj huan moeltlapal tlalantoyaj queja quiecahuiliyayaj huan quitlachiliyayaj itzajca nopa caxa campa TOTECO quintlasojtlas tlacame. ");
INSERT INTO nheBl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Nojquiya quisencajqui nopa cuamesa ica cuahuitl acacia. Huan quipixtoya ihuehueyaca 90 centímetros, huan 45 centímetros ipatlajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nheBl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Huan quiixalti ica senquistoc oro. Huan quichihuilijque nopa cuamesa se icorona tlen oro tlen quitenyahualo iixco. ");
INSERT INTO nheBl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Nojquiya quitenyahualo iixco nopa cuamesa ica se pilhuapaltzi tlen quipiya san chicome centímetros ipatlajca. Huan yahualtic quitejtequi para quichihuili iyejyejca huan quiixalti nochi ica senquistoc oro. ");
INSERT INTO nheBl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Huan quichihuili nahui anillos tlen oro, huan quitlali najcac ipan inacastla nopa cuamesa campa pehua iicxihua iquespa nopa mesa. ");
INSERT INTO nheBl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Nopa anillos eltoya huejcapa ipan iicxi nechca nopa pilhuapaltzi tlen quitentzajqui nopa cuamesa. Huan quisencajqui cuahuitl huehueyac huan quicalaqui ipan nopa anillos ipan nopa cuamesa para queja nopa huelis quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Huan para quichihuas nopa cuahuitl huehueyac para ica quihuicase nopa cuamesa quitequihui cuahuitl acacia, huan quiixalti ica oro. ");
INSERT INTO nheBl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Nojquiya quisencajqui tlen quitequihuise ipan cuamesa queja platome, huejhueyi cucharas, tepos huitzcucharas huan huejhueyi xarros para tlacajcahualistli tlen atic. ");
INSERT INTO nheBl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Nojquiya quisencajqui se tlahuil quetzali tlen senquistoc oro. Iicxi, icuayo, ipilcaxitzitzi, ixochiyo mimilijtoc huan tlahuijtoc huan nochi iyejyejca quisencahuili ica san se tlatectli oro tlen tlatejtejtzontli ica martillo. ");
INSERT INTO nheBl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Huan quipixtoya chicuase imacuayohua; eyi imacuayohua ipan se lado, huan ne se eyi ipan seyoc lado. ");
INSERT INTO nheBl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ipan sese imacuayo quipixqui eyi pilcaxitzitzi tlen ipan tlatlatise huan quipixqui itlachiyalis queja se almendra ixochiyo tlen mimilijtoc huan se tlen tlahuitoc. Huan ipan nochi nopa chicuase imacuayohua queja nopa eliyaya. ");
INSERT INTO nheBl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Huan ipan icuayo nopa tlahuil quetzali quipiyayaya nahui pilcaxitzitzi, sese ica itlachiyalis se xochitl almendra, se nesiyaya se xochitl mimilijtoc huan se queja se xochitl tlahuitoc. ");
INSERT INTO nheBl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Huan itzintla tlen sesen nopa chicuase imacuayohua tlen tlatzquitoyaj ipan icuayo nopa tlahuil quetzali quipiyayaya se xochitl tlahuitoc. ");
INSERT INTO nheBl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Huan nochi ixochiyohua huan imacuayohua huan icuayo eliyaya san se tlatectli oro huan tlatejtejtzontli ica martillo. ");
INSERT INTO nheBl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Nojquiya quichihuili chicome piltlahuiltzitzi, huan nopa cucharas tlen ica quinsehuijque nochi tlahuili, huan quichihuilijque iplatohua. Huan nochi quisencajque ica senquistoc oro. ");
INSERT INTO nheBl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Huan nopa tlahuil quetzali tlen oro quipixqui 33 kilos ietica. ");
INSERT INTO nheBl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Nojquiya quichijqui se tlaixpamitl campa quitlatise copali huan elqui cuadradojtic, ica 45 centímetros ihuehueyaca huan ipatlajca, huan quipiyayaya icuacua ipan nochi nahui inacastla, huan nochi san eliyaya se tlatectli cuahuitl. ");
INSERT INTO nheBl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Huan quiixalti ica senquistoc oro nochi itzontzajca, huan iquespa, huan icuacua. Huan yahualtic iixco quiquetzqui se icorona tlen oro tlen quiyejyectlali. ");
INSERT INTO nheBl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Huan nojquiya quichihuili nahui anillos tlatzintla nopa nahui iesquinajyo, huan nopona quicalaqui nopa cuahuitl huehueyac para ica quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Huan nopa cuahuitl huehueyac quisencajqui ica cuahuitl acacia, huan quiixalti ica oro. ");
INSERT INTO nheBl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nojquiya quisencajqui nopa aceite tlen tlatzejtzeloltic para tlaiyocatlalise para Toteco, huan quisencajqui nopa copali tlen ajhuiyac mijmiyotía. Nochi quisencajqui Bezaleel, se tlaajhuiyacasencajquetl tlen achi más quimatqui. ");
INSERT INTO nheBl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Huan nojquiya ica cuahuitl acacia quisencajqui se tlaixpamitl tlen cuadradojtic iixco campa quitlatise tlacajcahualistli. Quipixqui 2 metros 25 centímetros ihuehueyaca huan ipatlajca. Huan ihuejcapanca eltoya 1 metro 25 centímetros. ");
INSERT INTO nheBl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Huan ipan najcac inacastla quisencahuili icuacua. Huan quisencajqui ica san se tlatectli cuahuitl huan quiixalti ica nopa tepostli bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Huan quisencahuili nochi tlen monequi quitequihuise ipan nopa tlaixpamitl queja nopa tepos caja tlen ipan quitemase cuanextli, nopa huajcaltini para quiselise estli, huan nopa tepos chijcoli para ica quiitzquise nopa nacatl, huan palas para ica quiquixtise cuanextli, huan nopa tepostli para tlicoli. Huan nochi quisencajqui ica bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Huan ica bronce quisencahuili se tlixictli ica ipiltepos ixtlapalhua para iixco huelis motecas nopa tlacajcahualistli tlen quitlatíaj. Huan quisehui nopa tlixictli ipan tlajco ihuejcapanca iijtico nopa tlaixpamitl campa quipixqui se itencuayo. ");
INSERT INTO nheBl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Huan nojquiya najcac campa inacastla quichihuili nahui anillos para ipan quicalaquise nopa cuahuitl huehueyac para ica quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Huan quisencajqui nopa cuahuitl huehueyac ica cuahuitl acacia huan teipa quiixalti ica bronce. ");
INSERT INTO nheBl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Huan quicalaqui nopa huehueyac cuatini ipan nopa anillos tlen eltoya iquespa nopa tlaixpamitl para huelis quihuicase. Huan quichijqui nopa tlaixpamitl ica huapali huan iijtico mocajqui cacahuatic. ");
INSERT INTO nheBl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Huan quichijqui nopa hueyi paila para atl ica bronce huan quichijqui nopa tlen ipan moquetza. Quichijque ica miyac tescatl tlen bronce tlen sihuame quimatque quitequihuíaj, pampa sihuame tlen tlatequipanojque campa ipuerta nopa yoyon tiopamitl quihualicaque inintesca huan temacaque. ");
INSERT INTO nheBl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Teipa Bezaleel quisencajqui se calixpamitl tlen quiyahualo nochi nopa yoyon tiopamitl. Huan tzactoya nopa calixpamitl ica cortinas queja se tepamitl. Huan nopa cortinas tlen quitzajqui nopa calixpamitl ica sur quipixqui 45 metros ihuehueyaca. Huan quichijqui nopa cortinas tlaxinepaloli ica icpatl tlen lino nelía canactzi. ");
INSERT INTO nheBl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Huan ica sur tlatzquitoyaj nopa cortinas ipan 20 tlaquetzali ica 20 inincuatetoyo tlen bronce huan inintepos chijcolhua huan inianillos tlen plata. ");
INSERT INTO nheBl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Huan ica norte nopa cortinas tlen mochijqui nopa tlatzactli quipixqui 45 metros ihuehueyaca, huan tlatzquitoyaj ipan 20 tlaquetzali, huan 20 inincuatetoyo tlen bronce ica inintepos chijcolhua huan inianillos tlen plata. ");
INSERT INTO nheBl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Huan campa temo tonati nopa cortinas tlen quitzajqui nopa lado quipixqui 22 metros huan tlajco ihuehueyaca, huan quipixqui 10 tlaquetzali, huan 10 cuatetomitl para ipan tlatzquise. Huan nopa tlaquetzali, huan inintepos chijcolhua huan inianillos nochi elqui tlen plata. ");
INSERT INTO nheBl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Huan ica campa quisa tonati nopa cortinas tlen quitzajqui nopa lado quipixqui 22 metros huan tlajco. ");
INSERT INTO nheBl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Huan tlajco nopa tlatzactli campa quisa tonati mocajqui tlapojtoc queja puerta para calaquise ipan calixpamitl. Huan ipan se lado campa calaquise eltoya se cortina tlen quipixqui 7 metros ihuehueyaca, huan eyi tlaquetzali sese ica icuatetoyo para ipan tlatzquijque. ");
INSERT INTO nheBl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Huan ipan ne se lado tlen campa calaquiyayaj nojquiya eltoya se cortina tlen 7 metros ihuehueyaca, huan 3 tlaquetzali huan sesen ica icuatetoyo para ipan tlatzquijque. ");
INSERT INTO nheBl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Huan nochi nopa cortinas tlen mochijqui nopa tlatzactli tlen eltoya yahualtic nopa calixpamitl mochijtoya ica yoyomitl tlaxinepaloli tlen lino icpatl tlen nelía canactzi. ");
INSERT INTO nheBl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Huan icuatetoyo sesen tlaquetzali eliyaya tlen bronce, huan itepos chijcolhua huan ianillos eliyaya tlen plata. Huan itzonixco sesen tlaquetzali quiixalti ica plata. Huan nochi nopa tepos barras para ipan quicuapilose nopa cortinas eliyaya tlen plata. ");
INSERT INTO nheBl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Huan campa nopa cortina tlen quitzacuayaya campa calaquij ipan nopa calixpamitl elqui tlaxinepaloli ica lino icpatl tlen nelcanactzi huan icpatl tlen azultic, moradojtic huan chichiltic. Eltoya itequi se tlen achi más quimatqui tlaxinepalohua. Huan nopa cortina eliyaya 9 metros ihuehueyaca huan 2 metros 25 centímetros ihuejcapanca san se queja ne sequinoc cortinas tlen quiyahualojque nopa calixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Huan campa calaquiyayaj quipixqui 4 tlaquetzali, sese ica icuatetoyo tlen bronce para ipan moquetzas. Huan itepos chijcolhua huan ianillos nopa tlaquetzali eliyaya tlen plata huan itzonixco sesen tlaquetzali nojquiya quiixalti ica plata. ");
INSERT INTO nheBl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Huan nochi estacas eltoya tlen nopa tepostli bronce huan quitequihui para quiilpis huan quitetzilos nopa tiopamitl. Huan nopa cortina tlatzactli quiyahualo nopa calixpamitl. Huan nopa calixpamitl quiyahualo nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Huan ya ni nopa cuenta tlen nopa yoyon tiopamitl para elis ichaj nopa caxa ica itlanahuatil TOTECO. Huan quichijque nochi queja Moisés tlanahuatijtoya. Huan Itamar, icone totajtzi Aarón, tlayacanqui para quiitztiyas sesen tequitl. Huan nopa levitame quiijcuilojque quesqui imiyaca sesen tlamantli quitequihuijtoyaj para quichihuase nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Huan Bezaleel, icone Uri huan iixhui Hur ipan nopa hueyi familia Judá, tlayacanqui para quichihuas iixcopinca sesen tlamantli senquistoc queja TOTECO quinahuati Moisés ma quisencahua. ");
INSERT INTO nheBl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Huan quipalehui Aholiab, icone Ahisamac, tlen tlacatqui ipan nopa hueyi familia Dan. Huan Aholiab eltoya se tepos tejtzonquetl para tlayejyectlalis, huan se cuali tlaxinepalojquetl ica icpatl. Huan quimatqui quichihuas yejyectzi yoyomitl tlen quipixqui itlajtzoyo ica lino icpatl tlen canactzi huan icpatl tlen azultic, moradojtic huan chichiltic. ");
INSERT INTO nheBl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nochi oro tlen motequihui para nochi tlamantli ipan nopa tiopamitl eltoya oro tlen israelitame quimacatoyaj TOTECO. Huan ietica quipano 965 kilos queja nopa tlayejyecoli tlen quitequihuijque ipan nopa tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Huan imiyaca plata tlen quitequihuijque panoc 3 mil 319 kilos. ");
INSERT INTO nheBl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Nochi ni plata elqui tlen quininanque nopa 603 mil 550 tlacame tlen moijcuilojque ipan nopa censo pampa ya quiaxitijque 20 xihuitl. Sesen inijuanti temacaque macuili gramos tlen plata quema moijcuilojque. ");
INSERT INTO nheBl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Quitequihuijque 3 mil 300 kilos tlen plata para inincuatetoyo icaltepanyo tiopamitl huan nopa tlaquetzali para cortinas campa calaquise. Ica ni plata quichijque icuatetoyo 100 tlaquetzali. Elqui nechca 33 kilos tlen plata tlen quitequihui ipan icuatetoyo sesen tlaquetzali. ");
INSERT INTO nheBl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Huan nopa plata tlen mocajqui, quitequihuijque para itepos chijcolhua, ianillos, huan para itzonixco sesen nopa tlaquetzali. ");
INSERT INTO nheBl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Huan nopa bronce tlen nopa israelitame quimacaque TOTECO quipano 2 mil 336 kilos ietica. ");
INSERT INTO nheBl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Huan ica nopa bronce quichijque icuatetoyo nopa tlaquetzali tlen quitlaquechijque nopa cortinas campa calaquij ipan calixpamitl. Huan quichijque nopa tlaixpamitl tlen bronce para ipan quitlatise tlacajcahualistli, huan quichijqui itlixic ica ipiltepos ixtlapalhua tlen bronce tlen ipan quitecase nopa tlapiyali para quitlatise. Huan nojquiya ica ni bronce quichijqui nochi nopa tlamantzitzi tlen monequiyaya campa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Nojquiya quitequihui bronce para nopa cuatetomitl para tlaquetzali tlen quitlaquechi nopa cortinas tlen quitzajqui nopa calixpamitl huan nopa cortinas campa calaquij ipan calixpamitl. Huan quitequihui bronce para iestacas para quiilpis huan quitetzilos nopa tiopamitl huan nochi nopa tlaquetzali. ");
INSERT INTO nheBl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nojquiya ininyoyo nopa totajtzitzi tlen quitequihuise quema tequitise tiopan calijtic quixinepalojque ica icpatl azultic, moradojtic huan chichiltic. Huan quisencajque iyoyo Aarón tlen tlatzejtzeloltic queja TOTECO quinahuatijtoya Moisés. Huan ni yoyomitl quitequihuía san quema calaqui ipan tiopamitl campa tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nojquiya quisencajque iixpantzajcayo tlaxinepaloli ica icpatl tlen oro tlen azultic, moradojtic, huan chichiltic huan lino icpatl tlen nelía canactzi. Huan nochi elqui nelía cuali tlasencahuali. ");
INSERT INTO nheBl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Quicuique se tlatectli oro, huan quitejtzonque hasta quichijque se piltepos mecatzi tlen nelía canactzi queja icpatl. Huan nopa piltepos mecatzi tlen oro quixinepalojque ihuaya lino icpatl tlen canactzi huan icpatl tlen azultic, moradojtic huan chichiltic. Huan elqui itequi se tlen nelía quimatqui tequiti huan nelía yejyectzi mocajqui. ");
INSERT INTO nheBl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Huan nopa ixpantzajcayotl elqui ome tlatectli yoyomitl. Huan nojquiya quichijqui seyoc tlatectli para iajcolpa campa moixnamiquiyaya iyolixco huan icuitlapa. ");
INSERT INTO nheBl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Nojquiya nopa itzinquechilpica tlen yejyectzi elqui tlasencahuali ica san se nopa yoyomitl tlen quitequihuijque ipan nopa ixpantzajcayotl. Nochi eltoya tlen nopa piltepos mecatzi tlen oro tlaxinepaloli ica lino icpatl nelía canactzi huan ica icpatl azultic, moradojtic huan chichiltic. Nochi eltoya queja TOTECO quiilhui Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Huan quisencajque piltetzitzi tlen yejyectzi itoca ónice huan quitlali ipan oro. Huan ipani quiijcuilojque inintoca nochi itelpocahua Israel queja se sello tlen quipiya tlajcuiloli tlen nesi. ");
INSERT INTO nheBl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Huan quitlalili iajcolpa nopa ixpantzajcayotl para ica quinilnamiquiltis TOTECO tlen itelpocahua Israel. Huan nochi quichijque queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Huan nojquiya se tlen tlahuel quimatqui, quisencajqui nopa yolixpantzajcayotl queja nopa ixpantzajcayotl. Quixinepalo nopa icpatl tlen oro, lino icpatl ihuaya icpatl tlen azultic, moradojtic huan chichiltic. ");
INSERT INTO nheBl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Huan quicuelpacho nopa yolixpantzajcayotl huan quichijqui se bolsa tlen cuadradojtic. Ihuehueyaca huan ipatlajca eltoya 22 centímetros. ");
INSERT INTO nheBl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Huan iyolixpa oncayaya nahui tlatilimitl tlen piltetzitzi tlen yejyectzitzi. Ipan nopa achtohui tlatilimitl quitlatzquiltilijque se piltetzi tlen itoca rubí, se topacio huan se sardónice. Ya ni elqui nopa achtohui tlatilimitl. ");
INSERT INTO nheBl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Huan ipan nopa ompa tlatilimitl quitlalilijtoya se esmeralda, se zafiro huan se diamante. ");
INSERT INTO nheBl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Huan ipan nopa expa tlatilimitl quitlatzquiltijque se jacinto, se ágata huan se amatista. ");
INSERT INTO nheBl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Huan ipan nopa najpa tlatilimitl quitlatzquiltijque se berilo, se ónice huan se jaspe. Huan mocajqui nochi ni piltetzitzi tlatzquitoque ipan ininpiltencuayohua tlen oro tlen mocahua inintejteno huan tlen quiyecchijtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Huan imiyaca nopa piltetzitzi elqui 12 queja ininmiyaca itelpocahua Israel. Huan sese elqui queja se pilsellojtzi tlen quichihua itoca se itelpoca Israel. ");
INSERT INTO nheBl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nojquiya quisencajque para nopa yolixpantzajcayotl ipiltlajco ilpicayotzitzi tlen tlaxinepaloli tlen oro. ");
INSERT INTO nheBl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Huan quichihuili nopa yolixpantzajcayotl ome anillos tlen oro oncac ipan inacastla tlen huejcapa huan nopona quicalaqui nopa piltlajco ilpicayotl huan quitlatzquiltili nopa yolixpantzajcayotl ica tlen eltoc iajcoltipa ipan nopa ixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Huan quitlatzquiltijque oncac nopa ome piltlajco ilpicayotzitzi tlen oro tlen yejyectzitzi tlaxinepaloli ipan inacas huejcapa ipan nopa yolixpantzajcayotl. Huan teipa seyoc iteno nopa piltlajco ilpicayotzitzi quitlatzquilti ipan sese anillo iajcolpa ipan nopa ixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Huan quitlalijque ni ome ipiltlajco ilpicayotzitzi tlen oro tlen tlayejyecchihuali oncac, se ipan sesen nopa ome anillos tlen eltoc iajcolpa huan ica quitlatzquiltilijque iyolixpa nopa yolixpantzajcayotl ica iajcolpa nopa ixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Huan quichijque seyoc ome anillos tlen oro tlen quitlatzquiltilijque ipan sese iquespa ipan itejteno nopa yolixpantzajcayotl. ");
INSERT INTO nheBl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nojquiya quichijque ome anillos tlen oro tlen quitlatzquiltijque tlatzintla ipan tlen elqui iajcoltipa huan teipa quisalojque seyoc iteno ihuaya itzinquechilpica. ");
INSERT INTO nheBl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Huan quinechicojque nopa yolixpantzajcayotl ica nopa ixpantzajcayotl huan quiilpijque ica se listón azultic para ma motlali cuali ipan nopa ixpantzajcayotl itzinquechilpica para nochipa san sejco tlatzquitose nopa yolixpantzajcayotl ica nopa ixpantzajcayotl huan ax papatlacas. Huan nochi quichijqui senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Huan nojquiya quichihuili nopa totajtzi iyoyo tlen huehueyac tlen mocajqui itzala nopa ixpantzajcayotl, huan quichijqui nochi ica yoyomitl azultic. ");
INSERT INTO nheBl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Huan quiquechtejqui campa calaquis itzonteco huan quiyahualo campa quiquechtectoya ica se yejyectzi tlajtzontli tlen tlayahualoli para ma ax tzayani. ");
INSERT INTO nheBl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Huan ipan itejteno iyoyo huehueyac quichihuili se tlajtzontli tlen quiixcopinqui nopa cuatlactli itoca granada. Quiixcopinqui quema quixinepalo lino icpatl huan icpatl azultic, moradojtic huan chichiltic. ");
INSERT INTO nheBl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Nojquiya quichihuilijque pilcampanajtzitzi tlen senquistoc oro, huan quiilpijque tlajco nopa granadas. Huan queja nopa yajtiyajqui ipan nochi itejteno iyoyo. ");
INSERT INTO nheBl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Quipixqui se pilcampanajtzi huan se granada, seyoc pilcampanajtzi huan seyoc granada ipan nochi itejteno icuej iyoyo huehueyac. Huan nopa totajtzi motlalili nopa yoyomitl quema quitequipano TOTECO tiopan calijtic. Huan nochi quichijque senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Huan para Aarón huan itelpocahua quinchihuilijque inintlatzintlanyoyo ica yoyomitl tlen lino tlen nelcanactzi. ");
INSERT INTO nheBl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Nojquiya quixinepalojque nopa cuatzajcayotl ica icpatl tlen lino tlen nelcuali, huan quiyejyectlalijque nopa yoyomitl para inincuajtol ica icpatl tlen lino tlen nelía cuali, huan quichijque inintlatzintlanyoyo nojquiya ica icpatl tlamalintli tlen lino huan nelía canactzi. ");
INSERT INTO nheBl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Nojquiya quisencajque inintzinquechilpijcayo ica lino icpatl nelcanactzi huan icpatl tlen azultic, moradojtic huan chichiltic. Huan quichijque yejyectzi itlajtzoyo senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Nojquiya quichijqui se piltlatectzi tlen oro para quitlalis ipan icuatzajca huan ipani tlajcuilojque queja se sello tlen quiijto: TLAIYOCATLALILI PARA TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Huan quiilpilijque ica se icpatl azultic huan quitlalijque iixtla nopa cuatzajcayotl senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Huan queja ni tlanqui nochi nopa tequitl tlen quichihuayayaj para quisencahuase nopa yoyon tiopamitl campa mopantise ihuaya TOTECO. Huan nochi quisencajque nopa israelitame senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Huan nochi nopa tiopamitl ica nochi tlamantli tlen quisencajtoya quihualiquilijque Moisés. Quihualiquilijque nopa yoyoncali tlen quichijtoya ica nopa tetic yoyomitl tlen tlaxinepaloli ica iniijhuiyo oquich chivojme. Quihualicaque nopa cuamesas, tepos chijcoli, huapali, cuaixtlapali, tlaquetzali huan icuatetoyo. ");
INSERT INTO nheBl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Quihualiquilijque itzontzajca tlen quichijtoyaj ica inincuetlaxo oquich borregojme tlen quipajtoya chichiltic, huan itzontzajca tlen quisencajtoya ica inincuetlaxo pesojme huan nojquiya nopa cortinas tlen ica quitzacuas nopa cuarto tlen quipixqui nopa caxa. ");
INSERT INTO nheBl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Quihualicaque nopa caxa huan cuahuitl huehueyac para ica quihuicase, huan itzajca, ");
INSERT INTO nheBl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","huan nopa cuamesa ica nochi tlen motequihuis ipani, huan nopa pantzi tlen quitlalía ipan nopa cuamesa para tenextilis Toteco itztoc tohuaya. ");
INSERT INTO nheBl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Nojquiya quihualicaque nopa tlahuil quetzali tlen oro ica nochi itlahuilhua tlen quitlalijtoya sesen campa monequiyaya huan nojquiya quihualicaque nochi nopa tlamantzitzi tlen monequi quitequihuise ica nopa tlahuil quetzali ihuaya nopa aceite tlen quitequilise para ma tlatla. ");
INSERT INTO nheBl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Huan quihualicaque nopa tlaixpamitl tlen oro, ihuaya nopa copali tlen ajhuiyac huan nopa aceite para tlaiyocatlalise, huan nopa cortina para quicuapilose campa calaquise. ");
INSERT INTO nheBl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Quihualicaque nopa tlaixpamitl tlen bronce huan nochi tlen nopona motequihuía. Nojquiya quihualicaque itlixicyo tlen bronce huan nopa cuahuitl huehueyac para ica quihuicase. Huan nochi quiixaltijtoyaj ica bronce. Nojquiya quihualicaque nopa hueyi paila huan icuayo tlen ipan ma momajtequica totajtzitzi. ");
INSERT INTO nheBl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Quihualicaque nopa cortinas tlen mochihuas itzajca nopa calixpamitl, ihuaya itlaquetzalo huan itepos cuatetoyo. Nojquiya quihualicaque nopa cortinas para campa puerta campa calaquise ipan calixpamitl, huan nopa mecatl huan estacas para quiilpise huan quitetzilose sesen tlaquetzali, huan nochi tlamantli tlen motequihuis tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Nojquiya quihuiquilijque Moisés para ma quiita iyejyejca ininyoyo nopa totajtzitzi tlen moquentise quema calaquise para tequitise tiopan calijtic Campa Tlatzejtzeloltic. Quihualiquilijque nopa yoyomitl tlen tlatzejtzeloltic para nopa hueyi totajtzi Aarón, ihuaya nopa yoyomitl para itelpocahua quema quichihuase inintequi tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Huan nopa israelitame quichijque nochi senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Huan quema Moisés quitlachili nochi tlen quichijtoya, quiitac para quisencajtoyaj senquistoc queja TOTECO tlanahuatijtoya, huan quintiochijqui nochi inijuanti tlen quisencajtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Xijquetza nopa yoyon tiopamitl campa timopantise ipan nopa achtohui tonal ipan nopa achtohui metztli ipan nopa yancuic xihuitl ipan imocalendario. ");
INSERT INTO nheBl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Huan ipan nopa yoyon tiopamitl ipan nopa cuarto más calijtic, xijtlali nopa caxa, huan xijtzacua campa calaquise ipan nopa cuarto ica nopa cortina. ");
INSERT INTO nheBl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Huan ipan nopa seyoc cuarto tlen ax más calijtic, xijcalaqui nopa cuamesa para pantzi huan xijtlali campa monequi. Teipa xijcalaqui nopa tlahuil quetzali huan xijtlati. ");
INSERT INTO nheBl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Huan nojquiya ipan nopa cuarto tlen ax más calijtic, xijtlali nopa tlaixpamitl tlen oro campa quitlatise copali huan nopa tlaixpamitl tlen copali mocahuas iixmelac nopa caxa tlen eltoc ipan nopa cuarto más calijtic. Huan xijcuapilo seyoc cortina campa calaquise ipan nopa achtohui cuarto tlen ax más calijtic huan ni cortina elis iixmelac nopa tlaixpamitl tlen oro huan quitzacuas campa calaquise ipan nopa cuarto tlen ax más calijtic. ");
INSERT INTO nheBl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Huan ipan nopa calixpamitl, xijtlali nopa tlaixpamitl campa quitlatise tlacajcahualistli. Huan moquetzas iixmelac nopa cortina campa calaquise ipan nopa cuarto tlen ax más calijtic. ");
INSERT INTO nheBl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Teipa tlatlajco nopa yoyon tiopamitl huan nopa tlaixpamitl, xijtlali nopa hueyi paila tlen quitequilise atl para momajtequise. ");
INSERT INTO nheBl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Huan teipa xijquetza nopa tlatzactli tlen cortinas para xijchihua icalixpanyo yahualtic nopa yoyon tiopamitl. Huan tlen campa calaquise ipan calixpamitl, xijcuapilo nopa seyoc cortina. ");
INSERT INTO nheBl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Huan xijcui nopa aceite tlen tlaajaltise para tlaiyocatlalise para TOTECO. Huan xiquijtzelhuili nopa yoyon tiopamitl huan nochi cuamesas tlen eltoc ipani. Xiquijtzelhuili nochi tlen quitequihuise nopona. Huan nochi mocahuas tlatzejtzeloltic, tlaiyocatlalili para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Teipa xiquijtzelhuili nopa tlaixpamitl campa quitlatise tlacajcahualistli huan nochi tlen motequihuía ihuaya. Huan queja nopa moiyocatlalijtos nopa tlaixpamitl huan elis tlahuel tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nojquiya xiquijtzelhuili nopa hueyi paila campa momajtequise huan icuayo tlen bronce huan queja nopa tiquiyocatlalis huan tijchihuas tlatzejtzeloltic para na. ");
INSERT INTO nheBl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Huan xijhuica Aarón ihuaya itelpocahua ipan nopa calixpamitl hasta iixmelac campa calaquise ipan nopa yoyon tiopamitl campa timopantise, huan nopona ma maltica ica atl. ");
INSERT INTO nheBl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Huan xijyoyonti Aarón ica nopa yoyomitl tlatzejtzeloltic. Huan xicajalti ica aceite para tiquiyocatlalis para nechtequipanos queja nototajtzi tlen más hueyi. ");
INSERT INTO nheBl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Teipa xiquinhuica itelpocahua, huan xiquinyoyonti ica nopa yoyomitl huehueyac tlen inquinsencahuilijque. ");
INSERT INTO nheBl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Huan xiquinajalti ica aceite queja tijchijqui ica inintata, huan inijuanti nojquiya nechtequipanose queja totajtzitzi. Huan quema tiquinajaltis ica aceite, pehuas se familia tlen totajtzitzi tlen ax tlamis pampa iniixhuihua elise nototajtzitzi para nochipa.” ");
INSERT INTO nheBl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Huan Moisés quichijqui nochi senquistoc queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Huajca ipan nopa achtohui tonal, ipan nopa achtohui metztli quema yahuiyaya para ome xihuitl quistoyaj ipan tlali Egipto, quiquetzque nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Huan quema Moisés quiquetzqui nopa yoyon tiopamitl, quiquetzqui itepos cuatetoyo, ihuapalhua, huan quicalaqui icuaixtlapalhua huejhuehueyac huan itlaquetzalhua. ");
INSERT INTO nheBl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Teipa quipatlajque nopa cortina para quitzontzacuase, huan nojquiya nopa seyoc itzontzajca quitlali san queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Teipa quicuic nopa ome tepatlactli tlen quipixtoya itlanahuatilhua TOTECO huan quitlali ipan nopa caxa. Teipa quicalaqui nopa cuahuitl huehueyac para ica quihuicase campa monequiyaya. Huan iixco quitlali itzajca campa nopa totajtzi quinixtzacuilis inintlajtlacolhua tlacame iixtla TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Quema ya eltoya tlasencahuali nopa caxa, quicalaqui ipan nopa cuarto más tiopan calijtic, huan quicuapilo nopa cortinas para quitzacuas nopa cuarto tlen quipixtoya nopa caxa san queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Teipa ica norte ipan nopa achtohui cuarto tlen ax más calijtic, quitlali nopa cuamesa. Nopa cuarto eltoc iixpa nopa yejyectzi Cortina. ");
INSERT INTO nheBl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Huan ipan nopa cuamesa quitenqui nopa pantzi iixtla TOTECO senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Huan nojquiya ipan nopa cuarto tlen ax más calijtic, ica sur quitlali nopa tlahuil quetzali iixmelac nopa cuamesa para pantzi. ");
INSERT INTO nheBl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Huan quintlati nochi nopa tlahuili iixtla TOTECO queja TOTECO quinahuatijtoya ma quichihua. ");
INSERT INTO nheBl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Huan ipan nopa cuarto nojquiya quitlali nopa tlaixpamitl tlen oro. Huan quiquetzqui iixmelac nopa cortina tlen quitzacuayaya nopa cuarto tlen más calijtic. ");
INSERT INTO nheBl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Huan ipan nopa tlaixpamitl tlen oro, quitlati nopa copali tlen ajhuiyac queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Nojquiya Moisés quicuapilo se cortina para quitzacuas campa calaquise ipan nopa achtohui cuarto tlen ax más calijtic ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Huan ipan nopa calixpamitl iixmelac campa calaquise ipan nopa yoyon tiopamitl, quitlali nopa tlaixpamitl campa quitlatise tlacajcahualistli. Huan ipan quintlatijque tlapiyalime para tlacajcahualistli. Nojquiya quitlati tlacajcahualistli tlen harina queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Huan ipan calixpamitl tlatlajco tlen nopa yoyon tiopamitl huan tlaixpamitl campa quitlatise tlacajcahualistli, quiquetzqui nopa hueyi paila, huan quitequili atl para nopona ma moicxipajpacaca huan ma momajtequica totajtzitzi. ");
INSERT INTO nheBl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Huan Moisés ininhuaya Aarón huan itelpocahua nopona momajtequijque huan moicxipajpajque. ");
INSERT INTO nheBl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Huan monequiyaya mopajpacase queja TOTECO tlanahuatijtoya sesen huelta quema calajque ipan nopa yoyon tiopamitl o quema quinechcahuiyaya nopa tlaixpamitl campa quitlatise tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Teipa Moisés quiquetzqui nopa tlatzactli tlen cortinas tlen quitzajqui nopa calixpamitl yahualtic nopa yoyon tiopamitl huan nopa tlaixpamitl. Huan campa calaquij ipan calixpamitl, quicuapilo nopa cortina para elis queja se puerta. Huan ica ya nopa Moisés quitlamilti nopa tequitl. ");
INSERT INTO nheBl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Huan se mixtli quisentzajqui nopa yoyon tiopamitl. Huan itlatlanex TOTECO tlen nelía yejyectzi quitemiti nopa tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Huan Moisés ax huelqui calaqui tiopan calijtic pampa nopa mixtli motlalijtoya nopona. Huan itlatlanex TOTECO tlen tlahuel tlahuiyaya quisentzajqui nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Huan ipan nopa tonali quema nopa israelitame nentinemiyayaj campa hueli, intla nopa mixtli quitlalcahuiyaya nopa yoyon tiopamitl, nopa israelitame quitlalanayayaj nopa yoyon tiopamitl huan quitoquiliyayaj nopa mixtli. ");
INSERT INTO nheBl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pero intla nopa mixtli ax mijcueniyaya, inijuanti nojquiya ax mijcueniyayaj hasta quema nopa mixtli sampa mijcuenisquía. Huan huajca, quena, quema mijcuenisquía, inijuanti quitoquilisquíaj. ");
INSERT INTO nheBl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Huan queja nopa elqui ipan nochi iniojhui. Tonaya nopa mixtli tlen TOTECO motlaliyaya itzonpac nopa tiopamitl, huan tlayohua mocuepayaya se tlitl tlen mosehuiyaya nopona huan yeca nopa israelitame hueliyayaj tlachiyase tonaya huan tlayohua.");
INSERT INTO nheBl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","TOTECO quinotzqui Moisés tlen nopa yoyon tiopamitl campa mopantiyayaj huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Xiquinilhuiti nopa israelitame ni miyac tlanahuatili. Quema se quinequis nechhualiquilis se tlacajcahualistli na, niimoTECO, monequi nechhualiquilis se tlen ihuacaxhua, o se tlen iborregojhua o se tlen ichivojhua. ");
INSERT INTO nheBl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Intla elis se tlacajcahualistli tlatlatili tlen ihuacaxhua, huajca monequi nechmacas se becerro tlen ax quipiya niyon se tlamantli tlen ax cuali ipan itlacayo. Monequi quihuicas nopa tlapiyali noixtla hasta campa ipuerta nopa yoyon tiopamitl campa timopantíaj para na, niimoTECO, nijselis. ");
INSERT INTO nheBl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Huan nopa tlacatl tlen quihualica quitlalis ima ipan itzonteco nopa tlapiyali, huan queja nopa, nopa tlapiyali elis ipatlaca nopa tlacatl. Huan na nijselis nopa tlacajcahualistli huan niquitas para mijqui ipampa nopa tlacatl para quiixtzacuilis itlajtlacolhua noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Huan nopa tlacatl quimictis nopa tlapiyali nopona noixtla, niimoTECO. Huan itelpocahua Aarón, nopa totajtzitzi, quiijtzelose ieso nopa tlapiyali yahualtic nopa tlaixpamitl tlen eltoc nechca ipuerta nopa yoyon tiopamitl huan queja nopa nechmacase. ");
INSERT INTO nheBl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Huan nopa tlacatl quiquixtilis icuetlaxo nopa tlapiyali tlen elis para se tlacajcahualistli tlatlatili huan quihuejhuelos itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Teipa itelpocahua Aarón, nopa totajtzitzi, quitlipichise huan quitlalise miyac cuahuitl ipan nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Huan teipa itelpocahua Aarón quitlalise nochi nacatl tlahuejhueloli tlen nopa tlapiyali ihuaya itzonteco huan ichiyajca ipan nopa cuahuitl tlen lementos. ");
INSERT INTO nheBl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Pero achtohui quipajpacase icuitlaxcol huan imetzcuayohua nopa tlapiyali huan teipa nopa totajtzitzi quitlalise icuitlaxcol huan imetzcuayohua ipan nopa tlaixpamitl para ma tlatla. Huan ni elis se tlacajcahualistli tlatlatili tlen mijmiyotis nelía ajhuiyac noixtla huan nechyolpactis, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Huan intla nopa tlapiyali tlen temacas para se tlacajcahualistli tlatlatili elis se borrego o se chivo, huajca monequi elis se oquichtli tlen ax quipiya niyon se tlamantli tlen ax cuali ipan itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Huan nopa tlacatl tlen quihualica nopa tlacajcahualistli moquetzas nechca iquespa nopa tlaixpamitl ipan nopa lado norte huan quimictis nopa tlapiyali noixtla, na niimoTECO. Huan itelpocahua Aarón, nopa totajtzitzi, quicuise ieso nopa tlapiyali huan ica quiatzejtzelhuise yahualtic nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Huan nopa tlacatl tlen temaca nopa tlacajcahualistli, quihuejhuelos, huan nopa totajtzi quicuis nopa tlapiyali itzonteco huan ichiyajca, huan quitlalise ipan tlitl. ");
INSERT INTO nheBl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Pero nopa tlacatl tlen temacas nopa tlapiyali monequi achtohui quipajpacas icuitlaxcol huan imetzcuayohua. Huan teipa quema ya quipajpactos, nopa totajtzitzi quitlatise ipan nopa tlaixpamitl. Huan elis se tlacajcahualistli tlatlatili tlen mijmiyotis nelía ajhuiyac huan nechyolpactis, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Pero intla acajya quinequi nechmacas na, niimoTECO, se tototl para se tlacajcahualistli, huajca hueli temacas se paloma o se pichontzi. ");
INSERT INTO nheBl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","“Huan nopa totajtzi quihuicas nopa paloma o nopa pichontzi campa nopa tlaixpamitl huan quiquechilacatzos hasta quicotonas itzonteco huan quitlatis itzonteco ipan tlaixpamitl. Teipa quicahuilis ma quisa ieso nopa paloma ielchiquitipa nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Huan teipa nopa totajtzi quicuis iapompo huan iijhuiyo nopa piltototzi huan quinmajcahuas ielchiquitipa nopa tlaixpamitl ica campa quisa tonati campa eltoc nopa cuanextli. ");
INSERT INTO nheBl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Teipa quiitzquis ipan ieltlapalhua huan quitlajcotequis, pero ax quicotonas. Teipa nopa totajtzi temacas nopa paloma para se tlacajcahualistli huan quitlatis ipan tlitl tlen eltoc ipan nopa tlaixpamitl. Huan elis se tlacajcahualistli tlatlatili tlen mijmiyotis ajhuiyac huan nechyolpactis, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Quema se tlacatl quinequis nechmacas na, niimoTECO, se tlacajcahualistli tlen harina tlen trigo o cebada, monequi quicuechtilis iyol hasta mochihuas se harina tlen nelía cuechtic. Nojquiya monequis quitequilis aceite huan copali ipan nopa harina. ");
INSERT INTO nheBl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Teipa quimacas se itelpoca Aarón huan nopa totajtzi quicuis se quentzi nopa harina ica ima huan quitlatis ipan nopa tlaixpamitl queja se tlanextilijcayotl para ipan nopa tlalochtli nechmaca nochi nopa tlacajcahualistli. Huan ni elis se tlacajcahualistli tlatlatili tlen mijmiyotis ajhuiyac noixtla na, niimoTECO, huan nechyolpactis. ");
INSERT INTO nheBl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Huan nochi nopa harina tlen mocahuas tlen nopa tlacajcahualistli tlatlatili elis iniaxca Aarón huan itelpocahua, nopa totajtzitzi para quicuase. Huan nochi elis se tlacajcahualistli tlen tlahuel tlatzejtzeloltic para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Huan intla acajya quinequi nechmacas se tlacajcahualistli tlen harina tlen tlaicxitili ipan horno, huajca monequi quicuechtilis iyol hasta mochihuas se harina tlen nelía cuechtic, huan quimanelos ica aceite para quichihuas se pantzi, pero ax hueli quipiyas tlasonejcayotl. Nojquiya se tlacatl hueli nechmacas pantzi tlen queja se tlaxcali huan cacatztic tlen ax quipiya tlasonejcayotl huan san tlaajaloli ica aceite. ");
INSERT INTO nheBl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“Huan intla nopa tlacajcahualistli tlen harina eli tlaicxitili ipan se comali, huajca nojquiya monequi elis tlachihuali ica harina tlen nelía cuechtic tlen ax quipiyas tlasonejcayotl huan tlen tlamaneloli ica aceite. ");
INSERT INTO nheBl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Huan teipa monequi quihuejhuelos nopa pantzi huan ipani quitoyahuas aceite. Huan ya ni nojquiya elis se tlacajcahualistli tlen harina. ");
INSERT INTO nheBl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Huan intla nopa tlacajcahualistli tlen harina elis se pantzi tlen tlaicxitili ipan sartén, huajca nojquiya monequi elis tlachijchihuali ica harina tlen nelía cuechtic huan tlamaneloli ica aceite. ");
INSERT INTO nheBl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Huan quema se tlacatl quihualicas se tlacajcahualistli para na, niimoTECO, tlen tlaicxitili ipan horno, comali o sartén, monequi quimactilis nopa totajtzi huan yajaya quihuicas campa nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","“Huan nopa totajtzi quicuis san se quentzi tlen nopa tlacajcahualistli tlen harina para quitlatis para na ipan nopa tlitl ipan tlaixpamitl. Huan nopa poctli tlen nopa tlitl mijmiyotis ajhuiyac huan nechyolpactis, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Huan nochi tlen mocahua tlen nopa tlacajcahualistli tlatlatili elis iniaxca nopa totajtzitzi, Aarón huan itelpocahua, para quicuase. Huan nochi elis se tlacajcahualistli tlahuel tlatzejtzeloltic para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Niyon se tlacajcahualistli tlen harina tlen innechhualiquilise, ax quema huelis quipiyas tlasonejcayotl, niyon sayolnectli. Pampa ax tleno tlen inquitlatise ipan tlaixpamitl para innechmacase ax hueli quipiyas tlasonejcayotl, niyon sayolnectli. ");
INSERT INTO nheBl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Pero quema ajsis nopa ilhuitl quema inquipixcase imomil, huelis intemacase tlacajcahualistli tlen harina tlen quipiya tlasonejcayotl huan sayolnectli. Pero intla quipiya tlasonejcayotl o sayolnectli, ax hueli inquitlatise queja se tlacajcahualistli tlen ajhuiyac mijmiyotis noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","“Nojquiya monequi inquitlalise istatl ipan nochi tlacajcahualistli tlen tlasencahuali ica harina, pampa istatl eli se tlanextilijcayotl tlen inmechilnamiquiltía tlen nopa tlajtoli tlen na, niimoTeco Dios, nijchijqui imohuaya. Huajca nochipa monequi innechmacase istatl ica imotlacajcahualis. ");
INSERT INTO nheBl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Intla inquinequij innechmacase, se tlacajcahualistli tlen nopa tlen achtohui inquipixcaque ipan mili, huelis se tlamantli queja trigo o cebada iyol, monequi xijyolquixtica huan xijcacatztilica ipan tlitl. ");
INSERT INTO nheBl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Huan ipan nopa tlacajcahualistli xijteca aceite huan copali. Ya nopa nojquiya elis se tlacajcahualistli tlen harina. ");
INSERT INTO nheBl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Huan nopa totajtzitzi quicuise se quentzi tlen nopa tlacajcahualistli tlen tlamaneloli ica aceite huan copali para quitlatise noixtla para nechmacase. Huan quema quichihuase ya nopa, quiixnextise para nochi nopa tlacajcahualistli eli tlatzejtzeloltic huan noaxca na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Intla se tlacatl quinequis nechmacas na, niimoTECO, se tlacajcahualistli para ma onca tlayoltlalili nohuaya, huelis nechmacas se toro o se huacax. Pero nopa tlapiyali monequi elis tlapajpactic. Ax quipiyas niyon se tlamantli tlen ax cuali ipan itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Huan nopa tlacatl tlen quihualicas nopa tlacajcahualistli quitlalis ima ipan nopa tlapiyali itzonteco huan quimictis nopona nechca puerta tlen nopa yoyon tiopamitl. Huan itelpocahua Aarón, nopa totajtzitzi, quicuise nopa estli huan ica quiatzejtzelhuise yahualtic nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","“Huan tlen nopa tlacajcahualistli quicuise tlen nechmacase na, niimoTECO ipan tlitl. Quicuise nopa tlachiyajcayotl tlen eltoc ipan iijtico, huan nopa tlachiyajcayotl tlatlajco icuitlaxcol. ");
INSERT INTO nheBl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Huan quicuise nopa ome ieyo ica nochi ichiyajca, huan nopa parte tlen más hueyi tlen ieltapach huan quiquixtise san sejco ica ieyo. ");
INSERT INTO nheBl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Huan nochi ya ni itelpocahua Aarón, nopa totajtzitzi, quitlatise para na, niimoTECO, ipan nopa tlitl ipan tlaixpamitl. Huan elis se tlacajcahualistli tlen ajhuiyac mijmiyotis huan nechyolpactis. ");
INSERT INTO nheBl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Huan intla se tlacatl quinequis nechmacas tlacajcahualistli para ma onca tlayoltlalili nohuaya, monequi nechmacas se chivo o se borrego. Huelis nechmacase se sihuatzi o se oquichtli. Pero monequi nopa tlapiyali elis tlapajpactic. Ax hueli nechmacas niyon se tlapiyali tlen quipiya se tlamantli ax cuali ipan itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Huan san se quichihuas intla nopa tlacajcahualistli tlen nechmacas elis se pilborregojtzi. ");
INSERT INTO nheBl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Nopa tlacatl tlen temacas, quitlalis ima ipan nopa tlapiyali itzonteco, huan quimictis nopona campa ipuerta nopa yoyon tiopamitl. Teipa nopa totajtzitzi quicuise se quentzi estli huan ica quiatzejtzelhuise yahualtic nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","“Huan ipan nopa tlaixpamitl quitlalise nochi ichiyajca. Quitlalise icuitlapil tlen quipiya miyac ichiyajca huan quicotonase nechca icuitlapa nopa tlapiyali. Nojquiya quitlalise nochi ichiyajca tlen mopantía ipan iijtic huan tlatlajco icuitlaxcol. ");
INSERT INTO nheBl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Quitlatis ieyo ica nochi ichiyajca huan nopa parte tlen más hueyi tlen ieltapach tlen quiquixtise san sejco ica ieyo. ");
INSERT INTO nheBl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Huan nochi ni tlamantli nopa totajtzi quitlatis ipan nopa tlaixpamitl, huan ni elis se tlacajcahualistli tlen tlacualistli tlen nechmacase, na niimoTECO, ipan tlitl. ");
INSERT INTO nheBl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Intla se acajya quinequi quihualicas se sihua chivo para nechmacas, ");
INSERT INTO nheBl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","huajca nopa tlacatl quitlalis ima ipan nopa tlapiyali itzonteco, huan teipa quimictis nopona nechca ipuerta nopa yoyon tiopamitl campa timopantíaj. Huan nopa totajtzitzi quicuise se quentzi ieso nopa tlapiyali huan ica quiatzejtzelhuise yahualtic nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","“Huan quiquixtilise nopa tlapiyali nopa tlachiyajcayotl ipan iijtico, huan nochi nopa tlachiyajcayotl tlatlajco icuitlaxcol, huan quitlalise ipan nopa tlaixpamitl para nechmacase ipan tlitl. ");
INSERT INTO nheBl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Nojquiya quitlalise nopa ome ieyo huan nopa tlachiyajcayotl tlen eltoc ipani. Huan quitlalise nopa parte tlen más hueyi tlen ieltapach tlen quiquixtise ihuaya ieyo. ");
INSERT INTO nheBl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Huan ya ni elis se tlacajcahualistli tlen nopa totajtzi nechmacas, niimoTECO, ipan tlitl huan mijmiyotis ajhuiyac huan nechyolpactis. Nochi tlachiyajcayotl mocahua noaxca na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Quena, ya ni elis se tlanahuatili tlen monequi inquitlepanitase, imojuanti huan nochi imoixhuihua yonque campa hueli inmopantíaj: Amo xijcuaca estli, niyon tlachiyajcayotl.” ");
INSERT INTO nheBl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Huan teipa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Xiquinilhui nopa israelitame ni miyac tlanahuatili. Intla se tlen imojuanti tlajtlacolchihuas huan quiixpanos se notlanahuatil na, niimoTECO, huan ax quimati intla tlaixpano, ya ni tlen monequi quichihuas. ");
INSERT INTO nheBl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Intla elis nopa hueyi totajtzi tlen tlajtlacolchihuas yonque ax quimatiyaya, quinchihuas para nopa sequinoc tlacame nojquiya ma quihuicaca tlajtlacoli huan monequi nopa hueyi totajtzi temacas noixtla se becerro tlen ax tleno quipiya tlen ax cuali ipan itlacayo. Ya nopa elis se tlacajcahualistli para nopa tlajtlacoli tlen ya quichijtoc. ");
INSERT INTO nheBl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Huan monequi nopa hueyi totajtzi quihuicas nopa tlapiyali campa ipuerta nopa yoyon tiopamitl campa timopantíaj, huan nopona quitlalis ima ipan itzonteco nopa tlapiyali huan quimictis nopona noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Huan teipa nopa hueyi totajtzi quicuis se quentzi nopa tlapiyali ieso huan quihuicas ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Huan nopa totajtzi quixolonis imacpil ipan nopa estli huan quiatzejtzelhuis chicome hueltas noixtla nopona iixmelac nopa cortina tlen quitzacua nopa cuarto campa Más Tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Teipa nojquiya nopa hueyi totajtzi quiajalos estli nopa nahui icuacua nopa tlaixpamitl campa quitlatíaj copali tlen mocahua yoyon tiopan calijtic noixtla. Huan nopa estli tlen noja mocahua, quitoyahuas tlalchi itzintla nopa tlaixpamitl para tlacajcahualistli tlatlatili tlen eltoc nechca ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Teipa quiquixtilis nochi nopa tlachiyajcayotl tlen eltoc ipan iijtico nopa becerro huan nochi tlen eltoc tlatlajco icuitlaxcol. ");
INSERT INTO nheBl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Nojquiya quiquixtis nopa ome ieyo ihuaya ininchiyajca huan nopa parte tlen más hueyi tlen ieltapach tlen quiquixtis san sempa ica nopa ieyo. ");
INSERT INTO nheBl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Huan nochi ni tlamantli nopa totajtzi nechmacas na, niimoTeco, ipan nopa tlaixpamitl para tlacajcahualistli tlatlatili. Quiijtosnequi quichihuas san se queja quichijqui ica nopa becerro tlen nechmacas queja se tlacajcahualistli para ma onca tlayoltlalili nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Pero icuetlaxo nopa becerro, huan inacayo, itzonteco, iicxihua, icuitlaxcol huan icuitl, ");
INSERT INTO nheBl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","quinequi quiijtos nochi tlen mocahua, monequi quicahuatij ipan se lugar tlen tlapajpactic noixtla huan tlen mopantía huejca tlen nopa yoyon caltini campa inmochijtoque. Quena, quihuicase campa concahuaj nopa cuanextli tlen nopa tlacajcahualistli tlen quitlatíaj ipan tlaixpamitl. Huan nopona quitlatise ipan cuahuitl tlen mocahua tlen nopa becerro tlen elqui nopa tlacajcahualistli ipampa tlajtlacoli tlen nopa totajtzi quichijqui. ");
INSERT INTO nheBl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Intla nochi israelitame quichihuase se tlajtlacoli, o intla quichihuase se tlamantli tlen na, niimoTECO, niquinnahuatijtoc ma ax quichihuaca, yonque niyon se tlen inijuanti ax momacayaya cuenta tlen nopa tlajtlacoli, nochi nopa tlacame quihuicase tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Huajca quema momacase cuenta para quichijtoque tlajtlacoli, monequi quihualicase se becerro huan nechmacase queja se tlacajcahualistli ipampa tlajtlacoli. Nopa becerro quihualicase iixpa nopa yoyon tiopamitl, ");
INSERT INTO nheBl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","huan noixtla nopa huehue tlacame tlen quinyacanaj israelitame quitlalise ininma ipan nopa tlapiyali itzonteco huan nopona quimictise. ");
INSERT INTO nheBl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Teipa nopa hueyi totajtzi quicuis quentzi ieso nopa tlapiyali huan quihuicas ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Huan teipa quixolonis imacpil ipan nopa estli huan quiatzejtzelhuis chicome hueltas noixtla iixmelac nopa cortina. ");
INSERT INTO nheBl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Huan nojquiya ica nopa estli quiajalos nopa nahui icuacua nopa tlaixpamitl tlen eltoc noixtla tiopan calijtic. Huan nopa estli tlen noja mocahuas quitoyahuas tlalchi itzintla nopa tlaixpamitl campa temaca tlacajcahualistli tlatlatili. Nopa tlaixpamitl mocahua nechca ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Huan nojquiya quiquixtilis nopa becerro nochi ichiyajca, huan quitlatis ipan nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Huan san se quichihuas nopa totajtzi ica ni becerro tlen temacaj queja quichijqui ica nopa becerro para nopa tlacajcahualistli ipampa tlajtlacoli. Huan queja nopa quichihuas nopa totajtzi para quiixtzacuas nochi nopa tlajtlacoli tlen quichijque nopa israelitame, huan niquintlapojpolhuis. ");
INSERT INTO nheBl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Teipa tlen mocahuas tlen ni becerro nopa totajtzi quihuicas quentzi huejca tlen campa inmochijtoque. Nopona quitlatis queja niquijto quitlatisquía ne seyoc becerro. Ya ni elis se tlacajcahualistli para nochi inintlajtlacolhua nochi israelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Intla se tlayacanquetl ipan nopa israelitame quichihuas se tlajtlacoli huan quiixpanos se notlanahuatil, niimoTECO Dios, yonque ax quimatqui, huajca yajaya quihuica tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Huajca quema ya quimachilijtos para quichijtoc se tlajtlacoli, nimantzi ma quihuicas se oquich chivo para nechmacas queja se tlacajcahualistli. Nopa tlapiyali monequi elis tlapajpactic. Ax quipiyas tlen ax cuali ipan itlacayo. ");
INSERT INTO nheBl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Huan nopa tlacatl quitlalis ima ipan nopa oquich chivo itzonteco huan quimictis campa quinmictíaj tlapiyalime para tlacajcahualistli tlatlatili. Huan teipa nechmactilis na, niimoTECO, huan elis se tlacajcahualistli para itlajtlacol. ");
INSERT INTO nheBl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Teipa nopa totajtzi ica imacpil quicuis se quentzi ieso nopa tlapiyali tlen quitencajque queja se tlacajcahualistli ipampa tlajtlacoli huan quiajalos nopa nahui icuacua nopa tlaixpamitl para tlacajcahualistli tlatlatili. Huan nochi nopa estli tlen noja mocahuas quitoyahuas itzintla nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Huan nochi ichiyajca nopa oquich chivo nojquiya monequi nechmacase ipan tlitl queja quitlatíaj ichiyajca nopa tlapiyali tlen se tlacajcahualistli para ma onca tlayoltlalili nohuaya, niimoTECO. Huan quema quichijtos nochi ya ni, teipa nijtlapojpolhuis nopa tlayacanquetl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Intla aqui hueli israelita quichihuas se tlajtlacoli, yajaya quihuica tlajtlacoli yonque ax quimatqui para na, niimoTECO, nitlanahuatijtoya axaca ma quichihua nopa tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Huan teipa quema ya quimachilijtos para quichijtoc nopa tlajtlacoli, nimantzi monequi quihuicas se chivo tlen sihuatzi tlen ax quipiya niyon se tlamantli tlen ax cuali ipan itlacayo. Huan ya nopa elis se tlacajcahualistli para nopa tlajtlacoli tlen quichijqui. ");
INSERT INTO nheBl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Huan quihuicas nopa tlapiyali campa quinmictíaj nopa tlapiyalime para tlacajcahualistli tlatlatili. Huan nopona quitlalis ima ipan nopa tlapiyali itzonteco tlen elis se tlacajcahualistli ipampa tlajtlacoli huan teipa quimictis. ");
INSERT INTO nheBl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Huan nopa totajtzi quicuis ica imacpil se quentzi ieso huan quiajalos ipan nopa nahui icuacua nopa tlaixpamitl para tlacajcahualistli tlatlatili. Huan nopa estli tlen noja mocahuas, quitoyahuas tlalchi itzintla nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Nojquiya nopa tlacatl monequi quiquixtilis nochi ichiyajca nopa tlapiyali. Quena, san se quichihuas queja quichihua ica se tlacajcahualistli para ma onca tlayoltlalili nohuaya. Huan teipa nopa totajtzi quitlalis nopa tlachiyajcayotl ipan nopa tlaixpamitl huan quitlatis. Huan elis se tlacajcahualistli tlen mijmiyotis ajhuiyac huan nechpactis na, niimoTECO. Huan queja nopa, quichihuas nopa totajtzi para nechixtzacuilis itlajtlacol nopa tlacatl. Huan nijtlapojpolhuis. ");
INSERT INTO nheBl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Pero intla nopa tlacatl quinequi nechmacas se pilborregojtzi para se tlacajcahualistli ipampa tlajtlacoli, hueli quihualicas se pilsihua borregojtzi tlen ax quipiya ipan itlacayo niyon se tlamantli tlen ax cuali. ");
INSERT INTO nheBl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Huan quitlalis ima ipan itzonteco nopa tlapiyali huan quimictis campa quinmictíaj nopa tlapiyalime tlen quintequihuíaj para tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Huan nopa totajtzi quicuis se quentzi ieso nopa tlapiyali ica imacpil huan quiajalos ipan icuacua nopa tlaixpamitl para tlacajcahualistli tlatlatili. Huan nopa estli tlen noja mocahuas quitoyahuas tlalchi itzintla nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Teipa quiquixtilis nochi ichiyajca nopa pilsihua borregojtzi. Quena, san se quichihuas queja quichijqui ica nopa pilborregojtzi tlen nechtencahuilijque queja se tlacajcahualistli para ma onca tlayoltlalili nohuaya. Huan nopa totajtzi quitlatis nochi nopa tlachiyajcayotl ipan nopa tlaixpamitl huan nechmacas na, niimoTECO, ica nopa tlitl. Huan ica tlen quichihua nopa totajtzi nechixtzacuilis nopa tlajtlacoli tlen nopa tlacatl quichijqui, huan nijtlapojpolhuis. ");
INSERT INTO nheBl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Intla se acajya quiitztoc quema panoc se tlamantli ax cuali, o quicactoc se tlajtoli ax cuali, huan teipa tequitini quitemohuaj se testigo tlen quiitztoc nopa tlamantli o quicactoc nopa tlajtoli, huajca monequi teyolmelahuas tlen nelía quiitztoc o quicactoc. Pampa intla ax teyolmelahuas tlen panoc, yajaya quihuicas tlajtlacoli noixtla huan monequi nechhualiquilis se tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Nojquiya monequi quihualicas se tlacajcahualistli intla se acajya quiitzquis se tlamantli tlen ax tlapajpactic. Intla mictoc se tlapiyali tlen ax tlapajpactic para inquicuase yonque teaxca o ehua cuatitla, huan se tlacatl quiitzquis itlacayo, monequi nechhualiquilis se tlacajcahualistli. Nojquiya mochihuas ax tlapajpactic noixtla tlen quiitzquis itlacayo piltlapiyaltzi tlen mohuahuatatza tlalchi yonque tlen quiitzqui ax quimatiyaya intla quiitzqui. Pero temachtli mochijtoc ax tlapajpactic huan monequi nechhualiquilis se tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“O intla quiitzquis cuitlatl o tlen hueli atl tlen quistoc ipan itlacayo se tlacatl, ayoc tlapajpactic noixtla. Huan quema momacas cuenta para quichijtoc nopa tlamantli huan quihuica tlajtlacoli noixtla, monequi quihualicas se tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Intla se acajya tlatestigojquetzas para quichihuas se tlamantli tlen cuali o ax cuali, huan teipa motejtemos huan momacas cuenta para achi cuali ax camatitosquía, yajaya quihuicas tlajtlacoli noixtla huan monequi quihualicas se tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Intla se acajya quichihuas tlen hueli tlen ni tlamantli, huajca monequi nechilhuis na, niimoTECO, tlaque quichijtoc, ");
INSERT INTO nheBl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","huan monequi quihualicas noixtla nopa tlacajcahualistli para nopa tlajtlacoli tlen quihuica. Huelis quihualicas se sihua borrego o se sihua chivo. Huan nopa totajtzi nechmacas para nechixtzacuilis itlajtlacol nopa tlacatl noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Pero intla nopa tlacatl ax quipiya miyac tomi para quicohuas se pilborregojtzi, huajca hueli nechmacas ome palomas o ome pichontzitzi. Huan ni totome elise tlacajcahualistli para nopa tlajtlacoli tlen quihuica. Nechmacas se queja se tlacajcahualistli ipampa tlajtlacoli huan nopa seyoc nechmacas queja se tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Huan nopa totome quinhualicas campa nopa totajtzi huan yajaya temacas nopa achtohui piltototzi queja se tlacajcahualistli ipampa tlajtlacoli. Achtohui quipilquechilacatzos pero ax quicahuilis ma cotoni itzonteco. ");
INSERT INTO nheBl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Teipa quicuis se quentzi ieso huan ica quiatzejtzelhuis se ielchiqui nopa tlaixpamitl. Huan nopa estli tlen noja mocahuas quitoyahuas tlalchi itzintla nopa tlaixpamitl. Huan ya ni elis se tlacajcahualistli ipampa tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Huan nopa ompa piltototzi nechmacas queja se tlacajcahualistli tlatlatili, huan quichihuas san se queja quiijtohua nopa tlanahuatili. Huajca queja nopa quichihuas nopa totajtzi para nechixtzacuilis itlajtlacol nopa tlacatl noixtla. Huan na, niimoTECO, nijtlapojpolhuis. ");
INSERT INTO nheBl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Huan intla itomi se acajya noja ax quiaxilía para quincohuas ome palomas o ome pichones, hueli quihuicas ome kilo harina para nechmacas queja se tlacajcahualistli ipampa itlajtlacolhua. Pero ax quitlalilis aceite, niyon copali, pampa ni elis se tlacajcahualistli ipampa tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Huan monequi quihualicas nopa harina campa nopa totajtzi, huan nopa totajtzi quicuis se quentzi tlen nopa tlacajcahualistli queja se tlanextilijcayotl para nechmaca nochi nopa harina. Huan quitlatis ne quentzi ipan nopa tlaixpamitl queja quitlatía nochi sequinoc tlacajcahualistli para na. Ya ni elis se tlacajcahualistli ipampa tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Huan ica nochi ya ni nopa totajtzi quiixtzacuilis itlajtlacol tlen quichijtoc nopa tlacatl, huan na nijtlapojpolhuis nopa tlajtlacoli tlen quichijtoc. Huan nopa harina tlen noja mocahuas elis para nopa totajtzitzi inintlacualis queja nojquiya mochihua ica nochi tlen mocahua quema temacaj tlacajcahualistli tlen harina.” ");
INSERT INTO nheBl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Intla se tlacatl quichihuas tlen ax cuali, huan quisoquihuijtos tlamantzitzi tlen tlatzejtzeloltique, huan ax momaca cuenta quema quichihua, teipa quema quimatis, monequi quihualicas se tlacajcahualistli pampa tlajtlacole noixtla. Huan nopa tlacajcahualistli elis se oquich chivo tlen ax quipiya niyon se tlamantli tlen ax cuali ipan itlacayo. Huan nopa tlapiyali monequi elis ipati queja ome plata tomi tlen motequihuía ipan nopa yoyon tiopamitl o achi más. Ni elis se tlacajcahualistli para tlen quihuica tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Huan nopa tlacatl monequi quiixtlahuas tlen ipati nopa tlamantli tlen quisoquihuijtoc tlen achtohui eliyaya tlatzejtzeloltic. Huan nojquiya quitlalis seyoc 20 por ciento más. Queja nopa, nopa totajtzi nechixtzacuilis itlajtlacol nopa tlacatl noixtla, huan na, niimoTECO, nijtlapojpolhuis. ");
INSERT INTO nheBl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Aqui hueli tlacatl tlen quiixpanos notlanahuatil, niimoTECO, yonque ax momaca cuenta, quihuica tlajtlacoli noixtla huan monequi quiselis itlatzacuiltilis. ");
INSERT INTO nheBl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Huan monequi quihuicas se tlacajcahualistli campa nopa totajtzi. Huan nopa tlacajcahualistli elis se oquich borrego tlen ipati queja tlen ta, Moisés, tiquijtos. Huan nopa oquich borrego ax quipiyas niyon se tlamantli tlen ax cuali ipan itlacayo. Huan nopa totajtzi nechmacas nopa tlacajcahualistli para nechixtzacuilis itlajtlacol nopa tlacatl pampa ax quimatqui intla quichihuayaya tlajtlacoli. Huan na, niimoTECO, nijtlapojpolhuis. ");
INSERT INTO nheBl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ya ni elis se tlacajcahualistli para tlen quihuica tlajtlacoli pampa tlajtlacolchijtoc noixtla.” ");
INSERT INTO nheBl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Intla se acajya tlajtlacolchihuas huan quicajcayahuas seyoc pampa ax quineltocac notlajtol, niimoTECO, monequi quihualicas se tlacajcahualistli. Huelis ya ax quimocuitlahui cuali tlen ihuampo quicahuili imaco para quimocuitlahuis, o huelis quiichtequilijtoc, o quiquixtilijtoc se tlenijqui pampa yajaya más tetic, o huelis ax tlacuepqui tlen quitlanejtijque. ");
INSERT INTO nheBl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","O huelis se tlacatl quipantis tlen seyoc quipolojtoya, huan istlacatis o tlatestigojquetzas ica tlen ax melahuac huan quiijtos ax quiitztoc. Nochi ya ni se tlajtlacoli. Nojquiya tlajtlacoli tlen hueli tlamantli ax cuali tlen se tlacatl quichihua ica tlamantzitzi tlen seyoc iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Huan quema mopantis o seyoc quipantis para tlajtlacolchijtoc huan quihuica tlajtlacoli noixtla pampa quipiya tlen ax iaxca, o tlatestigojquetztoc ica tlen ax melahuac, huajca nimantzi monequi ma quicuepas nopa tlamantli. ");
INSERT INTO nheBl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Huan iyoca monequi noja temacas seyoc 20 por ciento queja elisquía se multa. Nochi temacas ipan san se tonal quema ipan nopa yoyon tiopamitl nechmacas se tlacajcahualistli para nopa tlajtlacoli tlen quihuica. ");
INSERT INTO nheBl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Monequi nechhualiquilis se oquich borrego tlen tlapajpactic huan senquistoc cuali itlacayo huan tlen cuali ipati. ");
INSERT INTO nheBl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Huan nopa totajtzi nechmacas nopa tlapiyali huan nechixtzacuilis itlajtlacol nopa tlacatl tlen na. Huan na, quena, nijtlapojpolhuis tlen hueli tlen quichijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Xiquinilhuiti Aarón huan itelpocahua para quej ni eltoc tlanahuatili para se tlacajcahualistli tlatlatili. Nopa tlacajcahualistli monequi eltos ipan nopa tlitl seyohual hasta ijnaloc huan nopa tlitl mocahuas lementoc. ");
INSERT INTO nheBl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Huan hualmostla nopa totajtzi moquentis itlatzintlanyoyo tlen lino nechca itlacayo huan teipa iyoyo huehueyac tlen lino. Huan quiquixtis nopa cuanextli tlen mocahua tlen nopa tlacajcahualistli huan quitlalis ipan se lado nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Teipa quiquixtis nopa iyoyo huan moquentis ne seyoc tlamantli iyoyo huan quihuicas nopa cuanextli hasta se lugar tlen tlapajpactic noixtla tlen mocahua huejca tlen campa inmochijtoque, huan nopona quicahuas. ");
INSERT INTO nheBl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","“Nochipa monequi lementos se tlitl ipan tlaixpamitl. Ma ax quicahuase ma sehui. Huan sese ijnaloc nopa totajtzi monequi quitlalilis cuahuitl nopa tlaixpamitl huan teipa quitlalis nopa tlapiyali para nopa tlacajcahualistli tlatlatili tlen monequi mojmostla. Nojquiya nopona quitlatis nopa tlachiyajcayotl tlen nopa tlacajcahualistli tlen tlacame temacaj para ma moyoltlalica nohuaya, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Quena, ax quema hueli quicahuase para sehuis nopa tlitl ipan tlaixpamitl. Monequi nochipa lementos. ");
INSERT INTO nheBl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Ya ni nopa miyac tlanahuatili para tlacajcahualistli tlen harina. Itelpocahua Aarón monequi moquetzase iixmelac nopa tlaixpamitl para nechmacase nopa tlacajcahualistli noixtla na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Se tlacajcahualistli tlen harina elis tlen se harina tlen quicuechtilijtoque nelcuechtic huan quimanelojtoque ica aceite huan copali. Huan se tlen nopa totajtzitzi quicuis ica ima se quentzi tlen nopa tlacajcahualistli tlen harina huan quitlatis ipan nopa tlaixpamitl para quinextis nechtencahuilijtoc nochi noixtla. Huan mijmiyotis ajhuiyac noixtla na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Huan ica nopa harina tlen mocahua tlen nopa tlacajcahualistli, Aarón huan itelpocahua, nopa totajtzitzi, quichihuase pantzi para quicuase, pero ax huelis quitlalilise tlasonejcayotl ipani. Huan monequi quicuase nopona campa tlatzejtzeloltic ipan nopa calixpamitl ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ma quipiyaca cuidado ma ax quiicxitica ica tlasonejcayotl. Niquinmacatoc ni harina para elis iniaxca tlen nochi nopa tlacajcahualistli tlen nechmacaj ica tlitl. Eltoc tlahuel tlatzejtzeloltic queja nojquiya tlatzejtzeloltic nopa tlapiyalime tlen nechmacaj para tlacajcahualistli ipampa tlajtlacoli huan para tlen quihuica tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nochi itlaca conehua huan itlaca ixhuihua Aarón hueli quicuase tlen mocahuas tlen nochi nopa tlacajcahualistli tlen nechmaca ica tlitl. Huan quej ni elis tlanahuatili para iteipa ixhuihua tlen oquichpilme tlen tlacajtiyase ipan ifamilia Aarón teipa. Pero san inijuanti hueli quicuase pampa inijuanti tlaiyocatlalilme para na. Mochihuas tlatzejtzeloltic aqui hueli tlacatl tlen quiitzquis nopa pantzi tlen quichijtoque ica harina tlen mocajqui tlen nopa tlacajcahualistli. Nojquiya mochihuas tlatzejtzeloltic tlen hueli tlacatl o tlamantli tlen quitoxomas.” ");
INSERT INTO nheBl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ipan nopa tonal quema Aarón o iteipa ixhuihua moiyocatlalise para ma elica totajtzitzi, sesen monequi quihualicas para na, niimoTECO, ni tlacajcahualistli. Nechmacas se tlacajcahualistli tlen quipiya ome kilos tlen harina nelcuechtic. Huan tlajco tlen nopa tlacajcahualistli nechmacase ica ijnaloc huan nopa seyoc tlajco nechmacase ica tiotlac. ");
INSERT INTO nheBl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Nopa tlacajcahualistli monequi elis tlaicxitili ipan se comali huan cuali tlamaneloli ica aceite. Huan quema ya icsitoc, quihuejhuelos nopa pantzi tlen quichijtoque ica nopa tlacajcahualistli tlen harina huan nechmacas. Huan mijmiyotis nelía ajhuiyac para na. ");
INSERT INTO nheBl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Huan san se nechmacas nopa itelpoca tlen se tonal calaquis queja nopa yancuic hueyi totajtzi ipatlaca Aarón. Huan ni tlacajcahualistli elis noaxca na, niimoTECO, huan monequi quitlatise nochi nopa tlacajcahualistli para nechmacase ipan poctli pampa quej nopa nimechnahuatía. ");
INSERT INTO nheBl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Huajca monequi quitlatis senquistoc nochi nopa tlacajcahualistli tlen harina tlen nopa totajtzi nechmacas para ya iselti. Niyon quentzi axaca hueli quicuas.” ");
INSERT INTO nheBl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Xiquinilhui Aarón huan itelpocahua ni miyac tlanahuatili para nopa tlacajcahualistli ipampa tlajtlacoli. Ni tlacajcahualistli tlen tlahuel tlatzejtzeloltic huan nopa tlapiyali monequi quimictise campa quinmictíaj tlapiyalime para tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Huan nopa nacatl tlen mocahuas elis iaxca nopa totajtzi tlen nechmacas nopa tlacajcahualistli ipampa tlajtlacoli para quicuas, pero monequi quicuas campa tlatzejtzeloltic nopona ipan calixpamitl, iixpa nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Tlen hueli tlamantli o tlacatl tlen quitoxomas quentzi nopa nacatl mochihuas tlatzejtzeloltic, tlaiyocatlalili para nechtequipanos na. Huan intla se quentzi tlen ieso quiajsis iyoyo, nopa tlacatl monequi quichicuenis iyoyo nopona campa tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Intla quiicxitía nopa nacatl ipan se comitl tlachijchihuali ica soquitl, monequi quitlapanas teipa. Pero intla quiicxitía nopa nacatl ipan se tlamantli tlachijchihuali ica nopa tepostli bronce, san monequi quipajpacas ica miyac cuidado teipa. ");
INSERT INTO nheBl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“San totajtzitzi huan inioquichpilhua hueli quicuase se tlacajcahualistli ipampa tlajtlacoli, pampa ni nopa tlacajcahualistli tlen tlahuel tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pero intla ieso nopa tlapiyali ya quihuicatoque tiopan calijtic campa nopa cuarto tlen Más Tlatzejtzeloltic para quiixtzacuase inintlajtlacol tlacame, huajca axaca hueli quicuas inacayo. Nochi itlacayo nopa tlacajcahualistli monequi inquitlatise noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Ya ni nopa tlanahuatili para nopa tlacajcahualistli para tlen quihuica tlajtlacoli noixtla, niimoTECO. Nopa tlacajcahualistli elis tlahuel tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nopa tlapiyali tlen quitencajtoque queja se tlacajcahualistli para tlen quihuica tlajtlacoli, monequi quimictise ipan nopa lugar campa quinmictíaj nopa tlapiyalime tlen quintequihuíaj para tlacajcahualistli tlatlatili. Huan ica ieso nopa tlapiyali quiatzejtzelhuise yahualtic nopa tlaixpamitl itzintla. ");
INSERT INTO nheBl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Huan nopa totajtzi nechmacas nochi ichiyajca yonque tlen mopantía campa tlatzquitoc icuitlapil o ipan icuitlaxcol. ");
INSERT INTO nheBl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Huan temacas nopa ome ieyo ihuaya nopa tlachiyajcayotl tlen mopantía ininpani. Nojquiya temacas nopa parte hueyi tlen ieltapach tlen quiquixtis ihuaya ieyo. ");
INSERT INTO nheBl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Teipa nopa totajtzi quitlatis nochi nopa partes ipan tlaixpamitl, huan elis se tlacajcahualistli para tlen quihuica tlajtlacoli. Elis se tlacajcahualistli tlen nechmacase niimoTECO ica tlitl huan mijmiyotis ajhuiyac noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Nochi totajtzitzi hueli quicuase nopa nacatl tlen mocahua tlen se tlacajcahualistli para tlen quihuica tlajtlacoli, pero monequi quicuase campa tlatzejtzeloltic pampa ni se tlacajcahualistli tlahuel tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“San se tlanahuatili eltoc para nopa nacatl tlen mocahua tlen nopa tlacajcahualistli ipampa tlajtlacoli huan nojquiya para nopa tlacajcahualistli para tlen quihuica tlajtlacoli. Nopa nacatl iniaxca nopa totajtzitzi tlen temacase nopa tlacajcahualistli para nechixtzacuilise nopa tlajtlacoli noixtla huan inijuanti ma quicuaca. ");
INSERT INTO nheBl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Pero quema se totajtzi nechmacas se tlacajcahualistli tlatlatili para se tlacatl, nopa totajtzi san quiselis nopa tlapiyali icuetlaxo. ");
INSERT INTO nheBl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Huan nojquiya nochi tlacajcahualistli tlen harina tlen tlaicxitili ipan horno, comali o sartén, elis para ma quitequihui nopa totajtzi tlen nechmacas. ");
INSERT INTO nheBl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Pero nochi tlacajcahualistli tlen harina yonque tlamaneloli ica aceite o axtle, elis san se iniaxca nochi Aarón iixhuihua. Huan monequi quinmajmacase sesen inijuanti san se imiyaca. ");
INSERT INTO nheBl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Ya ni nopa tlanahuatili para nopa tlacajcahualistli para ma onca tlayoltlalili nohuaya tlen tlacame temacaj. ");
INSERT INTO nheBl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Intla eli se tlacajcahualistli para tlascamatili, monequi temacase ihuaya pantzi tlen quipiya aceite, pero ax quipiyas tlasonejcayotl. Nojquiya monequi temacas ihuaya pantzi sepantic huan cacatztic tlen ax quipiya tlasonejcayotl huan tlen tlaajaloli ica aceite. Nojquiya monequi temacas pantzi tlen harina tlen tlahuel tlatzatzaltili huan tlen quihuica aceite. ");
INSERT INTO nheBl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pero ica ni tlacajcahualistli para tlascamatili monequi quihualicas pantzi tlen, quena, quipiya tlasonejcayotl. ");
INSERT INTO nheBl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Se quentzi tlen sesen tlamantli tlen ni tlacajcahualistli nopa totajtzi quitlejcoltis huejcapa huan quihuisos noixtla para nechmacas. Huan teipa ni elis iaxca nopa totajtzi tlen tlapalehuía huan quiatzejtzelhuía estli tlen nopa tlapiyali ipan tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","“Huan tlen quitencajqui nopa tlapiyali queja se tlacajcahualistli para ma onca tlayoltlalili nohuaya huan para nechtlascamatis monequi quicuas inacayo nopa tlapiyali ihuaya ifamilia ipan san se nopa tonali quema nechmacas. Ax tleno huelis quicahuase para seyoc tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Pero intla se tlacatl quihualicas se tlacajcahualistli para ma onca tlayoltlalili nohuaya pampa tlatestigojquetza tlen quichihuas o tlen ax quichihuas, o intla quihualica san ica ipaquilis, huajca quena, nopa nacatl tlen mocahuas elis iaxca tlen quihualicac. Huan inijuanti quicuase nopa tonal o hasta hualmostla. ");
INSERT INTO nheBl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Huan intla ipan eyi tonali noja eltos nopa nacatl, huajca monequi quitlatis nochi. ");
INSERT INTO nheBl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Pero intla se tlacatl quicuasquía nacatl ipan eyi tonali tlen quisqui tlen se tlacajcahualistli para ma onca tlayoltlalili nohuaya tlen yajaya nechmacac, nopa tlacajcahualistli ayoc elis se tlamantli tlen nechpactis na. Ax nijselis nopa tlacajcahualistli huan niquitas para se tlamantli fiero noixtla huan ax nijselis yajaya tlen nechmacac. Huan nopa tlacatl tlen quicuajqui ipan eyi tonali quihuicas itlajtlacol noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Nojquiya intla quentzi nopa nacatl huetzis ipan se tlamantli tlen ax tlapajpactic noixtla, huajca ayoc aca huelis quicuas. Monequi quitlatise nochi. “Pero nopa nacatl tlen ax quiajsis tlen ax tlapajpactic, quena, aqui hueli tlacatl tlen ax tlapajpactic hueli quicuas. ");
INSERT INTO nheBl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","“Huan intla aqui hueli tlacatl tlen ax tlapajpactic quicuas se quentzi inacayo nopa tlapiyali tlen noaxca na, niimoTECO, pampa se nechmacatoc queja se tlacajcahualistli para ma onca tlayoltlalili nohuaya, monequi xijquixtica tlen imojuanti para ayoc quema huelis itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“Mahuilili intla se tlacatl quitoxomas tlen ax tlapajpactic, yonque tlen quisa ipan inintlacayohua tlacame, o se tlapiyali tlen ax tlapajpactic, o tlen hueli tlamantli tlen ax tlapajpactic noixtla. Tlen quitoxomas tlen ax tlapajpactic huan teipa quicuas quentzi nacatl tlen se tlacajcahualistli para ma onca tlayoltlalili nohuaya tlen ya o seyoc nechmacatoc, monequi xijquixtica tlen imojuanti para ayoc quema huelis itztos ica inisraelitame.” ");
INSERT INTO nheBl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Huan teipa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Xiquinilhui nopa israelitame ni tlanahuatili. Axaca huelis quicuas niyon se tlamantli tlachiyajcayotl, yonque ininchiyajca huacaxme, borregojme o chivojme. ");
INSERT INTO nheBl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Pero ininchiyajca tlapiyalime tlen mijque ica ininselti o tlen quinmictijque sequinoc tecuanime, hueli xijtequihuica ininchiyajca ica tlen hueli tequitl, pero amo xijcuaca. ");
INSERT INTO nheBl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","“Huan intla aqui hueli tlacatl quicuas ichiyajca se tlapiyali tlen quitencajtoque queja se tlacajcahualistli para na ipan tlitl, monequi xijquixtica tlen imojuanti para ayoc quema huelis itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“Yonque campa hueli inmochansehuíaj, amo quema xijcuaca estli. Amo xijcuaca inieso totome tlen patlanij, niyon sequinoc tlamantli tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Intla se tlacatl quicuas estli, monequi xijquixtica tlen imojuanti para ayoc quema huelis itztos ica inisraelitame.” ");
INSERT INTO nheBl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Xiquinilhui nopa israelitame ni miyac tlanahuatili. Quema se acajya quinequis nechmacas na, niimoTECO, se tlacajcahualistli para ma onca tlayoltlalili nohuaya, monequi quihualicas nopa partes tlen monequi quitlatis noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Quena, monequi ya iselti quihualicas ica ima nopa tlachiyajcayotl ihuaya iyolixpa tlen nopa tlacajcahualistli para quitlatise noixtla. Pero achtohui nopa tlapiyali iyolixpa monequi quihuisos nopa totajtzi noixtla campa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Huan teipa iyolixpa nopa tlapiyali elis iniaxca Aarón huan itelpocahua para ma quicuaca. Pero nopa totajtzi nechmacas nochi nopa tlachiyajcayotl ipan tlitl ipan tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Nojquiya quema se nechmacas se tlacajcahualistli para ma onca tlayoltlalili nohuaya, monequi nechmacas nopa tlapiyali imetzcuayo nejmatl para elis iaxca nopa totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Quema se israelita temacas se tlacajcahualistli para ma onca tlayoltlalili nohuaya, nopa totajtzi tlen nechmacas ieso huan ichiyajca nopa tlapiyali quiselis imetzcuayo nopa tlapiyali para iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pampa na nijquixtilijtoc iyolixpa huan imetzcuayo nejmatl tlen nopa tlapiyali tlen quihuisohua noixtla para nechmacase, huan nijmacatoc Aarón huan itelpocahua para elis iniaxca nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Quena, ipan nopa tonal quema Aarón huan itelpocahua monextijque noixtla para mochihuase totajtzitzi, niquiniyocatlali ni partes para ma quicuaca tlen nochi tlacajcahualistli tlatlatili tlen tlacame nechmacase na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Huan ipan nopa tonali quema niquintequitlali para ma elica totajtzitzi nitlanahuati para israelitame ma quinmacaca totajtzitzi ni partes pampa quintocarohua. Huan ya nopa monequi nopa totajtzitzi quiselise hasta ininteipa ixhuihua tlacajtiyase huan para nochipa.” ");
INSERT INTO nheBl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Huajca nica eltoc nopa miyac tlanahuatili para quejatza ma tijmacaca TOTECO se tlacajcahualistli tlen harina, se tlacajcahualistli ipampa tlajtlacoli huan se tlacajcahualistli para tlen quihuica tlajtlacoli iixtla, huan se tlacajcahualistli para ma onca tlayoltlalili ihuaya. Nojquiya techilhuía catlía tlacajcahualistli monequi temacas se totajtzi para moiyocatlalis quema quiselía itequi para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Nochi ni miyac tlanahuatili TOTECO quimacac Moisés ipan nopa tepetl Sinaí quema nopa israelitame noja itztoyaj ipan nopa huactoc tlali, pampa nopona TOTECO techilhui para monequi ma tijhuicaca tlacajcahualistli iixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ama xiquinhuica Aarón huan itelpocahua hasta campa ipuerta nopa yoyon tiopamitl. Huan xijhuica ininyoyo nopa totajtzitzi huan nopa aceite para tiquinaltis. Nojquiya xijhuica nopa becerro tlen nechmacase queja se tlacajcahualistli ipampa tlajtlacoli. Huan xijhuica nopa ome oquich borregojme huan nopa chiquihuitl ica pantzi tlen ax quipiya tlasonejcayotl. ");
INSERT INTO nheBl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Huan xiquinilhui nochi nopa israelitame nojquiya ma mosentilica nopona.” ");
INSERT INTO nheBl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Huajca Moisés quichijqui nochi senquistoc queja TOTECO quinahuati. Huan quema mosentilijtoyaj nochi israelitame campa ipuerta nopa yoyon tiopamitl, ");
INSERT INTO nheBl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moisés quinilhui: “Ya ni tlen TOTECO tlanahuatijtoc ma tijchihuaca.” ");
INSERT INTO nheBl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Huan teipa Moisés quichijqui ma monechcahuica Aarón huan itelpocahua huan quinpajpajqui ica atl. ");
INSERT INTO nheBl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Huan teipa quiquenti Aarón itlatzintlanyoyo tlen huehueyac, huan quitlalili itzinquechilpica huan nojquiya quitlalili ipantzajca. Huan ipan nopa pantzajcayotl quitlali nopa seyoc ipantzajca tlen ax quipixqui ima. ");
INSERT INTO nheBl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Teipa Moisés quitlalili nopa yolixpantzajcayotl tlen quipixqui ibolsa huan nopona quitlalili nopa Urim huan nopa Tumim, nopa dados tlatzejtzeloltic tlen Toteco. ");
INSERT INTO nheBl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Huan teipa ipan itzonteco Aarón quitlalili icuatzajca tlen eli queja se tzonyahuali. Huan ipan icuaixco quitlalili nopa piltepos patlactzi tlen tlatzejtzeloltic huan tlen tlachijchihuali ica oro tlen quiixnextía para yajaya nopa hueyi totajtzi. Queja nopa TOTECO quinahuati ma quitlalili Aarón. ");
INSERT INTO nheBl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Teipa Moisés quicuic nopa aceite tlen quitequihuíaj para ica tlaiyocatlalíaj para elis iaxca Toteco, huan quipolo nochi tlamantli tlen onca ipan nopa yoyon tiopamitl huan queja nopa quiniyocatlali para elise senquistoc para TOTECO iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Huan quiijtzelo nopa aceite ipan nopa tlaixpamitl chicompa hueltas para quiiyocatlalis para elis iaxca Toteco nopa tlaixpamitl huan nochi tlamantzitzi tlen motequihuíaj ipan nopa yoyon tiopamitl. Nojquiya quiijtzelo ipan nopa hueyi paila huan tlen ipan moquetzaj huan queja nopa quintlatzejtzelolchijqui. ");
INSERT INTO nheBl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Huan teipa nojquiya quitequili quentzi aceite ipan Aarón itzonteco para quiiyocatlalis para itequi. ");
INSERT INTO nheBl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Huan teipa Moisés sampa quinnotzqui ma monechcahuica Aarón itelpocahua huan quinquenti ininyoyo tlen huehueyac, huan quintlalili inintzinquechilpijca, huan nojquiya quintlalili inintzontzajcayohua. Huan nochi quichijqui queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Teipa quicuic nopa becerro para nopa tlacajcahualistli ipampa tlajtlacoli, huan Aarón huan itelpocahua quitlalijque ininma ipan itzonteco nopa tlapiyali. ");
INSERT INTO nheBl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","16","Huan Moisés quimicti nopa tlapiyali huan ica imacpil quicuic se quentzi estli huan quiajalo nopa nahui icuacua nopa tlaixpamitl tlen mocahuayaya campa inacastla. Huan nojquiya quiatzejtzelhui nopa tlaixpamitl para quitlatzejtzelolchihuas. Huan nopa estli tlen mocajqui quitoyajqui tlalchi itzintla nopa tlaixpamitl. Teipa quicuic nopa tlachiyajcayotl tlen mopantía ipan icuitlaxcol ihuaya nopa parte tlen más hueyi tlen ieltapach, huan iome sosone ihuaya inintlachiyajcayo, huan quitencajqui iixpa TOTECO ipan tlitl ipan nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Huan nopa becerro inacayo huan icuetlaxo, huan icuitlaxcol ica icuitl, quitlatito ipan se lugar tlen mocahua huejca tlen campa mochijtoyaj. Quichijqui senquistoc queja quinahuatijtoya TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Teipa quihualicac nopa oquich borrego para nopa tlacajcahualistli tlatlatili iixtla TOTECO. Huan Aarón huan itelpocahua quitlalijque ininma ipan itzonteco nopa tlapiyali, ");
INSERT INTO nheBl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","huan Moisés quiquechtzontejqui huan quiatzejtzelhui yahualtic nopa tlaixpamitl ica ieso. ");
INSERT INTO nheBl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Teipa quihuejhuelo nopa oquich borrego. Huan nopa nacatl tlatectli ihuaya itzonteco huan ichiyajca quitlati ipan nopa tlaixpamitl para quimacas TOTECO ipan poctli. ");
INSERT INTO nheBl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Pero achtohui quipajpajqui icuitlaxcol huan imetzcuayo ica atl, huan teipa quitlati ipan nopa tlaixpamitl. Huan queja nopa, nochi nopa oquich borrego nejmajtic tlatlac iixpa TOTECO. Huan nopa tlapiyali elqui se tlacajcahualistli tlatlatili tlen mijmiyoti ajhuiyac para ya. Huan Moisés quimacac TOTECO nopa tlacajcahualistli ipan tlitl senquistoc queja quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Teipa Moisés quiixnexti nopa seyoc oquich borrego tlen elqui se tlacajcahualistli para quiniyocatlalis Aarón huan itelpocahua, huan inijuanti quitlalijque ininma ipan itzonteco. ");
INSERT INTO nheBl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Huan teipa Moisés quiquechtzontejqui nopa tlapiyali, huan quicuic se quentzi ieso huan quitlali Aarón ipan inacas nejmatl. Huan nojquiya quitlalili ipan ihueyi xocpil tlen inejmatl huan ipan ihueyi macpil tlen inejmatl. ");
INSERT INTO nheBl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Teipa Moisés quinilhui itelpocahua Aarón ma monechcahuise huan nojquiya san se quitlali ipan ininnacas nejmatl huan ininxocpilhua tlen hueyi tlen ininnejmatl huan ipan ininmacpil tlen hueyi tlen nojquiya ininnejmatl. Huan nopa estli tlen mocajqui quiatzejtzelhui itzintla huan yahualtic nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Teipa quicuic nopa tlachiyajcayotl huan icuitlapil tlen quipixqui ichiyajca. Nojquiya quicuic nopa tlachiyajcayotl tlen mopantía ipan icuitlaxcol, ieltapach, huan nopa ome ieyo huan imetzcuayo tlen inejmatl. ");
INSERT INTO nheBl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Huan tlen nopa chiquihuitl tlen quipixqui pantzi tlen ax quipixqui tlasonejcayotl tlen eltoc iixtla TOTECO, Moisés quiquixti se pantzi, huan se pantzi tlen tlamaneloli ica aceite, huan se pantzi tlen sepantic huan cacatztic. Huan nochi ya ni quitlali ininpani nopa partes tlen quisqui ipan nopa oquich borrego. ");
INSERT INTO nheBl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Huan nochi ni tlamantli quitlali imaco Aarón huan ipan ininma itelpocahua para inijuanti ma quihuisoca iixtla TOTECO para quimacase. ");
INSERT INTO nheBl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Huan teipa sampa quicuic nopa tlamantli tlen ininma, huan quitlati ipan nopa tlaixpamitl ihuaya nopa tlacajcahualistli tlatlatili para quimacas TOTECO. Huan ya ni, quena, elqui se tlacajcahualistli para quiniyocatlalis Aarón huan itelpocahua para inintequi tlen totajtzitzi. Huan mijmiyoti ajhuiyac para TOTECO. Ya ni elqui tlacajcahualistli tlen quimacac TOTECO ipan tlitl. ");
INSERT INTO nheBl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Huan teipa Moisés quicuic nopa oquich borrego iyolix huan quimacac TOTECO queja se tlacajcahualistli tlahuisoli iixtla, pampa quihuiso iixtla nopona campa nopa tlaixpamitl. Huan teipa iyolix nopa tlapiyali mocajqui iaxca Moisés pampa queja nopa tlanahuati TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Teipa quicuic quentzi nopa aceite para teiyocatlalise huan quentzi nopa estli tlen eltoya ipan tlaixpamitl huan ica quiatzejtzelhui iyoyo Aarón. Huan nojquiya quiatzejtzelhui ininyoyo itelpocahua Aarón. Huan queja nopa quichijqui ma elica tlaiyocatlalilme Aarón huan itelpocahua para quitequipanose TOTECO, huan nojquiya ininyoyo quiiyocatlalili para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Huan Moisés nojquiya quinilhui Aarón huan itelpocahua: “Xiquicxitica nopa nacatl ipan atl nechca ipuerta ni yoyon tiopamitl. Nopona calixpamitl, xijcuaca ihuaya nopa pantzi tlen eltoc ipan nopa chiquihuitl tlen quipiya nopa tlacajcahualistli para inmechiyocatlalise para TOTECO. Quena, xijchihuaca queja niquijtojtoc pampa nimechnahuatía para monequi imojuanti xijcuaca. ");
INSERT INTO nheBl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Huan nopa nacatl huan pantzi tlen noja mocahuas, monequi inquitlatise. ");
INSERT INTO nheBl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Huan ax hueli inquistehuase tlen ipuerta nopa yoyon tiopamitl para chicome tonali, pampa monequi chicome tonali para tlamis nochi tlen monequi para nimechiyocatlalis para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Huan nochi ni tlamantli tlen tijchijtoque, tijchijque pampa TOTECO queja nopa quinequiyaya ma tijchihuaca para quiixtzacuas imotlajtlacolhua iixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Huan sampa nimechnahuatía, monequi para chicome tonali, tonaya huan tlayohua ximocahuase nechca ipuerta nopa yoyon tiopamitl. Quena, queja nopa TOTECO inmechnahuatijtoc para ax inmiquise.” ");
INSERT INTO nheBl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Huan Aarón huan itelpocahua quichijque nochi tlen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Panoc nopa chicome tonali para moiyocatlalise para TOTECO huan ipan ne chicueyi tonal Moisés quinnotzqui Aarón huan itelpocahua huan nochi nopa huehue tlacame tlen tlayacanque ica israelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Huan quiilhui Aarón: “Xijcui se becerro para tijmacas TOTECO queja se tlacajcahualistli ipampa tlajtlacoli para ta. Huan nojquiya xijcui se oquich borrego para elis se tlacajcahualistli tlatlatili. Huan ni tlapiyalime monequi elise tlapajpacme. Ax quipiyase ipan inintlacayo niyon se tlamantli tlen ax cuali. ");
INSERT INTO nheBl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Huan xiquinilhuica nopa israelitame ma quicuica se oquich chivo para ma quimacaca queja se tlacajcahualistli ipampa tlajtlacoli. Huan nojquiya ma quicuica se becerro huan se pilborregojtzi tlen sanoc quiaxitijtoque sesen xihuitl para quinmacase queja se tlacajcahualistli tlatlatili. Ni tlapiyalime monequi elise tlapajpacme. Ax quipiyase niyon se tlamantli tlen ax cuali ipan inintlacayo. ");
INSERT INTO nheBl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Huan nojquiya xiquinilhui monequi quicuise se toro tlen tlaxahua huan se oquich borrego para ma quimacaca queja se tlacajcahualistli para ma onca tlayoltlalili ihuaya TOTECO. Nojquiya monequi quihualicase se tlacajcahualistli tlen harina tlen quicuechtilijtoque huan quichijtoque se harina huan quimanelojtoque ica aceite. Quena, nochi ya ni monequi xijchihuaca pampa ama TOTECO monextis ica imojuanti.” ");
INSERT INTO nheBl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Huajca nochi israelitame quihuicaque ni tlamantli tlen quinnahuatijtoya Moisés campa nopa yoyon tiopamitl icalixpa. Huan nochi nopa israelitame monechcahuijque huan ijcatoyaj nopona iixpa TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Huajca Moisés quinilhui: “Quema ya inquichijtose nochi tlen tlanahuatía TOTECO, monextis ihueyitilis ica imojuanti.” ");
INSERT INTO nheBl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Teipa Moisés quiilhui Aarón: “Ximonechcahui campa nopa tlaixpamitl huan xijmaca TOTECO nopa tlacajcahualistli ipampa tlajtlacoli tlen elis para ta motlajtlacolhua. Huan xijtencahua nopa tlacajcahualistli tlatlatili tlen quiixtzacuas motlajtlacolhua iixtla. Teipa xijmaca TOTECO nopa tlacajcahualistli para quiixtzacuas inintlajtlacolhua nochi israelitame iixtla queja yajaya tlanahuatijtoc.” ");
INSERT INTO nheBl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Huajca Aarón monechcahui campa nopa tlaixpamitl huan quimicti nopa becerro para se tlacajcahualistli ipampa tlajtlacoli ipampa ya itlajtlacol. ");
INSERT INTO nheBl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Huan itelpocahua quihualiquilijque nopa estli, huan Aarón quicuic se quentzi nopa estli ica imacpil huan quiajalo nopa nahui icuacua nopa tlaixpamitl. Huan nopa estli tlen noja mocajqui quitoyajqui tlalchi itzintla nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Huan teipa quitlati nochi nopa tlapiyali ichiyajcayo, ieyo huan nopa parte tlen más hueyi tlen ieltapach. Nochi quimacac TOTECO ipan poctli queja yajaya quinahuatijtoya ma quichihuaca. ");
INSERT INTO nheBl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Pero inacayo nopa tlapiyali huan icuetlaxo quitlati ipan se lugar huejca tlen campa timochijtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Huan teipa Aarón quimicti nopa tlapiyali tlen elqui para tlacajcahualistli tlatlatili, huan itelpocahua quihuiquilijque nopa estli. Huan quiatzejtzelhui ica nopa estli yahualtic ipan nochi ielchiqui nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Huan quihuejhuelojque nopa tlapiyali huan quihuiquilijque Aarón itzonteco huan sesen tlatectli. ");
INSERT INTO nheBl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Teipa quipajpajqui icuitlaxcol huan imetzcuayo huan nojquiya quitencajqui ipan tlitl ipan nopa tlaixpamitl ihuaya nopa tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Teipa quihualicac nopa oquich chivo tlen quihualicatoyaj nopa israelitame. Huan quimicti huan quitencajqui queja se tlacajcahualistli ipampa tlajtlacoli para nopa israelitame inintlajtlacolhua. Nochi quichijque queja achtohui quichijqui ica nopa seyoc tlacajcahualistli ipampa tlajtlacoli ipampa ya. ");
INSERT INTO nheBl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Huan teipa quihualicac nopa tlacajcahualistli tlatlatili. Huan quitencajqui iixtla TOTECO senquistoc queja quiijto itlanahuatil. ");
INSERT INTO nheBl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Teipa quihualicac nopa tlacajcahualistli tlen harina. Huan quicuic se quentzi nopa harina tlen quicuechtilijtoyaj tlen nopa tlacajcahualistli tlen quihualicatoyaj, huan quitlati ipan nopa tlaixpamitl ihuaya nopa tlacajcahualistli tlatlatili tlen quitencajque ica ijnaloc. ");
INSERT INTO nheBl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Teipa quiquechtzontejqui nopa toro tlen quimati tlapoxahua huan nopa oquich borrego tlen quimacayayaj nopa israelitame queja se tlacajcahualistli para ma onca tlayoltlalili ica TOTECO. Huan itelpocahua Aarón quihuiquilijque nopa estli, huan yajaya quiatzejtzelo yahualtic huan itzintla nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Teipa quicuic nopa toro ichiyajca huan ichiyajca nopa oquich borrego. Huan quicuic nopa tlachiyajcayotl tlen mopantía ipan inincuitlapil huan tlen mopantía ipan inincuetlaxcol. Huan quicuic ininsosone huan nopa parte tlen inieltapach tlen quipixqui ininchiyajca. ");
INSERT INTO nheBl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Huan nochi nopa partes itelpocahua quitlalijque ipan nopa tlapiyalime ininyolix para quimacase Aarón. Huan nochi nopa tlachiyajcayotl quitlati ipan nopa tlaixpamitl para quimacas TOTECO ipan poctli. ");
INSERT INTO nheBl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Pero ininyolix huan ininmetzcuayo tlen inejmatl, Aarón quitencajqui iixtla TOTECO queja se tlacajcahualistli tlahuisoli. Huan nochi Aarón quichijqui queja Moisés quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Huan Aarón quitlejcolti ima para campa itztoyaj nopa israelitame huan quintiochijqui. Huan quema ya quitencajtoya nopa tlacajcahualistli ipampa tlajtlacoli, huan nopa tlacajcahualistli tlatlatili, huan nopa tlacajcahualistli para ma onca tlayoltlalili ica TOTECO, Aarón temoc tlen campa nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Huan Moisés huan Aarón calajque calijtic ipan nopa yoyon tiopamitl. Huan teipa quisque huan quintiochijque nopa israelitame, huan TOTECO ihueyitilis monexti iniixtla nochi nopa israelitame tlen mosentilijtoyaj nopona. ");
INSERT INTO nheBl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Huan TOTECO quititlanqui tlitl tlen iixtla huan nimantzi quitlamitlati nochi nopa tlacajcahualistli huan nopa tlachiyajcayotl tlen eltoya ipan nopa tlaixpamitl. Huan quema nopa israelitame quiitaque ya nopa, quitzajtzilijque TOTECO ica paquilistli huan motlancuaquetzque huan mopachojque ica ininxayac hasta tlalchi. ");
INSERT INTO nheBl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Se tonal ome itelpocahua Aarón, inijuanti tlen inintoca eliyaya Nadab huan Abiú, quicuique sese popochcomitl huan ipan quitlalijque tlitl tlen ax tlatzejtzeloltic ihuaya copali huan quitlatijque iixtla TOTECO. Pero tlen quichijque ax elqui queja TOTECO quinnahuatijtoya ma quichihuaca. ");
INSERT INTO nheBl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Huan TOTECO quititlanqui se tlitl huan quintlamitlati huan mijque nopona iixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Huan teipa Moisés quiilhui Aarón: ―TOTECO quinequiyaya techilhuis para quej ni panos quema quiijto: ‘Niquinnextilis para nitlatzejtzeloltic, nochi tlen monechcahuíaj campa na. Huan nochi israelitame nechhueyitlalise.’ Huan Aarón ax molini. ");
INSERT INTO nheBl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Huan Moisés quinotzqui Misael huan Elzafán tlen eliyayaj itelpocahua Uziel, itío Aarón, huan quinilhui: ―Xihualaca huan xiquinhuicaca imoteixmatcahua ininmijcatzitzi. Xiquinquixtica tlen nopa calixpamitl tlen iixtla ni yoyon tiopamitl huan xiquinhuicaca huejca tlen campa timochijtoque. ");
INSERT INTO nheBl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Huan monechcahuijque huan quinhuicaque ininteixmatcahua ininmijcatzitzi, huan noja moquentijtoyaj ininyoyo tlen huehueyac tlen totajtzitzi. Huan quinhuicaque huejca tlen campa timochijtoque queja Moisés quinnahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Teipa Moisés quincamahui Aarón huan nopa ome itelpocahua tlen inintoca eliyaya Eleazar huan Itamar, huan quinilhui: ―Amo xichocaca niyon amo ximocuesoca. Amo xijcahuaca imotzoncal ma nesis fiero, niyon amo xijtzayanaca imoyoyo. Pampa intla inmocuesose, TOTECO nojquiya inmechtzontlamiltis huan yajaya nelía cualanis ihuaya nochi ni israelitame. Pero moicnihua, nochi nopa sequinoc israelitame, quena, hueli quinchoquilise Nadab huan Abiú huan hueli mocuesose ipampa nopa tlitl tlen TOTECO quititlanqui. ");
INSERT INTO nheBl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Pero ax hueli inquisase tlen nopona campa nopa yoyon tiopamitl. Intla inquisase, inmiquise, pampa intlaiyocatlalilme para TOTECO ipampa nopa aceite tlen nimechajalti. Huan Aarón huan nopa ome itelpocahua quichijque nochi queja quinnahuati Moisés. ");
INSERT INTO nheBl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Teipa TOTECO quicamahui Aarón huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ta huan motelpocahua ax hueli inquiise vino o tlen hueli tlamantli tlailistli tlen cococ quema incalaquise ipan nopa yoyon tiopamitl. Intla inquiise, inmiquise. Ni tlanahuatili monequi inquitoquilise imojuanti huan nochi imoteipa ixhuihua tlen tlacajtiyase para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Monequi inquimachilise catlía tlamantzitzi tlatzejtzeloltic para na huan catlía amo, huan catlía tlapajpactic noixtla huan catlía ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Huan monequi inquinmachtise nopa israelitame nochi notlanahuatilhua tlen na, niimoTECO, nimechmacatoc ica Moisés.” ");
INSERT INTO nheBl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Teipa Moisés quincamahui Aarón huan nopa ome itelpocahua tlen noja itztoyaj tlen inintoca eliyaya Eleazar huan Itamar. Quinilhui: ―Xijcuica nopa harina tlen noja mocahua tlen nopa tlacajcahualistli tlen inquimacaque TOTECO ipan tlitl. Xijpiyaca cuidado para ax quipiyas tlasonejcayotl huan xijcuaca nechca ielchiqui nopa tlaixpamitl, pampa ya ni elis se tlacajcahualistli tlen tlahuel tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Huan monequi xijcuica huan xijcuaca nopona yoyon tiopan calijtic campa tlatzejtzeloltic. Huan nopa tlen mocahua tlen nopa tlacajcahualistli tlen harina elis moaxca para motlacualis, Aarón, huan para inintlacualis motelpocahua. Quena, ni parte tlen nopa tlacajcahualistli tlen inquitlatise iixtla TOTECO elis imoaxca, pampa queja nopa tlanahuatijtoc TOTECO ma nimechilhui. ");
INSERT INTO nheBl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Pero iyolix nopa tlapiyali tlen inquihuisohuaj iixtla TOTECO huan imetzcuayo tlen nojquiya inmechtocaros, hueli inquicuase ipan tlen hueli lugar tlen tlapajpactic. Quena, imojuanti huan imooquichpilhua huan imosihuapilhua hueli inquicuase nopa iyolix huan imetzcuayo pampa imoaxca tlen nochi tlacajcahualistli para ma onca tlayoltlalili ica TOTECO tlen israelitame temacaj. ");
INSERT INTO nheBl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Nopa israelitame monequi quihualicase imetzcuayo nopa tlapiyali tlen inquitlejcoltise huan iyolix tlen inquihuisose iixtla TOTECO para intemacase quema nojquiya inquitlatise nopa tlachiyajcayotl. Huan teipa nopa partes elis imoaxca. Quena, ni ome tlamantli mocahuas para ta huan para moconehua para nochipa pampa queja nopa tlanahuatijtoc TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Huan teipa Moisés tlajtlanqui canque mocahua nopa oquich chivo tlen quitencajque queja se tlacajcahualistli ipampa tlajtlacoli huan quipanti para ya quitlatijtoyaj. Huan tlahuel cualanqui ihuaya Eleazar huan Itamar, nopa ome itelpocahua Aarón tlen noja itztoyaj. Huan quinilhui: ");
INSERT INTO nheBl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","―¿Para tlen ax inquicuajque nopa tlacajcahualistli ipampa tlajtlacoli campa tlatzejtzeloltic tiopan calijtic? Pampa nelía eliyaya tlatzejtzeloltic huan TOTECO inmechmacac para inquiquixtise nopa tlajtlacoli tlen israelitame quihuicaj iixtla huan para inquiixtzacuase inintlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Monectoya inquicuajtosquíaj yoyon tiopan calijtic campa tlatzejtzeloltic queja na nimechnahuatijtoya, pampa ax ya nopa tlacajcahualistli tlen inquihuicaj ieso tiopan calijtic campa Más Tlatzejtzeloltic tlen ax hueli inquicuase. ");
INSERT INTO nheBl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Pero Aarón quiilhui Moisés: ―Inijuanti quitencajque inintlacajcahualis para tlajtlacoli huan inintlacajcahualis tlatlatili iixtla TOTECO. Pero ica ininmiquilis ne sequinoc notelpocahua, na nimoilhui intla tijcuasquíaj ama nopa tlacajcahualistli ipampa tlajtlacoli, huelis ax quipactijtosquía TOTECO. Yeca ax nijcuajqui. ");
INSERT INTO nheBl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Huan quema Moisés quicajqui ya nopa, ayoc cualanqui. ");
INSERT INTO nheBl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Huajca TOTECO sampa quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nheBl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Xiquinilhuica nopa israelitame para san hueli quicuase ni tlapiyalime tlen ama nimechilhuis. ");
INSERT INTO nheBl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Hueli quicuase tlen quipiyaj iniisti maxaltic huan quicuajcuaj inintlacualis ome huelta. ");
INSERT INTO nheBl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Pero ax hueli inquincuase nopa camello, ");
INSERT INTO nheBl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","nopa cuatochi, ");
INSERT INTO nheBl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","huan nopa pesojtli, pampa yonque ni tlapiyalime quicuajcuaj inintlacualis ome huelta, ax quipiyaj iniisti maxaltic. ");
INSERT INTO nheBl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","“Nojquiya ax hueli inquicuase nopa pitzo, pampa yonque quipiya iisti maxaltic, ax quicuajcua ome huelta itlacualis, huan huajca niquita para ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","“Ax hueli inquicuase ininnacayo ni tlapiyalime niyon ax hueli inquiitzquise se itlacayo quema mictoc pampa ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Huan tlen nochi michime huan tlapiyalime tlen itztoque ipan atl, san hueli inquincuase tlen quipiyaj inieltlapal huan ininpetlayo. Quena, yonque inquinitzquise ipan hueyi atl o ipan se atlajtli san ni michime inquicuase. ");
INSERT INTO nheBl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ax hueli inquincuase niyon se tlamantli tlen itztoc ipan hueyi atl o ipan atemitl intla ax quipiya ieltlapal huan ininpetlayo queja quipiyaj michime. ");
INSERT INTO nheBl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nochi ni tlamantli inquiijiyase huan ax hueli inquinitzquise inintlacayo tlen mictoque. ");
INSERT INTO nheBl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Huan sampa nimechilhuía ya ni: Amo xijcuaca niyon se tlamantli tlen itztoc ipan atl intla ax quipiya ieltlapal huan ipetlayo queja quipiya se michi. ");
INSERT INTO nheBl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Huan nojquiya itztoque totome tlen ax hueli inquincuase. Amo xijcuaca niyon se hueyi cuajtli, niyon se huactzi, niyon tzopilotl nechca atl, ");
INSERT INTO nheBl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","niyon se tlamantli tzopilotl, ");
INSERT INTO nheBl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","o niyon se tlamantli cacalotl. ");
INSERT INTO nheBl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Niyon amo xijcuaca nopa huejcapantic tototl avestruz, niyon nopa cuajtli tlen tlayohua, niyon nopa atototl tlen chipahuac, o niyon se tlamantli cuajtli. ");
INSERT INTO nheBl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Amo xijcuaca nopa tololojtli, niyon nopa cuamojmojtli tlen hueyi, niyon nopa cuamojmojtli tlen ijcatoc iijhuiyo ipan itzonteco, ");
INSERT INTO nheBl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","niyon nopa cuamojmojtli chipahuac, niyon nopa tototl yayahuic tlen quincua michime, niyon nopa pelícano, niyon nopa tzopilotl tlen quincua tlapiyalime tlen mictoque. ");
INSERT INTO nheBl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Niyon amo xijcuaca nopa astatl, niyon nopa cigüeña, niyon totome tlen quipiyaj huejhueyi ininmetzhua, niyon tzotzome. Nochi ni tlapiyalime ax hueli inquincuase. ");
INSERT INTO nheBl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Nojquiya monequi xiquinijiyaca nochi tlamantli sayolime tlen patlanij huan quipiyaj nahui ininmetz. Amo xiquincuaca. ");
INSERT INTO nheBl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Pero itztoque sequin tlamantli tlen quipiyaj inieltlapal huan nahui ininmetzhua tlen hueli inquicuase. Intla ipan ininmetzhua quipiyaj inintlancuaco tlen quinpalehuíaj para huitonij, huajca quena, hueli inquincuase. ");
INSERT INTO nheBl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Hueli inquincuase nochi tlamantli pilchapoltzitzi, nochi chapolime tlen huejhueyi, huan nochi chapolime tlen quicuaj xihuitl huan quipiyaj inieltlapal. ");
INSERT INTO nheBl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Pero nochi nopa sequinoc sayolime huan chapolime tlen quipiyaj nahui iniicxi, ax hueli inquincuase. ");
INSERT INTO nheBl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Ni tlamantli quichihua para se tlacatl elis ax tlapajpactic: “Intla se tlacatl quiitzquis itlacayo se tlen ni totome o sayolime tlen mictoque, mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","“Huan intla se tlacatl quiitzquis itlacayo se tlen ni tlamantli tlapiyalime quema ya mictoc, monequi nimantzi quichicuenis iyoyo huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Nojquiya inmochihuase ax intlapajpactique quema inquiitzquise itlacayo se tlapiyali tlen ax senquistoc maxaltic iisti o ax quicuajcua ome huelta itlacualis. ");
INSERT INTO nheBl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","“Nojquiya ax huelis inquincuase tlapiyalime queja chichime tlen ax quipiyaj senquistoc iniisti. Huan intla se tlacatl quiitzquis itlacayo se tlen ni tlapiyali tlen mictoc mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Quena, quema se tlacatl quiitzquis itlacayo se tlen ni tlapiyali tlen mictoc monequi nimantzi quichicuenis iyoyo, pero noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Huan tlen nopa tlapiyalime tlen motlalohuaj tlalchi, ya ni tlen ax cuali para inquincuase: sehueme, quimichime, tamasolime, tusame, ");
INSERT INTO nheBl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","cocodrilome, axilime, topitzitzi huan tzonpetlachiquime. ");
INSERT INTO nheBl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","“Intla se tlacatl quiitzquis itlacayo se tlen ni tlapiyalime tlen mictoc, mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“Nojquiya mocahuas ax tlapajpactic nochi tlamantli tlen ipan huetzis nopa tlapiyali itlacayo. Quena, intla nopa tlapiyali tlen mictoc huetzis ipan se tlamantli cuahuitl, o se yoyomitl, o se cuetlaxtli o se coxtali, huajca nopa tlamantli mocahuas ax tlapajpactic. Monequis inquitlalise ipan atl huan mocahuas ax tlapajpactic hasta tlayohua, pero teipa elis tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","“Huan intla nopa tlapiyali huetzis ipan se tlamantli tlen tlachijchihuali ica soquitl, huajca nochi tlamantzitzi tlen quipixqui iijtico elise ax tlapajpactic, huan monequi inquitlapanase nopa comitl. ");
INSERT INTO nheBl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Huan intla nopa atl tlen ica quitlapajpacchihuaj tlen ax tlapajpactic huetzis ipan se tlamantli tlacualistli o se tlamantli tlailistli, nopa tlamantli nojquiya mochihuas ax tlapajpactic pampa quiajsic nopa atl. ");
INSERT INTO nheBl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","“Intla itlacayo se tlen ni tlapiyali tlen mictoc huetzis ipan tlen hueli tlamantli horno tlen tlachijchihuali ica soquitl, huajca nopa horno mocahuas ax tlapajpactic huan monequi inquixolehuase. ");
INSERT INTO nheBl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“Huan intla nopa tlapiyali huetzis ipan se ameli tlen quipiya atl, huajca nopa atl mocahuas tlapajpactic, pero nopa tlacatl tlen quiquixtis nopa tlapiyali itlacayo, yajaya, quena, mocahuas ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","“Huan intla itlacayo nopa tlapiyali tlen mictoc huetzis ipan xinachtli tlen quicajtoyaj para quitocase ipan mila, huajca nopa xinachtli noja mochihuas tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Pero intla itlacayo nopa tlapiyali tlen mictoc huetzis ipan xinachtli tlen xolontoc, huajca mocahuas ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Huan intla inquipiyaj se tlapiyali tlen cuali para inquicuase pero nopa tlapiyali miquis ica cocolistli, huajca amo xiquitzqui itlacayo. Pampa intla se tlacatl quiitzquis itlacayo, nopa tlacatl mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Huan intla se tlacatl quicuas inacayo o quihuicas itlacayo nopa tlapiyali, monequi nimantzi quichicuenis iyoyo, pero noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Monequi xiquinijiyaca nochi tlapiyalime tlen mohuahuatatzaj tlalchi huan ax hueli inquincuase. ");
INSERT INTO nheBl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","“Ax hueli inquincuase nochi tlamantli tlen ica ininyolix mohuahuatatzaj tlalchi, niyon nopa cohuame tlen nejnemij ica nahui iniicxi. Nojquiya ax hueli inquincuase nopa tlapiyalime tlen mohuahuatatzaj tlalchi huan quipiyaj miyac iniicxihua, pampa nelía ax tlapajpactique noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Amo xijtoxomaca niyon se tlen ni tlapiyalime pampa inmechchihuas ax intlapajpactique. ");
INSERT INTO nheBl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Na niimoTECO Dios. Nijnequi ximomocuitlahuica cuali huan xielica intlatzejtzeloltique pampa na nitlatzejtzeloltic. Huajca amo xiquitzquica niyon se ni tlapiyalime tlen mohuahuatatzaj tlalchi pampa inmechchihuas ax intlapajpactique noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Na niimoTECO tlen nimechquixti ipan tlali Egipto para nielis niimoTeco Dios. Huajca ama, monequi inelise intlatzejtzeloltique pampa na nitlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Huajca nica nimechilhuijtoc nopa miyac tlanahuatili tlen monequi inquitoquilise ica nochi totome, tlapiyalime, tlamantli tlen itztoque ipan atl huan tlamantli tlen mohuahuatatzaj tlalchi. ");
INSERT INTO nheBl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ni tlanahuatili inmechpalehuise para inquimatise tlaque eli se tlapiyali tlen tlapajpactic huan tlaque eli se tlapiyali tlen ax tlapajpactic. Huan nojquiya inmechpalehuis para inquimatise tlaque tlapiyali hueli inquicuase huan tlaque tlapiyali ax hueli inquicuase.” ");
INSERT INTO nheBl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Xiquinilhui nopa israelitame ni miyac tlanahuatili. Quema se sihuatl tlanemiltis huan quitlacatiltis se oquichpil, huajca nopa sihuatl mocahuas ax tlapajpactic para chicome tonali. Monequi quichihuas san se queja quichihua quema esotemo. ");
INSERT INTO nheBl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Huan ipan nopa chicueyi tonal, quiyecapantequilise se quentzi icuetlaxo ipan ipiltlacayo nopa piloquichpiltzi. ");
INSERT INTO nheBl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Teipa nopa piloquichpiltzi inana ax huelis quiitzquis niyon se tlamantli tlen tlatzejtzeloltic para seyoc 33 tonali pampa noja quipiya esotemolistli. Niyon ax hueli calaquis tiopan calijtic hasta tlamis nopa tonali para motlapajpacchijtos. ");
INSERT INTO nheBl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Pero intla nopa sihuatl quitlacatiltis se sihuapil, huajca mocahuas ax tlapajpactic para ome samanos. Huan monequi quitlepanitas nopa tlanahuatili para quema esotemo. Huan teipa quichiyas seyoc 66 tonali para motlapajpacchihuas. ");
INSERT INTO nheBl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Huan quema ya quitlamiltijtos nopa tonali para motlapajpacchihuas, huajca yonque tlacatqui oquichpil o sihuapil, inana monequi quihuicas campa nopa totajtzi ipan ipuerta nopa yoyon tiopamitl se pilborregojtzi tlen sanoc quipiya se xihuitl para quimacas queja se tlacajcahualistli tlatlatili. Nojquiya monequi quihuicas se paloma o se pichontzi para nechmacas queja se tlacajcahualistli ipampa tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","“Huan nopa totajtzi quintencahuas noixtla na, niimoTECO, huan nechixtzacuilis itlajtlacol nopa sihuatl noixtla. Huan queja nopa, nopa sihuatl motlapajpacchihuas tlen nopa esotemolistli. Quena, ya ni eli nopa tlanahuatili tlen monequi quitoquilis quema quitlacatiltijtos se conetl yonque oquichpil o sihuapil. ");
INSERT INTO nheBl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Pero intla nopa sihuatl eli tlahuel teicneltzi huan ax quipiya tomi para nechmacas se pilborregojtzi, huajca hueli quinhuicas ome pichontzitzi o ome palomas. Se tlen nopa ome nechmacas queja se tlacajcahualistli tlatlatili, huan nopa seyoc nechmacas queja se tlacajcahualistli ipampa tlajtlacoli. Huan queja nopa, nopa totajtzi nechixtzacuilis itlajtlacol nopa sihuatl, huan ya mocahuas tlapajpactic noixtla.” ");
INSERT INTO nheBl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","TOTECO quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nheBl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Quema inquiitase pehua temi icuetlaxo se tlacatl, o nesi para pehuas cocome, o nesi para pehuas mochihuas chipahuac icuetlaxo, huelis quinequi pehuas nopa tlacayo palanca cocolistli tlen tlamahua. Huajca monequi inquihuicase nopa tlacatl iixtla nopa totajtzi Aarón o iixtla se tlen itelpocahua. ");
INSERT INTO nheBl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Huan nopa totajtzi quitlachilis ica miyac cuidado campa monextijtoc nopa cocolistli. Huan intla campa quipiya cocolistli, itzoyo pejtoc mocuepa chipahuac huan intla nopa cocotl nesi para pejtoc tlatzintla icuetlaxo, huajca xijmachilica cuali para quipiya nopa tlacayo palanca cocolistli. Huan huajca nopa totajtzi monequi teyolmelahuas para ax tlapajpactic nopa tlacatl. ");
INSERT INTO nheBl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“Huan intla iyoca ipan icuetlaxo nopa tlacatl quinpiya manchas tlen chijchipahuac pero ax palantoc hasta más huejcatla, huan itzoyo ax mocueptoc chipahuac, monequi nopa totajtzi quitzacuas nopa tlacatl iselti para chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Huan quema quiaxitis chicome tonali, nopa totajtzi sampa quitlachilis. Huan intla nesis para nopa cocotl ax más mohueyilijtoc ipan icuetlaxo, huajca quitzacuas para seyoc chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Huan quema sampa ajsis nopa chicompa tonal, monequi sampa quitlachilis ica miyac cuidado, huan intla quiitas para nopa cocotl ax más mohueyilía ipan icuetlaxo huan pejtoc pachihui, huajca nopa totajtzi teyolmelahuas para nopa tlacatl eltoc tlapajpactic noixtla. Pampa tlen quipixtoya eliyaya san tlen hueli cocotl. Huan nopa tlacatl monequi quichicuenis iyoyo, huan queja nopa sampa elis tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pero intla nopa cocotl mohueyilis teipa quema nopa totajtzi quiijto para tlapajpactic, huajca monequi sampa hualas iixtla nopa totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Huan intla nopa totajtzi quiijtos para nopa cocotl mohueyilijtoc, huajca teyolmelahuas para nopa tlacatl ax tlapajpactic pampa quipiya tlacayo palanca cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Quema se tlacatl quinpiyas cocome ipan itlacayo, monequi quihuicase iixtla totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Huan nopa totajtzi quitlachilis ica miyac cuidado, huan intla quiitas para campa temitoc icuetlaxo pehua mocuepas chipahuac, huan itzoyo mocueptoc chipahuac, huan intla tlanemijya nesi inacayo tlapojtoc campa temitoc, ");
INSERT INTO nheBl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","huajca ya nopa eli nopa tlacayo palanca cocolistli tlen huejcajquiya quiajsitoc ipan icuetlaxo. Huan huajca nopa totajtzi monequi teyolmelahuas para nopa tlacatl ax tlapajpactic. Ax monequi quitzacuas iselti, para más quitlachilise pampa quimati melahuac quipiya nopa cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Pero intla nopa totajtzi quiitas para nopa mancha tlen nopa tlacatl quipiya ya mohueyilijtoc huan ya ajsitoc campa hueli tlen iicxihua huan hasta ipan itzonteco, ");
INSERT INTO nheBl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","huajca quiijtos para nopa tlacatl tlapajpactic, pampa nochi ya mochijtoc chipahuac huan ya panotoc nopa palanca cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Pero intla ipan icuetlaxo quinpiya cocome tlapojtoc tlen nesi inelnacayo, huajca ax tlapajpactic, ");
INSERT INTO nheBl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","pampa tlapojtoc icocohua huan nesi inelnacayo huan ya ni eltoc tlacayo palanca cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“Pero intla nopa tlacatl tlen quipixqui se cocotl tlapojtoc huan nesiyaya inacayo teipa quipantis para icoco mocueptoc chipahuac, huajca monequi sampa yas campa nopa totajtzi para ma quitlachilis. ");
INSERT INTO nheBl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Huan nopa totajtzi quitlachilis huan intla campa cocojtoc nelía nesi chipahuac, huajca nopa totajtzi teyolmelahuas para tlapajpactic nopa tlacatl tlen quinpixqui cocome. ");
INSERT INTO nheBl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Quema icuetlaxo se tlacatl quipiyas se cocotl campa temalquisayaya huan teipa mochicahuas, ");
INSERT INTO nheBl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","pero mocahuas temitoc huan nesis chipahuac, o nesi chichiltic huan chipahuac, huajca nopa tlacatl monequi yas campa nopa totajtzi para ma quitlachili. ");
INSERT INTO nheBl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Huan intla nopa totajtzi quiitas para nopa cocotl ajsi huejcatla, tlatzintla nopa cuetlaxtli, huan para itzoyo pehua para elis chipahuac, huajca monequi teyolmelahuas para nopa tlacatl ax tlapajpactic, pampa quipiya nopa tlacayo palanca cocolistli tlen pejqui ica se cocotl ica temali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pero intla nopa totajtzi quitlachilis huan ax quipantis itzoyo tlen nesi chipahuac, huan intla nopa cocotl ax eltoc huejcatla, huan san quentzi chipahuixtoc, huajca monequi quitzacuas iselti para chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Huan intla itlamiya nopa chicome tonali, nopa cocotl mohueyilis achi más, huajca nopa totajtzi quiijtos para nopa tlacatl ax tlapajpactic pampa quipiya se cocotl. ");
INSERT INTO nheBl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pero intla campa nesi chipahuac san se mocahua, huan ax más mohueyilijtoc, huajca quimachilise para san mocahua lipintic icuetlaxo campa pachijqui nopa cocotl. Huan nopa totajtzi quiijtos para nopa tlacatl eli tlapajpactic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Intla se acajya motlatis ipan itlacayo ica tlen hueli tlamantli, huan intla campa motlatijtoc teipa nesis chipahuac, o nesis chichiltic huan chipahuac, ");
INSERT INTO nheBl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","huajca nopa totajtzi quitlachilis ica miyac cuidado campa motlatijtoc nopa tlacatl. Huan intla quiitas para cocojtoc achi huejcatla hasta tlatzintla cuetlaxtli huan itzoyo ya mocueptoc chipahuac, huajca ya quipiya nopa tlacayo palanca cocolistli tlen yolqui campa motlati. Huan nopa totajtzi monequi quiijtos para nopa tlacatl ax tlapajpactic pampa quipiya nopa tlacayo palanca cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pero intla nopa totajtzi quiitas para nopa tlacatl ax quipiya itzoyo chipahuac campa cocojtoc, huan ax más huejcatla, san ipan nopa cuetlaxtli huan nesi para ya pachijtiya, huajca san quitzacuas iselti para chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pero quema tlantos nopa chicome tonali, monequi sampa quitlachilis nopa totajtzi. Intla quiitas para campa cocojtoya achi más mohueyilijtoc, huajca nopa totajtzi quiijtos para, quena, nopa tlacatl quipiya tlacayo palanca cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pero intla campa cocojtoc ax más mohueyilijtoc huan nesi para ya pachijtoc quentzi, huajca nopa totajtzi quiijtos para tlapajpactic nopa tlacatl noixtla. San quipiya ya nopa pampa motlati huan lipintic. ");
INSERT INTO nheBl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Intla se tlacatl o se sihuatl quipiya se cocotl ipan itzonteco o ipan itentzo, ");
INSERT INTO nheBl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","huajca monequi yas campa nopa totajtzi para ma quitlachili. Huan intla nopa cocotl nesis para panotoc tlatzintla nopa cuetlaxtli, huan intla quiitas para nopona quipiya itzoyo tlen nesi costic huan pitzantzitzi, huajca nopa totajtzi quiijtos para nopa tlacatl ax tlapajpactic pampa quipiya se tlamantli cocotl tlen mochijtoc nopa tlacayo palanca cocolistli ipan itzonteco o ipan itentzo. ");
INSERT INTO nheBl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Pero intla nopa totajtzi quiitas para nopa cocotl ax ajsitoc tlatzintla icuetlaxo huan noja quipiya itzoyo tlen yayahuic, huajca nopa totajtzi san quitzacuas nopa tlacatl iselti para chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Huan quema tlantos nopa chicome tonali, nopa totajtzi monequi sampa quitlachilis. Huan intla quiitas para nopa cocotl ax mohueyilijtoc huan ax pejtoc quipiyas itzoyo tlen nesi costic huan nesi para ax ajsitoc tlatzintla icuetlaxo nopa tlacatl, ");
INSERT INTO nheBl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","huajca nopa totajtzi quichihualtis ma quihuatani itentzo. Pero yaja ax hueli quihuatanis campa cocojtoc. Quema tlami mohuatanis, monequi noja mocahuas tzactoc para seyoc chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Huan ipan nopa chicome tonal nopa totajtzi sampa quitlachilis. Huan intla quiitas para nopa cocotl ax mohueyilijtoc, huan nesi para ax ajsitoc huejcatla ipan icuetlaxo, huajca nopa totajtzi quiijtos para nopa tlacatl eltoc tlapajpactic. Huan teipa quema ya quichicuenijtos iyoyo, nopa tlacatl mocahuas tlapajpactic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pero intla nopa cocotl mohueyilis quema ya quiijto para tlapajpactic, ");
INSERT INTO nheBl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","huajca nopa totajtzi monequi sampa quitlachilis. Huan ama, quena, intla mohueyilijtoc, ax monequi quipantis itzoyo tlen costic, pampa ya nesi nopa tlacatl ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pero intla quiitas para nopa cocotl ax mohueyilía huan ya pejtoc para monextía itzoyo tlen yayahuic, huajca quiijtosnequi ya pachijtoc nopa cocotl, huan tlapajpactic nopa tlacatl. Huajca nopa totajtzi quiijtos para tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Huan quema se tlacatl o se sihuatl pehuas para quipiyas ipan icuetlaxo cocome tlen nesi chipahuac, ");
INSERT INTO nheBl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","huajca nopa totajtzi quitlachilis icuetlaxo nopa tlacatl ica miyac cuidado. Intla quiitas nopa cocotl san se quentzi chipahuac, huajca ax ya nopa tlacayo palanca cocolistli. San quipiya tlen hueli cocolistli tlen quiajsic ipan icuetlaxo huan tlapajpactic eli nopa tlacatl noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Intla se tlacatl tepehuis nochi itzoncal hasta ayoc mocahuas niyon se, huajca nopa tlacatl ax quipiya tlacayo palanca cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Huan intla se tlacatl tepehuis itzoncal icuaixco huan mocahua cuapejpetztic, huajca ya nojquiya tlapajpactic, ax quipiya cocolistli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pero intla campa tepehui itzoncal eltos se cocotl tlen nesis chipahuac huan chichiltic, huajca quiijtosnequi pejtoc tlacayo palanca cocolistli campa tepejtoc itzoncal. ");
INSERT INTO nheBl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Huajca monequi nopa totajtzi quitlachilis campa yoli nopa cocotl ipan itzonteco, o icuaixco. Intla quiitas para nesi chipahuac huan chichiltic queja nopa tlacayo palanca cocolistli, ");
INSERT INTO nheBl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","huajca ya nopa quipiya huan ax tlapajpactic. Huan nopa totajtzi monequi quiijtos para nopa tlacatl melahuac quipiya tlacayo palanca cocolistli ipan itzonteco. ");
INSERT INTO nheBl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Se tlacatl tlen quipiya tlacayo palanca cocolistli monequi quihuicas iyoyo tzayantoc, huan ax huelis moxilhuis. Monequi motentzacuas huan monequi tzajtzitinemis: ‘Ax nitlapajpactic. Ax nitlapajpactic.’ ");
INSERT INTO nheBl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Huan yonque nopa cocolistli huejcahua ipan itlacayo, monequi itztos iselti huejca tlen campa mochijtoque ne sequinoc tlacame. ");
INSERT INTO nheBl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Huan intla se iyoyo o itlajque se tlacatl pojyajtoc, o quipiya se mancha monequi quitlachilis nopa totajtzi, yonque eltoc tlen tlachijchihuali ica lino o ica borregojme iniijhuiyo. ");
INSERT INTO nheBl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Yonque nopa mancha eltoc ipan nopa icpatl tlen ijcatoc o huetztoc ipan nopa yoyomitl, o yonque nopa yoyomitl, o tlamantli tlen poyajtoc tlasencahuali ica tlapiyalime inincuetlaxo; intla yoli se mancha, huajca xijhuicaca campa nopa totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Huan intla nesi quentzi xoxohuic o quentzi chichiltic nopa mancha tlen yoli ipan nopa yoyomitl o nopa tlamantli tlen quichijtoque ica cuetlaxtli, huajca campa nopa mancha ya pejtoc nopa tlacayo palanca cocolistli, huan monequi quihuicase iixtla nopa totajtzi para ma quitlachili. ");
INSERT INTO nheBl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Huan nopa totajtzi quitlachilis nopa yoyomitl, o nopa tlamantli, huan quiiyocatlalis para chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Huan quema ajsis nopa chicompa tonal, nopa totajtzi sampa quitlachilis nopa mancha. Huan intla quiitas para mohueyilijtoc ipan nopa yoyomitl o ipan nopa cuetlaxtli, huajca quiijtosnequi para eli se mancha tlen tlacayo palanca cocolistli tlen nelía fiero. Huajca nopa tlamantli mocahuas ax tlapajpactic yonque tlaxinepaloli ipan nopa yoyomitl, o mopantía ipan se tlamantli tlen cuetlaxtli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Huajca nopa yoyomitl tlen tlachijchihuali ica lino, o ica borregojme iniijhuiyo, o nopa tlamantli tlen cuetlaxtli tlen quipiya nopa mancha monequi quitlatise pampa quipiya nopa tlacayo palanca cocolistli tlen nelía fiero. ");
INSERT INTO nheBl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Pero intla quema tlamis chicome tonali, nopa totajtzi quitlachilis huan quiitas para nopa mancha ax más mohueyilijtoc, ");
INSERT INTO nheBl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","huajca quinnahuatis tlen quihualicaque ma quichicuenica nopa tlamantli tlen quipiya nopa mancha, huan sampa quiiyocatlalis seyoc chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","“Huan quema ya quipajpactose, nopa totajtzi quitlachilis sampa, huan intla nesis para nopa mancha noja mocajtoc huan ax quipatlatoc itlachiyalis, huajca nopa tlamantli monequi quitlatise yonque ax mohueyilijtoc más pampa quipiya nopa tlacayo palanca cocolistli. Yonque nopa mancha san ajsi ipan se lado o ajsi ipan nochi ome lados, monequi xijtlatica. ");
INSERT INTO nheBl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Pero intla nopa totajtzi sampa quitlachilis huan quiitas para nopa mancha ayoc más nesi queja achtohui, huajca san quitejtequis huan quiquixtis campa monextijtoc nopa mancha ipan nopa yoyomitl, o cuetlaxtli o ipan nopa tlamantli tlen tlaxinepaloli. ");
INSERT INTO nheBl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Pero intla nopa mancha sampa monextis campa hueli ipan nopa yoyomitl, o ipan nopa tlamantli tlen cuetlaxtli, huajca nopa tlamantli tlen quipiya mancha monequi quitlatise. ");
INSERT INTO nheBl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Pero intla quema ya quichicuenijtose nopa yoyomitl o nopa tlamantli tlen cuetlaxtli ayoc monextis nopa mancha, huajca san monequi quichicuenise seyoc huelta, huan teipa mocahuas tlapajpactic huan sampa huelis quitequihuise. ");
INSERT INTO nheBl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Huajca ya ni elqui nopa tlanahuatili para nopa tlacayo palanca cocolistli tlen monextía ipan yoyomitl tlen tlachijchihuali ica lino, o ica borregojme iniijhuiyo, o ica cuetlaxtli, o monextijtoc ipan sequinoc tlamantli tlen tlachijchihuali ica tlapiyalime inincuetlaxo. Quena, ya ni nopa tlanahuatili tlen quitequihuise para quiijtose intla nopa tlamantli eli tlapajpactic o eli ax tlapajpactic.” ");
INSERT INTO nheBl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ya ni nopa tlanahuatili para se tlacatl tlen quipixtoya nopa tlacayo palanca cocolistli huan quinequi hualas campa nopa totajtzi para motlapajpacchihuas. ");
INSERT INTO nheBl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Nopa totajtzi monequi yas campa mocahua nopa cocoxquetl huejca tlen campa inmochantijtoque para quitlachilis ica miyac cuidado. Intla quiitas para ya pachijtoc campa quipixqui nopa cocotl, ");
INSERT INTO nheBl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","huajca tlajtlanis ma quihuiquilica ome totome tlen tlapajpactic huan tlen cuali para inquicuase. Tlajtlanis ma quinhuiquilica nepa campa itztoc nopa cocoxquetl ihuaya tiocuahuitl, se icpatl tlen chichiltic huan se imacuayo nopa xihuitl tlen itoca hisopo. ");
INSERT INTO nheBl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Teipa nopa totajtzi tlanahuatis ma quiquechtzontequica se tlen nopa ome totome. Quena, monequi quiquechtzontequis ipan se comitl tlen tlachijchihuali ica soquitl huan quipiya atl tlen se ameli. ");
INSERT INTO nheBl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Huan quicuis ica nopa tiocuahuitl, huan nopa icpatl tlen chichiltic huan imacuayo nopa hisopo xihuitl huan nopa seyoc piltototzi tlen noja itztoc huan san sejco quinxolonis ica nopa achtohui tlapiyali ieso ipan nopa comitl tlen quipiya atl tlen huala tlen se ameli. ");
INSERT INTO nheBl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Huan teipa ica nopa tlamantli tlen xolontoc quiatzejtzelhuis nopa totajtzi chicome huelta nopa tlacatl tlen motlapajpacchihuas tlen icocolis. Huan teipa quiijtos para tlapajpactic. Huan nopa piltototzi tlen noja itztoc quimajcahuas para ma patlantinemi campa cuatitlamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Teipa nopa tlacatl tlen ya motlapajpacchijtoc, monequi quichicuenis iyoyo, huan quihuatanis itzoncal. Monequi maltis huan sampa calaquis para itztos campa nochi sequinoc israelitame mochijtoque. Pero noja aya huelis calaquis ipan ichaj tlen yoyomitl. ");
INSERT INTO nheBl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Huan ipan nopa chicome tonal, nopa tlacatl monequi sampa quitequis nochi itzoncal, itentzo huan iixtentzoyo. Teipa sampa quichicuenis iyoyo huan maltis, huan ica ya nopa, motlapajpacchihuas tlen nopa cocolistli tlen quipixtoya. ");
INSERT INTO nheBl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Huan ipan tonali chicueyi, quincuis eyi pilborregojtzitzi tlen quipiyaj sesen xihuitl huan niyon se tlamantli tlen ax cuali quipiyaj ipan inintlacayo. Monequi ome oquichme huan se sihuatzi tlen cuali inintlacayo. Nojquiya quicuis chicome litro harina tlen nelcuechtic huan tlamaneloli ica aceite para se tlacajcahualistli tlen harina, huan ihuaya quihuicas tlajco litro aceite. ");
INSERT INTO nheBl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Huan nopa totajtzi tlen tetlapajpacchihua, quihuicas nopa tlacatl tlen motlapajpacchihuas noixtla, niimoTECO. Huan ihuaya quihualicas nochi nopa tlamantzitzi tlen motequihuis, huan temacas noixtla na, niimoTECO nepa campa ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Teipa nopa totajtzi quicuis se tlen nopa piloquich borregojtzitzi huan nopa tlajco litro aceite huan quitencahuas noixtla queja se tlacajcahualistli para nopa tlacatl tlen quihuica tlajtlacoli. Huan para nechmacas monequi quinhuisos noixtla, niimoTECO. Huan elis queja se tlacajcahualistli tlahuisoli. ");
INSERT INTO nheBl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Huan teipa nopa totajtzi quiquechtzontequis nopa pilborregojtzi nopona campa yoyon tiopan puerta campa quinmictíaj nopa tlapiyalime para tlacajcahualistli ipampa tlajtlacoli huan para tlacajcahualistli tlatlatili. Huan nopa tlacajcahualistli ipampa tlajtlacoli huan ni tlacajcahualistli para tlen quihuica tlajtlacoli noixtla elis iaxca nopa totajtzi para tlacualistli pampa tlahuel tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“Huan nopa totajtzi quicuis se quentzi ieso nopa tlapiyali tlen quitencajtoc queja se tlacajcahualistli para tlen quihuica tlajtlacoli noixtla huan nopa estli quiajalos ipan inacas nejmatl nopa tlacatl tlen motlapajpacchihuas. Nojquiya quiajalos ipan imacpil tlen hueyi tlen ima nejmatl huan ipan ixocpil tlen hueyi tlen iicxi nejmatl. ");
INSERT INTO nheBl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","“Teipa nopa totajtzi quicuis nopa aceite huan quitecas quentzi ipan tlen ya ima arraves. ");
INSERT INTO nheBl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Huan teipa nopa totajtzi quixolonis imacpil tlen ima nejmatl ipan nopa aceite huan ica imacpil tlaatzejtzelhuis chicome huelta noixtla na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Huan ica nopa aceite tlen noja mocahuas ipan nopa totajtzi ima, quiajalos se quentzi inacas nejmatl nopa tlacatl tlen motlapajpacchihuas. Huan nojquiya quiajalos ipan imacpil tlen hueyi tlen ima nejmatl huan ipan ixocpil tlen hueyi tlen iicxi nejmatl. Huan nojquiya quitlalis aceite ipan nopa estli tlen nopa tlacajcahualistli para tlen quihuica tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Huan nopa aceite tlen noja mocahuas imaco nopa totajtzi quitequihuis para quiajalos ipan itzonteco nopa tlacatl tlen motlapajpacchihuas huan nechixtzacuilis itlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Teipa nopa totajtzi nechmacas nopa tlacajcahualistli ipampa tlajtlacoli para quiixtzacuas itlajtlacolhua nopa tlacatl tlen quitlapajpacchihua tlen nopa cocolistli tlen quichijtoya ax tlapajpactic. Huan teipa quimictis nopa tlapiyali tlen nechmacas queja se tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Huan nechmacas ipan tlaixpamitl nopa tlacajcahualistli tlatlatili ihuaya nopa tlacajcahualistli tlen harina. Huan ica nochi ya ni, nopa totajtzi nechixtzacuilis nopa tlacatl itlajtlacolhua, huan yajaya mocahuas tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Pero intla nopa tlacatl eli tlahuel teicneltzi huan ax huelis quincohuas ome pilborregojtzitzi, huajca hueli nechmacas setzi pilborregojtzi queja se tlacajcahualistli para tlen quihuica tlajtlacoli, pero achtohui quihuisos noixtla, niimoTECO, para se tlacajcahualistli majcahuali para nechixtzacuilis itlajtlacolhua. Huan para nopa tlacajcahualistli tlen harina, san quihualicas ome kilo huan tlajco harina tlen tlamaneloli ica aceite, ihuaya se tlajco litro aceite. ");
INSERT INTO nheBl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","“Nojquiya quinhuicas ome pichontzitzi o ome palomas queja quiitas para quiaxilía itomi. Huan se tlen nopa ome totome elis para nechmacas queja se tlacajcahualistli ipampa tlajtlacoli, huan nopa seyoc nechmacas queja se tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Nochi ya nopa monequi quihuicas ipan nopa chicueyi tonal. Huan quimactilis nopa totajtzi nopona noixtla campa ipuerta nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Huan nopa totajtzi quicuis nopa pilborregojtzi tlen nechmacas na, niimoTECO, queja se tlacajcahualistli para tlen quihuica tlajtlacoli. Nojquiya quicuis nopa tlajco litro aceite, huan elis queja se tlacajcahualistli tlen quihuijhuisos noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Teipa quiquechtzontequis nopa pilborregojtzi para se tlacajcahualistli para tlen quihuica tlajtlacoli, huan quicuis se quentzi ieso huan quiajalos ipan inacas nejmatl nopa tlacatl tlen quipajpaca huan quiajalos ipan imacpil tlen hueyi tlen ima nejmatl huan ixocpil tlen hueyi tlen iicxi nejmatl. ");
INSERT INTO nheBl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","“Teipa nopa totajtzi quicuis nopa aceite huan quitecas se quentzi ipan ima tlen iarraves. ");
INSERT INTO nheBl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Huan teipa quixolonis imacpil tlen ima nejmatl huan ica nopa aceite tlaatzejtzelhuis chicome huelta noixtla, na niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Nojquiya nopa totajtzi quicuis quentzi aceite tlen ipan ima tlen iarraves huan quiajalos inacas nejmatl nopa tlacatl tlen motlapajpacchihua. Nojquiya quiajalos ipan imacpil tlen hueyi tlen ima nejmatl huan ipan ixocpil tlen hueyi tlen iicxi nejmatl. San se quiajalos campa quiajalo ieso nopa tlapiyali tlen quitencajque para tlacajcahualistli para tlen quihuica tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Huan nopa aceite tlen noja mocahuas ipan ima nopa totajtzi, quiajalos ipan itzonteco nopa tlacatl tlen motlapajpacchihua. Ya nopa nechixtzacuilis itlajtlacol, na niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“Teipa nopa totajtzi nechmacas se tlen nopa palomas o nopa pichontzitzi, tlen quiaxili itomi nopa tlacatl para quicohuas. ");
INSERT INTO nheBl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Nechmacas se queja se tlacajcahualistli ipampa tlajtlacoli huan nopa seyoc nechmacas queja se tlacajcahualistli tlatlatili, huan ihuaya nechmacas nopa tlacajcahualistli tlen harina.” ");
INSERT INTO nheBl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Huajca ya ni elqui nopa tlanahuatili tlen monequi quitoquilis se tlacatl tlen ayoc quipiya tlacayo palanca cocolistli huan ax quiaxilis para temacas se tlacajcahualistli patiyo para ica motlapajpacchihuas. ");
INSERT INTO nheBl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Huan TOTECO quinilhui Moisés huan Aarón: ");
INSERT INTO nheBl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Quema ya inajsitose ipan tlali Canaán tlen na nimechmacatoc para imoaxca huan na nijtlalis ipan se cali se mancha tlen nesi para ax san aquistoc pero quipiya se hueyi cocolistli, ");
INSERT INTO nheBl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","huajca nopa tlacatl tlen iaxca nopa cali monequi yas quiitati nopa totajtzi huan quiilhuis: ‘Na niquita para ipan nochaj pejtoc mopannextía se mancha tlen nopa hueyi cocolistli.’ ");
INSERT INTO nheBl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“Huan quema nopa totajtzi aya calaqui ipan nopa cali, tlanahuatis ma quisaca nochi tlen itztoque nopona huan ma quiquixtica nochi tlamantzitzi tlen calijtic eltoc. Queja nopa ax quiijtos para ax tlapajpactique nochi nopa tlacame huan nopa tlamantzitzi tlen nopona onca. Huan teipa quema ya quistose, nopa totajtzi calaquis huan quitlachilis nopa mancha tlen mopannextijtoc. ");
INSERT INTO nheBl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","“Huan intla nopa totajtzi quiitas para nopona campa coyontoc nopa tlapepecholme mopannextijtoque manchas tlen nesij chichiltique o xoxohuique huan nesij para calactoque hasta huejcatla ipan tlapepecholi, ");
INSERT INTO nheBl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","huajca nopa totajtzi quisas huan quitzacuas nopa cali para chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Huan quema ajsis nopa chicome tonal, nopa totajtzi monequi sampa hualas quitlachiliqui. Intla quiitas para nopa mancha mohueyilijtoc ipan nopa tlapepecholi, ");
INSERT INTO nheBl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","huajca tlanahuatis ma quiquixtica nopa tetini ipan tlapepecholi campa mopannextijtoc nopa mancha, huan monequi quimajcahuatij huejca tlen campa inmochijtoque ipan se lugar tlen ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Huan nojquiya tlanahuatis ma quihuatanica nopa tlapepecholi yahualtic campa eltoya nopa mancha. Huan nochi nopa soquitl huan tlaltejpoctli quicahuatij huejca tlen campa inmochijtoque ipan se lugar tlen ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Teipa nopa tlacame quicuise sequinoc tetini para quitlalise ipan nopa lugar campa quiijcuenijque nopa tetini tlen quipiyayayaj manchas. Huan nojquiya quitlalise yancuic soquitl para quitlatzquiltise nopa tetl. ");
INSERT INTO nheBl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Pero intla nopa mancha sampa mopannextis ipan nopa cali quema ya quipatlatose nopa tetini, huan ya quihuatanijtose nopa tlapepecholi huan ya quitlalilijtose soquitl tlen yancuic, ");
INSERT INTO nheBl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","huajca nopa totajtzi calaquis huan sampa quitlachilis ica miyac cuidado. Huan intla quiitas para nopa mancha mohueyilijtoc ipan nopa tlapepecholi, huajca quiijtosnequi ya pejtoc nopa hueyi cocolistli tlen más fiero ipan nopa cali. Huan nopa cali elis ax tlapajpactic huan queja nopa mocahuas. ");
INSERT INTO nheBl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Huajca monequi ma quitlamiltica nopa cali huan nochi tetl huan cuahuitl huan soquitl ma quicahuatij ipan se lugar campa ax tlapajpactic tlen mocahua huejca tlen campa inmochijtoque. ");
INSERT INTO nheBl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Huan intla acajya calaquis calijtic ipan nopa tonali quema nopa totajtzi tlanahuati para eltos tzactoc, huajca ya mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Huan tlen hueli tlen tlacuas o motecas ipan nopa cali quema tzactoc monequi quichicuenis iyoyo. ");
INSERT INTO nheBl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Pero intla quema ya quipatlatoque nopa tetl huan soquitl, ax tleno nesis quema sampa calaquis nopa totajtzi para quiitas nopa mancha, huajca quiijtos para nopa cali tlapajpactic pampa nopa hueyi cocolistli ya ixpolijtoc. ");
INSERT INTO nheBl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Huan quema nopa totajtzi quitlapajpacchihuas nopa cali monequi quintequihuis ome totome, tiocuahuitl, se icpatl tlen chichiltic huan se imacuayo nopa cuahuitl tlen itoca hisopo. ");
INSERT INTO nheBl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Huan quiquechtzontequis se tlen nopa ome totome ipan se huajcali tlen tlachijchihuali ica soquitl tlen quipiyas atl tlen huala ipan se ameli. ");
INSERT INTO nheBl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","52","Huan nopa totajtzi quicuis nopa tiocuahuitl, nopa hisopo xihuitl imacuayo, nopa icpatl tlen chichiltic huan nopa seyoc tototl tlen noja itztoc, huan san sejco quinxolonis ipan nopa achtohui tototl ieso ihuaya nopa atl tlen ameli. Huan quinquixtis huan quiatzejtzelhuis chicome huelta nopa cali. Huan queja nopa quitlapajpacchihuas nopa cali. ");
INSERT INTO nheBl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Teipa yas huejca tlen nopa altepetl huan quimajcahuas nopa tototl tlen itztoc para ma patlani ipan cuatitlamitl. Huan quej nopa ya quichijtos nochi tlen monequi para nechixtzacuilis nopa tlajtlacoli tlen eltoya ipan nopa cali, huan nopa cali mocahuas tlapajpactic.” ");
INSERT INTO nheBl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","55","Nochi ya ni eli nopa tlanahuatili para campa hueli campa quipantíaj manchas tlen nopa hueyi cocolistli yonque mopannextía ipan se cali, o ipan se yoyomitl, o ipan icuetlaxo se tlacatl, ");
INSERT INTO nheBl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","o intla mopannextía campa semajtoc itlacayo se tlacatl, o campa motlatijtoc, o campa iselti yoli se mancha. ");
INSERT INTO nheBl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Huan ica ni tlanahuatili tlen cocolistli ipan tecuetlaxo o tlen hueli tlamantli, inquimatise quema ax tlapajpactic se tlamantli huan quema tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Huan TOTECO quinilhui Moisés huan Aarón: ");
INSERT INTO nheBl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Xiquinilhuica nopa israelitame ni miyac tlanahuatili. Quema se tlacatl quipiya atl tlen mojmostla temo ipan itlacayo, ax tlapajpactic nopa tlacatl. ");
INSERT INTO nheBl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Huan yonque quisenhuiquilis toyahuis o motzacuas, nopa tlacatl mocahuas ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“Nochi tlapechtli tlen ipan motecas nopa tlacatl tlen aquisa mochihuase ax tlapajpactique. “Huan campa mosehuis, quichihuas para nopa siya o nopa tlamantli elis ax tlapajpactic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","“Huan aqui hueli tlen quitoxomas nopa tlapechtli, monequi quichicuenis iyoyo huan maltis, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","“Huan intla se tlacatl mosehuis ipan nopa siya o nopa tlamantli campa ipan mosehui nopa tlacatl tlen aquisa, huajca monequi quichicuenis iyoyo huan maltis, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“Huan tlen hueli tlen quitoxomas nopa tlacatl tlen aquisa, monequi quichicuenis iyoyo, huan maltis, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Huan intla nopa tlacatl tlen aquisa chajchas ipan se tlacatl tlen tlapajpactic, huajca elis ax tlapajpactic. Monequi nopa tlacatl quichicuenis iyoyo huan maltis ica atl, huan mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“Huan intla nopa tlacatl tlen atemo tlejcos ipan se cahuayo, huajca nopa cahuajsiya mochihuas ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","“Tlen hueli tlen quitoxomas o quihuicas se tlamantli tlen ipan mosehuijtoc, o motectoc nopa tlacatl tlen atemo, mocahuas ax tlapajpactic hasta tlayohua. “Huan nopa tlacatl monequi quichicuenis iyoyo huan maltis, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Intla se tlacatl tlen atemo quiitzquis se acajya ica ima huan ax momajtequijtoc, huajca nopa tlacatl tlen quiitzquili ima monequi quichicuenis iyoyo huan maltis, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Intla nopa tlacatl tlen atemo quiitzquis se comitl tlen tlachijchihuali ica soquitl, huajca nopa comitl monequi quitlapanase. Huan intla quinitzquis tlamantzitzi tlen tlachijchihualme ica cuahuitl, huajca nopa tlamantzi san monequi quinpajpacase ica atl. ");
INSERT INTO nheBl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Intla ayoc atemos nopa tlacatl, huan quinequis pehuas motlapajpacchihuas monequi achtohui quichiyas seyoc chicome tonali. Huan intla quiitas ayoc atemo, huajca quichicuenis iyoyo huan mopajpacas ica atl tlen ameli. ");
INSERT INTO nheBl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Huan ipan tonali chicueyi quincuis ome pichontzitzi o ome palomas huan monextis iixtla TOTECO campa ipuerta nopa yoyon tiopamitl huan quinmacas nopa totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Huan nopa totajtzi nechmacas se queja se tlacajcahualistli ipampa tlajtlacoli. Huan ne seyoc nechmacas queja se tlacajcahualistli tlatlatili. Huan queja nopa, nopa totajtzi nechixtzacuilis itlajtlacol nopa tlacatl ipampa nopa atemolistli tlen quipixqui. ");
INSERT INTO nheBl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Quema se tlacatl quitoyahuas ixinajcho, monequi quipajpacas nochi itlacayo ica atl, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","“Huan intla toyahuis se quentzi ipan se yoyomitl o ipan se cuetlaxtli, huajca nopa tlamantli monequi quipajpacase ica atl huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","“Huan quema se tlacatl itztos ihuaya se sihuatl huan quitoyahuas ixinajcho, huajca nochi ome monequi mopajpacase ica atl, huan ax tlapajpactic mocahuase hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Huan quema se sihuatl esotemos, mocahuas ax tlapajpactic para chicome tonali. “Huan tlen quiitzquis nopa sihuatl, mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“Nochi tlamantli tlen ipan motecas o mosehuis nopa sihuatl ipan nopa chicome tonali, mocahuas ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","“Huan tlen hueli tlen quiitzquis itlapech nopa sihuatl tlen esotemo, monequi quichicuenis iyoyo huan maltis, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","23","“Huan tlen hueli tlen quiitzquis nopa tlapechtli, o nopa siya, o tlen hueli tlamantli tlen ipan mosehui nopa sihuatl tlen esotemo monequi quichicuenis iyoyo huan maltis, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“Intla se tlacatl cochis ihuaya nopa sihuatl ipan nopa tonali quema esotemo huan ieso quiajsis, huajca nopa tlacatl mocahuas ax tlapajpactic para chicome tonali. Huan tlen hueli tlapechtli tlen ipan motecas nopa tlacatl nojquiya mocahuas ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Huan intla se sihuatl noja esotemos miyac tonali quema ayoc ipohual, o pehuas esotemos ipan se tonali quema ax ipohual, huajca ax tlapajpactic san se queja nelía ipohual. ");
INSERT INTO nheBl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","“Huan nochi tlapechtli huan siyas tlen ipan mosehuis mocahuase ax tlapajpactic san queja ax tlapajpactique eli quema nelía ipohual para esotemos. ");
INSERT INTO nheBl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","“Nojquiya tlen hueli tlen quiitzquis nopa tlapechtli campa motejqui, o nopa siyas campa mosehui, mocahuas ax tlapajpactic. Monequi quichicuenis iyoyo huan maltis, huan noja mocahuas ax tlapajpactic hasta tlayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Huan quema ya tlantos esotemo, monequi quipohuas chicome tonali huan teipa mocahuas tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Huan ipan tonali chicueyi nopa sihuatl tlen esotemoyaya quema ax ipohual monequi quincuis ome pichontzitzi, o ome palomas, huan quinhuicas campa nopa totajtzi huan quimactilis nechca ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Huan nopa totajtzi nechmacas se tlen nopa totome queja se tlacajcahualistli ipampa tlajtlacoli, huan ne seyoc nechmacas queja se tlacajcahualistli tlatlatili. Huan queja nopa, nopa totajtzi nechixtzacuilis nopa esotemolistli tlen nopa sihuatl quipixqui tlen quichihuayaya ax tlapajpactic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Monequi quej ni inquintlapajpacchihuase israelitame quema ax tlapajpactique. Pampa intla ax motlapajpacchihuase, quichihuase ax tlapajpactic nopa yoyon tiopamitl campa na nimocahua tlatlajco imojuanti, huan queja nopa monequi miquise. ");
INSERT INTO nheBl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“Huajca nochi ya ni elqui nopa tlanahuatili para se tlacatl tlen atemo o tlen toyahui ixinajcho huan yeca mocajqui ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Huan sequin ni tlanahuatili nojquiya eli para sihuame quema esotemoj quema ininpohual huan quema ax ininpohual. Nojquiya nica eltoc nopa tlanahuatili para tlacame tlen cochij ihuaya se sihuatl tlen ax tlapajpactic pampa esotemo.” ");
INSERT INTO nheBl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","TOTECO quicamahui Moisés quema ya mictoyaj nopa ome itelpocahua Aarón. Mijque pampa monechcahuijque campa itztoc TOTECO, pero ax queja quinamiqui. ");
INSERT INTO nheBl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Huan TOTECO quiilhui: “Xiquilhui moicni, Aarón, ax hueli calaquis tlen hueli hora ipan nopa cuarto tlen Más Tlatzejtzeloltic tlen eltoc iica nopa cortina campa mocahua nopa caxa. Intla calaquis nopona ipan se tonal quema ax onca tlanahuatili para calaquis, miquis. Pampa itzonixco itzajca nopa caxa campa nechixtzacuilis tetlajtlacolhua, na noselti niitztos ipan nopa mixtli. ");
INSERT INTO nheBl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Huajca quej ni monequi mocualtlalis Aarón, quema ajsis nopa tonal sesen xihuitl quema monequi calaquis ipan nopa cuarto tlen Más Tlatzejtzeloltic. Aarón monequi quihualicas se becerro para nechmacas queja se tlacajcahualistli ipampa tlajtlacoli huan se oquich borrego para nechmacas queja se tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Achtohui monequi maltis, huan teipa monequi moquentis itlatzintlanyoyo tlen huehueyac huan tlen tlatzejtzeloltic, huan monequi moquentis itlatzintlanyoyo tlen lino. Teipa motlalilis itzinquechilpica, huan motlalilis icuatzajca pampa ya ni iyoyo tlen tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Huan israelitame quihuiquilise ome oquich chivojme para tlacajcahualistli ipampa tlajtlacoli. Huan quihuiquilise se oquich borrego para elis se tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Pero achtohui monequi Aarón ma nechmaca nopa becerro para se tlacajcahualistli ipampa tlajtlacoli tlen nechixtzacuilis tlen ya iselti itlajtlacolhua huan tlen ya ifamilia inintlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Huan teipa quincuis nopa ome oquich chivojme huan quinhualicas noixtla campa ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Huan teipa quichihuas suertes ica nopa ome oquich chivojme para quiitas tlen elis para na, niimoTECO, huan tlen elis para quihuicas tetlajtlacolhua hasta campa itoca Azazel ipan nopa tlahuel huactoc tlali campa ayoc quema huelis mocuepas sampa. ");
INSERT INTO nheBl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Huan Aarón quimictis nopa oquich chivo tlen elis para na huan nechmacas queja se tlacajcahualistli ipampa tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pero nopa oquich chivo tlen elis para quihuicas tetlajtlacolhua huejca, quiixnextis noja yoltoc noixtla, niimoTECO. Huan teipa quitlalis tetlajtlacolhua ipan nopa chivo queja monequi para nechixtzacuilis inintlajtlacol huan teipa quititlanis para yas huejca ipan nopa huactoc tlali para quihuicas tetlajtlacolhua nopona huan ayoc quema mocuepas sampa. ");
INSERT INTO nheBl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Huan quema Aarón ya quimictijtos huan ya quitencajtos nopa becerro para nechixtzacuilis itlajtlacolhua huan itlajtlacolhua iteixmatcahua, ");
INSERT INTO nheBl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","monequi quicuis se popochcomitl tlen temitoc ica tlicoli xahuantoc tlen eltoc ipan tlaixpamitl noixtla na, niimoTECO. Huan nojquiya quicuis ome tlamajtzoli copali tlen tlatixtli nelía cuechtic huan tlen mijmiyotía ajhuiyac, huan calaquis ipan nopa cuarto iica nopa cortina. ");
INSERT INTO nheBl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Huan nopona ipan nopa cuarto campa na, niimoTECO, niitztoc, quitlalis nopa copali ipan nopa tlitl tlen quihualica ihuaya. Huan quema quitlatis nopa copali, ipocyo quichihuas se mixtli para quiixtzacuilis nopa caxa itzajca para Aarón ax quiitas huan ax miquis. Pampa ipan itzajca nopa caxa eltoc campa nijnextis tlasojtlacayotl para tlacame. Huan iijtic nopa caxa oncas nopa tepatlactli ica nopa tlajtoli tlen nijchihua imohuaya. ");
INSERT INTO nheBl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Teipa quihualicas se quentzi ieso nopa becerro huan ica imacpil quiatzejtzelhuis chicome hueltas iixtla itzajca nopa caxa ica campa quisa tonati pampa nopona nitetlasojtla. Nojquiya tlaatzejtzelhuis ica imacpil seyoc chicome hueltas iixmelac nopa caxa. ");
INSERT INTO nheBl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Teipa quisas huan quimictis nopa oquich chivo tlen nechmacas queja se tlacajcahualistli ipampa tlajtlacoli para israelitame inintlajtlacolhua. Huan quihualicas quentzi ieso ipan nopa cuarto tlen iica nopa cortina. Huan ica ya nopa, quiatzejtzelhuis iixco itzajca nopa caxa campa onca tlasojtlacayotl para tlacame huan nojquiya quiatzejtzelhuis iixtla. Quena, san se quichihuas queja quichijqui ica nopa becerro ieso. ");
INSERT INTO nheBl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Huan queja nopa nechixtzacuilis nopa tlajtlacoli tlen israelitame quihuicaj tlen quichihuilijtoc ax ma eli tlapajpactic nopa cuarto tlen Más Tlatzejtzeloltic. Teipa san se quiixtzacuas nopa tlajtlacoli tlen quichihuilijtoc para nopa yoyon tiopamitl ax ma eli tlapajpactic. Pampa nopa yoyon tiopamitl ica nopa cuarto tlen Más Tlatzejtzeloltic mocahua tlatlajco campa mochijtoque nopa tlajtlacolchijca israelitame tlen ax tlapajpactique noixtla. Yeca inintlajtlacolhua quichihua ma eli ax tlapajpactic hasta calijtic ipan nopa yoyon tiopamitl huan monequi inquitlapajpacchihuase. ");
INSERT INTO nheBl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“Huan quema Aarón panos calijtic Campa Más Tlatzejtzeloltic para quiixtzacuas itlajtlacolhua, huan ifamilia inintlajtlacolhua, huan inintlajtlacolhua israelitame, huan nochi nopa tlajtlacoli tlen quichihuilijtoc nopa cuarto ax tlapajpactic, ax hueli itztos niyon se tlacatl ipan nopa yoyon tiopamitl hasta ya quisas. ");
INSERT INTO nheBl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Huan teipa yajaya monequi quisas huan yas campa nopa tlaixpamitl tlen eltoc ipan calixpamitl noixtla na, niimoTECO, para quiixtzacuas nopa tlajtlacoli tlen onca nopona. Huan quicuis se quentzi ieso nopa becerro huan se quentzi ieso nopa oquich chivo huan quiajalos ipan nopa nahui icuacua nopa tlaixpamitl tlen eltoque ipan nahui inacastla. ");
INSERT INTO nheBl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Huan ica imacpil quitzejtzelos nopa estli chicome hueltas ipan nopa tlaixpamitl, huan ica ya nopa quitlapajpacchihuas israelitame inintlajtlacolhua huan mocahuase tlaiyocatlalilme para Toteco. ");
INSERT INTO nheBl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Huan quema Aarón tlantos quitlapajpacchihuas nopa cuarto tlen Más Tlatzejtzeloltic, huan nopa yoyon tiopamitl huan nopa tlaixpamitl, tlanahuatis ma quihualiquilica nopa oquich chivo tlen itztoc. ");
INSERT INTO nheBl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Huan Aarón quitlalis nochi ome ima ipan itzonteco nopa oquich chivo tlen itztoc huan nechpohuilis nochi inintlajtlacolhua huan inintlaixpanolhua israelitame. Huan quema quitenpojtos nochi tetlajtlacolhua, huajca nochi tetlajtlacolhua mocahuase ipan nopa tlapiyali. Huan teipa se tlacatl tlen yajaya quitlapejpenijtos, ma quihuicas nopa tlapiyali huan ma quicahuati huejca ipan nopa huactoc tlali huan ayoc quema mocuepas. ");
INSERT INTO nheBl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Huan quema nopa tlacatl quimajcahuati nopa chivo, quihuicas nochi tetlajtlacolhua más huejca ipan se tlahuel huactoc tlali huan ax quema mocuepas. ");
INSERT INTO nheBl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Huan teipa quema Aarón sampa calaquis yoyon tiopan calijtic monequi moquixtilis iyoyo huehueyac tlen tlachijchihuali ica lino tlen moquentijtoya para calaquis nopa cuarto Campa Más Tlatzejtzeloltic huan quicahuas iyoyo nopona ipan nopa cuarto Campa Tlatzejtzeloltic tlen nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Teipa mopajpacas ica atl nopona ipan calixpamitl ipan nopa yoyon tiopamitl campa tlatzejtzeloltic, huan teipa sampa moquentis iyoyo tlen huehueyac huan tlen ipa quitequihuía. Huan teipa hualas huan nechmacas nopa tlacajcahualistli tlatlatili para ya huan nojquiya nopa seyoc tlacajcahualistli para israelitame para quiixtzacuas itlajtlacolhua huan israelitame inintlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Huan ichiyajca nopa tlapiyali tlen quitencajqui queja se tlacajcahualistli ipampa tlajtlacoli, quitlatis ipan nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Huan nopa tlacatl tlen quitlapejpenijque para quihuicas nopa oquich chivo huan quititlanis ipan nopa tlahuel huactoc tlali campa itoca Azazel, quichihuas nopa tequitl huan teipa quichicuenis iyoyo huan mopajpacas ica atl. Huan huajca, quena, huelis calaquis sampa campa inmochijtoque. ");
INSERT INTO nheBl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“Huan inintlacayohua nopa becerro huan nopa oquich chivo tlen elque tlacajcahualistli ipampa tlajtlacoli huan tlen inieso quihuicac Campa Más Tlatzejtzeloltic para quiixtzacuas tlajtlacoli nopona, monequi quihuicase tlahuel huejca tlen campa inmochijtoque. Nopona quintlatise ihuaya inincuetlaxo, inincuitlaxcol, inincuitl huan nochi tlen elqui iniijtico. ");
INSERT INTO nheBl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Huan teipa yajaya tlen quinhuicac, monequi quichicuenis iyoyo, huan mopajpacas ica atl, huan teipa sampa hueli mocuepas campa inmochijtoque. ");
INSERT INTO nheBl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Huajca ya ni nopa miyac tlanahuatili tlen monequi inquitlepanitase nochipa: Ipan majtlactli itequi nopa chicompa metztli ipan israelita calendario 16:29 Ipan septiembre o octubre ipan tocalendario tlen ama., ax inquichihuase niyon se tlamantli tequitl, pero monequi inmoechcapanose noixtla huan inmotejtemose. Ma ax tequitica israelitame, niyon seyoc tlali ehuani tlen itztoque imohuaya, pampa ya ni se tlanahuatili tlen monequi nochi inquitlepanitase. ");
INSERT INTO nheBl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ipan ni tonal nopa totajtzi quiixtzacuas imotlajtlacolhua para inmechtlapajpacchihuas huan yeca inmochihuase intlapajpactique tlen nochi imotlajtlacolhua noixtla na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ipan nopa tonali monequi inmosiyajcahuase huan inmoyoltlachilise para inmoechcapanose noixtla. Ya ni eli se tlanahuatili tlen monequi inquitlepanitase para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Huan teipa quema itztos seyoc hueyi totajtzi tlen quiajaltise huan quiiyocatlalise para quiixtzacuas tlajtlacoli ipatlaca inintata Aarón, nopa yancuic totajtzi moquentis nopa yoyomitl tlatzejtzeloltic tlen tlachijchihuali ica lino. ");
INSERT INTO nheBl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Huan yajaya quiixtzacuas tlajtlacoli ipampa nopa cuarto Campa Más Tlatzejtzeloltic huan ipampa nopa yoyon tiopamitl, huan ipampa tlaixpamitl. Huan nojquiya quiixtzacuas inintlajtlacolhua nopa totajtzitzi huan inintlajtlacolhua nochi israelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Huajca xijmatica ya ni se tlanahuatili tlen monequi inquitlepanitase para nochipa: Se huelta ipan se xihuitl monequi nechixtzacuilise inintlajtlacolhua israelitame.” Huan Aarón quitoquili senquistoc nochi ni miyac tlanahuatili tlen TOTECO quimacac Moisés. ");
INSERT INTO nheBl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Xiquinmaca Aarón huan nochi israelitame ni miyac tlanahuatili. ");
INSERT INTO nheBl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","“Tlen hueli israelita tlen quimictis se huacax, se pilborregojtzi o se oquich chivo nechca ichaj o huejca tlen campa inmochijtoque quihuicas tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Nochi tlacajcahualistli huan nochi tlapiyalime tlen inquinmictise para tlacualistli monequi achtohui xiquinhualicaca campa ipuerta nopa yoyon tiopamitl para innechmacase na, niimoTECO. Intla se tlacatl quihuicas se tlapiyali ipan seyoc lado huan quimictis huan ax nechmacatoc na queja niquijto, huajca quihuica tlajtlacoli pampa quitoyajqui estli. Huan nopa tlacatl monequi inquiquixtise tlen campa imojuanti para ayoc quema huelis itztos imohuaya. ");
INSERT INTO nheBl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Nimechmaca ni tlanahuatili para israelitame ayoc quema ma quimictica tlapiyalime ipan seyoc lado. Monequi ma quinhualicaca campa ipuerta nopa yoyon tiopamitl para nechmacase na, niimoTECO. Ma quimacaca nopa totajtzi huan nopona quinmictise nopa tlapiyali queja se tlacajcahualistli para ma onca tlayoltlalili nohuaya na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Huan nopa totajtzi quiijtzelos nopa estli ipan nopa tlaixpamitl tlen eltoc nechca ipuerta nopa yoyon tiopamitl. Huan nopa tlachiyajcayotl quitlatis huan mijmiyotis ajhuiyac huan nechyolpactis na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Huan yeca israelitame ayoc quema hueli quinmacase tlacajcahualistli nopa ajacame campa hueli. Queja se tlacanenca sihuatl tlen quicajtejtoc ihuehue, nopa israelitame tlajtlacolchijtoque miyac noixtla pampa nechcajtejtoque para quintoquilise ajacame. Ni tlanahuatili para san nechca nopa yoyon tiopamitl huelis quinmictise tlapiyalime monequi xijtlepanitaca imojuanti huan imoteipa ixhuihua tlen tlacajtiyase teipa. ");
INSERT INTO nheBl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Huajca xiquinilhui para niyon se israelita o seyoc tlali ejquetl tlen itztoc imohuaya hueli quimictis se tlapiyali o quitencahuas se tlacajcahualistli, ");
INSERT INTO nheBl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","huan ax quihualicas campa ipuerta nopa yoyon tiopamitl huan nechmacas na, niimoTECO. Aqui hueli tlen quichihuas ya nopa, monequi inquiquixtise tlen campa imojuanti para ayoc quema hueli itztos ica inisraelitame. San nopona campa ipuerta nopa yoyon tiopamitl nijtlapejpenijtoc para innechmacase tlacajcahualistli huan san nopona inquinmictise tlapiyalime. ");
INSERT INTO nheBl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Nojquiya intla se israelita o se seyoc tlali ejquetl tlen itztoc imohuaya quicuas estli, huajca na tlahuel nicualanis ica nopa tlacatl huan nijquixtis tlen campa imojuanti para ayoc quema huelis itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Pampa iyolis nopa tlapiyali mocahua ipan ieso tlen quipixtoc ipan itlacayo. Huan nopa estli nimechmacatoc para inquiijtzelose ipan nopa tlaixpamitl para ica intlaxtlahuase huan inquiixtzacuase imotlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","“Huajca nimechilhuía inisraelitame: Niyon se imojuanti huan niyon se seyoc tlali ejquetl tlen itztoc imohuaya ax hueli quicuas estli. ");
INSERT INTO nheBl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Huan intla israelitame o seyoc tlali ehuani tlapehuatij huan quimictise se tlamantli tlapiyali o tototl tlen tlapajpactic para inquicuase, monequi nopona campa quimictise, quitoyahuase tlalchi ieso huan ipani quitemilise tlali. ");
INSERT INTO nheBl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Pampa ininyolis nochi tlamantli tlapiyalime eltoc ipan inieso tlen quipixtoque ipan ininnacayo. Yeca niquinilhuijtoc ma ax quicuaca estli, pampa inieso nochi totome huan tlapiyalime quihuica ininyolis. Huajca tlen hueli tlen quicuas estli, monequi inquiquixtise tlen campa imojuanti para ayoc quema huelis itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Huan aqui hueli israelita o seyoc tlali ejquetl tlen quicuas inacayo se tlapiyali tlen mijqui ica iselti, o tlen quimictijque sequinoc tlapiyalime, monequi quichicuenis iyoyo huan mopajpacas ica atl. Huan noja mocahuas ax tlapajpactic hasta tlayohua. Teipa quema ajsis tlayohua, mochihuas tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Pero intla ax quichicuenis iyoyo, niyon ax mopajpacas ica atl, huajca quihuicas tlajtlacoli.” ");
INSERT INTO nheBl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Xiquinilhui nopa israelitame ni miyac tlanahuatili. “Na, niimoTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","“Nimechilhuía amo xijchihuaca queja quichihuaj nopa tlacame tlen ehuani ipan tlali Egipto campa achtohui initztoyaj. “Niyon amo xijchihuaca queja quichihuaj nopa tlacame tlen itztoque ipan nopa tlali Canaán campa nimechhuicas. Niyon ax inquitoquilise inintlanahuatilhua. ");
INSERT INTO nheBl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","“Monequi inquitoquilise senquistoc tlen quiijtohuaj notlanahuatilhua huan inquichijtinemise nochi tlen na nimechilhuía, pampa na niimoTECO Dios. Huan intla inquineltocase huan inquichihuase senquistoc tlen quiijtohuaj notlanahuatilhua, huajca inquipantise yolistli ipampa nopa miyac tlanahuatili. Na, niimoTECO, nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Axaca hueli cochis ica seyoc tlen iteixmatca tlen san se inieso. Na niimoTECO, nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“Se ichpocatl ax hueli cochis ihuaya itata. Huan se telpocatl ax hueli cochis ihuaya inana, pampa yajaya inana huan ax quinamiqui para cochis ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Amo ximocuili se sihuatl tlen achtohui itztoya ihuaya motata. ");
INSERT INTO nheBl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Amo xicochi ica se moicni o motepotz icni, yonque elis san iichpoca motata, o san iichpoca monana. Ax hueli ticochis ihuaya yonque nopa moicni tlacatqui ipan san se cali mohuaya o tlacatqui sejcoyoc. ");
INSERT INTO nheBl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Amo xicochi ihuaya se moixhui yonque icone moichpoca o motelpoca. Elis queja timoixpanos ica moselti, pampa se moixhui eli queja ta. ");
INSERT INTO nheBl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Amo xicochi ihuaya se ichpocatl tlen motepotz icni, pampa quitlacatilti motepotz nana. Yajaya eli moicni huan iichpoca motata. ");
INSERT INTO nheBl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Amo xicochi ihuaya moahui tlen motata isihua icni, pampa quipiya san se inieso ihuaya motata. ");
INSERT INTO nheBl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Amo xicochi ihuaya moahui tlen monana isihua icni, pampa quipiya san se inieso ihuaya monana. ");
INSERT INTO nheBl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“Amo xiquixpano motío tlen motata itlaca icni para ticochis ihuaya isihua, pampa eli moahui. ");
INSERT INTO nheBl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“Amo xicochi ihuaya moyex, pampa eli motelpoca isihua. ");
INSERT INTO nheBl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Amo xicochi ihuaya isihua motlaca icni pampa queja nopa tiquixpanos motlaca icni. ");
INSERT INTO nheBl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Amo xicochi ihuaya se sihuatl huan nojquiya ihuaya iichpoca. Niyon amo xicochi ihuaya se sihuatl huan teipa ihuaya se iixhui, pampa san se inieso huan niquita tlahuel fiero. ");
INSERT INTO nheBl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“Ax hueli timocuilis se sihuatl huan nojquiya timocuilis iicni, pampa mocualancaitase. Pero intla mosihua miquis, huajca, quena, hueli timocuilis mohuejpol. ");
INSERT INTO nheBl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Amo xicochi ihuaya se sihuatl quema esotemo. ");
INSERT INTO nheBl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Amo xicochi ihuaya mohuampo isihua para ax tiquixpanos. ");
INSERT INTO nheBl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Amo xijmactili niyon se mocone queja se tlacajcahualistli para se teteyotl queja nopa teteyotl Moloc, pampa elis queja innechtelchihuaj na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Se tlacatl ma ax quichihua tlamantli ihuaya seyoc tlacatl queja elisquía isihua, pampa nopa se hueyi tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Niyon se tlacatl ax hueli quichihuas tlamantli ihuaya se tlapiyali pampa nelía tlahuel fiero. Huan se sihuatl nojquiya ax hueli quichihuas tlamantli ihuaya se tlapiyali, pampa se hueyi tlajtlacoli huan ax quinamiqui. ");
INSERT INTO nheBl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Huajca amo xijchihuaca niyon se tlamantli tlen inmechcahuas ax intlapajpactique. Nopa tlacame tlen itztoque ipan nopa tlali campa nimechhuicas, quichijtoque miyac tlamantli huan tlahuel mochijtoque ax tlapajpactique huan yeca niquintojtocas imoixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Quena, nochi nopa tlali mocajtoc ax tlapajpactic ica nopa miyac tlamantli, huan yeca nochi nopa tlacame tlen itztoque nopona niquintlatzacuiltis huan niquintojtocas. ");
INSERT INTO nheBl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Pero monequi inquitlepanitase tlen nimechilhuijtoc huan senquistoc inquichijtinemise notlanahuatilhua. Amo xijchihuaca niyon se tlen nopa fiero tlamantli tlen inijuanti quichihuaj. Ni tlanahuatili monequi nochi inisraelitame inquitlepanitase huan nochi seyoc tlali ehuani tlen itztoque campa imojuanti. ");
INSERT INTO nheBl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Pampa nochi ni tlamantli tlen tlahuel fiero quichijtoque nopa tlacame tlen itztoque ipan nopa tlali campa nimechhuicas. Yeca nopa tlali mocajtoc tlahuel ax tlapajpactic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Amo xijchihuaca nopa tlamantli tlen ax cuali para ax nimechtojtocas queja niquintojtocac nopa tlacame tlen nopona itztoque. ");
INSERT INTO nheBl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Tlen hueli tlacatl tlen quichihuas nopa tlamantli tlen fiero monequi inquiquixtise tlen campa imojuanti para ayoc quema huelis itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Huajca xijpiyaca miyac cuidado para xijneltocatinemica tlen nimechilhuijtoc. Amo ximochihuaca ax tlapajpactique noixtla ica nopa fiero tlamantli tlen quichihuayayaj nopa tlacame tlen ama itztoque campa nimechhuicas. Na niimoTECO Dios.” ");
INSERT INTO nheBl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Xiquinilhui nochi israelitame ni miyac tlanahuatili. “Xiitztoca intlatzejtzeloltique pampa na, niimoTECO Dios, nitlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Sese imojuanti monequi inquitlepanitase imotata huan imonana. “Huan monequi ximosiyajcahuaca ipan nochi nopa tonali para inmosiyajcahuase. Na, niimoTECO Dios, nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Ax quema sampa ximotemachica ipan teteyome huan totiotzitzi. Na, niimoTECO Dios tlen nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Huan quema innechmacase se tlacajcahualistli para ma onca tlayoltlalili ica na niimoTECO, monequi innechmacase queja quinamiqui, pampa intla ax quinamiqui, ax nimechselilis. ");
INSERT INTO nheBl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nopa nacatl tlen nopa tlapiyali tlen innechmacase para nopa tlacajcahualistli monequi inquicuase nopa tonali quema innechmacase o tonili. Pero intla mocahuas nacatl hasta ihuiptlatica, monequi inquitlatise. ");
INSERT INTO nheBl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Huan intla inquicuase se quentzi hasta hualhuiptla, huajca ya nopa elis se tlajtlacoli noixtla huan na ax nimechselilis imotlacajcahualis. ");
INSERT INTO nheBl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Intla aqui quicuas hasta hualhuiptla nopa tlacajcahualistli tlen se nechmacas para ma oncas tlayoltlalili nohuaya, yajaya quihuicas tlajtlacoli noixtla huan quiselis itlatzacuiltilis pampa quichijtoc ax tlapajpactic nopa tlacajcahualistli tlen eltoya tlatzejtzeloltic para na, niimoTECO. Nopa tlacatl monequi inquiquixtise tlen campa imojuanti para ayoc quema itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Quema ajsis nopa tonali para inpixcase ipan imomil, amo xijcuica hasta campa miltlateno, niyon amo xijtemoca tlen mocajtoc, niyon amo xijpejpenaca tlen tepejtoc. ");
INSERT INTO nheBl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Huan san se inquichihuase ica imoxocomecamil. Amo xijtequica hasta inacastla imomil, niyon amo xijtemoca tlen mocajtoc o tepejtoc. Na niimoTECO Dios tlen nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Amo xitlaxtequica. Amo ximocajcayahuaca. Amo ximoistlacahuica se ica seyoc. ");
INSERT INTO nheBl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“Amo xinechtestigojquetzaca na quema inquiijtohuaj inquichihuase se tlamantli huan ya inquimatij ax inquichihuase. Intla queja nopa inquichihuase, huajca inquiijtlacose notoca, na niimoTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Axaca xijtlaijiyohuiltica, niyon amo xitetlaxtequilica. “Intla se tequitiquetl tequiti ipan mochaj, amo xijchiya hasta seyoc tonali para tijmacas itlaxtlahuil. ");
INSERT INTO nheBl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Amo xijtelchihua se tlacatl tlen ax hueli tlacaqui. “Niyon amo xijtlali se tlamantli campa nejnemi se popoyotzi para ax motepotlamis. Monequi xinechimacasica na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Se tlen tequitiquetl monequi tetlajtolsencahuas xitlahuac. Ax ma quichicoicneli tlen teicneltzi, niyon tlen rico o tlen hueyi. Nochi monequi ma quinchihuili san se. ");
INSERT INTO nheBl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Amo xiquijilnamiqui se tlacatl iniixtla sequinoc ichampoyohua quema yajaya ax aqui. “Amo xijteilhui se tlacatl ica se tlamantli tlen ax melahuac pampa tijnequi ma miqui. Na niimoTECO tlen nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Amo xijcocoli seyoc ipan moyolo. “Quema seyoc mitzchihuilijtoc tlen ax monequi, xiquilhui xitlahuac tlen itlajtlacol para yajaya mocualtlalis huan para ax tijhuicas tlajtlacoli nojquiya pampa ax tleno tiquilhui. ");
INSERT INTO nheBl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Ax quema xijcuepili seyoc israelita tlen mitzchihuilijtoc tlen ax cuali, niyon amo ximoyolilhui ajachica tlen mitzchihuilijtoc para más timocualancamacas. Monequi xiquicneli seyoc queja ta moselti timoicnelía. Na niimoTECO tlen nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Monequi xijtlepanitaca notlanahuatilhua. “Amo xijmamalti mohuacax ica seyoc tlamantli tlapiyali. “Ipan momila amo xijtoca ome tlamantli xinachtli. “Niyon amo ximoquenti se yoyomitl tlen tlachijchihuali ica lino icpatl huan ica ichcatl icpatl. ");
INSERT INTO nheBl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Intla se tlacatl tlen hueli quichihuas ihuaya se ichpoca tlatequipanojquetl tlen ya quiijtlantoc seyoc, pero noja iaxca iteco huan aya itztoc majcajtoc, huajca monequi quiselis tlatzacuiltili nopa tlacatl, pero ax para miquis pampa nopa ichpocatl noja eliyaya se tlatequipanojquetl tlen tlacohuali. ");
INSERT INTO nheBl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Huan nopa tlacatl tlen tlajtlacolchijqui monequi quihuicas se oquich borrego campa ipuerta nopa yoyon tiopamitl para quimacas TOTECO queja se tlacajcahualistli pampa quihuica tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Huan ica nopa oquich borrego, nopa totajtzi quiixtzacuas itlajtlacolhua nopa tlacatl, huan na, niimoTECO, nijtlapojpolhuis. ");
INSERT INTO nheBl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Huan quema incalaquise ipan nopa tlali huan inquitocase nochi tlamantli cuahuitl tlen temaca inintlajca, nopa achtohui eyi xihuitl ax inquicuase niyon se itlajca pampa monequi inquiitase nopa cuatlajcayotl para ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Huan ipan nopa najpa xihuitl, nochi nopa cuatlajcayotl elis tlaiyocatlalili para na niimoTECO. Quena, nochi nopa cuatlajcayotl innechmactilise para innechpaquilismacase. ");
INSERT INTO nheBl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pero ipan macuili xihuitl, quena, ya inhuelise inquicuase nopa cuatlajcayotl, huan intla innechneltocase, nopa cuatini noja más temacase inintlaca. ");
INSERT INTO nheBl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Ax hueli inquicuase niyon se tlamantli nacatl ihuaya estli. “Nojquiya ax quema xitetonalitaca, niyon xijcahuilica seyoc inmechtonalitas. Amo xitetlajchihuica, niyon amo xijtlajtlanica seyoc ma quitlajchihui seyoc mopampa ta. ");
INSERT INTO nheBl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“Amo ximoximaca campa imocuajtol, niyon amo xijhuatanica san imotentzo inacastla queja sequinoc quichihuaj para quitlepanitase inintlaixcopincayohua. ");
INSERT INTO nheBl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“Ax quema xijcococa imotlacayo queja inijuanti quichihuaj, niyon amo xijtequica imotlacayo quema inchocaj ica tlen mictoque. Amo xiquixcopinaca tlaixcopincayome ipan imotlacayo ica tinta. Na, niimoTECO, nimechnahuatía. ");
INSERT INTO nheBl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Amo xijchihua para moichpoca ma moichpocapolo pampa ta tijtlacanemilti. Pampa queja nopa inquichihuase tlatelchihuali nopa tlali tlen nimechmacas ica ahuilnencayotl huan tlafiero elis. ");
INSERT INTO nheBl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Xijtlepanitaca nopa tonali tlen nijtlalijtoc para inmosiyajcahuase. Huan xijtlepanitaca noyoyon tiopa. Na niimoTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Ax quema xijtemoca se tlen quincamahuía mijcatzitzi, niyon tlen tetonalitaj. Niyon ax quema xijtemoca se tlamatquetl, niyon se tlen mitzilhuis tlen motonal, pampa inmechchihuilis ax tlapajpactic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Ximoquetzaca quema ajsi se huehuentzi o se nanatzi, huan xijnextilica miyac tlatlepanitacayotl. Quema inquinextilíaj tlatlepanitacayotl se huehuentzi o se nanatzi, intenextilíaj para innechimacasij na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Quema se seyoc tlali ejquetl hualas ipan imotlal para mocahuas imohuaya, amo xijchihuilica tlen ax cuali. ");
INSERT INTO nheBl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Intla se seyoc tlali ejquetl mocahuas imohuaya, monequi inquiitase queja se nopona ejquetl. Quena, monequi xiquicnelica queja inmoicnelíaj pampa nojquiya initztoyaj seyoc tlali ehuani ipan tlali Egipto. Na, niimoTECO Dios, nimechnahuatía. ");
INSERT INTO nheBl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Quema intetlajtolsencahuaj amo xitlacajcayahuaca. Xijchihuaca san tlen xitlahuac. Quema inquiyejyecohuaj se tlali o inquiyejyecohuaj se tlenijqui ica ietica o ica imiyaca, monequi nochi nopa tlayejyecoli elis senquistoc xitlahuac. ");
INSERT INTO nheBl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","San xijtequihuica tlayejyecoli, tetini, barras huan cualitros tlen senquistoc xitlahuac para intlayejyecose. Ax quema xitecajcayahuaca niyon pilquentzi. Na, niimoTECO Dios, tlen nimechquixti ipan tlali Egipto. ");
INSERT INTO nheBl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Huajca xijpiyaca cuidado para inquintlepanitase nochi notlanahuatilhua huan inquichijtinemise senquistoc nochi tlen nimechnahuatía, pampa na, niimoTECO, tlen nimechilhuía.” ");
INSERT INTO nheBl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Xiquinilhui nopa israelitame ni tlanahuatili. “Tlen hueli tlen itztoc imohuaya, yonque se israelita o se seyoc tlali ejquetl, intla temacas icone queja se tlacajcahualistli para nopa teteyotl tlen itoca Moloc, monequi inisraelitame inquitepachose hasta miquis. ");
INSERT INTO nheBl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Na ihuaya nimotlalis huan ayoc nijcahuilis itztos pampa quimacatoc icone nopa totiotzi. Ica ya nopa quichijtoc ax tlapajpactic noyoyon tiopa huan nechpinahualtijtoc na tlen nitlatzejtzeloltic, huan quipinahualtijtoc notoca. ");
INSERT INTO nheBl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Huan intla israelitame ipan nopa tlali tlen nimechmacas ax quichihuilise cuenta quema seyoc temaca icone ica se totiotzi huan ax quinequij quitepachose huan quimictise, ");
INSERT INTO nheBl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","na nojquiya nimotlalis ihuaya tlen ax quichihuili cuenta huan nimotlalis ininhuaya nochi ichampoyohua. Huan niquinquixtis tlen inisraelitame para ayoc quema huelis itztose imohuaya pampa ax quichihuili cuenta tlen nopa tlacatl quichijqui. Ax san nijtlatzacuiltis yajaya tlen temaca icone, pero nojquiya niquintlatzacuiltis nochi tlacame tlen yase queja ahuilnenca sihuame huan quihueyichihuase nopa totiotzi Moloc. Nochi niquinquixtis tlen campa imojuanti para ayoc quema huelise itztose ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Intla tlen hueli tlacatl yas campa se tlen quiijtohua quincamahuía mijcatzitzi o quiijtohua para tetonalita, huajca nechcajtejtoc. Itztoc queja se tlacanenca sihuatl tlen momecatijtoc. Huan na ihuaya nimotlalis huan nijquixtis tlen campa imojuanti para ayoc quema itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Huajca ximoiyocatlalica tlen ni tlamantli huan xiitztoca intlatzejtzeloltique, pampa na niimoTECO Dios tlen nimechnahuatía. ");
INSERT INTO nheBl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Xiquinneltocaca notlanahuatilhua huan xiquinchijtinemica, pampa na, niimoTECO, tlen nimechtlatzejtzelolchihua. ");
INSERT INTO nheBl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Aqui quitelchihuas inana o itata, monequi xijmictica. Quitelchijtoc inana o itata huan tlahuel quihuica tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Intla se tlacatl cochis ihuaya seyoc tlacatl isihua, huajca nopa tlacatl huan nopa sihuatl monequi xiquinmictica. ");
INSERT INTO nheBl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“Intla se tlacatl cochis ihuaya itata isihua, huajca nopa tlacatl quiixpano itata, huan nopa ome, sihuatl huan tlacatl, monequi xiquinmictica pampa tlahuel quihuicaj tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Huan intla se tlacatl cochis ihuaya iyex, huajca nopa ome monequi xiquinmictica pampa tlahuel quiixpanotoque se ininteixmatca. ");
INSERT INTO nheBl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Intla se tlacatl cochis ihuaya seyoc tlacatl huan quichihuilis queja elisquía isihua, huajca nopa ome quichijtoque tlen ax nijnequi niquitas huan monequi xiquinmictica. Quena, miquise pampa tlahuel quihuicaj tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Intla se tlacatl ihuaya itztos se ichpocatl huan nojquiya mocuilis inana nopa ichpocatl, huajca fiero. Nopa eyi monequi xiquinmictica huan xiquintlatica para inquiquixtise nopa hueyi tlajtlacoli tlen campa imojuanti. ");
INSERT INTO nheBl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Intla se tlacatl quichihuas tlen ax quinamiqui ihuaya se tlapiyali, huajca nopa tlacatl huan nopa tlapiyali monequi xiquinmictica. ");
INSERT INTO nheBl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Huan intla se sihuatl quichihuas tlen ax quinamiqui ihuaya se tlapiyali, huajca nopa sihuatl huan nopa tlapiyali monequi xiquinmictica. Miquise pampa tlahuel quihuicaj tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Intla se telpocatl cochis ihuaya se ichpocatl tlen itepotzicni pampa yajaya itata iichpoca o huelis inana iichpoca, huajca nopa ome monequi inquinhuicase iniixtla nochi israelitame huan xiquinquixtica tlamiyacapa tlen campa inisraelitame huan xiquinitaca para mictoque. Pampa intla se tlacatl cochis ihuaya isihua icni eli se tlamantli tlen nelía monequi tlatzacuiltilistli. ");
INSERT INTO nheBl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Intla se tlacatl cochis ihuaya se sihuatl ipan nopa tonali quema esotemo, huajca nopa ome monequi xiquinquixtica tlen campa imojuanti para ayoc quema itztose ica inisraelitame, pampa nopa tlacatl quiixtlapo campa esotemo nopa sihuatl huan nopa sihuatl quinexti ieso. ");
INSERT INTO nheBl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Amo xijchihua tlen ax quinamiqui ihuaya moahui, niyon monana isihua icni, niyon motata isihua icni. Pampa intla se tlacatl ya nopa quichihuas ihuaya se iteixmatca tlen nechca, nochi ome quihuicase tlajtlacoli huan quiselise inintlatzacuiltilis. ");
INSERT INTO nheBl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Intla se cochis ihuaya itío isihua, quiixpanotoc itío. Huan nopa ome quihuicase tlajtlacoli noixtla. Quema miquise, ax quipixtehuase niyon se inincone. ");
INSERT INTO nheBl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“Intla se tlacatl quicuilis isihua itlaca icni, huajca quichihua se hueyi tlajtlacoli huan quiixpano itlaca icni huan ax quipixtehuase niyon se inincone. ");
INSERT INTO nheBl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Monequi xijneltocaca huan xijchijtinemica nochi tlen quiijtohua notlanahuatilhua para ax inmechisotlas nopa tlali campa nimechhuica para initztotij. ");
INSERT INTO nheBl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Amo xijchihuaca queja nopa tlacame tlen ama itztoque nopona ipan nopa tlali huan monequi niquintojtocas imoixtla. Quena, inijuanti quichijtinentoque nochi ni fiero tlamantli, huan yeca ax nijnequi niquinitas. ");
INSERT INTO nheBl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Huajca na nijcajtoc notlajtol para inmoaxcatise inintlal pampa na nimechmactilía para imoaxca. Nopa tlali elis se cuali tlali tlen temacas itlajca hasta mocahua. “Na, niimoTECO Dios, tlen nimechiyocatlalijtoc tlen nochi sequinoc tlacame. ");
INSERT INTO nheBl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Huan yeca monequi inquiniyocatlalise nopa tlapiyalime tlen niquinita para tlapajpactique para inquincuase huan inijuanti tlen ax tlapajpactique huan ax cuali para inquincuase. Amo ximochihuaca ax intlapajpactique noixtla ica niyon se tlapiyali o tototl tlen niquijtojtoc ax tlapajpactic, o ica niyon se tlamantli tlen mohuahuatatza tlalchi. Pampa na nimechiyocatlalijtoc tlen nopa tlamantli tlen ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Monequi xiitztoca intlatzejtzeloltique noixtla, pampa na tlen niimoTECO nitlatzejtzeloltic. Huan nimechiyocatlalijtoc tlen nopa sequinoc tlacame para xielica innoaxcahua. ");
INSERT INTO nheBl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Tlen hueli tlacatl o sihuatl tlen quiijtohua quincamahuía inintonalhua mijcatzitzi o quicamahuía se tlen tetonalita, monequi xijmictica ica tetl. Inijuanti quihuicase tlajtlacoli ininseltitzi ipampa ininmiquilis.” ");
INSERT INTO nheBl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Huan TOTECO quiilhui Moisés: “Xiquinilhui nopa totajtzitzi tlen itelpocahua Aarón, para ma ax quiitzquica tlen hueli mijcatzi pampa quinchihuas ax tlapajpactique noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Huelis quiitzquise imijcatzi se ininteixmatca tlen nelía nechca queja ininnana, inintata, inioquichpil, ininsihuapil, inintlaca icni, ");
INSERT INTO nheBl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o se ininsihua icni tlen noja itztoc ininmaco para quimocuitlahuise pampa aya monamictía. Ica inijuanti quena, hueli quiitzquise ininmijcatzitzi pampa ininteixmatcahua tlen nelnechca. ");
INSERT INTO nheBl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Pero ax hueli mochihuase ax tlapajpactique ica se mijcatzi tlen san mosejcotilijtoya ihuaya seyoc tlacatl tlen se ininteixmatca queja sequinoc tlacame monequi quichihuase quema onca se mijcatzi. ");
INSERT INTO nheBl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Nopa totajtzitzi ax hueli quinextise intla mocuesohuaj quema miqui se tlacatl. Ax quinamiqui mohuatanise inacastla inintentzo, niyon quitequise inintzoncal nechca inintzonteco, niyon ax quinamiqui quitequise inincuetlaxo queja seyoc tlali ehuani quichihuaj. ");
INSERT INTO nheBl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Monequi elise senquistoc tlatzejtzeloltique para na, niimoTeco Dios. Pampa inijuanti tlen nechmacase nopa tlacajcahualistli tlatlatili huan nopa pantzi tlen noaxca na, niimoTECO. Yeca monequi totajtzitzi elise tlatzejtzeloltique huan ax quiahuilmatise na notoca. ");
INSERT INTO nheBl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Se totajtzi ax hueli mocuilis se sihuatl tlen ahuilnentoc, niyon ax hueli mocuilis se sihuatl tlen moamaxolejtoc ihuaya ihuehue, pampa se totajtzi monequi mocahuas tlatzejtzeloltic para na, niiTeco Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Se totajtzi monequi mocahuas tlaiyocatlalili pampa yajaya tlen nechmacas nopa tlacajcahualistli noixtla na, niimoTeco Dios. Huajca ma mocahuaca tlatzejtzeloltique nopa totajtzitzi, pampa na, niimoTECO, nitlatzejtzeloltic, huan na tlen nimechtlatzejtzelolchihua. ");
INSERT INTO nheBl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Intla se totajtzi iichpoca mochihuas se ahuilnenca sihuatl, moixpanotos huan quiixpanotos itata. Huan monequi inquitlatise hasta miquis. ");
INSERT INTO nheBl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Huan nopa hueyi totajtzi tlen ticajaltijtoque itzonteco ica nopa aceite para quinyacanas nochi sequinoc totajtzitzi, huan tlen tlaiyocatlalili para moquentis nopa yoyomitl tlen más tlatzejtzeloltic, ax hueli tenextilis para tlahuel mocuesohua quema quiajsis se cuesoli. Ax hueli quicahuas itzoncal ma elis fiero, niyon ax huelis quitzayanas iyoyo queja quichihuaj sequinoc ica cuesoli. ");
INSERT INTO nheBl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Huan nopa hueyi totajtzi ax hueli monechcahuis campa eltoc se mijcatzi itlacayo, yonque eli inana o itata. Ax hueli mochihuas ax tlapajpactic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Huan quema quipiya tequitl ipan nopa yoyon tiopamitl, ax hueli quisas pampa quipiya se cuesoli pampa quichihuas ax tlapajpactic nopa yoyon tiopamitl. Tlaajaltili nopa hueyi totajtzi para ma eli tlatzejtzeloltic huan tlaiyocatlalili san para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Nopa hueyi totajtzi monequi mocuilis para isihua se ichpocatl tlen aya quiixmati se tlacatl. ");
INSERT INTO nheBl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ax hueli mocuilis se sihuatl tlen cahuali, o tlen quicajtoc ihuehue, o tlen ahuilnentoc. Monequi mocuilis se ichpocatl tlen nojquiya huala ipan nopa hueyi familia tlen totajtzitzi. Monequi elis se tlen nelía cuali ichpocatl. ");
INSERT INTO nheBl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Pampa monequi se totajtzi quitlepanitas TOTECO itlanahuatil para iconehua ma elica tlapajpactique noixtla. Na niimoTECO tlen nimechtlatzejtzelolchihua.” ");
INSERT INTO nheBl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Xiquilhui Aarón ni tlanahuatili. Ama huan teipa niyon se moixhui tlen quipiyas se tlenijqui tlen ax cuali ipan itlacayo ax huelis mochihuas totajtzi, niyon ax hueli monechcahuis para nechmacas nopa pantzi tlen eltoc para na, niimoTeco Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Pampa niyon se tlacatl tlen ax ajsitoc itlacayo ax hueli monechcahuis para quichihuas nopa tequitl. Huajca intla se tlacatl eli popoyotzi, o metzcototic, o lipintic itlacayo, o intla quipiya miyac ixocpilhua o imacpilhua, ");
INSERT INTO nheBl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","o intla quilecuenijtoc ima o iicxi, ");
INSERT INTO nheBl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","o intla cuitlapantomotztic, o tlahuel ax huejcapantic, o ax cuali se iixtiyol, o sahuati, o cocoti, o intla quicocojtoc itequis, ax hueli tequitis queja se totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Huajca yonque se itztoc se iixhui nopa totajtzi Aarón, ax hueli nechmacas, niimoTECO, se tlacajcahualistli ipan tlitl intla ax ajsitoc itlacayo. Niyon ax hueli nechmacas nopa pantzi tlen noaxca na, niimoTeco Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Pero, quena, ininconehua totajtzitzi tlen ax ajsitoc inintlacayo hueli quicuase nopa tlacualistli tlen huala tlen nopa tlacajcahualistli, yonque se tlacualistli tlen tlatzejtzeloltic, o tlen tlahuel tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","San ax hueli calaquis para quinechcahuis nopa cortina pampa ax ajsitoc itlacayo, niyon ax hueli monechcahuis campa nopa tlaixpamitl. Melahuac ax hueli quichihuas nopa tequitl pampa quichihuas notiopa ax tlapajpactic. Na, niimoTECO, tlen niquiniyocatlalijtoc nopa totajtzitzi.” ");
INSERT INTO nheBl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Huajca Moisés quiilhui Aarón nochi ya ni huan nojquiya quinilhui itelpocahua huan nochi nopa israelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Xiquinilhui Aarón huan itelpocahua ma momocuitlahuica miyac para ax ma quichihuaca ax tlapajpactic se tlacajcahualistli tlen tlatzejtzeloltic tlen nechmacaj israelitame. Ax hueli quiahuilmatise notoca na imoTECO Dios huan notlacajcahualis. ");
INSERT INTO nheBl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Intla se totajtzi tlen ax tlapajpactic quinechcahuis se tlapiyali, o seyoc tlamantli tlacajcahualistli tlen tlatzejtzeloltic tlen se israelita quihualicatoc para nechmacas, huajca monequi xijquixti nopa totajtzi para ayoc quema huelis itztos noixtla. Ni tlanahuatili elis para totajtzitzi ama huan nojquiya para moteipa ixhuihua tlen mochihuase totajtzitzi teipa. Na niimoTECO nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Aarón, niyon se tlen moixhuihua tlen quipiya nopa tlacayo palanca cocolistli, o tlen atemo ipan inintlacayo ax hueli quicuas nopa tlacajcahualistli tlen tlatzejtzeloltic. Pero quema ya mochicajtoc huajca, quena, huelis quicuas. “Nojquiya elis ax tlapajpactic tlen hueli totajtzi tlen quinechcahuis se mijcatzi, o temotos ixinajcho, ");
INSERT INTO nheBl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o quiitzquis se tlapiyali tlen mohuahuatatza tlalchi, o quiitzquis se tlacatl tlen ax tlapajpactic. ");
INSERT INTO nheBl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Aqui hueli totajtzi tlen ax tlapajpactic ipampa tlen hueli tlamantli mocahuas ax tlapajpactic noixtla, huan ax hueli quicuas nopa tlacualistli tlatzejtzeloltic tlen huala tlen tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Pero quema tlayohuas huan maltis, huajca motlapajpacchijtos. Huan huajca, quena, hueli quicuas nopa tlacajcahualistli tlen tlatzejtzeloltic pampa ya nopa itlacualis. ");
INSERT INTO nheBl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Se totajtzi ax hueli quicuas inacayo se tlapiyali tlen mijqui ica iselti, o tlen quimictijque sequinoc tlapiyalime, pampa intla quicuas, huajca mochihuas ax tlapajpactic noixtla. Na niimoTECO nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Huajca xiquinilhui nopa totajtzitzi ma quitoquilica nochi ni tlanahuatili ica miyac cuidado para ax quiixpanose huan ax miquise ipampa inintlajtlacol. Na niimoTECO tlen niquintlatzejtzelolchihua. ");
INSERT INTO nheBl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Niyon se tlacatl tlen ax totajtzi ax huelis quicuas tlen nopa tlacajcahualistli tlen tlatzejtzeloltic. “Niyon ax hueli quicuas se tlacatl tlen san quipaxalohua se totajtzi, o san quipalehuía se totajtzi se ome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","“Pero intla nopa totajtzi quicohuas se tequitiquetl ica itomi, huajca nopa tequitiquetl, quena, hueli quicuas nopa tlacajcahualistli tlen tlatzejtzeloltic. Huan intla nopa tlatequipanojquetl quinpiyas iconehua, huajca inijuanti nojquiya huelise quicuase nopa tlacajcahualistli tlen tlatzejtzeloltic tlen nopa totajtzi quinmacas. ");
INSERT INTO nheBl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","“Huan intla iichpoca se totajtzi monamictis ihuaya se tlacatl tlen ax totajtzi, huajca nopa ichpocatl ayoc huelis quicuas nopa tlacajcahualistli tlen tlatzejtzeloltic. ");
INSERT INTO nheBl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pero intla miquis ihuehue o quicahuas ihuehue, huan ax quinpiyas iconehua, huan sampa mocuepas ipan ichaj itata tlen eli se totajtzi, huajca nopa ichpocatl sampa huelis quicuas itata itlacualis queja quema eliyaya se pilsihuapiltzi. Pero se tlacatl tlen ax quipiya tleno ica nopa totajtzi ax hueli quicuas nopa tlacualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Intla se acajya mocuapolos huan quicuas nopa tlacajcahualistli tlen tlatzejtzeloltic, huajca monequi quicuepas san se imiyaca queja tlen quicuajqui, huan noja quitlalis seyoc 20 por ciento. Huan quihualicas huan quimacas nopa totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Huajca nopa totajtzitzi monequi ma quipiyase cuidado ica ajqueya inijuanti quincahuilise ma quicuaca nopa tlacajcahualistli para ax quichihuase ax tlapajpactic nopa tlacajcahualistli tlen tlatzejtzeloltic tlen nopa israelitame nechiyocatlalilijtoque na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Pampa intla se quiixpanos ni tlanahuatili, quihuicas tlajtlacoli huan monequi quiselis itlatzacuiltilis. Na niimoTECO tlen nijtlatzejtzelolchihua nopa tlacajcahualistli.” ");
INSERT INTO nheBl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Xiquilhui Aarón, huan iconehua, huan nochi sequinoc israelitame ni miyac tlanahuatili. Quema quinequis quimacas tlacajcahualistli tlen hueli israelita o tlen hueli seyoc tlali ejquetl tlen itztoc campa imojuanti pampa tlatestigojquetztoc tlen quichihuas para na, o pampa san ica ipaquilis quinequi nechmacas se tlacajcahualistli, ");
INSERT INTO nheBl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","huajca para nijselis monequi elis se becerro, se oquich borrego, o se oquich chivo tlen senquistoc cuali. ");
INSERT INTO nheBl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ax hueli nechmacas niyon se tlapiyali tlen quipiya ipan itlacayo se tlamantli tlen ax cuali, pampa ax nijselis. ");
INSERT INTO nheBl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Intla se quinequis nechmacas, niimoTECO, se tlacajcahualistli para ma onca tlayoltlalili nohuaya pampa tlatestigojquetztoc, o pampa san ica ipaquilis quinequi nechmacas se tlacajcahualistli, huajca monequi elis se toro, o se borrego, tlen ax tleno tlen ax cuali quipiya itlacayo para nijselilis. ");
INSERT INTO nheBl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Amo xinechmacaca na, niimoTECO, se tlapiyali tlen ax tlachiya, o mometzpostectoc, o cotontoc ima, o cocoti, o sahuati, o quipiya seyoc tlamantli cocolistli. Se tlapiyali queja nopa ax quema xijtlalica ipan notlaixpa, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Pero intla inquipiyaj se toro, o se pilborregojtzi tlen quipiya miyac ixocpilhua o quentzi, o quipiya cototzi o huehueyac se imetz, huajca quena, huelis innechmacase queja se tlacajcahualistli tlen san innechmacaj ica imopaquilis. Pero ni tlamantli tlapiyalime ax huelis innechmacase para se tlacajcahualistli quema monequi tlacajcahualistli pampa intlatestigojquetztoque tlen inquichihuase. ");
INSERT INTO nheBl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Nojquiya san se elis ni tlanahuatili quema inajsise ipan imotlal. Para tlacajcahualistli, monequi se tlapiyali tlen senquistoc cuali. Amo quema xinechmacaca se tlapiyali tlen cocojtoc itequis, o motejtzontoc, o quihuahuatzojtoc o quiquixtilijtoque itequis. ");
INSERT INTO nheBl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Niyon amo xiquincahuilica nopa seyoc tlali ehuani ma quitencahuaca se tlacajcahualistli queja nopa para elis tlacualistli para na, niimoTeco Dios. Intla quihualicase se tlapiyali tlen ax ajsitoc itlacayo huan quinequise nechmacase na, niimoTeco Dios, ax niquinselilis pampa ax tlapajpactic. Ax cuali nochi itlacayo.” ");
INSERT INTO nheBl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Quema tlacatis se becerro, se pilborregojtzi, o se piloquich chivojtzi monequi mocahuas ihuaya inana para chicome tonali. Pero quema quipiyas chicueyi tonali, huelis inquitequihuise para se tlacajcahualistli tlen inquitlatise para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","“Ipan san se tonali ax hueli inquimictise se huacax ihuaya icone, o se sihua borrego ihuaya icone. ");
INSERT INTO nheBl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Quema innechmacase se tlacajcahualistli para innechtlascamatilise, monequi inquichihuase queja quinamiqui para nijselis. ");
INSERT INTO nheBl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Monequi inquicuase nopa tlapiyali inacayo ipan nopa tonali quema innechmacase. Ax hueli inquicahuase se quentzi para inquicuase hasta seyoc tonal. Na niimoTECO tlen nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Xijtlepanitaca notlanahuatil. Quena, xijtoquilijtinemica senquistoc tlen quiijtohua pampa na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","“Amo xijtequihuica notoca queja eliyaya tlen hueli tocayotl pampa nitlatzejtzeloltic. Na niiyoca. Huan monequi nochi israelitame ma nechiyocatlalica huan ma nechixmatica para niitztoc niiyoca, pampa nitlatzejtzeloltic. Huan na niimoTECO tlen nimechtlatzejtzelolchihua. ");
INSERT INTO nheBl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Na tlen nimechmaquixti ipan tlali Egipto para nielis niimoTECO huan niimoDios.” ");
INSERT INTO nheBl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Xiquinilhuiti nopa israelitame ni miyac tlanahuatili. Ya ni nopa tonali tlen monequi inquiiyocacahuase para na, niimoTECO para inquichihuase ilhuitl huan nechhueyimatise. Xiquintocajtlalica tonali para tlanechicoli tlen tlatzejtzeloltique. Huan ipan ni tonali nochi israelitame ma mosentilica huan ma nechhueyitlalica. Huan ni nopa tonali: ");
INSERT INTO nheBl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Sesen samano para chicuase tonali intequitise, pero ipan tonali chicome, ax inquichihuase niyon se tequitl. Senquistoc inmosiyajcahuase ipan nopa chicompa tonali. Elis se tonali tlatzejtzeloltic para inmosentilise huan innechhueyichihuase. Quej ni inquichihuase ipan sesen samano. Nopa chicompa tonali elis tlatzejtzeloltic huan tlaiyocatlalili para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Huan ya ni nochi nopa tonali para inilhuichihuase ipan sesen xihuitl huan nopa tonali para inquipiyase nopa tlasentililistli tlen tlatzejtzeloltic para innechhueyichihuase na, niimoTECO: ");
INSERT INTO nheBl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Nopa ilhuitl tlen Pascua monequi xijchihuaca ipan 14 itequi nopa achtohui metztli ipan imoisraelita xihui 23:5 Quemantzi ni tonal huetzis ipan itlamiya marzo huan quemantzi ipan ipejya abril ipan tocalendario tlen ama., huan pehuas quema temo tonati ica tiotlac. ");
INSERT INTO nheBl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“Ipan ne seyoc tonal, inpehuase inquichihuase nopa ilhuitl tlen pantzi tlen ax quipiya tlasonejcayotl. Para chicome tonali san hueli inquicuase pantzi tlen ax quipiya tlasonejcayotl. ");
INSERT INTO nheBl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ipan nopa achtohui tonali tlen nopa chicome tonali, inmosentilise ipan se tlasentilistli tlatzejtzeloltic, huan ipan nopa tonali ax inquichihuase niyon se tequitl. ");
INSERT INTO nheBl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Huan ipan nochi nopa chicome tonali monequi inquitlatise tlacajcahualistli para na. Huan ipan nopa tonal chicome nojquiya inquipiyase se tlasentilistli tlatzejtzeloltic huan ax intequitise.” ");
INSERT INTO nheBl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Xiquinilhui israelitame ni miyac tlanahuatili. Quema ya inajsitose ipan nopa tlali tlen nimechmacas huan ya inquipixcatose cebada, monequi inquihuicase campa nopa totajtzi nopa achtohui tlatequili tlen inquipixcase. ");
INSERT INTO nheBl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","inquihuicase ipan ne seyoc tonali quema ya panoc nopa tonal quema inmosiyajcajque. Huan nopa totajtzi quihuisos noixtla niimoTECO, huan na nijselis queja se tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ipan nopa tonal nojquiya innechmacase se pilborregojtzi queja se tlacajcahualistli tlatlatili. Monequi nopa pilborregojtzi quipiyas san se xihuitl huan ax quipiyas ipan itlacayo niyon se tlamantli tlen ax cuali. ");
INSERT INTO nheBl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Huan ihuaya ni pilborregojtzi monequi innechmacase se tlacajcahualistli tlen elis nahui kilos huan tlajco tlen harina tlen tlamaneloli ica aceite. Monequi inquitlatise noixtla huan nelía nechpactis. Nojquiya ihuaya monequi innechmacase se litro xocomeca atl queja se tlacajcahualistli tlen inquitoyahuase noixtla. ");
INSERT INTO nheBl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Huan quema aya inquihuicaj ni tlacajcahualistli, ax huelis inquicuase niyon pilquentzi nopa cebada ipan imomil. Ax hueli inquimacuise iyol, niyon inquicacatzchihuase iyol, niyon ax hueli inquichihuase pantzi. Ya ni elis se tlanahuatili tlen monequi inquitlepanitase para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Huajca nopa achtohui tonal inmosiyajcahuase huan ne seyoc tonal inquihualicase nopa tlatequili yancuic huan teipa xipehuaca xijpohuaca chicome samanos. ");
INSERT INTO nheBl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","O huelis inquipohuase 50 tonali o chicome sábados tlen ipan inmosiyajcahuaj, huan huajca inquihuicase seyoc tlacajcahualistli tlen quisa tlen cebada para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Inquihualicase ome pantzi tlen imochajchaj para se tlacajcahualistli tlen inquihuisose noixtla, niimoTECO. Nopa pantzi monequi inquicualtlalise ica se nahui kilos tlen harina ica tlasonejcayotl. Ya ni elis se tlacajcahualistli tlen nopa tlayacanca pixquistli. ");
INSERT INTO nheBl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Huan ica nopa pantzi nojquiya innechmacase chicome pilborregojtzitzi tlen sanoc quipiyaj sese xihuitl tlen ax tleno tlen ax cuali quipiyaj. Nojquiya xinechmacaca se becerro huan ome oquich borregojme huan nochi elise tlacajcahualistli tlatlatili para na, niimoTECO. Huan nojquiya xinechmacaca nopa tlacajcahualistli tlen harina huan nopa tlacajcahualistli tlen tlatoyahuali noixtla tlen monequi innechmacase ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","“Huan nojquiya innechmacase se oquich chivo para se tlacajcahualistli ipampa tlajtlacoli, huan innechmacase ome pilborregojtzitzi queja se tlacajcahualistli para ma onca tlayoltlalili nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Huan nopa totajtzitzi quinhuisose nopa ome pilborregojtzitzi noixtla, niimoTECO. Nojquiya quihuisose nopa ome pantzi tlen nopa tlayacapan pixquistli. Nochi ni tlacajcahualistli elis tlaiyocatlalili para na, niimoTECO, huan monequi inquinmactilise nopa totajtzitzi para ma eli inintlacualis. ");
INSERT INTO nheBl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","“Huan ipan san se nopa tonal inteyolmelahuase para oncas se tlasentilistli tlen tlatzejtzeloltic para innechhueyichihuase. Ax huelis inquichihuase niyon se tequitl ipan nopa tonali. Ya ni elis se tlanahuatili tlen monequi nochi inisraelitame huan imoteipa ixhuihua inquitlepanitase para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Huan quema inpixcase ipan imomila ipan nopa tlali, amo xipixcaca hasta campa inacastla nopa mili, niyon amo xijpejpenaca tlen tepejtoc tlalchi. Ya nopa xijcahuaca para ma quipejpenaca tlen teicneltzitzi huan tlen seyoc tlali ehuani. Na niimoTECO Dios tlen nimechilhuía.” ");
INSERT INTO nheBl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Xiquinilhui israelitame ni miyac tlanahuatili. Nopa achtohui tonal ipan nopa chicompa metztli ipan imoisraelita calendario 23:24 Quemantzi ni tonal huetzi ipan itlamiya septiembre huan quemantzi ipan ipejya octubre ipan tocalendario tlen ama. elis tlatzejtzeloltic. Monequi inquiilnamiquise queja se tonal para inmosiyajcahuase. Pero monequi inmosentilise ipan se tlasentilistli tlen tlatzejtzeloltic para innechhueyimatise. Huan inquinpitzase tlapitzali para intenotzase ipan ni ilhuitl tlen tlapitzali. ");
INSERT INTO nheBl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Huan ipan nopa tonal ax tleno tlen tequitl inquichihuase, san innechmacase tlacajcahualistli ipan tlitl.” ");
INSERT INTO nheBl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Huan ipan nopa majtlacpa tonal ipan nopa chicompa metztli inquichihuase nopa Tonal para Quiixtzacuas Tetlajtlacolhua. Ipan ni tonal inmosentilise ipan se tlasentililistli tlen tlatzejtzeloltic para innechhueyimatise. Huan monequi inmosahuase, huan inmoicnonequise ipampa imotlajtlacolhua. Huan inquitencahuase se tlacajcahualistli ipan tlitl noixtla, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ipan nopa tonal ax inquichihuase niyon se tequitl, pampa elis nopa Tonal Para Quiixtzacuas Tetlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Tlen hueli tlacatl tlen ax mosahuas huan ax moicnonequis ipampa itlajtlacolhua ipan nopa tonal, monequi xijquixtica tlen campa imojuanti para ayoc quema itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Huan tlen hueli tlen quichihuas tlen hueli tequitl ipan nopa tonal, na nijtzontlamiltis para ayoc itztos ica inisraelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","“Quena, ax hueli inquichihuase niyon se tequitl. Ni tlanahuatili monequi inquitlepanitase imojuanti huan imoteipa ixhuihua para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Quena, ya ni elis se tonal para inmosiyajcahuase, huan monequi inmosahuase huan inmoicnonequise noixtla ipampa imotlajtlacolhua. Ni Tonal Para Quiixtzacuas Tetlajtlacolhua pehuas ica tiotlac ipan nopa chicnajpa tonal ipan nopa metztli huan huejcahuas hasta ne seyoc tonal ica tiotlac.” ");
INSERT INTO nheBl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Xiquinilhui israelitame ni tlanahuatili. Ipan 15 itequi nopa chicompa metztli ipan imocalendario, inquipehualtise para inquiilnamiquise nopa ilhuitl quema inquichihuase pilxajcaltzitzi. Huan inilhuichihuase noixtla, niimoTECO, para chicome tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ipan nopa achtohui tonal tlen nopa chicome tonali inmosentilise ipan se tlasentilistli tlen tlatzejtzeloltic para innechhueyichihuase. Ipan nopa tonal, ax hueli inquichihuase niyon se tlamantli tequitl. ");
INSERT INTO nheBl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Huan ipan nochi nopa chicome tonali, inquitlatise tlacajcahualistli para na, niimoTECO. Huan ipan nopa chicueyi tonal inmosentilise ipan seyoc tlasentilistli tlen tlatzejtzeloltic para innechhueyichihuase. Ya ni itlamiya nopa tlasentililistli tlen ni hueyi ilhuitl. Ipan nopa tonal nojquiya axaca hueli quichihuas niyon se tequitl. ");
INSERT INTO nheBl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Huajca nica nimechilhuijtoc nopa tonali ipan se xihuitl tlen nijtlalijtoc para inmosentilise huan inilhuichihuase para na, niimoTECO. Huan nojquiya ipan ni tonali inquintlatise miyac tlacajcahualistli para na. Nojquiya inquitencahuase tlacajcahualistli ipan tlitl para na. Innechmacase tlacajcahualistli tlatlatili, tlacajcahualistli tlen harina, huan tlacajcahualistli tlen tlapiyalime tlen inquinmictijtoque huan tlacajcahualistli tlen inquitoyahuase noixtla. Sesen tlacajcahualistli innechmacase ipan nopa tonali quema quinamiqui. ");
INSERT INTO nheBl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Nochi ni tlacajcahualistli elis iyoca tlen nopa tlacajcahualistli tlen monequi innechmacase ipan nopa tonal para inmosiyajcahuase ipan sesen samano. Nojquiya nochi ya ni eltoc iyoca tlen nopa tlacajcahualistli tlen innechmactilijtihualahuij, o nopa tlacajcahualistli tlen innechmacase ica imoseltitzitzi quema intlatestigojquetzase ica se tlenijqui tlen inquichihuase, o se tlacajcahualistli tlen inquitencahuase noixtla pampa san ipan imoyolo quisa para inquichihuase. ");
INSERT INTO nheBl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Ipan 15 itequi nopa chicompa metztli, quema ya inpixcaque, inquiilnamiquise ni ilhuitl noixtla, niimoTECO. Ni ilhuitl quema inquichihuase pilxajcaltzitzi inquichihuase para chicome tonali. Huan ipan nopa achtohui tonali huan ipan nopa chicueyi tonali, monequi inmosiyajcahuase. ");
INSERT INTO nheBl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ipan iachtohui tonal ni ilhuitl inquicuise imacuayo cuatini tlen yejyectzitzi huan tlen quipiyaj itlajca. Inquicuise imacuayo apach cuatini huan ininmacuayo cuatini tlen quipiyaj ininxihuiyo huan moscaltíaj campa atemitl. Huan ica ya nopa inquichihuase pilxajcaltzitzi para ipan initztose para chicome tonali huan inpaquise noixtla na, niimoTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Sesen xihuitl inquichihuase ni ilhuitl para chicome tonali para na. Ya ni eli se tlanahuatili tlen monequi inquitlepanitase nochi inisraelitame tlen ama initztoque huan nochi tlen teipa tlacatise. ");
INSERT INTO nheBl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ipan nopa chicome tonali nochi initztose ipan pilxajcaltzitzi. ");
INSERT INTO nheBl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ica ni ilhuitl, inquiilnamiquise quema nimechquixti ipan tlali Egipto huan nimechchijqui initztose ipan pilxajcaltzitzi. Na niimoTECO Dios tlen nimechilhuía.” ");
INSERT INTO nheBl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Huajca Moisés quinyolmelajqui nopa israelitame tlen nochi nopa ilhuime tlen TOTECO quiixtlalijtoya para tiquilnamiquise. ");
INSERT INTO nheBl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Xiquinnahuati israelitame ma quihualicaca aceite tzalantic para tlahuili ipan tiopamitl. Nopa aceite monequi hualas tlen olivas tlen tlatejtepacholi. Ica nopa cuali aceite, nopa tlahuili ax quema sehuise. ");
INSERT INTO nheBl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","4","Ma quinmocuitlahui miyac nopa tlahuili ipan nopa tlahuil quetzali tlen senquistoc oro. Quena, nopa tlahuili iixmelac nopa cortina tlen quitzacua campa nocaxa monequi tlatlatose nochipa noixtla, niimoTECO. Huan elis Aarón itequi para quinpajpacas huan quintequilis aceite nopa tlahuili ijnaloc huan tiotlac. Huan Aarón iixhuihua monequi quitlepanitase ni tlanahuatili para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","6","“Ipan sesen samano ipan nopa tonali para inmosiyajcahuase, nopa totajtzi monequi quitlalis 12 pantzi ipan nopa mesa tlen oro tlen eltoc noixtla, niimoTECO. Sesen tlen nopa pantzi monequi quichihuase ica nahui kilos huan tlajco tlen harina tlen tlahuel cuechtic. Huan quintecpanas ica ome tlatecpichtli. Sesen tlatecpichtli quipiyas chicuase pantzi. ");
INSERT INTO nheBl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Huan ipan sesen pamitl tlen nopa pantzi quitlalis copali tlen nelía cuali. Ni copali teipa elis se tlacajcahualistli tlen quitlatis ipan tlaixpamitl para nechmacas, na niimoTECO. Huan nopa pilquentzi copali tlen quitlatis quinextis para nechmaca senquistoc nochi nopa pantzi. ");
INSERT INTO nheBl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Huan sesen samano ipan nopa tonali para inmosiyajcahuase, nopa totajtzi monequi quitlalis nopa pantzi noixtla para se tlanextilijcayotl tlen nopa tlajtoli tlen nijchijtoc ininhuaya nochi israelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Huan nopa pantzi elis para Aarón huan iconehua ma quicuaca, pero monequi quicuase campa tlatzejtzeloltic. Quena, nopona ma quicuaca pampa nopa pantzi eltoc tlen más tlatzejtzeloltic tlen nochi tlamantli tlacajcahualistli tlen nechmacatoque ipan tlitl. Huan na, niimoTECO, niquinmaca ma quicuaca nopa totajtzitzi huan ininconehua para nochipa.” ");
INSERT INTO nheBl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Itztoya se telpocatl tlen inana eliyaya se israelita sihuatl, pero itata eliyaya se tlali Egipto ejquetl. Huan se tonal nopa telpocatl mocualani ihuaya se israelita tlacatl nopona campa nochi mochijtoyaj. ");
INSERT INTO nheBl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Huan quema motehuiyayaj, nopa telpocatl quitelchijqui TOTECO. Huan sequinoc quihuicaque iixtla Moisés para ma quitlajtolsencahua. Inana nopa telpocatl eliyaya Selomit tlen eliyaya iichpoca Dibri huan hualayaya ipan nopa hueyi familia Dan. ");
INSERT INTO nheBl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Huan quitzajque nopa telpocatl huan quichixque para TOTECO ma quiilhui Moisés tlaque tlatzacuiltili monequi quiselis. ");
INSERT INTO nheBl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Xijquixti nopa telpocatl tlen nechtelchijqui huejca tlen campa inmochijtoque. Huan ma hualaca nochi tlen quicajque quema nechtelchijqui, huan ma quitlalica ininma ipan itzonteco. Huan teipa nochi israelitame ma quimaquilica ica tetl hasta quimictise. ");
INSERT INTO nheBl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Huan xiquinilhui israelitame intla acajya nechtelchihuas na, niimoTECO, o quitelchihuas notoca, nojquiya quiselis nopa tlatzacuiltili. ");
INSERT INTO nheBl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Quena, aqui nechtelchihuas na, niimoTECO, monequi miquis, huan monequi nochi israelitame quitepachose. Ni tlanahuatili elis san se para israelitame huan para seyoc tlali ehuani. Intla se nechtelchihuas monequi inquimictise. ");
INSERT INTO nheBl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Nojquiya intla se tlacatl quimictis seyoc, nopa tlacatl tlen temicti monequi nojquiya xijmictica. ");
INSERT INTO nheBl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","“Tlen quimictis se tlapiyali tlen seyoc iaxca, monequi quicuepilis seyoc tlapiyali tlen san se. ");
INSERT INTO nheBl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Intla se acajya quicocos seyoc, monequi nojquiya san se inquicocose. ");
INSERT INTO nheBl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Intla se acajya quipostequilis seyoc iomiyo, huajca nojquiya monequi inquipostequilise iomiyo. O intla se acajya quiixtiyolquixtis seyoc, huajca nojquiya monequi inquiixtiyolquixtise. Huan intla se acajya tetlancochtepehuas, huajca nojquiya monequi inquitlancochtepehuase. Quena, queja se acajya quichihuilijtoc seyoc, monequi nojquiya inquichihuilise. ");
INSERT INTO nheBl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","“Tlen quimictis seyoc itlapiyal, monequi quicuepas seyoc tlapiyali tlen san se. Pero intla aqui quimictis seyoc tlacatl, monequi nojquiya xijmictica. ");
INSERT INTO nheBl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“Onca san se ni tlanahuatili para nochi tlacame, yonque israelitame o seyoc tlali ehuani. Na, niimoTECO Dios, tlen nimechnahuatía.” ");
INSERT INTO nheBl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Huajca teipa Moisés quincamahui israelitame. Huan quihuicaque nopa telpocatl tlen quitelchijtoya TOTECO hasta huejca tlen campa mochijtoyaj huan nopona nochi quimictijque ica tetl. Huajca nopa israelitame quichijque senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Quema Moisés itztoya ipan tepetl Sinaí, TOTECO quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Xiquinilhui nopa israelitame para quema ya inajsitose ipan nopa tlali tlen nimechmacas, nopa tlali iselti monequi mosiyajcahuas sesen huelta quema ajsis chicompa xihuitl. Huan ica ya nopa inquinextise para nopa tlali noaxca na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Para chicuase xihuitl hueli intlatojtocase ipan imomila. Nojquiya hueli inquitzontequise nopa xocomecatl ininmacuayo para más temacas, huan hueli inquitequise itlajca. ");
INSERT INTO nheBl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Pero ipan nopa chicompa xihuitl, nopa tlali monequi mosiyajcahuas huan elis se xihuitl tlaiyocatlalili para na para intenextilise intechtlepanitaj. Amo xijtocaca niyon se xinachtli, niyon amo xijtzontequica imacuayo nopa xocomecatl para ma chamani más. ");
INSERT INTO nheBl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Nopa tlen ixhuas ica iselti ipan imomila campa tepejtoc iyol, amo xijpixcaca, niyon xicajcocuica. Huan itlajca nopa xocomecatl tlen moscaltía iselti, amo xijtequilica queja ipa inquichijtoque, pampa ipan nopa xihuitl, nopa tlali san mosiyajcahuas. ");
INSERT INTO nheBl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pero tlen ixhuas iselti ipan mila ipan nopa xihuitl quema nopa tlali mosiyajcahuas elis tlacualistli para nochi hueli quitequihuise. San se quitequihuise tlen iaxca nopa mila, o itlatequipanojcahua tlen quincojtoc, o itlatequipanojcahua tlen quipalehuíaj se ome tonali, o nopa seyoc tlali ehuani tlen itztoque tlatlajco imojuanti. Nochi san se iniaxca elis para ma quicuaca, pero axaca huelis quipixcas para quiajcocuis. ");
INSERT INTO nheBl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Nojquiya imotlapiyalhua huan nopa tlapiyalime tlen itztoque ipan cuatitlamitl san se hueli quicuase tlen nopona eltoc ipan mila. ");
INSERT INTO nheBl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Xijpohuaca hasta tlamis chicome xihuitl chicome hueltas, o 49 xihuitl. Huan quema ya tlantos huan ajsis ne seyoc tonali, campa hueli inquipitzase icuacua se oquich borrego. ");
INSERT INTO nheBl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Quena, campa hueli ipan nochi nopa tlali Israel monequi inquipitzase tlapitzali quema ajsis nopa Tonali Para Quiixtzacuase Tetlajtlacolhua ipan majtlactli itequi nopa chicompa metztli ipan 50 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Pampa nopa xihuitl 50 elis tlatzejtzeloltic. Nopa xihuitl elis se xihuitl quema nochi tlen tlahuicaj elise malacantoque tlen nopa tlen tlahuicaj. Nojquiya ipan nopa xihuitl monequi inquinmajcahuase nochi imoisraelita tlatequipanojcahua tlen monamacatoque para inmechtequipanose. Quena, nochi israelita tlatequipanohuani mocahuase majcajtoque. Huan nochi israelitame tlen quinamacaque inintlal, nopa tlali sampa mochihuas iniaxca, o iniaxca iniixhuihua. Huan sesen israelita monequi sampa yas campa quistoc ifamilia huan campa eliyaya itlal para quiselis sampa nopa tlali tlen eliyaya iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Nopa xihuitl 50 elis se xihuitl quema inelise inmalacantoque tlen nochi imotequi. Ax intlatojtocase, niyon ax inquipixcase itlajca nopa tlatoctli tlen ixhuac ica iselti, niyon itlajca nopa xocomecatl tlen ax inquimocuitlahuijtoque. ");
INSERT INTO nheBl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Pampa nopa xihuitl elis tlatzejtzeloltic huan nochi israelitame mochihuase majcajtoque o malacantoque. Ipan nopa xihuitl quema inquicuase se tlamantli tlen iselti ixhuac, xijcuitehuaca campa mila huan nimantzi xijcuaca, pero amo xipixcaca, niyon amo xicajcocuica. ");
INSERT INTO nheBl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Ipan nopa xihuitl quema inmochihuase inmalacantoque o majcajtoque, sesen tlen imojuanti monequi mocuepas campa itlal huan campa quisqui ifamilia. Huan yonque ya quinamacatose itlal, ipan nopa tonali sampa quimactilise. ");
INSERT INTO nheBl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Huajca quema inquicohuilíaj o inquinamaquiltíaj seyoc israelita se tlali, amo ximocajcayahuaca. ");
INSERT INTO nheBl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Xijpohuaca quesqui xihuitl mocahuas hasta nopa xihuitl quema nochi mocahuas malacantoc, huan xijtlaxtlahui queja quesqui xihuitl huelis temacas itlajca nopa tlali hasta ajsis nopa xihuitl quema mocuepas ica tlen achtohui iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Huan intla polihui miyac xihuitl para ajsis nopa 50 xihuitl quema nochi mocahuas malacantoc, huajca más patiyo inquiixtlahuase nopa tlali para inquicohuase. Pero intla pilquentzi xihuitl eltos para sampa mocuepas moaxca, ax más patiyo xijnamaca. Pampa nelía tlen inquinamacaj eltoc imiyaca nopa pixquistli tlen temacas nopa tlali hasta sampa elis moaxca ta o tlen achtohui quipixqui. Quena, quej nopa elis ipati nopa tlali quema inquinamacase. ");
INSERT INTO nheBl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","“Huajca xinechimacasica na, niimoTECO Dios, huan amo xijcajcayahuaca seyoc ica se tlaxtlahuili tlen ax ijqui. ");
INSERT INTO nheBl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Monequi xiquintlepanitaca notlanahuatilhua huan xiquintoquilijtinemica para queja nopa initztose ica temachili ipan imotlal. ");
INSERT INTO nheBl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Huan intla inquitoquilise ni tlanahuatili, nopa tlali temacas miyac itlajca, huan inmechmacas para inquicuase hasta inixhuise cuali. Huan initztose ica paquilistli ipan nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Pero huelis imojuanti inmoilhuise ni: ‘¿Tlaque tijcuase ipan nopa xihuitl chicome, pampa ax intechcahuilíaj para titlatojtocase, niyon tipixcase?’ ");
INSERT INTO nheBl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Na nijtitlanis notlatiochihualis ipan nopa xihuitl chicuase, huan yeca nopa tlen inquipixcase ipan nopa xihuitl, huejcahuas para inmopanoltise hasta inpixcase sampa ipan nopa expa xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Quena, quema sampa ajsis tonali para intlatojtocase ipan xihuitl chicueyi, noja inquicuajtiyase nopa pixquistli tlen inquicuique ipan xihuitl chicuase. Huan inmechaxilis para ica inmopanoltise hasta oncas nopa pixquistli ipan xihuitl chicnahui. ");
INSERT INTO nheBl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Xiquilnamiquica para nopa tlali noaxca. Yeca ax hueli inquinamacase para mocahuas seyoc iaxca para nochipa. Imojuanti san inajsini huan inpaxalohuani nica, huan eltoc queja san nimechtlanejtía nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Nochipa quema inquinamacaj se tlali, nopa amatl monequi quiijtos para sampa hueli inquicohuase para imoaxca ipan tlen hueli tonal. ");
INSERT INTO nheBl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Huan quema se israelita mochihuas teicneltzi huan monequis mitznamaquiltis se quentzi itlal, huajca se iteixmatca tlen nelnechca hueli mitzcohuilis sampa nopa tlali tlen mitznamaquiltijtoc. ");
INSERT INTO nheBl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","“Huan intla nopa tlacatl ax quipiya niyon se iteixmatca tlen quipalehuis, pero ya iselti quisentilis nopa tomi, huajca yajaya sampa huelis quicohuas nopa tlali tlen quinamacac. ");
INSERT INTO nheBl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Huan monequi ximoilhuica quesqui xihuitl tlen pixquistli nopa tlacojquetl quiixtlajtoc para elisquía iaxca nopa tlali hasta nopa xihuitl quema nochi elis malacantoc o majcajtoque. Huan quema nopa tlacatl sampa quicohuas itlal, monequi quicuepilis itomi nopa tlacatl para nochi nopa xihuitl tlen quicojtoya para quitequihuis nopa tlali pero ama ayoc hueli quitequihuis pampa sampa quicojqui tlen quinamacac. Pero quena, tlen iaxca eliyaya se tlali sampa hueli quicohuas para elis iaxca intla quipiya nopa tomi. ");
INSERT INTO nheBl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pero intla ax quisentilis nopa tomi queja quinamiqui para sampa quicohuas itlal, huajca nopa tlali eltos iaxca tlen quicojqui hasta ajsis nopa xihuitl quema nochi tlali mocahuas malacantoc huan mocuepas ica tlen achtohui eliyaya iaxca. Huan huajca ipan nopa xihuitl, quena, nopa tlacatl tlen quinamacac nopa tlali, sampa quiselis para iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Intla se tlacatl quinamacas se cali ipan se altepetl tlen moyahualojtoc ica tepamitl, yajaya huelis quicohuas sampa intla quinequisquía para se xihuitl huan sampa elis iaxca tlen quinamacac. ");
INSERT INTO nheBl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Pero quema ya quiaxitijtos se xihuitl quinamacatoc, huajca ayoc hueli quicohuas sampa nopa cali tlen eltoc ipan se altepetl tlen moyahualojtoc ica tepamitl. Huan mocahuas nopa tlacatl tlen quicojtoc iaxca huan iniaxca iixhuihua para nochipa. Niyon nopa cali ax hueli mocuepas para elis iaxca iteco tlen achtohui ipan nopa xihuitl quema nochi tlali mocahuas majcajtos. Queja nopa eltoc tlanahuatili para caltini tlen mopantíaj ipan se altepetl tlen moyahualojtoc ica tepamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pero caltini tlen mopantíaj ipan pilaltepetzitzi tlen ax moyahualojtoque ica tepamitl elise queja nopa tlaltini campa mila. Quiijtosnequi iteco tlen quinamacac huelis quicohuas sampa ica tomi, huan intla ax quicohuas nopa cali sampa, quema ajsis nopa xihuitl 50 elis malacantoc o majcajtoque huan mocuepas para elis iaxca tlen achtohui. ");
INSERT INTO nheBl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Pero nopa caltini tlen mopantíaj ipan inialtepehua iixhuihua Leví, o nopa totajtzitzi, ax san se. Yonque moyahualojtoc nopa inialtepe ica tepamitl, se levita tlacatl tlen quinamacas ichaj sampa huelis quicohuas ipan tlen hueli tonali. ");
INSERT INTO nheBl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Huan se cali tlen se iixhui Leví quinamacas, nojquiya mocuepas iaxca nopa tlacatl ipan xihuitl 50 quema nochi tlali mocahuas malacantoc. Pampa nopa levitame quiselijque ininchajchaj ipatlaca nopa tlali campa hueltosquíaj tlatojtocasquíaj. Yeca axaca hueli quincuilis ininchajchaj para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Huan nopa potreros tlen nechca inialtepehua iixhuihua Leví ax hueli monamacase, pampa nopa piltlaltzitzi mocahuas iniaxca para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Intla se israelita mochihuas teicneltzi huan yas campa ta, monequi xijpalehui queja elisquía se nejnenquetl, o se seyoc tlali ejquetl, huan xijcahua ma itzto mohuaya. ");
INSERT INTO nheBl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Quena, xinechimacasica na, niimoTeco Dios, huan xijcahuilica para imoicni ma itzto imohuaya. Huan amo xitlainamaca itlanca quema inquitlanejtíaj imotomi. ");
INSERT INTO nheBl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ax tleno xitlainamaca quema intetlanejtíaj imotomi, niyon ax xijtlanica tomi intla inquimacase tlacualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Pampa na, niimoTeco Dios tlen nimechilhuía. Na tlen nimechquixti ipan tlali Egipto para nimechmactilis nopa tlali Canaán huan para nielis niimoTeco Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Intla se moisraelita icni mocahuas nelteicneltzi huan quinequis monamacas ica ta para mitztequipanos, huajca xijcohua, pero amo xijtequihui queja elisquía se tequitiquetl tlen tijcojtoc para moaxca tlen ax quipiya niyon se tequiticayotl. ");
INSERT INTO nheBl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Monequi xiquitas queja elisquía se tepaxalojquetl o se cuali tlatequipanojquetl tlen mitzpalehuía. Huan san huelis mitztequipanos hasta ipan nopa xihuitl quema nochi mocahuas malacantoc o majcajtoque. ");
INSERT INTO nheBl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Huan ipan nopa xihuitl quema nochi mocahuas malacantoc yajaya huelis quisas ihuaya iconehua huan mocuepas campa itatahua inintlal. ");
INSERT INTO nheBl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Pampa inisraelitame innotlatequipanojcahua tlen nimechquixti ipan tlali Egipto, huan ax quinamiqui inmonamacase para inelise tlatequipanohuani tlen seyoc iaxca huan intequipanose san tlapic. ");
INSERT INTO nheBl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ax quema xijnahuati se israelita o xijtequihui chicahuac. Monequi xinechimacasica na, niimoTeco Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Pero intla inquinequij inquincohuase tlatequipanohuani para imoaxcahua para inmechtequipanose san tlapic, huajca huelis inquincohuase tlacame huan sihuame tlen ehuani ipan sequinoc tlaltini huan ax israelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Nojquiya hueli inquincohuase seyoc tlali ehuani ininconehua tlen itztoque campa imojuanti yonque ininconehua tlacatque ipan imotlal. ");
INSERT INTO nheBl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Huan quema inmiquise, huajca ni tlatequipanohuani tlen ax israelitame tlen inquincojtoque mocahuase iniaxcahua imoconehua, huan quintequipanose para nochipa. Pero inisraelitame ax hueli inquitequihuise seyoc israelita san tlapic o inquinahuatise chicahuac. ");
INSERT INTO nheBl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Intla se seyoc tlali ejquetl tlen itztoc ipan imotlal mochihuas rico huan se israelita mochihuas teicneltzi huan quinequi monamacas ica nopa seyoc tlali ejquetl, ");
INSERT INTO nheBl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","huajca cualtitoc. Pero yonque monamacatos, nopa israelita noja quipiya tlanahuatili para se iteixmatca quicohuas sampa para quimajcahuas. Quena, hueli quicohuas se iicni, ");
INSERT INTO nheBl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","se itío, o se imachicni, o aqui hueli tlen iteixmatca tlen nelnechca. Huan intla ya iselti huelis quisentilis tomi para quicuepilis iteco queja quicojqui, huajca nojquiya huelis momanahuis ica iselti. ");
INSERT INTO nheBl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Monequi quichihuase cuentas ihuaya iteco para quiitas quesqui monequi tlaxtlahuas. Pehuase quipohuase tlen nopa xihuitl quema monamacac huan quipohuase hasta nopa 50 xihuitl quema nochi mocahuas malacantoc o majcajtoque. San tlaxtlahuas ipampa quesqui xihuitl polihuis para ajsis nopa xihuitl quema elis malacantoc. Quiijtosnequi quicuepilis iteco tlen monequisquía quitlaxtlahuis seyoc tequitiquetl para tequitis ipatlaca hasta nopa 50 xihuitl quema elisquía malacantoc. ");
INSERT INTO nheBl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Intla noja polihui miyac xihuitl para mocahuas malacantoc, huajca quitlaxtlahuis iteco nechca imiyaca tlen quiseli quema yajaya monamacac ica ya. ");
INSERT INTO nheBl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Pero intla ayoc miyac xihuitl polihui para mocahuas malacantoc, huajca san quiixtlahuas nopa xihuitl tlen noja polihui. ");
INSERT INTO nheBl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Intla nopa israelita monamacatoc ica se seyoc tlali ejquetl, yaya mocahuas ihuaya queja se tequitiquetl tlen motemacas tlatequipanos para se xihuitl. Huan nopa seyoc tlali ejquetl ax hueli quinahuatis chicahuac, niyon ax hueli moaxcatis para nochipa. ");
INSERT INTO nheBl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Huan intla nopa israelita tlacatl noja aya momanahuijtoc huan ajsis nopa xihuitl 50, huajca mocahuas malacantoc o majcajtoque ipan nopa xihuitl. Huan ya ica nochi iconehua quisase malacantoque san sejco. ");
INSERT INTO nheBl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Nochi inisraelitame innotlatequipanojcahua na. Na tlen nimechquixti ipan tlali Egipto para innechtequipanose. Na niimoTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Amo ximochijchihuilica totiotzitzi, niyon tlaixcopincayome, niyon teteyome. Quema inajsise ipan imotlal amo xijquetzaca se tetl tlen inquisencajtoque huan inquipajtoque para inquihueyichihuase, pampa na niimoTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Monequi xiquintlepanitaca notlanahuatilhua huan ximosiyajcahuaca ipan nopa tonali quema nimechnahuatijtoc. Xijtlepanitaca noyoyon tiopa. Na niimoTECO tlen nimechilhuía. ");
INSERT INTO nheBl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Intla inquinneltocase notlanahuatilhua huan inquitoquilise tlen niquijtohua, ");
INSERT INTO nheBl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","huajca nijchihuas para ma huetzis atl ipan imotlal quema monequi huetzis atl. Huan nopa tlali temacas miyac pixquistli, huan nopa cuatini temacase miyac itlajca hasta mocahuas. ");
INSERT INTO nheBl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Quena, inquipiyase miyac trigo hasta noja inquipixcatose ipan nopa tonal quema inpehuase inquitequise xocomecatl itlajca. Huan noja inquitequihuijtose nopa xocomecatl itlajca hasta nopa tonal quema sampa inquitocase trigo. Quena, inquicuase tlen nochi tlen inquinequise hasta inixhuise cuali. Huan initztose ica paquilistli ipan imotlal. ");
INSERT INTO nheBl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Quena, na noselti nimechmacas tlasehuilistli. Huan yeca quema incochise, ax inmajmahuise. Ax oncas niyon se tlamantli tlen inmechmajmatis. Nijchihuas para nochi tlapiyalime tlen mosisiníaj ma ixpolihuica. Huan nopona ayoc oncas tlatehuijcayotl. ");
INSERT INTO nheBl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Inquintojtocase imocualancaitacahua huan inquintzontlamiltise ica imomachete. ");
INSERT INTO nheBl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Macuilti tlen imojuanti inquintojtocase cien imocualancaitacahua. Huan cien tlen imojuanti inquintojtocase majtlactli mil imocualancaitacahua. Huan queja nopa, nochi imocualancaitacahua inquintzontlamiltise. ");
INSERT INTO nheBl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Pampa na, nimechtiochihuas huan nimechmiyaquilis. Huan tlen niquijtojtoc nijchihuas ica imojuanti, temachtli nijchihuas. ");
INSERT INTO nheBl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Quena, inquicuase nopa trigo tlen huejcajquiya inquipixcaque. Huan quema ajsis tonali para inquipixcase nopa tlen yancuic, monequis inquiquixtise tlen inquipixcaque se xihuijtlaya para huelis inquiajcocuise tlen yancuic. ");
INSERT INTO nheBl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","“Na nimocahuas para niitztos tlatlajco tlen imojuanti huan ax quema nimechcualancaitas. ");
INSERT INTO nheBl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Niitztos campa imojuanti huan na nielis niimoTeco Dios huan imojuanti inelise innotlacajhua. ");
INSERT INTO nheBl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Na niimoTECO tlen nimechquixti ipan tlali Egipto para ayoc intlatequipanose san tlapic. Na tlen nimechquixtili nopa cuahuitl etic tlen eltoya ipan imoquejquespa para intlapoxonise queja tlapiyalime, huan na nimechchijqui ximoquetzaca xitlahuac. ");
INSERT INTO nheBl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Pero intla ax intechneltoquilise huan ax inquitlepanitase nochi notlanahuatilhua, ");
INSERT INTO nheBl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","huan san inquihuejcamajcahuase huan ax inquinequise inquicaquise tlen nimechilhuijtoc, huajca imojuanti inquixolehuase nopa tlajtoli tlen nijchijtoc imohuaya. ");
INSERT INTO nheBl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Huan huajca ya ni tlen nimechchihuilis. Nimechtitlanilis se cocolistli tlen inmechcocoxcamacas huan se majmajtli tlen nimantzi inmechajsis, huan inquipantise cocolistli tlen tlahuel tlamahua. Nojquiya nimechmacas se cocolistli tlen tlatotonilotl tlen inmechpopoyochihuas. Huan imotlacayohua pehuas para nenpolihuis. Huan tlen inquitocase ipan imomila, elis san tlapic, pampa imocualancaitacahua inmechichtequilise huan inijuanti quicuase. ");
INSERT INTO nheBl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Na nielis niimocualancaitaca, huan sequinoc imocualancaitacahua niquincahuilis ma inmechtlanica. Quena, inijuanti inmechnahuatise. Huan incholojtehuase ica majmajtli yonque axaca inmechtojtoca. ");
INSERT INTO nheBl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Huan intla noja ax innechneltoquilise yonque ya nimechtitlanilijtos nochi ya ni, huajca nimechtlatzacuiltis chicome hueltas ipampa sese imotlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Quena, nijtlamiltis nopa chicahualistli tlen ica inmohueyimatij huan nijchihuas para nopa mixtli ma ayoc quitoyahua atl. Huan ne tlali nijchihuas ma elis queja xali. Quena, nijchihuas ma quipiyas itlachiyalis tlen cafentic queja nopa tepostli bronce. ");
INSERT INTO nheBl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","San tlapic inmosiyahuiltise para intlatojtocase pampa nopa tlali ayoc tlaeliltis huan nopa cuatini ayoc temacase itlajca. ");
INSERT INTO nheBl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Huan intla noja innechcualancaitase huan ax inquinequise inquitlacaquilise tlen nimechilhuía, huajca nimechtlatzacuiltis chicome hueltas más chicahuac. Quena, nopa tlatzacuiltili nimechtitlanilis ipampa imotlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Niquintitlanis tlapiyalime tlen mosisiníaj para quintzontlamiltise imoconehua huan imohuacaxhua. Huan nojquiya nimechtzontlamiltis huan ayoc initztose inmiyaqui huan yeca ipan campa hueli ojtli ayoc itztose israelita tlacame. ");
INSERT INTO nheBl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Pero intla teipa noja aya inmocualtlalise, huan aya inquichijtinemise tlen na nijnequi huan san innechcualancaitase, ");
INSERT INTO nheBl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","huajca nimotlalis queja niimocualancaitaca huan nimechtlatzacuiltis chicome hueltas más chicahuac para sese imotlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Huan nijchihuas para hualas se tlatehuijcayotl campa imojuanti pampa inquixolejtoque nopa tlajtoli tlen nijchijqui imohuaya. Huan intla inmochololtise huan inmotlatitij ipan imoaltepehua ica tepamitl, huajca altepeijtic nijchihuas ma inmechajsi se cocolistli tlen temictía. Huan nimantzi imocualancaitacahua inmechtlanise. ");
INSERT INTO nheBl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","“Huan teipa nijchihuas ma huala se mayantli huan tlahuel pilquentzi elis itlajca imomila. Majtlactli sihuame huelise quiicxitise pantzi ipan san setzi horno. Huan teipa inquipohuase nopa pantzi huan inmoxejxelhuilise para inmechaxilis miyac tonali. Huan yonque inquicuase se quentzi, ax inixhuise. ");
INSERT INTO nheBl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Huan intla ica ya nopa noja aya innechneltocase huan inquisenhuiquilise inquichijtinemise tlen ax nijnequi na, ");
INSERT INTO nheBl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","huajca imohuaya nimotlalis na. Huan tlahuel miyac más nicualanis imohuaya huan nimechtlatzacuiltis chicome hueltas más chicahuac para sese imotlajtlacolhua. ");
INSERT INTO nheBl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Huan inmayanase hasta inquincuase imoconehua tlen oquichpilme huan tlen sihuapilme. ");
INSERT INTO nheBl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Huan na nijxolehuas nopa tlaixpamitl campa inquinhueyichihuaj totiotzitzi campa tlachiquiltipa. Nojquiya nijxolehuas imotlaixpa campa inquitlatíaj copali para imotlaixcopincayohua. Imotlacayohua tlen mictoque niquintlalis ipan imototiotzitzi tlen nojquiya mictoque. Huan ayoc nijnequis nimechitas. ");
INSERT INTO nheBl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Niquinxolehuas imoaltepehua huan mocahuas queja se huactoc tlali, huan nijxolehuas campa inquinhueyichihuayayaj imototiotzitzi. Yonque inquitlatisquíaj copali noixtla, ayoc nijselis. ");
INSERT INTO nheBl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","“Nijxolehuas nochi nopa tlali. Huan quema imocualancaitacahua hualase para moaxcatise, quiitase tlen nijchijtoc huan quisentlachilise. ");
INSERT INTO nheBl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Huan imojuanti nimechtitlanis campa hueli ipan sequinoc tlaltini huan nimechtojtocas ica se machete nomaco. Huan imotlal mocahuas queja se huactoc tlali, huan imoaltepehua mocahuas queja tlasoli. ");
INSERT INTO nheBl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Huan quema initztose ipan inintlal imocualancaitacahua, nopa tlali tlen nimechmacac mosiyajcahuas. Quena, pampa ax inquicahuiliyayaj nopa tlali ma mosiyajcahuas sesen chicome xihuitl quema initztoyaj, nimechtojtocas huan yonque eltos tlaxolehuali, nopa tlali mosiyajcahuas ica paquilistli queja quinamiquiyaya mosiyajcahuas. ");
INSERT INTO nheBl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Huan imojuanti tlen noja initztose ipan sequinoc tlaltini, nimechchihuas para tlahuel ximajmahuica ipan imoyolo hasta quema inquicaquise mojmolinía se tlasoli, incholose pampa inmoilhuise acajya inmechsenpanohua ica machete. Quena, inmajmahuise hasta inmotlalose huan inhuetzise. Quej ni imopantis inisraelitame quema initztose ipan imocualancaitacahua inintlal. ");
INSERT INTO nheBl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Hasta inmocuitiquisase se ica seyoc quema incholose queja inmechsenpanosquíaj imocualancaitacahua ica machete, pero axtle. Huan ayoc tleno huelis inquichihuase iniixtla imocualancaitacahua pampa ayoc inquipiyase chicahualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Huan inixpolihuise nopona tlatlajco inijuanti. Quena, elis queja inintlal inmechcuas. ");
INSERT INTO nheBl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Huan imojuanti tlen noja initztose ipan nopa tlali tlen imocualancaitacahua inmocuesojtinemise ipampa imotlajtlacol. Quena, mojmostla inquipolojtiyase más imochicahualis ica nopa tlajtlacoli tlen imojuanti huan imohuejcapan tatahua inquichijtoque. ");
INSERT INTO nheBl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","“Pero teipa inquipannextise huan innechpohuilise nochi imotlajtlacolhua, huan innechpannextilise nopa tlajtlacoli tlen quichijque imohuejcapan tatahua. Quena, innechpohuilise queja imohuejcapan tatahua ax nechneltoquilijque notlanahuatil huan san quichijtinenque tlen na ax nijnequi niquitas. Huan yeca niquinnextili nocualancayo huan niquinhuicac ipan inintlal inincualancaitacahua. Huan quema imojuanti inmoechcapanose huan inquiselise nopa tlatzacuiltilistli tlen quinamiqui para nochi imotlajtlacolhua noixtla, ");
INSERT INTO nheBl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","huajca na niquilnamiquis nopa tlajtoli tlen nijchijqui ihuaya Abraham, Isaac huan Jacob huejcajquiya. Huan niquilnamiquis nopa tlali tlen niquinmacac huan quejatza ama mocahua tlasosolijtoc. ");
INSERT INTO nheBl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Pampa monequi para nopa tlali ma mosiyajcahuas huan axaca itztos nopona queja na niquijto quinamiqui para mosiyajcahuas. Huan inisraelitame teipa inquiselise imotlatzacuiltilis pampa ax inquitlepanitaque notlanahuatil, niyon ax inquinejque ma nimechnahuati. ");
INSERT INTO nheBl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Huan yonque inquichijtoque miyac tlajtlacoli huan initztose ipan imocualancaitacahua inintlal, na nimechilnamiquis. Ax nimechtlahuelcahuas, niyon ax nimechtzontlamiltis nochi imojuanti, niyon ax nijxolehuas nopa tlajtoli tlen nijchijqui imohuaya. Na niimoTECO Dios. ");
INSERT INTO nheBl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Huan pampa nimechicnelía, niquilnamiquis nopa tlajtoli tlen nijchihua ininhuaya imohuejcapan tatahua quema niquinquixti ipan tlali Egipto quema nochi sequinoc tlaltini ehuani san mosentlachiliyayaj. Quena, niquinquixti para nielis niininTECO Dios.” ");
INSERT INTO nheBl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Huajca nica eltoc nochi nopa miyac tlanahuatili tlen TOTECO quimacac Moisés ipan nopa tepetl Sinaí para ma quinilhuis israelitame. ");
INSERT INTO nheBl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Xiquinilhui israelitame nochi ni tlanahuatili. Quema se acajya ica iselti quinequis nechtestigojquetzas na para moiyocacahuas para na, niimoTECO, o quiiyocacahuas se icone huan teipa quinequis momanahuis para elis malacantoc o majcajtoc, quej ni monequi tlaxtlahuas. ");
INSERT INTO nheBl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Para se tlacatl tlen quipiya 20 xihuitl hasta tlen quipiya 60 xihuitl, tlaxtlahuas 50 plata tomi tlen quitequihuíaj ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Pero intla eli se sihuatl, huajca san tlaxtlahuas 30 plata tomi. ");
INSERT INTO nheBl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Huan para se oquichpil tlen quipiya macuili xihuitl hasta 20 xihuitl, tlaxtlahuase 20 plata tomi. Huan para se sihuapil tlen quipiya 5 xihuitl hasta 20 xihuitl, tlaxtlahuase 10 plata tomi. ");
INSERT INTO nheBl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Pero para se piloquichpiltzi tlen sanoc quipiya se metztli ica tlacatqui huan hasta tlen quipiya macuili xihuitl, tlaxtlahuase macuili plata tomi. Huan intla se pilsihuapiltzi tlen quipiya se metztli hasta macuili xihuitl, tlaxtlahuase eyi plata tomi. ");
INSERT INTO nheBl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Huan para se tlacatl tlen quipiya 60 xihuitl para huejcapa, tlaxtlahuas 15 plata tomi. Huan intla eli se sihuatl tlen quipiya 60 xihuitl para huejcapa, tlaxtlahuas majtlactli plata tomi. ");
INSERT INTO nheBl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Huan intla se tlacatl nelteicneltzi tlatestigojquetztoc para motemacas ica na huan teipa quinequi sampa mocohuis pero ax huelis quisentilis nopa tomi tlen monequi, huajca ma quihuicaca campa nopa totajtzi. Huan nopa totajtzi quiixtlalis quesqui plata tomi monequi tlaxtlahuas nopa tlacatl teicneltzi. Quena, quiixtlalis queja quiitas para quiaxilis itlaxtlahuil nopa tlacatl tlen tlatestigojquetztoc para motemactilis ica na, niimoTECO, huan quinequi sampa mocohuis para mocahuas malacantoc o majcajtoc. ");
INSERT INTO nheBl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Pero intla se acajya tlatestigojquetztoc para nechmacas na, niimoTECO, se tlapiyali, huajca nopa tlacatl monequi nelía nechmactilis nopa tlapiyali. Nochi nopa tlamantli tlen se quiijtos para nechmacas elis tlatzejtzeloltic huan tlaiyocatlalili para na. ");
INSERT INTO nheBl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Huan intla se tlatestigojquetztoc para nechmacas na, niimoTECO, se ofrenda, ax hueli moyolcuepas. Huan intla moilhuijtoc catlía tlapiyali nechmacas huan tlatestigojquetztoc para ya nopa nechmacas, huajca nopa tlapiyali ayoc huelis quipatlas. Niyon ax hueli nechmacas seyoc tlen más cuali o más fiero. Huan intla nechmacasquía seyoc queja ipatlaca, huajca nochi nopa ome tlapiyalime mocahuase tlaiyocatlalilme para na, niimoTECO, huan ax hueli sampa quincohuas. ");
INSERT INTO nheBl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“Huan intla tlatestigojquetzas para nechmacas se tlapiyali tlen ax tlapajpactic para elis tlacajcahualistli para na, niimoTECO, huajca nopa tlacatl quihuicas campa nopa totajtzi nopa tlapiyali. ");
INSERT INTO nheBl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Huan nopa totajtzi quitlachilis intla cuali o ax cuali, huan tlen nopa totajtzi quiixtlalis para ipati, ya nopa monequi quiixtlahuas ipan tiopamitl para sampa mocohuis nopa tlapiyali. ");
INSERT INTO nheBl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Pero intla teipa quinequis sampa quicohuas nopa tlapiyali, monequi tlaxtlahuas tlen ipati quiixtlalijtoc nopa totajtzi huan nojquiya monequi quimiyaquilis seyoc 20 por ciento para queja nopa, nopa tlapiyali sampa elis iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","15","“Intla acajya quiiyocatlalis ichaj para elis tlatzejtzeloltic para na, niimoTECO, huan teipa sampa quinequis mocohuis para iaxca, huajca quej ni quichihuas. Monequi ma huala nopa totajtzi ma quitlachiliqui nopa cali huan quiixtlalis quesqui ipati. Huan nopa imiyaca tomi tlen nopa totajtzi quiixtlalis, huajca ya nopa elis ipati. Huan iyoca tlen nopa ipati tlen quiixtlalijtoc nopa totajtzi, nopa tlacatl monequi quimiyaquilis seyoc 20 por ciento. Huan quema tlaxtlahuas nochi ya nopa, nopa cali sampa elis iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Huan intla se acajya quiiyocatlalis se quentzi tlali tlen quiselijtoc tlen ihuejcapan tatahua para nechmacas para elis noaxca, niimoTECO, huajca nopa totajtzi monequi quitlachilis quejatza ihuexca nopa tlali huan quesqui litros tlen xinachtli monequi para quitocas. Queja nopa quiixtlalis ipati. Intla quiitas para ipan nopa tlali monequi 220 litros tlen cebada xinachtli para quitocas para 50 xihuitl huajca monequi tlaxtlahuas 50 plata tomi. ");
INSERT INTO nheBl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Huan intla se tlacatl quiiyocatlalis itlal ipan nopa xihuitl 50 quema nochi mocahua malacantoc o majcajtoc, huajca nochi tlen ipati monequi tlaxtlahuas ipan tiopamitl para mocohuis sampa nopa tlali. ");
INSERT INTO nheBl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pero intla quiiyocatlalis nopa tlali quema ya panotoc nopa xihuitl quema nochi mocahuas malacantoc, huajca nopa totajtzi quipohuas quesqui xihuitl panotoc tlen nopa xihuitl huan quiquixtilis tlen ipati elisquía para nejmajtic 50 xihuitl. San monequi tlaxtlahuas para quesqui xihuitl polihui para sampa ajsis nopa xihuitl quema mocahuas malacantoc. ");
INSERT INTO nheBl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","“Huan intla nopa tlacatl tlen quiiyocatlali itlal sampa quinequis quicohuas nopa tlali para iaxca, huajca monequi tlaxtlahuas tlen nopa totajtzi quiixtlalis para ipati huan iyoca monequi quimiyaquilis seyoc 20 por ciento. Huan queja nopa, nopa tlali sampa elis iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Pero intla ax quicohuas nimantzi para sampa elis iaxca huan quinamaquiltis seyoc, huajca teipa ayoc quema sampa huelis quicohuas para iaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Huan quema ajsis nopa xihuitl para nochi mocahuas malacantoc o majcajtoc, nopa tlali nojquiya mocahuas malacantoc, huan elis tlaiyocacahuali para na, niimoTECO, huan teipa elis para nopa totajtzitzi iniaxca. ");
INSERT INTO nheBl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Huan intla acajya nechiyocatlalilis na, niimoTECO, se quentzi tlali tlen san quicojtoc huan ax quiselijtoc tlen ihuejcapan tatahua, ");
INSERT INTO nheBl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","huajca nopa totajtzi quipohuas quesqui xihuitl polihui para ajsis nopa xihuitl para nochi mocahuas malacantoc. Huan queja nopa quiixtlalis ipati. Huan nopa tlacatl tlen quiiyocatlalijtoc itlal para na, niimoTECO, monequi nimantzi tlaxtlahuas ipan nopa tonal. ");
INSERT INTO nheBl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Huan quema ajsis nopa xihuitl para nochi mocahuas malacantoc, nopa tlali sampa elis iaxca nopa achtohui tecojtli tlen nopa tlacatl quicohuili. ");
INSERT INTO nheBl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Ipan nochi tlamantli tlen inquiixtlalise ipati, monequi inquitequihuise nopa tlayejyecoli para ietica nopa plata tomi tlen motequihuía ipan nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Nochi huacaxme huan borregojme tlen achtohui tlacatij tlen ininnana ax hueli inquiniyocatlalise para na, niimoTECO, pampa ya eltoc noaxcahua tlen achtohui tlacatij. ");
INSERT INTO nheBl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Pero intla inquinequij inquiiyocatlalise se tlapiyali tlen se iachtohui ejca se tlapiyali tlen ax tlapajpactic para tlacajcahualistli huan yeca ax noaxca, huajca nopa tlacatl tlen iaxca huelis sampa mocohuis intla tlaxtlahuas queja quiixtlalijtoc nopa totajtzi para ipati nopa tlapiyali. Huan iyoca monequi quimiyaquilis seyoc 20 por ciento tlen ipati. Huan intla nopa tlacatl ax quinequis quicohuas sampa nopa tlapiyali tlen nechmaca, huajca nopa totajtzi quinamaquiltis nopa tlapiyali seyoc queja quiixtlalijtoc para ipati pampa ax cuali para tlacajcahualistli. ");
INSERT INTO nheBl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Pero se tlacatl, o se tlapiyali, o se tlali tlen se quiselijtoc tlen ihuejcapan tatahua huan senquistoc nechmacatoc para elis noaxca, ayoc aca huelis quicohuas o quinamacas ica seyoc, pampa ya nopa senquistoc noaxca huan tlahuel tlatzejtzeloltic para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Intla quiijtohua tlanahuatili para monequi miquis se tlacatl, ax huelis tlaxtlahuas para momanahuis. Monequi miquis. ");
INSERT INTO nheBl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Se diezmo tlen nochi tlen temaca momila eltoc noaxca. Quema nopa tlali temacas xinachtli o nopa cuatini temaca itlajca, monequi innechmacase na, niimoTECO, se tlayejyecoli tlen sesen majtlactli tlayejyecoli. Pampa ya nopa eli noaxca huan tlatzejtzeloltic para na. ");
INSERT INTO nheBl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Huajca intla acajya quinequis sampa mocohuis nopa xinachtli tlen imila o itlajca icuatlatochua, huajca monequi tlaxtlahuas tlen ipati huan quimacas nopa totajtzi huan nojquiya monequi quimiyaquilis seyoc 20 por ciento. ");
INSERT INTO nheBl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“Huan ipan sesen majtlactli tlapiyalime monequi inquiquixtise se para innechmacase na, niimoTECO. Amo xiquintlapejpenica catlía tlapiyalime elise noaxcahua. Quema nopa tlapiyalime motecpanaj para calaquise ipan tlatzactli huan nopa tlamocuitlahuijquetl quinpohua sesen quema panoj itzala icuatopil, sesen huelta quema quipohuas hasta ipan majtlactli, huajca nopa tlapiyali elis noaxca na. Quena, ya nopa se diezmo huan tlatzejtzeloltic para na nopa majtlacpa tlapiyali. ");
INSERT INTO nheBl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ax quenijqui intla nopa tlapiyali tlen nechtocarohua elis cuali o ax cuali, ax huelis quiixpatlas. Huan intla quipatlas, huajca nochi ome tlapiyalime, nopa tlen eltoya noaxca huan nopa tlen ipatlaca, nochi mocahuase tlaiyocatlalilme para na, niimoTECO. Huan axaca hueli sampa quicohuas para iaxca.” ");
INSERT INTO nheBl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Huajca ya ni nopa miyac tlanahuatili tlen TOTECO quimacac Moisés ipan nopa tepetl Sinaí para ma quinilhuis nochi israelitame.");
INSERT INTO nheBl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","TOTECO quicamahui Moisés ipan nopa huactoc tlali Sinaí ipan nopa yoyon tiopamitl campa mopantiyayaj. Quicamahui ipan 15 itequi nopa ompa metztli ipan nopa israelita calendario 1:1 Quemantzi huetzis ni tonal ipan abril huan quemantzi ipan mayo ipan tocalendario tlen ama. quema ya panotoya se xihuitl huan se metztli para nopa israelitame quistoyaj tlen tlali Egipto. Huan ya ni tlen TOTECO quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","“Monequi ta ihuaya Aarón xijtlalanaca se censo tlen nochi israelita tlacame tlen quiaxitijtoque 20 xihuitl para huejcapa huan tlen hueli tlatehuitij. Xiquijcuiloca sese itoca, huan itoca itata, huan itoca ihuejcapan tata, huan xiquinpohuaca quesqui itztoque. Huan quema ya inquinpojtose nochi, xiquintecpanaca ipan huejhueyi pamitl queja soldados para tlatehuise. ");
INSERT INTO nheBl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Nojquiya inmechpalehuis se iteipa ixhui nochi nopa 12 huejcapan tatame tlen huejcajquiya itztoyaj. Sesen motlapalehuijca elis tlen más tlayacana ipan iteixmatcahua ipan ihueyi familia. ");
INSERT INTO nheBl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","15","Ya ni inintoca nopa tlayacanani tlen inmechpalehuis tlen sesen hueyi familia: Familia, Tlayacanquetl Rubén, Elisur, icone Sedeur Simeón, Selumiel, icone Zurisadai Judá, Naasón, icone Aminadab Isacar, Natanael, icone Zuar Zabulón, Eliab, icone Helón Efraín, icone José, Elisama, icone Amiud Manasés, icone José, Gamaliel, icone Pedasur Benjamín, Abidán, icone Gedeoni Dan, Ahiezer, icone Amisadai Aser, Pagiel, icone Ocrán Gad, Eliasaf, icone Reuel Neftalí, Ahira, icone Enán ");
INSERT INTO nheBl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ya ni elque inintoca nopa tlayacanani tlen tlapejpenilme para tlayacanase ipan sesen hueyi familia.” ");
INSERT INTO nheBl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Huan Moisés huan Aarón ininhuaya ni tlayacanani tlen TOTECO quintocajtlalijtoya, ");
INSERT INTO nheBl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","quinnotzque nochi israelitame ma mosentilica ipan nopa tonal quema TOTECO quicamahui Moisés. Huan pejque quinijcuilohuaj nochi tlacame tlen ya quiaxitijtoyaj 20 xihuitl ica huejcapa. Huan sesen quiijcuilojque ajqueya eliyaya ihuejcapan tata huan ajqueya itata. Moijcuilojque sesentzitzi. ");
INSERT INTO nheBl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Huajca nopona ipan nopa huactoc tlali tlen itoca Sinaí quinpojque nochi ni tlacame queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Huan quema Moisés, Aarón huan nopa 12 tlayacanani tlen israelitame ya tlantoya inintequi, ya ni ininmiyaca nopa tlacame tlen quinpojque tlen quipixque 20 xihuitl para huejcapa huan huelque yohuij tlatehuitij: Familia, Quesqui Rubén, iachtohui ejca Israel, 46,500 Simeón, 59,300 Gad, 45,650 Judá, 74,600 Isacar, 54,400 Zabulón, 57,400 Efraín, icone José, 40,500 Manasés, icone José, 32,200 Benjamín, 35,400 Dan, 62,700 Aser, 41,500 Neftalí, 53,400 ");
INSERT INTO nheBl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Huajca ya ni techilhui tlen quipantijque Moisés huan Aarón huan nopa 12 tlayacanani tlen tlayacanayayaj ipan sese ifamilia tlen iteipa ixhuihua Israel. ");
INSERT INTO nheBl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Quinpojque nopa israelita tlacame tlen quiaxitijtoyaj 20 xihuitl ica huejcapa huan tlen huelque yohuij para tlatehuitij. ");
INSERT INTO nheBl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Huan quipantijque para ica nochi itztoyaj 603 mil 550 tlaca israelitame tlen huelque tlatehuitij. ");
INSERT INTO nheBl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Pero ax quinpojtoyaj tlacame ipan nopa hueyi familia tlen iteipa ixhuihua Leví, ");
INSERT INTO nheBl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","pampa TOTECO quiilhuijtoya Moisés: ");
INSERT INTO nheBl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Quema tijtlalanas se censo tlen nochi israelitame tlen hueli tlatehuitij, amo xiquinpohua nopa levitame, inijuanti tlen hualajque ipan nopa huejcapan tata Leví. Amo xiquintlali san sejco ihuaya ne sequinoc israelitame. ");
INSERT INTO nheBl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Pero xiquintequimaca nochi levita tlacame ma quimocuitlahuica noyoyon tiopa tlen quipiya nopa caxa, huan nochi tlen eltoc ipani, huan nochi tlamantzitzi tlen nopona calijtic quitequihuíaj. Quema inyase sejcoyoc, elis levitame inintequi para quihuicase nopa yoyon tiopamitl campa na nimocahua imohuaya huan nojquiya quihuicase nochi tlen quipiyaj. Nojquiya levitame ma quiquetzaca ininyoyoncalhua nechca nochaj para ma quiyahualoca. ");
INSERT INTO nheBl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Huan quema monequi quihuicase nopa yoyon tiopamitl, inijuanti tlen quicocopitzase. Huan quema inajsise campa inquiquetzase imoyoyoncalhua, inijuanti tlen sampa quicualchijchihuase nopa tiopamitl queja eltoya. Pero intla se tlacatl tlen ax se iteipa ixhui Leví quinechcahuis nopa yoyon tiopamitl campa na nimocahua imohuaya, monequi inquimictise. ");
INSERT INTO nheBl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Huan monequi nochi tlacame ipan sesen hueyi familia tlen israelitame quipiyase campa quiquetzase ininyoyoncalhua san sejco, ica se pamitl nopona campa quintocarohua iteipa ixhuihua ininhueyi familia. Huan iixhuihua sesen huejcapan tata quipiyase ininbandera para quinextis canque mocahua ininpamitl. ");
INSERT INTO nheBl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Pero nochi nopa levitame quiquetzase ininyoyoncalhua yahualtic tlen nopa yoyon tiopamitl campa nimocahua imohuaya huan tlen quipiya tlen imohuaya nimocajtoc pampa inintequi levitame quimocuitlahuise nopa tiopamitl. Quimocuitlahuise para aqui hueli tlacatl ax huelis monechcahuis huan ax nicualanis ica inisraelitame.” ");
INSERT INTO nheBl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Huajca nopa israelitame quichijque senquistoc nochi tlen TOTECO quinahuati Moisés. ");
INSERT INTO nheBl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nojquiya TOTECO quiilhui Moisés huan Aarón ni tlanahuatili: ");
INSERT INTO nheBl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Nochi israelitame monequi quiquetzase ininyoyoncalhua para huejca quiitase nopa yoyon tiopamitl campa timopantíaj. Huan sesen mocahuas nechca ibandera ihuejcapan tata huan mocahuas nechca ihueyi bandera nopa tlatehuijca pamitl tlen quitocarohua. ");
INSERT INTO nheBl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","“Nopa tlacame tlen nopa huejhueyi familias tlen Judá, Isacar huan Zabulón quiquetzase ininyoyoncalhua huan ininbandera ica campa quisa tonati tlen nopa yoyon tiopamitl. Huan nica eltoc inintoca sesen hueyi familia, inintlayacanca huan quesqui tlacame huelque yohuij tlatehuitij: Familia, Tlayacanquetl, Quesqui Judá, Naasón, icone Aminadab, 74,600 Isacar, Natanael, icone Zuar, 54,400 Zabulón, Eliab, icone Helón, 57,400 ");
INSERT INTO nheBl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Huajca ipan nopa tlatehuijca pamitl tlen Judá elis tlacame tlen hualahuij ipan ni eyi huejhueyi familias huan san sejco ajsique 186,400 tlacame tlen huelque tlatehuise. Huan ni tlatehuijca pamitl tlayacantiyas quema inisraelitame inquistehuase para inmochihuase sejcoyoc. ");
INSERT INTO nheBl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","15","“Nopa tlacame tlen nopa huejhueyi familias tlen Rubén, Simeón huan Gad quiquetzase ininyoyoncalhua huan ininbandera ica sur tlen nopa yoyon tiopamitl. Huan nica eltoc inintoca sesen hueyi familia, inintlayacanca huan quesqui tlacame huelque yohuij tlatehuitij: Familia, Tlayacanquetl, Quesqui Rubén, Elisur, icone Sedeur, 46,500 Simeón, Selumiel, icone Zurisadai, 59,300 Gad, Eliasaf, icone Reuel, 45,650 ");
INSERT INTO nheBl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Huajca ipan nopa tlatehuijca pamitl Rubén itztose tlacame tlen hualahuij ipan ni eyi huejhueyi familias huan san sejco ajsique 151,450 tlacame tlen huelque tlatehuise. Huan ni tlatehuijca pamitl motecpanase iica nopa tlatehuijca pamitl Judá quema inquistehuase para inmochihuase sejcoyoc. ");
INSERT INTO nheBl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Huan teipa motecpanase nopa levitame tlen quihuicase noyoyon tiopa, niimoTECO, quema inquisase para seyoc lado. Huan quisase tlatlajco ipan nochi huejhueyi familias san queja mocahuaj tlatlajco ininyoyoncalhua. Queja nopa quisase campa monequi sesen itzintla ibandera. ");
INSERT INTO nheBl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","23","“Nopa tlacame tlen nopa huejhueyi familias tlen Efraín, Manasés huan Benjamín quiquetzase ininyoyoncalhua huan ininbandera ica campa temo tonati tlen nopa yoyon tiopamitl. Huan nica eltoc inintoca sesen hueyi familia, inintlayacanca huan quesqui tlacame huelque yohuij tlatehuitij: Familia, Tlayacanquetl, Quesqui Efraín, Elisama, icone Amiud, 40,500 Manasés, Gamaliel, icone Pedasur, 32,200 Benjamín, Abidán, icone Gedeoni, 35,400 ");
INSERT INTO nheBl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Huajca ipan nopa itlatehuijca pamitl Efraín elis tlacame tlen hualahuij ipan ni eyi huejhueyi familias huan san sejco mochihuase 108,100. Huan ni tlatehuijca pamitl motecpanase iica nopa levitame. ");
INSERT INTO nheBl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","30","“Nopa tlacame tlen nopa huejhueyi familias tlen Dan, Aser huan Neftalí quiquetzase ininyoyoncalhua huan ininbandera ica norte tlen nopa yoyon tiopamitl. Huan nica eltoc inintoca sesen hueyi familia, inintlayacanca huan quesqui tlacame huelque yohuij tlatehuitij: Familia, Tlayacanquetl, Quesqui Dan, Ahiezer, icone Amisadai, 62,700 Aser, Pagiel, icone Ocrán, 41,500 Neftalí, Ahira, icone Enán, 53,400 ");
INSERT INTO nheBl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Huajca ipan nopa tlatehuijca pamitl tlen Dan elis nopa soldados tlen ni eyi huejhueyi familias huan san sejco ajsique 157,600 tlacame tlen huelque tlatehuise. Huan ni tlatehuijca pamitl motecpanase iica ibandera hasta teipa huan nejnemise iica nopa tlatehuijca pamitl Efraín.” ");
INSERT INTO nheBl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Huajca quema quinpojtoyaj nochi israelita tlacame tlen huelque tlatehuitij ipan nochi huejhueyi familias ajsique 603,550 tlacame. ");
INSERT INTO nheBl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Pero ax quintlalijque san sejco nopa levitame pampa TOTECO quinahuatijtoya Moisés ma ax quinpohua ica tlen tlatehuise. ");
INSERT INTO nheBl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Huajca nopa israelitame quichijque nochi senquistoc queja TOTECO quinahuatijtoya Moisés. Huan sesen hueyi familia quiquetzque ininchaj tlen yoyomitl iica ibandera campa quinilhuijtoyaj. Huan quema quistejque, motecpantiyajque huan nejnenque sesen hueyi familia senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ya ni techpohuilía tlen iteixmatcahua Moisés huan iicni Aarón ipan nopa tonali quema TOTECO quicamahui Moisés ipan nopa tepetl Sinaí. ");
INSERT INTO nheBl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Inintoca iconehua Aarón eliyaya: Nadab tlen achtohui ejquetl, Abiú, Eleazar, huan Itamar. ");
INSERT INTO nheBl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Nochi inijuanti quinajalti ica aceite huan quiniyocacajqui ma elica totajtzitzi para ma tequitica tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Pero Nadab huan Abiú mijque iixpa TOTECO nepa ipan nopa huactoc tlali Sinaí pampa ax quitoquilijque itlajtol TOTECO huan quitequihuijque se tlitl tlen ax tlatzejtzeloltic. Huan tlen mijque aya quinpiyayaya ininconehua, yeca san mocajqui Eleazar huan Itamar para quipalehuise inintata Aarón ipan itequi queja totajtzi ipan ininnemilis. ");
INSERT INTO nheBl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Xiquinnotza ma hualaca nochi iteipa ixhuihua Leví huan xijchihua para ma monextica iixtla Aarón para quitequipanose. ");
INSERT INTO nheBl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Huan inijuanti quitequipanose Aarón huan quintequipanose nochi israelitame pampa quichihuase miyac piltequitzitzi tlen tiquinilhuis ma quichihuaca ipan nopa achtohui cuartos ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Quimocuitlahuise nopa cuamesas huan nochi tlamantzitzi tlen eltoc ipan nopa yoyon tiopamitl campa timopantíaj. Huan quichihuase nochi tlen nimechnahuatijtoc inisraelitame xijchihuaca. ");
INSERT INTO nheBl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Huajca xiquinmaca Aarón huan itelpocahua nochi nopa levitame. Quena, nochi tlacame ipan nopa hueyi familia Leví quinpalehuise. Huan levitame mocahuase iyoca tlen nochi ne sequinoc israelitame para melahuac ma elica iaxcahua Aarón huan iniaxcahua itelpocahua. ");
INSERT INTO nheBl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Pero san Aarón huan itelpocahua xiquintequimaca para ma elica totajtzitzi, huan ne sequinoc levitame, axtle. Intla seyoc tlen ax totajtzi quichihuas itequi se totajtzi huan monechcahuis campa más tiopan calijtic, monequi xijmictica.” ");
INSERT INTO nheBl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Huan sampa TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ya nimechilhuijtoc para monequi xinechmacaca nochi imoachtohui ejcahua, pampa ya nopa noaxcahua. Pero para ax monequi innechmacatiyase imoachtohui ejcahua, ininpatlaca niquinselis nochi levitame para ma elica noaxcahua ininpatlaca nochi sequinoc israelitame, ");
INSERT INTO nheBl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","pampa na noaxcahua nochi tlen achtohui tlacatij. Quema nijchijqui para ma miquica nochi tlen achtohui ehuani tlen nochi tlali Egipto, nimocuili nochi coneme tlen achtohui ehuani tlen nochi inisraelitame, huan nojquiya nochi tlapiyalime tlen achtohui tlacatise, huan yeca nochi noaxcahua. Na niimoTECO.” ");
INSERT INTO nheBl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Huan TOTECO quinojnotzqui Moisés sampa ipan huactoc tlali Sinaí huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Xiquinpohua nochi levitame ipan sesen cali, huan iyoca xiquinpohua ajqueya inijuanti hualajque ipan sese itelpoca nopa huejcapan tata Leví. Xiquinpohua nochi oquichpilme tlen ya quiaxitijque se metztli para huejcapa.” ");
INSERT INTO nheBl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Huan Moisés quinpojqui senquistoc queja quinahuatijtoya TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Huan nopa huejcapan tata Leví quinpixqui eyi itelpocahua: Gersón, Coat huan Merari. ");
INSERT INTO nheBl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Huan Gersón quinpixqui ome itelpocahua: Libni huan Simei. ");
INSERT INTO nheBl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Huan Coat quinpixqui nahui itelpocahua: Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nheBl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Huan Merari quinpixqui ome itelpocahua: Mahli huan Musi. Huajca nica nimitzilhuijtoc ajqueya itztoyaj nopa tlayacanani ipan nopa familias tlen iteipa ixhuihua nopa huejcapan tata Leví huan ama tiquintocajtía nochi levitame. ");
INSERT INTO nheBl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Huajca iixhuihua Gersón mochijque ome huejhueyi familias tlen quisqui tlen itelpocahua, Libni huan Simei. ");
INSERT INTO nheBl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Huan ama nochi inintlaca ixhuihua tlen quipiyayayaj se metztli para huejcapa mochijque 7 mil 500. ");
INSERT INTO nheBl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Huan TOTECO quinnahuati iixhuihua Gersón ma quiquetzaca ininyoyoncalhua nechca nopa yoyon tiopamitl ica campa huetzi tonati. ");
INSERT INTO nheBl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Huan Eliasaf, icone Lael, elqui nopa tlayacanquetl tlen iixhuihua Gersón. ");
INSERT INTO nheBl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Huan inijuanti quipixque inintequi para quimocuitlahuise nopa tiopamitl huan nochi yoyomitl tlen quipixqui. Quimocuitlahuijque itzajca, icortinas, ");
INSERT INTO nheBl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","huan nopa icortinas tlen mochihua nopa tlatzactli tlen quiyahualohua nopa tlaixpamitl huan tiopamitl, huan nopa cortinas tlen quicuapilohuaj campa calaquise, huan nochi mecatl tlen quitequihuía tiopamitl. Ya nopa eliyaya inintequi iixhuihua Gersón. ");
INSERT INTO nheBl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Huan iixhuihua Coat mochijque nopa nahui huejhueyi familias tlen quisque tlen itelpocahua, Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nheBl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Huan ama nochi inintlaca ixhuihua tlen quipiyaj se metztli para huejcapa mochijque 8 mil 600. Huan iixhuihua Coat tequitiyayaj tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Huan TOTECO quinnahuati iixhuihua Coat ma quiquetzase ininyoyoncalhua nechca tiopamitl ica sur. ");
INSERT INTO nheBl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Huan Elizafán, icone Uziel, elqui nopa tlayacanquetl tlen iixhuihua Coat. ");
INSERT INTO nheBl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Huan inijuanti quipixque tlanahuatili para quimocuitlahuise nopa caxa, nopa cuamesa para pantzi, nopa tlahuil quetzali, nopa tlaixpamitl para copali, nopa tlaixpamitl para tlacajcahualistli tlatlatili, huan nochi tepostli tlen quitequihuijque tiopan calijtic. Nojquiya inintequi para quimocuitlahuise nopa cortina yejyectzi tlen quitzajqui campa Tlahuel Tlatzejtzeloltic. Nojquiya inintequi para quicualtlalise nochi ni tlamantli intla monequiyaya se quentzi tequitl. Ya nopa eliyaya inintequi iixhuihua Coat. ");
INSERT INTO nheBl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Huan Eleazar, icone nopa totajtzi Aarón, eliyaya nopa tlayacanquetl tlen más hueyi ipan nochi levitame. Yajaya tlen quintequimacayaya nopa tlacame tlen tlapalehuiyayaj tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Huan iixhuihua Merari mochijque nopa ome huejhueyi familias tlen quisque tlen itelpocahua Mahli huan Musi. ");
INSERT INTO nheBl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Huan ama nochi inintlaca ixhuihua tlen quipiyaj, se metztli para huejcapa mochijque 6 mil 200. ");
INSERT INTO nheBl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Huan TOTECO quinnahuati quiquetzase ininyoyoncalhua nechca tiopamitl ica norte. Huan Zuriel, icone Abihail, elqui nopa tlayacanquetl tlen iixhuihua Merari. ");
INSERT INTO nheBl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Huan inijuanti quipixque inintequi para quimocuitlahuise nopa huapali ica tlen quichijque caltechtli, nopa cuaixtlapali, nopa tlaquetzali, huan inintepos cuatetoyo, huan nochi tlamantzitzi tlen quitequihuía. ");
INSERT INTO nheBl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Nojquiya quimocuitlahuijque nopa tlaquetzali para nopa calixpamitl tlen quiyahualohuayaya nopa tiopamitl ihuaya nopa tepos cuatetomitl para tlaquetzali, ihuaya iniestacas huan ininmecayohua. Ya nopa elqui inintequi iixhuihua Merari. ");
INSERT INTO nheBl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Huan TOTECO quinnahuati Moisés, Aarón huan ininconehua ma quiquetzaca ininyoyoncalhua nechca tiopamitl ica campa quisa tonati. Huan quipixque inintequi para quinmocuitlahuilise nochi nopa yoyon tiopamitl campa TOTECO mopantiyaya ica nopa israelitame. Huan intla tlen hueli tlacatl quinechcahuisquía nopa yoyon tiopamitl, monequi quimictise. ");
INSERT INTO nheBl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Huan nochi nopa levita tlacame tlen Moisés huan Aarón quinpojque tlen quipiyayayaj se metztli para huejcapa ajsique 22 mil oquichpilme huan tlacame. ");
INSERT INTO nheBl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Teipa TOTECO quiilhui Moisés: “Xiquinpohua nochi achtohui ehuani oquichpilme huan tlacame ipan israelitame tlen quipiyaj se metztli para huejcapa, huan xiquinijcuilo ica inintoca. ");
INSERT INTO nheBl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nochi levitame elise noaxcahua para nechtequipanose na, niimoTECO. Huan yeca ayoc nimoaxcatis iniachtohui conehua nochi israelitame. Huan inintlapiyalhua levitame nimoaxcatis, huan yeca ayoc elis noaxca iniachtohui cone sesen sihua tlapiyali tlen iniaxca sequinoc israelitame tlen ax levitame.” ");
INSERT INTO nheBl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Huajca Moisés quinpojqui nochi israelitame tlen achtohui ehuani tlen oquichpilme o tlacame senquistoc queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Huan nochi oquich israelitame tlen quiaxitijtoyaj se metztli quinijcuilojque huan mochijque 22 mil 273 ica nochi. ");
INSERT INTO nheBl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Huan TOTECO quicamahui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Xinechmaca nochi levitame para nechtequipanose ininpatlaca imooquichpilhua tlen achtohui ehuani, huan xinechmaca inintlapiyalhua nopa levitame queja ininpatlaca inioquich tlapiyalhua tlen achtohui ehuaj tlen nochi israelitame. Quena, nochi levitame elise noaxcahua para ma nechtequipanoca na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pero nopa achtohui ehuani oquichpilme huan tlacame tlen nochi israelitame quionpano ica 273 imiyaca nopa oquichpilme huan tlacame tlen itztoyaj levitame. Huajca axaca se oquichpil o tlaca levita para ica nijpatlas nopa 273 achtohui ehuani tlen inisraelitame tlen mocajque huan monequi xinechcohuilise. ");
INSERT INTO nheBl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Huajca para sesen nopa 273, monequi xinechmacaca 5 plata tomi tlen quipiya 11 gramos ietica queja nopa tlayejyecoli tlen quitequihuíaj ipan tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Huan xiquinmactili nopa tomi Aarón huan iconehua para innechcohuilise nopa 273 achtohui ehuani ipan israelitame tlen mocajque.” ");
INSERT INTO nheBl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Huajca Moisés quiseli nopa tomi tlen nopa tlacame quitlaxtlahuiyayaj ipampa nopa achtohui ehuani israelitame tlen mocajque. ");
INSERT INTO nheBl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Huan para nochi quiseli 1 mil 365 plata tomi ica ietica queja nopa tlayejyecoli tlen quitequihuijque ipan tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Huan teipa Moisés quinmactili Aarón huan itelpocahua nopa tomi senquistoc queja TOTECO quinahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Teipa TOTECO quinnojnotzqui Moisés huan Aarón huan quinilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Xijtlalanaca se censo tlen nochi nopa levitame tlen nojquiya itztoque iteipa ixhuihua Coat. Xiquijcuiloca ajqueya hualajque ipan sesen nopa huejhueyi tetatme tlen eliyayaj itelpocahua nopa huejcapan tata Coat. ");
INSERT INTO nheBl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ama xiquinpohuaca nochi tlacame tlen quipiyaj 30 hasta 50 xihuitl huan tlen huelise tequitise ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Huan ya ni nopa tequitl tlen quichihuase iteipa ixhuihua Coat ica nopa tlamantli tlatzejtzeloltic tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quema monequi inquiijcuenise nopa yoyon tiopamitl para inyase sejcoyoc, Aarón ihuaya iixhuihua calaquise achtohui huan quiquixtilise nopa cortina tlen quitzacua ipan puerta campa calaquij campa nopa caxa tlen quipiya tlen imohuaya nimocajqui, niimoTECO, huan quipajpatlahuase nopa cortina ipan nopa caxa. ");
INSERT INTO nheBl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Huan ipan nopa cortina quiixtzacuase huan quiquimilose ica inincuetlaxo pesojme. Huan iixco quipatlahuilise nopa patiyo yoyomitl tlen azultic huan sampa quicalaquise nopa cuahuitl huehueyac ipan ianillos para ica quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Teipa ipan nopa cuamesa campa mocahua nopa pantzi monequi xijpajpatlahuase se yoyomitl azultic. Huan ipan nopa yoyomitl quitlalise nochi platos, cucharas, caxitl huan nopa tazas tlen quitequihuíaj quema quitoyahuaj se tlacajcahualistli tlatoyahuali. Huan nojquiya nopa pantzi tlen nochipa eltos nopona. ");
INSERT INTO nheBl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Huan iixco nochi nopa tlamantli quipatlahuase nopa patiyo yoyomitl tlen chichiltic. Huan teipa quipiquise ica inincuetlaxo pesojme huan teipa sampa quicalaquise nopa cuahuitl huehueyac tlen ica quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Teipa quicuise seyoc nopa patiyo yoyomitl tlen azultic huan quipatlahuase ipan nopa tlahuil quetzali ica itlahuilhua, nopa tepostli para quiitzquise tlicoli, iplatos, huan nochi ixarro para aceite tlen nopona quitequihuíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Huan nochi nopa tlamantli ihuaya nopa tlahuil quetzali quiquimilose ica inincuetlaxo pesojme. Huan teipa sampa quicalaquise nopa cuahuitl huehueyac para ica quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Teipa quipatlahuase seyoc patiyo yoyomitl azultic ipan nopa tlaixpamitl tlen oro para copali. Teipa quipiquise ica inincuetlaxo pesojme huan sampa quicalaquise nopa huejhueyi cuahuitl para ica quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Huan nochi tlamantzitzi tlen motequihuía tiopan calijtic quisentilise huan quitlalise ipan seyoc patiyo yoyomitl azultic. Teipa quiquimilose ica inincuetlaxo pesojme huan sampa quicalaquise nopa huehueyac cuahuitl para ica quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Teipa monequi quiquixtise nochi nopa cuanextli tlen nopa tlaixpamitl campa quitlatíaj tlacajcahualistli. Huan ipan quipatlahuase seyoc patiyo yoyomitl moradojtic. ");
INSERT INTO nheBl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Huan iixco quitlalise nochi tlen motequihuía ipan tlaixpamitl. Quitlalise itepos caja campa quitemaj cuanextli, iteposchijcolhua para quiitzquise nacatl, ipalas, huan nopa huajcali para quiselis estli, huan nochi sequinoc tepostli tlen nopona motequihuíaj. Huan teipa quipiquise ica inincuetlaxo pesojme huan sampa quicalaquise nopa huehueyac cuahuitl para ica quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Huan quema Aarón huan itelpocahua ya tlantose para quipijpiquise nochi nopa tlamantli tlen tlatzejtzeloltic tlen eltoya tiopan calijtic, huajca quena, hueli quicuiquij iixhuihua Coat para quihuicase ipan ojtli hasta campa inajsise. Pero iteipa ixhuihua Coat ax hueli quiitzquise nopa tlamantli tlatzejtzeloltic, pampa miquise. Huajca nochi ni tlamantli inintequi iteipa ixhuihua Coat para quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Huan Eleazar itelpoca nopa totajtzi Aarón quipiyas imaco nopa aceite para nopa miyac tlahuili, nopa copali tlen ajhuiyac mijmiyotía, nopa tlacajcahualistli tlen harina tlen monequi mojmostla, huan nopa aceite tlen tlatzejtzeloltic para tlaiyocatlalise para na, niimoTECO. Nelía mocahua imaco Eleazar para quimocuitlahuis nochi nopa yoyon tiopamitl campa nimocahua imohuaya ica nochi cuamesas huan tlamantzitzi tlen onca tiopan calijtic huan nochi tlen mochijtoc nopona.” ");
INSERT INTO nheBl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Huan TOTECO quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nheBl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Amo xijcahuilica para iteipa ixhuihua Coat ma quichihuaca tlamantli tequitl tlen ax quipiyaj tlanahuatili quichihuase huan queja nopa miquise. ");
INSERT INTO nheBl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Para ax tlantiyase iixhuihua Coat ipan levitame, quej ni inquichihuase. Aarón huan itelpocahua ma itztoca tiopan calijtic ininhuaya huan ma quinilhuica sesen iixhuihua Coat tlen monequi quichihuase huan tlen monequi quihuicase para ax quinechcahuise tlen tlatzejtzeloltic huan miquise. ");
INSERT INTO nheBl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Huan intla axaca itelpocahua Aarón tiopan calijtic, ma ax calaquica coatitame niyon se tlalochtli, pampa huelis quiitase se tlamantli tlen tlatzejtzeloltic, huan intla quiitase se tlenijqui, miquise.” ");
INSERT INTO nheBl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Teipa sampa TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Xijtlalana nojquiya se censo tlen nochi nopa levitame tlen iixhuihua Gersón tlen itztoya huejcajquiya. Xiquijcuilo ajqueya hualajque ipan sesen nopa huejhueyi tetatme tlen eliyayaj Gersón itelpocahua huejcajquiya. ");
INSERT INTO nheBl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Xiquinpohuaca nochi tlacame tlen quipiyaj 30 hasta 50 xihuitl tlen huelise calaquise ipan notequi, niimoTECO, ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Huan ya ni elis inintequi iixhuihua Gersón quema tequipanose tiopan calijtic huan quema quihuicase tlamamali. ");
INSERT INTO nheBl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Quihuicase nopa cortinas ica tlen quichijque nopa cuartos ipan tiopa, huan nopa inincuetlaxo pesojme tlen ica quitzactoque, huan nopa cortinas tlen ica quitzacuaj campa incalaquij tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Nojquiya quihuicase nopa cortinas ipan nopa tlatzactli iteno calixpamitl, ihuaya nopa cortina tlen quitzacua campa incalaquij campa calixpamitl tlen quiyahualohua nopa tiopamitl huan nopa tlaixpamitl. Huan quihuicase nochi mecatl huan tepostli tlen motequihuíaj ipan nopa cortinas. Huajca inintequi iixhuihua Gersón para quihuicase ni tlamantzitzi. ");
INSERT INTO nheBl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Huan Aarón ihuaya itelpocahua quinilhuise iixhuihua Gersón sesen tequitl tlen monequi quichihuase huan tlen quihuicase. ");
INSERT INTO nheBl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Pero elis Itamar, itelpoca nopa totajtzi Aarón, tlen achi más quinnahuatis iixhuihua Gersón ipan inintequi. ");
INSERT INTO nheBl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Xiquinpohua nojquiya nochi levitame tlen elij iixhuihua Merari tlen huejcajquiya ica sese itelpocahua, pampa nochi ome mochijtoque huejhueyi tetatme. ");
INSERT INTO nheBl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Xiquinpohua nochi iniixhuihua tlen quipiyaj 30 hasta 50 xihuitl huan hueli calaquise tlatequipanose tiopan calijtic. ");
INSERT INTO nheBl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Iixhuihua Merari quihuicase nopa tiopamitl ihuapalhua, icuaixtlapalhua, itlaquetzalhua huan itepos cuatetoyo. ");
INSERT INTO nheBl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Nojquiya quihuicase nopa tlaquetzali ipan calixpamitl huan inintepos cuatetoyo, huan inintepos estacas, huan ininmecayohua huan nochi nopa tlamantzitzi tlen quitequihuíaj. Huan Itamar monequi quinotzas sesen tlacatl ica itoca huan quiilhuis tlaque quihuicas quema inmijcuenise. ");
INSERT INTO nheBl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Huajca ya ni eli inintequi iixhuihua Merari huan monequi quinnahuatis Itamar, icone nopa totajtzi Aarón.” ");
INSERT INTO nheBl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Huajca Moisés huan Aarón huan nochi nopa tlayacanani tlen nopa israelitame quinpojque iixhuihua Coat. Huan quiniyocatlali ipan nahui familias queja quisque tlen inahui telpocahua Coat huejcajquiya. ");
INSERT INTO nheBl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Quinpojque tlen quipixque 30 hasta 50 xihuitl huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Huan iixhuihua Coat ajsique 2 mil 750. ");
INSERT INTO nheBl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ya ni elque nochi iixhuihua Coat tlen hueliyaya tlapalehuise ipan nopa yoyon tiopamitl. Huan Moisés huan Aarón quinpojque huan quinijcuilojque senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Huan nojquiya quinpojque iixhuihua Gersón. Huan quiniyocatlali ipan ome familias queja quisque tlen sese iome telpocahua Gersón huejcajquiya. ");
INSERT INTO nheBl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Quinpojque tlen quipixque 30 hasta 50 xihuitl, ");
INSERT INTO nheBl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamitl huan ajsique 2 mil 630. ");
INSERT INTO nheBl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Huajca ya ni elque nochi iixhuihua Gersón tlen hueliyaya tlapalehuise ipan nopa yoyon tiopamitl campa timopantíaj. Huan Moisés huan Aarón quinpojque huan quinijcuilojque senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Huan nojquiya quinpojque iixhuihua Merari. Huan quiniyocatlali ipan ome familias queja quisque ipan sese iome telpocahua Merari huejcajquiya. ");
INSERT INTO nheBl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Quinpojque tlen quipixque 30 hasta 50 xihuitl huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Huan iixhuihua Merari ajsique 3 mil 200. ");
INSERT INTO nheBl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Huajca ya ni elque nochi iixhuihua Merari tlen hueliyaya tlapalehuise ipan nopa yoyon tiopamitl. Huan Moisés huan Aarón quinpojque senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Huan Moisés huan Aarón quichijque se suma tlen nochi levitame tlen itztoyaj ipan nopa tonal. Huan quiijcuilojque tlen quisque ipan Coat, Gersón huan Merari tlen elque ieyi telpocahua Leví tlen huejcajquiya. Huan quiijcuilojque tlen quisque tlen sese ininchicueyi telpocahua. ");
INSERT INTO nheBl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Huan nopa tlacame tlen quipixque 30 hasta 50 xihuitl huan huelque tlapalehuise ipan tiopamitl huan tlamamase, ");
INSERT INTO nheBl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ajsique 8 mil 580. ");
INSERT INTO nheBl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Huajca ya ni elque nochi iteipa ixhuihua Leví tlen huelque tlapalehuise ipan tiopamitl. Huan senquistoc queja TOTECO quinahuatijtoya Moisés, quinpojque nochi tlen quichihuase tequitl o tlen quihuicase tlamantzitzi. ");
INSERT INTO nheBl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Teipa TOTECO quicamahui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Xiquinnahuati nochi israelitame para ma quinquixtica tlen ininchajchaj nochi tlen palani ininnacayo ica lepra, huan nojquiya tlen atemoj ipan inintlacayo ihuaya nochi tlen ax tlapajpactique pampa quiitzquijque se mijcatzi. Huan xiquintojtoca huejca tlen imoaltepe tlen yoyoncaltini. ");
INSERT INTO nheBl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Xiquinquixtica tlacame huan nojquiya sihuame tlen mopantíaj ica ni cocolistli, huan ma yaca itztotij huejca tlen imochajchaj para ax quichihuase ax tlapajpactic campa imoyoyoncalhua pampa nopona tlatlajco imojuanti, nimocahua na tlen nitlatzejtzeloltic.” ");
INSERT INTO nheBl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Huajca nopa israelitame quineltocaque nochi tlen TOTECO quinahuatijtoya Moisés huan quinquixtijque nochi tlen queja nopa mococohuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Xiquinilhui nochi israelitame para quema se tlacatl o se sihuatl quiixpano seyoc tlacatl, na niquijtohua para quihuica tlajtlacoli noixtla. ");
INSERT INTO nheBl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Huan monequi nopa tlacatl o nopa sihuatl nechnelilhuis noixtla tlen quichijtoc huan teipa yas quitlaxtlahuis ne se tlen quichihuilijtoc fiero. Huan quicuepilis nochi tlen quinenpolojtoc huan nojquiya quimiyaquilis 20 por ciento más huan ax queja quicuitoya. ");
INSERT INTO nheBl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Huan intla nopa tlacatl tlen quitlaxtequilijtoya o tlen hueli quichihuilijtoya ya mictoc huan axaca niyon se iteixmatca para quicuepilis, huajca nopa tomi tlen quitlahuiquilía elis para Toteco huan para quitequihuis se totajtzi. Huan nojquiya monequi quimacas nopa totajtzi nopa oquich borrego tlen monequi. Huan nopa totajtzi nechtencahuilis para nechixtzacuilis nopa tlajtlacoli tlen quichijtoc nopa tlacatl. ");
INSERT INTO nheBl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“Nochi regalo tlen israelitame nechhualiquilíaj na, niimoTECO, elis iaxca nopa totajtzi. ");
INSERT INTO nheBl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Nochi tlamantli tlacualistli huan tlapalehuili tlen ininmil tlen quimacase TOTECO, mocahuas iaxca nopa totajtzi.” ");
INSERT INTO nheBl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Huan TOTECO quinojnotzqui Moisés huan quiilhui ma quinmaca israelitame ni tlanahuatili: ");
INSERT INTO nheBl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Intla isihua se tlacatl quiixpanos ihuehue huan mocahuas ica seyoc tlacatl, ");
INSERT INTO nheBl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","pero axaca quiitas para huelis quiteilhuis ica itlajtlacol, ya ni tlen quichihuas. ");
INSERT INTO nheBl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Intla ihuehue, quena, quitlasomati isihua huan moilhuía para tlajtlacolchijtoc, o huelis ihuehue quitlasomati isihua huan ax tleno quichijtoc, queja ni inquisencahuase. ");
INSERT INTO nheBl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Nopa tlacatl monequi quihuicas isihua iixpa totajtzi ica se tlacajcahualistli tlen ome kilos harina tlen cebada, huan nechtencahuilis para na, niimoTECO. Pero ax quimanelos nopa harina ica aceite, niyon ax quitequilis nopa copali tlaajhuiyacayotl, pampa ya nopa elis se tlacajcahualistli para quimatis tlen temachtli intla moilhuía huelis tlajtlacolchijtoc isihua. ");
INSERT INTO nheBl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Huan nopa totajtzi quihualicas nopa sihuatl para ma monechcahui huan moquetzas noixtla, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Huan nopa totajtzi quicuis se achi atl tlen tlaiyocatlalili para na huan quitlalis ipan se xarro tlen soquitl, huan quimanelos ica se achi tlaltejpoctli tlen tlalchi tlen nopa yoyon tiopamitl campa nimocahua. ");
INSERT INTO nheBl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Huan teipa nopa totajtzi quichihuas para nopa sihuatl ma moquetza noixpa, niimoTECO, huan quitojtomas itzoncal. Huan nopa totajtzi quitlalis imaco nopa sihuatl ne tlacajcahualistli tlen harina pampa ihuehue moilhuía tlajtlacolchijtoc. Huan nopa totajtzi moquetzas iixpa nopa sihuatl huan quipixtos imaco nopa xarro ica nopa atl tlen chichic huan tlen quimaca se tlatelchihuali o se tlatzacuiltilistli tlen tlajtlacolchijtoc. ");
INSERT INTO nheBl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Huajca nopa totajtzi quichihuas para nopa sihuatl ma nechtestigojquetzas, niimoTECO, intla ax tlajtlacolchijtoc. Huan teipa nopa totajtzi quiilhuis: ‘Intla ax timocajtoc ica seyoc tlacatl quema ya tijpixqui mohuehue, niyon ax tleno tlen ax cuali tijchijtoc ica seyoc tlacatl, huajca ax tleno ma mopanti quema tiquis ni atl tlen chichic tlen quihualica tlatelchihualistli ipan tlen tlajtlacolchijtoc. ");
INSERT INTO nheBl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pero intla timochijtoc ax titlapajpactic huan titlaixpanotoc quema ya tijpixqui mohuehue huan timocajtoc ica seyoc tlacatl, ");
INSERT INTO nheBl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","huajca TOTECO ma mitztelchihuas huan ma mitztlatzacuiltis para nochi ma quiitaca. ");
INSERT INTO nheBl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Huan quema tiquis ni atl tlen chichic, quichihuas ma palanis mometztomahuiya huan ma samahuiya moijti huan ax huelis tiquinpiyas coneme.’ Huan nopa sihuatl quiijtos: ‘Queja nopa ma eli.’ ");
INSERT INTO nheBl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Huajca nopa totajtzi quiijcuilos ni tlatelchihualistli ipan se cuetlax amatl ica tinta huan teipa quiixpolos nopa tinta huan nopa tlajtoli ica nopa atl tlen chichic. ");
INSERT INTO nheBl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Teipa quichihuas para nopa sihuatl ma quii nopa atl tlen temaca se tlatelchihualistli ipan tlen tlajtlacolchijtoc. Huan nopa atl calaquis iijtico huan quichihuas chichic iijtic intla quipiya tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Huan teipa nopa totajtzi quiselis tlen imaco nopa sihuatl nopa tlacajcahualistli tlen harina, huan quihuisos iixtla TOTECO huan quihuicas campa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Huan quicuis se tlamajtzoli tlen nopa tlacajcahualistli tlen cebada huan quitlatis ipan nopa tlaixpamitl queja eliyaya nochi nopa tlacajcahualistli. “Huan teipa quema nopa totajtzi quichijtos nochi ni tlamantli, quimacas nopa atl ma quii. ");
INSERT INTO nheBl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Huan intla mochijtoc ax tlapajpactic huan quiixpanotoc ihuehue, nopa atl tlen quihualica tlatelchihualistli calaquis iijtico huan quichihuas para isihuayo ma temi huan imetztomahuiya ma palani. Huan nochi itlacajhua quiitase nopa sihuatl para tlatelchihuali. ");
INSERT INTO nheBl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pero intla nopa sihuatl ax quipiya tlajtlacoli, ax tleno oncas huan teipa cuali huelis conepiyas. ");
INSERT INTO nheBl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Huajca ya ni eli nopa tlanahuatili quema se quitlasomati isihua pampa mochijtoc ax tlapajpactic huan quiixpanotoc ihuehue quema ya monamictijtoya ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","O ya ni nojquiya para quema se tlacatl moilhuía para quiixpanotoc huan quitlasomati, huan quinequi quimatis tlen temachtli. Ihuehue quinextis isihua noixtla, niimoTECO, huan nopa totajtzi quichihuilis senquistoc queja quiijtohua ni tlanahuatili. ");
INSERT INTO nheBl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Huan ax elis itlajtlacol ihuehue intla quiajsis ni tlatelchihualistli, pampa eli nopa sihuatl itlajtlacol. Huan monequi quiijiyohuis nochi tlatzacuiltilistli.” ");
INSERT INTO nheBl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Huan sampa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Xiquinilhui nochi israelitame para quema se sihuatl o se tlacatl tlen quinequi noca mocahuas, na niimoTECO, para elis se nazareo huan moiyocatlalis para senquistoc elis noaxca, huan ax queja sequinoc sihuame o tlacame, ");
INSERT INTO nheBl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","huajca nopa tlacatl ax hueli quiis xocomeca atl o niyon se tlaili nelcococ. Niyon ax hueli quiis tlen quixocoltijtoque, niyon vinagre tlen quichijtoque ica xocomeca atl, o tlen cococ. Nojquiya ax huelis quicuas xocomecatl itlajca, niyon nopa xocomecatl tlen ya huactoc. ");
INSERT INTO nheBl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ipan nochi nopa tonali quema noca mocajtoc para moiyocacahuas queja se nazareo, ax tleno quicuas tlen huala ipan xocomecatl itlajca, niyon iyol, niyon ipetlayo. ");
INSERT INTO nheBl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ipan nochi nopa tonali quema moiyocacajtoc para na, ax hueli moximas. Yajaya elis tlatzejtzeloltic huan tlaiyocatlalili para na, niimoTECO, huan quicahuas ma moscalti huehueyac itzoncal hasta ma quitlamiltis nochi nopa tonali huan nopa tlamantli tlen nechilhuijtoc. ");
INSERT INTO nheBl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Huan ipan nochi nopa tonali quema moiyocatlalijtoc para na, ax hueli monechcahuis campa se mijcatzi, pampa mochihuas ax tlapajpactic noixpa. ");
INSERT INTO nheBl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Yonque miquis itata, inana, o se isihuaicni, o se itlacaicni, ma ax monechcahuis para mochihuas ax tlapajpactic pampa moiyocatlali para na, niimoTeco Dios, huan quipiyas itzoncal huehueyac tlen quiixnextía tlen noca mocajtoc. ");
INSERT INTO nheBl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Huan nochi tonali tlen huejcahuas tlen noca mocajtoc, monequi mocahuas tlatzejtzeloltic noixtla. ");
INSERT INTO nheBl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Huan intla nimantzi san huetzis mictoc se acajya tlen moquetza ihuaya, huajca, quena, quichihuilis ax tlapajpactic noixpa, yonque ax quinequiyaya mochihuas ax tlapajpactic. Huajca quema ajsis chicome tonali para mochijtoc ax tlapajpactic, quipiya para quitequis nochi itzoncal pampa itzoncal huehueyac quinextiyaya para tlaiyocatlalili para na. ");
INSERT INTO nheBl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Huan ipan ne chicueyi tonali, quinhualicas ome pilpichontzitzi, o ome pilpalomajtzitzi, huan quimacas nopa totajtzi campa ipuerta nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Huan nopa totajtzi nechtencahuilis nopa piltototzi queja se tlacajcahualistli ipampa tlajtlacoli, huan ne seyoc nechtencahuilis queja se tlacajcahualistli tlatlatili. Huan ica ya ni nechixtzacuilis itlajtlacol pampa itztoya nechca se mijcatzi. Huan nojquiya ipan nopa tonal sampa moiyocatlalis noca na, niimoTECO, huan sampa pehuas quicahuas ma moscalti itzoncal. ");
INSERT INTO nheBl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nopa tonali tlen ya panotoc quema achtohui moiyocatlalijtoya noca na, quiixpolo. Sampa monequi motemacas noca na para elis nazareo nochi tonali queja quichijqui achtohui. Huan monequi quihualicas se piloquich borregojtzi tlen san quipiya se xihuitl para nechtencahuilis queja se tlacajcahualistli pampa quihuica tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Huan quema ya tlamis nochi nopa tonali tlen motemacac para elis nazareo, ya ni nopa tlanahuatili tlen sesen monequi quitoquilis. Monequi hualas huan nechhualiquilis se tlacajcahualistli campa ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Nechtencahuilis se piloquich borregojtzi tlen san quipiya se xihuitl huan tlen ax tleno quipiya huan elis se tlacajcahualistli tlatlatili. Huan nojquiya nechmacas se pilsihua borregojtzi tlen san quipiya se xihuitl huan ax tleno quipiya huan nopa elis se tlacajcahualistli ipampa tlajtlacoli. Nojquiya nechtencahuilis se oquich borrego tlen ax tleno quipiya huan elis para se tlacajcahualistli para nimoyoltlalis ihuaya. ");
INSERT INTO nheBl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Nojquiya ihuaya, xinechmacaca nopa tlacajcahualistli tlen harina huan tlen tlatoyahuali tlen monequi nechmacase ihuaya. Huan monequi nopa tlacajcahualistli tlen harina elis se chiquihuitl temitoc ica pantzi tlen ax quipiya tlasonejcayotl. Quipiyas tortas tlen quichijtoque ica cuali harina maneltic ica aceite, huan nojquiya quipiyas pantzi tlen cacatztic tlen quixacualojtoque ica aceite. ");
INSERT INTO nheBl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Huan nopa totajtzi quitencahuas nochi ya ni noixtla ihuaya nopa tlacajcahualistli ipampa tlajtlacoli huan nopa tlacajcahualistli tlatlatili tlen ne nazareo quihualicac. ");
INSERT INTO nheBl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Huan nechmacas nopa oquich borrego huan nopa chiquihuitl ica pantzi tlen ax quipiya tlasonejcayotl, huan elis se tlacajcahualistli para tlayoltlalili nohuaya. Huan nopa totajtzi nojquiya nechmacas nopa tlacajcahualistli tlen harina huan tlen tlatoyahuali tlen ihuaya yohui. ");
INSERT INTO nheBl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Huan nopona campa ipuerta nopa yoyon tiopamitl campa timopantíaj, nopa nazareo monequi quiximas nochi itzoncal tlen quinextiyaya tlen noca mocajtoya, huan quicuis nochi nopa tzoncali huan quitlalis ipan nopa tlitl tlen eltoc itzala nopa tlacajcahualistli para tlayoltlalili nohuaya. ");
INSERT INTO nheBl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Huan teipa quema cuali motzoncaltectos ne nazareo, nopa totajtzi quicuis iajcol nopa oquich borrego tlen molontoya hasta cuali icsitoc, huan quitlalis imaco ne nazareo ihuaya se pantzi ica tlatzopelcayotl huan se pantzi tlen cacatztic tlen eltoc ipan nopa chiquihuitl huan tlen ax quipiya tlasonejcayotl. ");
INSERT INTO nheBl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Huan teipa nopa totajtzi quicuis huan quitlejcoltis huan quihuisos nopa tlacajcahualistli noixtla, niimoTECO, para ma eli se tlacajcahualistli tlahuisoli. Huan nochi nopa tlacajcahualistli mochihuas tlatzejtzeloltic huan elis iaxca nopa totajtzi, ica nopa pantzi ihuaya ielchiqui huan iajcol nacayo nopa borrego tlen tlahuisoli. Huan teipa quema nopa totajtzi tlamis nechtencahuilía nochi noixtla, ya tlen eliyaya nazareo huelis quiis xocomeca atl pampa ya tlanqui tlen noca mocajqui, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Huajca ya ni elqui nopa tlanahuatili para se nazareo, huan inmechilhuía tlaque tlacajcahualistli monequi innechtencahuilise quema se quitlamichihuas tlen noca mocajtoc para quichihuas. Nojquiya monequi quihualicas nochi sequinoc tlacajcahualistli tlen nechilhui nechmactilis quema moiyocatlali huan mochijqui nazareo.” ");
INSERT INTO nheBl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Xiquilhui Aarón ininhuaya iconehua para ma quintiochihuaca israelitame ica ni tlajtoli. Ma quiijtoca: ");
INSERT INTO nheBl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Ma TOTECO mitztiochihua huan ma mitzmocuitlahui. ");
INSERT INTO nheBl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ma cahuani ixayac TOTECO ica paquilistli quema moilhuía tlen ta. Ma quipiya hueyi iyolo mohuaya. ");
INSERT INTO nheBl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ma TOTECO mitznextili itlaicnelijcayo huan ma mitzmaca itlasehuilis ipan moyolo.’ ");
INSERT INTO nheBl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ica ni tlajtoli, Aarón huan iconehua nechnotzase ma niquintiochihua israelitame huan, quena, na niquintiochihuas para nochi quimatise inijuanti noaxcahua.” ");
INSERT INTO nheBl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Huan ipan nopa tonali quema Moisés quitlamisencajtoya nopa yoyon tiopamitl campa TOTECO mocahuasquía ininhuaya, quiatzejtzelhui ica aceite sesen tlamantli tlen mocajqui calijtic, huan quiiyocatlali para TOTECO. Nojquiya quiatzejtzelhui ica aceite nopa tlaixpamitl huan nochi tlen motequihuía nopona. ");
INSERT INTO nheBl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Teipa yajque nopa tlayacanca israelitame ipan sesen hueyi familia tlen tlapalehuijtoyaj para quitlalanque nopa censo. ");
INSERT INTO nheBl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Huan quitlalitoj iixtla TOTECO nochi tlen quinequiyayaj quimactilise. Huan sesen nopa tlayacanani quihualicac se hueyi toro. Huan sese ome tlayacanani quihualicaque se cuacarro. Huajca ica nochi nopa ofrendas tlen quihualicaque elqui chicuase cuacarros tlen tzactoque, huan 12 huejhueyi torojme tlen quimatij tlatilanase huan quimacaque TOTECO iteno ipuerta nopa yoyon tiopamitl campa mocahua TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nheBl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Xiquinselili nopa cuacarros huan nopa huejhueyi torojme tlen quimatij tlatilanaj, huan xiquinmaca nopa levitame para ma quintequihuica ipan nochi nopa tequitl tlen monequi para quihuicase tlen eltoc ipan nopa yoyon tiopamitl campa timopantíaj. Xijmaca sesen levita nopa tlamantzitzi tlen monequi quitequihuis ipan itequi tlen quitocarohua quichihuas.” ");
INSERT INTO nheBl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Huajca Moisés quinseli nopa cuacarros huan nopa huejhueyi torojme huan quinmajmacac nopa levitame. ");
INSERT INTO nheBl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Iixhuihua Gersón quinmacac ome cuacarros huan nahui huejhueyi torojme para quitequihuise ipan inintequi. ");
INSERT INTO nheBl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Huan iixhuihua Merari quinmacac nahui cuacarros huan chicueyi huejhueyi torojme para quitequihuise ipan inintequi ica imaco Itamar, icone nopa totajtzi Aarón. ");
INSERT INTO nheBl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Pero iixhuihua Coat ax quinmacac niyon se cuacarro huan niyon se toro, pampa monejqui quihuicase iniajcolpa nopa tlamantli tlatzejtzeloltique tlen mocajqui ininmaco para quimocuitlahuise. ");
INSERT INTO nheBl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Huan nojquiya quema ajsic tonal para quiiyocatlalise nopa tlaixpamitl para TOTECO huan quitlatzejtzelolchihuase, sesen nopa tlayacanani tlen nochi huejhueyi familias quihuicaque se ofrendas huan quitlalijque iixtla nopa tlaixpamitl. ");
INSERT INTO nheBl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Huan TOTECO quiilhui Moisés: “Mojmostla ipan sesen tonal quema inquitlatzejtzelolchihuaj nopa tlaixpamitl, xijcahua san se tlayacanquetl ma nechtemactili tlen quihualicac.” ");
INSERT INTO nheBl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Huajca ipan nopa achtohui tonali, quitemactili iregalo Naasón, icone Aminadab, ipan nopa hueyi familia Judá. ");
INSERT INTO nheBl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Huan iregalo eliyaya se hueyi plato ixpelentic tlen plata huan ietica eliyaya se kilo huan tlajco, ihuaya se hueyi taza tlen plata ica ietica queja tlajco kilo ipan itlayejyecol nopa yoyon tiopamitl. Huan nopa plato huan nopa hueyi taza quihualicac temitoc ica harina tlen achi más cuali maneltic ica aceite para se tlacajcahualistli tlen harina. ");
INSERT INTO nheBl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Nojquiya quihualicac se cuchara tlen senquistoc oro ica 110 gramos ietica, huan temitoya ica copali. ");
INSERT INTO nheBl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Huan quihualicac se becerro, se oquich borrego huan se piloquich borregojtzi tlen san quipiya se xihuitl para elise se tlacajcahualistli tlatlatili. ");
INSERT INTO nheBl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Nojquiya quihualicac se oquich chivo para se tlacajcahualistli ipampa tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Huan para se tlacajcahualistli para ma onca tlayoltlalili ihuaya TOTECO, quinhualicac ome huejhueyi torojme tlen quimatij tlatilanaj, macuili oquich borregojme, macuili oquich chivojme huan macuili piloquich borregojtzitzi tlen san quipiyaj se xihuitl. Nochi ya ni elqui nopa regalos tlen Naasón, icone Aminadab, quihualicac. ");
INSERT INTO nheBl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ipan ome tonali quihuicac iregalo Natanael, icone Zuar, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Isacar. ");
INSERT INTO nheBl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","23","Huan iregalo tlen quitemactili elqui senquistoc san se queja tlen temacac Naasón. ");
INSERT INTO nheBl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ipan eyi tonali quihuicac se regalo Eliab, icone Helón, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Zabulón. ");
INSERT INTO nheBl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","29","Huan quitemactili iregalo tlen elqui senquistoc san se queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ipan nahui tonali quihuicac se regalo Elisur, icone Sedeur, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Rubén. ");
INSERT INTO nheBl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","35","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ipan macuili tonali quihuicac se regalo Selumiel, icone Zurisadai, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Simeón. ");
INSERT INTO nheBl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","41","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ipan chicuasen tonali quihuicac se regalo Eliasaf, icone Reuel, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Gad. ");
INSERT INTO nheBl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","47","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ipan chicome tonali quihuicac se regalo Elisama, icone Amiud, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Efraín. ");
INSERT INTO nheBl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","53","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ipan chicueyi tonali quihuicac se regalo Gamaliel, icone Pedasur, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Manasés. ");
INSERT INTO nheBl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","59","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ipan chicnahui tonali quihuicac se regalo Abidán, icone Gedeoni, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Benjamín. ");
INSERT INTO nheBl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","65","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ipan majtlactli tonali quihuicac se regalo Ahiezer, icone Amisadai, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Dan. ");
INSERT INTO nheBl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","71","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ipan majtlactli huan se tonali quihuicac se regalo Pagiel, icone Ocrán, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Aser. ");
INSERT INTO nheBl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","77","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ipan majtlactli huan ome tonali quihuicac se regalo Ahira, icone Enán, tlen eliyaya tlayacanquetl ipan nopa hueyi familia Neftalí. ");
INSERT INTO nheBl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","83","Huan quitemactili nojquiya san se iregalo queja ne sequinoc. ");
INSERT INTO nheBl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Nochi ya ni elqui nopa regalo tlen nopa tlayacanani tlen israelitame quitemactilijque para quiiyocatlalise nopa tlaixpamitl para TOTECO huan quitlatzejtzelolchihuase. Ica nochi elqui 12 huejhueyi platos tlen ixpelentique tlen plata, 12 huajcali tlen plata, huan 12 huejhueyi cucharas tlen oro. ");
INSERT INTO nheBl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Huan sesen plato quipixqui se kilo huan tlajco ietica, huan sesen huajcali tlen plata quipixqui tlajco kilo ietica. Ica nochi nopa tlamantli tlen plata quipixqui nechca 26 kilos ietica ipan itlayejyecol nopa yoyon tiopamitl. ");
INSERT INTO nheBl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Nojquiya oncayaya 12 cucharas tlen oro temitoya ica copali tlen quipixqui 110 gramos ietica ipan itlayejyecol nopa yoyon tiopamitl. Nopa oro tlen nochi nopa cucharas quipixqui se kilo huan 320 gramos ietica. ");
INSERT INTO nheBl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Huan nopa tlapiyalime para tlacajcahualistli tlatlatili elque ica nochi 12 becerros, 12 oquich borregojme, 12 piloquich borregojtzitzi tlen san quipiyaj se xihuitl ihuaya nopa 12 tlacajcahualistli tlen harina tlen monequiyaya ininhuaya, huan 12 oquich chivojme para quinmacase queja tlacajcahualistli ipampa tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Huan nochi nopa tlapiyalime tlen quihualicaque para tlacajcahualistli para tlayoltlalili elqui ica nochi 24 becerros, 60 oquich borregojme, 60 oquich chivojme huan 60 piloquich borregojtzitzi tlen san quipixque se xihuitl. Nochi ya ni elqui tlen quimactilijque TOTECO quema quiiyocacahuayayaj huan quitlatzejtzelolchihuayayaj nopa tlaixpamitl para TOTECO. ");
INSERT INTO nheBl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Huan Moisés quicaquiyaya itos Toteco Dios quema calaquiyaya para quicamahuis ipan nopa yoyon tiopamitl campa mopantiyaya ihuaya. Huan caquistic itos quisayaya tlen tlatlajco nopa ome elhuicac ehuani tlen inintoca querubines tlen moquetztoyaj iixco itzajca icaxa. Huajca nopona Toteco Dios quicamahui Moisés. ");
INSERT INTO nheBl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Huan TOTECO quicamahui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Xiquilhui Aarón quema quintlalis nochi tlahuili, ma quichihua para ma tlahui ica iixmelac tlen nopa tlahuil quetzali.” ");
INSERT INTO nheBl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Huan quichijqui Aarón nochi tlen TOTECO quinahuatijtoya Moisés, huan quinsencajqui nochi tlahuili para ma tlahui ica iixmelac. ");
INSERT INTO nheBl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Huan nopa tlahuil quetzali quichijchijtoyaj ica senquistoc oro tlen quitejtejtzontoyaj san ica martillo. Iicxi hasta iyecapa campa quichihuilijtoyaj ixochiyo, nochi quichijque san ica martillo. Nochi iyejyejca nopa tlahuil quetzali elqui senquistoc queja TOTECO quinextilijtoya Moisés ma quichihua. ");
INSERT INTO nheBl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Huan TOTECO quicamahui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Xiquinquixti nochi iteipa ixhuihua Leví tlen ne sequinoc israelitame huan xiquintlapajpacchihua noixtla para nechtequipanose. ");
INSERT INTO nheBl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ya ni tlen tijchihuas: Xiquinatzejtzelhuis ica atl tlen tetlapajpacchihua noixtla. Teipa moximase huan mohuatanise hasta moquixtilise nochi tzoncali ipan inintlacayo. Teipa maltise, huan cuali quichicuenise ininyoyo, huan queja nopa elise tlapajpacme para nechtequipanose. ");
INSERT INTO nheBl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Teipa ma quihualicaca se becerro huan nopa tlacajcahualistli tlen harina tlen ihuaya yohui. Ya nopa elis cuali harina maneltic ica aceite. Huan nojquiya quihuicase seyoc becerro para se tlacajcahualistli ipampa tlajtlacoli. ");
INSERT INTO nheBl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ta tijchihuas para nopa levitame ma monechcahuica ipuertajteno ni yoyon tiopamitl campa timopantíaj huan nochi israelitame nojquiya nopona ma mosentilica. ");
INSERT INTO nheBl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Teipa xijchihua para nopa levitame ma moixnextica noixtla huan nopa sequinoc israelitame ma quintlalilica ininma ipan inintzonteco. ");
INSERT INTO nheBl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Huan Aarón quinixnextis nochi levitame noixtla na, niimoTECO, queja se hueyi tlacajcahualistli tlahuisoli tlen nochi israelitame nechmacaj na, niimoTECO. Huan ica ya nopa quiniyocatlalis nochi levitame para nechtequipanose. ");
INSERT INTO nheBl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Teipa nochi levitame quitlalise ininma ipan inintzonteco nopa becerros. Teipa nechtencahuilise se becerro queja se tlacajcahualistli ipampa tlajtlacoli huan seyoc becerro nechmactilise queja se tlacajcahualistli tlatlatili para na, niimoTECO, para nechixtzacuilise inintlajtlacolhua nochi levitame. ");
INSERT INTO nheBl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Huan teipa xiquintlali nochi nopa levitame para ma moquetzaca iniixtla Aarón huan itelpocahua, huan nochi yajaya nechmacas queja se tlacajcahualistli majcahuali para na, niimoTECO. ");
INSERT INTO nheBl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Huan quej ni tiquiniyocatlalis nopa levitame tlen nochi sequinoc israelitame, huan nochi levitame elise noaxcahua. ");
INSERT INTO nheBl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Huan quema ya inquintlapajpacchijtoque nopa levitame huan inquinnextijtoque noixtla queja se tlacajcahualistli majcahuali, inijuanti hueli calaquise para nechtequipanose ipan ni yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","“Pampa nochi levitame senquistoc noaxcahua huan ax queja sequinoc israelitame, pampa nimocuili nochi levitame ininpatlaca nochi ininconehua israelitame tlen achtohui ehuani tlen monequiyaya nechmactilisquíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Pampa nelía noaxcahua nochi tlen achtohui tlacatij tlen israelitame, yonque ininconehua o inintlapiyalhua, nochi tlen achtohui tlacatij noaxcahua. Pampa huejcajquiya quema niquinmijmicti nochi coneme tlen achtohui ejque ipan tlali Egipto, niquiniyocatlali para noaxcahua nochi coneme tlen achtohui ehuani tlen israelitame. ");
INSERT INTO nheBl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Pero ama queja ininpatlaca nopa achtohui ehuani tlen nochi israelita coneme, nimoaxcatijtoc nochi levitame para noaxcahua. ");
INSERT INTO nheBl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Huan ama niquinmaca nochi levitame tlen nochi sequinoc israelitame para ma elica se regalo para Aarón huan itelpocahua para quinpalehuise quichihuase nopa tequitl tlatzejtzeloltic ipan ni yoyon tiopamitl campa timopantíaj. Huan nopa levitame tequitise ininpatlaca sequinoc israelitame. Huan nechtencahuilise inintlacajcahualis nopa sequinoc israelitame para quiixtzacuase inintlajtlacolhua noixtla na, niimoTECO. Huan quej ni, tlen hueli israelita ax calaquis ipan ni yoyon tiopamitl para tlapalehuis para ax quinajsis israelitame se hueyi cocolistli tlen ica miquise.” ");
INSERT INTO nheBl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Huajca Moisés, Aarón huan nochi israelitame quichijque ica nopa levitame nochi tlen TOTECO quinahuatijtoya Moisés ma quichihuaca. ");
INSERT INTO nheBl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Huan nochi levitame motlapajpacchijque huan quichicuenijque ininyoyo, huan Aarón quinpannexti iixtla TOTECO queja se tlacajcahualistli majcahuali. Huan Aarón nojquiya quitencajqui iixtla se tlacajcahualistli para quinixtzacuilis inintlajtlacolhua para ma elica tlapajpacme iixtla. ");
INSERT INTO nheBl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Huajca quema tlanqui nochi ni tlamantli tlen mochijqui, nopa levitame pejque calaquij para quichihuase nochi inintequi ipan nopa yoyon tiopamitl campa timopantíaj ihuaya TOTECO, huan tequitique inintempa Aarón huan itelpocahua. Huan nochi quichijque senquistoc queja TOTECO quinahuatijtoya Moisés ma quinchihuili nopa levitame. ");
INSERT INTO nheBl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","TOTECO nojquiya quicamahui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Nochi levitame quema quiaxitijtose 25 xihuitl, monequi quipehualtise para nechtequipanose ipan ni yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nheBl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Huan quisase ipan nopa tequitl quema quiaxitise 50 xihuitl. ");
INSERT INTO nheBl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Teipa quema ya quiaxitijtose nopa xihuitl para mosehuise, huelis quinpalehuise ininhuampoyohua ica tequitl tlen ax ohui, pero nopa tequitl tlen ohui ayoc ma quichihuaca. Queja nopa inquintequimacase levitame.” ");
INSERT INTO nheBl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Quema TOTECO quicamahui Moisés huan quiilhui nochi ni tlajtoli ya tlantoya se xihuitl para quistejque tlen tlali Egipto. Ya calaquiyaya ipan nopa achtohui metztli ipan ome xihuitl. Huan ipan nopa tonali nopa israelitame itztoyaj ipan nopa huactoc tlali Sinaí huan nojquiya TOTECO quiilhui ni tlajtoli: ");
INSERT INTO nheBl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Sesen xihuitl monequi nochi israelitame quinextise nopa ilhuitl tlen itoca Pascua ipan nopa tonal tlen nimechnahuatijtoc. ");
INSERT INTO nheBl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Quema ya tiotlaquixtos ipan 14 itequi ni metztli tlen achtohui ipan toxihui, inquitoquilise nopa tlanahuatili queja ijcuilijtoc. Senquistoc queja nimechnextilijtoc para inquichihuase, ya nopa inquichihuase.” ");
INSERT INTO nheBl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Huajca Moisés quinnahuati nopa israelitame ma quinextica nopa Pascua Ilhuitl. ");
INSERT INTO nheBl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Huan nopona ipan nopa huactoc tlali tlen itoca Sinaí quema tiotlaquixtoya ipan 14 itequi nopa achtohui metztli ipan nopa xihuitl, inijuanti ilhuichijque senquistoc queja TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nheBl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Pero itztoyaj sequin tlacame tlen mochijtoyaj ax tlapajpacme iixpa TOTECO pampa quiitzquitoyaj se mijcatzi, huan yeca ax huelque quichihuase nopa Pascua Ilhuitl ipan nopa tonali. Huajca yajque quiitatoj Moisés ihuaya Aarón ipan nopa tonali, ");
INSERT INTO nheBl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","huan quinilhuijque: ―Yonque tiquitzquitoque se mijcatzi, huan timochijtoque ax titlapajpactique iixpa TOTECO, ¿para tlen ax huelis tijtencahuilise se regalo iixtla TOTECO ipan ni tonali quema nochi israelitame quichihuaj ni Pascua Ilhuitl? ");
INSERT INTO nheBl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Huan Moisés quinnanquili: ―Ximochiyaca hasta TOTECO nechilhuis tlaque cuali para mochihuas quema queja ni pano. ");
INSERT INTO nheBl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Huan TOTECO quicamahui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Xiquinilhui nopa israelitame quema inijuanti o se inincone ax hueli quinextise nopa ilhuitl Pascua ica nochi sequinoc, huelis quichihuase teipa. Intla se ax hueli quichihuas quema monequi pampa monejqui quiitzquis se mijcatzi huan yeca ax tlapajpactic o huelis se mopantía huejca tlen ichaj quema sequinoc ilhuichihuaj, yajaya hueli quinextise nopa ilhuitl teipa. ");
INSERT INTO nheBl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Pero quichihuase quema tiotlaquixtos ipan 14 itequi nopa ome metztli ipan ne xihuitl. Monequi quicuase nopa pilborregojtzi ica xihuitl tlen chichic huan pantzi tlen ax quipiya tlasonejcayotl. ");
INSERT INTO nheBl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Huan ax tleno quicahuase para seyoc tonali, niyon ax quipostequilise niyon se iomiyo nopa pilborregojtzi. Ma quinextica nopa Pascua senquistoc queja nimechnextilijtoc inquichihuase. ");
INSERT INTO nheBl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Pero intla se acajya yonque tlapajpactic huan ax cana yajtoc, san moilhuis para ax quichihuas nopa Pascua Ilhuitl, monequi inquiquixtise para ayoc huelis itztos imohuaya inisraelitame. Queja nopa inquichihuase, pampa ax nechtencahuili nopa tlacajcahualistli noixtla ipan nopa tonal quema, niimoTECO, nijtlali, huan huajca monequi quiselis nopa tlatzacuiltilistli ipampa itlajtlacol. ");
INSERT INTO nheBl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Nochi seyoc tlali ehuani tlen itztoque imohuaya nojquiya monequi quinextise nopa Pascua para na queja nimechnextilijtoc. Onca san se tlanahuatili para israelitame huan seyoc tlali ehuani para quejatza quichihuase, huan nochi san se monequi quitoquilise.” ");
INSERT INTO nheBl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ipan nopa tonal quema tlanque quiquetzaj nopa yoyon tiopamitl tlen quipixqui nopa tlajtoli tlen quichijtoya ininhuaya, se hueyi mixtli hualajqui quitzacuaco. Huan quema pejqui tiotlaquiya, nopa mixtli mopatlac para nesis queja se tlilelemectli itzonpac nopa tiopamitl huan queja nopa eltoya hasta tlanesiyaya. ");
INSERT INTO nheBl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Huan quej ni eliyaya nochipa. Ica tonaya se mixtli quitzacuayaya nopa yoyon tiopamitl huan ica tlayohua nesiyaya queja se hueyi tlitl. ");
INSERT INTO nheBl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Quema nopa mixtli mijcueniyaya tlen nopa yoyon tiopamitl, nopa israelitame quistehuayayaj huan quitoquilijtiyohuiyayaj. Huan quema nopa mixtli moquetzayaya huan ayoc nejnemiyaya, nopona nopa israelitame quiquetzayayaj ininyoyoncalhua. ");
INSERT INTO nheBl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Quej ni nopa israelitame mijcueniyayaj quema TOTECO quinnahuatiyaya, huan moquetzayayaj san campa quinilhuiyaya. Nochi tonali quema nopa mixtli mocahuayaya itzonpac nopa tiopamitl, ax quistehuayayaj. ");
INSERT INTO nheBl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Huan yonque nopa mixtli mocahuasquía ipan tiopamitl miyac tonali huan ax mijcueniyaya, nochi israelitame quineltoquiliyayaj itlanahuatil TOTECO huan ax nejnemiyayaj. ");
INSERT INTO nheBl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Huan quema nopa mixtli ax mocajqui miyac tonali, nopa israelitame ax mocajque miyac tonali, pampa queja nopa TOTECO quinnextilijtoya. ");
INSERT INTO nheBl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Huan quema nopa mixtli moquetzayaya tlen se tiotlac hasta ijnaloc, huajca nopa israelitame moquetzayayaj. Huan quema ica ijnaloc nopa mixtli motlalanayaya, inijuanti nojquiya motlalanayayaj huan quitoquiliyayaj. Pero yonque tonaya o tlayohua mijcueniyaya nopa mixtli, inijuanti quistehuayayaj para quitoquilise senquistoc queja TOTECO tlanahuatijtoya. ");
INSERT INTO nheBl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Yonque nopa mixtli moquetzayaya ipan nopa yoyon tiopamitl campa TOTECO itztoya se ome tonali, o se metztli, o se xihuitl, nopona nochi nopa israelitame mocahuayayaj huan ayoc nejnemiyayaj. Pero quema nopa mixtli motlalanayaya, inijuanti quistehuayayaj huan quitoquiliyayaj. ");
INSERT INTO nheBl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Huajca quema TOTECO quinnahuatiyaya ma quiquetzaca ininyoyoncalhua, inijuanti quinquetzayayaj. Huan quema TOTECO quinnahuatiyaya ma nejnemica para quitoquilise nopa mixtli, quistehuayayaj. Quineltoquilijque nochi tlen TOTECO quinahuati Moisés ma quichihuaca. ");
INSERT INTO nheBl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Huan TOTECO quicamahui Moisés huan quiilhui: ");
INSERT INTO nheBl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Xijchihua om