﻿USE sofia;
DROP TABLE IF EXISTS sofia.nguNT_vpl;
CREATE TABLE nguNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nguNT_vpl WRITE;
INSERT INTO nguNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","In se tocayomej de itajhuehuentzitzihuan Jesucristo yejhuan teicniu itech David niman Abraham. ");
INSERT INTO nguNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham tajtli catca itech Isaac, niman Isaac tajtli catca itech Jacob, niman Jacob tajtli catca intech Judá niman icnihuan Judá. ");
INSERT INTO nguNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá tajtli catca intech Fares niman Zara, niman innan Fares niman Zara itoca catca Tamar. Fares tajtli catca itech Esrom, niman Esrom tajtli catca itech Aram. ");
INSERT INTO nguNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram tajtli catca itech Aminadab, niman Aminadab tajtli catca itech Naasón, niman Naasón tajtli catca itech Salmón. ");
INSERT INTO nguNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón tajtli catca itech Booz, niman inan Booz itoca catca Rahab. Booz tajtli catca itech Obed, niman inan Obed itoca catca Rut. Obed tajtli catca itech Isaí, ");
INSERT INTO nguNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","niman Isaí tajtli catca itech rey David. Rey David tajtli catca itech Salomón, niman inan Salomón cahuajli catca itech Urías. ");
INSERT INTO nguNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón tajtli catca itech Roboam, niman Roboam tajtli catca itech Abías, niman Abías tajtli catca itech Asa. ");
INSERT INTO nguNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tajtli catca itech Josafat, niman Josafat tajtli catca itech Joram, niman Joram tajtli catca itech Uzías. ");
INSERT INTO nguNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías tajtli catca itech Jotam, niman Jotam tajtli catca itech Acaz, niman Acaz tajtli catca itech Ezequías. ");
INSERT INTO nguNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías tajtli catca itech Manasés, niman Manasés tajtli catca itech Amón, niman Amón tajtli catca itech Josías. ");
INSERT INTO nguNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías tajtli catca intech Jeconías niman icnihuan. Niman yejhuamej nemiyaj ipan on tonaltin ijcuac on hebreos oquimajsiquej niman oquintzacuatoj ne ipan on país itoca Babilonia. ");
INSERT INTO nguNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ijcuac on hebreos yoquintzacuatoj ne ipan on país itoca Babilonia, Jeconías onochiu tajtli itech Salatiel, niman Salatiel onochiu tajtli itech Zorobabel. ");
INSERT INTO nguNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel tajtli catca itech Abiud, niman Abiud tajtli catca itech Eliaquim, niman Eliaquim tajtli catca itech Azor. ");
INSERT INTO nguNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor tajtli catca itech Sadoc, niman Sadoc tajtli catca itech Aquim, niman Aquim tajtli catca itech Eliud. ");
INSERT INTO nguNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud tajtli catca itech Eleazar, niman Eleazar tajtli catca itech Matán, niman Matán tajtli catca itech Jacob. ");
INSERT INTO nguNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob tajtli catca itech José yejhuan ihuehuentzin catca María, niman María nantli catca itech Jesús. Yejhua no itoca Cristo yejhuan quijtosnequi on yejhuan Dios quitlalia para tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yejhua ica, tej, Abraham hasta David, onochiu majtlactli huan nahui itajhuehuentzitzihuan Cristo. Niman David hasta on tonaltin ijcuac on hebreos oquimajsiquej niman oquintzacuatoj ne Babilonia, no onochiu majtlactli huan nahui itajhuehuentzitzihuan Cristo. Niman desde on tonaltin ijcuac on hebreos oquimajsiquej niman oquintzacuatoj ne Babilonia hasta onen Cristo, no ijqui onochiu majtlactli huan nahui itajhuehuentzitzihuan Cristo. ");
INSERT INTO nguNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ijquin otlacat Jesucristo. María, on inan, yoquitlalijca compromiso para nonamictis ihuan José. Pero ijcuac xe san secan nemij, yejhua oquimat ica yocan se conetzintli. On conetzintli quitlacatilis ipampa ipoder on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, on yejhuan más saquin ihuan ononamictij María, yejhua se tlacatl catca yejhuan nochipa oquichiu on tlen cuajli. Pero yejhua xoquinec para quipinajtis María. Yejhua ica José quinemiliaya san quichtacatlalcahuis para on tlacamej xquimatisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Niman chica yejhua ijquin quinemiliaya, se ilhuicactequitquetl yejhuan toTeco ocuajtitlan oquinotitij itemicpan niman oquijlij: ―José, huejca teixhuiu David, ma ca xmomojti ticselis María para mosihuau, pampa on conetzintli yejhuan quitlacatilis, quitlacatilis ipampa on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María quitlacatilis se conetzintli, niman tictocayotis Jesús pampa yejhua quinmaquixtis ican intlajtlacolhuan on yejhuan quineltocasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nochi yejhua in onochiu para otenquisquej on tlen toTeco oquijtoca itechcopa on tiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Yejhua oquijtoj: Sen ichpochtli yejhuan xe yacaj tlacatl quinixmachtia canas iconetzin, niman quitlacatilis se oquichconetl. Niman on oquichconetl itoca yes Emanuel. Emanuel quijtosnequi: Dios tohuan nemi. ");
INSERT INTO nguNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ijcuac José otlachix, ihuan ononamictij María quen on ilhuicactequitquetl yejhuan toTeco ocuajtitlan oquinahuatij. ");
INSERT INTO nguNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero José ihuan María xnemiyaj quen on yejhuan yononamictijquej masqui ihuan nemiya, yej hasta ijcuac otlacat on conetzintli. Niman ijcuac otlacat on conetzintli, José oquitocayotij Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ijcuac Herodes rey catca, Jesús otlacat ne ipan on pueblo itoca Belén yejhuan oncaj ne Judea. Niman más saquin, oyejcoquej ne ipan on hueyican itoca Jerusalén sequimej tlacamej yejhuan intoca magos. Yejhuamej ohualejquej ipan on país yejhuan nocahua ne iquisayan on tonajli. ");
INSERT INTO nguNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yejhuamej otlajtlanquej: ―¿Canon nemi inrey on hebreos yejhuan quemach otlacat? Tej, desde ne ipan topaís yejhuan oncaj ne iquisayan on tonajli, otiquitaquej on sitlalin yejhuan otechititij ica yotlacat on rey. Yejhua ica otihualajquej para ticmahuistilisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ijcuac on rey Herodes ijcon ocac, sanoyej onomojtij, niman nochi tlacatl ne Jerusalén no onomojtij. ");
INSERT INTO nguNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Quemaj on rey oquinnotz nochimej on tlayecanquej tiopixquej niman on yejhuan quinmachtiayaj on tlacamej ica on tlanahuatiltin, niman oquintlajtoltij canon tlacatis yejhua on Cristo yejhuan quitenehuaj Dios quitlapejpenia para tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yejhuamej oquijlijquej: ―Tlacatis ipan on pueblo itoca Belén yejhuan oncaj ne Judea, pampa on tiotlajtojquetl ijquin oquijcuiloj: ");
INSERT INTO nguNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Tejhua Belén yejhuan tioncaj ne ipan iregión Judá xtejhua más tipitentzin intzajlan on ocsequimej huejhueyican niman pueblos, pampa motech Belén quisas se tlayecanquetl yejhuan quinyecanas on noconehuan hebreos. ");
INSERT INTO nguNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Quemaj Herodes oquimichtacanotz on magos, niman oquintlajtoltij tlen tonajli ones on sitlalin. ");
INSERT INTO nguNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Quemaj oquintitlan ne Belén ica in tlanahuatijli, oquimijlij: ―Xhuiyan ne Belén, niman cuajli xtejtemocan on conetzintli. Ijcuac nenquinextisquej, xnechijlijtiquisacan para nejhua no nias niconmahuistilis. ");
INSERT INTO nguNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ijcuac ocacquej on itlanahuatil on rey, on magos oyajquej. Niman on sitlalin yejhuan oquitaquej ne ipan impaís yejhuan oncaj ne iquisayan on tonajli yaya inyecapan, niman onoteltito ne campa nemiya on conetzintli. ");
INSERT INTO nguNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ijcuac on magos oquitaquej onoteltij on sitlalin, sanoyej ocuelitaquej niman sanoyej opaquilistlamatquej. ");
INSERT INTO nguNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yejhuamej ocalaquitoj ne ipan on cajli, niman oquitaquej on conetzintli ihuan María on inan. Quemaj onotlacuenquetzquej ixpan on conetzintli niman oquimahuistilijquej. Quemaj oquitlapojquej on incaja niman oquitlayocolijquej copajli yejhuan tlatla, incienso niman mirra. ");
INSERT INTO nguNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ijcuac ye quisasquiaj para yasquej ne impaís, Dios oquinnahuatij ipan se temictli ma ca nocuepacan itech on rey Herodes. Yejhua ica on magos onocuepquej ne impaís ipan ocse ojtli. ");
INSERT INTO nguNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ijcuac yoyajquej on magos, se ilhuicactequitquetl yejhuan toTeco ocuajtitlan oquinotitij José itemicpan, niman oquijlij: ―Xmoquetztehua niman xcuica on conetzintli niman inan ne Egipto. Ompa xnemican hasta ijcuac nimitzijlis ica cuajli para nenquisasquej, pampa Herodes quitejtemos on conetzintli para quimictis. ");
INSERT INTO nguNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yejhua ica José onoquetzteu sa no ipan on tlayohua, niman oquejcuanij on conetzintli ihuan inanaj, niman ocajsiquej on ojtli para oyajquej ne Egipto. ");
INSERT INTO nguNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ompa onenquej hasta ijcuac omic Herodes. Yejhua in onochiu para otenquis on tlen oquijtojca on toTeco itechcopa on tiotlajtojquetl. Yejhua oquijtoj: “Onicnotz noconeu para ma quisa ne Egipto.” ");
INSERT INTO nguNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ijcuac Herodes oquimat ica on magos yej oquelcahuijquej, sanoyej ocualan, niman oquinnahuatij isoldados para ma quinmictican nochi on oquichcoconej de ome xipan para tlatzintlan yejhuan chantiyaj ne Belén niman iyehualican. Yejhua san ipan nohuicaya on tonajli yejhuan on magos oquijlijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ijcuac nochi on coconej yomiquej, onochiu on tlen onijtoj itechcopa on tiotlajtojquetl Jeremías ijcuac oquijcuiloj: ");
INSERT INTO nguNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ocaquistic se ajmancatzajtzilistli ne ipan on pueblo itoca Ramá. Oncatca choquistli niman hueyi nejeltilistli, pampa Raquel chocaya impampa iconehuan. Yejhua xoquinec onoyoltlalij, pampa nochi iconehuan omiquej. ");
INSERT INTO nguNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero más saquin, ijcuac Herodes yomic, se ilhuicactequitquetl yejhuan toTeco ocuajtitlan oquinotitij ipan temictli José ne Egipto, niman oquijlij: ");
INSERT INTO nguNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Xmoquetztehua, niman xmocuepa ihuan on conetzintli niman inan ne ipan on mopaís Israel, pampa on yejhuan quinequiya quimictis on conetzintli aman yomic. ");
INSERT INTO nguNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Quemaj José onoquetzteu niman ocuicac on conetzintli ihuan inan ne Israel. ");
INSERT INTO nguNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero ijcuac José oquimat ica Arquelao tequihuajtiticaj ne Judea campa tequihuaj catca Herodes on itaj, onomojtij ompa chantis. Quemaj Dios oquinahuatij ipan se temictli ma huiya ne Galilea, niman yejhua ompa oyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ijcuac ompa oajsiquej, ochantitoj ne ipan on pueblo itoca Nazaret. Yejhua in onochiu san para otenquis on tlen oquijtojca on tiotlajtojquetl ijcuac oquijcuiloj ica Jesús quitocayotisquej nazareno. ");
INSERT INTO nguNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ipan on tonaltin, Juan on yejhuan tlacuatequijquetl ohuajlaj ipan itlapatlaco Judea, niman oquinmachtij on tlacamej yejhuan itech ohualajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Quijtohuaya: ―Xcajcahuacan ica nenquichihuaj on tlen xcuajli, pampa ye huajlau on tonaltin ijcuac Dios tlamandaros nican quen tlamandarohua ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","On tiotlajtojquetl Isaías otlajcuiloj itech ica Juan ijcuac ijquin oquijcuiloj: Yacaj nemi ne campa tlapatlaco niman ijqui tzajtzi: Xyectlalican nemoyojlo pampa ye huajlau toTeco. Xmejmelahuacan nemonemilis ijcon quen on tlacamej cueltlaliaj niman quimejmelahuaj se ojtli ijcuac huajlau se tlacatl yejhuan hueyixticaj. ");
INSERT INTO nguNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan notlaquentiaya ican tlaquentli yejhuan tlachijchiutli ican itojmiyo on camello, niman quitlaliaya ilpicatl tlachijchiutli ican cuetlaxtli. Yejhua quincuaya on yolcatzitzintin yejhuan quen chapolimej, niman no coniya on cojnecutli. ");
INSERT INTO nguNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Huajlayaj cuajcaquiyaj nochimej on chanejquej ipan on hueyican itoca Jerusalén, niman on yejhuan nochihuiyan chantiyaj ne Judea, niman ne nisiu itech on atentli itoca Jordán. ");
INSERT INTO nguNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yejhuamej noyolcuitijtiayaj ican intlajtlacolhuan, niman Juan quincuatequiaya ipan on atentli itoca Jordán. ");
INSERT INTO nguNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero ijcuac Juan oquitac ica miyequej fariseos niman saduceos huajlayaj para nocuatequisquej, oquimijlij: ―Nemejhuamej yejhuan nenquichihuaj on xcuajli quen nencohuamej, ¿aquinon omechmachiltij para xmomanahuican itech on temojtij castigo yejhuan huajlau? ");
INSERT INTO nguNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cuajli xmohuicacan para cuajli nenquiteititisquej ica melahuac yonencajcaquej nenquichihuaj on tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Niman ma ca xnemilican tla xitlaj huelis nochihuas nemotech pampa nenteconehuan itech Abraham. Nejhua nemechijlia ica hasta in temej Dios huelis quincuepas teconehuan itech Abraham. ");
INSERT INTO nguNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nemejhuamej nemijcomej quen on cojtin yejhuan xtlaquij. Nochi cojtli yejhuan xtlaquis notequis niman notlatis. Yejhua ica xmotacan sa no nemejhuamej, pampa on hacha ye oncaj listo para quintequis hasta ipan inelhuayohuan on cojtin yejhuan xtlaquij. ");
INSERT INTO nguNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Melahuac nejhua nemechcuatequiya ican atl para noteititia ica yonencajcaquej nenquichihuaj on tlen xcuajli, pero yejhua on yejhuan nechajtoca quipia más poder xquen nejhua, niman nejhua xnechmelahua nion achijtzin para nicacquixtis. Yejhua, tej, mechcuatequis ican Espíritu Santo niman ican tlitl. ");
INSERT INTO nguNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Dios ye nemi listo para nochimej quintlaxtlahuilis. Yejhua ye ipan ima quipia on iaventador para yejhua ica cajcahuis on trigo niman quixelos itech on itlajsojlo. Quejehuas on trigo ipan on cuescontli, pero on itlajsojlo quitlatis ipan on tlitl yejhuan xqueman sehuis. ");
INSERT INTO nguNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ipan on tonaltin Jesús oquis ne Galilea niman ohuajlaj itech on atentli Jordán para Juan ocuatequij. ");
INSERT INTO nguNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero Juan xquinequiya cuatequis Jesús, niman oquijlij: ―Nejhua nechtocarohua tinechcuatequis, ¿niman yej tejhua notech tihuajlau para ma nimitzcuatequi? ");
INSERT INTO nguNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero Jesús oquijlij: ―Xcahua para aman ma ijqui nochihua, pampa ijqui nonequi ticchihuasquej nochi tlen Dios tlanahuatia. Ijcuacon Juan ijqui oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Quemaj ijcuac Jesús yonocuatequij, oquis itech on atl. Niman nimantzin on ilhuicac otlapou, niman yejhua oquitac iEspíritu Dios huajtemohuaya quen itlaj paloma ipan. ");
INSERT INTO nguNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Quemaj ocaquistic se tlajtojli ne ilhuicac yejhuan oquijtoj: ―Yejhua in yejhua notlajsojcaConetzin yejhuan itech nipacticaj. ");
INSERT INTO nguNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Quemaj on Espíritu Santo ocuicac Jesús campa tlapatlaco, para on diablo ompa ma quitlatlata Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yejhua xotlacuaj ompoajli tonajli niman ompoajli yehuajli, niman sanoyej oquipix apistli. ");
INSERT INTO nguNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Quemaj on diablo oquinisihuij Jesús, niman oquijlij: ―Tla tejhua tiiConeu Dios, xquinnahuati in temej ma nochihuacan tlaxcaltin. ");
INSERT INTO nguNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero Jesús oquijlij: ―In Yectlajcuilojli quijtohua: “Xsan ican tlaxcajli huelis nemis on tlacatl, yej no ican nochi tlajtojli yejhuan Dios quijtohua.” ");
INSERT INTO nguNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Quemaj on diablo ocuicac ipan on yejyejticaj hueyican Jerusalén, niman oquitlejcoltij ne campa más tlacpac ipan on hueyi tiopan, ");
INSERT INTO nguNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","niman oquijlij: ―Tla melahuac tejhua tiiConeu Dios, xonmotlajcali ne tlatzintlan, pampa ipan on Yectlajcuilojli quijtohua: Dios quinnahuatis on iilhuicactequitcahuan ma mitzpalehuican niman mitzquetztehuasquej ican inmahuan para ma ca timocxicocos ican tetl. ");
INSERT INTO nguNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús oquijlij: ―No quijtohua on Yectlajcuilojli: “Ma ca xtlatlata moTeco Dios.” ");
INSERT INTO nguNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Quemaj on diablo ocuicac ipan se tepetl yejhuan sanoyej hueyi. Ompa oquititij nochi países yejhuan oncaj ipan in tlalticpactli niman on hueyilistli yejhuan impan oncaj. ");
INSERT INTO nguNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Quemaj on diablo oquijlij: ―Nochi yejhua in nimitzmacas tla tejhua timotlacuenquetzas niman tinechmahuistilis. ");
INSERT INTO nguNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ijcuacon Jesús oquijlij: ―Xhuiya, Satanás, pampa ipan on Yectlajcuilojli quijtohua: “Xmahuistili moTeco Dios, niman san yejhua xtequipano.” ");
INSERT INTO nguNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Quemaj on diablo oquitlalcahuij Jesús. Niman on ilhuicactequitquej ohualajquej itech Jesús niman oquipalehuijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ijcuac Jesús ocac ica Juan tzacuticaj, oyaj ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero yejhua xonocau ne Nazaret, yej ochantito ne Capernaum. Capernaum yejhua se pueblo yejhuan oncatca ne itenco on mar itoca Galilea niman ipan inyehualican Zabulón niman Neftalí. ");
INSERT INTO nguNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yejhua in onochiu para otenquis on tlen on tiotlajtojquetl Isaías oquijcuiloj. ");
INSERT INTO nguNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","Yejhua oquijcuiloj: On tlacamej nemiyaj ipan tlayehuajlotl ne Zabulón niman Neftalí, niman nisiu on ojtli itech on mar itoca Galilea, niman ne campaca iquisayan tonajli on atentli Jordán, niman se parte de Galilea campa chantij on yejhuan xhebreos. Pero aman yejhuamej quitasquej se hueyi tlahuijli. Yejhuamej ye miquisquia inalma, pero on tlahuijli oquinmacac tlanexyotl. ");
INSERT INTO nguNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Desde ijcuac onocuep para Galilea Jesús opeu tenojnotza, niman quiteijliaya: ―Xcajcahuacan ica nenquichihuaj on tlen xcuajli, pampa ye huajlau ijcuac Dios tlamandaros nican quen tlamandarohua ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Se tonajli ijcuac nejnentiaya ne itenco on mar de Galilea, oquintac omemej icniutin. Se itoca catca Simón, yejhuan no itoca Pedro, niman on ocse Andrés. Yejhuamej conchapaniayaj inmatl ne ipan on atl pampa michajsiquej catcaj. ");
INSERT INTO nguNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Niman Jesús oquimijlij: ―Nemejhuamej nenquintejtemohuaj michimej. Pero aman xhuajhuiyan nohuan niman nenquintejtemosquej tlacamej para nenquinhuicasquej itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yejhuamej nimantzin ocajquej inmatl niman ihuan oyajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Achijtzin más tlayecapan Jesús oquintac ocse omemej icniutin intoca catcaj Jacobo niman Juan. Yejhuamej iconehuan Zebedeo. Yejhuamej quitlamanilijticatcaj inmatl ipan se barco ihuan intaj. Jesús oquinnotz, ");
INSERT INTO nguNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","niman yejhuamej nimantzin oquitlalcahuijquej on barco niman intaj, niman ihuan oyajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús quipaxalohuilijtiaya nochi Galilea, niman temachtijtiaya ipan on tiopantin. Yejhua quiteijlijtiaya on cuajli tlajtojli ica Dios nemi listo para quinmandaros nochi on yejhuan quinequisquej. Yejhua no quipajtijtiaya nochi tlajtlamach cualolistli niman cocolistli yejhuan on tlacamej quipiayaj. ");
INSERT INTO nguNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Omachiyato itequiu ne imanyan Siria. Yejhua ica oquinhuajhuiquilijquej nochimej on yejhuan quijyohuijticatcaj nochi sesetlamantic cualolistin niman cocolistin, niman on yejhuan quipiayaj on xcuajcualtin espíritus, niman on yejhuan san sojsotlahuiyaj niman on yejhuan sepohuiyaj. Niman Jesús oquimpajtij. ");
INSERT INTO nguNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Niman quemaj oyaj ihuan miyec tlacatl yejhuan quisa ne Galilia, niman on yejhuan quisa ne Decápolis. Niman no oyaj ihuan miyec tlacatl yejhuan quisa ipan on hueyican itoca Jerusalén niman on yejhuan quisa imanyan Judea niman on yejhuan chantiyaj iquisayan tonajli de on atentli Jordán. ");
INSERT INTO nguNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ijcuac Jesús oquintac nochimej on tlacamej, otlejcoc ipan se tepetl niman ompa onotlalij. Quemaj on inomachtijcahuan ompa iyehualican onosentlalijquej, ");
INSERT INTO nguNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","niman Jesús opeu ijquin quinmachtia: ");
INSERT INTO nguNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Dios quintiochihua on yejhuan quimatij ica quimpolohua cuajlilistli tlen hualehua itech Dios. Quintiochihua pampa nemisquej ne campa Dios yejhuan ilhuicac chanej tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Dios quintiochihua on yejhuan najmanaj pampa Dios yejhua quinyoltlalis. ");
INSERT INTO nguNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Dios quintiochihua on yejhuan yolyemanquej pampa yejhuamej quiselisquej on tlalticpactli yejhuan Dios oquimprometerohuilij. ");
INSERT INTO nguNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Dios quintiochihua on yejhuan ican nochi inyojlo capismiquij niman camiquij para quichihuasquej on tlen cuajli pampa Dios quimpalehuis para quichihuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Dios quintiochihua on yejhuan quimpalehuiyaj ocsequimej ican teicnelilistli pampa Dios no itlaj ica quimicnelis. ");
INSERT INTO nguNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Dios quintiochihua on yejhuan yolchipajquej pampa yejhuamej quitasquej Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Dios quintiochihua on yejhuan quichihuaj canica para ma ca onyas tlahuejli ipan on tlacamej pampa Dios quintocayotis iconehuan. ");
INSERT INTO nguNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Dios quintiochihua on yejhuan quijyohuiyaj ijcuac quintlahuelitaj san pampa quichihuaj on tlen cuajli. Quintiochihua pampa nemisquej ne campa Dios yejhuan ilhuicac chanej tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Dios mechtiochihuas nemejhuamej ijcuac on tlacamej mechhuijhuicaltiaj, niman mechcojcocosquej, niman mechtenehuilisquej tlajtlamach tlen xmelahuac san pampa nennechneltocaj. ");
INSERT INTO nguNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ijcuac ijcon mechchihuilisquej, xpaquican niman xnemican ican pactli, pampa ne ilhuicac nenquiselisquej se hueyi tetlayocolijli. On tlacamej no ijqui oquintlahuelitaquej niman tlajtlamach ica oquintlajyohuiltijquej on tiotlajtojquej yejhuan onemicoj yehuejcahui ijcuac xe nennemiyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Nemejhuamej quen on istatl yejhuan on tlacamej ica quipoyeliaj on nacatl para ma ca ijtlacahuis. Dios quimpoyelia on tlalticpactlacamej nemotechcopa para ma ca ijtlacahuisquej ican tlajtlacojli. Niman nemejhuamej no nenquimatij ica tla on istatl quipolos on ipoyecyo, xhuelis ocsejpa quitequitiltisquej. On xoc itlaj ica tepalehuij, yej san para quixiniaj ne ipan ojtli niman nochi tlacatl ipan cholohua. ");
INSERT INTO nguNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ipan in tlalticpactli on tlacamej mechitaj quen ijqui nemohuicaj. Yejhua ica nemejhuamej nennemij quen itlaj on tlahuijli yejhuan quintlahuilhuiya. Nochimej huelij quitaj se hueyican yejhuan oncaj icuapan se tepetl. ");
INSERT INTO nguNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Niman xacaj quitlicuiltia se lámpara niman quitlalia itzintlan se chiquiutli, yej quitlalia campa tlacpac para hueli quitlahuilhuiya nochi tlacatl yejhuan nemi calijtic. ");
INSERT INTO nguNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nemejhuamej, tej, quen nenlámparas. Yejhua ica xchihuacan para nemotlahuil ma tlahuilo imixpan on tlacamej para ijqui quitasquej on tlen cuajli nenquichihuasquej, niman yejhua ica cueyilisquej nemoTajtzin yejhuan nemi ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ma ca xnemilican tla nejhua onihuajlaj para onicpopoloco on itlanahuatil Moisés niman itemachtilhuan on tiotlajtojquej. Nejhua onihuajlaj xpara onicpopoloco, yej para onictlacamatico niman para onicteititico nochi tlen quijtosnequi on tlanahuatijli. ");
INSERT INTO nguNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ica tlen melahuac nemechijlia ica xnoquixtilis se letra nion se punto itlanahuatil Dios chica onyas on cielo niman in tlalticpactli. Xitlaj noquixtilis hasta nochihuas nochi tlen onijcuiloj. ");
INSERT INTO nguNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yejhua ica, on yejhuan xquitlacamatis san catlejhua tlanahuatijli, masqui on tlanahuatijli yejhuan xmás hueyi quijtosnequi, niman quinmachtis ocsequimej para no ijqui ma quichihuacan, yejhua pitentzin yes ne campa Dios yejhuan ilhuicac chanej tlamandarohua. Pero on yejhuan quitlacamatis nochi on tlanahuatijli, niman quinmachtis ocsequimej para no ijqui ma quichihuacan, yejhua hueyi yes ne campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yejhua ica nemechijlia ica xnenhuelisquej nencalaquisquej ne campa Dios yejhuan ilhuicac chanej tlamandarohua tla xnenmohuicasquej más cuajli xquen on temachtijquej ican on tlanahuatijli niman on fariseos nohuicaj. ");
INSERT INTO nguNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Nemejhuamej onencaquej ica ye huejcahui Moisés otemachtij: “Ma ca titemictis. San aquinon yejhuan temictis ica oncaj onotelquetzas ixpan on tequihuaj, niman quitlajtlacolmacas.” ");
INSERT INTO nguNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero nejhua nemechijlia ica san aquinon yejhuan cualanis ihuan ocse, ica oncaj onotelquetzas ixpan on tequihuaj, niman quitlajtlacolmacas. Niman san aquinon yejhuan cuijhuicaltis ocse, ica oncaj onotelquetzas imixpan on tetlacanonotzquej. Niman san aquinon yejhuan quijlis ocse ica semi tonto, huelis yas ipan on tlitl yejhuan oncaj ne mictlan campa tetlajyohuiltiloyan. ");
INSERT INTO nguNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ijcon, tej, tla ijcuac tictemaca mohuen ne tlaixpan tiquelnamiqui ica ocse itlaj ica motech cualani, ");
INSERT INTO nguNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","xcahua mohuen ne ipan on tlaixpan niman xhuiya itech on tlacatl. Achtopa ihuan xmoyoltlaliti, niman quemaj ocsejpa xhuiya ne itech on tlaixpan niman xtemaca mohuen. ");
INSERT INTO nguNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tla yacaj mitzhuica ne juzgado para mitzteixpanhuis, nimantzin ihuan cuajli xmocahua ne ipan ojtli para ma ca mitztemacas ne itech on tequihuaj. Ijquin xchihua pampa tla mitztemacas itech on tequihuaj, on tequihuaj mitztemacas itech on policía niman mitzajsisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ica tlen melahuac nimitzijlia ica ompa xtiquisas hasta tictlaxtlahuas on sa ica nochi motomin yejhuan mitzquixtilisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Nemejhuamej onencaquej ica onijtoj: “Ma ca xsihuapajpatlacan nion xtlacapajpatlacan.” ");
INSERT INTO nguNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero nejhua nemechijlia ica san aquinon yejhuan quitas se sihuatl ican xcuajli elehuilistli, yejhua ye sihuapajpatla ipan iyojlo ihuan on sihuatl. ");
INSERT INTO nguNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Aman, tej, tla yejhua on mixtololoj yejhuan ticpia moyecmacopa mitzchihuilia para titlajtlacohua, xquixti niman xtlajcali. Más cuajli ticpolos se parte de on motlalnacayo niman ma ca nochi motlalnacayo contlajcalisquej ne mictlan campa tetlajyohuiltiloyan. ");
INSERT INTO nguNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Niman tla yej moyecma mitzchihuilia para titlajtlacohua, xmotequili niman xtlajcali. Más cuajli ticpolos se parte de on motlalnacayo niman ma ca nochi motlalnacayo contlajcalisquej ne mictlan campa tetlajyohuiltiloyan. ");
INSERT INTO nguNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Nemejhuamej no nenquimatztoquej ica onijtoj: “San aquinon yejhuan noxotonis ihuan isihuau ica oncaj quimacas se amatlajcuilojli campa quijtos ica melahuac yocau.” ");
INSERT INTO nguNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero nejhua nemechijlia ica tla se tlacatl noxotonia ihuan isihuau, niman xpampa tla on sihuatl oquichiu on tlen xcuajli ihuan ocse tlacatl, sa no yejhua quichihua para on sihuatl ma tlacapajpatla tla nonamictia ocsejpa. Niman on yejhuan ihuan nonamictia on sihuatl, yejhuan tehuan yonoxotonij, no sihuapajpatla. ");
INSERT INTO nguNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Nemejhuamej no onencaquej ica ye huejcahui Moisés otemachtij: “Ma ca ijqui ticahuas on tlen ticprometerohua, yej xchihua on tlen ican tlajtolpalehuilistli ticprometerohua itech toTeco.” ");
INSERT INTO nguNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero nejhua nemechijlia: Ma ca itlaj ica xmotlajtolpalehuican. Ma ca xmotlajtolpalehuican ica on ilhuicac, pampa ompa nosehuijticaj Dios ican nochi tequihuajyotl. ");
INSERT INTO nguNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nion ma ca xmotlajtolpalehuican ican in tlalticpactli, pampa Dios yejhua quimandarohua in tlalticpactli. Nion ma ca xmotlajtolpalehuican ican Jerusalén, pampa on yejhua ihueyican on tohueyi Rey. ");
INSERT INTO nguNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nion ma ca xmotlajtolpalehuican ican nemotzontecon, pampa nion se nemotzon xhueli nencuepaj istac noso capotztic. ");
INSERT INTO nguNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pero san xtlananquilican “quemaj” noso “ca”, pampa nochi tlen ocsequi nenquijtosquej hualehuas itech on diablo. ");
INSERT INTO nguNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Nemejhuamej onencacquej ica onijtoj: “Aquin quixtepatzahua se tlacatl, yejhua no quixtepatzahuasquej. Aquin quitlajcalilia itlan se tlacatl, yejhua no quitlajcalilisquej itlan.” ");
INSERT INTO nguNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero nejhua nemechijlia: Ma ca xcuepiltican on xcuajli tlacatl tlen yejhua mechchihuilia. Yej tla mitzmailia se lado ipan moxayac, no xmaca on ocse lado moxayac. ");
INSERT INTO nguNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Niman tla yacaj mitzteixpanhuiya niman quinequi mitzcuilis motlaquen, xcahuili no ma quitqui mogában. ");
INSERT INTO nguNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tla yacaj mitzchihualtia tiquitquis se tlamamajli ipan se kilómetro, xquitqui ipan ome kilómetro. ");
INSERT INTO nguNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","On yejhuan itlaj mitztlajtlanilis, xmaca. Niman on yejhuan itlaj mitztlanehuilisnequi, xtlanejti. ");
INSERT INTO nguNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’No ijqui onencacquej ica onijtoj: “Xtlajsojtla motetlajsojcau niman xtlahuelita motlahuelicniu.” ");
INSERT INTO nguNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero nejhua nemechijlia: Xquintlajsojtlacan on nemotlahuelicnihuan. Xchihuacan on tlen cuajli intech on yejhuan mechtenehuiliaj on tlen xcuajli, niman xchihuacan on tlen cuajli intech on yejhuan mechtlahuelitaj. Xchihuacan oración para on yejhuan mechchihuiliaj on tlen xcuajli niman yejhuan mechtlahuelitaj miman tlajtlamach ica mechtlajyohuiltiaj. ");
INSERT INTO nguNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ijcon xchihuacan para nesis ica nenteconehuan itech on nemoTajtzin ilhuicac chanej. Yejhua, tej, quichihua para on tonaltzintli ma quisa impan on yejhuan xcuajcualtin tlacamej niman yejhuan cuajcualtin. Niman no quichihua para quiahui impan on yolchipajquej niman yejhuan xyolchipajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Niman tla nemejhuamej nenquintlajsojtlaj san on yejhuan mechtlajsojtlaj, ¿tlin tetlayocolijli itech Dios nenquiselisquej yejhua ica on? Hasta on yejhuan tlacobrarojquej ipan impuestos ijqui quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Niman tla nenquintlajpalohuaj san on yejhuan nemocnihuan, ¿tlinon más cuajli nenquichihuaj xquen on ocsequimej quichihuaj? Tej, hasta on yejhuan xquixmatij Dios ijqui quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nemejhuamej, tej, xmochihuacan cuajcualtin ican nochi tlajtlamach para nennemisquej quen nemoTajtzin ilhuicac chanej. ");
INSERT INTO nguNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Xmotacan sa no nemejhuamej, ma ca nenquichihuasquej on tlen cuajli imixpan on tlacamej san para yejhuamej ma mechitacan tlen nenquichihuaj. Tla ijqui nenquichihuaj, on nemoTajtzin ilhuicac chanej xitlaj mechtlayocolis. ");
INSERT INTO nguNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Yejhua ica, ijcuac nenquimpalehuisquej on yejhuan quimpolojticaj, ma ca xpantlantican quen quichihuaj on omexayacyejquej ne ipan on tiopantin niman ipan calles. Yejhuamej quichihuaj san para on tlacamej ma quintlacaitacan. Pero nejhua ica tlen melahuac nemechijlia ica san yejhua ica on tlen quichihuaj ye quipiaj intetlayocolil. ");
INSERT INTO nguNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero ijcuac nemejhuamej itlaj ica nenquimpalehuisquej on yejhuan quimpolojticaj, hasta yejhua on yejhuan sanoyej cuajli nemotetlajsojcau ma ca ma quimati tlinon nenquichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yej xchihuacan san ichtaca. Tla ijcon nenquichihuasquej, nemoTajtzin yejhuan quitas tlinon nenquichtacachihuasquej mechmacas nemotetlayocolil yejhuan nochimej quimatisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Niman ijcuac nenquichihuasquej oración, ma ca xchihuacan quen on omexayacyejquej quichihuaj. Yejhuamej cuelitaj notelquetzaj para quichihuaj oración ne ijtic on tiopantin niman ipan iesquinas on calles, san para on tlacamej ma quintacan tlen quichihuaj. Ica tlen melahuac, tej, nemechijlia ica san yejhua ica on tlen quichihuaj ye quipiaj intetlayocolil. ");
INSERT INTO nguNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero ijcuac nemejhuamej nenquichihuasquej oración, xcalaquican nemocalitic, xtzacuacan nemotlatzacuilyo, niman ompa xquichtacachihuacan nemooración itech nemoTajtzin. Niman nemoTajtzin, yejhuan quitas tlinon nemejhuamej nenquichtacachihuasquej, mechmacas nemotetlayocolil yejhuan nochimej quimatisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ijcuac nenquichihuasquej oración, ma ca miyecpa sa no yejhua tlajtojli nenquijtosquej yejhuan xitlaj ica mechpalehuis, quen quichihuaj on xhebreos. Yejhuamej quinemiliaj ica Dios quincaqui pampa huejhueyac inoración quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma ca, tej, xchihuacan quen yejhuamej pampa on nemoTajtzin ye quimatzticaj tlinon nemejhuamej mechpolohua ijcuac xe nenquitlajtlaniaj. ");
INSERT INTO nguNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yejhua ica, tej, ijquin xchihuacan oración: ToTajtzin aquin tinemi ne ilhuicac, ma mitzyectenehua nochi tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma huajla on tonaltin ijcuac ticmandaros nochi tlacatl. Ipan in tlalticpactli on tlacamej ma quichihuacan on tlen ticnequi ijcon quen nochihua ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aman xtechmaca tlen ticuasquej on yejhuan mojmostla ica tipanotoquej. ");
INSERT INTO nguNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Niman xtechtlapojpolhuili totlajtlacolhuan ijcon quen tejhuamej tiquintlapojpolhuiyaj on yejhuan tlajtlamach xcuajli techchihuiliaj. ");
INSERT INTO nguNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Niman xtechpalehui para ma ca titlajtlacosquej, yej xtechejcuanilij nochi tlen xcuajli. Timitztlajtlaniliaj yejhua in pampa ticpia tequihuajyotl, niman poder, niman hueyilistli para nochipa. Amén. ");
INSERT INTO nguNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Tla nenquintlapojpolhuisquej ocsequimej ica on tlen xcuajli mechchihuiliaj, nemoTajtzin ilhuicac chanej no mechtlapojpolhuis. ");
INSERT INTO nguNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero tla on ocsequimej xnenquintlapojpolhuiliaj on tlen xcuajli mechchihuiliaj, nemoTajtzin no xmechtlapojpolhuilis on tlen xcuajli onenquichijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ijcuac nemejhuamej nemosahuasquej, ma ca xtlalican nemoxayac ican ajmantli quen quichihuaj on omexayacyejquej. Yejhuamej, tej, ijcon quichihuaj san para on tlacamej ma quitacan ica yejhuamej nosautoquej. Ica tlen melahuac nemechijlia ica san yejhua ica on tlen quichihuaj ye quipiaj intetlayocolil. ");
INSERT INTO nguNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero nemejhuamej ijcuac nemosahuasquej, cuajli xmixamican niman xmopeinarocan. ");
INSERT INTO nguNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ijcon on tlacamej xquitasquej ica nemosautoquej, yej san nemoTajtzin yejhuan xnesticaj quimatis. Yejhua quitas tlinon nenquichtacachihuasquej, niman yejhua mechmacas nemotetlayocolil yejhuan nochimej quimatisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ma ca xsentlalican nemorriquezas nican ipan in tlalticpactli campa on pochahuistli quijtlacohua niman nochi on tlajtlamach san ixpolihui, niman campa on ichtequej calaquij niman tlachtequij. ");
INSERT INTO nguNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yej xsentlalican nemorriquezas ne ilhuicac campa on pochahuistli xqueman tlaijtlacohua, niman nochi on tlajtlamach xqueman ixpolihui, niman on ichtequej xqueman calaquij para tlachtequij. ");
INSERT INTO nguNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tej, campa nemejhuamej nenquipiasquej nemorriquezas, no ompa onyas nemoyojlo. ");
INSERT INTO nguNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Ijcuac nemotlamachilis cajsicamati on tlen cuajli para nenquichihuasquej, yejhua nochihua itlahuil nemoalma. ");
INSERT INTO nguNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero tla nemotlamachilis xcajsicamati on tlen cuajli para nenquichihuasquej, nemoalma quipia tlayohualyotl. Niman xoncaj ocse tlayohualyotl yejhuan más capostic xquen yejhua on. ");
INSERT INTO nguNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Xacaj hueli quintequichihuilia omemej tecomej, pampa se quitlajsojtlas niman ocse quitlahuelitas, noso se quipialis cuajli iyojlo niman ocse quitlalcahuis. Ijcon, tej, xacaj huelis quitequichihuilis Dios niman no quinotequimacas on tomin. ");
INSERT INTO nguNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Yejhua ica, tej, nemechijlia: Ma ca xcomatztiacan on tlen nenquicuasquej niman on tlen nenconisquej, nion nemotlaquen yejhuan mojmostla mechpolojticaj. ¿Tlen xnenquimatij ica on nemilistli más hueyi quijtosnequi xquen yejhua on tlacuajli, niman on tlalnacayotl más hueyi quijtosnequi xquen yejhua on tlaquentli? ");
INSERT INTO nguNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xquintacan on totomej yejhuan patlantinemij ne ipan ajacatl. Yejhuamej xtocaj nion pixcaj, nion quejehuaj ipan se cuescontli on tlen quicuasquej. Niman xcahua, tej, on nemoTajtzin ilhuicac chanej quinmacaticaj tlen quicuaj. ¿Tlica nemejhuamej xmás nenhueyi quijtosnequij xquen yejhuamej on totomej? ");
INSERT INTO nguNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Niman aquinon masqui sa itlaj comatztias, huelis ocse tlajco metro más notlaquechilis? ");
INSERT INTO nguNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Niman tlica sa nencomatztoquej on nemotlaquen? Cuajli xquintacan quen ijqui noscaltiaj on xochimej ne ipan tepetl. Yejhuamej xtequitij nion quichijchihuaj intlaquen. ");
INSERT INTO nguNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero nejhua nemechijlia ica on rey Salomón xqueman onotlaquentij quen se de yejhua on xochitl masqui sanoyej onocualnextij ica on yejhuan patio itlaquehuan. ");
INSERT INTO nguNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","¡Oh! nemejhuamej yejhuan xmás nenquineltocaj Dios, tla on xojtli yejhuan quen aman in oncaj ipan tepetl, Dios ijqui quitlaquentia niman huajmostla quitlatiaj, ¿tlen xmás mechtlaquentis nemejhuamej? ");
INSERT INTO nguNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yejhua ica, ma ca xcomatztiacan nenquijtosquej: “¿Tlinon ticuasquej? noso ¿tlinon ticonisquej? noso ¿tlinon ica titotlaquentisquej?” ");
INSERT INTO nguNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","On yejhuan xhebreos quitejtemohuaj nochi yejhua in tlajtlamach. Pero nemoTajtzin ilhuicac chanej quimatzticaj ica nochi yejhua in mechpolohua. ");
INSERT INTO nguNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pero achtopa xnequican para nenquichihuasquej nochi on tlen Dios mechnahuatia niman no xnequican cuajli nennemisquej quen yejhua nemi. Tla ijcon nenquichihuasquej, Dios mechmacas nochi tlen mechpolohua. ");
INSERT INTO nguNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ma ca xcomatztiacan on tlen mostla nochihuas, pampa cada tonajli ye oncaj tlen nenquiselisquej yejhuan ica nemocahuasquej. Cada tonajli, tej, nenquipiasquej problemas san quech huelis nenquixicosquej. ");
INSERT INTO nguNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ma ca queman xquinmistlacocan ocsequimej para ijcon Dios no xmechistlacos, ");
INSERT INTO nguNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","pampa tla nemejhuamej nentetlajtlacoltisquej, Dios no mechtlajtlacoltis. Niman quech nemejhuamej ica nentetlajtlacoltisquej, Dios no sa no ijqui ica mechtlajtlacoltis. ");
INSERT INTO nguNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Quen ijqui, tej, hueli tiquita on quesqui tlajtlacojli yejhuan quichihua se mocniu niman xtiquita on miyec tlajtlacojli yejhuan tejhua ticchihua? ");
INSERT INTO nguNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Noso, ¿quen ijqui hueli tiquijlia mocniu: “Ma nimitzcajcahualti on quesqui tlajtlacojli”, ijcuac tejhua ticpia miyec tlajtlacojli? ");
INSERT INTO nguNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Omexayacyej! Achtopa xcajcahua on miyec tlajtlacojli yejhuan ticpia, niman ijqui huelis ticajcahualtis mocniu on quesqui tlajtlacojli yejhuan yejhua quipia. ");
INSERT INTO nguNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’On tlen chipahuac ma ca xquinmacacan on tlacamej yejhuan sanoyej xcuajli inyojlo, pampa yejhuamej quen chichimej yejhuan huajnocuepasquej nemotech, niman mechcuajcuasquej. Niman on tlen hueyi quijtosnequi ma ca xquinmacacan on tlacamej yejhuan quen pitzomej, para ma ca yej ipan chojcholosquej. ");
INSERT INTO nguNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Xtlajtlanilican Dios on tlen mechpolohua, niman yejhua mechmacas. Xtejtemocan on tlen mechpolohua, niman nenquinextisquej. Xtetepinican on tlatzacuilyotl, niman Dios mechtlapohuilis. ");
INSERT INTO nguNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ijcon xchihuacan, pampa yejhuan quitlajtlani quiselia, niman yejhuan quitejtemohua quinextia, niman yejhuan quitetepinia on tlatzacuilyotl, quitlatlapohuiliaj. ");
INSERT INTO nguNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Tlen nemotzajlan nemi se yejhuan noyolchicahuas para quimacas iconeu se tetl ijcuac quitlajtlanilis se tlaxcajli? ");
INSERT INTO nguNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Noso quimacas se cohuatl ijcuac quitlajtlanilis se michin? ");
INSERT INTO nguNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aman, tej, tla nemejhuamej yejhuan xnencuajcualtin tlacamej nenquimatij quen cuajli nenquinmacasquej nemoconehuan tlajtlamach on tlen cuajli, sanoyej pantlannestiacaj ica nemoTajtzin ilhuicac chanej mechmacas on tlen cuajli yejhuan nenquitlajtlanilisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ijcon, tej, xquinchihuilican ocsequimej nochi on tlajtlamach tlen nemejhuamej nenquinequisquiaj ma mechchihuilican ocsequimej, pampa nochi on itlanahuatil Moisés niman nochi on yectlajcuilotin yejhuan on tiotlajtojquej oquijcuilojquej yejhua tlanahuatia. ");
INSERT INTO nguNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Oncaj se ojtli yejhuan tehuica ne mictlan campa tetlajyohuiltiloyan, niman ocse yejhuan tehuica ne ilhuicac campa oncaj on nemilistli yejhuan para nochipa. Ne campa pehua on ojtli yejhuan tehuica ne mictlan oncaj se tlatzacuilyotl yejhuan patlahuac, niman on ojtli no patlahuac. Miyequej quinejnemij on ojtli patlahuac niman miyequej calaquij ipan on puerta. Pero pitztic on puerta yejhuan oncaj ne campa pehua on ojtli yejhuan tehuica ne campa oncaj on nemilistli, niman on ojtli pitzahuac. On ojtli pitzahuac ohuijticaj para quinejnemij, niman xmiyequej quinextiaj on tlatzacuilyotl para ompa calaquisquej. Pero nemejhuamej xcalaquican ipan on tlatzacuilyot yejhuan pitztic, niman xhuiyan ipan on ojtli yejhuan pitzahuac. ");
INSERT INTO nguNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Xmotacan sa no nemejhuamej intech on tlacajcayajquej tiotlajtojquej yejhuan quijtohuaj tenojnotzaj ican itemachtil Dios. Yejhuamej huajlahuij nemotech, niman nesij quen cuajli tlacamej, pero quinequij quixoxotonisquej nemotlaneltoc. ");
INSERT INTO nguNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nemejhuamej huelis nenquintasquej tla tlacajcayajquej noso ca ica on tlen quichihuaj. Tej, xqueman notequi uvas ipan on huitzcojtin, nion higos ipan on xicojhuitztin. ");
INSERT INTO nguNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ijcon, tej, nochi tlen cuajli cojtlaquijlyotl quipia cuajli itlaquilyo, niman nochi tlen xcuajli cojtlaquijlyotl quipia xcuajli itlaquilyo. ");
INSERT INTO nguNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","On cuajli cojtlaquijlyotl xhuelis quipias xcuajli itlaquilyo, nion on xcuajli cojtlaquijlyotl xhuelis quipias cuajli itlaquilyo. ");
INSERT INTO nguNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Niman nochi cojtlaquijlyotl yejhuan xcuajli quipia itlaquilyo quitzontequij niman quitlatiaj. ");
INSERT INTO nguNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yejhua ica, tej, huelis nenquintasquej tla tlacajcayajquej noso ca ica on tlen quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Xnochimej on yejhuan nechijliaj: “NoTeco, noTeco”, calaquisquej ne campa noTajtzin ilhuicac chanej tlamandarohua, yej san yejhuamej on yejhuan quichihuaj on tlen quinequi noTajtzin ilhuicac chanej. ");
INSERT INTO nguNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ijcuac yejcos on tonajli para Dios quitlaxtlahuilis nochi tlacatl, miyequej nechijlisquej: “NoTeco, noTeco, tejhuamej otitemachtijquej ican motocatzin, niman ican motlanahuatil otictequixtilijquej on xcuajcualtin espíritus, niman ican motocatzin oticchijquej miyec milagros.” ");
INSERT INTO nguNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero ijcuacon niquimijlis: “Xqueman onemechixmat. Xnechtlalcahuican nemejhuamej yejhuan nenquichihuaj on tlen xcuajli.” ");
INSERT INTO nguNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Nochimej on yejhuan nechcaquij niman quichihuaj on tlen nejhua niquijtohua, yejhuamej quen on tlacatl tlajmatqui yejhuan oquitlalij ical ipan se tepetlatl yejhuan tilahuac niman chicahuac. ");
INSERT INTO nguNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Opeu quiahui, ohuejhueyiyaquej on atepeyamej, niman opeu temojtij tlahuitequi on ajacatl ipan on cajli. Pero on cajli xohuetz, pampa yejhua tzimpejticaj ipan on tepetlatl. ");
INSERT INTO nguNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero nochimej on yejhuan nechcaquij niman xquichihuaj on tlen nejhua niquijtohua, yejhuamej quen on tlacatl xtlajmatqui yejhuan oquitlalij ical ipan xajli. ");
INSERT INTO nguNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Opeu quiahui, ohuejhueyiyaquej on atepeyamej, niman opeu temojtij tlahuitequi on ajacatl ipan on cajli. On cajli ohuetz, niman sanoyej temojtij quen oxoxoton. ");
INSERT INTO nguNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús otlan tlajtlajtohua niman on tojlan sanoyej mojcatlachaya ica on tlen yejhua quimijliaya, ");
INSERT INTO nguNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","pampa yejhua temachtiaya ican itlanahuatil Dios, niman xijqui quen on temachtijquej ican tlanahuatijli temachtiayaj. ");
INSERT INTO nguNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ijcuac Jesús ohuajtemoc ne ipan tepetl, miyec tlacatl oquicuitlapanhuij. ");
INSERT INTO nguNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Niman se cocoxqui yejhuan quipiaya on cualolistli itoca lepra oquinisihuij Jesús. Ijcuac oquinisihuij, ixpan onotlacuenquetz, niman oquijlij: ―Señor, tla ticnequi, huelis tinechpajtis. ");
INSERT INTO nguNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ijcuacon Jesús oquimatocac, niman oquijlij: ―Nicnequi. Xpajti aman. Ijcuac yejhua ijcon oquijtoj, inacayo on tlacatl nimantzin opajtic. ");
INSERT INTO nguNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Niman Jesús oquijlij: ―Xcaqui tlin timitzijlis. Ma ca yacaj tiquijlis on tlen onicchiu. Yej san xhuiya niman xmoteititi ne itech on tiopixqui para mitzitas ica xoc ticualo, niman xcuentlali on tlen Moisés otenahuatij para on tlacamej quitasquej ica yotipajtic. ");
INSERT INTO nguNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ijcuac Jesús ocalac ne ipan on pueblo itoca Capernaum, se capitán romano oquinisihuij niman oquitlajtlanilij se favor. ");
INSERT INTO nguNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Niman ijquin oquijlij: ―NoTeco, notequichihuilijcau nemi ipan tlapechtli ne nochan. Yejhua sepojtoc, niman sanoyej nococohua. ");
INSERT INTO nguNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús oquijlij: ―Nejhua nias nicompajtis. ");
INSERT INTO nguNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero on capitán oquijlij: ―NoTeco, nejhua xnechmelahua para tejhua ticalaquis nochan. San ican motlajtol xtlanahuati, niman notequichihuilijcau pajtis. ");
INSERT INTO nguNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ijcon nochihuas pampa nejhua no nicmati quen niquintlacamati on yejhuan nechmandarohuaj, niman nejhua no niquimpia soldados yejhuan nechtlacamatij ijcuac niquinmandarohua. Ijcuac se nicnahuatia canaj ma huiya, yau. Ijcuac ocse niquijlis ma huajla, huajlau. Niman ijcuac on notequichihuilijcau nicnahuatia itlaj ma quichihua, quichihua. ");
INSERT INTO nguNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ijcuac Jesús ijcon ocac, oquitlatlachaltij, niman oquimijlij on yejhuan cuicatiayaj: ―Ica tlen melahuac nemechijlia ica nion se hebreo xqueman niquita sanoyej tlaneltoca quen yejhua in tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nejhua nemechijlia ica miyequej xhebreos nochihuiyan ipan in tlalticpactli hualehuasquej, niman notlalisquej para tlacuasquej ihuan Abraham, Isaac niman Jacob ne campa Dios ilhuicac chanej tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","On hebreos nonequi calaquisquej ne campa Dios tlamandarohua, pero xcalaquisquej. Yej quinhuajxinisquej ipan tlayehuajlotl campa chocasquej niman notlantisisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Quemaj Jesús oquijlij on capitán: ―Xhuiya ne mochan niman on tlen oticneltocac ijqui nochihuas. Niman quemaj nimantzin on itequichihuilijcau on capitán opajtic. ");
INSERT INTO nguNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús oyaj ichan Pedro, niman ompa oquitac imonan Pedro onoc ipan itlapech ican totonqui. ");
INSERT INTO nguNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús oquitzquilij ima, niman ijqui ocau on totonqui. Quemaj yejhua onoquetzteu niman opeu quintlacualtia. ");
INSERT INTO nguNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ijcuac otlayohuac, oquinhuajhuicaquej itech Jesús miyequej tlacamej yejhuan quipiayaj on xcuajcualtin espíritus niman ocsequimej cocoxquej. Niman ican itlanahuatil oquinquixtilij on espíritus, niman no oquimpajtij nochimej on cocoxquej. ");
INSERT INTO nguNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yejhua in onochiu para otenquis on tlen oquiteijlijca on tiotlajtojquetl Isaías, ijcuac oquijtoj: “Sa no yejhua otechpopolohuilij on tocualolis, niman oquitquic on tococolis.” ");
INSERT INTO nguNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ijcuac Jesús oquitac ica tojlan quiyehualohuaya, oquinnahuatij on inomachtijcahuan para ma panotij ne ipan ocse ilado on mar. ");
INSERT INTO nguNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Quemaj se temachtijquetl ica on tlanahuatijli oquinisihuij Jesús niman oquijlij: ―Temachtijquetl, nimitzhuicas san canon tejhua tias. ");
INSERT INTO nguNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús oquijlij: ―On ostotzitzintin quipiaj intecal, niman on totomej quipiaj intepajsol, pero nejhua yejhuan oninochiu Tlacatl xnicpia canon nicochis. ");
INSERT INTO nguNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Niman ocse tlacatl, yejhuan no inomachtijcau, oquijlij: ―NoTeco, xnechcahuili achtopa ma nihuiya para nicontocas notaj niman quemaj mohuan nias. ");
INSERT INTO nguNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero Jesús oquijlij: ―Xhuajla nohuan, niman xquincahua on yejhuan mictoquej ixpan Dios ma quintocacan on inmicatzitzihuan. ");
INSERT INTO nguNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Niman Jesús otlejcoc ipan se barco niman on inomachtijcahuan oyajquej ihuan. ");
INSERT INTO nguNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Niman ipan on mar nimantzin opeu sanoyej chicahuac ajaca niman on atl yejhuan noquetztehuaya hasta calaquiyaj ijtic on barco. Pero Jesús cochticatca. ");
INSERT INTO nguNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Quemaj on inomachtijcahuan oquitlachaltitoj, niman oquijlijquej: ―¡ToTeco, xtechmaquixti! ¡Ye tiamimictoquej! ");
INSERT INTO nguNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yejhua oquimijlij: ―¿Tlica sanoyej nemomojtiaj? ¡Nemejhuamej semi achijtzin nenquipiaj tlaneltoctli! Quemaj onotelquetz niman oquinahuatij on ajacatl niman on mar ma ca sa tlamach ma quichihua. Nimantzin nochi onoteltij niman nochi cuajli onocau. ");
INSERT INTO nguNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","On tlacamej omojcatlachixquej, niman oquijtojquej: ―¿Tlinon itequiu yejhua in tlacatl ica hasta on ajacatl niman on mar quitlacamatij? ");
INSERT INTO nguNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ijcuac Jesús oajsic ne ipan ocse ilado on mar, ipan intlalhuan on tlacamej yejhuan chantij ne Gadara, omemej tlacamej ohuajquisquej ne intzajlan on ostomej yejhuan imijtic quintocayaj on mimiquej. On omemej tlacamej oquinisihuijquej Jesús. Yejhuamej quipiayaj on xcuajcualtin espíritus, niman ipan on ojtli xacaj hueliya panohuaya pampa yejhuamej sanoyej cualaniyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Niman opejquej tzajtzij: ―¿Tlinon ticnequi tohuan Jesús tejhua tiiConetzin Dios? ¿Otihuajlaj nican para titechcastigaros masqui xe ajsi on tonajli para ticselisquej tocastigo? ");
INSERT INTO nguNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","San ompaca nisiu miyequej pitzomej tlacuajcuajtinemiyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Niman on xcuajcualtin espíritus oquimojcatlajtlanilijquej Jesús: ―Tla titechquixtis impan in tlacamej, xtechcahuili ma ticalaquican ne impan on pitzomej. ");
INSERT INTO nguNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ijcuacon Jesús oquimijlij: ―Xhuiyan, tej. Niman on xcuajcualtin espíritus oquisquej ne impan on tlacamej niman ocalaquej impan on pitzomej. Quemaj nochimej on pitzomej onotlajtlalojquej niman ne ipan on tlaltentli campa huejcatlan oxinitoj hasta ijtic on mar, niman ompa oamimiquej. ");
INSERT INTO nguNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","On yejhuan tlajpiayaj ica on pitzomej, ican inmojcayo ontlatlacsaquej. Niman ijcuac oajsiquej ne ipan on pueblo, opeu quitetlajtlajtohuiliaj nochi tlen onochiu, niman on tlen onochiu intech on tlacamej yejhuan quipiayaj on xcuajcualtin espíritus. ");
INSERT INTO nguNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Quemaj nochi tlacatl yejhuan chanti ipan on pueblo oquis para oquitato Jesús campa yejhua nemiya. Niman ijcuac oquitaquej, oquimojcatlajtlanilijquej para ma nejcuani ne intlalpan ica. ");
INSERT INTO nguNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Quemaj Jesús ocalac ipan se barco, opanoc ne ipan ocse ilado on mar, niman oajsic ipan on pueblo itoca Capernaum. ");
INSERT INTO nguNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ipan on pueblo, ocuiquilijquej ican cojtlapechtli se tlacatl yejhuan sepojtoya. Ijcuac Jesús oquitac intlaneltoc, oquijlij on cocoxqui: ―Xmoyolchicahua, noconeu. Motlajtlacolhuan yotlapojpolhuiloquej. ");
INSERT INTO nguNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ijcuacon semej temachtijquej ica on tlanahuatijli oquinemilijquej: “In tlacatl yocuijhuicaltij Dios ican itlajtol pampa yejhua notenehua quipia sa no ipoder Dios.” ");
INSERT INTO nguNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús quimatzticatca tlinon yejhuamej quinemilijticatcaj. Yejhua ica, tej, oquimijlij: ―¿Tlica nenquinemiliaj on tlen xcuajli? ");
INSERT INTO nguNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Catlejhua más xtepopoloj para niquijtos: “Motlajtlacolhuan yotlapojpolhuiloquej”, noso yej niquijtos: “Xmotelquetz niman xnejnemi”? ");
INSERT INTO nguNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aman cuajli, nejhua nemechititis ica nejhua yejhuan oninochiu Tlacatl nicpia tequihuajyotl ipan in tlalticpactli para nitetlapojpolhuilis on tlajtlacoltin. Quemaj oquijlij on tlacatl yejhuan sepojtoya: ―Xmotelquetza, xcajcocui motlapech, niman xhuiya mochan. ");
INSERT INTO nguNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Quemaj on yejhuan sepojtoya onotelquetz niman oyaj ichan. ");
INSERT INTO nguNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Niman ijcuac on tlacamej ijcon oquitaquej, onomojtijquej, niman ocueyilijquej Dios ipampa on poder yejhuan oquimacac Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ijcuac Jesús oquis ompa, ipan iojhui oquitac se tlacatl itoca Mateo yehuaticatca ne campa tlacobrarohua ican impuestos. Niman Jesús oquijlij: ―Xhuajla nohuan. Mateo nimantzin ohuajnotelquetz niman oyaj ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Más saquin, ijcuac Jesús tlacuajticatca ne ichan Mateo, sequimej tlacamej yejhuan tlacobrarojquej ica on impuestos niman no ocsequimej yejhuan tlajtlacolejquej onosentlalijquej ihuan Jesús niman inomachtijcahuan ne itech mesa. ");
INSERT INTO nguNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pero ijcuac on fariseos ijcon oquitaquej, oquimijlijquej on inomachtijcahuan: ―¿Tlica on nemotemachtijcau tlacua inhuan on yejhuan tlacobrarohuaj ica on impuestos niman inhuan on ocsequimej tlajtlacolejquej? ");
INSERT INTO nguNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús ocac tlinon yejhuamej oquijtojquej, niman oquimijlij: ―Para on yejhuan xcualoj xquimpolohua on tepajtijquetl, pero on yejhuan cualoj quemaj. ");
INSERT INTO nguNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xhuiyan niman cuajli xcajsicamatitican tlinon quijtosnequi yejhua in Yectlajcuilojli ijcuac ijquin quijtohua: “Nejhua nicnequi teicnelilistli, amo tla yej nenquinhuentlalisquej on yolquej.” Ijcon quemaj nenquimatisquej ica nejhua xonihuajlaj para niquinnotzas on yejhuan yolmelajquej, yej para niquinnotzas on yejhuan tlajtlacolejquej. ");
INSERT INTO nguNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Quemaj on yejhuan cuicatinemiyaj Juan on tlacuatequijquetl oquinisihuijquej Jesús, niman oquitlajtoltijquej: ―¿Tlica tejhuamej niman on fariseos sanoyej titosahuaj, niman monomachtijcahuan xnosahuaj? ");
INSERT INTO nguNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús oquimijlij: ―Xhuelis najmanasquej on yejhuan tlanotzaltin campa nonamictihua, chica on montli ompa inhuan nemi. Pero yejcos on tonajli ijcuac nejhua yejhuan quen nimontli nechquixtisquej on notlahuelicnihuan intech on notlanotzcahuan. Niman ijcuacon quemaj yejhuamej nosahuasquej ican ajmantli. ");
INSERT INTO nguNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Xacaj quitlamanilia se tlaquentli ijsoltic ica on tlaquentli yejhuan yencuic, pampa on yejhuan yencuic tlaquentli tzolihui niman más hueyica quitzayana on tlaquentli ijsoltic. ");
INSERT INTO nguNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Niman no xquitecaj on vino yejhuan yencuic ipan on bolsas yejhuan tlachijchiutin ican on cuetlaxtin ijsoltiquej, pampa on vino posonis niman on bolsas toponisquej niman quemaj on vino ihuan on bolsas ixpolihuisquej. Yejhua ica xtlalican on vino yencuic ipan on bolsas yencuiquej, pampa ijcon quemaj san secan cuajli nocahuas. ");
INSERT INTO nguNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chica Jesús quimijliaya in tlajtlamach, se intlayecancau on hebreos ohuajlaj itech niman ixpan onotlacuenquetz. Niman yejhua oquijlij: ―Nochpotzin quinamantzin omic, pero tla tejhua tias niman ipan tictlalis moma, yejhua ocsejpa yolihuis. ");
INSERT INTO nguNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yejhua ica Jesús ohuanoquetzteu niman ihuan inomachtijcahuan oyajquej ihuan on tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","No ompa tehuan nemiya se sihuatl yejhuan quipia majtlactli huan ome xipan ica yeshuetztinemiya. Yejhua oquinisihuij Jesús icuitlapan niman ocajsic itempan itlaquen. ");
INSERT INTO nguNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ijcon oquichiu pampa yejhua oquinemilij: “Tla san nicajsis itlaquen, nejhua nipajtis.” ");
INSERT INTO nguNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Niman Jesús onocueptiquis, ocontac on sihuatl, niman oquijlij: ―Xmoyolchicahua, noconeu. Aman yotipajtic pampa otitlaneltocac. Quemaj nimantzin opajtic. ");
INSERT INTO nguNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ijcuac Jesús oajsic ne ichan on tlayecanquetl, niman oquitac ica on músicos nemiyaj listos para contocasquej on ichpocatzin, niman ica on tlacamej sa najcomantinemiyaj, ");
INSERT INTO nguNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","oquimijlij: ―Xquisacan nican, pampa on ichpocatzin xe miqui, yej san cochtica. Niman yejhuamej san ocuetzquilijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ijcuac otlan quinquixtiaj on tlacamej, Jesús ocalaquito niman oquitzquij ipan ima on ichpocatzin, niman yejhua onotelquetz. ");
INSERT INTO nguNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Niman nochihuiyan nimantzin omachiyato on tlen onochiu. ");
INSERT INTO nguNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús ompa oquis. Niman chica nejnentiaya, omemej ciegos oquitocaquej, niman quitzajtzilijtiayaj: ―¡Xtechicneli, xtechpalehui tejhua huejca teixhuiu itech David! ");
INSERT INTO nguNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Niman ijcuac Jesús ocalac ipan se cajli, on ciegos oquinisihuijquej, niman Jesús oquintlajtoltij: ―¿Nemejhuamej nenquineltocaj ica huelis nemechpajtis? Yejhuamej oquijtojquej: ―Quemaj, toTeco. ");
INSERT INTO nguNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ijcuacon Jesús oquinmatoquilij imixtololojhuan niman oquimijlij: ―Ma nochihua quen quimelahua nemotlaneltoc. ");
INSERT INTO nguNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Niman on imixtololojhuan opajtiquej. Niman Jesús sanoyej oquintlachicahuilij. Oquimijlij: ―Xchihuacan canica para ma ca yacaj quimatis aquinon omechpajtij. ");
INSERT INTO nguNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero yejhuamej ohuajquisquej, oquitetlajtlajtohuilijquej nochihuiyan on tlen Jesús oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ijcuac yejhuamej huajquistiayaj ne ipan on cajli, sequimej tlacamej ocuajhuiquilijquej Jesús se tlacatl nontzin yejhuan quipiaya se xcuajli espíritu. ");
INSERT INTO nguNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ijcuac Jesús oquixtij on xcuajli espíritu, on nontzin opeu tlajtohua. On tlacamej tlamojcaitayaj niman quijtohuayaj: ―Ipan in país itoca Israel xqueman tiquitayaj tlajtlamach quen yejhua in. ");
INSERT INTO nguNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero on fariseos quijtohuayaj: ―Yejhua in tlacatl quitequixtilia on xcuajcualtin espíritus, pampa on poder quiselia itech intlayecancau sa no yejhuamej on espíritus. ");
INSERT INTO nguNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús panotiaya nochihuiyan ipan pueblos niman cuadrillas. Niman nochihuiyan yejhua temachtijtiaya ipan intiopanhuan on hebreos niman quiteijlijtiaya on cuajli tlajtojli ica quen ijqui Dios tlamandarohua. Jesús quipajtijtiaya nochi cocolistli niman masqui san catlejhua cualolistli. ");
INSERT INTO nguNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ijcuac Jesús oquintac on tojlamej, sanoyej oquimicnelij, pampa yejhuamej najmanayaj niman xquipiayaj yolchicahualistli. Yejhuamej nemiyaj quen on borreguitos yejhuan xquipiaj intlajpixcau. ");
INSERT INTO nguNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ijcuacon oquimijlij inomachtijcahuan: ―Ica tlen melahuac tiquitaj ica sanoyej miyec tlatoctli, pero xmiyequej nemij tequitquej para pixcasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yejhua ica, tej, xtlajtlanilican iTeco on tlaquilyotl más ma quinhuajtitlani on pixcaquej para ma pixcaquij. ");
INSERT INTO nguNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Quemaj Jesús oquinsentlalij on majtlactli huan ome inomachtijcahuan, niman oquinmacac poder para ma quitequixtilican on xcuajcualtin espíritus niman para quipajtisquej nochi cocolistli niman masqui san catlejhua cualolistli. ");
INSERT INTO nguNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ijquin intojtoca on majtlactli huan ome apóstoles: achtopa Simón, yejhuan no itoca Pedro, niman Andrés on icniu, Jacobo niman Juan on icniu yejhuan iconehuan Zebedeo, ");
INSERT INTO nguNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo on yejhuan tlacobrarojquetl catca ican impuestos, Jacobo yejhuan iconeu Alfeo, Lebeo, yejhuan no itoca Tadeo, ");
INSERT INTO nguNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, on yejhuan tehuan tlapohuajli catca ne intech on cananistas, niman Judas Iscariote, yejhuan más saquin oquitemactilij Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús oquintitlan on majtlactli huan ome apóstoles, niman ijquin oquinnajnahuatij: ―Ma ca nenyasquej campa chantij on yejhuan xhebreos, nion ipan on pueblos de Samaria. ");
INSERT INTO nguNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yej xhuiyan ne campa on hebreos chantij. Yejhuamej quen iborreguitos Dios yejhuan polijcanemij. ");
INSERT INTO nguNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xhuiyan niman ijquin xteijlitij: “Ye huajlau on tonajli ijcuac Dios tlamandaros nican quen tlamandarohua ne ilhuicac.” ");
INSERT INTO nguNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xquimpajtican on yejhuan palanij innacayo niman on ocsequimej cocoxquej. Xquinyolihuitican on mimiquej. Xquintequixtilican on xcuajcualtin espíritus. Nemejhuamej xican tomin nenquiseliaj yejhua in poder, yejhua ica xtequitiltican niman ma ca xtecobrarocan. ");
INSERT INTO nguNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ma ca xquitquican tomin. ");
INSERT INTO nguNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ma ca xquitquican nemotlacual para nencuasquej ipan nemojhui. Ma ca ocsequi xquitquican nemotlaquen, nion nemocachuan. Nion ma ca xquitquican nemocojtopil. Nochi in tlajtlamach ma ca xquitquican, pampa on tequitquetl quimelahua quimacasquej itlaxtlahuil. ");
INSERT INTO nguNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ijcuac nemejhuamej nemajsisquej ipan se hueyican noso ipan se pueblo, ompa xtejtemocan yacaj cuajli tlacatl yejhuan nenhuelisquej nenquitlalisquej nemoyojlo itech, niman ichan xmocahuacan hasta ijcuac ocse pueblo nenyasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ijcuac nencalaquisquej ipan se cajli, ijquin xtetlajpalocan: “Xpiacan yolsehuilistli.” ");
INSERT INTO nguNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tla on tlacamej yejhuan chantij ipan on cajli cuajli mechselisquej, Dios quintiochihuas ican yolsehuilistli. Pero tla yejhuamej xcuajli mechselisquej, Dios xquinmacas yolsehuilistli. ");
INSERT INTO nguNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Niman tla on yejhuan chanejquej ipan on cajli noso ipan on pueblo xmechselisquej nion xquinequisquej mechcaquisquej, tla ijcon xquisacan niman xtzejtzelocan nemocxi ica on tlalteutli. ");
INSERT INTO nguNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ica tlen melahuac nemechijlia ica ipan on tonajli ijcuac Dios tetlaxtlahuilis, on yejhuan chanejquej ipan on pueblo más temojtij quiselisquej tlajtlacolmacalistli xquen on tlacamej yejhuan ochantijquej ne Sodoma niman Gomorra. ");
INSERT INTO nguNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Xcaquican! Nejhua nemechtitlani intzajlan on xcuajcualtin tlacamej quen on borreguitos yejhuan quistinemij intzajlan on lobos. Yejhua ica xmotacan sa no nemejhuamej quen on cohuamej niman xyolyemanquej quen on palomas. ");
INSERT INTO nguNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xmotacan sa no nemejhuamej, pampa on tlacamej mechtemacasquej intech on tetlacanonotzquej, niman no mechhuihuitequisquej ipan intiopanhuan. ");
INSERT INTO nguNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mechhuicasquej imixpan on gobernadores niman reyes san pampa nennechneltocaj. Ijcuac ijcon nemopan nochihuas, noca xtlajtocan imixpan niman imixpan on yejhuan xhebreos. ");
INSERT INTO nguNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Niman ijcuac mechtemactilisquej intech on tequihuajquej, ma ca sa xcomatztiacan tlinon nenquijtosquej noso quen ijqui nenquijtosquej, pampa ijcuac ajsis on hora para nentlajtosquej, Dios mechmacas tlinon nenquijtosquej. ");
INSERT INTO nguNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","On tlajtoltin yejhuan nenquijtosquej xnemoyaxca yes, yej on iEspíritu nemoTajtzin yejhua mechmacas on tlajtoltin. ");
INSERT INTO nguNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’On tlacamej quintemacasquej imicnihuan ma quinmictican, niman on tatajtin no quintemacasquej inconehuan, niman on teconehuan quintlahuelixnamiquisquej intajhuan niman quichihuasquej para ma miquican. Ijcon quinchihuilisquej pampa yejhuamej nechneltocaj. ");
INSERT INTO nguNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nochi tlacatl mechtlahuelitas san pampa nennechneltocaj. Pero yejhuan melajcanemis ican itlaneltoc hasta ijcuac nochi tlamis, Dios yejhua quimaquixtis. ");
INSERT INTO nguNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ijcuac mechtlahuelitasquej niman tlajtlamach ica mechtlajyohuiltisquej ipan se pueblo, xhuiyan ipan ocse. Tej, ica tlen melahuac nemechijlia ica nejhua yejhuan oninochiu Tlacatl nihuajlas ijcuac nemejhuamej xe tlami nenyahuij ipan nochi inpueblos on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Xacaj nomachtijquetl más hueyixticaj xquen on itemachtijcau, nion yacaj tlanamactli más hueyixticaj xquen on iteco. ");
INSERT INTO nguNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","On nomachtijquetl ma noyoltlali quijyohuis on tlajyohuilistli yejhuan quijyohuiya on itemachtijcau, niman on tlanamactli no quen yejhua on iteco. Tla nejhua nechtocayotiaj nidiablo, tla ijcon nemejhuamej más mechtocayotisquej ica tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Ma ca xquinmacajsican on tlacamej. Tej, nochi on temachtijli yejhuan iyanticaj pa nesis, niman nochi on temachtijli yejhuan ichtaca oncaj machiyas. ");
INSERT INTO nguNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tlinon nejhua nemechijlia campa xacaj nemi, nemejhuamej xtemachiltican ne campa tojlan. Niman tlinon nejhua nemechichtacaijlia, nochi tlacatl xpanextilican. ");
INSERT INTO nguNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma ca xquinmacajsican on yejhuan hueli quimictiaj nemotlalnacayo pero xhuelij itlaj quichihuiliaj nemoalma. Yej xmacajsican Dios yejhuan huelis quixoxotonis nemotlalnacayo niman cahuas nemoalma ne mictlan campa tetlajyohuiltiloyan. ");
INSERT INTO nguNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Tlen xsan se tomin valerohuaj omemej tototzitzintin? Pero nion semej yejhuamej on tototzitzintin hueli huetzi tla on toTajtzin xcahuilia. ");
INSERT INTO nguNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tej, hasta on tzontli ipan nemotzontecon nochi oncaj tlapohuajli cada sesentetl. ");
INSERT INTO nguNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yejhua ica, tej, ma ca xmomojtican. Nemejhuamej más nenhueyiquijtosnequij xquen miyequej tototzitzintin. ");
INSERT INTO nguNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Nochimej on yejhuan imixpan on tlacamej quijtosquej ica nechseliaj quen intemaquixtijcau, nejhua no niquijtos ixpan noTajtzin ilhuicac chanej ica niquinselia. ");
INSERT INTO nguNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero on yejhuan nonenequisquej nopampa imixpan on tlacamej, nejhua no ninonenequis impampa ixpan noTajtzin ilhuicac chanej. ");
INSERT INTO nguNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ma ca xnemilican ica nejhua onicuajquic yolsehuilistli ipan tlalticpactli. Nejhua, tej, xonicuajquic yolsehuilistli, yej nopampa notlahuelitalos. ");
INSERT INTO nguNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Onihuajlaj para noxexelosquej on tlacamej. Nopampa se telpochtli quipias tlahuejli itech itaj, niman se ichpochtli quipias tlahuejli itech inan, niman se sihuamontli quipias tlahuejli itech imonan. ");
INSERT INTO nguNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ijcon, tej, se quipias itlahuelicniu sa no ihuan ichanchanecahuan. ");
INSERT INTO nguNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’On yejhuan quitlajsojtlas itaj noso inan más xquen nejhua, xquimelahua noyaxca yes. Niman yejhuan quitlajsojtlas itelpoch noso ichpoch más xquen nejhua, xquimelahua noyaxca yes. ");
INSERT INTO nguNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Niman on yejhuan xquinequis quiselis on tlajyohuilistli ipan inemilis niman xquinequis nohuan yas, xquimelahua noyaxca yes. ");
INSERT INTO nguNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","On yejhuan quimanahuis inemilis para ma ca miquis nopampa, quipolos ialma. Pero on yejhuan quipolos inemilis san nopampa, yejhua quimaquixtis ialma. ");
INSERT INTO nguNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’On yejhuan mechselia, sa no ijqui quen nejhua nechselisquia. Niman yejhuan nechselia no quiselia on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yejhuan quiselia se tiotlajtojquetl pampa on tiotlajtojquetl quichihua itequiu Dios, sa no ijqui quiselis itlaxtlahuil quen quimacaj se tiotlajtojquetl. Niman yejhuan quiselia se cuajli tlacatl pampa yejhua cuajli tlacatl, sa no ijqui quiselis itlaxtlahuil quen quimacaj se cuajli tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Niman san aquinon yejhuan quimacas siquiera se vaso asesec semej nonomachtijcahuan, ica tlen melahuac quipias itlaxtlahuil. ");
INSERT INTO nguNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ijcuac Jesús otlan quinnajnahuatia on majtlactli huan ome inomachtijcahuan, onejcuanij ompa, niman oyaj para otemachtito niman otenojnotzato ne ipan ipueblos on región. ");
INSERT INTO nguNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ijcuac Juan yejhuan tzacuticatca oquimat tlinon Cristo quichihuaya, yejhua oquintitlan omemej inomachtijcahuan ");
INSERT INTO nguNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","para quitlajtoltisquej tla yejhua melahuac Cristo yejhuan ye oncaj para huajlas, noso yej quichasquej ocse. ");
INSERT INTO nguNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Quemaj Jesús ijquin oquinnanquilij on inomachtijcahuan Juan: ―Xhuiyan niman xquijlican Juan on tlen nemejhuamej nenquitztoquej niman nencactoquej. ");
INSERT INTO nguNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xtlajtlajtohuilican ica aman tlachaj on yejhuan ciegos, niman ica on yejhuan huilatzitzintin quistinemij, niman on yejhuan palaniyaj innacayo pajtij, niman on yejhuan nacastzatzamej tlacaquij, niman on yejhuan mimiquej yolihuij niman noquetztehua ipan intlalcon. Niman no xtlajtlajtohuilican ica on yejhuan mayanquej caquij on cuajli tlajtojli yejhuan quitemaca temaquixtilistli. ");
INSERT INTO nguNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dios quitiochihuas on yejhuan xqueman ometlamatis san nopampa. ");
INSERT INTO nguNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chica inomachtijcahuan Juan oyajquej, Jesús opeu quinnojnotza on tlacamej ica Juan, niman oquimijlij: ―¿Aquinon onenquitatoj ne tlapatlaco? ¿Onenquitatoj se tlacatl yejhuan nolinia itlaneltoc quen se ohuatl nolinijticaj ica on ajacatl? ");
INSERT INTO nguNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Aquinon, tej, onenquitatoj? ¿Onenquitatoj se tlacatl yejhuan tlaquempepetlacaj? Nemejhuamej nenquimatztoquej ica on yejhuan sanoyej tlaquempepetlacaj nemij ne inchan on reyes. ");
INSERT INTO nguNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tla ijcon, ¿aquinon onenquitatoj? ¿Onenquitatoj se tiotlajtojquetl? Quemaj on melahuac, niman yejhua más hueyixticaj xquen se tiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","In Juan yejhua on tenojnotzquetl yejhuan itechcopa in Yectlajcuilojli ijquin quijtohua: On yejhuan noachtotenojnotzcau nictitlanis moyecapan para yejhua mitzyectlalilis mojhui para tias ipan. ");
INSERT INTO nguNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ica tlen melahuac nemechijlia ica intzajlan nochimej on tlacamej xqueman yacaj otlacat yejhuan más hueyixticaj xquen Juan on tlacuatequijquetl. Pero in no melahuac ica on yejhuan quinocahuilia ma quimandaro Dios, más hueyixticaj xquen Juan. ");
INSERT INTO nguNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Desde ijcuac Juan on tlacuatequijquetl opeu quiteijlia on cuajli tlajtojli niman opeu tlacuatequia hasta aman, sanoyej noyolchicahualo para quinocahuiliaj Dios ne ilhuicac ma quinhuajmandarojtia. Pero yejhua san hueli quinhuajmandarohua on yejhuan itech noyolchicahuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hasta ijcuac Juan ohuajlaj, nochimej on tiotlajtojquej niman on itlanahuatil Moisés otlajtlajtojquej quen ijqui Dios tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Niman tla nemejhuamej nenquinequij nenquineltocasquej intemachtil, Juan sa no yejhua on tiotlajtojquetl Elías yejhuan onijtoj ica huajlas. ");
INSERT INTO nguNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tla nemejhuamej nenquipiaj nemotlamachilis, xcajsicamatican on tlen oniquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Tlinon ica huelis niquimixtlalos on tlacamej yejhuan nemij ipan in tonaltin? Yejhuamej ijcomej quen on telpocamej yejhuan nosehuiaj ne ipan plaza, niman ijquin quintzajtziliaj on intetlajsojcahuan: ");
INSERT INTO nguNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Otemechtlapichilijquej ica on acatlapitzajli quen quintlapichiliaj ipan se nonamictilistli, pero nemejhuamej xonemijtotijquej. Otemechcuicatlalijquej ica on tlacuicajli teajman yejhuan nocuicatiaj ijcuac se miqui niman xonenchocaquej.” ");
INSERT INTO nguNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ijcuac Juan ohuajlaj, nosahuaya niman xitlaj coniya. Pero yejhuamej oquijtojquej ica yejhua oquipix se xcuajli espíritu. ");
INSERT INTO nguNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Quemaj onihuajlaj, nejhua yejhuan oninochiu Tlacatl. Ijcuac nejhua yejhuan nitlacuani niman natlini onihuajlaj, yejhuamej oquijtojquej ica melahuac nitlacuan, niman ica sanoyej natlini. Niman oquijtojquej ica nitetlajsojcau itech on tlajtlacolejquej niman on yejhuan tlacobrarojquej ica on impuestos. Pero on ihueyi tlamatquilis Dios noteititia yejhua ica on tlen nochihua. ");
INSERT INTO nguNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Quemaj Jesús opeu quiteijlia ijqui quen on tlacamej yejhuan chantij ipan on pueblos campa más oquichiu imilagros ica sanoyej tlajtlacohuayaj. Yejhua ijquin temachtiaya, pampa on tlacamej yejhuan chantij ipan on pueblos xcajcahuayaj ica quichihuayaj on tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Oquimijlij: ―¡Lástima para yejhuamej on yejhuan chantij ipan on pueblo itoca Corazín niman ipan on pueblo itoca Betsaida! Xcuajli yes para yejhuamej pampa Dios sanoyej quincastigaros. Ijquin quinchihuilis pampa oquitaquej miyec milagros, pero xocajcajquej ica oquichijquej on tlen xcuajli. Tla on chanejquej ipan on huejhueyican intoca Tiro niman Sidón quitasquiaj on milagros yejhuan oquitaquej Corazín niman Betsaida, yejhuamej cahuasquiaj ica quichihuasquiaj on tlen xcuajli. Niman yejhuamej quitlalisquiaj tlaquentli tlachijchiutli ican ichtli niman quinotemilisquiaj tliconextli ipan intzontecon, para quiteititisquiaj ica yocajcajquej quichihuaj on tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Niman nemechijlia ica ipan on tonajli ijcuac Dios tetlaxtlahuilis, yejhuamej más hueyi tlajyohuilistli quiselisquej xquen on tlacamej yejhuan ochantijquej ne Tiro niman Sidón. ");
INSERT INTO nguNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Niman yejhuan chanejquej ipan on pueblo Capernaum sanoyej nohueyimatij ipampa on hueyilistli yejhuan quipia ipueblo. Pero inhueyimatilis quintlajcalis ne mictlan, pampa tla ne ipan on hueyican itoca Sodoma nochihuasquiaj on milagros yejhuan onochijquej ipan, manisquia on hueyican oc nemi. ");
INSERT INTO nguNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Niman nemechijlia ica ipan on tonajli ijcuac Dios tetlaxtlahuilis, yejhuamej on yejhuan chantij ne Capernaum más hueyi tlajyohuilistli quiselisquej xquen on tlacamej yejhuan ochantijquej ne Sodoma. ");
INSERT INTO nguNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ipan on tonajli Jesús oquichiu oración. Ijquin oquijtoj: ―Nimitzyectenehua noTajtzin, tejhua yejhuan iTeco on ilhuicac niman in tlalticpactli. Nimitzyectenehua pampa nochi in tlajtlamach xotiquinmachiltij on tlajmatquej niman on tlacajsicamatquej, pero otiquinmachiltij on yejhuan quen coconej. ");
INSERT INTO nguNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Melahuac noTajtzin, ijcon oticchiu quen oticnec. ");
INSERT INTO nguNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Nochi tlajtlamach noTajtzin onechmactilij. Xacaj nechixmati, nejhua yejhuan niiConeu, yej san yejhua on noTajtzin. Niman xacaj quixmati noTajtzin, yej san nejhua yejhuan niiConeu niman on yejhuan niquintlapejpenia para niquintitia. ");
INSERT INTO nguNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Xhuajlacan notech nemochimej yejhuan yonensiauquej pampa hasta aman xnenquinextiaj temaquixtilistli niman pampa on tlajtlamach tepajsolohualistin sanoyej mechyetiliaj, niman nejhua nemechmacas nesehuijli. ");
INSERT INTO nguNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xmocahuilican ma nemechpalehui niman xmocahuilican ma nemechmachti, pampa nejhua niyolsejqui niman niyolyemanqui, niman notech nenquinextisquej nesehuilistli para nemoalma. ");
INSERT INTO nguNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","On temachtijli yejhuan nejhua nemechmaca xtepopoloj para nenquitlacamatisquej, niman on tlanahuatijli yejhuan nejhua nemechmaca no xtepopoloj. ");
INSERT INTO nguNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ipan se tonajli ijcuac nosehuiaj on hebreos, Jesús nejnentiaya ne campaca tlatocyoj ican trigo. Inomachtijcahuan opeu apismiquij niman opeu quimaxicopinaj on trigo para quicuasquej on iteyo. ");
INSERT INTO nguNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ijcuac on fariseos ijcon oquitaquej, oquijlijquej Jesús: ―Xquinta, monomachtijcahuan tequitij, niman totlanahuatil xtechcahuilia para titequitisquej ipan on tonajli ijcuac on tlacamej nosehuiaj. ");
INSERT INTO nguNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero yejhua oquimijlij: ―¿Nemejhuamej xqueman nenquimomachtianij on tlen oquichijca David ijcuac yejhua niman itehuicalhuan oapismiquej? ");
INSERT INTO nguNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yejhua ocalac ichan Dios niman ihuan itehuicalhuan oquicuaj on pan yejhuan oquihuentlalilijcaj Dios, masqui on itlanahuatil Moisés san quincahuiliaya on tiopixquej quicuayaj on pan. ");
INSERT INTO nguNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Noso ca yej xqueman nenquimomachtiaj on itlanahuatil Moisés, ica on tiopixquej ipan hueyi tiopan xnosehuiaj ipan on tonaltin ijcuac nosehuiaj on hebreos, niman ica yejhuamej xquipiaj tlajtlacojli ijcuac ijquin quichihuaj? ");
INSERT INTO nguNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tej, nemechijlia ica nican nemi on yejhuan más hueyixticaj xquen on hueyi tiopan. ");
INSERT INTO nguNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","On Yectlajcuilojli quijtohua: “Nejhua nicnequi teicnelilistli, niman ma ca yej xquinhuentlalican on yolquej.” Tla nencajsicamatisquiaj tlinon quijtosnequi yejhua in Yectlajcuilojli, xnenquintlajtlacolmacasquiaj on tlacamej yejhuan xmelahuac quichihuaj on tlen ica nenquintlajtlacolmacaj. ");
INSERT INTO nguNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tej, nejhua yejhuan oninochiu Tlacatl nicpia tequihuayotl para niquijtos tlinon cuajli para se quichihuas ipan on tonajli ijcuac on hebreos nosehuiaj. ");
INSERT INTO nguNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Quemaj Jesús onejcuanij ompa, niman ocalaquito ipan on intiopan on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ompa nemiya se tlacatl yejhuan quipiaya se ima huaqui. No nemiyaj quesquimej tlacamej yejhuan quinequiyaj quinextilisquej tlinon ica huelisquej quiteixpanhuisquej Jesús. Yejhua ica oquitlajtoltijquej: ―¿Totlanahuatil techcahuilia para ticpajtisquej se cocoxqui ipan on tonajli ijcuac titosehuiaj? ");
INSERT INTO nguNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús oquinnanquilij: ―Tla semej nemejhuamej quipia se iborreguito niman on borreguito onhuetzi ijtic se pozo ipan on tonajli ijcuac on hebreos nosehuiaj, ¿xau para conquixtia? ");
INSERT INTO nguNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tej, se tlacatl más hueyi quijtosnequi xquen on borreguito. Ijcon, tej, totlanahutil techcahuilia ticchihuasquej on tlen cuajli ipan on tonajli ijcuac titosehuiaj. ");
INSERT INTO nguNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ijcuacon Jesús oquijlij on tlacatl yejhuan quipiaya se ima huaqui: ―Xmelahua moma. Niman ijcuac oquimelau, opajtic on ima, niman cuajli onocau quen on ocse ima. ");
INSERT INTO nguNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Quemaj oquisquej on fariseos ipan intiopan on hebreos, niman opejquej notlajtoltiaj quen ijqui huelisquej quimictisquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús oquimat on tlinon quinequij quichihuasquej niman yejhua ica onejcuanij. Miyec tlacatl oyaj ihuan, niman yejhua quimpajtiaya nochimej on cocoxquej. ");
INSERT INTO nguNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yejhua quinnahuatiaya para ma ca quiteijlisquej aquin yejhua. ");
INSERT INTO nguNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yejhua in onochiu para otenquis on tlen oquiteijlijca on tiotlajtojquetl Isaías, ijcuac oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","In yejhua notequipanojcau yejhuan onictlapejpenij, quijtohua Dios. Yejhua nictlajsojtla, niman itech nipacticaj. Ipan nictlalia noEspíritu para quimijlis on xhebreos ica cada se nictlaxtlahuilis quen quitocarohua on tlen quichihua. ");
INSERT INTO nguNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Xtehuan nocamatlanis, nion xtehuan notzajtzilis. Niman no xacaj caquis sa tzajtzi ijcuac temachtia ipan calles. ");
INSERT INTO nguNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yejhua xquitlajcali on yejhuan xcojtic xijqui quen se tlacatl quitlajcali se acatl yejhuan xcuajli. Yejhua xquisehuis itlahuil ialma on yejhuan xhueyi tlahuijli quipia ipan ialma, xquen se tlacatl quisehuia yejhua on mecha yejhuan sa popocaticaj. Yejhua quimpalehuijtias hasta queman tetlanis nochi on tlen cuajli. ");
INSERT INTO nguNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Niman on xhebreos quineltocasquej ica yejhua quinmaquixtis. ");
INSERT INTO nguNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Quemaj ocuiquilijquej Jesús se tlacatl ciego niman nontzin yejhuan quipia se xcuajli espíritu. Jesús oquipajtij. Ijcon, tej, on tlacatl ohuel otlachix niman ohuel otlajtoj. ");
INSERT INTO nguNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nochi tlacatl otlamojcaitac, niman oquijtoj: ―¿Manin in yejhua huejca teixhuiu itech David yejhuan Dios oquitlapejpenij para techmandaros? ");
INSERT INTO nguNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero ijcuac on fariseos ijcon ocacquej, oquijtojquej: ―Yejhua in tlacatl quintequixtilia on xcuajcualtin espíritus san ican ipoder on diablo, on yejhuan inhueyi tlayecancau. ");
INSERT INTO nguNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús quimatzticatca tlinon yejhuamej quinemilijticatcaj, niman oquimijlij: ―Tla se país notlajcoxelohua, xoxotoni. Niman nochi hueyican noso chanyotl yejhuan noxexelohuaj ican tlahuejli, xqueman huejcahuij san secan nemij. ");
INSERT INTO nguNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satanás, tej, quinmandarohua on xcuajcualtin espíritus. Niman tla sa no yejhua quitequixtilia on xcuajcualtin espíritus, ¿quen ijqui, tej, huelis san secan nemisquej? ");
INSERT INTO nguNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Tla nejhua nictequixtilia on xcuajcualtin espíritus ican ipoder on diablo quen nennechtenehuiliaj, tla ijcon, ¿aquinon quinmaca poder para quitequixtiliaj on yejhuan nopohuaj nemotech? Sa no yejhuamej, tej, quijtosquej tla melahuac noso ca on tlen onennechijlijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero nejhua nictequixtilia on xcuajcualtin espíritus ican iEspíritu Dios, niman yejhua in quijtosnequi ica Dios yohuajlaj para mechmandaros. ");
INSERT INTO nguNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Quen ijqui, tej, huelis yacaj calaquis ichan se tlacatl yejhuan sanoyej cojtic niman cuilis on tlen quipia, tla xachtopa quisalohua? San ijcon, tej, huelis quixtilis on tlen yejhua quipia. ");
INSERT INTO nguNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’On yejhuan xnohuan nopohua, quejecohua quiteltlalis notequiu. Niman on yejhuan xnohuan pixca, quichajchayahua on tlaquilyotl. ");
INSERT INTO nguNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yejhua ica nemechijlia ica Dios huelis quintlapojpolhuis nochi intlajtlacolhuan on tlacamej niman nochi tlahuijhuicaltilistli. Pero tla yej cuijhuicaltis on Espíritu Santo, yejhua xqueman quintlapojpolhuis. ");
INSERT INTO nguNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Niman san aquinon yejhuan nechtenehuilis se tlajtojli yejhuan xcuajli nejhua yejhuan oninochiu Tlacatl, Dios huelis quitlapojpolhuilis, pero on yejhuan quitenehuilis tlen xcuajli on Espíritu Santo, Dios xquitlapojpolhuis ipan in nemilistli nion ipan ocse. ");
INSERT INTO nguNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Tla on cojtlaquilyotl yejhua cuajli, quitlaquitia cuajli itlaquiliyo. Niman tla on cojtlaquilyotl yejhua xcuajli, xcuajli tlaqui itlaquiliyo. Yejhua ica, tej, on cojtlaquilyotl nenquixmatisquej tla cuajli noso xcuajli ica on itlaquiliyo. ");
INSERT INTO nguNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Teconehuan intech cohuamej! Xnenhuelisquej nenquijtosquej on tlajtlamach tlen cuajli ijcuac nemejhuamej xnencuajcualtin. Tej, on tlen quisa ipan tecamac hualehua ne ipan teyojlo campa yejhua ica tlatentoc. ");
INSERT INTO nguNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","On yejhuan cuajli tlacatl quijtohua tlajtlamach tlen cuajli pampa ipan iyojlo quipia on tlen cuajli. Niman on yejhuan xcuajli tlacatl quijtohua tlajtlamach tlen xcuajli pampa ipan iyojlo xquipia on tlen cuajli. ");
INSERT INTO nguNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Niman nejhua nemechijlia ica ipan on tonajli ijcuac Dios quintlaxtlahuilis on tlacamej, nochimej yejhuamej quimacasquej cuenta Dios nochi on tlen camaijnehuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ijcon, tej, ican nemotlajtol yejhuan cuajli xnemotlajtlacolmacasquej, pero ican nemotlajtol yejhuan xcuajli nemotlajtlacolmacasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Quemaj semej fariseos niman on yejhuan temachtijquej ican itlanahuatil Moisés oquijlijquej Jesús: ―Temachtijquetl, ticnequij tiquitasquej xchihua itlaj tlamajhuisojli milagrosa. ");
INSERT INTO nguNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús oquimijlij: ―On xcuajcualtin tlacamej, yejhuan ixcoejehuaj Dios quen se sihuatl ixcoejehua ihuehuentzin, quinequij quitasquej se tlamajhuisojli milagrosa. Pero xniquintitis ocse más, yej san yejhua on tlen oquichiu on tiotlajtojquetl Jonás. ");
INSERT INTO nguNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ijcon quen Jonás onen yeyi tonajli niman yeyi yehuajli ijtic on hueyi michin, no ijqui nejhua yejhuan oninochiu Tlacatl yeyi tonajli niman yeyi yehuajli ninemis ne ijtic on tlajli. ");
INSERT INTO nguNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","On yejhuan ochantijquej ne ipan on hueyican itoca Nínive ocacquej Jonás yejhuan oquimijlij on itemachtil Dios. Niman ijcuac ocacquej, yejhuamej ocajcajquej ica quichihuaj on tlen xcuajli. Tej, nemechijlia ica nican nemi on yejhuan más hueyixticaj xquen Jonás, niman on tlacamej yejhuan aman nemij xcajcahuaj ica quichihuaj on tlen xcuajli. Yejhua ica ijcuac on yejhuan aman nemij notelquetzasquej ixpan Dios ipan on tonajli ijcuac yejhua quintlaxtlahuilis nochimej, on yejhuan ochantijquej ne Nínive noquetztehuasquej niman quintlajtlacolmacasquej in tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","No ijqui on sihuatlamandarojquetl ne Sur ohualeu ne campa sanoyej huejca para ocaquico on itlamatquilis Salomón. Tej, nemechijlia ica nican nemi on yejhuan más hueyixticaj xquen Salomón. Yejhua ica on sihuatlamandarojquetl ne Sur no noquetztehuas ipan on tonajli ijcuac Dios quintlaxtlahuilis nochimej, niman yejhua quintlajtlacolmacas in tlacamej yejhuan chantij ipan in tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Ijcuac se xcuajli espíritu quisa ijtic se tlacatl, pehua quistinemi campa tlayohuatoc. Quitejtemojtinemi canon nosehuis. Niman ijcuac xhueli quinextia, quinemilia: ");
INSERT INTO nguNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Ocsejpa nias ne nochan campa oniquis.” Ijcuac yejco, quinextia on tlacatl quen se cajli yejhuan xacaj quitequitiltia, tlachpancan ijtic, niman cuajli tlaojoncaj. ");
INSERT INTO nguNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Quemaj yau cominana ocse chicomemej más xcuajcualtin espíritus xquen yejhua, niman nochimej calaquij para chantisquej ijtic on tlacatl. Ijcuacon on tlacatl más sanoyej xcuajli nocahua xquen ijcuac san se on xcuajli espíritu quipiaya. No ijqui impan nochihuas in xcuajcualtin tlacamej yejhuan chantij ipan in tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús oc quinnojnotzticatca on tlacamej, ijcuac oajsiquej inan niman icnihuan. Onocajquej ipan ojtli, niman quinequiyaj ihuan tlajtosquej. ");
INSERT INTO nguNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yacaj oquijlij Jesús: ―Monan niman mocnihuan ompa nemij ipan ojtli, niman mitznotzasnequij. ");
INSERT INTO nguNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero yejhua oquinanquilij niman oquijlij on yejhuan oquimachiltij: ―¿Aquinon on nonan, niman aquinomej on nocnihuan? ");
INSERT INTO nguNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Quemaj ocominmajpilhuij on inomachtijcahuan, niman oquijtoj: ―In yejhuamej nonan niman nocnihuan, ");
INSERT INTO nguNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","pampa san aquinon yejhuan quichihua on tlen quinequi noTatzin ilhuicac chanej, on yejhua nocniu noso yejhua nonan. ");
INSERT INTO nguNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ipan sa no yejhua on tonajli, Jesús oquis ne ipan on cajli niman onotlalij ne itenco on mar. ");
INSERT INTO nguNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ica sanoyej miyec tlacatl onosentlalij ne campa yejhua nemiya, Jesús otlejcoc ipan se barco niman onotlalij, niman nochi tlacatl onocau ne itenco on mar. ");
INSERT INTO nguNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Niman opeu quinmachtia miyec tlajtlamach ican ejemplos. Quimijliaya: ―Sen tlaxinijquetl oyaj tlaxinito. ");
INSERT INTO nguNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ijcuac tlaxinijtiaya, sequi xinachtli oxinito ipan ojtli, niman on totomej ohualajquej niman ocuajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ocsequi xinachtli oxinito ipan tepetlayoj campa xmás oncaj tlajli. On xinachtli nimantzin oquis, pampa xmás huejcatlan oncatca on tlajli campa oxin. ");
INSERT INTO nguNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero ijcuac oquis on tonaltzintli, ocoseu imilyo on trigo. Niman ica xhuejcatlan quipiaya inelhuayo, ohuajhuac. ");
INSERT INTO nguNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ocsequi xinachtli oxinito intzajlan on huitzcojtin. On huitzcojtin saniman onoscaltijquej niman oquixomictiquej imilyo on trigo. ");
INSERT INTO nguNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero ocsequi xinachtli oxin ipan on cuajli tlajli, niman oquipix cuajli itlaquiliyo. Sequi xinachtli oquitlaquitij se ciento iteyo, ocsequi sesenta, niman ocsequi treinta. ");
INSERT INTO nguNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tla nemejhuamej nenquipiaj nemotlamachilis, xcajsicamatican on ejemplo. ");
INSERT INTO nguNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Quemaj on nomachtijquej oquinisihuijquej Jesús, niman oquitlajtoltijquej: ―¿Tlica tiquinnojnotza on tlacamej ican ejemplos? ");
INSERT INTO nguNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yejhua oquimijlij: ―Nemejhuamej Dios yomechcahuilij para nenquimatisquej on tlinon iyanticatca quen ijqui yejhua tlamandarohua. Pero yejhuamej in tlacamej xquincahuilia ma quimatican. ");
INSERT INTO nguNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","San aquinon yejhuan cajsicamati itemachtil Dios, Dios quipalehuis para más cajsicamatis sanoyej miyec. Pero on yejhuan xcajsicamati itemachtil Dios, quixtilisquej on tlen achijtzin cajsicamati. ");
INSERT INTO nguNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yejhua ica niquinnojnotza ican ejemplos, pampa masqui quitaj on tlen nicchihua, yejhuamej xquinomacaj cuenta, niman masqui caquij on tlen niquijtohua, yejhuamej xcajsicamatij. ");
INSERT INTO nguNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ijcon, tej, cuajli impan nochihua tlen on tiotlajtojquetl Isaías oquijtoj: Nemejhuamej ican nemonacashuan nentlacaquisquej, pero xitlaj nencajsicamatisquej. Ican nemixtololojhuan nentlachasquej, pero xnenquimatisquej tlinon quijtosnequi on tlen nenquitasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yejhua in nochihua, pampa intlamachilis in tlacamej xtequiti. Yejhuamej nonacastzajtzacuasquej niman nixtzajtzacuasquej para ma ca tlachasquej ican imixtololojhuan, nion ma ca tlacaquisquej ican innacashuan, nion ma ca itlaj cajsicamatisquej ican intlamachilis, nion ma ca nocuepasquej notechica para nejhua niquinmaquixtis. ");
INSERT INTO nguNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero Dios mechtiochihua nemejhuamej, pampa nentlachaj ican nemixtololojhuan, niman nenquimatij tlinon quijtosnequi on tlen nenquitaj. Niman no nencajsicamatij on tlen nencaquij niquijtohua. ");
INSERT INTO nguNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ica tlen melahuac nemechijlia ica miyequej tiotlajtojquej niman on yejhuan cuajcualtin tlacamej sanoyej oquinequej quitasquej yejhua in tlen nemejhuamej nenquitaj, pero xoquitaquej. Niman yejhuamej sanoyej oquinequej caquisquej in tlen nemejhuamej nencaquij, pero xocacquej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Xcaquican, tej, on tlen quijtosnequi iejemplo on tlaxinijquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","On ojtli yejhuan ipan oxinito quesqui xinachtli quijtosnequi inyojlo on tlacamej yejhuan ica caquij itlajtol Dios yejhuan quimijlia ica Dios quinequi quinmandaros, niman xcajsicamatij. Yejhua ica on Satanás huajlau niman quinquixtilia itlajtol Dios ipan inyojlo. ");
INSERT INTO nguNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","On tlajli yejhuan tepetlayoj quijtosnequi inyojlo on tlacamej yejhuan ica cuelcaquij itlajtol Dios niman ican pactli quiseliaj. ");
INSERT INTO nguNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero yejhua in tlacamej xmás cuajli quitzquiaj on tlajtojli. Yejhua ica, ijcuac impan huajlau on tlen tepajsoloj niman on tlen tetlajyohuiltia ipampa itlajtol Dios, nimantzin cahuaj intlaneltoc. ");
INSERT INTO nguNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","On tlajli yejhuan huitzyoj quijtosnequi inyojlo on tlacamej yejhuan cuelcaquij itlajtol Dios. Pero pampa sa comatztoquej quen ijqui nopanoltisquej niman sanoyej quinequij notomintisquej, quelcahuaj itlajtol Dios. Ijcon, tej, itlajtol Dios xhueli quimpalehuiya yejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero on cuajli tlajli quijtosnequi inyojlo on tlacamej yejhuan ica cuelcaquij niman cajsicamatij itlajtol Dios, niman intech quisa se cuajli tlaquiliyotl. Yejhuamej sa no ijqui quen on xinachtli yejhuan oquitlaquitij se ciento iteyo, niman ocsequimej sa no ijqui quen on yejhuan oquitlaquitij yepoajli, noso sa no ijqui quen on yejhuan oquitlaquitij sempoajli huan majtlactli. ");
INSERT INTO nguNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús no oquintlalilij in ocse ejemplo: ―Niman ipan in tlalticpactli campa Dios tlamandarohua sa no ijqui quen se tlajli campa se tlacatl quitoca ican cuajli xinachtli. ");
INSERT INTO nguNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero ijcuac iteco on tlajli niman itequitcahuan cochticatcaj, ocalaquito se itlahuelicniu niman oquitocac on xcuajli xojtli intzajlan on trigo. Niman quemaj onejcuanij. ");
INSERT INTO nguNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ijcuac on trigo onoscaltij niman omiyahuatlapan, no ompa ones on xcuajli xojtli. ");
INSERT INTO nguNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Quemaj on tequitquej ohualajquej itech on iteco on tlajli, niman oquijlijquej: “Señor, tla yejhua on xinachtli yejhuan otictocac ne ipan on motlal cuajli catca, ¿canon, tej, ohualeu on xcuajli xojtli?” ");
INSERT INTO nguNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Niman iteco on tlajli oquimijlij: “Yacaj notlahuelicniu oquichiu yejhua on.” Quemaj itequitcahuan oquitlajtoltijquej: “¿Ticnequi para ma ticuihuitlatij on xcuajli xojtli?” ");
INSERT INTO nguNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Niman yejhua oquimijlij: “Ca, xnicnequi, pampa ijcuac nencuihuitlasquej on xcuajli xojtli, no huelis tehuan nencuihuitlasquej on trigo. ");
INSERT INTO nguNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Más cuajli xcahuilican ma ihuan noscalti hasta ma chicahui on trigo. Niman ijcuac yochicau, niquinnahuatis on pixcaquej achtopa ma quisentlalican on xcuajli xojtli niman ma quisalocan por manojos para tlatlas. Niman quemaj niquinnahuatis ma quisentlalican on trigo niman ma quitlalican ipan nocuescon.” ");
INSERT INTO nguNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús no oquintlalilij yejhua in ocse ejemplo: ―On tlacamej yejhuan Dios quinmandarohua ipan in tlalticpactli miyequixtihuij sa no ijqui quen iteyo mostaza ijcuac se tlacatl yoquitocac ipan itlal nomayehualojtiu. ");
INSERT INTO nguNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","On melahuac ica yejhua más pitentzin xinachtli xquen nochimej on xinachtin yejhuan onoquej. Pero ijcuac noscaltia, nochihua más hueyi xquen nochi on tlen quitocaj. Yejhua hueyiya quen itlaj hueyi cojtli, niman hasta on totomej huajlahuij itech niman notepajsoltiaj ipan imatzitzihuan. ");
INSERT INTO nguNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","No oquintlalilij yejhua in ocse ejemplo: ―On tlacamej yejhuan Dios quinmandarohua ipan in tlalticpactli ijcomej quen on tlaxocolilistli yejhuan se sihuatl quimanelohua ican yeyi tlatemachihuajli harina hasta queman nochi najcocui. ");
INSERT INTO nguNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nochi yejhua in Jesús oquimijlij on tlacamej ican ejemplos niman xitlaj quimijliaya tla xican ejemplo. ");
INSERT INTO nguNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yejhua ijquin oquichiu san para otenquis on tlen oquijtoj on tiotlajtojquetl ijcuac ijquin oquijcuiloj: Nitenojnotzas ican ejemplos, niman niquijtos on tlajtlamach yejhuan ichtaca oncaj desde ijcuac Dios oquichijchiu in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Quemaj Jesús oquimijlij on tojlan ica ye yau. Quemaj ocalaquito ipan on cajli, niman inomachtijcahuan oquinisihuijquej, niman oquijlijquej: ―Cuajli xtechmelajcaijli iejemplo yejhua on xcuajli xojtli yejhuan oquis ne itzajlan on trigo. ");
INSERT INTO nguNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ijcuacon Jesús oquimijlij: ―On yejhuan quitoca on cuajli xinachtli sa no nejhua yejhuan oninochiu Tlacatl, ");
INSERT INTO nguNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","niman on tlajli yejhuan trigojyoj sa no yejhua in tlalticpactli. On cuajli xinachtli quijtosnequi on tlacamej yejhuan teconehuan itech Dios, niman on xcuajli xojtli quijtosnequi on yejhuan teconehuan itech diablo, ");
INSERT INTO nguNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","niman on tetlahuelicniu yejhuan oquitocac on xcuajli xojtli sa no yejhua on diablo. On tonaltin ijcuac on pixcaquej quitequij on trigo quijtosnequi on tonaltin ijcuac tlatlalpolihuis, niman on pixcaquej yejhuan quitequij on trigo sa no yejhuamej on ilhuicactequitquej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ijcon quen on xcuajli xojtli nosentlalia niman conxiniaj ipan tlitl para tlatla, no ijqui nochihuas ijcuac tlatlalpolihuis. ");
INSERT INTO nguNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nejhua yejhuan oninochiu Tlacatl niquinhuajtitlanis noilhuicactequitcahuan para quinhuajsentlalisquej niman quinquixtisquej intzajlan on tlacamej yejhuan niquinmandarohua nochimej on yejhuan quichihuaj para ocsequimej ma tlajtlacocan, niman on yejhuan quichihuaj on tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Niman cominxinisquej ne tlico campa yejhuamej sanoyej chocasquej niman notlantotopotzasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ijcuacon on yejhuan cuajcualtin petlanisquej quen on tonaltzintli ne campa inTajtzin tlamandarohua. Tla nemejhuamej nenquipiaj nemotlamachilis, xcajsicamatican on ejemplo. ");
INSERT INTO nguNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’On tlacatl yejhuan quinequi Dios ma quimandaro quen se tlacatl yejhuan oquinextij on tesoro ipan se tlajli campa iyanticatca. Ijcuac oquinextij on tesoro, ocsejpa ompa oquiyan. Niman ican paquilistli oyaj ichan, niman oquinamacato nochi tlen quipia. Quemaj ocou on tlajli campa oquinextij on tesoro. ");
INSERT INTO nguNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’On tlacatl yejhuan quinequi calaquis ne campa Dios tlamandarohua, no quitejtemojtinemi on perlas yejhuan sanoyej cualtetzitzintin. ");
INSERT INTO nguNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Niman ijcuac quinextia se yejhuan sanoyej patioj, yau ichan, niman quinamaca nochi tlen quipia, niman cohua on perla. ");
INSERT INTO nguNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ne campa Dios ilhuicac chanej tlamandarohua no ijqui quen se matlatl yejhuan conchapaniaj ipan mar niman quisentlalia miyec sesetlamantic michimej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ijcuac temi on matlatl, on michajsiquej quixtiaj ne itenco on mar, niman ompa notlaliaj para quintlapejpeniaj on michimej. Yejhuamej quejehuaj on yejhuan cuajcualtin ipan chiquiutin, niman quixiniaj on yejhuan xcuajcualtin. ");
INSERT INTO nguNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ijcon nochihuas ijcuac tlatlalpolihuis. On ilhuicactequitquej quisasquej para quinxelosquej on yejhuan xcuajcualtin tlacamej intech on yejhuan cuajcualtin tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Niman cominxinisquej on xcuajcualtin tlacamej ne tlico campa sanoyej chocasquej niman notlantisisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Quemaj Jesús oquintlajtoltij: ―¿Nencajsicamatij nochi yejhua in? Yejhuamej oquijtojquej: ―Quemaj, toTeco. ");
INSERT INTO nguNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Quemaj oquimijlij: ―Ijcuac se temachtijquetl ica on tlanahuatijli nomachtia quen Dios tlamandarohua, hueli quitemachtia on yencuic temachtilistli niman on yejhuan xencuic. Yejhua, tej, sa no ijqui quen se tlayejyejquetl ipan se cajli yejhuan quimati quen ijqui quixtia itech on tlen quipia tlajtlamach yejhuan yencuic niman yejhuan xencuic. ");
INSERT INTO nguNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ijcuac Jesús otlan quiteijlia in ejemplos, oyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ijcuac oajsic ipan ipueblo, opeu temachtia ne ipan intiopan on tlacamej. Yejhuamej oometlamatquej niman ocualancatlanemilijquej. Yejhua ica quijtohuayaj: ―¿Canon ohuelito in tlacatl on tlamatquilistli? ¿Quen ijqui hueli quichihua yejhua in milagros? ");
INSERT INTO nguNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","In, tej, yejhua iconeu on cojxinqui, niman no yejhua inan María. Yejhua icnihuan Jacobo, José, Simón niman Judas. ");
INSERT INTO nguNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Niman nochimej icnihuan yejhuan sihuamej no nican totzajlan chantij. ¿Canon, tej, hueli quimati niman quichihua nochi yejhua in tlajtlamach? ");
INSERT INTO nguNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Niman yejhuamej ocualanquej itechcopa Jesús. Pero yejhua oquimijlij: ―Sen tiotlajtojquetl nochihuiyan quitlacaitaj, pero ipan ipueblo niman intzajlan ichanchanecahuan xquitlacaitaj. ");
INSERT INTO nguNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Niman ompa xoquichiu miyec milagros, pampa yejhuamej xquineltocayaj. ");
INSERT INTO nguNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ipan on tonaltin, Herodes, on gobernador ne Galilea, ocac on tlen huejhueyi quichihuaya Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Niman yejhua oquimijlij itequitcahuan yejhuan quipalehuiyaj para tlamandarohua: ―On yejhua Juan on tlacuatequijquetl. Yejhua yonoyolihuitij niman yonoquetzteu intzajlan on mimiquej. Yejhua ica yejhua hueli quichihua on milagros. ");
INSERT INTO nguNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes ijcon oquijtoj, pampa yejhua otlanahuatij ma cajsican Juan, niman ma quisalocan ican teposcadenas niman ma quitzacuacan para quipactis Herodías yejhuan isihuau. Yejhua in Herodías isihuau catca Felipe on icniu Herodes. ");
INSERT INTO nguNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Herodes oquitzacu Juan pampa yejhua quijliaya: ―Itlanahuatil Dios xmitzcahuilia ticpias isihuau mocniu quen mosihuau. ");
INSERT INTO nguNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes quinequiya quimictis Juan, pero quinmacajsiya on tlacamej, pampa nochimej quineltocayaj ica Juan se tiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero ijcuac oquichijquej ilhuitl ipan ilhuiu Herodes, imixpan on itenotzcahuan onijtotij ichpoch Herodías. Niman Herodes sanoyej ocuelitac quen onijtotij on ichpochtli. ");
INSERT INTO nguNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yejhua ica oquiprometerohuilij niman onocalactij ican itlajtol para quimacas san tlinon yejhua quitlajtlanis. ");
INSERT INTO nguNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ijcuacon yejhua ican itlanahuatil inan oquijlij Herodes: ―Nican ipan se plato xnechmaca itzontecon Juan on tlacuatequijquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ijcuacon on rey Herodes onajman, pero pampa yonocalactijca ican itlajtol, niman impampa on itenotzcahuan yejhuan ihuan tlacuaj, on rey otlanahuatij para ma quimacacan. ");
INSERT INTO nguNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Oquintitlan on isoldados ma quiquechtzontequitij Juan ne campa tzacuticaj. ");
INSERT INTO nguNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Quemaj ocuajquiquej itzontecon ipan se plato, niman oquimacaquej on ichpochtli. Quemaj yejhua oquitquic niman oquimactilij inan. ");
INSERT INTO nguNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Quemaj ohualajquej on yejhuan inomachtijcahuan Juan, niman oquitquiquej on itlalnacayo niman ocahuatoj ipan tlalcontli. Quemaj oyajquej oquimachiltitoj Jesús on tlinon onochiu. ");
INSERT INTO nguNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ijcuac Jesús ijcon oquimat, onejcuanij ompa niman oyaj ipan barco campaca xacaj nemi. Pero ijcuac on tlacamej oquimatquej ica Jesús ye yau, yejhuamej oquisquej ipan on pueblos, niman onejnentiajquej ocuitlapanhuijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ijcuac Jesús oquis ipan on barco, oquitac ica miyec tlacatl ompa quichixticatca. Yejhua oquimicnelij niman oquimpajtij on cocoxquej yejhuan quinhuicayaj. ");
INSERT INTO nguNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ijcuac ye tiotlac catca, on inomachtijcahuan Jesús ohualajquej itech, niman oquijlijquej: ―Ye tiotlac, niman xacaj nican chanti. Xquintitlani on tlacamej para ma huiyan ipan on pueblitos niman ma cohuacan tlen quicuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús oquimijlij: ―Ca, xquipiaj tlica yasquej. Sa no nemejhuamej xquinmacacan tlinon quicuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yejhuamej oquijlijquej: ―Pero san ticpiaj macuijli pan niman ome michin. ");
INSERT INTO nguNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús oquimijlij: ―Xnechajcuilican nican. ");
INSERT INTO nguNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Quemaj otlanahuatij para on tlacamej ma notlajtlalican ipan on sacayoj. Quemaj ijcuac ocontilan on macuijli pan niman on ome michimej, oajcotlachix ne ilhuicac niman oquimacac tlaxtlahuijli Dios para on tlacuajli. Niman quemaj oquitlatlapan on pan niman oquinmacac on inomachtijcahuan para ma quinxexelohuilican on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nochimej otlacuajquej niman cuajli oixhuiquej. Quemaj on nomachtijquej ica on tlatlajcotzitzin tlen onocau oquitemiltijquej majtlactli huan ome chiquiutin. ");
INSERT INTO nguNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","On yejhuan otlacuajquej canaj macuijli mil tlacamej, pero xtehuamej tlapohualti on sihuamej nion on coconej yejhuan no otlacuajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Quemaj Jesús oquinnahuatij on inomachtijcahuan para ma calaquican ipan on barco, niman ma yecatztiacan ipan ocse ilado on mar chica yejhua quinnahuatiaya on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Más saquin, ijcuac yoquintitlan on tlacamej, Jesús otlejcoc ipan on tepetl para iselti oquichihuato oración. Ijcuac otlayohuac, Jesús iselti ompa nemiya. ");
INSERT INTO nguNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ipan on mismo tiempo on barco ye atlajcotian yaya, niman on olas ontlahuitequiyaj itech on barco, pampa sanoyej chicahuac ajacatl tlahuitequiya intech yejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ijcuac canaj ipan yeyi hora ica cualcan, Jesús nejnentiaya ne ixco on mar niman oquinnisihuij inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Niman ijcuac on inomachtijcahuan oquitaquej nejnentiu ne ixco on mar, sanoyej onomojtijquej. Yejhuamej oquijtojquej: ―¡Aj! ¡Ne nemi se tlamojtiloni! Niman omojcatzajtziquej. ");
INSERT INTO nguNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Jesús nimantzin oquinnotz, niman oquimijlij: ―Xmoyolchicahuacan. Nejhua niJesús. Ma ca xmomojtican. ");
INSERT INTO nguNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ijcuacon Pedro oconanquilij, niman oquijlij: ―NoTeco, tla tejhua, xtlanahuati ma nihuiya ipan on atl hasta campa tejhua tinemi. ");
INSERT INTO nguNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús oquijlij: ―Xhuajla, tej. Ijcuacon Pedro otemoc ipan on barco, niman opeu nejnemi ipan on mar para yas campa nemi Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero ijcuac oquitac on temojtij ajacatl, onomojtij niman opeu apolaqui. Quemaj ijquin otzajtzic: ―¡Xnechmaquixti, noTeco! ");
INSERT INTO nguNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nimantzin Jesús oquitzquij ipan ima, niman oquijlij: ―¡Semi achijtzin ticpia tlaneltoctli! ¿Tlica otiometlamat? ");
INSERT INTO nguNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Niman ijcuac yejhuamej otlejcoquej ipan on barco, onoteltij on ica chicahuac ajacaya. ");
INSERT INTO nguNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Quemaj on yejhuan nemiyaj ne ipan barco onotlacuenquetzquej ne ixpan Jesús, niman oquimahuistilijquej. Oquijlijquej: ―Tlacaj melahuac tejhua tiiConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Niman ijcuac oquipanahuijquej on mar, oajsiquej ipan on tlajli itoca Genesaret. ");
INSERT INTO nguNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ijcuac on tlacamej yejhuan chanejquej ipan on lugar oconixmatquej, oquitemachiltitoj nochihuiyan ipan on regiónes ica Jesús ye ompa nemi. Yejhua ica oquinhuajhuicaquej nochimej on cocoxquej ne campa Jesús nemiya. ");
INSERT INTO nguNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Niman on tlacamej sanoyej oquitlajtlanilijquej para on cocoxquej ma quincahuili ma quimatoquilican, masqui san itencotzin on itlaquen. Niman nochimej yejhuan oquimatoquilijquej, opajtiquej. ");
INSERT INTO nguNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Quemaj semej fariseos niman on temachtijquej ican tlanahuatijli yejhuan ohualejquej ne ipan on hueyican de Jerusalén oquinisihuijquej Jesús, niman oquitlajtoltijquej: ");
INSERT INTO nguNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Tlica monomachtijcahuan xquitlacamatij incostumbre on achtojtajhuan? Monomachtijcahuan, tej, xnomajtequiaj ijcuac tlacuaj ijqui quen on achtojtatajtin tlamandarohuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pero Jesús oquimijlij: ―¿Man tlica nemejhuamej no xnenquitlacamatij on itlanahuatil Dios, san para nenquitlacamatij on nemocostumbres? ");
INSERT INTO nguNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios oquijtoj: “Xtlacaita motaj niman monan.” Niman no oquijtoj: “Yejhuan itlaj xcuajli quitenehuilis itaj noso inan, ma quimictican.” ");
INSERT INTO nguNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero nemejhuamej nenquijtohuaj ica se tlacatl huelis quijlis itaj noso inan yejhuan quipolohua itlaj: “Xhuelis nimitzpalehuis ica on tlen mitzpolohua pampa nochi tlen nicpia yonicmactilij Dios.” ");
INSERT INTO nguNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yejhua ica on, tej, tlen nenquijtohuaj quijtosnequi ica on tlacatl xoc quitocarohua quipalehuis itaj noso inan ica on tlen quipolohua. Ijcon, tej, nemejhuamej yonencuepquej quen xitlaj quijtosnequi on itlanahuatil Dios san para nenquitlacamatij on costumbres yejhuan otemachtijcaj on achtojtatajtin. ");
INSERT INTO nguNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Omexayacyejquej! Cuajli oquijtoj on tiotlajtojquetl Isaías nemotechcopa ijcuac oquijcuiloj quen Dios oquijtoj. Oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yejhuamej in tlacamej nechtlacaitaj ican on tlen quijtohuaj, pero xnechtlacaitaj ican inyojlo. ");
INSERT INTO nguNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","San nencaj nechmahuistiliaj, pampa yejhuamej quitemachtiaj on tlanahuatiltin yejhuan sa no yejhuamej on tlacamej oquitlalijquej quen itlanahuatilhuan yesquiaj Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Quemaj Jesús oquinnotz nochimej on tlacamej, niman oquimijlij: ―Xcaquican niman xcajsicamatican. ");
INSERT INTO nguNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","On tlen calaqui icamac se tlacatl xquijtlacohua, yej yejhua on tlen quisa icamac se tlacatl, yejhua quijtlacohua. ");
INSERT INTO nguNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ijcuacon on nomachtijquej oquinisihuijquej Jesús, niman oquijlijquej: ―¿Ticmati ica on fariseos ocualanquej ijcuac ocacquej on tlen otiquijtoj? ");
INSERT INTO nguNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero yejhua oquimijlij: ―San tlen xojtli noso cojtli yejhuan noTajtzin ilhuicac chanej xoquitocac, hasta ipan inelhuayo nohuihuitlas. ");
INSERT INTO nguNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ma ca, tej, xquimpajsolocan. Yejhuamej quen on ciegos quinyecanaj ocsequimej ciegos. Tla se ciego quiyecanas ocse ciego, nochimej on omemej onxinisquej ne campa huejcatlan. ");
INSERT INTO nguNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ijcuacon Pedro oquijlij Jesús: ―Cuajli xtechmelajcaijli yejhua in ejemplo. ");
INSERT INTO nguNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús oquijtoj: ―¿Nemejhuamej no oc xnencajsicamatij? ");
INSERT INTO nguNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Xnencajsicamatij ica nochi tlen calaqui ipan icamac se tlacatl yau ipan ijti niman quemaj quisa ipan on itlalnacayo? ");
INSERT INTO nguNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero on tlen quijtohua se tlacatl hualehua ipan iyojlo, niman in quijtlacohua on tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yejhua in melahuac, pampa ipan iyojlo quisa on xcuajcualtin tlamachilistli, on temictilistli, on sihuapajpatlalistli, on ahuilnemilistli, on tlachtequilistli, on tetlajtolcatztehualistli, niman on tlahuijhuicaltilistli. ");
INSERT INTO nguNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yejhua in tlajtlamach quijtlacohua se tlacatl. Pero tla se tlacatl xnomajtequiya ijcuac tlacua, quen on tlayecanquej ipan on tiopan temachtiaj, on xteijtlacohua. ");
INSERT INTO nguNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús onejcuanij niman oyaj ne ipan on región campa nisiu intech on omemej huejhueyican intoca Tiro niman Sidón. ");
INSERT INTO nguNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Niman se sihuatl cananea yejhuan chantiya ipan on región ohuajtzajtzitiaj itech Jesús: ―¡NoTeco, huejca teixhuiu itech David, xnechicneli niman xnechpalehui! Nochpoch quipia se xcuajli espíritu niman sanoyej temojtij quitlajyohuiltia. ");
INSERT INTO nguNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús xoquichihuilij cuenta. Quemaj on inomachtijcahuan oquinisihuijquej Jesús niman sanoyej oquitlajtlanilijquej: ―Xnahuati ma huiya pampa huajtzajtzitiu tocuitlapan. ");
INSERT INTO nguNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ijcuacon Jesús oquijtoj: ―NoTaj san onechajtitlan intech on hebreos yejhuan ixpolijtinemij. ");
INSERT INTO nguNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero on sihuatl oquinisihuij niman ixpan onotlacuenquetz, niman oquijlij: ―¡NoTeco, xnechpalehui! ");
INSERT INTO nguNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pero Jesús oquijlij: ―Tejhua xtihebrea. Tla nimitzpalehuis, yejhua in sa no ijqui quen nicualtisquia se chichi intlacual on iconehuan Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero yejhua oquijlij: ―On melahuac, noTeco, pero hasta on chichimej quicuaj on tlacuajli tejteinqui yejhuan xixini ipan tlajli yejhuan onehua ne ipan inmesa on inteco. ");
INSERT INTO nguNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ijcuacon Jesús oquijlij: ―¡Oh sihuatl, sanoyej hueyi motlaneltoc ticpia! Ma nochihua quen tejhua ticnequi. Ijcuacon nimantzin opajtic on ichpoch. ");
INSERT INTO nguNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús onejcuanij niman opanoc ne itenco on mar itoca Galilea. Quemaj otlejcoc ipan se tepetl niman ompa onotlalij. ");
INSERT INTO nguNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Miyec tlacamej oajsiquej ne campa yejhua nemiya, niman quinhuajhuicayaj coxomej, ciegos, nontzitzintin, on yejhuan xquipiayaj se imicxi noso inma niman miyequej ocsequimej cocoxquej. Oquintlalijquej icxitlan Jesús, niman yejhua oquimpajtij. ");
INSERT INTO nguNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ijcuac on tlacamej oquitaquej ica on nontzitzintin tlajtohuaj, on yejhuan quimpolohuaya imicxi noso inma quinmacaya, on coxomej cuajli nejnemiyaj niman on ciegos hueliyaj tlachaj, sanoyej opacatlachixquej. Niman opejquej cueyiliaj inDios on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Quemaj Jesús oquinnotz on inomachtijcahuan niman oquimijlij: ―Nejhua niquimicnelia in tlacamej, pampa ye quipia yeyi tonajli ica nican nohuan nemij niman xquipiaj tlinon quicuasquej. Xnicnequi niquintitlanis inchajchan tla xtlacuaj, pampa huelis sotlahuisquej ne ipan ojtli. ");
INSERT INTO nguNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ijcuacon on inomachtijcahuan oquijlijquej: ―Pero ¿quen ijqui huelis ticnextisquej quech tlacuajli nican campa tlapatlaco yejhuan quimajxilis in miyec tlacatl? ");
INSERT INTO nguNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús oquintlajtoltij: ―¿Quesqui pan nenquipiaj? Niman yejhuamej oquijlijquej: ―Chicome niman quesqui michintzitzintin. ");
INSERT INTO nguNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Quemaj Jesús otlanahuatij para on tlacamej ma notlajtlalican ipan tlajli. ");
INSERT INTO nguNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Quemaj yejhua ocontilan on chicome pan niman on michintzitzintin, niman oquimacac tlaxtlahuijli Dios. Quemaj oquitlatlapan niman oquinmacac on inomachtijcahuan, niman on inomachtijcahuan oquinxexelohuilijquej on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nochimej otlacuajquej, niman cuajli oixhuiquej. Quemaj inomachtijcahuan oquitemiltijquej chicome chiquiutin ica on tlatlajcotzitzin tlen onocau. ");
INSERT INTO nguNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","On yejhuan otlacuajquej canaj nahui mil tlacamej, pero xtehuamej tlapohualti on sihuamej nion on coconej yejhuan no otlacuajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Quemaj Jesús ononajnahuatij inhuan on tlacamej. Quemaj yejhua otlejcoc ipan barco niman oyaj ne ipan on región yejhuan oncaj itech on hueyican itoca Magdala. ");
INSERT INTO nguNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","On fariseos niman on saduceos oquitatoj Jesús, pampa quinequiyaj quitlatlatasquej. Yejhuamej oquijlijquej ma quichihua ne imixpan itlaj milagro yejhuan ne ilhuicac quisticaj para quitasquej ica Dios ocuajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero Jesús oquimijlij: ―Ijcuac on tonajli calaqui, nemejhuamej nenquijtohuaj: “Aman xquiahuis, pampa ne itech on cielo tlachichilejtoc.” ");
INSERT INTO nguNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Niman ijcuac quisa tonajli nenquijtohuaj: “Aman quiahuis, pampa ne itech on cielo tlachichilejtoc niman tlamoxtentoc.” ¡Omexayacyejquej! Nemejhuamej hueli nenquimatij tlinon quijtosnequi on tlen nochihua ne itech cielo, pero xhueli nenquimatij tlinon quijtosnequi on tlajtlamach yejhuan nochihua nemotzajlan ipan in tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","In tlacamej yejhuan aman nemij xcuajcualtin niman yoquitlalcahuijquej Dios. Yejhuamej nechijliaj ma nicchihua se milagro para niquintitis ica Dios onechajtitlan. Pero xniquintitis ocse más milagro, yej san yejhua on tlen oquichiu on tiotlajtojquetl Jonás. Quemaj oquincau, niman oyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ijcuac Jesús niman on inomachtijcahuan opanotoj ipan ocse ilado on mar, on inomachtijcahuan oquelnamiquej ica xquitquij pan. ");
INSERT INTO nguNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ijcuacon Jesús oquimijlij: ―Cuajli xcaquican yejhua in. Xmotacan sa no nemejhuamej itech intlaxocolilis on fariseos niman on saduceos. ");
INSERT INTO nguNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Quemaj on nomachtijquej opeu ijquin quinochtacaijliaj: ―On quijtohua pampa xoticuajquiquej pan. ");
INSERT INTO nguNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús oquimat on tlinon quinojlayaj, niman oquimijlij: ―¿Tlica nenquijtohuaj ica xnenquipiaj pan? ¡Nemejhuamej semi achijtzin nenquipiaj tlaneltoctli! ");
INSERT INTO nguNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Oc xnencajsicamatij nion nenquelnamiquij on macuijli pan ica onicxeloj intech on macuijli mil tlacamej, niman ica más saquin quesqui chiquiutin onenquisentlalijquej tlen onocau? ");
INSERT INTO nguNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nion nenquelnamiquij on chicome pan onicxeloj intech nahui mil tlacamej, niman ica más saquin quesqui chiquiutin onenquisentlalijquej tlen onocau? ");
INSERT INTO nguNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Tlica, tej, xonencajsicamatquej ica xejhua on pan nictenejticatca ijcuac onemechijlij ica xmotacan sa no nemejhuamej itech intlaxocolilis on fariseos niman saduceos? ");
INSERT INTO nguNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ijcuacon ocajsicamatquej ica Jesús xoquimijlij para ma notacan sa no yejhuamej itech on tlaxocolilistlii de pan, yej oquimijlij para ma notacan itech on intemachtil on fariseos niman on saduceos. ");
INSERT INTO nguNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ijcuac Jesús oajsic ne ipan iregión on hueyican itoca Cesarea de Filipo, oquintlajtoltij on inomachtijcahuan: ―Nejhua oninochiu Tlacatl, pero on tlacamej, ¿quen quijtohuaj aquin nejhua? ");
INSERT INTO nguNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yejhuamej oquijlijquej: ―Sequimej quijtohuaj ica tejhua tiJuan on tlacuatequijquetl, ocsequimej quijtohuaj ica tejhua tiElías, niman más ocsequimej quijtohuaj ica tejhua tiJeremías noso yacaj ocse tiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Quemaj Jesús oquimijlij: ―Niman nemejhuamej, ¿quen nenquijtohuaj aquin nejhua? ");
INSERT INTO nguNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ijcuacon Simón Pedro oquijlij: ―Tejhua tiCristo yejhuan Dios oquitlapejpenij para tlamandaros. Tejhua tiiConetzin Dios yejhuan melahuac nemi. ");
INSERT INTO nguNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús oquijlij: ―Dios yomitztiochiu tejhua Simón, yejhuan iconeu Jonás, pampa xacaj tlacatl mitzijlia ica nejhua niCristo yejhuan Dios onechtlapejpenij para tlamandaros. Yej noTajtzin ilhuicac chanej yejhua mitzmachiltia. ");
INSERT INTO nguNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Niman nejhua nimitzijlia ica tejhua tiPedro yejhuan quijtosnequi “tetl”, pampa tejhua oticpantlantij on tlen melahuac. Niman nochimej on yejhuan nechneltocasquej, quiselisquej in tlen melahuac. Niman ipoder on miquilistli xqueman huelis quintlanis. ");
INSERT INTO nguNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Niman nimitzmacas illaves on campa Dios tlamandarohua. On tlen tejhua xtictecahuilis ma nochihua nican ipan in tlalticpactli, Dios ne ilhuicac no ijqui quijtos ica on tlacamej xquintocarohua nohuicasquej ijcon. Niman on tlen tejhua tictecahuilis nochihua nican ipan in tlalticpactli Dios ne ilhuicac no ijqui quijtos ica on tlacamej huelisquej nohuicasquej ijcon. ");
INSERT INTO nguNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Quemaj Jesús oquinnahuatij on inomachtijcahuan ma ca yacaj quijlisquej ica yejhua Cristo yejhuan Dios oquitlapejpenij para tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jesús ijcuacon opeu quintlajtlajtohuilia on inomachtijcahuan ica yejhua ica oncaj yas ne Jerusalén, niman ica ompa on tlajtlamatquej, niman on tlayecanquej tiopixquej niman on temachtijquej ican tlanahuatijli quitlajyohuiltisquej ican miyec tlajtlamach. Niman oquimijlij ica yejhua quimictisquej, pero ipan yeyi tonajli yolihuis niman noquetztehuas ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ijcuacon Pedro oquixeloj ocsecan niman ijquin opeu cajhua: ―NoTeco, ¡Ma ca Dios quinequi ijcon nochihuas! ¡Tejhua xmitztocarohua para ijcon mopan nochihuas! ");
INSERT INTO nguNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Jesús onomalacachoj niman oquijlij Pedro: ―¡Xnechtlalcahui nican Satanás! Tejhua tinechteltia para xnicchihuas on tlen Dios quinequi. Tejhua xticnemilia quen Dios, yej ticnemilia quen on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Quemaj Jesús oquimijlij on inomachtijcahuan: ―Tla yacaj quinequi nohuan yas, ma quelcahua on tlen quinequi, ma nemi listo para tlajyohuis noso miquis nopampa, niman ma nohuan huiya. ");
INSERT INTO nguNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yejhua in nemechijlia pampa yejhuan quinequis quimaquixtis inemilis ipan in tlalticpactli, quipolos ialma, pero yejhuan san nopampa quipolos inemilis ipan in tlalticpactli, yejhua quiselis nemilistli para ialma. ");
INSERT INTO nguNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tej, ¿tlinon ica quipalehuis se tlacatl, tla yejhua quinoyaxcatis nochi tlen oncaj ipan in tlalticpactli niman quipolos ialma? Xitlaj, tej, ica quipalehuis, pampa xitlaj oncaj yejhuan se tlacatl huelis ica quitlaxtlahuas ialma. ");
INSERT INTO nguNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nejhua yejhuan oninochiu Tlacatl nihuajlas ihuan noilhuicactequitcahuan, niman nihuajlas ican ihueyilis noTajtzin. Niman ijcuacon cada se nictlaxtlahuilis quech quitocarohua on tlen oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ica tlen melahuac nemechijlia ica sequimej yejhuan aman nican nemij, ijcuac xe mimiquij, nechitasquej nejhua yejhuan oninochiu Tlacatl pehuas nitlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chicuasen tonajli más saquin, Jesús ocuicac Pedro, niman on icniutin Jacobo niman Juan, niman inseltimej oyajquej ipan se tepetl sanoyej hueyi ");
INSERT INTO nguNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","campa imixpan onixpatlac. Ixayac onocau petlanqui quen on tonaltzintli, niman on itlaquen sanoyej cualtzin opetlancaistayac. ");
INSERT INTO nguNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Niman nimatzin ohuajnonextijquej Moisés niman Elías otlajtlajtojquej ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ijcuacon Pedro oquijlij Jesús: ―NoTeco, ¡sanoyej cuajli ica nican tinemij! Tla ticnequi, ma ticchijchihuacan yeyi caltzitzintin, se para tejhua, ocse para Moisés niman ocse para Elías. ");
INSERT INTO nguNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chica Pedro ijcon tlajtohuaya, se moxtli yejhuan sanoyej istac oquintlapachoj. Niman quemaj ipan on moxtli ocaquistic se tlajtojli yejhuan oquijtoj: ―In yejhua notlajsojcaConeu yejhuan itech nipacticaj. Yejhua xtencaquican. ");
INSERT INTO nguNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ijcuac on nomachtijquej ijcon ocacquej, nimantzin onotlacuenquetzquej ican inxayac hasta ipan tlajli, niman sanoyej onomojtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ijcuacon Jesús oquinnisihuij. Oquinminmatocac niman oquimijlij: ―Xmotelquetzacan, ma ca xmomojtican. ");
INSERT INTO nguNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Niman ijcuac onotelquetzquej, xoc yacaj más oquitaquej, yej san Jesús iselti. ");
INSERT INTO nguNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chica huajtemotiayaj ne ipan on tepetl, Jesús oquinnahuatij: ―Ma ca yacaj xtlajtlajtohuilican on tlen onenquitaquej, hasta ijcuac nejhua yejhuan oninochiu Tlacatl niyolihuis niman ninoquetztehuas ipan notlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ijcuacon on nomachtijquej oquitlajtoltijquej Jesús: ―¿Tlica, tej, on temachtijquej ican itlanahuatil Dios quijtohuaj ica Elías ica oncaj achtoj huajlas xquen tejhua yejhuan Dios omitztlapejpenij para techmandaros? ");
INSERT INTO nguNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús oquimijlij: ―On melahuac ica Elías achtoj huajlas niman nochi tlajtlamach quiyectlalis. ");
INSERT INTO nguNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero nejhua nemechijlia ica Elías yohuajlaj, niman xoquixmatquej, yej oquichihuilijquej nochi tlen xcuajli yejhuamej oquinequej. No ijqui nejhua yejhuan oninochiu Tlacatl nechtlajyohuiltisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ijcuacon on nomachtijquej ocajsicamatquej ica ijcuac Jesús quinnojnotzticatca ica Elías, yejhua quitenejticatca Juan on tlacuatequijquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ijcuac oajsiquej ne itzintlan on tepetl campa nemiyaj on tojlamej tlacamej, se tlacatl oquinisihuij Jesús niman ixpan onotlacuenquetz, niman oquijlij: ");
INSERT INTO nguNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―NoTeco xpalehui notelpoch ican teicnelilistli. Yejhua san sojsotlajtinemi niman sanoyej temojtij tlajyohuiya. Miyecpa onhuetzi ipan tlitl niman miyecpa ipan atl. ");
INSERT INTO nguNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nejhua onicuajhuicac itech momachtijcahuan, pero yejhuamej xohuelquej oquipajtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús oquijtoj: ―¡Oh tlacamej yejhuan xtlaneltocaj niman xmelajqui tlanemiliaj! ¿Hasta quemanon más nemohuan ninemis? ¿Hasta quemanon nemechxicos? Nican xcuajhuicacan on telpochtli. ");
INSERT INTO nguNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Quemaj Jesús ocajhuac on xcuajli espíritu niman oquis ipan on telpochtli. Quemaj nimantzin on telpochtli opajtic. ");
INSERT INTO nguNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Más saquin on nomachtijquej oquinotzquej Jesús san iselti, niman oquitlajtoltijquej: ―¿Tlica tejhuamej xotihuelquej otiquixtijquej on xcuajli espíritu? ");
INSERT INTO nguNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús oquimijlij: ―Xonenhuelquej pampa onenometlamatquej tla huelisquia pajtis noso ca. Ica tlen melahuac nemechijlia ica tla nenquipiaj nemotlaneltoc masqui ichtetzin on quen on iteyo on mostaza huelis nenquijlisquej on tepetl: “Xmejcuanij nican niman xhuiya ne ocsecan”, niman on tepetl nejcuanis. Ijcon, tej, nochi huelis nenquichihuasquej tla melahuac nenquipiaj nemotlaneltoc. ");
INSERT INTO nguNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero in quen in xcuajli espíritu huelis nenquitequixtilisquej san ican oración niman nesahuajli. ");
INSERT INTO nguNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Chica san secan quistinemiyaj neca ipan on iregión Galilea, Jesús oquimijlij: ―Nejhua yejhuan oninochiu Tlacatl nechtemactilisquej intech on tlacamej, ");
INSERT INTO nguNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","niman nechmictisquej, pero ipan yeyi tonajli niyolihuis niman ninoquetztehuas ne ipan notlalcon. Niman ijcuac yejhuamej ijcon ocacquej, sanoyej onajmanquej. ");
INSERT INTO nguNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ijcuac Jesús niman inomachtijcahuan oajsiquej ipan on pueblo itoca Capernaum, on yejhuan tlacobrarohuayaj para ne tiopan, oyajquej itech Pedro niman ijquin oquitlajtoltijquej: ―¿On nemotemachtijcau xquitlaxtlahuas on tomin para on hueyi tiopan? ");
INSERT INTO nguNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro oquijlij: ―Quemaj. Quemaj ijcuac Pedro ocalaquito ne ipan on cajli, Jesús achtoj yejhua oquinotz, niman oquijlij: ―¿Quen ticnemilia Simón? In reyes ipan in tlalticpactli, ¿aquinomej quincobrarohuaj yejhua ica on impuestos? ¿Quincobrarohuaj yejhuamej on chanejquej noso on yejhuan xchanejquej? ");
INSERT INTO nguNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro oquijlij: ―On yejhuan xchanejquej. Quemaj Jesús oquijlij: ―Tla ijcon, on chanejquej xquintocarohua para quitlaxtlahuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero para ma ca yacaj ticualanisquej, xhuiya ne ipan mar para xcajsi se michin. Niman on yejhuan achtoj michin ticajsis, xquixti. Niman ipan icamac ticnextis se tomin yejhuan cajxilis para tictlaxtlahuas on quech techtlajtlaniaj nejhua niman tejhua ne ipan tiopan. Xquitqui, tej, on tomin niman xquintlaxtlahuiliti. ");
INSERT INTO nguNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ipan on tonaltin on nomachtijquej oquinisihuijquej Jesús niman oquitlajtoltijquej: ―¿Aquinon más hueyixticaj ne campa tlamandarohua on ilhuicac chanej? ");
INSERT INTO nguNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ijcuacon Jesús oquinotz se conetl, niman oquitlalij ne imixpan. ");
INSERT INTO nguNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Niman oquijtoj: ―Ica tlen melahuac nemechijlia, ica tla nemotlamachilis xnopatla niman xnocuepa quen intlamachilis on coconej, xnencalaquisquej ne campa tlamandarohua on ilhuicac chanej. ");
INSERT INTO nguNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ijcon, tej, on yejhuan más hueyixticaj campa tlamandarohua on ilhuicac chanej, on yejhuan xnohueyimati yej nohuica quen yejhua in conetl. ");
INSERT INTO nguNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","San aquinon yejhuan nopampa quiselis yacaj yejhuan yolyemanqui quen yejhua in conetl, nejhua nechselia. ");
INSERT INTO nguNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Pero san aquinon yejhuan quitlajcalis ipan tlajtlacojli semej yejhuamej in pipitiquej coconej yejhuan nechneltocaj, quiselis hueyi castigo. Más cuajli yesquia ijcuac xe quichihua on tlajtlacojli iquechtlan quipilohuilisquiaj se tetl hueyi yejhuan imetl on molino niman contlajcalisquiaj ne ipan on mar campa más huejcatlan. ");
INSERT INTO nguNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Lástima para in tlalticpactlacamej pampa sanoyej oncaj tlinon se ica huetzi ipan tlajtlacojli. Nochipa ijcon yes, pero sanoyej xcuajli yes para on tlacatl yejhuan itech pehua on tlajtlacojli. ");
INSERT INTO nguNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Yejhua ica, tej, tla moma noso mocxi mitzchihuilia titlajtlacohua, xtequi niman huejca xcontlajcali. Ijcon xchihua, pampa más cuajli tinemis timatejtepoltic noso tiicxitejtepoltic, ijcuac ticalaquis ne ilhuicac, xquen tla tajsitias niman yej mitzontlajcalisquej ne ipan on tlitl yejhuan para nochipa mitztlatis. ");
INSERT INTO nguNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Niman tla mixtololoj mitzchihuilia para titlajtlacohua, xquixti niman huejca xcontlajcali. Ijcon xchihua, pampa más cuajli para ticpias san se mixtololoj, ijcuac ticalaquis ne ilhuicac, xquen tla tajsitias niman yej mitzontlajcalisquej ne ipan on tlitl yejhuan oncaj ne mictlan. ");
INSERT INTO nguNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Xquintlacaitacan in pipitiquej coconej. Tej, nemechijlia ica ne ilhuicac on inilhuicactequitcahuan nochipa nemij ne ixpan on noTajtzin ilhuicac chanej. ");
INSERT INTO nguNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nejhua yejhuan oninochiu Tlacatl onihuajlaj para oniquinmaquixtico on yejhuan ixpolijtoquej. ");
INSERT INTO nguNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Quen nenquinemiliaj? ¿Tlinon quichihua se tlacatl yejhuan quipia se ciento iborreguitos ijcuac se quipolohua? Yejhua, tej, cajtehua on napoajli huan majtlactli huan chicanhui ne ipan tepetl niman yau contejtemohua on yejhuan oquipoloj. ");
INSERT INTO nguNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Niman tla yejhua quinextia, ica tlen melahuac nemechijlia ica yejhua más sanoyej paqui ihuan on se borreguito yejhuan oquipolojca xquen inhuan on napoajli huan majtlactli huan chicnahui yejhuan xoquimpoloj. ");
INSERT INTO nguNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","On nemoTajtzin ilhuicac chanej no xquinequi para semej yejhuamej in pipitiquej ma polihuican. ");
INSERT INTO nguNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Niman tla mocniu mitzchihuilia itlaj tlen xcuajli, xnotza san iselti niman xquijli on tlinon xcuajli omitzchihuilij. Tla quiselia on itlajtlacol niman noyoltlalia, yejhua ocsejpa cuajli mohuan nocahuas. ");
INSERT INTO nguNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero tla yejhua xmitztencaqui, tla ijcon, xcuica se noso ome tlacatl más para nochi tlen nijtos ma quimati ome noso yeyi teixpantiliquej. ");
INSERT INTO nguNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tla yejhua no xquintencaqui, tla ijcon, san secan xquinotza on tlaneltocaquej ipan itiopan Dios para no ma quitlacanonotzacan. Niman tla yejhua xquintencaqui, tla ijcon xpiacan, quen se yejhuan xquineltoca Dios noso quen se tlaixpachohuani tlacobrarojquetl ican on rentas. ");
INSERT INTO nguNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ica tlen melahuac nemechijlia, ica on tlen nemejhuamej xnenquitecahuilisquej ma nochihua nican ipan in tlalticpactli, Dios ne ilhuicac no ijqui quijtos ica on tlacamej xquintocarohua nohuicasquej ijcon. Niman no on tlen nemejhuamej nenquitecahuilisquej ma nochihua nican ipan in tlalticpactli Dios ne ilhuicac no ijqui quijtos ica tlacamej huelisquej nohuicasquej ijcon. ");
INSERT INTO nguNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’No ijqui nemechijlia ica tla nenomemej nican ipan in tlalticpactli nemotlajtolmacasquej ican nochi nemoyojlo para itlaj nenquitlajtlanisquej noTajtzin ilhuicac chanej, yejhua mechmacas. ");
INSERT INTO nguNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yejhua ijcon quichihuas pampa campa omemej noso yeyimej nopampa nosentlaliaj, nejhua ompa ninemi inhuan. ");
INSERT INTO nguNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Quemaj Pedro oquinisihuij Jesús niman oquijlij: ―NoTeco, ¿quesquipa nictlapojpolhuis yacaj nocniu tla yejhua nechchihuilia on tlen xcuajli? ¿Hasta chicomepa nictlapojpolhuis? ");
INSERT INTO nguNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús oquijlij: ―Nejhua xnimitzijlia tla hasta chicompa tictlapojpolhuis, yej nimitzijlia hasta yepoajli huan majtlactli ica chicomepa. ");
INSERT INTO nguNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Yejhua ica sanoyej nonequi titetlapojpolhuis pampa ne campa tlamandarohua on ilhuicac chanej sa no ijqui quen se rey yejhuan oquinec quixtis cuentas inhuan on itequipanojcahuan. ");
INSERT INTO nguNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yejhua on rey ye pejticatca quixtiaya cuentas ijcuac ocuiquilijquej se itequipanojcau yejhuan cuiquiliaya miyec millones de pesos. ");
INSERT INTO nguNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero on itequipanojcau xquipiaya tlinon ica quitlaxtlahuas icuenta. Yejhua ica on rey otlanahuatij para ma quinamacacan quen tlanamactli san secan ihuan isihuau, iconehuan niman no ma quinamacacan nochi tlen quipia, san para notlaxtlahuas on icuenta. ");
INSERT INTO nguNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ijcuacon on itequipanojcau onotlacuenquetz ixpan on iteco niman oquicnotlajtlanilij: “Señor, xnechijyohuili, niman nochi nimitztlaxtlahuilis tlen nimitzhuiquilia.” ");
INSERT INTO nguNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iteco oquicnelij, niman oquipopolohuilij on icuenta niman oquimacau. ");
INSERT INTO nguNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Pero ijcuac on mismo tlacatl ohuajquis ne itech iteco, oquinamic se itetequipanojcaxiu yejhuan cuiquiliaya quesqui pesos tomin. Yejhua ica nimantzin ocajsic iquechtlan, opeu cocojpatzca, niman ijquin quijliaya: “¡Xnechtlaxtlahuili tlen tinechhuiquilia!” ");
INSERT INTO nguNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Quemaj on itetequipanojcaxiu ixpan onotlacuenquetz niman ijquin oquicnotlajtlanilij: “Xnechijyohuili, niman nochi nimitztlaxtlahuilis tlen nimitzhuiquilia.” ");
INSERT INTO nguNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero yejhua xoquinec, yej ocuicac campa tzacutias hasta quitlaxtlahuilis nochi tlen cuiquilia. ");
INSERT INTO nguNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ijcuac on ocsequimej tetequipanojquej ijcon oquitaquej, sanoyej oquinyolcocoj, niman oyajquej oquitlajtlajtohuilitoj inteco nochi tlen oquitaquej onochiu. ");
INSERT INTO nguNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Quemaj on inteco oquitecuitlan on itequipanojcau, niman oquijlij: “¡Xcuajli tequipanojquetl! Nejhua onimitzpojpolohuilij nochi quech tinechhuiquiliaya, pampa tejhua ijqui otinechicnotlajtlanilij. ");
INSERT INTO nguNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ijcon quen nejhua onimitzicnelij, tejhua no ijqui nonequi tiquicnelis on motetequipanojcaxiu.” ");
INSERT INTO nguNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Niman on teteco sanoyej ocualan. Yejhua ica oquinnahuatij on cárcejtlapixquej ma castigarocan hasta queman quitlaxtlahuas nochi tlen cuiquiliaya. ");
INSERT INTO nguNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Niman otlan tlajtlajtohua Jesús ica in tlajtojli: ―No ijqui mechchihuilis on noTajtzin ilhuicac chanej, tla cada nensesentemej xnenquitlapojpolhuiaj nemocniu ican nochi nemoyojlo. ");
INSERT INTO nguNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ijcuac Jesús yotlan quiteijlia in tlajtlamach, oquis ne Galilea, niman oyaj ne ipan on yehualican itoca Judea yejhuan onocau ne campa iquisayan tonaltzintli de on atentli Jordán. ");
INSERT INTO nguNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Miyec tlacatl oyaj ihuan, niman ompa oquimpajtij on cocoxquej. ");
INSERT INTO nguNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niman sequimej fariseos oquinisihuijquej Jesús para quitlatlatasquej, niman ijquin oquitlajtoltijquej: ―¿On tlanahuatijli cahuilia se tlacatl noxotonis ihuan isihuau masqui san itlaj icatzin? ");
INSERT INTO nguNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yejhua oquimijlij: ―¿Nemejhuamej xqueman nenquimomachtiaj ipan on Yectlajcuilojli ica on yejhuan oquintlalij ijcuac quemach nochi otzimpeu, oquintlalij tlacatl niman sihuatl? ");
INSERT INTO nguNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","No oquijtoj: “Yejhua ica on tlacatl quitlalcahuis itaj niman inan para nosentlalis ihuan isihuau, niman ijcon on omemej nochihuasquej quen se tlacatl.” ");
INSERT INTO nguNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ijcon, tej, yejhuamej xoc omemej, yej yonochiu san se. Yejhua ica se tlacatl xhuelis quixelos on tlen Dios oquisentlalij. ");
INSERT INTO nguNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ijcuacon on fariseos ijquin oquitlajtoltijquej: ―¿Tla ijcon, tej, tlica Moisés otlanahuatij para se tlacatl quimacas se amatlajcuilojli on isihuau campa quijtos ica ihuan noxotonia, niman quemaj ma cahua? ");
INSERT INTO nguNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús oquimijlij: ―Moisés omechcahuilij nemoxotonisquej pampa nenyoltechicajquej niman xonenquinequej onenquitlacamatquej Dios. Pero ijcuac nochi otzimpeu, Dios xoquintlalij on tlacamej para ijcon quichihuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nejhua nemechijlia ica san aquinon yejhuan noxotonis ihuan isihuau, pero xpampa on sihuatl itlaj quichtacachijtinemi ihuan se tlacatl, niman nonamictis ihuan ocse sihuatl, yejhua sihuapajpatla. Niman on yejhuan nonamictis ihuan on sihuatl yejhuan yocajquej, no sihuapajpatla. ");
INSERT INTO nguNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Quemaj inomachtijcahuan oquijlijquej: ―Tla se tlacatl xquipia permiso para nocahuas ihuan isihuau, más cuajli para xqueman yacaj nonamictis. ");
INSERT INTO nguNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús oquimijlij: ―Xnochimej tlacamej huelisquej quijyohuisquej inseltimej nemisquej, yej san on yejhuan Dios quinequi para ijqui nemisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oncaj sesetlamantic tlajtlamach yejhuan xquitecahuilia ma nonamictihua. Sequimej xhueli nonamictiaj pampa xcuajli tlacatij. Ocsequimej xhueli nonamictiaj pampa on mismos tlacamej quinquixtiliaj on tlen quinchihualtia ma nonamictican. Niman ocsequimej xquinequij nonamictisquej pampa quinequij más huelisquej quichihuasquej on tequitl yejhuan para Dios. On yejhuan noyolchicahuas para nemis iselti, ma quichihua. ");
INSERT INTO nguNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Quemaj oquinhuajhuicaquej sequimej coconej ne itech Jesús para yejhua impan ma quintlali imahuan, niman para impampa quichihuas oración. Pero on nomachtijquej opejquej quimajhuaj on yejhuan quinhuajhuicayaj on coconej. ");
INSERT INTO nguNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesús oquijtoj: ―Xquincahuilican on coconej ma huajhuiyan notech, niman ma ca xquinteltican, pampa on tlacamej yejhuan nemij quen coconej calaquisquej ne campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yejhua oquintlalij imahuan impan on coconej, niman quemaj ompa onejcuenij. ");
INSERT INTO nguNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sen tlacatl oyaj itech Jesús niman oquitlajtoltij: ―Cuajli temachtijquetl, ¿tlinon cuajli nicchihuas para nicselis on nemilistli yejhuan para nochipa? ");
INSERT INTO nguNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús oquijlij: ―¿Tlica tinechcuitia nicuajli? On yejhuan cuajli san Dios iselti, niman tejhua ticnemilia ica nejhua san nitlacatl niman xniDios. Pero xcaqui tlen nimitzijlis. Tla ticnequi tonchantis ne ilhuicac, xquintlacamati on tlanahuatiltin. ");
INSERT INTO nguNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Niman on tlacatl oquijlij: ―¿Catlejhuamej on tlanahuatiltin? Niman Jesús oquijlij: ―Ma ca titemictis; ma ca tisihuapajpatlas; ma ca titlachtequis; ma ca yacaj tictlajtolquetztehuilis; ");
INSERT INTO nguNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","xtlacaita motaj niman monan, niman xquintlajsojtla ocsequimej quen tejhua timotlajsojtla. ");
INSERT INTO nguNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Quemaj on tlacatl oquijtoj: ―Nochi yejhua in desde niconetl nicuajtlacamatztiu. ¿Tlinon más nechpolohua? ");
INSERT INTO nguNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús oquijlij: ―Tla ticnequi nochi ica ticuajli tlacatl yes, xhuiya mochan, niman xnamaca on tlen ticpia niman on tomin xquinmaca on mayanquej. Tla ijcon ticchihuas, ticpias riquezas ne ilhuicac. Niman quemaj xhuajla niman xhuiya nohuan. ");
INSERT INTO nguNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero ijcuac on tlacatl ijcon ocac, oyaj onajmantiaj, pampa sanoyej rico catca. ");
INSERT INTO nguNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ijcuacon Jesús oquimijlij on inomachtijcahuan: ―Ica tlen melahuac nemechijlia ica sanoyej ohuijticaj, para Dios yejhuan ilhuicac chanej quimandaros se tlacatl yejhuan rico. ");
INSERT INTO nguNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ocsejpa nemechijlia ica más ohuijticaj para se rico calaquis ne campa Dios tlamandarohua xquen para se camello panos ipan on campa tlacoyoniaj ican aguja. ");
INSERT INTO nguNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ijcuac on inomachtijcahuan ijcon ocaquej, sanoyej omojcatlachixquej, niman ijquin oquijtojquej: ―Tla ijcon, tej, ¿aquinon huelis maquisas? ");
INSERT INTO nguNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús oconmintac, niman oquimijlij: ―On tlacamej xhuelij nomaquixtiaj, pero Dios nochi hueli quichihua. ");
INSERT INTO nguNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Quemaj Pedro oquijlij: ―NoTeco, tejhuamej yoticajquej nochi tlen ticpiayaj, niman tiquistinemij mohuan. ¿Tlinon, tej, ticpiasquej? ");
INSERT INTO nguNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús ijquin oquimijlij: ―Ica tlen melahuac nemechijlia ica ipan on tonajli ijcuac nochi yencuiyas, nejhua yejhuan oninochiu Tlacatl ninotlalis ipan on silla campa nihueyixtias para nitlamandaros. Ipan on tonaltin nemejhuamej yejhuan nennechtocaj no nemotlalisquej ipan majtlactli huan ome sillas. Ompa nenquipiasquej tlanahuatijli para nenquintlajtlacolmacasquej on xcuajcualtin, niman nenquinyectenehuasquej on yejhuan cuajcualtin tlacamej nemij ipan on majtlactli huan ome ifamilias de Israel. ");
INSERT INTO nguNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Niman nochimej yejhuan cahuaj inchan noso imicnihuan, noso intaj, noso innan, noso insihuau, noso inconehuan, noso intlalhuan san nopampa, quiselisquej se ciento más, niman no quiselisquej nemilistli para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero miyequej yejhuan saniman calaquij campa Dios tlamandarohua, xhuejhueyixtiasquej, niman miyequej yejhuan más saquin calaquij campa Dios tlamandarohua huejhueyixtiasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Yejhua ica, ne campa tlamandarohua on yejhuan ilhuicac chanej, no ijcon nochihua quen on tlalejquetl yejhuan quipia uvas ipan se hueyi tlajli. Yejhua in tlacatl, ijcuac cualcan oquis, oquintejtemoto tlaquehualtin para quitequilisquej on uvas. ");
INSERT INTO nguNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ijcuac oquinnextij quesquimej tlaquehualtin, inhuan onocau para se tonajli quintlaxtlahuilis ican se tomin itoca denario. Quemaj oquintitlan ne ipan itlal para ma tequititij. ");
INSERT INTO nguNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sa no ipan on tonajli canaj ipan chicnahui hora ica cualcan, ocsejpa oquis, niman ne ipan plaza oquintac ocsequimej tlacamej yejhuan xtequitij. ");
INSERT INTO nguNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yejhua oquimijlij: “Nemejhuamej no xhuiyan, xtequititij ne ipan notlal, niman nemechtlaxtlahuilis quen quitocarohua.” Niman yejhuamej oyajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","On tlalejquetl ijcuac tlacualispan oquis, niman canaj ipan yeyi hora ocsejpa oquis, niman sa no ijqui oquinnotz ocsequimej tlaquehualtin. ");
INSERT INTO nguNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Quemaj ipan macuijli hora ica tiotlac, ocsejpa oyaj ne plaza, niman ompa oquintac ocsequimej tlacamej yejhuan xitlaj quichihuayaj. Yejhua ica oquimijlij: “¿Tlica nican yonensetonalojquej niman xnentequitij?” ");
INSERT INTO nguNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yejhuamej oquijlijquej: “Pampa xacaj techtlaquehua.” Ijcuacon oquimijlij: “Nemejhuamej no xhuiyan, xtequititij ne ipan notlal, niman nemechtlaxtlahuilis quen quitocarohua.” ");
INSERT INTO nguNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Ijcuac otlapoyau, on tlalejquetl oquijlij on yejhuan quiyecanaya on tequitl: “Xquinquixti on tlaquehualtin, niman xquintlaxtlahuili inca xtlapehua on yejhuan sa otlatocatiajquej ica ocalaquej, niman inca tontlamis on yejhuan achtopa ocalaquej.” ");
INSERT INTO nguNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Niman ijcuac ohualajquej on yejhuan ocalaquej para tequitisquej canaj ipan macuijli hora ica tiotlac, cada se oquiselij itlaxtlahuil se denario. ");
INSERT INTO nguNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ijcuac no ohualajquej on yejhuan achtopa opeu tequitij, oquinemilijquej ica más hueyi quiselisquej intlaxtlahuil, pero cada se no san oquiselij se denario. ");
INSERT INTO nguNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yejhua ica, ijcuac oquiselijquej intlaxtlahuil, opeu cualanij itechcopa on tlalejquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Quijliayaj: “Yejhuamej in yejhuan sa otlatocatiajquej para tequitisquej san se hora otequitquej niman sa no ijqui otiquintlaxtlahuilij quen tejhuamej yejhuan nochi se tonajli otitequitquej campa tonayan.” ");
INSERT INTO nguNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pero on tlalejquetl oquinanquilij semej yejhuamej, niman oquijlij: “Notetlajsojcau, nejhua xnimitzixpachohuilia motomin. ¿Tlen xmohuan oninocau para nimitztlaxtlahuilis se denario? ");
INSERT INTO nguNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xquitqui motlaxtlahuil niman xhuiya. Nejhua onicnec para yejhua in yejhuan saquin ocalac para tequitis sa no ijqui ma quiseli itlaxtlahuil quen tejhua ticselia. ");
INSERT INTO nguNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Tlen xnechmelahua nicchihuas ican notomin tlen nejhua nicnequis? ¿Noso yej tinexicolmiqui pampa nejhua nitepalehuiya ican teicnelilistli?” ");
INSERT INTO nguNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yejhua ica, tej, miyequej yejhuan saniman calaquij campa Dios tlamandarohua xhuejhueyixtiasquej, niman miyequej yejhuan más saquin calaquij campa Dios tlamandarohua huejhueyixtiasquej. Dios miyequej oquinnotz, pero xmiyequej oquintlapejpenij. ");
INSERT INTO nguNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ijcuac Jesús ye yaya ne Jerusalén, se lado oquinhuicac on majtlactli huan ome inomachtijcahuan, niman ijquin oquimijlij: ");
INSERT INTO nguNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Xcaquican. Aman tiahuij ne Jerusalén campa nejhua yejhuan oninochiu Tlacatl nechtemactilisquej intech on tlayecanquej tiopixquej niman intech on temachtijquej ican itlanahuatil Dios. Yejhuamej nechtlajtlacolmacasquej para nechmictisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Quemaj nechtemactilisquej intech on xchanejquej para ma noca huetzcacan, ma nechhuihuitequican, niman ma nechmajmasohualtican ipan cojnepanojli, pero ipan yeyi tonajli niyolihuis niman ninoquetztehuas ne ipan notlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Quemaj, isihuau Zebedeo ihuan Jacobo niman Juan, on iconehuan, oquinisihuijquej Jesús. Niman isihuau Zebedeo ixpan onotlacuenquetz Jesús para oquitlajtlanilij se favor. ");
INSERT INTO nguNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús oquitlajtoltij: ―¿Tlinon ticnequi? Yejhua oquijlij: ―Xtlanahuati para ne campa titlamandaros yejhuamej in notlajsojcaconehuan se ma notlali moyecmacopa niman ocse ipan mopochmacopa. ");
INSERT INTO nguNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero Jesús oquimijlij: ―Nemejhuamej xnenquimatij tlinon nenquitlajtlanij. ¿Nenhuelisquej nenquijyohuisquej on tlen nejhua ye oncaj para niquijyohuis? Yejhuamej oquijtojquej: ―Huelis titlajyohuisquej quen tejhua. ");
INSERT INTO nguNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yejhua oquimijlij: ―On melahuac ica nentlajyohuisquej quen nejhua. Niman nemocuatequisquej quen nejhua pero yejhua on para nemotlalisquej noyecmacopa niman ipan nopochmacopa, nejhua xnechmelahua ompa nemechtlalis, yej ompa noTajtzin quintlalis on yejhuan yoquintlapejpenij. ");
INSERT INTO nguNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ijcuac on majtlactlimej nomachtijquej oquimatquej tlinon oquitlajtlanquej on omemej icniutin, sanoyej intechcopa ocualanquej. ");
INSERT INTO nguNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesús nochimej oquinnotz para ma huajhuiyan nisiu, niman oquimijlij: ―Nemejhuamej ye nenquimatztoquej ica nemij xhebreos yejhuan huejhueyixtoquej, niman yejhuamej quinmandarohuaj ocsequimej tlayecanquej, niman yejhua in tlayecanquej tlamandarohuaj ipan on países xican teicnelilistli. ");
INSERT INTO nguNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero para nemejhuamej xijqui yes. Yej aquin quinequis hueyixtias nemotzajlan, ica oncaj quimpalehuis on ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","San aquinon de nemejhuamej yejhuan quinequis tlayecantias, ica oncaj yejhua tepalehuis quen se tlanamactli. ");
INSERT INTO nguNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","No ijqui quen nejhua yejhuan oninochiu Tlacatl xonihuajlaj para nechpalehuisquej, yej para nitepalehuis, niman nictemacas nonemilis para niquinmaquixtis miyec tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ijcuac yejhuamej quistiayaj ne ipan on hueyican itoca Jericó, miyec tlacatl ocuitlapanhuij Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ne itech ojtli yejyehuaticatcaj omemej ciegos. Niman ijcuac ocacquej ica Jesús ompaca panotiaya, oquitzajtzilijquej: ―¡ToTeco huejca teixhuiu itech David, xtechicneli niman xtechpalehui! ");
INSERT INTO nguNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pero on tlacamej oquimajhuaquej on ciegos para ma ca sa ma nahuatican, pero yejhuamej yej más otzajtziquej: ―¡ToTeco, huejca teixhuiu itech David, xtechicneli niman xtechpalehui! ");
INSERT INTO nguNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Quemaj Jesús onoteltij, ocominnotz on ciegos, niman ijquin oquintlajtoltij: ―¿Tlinon nenquinequij ma nemechchihuili? ");
INSERT INTO nguNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yejhuamej oquijlijquej: ―ToTeco, san ticnequij ma tihuelican titlachacan. ");
INSERT INTO nguNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ijcuacon Jesús oquimicnelij, niman oquinmatoquilij imixtololojhuan. Quemaj nimantzin on ciegos ohuelquej otlachixquej. Quemaj oyajquej ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ijcuac ye nisiu nemiyaj ne Jerusalén campa oncatca on pueblo itoca Betfagé, ne ipan on tepetl itoca Olivos, Jesús oquintitlan omemej inomachtijcahuan, ");
INSERT INTO nguNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","niman oquimijlij: ―Xhuiyan ipan on pueblito yejhuan oncaj ne tlayecapan. Ne campa nemoncalactiasquej, nenquitasquej se sihuapoloco salijticaj ihuan se polocotzin. Xquintojtomacan niman xnechinhuajhuiquilican. ");
INSERT INTO nguNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Niman tla yacaj mechijlia: “¿Tlica nenquintojtomaj on polocomej?”, xquijlican ica on nemoTeco quinnequi niman ica nimantzin cuajtitlanis. ");
INSERT INTO nguNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yejhua in onochiu san para otenquis on tlen oquijtoj nochihuas on tiotlajtojquetl ijcuac ijquin oquijcuiloj: ");
INSERT INTO nguNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xquijlican on yejhuan chanti ipan on hueyican itoca Sión: “Xquitacan, moRey huajlau motech. Yejhua xhuajnohueyimatztiu, yej hualetiu ipan se poloco yejhuan pitentzin. On polocotzin teconeu itech on yolqui yejhuan tlamama.” ");
INSERT INTO nguNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yejhua ica on nomachtijquej oyajquej, niman oquichijquej quen Jesús oquinnahuatij. ");
INSERT INTO nguNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yejhuamej ocuajhuicaquej on sihuapoloco ihuan iconetzin. Quemaj impan oquintlalijquej intlaquen, niman Jesús otlejcoc ipan on polocotzin. ");
INSERT INTO nguNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Niman más miyequej on tlacamej yejhuan ompa yayaj oquisojquej intlaquen ipan ojtli, niman sequimej oquitejtequej inxojyo on cojtin niman oquitlalijquej neca ipan ojtli. ");
INSERT INTO nguNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","On tlacamej yejhuan tlayecapan yayaj, niman on yejhuan tlacuitlapan yayaj, opejquej tzajtzij: ―¡Ticyectenehuaj in huejca teixhuiu itech rey David! ¡Ma Dios quitiochihua on yejhuan ocuajtitlan! ¡Ma ne ilhuicac noyectenehua! ");
INSERT INTO nguNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ijcuac Jesús ocalac ne Jerusalén, nochi tlacatl ipan on hueyican onajcoman, niman miyequej otlajtlanquej: ―¿Aquinon in? ");
INSERT INTO nguNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Niman on yejhuan ihuan Jesús yayaj oquijtojquej: ―In yejhua tiotlajtojquetl Jesús, on yejhuan chanej Nazaret yejhuan oncaj ipan on región itoca Galilea. ");
INSERT INTO nguNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Quemaj Jesús ocalac ne iquiahuac on ihueyi tiopan Dios, niman oquinhuajquixtij on yejhuan ompa tlanamacaticatcaj niman tlacojticatcaj. Oquinxixinilij inmesas on yejhuan quitepatiliayaj tomin, niman insietas on yejhuan quinnamacayaj palomas. ");
INSERT INTO nguNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Niman oquimijlij: ―Ipan in Yectlajcuilojli, ijquin tlajcuilolnesticaj: “Nochan itoca yes tioyocajli campa quichihuaj oraciónes”, pero nemejhuamej yonencuepquej quen teostotl cajli campa on tlachtequij nosentlaliaj. ");
INSERT INTO nguNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chica Jesús nemiya ipan on hueyi tiopan, semej ciegos niman coxomej oquinisihuijquej, niman yejhua oquimpajtij. ");
INSERT INTO nguNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero intlayecancahuan on tiopixquej niman on temachtijquej ican tlanahuatijli ocualanquej ijcuac oquitaquej on sanoyej cuajli tlajtlamach yejhuan Jesús quichihuaya. Niman no ocualanquej ijcuac ocacquej on coconej ijquin tzajtziyaj ne ipan on hueyi tiopan: “¡Ma noyectenehua in huejca teixhuiu itech rey David!” ");
INSERT INTO nguNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yejhua ica oquijlijquej Jesús: ―¿Ticaqui tlen on yejhuamej in quijtohuaj? Niman Jesús oquimijlij: ―Quemaj nicaqui. ¿Tlen xqueman nenquimomachtiaj on Yectlajcuilojli campa quijtohua: “Oticchiu para on coconej niman on tzelicacoconej ma mitzcuicatlalican ica on melajqui yectenehualistli”? ");
INSERT INTO nguNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Quemaj yejhua oquintlalcahuij, niman onejcuenij ne ipan on hueyican. Oyaj ne ipan on pueblo itoca Betania, campa onocau ipan on tlayohua. ");
INSERT INTO nguNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ijcuac cualcan, Jesús ocsejpa yaya ne Jerusalén, niman ipan iojhui opeu apismiqui. ");
INSERT INTO nguNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","San nisiu campa yaya oquitac se cojtli itoca higuera. Pero ijcuac oquinisihuij, xoquinextilij itlaquilyo on cojtli, yej san ixojyo quipiaya. Quemaj Jesús oquijlij on higuera: ―Ma ca sa queman titlaquis. Niman on higuera nimantzin ohuac. ");
INSERT INTO nguNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ijcuac on nomachtijquej ijcon oquitaquej, omojcatlachixquej niman oquitlajtoltijquej Jesús: ―¿Quen ijqui, tej, ohuel nimantzin ohuac on higuera? ");
INSERT INTO nguNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús oquimijlij: ―Ica tlen melahuac nemechijlia, ica tla nentlaneltocaj niman xnenometlamatij, xsan yejhua on tlen onicchihuilij on higuera huelis nenquichihuasquej, yej no huelis nenquijlisquej yejhua in tepetl: “Xmejcuanij nican, niman xcalaqui ne ijtic on mar”, niman ijqui nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Niman tla nentlaneltocasquej nochi on tlen nemejhuamej nenquitlajtlanisquej ijcuac nenquichihuasquej oración, nenquiselisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Quemaj Jesús ocalac ne ipan on hueyi tiopan, niman chica yejhua ompa temachtiaya, oquinisihuijquej intlayecancahuan on tiopixquej niman on intlajtlajmatcahuan on hebreos, niman oquitlajtoltijquej: ―¿Tlen tlanahuatijli ticpia para ticchihua yejhua in tlajtlamach? ¿Aquinon, tej, omitzmacac yejhua on tlanahuatijli? ");
INSERT INTO nguNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús oquimijlij: ―Nejhua no nicpia tlen nemechtlajtoltis. Tla nennechijlisquej on tlen nemechtlajtoltis, nejhua no nemechijlis ican tlen tlanahuatijli nicchihua in tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Aquinon ocuajtitlan Juan para ma otlacuatequij? ¿Dios ocuajtitlan, noso on tlacamej ocuajtitlanquej? Quemaj yejhuamej opejquej ijquin quinochtacatlajtlajtoltiayaj: ―¿Quen ijqui tiquijlisquej? Tla tiquijtosquej ica Dios ocuajtitlan, yejhua techijlis: “Tla ijcon, ¿Tlica xonenquineltocaquej on tlen Juan oquijtoj notechica?” ");
INSERT INTO nguNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Niman tla tiquijtosquej ica on tlacamej ocuajtitlanquej, tehuamej tiquinmacajsij on tlacamej, pampa nochimej quineltocaj ica Juan se tiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yejhua ica oquijlijquej Jesús: ―Xticmatij aquinon ocuajtitlan. Ijcuacon yejhua oquimijlij: ―Yejhua ica nejhua no xnemechijlis aquinon onechmacac tlanahuatijli para nicchihua yejhua in tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús ijquin oquimijlij: ―¿Quen nenquinemiliaj yejhua in? Sen tlacatl quipiaya ome iconeu. Niman on yejhuan yencuiyotl ijquin oquijlij: “Noconeu, aman xtequititi ne ipan notlal para tictequis uvas.” ");
INSERT INTO nguNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","On iconeu oquijlij: “¡Ca! ¡Xnicnequi nias!” Pero más saquin cuajli ononemilij niman oyaj otequitito. ");
INSERT INTO nguNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Quemaj on tajtli oquitato on ocse iconeu, niman no sa no ijqui oquijlij. Niman yejhua in iconeu oquijlij: “Quemaj nias.” Pero yejhua xoyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Catlejhua, tej, de on omemej icniutin oquitlacamat itaj? Yejhuamej oquijtojquej: ―On yejhuan achtoj oquinotz itaj. Ijcuacon Jesús oquinmijlij: ―Ica tlen melahuac nemechijlia, ica yejhuamej on yejhuan tlacobrarohuaj ne ipan on impuestos niman on sihuamej yejhuan san ica nocahuaj tlacapajpatlaj calaquisquej achtopa ne campa Dios tlamandarohua xquen nemejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","In nochihua pampa Juan on tlacuatequijquetl ohuajlaj niman omechititij quen ijqui nonequi nennemisquej, niman nemejhuamej xonenquineltocaquej tlen omechijlij. Pero on yejhuan tlacobrarohuaj ne ipan tlajtlanetli niman on sihuamej yejhuan san ica nocahuaj tlacapajpatlaj oquineltocaquej. Niman masqui nemejhuamej onenquitaquej quen ijqui onoyolpatlaquej on tlacamej, nemejhuamej xonemoyolpatlaquej para onenquineltocaquej on tlen Juan oquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Xcaquican yejhua in ocse ejemplo: Nemiya se tlalejquetl yejhuan ne ipan itlal oquitocac uvas. Quemaj ocorraltij, niman oquichijchiu se pila campa quipatzcasquej on uvas. Niman no oquichijchiu se torre para huelis nochi cuidarosquej. ’Quemaj oquinnextij sequimej medieros para ma tequitican niman cuidarosquej on uvas. Niman quemaj yejhua onejcuenij niman oyaj ipan ocse país. ");
INSERT INTO nguNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ijcuac oajsic on tonaltin para notequis on uvas, on tlalejquetl oquintitlan itequichihuilijcahuan intech on medieros para ma quintlajtlanilitij on medieros quech yejhua quitocarohua quiselis. ");
INSERT INTO nguNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero on medieros ompa oquimajsiquej itequichihuilijcahuan on tlalejquetl. Se oquimajmailijquej, ocse oquimictijquej, niman on ocse oquitemojmotlaquej. ");
INSERT INTO nguNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","On tlalejquetl ocsejpa ocsequimej oquintitlan on itequichihuilijcahuan, niman más miyequej xquen ijcuac achtoj oquintitlanca. Pero on medieros sa no ijqui oquinchihuilijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Quemaj sa ica nochi yejhua oquititlan on yejhuan mero iconeu pampa oquinemilij: “Melahuac quitlacaitasquej noconeu.” ");
INSERT INTO nguNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ijcuac on medieros oquitaquej on teconeu, opeu ijquin quinojlaj: “Yejhua in iconeu on tlalejquetl. Ijcuac miquis itaj, yejhua yes iyaxca nochi in tlajli. Aman ma ticmictican para totech nocahuas on herencia.” ");
INSERT INTO nguNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yejhua ica, tej, ompa ocajsiquej; oquixtijquej ne ipan on uvasyoj, niman oquimictijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Quemaj Jesús ijquin oquintlajtoltij: ―Ijcuac huajlas iteco on tlajli, ¿tlinon quinchihuilis on medieros? ");
INSERT INTO nguNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yejhuamej oquijlijquej: ―Xquimicnelis para quinmictis on xcuajcualtin medieros. Niman yejhua quintejtemos ocsequimej medieros yejhuan quitequitisquej on uvas, niman ijcuac ajsis on tonajli quimacasquej quech quitocaros quiselis. ");
INSERT INTO nguNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ijcuacon Jesús oquimijlij: ―¿Xqueman nenquimomachtianij yejhua in Yectlajcuilojli yejhuan ijquin quijtohua? On tetl yejhuan xoquiselijquej on tepanchijquej aman yejhua yonotlalij yacatztica. Yejhua in ijqui oquitlalij on toTeco, niman ticmojcaitaj tlen tiquitaj. ");
INSERT INTO nguNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yejhua ica nemechijlia ica Dios xmechcahuilis nencalaquisquej ne campa yejhua tlamandarohua. Yej quincahuilis calaquisquej on yejhuan quichihuasquej on tlen cuajli quinequi Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Niman ica yejhua on tetl yejhuan onemechijlij, on sa no yejhua in, ica san aquin huetzis ipan on tetl notepojpostequis, niman tla on tetl yacaj ipan onhuetzis, cuejcuechtilis. ");
INSERT INTO nguNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ijcuac intlayecancahuan on tiopixquej niman on fariseos ocacquej on ejemplos yejhuan Jesús quintlaliliaya, oquimatquej ica Jesús intechcopa tlajtohuaya. ");
INSERT INTO nguNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yejhua ica, tej, quinequiyaj cajsisquej, pero quinmacajsiyaj on tlacamej, pampa on tlacamej quineltocayaj ica Jesús se tiotlajtojquetl yejhuan tlajtlajtohua ica on tlen Dios quimachiltia. Yejhua ica, tej, xocajsiquej. ");
INSERT INTO nguNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ocsejpa opeu quinnojnotza ican ejemplos, niman ijquin oquimijlij: ");
INSERT INTO nguNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ne campa tlamandarohua on ilhuicac chanej sa no ijqui quen on ilhuitl yejhuan oquichiu on rey ijcuac ononamictij itelpoch. ");
INSERT INTO nguNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Oquintitlan on itequitcahuan para ma quimanatij on yejhuan itenotzcahuan yejhuan yoquinnotzcaj ipan ilhuitl. Pero on yejhuan yoquinnotzcaj xoquinequej oyajquej ipan in ilhuitl. ");
INSERT INTO nguNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Quemaj ocsejpa oquintitlan ocsequimej itequitcahuan, niman oquimijlij: “Xquimijlican on yejhuan yotiquinnotzcaj ica ye nicpia listo on tlacuajli. Nohuacaxhuan niman ocsequimej yolquej yejhuan tojtomajquej yoquinmictijquej, niman nochi on tlacuajli ye oncaj listo. Ma hualajtetzican ipan in ilhuitl.” ");
INSERT INTO nguNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero on itenotzcahuan xoquitencaquej. Semej yejhuamej oyaj oquintato itlalhuan, niman ocse oyaj otlasemanato. ");
INSERT INTO nguNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","On ocsequimej oquimajsiquej itequitcahuan on rey niman sanoyej oquinmajmailijquej, niman quemaj oquinmictijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ijcuacon on rey sanoyej ocualan, niman oquintitlan isoldados para no ma quinmictitij on yejhuan otemictijquej, niman para quitlatisquej on impueblo. ");
INSERT INTO nguNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Quemaj oquimijlij on itequitcahuan: “Nochi ye oncaj listo para on ilhuitl, pero on yejhuan ye tlanotzalticatcaj xquinmelahuaya huajlasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Xhuiyan, tej, ipan iesquinas on calles, niman nochimej on yejhuan nenquinnamiquisquej xquinnotzacan ma huajhuiyan ipan in ilhuitl.” ");
INSERT INTO nguNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yejhua ica on tequipanojquej oyajquej ipan on calles, niman oquinsentlalijquej nochimej on yejhuan oquinnamiquej. Oquisentlalijquej, tej, on yejhuan xcuajcualtin tlacamej niman on yejhuan cuajcualtin tlacamej. Niman ijcon on cajli oten ican tlanotzaltin. ");
INSERT INTO nguNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Quemaj on rey ocalac ipan on cajli para quintas on tlanotzaltin. Ompa oquitac se tlacatl yejhuan xonotlaquentij quen nonequi notlaquentihuas ipan on quen on ilhuitl. ");
INSERT INTO nguNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Niman oquijlij: “Notetlajsojcau, ¿quen ijqui ohuel oticalac nican niman xtitlaquemej quen nonequi notlaquentihuas ipan in quen in ilhuitl?” Pero yejhua xonahuat. ");
INSERT INTO nguNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Quemaj on rey ijquin oquinnahuatij on yejhuan tetlamacayaj: “Xmasajsalocan niman xquicxisajsalocan, niman xcontlajcalican campa tlayohuatoc campa chocas niman notlantotopotzas.” ");
INSERT INTO nguNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Quemaj Jesús oquijtoj: “Dios miyequej oquinnotz, pero xmiyequej on yejhuan oquintlapejpenij.” ");
INSERT INTO nguNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Quemaj on fariseos oyajquej, niman san secan oquinojlijquej quen ijqui quichihualtisquej Jesús itlaj ma quimijli yejhuan ica huelis quiteixpanhuisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Quemaj, tej, on fariseos oquintitlanquej itech Jesús on innomachtijcahuan inhuan on yejhuan oquipalehuijquej Herodes para ma calaqui rey. Yejhuamej oquijlijquej: ―Temachtijquetl, ticmatztoquej ica nochipa tiquijtohua on tlen melahuac. On tlacamej cuajli tiquintitia quen Dios quinequi para nohuicasquej. Tejhua xticchihuilia cuenta on tlen quijtohuaj motechcopa on tlacamej, masqui huejhueyixtoquej. ");
INSERT INTO nguNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aman, tej, xtechijli tlinon ticnemilia. ¿Itlanahuatil Moisés techcahuilia titlatlaxtlahuasquej ican impuestos itech César yejhuan itequihuaj nochi on país de Roma? ");
INSERT INTO nguNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesús oquimat ica yejhuamej ijcon quitlajtoltiayaj san para cajcayahuasquej. Yejhua ica ijquin oquimijlij: ―Omexayacyejquej, ¿tlica nennechchihualtisnequij ma nemechijli itlaj yejhuan ica huelis nennechteixpanhuisquej? ");
INSERT INTO nguNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xnechititican on tomin yejhuan ica notlaxtlahua on impuestos. Niman yejhuamej oquititijquej se tomin. ");
INSERT INTO nguNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ijcuac Jesús oquitac on tomin, oquintlajtoltij: ―¿Aquinon ixayac yejhua in, niman aquinon itocayo in nican tlajcuilolnesticaj ipan in tomin? ");
INSERT INTO nguNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yejhuamej oquijlijquej: ―Iyaxca on tequihua César. Quemaj Jesús oquimijlij: ―Xmacacan César on tlen yejhua iyaxca, niman no xmacacan Dios on tlen yejhua iyaxca. ");
INSERT INTO nguNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ijcuac yejhuamej ijcon ocacquej, otlamojcaitaquej, niman ijqui oquitlalcahuijquej, niman oyajquej. ");
INSERT INTO nguNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ipan sa no on tonajli semej saduceos oquitatoj Jesús. Yejhuamej temachtiayaj ica xhuelis yolihuisquej niman noquetztehuasquej on mimiquej. Yejhua ica ijquin oquijlijquej: ");
INSERT INTO nguNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Temachtijquetl, Moisés oquijtoj ica tla miqui se tlacatl yejhuan xoquipix iconehuan, icniu on tlacatl ica oncaj nonamictis ihuan on sihuacahuajli, niman ihuan tlascaltis para on coconej nemisquej quen iconehuan yesquia on icniu yejhuan omic. ");
INSERT INTO nguNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aman, tej, nican totzajlan nemiyaj chicomemej icniutin. On achtoj teicniu ononamictij, niman omic. Niman ica xoquipix iconehuan, on icniu ihuan on sihuacahuajli ononamictij. ");
INSERT INTO nguNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","No ijqui oquichiu on ica ome teicniu, quemaj on ica yeyi teicniu, niman ijqui onochijtiaj hasta otlanquej on chicomemej icniutin. ");
INSERT INTO nguNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ijcuac on icniutin nochimej yomiquej, quej yejhua on sihuatl omic. ");
INSERT INTO nguNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tla ijcon, tej, ijcuac yolihuis, ¿catlejhua itech tesihuau yes de yejhuamej on chicomemej icniutin, pampa nochimej oquipixquej quen insihuau? ");
INSERT INTO nguNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús oquimijlij: ―Nemejhuamej nemopopolohuaj, pampa xnenquimatij tlinon quijtohua on Yectlajcuilojli nion nenquimatij ica Dios nochi hueli quichihua. ");
INSERT INTO nguNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tej, ijcuac on mimiquej yolihuisquej, xnonamictisquej nion on tatajtin quitemacasquej imichpochhuan para ma nonamictican. Ijcuacon nemisquej quen iilhuicactequitcahuan Dios yejhuan nemij ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","’Niman aman on ica yolihuisquej niman noquetztehuasquej on mimiquej, ¿xnenquimomachtianij on tlen Dios omechijlij? Yejhua ijquin oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nejhua niiDios Abraham, nejhua niiDios Isaac niman nejhua niiDios Jacob.” Ticmatij ica Dios xejhua inDios on mimiquej, yej yejhua inDios on yoltoquej. ");
INSERT INTO nguNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ijcuac on tlacamej ijcon ocacquej, nochimej otlamojcaitaquej ica on itemachtil Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ijcuac on fariseos oquimatquej ica Jesús oquincamatzacu on saduceos, san secan onosentlalijquej, niman quej yejhuamej oquinisihuijquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Quemaj semej yejhuamej on yejhuan tepantlajtojquetl catca ican itlanahuatil Dios oquinec quistlacos Jesús, niman ijquin oquitlajtoltij: ");
INSERT INTO nguNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Temachtijquetl, ¿catlejhua tlanahuatijli más hueyixticaj ipan on itlanahuatil Moisés? ");
INSERT INTO nguNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús oquijlij: ―“Xtlajsojtla on moTeco Dios ican nochi moyojlo, ican nochi moalma niman ican nochi motlamachilis.” ");
INSERT INTO nguNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yejhua in yejhua más hueyixticaj niman yejhua yecatzticaj de nochimej on tlanahuatiltin. ");
INSERT INTO nguNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Niman on ica ome tlanahuatijli yejhuan no ijqui hueyi quijtosnequi quen on achtoj tlanahuatijli ijquin quijtohua: “Xquintlajsojtla ocsequimej no ijqui quen tejhua timotlajsojtla.” ");
INSERT INTO nguNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yejhua in ome tlanahuatijli quitzquijticaj nochi itlanahuatil Moisés niman intemachtilhuan on tiotlajtojquej. ");
INSERT INTO nguNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Chica on fariseos san secan nemiyaj, Jesús ijquin oquintlajtoltij: ");
INSERT INTO nguNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Tlinon nenquinemiliaj nemejhuamej itechica Cristo on yejhuan Dios oquitlapejpenij para tlamandaros? ¿Aquinon itech huejca teixhuiu? Yejhuamej oquijlijquej: ―Yejhua huejca teixhuiu itech David. ");
INSERT INTO nguNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ijcuacon Jesús oquimijlij: ―¿Tlica, tej, on Espíritu Santo oquichihualtij David para ma quijto ica Cristo “noTeco”, pampa David ijquin oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dios oquijlij noTeco: “Xmotlali nican ipan noyecma, hasta queman ma nimitztlali tlayecanquetl intech on yejhuan motlahuelicnihuan”? ");
INSERT INTO nguNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tla David ijcon oquijtoj ica Cristo yejhua iTeco, tla ijcon, tej, ¿quen ijqui Cristo hueli huejca teixhuiu itech David? ");
INSERT INTO nguNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Niman xacaj ohuel oquinanquilij nion ican se tlajtojli. Niman desde ipan on tonajli nochimej pinahuayaj para itlaj quitlajtoltisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Quemaj Jesús oquimijlij on tlacamej niman on inomachtijcahuan: ");
INSERT INTO nguNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―On temachtijquej ican itlanahuatil Dios niman on fariseos quipiaj tlanahuatijli para quinoquitzquiltiaj on itequiu Moisés. Yejhua ica, aman yejhuamej nonequi temachtiaj ica on itlanahuatil Moisés. ");
INSERT INTO nguNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yejhua ica, tej, nemejhuamej xquintlacamatican, niman xchihuacan nochi tlen mechijlisquej. Pero ma ca xmohuicacan quen yejhuamej, pampa yejhuamej quijtohuaj se tlamantli niman yej ocse quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Niman yejhuamej quinchihualtiaj on tlacamej cuajli ma quejehuacan on miyec tlanahuatiltin. Yejhua in sanoyej ohuijticaj para quejehuasquej. Pero yejhuamej nion siquiera ican se inmajpil quinequij tepalehuisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nochi intequiu quichihuaj san para on tlacamej ma quintacan. Cuelitaj quitquisquej sequimej ihuejhueyi textos on Yectlajcuilojli ijtic on incaja tlachijchiutin ican cuetlaxtli yejhuan quinotlaliliaj ipan imixcuateu niman ipan inma. Niman no cuelitaj quitlalisquej intlaquen ican puntas más pajpatlaquej xquen on ocsequimej tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Quinequij quipiasquej on yejhuan más huejhueyixtoquej sietas ne campa ilhuipan, niman on más cuajcualtin sietas ne ipan on tiopantin. ");
INSERT INTO nguNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yejhuamej quinequij para on tlacamej ma quintlajpalocan ican miyec tetlacaitalistli ne ipan on plazas, niman ma quincuitican temachtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero nemejhuamej ma ca nenquimocahuilisquej ma mechcuitican temachtijquej, pampa nochimej nemejhuamej nemicniutin niman nenquipiaj san se temachtijquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Niman ipan in tlalticpactli ma ca yacaj nenquijlisquej “noTajtzin”, pampa san se nemoTajtzin nenquipiaj, niman yejhua nemi ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nion ma ca nenquimocahuilisquej ma mechcuitican tlayecanquej, pampa san nejhua niCristo yejhuan Dios onechtlalij para tlamandaros, ninemotlayecancau. ");
INSERT INTO nguNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","On yejhuan más hueyixticaj mechpalehuis. ");
INSERT INTO nguNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","On yejhuan nohueyilia quipias nocnelilistli, pero on yejhuan nocnelis quipias hueyilistli. ");
INSERT INTO nguNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Lástima para nemejhuamej temachtijquej ican itlanahuatil Dios niman nemejhuamej fariseos, nenomexayacyejquej! Lástima, pampa on tlacamej xnenquincahuiliaj ma calaquican ne campa tlamandarohua on ilhuicac chanej. Niman sa no nemejhuamej xnencalaquij, nion nenquincahuiliaj calaquisquej on yejhuan quinequij calaquisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Lástima nemejhuamej temachtijquej ican itlanahuatil Dios niman nemejhuamej fariseos, nenomexayacyejquej! Lástima, pampa on sihuacahualtin nenquincuiliaj incal, niman para nesi quen xnentlajtlacolejquej, nenquichihuaj huejhueyac oraciones. Yejhua ica on nemejhuamej más hueyi nenquiselisquej nemocastigo. ");
INSERT INTO nguNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Lástima para nemejhuamej temachtijquej ican itlanahuatil Dios niman nemejhuamej fariseos, nenomexayacyejquej! Lástima, pampa nenquipaxalohuiliaj nochi tlalticpactli para ijqui nencalactiaj se tlacatl ipan nemorreligión, niman ijcuac se tlacatl yonencuepquej, nemejhuamej nenquichihuaj para on tlacatl ocpa ma quitocaro yas ne mictlan campa tetlajyohuiltiloyan xquen nemejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Lástima para nemejhuamej tlayecanquej yejhuan nenquitemachtiaj on tlen xnencajsicamatij! Lástima, pampa nenquijtohuaj: “Tla yacaj quitlalia se promesa, niman notlajtolpalehuiya itech on hueyi tiopan ica quichihuas on promesa, ipromesa xoc itlaj quijtosnequi. Pero tla notlajtolpalehuiya itech on oro yejhuan oncaj ne ipan on hueyi tiopan, on quemaj melahuac hueyi quijtosnequi ipromesa niman yejhua ica nonequi quichihuas on tlen oquitlalij ipan ipromesa.” ");
INSERT INTO nguNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Xnentlanemiliaj niman nenquitemachtiaj on tlen xnencajsicamatij! ¿Catlejhua más hueyixticaj: on oro, noso on hueyi tiopan yejhuan quichipajticaj on oro? ");
INSERT INTO nguNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Niman nemejhuamej no nenquijtohuaj: “Tla yacaj quitlalia se promesa, niman notlajtolpalehuiya itech on tlaixpan ica quichihuas, ipromesa xoc itlaj quijtosnequi. Pero tla notlajtolpalehuiya itech on huintli yejhuan oncaj ne tlapani ipan on tlaixpan, on quemaj melahuac hueyi quijtosnequi ipromesa niman yejhua ica nonequi quichihuas on tlen oquitlalij ipan ipromesa.” ");
INSERT INTO nguNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Nemejhuamej nenquitemachtiaj on tlen xnencajsicamatij! ¿Catlejhua más hueyixticaj: on ofrenda, noso on tlaixpan yejhuan quichipajticaj on huintli? ");
INSERT INTO nguNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tej, on yejhuan notlajtolpalehuiya itech on tlaixpan, ican ipromesa xsan itech on tlaixpan yej no itech on tlen oncaj ipan on tlaixpan. ");
INSERT INTO nguNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Niman on yejhuan notlajtolpalehuiya itech on hueyi tiopan, ican ipromesa xsan itech on tiopan notlajtolpalehuiya, yej no itech Dios yejhuan ompa chanti. ");
INSERT INTO nguNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","No ijqui on yejhuan notlajtolpalehuiya itech ilhuicac ican ipromesa, no notlajtolpalehuiya itech on nesehuilpan campa tequihuajti Dios, niman no itech sa no yejhua Dios yejhuan ompa nosehuia. ");
INSERT INTO nguNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Lástima para nemejhuamej temachtijquej ican itlanahuatil Dios niman nemejhuamej fariseos, nenomexayacyejquej! On tlajtlamach yejhuan nenquipiaj, se nenquiyaxcatiaj Dios itech on majtlactli. In se ejemplo, nenquiyaxcatiaj se menta, se anís niman se comino. Pero xnenquichihuaj on tlen más hueyi quijtosnequi ipan on temachtilistli yejhuan oncaj ipan on tlanahuatijli campa quijtohua ica nonequi nemohuicasquej ican melajcanemilistli, ican teicnelilistli niman ican tlaneltoctli. In yejhua mechmelahua nenquichihuasquej ihuan on tlen nenquichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Nemejhuamej nenquitemachtiaj on tlajtlamach yejhuan xnencajsicamatij! Nemejhuamej nenquitemachtiaj on tlajtlamach yejhuan xhueyi quijtosnequi. Pero on yejhuan hueyi quijtosnequi, xnenquichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Lástima para nemejhuamej temachtijquej ican itlanahuatil Dios niman nemejhuamej fariseos, nenomexayacyejquej! Lástima, pampa nenquichihuaj para ma mechitacan quen sanoyej nencuajcualtin tlacamej, pero nemoyojlo tenticaj ican on tlen nenquitlanij ipan on tlachtecyotl niman ipan on nexicolyotl. ");
INSERT INTO nguNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nemejhuamej fariseos nenquitemachtiaj on tlen xnencajsicamatij. Achtopa, tej, xchipahuacan nemoyojlo, niman quemaj nemotlalnacayo no chipahuis. ");
INSERT INTO nguNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Lástima para nemejhuamej temachtijquej ican itlanahuatil Dios niman nemejhuamej fariseos, nenomexayacyejquej! Lástima, pampa nemijcomej quen on micacajli yejhuan ne camposanto cuajli quistaliaj san para cualtzin tlajtlacha, pero ijtic tenticaj ican micaomimej niman ican nochi tlajtlamach tlen xchipahuac. ");
INSERT INTO nguNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ne imixpan on ocsequimej nesi sanoyej nencuajcualtin tlacamej, pero nemojtic tenticaj ican on tlen xmelahuac niman ican tlajtlacojli. ");
INSERT INTO nguNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Lástima para nemejhuamej temachtijquej ican itlanahuatil Dios niman nemejhuamej fariseos, nenomexayacyejquej! Lástima, pampa nenquinchijchihuiliaj inmicacal on tiotlajtojquej, niman nenquitlatlajmachyotiaj ne campa toctoquej on yejhuan cuajcualtin tlacamej catcaj. ");
INSERT INTO nguNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Niman nenquijtohuaj: “Tla tejhuamej tinemisquiaj ipan on tonaltin ijcuac onenquej on toachtojtajhuan, xtiquimpalehuisquiaj para quinmictisquiaj on tiotlajtojquej.” ");
INSERT INTO nguNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","San nemopantlantiaj ica nenteconehuan intech on yejhuan oquinmictijquej on tiotlajtojquej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Xtlamican on tlajtlacojli yejhuan opejquej quichihuaj on nemoachtojtajhuan. ");
INSERT INTO nguNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Cohuamej! ¡Teconehuan intech on cohuamej! ¿Quen ijqui nemomaquixtisquej itech on castigo yejhuan oncaj ne mictlan campa tetlajyohuiltiloyan? ");
INSERT INTO nguNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yejhua ica nemechinhuajtitlanilis on tiotlajtojquej, on tlajmatquej, niman on temachtijquej. Pero sequimej nenquinmictisquej, sequimej nenquimajmasohualtisquej ipan cojnepanojli, niman ocsequimej nenquinhuihuitequisquej ne ipan on tiopantin. Niman campa cada pueblo ocsequimej oniyanasquej nencomintejtemosquej para más nenquintlajyohuiltisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yejhua ica, tej, nemejhuamej hebreos nenquiselisquej nochi castigo impampa on cuajcualtin tlacamej yejhuan oquinmictijquej huajpejtoc itech Abel hasta itech Zacarías iconeu Berequías, yejhuan nemejhuamej onenquimictijquej itzajlan on tiopan niman on tlaixpan ne quiahuac. ");
INSERT INTO nguNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ica tlen melahuac nemechijlia, ica on hebreos yejhuan aman nemij, quiselisquej nochi on castigo yejhuan hualejticaj intech on yejhuan oquinmictijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Oh nemejhuamej yejhuan nenchantij ne Jerusalén, nemejhuamej nenquinmictiaj on tiotlajtojquej niman nenquintemojmotlaj on yejhuan Dios mechinhuajtitlanilia! ¡Miyecpa onicnec nemechsentlalis quen yejhua on cuanaca quinsentlalia iconehuan itzintlan imajtlapalhuan, pero xonenquinequej! ");
INSERT INTO nguNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aman Dios xoc mechpalehuis, yej mechtlalcahuis. ");
INSERT INTO nguNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yejhua ica, tej, nemechijlia ica xoc ocsejpa nennechitasquej hasta ajsis on tonajli ijcuac nemejhuamej ijquin nenquijtosquej: “Ma Dios quitiochihua on yejhuan ocuajtitlan para tlamandaros.” ");
INSERT INTO nguNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús oquis ne ipan on hueyi tiopan, niman ye yajticatca, ijcuac on inomachtijcahuan oquinisihuijquej para quititisquej quen tlachijchiutli on hueyi tiopan. ");
INSERT INTO nguNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pero Jesús oquimijlij: ―¿Nemejhuamej nenquitaj nochi yejhua in? Ica tlen melahuac nemechijlia, ica nican nion se tetl xnocahuas ipan ocse tetl, pampa nochi quixoxotonisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Niman ijcuac yehuaticatca Jesús ne ipan on tepetl itoca Olivos, on nomachtijquej oyajquej itech niman ijquin sa iseltimej oquichtacaijlitoj: ―Xtechijli, ¿quemanon nochihuas on tlajtlamach, niman tlinon tlamajhuisojli noteititis ijcuac tejhua tihuajlas ocsejpa, niman ijcuac tlatlalpolihuis? ");
INSERT INTO nguNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ijcuacon Jesús oquimijlij: ―Xmotacan sa no nemehuamej para ma ca yacaj mechcajcayahuas, ");
INSERT INTO nguNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","pampa miyequej huajlasquej yejhuan ican noTocatzin cualij tojtiasquej: “Nejhua niCristo”, niman miyequej quincajcayahuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nemejhuamej nencaquisquej ica nisiu oncaj on guerra, niman ica neca huejca no oncaj. Pero ma ca xmoyolpajsolocan pampa nochi on ica oncaj achtoj nochihuas. Pero ijcuac ijcon nochihuas oc xejhua tonajli para tlatlajtlamis. ");
INSERT INTO nguNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","On tequihuajquej nohuijsoquisquej inhuan ocsequimej tequihuajquej niman on países nomictisquej inhuan ocsequimej países. Onyas apistli, niman onyas miyec cualolistli, niman tlalolinis miyecan. ");
INSERT INTO nguNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero in xsan ica nochi yes, yej más onyas tlajyohuilistli. ");
INSERT INTO nguNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Quemaj nemejhuamej mechtemacasquej para mechtlajyohuiltisquej, niman mechmictisquej, niman san nopampa nochi tlacatl mechtlahuelitas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ipan on tonaltin ijcuac ijcon nochihuas, miyequej xoc nechneltocasquej, niman notlahuelitasquej semej ihuan ocsequimej, niman notemactilisquej semej ihuan ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Niman miyequej tlacajcayajquej yejhuan notenehuaj tiotlajtojquej huajnesisquej, niman miyequej quincajcayahuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Niman ica sanoyej miyequiyas on tlen xcuajli, miyequej xoc quipiasquej tetlajsojtlalistli intech ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero on yejhuan quixicos hasta ijcuac nochi tlamis, on yejhua maquisas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Niman in cuajli tlajtojli yejhuan techijlia quen ijqui tlamandarohua on yejhuan ilhuicac chanej, noteijlis nochihuiyan ipan in tlalticpactli para nochimej países ma quixmatican on tlen melahuac. Niman ijcuac nochihuiyan yonoteijlij, ijcuacon tlatlalpolihuis. ");
INSERT INTO nguNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’On yejhuan quinomachtis itlajcuilol Daniel ma cajsicamati. Yejhua otlajcuiloj ica yejhua on tlen tlaijtlacohua niman on tlen tetzinquixtia cuajtlalisquej ne campa tlayectiticaj. Ijcon, tej, ijcuac nemejhuamej nenquitasquej ica yejhua on tlen Daniel oquijcuiloj ye nochijticaj ne campa yectiticaj, ");
INSERT INTO nguNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ijcuacon on yejhuan nemisquej ne Judea ma cholocan niman ma huiyan ne ipan tepemej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Niman on yejhuan ipan on tonajli nemis ne icuapan ical, ma ca huajtemos para itlaj quixtis ne icalijtic. ");
INSERT INTO nguNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Niman on yejhuan nemis ne ipan imil, ma ca nocuepas ichan para concuis itlaj itlaquen. ");
INSERT INTO nguNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Sanoyej xcuajli yes para on sihuamej yejhuan ipan on tonaltin yocanquej inconetzin niman on sihuamej yejhuan ipan on tonaltin tlachichitisquej! ");
INSERT INTO nguNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nemejhuamej xchihuacan oración itech Dios para ma ca nencholosquej ipan on tonaltin ijcuac sanoyej sehuas, nion ipan on tonajli ijcuac nosehuiaj on hebreos, ");
INSERT INTO nguNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","pampa ijcuacon sanoyej miyec onyas tlajyohuilistli quen yejhuan xqueman oncaj desde ijcuac otzimpeu yejhua in tlalticpactli, niman xqueman onyas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tla yejhua xquinteltlalis on tonaltin, nochimej miquisquej. Pero Dios quinteltlalis on tonaltin impampa on yejhuan yoquintlapejpenij. ");
INSERT INTO nguNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Tla ijcuacon yacaj mechijlis: “Xquitacan, nican nemi Cristo”, noso “Xquitacan, nepa nemi”, ma ca xneltocacan. ");
INSERT INTO nguNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ma ca xneltocacan, pampa huajlasquej on tlacajcayajquej yejhuan notenehuasquej Cristos noso tiotlajtojquej. Niman quichihuasquej huejhueyi tlamajhuisoltin niman milagros para tecajcayahuasquej, niman hasta on yejhuan Dios yoquintlapejpenij. Pero yejhuamej xhuelisquej quincajcayahuasquej on yejhuan Dios yoquintlapejpenij. ");
INSERT INTO nguNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Xmotacan sa no nemejhuamej. Xquipia tlica nenhuetzisquej, pampa ye nemechmachiltijticaj tlinon nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Yejhua ica, tla mechijlisquej: “Xquitacan, nepa nemi Cristo campa tlapatlaco”, ma ca xhuiyan. Noso tla mechijlisquej: “Xquitacan nican iyanticaj ijtic in caltzintli”, ma ca xneltocacan. ");
INSERT INTO nguNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ma ca xneltocacan, pampa ijcuac nejhua yejhuan oninochiu Tlacatl nihuajlas, nochi tlacatl nechitas quen on tlapetlanajli nochi tlacatl quita ijcuac ne iquisayan tonaltzintli ompa pehua petlani niman hasta ne icalaquiyan tonaltzintli ontlami petlani. ");
INSERT INTO nguNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","’Ijcuac nihuajlas, nicuaquis castigo para nochi yejhuan xcuajli tlacatl no ijqui quen on tzopilomej huajlahuij ne campa xintoquej on yolquej yejhuan yomiquej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ijcuac yopanoquej on tonaltin ican tlajyohuilistli, nimantzin xoc tlahuilos on tonaltzintli niman on metztli xoc petlanis. Niman on sitlalimej huajxinisquej niman hasta on tlen cojtilijticaj on cielo huihuixcas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Quemaj ne ipan cielo quitasquej notlamajhuisol, nejhua yejhuan oninochiu Tlacatl. Niman ijcuacon nochi tlajtlacoltlacatl quipias hueyi ajmantli, niman nechitas nejhua yejhuan oninochiu Tlacatl, nihuajlas ican nohueyi poder niman nohueyilis. Nihuajlas ipan on moxtli yejhuan quisa ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Quemaj ica on trompeta chicahuac quipitzasquej, niquinhuajtitlanis on noilhuicactequitcahuan para quinsentlalisquej nochimej on yejhuan Dios yoquintlapejpenij nochihuiyan ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Xcajsicamatican in ejemplo itech on higuera. Ijcuac on imahuan seliaj niman pehua xojyoquisaj, nemejhuamej nenquimatij ica ye nisiu on xopantlaj. ");
INSERT INTO nguNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","In sa no ijqui, ijcuac nemejhuamej nenquitasquej nochi yejhua in tlajtlamach ye nochijticaj, xmatican ica ye listo para nihuajnocuepas ocsejpa. ");
INSERT INTO nguNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ica tlen melahuac nemechijlia, ica nochi yejhua in tlajtlamach nochihuas ijcuac xe miquij on tlacamej yejhuan nemij ipan in tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","On cielo niman in tlalticpactli popolihuis, pero notlajtol xqueman popolihuis ifuerza. ");
INSERT INTO nguNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Pero on tonajli niman on hora para tlatlalpolihuis xacaj quimati, nion yejhuamej on ilhuicactequitquej ne ilhuicac nemij, nion nejhua yejhuan niiConeu Dios. Yej san Dios toTajtzin quimati. ");
INSERT INTO nguNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ijcuac nejhua yejhuan oninochiu Tlacatl nihuajlas, on tlacamej ijcon quichihuasquej quen oquichijquej ipan on tonaltin ijcuac nemiya Noé. ");
INSERT INTO nguNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ipan on tonaltin, ijcuac xe apachihuilo, on tlacamej tlacuayaj, atliyaj, nonamictiayaj niman quitemacayaj inichpochhuan para ma nonamictican hasta ipan on tonajli ijcuac Noé ocalac ipan barco. ");
INSERT INTO nguNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Niman yejhuamej xoquichihuilijquej cuenta on tlen nochijticatca, yej hasta ijcuac opeu quiahui niman on atl nochimej oquinmictij. Ijcon, tej, quen ipan on tonaltin onochiu, no ijqui nochihuas ijcuac nejhua yejhuan oninochiu Tlacatl nihuajlas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ipan on tonajli omemej tlacamej tequitisquej ne ipan tepetl. Se cuicasquej niman ocse cajtehuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Omemej sihuamej tistiasquej ipan se molino. Se cuicasquej niman ocse cajtehuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Xtlachixtiacan, tej, pampa xnenquimatij tlen hora huajlas on nemoTeco. ");
INSERT INTO nguNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero xmatican yejhua in, ica tla se tlacatl tlayecanqui ican ichanchanecahuan quimatisquia tlen hora huajlas on tlachtequetl, yejhua xcochisquia niman xcahuilisquia on tlachtequetl ma quitlapohuili ical para quitlachtequilis. ");
INSERT INTO nguNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yejhua ica, nemejhuamej no nochipa xnemican listos, pampa ijcuac xnenquinemilijtiasquej ica nihuajlas, nejhua yejhuan oninochiu Tlacatl ijcuacon nihuajlas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Aquinon on tequitquetl yejhuan nochipa quichihua quen iteco quinahuatia niman quipia cuajli itlamachilis? On tequitquetl sa no yejhua on, yejhuan iteco quimactilia ichanchanecahuan niman itequitcahuan para quimacas on tlen quicuasquej ijcuac nonequi. ");
INSERT INTO nguNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dios quitiochihuas on tequitquetl yejhuan ijcuac huajlas iteco, cuajnextis cuajli quichijticaj itequiu. ");
INSERT INTO nguNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ica tlen melahuac nemechijlia, ica on iteco quimactilis on tequitquetl nochi tlen yejhua quipia para quejehuas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero tla yejhua on tequitquetl nocuepas xcuajli tlacatl, niman quinemilis ica iteco nohuejcahuas para huajlas, ");
INSERT INTO nguNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","niman pehuas quinhuihuitequis on ocsequimej tequitquej, niman no notlalis tlacuas niman tlahuanis inhuan on tlahuanquej, ");
INSERT INTO nguNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","on iteco huajlas ipan on tonajli niman ipan on hora ijcuac yejhua xquimatztias ica huajlas. ");
INSERT INTO nguNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Niman on iteco sanoyej quitlajyohuiltis, niman quitlalis inhuan on omexayacyejquej campa chocas niman notlantotopotzas. ");
INSERT INTO nguNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Ipan on tonajli ijcuac nihuajlas, on yejhuan quinequij calaquisquej ne campa tlamandarohua on yejhuan ilhuicac chanej, ijcon yesquej quen on majtlactlimej ichpocamej. Cada se oquitquic itlahuil ican aceite niman oyajquej ne campa conamiquisquej on novio, yejhuan huajlaya para nonamictis. ");
INSERT INTO nguNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Macuijli de yejhuamej xtlamatquej catcaj, niman on ocse macuijli huej quemaj tlamatquej catcaj. ");
INSERT INTO nguNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","On yejhuan xtlamatquej catcaj ijcuac oquitquiquej intlahuil, xoquitquiquej aceite para quitequilisquej on intlahuil. ");
INSERT INTO nguNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero on yejhuan tlamatquej catcaj oquitquiquej aceite ican imbotella. ");
INSERT INTO nguNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Niman ica on novio polihuiya para yejcos, nochimej opeu cochisnequij, niman ijqui ocochquej. ");
INSERT INTO nguNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","’Quemaj ijcuac canaj tlajcoihuan, ocaquistic se tlajtojli: “¡Ye huajlau on novio! ¡Xnamiquitij!” ");
INSERT INTO nguNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nochimej on ichpocamej otlachixquej, niman opeu quectlaliaj intlahuil. ");
INSERT INTO nguNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Quemaj on macuiltimej ichpocamej xtlamatquej oquimijlijquej on yejhuan tlamatquej: “Achijtzin xtechmacacan nemoaceite, pampa totlahuilhuan ye sejtoquej.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero on yejhuan tlamatquej ichpocamej oquinnanquilijquej: “Ca, pampa tla ijcon xcaxilis para tejhuamej niman nemejhuamej. Más cuajli, xhuiyan campa quinamacaj, niman xcohuacan yejhuan para nemejhuamej.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero chica on macuijli ichpocamej xtlamatquej ocohuatoj on aceite, oyejcoc on novio. Quemaj on ichpocamej yejhuan quimachayaj oyajquej ihuan on novio ipan on ilhuitl campa nonamictihuaj. Ijcuac yejhuamej ocalaquej ipan on ilhuitl on tlatzacuilyotl onotzacu. ");
INSERT INTO nguNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","’Quemaj oajsiquej on ocsequimej ichpocamej, niman oquijtojquej: “¡Señor, Señor, xtechtlatlapohuili!” ");
INSERT INTO nguNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero yejhua oquinnanquilij: “Ica tlen melahuac nemechijlia ica nejhua xnemechixmati.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Quemaj Jesús oquimijlij: ―Nemejhuamej xnemican ican tlamachalistli, pampa xnenquimatij on tonajli nion yejhua on hora ijcuac nejhua yejhuan oninochiu Tlacatl nihuajlas. ");
INSERT INTO nguNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Nemechijlia ocse ejemplo ica yejhua on tonajli ijcuac nihuajlas. Ijcuac nihuajlas nicchihuas quen oquichiu on tlacatl yejhuan, ijcuac ye yas ipan ocse país, oquinnotz on itequitcahuan niman oquinmactilij itomin para ma ica tequitican, ijcuac xac yes. ");
INSERT INTO nguNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Se oquimacac canaj ompoajli huan majtlactli mil pesos, ocse oquimacac canaj sempoajli mil pesos, niman ocse canaj majtlactli mil pesos. Oquinmacac san quech se hueli quitequitiltis. Quemaj yejhua oyaj ipan ocse país. ");
INSERT INTO nguNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","’On tequitquetl, yejhuan oquiselij ompoajli huan majtlactli mil pesos, oquitequitiltij on tomin, niman ijqui oquitlan ocse ompoajli huan majtlactli mil pesos. ");
INSERT INTO nguNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Niman on yejhuan oquiselij sempoajli mil pesos sa no ijqui oquichiu, niman no oquitlan ocse sempoajli mil pesos. ");
INSERT INTO nguNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero on yejhuan oquiselij majtlactli mil pesos oyaj niman oquiyanato ne ijtic tlajli itomin on iteco. ");
INSERT INTO nguNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Miyec tonaltin más saquin, ohuajlaj inteco on tequitquej, niman opeu inhuan quixtia cuenta. ");
INSERT INTO nguNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Achtopa itech ohuajlaj on yejhuan oquiselijca ompoajli huan majtlactli mil pesos, niman oquititij iteco on ocsequi ompoajli huan majtlactli mil pesos yejhuan oquitlan. Oquijlij: “Señor, otinechmacac ompoajli huan majtlactli mil pesos, niman nican ticpia in ocse ompoajli huan majtlactli mil yejhuan onictlan.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Iteco oquijlij: “¡Sanoyej cuajli! Tejhua ticuajli tequitquetl, niman oticchiu quen onicnec. Aman ica xomitzixcajcayau on achijtzin, más miyec nimitzmactilis. Xcalaqui niman nohuan xpaqui.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Quemaj itech ohuajlaj on yejhuan oquiselij sempoajli mil pesos, niman oquijlij: “Señor, otinechmacac sempoajli mil pesos, niman nican ticpia in ocse sempoajli mil pesos yejhuan onictlan.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","On iteco oquijlij: “¡Sanoyej cuajli! Tejhua ticuajli tequitquetl, niman oticchiu quen onicnec. Aman ica xomitzixcajcayau on achijtzin, más miyec nimitzmactilis. Xcalaqui niman nohuan xpaqui.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero ijcuac oyejcoc on tequitquetl yejhuan oquiselijca majtlactli mil pesos, oquijlij on iteco: “Señor, nejhua nicmatzticatca ica tejhua xtiteicnelia, niman ticmoyaxcatia itlanca on tlen se quitequiti. ");
INSERT INTO nguNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yejhua ica nejhua oninomojtij, niman oniaj oniquiyanato motomin ne ijtic tlajli. Pero nican ticpia on tlen otinechmacac.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Iteco oquijlij: “Xcuajli tequitquetl niman tlatzijqui, ye ticmatzticatca ica nicnoyaxcatia itlanca on tlen se quitequiti. ");
INSERT INTO nguNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yejhua ica, nonequiya ticalactisquia notomin ipan banco para ijcuac nejhua nihuajlasquia nicselisquia on tlen noyaxca niman on itlanca.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Quemaj on teteco oquinnahuatij on yejhuan ompa nemiyaj: “Xcuilican on majtlactli mil pesos, niman xmacacan on yejhuan aman quipia cien mil pesos, ");
INSERT INTO nguNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","pampa on yejhuan quitequitiltia on tlen quipia, quitlanis más, niman on yejhuan xquitequitiltia on tlen quipia, quipolos on tlen achijtzin quipia. ");
INSERT INTO nguNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aman in tequitquetl, yejhuan xitlaj ica servirohua, xcontlajcalican ne campa tlayohuatoc campa chocas niman notlantotopotzas.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ijcuac nejhua yejhuan oninochiu Tlacatl nihuajlas ican nohueyilis inhuan nochimej noilhuicactequitcahuan, nihuajlas ican tlanahuajtijli para nitetlajtlacolmacas niman niteyectenehuas. ");
INSERT INTO nguNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","On tlacamej de nochihuiyan países nixpan nosentlalisquej. Quemaj on yejhuan yolchipajquej niquinxelos intech on yejhuan xyolchipajquej, ijcon quen on tlajpixqui quinxelohua on iborreguitos itech on ichivos. ");
INSERT INTO nguNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","On yejhuan borreguitos niquintlalis ipan noyecma, niman on yejhuan chivos niquintlalis ipan nopochma. ");
INSERT INTO nguNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Quemaj nejhua niquimijlis on yejhuan niquintlalis ipan noyecma: “Nemejhuamej yejhuan noTajtzin omechtiochiu, xhuajlacan niman xcalaquican ne campa nitlamandarohua quen Rey. Ompa Dios otlayectlalij para nemejhuamej, desde ijcuac oquichijchiu in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mechmelahua nencalaquisquej, pampa nejhua onapismic, niman nemejhuamej onennechtlacualtijquej. Nejhua onamic, niman onennechatlitijquej. Oniquistinen quen huejca chanej, niman onennechsehuijquej nemochan. ");
INSERT INTO nguNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nechpolojticatca notlaquen, niman onennechmacaquej. Onicualoc, niman onennechpalehuijquej. Nitzacuticatca niman onennechitacoj.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Ijcuacon on yejhuan yolchipajquej nechtlajtoltisquej: “ToTeco, ¿quemanon otimitzitaquej ican apistli niman otimitztlacualtijquej? ¿Noso quemanon otimitzitaquej ican amictli, niman otimitzatlitijquej? ");
INSERT INTO nguNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Noso quemanon otimitzitaquej quen tihuejcachanej, niman otimitzsehuijquej tochan, noso omitzpoloj motlaquen, niman otimitzmacaquej? ");
INSERT INTO nguNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Noso quemanon otimitzitaquej ticualo, noso titzacuticaj niman otimitzitatoj?” ");
INSERT INTO nguNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Niman nejhua yejhuan niRey niquimijlis: “Ica tlen melahuac nemechijlia ica nochi on tlen ica onenquipalehuijquej intech in nocnihuan yejhuan xhuejhueyixtoquej, sa no nejhua onennechpalehuijquej.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Quemaj niquimijlis on yejhuan nemij ipan nopochma: “Xmejcuanican notech nemejhuamej yejhuan Dios yomechtlajtlacolmacac. Xhuiyan ne ipan on tlitl yejhuan nochipa tlicuitias. On tlitl Dios oquitlalij para on diablo niman on ilhuicactequitquej yejhuan aman quitequipanohua on diablo. ");
INSERT INTO nguNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ompa, tej, xhuiyan pampa onapismic, niman nemejhuamej xonennechtlacualtijquej. Onamic, niman xonennechatlitijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Oniquistinen quen huejca chanej, niman xonennechsehuijquej nemochan. Nejhua onechpoloj notlaquen, niman xonennechmacaquej. Nejhua onicualoc niman no nitzacuticatca, pero xonennechnotzatoj.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Ijcuacon yejhuamej nechijlisquej: “Señor, ¿quemanon otimitzitaquej ican apistli, noso ican amictli, noso quen huejca tichanej, noso mitzpolojticatca motlaquen, noso ticualo, noso titzacuticaj niman xotimitzpalehuijquej?” ");
INSERT INTO nguNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Niman niquimijlis: “Ica tlen melahuac nemechijlia, ica nochi on tlen xonenquipalehuijquej semej yejhuamej in nocnihuan yejhuan xhuejhueyixtoquej, sa no nejhua xonennechpalehuijquej.” ");
INSERT INTO nguNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Quemaj yejhuamej in xyolchipajquej yasquej ne campa para nochipa nemisquej ipan tlajyohuilistli, pero on yejhuan yolchipajquej yasquej ne campa para nochipa quipiasquej on nemilistli. ");
INSERT INTO nguNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ijcuac Jesús otlan tlajtlajtohua, oquimijlij on inomachtijcahuan: ");
INSERT INTO nguNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Nemejhuamej nenquimatztoquej ica polihui ocse ome tonajli para onyas on ilhuitl pascua. Ipan on tiempo, nejhua yejhuan oninochiu Tlacatl, nechtemactilisquej para nechmajmasohualtisquej ipan cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Quemaj intlayecancahuan on tiopixquej inhuan on temachtijquej ican tlanahuatijli, niman on tlajtlajmatquej intech on hebreos onosentlalijquej ne iquiahuac on ipalacio Caifás. Yejhua on más hueyi intlayecancau on tiopixquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ompa san secan oquinojlijquej para san ichtacatzin cajsisquej Jesús niman quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero quijtohuayaj: ―Ma ca ijcon ticchihuasquej ipan on ilhuitl para ma ca najcomanasquej on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús nemiya ne Betania ichan Simón, on yejhuan oquipatijca ijcuac palaniya inacayo. ");
INSERT INTO nguNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Niman chica Jesús yehuaticatca ne itech on mesa, oquinisihuij se sihuatl. Yejhua quitquiya se botella tlachijchiutli ican on tetl yejhuan fino. On botella tentiaya ican ajhuiyalistli yejhuan sanoyej patioj. Niman on sihuatl oquitoyau on ajhuiyalistli ipan itzontecon Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Niman ijcuac on nomachtijquej oquitaquej tlinon quichihua on sihuatl, ocualanquej niman opeu ijquin quijtohuaj: ―¿Tlica oixpoliu yejhua on? ");
INSERT INTO nguNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yejhua on huelisquia patioj nonamacasquia, niman ica on tomin nopalehuisquiaj on mayanquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús ocac on tlen quijtohuayaj, niman oquimijlij: ―¿Tlica nenquipajsolohuaj yejhua in sihuatl? Yejhua in tlen yejhua nechchihuilia sanoyej cuajli. ");
INSERT INTO nguNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nemejhuamej nochipa nemotzajlan nenquimpiasquej on mayanquej, pero nejhua xnochipa nican nennechpiasquej nemohuan. ");
INSERT INTO nguNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","On ica in sihuatl oquitoyau on aceite ajhuiyalistli ipan notlalnacayo, oquichiu para nechpalehuis ijcuac nechtocasquej ipan notlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ica tlen melahuac nemechijlia, ica ne imanyan in tlalticpactli campa noteijlis on temachtilistli yejhuan quitemaca temaquixtilistli, no noteijlis on tlen oquichiu in sihuatl para yejhua no quelnamiquisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Quemaj semej yejhuamej on majtlactli huan ome nomachtijquej, itoca Judas Iscariote, oyaj oquinnotzato intlayecancahuan on tiopixquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Niman oquimijlij: ―¿Quech nennechtlaxtlahuilisquej tla nemechmactilis Jesús? Ijcuacon yejhuamej oquitlaxtlahuilijquej sempoajli huan majtlactli piezas de tomin tlachijchiutin ican plata. ");
INSERT INTO nguNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Niman desde ijcuacon, Judas quipiaya cuidado on cuajli tiempo para quinmactilis Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ipan on achtoj tonajli de on ilhuitl ijcuac nocuaya on pan yejhuan xquipia tlaxocolilistli, on nomachtijquej oquinisihuijquej Jesús niman oquijlijquej: ―¿Canon ticnequi ma timitzcuectlalilitij on tlacuajli yejhuan ticuas ipan in ilhuitl pascua? ");
INSERT INTO nguNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yejhua oquimijlij: ―Xhuiyan ne ipan on hueyican, ipan ichan se tlacatl yejhuan niquixmati, niman xquijlican: “On temachtijquetl quijtohua: Ye nisiu para nitlajyohuis, niman ica oncaj mochan nicuas on tlacuajli inhuan nonomachtijcahuan ipan in ilhuitl pascua.” ");
INSERT INTO nguNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","On nomachtijquej oquichijquej on tlen Jesús oquinnahuatij, niman otlatlajtlalijquej on tlacuajli para nocuas ipan on ilhuitl pascua. ");
INSERT INTO nguNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ijcuac otlayohuac, Jesús nemiya ne itech mesa inhuan on majtlactli huan ome nomachtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Niman chica tlacuayaj, oquimijlij: ―Ica tlen melahuac nemechijlia, ica semej nemejhuamej nechtemactilis. ");
INSERT INTO nguNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ijcuac yejhuamej ijcon ocacquej, sanoyej onajmanquej, niman quemaj cada sesentemej opeu quitlajtoltiaj: ―NoTeco, ¿tlen manin nejhua? ");
INSERT INTO nguNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Niman Jesús oquimijlij: ―On yejhuan nohuan tlapalohua ipan noplato, yejhua nechtemactilis. ");
INSERT INTO nguNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nejhua yejhuan oninochiu Tlacatl nimiquis quen quijtohua on Yectlajcuilojli, pero ¡lástima para on tlacatl yejhuan nechtemactilis! Más cuajli yesquia tla xqueman tlacatisquia. ");
INSERT INTO nguNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Quemaj otlajtoj Judas, on yejhuan quitemactilis, niman oquijlij: ―Temachtijquetl, ¿tlen manin nejhua? Jesús oquijlij: ―Quemaj. Melahuac on tlen yotiquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chica tlacuajticatcaj, Jesús ocontilan on pan, niman oquimacac tlaxtlahuijli Dios. Ijcuac yoquitlatlapan, oquinmacac on inomachtijcahuan, niman ijquin oquimijlij: ―Nochimej nemejhuamej xcuacan yejhua in pan. In pan quixnescayotia notlalnacayo. ");
INSERT INTO nguNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Quemaj ocontilan on copa, oquimacac tlaxtlahuijli Dios, niman oquimpanoltilij on inomachtijcahuan. Yejhua ijquin oquimijlij: ―Nochimej nemejhuamej xconican yejhua in. ");
INSERT INTO nguNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yejhua in tlen aman nenconisquej ica in copa quixnescayotia noyesyo yejhuan ica notzimpehualtia on yencuic pacto, niman in noyesyo toyahuis para miyequej tlapojpolhuilos intlajtlacol. ");
INSERT INTO nguNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Niman no nemechijlia ica aman tzimpehua ica xoc niconis iyayo in uvas, yej hasta ipan on tonajli ijcuac nemohuan niconis on yencuic iyayo uvas ne campa toTajtzin tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Niman ijcuac yoquinocuicatijquej se tlacuicajli, oyajquej ne ipan on tepetl itoca Olivos. ");
INSERT INTO nguNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Niman ompa Jesús oquimijlij: ―Ipan in tlayohua, nochimej nemejhuamej nennechtlalcahuisquej, pampa on Yectlajcuilojli ijquin quijtohua: “Nicmictis on tlajpixqui, niman on borregos nopojpolosquej.” ");
INSERT INTO nguNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero ijcuac nejhua yoniyoliu niman yoninoquetzteu ne ipan notlalcon, nias ne Galilea nemoyecapan. ");
INSERT INTO nguNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ijcuacon Pedro oquinanquilij: ―Masqui nochimej mitztlalcahuisquej, nejhua ca. ");
INSERT INTO nguNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Niman Jesús oquijlij: ―Ica tlen melahuac nimitzijlia, ica ipan sa no in tlayohua, ijcuac xe tzajtzi on caxtil, tejhua tiquijtos yexpa ica xtinechixmati. ");
INSERT INTO nguNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro oquijlij: ―Masqui hasta mohuan nimiquis, nejhua xnimitznenequis. Niman nochimej on nomachtijquej sa no ijqui oquijtojquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Quemaj Jesús oajsic ihuan on inomachtijcahuan campa itoca Getsemaní. Niman sequimej inomachtijcahuan ijquin oquimijlij: ―Chica nicchihua oración, nican xmotlajtlalican. ");
INSERT INTO nguNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Quemaj Jesús más neca ocuicac Pedro niman on omemej iconehuan Zebedeo, niman opeu sanoyej najmana niman noyolcocohua. ");
INSERT INTO nguNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Quemaj oquimijlij: ―Sanoyej ninajmana. Machixti niajmancamiquis. Nemejhuamej nican xmocahuacan, niman xtlachixtiacan. ");
INSERT INTO nguNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Quemaj Jesús oyaj achijtzin más tlayecapan niman, ijcuac onotlacuenquetz niman oquitlalij ixayac ipan tlajli, oquichiu oración itech Dios, niman oquijlij: ―NoTajtzin, tla huelisquia, xnechcahuili ma ca niquijyohuis yejhua in tlajyohuilistli, pero ma ca ma nochihua quen nejhua nicnequi, yej ma nochihua quen tejhua ticnequi. ");
INSERT INTO nguNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Quemaj oyaj ne campa nemiyaj on yeyimej inomachtijcahuan, niman oquinnextito cochtoquej. Niman oquijlij Pedro: ―¿Nemejhuamej nion se hora xnenhuelij nohuan nentlachixtoquej? ");
INSERT INTO nguNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xtlachixtiacan niman xchihuacan oración para xmechtlatlatas on diablo. Melahuac, tej, on nemoespíritu quinequi quichihuas cuajli, pero nemonacayo xcojtic. ");
INSERT INTO nguNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ica ocpa oyaj, niman ijquin oquichiu oración: ―NoTajtzin, tla xhuelis para tejhua ticchihuas para ma ca niquijyohuis in tlajyohuilistli, tla ijcon ma nochihua tlen tejhua ticnequi. ");
INSERT INTO nguNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Niman ijcuac ocsejpa oyaj itech inomachtijcahuan, ocsejpa oquinnextito cochij, pampa sanoyej ocochisnequej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yejhua xoquinnotz, yej oyaj para ica yexpa oquichiu oración, niman sa no yejhua tlajtojli oquijtoto. ");
INSERT INTO nguNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Quemaj oyaj ne campa nemiyaj on inomachtijcahuan, niman oquimijlij: ―¿Hasta aman nencochij niman nenmosehuitoquej? Yoyejcoc on hora ijcuac nechtemactilisquej nejhua yejhuan oninochiu Tlacatl ipan inmahuan on tlajtlacojquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Xmotelquetzacan. Tiahuij. Ye huajlau on yejhuan nechtemactilis. ");
INSERT INTO nguNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús oc tlajtojticatca ijcuac oyejcoc Judas, on yejhuan inhuan on majtlactli huan ome nomachtijquej tlapohuajli catca. Niman yejhua cuajhuicaya sanoyej miyec tlacatl yejhuan cuajquiyaj inespadas, niman sequimej cuajquiyaj cojtin. Yejhuamej huajlayaj ican intlanahuatil on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Niman Judas, on yejhuan quitemactiliaya Jesús, ijquin oquimijlijca on tlacamej: ―On yejhuan nictencuas, yejhua Jesús. Xcajsican. In, tej, yejhua señal oquinmacac Judas on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Quemaj Judas nimantzin oquinisihuij Jesús, niman oquijlij: ―¡Yahuilij, temachtijquetl! Niman oquitencuaj. ");
INSERT INTO nguNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús oquijlij: ―Notetlajsojcau, ¿tlinon ica tihuajlau? Quemaj on tlacamej oquinisihuijquej Jesús, niman ocajsiquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero semej on yejhuan nemiyaj ihuan Jesús oquixicopintiaj iespada, niman oquinacastzontec se tlacatl itlaquehual on más hueyi intlayecancau on tiopixquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ijcuacon Jesús oquijlij: ―Xquejehua moespada campa oticxicopin, pampa nochimej yejhuan temictiaj ican espada, no yejhua ica miquisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tlen xticmati ica nejhua nihuelisquia nictlajtlanilisquia noTajtzin más de majtlactli huan ome tlatecpantli iilhuicactequitcahuan, niman yejhua amantzin nechinhuajtitlanilisquia? ");
INSERT INTO nguNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero tla ijcon nochihuas, ¿quen ijqui nochihuas on tlen quijtohua on Yectlajcuilojli campa quijtohua ica ye ijqui oncaj para ijquin nochihuas? ");
INSERT INTO nguNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Quemaj Jesús oquimijlij on tlacamej: ―¿Nemejhuamej onenhualajquej ican espadas niman cojtin para nennechajsisquej quen yacaj nitlachtequetl yesquia? Nejhua mojmostla nemohuan ninotlaliaya para nemechmachtiaya ne ipan ihueyitiopan Dios, niman xqueman onennechajsiquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero nochi yejhua in nochihua para tenquisa on tlen oquijtojquej on tiotlajtojquej ipan on Yectlajcuilojli. Quemaj nochimej on nomachtijquej ontlatlacsaquej, niman sa iselti ocajtejquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","On yejhuan ocajsiquej Jesús ocuicaquej itech Caifás, on yejhuan más hueyi intlayecancau on tiopixquej. Ompa on temachtijquej ican tlanahuatijli niman on tlajmatquej san secan nemiyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pero Pedro san huejca oquitocac hasta queman oajsic ne iquiahuac on cajli yejhuan ical on yejhuan más hueyi tlayecanquetl intech on tiopixquej. Ijcuac ompa ocalac, onotlalij inhuan on policías yejhuan tlajpiaj ipan ihueyi tiopan Dios para quitas quen ijqui tlamis on tlen nochijticatca. ");
INSERT INTO nguNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Intlayecancahuan on tiopixquej, niman nochimej on tetlacanojnotzquej quitejtemohuayaj quen ijqui quiteixpanhuisquej Jesús para ijqui huelis quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero masqui miyequej tlacajcayajquej teixpantiliquej oyajquej niman oquijtojquej miyec tlen xmelahuac itechica Jesús, xohuel oquitlajtlacolmacaquej. Pero quemaj oyajquej omemej xcuajcualtin teixpantiliquej ");
INSERT INTO nguNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yejhuan oquijtojquej: ―Yejhua in tlacatl oquijtoj: “Nejhua huelis nicxoxotonis ihueyi tiopan Dios, niman ipan yeyi tonajli nitlamis ocsejpa nicchijchihuas.” ");
INSERT INTO nguNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Quemaj on más hueyixticaj tlayecanquetl intech on tiopixquej ohuajnotelquetz, niman oquijlij Jesús: ―¿Xitlaj ica titlananquilis? ¿Tlinon in quiteixpantilijtoquej yejhuamej in moca tejhua? ");
INSERT INTO nguNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús xonahuat. Quemaj ocsejpa on más hueyixticaj tlayecanquetl intech on tiopixquej oquijlij: ―Ican itocatzin Dios yejhuan nochipa nemi, xtechijli ican tlajtolpalehuilistli tla tejhua tiCristo, on iConeu Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús oquijlij: ―Quemaj, melahuac on tlen otiquijtoj. Niman no nemechijlia ica nennechitasquej nejhua yejhuan oninochiu Tlacatl, ninotlalis iyecmacopa Dios yejhuan quipia nochi poder. Niman no nennechitasquej nihuajlas ipan on moxtli yejhuan ne ilhuicac quisticaj. ");
INSERT INTO nguNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ijcuacon on más hueyi tlayecanquetl intech on tiopixquej sanoyej ocualan niman onotlaquencocotontiaj, niman oquijtoj: ―Yejhua in tlacatl yocuijhuicaltij Dios ican itlajtol. Tej, ¿tlinon para tiquinnequij más teixpantiliquej? Nemejhuamej yonencaquej quen yocuijhuicaltij Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Quen nenquinemiliaj? Yejhuamej oquijtojquej: ―Yejhua tlajtlacolej, niman nonequi miquis. ");
INSERT INTO nguNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Quemaj oquixayacachijchatiajquej, niman oquihuihuitequej. Niman sequimej oquixayacatetlatzinijquej, ");
INSERT INTO nguNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","niman oquijlijquej: ―Xtlajto, tiotlajtojquetl. Tejhua Cristo, xtechijli aquinon omitzmailij. ");
INSERT INTO nguNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro yehuaticatca ne quiahuac, niman se sihuatl tequichihuilijquetl oquinisihuij niman oquijlij: ―Tejhua no tiquistinemiya ihuan Jesús, on yejhuan hualehua ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Niman Pedro imixpan nochimej oquinenec, niman oquijtoj: ―Nejhua xnicmati on tlen tiquijtohua. ");
INSERT INTO nguNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro ye yajtiaya itechica on tlatzacuilyotl ijcuac ocse sihuatl tequichihuilijquetl oquitac. Niman on sihuatl oquimijlij on yejhuan ompa nemiyaj: ―Yejhua in tlacatl no quistinemiya ihuan Jesús on yejhuan hualehua ne Nazaret. ");
INSERT INTO nguNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Niman Pedro ocsejpa oquinenec niman onocalactij ican itlajtol. Oquijtoj: ―Nemechyolmelajcaila ica nejhua xniquixmati yejhua on tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Achijtzin más saquin, on yejhuan ompa nemiyaj oquinisihuijquej Pedro niman oquijlijquej: ―Melahuac, tejhua no tehuan titlapoajli, pampa tixmachyoj hasta ica titlajtlajtohua. ");
INSERT INTO nguNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ijcuacon Pedro oquijtoj ican itlajtolpalehuilis: ―¡Ma nimiqui tla xniquijtohua on tlen melahuac! Nejhua xniquixmati yejhua on tlacatl. Quemaj nimantzin otzajtzic se caxtil. ");
INSERT INTO nguNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ijcuac Pedro ocac ica otzajtzic on caxtil, oquelnamic on tlin Jesús oquijlijca: “Ijcuac xe tzajtzi on caxtil, tejhua yexpa tinechnenequis.” Niman quemaj Pedro oquis ompa niman sanoyej oajmancachocac. ");
INSERT INTO nguNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ijcuac yotlanes, nochimej intlayecancahuan on tiopixquej niman on tlajtlajmatquej intech hebreos oquinojlijquej quen ijqui quimictisquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Quemaj ijcuac yoquisalojquej Jesús, ocuicaquej niman oquitemactilitoj ne itech on gobernador Poncio Pilato. ");
INSERT INTO nguNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ijcuac Judas, on yejhuan oquitemactilij Jesús, oquitac ica Jesús yoquitlajtlacoltijquej para miquis, onoyolpatlac niman on sempoajli huan majtlactli piezas de tomin tlachijchiutin ican plata oquincuepilij intlayecancahuan on tiopixquej niman on tlajtlajmatquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Oquimijlij: ―Nejhua yonitlajtlacoj pampa yonictemactilij se tlacatl yolchipahuac para ma quimictican. Pero yejhuamej oquijlijquej: ―Niman aman, ¿tlinon totequiu tejhuamej? ¡On, tejhua ompa xcontili quen ticchihuas! ");
INSERT INTO nguNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ijcuacon Judas oconxinij on tomin ne ijtic on hueyi tiopan, niman quemaj oyaj onoquechmictito. ");
INSERT INTO nguNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Intlayecancahuan on tiopixquej ocajcocuquej on tomin, niman oquijtojquej: ―On tlanahuatijli xtechcahuilia tictlalisquej in tomin ne ipan on caja campa nehua on huentomin, pampa in yejhua ica oquitlaxtlajquej imiquilis se tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Quemaj san secan onotlajtolmacaquej para yejhua ica on tomin cohuasquej se tlajli, yejhuan itoca Alfarero, campa quintocasquej on yejhuan xchanejquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yejhua ica, hasta aman ipan in tonajli, on tlajli itoca Yestlajli. ");
INSERT INTO nguNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Niman ijqui onochiu on tlen oquijtocaj on tiotlajtojquetl Jeremías: “Oquitilanquej on sempoajli huan majtlactli tomin de plata, niman ocojquej on tlajli itoca Alfarero, sa no ijqui quen onechnahuatij on toTeco.” On hebreos sa no ijqui on tomin oquijtojcaj para quitlaxtlahuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús ijcaticatca ne ixpan on gobernador. Niman on gobernador oquitlajtoltij: ―¿Tejhua tiinRey on hebreos? Jesús oquinanquilij: ―Quemaj. Ijqui quen tejhua tiquijtohua. ");
INSERT INTO nguNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pero ijcuac intlayecancahuan on tiopixquej niman on tlajtlajmatquej quiteixpanhuiyayaj, Jesús xitlaj ica otenanquilij. ");
INSERT INTO nguNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Niman on Pilato oquijlij: ―¿Xticaqui nochi on tlen ica mitzteixpanhuiyaj? ");
INSERT INTO nguNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús xitlaj ica oquinanquilij nion se tlajtojli. Yejhua ica on gobernador otlamojcaitac, niman xquimatiya tlinon quinemilis. ");
INSERT INTO nguNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cada xipan ipan on ilhuitl itoca pascua, on gobernador quinmacahuiliani on tlacamej se tlacatl yejhuan tzacuticaj yejhuan yejhuamej quitlajtlaniyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Niman ipan on tonaltin nemiya se yejhuan tzacuticatca itoca Barrabás yejhuan nochi tlacatl quixmatiya ica xcuajli tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yejhua ica, ijcuac on tlacamej onosentlalijquej, Pilato oquintlajtoltij: ―¿Aquinon nenquinequij ma nemechmacahuili: Barrabás, noso Jesús, on yejhuan no itoca Cristo? ");
INSERT INTO nguNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yejhua ijcon oquintlajtoltij pampa oquimat ica intlayecancahuan on tiopixquej san ican innexicol oquimactilijquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","No ijqui, ijcuac Pilato yehuaticatca ne ipan on silla campa quintlajtlacolmaca on yejhuan xcuajcualtin tlacamej, on isihuau otlanahuatij ijquin ma quijlitij: “Ma ca itlaj ica timocalactis ticchihuilis on yolchipahuac tlacatl, pampa in tlayohua sanoyej temojtij onictemic san ipampa.” ");
INSERT INTO nguNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero intlayecancahuan on tiopixquej niman on tlajtlajmatquej oquinyolchicajquej on tlacamej para ma tlajtlanican ma quimacahuacan Barrabás, niman Jesús ma quimictican. ");
INSERT INTO nguNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","On gobernador ocsejpa oquinnotz, niman oquintlajtoltij: ―¿Catlejhua de in omemej nenquinequij ma nemechmacahuili? Niman yejhuamej oquijtojquej: ―Barrabás. ");
INSERT INTO nguNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato oquintlajtoltij: ―¿Niman tlinon nicchihuas ihuan Jesús, yejhuan no itoca Cristo? Nochimej oquijtojquej: ―¡Xmajmasohualti ipan cojnepanojli! ");
INSERT INTO nguNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Quemaj Pilato oquimijlij: ―¿Tlinon, tej, xcuajli oquichiu? Pero yejhuamej más chicahuac ocsejpa otzajtziquej: ―¡Xmajmasohualti ipan cojnepanojli! ");
INSERT INTO nguNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ijcuac Pilato oquitac ica xhuelis quimanahuis Jesús, yej más najcomanayaj on tlacamej, otlanahuatij ma cuilitij atl. Niman quemaj onomajtequij imixpan nochimej on tlacamej, niman oquimijlij: ―Nejhua xnicpias tlajtlacojli tla miquis in yolchipahuac tlacatl. Ompa xcontilican. ");
INSERT INTO nguNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Niman nochimej on tlacamej oquijtojquej: ―¡Tejhuamej niman toconehuan titotlajtlacolmacasquej yejhua ica on imiquilis! ");
INSERT INTO nguNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Quemaj Pilato oquinmacahuilij Barrabás, niman otlanahuatij ma quitlatzhuitequican Jesús, niman oquitemacac para ma quimajmasohualtican ipan cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Quemaj isoldados on gobernador ocuicaquej Jesús ne ipan palacio, niman nochi on quech soldado ompa nemiya oquiyejyehualojquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Quemaj Jesús oquixtilijquej itlaquen, niman oquitlaliltijquej se tlaquentli morado. ");
INSERT INTO nguNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Niman no oquimaniltijquej se huitzcorona, niman oquimacuitijquej se acatl ipan iyecma. Quemaj ixpan onotlacuenquetzquej niman ica huetzcayaj. Quijliayaj: ―¡Cuajli xnemi tejhua Rey intech on hebreos! ");
INSERT INTO nguNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","No ijqui quichijchayaj, niman cuiliayaj on cojtli yejhuan oquimacuitijquej, niman quimailiayaj ipan itzontecon. ");
INSERT INTO nguNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ijcuac ica yonahuiltijquej, oquixtilijquej on tlaquentli morado, niman oquitlaliltijquej on yejhuan yejhua itlaquen. Niman quemaj ocuicaquej para quimajmasohualtisquej ipan on cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ijcuac quistiayaj ipan on hueyican, oquinamiquej se tlacatl itoca Simón yejhuan chantiya ne Cirene. Niman on soldados oquichihualtijquej para ma quitquili icojnepanol Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Niman ijcuac oajsiquej ne campa itoca Gólgota, yejhuan quijtosnequi “Micatzontecomatlan”, ");
INSERT INTO nguNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jesús oquimacaquej para ma coni on vino tlanelyoj ihuan on tlen chichic itoca hiel. Pero ijcuac yejhua oquimat ican icamac, xoquinec oconic. ");
INSERT INTO nguNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ijcuac yoquimajmasohualtijquej ipan on cojnepanojli, on soldados onotlatlanquej para quitasquej cada se tlinon quitquis de yejhua on itlaquen Jesús. Ijquin onochiu on tlen oquijtoj on tiotlajtojquetl: “Onotlatlanquej ican suertes para se oquinoyaxcatij notlaquen.” ");
INSERT INTO nguNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Quemaj onotlajtlalijquej itech Jesús para oquitlajpixquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Niman ne ipan on cojnepanojli campa icuapan ica Jesús, oquijcuiloltlalijquej tlica oquimictijquej. Niman on tlajcuilojli quijtohuaya: “In yejhua Jesús, inRey on hebreos.” ");
INSERT INTO nguNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","No ijqui ihuan Jesús oquinmajmasohualtijquej impan cojnepanoltin omemej tlachtequej. Se oquimajmasohualtijquej iyecmacopa niman ocse iopochmacopa. ");
INSERT INTO nguNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Niman on yejhuan ompa quipanahuiyayaj cuijhuicaltiayaj, niman nocuahuihuixohuayaj, pampa sa ica nahuiltiayaj. ");
INSERT INTO nguNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Niman quijliayaj: ―Tejhua yejhuan ticxoxotonis ihueyi tiopan Dios niman ipan yeyi tonajli ocsejpa tlamis ticchijchihuas, xmomaquixti sa no tejhua. Tla melahuac tiiConeu Dios, xhuajtemo ipan on cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Niman intlayecancahuan on tiopixquej niman on temachtijquej ican tlanahuatijli, inhuan on fariseos niman on tlajtlajmatquej no ijqui ica huetzcayaj, niman yejhuamej quinojlayaj: ");
INSERT INTO nguNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ocsequimej oquinmaquixtij, pero sa no yejhua xhueli nomaquixtia. Tla melahuac yejhua inRey on hebreos, ma huajtemo ne ipan on cojnepanojli niman ticneltocasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yejhua notenehua yoquitlalij iyojlo itech Dios. Aman, tej, ma Dios quimaquixti tla melahuac quitlajsojtla, pampa yejhua oquijtoj: “Nejhua niiConeu Dios.” ");
INSERT INTO nguNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Niman hasta on tlachtequej yejhuan no oquinmajmasohualtijquej impan cojnepanoltin cuijhuicaltiayaj Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Quemaj ijcuac oajsic tlacualispan, otlayohuatiac nochihuiyan, niman tlayohuatoc catca hasta ijqui oajsic ipan yeyi hora ica tiotlac. ");
INSERT INTO nguNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Niman canaj ipan on hora, Jesús chicahuac otzajtzic: ―Elí, Elí, ¿lama sabactani? ―yejhuan quijtosnequi: noDios, noDios, ¿tlica tinechtlalcahuiya? ");
INSERT INTO nguNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sequimej yejhuan ompa nemiyaj ocacquej, niman ijquin oquijtojquej: ―Yejhua in tlacatl quinotza on tiotlajtojquetl Elías. ");
INSERT INTO nguNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Quemaj nimantzin semej yejhuamej onotlalojtiquis, ocuito on quen itlaj tlaquentli momoxtic itoca esponja, niman oquipolactij ipan on vinagre. Quemaj ocontlalij icuapan se acatl niman ocontlalij itech iten Jesús para ma quipachichina. ");
INSERT INTO nguNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero on ocsequimej oquijlijquej: ―¡Ma ca! Yej xcahua. Tiquitasquej tla huajlas Elías niman cuajmanahuis. ");
INSERT INTO nguNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Quemaj Jesús ocsejpa otzajtzic chicahuac, niman ijcuacon ohuajnotlamilij. ");
INSERT INTO nguNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Quemaj nimantzin on tlatzacuililtlaquentli yejhuan pilcaya ne ijtic on hueyi tiopan ohuajtlajcotecoton tlacpac hasta tlatzintlan. No otlalolin niman on temej otlajtlapanquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","On tlalcontin otlapojquej, niman miyequej on mimiquej yejhuan Dios iyaxcahuan oyoliuquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Niman ijcuac Jesús oyoliu niman onoquetzteu, on iyaxcahuan Dios oquisquej ijtic intlalcon, niman oyajquej ne ipan on yectiticaj hueyican itoca Jerusalén campa miyec tlacatl oquintac. ");
INSERT INTO nguNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ijcuac on capitán niman on soldados, yejhuan ompa inhuan quitlajpiayaj Jesús, oquimatquej tlalolinticaj niman oquitaquej ocsequi tlajtlamach nochijticaj, sanoyej onomojtijquej, niman oquijtojquej: ―In tlacatl melahuac iConeu catca Dios. ");
INSERT INTO nguNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","San huejcatzin nemiyaj miyequej sihuamej yejhuan ocuajhuicaquej Jesús de ne Galilea hasta Jerusalén para oquipalehuijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","María yejhuan hualehua ne ipan on hueyican itoca Magdala, María on yejhuan innan Jacobo niman José, niman innan on iconehuan Zebedeo ompa nemiyaj inhuan ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ijcuac ye tlayohuatitiaya, ohuajlaj se tlacatl rico itoca José. Yejhuan hualehuaya ipan on pueblo itoca Arimatea. Yejhua no inomachtijcau catca Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Oyaj itech Pilato, niman oquitlajtlanilij itlalnacayo Jesús. Niman Pilato otlanahuatij ma quimacacan. ");
INSERT INTO nguNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José oquitemohuij itlalnacayo Jesús, niman oquitejcuix ican se tlaquentli istac yejhuan patioj niman chipahuac. ");
INSERT INTO nguNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Quemaj ocahuato ipan se yencuic tlalcontli yejhuan oquichijchiu ipan se techinantli. Niman quemaj ocuejcueptiaj se tetl sanoyej hueyi para oquitentzacu. Niman ijcuac yoquitentzacu on tlalcontli, oyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Niman María yejhuan hualehua Magdala ihuan on ocse María onotlajtlalijquej ixpan on tlalcontli. ");
INSERT INTO nguNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Huajmostla, ipan on tonajli ijcuac on hebreos nosehuiaj, intlayecancahuan on tiopixquej niman on fariseos oyajquej, oquitatoj Pilato, ");
INSERT INTO nguNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","niman oquijlijquej: ―Señor, tejhuamej otiquelnamiquej ijcuac on tlacajcayajquetl oc nemiya, oquijtoj ica más saquin ipan yeyi tonajli yolihuis niman noquetztehuas ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yejhua ica, tejhuamej ticnequij xtlanahuati ma cuajli quitlajpiatij on tlalcontli hasta ma ajsi on yeyi tonajli para on inomachtijcahuan ma ca cualichtequisquej on itlalnacayo, niman quemaj quimijlisquej on tlacamej: “Aman yoyoliu niman yonoquetzteu ipan itlalcon.” Tla ijcon nochihuas, más temojtij onyas tlacajcayahualistli xquen ijcuac oquijtoj ica ijcon quichihuas. ");
INSERT INTO nguNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato oquimijlij: ―Ompa on nenquimpiaj quesquimej soldados. Xhuiyan, niman hasta campa nenhuelisquej cuajli xtlajpiacan on tlalcontli. ");
INSERT INTO nguNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Quemaj oyajquej niman oquitlalijquej se sello ipan on tetl yejhuan ica tentzacuticatca para quitasquej tla yacaj calaqui ne ijtic on tlalcontli. Niman quemaj ompa oquincajquej on soldados para ma quitlajpiacan. ");
INSERT INTO nguNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ijcuac opanoc on tonajli ica nosehuiaj on hebreos niman yohuajtlanes ipan on tonajli domingo, María yejhuan hualehua ne Magdala ihuan on ocse María oyajquej oquitatoj on tlalcontli. ");
INSERT INTO nguNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Niman nimantzin ohuajtlalolin, pampa se ilhuicactequitquetl, yejhuan toTeco ocuajtitlan, ohuajtemoc ne ilhuicac. Ijcuac oyejcoc ne itech on tlalcontli, oquejcuanij on tetl yejhuan ica tentzacuticatca niman ipan onotlalij. ");
INSERT INTO nguNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yejhua sanoyej petlanqui catca quen itlaj tlapetlanajli, niman itlaquen istac catca quen itlaj nieve. ");
INSERT INTO nguNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Niman ijcuac on soldados oquitaquej on ilhuicactequitquetl, onomojtijquej, ocuecuetlacaquej niman onocajquej quen omijmiquej. ");
INSERT INTO nguNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Quemaj on ilhuicactequitquetl oquimijlij on sihuamej: ―Ma ca xmomojtican. Nejhua nicmatzticaj ica onenquitacoj Jesús yejhuan oquimajmasohualtijquej ipan on cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yejhua xnican nemi. Yejhua yoyoliu niman yonoquetzteu ipan itlalcon quen oquijtojca quichihuas. Xhuajlacan, xquitacan campa oquitecacaj. ");
INSERT INTO nguNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nimantzin xhuiyan, niman xquimijlican on inomachtijcahuan: “On yejhuan omic, aman yoyoliu niman yonoquetzteu ipan itlalcon. Aman, tej, yejhua nemoyecapan yas ne Galilea niman ompa nenquitasquej.” Aman yonemechijlij on tlen nonequi nemechijlis. ");
INSERT INTO nguNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Niman on sihuamej nimantzin onejcuanijquej ne itech on tlalcontli ican nemojtijli niman no ican miyec paquilistli. Yejhuamej onotlajtlalojquej para oquinmachiltitoj on nomachtijquej on tlen oquimijlij on ilhuicactequitquetl. ");
INSERT INTO nguNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Niman chica yejhuamej on sihuamej yayaj, Jesús oquinnotitij niman oquintlajpaloj. Niman yejhuamej oquinisihuijquej, niman oquinapalojquej icxihuan, niman oquimahuistilijquej. ");
INSERT INTO nguNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yejhua oquimijlij: ―Ma ca xmomojtican. Xhuiyan, xquinmachiltitij nocnihuan ma huiyan ne Galilea, niman ompa nechitasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chica yejhuamej on sihuamej yayaj, sequimej soldados, yejhuan quitlajpiayaj on tlalcontli, oyajquej ne ipan on hueyican, niman oquintlajtlajtohuilijquej intlayecancahuan on tiopixquej nochi on tlen onochiu. ");
INSERT INTO nguNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yejhuamej on tiopixquej oyajquej oquinnotzatoj on tlajtlajmatquej. Niman ijcuac san secan yoquinojlijquej quen ijqui quiyanasquej on tlen melahuac ica Jesús yoyoliu niman yonoquetzteu ipan itlalcon, yejhuamej oquinmacaquej miyec tomin on soldados. ");
INSERT INTO nguNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Niman ijquin oquimijlijquej: ―Xquimijlican on tlacamej ica ijcuac tlayohua, chica nemejhuamej nencochticatcaj, on inomachtijcahuan ohualajquej niman oquichtequej itlalnacayo. ");
INSERT INTO nguNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Niman tla on gobernador caquis, tejhuamej ticyoltlalisquej niman ticchihuasquej para ma ca itlaj mechchihuilisquej. ");
INSERT INTO nguNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Quemaj on soldados oquiselijquej on tomin, niman oyajquej oquichihuatoj quen oquimijlijquej. Niman desde ipan on tonajli hasta aman ijqui quitetlajtlajtohuiliaj on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ijcon, tej, on majtlactli huan se nomachtijquej oyajquej ne Galilea ipan on tepetl campa Jesús oquimijlij para yasquej. ");
INSERT INTO nguNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Niman ijcuac yejhuamej oquitaquej Jesús, oquimahuistilijquej. Pero sequimej ometlamatiyaj. ");
INSERT INTO nguNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Quemaj Jesús oquinnisihuij, niman oquimijlij: ―Nejhua yonechmacaquej nochi tequihuajyotl para nitlamandarohua ne ilhuicac niman nican ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yejhua ica, tej, xhuiyan imanyan nochi on tlalticpactli, niman xquinmachtican nochimej on tlacamej para yejhuamej no nonomachtijcahuan yesquej. Xquincuatequican ican itoca noTajtzin, niman ican itoca on iConetzin, niman ican itocatzin on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Niman xquinmachtican para ma quitlacamatican nochi tlen yonemechnahuatij. Niman xmatican ica nejhua mojmostla nemohuan ninemi hasta ijcuac tlatlalpolihuis. Ma ijqui nochihua.");
INSERT INTO nguNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ijquin otzimpeu in cuajli tlajtojli ica Jesucristo yejhua iConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","On tiotlajtojquetl Isaías oquijcuilojca on tlinon Dios oquijlijca iconeu. Dios oquijlij: Xcaqui in. Nictitlanis se notenojnotzcau moyecapan. Yejhua quintlalilis inyojlo melajqui para mitzselisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","On notlaquehual tzajtzi ipan se tlapatlaco. Quimijlia on tojlamej tlacamej: “Xyectlalican nemoyojlo pampa ye huajlau toTeco. Xmejmelahuacan nemonemilis ijcon quen on tlacamej cueltlaliaj niman quimejmelahuaj se ojtli ijcuac huajlau se tlacatl yejhuan hueyixticaj.” ");
INSERT INTO nguNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Juan, on tlacuatequijquetl, tlacuatequiaya ne ipan on tlapatlaco, niman quinmachtiayaj on tlacamej ma noyolcuepacan niman ma nocuatequican, niman Dios quintlapojpolhuis intlajtlacol. ");
INSERT INTO nguNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Huajlayaj cuajcaquiyaj nochimej on chanejquej ipan on hueyican Jerusalén niman on yejhuan nochihuiyan chantiyaj ne Judea. Niman ijcuac yejhuamej yonoyolcuitijquej, Juan quincuatequiayaj ne ipan on atentli itoca Jordán. ");
INSERT INTO nguNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan notlaquentiaya ican itojmiyo on yolqui itoca camello, niman notlajcosalohuaya ican se ilpicatl tlachijchiutli ican cuetlaxtli. Quincuaya on yolcatzitzintin yejhuan quen chapolimej, niman no coniya on cojnecutli. ");
INSERT INTO nguNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Niman quinmachtiaya ijquin: ―Huajlau ocse, yejhuan quipia más poder xquen nejhua. Nejhua nion achijtzin xnechmelahua nictojtomas icacmecayo. ");
INSERT INTO nguNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nejhua melahuac, tej, yonemechcuatequij ican atl, pero yejhua mechcuatequis ican Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ipan on tonaltin Jesús oquis Nazaret de Galilea, niman Juan ocuatequij ne ipan on atentli itoca Jordán. ");
INSERT INTO nguNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Niman ijcuac Jesús ohuajquis ne ijtic on atl, oquitac on ilhuicac otlapou, niman on Espíritu Santo huajtemohuaya quen itlaj paloma ipan. ");
INSERT INTO nguNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Niman ohualeu itlajtol toTajtzin ne ilhuicac. Quijtohua: ―Tejhua tinotlajsojcaConetzin, niman sanoyej moca nipacticaj. ");
INSERT INTO nguNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Quemaj nimantzin on Espíritu Santo oquichihualtij Jesús ma huiya ne ipan on tlapatlaco. ");
INSERT INTO nguNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Niman Jesús ompa onen ompoajli tonaltin campa nemij on huejhueyi yolcamej yejhuan tecuanimej. Niman on diablo ompa oquitlatlatac Jesús para ma tlajtlaco. Quemaj ohualajquej on ilhuicactequitquej, niman ompa quipalehuiyayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Quemaj ijcuac Juan yocasiquej, Jesús oajsic ne Galilea campa quitemachtiaya on cuajli tlajtojli ica quen ijqui Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Quijtohuaya Jesús: ―Ye huajlau on tonajli ijcuac Dios tlamandaros. Xcajcahuacan ica nenquichihuaj on tlen xcuajli, niman xneltocacan on temachtilistli yejhuan quitemaca temaquixtilistli. ");
INSERT INTO nguNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Se tonajli ijcuac nejnentiaya ne itenco on mar itoca Galilea, Jesús ocomintac Simón niman icniu Andrés. Yejhuamej michajasiquej catcaj, niman conchapaniayaj inmatl ne ipan on atl. ");
INSERT INTO nguNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Niman Jesús oquimijlij: ―Nemejhuamej nenquintejtemohuaj michimej. Pero aman xhuajhuiyan nohuan, niman nenquintejtemosquej tlacamej para nenquinhuicasquej itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yejhuamej nimantzin ocajquej inmatlahuan, niman ihuan oyajquej. ");
INSERT INTO nguNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Quemaj Jesús onejnen achijtzin más, niman ocomintac omemej icniutin intoca catcaj Jacobo niman Juan. Yejhuamej iconehuan Zebedeo. Nemiyaj ipan se barco, niman quintlamanilijticatcaj on inmatlahuan. ");
INSERT INTO nguNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nimantzin ocominnotz para ma huajhuiyan ihuan, niman yejhuamej ocajtejquej intataj Zebedeo ne ipan on barco inhuan on itlaquehualhuan, niman oyajquej ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Niman oajsiquej ne ipan on pueblo itoca Capernaum. Ijcuac oyejcoc on tonajli sábado, yejhua on tonajli ijcuac on hebreos nosehuiaj, Jesús ocalac ne ipan intiopan on hebreos, niman ompa otemachtij. ");
INSERT INTO nguNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yejhua xtemachtiaya quen on temachtijquej ican itlanahuatil Dios, yej temachtiaya quen se yejhuan quipia tequihuajyotl. Yejhua ica on tlacamej sanoyej omojcatlachixquej. ");
INSERT INTO nguNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ne ipan intiopan on hebreos nemiya se tlacatl yejhuan quipiaya se xcuajli espíritu. Niman on tlacatl otzajtzic, ");
INSERT INTO nguNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","oquijlij: ―¿Tlinon ticchihuas tohuan, tejhua Jesús aquin otihualeu Nazaret? ¿Otihuajlaj para titechxoxotonico? Nejhua nimitzixmatzticaj, niman nicmatzticaj ica tejhua tiichipauConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús ocajhuac on xcuajli espíritu, niman oquijlij: ―¡Ma ca xnahuati, niman xquisa ijtic yejhua in tlacatl! ");
INSERT INTO nguNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Niman on xcuajli espíritu sanoyej chicahuac oquitzejtzeloj on tlacatl, niman otzajtzic chicahuac. Quemaj oquis. ");
INSERT INTO nguNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nochimej omojmojcatlachixquej, niman nochimej quinotlajtoltiayaj yejhuamej: ―¿Tlinon in? In nesi yencuic tlamachtijli. Ican itequihuajyo Dios in tlacatl tlamandarohua, niman hasta on xcuajcualtin espíritus quitlacamatij. ");
INSERT INTO nguNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nimantzin omachiyac ne imanyan Galilea tlinon oquichiu Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Quemaj Jesús oquis ne ipan intiopan on hebreos, niman oyaj ihuan Jacobo niman Juan ne inchan Simón niman Andrés. ");
INSERT INTO nguNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Niman imonan Simón ompa onoya ipan se tlapechtli. Yejhua quipiaya totonqui. Niman nimantzin oquijlijquej Jesús ica on imonan Pedro cualo. ");
INSERT INTO nguNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Niman quemaj Jesús oquinisihuij, ocontilan ipan ima, niman oquitelquetz. Nimantzin ocau on totonqui, niman quemaj opeu quintlacualtia. ");
INSERT INTO nguNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ijcuac yocalac tonajli, yejhuamej quinhuajhuicayaj nochimej on quech cualohuayaj, niman on yejhuan quipiayaj on xcuajcualtin espíritus. ");
INSERT INTO nguNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Niman nochimej on yejhuan chantiyaj ipan on hueyican onosentlalijquej ne quiahuatenco. ");
INSERT INTO nguNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Niman Jesús oquimpajtij miyequej on cocoxquej, on yejhuan cada se quipiaya ocse tlamantic cualolistin, niman miyequej oquinquixtilij on xcuajcualtin espíritus. Pero xquincahuiliaya para on xcuajcualtin espíritus ma tlajtocan, pampa yejhuamej quimatzticatcaj ica yejhua aquinon. ");
INSERT INTO nguNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Huajmostla huelipan, ijcuac oc tlayohuatoc catca, Jesús onocoteu, niman oquis ipan on pueblo, niman oyaj neca campaca xacaj nemi. Ompa oquichihuato oración. ");
INSERT INTO nguNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Más saquin, Simón niman on ocsequimej inomachtijcahuan Jesús oyajquej para oquitejtemotoj. ");
INSERT INTO nguNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ijcuac oquinextitoj, oquijlijquej: ―Miyec tlacatl mitztejtemohua. ");
INSERT INTO nguNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yejhua oquinnanquijlij: ―Tiahuij ocsecan pueblos campaca nisiu para ompa no nitemachtis, pampa yejhua ica onihuajlaj. ");
INSERT INTO nguNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Quemaj Jesús temachtijtinemiya ipan intiopan on hebreos nochihuiyan ne imanyan Galilea. No quinquixtiliaya on tlacamej xcuajcualtin espíritus. ");
INSERT INTO nguNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ohuajlaj se tlacatl itech Jesús yejhuan palaniya inacayo ican on cualolistli itoca lepra. Ixpan onotlacuenquetz niman oquiajmancatlajtlanilij. Oquijlij: ―Tla ticnequi, huelis tinechpajtis. ");
INSERT INTO nguNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Niman Jesús oquicnelij. Oquimatocac, niman oquijlij: ―Nicnequi. Aman xpajti. ");
INSERT INTO nguNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Niman ijcuac Jesús ijcon oquijtoj, on cualolistli nimantzin opopoliu ipan on tlacatl. Opajtic inacayo. ");
INSERT INTO nguNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jesús oquichicacanahuati, oquijlij: ―Xcaqui in. Ma ca yacaj itlaj xquijli, yej san xhuiya, niman xmoteititi ne itech on tiopixqui para mitzitas ica xoc ticualo. Niman pampa yotipajtic, xcuentlali on tlen Moisés otlanahuatij. Ijcon, tej, on tlacamej quitasquej ica tejhua yotipajtic. ");
INSERT INTO nguNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero on tlacatl oyaj niman opeu quitetlajtlajtohuilia nochihuiyan on tlen Jesús oquichihuilij. Yejhua ica Jesús xoc hueliya calaquiya neca ipan pueblos, yej sanecaj nemiya campaca tlapatlaco, niman on tlacamej huajlayaj itech de nochihuiyan pueblos. ");
INSERT INTO nguNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Quemaj ipan quesqui tonajli más saquin, ocsejpa Jesús oyejcoc ne Capernaum. Niman ocacquej ica yejhua nemiya ne techan. ");
INSERT INTO nguNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nimantzin onosentlalijtetzquej sanoyej tojlamej tlacamej hasta xoc onaquiyaj. Sanoyej oten on cajli, nion siquiera ne quiahuatenco xoc onaquiyaj. Yejhua quitemachtiaya on itlajtol toTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Niman quemaj oyejcoquej nahuimej tlacamej yejhuan cualajantiayaj se tlacatl yejhuan sepojtoc. ");
INSERT INTO nguNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Niman quemaj ica xohuelquej ocalaquej pampa sanoyej tojlan catca, yej oquitlejcoltijquej ne icuatipan on cajli. Ompa, tej, ocuatlapojquej on cajli ne imelacan Jesús. Niman quemaj ocuajtemoltijquej on sepojtoc ican se cojtlapechtli. ");
INSERT INTO nguNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ijcuac Jesús oquitac ica yejhuamej quineltocayaj ica yejhua hueli tepajtia, oquijlij on cocoxqui: ―Noconeu, motlajtlacolhuan yotlapojpolhuilojquej. ");
INSERT INTO nguNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pero ompa yejyehuaticatcaj sequimej temachtijquej ican itlanahuatil Dios. Ijquin yejhuamej quinemilijticatcaj ipan inyojlo: ");
INSERT INTO nguNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“In tlacatl, ¿tlica tlajtlajtohua ijquin? In tlacatl cuijhuicaltia Dios. Xacaj hueli quitetlapojpolhuilia on tlajtlacojli, yej san yejhua Dios.” ");
INSERT INTO nguNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero Jesús quimatzticatca ipan iyojlo tlinon yejhuamej quinemilijticatcaj, niman oquimijlij: ―¿Tlica ijcon nenquinemiliaj ipan nemoyojlo? ");
INSERT INTO nguNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Catlejhua más xtepopoloj niquijtos: “Motlajtlacolhuan yotlapojpolhuilojquej”, noso niquijtos: “Xmoquetztehua, xcajcocui motlapech niman xnejnemi”? ");
INSERT INTO nguNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aman cuajli nemechititis ica nejhua yejhuan oninochiu Tlacatl nicpia tequihuayotl ipan in tlalticpactli para nictetlapojpolhuilis on tlajtlacojli. Quemaj Jesús oquijlij on tlacatl yejhuan sepojtoc: ");
INSERT INTO nguNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Tejhua nimitzijlia: Xmoquetztehua, xcajcocui motlapech niman xhuiya mochan. ");
INSERT INTO nguNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Quemaj on yejhuan sepojtoya nimantzin onotelquetz, ocajcocu itlapech, niman quemaj imixpan nochimej ohuajquis. Yejhua ica nochimej sanoyej omojmojcatlachixquej, niman opeu cueyiliaj Dios. Quijtohuayaj: ―Xqueman tiquitayaj ijquin. ");
INSERT INTO nguNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Quemaj Jesús ocsejpa oyaj ne itenco on mar. Onosentlalij miyec tlacatl, niman oquinmachtij. ");
INSERT INTO nguNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ijcuac oquis ompa ipan iojhui, oquitac Leví iconeu Alfeo. Yejhua yehuaticatca ne campa tlacobrarohua ica on impuestos. Niman Jesús oquijlij: ―Xhuajla nohuan. Leví nimantzin ohuajnotelquetz niman oyaj ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Más saquin ijcuac Jesús tlacuajticatca ne ichan Leví, sequimej tlacamej yejhuan tlacobrarojquej ica on impuestos niman on ocsequimej yejhuan tlajtlacolejquej onosentlalijquej ihuan Jesús niman inomachtijcahuan ne ipan mesa. Ijcon onochiu pampa miyequej yayaj ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pero on temachtijquej ican itlanahuatil Dios niman on fariseos, ijcuac oquitaquej ica inhuan tlacuaya on tlacobrarojquej niman tlajtlacolejquej, oquimijlijquej on inomachtijcahuan Jesús: ―¿Tlica nemotemachtijcau tlacua niman coni inhuan on tlacobrarojquej niman on tlajtlacolejquej? ");
INSERT INTO nguNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús ocac tlinon oquijtojquej, niman oquimijlij: ―Para on yejhuan xcualoj xnonequij on tepajtijquetl, pero on yejhuan cualoj quemaj. Nejhua xonihuajlaj para niquinnotzas on yejhuan yolmelajquej, yej para niquinnotzas on yejhuan tlajtlacolejquej. ");
INSERT INTO nguNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Se tonajli, ijcuac on fariseos niman on inomachtijcahuan Juan nosahuayaj, sequimej tlacamej oyajquej itech Jesús, niman oquijlijquej: ―On innomachtijcahuan on fariseos niman inomachtijcahuan Juan nosahuaj. ¿Tlica on monomachtijcahuan xnosahuaj? ");
INSERT INTO nguNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús oquimijlij: ―¿Tlen huelisquej nosahuasquej on yejhuan tlanotzaltin campa nonamictihua chica on montli ompa inhuan nemi? Ijcuac on montli ompa nemi tehuan, xhuelisquej nosahuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero yejcos on tonajli ijcuac nejhua yejhuan quen nimontli nechquixtisquej intech on notenotzcahuan. Niman ijcuacon quemaj yejhuamej nosahuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Xacaj quitlamanilia se tlaquentli ijsoltic ica on tlaquentli yejhuan yencuic, pampa on yejhuan yencuic tlaquentli tzolihui, niman más hueyica quicotona on tlaquentli ijsoltic. ");
INSERT INTO nguNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Niman no xacaj quitlalia on vino yencuic ipan on bolsas yejhuan tlachijchiutin ican on cuetlaxtin ijsoltiquej, pampa on vino posonis, niman on bolsas toponisquej, niman quemaj on vino ihuan on bolsas ixpolihuisquej. Yejhua ica xtlalican on vino yencuic ipan on bolsas yencuiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Se tonajli, yejhuan ijcuac on hebreos nosehuiaj, Jesús panotiaya inhuan on inomachtijcahuan neca campaca oncatca mijli. Niman on inomachtijcahuan opeu cojcopinaj on inyahuayo on mijli de trigo. ");
INSERT INTO nguNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Quemaj on fariseos oquijlijquej: ―Xquita. On monomachtijcahuan tequitij ipan in tonajli de nesehuijli. Totlanahuatil xtechcahuilia titequitisquej ipan on tonajli de nesehuijli. ");
INSERT INTO nguNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero Jesús oquimijlij: ―¿Nemejhuamej xqueman nenquimomachtianij on tlen oquichijca David ijcuac yejhua niman itehuicalhuan oapismiquej? ");
INSERT INTO nguNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yejhua ocalac ipan itiopan Dios ijcuac Abiatar yejhua on más hueyi intlayecancau catca intech yejhuamej on tiopixquej. Niman yejhua oquicuaj on pan yejhuan tlatiochiutli. Ijquin oquichiu masqui on itlanahuatil Moisés san quincahuiliaya on tiopixquej quicuayaj on pan. Niman David no oquinmacac on tlacamej yejhuan no ompa inhuan nemiya. ");
INSERT INTO nguNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Quemaj Jesús oquimijlij: ―On tonajli de nesehuijli Dios oquitlalij impampa on tlacamej. Xoquintlalij on tlacamej ipampa on tonajli de nesehuijli. ");
INSERT INTO nguNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yejhua ica nejhua yejhuan oninochiu Tlacatl nechmelahua para niquijtos tlinon cuajli para se quichihuas ipan on tonajli de nesehuijli. ");
INSERT INTO nguNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús ocalac ocsejpa ne ipan se tiopan. Niman ompa nemiya se tlacatl yejhuan quipiaya se ima huaqui. ");
INSERT INTO nguNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","No ompa nemiyaj sequimej yejhuan sa quipijpiayaj Jesús, para quitasquej tla quipajtis on tlacatl ipan on tonajli de nesehuijli. Ijcon oquichijquej para quipiasquej tlinon ica huelis quiteixpanhuisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús oquijlij on tlacatl yejhuan mahuaquiya, ma notelquetza ne tlajcotian. ");
INSERT INTO nguNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Quemaj oquintlajtoltij on tlacamej: ―¿Totlanahuatil tlinon techcahuilia ticchihuasquej ipan on tonajli de nesehuijli? ¿Techcahuilia ticchihuilisquej on tlen cuajli on tlacamej, noso on tlen xcuajli? ¿Techcahuilia ticmaquixtisquej on nemilistli, noso ticmictisquej? Pero yejhuamej xoquinanquilijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Quemaj Jesús oquintlahueltlajtlatac, niman sanoyej onajman sa ica on inyoltechicahualis. Niman oquijlij on tlacatl: ―Xmelahua moma. On tlacatl oquimelau ima niman opajtic. ");
INSERT INTO nguNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ijcuacon ohuajquisquej on fariseos, niman opejquej quinotlajtoltiaj inhuan on itetlajsojcahuan Herodes quen ijqui huelisquej quimictisquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús onejcuanij, niman oyaj ne itenco on mar inhuan inomachtijcahuan. Niman sanoyej miyec tlacatl yejhuan chanej ne Galilea oyajquej no. No ijqui oyajquej yejhuan chanejquej ne Judea, ");
INSERT INTO nguNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","niman ne hueycan Jerusalén, niman ne Idumea, niman ne iquisayan tonajli de on atentli Jordán, niman ne nisiu on hueyican Tiro niman on hueyican Sidón. Yejhuamej oyajquej para oquitatoj Jesús pampa ocacquej nochi tlinon quichihuaya. ");
INSERT INTO nguNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesús oquimijlij on inomachtijcahuan ma onya listo se barco campa huelis tlejcos, para ma ca quipitzmictisquej on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nemiyaj sanoyej tojlan tlacamej pampa oquimpajtij miyequej cocoxquej, niman yejhua ica nochimej yejhuan quipiayaj cualolistli quitelosnequiyaj para pajtisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Niman on tlacamej, yejhuan quipiayaj on xcuajcualtin espíritus notlajcaliyaj icxitlan Jesús, niman on xcuajcualtin espíritus chicahuac tzajtziyaj, quijtohuayaj: ―Tejhua tiiConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jesús oquinchicajcanahuatij ma ca quiteijlisquej aquin yejhua. ");
INSERT INTO nguNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Quemaj Jesús otlejcoc ne ipan se tepetl niman oquinhuajnotz san aquinomej yejhua oquinec. Niman yejhuamej oyajquej itech. ");
INSERT INTO nguNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Niman oquintlalij on majtlactli huan ome tlacamej ipan on tequitl para ma nemican ihuan, niman para quintitlanis ontemachtisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Niman oquinmacac poder para quimpajtisquej on cocoxquej, niman para quintequixtilisquej on xcuajcualtin espíritus. ");
INSERT INTO nguNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Oquitlalij Simón yejhuan no oquitocayotij Pedro. ");
INSERT INTO nguNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","No oquintlalij Jacobo iconeu Zebedeo, niman Juan yejhuan icniu Jacobo. Jesús oquintocayotij Boanerges yejhuan quijtosnequi tetlajtlahuelmej. ");
INSERT INTO nguNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","No ijqui oquintlalij Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo yejhuan iconeu Alfeo, Tadeo, Simón on yejhuan no tehuan catca ne intech on intoca cananistas, ");
INSERT INTO nguNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","niman Judas Iscariote yejhuan más saquin oquitemactilij Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Quemaj Jesús oyaj ne techan, niman ocsejpa onosentlalij miyec tlacatl, niman nion achijtzin xhueliyaj tlacuayaj Jesús niman inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ijcuac on quen quintaya oquimatquej, ohualajquej para cuicasquej, pampa yejhuamej cuitiayaj yotlamachilispoliu. ");
INSERT INTO nguNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yejhuamej on temachtijquej ican itlanahuatil Dios, yejhuan ohualejquej ne Jerusalén, quijtohuayaj: ―Jesús quipia on diablo itoca Beelzebú yejhuan tlayecanquetl intech nochimej on xcuajcualtin espíritus. Yejhua quimacaticaj Jesús on hueyilistli para quinquixtis on xcuajcualtin espíritus. ");
INSERT INTO nguNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Quemaj Jesús oquinnotz, niman oquimijlij: ―¿Quen ijqui huelis on diablo quixtis on xcuajcualtin espíritus tla sa no yejhua? ");
INSERT INTO nguNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tla se país noxexelos, niman pehuas nohuijsoquisquej sa no yejhuamej, on país xhuelis nemis. ");
INSERT INTO nguNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Niman no ijqui, tla se chanyotl noxexelos, niman pehuas nohuijsoquisquej sa no yejhuamej, on chanyotl xhuelis onyas. ");
INSERT INTO nguNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","No ijqui, tla on diablo noxelos intech on xcuajcualtin espíritus niman pehuas quinhuijsoquis, xoc huelisquej itlaj quichihuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’No ijqui, tla yacaj ichtequi quinequi calaquis ichan se tlacatl yejhuan cojtiticaj para quixtilis on tlinon quipia, achtoj ica oncaj quisalos on yejhuan cojtic tlacatl. Niman ijcuacon huelis quicuilis nochi on tlen quipia ipan ichan. ");
INSERT INTO nguNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Melahuac, tej, nemechijlia ica Dios huelis quintlapojpolhuis on tlacamej nochi intlajtlacol niman on tlahuijhuicaltilistli san catlejhua nochi quech ica tlahuijhuicaltihuaj. ");
INSERT INTO nguNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero tla se tlacatl cuijhuicaltis on Espíritu Santo, Dios xqueman quitlapojpolhuis, yej nochipa quipias itlajtlacol. ");
INSERT INTO nguNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ijcon oquijtoj pampa on temachtijquej ican itlanahuatil Dios quijtojticatca ica yejhua quipiaya se xcuajli espíritu. ");
INSERT INTO nguNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Quemaj ohualajquej inan niman icnihuan Jesús. Yejhuamej onocajquej ipan calle, niman otlatitlanquej ma quinotzatij Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","On tojlan yejhuan nemiyaj iyehualijcan Jesús ne calijtic, oquijlijquej: ―Monan niman mocnihuan nemij ipan calle, niman quinequij mitzitasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero yejhua oquinnanquilij, oquimijlij: ―¿Aquinon nonan niman nocnihuan? ");
INSERT INTO nguNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Quemaj yejhua ocomintac on yejhuan ompa nemiyaj iyehualijcan, niman quemaj oquijtoj: ―In yejhuamej nonan niman nocnihuan. ");
INSERT INTO nguNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nochi aquin quichihuas on tlen Dios quinequi, yejhua nocniu tlacatl, noso nocniu sihuatl, niman yejhua nonan. ");
INSERT INTO nguNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ocsejpa Jesús otemachtij ne itenco on mar. Ica sanoyej miyec tlacatl onosentlalij ne campa yejhua nemiya, Jesús otlejcoc ipan se barco yejhuan oncatca ipan on mar, niman onotlalij. On tlacamej nemiyaj ne itenco on mar. ");
INSERT INTO nguNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Niman yejhua quinmachtiaya miyec tlajtlamach ican ejemplos, niman ijquin quimijliaya: ");
INSERT INTO nguNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Xcaquican cuajli tlinon nemechilhuis. Sen tlacatl oyaj oquixinito on xinachtli de trigo. ");
INSERT INTO nguNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chica tocaya, sequi xinachtli oxinito ipan ojtli, niman on totomej ohuajlajquej niman oquicuajquej. ");
INSERT INTO nguNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ocsequi xinachtli oxinito ipan tepetlayoj campa xmás oncaj tlajli, niman on xinachtli nimantzin oixhuac, pampa xmás huejcatlan oncatcaj on tlajli campa oxin. ");
INSERT INTO nguNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero ijcuac oquis on tonaltzintli, ocoseu imilyo on trigo. Niman ica xhuejcatlan quipiaya inelhuayo, ohuajhuac. ");
INSERT INTO nguNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Niman ocsequi xinachtli oxinito intzajlan on huitzcojtin. On huitzcojtin saniman onoscaltijquej niman oquixomictijquej imilyo on trigo. Yejhua ica xotlac. ");
INSERT INTO nguNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero sequi xinachtli oxin ipan cuajli tlajli. Onoscaltij, niman sanoyej cuajli otlac. Sequi oquitlaquitij sempoajli huan majtlactli iteyo, niman sequi yepoajli iteyo, niman sequi se ciento. ");
INSERT INTO nguNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","No oquimijlij: ―Tla nemejhuamej nenquipiaj nemotlamachilis, xcajsicamatican on ejemplo. ");
INSERT INTO nguNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Niman quemaj saquin ijcuac Jesús sa iselti nemiya inhuan on inomachtijcahuan niman sa quesqui tlacatl, yejhuamej oquitlajtlanilijquej Jesús para ma quimijli tlinon quijtosnequi on ejemplos. ");
INSERT INTO nguNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Oquimijlij: ―Nemejhuamej Dios yomechcahuilij para nenquimatisquej on tlinon iyanticatca quen ijqui yejhua tlamandarohua. Pero on ocsequimej niquinmachtia san ican ejemplos ");
INSERT INTO nguNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","para masqui quicaquisquej on tlinon niquijtohua, niman quitasquej tlinon nicchihua, xcajsicamatisquej, para ma ca noyolcuepasquej niman quintlapojpolhuis Dios on intlajtlacol. ");
INSERT INTO nguNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Quemaj oquimijlij: ―Tla xnencajsicamatij in ejemplo, ¿quen ijqui nencajsicamatisquej ocsequi ejemplos? ");
INSERT INTO nguNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yejhua on tlacatl yejhuan toca, on quen on yejhuan quiteijlia on itlajtoltzin Dios niman on xinachtli quen itlajtol Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","On ojtli campa ohuetz on xinachtli sa no ijqui quen on inyojlo sequimej tlacamej yejhuan quicaquij on itlajtol Dios. Pero nimantzin huajlau on diablo, niman quitlalcahualtia ica on itlajtol Dios yejhuan oquitocaquej ipan inyojlo. ");
INSERT INTO nguNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","On tlajli yejhuan tepetlayoj quijtosnequi inyojlo on tlacamej yejhuan cuelcaquij itlajtol Dios, niman ican pactli quiseliaj on tlajtojli. ");
INSERT INTO nguNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero yejhua in tlacamej xmás cuajli quitzquiaj on tlajtojli. Yejhua ica ijcuac impan huajlau on tlen tepajsoloj niman quintlahuelitaj niman tlajtlamach ica quintlajyohuiltiaj ipampa itlajtol Dios, nimantzin cahuaj intlaneltoc. ");
INSERT INTO nguNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","On tlajli yejhuan huitzyoj quijtosnequi inyojlo on tlacamej yejhuan cuelcaquij itlajtol Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero pampa sa comatztoquej quen ijqui nopanoltisquej, niman sanoyej quinequij notomintisquej, niman ocsequi tlajtlamach quinejnemiliaj, quelcahuaj on itlajtol Dios. Ijcon itlajtol Dios xhueli quimpalehuiya yejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero on cuajli tlajli quijtosnequi inyojlo on tlacamej yejhuan ica cuelcaquij itlajtol Dios, niman quiseliaj, niman intech quisa se cuajli tlacyotl. Yejhuamej sa no ijqui quen on xinachtli yejhuan oquitlaquitij sempoajli huan majtlactli iteyo, niman ocsequimej sa no ijqui quen on yejhuan oquitlaquitij yepoajli, noso sa no ijqui quen on yejhuan oquitlaquitij se ciento. ");
INSERT INTO nguNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","No oquimijlij: ―Xacaj cuajqui se tlahuijli, niman quitlalia ne itzintlan se chiquiutli noso ne itzintlan tlapechtli. On tlahuijli nenquitlaliaj ne tlacpac para ijcon ma tlahuilpanti cuajli. ");
INSERT INTO nguNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yejhua on tlen iyanticaj, yejhuamej quimatisquej ipan ocse tonaltin. Nochi on yejhuan aman xquimatij, quimatisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tla yacaj quipia itlamachilis, ma cajsicamatican cuajli. ");
INSERT INTO nguNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Xnemilican cuajli tlinon nenquicaquij, pampa ica on tlen tejhua tictequitiltia para tiquintlajtlacolmaca ocsequimej, Dios no yejhua quitequitiltis para mitztlajtlacolmacas. Niman más miyec ica mitztlajtlacolmacas. ");
INSERT INTO nguNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tej, yejhuan quipia cajsicamatilistli, Dios quimacas más, niman on yejhuan xquipia cajsicamatilistli, Dios quixtilis hasta nochi quech quipia. ");
INSERT INTO nguNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","No oquijtoj Jesús: ―On yejhuan Dios quinmandarohua nochihuaj quen on xinachtli yejhuan se tlacatl quitoca ne ipan tlajli. ");
INSERT INTO nguNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mojmostla on tlacatl cochi tlayohua niman nocuitehua cualcan. Niman on xinachtli ixhua, niman quemaj noscaltia, pero yejhua xquimati quen ijqui. ");
INSERT INTO nguNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","On tlajli san iselti quiscaltia. Achtoj quisa on imilohuayotzin, quemaj on imiyahuayo, niman quemaj xilotzintli, quemaj yelotl, camahuac, niman quemaj sintli. ");
INSERT INTO nguNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Niman quemaj ijcuac yotlachicau, on tlacatl nimantzin calactilia machete, pampa yoyejcoc on pixquilistli. ");
INSERT INTO nguNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","No oquijtoj Jesús: ―Nemechijlis quen ijqui Dios tlamandarohua. Masqui Dios quinmandarohua aman sanoyej achijtzin on tlacamej, pero más miyequiyasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sa no ijqui quen se tlacatl oquitocac on iteyo on itoca mostaza. On mostaza quipia más pitentzin iteyo xquen nochi quech xinachtli yejhuan oncaj nican ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero ijcuac yonotocac noscaltia, niman hueyiya más huejcapania xquen nochi quech xiutli. Sanoyej nomajmatia hasta on totomej huelij ompa quichijchihuaj intepajsol ne ipan imahuan campa tlajsehuayoc. ");
INSERT INTO nguNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Quinmachtiaya on cuajli tlajtojli ican ejemplos hasta campa xoc hueliyaj cajsicamatiyaj. ");
INSERT INTO nguNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yejhua quinmachtiaya san ican ejemplos niman xitlaj quimijliaya tla xican ejemplo. Pero ijcuac Jesús sa iselti nemiya inhuan on inomachtijcahuan, yejhua quinmachtiaya tlinon quijtosnequi on ejemplos. ");
INSERT INTO nguNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ipan on tonajli ijcuac yotlayohuac, Jesús oquimijlij on inomachtijcahuan: ―Tiahuij ne ocse ilado in mar. ");
INSERT INTO nguNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Quemaj ijcuac yoquinnahuatijquej on tlacamej ma huiyan, on nomachtijquej ocuicaquej Jesús ipan on barco ijcon quen nemiya. Ocsequimej barcos oyajquej ihuan. ");
INSERT INTO nguNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Niman quemaj más achi saquin, ohuajlaj se ajacatl sanoyej chicahuac, niman on atl oncoxoniya ne ijtic on barco hasta ye temiya. ");
INSERT INTO nguNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús cochticatca nepa tlacuitlapan ipan se cuejtomatl. Niman quemaj oquitlachaltitoj, niman oquijlijquej: ―Totemachtijcau, ¿tlica yej ticochticaj chica tejhuamej ye tiamimictoquej? ¡Xtechpalehui! ");
INSERT INTO nguNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Quemaj Jesús onotelquetz, oquinahuatij on ajacatl, niman oquijlij on mar: ―Xmotelti, niman ma ca sa tlamach xchihua. Niman quemaj ohuajnoteltij on ajacatl. Nimantzin nochi ocactiaj, niman nochi cuajli onocau. ");
INSERT INTO nguNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Niman quemaj oquimijlij on inomachtijcahuan: ―¿Tlica sanoyej nemomojtiaj? ¿Tlen, xnennechneltocaj hasta aman? ");
INSERT INTO nguNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yejhuamej sanoyej nomojtiayaj, niman quinojliayaj ihuan ocsequimej: ―¿Manin aquin tlacatl in ica on ajacatl niman on mar quitlacamatij? ");
INSERT INTO nguNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Oajsiquej ne ocsecan itenco on mar ipan iregión Gadara. ");
INSERT INTO nguNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Niman ijcuac Jesús yohuajquis ipan on barco, oquinamiquito se tlacatl yejhuan quipiaya se xcuajli espíritu. Ohualeu neca ijtic ostomej campa notocayaj on mimiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ompa, tej, ichan catca. Niman xacaj hueliya quiteltiaya, nion siquiera ican on teposcadenas. ");
INSERT INTO nguNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sanoyej miyecpa oquisalojcaj ican teposcadenas niman tepostli yehualtic yejhuan para quiteltiaya imahuan niman icxihuan. Pero nochipa ijcuac quitlaliliayaj, yejhua quitecojcotonaya on teposcadenas, niman quincuejcuechtiliaya on tepostin yejyehualtiquej. Niman xacaj hueliya quiteltiaya. ");
INSERT INTO nguNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tlayohua niman tlajocaj tzajtzitinemiya, niman nocojcocohuaya ican temej ne imanyan on ostomej campa notocayaj on mimiquej niman ipan on tepemej. ");
INSERT INTO nguNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pero ijcuac ocontac Jesús huejcatzin, huajlau onotlaloj campa yejhua nemiya, niman ixpan onotlacuenquetz. ");
INSERT INTO nguNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Niman oquitzajtzilij chicahuac: ―¿Tlinon ticnequi nohuan Jesús, tejhua tiiConeu Dios yejhuan más hueyixticaj? Nimitzajmancatlajtlanilia ixpan Dios, ma ca xnechtlajyohuilti. ");
INSERT INTO nguNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Otzajtzic ijcon pampa Jesús yoquijlijca: ―Xcuajli espíritu, xquisa ijtic in tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús oquitlajtoltij: ―¿Quen ijqui motoca? Yejhua oquinanquilij: ―Nejhua nicpia miyec notoca pampa sanoyej timiyequej. ");
INSERT INTO nguNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Niman yejhuamej on xcuajcualtin espíritus sanoyej quitlajtlaniliayaj Jesús para ma ca ma quinquixti ompaca ne. ");
INSERT INTO nguNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Niman ompa nemiyaj miyequej pitzomej ipan se tepetl campa tlacuajcuajtinemiyaj. ");
INSERT INTO nguNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Niman on xcuajcualtin espíritus sanoyej quitlajtlaniliayaj Jesús: ―Xtechtitlani ne intech on pitzomej niman ma ticalaquican impan. ");
INSERT INTO nguNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Niman Jesús oquincahuilij, niman on xcuajcualtin espíritus oquisquej ipan on tlacatl, niman ocalaquej impan on pitzomej. On pitzomej canaj ome mil catca. Yejhuamej on tlatlacsaquej niman ne ipan se teostotl campa huejcatlan oxixinitoj hasta ijtic on mar. Ompa, tej, nochimej oamimiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","On yejhuan tlajpiayaj ica on pitzomej, ican inmojcayo ontlatlacsaquej. Oquitetlajtlajtohuilitoj ne ipan on pueblos niman nochihuiyan ipan campo. Niman on tojlan oyajquej para oquitatoj on tlen onochiu. ");
INSERT INTO nguNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ijcuac oyejcoquej campa nemiya Jesús, oquitaquej on tlacatl yejhuan ipan oquisquej on xcuajcualtin espíritus. Yejhua yehuaticatca, niman ye nemiya ican itlaquen, niman ye quipiaya cuajli itlamachilis. Yejhuamej sanoyej onomojtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Niman quemaj yejhuamej on yejhuan oquitaquej quen ijqui onochiu, nochi oquitetlajtlajtohuilijquej quen onochiu ica on yejhuan quipiayaj on xcuajcualtin espíritus, niman quen onochiu ica on pitzomej. ");
INSERT INTO nguNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Niman yejhuamej sanoyej oquitlajtlanilijquej Jesús para ma quisa ompaca ne. ");
INSERT INTO nguNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ijcuac Jesús ocsejpa otlejcoc ipan on barco, on tlacatl yejhuan quimpiaya on xcuajcualtin espíritus sanoyej oquitlajtlanilij para ma huiya ihuan. ");
INSERT INTO nguNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús xocahuilij, yej oquijlij: ―Xhuiya mochan, niman xquimijli on quen tiquinta nochi on huejhueyi tlajtlamach tlen Dios omitzchihuilij, niman quen omitzicnelij. ");
INSERT INTO nguNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tej, on tlacatl oyaj ne ipan on región yejhuan quimpia majtlactli pueblos, niman nochi oquitetlajtlajtohuilij tlinon Jesús oquichiu ipampa, niman nochimej tlamojcaitayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ijcuac Jesús ocsejpa yopanoc ipan ocse lado de on mar ipan on barco, onosentlalij miyec tlacatl itech. Niman yejhua ompa nemiya itenco on mar. ");
INSERT INTO nguNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Quemaj oyejcotetz se tlacatl itoca Jairo. Yejhua se tlayecanquetl ne ipan intiopan on hebreos. Ijcuac oquitac Jesús, ixpan onotlacuenquetz. ");
INSERT INTO nguNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yejhua oquiajmancatlajtlanilij, oquijlij: ―Nochpocatzin ye micticaj. Nimitztlajtlanilia sanoyej, xhuiya, niman xtlaliti momahuan ipan yejhua para ma pajti, niman ma nemi. ");
INSERT INTO nguNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Quemaj Jesús oyaj ihuan, niman oyajquej miyequej tlacamej ihuan. Sa quipitzmictiayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","No ompa tehuan nemiya se sihuatl, yejhuan quipia matlactli huan ome xipan ica yeshuetztinemiya. ");
INSERT INTO nguNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Miyequej tlapajtijquej sanoyej yoquitlajyohuiltijcaj. Yejhua yoquitlajtlamijca nochi on tlinon quipiaya, pero xopajtic, yej más tlanahuiya. ");
INSERT INTO nguNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","On sihuatl oquicac ica Jesús hueli tepajtia. Yejhua ica yejhua ohuajlaj inhuan on tlacamej. Oquinisihuij Jesús san icuitlapan, niman ocajsic itlaquen. ");
INSERT INTO nguNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ijcon oquichiu pampa quinemiliaya: “Tla san nicajsis itlaquen, nipajtis.” ");
INSERT INTO nguNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nimantzin xoc yeshuetziya. On sihuatl nimantzin oquimat ipan itlalnacayo ica opajtic. ");
INSERT INTO nguNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ijcuacon Jesús oquimat ica on poder itech oquis. Yejhua ica ohuajnocuep ne tetzajlan niman oquitetlajtoltij: ―¿Aquinon oquimatocac notlaquen? ");
INSERT INTO nguNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","On inomachtijcahuan oquilijquej: ―Tiquitzticaj ica in tlacamej mitzpitzmictiaj. Yejhua ica, ¿tlica titlajtlani aquinon oquimatocac notlaquen? ");
INSERT INTO nguNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero Jesús tlatlachaya iyehualijcan para quitas aquinon oquimatocac. ");
INSERT INTO nguNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ijcuacon on sihuatl yehuan quimatzticatca tlinon ipan yonochiu, ohuajlaj itech Jesús, niman onotlacuenquetz ixpan. Yejhua sanoyej nomojtiaya, niman cuecuetlacaya. Yejhua oquijlij nochi tlen melahuac. ");
INSERT INTO nguNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Quemaj Jesús oquijlij: ―Noconeu, otipajtic pampa otitlaneltocac. Xhuiya ican yolsehuilistli. On cualolistli xoc ticpia. ");
INSERT INTO nguNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús oc tlajtlajtojticatca ijcuac oyejcotetzquej sequimej tlacamej yejhuan ohualejquej ne ichan itlayecancau on tiopan. Niman yejhuamej oquijlijquej: ―Mochpoch yomic. Ma ca sa más xpajsolo on temachtijquetl. ");
INSERT INTO nguNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús xoquinchihuilij cuenta on tlinon oquijtojquej, niman oquijlij on tlayecanquetl ipan on tiopan: ―Ma ca xmomojti, yej san xnechneltoca melahuac. ");
INSERT INTO nguNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Niman Jesús xocahuilij yacaj más ihuan ocalac, yej san Pedro niman on omemej icniutin Jacobo niman Juan. ");
INSERT INTO nguNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ijcuac oajsiquej ne ichan on tlayecanquetl ipan on tiopan, Jesús oquitac ica on tlacamej sanoyej yonajcomanquej, niman ica chocayaj, niman sa amancatzajtziyaj sanoyej. ");
INSERT INTO nguNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús ocalac, niman oquimijlij: ―¿Tlica nenmajcomanaj, niman nenchocaj? On sihuaconetl xmiqui, yej san cochtica. ");
INSERT INTO nguNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero yejhuamej ocuetzquilijquej. Quemaj Jesús oquinquixtij ne quiahuac on yejhuan ompa nemiyaj, niman ocuicac san itataj niman on inanaj on sihuaconetl, niman yejhuamej on yeyimej inomachtijcahuan. Niman ocalacquej ne campa onoc on sihuaconetl. ");
INSERT INTO nguNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Quemaj oconquitzquij ima on sihuaconetl, niman oquijlij: ―Talita, cumi ―yejhuan quijtosnequi: Sihuaconetl, nejhua nimitzijlia, xmotelquetza. ");
INSERT INTO nguNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nimantzin on sihuaconetl, yejhuan quipiaya majtlactli huan ome xipan, onoquetzteu, niman quemaj opeu nejnemi. Niman nimantzin yejhuamej sanoyej otlamojcaitajquej. ");
INSERT INTO nguNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero Jesús oquintlachicahuilij para ma ca yacaj quijlisquej on tlinon yejhua oquichiu. Quemaj Jesús otlanahuatij ma quitlacualtican on sihuaconetl. ");
INSERT INTO nguNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Quemaj Jesús ohuajquis niman oyaj ne ipan on pueblo campa onoscaltij. Niman on inomachtijcahuan oyajquej ihuan. ");
INSERT INTO nguNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ijcuac oajsic on sábado, opeu temachtia ipan intiopan on hebreos. Niman miyec tlacatl oquicac, niman otlamojcaitajquej. Oquijtojquej: ―¿Hasta canon ohuelito nochi in tlen quijtohua? niman ¿aquinon oquimacac in tlamatquilistli? niman ¿quen quichihua in milagros? ");
INSERT INTO nguNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Tlen xejhua cojxinqui, niman iconeu María? ¿Xejhua icniu Jacobo, niman José, niman Judas niman Simón? ¿Xnican ipan in pueblo chantij on icnihuan yejhuan sihuamej? Niman onotlahueltijquej ipampa. ");
INSERT INTO nguNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús oquimijlij: ―Se tiotlajtojquetl nochihuiyan quitlacaitaj, pero ne ipan ipueblo niman on quen quinta niman ichanchanecahuan xquitlacaitaj. ");
INSERT INTO nguNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Xohuel oquichiu ompa itlaj milagro. San quesquimej cocoxquej impan oquintlalij imahuan, niman oquimpajtij. ");
INSERT INTO nguNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús sanoyej tlamojcaitaya pampa yejhuamej xquineltocayaj. Niman Jesús panotiaya nochihuiyan ipan on pueblos, niman temachtijtiaya. ");
INSERT INTO nguNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Niman quemaj oquinsentlalij on majtlactli huan ome inomachtijcahuan, niman opeu quintijtitlani ojomemej. Niman yejhua oquinmacac poder para ma quitequixtilican on xcuajcualtin espíritus. ");
INSERT INTO nguNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Niman oquinnahuatij ma ca itlaj quitquisquej para ipan ojtli san incojtopil. Oquimijlij para ma ca quitquisquej inbolsa, nion tlaxcajli, nion tomin, ");
INSERT INTO nguNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","yej san ma quitequitiltican incac niman insentetlaquen. ");
INSERT INTO nguNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Quemaj oquimijlij: ―Ijcuac nemajsiquej ipan se pueblo, xmocahuacan ipan se cajli hasta nenquisasquej ipan on pueblo. ");
INSERT INTO nguNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tla nemajsij ipan se pueblo campa xmechselisquej, nion mechcaquisquej, xtzejtzelocan nemocxi on tlalteutli ijcuac nenquisasquej. Melahuac, tej, nemechijlia ica ijcuac Dios quiyolcuitis niman quitlajtlacolmacas on pueblo, más tlajyohuis xquen Sodoma niman Gomorra. ");
INSERT INTO nguNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Quemaj yejhuamej oquisquej, niman oyajquej. Quinmachtijtiayaj on tlacamej para ma noyolcuepacan. ");
INSERT INTO nguNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","No oquinquixtijquej miyequej xcuajcualtin espíritus, niman oquintlalilijquej aceite ipan miyequej on cocoxquej, niman oquimpatijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Niman on rey Herodes ocac ica notenehua Jesús pampa itoca nohuiyan yomachiyac. Sequimej quijtohuayaj: ―Jesús hueli quichihua on milagros pampa melahuac, tej, yejhua Juan yejhuan Dios yoquiyolihuitij niman yoquetzteu ne intzajlan on mimiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero sequimej quijtohuayaj: ―Yejhua on tiotlajtojquetl Elías. Niman ocsequimej quijtohuayaj: ―Yejhua se tiotlajtojquetl noso yacaj semej on achtoj tiotlajtojquej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero ijcuac Herodes ocac, oquijtoj: ―Yejhua in Juan on tlacuatequijquetl yejhuan onitlatitlan para oquechtzontequej. Aman yonoyolihuitij niman yonoquetzteu ne intzajlan on mimiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ijquin Herodes oquijtoj pampa yejhua otlanahuatij para ma cajsican Juan, niman oquisalojquej ican teposcadena ne campa tzacuticaj para quipactis Herodías. Yejhua in Herodías, isihuau catca Felipe on icniu Herodes, pero Herodes oquicuilij para yejhua isihuau. ");
INSERT INTO nguNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Herodes oquitzacu Juan pampa yejhua quijlijtinemiya Herodes: ―Itlanahuatil Dios xmitzcahuilia ticpias isihuau mocniu quen mosihuau. ");
INSERT INTO nguNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías, tej, sanoyej quitlahuelitaya Juan, niman quinequiya quimictis, pero yejhua xhueliya ");
INSERT INTO nguNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","pampa Herodes quitlacaitaya Juan, niman quimatzticatca ica yejhua cuajli tlacatl yolchipahuac. Yejhua ica Herodes quimanahuiaya. Ijcuac Herodes contaya sanoyej cuelcaquiya, masqui xoc quimatiya tlen quichihuas. ");
INSERT INTO nguNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Quemaj oyejcoc on tonajli yejhuan cuajli catca para Herodías. Ijcuac on Herodes oquichiu ilhuitl pampa yejhua ilhuiu catca, oquinnotz on tequihuajquej, niman on comandantes niman on huejhueyixtoquej ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Niman on ichpoch Herodías no ocalac, niman onijtotij. Niman on rey Herodes niman yejhuan oquinnotz sanoyej ocuelitaquej. Yejhua ica Herodes oquijlij on ichpochtli: ―Xnechtlajtlanili nochi san tlinon ticnequis, niman nimitzmacas. ");
INSERT INTO nguNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Niman no oquijlij: ―Ican notlajtol nimitzijlia: “Nochi tlinon tinechtlajtlanis nimitzmacas, masqui hasta tlajcotipan in campa nejhua nitlamandarohua.” ");
INSERT INTO nguNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","On ichpochtli oquis niman oquitlajtoltijtetzito inan. Oquijlij: ―¿Tlinon nictlajtlanilis? Niman yejhua oquijlij: ―Xtlajtlanili itzontecon Juan on tlacuatequijquetl. ");
INSERT INTO nguNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Niman quemaj nimantzin on ichpochtli ocsejpa ocalaquito. Oquitlajtlanito, oquijlij on rey: ―Ipan se plato xnechmaca amantzin itzontecon Juan on tlacuatequijquetl. ");
INSERT INTO nguNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Niman quemaj on rey Herodes sanoyej onajman. Pero pampa yejhua yonocalactijca ican itlajtol, niman impampa itenotzcahuan yejhuan ihuan tlacuaj, on rey oquichiu quen oquijtojca. ");
INSERT INTO nguNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nimantzin on rey oquititlan se itlajpixcau soldado, niman oquinahuatij para ma cuajqui on itzontecon Juan ipan se plato. On soldado oyaj, niman oquechtzontequito Juan ne campa tzacuticatca, ");
INSERT INTO nguNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","niman ocuajquic itzontecon ipan se plato. Yejhua oquimacac on ichpochtli, niman on ichpochtli oquimacac inan. ");
INSERT INTO nguNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ijcuac on inomachtijcahuan Juan oquimatquej ica yomic Juan, ohualajquej niman ocuicaquej. Quemaj oquitocatoj ne ipan se tlalcontli. ");
INSERT INTO nguNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Quemaj on iapostolhuan Jesús onosentlalijquej ihuan, niman oquitlajtlajtohuilijquej nochi tlinon oquichijquej, niman tlinon otemachtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yayaj niman huajlayaj tojlamej, niman Jesús inhuan iapostolhuan nion xquipiayaj tiempo para tlacuasquej. Yejhua ica Jesús oquimijlij on iapostolhuan: ―Xhuajhuiyan, tiahuij neca campaca xacaj nemi, niman ompa tihuelisquej titosehuisquej achijtzin. ");
INSERT INTO nguNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Quemaj oyajquej ipan se barco ne tlapatlaco campa xacaj nemi. ");
INSERT INTO nguNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Niman ijcuac oyajquej, miyequej oquintaquej, niman oconixmatquej Jesús. Niman on tlacamej ipan nochihuiyan pueblos campaca san nisiu onotlajtlalojquej, niman oajsiquej más achtoj, niman on barco oajsic más saquin. ");
INSERT INTO nguNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ijcuac Jesús ohuajquis ne ipan on barco, oquintac sanoyej yotojlantic. Yejhua sanoyej oquimicnelij, pampa nemiyaj quen itlaj borregos yejhuan xquipiaj intlajpixcau. Quemaj Jesús opeu quinmachtia miyec tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ijcuac más tiotlac, on inomachtijcahuan oquijlijquej: ―Xacaj chanti nican, niman ye tiotlactiticaj. ");
INSERT INTO nguNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xquintitlani para ma huiyan neca ipan on pueblitos niman neca ipan on cuadrillas campaca san nisiu para ma cohuacan itlaj para quicuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero yejhua oquimijlij: ―Nemejhuamej xquintlacualtican. Niman oquijlijquej: ―¿Ticnequi ma tihuiyan, niman ma ticohuatij pan? Sen tlacatl nonequi tequitis canaj chicueyi metztli para huelis cohuas on pan para nochimej in tojlamej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Oquimijlij: ―¿Quesqui pan nenquipiaj? Xhuiyan, niman xquitacan quesqui nenquipiaj. Niman quemaj ijcuac oquimatquej, oquijlijquej: ―Ticpiaj macuijli pan niman ome michimej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Quemaj Jesús oquinnahuatij ma notlajtlalican ipan on sacatl ojoncuaj. ");
INSERT INTO nguNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Niman quemaj onotlajtlalijquej ojoncuaj sejsen ciento niman tlatlajco ciento. ");
INSERT INTO nguNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Quemaj ijcuac Jesús ocontilan on macuijli pan niman ome michin, oajcotlachix ne ilhuicac niman oquimacac tlaxtlahuijli Dios para on tlacuajli. Niman quemaj oquitlatlapan on pan, niman oquinmacac inomachtijcahuan para ma quinxelohuilican on tlacamej. No oquitexelohuilijquej on ome michin. ");
INSERT INTO nguNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nochimej otlacuajquej, niman cuajli oixhuiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Niman quemaj ica on tlatlajcotzitzin tlen onocau, oquitemiltiquej majtlactli huan ome chiquiutin. ");
INSERT INTO nguNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Niman on yejhuan otlacuajquej macuijli mil tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Quemaj Jesús nimantzin oquinnahuatij on inomachtijcahuan para ma calaquican ipan on barco, niman ma yecatztiacan ne ocse ilado on mar ipan on pueblo itoca Betsaida, chica yejhua quinnahuatiaya on tlacamej para ma huiyan. ");
INSERT INTO nguNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Más saquin, ijcuac yoquintitlan on tlacamej, yejhua otlejcoc ipan se tepetl, niman ompa oquichiu oración. ");
INSERT INTO nguNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ijcuac otlayohuac, on barco yaya ne atlajcotian ipan on mar, niman Jesús nemiya iselti ne ipan on tepetl. ");
INSERT INTO nguNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús oquitac ica on inomachtijcahuan yosiauquej ica quinejnemitiayaj on barco pampa on ajacatl quimixnamiquiya. Niman canaj ipan yeyi hora ica cualcan, yejhua nejnentiaya ne ixco on mar hasta ijqui oajsic ne campa nemiyaj on inomachtijcahuan. Yejhua quinemiliaya quimpanahuis. ");
INSERT INTO nguNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero ijcuac on nomachtijquej oquitaquej nejnentiu ne ixco on mar, yejhuamej cuitiayaj se xcuajli tlamojtiloni. Yejhuamej chicahuac otzajtziquej, ");
INSERT INTO nguNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","pampa nochimej oquitaquej, niman sanoyej onomojtijquej. Quemaj nimantzin Jesús oquimijlij: ―¡Xmoyolchicahuacan niman ma ca xmomojtican! Nejhua niJesús. ");
INSERT INTO nguNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Quemaj otlejcoc ne ipan on barco, niman quemaj onoteltij on ica chicahuac ajacaya. On inomachtijcahuan sanoyej otlamachilispolijquej niman sanoyej otlamojcaitaquej. ");
INSERT INTO nguNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yejhuamej, masqui yoquitaca tlinon yoquichijca ican on pan niman on michin, hasta aman xcajsicamatiyaj on milagro yejhuan Jesús oquichiu. Quipiayaj on intlamachilis sanoyej chicahuac. ");
INSERT INTO nguNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Niman ijcuac oquipanahuijquej on mar, oajsiquej ipan on tlajli itoca Genesaret campa oquisalotoj inbarco. ");
INSERT INTO nguNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ijcuac yejhuamej oquisquej ipan on barco, on tojlamej nimantzin oquixmatquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Quemaj nimantzin oyajquej nochihuiyan ompaca nijnisiu, niman oquinhuajhuicaquej on incocoxcahuan ipan cojtlapechtin hasta campa nemiya Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nochihuiyan campa calaquiya ipan huejhueyican, noso pueblos, noso cuadrillas, yejhuamej oquintlajtlalijquej on incocoxcahuan ne ipan calles, niman quitlajtlaniliayaj Jesús para ma quinocahuili ma cajxilican on itlaquen, masqui san itencotzin. Niman nochimej on yejhuan ocajxilijquej itlaquen oquimpajtij. ");
INSERT INTO nguNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Se tonajli sequimej fariseos niman sequimej temachtijquej ican itlanahuatil Dios ohualejquej ne Jerusalén, niman onosentlalijquej ne itech Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ijcuac nemiyaj ihuan Jesús, yejhuamej oquitaquej ica sequimej inomachtijcahuan Jesús tlacuayaj, masqui xnomajtequiayaj quen on huehuetquej tlajtlajmatquej oquijtocaj ica nonequi nomajtequisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","On fariseos niman nochimej on hebreos xtlacuaj, tla xachtoj nomajtequiaj quen on huehuetquej tlajtlajmatquej oquijtojcaj ica cuajli para quichihuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","In se ejemplo. Ijcuac huajnocuepaj ne plaza, achtoj nomajtequiaj quen on tlajtlajmatquej huehuetquej oquijtojcaj ica cuajli para quichihuasquej, niman quemaj tlacuasquej. Niman quipiaj ocsequi miyec tlanahuatijli no ijqui quejehuasquej, ijcon quen quimpajpacayaj on contzitzintin, niman on tazas niman on teposcontin. ");
INSERT INTO nguNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Quemaj on fariseos niman on temachtijquej ican itlanahuatil Dios oquitlajtoltijquej Jesús: ―¿Tlica on monomachtijcahuan xnomajtequiyaj ijcon quen otechititijquej on huehuetquej tlajtlajmatquej? ");
INSERT INTO nguNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús oquinnanquilij: ―Cuajli oquijtoj on tiotlajtojquetl Isaías nemotechcopa nemejhuamej omexayacyequej, ijcuac oquijcuiloj quen Dios oquijtoj. Oquijtoj: Yejhuamej in tlacamej nechtlacaitaj san ica incamac, pero xnechtlacaitaj ican inyojlo. ");
INSERT INTO nguNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sanencaj nechmahuistiliaj, pampa yejhuamej quitemachtiaj on tlanahuatiltin yejhuan on tlacamej oquitlalijquej quen itlanahuatilhuan yesquiaj Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Quemaj Jesús oquimijlij: ―Xnenquitlacamatij on tlinon Dios omechnahuatij, pero nenquitlacamatij yejhua on tlinon on huehuetquej tlajtlajmatquej otemachtijcaj. Niman nenquichihuaj ocsequi miyec tlajtlamach no ijqui. ");
INSERT INTO nguNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Niman quemaj oquimijlij: ―Nemocajcayahuaj niman nentecajcayahuaj, ijcuac nenquejcuaniaj itlanahuatil Dios para nentemachtiaj quen nemejhuamej nemohuicaj. ");
INSERT INTO nguNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ijquin nentecajcayahuaj. Moisés otlanahuatij: “Xtlacaita motaj niman monan.” Niman no oquijtoj: “Yejhuan itlaj xcuajli quitenehuilis itaj noso inan, ma quimictican.” ");
INSERT INTO nguNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero nemejhuamej nenquijtohuaj ica se tlacatl huelis quijlis itaj noso inan: “Xhuelis nimitzpalehuis ica on tlen mitzpolohua pampa yej Corbán.” (Corbán quijtosnequi on tlinon nicpia yonicmactilij Dios). ");
INSERT INTO nguNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ijcon xnencahuiliaj ma quipalehui itaj noso inan. ");
INSERT INTO nguNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ijcon, tej, nemejhuamej onenquichijquej quen xitlaj quijtosnequi on itlanahuatil Dios, pampa nemohuicaj ipan on costumbres yejhuan on huehuetquej tlajtlajmatquej otemachtijquej. Niman nenquichihuaj miyec ocsequi tlajtlamach sa no ijqui. ");
INSERT INTO nguNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Quemaj Jesús oquinnotz nochimej on tlacamej, niman oquimijlij: ―Xcaquican nemochimej niman xcajsicamatican. ");
INSERT INTO nguNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","On tlen calaqui icamac se tlacatl xejhua quijtlacohua, pero on yejhuan quisa ipan iyojlo, on quemaj yejhua quijtlacohua. ");
INSERT INTO nguNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tla nemejhuamej nenquipiaj nemotlamachilis, xcajsicamatican on tlen oniquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Quemaj ijcuac Jesús oquincajteu on tlacamej niman ocalaquito ipan techan, inomachtijcahuan oquitlajtoltijquej para ma quimijli tlinon quijtosnequi on ejemplo. ");
INSERT INTO nguNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús oquinnanquilij: ―¿Nemejhuamej no xonencajsicamatquej on tlinon oniquijtoj? Xnencajsicamatij ica nochi tlen calaqui ipan icamac se tlacatl xejhua quijtlacohua, ");
INSERT INTO nguNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","pampa on tlinon quicua xcalaqui ne ipan iyojlo, yej calaqui ne ijtic icuitlaxcol, niman quemaj quisa ne ipan itlalnacayo. Ijcon oquijtoj ica nochi quech tlacuajli oncaj cuajli para nocuas. ");
INSERT INTO nguNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Niman no quijtohuaya: ―On yejhuan quisa ipan iyojlo se tlacatl, on quemaj quijtlacohua, ");
INSERT INTO nguNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","pampa ne ijtic iyojlo quisa on xcuajcualtin tlamachilistin, sihuapajpatlalistli, tlacapajpatlalistli, on ahuilnemilistli, temictilistli, ");
INSERT INTO nguNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tlachtequilistli, on tlen xcuajli elehuilistli, tlacajcayahualistli, xtetlacamatilistli, nexicolistli tetlajtojquetztehuilistli, nohueyimatilistli, tontojtililistli niman nochi tlajtlamach tlen xcuajli nochihua. ");
INSERT INTO nguNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nochi in yejhuan xcuajli hualehua ne ipan iyojlo se tlacatl, niman yejhua ica más nijtlacohua. ");
INSERT INTO nguNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Quemaj ohuajnoquetzteu, oquis ompa, niman oyaj ne ipan iregión on huejhueyican Tiro niman Sidón. Quemaj ocalac ipan se cajli, niman xquinequiya para ma quimatican on tlacamej tla ompa nemi, pero yejhuamej oquimatquej. ");
INSERT INTO nguNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nimantzin inan se ichpochtli, yejhuan quipiaya se xcuajli espíritu, oquimat ica Jesús nemiya ne ipan on cajli. Yejhua oyaj itech niman ixpan onotlacuenquetz. ");
INSERT INTO nguNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","On sihuatl ohualeu ne Sirofenicia niman tlajtohuaya griego. Oquiajmancatlajtlanilij Jesús para ma quixtili on xcuajli espíritu yejhuan nemiya ijtic ichpoch. ");
INSERT INTO nguNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús oquijlij: ―Achtoj ma niquimpalehui on nochantlacaj hebreos. Tejhua xtihebrea. Tla nimitzpalehuis, yejhua in sa no ijqui quen nicualtisquia se chichi intlacual on iconehuan Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero on sihuatl oquijlij: ―On melahuac, noTeco, pero on chichimej yejhuan nemij ne itzintlan on mesa, quicuajcuaj on tlaxcaltejteinqui yejhuan xixini ne tlaltipan. ");
INSERT INTO nguNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús oquijlij: ―Ma ijqui nochihua. Xhuiya. On xcuajli espíritu yoquis ne ijtic mochpoch pampa tlinon otinechijlij sanoyej cuajli. ");
INSERT INTO nguNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","On sihuatl oyaj, niman ijcuac oajsic ne ichan, oquinextijtajsic ichpoch nemi ipan itlapech, niman on xcuajli espíritu yoquitlalcahuij. ");
INSERT INTO nguNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Quemaj Jesús oquis ne ipan iregión Tiro, niman ohuajlaj ipan on hueyican itoca Sidón. Quemaj yejhua oyaj imanyan on iyehualican yejhuan quipia majtlactli pueblos, niman oajsic ne itech on mar itoca Galilea. ");
INSERT INTO nguNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Niman sequimej tlacamej ocuajhuicaquej se tlacatl yejhuan nacastzatza catca niman tenenepochticatca. Niman sanoyej oquitlajtlanilijquej para ma quitlali ima ipan on tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús ocuicac neca campa xacaj nemi, niman quemaj oquincalactij imajpilhuan ne ijtic inacashuan. Niman quemaj oquipatzoj on imajpil ican icualac, niman oquitzquilij on inenepil on tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Oajcotlachix ne ilhuicac, niman quemaj onejeltij ica ajmantli, niman oquijtoj: ―¡Efata! ―yejhuan quijtosnequi: ¡Xtlapohuican! ");
INSERT INTO nguNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Quemaj nimantzin on tlacatl otlacac. No ijqui ohuajnomajmacau isasaliuyan inenepil niman ohuel otlajtoj cuajli. ");
INSERT INTO nguNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Quemaj Jesús oquinnahuatij on tlacamej: ―Ma ca yacaj nenquijlisquej on tlinon onicchiu. Pero masqui quinnahuatiaya para ma ca yacaj quijlisquej, más quiteijliayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nochimej sanoyej tlamojcaitayaj, niman quijtohuayaj: ―¡Nochi hueli quichihua sanoyej cuajli hasta on nacastzatzamej hueli quintlacaquitia, niman on tenenepochmej quinchihuilia para ma tlajtocan cuajli! ");
INSERT INTO nguNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ocse tonajli ocsejpa onosentlalij miyec tlacatl. Yejhuamej xquipiayaj tlen cuasquej niman Jesús oquinnotz on inomachtijcahuan, niman oquimijlij: ");
INSERT INTO nguNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nejhua niquinmicnelia on tlacamej, pampa ye quipiaj yeyi tonajli ica nican nohuan nemij niman xquipiaj tlinon quicuasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tla xniquintlacualtis, yej niquinnahuatis ma huiyan, huelisquej sotlahuisquej ne ipan ojtli, niman sequimej sanoyej huejca inchan. ");
INSERT INTO nguNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","On inomachtijcahuan oquijlijquej: ―Xtihuelisquej ticnextisquej tlacuajli para tiquintlacualtisquej nochimej in tlacamej nican tlapatlaco. ");
INSERT INTO nguNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yejhua oquintlajtoltij: ―¿Quesqui pan nenquipiaj? Yejhuamej oquijlijquej: ―Chicome. ");
INSERT INTO nguNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Quemaj Jesús otlanahuatij para on tlacamej ma notlajtlalican ne ipan tlajli. Quemaj ocontilan on chicome pan, niman oquimacac tlaxtlahuijli Dios. Quemaj oquitlatlapan, niman oquinxelohuilij on inomachtijcahuan para ma quinxelohuilican on tlacamej. Niman oquinxelohuilijquej nochi on quech ica tojlan. ");
INSERT INTO nguNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","No quimpiayaj quesquimej michintzitzintin. Quemaj oquimacac tlaxtlahuijli Dios por yejhua on michimej, niman quemaj oquimijlij on inomachtijcahuan para ma quitexelohuilican. ");
INSERT INTO nguNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Canaj nahui mil tlacatl catcaj, niman nochimej otlacuajquej niman cuajli oixhuiquej. Niman quemaj on inomachtijcahuan oquisentlalijquej chicome chiquiutin yejhuan onocau. Niman on yejhuan otlacuajquej canaj nahui mil. Quemaj Jesús oquinnahuatij on tlacamej ma huiyan. ");
INSERT INTO nguNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nimantzin otlejcoc ipan barco inhuan on inomachtijcahuan, niman oyajquej ne Dalmanuta. ");
INSERT INTO nguNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Quemaj ohualajquej on fariseos niman opeu notencuicuij ihuan Jesús. Quitlajtlaniliayaj ma quintiti itlaj milagro ne ipan cielo. Ijquin oquijtojquej para oquitlatlataquej. ");
INSERT INTO nguNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús onejeltij ican ajmantli, niman oquijtoj: ―Miyequej on tlacamej quitlajtlanij se milagro. Melahuac, tej, nemechijlia ica xitlaj nicteititis. ");
INSERT INTO nguNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Niman quemaj oquincajteu. Yejhua otlejcoc ipan se barco, niman oyaj ne ocse ilado on mar. ");
INSERT INTO nguNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","On inomachtijcahuan oquelcajquej para quitquisquej pan. San se pan oquitquijquej ne ipan on barco. ");
INSERT INTO nguNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Quemaj Jesús oquintlachicahuilij: ―Cuajli xcaquican yejhua in. Xmotacan sa no nemejhuamej ica intlaxocolilis on fariseos niman itlaxocolilis on rey Herodes. ");
INSERT INTO nguNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Quemaj on inomachtijcahuan opeu ijquin quinotlajtoltiayaj se ihuan ocse: ―Yejhua otechijlij in pampa xticpiaj pan. ");
INSERT INTO nguNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús oquimat tlen quijtohuayaj, niman oquimijlij: ―¿Tlica nenquijtohuaj xnenquipiaj pan? ¿Xnencajsicamatij? ¿Tlen nemotlamachilis sanoyej chicahuac? ");
INSERT INTO nguNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Nemejhuamej xnentlachaj ican nemixtololoj, nion xnentlacaquij ican nemonacas? ¿Tlen xnenquelnamiquij? ");
INSERT INTO nguNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ijcuac onictlatlapan on macuijli pan, niman quemaj oniquintlacualtij on macuijli mil tlacatl, ¿quesqui chiquiutin de tlatlajcotzitzin yejhuan onocau onenquisentlalijquej? Niman yejhuamej oquijtojquej: ―Majtlactli huan ome. ");
INSERT INTO nguNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Quemaj Jesús oquintlajtoltij inomachtijcahuan: ―Niman ijcuac yonictlatlapan on chicome pan, niman quemaj oniquintlacualtij on nahui mil tlacatl, ¿quesqui chiquiutin de tlatlajcotzitzin yejhuan onocau onenquisentlalijquej? Niman yejhuamej oquijtojquej: ―Chicome. ");
INSERT INTO nguNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Quemaj oquimijlij: ―¿Man hasta aman xnencajsicamatij? ");
INSERT INTO nguNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Quemaj oajsiquej ne Betsaida, niman ocuajhuiquilijquej se tlacatl yejhuan ciego catca. On tlacamej sanoyej oquitlajtlanilijquej Jesús para ma quimatoca. ");
INSERT INTO nguNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Quemaj Jesús oquitilan ipan ima, niman ocuicac neca caltempan. Niman ijcuac oquitlalilij icualac ipan ixtololojhuan, oquintlalij imahuan ipan, niman quemaj oquitlajtoltij: ―¿Ye tihueli tiquita itlaj? ");
INSERT INTO nguNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","On tlacatl oajcotlachix, niman oquijlij: ―Niquinta tlacamej, pero nesi quen cojtin yehuan nejnemij. ");
INSERT INTO nguNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Quemaj ocsejpa Jesús oquintlalij imahuan ne ipan ixtololojhuan on tlacatl. Niman quemaj on tlacatl sa sentlachixticatca, niman quemaj nochi cuajli oquitac. ");
INSERT INTO nguNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús oquijlij: ―Ma ca sa xhuiya ipan in pueblo. Niman ma ca itlaj xteijli. ");
INSERT INTO nguNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús niman on inomachtijcahuan oyajquej neca ipan on pueblos nisiu Cesarea de Filipo. Neca ipan ojtli oquintlajtoltij on inomachtijcahuan: ―On tlacamej, ¿quen quijtohuaj aquin nejhua? ");
INSERT INTO nguNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Oquijlijquej: ―Sequimej quijtohuaj ica tejhua tiJuan on tlacuajtequijquetl, ocsequimej quijtohuaj ica tejhua tiElías, niman ocsequimej quijtohua ica tejhua tiyacaj ocse tiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Quemaj Jesús oquintlajtoltij on inomachtijcahuan: ―Niman nemejhuamej, ¿quen nenquijtohuaj aquin nejhua? Pedro oquijlij: ―Tejhua tiCristo, yejhuan Dios oquitlapejpenij para tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Quemaj Jesús oquinnahuatij para ma ca yacaj ma quijlijcan ica yejhua Cristo. ");
INSERT INTO nguNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Quemaj Jesús opeu quinmachtia ica yejhua aquin onochiu Tlacatl quijyohuis miyec tlajtlamach. On tlajtlajmatquej, niman intlayecancahuan on tiopixquej niman on temachtijquej ican itlanahuatil Dios xquiselisquej. Yejhuamej quimictisquej, pero ipan yeyi tonajli yolihuis, niman noquetztehuas. ");
INSERT INTO nguNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nochi oquinmelajcaijlij ica ijqui nochihuas. Ijcuacon Pedro oquixeloj neca ocsecan niman opeu cajhua. ");
INSERT INTO nguNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Jesús ohuajnocuep, niman ocomintac on ocsequimej inomachtijcahuan, niman ijquin ocajhuac Pedro: ―Xnechtlalcahui Satanás. Tejhua Pedro, xticnemilia quen Dios, yej tejhua ticnemilia quen on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Quemaj Jesús oquinnotz on tojlamej niman on inomachtijcahuan, niman oquimijlij: ―Tla yacaj quinequi yas nohuan, ma quelcahua on tlen quitlajsojtla, niman ma nemi listo para tlajyohuis no ijqui quen se tlacatl tlayohuia ijcuac quimamajtiu icojnepanol ne campa quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yejhua in nemechijlia pampa yejhuan quinequis quimaquixtis inemilis ipan in tlalticpactli, quipolos ialma, pero yejhuan san nopampa niman san ipampa on cuajli tlajtojli yejhuan quitemaca temaquixtilistli quipolos inemilis ipan in tlalticpactli, yejhua quiselis nemilistli para ialma. ");
INSERT INTO nguNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tej, ¿tlinon ica quipalehuis se tlacatl tla yejhua quinoyaxcatis nochi tlen oncaj ipan in tlalticpactli niman quipolos ialma? ");
INSERT INTO nguNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Xitlaj, tej, ica quipalehuis, pampa xitlaj oncaj yejhuan se tlacatl huelis ica quitlaxtlahuas ialma. ");
INSERT INTO nguNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tla yacaj ne imixpan on tlajtlacolejquej noca pinahua niman ica pinahua on tlen nictemachtia, nejhua yejhuan oninochiu Tlacatl no ica nipinahuas ijcuac nihuajlas ican ihueyilis noTataj niman inhuan on yolchipajquej ilhuicactequitquej. ");
INSERT INTO nguNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","No oquimijlij Jesús: ―Ica tlen melahuac nemechijlia ica sequimej yejhuan aman nican nemij quitasquej Dios tlamandaros ican poder ijcuac xe mijmiquij. ");
INSERT INTO nguNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chicuasen tonajli más saquin, Jesús oquinotz Pedro, Jacobo niman Juan niman oquinhuicac san yejhuamej ipan se tepetl sanoyej hueyi. Ompa oquitaquej Jesús ica onixpatlac. ");
INSERT INTO nguNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","On itlaquen sanoyej opetlan, niman oistayac ijcon quen xacaj tlapacquetl ipan in tlalticpactli hueli tlapaca, niman tlastalia sanoyej. ");
INSERT INTO nguNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Niman quemaj Elías niman Moisés ohuajnonextijquej imixpan. Niman on yeyimej inomachtijcahuan oquitaquej ica Elías niman Moisés ihuan tlajtlajtohuayaj Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ijcuacon Pedro oquijlij Jesús: ―Totemachtijcau, sanoyej cuajli ica nican tinemij. Ma ticchijchihuacan yeyi caltzitzintin, se para tejhua, ocse para Moisés, niman ocse para Elías. ");
INSERT INTO nguNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ijcon oquijtoj pampa yejhua niman on ocsequimej sanoyej yonomojtijcaj, niman yejhua xoc quimatiya tlinon quijtos. ");
INSERT INTO nguNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Quemaj ohuajlaj se moxtli yejhuan oquintlapachoj, niman quemaj ipan on moxtli ocaquistic se tlajtojli yejhuan oquijtoj: ―In yejhua notlajsojcaConeu. Yejhua xtencaquican. ");
INSERT INTO nguNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Quemaj nimantzin otlatlachixquej inyehualican niman xoc yacaj más oquitaquej, yej san Jesús iselti. ");
INSERT INTO nguNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chica huajtemohuayaj ne ipan on tepetl, Jesús oquinnahuatij para ma ca yacaj quijlisquej on tlinon oquitaquej hasta ijcuac yejhua, aquin onochiu Tlacatl, yonoyolihuitij niman yonoquetzteu ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yejhua ica xacaj oquijlijquej, yej san quinojliayaj tlinon quijtosnequi on ica quijtohua noyolihuitis niman noquetztehuas ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Quemaj oquitlajtoltijquej Jesús: ―¿Tlica, tej, quijtohuaj on temachtijquej ican itlanahuatil Dios ica Elías ica oncaj achtoj huajlas xquen tejhua yejhuan Dios omitztlapejpenij para techmandaros? ");
INSERT INTO nguNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Otlananquilij, Jesús oquimijlij: ―On melahuac ica Elías achtoj huajlas niman quiyectlalis nochi tlajtlamach. Tla ijcon, ¿tlica tlajcuilolnesticaj ipan on Yectlajcuilojli ica nejhua yejhuan oninochiu Tlacatl nechtlajyohuiltisquej sanoyej niman xnechselisquej? ");
INSERT INTO nguNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero nemechijlia ica Elías yohuajlaj, niman oquichihuilijquej nochi xcuajli tlen oquinequej quen on Yectlajcuilojli quijtohua ipan nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Quemaj ijcuac oajsiquej intech on ocsequimej nomachtijquej, oquitaquej sanoyej tojlamej san secan nemiyaj niman sequimej temachtijquej ican itlanahuatil Dios notencuicuiticatcaj inhuan on nomachtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Niman ijcuac on tojlamej oquitaquej ica yoyejcoc Jesús, sanoyej otlamojcaitaquej niman onotlajtlalojquej para oquitlajpalojtetzitoj. ");
INSERT INTO nguNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Quemaj Jesús oquintlajtoltij on inomachtijcahuan: ―¿Tlinon ica nenmotencuicuiticatcaj inhuan on temachtijquej ican itlanahuatil Dios? ");
INSERT INTO nguNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Quemaj se on yejhuan tehuan ompa nemiyaj, oquinanquilij: ―Temachtijquetl, nican onimitzajhuiquilij notelpoch yejhuan quipia se xcuajli espíritu yejhuan quinontzintilia. ");
INSERT INTO nguNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tej, nochihuiyan campaca yau in espíritu cajsi niman quitlajcali ipan tlajli, niman ompa sanoyej camaposonalquisa, niman sanoyej notlancochtijsi, niman cuecuetlaca. Yoniquintlajtlanilij in monomachtijcahuan para ma quixtilican on xcuajli espíritu, pero xohuelquej. ");
INSERT INTO nguNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Quemaj Jesús oquimijlij: ―¡Oh, nemejhuamej tlacamej yejhuan xnennechneltocaj! ¿Hasta quemanon ninemis nemohuan? ¿Hasta quemanon nemechijyohuis? Xcuajhuicacan nican on telpochtli. ");
INSERT INTO nguNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yejhuamej ocuajhuicaquej on telpochtli ne campa nemiya Jesús. Ijcuac oquitac Jesús, nimantzin on xcuajli espíritu oquitzejtzeloj on telpochtli, niman ohuetz ipan tlajli. Onotlalcuejcuep, niman otemposonalquis. ");
INSERT INTO nguNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús oquitlajtoltij on tajtli: ―¿Quesqui xipan ica quipia motelpoch in xcuajli espíritu? Yejhua oquinanquilij: ―Hasta ijcuac pitentzin. ");
INSERT INTO nguNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Miyecpa on xcuajli espíritu quinequi quimictis. Camantica contlajcali ne ipan atl noso ne tlico. Xtechicneli niman xtechpalehui tla tihueli. ");
INSERT INTO nguNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús oquijlij: ―¿Tlica tinechijlia: “Tla tihuelis”? Tla yej tejhua ticneltoca, Dios nochi huelis mitzchihuilis. ");
INSERT INTO nguNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nimantzin on tajtli otzajtzic chicahuac: ―Nejhua nicneltoca, pero xnechpalehui más ma nitlaneltoca quen melahuac nonequi. ");
INSERT INTO nguNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ijcuac Jesús oquitac ica on tlacamej sanoyej ye nosentlalijticatcaj. Ocajhuac on xcuajli espíritu: ―Tejhua, aquin yoticau nontzin niman nacastzatza in telpochtli, xquisa ne ijtic, niman ma ca ocsejpa ticalaquis ijtic. ");
INSERT INTO nguNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ijcuacon on xcuajli espíritu otzajtzic niman oquitzejtzeloj sanoyej chicahuac. Quemaj oquis ne ijtic on telpochtli, niman ompa ocajteu sotlajtoc. Yejhua ica miyec tlacatl quijtohuaya ica yomic. ");
INSERT INTO nguNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús ocontilan ima on telpochtli, niman oquipalehuij para onotelquetz. ");
INSERT INTO nguNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ijcuac Jesús ocalac ne calijtic, on inomachtijcahuan sa iseltimej oquitlajtoltijquej Jesús: ―¿Tlica tejhuamej xotihuelquej otiquixtijquej on xcuajli espíritu? ");
INSERT INTO nguNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yejhua oquinnanquilij: ―Nemejhuamej san nenhuelisquej nenquinquixtisquej yejhua in quen in xcuajli espíritu tla nenquichihuaj oración niman nemosahuaj. ");
INSERT INTO nguNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Quemaj Jesús niman inomachtijcahuan oquisquej ompa, niman opanoquej neca Galilea. Xquinequiya yejhua ma quimatican canon nemi ");
INSERT INTO nguNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pampa quinmachtiaya inomachtijcahuan. Yejhua oquinmachtij, oquimijlij: ―Nejhua yejhuan oninochiu Tlacatl nechtemactilisquej intech on tlacamej niman nechmictisquej, pero ipan yeyi tonajli niyolihuis niman ninoquetztehuas ipan notlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero on inomachtijcahuan xcajsicamatiyaj tlinon quimijliaya niman nomojtiayaj para quitlajtojlisquej ma quinmelajcaijli on tlen quimijlijticatca. ");
INSERT INTO nguNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ijcuac oajsiquej ne Capernaum, ocalaquej ne ipan se cajli, niman Jesús oquintlajtoltij: ―¿Tlinon nencualijijtojtiayaj ne ipan ojtli? ");
INSERT INTO nguNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero yejhuamej xoquinanquilijquej pampa yejhuamej cualijitojtiayaj aquinon más hueyixticaj intzajlan. ");
INSERT INTO nguNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Quemaj Jesús onotlalij, niman oquinnotz on majtlactli huan ome inomachtijcahuan. Niman quemaj oquimijlij: ―On yejhuan quinequis hueyixtias, yejhua ma nochihua quen se tlanamactli, niman ma quinserviro nochimej. ");
INSERT INTO nguNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Quemaj oquitilan se conetl niman oquitelquetz ne imixpan. Quemaj oquinapaloj, niman oquimijlij on inomachtijcahuan: ");
INSERT INTO nguNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―San aquinon yejhuan nopampa quiselis yacaj yejhuan yolyemanqui quen yejhua in conetl, nejhua nechselia, niman on yejhuan nechselia, xsan nejhua nechselia, yej no quiselia Dios on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan oquijlij Jesús: ―Notemachtijcau, otiquitaquej se tlacatl yejhuan ica motocatzin quintequixtiliaya on xcuajcualtin espíritus. Pero oticnahuatijquej ma ca sa ijqui ma quichihua pampa xtohuan quistinemi. ");
INSERT INTO nguNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Quemaj Jesús oquimijlij: ―Ma ca xtlacahualtican pampa on yejhuan quitenquixtia notoca para quichihua on milagros xhuelis más saquin itlaj nechijtohuilis tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","On yejhuan xtlamach quijtohuaj totechcopa, on tohuan nopohua. ");
INSERT INTO nguNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tla yacaj mechmacas masqui san se vaso atl pampa nennoyaxcahuan, melahuac quiselis itlaxtlahuil yejhuan Dios quimacas. ");
INSERT INTO nguNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’San aquinon yejhuan quitlajcalis ipan tlajtlacojli semej yejhuamej in pipitiquej yejhuan nechneltoca quiselis ihueyi tlahuel Dios. Más cuajli yesquia, ijcuac xe quichihua on tlajtlacojli, iquechtlan quipilohuilisquiaj se tetl yejhuan imetl on molino, niman contlajcalisquiaj ne ipan on mar. ");
INSERT INTO nguNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Niman tla moma mitzchihuilia titlajtlacohua, xtequi. Ijcon xchihua pampa más cuajli ticpias san se moma ijcuac ticalaquis ne ilhuicac xquen tiquimpias ome momahuan niman tias ne mictlan campa on tlitl tetlatij para nochipa, ");
INSERT INTO nguNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","niman campa on ocuilimej nochipa quicuasquej motlalnacayo, niman campa on tlitl xcaman sehuis. ");
INSERT INTO nguNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Niman tla mocxi mitzchihuilia titlajtlacohua, xtequi. Ijcon xchihua pampa más cuajli ticpias san se mocxi ijcuac ticalaquis ne ilhuicac, xquen tla tajsitias niman yej mitzontlajcalis ne mictlan, ");
INSERT INTO nguNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ne campa on ocuilimej nochipa quicuasquej motlalnacayo, niman on tlitl xcaman sehuis. ");
INSERT INTO nguNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Niman tla mixtololoj mitzchihuilia para titlajtlacohua, xquixti. Ijcon xchihua pampa más cuajli ticpias san se mixtololoj ijcuac ticalaquis ne campa Dios tlamandarohua, xquen tla tajsitias niman yej mitzontlajcalis ne mictlan, ");
INSERT INTO nguNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","campa on ocuilimej nochipa quicuasquej motlalnacayo, niman on tlitl xcaman sehuis. ");
INSERT INTO nguNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nochimej on yejhuan quintlatlatas on tlajtlacojli, quimatisquej sanoyej ohuijticaj, pero on Espíritu Santo yejhua quimpalehuis. ");
INSERT INTO nguNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","’Sanoyej cuajli on istatl para tlacuajli, pero ijcuac xoc poyec, xacaj ocsejpa hueli quichihuilia para poyeya. Xnemican cuajli sa no ijqui quen on istatl, niman xchantican inhuan ocsequimej ican yolsehuilistli. ");
INSERT INTO nguNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Quemaj Jesús oquis ompa, niman oyaj ne Judea, niman ne campa iquisayan tonaltzintli campaca on atentli itoca Jordán. Ompa ocsejpa miyec tlacamej onosentlalijquej, niman ocsejpa Jesús opeu quinmachtia ijcon quen nochipa quichihuaya. ");
INSERT INTO nguNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Niman sequimej fariseos oquinisihuijquej Jesús para quitlatlatasquej. Oquitlajtoltijquej: ―¿On tlanahuatijli cahuilia se tlacatl noxotonis ihuan isihuau? ");
INSERT INTO nguNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Quemaj Jesús oquinnanquilij, oquimijlij: ―¿Quen otlanahuatij Moisés? ");
INSERT INTO nguNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yejhuamej oquijlijquej: ―Itlanahuatil Moisés cahuilia se tlacatl quitlalia se amatl campa quijtohua ica noxotonia ihuan isihuau. ");
INSERT INTO nguNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús oquimijlij: ―Moisés oquitlalij on tlanahuatijli pampa on tlacamej sanoyej yoltechicajquej. ");
INSERT INTO nguNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero ijcuac Dios oquitlalij in tlalticpactli, oquitlalij se tlacatl niman se sihuatl. ");
INSERT INTO nguNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yejhua ica on tlacatl cahuas itaj niman inan para nosentlalis ihuan isihuau. ");
INSERT INTO nguNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ijcon, tej, on omemej sa se huajnochihuasquej quen se tlacatl. Ijcon, tej, yejhuamej xoc omemej, yej yonochijquej san se. ");
INSERT INTO nguNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yejhua ica ma ca yacaj tlacatl quixelos on tlen Dios oquinsentlalij. ");
INSERT INTO nguNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ijcuac oyajquej ne calijtic, on inomachtijcahuan ocsejpa quitlajtlanilijquej para ma quinmelajcaijlij on tlen oquimijlijcaj on fariseos. ");
INSERT INTO nguNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Quemaj oquimijlij: ―San aquinon yejhuan noxotonis ihuan isihuau niman nonamictis ihuan ocse sihuatl, yejhua sihuapajpatla. Yejhua tlajtlacohua itech ica on achtoj isihuau. ");
INSERT INTO nguNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Niman no tla se sihuatl noxotonis ihuan ihuehuentzin, niman nonamictis ihuan ocse tlacatl, yejhua tlacapajpatla. ");
INSERT INTO nguNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Quemaj sequimej oquinhuicaquej inconehuan para ma quinmatoca Jesús, pero on inomachtijcahuan opejquej quimajhuaj on yejhuan quinhuajhuicayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pero ijcuac Jesús oquitac, ocualan, niman oquimijlij: ―Xquincahuacan on coconej notech ma huajlacan, niman ma ca xquinteltican pampa yejhuan yolyemanquej quen in coconej calaquisquej ne campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ica tlen melahuac nemechijlia ica on yejhuan xquiselis itequihuayo Dios quen yacaj conetl, xqueman ompa calaquis campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Quemaj Jesús oquinnapaloj on coconej, niman oquintlalij imahuan impan, niman oquintiochiu. ");
INSERT INTO nguNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Niman chica Jesús quisaya, se tlacatl ohuajnotlaloj itech, niman onotlancuaquetz ixpan, niman oquitlajtoltij: ―Cuajli temachtijquetl, ¿tlinon nicchihuas para nicselis on nemilistli yejhuan para nochipa? ");
INSERT INTO nguNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús oquijlij: ―¿Tlica tiquijtohua ica nicuajli? Dios san yejhua iselti cuajli, niman tejhua ticnemilia ica nejhua xniDios. ");
INSERT INTO nguNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tejhua tiquimixmati itlanahuatilhuan Dios: “Ma ca xtemicti, ma ca xahuilnemi, ma ca xtlachtequi, ma ca yacaj xtlajtolquetztehuili, ma ca xtlacajcayahua, xtlacaita motaj niman monan.” ");
INSERT INTO nguNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","On tlacatl oquinanquilij: ―Temachtijquetl, nochi yejhua in desde niconetl nicuajtlacamatztiu. ");
INSERT INTO nguNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Niman Jesús ocontac, niman sanoyej oquitlajsojcaitac, niman oquijlij: ―Sanquen mitzpolohua se cosa. Xhuiya mochan niman xnamaca on tlen ticpia, niman on tomin xquinmaca on mayanquej. Tla ijcon ticchihuas, ticpias riquezas ne ilhuicac. Niman quemaj xhuajla nohuan, niman xmomamalti mocojnepanol. ");
INSERT INTO nguNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero ijcuac on tlacatl ijcon ocac, sanoyej onajman, niman oyaj onajmantiaj pampa sanoyej rico catca. ");
INSERT INTO nguNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Quemaj Jesús ocomintac iyehualican on inomachtijcahuan, niman oquimijlij: ―Sanoyej ohuijticaj para huelis Dios quinmandaros on yejhuan ricos. ");
INSERT INTO nguNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","On inomachtijcahuan sanoyej otlamojcaitaquej ica on tlinon oquimijlij Jesús. Pero Jesús ocsejpa oquimijlij: ―Noconehuan, sanoyej ohuijticaj para on tlacamej calaquisquej ne campa Dios tlamandarohua on yejhuan quitlaliaj inyojlo ne ipan inrriquezas. ");
INSERT INTO nguNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más ohuijticaj para se rico calaquis ne campa Dios tlamandarohua xquen para se camello panos ne campa tlacoyonia se aguja. ");
INSERT INTO nguNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","On inomachtijcahuan sanoyej omojcatlachixquej niman ijquin oquijtojquej: ―Tla ijcon, tej, ¿aquinon huelis maquisas? ");
INSERT INTO nguNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús oconmintac, niman oquimijlij: ―On tlacamej xhuelisquej nomaquixtisquej, pero Dios huelis quinmaquixtis pampa para Dios xitlaj ohuijticaj quichihua. ");
INSERT INTO nguNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Quemaj Pedro oquijlij Jesús: ―Xquita, tejhuamej yoticajquej nochi tlen ticpiayaj, niman tiquistinemij mohuan. ");
INSERT INTO nguNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús oquinanquilij: ―Ica tlen melahuac nemechijlia ica san aquinon yejhuan quicahuas ichan, icnihuan, itaj, inan, isihuau, iconehuan, noso itlalhuan, san nopampa niman ipampa on cuajli tlajtojli yejhuan quitemaca temaquixtilistli, ");
INSERT INTO nguNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","quiselis aman ipan in tlalticpactli se ciento más de yejhua on tlen ocajteu. Quiselis se ciento más caltin, icnihuan, inanhuan, iconehuan niman itlalhuan. Pero no quiselis tlahuejli niman tlajtlamach ica quitlajyohuiltisquej. Niman ipan on tonaltin yejhuan huajlau, quiselis nemilistli yejhuan para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aman miyequej on yejhuan huejhueyixtoquej, ompa xoc huejhueyixtiasquej. Niman miyequej on yejhuan xhuejhueyixtoquej, ompa yejhuamej huejhueyixtiasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Quemaj opeu nejnemiyaj tlejcotiayaj para Jerusalén. Jesús yaya ipan ojtli inyecapan on inomachtijcahuan, niman yejhuamej cuitlapanhuijtiayaj. Yejhuamej on inomachtijcahuan tlamojcaitayaj niman on ocsequimej tojlamej nomojtiayaj. Jesús oquinnotz on inomachtijcahuan niman ocsejpa oquimijlij on tlajtlamach tlinon ipan nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Oquimijlij: ―Xcaquican. Aman titlejcotihuij para Jerusalén campa nejhua aquin oninochiu Tlacatl nechtemactilisquej intech on tlayecanquej tiopixquej niman intech on temachtijquej ican itlanhuatil Dios. Yejhuamej nechtlajtlacolmacasquej para nechmictisquej, niman nechtemacajsquej intech on xhebreos. ");
INSERT INTO nguNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yejhuamej on xhebreos noca huetzcasquej, niman nechchijchasquej, niman nechhuihuitequisquej niman nechmictisquej. Niman quemaj ipan yeyi tonajli niyolihuis niman ninoquetztehuas ipan notlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Quemaj Jacobo niman Juan, iconehuan Zebedeo, oquinisihuijquej Jesús, niman oquijlijquej: ―Totemachtijcau, tejhuamej ticnequij xtechchihuili tlen nimitztlajtlanisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Niman Jesús oquimijlij: ―¿Tlinon nenquinequij ma nemechchihuili? ");
INSERT INTO nguNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Niman oquinanquilijquej: ―Xtechcahuili ma titotlalican monacastlan ijcuac tipehuas titlamandaros ican mohueyilis, se ipan moyecmacopa niman se ipan mopochmacopa. ");
INSERT INTO nguNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Niman Jesús oquimijlij: ―Xnenquimatij tlinon nenquitlajtlanij. ¿Nenhuelisquej nenquijyohuisquej on tlen nejhua niquijyohuis? ¿Nenhuelisquej nenquixicosquej tlajtlamach ijcon quen nejhua nicxicos? ");
INSERT INTO nguNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Quemaj oquinanquilijquej: ―Huelis titlajyohuisquej quen tejhua. Ijcuacon Jesús oquimijlij: ―Melahuac, nentlajyohuisquej ijcon quen nejhua, niman nenquixicosquej tlajtlamach ijcon quen nejhua. ");
INSERT INTO nguNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero yejhua on para nemotlalisquej noyecmacopa niman ipan nopochmacopa nejhua xnihuelis ompa nemechtlalis, yej ompa noTajtzin quintlalis on yejhuan yoquintlapejpenij. ");
INSERT INTO nguNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ijcuac on majtlactlimej nomachtijquej oquimatquej tlinon oquitlajtlanquej, sanoyej ocualanquej intechcopa Jacob niman Juan. ");
INSERT INTO nguNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Niman Jesús oquinnotz niman oquimijlij: ―Nemejhuamej ye nenquimatztoquej ica nemij xhebreos yejhuan huejhueyixtoquej, niman yejhuamej quinmandarohuaj ocsequimej tlayecanquej, niman yejhuamej in tlayecanquej tlamandarohuaj ipan on países xican teicnelilistli. ");
INSERT INTO nguNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero para nemejhuamej xijqui yes. Yej aquin quinequis hueyixtias nemotzajlan ica oncaj yejhua teserviros intech ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","San aquinon nensemej nemejhuamej yejhuan quinequis tlayecantias, ica oncaj yejhua tepalehuis quen se tlanamactli. ");
INSERT INTO nguNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pampa nejhua aquin oninochiu Tlacatl xonihuajlaj para nechtequipanosquej, yej para nitetequipanos niman nictlaxtlahuas ica nonemilis para niquinmaquixtis miyec tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Niman quemaj oajsiquej ne Jericó. Niman ijcuac Jesús ye quistiaya ipan on hueyican inhuan on inomachtijcahuan niman sanoyej miyequej tlacamej, se ciego, itoca Bartimeo, iconeu Timeo, yehuaticatca ne itenco on ojtli. Quinotlajtlanilijticatca tlanechicojli. ");
INSERT INTO nguNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Niman ijcuac ocac ica quitenehuayaj Jesús on yejhuan hualehua Nazaret, opeu tzajtzi: ―Jesús, huejca teixhuiu ne itech David, xnechicneli. ");
INSERT INTO nguNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Miyequej tlacamej ocajhuaquej niman oquijlijquej para ma ca sa ma nahuati. Pero yejhua más chicahuac tzajtziya: ―Huejca teixhuiu ne itech David, xnechicneli. ");
INSERT INTO nguNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ijcuacon Jesús onoteltij, niman oquijtoj: ―Xquijlican ma huajla nican. Quemaj oquinotzatoj, niman oquijlijquej: ―Xmoyolchicahua. Xmotelquetza. Yejhua mitznotza. ");
INSERT INTO nguNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Quemaj on ciego ompa oquichapanij on igaban, onotelquetz, niman oyaj ne campa nemi Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús oquitlajtoltij: ―¿Tlinon ticnequi ma nimitzchihuili? On ciego oquijlij: ―Temachtijquetl, xchihua para ma nitlacha. ");
INSERT INTO nguNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Niman Jesús oquijlij: ―Xhuiya. Aman tihueli titlacha pampa oticneltocac ica nimitzpajtisquia. Quemaj nimantzin on tlacatl ohuel otlachix, niman oyaj ihuan Jesús neca ipan ojtli. ");
INSERT INTO nguNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús oquinisihuij Jerusalén ne ipan on tepetl itoca Olivos campa oncatcaj on pueblitos itoca Betfagé niman Betania. Ijcuacon oquintitlan omemej inomachtijcahuan, ");
INSERT INTO nguNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","niman oquinmijlij: ―Xhuiyan ne ipan on pueblito yejhuan oncaj ne tlayecapan. Niman ijcuac nemoncalactiasquej, nenquitasquej salijticaj se polocotzin yehuan xqueman yacaj ipan tlejcohua. Xtojtomacan, tej, niman xnechajhuiquilican. ");
INSERT INTO nguNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tla yacaj mechijlia: “¿Tlica nenquitojtomaj?” xquijlican ica nemoTeco quinequi niman ica nimantzin cuajtitlanis. ");
INSERT INTO nguNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","On omemej inomachtijcahuan oyajquej, niman oquinextijquej on polocotzin salijticaj ne ipan ojtli quiahuatenco, niman quemaj oquitojtonquej. ");
INSERT INTO nguNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Niman sequimej tlacamej yejhuan nemiya ompa oquintlajtoltijquej on inomachtijcahuan Jesús: ―¿Tlica nenquitojtomaj on polocotzin? ");
INSERT INTO nguNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yejhuamej on inomachtijcahuan oquiteijlijquej ijcon quen oquimijlij Jesús. Niman quemaj on tlacamej oquincahuilijquej para ma cuicacan. ");
INSERT INTO nguNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Niman ocuajhuicaquej on polocotzin ne itech Jesús. Ijcuacon yejhuamej oquitlalijquej intlaquen ipan on polocotzin, niman quemaj Jesús otlejcoc ipan. ");
INSERT INTO nguNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Niman miyequej oquisojquej intlaquen ipan ojtli, niman sequimej oquitejtequej inxojyo on cojtin ");
INSERT INTO nguNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","On yejhuan yayaj ne tlayecapan, niman on yejhuan yayaj ne tlacuitlapan opeu tzajtzij: ―Ma noyectenehua Dios. Ma Dios quitiochihua on yejhuan ocuajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ma Dios quitiochihua on yejhuan huajlau para techmandaros cuajli quen otlamandaroj David ye huejcahui. ¡Ma Dios ne ilhuicac noyectenehua! ");
INSERT INTO nguNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Niman ocalac Jesús ne ipan on hueyican Jerusalén, niman quemaj oyaj ne calijtic ipan on hueyi tiopan. Ompa oquitac nochi tlen quichijticatcaj. Niman pampa sanoyej, niman oquitlalijquej neca ipan ojtli. ye tiotlac catca, oyaj ne Betania inhuan on inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Huajmostla ocsejpa oquisquej ne Betania, niman ne ipan ojtli Jesús apismiquiya. ");
INSERT INTO nguNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jesús ocontac ne huejca se cojtli, itoca higuera, niman xojyo catca. Yejhua oyaj ne para quitas tla quipia itlaquilyo. Ijcuac oquinisihuij on cojtli, xoquinextilij itlaquilyo, yej san ixojyo pampa ijcuacon xe tiempo catca para quipias itlaquilyo. ");
INSERT INTO nguNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Quemaj oquijlij on cojtli: ―Ma ca sa queman yacaj quicuas motlaquilyo. Niman on inomachtijcahuan ocacquej. ");
INSERT INTO nguNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Quemaj oajsiquej ne Jerusalén niman Jesús ocalaquito ne iquiahuac on hueyi tiopan. Yejhua opeu quinhuajquixtia on yejhuan ompa tlanamacayaj niman tlacohuayaj. Oquinxixinilij inmesas on yejhuan quitepatiliayaj tomin, niman insietas on yejhuan quinnamacayaj palomas. ");
INSERT INTO nguNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesús xquitecahuiliaya para yacaj ma quitqui itlaj ne ipan on hueyi tiopan. ");
INSERT INTO nguNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Quemaj Jesús oquinmachtij on tlacamej: ―Ye nenquimatztoquej tlinon quijtohua in Yectlajcuilojli: “Nochan itoca yes cajli campa nochihua oración para nochimej on tlacamej chanejquej ipan nochi países”, pero nemejhuamej yonencuepquej campa on tlachtequej nosentlaliaj. ");
INSERT INTO nguNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Quemaj on tlayecanquej tiopixquej niman on temachtijquej ican itlanhuatil Dios ocacquej, niman quemaj opejquej quitejtemohuaj quen ijqui quimictisquej. Yejhuamej sanoyej nomojtiayaj, pampa oquimatquej ica nochimej on tlacamej cuelcaquiyaj on itemachtil Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ijcuac otlayohuac, Jesús niman on inomachtijcahuan oquisquej ipan on hueyican. ");
INSERT INTO nguNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Huajmostla cualcan oyajquej, niman oquitaquej ica on higuera yohuac hasta ipan inelhuayo. ");
INSERT INTO nguNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ijcuacon Pedro oquelnamic quen Jesús ocajhuac on cojtli, niman oquijlij: ―Notemachtijcau, xquita on higuera yejhuan oticajhuac para ma ca sa tlaquis. Aman yejhua yohuac. ");
INSERT INTO nguNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Quemaj Jesús oquimijlij: ―Xtlaneltocacan itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ica tlen melahuac nemechijlia, san aquinon quijlisquia yejhua on tepetl: “Xmejcuani nican niman xcalaqui ne ijtic on mar”, niman xometlamatztias ipan iyojlo, on tlen quijtos nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yejhua ica nemechijlia ica nochi on tlen nenquitlajtlanij ijcuac nenquichihuasquej oración, xneltocacan ica nenquiselisquej, niman nenquipiasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Niman no ijqui, tej, ijcuac nenquichihuasquej oración, xtlapojpolhuican on yejhuan mechchihuiliaj on tlen xcuajli, para ijcon on nemoTajtzin yejhuan nemi ne ilhuicac no mechtlapojpolhuis ica nemotlajtlacol. ");
INSERT INTO nguNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tla nemejhuamej xnentetlapojpolhuiyaj, yejhua no xmechtlapojpolhuis. ");
INSERT INTO nguNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Quemaj ocsejpa oajsiquej ne Jerusalén. Niman chica Jesús ompa quistinemiya ne ipan on hueyi tiopan, oquinisihuijquej intlayecancahuan on tiopixquej niman on temachtijquej ican itlanahuatil Dios niman on tlajtlajmatquej. ");
INSERT INTO nguNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Niman oquitlajtoltijquej: ―¿Tlen tequihuajyotl ticpia para ticchihua yejhua on tlajtlamach? ¿Aquinon, tej, omitzmacac yejhua on tequihuajyotl ica oticchiu on tlajtlamach? ");
INSERT INTO nguNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Quemaj Jesús oquimijlij: ―Nejhua no nicpia tlen nemechtlajtoltis. Tla nennechijlisquej, nejhua no nemechijlis ican tlen tequihuajyotl nicchihua in tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Xnechijlican, ¿aquinon ocuajtitlan Juan para otlacuatequij? ¿Dios ocuajtitlan noso on tlacamej ocuajtitlanquej? ");
INSERT INTO nguNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Quemaj yejhuamej opejquej ijquin quinochtacatlajtlajtoltiayaj: ―¿Quen ijqui tiquijlisquej? Tla tiquijtosquej ica Dios ocuajtitlan, yejhua ijquin techijlis: “Tla ijcon, ¿tlica xonenquineltocaquej on tlen Juan oquijtoj notechica?” ");
INSERT INTO nguNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Niman xhueli tiquijtohuaj ica on tlacamej ocuajtitlanquej Juan. Yejhuamej nomojtiayaj, pampa nochimej quijtohuayaj ica Juan melahuac se tiotlajtojquetl catca. ");
INSERT INTO nguNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yejhua ica oquijlijquej Jesús: ―Xticmatij aquinon ocuajtitlan. Quemaj oquimijlij: ―Yejhua ica nejhua no xnemechijlis aquinon onechmacac tequihuajyotl ica nicchihua in tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Quemaj Jesús opeu quintlaliliaj ejemplos, oquimijlij: ―Sen tlalejquetl oquitocac miyec uvas. Quemaj ocorraltij niman oquichijchiu se pilaj campa quipatzcasquej on uvas. Niman no oquichijchiu se torre para huelis quitlajpias on itlal. Niman quemaj oquinnextij sequimej medieros yejhuan tehuan tlaxelohuaj para quitlajpiasquej on uvas. Quemaj on tlalejquetl onejcuanij niman oyaj ipan ocse país. ");
INSERT INTO nguNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ijcuac oyejcoc on tonaltin para quitequisquej on uvas, on tlalejquetl oquititlan se itequichihuilijcau para ma quintlajtlaniliti on medieros on quech yejhua quitocarohua quiselis. ");
INSERT INTO nguNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero yejhuamej ocajsiquej, niman oquimajmailijquej on tequichihuilijquetl. Ocontitlanquej niman xitlaj oquimacaquej. ");
INSERT INTO nguNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Quemaj on tlalejquetl oquititlan ocse itequichihuilijcau, niman on tlacamej oquitemojmotlaquej ipan itzontecon niman oquipijpinajtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Quemaj on tlalejquetl oquititlan ocse itequichihuilijcau, niman on medieros oquimictijquej. Miyequej ocsequimej no ijqui oquinchihuilijquej. Sequimej oquinmajmailijquej, niman sequimej oquinmictijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’On tlalejquetl sa iconeu itech ohuajnocau, yejhuan sanoyej quitlajsojtlaya. Quemaj sa ye ica quej yejhua oquititlan. On tlalejquetl quinemiliaya: “In noconeu quemaj quitlacaitasquej.” ");
INSERT INTO nguNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero ijcuac on teconeu oajsic ne ipan on tlatocyo ican uvas, on medieros oquijtojquej: “Yejhua in iconeu on tlalejquetl. Ijcuac miquis itaj, yejhua yes iyaxca nochi in tlajli. Aman ma ticmictican iconeu niman in tlajli toyaxca yes.” ");
INSERT INTO nguNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Quemaj ocajsiquej, oquimictijquej, niman itlalnacayo oquixtijquej ne ipan on tlatocyo ican uvas. ");
INSERT INTO nguNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Quemaj Jesús oquintlajtoltij: ―Aman, tej, iteco on tlatocyo ican uvas, ¿tlinon quinchihuilis on xcuajcualtin medieros? Yejhua, tej, yas niman quinmimictis on medieros, niman on tlatoctli ocsequimej quinmacas. ");
INSERT INTO nguNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nemejhuamej cuajli nenquimatij quen ijqui quijtohua on tiotlajtojli: On tetl yejhuan on tepanchijquej xoquiselijquej, aman yejhua yonotlalij yacatztica. ");
INSERT INTO nguNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yejhuan in ijqui oquitlalij on toTeco niman ticmojcaitaj tlen tiquitaj. ");
INSERT INTO nguNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","On tlayecanquej intech on hebreos quinequiyaj cajsisquej Jesús para quitzacuasquej, pampa quimatzticatcaj ica on ejemplo oquintenehuilij yejhuamej. Pero xocajsiquej, pampa nomojtiayaj quincualanisquej on tlacamej. Yejhua ica ocajtejquej niman xitlaj oquichihuilijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Quemaj oquintitlanquej sequimej fariseos niman sequimej herodianos para quichihualtisquej Jesús quijtos itlaj ican itlajtol yejhuan huelis ica quiteixpanhuisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yejhuamej ohualajquej, niman oquijlijquej Jesús: ―Temachtijquetl, ticmatztoquej ica nochipa tiquijtohua on tlen melahuac. Tejhua xtictencaqui on tlen quijtohuaj motech ica on tlacamej masqui huejhueyixtoquej. Yej melahuac ticteititia quen Dios quinequi ma titohuicacan. Xtechijli, ¿itlanahuatil Moisés techcahuilia titlatlaxtlahuasquej ican impuestos itech César yejhuan itequihuaj on país de Roma? ¿Tontlatlaxtlahuasquej, noso xtontlatlaxtlahuasquej? ");
INSERT INTO nguNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús oquitac inyojlo ica omexayacyejquej. Yejhua ica oquimijlij: ―¿Tlica nennechchihualtisnequij ma nemechijli itlaj yejhuan ica huelis nennechteixpanhuisquej? Xnechajcuilican se tomin para ma niquita. ");
INSERT INTO nguNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yejhuamej ocuajquiquej se tomin, niman Jesús oquintlajtoltij: ―¿Aquinon ixayac yejhua in, niman aquinon itocayo in nican tlajcuilolnesticaj ipan in tomin? Yejhuamej oquinanquilijquej: ―On tequihua César yejhuan quimandarohua nochi on país itoca Roma. ");
INSERT INTO nguNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Quemaj Jesús oquimijlij: ―Xmacacan César on tlen yejhua iyaxca, niman xmacacan Dios on tlen yejhua iyaxca. Yejhuamej sanoyej otlamojcaitaquej ijcon quen oquinnanquilij. ");
INSERT INTO nguNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Niman oquitacoj Jesús sequimej saduceos yejhuan quijtohuaj ica xhuelis yolihuisquej on mimiquej. Quemaj oquijlijquej: ");
INSERT INTO nguNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Temachtijquetl, Moisés oquijcuiloj para tejhuamej ica tla yacaj icniu miqui niman cajtehua isihuau, niman tla xitlaj iconeu cajtehua, icniu ihuan nonamictis isihuau niman ma yejhua tlaxinacho quen icniu yesquia. ");
INSERT INTO nguNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aman, tej, nemiyaj chicomemej icniutin yejhuan tlacamej. Yejhua on yejhuan yencuiyotl ononamictij, pero omic niman xitlaj iconeu ocajteu. ");
INSERT INTO nguNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yejhua ica on ica ome teicniu no ihuan ononamictij, niman no omic. Nion yejhua xocajteu iconeu. No ijqui opanoc on ica yeyi teicniu. ");
INSERT INTO nguNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Niman no ijqui opanoc inhuan on ocsequimej hasta ijqui otlanquej on chicomemej. Niman nochimej inhuan ononamictijquej, pero xoquipixquej inconeu. Niman quemaj on sihuatl no omic. ");
INSERT INTO nguNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Xtechijli, ijcuac yolihuilos, ¿catlejhua itech tesihuau yes de yejhuamej on chicomemej icniutin, pampa nochimej oquipixquej quen insihuau? ");
INSERT INTO nguNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús oquimijlij: ―Nenquijnehuaj pampa xnenquimatij tlinon quijtohua on Yectlajcuilojli, nion nenquimatij ica Dios nochi hueli quichihua. ");
INSERT INTO nguNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ijcuac on mimiquej yolihuisquej, xnonamictisquej nion on tatajtin quitemacasquej imichpochhuan para ma nonamictican. Ijcuacon nemisquej quen iilhuicactequitcahuan Dios yejhuan nemij ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Niman aman on ica yolisquej niman noquetztehuasquej on mimiquej, ¿xnenquimomachtianij iamau Moisés campa oquijcuiloj on tiotlajtojli ica Dios nemiya ne ijtic on tlacotepajsojli, niman oquinotz Moisés? Oquijlij ijquin: “Nejhua niiDios Abraham, niman niiDios Isaac, niman niiDios Jacob.” ");
INSERT INTO nguNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios oquijtoj ijquin saquin ijcuac yomiquej yejhuamej on tlacamej, pero Dios xejhua inDios on mimiquej. Yejhua inDios on yoltoquej. Nemejhuamej yejhua in ica nenquipolohuaj sanoyej. ");
INSERT INTO nguNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ohuajlaj se temachtijquetl ican itlanhuatil Dios, niman yejhua ocac quen ijqui notencuicuiyaj Jesús. Yejhua ocac ica Jesús cuajli otlananquilij. Yejhua ica on temachtijquetl oquitlajtoltij: ―¿Catlejhua más hueyi quijtosnequi on tlanahuatijli de nochi? ");
INSERT INTO nguNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús oquinanquilij: ―On tlanahuatijli yejhuan más hueyi quijtosnequi yejhua in: “Xcaquican tlacamej yejhuan huajlehuaj ne Israel. ToTeco Dios, yejhua san se. ");
INSERT INTO nguNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Xtlajsojtla on moTeco Dios ican nochi moyojlo, ican nochi moalma, ican nochi motlamachilis, niman ican nochi mochicahualis.” Yejhua in, tej, tlanahuatijli yejhuan más hueyi quijtosnequi. ");
INSERT INTO nguNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Niman on ica ome tlanahuatijli san yejhua in: “Xquintlajsojtla ocsequimej no ijqui quen tejhua timotlajsojtla.” Xitlaj ocse tlanahuatiltin yejhuan más hueyi quijtosnequi quen yejhua in ome. ");
INSERT INTO nguNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","On temachtijquetl ican itlanahuatil Dios oquijlij Jesús: ―Temachtijquetl, otiquijtoj cuajli. Melahuac, san se Dios nemi, niman xacaj ocse Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tla tictlajsojtlasquej Dios ican nochi toyojlo, ican nochi totlamachilis, ican nochi toalma niman ican nochi tochicahualis, niman tla tictlajsojtlasquej nochi tlacatl ijcon quen tejhuamej titotlajsojtlaj, yejhua ica in más ticpactiaj Dios xquen itlaj huentli tictlatisquiaj noso itlaj ica titlamanasquiaj. ");
INSERT INTO nguNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ijcuac Jesús oquitac ica cuajli oquinanquilij, oquijlij: ―San polihui achijtzin para timotemacas itech Dios para yejhua mitzmandaros. Niman xoc yacaj onoyolchicau para itlaj quitlajtoltis. ");
INSERT INTO nguNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Quemaj ijcuac Jesús temachtiaya ne ipan on hueyi tiopan, quijtohuaya: ―¿Tlica on temachtijquej ican itlanahuatil Dios quijtohuaj ica Cristo, yejhuan Dios oquitlapejpenij para temandaros, yejhua teconeu ne itech David? ");
INSERT INTO nguNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sa no yejhua David oquimelajcaijtoj ican on Espíritu Santo: NoDios oquijlij noTeco: “Xmotlali nican ipan noyecma hasta queman nimitztlalis tlayecanquetl intech on yejhuan motlahuelicnihuan.” ");
INSERT INTO nguNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tla David ijcon oquijtoj ica Cristo yejhua iTeco, tla ijcon, tej, ¿quen ijqui Cristo hueli huejca teixhuiu itech David? Niman on tlacamej sanoyej miyequej quicaquiyaj ican pactli. ");
INSERT INTO nguNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yejhua más quinmachtiaya, oquimijlij: ―Xmotacan sa no nemejhuamej intech on temachtijquej ican tlanahuatijli yejhuan cuelitaj tlaquenhuejhueyac quistinemij. Yejhuamej cuelitaj quistinemisquej ican intlaquen huejhueyaquej para nochi tlacatl quinemilis ica on temachtijquej ican itlanahuatil Dios sanoyej hueyixticaj. Niman cuelitaj ijcuac tlacamej quintlajpalohuaj neca ipan plaza. ");
INSERT INTO nguNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yejhuamej no quinequij on más cuajcualtin sietas, ne ipan on tiopantin. Niman quinequi quipiasquej on yejhuan más huejhueyixtoquej sietas ne campa ilhuipan. ");
INSERT INTO nguNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Niman quinchancuiliaj on sihuacahualtzitzintin, niman quichihuaj oración sanoyej huejcahuij para on tlacamej ma cuajli tlanemilican intech. Yejhuamej, tej, quiselisquej más hueyi castigo. ");
INSERT INTO nguNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús yehuaticatca ne nisiu itech on caja ne ipan on hueyi tiopan campa contlaliaj on huentomin. Ompa oquintac on tlacamej concajticatcaj inhuentomin. Miyequej yejhuan ricos conxinijticatcaj miyec tomin. ");
INSERT INTO nguNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","No ohuajlaj se sihuacahualtzintli mayanqui. Ocahuaco ome centavito, sanoyej achijtzin tomin. ");
INSERT INTO nguNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Quemaj Jesús oquinnotz on inomachtijcahuan, niman oquimijlij: ―Ica tlen melahuac nemechijlia ica yejhua in mayanqui sihuacahualtzintli más hueyi oquitlalij ihuentomin xquen nochimej ocsequimej yejhuan yocahuacoj intomin ipan on caja. ");
INSERT INTO nguNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yejhuamej on yejhuan ricos quitemacaj san yejhua on tlen yoquinsobraroj. Pero in sihuatl, masqui mayanqui, oquitemacac nochi hasta on tlen ica nopanoltisquia. ");
INSERT INTO nguNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ijcuac Jesús huajquistiaya ne ipan on hueyi tiopan, se on inomachtijcau oquijlij: ―Notemachtijcau, xquita. Sanoyej huejhueyimej on temej yejhuan ica tlachijchiutin on caltin niman sanoyej huejhueyimej on caltin. ");
INSERT INTO nguNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ijcuacon Jesús oquijlij: ―¿Tiquinta in huejhueyimej caltin? Nican xnocahuas nion se tetl tlapani ipan ocse pampa nochi quixoxotonisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Niman ijcuac yehuaticatca Jesús ne ipan on tepetl itoca Olivos ne ixpan on hueyi tiopan, Pedro, Jacobo, Juan niman Andrés san iseltimej oquitlajtoltijquej: ");
INSERT INTO nguNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Xtechijli, ¿quemanon ijcon nochihuas on tlajtlamach, niman tlen tlamajhuisojli noteititis ijcuac in tlajtlamach ye pehuas nochihuas? ");
INSERT INTO nguNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús opeu quinmachtia, oquimijlij: ―Xmotacan sa no nemejhuamej para ma ca yacaj mechcajcayahuas, ");
INSERT INTO nguNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","pampa miyequej huajlasquej yejhuan ican noTocatzin cualijtojtiasquej: “Nejhua niCristo.” Niman yejhuamej quincajcayahuasquej miyequej. ");
INSERT INTO nguNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Niman ijcuac nencaquisquej ica oncaj guerras nisiu niman no neca huejca, ma ca xmoyolpajsolocan. Tej, nochi on ica oncaj achtopa nochihuas. Pero ijcuac ijcon nochihuas, oc xejhua tiempo para ipan in tlalticpactli tlatlajtlamis. ");
INSERT INTO nguNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","On tequihuaquej nohuijsoquisquej inhuan ocsequimej tequihuajquej, niman on países nohuijsoquisquej inhuan ocsequimej países, niman tlalolinis miyecan, niman onyas apistli. Pero in xica nochi yes, yej más onyas tlajyohuilistli. ");
INSERT INTO nguNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Xmotacan sa no nemejhuamej, pampa san nopampa semej nemejhuamej mechtemacasquej ne intech on tequihuajquej, niman semej nemejhuamej mechhuihuitequisquej ne ipan intiopanhuan on hebreos, niman semej nemejhuamej mechhuicasquej san nopampa ne intech on presidentes niman intech on reyes. Ijcuacon noca nentenojnotzasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","On cuajli tlajtojli yejhuan quitemaca temaquixtilistli achtoj noteijlis nochihuiyan, niman quemaj tlatlajtlamis. ");
INSERT INTO nguNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Niman ijcuac mechajhuicasquej niman mechtemacasquej ne intech on tequihuajquej, ma ca sa xcomatztiacan tlinon nenquijtosquej, niman ma ca xnemilijtiacan. Xquijtocan tlinon Dios mechmacas para nenquijtosquej ipan on hora, pampa xnemejhuamej nentlajtosquej, yej tlajtos on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sequimej quintemacasquej imicnihuan para ma quinmictican pampa nechneltocaj. Niman sequimej tatajtin no ijqui quintemacasquej iconehuan para ma quinmictican pampa nechneltocaj. Niman on teconehuan noquetztehuasquej impan on tatajtin niman nanantin, niman no quintemacasquej para quinmictisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nochi tlacatl mechtlahuelitas san pampa nennechneltocaj. Pero on yejhuan quixicos nochi, on yejhua maquisas. ");
INSERT INTO nguNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Nenquitasquej nochihuas yejhua on tlen xcuajli tlaijtlacohua niman on tlen tetzinquixtia quitlalisquej ne campa xquitocarohua para nemis ijcon quen on tiotlajtojquetl Daniel oquijcuiloj. (Ijcuac timomachtis, xcajsicamati sanoyej cuajli.) Quemaj on yejhuan nemisquej ne Judea, ma ontlatlacsacan neca ipan tepeyoj. ");
INSERT INTO nguNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Niman on yejhuan ipan on tonajli nemis ne icuatipan on cajli, ma ca huajtemos para concuis itlaj ne icalijtic. ");
INSERT INTO nguNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Niman on yejhuan nemis ne ipan imil ixtlahuacan, ma ca nocuepas ichan para concuis itlaj itlaquen. ");
INSERT INTO nguNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sanoyej xcuajli yes para on sihuamej yejhuan ipan on tonaltin yocanquej inconeu, niman on sihuamej yejhuan ipan on tonaltin tlachichitisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Xchihuacan oración niman xtlajtlanilican Dios para ma ca nochihuas ijcuac sanoyej sehua, ");
INSERT INTO nguNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","pampa ijcuacon sanoyej miyec onyas tlajyohuilistli quen yejhuan xqueman oncaj desde ijcuac Dios oquitlalij in tlalticpactli, niman xqueman yes. ");
INSERT INTO nguNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pero toTeco xcahuilis para on tlacamej tlajyohuisquej miyec tonaltin pampa quimicnelis on yejhuan yoquintlapejpenij. Tla yejhua quincahuilisquia tlajyohuisquiaj miyec tonaltin, nochimej miquisquiaj. ");
INSERT INTO nguNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Niman tla ijcuacon yacaj mechijlis: “Xquitacan, nican nemi Cristo”, noso “Xquitacan, ompa on nemi”, ma ca xneltocacan. ");
INSERT INTO nguNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ma ca xneltocacan pampa huajlasquej on tlacajcayajquej yejhuan notenehuasquej Cristos noso tiotlajtojquej. Niman yejhuamej quichihuasquej on tlamajhuisoltin niman milagros para tecajcayahuasquej niman hasta on yejhuan Dios yoquintlapejpenij. Pero yejhuamej xhuelisquej quincajcayahuasquej on yejhuan Dios yoquintlapejpenij. ");
INSERT INTO nguNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Xmotacan sa no nemejhuamej. Xquipia tlica nenhuetzisquej pampa ye nemechmachiltijticaj nochi tlen nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ijcuac yopanoquej on tonaltin ican tlajyohuilistli, xoc tlahuilos on tonaltzintli niman on metztli xoc petlanis. ");
INSERT INTO nguNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","On sitlalimej huajxinisquej ne ipan cielo, niman hasta on tlen cojtilijticaj on cielo nolinis. ");
INSERT INTO nguNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","’Niman quemaj nechitasquej nejhua yejhuan oninochiu Tlacatl, nihuajlas ipan on moxtli ican nohueyi poder niman ican nohueyilis. ");
INSERT INTO nguNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Niman quemaj niquinhuajtitlanis on noilhuicactequitcahuan para quinsentlalisquej nochimej on yejhuan Dios yoquintlapejpenij nochihuiyan ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Xcajsicamatican in ejemplo itech on higuera. Ijcuac on imahuan seliaj, niman quisa on ixouyo, nemejhuamej nenquimatij ica ye nisiu xopantlaj. ");
INSERT INTO nguNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sa no ijqui in, ijcuac nenquitasquej nochi yejhua in tlajtlamach ye nochijticaj, xmatican ica ye nisiu para nihuajnocuepas ocsejpa. ");
INSERT INTO nguNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ica tlen melahuac nemechijlia ica nochi in tlajtlamach nochihuas ijcuac xe miquij on tlacamej yejhuan nemij ipan in tiempo. ");
INSERT INTO nguNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","On cielo niman in tlalticpactli popolihuis, pero notlajtol xqueman popolihuis. ");
INSERT INTO nguNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’On tonajli niman on hora ijcuac tlatlalpolihuis xacaj quimati, nion yejhuamej on ilhuicactequitquej ne ilhuicac nemij, nion nejhua, yejhuan niiConeu Dios. Yej san noTajtzin quimati. ");
INSERT INTO nguNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’¡Xmotacan sa no nemejhuamej! Xtlachixtiacan niman xchihuacan oración, pampa xnenquimatij quemanon yejcos on tonajli. ");
INSERT INTO nguNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","In sa no ijqui quen se tlacatl yejhuan cajtehua ichan niman ompaxalohua sanoyej huejca. Niman quinnajnahuatitehua on itlaquehualhuan, niman quinmajmaca tequitl, niman ocse tlacatl cajtehua ne quiahuatenco para ma tlajpia. ");
INSERT INTO nguNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Oquimijlij iteco on cajli: “Xtlachixtiacan, tej, pampa xnenquimatij quemanon nejcos, tla tlayohua, noso tlajcoihuan, noso ijcuac tzajtzitoquej on caxtiltin, noso ijcuac yotlanes.” ");
INSERT INTO nguNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Xtlachixtiacan, tej, para ma ca san isicapan nihuajnocuepas ijcuac xnennechchixtoquej, niman nemechnextijtejcos nencochij. ");
INSERT INTO nguNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Niman in tlajtlamach tlen nemechijlia, nochi tlacatl niquijlia: “Ma tlachixtiacan.” ");
INSERT INTO nguNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ipan ome tonajli ilhuitl yes itoca pascua. Ipan on ilhuitl quicuaj pan yejhuan xquipia tlaxocolilistli. Niman intlayecancahuan on tiopixquej niman on temachtijquej ican itlanahuatil Dios ichtaca quitejtemohuiliayaj quen ijqui cajcayahuasquej Jesús para cajsisquej, niman quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero quijtohuayaj ma ca ipan on ilhuitl para ma ca on tlacamej najcomanasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús nemiya ne Betania ichan Simón on yejhuan oquipatijca ijcuac palaniya inacayo. Niman ijcuac yehuaticatca ne ipan mesa, ohuajlaj se sihuatl. Ocuajquic se on quen itlaj botella yejhuan tlachijchiutli ican tetl fino. On botella tentiaya ican on ajhuiyalistli itoca nardo yejhuan sanoyej patioj. Quemaj yejhua oquitlapan on botella para oquitlapoj, niman oquitequilij Jesús ipan itzontecon. ");
INSERT INTO nguNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pero sequimej yejhuan ompa nemiyaj ocualanquej, niman quinnojliayaj: ―¿Tlica oixpoliu in ajhuiyalistli? ");
INSERT INTO nguNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","In huelisquia nonamacasquia para notlanisquiaj tomin canaj sa no ijqui quen quitlani se tlacatl tla tequiti se xipan. Niman ica on tomin tiquimpalehuisquiaj on mayanquej. Niman yejhuamej cajhuayaj on sihuatl. ");
INSERT INTO nguNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Jesús oquimijlij: ―Xcahuacan, ¿Tlica nenquipajsolohuaj? Yejhua in tlen yejhua nechchihuilia sanoyej cuajli. ");
INSERT INTO nguNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nemejhuamej nochipa nemotzajlan nenquimpiasquej on mayanquej, niman san quemanon nenquinequisquej huelis nenquinchihuilisquej cuajli. Pero nejhua xnochipa nican nennechpiasquej nemohuan. ");
INSERT INTO nguNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","In sihuatl oquichiu hasta campa ohuel. Yejhua yonachtojhuij ica yocajhuiyalij notlalnacayo para nechtlaltocasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ica tlen melahuac nemechijlia ica nochihuiyan ipan in tlalticpactli campa noteijlis on temachtilistli yejhuan quitemaca temaquixtilistli, no noteijlis on tlen oquichiu in sihuatl para yejhua quelnamiquisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ijcuacon Judas Iscariote, se on ica majtlactli huan ome inomachtijcahuan Jesús, oyaj intech intlayecancahuan on tiopixquej para oquintlajtlatohuilito quen ijqui huelis quinmactilis Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ijcuac yejhuamej ijquin ocacquej, yejhuamej sanoyej opacquej, niman onotlajtolmacaquej para Judas quimacasquej tomin. Quemaj Judas opeu quitejtemohua quen ijqui quitemactilis Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ipan on achtoj tonajli ica on ilhuitl, ijcuac nocuaya on pan yejhuan xquipia tlaxocolilistli, niman ijcuac quihuentlaliaj on borreguito, on inomachtijcahuan Jesús oquitlajtoltijquej: ―¿Canon ticnequi ma tihuiyan niman ma timitzcuectlalilitij on tlacuajli yejhuan ticuas ipan in ilhuitl pascua? ");
INSERT INTO nguNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Quemaj oquintitlan omemej inomachtijcahuan, niman oquimijlij: ―Xhuiyan ne ipan on hueyican, niman ompa nenquinamiquisquej se tlacatl yejhuan quitqui se tzotzocojli ican atl. Xhuiyan ihuan. ");
INSERT INTO nguNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Niman ne campa calaquis, xquijlican iteco on cajli: “On Temachtijquetl quijtohua: ¿canon oncaj on calijtic campa nicuas on tlajcuajli ipan on ilhuitl pascua inhuan nonomachtijcahuan?” ");
INSERT INTO nguNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Niman yejhua mechititis se hueyi calijtic ye listo ne ipan on sa ica nochi caltlanepantli tlacpac. Ompa, tej, xchihuacan on tlacuajli. ");
INSERT INTO nguNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","On inomachtijcahuan oyajquej ne ipan on hueyican, niman ijqui oquinextijquej quen Jesús oquimijlij. Ompa, tej, ocuectlalijquej on tlacuajli para tlacuasquej ipan on ilhuitl pascua. ");
INSERT INTO nguNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ijcuac yotlayohuac, oajsic Jesús inhuan on majtlactli huan omemej nomachtijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Niman ijcuac nemiyaj ne ipan mesa tlacuayaj, Jesús oquimijlij: ―Ica tlen melahuac nemechijlia ica semej nemejhuamej nechtemactilis. Yejhua nican tlacuajticaj nohuan. ");
INSERT INTO nguNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Quemaj yejhuamej sanoyej onajmanquej, niman opejquej quitlajtoltiaj Jesús sesentemej: ―¿Tlen manin nejhua? Niman ocse no oquijtoj: ―¿Tlen manin nejhua? ");
INSERT INTO nguNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús oquimijlij: ―Semej nemejhuamej nenmajtlactli huan ome yejhuan quipatzohua on pan ipan on plato campa nejhua nicpatzohua on pan. ");
INSERT INTO nguNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nejhua yejhuan oninochiu Tlacatl nimiquis ijqui quen quijtohua on Yectlajcuilojli, pero lástima para on yejhuan nechtemactilis. Más cuajli yesquia tla xqueman tlacatisquia. ");
INSERT INTO nguNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chica tlacuajticatcaj, Jesús ocontilan on pan, niman oquimacac tlaxtlahuijli Dios. Niman quemaj ijcuac yoquitlatlapan, oquinmacac on inomachtijcahuan. Oquimijlij: ―Xcuacan. In pan yejhua quixnescayotia notlalnacayo. ");
INSERT INTO nguNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Niman quemaj ocontilan on copa niman oquimacac tlaxtlahuijli Dios. Niman quemaj oquinmacac on inomachtijcahuan, niman nochimej oconiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Niman oquimijlij: ―In tlen nenconisquej noyesyo yejhuan ica notzimpehualtia on yencuic pacto, niman in noyesyo toyahuis para miyequej tlapojpolhuilos intlajtlacol. ");
INSERT INTO nguNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ica tlen melahuac nemechijlia ica xoc queman niconis iyayo in uva hasta ipan on tonajli ijcuac niconis yencuic iyayo on uvas campa tlamandarohua Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Niman ijcuac yoquinocuicatijquej se tlacuicajli, oyajquej ne ipan on tepetl itoca Olivos. ");
INSERT INTO nguNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Niman Jesús oquimijlij: ―Nemochimej nemejhuamej nennechtlalcahuisquej pampa on Yectlajcuilojli ijquin quijtohua: “Nicmictis on tlajpixqui, niman on borregos pojpolihuisquej.” ");
INSERT INTO nguNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero ijcuac nejhua yoniyoliu niman yoninoquetzteu ipan notlalcon, nias ne Galilea nemoyecapan. ");
INSERT INTO nguNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Quemaj Pedro oquijlij: ―Masqui nochimej mitztlalcahuisquej, nejhua ca. ");
INSERT INTO nguNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pero Jesús oquijlij: ―Ica tlen melahuac nimitzijlia ica aman ipan in tlayohua, ijcuac xe tzajtzi on caxtil ocpa, tejhua tiquijtos yexpa ica xtinechixmati. ");
INSERT INTO nguNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero yejhua quichihuaya canica, niman oquijtoj: ―Masqui hasta ijqui mohuan nimiquis, nejhua xniquijtos ica xnimitzixmati. Niman nochimej ijqui quijtohuayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Quemaj oajsiquej ne campa itoca Getsemaní, niman ompa Jesús oquimijlij on inomachtijcahuan: ―Xmotlajtlalican nican chica nejhua nicchihuas oración. ");
INSERT INTO nguNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Quemaj Jesús más neca oquinhuicac Pedro, Juan niman Jacobo. Niman Jesús opeu sanoyej najmana niman noyolcocohua. ");
INSERT INTO nguNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Niman oquimijlij: ―Nejhua sanoyej ninajmana. Machisti niajmancamiquis. Nemejhuamej nican xmocahuacan, niman xtlachixtiacan. ");
INSERT INTO nguNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Quemaj Jesús oyaj achijtzin más tlayecapan, niman onixacamantetlajcal ne ipan tlajli. Oquichiu oración tla huelisquia xquipanosquia on tlajyohuilistli yejhuan ipan huajlas. ");
INSERT INTO nguNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Niman oquijtoj: ―NoTajtzin, tejhua tihueli nochi. Xnechmaquixti ican in tlajyohuilistli yejhuan nechcha, pero ma ca ma nochihua quen nejhua nicnequi, yej ma nochihua quen tejhua ticnequi. ");
INSERT INTO nguNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Quemaj oyaj ne intech on inomachtijcahuan, niman oquinnextito cochtoquej. Niman oquijlij Pedro: ―Simón, ¿ticochi? ¿Xtihueli titlachixticaj nion se hora? ");
INSERT INTO nguNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Niman oquimijlij: ―Xtlachixtiacan, niman xchihuacan oración para on diablo xmechtlatlatas para xtlajtlacocan. Melahuac, tej, nemoespíritu quinequij quichihuas cuajli, pero nemonacayo xcojtic. ");
INSERT INTO nguNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Quemaj ocsejpa oyaj, niman oquichiu oración sa no ijqui oquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Quemaj ocsejpa ohuajlaj, niman oquinnextijtejcoc cochij on inomachtijcahuan, pampa sanoyej cochisnequiyaj. Niman yejhuamej xquimatiyaj tlinon quijlisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Niman ica yexpa ohuajlaj intech, niman oquimijlij: ―¿Hasta aman nencochij niman nemosehuitoquej? Yoyejcoc on hora ijcuac nechtemactilisquej. Xquitacan. Nejhua yejhuan oninochiu Tlacatl nechtemactilisquej ipan inmahuan on tlajtlacolejquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Xmotelquetzacan. Tiahuij. Ye huajlau on yejhuan nechtemactilis. ");
INSERT INTO nguNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús oc tlajtojticatca ijcuac oyejcoc Judas, on yejhuan tehuan nopohua intech on majtlactli huan ome nomachtijcamej. Niman yejhua cuajhuicaya miyec tlacatl yejhuan cuajquiya inespadas, niman sequimej cuajquiyaj cojtin. Yejhuamej huajlayaj ican intlanahuatil on tlayecanquej tiopixquej, niman on temachtijquej ican itlanahuatil Dios niman on tlajtlajmatquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Niman Judas, on yejhuan quitemactiliaya Jesús, ijquin oquimijlijca on tlacamej: ―On yejhuan nictencuas, yejhua Jesús. Xcajsican, cuajli xsasalocan niman xcuicacan. ");
INSERT INTO nguNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Quemaj Judas nimantzin oquinisihuij Jesús, niman oquijlij: ―Notemachtijcau. Niman quemaj oquitencuaj. ");
INSERT INTO nguNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Quemaj oquimayauquej, niman ocajsiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero semej on yejhuan ompa nemiyaj ihuan Jesús oquixicopintiaj iespada niman oquinacastzontec se tlacatl itlaquehual on más hueyi tlayecanqui intech on tiopixquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Quemaj Jesús oquimijlij on tlacamej: ―¿Onenhuajlajquej nemejhuamej ican espadas niman cojtin para nennechajsicoj quen yacaj nitlachtequetl yesquia? ");
INSERT INTO nguNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nejhua mojmostla nemohuan ninemiya para nemechmachtiaya ne ipan ihueyi tiopan Dios. Nemechmachtiaya niman xqueman onennechajsiquej. Pero onennechajsiquej para ma nochihua quen tlajcuilolnesticaj ipan on Yectlajcuilojli. ");
INSERT INTO nguNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Quemaj on inomachtijcahuan ocajtejquej Jesús, niman ochojcholojquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Niman se telpochtli quitocaya Jesús san huejca. Niman san quitquia se sábana ica notlapachojtiaya. Niman ocajsiquej, ");
INSERT INTO nguNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero yejhua ocajteu on isábana niman ijqui oyaj tetzotzoltic. ");
INSERT INTO nguNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Quemaj ocuicaquej Jesús ne itech on más hueyi intlayecancau on tiopixquej. Niman ompa onosentlalijquej nochimej on tlayecanquej tiopixquej, niman on tlajtlajmatquej, niman on temachtijquej ican itlanahuatil Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Niman Pedro ocuitlapanhuijtiaj san huejca hasta queman oajsic ne ijtic iquiahuac on cajli yejhuan ical on yejhuan más hueyi intlayecancau on tiopixquej. Niman ompa yehuaticatca inhuan on policías yejhuan tlajpiayaj ipan on hueyi tiopan. Nototonijticatcaj ne itech on tlitl. ");
INSERT INTO nguNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Intlayecancahuan on tiopixquej niman nochimej on tetlacanonotzquej quitejtemohuiliayaj quen ijqui quiteixpanhuisquej Jesús para ijqui huelis quimictisquej, pero xquinextiliayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Niman miyec quitlajtolquetztehuiliayaj Jesús, pero xsan se tlajtojli quipiayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sequimej huajnotelquetzquej, niman opeu quiteixpanhuiyaj. Quijtohuayaj on tlen xmelahuac. ");
INSERT INTO nguNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Quijtohuayaj: ―Oticaquilijquej oquijtoj: “Nejhua nicxoxotonis ihueyi tiopan Dios yejhuan oquichijchijquej on tlacamej. Niman ipan yeyi tonajli ocse nicchijchihuas yejhuan xtlachijchiutli yes ican tlacamej.” ");
INSERT INTO nguNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero nochimej xsan se tlajtojli quipiayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Quemaj on más hueyixticaj tlayecanquetl intech on tiopixquej ohuajnotelquetz imixpan nochimej, niman oquitlajtoltij Jesús: ―¿Xitlaj ica titlananquilis? ¿Tlinon in quiteixpantilijtoquej yejhuamej in moca tejhua? ");
INSERT INTO nguNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero Jesús xonahuat. Xtenanquiliaya. On más hueyixticaj tlayecanquetl intech on tiopixquej ocsejpa oquitlajtoltij, oquijlij: ―¿Tejhua tiCristo, tiiConeu on Dios yejhuan quiselia yectenehualistli? ");
INSERT INTO nguNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Quemaj oquijtoj Jesús: ―Quemaj, nejhua. Niman nennechitasquej nejhua yejhuan oninochiu Tlacatl ninotlalis iyecmacopa Dios yejhuan quipia nochi poder. Niman no nennechitasquej nihuajlas ipan on moxtli yejhuan ne ilhuicac quisticaj. ");
INSERT INTO nguNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ijcuacon on más hueyixticaj tlayecanquetl intech on tiopixquej sanoyej ocualan niman onotlaquencocotontiaj, niman oquijtoj: ―¿Tlinon para tiquinnequij más teteixpantilijquej? ");
INSERT INTO nguNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yonencaquej quen yocuijhuicaltij Dios. ¿Quen nenquinemiliaj nemejhuamej? Quemaj yejhuamej nochimej oquitlajtlacoltijquej para ma quimictican. ");
INSERT INTO nguNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Quemaj sequimej opejquej quichijchaj, niman oquixtlapachojquej, niman ocuijhuitequej. Niman quijliayaj: ―Xtlajto tiotlajtojquetl. Xtechijli aquinon omitzmailij. Niman quemaj on policías yejhuan tlajpiaj ipan on hueyi tiopan ocuicaquej, niman ocuijhuitequej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ijcuac Pedro nemiya ne tlatzintlan ne quiahuac, ohuajlaj se sihuatl yejhuan quipalehuiya on más hueyi tlayecanquetl intech on tiopixquej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Niman ijcuac oquitac Pedro ompa nototonijticatca itech on tlitl, opeu quitlajtlata, niman oquijlij: ―Tejhua no tiquistinemiya ihuan Jesús yejhuan hualehua Nazaret. ");
INSERT INTO nguNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero Pedro oquinenec, niman oquijtoj: ―Xniquixmati, nion nicmati tlinon on tiquijtohua. Niman quemaj Pedro oquis ne quiahuac, niman oyaj ne quiahuatenco. Niman quemaj ompa otzajtzic se caxtil. ");
INSERT INTO nguNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Niman on sihuatl ocsejpa ocontac, niman oquimijlij on yejhuan ompa nemiyaj: ―In tlacatl tehuan nopohua itech Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero yejhua ocsejpa oquinenec, niman achijtzin más saquin ocsejpa yejhuamej on yejhuan ompa nemiyaj, oquijlijquej Pedro: ―Melahuac, tejhua titehuan pampa tejhua tihualehua ne Galilea, niman ijqui titlajtlajtohua quen yejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro opeu quijtohua: ―Ma nimiqui tla xniquijtohua on tlen melahuac. Nejhua xniquixmati on tlacatl aquin nenquijtohuaj. ");
INSERT INTO nguNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Quemaj nimantzin otzajtziteu on caxtil ica ocpa. Quemaj Pedro oquelnamic on tlen Jesús oquijlijca: “Achtoj ijcuac xe tzajtzi on caxtil ocpa, tejhua tinechnenequis yexpa.” Niman ijcuac yejhua oquelnamic on tlajtojli opeu choca. ");
INSERT INTO nguNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ijcuac otlanes, intlayecancahuan on tiopixquej, on tlajtlajmatquej, on temachtijquej ican itlanahuatil Dios niman nochimej on tetlacanonotzquej oquinemilijquej tlinon quichihuilisquej Jesús. Quemaj ijcuac yoquisalojquej, ocuicaquej niman quitemactilitoj ne itech on gobernador itoca Pilato. ");
INSERT INTO nguNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Niman Pilato oquitlajtoltij: ―¿Tejhua tiinrey on hebreos? Jesús oquinanquilij: ―Quemaj, ijqui quen tejhua tiquijtohua. ");
INSERT INTO nguNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Niman on tlayecanquej tiopixquej quiteixpanhuiayaj ican miyec tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Quemaj Pilato ocsejpa oquitlajtoltij, oquijlij: ―¿Xitlaj ica titlananquilis? Xquita quech san tlajtlamach ica mitzteixpanhuijtoquej. ");
INSERT INTO nguNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús xitlaj ica oquinanquilij. Yejhua ica Pilato otlamojcaitac, niman xquimatiya tlinon quinemilis. ");
INSERT INTO nguNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cada xipan ipan on ilhuitl itoca pascua, Pilato quinmacahuiliani on tlacamej se tlacatl yejhuan tzacuticatca yejhuan yejhuamej quitlajtlaniyaj. ");
INSERT INTO nguNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Niman nemiya se tlacatl itoca Barrabás, tzacuticatca ihuan ocsequimej yejhuan inhuan onoquetztejca. Yejhuamej otemictijcaj ijcuac onajcomancaj. ");
INSERT INTO nguNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Quemaj on tlacamej ohualajquej, niman oquitlajtlanilijquej Pilato para ma quixti se yejhuan tzacuticaj quen quichihuani nochipa ipan on ilhuitl. ");
INSERT INTO nguNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Niman Pilato oquinnanquilij: ―¿Nenquinequij para ma nemechmacahuili inRey on hebreos? ");
INSERT INTO nguNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato ijquin oquijtoj pampa yejhua quimatzticatca ica san ican innexicol on tlayecanquej tiopixquej oquitemactilijquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero on tlayecanquej tiopixquej oquinchihualtijquej on tlacamej para ma tlajtlanican Barrabás, niman ma ca ma quitlajtlanican Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Quemaj Pilato oquintlajtoltij: ―¿Niman, tej, tlinon nicchihuas ihuan on yejhuan nemejhuamej nenquitocayotiaj inRey on hebreos? ");
INSERT INTO nguNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Quemaj yejhuamej oquijlijquej chicahuac ocsejpa: ―¡Xmajmasohualti ipan cojnepanojli! ");
INSERT INTO nguNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato oquimijlij: ―¿Tlinon, tej, xcuajli oquichiu? Pero yejhuamej ocsejpa más chicahuac otzajtziquej: ―¡Xmajmasohualti ipan cojnepanojli! ");
INSERT INTO nguNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pampa Pilato quinequiya cuajli nocahuas inhuan on tlacamej, oquinmacahuilij Barrabás. Quemaj oquinnahuatij on isoldados para ma cuijhuitequican Jesús. Niman quemaj oquitemactilij para ma quimajmasohualtican ipan cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ijcuacon, on soldados ocuicaquej Jesús ne iquiahuac on palacio, niman oquinnotzquej nochimej on ocsequimej soldados. ");
INSERT INTO nguNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Oquitlaliltijquej se tlaquentli morado, niman oquichijchijquej se huitzcorona, niman oquimaniltijquej ne ipan itzontecon. ");
INSERT INTO nguNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Quemaj opeu quitlajpalohuaj, quijliayaj: ―¡Cuajli xnemi tejhua Rey intech on hebreos! ");
INSERT INTO nguNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Quemaj ocuahuijhuitequej ican se ojtlatl, oquichijchaquej, niman onotlacuenquetzquej ixpan sa no ijqui quen quimahuistiliasquiaj. ");
INSERT INTO nguNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Quemaj ijcuac ica yonajahuiltijquej, oquixtilijquej on tlaquentli morado, niman oquitlaliltijquej on itlaquen. Quemaj ocuicaquej para oquimajmasohualtitoj ne ipan cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ijcuacon huajpanotiaya se tlacatl itoca Simón yejhuan chanej catca ne Cirene. Yejhua itaj catca Alejandro niman Rufo, niman ohualeu campa otequitito ipan imijla. Yejhua oquinahuatijquej para ma quitqui on icojnepanol Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ocuicaquej Jesús ne campa itoca Gólgota, más cuajli quijtosnequi Micatzontecomatl. ");
INSERT INTO nguNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Niman oquitequihuiltijquej on vino tlanelojli ihuan mirra. Pero Jesús xoquiselij. ");
INSERT INTO nguNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Quemaj oquimajmasohualtijquej ne ipan on cojnepanojli, niman yejhuamej onotlatlanquej para quitasquej cada se tlinon quitquis ica yejhua on itlaquen Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Las nueve catca, ijcuac cualcan, oquimajmasohualtijquej Jesús ne ipan on cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Niman para nochimej ma quitacan tlica miqui ne ipan on cojnepanojli, ijquin oquijcuilojquej: “Yejhua in inRey on hebreos.” ");
INSERT INTO nguNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Niman on omemej tlacamej tlachtequej oquinmajmasohualtijquej ipan cojnepanoltin ihuan Jesús, se iyecmacopa niman ocse iopochmacopa. ");
INSERT INTO nguNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Onochiu ijcon quen tlajcuilolnesticaj ne ipan on Yectlajcuilojli. Quijtohua: “Otlapohualquis inhuan on xcuajcualtin.” ");
INSERT INTO nguNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Niman yejhuamej on yejhuan ompa quipanahuiayaj, cuijhuicaltiayaj, niman nocuahuihuixohuayaj pampa sa ica nahuiltiayaj. Quijliayaj: ―¡Aj! Tejhua yejhuan ticxoxotonis ihueyitiopan Dios niman ipan yeyi tonajli ocsejpa tlamis ticchijchihuas, ");
INSERT INTO nguNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","xmomaquixti sa no tejhua, niman xhuajtemo ipan on cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sa no ijqui intlayecancahuan on tiopixquej niman on temachtijquej ican itlanahuatil Dios sa ica nahuiltiayaj Jesús. Yejhuamej quinojliayaj: ―Ocsequimej oquinmaquixtij, pero sa no yejhua xhueli nomaquixtia. ");
INSERT INTO nguNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tla yejhua Cristo yejhuan inRey on hebreos, ma huajtemo ne ipan on cojnepanojli para tiquitasquej niman ticneltocasquej ica melahuac yejhua inRey on hebreos. Niman on yejhuan ompa pilcayaj ipan on cojnepanoltin no cuijhuicaltiayaj Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ijcuac oajsic tlacualispan, otlayohuatiac nochihuiyan, niman tlajyohuatoc catca hasta ijqui oajsic ipan yeyi hora ica tiotlac. ");
INSERT INTO nguNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Niman ipan on hora, Jesús chicahuac otzajtzic: ―Eloi, Eloi, ¿lama sabactani? ―yejhuan quijtosnequi: NoDios, noDios, ¿tlica tinechtlalcahuia? ");
INSERT INTO nguNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sequimej, yejhuan ompa nemiyaj, ocacquej, niman oquijtojquej: ―Xcaquican. Quinotzticaj on tiotlajtojquetl Elías. ");
INSERT INTO nguNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nimantzin se tlacatl onotlalojtiquis. Yejhua oquictic se tojtontli momoxtic, niman oquipatzo ican xococ vino. Quemaj ocontlalij ipan sen acatl ica oconitij Jesús. Quemaj oquijtoj: ―Xcahuacan, ma tiquitacan tla huajlau Elías cuajtemohuis. ");
INSERT INTO nguNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Quemaj Jesús chicahuac otzajtzic, niman quemaj ohuajnotlamilij. ");
INSERT INTO nguNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ijcuacon, on tlatzacuililtlaquentli yejhuan pilcaya ne ijtic on hueyi tiopan ohuajtlajcocoton tlacpac hasta tlatzintlan. ");
INSERT INTO nguNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ijcuac on capitán romano yejhuan ijcaya ixpan Jesús oquitac quen ijqui otzajtzic, niman quen ijqui omic, oquijtoj: ―Yejhua in tlacatl melahuac iConetzin catca Dios. ");
INSERT INTO nguNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","No san huejcatzin sequimej sihuamej conitzticatcaj Jesús. Ompa nemiya María on yejhuan hualehua Magdala, Salomé, niman María on yejhuan inan Jacobo on yejhuan más teyic, niman José. ");
INSERT INTO nguNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","In sihuamej oyajquej ihuan Jesús, niman oquipalehuijquej ijcuac quistinemiya neca Galilea. No nemiyaj ompa ocsequimej sihuamej yejhuan ohualajquej ne Jerusalén ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ipan on tonajli viernes on hebreos cuectlaliayaj nochi tlajtlamach para xtequitiyaj ipan on tonajli sábado. Ipan in tonajli viernes, ijcuac ye tlayohuatitiaya, ");
INSERT INTO nguNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ohuajlaj se tlacatl, itoca José, yejhuan hualehua ne ipan on pueblo itoca Arimatea. Yejhua tehuan catca intech on tetlacanonotzquej ne ipan on hueyi tiopan, niman nochimej quitlacaitayaj. Yejhua no quichaya quemanon pehuas tlamandaros Dios. Yejhua onoyolchicau, niman oyaj itech Pilato para oquitlajtlanilij itlalnacayo Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato omojcatlachix ica yomic Jesús. Yejhua ica oquititlan se tlacatl para ma cuajhuica on capitán. Ijcuac on capitán ohuajlaj, Pilato oquitlajtoltij tla melahuac yomic Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Quemaj ijcuac on capitán oquimachiltij ica melahuac yomic, Pilato ocahuilij José para ma quitemolti on itlalnacayotzin Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Quemaj José ocou se tlaquentli istac sanoyej patioj. Niman ijcuac oquitemohuij on itlalnacayo Jesús, oquitejcuix ican on tlaquentli istac. Quemaj oquitocato ne ijtic se ostotl yejhuan oquichcuajquej ipan tetl. Niman ne itenco ocuejcueptiajquej se tetl sanoyej hueyi, niman ica oquitentzacu. ");
INSERT INTO nguNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María on yejhuan hualehua ne Magdala, niman María yejhuan inan José oquitatoj canon ocahuatoj itlalnacayotzin Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ijcuac yopanoc on sábado, María on yejhuan hualehua ne Magdala, María inan Jacobo, niman Salomé ocojquej on ajhuiyalistli para conajhuiyalisquiaj on itlalnacayotzin Jesús. ");
INSERT INTO nguNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Huelipan cualcan, ipan on achtoj tonajli ipeuyan on semana, oyajquej ne itech on tlalcontli campa José oquitocato itlalnacayotzin Jesús. Ye huajquistiaya on tonaltzintli. ");
INSERT INTO nguNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Niman ijcuac xe ajsiaj, quinojliayaj yejhuamej: ―¿Aquinon techejcuanilis on tetl ne itenco on tlalcontli? ");
INSERT INTO nguNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero ijcuac ontlachixquej, oquitaquej ica on tetl yejhuan sanoyej hueyi ye cueptoc. ");
INSERT INTO nguNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Quemaj ijcuac ocalaquitoj ne ijtic on ostotl yejhuan tlalcontli, oquitaquej ipan yecmatli se telpochtli. Ompa yehuaticaj niman tejcuixticaj ican se hueyac tlaquentli istac. Niman yejhuamej sanoyej onomotiquej. ");
INSERT INTO nguNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero yejhua oquimijlij: ―Ma ca xmomojtican. Nenquitejtemohuaj Jesús on yejhuan hualehua Nazaret niman oquimajmasohualtiquej ne ipan on cojnepanojli. Pero aman yoyoliu niman yonoquetzteu. Yejhua xnican nemi. Xquitacan nican campa oquitlalijcaj itlalnacayotzin. ");
INSERT INTO nguNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aman xhuiyan, niman xquijlican inomachtijcahuan niman Pedro ica inyecapan yas ne Galilea, niman ompa nemejhuamej nenquitasquej ijcon quen omechijlij. ");
INSERT INTO nguNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Quemaj nimantzin on sihuamej oquitlalcahuijquej on tlalcontli niman sa mojcacuecuetlacatiayaj. Xacaj oquijlijquej quen ijqui oquitaquej, pampa sanoyej nomojtiayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Niman ipeuyan on semana ijcuac Jesús oyoliu niman onoquetzteu ipan itlalcon, Jesús oquinotitij achtoj María on yejhuan hualehua ne Magdala, on yejhuan oquixtilijca chicomemej xcuajcualtin espíritus. ");
INSERT INTO nguNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Niman yejhua oyaj, oquinmachiltito on inomachtijcahuan Jesús, yejhuan sanoyej najmanayaj, niman chocayaj. ");
INSERT INTO nguNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero ijcuac ocacquej ica Jesús yoyoliu niman yonoquetzteu ipan itlalcon, niman ica María oquitac, yejhuamej xoquineltocaquej. ");
INSERT INTO nguNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Más saquin, ocse tlamantic oquinnotitij omemej nomachtijquej chica yejhuamej yayaj ipan ojtli. ");
INSERT INTO nguNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yejhuamej onocuepquej ne campa nemiyaj on ocsequimej, pero no xoquinneltoquilijquej. ");
INSERT INTO nguNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Más saquin Jesús oquinnotitij on majtlactli huan se inomachtijcahuan chica tlacuajticatcaj. Ijcuacon oquimajhuac pampa xtlaneltocayaj niman ipampa inyoltechicahualis. Yejhuamej xoquinneltocaquej on yejhuan oquitaquej achtoj ica oyoliu niman onoquetzteu ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Quemaj oquimijlij: ―Xhuiyan nochihuiyan imanyan in tlalticpactli, niman xquijlican nochi tlacatl on cuajli tlajtojli yejhuan quitemaca temaquixtilistli. ");
INSERT INTO nguNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","On yejhuan quineltocas on cuajli tlajtojli yejhuan quitemaca temaquixtilistli niman nocuatequis nomaquixtis. Pero on yejhuan xquineltocas quitlajtlacolmacasquej. ");
INSERT INTO nguNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Niman in tlamajhuisoltin quichihuasquej on aquin tlaneltocasquej. Quinquixtisquej on xcuajcualtin espíritus ica notoca. Tlajtosquej ican ocsequi yencuic tlajtojli. ");
INSERT INTO nguNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tla quinquitzquisquej cohuamej, noso tla conisquej on veneno, xquinchihuilis daño. Quintlalisquej inmahuan impan on cocoxquej niman quimpajtisquej. ");
INSERT INTO nguNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Niman quemaj ijcuac Jesús yoquinnojnotz, Dios ocuicac ne ilhuicac campa onotlalij ipan iyecmatzin. ");
INSERT INTO nguNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","On nomachtijquej opejquej tenojnotzaj niman temachtijtiyaj nochihuiyan. Niman toTeco quimpalehuiyaya, niman itechcopa on milagros yejhuan onochiu ijcuac temachtijtiayaj, quintitiaya on tlacamej ica intemachtil yejhua tlen melahuac.");
INSERT INTO nguNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Miyequej tlacamej oquijcuilojquej quen ijqui onochiu on tlajtlamach opanoc totzajlan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nochi oquijcuijloquej ijqui quen otechmachiltijquej on yejhuan oquiteixpantilijquej nochi on tlajtlamach tlen onochiu desde itzimpeuyan niman oquiteijlijquej itlajtol Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nejhua no cuajli oninomachtij nochi yejhua on tlajtlamach yejhuan onochiu desde ne itzimpeuyan. Yejhua ica, tejhua hueyixticaj Teófilo, nicuitia cuajli para nimitztlajcuilhuis niman nimitzmelajcailis ipan iyojhui on quen ijqui onochiu on tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ijcon, tej, cuajli ticmatis nochi on tlen melahuac itechica on tlajtlamach yejhuan omitzmachtijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nochi on tlajtlamach opeu ijcuac rey Herodes tequihua catca ipan iregión Judea. Ipan on tonaltin nemiya se tiopixqui itoca catca Zacarías, yejhuan tehuan nopohuaya ipan igrupo on tiopixquej Abías. Isihuau Zacarías itoca catca Elisabet. Yejhua on huejca teixhuiu catca itech on tiopixqui itoca Aarón. ");
INSERT INTO nguNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","On omemej yolchipajquej catcaj ixpan Dios niman quitlacamatiyaj nochi on itlanahuatilhuan niman on tlen oquijtoj toTeco, niman ijcon, tej, xacaj hueliya itlaj ica quintlajtlacolmacaya. ");
INSERT INTO nguNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero xquipiayaj inconehuan, pampa Elisabet tetzacatl catca, niman sanoyej ye huehuentzitzintin catcaj. ");
INSERT INTO nguNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ijcuac oyejcoc on tonaltin para tequitis on grupo campa Zacarías nopohuaya, yejhua otequit ixpan Dios pampa yejhua tiopixqui catca. ");
INSERT INTO nguNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Oquipixquej se costumbre intzajlan on tiopixquej ica quitlapejpeniayaj se tiopixqui san ican suerte para calaquiya niman quitlatiaya on xochicopajli ipan ihueyi tiopan toTeco. ");
INSERT INTO nguNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chica quitlatiaya on xochicopajli, nochi on tlacamej quichijticatcaj oración ne quiahuac ixpan on hueyi tiopan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Quemaj se ilhuicactequitquetl, yejhuan toTeco ocuajtitlan, ohuajnonextij nisiu itech Zacarías. On ilhuicactequitquetl ijcaticatca iyecmacopa on tlaixpan campa notlatiani on xochicopajli. ");
INSERT INTO nguNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ijcuac Zacarías oquitac on ilhuicactequitquetl, xoc quimatiya quen quichihuas niman sanoyej onomojtij. ");
INSERT INTO nguNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero on ilhuicactequitquetl oquijlij: ―Ma ca xmomojti, Zacarías. Dios yocac mooraciones, niman mosihuau Elisabet quitlacatilis ioquichconeu. Tictocayotis Juan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sanoyej tipaquis niman no miyequej paquisquej ipampa itlacatilis moconeu. ");
INSERT INTO nguNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ijquin nochihuas, pampa yejhua hueyixtias ixpan Dios. Yejhua xconis vino nion itlaj se yejhuan tetlahuantij, niman on Espíritu Santo nochi ica quiyecanas desde ijcuac tlacatis. ");
INSERT INTO nguNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yejhua quichihuas para miyequej tlacamej yejhuan teconehuan itech Israel ma nocuepacan niman ma quitlacamatican toTeco yejhuan inDios. ");
INSERT INTO nguNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yejhua in Juan yas iyecapan toTeco ican on iyolchicahualis niman on poder yejhuan oquipix on tiotlajtojquetl Elías. Yas iyecapan toTeco, niman quichihuas para on tatajtin ma quintlajsojtlacan inconehuan, niman no quichihuas para on yejhuan xquitlacamatij Dios ma quipiacan on tlamatquilistli, ijcon quen on yejhuan cuajcualtin tlacamej quipiaj. Ijcon quinmelajcatlalis on tlacamej para huelisquej quiselisquej on toTeco. ");
INSERT INTO nguNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pero Zacarías oquitlajtoltij on ilhuicactequitquetl: ―¿Quen ijqui nicmatis ica on tlen otiquijtoj melahuac? pampa nejhua sanoyej ye nihuehuentzin niman nosihuau no ye lamajtzin. ");
INSERT INTO nguNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Niman on ilhuicactequitquetl oquinanquilij: ―Nejhua niGabriel, niman niitequitcau Dios. Dios, tej, onechajtitlan ma nimitznotzaqui para nimitzijlis in cuajli tlajtojli. ");
INSERT INTO nguNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero xoticneltocac tlinon onimitzijlij. Yejhua ica tinontias. Xhuelis titlajtos hasta ijcuac tlacatis moconeu. ");
INSERT INTO nguNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","On tlacamej yejhuan quichixticatcaj Zacarías ne quiahuac xoquimatquej tlinon quinemilisquej, pampa yejhua yohuejcajca ica xhuajquisaya ne ijtic on hueyi tiopan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Niman ijcuac Zacarías ohuajquis, xhueliya quinnojnotzaya. Yejhua ica on tlacamej ocajsicamatquej ica yejhua oquitac itlaj tetlatlachaltilistli yejhuan quen itemicpan ne ijtic on hueyi tiopan. Niman yejhua, tej, sa quinmanotzaya, pampa xoc hueliya tlajtohuaya. ");
INSERT INTO nguNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ijcuac otlanquej on tonaltin ica Zacarías tequiti ne ipan on hueyi tiopan, oquis niman oyaj ichan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Más saquin, Elisabet on isihuau ones ica ye quipia iconeu, niman macuijli metztli oniyan ne ichan. Ijquin quinemiliaya: ");
INSERT INTO nguNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Aman toTeco ijquin onechchihuilij ican iteicnelilis para xoc nipinahuas imixpan on tlacamej.” ");
INSERT INTO nguNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ijcuac Elisabet ye quipiaya iconeu chicuasen metztli, Dios ocuajtitlan on ilhuicactequitquetl Gabriel ipan se pueblo de Galilea itoca Nazaret. ");
INSERT INTO nguNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dios oquititlan para conotzas se ichpochtli, yejhuan xe yacaj tlacatl quinixmachtiaya, itoca María. María yoquitlalijca compromiso para nonamictis ihuan se tlacatl itoca José yejhuan sa huejca teixhuiu itech David. ");
INSERT INTO nguNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","On ilhuicactequitquetl oquinisihuij María niman oquijlij: ―Nimitztlajpalohua. ¡Dios yomitztiochiu! On toTeco mohuan nemi. Dios más omitztiochiu xquen nochimej on ocsequimej sihuamej. ");
INSERT INTO nguNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pero ijcuac María ocac on ilhuicactequitquetl, oquimojcacac itlajtol, niman sa no yejhua quinotlajtoltiaya tlica ijquin quitlajpalohuaya. ");
INSERT INTO nguNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pero on ilhuicactequitquetl oquijlij: ―Ma ca xmomojti María, pampa Dios yomitztiochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aman ticanas moconetzin niman tictlacatilis se oquichconetl. Niman tictocayotis Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yejhua hueyixtias niman itoca yes teConeu itech on yejhuan más hueyixticaj Dios. Niman Dios toTeco quitlalis para Rey yes niman quipias on tequihuajyotl yejhuan ihuejcataj David oquipix. ");
INSERT INTO nguNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yejhua nochipa tequihuaj yes ipan on país de Israel, niman on ica tequihuaj yes xsan ontlamis. ");
INSERT INTO nguNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Quemaj María oquitlajtoltij on ilhuicactequitquetl: ―¿Quen ijqui huelis nochihuas yejhua in, pampa nejhua xe yacaj tlacatl ihuan ninemi? ");
INSERT INTO nguNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Niman on ilhuicactequitquetl oquijlij: ―On Espíritu Santo mopan huajlas, niman ipoder on yejhuan más hueyixticaj Dios quichihuas se milagro tejhua mopan. Yejhua ica on conetzintli yejhuan tlacatis chipajtias niman cuitisquej iConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Xquelnamiqui moprima Elisabet yejhuan quijtohuiliaj tetzacatl. Aman ye quipia chicuasen metztli ica conehua masqui yejhua lamajtzin. ");
INSERT INTO nguNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","In ijquin nochihuas pampa xitlaj oncaj yejhuan Dios xhuelis quichihuas. ");
INSERT INTO nguNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Niman ijcuacon María oquijtoj: ―Nejhua niitequichihuilijcau toTeco. Ma Dios, tej, nechchihuili on tlen otinechijlij. Quemaj on ilhuicactequitquetl oyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ipan on tonaltin María ocajsic iojhui. Nimantzin oyaj ipan on tepemej hasta oajsic ipan se pueblito yejhuan oncatca ne Judea. ");
INSERT INTO nguNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ijcuac oajsic ipan on pueblo, ocalac ichan Zacarías niman oquitlajpaloj Elisabet. ");
INSERT INTO nguNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Niman ijcuac Elisabet ocac itetlajpalol María, on iconetzin Elisabet onolinij ijtic, niman on Espíritu Santo nochi ica oquiyecan Elisabet. ");
INSERT INTO nguNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Quemaj Elisabet oquijtoj chicahuac, niman oquijlij María: ―Dios más omitztiochiu xquen nochimej on sihuamej, niman no yoquitiochiu on conetzintli yejhuan tictlacatilis. ");
INSERT INTO nguNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Aquin nejhua, tej, ica tejhua yejhuan inan noTeco otihuajlaj para otinechnotzaco? ");
INSERT INTO nguNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nimantzin ijcuac otinechtlajpaloj, noconetzin onolinij ican pactli nican nojtic. ");
INSERT INTO nguNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dios mitztiochihua para tejhua yejhuan oticneltocac ica nochihuas on tlen toTeco oquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Quemaj María oquijtoj: Noalma cueyilia toTeco, ");
INSERT INTO nguNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","niman noyojlo nopactia itech Dios yejhuan noTemaquixtijcau, ");
INSERT INTO nguNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","pampa yejhua onechelnamic nejhua yejhuan xnihueyixticaj itequichihuilijcau. Niman desde aman nochimej nechtocayotisquej nitlatiochicasihuatl. ");
INSERT INTO nguNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ijcon nochihuas pampa on huejhueyi tlajtlamach yejhuan tohueyi Dios onechchihuilij. Yejhua yolchipahuac. ");
INSERT INTO nguNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nochipa quipialis teicnelilistli nochimej yejhuan quitlacaitasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yejhua oquiteititij ipoder ican on tlen oquichiu. On yejhuan nohueyimatij niman san tlamach xcuajli quinejnemiliaj, Dios xquincahuilia ma quichihuacan tlen quinequij. ");
INSERT INTO nguNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","On tequihuajquej oquinquixtij ne campa tequihuajtiticatcaj niman oquinmamacac hueyilistli on yejhuan yolyemanquej. ");
INSERT INTO nguNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yejhuan apismiquiyaj oquinmacac nochi tlen cuajli niman xitlaj oquinmacac on yejhuan ricos. ");
INSERT INTO nguNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Oquipalehuij on país itoca Israel yejhuan itequipanojcau. Yejhua xoquelcau quipialis teicnelilistli on país, ");
INSERT INTO nguNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ijcon quen oquintlalilij ipan ipromesa on toachtojtajhuan, Abraham niman nochi quech teconehuan para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María onocau ihuan Elisabet canaj yeyi metztli, niman quemaj onocuep para ichan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Oajsic on tonajli para Elisabet quitlacatilis iconetzin, niman oquitlacatilij se oquichconetl. ");
INSERT INTO nguNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Quemaj inisiuchantlacaj niman ichanecahuan, ijcuac ocacquej quen toTeco sanoyej cuajli oquitiochiu, paquiyaj ihuan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Quemaj ipan chicueyi tonajli oyajquej para oquitlalilitoj se nescayotl itoca circuncisión ipan inacayo. Niman quinequiyaj quitocayotisquej Zacarías quen itaj, ");
INSERT INTO nguNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","pero inan oquijtoj: ―Ca. Itoca yes Juan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Niman oquijlijquej: ―¿Tlica ijcon itoca yes? Ipan mochanecahuan xacaj nemi yejhuan ijcon itoca. ");
INSERT INTO nguNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Quemaj oquimanotzquej itaj on conetzintli para quimatisquej quen ijqui yejhua quinequi quitocayotis. ");
INSERT INTO nguNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Niman itaj oquitlajtlan se amatl para ompa quijcuilos quen itoca yes on iconeu. Niman ijquin oquijcuiloj: “Itoca Juan.” Niman nochimej omojcatlachixquej yejhua ica in. ");
INSERT INTO nguNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nimantzin Zacarías ohuel otlajtoj ocsejpa, niman opeu quiyectenehua Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yejhua ica in, nochimej on ichantlacaj otlamojcaitaquej. Niman nochihuiyan ipan on tepemej yejhuan oncaj ipan on iregión Judea noteijliaya on tlen onochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Niman nochimej on yejhuan intech on machiyaya yejhua on, pehuayaj tlanemiliayaj niman ijquin quinotlajtoltiayaj: ―¿Manin tlinon itequiu yes in oquichconetl? Melahuac ipoder toTeco ipan oncaj. ");
INSERT INTO nguNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","On Espíritu Santo nochi ica oquiyecan Zacarías itaj on oquichconetl niman ica on yectlajtojli yejhuan Dios oquimacac, oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ma ticueyilican toTeco Dios, on yejhuan inDios on hebreos pampa yotechnotz niman yotechmaquixtij. ");
INSERT INTO nguNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yotechmacac se hueyi Temaquixtijquetl yejhuan huejca teixhuiu itech David yejhuan itequipanojcau. ");
INSERT INTO nguNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ye huejcahui ijquin oquijtoj intechcopa on iyectiotlajtojcahuan ");
INSERT INTO nguNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ica yejhua techmaquixtis intech on totlahuelicnihuan niman itech inpoder nochimej on yejhuan techtlahuelitaj. ");
INSERT INTO nguNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ijcon oquichiu para techmacas on teicnelilistli yejhuan oquimprometerohuijlij toachtojtajhuan, niman xquelcahua ichipahuac pacto. ");
INSERT INTO nguNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","In yejhua on promesa yejhuan Dios oquiprometerohuilij itech on toachtojtaj Abraham ");
INSERT INTO nguNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ica techmanahuis intech on totlahuelicnihuan, para xican nemojtijli tictequipanosquej ");
INSERT INTO nguNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ican chipahualistli niman quen cuajli para ticchihuasquej nochi tonaltin ipan tonemilis. ");
INSERT INTO nguNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Niman tejhua, noconetzin Juan, mitztocayotisquej itiotlajtojcau on más hueyixticaj Dios, pampa tejhua tias iyecapan on toTeco para ticuectlalijtias iojhuihuan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tictemachiltis ica quiselisquej temaquixtilistli ijcuac Dios quintlapojpolhuilis intlajtlacolhuan. ");
INSERT INTO nguNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ToDios quintlapojpolhuiya pampa sanoyej quimicnelia. Ican iteicnelilis quinhuajtitlanilis on Temaquixtijquetl yejhuan hualehua ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Niman on Temaquixtijquetl quinmaquixtis yejhuan tlajtlacohuaj niman yejhuan nemij ipan miquilistli. Yejhuamej no quinmacas yolsehuilistli. ");
INSERT INTO nguNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Niman on oquichconetl noscaltiaya niman chicajtiaya itech Dios. Niman yejhua ochantic ne campa tlapatlaco hasta ipan on tonajli ijcuac yejhua onoteititij itech on tlacamej yejhuan chantij ipan on país de Israel. ");
INSERT INTO nguNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ipan on tonaltin, Augusto yejhuan más hueyi tlayecanquetl catca ipan on hueyi país Roma, otlanahuatij para nochi on ichantlacaj ipan on país ma quitemacatij intoca ne ipan on censo. ");
INSERT INTO nguNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yejhua in achtoj censo oquichichiquej ijcuac Cirenio tequihuaj catca ipan on iregión Siria. ");
INSERT INTO nguNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ipan on tonaltin nochi tlacatl yaya cada se ipan ipueblo campa nemiya san secan ichanecahuan para ompa onijcuiloto ipan on censo. ");
INSERT INTO nguNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José huejca teixhuiu catca itech David. Yejhua ica oquis ipan on pueblo itoca Nazaret, yejhuan oncaj ipan on iregión Galilea, niman oyaj ne ipan on pueblo itoca Belén, yejhuan oncaj ipan on iregión Judea campa otlacatca David. ");
INSERT INTO nguNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yejhua oyaj ne Belén para onijcuiloto ipan on censo ihuan María yejhuan quipiaya compromiso para ihuan nonamictis. María, tej, ye quipiaya iconeu. ");
INSERT INTO nguNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Niman chica nemiyaj ne Belén, oyejcoc on tonajli para María quitlacatilis iconetzin. ");
INSERT INTO nguNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ompa oquitlacatilij on iachtoj conetzin yejhuan oquichconetl catca. Oquitlatlapachoj ican tlaquentli niman oquitecac ipan se canoa, pampa xoncatca ompa campa yejhuamej nosehuisquej ijtic on mesón campa nosehuiaj on nejnenquej. ");
INSERT INTO nguNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nisiu ne Belén nemiyaj sequimej tlajpixquej yejhuan nochi tlayohua nocahuayaj ne ipan on tepetl campa quintlajpiayaj inborreguitos. ");
INSERT INTO nguNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sen ilhuicactequitquetl yejhuan toTeco Dios ocuajtitlan oquinhuajnotitij. Niman ihueyilis toTeco Dios quen se tlahuijli opetlan inyehualican on tlajpixquej. Ijcuacon, yejhuamej sanoyej onomojtijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero yejhua on ilhuicactequitquetl oquimijlij: ―Ma ca xmomojtican, pampa onihuajlaj para nemechmachiltico se cuajli tlajtojli, yejhuan huelis quipactis nochi tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aman ne ipan ipueblo David otlacat nemoTemaquixtijcau. Yejhua Cristo on toTeco. ");
INSERT INTO nguNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Niman para nenquixmatisquej, nemejhuamej nenquinextisquej on conetzintli tetejcuixticaj ican se tlaquentli, niman onoc ipan se canoa. ");
INSERT INTO nguNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Quemaj nimantzin ne itech on ilhuica tequitquetl ohuajnonextijquej sanoyej miyequej ocsequimej ilhuicactequitquej yejhuan ohualejquej ne tlacpac ilhuicac. Yejhuamej cueyiliayaj Dios niman quijtohuayaj: ");
INSERT INTO nguNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Hueyixtica Dios ne ilhuicac, niman nican ipan tlalticpactli ma onya yolsehuilistli intzajlan on tlacamej yejhuan quipiaj tetlajsojtlalistli! ");
INSERT INTO nguNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Quemaj ijcuac on ilhuicactequitquej onocuepquej ne ilhuicac, on tlajpixquej opeu quinojliaj ihuan ocsequimej: ―Tiahuij, tej, ne Belén, niman ticontasquej on tlen onochiu yejhuan otechmachiltij on toTeco. ");
INSERT INTO nguNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nimantzin oyajquej niman oquinextitoj María niman José, niman on conetzintli onoya ipan se canoa campa tlacuaj on yolquej. ");
INSERT INTO nguNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ijcuac oquitaquej, oquintlajtlajtohuilijquej on tlen on ilhuicactequitquetl oquimijlij itech ica yejhua on conetzintli. ");
INSERT INTO nguNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Niman nochimej yejhuan oquincaquej otlamojcacaquej ica on tlen on tlajpixquej quijtohuayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero María oquejeu ipan iyojlo nochi yejhua in tlajtojli niman sanoyej ica tlanemiliaya. ");
INSERT INTO nguNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","On tlajpixquej onocuepquej ne campa oquincajquej on inborreguitos. Niman chica nocuepayaj, ocueyilijquej niman oquiyectenejquej Dios ipampa nochi on tlen ocacquej niman oquitaquej. Nochi onochiu quen on ilhuicactequitquetl oquimijlij. ");
INSERT INTO nguNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ipan chicueyi tonajli oquitlalilijquej on nescayotl itoca circuncisión ipan inacayo on conetzintli niman oquitocayotijquej Jesús. Oquitocayotijquej ica sa no yejhua on tocayotl yejhuan on ilhuicactequitquetl oquijlij María ijcuac oc xe nesiya tla quipia iconeu. ");
INSERT INTO nguNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ijcuac yopanoc on tonaltin ica José niman María yonochipajquej ijcon quen tlanahuatia itlanahuatil Moisés, yejhuamej ocuicaquej Jesús ne Jerusalén niman oquiyaxcatijquej on toTeco Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","In oquichijquej pampa ipan itlanahutil on toTeco ijquin tlajcuilolnesticaj: “Nochi yejhuan yencuiyotl oquichconetl ma quiyaxcatican on toTeco.” ");
INSERT INTO nguNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Niman no oyajquej para oquihuentlalitoj ome cocotetzitzintin noso ome palomas ijcon quen tlanahuatia itlanahuatil toTeco. ");
INSERT INTO nguNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ipan on tonaltin chantiya ne Jerusalén se tlacatl itoca Simeón. Yejhua cuajli tlacatl catca, niman cuajli quitlacaitaya Dios. Yejhua quichaya quemanon tlacatis on yejhuan quinyoltlalis ichantlacaj on país itoca Israel, niman Espíritu Santo nemiya ipan. ");
INSERT INTO nguNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Niman on Espíritu Santo oquimachiltijca ica yejhua xmiquis hasta quitas on Cristo yejhuan toTeco cuajtitlanis. ");
INSERT INTO nguNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Niman yejhua on Espíritu Santo ocuicac Simeón para oyaj ipan on hueyi tiopan. Niman ijcuac José niman María ocuicaquej on conetzintli Jesús ne ipan on hueyi tiopan para oquichihuilijquej tlinon on tlanahuatijli tlanahuatia, ");
INSERT INTO nguNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón oquinapaloj on conetzintli niman oquihueyilij Dios, oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","NoTeco, aman ye huelis tinechcahuilis para ma nimiqui ican yolsehuilistli, pampa aman yoticchiu tlinon otinechprometerohuilij nejhua nimotequipanojcau. ");
INSERT INTO nguNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aman ican nixtololojhuan yoniquitac on Temaquixtijquetl yejhuan yoticuajtitlan ");
INSERT INTO nguNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","niman yejhuan yotictlalij ixpan nochi tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yejhua quen tlahuijli yejhuan quitlahuilhuis on ojtli itech Dios para on yejhuan xhebreos niman quinmacas hueyilistli moconehuan hebreos. ");
INSERT INTO nguNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José niman inan Jesús sanoyej oquintlatlachaltij on tlen Simeón quijtohuaya itech ica on conetzintli. ");
INSERT INTO nguNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Quemaj Simeón oquintiochiu, niman oquijlij María: ―Xquita, Dios oquitlalij in conetzintli ipan itequiu. Miyec tlacatl yejhuan chanej ipan in país de Israel ixpolihuisquej pampa xquineltocasquej moconeu, niman miyec tlacatl no quiselisquej on nemilistli yejhuan para nochipa pampa quineltocasquej. Niman yejhua quiteititis on ojtli para calaquisquej ne itech Dios, pero miyequej yej quixnamiquisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Niman ijcon miyequej quiteititisquej quen quinemiliaj ipan inyojlo. Niman para tejhua, nochi yejhua in quen itlaj espada yes yejhuan quitzopinis moalma. ");
INSERT INTO nguNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","No ompa nemiya se sihuatl tiotlajtojquetl, itoca Ana, yejhuan itaj catca Fanuel, yejhuan quisa ipan on ihuejcachanej Aser. Yejhua sanoyej lamajtzin catca. Ijcuac ononamictijca san chicome xipan onen ihuan ihuehuentzin. ");
INSERT INTO nguNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Niman quemaj yejhua cahuajli catca hasta ye quipiaya napoajli huan nahui xipan. Xcaman quisaya ipan on hueyi tiopan, yej quitequipanohuayaj toTeco ican tonajli niman yehuajli, ican nesahuajli niman ican oraciones. ");
INSERT INTO nguNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Niman chica Simeón tlajtlajtohuaya ihuan María niman José, yejhua oquinnisihuij niman opeu quimaca tlaxtlahuijli Dios. Niman quemaj opeu quinnojnotza yejhua ica on conetzintli Jesús nochimej on yejhuan no quimachayaj on temaquixtijquetl para quinmanahuis on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Quemaj ijcuac José niman María yoquichijquej nochi on tlen tlanahuatia on itlanahuatil toTeco, onocuepquej para oyajquej ipan on impueblo itoca Nazaret yejhuan oncaj ne ipan iregión Galilea. ");
INSERT INTO nguNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Niman on oquichconetl Jesús noscaltiaya niman cajsitiaya más chicahualistli niman miyec tlamatquilistli, niman quiseliaya itlatiochihualis Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cada xipan itajhuan Jesús yayaj ne Jerusalén para companohuayaj on ilhuitl itoca pascua. ");
INSERT INTO nguNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Niman ijcuac Jesús ocajxitij majtlactli huan ome xipan, oyajquej Jerusalén ijcon quen quichihuayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ijcuac otlan on ilhuitl niman nochi tlacatl nocuepaya para ichan, on oquichconetl Jesús onocau ne Jerusalén. Pero inan niman itaj xoquimatquej ica yejhua onocau. ");
INSERT INTO nguNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yejhuamej quinemiliayaj ica Jesús yaya intzajlan on tlacamej. Yejhua ica ijcuac se tonajli yonejnencaj, quemaj opeu quitejtemohuaj intech on ichanchanecahuan niman intech iteixmatcahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero ijcuac xoquinextijquej, onocuepquej ne Jerusalén para ompa oquitejtemotoj. ");
INSERT INTO nguNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Niman ipan yeyi tonajli saquin oquinextitoj ne ipan on hueyi tiopan. Yehuaticatca intzajlan on huejhueyixtoquej temachtijquej yejhuan quitemachtiaj itlanahuatilhuan Dios. Ompa quincacticatca niman no miyec tlamach quitlajtoltiayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Niman nochimej yejhuan caquiyaj quipacaitayaj ica on cuajli itlamatquilis yejhuan ica tenanquiliaya. ");
INSERT INTO nguNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ijcuac itajhuan oquitaquej, opacatlachixquej, niman inan oquijlij: ―Noconetzin, ¿tlica ijquin otitechchihuilij? Motaj niman nejhua sanoyej yotimojcamiquej chica nimitztejtemohuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Niman Jesús oquimijlij: ―¿Tlica nennechtejtemohuayaj? ¿Tlica xnenquimatij ica nejhua ica oncaj ninotequimacas ipan on tlajtlamach yejhuan iyaxca noTajtzin? ");
INSERT INTO nguNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero yejhuamej xocajsicamatquej tlinon on yejhua oquimijlij. ");
INSERT INTO nguNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Quemaj inhuan onocuep para Nazaret, niman yejhua quintlacamatiya. Niman inan quejehuaya ipan iyojlo nochi on tlajtlamach yejhuan onochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Niman Jesús más noscaltijtiaya ipan itlalnacayo niman más cajsitiaya itlamatquilis, niman quipactiaya Dios niman on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ijcuac Tiberio César quipiaya caxtojli xipan ica tequihuaj catca ipan on hueyi país Roma, Poncio Pilato gobernador catca ne Judea, Herodes gobernador catca ne Galilea, niman Felipe on icniu Herodes gobernador catca ne Iturea niman ne Traconite, niman Lisanias gobernador catca ne Abilinia. ");
INSERT INTO nguNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Niman ipan sa no on tonaltin Anás niman Caifás yejhuamej más huejhueyixticatcaj tlayecanquej intech on tiopixquej. Ipan on tonaltin Juan, on iconeu Zacarías, oquiselij se yectlajtojli itech Dios ne campa tlapatlaco. ");
INSERT INTO nguNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yejhua ica, tej, Juan oquistinen nochihuiyan campa nisiu itech on atentli Jordán. Quimijlijtiaya on tlacamej ica nonequi nocuatequisquej para quiteititisquej ica yonoyolpatlaquej, niman Dios quintlapojpolhuis intlajtlacolhuan. ");
INSERT INTO nguNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yejhua in onochiu ijcon quen on tiotlajtojquetl Isaías oquijcuilojca: Yacaj nemi ne campa tlapatlaco niman ijqui tzajtzi: “Xyectlalican nemoyojlo pampa ye huajlau toTeco. Xmejmelahuacan nemonemilis ijcon quen on tlacamej cueltlaliaj niman quimejmelahuaj se ojtli ijcuac huajlau se tlacatl yejhuan hueyixticaj. ");
INSERT INTO nguNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nochihuiyan campa tlahuejhuejcatlan ica oncaj quintlaltemasquej, niman nochimej tepemej niman tepetzitzintin ica oncaj calahuasquej para tlaixmanasquej. On ojtli xmelajqui ica oncaj quinmelahuasquej, niman on ojtli yejhuan xixmanqui ica oncaj quixmanasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Niman nochi tlalticpactlacatl quitas quen temaquixtis Dios.” ");
INSERT INTO nguNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Miyec tlacatl huajlaya itech Juan para quincuatequiaya, niman ijquin quimijliaya: ―Teconehuan intech cohuamej, ¿Aquinon omechmachiltij para xmomanahuican itech on temojtij castigo yejhuan huajlau? ");
INSERT INTO nguNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cuajli xmohuicacan para cuajli nenquiteititisquej ica yonencajcajquej nenquichihuaj on tlen xcuajli. Niman ma ca nemejhuamej nenquijtosquej: “Xitlaj huelis nochihuas totech, pampa titeconehuan itech Abraham.” Nejhua nemechijlia ica hasta in temej Dios huelis quincuepas teconehuan itech Abraham. ");
INSERT INTO nguNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nemejhuamej no ijqui quen on cojtin yejhuan xtlaquij. Nochi cojtli yejhuan xtlaquis notzontequis niman notlatis. Yejhua ica cuajli xmotacan, pampa on hacha ye oncaj listo para quintequis hasta ipan inelhuayohuan on cojtin yejhuan xtlaquij. ");
INSERT INTO nguNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Quemaj on tlacamej oquitlajtoltijquej Juan: ―¿Tlinon, tej, nonequi ticchihuasquej? ");
INSERT INTO nguNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan oquimijlij: ―On yejhuan quipia ome itlaquen, nonequi se quimacas on yejhuan xitlaj quipia, niman on yejhuan quipia tlen cuas, nonequi sequi quimacas on yejhuan xquipia. ");
INSERT INTO nguNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","No ohualajquej itech Juan sequimej tlacobrarojquej ica on impuestos para yejhua ma quincuatequi. Niman no oquitlajtoltijquej: ―Temachtijquetl, ¿tlinon nonequi ticchihuasquej? ");
INSERT INTO nguNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Niman Juan oquimijlij: ―Xtlacobrarocan san quech tlanahuatia on tlanahuatijli niman ma ca ipan xtecuilican. ");
INSERT INTO nguNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","No ijqui oquitlajtoltijquej sequimej soldados: ―Niman tejhuamej, ¿tlinon nonequi ticchihuasquej? Niman yejhua oquimijlij: ―Ma ca yacaj itlaj xcuilican, nion ma ca yacaj xteixpanhuican quen itlaj yoquichiu ijcuac xnejli oquichiu niman xpaquican san ican on quech nenquitlanij. ");
INSERT INTO nguNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nochi tlacatl sa quichixticatca para saniman ma huajla Cristo. Niman quinemiliayaj tla Juan yejhua Cristo noso ca. ");
INSERT INTO nguNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yejhua ica Juan oquimijlij: ―Melahuac nejhua nemechcuatequia ican atl. Pero huajlau ocse yejhuan quipia más hueyitilistli xquen nejhua, niman nejhua xnechmelahua nion se achijtzin nictojtomas icacmecayo. Yejhua, tej, mechcuatequis ican Espíritu Santo niman ican tlitl. ");
INSERT INTO nguNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yejhua ye ipan ima quipia on iaventador para ica cajcahuis on trigo niman quixtilis on itlajsojlo. On trigo quejehuas ipan icuescon, pero on itlajsojlo quitlatis ipan on tlitl yejhuan xqueman sehuis. ");
INSERT INTO nguNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ijcon, niman ican ocsequi miyec más tlachicahualistli, Juan quinmachiltiaya on tlacamej itech ica on cuajli tlajtojli. ");
INSERT INTO nguNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan no oquichicajcanotz on gobernador Herodes pampa Herodes quipiaya Herodías quen isihuau, masqui Herodías isihuau catca Felipe. Felipe icniu catca Herodes. Juan no oquichicajcanotz Herodes pampa oquichijca miyec ocsequi tlajtlamach tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero Herodes xoquinec, yej oquichiu ocse tlin xcuajli. Oquitzacu Juan. ");
INSERT INTO nguNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pero Herodes antes quitzacuasquia Juan, Juan oquicuatequij miyec tlacatl. Niman no ocuatequij Jesús. Quemaj chica Jesús quichihuaya oración, on ilhuicac otlapou, ");
INSERT INTO nguNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","niman on Espíritu Santo ohuajtemoc quen itlaj paloma ipan Jesús. Niman quemaj ocaquistic se tlajtojli ne ilhuicac yejhuan quijtohuaya: ―Tejhua tinotlajsojcaConetzin, niman moca nipacticaj. ");
INSERT INTO nguNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús quipiaya canaj sempoajli huan majtlactli xipan ijcuac opeu quichihua itequiu Dios. On tlacamej oquinemilijquej ica yejhua teconeu catca itech José pero xmelahuac itaj catca José. José teconeu catca itech Elí, ");
INSERT INTO nguNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","niman Elí teconeu catca itech Matat, niman Matat teconeu catca itech Leví, niman Leví teconeu catca itech Melqui, niman Melqui teconeu catca itech Jana, niman Jana teconeu catca itech José, ");
INSERT INTO nguNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","niman José teconeu catca itech Matatías, niman Matatías teconeu catca itech Amós, niman Amós teconeu catca itech Nahúm, niman Nahúm teconeu catca itech Esli, niman Esli, teconeu catca itech Nagai, ");
INSERT INTO nguNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","niman Nagai teconeu catca itech Maat, niman Maat teconeu catca itech Matatías, niman Matatías teconeu catca itech Semei, niman Semei teconeu catca itech José, niman José teconeu catca itech Judá, ");
INSERT INTO nguNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","niman Judá teconeu catca itech Joana, niman Joana teconeu catca itech Resa, niman Resa teconeu catca itech Zorobabel, niman Zorobabel teconeu catca itech Salatiel, niman Salatiel teconeucacta itech Neri, ");
INSERT INTO nguNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","niman Neri teconeu catca itech Melqui, niman Melqui teconeu catca itech Adi, niman Adi teconeu catca itech Cosam, niman Cosam teconeu catca itech Elmodam, niman Elmodam teconeu catca itech Er, ");
INSERT INTO nguNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","niman Er teconeu catca itech Josué, niman Josué teconeu catca itech Eliezer, niman Eliezer teconeu catca itech Jorim, niman Jorim teconeu catca itech Matat, ");
INSERT INTO nguNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","niman Matat teconeu catca itech Leví, niman Leví teconeu catca itech Simeón, niman Simeón teconeu catca itech Judá, niman Judá teconeu catca itech José, niman José teconeu catca itech Jonán, niman Jonán teconeu catca itech Eliaquim, ");
INSERT INTO nguNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","niman Eliaquim teconeu catca itech Melea, niman Melea teconeu catca itech Mainán, niman Mainán teconeu catca itech Matata, niman Matata teconeu catca itech Natán, ");
INSERT INTO nguNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","niman Natán teconeu catca itech David, niman David teconeu catca itech Isaí, niman Isaí teconeu catca itech Obed, niman Obed teconeu catca itech Booz, niman Booz teconeu catca itech Salmón, niman Salmón teconeu catca itech Naasón, ");
INSERT INTO nguNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","niman Naasón teconeu catca itech Aminadab, niman Aminadab teconeu catca itech Aram, niman Aram teconeu catca itech Esrom, niman Esrom teconeu catca itech Fares, niman Fares teconeu catca itech Judá, ");
INSERT INTO nguNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","niman Judá teconeu catca itech Jacob, niman Jacob teconeu catca itech Isaac, niman Isaac teconeu catca itech Abraham, niman Abraham teconeu catca itech Taré, niman Taré teconeu catca itech Nacor, ");
INSERT INTO nguNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","niman Nacor teconeu catca itech Serug, niman Serug teconeu catca itech Ragau, niman Ragau teconeu catca itech Peleg, niman Peleg teconeu catca itech Heber, niman Heber teconeu catca itech Sala, ");
INSERT INTO nguNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","niman Sala teconeu catca itech Cainán, niman Cainán teconeu catca itech Arfaxad, niman Arfaxad teconeu catca itech Sem, niman Sem teconeu catca itech Noé, niman Noé teconeu catca itech Lamec, ");
INSERT INTO nguNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","niman Lamec teconeu catca itech Matusalén, niman Matusalén teconeu catca itech Enoc, niman Enoc teconeu catca itech Jared, niman Jared teconeu catca itech Mahalaleel, niman Mahalaleel teconeu catca itech Cainán, ");
INSERT INTO nguNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","niman Cainán teconeu catca itech Enós, niman Enós teconeu catca itech Set, niman Set teconeu catca itech Adán, niman Adán teconeu catca itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús oquis itech on atempan Jordán. Niman on Espíritu Santo nochi ica quiyecanaya Jesús niman ocuicac ne campa tlapatlaco. ");
INSERT INTO nguNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne campa tlapatlaco onen ompoajli tonaltin niman on diablo ompa oquitlatlatac Jesús para tlajtlacos. Ipan on ompoajli tonaltin, Jesús xotlacuaj. Yejhua ica sanoyej apismiquiya. ");
INSERT INTO nguNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Niman on diablo oquijlij: ―Tla melahuac titeConeu itech Dios, xnahuati yejhua in tetl ma nochihua tlaxcajli. ");
INSERT INTO nguNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Niman Jesús oquijlij: ―In Yectlajcuilojli quijtohua: “Xsan ican tlaxcajli huelis nemis se tlacatl, yej no ican nochi tlajtojli yejhuan Dios quijtohua.” ");
INSERT INTO nguNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Quemaj on diablo ocuicac icuapan se hueyi tepetl, niman nimantzin oquititij nochi on países yejhuan oncaj ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Niman on diablo oquijlij: ―Nejhua nimitzmacas nochi tequihuajyotl niman on hueyilistli yejhuan oncaj ipan in países. Nochi yejhua in onechmacaquej, yejhua ica nihuelis nicmacas san aquin nicnequis nicmacas. ");
INSERT INTO nguNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tla nixpan timotlacuenquetzas niman tinechmahuistilis, nochi yejhua on moyaxca yes. ");
INSERT INTO nguNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero Jesús oquijlij: ―Xnechtlalcahui, Satanás, pampa on Yectlajcuilojli quijtohua: “Xtlacaita moTeco Dios, niman san yejhua xtequipano.” ");
INSERT INTO nguNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Quemaj on diablo ocuicac Jesús ne ipan on hueyican itoca Jerusalén niman oquitlejcoltij ne campa más tlacpac ipan on hueyi tiopan, niman oquijlij: ―Tla melahuac tejhua titeConeu itech Dios, xonmotlajcali ne tlatzintlan, ");
INSERT INTO nguNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pampa ipan on Yectlajcuilojli quijtohua: Dios quinnahuatis on iilhuicactequiticahuan ma mitzpalehuican. ");
INSERT INTO nguNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","No quijtohua: Mitzquetztehuasquej ican inmahuan para ma ca timocxicocos ican se tetl. ");
INSERT INTO nguNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ijcuacon Jesús oquijlij: ―No quijtohua on Yectlajcuilojli: “Ma ca xtlatlata moTeco Dios.” ");
INSERT INTO nguNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Niman ijcuac on diablo yotlan quitlatlata Jesús, oquitlalcahuij sequi tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Quemaj Jesús onocuep para Galilea niman nochi ica oquipalehuij ipoder on Espíritu Santo. Niman nochihuiyan oquimatquej on tlacamej tlinon quichihuaya Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yejhua temachtiaya ipan on tiopantin niman nochi tlacatl quihueyiliaya. ");
INSERT INTO nguNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Quemaj Jesús oyaj ne ipan on pueblo de Nazaret campa onoscaltij. Niman ipan on tonajli ijcuac on hebreos nosehuiaj, ocalac ipan on tiopan ijcon quen yejhua nochipa quichihuaya. Ne ipan on tiopan onotelquetz para oquinomachtij on Yectlajcuilojli ");
INSERT INTO nguNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","niman oquimacaquej on tlajcuilolamatl yejhuan on tiotlajtojquetl Isaías oquijcuilojca. Niman ijcuac oquitlapoj, oquinextij on campa tlajcuilolnesticaj: ");
INSERT INTO nguNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","On iEspíritu toTeco nopan oncaj, pampa onechcalactij ipan notequiu para niquinmachiltis on mayanquej tlacamej on cuajli temachtilistli yejhuan quitemaca temaquixtilistli. Onechajtitlan niquimpactis on yejhuan noyolajmanaj, para niquintitis ica Dios huelis quinmanahuis on yejhuan Satanás yoquinnoyaxcatijca, para niquiminmacas intlachalis on ciegos, niman para niquiminmanahuis on yejhuan tlajyohuiaj. ");
INSERT INTO nguNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Onechajtitlan para nictemachiltis ica yoyejcoc on tonaltin ijcuac Dios ican iteicnelilis quintiochihuas on yejhuan hualasquej itech. ");
INSERT INTO nguNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ijcuac Jesús otlan nomachtia, oquitzacu on tlajcuilolamatl, oquimacac on tlapalehuijquetl ipan on tiopan niman quemaj onotlalij. Niman nochimej on yejhuan nemiyaj ipan on tiopan sa conitzticatcaj. ");
INSERT INTO nguNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ijcuacon yejhua opeu ijquin quijtohua: ―Amantzin nican nemixpan otenquis on tlen quijtohua in Yectlajcuilojli. ");
INSERT INTO nguNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Niman nochimej cuajli quijtohuiliayaj Jesús niman pacatlachayaj ica on cualtzin tlajtojli yejhuan quimijliayaj. Pero ijquin quinotlajtoltiayaj: ―¿Tlica xejhua in iconeu José? ");
INSERT INTO nguNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús oquimijlij: ―Niman nicmati ica nennechijlisnequij in tlajtojli: “Tepajtijquetl, sa no tejhua xmopajti.” Niman no nennechijlisnequij: “On tlen otechmachiltijquej ica oticchiu ne Capernaum, no ijqui xchihua nican ipan in pueblo campa otimoscaltij.” ");
INSERT INTO nguNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Quemaj más otlajtoj, niman oquijtoj: ―Ica tlen melahuac nemechijlia ica xacaj tiotlajtojquetl cuajli quitlacaitaj niman quiseliaj ipan on pueblo campa noscaltia. ");
INSERT INTO nguNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nemechmelajcaijlia ica nemiyaj miyequej sihuacahualtin ne ipan Israel ipan on tonaltin ijcuac Elías on tiotlajtojquetl nemiya, ijcuac yeyi xipan huan tlajco xoquiau niman sanoyej oncatca apistli ipan nochi on país de Israel. ");
INSERT INTO nguNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Dios xocuajtitlan Elías nion se itech on sihuacahualtin yejhuan nemiyaj ne Israel, yej itech se yejhuan nemiya ipan on pueblo de Sarepta yejhuan oncaj ipan on iyehualican Sidón. ");
INSERT INTO nguNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","No ijqui ipan on tonaltin ijcuac nemiya on tiotlajtojquetl Eliseo, ne Israel nemiyaj miyequej tlacamej yejhuan quipiayaj on temojtij cualolistli itoca lepra. Pero Eliseo xoquipajtij nion se de yejhuamej, yej oquipajtij Naamán, yejhuan chantiya ne Siria. ");
INSERT INTO nguNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","On yejhuan nemiyaj ipan on tiopan, ijcuac ijcon ocacquej quen oquijtoj Jesús sanoyej ocualanquej. ");
INSERT INTO nguNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yejhuamej ohuajnoquetztejquej niman oquixtijquej Jesús ipan on pueblo. On pueblo itoca Nazaret oncatca ipan se tepetl. Quemaj ocuicaquej más tlacpac ipan on tepetl para cuajtlajcalisquiaj ne ipan on teostotl campa más tlacpac. ");
INSERT INTO nguNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ijcuac ompa ye cuajtlajcalisquiaj, Jesús intlajcotian ohuajpanoc niman oyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Quemaj Jesús otemoc ipan on pueblo itoca Capernaum, yejhuan oncaj ipan on iyehualican Galilea. Niman ipan on tonajli ijcuac on hebreos nosehuiaj ompa opeu quiminmachtia on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Niman on tlacamej sanoyej mojcatlachayaj quen temachtiaya pampa yejhua temachtiaya quen se tequihuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ne ipan on tiopan nemiya se tlacatl yejhuan quipiaya se xcuajli espíritu. Yejhua on espíritu se demonio. Niman yejhua chicahuac otzajtzic: ");
INSERT INTO nguNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Xtechcahua! ¿Tlinon ticchihuas tohuan tejhuamej, Jesús aquin otihualeu Nazaret? ¿Otihuajlaj para titechxoxotonis? Nejhua nimitzixmatzticaj, niman nicmatzticaj ica tejhua tiichipajcaConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús ocajhuac on xcuajli espíritu, niman oquijlij: ―¡Ma ca xnahuati! ¡Xquisa ijtic yejhua in tlacatl! Quemaj on xcuajli espíritu imixpan oquitlajcaltiaj on tlacatl, niman quemaj oquis, pero xoc itlaj oquichihuilij. ");
INSERT INTO nguNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ijcuac on tlacamej ijcon oquitaquej, nochimej ojmojcatlachixquej niman ijquin quinojlayaj: ―¿Tlinon quipia itlajtol on tlacatl? ¡Ican itlajtol de tlanahuatijli niman poder quinnahuatia on xcuajcualtin espíritus, niman yejhuamej quitlacamatij! ");
INSERT INTO nguNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Niman nochihuiyan noteijliaya on tlen Jesús oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Quemaj Jesús oquis ne ipan on tiopan niman ocalac ne ichan Simón. Imonan Simón sanoyej cualohuaya ican totonqui, niman oquitlajtlanilijquej Jesús para ma quipajti. ");
INSERT INTO nguNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús ohuajnopachoj itech on sihuatl niman quemaj ocajhuac on totonqui para ma cahua, niman on totonqui ocau on sihuatl. Nimantzin yejhua onoquetzteu niman opeu quintlacualtia. ");
INSERT INTO nguNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ijcuac ye calacticatca tonajli, nochimej on tlacamej yejhuan quipiayaj incocoxcahuan oquinhuajhuicaquej itech Jesús. On cocoxquej quipiayaj sesetlamantic cualolistin, pero ipan cada se de yejhuamej Jesús oquitlalij imahuan niman ijqui oquimpajtij. ");
INSERT INTO nguNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Intech on miyequej cocoxquej no oquisquej on xcuajcualtin espíritus yejhuan tzajtziyaj niman quijtohuayaj: ―Tejhua titeConeu itech Dios. Pero Jesús quimajhuatiaya niman xquincahuiliaya ma tlajtocan, pampa yejhuamej quimatzticatcaj ica yejhua Cristo. ");
INSERT INTO nguNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Huajmostla ijcuac otlanes, Jesús oquis ipan on hueyican niman oyaj campa tlapatlaco. Niman on tlacamej quitejtemohuayaj. Niman ijcuac oquinextijquej, quejecohuayaj quiteltisquej para ma ca ma nejcuani intech. ");
INSERT INTO nguNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesús oquimijlij: ―Nejhua ica oncaj nitemachtis on cuajli tlajtojli no ipan on ocsequimej pueblos quen Dios tlamandarojticaj, pampa yejhua ica Dios onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ijcon, tej, temachtijtinemiya Jesús ne ipan on tiopantin yejhuan oncaj ipan on iregión Galilea. ");
INSERT INTO nguNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ipan se tonajli Jesús nemiya ne itenco on atl itoca Genesaret. Niman miyec tlacatl oyaj itech niman hasta quipitzmictiayaj para caquisquej itemachtil Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús oquitac ome barco ne itenco on atl. On michajsiquej yehuaticatcaj niman quipajpacticatcaj inmatl. ");
INSERT INTO nguNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Quemaj Jesús otlejcoc ipan on se barco yejhuan iyaxca Simón, niman oquitlajtlanilij Simón para achijtzin ma calacti ne atlajcotian. Quemaj Jesús onotlalij ne ipan on barco niman oquiminmachtij on tlacamej yejhuan nemiyaj ne atlatenco. ");
INSERT INTO nguNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Niman ijcuac Jesús otlan quiminmachtia on tlacamej, oquijlij Simón: ―Xcuica yejhua in barco ne campa más achi huejcatlan niman ompa xconchapanican nemomatlahuan para nenquimajsisquej on michimej. ");
INSERT INTO nguNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón oquijlij: ―Temachtijquetl, tejhuamej nochi tlayohua otiquejecojquej tiquimajsisquej on michimej niman xqueman itlaj oticajsiquej. Pero pampa tejhua titechnahuatia, tejhuamej ticonchapanisquej in matlatl. ");
INSERT INTO nguNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ijcuac oconchapanijquej on matlatl, ocajsiquej miyec michin niman hasta ye cocotoniya on matlatl. ");
INSERT INTO nguNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Quemaj oquinmanotzquej on intequipanojcaxihuan yejhuan nemiyaj ipan on ocse barco para ma quimpalehuijquij. Niman yejhuamej ohualajquej, niman oquitemiltijquej on ome barco ican michimej niman hasta ye polaquisnequiyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Niman ijcuac Simón Pedro oquitac on tlen onochiu, onotlacuenquetztiaj ixpan Jesús niman oquijlij: ―Xnechtlalcahui, noTeco, pampa nejhua nitlajtlacolej. ");
INSERT INTO nguNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón niman nochimej yejhuan ihuan nemiyaj otlamojcaitaquej, pampa ocajsiquej miyec michin. ");
INSERT INTO nguNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","No ijqui onomojtijquej Jacobo niman Juan, iconehuan Zebedeo, yejhuan itequipanojcaxihuan catca Simón. Pero Jesús oquijlij Simón: ―Ma ca xmomojti, pampa desde aman xoc tiquintejtemos michimej para tiquinmajsis, yej tiquintejtemos tlacamej para tiquiminmachtis on itlajtol Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Niman ijcuac oquinquixtijquej on barcos itenco on atl, nochi ompa ocajtejquej niman oyajquej ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ijcuac Jesús nemiya ipan se pueblo, ompa oyejcoc se tlacatl yejhuan quipiaya se cualolistli itoca lepra. On cualolistli quipalanaltijtiaya san miyecan ipan itlalnacayo. Ijcuac yejhua on tlacatl oquitac Jesús, ixpan onotlacuenquetz niman ixayac hasta ipan tlajli oquitlalij. Niman yejhua ijquin sanoyej oquitlajtlanilij: ―Señor, tla ticnequi, huelis tinechpajtis. ");
INSERT INTO nguNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Quemaj Jesús oquimatocac, niman oquijlij: ―Nicnequi. Aman xpajti. Niman ijcuac Jesús ijcon oquijtoj, on cualolistli nimantzin opopoliu ipan on tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Quemaj Jesús oquinahuatij on tlacatl para ma ca yacaj quitlajtlajtohuilis aquinon oquipajtij. Oquijlij: ―San xhuiya niman xmoteititi ne itech on tiopixqui para mitzitas ica xoc ticualo. Niman pampa yotipajtic, xcuentlali on tlen Moisés otlanahuatij. Ijcon, tej, on tlacamej quitasquej ica yotipajtic. ");
INSERT INTO nguNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero on tlen Jesús quichihuaya más nohuiyan machiyaya, niman miyec tlacatl nosentlaliaya itech para caquisquej niman para yejhua quimpajtilis incualolis. ");
INSERT INTO nguNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús miyecpa quintlalcahuiyaya on tlacamej niman yaya ne campa tlapatlaco para ompa quichihuaya oración. ");
INSERT INTO nguNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Se tonajli ne campa Jesús temachtiaya, yejyehuaticatcaj sequimej fariseos, niman on temachtijquej ica on tlanahuatiltin yejhuan hualehuayaj san mijmiyecan nochimej ipan on pueblos de Galilea, de Judea niman no de on hueyican itoca Jerusalén. Niman Jesús oquipix ipoder Dios para quimpajtiaya on cocoxquej. ");
INSERT INTO nguNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sequimej tlacamej oyejcoquej yejhuan ocualajantiajquej ipan cojtlapechtli se tlacatl yejhuan sepojtoya. Niman quinequiyaj calactisquej ne calijtic niman quitlalisquej ixpan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero xohuelquej ocalaquej, pampa miyec tlacatl ompa nemiya. Yejhua ica otlejcoquej icuapan on cajli. Niman ijcuac yoquejcuanijquej on tejas, oquitemoltijquej on cocoxqui ipan icojtlapech intlajcotian on tlacamej, niman melajqui ixpan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ijcuac Jesús oquitac ica on tlacamej otlaneltocaquej, oquijlij on yejhuan cualo: ―Tlacatl, motlajtlacolhuan yonimitzintlapojpolhuilij. ");
INSERT INTO nguNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Quemaj on temachtijquej ica on tlanahuatijli niman on fariseos opeu ijquin quinemiliaj: “¿Aquinon in tlacatl? ¿Tlica cuijhuicaltijticaj Dios ican itlajtol? Xacaj hueli quitetlapojpolhuilia on tlajtlacojli, yej san Dios.” ");
INSERT INTO nguNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús quimatzticatca tlinon yejhuamej quinemilijticatcaj, niman oquimijlij: ―¿Tlica ijcon nenquinemiliaj? ");
INSERT INTO nguNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Catlejhua más xtepopolo niquijtos: “Motlajtlacolhuan yotlapojpolhuiloquej”, noso yej niquijtos: “Xmoquetztehua niman xnejnemi”? ");
INSERT INTO nguNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aman cuajli nejhua nemechititis ica nejhua, yejhuan oninochiu Tlacatl, nicpia tequihuajyotl ipan in tlalticpactli para nitetlapojpolhuilis on tlajtlacoltin. Quemaj oquijlij on tlacatl yejhuan sepojtoya: ―Tejhua nimitzijlia, xmoquetztehua, xcajcocui motlapech niman xhuiya mochan. ");
INSERT INTO nguNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nimantzin on yejhuan sepojtoya ohuajnotelquetz imixpan on tlacamej, ocajcocu itlapech yejhuan ipan onoya niman oyaj ichan. Niman cueyilijtiaya Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nochimej on tlacamej omojcatlachixquej niman ocueyilijquej Dios, niman ican miyec nemotijli oquijtojquej: ―Aman yotiquitaquej on tlajtlamach yejhuan xqueman tiquitayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Más saquin ijcuac yopanoc yejhua on, Jesús oquis, niman oquitac se tlacatl itoca Leví yehuaticatca ne campa tlacobrarohuaya ica impuestos. Niman Jesús oquijlij: ―Xhuajla nohuan. ");
INSERT INTO nguNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Niman quemaj Leví ohuajnotelquetz, ocajteu nochi, niman oyaj ihuan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Más saquin, Leví oquichiu se hueyi ilhuitl para Jesús ne ichan, niman ompa miyequej nemiyaj yejhuan tlacobrarohuaj ica impuestos niman ocsequimej más tlacamej yejhuan ompa inhuan san secan yejyehuaticatcaj itech mesa. ");
INSERT INTO nguNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero on fariseos niman on temachtijquej ican on tlanahuatijli yejhuan no nopohuaj inhuan on fariseos opejquej quimichtacaajhuaj on inomachtijcahuan Jesús, niman oquimijlijquej: ―¿Tlica nemejhuamej nentlacuaj niman nenatlij inhuan on yejhuan tlacobrarojquej ica impuestos, niman inhuan on tlajtlacolejquej? ");
INSERT INTO nguNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús oquimijlij: ―On yejhuan xcualoj xquimpolohua on tepajtijquetl, pero on yejhuan cualoj quemaj. ");
INSERT INTO nguNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nejhua xonihuajlaj para niquinnotzas on yejhuan yolmelajquej, yej on yejhuan tlajtlacolejquej para amo ma quichihuacan on tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Quemaj yejhuamej oquitlajtoltijquej Jesús: ―¿Tlica miyecpa nosahuaj niman quichihuaj oraciones on yejhuan nohuicaj ihuan Juan niman on yejhuan nohuicaj ihuan on fariseos, pero monomachtijcahuan tlacuaj niman atlij? ");
INSERT INTO nguNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús oquimijlij: ―¿Nemejhuamej huelis nenquinnesahualtisquej on tlanotzaltin ne campa nonamictihua chica on montli ompa inhuan nemi? ");
INSERT INTO nguNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero xmatztiacan ica yejcos on tonajli ijcuac on montli quinquixtilisquej, niman ijcuacon quemaj nosahuasquej notemachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","No oquintlalijlij in ocse ejemplo: ―Xacaj quitequi on tlaquentli yencuic para ica quitlamanilia on yejhuan tlaquentli ijsoltic. Tla se ijcon quichihua, quixpolohua on yencuic tlaquentli, niman no on tlaquentli yencuic xoc cuajli ihuan nocahua on tlaquentli ijsoltic. ");
INSERT INTO nguNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Niman no xacaj quitlalia on vino yencuic ipan on bolsas tlachijchiutin ican on cuetlaxtli ijsoltiquej, pampa on vino posonis niman on bolsas toponisquej, niman quemaj on vino ihuan on bolsas ixpolihuisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yejhua ica más cuajli notecas on vino yencuic ipan on bolsas tlachijchiutin ican cuetlaxtin yencuiquej para ijcon on ome tlamantin cuajli quixicosquej. ");
INSERT INTO nguNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Niman xacaj yejhuan yoconic on vino yejhuan ye quipia tonaltin ica oncaj, quinequis conis on vino yencuic pampa quijtohua: “On vino yejhuan ye quipia tonaltin ica oncaj, más huelic.” ");
INSERT INTO nguNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ipan se tonajli ijcuac on hebreos nosehuiaj, Jesús nejnentiaya ne campa oncaj on tlatoctli de trigo. On inomachtijcahuan quimaxicopinayaj on trigo, niman quimateiniayaj niman quicuayaj on iteyo. ");
INSERT INTO nguNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Niman sequimej fariseos oquintlajtoltijquej: ―¿Tlica nenquichihuaj on tequitl yejhuan itlanahuatil Moisés xquitecahuilia nochihuas ipan on tonaltin de nesehuijli? ");
INSERT INTO nguNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús oquimijlij: ―¿Xqueman nenquimomachtianij on tlen oquichijca David ijcuac yejhua niman itetequipanojcaxihuan oapismiquej? ");
INSERT INTO nguNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ocalac ne ipan itiopan Dios niman oquitilan on pan yejhuan tlatiochiutli. Quemaj ocuaj on pan niman no oquiminmacac on yejhuan ompa inhuan nemiyaj, masqui on itlanahuatil Moisés san quimincahuiliaya on tiopixquej quicuayaj on pan. ");
INSERT INTO nguNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","No ijqui oquimijlij: ―Tej, nejhua yejhuan oninochiu Tlacatl nicpia tequihuayotl para niquijtos tlinon cuajli para se quichihuas ipan on tonajli de nesehuijli. ");
INSERT INTO nguNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ipan ocse tonajli de nesehuijli, Jesús ocalac ipan se tiopan niman ompa temachtiaya. Ompa nemiya se tlacatl yejhuan quipiaya on iyecma huaqui. ");
INSERT INTO nguNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Niman on temachtijquej ican on tlanahuatijli niman on fariseos quipijpiayaj Jesús para quitasquej tla quipajtis on tlacatl ipan on tonajli de nesehuijli. Ijcon oquichijquej para quinextilisquej tlinon ica huelis quiteixpanhuisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús quimatzticatca tlinon yejhuamej quinemiliayaj, niman oquijlij yejhua on tlacatl yejhuan quipiaya ima huaqui: ―Xmotelquetza niman xhuia ne tlajcotian. On tlacatl onotelquetz niman ompa oyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Quemaj Jesús oquimijlij on ocsequimej: ―Nejhua nemechtlajtoltis yejhua in: ¿Tlinon techcahuilia itlanahuatil Moisés ticchihuasquej ipan on tonajli de nesehuijli, on tlen cuajli noso on tlen xcuajli? ¿Techcahuilia ticmaquixtilisquej inemilis se tlacatl noso tiquixtilisquej inemilis? ");
INSERT INTO nguNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Quemaj Jesús oquimixtlaloj on yejhuan quiyehualojticatcaj, niman oquijlij on tlacatl: ―Xmelahua moma. On tlacatl oquimelau ima, niman opajtic. ");
INSERT INTO nguNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero on ocsequimej sanoyej ocualanquej, niman opeu notlajtoltiaj tlinon huelis quichihuilisquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ipan on tonajli Jesús otepetlejcoc para quichihuas oración. Niman ne ipan on tepetl nochi tlayohua oquichiu oración itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ijcuac otlanes, oquiminnotz inomachtijcahuan, niman de yejhuamej oquintlapejpenij majtlactli huan ome nomachtijquej yejhuan oquintocayotij apóstoles. ");
INSERT INTO nguNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ijquin intoca catca on apóstoles: Simón, yejhuan Jesús oquitocayotij Pedro, Andrés icniu Simón, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO nguNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo iconeu Alfeo, Simón, yejhuan intech on cananistas nopohuaya, ");
INSERT INTO nguNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas icniu Jacobo niman Judas Iscariote, yejhuan más saquin oquitemactilij Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús ihuan miyequej inomachtijcahuan ohuajtemoc ne ipan on tepetl, niman campa tlaixmanco ompa onoteltij. Niman ompa nemiyaj miyequej tlacamej yejhuan chanejquej nochihuiyan ne Judea, niman on hueyican Jerusalén niman ipan on huejhueyican de Tiro niman de Sidón yejhuan oncaj ipan itenco on mar. Yejhuamej in ompa oyajquej para ocaquitoj Jesús niman para itech oquipajtitoj incualolis. ");
INSERT INTO nguNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","On yejhuan tlajyohuiyaj pampa quipiayaj on xcuajcualtin espíritus no opajtiquej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nochi tlacatl quinequiya quimatocas Jesús, pampa ipoder quisaya itech niman quimpajtiaya nochimej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ijcuac Jesús oquimixtlaloj on inomachtijcahuan oquimijlij: ―Dios mechtiochihua nemejhuamej pobres, pampa nencalaquisquej ne campa Dios tequihuajtiticaj. ");
INSERT INTO nguNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Dios mechtiochihua nemejhuamej yejhuan nemapismiquij, pampa nemejhuamej nemixhuisquej. ’Dios mechtiochihua nemejhuamej yejhuan aman nenchocaj, pampa nemejhuamej nempaquisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Dios mechtiochihua nemejhuamej ijcuac on tlacamej mechtlahuelitasquej, ijcuac xmechselisquej, ijcuac mechhuijhuicaltisquej, niman ijcuac mechtejtenehuasquej san pampa nennechneltocaj nejhua yejhuan oninochiu Tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ijcuac ijcon nochihuas sanoyej xmopactican niman xtemican ican paquilistli, pampa ne ilhuicac nenquiselisquej se hueyi tlaxtlahuijli. On inachtojtajhuan no ijqui oquinchihuilijquej on tiotlajtojquej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero lástima para nemejhuamej ricos, pampa on paquilistli yejhuan nenquipiaj tlamis sa no ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Lástima para nemejhuamej yejhuan nemijixhuitoquej pampa nenquipiasquej apistli. ’Lástima para nemejhuamej yejhuan aman nempaquij, pampa nenchocasquej niman nemajmanasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Lástima para nemejhuamej ijcuac nochi tlacatl mechijtohuilia on tlen cuajli. On inachtojtajhuan no ijqui quinmijtohuiliayaj on yejhuan xmelahuac tiotlajtojquej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Pero nemejhuamej yejhuan nennechcaquij nemechijlia: Xquintlajsojtlacan on nemotlahuelicnihuan; xquinchihuilican tlen cuajli on yejhuan mechtlahuelitaj. ");
INSERT INTO nguNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xtlajtlanilican Dios para ma quintiochihua on yejhuan mechhuijhuicaltiaj; xchihuacan oración impampa on yejhuan mechchihuiliaj tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tla yacaj mitzxayacahuitequi, no xcahuili ocse lado ma mitzxayacahuitequi. Niman tla yacaj mitzcuilia mogában, no xcahuili ma quitqui motlaquen. ");
INSERT INTO nguNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","San aquinon yejhuan quinequi itlaj mitztlajtlanilis, xmaca. Niman on yejhuan mitzcuilis tlen moyaxca, ma ca sa xtlajtlanili para ma mitzmaca. ");
INSERT INTO nguNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xquinchihuilican ocsequimej on tlen nemejhuamej nenquinequisquiaj para yejhuamej ma mechchihuilican. ");
INSERT INTO nguNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tla nemejhuamej nenquintlajsojtlaj san yejhuamej on yejhuan no mechtlajsojtlaj, ¿tlinon cuajli nenquichihuaj más xquen ocsequimej? pampa hasta on tlajtlacolejquej ijqui quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Noso tla on yejhuan mechchihuiliaj on tlen cuajli san yejhuamej nenquinchihuiliaj on tlen cuajli, ¿tlinon cuajli nenquichihuaj más xquen ocsequimej? pampa on yejhuan tlajtlacolejquej no ijqui quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Niman tla itlaj nenquintlanejtiaj san yejhuamej on yejhuan nenquinemiliaj intech nenquiselisquej ocsejpa sa no ijqui, ¿tlinon cuajli nenquichihuaj más xquen ocsequimej? Xitlaj más cuajli nenquichihuaj xquen ocsequimej pampa on tlajtlacolejquej no itlaj quintlanejtiaj on yejhuan no tlajtlacolejquej para intech quiseliaj ocsejpa sa no ijqui. ");
INSERT INTO nguNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero nemejhuamej xquimintlajsojtlacan on nemotlahuelicnihuan niman xquinchihuilican on tlen cuajli. Niman itlaj xquimintlanejtican pero ma ca nenquichasquej itlaj intech nenquiselisquej. Tla ijcon nenquichihuasquej, nenquipiasquej se hueyi tetlayocolijli, niman nemejhuamej nenteconehuan yesquej itech Dios yejhuan más hueyixticaj, pampa yejhua yolyemanqui intech on yejhuan xitlaj quitlajsojcamatij niman intech on yejhuan xcuajcualtin tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nemejhuamej, tej, xteicnelican ijcon quen nemoTajtzin teicnelia. ");
INSERT INTO nguNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ma ca xquinmistlacocan ocsequimej, niman Dios xmechistlacos. Ma ca xquintlajtlacolmacacan ocsequimej, niman Dios xmechtlajtlacolmacas. Xtetlapojpolhuican, niman Dios no mechtlapojpolhuis. ");
INSERT INTO nguNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xquinmacacan tlajtlamach on ocsequimej, niman Dios no mechmacas. Xquinmacacan quen se cuajli tlanamacaquetl quitemaca ican se tlatemachihuajli yejhuan cuajli tenticaj, yejhuan cuajli quipachohua, niman yejhuan quicoxonia niman yejhuan quitehuitzoltia, pampa Dios mechmacas sa no ijqui quen nemejhuamej nenquiminmacaj ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús oquintlalilij yejhua in ocse ejemplo: ―¿Tlen se ciego huelis quiyecanas ocse ciego? Yejhua xhueli, pampa onxinisquej san secan ipan se pozo. ");
INSERT INTO nguNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Xacaj nomachtijquetl más hueyixticaj xquen on yejhuan quimachtia. Pero ijcuac tlamis nomachtis, no ijqui yes quen on yejhuan quimachtia. ");
INSERT INTO nguNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Quen ijqui, tej, hueli tiquita on quesqui tlajtlacojli yejhuan quichihua se mocniu niman xtiquita on miyec tlajtlacojli yejhuan tejhua ticchihua? ");
INSERT INTO nguNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Noso, ¿quen ijqui hueli tiquijlia mocniu: “Ma nimitzcajcahualti on quesqui tlajtlacojli”, ijcuac sa no tejhua ticpia miyec tlajtlacojli? ¡Omexayacyej! Achtopa xcajcahua on miyec tlajtlacojli yejhuan ticpia, niman quemaj huelis ticajcahualtis mocniu on quesqui tlajtlacojli yejhuan yejhua quipia. ");
INSERT INTO nguNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’On cuajli cojtlaquilyotl xhuelis quipias xcuajli itlaquilyo nion on xcuajli cojtlaquilyotl xhuelis quipias cuajli itlaquilyo. ");
INSERT INTO nguNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ijcon, tej, nochi cojtlaquilyotl nixmati ica on itlaquilyo. Xqueman notequi higos ipan on huitzcojtli, nion xnotequi uvas ipan on huitzcuamecatl. ");
INSERT INTO nguNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","On cuajli tlacatl quijtohua nochi tlen cuajli, pampa on tlen cuajli oncaj ipan iyojlo, niman on xcuajli tlacatl quijtohua on tlen xcuajli, pampa on tlen xcuajli oncaj ipan iyojlo. On tlen se tlacatl quijtohua ican icamac, on sa no yejhua ica tenticaj iyojlo. ");
INSERT INTO nguNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Tlica nennechijliaj, “noTeco, noTeco”, niman xnenquichihuaj on tlen nemechijlia? ");
INSERT INTO nguNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nemechijlis quen aquinon nesi on yejhuan notech huajlau niman nechcaqui niman quichihua on tlen nejhua nitlanahuatia. ");
INSERT INTO nguNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nesi quen se tlacatl yejhuan oquitlalij se cajli. Yejhua achtopa huejcatlan otlachcuac para huejcatlan oquipehualtij on cimiento ipan on tepetlatl. Niman ijcuac ohueyiyac on atepeyatl, on atl chicahuac oquichcuato on cajli, pero nion xoocolinij, pampa huejcatlan otzimpeu on cimiento ipan on tepetlatl. ");
INSERT INTO nguNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero on yejhuan nechcaqui niman xquichihua on tlen nitlanahuatia, nesi quen se tlacatl yejhuan san ixco tlajli oquitlalij ical niman xican cimiento. Yejhua ica ijcuac on atepeyatl ohueyiyac niman chicahuac oquichcuato ohuetz, niman nochi cuajli oxoxoton. ");
INSERT INTO nguNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ijcuac Jesús otlan oquijtoj nochi in tlajtlamach imixpan on tlacamej, oyaj ne Capernaum. ");
INSERT INTO nguNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ompa nemiya se capitán romano yejhuan quipiaya se itequichihuilijcau niman sanoyej quitlajsojtlaya. On itequichihuilijcau sanoyej cualohuaya niman ye micticatca. ");
INSERT INTO nguNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Niman ijcuac on capitán ocac quitenehuaj Jesús, oquinnahuatij on tlajtlajmatquej tlayecanquej yejhuan quisayaj intzajlan on hebreos para ma quicnotlajtlanilitij Jesús para ma quipajtiti on itequichihuilijcau. ");
INSERT INTO nguNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yejhuamej oquinisihuijquej Jesús niman opeu sanoyej quicnotlajtlaniliaj, quilayaj: ―Yejhua in capitán quimelahua niman cuajli para ticpalehuis, ");
INSERT INTO nguNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pampa yejhua quitlajsojtla topaís niman yejhua oquichijchiu totiopan ican itomin. ");
INSERT INTO nguNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Quemaj Jesús inhuan oyaj. Pero ijcuac ye nisiu nemiyaj ne ichan on capitán, yejhua on capitán oquinnahuatij sequimej itetlajsojcahuan para ijquin ma quijlitij Jesús: ―NoTeco, ma ca xmopajsolo pampa nejhua xnechmelahua para ticalaquis nochan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nion xnechmelahua para nejhua nimitznotzas. San xtlanahuati niman notequichihuilijcau pajtis. ");
INSERT INTO nguNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ijcon nochihuas pampa nejhua no nicmati quen niquintlacamati on notequihuajhuan ijcuac itlaj nechnahuatiaj, niman nejhua no niquimpia soldados yejhuan nechtlacamatij ijcuac niquinnahuatia. Ijcuac se nicnahuatia canaj ma huiya, yau. Ijcuac ocse niquijlis ma huajla, huajlau. Niman ijcuac on notequichihuilijcau nicnahuatia itlaj ma quichihua, quichihua. ");
INSERT INTO nguNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ijcuac Jesús ijcon ocac, sanoyej oquitlatlachaltij. Quemaj ohuajnocuep niman oquimixtlaloj on tlacamej yejhuan quicuitlapanhuijtiayaj niman oquijtoj: ―Ica tlen melahuac nemechijlia ica nion se hebreo xqueman niquita sanoyej tlaneltoca quen yejhua in tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","On yejhuan oquintitlancaj onocuepquej ichan on capitán niman oquinextitoj on tequichihuilijquetl yopajtic. ");
INSERT INTO nguNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Achijtzin más saquin Jesús yaya ipan se pueblo itoca Naín, niman ihuan yayaj on inomachtijcahuan niman miyequej ocsequimej tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ijcuac ye quinisihuijtiayaj icalaquiyan on pueblo, oquitac ica cuicayaj contocasquej se micatzintli. Yejhua san ica nochi catca teconeu itech se sihuacahualtzintli. Miyec tlacatl yejhuan chanejquej ipan on pueblo huajlayaj ihuan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ijcuac on toTeco oquitac on sihuacahualtzintli, oquicnelij, niman oquijlij: ―Ma ca xchoca. ");
INSERT INTO nguNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Quemaj Jesús oquinnisihuij niman oquimatocac on caja, niman on yejhuan quechpanohuayaj onoteltijquej. Niman Jesús oquijlij on micatzintli: ―Telpochtli, nejhua nimitzijlia: ¡Xmoquetztehua! ");
INSERT INTO nguNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Quemaj on yejhuan yomica onotlalij niman opeu tlajtlajtohua, niman Jesús oquimactilij inan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ijcuac nochimej ijcon oquitaquej, onomojtijquej niman opeu cueyiliaj Dios, quijtohuayaj: ―Sen hueyi tiotlajtojquetl ononextij totzajlan. No quijtohuayaj: ―Dios yohuajlaj niman oquinnotzaco iconehuan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Niman ipan nochi on iyehualican Judea niman ipan nochi on iyehualican omachiyac on tlen Jesús oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Niman Juan no oquimat nochi yejhua on, pampa inomachtijcahuan oquitlajtlajtohuilijquej. Quemaj oquinnotz omemej inomachtijcahuan, ");
INSERT INTO nguNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","niman oquintitlan itech Jesús para quitlajtoltisquej tla yejhua melahuac Cristo yejhuan ye oncaj para huajlas, noso yej quichasquej ocse. ");
INSERT INTO nguNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","On yejhuan oquintitlan Juan, oquinisihuijquej Jesús niman oquijlijquej: ―On tlacuatequijquetl Juan, otechajtitlan para timitztlajtoltisquej tla tejhua tiCristo yejhuan ye oncaj para huajlas noso yej ticchasquej ocse. ");
INSERT INTO nguNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sa no ipan on tonaltin chica inomachtijcahuan Juan ompa nemiyaj, Jesús oquimpajtij miyequej tlacamej ica on cualolistin niman cocolistin, niman ica on xcuajcualtin espíritus, niman no oquinmacac tlachalistli miyequej on yejhuan ciegos. ");
INSERT INTO nguNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Quemaj Jesús oquinnanquilij on inomachtijcahuan Juan: ―Xhuiyan niman xquijlican Juan on tlen nemejhuamej yonenquitaquej niman yonencaquej. Xtlajtlajtohuilican ica aman tlachaj on yejhuan ciegos catcaj, niman on yejhuan huilatzitzintin catcaj quistinemij, niman on yejhuan palaniyaj innacayo pajtij, niman on yejhuan nacastzatzamej catcaj tlacaquij, niman on yejhuan mimiquej yolihuij niman noquetztehuaj ipan intlalcon. Niman no xtlajtlajtohuilican ica on yejhuan mayanquej caquij on cuajli tlajtojli yejhuan quitemaca temaquixtilistli. ");
INSERT INTO nguNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sanoyej tlatiochiutli on yejhuan xqueman ometlamatis san nopampa. ");
INSERT INTO nguNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ijcuac oyajquej on yejhuan oquintitlanca Juan, Jesús opeu tenojnotza ica Juan niman oquimijlij: ―¿Aquin onenquitatoj ne tlapatlaco? ¿Onenquitatoj se tlacatl yejhuan nolinia itlaneltoc quen se ohuatl nolinijticaj ica on ajacatl? ");
INSERT INTO nguNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Aquinon, tej, onenquitatoj? ¿Onenquitatoj se tlacatl yejhuan tlaquempepetlaca? Nemejhuamej nenquimatztoquej ica on yejhuan sanoyej tlaquempepetlacaj niman cuelitaj nemisquej campa paquiloyan, nemij inchan on yejhuan reyes. ");
INSERT INTO nguNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aman, tej, ¿aquinon onenquitatoj? ¿Onenquitatoj se tiotlajtojquetl? Quemaj, on melahuac, niman yejhua más hueyixticaj xquen se tiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","In Juan on tenojnotzquetl yejhuan ica in Yectlajcuilojli ijquin quijtohua: On yejhuan notech tenojnojtzquetl nictitlanis moyecapan para yejhua mitzyectlalilis mojhui para tias ipan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nemechijlia ica intzajlan nochimej on tlacamej, xqueman yacaj otlacat yejhuan más hueyixticaj tiotlajtojquetl quen Juan on tlacuatequijquetl. Pero in no melahuac ica on yejhuan quinocahuilis ma quimandaro Dios más hueyi tetlajsojtlalistli quipias xquen Juan quipia, masqui yejhua xmás hueyixticaj quen Juan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ijcuac ocacquej Juan, nochimej on tlacamej niman hasta on yejhuan tlacobrarojquej ica impuestos oquitaquej ica Dios melajcanemi, niman yejhua ica onocuatequijquej itech Juan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero on fariseos niman on temachtijquej ican on itlanahuatil Dios xoquiselijquej itemachtil Dios niman yejhua ica xonocuatequijquej itech Juan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Niman on toTeco oquijtoj: ―¿Tlinon ica huelis niquimixtlalos on tlacamej yejhuan nemij ipan in tonaltin? ¿Quen aquinomej nesij? ");
INSERT INTO nguNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ijcomej quen on coconej yejhuan nahuiltiaj ne plaza niman on intehuicalhuan quintzajtziliaj: “Otemechtlapichilijquej ica on acatlapitzaltin quen quintlapichiliaj ipan se nonamictilistli, pero nemejhuamej xonemijtotijquej. Otemechcuicatlalijquej ica on tlacuicajli teajman yejhuan quinocuicatiaj ijcuac se miqui niman xonenchocaquej.” ");
INSERT INTO nguNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ohuajlaj Juan on tlacuatequijquetl yejhuan nosahua niman xconi vino, niman nemejhuamej nenquijtohuaj ica quipia se xcuajli espíritu. ");
INSERT INTO nguNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Quemaj onihuajlaj nejhua yejhuan oninochiu Tlacatl. Ijcuac nejhua yejhuan nitlacuani niman niatlini onihuajlaj, nemejhuamej onenquijtojquej ica melahuac nitlacuani niman ica sanoyej niatlini. Niman onenquijtojquej ica nitetlajsojcau itech on tlajtlacojquej niman on yejhuan tlacobrarojquej ica on impuestos. ");
INSERT INTO nguNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero on itlamatquilis Dios nopanextia melahuac impan on yejhuan tlajmatquej. ");
INSERT INTO nguNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Semej yejhuamej on fariseos oquinotz Jesús para ihuan tlacuas. Niman Jesús oyaj ichan on fariseo niman onotlalij itech on mesa. ");
INSERT INTO nguNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sa no ipan on pueblo nemiya se sihuatl yejhuan xcuajli nohuicaya. Niman ijcuac yejhua oquimat ica Jesús oyaj otlacuato ichan on fariseo, oyaj oquitquic se botella tlachijchiutli ican tetl yejhuan fino. On botella tentiaya ican aceite ajhuiyac. ");
INSERT INTO nguNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Niman chica chocaticatca, onotlalij icxitlan Jesús niman opeu quimpajpaca icxihuan ican ixayo. Quemaj oquinhuajhuachilij ican itzon. No oquintencualij niman quemaj oquintequilij on aceite ajhuiyac. ");
INSERT INTO nguNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ijcuac on fariseo yejhuan oquinotz Jesús, ijcon oquitac, oquinemilij: “Tla yejhua in tlacatl melahuac tiotlajtojquetl yesquia, quimatisquia aquinon quimatocaticaj niman ica xcuajli nohuica, pampa yejhua se tlajtlacolej.” ");
INSERT INTO nguNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Quemaj Jesús oquijlij on fariseo: ―Simón, nicpia tlinon nimitzijlis. On fariseo oquijlij: ―Xnechijli, Temachtijquetl. ");
INSERT INTO nguNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús oquijtoj: ―Sen tlacatl oquintlanejtij tomin omemej tlacamej. Se tlacatl oquitlanejtij macuijli cientos denarios, niman ocse ompoajli huan majtlactli. ");
INSERT INTO nguNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Niman ica on omemej tlacamej xhueliyaj cuepayaj on tomin, on yejhuan oquintlanejtij on tomin oquimimpopolohuilij tlen quitehuiquiliayaj. Aman xnechijli, ¿catlejhua de on omemej más oquipialij tetlajsojtlalistli? ");
INSERT INTO nguNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón oquijlij: ―Nejhua nicuitia ica yejhua on yejhuan más hueyi oquipopolohuilij on tlen quitehuiquiliaya. Jesús oquijlij: ―Cuajli otiquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Quemaj Jesús onocuep para ocontac on sihuatl, niman oquijlij Simón: ―Onicalac mochan niman xotinechmacac atl para nocxihuan. Pero, ¿tiquita yejhua in sihuatl? Yejhua in sihuatl oquinpajpac nocxihuan ican ixayo, niman oquinhuajhuatz ican itzon. ");
INSERT INTO nguNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nion xotinechtencuaj ijcuac otinechtlajpaloj, pero yejhua desde ijcuac nican onicalaquico xcajticaj ica quintencua nocxihuan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Xotinechtlalilij aceite ipan notzontecon, pero yejhua oquitoyau aceite ajhuiyac ipan nocxihuan. ");
INSERT INTO nguNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nimitzijlia ica on miyec itlajtlacol aman yotlapojpolhuiloc ipampa ihueyitetlajsojtlalis. Pero on yejhuan achijtzin itlajtlacol quitlapojpolhuiliaj san achijtzin quiteititia itetlajsojtlalis. ");
INSERT INTO nguNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Quemaj Jesús oquijlij on sihuatl: ―Motlajtlacol nochi yotlapojpolhuiloc. ");
INSERT INTO nguNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Niman on tenotzquej yejhuan ompa ihuan yejyehuaticatcaj opeu sa no yejhuamej quinojliaj: ―¿Aquin tlacatl in? ¿Tlica quinemilia hueli quitetlapojpolhuilia tetlajtlacol? ");
INSERT INTO nguNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Jesús oquijlij on sihuatl: ―Aman yotimaquis pampa otitlaneltocac. Xhuiya ican yolsehuilistli. ");
INSERT INTO nguNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Más saquin Jesús oquistinen ipan miyec huejhueyican niman pueblitos. Quiteijlijtiaya niman quitemacatiaya on cuajli temachtilistli quen Dios tlamandarohua. Niman majtlactli huan ome apóstoles cuicatinemiyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","No ijqui cuicatinemiyaj sequimej sihuamej on yejhuan oquinquixtilijca on xcuajcualtin espíritus niman oquimpajtijca ica incualolis. Semej on sihuamej yejhuan ompa yayaj itoca María yejhuan no itoca catca Magdalena. Itech in sihuatl oquisquej on chicomemej xcuajcualtin espíritus. ");
INSERT INTO nguNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","No ompa tehuan yaya Juana, yejhuan isihuau Chuza. Chuza tlajtlajmatqui catca itech Herodes. No ijqui ompa tehuan yaya Susana niman miyequej ocsequimej más yejhuan quipalehuiyaj ican on tlen quipiayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Miyequej tlacamej oquisquej ipan on pueblos para quitasquej Jesús. Niman ijcuac miyec tlacatl onosentlalij, oquinnojnotz ican se ejemplo. Oquimijlij: ");
INSERT INTO nguNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Sen tocaquetl otlaxinito. Ijcuac tlaxiniaya, sequi xinachtli oxinito ipan ojtli niman ipan ochojcholojquej, niman on totomej oquicuajquej. ");
INSERT INTO nguNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Niman ocsequi xinachtli oxin ipan tepetlayoj, niman ijcuac in xinachtli oquis, nimantzin ohuajhuac pampa oquipoloto tlacuechahualistli. ");
INSERT INTO nguNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ocsequi xinachtli oxin intzajlan on huitzcojtin, niman on tlen oixhuac oxomic pampa semi ihuan oquis on huitzcojtin. ");
INSERT INTO nguNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero ocsequi xinachtli oxin campa cuajli tlajli. Ijcuac oquis, onoscaltij niman oquipix cuajli itlaquilyo, niman cada xinachtli oquitlaquitij ciento iteyo. Ijcuac Jesús otlan quijtohua yejhua in, ican chicahuac tlajtojli oquimijlij: ―Tla nemejhuamej nenquipiaj nemotlacaquilis, xcajsicamatican on ejemplo. ");
INSERT INTO nguNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Quemaj on inomachtijcahuan oquitlajtoltijquej tlinon quijtosnequi on ejemplo. ");
INSERT INTO nguNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Niman Jesús oquimijlij: ―Nemejhuamej Dios yomechcahuilij para nenquimatisquej on tlinon iyanticatca quen ijqui yejhua tlamandarohua. Pero on ocsequimej niquinnojnotza ican ejemplos para ijcuac quitasquej on tlen nicchihua niman caquisquej on ejemplos, ma ca ma cajsicamatican. ");
INSERT INTO nguNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Niman on ejemplo yejhua in quijtosnequi: On xinachtli quijtosnequi itlajtol Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","On ojtli yejhuan ipan oxinito quesqui xinachtli quijtosnequi inyojlo on tlacamej yejhuan san caquij itlajtol Dios. Pero huajlau on diablo niman quejcuania ipan inyojlo itlajtol Dios para ma ca ma quineltocacan niman ma ca ma nomaquixtican. ");
INSERT INTO nguNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","On tepetlayoj yejhuan sequi xinachtli ipan oxin, quijtosnequi inyojlo on tlacamej yejhuan caquij on itlajtol Dios niman quiseliaj ican pactli. Pero san tlaneltocaj ipan quesqui tonaltin, pampa on itlajtol Dios xnonelhuayotia huejcatlan ipan inyojlo. Yejhua ica ijcuac quintlatlata on tlen xcuajli noxelohuaj itech on tlaneltoctli. ");
INSERT INTO nguNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","On tlajli ne intzajlan on huitzcojtin campa ipan oxin on xinachtli quijtosnequi on yejhuan caquij itlajtol Dios pero xhueli tlaqui pampa sa comatztoquej quen ijqui nopanoltisquej niman sanoyej quinequij notomintisquej niman paquisquej ipan innemilis. ");
INSERT INTO nguNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero on cuajli tlajli yejhuan ipan oxin on xinachtli quijtosnequi inyojlo on tlacamej yejhuan ican cuajli inyojlo melahuac cuelcaquij itlajtol Dios niman quiseliaj niman quixicohuaj nochi on tetlatlatalistli. Yejhuamej quipiaj cuajli intlaquilyo. ");
INSERT INTO nguNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Xacaj quitlicuiltia itlahuil niman quemaj itlaj ica quitlapachohua noso quitlalia itzintlan tlapechtli, yej tlacpac quitlalia para on yejhuan ompa calaquij huelij tlachaj. ");
INSERT INTO nguNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Xitlaj oncaj yejhuan iyanticaj niman ijqui nocahua, yej quipantlantisquej. Niman xitlaj yejhuan ichtaca oncaj yejhuan xacaj quimatis, yej nochi nopanextis. ");
INSERT INTO nguNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Yejhua ica, tej, xmotacan sa no nemejhuamej quen nencaquij pampa on yejhuan quipia tlamachilistli, Dios quimacas más, pero on yejhuan xquipia tlamachilistli, hasta on yejhuan quinemilia quipia Dios quixtilis. ");
INSERT INTO nguNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Quemaj inan niman icnihuan Jesús ohualajquej campa yejhua nemiya, pero xhueliyaj quinisihuiayaj pampa miyec tlacatl ompa nemiya. ");
INSERT INTO nguNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yacaj ijquin oquijlij Jesús: ―Monan niman mocnihuan ompa on nemij ipan ojtli niman quinequij mitzitasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero yejhua oquinnanquijlij niman oquimijlij: ―On tlacamej yejhuan caquij itemachtil Dios niman quitlacamatij, yejhua nonan niman nocnihuan. ");
INSERT INTO nguNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Se tonajli Jesús ocalac ipan se barco ihuan on inomachtijcahuan, niman oquimijlij: ―Tiahuij ne ipan ocse ilado in atl. Quemaj oyajquej. ");
INSERT INTO nguNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Niman chica quipanahuiayaj on atl, Jesús ococh. Niman ipan on atl opeu temojtij ajaca, hasta on barco opeu temi ican atl, niman ye mero polaquiyaj. Sanoyej temojtijcatca. ");
INSERT INTO nguNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Quemaj on nomachtijquej oquitlachaltitoj Jesús, niman oquijlijquej: ―¡Temachtijquetl! ¡Temachtijquetl! ¡Ye tiapolactoquej! Quemaj Jesús onotelquetz niman ocajhuac on ajacatl niman on atl yejhuan najcocuiya. Nimantzin nochi onoteltij niman nochi cuajli onocau. ");
INSERT INTO nguNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Quemaj oquimijlij on inomachtijcahuan: ―¿Canon nenquipiaj ne motlaneltoc? Pero yejhuamej sanoyej onomojtijquej niman otlatlachixquej niman quinotlajtoltiayaj semej ihuan ocsequimej: ―¿Manin aquin tlacatl in ica hueli quimandarohua on ajacatl niman on atl, niman yejhuamej quitlacamatij? ");
INSERT INTO nguNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Niman quemaj oquipanahuijquej on atl niman oyejcoquej ipan on pueblo itoca Gadara, yejhuan oncaj ipan on ocse ilado on atl ixpan Galilea. ");
INSERT INTO nguNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ijcuac Jesús otemoc ipan on barco, oquinisihuij se tlacatl yejhuan chanej ne Gadara. Yejhua in tlacatl ye quipiaya miyec tonaltin ica quipiaya on xcuajcualtin espíritus. Yejhua xquitlaliaya itlaquen nion chantiya ipan cajli, yej san neca nemiya ijtic on teostomej yejhuan imijtic quintocayaj on mimiquej. ");
INSERT INTO nguNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ijcuac in tlacatl oquitac Jesús, otzajtzic niman onotlacuenquetztiaj ixpan. Niman quemaj oquijlij ican chicahuac tlajtojli: ―¿Tlinon ticnequi nohuan, Jesús, tejhua titeConeu itech Dios yejhuan más hueyixticaj? Sanoyej nimitztlajtlanilia ma ca tinechtlajyohuiltis. ");
INSERT INTO nguNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ijcon oquijtoj pampa Jesús quinahuatijticatca on xcuajli espíritu ma quisa ijtic on tlacatl. Niman masqui on tlacamej quimasajsalohuayaj niman quicxisajsalohuayaj ican teposcadenas, yejhua quitecojcotonaya niman on xcuajli espíritu quichihualtiaya ma huiya neca campa tlacauyan. ");
INSERT INTO nguNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús oquitlajtoltij: ―¿Quen ijqui motoca? Niman yejhua oquijlij: ―Nejhua nicpia miyec notoca. Ijcon oquijtoj pampa sanoyej miyequej catcaj on xcuajcualtin espíritus yejhuan nemiyaj ijtic on tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Niman on xcuajcualtin espíritus sanoyej oquitlajtlanilijquej Jesús para ma ca quintitlanis ne mictlan campa tetlajyohuiltiloyan. ");
INSERT INTO nguNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Niman ompa nemiyaj miyequej pitzomej ipan se tepetl campa tlacuajcuajtinemiyaj. On xcuajcualtin espíritus sanoyej oquitlajtlanilijquej Jesús para ma quincahuili calaquisquej ne impan on pitzomej, niman yejhua oquincahuilij. ");
INSERT INTO nguNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Quemaj nimantzin on xcuajcualtin espíritus oquisquej ipan on tlacatl niman ocalaquej impan on pitzomej. Niman yejhuamej on pitzomej nochimej oquiquistequej niman ne ipan on teostotl campa huejcatlan oxixinitoj hasta ijtic on mar niman nochimej oamimiquej. ");
INSERT INTO nguNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","On yejhuan tlapiayaj ica on pitzomej, ijcuac oquitaquej tlinon onochiu, ican innemojtil onotlajtlalojquej para oquitetlajtlajtohuilitoj ne ipan on hueyican niman nochihuiyan techachan yejhuan oncatcaj ipan tepemej. ");
INSERT INTO nguNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Niman on tlacamej oyajquej oquitatoj on tlen onochiu. Ijcuac oajsiquej ne campa nemiya Jesús, oquinextitoj on tlacatl, yejhuan ipan oquisquej on xcuajcualtin espíritus, yehuaticatca icxitlan Jesús. Niman ye nemiya ican itlaquen niman ocsejpa oquipix cuajli itlamachilis, niman yejhuamej onomojtijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Niman on yejhuan oquitaquej quen ijqui onochiu itech on yejhuan quipiaya on xcuajcualtin espíritus, oquintlajtlajtohuilijquej on yejhuan quemach ompa oyajquej quen ijqui onochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Quemaj nochi tlacatl yejhuan chanej ipan iregión on hueyican itoca Gadara opeu sanoyej quitlajtlaniliaj Jesús para ma nejcuani ompa, pampa yejhuamej sanoyej nomojtiayaj. Yejhua ica Jesús ocalac ipan barco niman oyaj ocse lado. ");
INSERT INTO nguNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","On tlacatl yejhuan ipan oquisquej on xcuajcualtin espíritus sanoyej oquitlajtlanilij Jesús para ma cahuili ihuan huiya, pero yejhua oquinahuatij para ma nocahua. ");
INSERT INTO nguNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ijquin oquijlij: ―Xmocuepa para mochan niman xtetlajtlajtohuili nochi on huejhueyi tlajtlamach tlen Dios omitzchihuilij. Yejhua ica on tlacatl oyaj, niman oquintlajtlajtohuilij nochimej ipan on hueyican nochi tlen Jesús oquichihuilij. ");
INSERT INTO nguNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ijcuac Jesús onocuep ne ipan ocse ilado on atl, on tlacamej oquiselijquej ican pactli, pampa nochimej quichixticatcaj. ");
INSERT INTO nguNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Quemaj itech ohuajlaj se tlacatl itoca Jairo, yejhuan tlayecanquetl catca ipan on tiopan. Yejhua in tlacatl onotlacuenquetz icxitlan Jesús niman oquicnotlajtlanilij para ma huiya ichan, ");
INSERT INTO nguNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","pampa on isihuasenteconeu yejhuan quipiaya canaj majtlactli huan ome xipan ye micticatca. Chica Jesús yaya, miyec tlacatl oyaj ihuan niman hasta quipitzmictiayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","No ompa tehuan yaya se sihuatl yejhuan quipia majtlactli huan ome xipan ica yeshuetztinemiya. Niman nochi tlen quipiaya oquipopoloj intech on tlapajtijquej, niman xacaj ohuel oquipajtij. ");
INSERT INTO nguNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yejhua ocuitlapannisihuij Jesús niman ocajsic itempan itlaquen niman quemaj nimantzin onoteltij on ica yeshuetziya. ");
INSERT INTO nguNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Quemaj Jesús otetlajtoltij: ―¿Aquinon onechmatocac? Ijcuac nochimej oquinenequej, Pedro niman itehuicalhuan oquijtojquej: ―Temachtijquetl, tiquitzticaj in tlacamej sa mitzmapehuaj niman mitzpitzmictiaj, niman yej titlajtlani: “¿aquinon onechmatocac?” ");
INSERT INTO nguNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús oquijtoj: ―Yacaj onechmatocac, pampa onicmat ijcuac oquis notech on poder para aquinon on onicpajtij. ");
INSERT INTO nguNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ijcuac on sihuatl oquitac ica yopanes, ican icuecuetlacalis ohuajlaj niman onotlacuenquetz icxitlan Jesús. Quemaj yejhua oquijlij imixpan nochimej on tlacamej tlica ocajsic itlaquen, niman ica nimantzin opajtic. ");
INSERT INTO nguNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ijcuacon Jesús oquijlij: ―Noconeu, otipajtic pampa otitlaneltocac. Xhuiya ican yolsehuilistli. ");
INSERT INTO nguNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús oc tlajtlajtojticatca, ijcuac oyejcoc se tlacatl yejhuan ohualeu ne ichan Jairo, itlayecancau on tiopan. Niman on tlacatl oquijlij Jairo: ―Mochpocatzin yomic. Ma ca sa xpajsolo in temachtijquetl. ");
INSERT INTO nguNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ijcuac Jesús ocac yejhua in, oquijlij Jairo: ―Ma ca xmomojti, yej san xtlaneltoca melahuac, niman mochpocatzin pajtis. ");
INSERT INTO nguNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ijcuac oajsiquej ichan Jairo, Jesús xocahuilij yacaj más ihuan ocalac, yej san Pedro, Jacobo, Juan niman itajhuan on ichpocatzin. ");
INSERT INTO nguNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nochimej quichoquilijticatcaj niman najmanticatcaj ipampa on ichpocatzin. Pero Jesús oquimijlij: ―Ma ca xchoquilican. In ichpocaconetl xmiqui, yej san cochtica. ");
INSERT INTO nguNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero yejhuamej san ocuetzquilijquej, pampa quimatzticatcaj ica on ichpocaconetl yomic. ");
INSERT INTO nguNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Quemaj Jesús oquitzquij ipan ima on ichpocaconetl niman oquijlij chicahuac: ―Ichpocaconetl, xmoquetztehua. ");
INSERT INTO nguNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Niman yejhua ocsejpa otlachix niman oquipix nemilistli, niman nimantzin onotelquetz. Quemaj Jesús otlanahuatij ma quitlacualtican on ichpocaconetl. ");
INSERT INTO nguNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Itajhuan on ichpocaconetl sa tlachixticatcaj, pero Jesús oquimijlij ma ca yacaj quijlisquej on tlen onochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús oquinsentlalij on majtlactli huan ome apóstoles niman oquinmacac poder niman tlanahuatijli para quintequixtilisquej nochi on xcuajcualtin espíritus niman para tepajtisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Quemaj oquintitlan ma quiteijlitij on temachtijli ica Dios quinequi tlamandaros inca yejhuamej on yejhuan quinocahuiliaj, niman para quimpajtisquej on cocoxquej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Niman oquimijlij: ―Ma ca itlaj xquictican para ipan ojtli, nion cojtopijli, nion bolsa, nion tlacuajli, nion tomin. Niman san se nemotlaquen xquitquican. Ma ca ome. ");
INSERT INTO nguNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Xmocahuacan ipan san catlejhua cajli campa nemajsisquej hasta ijcuac nemejcuanisquej ipan on pueblo. ");
INSERT INTO nguNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Niman campa xmechselisquej, xquisacan ipan on pueblo niman xtzejtzelocan ipan nemocxi on tlalteutli, para ma quimatican ica yejhuamej cualaniaj Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yejhuamej, tej, oyajquej ipan nochi on pueblitos, niman temachtiayaj on cuajli tlajtojli yejhuan quitemaca temaquixtilistli niman quimpajtijtiayaj on cocoxquej nochihuiyan. ");
INSERT INTO nguNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","On gobernador Herodes ocac tlen Jesús quichihuaya, niman xquimatiya tlinon quinemilis, pampa sequimej quijtohuayaj ica Juan yoyoliu niman yonoquetzteu ipan itlalcon, ");
INSERT INTO nguNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","niman ocsequimej quijtohuayaj ica on yejhua on tiotlajtojquetl Elías yejhuan yononextij. Niman ocsequimej quijtohuayaj ica semej on ye huejcahui tiotlajtojquej yoyoliu niman yonoquetzteu ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Herodes oquijtoj: ―Sa no nejhua onitlanahuatij para ma quiquechtzontequican Juan. ¿Manin, tej, aquinon on tlacatl yejhuan nicaqui quitenehuaj quichihua miyec tlajtlamach? Niman Herodes quichihuaya canica para quitas Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ijcuac on apóstoles onocuepquej, oquitlajtlajtohuilijquej Jesús nochi tlinon oquichijquej. Quemaj oquinhuicac niman oyajquej ipan se tlapatlaco nisiu ipan on hueyican, itoca Betsaida. ");
INSERT INTO nguNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero ijcuac on tlacamej oquimatquej, oyajquej ihuan. Niman Jesús oquinselij niman oquinnojnotz ica on quen Dios tlamandarohua impan on yejhuan quinocahuiliaj, niman Jesús no oquimpajtij on cocoxquej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ijcuac ye tiotlactitiaya, on majtlactli huan ome nomachtijquej oquijlijquej: ―Xquintijtitlani on tlacamej para ma quitejtemotij canon cochisquej niman tlen quicuasquej ipan on pueblitos niman mijmiyecan campa san nijnisiu, pampa nican campa tinemij xitlaj oncaj. ");
INSERT INTO nguNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesús oquimijlij: ―Nemejhuamej xquinmacacan tlen quicuasquej. Niman yejhuamej oquijtojquej: ―Xticpiaj más tlacuajli yej san yejhuan in macuijli pan niman in ome michimej. ¿Ticnequi ma ticohuatij tlacuajli para nochimej in tlacamej? ");
INSERT INTO nguNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","On tlacamej canaj macuijli mil catcaj. Pero Jesús oquimijlij on inomachtijcahuan: ―Xquinnahuatican ma nosehuican ipan grupos de ompoajli huan majtlactli ne ipan on sacayo. ");
INSERT INTO nguNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yejhuamej ijqui oquichijquej niman nochimej onotlajtlalijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Quemaj ijcuac Jesús ocontilan on macuijli pan niman on ome michimej, oajcotlachix ne ilhuicac niman oquimacac tlaxtlahuijli Dios para on tlacuajli. Niman quemaj ijcuac yoquitlatlapan on pan, oquinmacac on inomachtijcahuan para ma quinxexelohuilican on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yejhuamej otlacuajquej niman nochimej oixhuiquej. Niman quemaj on nomachtijquej ica on tlatlajcotzitzintin tlen onocau oquitemiltilijquej majtlactli huan ome chiquiutin. ");
INSERT INTO nguNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Se tonajli ijcuac Jesús iselti quichijticatca oración, niman on inomachtijcahuan ompa ihuan nemiyaj, oquintlajtoltij: ―On tlacamej, ¿quen quijtohuaj aquin nejhua? ");
INSERT INTO nguNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yejhuamej oquijlijquej: ―Sequimej quijtohuaj ica tejhua tiJuan on tlacuatequijquetl, ocsequimej qujtohuaj ica tejhua tiElías, niman no sequimej quijtohuaj ica tise on ye huejcahui tiotlajtojquej yejhuan yoyoliu niman yonoquetzteu ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Quemaj oquintlajtoltij: ―Niman nemejhuamej, ¿quen nenquijtohuaj aquin nejhua? Niman Pedro oquijlij: ―Tejhua tiCristo yejhuan ohualeu itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero yejhua sanoyej cuajli oquinnahuatij para ma ca yacaj ijcon quijlisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Niman oquimijlij: ―Nejhua yejhuan oninochiu Tlacatl ica oncaj niquijyohuis miyec tlajtlamach. On tlajtlajmatquej niman intlayecancahuan on tiopixquej niman on temachtijquej ican itlanahuatil Dios xnechselisquej. Nechmictisquej, pero ipan yeyi tonajli niyolihuis niman ninoquetztehuas ipan notlalcon. ");
INSERT INTO nguNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Niman nochimej oquimijlij: ―Tla yacaj quinequi nohuan yas, ma quelcahua on tlen quinequi, ma nemi listo para tlajyohuis mojmostla no ijqui quen se tlacatl tlayohuia sanoyej ijcuac quimamajtiu icojnepanol ne campa quimictisquej, niman nohuan ma huajla. ");
INSERT INTO nguNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yejhua in nemechijlia pampa yejhuan quinequis quimaquixtis inemilis ipan in tlalticpactli, quipolos ialma, pero yejhuan san nopampa quipolos inemilis ipan in tlalticpactli yejhua quiselis nemilistli para ialma. ");
INSERT INTO nguNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Xitlaj ica quipalehuis on tlacatl tla quinoyaxcatis nochi tlen oncaj ipan in tlalticpactli niman sa no yejhua popolihuis noso noxoxotonis. ");
INSERT INTO nguNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tla yacaj, tej, noca pinahua niman ica pinahua on tlen nictemachtia, nejhua yejhuan oninochiu Tlacatl no ica nipinahuas ijcuac nihuajlas ican nohueyilis, ican ihueyilis noTajtzin niman inhueyilis on yejyejtoquej iilhuicactequitcahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ica tlen melahuac nemechijlia ica sequimej yejhuan aman nican nemij quitasquej Dios tlamandaros ijcuac xe mimiquij. ");
INSERT INTO nguNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Canaj ipan chicueyi tonajli más saquin ica ijcon oquijtoj, Jesús oquinhuicac Pedro, Jacobo niman Juan ihuan niman otlejcoc ipan se tepetl para oquichihuato oración. ");
INSERT INTO nguNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Niman chica Jesús quichijticatca oración, onixpatlac niman on itlaquen sanoyej oistayac niman opetlan. ");
INSERT INTO nguNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Quemaj ohuajnonextijquej omemej tlacamej ihuan tlajtlajtohuayaj, niman on tlacamej yejhuamej catcaj Moisés niman Elías. ");
INSERT INTO nguNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yejhuamej huatlachixticatcaj ijtic on hueyilistli sanoyej petlani niman tlajtlajtohuayaj quen Jesús miquis ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Masqui Pedro niman itehuicalhuan sanoyej cochisnequiyaj, onotlachaltijquej, niman oquitaquej on ihueyilis Jesús niman on omemej tlacamej yejhuan ompa inhuan nemiyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ijcuac on tlacamej ye quitlalcahuijtiayaj Jesús, Pedro oquijlij: ―Temachtijquetl, ¡sanoyej cuajli ica nican tinemij! Ma ticchijchihuacan yeyi caltzitzintin: se para tejhua, ocse para Moisés niman ocse para Elías. Pero Pedro xquimatiya tlinon quijtohuaya. ");
INSERT INTO nguNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Niman chica Pedro ijcon tlajtohuaya, ohuajlaj se moxtli yejhuan oquintlapachoj niman ijcuac oquitaquej ica yomoxcalaquej, onomojtijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Quemaj ne ipan moxtli ocaquistic se tlajtojli yejhuan oquijtoj: ―In yejhua notlajsojcaConeu. Yejhua xtencaquican. ");
INSERT INTO nguNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ijcuac yotlan caquisti on tlajtojli, oquitaquej ica Jesús sa iselti nemiya. Yejhuamej xoc onahuatquej niman xacaj itlaj oquijlijquej ipan on tonaltin on tlen oquitaquej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ijcuac huajmostla, otemoquej ne ipan on tepetl, niman miyec tlacatl oquinamiquito Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Quemaj se tlacatl yejhuan nemiya ne intzajlan on tlacamej oquijlij ican chicahuac tlajtojli: ―Temachtijquetl, por favor xquita nosenteconeu, ");
INSERT INTO nguNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","pampa cajsi se xcuajli espíritu yejhuan quichihualtia san tzajtzitehua niman quemaj sanoyej quitzejtzelohua hasta camaposonalquisa. Sanoyej quitlajyohuiltia niman xquinequi quitlalcahuis. ");
INSERT INTO nguNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Sanoyej yoniquinmicnotlajtlanilij on monomachtijcahuan para ma quixtilican on xcuajli espíritu, pero xohuelquej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús oquijtoj: ―¡Oh tlacamej yejhuan xtlaneltoca niman xmelajqui tlanemiliaj! ¿Hasta quemanon nemohuan ninemis niman nemechxicos? Nican xcuajhuica moconeu. ");
INSERT INTO nguNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pero ijcuac on telpochtli quinisihuiaya Jesús, on xcuajli espíritu oquitlajcal ipan tlajli niman sanoyej oquitzejtzeloj. Pero Jesús nimantzin ocajhuac on xcuajli espíritu, oquipajtij on telpochtli niman quemaj oquimactilij itaj. ");
INSERT INTO nguNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Niman nochimej oquintlatlachaltij on ihueyilis Dios. Chica nochimej tlamocaitzticatcaj ica nochi on tlen Jesús quichihuaya, yejhua oquimijlij on inomachtijcahuan: ");
INSERT INTO nguNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Cuajli xcaquican yejhua in, niman ma ca xquelcahuacan. Nejhua yejhuan oninochiu Tlacatl nechtemactilisquej intech on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero on nomachtijquej xcajsicamatiyaj tlinon yejhua quimijliaya, pampa xe quincahuiliayaj quimatisquej. Niman yejhuamej nomojtiayaj quitlajtoltisquej Jesús ma quinmelajcaijli on tlen quimijlijticatca. ");
INSERT INTO nguNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Quemaj on nomachtijquej opejquej nocamatlanij yejhua ica on aquinon más hueyixtias ne intzajlan. ");
INSERT INTO nguNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús oquimat on tlen yejhuamej quinemilijticatcaj. Yejhua ica oquitilan se conetl niman inacastlan oquitlalij. ");
INSERT INTO nguNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Quemaj oquimijlij: ―San aquinon yejhuan nopampa quiselia yejhua in conetl, nejhua nechselia. Niman yejhuan nejhua nechselia, no quiselia on yejhuan onechajtitlan. Ijcon, tej, on yejhuan más xitlaj quijtojticaj nemotzajlan, on yejhuan más hueyixticaj. ");
INSERT INTO nguNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Quemaj Juan oquijlij: ―Temachtijquetl, otiquitaquej se tlacatl yejhuan ican motocatzin quintequixtiliaya on xcuajcualtin espíritus, pero tejhuamej oticnahuatijquej ma ca sa ijqui ma quichihua, pampa xtohuan quistinemi. ");
INSERT INTO nguNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesús oquijlij: ―Ma ca xtlacahualtican, pampa on yejhuan xitlaj ica techixnamiqui, tohuan nopohua. ");
INSERT INTO nguNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ijcuac ye nisiu on tonajli ica Jesús tlejcos ne ilhuicac, opeu nejnemi ican yolchicahualistli para Jerusalén. Ijcon, tej, ocajsic iojhui para Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Oquintitlan sequimej iyecapan, niman yejhuamej oyajquej ipan se pueblito yejhuan oncaj ne ipan on iregión Samaria para oquitejtemotoj canon nosehuis. ");
INSERT INTO nguNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero on yejhuan chantiyaj ipan on pueblito xoquinequej quiselijquej pampa oquitaquej ica yau ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ijcuac on nomachtijquej Jacobo niman Juan ijcon oquitaquej, oquijlijquej Jesús: ―ToTeco, ¿ticnequi para ma titlanahuatican ma huajhuetzi tlitl ne ilhuicac ijcon quen oquichiu on tiotlajtojquetl Elías para nochimej ma tlatlacan? ");
INSERT INTO nguNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Quemaj Jesús oquimixtlaloj niman oquimajhuac, oquimijlij: ―Nemejhuamej xnenquimatij tlinon nemojtic yocalac. ");
INSERT INTO nguNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nejhua, tej, yejhuan oninochiu Tlacatl onihuajlaj xpara niquinxoxotonilis innemilis on tlacamej, yej para niquinmaquixtilis. Quemaj oyajquej ipan ocse pueblito. ");
INSERT INTO nguNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Chica yejhuamej yayaj ipan ojtli, se tlacatl oquijlij Jesús: ―NoTeco, nicnequi nias mohuan san canon tejhua tias. ");
INSERT INTO nguNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús oquijlij: ―On ostotzitzintin quipiaj intecalhuan, niman on totomej quipiaj intepajsol, pero nejhua yejhuan oninochiu Tlacatl xnicpia nion canon nicochi. ");
INSERT INTO nguNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús oquijlij on ocse tlacatl: ―Xhuajla nohuan. Pero yejhua oquijlij: ―NoTeco, xnechcahuili achtopa ma nihuiya para nicontocas notaj niman quemaj mohuan nias. ");
INSERT INTO nguNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús oquijlij: ―Xquincahua on yejhuan mictoquej ixpan Dios ma quintocacan on inmicatzitzihuan, pero tejhua xhuiya niman xteijli on temachtijli yejhuan quitemachiltia quen ijqui Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Quemaj ocse no ijqui oquijlij: ―NoTeco, nicnequi mohuan niyas, pero achtopa xnechcahuili ma niquinnahuatiti nochanchanecahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero Jesús oquijlij: ―On yejhuan pehua yau nohuan niman noteltia, nemi quen se tlacatl yejhuan pehua tequiti ica on tepostlaxoponajli, niman quemaj icuitlapan on tlacha. On yejhuan ijcon quichihua xitlaj ica hueli tlapalehuiya ne campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Más saquin, toTeco oquintlapejpenij yepoajli huan majtlactli tlacamej, niman ojomemej iyecapan oquintitlan ipan nochi pueblos niman lugares campa yejhua yasquia. ");
INSERT INTO nguNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Antes yasquiaj oquimijlij: ―On pixquilistli sanoyej hueyi, pero xmiyequej nemij on pixcaquej para pixcasquej. Yejhua ica, tej, xtlajtlanilican iTeco on pixquilistli para ma quinhuajtitlani más tequitquej para ma pixcaquij. ");
INSERT INTO nguNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nemejhuamej xhuiyan. Nemechtitlani quen borreguitos intzajlan on lobos. ");
INSERT INTO nguNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma ca xquictican bolsa, nion tomin, nion cactin. Niman ma ca xmoteltican para yacaj nenquitlajpalosquej ipan ojtli. ");
INSERT INTO nguNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ijcuac nencalaquisquej techan, achtopa xtetlajpalocan, xteijlican: “¡Xyolsejtiacan chanejquej!” ");
INSERT INTO nguNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Niman tla ompa nemij yacaj yejhuan quinequi quipias yolsehuilistli, nocahuas nemotetlajpalohualis. Pero tla ca, nemotetlajpalohualis nocuepas nemotech. ");
INSERT INTO nguNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","San se cajli ipan xmocahuacan ne campa quiselisquej nemotetlajpalohualis. Xtlacuacan niman xconican on tlinon yejhuamej mechmacasquej, pampa on tequitquetl quimelahua quipias itlaxtlahuil. Ma ca nenquipatlasquej on chanyotl. ");
INSERT INTO nguNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ijcuac nemajsisquej ipan se pueblo campa mechseliaj, xcuacan tlinon mechmacasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xquimpajtican on cocoxquej yejhuan ompa nemij niman xquimijlican on tlacamej yejhuan chantij ne: “Dios yomechnisihuij para yejhua mechmandaros.” ");
INSERT INTO nguNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero tla nemajsij ipan se pueblo campa xmechseliaj, xquisacan ipan on calles niman xquijtocan: ");
INSERT INTO nguNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hasta itlalteuyo nemopueblo yejhuan onocau ipan tocxihuan tictzejtzelohuaj para temechititiaj ica nencualaniaj Dios. Pero xmatican ica Dios yomechnisihuij para mechmandaros.” ");
INSERT INTO nguNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nemechijlia ica ipan on tonajli ijcuac Dios teyolcuitis niman tetlajtlacolmacas, on pueblo más temojtij quiselis icastigo xquen on tlacamej yejhuan chantij ipan on hueyican Sodoma. ");
INSERT INTO nguNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Tla on chanejquej ipan on huejhueyican intoca Tiro niman Sidón quitasquiaj on milagros yejhuan oquitaquej Corazín niman Betsaida, yejhuamej ye huejcahui cacahuasquia ica quichihuaj on tlen xcuajli. Niman yejhuamej notlaquentisquiaj ican tlaquentli yejhuan tlachijchiutli ican ichtli niman quinotemilisquiaj tliconextli ipan intzontecon para quiteititisquiaj ica yocajcajquej quichihuaj on tlen xcuajli. Yejhua ica temojtij yes para yejhuamej on yejhuan chantij ipan on pueblos itoca Corazín niman Betsaida pampa ijcuac oquitaquej on milagros xonoyolcuepquej. ");
INSERT INTO nguNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Niman nemechijlia ica ipan on tonajli ijcuac Dios teyolcuitis niman tetlajtlacolmacas, yejhuamej más hueyi castigo quiselisquej xquen on tlacamej ne Tiro niman Sidón. ");
INSERT INTO nguNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Niman yejhuan chanejquej ipan on pueblo Capernaum sanoyej nohueyimatij ipampa on hueyilistli yejhuan quipia ipueblo. Yejhuamej quinemiliaj quinmacas Dios hueyilistli ne ilhuicac pero quinmacas tlajyohuilistli ne mictlan. ");
INSERT INTO nguNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’On yejhuan mechcaqui, nejhua nechcaqui. Niman on yejhuan xmechselia, nejhua xnechselia, niman on yejhuan xnechselia, xquiselia on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Más saquin ijcuac yotlanquej oquistinenquej, on yepoajli huan majtlactli nomachtijquej onocuepquej ican pactli niman oquijlijquej Jesús: ―¡ToTeco, hasta on xcuajcualtin espíritus otechtlacamatquej ijcuac otiquinnahuatijquej ican motocatzin yejhuan otitechmacac! ");
INSERT INTO nguNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús oquimijlij: ―Nejhua oniquitac ohuetzico Satanás ne ilhuicac quen itlaj tlapetlanajli. ");
INSERT INTO nguNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xquitacan, nejhua onenmechmacac poder para impan nencholosquej on cohuamej niman on colomej, niman para nenquitlanisquej nochi icojtilis on totlahuelicniu, niman xitlaj huelis mechcocos. ");
INSERT INTO nguNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero ma ca xpaquican pampa tla on xcuajcualtin espíritus mechtlacamatij, yej xpaquican pampa nemotoca ye tlajcuilolnesticaj ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Quemaj on Espíritu Santo sanoyej oquipactij Jesús niman Jesús oquijtoj: ―Nimitzhueyilia noTajtzin, iTeco ilhuicac niman tlalticpactli, pampa otiquinmiyanilij in tlajtlamach on yejhuan tlajmatquej niman on tlacajsicamatquej, niman otiquimpantlantilij on yejhuan mitzneltocaj quen coconej. Quemaj, noTajtzin, ijquin oticchiu pampa tejhua ijqui oticnec. ");
INSERT INTO nguNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Quemaj Jesús oquijtoj: ―NoTajtzin onechmactilij nochi tlajtlamach. Xacaj quimati aquinon nejhua yejhuan niteConeu, yej sa no noTajtzin. Niman xacaj quimati aquinon noTajtzin, yej san nejhua niteConeu, niman yejhuamej on yejhuan nicnequi niquimimpanextilia. ");
INSERT INTO nguNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Quemaj oquimixtlaloj inomachtijcahuan niman oquimijlij yejhuamej inseltimej: ―Melahuac tlatiochiutin on yejhuan quitaj on tlen nemejhuamej nenquitaj. ");
INSERT INTO nguNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nemechijlia ica miyequej tiotlajtojquej niman reyes oquinequej quitasquej niman caquisquej on tlen nemejhuamej nenquitaj niman nencaquij, pero xohuelquej. ");
INSERT INTO nguNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Quemaj se temachtijquetl ican on itlanahuatil Dios, onotelquetz niman oquinotzato Jesús para quitlatlatas. Oquitlajtoltij: ―Temachtijquetl, ¿tlinon cuajli nicchihuas para nicpias nemilistli yejhuan para nochipa? ");
INSERT INTO nguNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús oquijlij: ―¿Tlinon tlajcuilolnesticaj ipan on tlanahuatijli? ¿Quen ijqui ticajsicamati? ");
INSERT INTO nguNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","On temachtijquetl ican on tlanahuatijli oquinanquilij: ―Xtlajsojtla moTeco Dios ican nochi moyojlo, ican nochi moalma, ican nochi mochicahualis niman ican nochi motlamachilis, niman xtlajsojtla motlalticpacicniu no ijqui quen tejhua timotlajsojtla. ");
INSERT INTO nguNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Quemaj Jesús oquijlij: ―Cuajli otitlananquilij. Ijcon xchihua, niman ticpias nemilistli para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero on temachtijquetl ican on tlanahuatijli quinequiya quimanahuis itlajtol. Yejhua ica, tej, ocsejpa oquitlajtoltij Jesús: ―¿Aquinonon notlalticpacicniu yejhuan nonequi nictlajsojtlas? ");
INSERT INTO nguNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ijcuacon Jesús oquitlalij se ejemplo, oquijlij: ―Sen tlacatl oquis Jerusalén niman temohuaya ipan on ojtli yejhuan yau ipan on hueyican itoca Jericó. Niman ipan on ojtli oquitzacuilijquej sequimej tlachtequej yejhuan nochi oquicuilijquej, hasta itlaquen. Oquimajmailijquej niman oquitlajcaltejquej sotlajtoc. ");
INSERT INTO nguNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Niman onochiu ica se tiopixqui ompaca panotiaya ipan on ojtli, pero ijcuac oquitac ica ompa tlajcaltoc on tlacatl, yej san oquipanahuij ocse lado ocomelau. ");
INSERT INTO nguNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","No ijqui se levita opanoc ompaca, niman ijcuac oquitac on tlacatl, san oquipanahuij niman no ocse lado ocomelau. ");
INSERT INTO nguNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Quemaj se tlacatl chanej ne ipan on iregión Samaria yejhuan panotiaya ipan on ojtli. Ijcuac yejhua oquitac on tlacatl tlacocojli, oquicnelij. ");
INSERT INTO nguNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yejhua oquinisihuij, niman oquipajtilij ican aceite niman vino ne campa tlacocojli, niman oquitejcuilij ican pitzahuac tlaquentli. On samaritano cuajhuicaya iyolcau niman oquitlejcoltij ipan. Quemaj ocuicac ipan se chanyotl campa nosehuiaj on nejnenquej niman ompa oquipalehuij. ");
INSERT INTO nguNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Huajmostla, ijcuac on samaritano ye yas, oquixtij tomin ipan ibolsa niman ome denarios oquimacac on iteco on chanyotl, niman oquijlij: “Xpalehui yejhua in tlacatl, niman tla itlaj más quipolos, nejhua nimitztlaxtlahuilis ijcuac nihuajlas ocsejpa.” ");
INSERT INTO nguNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Quemaj Jesús oquitlajtoltij on temachtijquetl ican on tlanahuatijli: ―¿Catlejhua de on yeyimej tlacamej ticnemilia ica yejhua nohuica quen itlalticpacicniu itech on tlacatl yejhuan oquitlachtequilijquej? ");
INSERT INTO nguNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","On temachtijquetl ican on tlanahuatijli oquijtoj: ―On yejhuan oquicnelij. Ijcuacon Jesús oquijlij: ―Tla ijcon, xhuiya niman no ijqui xteicneli. ");
INSERT INTO nguNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ihuan inomachtijcahuan más onejnen niman oajsic ipan se pueblito, niman ompa se sihuatl itoca Marta oquiselij ichan. ");
INSERT INTO nguNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta quipiaya se icniu sihuatl itoca catca María. Niman María onotlalij icxitlan Jesús para ocac on tlinon yejhua quijtohuaya. ");
INSERT INTO nguNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta sanoyej tequimiquiya, niman yejhua oyaj itech Jesús niman oquijlij: ―NoTeco, ¿tlen xticmomaca cuenta ica nocniu nopan cahua in tequitl? Tej, xquijli ma nechpalehui. ");
INSERT INTO nguNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Jesús oquijlij: ―Marta, Marta, sa tlamach ticomatzticaj niman timopajsolohua ican miyec tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero san se tlamantli oncaj yejhuan más hueyi quijtosnequi. Niman María oquitlapejpenij on tlen más cuajli, niman xacaj quicuilis. ");
INSERT INTO nguNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Se tonajli Jesús quichijticatca oración. Niman ijcuac otlan, semej inomachtijcahuan oquijlij: ―ToTeco, xtechmachti quen ijqui ticchihuasquej oración ijcon quen Juan oquinmachtij on inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús oquimijlij: ―Ijcuac nenquichihuasquej oración xquijtocan ijquin: ToTajtzin aquin tinemi ne ilhuicac, ma mitzyectenehua nochi tlacatl. Ma huajla on tonaltin ijcuac ticmandaros nochi tlacatl. Ipan in tlalticpactli on tlacamej ma quichihuacan on tlen ticnequis ijcon quen nochihua ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aman xtechmaca tlen ticuasquej on yejhuan mojmostla ica tipanotoquej. ");
INSERT INTO nguNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Niman xtechtlapojpolhuili totlajtlacolhuan ijcon quen tejhuamej tiquintlapojpolhuiyaj on yejhuan tlajtlamach xcuajli techchihuiliaj. Niman xtechpalehui para ma ca titlajtlacosquej, yej xtechejcuanili nochi tlin xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","No ijqui oquimijlij Jesús: ―Ma ticontlalican ica semej nemejhuamej quipia se itetlajsojcau niman canaj ipan tlajcoyehuajli yau ichan on itetlajsojcau niman quijlia: “Notetlajsojcau, xnechtlanejti yeyi pan, ");
INSERT INTO nguNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","pampa se notetlajsojcau huejca ohualeu niman san quemach oyejcoc nochan, niman xnicpia tlinon nicualtis.” ");
INSERT INTO nguNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Niman ma ticontlalican ica on ocse cuajnanquilis nepa icalijtic, niman quijlis: “Ma ca xnechpajsolo. Notlatzacuilyou cuajli tzacuticaj, niman noconehuan nohuan nemij ipan tlapechtli. Xnihuelis ninoquetztehuas para nimitzonmacas.” ");
INSERT INTO nguNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nemechijlia ica masqui xnoquetztehuasnequisquia para conmacas, pero san pampa itetlajsojcau quitlajtlanilia, yejhua noquetztehuas niman quimacas nochi tlen quipolojticaj. ");
INSERT INTO nguNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yejhua ica nemechijlia: xtlajtlanilican Dios on tlen mechpolohua, niman yejhua mechmacas. Xtejtemocan on tlen mechpolohua, niman nenquinextisquej. Xtetepinican on tlatzacuilyotl, niman Dios mechtlapohuilis. ");
INSERT INTO nguNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ijcon xchihuacan, pampa yejhuan quitlajtlani, quiselia, niman yejhuan quitejtemohua, quinextia, niman yejhuan quitetepinia on tlatzacuilyotl, quitlapohuiliaj. ");
INSERT INTO nguNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Tlen nemotzajlan yacaj tajtli nemi yejhuan noyolchicahuas para quimacas iconeu se tetl ijcuac quitlajtlanilis se tlaxcajli? ¿Noso quimacas se cohuatl ijcuac quitlajtlanis se michin? ");
INSERT INTO nguNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Noso quimacas se colotl ijcuac quitlajtlanis se totoltetl? ");
INSERT INTO nguNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aman, tej, tla nemejhuamej yejhuan xnencuajcualtin tlacamej nenquimatij quen nenquinmacasquej nemoconehuan on tlajtlamach tlen cuajli, sanoyej pantlannesticaj ica nemoTajtzin ilhuicac chanej quinmacas Espíritu Santo on yejhuan quitlajtlanilisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús quixtilijticatca se tlacatl on xcuajli espíritu yejhuan oquinontilijca, niman ijcuac on xcuajli espíritu oquis, on nontzin otlajtoj. Niman yejhua ica on tlacamej otlamojcaitaquej. ");
INSERT INTO nguNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero sequimej oquijtojquej: ―Yejhua in tlacatl quintequixtilia on xcuajcualtin espíritus ica ipoder on Beelzebú yejhuan intlayecancau. ");
INSERT INTO nguNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Niman ocsequimej, san para quitlatlatasquej, quitlajtlaniliayaj ma quichihua se tlamajhuisojli milagrosa yejhuan ne ilhuicac quisticaj. ");
INSERT INTO nguNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesús quimatzticatca tlinon quinemilijticatcaj, niman oquimijlij: ―San catlejhua gobierno yejhuan notlajcoxelohua, xoxotoni. Niman tla ipan se chanyotl on chanejquej noxelohuaj ican tlahuejli, no ijqui xoxotonij. ");
INSERT INTO nguNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","No ijqui, tej, tla on Satanás noxelos inhuan on xcuajcualtin espíritus, ¿quen ijqui huelis onyas nochipa ipoder? Yejhua in niquijtohua pampa nemejhuamej nenquijtohuaj ica nictequixtilia on xcuajcualtin espíritus ican ipoder on Beelzebú. ");
INSERT INTO nguNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero tla ijqui yesquia quen nenquinemiliaj, ¿aquinon quinmaca poder on yejhuan nemochantlacaj para no quitequixtiliaj on xcuajcualtin espíritus? Sa no yejhuamej quiteititiaj ica xcuajli nentlanemiliaj. ");
INSERT INTO nguNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero tla Dios nechmaca poder para nictequixtilia on xcuajcualtin espíritus, yejhua in quijtosnequi ica Dios yohuajlaj para nemoca tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ijcuac se cojtiticaj tlacatl cuajli nemi armado niman quitlapia ichan, on tlen ompa quipia xacaj hueli quicuilia. ");
INSERT INTO nguNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero tla huajlau ocse tlacatl yejhuan más cojtic xquen yejhua niman quitlani, tla ijcon, on tlacatl yejhuan más cojtic cuilia nochi iarmas yejhuan ica noyolchicahuaya iteco on cajli, niman yejhua quixexelohua para ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’On yejhuan xitlaj ica nechixnamiqui nohuan nopohua, niman on yejhuan xnohuan tlasentlalia tepopolohua. ");
INSERT INTO nguNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ijcuac se xcuajli espíritu quisa ipan se tlacatl, pajpanotinemi nochihuiyan campa tlahuactoc. Quitejtemojtinemi campa nosehuis, niman ijcuac xquinextia, quinemilia: “Ocsejpa nias ne ipan on tlacatl campa oniquis.” ");
INSERT INTO nguNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ijcuac ocsejpa nocuepa, conextia on tlacatl quen itlaj cajli yejhuan ijtic cualtzin tlachpancan niman cuajli tlaojoncaj. ");
INSERT INTO nguNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Quemaj yejhua yau niman cominana ocsequi chicome yejhuan más xcuajcualtin espíritus xquen yejhua, niman nochimej nochantiaj ijtic on tlacatl. Yejhua ica on tlacatl más xoc cuajli nemi xquen achtopa nemiya. ");
INSERT INTO nguNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ijcuac Jesús otlan quijtohua yejhua in tlajtlamach, se sihuatl yejhuan nemiya intzajlan on tojlamej, ican chicahuac tlajtojli oquijlij: ―Tlatiochiutli sanoyej on sihuatl yejhuan omitztlacatilij niman omitzchichitij. ");
INSERT INTO nguNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero yejhua oquijtoj: ―¡Dios más quintiochihua on yejhuan caquij itlajtol niman quitlacamatij! ");
INSERT INTO nguNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","On tlacamej más nosentlalijticatcaj iyehualican Jesús, niman yejhua opeu tlajtlajtohua, quijtohuaya: ―On tlacamej yejhuan nemij ipan in tonaltin yejhuamej xcuajcualtin. Nechtlajtlaniliaj ma nicchihua se tlamajhuisojli milagrosa, pero xnicchihuas, yej san on itlamajhuisol on tiotlajtojquetl Jonás. ");
INSERT INTO nguNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ijcon quen Jonás onochiu tlamajhuisojli para on tlacamej yejhuan chantiyaj ne Nínive, no ijqui nejhua yejhuan oninochiu Tlacatl ninochihuas tlamajhuisojli para on tlacamej yejhuan nemij ipan in tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ipan on tonajli ijcuac Dios teyolcuitis niman tetlajtlacolmacas, on sihuatequihua tlayecanquetl ne Sur noquetztehuas niman quintlajtlacolmacas on tlacamej yejhuan aman nemij. Ijcon huelis quichihuas pampa yejhua ohualeu ne campa más huejca oncaj on pueblo ipan in tlalticpactli para ocaquico itlamatquilis Salomón, niman nejhua nican ninemi yejhuan más nihueyixticaj xquen Salomón niman on yejhuan aman nemij xnechchihuiliaj cuenta. ");
INSERT INTO nguNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ipan on tonajli, ijcuac Dios teyolcuitis niman tetlajtlacolmacas, on yejhuan chantiyaj ne ipan on hueyican itoca Nínive noquetztehuasquej niman quintlajtlacolmacasquej on tlacamej yejhuan aman nemij. Ijcon quichihuasquej pampa on yejhuan ochantijquej Nínive onoyolpatlaquej ijcuac Jonás oquintlajtlajtohuilij itemachtil Dios. Niman nejhua nican ninemi yejhuan más nihueyixticaj xquen Jonás niman on yejhuan aman nemij xonoyolpatlaquej ijcuac oniquintlajtlajtohuilij itemachtil Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Xacaj quitlicuiltia itlahuil niman quitlalia campa iyantias, nion itzintlan itlaj chiquiutli. Yej quitlalia campa tlacpac para quintlahuilhuiya on yejhuan calaquisquej ijtic on cajli. No ijqui, tej, ijcuac se quimati itech ica Dios xquitocarohua quiyanas. ");
INSERT INTO nguNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ipan motlalnacayo ticpia mixtololojhuan para titlacha. Tla mixtololojhuan cuajli tlacha, hueli tiquita on tlen ticchihua. Pero tla xtitlacha, xhueli tiquita on tlen ticchihua. No ijqui tla motlamachilis cuajli, hueli ica ticajsicamati on tlen Dios quinequi para ticchihua. Pero tla motlamachilis xcuajli, tla ijcon xticajsicamati on tlen Dios quinequi para ticchihuas. ");
INSERT INTO nguNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yejhua ica nonequi para tiquejehuas motlamachilis para ticajsicamatis on tlen Dios quinequi para ticchihuas, niman para ma ca ticpolos itlaj mocajsicamatilis. ");
INSERT INTO nguNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ijcon, tej, tla motlamachilis cajsicamati nochi tlen Dios quinequi para ticchihuas, tla ijcon, xmitzpolos nion achijtzin cajsicamatilistli, yej motlamachilis quen se lámpara yes yejhuan mitzititis nochi tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ijcuac Jesús otlan tlajtlajtohua, se fariseo oquinotz para ihuan ontlacuas ichan. Yejhua ica Jesús ocalac ichan on fariseo niman onotlalij itech mesa. ");
INSERT INTO nguNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","On fariseo hasta omojcatlachix ijcuac oquitac ica Jesús xonomajtequij para tlacuas. ");
INSERT INTO nguNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero on toTeco oquijlij: ―Nemejhuamej fariseos san tlapani nemochipahuaj quen se quichipahua san icuitlapan on taza noso icuitlapan on plato, pero ipan nemoyojlo nententoquej ica on tlen nenquiteixpachohuiliaj niman ica on tlen xcuajli nenquichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ah tzonteconchicajquej! ¿Tlen xnenquimatij ica on yejhuan omechchijchiu pani ipan nemotlalnacayo no oquichijchiu tlaijtic ipan nemoyojlo? ");
INSERT INTO nguNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pero xquinmacacan tetlayocolili on mayanquej niman nemocahuasquej nochi chipahuac hasta nemoyojlo. ");
INSERT INTO nguNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Melahuac nemejhuamej fariseos nenquimacaj Dios nemodiezmo ican on menta, niman ruda niman nochi tlajtlamach quijli. Pero masqui ijcon nenquichihuaj, ¡lástima para nemejhuamej! pampa xnemohuicaj ihuan ocsequimej ican yolchipahualistli quen nonequi, nion xnenquitlajsojtlaj Dios quen nonequi. Ijcuac nenquimacaj Dios nemodiezmo, no nonequi nenquichihuasquiaj yejhua in ocsequij tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Lástima para nemejhuamej fariseos!, pampa ne ipan tiopantin nenquinequij nemotlalisquej ipan on sietas campa notlaliaj on huejhueyixtoquej, niman nenquinequij para ne ipan on plazas ma mechtlajpalocan ican miyec tetlacaitalistli. ");
INSERT INTO nguNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Lástima para nemejhuamej temachtijquej ican itlanahuatil Dios niman nemejhuamej fariseos! ¡Nemejhuamej nenomexayacyejquej! Nemejhuamej quen nentlalcontin yejhuan xnestoquej, niman on tlacamej impan panohuaj. Ijcon tej, on tlacamej panohuaj nemotech niman xquimatij ica nenquincajcayahuaj ican nemotlamachtil. ");
INSERT INTO nguNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Quemaj se temachtijquetl ican itlanahuatil Dios oquinanquilij niman oquijlij: ―Temachtijquetl, ica on tlen tiquijtohua, tejhuamej no tehuan titechcaquistilia. ");
INSERT INTO nguNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero Jesús oquijtoj: ―¡Lástima para nemejhuamej no!, temachtijquej ican itlanahuatil Dios, pampa ocsequimej nenquintlamamaltiaj ica on tlamamajli yejhuan sanoyej yetic para quitquisquej. Pero nemejhuamej nion siquiera ican se nemomajpil nenquinequij nenconquictzisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Lástima para nemejhuamej!, pampa nenquinchijchihuaj inmicacal on tiotlajtojquej yejhuan sa no on nemoachtojtajhuan oquinmictijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ica on nenquiteititiaj ica nenquitlaliaj nemoyojlo ipan on tlen oquichijquej on nemoachtojtajhuan. Yejhuamej, tej, oquinmictijquej on tiotlajtojquej, niman nemejhuamej nenquinchijchihuiliaj on inmicacal. ");
INSERT INTO nguNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yejhua ica, tej, Dios ican itlamatquilis oquijtoj: “Niquintitlanilis tiotlajtojquej niman apóstoles, niman sequimej yejhuamej quinmictisquej niman ocsequimej quintlahuelitasquej niman tlamach ica quintlajyohuiltisquej.” ");
INSERT INTO nguNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yejhua ica on tlacamej yejhuan aman nemij quinyolcuitisquej ipampa inmiquilis nochimej on tiotlajtojquej desde ijcuac otzimpeu in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Huajpehua ica iyesyo Abel niman ontlami hasta ica iyesyo Zacarías, yejhuan oquimictijquej itzajlan on tiopan niman on tlaixpan ne quiahuac. Yejhua ica ocsejpa nemechijlia ica on tlacamej yejhuan aman nemij quinyolcuitisquej ipampa on inyesyo on tiotlajtojquej. ");
INSERT INTO nguNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Lástima para nemejhuamej temachtijquej ican itlanahuatil Dios!, pampa xnenquincahuiliaj on tlacamej ma cajsicamatican on tlajtlamach ica Dios. Nemejhuamej xnenquiseliaj on tlajtlamach niman xnenquincahuiliaj ocsequimej quiselisquej yejhuan quinequij. ");
INSERT INTO nguNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ijcuac Jesús otlan quimijlia in tlajtlamach, on temachtijquej ican itlanahuatil Dios niman on fariseos opejquej quixnamiquij niman sa tlajtlamach quitlajtoltiayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Niman yejhuamej quipiayaj cuidado tlinon ica quitlajcalisquej para huelis itlaj ica quiteixpanhuisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Quemaj sanoyej miyequej miles tlacamej onosentlalijquej hasta sa notlajtlajcaliyaj. Pero Jesús achtoj opeu quimijlia on inomachtijcahuan: ―Xmotacan sa no nemejhuamej ican intlaxocolilis on fariseos. In quijtosnequi on inomexayacalis. ");
INSERT INTO nguNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Xmotacan sa no nemejhuamej, pampa nochi tlen nenquichtacachihuasquej nopanextis, niman nochi tlen nenquinemilisquej ica xacaj quimatis machiyas. ");
INSERT INTO nguNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yejhua ica, on tlen onenquijtoquej ipan tlayohuajlotl, caquistis ipan tonajli ijcuac tlastastoc. Niman on tlen onoichtacaijtoj calijtic, quijtosquej chicahuac ne icuapan on caltin. ");
INSERT INTO nguNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Nemejhuamej notetlajsojcahuan, nemechijlia ma ca xmacajsican on yejhuan huelij quimictiaj on tlalnacayotl niman quemaj xoc huelij itlaj más quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yej quemaj nemechijlia aquinon quitocarohua nenquimacajsisquej. Xmacajsican Dios yejhuan ijcuac se yoquimictij, quemaj ican ipoder hueli contlajcali ne campa temojtij tetlajyohuiltiloyan. Melahuac, tej, nemechijlia yejhua xmacajsican. ");
INSERT INTO nguNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Tlica xnonamacaj macuijli tototzitzintin ican san ica macuijli centavos? Pero nion semej yejhuamej xquimelcahua Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yejhua ica ma ca xmomojtican pampa nemejhuamej más nenhueyi quijtosnequi xquen miyequej tototzitzintin. Tej, hasta nemotzon cada sesentetl oncaj tlapohuajli ixpan Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Aman, tej, nemechijlia ica nochimej yejhuan quipantlantisquej imixpan on tlacamej ica nohuan nopohuaj, nejhua yejhuan niteConeu itech Dios no ijqui niquimpantlantis imixpan iilhuicactequitcahuan Dios ica nohuan nopohuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero on yejhuan nonenequisquej nopampa imixpan on tlacamej, nejhua no ijqui ninonenequis impampa ne imixpan iilhuicactequitcahuan Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Niman san aquinon yejhuan itlaj xcuajli nechtenehuilis, nejhua yejhuan oninochiu Tlacatl huelis quitlapojpolhuilisquej on tlen quijtos. Pero on yejhuan cuijhuicaltis on Espíritu Santo, xhuelis quitlapojpolhuilisquej on tlen quijtos. ");
INSERT INTO nguNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ijcuac mechhuicasquej para mechteixpanhuisquej ne ipan on tiopantin, noso imixpan on yejhuan tlanahuatia noso on tequihuajquej, ma ca xcomatztiacan quen ijqui nentlananquilisquej noso tlinon nenquijtosquej, ");
INSERT INTO nguNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","pampa ijcuac ajsis on hora ica nentlajtosquej, on Espíritu Santo yejhua mechijlis tlinon nenquijtosquej. ");
INSERT INTO nguNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ne intzajlan on tlacamej ohuajtlajtoj se tlacatl yejhuan oquijlij Jesús: ―Temachtijquetl, xquijli nocniu ma nechxelohuili on herencia yejhuan nechtocarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero Jesús oquijlij: ―Tlacatl, ¿aquinon onechtlalij nemotzajlan quen se tequihuaj noso tlaxelojquetl? ");
INSERT INTO nguNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Quemaj oquimijlij nochimej: ―Xmotacan sa no nemejhuamej niman xmotlapiacan para ma ca sanoyej xnequican nenmoyaxcatisquej tlajtlamach pampa inemilis se tlacatl xne hualejticaj itech on tlen miyec quipia. ");
INSERT INTO nguNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Quemaj oquintlalilij yejhua in ejemplo: ―Nemiya se tlacatl yejhuan quinopiyaliaya miyec, niman ipan itlalhuan sanoyej otlatlac. ");
INSERT INTO nguNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Niman quemaj on tlacatl yejhuan quinopiyaliaya miyec opeu ijquin quinemilia: “¿Tlinon nicchihuas? Xnicpia canon niquejehuas on tlen otlac.” ");
INSERT INTO nguNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Niman oquinemilij: “Aman ye nicmati tlinon nicchihuas. Niquinxoxotonis nocuesconhuan, para ocsequimej niquinchijchihuas yejhuan más huejhueyimej, niman ompa niquejehuas nochi on tlen otlac niman nochi tlen ye nicpia.” ");
INSERT INTO nguNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Niman quemaj ijquin oquinojlij: “Miyec tlajtlamach yejyejticaj niman ye ticpia para mitzajxilis miyec xipan. Xmosehui, xtlacua, xatli, niman xmopacti.” ");
INSERT INTO nguNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios oquijlij: “¡Ah tlacatl tzonteconchicahuac! Yejhua in mismo tlayohua timiquis, niman on tlen yotiquejeu, ¿aquinon itech nocahuas?” ");
INSERT INTO nguNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ijcon impan nochihuas on tlacamej yejhuan quimiyequiliaj riquezas para san yejhuamej, niman ixpan Dios onesij xitlaj quipia. ");
INSERT INTO nguNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Quemaj Jesús oquimijlij on inomachtijcahuan: ―Aman, tej, nemechijlia: Ma ca xcomatztiacan on tlen nencuasquej para nenquipiasquej nemilistli, nion on tlen ica nenquitlaquentisquej nemotlalnacayo. ");
INSERT INTO nguNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nemonemilis más hueyi quijtosnequi xquen on tlacuajli, niman nemotlalnacayo más hueyi quijtosnequi xquen on tlaquentli. ");
INSERT INTO nguNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xquimixtlalocan on cacalomej ica xtocaj nion pixcaj, nion quipiaj incuescon noso cajli para tlayejyehua. Pero Dios quintlacualtia. ¡Nemejhuamej, tej, más sanoyej nenhueyiquijtosnequij xquen on totomej! ");
INSERT INTO nguNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nion semej nemejhuamej ijcuac ye miquis huelis sa comatztias para quitlaquechilis ocse hora inemilis. ");
INSERT INTO nguNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tej, tla xhueli nenquimochihuiliaj itlaj yejhuan xhueyi quijtosnequi quen nenquitlaquechilisquej nemonemilis se hora, “¿tlica, tej, nencomatztoquej on ocsequi tlajtlamach yejhuan mechpolohua?” ");
INSERT INTO nguNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Xquimixtlalocan on xochimej quen ijqui noscaltiaj. Yejhuamej xtequitij nion tlajtzomaj. Pero nejhua nemechijlia masqui on rey Salomón notlaquentiaya ican itlaquen sanoyej pepetlaca, xqueman ijqui onotlaquentij cualtzin quen se xochitl. ");
INSERT INTO nguNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aman, tej, tla Dios ijcon quitlaquentia on xojtli, yejhuan aman oncaj ipan tepetl niman quemaj huajmostla quitlatiaj ipan horno, tla ijcon, tej, ¿yej xmás mechtlaquentis nemejhuamej tlacamej? ¡Oh tlacamej semi xnentlaneltocaj! ");
INSERT INTO nguNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yejhua ica ma ca xcomatztiacan on tlen nencuasquej nion on tlen nenconisquej, nion ma ca xometlamatican ");
INSERT INTO nguNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","pampa on tlacamej yejhuan xquineltocaj Dios san yejhua on tlajtlamach quitejtemohuaj. Pero nemoTajtzin ye quimatzticaj ica mechpolohua on tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yej xchihuacan canica para Dios ma mechmandaro niman ma quinmandaro ocsequimej. Tla ijcon nenquichihuasquej nenquiselisquej in tlajtlamach yejhuan mechpolohua. ");
INSERT INTO nguNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ma ca xmomojtican masqui xnenmiyequej, pampa nemoTajtzin quipia pactli para mechcahuilis nencalaquisquej ne campa yejhua tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","On tlen nenquipiaj xnamacacan, niman on tomin xquinmacacan on yejhuan mayanquej. Ijcon, tej, xpiacan riquezas yejhuan xqueman ijsolihuij, niman xsentlalican riquezas ne ilhuicac campa xqueman tlamis, niman campa on tlachtequetl xhuelis calaquis nion itlacuanyo conixpolos. ");
INSERT INTO nguNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tla ijcon, tej, campa nenquipiasquej nemoriquezas, no ompa nenquipiasquej nemoyojlo. ");
INSERT INTO nguNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Xcololocan nemotlaquen niman xpiacan listo nemotlahuil yejhuan cuajli tlahuilohua ");
INSERT INTO nguNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","quen tequitquej yejhuan quichixtoquej inteco ma huajnocuepati ne campa nonamictihua, para nimantzin quitlatlapohuilisquej oc yejcotetzis niman quitetepinis on tlatzacuilyotl. ");
INSERT INTO nguNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tlatiochiutin yesquej para on tequitquej yejhuan ijcuac huajlas inteco quinhuajnextis tlajtlachixtoquej. Ica tlen melahuac nemechijlia ica sa no inteco nochihuas intequichihuilijcau. Quemaj quinnotzas ma huajlacan ipan mesa niman quemaj quintlamacas. ");
INSERT INTO nguNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Masqui yejhua yejcos canaj tlajcoihuan noso cualcan, tlatiochiutli yesquej on tequitquej tla inteco quinnextijtejco tlajtlachixtoquej. ");
INSERT INTO nguNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Niman xmatican yejhua in, ica tla iteco se cajli quimatisquia tlen hora yejcos on tlachtequetl ne ipan ical, yejhua tlachixtiasquia niman xcahuilisquia ma quitlapohuili ical para quitlachtequilis. ");
INSERT INTO nguNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nemejhuamej no ijqui xtlamachixtiacan, pampa ijcuac xnenquinemilijtiasquej, nihuajlas nejhua yejhuan oninochiu Tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Quemaj Pedro oquitlajtoltij: ―ToTeco, ¿otictlalij in ejemplo san para tejhuamej, noso para nochimej? ");
INSERT INTO nguNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","On toTeco oquijtoj: ―¿Aquinon on tequitquetl yejhuan nochipa quitlacamati iteco, niman cuajli tlanemilia, niman yejhuan iteco quimactilia ichanchanecahuan, niman on ocsequimej itequitcahuan para quinmaca tlen quimpolohua ijcuac nonequis quiselisquej? ");
INSERT INTO nguNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tlatiochiutli yes on tequitquetl yejhuan ijcuac huajlas iteco cuajnextis quichijticaj on tlen oquinahuatij. ");
INSERT INTO nguNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ica tlen melahuac nemechijlia ica iteco quimactilis on tequitquetl nochi tlen yejhua quipia para quejehuas. ");
INSERT INTO nguNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero tla yejhua on tequitquetl quinemilis ica on iteco oc polihui para huajlas, niman pehuas quinhuisoquis on tlacamej tequitquej niman on sihuamej tequitquej, niman san tlacuas, niman atlis niman tlahuantinemis, ");
INSERT INTO nguNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tla ijcon, iteco huajlas ipan on tonajli ijcuac yejhua xquichixticaj, niman ipan on hora ijcuac xquimati. Niman quemaj iteco temojtij quicastigaros, niman cahuas inhuan on yejhuan xquitlacamatij. ");
INSERT INTO nguNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’On tequitquetl yejhuan quimati tlinon quinequi on iteco, pero xnolistojtlalia para quichihuas nion quitlacamati, sanoyej quitlajyohuiltisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero on tequitquetl yejhuan xquimati tlinon quinequi iteco, niman quichihuas on tlajtlamach yejhuan nonequi quiselis san achijtzin castigo. On yejhuan miyec quinahuatiaj ica oncaj miyec quichihuas. Niman on yejhuan más miyec quinahuatiaj no ijqui ica oncaj más miyec quichihuas. ");
INSERT INTO nguNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Nejhua onihuajlaj ipan in tlalticpactli para niquinmacas on tlacamej yencuic tlaneltoctli yejhuan tlicuis quen tlitl ipan inyojlo. Niman sanoyej nicnequisquia ica ye quipiasquiaj. ");
INSERT INTO nguNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero antes yejhuamej quipiasquej in, ica oncaj sanoyej nitlajyohuis. Niman sanoyej ninajmana hasta caman in nopan nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Nenquinemiliaj ica nejhua onihuajlaj para oniquinsentlalico on tlalticpactlacamej ican yolsehuilistli? Nemechijlia ica ca, yej nopampa noxexelosquej. ");
INSERT INTO nguNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Desde aman ye pehua macuiltimej chanchanejquej ipan se chanyotl xexelijtiasquej. Yeyimej tlahuelnemisquej inhuan on ocse omemej niman on omemej inhuan on yeyimej. ");
INSERT INTO nguNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","On tajtli tlahuelnemis ihuan on itelpoch niman on telpochtli ihuan itaj. Niman on nantli tlahuelnemis ihuan ichpoch, niman on ichpoch ihuan inan. On monantli tlahuelnemis ihuan on isihuamon, niman on sihuamontli ihuan on imonan. ");
INSERT INTO nguNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús no oquimijlij on tlacamej: ―Ijcuac nemejhuamej nenquitaj ica on moxtli noquetztehua ne ica icalaquiyan tonaltzintli, nimantzin nenquijtohuaj ica quiahuis, niman melahuac ijqui nochihua. ");
INSERT INTO nguNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Niman ijcuac on ajacatl hualehua ne ica sur, nenquijtohuaj ica tona yes, niman ijqui nochihua. ");
INSERT INTO nguNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Omexayacyejquej! Nemejhuamej hueli nencajsicamatij tlinon nochihuas ne ipan cielo niman nican tlalticpac. ¿Tlica, tej, xhueli nencajsicamatij tlinon quijtosnequi on tlen nicchihua ipan in tonaltin? ");
INSERT INTO nguNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Tlica xsan no nemejhuamej nenquitaj quen nemoyoltlaliaj ica cuajli? ");
INSERT INTO nguNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ijcuac yacaj mitzhuica para mitzteixpanhuiya ne imixpan on tequihuajquej, xchihua canica para ihuan xmoyolsehui ipan ojtli, para ma ca mitzhuicas ixpan on tequihuaj, niman on tequihuaj mitztemacas intech on policías, niman on policías mitzajsisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ompa xtiquisas hasta tictlaxtlahuas on sa ica nochi motomin yejhuan mitzquixtilisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sa no ipan on tonajli ompa nemiyaj sequimej tlacamej yejhuan oquitlajtlajtohuilijquej Jesús quen ijqui Pilato otlanahuatijca para oquinmictijquej sequimej tlacamej yejhuan chanejquej ne Galilea niman ica on inyesyo oquinelojquej ihuan inyesyo on yolquej yejhuan on galileos oquinmictijquej para se huentli. ");
INSERT INTO nguNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Niman Jesús oquimijlij: ―¿Nemejhuamej nenquinemiliaj ica on tlacamej galileos ijcon impan onochiu pampa más tlajtlacolejquej catcaj xquen on inchantlacaj? ");
INSERT INTO nguNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nemechijlia ica ca. Yej, tla nemejhuamej xnencajcahuasquej ica nenquichihuaj on tlen xcuajli, nochimej nemejhuamej no ijqui nenmiquisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Tlen nemejhuamej nenquinemiliaj ica on majtlactli huan chichuasen tlacamej yejhuan omiquej ijcuac impan oxoton on torre ne Siloé, yejhuamej más quipiayaj tlajtlacojli xquen on yejhuan chantiyaj ne Jerusalén? ");
INSERT INTO nguNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nemechijlia ica ca, yej tla nemejhuamej xnencajcahuasquej ica nenquichihuaj on tlen xcuajli, nochimej nemejhuamej no ijqui nenmiquisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Quemaj Jesús oquintlalilij yejhua in ejemplo: ―Sen tlacatl quipiaya se higuera cojtli ne ipan itlal, niman se tonajli yejhua oquitato tla yotlac, pero xitlaj oquinextilij itlaquilyo. ");
INSERT INTO nguNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Quemaj yejhua oquijlij on tlacatl yejhuan quinotequiyotiaya on tlajli: “Xquita, ye quipia yeyi xipan ica nicualitztinemi higos nican ipan in cojtli, niman xqueman niquita tla tlaqui. Más cuajli xtzontequi. ¿Tlinon para ne san tlalcuiticaj niman xtlaqui?” ");
INSERT INTO nguNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero on yejhuan quinotequiyotiaya on tlajli oquijlij: “Señor, sa yejhua in xipan xcahua. Nejhua nictlalquexanilis niman nictemilis tlapalanajli. ");
INSERT INTO nguNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tla tlaquis cuajli yes, pero tla xotlac, ijcuacon quemaj titlanahuatis para ma quitzontequican.” ");
INSERT INTO nguNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ipan se tonajli de nesehuijli, Jesús temachtijticatca ipan se tiopan. ");
INSERT INTO nguNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Niman ompa nemiya se sihuatl yejhuan ye quipiaya majtlactli huan chicueyi xipan ica cualohuaya, pampa on xcuajli espíritu yejhuan ijqui oquichihuilij. Yejhua on sihuatl sa nopachojtinemiya, niman nion achijtzin xhueliya nomelajcatelquetzaya. ");
INSERT INTO nguNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ijcuac Jesús ijcon oquitac on sihuatl, oquinotz niman oquijlij: ―Sihuatl, ye cuajli yotipajtic de yejhua on cualolistli. ");
INSERT INTO nguNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Quemaj oquintlalij imahuan ipan niman nimantzin on sihuatl onomelajcatelquetz, niman opeu quihueyilia Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero on yejhuan tlayecanquetl catca ipan on tiopan ocualan pampa Jesús otepajtij ipan on tonajli de nesehuijli, niman yejhua oquimijlij on tlacamej: ―Chicuasen tonajli oncaj para tequitihuas. Ipan on tonaltin xhuajlacan para nemopajtisquej, niman ma ca ipan on tonajli de nesehuijli. ");
INSERT INTO nguNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ijcuacon on toTeco oquijlij: ―Omexayacyejquej, cada se nemejhuamej quitojtoma ihuacax noso ipoloco ipan on tonajli de nesehuijli niman cuica conatlitia. ");
INSERT INTO nguNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Niman nican nemi yejhua in sihuatl yejhuan huejca teixhuiu itech Abraham niman ye quipia majtlactli huan chicueyi xipan ica Satanás ijcon oquichihualtij. ¿Xquitocarohuaya nomanahuis de on cualolistli ipan on tonajli de nesehuijli? ");
INSERT INTO nguNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ijcuac Jesús ijcon oquijtoj, nochimej on itlajhuelicnihuan opinajquej. Pero nochi tlacatl paquia ipampa on huejhueyi tlajtlamach tlen Jesús quichihuaya. ");
INSERT INTO nguNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Quemaj oquijtoj: ―¿Quen ijqui noscaltia itequihuayo Dios? ¿Tlinon ica huelis niquixnescayotis on itequihuayo Dios? ");
INSERT INTO nguNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yejhua quen itlaj on xinachtli itoca mostaza yejhuan se tlacatl quitoca ipan itlal. On xinachtli noscaltia hasta ajsi quen itlaj hueyi cojtli. Sanoyej hueyiya hasta on totomej yejhuan pajpatlantinemij quichijchihuaj intepajsol ipan imahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","No ijqui oquijtoj Jesús: ―¿Tlinon ica más huelis niquixnescayotis on itequihuayo Dios? ");
INSERT INTO nguNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yejhua quen tlaxocolilistli yejhuan se sihuatl quimanelohua ican yeyi tlatemachihuajli harina niman quemaj najcocui nochi on tixtli de harina. ");
INSERT INTO nguNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ijcuac Jesús panohuaya ipan on ojtli para Jerusalén, opajpanotiaj ipan pueblos niman ipan pueblitos campa temachtiaya. ");
INSERT INTO nguNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Quemaj se tlacatl ijquin oquitlajtoltij: ―ToTeco, ¿san quesquimej on yejhuan nomaquixtisquej? Niman yejhua oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―On tlatzacuilyotl yejhuan tlapojticaj ne ilhuicac pitzahuac. Xchihuacan canica para xcalaquican ne ipan on tlatzacuilyotl pampa nemechijlia ica miyequej quinequisquej calaquisquej pero xhuelisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ijcuac iTeco on chanyotl notelquetzas niman quitzacuas on tlatzacuilyotl, tla nemejhuamej ipan ojtli onemocajquej, nenquitetelosquej on tlatzacuilyotl niman nenquijtosquej: “ToTeco, xtechtlatlapohuili.” Pero yejhua mechijlis: “Nejhua xnicmati canon nenhualehuaj.” ");
INSERT INTO nguNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ijcuacon nemejhuamej pehuas nenquijtosquej: “Tejhuamej mohuan otitlacuajquej niman otatliquej, niman tejhua otitemachtij ipan tocalles.” ");
INSERT INTO nguNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero yejhua mechijlis: “Nejhua nemechijlia ica xnicmati canon nenhualehuaj. Xnechtlalcahuican nochimej nemejhuamej yejhuan nenquichihuaj on tlen xcuajli.” ");
INSERT INTO nguNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Sanoyej nenchocasquej niman nemotlantotopotzasquej ijcuac nenquitasquej ica Abraham, Isaac, Jacob niman nochimej on tiotlajtojquej nemij ne campa Dios tequihuatiticaj, chica nemejhuamej mechajquixtisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Niman on tlacamej yejhuan chanejquej ne iquisayan tonajli niman ne icalaquiyan tonajli, niman ne ica norte niman ne ica sur, huajlasquej para notlalisquej tlacuasquej ne ilhuicac ichan Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ijcuacon on yejhuan aman xhuejhueyixtoquej ijcuacon huejhueyixtiasquej, niman on yejhuan aman huejhueyixtoquej ijcuacon xhuejhueyixtiasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sa no ipan on tonajli, itech ohualajquej sequimej fariseos niman oquijlijquej: ―Xmejcuani nican pampa Herodes quinequi mitzmictis. ");
INSERT INTO nguNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero yejhua oquimijlij: ―Xhuiyan niman xquijlican on tlacajcayajquetl: “Xquita, aman niman mostla niquintequixtilia on xcuajcualtin espíritus niman niquimpajtia on cualoj, niman para huiptla nochi nitlamis.” ");
INSERT INTO nguNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero ica oncaj nicnejnemitis nojhui aman, mostla niman huiptla, pampa nochi tiotlajtojquetl ica oncaj miquis ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Ah nemejhuamej chanejquej ne Jerusalén, nemejhuamej nenquinmictiaj on tiotlajtojquej niman nenquintemojmotlaj on yejhuan Dios mechinhuajtitlanilia! ¡Miyecpa onicnec nemechsentlalis quen yejhua on cuanaca quinsentlalia iconehuan itzintlan imajtlapalhuan, pero xonenquinequej! ");
INSERT INTO nguNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aman xcaquican. Dios xoc mechpalehuis pampa yejhua yomechtlalcahui. Aman, tej, nemechijlia ica xoc nennechitasquej hasta ipan on tonajli ijcuac nemejhuamej nenquijtosquej: “Ma toTeco Dios quitiochihua on yejhuan ocuajtitlan.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ipan se tonajli de nesehuijli ijcuac on hebreos nosehuiaj, Jesús oyaj otlacuato ichan se tlayecanquetl fariseo, niman on ocsequimej fariseos sa quipijpiayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","No ompa nemiya se tlacatl yejhuan imahuan niman icxihuan pojposahuiyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Quemaj Jesús oquintlajtoltij on temachtijquej ican itlanahuatil Dios niman on fariseos: ―¿Totlanahuatil techcahuilia para ipan on tonajli de nesehuijli nopajtis se yejhuan cualo? ¿Quemaj noso ca? ");
INSERT INTO nguNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero yejhuamej xonahuatquej. Quemaj Jesús oconquitzquij on yejhuan cualo, niman oquipajtij niman oquijlij ma huiya. ");
INSERT INTO nguNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Niman on fariseos oquimijlij: ―¿Aquinon de nemejhuamej xnimantzin conquixtia tla se ipoloco noso ihuacax onhuetzi ijtic se pozo ipan on tonajli de nesehuijli? ");
INSERT INTO nguNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Niman xohuelquej itlaj ica oquinanquilijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ijcuac Jesús oquitac ica on tenotzaltin quitlapejpeniayaj on más huejhueyixtoquej sietas ne itech on mesa, oquitlalij yejhua in ejemplo: ");
INSERT INTO nguNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ijcuac yacaj mitznotzas para tehuan ticpanos on ilhuitl campa nonamictihua, ma ca timosehuis ipan on lugar más hueyixticaj, pampa huelis yejcos ocse yejhuan más hueyixticaj tlanotzajli xquen tejhua. ");
INSERT INTO nguNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tla ijcon, tej, on yejhuan omechnotz yas motech niman mitzijlis: “On sieta xmaca yejhua in yejhuan más hueyixticaj.” Niman ijcuac ijcon ticaquis mitzijliaj, ican mopinahuilis tias timotlalis ipan on sieta campa notlaliaj on yejhuan xhuejhueyixtoquej. ");
INSERT INTO nguNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Más cuajli tla ijcuac canaj mitznotzasquej, xmotlali ipan on sieta yejhuan para on yejhuan xhuejhueyixtoquej, para ijcuac motech huajlas on yejhuan omitznotz, mitzijlis: “Notetlajsojcau, xmotlaliti ne ipan on más hueyixticaj sieta.” Ijqui ticselis tetlacaitalistli imixpan on tlanotzaltin yejhuan ompa itech on mesa mohuan yejyehuatiasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ijcon xchihua, pampa on yejhuan nohueyilia, quicnotlalisquej, niman on yejhuan nocnotlalilia cueyilisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Niman on yejhuan oquinotz Jesús no oquijlij: ―Ijcuac ticnequis titetlacualtis tiotlac noso tlayohua, ma ca xquinnotza motetlajsojcahuan, nion mocnihuan, nion on yejhuan sa huejca mocnihuan, nion on monisiuchantlacaj yejhuan xitlaj quinpolohuaj, para ma ca sa no yejhuamej no quemantica mitznotzasquej niman ijcuacon quen mitzcuepilisquej on tlen achtopa tiquincualtis. ");
INSERT INTO nguNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yej ocse tlamantic xchihua. Ijcuac ticpias itlaj ilhuitl, xquinnotza on yejhuan mayanquej, on yejhuan macocoxquej noso icxitlajcomej, on yejhuan coxomej niman on yejhuan ciegos. ");
INSERT INTO nguNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Niman Dios mitztiochihuas pampa masqui yejhuamej xhuelisquej mitzcuepilisquej on tlacuajli, tejhua ticpias motlaxtlahuil ipan on tonajli ijcuac on yejhuan yolchipajquej yolihuisquej niman noquetztehuasquej ipan intlalcon. ");
INSERT INTO nguNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ijcuac semej yejhuamej on yejhuan yejyehuaticatcaj ne itech on mesa ijcon ocac, oquijlij Jesús: ―Melahuac tlatiochiutli yes on yejhuan quicuas pan ne ilhuicac campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Quemaj Jesús oquijlij: ―Sen tlacatl oquitemacac se hueyi tiotlac tlajcuajli, niman otlanahuatij ma quinnojnotzatij miyequej tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Niman ijcuac ye nisiu para tlacuasquej, oquititlan on itequichihuilijcau para ma quimijliti on tlanotzalti: “Xhuajlacan pampa ye oncaj tlachijchiutli nochi.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero nochimej opejquej sa tlamach ica notlamiyaj ica xhuelisquej yasquej ipan on tiotlac tlajcuajli. On achtoj tlacatl oquijtoj: “Quinamantzin oniconcou se tlajli, niman ica oncaj nicontas. Nimitztlajtlanilia xnechtlapojpolhui ica xnias ipan on tiotlac tlajcuajli.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","On ocse oquijtoj: “Nejhua onicou macuijli yunta huacax, niman ye niau niconmintas tla huelij cuajli tequitij. Tla ijcon xnechtlapojpolhui ica xnias ipan on tiotlac tlajcuajli.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Niman ocse oquijtoj: “Quemach oninonamictij, niman yejhua ica xnihuelis nias.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Quemaj on tequichihuilijquetl ohuajnocuepato niman nochi yejhua on tlen ica oquinanquilijquej, oquitlajtlajtohuilij on iteco. Ijcuacon on iteco ocualan niman oquijlij on itequichihuilijcau: “Amantzin xhuiya ipan icalles niman iojhui in hueyican, niman nican xquinhuajhuica on yejhuan mayanquej, niman on yejhuan macocoxquej, niman icxitlajcotzitzintin, niman on ciegos niman on coxomej.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Más saquin on tequichihuilijquetl oquijtoj: “Señor, yonicchiu tlen otinechnahuatij niman oc oncaj campa notlalisquej ocsequimej más.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ijcuacon on iteco oquijlij: “Xhuiya ipan on calles niman ipan on ojtin, niman xquinchihualti ocsequimej ma huajlacan para ma temi nochan. ");
INSERT INTO nguNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ijquin xchihua, pampa nemechijlia ica nion aquin de on yejhuan achtopa oniquinnotz xquicuasquej on tiotlac tlajcuajli yejhuan nictemacas.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Miyec tlacatl cuitlapanhuijtiayaj Jesús, niman yejhua ohuajnocuep niman oquimijlij: ");
INSERT INTO nguNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tla yacaj huajlau notech, niman yej quintlajsojtla más itaj, inan, isihuau, iconehuan, icnihuan yejhuan tlacamej niman yejhuan sihuamej, niman hasta sa no yejhua más quitlajsojtla inemilis xquen nejhua, yejhua xhuelis nonomachtijcau yes. ");
INSERT INTO nguNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Niman on yejhuan xquiselis on tlajyohuilistli ipan inemilis quen se tlacatl yejhuan quitqui icojnepanol ne campa quimictisquej niman xyas nohuan, xhuelis para yejhua nonomachtijcau yes. ");
INSERT INTO nguNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Cada semej nemejhuamej yejhuan quinequi quichijchihuas se torre, achtopa notlalia para quixtlalohua itomin tla caxilis para tlamis on torre. ");
INSERT INTO nguNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tla quitlalia on cimiento niman quemaj xoc hueli tlami, tla ijcon, quitasquej ocsequimej niman pehuas cuejhuetzquilisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Niman quijtosquej: “Yejhua on tlacatl oquipehualtij on itequiu niman xohuel otlan.” ");
INSERT INTO nguNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Cada rey yejhuan yau para onohuisoquij ihuan ocse rey, achtopa quixtlalohua tla huelis quixnamiquis ican majtlactli mil isoldados on ocse rey yejhuan huajlau ican sempoajli mil isoldados. ");
INSERT INTO nguNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Niman tla xhuelis, ijcuac on ocse rey oc huejca nemi, itech quintitlanilis sequimej tlacamej para contlajtlanilisquej tlinon quinequi on ocse rey para ma nopiali yolsehuilistli. ");
INSERT INTO nguNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ijcon, tej, san aquinon de nemejhuamej yejhuan achtoj quixtlalos ica quipias tlajyohuilistli niman cahuas nochi tlen quipia huelis para yejhua nonomachtijcau yes. ");
INSERT INTO nguNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’On istatl sanoyej cuajli, pero tla quipolos on ica poyec, ¿quen ijqui, tej, huelis ocsejpa poyec yes? On melahuac xhuelis. ");
INSERT INTO nguNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Xoc huelis quitequitiltisquej para on tlajli nion para se achitzin tlalpalanajli, yej san quixinisquej. Tla nemejhuamej nenquipiaj nemotlamachilis, xcajsicamatican on tlen niquijtohua. ");
INSERT INTO nguNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Miyequej on yejhuan tlacobrarohua ica impuestos niman on tlajtlacolejquej quinisihuiayaj Jesús para caquisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yejhua ica on fariseos niman on temachtijquej ican itlanahuatil Dios tlahueltlajtohuayaj niman ijquin quijtohuiliayaj Jesús: ―Yejhua in tlacatl quinselia on tlajtlacolejquej niman inhuan tlacua. ");
INSERT INTO nguNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yejhua ica Jesús oquintlalilij yejhua in ejemplo: ");
INSERT INTO nguNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ma ticonijtocan ica semej nemejhuamej quipia cien borreguitos niman se oquipoloj. ¿Xquincatehua on napoajli huan majtlactli huan chicnahui ne campa tlacualcan niman yau contejtemohua on se borreguito yejhuan oquipoloj hasta caman quinextia? ");
INSERT INTO nguNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Niman ijcuac conextia, ican pactli cuajnoquechpanoltia. ");
INSERT INTO nguNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Niman ijcuac ajsi ichan, quinsentlalia itetlajsojcahuan niman inisiuchantlacaj niman quimijlia: “Nohuan xpaquican, pampa yonicnextij on borreguito yejhuan onicpolojca.” ");
INSERT INTO nguNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nejhua, tej, nemechijlia ica ne ilhuicac no sa no ijqui nochihua. Ompa más oncaj pactli ipampa se tlajtlacolej yejhuan noyolpatla xquen impampa on napoajli huan majtlactli huan chicnahui cuajcualtin tlacamej yejhuan xquipiaj tlinon ica noyolpatlasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Noso ma ticonijtocan ica se sihuatl quipia majtlactli tomin tlachijchiutli ican plata niman se quipolohua. ¿Xquitlicuiltia itlahuil niman pehua tlachpana chica ican miyec cuidado quitejtemohua on tomin hasta caman quinextia? ");
INSERT INTO nguNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Niman ijcuac quinextia, quinsentlalia itetlajsojcahuan niman inisiuchantlacaj niman quimijlia: “Nohuan xpaquican pampa yonicnextij on tomin yejhuan onicpolojca.” ");
INSERT INTO nguNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nemechijlia ica no ijqui oncaj pactli ne intzajlan on iilhuicactequitcahuan Dios ipampa se tlajtlacolejquetl yejhuan noyolpatla. ");
INSERT INTO nguNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","No ijqui oquijtoj Jesús: ―Sen tlacatl quipiaya ome iconeu. ");
INSERT INTO nguNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Niman on yejhuan más conetl catca oquijlij itaj: “Notaj, xnechxelohuili aman on tlin ticpia yejhuan noyaxca yes.” Niman on tajtli oquintlajcoxelohuilij on tlen quipiaya. ");
INSERT INTO nguNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ipan quesqui tonajli más saquin, on telpochtli yejhuan más conetl oquisentlalij nochi tlajtlamach tlen iyaxca niman oyaj huejca ipan ocse país campa otlan quinajahuiltia itomin ican se xcuajli nemilistli. ");
INSERT INTO nguNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pero ijcuac nochi yoquitlamijca on tomin, sanoyej opeu tlasojti tlacuajli ne ipan on país, niman opeu ajapismiqui. ");
INSERT INTO nguNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Quemaj oquitejtemoto tequitl itech se tlacatl yejhuan chanej ipan on país, niman on tlacatl oquititlan imijla para quintlapialis ica on ipitzohuan. ");
INSERT INTO nguNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Niman sanoyej quinequiya quicuas on tlacuajli itoca algarrobas yejhuan quicuayaj on pitzomej, pero xacaj quimacaya. ");
INSERT INTO nguNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ijcuacon opeu ijquin quinemilia: “Nochi on tequitquej ichan notaj quipiaj más tlacuajli san quech quinequij quicuaj, niman nejhua nican ye nimicticaj ican apistli. ");
INSERT INTO nguNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ninoquetztehuas niman nias ne campa nemi notaj, niman ijquin niquijlis: Ay notaj, yonitlajtlacoj itech Dios niman motech. ");
INSERT INTO nguNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aman xoc nechmelahua tinechitas quen nimoconeu. Aman sa xnechpohua quen semej yejhuamej on motequichihuilijcahuan.” ");
INSERT INTO nguNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Quemaj onotelquetz ocajsic ojtli niman oyaj ne ichan itaj. ’Ijcuac oc huejca huajlaya, on itaj ocontac niman oquicnelij. Onotlaloj oquinamiquito. Oquinapaloj niman oquitencuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Niman on teconeu oquijlij itaj: “Ay notaj, yonitlajtlacoj itech Dios niman motech. Aman xoc nechmelahua tinechitas quen nimoconeu.” ");
INSERT INTO nguNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero on tajtli oquimijlij on itequichihuilijcahuan: ¡Amantzin xcuaquican on yejhuan más cuajli tlaquentli, niman xtlaquentican! Xtlaliltican se anillo ipan imajpil, niman no xcactican. ");
INSERT INTO nguNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Quemaj xcuajhuicacan on huacaxconetl yejhuan más tomahuac niman xmictican. ¡Aman titlacuasquej ican paquilistli! ¡Aman ticchihuasquej se ilhuitl! ");
INSERT INTO nguNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ijcon ticchihuasquej, pampa yejhua in noconeu quen yomica, pero aman ocsejpa ye quipia nemilistli. Yejhua yopolijca, pero aman yones. Quemaj opejquej quichihuaj on ilhuitl. ");
INSERT INTO nguNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ijcuac in nochijticatca, on teconeu yejhuan yencuiyotl nemiya ipan tepetl. Niman ijcuac ohuajnocuepato niman oajsic nisiu ichan, oconcac on tlapitzquej ichan niman no ocontac nijtotihua. ");
INSERT INTO nguNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Quemaj ocontzajtzilij se tequichihuilijquetl niman oquitlajtoltij tlinon nochihuaya. ");
INSERT INTO nguNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","On tequichihuilijquetl oquijlij: “Oncaj ilhuitl pampa mocniu yohuajlaj. Niman motaj otlanahuatij ma quimictican on huacaxconetl yejhuan más tomahuac, pampa mocniu oyejcoc chicajticaj niman xcualo.” ");
INSERT INTO nguNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pero on yencuiyotl teicniu ocualan hasta xquinequiya oncalaquis ne ichan. Yejhua ica itaj oquisaco para oquitlajtlanilij ma calaquiti. ");
INSERT INTO nguNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Niman yejhua oquijlij itaj: “Tejhua ticmatzticaj miyec xipan yonimitztequichihuilij, niman nochipa nimitztlacamati, pero xqueman tinechmaca nion se chito conetl para nicchihuas se ilhuitl inhuan notetlajsojcahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero aman oyejcoc yejhua in moconeu, yejhuan oquipopoloj motomin inhuan on sihuajahuilnemij, niman para yejhua ticmictia on huacax conetl yejhuan más tomahuac.” ");
INSERT INTO nguNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Quemaj on tajtli oquijlij: “Noconeu, tejhua nochipa nohuan tinemi niman nochi tlen nicpia tejhua moyaxca. ");
INSERT INTO nguNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero aman nonequi ticchihuasquej ilhuitl niman tipaquisquej, pampa mocniu quen yomica, pero aman ocsejpa quipia nemilistli. Yejhua yopolijca, pero aman yones.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús no oquimijlij on inomachtijcahuan: ―Nemiya se tlacatl yejhuan quinopiyaliaya miyec niman quipiaya se tequitquetl tlayecanqui. Niman yejhua in tlacatl yejhuan iteco on tequitquetl oquijlijquej ica on tequitquetl san quinempolohuilia itequiu. ");
INSERT INTO nguNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Quemaj on iteco oquinotz on tequitquetl tlayecanqui, niman oquijlij: “¿Tlinon quijtosnequi yejhua in yejhuan moca nechijliaj? Xnechcahuili nochi quen yau motequiu yejhuan yoticchiu, pampa aman tejhua xoc tinotequitcau yes tlayecanqui.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Quemaj on tequitquetl tlayecanqui opeu quinemilia: “¿Aman tlinon nicchihuas? Noteco nechquixtilia on tequitl. Xnicojtic para nictequitis on tlajli, niman nipinahua ninotlajtlayehuis. ");
INSERT INTO nguNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ye nicmatzticaj tlinon nicchihuas para nicpias aquin nechselisquej inchan ijcuac nejhua xnicpias tequitl.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Quemaj cada sesentemej oquinnotz on yejhuan cuiquiliayaj iteco. On achtoj tlacatl oquitlajtoltij: “¿Quech ticuiquilia noteco?” ");
INSERT INTO nguNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Niman yejhua oquijlij: “Nicuiquilia cien hueyi tlatemachijtli ica on aceite.” Ijcuacon on tequitquetl tlayecanqui oquijlij: “Nican oncaj tlin tictehuiquilia. Nimantzin xmotlali niman ocse xchijchihua yejhuan san ompoajli huan majtlactli.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Quemaj on ocse no oquitlajtoltij: “Niman tejhua, ¿quech ticuiquilia noteco?” Niman yejhua oquijlij: “Cien tlatemachijtli ica on trigo.” Ijcuacon oquijlij: “Nican oncaj tlin tictehuiquilia, niman ocse xchijchihua yejhuan san de napoajli.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Niman on tlacatl yejhuan iteco on xcuajli tequitquetl tlayecanqui oquiyecteneu pampa oquipix itlamachilis para oquichiu ijcon ipan on itequiu. Quemaj Jesús oquijtoj: ―Lástima pampa on tlalticpactlacamej más quimatij quen ijqui quitequitiltia on tlajtlamach ipan on tlin xcuajli, xijqui quen on iconehuan Dios quichihuaj ica on tlin cuajli. ");
INSERT INTO nguNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Nejhua nemechijlia ica más cuajli ica nenquitequitiltiaj on riquezas de yejhua in tlalticpactli para quimpalehuisquej on mayanquej niman ijcon nenquipiasquej nemotetlajsojcahuan yejhuan ijcuac on riquezas tlamis mechselisquej ne ilhuicac campa para nochipa nennemisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Yejhuan quipia cuajli iyojlo itech on tlen achijtzin, no ipan on tlen miyec quipia cuajli iyojlo. Niman on yejhuan xcuajli quipia iyojlo itech on tlen achijtzin no ipan on tlen miyec xquipia cuajli iyojlo. ");
INSERT INTO nguNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aman, tej, tla ipan on riquezas yejhuan oncaj ipan in tlalticpactli xcuajli nenquipiaj nemoyojlo, xacaj, tej, mechmactilis on tlen melahuac cuajli riquezas. ");
INSERT INTO nguNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Niman tla ipan on tlen xnemoyaxca xnenquipiaj cuajli nemoyojlo, xacaj, tej, mechmacas on tlen nemoyaxca yes. ");
INSERT INTO nguNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Xacaj tetequichihuilijquetl hueli quitequichihuilia ome iteco, pampa se xcuelitas niman on ocse cuelitas, noso se quipialis cuajli iyojlo niman on ocse quitlalcahuis. Xhuelis tictequichihuilis Dios san secan ihuan on tomin. ");
INSERT INTO nguNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","On fariseos, yejhuan quinejnequiyaj on tomin, cacticatcaj nochi on tlen Jesús quijtohuaya niman san cuejhuetzquiliaya. ");
INSERT INTO nguNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ijcuacon Jesús oquimijlij: ―Nemejhuamej nenquichihuaj para nennesij quen sanoyej nencuajcualtin tlacamej imixpan on tlacamej, pero Dios quixmati nemoyojlo. Xmatican ica on tlen on tlacamej quiseliaj quen hueyixticaj, Dios xcuelita. ");
INSERT INTO nguNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Hasta ipan on tonaltin ijcuac nemiya Juan on tlacuatequijquetl, on itlanahuatil Moisés niman intlamachtilhuan on tiotlajtojquej ipan onohuicaquej. Niman desde ijcuacon, noteijliaj on yencuic tlajtojli yejhuan techmachiltiaj quen ijqui Dios tlamandarohua. Niman aman nochimej quinchihualtiaj quen ijqui quincalactisquej campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Más huelis achtoj popolihuis on cielo niman on tlalticpactli, xquen yejhua on itlanahuatil toTeco quipolos se pitelotzin yejhuan más pitentzin. ");
INSERT INTO nguNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tla se tlacatl noxotonis itech isihuau niman ihuan ocse sihuatl nonamictis, quichihua sihuapajpatlalistli. Niman tla se tlacatl nonamictia ihuan on sihuatl yejhuan onoxotonij itech ihuehuentzin quichihua sihuapajpatlalistli. ");
INSERT INTO nguNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Nemiya se tlacatl yejhuan ricoj catca. Yejhua notlaquentiaya quen yacaj rey ican on tlaquentli sanoyej patioj niman petlani. Niman mojmostla quichihuaya ilhuitl niman quicuayaj miyec tlajcuajli yejhuan sanoyej cuajli. ");
INSERT INTO nguNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Niman ne iquiahuatenco on tlacatl yejhuan ricoj catca notlaliaya se mayancatlacatl itoca Lázaro yejhuan nochi itlalnacayo tzotzoyoj catca. ");
INSERT INTO nguNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yejhua in mayancatlacatl quinequiya quicuas on tlen xiniya ne ipan imesa on tlacatl rico. Niman on chichimej quipajpalohuiliayaj itzotzohuan. ");
INSERT INTO nguNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Se tonajli on mayanqui omic, niman on ilhuicactequitquej ocuicaquej para nemis ihuan Abraham ne ilhuicac. On tlacatl yejhuan ricoj catca no omic, niman oquitocato. ");
INSERT INTO nguNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","On tlacatl yejhuan ricoj catca sanoyej tlajyohuiaya ne mictlan campa tetlajyohuiltiloyan, niman oajcotlachix nepa tlacpac campa ocontac Abraham ihuan Lázaro. ");
INSERT INTO nguNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Quemaj ontzajtzic: “Notaj Abraham, ¡xnechpiali teicnelilistli! Xnahuati Lázaro ma quipatzo icuatipan imajpil ican atl, niman ma huajla, ma quiseseliqui nonenepil, pampa sanoyej nitlajyohuijticaj ipan in tlitl.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham oquijlij: “Noconeu, xquelnamiqui ica tejhua oticselij nochi tlen cuajli ipan monemilis, niman Lázaro oquiselij nochi tlen xcuajli. Pero aman yejhua quiselia paquilistli, niman tejhua titlajyohuiya. ");
INSERT INTO nguNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Niman no oncaj se hueyi atlautli sanoyej tlacpac yejhuan techxelohua. Niman on yejhuan nican nemij yejhuan quinequij yasquej ompa on xhuelij, nion yejhuamej on yejhuan ompa on nemij xhuelij huajlahuij nican.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Quemaj on tlacatl yejhuan ricoj catca oquijtoj: “Tla ijcon, tej, notaj Abraham, nimitzicnotlajtlanilia xcontitlani Lázaro ichan notaj ");
INSERT INTO nguNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","campa niquimpia macuijli nocnihuan. Xcontitlani para ma quinmachiltiti, niman ijcon yejhuamej ma ca huajlasquej nican campa tetlajyohuiltiloyan.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abraham oquijlij: “Yejhuamej ompa quipiaj on tlen oquijcuilojquej Moisés niman on tiotlajtojquej. Ma yejhuamej quincaquican.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","On tlacatl yejhuan ricoj catca oquijlij: “Ca, notaj Abraham, yejhuamej xquincaquisquej. Pero tla yacaj comintas yejhuan yolihuis niman noquetztehuas intzajlan on mimiquej, yejhuamej cajcahuasquej ica quichihuaj on tlen xcuajli.” ");
INSERT INTO nguNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham oquijlij: “Tla xquinequij caquisquej Moisés niman on tiotlajtojquej, no ijqui xtlaneltocasquej, masqui yacaj yolihuis niman noquetztehuas intzajlan on mimiquej niman quinnojnotzas.” ");
INSERT INTO nguNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús oquimijlij on inomachtijcahuan: ―Nochipa onyas on tlajtlamach yejhuan quinchihualtis on tlacamej para ma tlajtlacocan. Pero ¡lástima para on tlacatl yejhuan quinchihualtia ocsequimej tlajtlacohuaj! ");
INSERT INTO nguNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más cuajli yesquia tla iquechpan quisalohuilisquiaj se tetl hueyi yejhuan imetl on molino, niman contlajcalisquiaj ipan mar, ijcuac xe quinchihualtia para semej in coconej ma tlajtlacocan. ");
INSERT INTO nguNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tla ijcon, xmotacan sa no nemejhuamej. ’Tla mocniu tlajtlacohua motech, xmelajcanotza ica on tlen oquichiu, niman tla noyolpatla, xtlapojpolhui. ");
INSERT INTO nguNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Masqui chicomepa mitzchihuilis tlajtlacojli ipan se tonajli niman cada ves huajlas niman mitzalijlis: “Aman xoc ocsejpa nicchihuas”, tla ijcon quitocarohua tictlapojpolhuis. ");
INSERT INTO nguNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","On apóstoles oquijlijquej toTeco: ―Xtechmaca más tlaneltoctli. ");
INSERT INTO nguNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Quemaj on toTeco oquimijlij: ―Tla nenquipiasquiaj nemotlaneltoc, masqui sanoyej pitentzin quen yejhua on ixinachyo mostaza, huelisquia nenquijlisquiaj in cojtli sicómoro: “Xmohuihuitla nican niman xmotocati ne ipan mar”, niman on cojtli mechtlacamatisquia. ");
INSERT INTO nguNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tla semej nemejhuamej quipia se itequichihuilijcau niman tla yejhua yohuajnocuepato ne campa tlaxoponia noso quintlapixtiaya on huacaxtin, ¿manin tiquijlia: “Xcalaqui; xmotlali niman titlacuas”? ");
INSERT INTO nguNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ca, tejhua yej tiquijlia: “Xnechchihuili tlen nicuas, niman xnemi nican para tiquitas tlen nechpolohua chica nejhua nitlacua niman natli. Quemaj quej tejhua huelis titlacuas niman tatlis.” ");
INSERT INTO nguNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Manin ticmaca tlaxtlahuijli on motequichihuilijcau pampa oquichiu on tlen oticnahuatij? Cuajli ticmatztoquej ica ca. ");
INSERT INTO nguNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","No ijqui ijcuac nemejhuamej tlamis nenquichihuasquej nochi tlen Dios mechnahuatia, nonequi nenquijtosquej: “Tejhuamej xticuajcualtin titequitquej, pampa oticchijquej san on yejhuan nonequi ticchihuasquej.” ");
INSERT INTO nguNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ijcuac Jesús onojhuitlalij para Jerusalén, opanoc intzajlan on iregión Samaria niman Galilea. ");
INSERT INTO nguNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ijcuac oajsic ipan se pueblito, oquisquej oquinamiquitoj majtlactlimej tlacamej yejhuan quipiayaj on cualolistli yejhuan palania innacayo itoca lepra. Yejhuamej san huejca onomajmanquej ");
INSERT INTO nguNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","niman ijquin ocontzajtzilijquej Jesús: ―¡Jesús, Temachtijquetl, xtechicneli niman xtechpalehui! ");
INSERT INTO nguNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ijcuac Jesús oquintac, oquimijlij: ―Xhuiyan; xmoteitititij ne intech on tiopixquej. Niman chica yejhuamej yayaj, opajtiquej. ");
INSERT INTO nguNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Quemaj semej yejhuamej, ijcuac onotac yopajtic, onocuep, niman ican chicahuac tlajtojli cueyiliaya Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Onotlacuenquetz ixpan Jesús onopachoj, niman ocajxitij ixayac hasta ipan tlajli, niman oquimacac tlaxtlahuijli. Niman on tlacatl chanej catca ne Samaria. ");
INSERT INTO nguNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Quemaj Jesús oquijtoj: ―¿Xnochimej on majtlactlimej opajtiquej? ¿Canon nemij on ocse chicnahuimej? ");
INSERT INTO nguNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿San yejhua in yejhuan xhebreo ohuajnocuepato, para cueyilia Dios? ");
INSERT INTO nguNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Quemaj Jesús oquijlij on tlacatl: ―Xmoquetztehua niman xhuiya. Otipajtic pampa otitlaneltocac. ");
INSERT INTO nguNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","On fariseos oquitlajtoltijquej Jesús quemanon pehuas tlamandaros Dios, niman yejhua oquimijlij: ―On ica yejcos ijcuac Dios tlamandaros, on xquen itlaj hueyilistli yejhuan huelis yacaj quitas. ");
INSERT INTO nguNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nion xnoteijlis: “Ye nican oncaj” noso “Nepa oncaj” pampa Dios ye nemotzajlan nemi listo para mechmandaros. ");
INSERT INTO nguNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Quemaj oquimijlij on inomachtijcahuan: ―Yejcos on tonaltin ijcuac nemejhuamej nenquinequisquej para nejhua yejhuan oninochiu Tlacatl nihuajlas nemohuan masqui san se tonajli, pero xninemis nemohuan. ");
INSERT INTO nguNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Niman nemisquej sequimej yejhuan mechijlisquej: “Nican nemi” noso “Nepa nemi.” Pero nemejhuamej ma ca xhuiyan, nion ma ca xquinhuicacan, ");
INSERT INTO nguNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","pampa ijcon quen ne iquisayan tonajli huajpehua nesi on tlapetlanajli niman on tlami hasta ne icalaquiyan on tonajli, sa no ijqui nochihuas ijcuac nejhua yejhuan oninochiu Tlacatl nihuajlas. ");
INSERT INTO nguNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero achtopa ica oncaj sanoyej nitlajyohuis, niman nechixnamiquisquej on tlacamej yejhuan nemij ipan in tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ijcuac nejhua yejhuan oninochiu Tlacatl nihuajlas, on tlacamej no ijqui nohuicasquej ijcon quen on tlacamej onohuicaquej ipan on tonaltin ijcuac nemiya Noé. ");
INSERT INTO nguNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yejhuamej tlacuayaj niman atliyaj, niman nonamictiayaj niman quintemacayaj imichpochhuan para ma nonamictican, hasta ijqui oyejcoc on tonajli ijcuac Noé ocalac ijtic on barco. Niman quemaj ohuajlaj on apachihuilistli niman nochimej yejhuamej oamimiquej. ");
INSERT INTO nguNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ijcuac nihuajlas no ijqui nohuicasquej on tlacamej quen onohuicaquej ipan on tonaltin ijcuac nemiya Lot. Tlacuayaj niman atliyaj, tlacohuayaj niman tlanamacayaj, tocayaj niman quinchijchihuayaj incal. ");
INSERT INTO nguNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero ipan on tonajli ijcuac Lot oquis ne ipan on hueyican itoca Sodoma, otliquiau ican tlitl niman azufre, niman ijqui nochimej omiquej. ");
INSERT INTO nguNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ijcon nochihuas ipan on tonajli ijcuac nejhua yejhuan oninochiu Tlacatl nihuajnonextis. ");
INSERT INTO nguNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ipan on tonajli, tla yacaj nemis ne ipan ical, ma ca ma temo para conquixtis on tlajtlamach quipia icalijtic. Niman tla yacaj nemis ne ipan tepetl, ma ca ma huajnocuepa para ichan. ");
INSERT INTO nguNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xquelnamiquican tlinon ipan onochiu isihuau Lot. ");
INSERT INTO nguNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","On yejhuan quichihuas canica para quimaquixtis inemilis ipan in tlalticpactli, quipolos ialma. Pero on yejhuan quipolos inemilis san nopampa quimaquixtis ialma. ");
INSERT INTO nguNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Nemechijlia ica ipan on tlayohua cochisquej omemej san secan. On se cuicasquej niman ocse cajtehuasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Omemej sihuamej san secan tistiasquej. On se cuicasquej niman ocse cajtehuasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Omemej tlacamej nemisquej ne ipan tepetl. On se cuicasquej niman ocse cajtehuasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ijcuac ijcon oquicaquilijquej, oquitlajtoltijquej: ―¿Canon ijcon nochihuas, toTeco? Niman yejhua oquimijlij: ―Campa tlajcaltos on yolqui yejhuan yomic, ompa nosentlalisquej on tzopilomej. Yejhua ijquin oquijtoj pampa no ijqui yes ne campa nemisquej on yejhuan xtlaneltocaj itech Dios. Ompa quinyolcuitisquej niman quintlajtlacolmacasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús oquintlalilij se ejemplo para quintitis ica nonequi nochipa quichihuasquej oración, niman xqueman cajcahuasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ijquin oquimijlij: ―Ipan se pueblo nemiya se juez teyolcuitijquetl. Yejhua xquitlacaitaya Dios, nion oquipix teicnelilistli para on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sa no ipan on pueblo no nemiya se sihuacahuajli yejhuan nochipa contaya on juez para quitlajtlaniliaya ma quipalehui para huelis quitlanis on yejhuan ihuan quipiaya tlahuejli. ");
INSERT INTO nguNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Miyecpa on juez xoquinec quipalehui on sihuacahuajli, pero más saquin ononemilij: “Masqui xnictlacaita Dios nion nicpia teicnelilistli para tlacamej, ");
INSERT INTO nguNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nicpalehuis yejhua in sihuatl san pampa sanoyej huajlajtinemi niman nechpajsolohua niman ma ca yej nechyolajxitis.” ");
INSERT INTO nguNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Niman on toTeco oquijtoj: ―Xcaquican on tlen oquijtoj on xcuajli juez teyolcuitijquetl. ");
INSERT INTO nguNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aman, tej, Dios no quimpalehuis on yejhuan oquintlapejpenij tla ican tonajli niman yehuajli itech nohueyicatzajtzilijtoquej. ¿Nohuejcahuas ica quimpalehuis? ");
INSERT INTO nguNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nemechijlia ica xnohuejcahuas ica quimpalehuis. Pero ijcuac nejhua yejhuan oninochiu Tlacatl nihuajlas, ¿niquinhuajnextis on tlacamej ipan in tlalticpactli yejhuan tlaneltocaj? ");
INSERT INTO nguNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús oquimijlij se ejemplo on yejhuan quinemiliaj ica yejhuamej más cuajcualtin niman quinchichihuaj on ocsequimej. Oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Omemej tlacamej oquichihuatoj oración ne ipan tiopan. Semej yejhuamej se fariseo catca niman ocse yejhuan tequitiya quen tlacobrarojquetl ican impuestos. ");
INSERT INTO nguNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","On fariseo ijcaticatca niman ijquin quichihuaya ioración: “Oh Dios, noTajtzin, nimitzmaca tlaxtlahuijli pampa nejhua xnicchihua quen on ocsequimej yejhuan quiteixpachohuiliaj itlaj, niman xyolmelajquej niman sihuapajpatlaj. No ijqui nimitzmaca tlaxtlahuijli pampa xnicchihua quen yejhua in tlacobrarojquetl ican impuestos. ");
INSERT INTO nguNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nejhua ocpa ninosahua ipan se semana, niman de nochi on tlen nictlani ompa niquixtia on diezmo niman nimitzmaca.” ");
INSERT INTO nguNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero on tlacobrarojquetl san huejca onocau niman xquinequiya nion achijtzin para ajcotlachas ne ilhuicac, yej san noyelpanhuitequiya ican ajmantli niman quijtohuaya: “¡Oh Dios, noTajtzin, xnechicneli! Nejhua sanoyej nitlajtlacolej.” ");
INSERT INTO nguNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nemechijlia ica ijcuac on tlacobrarojquetl oyaj ichan, xoc quipiaya tlajtlacojli. Pero on fariseo xoquitlapojpolhuijquej, pampa on yejhuan nohueyilia, masqui xquinequis nocnelis, niman on yejhuan nocnelia, quihueyilisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","On tlacamej quinhuajhuicayaj inconetzitzihuan itech Jesús para ma quincuamatoca. Pero ijcuac on nomachtijquej ijcon oquitaquej, opejquej quimajhuaj on yejhuan quinhuajhuicayaj on coconej. ");
INSERT INTO nguNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús oquinnotz on coconej ma huajlacan itech, niman oquimijlij inomachtijcahuan: ―Xquincahuacan on coconej notech ma huajlacan, niman ma ca xquinteltican, pampa on yejhuan yolyemanquej quen in coconej calaquisquej ne campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ica tlen melahuac nemechijlia ica on yejhuan xquiselis itequihuayo Dios quen yacaj conetl, xqueman calaquis campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Semej yejhuamej on tlayecanquej oquitlajtoltij Jesús: ―Cuajli temachtijquetl, ¿tlinon nonequi nicchihuas para nicselis on yencuic nemilistli yejhuan para nochipa? ");
INSERT INTO nguNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús oquijlij: ―¿Tlica tiquijtohua ica nicuajli? Dios san yejhua iselti cuajli, niman tejhua ticnemilia ica nejhua xniDios. ");
INSERT INTO nguNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tejhua tiquimixmati on tlen Dios tlanahuatia: “Ma ca xsihuapajpatla, ma ca xtemicti, ma ca xtlachtequi, ma ca yacaj xtlajtolquetztehuili, xtlacaita motaj niman monan.” ");
INSERT INTO nguNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","On tlacatl oquijlij: ―Nochi yejhua in desde niconetl nicuajtlacamatztiu. ");
INSERT INTO nguNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ijcuac Jesús ijcon ocac, oquijlij: ―Oc mitzpolohua sa se cosa. Xhuiya mochan niman xnamaca nochi tlen ticpia niman on tomin xquinmaca on mayanquej. Tla ijcon ticchihuas, ticpias riquezas ne ilhuicac. Niman quemaj xhuajla niman xnechhuica. ");
INSERT INTO nguNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero ijcuac on tlacatl ijcon ocac, sanoyej onajman pampa sanoyej ricoj catca. ");
INSERT INTO nguNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ijcuac Jesús oquitac ica on tlacatl onajman, oquijtoj: ―¡Sanoyej ohuijticaj para Dios quinmandaros on yejhuan ricos! ");
INSERT INTO nguNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más sanoyej ohuijticaj para se rico calaquis ne campa Dios tlamandarohua xquen para se camello panos ipan on campa tlacoyoniaj ican aguja. ");
INSERT INTO nguNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","San yejhua ica on, yejhuamej on yejhuan ocacquej oquitojquej: ―Tla ijcon, ¿aquinon huelis maquisas? ");
INSERT INTO nguNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús oquimijlij: ―On tlen on tlacamej xhuelij quichihuaj, Dios quemaj hueli quichihua. ");
INSERT INTO nguNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro oquijlij: ―Xquita, tejhuamej yoticajquej nochi tlen ticpiayaj, niman tiquistinemij mohuan. ");
INSERT INTO nguNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ijcuacon yejhua oquimijlij: ―Ica tlen melahuac nemechijlia ica san aquinon yejhuan quicahuas ichan, noso itajhuan, noso icnihuan, noso isihuau, noso iconehuan san ipampa itequiu Dios, ");
INSERT INTO nguNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","quiselis miyec más ipan in tonaltin, niman ipan on tonaltin yejhuan huajlau quiselis nemilistli yejhuan para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús ocsecan oquinnotz on majtlactli huan ome nomachtijquej, niman oquimijlij: ―Aman tiahuij ne Jerusalén campa tenquisas nochi tlen on tiotlajtojquej oquijcuilojquej noca nejhua yejhuan oninochiu Tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nechtemacasquej, tej, intech on yejhuan xhebreos. Yejhuamej nechhuetzcasquej, nechhuijhuicaltisquej niman nechchijchasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nechhuijhuitequisquej niman quemaj nechmictisquej, pero ipan yeyi tonajli nejhua niyolihuis niman ninoquetztehuas ne ipan notlalcon. ");
INSERT INTO nguNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nochi yejhua on tlen oquimijlij xocajsicamatquej, pampa nochi on tlajtlamach tlen oquimijlij Dios xoquincahuilij ma cajsicamatican. Yejhuamej, tej, nion achijtzin xquimatiyaj tlinon ica tlajtlajtojticatca. ");
INSERT INTO nguNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ijcuac Jesús oquinisihuij on hueyican itoca Jericó, se ciego yehuaticatca ipan ojtli notlajtlayehuiticatca. ");
INSERT INTO nguNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ijcuac on ciego ocac miyec tlacatl panoticaj ne campaca yejhua nemiya, oquitetlajtoltij tlinon nochijticaj. ");
INSERT INTO nguNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Niman oquijlijquej ica Jesús yejhuan hualehua Nazaret ompaca panoticatcaj. ");
INSERT INTO nguNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Quemaj on ciego otzajtzic: ―¡Jesús, huejca teixhuiu itech David, xnechicneli niman xnechpalehui! ");
INSERT INTO nguNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","On yejhuan tlayecapan yayaj ocajhuaquej niman oquijlijquej para ma ca sa ma nahuati, pero yejhua oc más tzajtziya: ―¡Huejca teixhuiu itech David, xnechicneli niman xnechpalehui! ");
INSERT INTO nguNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Quemaj Jesús onoteltij niman otlanahuatij ma canilitij. Ijcuac ixpan yocuajhuiquilijquej, Jesús ijquin oquijlij: ");
INSERT INTO nguNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tlinon ticnequi ma nimitzchihuili? Niman on ciego oquijlij: ―NoTeco, xchihua para ma nitlacha. ");
INSERT INTO nguNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","43","Jesús oquijlij: ―¡Xseli motlachalis! Nimantzin on ciego ohuel otlachix. Quemaj Jesús oquijlij: ―Aman oticselij motlachalis pampa otitlaneltocac ica nimitzpajtisquia. Ijcuacon yejhua oyaj ihuan Jesús, niman quihueyiliaya Dios. Niman nochimej tlacamej yejhuan oquitaquej yejhua on no oquiyectenejquej Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Quemaj Jesús ocalac niman san opanotiquis ne ipan on hueyican itoca Jericó. ");
INSERT INTO nguNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ipan on hueyican nemiya se tlacatl yejhuan rico catca. Yejhua intlayecancau catca on tlacobrarojquej ican impuestos. Yejhua itoca catca Zaqueo. ");
INSERT INTO nguNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yejhua quinequiya quitas aquinon Jesús, pero xhueliya quitaya pampa yejhua semi xhuejcapan catca niman sanoyej tojlan catca. ");
INSERT INTO nguNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ne campaca Jesús opanoc, oncatca se cojtli itoca sicómoro. Niman Zaqueo onotlaloj niman otlejcoto ne ipan on cojtli para ohuel oquitac Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ijcuac Jesús ompaca panotiaya, onajcotlachix, niman oquijlij Zaqueo: ―Zaqueo, xhuajtemotetzi, pampa aman ica oncaj mochan ninocahuas. ");
INSERT INTO nguNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Quemaj Zaqueo nimantzin ohuajtemoc, niman ican pactli oquiselij Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ijcuac ijcon oquitaquej, nochimej opejquej quichtacatlatohuiliayaj, niman quijtohuayaj tlica Jesús ocalaquito niman nocahua ichan se tlajtlacolej. ");
INSERT INTO nguNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Quemaj Zaqueo ohuajnotelquetz niman oquijlij on toTeco: ―Xcaqui, noTeco, on tlen nicpia tlajcotipan niquinmacas on yejhuan mayanquej. Niman tla yacaj onicajcayajca para ohuel onictlachtequilij, naupa sa no ijqui nicuepilis on quech oniquichtequilijca. ");
INSERT INTO nguNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús oquijlij: ―Aman on yejhuan chantij nican ipan in cajli yoquiseliquej temaquixtilistli, pampa in tlacatl no tlaneltoca quen Abraham otlaneltocac. ");
INSERT INTO nguNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nejhua, tej, yejhuan oninochiu Tlacatl onihuajlaj para onictejtemoco niman oniquicmaquixtico on yejhuan ixpolijtoquej. ");
INSERT INTO nguNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Chica on tlacamej cacticatcaj on tlajtlamach yejhuan Jesús quimijlijticatca, oquintlalilij ocse ejemplo, pampa ye nisiu Jerusalén nemiya niman on tlacamej quinemiliayaj ica san yejcotetzis on ica Dios tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yejhua ijquin oquimijlij: ―Nemiya se hueyixticaj tlacatl. In tlacatl ye quipiaya para yas huejca ipan ocse país campa conselis tlanahuatijli para rey yes, niman quemaj ocsejpa huajlas. ");
INSERT INTO nguNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ijcuac xe yaya ipan on país, oquinnotz majtlactlimej itequichihuilijcahuan para cada se quimacas huejhueyi tomin. Quemaj oquinmijlij: “San chica nihuajlau, xtlacohuacan niman xtlanamacacan ica in tomin.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero on tlacamej chanejquej ipan on país quitlahuelitayaj on tlacatl. Yejhua ica yejhuamej oquintitlanquej quesquimej tlacamej yejhuan san ocuitlapanhuijquej para oquiteijlitoj: “Xticnequij para yejhua in tlacatl torey yes.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","On tlacatl oquiselij tlanahuatijli para rey, niman quemaj onocuep para oyaj ipan ipaís. Ijcuac oajsic ichan, oquintlatitlanilij on yejhuan oquincahuilijtejca itomin. Yejhua oquintecuitlan para quimatis quech yoquitlan cada se. ");
INSERT INTO nguNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","On achtoj tlacatl oyaj itech, niman oquijlij: “Señor, motomin ocse majtlactli yoquitlan.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Niman on rey oquijlij on tlacatl: “Sanoyej cuajli tlen oticchiu. Tejhua ticuajli tequitquetl. Niman pampa oticpix cuajli moyojlo ipan on tlen achijtzin onimitzmacac, nimitzmactilis majtlactli pueblos para titequihuaj yes.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Quemaj quej yejhua on ocse oyaj itech niman oquijlij: “Señor, motomin ocse macuijli yoquitlan.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Niman on rey no ijqui oquijlij: “Tejhua nimitzmactilis macuijli pueblos para titequihuaj yes.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Quemaj quej on ocse oyaj itech niman oquijlij: “Señor, nican oncaj motomin yejhuan oniquejeu ican se pañito. ");
INSERT INTO nguNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nejhua oninomojtij pampa tejhua tiyoltechicactic, niman ticmoyaxcatia on tlen xmoyaxca niman tictlani on itlanca on tlen tictemaca.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ijcuacon on rey oquijlij: “¡Xcuajli tequichihuilijquetl! Sa no ican motlajtol nimitztlajtlacolmaca. Tejhua ticmatzticatca ica niyoltechicactic, pampa nicnoyaxcatia on tlen xnoyaxca niman nictlani itlanca on tlen nictemaca. ");
INSERT INTO nguNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tla ijcon, tej, ¿tlica xoticalactij notomin ipan banco para tla yonejcoc nochan nicselijtejcosquia on itlanca?” ");
INSERT INTO nguNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Quemaj on rey oquimijlij on yejhuan ompa nemiyaj: “Xcuilican on tomin niman xmacacan on yejhuan quipia majtlactli tomin.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Niman yejhuamej oquijlijquej on rey: “Pero Señor, yejhua ye quipia majtlactli.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","On rey oquimijlij: “Nejhua, tej, nemechijlia ica on yejhuan quipia miyec, más quimacasquej. Pero on yejhuan san quipia achijtzin hasta on quech quipia cuilisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Niman on notlahuelicnihuan yejhuan xquinequiyaj niinrey yes, xnechinhuajhuiquilican niman nixpan xquinmictican.” ");
INSERT INTO nguNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ijcuac Jesús otlan quiteijlia on ejemplo, otlejcoc ipan on ojtli para Jerusalén ne inyecapan on ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ijcuac oquinnisihuij on pueblos intoca Betfagé niman Betania, yejhuan onoquej nisiu itech on tepetl itoca Olivos, oquintitlan omemej inomachtijcahuan, ");
INSERT INTO nguNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","niman ijquin oquimijlij: ―Xhuiyan ipan on pueblito yejhuan oncaj ne tlayecapan. Ne campa nemoncalactiasquej, nenquitasquej salijticaj se polocotzin yejhuan xqueman yacaj ipan tlejcohua. Xtojtomacan, tej, niman xnechajhuiquilican. ");
INSERT INTO nguNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Niman tla yacaj mechtlajtoltia tlica nenquitojtomaj, xquijlican ica nemoTeco quitequitiltis. ");
INSERT INTO nguNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","On nomachtijquej oyajquej ipan on pueblito niman oquinextijquej ijcon quen Jesús oquimijlij. ");
INSERT INTO nguNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ijcuac yejhuamej quitojtonticatcaj on polocotzin, on iteco oquintlajtoltij: ―¿Tlica nenquitojtomaj on polocotzin? ");
INSERT INTO nguNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","On nomachtijquej oquinanquilijquej: ―Pampa on toTeco quitequitiltis. ");
INSERT INTO nguNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Niman ocuiquilijquej Jesús on polocotzin. Quemaj oquitlalijquej intlaquen ipan on polocotzin, niman oquitlejcoltijquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chica Jesús yetiaya ipan on polocotzin, on tlacamej quisojtiayaj intlaquen ipan ojtli. ");
INSERT INTO nguNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ijcuac Jesús oajsic ne campa pehuas temos ipan on tepetl itoca Olivos, nochimej on miyequej nomachtijquej opejquej paquij, niman quiyectenehuayaj Dios ican chicahuac tlajtoli pampa nochi on tlamajhuisoltin yejhuan oquitaquej. ");
INSERT INTO nguNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","On nomachtijquej quijtohuayaj: ―¡Dios ma quitiochihua on Rey yejhuan huajlau ican itocatzin toTeco! ¡Ma onya yolsehuilistli ne ilhuicac, niman ma Dios quiseli hueyilistli! ");
INSERT INTO nguNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Quemaj sequimej fariseos yejhuan nemiyaj intzajlan on tlacamej oquijlijquej Jesús: ―Temachtijquetl, xquintlacahualti monomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero Jesús oquimijlij: ―Nejhua nemechijlia ica tla yejhuamej nocamatzacuasquej, yej in temej tzajtzisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús sa nisiu yaya itech Jerusalén, niman ijcuac ocontac on hueyican, ochocac, ");
INSERT INTO nguNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","niman oquijtoj: ―¡Tla ticajsicamatisquia ica ipan in tonajli huelisquia ticselisquia yolsehuilistli, xticselisquia icastigo Dios! Pero aman yejhua on omitziyanilijquej niman xhueli ticmati. ");
INSERT INTO nguNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mopan yejcos on xcuajli tonaltin ijcuac on motlahuelicnihuan mitzyehualtzacuasquej ican se tepanchinantli. Sa no yejhuamej mitzyehualosquej niman nochihuiyan mitzmajmasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yejhuamej, tej, hasta ixco tlajli mitzcahuasquej. Yejhuamej quinmictisquej on mopan chanejquej, niman xmitzcahuilisquej nion se tetl nepanijtias, pampa xoticmat tlen tonajli omitznotzaco Dios para mitzmacas temaquixtilistli. ");
INSERT INTO nguNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Quemaj Jesús ocalaquito ne ijtic on hueyi tiopan niman opeu quinhuajquixtia on yejhuan ompa tlanamacayaj niman tlacohuayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yejhua ijquin oquimijlij: ―Ipan on Yectlajcuilojli ijquin tlajcuilolnesticaj: “Nochan itoca yes chanyotl campa quichihuasquej oración.” Pero nemejhuamej yonencuepquej quen teostocajli campa on tlachtequej nosentlaliaj. ");
INSERT INTO nguNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús mojmostla temachtiaya ipan on hueyi tiopan, pero intlayecancau on tiopixquej, niman on temachtijquej ican itlanahuatil Moisés niman on tlayecanquej ipan on hueyican quitejtemohuiliayaj quen ijqui huelis quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero xquimatiyaj quen ijqui huelis quimictisquej, pampa nochi tlacatl sanoyej quinequiya caquis nochi tlinon yejhua quijtohuaya. ");
INSERT INTO nguNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Se tonajli ne ipan on hueyi tiopan, Jesús quinmachtiaya on tlacamej niman quimijliaya on temachtijli yejhan quitemaca temaquixtilistli. Intlayecancahuan on tiopixquej niman on temachtijquej ican itlanahuatil Dios san secan ihuan on tlajtlajmatquej oajsiquej itech Jesús, ");
INSERT INTO nguNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","niman oquijlijquej: ―Xtechijli ¿tlen tequihuajyotl ticpia para ticchihua yejhua in tlajtlamach? ¿Aquinon, tej, omitzmacac yejhua on tequihuajyotl? ");
INSERT INTO nguNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Niman Jesús oquimijlij: ―Nejhua no nicpia tlen nemechtlajtoltis. ");
INSERT INTO nguNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Xnechijlican, ¿aquinon ocuajtitlan Juan para ma tlacuatequi? ¿Dios ocuajtitlan, noso on tlacamej ocuajtitlanquej? ");
INSERT INTO nguNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Quemaj yejhuamej opejquej ijquin quinochtacatlajtlajtoltiayaj: ―¿Quen ijqui tiquijlisquej? Tla tiquijtosquej ica Dios ocuajtitlan, yejhua ijquin techijlis: “Tla ijcon, ¿tlica, xonenquineltocaquej on tlen Juan oquijtoj nocanejhua?” ");
INSERT INTO nguNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Niman tla tiquijtosquej ica on tlacamej ocuajtitlanquej, nochimej in tlacamej techmictisquej ican temej, pampa yejhuamej xometlamatij ica Juan itiotlajtojcau Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yejhua ica, tej, yejhuamej oquijlijquej Jesús ica xquimatij aquinon ocuajtitlan Juan para ma tlacuatequi. ");
INSERT INTO nguNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Niman Jesús oquimijlij: ―Yejhua ica nejhua no xnemechijlis aquinon onechmacac tequihuajyotl para nicchihua yejhua in tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Quemaj Jesús opeu quinnojnotza on tlacamej niman oquintlalilij yejhua in ejemplo: ―Sen tlalejquetl oquitocac miyec uvas, niman ijcuac yoquitocac oquintlanejtij sequimej medieros para quitlapilisquej ican on uvas. Niman on tlalejquetl onejcuanij niman oyaj ipan ocse país para miyec tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ijcuac oyejcoc on tonaltin para quitequisquej on uvas, on tlalejquetl yejhuan oquitocac on uvas oquititlan itequichihuilijcau para ma quintlajtlaniliti on medieros on quech yejhua quitocarohua quiselis. Pero yejhuamej oquimajmailijquej on tequichihuilijquetl niman ocotitlanquej. Xitlaj oquimacaquej. ");
INSERT INTO nguNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Quemaj on tlalejquetl oquititlan ocse itequichihuilijcau, pero yejhua on tequichihuilijquetl no oquitlahuelixnamiquej niman oquimajmailijquej, niman oquititlanquej. Xitlaj oquimacaquej. ");
INSERT INTO nguNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Quemaj on tlalejquetl oquititlan on ica yeyi itequichihuilijcau, pero on medieros ipan on uvasyoj no ocojcocojquej niman ocuajquixtijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Quemaj iteco on tlatoctli ijquin oquinemilij: “¿Quen ijqui nicchihuas? ¡Ah, aman nicmati! Nictitlanis notlajsojcaconeu. Cas ijcuac quitasquej quitlacaitasquej.” ");
INSERT INTO nguNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ijcuac on medieros oquitaquej on teconeu, oquinojlijquej: “Yejhua in iconeu on tlalejquetl. Ijcuac miquis itataj, yejhua yes iyaxca nochi in tlajli. Aman, tej, ma ticmictican iconeu para tejhuamej toyaxca yes.” ");
INSERT INTO nguNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yejhuamej, tej, ocuajquixtijquej on teconeu ne ipan on uvasyoj, niman oquimictijquej. Quemaj Jesús oquintlajtoltij: ―Aman, tej, iteco on uvasyo, ¿tlinon quinchihuilis on xcuajcualtin medieros? ");
INSERT INTO nguNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yejhua, tej, yas niman quinhuajmictis on medieros niman on tlatoctli ocsequimej quinmacasquej para cuidarosquej. Ijcuac on tlacamej ijcon ocacquej on ejemplo, oquimatquej ica on iteco on uvasyo quijtosnequi Dios, niman on xcuajcualtin tequitquej quijtosnequi sa no yejhuamej. Yejhua ica oquijtojquej: ―¡Xnejli! Dios xquichihuas. ");
INSERT INTO nguNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Jesús oquimixtlaloj, niman oquimijlij: ―Tla xijqui tej, ¿tlinon quijtosnequi yejhua in Yectlajcuilojli? Ijquin tlajcuilolnesticaj: On tetl yejhuan xoquiselijquej on tepanchijquej aman yejhua yacatztica. ");
INSERT INTO nguNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","San aquinon ipan huetzis on tetl, tepojpostequis, niman tla on tetl yacaj ipan huetzis, quicuejcuechtilis. ");
INSERT INTO nguNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nimantzin on intlayecancahuan on tiopixquej niman on temachtijquej ican tlanahuatijli oquejecojquej ocajsiquej Jesús para contzacuasquej, pampa quimatzticatca ica on ejemplo oquintenehuilij yejhuamej. Pero xocajsiquej, pampa quinmacajsiyaj on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yejhuamej, tej, oquintitlanquej on yejhuan notenehuaj cuajcualtin tlacamej para oquipijpiatoj Jesús. Yejhuamej oquichihualtijquej itlaj ma quijto yejhuan huelis ica quitemactilisquej itech on gobernador. ");
INSERT INTO nguNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yejhua ica ijquin oquitlajtoltijquej: ―Temachtijquetl, ticmatztoquej ica on tlen tiquijtohua niman tictemachtia yejhua tlen melahuac. Niman no ticmatztoquej ica xqueman titechicoita intech tlacamej, yej on tlacamej cuajli tiquintitia quen Dios quinequi para nohuicasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aman xtechijli: ¿Itlanahuatil Moisés techcahuilia tontlatlaxtlahuasquej ican impuestos itech César yejhuan itequihuaj on país Roma? ");
INSERT INTO nguNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero Jesús oquimat ica yejhuamej ican xcuajli inyojlo ijcon quitlajtoltiayaj san para cajcayahuasquej. Yejhua ica ijquin oquimijlij: ―¿Tlica nennechnequiliaj para ma niquijto itlaj yejhuan ica huelis nennechteixpanhuisquej? ");
INSERT INTO nguNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Se xnechititican on tomin. ¿Aquinon iyaxca yejhua in, niman aquinon itocayo nican tlajcuilolnesticaj ipan in tomin? Yejhuamej oquijlijquej: ―On tlanahuatijquetl César yejhuan itequihua nochi on país itoca Roma. ");
INSERT INTO nguNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Quemaj Jesús oquimijlij: ―Tla ijcon, tej, xmacacan César on tlen yejhua iyaxca, niman xmacacan Dios on tlen yejhua iyaxca. ");
INSERT INTO nguNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yejhuamej, tej, xohuelquej ocajcayajquej ica on tlen imixpan on tlacamej quijtohuaya. Yej, yejhuamej otlamojcaitaquej, pampa Jesús ijcon oquinnanquilij niman xoc onahuatquej. ");
INSERT INTO nguNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Oquitatoj Jesús sequimej saduceos yejhuan quijtohuaj ica xhuelis yolihuisquej niman noquetztehuasquej on mimiquej. Yejhuamej ijquin oquijlijquej Jesús: ");
INSERT INTO nguNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Temachtijquetl, ipan itlanahuatil Moisés ijquin oquijcuiloj para tejhuamej. Tla se tlacatl miqui niman xican iconehuan cajtehua on sihuatl, icniu on tlacatl ica oncaj nonamictis ihuan on sihuacahuajli, niman ihuan tlascaltis para on coconej nemisquej quen iconehuan yesquia on icniu yejhuan omic. ");
INSERT INTO nguNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aman, tej, nemiyaj chicomemej icniutin yejhuan tlacamej. On yejhuan yencuiyotl ononamictij, niman quemaj omic, pero on sihuatl xoquitlascaltililij. ");
INSERT INTO nguNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Quemaj on ica ome teicniu ononamictij ihuan on sihuacahuajli, niman quemaj no omic in teicniu, niman on sihuatl xoquitlascaltililij. ");
INSERT INTO nguNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Quemaj quej on ica yeyi teicniu ononamictij ihuan on sihuacahuajli, niman hasta ijqui oquijsatoj nochimej on icniutin. Nochimej, tej, omiquej, niman nion se xoquitlascaltililij on sihuatl. ");
INSERT INTO nguNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Quemaj on sihuatl no omic. ");
INSERT INTO nguNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ijcuac yolihuilos, ¿catlejhua itech tesihuau yes de yejhuamej on chicomemej icniutin, pampa nochimej oquipixquej quen insihuau? ");
INSERT INTO nguNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Quemaj Jesús oquimijlij: ―Chica nemij ipan in tlalticpactli, on tlacamej niman on sihuamej nonamictiaj niman on tatajtin quintemacasquej imichpochhuan para ma nonamictican. ");
INSERT INTO nguNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero ijcuac yolihuisquej niman noquetztehuasquej intzajlan on mimiquej, on yejhuan Dios quincahuilis ajsisquej ne ilhuicac, xoc nonamictisquej nion on tatajtin quintemacasquej inconehuan para ma nonamictican. ");
INSERT INTO nguNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Xnonamictisquej pampa ompa xoc miquisquej. Yejhuamej, tej, quen on ilhuicactequitquej. Niman pampa yolihuij niman noquetztehuaj intzajlan on mimiquej, yejhuamej teconehuan itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hasta Moisés otechmachiltij ica on mimiquej yolihuij niman noquetztehuaj. Ijcuac on tlacotepajsojli tlicuiticatca, toTeco Dios ompa oquijlij Moisés ica yejhua iDios Abraham, Isaac niman Jacob. ");
INSERT INTO nguNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ticmatij ica Dios xejhua inDios on mimiquej, yej yejhua inDios on yoltoquej, pampa para yejhua melahuac nochimej quipiaj nemilistli. ");
INSERT INTO nguNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Quemaj sequimej temachtijquej ican on tlanahuatijli oquijlijquej Jesús: ―Temachtijquetl, cuajli on tlen otiquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Niman on saduceos xoc oquinemilijquej itlaj más quitlajtoltisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Quemaj Jesús oquimijlij: ―¿Tlica nijtohua ica Cristo yejhuan Dios oquitlapejpenij para temaquixtis yejhua huejca teixhuiu itech David? ");
INSERT INTO nguNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tej, ipan on Salmos tlajcuilolnesticaj ica sa no David ijquin quijtohua: Dios oquijlij noTeco: “Xmotlali nican ipan noyecma, ");
INSERT INTO nguNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta caman ma nimitztlali tlayecanquetl intech on yejhuan motlahuelicnihuan.” ");
INSERT INTO nguNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tla David ijcon oquijtoj ica Cristo yejhua iTeco, tla ijcon, tej, ¿Quen ijqui Cristo hueli huejca teixhuiu itech David? ");
INSERT INTO nguNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nochi tlacatl tlacacticatca ijcuac Jesús ijquin oquimijlij inomachtijcahuan: ");
INSERT INTO nguNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Xmotacan sa no nemejhuamej intech on temachtijquej ican tlanahuatijli yejhuan cuelitaj tlaquenhuejhueyacquistinemij, niman quinequij ican miyec tetlacaitalistli ma quintlajpalocan neca ipan plaza, niman quinequij on más cuajli sietas ne ipan on tiopantin, niman ipan on ilhuimej quinequij nosehuisquej ipan on más huejhueyixtoquej sietas. ");
INSERT INTO nguNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yejhuamej, tej, no quinchancuiliaj on sihuacahualtzitzintin, niman sanoyej huejhueyac oraciones quijtohuaj imixpan on tlacamej para on tlacamej ma cuajli tlanemilican intech. Yejhuamej, tej, más hueyi castigo quiselisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ijtic on hueyi tiopan Jesús ocomintac on ricos quitlaliayaj tomin ijtic on caja campa nosentlalia on huentomin. ");
INSERT INTO nguNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","No ijqui oquitac se mayanqui sihuacahualtzintli yejhuan ocontlalij san ome cobre tomin ijtic on caja. ");
INSERT INTO nguNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Niman yejhua oquijtoj: ―Ica tlen melahuac nemechijlia ica yejhua in mayanqui sihuacahualtzintli más hueyi oquitlalij ihuentomin xquen nochimej ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nochimej on ocsequimej, tej, oquitlalijquej inhuentomin yejhuan yoquinsobraroj, pero in sihuatl, masqui mayanqui, oquitemacac nochi tlen quipiaya para notequipanos. ");
INSERT INTO nguNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ijcuac sequimej inomachtijcahuan tlajtlajtojticatcaj ica on hueyi tiopan niman quen tlachijchiutli ican cualtetzitzintin temej niman yejhua ica on cualtetzitzintin tlajtlamach yejhuan ompa onotetlayocolijca quen ofrendas, Jesús oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Yejcos on tonajli ijcuac nochi on tlen amantzin nenquitztoquej xoxotonis, niman nion se tetl xnocahuas ipan ocse tetl. ");
INSERT INTO nguNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Quemaj oquitlajtoltijquej: ―Temachtijquetl, ¿quemanon nochihuas? ¿Tlen tlamajhuisojli noteititis ijcuac in tlajtlamach ye pehuas nochihuas? ");
INSERT INTO nguNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús oquijtoj: ―Xmotacan sa no nemejhuamej, niman ma ca nenquimocahuilisquej mechcajcayahuasquej, pampa huajlasquej miyequej yejhuan ican noTocatzin cualijtojtiasquej: “Nejhua niCristo”, niman “Aman yoyejcoc on tonajli.” Pero nemejhuamej ma ca xhuiyan inhuan. ");
INSERT INTO nguNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Niman ijcuac nencaquisquej ica oncaj guerras niman revoluciones, ma ca nemomojtisquej. Tej, nochi yejhua on ica oncaj achtopa nochihuas. Pero ijcuac ijcon nochihuas, oc xejhua tonajli para ipan in tlalticpactli tlatlajtlamis nimantzin. ");
INSERT INTO nguNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús ocsejpa más oquijtoj: ―On tequihuajquej nohuijsoquisquej ihuan ocsequimej tequihuajquej, niman on países nomijmictisquej ihuan ocsequimej países. ");
INSERT INTO nguNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Temojtij tlalolinis ipan miyecan, niman onyas apistli niman miyec cualolistli. Niman ne ipan cielo miyec tlajtlamach temojtij nesis, niman huejhueyi tlamajhuisoltin. ");
INSERT INTO nguNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero ijcuac xe nochihua nochi yejhua in, mechajsisquej, niman mechtlahuelitasquej niman tlajtlamach ica mechtlajyohuiltisquej niman mechtlajtlacolmacasquej ne impan on tiopantin. No ijqui mechtzajtzacuasquej, niman imixpan on reyes niman gobernadores mechhuicasquej. Nochi yejhua in nochihuas san nopampa. ");
INSERT INTO nguNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ijcuac ijcon nemopan nochihuas, huelis noca nentenojnotzasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Xmoyolchicahuacan, tej, para ma ca sa nencomatztiasquej tlen tlajtojli nenquijtosquej para nemomanahuisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ijcon xmoyolchicahuacan, pampa on tlen tlajtojli niman tlamatquilistli mechpolos, nejhua nemechmacas yejhuan nion se nemotlahuelicniu xhuelis quixicos nion xhuelis quixnamiquis. ");
INSERT INTO nguNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nemejhuamej hasta nemotajhuan, nemocnihuan, on yejhuan sa huejca nemochanecahuan niman nemotetlajsojcahuan sa no yejhuamej mechtemajcasquej. Niman sequimej nemejhuamej mechchihuilisquej para mechmictisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Niman san pampa nennechneltocaj, nochi tlacatl mechtlahuelitas. ");
INSERT INTO nguNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero nion se nemotzon xpolihuis. ");
INSERT INTO nguNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Niman tla nemelajcanemij ican nemotlaneltoc, ajsis on tonajli ijcuac nenquiselisquej on nemilistli yejhuan para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ijcuac nenquitasquej ica miyec soldados yoquiyehualoj on Jerusalén, ijcuacon xmatican ica saniman xoxotonis. ");
INSERT INTO nguNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ijcuacon on yejhuan nemisquej ne Judea ma ontlatlacsacan neca ipan tepemej. Niman on yejhuan nemisquej ne Jerusalén ma quisacan ompa, niman on yejhuan ipan tepetl nemisquej ma ca ma calaquican ocsejpa ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ijcon xchihuacan, pampa ipan on tonaltin onyas castigo. Ijcuacon, tej, tenquisas nochi tlen tlajcuilolnesticaj ipan in Yectlajcuilojli. ");
INSERT INTO nguNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lástima para on sihuamej yejhuan ipan on tonaltin yocanquej inconetzin niman on sihuamej yejhuan ipan on tonaltin tlachichitisquej, pampa ipan on tonaltin miyec cocolistli onyas ipan in país niman se temojtij castigo quipiasquej on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sequimej miquisquej ipan guerra, niman ocsequimej quintzacuasquej nochihuiyan países. Niman on yejhuan xhebreos quichojcholosquej on hueyican Jerusalén hasta tlamis on tonaltin quech quincahuilisquej ijqui quichihuasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Quemaj onyas tlamajhuisojli ipan on tonaltzintli, ipan on metztli, niman impan on sitlalimej. Niman nican ipan in tlalticpactli on tlacamej yejhuan chantij ipan on países xquimatisquej tlinon quichihuasquej niman sanoyej nomojtisquej, pampa sanoyej temojtij caquistis on mar niman quen noquetztehuas on mar. ");
INSERT INTO nguNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chica nochi tlacatl quitasquej on tlen nochihuas ipan in tlalticpactli, yolpopolihuisquej ican innemojtil, pampa nochi quech cojtiticaj ne ipan cielo nolinis. ");
INSERT INTO nguNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Quemaj nechitasquej, nejhua yejhuan oninochiu Tlacatl, nihuajlas ipan se moxtli ican nohueyi poder niman ican nohueyilis. ");
INSERT INTO nguNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ijcuac pehuas nochihuas in tlajtlamach, xmoyolehuacan niman sa xonajcotlachixtiacan, pampa saniman mechmaquixtisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Quemaj Jesús oquintlalilij yejhua in ejemplo: ―Xquitacan on cojtlaquilyotl itoca higuera niman no ocsequi cojtlaquilyotl. ");
INSERT INTO nguNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ijcuac nenquitaj selia on cojtli, sa no nemejhuamej nenquimatij ica ye nisiu xompantla yes. ");
INSERT INTO nguNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sa no ijqui, tej, ijcuac nenquitasquej ye nochijticaj on tlamahuijsoltin yejhuan yonemechijlij, xmatican ica ye nisiu para Dios quinmandaros nochi tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ica tlen melahuac nemechijlia ica nochi in tlamahuijsoltin nochihuas ijcuac xe miquij on tlacamej yejhuan nemij ipan in tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","On cielo niman in tlalticpactli popolihuis, pero notlajtol xqueman popolihuis. ");
INSERT INTO nguNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Xmotacan sa no nemejhuamej. Ma ca xmoyoltechicahuacan ica on tlen xcuajli, nion ma ca xtlahuantinemican, nion itlaj xcomatztiacan on tlen ica nemotequipanosquej para ma ca huajlas on tonajli ijcuac xnencomatztoquej ica huajlas. ");
INSERT INTO nguNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ijcon quen se tlatlalilistli cajsi se yolqui ijcuac on yolqui quinemilia ica cuajli nemi, no yejcos on temojtij tonajli ipan nochi quech tlacatl yejhuan chanti ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nemejhuamej, tej, xnemican listos. Niman nochipa xchijtiacan oración para ijqui huelis nemomanahuisquej ipan nochi on tlajyohuilistli yejhuan nochihuas, niman para huelis nemomanasquej nixpan nejhua yejhuan oninochiu Tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mojmostla Jesús temachtiaya ne ipan on hueyi tiopan, niman ica tlayohua yaya ne ipan on tepetl itoca Olivos. ");
INSERT INTO nguNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Niman mojmostla saniman cualcan nochi tlacatl yaya ne hueyi tiopan para concacquiya Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ye nisiu catca para onyas on ilhuitl yejhuan nochihua ijcuac nocua on pan yejhuan xquipia tlaxocolilistli. On ilhuitl itoca pascua. ");
INSERT INTO nguNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Niman intlayecancahuan on tiopixquej niman on temachtijquej ican tlanahuatijli ichtaca quitejtemohuiliayaj quen ijqui quimictisquej Jesús, pampa quinmacajsiyaj on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Quemaj Satanás ijtic ocalac Judas. Judas no itoca Iscariote, niman yejhua inhuan on majtlactli huan ome nomachtijquej tlapohuajli catca. ");
INSERT INTO nguNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yejhua, tej, oyaj oquintato on intlayecancahuan on tiopixquej niman on yejhuan tlayecanquej ipan on hueyi tiopan para oquintlajtlajtohuilito ica quen ijqui huelis quinmactilis Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yejhuamej, tej, opacquej, niman onotlajtolmacaquej para Judas quimacasquej tomin. ");
INSERT INTO nguNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas oquitlalij iyojlo san secan inhuan, niman opeu quitejtemohua quemanon cuajli para quitemactilis Jesús ijcuac on tlacamej xnemisquej itech. ");
INSERT INTO nguNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oyejcoc on tonajli para onyas on ilhuitl yejhuan nochihua ijcuac nocua on pan yejhuan xquipia tlaxocolilistli. Niman ipan on tonajli ica oncaj quihuentlaliaj on borreguito para quicuaj ipan on ilhuitl pascua. ");
INSERT INTO nguNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Niman Jesús oquintitlan Pedro niman Juan ica in tlanahuatijli: “Xhuiyan. Xchijchihuatij on tlacuajli para ticuasquej ipan on ilhuitl pascua.” ");
INSERT INTO nguNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yejhuamej oquijlijquej: ―¿Canon ticnequi ma ticchijchihuatij? ");
INSERT INTO nguNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús oquimijlij: ―Ijcuac nemejhuamej nencalaquisquej ipan on hueyican, nenquinamiquisquej se tlacatl yejhuan quitqui se tzotzocojli ican atl. Xcuitlapanhuican, tej, hasta ne campa oncalaquis, ");
INSERT INTO nguNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","niman iteco on cajli ijquin xquijlican: “On Temachtijquetl oquijtoj: ¿Canon oncaj on calijtic campa niconcuas on tiotlac tlacuajli ipan on ilhuitl pascua inhuan on nonomachtijcahuan?” ");
INSERT INTO nguNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Niman yejhua mechititis se hueyi calijtic ne tlapani campa ye tlaojoncaj. Ompa, tej, xchijchihuacan on tlacuajli. ");
INSERT INTO nguNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yejhuamej, tej, oyajquej niman ijqui oquinextijquej quen Jesús oquimijlij. Ompa, tej, oquichijchijquej on tlacuajli para tlacuasquej ipan on ilhuitl pascua. ");
INSERT INTO nguNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Niman ijcuac oajsic hora para tlacuasquej, Jesús onosehuij itech on mesa inhuan inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Quemaj Jesús oquimijlij: ―¡Sanoyej nicnequiya nemohuan nicuas in tlacuajli ijcuac xe nitlajyohuia! ");
INSERT INTO nguNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pampa aman nemechijlia ica xoc ocsejpa nemohuan nicuas hasta on tonajli ijcuac tenquisas on tlen in tlacuajli quijtosnequi ne campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Quemaj ocontilan se copa yejhuan quipia iyayo on uvas, niman ijcuac yoquimacac tlaxtlahuijli Dios, ijquin oquijtoj: ―Xconican yejhua in niman xmopanoltilijtiacan. ");
INSERT INTO nguNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nejhua, tej, nemechijlia ica xoc nemohuan niconis iyayo in uvas hasta ijcuac Dios pehuas tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Quemaj ocontilan on pan, niman ijcuac yoquimacac tlaxtlahuijli Dios, oquitlatlapan niman oquinmacac. Quemaj ijquin oquimijlij: ―In pan quixnescayotia notlalnacayo yejhuan nohuentlalis nemopampa. In xcuacan para ica xnechelnamiquican. ");
INSERT INTO nguNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ijcuac yocuajquej on tlacuajli, no ijqui oquinmacac on copa niman oquijtoj: ―Yejhua in tlen aman nenconisquej ica in copa quixnescayotia on yencuic pacto yejhuan notzimpehualtis ica noyesyo, niman san nemopampa toyahuis. ");
INSERT INTO nguNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Xquitacan, aman on tlacatl yejhuan nechtemactilis, nohuan nemi ipan in mesa. ");
INSERT INTO nguNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ijcon, tej, nejhua yejhuan oninochiu Tlacatl nimiquis quen Dios otlanahuatij, pero ¡lástima para on tlacatl yejhuan nechtemactilis! ");
INSERT INTO nguNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Quemaj yejhuamej opejquej quinotlajtoltiaj aquinon on quitemactilis. ");
INSERT INTO nguNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Quemaj yejhuamej opeu notencuicuij ica on aquinon más hueyixtias. ");
INSERT INTO nguNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesús oquimijlij: ―On reyes yejhuan xhebreos nochihuaj quen inteco on países. Niman on tlacamej quintenehuiliaj cuajcualtin tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero nemejhuamej xmechtocarohua ijcon nemohuicasquej. Yej ocse tlamantic. Yejhuan nemotzajlan más hueyixticaj nonequi nohuicas quen xhueyixticaj, niman yejhuan tlamandarohua nonequi nohuicas quen on yejhuan tepalehuijquetl. ");
INSERT INTO nguNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Aquinon, tej, más hueyixticaj, on tlayecanquetl yejhuan tlacua ipan mesa, noso on tetlamacajquetl? Niquijtohua ica on tlayecanquetl yejhuan tlacua. Pero nejhua, masqui nimotlayecancau, ninemi nemotzajlan quen se yejhuan tetlamaca. ");
INSERT INTO nguNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Nemejhuamej, tej, nochipa nohuan yonentlajyohuijtinenquej. ");
INSERT INTO nguNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yejhua ica, tej, nejhua nemechmaca se tequihuajyotl quen noTajtzin onechmacac. ");
INSERT INTO nguNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nenmatlisquej niman nentlacuasquej ipan nomesa. Niman nemotlalisquej ipan on huejhueyixtoquej sietas para nenquinyolcuitisquej niman nenquintlajtlacolmacasquej on majtlactli huan ome chanchanejquej itech Israel. ");
INSERT INTO nguNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","No ijqui oquijtoj toTeco: ―Simón, Simón, xcaqui. Nemoca yotlajtlan Satanás para mechtzejtzelos quen itlaj trigo, ");
INSERT INTO nguNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","pero nejhua moca yonictlajtlan itech Dios para ma ca ticpolos motlaneltoc. Niman ijcuac tejhua yotimoyolcuep, xquimpalehui mocnihuan para ma melajcanemican. ");
INSERT INTO nguNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón oquijlij: ―NoTeco, nejhua ninemi listo para mohuan nechtzacuasquej niman hasta para mohuan nimiquis. ");
INSERT INTO nguNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Niman Jesús oquijlij: ―Pedro, nejhua nimitzijlia ica sa no aman ijcuac xe tzajtzi on caxtil, tejhua tiquijtos yexpa ica xtinechixmati. ");
INSERT INTO nguNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Quemaj Jesús oquimijlij: ―Ijcuac onemechtitlan niman onemechijlij ma ca xquitquican itlaj bolsa, nion tomin, nion cactin, ¿itlaj omechpoloj? Yejhuamej oquijtojquej: ―Xitlaj otechpoloj. ");
INSERT INTO nguNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","―Pero aman tla ticpia mobolsa niman motomin, xquitqui, niman tla xticpia moespada xnamaca motlaquen para xcohua moespada. ");
INSERT INTO nguNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pampa nejhua nemechijlia ica on tlen noca tlajcuilolnesticaj ipan on Yectlajcuilojli ica oncaj nochihuas. On Yectlajcuilojli ijquin quijtohua: “Inhuan xcuajcualtin tlacamej oquipojquej.” Nochi, tej, tlen noca tlajcuilolnesticaj tenquisas. ");
INSERT INTO nguNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ijcuacon yejhuamej oquijtojquej: ―Xquita toTeco, nican oncaj ome espadas. Yejhua oquimijlij: ―¡Ah, xnencajsicamatij tlinon niquijtosnequi! Ma ijqui. ");
INSERT INTO nguNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Quemaj Jesús oquis, niman oyaj ipan on tepetl itoca Olivos inhuan on inomachtijcahuan quen miyecpa oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ijcuac oajsic, oquimijlij on inomachtijcahuan: ―Xchihuacan oración para ma ca on Satanás mechtlajcalis ipan tlajtlacojli. ");
INSERT INTO nguNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Quemaj Jesús oquintlalcahuij huejca quen se ica mahuejca ijcuac tlamotla ican tetl, niman onotlacuenquetz niman onohueyicatzajtzilij. ");
INSERT INTO nguNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Niman oquijtoj: ―NoTajtzin, tla ticnequi, xnechmanahui para ma ca niquijyohuis in tlen sanoyej teajman. Pero ma ca nochihua quen nejhua nicnequi, yej ma nochihua quen tejhua ticnequi. ");
INSERT INTO nguNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Quemaj se ilhuicactequitquetl yejhuan ne ilhuicac ohualeu, oquinotitij niman oquimacac yolchicahualistli. ");
INSERT INTO nguNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Niman pampa yejhua sanoyej noyolcocojticatca, ican más yolchicahualistli onohueyicatzajtzilij. Yejhua, tej, nitoniaya, niman itonil catca quen yestli huejhueyi yejhuan chipinticatca ipan tlajli. ");
INSERT INTO nguNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ijcuac otlan onohueyicatzajtzilij, ohuajnotelquetz, niman oyaj ne intech on inomachtijcahuan. Ijcuac intech oajsic, oquintac cochtoquej, pampa yoquinsiahuitij inajman. ");
INSERT INTO nguNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Quemaj oquimijlij: ―¿Tlica nencochtoquej? Xmotelquetzacan, niman xchihuacan oración para xmechtlatlatas on diablo. ");
INSERT INTO nguNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús oc tlajtojticatca, ijcuac miyec tlacatl itech oajsic. Niman Judas yejhuan inhuan on nomachtijquej tlapohuajli catca, huajlaya tlayecapan, niman oquinisihuij Jesús para oquitencuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Niman Jesús oquijlij: ―Judas ¿ijcon tinechtencua para tinechtemactilia nejhua yejhuan oninochiu Tlacatl? ");
INSERT INTO nguNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ijcuac inomachtijcahuan Jesús yejhuan ihuan ompa nemiyaj oquitaquej tlen ye nochijticaj, oquijlijquej: ―ToTeco, ¿ma titeixnamiquican ican espada? ");
INSERT INTO nguNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Niman semej yejhuamej oquinacastzontec se tlacatl itlaquehual on más hueyi intlayecancau on tiopixquej. Oquitequilij inacas ipan iyecmacopa. ");
INSERT INTO nguNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jesús oquijtoj: ―Xmoteltican. Ma ijqui. Quemaj Jesús oquimatoquilij inacas on tlaquehuajli niman oquipajtij. ");
INSERT INTO nguNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Quemaj ijquin oquimijlij intlayecancahuan on tiopixquej, niman on tlayecanquej ipan on hueyi tiopan niman on tlajtlajmatquej yejhuan ohualejquej ocanacoj: ―¿Onennechajsicoj ican espadas niman cojtin quen yacaj nitlachtequetl yesquia? ");
INSERT INTO nguNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mojmostla nemohuan ninemiya ne ipan ihueyi tiopan Dios, niman xonennechajsiquej, pero ipan in hora Dios mechcahuilia nenquichihuaj on tlen nenquinequij. Aman ipoder Satanás tetlani. ");
INSERT INTO nguNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Quemaj ocajsiquej Jesús, niman ocuicaquej ne ichan on más hueyi intlayecancau on tiopixquej. Niman Pedro san huejca cuitlapanhuijtiaya. ");
INSERT INTO nguNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ompa itlajcotian on quiahuac otlatlatijquej, niman iyehualican on tlitl onotlajtlalijquej, niman Pedro no ompa intzajlan onotlalij. ");
INSERT INTO nguNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Quemaj ijcuac se sihuatl tetequichihuilijquetl oquitac Pedro yehuaticaj itech on tlitl, oquixquechij niman oquijtoj: ―Yejhua in tlacatl no ompa ihuan nemiya. ");
INSERT INTO nguNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro oquinenec ican in tlajtojli: ―Sihuatl, nejhua xniquixmati. ");
INSERT INTO nguNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Achijtzin más saquin, quej ocse oquitac Pedro niman oquijlij: ―Tejhua no inhuan tiquistinemiya. Pero Pedro oquijtoj: ―Ca, tlacatl, xnejhua. ");
INSERT INTO nguNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Canaj ipan se hora saquin, quej ocse oquimelajcaijtoj: ―In tlacatl melahuac ihuan quistinemiya, pampa yejhua no hualehua Galilea. ");
INSERT INTO nguNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ijcuacon Pedro oquijtoj: ―Tlacatl, xnicmati tlinon on tiquijtojticaj. Quemaj nimantzin ijcuac Pedro oc tlajtojticatca, otzajtzic on caxtil. ");
INSERT INTO nguNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Quemaj toTeco onomalacachoj niman ocontac Pedro. Ijcuacon Pedro oquelnamic on tlen yejhua yoquijlijca: “Sa no aman ijcuac xe tzajtzi on caxtil tejhua tiquijtos yexpa ica xtinechixmati.” ");
INSERT INTO nguNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Quemaj Pedro oquis ompa niman sanoyej oajmancachocac. ");
INSERT INTO nguNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","On tlacamej yejhuan ipan inmahuan nemiya Jesús ica ohuetzcaquej niman oquihuijhuitequej. ");
INSERT INTO nguNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Oquixtlapachojquej niman oquixayacahuijhuitequej, niman ijquin oquijlijquej: ―Xtlajto tiotlajtojquetl. Xtechijli aquinon omitzhuitec. ");
INSERT INTO nguNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Niman miyec ocsequi tlamach quijliayaj para oquipijpinahuijquej. ");
INSERT INTO nguNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ijcuac ohuajtlanes, intlajtlajmatcahuan on tlayecanquej hebreos, niman intlayecancahuan on tiopixquej niman on temachtijquej ican tlanahuatijli onosentlalijquej niman ocuicaquej Jesús imixpan on tetlacanonotzquej. Ompa ijquin oquitlajtoltijquej Jesús: ");
INSERT INTO nguNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Xtechijli tla tejhua tiCristo. Yejhua oquimijlij: ―Tla nemechijlis ica niCristo, xnennechneltocasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Niman tla itlaj nemechtlajtoltis xnennechnanquilisquej nion xnennechmacahuasquej. ");
INSERT INTO nguNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero desde aman pehua nejhua yejhuan oninochiu Tlacatl niyehuatias iyecmacopa on Dios yejhuan nochi hueli. ");
INSERT INTO nguNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Quemaj nochimej oquijlijquej: ―¿Tla ijcon tejhua titeConeu itech Dios? Jesús oquimijlij: ―Quemaj. Ijqui quen nemejhuamej nenquijtohuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Quemaj yejhuamej oquijtojquej: ―Xpolihui más tlateixpanhuijquej. Sa no tejhuamej yoticaquej tlen quijtohua. ");
INSERT INTO nguNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Quemaj nochimej ohuajnotelquetzquej niman ocuicaquej Jesús ixpan Pilato. ");
INSERT INTO nguNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ompa ijquin opeu quiteixpanhuiyaj Jesús, niman oquijtojquej: ―Yejhua in tlacatl oticaquej quimajcomantinemi in tochantlacaj. Quimijlia ica xquitocarohua ontlatlaxtlahuasquej ica on impuestos ne itech César itequihuaj on país de Roma. Niman no notenehua yejhua Cristo, se rey. ");
INSERT INTO nguNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Niman Pilato oquitlajtoltij: ―¿Tejhua tiinRey on hebreos? Jesús oquinanquilij: ―Ijqui quen tejhua tiquijtohua. ");
INSERT INTO nguNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Quemaj Pilato oquimijlij on intlayecancahuan on tiopixquej inhuan on tlacamej: ―Xitlaj nicnextilia tla itlaj xcuajli oquichiu in tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero yejhuamej más notencojtiliayaj para ipan más oquiteixpanhuijquej: ―Ican itlamachtil quimajcomantinemi nochi tlacatl chanej Judea. Ohuajpeu ne Galilea, niman aman hasta nanica yotlamico. ");
INSERT INTO nguNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ijcuac Pilato ijcon ocac, otlajtlan tla Jesús chanej ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ijcuac oquijlijquej ica melahuac yejhua chanej ne Galilea, oquititlanilij Herodes on gobernador de Galilea, yejhuan ipan on tonaltin nemiya ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ijcuac Herodes oquitac Jesús, sanoyej opac, pampa miyec tonaltin quinectinemiya quitas. Yoquimachiltijcaj yejhua ica on miyec tlajtlamach oquichiu, niman yejhua ica quinectinemiya quitas ma quichihua se milagro. ");
INSERT INTO nguNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Miyec tlajtlamach oquitlajtoltij, pero Jesús xitlaj ica oquinanquilij. ");
INSERT INTO nguNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","On intlayecancahuan on tiopixquej niman on temachtijquej ican tlanahuajtijli yejhuan ompa nemiyaj sanoyej quiteixpanhuiayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Quemaj Herodes ihuan isoldados oquipijpinahuijquej niman ica onajahuiltijquej. Quemaj oquitlaquentijquej quen se rey ican se tlaquentli patioj. Niman Herodes ocsejpa oquititlan Jesús itech Pilato. ");
INSERT INTO nguNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sa no ipan on tonajli Pilato niman Herodes onoyolsehuiquej. Achtoj yejhuamej notlahuelitayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Quemaj Pilato san secan oquinsentlalij intlayecancahuan on tiopixquej, on tequihuajquej niman on tlacamej, ");
INSERT INTO nguNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","niman ijquin oquimijlij: ―Ijcuac onennechajhuiquilijquej yejhua in tlacatl, onenquijtojquej ica yejhua quimajcomantinemi on tlacamej. Pero nemixpan yonicyolcuitij, niman nion se tlajtlacojli yejhuan ica nenquiteixpanhuiyaj xonicnextilij. ");
INSERT INTO nguNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nion Herodes xoquinextilij tlajtlacojli, pampa ocsejpa yonechajtitlanilij. Xquitacan, xitlaj oquichiu yejhuan quimelahua para yejhua miquis. ");
INSERT INTO nguNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aman nicastigaros, niman quemaj nicmacahuas. ");
INSERT INTO nguNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato ica oncatca para quinmacahuilis se tlacatl yejhuan tzacuticatca on tlacamej ipan on ilhuitl. ");
INSERT INTO nguNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero nochimej opejquej san secan ijquin otzajtziquej: ―¡Yejhua on ma ca xmacahua, yej xmacahua Barrabás! ");
INSERT INTO nguNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás ocajsiquej pampa onoquetztejca para quixtisquia on tequihuaj de Jerusalén, niman pampa otemictijca. ");
INSERT INTO nguNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ocsejpa oquinnotz on tlacamej, pampa quinequiya quimacahuas Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero yejhuamej ocsejpa más chicahuac otzajtziquej: ―¡Xmajmasohualti! ¡Xmajmasohualti! ");
INSERT INTO nguNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato ica yexpa ijquin oquimijlij: ―¿Tlica? ¿Tlinon, tej, xcuajli oquichiu? Nejhua xonicnextilij tlajtlacojli yejhuan quimelahua para miquis. Yejhua ica san nicastigaros, niman quemaj nicmacahuas. ");
INSERT INTO nguNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero yejhuamej onotencojtilijquej niman otlanahuatijquej ma quimajmasohualtican ipan cojnepanojli. San secnec, tej, sanoyej otzajtziquej inhuan intlayecancahuan on tiopixquej, niman tlen oquinequej ma nochihua, onochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato onocalactij niman otlanahuatij ijcon quen yejhuamej quinequiyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ijcon, tej, Pilato oquimacau on tlacatl yejhuan tzacuticatca pampa onoquetztejca para quixtisquia on tequihuaj de Jerusalén, niman pampa otemictijca. Oquimacau on yejhuan oquitlajtlanquej niman Jesús oquinmactilij quen yejhuamej oquinequej. ");
INSERT INTO nguNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ijcuac cuicaticatcaj Jesús para conmajmasohualtisquej ipan cojnepanojli, oquinahuatijquej se tlacatl itoca Simón yejhuan chanejquetl catca ne Cirene. Yejhua ohualeu imijla. Oquichihualtijquej ma quimama on cojnepanojli ne icuitlapan Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Miyequej tlacamej ocuitlapanhuijquej inhuan miyequej sihuamej yejhuan ipampa chocatiayaj niman najmantiayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero Jesús ohuajnocuep niman oquimijlij: ―Sihuamej de Jerusalén, ma ca nopampa xchocacan, yej sa no nemejhuamej nemopampa xchocacan niman impampa nemoconehuan. ");
INSERT INTO nguNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ijcon xchocacan pampa yejcos on tonajli ijcuac ijquin nijtos: “Dios quintiochihua on sihuamej yejhuan tetzacamej, on sihuamej yejhuan xqueman canaj inconeu niman on chichihualtin yejhuan xqueman tlachichitiaj.” ");
INSERT INTO nguNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Quemaj on tlacamej pehuas quimijlisquej on tepemej: “Topan xxinican”, niman no quimijlisquej on tepetzitzintin: “Xtechiyanacan.” ");
INSERT INTO nguNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tla nejhua yejhuan xnicpia tlajtlacojli nicselia in tlajyohuistli, tla ijcon ¿tlinon, tej, impan nochihuas on ocsequimej yejhuan quipiaj tlajtlacojli? ");
INSERT INTO nguNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","San secan ihuan Jesús no cuicayaj ome xcuajcualtin tlacamej para quinmictisquej. ");
INSERT INTO nguNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ijcuac oajsiquej ne campa itoca “Micatzontecomatl”, ompa, tej, Jesús oquimajmasohualtiquej ipan cojnepanojli, niman on omemej xcuajcualtin tlacamej no oquinmajmasohualtiquej ipan cojnepanoltin. Se nemiya iyecmacopa Jesús niman ocse ipan iopochmacopa. ");
INSERT INTO nguNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Niman ijcuac Jesús ye quimajmasohualtijticatca ipan on cojnepanojli oquijtoj: ―NoTajtzin, xquintlapojpolhui, pampa xquimatij tlen quichihuaj. Niman on soldados onotlatlanquej para oquitaquej cada se tlinon quitquis de yejhua on itlaquen Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","On tlacamej yejhuan ompa nemiyaj quitzticatcaj nochi tlen onochiu, niman on tequihuajquej ica melahuac quihuetzcayaj Jesús ica in tlajtojli: ―Yejhua oquinmaquixtij ocsequimej. Aman, tej, tla melahuac yejhua Cristo yejhuan Dios oquitlapejpenij, sa no yejhua ma nomaquixti. ");
INSERT INTO nguNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","On soldados no huetzcayaj. Oquinisihuijquej niman oconitijquej vinagre. ");
INSERT INTO nguNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Niman ijquin oquijlijquej: ―Tla tejhua tiinRey on hebreos, sa no tejhua xmomaquixti. ");
INSERT INTO nguNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Niman icuapan oncatca se tlajcuilojli, ican tlajtoltin griego, latín niman hebreo. On tlajtojli ijquin quijtohuaya: “In yejhua inRey on hebreos.” ");
INSERT INTO nguNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Semej yejhuamej on xcuajcualtin tlacamej yejhuan ompa ihuan pilcayaj, ijquin quijixcomacaya: ―Tla tiCristo, sa no tejhua xmomaquixti, niman tejhuamej no xtechmaquixti. ");
INSERT INTO nguNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero on ocse xcuajli tlacatl ocajhuatiaj itehuical, niman ijquin oquijlij: ―¿Xticmacajsi Dios, masqui sa no yejhua castigo tiquijyohuiya? ");
INSERT INTO nguNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tejhuamej techmelahua ijquin ma titlajyohuican pampa on tlen xcuajli oticchijquej, pero yejhua in tlacatl xitlaj tlajtlacojli quipia. ");
INSERT INTO nguNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Quemaj on tlacatl oquijlij Jesús: ―Jesús, xnechelnamiqui ijcuac tinemis quen Rey. ");
INSERT INTO nguNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Niman Jesús oquinanquilij: ―Ica tlen melahuac nimitzijlia ica aman nohuan tinemis ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ye canaj tlacualispan catca otlayohuatiac nochihuiyan, hasta ijqui oajsic yeyi hora ica tiotlac. ");
INSERT INTO nguNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Chica on tonajli xoc tlachaya, ne ijtic on hueyi tiopan on tlatzacuililtlaquentli ohuajtlajcotetzayan. ");
INSERT INTO nguNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Quemaj Jesús otzajtzic chicahuac: ―NoTajtzin, ipan momatzin nimitzmactilia nonemilis. Ijcuac ijcon oquijtoj, omic. ");
INSERT INTO nguNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ijcuac on capitán romano oquitac tlinon onochiu, ijquin ocueyilij Dios, niman oquijtoj: ―Ica tlen melahuac, in tlacatl yolchipahuac catca. ");
INSERT INTO nguNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Quemaj nochimej on tlacamej yejhuan ompa nemiyaj niman oquitaquej tlinon onochiu, oyajyajquej inchan niman noyelpanhuitequiyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero nochimej iteixmatcahuan Jesús, niman on sihuamej yejhuan ohuapejquej cuajhuicatiayaj de ne Galilea, san huejca conitzticatcaj on tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nemiya se cuajli tlacatl itoca catca José yejhuan nochipa onohuicac quen quitocarohua. Yejhua chanej catca ipan on pueblo itoca Arimatea ne Judea. Yejhua tlapohuajli catca itech on tequihuajyotl yejhuan más hueyixticaj ne tiopan. ");
INSERT INTO nguNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Masqui yejhua tlapohuajli catca itech on tequihuajyotl, yejhua xocuelitac on tlen oquinemilijquej on ocsequimej nion on tlen oquichijquej. Yejhua, tej, quichaya quemanon pehuas tlamandaros Dios. ");
INSERT INTO nguNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Niman yejhua oyaj itech Pilato niman oquitlajtlanilito itlalnacayo Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ijcuac yocuajtemoltij ne ipan cojnepanojli on itlalnacayo Jesús, oquitetejcuix ican se tlaquentli patioj, niman quemaj ocahuato ijtic se teostotl campa xqueman yacaj quitocayaj. ");
INSERT INTO nguNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yoajsica on tonajli ijcuac notlatlajtlalilisquej para quejehuasquej on tonajli de nesehuijli yejhuan ye nisiu catca para pehuas. ");
INSERT INTO nguNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","On sihuamej yejhuan ohuajpequej cuajhuicatiaya Jesús de ne Galilea no oyajquej ihuan José. Yejhuamej oquitatoj on tlalcontli, niman quen ijqui oquitlalijquej itlalnacayo Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Niman ijcuac onocuepquej inchan, oquicueltlaliquej on ajhuiyalistli tzacuanqui niman aceite para itlacayo Jesús. Quemaj quen tlanahuatia itlanahuatil Moisés, onosehuijquej ipan on tonajli de nesehuijli. ");
INSERT INTO nguNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ipan on achtoj tonajli ipeuyan on semana, on sihuamej sanoyej huelipan oyajquej itech on tlalcontli. Yejhuamej oquitquiquej on chahualistli ajhuiyac yejhuan oquicueltlalijquej. Niman no oquinhuicaquej ocsequimej sihuamej. ");
INSERT INTO nguNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ijcuac ompa oajsiquej, oquitaquej ica on tetl yejhuan ica tentzacuticatca on tlalcontli ye cueptoya. ");
INSERT INTO nguNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yejhuamej, tej, ocalaquitoj ijtic on tlalcontli, pero xoquinextijquej itlalnacayo Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chica yejhuamej xcajsicamatiyaj tlinon onochiu, nimantzin omemej tlacamej ican petlanqui tlaquentli ohuajnonextijquej ompa intech majmaniyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","On sihuamej sanoyej onomojtijquej hasta ixco on tlajli onopachojquej. Pero on tlacamej oquimijlijquej on sihuamej: ―¿Tlica intzajlan on mimiquej nenquitejtemohuaj on yejhuan yolticaj? ");
INSERT INTO nguNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yejhua xnican nemi. Yejhua, tej, yoyoliu niman yonoquetzteu. Xquelnamiquican tlinon omechijlij ijcuac oc nemiya nemohuan ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Omechijlij ica yejhua yejhuan onochiu Tlacatl ica oncatca ipan inmahuan on tlajtlacolejquej quitemacasquej, niman ica quimajmasohualtiquej ipan cojnepanojli, niman ipan yeyi tonajli yolihuis niman noquetztehuas ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Quemaj on sihuamej oquelnamiquej on tlen Jesús oquimijlijca. ");
INSERT INTO nguNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Niman ijcuac yohuajnocuepatoj ne itech on tlalcontli, nochi oquintlajtlajtohuilijquej on majtlactli huan se apóstoles niman nochimej on ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","On sihuamej yejhuan oquinmachiltitoj on apóstoles yejhuamej in: María yejhuan hualehua ne Magdala, Juana niman María on inan Jacobo inhuan on ocsequimej sihuamej. ");
INSERT INTO nguNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero on apóstoles san oquilocojmatquej on tlen yejhuamej oquimijlijquej niman xoquineltocaquej. ");
INSERT INTO nguNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero Pedro ohuajnotelquetz niman onotlaloj hasta ne itech on tlalcontli. Ijcuac yejhua onopachoj para ontlachix ijtic on tlalcontli, oquitac ica ocsecan onoquej on tlaquentin. Quemaj yejhua onocuep niman tlamojcaitaya ipampa on tlen onochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sa no ipan on tonajli, omemej on tlaneltocaquej yayaj ipan se pueblo itoca Emaús, yejhuan oncaj canaj majtlactli huan se kilómetros itech Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","On omemej tlajtlajtojtiayaj nochi yejhua ica on tlen yonochijca. ");
INSERT INTO nguNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chica yejhuamej tlajtlajtojtiayaj niman notencuicuitiayaj ica in tlajtlamach, sa no Jesús oquinnisihuij niman opeu inhuan nejnemi. ");
INSERT INTO nguNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Niman masqui quitayaj Jesús, tlinonon quintzacuiliaya para ma ca ma quimatican aquin yejhua. ");
INSERT INTO nguNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Quemaj Jesús oquimijlij: ―Chica nemejhuamej nennejnemij, ¿Tlinon ica nemotencuicuitihuij? ¿Tlica nemajmanaj? ");
INSERT INTO nguNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Semej yejhuamej, itoca Cleofas, oquinanquilij: ―Nochi tlacatl quimatzticaj tlinon yonochiu ipan in tonaltin ne Jerusalén. ¿Tlen san tejhua de nochi quech ompa chanti ne Jerusalén xticmati on tlen yonochiu? ");
INSERT INTO nguNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Niman Jesús oquimijlij: ―¿Tlinon, tej, onochiu? Niman yejhuamej oquijlijquej: ―On tlen onochiu itech Jesús yejhuan hualehua ne Nazaret. Yejhua tiotlajtojquetl catca niman ixpan Dios niman imixpan on tlacamej oquipix hueyi poder ica on tlen quichihuaya niman ica on tlen quijtohuaya. ");
INSERT INTO nguNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero intlayecancahuan on tiopixquej niman on tequihuajquej ipan on tiopan oquitemactilijquej para ma quitlajtlacolmacacan ipan miquilistli niman ma quimajmasohualtican ipan cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tejhuamej ticuitiayaj yejhua quimaquixtisquia in país de Israel. Niman no, aman ye quipia yeyi tonajli ica ijcon onochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Masqui no ijqui sequimej sihuamej yejhuan tohuan nopohuaj otechmojcatlachaltijquej aman. Ijcuac sa nimantzin, oyajquej ne itech on tlalcontli, ");
INSERT INTO nguNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero xoquinextijquej itlalnacayo Jesús ne ijtic on tlalcontli. Ijcuac onocuepquej, oquijtojquej yej oquitaquej sequimej ilhuicactequitquej quen intemicpan yejhuan oquimijlijquej ica Jesús nemi yolticaj. ");
INSERT INTO nguNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Quemaj sequimej totehuicalhuan oyajquej itech on tlalcontli, niman oquitaquej quen on sihuamej oquijtojquej. Pero xoquitaquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Quemaj Jesús oquimijlij: ―¡Sanoyej mechpolohua cajsicamatilistli, niman sanoyej nemohuejcahuaj para nenquineltocaj nochi on tlen oquijtojquej on tiotlajtojquej! ");
INSERT INTO nguNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Tlen xoquijtojquej on tiotlajtojquej ica Cristo ica oncaj tlajyohuis ijcuac xe quiselia hueyilistli? ");
INSERT INTO nguNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Quemaj opeu quinmelajcaijlia nochi on temachtijli campa quijtohua itech ica yejhua ipan in Yectlajcuilojli. Ohuajpeu ipan itlajcuilolhuan Moisés niman quemaj on ocsequimej tlajcuiloltin yejhuan on ocsequimej tiotlajtojquej oquijcuilojquej. ");
INSERT INTO nguNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ijcuac oajsiquej ipan on pueblo campa yayaj, ones quen Jesús nejnemiya más tlayecapan. ");
INSERT INTO nguNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero yejhuamej onotencojtilijquej para ompa inhuan ma nocahua ican in tlajtojli: ―Nican tohuan xmocahua, pampa ye tiotlactijticaj, niman ye tlayohua. Yejhua ica Jesús ompa inhuan onocau. ");
INSERT INTO nguNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Niman ijcuac ipan on mesa inhuan yehuaticatca, ocontilan on pan niman oquitiochiu. Quemaj oquitlapan niman oquinmamacac. ");
INSERT INTO nguNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Quemaj nimantzin oixtlajtlapojquej niman oquixmatquej ica yejhua Jesús, niman quemaj yejhua san ohuajnopoloj. ");
INSERT INTO nguNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Niman ijquin quinojlayaj se ihuan ocse: ―¿Tlen xmelahuac sanoyej otechpactij chica techajnojnotztiaya ipan ojtli niman techajpantlantilijtiaya on tlen itech ica yejhua tlajcuilolnesticaj ipan on Yectlajcuilojli? ");
INSERT INTO nguNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sa no ipan on hora, yejhuamej ocajsiquej inmojhui para Jerusalén campa oquinnextitoj on majtlactli huan se apóstoles niman on intehuicalhuan san secan nemiyaj. ");
INSERT INTO nguNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","On majtlactli huan se apóstoles oquijtojquej: ―Melahuac, tej, toTeco yoyoliu niman yonoquetzteu ipan itlalcon. Niman Simón yoquitac. ");
INSERT INTO nguNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Quemaj on omemej tlaneltocaquej no oquitetlajtlajtohuilijquej tlinon impan onochiu ne ipan ojtli, niman quen ijqui oquimatquej ica Jesús oquinnotz ijcuac oquitlapan on pan. ");
INSERT INTO nguNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yejhuamej oc quijitojticatcaj on quen impan onochiu, ijcuac Jesús onotelquetztajsic ne intlajcotian niman ijquin oquintlajpaloj: ―Xyolsejtiacan. ");
INSERT INTO nguNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ican innemojtil niman incuecuetlacalis, quinemiliayaj quitztoquej san yacaj itonal. ");
INSERT INTO nguNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesús oquimijlij: ―¿Tlica nemojcatlachaj? ¿Tlica nencahuiliaj on ometlamatilistli calaqui ipan nemoyojlo? ");
INSERT INTO nguNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xquitacan nomahuan niman nocxihuan, niman xmatican ica sa no nejhua. Xnechmatocacan niman xnechitacan. Tla san yacaj itonal xnacayoj nion omiyoj quen nenquitztoquej nicpia. ");
INSERT INTO nguNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ijcuac ijcon oquimijlij, oquintitij imahuan niman icxihuan. ");
INSERT INTO nguNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero oc xquineltocayaj, pampa tlamojcaitayaj niman sanoyej paquilistlamatiyaj. Yejhua ica Jesús oquimijlij: ―¿Itlaj nenquipiaj para nicuas? ");
INSERT INTO nguNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Quemaj oquimacaquej sequi michin yejhuan tlihuaqui niman se achijtzin necutli. ");
INSERT INTO nguNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yejhua oquinselilij niman imixpan oquicuaj. ");
INSERT INTO nguNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Quemaj oquimijlij: ―Ijcuac oc nemohuan ninemiya, onemechijlij ijquin: Ica oncaj tenquisas nochi on tlen noca tlajcuilolnesticaj ipan itlanahuatil Moisés niman ipan intlajcuilol on ocsequimej tiotlajtojquej niman on salmos. ");
INSERT INTO nguNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Quemaj oquincajsicamachiltij on tlen oncaj ipan on Yectlajcuilojli. ");
INSERT INTO nguNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ijquin, tej, oquimijlij: ―Ijquin tlajcuilolnesticaj, ica Cristo ica oncatca miquis, niman ipan yeyi tonajli yolihuis niman noquetztehuas ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Niman no on yejhuan notenojnotzcahuan nonequi quinmachtisquej on tlacamej para ma noyolpatlacan, niman ijcon intlajtlacolhuan quintlapojpolhuilisquej. Yejhua in temachtijli quiteijlisquej ipan países nochihuiyan, pero yejhuamej ica oncaj pehuasquej nican Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","In tlajtlamach nemejhuamej xteixpantilican. ");
INSERT INTO nguNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Niman aman xcaquican, nemopan nicuajtitlanis on Espíritu Santo yejhuan noTajtzin omechilijca ica mechmacas. Pero xmocahuacan nican Jerusalén hasta ijcuac nenquiselisquej on poder yejhuan ne tlacpac hualehuas. ");
INSERT INTO nguNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Quemaj Jesús oquinquixtij ipan on hueyican niman hasta Betania oquinhuicac. Ompa oquinhuajquetzteu imahuan niman oquintiochiu. ");
INSERT INTO nguNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chica quintiochijticatca, quintlalcahuijtiaya niman otlejcotiaj ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Quemaj yejhuamej oquiyectenejquej Jesús, niman ican pactli onocuepquej para Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Niman yejhuamej onocajquej ipan on hueyi tiopan niman quiyectenehuayaj Dios. Ma ijqui nochihua.");
INSERT INTO nguNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ijcuac nochi otzimpeu, ye nemiya iConeu Dios yejhuan Tlajtojli. Niman yejhua on yejhuan Tlajtojli ihuan Dios nemiya niman sa no yejhua Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ijcon, tej, ye nemiya ihuan Dios ijcuac nochi otzimpeu. ");
INSERT INTO nguNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dios oquitlalij nochi tlajtlamach tlen oncaj niman tlen yolticaj itechcopa yejhua on yejhuan Tlajtojli. Xijtlaj tlen oncaj nion on tlen yolticaj onochijchiu tla xyejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","IConeu Dios quitemaca on nemilistli yejhuan para nochipa. Niman on nemilistli quitemaca tlamachilistli quen tlahuijli para on tlacamej cajsicamatisquej on tlajtlamach ica Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yejhua in tlamachilistli oncatcaj intzajlan on xcuajcualtin tlacamej niman xcuajcualtin espíritus, niman yejhuamej xhuelij quipopolohuaj on tlamachilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios ocuajtitlan se tlacatl itoca Juan. ");
INSERT INTO nguNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yejhua ohuajlaj quen se teixpantiliquetl para oquiteixpantilico ica on yejhuan quitemaca tlamachilistli para ijcon nochimej huelisquej tlaneltocasquej. ");
INSERT INTO nguNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan xejhua on yejhuan tequichihua para cajsicamatisquej on tlajtlamach ica Dios, yej yejhua san quiteixpantilia ica oncaj on tlahuijli. ");
INSERT INTO nguNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yejhua in tlahuijli yejhua melahuac. Yejhua ohuajlaj ipan in tlalticpactli niman tequichihua para nochi tlacatl cajsicamatis on tlamachilistli yejhuan melahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yejhua on yejhuan Tlajtojli nemiya ipan in tlalticpactli. Masqui Dios oquitlalij in tlalticpactli itechcopa yejhua, on tlalticpactlacamej xoquixmatquej. ");
INSERT INTO nguNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ohuajlaj intech on hebreos niman on hebreos xoquiselijquej. ");
INSERT INTO nguNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero nochimej on yejhuan oquiselijquej niman itech otlaneltocaquej, oquinmacac permiso para onochijquej iconehuan Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yejhuamej xteconehuan intech tlalticpactlacamej yejhuan tlacatij quen nochi tlacatl, nion huajtlacatij pampa innan niman intaj quinequij, yej otlacaticoj pampa Dios oquinec para tlacatisquej itech. ");
INSERT INTO nguNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Niman on yejhuan Tlajtojli otlacat niman totzajlan onen. Yejhua sanoyej otetlajsojtlac niman otemachtij tlen melahuac. Niman otiquitaquej ihueyilis. On hueyilistli yejhua quipia pampa yejhua isenTeconeu toTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan oquiteixpantilij Cristo ijcuac oquijtoj: “In yejhua nictenehuaya ijcuac oniquijtoj ica on yejhuan nechajtocatiaya ipan notequiu, yejhua más hueyixticaj xquen nejhua pampa ijcuac onitlacat yejhua ye nemiya.” ");
INSERT INTO nguNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tinochimej ticselijtihuij itech ihueyilis sanoyej miyec tlatiochihualistli. ");
INSERT INTO nguNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés oquitemacac on tlanahuatijli pero on tetlajsojtlalistli niman on tlen melahuac ocuajquic Jesucristo. ");
INSERT INTO nguNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xqueman yacaj quitaya Dios. Pero isenTeconetzin yejhuan toTajtzin sanoyej quitlajsojtla yejhua yoquipantlantij. ");
INSERT INTO nguNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juan oteixpantilij ijcuac on tlayecanquej hebreos chanejquej ne Jerusalén oquintitlanquej tiopixquej niman levitas itech para quitlajtoltisquej aquin yejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yejhua ijquin oquinnanquijlij. Cuajli oquinmelajcaijlij: ―Nejhua xniCristo yejhuan Dios oquitlalij para tlamandaros. ");
INSERT INTO nguNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Quemaj oquitlajtoltijquej: ―Tla ijcon, ¿aquin tejhua? ¿Tejhua titiotlajtojquetl Elías? Niman Juan oquijtoj: ―Ca, xnejhua. Quemaj ijquin oquitlajtoltijquej: ―Tla ijcon, ¿Tejhua titiotlajtojquetl on yejhuan ica oncaj huajlas? Niman yejhua oquijtoj: ―Ca. ");
INSERT INTO nguNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Quemaj más oquitlajtoltijquej: ―Xtechijli, tej, aquin tejhua pampa ica oncaj ticpiasquej tlen tiquimijlisquej on yejhuan otechajtitlanquej. ¿Tlinon tiquijtohua moca tejhua? ");
INSERT INTO nguNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ijcuacon Juan oquinnanquilij: ―Nejhua on aquin tzajtzi ne campa tlapatlaco: “Xmelajcatlalican nemoyojlo para nenhuelisquej nenquiselisquej toTeco.” No ijqui niquijtohua quen oquijtoj on tiotlajtojquetl Isaías. ");
INSERT INTO nguNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","On yejhuan oquinotzatoj Juan oquinhuajtitlancaj on fariseos. ");
INSERT INTO nguNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Niman yejhuamej oquijlijquej: ―Tla ijcon, tla xtejhua tiCristo, nion tiElías, nion yejhua on tiotlajtojquetl yejhuan ica oncaj huajlas, ¿tlica, tej, titlacuatequiya? ");
INSERT INTO nguNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan oquimijlij: ―Nejhua nitlacuatequiya ican atl, pero nemotzajlan ocse nemi yejhuan xnenquixmatij. ");
INSERT INTO nguNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yejhua nechajcuitlamanhuijtiu ipan notequiu. Niman nejhua nion achijtzin xnechmelahua nictojtomas icacmecayo, pampa más hueyixticaj xquen nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nochi yejhua in onochiu ne campa itoca Betábara yejhuan nocahua ne ica iquisayan tonajli de on atentli Jordán campa Juan tlacuatequiaya. ");
INSERT INTO nguNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Huajmostla Juan oquitac Jesús ye ompa quinnisihuijtiaya niman oquijtoj: ―Xquitacan yejhua on tlacatl. Yejhua quihuentlalisquej quen se borreguito para Dios quintlapojpolhuilis intlajtlacolhuan nochimej on tlalticpactlacamej. ");
INSERT INTO nguNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","In yejhuan nictenehuaya ijcuac oniquijtoj: “Se tlacatl yejhuan nechajcuitlapanhuiya ipan notequiu yejhua más hueyixticaj xquen nejhua pampa ijcuac onitlacat, yejhua ye nemiya.” ");
INSERT INTO nguNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Sa no nejhua xnicmatiya aquin yejhua. Pero yejhua ica nihuajtlacuatequijtiu ican atl para on hebreos huelis quixmatisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Niman no oquiteixpantilij Juan on tlen oquitac. Yejhua oquijtoj: ―Nejhua oniquitac quen ohuajtemoc ne ilhuicac on Espíritu Santo. Yejhua ohuajtemoc quen itlaj paloma niman ipan yejhua onocau. ");
INSERT INTO nguNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nejhua hasta aman xnicmatisquia aquin yejhua, pero yejhua on yejhuan onechajtitlan ma nitlacuatequi ican atl onechijlij: “Ijcuac tiquitas temos on Espíritu Santo niman on aquin ipan nocahuas, ticmatis ica on yejhua tlacuatequis ican Espíritu Santo.” ");
INSERT INTO nguNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nejhua yoniquitac niman aman nicteixpantilia ica yejhua iConeu Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Huajmostla Juan ocsejpa ompa nemiya ihuan omemej inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Niman ijcuac oquitac ompaca panohuaya Jesús, oquijtoj: ―Xquitacan on tlacatl. On iborreguito Dios. Dios ocuajtitlan para quihuentlalisquej quen se borreguito. ");
INSERT INTO nguNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Quemaj ijcuac on omemej inomachtijcahuan Juan ocacquej on tlen yejhua oquijtoj, oquicuitlapanhuiquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Quemaj Jesús ontlachix icuitlapan niman ica oquitac cuajcuitlapanhuiyayaj on omemej tlacamej oquimijlij: ―¿Tlinon nenquitejtemohuaj? Yejhuamej oquijlijquej: ―Temachtijquetl, ¿canon tichanti? ");
INSERT INTO nguNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús oquimijlij: ―Xhuajlacan niman xquitacan. Quemaj oyajquej niman oquitaquej canon chanti, niman ompa ihuan onocajquej hasta queman otlayohuac pampa ye tiotlac catca, canaj ipan nahui hora ijcuac oyejcoquej. ");
INSERT INTO nguNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Semej yejhuamej on omemej yejhuan ocacquej Juan niman oquicuitlapahuij Jesús, itoca Andrés yejhuan icniu Simón Pedro. ");
INSERT INTO nguNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Achtoj ijcuac xe itlaj quichihuaya, Andrés oyaj quitejtemoto Simón on icniu, niman oquijlij: ―Yoticnextijquej on Mesías ―yejhuan quijtosnequi Cristo yejhuan Dios oquitlalij para ma tlamandaro. ");
INSERT INTO nguNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Quemaj Andrés ocuicac Simón ne campa Jesús nemiya. Niman ijcuac Jesús oquitac, oquijlij: ―Tejhua tiSimón iconeu Jonás, pero motoca yes Cefas ―yejhuan quijtosnequi Pedro. ");
INSERT INTO nguNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Huajmostla Jesús oquinemilij para yas ne Galilea. Niman ijcuac oquinextij Felipe, oquijlij: ―Xhuajla nohuan. ");
INSERT INTO nguNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe chanej catca ipan on pueblo itoca Betsaida campa no chantiyaj Andrés niman Pedro. ");
INSERT INTO nguNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Quemaj Felipe oyaj niman oquinextij Natanael. Niman yejhua oquijlij: ―Yoticnextijquej on tlacatl yejhuan oquiteneu Moisés ipan on itlajcuilolamahuan ican tlanahuajtijli, niman no on tiotlajtojquej ica otlajcuilojcaj. Yejhua Jesús iconeu José yejhuan chanej ipan on pueblo itoca Nazaret. ");
INSERT INTO nguNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Quemaj Natanael oquijtoj: ―¿Intech on tlacamej yejhuan chantij ne Nazaret huelis quisas se yejhuan tepalehuis? Felipe oquijlij: ―Xhuajla niman xquitaqui. ");
INSERT INTO nguNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ijcuac Jesús oquitac Natanael quinisihuiaya, oquijtoj: ―Nican huajlau se yejhuan melahuac hebreo yejhuan xqueman tlacajcayahua. ");
INSERT INTO nguNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Quemaj Natanael oquitlajtoltij: ―¿Quen tinechixmati? Niman Jesús oquijlij: ―Ijcuac Felipe xe mitznotzaya, nejhua onicmat ica tinemiya ne itzintlan on cojtli itoca higuera. ");
INSERT INTO nguNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Quemaj Natanael oquijlij: ―Temachtijquetl, tejhua tiiConeu Dios. Tejhua tiiRey on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús oquijlij: ―¿Tinechneltoca san ica onimitzijlij onimitzontac itzintlan on cojtli higuera? Aman, tej, nimitzijlia ica más huejhueyi tlajtlamach tiquitas. ");
INSERT INTO nguNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","No ijqui oquijtoj Jesús: ―Ica tlen melahuac nemechijlia, ica nemejhuamej nenquitasquej tlapojtias on ilhuicac niman on iilhuicactequitcahuan Dios tlejcosquej niman temosquej nopan yejhuan oninochiu Tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ipan yeyi tonajli más saquin, oncatca se tlanamictilistli ne ipan on pueblo itoca Caná de Galilea. Inan Jesús ompa nemiya. ");
INSERT INTO nguNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Niman Jesús ihuan inomachtijcahuan no oquinnotzquej ipan on tlanamictilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Inan Jesús, ijcuac otlan on vino ipan on ilhuitl, oquijlij Jesús: ―Xocuitlaj vino. ");
INSERT INTO nguNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero Jesús oquijlij: ―Sihuatl, ¿tlica tinechijlia nejhua? Hasta aman xe ajsi on tonajli para nicchihuas milagros. ");
INSERT INTO nguNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Quemaj inan ijquin oquimijlij on yejhuan ompa tequichihuayaj: ―Xchihuacan nochi tlen yejhua mechijlis. ");
INSERT INTO nguNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ompa oncatcaj chicuasen contin tlachijchiutin ican tetl niman ipan se contli hueli calaquiya canaj napoajli noso cien litros de atl. On hebreos quitequitiltiayaj on atl para nomajtequiayaj, niman ijcon nocahuayaj chipajquej ixpan Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús oquimijlij on tequichijquej: ―Xquintemacan in contin ican atl. Niman cuajli oquintemiltiquej. ");
INSERT INTO nguNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Niman quemaj Jesús oquimijlij: ―Aman xquixtican achijtzin niman xquitquilican on yejhuan tlayecanquetl ipan in ilhuitl. Niman yejhuamej ijqui oquichijquej. ");
INSERT INTO nguNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","On tlayecanquetl ipan on ilhuitl xquimatiya canon ohualeu, yej san yejhuamej on tequichijquej quimatzticatcaj yejhuan oquixtijquej on atl. On tlayecanquetl oquimat on atl yejhuan tlacueptli vino niman quemaj oquinotz on montli ");
INSERT INTO nguNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","niman oquijlij: ―Nochi tlacatl achtoj quitemaca on más huelic vino niman ijcuac on tenotzaltin miyec yoconiquej, quinmacaj on vino yejhuan xmás huelic. Pero tejhua yej otiquejeu on más huelic vino para más saquin tictemaca. ");
INSERT INTO nguNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yejhua in tlen Jesús oquichiu ne Caná de Galilea, yejhua iachtoj milagro. Yejhua in tlamajhuisojli oquiteititij ihueyilis, niman on inomachtijcahuan oquineltocaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ijcuac ijcon yonochiu, Jesús ihuan inan, icnihuan niman inomachtijcahuan oyajquej ne ipan on pueblo itoca Capernaum campa onenquej quesqui tonajli. ");
INSERT INTO nguNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Quemaj ica ye nisiu huajlaya on ilhuitl itoca pascua yejhuan on hebreos quejehuayaj, Jesús oyaj ne ipan on hueyican Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne ipan iquiahuac on hueyi tiopan, Jesús oquinnextito on yejhuan quinnamacayaj huacaxtin, borregos niman palomas. Niman no ompa oquinnextito on yejhuan quimpatiliayaj tomin on tlacamej ne campa yejyehuaticatcaj ipan inmesas. ");
INSERT INTO nguNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ijcuac yejhua ijcon oquitac, oquichijchiu se tlachijchihualmecatl niman nochimej oquintlahuelhuijhuitec ihuan inborregos niman inhuacaxhuan. On yejhuan quitepatiliayaj tomin, oquinxixinilij intomin ipan tlajli, niman oquinxixinilij inmesa. ");
INSERT INTO nguNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","On tlanamacaquej ican palomas oquimijlij: ―¡Yejhua on xquejcuanican nican! ¡Ma ca xmercado chihuacan ipan ical noTajtzin! ");
INSERT INTO nguNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Quemaj on inomachtijcahuan oquelnamiquej on Yectlajcuilojli yejhuan quijtohua: “Ican nochi noyojlo nictlacaita motiopan.” ");
INSERT INTO nguNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Quemaj on hebreos oquijlijquej: ―¿Catlejhua tlamahuisojli titechititis para tiquitasquej ica mitzmelahua ticchihuas yejhua in? ");
INSERT INTO nguNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús oquimijlij: ―Xxoxotonican yejhua in tiopan niman ipan yeyi tonajli ocsejpa niquetztehuas. ");
INSERT INTO nguNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Quemaj on hebreos oquijlijquej: ―Yejhua in tiopan ompoajli huan chichuasen xipan ohuejcajquej ica oquichijchijquej, ¿niman tejhua san ipan yeyi tonajli ticchijchihuas ocsejpa? ");
INSERT INTO nguNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero on tiopan yejhuan Jesús quitenehuayaj sa no de yejhua itlalnacayo. ");
INSERT INTO nguNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yejhua ica, ijcuac Jesús oyoliu niman onoquetzteu ipan itlalcon, on inomachtijcahuan oquelnamiquej in tlen yejhua oquijtojca. Yejhua ica oquineltocaquej on Yectlajcuilojli niman on tlajtojli yejhuan oquimijlijca. ");
INSERT INTO nguNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ijcuac Jesús nemiya ne Jerusalén ipan on ilhuitl pascua, miyequej oquineltocaquej ijcuac oquitaquej on milagros yejhuan quichihuaya. ");
INSERT INTO nguNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero yejhua xoquitlalij iyojlo itech intlaneltoc pampa quimixmatiya ipan inyojlo nochimej. ");
INSERT INTO nguNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Xquipolohuaya para yacaj quijlis quen ijquimej on tlacamej pampa sa no yejhua quimatzticatca tlinon oncaj ipan inyojlo on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nemiya se fariseo itoca Nicodemo yejhuan tlayecanquetl catca intech on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yehua in Nicodemo oyaj oquinotzato Jesús ijcuac tlayohua, niman oquijlij: ―Temachtijquetl, ticmatztoquej ica Dios omitzajtitlan para otitechmachtico, pampa xacaj hueli quiteititia ipoder ican milagros quen tejhua ticchihua tla Dios xihuan nemi. ");
INSERT INTO nguNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Quemaj Jesús oquijlij: ―Ica tlen melahuac nimitzijlia, tla yacaj xoc sejpa tlacatis, xhuelis calaquis campa Dios tlamandarohua. ");
INSERT INTO nguNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niman Nicodemo oquitlajtoltij: ―Pero ¿quen ijqui se tlacatl yejhuan yonoscaltij huelis ocsejpa tlacatis? ¿Tla ijcon huelis calaquis ijtic inan para ocsejpa tlacatis? ");
INSERT INTO nguNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Niman Jesús oquijlij: ―Ica tlen melahuac nimitzijlia, tla yacaj tlacatl xnocuatequia ican atl niman xtlacati itechcopa on Espíritu Santo, xhuelis calaquis ne campa tlamandarohua Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ijcuac se tlacati itech inan quiselia san nemilistli ipan itlalnacayo para nemis quen inan, pero ijcuac tlacati itech on Espíritu Santo quiselia yencuic nemilistli ipan ialma. ");
INSERT INTO nguNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma ca mitzmojcatlachalti on ica nimitzijlia: “Ica oncaj ocsejpa titlacatis.” ");
INSERT INTO nguNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","On ajacatl tlalpitza san canon quinequi. Ticaqui on tlen yejhua caquistilia, pero xticmati canon hualehua niman canon yau. No ijqui, tej, on yejhuan tlacatij ican on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Quemaj Nicodemo oquitlajtoltij: ―¿Quen ijqui huelis nochihuas yejhua in? ");
INSERT INTO nguNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús oquinanquilij: ―¿Tejhua tihueyitemachtijquetl ipan Israel niman xticmati yejhua in tlajtlamach? ");
INSERT INTO nguNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ica tlen melahuac nimitzijlia ica tejhuamej titlajtlajtohuaj ica on tlen ticmatij, niman ica on tlen yotiquitaquej ticteixpantiliaj, pero nemejhuamej temachtijquej xnenquineltocaj tlen temechijliaj. ");
INSERT INTO nguNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tla xnennechneltocaj ijcuac nemechnojnotza ica on tlajtlamach yejhuan quisa ipan in tlalticpactli, ¿quen ijqui nennechneltocasquej tla nemechnojnotzas ica on tlajtlamach yejhuan quisa ne ilhuicac? ");
INSERT INTO nguNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Xe yacaj tlejcohua ne ilhuicac, yej san nejhua yejhuan oninochiu Tlacatl onihuajtemoc ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Niman ijcon quen Moisés oquipiloj on cohuatl ne campa tlapatlaco, ica oncaj no ijqui nechajcopilosquej nejhua yejhuan oninochiu Tlacatl ");
INSERT INTO nguNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","para nochi on yejhuan nechneltocas xmiquis, yej quipias nemilistli para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tej, Dios sanoyej oquintlajsojtlac on tlalticpactlacamej hasta oquitemacac isenteConetzin para nochi on aquin quineltocas xpolihuis, yej quipias yencuic nemilistli para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios xocuajtitlan iConetzin, intech on tlalticpactlacamej para quintlajtlacolmacas, yej para on tlalticpactlacamej ma nomaquixtican itechcopa. ");
INSERT INTO nguNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","On yejhuan quineltoca xquitlajtlacolmacasquej, pero on yejhuan xquineltoca ye quipia tlajtlacolmacalistli san pampa xquineltoca isenteConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yejhuamej quiseliaj tlajtlacolmacalistli pampa ohuajlaj iConetzin Dios ipan in tlalticpactli niman oquintitij on cuajli ojtli para ipan nohuicasquej, pero xquinequij nohuicasquej ipan on cuajli ojtli, pampa yejhuamej quichihuaj on tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nochimej yejhuan quichihuaj on tlen xcuajli quitlahuelitaj iConetzin Dios niman on cuajli ojtli yejhuan oquiteititij. Yejhuamej xhuajlahuij itech pampa xquinequij nopantlantis intlajtlacol. ");
INSERT INTO nguNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero on yejhuan quichihuaj on tlen cuajli huajlahuij itech para nopantlantis ica quichihuaj on tlen Dios quinnahuatia. ");
INSERT INTO nguNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ijcuac in yopanoc, Jesús oyaj inhuan inomachtijcahuan ne Judea campa quesqui tonaltin ompa inhuan onocau. Niman Jesús oquinnahuatij inomachtijcahuan ma tlacuatequican. ");
INSERT INTO nguNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","No ijqui Juan tlacuatequiaya ne Enón nisiu Salim pampa ompa oncatca miyec atl. On tlacamej huajlayaj itech niman yejhua quincuatequiaya. ");
INSERT INTO nguNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yejhua in onochiu ijcuac Juan xe cajsiyaj. ");
INSERT INTO nguNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Quemaj sequimej inomachtijcahuan Juan opejquej nocamatlanij inhuan sequimej hebreos yejhua ica on tlacuatequilistli. Yejhuamej quinequiya quimatisquej catlejhua tlacuatequilistli más cuajli, tla on yejhuan de Jesús noso on de Juan. ");
INSERT INTO nguNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yejhua ica oyajquej niman oquijlijtoj Juan: ―Temachtijquetl, cuajli xcaqui ica on yejhuan mohuan nemiya ne ica iquisayan tonajli on atentli Jordán yejhuan tejhua ica otiteixpantilij, aman tlacuatequiya niman nochi tlacatl huajlau itech. ");
INSERT INTO nguNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Quemaj Juan oquimijlij: ―Xacaj huelis quipias itlaj tla Dios ne ilhuicac xcahuilis. ");
INSERT INTO nguNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nemejhuamej cuajli onennechcaquej ijcuac onemechijlij ica nejhua xniCristo, yej se yejhuan Dios ocuajtitlan iyecapan. ");
INSERT INTO nguNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ne campa nonamictilo, on montli yejhua quiselia sihuamontli. Niman itetlajsojcau on montli no sanoyej paqui ijcuac caqui tlajtlajtohua on montli. Nejhua quen itetlajsojcau on montli. Ijcon, tej, sanoyej nipaqui ijcuac nicaqui ica nochi tlacatl yau itech Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yejhua ica, tej, ica oncaj más hueyixtias niman nejhua yej más nitemotias. ");
INSERT INTO nguNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","On yejhuan huatemohua ne ilhuicac más hueyixticaj xquen nochi tlacatl. On yejhuan chanej ipan in tlalticpactli san tlalticpactlacatl niman tlajtlajtohua ica on tlajtlamach yejhuan quisticaj ipan in tlalticpactli. Pero on yejhuan hualehua ne ilhuicac más hueyixticaj xquen nochi tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yejhua quiteixpantilia ica on tlen yoquitac niman yocac, pero xacaj quineltoca on tlen yejhua quijtohua. ");
INSERT INTO nguNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero tla yacaj quineltoca on tlen quijtohua on yejhuan ohuajtemoc ne ilhuicac, quiteixpantilia ica Dios quijtohua on tlen melahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","On yejhuan Dios ocuajtitlan quitojhua on itlajtol Dios, pampa Dios oquimacac iEspíritu ican nochi ihueyilis. ");
INSERT INTO nguNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","On Tajtli quitlajsojtla iConetzin, niman yoquimactilij nochi itequihuajyo ipan nochi tlen oncaj. ");
INSERT INTO nguNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yejhuan quineltoca iConetzin Dios quipia nemilistli para nochipa, pero on yejhuan xquitlacamati xquipias yejhua in nemilistli, yej quiselis on temojtij itlahuel Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ToTeco Jesús oquimat ica on fariseos oquimatquej ica yejhua quimpia más nomachtijquej niman tlacuatequiaya más xquen Juan. ");
INSERT INTO nguNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero Jesús xtlacuatequiaya, yej san inomachtijcahuan tlacuatequiayaj. ");
INSERT INTO nguNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Niman ijcuac Jesús ijcon oquimat, oquis ne Judea para ocsejpa oyaj ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Niman ipan iojhui, ica oncatca para panos ipan on yehualican itoca Samaria. ");
INSERT INTO nguNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Oajsic, tej, ipan se pueblo ne Samaria itoca Sicar. Yejhua in pueblo oncatca san nisiu itech on tlajli yejhuan Jacob oquimacac José on iconeu. ");
INSERT INTO nguNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ompa oncatca se pozo yejhuan quipiaya atl. On pozo cuitiayaj ipozo Jacob. Jesús onotlalij itenco on pozo pampa ye huajsiautiaya ipan iojhui. Ijcuacon canaj tlacualispan catca. ");
INSERT INTO nguNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Inomachtijcahuan oyajquej ipan on pueblo para ocohuatoj itlaj tlen quicuasquej. Quemaj ohuajlaj se sihuatl yejhuan chanej ne Samaria. Yejhua ohuajlaj para oquixtico atl ijtic on pozo, niman Jesús oquijlij: ―Xnechmaca atl. ");
INSERT INTO nguNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Quemaj on sihuatl samaritana oquijlij Jesús: ―¿Quen ijqui tejhua yejhuan tihebreo tinechtlajtlanilia atl nejhua yejhuan nisamaritana? Ijquin oquijtoj pampa on hebreos xcuajli nohuicaj inhuan on samaritanos. ");
INSERT INTO nguNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Quemaj Jesús oquijlij: ―Tla ticmatisquia on tlen cuajli tetlayocolijli Dios quinequi mitzmacas, niman aquin nejhua yejhuan nimitztlajtlanilijticaj atl, tla ijcon, yej tejhua tinechtlajtlanilisquia atl niman nejhua nimitzmacasquia on atl yejhuan quitemaca nemilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","On sihuatl oquijlij: ―Señor, nion siquiera xticpia tlinon ica tiquixtis on atl niman in pozo sanoyej huejcatlan. ¿Canon ticoncuitetzis on atl yejhuan quitemaca nemilistli para tinechmacas? ");
INSERT INTO nguNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Tlen tejhua ticnemilia más tihueyixticaj xquen on achtoj totaj Jacob yejhuan otechmacac in pozo? Yejhua atliya nican niman no iconehuan, niman iyolcahuan atliyaj nican. ");
INSERT INTO nguNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús oquijlij: ―On aquin coni yejhua in atl ocsejpa amiquis. ");
INSERT INTO nguNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero aquin conis on atl yejhuan nicmacas xqueman amiquis, pampa on atl yejhuan nicmacas yejhua nochihuas ijtic quen itlaj ameyajli yejhuan quimacas nemilistli para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Quemaj on sihuatl oquijlij: ―Señor, xnechmaca yejhua on atl para ma ca ocsejpa namiquis, nion nihuajlas nicuajquixtis atl ijtic in pozo. ");
INSERT INTO nguNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús oquijlij: ―Xhuiya xcanati mohuehuentzin niman quemaj xhuajlacan nican. ");
INSERT INTO nguNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Niman on sihuatl ijquin oquinanquilij: ―Xnicpia nohuehuentzin. Quemaj Jesús oquijlij: ―On ica otiquijtoj xticpia mohuehuentzin, on melahuac, ");
INSERT INTO nguNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","pampa macuijli mohuehuentzitzihuan yotiquimpix, niman on yejhuan aman ticpia xmohuehuentzin. Yejhua ica on melahuac tlen otiquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Niman ijcuac on sihuatl ijcon ocac, oquijlij Jesús: ―Señor, nejhua niquita ica tejhua titiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","On noachtojtajhuan samaritanos oquimahuistilijquej Dios nican ipan in tepetl, pero nemejhuamej yejhuan nenhebreos nenquijtohuaj ica nonequi ticmahuistilisquej ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús oquijlij: ―Sihuatl, xnechneltoquili ica huajlau on tonaltin ijcuac nion nican ipan in tepetl nion ne Jerusalén xnenquimahuistilisquej Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nemejhuamej yejhuan nensamaritanos xnenquimatij aquinon nenquimahuistiliaj, pero tejhuamej yejhuan tihebreos ticmatij aquinon ticmahuistiliaj pampa on temaquixtilistli quisa totech. ");
INSERT INTO nguNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero huajlau on tonajli niman sa no aman ijcuac on yejhuan melahuac quinequij quimahuistiliaj toTajtzin, quimahuistilisquej ne impan inyojlo niman ica tlen melahuac quen Dios quinequi. ToTatzin, tej, ijqui quinequi ma quichihuacan on yejhuan quimahuistiliaj. ");
INSERT INTO nguNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios yejhua Espíritu, niman on yejhuan quimahuistiliaj ica oncaj quichihuasquej impan inyojlo niman ica tlej melahuac quen Dios quinequi. ");
INSERT INTO nguNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","On sihuatl oquijlij: ―Nejhua nicmatzticaj ica huajlas on Mesías yejhuan itoca Cristo. Ijcuac yejhua huajlas, nochi tlajtlamach techmelajcailis. ");
INSERT INTO nguNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Niman Jesús oquijlij: ―Sa no nejhua yejhuan nimitznojnotza. ");
INSERT INTO nguNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Niman quemaj oyejcoquej on inomachtijcahuan niman otlamojcaitaquej ica Jesús tlajtlajtohuaya ihuan se sihuatl. Pero xacaj oquitlajtoltij tlinon quinequiya on sihuatl, noso tlica tlajtlajtohuaya Jesús ihuan on sihuatl. ");
INSERT INTO nguNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Quemaj on sihuatl ocajteu itzotzocol niman oyaj ne ipan on hueyican, niman oquimijlito on tlacamej: ");
INSERT INTO nguNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Xhuajlacan, xquitaquij se tlacatl yejhuan onechpanextijlij nochi tlen yonicchiu. ¿Manin yejhua Cristo? ");
INSERT INTO nguNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ijcuacon on tlacamej oquisquej ne ipan on hueyican niman oyajquej ne campa nemiya Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chica yejhua in onochiu, on inomachtijcahuan quitlajtlaniliayaj Jesús: ―Temachtijquetl, nimantzin xtlacua. ");
INSERT INTO nguNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero yejhua oquimijlij: ―Nejhua nicpia tlen nicuas yejhuan nemejhuamej xnenquimatij. ");
INSERT INTO nguNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ijcuac on nomachtijquej ijcon ocacquej, opeu notlajtoltiaj: ―¿Manin yej yacaj yoquitlacualtico? ");
INSERT INTO nguNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Jesús oquimijlij: ―Ijcon quen nemotlalnacayo cojtiticaj ijcuac nentlacuaj, no ijqui noalma cojtiticaj ijcuac nicchihua tlen quinequi on yejhuan onechajtitlan para nitlamis itequiu. Yejhua ica, tej, in tequitl sa no ijqui quen notlacual. ");
INSERT INTO nguNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nemejhuamej nenquijtohuaj: “Oc polihui nahui metztli para pixcalos.” Pero nejhua nemechijlia: Xquitacan nochimej on tlalticpactlacamej. Yejhuamej no ijqui quen se hueyi tlatoctli yejhuan yochicau para nopixcas. ");
INSERT INTO nguNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","On yejhuan quimpixca inalmas on tlacamej quiselia itlaxtlahuil, niman on yejhuan quimpixca quiselis nemilistli para nochipa. Tla ijcon, tej, on yejhuan tlatoca niman on yejhuan pixca san secan paquisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tla ijcon, melahuac quen quijtohua se tlajtojli: “Se tlatoca niman ocse pixca.” ");
INSERT INTO nguNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nejhua onemechtitlan xpixcatij ne campa xonentocaquej. Ocsequimej otequitquej niman nemejhuamej sa nenquiseliaj on tlen yoquitequitquej. ");
INSERT INTO nguNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Niman miyequej samaritanos yejhuan chanejquej ipan on hueyican oquineltocaquej Jesús ipampa on tlen oquimijlij on sihuatl ijcuac oquiteixpantijlij: “Onechpanextijlij nochi tlen nejhua yonicchiu.” ");
INSERT INTO nguNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yejhua ica, ijcuac on chanejquej Samaria ohualajquej, sanoyej oquitlajtlanilijquej para ompa inhuan ma nocahua niman Jesús ome tonajli ompa onocau. ");
INSERT INTO nguNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Niman miyequej más otlaneltocaquej ijcuac ocacquej on tlen sa no yejhua quijtohuaya. ");
INSERT INTO nguNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Quemaj oquijlijquej on sihuatl: ―Aman ticneltocaj xsan pampa yejhua on tlen otitechijlij, yej no pampa sa no tejhuamej yoticacquej. Niman ticmatztoquej ica melahuac yejhua on temaquixtiquetl yejhuan quinmaquixtis on tlalticpactlacamej. ");
INSERT INTO nguNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Quemaj ipan ome tonajli Jesús oquis ne Samaria niman ocajsic iojhui para oyaj ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús sa no yejhua oquijtoj ica se tiotlajtojquetl xquitlacaitaj on yejhuan chanejquej. ");
INSERT INTO nguNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ijcuac oajsic ne Galilea, on yejhuan ompa chanejquej cuajli oquiselijquej, pampa yejhuamej no oyajcaj ne Jerusalén ipan on ilhuitl pascua, niman oquitaquej nochi tlen yejhua ompa oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Quemaj Jesús ocsejpa ohuajlaj ne Caná campa on atl oquicuepca vino. Ompa nemiya se hueyixticaj itequitcau on rey, yejhuan ne ipan on hueyican Capernaum quipiaya se iconeu cualohuaya. ");
INSERT INTO nguNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ijcuac on hueyixticaj tequitquetl oquimat ica Jesús ohuaquis ne Judea niman ica yoyejcoc Galilea, oyaj oquitato niman oquicnotlajtlanilij para ma huiya ichan niman ma quipajti iconeu yejhuan ye micticatca. ");
INSERT INTO nguNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Quemaj Jesús oquijlij: ―Nemejhuamej xnentlaneltocaj tla xnenquitaj tlamajhuisoltin niman milagros. ");
INSERT INTO nguNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero on hueyixticaj tequitquetl oquijlij: ―Señor, nimantzin xhuajla antes miquis noconeu. ");
INSERT INTO nguNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Niman Jesús oquijlij: ―Xhuiya mochan. Moconeu xmiquis. On tlacatl oquineltocac tlinon Jesús oquijlij, niman oyaj. ");
INSERT INTO nguNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ijcuac ye ajsiticatca ichan on itequitcahuan oquinamiquitoj niman oquijlijquej: ―Moconeu yopajtic. ");
INSERT INTO nguNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Quemaj oquintlajtoltij tlen hora opeu pajtitiu iconeu, niman oquijlijquej: ―Yalohua ipan la una ijcuac tiotlac ocau on totonqui. ");
INSERT INTO nguNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ijcuacon on tajtli oquelnamic ica sa no ipan on hora ijcuacon ijcuac Jesús oquijlij: “Moconeu xmiquis.” Yejhua ica, tej, ihuan nochi ichanchanejcahuan oquineltocaquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","In yejhua ica ome milagro oquichiu Jesús ijcuac ohuajquis ne Judea niman oyaj ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ijcuac in tlajtlamach yonochiu, Jesús oyaj ne Jerusalén campa on hebreos quichijticatcaj se ilhuitl para Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ipan on hueyican, nisiu itech on tlatzacuilyotl itoca de las Ovejas, oncatca se campa naltilo yejhuan ica tlajtojli hebreo itoca Betesda. Ne campa naltilo quipiaya macuijli tlatzacuiltenco. ");
INSERT INTO nguNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Niman ompa ipan on tlatzacuiltenco tejtemiyaj miyequej cocoxquej yejhuan coxomej, ciegos niman on yejhuan sepohuiyaj. Yejhuamej quichixticatcaj ma nolini on atl, ");
INSERT INTO nguNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","pampa san ajsiya on tiempo ijcuac se ilhuicactequitquetl temohuaya ne ijtic campa naltilo niman quinelohuaya on atl. Quemaj on yejhuan achtopa calaquiya ne ijtic on atl pajtiya masqui san catlejhua cualolistli quipiaya. ");
INSERT INTO nguNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ompa nemiya se tlacatl yejhuan ye quipiaya sempoajli huan majtlactli huan chichueyi xipan ica cualohuaya. ");
INSERT INTO nguNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ijcuac Jesús oquitac ompa onoc, niman oquitac ica ye huejcahui cualo, oquitlajtoltij: ―¿Ticnequi tipajtis? ");
INSERT INTO nguNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","On cocoxqui oquijlij: ―Señor, xnicpia aquin nechcalactis ijtic on atl ijcuac nolinia. Ijcuac nicnequi nicalaquis, ocse achtopa calaqui. ");
INSERT INTO nguNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús oquijlij: ―Xmotelquetza. Xcajcocui mopetl niman xhuiya. ");
INSERT INTO nguNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nimantzin on tlacatl opajtic, ocontilan ipetl niman onejnen. Pero yejhua in onochiu ipan on tonajli ijcuac nosehuiaj on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yejhua ica intlayecancahuan on hebreos oquijlijquej on yejhuan opajtic: ―Aman in tonajli para titosehuiaj. Itlanahuatil Moisés xmitzcahuilia para ticmomamaltis mopetl. ");
INSERT INTO nguNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","On tlacatl oquimijlij: ―On yejhuan onechpajtij onechijlij: “Xcajcocui mopetl niman xhuiya.” ");
INSERT INTO nguNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Quemaj oquitlajtoltijquej: ―¿Aquinon omitzijlij: “Xcajcocui mopetl niman xhuiya”? ");
INSERT INTO nguNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero on tlacatl xquimatiya aquinon oquipajtij, pampa Jesús onejcuanij itech on miyec tlacatl yejhuan ompa nemiya. ");
INSERT INTO nguNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Más saquin Jesús oquinextij ne ipan on hueyi tiopan, niman oquijlij: ―Xcaqui, aman yotipajtic. Ma ca ocsejpa titlajtlacos para ma ca mopan nochihuas itlaj yejhuan más temojtij. ");
INSERT INTO nguNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Quemaj on tlacatl oyaj niman oquinmachiltijtetzito itlayecancahuan on hebreos ica on yejhuan oquipajtij yejhua Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yejhua ica, tej, on tlayecanquej tlamach ica oquipajsolojquej Jesús niman quimictisnequiyaj, pampa on tlen oquichiu ipan on tonajli ijcuac nosehuiaj on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Jesús oquimijlij: ―NoTajtzin hasta aman tequiti, niman nejhua no nitequiti. ");
INSERT INTO nguNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yejhua ica on itlayecancahuan on hebreos más quinequiyaj quimictisquej, pampa xsan xquitlacaitaya on nesehuiltonajli, yej no oquijtoj ica Dios yejhua iTaj, niman ijcon, tej, onoteneu ica yejhua nemi sa no ijqui quen Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Quemaj Jesús oquimijlij: ―Ica tlen melahuac nemechijlia ica nejhua yejhuan niiConeu Dios xhueli nicchihua itlaj noselti, yej san nihueli nicchihua on tlen niquita quichihua noTaj. On tlen noTaj quichihua no nicchihua. ");
INSERT INTO nguNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tej, noTaj nechtlajsojtla niman nechititia nochi tlen yejhua quichihua. Yejhua nechititis tlajtlamach yejhuan más huejhueyi xquen yejhua in para nicchihuas. Ijcon tej, nemejhuamej mechmojcatlachaltis. ");
INSERT INTO nguNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ijcon quen noTaj quinyolitis on mimiquej niman quinmacas nemilistli, nejhua yejhuan niiConeu no ijqui nicmacas nemilistli on yejhuan nicnequis nicmacas. ");
INSERT INTO nguNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Niman noTaj xquiyolcuitia nion quitlajtlacolmaca yacaj tlacatl, yej nejhua onechmacac nochi on tequihuajyotl para niteyolcuitis niman nitetlajtlacolmacas, ");
INSERT INTO nguNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","para nochimej ma nechtlacaitacan quen quitlacaitaj noTaj. Yejhuan xnechtlacaitaj, no xquitlacaitaj noTaj yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ica tlen melahuac nemechijlia: Yejhuan cuajli caqui on tlen niquijtohua niman quineltoca on yejhuan onechajtitlan quipia nemilistli para nochipa. Niman xquitlajtlacolmacasquej, yej ialma yonomanahuij itech miquilistli, niman aman quipia nemilistli para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ica tlen melahuac nemechijlia ye huajlau on tonajli niman sa no aman yoyejcoc ijcuac on mimiquej caquisquej notlajtol nejhua yejhuan niiConeu Dios, niman on yejhuan quitlacamatisquej nemisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ijcon quen noTajtzin quitemaca nemilistli para nochipa, no ijqui nejhua yejhuan niiConeu nictemaca nemilistli para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Niman yonechmacac itlanahuatil para niteyolcuitis niman nitetlajtlacolmacas pampa oninochiu Tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma ca yejhua ica in xmojcatlachacan, pampa yejcos on tonajli ijcuac nochimej on mimiquej caquisquej notlajtol ");
INSERT INTO nguNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","niman quisasquej ipan intlalcon. On yejhuan oquichijquej on tlen cuajli, yolisquej niman noquetztehuasquej ipan intlalcon para quipiasquej yencuic nemilistli yejhuan para nochipa. Pero on yejhuan oquichijquej on tlen xcuajli, yolisquej niman noquetztehuasquej para quintlajtlacolmacasquej. ");
INSERT INTO nguNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Nejhua xhueli itlaj nicchihua itechcopa notequiyo. Nejhua niteyolcuitia niman nitetlajtlacolmaca quen Dios nechijlia. Yejhua ica niteyolcuitia niman nitetlajtlacolmaca quen quitocarohua pampa xnicchihua tlen nejhua nicnequi, yej tlen quinequi noTajtzin yejhua onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tla sa no nejhua noca ninoteixpantilia nenhuelisquiaj nenquijtosquiaj ica on tlen niquijtohua xmelahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero nemi ocse yejhuan noca quiteixpantilia, niman nejhua nicmati ica on tlen noca quijtohua melahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Onenquintitlanquej sequimej itech Juan, niman on tlen yejhua noca oquijtoj melahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero on tlen Juan noca oquijtoj xnechpolohua, yej san nemechelnamictia on tlen yejhua noca oquijtoj para huelis nennechneltocasquej niman nenmaquisasquej. ");
INSERT INTO nguNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan quen itlaj tlahuijli catca yejhuan tlicuiya niman cuajli tlahuilohuaya. Itlahuil omechititij on cuajli ojtli para ipan nemohuicasquej. Niman quesqui tonaltin onenquitlalijquej nemoyojlo ican paquilistli para nenyasquej ipan on cuajli ojtli. ");
INSERT INTO nguNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero nejhua nicpia noteixpantilijcau yejhuan más hueyi quijtosnequi xquen yejhua on tlen oquijtoj Juan. On tlen noTajtzin onechmacac para ma nicchihua quiteixpantilia ica melahuac noTajtzin onechajtitlan niman no in tlajtlamach nicchihua. Yejhuamej quiteititia ica melahuac noTajtzin onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Niman noTajtzin yejhuan onechajtitlan no noca teixpantilia. Nemejhuamej xqueman onencacquej ijcuac tlajtlajtohua, xqueman onenquitaquej quen tlajtlacha. ");
INSERT INTO nguNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nion itlajtol xhueli calaqui ipan nemoyojlo, pampa xnennechneltocaj nejhua yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nemejhuamej sanoyej nenquimomachtiaj on Yectlajcuilojli, pampa nenquinemiliaj ica nenquinextisquej nemilistli yejhuan para nochipa ijcuac yejhua nenquimomachtiaj. Yejhua ica mechtocarohua nenquimatisquej ica on Yectlajcuilojli yejhua mechtenquixtilia noca nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero nemejhuamej xnenquinequij notech nenhuajlasquej para nenquipiasquej yejhua on nemilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Nejhua xnictejtemohua para on tlacamej ma nechtlacaitacan. ");
INSERT INTO nguNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero nemechixmati niman nicmatzticaj ica xnenquitlajsojtla Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nejhua onihuajlaj nemotech ican itocatzin noTajtzin, niman nemejhuamej xnennechseliaj. Pero tla huajlas ocse yejhuan tlajtlajtos ica sa no itlamachilis, on quemaj nenquiselisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Quen ijqui, tej, huelis nentlaneltocasquej tla sa no nemejhuamej nenquimoseliliaj on tlacaitalistli niman xnenquitejtemohuaj on tetlacamatilistli yejhuan san yejhua Dios quitemaca? ");
INSERT INTO nguNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma ca xnemilican ica nejhua nemechteixpanhuis itech noTajtzin. Yej mechteixpanhuis Moisés yejhuan itech yonenquitlalijquej nemotlamachalis. ");
INSERT INTO nguNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tla nemejhuamej melahuac nenquineltocasquiaj on tlen oquijtoj Moisés, no nennechneltocasquiaj, pampa yejhua otlajcuiloj noca nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero xnenquineltocaj on tlen yejhua oquijcuiloj. Yejhua ica, ¿quen ijqui, tej, huelis nenquineltocasquej on tlen nejhua nemechijlia? ");
INSERT INTO nguNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Saquin ijcuac yejhua on onochiu, Jesús oyaj ipan ocse ilado on mar itoca Galilea yejhuan no itoca Tiberias. ");
INSERT INTO nguNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sanoyej miyec tlacatl yayaj ihuan, pampa yoquitacaj on milagros yejhuan oquichiu ica oquimpajtij on cocoxquej. ");
INSERT INTO nguNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Quemaj Jesús otlejcoc ipan se tepetl niman ompa onotlalij ihuan inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ipan on tonaltin ye nisiu catca para on hebreos quichihuasquej on ilhuitl itoca pascua. ");
INSERT INTO nguNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Niman Jesús oquitac iyehualijcan ica miyec tlacatl quinisihuiya. Yejhua ica oquijlij Felipe: ―¿Canon ticohuasquej tlacuajli para nochi yejhua in tlacatl? ");
INSERT INTO nguNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Cuajli Jesús ye quimatzticatca tlinon quichihuas, pero yejhua ijcon oquijlij san para quitas tlinon quijtos Felipe. ");
INSERT INTO nguNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Niman Felipe oquijlij: ―Se tlacatl nonequi tequitis canaj ome ciento tonaltin para huelis cohuas pan para nochimej in tojlamej. Masqui Ijcon quichihuasquia xcajxilis nion siquiera para cada se quicuas pitentzin. ");
INSERT INTO nguNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Quemaj Andrés, yejhuan semej on inomachtijcau niman yejhuan icniu Simón Pedro, oquijlij: ");
INSERT INTO nguNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nican nemi se oquichconetl yejhuan quipia macuijli pan tlachijchiutin ican cebada niman ome michintzitzintin. Pero ¿tlinon quijtojticaj yejhua in achijtzin tlacuajli para in miyec tlacatl? ");
INSERT INTO nguNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ijcuacon Jesús oquijtoj: ―Xquimijlican ma nosehuican nochimej. Ne campa nemiyaj oncatca miyec sacatl niman ompa onosehuijquej canaj macuijli mil tlacamej, niman on sihuamej xtlapohualtij inhuan. ");
INSERT INTO nguNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Quemaj Jesús ocontilan on pan niman, ijcuac yoquimacac tlaxtlahuijli Dios, oquinmacac on inomachtijcahuan, niman on nomachtijquej oquinxexelohuilijquej nochimej on yejhuan ompa yejyehuaticatcaj. Sa no ijqui oquichiu ica on michimej niman nochimej yejhuamej oquimajxilij san quech quinequiyaj. ");
INSERT INTO nguNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ijcuac yoixhuiquej, Jesús oquimijlij on inomachtijcahuan: ―Xsentlalican nochi on tlen onocau para ma ca itlaj ma ixpolihui. ");
INSERT INTO nguNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ijcon, tej, oquisentlalijquej on tlatlajcotzitzintin tlen onocau itech on macuijli pan tlachijchiutin ican cebada niman oquitemiltiquej majtlactli huan ome chiquiutin. ");
INSERT INTO nguNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Quemaj ijcuac on tlacamej oquitaquej on milagro yejhuan Jesús oquichiu, oquijtojquej: ―Melahuac in yejhua tiotlajtojquetl on yejhuan ye oncatca para huajlasquia ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Quemaj Jesús oquimat ica quinequiyaj quitehuilanasquej para quitlalisquej inrey. Yejhua ica ocsejpa onejcuanij niman iselti oyaj ne ipan on tepetl. ");
INSERT INTO nguNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ijcuac ohuajtlayohuac on inomachtijcahuan Jesús otemotoj ne itech mar. ");
INSERT INTO nguNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Niman otlejcoquej ipan se barco niman opeu quipanahuiyaj on mar para ajsisquej ne Capernaum. Ye tlayohua catca niman Jesús oc xe huajnocuepaya intech. ");
INSERT INTO nguNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Niman opeu chicahuac ajaca, niman tejmotij coxoniya on mar. ");
INSERT INTO nguNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Niman ijcuac yoquinejnenquej macuijli noso chicuasen kilómetros, oquitaquej Jesús nejnentiu ipan on atl niman ye quinisihuijtiaya on barco. Niman yejhuamej onomojtijquej. ");
INSERT INTO nguNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero yejhua oquimijlij: ―¡Nejhua niJesús, ma ca xmomojtican! ");
INSERT INTO nguNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ijcuacon yejhuamej ican pactli oquiselijquej ne ipan barco, niman nimantzin sa oquitaquej yoajsiquej ne ipan on tlajli campa yayaj. ");
INSERT INTO nguNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ijcuac huajmostla, on tlacamej yejhuan onocajcaj ipan on ocse itenco on mar oquimatquej ica on nomachtijquej oyajquej ipan on san ica nochi barco ompa nemiya, niman ica Jesús xinhuan oyaj. ");
INSERT INTO nguNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero saniman oyejcoquej sequimej barcos yejhuan ohualejquej ipan on hueyican itoca Tiberias. Yejhuamej oyejcoquej ne campa nisiu ocuajquej on pan ijcuac on toTeco oquimacac tlaxtlahuijli Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Niman ijcuac on tlacamej oquitaquej ica xompa nemiya Jesús nion inomachtijcahuan, ocalaquej ipan on barcos niman oyajquej oquitejtemotoj ne Capernaum. ");
INSERT INTO nguNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ijcuac on tlacamej oajsiquej ipan on ocse ilado on mar, oquinextitoj Jesús, niman oquitlajtoltijquej: ―Temachtijquetl, ¿camanon otejcoc nican? ");
INSERT INTO nguNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pero Jesús oquimijlij: ―Ica tlen melahuac nemechijlia nemejhuamej nennechtejtemohuaj xpampa onencajsicamatquej tlen quijtosnequi on milagro yejhuan onicchiu yalohua ijcuac onemechtlacualtij, yej san pampa onentlacuajquej hasta campa onemixhuiquej. ");
INSERT INTO nguNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma ca xtequitican ica on tlacuajli yejhuan saniman tlami, yej xtequitican ica on tlacuajli yejhuan quisa itech Dios yejhuan quitemaca nemilistli para nochipa. Nejhua yejhuan oninochiu Tlacatl mechmacas yejhua in tlacuajli pampa toTajtzin oquipantlatij ica nicpia on tlanahuatijli para ijquin nicchihuas. ");
INSERT INTO nguNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Quemaj oquitlajtoltijquej: ―¿Tlinon nonequi ticchihuasquej para tictequitisquej on tlajtlamach yejhuan Dios quinequi ma ticchihuacan? ");
INSERT INTO nguNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Niman Jesús oquimijlij: ―On tlen Dios quinequi xchihuacan sa no yejhua in: Xnechneltocacan nejhua yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Niman quemaj ijquin oquitlajtoltijquej: ―¿Tlen tlamajhuisojli titechititis para ma tiquitacan niman timitzneltocasquej? ¿Tlinon, tej, ticchihuas? ");
INSERT INTO nguNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","On Yectlajcuilojli quijtohua ica ne tlapatlaco on toachtojtajhuan ocuajquej on tlen itoca maná. Ijquin, tej, quijtohua on Yectlajcuilojli: “Dios oquintlacualtij ica on pan yejhuan ne ilhuicac hualejticaj.” ");
INSERT INTO nguNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús oquimijlij: ―Ica tlen melahuac nemechijlia: Moisés xejhua oquitemacac on pan yejhuan ilhuicac hualejticaj. Yej noTajtzin yejhua quitemaca on pan yejhuan melahuac ne ilhuicac hualejticaj. ");
INSERT INTO nguNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yejhua on pan yejhuan Dios quitemaca sa no yejhua on pan yejhuan ohuajtemoc ne ilhuicac niman quinmaca yencuic nemilistli on tlalticpactlacamej. ");
INSERT INTO nguNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Quemaj oquijlijquej: ―ToTeco, nochipa xtechmaca yejhua in pan. ");
INSERT INTO nguNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Niman Jesús oquimijlij: ―Nejhua nipan yejhuan quitemaca yencuic nemilistli. Yejhuan notech huajlau xqueman apismiquis, niman yejhuan nechneltocas xqueman amiquis. ");
INSERT INTO nguNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero quen nejhua yonemechijlij, nemejhuamej xnennechneltocaj masqui yonennechitaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nochimej on quech nechinmacas noTajtzin huajlasquej notech, niman on yejhuan huajlasquej notech niquinselis. ");
INSERT INTO nguNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ijquin nicchihuas pampa nejhua onihualeu ne ilhuicac xpara nicchihuas tlen nejhua nicnequi, yej para nicchihuas on tlen quinequi on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Niman noTajtzin yejhuan onechajtitlan xquinequi nicpolos nion se on yejhuan yejhua onechmacac, yej ipan on sa ica nochi tonajli ma niquinyoliti niman ma niquinquetztehua ipan intlalcon. ");
INSERT INTO nguNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yejhua quinequi para nochimej on yejhuan quimatij aquinon nejhua yejhuan niiConeu Dios niman nechneltocaj, ma quipiacan nemilistli para nochipa. Niman nejhua niquinyolitis niman niquimquetztehuas ipan intlalcon ipan on sa ica nochi tonajli. ");
INSERT INTO nguNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","On hebreos opejquej tlahueltlajtohuaj pampa Jesús ijquin oquijtoj: “Nejhua niyejhua on pan yejhuan ne ilhuicac hualejticaj.” ");
INSERT INTO nguNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Niman oquijtojquej: ―¿Manin in xejhua Jesús, on iconeu José? Tejhuamej tiquixmatij itaj niman inan. Yejhua ica ¿quen ijqui, tej, aman quijtohua ica hualejticaj ne ilhuicac? ");
INSERT INTO nguNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Quemaj Jesús oquimijlij: ―Ma ca sa xtlahueltlajtotiacan. ");
INSERT INTO nguNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xacaj hueli notech huajlau tla xquinotza noTajtzin. Niman nejhua nicyolitis niman niquetztehuas ipan itlalcon ipan on sa ica nochi tonajli. ");
INSERT INTO nguNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ipan intlajcuilolamahuan on tiotlajtojquej ijquin quijtohua: “Dios quinmachtis nochimej.” Ijcon, tej, nochimej yejhuan quitencaquij toTajtzin niman quiseliaj on tlen yejhua quinmachtia, notech huajlahuij. ");
INSERT INTO nguNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Xacaj oquitac on toTajtzin, yej san nejhua yejhuan itech onihualeu oniquitac yejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ica tlen melahuac nemechijlia, ica on yejhuan nechneltoca quipia on nemilistli yejhuan para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nejhua niyejhua on pan yejhuan quitemaca on yencuic nemilistli yejhuan para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","On nemoachtojtajhuan ocuajquej yejhua on maná ne campa tlapatlaco. Xonenquej para nochipa, yej omiquej. ");
INSERT INTO nguNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero on yejhuan quicuasquej on pan yejhuan ne ilhuicac hualejticaj xmiquisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nejhua niyejhua on pan yejhuan quitemaca nemilistli niman yejhuan ne ilhuicac ohualeu. Yejhuan quicuas yejhua in pan nemis para nochipa. On pan yejhuan nejhua nicmacas sa no yejhua nonacayo yejhuan nicuentlalis para on tlalticpactlacamej huelisquej nemisquej para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Quemaj on hebreos opejquej sa no yejhuamej nocamahuisojquij. Quijtohuayaj: ―¿Quen ijqui, tej, huelis sa no inacayo techcualtis? ");
INSERT INTO nguNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús oquimijlij: ―Nejhua yejhuan onochiu Tlacatl ica tlen melahuac nemechijlia, tla nemejhuamej xnenquicuaj nonacayo niman xnenconij noyesyo, xnennemisquej para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yejhuan quicua nonacayo niman coni noyesyo quipia nemilistli para nochipa, niman nejhua nicyolitis niman niquetztehuas ipan itlalcon ipan on sa ica nochi tonajli. ");
INSERT INTO nguNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ijcon nochihuas pampa nonacayo yejhua melahuac tlacuajli, niman noyesyo yejhua melahuac atlilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yejhuan quicua nonacayo niman coni noyesyo nemis san secan nohuan, niman nejhua no ninemis san secan ihuan. ");
INSERT INTO nguNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ToTajtzin yejhuan onechajtitlan quipia nemilistli, niman nejhua itechcopa ninemi. Niman no ijqui, tej, yejhuan nechcuas san notechcopa nemis para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nejhua nipan yejhuan ne ilhuicac ohualeu. Yejhua in pan xijqui quen yejhua on maná yejhuan ocuajquej nemoachtojtajhuan niman omiquej. Yejhuan quicuas in pan yejhuan nictenehua, nemis para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús oquitemachtij yejhua in tlajtlamach ne ipan on tiopan yejhuan oncaj ne Capernaum. ");
INSERT INTO nguNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ijcuac miyequej inomachtijcahuan ijcon ocacquej, oquijtojquej: ―Yejhua in tlen quijtohua sanoyej ohuijticaj para ticselisquej. ¿Aquinon huelis quiselis in temachtijli? ");
INSERT INTO nguNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús oquimat ipan iyojlo ica xpacatlajtlajtohuayaj yejhua ica on, niman oquintlajtoltij: ―¿Mechtlahuelcuitia on yejhuan oniquijto? ");
INSERT INTO nguNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tlinon nenquinemilisquiaj tla nennechitasquiaj nejhua yejhuan oninochiu Tlacatl nitlejcohua ne campa achtoj ninemiya? ");
INSERT INTO nguNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ialma se tlacatl yejhua quimaca nemilistli itlalnacayo. Itlalnacayo xitlaj quijtosnequi tla quipolohua ialma. On notlajtol yejhuan yonemechijlij mechmaca nemilistli para nochipa ijcon quen ialma se tlacatl quimaca nemilistli itlalnacayo. ");
INSERT INTO nguNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero nemotzajlan oc nemij sequimej on yejhuan xe tlaneltocaj. Jesús, tej, ye quimatzticatca aquinomej on yejhuan xtlaneltocayaj, niman aquinon on yejhuan quitemactilis. ");
INSERT INTO nguNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Niman oquijtoj: ―Yejhua ica in onemechijlij ica xacaj huelis notech huajlas, tla toTajtzin xquitlalia ipan iyojlo para ma huajla. ");
INSERT INTO nguNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Desde ijcuacon opeu miyequej on yejhuan cuicatinemiyaj onocuepquej, niman xoc ihuan oquistinenquej. ");
INSERT INTO nguNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yejhua ica Jesús oquintlajtoltij on majtlactli huan ome inomachtijcahuan: ―¿Nemejhuamej no nenquinequij nennechtlalcahuisquej? ");
INSERT INTO nguNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pero Simón Pedro oquijlij: ―NoTeco, ¿aquinon huelis itech tiasquej? San on motlajtoltzin yejhuan tiquijtohua yejhua quitemaca nemilistli yejhuan para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Niman aman tejhuamej yoticneltocaquej niman ye ticmatztoquej ica tejhua tiCristo, tiiConeu Dios yejhuan nochipa nemi. ");
INSERT INTO nguNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús oquimijlij: ―Masqui onemechtlapejpenij nemejhuamej majtlactli huan ome, nemotzajlan nemi se yejhuan quitequipanohua on diablo. ");
INSERT INTO nguNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ijcuac Jesús ijcon oquijtoj, quitenejticatca Judas Iscariote, iconeu Simón, pampa Judas quitemactilisquia masqui yejhua tlapohuajli intech on majtlactli huan ome nomachtijquej. ");
INSERT INTO nguNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ijcuac in yonochiu, Jesús quistinemiya ne Galilea. Xquinequiya quistinemis ne Judea pampa ompa itlayecancahuan on hebreos quinequiyaj quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Inilhuiu on hebreos itoca tabernáculos ye nisiu catca ");
INSERT INTO nguNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","niman icnihuan oquijlijquej: ―Ma ca nican xmocahua. Xhuiya ne Judea para on monomachtijcahuan yejhuan ompa nemij no ma quitacan on milagros yejhuan tictenehua ticchihua. ");
INSERT INTO nguNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tej, on yejhuan quinequi ma cuajli quixmatican xquichtacachihua on tlajtlamach yejhuan quichihua. Niman pampa tictenehua ica ticchihua in quen in tlajtlamach, xchihua ixpan nochi tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","On icnihuan ijcon oquijlijquej pampa nion yejhuamej xquineltocayaj. ");
INSERT INTO nguNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Quemaj Jesús oquimijlij: ―Oc xe yejco on tonajli para nias, pero para nemejhuamej san catlejhua tonajli cuajli para nenyasquej. ");
INSERT INTO nguNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","On tlalticpactlacamej xhuelis itlaj ica mechtlahuelitasquej nemejhuamej. Pero nejhua quemaj nechtlahuelitaj pampa niquinmixcomaca nochi on tlen tlajtlamach xcuajli quichihuaj. ");
INSERT INTO nguNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Xhuiyan nemejhuamej ne ipan on ilhuitl. Nejhua xe niau pampa oc xe ajsi on tonajli para nias. ");
INSERT INTO nguNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Niman ijcuac ijcon oquimijlij, onocau ne Galilea. ");
INSERT INTO nguNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Saquin ijcuac yoyajquej icnihuan, yejhua no oyaj ne ipan on ilhuitl. Pero xoyaj teixpan, yej san ichtaca. ");
INSERT INTO nguNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Itlayecancahuan on hebreos quitejtemohuayaj ne campa ilhuitl, niman quijtohuayaj: ―¿Manin canon nemi yejhua on tlacatl? ");
INSERT INTO nguNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Niman intzajlan on tlacamej miyequej tlajtlajtohuayaj. Sequimej quijtohuayaj: “Yejhua se cuajli tlacatl.” Pero ocsequimej quijtohuayaj: “Ca. Xcuajli tlacatl pampa quincajcayahua on tlacamej.” ");
INSERT INTO nguNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero xacaj teixpan ica tlajtlajtohuaya pampa quinmacajsiyaj itlayecancahuan on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yejhua on ilhuitl ye tlajcotipan yaya ijcuac Jesús ocalac ne ipan on hueyi tiopan, niman opeu temachtia. ");
INSERT INTO nguNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Niman itlayecancahuan on hebreos tlamojcaitayaj, niman quijtohuayaj: ―¿Quen quimati yejhua in miyec tlajtlamach, niman xonomachtij? ");
INSERT INTO nguNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús oquimijlij: ―Notemachtil xnoyaxca. Onicselij itech on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tla yacaj quipia iyojlo para quichihuas on tlen Dios quinequi, huelis quimatis tla notemachtil hualehua itech Dios noso tla san nitemachtia on tlen nicnemilia. ");
INSERT INTO nguNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","On yejhuan tlajtlajtohua san on tlen yejhua quinemilia, quichihua san para on tlacamej ma cueyilican. Pero on yejhuan quichihua canica para yej ma quihueyilican on yejhuan otehuajtitlan, on yejhua quijtohua tlen melahuac niman xqueman tlacajcayahua. ");
INSERT INTO nguNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Masqui Moisés omechmacac on tlanahuatijli, nion semej nemejhuamej xnenquitlacamatij on tlanahuatijli. Yejhua ica, ¿tlica nenquinequij nennechmictisquej? ");
INSERT INTO nguNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","On tlacamej oquinanquilijquej: ―Mojtic nemi se xcuajli espíritu. ¿Aquinon quinequi mitzmictis? ");
INSERT INTO nguNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús oquimijlij: ―San ica on se tequitl onicchiu ipan on tonajli ijcuac on hebreos nosehuiaj niman nemochimej nentlamojcaitaj. ");
INSERT INTO nguNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés omechnahuatij xtlalican on nescayotl itoca circuncisión ipan nemoquichconehuan. Moisés xejhua oquipehualtij, yej on iachtojtajhuan. Yejhua ica nenquitlaliaj on nescayotl ipan se oquichconetl niman nenquichihuaj masqui ipan on nesehuiltonajli. ");
INSERT INTO nguNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tla nenquitlaliaj on nescayotl ipan se oquichconetl ipan on tonajli ijcuac on hebreos nosehuiaj para nenquitlacamatij itlanahuatil Moisés, tla ijcon ¿tlica nennechtlahuelitaj ica onicpajtilij nochi itlalnacayo se tlacatl ipan on tonajli? ");
INSERT INTO nguNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma ca xtetlajtlacolmacacan san isijcapan. Yej san xtlajtlacolmacacan yacaj tla melahuac nenquimatij ica oquichiu tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sequimej yejhuan chantiyaj ne Jerusalén opeu quinotlajtoltiaj: ―¿Tlen xejhua in quitejtemojtinemij para quimictisquej? ");
INSERT INTO nguNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aman, tej, nican tlajtlajtojticaj teixpan, niman xacaj itlaj quijlia. ¿Manin on tequihuajquej melahuac quineltocaj ica in tlacatl yejhua Cristo yejhuan Dios oquitlalij para tlanahuatiquetl yes? ");
INSERT INTO nguNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero xejhua Cristo pampa tejhuamej ticmatztoquej canon ohualeu. Ijcuac huajlas Cristo, xacaj quimatis canon hualehuas. ");
INSERT INTO nguNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ijcuac Jesús ijcon ocac, chica temachtijticatca ne ipan on hueyi tiopan, ican chicahuac tlajtojli oquijtoj: ―¿Melahuac nennechixmatij niman nenquimatztoquej canon nihualehua? Nejhua xonihuajlaj san pampa nejhua onicnec, yej onihuajlaj pampa onechajtitlan on yejhuan melahuac. Niman nemejhuamej xnenquixmatij. ");
INSERT INTO nguNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero nejhua quemaj niquixmati pampa itech nihualehua, niman yejhua onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Quemaj quinequiyaj cajsisquiaj, pero xacaj ocajsic pampa oc xe ajsiya on tonajli para yejhua in nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero miyequej oquineltocaquej, niman oquijtojquej: ―Ticneltocaj ica in tlacatl yejhua Cristo pampa xacaj huelis huajlas yejhuan quichihuas más milagros quen yejhua in tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","On fariseos ocacquej tlinon quijtohuayaj ica Jesús, niman yejhua ica yejhuamej inhuan intlayecancahuan on tiopixquej oquintitlanquej on policías yejhuan tequitij ne ipan on tiopan para cajsisquiaj. ");
INSERT INTO nguNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Niman Jesús oquijtoj: ―San quesqui tonaltin nemohuan ninemis, niman quemaj nias itech on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nemejhuamej nennechtejtemosquej pero xnennechnextisquej, pampa xhuelis nenyasquej ne campa nejhua ninemis. ");
INSERT INTO nguNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Quemaj on hebreos opeu sa no yejhuamej quinotlajtoltiayaj: ―¿Canon, tej, yas campa xhuelis ticonextisquej? ¿Manin yas intech on hebreos yejhuan chajchayajcachantij intzajlan on griegos niman cominmachtis on griegos? ");
INSERT INTO nguNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tlinon quijtosnequi on ica otechijlij: “Nennechtejtemosquej pero xnennechnextisquej”, niman “Xhuelis nenyasquej ne campa nejhua ninemis”? ");
INSERT INTO nguNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","On sa ica nochi tonajli ipan on ilhuitl yejhua más hueyi quitosnequi. Ipan on tonajli Jesús onotelquetz niman ican chicahuac tlajtojli oquijtoj: ―Tla yacaj amiqui, ma huajla notech niman ma atli. ");
INSERT INTO nguNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","On Yectlajcuilojli quijtohua ica yejhuan nechneltocas, ipan iyojlo ameyas se atl yejhuan quimacas nemilistli para nochipa. Niman on atl miyec yes quen itlaj atentli. ");
INSERT INTO nguNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yejhua in Jesús oquijtoj ica on Espíritu Santo yejhuan quiselisquej on yejhuan quineltocasquej. Ipan on tonaltin oc xe huajlaya on Espíritu Santo, pampa Jesús oc xe tlejcohuaya ne ilhuicac para quiselis hueyilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sequimej yejhuan nemiyaj intzajlan on tlacamej, ijcuac ijcon ocacquej, oquijtojquej: ―Tlacaj melahuac, in tlacatl yejhua tiotlajtojquetl yejhuan ica oncatca para huajlas. ");
INSERT INTO nguNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Niman sequimej quijtohuayaj: ―Yejhua in yejhua Cristo yejhuan Dios oquitlalij para tlanahuatiquetl yes. Pero ocsequimej oquijtojquej: ―Yejhua in xejhua Cristo pampa Cristo xhualehuas Galilea. ");
INSERT INTO nguNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","On Yectlajcuilojli quijtohua ica Cristo ica oncaj huejca teixhuiu yes itech rey David niman ica tlacatis ne Belén sa no ipan on pueblo campa onen David. ");
INSERT INTO nguNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yejhua ica on tlacamej onotlajcoxelojquej ipampa Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sequimej quinequiyaj cajsisquiaj, pero xacaj oquimayau. ");
INSERT INTO nguNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","On policías yejhuan quitlajpiaj on tiopan onocuepquej ne campa nemiyaj on fariseos niman intlayecancahuan on tiopixquej. Quemaj ijquin oquintlajtoltijquej on policías: ―¿Tlica xonencuajhuicaquej? ");
INSERT INTO nguNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Niman on policías otlananquilijquej: ―¡Xqueman yacaj tlajtlajtohuaya quen tlajtlajtohua yejhua on tlacatl! ");
INSERT INTO nguNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Quemaj on fariseos oquimijlijquej: ―¿Omechcajcayau nemejhuamej no? ");
INSERT INTO nguNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Nenquitaj yacaj totlayecancau noso se fariseo yotlaneltocac? ");
INSERT INTO nguNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero on quech tojlamej yejhuan xquimatij itlanahuatil Moisés quiselisquej tlajtlacolmacalistli yejhuan Dios quinmacas. ");
INSERT INTO nguNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, yejhuan oquitatoya Jesús ijcuac tlayohua, niman yejhuan inhuan nopohua on fariseos, oquimijlij: ");
INSERT INTO nguNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ipan totlanahuatil quijtohua ica xtihuelisquej tictlajtlacolmacasquej se tlacatl tla xachtopa ticyolcuitisquej para ticmatisquej on tlen oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Quemaj oquijlijquej: ―¿Tejhua no tihualehua ne Galilea? Xmomachti on Yectlajcuilojli, niman tiquitas ica ne Galilea xqueman hualehuaj tiotlajtojquej. ");
INSERT INTO nguNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Quemaj cada se oyaj ichan, ");
INSERT INTO nguNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","pero Jesús oyaj ne ipan on tepetl itoca Olivos. ");
INSERT INTO nguNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Huajmostla ijcuac ohuajtlanes, ocsejpa oyaj ne ipan on hueyi tiopan. Nochi tlacatl oquinisihuij, niman yejhua onotlalij niman opeu quinmachtia. ");
INSERT INTO nguNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Quemaj on temachtijquej ica on tlanahuatijli niman on fariseos ocuajhuicaquej se sihuatl yejhuan oquinextiquej ipan tlajtlacojli ihuan itlacau. Oquitlalijquej ne tlajcotian imixpan nochimej. ");
INSERT INTO nguNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Niman ijquin oquijlijquej Jesús: ―Temachtijquetl, yejhua in sihuatl oticnextijquej ihuan se tlacatl ipan tlajtlacojli. ");
INSERT INTO nguNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","On itlanahuatil Moisés technahuatia tictemojmotlasquej niman ticmictisquej in quen in sihuatl. ¿Tejhua tej, quen tiquijtohua? ");
INSERT INTO nguNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yejhuamej ijcon oquijlijquej san para oquitlatlataquej, niman ijqui ye huelisquiaj quiteixpanhuisquiaj. Pero Jesús ohuajnopachoj niman opeu tlajcuilohua ipan tlajli ican imajpil. ");
INSERT INTO nguNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero ica más quitlajtoltiayaj, yejhua ohuajnahuatequetz, niman oquimijlij: ―San aquinon yejhuan xqueman tlajtlacohua, yejhua achtoj ma quimotla. ");
INSERT INTO nguNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Niman ocsejpa onopachoj niman otlajcuiloj ipan tlajli. ");
INSERT INTO nguNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pero ijcuac yejhuamej ijcon ocacquej, oquimatquej ica oquintlajtlacolmacac intlamachilis, niman cada se de yejhuamej oquisquej. Achtoj opejquej on yejhuan más huehuetquej. Niman ijcuac nochimej yoquisquej, Jesús iselti onocau ihuan on sihuatl yejhuan ompa onocau ne ixpan. ");
INSERT INTO nguNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Quemaj Jesús ohuajnahuatequetz niman ica xoc yacaj oquitac yej san yejhua on sihuatl, oquijlij: ―Sihuatl, ¿canon nemij on yejhuan mitzteixpanhuiyaj? ¿Xacaj omitztlajtlacolmacac? ");
INSERT INTO nguNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yejhua oquijlij: ―Ca, noTeco, xacaj. Quemaj Jesús oquijlij: ―Tej, nion nejhua xnimitztlajtlacolmaca. Aman xhuiya, pero ma ca ocsejpa titlajtlacos. ");
INSERT INTO nguNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús ocsejpa oquinnotz on tlacamej niman oquimijlij: ―Nejhua quen se tlahuijli ipan in tlalticpactli yejhuan huelis quintlahuilhuis intlamachilis on tlalticpactlacamej para cajsicamatisquej. Yejhuan nechhuicas cajsicamatis tlajtlamach ica Dios niman on cajsicamatilistli quimacas yencuic nemilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ijcuacon on fariseos oquijlijquej: ―Tejhua sa no moca titlajtohua, niman on tlen tiquijtohua xmelahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús oquimijlij: ―Tlen nejhua niquijtohua quemaj melahuac masqui sa no nejhua noca nitlajtohua, pampa nicmati canon nihualehua niman canon niau. Pero nemejhuamej xnenquimatij canon nihualehua nion canon niau. ");
INSERT INTO nguNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nemejhuamej nentetlajtlacolmacaj quen on tlalticpactlacamej quichihuaj. Pero nejhua xacaj nictlajtlacolmaca. ");
INSERT INTO nguNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero tla nitetlajtlacolmacasquia, notetlajtlacolmacalis melajqui yesquia, pampa xnoselti nitetlajtlacolmacas. NoTajtzin yejhuan onechajtitlan ihuan nitetlajtlacolmacasquia. ");
INSERT INTO nguNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ipan nemotlanahuatil tlajcuilolnesticaj ijcuac omemej teixpantiliquej san se tlajtojli quijtohuaj, on tlen quijtohua melahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Sa no nejhua noca ninoteixpantilia, niman noTajtzin yejhuan onechajtitlan, no yejhua noteixpantilis. ");
INSERT INTO nguNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Quemaj oquitlajtoltijquej: ―¿Canon nemi moTajtzin? Jesús oquinnanquilij: ―Nemejhuamej xnennechixmatij, niman nion noTajtzin xnenquixmatij. Tla nennechixmatisquiaj, no nenquixmatisquiaj noTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús oquijtoj in tlajtlamach chica temachtiaya ne ijtic on hueyi tiopan campa quejehuaya on huentomin. Pero xacaj ocajsic, pampa oc xe yejcoya on tonajli para ijqui nochihuas itech. ");
INSERT INTO nguNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ocsejpa oquimijlij: ―Nejhua niau, niman nemejhuamej nennechtejtemosquej, pero nenmiquisquej ipan nemotlajtlacol. Tej, campa nejhua niau, nemejhuamej xhuelis nenyasquej. ");
INSERT INTO nguNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Quemaj on hebreos oquijtojquej: ―¿Manin yej nomictis sa no yejhua? Cas quemaj, niman yejhua ica quijtohua xhuelis tiasquej campa yejhua yas. ");
INSERT INTO nguNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús oquimijlij: ―Nemejhuamej nenquistoquej nican ipan tlalticpactli, pero nejhua onihualeu ne ilhuicac. Nemejhuamej onenhualejquej ipan in tlalticpactli, pero nejhua xonihualeu ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Onemechijlij ica nenmiquisquej ican nemotlajtlacol. Tla xnennechneltocaj ica nejhua niCristo yejhuan Dios onechtlalij para nitlamandaros, nenmiquisquej ipan nemotlajtlacol. ");
INSERT INTO nguNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Quemaj oquitlajtoltijquej: ―Tej, ¿tlen aquin tejhua? Niman Jesús oquimijlij: ―Nejhua desde ijcuac onipeu nitemachtia yonemechijlijca aquin nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nicpia miyec tlajtlamach tlen nemoca niquijtos niman tlen nemechtlajtlacoltis. Pero noTajtzin yejhuan onechajtitlan yejhua quijtohua tlen melahuac. Niman tlen niquijtohua ipan in tlalticpactli on yejhua onicac itech. ");
INSERT INTO nguNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero yejhuamej xocajsicamatquej ica quitenehuaya on iTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yejhua ica oquimijlij: ―Ijcuac nemejhuamej nennechmajmasohualtisquej ipan se cojnepanojli, nejhua yejhuan oninochiu Tlacatl, ijcuacon nenquimatisquej aquin nejhua. Niman nenquimatisquej ica xitlaj nicchihua yejhuan san nejhua nicnequi, yej san niquijtohua on tlen noTajtzin yonechmachtij. ");
INSERT INTO nguNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","On yejhuan onechajtitlan nohuan nemi. NoTajtzin xnoselti nechcahua, pampa nejhua nochipa nicchihua tlen yejhua cuelita. ");
INSERT INTO nguNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ijcuac Jesús ijquin oquijtoj, miyequej oquineltocaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Quemaj Jesús oquimijlij on hebreos yejhuan oquineltocaquej: ―Tla nenmelajcanemisquej ipan on tlen nemechijlia, nenmochihuasquej melahuac nennomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nenquixmatisquej tlen melahuac, niman on tlen melahuac yejhua mechmanahuis. ");
INSERT INTO nguNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yejhuamej oquijlijquej: ―Tejhuamej tiihuejcaconehuan Abraham niman xqueman yacaj otechpix tlanamactin. ¿Quen ijqui, tej, tiquijtohua ica ticpiasquej temanahuilistli? ");
INSERT INTO nguNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús oquimijlij: ―Ica tlen melahuac nemechijlia ica nochimej yejhuan tlajtlacohuaj, yejhuamej tlanamactin itech on tlajtlacojli. ");
INSERT INTO nguNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sen tlanamactli xqueman tehuan tlapohuajli ipan se chanyotl, pero se teconeu quemaj nochipa tehuan tlapohuajli ipan on chanyotl. ");
INSERT INTO nguNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tla nejhua yejhuan niiConeu Dios nemechmanahuis, nemejhuamej melahuac nennemisquej tlamanahuiltin intech nemotlajtlacolhuan. ");
INSERT INTO nguNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ye nicmatzticaj ica nemejhuamej nenihuejcaconehuan Abraham. Pero nenquinequij nennechmictisquej, pampa xnenquiseliaj tlen nemechijlia. ");
INSERT INTO nguNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nejhua nitlajtohua ica on tlen noTajtzin nechititia, niman nemejhuamej nenquichihuaj tlen nemotaj mechijlia. ");
INSERT INTO nguNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yejhuamej oquijlijquej: ―Tejhuamej totaj Abraham. Pero Jesús oquimijlij: ―Tla nemejhuamej melahuac nenteconehuan yesquiaj itech Abraham, nenquichihuasquiaj on tlajtlamach yejhuan oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero masqui nemechijlia on tlen melahuac yejhuan Dios yonechijlij, nemejhuamej nenquinequij nennechmictisquej. ¡Abraham xqueman itlaj ijcon oquichiu! ");
INSERT INTO nguNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nemejhuamej sa no yejhua nenquichihuaj on tlen quichihua nemotaj. Quemaj yejhuamej oquijlijquej: ―Tejhuamej xtiteichtacaconehuan. San se tajtli ticpiaj niman on yejhua Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Niman Jesús oquimijlij: ―Tla melahuac Dios nemoTaj yesquia, nemejhuamej nennechtlajsojtlasquiaj, pampa nejhua nihualehua itech Dios niman aman nican ninemi. Xonihuajlaj san pampa onicnec, yej onihuajlaj pampa Dios onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tlica xhueli nencajsicamatij on tlen nemechijlia? On pampa xnenquinequij nenquiselisquej notemachtil. ");
INSERT INTO nguNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nemejhuamej nemotaj yejhua on diablo, niman nenquinequij nenquichihuasquej tlinon yejhua quinequi. On diablo desde otzimpeu in tlalticpactli temictijquetl. Xqueman quijtohua on tlen melahuac, pampa xquipia ipan iyojlo on tlen melahuac. Ijcuac quijtohua on tlen xmelahuac, san quijtohua quen nochipa nohuica, pampa yejhua tlacajcayajquetl niman yejhua intaj on yejhuan tlacajcayahuaj. ");
INSERT INTO nguNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero nejhua pampa niquijtohua on tlen melahuac, xnennechneltocaj. ");
INSERT INTO nguNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Aquinon de nemejhuamej huelis nechititis ica nicpia se tlajtlacojli? Niman tla niquijtohua tlen melahuac, ¿tlica xnennechneltocaj? ");
INSERT INTO nguNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","On yejhuan iconehuan Dios caquij on itlajtoltzin Dios. Pero nemejhuamej xneniconehuan Dios. Yejhua ica xnenquinequij nencaquisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Quemaj on hebreos oquijlijquej: ―¿Xtiquijtohuaj tlen melahuac ijcuac tiquijtohuaj ica tejhua tisamaritano niman mojtic huajlau on xcuajli espíritu? ");
INSERT INTO nguNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús oquimijlij: ―Nejhua xhuajlau notic nion se xcuajli espíritu. Yejhua in nopanextia pampa nictlacaita noTajtzin, pero nemejhuamej xnennechtlacaitaj. ");
INSERT INTO nguNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nejhua xnictejtemohua para on tlacamej ma nechtlacaitacan. Nemi ocse yejhuan quintejtemohua tlacamej para ma nechtlacaitacan. Yejhua teyolcuitia niman tetlajtlacolmaca. ");
INSERT INTO nguNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ica tlen melahuac nemechijlia ica on yejhuan quichihua on tlen nejhua niquijtohua, xqueman miquis. ");
INSERT INTO nguNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ijcuacon on hebreos oquijlijquej: ―Aman cuajli ticmatij ica ticpia se xcuajli espíritu. Abraham niman nochimej on tiotlajtojquej omiquej, niman tejhua tiquijtohua: “Yejhuan quichihua on tlen nejhua niquijtohua, xqueman miquis.” ");
INSERT INTO nguNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tla ijcon, tejhua más tihueyixticaj xquen totaj Abraham yejhuan omic? Niman on tiotlajtojquej no omiquej. ¿Aquinon ticuitia timochihua tejhua? ");
INSERT INTO nguNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús oquimijlij: ―Tla sa no nejhua ninotlacaita, notlacaitalis xitlaj quijtosnequi. Pero noTajtzin quemaj nechtlacaita, on yejhuan nemejhuamej nenquijtohuaj ica nemoDios. ");
INSERT INTO nguNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nemejhuamej xnenquixmatij, yej nejhua quemaj niquixmati. Tla niquijtosquia xniquixmati, tla ijcon nitlacajcayajqui yesquia no quen nemehuamej. Pero nejhua melahuac niquixmati niman nicchihua nochi on tlen yejhua quijtohua. ");
INSERT INTO nguNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham on nemoachtojtaj opac pampa oquimat ica nihuajtlacatisquia ipan in tlalticpactli. Yejhua itechcopa itlaneltoc onechitac niman yejhua ica opac. ");
INSERT INTO nguNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Quemaj on hebreos oquijlijquej Jesús: ―Nion ompoajli huan matlactli xipan xe ticpia, ¿niman tiquijtohua ica otiquitac Abraham? ");
INSERT INTO nguNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús oquimijlij: ―Ica tlen melahuac nemechijlia: ijcuac Abraham xe nemiya, nejhua ye ninemiya. ");
INSERT INTO nguNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Quemaj ocontilancaj temej para quimojmotlasquiaj. Pero Jesús oniyan, niman oquisteu ne ipan on hueyi tiopan. ");
INSERT INTO nguNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ijcuac Jesús panotiaya, oquitac se tlacatl yejhuan otlacat ciego. ");
INSERT INTO nguNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Niman on inomachtijcahuan oquitlajtoltijquej: ―Temachtijquetl, ¿tlica otlacat ciego in tlacatl? ¿Tlen manin pampa otlajtlacojquej itajhuan, noso sa no yejhua otlajtlacoj? ");
INSERT INTO nguNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús oquimijlij: ―Otlacat ciego xpampa tla yejhua otlajtlacoj, noso itajhuan otlajtlacojquej. Yej ijcon otlacat para itech nopantlantis on tlen Dios hueli quichihua. ");
INSERT INTO nguNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nejhua nicchihuas itequiu on yejhuan onechajtitlan ipan in tonaltin. Tej, huajlau on tonaltin ijcuac xacaj huelis tequitis. ");
INSERT INTO nguNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Chica ninemi ipan in tlalticpactli, niquintlamachilistia on tlacamej para cajsicamatisquej tlajtlamach itech ica Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ijcuac ijcon yoquijtoj, ochijchac ipan tlajli, oquichijchiu achijtzin soquitl ican icualac, niman oquitlalilij ipan ixtololojhuan on ciego. ");
INSERT INTO nguNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Quemaj oquijlij: ―Xhuiya xmixpajpacati ne campa naltilo itoca Siloé. Siloé quijtosnequi “on yejhuan notitlani.” Yejhua ica on ciego oyaj niman onixpajpac, niman ijcuac ohuajnocuepato ye hueliya tlachaya. ");
INSERT INTO nguNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Quemaj inisiuchantlacaj niman on yejhuan quixmatiyaj ica ciego catca oquijtojquej: ―¿Tlen yejhua in tlacatl xejhua on yejhuan notlajtlanechicohuiliaya? ");
INSERT INTO nguNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sequimej quijtohuayaj: ―Quemaj, yejhua. Ocsequimej quijtohuayaj: ―Ca, xejhua, pero ijqui tlajtlachasnequi. Pero sa no yejhua quijtohuaya: ―Quemaj, melahuac nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Quemaj oquitlajtoltijquej: ―¿Quen ijqui, tej, onochiu ica aman hueli titlacha? ");
INSERT INTO nguNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yejhua oquimijlij: ―Yejhua on tlacatl yejhuan itoca Jesús oquichijchiu soquitl niman onechtlalilij ipan nixtololojhuan. Quemaj onechijlij: “Xhuiya ne campa naltilo itoca Siloé niman xmixpajpaca.” Oniaj, tej, niman ijcuac oninixpajpac, ohuel onitlachix. ");
INSERT INTO nguNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Quemaj oquitlajtoltijquej: ―¿Canon nemi on tlacatl? Yejhua oquimijlij: ―Xnicmati. ");
INSERT INTO nguNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Quemaj on yejhuan ciego catca ocuicaquej intech on fariseos. ");
INSERT INTO nguNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ijcuac Jesús oquichijchiu on soquitl niman oquixtlapoj on ciego, on tonajli catca ijcuac on hebreos nosehuiayaj. ");
INSERT INTO nguNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","On fariseos oquitlajtoltijquej on tlacatl ica quen ijqui aman hueli tlachaya. Yejhua oquimijlij: ―Onechtlalilij soquitl ipan nixtololojhuan, niman oninixpajpac, niman aman nitlacha. ");
INSERT INTO nguNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Quemaj sequimej fariseos oquijtojquej: ―On tlacatl ica ijcon oquichiu xhualehua itech Dios, pampa xquitlacamati on tlanahuatijli yejhuan technahuatia para ma ca ma titequitican ipan on tonajli ijcuac titosehuiayaj yejhuan tihebreos. Pero ocsequimej quijtohuayaj: ―¿Quen ijqui huelisquia quinchihuasquia in huejhueyi milagros tla yejhua tlajtlacolej yesquia? Niman ijquin onotlajcoxelojquej. ");
INSERT INTO nguNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Quemaj ocsejpa oquitlajtoltijquej on yejhuan ciego catca: ―Niman tejhua, ¿tlinon tiquijtohua ica on tlacatl yejhuan omitzimpajtilij mixtololojhuan? Niman yejhua oquijtoj: ―Nejhua niquijtohua ica yejhua se tiotlajtojquetl. ");
INSERT INTO nguNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero itlayecancahuan on hebreos xquinequiyaj quineltocasquej ica yejhua ciego catca niman ica aman hueliya tlacha, hasta oquinnotzquej itajhuan on yejhuan opajtic, ");
INSERT INTO nguNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","niman oquintlajtoltijquej: ―¿In yejhua nemotelpoch yejhuan nenquijtohuaj ciego otlacat? ¿Quen ijqui, tej, aman hueli tlacha? ");
INSERT INTO nguNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","On itajhuan oquijtojquej: ―Ticmatij ica in yejhua totelpoch niman ica ciego otlacat. ");
INSERT INTO nguNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero xticmatij quen ijqui aman hueli tlacha, nion xticmatij aquinon oquimpajtilij ixtololojhuan. Yejhua xtlajtoltican. Yejhua xoc conetl niman sa no yejhua huelis mechijlis quen ijqui opajtic. ");
INSERT INTO nguNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","On itlayecancahuan hebreos yonotlajtolmacacaj para cuajquixtisquej ne tiopan san aquinon yejhuan quiteixpantilis ica Jesús yejhua Cristo. Yejhua ica ijcon oquijtojquej on itajhuan pampa quinmacajsiyaj itlayecancahuan on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yejhua ica itajhuan oquijtojquej: “Yejhua xtlajtoltican. Yejhua xoc conetl.” ");
INSERT INTO nguNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Quemaj on hebreos ocsejpa oquinotzquej on tlacatl yejhuan ciego catca, niman oquijlijquej: ―Xtechijli ixpan Dios tlen melahuac. Tejhuamej ticmatztoquej ica on tlacatl tlajtlacolej. ");
INSERT INTO nguNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ijcuacon yejhua oquimijlij: ―Nejhua xnicmati tla yejhua tlajtlacolej noso ca. Yej tlinon nejhua nicmatzticaj, niciego catca niman aman nitlacha. ");
INSERT INTO nguNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Niman ocsejpa oquitlajtoltijquej: ―¿Tlinon omitzchihuilij? ¿Quen ijqui oquichiu para omitzimpajtilij mixtololojhuan? ");
INSERT INTO nguNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Oquimijlij: ―Yonemechijlij niman xnennechneltoquiliaj. ¿Tlica ocsejpa nenquinequij ma nemechijli? ¿Tlen no nenquinequij neninomachtijcahuan yesquej? ");
INSERT INTO nguNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Quemaj ocajhuaquej, niman oquijlijquej: ―Tejhua tiinomachtijcau yejhua on tlacatl, pero tejhuamej tiinnomachtijcahuan Moisés. ");
INSERT INTO nguNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tejhuamej ticmatztoquej ica Dios oquinotz Moisés, pero yejhua on tlacatl, nion achijtzin xticmatij canon hualehua. ");
INSERT INTO nguNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","On tlacatl ijcuacon oquimijlij: ―¡Yejhua in nechtlatlachaltia ica nemejhuamej xnenquimatij canon hualehua niman nejhua onechimpajtilij nixtololojhuan! ");
INSERT INTO nguNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cuajli ticmatztoquej ica Dios xquincaqui on tlajtlacolejquej, yej san quincaqui on yejhuan quitlacaitaj niman quichihuaj on tlen yejhua quinequi. ");
INSERT INTO nguNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Xqueman oticaquej tla yacaj quimpajtilia ixtololojhuan se tlacatl yejhuan otlacat ciego. ");
INSERT INTO nguNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tla yejhua in tlacatl xhualehuasquia itech Dios, xhuelisquia itlaj quichihuasquia. ");
INSERT INTO nguNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Quemaj oquijlijquej: ―Tejhua yejhuan otitlacat tenticaj ican tlajtlacojli, ¿ticnemilia yej tejhua titechmachtis? Niman ocuajquixtijquej ipan on tiopan. ");
INSERT INTO nguNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús oquimat ica on yejhuan ciego catca ocuajquixtijquej ne ipan on tiopan. Niman ijcuac oquinamic, oquijlij: ―¿Ticneltoca iConetzin Dios? ");
INSERT INTO nguNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","On tlacatl oquijlij: ―Señor, xnechijli aquinonon para huelis nicneltocas. ");
INSERT INTO nguNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús oquijlij: ―Yotiquitaca, niman sa no nejhua yejhuan ihuan titlajtojticaj. ");
INSERT INTO nguNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Quemaj on tlacatl onotlacuenquetz ixpan Jesús, niman oquijlij: ―NoTeco, nimitzneltoca. ");
INSERT INTO nguNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Quemaj oquijtoj Jesús: ―Nejhua onihuajlaj ipan in tlalticpactli para niquintlaxtlahuilis on tlacamej quen nonequi quiselisquej. On yejhuan xhuelij cajsicamatij on tlajtlamach ica Dios, yejhuamej niquimpalehuis para huelis cajsicamatisquej. Niman on yejhuan notenehuaj cajsicamatij, masqui xnejli, xniquimpalehuis para ma cajsicamatican. Ijcon tej, yejhuamej quen ciegos impan intlamachilis pampa xcajsicamatij on tlajtlamach itech ica Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Quemaj sequimej fariseos yejhuan ompa ihuan nemiyaj, ijcuac ijcon ocacquej, oquitlajtoltijquej: ―¿Tiquijtosnequi ica tejhuamej quen ticiegos impan totlamachilis niman yejhua ica xticajsicamatij on tlajtlamach itech ica Dios? ");
INSERT INTO nguNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús oquimijlij: ―Tla xnencajsicamatisquiaj, xnenquipiasquiaj tlajtlacojli. Pero pampa nenquijtohuaj ica nencajsicamatij, on tlajtlacojli nemopan oncaj. ");
INSERT INTO nguNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ica tlen melahuac nemechijlia, on yejhuan xcalaquis ipan itlatzacuilyou on corral campa nemij borregos, yej calaquis san canon, yejhua tlachtequetl. ");
INSERT INTO nguNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero on yejhuan calaquis ipan on tlatzacuilyotl, yejhua tlajpixqui ica on borregos. ");
INSERT INTO nguNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Se tlacatl quitlapohuilia on tlatzacuilyotl para ma calaqui on tlajpixqui. Quemaj on borregos yejhuan iyaxcahuan quitencaquij ijcuac quintocayotia. Quemaj quinquixtia. ");
INSERT INTO nguNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Niman quemaj ijcuac yoquinhuajquixtij nochimej iborregos, nejnemi inyecapan, niman on borregos quicuitlapanhuiaj pampa quitencaquij itlajtol. ");
INSERT INTO nguNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero yejhuan xquixmatij xquicuitlapanhuiaj, yej ontlatlacsaj pampa xquitencaquij on yejhuan xquixmatij. ");
INSERT INTO nguNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús oquintlalilij yejhua in ejemplo, pero yejhuamej xocajsicamatquej tlinon quinequiya quimijlis. ");
INSERT INTO nguNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yejhua ica Jesús ocsejpa oquimijlij: ―Ica tlen melahuac nemechijlia: nejhua nitlatzacuilyotl campa calaquij on borreguitos. ");
INSERT INTO nguNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nochimej yejhuan achtoj de nejhua ohualajquej tlachtequej, pero on borregos xoquitencaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nejhua nitlatzacuilyotl. Yejhuan notechcopa calaquis, nomaquixtis. Niman yejhua yes quen on se borrego yejhuan calaqui niman quisa ipan on corral niman quinextia tlen quicua. ");
INSERT INTO nguNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","On tlachtequetl huajlau san para tlachtequi, temictia niman tlaxoxotonia. Pero nejhua onihuajlaj para quipiasquej nemilistli, niman ipan innemilis nochi cuajli quisas. ");
INSERT INTO nguNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","’Nejhua nicuajli tlajpixqui. On cuajli tlapixqui quitemaca inemilis impampa on borregos. ");
INSERT INTO nguNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero on yejhuan tequiti san pampa quitlaxtlahuiliaj, ijcuac quita huajlau on yolqui lobo, quincahua on borregos niman cholojtehua, pampa yejhua xtlajpixqui niman on borregos xiyaxcahuan. Quemaj on yolquej quinmajsi on borregos niman quinchajchayahuaj. ");
INSERT INTO nguNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yejhua in tlacatl cholojtehua pampa tequiti san ica quitlaxtlahuiliaj, niman para yejhua xitlaj quijtosnequi on borregos. ");
INSERT INTO nguNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nejhua nicuajli tlajpixqui. Ijcon quen noTajtzin nechixmati niman nejhua niquixmati, no ijqui niquinmixmati noborregos, niman yejhuamej no nechixmatij. Niman impampa on noborregos nictemaca nonemilis. ");
INSERT INTO nguNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","No niquimpia ocsequimej borregos yejhuan xtlapohualti ipan in corral. No ica oncaj niquinhuajhuicas. Yejhuamej cuajli quitencaquisquej notlajtol niman nechtlacamatisquej. Ijcon, tej, san secan nemisquej niman no san se tlapixqui nemis. ");
INSERT INTO nguNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’NoTajtzin nechtlajsojtla pampa nictemaca nonemilis para noborregos. Niman quemaj ocsejpa ninoyolihuitis. ");
INSERT INTO nguNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Xacaj nechcuilia nonemilis, yej nejhua nictemaca ican cuajli noyojlo. Nihueli nictemacas nonemilis, niman no nihueli ocsejpa ninoyolitis. Ijcon noTajtzin onechnahuatij para nicchihuas. ");
INSERT INTO nguNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ijcuac on hebreos ocacquej on tlajtoltin, ocsejpa xoquipixquej san se inyojlo. ");
INSERT INTO nguNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Miyequej yejhuamej quijtohuayaj: ―¿Tlica nenquicaquij in tlacatl? Yejhua quipia se xcuajli espíritu niman loco. ");
INSERT INTO nguNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero ocsequimej quijtohuayaj: ―Xacaj yejhuan quipia se xcuajli espíritu hueli ijcon tlajtohua. ¿Tlen hueli se xcuajli espíritu quimpajtia imixtololojhuan on coxcatzitzintin? ");
INSERT INTO nguNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Niman ne Jerusalén quipanoticatcaj on ilhuitl yejhuan nochihuaya para quimelnamictia on tlacamej ijcuac on tiopan yencuic catca. Ijcuacon invierno ijcuac sehua catca. ");
INSERT INTO nguNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús quistinemiya ne ipan on icorredor on hueyi tiopan itoca Icorredor Salomón. ");
INSERT INTO nguNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Niman on hebreos oquiteyehualojquej, niman oquijlijquej: ―¿Hasta quemanon titechometlamachilispias? Tla tejhua tiCristo, amantzin cuajli xtechijli. ");
INSERT INTO nguNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús oquimijlij: ―Yonemechijlij niman xonennechneltocajquej. On tlajtlamach yejhuan nicchihua ipan itocatzin noTajtzin nechteixpantiaj aquin nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero nemejhuamej xnennechneltocaj pampa xnentejhuamej nentlapohualtin intech on noborregos. ");
INSERT INTO nguNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Noborregos nechtencaquij, niman nejhua niquimixmati niman nechcuitlapanhuiaj. ");
INSERT INTO nguNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nejhua niquinmaca on nemilistli yejhuan para nochipa, niman yejhuamej xqueman miquisquej, niman xacaj huelis nechincuijcuilis. ");
INSERT INTO nguNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","NoTajtzin yejhuan onechinmacac noborregos, yejhua más hueyi xquen yacaj ocse. Yejhua ica xacaj huelis quintecuilis itech. ");
INSERT INTO nguNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nejhua niman noTajtzin san se tinemij. ");
INSERT INTO nguNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Quemaj on hebreos ocsejpa ocontilanquej temej para quimojmotlasquiaj. ");
INSERT INTO nguNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Niman Jesús oquimijlij: ―Nemixpan yonicchiu miyec tlajtlamach tlen cuajli itechcopa ipoder noTajtzin. ¿Catlejhua de in tlajtlamach ica nennechmojmotlasnequij? ");
INSERT INTO nguNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","On hebreos oquijlijquej: ―Nion se ica on tlen cuajli oticchiu timitzmojmotlasnequij, yej pampa ticuijhuicaltia Dios ican motlajtol. Tejhua san titlacatl, pero timotenehua tiDios. ");
INSERT INTO nguNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús ijcuacon oquimijlij: ―Ipan nemotlanahuatil tlajcuilolnesticaj ica Dios oquijtoj: “Nemejhuamej nendioses.” ");
INSERT INTO nguNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ticmatij ica tlen quijtohua on Yectlajcuilojli xqueman huelis nopatlas. Dios oquintocayotij dioses yejhuamej on tlacamej yejhuan oquiselijquej itlajtoltzin. ");
INSERT INTO nguNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yejhua ica, tej, tla Dios onechtlapejpenij niman onechajtitlan ipan in tlalticpactli, ¿quen ijqui, tej, hueli nenquijtohuaj ica nicuijhuicaltia pampa oniquijtoj ica niiConeu? ");
INSERT INTO nguNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tla xnicchihua itequiu noTajtzin, ma ca xnechneltocacan. ");
INSERT INTO nguNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero tla melahuac nicchihua itequiu, xneltocacan impampa on tlen tlajtlamach nicchihua masqui xnenquinneltocaj on tlen onemechijlij. Ijcon tej, xneltocacan para xmatican ica melahuac noTajtzin san se nohuan nemi, niman nejhua san se ihuan ninemi noTatzin. ");
INSERT INTO nguNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ocsejpa quinequiyaj cajsisquej, pero Jesús ocholojteu intech. ");
INSERT INTO nguNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Quemaj Jesús onocuep para oyaj ne ica iquisayan tonajli de on atentli Jordán niman onocau campa otlacuatequij Juan. ");
INSERT INTO nguNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Miyec tlacatl oyaj oquitatoj, niman quijtohuayaj: ―Masqui Juan xitlaj tlamajhuisojli oquichiu, nochi tlen oquijtoj ica in tlacatl melahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Niman ompa miyequej oquineltocaquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nemiya se tlacatl itoca catca Lázaro yejhuan cualohuaya. Yejhua chanej catca ne ipan on pueblo itoca Betania yejhuan no ipueblo María niman icniu Marta. ");
INSERT INTO nguNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Yejhua in María yejhua on yejhuan oquitequilijca toTeco, on ajhuiyalistli itoca nardo ipan icxihuan niman oquinhuajhuatz ican itzon. In María icniu Lázaro yejhuan cualohuaya. ");
INSERT INTO nguNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","On omemej sihuamej icniutin otlatitlanquej ma quijlitij Jesús: ―ToTeco, on motejtlajsocau cualo. ");
INSERT INTO nguNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ijcuac Jesús ijcon ocac, oquijtoj: ―Yejhua on cualolistli xquimictis, yej san para noteititis ihueyilis Dios niman no itechcopa nechteititis nohueyilis nejhua yejhuan niiConeu Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús quitlajsojtlaya Marta inhuan icnihuan María niman Lázaro. ");
INSERT INTO nguNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero masqui oquijlijquej ica Lázaro cualohuaya, ome tonajli más onocau ne campa nemiya. ");
INSERT INTO nguNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Quemaj oquimijlij on inomachtijcahuan: ―Ma tihuian ne Judea ocsejpa. ");
INSERT INTO nguNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ijcuacon on nomachtijquej oquijlijquej: ―Temachtijquetl, san quemach catca on hebreos yejhuan ompa chanejquej quinequiyaj mitzmictisquej ican temej, ¿niman ocsejpa ticnequi tias ompa? ");
INSERT INTO nguNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús oquimijlij: ―¿Tlica xmelahuac quipia majtlactli huan ome horas on tonajli? Tej, tla se quistinemi ican tonajli, xnajantiquisa pampa nochi nesi ican on tlahuijli yejhuan oncaj ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero tla se quistinemi ican yehuajli, najantiquisa pampa quipolohua tlahuijli. ");
INSERT INTO nguNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Quemaj oquimijlij Jesús: ―Totetlajsojcau Lázaro cochi, pero nicontlachaltis. ");
INSERT INTO nguNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Quemaj on nomachtijquej oquijlijquej: ―ToTeco, tla san yococh, quijtosnequi huelis pajtis. ");
INSERT INTO nguNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero Jesús quijtosnequiya ica Lázaro yomic, niman on nomachtijquej quinemiliayaj ica Lázaro san cochiya. ");
INSERT INTO nguNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yejhua ica Jesús más cuajli oquimijlij: ―Lázaro yomic. ");
INSERT INTO nguNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Más cuajli para nemejhuamej ica xompa ninemiya ijcuac Lázaro cualohuaya, pampa aman huelis nicchihuas itlaj yejhuan mechpalehuis nentlaneltocasquej. Yejhua ica nipaqui. Ma tihuian, ma tiquitatij. ");
INSERT INTO nguNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Quemaj Tomás, yejhuan no quijliayaj cohuatzin, oquimijlij on ocsequimej nomachtijquej: ―No ma tihuian para san secan ihuan Jesús timiquisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ijcuac Jesús oajsic oquimachiltijquej ica Lázaro ye quipia nahui tonajli ica tlaltoctoc. ");
INSERT INTO nguNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania nisiu Jerusalén catca. San quipiaya canaj ome kilómetro huan tlajco ica huejca, ");
INSERT INTO nguNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","niman miyequej hebreos oyajquej quinnotzatoj Marta niman María para quinyoltlalisquej pampa omic inicniu. ");
INSERT INTO nguNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ijcuac Marta oquimat ica Jesús ompa ye ajsitiaya, oquis oquinamiquito, pero María onocau ne inchan. ");
INSERT INTO nguNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Niman Marta oquijlij Jesús: ―NoTeco, tla nican tinemisquia, nocniu xmiquisquia. ");
INSERT INTO nguNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero nejhua nicmatzticaj ica Dios mitzmacas nochi tlen tictlajtlanilis. ");
INSERT INTO nguNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús oquijlij: ―Mocniu ocsejpa yolihuis. ");
INSERT INTO nguNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta oquijlij: ―Quemaj, nejhua nicmatzticaj ica ocsejpa yolihuis ijcuac yolihuisquej niman noquetztehuasquej on mimiquej ipan on sa ica nochi tonajli. ");
INSERT INTO nguNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Quemaj Jesús oquijlij: ―Nejhua niquinyolihuitia on yejhuan mimiquej niman niquinmaca nemilistli ocsejpa. Yejhuan nechneltocas, masqui miquis, nemis ocsejpa. ");
INSERT INTO nguNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Niman nochi yejhuan sanquen nemi niman nechneltoca, nemis para nochipa ne ilhuicac. ¿Ticneltoca yejhua on? ");
INSERT INTO nguNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Yejhua oquijlij: ―Quemaj noTeco. Nejhua nicneltoca ica tejhua tiCristo yejhuan Dios ocuajtitlan para tlamandaros. Niman nicneltoca ica tejhua tiiConeu Dios yejhuan ye ijqui oncatca para huajlas ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ijcuac ijcon yoquijtoj, Marta oyaj oquinotzato on icniu María, niman san oquichtacaijlij yejhua in: ―On Temachtijquetl nican nemi niman mitznotza. ");
INSERT INTO nguNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ijcuac María ijcon ocac, nimantzin onotelquetz niman oyaj oquitato Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús oc xe calaquiya ne ipan on pueblo, yej nemiya campa Marta oquinamiquito. ");
INSERT INTO nguNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Niman ijcuac on hebreos yejhuan quiyoltlaliayaj María ne ichan oquitaquej ica María nimantzin oquis, oquicuitlapanhuiquej. Yejhuamej quinemiliayaj ica María yau ne itech on tlalcontli para ompa onchocas. ");
INSERT INTO nguNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Quemaj, ijcuac oajsic ne campa nemiya Jesús, María onotlacuenquetz icxitlan, niman oquijlij: ―NoTeco, tla nican tinemisquia, nocniu xmiquisquia. ");
INSERT INTO nguNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ijcuac Jesús oquitac ica María niman on hebreos yejhuan ompa ihuan oyejcoquej sanoyej chocaj, sanoyej onajman niman onomau inhuan, ");
INSERT INTO nguNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","niman oquintlajtoltij: ―¿Canon onenquitocaquej? Niman oquijlijquej: ―ToTeco, xhuajla xquitaqui. ");
INSERT INTO nguNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Niman Jesús ochocac. ");
INSERT INTO nguNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Quemaj on hebreos oquijtojquej: ―Xquitacan quen sanoyej quitlajsojtlaya. ");
INSERT INTO nguNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero semej yejhuamej oquijtojquej: ―In yejhuan oquimpajtij ixtololojhuan on ciego, ¿xhuelisquia itlaj quichihuasquia para Lázaro ma ca miquisquia? ");
INSERT INTO nguNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús ican miyec iyolquexanalis oquinisihuij on tlalcontli. On tlalcontli se teostotl catca niman quipiaya se tetl yejhua quitzacuticatca on itenco. ");
INSERT INTO nguNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús oquijtoj: ―Xquejcuanican on tetl. Pero Marta yejhuan icniu on micatzintli, oquijlij: ―NoTeco, amantzin sanoyej yomoloniac pampa ye quipia nahui tonajli ica omic. ");
INSERT INTO nguNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero Jesús oquijlij: ―¿Tlen xonimitzijlij ica tla titlaneltoca tiquitas ihueyilis Dios? ");
INSERT INTO nguNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Quemaj oquejcuanijquej on tetl. Niman Jesús oajcotlachix ne ilhuicac, niman oquijtoj: ―NoTajtzin, nimitzmaca tlaxtlahuijli pampa tinechcaqui. ");
INSERT INTO nguNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nejhua nicmatzticaj ica nochipa tinechcaqui, pero aman ijquin niquijtohua impampa in tlacamej yejhuan nican nemij, para ma quineltocacan ica tejhua otinechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ijcuac ijcon oquijtoj, quemaj ica chicahuac tlajtojli oquinotz: ―¡Lázaro, xhuajquisa on pon! ");
INSERT INTO nguNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Niman on micatzintli ohuajquis ipan imahuan niman icxihuan tecuixticatca ican ilpicatl niman ixayac tecuixticatca ican tlaquentli. On hebreos ijcon quitequitiltiayaj ijcuac quintejcuiyaj on mimiquej. Jesús oquimijlij: ―Xtojtomacan niman xcahuilican ma huia. ");
INSERT INTO nguNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Miyequej hebreos yejhuan ohualejquej ihuan María oquineltocaquej ijcuac oquitaquej on tlen Jesús oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero sequimej oyajquej oquintatoj on fariseos niman oquintlajtlajtohuilijquej on tlen Jesús oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yejhua ica on fariseos niman intlayecancahuan on tiopixquej onosentlalijquej inhuan on tetlacanonotzquej niman oquijtojquej: ―¿Tlinon ticchihuasquej? Yejhua in tlacatl quichijticaj miyec milagros. ");
INSERT INTO nguNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tla ijqui ticahuilisquej ma quichihua, nochi tlacatl quineltocas niman on romanos quixoxotonisquej tohueyi tiopan niman in topaís. ");
INSERT INTO nguNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero se de yejhuamej, itoca Caifás, yejhuan ipan on xipan on más hueyi intlayecancau catca intech on tiopixquej, oquimijlij: ―Nemejhuamej xitlaj nenquimatij. ");
INSERT INTO nguNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nemejhuamej xnencajsicamatij ica para tejhuamej más cuajli yes tla se tlacatl miquis para ma ca quixoxotonisquej nochi in país. ");
INSERT INTO nguNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero Caifás ijcon oquijtoj xpampa melahuac ijqui oquis ipan iyojlo. Yejhua oquijtoj pampa yejhua on más hueyi intlayecancau catca intech on tiopixquej ipan on xipan, niman Dios oquitlamachilistij para ma quijto ica Jesús miquis ipampa on país campa chanejquej on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Niman ijcon oquijtoj xsan ipampa on país, yej no para quinsentlalis nochimej on iconehuan Dios yejhuan nochajchayajtinemij. ");
INSERT INTO nguNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yejhua ica desde ipan on tonajli on tequihuajquej hebreos oquinejnemilijquej quen ijqui quimictisquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yejhua ica, tej, Jesús xoc quistinemiya ne intzajlan on hebreos, yej oquis ne Judea niman oyaj ne ipan se pueblo itoca Efraín yejhuan nisiu tlapatlaco. Ompa onocau inhuan inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ye nisiu catca para on hebreos quichihuasquej on ilhuitl pascua, niman miyec tlacatl yejhuan hualehuayaj nochihuiyan ipan on país oyaj ne Jerusalén para nochipahuasquej quen intlanahuatil on hebreos tlanahuatia. ");
INSERT INTO nguNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesús quitejtemojtinemiyaj. Niman ijcuac ye nemiyaj ne ipan on hueyi tiopan, ijquin quinotlajtoltiayaj: ―¿Tlinon nenquinemiliaj? ¿Nenquinemiliaj ica huajlas ipan in ilhuitl, noso ca? ");
INSERT INTO nguNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","On fariseos niman intlayecancahuan on tiopixquej yotlanahuatijcaj ica tla se quimati canon nemi Jesús, ma quitemachiltican para huelis cajsisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chicuasen tonajli polihuia ica ajsis on ilhuitl pascua, Jesús oyaj ne ipan on pueblo itoca Betania. Lázaro on tlacatl yejhuan Jesús yoquiyolitijca niman yoquetztejca ne ipan itlalcon, chantiya ipan on pueblo. ");
INSERT INTO nguNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ompa oquichijchiquej se tlacuajli para quitlajsojcamachilisquej Jesús ica on tlen oquichiu. Marta quintlamacaya niman Lázaro tehuan ompa ihuan tlacuajticatca ipan on mesa. ");
INSERT INTO nguNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Quemaj María ocuajquic canaj tlajco litro ajhuiyalistli itoca nardo, yejhuan sanoyej patioj. Niman ican on ajhuiyalistli oquimaltij icxihuan Jesús niman quemaj oquinhuajhuatz ican itzon. Ijtic on cajli oten ican iajhuiyalis on ajhuiyalistli. ");
INSERT INTO nguNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Quemaj Judas Iscariote, iconeu Simón, yejhuan no tehuan tlapohuajli catca intech on majtlactli huan ome inomachtijcahuan Jesús niman sa no yejhua, yejhuan quitemactilis, oquijlij: ");
INSERT INTO nguNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Tlica xmás cuajli nonamacasquia in ajhuiyalistli ica yeyi ciento denarios niman ica on tomin tiquimpalehuisquiaj on mayanquej? ");
INSERT INTO nguNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero Judas ijcon oquijtoj xpampa melahuac quimicneliaya on mayanquej, yej pampa yejhua tlachtequetl. Yejhua quejehuaya on bolsa ican tomin niman quichtequiya sequi on tlen ipan on bolsa quitlaliayaj. ");
INSERT INTO nguNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Quemaj Jesús oquijlij: ―Ma ca xpajsolo. Yejhua quejehuaya in ajhuiyalistli para nechmatlalosquia ipan notlalnacayo ipan on tonajli ijcuac nechtocasquej ne ipan notlalcon. ");
INSERT INTO nguNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nochipa nemotzajlan nenquimpiasquej on mayanquej, pero nejhua xnochipa nican nennechpiasquej. ");
INSERT INTO nguNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Miyequej on hebreos oquimatquej ica Jesús nemiya ne Betania niman ompa oyajquej. Oyajquej xsan para contasquej Jesús, yej no para contasquej Lázaro yejhuan Jesús oquiyolihuitij niman oquetzteu ne intzajlan on mimiquej. ");
INSERT INTO nguNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yejhua ica intlayecancahuan on tiopixquej oquitlalijquej inyojlo para no quimictisquiaj Lázaro, ");
INSERT INTO nguNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","pampa san yejhua ipampa miyequej on hebreos ye notzijtzinquixtiayaj ne intech niman yej quineltocayaj Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Huajmostla miyec tlacatl yejhuan ye nemiya ne Jerusalén para quipanosquej on ilhuitl pascua ocacquej ica Jesús ajsis ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yejhua ica oquitequej imahuan on soyatl niman oquisquej oquinamiquitoj Jesús. Yejhuamej ijquin tzajtzitiayaj: ―¡Ma quiseli yectenehualistli! ¡Ma Dios quitiochihua yejhua on yejhuan hualajticaj ican itocatzin toTeco! ¡Ma Dios quitiochihua on iRey Israel! ");
INSERT INTO nguNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús oquinextij se poloco niman ipan otlejcoc quen quijtohua on Yectlajcuilojli: ");
INSERT INTO nguNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ma ca xmomojtican nemejhuamej yejhuan nenchantij ipan on hueyican itoca Sión. Xquitacan, nemoRey. Hualetiu ipan se poloco. ");
INSERT INTO nguNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ijcuac on onochiu, inomachtijcahuan Jesús xocajsicamatquej on tlajtlamach. Pero ijcuac Jesús otlejcoc ne ilhuicac, oquelnamiquej ica nochi yejhua on ye ijqui tlajcuilolnesticatca yejhua itech, niman ica ijqui mero ipan onochiu. ");
INSERT INTO nguNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","On tlacamej yejhuan ihuan Jesús nemiyaj ijcuac oconotz Lázaro ne ipan itlalcon ijcuac oquiyolitij niman oquetzteu, quitetlajtlajtohuiliayaj nochi tlen oquitaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yejhua ica miyec tlacatl oyajquej quinamiquitoj Jesús pampa oquimatquej on milagros yejhuan oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Quemaj on fariseos oquinojlijquej: ―¡Xquitacan, xitlaj otictlanquej! ¡Xquitacan, nochi tlacatl ipan in tlalticpactli oquiselijquej yejhua! ");
INSERT INTO nguNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Intzajlan on tlacamej yejhuan oyajquej Jerusalén para quimahuistiliaj Dios ipan on ilhuitl, nemiyaj sequimej yejhuan chanejquej catcaj ne Grecia. ");
INSERT INTO nguNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yejhuamej oquinisihuijquej Felipe yejhuan chanej catca ne Betsaida de Galilea, niman ijquin oquijlijquej: ―Señor, ticnequij tiquitasquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe oyaj niman oquitlajtlajtohuilij Andrés on tlen oquijlijquej. Niman quemaj on omemej san secan oyajquej oquitlajtlajtohuilitoj Jesús on tlen quijtohuayaj. ");
INSERT INTO nguNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Niman Jesús oquimijlij: ―Yoyejcoc on tonajli ijcuac nejhua yejhuan oninochiu Tlacatl nechhueyilisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ica tlen melahuac nemechijlia ica tla xachtopa nimiquis, xhuelis nictemacas yencuic nemilistli. Nejhua no niijqui quen se iteyo on trigo. Tla se iteyo on trigo xnotoca ipan tlajli, xhueli quitlaquitia miyec, yej nocahua iselti. Pero tla notoca ipan tlajli, tla ijcon, noscaltia niman quitlaquitia miyec. ");
INSERT INTO nguNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yejhuan quichihua canica para ma ca quipolos inemilis ipampa Cristo xquipias nemilistli yejhuan para nochipa. Pero on yejhuan quitemaca inemilis ipampa Cristo, quiselis nemilistli para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tla yacaj quinequi nechtequipanos, ica oncaj yas nohuan, niman ijcon campa nejhua ninemis, no ompa nemis on yejhuan nechtequipanos. Tla yacaj nechtequipanos, noTajtzin quitlacaitas. ");
INSERT INTO nguNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Aman sanoyej ninoyolcocohua. ¿Tlinon niquijlis noTajtzin? ¿Niquijlis: “NoTajtzin, xnechmanahui itech on tlajyohuilistli tlen aman nopan nochihuas”? ¡Ca! Xijcon niquijlis pampa yejhua ica on onihuajlaj ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","NoTajtzin, xchihua para ma mitzhueyilican. Quemaj ocaquistic se tlajtojli ne ilhuicac yejhuan oquijtoj: “Yonicchiu para ma nechhueyilican, niman ocsejpa nicchihuas para ma nechhueyilican.” ");
INSERT INTO nguNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Niman on tlacamej yejhuan ompa tlacacticatcaj oquijtojquej ica ocaquistic se tlacomonajli, niman ocsequimej quijtohuayaj ica se ilhuicactequitquetl ocuajnotz. ");
INSERT INTO nguNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Quemaj Jesús oquimijlij: ―On tlajtojli ocaquistic xpara nejhua nicaquis, yej para nemejhuamej nencaquisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aman yoyejcoc on tonaltin ijcuac Dios quinyolcuitis niman quintlaxtlahuilis nochimej in tlalticpactlacamej. Niman aman yejhua quixtilis itequihuajyo on yejhuan itequihua in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Niman ijcuac nechmajmasohualtisquej ipan cojnepanojli nican ipan in tlalticpactli, sa no nejhua niquinyoltilanas nochimej notech. ");
INSERT INTO nguNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ijcuac ijcon oquijtoj, oquitecaquistilij quen miquis ipan on cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Niman ijcuac on tlacamej ijcon ocacquej, oquijlijquej: ―On Yectlajcuilojli techmachiltia ica Cristo nemis para nochipa. Yejhua ica ¿tlica, tej, tejhua tiquijtohua ica on yejhuan onochiu Tlacatl ica oncaj cajcopilosquej? ¿Aquinon on yejhuan onochiu Tlacatl? ");
INSERT INTO nguNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ijcuacon Jesús oquimijlij: ―Nejhua yejhuan nitequichihua para cajsicamatisquej on tlajtlamach ica Dios nemis nemotzajlan san quesqui tonaltin más. Yejhua ica xselican on tlaixmachilistli chica nenhuelij para ma ca on xtlaixmachilistli tetlanis. Yejhuan xcajsicamati, xquimati canica yau. ");
INSERT INTO nguNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nejhua nitequichihua para cajsicamatij tlajtlamach itech ica Dios. Yejhua ica, chica ninemi nemotzajlan, xnechneltocacan para nenquipiasquej tlaixmachilistli. Ijcuac Jesús otlan quijtohua in tlajtlamach, oyaj niman yejhuamej xoc oquimatquej canica oyaj. ");
INSERT INTO nguNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Masqui Jesús oquichiu miyec milagros imixpan, xquineltocayaj. ");
INSERT INTO nguNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ijcon yej oncatca para nochihuas on tlen oquijcuiloj on tiotlajtojquetl Isaías: ToTeco, ¿aquinon yoquineltocac totemachtil? Masqui oquitaquej mopoder, ¿aquinon tlaneltoca? ");
INSERT INTO nguNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","No xhueliyaj quineltocayaj, pampa Isaías ijquin no oquijcuilojca: ");
INSERT INTO nguNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios oquinciegotilij niman oquinyoltechijcau. Ijquin oquichiu para ma ca ma cajsicamatican tlinon quijtosnequi on tlen oquitaquej, niman ma ca tlaneltocasquej impan inyojlo, niman para ma ca ma huajnocuepacan notech para niquintlapojpolhuis. ");
INSERT INTO nguNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yejhua in tlajtlamach oquijtoj Isaías pampa oquitac ihueyilis Jesús niman otlajtoj ica yejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Masqui ijcon, miyequej on hebreos oquineltocaquej Jesús, hasta on yejhuan tequihuajquej. Pero xquipantlantiayaj intlaneltoc pampa quinmacajsiyaj ica on fariseos quinhuajquixtisquej ipan on tiopan. ");
INSERT INTO nguNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ijcon, tej, xquipantlantiayaj intlaneltoc pampa yejhuamej más cuelitayaj para tlacamej ma quintlacaitacan xej para Dios ma quintlacaita. ");
INSERT INTO nguNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús oquijtoj ican chicahuac tlajtojli: ―Yejhuan nechneltoca xsan nejhua nechneltoca, yej no quineltoca noTajtzin yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Niman on yejhuan nechita no quita on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nejhua onihuajlaj ipan in tlalticpactli para nictemacas cajsicamatilistli, niman ijcon, tej, san aquinon yejhuan nechneltocas quiselis tlamachilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tla yacaj caqui notlajtol niman xquitlacamati, xnejhua niquiyolcuitis nion niquitlajtlacolmacas, pampa nejhua onihuajlaj xpara niquinyolcuitis niman niquintlajtlacolmacas in tlalticpactlacamej, yej para niquinmaquixtis. ");
INSERT INTO nguNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero ye nemi aquin quiyolcuitis niman quitlajtlacolmacas on yejhuan xnechselia niman xquitlacamati notlajtol. On tlajtojli yejhuan yoniquijtoj on yejhua quiyolcuitis niman quitlajtlacolmacas ipan on sa ica nochi tonajli. ");
INSERT INTO nguNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ijcon nochihuas pampa nejhua xniquijitohua on tlen nicnemilia, yej noTajtzin, yejhuan onechajtitlan, onechnahuatij yejhua ica on tlen niquijtos niman nicteititis. ");
INSERT INTO nguNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Niman nicmatzticaj ica on tlen noTajtzin onechnahuatij para nemechijlis, quitemaca on nemilistli yejhuan para nochipa. Yejhua ica on tlen nejhua niquijtohua, niquijtohua quen yejhua onechijlij. ");
INSERT INTO nguNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sa se tonajli polihuiya ijcuac on hebreos quipanohuaj on ilhuitl itoca pascua. Jesús quimatzticatca ica yoyejcoc on tiempo para yejhua cajtehuas in tlalticpactli niman yas itech iTajtzin. Yejhua nochipa oquintlajsojtlac on iyaxcahuan yejhuan nemij ipan in tlalticpactli, pero aman quintitiaj quech ica sanoyej quintlajsojtla. ");
INSERT INTO nguNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","On diablo yoquitlalijca ipan iyojlo Judas Iscariote, itelpoch Simón, on tlamachilistli para quitemacas Jesús intech on tlayecanquej hebreos. Jesús quimatzticatca ica sa no yejhua ohualeu ne itech Dios, niman ica ocsejpa yas itech. No ijqui quimatzticatca ica toTajtzin yoquimacac nochi tlanahuatijli. Yejhua ica, ijcuac tlacuajticatcaj, ohuajnoquetzteu ne itech on mesa, ocuajquixtij on itlaquen pani niman onoxijlansaloj ican se tlaquentli huan ica nohuajhuatzaj. ");
INSERT INTO nguNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Niman quemaj on atl oquitecac ipan se hueyi teposhuajcali niman opeu quimicxipajpaca on inomachtijcahuan niman quimicxihuajhuatzaya ican on tlaquentli yejhuan quipiaya ixijlan. ");
INSERT INTO nguNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ijcuac ye quimpajpacasquia icxihuan Simón Pedro, Simón Pedro oquijlij: ―NoTeco, ¿tejhua tinechimpajpaquilis nocxihuan? ");
INSERT INTO nguNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús oquinanquilij: ―Aman xticajsicamati tlinon nicchijticaj, pero más saquin ticajsicamatis. ");
INSERT INTO nguNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pero Pedro oquijlij: ―Nejhua xqueman tinechimpajpaquilis nocxihuan. Jesús oquijlij: ―Tla xnimitzimpajpaquilis, xoc nohuan timopohuas. ");
INSERT INTO nguNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro oquijlij: ―Tla ijcon, noTeco, ma ca san xnechimpajpaquili nocxihuan, yej no xnechimpajpaquili nomahuan niman notzontecon. ");
INSERT INTO nguNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero Jesús oquijlij: ―On yejhuan quemach otlan naltia xoc nonequi nochi nopajpacas, yej san icxihuan, pampa nochihuiyan chipajticaj. Nemoyojlo chijchipajtoquej, masqui xnochimej. ");
INSERT INTO nguNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Oquijtoj: “Xnochimej chipajtoquej”, pampa quimatzticatca aquinon quitemacas. ");
INSERT INTO nguNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Más saquin ijcuac yoquimicxipajpac, Jesús ocsejpa oquinaquij on itlaquen pani, ohuajnotlalij itech on mesa niman oquimijlij: ―¿Nencajsicamatij on tlen onemechchihuilij? ");
INSERT INTO nguNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nemejhuamej nennechtocayotiaj Temachtijquetl niman nemoTeco, niman cuajli quen nenquijtohuaj, pampa melahuac nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aman, tej, tla nejhua yejhuan melahuac nemoTemachtijcau niman nemoTeco yonemechicxipajpac, tla ijcon no ijqui nonequi nenquimochihuilisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nejhua nemechchihuilia in para nemejhuamej no xchihuacan quen nejhua yonicchiu. ");
INSERT INTO nguNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ica tlen melahuac nemechijlia ica se tetequichihuilijquetl xejhua más hueyixticaj xquen on iteco, niman nion on yejhuan canaj quititlanij xejhua más hueyixticaj xquen on yejhuan quititlani. ");
INSERT INTO nguNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tla nencajsicamatij in tlajtlamach niman pehua ijqui nenquichihuaj, Dios mechtiochihuas. ");
INSERT INTO nguNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’In tlen niquijtohua xpara nochimej nemejhuamej. Nejhua niquixmatzticaj inyojlo nochimej on yejhuan yoniquintlapejpenij. Pero ica oncaj nochihuas on tlen quijtohua on Yectlajcuilojli: “On yejhuan nohuan tlacua, yonocuep notlahuelicniu.” ");
INSERT INTO nguNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Aman nemechijlia yejhua in ijcuac xe nochihua, para ijcuac nochihuas, nemejhuamej nenquineltocasquej ica nejhua melahuac nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ica tlen melahuac nemechijlia ica yejhuan quiselia on yejhuan nictitlani, no nejhua nechselia. Niman on yejhuan nejhua nechselia, no quiselia on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ijcuac ijcon yoquijtoj, Jesús onoyolajman, niman imixpan oquijtoj: ―Ica tlen melahuac nemechijlia, semej nemejhuamej nechtemacas. ");
INSERT INTO nguNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Quemaj on nomachtijquej opeu nootaj. Yejhuamej xquimatiyaj aquinon quitenehuaya Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Niman semej inomachtijcahuan, yejhuan Jesús sanoyej quitlajsojtlaya, nemiya inacastlan ne campa tlacuajticatcaj. ");
INSERT INTO nguNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Niman Simón Pedro oquixnotz para ma quitlajtolti aquinon on yejhuan quitenehuaya quitemacas. ");
INSERT INTO nguNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yejhua ica on nomachtijquetl oquinisihuij más iyelpan ica Jesús, niman oquitlajtoltij: ―NoTeco, ¿aquinon on yejhuan mitztemacas? ");
INSERT INTO nguNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús oquinanquilij: ―Nicpatzos se tlajcotipantzin pan, niman on aquin nicmacas, on yejhua. Ijcon, tej, oquipatzoj se tlajcotipantzin pan niman oquimacac Judas Iscariote, iconeu Simón. ");
INSERT INTO nguNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Niman ijcuac Judas yoquicuaj on pan, nimantzin ipan iyojlo ocalac Satanás. Quemaj Jesús oquijlij: ―On tlen ticchihuas, nimantzin xchihua. ");
INSERT INTO nguNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero nion semej on yejhuan tlacuajticatcaj ne ipan on mesa ocajsicamat tlica ijcon oquijlij. ");
INSERT INTO nguNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas quipiaya on bolsa campa quejehua tomin. Yejhua ica sequimej oquinemilijquej ica Jesús quijliaya itlaj ma cohuati tlen quitequitiltisquej ipan on ilhuitl, noso itlaj ma quinmaca on mayanquej. ");
INSERT INTO nguNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ijcuac Judas yoquicuaj yejhua on pan, nimantzin oquis. Ijcuacon ye tlayohua catca. ");
INSERT INTO nguNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Más saquin ijcuac Judas yoquis, Jesús oquijtoj: ―Aman noteititia nohueyilis, nejhua yejhuan oninochiu Tlacatl. Niman no ihueyilis Dios noteititia notechcopa. ");
INSERT INTO nguNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Niman tla nejhua nicteititia ihueyilis Dios, tla ijcon Dios no quiteititis nohueyilis, niman saniman ijqui quichihuas. ");
INSERT INTO nguNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Notlajsojcaconehuan, xoc ninemis miyec tonaltin nemohuan. Nemejhuamej nennechtejtemosquej, pero sa no ijqui quen oniquimijlij on hebreos no ijqui nemechijlia aman: Xhuelis nenyasquej campa nejhua niau. ");
INSERT INTO nguNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nemechmaca yejhua in yencuic tlanahuatijli: xmotlajsojtlacan semej ihuan ocsequimej. Ijcon quen nejhua nemechtlajsojtla, nemejhuamej no ijqui xmotlajsojtlacan semej ihuan ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tla nemotlajsojtlaj semej ihuan ocsequimej, nochi tlacatl quitas ica nennotemachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro oquitlajtoltij Jesús: ―ToTeco, ¿canon tiau? Niman Jesús oquijlij: ―Campa nejhua niau, xhuelis tias aman, pero más saquin quemaj tias. ");
INSERT INTO nguNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Quemaj Pedro oquijlij: ―NoTeco, ¿tlica xhuelis nias aman? Nicpia noyojlo para nimiquis san mopampa tla nonequi. ");
INSERT INTO nguNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús oquijlij: ―¿Melahuac ticpia moyojlo para timiquis san nopampa? Ica tlen melahuac nimitzijlia ica ijcuac xe tzajtzi on caxtil, tejhua yexpa tiquijtos ica xtinechixmati. ");
INSERT INTO nguNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Nemejhuamej ma ca xmoyolajmanacan. Xneltocacan Dios niman nejhua no xnechneltocacan. ");
INSERT INTO nguNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ne ichan noTajtzin oncaj miyec chanyotl campa huelis chantihuas. Tla xonyasquia miyec chanyotl, xnemechijlisquia. Aman, tej, niau para niconyectlalis ne campa nemonchantisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Niman ijcuac yonitlan, ocsejpa nihuajlas para nemechhuicas para nemejhuamej no nennemisquej campa nejhua ninemis. ");
INSERT INTO nguNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Niman nemejhuamej ye nenquimatztoquej canon niau, niman ye nenquixmatztoquej on ojtli. ");
INSERT INTO nguNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Quemaj Tomás oquijlij: ―ToTeco, tejhuamej xticmatij canon tiau. ¿Quen ijqui tiquixmatisquej on ojtli? ");
INSERT INTO nguNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús oquinanquilij: ―Nejhua niojtli, niman nitlin melahuac, niman no ninemilistli. Tej, san nejhua notechcopa huelis ajsisquej ne itech on Tajtli. ");
INSERT INTO nguNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tla nemejhuamej nennechixmatisquiaj, no nenquixmatisquiaj noTajtzin. Niman desde aman nenquixmatij niman ye nenquitztoquej. ");
INSERT INTO nguNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Quemaj Felipe oquijlij: ―NoTeco, xtechcahuili ma tiquitacan on toTajtzin, niman san yejhua ica on tiyolpachihuisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús oquijlij: ―Felipe, masqui ye quipia miyec tonaltin ica nemohuan ninemi, ¿oc xtinechixmati? On yejhuan nechita, no quita on Tajtli. Yejhua ica ¿tlica tinechtlajtlanilia ma nemechititi on Tajtli? ");
INSERT INTO nguNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Xticneltoca ica nejhua ninemi ihuan noTajtzin niman noTajtzin nohuan nemi? On tlajtlamach tlen nemechijlia ocse onechijlij. On tequitl yejhuan nesi ica nicchihua, noTajtzin yejhuan nopan nocahua quichihua notechcopa. ");
INSERT INTO nguNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Quemaj Jesús oquimijlij inomachtijcahuan: ―Xneltocacan ica nejhua ninemi ihuan noTajtzin, niman noTajtzin nohuan nemi. Pero tla xnenhuelij nenquineltocaj itechcopa on tlen nemechijlia, xneltocacan itechcopa on tequitl tlen nicchihua. ");
INSERT INTO nguNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ica tlen melahuac nemechijlia, ica yejhuan nechneltocas quichihuas on tequitl tlen nicchihua. Niman yejhua quichihuas on tequitl yejhuan más huejhueyi, pampa nejhua niau itech noTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Niman nochi tlen nemejhuamej nentlajtlanisquej ican notoca, nejhua nicchihuas para noTajtzin quiselis hueyilistli notechcopa yejhuan niiConeu. ");
INSERT INTO nguNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","San tlinon yejhuan nemejhuamej nentlajtlanisquej ican notoca, nicchihuas. ");
INSERT INTO nguNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tla nemejhuamej nennechtlajsojtlaj, xtlacamatican notlanahuatilhuan. ");
INSERT INTO nguNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Niman nejhua nictlajtlanilis noTajtzin ma mechajtitlanili ocse yejhuan mechyolchicahuas, mechpalehuis niman nemohuan nemis para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yejhua, tej, on Espíritu Santo yejhuan mechtlamachilistis ica on tlen melahuac. On tlalticpactlacamej xhuelij quiseliaj, pampa xhuelij quitaj nion quixmatij. Pero nemejhuamej nenquixmatij, pampa yejhua nemohuan nemi niman nemohuan nocahuas. ");
INSERT INTO nguNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nejhua xnemechcahuas quen icnomej, yej ninocuepas para nemohuan nichantis. ");
INSERT INTO nguNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sa quesqui tonaltin niman on tlalticpactlacamej xoc nechitasquej, pero nemejhuamej nennechitasquej. Niman nemejhuamej nennemisquej pampa nejhua ninemi. ");
INSERT INTO nguNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ipan on tonajli nemejhuamej nenquimatisquej ica ninemi ihuan noTajtzin, niman nemejhuamej nohuan nennemij, niman nejhua ninemi nemohuan. ");
INSERT INTO nguNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yejhuan quimati niman quitlacamati notlanahuatilhuan, melahuac nechtlajsojtla. Niman on yejhuan nechtlajsojtla noTajtzin no quitlajsojtlas. Niman nejhua no nictlajsojtlas niman ninoteititis itech. ");
INSERT INTO nguNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, on yejhuan xejhua Iscariote, oquijlij: ―NoTeco, ¿tlica timoteititis san totech tejhuamej, niman xintech on tlalticpactlacamej? ");
INSERT INTO nguNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús oquijlij: ―Yejhuan nechtlajsojtla quejehuas on tlen niquijtohua. Niman noTajtzin quitlajsojtlas, niman noTajtzin niman nejhua tihuajlasquej para ihuan tichantisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yejhuan xnechtlajsojtla xquejehua on tlen niquijtohua. In cuajli tlajtojli yejhuan yonemechijlij xquisa notech, yej quisa itech noTajtzin yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Nochi yejhua in nemechijlijticaj chica nemohuan ninemi. ");
INSERT INTO nguNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero ijcuac noTajtzin cuajtitlanis on Espíritu Santo ican notocatzin para mechyolchicahuas niman mechpalehuis, yejhua nochi mechmachtis niman mechelnamictis nochi tlen yonemechijlij. ");
INSERT INTO nguNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ninonahuatia nemohuan ican yolsehuilistli. Nejhua nemechmaca noyolsehuilis, pero xnemechmaca on yolsehuilistli yejhuan quitemacaj on tlalticpactlacamej. Ma ca xmoyolajmanacan, nion ma ca xmomojtican. ");
INSERT INTO nguNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aman yonencaquej quen niquijtohua ica ye niau, niman ica ninocuepas para ocsejpa nemohuan ninemis. Tla melahuac nennechtlajsojtlasquiaj, nenquipaquilismatisquiaj on ica niau itech noTajtzin, pampa yejhua más hueyixticaj xquen nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Aman nemechijlia yejhua in chica xe nochihua, para ijcuac nochihuas, nemejhuamej nentlaneltocasquej. ");
INSERT INTO nguNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Nitlajtlajtos nemohuan san achijtzin más, pampa ye huajlau on diablo yejhuan tlamandarohua ipan in tlalticpactli. Masqui yejhua xquipia poder para nechtlanis, ");
INSERT INTO nguNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nicchihuas on tlen noTajtzin onechnahuatij para in tlalticpactlacamej quimatisquej ica nejhua nictlajsojtla noTajtzin. Xmotelquetzacan, ma titejcuanican nican. ");
INSERT INTO nguNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Nejhua niquen tlen melahuac itemecayo on uvas, niman noTajtzin quen on yejhuan quitlapia on temecatl. ");
INSERT INTO nguNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yejhua quitequi nochi nomatzitzihuan yejhuan xtlaqui, pero quitlacuijcuilia niman quichipahua on nomatzitzihuan yejhuan tlaquij para más ma tlaquican. ");
INSERT INTO nguNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nemejhuamej yej yonenchipajquej itechcopa on temachtijli yejhuan yonemechijlij. ");
INSERT INTO nguNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nochipa xnemican nohuan, niman nejhua no nochipa ninemis nemohuan. Tla xnennemisquej nohuan, xhuelis nentlaquisquej sa no ijqui quen imahuan on uvas xhuelisquej tlaquisquej tla xquipia itemecayo. ");
INSERT INTO nguNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nejhua quen se itemecayo on uvas niman nemejhuamej quen nennomatzitzihuan. Xitlaj huelis nenquichihuasquej tla xnennemisquej nohuan. On yejhuan nochipa nemis nohuan niman nochipa ninemis ihuan quipias miyec itlaquilyo. ");
INSERT INTO nguNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","On yejhuan xnochipa nemis nohuan, quitequechehuasquej notech niman huaquis quen se cuamatli. Tla ijcon nochihuas on cuamatli ye quisentlalijtiasquej para quitlatisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tla nemejhuamej nennemisquej nohuan niman nenquejehuasquej notlajtol impan nemoyojlo, nenhuelisquej nentlajtlanisquej san tlen nenquinequisquej, niman ijqui nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ijcuac nemejhuamej nenquipiaj miyec tlacyotl, noTajtzin quiselia hueyilistli, niman ijqui nenquiteititiaj ica nemejhuamej melahuac nennotemachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nejhua nemechtlajsojtla ijcon quen noTajtzin nechtlajsojtla. Xchihuacan quen nenhuelisquej para nenquiselijtiasquej notetlajsojtlalis. ");
INSERT INTO nguNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tla nenquitlacamatztiasquej notlanahuatilhuan, nenquiselijtiasquej notetlajsojtlalis ijcon quen nejhua nictlacamatztiu itlanahuatilhuan noTajtzin niman nicselijtiu itetlajsojtlalis. ");
INSERT INTO nguNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nejhua ijcon nemechnojnotza para nipaquis nemopampa niman nemejhuamej nemopaquilis ajsitias. ");
INSERT INTO nguNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","In yejhua notlanahuatil: Xmotlajsojtlacan ihuan ocsequimej ijcon quen nejhua nemechtlajsojtla. ");
INSERT INTO nguNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","On tetlajsojtlalistli más hueyi yejhuan se huelis quipias sa no yejhua on ica ma miqui impampa itetlajsojcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Niman nemejhuamej nennotetlajsojcahuan tla nenquichihuaj tlen nejhua nemechnahuatia. ");
INSERT INTO nguNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Xoc nemechtocayotia tequichijquej pampa se tequichijquetl xquimati tlen quichihua iteco. Pero nemechtocayotia notetlajsojcahuan pampa yonemechijlij nochi tlen noTajtzin onechijlij. ");
INSERT INTO nguNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nemejhuamej xonennechtlapejpenijquej, yej nejhua onemechtlapejpenij niman onemechtlalij ipan notequiu para xhuiyan niman xpiacan miyec tlacyotl yejhuan nocahuas para nochipa. Quemaj noTajtzin mechmacas nochi tlen nenquitlajtlanilisquej ican notoca. ");
INSERT INTO nguNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yejhua in, tej, nemechnahuatia: Xmotlajsojtlacan nemejhuamej ihuan ocsequimej. ");
INSERT INTO nguNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tla on tlalticpactlacamej mechtlahuelitaj, xmatican ica achtopa onechtlahuelitaquej nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tla nemejhuamej nemohuicasquiaj quen on tlalticpactlacamej yejhuan xnechneltocaj, yejhuamej mechtlajsojtlasquiaj quen yejhuamej notlajsojtlaj. Pero nejhua onemechtlapejpenij intzajlan on tlalticpactlacamej. Yejhua ica on tlalticpactlacamej mechtlahuelitaj pampa xoc nemohuicaj quen yejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xquelnamiquican on tlen onemechijlij: “Xacaj tlaquehuajli más hueyixticaj xquen on iteco.” Tla nejhua nechtlajyohuiltiaj, nemejhuamej no mechtlajyohuiltisquej. Niman tla oquitlacamatquej notemachtil, no quitlacamatisquej on yejhuan nemejhuamej nemotemachtil. ");
INSERT INTO nguNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nochi in sa nopampa mechchihuilisquej, pampa xquixmatij on yejhuan onechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tla nejhua, tej, xniquinhuajnojnotzasquia, yejhuamej xquipiasquiaj tlajtlacojli. Pero aman xacaj huelis quijtos: “Ijcuac onitlajtlacoj, xonicmat ica on tlen onicchiu tlajtlacojli.” ");
INSERT INTO nguNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tej, on yejhuan nechtlahuelitaj, no quitlahuelitaj noTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Xquipiasquiaj tlajtlacojli, tla xnicchihuasquia intzajlan on tlen xqueman yacaj oquichiu. Pero miyec tlajtlamach yoquitaquej onicchiu, niman yej nechtlahuelitaj niman no quitlahuelitaj noTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero yejhua in ijquin nochihua para tenquisa on tlajtojli yejhuan tlajcuilolnesticaj ipan intlanahuatil yejhuan quijtohua: “Onechtlahuelitaquej, pero nion oncaj tlinon ica.” ");
INSERT INTO nguNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Pero nicuajtitlanis on tlapalehuijquetl yejhuan quisas itech noTajtzin. Yejhua on Espíritu Santo yejhuan tecajsicamachiltis on tlen melahuac. Ijcuac yejhua huajlas nechteixpantilis. ");
INSERT INTO nguNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Niman nemejhuamej no nennechteixpantilisquej, pampa desde onipeu nitemachtia, nohuan nennemij. ");
INSERT INTO nguNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Nemechijlia in tlajtlamach para ma ca nenmojometlamatisquej niman nennechtlalcahuisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mechajquixtisquej ne ipan on tiopantin. Niman ajsis on tonajli ijcuac san aquinon mechmictis quinemilis ica quitequipanohua Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yejhua in quichihuasquej pampa xqueman oquixmatquej noTajtzin nion nejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pero yejhua in nemechijlia para ijcuac ajsis on tonaltin ijcuac ijcon mechchihuilisquej, nenquelnamiquisquej ica nejhua yonemechijlijca. ’Ijcuac onipeu onenmechmachtij, xonenmechijlij in tlajtlamach pampa nejhua nemohuan ninemiya. ");
INSERT INTO nguNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero aman ye niau para ninemis ihuan on yejhuan onechajtitlan, niman nion se nemejhuamej nechtlajtoltia ¿canon tiau? ");
INSERT INTO nguNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yej sanoyej yonenmajmanquej pampa onemechijlij in tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero nemechijlia tlen melahuac. Más cuajli para nemejhuamej ma nihuiya, pampa tla nejhua xnias, xhuajlas on tlapalehuijquetl. Pero tla nias, nejhua nicuajtitlanis nemotech. ");
INSERT INTO nguNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ijcuac yejhua huajlas, quintitis on tlalticpactlacamej ica nemij ipan tlajtlacojli, niman ica huelis quipiasquej yolmelahualistli, niman ica Dios quinyolcuitis niman quintlajtlacolmacas. ");
INSERT INTO nguNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yejhua quintitis ica tlajtlacolejquej pampa xnechneltocaj. ");
INSERT INTO nguNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yejhua quintitis ica huelis quipiasquej yolmelahualistli, pampa nejhua niau campa nemi noTajtzin, niman nemejhuamej xoc más nennechitasquej. ");
INSERT INTO nguNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Niman yejhua quintitis ica quinyolcuitis niman quintlajtlacolmacas, pampa on diablo, yejhuan tlamandarohua ipan in tlalticpactli, ye cuajli yoquitlajtlacolmacaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Nicpia miyec tlinon más nemechijlis, pero nemejhuamej xhuelis nencajsicamatisquej aman. ");
INSERT INTO nguNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero ijcuac huajlas on Espíritu Santo, yejhuan tecajsicamachiltis on tlen melahuac, yejhua mechmachtis nochi tlen melahuac pampa xmechijlis sa no yejhua itlamachilis, yej quijtos nochi tlen caqui itech noTajtzin. Niman no mechititis on tlajtlamach yejhuan más saquin nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yejhua nechmacas hueyilistli pampa quiselis on tlen melahuac noca nejhua niman mechpantlantilis. ");
INSERT INTO nguNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nochi tlen iyaxca noTajtzin, no noyaxca. Yejhua ica oniquijtoj ica on Espíritu Santo quiselis tlen melahuac noca nejhua niman mechpantlantilis. ");
INSERT INTO nguNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Xhuejcajtica yes xoc nennechitasquej, niman quemaj san xhuejcajtica nennechitasquej ocsejpa pampa nejhua niau campa nemi noTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Quemaj sequimej nomachtijquej oquinotlajtoltijquej se ihuan ocse: ―¿Tlinon quijtosnequi ijcuac oquijtoj: “Xhuejcajtica yes niman xoc nennechitasquej, niman quemaj san xhuejcajtica nennechitasquej ocsejpa”, niman ica no oquijtoj: “Pampa nejhua niau campa nemi noTajtzin”? ");
INSERT INTO nguNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Tlinon, tej, quijtosnequi yejhua on ica quijtohua, “xhuejcajtica yes”? Xticajsicamatij tlinon ica technojnotza. ");
INSERT INTO nguNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús oquimat ica yejhuamej quinequiyaj quitlajtoltisquej, niman oquimijlij: ―Nejhua onemechijlij ica xhuejcajtica yes xoc nennechitasquej niman quemaj san xhuejcajtica más ocsejpa nennechitasquej. ¿In yejhua nenquimotlajtoltijtoquej? ");
INSERT INTO nguNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ica tlen melahuac nemechijlia, nemejhuamej nenchocasquej niman nenmajmanasquej, niman on tlalticpactlacamej paquisquej. Pero masqui nenmajmanasquej, nemoajmanalis nocuepas paquilistli. ");
INSERT INTO nguNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ijcuac se sihuatl ye quitlacatilis se conetzintli, najmana pampa yoyejcoc on hora para nococos. Pero ijcuac yotlacat on conetzintli, xoc quelnamiqui on tla onococoj, pampa sanoyej paqui ica otlacat se conetl ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","No ijqui nochihuas nemohuan. Aman nenmajmanaj, pero nejhua nihuajlas nemechalitas, niman ijcuacon nemoyojlo sanoyej paquis. Niman yejhua on paquilistli xacaj huelis mechcuilis. ");
INSERT INTO nguNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ipan on tonajli xoquitlaj nennechtlajtoltisquej. Ica tlen melahuac, tej, nemechijlia ica noTajtzin mechmacas nochi tlen nenquitlajtlanilisquej ican notoca. ");
INSERT INTO nguNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta aman nemejhuamej xe itlaj nenquitlajtlanij ican notoca. Xtlajtlanican tlen nenquinequisquej niman nenquiselisquej para ajsitias nemopaquilis. ");
INSERT INTO nguNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’In tlajtlamach yonemechijlij ican ejemplos. Pero yejcos on tonajli ijcuac xoc nemechnojnotzas ican ejemplos, yej cuajli nemechnojnotzas itech ica noTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ipan on tonajli nemejhuamej nenquitlajtlanilisquej noTajtzin tlajtlamach ican notoca. Niman xniquijtohua tla nejhua nictlajtlanilis itlaj nemopampa, ");
INSERT INTO nguNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pampa sa no yejhua toTajtzin mechtlajsojtla. Mechtlajsojtla pampa nemejhuamej nennechtlajsojtlaj niman nenquineltocaj ica nejhua itech onihualeu. ");
INSERT INTO nguNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Melahuac nejhua oniquis itech noTajtzin niman onihuajlaj ipan in tlalticpactli. Niman aman nicajtehuas in tlalticpactli niman ocsejpa nias itech noTajtzin. ");
INSERT INTO nguNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Quemaj on inomachtijcahuan oquijlijquej: ―Aman quemaj cuajli titechnojnotza xoc ican ejemplos. ");
INSERT INTO nguNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aman ticmatij ica ticmati nochi tlajtlamach. Niman xpolihui yacaj itlaj mitztlajtoltis, pampa ticmati tlinon se mitztlajtoltisnequi ijcuac xe mitznotza. Yejhua ica in ticneltocaj ica otihualeu itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús oquimijlij: ―¿Tla ijcon, aman nentlaneltocaj? ");
INSERT INTO nguNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tej, ye huajlau on tonajli niman sa no amantzin ijcuac nemejhuamej nemoxeyelosquej. Cada se yas sa canica niman noselti nennechcahuasquej. Pero xnoselti ninemis pampa noTajtzin nohuan nemis. ");
INSERT INTO nguNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nochi yejhua in nemechijlia para nenquipiasquej yolsehuilistli, pampa san secan nennemij nohuan. Ipan in tlalticpactli nentlajyohuisquej, pero xpiacan yolchicahualistli pampa nejhua yonictlan nochi quech oncaj niman nemij ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ijcuac Jesús yotlan quijtohua in tlajtlamach, oajcotlachix ne ilhuicac, niman oquijtoj: ―NoTajtzin, yoyejcoc yejhua on hora. Xnechhueyili nejhua yejhuan nimoConeu para nejhua no ma nimitzhueyili. ");
INSERT INTO nguNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tejhua, tej, yotinechmacac on poder ipan nochi tlacatl, para niquinmacas nemilistli para nochipa nochimej on yejhuan yotinechinmacac. ");
INSERT INTO nguNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Niman ijcuac se mitzixmati tejhua yejhuan san moselti melahuac tiDios, niman nejhua niJesucristo yejhuan otinechajtitlan, yejhua quipia on nemilistli yejhuan para nochipa. ");
INSERT INTO nguNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nejhua yonitlan on tlen otinechnahuatij nicchihuas. Ijcon, tej, yonimitzhueyilij ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aman, tej, noTajtzin, ne campa tinemi, xnechmaca sa no yejhua on hueyilistli yejhuan mohuan nicpiaya ijcuac in tlalticpactli xe oncatca. ");
INSERT INTO nguNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","On tlacamej yejhuan tejhua otinechinmacac intzajlan on tlalticpactlacamej oniquinmachiltij aquin tejhua. Moyaxcahuan catcaj, niman tejhua otinechinmacac, niman yoquitlacamatquej on tlen otiquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aman quimatztoquej ica nochi tlajtlamach yejhuan otinechmacac hualehua motech, ");
INSERT INTO nguNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","pampa yoniquinmacac motemachtil yejhuan otinechmacac, niman yejhuamej yoquiselijquej. Aman yejhuamej quimatij ica melahuac motech onihualeu, niman quineltocaj ica tejhua otinechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nejhua impampa motech nitlajtlani. Xictlajtlani impampa on tlalticpactlacamej, yej impampa on yejhuan otinechinmacac pampa yejhuamej moyaxcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nochimej yejhuan noyaxcahuan no moyaxcahuan, niman nochimej yejhuan moyaxcahuan noyaxcahuan, niman yejhuamej nechhueyiliaj. ");
INSERT INTO nguNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Aman nejhua niau para mohuan ninemis. Xoc ninocahuas ipan in tlalticpactli, pero yejhuamej nocahuasquej ipan in tlalticpactli. NoyecTajtzin, xquinmanahui ican mopoder yejhuan otinechinmacac para san secan ma nemican ijcon quen tejhua nohuan tinemi. ");
INSERT INTO nguNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ijcuac nejhua inhuan ninemiya ipan in tlalticpactli, on yejhuan otinechinmacac oniquinmanahuij ican mopoder. Oniquinmanahuij niman nion se xopoliu, yej san yejhua on yejhuan ye ijqui oncatca para polihuis para otenquis on tlen quijtohua on Yectlajcuilojli. ");
INSERT INTO nguNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Aman ye niau campa tejhua tinemi, pero chica oc ninemi ipan in tlalticpactli niquijtohua in tlatlamach para yejhuamej ma quipiacan sa no yejhua on paquilistli yejhuan nejhua nicpia. ");
INSERT INTO nguNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nejhua yoniquinmacac motemachtil, pero on tlalticpactlacamej quintlahuelitaj, pampa yejhuamej xoc nohuicaj quen on tlalticpactlacamej no ijqui quen nejhua xninohuica quen on tlalticpactlacamej. ");
INSERT INTO nguNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nejhua xnimitztlajtlanilia xquinquixti intzajlan on tlalticpactlacamej, yej nimitztlajtlanilia xquinmanahui itech on diablo. ");
INSERT INTO nguNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ijcon quen xninohuica quen on tlalticpactlacamej, yejhuamej no xnohuicaj quen on tlalticpactlacamej. ");
INSERT INTO nguNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xquinchipahuili innemilis itechcopa on tlen melahuac. Motlajtol yejhua tlen melahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ijcon quen tejhua otinechajtitlan campa nemij in tlalticpactlacamej, no ijqui nejhua niquintitlani campa nemij on tlalticpactlacamej. ");
INSERT INTO nguNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Niman impampa yejhuamej sa no nejhua ninotemaca para yejhuamej huelis chipahuilosquej ica motlajtoltzin. ");
INSERT INTO nguNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Pero xnicchihua oración san impampa yejhuamej, yej no impampa on yejhuan nechneltocasquej itechcopa on temachtilistli yejhuan quiteijlisquej on yejhuan yotinechinmacac. ");
INSERT INTO nguNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nimitztlajtlanilia para nochimej yejhuamej ma san secan nemican. Oh, noTajtzin, ma yejhuamej san secan tohuan nemican ijcon quen tejhua tinemi niman nejhua mohuan ninemi. Melahuac, tej, ma san secan nemican tohuan para on tlalticpactlacamej ma quineltocacan ica tejhua otinechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yejhuamej yoniquinmacac sa no yejhua on hueyilistli yejhuan tejhua otinechmacac para san secan ma nemican, ijcon quen tejhua niman nejhua tinemij san secnec. ");
INSERT INTO nguNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nejhua ninemi inhuan niman tejhua tinemi nohuan para yejhuamej huajnochihua san se niman ijqui on tlalticpactlacamej huelis quimatisquej ica tejhua otinechajtitlan, niman ica moconehuan tiquintlajsojtla quen nejhua tinechtlajsojtla. ");
INSERT INTO nguNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’NoTajtzin, nicnequi para on yejhuan tejhua otinechinmacac nohuan nemisquej campa ninemis para ma quitacan on hueyilistli yejhuan otinechmacac. Nicpia on hueyilistli pampa otinechtlajsojtlac desde ijcuac in tlalticpactli xe oncatca. ");
INSERT INTO nguNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","NoyecTajtzin, on tlalticpactlacamej xmitzixmatij, pero nejhua nimitzixmati, niman yejhuamej in yejhuan achtopa otinechinmacac ye quimatztoquej ica tejhua otinechajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yoniquinmachiltij aquin tejhua, niman oc moca nitemachiltis para on tetlajsojtlalistli yejhuan tinechpialia ma intech onya, niman para sa no nejhua intech ma ninemi. ");
INSERT INTO nguNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ijcuac Jesús yotlan quijtohua in tlajtlamach, oquis inhuan inomachtijcahuan niman oquipanahuitoj on atentli itoca Cedrón. Ompa oncatca se cojtlaquilyoj campa Jesús ocalac inhuan on inomachtijcahuan. ");
INSERT INTO nguNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, on yejhuan quitemactilisquia Jesús, no quixmatia ompa, pampa Jesús miyecpa onosentlalitoya inhuan inomachtijcahuan ompa ne. ");
INSERT INTO nguNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Niman Judas oajsic ompa inhuan miyequej soldados. Niman oajsic inhuan sequimej ipolicías on tiopan yejhuan ohualajquej ican intlanahuatil on fariseos niman intlayecancahuan on tiopixquej. Yejhuamej yayaj ican armas niman quitquiyaj inlámparas niman ocopiltin. ");
INSERT INTO nguNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús ye quimatzticatca tlinon ipan nochihuas. Yejhua ohuajnonextij, niman oquintlajtoltij: ―¿Aquinon nenquitejtemohuaj? ");
INSERT INTO nguNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yejhuamej oquijlijquej: ―Jesús on chanej Nazaret. Jesús oquimijlij: ―Nejhua ijqui notoca. Judas, on yejhuan quitemactilij Jesús no ompa inhuan nemiya. ");
INSERT INTO nguNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Niman ijcuac Jesús oquimijlij: “Nejhua ijqui notoca”, ohuajquetztiajquej ipan tlajli. ");
INSERT INTO nguNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Quemaj Jesús ocsejpa oquintlajtoltij: ―¿Aquinon nenquitejtemohuaj? Niman yejhuamej oquijtojquej: ―Jesús on yejhuan chanej Nazaret. ");
INSERT INTO nguNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Niman Jesús oquimijlij: ―Yonemechijlij ica nejhua. Tla nejhua nennechtejtemohuaj, tla ijcon in ocsequimej xquincahuilican ma huiyan. ");
INSERT INTO nguNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yejhua in onochiu san para otenquis on tlen sa no Jesús oquijtoca: “On yejhuan otinechinmacac nion se xopoliu.” ");
INSERT INTO nguNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Quemaj Simón Pedro, yejhuan quipiaya se espada, oquixicopintiaj niman oquitequilij iyecmacopanacas se tlacatl itoca Malco. Yejhua itlaquehual on más hueyi tlayecanquetl catca itech on tiopixquej. ");
INSERT INTO nguNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pero Jesús oquijij Pedro: ―Xcalacti moespada ne campa oticxicopin. ¿Tlen ticnemilia xijqui nonequi niquijyohuis on tlajyohuilistli yejhuan noTajtzin oquitlalij para niquijyohuis? ");
INSERT INTO nguNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Quemaj on miyequej soldados ihuan intlayecancau niman impolicías on hebreos ocajsiquej Jesús, niman oquisalojquej. ");
INSERT INTO nguNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Quemaj ocuicaquej itech Anás. Anás imonta catca Caifás yejhuan ipan on xipan más hueyi tlayecanquetl catca intech on tiopixquej. ");
INSERT INTO nguNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yejhua in Caifás sa no yejhua yejhuan oquimijlijca on hebreos ica más cuajli para yejhuamej tla miquis se tlacatl ipampa on país. ");
INSERT INTO nguNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro ihuan ocse nomachtijquetl quicuitlapanhuijtiayaj Jesús. On ocse nomachtijquetl quixmatiya on más hueyi intlayecancau on tiopixquej. Yejhua ica no ihuan Jesús ocalac ipan iquiahuac on tlayecanquetl. ");
INSERT INTO nguNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero Pedro onocajca ne quiahuatenco. Yejhua ica on nomachtijquetl yejhuan quixmatiya inmás hueyi tlayecancau on tiopixquej oquisaco niman otlajtlajtoj ihuan on sihuatl yejhuan tlapixqui ne quiahuatenco, niman ocalactij Pedro. ");
INSERT INTO nguNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Quemaj on sihuatl yejhuan tlapixqui ne quiahuatempan ijquin oquitlajtoltij Pedro: ―¿Tlen tejhua xno tiitemachtijcau on tlacatl? Pedro oquijtoj: ―Ca, nejhua ca. ");
INSERT INTO nguNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","On tetequichihuilijquej niman on policías oquitlalijcaj tlitl de tecojli niman majmaniyaj ica nototonijticatcaj pampa sehuaya. Pedro no ompa inhuan nemiya chica nototonijticatca itech on tlitl. ");
INSERT INTO nguNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","On tlayecanquetl intech on tiopixquej oquitlajtoltij Jesús ica on inomachtijcahuan, niman ica on tlen quitemachtiaya. ");
INSERT INTO nguNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús oquimijlij: ―Nejhua teixpan onitlajtlajtoj ixpan nochi tlacatl. Nochipa nitemachtiaya ipan on tiopantin niman ipan on hueyi tiopan campa nosentlaliaj nochimej on hebreos. Ijcon, tej, xitlaj san oniquichtacaijtoj. ");
INSERT INTO nguNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tlica nejhua tinechtlajtoltia? Xquintlajtolti on yejhuan nechcaquiyaj. Yejhuamej ma quijtocan tlinon niquimijliaya. Yejhuamej quimatztoquej tlinon notemachtil. ");
INSERT INTO nguNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ijcuac Jesús ijcon oquijtoj, se ipolicía on hueyi tiopan yejhuan ompa nemiya oquixayacahuitectiaj, niman oquijlij: ―¿Ijcon ticnanquilia on más hueyi intlayecancau on tiopixquej? ");
INSERT INTO nguNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús oquijlij: ―Tla itlaj xmelahuac oniquijtoj, xquijto tlica xmelahuac. Pero tla melahuac on tlen oniquijto, ¿tlica, tej, tinechmailia? ");
INSERT INTO nguNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Quemaj Anás oquititlan itech Caifás on yejhuan inmás hueyi tlayecancau on tiopixquej. Jesús oc salijtiaya. ");
INSERT INTO nguNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Chica Pedro oc nototonijticatca ne itech on tlitl, oquijlijquej: ―¿Tejhua xnotiitemachtijcau on tlacatl? Niman Pedro oquinenec, oquijtoj: ―Ca, nejhua ca. ");
INSERT INTO nguNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Quemaj se itequichihuilijcau on tlayecanquetl itech on tiopixquej, yejhuan quen quitaya on tlacatl yejhuan Pedro oquinacastzonteca, ijquin oquitlajtoltij Pedro: ―¿Xihuan onimitzitac ne ipan cojtlaquilyoj? ");
INSERT INTO nguNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro ocsejpa oquinenec, niman nimantzin otzajtzic se caxtil. ");
INSERT INTO nguNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Quemaj oquejcuanijquej Jesús ne ichan Caifás niman ocuicaquej ne ipan ipalacio on gobernador. Ye huajtlanestiaya niman on hebreos xocalaquej ne ipan on palacio para ma ca nijtlacosquej ixpan Dios. Tla nijtlacosquej ixpan Dios xhuelis quicuasquej on tiotlac tlajcuajli ipan on ilhuitl pascua. Yejhua ica xocalaquej ne ipan on palacio. ");
INSERT INTO nguNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yejhua ica Pilato ohuajquis para oquinnotz, niman oquimijlij: ―¿Tlinon ica nenquiteixpanhuiyaj yejhua in tlacatl? ");
INSERT INTO nguNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yejhuamej oquijlijquej: ―Tla yejhua xquichihuasquia on tlen xcuajli xtimitzajhuiquilisquiaj. ");
INSERT INTO nguNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Quemaj Pilato oquimijlij: ―Xcuicacan. Nemejhuamej xyolcuitican niman xtlajtlacolmacacan quen no nemotlanahuatil. On hebreos oquijlijquej: ―Pero itlanahuatil César xtechcahuilia yacaj ticmictisquej. ");
INSERT INTO nguNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ijcon otenquis on tlen Jesús oquijtojca ica yejhua ijcon miquis. ");
INSERT INTO nguNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ocsejpa ocalaquito ne ipan ipalacio, oconotz Jesús niman ijquin oquitlajtoltij: ―¿Tejhua tiinRey on hebreos? ");
INSERT INTO nguNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús oquijlij: ―¿Yejhua on tlen tictlajtlani san tejhua ticonnemilia, noso pampa yej ocsequimej omitzijlijquej aquin nejhua? ");
INSERT INTO nguNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato oquijlij: ―¿Tlen ticnemilia ica nejhua nihebreo? On mochantlacaj niman on tlayecanquej tiopixquej yejhuamej omitztemacaco notech. ¿Tlen tlinon oticchiu? ");
INSERT INTO nguNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ijcuacon Jesús oquinanquilij: ―Nejhua xnitlamandarohua nican ipan in tlalticpactli quen se rey. Tla nitlanahuatisquia nican, on yejhuan nohuan quistinemij nechmanahuisquiaj para nejhua xnechtemacasquiaj intech on hebreos. Pero nejhua xnitlamandarohua nican ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Quemaj Pilato oquijlij: ―Tla ijcon, tej, ¿tejhua tiRey? Jesús oquinanquilij: ―Nejhua niRey quen tejhua tiquijtohua. Nejhua onitlacat niman onihuajlaj ipan in tlalticpactli para onicteixpantilico on tlen melahuac. Nochimej yejhuan quitlacamatij on tlen melahuac, caquij tlen nejhua niquijtohua. ");
INSERT INTO nguNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato oquijlij: ―¿Niman catlejhua on tlen melahuac? Ijcuac ijcon yoquitlajtoltij, ocsejpa ohuajquis para oquinnotz on hebreos, niman oquimijlij: ―Xitlaj nicnextilia tla itlaj tlanahuatijli xoquitlacamat in tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero ye ijqui huajnochijtiu para nocahua para nemechmacahuilia se yejhuan tzacuticaj ipan in hueyi ilhuitl pascua. ¿Nenquinequij, tej, ma nemechmacahuili inRey on hebreos? ");
INSERT INTO nguNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ijcuacon nochimej otzajtziquej: ―¡Yejhua on ma ca xmacahua! ¡Xmacahua Barrabás! Niman Barrabás, se tlachtequetl catca. ");
INSERT INTO nguNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Quemaj Pilato oquimayau Jesús niman otlanahuatij ma quitlatzhuitequican. ");
INSERT INTO nguNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yejhuamej on soldados oquichijchijquej se huitzcorona niman oquimaniltijquej Jesús. Niman no oquitlaquentijquej ican se tlaquentli morado. ");
INSERT INTO nguNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Quemaj oquinisihuijquej, niman oquijlijquej: ―¡Cuajli xnemi, tiinRey on hebreos! Niman oquixayacahuijhuitequej. ");
INSERT INTO nguNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Quemaj Pilato ocsejpa ohuajquis, niman oquimijlij on hebreos: ―Xquitacan, nican nicuajhuica para xmatican ica xitlaj nicnextilia tlen xcuajli oquichiu. ");
INSERT INTO nguNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Niman Jesús ohuajquis cuajmantiaya ihuitzcorona niman huajtlaquemejtitiaya ican on tlaquentli morado. Quemaj Pilato oquimijlij: ―¡Xquitacan, nican nemi in tlacatl! ");
INSERT INTO nguNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ijcuac on tlayecanquej tiopixquej niman on policías oquitaquej Jesús, opejquej tzajtzij: ―¡Xmajmasohualti ipan cojnepanojli! ¡Xmajmasohualti ipan cojnepanojli! Pilato oquimijlij: ―Nemejhuamej xcuican niman xmajmasohualtican ipan cojnepanojli, pampa nejhua nion se itlajtlacol xonicnextilij. ");
INSERT INTO nguNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero on hebreos oquijlijquej: ―Tejhuamej ticpiaj se tlanahuatijli niman totlanahuatil quijtohua ica oncaj miquis, pampa yonoteneu iConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ijcuac Pilato ijcon ocac, más sanoyej onomojtij. ");
INSERT INTO nguNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ocsejpa ocalaquito ne ijtic on palacio, niman oquitlajtoltij Jesús: ―¿Canon tihualehua tejhua? Pero Jesús xitlaj ica oquinanquilij. ");
INSERT INTO nguNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Niman Pilato oquijlij: ―¿Xitlaj ica tinechnanquilia? ¿Tlen xticmati ica nicpia tequihuajyotl para nimitzmajmasohualtis ipan cojnepanojli niman no nicpia tequihuajyotl para nimitzmacahuas? ");
INSERT INTO nguNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús oquijlij: ―Xticpiasquia itlaj tequihuajyotl nopan tla Dios xmitzmacasquia. Yejhua ica quipia más hueyi tlajtlacojli xquen tejhua on yejhuan motech onechtemacac. ");
INSERT INTO nguNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Quemaj Pilato quitejtemohuiliaya quen ijqui quimacahuasquia Jesús, pero on hebreos ijquin oquitzajtzilijquej: ―¡Tla ticmacahuas, xtiitetlajsojcau César on hueyi tlayecanquetl yejhuan tequihuaj ipan on país itoca Roma! ¡San aquinon yejhuan nochihua rey, yejhua nochihua itlahuelicniu César! ");
INSERT INTO nguNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Quemaj ijcuac Pilato ijcon ocac, otlanahuatij ma cuajquixtitij Jesús niman yejhua ohuajnotlalij ne ipan nesehuilpan campa tequihuajti niman tetlajtlacolmaca. Ne campa onotlalij ican tlajtojli hebreo quitocayotiayaj Gabata. Quijtosnequi on tepejpechyoj. ");
INSERT INTO nguNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ijcuacon canaj tlacualispan catca ipan on tonajli ijcuac xe ajsi on ilhuitl pascua. Quemaj Pilato oquimijlij on hebreos: ―¡Nican nemi nemoRey! ");
INSERT INTO nguNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero yejhuamej otzajtziquej: ―¡Ma miqui! ¡Ma miqui! ¡Xmajmasohualtican ipan cojnepanojli! Pilato oquimijlij: ―¿Tla ijcon, nenquinequij ma nicmajmasohualtia ipan cojnepanojli nemoRey? Pero on tlayecanquej tiopixquej oquijlijquej: ―Tejhuamej xticpiaj ocse rey. Torey san yejhua César. ");
INSERT INTO nguNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yejhua ica on, Pilato oquinmactilij para ma quimajmasohualtican ipan cojnepanojli, niman on soldados ocuicaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús, tej, oquis oquimamajtiaj icojnepanol para oyaj ne campa quitocayatiaj Micatzontecomatl, yejhuan ican on tlajtojli hebreo itoca Gólgota. ");
INSERT INTO nguNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ompa, tej, oquimajmasohualtiquej ipan cojnepanojli. Niman ihuan yejhua omemej más oquinmajmasohualtiquej ipan cojnepanoltin inajnacastlan niman Jesús intlajcotian. ");
INSERT INTO nguNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato oquijcuiloj se tlajcuilojli niman otlanahuatij ma quitlalitij ne ipan on cojnepanojli. On tlajcuilojli quijtohuaya: “In Jesús yejhuan chanej Nazaret yejhua inRey on hebreos.” ");
INSERT INTO nguNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Miyequej hebreos oquinomachtijquej on tlajcuilojli pampa on campa oquimajmasohualtiquej Jesús ipan cojnepanojli xhuejca oncatca itech on hueyican. Niman on tlajcuilojli tlajcuilolnesticatca ican tlajtojli hebreo, griego niman latín. ");
INSERT INTO nguNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","On tlayecanquej tiopixquej hebreos oquijlijquej Pilato: ―Ma ca xquijcuilo “InRey on hebreos.” Más cuajli xquijcuilo: “In tlacatl notenehua inRey on hebreos.” ");
INSERT INTO nguNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero Pilato oquimijlij: ―Tlen yoniquijcuiloj, yoniquijcuiloj. ");
INSERT INTO nguNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ijcuac on soldados yoquimajmasohuatiquej Jesús ipan cojnepanojli, oquitilanquej itlaquen niman naucantipan oquixelojquej, niman sejsetemej oquicuiquej. Niman no oquitilanquej itlaquen pani, itoca manto, yejhuan xtlajtzontli catca yej san se hueyi catca. ");
INSERT INTO nguNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","On soldados oquinojlijquej: ―Ma ca ma tictzajtzayanacan. Más cuajli ma titotlatlanican para tiquitasquej aquinon tetlanis yejhua quicuis. Ijcon, tej, otenquis on Yectlajcuilojli yejhuan quijtohua: “Oquinoxexelohuilijquej notlaquen niman ica on nomanto onotlatlanquej para ones aquinon iyaxca yes.” Ijcon, tej, oquichijquej on soldados. ");
INSERT INTO nguNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Itech icojnepanol Jesús ompa nemiya inan niman icniu on inan yejhuan sihuatl. María on isihuau Cleofas no ompa nemiya ihuan María yejhuan hualehua Magdala. ");
INSERT INTO nguNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ijcuac Jesús oquitac inan ihuan ijcac on nomachtijquetl yejhuan sanoyej oquitlajsojtlac, oquijlij inan: ―Sihuatl, ompon nemi moconeu. ");
INSERT INTO nguNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Quemaj oquijlij on nomachtijquetl: ―Ompon nemi monan. Niman ijcuacon on nomachtijquetl oquiselij ne ichan quen inan. ");
INSERT INTO nguNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Quemaj ijcuac nochi yejhua in yopanoc, Jesús quimatzticatca ica nochi itequiu yotlan, niman para otenquis on Yectlajcuilojli, oquijtoj: ―Namiqui. ");
INSERT INTO nguNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ompa oncatca se jarro tenticatca ican on xococ vino. Yejhua ica oquipatzojquej se esponja ican on vino. Quemaj oquitlalijquej ipan se acatl, niman ocontlalilijquej ne ipan icamac. ");
INSERT INTO nguNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ijcuac Jesús oquimat on xococ vino, oquijtoj: ―Nochi cuajli yonitenquis. Quemaj onotzonacapiloj, niman ohuajnotlamilij. ");
INSERT INTO nguNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","On hebreos oquitlajtlanilijquej Pilato ma tlanahuati ma quimicxipojpostequican on yejhuan oquinmajmasohualtiquej ipan incojnepanol, niman ma quimejcuanican on intlalnacayo ne ipan incojnepanol. Ijcon oquitlajtlanilijquej Pilato pampa ye viernes catca niman xquinequiyaj para on tlalnacayomej nocahuasquej ne ipan cojnepanoltin ipan sábado on tonajli ijcuac nosehuiaj on hebreos. Niman yejhua in sábado más hueyixticatca xquen ocsequi sábados pampa ye ajsiticatca on ilhuitl pascua. ");
INSERT INTO nguNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Quemaj on soldados oyajquej niman oquicxipostequej on achtoj tlacatl, niman quemaj quej on ocse tlacatl yejhuan nopilcaya itech ica Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero ijcuac on soldados oyajquej itech Jesús oquitaquej ica yomic. Yejhua ica xoc oquicxipostequej. ");
INSERT INTO nguNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero se soldado oquitzopinij ijtinacastlan ican ilanza. Quemaj nimantzin oquis yestli niman atl. ");
INSERT INTO nguNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nochi yejhua in cuajli oniquitac. Nemechijlia on tlen oniquitac niman toTeco quimati ica nemechijlia on tlen melahuac. Nejhua nemechijlia yejhua in para nemejhuamej no xneltocacan. ");
INSERT INTO nguNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","In tlajtlamach onochiu para otenquis on Yectlajcuilojli campa quijtohua: “Nion se iomiyo xquipostequilisquej.” ");
INSERT INTO nguNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Niman ocsecan no quijtohua: “Quitasquej on yejhuan oquitzopinijquej. ");
INSERT INTO nguNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Más saquin ijcuac ijcon yonochiu, José, on yejhuan chantiya ne Arimatea, oquitlajtlanilij permiso Pilato para quitquis itlalnacayo Jesús. José san ichtaca inomachtijcau catca Jesús, pampa quinmacasiya on hebreos. Pilato ocahuilij, niman José oyaj niman oquitquic itlalnacayo Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","No ijqui Nicodemo, on yejhuan achtoj oyajca quinotzato Jesús ijcuac tlayohua, oajsic niman cuajquiya canaj sempoajli huan majtlactli kilos ajhuialistin tlachijchiutli ican mirra niman iyayo se xojtli itoca áloes. ");
INSERT INTO nguNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ijcon, tej, José niman Nicodemo oquitquiquej itlalnacayo Jesús, niman oquitetejcuixquej ica on tlaquentli fino itoca lienzo yejhuan oquitlalilijquej on se tlaneloltipan ajhuiyalistli. Oquichijquej quen quichihuaj on hebreos ijcuac quintocaj on mimiquej. ");
INSERT INTO nguNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ne campa oquimajmasohualtiquej Jesús ipan cojnepanojli oncatca se cojtlaquilyoj. Niman ipan on cojtlaquilyoj oncatca se yencuic tlalcontli ijtic se teostotl campa xe yacaj contocayaj. ");
INSERT INTO nguNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ompa oquitlalijquej itlalnacayo Jesús pampa on tlalcontli nisiu oncatca, niman pampa ye pehuaya on tonajli ijcuac nosehuisquej on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Saniman ipan on achtoj tonajli ipeuyan on semana, ijcuac oc tlayohuatoc catca, María, yejhuan chantiya ne ipan on pueblo itoca Magdala, oyaj ne itech on tlalcontli. Niman ijcuac oajsic, oquitac ica xoc ompa oncatca on tetl yejhuan quitentzacuticatca on teostotl. ");
INSERT INTO nguNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Quemaj onotlaloj ne campa nemiyaj Simón Pedro niman on nomachtijquetl yejhaun Jesús sanoyej quitlajsojtlaya, niman oquimijlij: ―Yoquejcuanijquej toTeco ne ipan itlalcon niman xticmatij canon ocahuatoj. ");
INSERT INTO nguNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Quemaj Pedro niman on ocse nomachtijquetl oquisquej niman oyajquej ne itech on tlalcontli. ");
INSERT INTO nguNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","On omemej notlajtlalohuayaj, pero on ocse más sanoyej onotlaloj xquen Pedro niman achtopa yejhua oajsic itech on tlalcontli ne ijtic on teostotl. ");
INSERT INTO nguNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Onopachoj para ontlachix ijtic on tlalcontli niman san oquitac ompa oncaj on tlaquentin istaquej, pero xocalaquito. ");
INSERT INTO nguNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Quemaj Simón Pedro oajsic icuitlapan niman ocalaquito ne ijtic on tlalcontli. Yejhua no oquitac ompa oncaj on tlaquentin istaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Niman no oquitac on tlaquentli yejhuan ica ocuatejcuixcaj Jesús. On tlaquentli yejhuan ica ocuatejcuixcaj xsan secan oncatca ihuan on tlaquentin istaquej, yej tepayolijticatca niman ocsecan oncatca. ");
INSERT INTO nguNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Quemaj no ocalaquito on ocse nomachtijquetl yejhuan achtopa oajsic. Ijcuac cuajli oquitac tlinon yonochiu, oquineltocac ica Jesús nemi. ");
INSERT INTO nguNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yejhuamej, tej, oc xe cajsicamatiyaj on Yectlajcuilojli yejhuan quijtohua ica Jesús ica oncatca yolihuis niman noquetztehuas ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Quemaj yejhuamej on nomachtijquej oyajquej para inchan. ");
INSERT INTO nguNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero María onocau ne quiahuac itech on tlalcontli niman chocaya. Chica chocaya, onopachoj para ontlachix ijtic on tlacontli, ");
INSERT INTO nguNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","niman oquintac omemej ilhuicactequitquej ican intlaquen istac. Yejhuamej yejyehuaticatcaj ne campa oncatca on itlalnacayo Jesús. Ocse yehuaticatca ne campa itzontlan niman se ne icxitlan. ");
INSERT INTO nguNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Niman on ilhuicactequitquej oquitlajtoltijquej: ―Sihuatl, ¿tlica tichocaticaj? Yejhua oquimijlij: ―Pampa yoquejcuanijquej noTeco niman xnicmati canon ocahuatoj. ");
INSERT INTO nguNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Quemaj ijcuac ijcon oquijtoj, onocuep niman oquitac Jesús ica ompa nemiya, pero xquimatiya ica yejhua Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Quemaj Jesús oquitlajtoltij: ―Sihuatl, ¿tlica tichocaticaj? ¿Aquinon tictejtemohua? Yejhua oquinemilij ica on aquin oquinotz, yejhua on yejhuan quitlapia on cojtlaquilyoj. Yejhua ica oquijlij: ―Señor, tla tejhua oticuicac, xnechijli canon oticau para nejhua nicuicas. ");
INSERT INTO nguNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ijcuacon Jesús oquijlij: ―¡María! Yejhua onocueptiquis itech, niman oquijlij ican tlajtojli hebreo: ―¡Raboni! ―yejhuan quijtosnequi Temachtijquetl. ");
INSERT INTO nguNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús oquijlij: ―Ma ca xnechquitzqui pampa oc xe nitlejcohua ne itech noTajtzin. Pero xhuiya niman xquimijliti on nocnihuan ica nitlejcohua ne itech noTajtzin niman nemoTajtzin, itech noDios niman nemoDios. ");
INSERT INTO nguNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Quemaj María on yejhuan chanej ne Magdala oyaj quinmachiltito on nomachtijquej ica yejhua yoquitac inTeco, niman ica yejhua oquijlij in tlajtlamach. ");
INSERT INTO nguNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sa no ipan on tonajli, on achtoj tonajli ipeuyan on semana ijcuac tlayohua, on nomachtijquej onosentlalijquej ipan se cajli. Cuajli oquintzajtzacuquej on tlatzacuilomej pampa quinmacajsiyaj on hebreos. Masqui cuajli tlatzajtzacutoyaj, Jesús ocalac niman onotelquetztajsic ne intlajcotian, niman ijquin oquintlajpaloj: ―Xyolsejtiacan nemejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ijcuac ijcon yoquimijlij, oquintitij imahuan campa oquitzopinijcaj, niman no ijtinacastlan. Niman on nomachtijquej sanoyej opacquej ica oquitaquej inTeco. ");
INSERT INTO nguNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Quemaj Jesús ocsejpa oquimijlij: ―Xyolsejtiacan nemejhuamej. Ijcon quen noTajtzin onechajtitlan, no ijqui nemechtitlani. ");
INSERT INTO nguNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Niman ijcuac ijquin oquijtoj, oquimilpitz niman oquimijlij: ―Xselican on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tla nemejhuamej nenquintlapojpolhuiliaj intlajtlacolhuan on tlacamej, intlajtlacolhuan pojpolihuisquej. Niman tla xnenquintlapojpolhuiliaj intlajtlacolhuan, intlajtlacolhuan xpojpolihuis. ");
INSERT INTO nguNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero Tomás yejhuan tehuan caxitia on majtlactli huan ome nomachtijquej, niman yejhuan cuitiaj cohuatzin, xompa inhuan nemiya ijcuac ohualajca Jesús. ");
INSERT INTO nguNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yejhua ica on ocsequimej nomachtijquej oquijlijquej: ―Yotiquitaquej toTeco. Pero Tomás oquimijlij: ―Tla nejhua xniquita imahuan campa otlajtlalacaj on clavos, niman xompa nicalactia nomajpil, niman no xnicalactia noma ipan ijtinacastlan, xnicneltocas ica nemi. ");
INSERT INTO nguNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chicueyi tonajli más saquin, on nomachtijquej ocsejpa onosentlalijquej ipan se cajli, niman ijcuacon ompa inhuan nemiya Tomás. Quemaj, masqui tlatzajtzacutoya cuajli, Jesús ocalac, onotelquetz intlajcotian niman oquintlajpaloj, oquimijlij: ―Xyolsejtiacan nemejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Quemaj oquijlij Tomás: ―Nican xcalacti momajpil ipan nomahuan. Xquintaj nomahuan. Niman xcuajqui moma niman xcalacti nican nojtinacastlan. Ma ca sa xometlamatztia, yej xnechneltoca. ");
INSERT INTO nguNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ijcuacon Tomás oquijlij: ―¡NoTeco niman noDios! ");
INSERT INTO nguNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús oquijlij: ―Tomás, tejhua otitlaneltocac pampa otinechitac. Quintiochihuasquej sanoyej on yejhuan xonechitaquej niman otlaneltocaquej. ");
INSERT INTO nguNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Niman Jesús oquichiu ocsequi miyec milagros imixpan on inomachtijcahuan yejhuan xtlajcuilolnesticaj ipan in tlajcuilolamatl. ");
INSERT INTO nguNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero yejhua in tlen onijcuiloj, onijcuiloj para nemejhuamej xneltocacan ica Jesús yejhua Cristo iConetzin Dios, niman para ijcuac nenquineltocasquej nenquipiasquej yencuic nemilistli itechcopa Jesucristo. ");
INSERT INTO nguNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ijcuac ijcon yonochiu, Jesús ocsejpa oquinnotitij on inomachtijcahuan ne itenco on mar itoca Tiberias. Ijcuacon ijquin oquinnotitij. ");
INSERT INTO nguNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedro, Tomás, on yejhuan cuitiayaj cohuatzin, niman Natanael yejhuan chantiya ne Caná de Galilea, iconehuan Zebedeo, niman ocse omemej inomachtijcahuan Jesús san secan nemiyaj. ");
INSERT INTO nguNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro oquimijlij: ―Nejhua nomichajsis. Yejhuamej on ocsequimej oquijlijquej: ―Tejhuamej no mohuan tiasquej. Yejhua ica oyajquej niman otlejcoquej ipan se barco. Pero ipan nochi on tlayohua xitlaj michin ocajsiquej. ");
INSERT INTO nguNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ijcuac ye huajtlanestiaya, Jesús nemiya ne itenco on mar, pero on nomachtijquej xquimatiyaj ica yejhua. ");
INSERT INTO nguNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Quemaj oquimijlij: ―Noconehuan, ¿xitlaj michin nencajsij? Niman yejhuamej oquijlijquej: ―Ca. Xitlaj ticajsij. ");
INSERT INTO nguNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Quemaj Jesús oquimijlij: ―Xconchapanican nemomatlau iyecmacopa on barco niman nenquimajsisquej michimej. Ijqui oquichijquej niman quemaj xoc hueliyaj quixtiayaj on inmatlau ne ijtic on atl pampa sanoyej miyec michin ijtic huajlaya. ");
INSERT INTO nguNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Quemaj on nomachtijquetl yejhuan Jesús sanoyej quitlajsojtlaya, oquijlij Pedro: ―¡Yejhua toTeco! Niman ijcuac Simón Pedro ocac ica yejhua inTeco, nimantzin onotlaquentijtihuetz pampa onotlaquenquixtijca. Quemaj ijcuac onotlaquentij, onatlajcal. ");
INSERT INTO nguNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Xhuejca nemiyaj de ne atentli, san canaj cien metros. Niman on ocsequimej nomachtijquej oajsiquej ne itenco on atl ipan on barco. Yejhuamej quitejchihuilantiajquej on inmatlau yejhuan tentiaya ican michimej. ");
INSERT INTO nguNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ijcuac oajsiquej ipan tlajli, oquitaquej tlitl niman ipan on tlixochtli oncatcaj michin niman pan. ");
INSERT INTO nguNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús oquimijlij: ―Xquinhuajhuicacan sequimej michimej yejhuan quemach onenquimajsiquej. ");
INSERT INTO nguNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro otlejcoc ipan on barco niman oquitejchihuilantiaj on matlatl hasta ne ipan on atentli tentiaya ican michimej huejhueyimej. Ocajsiquej yeyi ciento huan tlajco ipan yeyi huejhueyi michin. Niman masqui sanoyej miyec catca, on matlatl xotzayan. ");
INSERT INTO nguNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Quemaj Jesús oquimijlij: ―Xhuajlacan niman xtlacuacan. Niman nion se nomachtijquetl xoquinemilij quitlajtoltis aquin yejhua pampa quimatzticatcaj ica yejhua inTeco. ");
INSERT INTO nguNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Quemaj Jesús oquinnisihuij, niman ocontilan on pan niman oquinmacac, niman sa no ijqui oquichiu ican on michin. ");
INSERT INTO nguNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","In, tej, ica yexpa oquinnotitij Jesús on inomachtijcahuan ijcuac yoyoliu niman yonoquetzteu ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ijcuac yotlacuajquej, Jesús oquitlajtoltij Simón Pedro: ―Simón, iconeu Jonás, ¿más tinechtlajsojtla xquen yejhuamej in? Pedro oquijlij: ―Quemaj. NoTeco, tejhua ticmati ica nimitztlajsojtla. Jesús oquijlij: ―Tla ijcon xquintlacualti noborreguitos. ");
INSERT INTO nguNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ica ocpa ocsejpa oquitlajtoltij: ―Simón, iconeu Jonás, ¿tinechtlajsojtla? Pedro oquijlij: ―Quemaj. NoTeco, tejhua ticmatzticaj ica nimitztlajsojtla. Yejhua oquijlij: ―Tla ijcon xquintlapia noborregos. ");
INSERT INTO nguNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ica yexpa oquitlajtoltij: ―Simón, iconeu Jonás, ¿tinechtlajsojtla? Pedro onajman pampa ica yexpa oquitlajtoltij tla quitlajsojtla, niman yejhua oquijlij: ―NoTeco, tejhua nochi ticmati. Tejhua ticmatzticaj ica nimitztlajsojtla. Jesús oquijlij: ―Tla ijcon xquintlacualti noborregos. ");
INSERT INTO nguNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ica tlen melahuac nimitzijlia ica ijcuac más ticonetl catca, san tihuajmotlaquentiaya niman tiaya campaca tejhua ticnequiya, pero ijcuac ye tihuehuentzin yes, san tiquinhuajmelahuas momahuan niman ocse mitztlaquentis, niman mitzhuicas campa xticnequis tias. ");
INSERT INTO nguNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ijcuac Jesús ijcon oquijtoj, oquipantlantilij quen ijqui Pedro miquis niman ijqui quihueyilis Dios. Quemaj oquijlij: ―¡Xhuajla nohuan! ");
INSERT INTO nguNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Quemaj Pedro ohuajnocuep, niman oquitac ica quicuitlapanhuiya on nomachtijquetl yejhuan Jesús sanoyej quitlajsojtlaya. On yejhua on nomachtijquetl yejhuan ijcuac otlacuaquej inacastlan Jesús nemiya, niman oquitlajtoltij: “NoTeco, ¿aquinon on yejhuan mitztemacas?” ");
INSERT INTO nguNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Niman ijcuac Pedro ocontac, ijquin oquitlajtoltij Jesús: ―NoTeco, niman yejhua in yej ¿tlinon ipan nochihuas? ");
INSERT INTO nguNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús oquijlij: ―Tla nejhua nicnequi para yejhua ma nemi hasta ijcuac ocsejpa nihuajlas, ¿tlin ticmati tejhua? Tejhua xhuajla nohuan. ");
INSERT INTO nguNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yejhua ica omachiyato intech on nomachtijquej ica on nomachtijquetl xmiquis. Pero Jesús xoquijlij ica yejhua xmiquis, yej oquijtoj: “Tla nejhua nicnequi para yejhua nemis hasta ijcuac ocsejpa nihuajlas, ¿tlin ticmati tejhua?” ");
INSERT INTO nguNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yejhua in nomachtijquetl yejhua quiteixpantilia nochi quen oquitac in tlajtlamach, niman oquijcuiloj nochi in tlajtlamach ipan in tlajcuilolamatl. Niman ticmatij ica on tlen quijtohua, yejhua tlen melahuac. ");
INSERT INTO nguNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Niman no oncaj ocsequi miyec tlajtlamach yejhuan Jesús oquichiu. Niman nicnemilia ica tla niquijcuilosquia cada se de nochi on tlajtlamach, xonyasquia canon quintlalisquia ipan in tlalticpactli para nochi on tlajcuilolamamej. Ma ijqui nochihua.");
INSERT INTO nguNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","NotlajsojcaTeófilo, ipan on achtoj tlajcuilolamatl oniquijcuiloj nochi ica on tlajtlamach tlen Jesús oquichiu niman oquitemachtij ijcuac opeu itequiu ");
INSERT INTO nguNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta ijcuac yejhua otlejcoc ne ilhuicac. Ijcuac yejhua xe tlejcohuaya ne ilhuicac, ica ipoder on Espíritu Santo, Jesús oquinnahuatij tlinon quichihuasquej on tlacamej yejhuan oquintlapejpenij quen iapóstoles. ");
INSERT INTO nguNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Oquinnotitij saquin ijcuac yotlajyohuij niman yomic, niman oquichiu miyec tlajtlamach para yejhuamej quimatisquej ica melahuac yolticaj. Ijcon quinnonextijtinemiya hasta ipan ompoajli tonaltin, niman quinnojnotzaya quen Dios tlanahuatia. ");
INSERT INTO nguNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chica oc nemiya ihuan on iapóstoles ijquin oquinnahuatij Jesús: ―Ma ca xquisacan Jerusalén, yej xchacan para nenquiselisquej on Espíritu Santo yejhuan toTajtzin oquijtoj ica mechajtitlanilis ijcon quen nejhua onemechijlij. ");
INSERT INTO nguNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","On melahuac ica Juan otlacuatequij ican atl, pero xhuejcajticaj yes nemejhuamej nentlacuatequiltiyesquej ican on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ijcuac on apóstoles onosentlalijquej ihuan Jesús, ijquin oquitlajtoltijquej: ―ToTeco, ¿ipan in tonaltin ticmanahuis yejhua in país de Israel para ocsejpa iselti noyecanas? ");
INSERT INTO nguNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús oquinnanquilij: ―Aman xnemotequiu nenquimatisquej quemanon niman tlen tonajli toTajtzin oquitlalij para nochihuas. San yejhua quipia tequihuajyotl para quijtohua quemanon nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yej, ijcuac on Espíritu Santo huajlas nemopan, nenquiselisquej on poder. Niman nennechteixpantilisquej ne Jerusalén, niman imanyan Judea, niman Samaria, niman nochihuiyan ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ijcuac yotlan quijtohua on tlajtlamach, Jesús otlejcotiaj ne ipan cielo chica on apóstoles sa conitzticatcaj. Niman quemaj se moxtli oquitlapachoj niman xoc ohuel más oquitaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chica Jesús tlejcotiaya ne ilhuicac niman yejhuamej ontlachixticatcaj, omemej tlacamej tlaquenistaquej ohuajnonextijquej intech, ");
INSERT INTO nguNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","niman oquimijlijquej: ―Tlacamej galileos, ¿man tlica sa nemonajcotlachixtoquej ne ipan cielo? Yejhua in Jesús sa no yejhua quen nemotzajlan yoquis para otlejcoc ne ilhuicac, ocsejpa huajlas sa no ijqui quen onenquitaquej oyaj. ");
INSERT INTO nguNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ijcuacon on apóstoles ohuajtemoquej ne ipan on tepetl, yejhuan quitocayotiaj Olivos, niman ocsejpa oyajquej ne Jerusalén. On tepetl Olivos oncaj sa ompaca nisiu ne Jerusalén, san on quech itlanahuatil Moisés quitecahuilia para se nejnemis ipan sábado ijcuac on hebreos nosehuiaj. ");
INSERT INTO nguNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ijcuac oajsiquej ne ipan on hueyican, otlejcoto ipan on cajli yejhuan oncaj ipan ome caltlanepantli campa nosentlaliayaj. Ompa nemiyaj Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo on iconeu Alfeo, Simón on yejhuan nopohua ipan on partido itoca cananista, niman Judas iconeu Jacobo. ");
INSERT INTO nguNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nochimej yejhuamej san se inyojlo quipiayaj niman nosentlaliayaj mojmostla para quichihuayaj oración. Ijcon oquichijquej ihuan icnihuan Jesús, niman María on inan Jesús niman ihuan ocsequimej sihuamej. ");
INSERT INTO nguNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Niman ipan on tonaltin ompa nemiyaj canaj se ciento ipan sempoajli yejhuan nosentlalijticatcaj. Niman quemaj Pedro ohuajnotelquetz intlajcotian nochimej, niman oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nocnihuan, ye ijqui oncatca para nochihuas on tlen oquijtoca on Espíritu Santo itechcopa David ipan on Yectlajcuilojli yejhua ica on Judas on aquin oquinyecan on yejhuan ocajsiquej Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas, tej, tohuan nopohuaya, niman yejhua no otequit san secan tohuan. ");
INSERT INTO nguNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero oquitlaxtlau se tlajli ica on tomin yejhuan oquitlanca ican on tlen xcuajli oquichiu. Niman ohuajnotlajcal campa tlacpac niman oijtitetzayan niman nochi on icuitlaxcol ochajchapan. ");
INSERT INTO nguNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Niman nochimej on chanejquej ne Jerusalén cuajli oquimatquej quen onochiu, niman ijcon, tej, on tlajli oquitocayotijquej Acéldama, yejhuan ican intlajtol quijtosnequi Yestlajli. ");
INSERT INTO nguNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ipan on tlajcuilolamatl itoca Salmos ijquin quijtohua: Ma tla cajtehua ne ichan niman ma ca sa yacaj chantis ompa. Niman ocsecan no ijquin quijtohua: Ma ocse cajsi itequiu. ");
INSERT INTO nguNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Yejhua ica nonequi, tej, ma tictlapejpenijcan se intech in tlacamej yejhuan onenquej sa secan tohuan nochipa ijcuac toTeco Jesús quistinemiya totzajlan. ");
INSERT INTO nguNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Nonequi se yejhuan oixpantic nochi ijcuac Juan oquicuatequij Jesús hasta on tonajli ijcuac yejhua oyaj ne ilhuicac. Ijqui nonequi ma se nochihua teixpantiliquetl tohuan ica melahuac Jesús onoyolihuitij niman onoquetzteu ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Niman yejhuamej oquintlapejpenijquej omemej: sen tlacatl itoca José, yejhuan no itoca Barsabás yejhuan no san quixmatiyaj Justo, niman ocse yejhuan itoca Matías. ");
INSERT INTO nguNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Niman quemaj ijquin oquichiquej oración: ―ToTeco, tejhua yejhuan tiquixmati inyojlo nochi tlacatl, xtechititi catlejhua tictlapejpenia intech in omemej ");
INSERT INTO nguNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para ma quichihua on tequitl quen apóstol, pampa Judas oquipoloj on tequitl ipampa itlajtlacol niman oyaj ne campa quitocarohua. ");
INSERT INTO nguNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Quemaj onotlatlanquej niman on suerte ohuetz ipan Matías. Yejhua ica Matías opeu inhuan nopohua on majtlactli huan se apóstoles. ");
INSERT INTO nguNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Niman ijcuac oajsic on ilhuitl itoca Pentecostés, nochimej on tlaneltocaquej san secan ompa nemiyaj niman san se inyojlo quipiayaj. ");
INSERT INTO nguNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Quemaj nimantzin ohuajtlacocomocac ne ilhuicac quen ijcuac sanoyej chicahuac ajaca. Niman on ajacatl ocaquistic ijtic nochi on cajli campa yejhuamej yejyehuaticatcaj. ");
INSERT INTO nguNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Niman ohuajnonextij quen itlaj tlitl yejhuan tlicuitiu niman onoxexeloj impan cada se quen itlan nenepiltin. ");
INSERT INTO nguNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Niman on Espíritu Santo nochi ica quinyecanaya. Quemaj opejquej tlajtlajtohuaj ican sesetlamantic yencuic tlajtojli ijcon quen on Espíritu Santo quinchihualtiaya para ma tlajtlajtocan. ");
INSERT INTO nguNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ipan on tonaltin chantiyaj ne Jerusalén hebreos yejhuan cuajli quitlacaitayaj Dios. Yejhuamej huajhualehuayaj de nochihuiyan ipan in tlalticpactli. ");
INSERT INTO nguNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Niman ijcuac ocaquistic yejhua on cocomocalistli, onosentlalijtetzquej on tojlamej. Ijcuacon on tlacamej xquimatiyaj tlinon quinemilisquej pampa cada se caquiliayaj tlajtlajtohuayaj ican intlajtol. ");
INSERT INTO nguNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yejhuamej sa ometlamatiyaj niman mojcatlachayaj. Niman quijtohuayaj: ―¿Tlen xchanejquej ne Galilea nochimej in yejhuan tlajtlajtohuaj? ");
INSERT INTO nguNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Man tlica cada se de tejhuamej tiquincaquij tlajtohuaj ican totlajtol yejhuan tejhuamej ipan otixtlamatquej? ");
INSERT INTO nguNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nican nemij tlacamej yejhuan chanejquej ipan on miyecan. Sequimej chantij ne Partia, sequimej ne Media, sequimej ne Elam, sequimej ne Mesopotamia, sequimej ne Judea, sequimej ne Capadocia, sequimej ne Ponto niman sequimej ne Asia. ");
INSERT INTO nguNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","No nican nemij on yejhuan chanejquej ne Frigia niman Panfilia niman ne Egipto, niman ne ipan iregiónes Africa yejhuan nisiu oncaj itech Cirene. Niman no nican nemij yejhuan hualehuaj ne Roma, sequimej hebreos pampa ijcon otlacatquej, niman ocsequimej onocuepquej hebreos pampa oquineltocaquej intlaneltoc on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","No nican nemij on tlacamej yejhuan hualehuaj ne Creta niman ne Arabia. Tinochimej tiquincaquij on apóstoles tlajtlajtohuaj ica on itlamajhuisolhuan Dios cada se ican itlajtol. ");
INSERT INTO nguNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Niman nochimej sa mojcatlachixticatcaj niman xquimatiyaj tlinon quinemilisquej. Quinotlajtoltiayaj ihuan ocsequimej: ―¿Tlinon quijtosnequi yejhua in? ");
INSERT INTO nguNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero sequimej san tepijpinahuiayaj, niman quijtohuayaj: ―On yej tlajtlahuanquej. ");
INSERT INTO nguNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ijcuacon Pedro ohuajnotelquetz inhuan on majtlactli huan se apóstoles, niman ican chicahuac tlajtojli, oquijtoj: ―Tlacamej hebreos niman nemochimej aquin nenchantij nican Jerusalén, xmatican nemejhuamej yejhua in, niman cuajli xcaquican tlinon nemechijlis. ");
INSERT INTO nguNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yejhuamej in tlacamej xtlajtlahuanquej quen sequimej nemejhuamej nenquinemiliaj, pampa quemach cualcan ijcuac chicnahui hora. ");
INSERT INTO nguNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yej yejhua in sa no yejhua on yejhuan oquipantlantijca on tiotlajtojquetl Joel ijcuac oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dios quijtohua: “Ijcuac sa itlajtlancan on tonaltin, nictitlanis noEspíritu itech nochi tlacatl. Niman nemoconehuan tlacamej niman nemoconehuan sihuamej quiteijlisquej on tiotlajtojli yejhuan quiseliaj itech Dios. Niman nemotelpochhuan quitasquej tlachalistli yejhuan quen intemicpan, niman on huehuentzitzintin incochpan temiquisquej. ");
INSERT INTO nguNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Niman melahuac ipan on tonaltin nictitlanis noEspíritu itech notequitcahuan tlacamej niman notequitcahuan sihuamej, niman quiteijlisquej on tiotlajtojli yejhuan quiselisquej itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ne tlacpac ipan cielo nicteititis tlamajhuisoltin, niman ipan tlalticpactli nicteititis miyec milagros. Onyas yestli, tlitl niman moxtli yejhuan tlapoctemas. ");
INSERT INTO nguNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","On tonaltzintli capotzehuis niman on metztli chichilihuis quen itlaj yestli. In nochihuas ijcuac xe huajnopantlantia on hueyi quijtosnequi ilhuiu toTeco. ");
INSERT INTO nguNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Niman san aquinon yejhuan quitlajtlanilia toTeco para ma maquisa, toTeco quimaquixtis. ");
INSERT INTO nguNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro no oquijtoj: ―Tlacamej hebreos, xcaquican in tlen niquijtos. Dios cuajli omechititij ica Jesús yejhuan hualehua ne Nazaret melahuac yejhua iConeu. Ijcon, tej, Dios omechititij ican huejhueyi tetlatlachaltilistli, milagros niman tlamajhuisoltin yejhuan yejhua oquichiu nemotzajlan itechcopa Jesús ijcon quen nemejhuamej cuajli nenquimatztoquej. ");
INSERT INTO nguNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dios ye huejcahui quimatzticatca on tlen nenquichihuilisquiaj Jesús niman yejhua oquitlalij ipan iyojlo para notecahuilis nenquitemactilisquej intech on xcuajcualtin tlacamej para ma quimajmasohualtican ipan cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Dios oquiyolihuitij niman oquetzteu ne ipan itlalcon. Yejhua oquimanahuij ipan ipoder on miquilistli pampa ipoder on miquilistli xohuel oquiteltlalij Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","On rey David otlajtlatoj itech ica Jesús. Oquijtoj: Nejhua nochipa niquitaya toTeco Dios nixpan nemi. Xoncaj itlaj yejhuan nechmojtis pampa yejhua noyecmacopa nemi. ");
INSERT INTO nguNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yejhua ica noyojlo sanoyej paqui niman nipacatlajtohua. Niman masqui notlalnacayo miquis, ninosehuis ican tlamachalistli, ");
INSERT INTO nguNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","pampa xticahuilis noalma nocahuas ne mictlan nion xticahuilis itlalnacayo moyolchipajcau para ma ijtlacahui. ");
INSERT INTO nguNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Otinechititij on ojtli yejhuan nechhuica ne campa oncaj on nemilistli. Niman ne mixpan tinechyoltemitis ican pactli. ");
INSERT INTO nguNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Nocnihuan, in cuajli panesticaj ica toachtojtata David omic niman oquitlaltocaquej ipan itlalcon, niman on itlalcon oc nican tohuan oncaj. ");
INSERT INTO nguNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero David tiotlajtojquetl catca niman yejhua quimatzticatca ica Dios oquijtojca quichihuas niman oquimelajcaijtoj ica semej ihuejcaconehuan notlalis ne ipan inesehuilpan para tequihuaj yes. ");
INSERT INTO nguNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ye huejcahui chica nemiya David ocajsicamat tlinon nochihuas. Yejhua ica otlajtoj itech ica Cristo yolihuis niman noquetztehuas ne ipan itlalcon, niman ica ialma xnocahuas ne mictlan, nion inacayo ijtlacahuis. ");
INSERT INTO nguNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Aman, tej, Dios oquiyolihuitij niman oquetzteu ne ipan itlalcon sa no yejhua sa no in Jesús. Yejhua ica tej, tinochimej ticteixpantiliaj. ");
INSERT INTO nguNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ijcon, tej, Dios oquitlejcoltij ne iyecmacopa para más hueyixtias. Quemaj Jesús oquiselij itech iTaj on Espíritu Santo yejhuan Dios oquijtocac quitemacas, niman aman yoquichayau nochi in yejhuan nenquitaj niman nencaquij. ");
INSERT INTO nguNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David xotlejcoc ne ilhuicac, pero sa no yejhua quijtohua: On toTajtzin Dios oquijlij toTeco: “Xmotlali nican ipan noyecmacopa ");
INSERT INTO nguNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta ma nimitztlali tetlanqui intech on yejhuan motlahuelicnihuan.” ");
INSERT INTO nguNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Yejhua ica nochi quech nenhebreos ipan in país de Israel xmatican cuajli niman ma ca xometlamatican ica in Jesús yejhua on yejhuan nemejhuamej onenquimajmasohualtiquej ipan cojnepanojli, Dios oquitlalij para yejhua toTeco niman yejhua Cristo. ");
INSERT INTO nguNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ijcuac ocacquej yejhua in, sanoyej onoyolcocojquej niman oquitlajtoltijquej Pedro niman on ocsequimej apóstoles: ―Tocnihuan, ¿tlinon ticchihuasquej? ");
INSERT INTO nguNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Quemaj Pedro oquimijlij: ―Xmoyolcuepacan niman xmocuatequican cada se de nemejhuamej ican itocatzin Jesucristo para nemotlajtlajcolhuan mechtlapojpolhuilisquej, niman nenquiselisquej itetlayocolil Dios yejhuan on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yejhua in ipromesa Dios para nemejhuamej, niman para nemoconehuan, niman para nochimej on yejhuan huejca nemisquej, niman para nochimej on quech toTeco Dios quinnotzas. ");
INSERT INTO nguNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Niman ica ocsequi miyec tlajtojli Pedro oquiteixpantilij niman oquintlacanojnotz, oquimijlij: ―Xmejcuanican itech on tlajyohuilistli yejhuan quiselisquej on tlacamej yejhuan xcuajli nohuicaj. ");
INSERT INTO nguNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ijcon, tej, on yejhuan oquiselijquej itemachtil onocuatequijquej. Niman ipan on tonajli canaj yeyi mil tlacamej tehuan onopojquej intech on tlaneltocaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Niman nochimej cuajli nohuicayaj quen on apóstoles quitemachtiayaj, niman quisepamatiyaj niman nosentlaliayaj para quicuayaj on Santa Cena, niman quichihuayaj oraciones. ");
INSERT INTO nguNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","On apóstoles miyec milagros niman tlamajhuisoltin oquichijquej, niman yejhua ica nochimej tlamojcaitayaj. ");
INSERT INTO nguNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nochimej yejhuan otlaneltocaquej cuajli nohuicayaj san secan ican san se inyojlo. Niman se ihuan ocse quinomacayaj nochi tlajtlamach tlen quipiayaj. ");
INSERT INTO nguNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Quinamacayaj intlal niman nochi tlen quipiayaj, niman on tomin quinxelohuiliayaj quen cada se quipolojticatca. ");
INSERT INTO nguNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mojmostla nosentlaliayaj ne ipan on hueyi tiopan, niman inchajchan quicuayaj on Santa Cena, niman tlacuayaj san secan ican pactli niman yolyemanilistli. ");
INSERT INTO nguNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Quiyectenehuayaj Dios, niman nochi tlacatl quinmixpacaitaya cuajli. Niman on toTeco más quinmiyequilijtiaya mojmostla on yejhuan maquisasquej. ");
INSERT INTO nguNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Se tonajli Pedro niman Juan san secan tlejcotiayaj ne ipan on hueyi tiopan ipan yeyi hora ica tiotlac, on hora ijcuac nochihuaya oración. ");
INSERT INTO nguNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mojmostla ompa nemiya se tlacatl yejhuan huilatzin catca desde ijcuac onen. Concahuayaj ne ipan hueyi tiopan niman quitlaliayaj ne tiopanquiahuatenco yejhuan quitocayotiayaj “Cualtetzin” para notlajtlayehuiaya intech on yejhuan calaquij ne hueyi tiopan. ");
INSERT INTO nguNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ijcuac on huilatzin oquitac Pedro niman Juan ica oncalaquisquej ne ipan on hueyi tiopan, oquintlajtlanilij se tetlayocolijli. ");
INSERT INTO nguNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Quemaj Pedro ihuan Juan oquixquechijquej, niman Pedro oquijlij: ―Xtechalita. ");
INSERT INTO nguNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ijcuacon on tlacatl sa cominitzticatca quinemiliaya ica quiselis itlajtzin intech yejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Quemaj Pedro oquijlij: ―Xnicpia plata nion oro, yej tlen nejhua nicpia nimitzmaca. Ican itocatzin Jesucristo, yejhuan hualehua Nazaret, nimitznahuatia xmotelquetza niman xnejnemi. ");
INSERT INTO nguNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Quemaj Pedro ocontilan on huilatzin ipan iyecma niman oquipalehuij para ma notelquetza. Nimantzin on huilatzin opajtiquej icxihuan niman icacayolhuan. ");
INSERT INTO nguNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ijcuacon on huilatzin otzicuin, niman ijcuac onotelquetz, opeu nejnemi. Quemaj inhuan Pedro niman Juan ocalac ne ipan on hueyi tiopan, nejnentiaya, niman tzicuintiaya niman quiyectenetiaya Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ijcuac nochi tlacatl oquitac nejnemi niman cueyilia Dios, ");
INSERT INTO nguNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sanoyej otlamojcaitaquej yejhua ica on tlen ipan onochiu. Ijcon onochiu pampa quixmatiyaj on tlacatl niman quimatiyaj ica sa no yejhua on aquin notlaliaya ne tiopanquiahuatenco itoca “Cualtetzin”, para notlajtlayehuiya. ");
INSERT INTO nguNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chica on huilatzin yejhuan opajtic quimayantiaya Pedro niman Juan, nochi tlacatl isijcapan oyajquej ican mojcatlachalistli intech ne quiahuac campa itoca iCorredor Salomón. ");
INSERT INTO nguNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Niman ijcuac ijcon oquitac, Pedro oquimijlij on tlacamej: ―Tlacamej hebreos, ¿tlica nentlamojcaitaj ica in? ¿Tlica nentechtlajtlataj quen tla tejhuamej ticpajtisquiaj in tlacatl ican topoder, noso toyolchipahualis para ma nejnemi? ");
INSERT INTO nguNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","On iDios Abraham niman Isaac, niman Jacob niman yejhuan no inDios on ocsequimej toachtojtajhuan ocueyilij Jesús on iConetzin. Pero nemejhuamej onenquitemactilijquej, niman onenquinenequej ne itech Pilato ijcuac yejhua quinequiya quimacahuas. ");
INSERT INTO nguNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Xonenquiselijquej yejhua on yejhuan yolchipahuac niman yolmelajqui, yej onenquitlajtlanilijquej Pilato ma mechmacahuili se temictijquetl. ");
INSERT INTO nguNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ijcon, tej, nemejhuamej onenquimictijquej on yejhuan quitemaca yencuic nemilistli. Pero Dios oquiyolihuitij niman oquetzteu ne ipan itlalcon, niman yejhua ica on tejhuamej ticteixpantiliaj. ");
INSERT INTO nguNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","San ican itocatzin Jesús, niman itechcopa totlaneltoc itech itocatzin, yejhua in tlacatl yejhuan nemejhuamej nenquitaj niman nenquixmatij, opajtic ipan icxihuan. Niman ica itlaneltoc itech Jesús, in tlacatl cuajli opajtic ijcon quen nemejhuamej nenquitaj. ");
INSERT INTO nguNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Ye nicmatzticaj, nocnihuan, ica ijcuac nemejhuamej niman nemotlayecancahuan onenquimictijquej Jesús xnenquimatiyaj tlinon nenquichijticatcaj. ");
INSERT INTO nguNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero ijquin Dios oquichiu on tlen ye huejcahui nochi on quech tiotlajtojquej oquijtojcaj nochihuas. Nochimej yejhuamej oquijtojquej ica iCristo Dios tlajyohuis. ");
INSERT INTO nguNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tla ijcon, tej, xmoyolcuepacan niman xpatlacan nemonemilis para nemotlajtlacol popolihuis. Niman toTeco Dios mechajtitlanilis on tonaltin ijcuac mechyoltlalis, ");
INSERT INTO nguNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","niman cuajtitlanis on Jesús on yejhuan Cristo yejhuan Dios yoquitlalij para tequihuaj yes. ");
INSERT INTO nguNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero Cristo ica oncaj nocahuas ne ilhuicac hasta ijcuac Dios nochi tlajtlamach cuajli quitlalis, ijcon quen oquijtoj intechcopa on iyectiotlajtojcahuan yejhuan onenquej ye huejcahui. ");
INSERT INTO nguNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ijquin, tej, Moisés oquimijlij on toachtojtajhuan: “Ijcon quen toTeco Dios onechajtitlan no ijqui cuajtitlanis se tiotlajtojquetl, niman yejhua on tiotlajtojquetl quisas intzajlan nemocnihuan. Xtencaquican nochi on quech tlajtlamach tlen yejhua mechijlis, ");
INSERT INTO nguNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","pampa san aquinon xquitencaquis tlen quijtohua on tiotlajtojquetl, xoxotonis, niman quixelosquej itech on ipaís Israel.” Ijcon, tej, oquijtoj Moisés. ");
INSERT INTO nguNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nochi on tiotlajtojquej desde Samuel hasta aman otlajtlajtojquej ica ijcon nochihuasquia ipan in tonaltin. ");
INSERT INTO nguNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","On promesas, yejhuan Dios oquitemacac intechcopa on tiotlajtojquej, on para nemejhuamej. Niman no para nemejhuamej on pacto yejhuan Dios oquitlalij inhuan on toachtojtajhuan ijcuac oquijlij Abraham: “Nochi chanej ipan in tlalticpactli quiselisquej tlatiochihualistli itech mohuejcaconeu.” ");
INSERT INTO nguNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ijcuac Dios oquiyolihuitij niman oquetzteu iConeu yejhuan Jesús, achtoj omechajtitlanilij nemejhuamej para mechtiochihuas para cada se de nemejhuamej nenquipatlasquej nemonemilis niman nenquitlalcahuisquej on tlen xcuajli. ");
INSERT INTO nguNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Chica Pedro niman Juan oc quinnojnotzayaj on tlacamej, ohualajquej on tiopixquej ihuan on intlayecancau on policía ipan on hueyi tiopan niman on saduceos. ");
INSERT INTO nguNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yejhuamej cualaniyaj pampa Pedro niman Juan quinmachtiayaj on tlacamej ica Jesús onoyoliutij niman onoquetzteu ne ipan itlalcon niman yejhua ica on mimiquej no yolihuisquej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Oquimajsiquej niman oquintzacuquej hasta huajmostla, pampa ijcuacon ye tiotlac catca. ");
INSERT INTO nguNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero miyequej yejhuan ocacquej on temachtilistli otlaneltocaquej. Niman oquimpojquej san on yejhuan tlacamej oajsic canaj macuijli mil tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Niman huajmostla onosentlalijquej ne Jerusalén on intlayecancahuan on hebreos, on tlajtlajmatquej niman on temachtijquej ican on tlanahuatijli. ");
INSERT INTO nguNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","No ompa nemiyaj Anás yejhuan on más hueyixticaj tlayecanquetl intech on tiopixquej, Caifás, Juan, Alejandro niman on ocsequimej yejhuan nopohuaj ipan ichanchanecahuan on más hueyixticaj tlayecanquetl intech on tiopixquej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Niman ijcuac oquintlalijquej Pedro niman Juan ne imixpan, oquintlajtoltijquej: ―¿Aquinon itlanahuatil, noso aquinon ica itoca onenquipajtiquej yejhua on tlacatl? ");
INSERT INTO nguNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ijcuacon on Espíritu Santo nochi ica quiyecanaya Pedro. Niman Pedro oquijtoj: ―Nemejhuamej tlayecanquej intech on tlacamej, niman nemejhuamej aquin nentlajtlajmatquej hebreos, ");
INSERT INTO nguNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tla nemejhuamej nentlajtlanij ica on tlen cuajli yejhuan onochiu ipan in tlacatl huilatzin, niman quen ijqui opajtic, nemechijlis. ");
INSERT INTO nguNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Cuajli xmatztiacan nemochimej nemejhuamej, niman nochimej on quech chanejquej ipan in país de Israel, ica yejhua in tlacatl, yejhuan nican nemixpan nemi, yopajtic ican ipoder Jesucristo yejhuan hualehua Nazaret. Sa no yejhua on yejhuan onenquimajmasohualtiquej ne ipan cojnepanojli, niman yejhuan Dios oquiyolihuitij niman oquetzteu ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yejhua on Jesús, yejhua quen se tetl yejhuan nentepanchijquej xonenquiseliquej. Pero aman yejhua yonochiu yacatztica. ");
INSERT INTO nguNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Niman xacaj ocse hueli temaquixtia, pampa Dios xocuajtitlan yacaj ocse tlacatl ipan in tlalticpactli yejhuan itechcopa huelis timaquisasquej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ijcuac on tequihuajquej oquitaquej quen yolchicajquej Pedro niman Juan, niman ica yejhuamej xoyajquej ipan escuela nion xhueyixtoquej, yej quen san yacaj tlacamej, otlamojcaitaquej niman oquinomacaquej cuenta ica yejhuamej ihuan nemiyaj Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Niman pampa on tlacatl yejhuan oquipajtiquej ompa inhuan ijcaticatca, yejhuamej xohuelquej itlaj oquimixcomacaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yejhua ica oquinnahuatijquej ma huajquisacan ne campa onosentlalijquej on tetlacanojnotzquej, niman quemaj on tequihuajquej onotlajtlajtoltijquej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Quijtohuayaj: ―¿Tlinon tiquinchihuilisquej, tej, in tlacamej? Nochimej yejhuan chantij Jerusalén quimatztoquej ica yejhuamej oquichijquej se hueyi milagro niman tejhuamej xhuelis tiquiyanasquej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero san para ma ca más nopantlantis intzajlan on tlacamej on tlen oquichijquej, ma tiquinmojmotican ica tiquincastigarosquej para ma ca sa ma tenojnotzacan ican itoca Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Niman quemaj ocsejpa oquinnotzquej niman oquinnahuatijquej para ma ca más tenojnotzasquej nion temachtisquej ican itocatzin Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ijcuacon Pedro niman Juan otlananquilijquej: ―Xtechijlican sa no nemejhuamej on tlen Dios quinequi. ¿Aquinon más nonequi tictlacamatisquej, nemejhuamej noso Dios? ");
INSERT INTO nguNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tejhuamej, tej, xhuelis ticajcahuasquej ica tiquijtosquej on tlajtlamach yejhuan yotiquitaquej niman yoticaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ijcuacon on tequihuajquej quinmojmotisnequiya ica quincastigarosquej, niman quemaj oquinmacajquej. Xoquinextijquej quen ijqui huelis quincastigarosquej pampa nochi tlacatl quiyectenehuaya Dios ipampa on tlen onochiu. ");
INSERT INTO nguNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","On tlacatl, yejhuan opajtic ican on milagro, quipiaya más de ompoajli xipan. ");
INSERT INTO nguNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ijcuac Pedro niman Juan yoquinmacajquej, oyajquej ne campa nemiyaj on intehuicalhuan, niman oquintlajtlajtohuilijquej nochi tlen oquimilijquej intlayecancahuan on tiopixquej niman on tlajtlajmatquej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Niman ijcuac on tlaneltocaquej yocacquej, nochimej yejhuamej onohueyicatzajtzilijquej itech Dios ican san se inyojlo. Oquijlijquej: ―ToTeco, tejhua tiDios yejhuan oticchijchiu on cielo, niman in tlalticpactli, niman on mar niman nochi tlajtlamach tlen impan oncaj. ");
INSERT INTO nguNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tejhua otiquijtoj itechcopa moEspíritu Santo niman itechcopa motequitcau David: ¿Tlica najcomanaj on países? ¿Tlica on tlalticpactlacamej quinemiliaj on tlen xitlaj quijtosnequi? ");
INSERT INTO nguNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ireyes in tlalticpactli san secan nemiyaj niman on tlayecanquej onosentlalijquej para quixnamiquisquej ican tlahuejli toTeco Dios niman iCristo yejhuan oquitlapejpenij para techmandaros. ");
INSERT INTO nguNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Melahuac ijcon onochiu pampa Herodes niman Poncio Pilato onosentlalijquej nican ipan in hueyican inhuan on yejhuan xhebreos niman no inhuan hebreos. Yejhuamej, tej, onosentlalijquej para oquixnamiquij ican tlahuejli on moyecConetzin Jesús yejhuan otictlapejpenij para techmandaros. ");
INSERT INTO nguNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ijcon, tej, yejhuamej oquichijquej nochi tlen tejhua oticnec niman yotictlalijcaj moyojlo para nochihuas. ");
INSERT INTO nguNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Niman aman toTeco Dios, xquita quen techchicajcanahuatiaj, niman xquincahuili motequitcahuan para ma quiteijlijcan motlajtol ican nochi yolchicahualistli. ");
INSERT INTO nguNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Niman ican mopoder ma quimpajtican on cocoxquej niman ma quinchihuacan tlamajhuisoltin niman milagros ican itocatzin moyecConetzin Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ijcuac otlanquej ica nohueyicatzajtziliaj, ne campa onosentlalijquej otlalolin, niman on Espíritu Santo nochi ica quinyecanaya nochimej, niman otemachtijquej itlajtol Dios ican yolchicahualistli. ");
INSERT INTO nguNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nochimej on tlaneltocaquej san se inyojlo niman san se intlamachilis quipiayaj. Niman xacaj quijtohuaya tla itlaj iyaxca catca on tlen quipiaya, yej nochi on tlajtlamach insepanyaxca catca. ");
INSERT INTO nguNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Niman ican hueyi chicahualistli on apóstoles oc quiteixpantiliayaj quen toTeco Jesús onoyolihuitij niman onoquetzteu ne ipan itlalcon. Niman Dios sanoyej oquintiochiu nochimej yejhuamej. ");
INSERT INTO nguNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Intzajlan xacaj nemiya yejhuan itlaj quipolojticatca, pampa nochimej on yejhuan quipiayaj intlalhuan noso incalhuan quinnamacayaj, niman on tomin cuajcuiyaj ");
INSERT INTO nguNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","niman quinmactiliayaj on apóstoles. Niman on apóstoles quinxelohuiliayaj ocsequimej quen se quipolojticaj. ");
INSERT INTO nguNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ne tetzajlan nemiya se levita, itoca catca José, yejhuan ijqui oquichiu. Yejhua otlacat ne ipan on tlalhuactli itoca Chipre. Niman on apóstoles oquitocayotijquej Bernabé yejhuan quijtosnequi teyoltlalijquetl. ");
INSERT INTO nguNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yejhua in tlacatl oquinamacac se tlajli niman on tomin ocuajquic niman oquinmactilij on apóstoles para quimpalehuisquej on yejhuan quimpolojticaj. ");
INSERT INTO nguNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero se tlacatl itoca catca Ananías ihuan Safira isihuau no oquinamacaquej se tlajli. ");
INSERT INTO nguNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yejhua in tlacatl sequi oquixpachoj on tomin niman on ocsequi oquinmactilij on apóstoles quen nochi yesquia. Niman isihuau nochi quimatzticatca. ");
INSERT INTO nguNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Niman quemaj Pedro oquijlij: ―Ananías, ¿tlica oticahuilij Satanás ocalac ipan moyojlo niman omitzchihualtij para ticajcayahuasnequiya on Espíritu Santo? ¿Tlica, tej, sequi otiquixpachoj on tomin yejhuan ica omitztlaxtlahuilijquej on motlal? ");
INSERT INTO nguNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ijcuac xe ticnamacaya ¿xmoyaxca catca on tlajli? Niman ijcuac oticnamacac ¿xmoyaxca catca on tomin? ¿Tlica, tej, ijcon oticnemilij ticchihuas? Ticnemilia tejhuamej otitechcajcayau, yej xmati ica Dios ticajcayahuasnequiya. ");
INSERT INTO nguNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ijcuac Ananías ijquin ocac, ohuetztiaj niman omic. Niman nochimej yejhuamej yejhuan oquimatquej on tlen onochiu sanoyej onomojtijquej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Quemaj ohualajquej semej telpocamej, niman oquitejcuixquej itlalnacayo. Quemaj ocuicaquej niman oquitocatoj. ");
INSERT INTO nguNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Canaj ipan ocse yeyi hora ocalaquito on isihuau Ananías. Yejhua xquimatiya tlinon yonochiu. ");
INSERT INTO nguNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ijcuacon Pedro oquitlajtoltij: ―Xnechijli, ¿melahuac san ichquich in onenquinamacaquej nemotlal? Niman yejhua oquinanquilij: ―Quemaj, san ichquich. ");
INSERT INTO nguNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ijcuacon Pedro oquijlij: ―Man, ¿tlica onemotlajtolmacaquej para nenquitlatlatasquej iEspíritu toTeco? Aman nican quiahuatenco huajlahuij on yejhuan yoquitocatoj mohuehuentzin, niman aman tejhua no mitzhuicasquej niman mitzontocasquej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Quemaj nimantzin ohuetztiaj icxitlan Pedro niman omic. Ijcuac ocalaquitoj on telpocamej, oquitatoj yomic. Yejhuamej oquixtijquej niman oquitocatoj inacastlan ihuehuentzin. ");
INSERT INTO nguNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Niman nochimej on tlaneltocaquej, niman nochimej yejhuan oquimatquej on tlen onochiu, sanoyej onomojtijquej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","On apóstoles quichihuayaj miyec milagros niman tlamajhuisoltin ne intzajlan on tlacamej. Niman nochimej on tlaneltocaquej nosentlaliayaj ne campa itoca iCorredor Salomón. ");
INSERT INTO nguNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Niman nochimej on ocsequimej xquinequiyaj tehuan nonelosquej, masqui quipiayaj miyec tetlacaitalistli intech on apóstoles niman on tlaneltocaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Niman on yejhuan tlaneltocayaj itech toTeco más miyequiayaj, sanquen tlacamej niman sihuamej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ijcon, tej, quinhuaquixtiayaj on cocoxquej ne ipan calles niman quintlaliayaj ipan intlapech noso ipan impetl para ijcuac panos Pedro masqui san itlasehualo quimajsis semej yejhuamej ijcuac panos. ");
INSERT INTO nguNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Niman ipan on pueblos nijnisiu iyehualican, no yayaj tojlamej ne Jerusalén. Quinhuicayaj incocoxcahuan niman on yejhuan quipiayaj on xcuajcualtin espíritus. Niman nochi pajtiyaj. ");
INSERT INTO nguNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ijcuacon inmás hueyi tlayecancau on tiopixquej niman nochimej on yejhuan ihuan nemiyaj yejhuan nopohuayaj inhuan on saduceos sanoyej quinnexicolitayaj on apóstoles. ");
INSERT INTO nguNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yejhua ica, tej, yejhuamej oquimajsiquej on apóstoles niman oquintzacuatoj. ");
INSERT INTO nguNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ijcuac tlayohua se ilhuicactequitquetl, yejhuan toTeco ocuajtitlan, oquitlapoj itlatzacuilyo on cárcel, oquinquixtij, niman oquimijlij: ");
INSERT INTO nguNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Xhuiyan niman xmomanacan ne ipan on hueyi tiopan. Xquintlajtlajtohuilican on tlacamej on temachtijli ica in yencuic nemilistli. ");
INSERT INTO nguNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","On apóstoles oquitlacamatquej niman ijcuac otlanes ocalaquej ne ipan on hueyi tiopan niman opeu temachtiaj. Ijcuac yoajsic inmás hueyi tlayecancau on tiopixquej niman on yejhuan ihuan ompa nemiyaj, oquinsentlalijquej nochimej on tetlacanojnotzquej niman nochimej on tlajtlajmatquej hebreos. Quemaj oquintitlanquej on policías ne ipan cárcel para cominnanasquiaj on apóstoles. ");
INSERT INTO nguNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero ijcuac on policías oajsiquej xoquinnextijquej on apóstoles. Yejhua ica ohuajnocuepquej niman oquitemachiltitoj. ");
INSERT INTO nguNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Oquijtojquej: ―Ijcuac otajsiquej, oticnextijquej on cárcel cuajli tzacuticaj ican llave niman on soldados majmantoquej ne ixpan on tlatzacuilomej. Pero ijcuac otitlatlapojquej xacaj oticnextijquej ne tlaijtic. ");
INSERT INTO nguNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ijcuac ocacquej on tlajtojli, intlayecancahuan on tiopixquej niman intlayecancau on policía ne ipan on hueyi tiopan niman on huejhueyi tiopixquej oometlamatquej, niman quinotlajtoltiayaj canon onquisas nochi yejhua in tlen onochiu. ");
INSERT INTO nguNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Quemaj oyejcoc se tlacatl yejhuan oquimijlij: ―Xcaquican. On tlacamej yejhuan onenquintzacucaj nemij ne hueyi tiopan, niman quinmachtiaj on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ijcuacon on intlayecancau on policía niman on policías oyajquej niman oquimanatoj on apóstoles san ica cuajloticaj, pampa quinmacajsiaj on tlacamej. Cuitiayaj ica on tlacamej quinmojmotlasquiaj. ");
INSERT INTO nguNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ijcuac oquinhuajhuicaquej, oquinmanquej ixpan on tetlacanojnotzquej, niman on más hueyi tlayecanqui intech on tiopixquej oquintlajtoltijquej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ijquin oquimijlijquej: ―Sanoyej otimechchicajcanahuatijquej para ma ca sa xtemachtican ican itoca Jesús. Aman xquitacan on tlen onenquichijquej. Yonenquitemiltijquej ican nemotemachtil imanyan nochi Jerusalén niman nenquinequij nentechtlajtlacoltisquej ica imiquilis on tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Quemaj Pedro niman on ocsequimej apóstoles otlananquilijquej: ―Quimelahua tictlacamatisquej achtoj Dios xquen nemejhuamej yejhuan san nentlacamej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","InDios on toachtojtajhuan oquiyolihuitij niman oquetzteu Jesús on yejhuan onenquimictijquej ijcuac onenquimajmasohualtiquej ne ipan cojnepanojli. ");
INSERT INTO nguNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios oquitlalij Jesús hueyi tlayecanquetl niman temaquixtijquetl ne iyecmacopa para cahuilis on hebreos ma noyolcuepacan niman para quipopolosquej nochi quech tlajtlacojli. ");
INSERT INTO nguNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Niman tejhuamej ticteixpantiliaj nochi in quech tlajtlamach, niman no quiteixpantilia on Espíritu Santo yejhuan oquinmacac Dios on yejhuan quitlacamatij. ");
INSERT INTO nguNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ijcuac on tetlacanojnotzquej ocacquej on, cualaniyaj sanoyej hasta quinequiliayaj para quinmictisquej on apóstoles. ");
INSERT INTO nguNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero ne intzajlan on tetlacanojnotzquej nemiya se fariseo, itoca Gamaliel, yejhuan temachtijquetl catca ica on tlanahuatijli. Nochi tlacatl sanoyej quitlacaitayaj. Yejhua onotelquetz niman otlanahuatij ma quinquixtican on apóstoles achijtzin ne quiahuac. ");
INSERT INTO nguNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Quemaj oquimijlij on tetlacanojnotzquej: ―Tlacamej hebreos, xmotacan sa no nemejhuamej tlinon nenquinchihuilisquej on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xquelnamiquican nemejhuamej ica nemiya se tlacatl itoca Teudas yejhuan quijtohuaya ica yejhua se tlacatl hueyixticaj, niman oquistinen ihuan canaj nahui ciento tlacamej. Pero se tonajli yacaj oquimictij niman nochimej yejhuan ihuan oquistinenquej onochajchayajquej, niman nochi ompa otlan. ");
INSERT INTO nguNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Más saquin Judas, yejhuan chanej ne Galilea, ohuajlaj ipan on tonaltin ijcuac onijcuiloloc ne ipan on censo. Niman miyequej ihuan oquistinenquej, pero no omic niman nochimej yejhuan ihuan oquistinenquej onochajchayajquej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yejhua ica, nemechijlia xquincahuacan in tlacamej. Ma ca itlaj ica xmocalactican, pampa on intemachtil on apóstoles noso on tlen nochihua tla san intech tlacamej quisa, popolihuis. ");
INSERT INTO nguNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero tla yejhua in quisa itech Dios, xnenhuelisquej nenquixoxotonisquej, yej nenquitlahuelixnamictiasquej Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Niman yejhuamej oquiselijquej on tlen Gamaliel oquijtoj. Quemaj ijcuac oquinhuajhuicaquej on apóstoles, oquinnotzquej, niman ijcuac yoquinhuijhuitequej, oquinnahuatijquej ma ca sa tenojnotzacan ican itoca Jesús. Quemaj oquinmacaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","On apóstoles ohuajquisquej ne imixpan on tetlacanojnotzquej ican pactli, pampa Dios oquincahuilij oquimpijpinahuijquej pampa quineltocayaj Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Niman mojmostla ne hueyi tiopan niman techajchan xcajcahuayaj ica temachtiayaj niman tenojnotzayaj ica Jesucristo. ");
INSERT INTO nguNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ipan on tonaltin on nomachtijquej más sanoyej miyequixtiayaj. Niman on yejhuan tlajtlajtohuaj griego opeu chicotlajtohuayaj intech on yejhuan tlajtlajtohuaj hebreo, pampa on sihuacahualtin de on griegos xijqui quiseliayaj tlajcuajli quen on sihuacahualtin intech on hebreos ijcuac mojmostla quinxelohuiliayaj on tlajcuajli. ");
INSERT INTO nguNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ijcuacon on majtlactli huan omemej apóstoles oquinsentlalijquej nochimej on nomachtijquej, niman oquimijlijquej: ―Xcuajli para tejhuamej ticajcahuasquej ica ticteijlisquej on itlajtol Dios para titexelohuilisquej on tlajcuajli. ");
INSERT INTO nguNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yejhua ica, tej, nocnihuan, xquintlapejpenican chicome tlacatl nican nemotzajlan yejhuan quintlacaitaj, niman yejhuan on Espíritu Santo nochi ica quinyecana ipan inemilis niman yejhuan quipiaj miyec tlamatquilistli. Quemaj yejhuamej tiquincalactisquej ipan yejhua on tequitl. ");
INSERT INTO nguNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Niman ijcon, tej, tejhuamej xticajcahuasquej ica ticchihuasquej oración niman ica tictemachtisquej itlajtol Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Niman nochimej ocuelcaquej yejhua ica in, niman oquitlapejpenijquej Esteban yejhuan quineltocaya Jesús ican nochi iyojlo, niman yejhuan quinocahuiliaya quiyecanaya ipan nochi inemilis on Espíritu Santo. No oquintlapejpenijquej Felipe, Prócoro, Nicanor, Timón, Parmenas niman Nicolás yejhuan hualehuaj ne Antioquía. Ijcuac Nicolás xe quineltoca Cristo, oquineltocac Dios quen on hebreos masqui xhebreo. ");
INSERT INTO nguNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Quemaj oquinhuajhuicaquej imixpan on apóstoles, niman on apóstoles impampa onohueyicatzatzilijquej on niman oquitlalijquej inmahuan impan. ");
INSERT INTO nguNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","On itlajtol Dios nochayajtiaya intech miyequej ocsequimej. Niman on nomachtijquej sanoyej miyequixtiayaj ne Jerusalén, niman hasta miyequej tiopixquej quiseliayaj on tlaneltoctli. ");
INSERT INTO nguNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dios sanoyej oquitiochiu Esteban niman oquimacac poder. Yejhua ica, Esteban quichihuaya milagros niman tlamajhuisoltin intzajlan on tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ijcuacon semej on yejhuan nopohuaj ipan intiopan on hebreos, itoca “Tlanamactin Tlamacahualtin”, inhuan ocsequimej yejhuan hualehuaj ne intech on huejhueyican Cirene niman Alejandría, niman ne Cilicia niman Asia, opejquej quitlajtolixnamiquij Esteban. ");
INSERT INTO nguNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero xhueliyaj quitentlaniyaj, pampa yejhua tlajtohuaya ica on tlamachilistli yejhuan quimacaya on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yejhua ica quimichtacanahuatiayaj ocsequimej tlacamej para ma quijtocan ica yejhuamej ocaquilijcaj cuijhuijhuicaltia Moisés niman Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Niman ijquin, tej, oquimajcomanquej on tlacamej inhuan on tlajtlajmatquej niman on temachtijquej ican tlanahuatijli. Yejhuamej oyajquej itech Esteban, ocajsiquej niman ocuajhuicaquej ne imixpan on tetlacanojnotzquej. ");
INSERT INTO nguNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Niman no oquintlalijquej on istlacatquej para ijquin ma quijtocan: ―Yejhua in tlacatl xcajcahua on ica cuijhuicaltia in yectiticaj tiopan, niman itech on itlanahuatil Moisés. ");
INSERT INTO nguNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ticaquiliaj quijtohua ica Jesús yejhuan hualehua Nazaret cuajxoxotonis in yectiticaj tiopan, niman cuajpatlas in tlajtlamach tlanahuatijli yejhuan Moisés otechmacac. ");
INSERT INTO nguNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ijcuacon nochimej on tetlacanojnotzquej yejhuan ompa yejyehuaticatcaj ontlachixquej ixco Esteban, niman oquitaquej ixayac yonocau quen ixayac se ilhuicactequitquetl. ");
INSERT INTO nguNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Quemaj inmás hueyi tlayecancau on tiopixquej oquitlajtoltij Esteban: ―¿Tlen melahuac nochi yejhua in quen mitzteixpanhuiyaj? ");
INSERT INTO nguNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Niman yejhua oquinanquilij: ―Notlajsojcaicnihuan niman tatajtin, xnechcaquican. On hueyixticaj Dios oquinotitij totataj Abraham ijcuac yejhua nemiya ne Mesopotamia, ijcuac xe onchantiya ne Harán. ");
INSERT INTO nguNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Niman Dios oquijlij: “Xquisa nican motlalpan niman xquincajtehua mochanejcahuan, niman xhuiya ne ipan on tetlalpan yejhuan nimitzititis.” ");
INSERT INTO nguNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ijcuacon Abraham oquis ne intlalpan on caldeos niman ochantito ipan on pueblo itoca Harán. Niman ijcuac yomic itataj, Dios oquititlan Abraham ipan in tlajli campa aman nemejhuamej nenchantij. ");
INSERT INTO nguNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero xoquimacac nion se herencia ipan in tlajli, nion siquiera campa quitlalis se icxi. Pero Dios oquimacac ipromesa ica quimacas yejhua niman sanquin ijcuac miquis quincahuilijtejhua ihuejcaconehuan, masqui ipan on tonaltin Abraham oc xquimpiaya iconehuan. ");
INSERT INTO nguNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Niman Dios oquijlijca ica ihuejcaconehuan chanejquej yesquej ipan se tlajli yejhuan xinyaxca, niman ica ompa tlanamactin yesquej, niman quintlajyohuiltisquej nahui ciento xipan. ");
INSERT INTO nguNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero Dios no oquijlij: “Nictlajtlacolmacas on país yejhuan quimpias tlanamactin niman quemaj yejhuamej quisasquej ompa, niman nechajtequipanosquej nican.” ");
INSERT INTO nguNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Quemaj Dios oquitlalij se pacto ihuan Abraham niman oquinahuatij ma quitlali se nescayotl, itoca circuncisión, ipan inacayo para nestias ica oquiselij on pacto. Quemaj Abraham onochiu tajtli ican Isaac niman ipan oquitlalij on nescayotl de circuncisión ijcuac quipiaya chicueyi tonajli ica onen. Niman no ijqui oquichiu Isaac ihuan Jacob on iconeu, niman Jacob no ijqui oquichiu inhuan iconehuan on yejhuan onochijquej tatajtin intech on majtlactli huan ome chanejquej de Israel. ");
INSERT INTO nguNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Iconehuan Jacob oquinexicolitaquej José on imicniu, niman oquinamacaquej para ocuicaquej ne ipan on país Egipto. Pero Dios xqueman ocau José ");
INSERT INTO nguNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","niman oquimanahuij ipan nochi tlen teyolcocoj. Oquimacac tlamachilistli niman oquipalehuij para quipactis Faraón on irey on país Egipto. Niman on rey oquitlalij José quen más hueyi tlayecanquetl itech on país Egipto niman no sa no itech nochi tlin iyaxca on rey. ");
INSERT INTO nguNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Quemaj ohuajlaj se mayantli yejhuan sanoyej oquintlajyohuiltij on chanejquej nochihuiyan ne Egipto niman Canaán. Ijcon, tej, on totajhuan xquinextiayaj tlen quicuasquej. ");
INSERT INTO nguNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Niman ijcuac Jacob oquimat ica ne Egipto oncatca trigo, ompa oquintitlan iconehuan yejhuan toachtojtajhuan. Ipan in tonaltin quemach yeica oyajquej. ");
INSERT INTO nguNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ijcuac on toachtojtajhuan ica ocpa oyajquej ne Egipto, José oquichiu para ma quixmatican on icnihuan, niman no oquichiu para irey Egipto ma quimati aquinon itech hualejticaj. ");
INSERT INTO nguNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Quemaj José otlatitlan ma cuajhuiquilican itaj Jacob ne Egipto niman nochi ichanchanejcahuan yejhuan canaj yepoajli huan majtlactli ipan macuijli tlacamej catcaj. ");
INSERT INTO nguNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Niman ijcon Jacob otemoc, niman ochantic ne Egipto campa saquin ompa omic niman campa no omiquej on toachtojtajhuan. ");
INSERT INTO nguNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Saquin oquinhuicaquej on micatzitzintin ne Siquem niman ompa oquintocaquej ipan on tlalcontli yejhuan Abraham oquincohuilijca on iconehuan Hamor ne Siquem. ");
INSERT INTO nguNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ijcuac ye nisiu para nochihuas on tlen Dios yoquimelajcaijlica Abraham, on hebreos ne Egipto sanoyej omiyequiaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Quemaj ne Egipto opeu tequihuajti se rey yejhuan xoquimat itech ica José. ");
INSERT INTO nguNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yejhua in yencuic rey oquincajcayau tlamach ica on tochantlacaj hebreos, niman xcuajli oquimpix on toachtojtajhuan hasta quinchihualtiaya para ma quincahuatij inconehuan ne tlapatlaco yejhuan quemach tlacatij para ompa ma miquican. ");
INSERT INTO nguNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sa no ipan on tonaltin otlacat Moisés niman yejhua oquipacaitac Dios. Niman Moisés oquiscaltijquej yeyi metztli ichan itaj. ");
INSERT INTO nguNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Niman ijcuac oquicahuatoj Moisés ne tlapatlaco, ichpoch on rey ne Egipto oquinextito, niman oquiscaltij quen iconeu yesquia. ");
INSERT INTO nguNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Niman oquimachtijquej Moisés nochi on tlajtlamach yejhuan on egipcios nomachtiaj, niman Moisés nochi hueliya quijtohuaya niman quichihuaya. ");
INSERT INTO nguNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Ijcuac Moisés ye quipiaya ompoajli xipan, oquinec cominnotzas on ichantlacaj hebreos. ");
INSERT INTO nguNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ompa oquitac ica se egipcio cuijsoquia se de yejhuamej on hebreos. Yejhua, tej, oquimanahuij on hebreos, niman ocuepiltij on egipcio yejhuan temailiaya hasta oquimictij. ");
INSERT INTO nguNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ijcuac ijcon oquichiu quinemiliaya ica on ichanchanejcahuan hebreos cajsicamatisquiaj ica Dios yejhua itechcopa quinmaquixtisquia, pero yejhuamej xocajsicamatquej. ");
INSERT INTO nguNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Niman ijcuac huajmostla, Moisés oquinnextito omemej hebreos yejhuan nohuijsoquiyaj. Pampa quinequiya quintlahuelsehuis, yejhua oquimijlij: “Tlacamej, nemejhuamej nemicniutin. ¿Tlica, tej, ijcon nenquimochihuiliaj?” ");
INSERT INTO nguNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","’Ijcuacon on yejhuan cuijsoquia on itehuical oquimapejtiaj Moisés, niman oquijlij: “¿Aquinon omitztlalij para toca titequihuaj yes niman para titechtlajtlacolmacas? ");
INSERT INTO nguNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿No ticnequi tinechmictis quen yalohua oticmictij on egipcio?” ");
INSERT INTO nguNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Niman ijcuac Moisés oquimat ica on tlacamej oquimatquej ica oquimictijca se egipcio, ocholojteu niman oyaj ne ica Madián. Ompa ochantic quen se yejhuan xchanej, niman oquipix ome iconeu. ");
INSERT INTO nguNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Niman ijcuac yopanoc on ompoajli xipan, se ilhuicactequitquetl oquinotitij ican se tlimilinajli ipan se tlacotepajsojli ne campa tlapatlaco, nisiu on tepetl itoca Sinaí. ");
INSERT INTO nguNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ijcuacon Moisés sa tlamojcaitzticatca ica on tlen oquitac. Niman ijcuac oquinisihuij para más cuajli quitas, ocac itlajtol toTeco yejhuan quijtohuaya: ");
INSERT INTO nguNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nejhua niinDios on moachtojtajhuan. NiiDios Abraham, Isaac niman Jacob. Ijcuacon Moisés opeu mojcacuecuetlacaya, niman xquichihuaya canica para ontlachas.” ");
INSERT INTO nguNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Quemaj on toTeco oquijlij: “Xquinquixti mocachuan pampa nican campa ticholojticaj sanoyej tlayecan. ");
INSERT INTO nguNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Melahuac yoniquintac quen tlajyohuiyaj noconehuan yejhuan chantij ne Egipto, niman niquincaqui quen chocaj ican ajmantli. Aman yonitemoc para niquinmanahuis. Xhuajla, tej, nimitztitlanis ne Egipto.” ");
INSERT INTO nguNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Aman, tej, sa no yejhua on Moisés on yejhuan xoquitlacamatquej niman oquijlijquej: “¿Aquinon omitztlalij para toca tequihuaj yes niman para titechtlajtlacolmacas?” Dios oquititlan para tlayecanquetl niman para temaquixtijquetl yes. Ijcon oquititlan itechcopa on ilhuicactequitquetl yejhuan oquinotitij ne ipan on tlacotepajsojli. ");
INSERT INTO nguNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés, tej, yejhua oquinquixtij on hebreos ne Egipto. Niman yejhua oquichiu milagros niman tlamajhuisojli ne Egipto niman ne ipan on mar Rojo, niman ne tlapatlaco campa onenquej ompoajli xipan. ");
INSERT INTO nguNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Aman sa no yejhua on Moisés yejhuan oquimijlij on hebreos: “Dios mechajtitlanilis se tiotlajtojquetl yejhuan sa no nemotzajlan quisas ijcon quen nejhua onechajtitlan. Xcaquican tlinon yejhua mechijlis.” ");
INSERT INTO nguNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Niman Moisés no yejhua onen inhuan on tlacamej yejhuan onosentlalijquej ne campa tlapatlaco. Yejhua onen ihuan on ilhuicactequitquetl yejhuan oquinotz ne ipan on tepetl itoca Sinaí niman inhuan on toachtojtajhuan. Niman no yejhua oquiselij on cuajli tlajtojli yejhuan quitemaca nemilistli para otechpanoltilij. ");
INSERT INTO nguNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero on toachtojtajhuan xoquinequej oquitlacamatquej, yej neca ocomapejquej, niman ocsejpa quinequiyaj para nocuepasquej ne Egipto. ");
INSERT INTO nguNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yejhuamej oquijlijquej Aarón: “Xtechchijchihuili totajtzitzihuan para techyecanasquej tejhuamej, pampa Moisés, on aquin otechquixtij ne tetlalpan Egipto, xticmatij tlinon ipan yonochiu.” ");
INSERT INTO nguNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Quemaj oquichijchijquej se huacaxconetl niman oquinmictijquej yolquej para ocuentlalilijquej itech on intotajtzin, niman opacquej yejhua ica on tlen oquichijchijquej ican inmahuan. ");
INSERT INTO nguNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ijcuacon Dios oquintlalcahuij niman oquincahuilij para ma quinmahuistilican on tlahuiltin yejhuan quech tlahuilohuaj ne ipan cielo ijcon quen tlajcuilolnesticaj ipan on intlajcuilolamau on tiotlajtojquej: Nemehuamej chanejquej ne Israel, ¿onenquinmictijquej on yolquej para nennechixpantilisquej nejhua ipan on ompoajli xipan ne tlapatlaco? ");
INSERT INTO nguNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ca. Yej nenquitquiyaj on itiopantzin on dios Moloc niman on isitlalin on dios Renfán. Yejhua in tlajtlamach onenquinmachijchijquej para onenquinmahuistilijquej. Yejhua ica, tej, nejhua nemechquixtis ne ipan nemopaís niman nemechtitlanis más huejca iyacapan on Babilonia. ");
INSERT INTO nguNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Ne campa tlapatlaco on toachtojtajhuan quipiayaj on tlaquentiopan hueyi campa quejehuayaj on temej yejhuan ipan tlajcuilolnesticatca on tlanahuatijli. Ijcon, tej, quipiayaj on quen Dios oquinahuatij Moisés para ma quichijchihua ijcon quen yejhua oquititij. ");
INSERT INTO nguNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Quemaj más saquin toachtojtajhuan oquinmacaquej inconehuan on tlaquentiopan. Niman quemaj yejhuamej oquitquiquej ijcuac oyajquej ihuan Josué niman oquinoyaxcatijquej intlal on xhebreos yejhuan Dios oquinquixtij imixpan on toachtojtajhuan. Ijcon, tej, onochiu hasta ipan on tonaltin ijcuac David nemiya. ");
INSERT INTO nguNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios ican iteicnelilis oquiselij David, niman David oquitlajtlanilij para cahuilis ma quichijchihuili se tiopan para iDios Jacob chantis. ");
INSERT INTO nguNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero Salomón yejhua oquichijchihuilij ihueyi tiopan Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero tohueyi Dios xchanti ipan tiopantin yejhuan tlacamej quichijchihuaj. Ijquin quijtohua on tiotlajtojquetl: ");
INSERT INTO nguNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ToTeco Dios quijtohua: “On ilhuicac on campa nehuaticaj niman on tlalticpactli on campa nicholojticaj. Tla ijcon, tej, xhuelis tinechchijchihuilis tiopan campa nichantis. Nion xoncaj canon campa ninosehuis. ");
INSERT INTO nguNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Tlen xnejhua ican nomahuan onicchijchiu nochi in tlajtlamach?” ");
INSERT INTO nguNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Quemaj Esteban oquimijlij: ―Nemejhuamej nochipa ijcon nenquichihuaj, sanoyej nenyoltechicajquej. Xnenquinequij nencaquisquej itlajtol Dios nion xnenquinequij nenquitlacamatisquej. Yej nochipa xipan nenquitaj on Espíritu Santo. Ijcon quen nemotajhuan onohuicajquej, no ijqui nemejhuamej nemohuicaj. ");
INSERT INTO nguNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nemoachtojtajhuan oquintlahuelitaquej niman tlajtlamach ica oquitlayohuiltijquej nochimej on tiotlajtojquej. Oquinmijmictijquej on yejhuan oquiteijlijquej ica huajlas on yolmelajqui, niman aman ica yohuajlaj nemejhuamej onenquitemactilijquej niman onenquimictijquej. ");
INSERT INTO nguNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Masqui onenquiselijquej itlanahuatil Moisés intechcopa on ilhuicactequitquej, xnenquitlacamatij. ");
INSERT INTO nguNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ijcuac yejhuamej ocacquej on tlajtlamach, ocualanquej sanoyej ipan inyojlo itechcopa Esteban, hasta notlantisiyaj ican intlahuel. ");
INSERT INTO nguNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero on Espíritu Santo nochi ica quiyecanaya Esteban, niman yejhua ontlachix ne ilhuicac niman oquitac ihueyilis Dios, niman Jesús ompa ijcaticatca iyecmacopa Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ijcuacon oquijtoj: ―¡Xquitacan! Nejhua niquita on ilhuicac tlapojticaj, niman yejhua on yejhuan onochiu Tlacatl ompa ijcaticaj iyecmacopa Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ijcuacon yejhuamej ononacastzajtzacuquej niman chicahuac otzajtziquej niman quemaj nochimej san secan ipan oyajquej. ");
INSERT INTO nguNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Oquixtijquej ne ipan on hueyican. Quemaj on yejhuan oquiteixpanhuijquej Esteban oquitlalijquej intlaquen ne icxitlan se telpochtli itoca Saulo, niman opeu quitemojmotlaj. ");
INSERT INTO nguNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Niman chica quitemojmotlayaj, Esteban onohueyicatzajtzilij. Ijquin oquijtoj: ―NoTeco Jesús, xnechselili nonemilis. ");
INSERT INTO nguNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Quemaj onotlacuenquetz niman chicahuac otzajtzic: ―NoTeco, ma ca tiquintlajtlacolmacas yejhua ica in tlajtlacojli. Niman quemaj ijcuac ijquin oquijtoj, ohuajnotlamilij. ");
INSERT INTO nguNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Niman Saulo tehuan quimatiya para ma quimictican Esteban. Ipan on tonajli opeu quintlahueltotocatinemij niman quintlajyohuiltiaya sanoyej on yejhuan tlaneltocaquej ne Jerusalén. Ijcon, tej, nochimej on tlaneltocaquej ochojcholojquej ne ica miyecan ipan iregión Judea niman ne ica Samaria, pero on apóstoles onocajquej. ");
INSERT INTO nguNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Quemaj sequimej tlacamej yejhuan cuajli quitlacamatij Dios oquitocatoj Esteban, niman sanoyej oquichoquilijquej. ");
INSERT INTO nguNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Niman Saulo opeu quintlahueltotocatinemi niman quintlajyohuiltiaya on yejhuan tlaneltocaj. Yejhua calaquiya techajchan niman quinhuajquixtiaya hasta quintejchihuilanaya on tlacamej niman sihuamej para comintzacuaya. ");
INSERT INTO nguNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yejhuamej on yejhuan onochajchayajquej oyajquej nochihuiyan quiteijlijtiayaj on cuajli tlajtojli yejhuan quitemaca temaquixtilistli. ");
INSERT INTO nguNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ijcuacon Felipe otemoc ipan se hueyican ne Samaria niman opeu tenojnotzaya ica Cristo. ");
INSERT INTO nguNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","On tojlamej nosentlaliayaj niman ican se inyojlo cuelcaquiyaj on tlajtlamach yejhuan Felipe quitohuaya. Caquiyaj niman quitayaj on tlamajhuisoltin yejhuan quichihuaya. ");
INSERT INTO nguNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ijcon, tej, miyequej tlacamej yejhuan quipiayaj on xcuajcualtin espíritus quimpajtiaya niman on xcuajcualtin espíritus tzajtziyaj chicahuac ijcuac quisayaj impan on tlacamej. Niman miyequej on yejhuan sepohuiyaj niman huilatzitzintin quimpajtiaya. ");
INSERT INTO nguNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ijcon, tej, ipan on hueyican nochimej sanoyej paquiyaj. ");
INSERT INTO nguNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero ipan on pueblo nemiya se tlacatl itoca catca Simón. Yejhua nahuajli catca, niman yoquincajcayajca on chanejquej ne Samaria, quimijliaya ica yejhua se tlacatl hueyixticaj. ");
INSERT INTO nguNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nochimej caquiyaj cuajli desde on pipitijquej hasta on yejhuan huejhueyimej, quijtohuayaj: “Yejhua in tlacatl yejhua ihueyi poder Dios.” ");
INSERT INTO nguNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Niman sanoyej cuelitayaj caquiyaj, pampa ye quipiaya miyec tonaltin yoquimixcajcayajca ica inajhuajlo yejhuan hueliya quichihuaya. ");
INSERT INTO nguNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero ijcuac oquineltocaquej on cuajli tlajtojli yejhuan Felipe quiteijliaya ica quen ijqui Dios tlamandarohua niman ica Jesucristo, nocuatequiayaj sanquen tlacamej niman sihuamej. ");
INSERT INTO nguNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Niman hasta Simón no otlaneltocac niman onocuatequij. Yejhua opeu cuicatinemi Felipe, niman ica oquitac on huejhueyi tlamajhuisoltin niman milagros yejhuan nochihuaya sanoyej tlapacaitaya. ");
INSERT INTO nguNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ijcuac on apóstoles yejhuan nemiyaj ne Jerusalén oquimatquej ica miyec tlacatl ne Samaria yoquiselijquej itemachtil Dios, ompa oquintitlanquej Pedro niman Juan. ");
INSERT INTO nguNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ijcuac oajsiquej, oquichijquej oración impampa on tlaneltocaquej ne Samaria para ma quiselican on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ijcon oquichijquej pampa xe yacaj ipan huajtemohuaya on Espíritu Santo, yej san onocuatequijcaj ican itocatzin Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Quemaj Pedro niman Juan oquintlalijquej inmahuan impan yejhuamej, niman ijqui oquiselijquej on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ijcuac Simón oquitac ica on Espíritu Santo huajlaya ijcuac on apóstoles quitlaliayaj inmahuan impan on tlaneltocaquej, oquintequihuiltij tomin, ");
INSERT INTO nguNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","oquimijlij: ―Nejhua no xnechmacacan in poder para ijcuac nejhua nictlalis nomahuan san ipan aquinon, yejhua no quiselis on Espíritu Santo. ");
INSERT INTO nguNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Quemaj Pedro oquijlij: ―Motomin mohuan ma popolihui, pampa ticnemilia ica in poder yejhuan Dios quitemaca huelis ticohuas. ");
INSERT INTO nguNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Xhuelis timopohuas tohuan nion xmitzmelahua ticchihuas yejhua in tequitl, pampa xtiyolchipahuac ixpan Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Xcajcahua on tlen xcuajli ticchihua, niman xtlajtlanili Dios para tiquitas tla mitztlapojpolhuilis on tlen ticnemilia ipan moyojlo, ");
INSERT INTO nguNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","pampa niquita ica ticpia nexicolistli ipan moyojlo, niman mitzpia on motlajtlacol quen tlanamactli. ");
INSERT INTO nguNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Quemaj Simón oquimijlij: ―Nopampa xchihuacan oración itech on toTeco para ma ca nopan nochihuas on tlen yonennechijlijquej. ");
INSERT INTO nguNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ijcuac yoquiteixpantilijquej niman yotenojnotzquej ican itlajtoltzin Dios, Pedro niman Juan onocuepquej para Jerusalén. Niman ipan miyec pueblitos ne Samaria campa huajpanotiayaj ompa quiteijliayaj on cuajli tlajtojli yejhuan quitemaca temaquixtilistli. ");
INSERT INTO nguNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Niman ijcuac yonochiu nochi yejhua on, toTeco oquititlan se ilhuicactequitquetl yejhuan oquinotz Felipe, niman oquijlij: ―Xmotelquetza niman xhuiya ne ica ipan sur ipan on ojtli yejhuan temohua ne Jerusalén niman yau hasta Gaza. Yejhua on ojtli panohua ne campa tlapatlaco. ");
INSERT INTO nguNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ijcuacon Felipe ohuajnotelquetz niman oyaj. Niman ipan ojtli oquinamic se tlacatl yejhuan hualehua ne Etiopía. On tlacatl eunucoj catca. Yejhua hueyi tequihuaj catca yejhuan nemiya quen tesorero ica on quech tomin quipiaya on sihuatl itoca Candace yejhuan tequihuaj catca nochi on iregión Etiopía. Yejhua on tlacatl oyajca ne Jerusalén para oquimahuistilito Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yejhua in tlacatl nocuepaya para ichan ipan icarreta, niman huajnomachtijtiaya itlajcuilolamau on tiotlajtojquetl Isaías. ");
INSERT INTO nguNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Quemaj on Espíritu Santo oquijlij Felipe: ―Xhuiya niman xnisihui on carreta. ");
INSERT INTO nguNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Niman Felipe oquinisihuij niman ocac ica nomachtiaya on itlajcuilolamau on tiotlajtojquetl Isaías. Niman oquitlajtoltij, oquijlij: ―¿Ticajsicamati on tlen ticmomachtia? ");
INSERT INTO nguNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Niman yejhua oquinanquilij: ―¿Quen ijqui, tej, nicajsicamatis tla xacaj nechmachtia? Ijcuacon oquitlajtlanilij Felipe para ma tlejco niman ma notlali ihuan. ");
INSERT INTO nguNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Niman ipan on Yectlajcuilojli campa quinomachtijtiaya ijquin quijtohua: Ocuicaquej para miquis quen itlaj borrego. Niman ijcon quen on borreguito xnahuati ijcuac quiximaj, no ijqui yejhua xitlaj oquijtoj. ");
INSERT INTO nguNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Oquipijpinahuijquej niman oquitlajtlacolmacaquej masqui yejhua xoquichiu itlaj tlen xcuajli. Xqueman yacaj huelis quintenehuas iconehuan, pampa oquixtilijquej on inemilis nican tlalticpac. ");
INSERT INTO nguNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","On hueyi tequihuaj oquitlajtoltij Felipe: ―Xchihua se favor. Xnechijli, on tiotlajtojquetl, ¿aquinon quijtohuilia in tlajtlamach? ¿Sa no yejhua notenehuaya, noso quijtohuilia yacaj ocse? ");
INSERT INTO nguNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Quemaj Felipe oquipehualtij quinojnotza desde on Yectlajcuilojli yejhuan quinomachtijticatca, niman hasta nochi oquitlajtlajtohuilij on cuajli tlajtojli itech ica Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Niman ijcuac panotiayaj ipan ojtli, oyejcoquej campa oncatca atl. Niman on hueyi tequihuaj oquijlij Felipe: ―Nican oncaj atl. ¿Xhuelis tinechcuatequis? ");
INSERT INTO nguNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe oquijlij: ―Tla ticneltoca Cristo ican nochi moyojlo, huelis. On tlacatl oquijlij: ―Nicneltoca ica Jesucristo yejhua iConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Niman quemaj on hueyi tequihuaj otlanahuatij ma quiteltican on carreta. Quemaj Felipe niman on hueyi tequihuaj otemoquej ompa ne itech on atl, niman Felipe ocuatequij. ");
INSERT INTO nguNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Niman ijcuac huajtlejcojtiayaj ne itech on atl, on iEspíritu toTeco oquejcuanij Felipe nimantzin, niman on hueyi tequihuaj xoc oquitac, pero yejhua oyaj ipan iojhui ican pactli. ");
INSERT INTO nguNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe ononextito ne ipan on hueyican itoca Azoto. Yejhua panotiaya niman quiteijlijtiaya on cuajli tlajtojli yejhuan quitemaca temaquixtilistli. Ijcon quichihuaya ipan nochimej on pueblos hasta ijqui oajsic ne Cesarea. ");
INSERT INTO nguNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo oc tlamomojtijtinemiya niman quintlajtohuilijticatca ica quinmijmictis on tlaneltocaquej itech toTeco. Yejhua ica, tej, oyaj itech on inmás hueyi tlayecancau on tiopixquej, ");
INSERT INTO nguNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","niman oquitlajtlanilij se amatlanahuatijli yejhuan ica nopresentarosquia ne ipan intiopanhuan on hebreos ne hueyican Damasaco, niman comintejtemosquia on yejhuan quitlacamatiyaj on cuajli temachtijli. Niman ijcuac quinnextisquia sanquen tlacamej niman sihuamej, quinhuajtzacuasquia ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pero chica yaya ipan ojtli ne nisiu Damasco, nimantzin ohuajpetlan ne iyehualican se tlahuijli yejhuan hualejticatca ne ilhuicac. ");
INSERT INTO nguNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ijcuacon Saulo ohuetz ipan tlajli, niman ocac se tlajtojli yejhuan oquijlij: ―Saulo, saulo, ¿tlica tinechtlahuelita niman tinechtlajyohuiltijtinemi? ");
INSERT INTO nguNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Niman yejhua oquinanquilij: ―¿Aquin tejhua Señor? Niman on tlajtojli oquinanquilij: ―Nejhua niJesús aquin tinechtlahuelita niman tinechtlajyohuiltijtinemi. Sa no tejhua timocojcocohua ijcon quen nocojcocohua se huacax ijcuac quitejtelicsa ipunta on tlen ica quitzopinijtihuij ijcuac tequiti. ");
INSERT INTO nguNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ijcuacon yejhua sa mojcacuecuetlacaticatca, niman oquijlij: ―Señor, ¿tlinon nonequi ma nicchihua? Niman on toTeco oquijlij: ―Xmotelquetza niman xhuiya ne ipan on hueyican, niman ompa mitzijlisquej tlinon ticchihuas. ");
INSERT INTO nguNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","On tlacamej yejhuan yayaj ihuan Saulo onomojtijquej pampa ocacquej on tlajtojli pero xacaj oquitaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Quemaj Saulo onotelquetz ne ipan tlajli, pero ijcuac oquintlapoj ixtololojhuan xoc tlachaya. Yejhua ica oquimayantiajquej hasta ne Damasco. ");
INSERT INTO nguNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ompa yeyi tonajli xotlachix. Niman xotlacuaj nion xitlaj oconic. ");
INSERT INTO nguNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ne Damasco chantiya se nomachtijquetl itoca Ananías. Niman toTeco oquinotz ipan se tlatlachalistli yejhuan quen itemicpan, niman oquijlij: ―Ananías. Niman yejhua oquinanquilij: ―Nican ninemi noTeco. ");
INSERT INTO nguNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Niman on toTeco oquijlij: ―Xmotelquetza niman xhuiya ne ipan on calle quitocayotiaj “Melajqui”. Niman ompa xtejtemo ne ichan Judas se tlacatl itoca Saulo yejhuan hualehua ne Tarso. Aman, tej, yejhua nohueyicatzajtzilijticaj, ");
INSERT INTO nguNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","niman ipan se tlatlachalistli yejhuan quen itemicpan yejhua oquitac se tlacatl itoca Ananías yejhuan ocalaquito, niman ipan oquitlalij imahuan para ocsejpa huelis tlachas. ");
INSERT INTO nguNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ijcuac Ananías ijcon ocac, oquijlij: ―NoTeco, ye niquincaquilijtinemi miyequej ica on tlacatl quech san tlajtlamach yoquinchihuilij on yejhuan otiquintlapejpenij para moyaxcahuan ne Jerusalén. ");
INSERT INTO nguNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Niman aman yejhua ohuajlaj nican ican se amatlanahuatijli yejhuan intlayecancahuan on tiopixquej oquimacaquej para quinmajsis nochimej on yejhuan quiyectenehuaj motocatzin. ");
INSERT INTO nguNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero on toTeco oquijlij: ―Xhuiya, pampa on tlacatl yonictlapejpenij para tenojnotzas noca nejhua intech on yejhuan xhebreos, niman inreyes niman on hebreos. ");
INSERT INTO nguNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nejhua niquititis quech san tlajtlamach quijyohuis nopampa. ");
INSERT INTO nguNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Quemaj Ananías oyaj ne ipan on cajli campa nemiya Saulo. Ijcuac ocalaquito, oquitlalij imahuan ipan Saulo, niman oquijlij: ―Nocniu Saulo, on toTeco Jesús yejhuan omitznotitij ne ipan on ojtli campa tihuajlaya, onechajtitlan para ocsejpa huelis titlachas, niman para on Espíritu Santo nochi ica mitzyecanas. ");
INSERT INTO nguNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Quemaj nimantzin oxinquej ipan on ixtololojhuan on quen ixcacahuayohuan, niman ocsejpa ohuel otlachix. Quemaj Saulo ohuajnotelquetz, niman onocuatequij. ");
INSERT INTO nguNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Niman ijcuac yotlacuaj, ocsejpa ocajsic chicahualistli. Niman Saulo onocau quesqui tonajli inhuan on tlaneltocaquej yejhuan ompa chanejquej ne Damasco. ");
INSERT INTO nguNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Quemaj nimantzin Saulo opeu temachtia ipan itiopanhuan on hebreos ica Jesús yejhua iConetzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Niman nochimej on yejhuan caquiyaj sa mojcatlachayaj, niman quijtohuayaj: ―¿In tlacatl xejhua quintlahuelita niman quintlajyohuiltia on yejhuan ne Jerusalén quiyectenehuayaj itocatzin Jesús? ¿Xsa no yejhua yejhuan ohuajlaj nican para quinhuicas presos on yejhuan tlaneltocaquej itech Jesús, niman comintemactilis intech intlayecancahuan on tiopixquej? ");
INSERT INTO nguNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero Saulo quimijliaya ican más yolchicahualistli on hebreos ica Jesús melahuac yejhua on Cristo yejhuan Dios oquitlalij para techmaquixtis. Ijcon oquichiu hasta opejquej ometlamatij on yejhuan chantiyaj ne Damasco. ");
INSERT INTO nguNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Miyec tonaltin más saquin on hebreos yoquitlajtohuilijcaj Saulo para quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero yejhua oquimat tlinon quichihuasnequiyaj on hebreos. Ican tonajli niman yehuajli yejhuamej quipijpiayaj ipan itlatzacuijlohuan on hueyican para quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero ijcuac tlayohua, on tlaneltocaquej oquitlalijquej Saulo ijtic se hueyi chiquiutli ne campa tlapojticaj on tepanchinantli yejhuan quiyehualojtoya on hueyican. Quemaj oquitemoltijquej niman ijqui ocholoj. ");
INSERT INTO nguNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ijcuac Saulo oajsic ne Jerusalén, quichihuaya canica para nosentlalis inhuan on tlaneltocaquej, pero nochimej quimacasiyaj pampa xquineltocayaj tla yejhua no yotlaneltocac itech Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ijcuacon Bernabé ocontilan Saulo niman oquimixpantilij on apóstoles. Oquintlajtlajtohuilij quen ijqui Saulo oquitac toTeco ne ipan ojtli, niman quen ijqui toTeco oquinotz. Niman no oquitetlajtlajtohuilij quen ne Damasco Saulo otemachtij ican yolchicahualistli pampa Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Quemaj Saulo onocau ne Jerusalén niman inhuan quistinemiya. ");
INSERT INTO nguNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Niman tenojnotzaya ican yolchicahualistli ipampa toTeco. Yejhua tlajtlajtohuaya niman nocamatlaniya inhuan on hebreos yejhuan tlajtlajtohuaj on tlajtojli griego, pero yejhuamej quinequiliayaj quimictisquej. ");
INSERT INTO nguNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Niman ijcuac on tocnihuan oquimatquej yejhua on, ocuicaquej Saulo ne Cesarea, niman ompa ocontitlanquej para Tarso. ");
INSERT INTO nguNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ijcuacon on yejhuan tlaneltocaj nohuiyan ipan on inyehualican Judea, Galilea niman Samaria quipiayaj yolsehuilistli niman noyolchicahuayaj. Quitlacaitayaj on toTeco, niman quimpalehuiya on Espíritu Santo. Ijcon, tej, más miyequixtiayaj. ");
INSERT INTO nguNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro quinnojnotztinemiya on tocnihuan nochihuiyan, niman oyaj para oquintato on teyaxcahuan itech Dios yejhuan chantiyaj ne ipan on pueblo Lida. ");
INSERT INTO nguNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ompa oquinextito se tlacatl itoca Eneas yejhuan ye quipiaya chicueyi xipan ica onoya ipan itlapech, pampa sepojtoya. ");
INSERT INTO nguNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Niman Pedro oquijlij: ―Eneas, Jesucristo mitzpajtia. Xmotelquetza niman xcuectlali motlapech. Quemaj nimantzin Eneas onotelquetz. ");
INSERT INTO nguNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nochimej yejhuan chantiyaj ne Lida niman Sarón oquitaquej ica opajtic. Yejhua ica yejhuamej oquitlalcahuijquej inachtoj tlaneltoc niman oquineltocaquej toTeco. ");
INSERT INTO nguNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ne ipan on hueyican itoca Jope nemiya se sihuatl tlaneltocaquetl itoca catca Tabita, yejhuan ipan griego quijtosnequi Dorcas. Yejhua in sihuatl nochipa quichihuaya on tlen cuajli niman quimpalehuiyaya on yejhuan tla itlaj quimpolohuaya. ");
INSERT INTO nguNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ipan on tonaltin Dorcas ocualoc niman omic. Niman ijcuac yoquipajpacquej itlalnacayo, ocahuatoj ipan se cajlitic campa ica ome caltlanepantli niman ompa oquitecaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida sa nisiu quitzticatca Jope. Yejhua ica ijcuac on tlaneltocaquej ne Jope ocacquej ica Pedro nemiya ne Lida, oquintitlanquej omemej tlacamej para oquijlijtoj: ―Ma ca tihuejcahuis para tihuajlas Jope campa tejhuamej tinemij. ");
INSERT INTO nguNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ijcuacon Pedro ohuajnotelquetz niman oyaj inhuan. Ijcuac oajsic, ocuicaquej ne ipan on cajlitic campa oncatca on itlalnacayo on micatzintli. Niman nochimej on sihuacahualtin chocayaj niman oquiteyehualojquej para oquititijquej on tlaquentin niman on cuetin yejhuan Dorcas oquinchijchiu ijcuac nemiya. ");
INSERT INTO nguNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Quemaj Pedro oquinquixtij nochimej, niman quemaj onotlacuenquetz niman oquichiu oración. Quemaj ohuajnocuep niman ocontac on sihuatl yejhuan mictoya. Niman oquijlij: ―Tabita, xmotelquetza. Ijcuacon yejhua oquinhuajtlapoj ixtololojhuan, niman ijcuac oquitac Pedro, ohuajnotlalij. ");
INSERT INTO nguNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro oquitzquij ipan ima niman oquipalehuij para onotelquetz. Quemaj ocominnotz on sihuacahualtin niman on tocnihuan, niman oquimixpantilij yolticaj. ");
INSERT INTO nguNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yejhua in omachiyato nohuiyan ipan on hueyican de Jope, niman miyequej otlaneltocaquej itech on toTeco. ");
INSERT INTO nguNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Niman Pedro onocau miyec tonaltin ne Jope ipan ichan se curtidor itoca Simón. ");
INSERT INTO nguNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nemiya ne ipan on hueyican itoca Cesarea se tlacatl itoca Cornelio. Yejhua on tlacatl tlayecanqui catca ica se ciento soldados niman yejhua on se ciento soldados notocayotiaya Italiano. ");
INSERT INTO nguNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio quitlacaitaya Dios niman san secan ihuan nochi ichanchanejcahuan quimahuistiliayaj Dios ican nochi inyojlo. No quitemacaya miyec tomin para quimpalehuiyaya on hebreos yejhuan quimpolohuaya, niman nochipa oquichiu oración itech Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Se tonajli, canaj ipan yeyi hora ica tiotlac, oquitac se tlatlachalistli quen itemicpan, se ilhuicactequitquetl yejhuan Dios ocuajtitlan. On ilhuicactequitquetl oquijlij: ―¡Cornelio! ");
INSERT INTO nguNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio oquimojcaitac on ilhuicactequitquetl, niman oquitlajtoltij: ―¿Tlinon Señor? Niman on ilhuicactequitquetl oquijlij: ―Dios yoquinselij mooraciones niman yoquitac on tlen tictetlayocolia para tiquimpalehuiya on yejhuan itlaj quimpolohua. Ijcon, tej, yomitzelnamic. ");
INSERT INTO nguNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Aman, tej, xquintitlani tlacamej ne Jope para ma cuajhuicacan se tlacatl itoca Simón, yejhuan no san quixmatij Pedro. ");
INSERT INTO nguNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Niman yejhua mitzijlis tlinon tejhua ticchihuas. Yejhua chanti ihuan ocse tlacatl itoca Simón yejhuan curtidor. Ichan on curtidor oncaj ne nisiu itech on mar. ");
INSERT INTO nguNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ijcuac oyaj on ilhuicactequitquetl yejhuan ihuan tlajtohuaya, Cornelio oquinnotz omemej itlaquehualhuan. Niman no oquinotz se soldado yejhuan no cuajli quitlacaitaya Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nochi oquintlajtlajtohuilij tlen onochiu, niman quemaj oquintitlan ne Jope. ");
INSERT INTO nguNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Niman huajmostla, chica yejhuamej yajtiayaj ipan ojtli niman sa nisiu para ajsisquej ne Jope, Pedro otlejcoc ne icuapan on cajli, canaj tlacualispan, para quichihuas oración. ");
INSERT INTO nguNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Yejhua sanoyej apismiquiya niman oquinec tlacuas. Pero chica quichijchihuiliayaj tlen quicuas, oquitac se tlatlachalistli quen itemicpan. ");
INSERT INTO nguNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Oquitac ne ajcopa tlapohuiya niman huajtemotiaya ipan tlajli se hueyi manta istac, huajsajsalijtiaya ipan nochi inahui yacapitzco. ");
INSERT INTO nguNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ipan on hueyi manta huajlayaj nochi tlajtlamach yolqui yejhuan najnahui imicxihuan, niman on quech yolquej yejhuan notilanaj ipan tlajli niman on quech totomej yejhuan patlanij. ");
INSERT INTO nguNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Quemaj ocac se tlajtojli yejhuan oquijlij: ―Xmotelquetz, Pedro. Xtlamicti niman xtlacua. ");
INSERT INTO nguNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero Pedro oquijlij: ―Ca, noTeco, pampa nejhua xqueman nicua itlaj on tlen xchipahuac yejhuan itlanahuatil Moisés xtechcahuilia ticuasquej. ");
INSERT INTO nguNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ijcuacon on tlajtojli ocsejpa oquinotz, niman oquijlij: ―Tlen Dios oquichipau, ma ca xquijto ica xchipahuac. ");
INSERT INTO nguNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yejhua in onochiu yexpa, niman quemaj nimantzin on hueyi manta istac ocsejpa otlejcoc. ");
INSERT INTO nguNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Chica Pedro ometlamatzticatca niman sa comatzticatca tlinon quijtosnequi on tlatlachalistli yejhuan oquitaca quen itemicpan, on tlacamej yejhuan oquinhuajtitlan Cornelio, tlajtlantiayaj canon ichan Simón. Quemaj oajsiquej ne iquiahuatenco. ");
INSERT INTO nguNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Niman ontzajtziquej oquitetlajtoltijquej tla ompa ipan on cajli nemiya Simón, on yejhuan no itoca Pedro. ");
INSERT INTO nguNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Niman chica Pedro oc quinemilijticatca tlinon quijtosnequi on tlen oquitaca, on Espíritu Santo oquijlij: ―Xquita. Mitztejtemohuaj yeyimej tlacamej. ");
INSERT INTO nguNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Xmotelquetz, xtemoti niman ma ca xometlamati, yej inhuan xhuiya, pampa nejhua oniquinhuajtitlan. ");
INSERT INTO nguNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Quemaj Pedro otemoto campa nemiyaj on tlacamej yejhuan Cornelio oquinhuajtitlan, niman oquimijlij: ―Nejhua on aquin nemejhuamej nenquitejtemohuaj. ¿Tlica onenhualajquej? ");
INSERT INTO nguNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yejhuamej oquijlijquej: ―Sen tlacatl itoca Cornelio, yejhuan tlayecanquetl ica se ciento soldados, otechajtitlan. Yejhua in tlacatl yolmelajqui niman quitlacaita Dios. Nochi quech hebreos quitlacaitaj in tlacatl. Sen iilhuicactequitcau Dios oquijlij para ma mitztlatitlanili ichan, niman tiquijlis on tlen ticpia para tiquijlis. ");
INSERT INTO nguNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Quemaj Pedro oquincalactij, niman ompa onocajquej ipan on tlayohua. Niman huajmostla ohuajnotelquetz niman oyaj inhuan. Niman oyajquej san secan inhuan ocsequimej tocnihuan on yejhuan chanejquej ne Jope. ");
INSERT INTO nguNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Niman huajmostla oajsiquej ne Cesarea campa Cornelio quinchixticatca inhuan ocsequimej yejhuan achi quen quinmita niman on yejhuan más cuajli itetlajsojcahuan yejhuan yoquinsentlalijca. ");
INSERT INTO nguNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ijcuac Pedro oajsic ipan on cajli, Cornelio ohuajquis para oquinamiquito niman onotlacuenquetz ixpan para quimahuistilisquia. ");
INSERT INTO nguNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Pedro ocontilan, niman oquijlij: ―Xmotelquetz, pampa nejhua no san nitlalticpactlacatl quen tejhua. ");
INSERT INTO nguNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Niman chica ihuan tlajtlajtohuaya, ocalac campa oquinnextijtajsic miyequej tlacamej yonosentlalijcaj. ");
INSERT INTO nguNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Niman Pedro oquimijlij: ―Nemejhuamej nenquimatztoquej ica itlaneltoc se hebreo xcahuilia nosentlalis ihuan se yejhuan xhebreo noso calaquis ichan. Pero Dios onechititij ica xcuajli para yacaj nicuitis ijtlacauquej noso xchipahuac ixpan Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yejhua ica, tej, ijcuac onennechnotzquej, onihuajlaj niman xitlaj oniquijtoj. Aman, tej, nicnequi nicmatis tlinon ica onennechtlatitlanilijquej. ");
INSERT INTO nguNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ijcuacon Cornelio oquinanquilij: ―Ye quipia nahui tonajli ipan in hora nejhua ninosahuaya. Niman ipan yeyi hora ica tiotlac ijcuac nicchijticatca nooración ne nochan, nimantzin se tlacatl tlaquemej ican se tlaquentli petlanqui onotelquetz nixpan. ");
INSERT INTO nguNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Niman onechijlij: “Cornelio, Dios yoquiselij mooración, niman yoquitac on tlen tejhua tictetlayocolia para tiquimpalehuiya on yejhuan itlaj quimpolojticaj. ");
INSERT INTO nguNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Xtlanahuati, tej, ma canatij Simón, yejhuan no itoca Pedro, ne ipan on hueyican itoca Jope. Yejhua nemi ne ichan se tlacatl, no itoca Simón, yejhuan curtidor niman chanti nisiu itech on mar. Ijcuac huajlas, tlajtlajtos mohuan.” ");
INSERT INTO nguNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ijcon, tej, nimantzin onitlatitlan ma mitztejtemotij, niman oticchiu cuajli ica otihuajlaj. Aman, tej, titochimej tinemij nican ixpan Dios para ticaquisquej nochi tlen on toTeco omitznahuatij. ");
INSERT INTO nguNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Quemaj Pedro opeu tlajtlajtohua, niman oquijtoj: ―Aman nicmati ica melahuac Dios xquichicoita se tlacatl ihuan ocse, ");
INSERT INTO nguNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","yej quiselia san catlejhua tlacatl yejhuan quitlacaita niman cuajli quichihua masqui hualehua san catlehua país. ");
INSERT INTO nguNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios oquinhuajtitlanilij in tlajtojli on hebreos. Oquiteijlij on cuajli tlajtojli yejhuan quitemaca yolsehuilistli niman hueli ticseliaj itechcopa Jesuscristo. Yejhua iTeco nochi tlacatl. ");
INSERT INTO nguNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nemejhuamej cuajli nenquimatztoquej tlinon onochiu nochihuiyan ne ipan iyehualijyan Judea. Ohuajpeu ne ipan iyehualijyan Galilea, saquin ijcuac Juan yotemachtij niman yotlacuatequij. ");
INSERT INTO nguNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nemejhuamej nenquimatztoquej yejhua ica on quen Dios oquititlan on Espíritu Santo itech Jesús, yejhuan hualehua ne Nazaret, para quipia poder. Niman no ijqui, tej, nemejhuamej nenquimatztoquej quen ijqui Jesús nohuiyan oquichijtinen on tlen cuajli niman nochimej on yejhuan itlaj ica quintlajyohuiltiaya ica ipoder on diablo oquimpajtijtinen, pampa Dios ihuan nemiya. ");
INSERT INTO nguNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Niman tejhuamej ticteixpantiliaj nochi ica on tlajtlamach tlinon Jesús oquichiu ne Judea niman ne Jerusalén. Niman más saquin oquimictijquej, oquimajmasohualtijquej ipan cojnepanojli, ");
INSERT INTO nguNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","pero ipan yeyi tonajli Dios oquiyolihuitij niman oquetzteu ipan itlalcon, niman oquichiu para ma cuajli noteititi. ");
INSERT INTO nguNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Xoquinotitij nochi tlacatl, yej san tejhuamej yejhuan Dios otechtlapejpenij para ticteixpantilisquej, tejhuamej yejhuan ihuan otitlacuajquej niman ihuan otatliquej saquin ijcuac yonoyolihuitij niman yonoquetzteu ne ipan itlalcon. ");
INSERT INTO nguNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Niman yejhua otechnahuatij ma ticteijlican in cuajli tlajtojli yejhuan quitemaca temaquixtilistli niman ma ticteixpantilican ica yejhua on Jesús Dios yoquitlalij para quinyolcuitis niman quintlajtlacolmacas on yejhuan nemij niman on yejhuan yomiquej. ");
INSERT INTO nguNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Niman no ye huejcahui nochimej on quech tiotlajtojquej yoquiteixpantilijcaj ica nochimej on yejhuan tlaneltocasquej itech quiselisquej tetlapojpolhuilistli intlajtlacol itechcopa itocatzin Jesús. ");
INSERT INTO nguNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Chica Pedro oc tlajtlajtojticatca, on Espíritu Santo impan oyejcoc nochimej on yejhuan caquiyaj on tlajtojli. ");
INSERT INTO nguNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Niman on tlaneltocaquej hebreos yejhuan ohualajquej ihuan Pedro omojcatlachixquej ica ne impan on yejhuan xhebreos no oquiseliquej on Espíritu Santo yejhuan itetlayocolil Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ijcon omojcatlachixquej pampa quincaquiyaj on xhebreos tlajtlajtohuaj ica sesetlamantic yencuic tlajtoltin, niman no quincaquiliayaj quiyectenehuayaj Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Quemaj Pedro oquijtoj: ―¿In tlacamej yejhuan no yoquiselijquej on Espíritu Santo sa no ijqui quen tejhuamej, huelis yacaj tlatzacuilis para nocuatequisquej? ");
INSERT INTO nguNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Niman Pedro otlanahuatij ma quincuatequican ican itocatzin toTeco Jesús. Quemaj oquitlajtlanilijquej Pedro para ma nocahua quesqui tonajli inhuan. ");
INSERT INTO nguNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","On apóstoles niman on tocnihuan yejhuan nemiyaj imanyan ne Judea ocacquej ica on yejhuan xhebreos no yoquiselijquej on itlajtoltzin Dios. ");
INSERT INTO nguNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Niman ijcuac Pedro ohuajlaj Jerusalén, on tlaneltocaquej hebreos yejhuan quejehuayaj on circuncisión ocajhuaquej. ");
INSERT INTO nguNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Oquijlijquej: ―¿Tlica oticalac inchan on tlacamej xhebreos yejhuan xoquiselijquej on nescayotl de circuncisión, niman otitlacuaj inhuan? ");
INSERT INTO nguNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ijcuacon Pedro oquintlajtlajtohuilij desde ijcuac opeu nochi tlen ipan onochiu, niman oquijtoj: ");
INSERT INTO nguNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Nejhua ninemiya ne ipan on hueyican itoca Jope. Niman ijcuac nicchihuaya nooración, oniquitac se tlatlachalistli quen notemicpan. Oniquitac on quen itlaj hueyi manta istac yejhuan ne ajcopa huajtemohuaya. Huajsajsalijtiaya ipan on inaucan yacapitzco niman yejcotoya hasta campa nejhua ninemiya. ");
INSERT INTO nguNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ijcuac onicchiu para cuajli niquitas tlinon huajlau ijtic, oniquitac on yolquej yejhuan najnahui imicxi niman on quech yolquej yejhuan notilanaj ipan tlajli niman on quech totomej yejhuan patlanij. ");
INSERT INTO nguNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Quemaj onicac se tlajtojli yejhuan onechijlij: “Xmotelquetz, Pedro. Xtlamicti niman xtlacua.” ");
INSERT INTO nguNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero oniquijtoj: “Ca, noTeco, pampa nejhua xqueman nicua itlaj on tlen xchipahuac yejhuan itlanahuatil Moisés xtechcahuilia ticuasquej.” ");
INSERT INTO nguNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ijcuacon on tlajtojli onechajnanquilij ne ilhuicac ica ocpa quijtohua: “Tlen Dios oquichipau, ma ca xquijto ica xchipahuac.” ");
INSERT INTO nguNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yejhua in onochiu yexpa, niman quemaj nimantzin on hueyi manta istac ocsejpa otlejcoc. ");
INSERT INTO nguNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Quemaj nimantzin oyejcoquej yeyimej tlacamej ne ipan on cajli campa nejhua ninemiya. Oquinhuajtitlancaj ne Cesarea. ");
INSERT INTO nguNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Niman on Espíritu Santo onechijlij ma nihuiya inhuan niman ma ca itlaj ica ma niometlamati. Niman no nohuan oyajquej in chicuasemej tocnihuan. Niman ijcuac otejcoquej, oticalaquej ichan on tlacatl yejhuan quinequiya nechnotzas. ");
INSERT INTO nguNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yejhua otechtlajtlajtohuilij quen ijqui oquitac se ilhuicactequitquetl ne ichan yejhuan ijcaticatca, niman oquijlij: “Xquintitlani tlacamej ne Jope para ma cuajhuicacan se tlacatl itoca Simón, yejhuan no itoca Pedro.” ");
INSERT INTO nguNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yejhua mitzijlis on cuajli tlajtojli yejhuan mitzmacas temaquixtilistli ihuan nochi mochanchanejcahuan. ");
INSERT INTO nguNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Niman ijcuac opeu niquinnojnotza, on Espíritu Santo impan ohuajlaj ijcon quen topan ohuajlaj ijcuac quemach yeica topan oyejcoc. ");
INSERT INTO nguNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ijcuac in onochiu, oniquelnamic on tlen oquijtoj toTeco. Oquijtoj: “On melahuac ica Juan otlacuatequij ican atl, pero nemejhuamej nentlacuatequiltiyesquej ican Espíritu Santo.” ");
INSERT INTO nguNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ijcon, tej, tla aman yejhuamej Dios no oquinmacac sa no yejhuaj on tetlayocolijli yejhuan tejhuamej otechmacac ijcuac oticneltocaquej toTeco Jesucristo, ¿aquin nejhua para niqui