﻿USE sofia;
DROP TABLE IF EXISTS sofia.ngp_vpl;
CREATE TABLE ngp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ngp_vpl WRITE;
INSERT INTO ngp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ulu nulo ludongo lwo lukolo lwa Zumbe Yesu Kilisito, mwelekwa ywa Daudi andaga mlukolo ywa Ibulahimu. ");
INSERT INTO ngp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibulahimu amwelekaga Isaka, Isaka amwelekaga Yakobo, Yakobo amwelekaga Yuda na wanduguze, ");
INSERT INTO ngp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda amwelekaga Pelesi na Zela, mamiyawe andaga ni Tamali, Pelesi amwelekaga Heziloni, na Heziloni amwelekaga Alamu, ");
INSERT INTO ngp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu amwelekaga Aminadabu, Aminadabu amwelekaga Nahashoni, Nahashoni amwelekaga Salimoni, ");
INSERT INTO ngp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni amwelekaga Boazi, Boazi etangagwa Lahabu. Boazi amwelekaga Obedi, nine etangagwa Luti, Obedi amwelekaga Yese, ");
INSERT INTO ngp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese naye niye amwelekega zumbe Daudi. Daudi amwelekaga Sulemani, nine andaga mkaza Yulia. ");
INSERT INTO ngp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemani amwelekaga Lehoboamu, Lehoboamu amwelekaga Abia, Abia amwelekaga Asa. ");
INSERT INTO ngp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa amwelekaga Yehoshafati, Yehoshafati amwelekaga Yolamu, Yolamu amwelekaga Uzia, ");
INSERT INTO ngp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia amwelekaga Yosamu, Yosamu amwelekaga Ahazi, Ahazi amwelekaga Hezekia. ");
INSERT INTO ngp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia amwelekaga Manase, Manase amwelekaga Amoni, Amoni amwelekaga Yosia, ");
INSERT INTO ngp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia amwelekaga Yekonia na wanduguze umwo want'hu wa Izilaeli wegalagwa kwo utumwa uko Babeli ");
INSERT INTO ngp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ulu nulo ludongo lwo lukolo, kukongela aho want'hu wa Izilaeli wegalagwa kwo utumwa uko Babeli. Yekonia amwelekaga Shealitieli, Zelubabeli amwelekaga ");
INSERT INTO ngp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli amwelekaga Abihudi na Abihudi amwelekaga Eliakimu na Eliakimu amwelekaga Azoli, ");
INSERT INTO ngp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli amwelekaga Zadoki, Zadoki amwelekaga Akimu, Akimu amwelekaga Eliudi, ");
INSERT INTO ngp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi amwelekaga Eliazali na Eliazali amwelekaga Matani, Matani amwelekaga Yakobo, ");
INSERT INTO ngp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo amwelekaga Yusufu, mnumewe dya Maliamu uyo nine dya Yesu akwitangwa Kilisito Mkombozi. ");
INSERT INTO ngp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ivo vatenda, kulawa Ibulahimu kubula kwa Daudi vyeleko mlongo navine, kulawa Daudi kubula hadya want'hu wa Izilaeli waguhagwa utumwa uko Babiloni, vyeleko mlongo na vine, naho kulawa aho kubula mwo kwelekwa kwa Zumbe Yesu Kilisito, vyeleko mlongo na vine. ");
INSERT INTO ngp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kwelekwa kwa Zumbe Yesu kwandaga ivi. Maliamu uyo nine dya Yesu Kilisito, atumizagwa ni Yusufu. Umwo wandaga akei kulozigwa, Maliamu aonekaga kunda mbovu kwa udahi wa Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwaviya Yusufu andaga mnt'hu akumwelela Mnungu, haungile kumgela soni mwa want'hu, ivo aungaga amwase Maliamu kwa kinyele. ");
INSERT INTO ngp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Umwo andaga akafanyanya ivo, mtumigwa ywa Zumbe niyo amlaila mwe zisozi akamgamba, “Yusufu weye mwelekwa ywa Daudi, usekogoha kumguha Maliamu kunda mkaziyo kwaviya ubovu ananao ni kwa udahi wa Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Neeleke mwana kilume, naho noumwitange zina dyakwe niye Yesu, kwaviya niye akuunga awayokole want'hu wakwe walawe mwo uwavu wawe.” ");
INSERT INTO ngp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aya yose yalailaga vileke kia kindedi cha Zumbe alongaga kombokela kwa mlotezi ywakwe kikelavilize, ");
INSERT INTO ngp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mwali na mazanga neenule ubovu, naho kwakwe naavumbuke mwana kilume, zina dyakwe neetangwe Imanueli” nuko kugamba, “Mnungu ehamwenga na suwe.” ");
INSERT INTO ngp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ivo Yusufu eze enuke mwe zint'hongo, amlomba Maliamu enga viya agambilwe ni mtumigwa ywa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mna hawagendaga enga mnt'hu na mkaziwe mpaka hadya Maliamu amwelekaga mwanawe ywa kilume, niyo Yusufu amwink'ha zina niye Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aho Yesu eze elekwe mwo mzi wa Betelehemu uko Uyahudi, umwo Helode andaga seuta, wamanyi we zint'hondo wezaga Yelusalemu kulawa ulawilo wa zuwa, ");
INSERT INTO ngp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wakauza kugamba “Ekuhi mwana elekwe akuunga ande Seuta ywa Wayahudi? Kwaviya nekiona nt'hondo yakwe kwo ulawilo wa zuwa, ivo kiza kimvike.” ");
INSERT INTO ngp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Helode hamwenga na want'hu wose wa Yelusalemu weze weve ivo, wengilaga kinyulu mwe mioyo yawe. ");
INSERT INTO ngp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Niyo awetanga wakulu wa walava nt'hambiko wose hamwenga na wahinizi we Miko ya Musa, akawauza, “Kilisito Mkombozi neelekwe hi?” ");
INSERT INTO ngp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Niyo wamhitula, “Neelekwe mwo mzi wa Betelehemu yo Uyahudi.” Kwaviya nivo vawandikagwa ni walotezi kugamba, ");
INSERT INTO ngp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Weye Betelehemu, mwe isi ya Uyahudi hwi mdodo mwe mizi ya Uyahudi, kwaviya kilongozi naalawe kwako akuunga awalongoze want'hu wangu wa Izilaeli. ");
INSERT INTO ngp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ivo Helode niyo awetanga kwe njama wadya want'hu wezile kulawa ulawilo wa zuwa, niyo wamgambila ikindedi che int'hondo idya kukongela aho yakongaga kulaila. ");
INSERT INTO ngp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Niyo awagamba, “Iteni Betelehemu mkapelembe kwa wengele izimbuli zo mwana. Mkajika kumuwona, mwize mnigambile vileke name hamvike.” ");
INSERT INTO ngp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Zumbe Helode eze abinde kuwagambila, niyo wahalawa. Umwo mwe sila niyo waiona idya int'hondo waione ulailo wa zuwa. ");
INSERT INTO ngp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Weze waione idya int'hondo, niyo welelwa kwa kinyemi kikulu. ");
INSERT INTO ngp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Wengilaga mwe nyumba niyo kumuwona umwana hamwenga na nine Maliamu. Niyo wamfikila madi na kumvika. Wamwink'haga umwana mageleko ya zahabu na mavumba na mavuta ya mhemp'he. ");
INSERT INTO ngp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mnungu eze wawakanye mwe zisozi kugamba wase kumwombokela Helode, wauyaga kwawe wakombokela sila nt'huhu. ");
INSERT INTO ngp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Woho weze wahalawe, mtumigwa ywa kwe mbingu ywa Zumbe amlailaga Yusufu mwe zisozi akamgamba, “Helode amzungula mwana vileke amkome. Haluse inuka umguhe mwana hamwenga na nine mnyilikile Misili mkekale ukwo kubula aho nenize nimitangeni.” ");
INSERT INTO ngp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusufu enukaga niyo akumguha mwana hamwenga na nine iicho ikilo, niyo waita Misili. ");
INSERT INTO ngp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wekalaga uukwo Misili kubula aho Helode eze abanike. Ino yalailaga vileke kiya alongaga Zumbe kwombokela mlotezi ywakwe kugamba, “Nehimwitanga mwanangu kulawa Misili.” ");
INSERT INTO ngp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode eze abunk'hule kugamba kadant'hilizwa ni wadya wamanyi we zint'hondo kulawa ulailo wa zuwa, engilaga maya niyo asigiila wana kilume wose wabuile myaka miidi kwiza hasi, ukwo Betelehemu hamwenga na kaya zose zi mgihi na aaho, wakomigwe. Ino nayo yadamanyikaga viligane no lupisi lukukongela aho evilaga kulawa kwa wadya wamanyi we zint'hondo kulawa ulawilo wa zuwa. ");
INSERT INTO ngp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Niho ulotezi wa Yelemia mlotezi ywa Mnungu wakelavilizaga. Udya ukugamba, ");
INSERT INTO ngp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Izwi dyevikaga ukwo Lama, izwi dya ndilo nk'hulu, Laheli akawaiila wanawe, alemelaga kutondoazwa, kwaviya haawaone naho.” ");
INSERT INTO ngp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helode eze abanike, mtumigwa ywa kwe mbingu ywa Zumbe amlailaga Yusufu mwe zisozi ukwo Misili, ");
INSERT INTO ngp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akamgamba, “Mguhe mwana na nine muuye kwe isi ya Izilaeli kwaviya wadya nawakaunga wamkome mwana wabanika.” ");
INSERT INTO ngp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ivo Yusufu enukaga no kumguha mwana hamwenga na nine, niyo wauya kwe isi ya Izilaeli. ");
INSERT INTO ngp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mna Yusufu eze eve kugamba, Alikelao niye akulongoza ukwo Uyahudi hant'hu ha Helode uyo ise, ogohaga kuita ukwo. Enk'hagwa malavo matuhu mwe zisozi, naivo ahingaga nt'hendelo za Galilaya. ");
INSERT INTO ngp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Niyo agenda kwikala mwo mzi ukwitangwa Nazaleti, vileke ulotezi wa walotezi ywa Mnungu yalaile, yadya yakugamba, “Neetangwe Mnazaleti.” ");
INSERT INTO ngp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mwa mazuwa yadya, Yohana Mbatizi alailaga mwe dijangwa dya Uyahudi akabilikiza, ");
INSERT INTO ngp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","akagamba “Lekeni wavu wenyu,” “kwaviya Useuta wa kwe mbingu uhaguhi!” ");
INSERT INTO ngp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana niye alotelagwa ni mlotezi ywa Mnungu Isaya kugamba, “Izwi dya mnt'hu akubongeela mwe nyika, ‘Ikeni lumwe sila ya Zumbe, chumizeni lwombokelo lwake!’ ” ");
INSERT INTO ngp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana avalaga suke idamanywe kwa mazoya ya ngamia. Mwe kigudi avalaga mkoa wa nk'hingo, nk'hande yakwe yandaga sige no uki. ");
INSERT INTO ngp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Want'hu kulawa Yelusalemu hamwenga na Uyahudi na mwe si zose hagihi ne Yolodani wamwizilaga. ");
INSERT INTO ngp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wakweiilaga wavu wawe, niyo Yohana awabatiza mwo mto Yolodani. ");
INSERT INTO ngp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohana eze awaone Mafalisayo hamwenga na Masadukayo wambasa awabatize, niyo awagamba, “Nyuwe cheleko che nyoka, niani awagambileni kugamba mwadaha kunyilika maya ya Mnungu yakwiza? ");
INSERT INTO ngp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lagiseni kwa udamanyi kugamba muuleka uwavu wenyu. ");
INSERT INTO ngp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Naho msekugamba mwadaha kukehonya na maya ya Mnungu kwa kugamba mnanaye tati yenyu akwitangwa Ibulahimu. Nawagambilani, Mnungu adaha kuguha maiwe aya niyo amdamanyila Ibulahimu welekwa mwa maiwe aya. ");
INSERT INTO ngp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hoya diikilwa lumwe he nk'holo yo mti. Mti wowose howiina cheleko chedi nousengwe no kokigwa mwo moto. ");
INSERT INTO ngp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ikindedi, miye nawabatizani kwa mazi kulagisa kugamba mkweiila wavu wenyu. Mna eza mto udahi kunijink'ha miye. Naho hikuwagilwa kwinula vilatu vakwe. Yehe naawamibatizeni kwa Muye ywa Mnungu na kwa moto wa usengelo. ");
INSERT INTO ngp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Naho lungo lwakwe ananalo mwe mikono vileke ahete vedi ngano. Naadihagile vedi digulu dyakwe niyo aigela umwo, mna mahofya naayagele mwo moto houkuzima.” ");
INSERT INTO ngp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mwa mazuwa yadya, Yesu abulaga Yolodani akalawa Galilaya, vileke abatizwe ni Yohana. ");
INSERT INTO ngp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mna Yohana aungaga amlemele, akagamba, “Miye naungwa nibatizwe ni weye, weye nawe weza kwangu hubatize!” ");
INSERT INTO ngp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu niyo amgamba, “Zumila ivi haluse, kwaviya kwa kudamanya aya, nekinde kikint'hiza yadya yose akuunga Mnungu.” Ivo Yohana niyo azumila kumbatiza. ");
INSERT INTO ngp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aho Yesu eze ajike kubatizwa, afosaga mwa mazi. Mbingu niyo zagubuka, naho aonaga Muye ywa Mnungu akaseela kulawa kwe mbingu enga suwa, niyo amkima. ");
INSERT INTO ngp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Izwi kulawa kwe mbingu dyevikaga dikagamba, “Uyu niye Mwanangu nimuungise, hyelelwa naye.” ");
INSERT INTO ngp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Muye ywa Mnungu niyo amwigalaga Yesu kwe dijangwa vileke akagezigwe nu Mwavu. ");
INSERT INTO ngp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eze ekale mazuwa milongo mine kilo na msi haheina kudya chochose, akeivaga sala. ");
INSERT INTO ngp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Niyo Mgezi amwiizila niyo amgamba, “Uneva kindedi weye ywi Mwana Mnungu, yagambe maiwe aya yande nk'hande.” ");
INSERT INTO ngp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mna Yesu niyo amgamba, “Iwandikwa kugamba, ‘Mnt'hu haaikwe ni kudya nk'hande du, mna naaikwe ni kiya akulonga Mnungu.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Naho Mwavu niyo amwigala Yesu uko Yelusalemu, mzi ukukile, niyo amkweza kwo lunenengwa lwe Nyumba ya Mnungu, ");
INSERT INTO ngp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Niyo amgamba, “Uneva ywi Mwana Mnungu, keduule hasi, kwaviya iwandikwa kugamba, ‘Mnungu naawagambe watumigwa wa kwe mbingu wakupoele mwe mikono yawe, vileke use kukakobadisa ikiga chako mwe diiwe.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu niyo amgamba, “Iwandikwa kugamba, ‘Use kumgeza Zumbe Mnungu ywako.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mwavu niyo amwigala Yesu kwo mnima mtali, no kumlagisa useuta wose umwe isi hamwenga no uwedi wakwe utendedse. ");
INSERT INTO ngp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mwavu niyo amgamba, “Nohwink'he ivi vose,” “uneva unanifikila madi na kunivika.” ");
INSERT INTO ngp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu niyo amgamba, “Halawe aha, weye Mwavu! Iwandikwa kugamba, ‘Umfikile madi Zumbe Mnungu ekedu, naho umdamanyile ndima yehe du!’ ” ");
INSERT INTO ngp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Niyo Mwavu amleka Yesu, watumigwa wa kwe mbingu wamwizilaga Yesu, niyo wamwambiza. ");
INSERT INTO ngp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu eze eve Yohana kavugailwa kwe divugailo, aitaga Galilaya. ");
INSERT INTO ngp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hekalaga Nazaleti, ivo agendaga kwikala Kapelinaumu, mzi umnk'handa ye diziwa dya Galilaya, mwe mihaka ye wilaya ya Zabuloni na Nafutali. ");
INSERT INTO ngp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Idi dyadamanyika vileke yadya alongaga mlotezi ywa Mnungu Isaya yakint'he kugamba, ");
INSERT INTO ngp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Si za Zabuloni na si za Nafutali, sila ya mwe bahali kujink'hanya ng'ambu yo mto Yolodani, Galilaya, isi ya want'hu hi Wayahudi! ");
INSERT INTO ngp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Want'hu wakwikala mwo lwiza, wauwona unga'zi mkulu. Na wose wakwikala mwe isi yo lwiza lwe file, ung'azi uwang'azila.” ");
INSERT INTO ngp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kukongela aho, Yesu andaga akabilikiza akagamba, “Lekeni wavu wenyu, kwaviya Useuta wa Mnungu uhagihi!” ");
INSERT INTO ngp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu andaga akagenda mwe mp'wani ye diziwa dya Galilaya, aonaga wandugu waidi wandaga wakalowa samaki, Simoni etangagwa Petulo, na nduguye Anduleya wandaga wakaika lumwe zinyavu zawe kwaviya wandaga ni walowa samaki. ");
INSERT INTO ngp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu niyo awagamba, “Nitimileni, name neni watendeni walowa want'hu.” ");
INSERT INTO ngp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aaho, wazilekaga zinyavu zawe, niyo wamtimila. ");
INSERT INTO ngp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Agendeelaga halongole, niyo aona wandugu watuhu waidi, Yakobo na Yohana, wana Zebedayo hamwenga na Zebedayo tati yawe, wandaga mwe ngalawa wakaika lumwe zinyavu zawe. Yesu niyo awetanga. ");
INSERT INTO ngp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aaho niyo waileka ingalawa na tati yawe niyo wamtimila Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu agendaga mwe isi yose ya Galilaya akahiniza mwe zinyumba zo kumvika Mnungu, akabilikiza Mbuli Yedi yo Useuta naho ahonyaga wakulumwa wengi no kuwahonya wose wandaga na maine. ");
INSERT INTO ngp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Zimbuli zakwe niyo zenela mwe isi yose ya Silia, vitendile want'hu wamwigaile want'hu wose wandile wakahuma nawadya nawakakunt'hizwa ni maine yose na hewe kukedaha, wata mp'hepo, wata vifafa, na wadya waholole. Yesu awahonyaga wose. ");
INSERT INTO ngp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Fyo kulu dya want'hu kulawa Galilaya na Mizi mlongo dyamtimilaga Yesu. Isi ina mizi mlongo, kulawa Yelusalemu, Uyahudi, ne digundi dituhu dya Yolodani. ");
INSERT INTO ngp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu eze auone mdugano mkulu wa want'hu, akwelaga kwo mnima niyo ekala hasi. Wadya wanamp'hina nao wambasaga niyo wamzunguluka, ");
INSERT INTO ngp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","niyo akonga kuwahiniza akagamba, ");
INSERT INTO ngp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wavikilwa wadya wose wakumhuwila Mnungu, kwaviya Useuta wa kwe mbingu ni wawe! ");
INSERT INTO ngp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wavikilwa wadya wose wakuhongeza, Mnungu naawatondowaze! ");
INSERT INTO ngp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wavikilwa wata ujalamu, kwaviya nawande wakipe we isi! ");
INSERT INTO ngp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wavikilwa wadya wose wata nk'hilu na sala ya kudamanya yadya yakumwelela Mnungu, Mnungu naawenk'he va kumema! ");
INSERT INTO ngp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wavikilwa wadya wata mbazi na weyawe, kwaviya Mnungu naande na mbazi nawo! ");
INSERT INTO ngp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wavikilwa wadya wata mioyo yedi, kwaviya nawamuwone Mnungu! ");
INSERT INTO ngp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wavikilwa wadya wakuwalunganya want'hu, kwaviya nawetangwe wana Mnungu! ");
INSERT INTO ngp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wavikilwa wadya wose nawadamanyilwe wiihi kwa kudamanya yadya yakumwelela Mnungu, kwaviya Useuta wa kwe mbingu, wawe! ");
INSERT INTO ngp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nomvikilwe umwo want'hu wakawakalalizani no kuwasulumiza, no kuwalonga vihile kwajili ya miye. ");
INSERT INTO ngp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Indeni na kinyemi na kwanga, kwaviya maliho yenyu ni makulu uko kwe mbingu. Ivi nivo watendelagwa awalotezi awo wandaga uuko nk'hongo aho nyuwe mwandaga hamnati mwize. ");
INSERT INTO ngp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nyuwe mwi munyu we isi. Mna uneva munyu unabanika, hahana cho kuutenda uuiye ukimunyu wakwe. Hiwo wedi naho, waduulwa kuse niyo wajatwa ni want'hu. ");
INSERT INTO ngp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nyuwe mwi ung'azi we isi. Mzi una zengwa henukile haukudaha kukefisa. ");
INSERT INTO ngp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Naho hahali mnt'hu akukweleza lumuli, niyo alwiika kwe divungu. Mna nolwiikwe hant'hu henukile vileke want'hu wose wauone ung'azi mwe nyumba. ");
INSERT INTO ngp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Viligane na ivo, ung'azi wenyu nanywe ung'ale mwa want'hu, vileke wakaule ayedi mkudamanya, wamtogole Tati yenyu ywa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mnase kugamba hiza kuiusa Miko ya Musa hegu mbuli za walotezi. Hizile kutenda ivo, mna hiza kuyakint'hiza. ");
INSERT INTO ngp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Namigambilani kindedi, mbingu ne isi nevomboke mna hakihali nekihunguke mwe Miko, kubula kwo uheelo we vint'hu vose. ");
INSERT INTO ngp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mnt'hu yeyose akuunga abanange Mwiko umwenga mwe Miko ino imidodo mwa yose, no kuwahiniza want'hu enga ivo yehe akudamanya, naande mdodo kwo Useuta wa kwe mbingu. Nuko kugamba yeyose akuzumila Miko na kuhiniza watuhu kudamanya ayo, naande mkulu kwo Useuta wa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Naivo nawagambani kugamba, nomwingile ko Useuta wa kwe mbingu uneva kumwelela Mnungu kwenyu kunajink'ha kudya kwa wahinizi we Miko hamwenga na Mafalisayo. ");
INSERT INTO ngp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwiva kugamba aho kale neigambigwa, ‘Use kukoma, naho mnt'hu akukoma, naasengelwe.’ ");
INSERT INTO ngp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naho nawagambani nyuwe, yeyose akuunga amwihiye miyawe naasengelwe, naho yeyose akuunga ambele nduguye, neegalwe kwe kitala. Naho akuunga amgambe nduguye kugamba, ‘Weye wi hezi!’ Naageligwe mwo moto houkuzima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Elo, uneva waunga ukalave malavo kwe kilingo cho kumlavila Mnungu, niyo wakumbukila kugamba eyuko nduguyo mwikailane vihile, ");
INSERT INTO ngp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","inda uyaleke malavo ayo he kilingo cho kulavila malavo, wiite kwa uyo nduguyo mwikalane vihile, mkaivane niho wiite ukalave malavo yako. ");
INSERT INTO ngp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Sunguza kuivana na yudya akulongeleze mkei kubula kwe kitala. Unagoja mbule he kitala naakwink'hize kwo mkulu we kitala, mkulu ywe kitala naye naakwink'hize kwa mtowani, mtowani naye akugela kwe divugailo. ");
INSERT INTO ngp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nawagambilani ikindedi, homfose uko mpaka mbinde kuliha ditundu dyo uheelo. ");
INSERT INTO ngp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwiva igambigwa, ‘Usekugenda na mvele ywa mnt'hu.’ ");
INSERT INTO ngp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mna miye Nawagambani, akuunga amkaule mvele no kumunk'hilwa naye, kagendanaye kale mwo moyo wakwe. ");
INSERT INTO ngp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Uneva ziso dyako dyo kulume dyakugela mwo uwavu, ding'ole udiduule, nevindilise vedi una swesa kilungo kimwenga mwo mwili kujink'ha kunda no mwili wose, mna uduulwe kwo moto houkuzima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mkono wako wo kulume unakugela mwo wavu ukant'he uuduule. Nivedi uuswese kujink'ha kunda no mwili wose mna uduulwe kwo moto houkuzima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naho igambigwa, ‘Mnt'hu akumwasa mkaziwe amuwandikile talaka.’ ");
INSERT INTO ngp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mna miye nawagambani mnt'hu akuunga amwase mkaziwe haheina lema, mafa kwa kugenda na mgosi ywa kuse, amtenda kunda mhabwasi, naho akuunga amlombe akehabwasa hamwenga naye. ");
INSERT INTO ngp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Naho mwiva kugamba, aho kale want'hu nawagambigwa, ‘Mse kuusa kilapi, mna, damanyeni viya mwikile kilapi kwa Zumbe.’ ");
INSERT INTO ngp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mna miye nawagambani, msekugeza kukelisa hata kwe mbingu, kwa mbingu niyo ukalo wa Mnungu, ");
INSERT INTO ngp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","naho mse kukelisila isi kwaviya umwo numwo Mnungu akuikila viga vakwe, naho msekukelisila Yelusalemu kwaviya nuwo mzi wa Seuta mkulu. ");
INSERT INTO ngp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naho use kwelisila umtwi wako kwaviya houdahe kudamanya hata luvili lumwenga mwo mtwi lunde lung'aile, hegu lutitu. ");
INSERT INTO ngp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yose mkuunga myalonge gambeni ‘heiye’ hegu du ‘bule.’ Hadihali dikujink'ha aho, idyo dyalawa kwa Mwavu. ");
INSERT INTO ngp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Naho mwiva kugamba, ‘Ziso kwa ziso naho zino kwa zino.’ ");
INSERT INTO ngp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mna miye nawagambani, mse kumliha mwiihi. Uneva mnt'hu anakutowa mwe funda ya kumoso, mhituile ya kulume nayo. ");
INSERT INTO ngp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Uneva mnt'hu anakwigala kwe kitala vileke akuhoke ishati yako, mwink'he ne dikoti. ");
INSERT INTO ngp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Naho uneva mnt'hu anakugendeza kwa udahi wakwe maili imwenga, weye genda naye maili maidi. ");
INSERT INTO ngp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mnt'hu akukulombeza kint'hu, mwink'he. Use kumlemela akuunga kukukopa. ");
INSERT INTO ngp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwiva ivo ilongigwe kugamba, ‘Muunge uywako, mna muihiye mnk'hondo ywako.’ ");
INSERT INTO ngp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mna miye nawagambani, waungeni awank'hondo wenyu naho muwalombezele wose wakuwatendelani wiihi, ");
INSERT INTO ngp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ivo nomnde wana Tati yenyu ekulanga kwaviya, yehe awang'azila ung'azi we dizuwa, waihile, na awedi hamwenga, naho awenk'ha fula wose hamwenga, wakumwelela na hewe kumwelela. ");
INSERT INTO ngp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Elo Mnungu naawaliheni mbwai uneva mnawaunga wakukwelela du? Elo wakugwila kodi, wose nagamba wadamanya enga ayo? ");
INSERT INTO ngp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Naho mnawalamsa wandugu zenyu du mdamanya dihi kujink'ha awatuhu? Kwaviya hata wadya hewe mmanyize Mnungu, watenda enga ayo. ");
INSERT INTO ngp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Elo, kint'heni, enga viya Tati yenyu ywa kwe mbingu ivo eli akint'hile. ");
INSERT INTO ngp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Msinyise msekudamanya yakwelela hameso ya want'hu vileke wawatogoleni, kwa kudamanya ivo, homhokele nt'hunyo yoyose kulawa kwa Tati yenyu ywa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Elo, mkawenk'ha wakiwa vint'hu usekutoa lugong'ondo enga watondwe ivo wakutenda mwe zinyumba zo kuvikila na mwe zisila, vileke wakaulwe no kutogolwa ni want'hu. Nawagambilani ikindedi, wahokela kale amaliho yawe yose. ");
INSERT INTO ngp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mna nyuwe mkawambiza wakiwa, damanyeni kwa kinyele kugamba hata ehagihi na weye asekumanya. ");
INSERT INTO ngp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Malavo yako udamanye kwa kinyele, Mnungu akukaula kwe kinyele niye naawatunyeni. ");
INSERT INTO ngp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ukalombeza use kulombeza enga want'hu watondwe, waungisa kuvika mwe zinyumba zo kuvikila, na mwe zisila mp'handa, vileke wakaulwe ni want'hu. Nawagambilani ikindedi, wahokela kale maliho yawe. ");
INSERT INTO ngp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mna nyuwe mkalombeza, ingileni kwe nyumba kundani niyo mwavugala lwivi. Mlombezeni Mnungu heekuoneka, akusinya kwo moyo naawa tunyeni. ");
INSERT INTO ngp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Naho mkalombeza, msekulalata kwa mbuli nyingi enga hewe mmanyize Mnungu, wakagamba nawevigwe kwo wingi we zimbuli mwo kulombeza kwawe. ");
INSERT INTO ngp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mnase kunda enga woho, kwaviya Tati yenyu kamanya kale kiya mkuunga, mkei kulonga naye. ");
INSERT INTO ngp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Elo mkamlombeza Mnungu, gambeni ivi, ‘Tati yetu ywa kwe mbingu. Zina dyako ditogolwe, ");
INSERT INTO ngp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Useuta wako wize, vinde viya ukuunga weye aha he isi enga ukwo kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ukink'he dielo nk'hande ya mazuwa yose. ");
INSERT INTO ngp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ukiusile wavu wetu kitendile, enga naswe viya kikuwausila wadya wakukitendela wavu. ");
INSERT INTO ngp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Usekukigela mwa magezo, mna ukikombole kulawa mwo Mwavu.’ Kwaviya Useuta ni wako, no udahi no uwedi utendese, ulo na ulo. Taile. ");
INSERT INTO ngp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Mnawausila wavu wadya wakuwatendelani, Tati yenyu ywa kwe mbingu naye naawa usileni nyuwe wavu wenyu. ");
INSERT INTO ngp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mna hamna wausile mbazi wadya wawatendeleni wavu, Tati yenyu ywa kwe mbingu naye haawa usileni wavu wenyu mtendile. ");
INSERT INTO ngp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Naho mkafunga, msekunda want'hu wana kinyulu mwe zinyuso, enga viya watondwe wakutenda. Woho wabilinga zinyuso zawe vileke want'hu wamanye kugamba wafunga. Nawagambilani kugamba awo wahokela kale amaliho yawe. ");
INSERT INTO ngp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mna nyuwe mkafunga, hakeni mavuta mwe mitwi yenyu naho mhake mazi mwe zinyuso zenyu, ");
INSERT INTO ngp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","vileke watuhu wasekumanya kugamba mfunga, amanye Tati yenyu du e kulanga heekuoneka. Yehe akudaha kukaula yadya ya kwe kinyele naawa tunyeni. ");
INSERT INTO ngp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mse kukeikila vindolo aha he isi, aha vikubanangwa ni vimungu ne kanga, naho wahoki nawamole no kubawa. ");
INSERT INTO ngp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Keikeni ugoli kulanga ukwo vimungu ne kanga hevikudaha kubananga naho wahoki hawa kudaha kumola no kubawa. ");
INSERT INTO ngp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwaviya mioyo yenyu neikekale kudya wili vindolo venyu. ");
INSERT INTO ngp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ziso nulo lumuli lwo mwili, uneva ziso dyako dinanda gima mwili wako woseni nounde no ung'azi. ");
INSERT INTO ngp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mna uneva ziso dyako hidyo gima, mwili wako wose nounde mwe diziza titu tilili. Mna uneva udya ung'azi umwako ni lwiza, ulo nolunde lwiza lwa kutisa! ");
INSERT INTO ngp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hahali mnt'hu akudaha kunda mtumwa ywa mazumbe waidi, naamuungise yumwenga no kumbela mtuhu, naamwase yumwenga no kunda no mtuhu. Hukudaha kudamanyila ndima Mnungu no ugoli. ");
INSERT INTO ngp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ivi nivo vikuleka nawagambilani kugamba, msekunda na kiyangayanga ne nk'hande mkagamba nekidyei nekinywei, naho nekivalei. Togoleni ugima haujink'hile nk'hande, mwili nao houjink'hile zisuke? ");
INSERT INTO ngp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kauleni madege, hayadahile kuhanda na kuvuna, na kugela kwedigulu. Hamwenga naayo, Tatiyenyu ekulanga ayenk'ha nk'hande. Togoleni, nyuwe hamyajink'hile yoho mwo uwagilwa? ");
INSERT INTO ngp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Niani mwa nyuwe, kwa kunda na kiyangayanga naake ongezele utali hata mkono umwenga? ");
INSERT INTO ngp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Naho nii mwayafanyanyisa izisuke? Hake kauleni mabwali ivo yakukula, hayana ndima yoyose. ");
INSERT INTO ngp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mna nawagambilani, hata Sulemani mwo uwedi wakwe utendese wose, akei kuhambwa enga ve mihambilwe ya mabwali aya. ");
INSERT INTO ngp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Uneva Mnungu adaha kuyavala vedi mani ya kwe mbago yakunda aaho dielo na luvi yaduulwa kwo moto, haadahise kuwavalani nyuwe?, Nyuwe mhungukilwe ni mhuwi! ");
INSERT INTO ngp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Elo, mse kunda na kiyangayanga mkagamba, ‘Nekidyei, ne kivalei, hegu nekinywei? ");
INSERT INTO ngp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Want'hu hewemmanyize Mnungu nawo wafanyanya enga ivo, na Tati yenyu ekwe mbingu kamanya kugamba, mwayaunga ayo yose, naho na awenk'heni ayo. ");
INSERT INTO ngp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Naivo elo, indeni kuuzungula nk'hongo Useuta wa Mnungu na yadya yakumwelela, niho nomongezelwe aya yose. ");
INSERT INTO ngp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Elo, mse kuyafanyanya ya luvi, kwaviya luvi ina makunt'ho yakwe yenye. Makunt'ho ye dizuwa dimwenga naya mkint'heni. ");
INSERT INTO ngp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Msekuwasengela weenyu, sema nanywe mna sengelwe, ");
INSERT INTO ngp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","enga viya mkuwasengela weenyu nanywe nomsengelwe iivo, ne kihimo kiya mkuwahimila weenyu, nicho nomhimilwe nanywe. ");
INSERT INTO ngp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mna nii wakaulisa kabasi ke kwe diziso dya nduguyo, haheina kukaula kasoso kekwe diziso dyako we mwenye? ");
INSERT INTO ngp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Vivihi umgambe nduguyo ‘Hake goja hulave kabasi ke mwe diziso dyako,’ mna we mwenye ziso ditungwa ni soso? ");
INSERT INTO ngp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Weye mtondwe, hake yanda kulava kasoso ke mwediziso dyako, niho unaone vedi akabasi kemwe diziso dya nduguyo. ");
INSERT INTO ngp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Msekwink'ha makuli kint'hu kikukile, naho mse kuduula vint'hu va ugoli hana nguluwe, kwaviya, sema zinavijatangize no kuwahitukilani niyo zawasabant'hulani. ");
INSERT INTO ngp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Lombezeni nomwink'higwe, zunguleni no mbunk'hule, toweni hodi mkomwoelwe. ");
INSERT INTO ngp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwaviya, akulombeza, neenk'higwe, naho akuzungula, naabunk'hule, na wose nawatowe hodi nawakomoelwe. ");
INSERT INTO ngp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Hegu eyuko mwa nyuwe watate, akuunga amwink'he palamba mwanawe hant'hu hakumwink'ha nk'hade iyo alombeze? ");
INSERT INTO ngp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hegu wadaha kumwink'ha nyoka hant'hu ha kumwink'ha samaki iyo alombeze? ");
INSERT INTO ngp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Uneva nyuwe want'hu mwihile, mwadaha kwink'ha wana wenyu vint'hu vedi, Tati yenyu e kulanga, haasump'hule kuwenk'ha vint'hu vedi wose wakulombeza kwakwe? ");
INSERT INTO ngp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Wadamanyileni want'hu viya nyuwe mkuunga kudamanyilwa kwaviya ino niyo miko ya Musa, hamwenga na mahinizo ya walotezi. ");
INSERT INTO ngp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Yombokeleni mwo lwivi lufinyu, kwaviya lwivi luzangalamuka, sila nayo ikuita kwo kubanika izangalamu naho mp'hufu, wakombokela isila iyo wengi. ");
INSERT INTO ngp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mna sila ikuita kwo ugima finyu naho ifint'wa, naho wakuiona wageke. ");
INSERT INTO ngp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Indeni na wengele mwa walotezi wo udant'hi, want'hu wakuunga waweziileni wakanda enga ngoto, mna kundani ni mauzi yaihile. ");
INSERT INTO ngp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nomuwabunk'huile mwe zimbuli zawe wakudamanya. Zabibu hazikwahigwa mwe miwambangoma. Naho matunduja hayahigwe mwe zimbigili. ");
INSERT INTO ngp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ziti dyodyose dyedi, dyeleka matunda yedi, diihile nadyo dyeleka matunda yaihile. ");
INSERT INTO ngp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ziti dyedi hedidahe kweleka matunda yaihile. Ziti diihile nadyo hedyeleke matunda yedi. ");
INSERT INTO ngp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ziti dyodyose, hediikweleka matunda yedi, idyo dya sengwa no kugeligwa moto. ");
INSERT INTO ngp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Elo nomuwamanye mwe zimbuli zawe ziya wakudamanya. ");
INSERT INTO ngp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Hiwo wose wakunitanga, Zumbe, wakuunga wengile mwo Useuta wa kwe mbingu, mna niwadya du wakuunga wadamanye yadya yakumwelela Tate ywa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Want'hu wengi mwe dizuwa dyo usengelo nawanigambe, ‘Zumbe, suwe hachadamanye ulotezi kwa zina dyako, naho kwe dizina dyako chalavaga mp'hepo, no kudamanya vihungi!’ ");
INSERT INTO ngp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Niho neni wagambe, ‘Hiwamanyizeni. Halaweni aha hangu, nyuwe mkudamanya uwavu!’ ");
INSERT INTO ngp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Elo mnt'hu yeyose akuunga anitegeleze mbuli zangu, niyo adamanya enga ivo, uyo aliganyizwa no mnt'hu azengile nyumba yakwe mnanga mwo luwe. ");
INSERT INTO ngp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fula ize inye, mazi niyo yamema, nk'hung'unto niyo yaikungudisa inyumba, mna haiyukile hasi, kwaviya neizengelwa mwo luwe. ");
INSERT INTO ngp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Naho mnt'hu yeyose akuunga anayeve aya hulonga, niyo ase kutenda enga ivo, naaliganywe na mnt'hu mhezi, azengile nyumba yakwe mwo msanga. ");
INSERT INTO ngp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Fula niyo yanya mito niyo yamema na kumwaguka, nk'hung'unto niyo yaitowa inyumba niyo yagwa, naho cheleka chakwe ni kikulu!” ");
INSERT INTO ngp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aho Yesu eze abinde milosi iyo, want'hu nawehelwa vidala mwaivo naakahiniza. ");
INSERT INTO ngp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ahinizaga enga viya mnt'hu mta udahi naho hiyo enga wahinizi we Miko. ");
INSERT INTO ngp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu eze auye kulawa kwo mnima, atimilagwa ni mafyo makulu ya want'hu. ");
INSERT INTO ngp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mnt'hu yumwenga mta matana amwiziilaga Yesu akamfikila madi akamgamba, “Zumbe, uneva ukaunga, wadaha kunitenda nisunt'hike.” ");
INSERT INTO ngp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Niyo Yesu achulula mikono yakwe, niyo amkwafa uku aka mhitula kugamba, “Naunga.” “Sunt'hika!” Aaho, niyo yudya mta matana ahona. ");
INSERT INTO ngp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Niyo Yesu amgamba, “Kaula usekugambila mnt'hu yeyose. Mna wiite kwa mlava nt'hambiko mkulu ukakelagise kwakwe, unde uwona kwa want'hu wose kugamba kuhona, naho ukalave malavo enga viya Musa asigiilaga.” ");
INSERT INTO ngp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aho Yesu engilaga Kapelinaumu, mkulu yumwenga ywe Kilumi amwiziilaga akalombeza kwambizwa. ");
INSERT INTO ngp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Akagamba, “Zumbe kaya, eyuko mtumwa ywangu mwo lusazi, alumwa unyonge wa kuholomp'hala, alumiswa.” ");
INSERT INTO ngp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu niyo amgamba, “Neniite hamhonye.” ");
INSERT INTO ngp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yudya mkulu niyo amgamba, “Zumbe, miye hina wedi ukint'hile, vikuunga vileke weye ubule kwe nyumba yangu. Weye longa mbuli du, mndima ywangu naahone. ");
INSERT INTO ngp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwaviya miye name ni mnt'hu mkulu, naho nna watowani we mwe udahi wangu. Nnamgamba yumwenga, ‘Ita!’ Aita, hegu nnamgamba mtuhu ‘So!’ Eza, naho nnamgamba mtumwa ywangu, ‘Tenda ivi!’ Atenda.” ");
INSERT INTO ngp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu eze eve ivo, eheelwagwa, niyo awagamba wadya want'hu wamtimilaga kugamba, “Nawagambilani ikindedi, hinati kuwona mhuwi mkulu enga uno kwa mnt'hu yeyose aha he Izilaeli.” ");
INSERT INTO ngp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Naho nawagambilani, mafyo ya want'hu kulawa ulailo wa zuwa no usweelo we dizuwa, niyo wekala hamwenga na Ibulahimu, na Isaka, na Yakobo mwo Useuta wa kulanga. ");
INSERT INTO ngp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mna wadya wakuungwa kunda mwo Useuta nawaduulwe kuse ko lwiza, nuko nokunde ndilo no kugwegwejula meno. ");
INSERT INTO ngp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu niyo amgamba yudya mkulu, “Kweitile kaya, nevinde enga viya ukuhuwila.” Aaho, yudya mtumwa ywo mkulu niyo anda kahona. ");
INSERT INTO ngp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu aitaga kwe kaya kwa Petulo. Uuko ambwiilaga nine mdodo, emwo lusazi, alumwa. ");
INSERT INTO ngp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu amtozaga mkono, niyo aaho enuka ahonile, niyo akonga kuwa sank'honila. ");
INSERT INTO ngp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ize ibule mwalagulo, want'hu wamwigailaga wata mp'hepo, hamwenga na wose wandile heweekukedaha, Yesu niyo awahonya kwa ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aya yose yandaga ni kukint'hiza yadya yalogagwa ni mlotezi Isaya, akagamba, “Yehe mwenye kakihokela usokezi wetu, kakihokela maine yetu.” ");
INSERT INTO ngp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu eze aone idifyo dya want'hu dyamzunguluka, awagambaga wanamp'hina wakwe wajink'hanye nt'hendelo ya kaidi ye diziwa. ");
INSERT INTO ngp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mhinizi yumwenga ywe Miko amwizilaga, niyo amgamba, “Mhinizi,” “Miye nohutimile hohose nouite.” ");
INSERT INTO ngp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu niyo amgamba, “Mabwasiko yana ugono ywawe kwezimp'hanga, madege nayo yana vyaila vawe, mna Mwana Mnt'hu kaswesa ho kuika umtwi wakwe.” ");
INSERT INTO ngp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yumwenga mwa wanamp'hina wakwe niyo amgamba, “Zumbe, goja hande kummosa tate.” ");
INSERT INTO ngp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu niyo amhitula kugamba, “Waleke wazimu wakaika wawamose msanga wazimu weyawe.” ");
INSERT INTO ngp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu eze engile mwe ngalawa, wanamp'hina wakwe nao niyo wamtimila. ");
INSERT INTO ngp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kwandaga mjubwaniso mkulu mwe bahali, naho ingalawa yandaga aka didimila, mna Yesu andaga kagona. ");
INSERT INTO ngp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wanamp'hina niyo wamwinula, niyo wamgamba, “Zumbe kiyokole!” “Kihagihi no kubanika!” ");
INSERT INTO ngp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu niyo awagamba, “Mwogohai nyuwe mhungukilwe nu mhuwi?” Niyo enuka no kukonga kuditivila idya ink'hung'unt'ho, niyo mjubwaniso wanyamala, niyo kwa tondowala. ");
INSERT INTO ngp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Want'hu wose niyo weehelwa, wakagamba, “Uyu ni mnt'hu ywa vivihi akwivigwa hata ni nk'hung'unt'ho ne mijubwaniso ye bahali!” ");
INSERT INTO ngp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu eze abule ng'ambu mwe isi ya Wagelasi, aduganaga na want'hu waidi wandaga na mp'hepo wandaga wakalawa kwe vikuta. Wandaga wakali vidala, naho hakwandaga na mnt'hu yeyose adahaga kombokela mwe sila iyo. ");
INSERT INTO ngp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Niyo wagutiila wakagamba, “Kikubanangai weye mwana Mnungu? Weye kwiza kukisulumiza hekiinati kubula mwo lupisi lwetu lwo kusulumizwa?” ");
INSERT INTO ngp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Handaga na fyo dya nguluwe dyandaga dikadya luhalehale. ");
INSERT INTO ngp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ziya zimp'hepo zamlombezaga Yesu kugamba, “Uneva wakilava mwa want'hu awa, kigambe kikengile mwe zinguluwe.” ");
INSERT INTO ngp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu niyo azigamba, “Iteni.” Niyo zafosa mwa want'hu no kwingila mwe zinguluwe. Idifyo dyose dye zinguluwe niyo dyatula nguluko, niyo dyose dyadidimila mwe diziwa dya mazi. ");
INSERT INTO ngp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wadya wadimi we zinguluwe, niyo waguluka kwo mzi niyo wawagambila want'hu mbuli zose, hamwenga na yadya yawalaile wadya wandile ne zimp'hepo. ");
INSERT INTO ngp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Niyo mzi wose wagenda kumsingila Yesu. Weze wamuwone, niyo wamlombeza kugamba, amlawe mwe isi yawe. ");
INSERT INTO ngp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu engilaga mwe ngalawa niyo ajink'hanya mwe digundi ye diziwa, no kwingila mwo mzi wa kwawe. ");
INSERT INTO ngp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Want'hu wamwigailaga mnt'hu aholomp'hale alambalikagwa mwo lusazi. Yesu eze aone uwedi utendese wo mhuwi wawe, niyo amgamba yudya aholomp'hale, “Mwanangu, keink'he moyo, kuusilwa wavu wako.” ");
INSERT INTO ngp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niyo wahinizi wamwenga we miko, walosanyaga wakagamba, “Mnt'hu uyu amhomola Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu abunk'hulaga zifanyanyi zawe niyo awagamba, “Nii mwafanyanya wiihi mwe mioyo yenyu? ");
INSERT INTO ngp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ni kihi kihufu vitendese, kugamba, ‘Kuusilwa wavu wako,’ hegu kugamba, ‘Inuka ugende’? ");
INSERT INTO ngp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Viya naunga niwalagiseni kugamba, Mwana Mnt'hu haswesile udahi mwe isi wo kuwausila want'hu wavu ywawe.” Ivo amgamba yudya aholomp'hale, “Inuka, inula lusazi lwako ukeitile kaya!” ");
INSERT INTO ngp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yudya mnt'hu aholomp'hale akimaalaga na kuita kaya. ");
INSERT INTO ngp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Want'hu weze wayaone ayo, weehelagwa na kogoha, niyo wamtogola Mnungu kwa kuwenk'ha want'hu udahi enga uwo. ");
INSERT INTO ngp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu eze ahalawe hadya agendeelaga kulongole, niyo amuona mnt'hu akwitangwa Matayo andaga kekala he nyumba yawe yo uduganyi we kodi. Niyo amgamba, “Nitimile.” Matayo niyo enuka no kumtimila. ");
INSERT INTO ngp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu Umwo andaga akadya nk'hande kwe nyumba kwa Matayo, watoza kodi watuhu wabindile ingi, hamwenga na wata wavu watuhu wezaga kwikala hamwenga na wanamp'hina wa Yesu ho ludyo. ");
INSERT INTO ngp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo wamwenga weze wayaone ayo, wawauzaga wanamp'hina wakwe kugamba, “Mhinizi ywenyu nii adya na watoza kodi hamwenga na wata wavu?” ");
INSERT INTO ngp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu awevaga, niyo awahitula, “Mnt'hu heiina maine hakuunga ulaguzi, wanamaine nao akuunga ulaguzi. ");
INSERT INTO ngp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kehinizeni mwa mawandiko ivo Mnungu ukulonga. ‘Miye naunga mbazi hikuunga malavo.’ Miye hizile kuwetanga want'hu wedi, mna wata wavu.” ");
INSERT INTO ngp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wanamp'hina wa Yohana Mbatizi wamwiziilaga Yesu, niyo wamuuza kugamba, “Suwe na Mafalisayo chafunga. Nii wanamp'hina wako hawakufunga?” ");
INSERT INTO ngp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu niyo awahitula kugamba, “Havikudahika walalikwe kwe ndoza kufunga wakanda wamwenga no mlombi. Mna aho mlombi akeza kuhalawa mwawe, aho niho nawaungwe kufunga. ");
INSERT INTO ngp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Hahana mnt'hu akugela kilaka mwe suke isakale, cheivo kiya kilaka ikihya nekiivutumule kulawa mwe suke iyo isakale, niyo yatenda langa kulu mwe suke iyo. ");
INSERT INTO ngp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Naho hahali mnt'hu akugela lude mwe vizembe visakale, cheivo nevitulike niyo ulude ulo lwetika, vizembe ivo navo nevinde vibanika, vituhu vakwe, want'hu wagela lude mhya mwe vizembe vihya, niyo vizembe no uki vanda viikwa vedi.” ");
INSERT INTO ngp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Umwo Yesu andaga akalonga ivi, mkulu yumwenga ywa Kiyahudi amwiizilaga na kumfikila madi akamgamba, “Mwanangu ywa kivele kabanika haluse ivi, elo so uka mwiikile mikono, naande mgima.” ");
INSERT INTO ngp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu hamwenga na wanamp'hina wakwe enukaga niyo waitanya naye. ");
INSERT INTO ngp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aaho, niyo alaila mvele yumwenga andaga akahuma unyonge wakulawa sakame ibuile myaka mlongo na miidi, amtimilaga Yesu niyo adosa imp'hindilo ye suke ya Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Alongaga kimoyomoyo kugamba, “Nnadosa du isuke yakwe, nenihone.” ");
INSERT INTO ngp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ahitukaga, niyo amuona yudya mvele, niyo amgamba, “Keink'he moyo mwanangu. Mhuwi wako ukuhonya.” Aaho yudya mvele niyo ahona. ");
INSERT INTO ngp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu engilaga mwe nyumba ya yudya mkulu. Awabwiilaga want'hu wakuhongeza ndilo ");
INSERT INTO ngp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","niyo awagamba, “Foseni kuse wose! Mwana uyu habanike, kagona du!” Niyo wose wamseka. ");
INSERT INTO ngp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mna aaho want'hu weze wafose kuse, Yesu engilaga kwe nyumba kudya andaga yudya mndele abanike, amtozaga mkono niyo mndele enuka. ");
INSERT INTO ngp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Imbuli idya yenelaga mwe nt'hendelo zose ze isi idya. ");
INSERT INTO ngp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu eze ahalawe hadya, no kugendeela kulongole, mant'hunt'hu waidi, wamwiizilaga wakalonga kwa izwi kulu wakagamba, “Mwana Daudi kionele mbalazi!” ");
INSERT INTO ngp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu eze engile, wadya mant'hunt'hu waidi wamtimilaga, niyo awauza kugamba, “Togoleni, mwahuwila kugamba nadaha kuwahonyani?” Niyo wagamba, “Heiye Zumbe, wadaha.” ");
INSERT INTO ngp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu niyo ayatoza meso yawe na kuwagamba, “Nevinde enga viya mhuwile!” ");
INSERT INTO ngp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Meso yawe niyo yaona naho. Yesu niyo awafingiza akawagamba, “Msekumgambila mnt'hu yeyose imbuli ino!” ");
INSERT INTO ngp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mna woho weze waite niyo wagendeza zimbuli za Yesu mwe isi idya yose. ");
INSERT INTO ngp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Umwo want'hu wandaga wakahalawa, want'hu watuhu wamwigailaga Yesu mnt'hu kimumu kwaviya andaga ana mp'hepo. ");
INSERT INTO ngp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mna zimp'hepo izo zize zimfose aaho, mnt'hu yudya niyo akonga kulonga, want'hu wose niyo weehelwa wakagamba, “Hakinati kuviona vint'hu enga ivi mwe Izilaeli!” ");
INSERT INTO ngp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mna Mafalisayo niyo wagamba, “Alava mp'hepo kwa udahi wa mkulu we zimp'hepo!” ");
INSERT INTO ngp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu azungulukaga mizi yose ne zikaya. Ahinizaga mwe zinyumba zo kuvikila akabilikiza Mbuli Yedi yo Useuta wa Mnungu, naho ahonyaga kila maine na kila manyonge na wose heweekudaha. ");
INSERT INTO ngp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu eze ayaone mafyo ya want'hu, awaonelaga mbazi momoyo wakwe kwaviya nawanda wahwele no kuswesa wambizi enga ngoto heziina wadimi. ");
INSERT INTO ngp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ivo niyo awagamba wanamp'hina wakwe, “Ulozo ulozoka, mna wandima wo kuulozola wageke. ");
INSERT INTO ngp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mlombezeni Zumbe wo ulozo, vileke egale wavuni wo ulozo wakwewagilwa wakwe.” ");
INSERT INTO ngp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu awetangaga wanamp'hina wakwe mlongo na waidi hamwenga, awenk'ha udahi wa kugulusa mp'hepo no kuhonya want'hu maine yawe, na wose heweekukedaha. ");
INSERT INTO ngp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yano nayo amazina ya wegala ulosi mlongo na waidi wa Yesu nk'hongo ni Simoni akwitangwa Petulo, na Anduleya nduguye na Yakobo mwanawe Zebedayo na Yohana nduguye, ");
INSERT INTO ngp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batolomayo, Tomasi na Matayo andaga mkusanya kodi. Yakobo mwana Alufayo na Tadayo, ");
INSERT INTO ngp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni mkaya mtoanila isi na Yuda Isikaliyote, yudya amsezengaga Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu niyo awasigila wadya wasigilwa mlongo na waidi, niyo awagamba, “Msekuita kwa want'hu hi Wayahudi, naho msekwingila mwo mzi wowose wa Kisamalia. ");
INSERT INTO ngp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ivedi vakwe, mziitile zingoto zagile za want'hu wa Izilaeli ");
INSERT INTO ngp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Iteni mkabilikize kugamba, ‘Useuta wa Mnungu wihagihi.’ ");
INSERT INTO ngp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Honyeni wanyonge, uyuleni want'hu, wasunt'heni wata matana, laveni mp'hepo mwa want'hu. Mwink'higwa haheina maliho laveni haheina maliho. ");
INSERT INTO ngp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Msekwinula zahabu, hela, hegu shaba mwemifuko yenyu. ");
INSERT INTO ngp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Msekwinula mifuko ya kulombezela vint'hu mwe nt'hambo, naho mse kuguha suke ya kusakanya, hegu vilatu, hegu ngoda. Wandima wawagilwa kwinkwa kiya wakuunga. ");
INSERT INTO ngp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Umwo mkaita mwe zikaya na mwe mizi, ingileni mkaule yeyose akuunga amitendeleni kise. Ikaleni kwakwe mpaka aho mkuunga mhalawe. ");
INSERT INTO ngp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mkengila mwe nyumba, wagambeni, ‘Utondowazi nounde mwa nyuwe.’ ");
INSERT INTO ngp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Uneva want'hu we nyumba iyo wana watendelani kise, ndamsa iyo yo utondowazi, neisigale nawo, hawana tendile ivo, ndamsa yenyu nemiuiyeni. ");
INSERT INTO ngp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Naho want'hu wanaleka kuwatendela kise mwo mzi hegu mwe kaya yoyose, halaweni aho, naho mkahalawa, kungunt'heni no luvumbi lumwe viga venyu. ");
INSERT INTO ngp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nawagambilani ikindedi, mwe dizuwa dyo usengelo, mzi uwo noupate masulumizo makulu kujink'ha masulumizo yawapataga want'hu we mizi ya Sodoma na Gomola. ");
INSERT INTO ngp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kauliseni, miye nawasigiilani uko kuse enga ngoto mwe nyika ya mauzi. Mwaungwa mnde wabala enga nyoka, naho mnde wajalamu enga suwa. ");
INSERT INTO ngp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Indeni na wengele, kwaviya nawa wavugaileni, niyo ywawegala kwe vitala vawe, nomtoigwe ngoda mnenge nyumba zawe zo kuvikila. ");
INSERT INTO ngp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nomwigalwe kwe vitala va wakulu we isi na mazumbe kwa ajili yangu, enga ulonga uwona kwa woho na want'hu wose hi Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Umwo wakawegalani kwe vitala, msekufanyanya fanyanya ivo mkuunga mlonge. Nomwink'higwe yo kulonga Umwo mkaungwa ukulonga. ");
INSERT INTO ngp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwaviya yadya mkunga mlonge hiyo ya kwenyu nyuwe, mna nayalawe kwa Muye ywa Mnungu akuunga alonge kombokela kwa nyuwe. ");
INSERT INTO ngp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Want'hu nawawazunguile wandugu zawe kukomwa, iviya iviya welesi wakigosi nawawazunguile wana ywawe kukomwa. Wana nao nawawahitukize welesi ywawe, na kuwakoma. ");
INSERT INTO ngp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Want'hu wose na wawa ihiyeni kwaviya mwanitimila, mna akuunga afinyilize no kubula kwo uheelo, niye akuunga ahone. ");
INSERT INTO ngp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Wakakusunk'ha sunk'ha mwo mzi umwenga sumkila hatuhu. Nawagambilani ikindedi kugamba hombinde mizi yose ya Izilaeli kubula aho mwana mt'hu akei abule ");
INSERT INTO ngp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanamp'hina hakudaha kunda mkulu kumjink'ha mhinizi ywakwe, mtumwa naye hakudaha kunda mkulu kujink'ha zumbe ywakwe. ");
INSERT INTO ngp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vakint'ha mwanamp'hina aligane na mhinizi ywakwe, na mtumwa naye kuligana na zumbe dyakwe. Uneva mkulu we nyumba ketangwa Belizebuli, wana we inyumba iyo nawenk'higwe mazina yaihise? ");
INSERT INTO ngp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ivo mse kuwogoha want'hu kwaviya chochose kikefisile nekivumbuke, na kiya kimwe kinyele nekilawile kuse. ");
INSERT INTO ngp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Diya huunga niwa gambileni mwo lwiza, nyuwe mwaungwa mdilonge kungaile, na diya mkuunga mgambilwe kwe nyumba, nyuwe dilongeleni kwe hant'hu henuke hakumvikila Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Use kwogoha wakuukoma umwili niyo wadunduga kuukoma umuye. Nivedi mna mogoha akukoma umwili, akajika naho akoma no umuye mwo moto houkuzima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Togoleni, mbayuwayu imwenga haikutagwa kwa hela imwenga? Naho haikudaha kugwa imwenga haheina mzungu wa Tati yenyu ");
INSERT INTO ngp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mna nyuwe, zifili zenyu ze mitwi yenyu ziwazigwa zose. ");
INSERT INTO ngp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Elo nyuwe msekogoha, nyuwe mwafaha kujink'ha zimbayu wayu zinyingi. ");
INSERT INTO ngp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kwaviya wakuunga wanizumile miye mwe kiyeti cha want'hu kugamba miye niywawe, miye name neniwatendele iivo mwa ameso ya Tate ekulanga. ");
INSERT INTO ngp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mna akuunga ananilemele mwe kieti, name neni mlemele mwa ameso ya Tate e kulanga ");
INSERT INTO ngp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mnase mgambe hiza kwigala mwivano mwe isi. Bule. Hizile kwigala utondowazi, higala nk'hondo. ");
INSERT INTO ngp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Hiza kuwachakulani wanakilume na wa Tati zawe, wanakivele na wamami zawe, mwana kike na nine vyala. ");
INSERT INTO ngp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Naho wank'hondo wa mnt'hu nawalawe mwe mp'huga yakwe. ");
INSERT INTO ngp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Wose wawaungise wamamizawe na watatizawe kujink'ha kuniunga miye, hawawagilwe kunda wanamp'hina wangu. Na wadya wakuwaungisa wana wawe, hawawagilwe kunda wanamp'hina wangu. ");
INSERT INTO ngp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Heweekudaha kwinula viwambilo vawe, niyo wanitimila mnenge sila zangu, hawawagilwe kunda wanamp'hina wangu. ");
INSERT INTO ngp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wakuunga wageze kongezela ugima ywawe, nawawaze, mna wakuunga kuwaza ugimawawe kwa kuni zungula miye, nawongezelwe. ");
INSERT INTO ngp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Akuwahokelani nyuwe, anihokela miye, naho akunihokela miye amhokela yehe anitumile. ");
INSERT INTO ngp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Akuunga amhokele mlotezi we mbuli ya Mnungu, naahokele iviya viwagilwe ulotezi ywakwe, naho akumhokela mnt'hu ywedi, mwo uwagilwa wakwe naahokele viwagile uwedi wa uyo kwe. ");
INSERT INTO ngp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Naho namigambilani kindedi, mnt'hu yeyose akuunga amwink'he yumwenga mwa awa wakunitimila kiyamp'ha cha mazi yahoile kwaviya ni mwanamp'hina ywangu, naahokele mageleko.” ");
INSERT INTO ngp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aho Yesu eze ajinke kuwenk'ha mwiko wanamp'hina wakwe wadya mlongo na waidi, ahalawaga hadya niyo agenda kubilikiza kwe mizi ihagihi na hadya. ");
INSERT INTO ngp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana Mbatizi uko kwe divugailo, evaga zimbuli izo Kilisito naakadamanya, niyo awatuma wamwenga mwa wanamp'hina wakwe kwa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Niyo wamgamba, “Kigambile, weye niweye chagambilwe ni Yohana Mbatizi kugamba weza, hegu kikawiile mtuhu?” ");
INSERT INTO ngp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu awahitulaga kugamba, “Uyeni mkamgambile Yohana aya mkuyaona na kuyeva, ");
INSERT INTO ngp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mant'hunt'hu waona, viwete vagenda, wata matana wakukizwa, viziwi weva, wabanike wauyulwa, naho Mbuli Yedi ya Mnungu, yabilikizwa kwa want'hu wakiwa. ");
INSERT INTO ngp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nawande na kinyemi kwa wadya wose wakuunga waike mhuwi kwangu!” ");
INSERT INTO ngp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Umwo wanamp'hina wa Yohana wandaga wakauya, Yesu akongaga kulonga no mdugano akawauza kugamba, “Viya kudya kwenyika mwaitaga, mwagendaga kukaulai? Mwakawiilaga kuonai? Lunyazi lukuvesulwa ni Muye? ");
INSERT INTO ngp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mwagendaga kukaulai? Mnt'hu availe suke za kiseuta? Mnt'hu akuvala enga ivo ahumula mwe zinyumba ze kiseuta! ");
INSERT INTO ngp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nigambileni, nomgenda kukaulai? Mlotezi? Kindedi, naho kujink'ha mlotezi. ");
INSERT INTO ngp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kwaviya Yohana niye alongagwa mwe mawandiko kugamba, ‘Nenigale mwigala mbuli akuunga akulongoele, akuunga akomole isila yako.’ ");
INSERT INTO ngp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nawagambilani ikindedi kugamba, Yohana Mbatizi ni mkulu kujink'ha wose walailaga. Mna yeyose emdodo mwo useuta wa kulanga, ni mkulu kumjika Yohana. ");
INSERT INTO ngp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kukongela aho Yohana Mbatizi andaga akabilikiza mpaka mwa mazuwa aya ya dielo, Useuta wa kwe mbingu wapatikana kwa ludole, naho wata ludole nawo wakuutaha. ");
INSERT INTO ngp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwaviya mahinizo yose ya walotezi ne miko ya Musa, yalotelaga mpaka mwa Yohana. ");
INSERT INTO ngp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Naho uneva mwadaha kuzumila, uyu Yohana niye yudya Eliya aungigwe eze. ");
INSERT INTO ngp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mta magutwi, neeve! ");
INSERT INTO ngp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Haluse, want'hu wa dielo niwaliganyize na mbwai? Wekala enga wana wakwikala hedigwilo, kawetanga weyawe, ");
INSERT INTO ngp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kimtoelani ngoma mna hamuungile kuvina, naho kimkemelani mila ya kuhongeza mna hamuungile kuhongeza!’ ");
INSERT INTO ngp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Umwo Yohana ezaga, hadyaga naho hanywele mp'hombe, niyo wamgamba, ‘Ana mp'hepo!’ ");
INSERT INTO ngp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Umwo Mwana Mnt'hu eze eze, adyaga no kunywa mazi ye zabibu, niyo wamgamba mhank'hu naho mkozi, ana uhamwenga na want'hu wakutoza ushusulu mwa want'hu na want'hu watuhu wavu, kwavovose, mzungu wa Mnungu nouoneka kunda kindedi, vilawane ne zindima zakwe.” ");
INSERT INTO ngp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Want'hu we mizi idya Yesu adamanyisaga vihungi, hawaungaga kuleka wavu wawe, vatendaga Yesu awativile. ");
INSERT INTO ngp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Hangi we mwenye, Kolazini! Hangi we mwenye, Betisaida! Yandile vihungi vidamanywe kwenyu vadamanywe Tilo na Sidoni, want'hu wakwe hegu nawakweiila kale, wakavala magunia, kulagisa kugamba, waleka wavu wawe. ");
INSERT INTO ngp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nawagambilani ikindedi, mwe dizuwa dyo usengelo, nyuwe nomsulumiziswe kujink'ha weenyu wa Tilo na Sidoni. ");
INSERT INTO ngp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Weye nawe Kapelinaumu, waunga ukekweze we mwenye kulanga! Nouselezwe mpaka kwe isi ya want'hu wabanike. Uneva vihungi vidamanywe kwenyu vadamanywe Sodoma, mzi uwo hegu nounda aaho hata ivi dielo. ");
INSERT INTO ngp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Manyiseni kugamba, mwe dizuwa dyo usengelo Mnungu naauonele mbalazi Sodoma, kujink'ha nyuwe.” ");
INSERT INTO ngp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aho Yesu niyo agamba, “Nakutogola Tate, Zumbe ywa Kulanga ne isi. Nakutogola kwaviya mbuli izi kuwafisa wata umanyi na mizungu niyo wawagubuila want'hu wakembe. ");
INSERT INTO ngp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Heiye Tate ivi nivo uungile vinde. ");
INSERT INTO ngp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Hink'higwa vose ni Tate. Hahali ammanyize Umwana, hegu Tate, naho hahali ammanyize Tate ila Mwana na yeyose yudya Mwana aungile kumlavanyila. ");
INSERT INTO ngp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Soni kwangu nyose mzamilwe ni nt'wika zenyu, miye neni wahumuzeni. ");
INSERT INTO ngp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kekakeni kifungo changu, naho hineni kwangu kwaviya miye ni mjalamu naho hikeseleza, nanywe nomnde na kinyemi mwe mioyo yenyu. ");
INSERT INTO ngp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwaviya, mbuli huunga niwenk'heni nyuwe mpufu, ne nt'wika huunga niwatwikeni, ihuha.” ");
INSERT INTO ngp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mwe mazuwa yadya, Yesu andaga akagenda kombokela mwe nk'honde imwenga ya ngano mwe zuwa dya Kuhumula. Wanamp'hina wakwe niyo wakeiva sala, niyo wakonga kukwanyula magola ye ngano na kukonga kuyadya. ");
INSERT INTO ngp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo weze wayaone ayo, niyo wamgamba Yesu, “Kaula ivo wakutenda wanamp'hina wako, wabananga Miko. Hivo vedi kutenda ivo mwe dizuwa dyo Kuhumula.” ");
INSERT INTO ngp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu niyo awahitula, “Nyuwe hamsomile ivo Daudi atendaga viya yehe hamwenga na wadya want'hu viya andaga na sala? ");
INSERT INTO ngp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wengilaga kwe nyumba ya Mnungu, yehe na weyawe, niyo wadya imikate ilavigwe kwe mbuli ya Mnungu, hamwenga na kugamba hachandaga kint'hu chedi kwa woho kuidya, kwaviya wawagilwe kuidya na walava nt'hambiko aawo du. ");
INSERT INTO ngp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hegu naho nyuwe hamsomile mwe miko ya Musa kugamba kila zuwa dye Kuhumula walava nt'hambiko mwe nyumba ya Mnungu, wabanangaga miko imwenga, naho hawa kuwazilwa wavu? ");
INSERT INTO ngp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nawagambilani ikindedi, kiyaha kikulu kikujink'ha Inyumba ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iwandikwa, ‘Naungisa mbazi, hikuungisa nt'hambiko.’ Wandile mwaumanyize ulosi uno vedi, hegu homka wasengela want'hu heweina masa. ");
INSERT INTO ngp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwaviya, Mwana Mnt'hu niye Zumbe we zuwa dyo Kuhumula.” ");
INSERT INTO ngp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ahalawaga hadya, niyo aita kwe nyumba ya kuvikila. ");
INSERT INTO ngp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Uko kwandaga na mnt'hu yumwenga aholomp'halaga mkono. Naho handaga na want'hu waungaga wamgele Yesu mwa masa. Niyo wamuuza, “Hivo vedi mwe Miko yetu kumhonya mnt'hu mwe dizuwa dye Kuhumula?” ");
INSERT INTO ngp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu niyo awahitula kugamba, “Togoleni, niani mwa nyuwe mta ngoto ingile mwe digenge heekudaha kuilava mwe dizuwa dye Kuhumula? ");
INSERT INTO ngp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Naho mnt'hu ni ugoli utendedese kujink'ha ngoto. Naivo elo, mwe Zimiko hazikukifingiza kudamanya yedi mwe dizuwa dyo Kuhumula.” ");
INSERT INTO ngp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Niyo amgamba yudya aholomp'hale mkono, “Chulula mkono wako.” Niyo auchululaga mkono wakwe, niyo wanda mgima enga udya umtuhu. ");
INSERT INTO ngp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mafalisayo wamlekaga, niyo wagenda kuluka mizungu yo kumkoma Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu eze eve mizungu yo kumkoma, niyo ahalawa hadya, mna fyo kulu dya want'hu dya mtimilaga. Awahonyaga wose wandaga wakalumwa, ");
INSERT INTO ngp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","naho awasigiilaga kugamba, wasekugambila want'hu watuhu zimbuli zakwe. ");
INSERT INTO ngp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Atendaga ivi vileke yadya alongaga Mnungu kombokela kwa mlotezi Isaya yakint'he. ");
INSERT INTO ngp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Niye mtumwa ywangu nimsagule, niye nimuungise naho hyelelwa naye. Nenimgele Muye ywangu mwakwe. Mbuli yo usengelo wangu naaigendeze kwa want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Haande mnk'hani naho haagutile, naho haaile kwa izwi kulu mwe zibalabala. ");
INSERT INTO ngp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Haavune mnuli ugolome, naho lumuli lukufunk'ha mosi haaluzime Naande aaho mpaka aulete usengelo wo uwagilwa inde na uhumi, ");
INSERT INTO ngp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","naho mwa yehe, want'hu wose nawande na kawiilo.” ");
INSERT INTO ngp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Naho kwandaga na want'hu yumwenga andaga mant'hunt'hu wamwigalaga kwa Yesu. Naho hakudaha kulonga kwaviya andaga na mp'hepo. Yesu amhonyaga mnt'hu yudya niyo anda mgima niyo adaha kulonga na kukaula. ");
INSERT INTO ngp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mafyo ya want'hu weehelwagwa kwa yadya adamanyaga Yesu. Niyo wakeuzauza kugamba, “Ivi uyu hiyo Mwana Daudi?” ");
INSERT INTO ngp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mafalisayo weze ivo, niyo wahitula kugamba, “Uyu alava mp'hepo kwaviya Belizebuli amwink'ha udahi wa kudamanya ivo.” ");
INSERT INTO ngp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu ayamanyaga yose yadya nawakadamanya, niyo awahitula kugamba, “Useuta wowose ukukepanga vivulujungu, vikutoana venye kwa venye, haikwikalisa. Naho uneva mzi, hegu lukolo lolose lukukepanganiza mwe vivulujungu, vikutoana venye kwa venye, lukolo ulo nolugwe ");
INSERT INTO ngp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ivo uneva mwo useuta wa Mwavu, kila kafyo katoana na keyawe, nuko kugamba, uzumbe uwo ukepanga, naho nousunguze ukugwa! ");
INSERT INTO ngp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nyuwe mwagamba miye nalava mp'hepo kwaviya Belizebuli anink'ha udahi wo kudamanya ivo. Vedi, haluse niani akuwenk'ha wanamp'hina wenyu udahi wo kulava mp'hepo? Kiya wakudamanya wanamp'hina wenyu, nichokikuwasengelani kugamba mwi wavu! ");
INSERT INTO ngp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bule! Hiyo mkulu ywa mp'hepo, mna Muye ywa Mnungu niye akunink'ha udahi wa kuzilava mp'hepo. Naivo kulavanya kugamba, Useuta wa Mnungu uweziilani kale. ");
INSERT INTO ngp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Hahali yeyose akudaha kumola nyumba ya mta udahi, niyo aguha vint'hu vakwe, mpaka ande kumkakakiliza mta umdahi uyo, niho adahe kuitaha inyumba iyo. ");
INSERT INTO ngp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mnt'hu yeyose hehamwenga na miye uyo anitowa nk'hodo, naho heekuduganya na miye, uyo amwaganisa. ");
INSERT INTO ngp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Naivo nawagambilani, want'hu nawausilwe wavu wowose na wiihi wowose wakunga wamlongele Mnungu. Mna mnt'hu akuunga amlongele yaihile Muye ywa Mnungu, haausilwe. ");
INSERT INTO ngp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Naho mnt'hu yeyose akuunga alonge dyodyose diihile kwa mwana mnt'hu, adaha kuusilwa wiihi uwo, mna akuunga ayalonge yaihile kwa Muye ywa Mnungu, haausilwe wavu uwo kukongela ivi haluse, na mazuwa yakwiza. ");
INSERT INTO ngp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mti wedi neweleke matunda yedi, mti wiihile nawo neweleke matunda yaihile. Naho kila mti nemanyike mwe cheleko chakwe. ");
INSERT INTO ngp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nyuwe cheleko cha mazoka! Mwadaha vivihi kulonga mbuli zedi mna nyuwe enye mwiha? Kwaviya mnomo walonga kiya kimemeze umoyo. ");
INSERT INTO ngp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mnt'hu ywedi alava mbuli zedi kulawa mwe kindolo che vint'hu vedi, aihile naye alava vint'hu viihile kulawa mwe kindolo che vint'hu viihile. ");
INSERT INTO ngp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mwikale mkamanya kugamba, mwedizuwa dyo usengelo, kila yumwenga naaungwe kulava ikindedi cha kila ulosi wiihile aulongile. ");
INSERT INTO ngp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwaivo kwe milosi yako nousengelwe kulumizwa, naho kwe milosi yako nousengelwe kuhozwa.” ");
INSERT INTO ngp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Niyo wahinizi wamwenga we zimiko hamwenga na Mafalisayo niyo wamgamba, “Mhinizi, chaunga ukilagise vilagiso.” ");
INSERT INTO ngp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu niyo ahita akagamba, “Cheleko cha uhabwasi kiihile chazungula vilagiso, du hekink'higwe vilagiso, ila vilagiso va mlotezi Yona. ");
INSERT INTO ngp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Enga viya Yona ekalaga mazuwa matatu mwe diifu dye nyangumi, Mwana Mnt'hu nivo neekale mwo moyo we isi mazuwa matatu kilo na msi. ");
INSERT INTO ngp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mwe dizuwa dyo usengelo, want'hu wa Ninawi nawakimale hamwenga ne cheleko iki, naho nawakisegele kunda na wiihi. Kwaviya wamtegelazaga Yona niyo waleka wavu wawe. Nawagambilani ikindedi kugamba, kiyaho kikulu kumjink'ha Yona. ");
INSERT INTO ngp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mwe dizuwa dyo usengelo, mke zumbe ywa kumosi naakimale na kuwagela mwo usengelo wo wiihi wenyu, kwaviya agendaga kulawa hale kwiza kwiva ubala wa Sulemani. Naho aha eyaho mkulu kumjink'ha Sulemani! ");
INSERT INTO ngp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mp'hepo ikamfosa mnt'hu, yombokela mwe isi inyaile ikazungula ho kwikala. Uneva ina swesa, ");
INSERT INTO ngp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yagamba, ‘Neniuye kwe nyumba yangu.’ Naivo yauya, niyo inabwiila inyumba idya haina chochose, ihagilwa naho ihambwa. ");
INSERT INTO ngp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Naivo yaita kuse niyo yawaguha weyawe watuhu mfungate waihile kujink'ha yoho yenye, niyo zeza kwikala mwo mt'hu uyo. Umwo zikekala mwo mnt'hu uyo, uyo mnt'hu anda na hali iihise kujink'ha idya ya nk'hogo. Naivo nivo vikuunga vilaile, mwa awant'hu awa awavu wa mazuwa aya.” ");
INSERT INTO ngp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Umwo nine na wanduguze wamwizilaga, Yesu andaga akagendeela kulonga na want'hu. Woho wakimaalaga kuse kwaviya waungaga walonge naye. ");
INSERT INTO ngp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ivo mwanamp'hina ywakwe yumwenga niyo amgamba, “Nyokwe na wanduguzo wakimala kuse, waunga walonge na weye.” ");
INSERT INTO ngp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu niyo awahitula kugamba, “Wandugu zangu ni wahi? Naho mnala niani?” ");
INSERT INTO ngp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Niyo aloloteza kwa wanamp'hina wakwe niyo agamba, “Kauleni awa nao wandugu zangu, naho nao wamnala. ");
INSERT INTO ngp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mnt'hu yeyose akutenda yakumuwagila Tate ywa kwe mbingu, uyo niye lumbu dyangu naho niye ndugu yangu naho niye mnala.” ");
INSERT INTO ngp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mwe dizuwa idia, Yesu ahalawaga hadya he nyumba, niyo aita nt'hendelo ya kwe diziwa. Uko ekalaga hasi niyo akonga kuhiniza. ");
INSERT INTO ngp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mafyo makulu ya want'hu yamzungulukaga, valekaga akengila mwe ngalawa niyo ekala uumo, mna ayo amafyo yandaga mnk'handa mwe diziwa. ");
INSERT INTO ngp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ahinizaga mbuli zibindile ingi kwa miliganyizo. “Kwandaga na mnt'hu agendaga kumyaga mbeyu. ");
INSERT INTO ngp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Umwo andaga akamyaga zimbeyu zimwenga zatomokaga mwe sila, niyo zadondolwa ni videge. ");
INSERT INTO ngp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Zimwenga zatomokaga mwo luwe mwandaga na msanga mgeke. Mbeyu zia niyo zanyuluka, kwaviya msanga nounda mgeke. ");
INSERT INTO ngp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mna zuwa dize dyalike, niyo dyazoka zimbeyu zihotile, naho kwaviya maizi yakwe hayengilisaga hasi, mbeyu ziya zihotile niyo zanyuluka. ");
INSERT INTO ngp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu zimwenga zatomokelaga mwe miwamba ngoma yakulisaga, niyo yazivigaviga zimbeyu izo zihotile. ");
INSERT INTO ngp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mna mbeyu zimwenga nezitomokela mwo ulongo wedi, niyo zimwenga zeleka mp'huluzi gana, zimwenga milongo mtandatu, imwenga milongo mitatu kujink'ha viya zahandagwa.” ");
INSERT INTO ngp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu niyo awagamba, “Mta magutwi yo kwivila neeve!” ");
INSERT INTO ngp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wanamp'hina wakwe wezaga wakamuuza, “Nii wahiniza kwa miliganyizo umwo ukalonga na want'hu?” ");
INSERT INTO ngp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu awahitulaga akawagamba, “Nyuwe mwink'higwa kumanya kinyele cho umanyi we vint'hu vo Useuta wa Mnungu, mna hiyo woho.” ");
INSERT INTO ngp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwaviya kila mta kint'hu neenk'higwe vituhu no kongezelwa, vileke ande navo vikumkint'ha. Mna heiina kint'hu, naahokigwe hata kiya ikidodo ana nacho. ");
INSERT INTO ngp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Vikuleka hahiniza kwa miliganyizo umwo halonga nao, ni kwaviya, wakaula mna hawakuona, wategeleza mna hawa kwiva, naho hawa kukombaganya. ");
INSERT INTO ngp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ivo yadya alongile mlotezi Isaya yakint'ha kwawe kugamba, kutegeleza nomtegeleze mna homkombaganye. Kukaula nomkaule mna homuwone. ");
INSERT INTO ngp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwaviya mioyo yawe midala, naho wayasita magutwi yawe, na meso yawe wafinya. Hegu nawakaula, naho hegu naweva, hegu nawakombaganya mwo ubala wawe, no kunihitukila, name hegu nehiwahonya. ");
INSERT INTO ngp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mna kwa nyuwe mna kinyemi kwaviya meso yenyu yaona magutwi yenyu nayo yeva. ");
INSERT INTO ngp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nawagambilani kindedi, walotezi na want'hu wengi wedi nawaungisa kuyaona ayo nyuwe mkuyaona, mna wadundugaga, nokwiva aya nyuwe mkwiva, mna hawadahaga. ");
INSERT INTO ngp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tegelezeni naho mhine mliganyizo wo mhandi ivo ukulonga. ");
INSERT INTO ngp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wose wadya wakuitegeleza mbuli yo useuta wa Mnungu, mna niyo hawakuukombaganya, awa wekala enga ziya zimbeyu zatomokaga mwe sila. Mwavu niyo eza no kuzingola ziya zimyagigwe mwawe. ");
INSERT INTO ngp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ziya zimbeyu zitomokele mwo luwe, ni enga wadya wakuhokela mbuli ya Mnungu kwa kinyemi, aaho wakeza kuiva du. ");
INSERT INTO ngp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mna haikwingilisa mwe mioyo yawe, naho haikwikalisa, naivo wabwiilana na masulumizo na magezo yakaweziila kwe mbuli idya wahokele, wauya kunyuma. ");
INSERT INTO ngp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Zimbeyu ziya zigweele mwe miwambangoma, zakeiga na wadya wose wakuiva mbuli ya Mnungu, wogofi wo wikazi mwe isi, hamwenga nokuungisa ugoli, wazinganiza imbuli niyo waswesa kweleka. ");
INSERT INTO ngp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Naho mbeyu ziya zitomokele mwo ulongo wedi zakimala hant'hu ha wadya wakuiva imbuli ya Mnungu no kuikombaganya, naivo ukweleka mp'huluzi, imwenga kwa gana, imwenga milongo mtandatu, nt'huhu milongo mitatu.” ");
INSERT INTO ngp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Niyo Yesu awagambila mliganyizo mtuhu. “Useuta wa Mnungu wikala enga ivi. Mnt'hu ahandaga mbeyu yedi mwo mgunda. ");
INSERT INTO ngp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mna zuwa dimwenga nekilo want'hu wagonile, mwiihi ezaga niyo ahanda mani matuhu mwe nk'honde idya ihandigwe ingano niyo ahalawa. ");
INSERT INTO ngp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mbeyu izo zize zikule no kukonga kugela magola, mani nayo niyo yakelaviliza. ");
INSERT INTO ngp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Niho wandima wakwe wamwiizila no kumgamba, ‘Zumbe, hwa handile mbeyu zedi mwe nk'honde yako? Mani matuhu yalawa nahi?’ ");
INSERT INTO ngp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Zumbe niyo ahitula, ‘Mwiihi niye adamanye ivi,’ wandima niyo wamuuza, ‘Waunga kikayangole mani yadya?’ ");
INSERT INTO ngp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yudya zumbe niyo awahitula, ‘Bule, mnase mng'ole hamwenga ne ingano, kwaviya vi hamwenga. ");
INSERT INTO ngp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lekeni zikulanye, vibule mwokuvunwa, aho niho neniwagambe wavuni, yandeni kung'ola mani matuhu, niyo mwayalunja hamwenga mwe vichanga yokwe moto. Mkajika, ingano igeleni kwe digulu dyangu.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu niyo awagambila mliganyizo mtuhu. “Useuta wa Mnungu, wikala enga ivi. Mnt'hu akuguha kabeyu kadodo vitendese niyo aihanda mwo mgunda wakwe. ");
INSERT INTO ngp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ni kabeyu kadodo kujink'ha mbeyu zose, mna kanakula, dyanda ziti kulu kujink'ha miti yose. Dyanda ziti dikutenda madege yeze no kuzenga vyaila vawe mwa matambi yakwe.” ");
INSERT INTO ngp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu awagambila mliganyizo mtuhu. “Useuta wa kulanga wikala enga viya mvele akuguha ugwadu no kuugela mwe mpishi nt'hatu za unga, niyo wagwaduka wose.” ");
INSERT INTO ngp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu niyo awagambilaga want'hu zimbuli zose kwa miliganyizo. Halongaga dyodyose kwa want'hu haheina miliganyizo. ");
INSERT INTO ngp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Atendaga ivi kutenda yadya alongaga mlotezi yakint'he, “Neniloge kwa miliganyizo Umwo halonga na woho, neniwagambile mbuli heziimanyike kukongela aho ho kuumbigwa isi.” ");
INSERT INTO ngp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu eze awalage awant'hu no kwingila kwe nyumba, wanamp'hina wakwe nawamuitila no kumgamba, “Kigambile, mliganyizo wa mani mo mgunda, nivo wagaaze?” ");
INSERT INTO ngp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu niyo awahitula, “Mhandi we mbeyu izedi ni Mwana ywa Mnungu, ");
INSERT INTO ngp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","mgunda ni isi, mbeyu izedi ni want'hu wo Useuta, mani ni wadya want'hu wa Mwavu. ");
INSERT INTO ngp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mwavu ahandile zimbeyu ziihile ni Mwavu, uvuni nounde mwo kusila kwe isi, wavuni ni mtumigwa ywa kwe Mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Enga viya va mani matuhu yakulunganywa no kokigwa mwo moto, kint'hu enga icho nekilaile kwe dizuwa dyo kusila isi. ");
INSERT INTO ngp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana Mnt'hu naawegale mtumigwa ywakwe no kuwaduganya wose wekuse yo Useuta wakwe, na wose wawatendile want'hu wadamanye wavu, na wose wakudamanya mbuli ziihile. ");
INSERT INTO ngp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mtumigwa ywa kwe mbingu wa Mnungu nawawaduule mwo moto. Uko nawaile no kugwagwajula meno. ");
INSERT INTO ngp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Naho wadya want'hu wedi nawang'ale enga zuwa ko Useuta wa Tati yawe. Mta magutwi ya kwivila neeve! ");
INSERT INTO ngp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Useuta wa kulanga ukeiga na mnt'hu akuzungula kindolo kifisigwe mwo mgunda. Eze akione, kwa kinyemi niyo agenda kutaga vint'hu vose andile navo niyo eza kuugula umgunda udya. ");
INSERT INTO ngp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Naho useuta wa kulanga ukeiga na mnt'hu akuzungula kint'hu cha ugoli, ");
INSERT INTO ngp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","naho eze avumbuze iyedi heina ya kuligana nayo, agendaga kutaga vose viya andaga navo, niyo aigula. ");
INSERT INTO ngp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Naho Useuta wa kulanga ukeiga na lwavu wa samaki waduulaga lwavu lwawe mwe diziwa niyo wagwila zisamaki zi hengi. ");
INSERT INTO ngp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lwavu lwize lumeme, nawaluvuta kuse ye bahali, wazisagule zi samaki zia izedi wazigela mwe zint'hangulu, na zia ziihile waziduula. ");
INSERT INTO ngp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ivi nivo nevinde mwe dizuwa dyo kusila isi mtumigwa ywa kwe Mbingu nawawaduganye want'hu awavu kulawa mwa awant'hu awedi, ");
INSERT INTO ngp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","naho nawaduulwe mwe nunda ina moto. Uko nokunde ndilo na kugwegwejula meno.” ");
INSERT INTO ngp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu niyo awauza, “Togoleni mwayakombaganya aya?” Niyo wamhitula, “Heiye,” ");
INSERT INTO ngp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ivo niyo awahitula, “Uku nukugamba, kila mhinizi wa Miko ukunda mwanamp'hina mwo Useuta wa kulanga, naande enga yudya mta nyumba aguile ivint'hu ivihya na kuviusa viya va kale mwe nyumba yakwe.” ");
INSERT INTO ngp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu eze abinde kuwagambila imiliganyizo iyo, ahalawaga hadya ");
INSERT INTO ngp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nokuuya kwawe kaya. Ahinizaga mwe nyumba ya Mnungu, naho wose wadya wamwivile weheelagwa. Wauzaga, “Uyu kaulavahi umanyi enga uno? Na udamanyi wa udahi enga uno? ");
INSERT INTO ngp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Uyu hiye mwana ywa selemala? Nine hi Maliamu, naho wanduguze hi awa wakina Yakobo, na Yusufu, na Simoni, na Yuda? ");
INSERT INTO ngp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Walumbuze wose hawa kwikala aaha? Yano yose kayapata hi?” ");
INSERT INTO ngp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Elo niyo wamlemela. Mna Yesu niyo awagamba, “Mlotezi naahokelwe hohose ila hiyo kwawe kaya, na mwe nyumba yawe.” ");
INSERT INTO ngp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwaviya hawana mhuwi, hakudaha kudamanya vihungi vingi aho. ");
INSERT INTO ngp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Helode zumbe ywa Galilaya azivaga zimbuli za Yesu, ");
INSERT INTO ngp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","niyo awagamba wandima wakwe, “Uyo ni Yohana Mbatizi auyuke! Nivo vikuleka ana udahi wa kudamanya vihungi.” ");
INSERT INTO ngp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kwaviya helode asiigilaga kugamba Yohana agwilwe niyo akakilizwe mp'hingu na kuvugailwa kwedivugailwe, adamanyaga ivo kwe mbuli ya Helodiya mkaziwe dya mkuluwe Filipo. ");
INSERT INTO ngp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwaviya zuwa dimwenga, Yohana Mbatizi amgambaga Helode, “Hivo vedi kwa weye kumlomba Helodia.” ");
INSERT INTO ngp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode aungaga amkome mna andaga akawogoha Wayahudi Kwaviya wammanyaga kugamba andaga mlotezi. ");
INSERT INTO ngp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mwe dizuwa dyo wila wokukumbukila ukwelekwa kwakwe Helode, mwanawe we kivele etangwe Helodiya avinaga mwe kieti cha want'hu wose. Helode elelwaga vidala uvini wo mwanawe ");
INSERT INTO ngp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","vilekile akamgamba, “nilombeze chochose name nohwink'he!” ");
INSERT INTO ngp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kwa kusongelezwa ni nine, amgambaga ise, “Nink'he haluse ivi umtwi wa Yohana Mbatizi mwo lwiga.” ");
INSERT INTO ngp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Zumbe azimilagwa, mna kwa kuwogoha wadya wandaga aho wevaga akalonga no mwanawe, niyo asigiila kugamba yudya mwana kike enk'higwe viya aungile. ");
INSERT INTO ngp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yohana niyo akant'wa umtwi kudya kwe divugailo. ");
INSERT INTO ngp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Umtwi niyo wageligwa mwe kaziga niyo enk'higwa yudya mwana kike, naye niyo amwigaila nine. ");
INSERT INTO ngp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wanamp'hina wa Yohana wezaga kuuguha umwili wa Yohana no kuumosa msanga, niyo wagenda kumgambila Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu eze eve zimbuli za Yohana ahalawaga hadya mwe ingalawa niyo aita hant'hu hakiikeike, want'hu wamwivaga, niyo wamtimila kulawa kwe kaya lwaviga. ");
INSERT INTO ngp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu niyo afosa mwe ngalawa, naho eze auone mdugano mkulu, nakawaonela mbazi awant'hu, awahonyaga wose wandaga wakalumwa. ");
INSERT INTO ngp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mwalagulo ludya wanamp'hina wakwe wamwizilaga niyo wamgamba, “Zuwa diswa na uku ki kwe nyika. Walage awant'hu waite wakakezunguile nk'hande.” ");
INSERT INTO ngp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu niyo awagamba, “Hevidahike want'hu awa wahalawe, wenk'heni nyuwe cho kudya.” ");
INSERT INTO ngp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Niyo wamhitula, “Aha suwe kina visamaki vishano du na vebesu viidi va mikate.” ");
INSERT INTO ngp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu niyo awagamba, “Hake vinink'heni.” ");
INSERT INTO ngp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Awagambaga want'hu wekale hasi mwa mani, niyo aguha mikate idya imishano ne visamaki viidi. Niyo akaula kulanga, niyo amtogola Mnungu, aibendulaga migate idya, niyo awenk'ha wanamp'hina, wanamp'hina nawo niyo wawapasila awant'hu. ");
INSERT INTO ngp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kila yumwenga adyaga, niyo eguta. Wana mp'hina wakwe waduganyaga nt'hangulu mlongo na mbili zimemile vibesu visigale. ");
INSERT INTO ngp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Want'hu wadyaga ludyo ulo wandaga gana milongo mishano wagosi awo du, kuleka wavele, na wana. ");
INSERT INTO ngp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu niyo awagamba wanamp'hina wakwe wengile mwe ngalawa, naho walongole kuita gundi ye diziwa Umwo yehe andaga akawalaga awant'hu. ");
INSERT INTO ngp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eze abinde kuwalaga, aitaga komnima ekedu kugenda kumlombeza Mnungu. Kwize kunde mwalagulo Yesu andaga ekedu. ");
INSERT INTO ngp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naho mwo lupisi ulo ngalawa yandaga hale mwediziwa, ikajubwaniswa kwaviya kwandaga na nk'hung'unto yandaga ikaihingamila ingalawa. ");
INSERT INTO ngp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ize ibuze kilo cha gati ya saa kane na saa mtandatu, Yesu awabasaga wanamp'hina wakwe akagenda mwa amazi. ");
INSERT INTO ngp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Weze amuone akagenda mwa amazi, niyo wogoha wakagamba, “Iki kizuli!” Niyo waguta kwa kogoha. ");
INSERT INTO ngp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mna aho Yesu niyo awagamba, “Keink'heni moyo, ni miye. Msekogoha!” ");
INSERT INTO ngp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulo niyo amgamba, “Zumbe uneva ni weye nigambe nize uko nigende mwa mazi.” ");
INSERT INTO ngp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu niyo amgamba, “So.” Petulo niyo aseela mwe ngalawa no kugenda mwa amazi akambasa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mna eze aone nk'hun'gunto, niyo ogoha no kukonga kudubwila mwa mazi niyo aguta, “Zumbe niyokole!” ");
INSERT INTO ngp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aho niyo Yesu amtoza no umkono wakwe na kumgamba, “Weye uhungukilwe mhuwi, nii kunda muoga?” ");
INSERT INTO ngp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Naho Umwo weze wengile mwe ingalawa, nk'hung'unto niyo wanyamala. ");
INSERT INTO ngp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Niyo wose wandaga mwe ingalawa niyo wamvika wakagamba, “Kindedi weye niwe mwana Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Weze womboke idiziwa, niyo wabula mwe isi ya Genezaleti, ");
INSERT INTO ngp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","want'hu wa hadya weze wabunk'hule kugamba niyehe, niyo wagambilana wose, hamwenga na wanyonge wawegalaga kwa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Niyo wamlombeza kugamba wadose du zimp'hindo ze isuke yakwe, naho wose watendaga ivo wahonaga kindedi. ");
INSERT INTO ngp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Naho mafalisayo wamwenga na wahinizi we zisigiizi wezaga kulawa Yelusalemu wakamuuza Yesu kugamba, ");
INSERT INTO ngp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nii wanamp'hina wako hawakutimila mahinizo ya wakale wetu? Hawa kuhaka mazi mwe mikono enga viya vikuungwa wakaunga wadye!” ");
INSERT INTO ngp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu niyo awahitula, “Nii nanywe hakutimila miko ya Mnungu mna mwatimila mahinizo yenyu nyuwe wenye? ");
INSERT INTO ngp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwaviya Mnungu agambaga, ‘Wogoheni watati zenyu na wamami zenyu,’ naho ‘Akuunga amhomole nine hegu ise naakomigwe.’ ");
INSERT INTO ngp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mna nyuwe mwahiniziza kugamba uneva mnt'hu ananacho cha kumwambiza ise hegu nine mna agamba, ‘Iki kint'hu ni cha Mnungu,’ ");
INSERT INTO ngp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","havikuungwa amogohe ise. Kwa ivi hamtimila miko ya Mnungu, vileke mtimile mahinizo yenyu enye. ");
INSERT INTO ngp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Watondwe nyuwe! Isaya awalotelaga vedi aho akagamba, ");
INSERT INTO ngp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Want'hu awa wanivika kimnomo, mna mioyo yawe ihale na miye. ");
INSERT INTO ngp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wanivika bule, kwaviya wahiniziza mahinizo ya want'hu, enga kugamba ni miko yangu!’ ” ");
INSERT INTO ngp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu niyo awitanga umdugano, niyo awagamba “Tegelezani naho mkombaganye. ");
INSERT INTO ngp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hiyo kiya kikumwingila mnt'hu kwo mnomo kimtende ande msavu, mna kukifosa mo mnomo uwo nicho kikumtenda ande msavu.” ");
INSERT INTO ngp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wanamp'hina wakwe niyo wamwizila wakamgamba, “Kuvimanya kugamba Mafalisayo wank'hondo wa kwe milosi yako?” ");
INSERT INTO ngp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Niyo yehe ahitula kugamba, “Ziti dyodyose hedihandigwe ni Tate e kulanga nedi ng'oligwe na maizi. ");
INSERT INTO ngp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Msekuwogoha Kwaviya awo ni vilongozi mant'hunt'hu, uneva kilongozi mant'hunt'hu amlongoza mant'hunt'hu miyawe wose waidi nawahubugile mwedibome.” ");
INSERT INTO ngp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulo niyo amgamba, “Kigambile vedi umliganyizo uno.” ");
INSERT INTO ngp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu niyo awauza, “Nanywe mkei kunda wabala du? ");
INSERT INTO ngp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Hamkukombaganya kugamba, kikwingila kwo mnomo chaita kwezinda, niyo chafosela kuse. ");
INSERT INTO ngp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mna kikulawa mwo mnomo chalawa ko moyo naho iki chamgela mnt'hu usavu. ");
INSERT INTO ngp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwaviya kwo moyo kwalawa fanyanyi ziihile, zikwigala ukomi, uhabwasi, na mbuli nt'huhu za mwo mwili, finju, udant'hi, na kuhomola. ");
INSERT INTO ngp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yano yose nayo yakumgela mnt'hu usavu, mna hiyo kudya haheina kuhaka mikono kukumtenda mnt'hu ande msavu.” ");
INSERT INTO ngp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu ahalawaga hadya niyo aita kwe isi hagihi ne mizi ya Tilo na Sidoni. ");
INSERT INTO ngp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mvele yumwenga wa Kanani amwizilaga akamgamba, “Yesu mwana Daudi! Niyonele mbazi Zumbe! Mwanangu wa kike ana mp'hepo, naho yamgela kiyangayanga yanga.” ");
INSERT INTO ngp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mna Yesu hamhitulaga dyodyose. Wanamp'hina wakwe wamwizilaga, niyo wamgamba, “Mgambe ahalawe kwaviya akitimilatimila naho akiyegezela.” ");
INSERT INTO ngp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu niyo ahitula kugamba, “Hitumigwa kwezingoto zagigile za want'hu wa Izilaeli aawo du.” ");
INSERT INTO ngp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aaho yudya mvele niyo amfikila madi akamgamba, “Zumbe nambize.” ");
INSERT INTO ngp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu niyo ahitula, “Hivo vedi kuguha nk'hande ya awana na kwink'ha makuli.” ");
INSERT INTO ngp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yudya mvele niyo agamba, “Ni kindedi Zumbe, mna hata makuli nayo yalogotaga visiga vikutomoka mwe meza ya zumbe ywawe.” ");
INSERT INTO ngp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu niyo amhitula kugamba, “Mnala, mhuwi wako ni mkulu, nevinde viya ukuunga.” Aaho yudya mwana kike niyo ahona. ");
INSERT INTO ngp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ahalawaga no kuita mnk'handa mwe diziwa dya Galilaya, akwela ko mnima niyo ahumula. ");
INSERT INTO ngp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mdugano mkulu wa mwiizilaga wakamwigaila want'hu waholomp'hale, want'hunt'hu, viwete, vimumu na want'hu wabindile ingi, niyo wawatambalika heviga vakwe niyo awahonya. ");
INSERT INTO ngp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Want'hu wehelagwa weze waone vimumu valonga, viwete vagenda, waholomp'hale wahona mant'hunt'hu nawo wasinya, niyo wamtogolesa Mnungu wa Izilaeli. ");
INSERT INTO ngp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu niyo awetanga wanamp'hina wakwe, niyo awagamba, “Naona mbazi nawo mdugano uno mkulu Kwaviya nekindanya mwa mazuwa amatatu yose, mna waswesa chokudya, name hikuzumila kuwalaga haheina kuwenk'ha chokudya, Kwaviya na wagwe mteho mwe sila wakauya kwe kaya.” ");
INSERT INTO ngp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanamp'hina wakwe niyo wamgamba, “Chapatahi nk'hande kikint'he mdugano uno wose?” ");
INSERT INTO ngp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu niyo auza, “Mnanayo mikate mingahi?” Wana mp'hina wakwe niyo wamhitula, “Mfungate na visamaki vigeke.” ");
INSERT INTO ngp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ivo Yesu niyo awagamba want'hu wekale hasi ho ulwazo. ");
INSERT INTO ngp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Niyo aguha idya migate mfungate na visamaki, niyo amtogola Mnungu, niyo abendula no kuwenk'ha wanamp'hina, wanamp'hina nao niyo wawapasila awant'hu. ");
INSERT INTO ngp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wose wadyaga, niyo weguta. Niyo wanamp'hina waduganya nt'hangulu mfungate zimemile vibesu ve visigale ve mikate. ");
INSERT INTO ngp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Want'hu waidyaga wabulaga alufu kane, wagosi aawo du, haheina kuwawaza wana hamwenga na wavele. ");
INSERT INTO ngp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Naho niyo Yesu awalaga want'hu, no kwingila mwe ngalawa niyo aita kwe isi ya Magadani. ");
INSERT INTO ngp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Niyo Mafalisayo na Masadukayo wamwizila Yesu wakamwinika kwa kumgamba adamanye vilagiso kulawa kulanga vikuga vilagise kugamba kalawa kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mna Yesu awahitulaga kugamba, “Zuwa dikaswa mwagamba kwaunga kunde kwedi, Kwaviya ulanga wink'hundu. ");
INSERT INTO ngp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kukanda mtondo wedi mwagamba kwa unga kunde vula kulu Kwaviya ulanga wi nk'hundu naho utitihala. Mwadaha kumanya umsimo, mkausinya ulanga mna mdunduga kumanya vilagiso va amazuwa aya. ");
INSERT INTO ngp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Cheleko kiihiye naho cha wahabwasi nicho cha awant'hu wa amazuwa aya! Mwaniunga niwenk'heni vilagiso? Bule! No mwink'higwe kilagiso kimwenga cha Yona.” Niyo awaleka no kukeitila akeitila. ");
INSERT INTO ngp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Umwo wanamp'hina wandaga wakajink'hanya ng'ambu ye diziwa, wajalaga kuguha mkate wowose udya. ");
INSERT INTO ngp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu niyo awagamba, “Mnde na wengele, naho mkedime no ugwadu ya Mafalisayo na Masadukayo!” ");
INSERT INTO ngp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Niyo wakonga kulosanya wenye kwa weye kugamba, “Kalonga ivi kwaviya hakiguhile mkate wowose.” ");
INSERT INTO ngp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mna Yesu ayamanyaga ayo wandaga wakalonga. Niyo awauza, “Nyuwe mhungukilwe ni mhuwi! Nii mwatalaula mwe mbuli yokuswesa mikate? ");
INSERT INTO ngp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mkei kukomboganya hata haluse? Mjala ivo nabendulaga mikate idya mishano niyo wadya want'hu milongo magana mashano? Mwamemezana nt'hangulu nyingahi? ");
INSERT INTO ngp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Naho togoleni mikate mfungate wadyaga want'hu milongo magana mane? Mwamemeza nt'hangulu nyingahi? ");
INSERT INTO ngp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vivihi hamkukombaganya viya nehilonga imbuli ye mikate? Kedimeni no ugwadu wa Mafalisayo na Masadukayo!” ");
INSERT INTO ngp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aho wanamp'hina wakwe niho wakombaganyaga kugamba hawafundaga wakedime no ugwadu we mikate, ila wakedime na mahinizo ya mafalisayo hamwenga na Masadukayo. ");
INSERT INTO ngp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu aitaga mwe isi ya Kaisalia Filipi, awauzaga wanamp'hina, “Want'hu wagamba miye ni miye yuhi?” ");
INSERT INTO ngp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wamhitulaga kugamba, “Wamwenga wagamba ni weye Yohana Mbatizi, wamwenga wagamba Eliya, naho wamwenga wagamba Yelemia hegu u yumwenga mwa walotezi wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Niyo awauza, “Nyuwe mwagamba ni miye yuhi?” ");
INSERT INTO ngp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulo niyo ahitula, “Weye nuyo Kilisito, Mwana ywa Mnungu e mgima.” ");
INSERT INTO ngp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu niyo amhitila, “Una kinyemi weye Simoni mwana Yohana. Kwaviya ikindedi iki hwink'higwe ni mnt'hu yeyose, mna kwinkwa ni Tate e kulanga. ");
INSERT INTO ngp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Naivo nakugambila, weye Petulo u luwe, naho mo luwe ulu neni dizenge fyo dya wahuwila wa Kilisito, naho file yoyose heidahe kudihuma. ");
INSERT INTO ngp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nohwink'he vikomoelo vo Useuta wa kwe mbingu, na yadya ukuunga ulemeze mwe isi nekinde kilemezwa kulanga, na kiya ukuunga ukizumile mwe isi nekinde kizumilwa kulanga.” ");
INSERT INTO ngp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Niyo Yesu awafingiza wanamp'hina wakwe wase kumgambila mnt'hu yeyose kugamba yehe niye Kilisito, Mkombozi. ");
INSERT INTO ngp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kukongela aho Yesu akongaga kuwagambila awanamp'hina wakwe haheina kufisa, kugamba aungwa aite Yelusalemu, na uko na apate masulumizo mengi kulawa kwa wakale na wakulu wa walava nt'hambiko na awahinizi we miko ya Musa enk'higwe Mnungu. Naho naakomigwe na mna zuwa dya katatu naauyuke. ");
INSERT INTO ngp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petulo niyo amguha hank'handa, no kumtivila akamgamba, “Heidahike Zumbe mbuli enga iyo ikubwiile!” ");
INSERT INTO ngp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu niyo amhitukila no amgamba Petulo, “Halawe mwa meso yangu, weye Mwavu! Wanikindila kulongole mwe sila yangu, Kwaviya ufanyanyi uwo unanao hakulawa kwa Mnungu, uwo wa kimnt'humnt'hu.” ");
INSERT INTO ngp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Niyo Yesu awagamba wanamp'hina wakwe, “Uneva yeyose aunga kunitimila akelave kindedi, aketwike msalaba wakwe wa masulumizo, niyo anitimila.” ");
INSERT INTO ngp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yeyose akuunga kuuhonya ugima wakwe naazaganye, mna akuwazaganya zumila wakwe kwa ajili ya miye na uone. ");
INSERT INTO ngp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Uneva mnt'hu anenk'wa isi yose, mna awaza ugima wakwe, naakeongezelei? Hegu mnt'hu aunga ausakanye ugima wakwe na kint'hu chani? ");
INSERT INTO ngp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwaviya Mwana Mnt'hu neeze mwo uwedi utendese wa Ise hamwenga na watumigwa wa kwe mbingu, niyo awaliha want'hu kwa kila yumwenga viligane na viya adamanye. ");
INSERT INTO ngp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nawagambilani ikindedi kugamba weyaho mwa woho wakimale aha, hawadugane ne file heweenati kumuwona Mwana Mnt'hu akeza mo Useuta wakwe. ");
INSERT INTO ngp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yeze yomboke mazuwa mtandatu Yesu awaguhaga. Petulo, Yakobo, hamwenga na Yohana nduguye dya Yakobo aawo du, niyo awalongoza mpaka kulanga mwo mnima. ");
INSERT INTO ngp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ahadya wamuonaga akahituka ifuta yakwe, ifuta yakwe yangalaga enga zuwa, suke zakwe nao zandaga enga ung'azi. ");
INSERT INTO ngp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aaho niyo walailwa ni Musa, hamwenga na Eliya, wakasimuila hamwenga na Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petulo niyo amgamba Yesu, “Zumbe viwagila suwe kunda aha, uneva ukaunga neni zenge viheha vitatu, kamwenga kako, kamwenga kakwe Musa, katuhu nako kakwe Eliya.” ");
INSERT INTO ngp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Umwo andile akagendela kulonga ivo, vunde ding'aile, niyo dyawagubika, izwi kulawa kulanga dyagambaga, “Uyu niye Mwanangu nimuungise, hyelelwa naye. Mtegelezeni yehe.” ");
INSERT INTO ngp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wanamp'hina weze weve diizwi, niyo wenamiza zinyuso zawe hasi kwa kogohesa. ");
INSERT INTO ngp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mna Yesu niyo eza kuwa dosa niyo awagamba, “Inukileni, msekogoha.” ");
INSERT INTO ngp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Niyo wenula meso, mna hawaone mnt'hu ila Yesu eke du. ");
INSERT INTO ngp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Uno wandaga wakaseela kulawa kwo omnima, Yesu awafingizaga wase kugambila yoyose kwa yadya wayaone, mpaka mwana Mnt'hu eze auyuke. ");
INSERT INTO ngp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wanamp'hina niyo wamuuza, “Vivihi wakuhiniza sigilizi? Wagamba Eliya naande kwiza?” ");
INSERT INTO ngp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu niyo ahitula, “Ikindedi Eliya naande kwiza, naho naayadamanye yose. ");
INSERT INTO ngp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mna nawagambilani kugamba, Eliya keza kale, mna woho wadunduga kummanya, mna namdamanyila kale yose yadya waungile kumdamanyila, enga ivi Mwana Mnt'hu naye akusulumizwa mwe mikono yawe.” ");
INSERT INTO ngp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Niyo wanamp'hina wakwe wakombaganya kugamba, naaka wasimulizila mbuli ya Yohana Mbatizi. ");
INSERT INTO ngp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aho weze wauye ko mdugano, mnt'hu yumwenga amwizilaga akamfikila madi akamgamba, ");
INSERT INTO ngp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Zumbe mfile mbazi mwanangu, ana kifutu naho alumiziswa, adulagwa momoto na mwamazi. ");
INSERT INTO ngp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nawegailaga wanamp'hina wako mna wadunduga kumhonya. ");
INSERT INTO ngp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu niyo ahitula akagamba, “Nyuwe cheleko kiswesile mhuwi! Nenikale na nyuwe mpaka ini? Nigaileni aha uyo ndugu ywetu.” ");
INSERT INTO ngp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu aitivilaga idya mp'hepo, niyo yamlawa yudya mbwanga, aaho yudya mbwanga niyo ahona. ");
INSERT INTO ngp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Wanamp'hina wakwe niyo wamwizila Yesu kinyele no kumuuza, “Zumbe, suwe nii kidunduga kuilava mp'hepo?” ");
INSERT INTO ngp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu niyo awahitula, “Kwaviya mswesa kunda na mhuwi ukint'hile. Nawagambilani ikindedi, mwandile no mhuwi ukuligana na kabeyu ko mvumo, mwadaha kuugamba mnima uno, ‘Halawe aha uite hadya,’ naho niyo waita. Hakihali kikuunga kinde kidala kwa nyuwe.” ");
INSERT INTO ngp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mna naho, aya yadaha kulavigwa kwa kufunga na kulombeza Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wana mp'hina wakwe weze weze wose Galilaya, Yesu awagambaga, “Mwana Mnt'hu naagelwe mwe mikono ya want'hu waihile. ");
INSERT INTO ngp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nawamkome, mna mwe dizuwa dya katatu naauyuke.” Wana mp'hina wakwe niyo waihiwa mwo ulosi uwo. ");
INSERT INTO ngp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na wanamp'hina wakwe weze wabule Kapelinaumu, watoza wa kodi wamwizilaga Petulo, niyo wamuuza kugamba, “Togola, Mhinizi ywenyu akulihaga kodi ye Nyumba ya Mnungu?” ");
INSERT INTO ngp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulo niyo amhitula kugamba, “Alihaga.” Petulo eze engile kwe nyumba, Yesu niyo akonga kumuuza, “Simoni Petulo, wayafanyanya vihi? Mazumbe we isi waduganyaga maliho kulawa kwaani? Kulawa mwa wanawe wenye, hegu kulawa kwa wata kwiza?” ");
INSERT INTO ngp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo niyo ahitula, “Kulawa kwa wata kwiza.” Yesu niyo amgamba Petulo, “Nivedi. Uneva ni ivo wakaya hawakuliha. ");
INSERT INTO ngp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mna vileke kinase kukiguha hant'hu, ita kwe diziwa, kaduule induwano yako, guha samaki ya nk'hongo ukuunga unaigwile. Igubule mnomo wakwe, nouone shilingi mlongo na mbili, ziguhe, niyo unilihile kodi miye hamwenga na weye mwenye.” ");
INSERT INTO ngp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ukati udya awanamp'hina wakwe wamwizilaga Yesu wakamuuza, “Niani umkulu mo Useuta wa kulanga?” ");
INSERT INTO ngp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu etangaga kazana kadodo, niyo akakimalisa mgati mwawe, ");
INSERT INTO ngp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","niyo agamba, “Nawagambilani kindedi, homdahe kwingila ko Useuta wa kulanga uneva hamnahituke no kunda enga akazana aka kadodo. ");
INSERT INTO ngp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Elo mnt'hu yeyose akuunga anakeseleze niyo anda enga aka kazana kadodo, uyo niye mkulu kujink'ha wose ko Useuta wa kulanga. ");
INSERT INTO ngp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Naho mnt'hu yeyose akuunga akatendele kise kazana enga aka kwa zina dyangu, mnt'hu uyo anitendela miye. ");
INSERT INTO ngp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mna mnt'hu yeyose akuunga analeke yumwenga mwa wadodo awa asekunihuwila miye atende wavu, viwagilwa uyo akakigwe iwe kulu dya kusagila, mwe singo yakwe, niyo adubwikwa mwo mnyongomela we bahali. ");
INSERT INTO ngp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hangi yenye isi kwaviya umwo mbuli zikuwatenda want'hu waze mhuwi wawe, mbuli enga izo hazikukindilika kulaila, mna hangi yemwenye mnt'hu akuunga aleke zilaile. ");
INSERT INTO ngp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Uneva mkono hegu kiga chako vakutenda udamanye wavu, ukant'he niyo waudula hale, ni vedi kwa weye kwingila ko ugima hwiina mkono, hegu kiga, kujink'ha kunda ne mikono yose miidi, hegu viga vose viidi niyo waduulwa kwo moto wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naho sizo dyako dinakutenda unde Mwavu, ding'ole, niyo wadiduula. Ni vedi kwa weye kwingila kwo ugima na ziso dimwenga, kujink'ha kunda na meso yose maidi niyo wadulwa kwo moto houkuzima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Msinyise mse kumbela yeyose mwa wadodo awa, kwaviya nawagambilani, watumigwa wawe uko kulanga we hameso ya Tate uko kulanga. ");
INSERT INTO ngp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwaviya Mwana Mnt'hu keza kukombola kiya chagile. ");
INSERT INTO ngp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mwafanyanya vihi, uneva mnt'hu mta magoto gana, niyo dimwenga mwa ayo dyaga naatende vivihi? Naayaleke yadya mlongo kanda na kanda mwo lugulu, no kugenda kudizungula diya digoto dimwenga dyagile. ");
INSERT INTO ngp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Naho anadiona nawagambilani ikindedi, na ande na kinyemi kikulu kujink'ha yadya milongo kanda na kanda heyagile. ");
INSERT INTO ngp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Enga iivo Tati yenyu ekulanga, hakuunga yumwenga mwa wadodo awa age. ");
INSERT INTO ngp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mnt'hu akuunga anakutendele wiihi, mwiitile niyo wakumlagisa uwavu wakwe. Mna utende ivo kwa kinyele, nyuweenye waidi du, anakwiva nivedi, kumpata umiao. ");
INSERT INTO ngp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mna hanakwivile kaguhe mnt'hu mtuhu yumwenga hegu waidi, vileke dia dikuunga dinalongwe mwakwe dimanyike kwa want'hu waidi hegu watatu. ");
INSERT INTO ngp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Uneva anawalemela ao nao mwitangile kwe fyo dya wahuwila wa Kilisito, analemela kwe fyo dya wahuwila wa Kilisito kose, uyo umtende enga mnt'hu he mmanyize Mnungu hegu du uone enga mgwila kodi. ");
INSERT INTO ngp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nawagambilani kindedi, dyodyose mkuunga mdivugale he isi nedinde divugalwa kwe mbingu, diya mkuunga mdikomole he isi nedinde dikomwolwa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Naho nawagambilani uneva waidi wenyu wanaivana mwe isi, kwa mbuli yoyose wakuunga wanalombeze neniidamanye kwe dizina dya Tate ekulanga. ");
INSERT INTO ngp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwaviya aho wakudugana waidi hegu watatu mwedizina dyangu, name nihamwenga nawo.” ");
INSERT INTO ngp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petulo niyo amwitila Zumbe, niyo amuuza, “Mnt'hu anitendele wavu kengahi name nimlekele? Anitendele malavo mfungate?” ");
INSERT INTO ngp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu niyo amhitula kugamba, “Hiyo malavo mfugate du, mna malavo milongo mfugate malavo mfungate. ");
INSERT INTO ngp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwaviya Useuta wa kulanga ukeiga na mnt'hu yumwenga aungaga kumanya ivo wadamanye awatumwa wakwe. ");
INSERT INTO ngp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aho wakakonga kugambilana, egalagwa mnt'hu yumwanga andaga akadaiwa ni yudya zumbe zabulaga talant'ha milongo magana mlongo. ");
INSERT INTO ngp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kwa mtumwa aswesaga cho kuliha, zumbe aungaga mtumwa atagigwe, yehe mwenye, mkaziwe awanawe, na vose viya wandaga navo vileke alihe dideni. ");
INSERT INTO ngp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yudya mtumwa niyo amgweela akamfikila madi akagamba, ‘Nionele mbazi ludodo, no hulihe kila kint'hu!’ ");
INSERT INTO ngp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yudya zumbe ywo mtumwa niyo aona mbazi, niyo amuusila dideni dyakwe no amleka aite. ");
INSERT INTO ngp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Mna umwo yudya mtumwa akaita kuse, niyo amuona mtumwa miyawe naakamdai dinali gana, niyo amgwila akamgamba, ‘Nilihe kila kiya hwink'hile!’ ");
INSERT INTO ngp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yudya mtumwa miyawe niyo amfikila madi, akamwiila mbazi, ‘Niyonele mbazi, nohulihe dideni dyako!’ ");
INSERT INTO ngp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mna yehe niyo alemela, niyo amgwila no kumdula kwedivugailo, mpaka ande kuliha idideni. ");
INSERT INTO ngp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Awatumwa watuhu weze wayaone yose yadya yalaile nawaona usungu, niyo waita kwa zumbe nokumgambila yose yalaile. ");
INSERT INTO ngp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Niyo zumbe amwitanga yudya mndima kwe nyumba nokumgamba, ‘Weye mndima wiihile, nokunilombeza name niyo nakulekela yose yadya nehakutigiza, uguhile kwangu, ");
INSERT INTO ngp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","We nawe hudahile kumwonela mbazi mndima miyao enga viya miye huonele mbazi?’ ");
INSERT INTO ngp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kwa maya zumbe dyakwe naye niyo amhitukila nakumgela kwedivugailo alumizwe haheina kulekelwa, vikungwa alihe vose viya akudaiwa.” ");
INSERT INTO ngp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ivi nivo Tate ekulanga, akuunga amtende yeyose mwa nyuwe hakudaha kuwausila madeni wanduguze kwa mbazi kulawa momoyo wakwe.” ");
INSERT INTO ngp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu eze abinde kuyalonga ayo, ahalawaga Galilaya niyo aita mwe isi ya Uyahudi ng'ambu yo mto Yolodani. ");
INSERT INTO ngp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Fyo kulu dya want'hu dya mtimilaga niyo awahonya uko. ");
INSERT INTO ngp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo wamwenga wamwiizilaga na ugeza kumgwila kwa kumuuza, “Togola haviihile kwa mnt'hu kumwasa mkaziwe kwa lema dyodyose?” ");
INSERT INTO ngp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu awahitulaga akawagamba, “Hamsomile mawandiko msunt'hilwa kugamba, aho nk'hongo Muumbi aumbaga mgosi na mvele? ");
INSERT INTO ngp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Naho Mnungu agambaga, ‘Kwa aya mgosi na awase ise na nine, niyo anda na mkaziwe, naho awa waidi nawande hiyo waidi naho, ila nawande mwili umwenga.’ ");
INSERT INTO ngp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hawande waidi naho, woho wanda mwili umwenga. Kwa ivo walunganywe ni Mnungu, mnt'hu ase kuwa panga.” ");
INSERT INTO ngp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mafalisayo wamuuza Yesu, “Nii Musa akisigiilaga kugamba mnt'hu adaha kumwink'ha mkaziwe talaka niyo amwasa?” ");
INSERT INTO ngp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu niyo awahitula, “Musa awalekagani muwase wavele wenyu kwaviya mna nk'hani. Mna havandaga enga ivo kukongela kwo kuumbigwa kwe isi. ");
INSERT INTO ngp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Naivo wagambilani nyuwe, yeyose akuunga amwase mkaziwe hi kwa mbuli ya uhabwasi, niyo alomba mvele mtuhu, naande mhabwasi. Na akuunga alombe yudya mvele naye, atenda uhabwasi.” ");
INSERT INTO ngp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wanamp'hina wakwe niyo wamgamba Yesu, “Uneva nivo vili kwa mgosi na mkaziwe, ni vedi mnt'hu asekulomba.” ");
INSERT INTO ngp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu niyo awahitula, “Hiyo wose kuihokela imbuli ino ni kwa wadya du wasagulwe ni Mnungu kunda ivo. ");
INSERT INTO ngp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwaviya ziuko mbuli heezikuligana zikuleka mnt'hu asekulomba. Wamwenga nivo welekwe, wamwenga watakutendigwa ni want'hu kunda ivo, wamwenga nao hawakulomba kwa kuuzugula Useuta wa Mnungu. Yeyose akuidaha imbuli ino naaihokele.” ");
INSERT INTO ngp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Naho niyo egailwa wana wadodo awageleke mikono yakwe awavikile. Mna wanamp'hina wakwe niyo wawativila wadya wawegale. ");
INSERT INTO ngp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu niyo agamba, “Walekeni wana wadodo waniizile, msekuwafingiza, kwaviya Useuta wa kulanga ni wa want'hu enga awana awa.” ");
INSERT INTO ngp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Agelekaga mikono yakwe mwa awo wana, niyo ahalawa. ");
INSERT INTO ngp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mnt'hu yumwenga mgoli amwizilaga Yesu akamgamba, “Mhinizi, naungwa nidamanye mbuli yani yedi vileke nihokele ugima wa ulo na ulo?” ");
INSERT INTO ngp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu niyo amhitula, “Nii waniuza uwedi? Hahali mnt'hu ywedi, ywedi ni Mnungu ekedu. Mna uneva waunga wingile kwo ugima wa mazuwa hasila, damanya mwiko viya zikulonga.” ");
INSERT INTO ngp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yudya mnt'hu niyo amuza Yesu, “Ni zihi?” Yesu niyo amhitula, “Usekukoma, usekunda mgenda na wavele hi wako, usekubawa, usekumlongelezela mnt'hu mbuli hi za kindedi, ");
INSERT INTO ngp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","uweve iso na nyokwe, naho uwaunge weyao enga viya ukukeunga weye mwenye.” ");
INSERT INTO ngp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yudya mnt'hu niyo ahitula, “Yose ayo hiyatoza, hisigazai naho?” ");
INSERT INTO ngp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu niyo amgamba, “Ukaunga unde kukint'ha mo uwedi, katage viya unanavo niyo wawapangila wakiwa, ivo naunde na kindolo uko kulanga. Ukajika nitimile.” ");
INSERT INTO ngp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yudya mnt'hu eze eve ivo, ahalawaga aihiwe, Kwaviya andaga mgoli mkulu. ");
INSERT INTO ngp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Niyo Yesu alonga na wanamp'hina wakwe kugamba, “Nawagambilani ikindedi, ni vidala vitendese kwa mgoli kwingila ko Useuta wa kulanga. ");
INSERT INTO ngp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Navuzagiza ni vihufu ngamia komboka mwa kalanga ke singano, mna hi mgoli kwingila ko Useuta wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wanamp'hina wakwe weze weve ivo, naweeheleswa, niyo wauza, “Uneva ni ivo, niani naadahe kuhona?” ");
INSERT INTO ngp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu niyo awasinya kwa udahi no kuwagamba, “kwa want'hu hevidahike, mna kwa Mnungu yose ni mahufu.” ");
INSERT INTO ngp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petulo niyo amhitula, “kaula,” Suwe kileka kila kint'hu niyo chakutimila. “Nekink'higwei?” ");
INSERT INTO ngp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu niyo awahitula akawagamba, “Nawagambilani ikindedi, nyuwe, umwo Mwana Mnt'hu akekala mwe difumbi dyakwe dyo uwedi utendese, niho nyuwe nanywe mkunitimila nomwikale mwe viti mlongo na viidi mkayasengela makabila mlongo na maidi ya Waizilaeli. ");
INSERT INTO ngp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Naho yeyose alekile nyumba yakwe, hegu wandugu wa kigosi na walumbuse na ise na nine, hegu wanawe ne zink'honde zakwe, kwa kunizungula miye naahokele malavo gana ya viya avilekile, naho neenk'higwe ugima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mna wengi wa nk'hongo nawaziigile, wadya nao wazigiile nawande wa nk'hongo.” ");
INSERT INTO ngp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kwaviya Useuta wa kwe mbingu ukeiga enga ivi. Mnt'hu mta nk'honde yakwe, akelailaga kilo kilo akawapangile want'hu ndima mwe nk'honde yakwe ye mizabibu. ");
INSERT INTO ngp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Naho weze wazumilane kuwaliha maliho ya zuwa dimwenga, niyo awasindikiza kwe nk'honde ye mizabibu. ");
INSERT INTO ngp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ize inde saa nt'hatu, niyo afosa naho kuse yo mgunda ambwilaga watuhu wakimale hedigwilo, heweina chokudamanya, ");
INSERT INTO ngp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","niyo awagamba, ‘Nanywe iteni kwe nk'honde yangu ye mizabibu mkadamanye ndima neniwaliheni viya muwagilwe kulihwa.’ ");
INSERT INTO ngp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Niyo waita. Eze afose naho, ize ibule sa ya mtandatu na sa kanda, adamanyaga enga viya va bosi. ");
INSERT INTO ngp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Afosaga naho ize ibule sa ya mlongo na imwenga aonaga watuhu wakimale hagihi, niyo awauza, ‘Nyuwe nii mkimala aha msi mgima mswesa ndima?’ ");
INSERT INTO ngp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Niyo wamhitula, ‘Kwaviya hahali akink'hile ndima,’ niyo awagamba, ‘Nivedi, nanywe iteni mkadamanye ndima kwe nk'honde yangu ye mizabibu.’ ");
INSERT INTO ngp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kisingi kize kibule, zumbe wo mgunda niyo amgamba umnyamp'hala, ‘Wetange wandima wose uwalihe amaliho yawe, akakonga yudya azigiile, kubula kwa uyu wa bosi.’ ");
INSERT INTO ngp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wadya want'hu wakongile indima sa mlongo na imwenga, nawalihigwa shilingi kila yumwenga. ");
INSERT INTO ngp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ivo weze weze wadya wose wakongaga bosi, nawakamanya kugamba nawalihigwe na maholokela, mna woho nawo nawalihigwa maliho ya zuwa dimwenga kila yumwenga. ");
INSERT INTO ngp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nawasinya yadya maliho niyo wakonga kumkalaliza mta mgunda, ");
INSERT INTO ngp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","wakamgamba, ‘Awa wazigiile wadamanya ndima sa dimwenga du,’ ‘suwe kiikigwa mwe dizuwa msi mgima, mna wawaliha vikuligana na suwe!’ ” ");
INSERT INTO ngp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mta mgunda niyo amhitula yumwenga ywawe akamgamba, “ ‘Mbuyangu,’ ‘Hikuhujile. Hamwenga na ayo kiivana mlihwe maliho ya zuwa dimwenga kwa wose. ");
INSERT INTO ngp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Elo guha matundu yako ukeitile. Naunga nimlihe yudya azigiile enga viya hulihile weye. ");
INSERT INTO ngp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hiwagilwe kuyadamanyila ndima matundu yangu enga ivo huunga? Hegu kwingila finju kwaviya miye ni ywedi?’ ” ");
INSERT INTO ngp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu niyo akomeleza kugamba, “Akuziigila ivi haluse, naande ywa nk'hongo, ywa nk'hongo naye naazigile.” ");
INSERT INTO ngp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Umwo Yesu andaga akaita Yelusalemu, awaguhaga wanamp'hina wakwe kwe nyumba, niyo alonga nao haheina want'hu akawagamba. ");
INSERT INTO ngp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kauleni,” “chaita Yelusalemu, na Mwana Mnt'hu naagelwe mwe mikono ya wakulu wa walava nt'hambiko na wahinizi wa Miko, naho nawamsengele kukomwa, ");
INSERT INTO ngp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","naho na wamvuze kwa want'hu hi Wayahudi, nawamzesezigile na kumtoa mikotya niyo wamuwamba mwo msalaba, mna mwe dizuwa dya katatu kukongela dizuwa dye file yakwe, naande kauyuka.” ");
INSERT INTO ngp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Niyo mkaza Zebedayo hamwenga na wanawe waidi wambasa Yesu niyo wamfikila madi akalombeza kint'hu. ");
INSERT INTO ngp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu niyo amgamba, “Waungani?” Yudya mvele niyo agamba, “Sigiila kugamba wanangu awa, yumwenga ekale kulume kwako, na yumwenga naye kumoso uko ko Useuta wako.” ");
INSERT INTO ngp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu niyo amgamba, “Hamkimanyize kia mkulombeza. Ivi mwadaha kukinyweela kiamp'ha changu cha masulumizo kia hunyweela miye?” Niyo wamhitula, “Chadaha.” ");
INSERT INTO ngp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu niyo awagamba, “Yadahika mkadaha kukinyweela ikikombe changu, mna ukwikala kulume hegu kumoso, miye hina ulamuzi. Kulume na kumoso kuikilwa wadya waikilwe lumwe ni Tate.” ");
INSERT INTO ngp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Naho wadya mlongo weze weve zimbuli za wadya wandugu niyo waihiwa. ");
INSERT INTO ngp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mna Yesu niyo awetanga akawagamba, “Mmanya kugamba wakulu wa want'hu hi Wayahudi wawalongoza want'hu kikwank'walu, wakulu wawe nawo wawombosela udahi wawe mwawo. ");
INSERT INTO ngp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mna hevinde ivo kwenyu. Akuunga kunda mkulu umwenyu, vamuunga ande mtumwa ywenyu, ");
INSERT INTO ngp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","naho mnt'hu akuunga ande ywa nk'hongo, akonge kunda mtumwa ywenyu, ");
INSERT INTO ngp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kwaviya Mwana Mnt'hu hezile adamanyilwe ndima ni want'hu mna keza kuwadamanyila ndima want'hu, no kuulava ugima wakwe vileke want'hu wengi wakombolwe.” ");
INSERT INTO ngp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Umwo Yesu na wanamp'hina wakwe wakalawa Yeliko, fyo kulu dya want'hu dyamtimilaga. ");
INSERT INTO ngp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Want'hu waidi mant'hunt'hu wekalaga hank'handa he sila. Naho weze weve Yesu omboka, niyo wabongeela wakagamba, “Zumbe Mwana Daudi kionele mbazi.” ");
INSERT INTO ngp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Want'hu niyo wawativila no kuwagamba wanyamale, mna woho niyo wagendeela kukweza izwi, “Zumbe Mwana Daudi kionele mbazi.” ");
INSERT INTO ngp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu niyo akimala no kuwetanga, niyo awauza, “Mwaunga niwadamanyileni mbwai?” ");
INSERT INTO ngp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Niyo wamhitula, “Zumbe chaunga kidahe kuwona.” ");
INSERT INTO ngp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu niyo awaonela mbazi, niyo awadosa meso yawe, aaho niyo wadaha kuwona, no kumtimila. ");
INSERT INTO ngp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aho Yesu na wanamp'hina wakwe weze wabule hagihi na Yelusalemu no kubula Betifage mo Mnima we Mizeituni, aho Yesu nakawatuma wanamp'hina wakwe waidi, ");
INSERT INTO ngp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akawagamba, “Iteni he kaya iyo ihalongole, nomkabwiile mp'hunda ikakigwe hamwenga na mwanawe. Zidoholeni mnigaile. ");
INSERT INTO ngp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mnt'hu yeyose akuunga awauzeni dyodyose, mgambileni kugamba, ‘Zumbe aziunga,’ naho naazivuze.” Nae naawa zumileni. ");
INSERT INTO ngp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Idi dilaile vileke yadya alongaga mlotezi yakint'he. ");
INSERT INTO ngp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ugambileni mzi wa Sayuni, kaula Zumbe ywako akwizila, mjalamu wa moyo, emwe mp'hunda, na mwana mp'hunda.” ");
INSERT INTO ngp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wanamp'hina waitaga, niyo wadamanya enga viya Yesu Awasigilaga. ");
INSERT INTO ngp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wamwigaila mp'hunda no mwana mp'hunda, watandikaga zisuke zawe mnanga niyo Yesu ekala mnanga mwe mp'hunda. ");
INSERT INTO ngp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mafyo ya want'hu wabindile ingi watandikaga zisuke zawe mwe sila, wamwenga nawo nawasenga mahuto no kuyatandika mwe sila. ");
INSERT INTO ngp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Idifyo dya want'hu diya dimlongoele na diya dikumtimila, wandaga wakanga kwa izwi kulu wakagamba, “Ntogola kwa Mwana Daudi! Mnungu naamvikile yudya akwiza kwa zina dya Zumbe. Naatogolwe Mnungu uko kulanga.” ");
INSERT INTO ngp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu eze engile Yelusalemu, mzi wose no wituka, wakauza, “Uyu ni ani?” ");
INSERT INTO ngp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Diya idifyo niyo dyawahitula, “Uyu ni Yesu, Mlotezi kulawa Nazaleti ya Galilaya.” ");
INSERT INTO ngp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu engilaga mwe Nyumba ya Mnungu, niyo awakump'husa kuse wadya wose wandaga wakataga no kugula mdya mwe Nyumba ya Mnungu. Azikindulaga zimeza za wadya nawaka sakanya matundu, ne viti va wataga suwa, ");
INSERT INTO ngp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","akawagamba, “Iwandikwa mwe mawandiko kugamba, ‘Nyumba yangu neitangwe nyumba ya kuvika Mnungu.’ Mna nyuwe mwaitenda mp'hanga ya wabavi!” ");
INSERT INTO ngp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Want'hu viwete na mant'hunt'hu wamwizilaga kudya kwe Nyumba ya Mnungu niyo awahonya. ");
INSERT INTO ngp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mna wakulu wa Walava nt'hambiko na wahinizi we zi sigilizi, waihiwagwa weze waone yadya ya kweheela akudamanya Yesu, no ukwanga kwa wana wadodo mwe Nyumba idya ya Mnungu wakagamba, “Naatogolwe Mwana Daudi!” ");
INSERT INTO ngp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Niyo wamgamba, “Weva ivo wana awa wakulonga?” Yesu niyo awagamba, “Heiye, neva.” “Hamsomile mwa Mawandiko? ‘Muwahiniza wana ne vizana, kulava nt'hogola zikinth'ile.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Niyo Yesu awalekaga no kuita kuse yo umzi, aitaga Besania, uko agonaga. ");
INSERT INTO ngp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mtootondo Umwo andaga akeza naho kwo mzi, akeivaga sala. ");
INSERT INTO ngp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Eze auone mtini hagihi ne sila, aubasaga, mna haonaga matunda ila na mani du, niyo augamba, “Howize weleke matunda naho ulo na ulo.” Aaho umti udya niyo wanyuluka. ");
INSERT INTO ngp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wanamp'hina wadya weze wayaone yadya niyo weehelwa wakagamba, “Kwa vivihi mti udya ukanyuluka ludole?” ");
INSERT INTO ngp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu niyo ahitula, “Nawagambilani ikindedi, mnanda namhuwi, naho msekung'asang'asa, nomdahe kudamanya hiyo enga idi du dyo didamanyike dyo mtini, nomdahe hata kuugamba mnima uno, ‘Ita kaakedule kwe bahali,’ naho niyo vanda. ");
INSERT INTO ngp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nawagambilani ikindedi mnanda na mhuwila nom mhokele kia ukulombeza.” ");
INSERT INTO ngp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu eze engile mwe Nyumba ya Mnungu, Umwo andaga akahiniza, wakulu wa Walava nt'hambiko ne wadala a vilongozi va want'hu wambasaga wakamuuza. “Wayadamanya aya kwa udahi waani? Naho niani akwink'hile udahi uwo?” ");
INSERT INTO ngp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu niyo awahitula, “Neniwauzeni nanywe mbuli imwenga, mna nihitula name neniwa gambileni, kugamba nadamanya aya kwa udahi waani. ");
INSERT INTO ngp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nigambileni, Ubatizi wa Yohana walawaga nahi? Walawaga kwa Mnungu, hegu walawaga kwa want'hu?” Watalaulaga woho kwa woho kugamba, “Nekigeeze? Uneva kinagamba, ‘Ulawa kwa Mnungu,’ naakiuze kugamba, ‘Nii hamumhuwile mhuwile Yohana?’ ");
INSERT INTO ngp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mna naho kinagamba, ‘Ulawa mwa want'hu,’ chogoha want'hu Kwaviya wose nawamanya kugamba Yohana andaga mlotezi ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ivo niyo wamhitula kugamba, “Hakimanyize” Naye Yesu niyo awagamba, “Name heniwagambileni kugamba nayadamanya aya kwa udahi waani.” ");
INSERT INTO ngp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mwafanyanya vihi mwe mbuli ino? Kwandaga na mnt'hu andaga na wanawe waidi wa kilume, niyo ambasa wa nk'hongo na kumgamba, ‘Mwanangu, uite ukadamanye ndima kwe nk'honde ye mizabibu dielo.’ ");
INSERT INTO ngp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yudya mwana niyo ahitula kugamba, ‘Hikuunga,’ mna akajika niyo afanyanya vint'hu niyo aita. ");
INSERT INTO ngp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Niyo Tati ya mnt'hu ambasa yudya mtuhu niyo amlonga enga iviya alongile kwa ywa nk'hongo. Yudya mwana niyo agamba, ‘Tate neniite,’ mna niyo haitile. ");
INSERT INTO ngp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mwa waidi awa, niani adamanye yadya aungile tati yawe?” Niyo wahitula, “Ni yudya ywa kaidi.” Yesu niyo awagamba, “Nawagambilani ikindedi, wagwila kodi na mapamp'he nawawalongoeleni kwo Useuta wa Mnungu, ");
INSERT INTO ngp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","kwaviya Yohana awezilagani niyo awalagisani zisila ze kindedi mna hamwamtegelezaga, mna wagwila kodi na mapamp'he nawamwiva niyo wamhuwila. Mna nyuwe hamwenga no ukuyaona aya hamuungile kweiila no kumhuwila.” ");
INSERT INTO ngp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu niyo agamba, “Tegelezeni mliganyizo mtuhu.” “Kwandaga na mnt'hu mta nk'honde yakwe, ahandaga mizabibu, niyo aizengela gomela, niyo asimba bome dyo kuhondela no kuzenga hant'hu henuke hakumvikila Mnungu cho wamizi, niyo awiikiza kwa walimi wamwenga, niyo yehe atamba. ");
INSERT INTO ngp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Msimo wo kuvuna uze ubuze, atumaga wandima wakwe kwa wadya waikizilwe, wakamguhile amaliho yakwe. ");
INSERT INTO ngp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wadya walimi niyo wawagwila wandima wadya yumwenga wamtoa, yumwenga wamkoma, yudya ywa katatu niyo wamtowa na maiwe. ");
INSERT INTO ngp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mna niyo egala wandima watuhu kwao, wasumpule uwingi kujink'ha wadya wa bosi. Mna naho wadya walimi niyo wawatendela viihile enga wadya wa nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kwo mzigilizo amwigalaga mwanawe mwenye kwawo akagamba, ‘Mafani wadaha kumwogoha.’ ");
INSERT INTO ngp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mna wadya walimi weze wamuwone umwana, niyo wagambilina kugamba, ‘Mlisi keza, nekimkomeni kiguhe ikipe chakwe.’ ");
INSERT INTO ngp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ivo niyo wamgwila no kumduula kuse ye nk'honde ye mizabibu, niyo wamkoma.” ");
INSERT INTO ngp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu niyo wauza, “Haluse zumbe wo mgunda we mizabibu akeza naawatende vivihi walimi ao?” ");
INSERT INTO ngp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Niyo wahitula, “Naawakome nao wadya wahi, niyo umgunda wakwe we mizabibu nawaikizile walimi watuhu.” ");
INSERT INTO ngp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu niyo awauza, Togoleni hamnati msome ivo viwandikwe mwa mawandiko? Iwe diya wazesi wadilemele, dinda iwe dikuungiswa. Zumbe niye adamanye ivo, naho ni mbuli ya kwehela mwa meso yetu. ");
INSERT INTO ngp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu niyo agendeela kulonga, “Naivo nawagambilani,” “nomhokigwe Useuta wa Mnungu niyo wenk'hwa want'hu wakudamanya ayedi.” ");
INSERT INTO ngp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Akuunga agwe mwe diiwe idyo naavunike vunike, uyo nedimgwele nedimtigint'he ande luvumbi. ");
INSERT INTO ngp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wakulu wa walava nt'hambiko na Mafalisayo weze weve miliganyizo ya Yesu, niyo wabunk'hula kugamba nakawalonga woho, ");
INSERT INTO ngp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","wazungulaga ubala wakumgwila, mna wandaga wakogoha umdugano, Kwaviya want'hu wamanyaga kugamba Yesu ni mlotezi ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu nakawenk'ha mliganyizo mtuhu akawagamba, ");
INSERT INTO ngp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Useuta wa kulanga wakeiga ivi. Kwandaga na zumbe yumwenga amfunganyilaga mwanawe kilume wila wa ndoza. ");
INSERT INTO ngp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Atumaga wandima kwa wose wadya walalikagwa kwe ndoza wakawetange, mna wadya walalikwe walemelaga. ");
INSERT INTO ngp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Niyo naho atuma wandima watuhu no kuwagamba, Wagambileni wose wadya walalikwe kugamba, ‘Hikeika lumwe fugo yangu, naho hifunganya kila kigimbale na nk'hande zangu, hifunganya kila kint'hu. Soni kwe fugo!’ ");
INSERT INTO ngp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mna wadya walalikwe hawaone kugamba ni kint'hu, niyo wakeagala, yumwenga kwe nk'honde, yumwenga naye kwo uchuuzi wakwe, ");
INSERT INTO ngp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","wamwenga niyo wawagwila wadya wandima watumigwe, niyo wawatenda vihile no kuwakoma. ");
INSERT INTO ngp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yudya zumbe ahigagwa, niyo egala wank'hondo wakwe, niyo wakuwakoma wakomi wadya no kuutimp'ha moto umzi wawe. ");
INSERT INTO ngp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Niyo awagamba wandima wakwe, ‘Fugo ye ndoza ibula, mna wadya walalikwe hawaungile ukwiza. ");
INSERT INTO ngp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iteni kwezi sila mp'handa, walalikeni wose mkuunga muwabwiile, weze kwe ndoza.’ ");
INSERT INTO ngp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Wandima wadya niyo waita kwe zisila zink'hulu, niyo wawaduganya want'hu wose wawaone, awavu na awedi, ndoza niyo yamema want'hu. ");
INSERT INTO ngp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mna zumbe eze engile, kuwakaula wageni, niyo kwanda na yumwenga hevaile suke yo kuitila kwe ndoza? Mna uyo mnt'hu hahitule dyodyose. ");
INSERT INTO ngp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Niyo amuuza, ‘Mbuyangu kwingila vivihi aha hwiina suke ya kuvaligwa mwe ndoza?’ ");
INSERT INTO ngp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yudya zumbe niyo awagamba wandima wakwe, ‘Mkakeni viga ne mikono mkamduule kuse ko lwiza. Uko nokunde na ndilo no kugwegwejula meno.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu niyo abindiliza akagamba, “Kwaviya wetangwe wabinda ingi, mna wasagulwe wageke.” ");
INSERT INTO ngp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mafalisayo waitaga kuse wakaika mizungu na kumtegela Yesu vileke wamgwile mwe milosi yakwe. ");
INSERT INTO ngp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Niyo wawatuma wanamp'hina wawe na hamwenga na kafyo kakwe Mahelode kwa Yesu, niyo wamgamba, “Mhinizi,” “kimanya kugamba weye u mnt'hu ywedi, naho wahiniza mbuli ya Mnungu mwe ikindedi, naho hukogoha ukulu wo mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Elo ukigambile weye, waona vihi, ni vedi kumliha kodi uyu Seuta ywe Kilumi hegu vihi?” ");
INSERT INTO ngp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mna Yesu niyo abunk'hulaga fanyanyi zawe ziihile niyo awagamba, “Nyuwe watondwe! Nii mwanigeza? ");
INSERT INTO ngp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nilagiseni ihela ikulihila ikodi” Niyo wamwink'ha, ");
INSERT INTO ngp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Niyo awauza, “Ifuta imwe ihela yaani? Zina idi dyaani?” ");
INSERT INTO ngp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Niyo wamhitula kugamba, “Va Seuta ywa Kilumi.” Niyo awagamba, “Mwink'heni Seuta ywa Kilumi viya vimuwagile, viya viwagile Mnungu navo mwink'heni Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Weze weve uhituzi wakwe, weheelagwa, niyo wahalawa. ");
INSERT INTO ngp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dizuwa idia Masadukayo wadya wakugamba hokunde no kuuyuka, wezaga kwa Yesu niyo wamuuza. ");
INSERT INTO ngp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wakagamba, “Mhinizi, Musa agambaga, uneva mnt'hu anabanika heina mwana kwa mkaziwe, nduguye amlombe mvele uyo vileke amwelekele wana. ");
INSERT INTO ngp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Haluse wandaga uko wandugu mfungate wekalaga aha, ywa nk'hongo alombaga, mna niyo abanika, mna kwaviya helekaga, mkaziwe aguhagwa ni nduguye. ");
INSERT INTO ngp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Vandaga kwa ywa kaidi na wakatatu, viita ivo vibuile mwa ywa mfungate. ");
INSERT INTO ngp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ko mzigilizo, yudya mvele naye niyo abanika. ");
INSERT INTO ngp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Haluse kigambe mwe dizuwa dyo kuuyuka, mvele yudya naande ywaani, Kwaviya nakalombigwa ni wagosi mfungate?” ");
INSERT INTO ngp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu niyo awahitula, “Mna malema, kwaviya hamuyamanyize mawandiko yakukile, no udahi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwaviya, umwo want'hu wabanike wakauyuka, hokunde na kulomba hegu kulombigwa, kwaviya want'hu nawande enga watumigwa wa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mna imbuli yo kuuyuka, hamsomile ivo Mnungu awagambileni, ");
INSERT INTO ngp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Miye ni Mnungu ywa Ibulahimu, Mnungu ywa Isaka, Mnungu ywa Yakobo.’ Ni Mnungu ywa wagima, hiye Mnungu ywa wabanike.” ");
INSERT INTO ngp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Idifyo dya awant'hu dize dive viya, niyo dyeehelwa ukuhiniza kwakwe. ");
INSERT INTO ngp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo weze weve kugamba Masadukayo waswesa dyo kumuuza Yesu, Mafalisayo niyo wekala hamwenga, ");
INSERT INTO ngp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","yumwenga mwa woho mhinizi we sigilizi, niyo amuuza Yesu akamgeza, ");
INSERT INTO ngp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mhinizi,” “Mwiko mkulu ni uhi?” ");
INSERT INTO ngp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu niyo ahitula, “ ‘Umuunge Zumbe Mnungu ywako kwo moyo wako wose, no kwo unt'hu wako wose, no kwo ubala wako wose.’ ");
INSERT INTO ngp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ino niyo umwiko mkulu nayo niyo ya nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nayo iyuko miko kaidi, ikugamba, ‘Umuunge miyao enga viya ukukeunga we mwenye.’ ");
INSERT INTO ngp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Zisigilizi izi zimbuli ziduganya miko yose na mahinizo ya walotezi.” ");
INSERT INTO ngp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Aho Mafalisayo weze wadugane, Yesu niyo awauza, ");
INSERT INTO ngp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwaona vihi mwe mbuli ya Kilisito? Ni mwana ani?” Niyo wamgamba, “Mwana Daudi.” ");
INSERT INTO ngp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Niyo naho awauza, “Vinda vivihi elo mwa Muye ywa Mnungu, Daudi akamwitanga ‘Zumbe?’ Kwaviya agambaga, ");
INSERT INTO ngp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Zumbe nakamgamba Zumbe ywangu, wikale kulume kwangu mpaka aho neniwaike wank'hondo wako hasi ye iviga vako.’ ");
INSERT INTO ngp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Elo haluse Daudi akamwitanga ‘Zumbe’ vanda vivihi naho Kilisito Mkombozi ande Mwanawe?” ");
INSERT INTO ngp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hahandile na yeyose, ahitulaga mbuli hegu mnt'hu yeyose kugeza kumuza mbuli yoyose kukongela zuwa diya. ");
INSERT INTO ngp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Niho Yesu alongaga na want'hu na wanamp'hina, ");
INSERT INTO ngp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Awagamba, “Wahinyi we Zimiko hamwenga na Mafalisayo wana udahi wa kuhiniza mahinizo ya Musa. ");
INSERT INTO ngp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ivo elo vaunga muyatoze no kuyadamanya yose yadya wakuwagambilani, mna mse kutimila mwa yadya wakudamanya, Kwaviya hawakudamanya enga viya wakubilikiza. ");
INSERT INTO ngp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Woho wakaka madondolo makulu niyo wayahasikiza mwa maega ya want'hu, mna woho wenye hawakuunga hata kuikwafa ne nividole vawe kuwambiza. ");
INSERT INTO ngp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yose wakuyadamanya waungisa watogolwe ni want'hu, wagalamula mapingu yawe no kugenyeza mnengesuke zawe zint'hali. ");
INSERT INTO ngp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Waungisa kwikala mwo fumbi wa kulongole, mwe midugano yo ludyo, na mwe zinyumba za kulombezela Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mwaungisisa kulamswa mwa magwilo no kwitangwa Mhinizi. ");
INSERT INTO ngp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mna nyuwe msekwitangwa ‘Mhinizi,’ Kwaviya Mhinizi ywenyu ni yumwenga nanywe mwi wandugu. ");
INSERT INTO ngp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Naho msekumwitanga yoyose aha he isi ‘Tate’ Kwaviya Tati yenyu ni yumwenga ekulanga. ");
INSERT INTO ngp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Naho msekwitangwa vilongozi, Kwaviya akuwalongoelani nyuwe ni yumwenga akwitangwa Kilisito Mkombozi. ");
INSERT INTO ngp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Umkulu umwenyu aungwa ande mndima ywenyu. ");
INSERT INTO ngp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kwaviya yeyose akukekweza, nakulumulwe, yudya nae akuke kulumula, naakwezigwe ni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Hangi nyuwe wenye wahinizi we miko na Mafalisayo! Watondwe nyuwe! Mkuwavugaila want'hu Useuta wa kwe mbingu, mna nyuwe enye hamkwingila, hamkuwenk'ha sila wakuunga kwingila. ");
INSERT INTO ngp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Hangi nyuwe wenye wahinizi we zi miko na Mafalisayo! Mkudya nyumba za wadya wabanikilwe ni walume zawe, naho kwa utondwe, mwaketenda kulonga mabuli mengi na mengi mo kumvika Mnungu! Kwaivo nomsulumizwe masulumizo makulu. ");
INSERT INTO ngp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Hangi nyuwe wenye nyuwe wahinizi we Miko na Mafalisayo! Nyuwe watondwe! Mkuzunguluka mwe isi na mwe ibahali no kumtenda mnt'hu yumwenga kunda enga ivo nyuwe mkuhuwila, naho mkajika mwamtenda kunda mwana wa mo moto houkuzima wa ulo na ulo kuwajink'ha nyuwe wenye ivo mwili! ");
INSERT INTO ngp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Hangi nyuwe wenye vilongozi mant'hunt'hu! Mwahiniziza kugamba, ‘Uneva mnt'hu anakwelisila mwe Nyumba ya Mnungu, hicho kint'hu, mna mnt'hu anakwelisila kwe izahabu ye inyumba ya Mnungu, naande kakegwila mwenye.’ ");
INSERT INTO ngp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mant'hunt'hu wahezi nyuwe! Ni ihi ink'hulu, izahabu hegu Inyumba ya Mnungu ikugela kilingo kinde kikukizwe? ");
INSERT INTO ngp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Iviya iviya, mwagamba, ‘Uneva mnt'hu akwelisila hekilingo cha kulavila nt'hambiko hi kint'hu, mna akwelisila kint'hu kilavigwe mnanga mwe kilingo cho kulavila nt'hambiko naande kakegwila mwenye.’ ");
INSERT INTO ngp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nyuwe want'hu mant'hunt'hu! Ni ihi ink'hulu, ni malavo hegu kilingo cha kumvikila Mnungu kikukukiza malavo? ");
INSERT INTO ngp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ivo elo akwelisila hekilingo hakumvikila Mnungu cha Mnungu, akelisa mwe icho na malavo yose yemwe hant'hu henuke hakumvikila Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Naho akwelisila Nyumba ya Mnungu, akelisa kwe iyo hamwenga na Mnungu wenye akwikala uumo. ");
INSERT INTO ngp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naho akukelisila kulanga, akelisa ukalo wa Mnungu no umwenye akwikala uumo. ");
INSERT INTO ngp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Hangi nyuwe wenye wahinizi we Miko na Mafalisayo! Watondwe! Mwalava zaka ze zimboga za mani na bizali, ne jila, mna mleka kutimila zimbuli zink'hulu zisiigilwe, zo utondowazi na mbazi no uhuwilwa. Zimbuli izi zink'hulu mwaungwa mzi damanye, haheina kuyajala ayo matuhu. ");
INSERT INTO ngp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vilongozi mant'hunt'hu! Mwatuja mbu mna mwamela mp'hunda! ");
INSERT INTO ngp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Hangi nyuwe wenye wahinizi we Miko na Mafalisayo! Nyuwe watondwe! Mwasunt'ha viyamp'ha ne vihungu kwa kuse, mna kundani kumema yadya myalavile kwo kuwahoka want'hu no ugila. ");
INSERT INTO ngp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nyuwe Mafalisayo mant'hunt'hu! Indeni kusunt'ha kundani ye viyamp'ha ne vihungu, niho kuse nako kunde kusunt'hika! ");
INSERT INTO ngp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Hangi nyuwe wenye wahinizi we zimiko na Mafalisayo! Mkeiga vikuta vikakigwe, ukavikaula kwa kuse kunda viwakigwa, mna kwa kundani vimema want'hu wabanike, mavuha na nt'hagant'ha zose. ");
INSERT INTO ngp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Enga ivo kwa kuse mwa kaulwa kunda want'hu wedi, mna kwa kundani mmema utondwe no wavu. ");
INSERT INTO ngp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Hangi nyuwe wenye wahinizi vilongozi we miko na mafalisayo watondwe! Mwazenga vikuta va walotezi wa Mnungu no kutuluma vikuta va wawagile Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Naho mwagamba vandile chandaga uuko, aho watati zetu, hegu hamwandile hamwenga mwo kuwakoma walotezi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ivo elo mwalonga uwona nyuwe wenye kugamba ni nyuwe mwelekwe kwa wadya wose wawakomaga walotezi wa Mnungu! ");
INSERT INTO ngp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gendeeleni elo, vileke mkomeleze kiya wakongaga watati zenyu! ");
INSERT INTO ngp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mazoka nyuwe naho cheleko cha mazoka! Msekugamba nomkehonye no usengelo wo kugeligwa ko moto houkuzima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Haluse nawegailani naho walotezi wa Mnungu, want'hu wano umanyi wa Mnungu, na wahiniza Miko. Naho wawenga nomuwakome, wamwenga nao nomuwagele mwe viwambilo, wamwenga nomuwabunt'he mwe nyumba zenyu zo kuvikila, wamwenga nomuwaguluse kulawa mzi umwenga kuita mzi mtuhu. ");
INSERT INTO ngp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Naho niyo isakame ya wose wawagilwe ni Mnungu idya itike, neinde umwenyu, kukongela ya Habili mpaka ya Zakalia mwana Balaki, Zakalia mwamkomaga hagati ye Nyumba ya Mnungu na hekilingo hokumvikila Mnungu malavo. ");
INSERT INTO ngp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nawagambilani kindedi, maliho yo ukomi uno wose nayande mwa want'hu wa mazuwa aya. ");
INSERT INTO ngp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ho! Yelusalemu, Yelusalemu! Weye ukuwakoma walotezi wa Mnungu na kuwatoa maiwe wadya watumigwe kwako ni Mnungu! Kengahi niungile kuwaduganya hamwenga awanao, enga viya nguku ikuwaduganya wakinda wakwe mwa amawawa yakwe mna haviungile! ");
INSERT INTO ngp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaula elo nyumba yako neilekigwe hame. ");
INSERT INTO ngp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nakugambilani, kukongela ivi haluse na kugendeela, hounione miye naho mpaka hadya nomgambe, ‘Kavikilwa yehe akwiza kwe dizina dya Zumbe.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Umwo Yesu andaga akahalawa he Nyumba idya ya Mnungu, wanamp'hina wakwe wamwitangaga vileke akaule mzengo we Nyumba ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Niyo awagamba, “Kindedi aya yose myakaule vedi. Nawagambilani kindedi, hedisigale iwe mnanga mwo miyawe, yose nayamogoelwe hasi.” ");
INSERT INTO ngp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Umwo Yesu andaga ahumule ko lugulu lwe Mizeituni, wanamp'hina wakwe wamwiizilaga kinyele wakamgamba, “Kigambile, aya ulongile nayalaile ini naho ni kilagiso chani kugamba weye weza, nokubindilikila kwe isi?” ");
INSERT INTO ngp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu niyo ahitula, “Msinyise, yeyose ase kuwadant'hiliza. ");
INSERT INTO ngp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwaviya naweze wabindile ingi kwa zina dyangu, wakagamba kila yumwenga niye Kilisito! Naho nawawadant'hilize want'hu wengi. ");
INSERT INTO ngp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nomwive nk'hondo na nt'hegelezi za nk'hondo. Mkaulise, msekwituka kwaviya ayo hayaleke kulaila, mna hokunde nuko kubindilikila kwe isi. ");
INSERT INTO ngp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Isi na isi nezitoane, useuta nao kutoana na uzumbe mtuhu, nokunde na magumbo, na visingisa kila hant'hu. ");
INSERT INTO ngp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yose aya nayande enga nk'hongelo ya kulumwa usungu wa mvele kwingila nyumba. ");
INSERT INTO ngp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nanywe nawawagwileni no kuwasezenga mtendelwe yaihile, na kuwakoma, naho want'hu we isi zose nawawa ihieni, kwaviya mwanitimila miye. ");
INSERT INTO ngp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aho naho want'hu wengi nawahituke, naho nawa sezengane, naho nawaihiyane. ");
INSERT INTO ngp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Naho walotezi wengi wo udant'hi na walaile nokudant'hiliza want'hu wengi. ");
INSERT INTO ngp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Naho Kwaviya wavu nougenyele, lukunde kunde lwa want'hu no luhole. ");
INSERT INTO ngp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mna yudya mnt'hu akuunga afinyilize niyo abinda int'hambo niye akuunga ayokolwe. ");
INSERT INTO ngp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Naho Mbuli Yedi ya useuta wa Mnungu neibilikizwe enga ulonga uwona kwa isi zose niho kubindilikila kwe isi nokwize. ");
INSERT INTO ngp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Aho nomuwone Dikuihiza dikubananga dikimala hakukile ha Mnungu, idyo alongaga mlotezi Danieli.” Wakusoma nawa kombaganye. ");
INSERT INTO ngp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Niho wose we mwe isi ya Yuda, wanyilikile kwe vigulu. ");
INSERT INTO ngp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mnt'hu ekwe digulu dye nyumba yakwe asekuseela aguhe vint'hu vimwe nyumba. ");
INSERT INTO ngp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Naho mnt'hu ekwe nk'honde, asekuuya na nyuma kuguha suke yakwe. ");
INSERT INTO ngp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Makunt'ho makulu ni kwa wadya awabovu na wadya wakonk'heza mwa mazuwa ayo. ");
INSERT INTO ngp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lombezeni Mnungu kugamba nguluko zenyu zisekunda mwe dizuwa dya mp'heho, naho disekunda mwe dizuwa dya kuhumula. ");
INSERT INTO ngp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwaviya nokunde na makunt'ho makulu heyenati kulaila kukongela kwo kuumbwa isi, kubula ivi haluse, naho heyeze yalaile vituhu. ");
INSERT INTO ngp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Naho vandile Mnungu hahungule mazuwa ayo, hegu hakwahonile mnt'hu yeyose, mna kwaviya weyuko wasagulwe, Mnungu naayahungule mazuwa ayo.” ");
INSERT INTO ngp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Naho aho mnt'hu akakugamba, ‘Kaula, Kilisito eyuku!’ Hegu wakagamba, ‘Ehadya!’ Msekuhuwila. ");
INSERT INTO ngp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwaviya nawalaile wakina Kilisito wo udant'hi na walotezi wa udant'hi, naho nawadamanye vihungi vikulu na mbuli za kwehela, vileke wawazaganye want'hu, vika dahika ni hamwenga na wadya wasagulwe ni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Elo msinyise! Hiwagambilani kale yakwiza kulongole. ");
INSERT INTO ngp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hegu, yeyose akuwagambani, ‘Kauleni ekwe nyika!’ Msekuita, hegu du akuwagambani, ‘Kauleni e yuku kwe nyumba!’ Mse kumhuwila. ");
INSERT INTO ngp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Saviya lumwemwe lukudaha kulaila ulailo wa zuwa, niyo lwaonwa usweelo wa zuwa, nivo vikuunga vinde ukwiza kwa Mwana Mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kwaviya hohose hakuunga hande ne kimba, ndege nyika naho nezidugane. ");
INSERT INTO ngp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Aaho mazuwa ya makunt'ho yakeza kwomboka, zuwa nedigelwe lwiza naho umnenge nao houng'ale, nt'hondo nazo nezigwe kulawa kulanga, naho udahi wa kwe mbingu nousingisike. ");
INSERT INTO ngp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Niho nokuonekele vilagiso va Mwana Mnt'hu akalaila mo ulanga, naho want'hu wose weisi nawahongeze no kuila aho wakeza kumuwona Mwana Mnt'hu akeza mwa mavunde ya kwe mbingu na udahi no uwedi utendese. ");
INSERT INTO ngp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naawatume watumigwa wakwe hamwenga na izwi kulu dye digunda, naho waduganywe wasagulwa wakwe kulawa nt'hendelo izine ze isi, kukongela uheelo umwenga we isi, kuhinga uheelo mtuhu. ");
INSERT INTO ngp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Elo kwe diziti dikwitagwa mtini, kehinizeni mliganyizo. Aho mkaona amatambi yakwe yadakila no kulava mani mahya, manyeni kugamba uvuni uhagihi. ");
INSERT INTO ngp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Enga iivo, mneza kuyaona aya yose, manyeni kugamba Mwana Mnt'hu ehagihi kwiza. ");
INSERT INTO ngp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nawagambilani ikindedi, cheleko iki hekidahe komboka, mpaka vint'hu ivi vose vilaile. ");
INSERT INTO ngp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ulanga ne isi nevomboke, mna milosi yangu heyomboke. ");
INSERT INTO ngp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Hahali mnt'hu yoyose amanyize zuwa hegu sa, hi mtumigwa ywa kwe mbingu, hegu Mwana mwenye. Haheina yeyose, Tate ekedu niye amanyize. ");
INSERT INTO ngp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Enga viya vandaga mwe dizuwa dya Nuhu, nivo nevinde ukwiza kwa Mwana Mt'hu. ");
INSERT INTO ngp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwaviya mwa mazuwa yalongoele ugubiko wa mazi, want'hu wandaga wakanywa no kudya, kulombigwa no kulomba, kubula mwe dizuwa diya Nuhu engile mwe ngalawa, ");
INSERT INTO ngp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","naho hawamanyaga kint'hu chochose chadahaga kulaila, mpaka hadya wezile kukebwiila wose wagubikwa pele na mazi. Ivi nivo vikuunga vinde imiziile ya Mwana Mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Want'hu waidi nawande henk'honde, yumwenga na aguhigwe yumwenga naasigwe. ");
INSERT INTO ngp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wavele waidi nawande wakasigint'ha, yumwenga na aguhigwe yumwenga naasigwe. ");
INSERT INTO ngp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ivo mnde meso kwaviya hammanyize aho neezile Zumbe ywenyu. ");
INSERT INTO ngp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mna mmanye kugamba, yandile mta nyumba amanyize kilo kihi mbavi neezile, hegu nakekala meso no kuyamila inyumba yakwe isekumoligwa. ");
INSERT INTO ngp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Naivo elo, weye nawe wikale meso, Kwaviya Mwana Mnt'hu naakwizile hadya hwi kawiile. ");
INSERT INTO ngp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Niani elo mtumwa ywedi mhuwilwa akuzumilwa ni Zumbe ywakwe, vikutenda aikwe kunda mkulu mwa wandima watuhu, naho awenk'he nk'hande wandima weyawe kwa hadya hakuungwa?” ");
INSERT INTO ngp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nevinde vedi ko mtumwa enga uyo akuunga abwiilwe ni Zumbe dyakwe akadamanya ivo Umwo akauya. ");
INSERT INTO ngp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nawagambilani ikindedi, naa muike kunda mkulu wo ugoli wakwe wose. ");
INSERT INTO ngp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mna mtumwa yudya aihile, alonga momoyo wakwe mwenye kugamba, Zumbe hakusunguza kwiza, ");
INSERT INTO ngp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","naho niyo akonga kuwatoa wandima weyawe na kudya no kunywa hamwenga na wakozi. ");
INSERT INTO ngp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Niho Zumbe ywakwe umtumwa uyo naauye zuwa dimwenga hewe kawiile wandima awo. ");
INSERT INTO ngp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na amsulumize vitendese na kumwiika hamwenga na watondwe, nuko nokunde ndilo no kugwegwejula ameno. ");
INSERT INTO ngp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Naho, Useuta wa kulanga nounde enga ivi. Wali mlongo waguhaga vimuli vawe niyo wagenda kumhokela mlombi. ");
INSERT INTO ngp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Washano mwa ao wandaga wahezi, washano watuhu wandaga wabala. ");
INSERT INTO ngp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Wadya wahezi waguhaga vimuli vawe, mna hawaguhile hamwenga na mavuta ya kongezela. ");
INSERT INTO ngp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mna wadya wabala vandaga wakeikila mavuta mnenge shupa zawe yo kugela mwe vimuli vawe. ");
INSERT INTO ngp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mlombi uyo hasunguzaga kwiza, vilekile wose wakupile niyo wagona nt'hongo. ");
INSERT INTO ngp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mna ize ibuze kilo cha gati want'hu niyo wakonga kwanga, ‘Mlombi keza! Mwinuke mumhokele!’ ");
INSERT INTO ngp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wadya wali niyo wenuka woseni no kuvidamanya vimuli vawe. ");
INSERT INTO ngp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wadya wahezi niyo wawagamba wadya wabala, ‘Kink'hageni mavuta ludodo, vimuli vetu vazima.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wadya wabala niyo vawagamba, ‘Bule! Haya kikint'he choseni nyuwe na suwe. Iteni kwe duka mkakeguile.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mna Umwo wandaga wakaita kokugula mavuta, mlombi niyo engila, wadya wali wakeikilaga lumwe niyo wengilanya no mlombi kwe ndoza, ulwivi niyo lwavugalwa. ");
INSERT INTO ngp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Halongole, wadya watuhu nawo niyo weza wakagamba, ‘Zumbe! Zumbe! Kikomoele!’ ");
INSERT INTO ngp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Zumbe niyo awahitula, ‘Nawagambilani ikindedi, hiwamanyizeni.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu niyo abindiliza kwa kugamba, “Elo indeni meso kwaviya hammanyize kwizilwa kwenyu nokunde ni ini! ");
INSERT INTO ngp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Naho Useuta wa kulanga noukeige na mnt'hu akuita utafi awetange wandima wakwe niyo awatenda wakaulizi mwo ugoli wakwe wose. ");
INSERT INTO ngp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Awenk'haga kila yumwenga enga viya adahile. Yumwenga kaikizilwa matundu mashano, yumwenga kaikizilwa matundu maidi, nt'huhu kaikizilwa dimwenga, kila yumwenga viligane no ludole lwakwe. Niyo yehe akeitila kwo utafi wakwe. ");
INSERT INTO ngp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yudya enk'higwe matunt'hu amashano, niyo akuyadamanyila ndima, niyo elesa mashano matuhu. ");
INSERT INTO ngp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yudya ahokele amatundu maidi, yehe naye niyo elesa matundu maidi matuhu. ");
INSERT INTO ngp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mna yudya ahokele tundu dimwenga, aitaga niyo adisimbila hasi no kudifisa hasi ditundu dyo mkulu ywakwe. ");
INSERT INTO ngp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Yeze yomboke mazuwa mengi, zumbe wa wandima wadya wose auyaga, niyo wekala wakatalaula hamwenga na wandima wakwe yadya awasile. ");
INSERT INTO ngp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mndima yudya ahokele matundu mashano, kegala matuhu mashano, akamgamba mkulu wakwe, ‘Mkulu waikizaga kwangu, matundu mashano.’ ‘Kaula! Hongeleza mashano matuhu.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mkulu wakwe niyo amhitula, ‘Kutenda vedi mtumwa ywedi, kunda mhuwilwa mwe vint'hu vigeke, nohuike kunda mkulu mwe vint'hu vingi. Naho nou unde hamwenga no mkulu ywako mwe kinyemi chakwe.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Yudya ahokele matundu maidi naye niyo eza akamgamba mkulu ywakwe, ‘Waniikizilaga matundu maidi, kaula higenyeza matuhu maidi.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yudya mkulu niyo amhitula, ‘Kutenda vedi mndima ywedi naho mhuwilwa!’ ‘Kunda mhuwilwa kwe vint'hu vigeke, nohutende mkulu mwe vint'hu vingi. So kinde hamwenga mwe kinyemi changu!’ ");
INSERT INTO ngp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Niyo azigiila yudya ahokelega ditundu dimwenga, naye niyo amgamba mkulu ywakwe, ‘Himanya kugamba umnt'hu mdala, wavuna hadya hwitile mbeyu, naho waduganya hadya hwi myagile mbeyu. ");
INSERT INTO ngp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ivo nehyogoha niyo nagenda kudifisa ditundu dyako mwe sanga, kaula diaha diya idyako.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mkulu ywakwe niyo amhitula, ‘Weye undima wiihile naho umsokezi wa ndima! Ivo nivo umanyize kugamba navuna hadya hii handile, naho naduganya hadya hitile mbeyu? ");
INSERT INTO ngp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mna vedi hegu waikize ditundu dyangu kwe kindolo kikuliha mtendese, kugamba mokuuya kwangu hegu nehihokela hamwenga nomtendese. ");
INSERT INTO ngp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mhokeni ditundu, mmwink'he yudya mta mlongo. ");
INSERT INTO ngp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwaviya yeyose mtanacho naogenyezelwe no mtendese niyo vagenyela, mna yudya heiina, hata kiya kidodo ananacho naahokwe. ");
INSERT INTO ngp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naho mduuleni mtumwa mkiwa uyo kwo lwiza, nuko nokunde ndilo no kugwegwejula ameno.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Aho Mwana Mnt'hu akeza kwiza mwo wedi wakwe utendese, hamwenga na watumigwa wa kwe mbingu wose, neekale mwe difumbi dyo uwedi wakwe utendese. ");
INSERT INTO ngp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Want'hu wose mwe isi zose, nawaduganywe hamwenga, naho naawapagule enga viya mdimi akupagula zingoto mwe difyo dye zimbuzi. ");
INSERT INTO ngp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ngoto naayapaguile kulume kwakwe, zimbuzi naazipaguile kumoso kwakwe. ");
INSERT INTO ngp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Seuta naawagambe wadya wose wekulume, ‘Soni nyuwe mvikilwe ni Tate, guheni kipe chenyu, useuta mwaikilagwa lumwe kukongela aho nk'hongo ho kuumbigwa isi. ");
INSERT INTO ngp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwaviya nakeivaga sala niyo wanink'ha chokudya, nakeivaga nk'hilu, niyo mwanink'ha chokunywa, nandaga mgeni, niyo mwanitendela ukise. ");
INSERT INTO ngp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nandaga hisakaza niyo mwanink'ha suke, nandaga mnyonge niyo mweza kunikaula, nandaga mvugailwa kwe divugailo, niyo mweza kunitalamkila.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Niyo awedi hameso yo Mnungu wamhitula kugamba, ‘Zumbe, niini kikuone una sala niyo chakwink'ha nk'hande? Hegu naho kikuona ini una nk'hilu niyo chakwink'ha chokunywa? ");
INSERT INTO ngp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naho nekikuona ini kugamba weye wi mgeni niyo chakuhokela? Hegu kikuona hi usakaze niyo chakwink'ha suke? ");
INSERT INTO ngp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Chakuonaga hii umnyonge, hegu du ukwedivugailo niyo cheza kukutalamkila?’ ");
INSERT INTO ngp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Zumbe niyo ahitula kugamba, ‘Nawagambilani ikindedi, vovose viya mumdamanyile yumwenga mwa wadodo awa wandugu zangu, mnidamanyila miye.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Naho nawagambe wadya wekumoso kwakwe, ‘Halaweni aha hangu nyuwe mligitwe ni Mnungu, iteni mkengile ko moto wa ulo na ulo uikilwe lumwe Mwavu na watumigwa wakwe! ");
INSERT INTO ngp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nehinda na sala, hamnink'hile chokudya, nehinda na nk'hilu, hamnink'hile mazi ninywe, ");
INSERT INTO ngp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nandaga mgeni, hamnidamanyile ukise kwenyu, hisakaza, hamnink'hile suke, halumwa, naho nandaga hivugailwa kwe divugailo, hamwizile kunikaula. ");
INSERT INTO ngp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Niho nawo nawahitule, ‘Zumbe, niini kikuone weye una sala, nk'hilu, hegu niini ukiizile niyo chaswesa kukutendela ukise, naho kikuone usakaze, undile mnyonge, no kuvugailwa kwe divugailo, niyo kiswesa kukudamanyila uwedi?’ ");
INSERT INTO ngp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Niho Zumbe naawahitule, ‘Nawagambilani ikindedi, uneva hamuwambize yumwenga mwa awa wabeligwe, mlemela kunambiza miye.’ ");
INSERT INTO ngp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Niho nawaite kokulumizwa hokukusila, mna wazumilwe kunda wedi kwa Mnungu nawaite kwo ugima wa ulo na ulo.” ");
INSERT INTO ngp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu eze ajinke kuyalonga yose ayo, niyo awagamba awanamp'hina wakwe, ");
INSERT INTO ngp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Enga viya mmanyize kugamba, yasigala mazuwa maidi kulongole neinde kinyemi che Pasaka, naho Mwana Mnt'hu naagwiligwe naho na awambigwe mwo msalaba.” ");
INSERT INTO ngp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Naho wakulu wa walava nt'hambiko na wadala wa want'hu nawakint'hana kwe nyumba ya Mlava nt'hambiko mkulu, etangagwa Kayafa, ");
INSERT INTO ngp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","naho waikaga mzungu wa hamwenga wa kumgwila kwa kinyele Yesu no kumkoma. ");
INSERT INTO ngp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Niyo wagamba, “Isekunda mwedizuwa dya kinyemi, neinegale nk'humbizi mwa want'hu.” ");
INSERT INTO ngp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Umwo Yesu andaga Besania mwe nyumba ya mnt'hu yumwenga etangagwa Simoni, mnt'hu aho nk'hongo andaga akalumwa unyonge wa ukoma. ");
INSERT INTO ngp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ezaga mvele yumwenga andaga na kijaluba kimemile mavuta yana mhemp'he ya utana utendese, niyo amsogeela Yesu Umwo wandaga ho ludyo, no kumgidila mwo mtwi. ");
INSERT INTO ngp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wanamp'hina wakwe weze wayaone ayo niyo waihiwa, wakalonga mwe mioyo yawe kugamba, “Kwaza uku kwa mbwai?” ");
INSERT INTO ngp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mavuta aya yo mhemp'he hegu yatagigwe kwa utana utendese niyo amatundu wenk'hwa awakiwa. ");
INSERT INTO ngp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu eze ayamanye ayo, niyo awagamba, “Nii mwamsunk'ha sumka mvele uyu? Nakanidamanyila kint'hu chedi miye. ");
INSERT INTO ngp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Awakiwa mnanao mazuwa yose aha, mna miye nekinda wose mazuwa yose. ");
INSERT INTO ngp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ukunigela mavuta aya yo mhemp'he mwo mwili wangu, andaga aniikila lumwe kwa amazisi yangu. ");
INSERT INTO ngp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nawagambilani ikindedi, hohose Imbuli Yedi ya Mnungu neibilikizwe mwe isi yose, iki atendile ne kitambulwe kwa kumkumbukila.” ");
INSERT INTO ngp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yumwenga mwa wadya mlongo na waidi etangagwa Yuda Isikaliyote aitaga kwa wakulu wa walava nt'hambiko, ");
INSERT INTO ngp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","niyo awauza kugamba, “Nomnink'hei miye nna msezenga Yesu kwenyu?” Wamuwazilaga no kumwink'ha matunt'hu milongo mitatu. ");
INSERT INTO ngp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kukongela aho Yuda naakazungula luneka lwa kumsezengela Yesu kwawo. ");
INSERT INTO ngp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mwedizuwa dyank'hongo dye Mikate heigeligwe Ugwadu, wanamp'hina wezaga kwa Yesu na kumuuza, “Ni hii ukuunga kikaike lumwe kokudiila ludyo lwe Pasaka?” ");
INSERT INTO ngp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Niyo awahitula, “Iteni kwa mnt'hu yumwenga, niyo mwamgamba Mhinizi agamba, ‘Dizuwa dyangu dibula, naunga hadye Pasaka na wanamp'hina wangu mwe nyumba yako.’ ” ");
INSERT INTO ngp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wanamp'hina niyo watenda enga viya Yesu awasigiile, niyo waiikila lumwe uludyo lwe Pasaka. ");
INSERT INTO ngp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ize inde mwalagulo, Yesu nakekala yehe hamwenga na wanamp'hina wakwe mlongo na waidi ho ludyo. ");
INSERT INTO ngp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aho wandaga wakadya, agambaga, “Nawagambilani ikindedi, yumwenga mwa nyuwe naanisezenge.” ");
INSERT INTO ngp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Niyo wose wahuza kwa meso, niyo wakonga kulosanya wenye kwa wenye, kila mnt'hu no miyawe, “Zumbe ni miye hegu?” ");
INSERT INTO ngp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu niyo ahitula, “Yeyose yudya akuunga anatweeze hamwenga na miye mwe kihungu naani sezenge. ");
INSERT INTO ngp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana Mnt'hu naungwe ayombokele yadya yose awandikilwe mo Mawandiko Akukile, mna naaligitwe yudya mnt'hu akuunga ana msengeze Mwana Mnt'hu! Hegu nevinda vedi mnt'hu enga uyo andile helekwe!” ");
INSERT INTO ngp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Niyo Yuda, yudya akuunga anamsengeze agamba, “Mhinizi ni miye hegu?” Yesu niyo amhitula, “Heiye weye kulonga.” ");
INSERT INTO ngp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aho wandile wakadya Yesu na kaguha mkate, niyo atogola Mnungu, niyo aubendula no kuwenk'ha wanamp'hina wakwe akagamba, “Guheni mdye. Uno nuwo umwili wangu.” ");
INSERT INTO ngp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Naho niyo aguha kiamp'ha niyo alava nt'hogola no kuwenk'ha akagamba, “Nyweni nyose. ");
INSERT INTO ngp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ino niyo isakame yangu ye ndagano ikwitika kwa ajili ya want'hu wengi kwo kuusilwa wavu wawe. ");
INSERT INTO ngp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nawagambilani, heninywe naho mwe cheleko che zabibu, kukongela ivi haluse kubula mwe dizuwa umwo neninywe imp'yahamu hamwenga na nyuwe ko Useuta wa Tate.” ");
INSERT INTO ngp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Weze wabinde kukema wila niyo wafosa kuita kwo Lugulu lwe Mizeituni. ");
INSERT INTO ngp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Niho Yesu akawagamba, “Kilo cha dielo nomwiihiwe kwajili miye, Kwaviya nivo yawandikagwa, Mnungu kagamba, ‘Nenimtowe mdimi, niyo zingoto ze difyo dyakwe nezikepange.’ ");
INSERT INTO ngp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mna hezakwinuka kulawa mwe kikuta, neniwalongoleni kuita Galilaya.” ");
INSERT INTO ngp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulo niyo agamba, “Wose uneva nawa kunyilika mna miye hikuvitenda ivo.” ");
INSERT INTO ngp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu niyo amgamba, “Nakugambila ikindedi, Ikilo iki zogolo dikei kuila, nounde kunilemela nk'hana nt'hatu.” ");
INSERT INTO ngp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulo niyo agamba, “Uneva ni kukomwa hamwenga na weye nevinde iivo, mna hohuleke.” Niyo wanamp'hina wose walonga iivo. ");
INSERT INTO ngp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Niyo Yesu aita hamwenga na wanamp'hina wakwe, hant'hu hakwitangwa Getisemani, niyo awagamba wanamp'hina wakwe, “Hake ikaleni aha, miye niite halongole ludogo hamlombeze Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Niyo awaguha Petulo na watuhu waidi wana Zebedayo hamwenga na Yehe, niyo akonga kwingilwa ni kinyulu na kiyangayanga. ");
INSERT INTO ngp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Niyo awagamba, “Moyo wangu wingila kinyulu kwa usungu, hagihi no kubanika. Ikaleni aaha mnde meso hamwenga na miye.” ");
INSERT INTO ngp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Niyo aita halongole ludodo no kufunamiza uso hasi, niyo alombeza. “Tate, uneva vadahika ndima ino indala ikunizila niusile, mna hiyo viya miye huunga, nevinde enga viya uukunga weye.” ");
INSERT INTO ngp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Naho niyo auyaga kwa wanamp'hina wakwe, awabwiilaga wagona, niyo amuuza Petulo, “Nyuwe mdunduga kunda na miye hata kwa saa dimwenga du? ");
INSERT INTO ngp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Indeni meso, naho mlombeze Mnungu mnase kwingila mo kugezigwa. Moyo wa mnt'hu waungisa kudamanya vedi mna umwili uhwa.” ");
INSERT INTO ngp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu afosaga kaidi kulombeza Mnungu akagamba, “Tate, ivi havikudahika imbuli ino inombokele kunk'handa mpaka inibwiile? Mna nevinde enga viya uungile weye.” ");
INSERT INTO ngp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eze awauiye vituhu, awabwiilaga wagona, kwaviya meso yawe nayanda yazama. ");
INSERT INTO ngp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Awasaga niyo aita naho katatu komlombeza Mnungu akavuzagiza ulosi uudya. ");
INSERT INTO ngp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Niyo auya kwa wanamp'hina wakwe awagamba “Mkei gonile? Kauleni, sa ibula yo Mwana Mnt'hu kugeligwa mwe mikono ya want'hu wavu. ");
INSERT INTO ngp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Inukeni, kiteni kwaviya yudya akunisezenga keza!” ");
INSERT INTO ngp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Umwo andile akagendeela kulonga, Yuda, yudya yumwenga wawadya mlongo na waidi ezaga hamwenga na fyo dya want'hu wavaile kink'hondo wenule mijungo, hamwenga na malungu. Nawatumigwa wa kwe mbingu ni wakulu wa walava nt'hambiko na wadala vilongozi wa want'hu. ");
INSERT INTO ngp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Naho yudya umsezengi nakawenk'ha kilagiso akawagamba, “Mnt'hu uyo huunga nimnamse kwa lukunde, nuuyo, mgwileni.” ");
INSERT INTO ngp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Niyo aita ludole kwa Yesu, niyo amlamsa “Mhinizi, ndamsa!” Niyo amnonela. ");
INSERT INTO ngp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu niyo amgamba, “Mbuyangu damanya idya ikutendile wize.” Niyo wamkumpukila Yesu, niyo wamgwila. ");
INSERT INTO ngp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yumwenga mwa wanamp'hina wa Yesu andaga na gola dyakwe mwe yala, niyo adisomola nokumtoa niyo amsenga digutwi mtumwa wo Mkulu ywa walava nt'hambiko. ");
INSERT INTO ngp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu niyo amgamba mwanamp'hina ywakwe, “Vuza digola mwe yala yakwe, kwaviya kila akukoma kwa gola naakomwe kwa digola. ");
INSERT INTO ngp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hamamanyize kugamba miye nadaha kumloeza Tate, niyo anigaila mafyo yakujink'ha mlongo na maidi ya mtumigwa ywa nk'hondo haluse ivi? ");
INSERT INTO ngp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mna Mawandiko Akukile udya ukugamba, vaungwa aya yose kulaila, noukint'he vivihi?” ");
INSERT INTO ngp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aho Yesu awauzaga wadya wezile kumgwila, “Nyuwe mwiza na magola na malungu vileke mnigwile, mazuwa yose nehinda mwe nyumba ya Mnungu hahiniza, mna hamwanigwilaga du! ");
INSERT INTO ngp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mna aya yose yalaila vileke yadya yawandikwa na walotezi wa Mnungu yakint'he.” Niho wanamp'hina wakwe wanyilika no kunyilika. ");
INSERT INTO ngp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wadya wamgwilaga Yesu wamwigalaga kwe nyumba ya Kayafa uyo Mkulu ywa walava nt'hambiko, aho andaga hamwenga na wahinizi we miko na wadala vilongozi wa want'hu. ");
INSERT INTO ngp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo naakamtimila luhalehale kubula ko uwa we nyumba yo Mkulu ywa walava nt'hambiko, engilaga uko kundani, niyo ekala akakaula ya kumlaila Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ivo Wakulu wa walava nt'hambiko hamwenga na want'hu we kitala, wandaga wakazungula mizungu ya udant'hi, vileke Yesu akomigwe, ");
INSERT INTO ngp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","mna wadundugaga hamwenga na kugamba, wezaga want'hu wengi wakamziga. Uuko uko walailaga want'hu waidi, ");
INSERT INTO ngp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na kugamba, “Mnt'hu uyu agambaga hambwe adaha kuimola Inyumba ino ya Mnungu niyo aizenga naho mwa mazuwa matatu.” ");
INSERT INTO ngp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mkulu wa walava nt'hambiko akimaalaga na kumgamba Yesu, “Hukuhitula kint'hu mwa aya wakuku longeleza?” ");
INSERT INTO ngp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mna Yesu handile no uhituzi wowose. Mkulu wa walava nt'hambiko niyo amgamba, “Nakulapiza mwe dizina dya Mnungu emgima, kigambile hegu kindedi weye niwe Kilisito Mkombozi Mwana ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Niyo Yesu ahitula, “Heiye ayo ukulonga naayo. Mna nawagambilani nyuwe nyose, mazuwa na yeze aho nommuwone Mwana Mnt'hu akekala kulume kwa Mnungu mta Udahi, akeza mwa mavunde ya kwe mbingu.” ");
INSERT INTO ngp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aho niyo Mkulu wa walava nt'hambiko atatula isuke yakwe yo ukulu akagamba, “kamlonga vihile, chaungai naho kulawa kwa waona? Mwiva ivo alongile vihile! ");
INSERT INTO ngp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Haluse mwagaaze?” Niyo wahitula, “Anamasa, kawagilwa kukomwa.” ");
INSERT INTO ngp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Niyo wamtweela mate mwo uso, no kumtoa, akajika wadya wamtoile, ");
INSERT INTO ngp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","wamgamba, “Kilisito, lotela, niani akutoile!” ");
INSERT INTO ngp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petulo ekalaga kuse ye kitala, aho eziilagwa ni mvele yumwenga mtumwa wa Mkulu akamgamba, “Weye nawe nokunda hamwenga na Yesu wa Galilaya.” ");
INSERT INTO ngp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mna aulemelaga ulosi uwo mwa meso yawe wose akagamba, “Hikukimanya kia mkulonga,” ");
INSERT INTO ngp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Niyo Petulo afosa kuse yo nk'hili ye nyumba ye kitala. Mtumwa mtuhu mvele nakamuona niyo awagamba wadya wandile hadya, “Mnt'hu uyu nawandanya na Yesu wa Nazaleti.” ");
INSERT INTO ngp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulo niyo akana kaidi kwa kukelisa akagamba, “Nawagambilani ikindedi himmanyize mnt'hu uyu!” ");
INSERT INTO ngp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lupisi ludodo wadya wakimalaga hadya hagihi na Petulo wamgambaga, “Ikindedi, Petulo nawe uyumwenga mwa woho, kwaviya hata milosi yako yakilagisa.” ");
INSERT INTO ngp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petulo niyo agamba, “Mnungu kamanya kagamba nalonga kindedi, neniligitwe uneva nadant'ha, himmanyize mnt'hu uyu!” Aaho zogolo niyo dyaila. ");
INSERT INTO ngp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Naho niyo Petulo akumbukila yadya Yesu amgambilaga kugamba, “Zogolo nedinde hadinati kuila weye nounde kunilemela nk'hanana nt'hatu, kugamba hunimanyize.” Aitaga kuse niyo aila kwa usungu mkulu. ");
INSERT INTO ngp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mtondo tondo, wakulu wa walava nt'hambiko wose hamwenga ne wadala vilongozi va want'hu wadamanyaga mzungu wawe wamgele Yesu mokumkoma. ");
INSERT INTO ngp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Niyo wamkakiliza mp'hingu no kumlongoza kumwigala kwa Pilato, mkulu wo mkowa asagulwe ni mkulu we Kilumi. ");
INSERT INTO ngp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aho Yuda msezengi eze aone kugamba Yesu kasengelwa kukomwa, nakakeiva usungu momoyo wakwe, niyo awavuzila yadya matundu milongo katatu, kwa wakulu wa walava nt'hambiko ne wadala vilongozi wa want'hu. ");
INSERT INTO ngp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Niyo Yuda umsezengi agamba, “Hindamanya wavu kwaviya hisezenga mnt'hu heedamanye lema dyodyose.” Niyo woho wamhitula kugamba, “Iyo haimwetu suwe, noumanye weye mwenye!” ");
INSERT INTO ngp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda ayaduulaga amatundu kwe nyumba idya ya Mnungu, niyo ahalawa, no kugenda kukenyulika yehe mwenye. ");
INSERT INTO ngp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wakulu wa walava nt'hambiko wayalogotaga amatundu wakagamba, “Hivo vedi kuyagela amatundu aya mwe kindolo cho kumlavila Mnungu malavo, kwaviya matundu aya ni ya sakame.” ");
INSERT INTO ngp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Weze wazumilane kwa idyo, matundu yadya wayaguilaga nk'honde ya kilongo hande hant'hu ha kuwamosa msanga want'hu wageni. ");
INSERT INTO ngp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Naho nivo vikuleka hant'hu aho hetangwa “Mgunda ya Sakame” hata diyelo. ");
INSERT INTO ngp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Niho yadya alongaga mlotezi Yelemia kunda kindedi kugamba, “Nawaguha matundu milongo mitatu, nicho kihimo cha want'hu wa Izilaeli wazumilaga kumliha. ");
INSERT INTO ngp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Naho matundu waziguilaga hant'hu hana ulongo wa kilongo enga viya Zumbe anisigiilaga miye.” ");
INSERT INTO ngp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu akimaalaga ha Pilato mkulu wo Mkoa aho amuuzaga, “Weye ni weye Seuta ywe Kiyahudi?” Yesu niyo amhitula, “Ivo ukulonga ni iivo.” ");
INSERT INTO ngp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mna hahitulaga dyodyose aho akalongelezwa ni Wakulu wa walava nt'hambiko ne wadala vilongozi wa want'hu. ");
INSERT INTO ngp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato niyo amgamba, “Aya yose wakukulongelezela wayeva?” ");
INSERT INTO ngp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mna Yesu alemelaga kulonga mbuli yoyose, imtendile Pilato mkulu wo Mkowa kwehelwa. ");
INSERT INTO ngp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Handaga ni kihendo kugamba, want'hu wakabula mwe dizuwa dye Pasaka, mkulu wo Mkoa alekelaga mvugailwa yumwenga wakumuunga. ");
INSERT INTO ngp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Elo kwandaga na mvugailwa yumwenga amanyikisaga, etangagwa Balaba. ");
INSERT INTO ngp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ivo want'hu weze waduganyike, Pilato awauzaga, “Mwaunga miye niwakomoeleni ani mwa wafungwa awa, Balaba hegu Yesu akwitangwa Kilisito mkombozi?” ");
INSERT INTO ngp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Awamanyaga vedi kugamba Wayahudi wandaga wakamlongeleza Yesu haheina lema. ");
INSERT INTO ngp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Umwo Pilato andaga kekala he nyumba yo kukantila masa, mkaziwe amwigailaga ulosi kugamba, “Usekunda na mbuli naye mnt'hu uyo uywedi, kwaviya hionesa makulu mwe sozi, ikilo chomboke mwa yehe.” ");
INSERT INTO ngp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wakulu wa walava nt'hambiko hamwenga na wadala vilongozi wa want'hu, wawatendaga want'hu kumgamba Pilato amlekele Balaba mna Yesu akantilwe kukomwa. ");
INSERT INTO ngp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mna Pilato awauzaga want'hu kugamba, “Niani mkuunga nimlekele?” Niyo wagamba, “Balaba!” ");
INSERT INTO ngp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato awauzaga naho, “Uyu Yesu akwitangwa Kilisito nimtende vivihi?” Niyo wahitula, “Muwambe mo mti wa masulmizo.” ");
INSERT INTO ngp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato niyo auza vituhu, “Kabanangai?” Niyo wakonga kutoa lwasu kwa kukweza maizwi, “Muwambe mo mti wa masulmizo.” ");
INSERT INTO ngp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato eze aone kugamba hakuzumilwa kwa dyodyose, mna henuka nk'humbizi, aguhaga mazi, niyo ahaka mikono yakwe wakamsinya wose, niyo awagamba, “Kukomwa kwo umnt'hu uyu hakwi mwangu, nomkaule nyuwe wenye.” ");
INSERT INTO ngp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Want'hu wose niyo wamhitula, “Sakame yakwe ileke inde mwetu hamwenga na wana wetu.” ");
INSERT INTO ngp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato niyo amlekela Balaba, eze Yesu eze atoigwe mikotya, niyo awenk'ha Yesu vileke wakamuwamba mo mti wa masulmizo. ");
INSERT INTO ngp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wank'hondo wa Pilato niyo wamgela Yesu he nyumba yo mkulu wo Mkowa, niyo wose wamzugulukila. ");
INSERT INTO ngp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Niyo wamhambula zisuke zakwe, no kumvala suke ya kiseuta. ");
INSERT INTO ngp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Naho niyo wadamanya taji ya miwa, niyo wamtungizila mo mtwi enga taji, niyo wamwink'ha ngoda ya kiseuta momkono wakwe wo kulume, akajika wamfikila madi, niyo wajumbwizila wakagamba, “Ndamsa we Zumbe we Kiyahudi.” ");
INSERT INTO ngp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wamtweelaga mate mwa meso, niyo wamtoa ngoda mwo mtwi. ");
INSERT INTO ngp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Weze wabinde kumtendela ujumbwizi, wamhambulaga idya isuke ye kiseuta, no kumvala zia izakwe. Aho niyo wamlongoza kuse kwo kumuwamba mwo mti msalaba. ");
INSERT INTO ngp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Umwo wandaga wakaita, wabwiilaga mnt'hu kulawa Kilene etangagwa Simoni, niyo wadya wank'hondo wamtigizaga kukinula msalaba cha Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wabulaga hamwenga hakwitangwa Goligota, “Hant'hu ha kibela cha Mtwi.” ");
INSERT INTO ngp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Niho wamwink'hilaga, mazi ya gwaduke, mna eze alume niyo ayalemela. ");
INSERT INTO ngp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nawamuwamba mo mti wa masulmizo niyo wakepangila izisuke zakwe kwa kuzitoela kula. ");
INSERT INTO ngp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Niyo wekala aaho wakamwamila. ");
INSERT INTO ngp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Halanga homtwi wakwe wawandikaga ivo viwandikwe yalekile wakamgela mwa masa, ya kugamba, “Uyu niye Yesu, Zumbe ywa Wayahudi.” ");
INSERT INTO ngp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Naho nawawambigwa mwe viwambilo watuhu waidi wandaga wahoki, yumwenga kulume mtuhu kumoso. ");
INSERT INTO ngp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Want'hu wandaga wakomboka, wamhomolaga, uku wakasingisa imitwi yawe, na kugamba, ");
INSERT INTO ngp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Weye hiwe wagambaga wadaha kuimola Inyumba ino ya Mnungu niyo izenga naho kwa mazuwa matatu! Uneva niwe Mwana ywa Mnungu keyokole kulawa kwo msalaba.” ");
INSERT INTO ngp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wakulu wa walava nt'hambiko hamwenga na wahinizi we zi Sigilizi na wadya wadala vilongozi, wamgelaga mabelo wakagamba, ");
INSERT INTO ngp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ayokolaga weyawe, hakudaha kukeyokola ye mwenye! Yehe hi zumbe wa Waizilaeli? Naakeseleze elo kulawa mwe kiwambilo, naswe nekimhuwile! ");
INSERT INTO ngp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kamhuwila Mnungu no kuke gamba yehe Mwana ywa Mnungu. Vedi, goja kikaule uneva Mnungu amuunga kindedi naa myokole!” ");
INSERT INTO ngp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wadya awahoki wawambigwe hamwenga na yehe nao niyo wamkalaliza. ");
INSERT INTO ngp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kukongela sa mtandatu, mpaka sa kanda kisingi handaga na ziza mwe isi yose. ");
INSERT INTO ngp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ize ibuze mwe sa kanda Yesu alavaga diizwi akagamba, “Eloi, Eloi, lama sabakitani?” Nuko kugamba, “Mnungu, Mnungu wanasa vivihi?” ");
INSERT INTO ngp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Want'hu wamwenga mwa wadya wandaga aaho weze weve, nawagamba, “Uyu amwitanga Eliya.” ");
INSERT INTO ngp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aaho niyo yumwenga aguluka no kuguha nk'hata imemile mazi yagwaduke niyo iisomeka mwo lukombosha nokugeza kumnywesa. ");
INSERT INTO ngp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wadya wamwenga niyo wagamba, “Mnekeni kikaule uneva Eliya neeze amhonye.” ");
INSERT INTO ngp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu niyo akweza diizwi kwa kuila, niyo aseleza umoyo. ");
INSERT INTO ngp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Niyo dipazia dyandile mwe Nyumba ya Mnungu dyatatuka hagati, kulawa kulanga mpaka hasi. Isi niyo yasingisika nyuwe niyo zatulika. ");
INSERT INTO ngp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Vikuta vagubukaga, want'hu wafaga, wasuntilwa wa Mnungu niyo wafosa mwe vikuta. ");
INSERT INTO ngp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Weze wafose mwe vikuta, naho Yesu eze ande kauyuka, waitaga kwo mzi Akukile Yelusalemu, uko waonagwa, ni want'hu wengi. ");
INSERT INTO ngp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yudya mkulu wa wank'hondo, hamwenga na wank'hondo wadya wandanye wakamwamila Yesu weze waone idisingisa hamwenga ne zimbuli zilaile hadya, wogohesaga, niyo wagamba, “Ikindedi uyu andaga Mwana ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kwandaga na wavele wengi, wandaga wakasinya kwa luhale. Woho nawo wamtimilaga Yesu kulawa Galilaya, naho wandaga wakaika mwambiza. ");
INSERT INTO ngp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mwa awoho wandaga aaho maliamu Magedalena, Maliamu nine dya Yakobo na Yusufu, na mkaza Zebedayo. ");
INSERT INTO ngp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ize inde mwalagulo, mgoli yumwenga kulawa Alimatayo, akwitangwa Yusufu yehe naye andaga mwanamp'hina ywa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Amwiitilaga Pilato no kuulombeza umwili wa Yesu. Pilato asiigilaga kugamba Yusufu enk'higwe umwili wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu niyo auguha umwili wa Yesu no kuuvala sanda yedi, ");
INSERT INTO ngp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","niyo akuwiika kwe kikuta chakwe mwenye akedamanyilaga, kwa kuupuka mwo luwe lutogile, niyo atongolosa iwe kulu, no kugubika ho mwingiilo we kikuta icho, niyo ahalawa. ");
INSERT INTO ngp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliamu Magedalena na yudya Maliamu umtuhu, wekalaga hadya wakaika kukaula ikikuta. ");
INSERT INTO ngp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Zuwa ditimile dyandaga zuwa dya Kuhumula. Wakulu wa walava nt'hambiko hamwenga na Mafalisayo wabwilanaga kwa Pilato ");
INSERT INTO ngp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","niyo wamgamba, “Zumbe, kikumbukila kugamba yudya mdant'hi aho andaga mgima agambaga, ‘Mwe dizuwa dya katatu neninde hiuyuka.’ ");
INSERT INTO ngp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sigiila kugamba hadya he kikuta hamilwe kindedi ndedi mwa mazuwa aya matatu, vileke wanamp'hina wakwe wasekudaha kuita, niyo waubawa umwili udya, niyo wawagamba want'hu kugamba, kauyuka. Lulimi ulu lwa kaidi nolunde lwiihisa kujink'ha ludya lwa nk'hongo.” ");
INSERT INTO ngp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato niyo awagamba, “Yamileni,” “Iteni niyo mwamila kikuta kwa udahi wenyu wose” ");
INSERT INTO ngp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ivo wahalawaga niyo wakuika wamizi kwe kikuta, kwa kukanda kikuta, no kuika want'hu wakwamila. ");
INSERT INTO ngp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dize dyomboke dizuwa dyo kuhumula, aho kwandaga kukatandazuka, Maliamu Magedalena na yudya Maliamu mtuhu, wagendaga kukaula ikikuta. ");
INSERT INTO ngp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aaho niyo alaila kisingisa, Kwaviya mtumigwa ywa kwe mbingu aseelaga kulawa kulanga niyo eza hadya he kikuta, no kuditongolosa diya diiwe, no kwikala mnanga mwakwe. ");
INSERT INTO ngp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ifuta yakwe yandaga ikamweka enga lumwemwe, sukwe zakwe nazo zang'alaga mbee. ");
INSERT INTO ngp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wadya awamizi wogohesaga weze wamuwone uyo mtumwa ywa Mnungu, niyo wengila lukengent'ha naho nawanda enga want'hu wabanike. ");
INSERT INTO ngp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mtumigwa ywa kwe mbingu niyo awagamba wadya wavele, “Msekogoha, himanya mwiza kumkaula Yesu, yudya awambagwa mwo msalaba. ");
INSERT INTO ngp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hahali aha! Kauyuka enga viya alongaga, soni mkaule hadya wamwikaga. ");
INSERT INTO ngp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Iteni ludole, naho mkawagambile wanamp'hina wakwe kugamba, ‘Kauyuka, naho kawalongoela kuita Galilaya, nuko nomkamuwone!’ Kumbukileni ayo niwagambileni.” ");
INSERT INTO ngp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Niyo wadya wavele wahalawa nguzu uku wakogoha. Mna nawanda na kinyemi, wagulukaga kugenda kuwagambila wanamp'hina wakwe. ");
INSERT INTO ngp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aho niyo Yesu awalaila naho niyo awalamsa akawagamba, “Ndamsa.” Niyo wambasa no kumtoza mwe viga, niyo wamwinamila kwa kumvika. ");
INSERT INTO ngp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu niyo awagamba, “Msekogoha, iteni mkawagambile wandugu zangu, waite Galilaya, nuko nawakanione.” ");
INSERT INTO ngp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Umwo wadya wavele wandaga wakaita, wamizi wamwenga waitaga kwo mzi kuwagambila wakulu wa walava nt'hambiko no kuwagambila kila kint'hu kilaile. ");
INSERT INTO ngp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Elo nawadugana hamwenga na wadala vilongozi na kuivana kuwenk'ha wadya watowani matundu mengi, ");
INSERT INTO ngp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na kuwagamba, “Mgambe kugamba, wanamp'hina wakwe naweza nekilo kigonile niyo waubawa umwili wakwe. ");
INSERT INTO ngp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Naho imbuli ino inevika kwo mkulu we isi, suwe nekilonge naye, msekunda na kituletule.” ");
INSERT INTO ngp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ivo wamizi niyo waguha matundu nokutenda enga viya wasigiilwe. Naho mbuli iyo yagendezwaga mwe isi yose ya Wayahudi hata mwa mazuwa aya yadielo. ");
INSERT INTO ngp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wadya wanamp'hina mlongo na yumwenga waitaga kwo lugulu lwa Galilaya, kudya Yesu awasigiilaga kuita. ");
INSERT INTO ngp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Weze wamuwone Yesu, niyo wamvika mna wamwenga mwawe nawanda wang'asa ng'asa. ");
INSERT INTO ngp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu awasogeelaga niyo awagamba, “Hink'higwa udahi wose, kulanga na mwe isi. ");
INSERT INTO ngp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Waitileni want'hu wose mwe isi zose, muwatende kunda wanamp'hina wangu, mkawabatiza kwa zina dya Tate, na dyo Mwana, na dya Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Naho wahinizeni kuyatimila yadya yose niwasigiileni nyuwe. Naho mmanye kugamba miye ni hamwenga na nyuwe mazuwa yose, mpaka kwo uheelo we zimbuli zose.”");
INSERT INTO ngp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ino niyo Mbuli Yedi ya Yesu Kilisito, Mwana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ikukonga enga ivo iwandikwe ni mlotezi ywa Mnungu Isaya. “Mnungu agambaga, ‘Nenimsigiile mwigala Ulosi ywangu akulongoele, akuunga akudamanyile sila yako.’ ");
INSERT INTO ngp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Izwi dya mnt'hu akubongeela kwe nyika, ‘Ikeni lumwe sila ya Zumbe, chululeni lwombokelo lwakwe!’ ” ");
INSERT INTO ngp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ivo Yohana Mbatizi alailaga mwe dijangwa, akabilikiza na kubatiza want'hu, akawagamba, “Kweiileni mbatizwe, Mnungu awausileni wavu wenyu.” ");
INSERT INTO ngp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Niyo want'hu wose we isi ya Uyahudi na mzi wa Yelusalemu wambasa wamtegeleze Yohana, wakakweiila wavu wawe, niyo wabatiziwa mo mto Yolodani. ");
INSERT INTO ngp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana avalaga valo didamanywe kwa mazoya ya ngamia, na mkoa wa nk'hingo mwe kigudi. Nk'hande yakwe yandaga sige na uki. ");
INSERT INTO ngp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Andaga akabilikiza kugamba, “Eyuko akwiza uyo miye nimlongoele, naho ana udahi kujink'ha miye. Miye hiwagilwe kufunama no kuhambula sigi ze vilatu vakwe. ");
INSERT INTO ngp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Miye nawabatizani kwa mazi, mna uyo akwiza naawabatizeni kwa Muye ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mwa mazuwa yadya, Yesu niyo eza kulawa Nazaleti mzi wa Galilaya, niyo abatizwa ni Yohana mwo mto Yolodani. ");
INSERT INTO ngp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aaho eze alawe mwa mazi, aonaga mbingu zikagubuka, Muye ywa Mnungu niyo amwizila enga suwa niyo amkima. ");
INSERT INTO ngp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Naho izwi kulawa kwe mbingu dyevikaga dikagamba, “Weye ni weye Mwanangu nikuungise, hyelelwa na weye.” ");
INSERT INTO ngp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aaho Muye ywa Mnungu amlongozaga kuita kwe dijangwa. ");
INSERT INTO ngp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ekalaga uuko mazuwa milongo mine akagezigwa nu Mwavu. Ekalaga na makala ya kwe mbago, mna watumigwa wa kwe mbingu wezaga kumwambiza. ");
INSERT INTO ngp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana eze avugailwe kwe divugailo, Yesu aitaga kwe isi ya Galilaya. Uko naakabilikiza Mbuli Yedi ya Mnungu kugamba, ");
INSERT INTO ngp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Lupisi lubula, Useuta wa Mnungu wi hagihi. Kweiileni wavu wenyu, ihuwileni Mbuli Yedi!” ");
INSERT INTO ngp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Umwo andaga akomboka mnk'handa mwe bahali ya Galilaya. Niyo awaona Simoni na nduguye Anduleya, wadula wavu mwe bahali, kwaviya wandaga walowa samaki. ");
INSERT INTO ngp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu niyo awagamba, “Nitimileni, name neniwatendeni mnde walowa wa want'hu.” ");
INSERT INTO ngp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aaho, wazilekaga zinyavu zawe niyo wamtimila. ");
INSERT INTO ngp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Eze agendegende awabwiilaga Yakobo hamwenga na nduguye Yohana, wana wa Zebedayo. Woho nawo wandaga mwe ngalawa yawe wakaziika lumwe zinyavu zawe. ");
INSERT INTO ngp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aaho Yesu eze awaone, niyo awetanga. Niyo wamleka Zebedayo tati yawe mwe ngalawa akanda hamwenga na wandima wa maliho, woho niyo wamtimila Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na wanamp'hina wakwe waitaga mwo mzi ukwitangwa Kapelinaumu. Mwe Sabato, nuko kugamba ni zuwa dya kuhumula, Yesu engilaga mwe nyumba ya Mnungu, niyo akonga kuwahiniza want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Want'hu wose wamtegelazaga niyo wehelwa ivo andile akahiniza, kwaviya handile akahiniza enga wahinizi wawe we miko, mna ni enga mnt'hu mta udahi. ");
INSERT INTO ngp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mdya mwe nyumba ya Mnungu mwandaga na mta mp'hepo, ahadya niyo agutila, ");
INSERT INTO ngp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Kina mbwai na weye Yesu wa Nazaleti? Haluse kwiza ukikome? Hikumanya weye ni weye Akukile ywa Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu niyo aitivila idya mp'hepo, “Nyamala! Naho umfose mnt'hu uyo!” ");
INSERT INTO ngp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Idya imp'hepo niyo yamgela yudya mnt'hu kifafa niyo yailisa, akajika niyo yamfosa. ");
INSERT INTO ngp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Want'hu wose weheelagwa wakauzana, “Ino mbwai? Mahinizo aya mahya? Kwaviya kwa udahi mnt'hu uyu alava mp'hepo, nazo zamwiva!” ");
INSERT INTO ngp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ivo mbuli zakwe Yesu niyo zagendesa mwe ziisi zose zimnk'handa ye Galilaya. ");
INSERT INTO ngp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ahadya weze wafose mwe nyumba ya Mnungu, Yesu aitaga na Yakobo na Yohana, mwe nyumba ya Simoni na Anduleya. ");
INSERT INTO ngp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nine dya mkaziwe Simoni andaga mo lusazi hakudaha. Ahadya weze wabule, niyo wamgambila Yesu mbuli idya. ");
INSERT INTO ngp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu niyo asogela hagihi ha yudya mnyonge. Amtozaga mkono no kumwinula. Udya unyonge niyo wamlekela, naye niyo akonga kuwakont'hela. ");
INSERT INTO ngp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kisingi, zuwa dize diswe, want'hu wamletelaga wanyonge na wata mp'hepo. ");
INSERT INTO ngp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Want'hu wabindile ingi nawamema ho lwazo lwe nyumba. ");
INSERT INTO ngp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu niyo awahonya want'hu wengi wandaga na maine ye hengi. Naho niyo awalava want'hu mp'hepo nyingi, mnaalo halekele mp'hepo kulonga kwaviya zammanyaga. ");
INSERT INTO ngp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kilo kilo, Yesu niyo afosa hakaya, aitaga kunt'hu hekwiina want'hu, uko niyo akonga kulombeza Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na weyawe niyo wamzungula. ");
INSERT INTO ngp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Weze wamuwone, niyo wamgamba, “Want'hu wose wakuzungula weye.” ");
INSERT INTO ngp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mna yehe niyo awagamba, “Kiteni mwe kaya zihagihi habilikize mbuli ya Mnungu uko nako. Kwaviya mbuli iyo niyo ilekile miye nize.” ");
INSERT INTO ngp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Niyo agenda mwe isi yose ya Galilaya, abilikiza mwe zinyumba zo kumvika Mnungu no kuzilava mp'hepo mwa want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mnt'hu mta matana niyo aita kwa Yesu, amhembelezaga akata kufika madi niyo amgamba, “Ukaunga, wadaha kunikukiza.” ");
INSERT INTO ngp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu niyo amwonela mbazi niyo achulula mkono wakwe, niyo amtoza. Niyo amgamba, “Naunga kukwambiza, ukuke!” ");
INSERT INTO ngp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ahadya niyo matana yakuka mwo mnt'hu yudya, niyo anda mgima. ");
INSERT INTO ngp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu amgambaga aite, akamkanya akamgamba, ");
INSERT INTO ngp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kaulisa, use kumgambila mnt'hu yeyose mbuli ino. Mna ita kakelagise kwa mlava nt'hambiko, naho kwa kukukizwa kwako ukalave malavo enga ivo Musa alongile, inde uwona kwawe.” ");
INSERT INTO ngp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mna yudya mnt'hu niyo afosa no kukonga kubilikiza mbuli idya hant'hu hose, vilekile Yesu adunduge kwingila mwo mzi asekuoneka. Niyo anda hant'hu haheina want'hu. Mna niyo want'hu wambasa kulawa kila hant'hu. ");
INSERT INTO ngp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yeze yomboke mazuwa mageke, niyo Yesu engila Kapelinaumu vituhu, want'hu niyo weva kugamba emwe nyumba. ");
INSERT INTO ngp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Niyo want'hu wengi wamema hata hakwasigale chumba, mpaka mo lwazo. Yehe niyo awabilikiza ulosi wakwe kwawe. ");
INSERT INTO ngp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Niyo weza want'hu wamwigaile Yesu mnyonge wawe aholole enulwe ni want'hu wane. ");
INSERT INTO ngp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwaviya want'hu nawamemesa, hawadahile kumbwila Yesu. Niyo waponk'hola langa kulanga kwe nyumba idya, hadya andile Yesu. Niyo waseleza lusazi lwa yudya mnyonge. ");
INSERT INTO ngp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu eze aone mhuwi wawe, niyo amgamba yudya mnyonge aholole, “Mwanangu, kuusilwa wavu wako.” ");
INSERT INTO ngp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wahinizi watuhu we Miko wandile mdya mwe nyumba niyo wakonga kufanyanya mwe mioyo yawe, ");
INSERT INTO ngp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nii uyu alonga ivi? Amhomola Mnungu! ni ani akudaha kuusa wavu uneva hi Mnungu ekedu!” ");
INSERT INTO ngp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ahadya Yesu niyo amanya moyo wakwe yadya nawakayafanyanya mwe mioyo yawe. Niyo awauza, “Nii mwafanyanya ivo mwe mioyo yenyu? ");
INSERT INTO ngp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mbuli mp'hufu ni ihi, kumgamba mta kuholola, ‘Kuusilwa wavu wako’, hegu kumgamba, ‘Inuka guha lusazi lwako wiite’? ");
INSERT INTO ngp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mna, vileke mmanye kugamba, Mwana Mnt'hu ana udahi wa kuwausila want'hu wavu wawe mwe isi.” Amgamba du yudya mnt'hu aholomp'hale, ");
INSERT INTO ngp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nakugamba, kimala, guha lusazi lwako wiite kaya.” ");
INSERT INTO ngp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ahadya yudya mnt'hu niyo akimaala no kuketwika lusazi lwakwe, niyo ahalawa want'hu wose wakamkaula. Want'hu wose weze waone viya, niyo wehelwa na kumtogola Mnungu wakagamba, “Hakinati kione mbuli enga ino!” ");
INSERT INTO ngp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu afosaga no kuita kunk'handa kwe bahali ya Galilaya. Want'hu wose niyo wambasa, yehe naye niyo awahiniza. ");
INSERT INTO ngp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Umwo andaga akomboka, niyo amuona mnt'hu akwitangwa Lawi mwana Alifayo kekala mwe nyumba ya kutozela kodi. Niyo Yesu amgamba, “Nitimile.” Lawi niyo enuka no kumtimila. ");
INSERT INTO ngp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Umwo Yesu andile akadya nk'hande mwe nyumba ya Lawi, fyo dya watoza kodi na wadya nawakagambigwa wata wavu nawakadya naye, hamwenga na wanamp'hina wakwe, kwaviya want'hu wengi nawakamtimila. ");
INSERT INTO ngp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wahinizi wamwenga we Miko wa Mafalisayo weze waone adya hamwenga na wata wavu na wakutoza kodi, niyo wawauza wanamp'hina wakwe, “Nii adya na want'hu enga awo?” ");
INSERT INTO ngp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu eze aweve, niyo awahitula, “Want'hu wagima hawakumuunga mlaguzi, mna wanyonge wamuunga. Hizile kuwetanga want'hu hewena wavu, mna wata wavu.” ");
INSERT INTO ngp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wanamp'hina wa Yohana Mbatizi hamwenga na wa Mafalisayo nawanda wakafunga. Want'hu wamwenga wezaga kwa Yesu kumuuza, “Wanamp'hina wa Yohana na wa Mafalisayo woho wafunga, nii weye wanamp'hina wako hawakufunga?” ");
INSERT INTO ngp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu niyo awahitula, “Want'hu wakwita kwe ndoza wehamwenga no mlombi nawadahe ivihi kufunga? Hawakudaha kufunga kwaviya wehamwenga no mlombi. ");
INSERT INTO ngp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mna mlombi aneza kuuswa, aho niho nawafunge. ");
INSERT INTO ngp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Hahali mnt'hu akugela kilaka kihya mwe suke isakale. Uneva atenda ivo, kiya kilaka nekivutumule idya isuke isakale niyo yatenda langa kulu. ");
INSERT INTO ngp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Naho hahali mnt'hu akugela divai mp'hya mwe vizembe visakale. Uneva anatenda ivo, idya divai mp'hya neibalange viya vizembe, niyo yetika. Divai mp'hya yaungigwa kugeligwa mwe vizembe vihya!” ");
INSERT INTO ngp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Zuwa dimwenga dyo Kuhumula, Yesu na wanamp'hina wakwe nawanda wakomboka mwo nk'honde yo uhemba. Wanamp'hina wakwe nawanda wakavuna magola ye uhemba mteke mwe idya migunda. ");
INSERT INTO ngp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafalisayo weze waone viya, niyo wamuuza Yesu, “Nii wanamp'hina wako wadamanya mbuli zilemezwe mwe dizuwa dyo Kuhumula?” ");
INSERT INTO ngp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu niyo awahitula, “Hamnati msome ivo adamanyaga Daudi hamwenga na weyawe hadya wandile na sala nokuswesa kint'hu cho kudya? ");
INSERT INTO ngp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mwa mazuwa yadya ya mkulu ywa walava nt'hambiko etangagwa Abiazali, Daudi niyo engila mwe Nyumba ya Mnungu, adyaga mikate hevikaungwa idigwe ni yeyose. Mikate iyo neikadigwa ni walava nt'hambiko du. Mna Daudi nakadya na kuwasangila weyawe.” ");
INSERT INTO ngp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu niyo awagamba, “Zuwa dya Kuhumula nedinda kwa mbuli ya want'hu, hiyo want'hu kwa mbuli ya Zuwa dya Kuhumula. ");
INSERT INTO ngp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ivo elo Mwana Mnt'hu yehe niye Zumbe ywe dizuwa dyo Kuhumula.” ");
INSERT INTO ngp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Niyo Yesu engila naho mwe nyumba ya Mnungu. Uko Nokunda na mnt'hu mta mkono uholole. ");
INSERT INTO ngp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mafalisayo watuhu nawakazungula mbuli ya kumlongeleza. Niyo wakaula vileke waone uneva naamhonye mnt'hu yudya mwe dizuwa dya Kuhumula. ");
INSERT INTO ngp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Niyo Yesu amgamba yudya mnt'hu aholole, “So aha hagati.” ");
INSERT INTO ngp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Niyo awauza, “Sigilizi zaunga kidamanye kihi mwe dizuwa dya Kuhumula, kudamanya mbuli yedi hegu iihile? Kuhonya ugima wa mnt'hu hegu kuukoma?” Mna niyo wanyamala twi! ");
INSERT INTO ngp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu niyo ahituka nt'hendelo zose akawang'oela meso kwa maya. Niyo awaonela mbazi kwo udala we mioyo yawe. Akajika amgamba yudya mnt'hu, “Kusula mkono wako.” Naye niyo aukusula, ahadya mkono wakwe niyo wanda mgima. ");
INSERT INTO ngp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wadya Mafalisayo niyo wafosa mwe nyumba idya ya Mnungu. Aaho, niyo wadugana na want'hu wa Mahelode, niyo waika mzungu vileke wamkome Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu hamwenga na wanamp'hina wakwe wakepagulaga niyo waita kunk'handa kwe bahali. Fyo dya want'hu niyo dyamtimila kulawa mwe ziisi za Galilaya na Uyahudi, ");
INSERT INTO ngp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na Yelusalemu, na Idumeya ne ng'ambu ya Yolodani, na nt'hendelo za mizi ya Tilo na Sidoni. Want'hu woseni awo wezaga kwa Yesu weze weve mbuli ziya Yesu adamanye. ");
INSERT INTO ngp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu niyo awagamba wanamp'hina wakwe wamwigaile ngalawa vileke akwele kwaviya want'hu wandilisaga wengi, vileke wase kudaha kumvigaviga, ");
INSERT INTO ngp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","kwaviya nakahonya want'hu wengi, wadya wose wandile wanyonge nawakavigana vigana vileke wamdose. ");
INSERT INTO ngp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na kila wata mp'hepo weze wamwone, mp'hepo niyo zagwa hameso hakwe zikaila naho zikamgamba, “Weye niwe Mwana Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mna Yesu niyo azitivila zimp'hepo zise kumtenda amanyike kwa want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu niyo akwela ko mnima, uko niyo awetanga wadya awaungile mwenye, woho nao niyo wambasa. ");
INSERT INTO ngp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Niyo awasagula mlongo na waidi awetanga wegala ulosi. Niyo awagamba, “Hiwasagulani mnde hamwenga na miye.” “Naho neniwasigileni mkabilikize, ");
INSERT INTO ngp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","nanywe nomnde na udahi wa kulava mp'hepo mwa want'hu.” ");
INSERT INTO ngp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wano nawo awasagulaga, Simoni niyo amwink'ha zina dya Petulo, ");
INSERT INTO ngp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo na nduguye Yohana, wana Zebedayo niyo awenk'ha zina dya Boanege, nuko kugamba, “Want'hu wa Kiludoleludole”, ");
INSERT INTO ngp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduleya, Filipo, Batolomayo, Matayo, Tomasi, Yakobo mwana Alufayo, Tadayo, Simoni Mkaya mtoanila isi ya Izilaeli, ");
INSERT INTO ngp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikaliyote, mta kumsezenga Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu niyo engila kwe nyumba. Fyo kulu dya want'hu niyo dyadugana, vilekile Yesu na wanamp'hina wakwe wadunduge ukudya. ");
INSERT INTO ngp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wanduguze weze weve idyo, niyo wagenda kumgwila kwaviya want'hu nawakagamba, “Kalaluka!” ");
INSERT INTO ngp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wahinizi watuhu we Sigilizi za Musa wezile kulawa Yelusalemu niyo wagamba, “Ana Belizebuli, awalava want'hu mp'hepo kwa udahi wa mkulu wa mp'hepo.” ");
INSERT INTO ngp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu niyo awetanga, akawagambila kwa mliganyizo, “Ivi Mwavu adaha kumgulusa Mwavu miyawe? ");
INSERT INTO ngp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Uneva useuta unaketoa nk'hondo woho wenye, useuta uwo haukudaha kukimala. ");
INSERT INTO ngp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Uneva nyumba inaketoa nk'hondo yoho yenye, inyumba iyo haikudaha kukimala. ");
INSERT INTO ngp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ivo uneva useuta wa Mwavu unaketoa nk'hondo woho wenye, niyo wagwa na haukudaha kugendeela. ");
INSERT INTO ngp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Mnt'hu hakudaha kwingila mwe nyumba ya mta udahi na kuvitaha vint'hu vakwe hanandile kumkakiliza yudya mta udahi. Aho niho naadahe kuitaha inyumba vakwe. ");
INSERT INTO ngp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nawagambilani kindedi, want'hu wadaha kuusilwa wavu wao wose hamwenga na kulonga vihile. ");
INSERT INTO ngp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mna mnt'hu akuunga amhomole Muye ywa Mnungu, hakudaha kuusilwa wavu wakwe, kwaviya katenda wavu wa ulo na ulo.” ");
INSERT INTO ngp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu nivo alongile kwaviya wan'thu watuhu nawagamba, “Ana mp'hepo.” ");
INSERT INTO ngp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nine na wanduguze Yesu wezaga niyo wakimala kuse, niyo wamtuma mnt'hu vileke akamwitange Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na fyo dya want'hu nedikala kumzunguluka. Niyo dyamgamba, “Kaula, nyokwe hamwenga na wanduguzo wekuse wakuzungula.” ");
INSERT INTO ngp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu niyo awahitula, “Mnala na wandugu zangu ni wahi?” ");
INSERT INTO ngp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Niyo ahituka akawakaula wadya wekale wamzunguluke niyo agamba “Kauleni! Awa nawo mnala na ndugu zangu! ");
INSERT INTO ngp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mnt'hu yeyose akudamanya yadya akuunga Mnungu niye lumbu dyangu na ndugu yangu naho niye mnala.” ");
INSERT INTO ngp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu niyo akonga kuhiniza vituhu kunk'handa mwe bahali ya Galilaya. Want'hu wabindile ingi niyo wammemela, yehe niyo akwela mwe ngalawa na kwikala uumo. Want'hu woseni niyo wasigala hank'handa he bahali. ");
INSERT INTO ngp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Niyo awahiniza kwa mliganyizo mbuli zibindile ingi. Mwe mahinizo yakwe niyo awagamba. ");
INSERT INTO ngp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tegelezeni, Handaga na mhanda mbeyu aitaga kumyaga mbeyu. ");
INSERT INTO ngp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Umwo akamyaga, mbeyu nt'huhu nazigwela kunk'handa kwe sila, niyo wadege weza na kuzidya. ");
INSERT INTO ngp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nt'huhu nezigwela mo luwe. Mbeyu niyo zatunga nguvu kwaviya nahenda hana msanga mgeke. ");
INSERT INTO ngp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mnaalo zuwa dize difose, mbeyu zidya niyo zahomp'hala kwaviya nazinda hazina maizi. ");
INSERT INTO ngp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu nt'huhu nazigwela mwe miwa, niyo zakula, mnaalo miwa niyo yazifint'ha vilekile mbeyu ziya zadunduga ukweleka. ");
INSERT INTO ngp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mna mbeyu zimwenga nazigwela mwo ulongo wedi. Niyo zakula na kweleka vedi, imwenga malavo milongo mitatu, zimwenga malavo milongo mtandatu, na zimwenga nazo malavo gana.” ");
INSERT INTO ngp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu niyo awagamba, “Mta magutwi, neeve.” ");
INSERT INTO ngp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu eze asigale yehe mwenye, wanamp'hina wakwe mlongo na waidi hamwenga na want'hu niyo wamwitila na kumgamba awatambalise idya imiliganyizo. ");
INSERT INTO ngp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Niyo awagamba, “Nyuwe mgubuilwa kinyele cho Useuta wa Mnungu. Mna wadya we kuse wagambilwa mbuli zose kwa miliganyizo, ");
INSERT INTO ngp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","vileke, ‘Wakaule no kukaula, mna wase kuwona, wategeleze na kutegeleza mna wase kukombaganya. Kwaviya wanamanya nawadahe kumuuiya Mnungu, naye niyo awausila wavu wawe.’ ” ");
INSERT INTO ngp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu niyo awauza, hamuukombaganye mliganyizo uno? Nomuimanye vivihi mituhu? ");
INSERT INTO ngp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mbeyu imyagigwe nu mhandi ni mbuli ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Want'hu wamwenga ni enga viya vilaile mwe zimbeyu zigwele mwe sila. Waiva imbuli ya Mnungu, ahadya Mwavu eza kuiguha idya imbuli ihandigwe mwe mioyo yawe. ");
INSERT INTO ngp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Want'hu wamwenga ni enga viya vilaile mwe zimbeyu zigwele mwo luwe. Wanaiiva imbuli ahadya, waihokela kwa kinyemi. ");
INSERT INTO ngp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mna kwaviya hawana maizi mwe mioyo yawe, wafinyiliza ludodo. Niyo hanalaila makunt'ho hegu masulumizo yoyose kwe idya mbuli, ahadya wauya kunyuma. ");
INSERT INTO ngp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Want'hu wamwenga nao wakeiga enga viya vilaile mwe zimbeyu zigwele mwe miwa. Wano ni wadya wakutegeleza imbuli, ");
INSERT INTO ngp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mna wogofi wo ugima uno na kuunga ugoli na kumunk'hwamunk'hwa kwi hengi mwe mioyo yawe, zaifint'ha idya imbuli, niyo wadunduga kweleka. ");
INSERT INTO ngp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Want'hu wamwenga nao wakeiga enga viya vilaile mwe zimbeyu zigwele mo ulongo wedi. Weva imbuli, na kweleka, wamwenga malavo milongo mitatu, wamwenga malavo milongo mtandatu na wamwenga malavo gana dimwenga. ");
INSERT INTO ngp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu niyo awauza, “Togoleni, lumuli lunawashigwa lwingizwa na kuikwa halanga hang'aile hegu yaikigwa hasi? Hikugamba yaikigwa halanga? ");
INSERT INTO ngp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kwaviya kint'hu chochose kifisigwe nekilondoke na chochose kigubikwe nekigubulwe. ");
INSERT INTO ngp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mta magutwi, neeve!” ");
INSERT INTO ngp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Niyo awagamba, “Mwinde na wengele kwa yadya mkuyeva, kiya kihimo mkuhima nyuwe, nanywe namhimilwe iicho. Naho nyuwe namwongezelwe. ");
INSERT INTO ngp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwaviya mta kint'hu noongezelwe, mna yudya heiina kint'hu, hata kiya kidodo ananacho naahokigwe.” ");
INSERT INTO ngp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu niyo agamba, “Useuta wa Mnungu ukeiga enga mnt'hu ahandile mbeyu mwe isi. ");
INSERT INTO ngp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Niyo enda viya akagona na kufosa ne zindima zakwe. Kilo na msi mbeyu idya niyo yagendeela kukula haheina yehe mwenye kumanya ivo ikukula. ");
INSERT INTO ngp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kwaviya isi yeleka yoho yenye, ikukongela mwe mani, niyo dyeza gola, ho uheelo ngano itogile. ");
INSERT INTO ngp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Umwo yakanyala, mnt'hu uyo niyo aita ne hengo kwaviya uvuni ubula.” ");
INSERT INTO ngp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Niyo Yesu agamba, “Kiuliganye na Useuta wa Mnungu? Hegu kiusimuile kwa kuliganya naho? ");
INSERT INTO ngp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ukeiga na kabeyu katendese udodo kakwe haladali, kabeyu aka ni kadodo kujink'ha mbeyu zose zikuhandwa mwe isi. ");
INSERT INTO ngp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mna kanahandwa, kakulisa niyo dyanda ziti kulu kujink'ha maziti yose ya kwe mbago. Dyanda na matambi makulu, hata wadege wa mwo ulanga niyo wadaha kuzenga vyaila mwa matambi yakwe.” ");
INSERT INTO ngp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu nakawabilikiza want'hu mbuli yakwe kwa miliganyizo mingi enga ino, naakalonga nao viligane na ivo nawakadaha kumtegeleza. ");
INSERT INTO ngp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Halongaga nawo mbuli yoyose haheina miliganyizo. Mna Umwo andaga na wanamp'hina wakwe weke du, nakawagambila mbuli zose. ");
INSERT INTO ngp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nekisingi mwe dizuwa idiya, niyo Yesu awagamba wanamp'hina wakwe, “Kijink'hanye kudya ng'ambu ye diziwa.” ");
INSERT INTO ngp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Niyo wauleka udya mdugano wa want'hu, wanamp'hina niyo wakwela mwe ngalawa mudya andile Yesu. Iviya iviya nokunda na ngalawa nt'huhu. ");
INSERT INTO ngp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Niyo halaila nk'hung'unt'ho nk'hulu, mjubwaniso wa mazi niyo yaitowa idya ngalawa, ingalawa nayo niyo yakonga kumema mazi. ");
INSERT INTO ngp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu andaga kagonela mwo mto kunyuma mwe ngalawa. Niyo wanamp'hina wakwe wamwinula, wakamgamba, “Mhinizi, hukuona changamila?” ");
INSERT INTO ngp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Niyo Yesu enuka, akonga kuditivila diya diheho dikulu na kuugamba mjubwaniso, “Nyamala twii!” Diya diheho niyo dyanyamala, niyo kwenda mp'heho tondolo. ");
INSERT INTO ngp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Niyo awagamba wanamp'hina wakwe, “Nii mwogoha? Mkeyi kunda na mhuwi?” ");
INSERT INTO ngp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Niyo wogohesa wakakegamba, “Uyu mnt'hu ywa vivihi? Akwivigwa hata ni nk'hung'unt ho ne mijubwaniso ye bahali!” ");
INSERT INTO ngp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na wanamp'hina wakwe niyo wabula ng'ambu ye diziwa dya Galilaya mwe isi ya Wagelasi. ");
INSERT INTO ngp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aho Yesu eze asele mwe ngalawa, niyo adugana na mnt'hu mta mp'hepo akulawa kwe vikuta. ");
INSERT INTO ngp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mnt'hu yudya andaga akekala ukudya kwe vikuta, naho hahandile na mnt'hu adahile kumtoza na kumkaka minyololo. ");
INSERT INTO ngp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nk'hanana nyingi nakakakigwa mwe viga vakwe na mikono yakwe, mna andaga akaikant'ha mp'hingu na minyololo ikakigwe mwe viga vakwe. Handaga hahana mnth'u adahile kumgwila. ");
INSERT INTO ngp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mazuwa yose msi na kilo andaga akekala kwe vikuta na kwe vigulu, akagutila na kukesenga na maiwe. ");
INSERT INTO ngp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eze amuone Yesu kwa hale, amgulukilaga. Eze ambwiile, amfikilaga madi. ");
INSERT INTO ngp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Niyo aila kwa izwi kulu akagamba, “Yesu Mwana Mnungu e Kulanga, waungai kwangu? Kelise kwa zina dya Mnungu kugamba hounisulumize!” ");
INSERT INTO ngp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nakalonga ivo kwaviya Yesu nakamgamba, “Weye mp'hepo, mlawe mnt'hu uyu!” ");
INSERT INTO ngp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Niyo Yesu amuuza, “Zina dyako niwe ani?” Naye niyo amhitula, “Netangwa fyo, kwaviya ki wengi.” ");
INSERT INTO ngp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Niyo amwilisa asekuyegala mp'hepo kuse ya idya isi. ");
INSERT INTO ngp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kudya ko vigulu Nokunda na fyo dya nguluwe dyandile dikadya. ");
INSERT INTO ngp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Niyo ziya zimp'hepo zamwiila Yesu kugamba, “Kigale kikengile mwe zinguluwe.” ");
INSERT INTO ngp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Niyo Yesu azumila, ziya zimp'hepo niyo zafosa mwe yudya mnt'hu no kwingila mwe ziya zinguluwe. Fyo gima dya nguluwe milongo magana dyanyaga nguluko kugenda kwingila kwe diziwa no kudidimila mwa mazi. ");
INSERT INTO ngp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wadya nawakadima zinguluwe, niyo wanyilika na kugendeza kose imbuli idya mwe mizi na mwe migunda. Want'hu niyo waita vileke wakakaule diya dilaile. ");
INSERT INTO ngp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Weze wabule kwa Yesu, wambwilaga yudya andaga na fyo dye zimp'hepo kekala, naho kavala suke yakwe na ubala wakwe umuuiya. Want'hu wose niyo wogoha. ");
INSERT INTO ngp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wadya waone mbuli idya, niyo wawasimuila want'hu kiya kimlaile mnt'hu yudya endile ne zimp'hepo, hamwenga na mbuli ya ziya zinguluwe. ");
INSERT INTO ngp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Want'hu niyo wamwiila Yesu afose mwe isi yawe. ");
INSERT INTO ngp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu eze ande akwela mwe ngalawa, mnt'hu yudya andaga ne zimp'hepo niyo aunga waitanye. ");
INSERT INTO ngp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mna Yesu hamzumilaga, niyo amgamba, “Keitile kaya ukawagambile ivo Zumbe akutendele na ivo akuonele mbazi.” ");
INSERT INTO ngp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yudya mnt'hu niyo akeitila no kukonga kubilikiza ivo Yesu amtendele uko kwo mzi ukwitangwa Mizi Mlongo Naho want'hu wose wevile niyo wehelwa. ");
INSERT INTO ngp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu eze omboke naho kwa ngalawa ng'ambu ye diziwa, want'hu wengi niyo wadugana hameso hakwe mk'handa mwe diziwa. ");
INSERT INTO ngp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Niyo eza mnt'hu yumwenga akwitangwa Yailo, yumwenga wa wakulu we nyumba ya Mnungu. Eze amwone Yesu, niyo amgweela mwe viga vakwe, ");
INSERT INTO ngp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","niyo amwiila vidala, amgamba, “Mwanangu wa kivele alumiswa. Nakuiila wize kaya vileke umuikile mikono yako ahone na kunda mgima.” ");
INSERT INTO ngp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu niyo aita hamwenga naye. Fyo kulu dya want'hu nadikamtimila Yesu na kumvigaviga. ");
INSERT INTO ngp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mwa wadya want'hu, nomnda na mvele yumwenga andile na unyonge wa kulawa sakame kwa myaka mlongo na miidi. ");
INSERT INTO ngp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yudya mvele nakasulumila vidala kwa wagangana wabindile ingi mna hahonile. Kafoseza vint'hu vakwe vose, mna unyonge wakwe nounda hunati kuhona. ");
INSERT INTO ngp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yudya mvele eze eve mbuli za Yesu, niyo awajink'ha want'hu mwo mdugano, no kumbasa Yesu kwa kunyuma. Eze ambwiile, niyo adosa suke yakwe, ");
INSERT INTO ngp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kwaviya nakalonga mwo moyo wakwe, “Uneva nna dosa suke yakwe du, nenihone.” ");
INSERT INTO ngp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eze adose du idya suke, aaho isakame niyo yaleka kumlawa, aaho mwenye niyo abunk'hula mwo mwili kugamba kahona. ");
INSERT INTO ngp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aaho Yesu niyo amanya kugamba ludole lumfosa. Niyo awahitukila want'hu mwo udya mdugano na kuwauza, “Ni ani adosile suke yangu?” ");
INSERT INTO ngp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanamp'hina wakwe niyo wamuuza, “Weye waona want'hu ivo wakukuvigaviga, mna wauza ni ani akukudosa?” ");
INSERT INTO ngp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mna Yesu niyo agendeela kuhituka mp'hande zose vileke akaule yudya adamanye mbuli idya. ");
INSERT INTO ngp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yudya mvele niyo kamanya diya dimlaile. Niyo amwitila uku akazingiza kwa kogoha, niyo amgweela mwe viga vakwe na kumgambila ikindedi chose. ");
INSERT INTO ngp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu niyo amgamba, “Mwanangu, mhuwi wako ukuhonya. Keitile mp'heho yedi, naho unde mgima.” ");
INSERT INTO ngp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu umwo andile akalonga ivo, niyo weza want'hu kulawa kwe nyumba ya Yailo, yudya mkulu we nyumba yakuvikila Mnungu. Niyo wamgamba Yailo, “Mwanao kabanika kale. Kwa ajili yani wagendeela kumkunt'ha Mhinizi?” ");
INSERT INTO ngp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mna Yesu eze eve wadya want'hu viya wakulonga, abela, niyo amgamba Yailo, “Usekogoha, weye huwila du.” ");
INSERT INTO ngp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu haungile kuita na mnt'hu yeyose, mna nakatimilana na Petulo, Yakobo hamwenga na Yohana mvunawe dya Yakobo. ");
INSERT INTO ngp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Weze wabule mwe nyumba ya Yailo, Yesu nakaona vugo, na kwiva ndilo na kuhongeza. ");
INSERT INTO ngp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu niyo engila kwe nyumba, niyo awagamba, “Kwa ajili yani mwatenda vugo naho uku mwaila? Mwana habanike, kagona du!” ");
INSERT INTO ngp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mna want'hu niyo wamseka. Ivo niyo awalava want'hu wose kuse, niyo amguha ise na nine dya yudya mwana na wadya wanamp'hina watatu, niyo wengila mwe chumba kiya andile yudya mwana. ");
INSERT INTO ngp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Niyo amtoza yudya mwana mkono na kumgamba, “Talita kumi!” Nuko kugamba “Mndele, nakugamba inuka!” ");
INSERT INTO ngp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ahadya yudya mndele niyo enuka na kukonga kugenda. Mndele yudya andaga na myaka mlongo na miidi. Dize dilaile idyo, want'hu niyo weheeleswa. ");
INSERT INTO ngp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu niyo awafunda wasekuwagambila want'hu mbuli idya. Niyo awagamba wamwink'he nk'hande mndele yudya. ");
INSERT INTO ngp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu niyo ahalawa hadya, aita kwo mzi wakwe na wanamp'hina wakwe niyo wamtimila. ");
INSERT INTO ngp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ize ibuze dizuwa dya Kuhumula, niyo Yesu akonga kuhiniza mwe nyumba ya Mnungu. Want'hu wengi wamwivile niyo weehelwa, naho niyo wauzana, “Kayalavahi aya? Naho upapala wa vivihi uno enk'higwe? Naho vivihi vihungi ivi vikulu akudamanya? ");
INSERT INTO ngp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Uyu hi yudya msongoli, mwana Maliamu, naho ndugu yawe dya Yakobo na Yose na Yuda hamwenga na Simoni? Naho walumbuze hikugamba kinanao aaha hetu kaya?” Want'hu niyo wamlemela. ");
INSERT INTO ngp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu niyo awagamba, “Mlotezi atunywa kila hant'hu, mna hiyo mwe isi yakwe na mwe kaya yakwe.” ");
INSERT INTO ngp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naho hadahaga kudamaya kihungi chochose, mna agelekaga mikono mwa wanyonge wageke, niyo awahonya. ");
INSERT INTO ngp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Niyo Yesu ehelwa vidala kwaviya want'hu nawaswesa kunda na mhuwi. Yesu niyo azungulukila mwe vijiji vi mgihi akahiniza want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Niyo awetanga wadya wanamp'hina mlongo na waidi, awasigila waidiidi. Niyo awenk'ha udahi mwe mp'hepo. ");
INSERT INTO ngp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nakawagamba, “Msekuguha kint'hu chochose mwe nt'hambo mna ngoda du. Msekuguha nk'hande na mkoa na matundu. ");
INSERT INTO ngp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Valeni vilatu, mna msekuguha nk'hazu mbili. ");
INSERT INTO ngp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nyumba yoyose nomwingile, ikaleni aho mpaka mkeza kuhalawa mo uwo mzi. ");
INSERT INTO ngp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na hant'hu hohose hawana wahokeleni hegu kuwategelezani, halaweni hant'hu aho kungunt'heni mavumbi ya mwe viga venu inde uwona kuwakanya.” ");
INSERT INTO ngp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Niyo waita na wakawabilikiza want'hu waleke uwavu wawe. ");
INSERT INTO ngp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Niyo wawalava want'hu mp'hepo nyingi, naho niyo wawahaka mavuta wanyonge wengi na kuwahonya. ");
INSERT INTO ngp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Seuta Helode niyo eva mbuli izo kwaviya dizina dyakwe Yesu nedigendezwa kila hant'hu. Want'hu watuhu nawakagamba, “Yohana Mbatizi kauyuka. Nivo vikuleka ana udahi wa kudamanya vihungi.” ");
INSERT INTO ngp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Watuhu niyo wagamba, “Uyu ni Eliya.” Na watuhu nao niyo wagamba, “Uyu mlotezi enga wadya walotezi wa kale.” ");
INSERT INTO ngp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mna Helode eze eve, niyo agamba, “Uyu ni Yohana Mbatizi nimkant'hile mtwi kauyuka!” ");
INSERT INTO ngp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kwaviya Helode mwenye nakasigila want'hu vileke Yohana agwiligwe na kwuikwa mwe divugailo. Helode nakadamanya ivo kwa mbuli ya Helodiya andile mkaza Filipo, nduguye dya Helode. Helode nakamlomba Helodia. ");
INSERT INTO ngp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana Mbatizi naakamgambila Helode hiyo vedi, “Sigilizi zagamba, havikuungwa weye kumlomba mkaza nduguyo.” ");
INSERT INTO ngp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Helodiya niyo amwiihia Yohana, naakaunga amkome. Mna hadahile kwa ajili ya Helode. ");
INSERT INTO ngp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode naakamwogoha Yohana kwaviya Yohana na kanda mnt'hu wedi naho akukile, ivo elo na kanda mo kumwamila. Naakaungisa kumtegeleza kwa kinyemi, ikanda eze amtegeleze naakalugumila. ");
INSERT INTO ngp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Helodia ketukila kupata luneka mwe dizuwa dya wila wa kukumbukila ukwelekwa kwake Helode. Helode nakawadamanyila wila wakulu wakwe wose na wakulu wa wank'hondo hamwenga na vilongozi wose wa Galilaya. ");
INSERT INTO ngp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Niyo mndele wakwe Helodiya engila na kuvina vedi. Helode na wose wandile mo udya wila niyo weleleswa. Seuta Helode niyo amgamba yudya mndele, “Lombeza kint'hu chochose kiya ukuunga, name nohwink'he.” ");
INSERT INTO ngp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Helode niyo akelisa akagamba, “Dyodyose ukuunga nohwink'he, hata unaunga hant'hu ho useuta wangu!” ");
INSERT INTO ngp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yudya mndele niyo afosa akumuuza nine, “Nilombeze kint'hu chani?” Nine niyo amgamba, “Lombeza mtwi wa Yohana Mbatizi.” ");
INSERT INTO ngp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yudya mndele niyo atenda nguzu kubula kwa seuta na kugamba, “Naunga iivi haluse unink'he mwe kihungu mtwi wa Yohana Mbatizi!” ");
INSERT INTO ngp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Seuta niyo engilwa ni usungu mkulu, mna kwaviya alavile ikilapi kwa wadya wandile hadya he wila, hadahile kulemela. ");
INSERT INTO ngp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ahadya niyo seuta asigiila mtowani egale mtwi wakwe Yohana Mbatizi. Mtowani niyo aita kwe divugailo na kumkant'ha Yohana mtwi. ");
INSERT INTO ngp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Niyo eza nao udya mtwi mwe kihungu na kumwink'ha yudya mndele. Yudya mndele naye niyo amwigaila nine. ");
INSERT INTO ngp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wanamp'hina wakwe Yohana weze weve, niyo wagenda kuguha ikimba chakwe Yohana niyo akimosela msanga. ");
INSERT INTO ngp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wegala ulosi niyo wadugana kwa Yesu na kumgambila yadya yose wadamanye na kuhiniza. ");
INSERT INTO ngp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu niyo awagamba, “Kiteni hant'hu haheina want'hu vileke muhumule ludodo.” Yesu nakalonga ivo kwaviya na handa na want'hu wengi, watuhu weza, watuhu wauya vilekile Yesu na wanamp'hina wakwe waswese luneka lwa kudya. ");
INSERT INTO ngp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Woho wenye niyo wakwela mwe ngalawa na kuita hant'hu haheina want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Umwo wandile wakaita, niyo want'hu wengi wawaona no kuwamanya. Niyo waguluka kulawa mizi yose, naho niyo wakonga woho kubula. ");
INSERT INTO ngp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu eze asele mwe ngalawa, niyo aona want'hu wabindile ingi. Yesu niyo awaonela mbazi kwaviya na wanda enga ngoto heziina mdimi. Niyo akonga kuwahiniza mbuli nyingi. ");
INSERT INTO ngp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ize ibuze nekisingi, wanamp'hina wakwe niyo wamuitila na kumgamba, “Hant'hu aha ni he nyika, ne dizuwa nadyo dyaswa. ");
INSERT INTO ngp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Walage want'hu awa vileke waite mwe migunda hamwenga na zikaya zihagahi wakakeguile nk'hande.” ");
INSERT INTO ngp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mna Yesu niyo awahitula, “Wenk'heni nyuwe nk'hande.” Niyo wamuuza, “Haluse kikawaguile mikate ya dinali magana maidi weze wadye?” ");
INSERT INTO ngp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Niyo awauza, “Mnanayo mikate mingahi? Iteni mkaikaule.” Weze wamanye, niyo wamhitula, “Kuna mikate mishano hamwenga na samaki mbili.” ");
INSERT INTO ngp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu niyo awagamba wanamp'hina wakwe wawagambile want'hu wekale hasi mwa mani wakepange mwe vibunga. ");
INSERT INTO ngp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Niyo wekala mwe vibunga va want'hu maganagana, aha milongo mishano shano. ");
INSERT INTO ngp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Niyo Yesu aguha idya mikate mishano ne ziya zisamaki zimbuli, niyo akaula kulanga kwe mbingu, na kumtogola Mnungu. Niyo abendula idya mikate na kuwenk'ha wanamp'hina wakwe wawapangile want'hu. Naho niyo awapangila want'hu wose ne ziya zisamaki zimbuli. ");
INSERT INTO ngp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Want'hu wose niyo wadya no kwiguta. ");
INSERT INTO ngp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wanamp'hina wakwe walogotaga vibesu visigale na samaki na kumemeza nt'hangulu mlongo na mbili. ");
INSERT INTO ngp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wagosi du nao wawazigwe, naho na wanda magana milongo mishano. ");
INSERT INTO ngp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aaho Yesu niyo awagamba wanamp'hina wakwe wakwele mwe ngalawa wakonge kuita Betisaida, ng'ambu ye diziwa. Umwo yehe andile akawalaga want'hu wahalawe. ");
INSERT INTO ngp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eze ajike kuwalaga want'hu, niyo aita mwo mnima kumlombeza Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ize ibuze nekisingi, ngalawa ne inda hagati mwe diziwa, na Yesu andaga ekedu mnk'handa mwe diziwa. ");
INSERT INTO ngp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Niyo awaona wanamp'hina wakwe viya wandile wakapayapaya mwe ngalawa kwaviya nawakahigana na heho. Hagihi na mazogolo kwila, niyo awatimila akagenda mnanga mwe mazi. Na kaunga kuwomboka, ");
INSERT INTO ngp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mna woho weze wamuwone akagenda mwe mazi, nawakagamba ni mzimu. Niyo waguta nk'hunga ");
INSERT INTO ngp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kwaviya wose nawogoha. Yesu niyo awagamba, “Msekogoha! Ni miye. Keink'heni moyo!” ");
INSERT INTO ngp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Niyo akwela mwe ngalawa mdya weli, heho niyo dyaleka. Wana mp'hina wakwe niyo weheleswa ");
INSERT INTO ngp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kwaviya nawanda hawamanyize imbuli idya ya kuwenk'ha nk'hande wadya want'hu wengi, mioyo yawe ne inda midala. ");
INSERT INTO ngp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Weze wabule nt'hendelo ya kaidi ya diziwa, wabula mwe isi ya Genezaleti, niyo waika nt'hulwe. ");
INSERT INTO ngp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Weze wasele mwe ngalawa, ahadya want'hu niyo wammanya Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Niyo wagulukila mwe isi yose, hohose hadya wevile Yesu andile. Wawenula mwe zisazi wose wandile wanyonge, niyo wamwigaila. ");
INSERT INTO ngp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kokose kudya Yesu aitile mwe zikaya hegu mwe mizi hegu mwe migunda want'hu nawawaika wanyonge mwe magwilo. Niyo wamlombeza wadose du suke yakwe. Wose wadya wadosile, nawahona. ");
INSERT INTO ngp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo wamwenga na Wahinizi wa Sigilizi wamwenga walaile Yelusalemu, waduganaga kwa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Niyo waona wanamp'hina wakwe wamwenga wadya nk'hande na mikono “misavu,” mna hawahakile mikono vedi enga viya ikuungwa. ");
INSERT INTO ngp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafalisayo hamwenga na Wayahudi hawakudya nk'hande uneva hawahakile mikono yawe enga viya ikuungwa. Nawakatenda ivo kutimila mahinizo ya wakale wawe. ");
INSERT INTO ngp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Naho hawakudaha kudya kint'hu chochose kikulawa kwe digwilo hakinandile kusuntigwa. Iviya iviya yeyuko mahinizo mengi nawakayatimila wayahokelaga, enga viya kusunt'ha viyamp'ha, nyungu na nyiga. ");
INSERT INTO ngp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Niyo wadya Mafalisayo hamwenga na wahinizi wa Sigilizi wamuuza Yesu, “Nii wanamp'hina wako hawakuyatimila mahinizo ya wakale? Nii wadya nk'hande na mikono misavu?” ");
INSERT INTO ngp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu niyo awagamba, “Isaya nakalotela vedi kwenyu nyuwe watondwe, enga viya iwandikwe. ‘Want'hu awa wanitogola mwe milomo yawe, mna imioyo yawe ihale na miye, ");
INSERT INTO ngp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naho woho wanivikila bule, wakahiniza miko ya want'hu, wakazitenda enga miko ya Mnungu!’ ");
INSERT INTO ngp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Nyuwe mwiileka miko ya Mnungu, mwatimila mahinizo ya want'hu.” ");
INSERT INTO ngp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu niyo agendeela kuwagamba, “Mwagamba mtenda vedi mna mwalemela miko ya Mnungu vileke mtimile mahinizo yenyu. ");
INSERT INTO ngp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa nakasigila, ‘Wategelezeni watati zenyu na wamami zenyu.’ Naho nakasigila, ‘Mnt'hu akuunga amligite ise hegu nine yaungigwa akomigwe.’ ");
INSERT INTO ngp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mna nyuwe mwahiniziza kugamba, mnt'hu ananda na kint'hu cha kuwaambiza ise hegu nine, mna anagamba kint'hu iki ni ‘Kolibani’ nuko kugamba ni geleko dya kumwink'ha Mnungu, ");
INSERT INTO ngp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","niyo mwagamba mnt'hu uyo, Alekelwa kumwambiza ise hegu nine. ");
INSERT INTO ngp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kwa ivo mahinizo yenyu mkuhinizana yausa imbuli ya Mnungu. Naho viyuko vint'hu vituhu vingi mkuvidamanya vikuligana na ivi.” ");
INSERT INTO ngp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu niyo aditanga idifyo dya want'hu naho kaidi no kuwagamba, “Nitegelezeni nyose, naho mkombaganye. ");
INSERT INTO ngp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hekihali kint'hu chochose kikuse yo mwili wa mnt'hu kikumwingila niyo chamgela usavu. Mna kiya kikufosa mndani mwo mnt'hu nicho kikudaha kumgela usavu.” ");
INSERT INTO ngp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mta kwiva, neeve! ");
INSERT INTO ngp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu eze adileke fyo dya want'hu, niyo engila kwe nyumba. Wanamp'hina wakwe niyo wamgamba mliganyizo wa mbuli idya. ");
INSERT INTO ngp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Niyo awagamba, “Ivi nanywe mswesa ubala ujink'hile watuhu? Hammanyize kugamba kint'hu chochose ki kuse ya mnt'hu, kinamwingila hakikudaha kumtenda ande msavu? ");
INSERT INTO ngp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kwaviya hakikumwingila mwo moyo mna mwe inda, niyo chafosa mwo mwili.” Mwo kulonga ivo, Yesu kalagisa kugamba nk'hande zose ziwagilwa kudigwa. ");
INSERT INTO ngp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Niyo agendeela kulonga, “Kint'hu kikufosa mndani mo mnt'hu niicho kikumgela usavu. ");
INSERT INTO ngp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwaviya mwo moyo wo mnt'hu numwo mkulawa fanyanyi ziihile, uhabwasi na kukoma, ");
INSERT INTO ngp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uhabwasi na ugubaguba na wiihi na udant'hii na finju na kulonga viihile na kukeduvya na ubwalasi. ");
INSERT INTO ngp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Vint'hu ivi nivo vikulawa mndani mwo mnt'hu na kumtenda ende msavu.” ");
INSERT INTO ngp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu niyo afosa na kwita mwe isi i mgihi no mzi wa Tilo. Engilaga mwe nyumba, naho haungile mnt'hu yeyose kumanya kugamba andaga ahadya. Mnaalo havidahike kukefisa. ");
INSERT INTO ngp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mvele yumwenga andile na mwana kike mta mp'hepo evaga mbuli za Yesu. Ahadya niyo amwitila na kumgweela mwe viga vakwe. ");
INSERT INTO ngp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mvele yudya andaga Mgiliki, elekwe mwo mzi wa Silofoinike mwe isi ya Siliya. Niyo amwiila Yesu amlave mwanawe zimp'hepo. ");
INSERT INTO ngp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu niyo amgamba, “Hake goja wana wande kwiguta. Hiyo vedi kuguha nk'hande ya wana na kuyaduila makuli.” ");
INSERT INTO ngp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yudya mvele niyo amhitula, “Heiye Zumbe, mna hata makuli nayo yadaha kulogota visigazwe na wana hasi ye meza.” ");
INSERT INTO ngp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu niyo amgamba, “Kwa ulosi uwo, keuiye kaya. Uko naukabwile zimp'hepo zimlawa kale mwanawo.” ");
INSERT INTO ngp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Niyo yudya mvele auya kaya. Eze abule, ambwiila yudya mwana kagona mo lusazi, na diya mp'hepo dimlawa kale. ");
INSERT INTO ngp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu niyo ahalawa mwe mihaka ya Tilo, akombokela hagati ya Sidoni, akaita kwe diziwa Galilaya na kubula mwe isi ikwitangwa Mizi Mlongo. ");
INSERT INTO ngp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Niyo wamwigaila mnt'hu heekwiva naho mta kigugumo. Niyo wamwiila Yesu amwikile mikono. ");
INSERT INTO ngp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu niyo amguha no kuita nae kunk'handa hekwiina want'hu. Niyo agela madole mwe magutwi ya yudya mnt'hu. Naho atwa mate na kumdosa mwo lulimi. ");
INSERT INTO ngp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesu niyo enula meso kulanga, atoa nkwilo, niyo amgamba yudya mnt'hu, “Efata!” Nuko kugamba, “Lohoka!” ");
INSERT INTO ngp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ahadya magutwi ya mnt'hu yudya niyo yakomoka no lulimi lwake nalwo lwalegela. Niyo akonga kulonga vedi vitendese. ");
INSERT INTO ngp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Niyo Yesu awafingiza wasekumgambila mnt'hu yeyose mbuli izo. Mna kila ivo naakawafingiza, woho nivo nawakatendesa kubilikiza kose mbuli izo. ");
INSERT INTO ngp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wadya wose wevile naweheleswa. Wakagamba, “Katenda kila kint'hu vedi! Kawatenda wata magutwi hayeekwiva weve, ne vimumu walonge!” ");
INSERT INTO ngp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mwe mazuwa yadya, fyo tuhu dya want'hu dyadugana naho hamwenga. Wadya want'hu weze waswese cho ukudya, Yesu niyo awetanga wanamp'hina wakwe, awagamba, ");
INSERT INTO ngp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nawonela mbazi wano want'hu, na wanda na miye mazuwa yose aya matatu, naho ivi haluse waswesa kint'hu cho ukudya. ");
INSERT INTO ngp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Uneva nnawagamba wauye kaya haheina kuwek'ha nk'hande, wadaha wakagwa mteho mwe sila, kwaviya watuhu weza kulawa hale.” ");
INSERT INTO ngp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wanamp'hina wakwe niyo wamuuza, “Haluse ni kuhi aha he nyika kikudaha kupata nk'hande ya kuwenk'ha want'hu woseni awa?” ");
INSERT INTO ngp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu niyo awauza, “Togoleni, mnanayo mikate mingahi?” Niyo wamhitula, “Mfungate.” ");
INSERT INTO ngp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu niyo awagamba want'hu wekale hasi. Niyo aiguha idya mikate mfungate na kuivikila. Abendula bendula, awenk'ha wanamp'hina wakwe na kuwasigila wawapangile want'hu. Woho nao niyo wadamanya enga viya wasigilwe. ");
INSERT INTO ngp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Naho nawanda na wasamaki wageke. Yesu niyo awavikila na kuwenk'ha wanamp'hina wakwe wawapangile want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Want'hu wose wadyaga na kwiguta. Niyo wanamp'hina wakwe wakasinya masigazi ye vibesu ve nk'hande vikumema nt'hangulu mfungate. ");
INSERT INTO ngp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hadya nahanda na want'hu wajink'hile magana milongo mine. Yesu niyo awalaga, ");
INSERT INTO ngp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","niyo yehe hamwenga na wanamp'hina wakwe wakwela mwe ngalawa na kwita mwe mzi wa Dalumanuta. ");
INSERT INTO ngp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayo wamwenga niyo wamwizila Yesu, wakonga kuhigana naye. Nawakaunga wamtegele, ivo niyo wamgamba adamanye kilagiso cha kihungi kulawa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mna Yesu niyo alugumila mwo moyo wakwe, niyo agamba, “Nii want'hu we cheleko iki waunga vilagiso va vihungi? Namigambilani ikindedi, hekihali kilagiso chochose wakunga wenk'higwe.” ");
INSERT INTO ngp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesu niyo awasa na kwingila mwe ngalawa, akonga kuita ng'ambu ye diziwa. ");
INSERT INTO ngp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wana mp'hina wakwe wajalaga kuguha mikate ya kuwakint'ha, nawanda na mkate umwenga du mwe ngalawa. ");
INSERT INTO ngp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu niyo awafunda kugamba, “Hangi nyuwe wenye, indeni na wengele ne ihamila ya Mafalisayo na ya Helode!” ");
INSERT INTO ngp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Niyo wakonga kuuzana, “Kalonga ivi kwaviya hakina mikate.” ");
INSERT INTO ngp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu nakamanya viya nawakalonga, niyo awauza, “Nii mwauzana imbuli yo kuswesa mikate? Nyuwe mkei kumanya hegu kukombaganya? Imioyo yenyu ikei midala? ");
INSERT INTO ngp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mnanayo meso mna hamkuona? Mnanayo magutwi mna hamkutegeleza? Hamkukumbukila? ");
INSERT INTO ngp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Viya nabendulaga idya mikate mishano na kuwenk'ha want'hu magana milongo mishano wadye? Vino nomlogota nt'hangulu nyingahi zimemile awabesu wasigale?” Niyo wamhitula, “Nakilogota nt'hangulu mfungate na mbili.” ");
INSERT INTO ngp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Niyo Yesu awauza, “Na hadya nabendulaga idya mikate mfungate na kuwenk'ha want'hu magana milongo mine wadye, nomkisanya nt'hangulu nyingahi zimemile masigazi?” Niyo wamhitula, “Nekisinya nt'hangulu mfungate.” ");
INSERT INTO ngp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Niyo awauza, “Mkei kukombaganya?” ");
INSERT INTO ngp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Niyo wabula ko mzi ukwitangwa Betisaida, niyo want'hu wamwigaila Yesu mnt'hu andile nt'hunt'hu. Wakamwiila amdose. ");
INSERT INTO ngp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu niyo amguha yudya nt'hunt'hu, aita naye kuse yo mzi. Niyo amtweela mate mwa meso, amwiikila mikono na kumuuza, “Wadaha kuwona kint'hu chochose?” ");
INSERT INTO ngp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yudya mnt'hu niyo akaula na kugamba, “Heiye! Naona want'hu wakugenda, wekale enga miti.” ");
INSERT INTO ngp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu niyo aika mikono yakwe naho mwa meso ya yudya mnt'hu. Nt'hambo ino, meso yakwe niyo yagubuka, anda aona kila kint'hu vedi vitendese. ");
INSERT INTO ngp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu niyo amgamba auye kaya, mna kamfingiza asekombokela kwo mzi udya. ");
INSERT INTO ngp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu hamwenga na wanamp'hina wakwe niyo wafosa no kuita mwe zikaya zi hagihi na Kaisalia Filipi. Viya wandile mwe sila, niyo Yesu awauza, “Nigambileni, want'hu wanitanga ni miye ani?” ");
INSERT INTO ngp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Niyo wamhitula, “Wamwenga wagamba ni Yohana Mbatizi, watuhu ni Eliya, naho kuna watuhu wakugamba ni yumwenga wa walotezi.” ");
INSERT INTO ngp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Niyo awauza woho, “Togoleni, nyuwe mwanitanga ni miye ani?” Petulo niyo amhitula, “Weye niwe Kilisito Myokozi.” ");
INSERT INTO ngp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu niyo awafunda wasekumgambila mnt'hu yeyose mbuli idya. ");
INSERT INTO ngp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Niyo Yesu akonga kuwahiniza wanamp'hina wakwe. “Mwana wa Mnt'hu aungigwa kusulumizwa vidala hamwenga na kulemelwa na wadala vilongozi na wakulu wa walava nt'hambiko hamwenga na wahinizi we Miko. Naho naakomigwe, mna mwa mazuwa matatu yakwiza naauyuke.” ");
INSERT INTO ngp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu nakayalonga aya haheiha kuyafisa kwa woho. Petulo niyo amguha hank'handa, akonga kumtivila. ");
INSERT INTO ngp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mna Yesu niyo awahitukila nakuwakaula wanamp'hina wakwe, niyo amfank'hila Petulo, “Halawe aha Mwavu! Hwikufanyanya mbuli za Mnungu, mna wafanyanya mbuli za kimnt'hu.” ");
INSERT INTO ngp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Niyo etanga fyo dya want'hu hamwenga na wanamp'hina wakwe no kuwagamba, “Uneva mnt'hu yeyose aunga kunitimila, akelemele mwenye, aguhe umsalaba chakwe atimile. ");
INSERT INTO ngp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mnt'hu akuunga aukombole ugima wakwe, nawazaganye, mna mnt'hu akuunga auzaganye ugima wakwe kwa ajili ya Miye na kwa ajili ya Mbuli Yedi ya Mnungu, naayokolwe. ");
INSERT INTO ngp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ivi mnt'hu naapatise mbwai anapata isi yose mna anawazaganye ugima wakwe? ");
INSERT INTO ngp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Hakihali k'hint'hu chochose akudaha kulava, avuzilwe naho ugima wakwe. ");
INSERT INTO ngp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mnt'hu akunionela soni miye hamwenga na mahinizo yangu mwe cheleko iki cho wavu hekimmanyize Mnungu, Mwana wa Mnt'hu namuwonele soni akeza kwiza mwo uwedi utendese wa Ise hamwenga na watumigwa wa kwe mbingu wakukile.” ");
INSERT INTO ngp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Niyo agendeela kuwagamba, “Kindedi nawagambilani kindedi, weaho want'hu wamwenga aha hawabanike mpaka hadya nawauone Useuta wa Mnungu ukeza kwa udahi.” ");
INSERT INTO ngp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yeze yomboke mazuwa mtandatu, Yesu niyo awaguha Petulo na Yakobo hamwenga na Yohana no kukwela nawo ko mnima wekedu. Uko Yesu niyo ahituka umwili wa Yesu niyo wahitukila mwa meso yawe. ");
INSERT INTO ngp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Suke zakwe niyo zamwekamweka, ukumweka kwakwe hahali mnt'hu yeyose mwe isi akudaha kunyukula zimweke enga ivo. ");
INSERT INTO ngp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Niyo wadya wanamp'hina wakwe watatu wawaona Eliya hamwenga na Musa wakasimuila na Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo niyo amgamba Yesu, “Mhinizi, ni vedi vitendese suwe kinde aha. Nekizenge waheha watatu, kamwenga kako na katuhu kakwe Eliya na kakwe katatu kakwe Musa.” ");
INSERT INTO ngp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petulo na weyawe nawogohesa vilekile aswese dyokulonga. ");
INSERT INTO ngp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naho niyo halaila vunde dyawagubika. Mwe divunde diya izwi niyo dyevika, dikagamba, “Uyu niye Mwanangu himuungise, mtegelezeni yehe!” ");
INSERT INTO ngp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ahadya weze wabagaze, hawaone mnt'hu mtuhu mna Yesu ekedu hamwenga na woho. ");
INSERT INTO ngp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Viya wandile wakasela kulawa ko mnima, Yesu niyo awagamba, “Msekumgambila mnt'hu yeyose mbuli ziya muwone mpaka Mwana wa Mnt'hu eze auyuke kulawa mwe file.” ");
INSERT INTO ngp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Niyo wazumila kiya awagambile, mna wakonga kuhitulana woho kwa woho wakagamba, “Kuuyuka kulawa mwe file niyo mbwai?” ");
INSERT INTO ngp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Niyo wamuuza Yesu, “Nii wahinizi wa miko wagamba Eliya aungigwa ande kwiiza?” ");
INSERT INTO ngp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yehe niyo awahitula, “Ni kindedi Eliya naande kwiza vileke aikile lumwe vint'hu vose. Hamwenga na ayo, nii Mawandiko Yakukile yagamba Mwana wa Mnt'hu naasulumizwe na kulemelwa? ");
INSERT INTO ngp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mna nawagambilani, Eliya nakeza kale niyo want'hu wamtendela viya waungile, enga viya awandikilwe mwo Mawandiko.” ");
INSERT INTO ngp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Weze wahangane na wadya wanamp'hina watuhu, waonaga fyo kulu dya want'hu diwazunguluke, na wamwenga wa wahinizi wa miko wakahituilana nawo milosi. ");
INSERT INTO ngp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Want'hu wose weze wamuwone Yesu, niyo weheleswa, niyo wamgulukila kumlamsa. ");
INSERT INTO ngp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu niyo awauza wanamp'hina wakwe, “Mwahituilana milosi yani na woho?” ");
INSERT INTO ngp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mnt'hu yumwenga mwe difyo diya niyo amhitula Yesu, “Mhinizi, nehikwigaila mwanangu kwaviya ana mp'hepo ikumtenda ande kimumu. ");
INSERT INTO ngp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Naho mp'hepo iyo inamwingila, humgwesa hasi, na kulawa fulo mo mnomo, meno nayo yagwegwejula naho anda katoga. Nehilonga na wanamp'hina wako uleke wailave imp'hepo iyo, mna niyo wadunduga.” ");
INSERT INTO ngp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu niyo awahitula, “Nyuwe cheleko mzungu mhuwi! Nenikale na nyuwe mpaka ini? Neniguhilane na nyuwe mpaka ini? Nileteleni uyo ndugu ywetu!” ");
INSERT INTO ngp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Niyo wamwigala ndugu ywetu yudya kwa Yesu. Ahadya imp'hepo idya ize imuwone Yesu, niyo yamgela kifutu yudya ndugu ywetu, yamkinya hasi, naye kakonga kusamp'ha na kulawa fulo. ");
INSERT INTO ngp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu niyo amuuza ise. “Kanda ivi kukongela ini?” Ise niyo amhitula, “Kukongela udodo wakwe.” ");
INSERT INTO ngp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Nk'hanana nyingi mp'hepo iyo yagezaga kumkoma ikamduula mwo moto na mwa mazi. Kionele mbazi, uchambize uneva ukadaha!” ");
INSERT INTO ngp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu niyo agamba, “Nii wagamba, uneva ukadaha! Mbuli yoyose yadahika kwa yudya mta mhuwi.” ");
INSERT INTO ngp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ahadya ise dya yudya ndugu ywetu niyo alonga kwa izwi kulu, “Nna mhuwi, mna haukukit'ha. Nambize ninde na mhuwi ukint'hile!” ");
INSERT INTO ngp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu eze aone difyo dya want'hu dyawasogeela, niyo aitivila idya imp'hepo, “Weye mp'hepo yo umumu no unt'hunt'hu, nakugamba, mlawe mbwanga uyu, naho usekumuuiya naho!” ");
INSERT INTO ngp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mp'hepo idya iihile niyo yaila na kumgwisisa kifutu yudya ndugu ywetu na kumlawa. Yudya mbwanga niyo anda enga abanike, want'hu niyo wagamba, “Kabanika!” ");
INSERT INTO ngp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mna Yesu niyo amtoza mkono yudya ndugu ywetu, niyo amwambiza ukwinuka, naye niyo akimaala. ");
INSERT INTO ngp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu eze engile kwe nyumba, wanamp'hina wakwe wamuuzaga kwa kinyele, “Kwajili yani suwe kidunduga kuilava imp'hepo idya iihile?” ");
INSERT INTO ngp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu niyo awahitula, “Hahana sila nt'huhu ikudaha kuilava mp'hepo enga iyo, mna kwa kulombeza Mnungu du.” ");
INSERT INTO ngp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na wanamp'hina wakwe wahalawaga hadya, niyo waita wakombokela mwo mzi we Galilaya. Yesu haungile mnt'hu yeyose amanye hadya endaga, ");
INSERT INTO ngp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwaviya andaga akawahiniza wanamp'hina wakwe. Niyo awagamba, “Mwana ywa Mnt'hu naaik'hizwe mwa want'hu wakuunga wamkome. Mna mwe dizuwa dya katatu naande kauyuka.” ");
INSERT INTO ngp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wanamp'hina wakwe hawayakombaganye mahinizo yadya, mna nawakogoha kumuuza. ");
INSERT INTO ngp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Niyo wabula Kapelinaumu. Umwo wandaga mwe nyumba, Yesu awauzaga wanamp'hina wakwe, “Nomkaagaze mwe sila?” ");
INSERT INTO ngp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Niyo wanyamala kwaviya mwe sila nawakauzana milosi kugamba ni ani mkulu mgati mwawe. ");
INSERT INTO ngp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu niyo ekala hasi no kuwetanga wanamp'hina wakwe mlongo na waidi, niyo awagamba, “Mnt'hu akuunga kunda ywa nk'hongo yaungwa aketende mwenye kunda wakuzigiila mwa wose, naho ande mndima ywa wose.” ");
INSERT INTO ngp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Niyo amguha mwana mdodo no kumkimalisa hameso yawe, niyo amkumbatila na kuwagamba, ");
INSERT INTO ngp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mnt'hu yeyose naamhokele mwana enga uyu kwe dizina dyangu anihokela miye. Naho mnt'hu ananihokela miye, hakunihokela miye du, amhokela hata yudya anisigiile miye.” ");
INSERT INTO ngp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana niyo amgamba Yesu, “Mhinizi, nekimuwona mnt'hu akulava mp'hepo kwa dizina dyako. Niyo chamfingiza kwaviya hiyo miyetu.” ");
INSERT INTO ngp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu niyo awagamba, “Msekumfingiza,” kwaviya hahana mnt'hu akudaha kudamanya vihungi kwa zina dyangu, naho akajika anilongele mbuli ziihie. ");
INSERT INTO ngp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kwaviya mnt'hu yeyose heekukihiga suwe, uyo ni miyetu. ");
INSERT INTO ngp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nawagambilani kindedi, mnt'hu yeyose akuunga awenk'he nyuwe mazi yo kunywa kwaviya nyuwe mwi want'hu wa Kilisito, naahokele nt'hunyo. ");
INSERT INTO ngp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Naho mnt'hu yeyose akuunga amtende yumwenga mwa awa wadodo kuhuwila atende wavu, nevinde vedi kwa mnt'hu uyo akakigwe iwe kulu mwe singo yakwe, no kuduulwa mwe bahali. ");
INSERT INTO ngp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Uneva mkono wako wakutenda udamanye wavu ukant'he. Ni vedi wingile ko ugima wa ulo na ulo na kagunk'ho, kujink'ha kwingila kwo moto houkuzima wa ulo na ulo na mikono miidi. ");
INSERT INTO ngp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mafuza ya ukwo hayakubanika, naho moto wakwe haukuzima. ");
INSERT INTO ngp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Uneva kiga chako kinakutenda udamanye wavu kikant'he. Ni vedi wingile kwo ugima wa ulo na ulo na kiga kimwenga, kujink'ha kunda ne viga vose viidi niyo waduulwa kwo moto houkuzima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘Madudu ya ukwo yakuwadya hayakubanika, no moto wa ukwo ukuwoka haukuzima’ ");
INSERT INTO ngp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","iviya iviya ziso dyako dinakutenda udamanye wavu, ding'ole. Neinde vedi wingile ko Useuta wa Mnungu na ziso dimwenga, kujink'ha kunda na meso maidi niyo waduulwa kwo moto houkuzima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Madudu ya uko yakuwadya hayakubanika, naho moto wa uko haukuzima.’ ");
INSERT INTO ngp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kwaviya kila yumwenga naagelwe munyu kwa moto. ");
INSERT INTO ngp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Munyu ni wedi, mna munyu unabanika no utendigwe vivihi unde munyu wedi? “Indeni na munyu wa uhamwenga mgati mwenyu, naho mwikale kwa utondowazi kila yumwenga na miyawe.” ");
INSERT INTO ngp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ahalawaga ahadya niyo aita Uyahudi akombokela Yolodani. Fyo dya want'hu dyamwiziilaga, niyo yehe awahiniza enga viya azoele. ");
INSERT INTO ngp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mafalisayo watuhu wamwizilaga, niyo wamuuza kwa kumgeza wakamgamba, “Ni vedi mgosi kumwasa mkaziwe?” ");
INSERT INTO ngp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu niyo awahitula kwa kuwauza, “Musa awasigiilagai?” ");
INSERT INTO ngp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Woho niyo wamhitula, “Musa nakazumila mgosi amwink'he talaka na kumwasa mkaziwe.” ");
INSERT INTO ngp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu niyo awagamba, “Musa awawandikilagani miko iyo, kwaviya mioyo yenyu ni midala mwo kuhinizwa. ");
INSERT INTO ngp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Viligane na ivo viwandikwe mwa Mawandiko, ‘Kukongela nk'hongo mwe kuumbigwa isi, Mnungu nakamuumba mgosi na mvele.’ ");
INSERT INTO ngp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kwa ivo, mgosi naamwase ise na nine, niyo alungana hamwenga na mkaziwe, ");
INSERT INTO ngp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","naho awaidi awa nawande mwili umwenga.’ Ivo hawande waidi naho, mna mnt'hu yumwenga. ");
INSERT INTO ngp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kwa ivo kilunganywe ni Mnungu, mnt'hu yeyose ase kukipanga.” ");
INSERT INTO ngp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Umwo wandaga kwe nyumba, wanamp'hina wakwe niyo wamuuza Yesu idya imbuli. ");
INSERT INTO ngp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu niyo awagamba, “Mnt'hu yeyose anamwasa mkaziwe niyo alomba mvele mtuhu, naande mhabwasi. ");
INSERT INTO ngp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mvele naye anamwasa mgosiwe niyo alombigwa ni mgosi mtuhu, yehe naye naande mhabwasi.” ");
INSERT INTO ngp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Niyo want'hu wamletela Yesu wana wadodo vileke awageleke mikono. Mna wanamp'hina wakwe niyo wawativila wadya want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu eze aone, niyo aihiwa no kuwagamba wanamp'hina wakwe, “Walekeni wana wadodo weze kwangu, msekuwafingiza, kwaviya Useuta wa Mnungu umwe want'hu enga awa wana wadodo. ");
INSERT INTO ngp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nawagambila kindedi, mnt'hu yeyose hana uzumile Useuta wa Mnungu enga mwana mdodo, heengile mbwitu.” ");
INSERT INTO ngp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Niyo awakumbatila no kuwagelekela mikono na kuwavikila. ");
INSERT INTO ngp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Umwo Yesu andaga akakonga naho int'hambo yakwe, mnt'hu yumwenga niyo amgulukila, niyo amfikila madi na kumuuza, “Mhinizi wedi, nitende vivihi vileke ninde mkipe ywo ugima wa ulo na ulo?” ");
INSERT INTO ngp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu niyo amuuza, “Nii wanitanga ywedi? Hahali mnt'hu ywedi mna Mnungu ekedu. ");
INSERT INTO ngp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Miko kuimanya, ‘Usekukoma, usekunda mhabwasi, usekubawa, usekunda mdant'hi naho weive welesi wako.’ ” ");
INSERT INTO ngp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yudya mnt'hu niyo amgamba, “Mhinizi, hizitoza sigilizi izo kukongela udodo wangu.” ");
INSERT INTO ngp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kwa kumuungisa, niyo amkaula na kugamba, “Kuhungukilwa kint'hu kimwenga. Ita ukatage vint'hu vose unanavo, uwenk'he matundu wakiwa, nawe no unde na kindolo kwe mbingu kwa Mnungu. Ukajika wize unibase.” ");
INSERT INTO ngp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yudya mnt'hu eze eve ivo, niyo aihiwa, niyo ahalawa kwa usungu kwaviya andaga mgoli. ");
INSERT INTO ngp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu niyo abagaza na kuwagamba wanamp'hina wakwe, “Nevindilise vidala kwa want'hu wagoli kwingila ko Useuta wa Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wanamp'hina wakwe niyo wehelwa kwa mbuli ziya alongile Yesu. Mna Yesu niyo agendeela kulonga, “Wanangu, ni vidala kwingila mwo useuta wa Mnungu! ");
INSERT INTO ngp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nainde vidala kwa mgoli kwingila mwo Useuta wa Mnungu kujink'ha ngamiya kombokela mwe nt'hundu ye singano.” ");
INSERT INTO ngp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Woho niyo weheleseswa, wakauzana, “Haluse ni ani akuunga ayokolwe?” ");
INSERT INTO ngp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu niyo awakaula na kuwagamba, “Kwa want'hu haikudahika, mna kwa Mnungu hiyo ivo, naho kwa Mnungu mbuli zose zadahika.” ");
INSERT INTO ngp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petulo niyo amgamba, “Kaula, suwe kileka kila kint'hu kikutongele weye!” ");
INSERT INTO ngp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu niyo awagamba, “Heiye, namigambilani ikindedi, mnt'hu yeyose asile kaya na wanduguze we kigosi na walumbuze na nine na ise na wanawe na migunda kwa ajili ya miye hamwenga na Mbuli Yedi, ");
INSERT INTO ngp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","naahokele vitendese mwe mazuwa aya, naho nahokele malavo gana, zinyumba na wandugu we kigosi na walumbu na wa mami na wana na migunda, hamwenga na masulumizo. Na mwe isi ikwiza naahokele ugima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mna want'hu wengi wakutogolwa na wande wa kubelwa na wadya wa kubelwa na wande wakutogolwa.” ");
INSERT INTO ngp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu hamwenga na wanamp'hina wakwe nawanda mwe sila wakakwela kuita Yelusalemu. Yesu nakawalongoela wanamp'hina, niyo wanamp'hina wehelwa, na want'hu nawakamtimila wenda wogoha. Yesu awaguha wadya wanamp'hina mlongo na waidi kunk'handa na kukonga kuwagambila mbuli zikuunga zimlaile. ");
INSERT INTO ngp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Niyo awagamba, “Tegelezeni, chakwela kuita Yelusalemu. Uko Mwana wa Mnt'hu naalavigwe kwa Wakulu wa walava nt'hambiko hamwenga na wahinizi we miko. Woho nawamsengele kubanika na kumlava kwa want'hu hiyo Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Woho nawambele hamwenga na kumtweela mate, nawamtoe ngoda na kumkoma. Mna yanomboka mazuwa matatu, naauyuke.” ");
INSERT INTO ngp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo hamwenga na Yohana, wana wakwe Zebedayo niyo wambasa na kumgamba, “Mhinizi, kuna kint'hu kikuunga ukidamanyile.” ");
INSERT INTO ngp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu niyo awauza, “Kint'hu chani icho?” ");
INSERT INTO ngp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Niyo wamhitula, “Unekala mwe difumbi dyako dye kiseuta na mwo uwedi wako utendese, chaunga ukitende suwe kikanye na weye, yumwenga kulume kwako na mtuhu kumoso kwako.” ");
INSERT INTO ngp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu niyo awagamba, “Hammanyize icho mkulombeza. Haluse mwadaha kunyweela mwe kikombe che masulumizo hunga ninywele miye? Hegu kubatizwa viya huunga nibatizigwe miye?” ");
INSERT INTO ngp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Woho niyo wahitula, “Chadaha.” Yesu niyo awagamba, “Kikombe huunga nikinywele nomnywele kindedi, naho mwadaha kubatizwa enga viya nibatizwe miye. ");
INSERT INTO ngp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mna hikudaha kusagula yudya akuunga ekale kulume kwangu hegu kumoso kwangu. Ni Mnungu akuunga awek'he ukalo uwo wadya awasagule.” ");
INSERT INTO ngp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Niyo wadya wanamp'hina watuhu mlongo weze weve kiya Yakobo na Yohana walombeze, niyo wawafila maya. ");
INSERT INTO ngp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu niyo awetanga wose na kuwagamba, “Wadya wakugambigwa vilongozi wakulu wa want'hu hiyo wayahudi wawalongoza want'hu kwa ludole, naho wana udahi mkulu kwa want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mna kwa nyuwe hiyo ivo. Mnt'hu yeyose akuunga kunda mkulu kwenyu aungigwa ende mndima wenyu, ");
INSERT INTO ngp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","naho mnt'hu yeyose mgati mwenyu akuunga ende wa nk'hongo yaungigwa ende mtumwa wa wose. ");
INSERT INTO ngp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwaviya Mwana wa Mnt'hu hezile kudamanyilwa ndima, mna keza kunda wandima wa want'hu, na kulava ugima wakwe vileke awakombole want'hu wengi.” ");
INSERT INTO ngp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Niyo wabula Yeliko. Yesu na wanamp'hina wakwe hamwenga na fyo kulu dya want'hu weze wende wahalawa, nt'hunt'hu yumwenga endile aketangwa Batimayo mwana wakwe Timayo nakekala hank'handa he sila akalombeza want'hu. ");
INSERT INTO ngp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eze eve ni Yesu wa Nazaleti andile akomboka, niyo akonga kubongeela, “Yesu! Mwana wa Daudi! Niyonele mbazi!” ");
INSERT INTO ngp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Want'hu wengi niyo wamtivila vileke anyamale. Mna yehe niyo agendeela kubongeelesa, “Mwana wa Daudi, nionele mbazi!” ");
INSERT INTO ngp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu akimalaga niyo agamba, “Mwitangeni.” Wamwitanga yudya mnt'hu niyo wamgamba, “Keink'he moyo. Inuka, akwitanga.” ");
INSERT INTO ngp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yehe naye aduulaga suke yakwe, niyo apilika na kuita kwa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu niyo amuuza, “Waunga hudamanyilei” Yudya t'hut'hu niyo amhitula, “Naunga nione vituhu.” ");
INSERT INTO ngp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu niyo amgamba, “Keitile, mhuwi wako ukuhonya.” Meso yakwe yagubukaga ahadya, naho aonaga kaidi, niyo amtimila Yesu mwe sila. ");
INSERT INTO ngp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Weze wande hagihi na Yelusalemu, kwe mizi ya Betifage hamwenga na Besania, wabulaga mwo mnima we Mizeituni. Niyo Yesu awatuma wanamp'hina wakwe waidi wawalongoele. ");
INSERT INTO ngp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Niyo awagamba, “Iteni mwe kaya ikulongole yenyu. Mnabula, nambwile mwana mp'hunda ageligwe luzigi, naho akei kwinula mnt'hu. Mfunguleni niyo mwaniletela. ");
INSERT INTO ngp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Uneva mnt'hu anawauzani, ‘Nii mwadamanya ivo?’ Mgambeni, ‘Zumbe amuunga, nenisunguze kumvuza.’ ” ");
INSERT INTO ngp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Waitaga niyo wambwila mwana mp'hunda kakakigwa hank'handa he sila ho lwivi lwe nyumba. Weze wakonge kumfungula, ");
INSERT INTO ngp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","want'hu wandile haguhi niyo wawauza, “Nii mwamfungula uyo mwana mp'hunda?” ");
INSERT INTO ngp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wanamp'hina wadya niyo wawahitula enga viya wasigilwe ni Yesu. Wadya want'hu niyo wawaleka waite naye. ");
INSERT INTO ngp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Niyo wamwigaila Yesu yudya mwana punda, niyo watandika zisuke zawe mnanga mwa yudya mwana mp'hunda, Yesu niyo ekala mnanga mwake. ");
INSERT INTO ngp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Want'hu wengi niyo watandika zisuke zawe mwe sila, watuhu nawo niyo wanjaza matambi ye miti wayakat'hile mwe migunda wakamsingila. ");
INSERT INTO ngp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Want'hu wadya walongole na wadya wakutimila kunyuma niyo wabongela wakagamba, “Zumbe atogolwe! Kavikilwa yudya akwiza kwa dizina dya Zumbe! ");
INSERT INTO ngp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uvikilwa useuta ukwiza wa tati yetu Daudi, atogolwe Mnungu ekwe mbingu!” ");
INSERT INTO ngp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu niyo engila mo mzi we Yelusalemu, aita kwe Nyumba nk'hulu ya Mnungu niyo akaula kila kint'hu. Mna kwaviya yandaga mwalagulo, aitaga hamwenga na wanap'hina wakwe mlongo na waidi ko mzi wa Besania. ");
INSERT INTO ngp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Zuwa dya kaidi weze wande walawa Besania, Yesu andaga na sala. ");
INSERT INTO ngp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aonaga kwa hale mtini umemile mani. Niyo aubasaga vileke akakaule uneva naapate tini. Eze abule, abwiila mani ayo du kwaviya yandaga hiyo msimo wakwe wo kweleka. ");
INSERT INTO ngp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu niyo augamba mtini, “Kukongela dielo na ulo na ulo hahali mnt'hu naadye matunda kulawa kwako nahi.” Wanamp'hina wakwe niyo wamwiva viya alongaga. ");
INSERT INTO ngp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Aho weze wabule Yelusalemu, Yesu niyo engila mwe Nyumba ink'hulu ya Mnungu niyo akonga kuwagulusa want'hu wandile wakachuuza hamwenga na kugula vint'hu. Niyo akindula zimeza za wadya wandile wakasakanya matundu, hamwenga na mafumbi ya wadya wandile wakachuuza suwa. ");
INSERT INTO ngp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Naho hamlekele mnt'hu yeyose kufosa na kint'hu chochose mwe nk'hili ye nyumba nk'hulu ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Niyo awahiniza kugamba, “Iwandikwa mwa Mawandiko Yakukile, ‘Nyumba yangu neitangwe nyumba ya kuvikila kwa want'hu wose.’ Mna nyuwe mwiihitula kunda mp'hanga ya wabavi.” ");
INSERT INTO ngp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wakulu wa walava nt'hambiko hamwenga na wahinizi we Miko wevaga zimbuli izi niyo wakonga kuzungula sila vileke wamkome Yesu. Mna niyo wogoha kwaviya fyo dya want'hu nawakehelwa mwa yadya andile akahiniza. ");
INSERT INTO ngp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ize inde mwalagulo, Yesu hamwenga na wanamp'hina wakwe niyo wahalawa ho mzi udya. ");
INSERT INTO ngp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mtondotondo Zuwa dya kaidi tondotondo, umwo wandile wakomboka, wauwonaga udya mtini uligitwe ni Yesu unyala kukongela kwa maizi. ");
INSERT INTO ngp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo niyo akumbukila yadya yalaile, niyo amgamba Yesu, “Mhinizi, hake kaula! Udya mtini uuligite unyala!” ");
INSERT INTO ngp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu niyo awahitula, “Mhuwileni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nawagambilani ikindedi, mnt'hu yeyose anaugamba mnima uno, genda kakeduule mwe bahali, handile na kiyangayanga mwo moyo wakwe, mna anahuwila kugamba mbuli zose akuzilonga zadahika, naadamanyilwe ayo. ");
INSERT INTO ngp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwa ivo namigambilani, mnanda mwo kuvika na kulombeza kint'hu chochose, mhuwile kugamba mhokela, nanywe nomwikwe kiya mkulombeza. ");
INSERT INTO ngp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nanywe mnanda mkavika, wausileni want'hu wavu wawe vileke Tati yenyu ekwe mbingu naye amiusileni uwavu wenyu. ");
INSERT INTO ngp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mna uneva nyuwe hamkuwausila uwavu watuhu, Tati yenyu ekwe mbingu naye haamiusileni uwavu wenyu.” ");
INSERT INTO ngp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Niyo wabula naho Yelusalemu, Yesu umwo eze ande mwe Nyumba nk'hulu ya Mnungu, Wakulu wa walava nt'hambiko na wahinizi wa Sigilizi hamwenga na wadala vilongozi wamwiitilaga ");
INSERT INTO ngp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","niyo wamuuza, “Weye wadamanya zimbuli izi kwa udahi wa ani? Naho ni ani akwink'hile udahi wa kudamanya aya?” ");
INSERT INTO ngp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mna Yesu niyo awahitula, “Name neniwauzeni mbuli imwenga, umwo mnanihitula, neniwagambileni nadamanya aya kwa udahi wa ani. ");
INSERT INTO ngp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nigambileni, ubatizo wa Yohana walawaga kwa ani? Walawaga kwa Mnungu eli kwe mbingu hegu kwa want'hu?” ");
INSERT INTO ngp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Niyo wakonga kukeuza woho wenye, “Nekigeeze? Kinamhitula, ‘Walawaga kwa Mnungu eli kwe mbingu,’ naakiuze, ‘Nii hamwamhuwile?’ ");
INSERT INTO ngp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Naho hakikudaha kugamba, ‘Walawaga kwa want'hu.’ ” Nawakawogoha want'hu kwaviya want'hu wose nawamanya kugamba Yohana andaga mlotezi we kindedi. ");
INSERT INTO ngp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ivo niyo wamhitula, “Hakimanyize.” Yesu naye niyo awagamba, “Miye name hikumigambilani kugamba nadamanya mbuli izi kwa udahi wa ani.” ");
INSERT INTO ngp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Niyo akonga kulonga nawo kwa miliganyizo. “Handaga na mnt'hu yumwenga ahandile zabibu mwe mgunda wakwe. Niyo azungulusila nk'hindilo, asimba bome dya kukamuila zizabibu, hamwenga na kuzenga kinala. Eze ajike, niyo aika wandima mwenye, niyo aita nt'hambo. ");
INSERT INTO ngp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lupisi wize lubule wa kwaha zizabibu, niyo amsigila mtumwa kwa wadya wandima vileke wamwink'he hant'hu hakwe mwa kiya kipatikane. ");
INSERT INTO ngp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wadya wandima niyo wamgwila, wamtoa, na kumgamba auye haheiina kumwiink'ha kint'hu chochose. ");
INSERT INTO ngp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mta mgunda niyo amsigila mtumwa mtuhu. Yudya naye niyo wamgela nkwenge za mwo mtwi hamwenga na kumdamanyizila soni. ");
INSERT INTO ngp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Niyo amsigila mtuhu, uyo niyo wamkoma. Naho niyo awasigila watumwa watuhu wengi, mna wadya wandima niyo wawatoa watuhu hamwenga na kuwakoma watuhu. ");
INSERT INTO ngp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Asigale wo kumsigila andaga mwanawe we kilume amuungise. Niyo amsigila kwa wadya wandima kwaviya nakagamba, ‘Uyu nawamwive kwaviya ni mwanangu!’ ");
INSERT INTO ngp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mna wadya wandima niyo wagambilana, ‘Uyu niye mwana mkipe wa mta mgunda. Kimkome vileke mgunda uno winde wetu.’ ");
INSERT INTO ngp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ivi niyo wamgwila yudya mwana na kumkoma. Niyo kudula kimba chakwe kuse ko mgunda wa mizabibu.” ");
INSERT INTO ngp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu niyo awauza, “Haluse na atende ivivihi yudya zumbe mta mgunda we mizabibu? Naeze na kuwakoma wadya want'hu, naho mgunda udya we mizabibu naawenk'he want'hu watuhu. ");
INSERT INTO ngp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hamnati kusoma Mawandiko yakulonga. ‘Diiwe diya dyalemelagwa ni wazesi, dinda iwe kulu kujink'ha yose. ");
INSERT INTO ngp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Vint'hu ivi navitendwa ni Zumbe, navo vihungi mwa meso yetu?’ ” ");
INSERT INTO ngp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Niyo wageza kumgwila Yesu kwaviya nawabunk'hula kugamba umliganyizo udya nauwalonga woho. Mna nawakaogoha fyo dya want'hu, niyo wamleka waita zawe. ");
INSERT INTO ngp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mafalisayo watuhu hamwenga na want'hu wamwenga we dibunga dya zumbe Helode nawasigilwa kwa Yesu wakamgeze vileke wamgwile mwe milosi yakwe. ");
INSERT INTO ngp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Niyo wamwiziila wamgamba, “Mhinizi, kimanya weye umta ikindedi, naho hukogoha ukulu wa mnt'hu, mna wahiniza ikindedi cha Mnungu kwa want'hu. Kigambile, ni vedi suwe kuliha kodi kwa Seuta ywa Kilumi? Haluse kilihe hegu kisekuliha?” ");
INSERT INTO ngp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mna Yesu niyo amanya udya utondwe wawe. Niyo awahitula, “Kwa mbwai mwanigeza miye? Nink'heni ditundu vileke nidikaule.” ");
INSERT INTO ngp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Niyo wamlagisa. Yesu niyo awauza, “Futa ne dizina idi va ani?” Niyo wamhitula, “Ni va Seuta ywa Kilumi.” ");
INSERT INTO ngp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu niyo agamba, “Vedi, mwink'heni Seuta ywa Kilumi ayo ayakwe, yadya ya Mnungu nayo mwink'heni Mnungu.” Niyo wamwehelwa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Niyo want'hu wamwenga mwe dibunga dya Masadukayo, wadya want'hu wakugamba hakuhali kuuyuka kulawa mwe file, wamwizilaga Yesu na kumgamba, ");
INSERT INTO ngp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mhinizi, Musa nakakiwandikila miko kugamba, ‘Uneva mnt'hu anabanika niyo asa mvele heena mwana, nduguye adaha kumguha yudya mvele uleke amwelekele mwana nduguye yudya abanike.’ ");
INSERT INTO ngp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nahenda na ndugu mfungate. Yudya wa nk'hongo nakalomba mvele, niyo abanika mna hasile mwana, ");
INSERT INTO ngp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","wa kaidi naye niyo amguha yudya mvele, yehe naye niyo abanika haheina kwasa mwana. Niyo yalaila enga ivo kwa ndugu wa katatu. ");
INSERT INTO ngp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Niyo woseni wadya wasigale wampala yudya mvele, mna wabanika haweina mwana weleke. Niho elo yudya mvele naye abanika. ");
INSERT INTO ngp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Haluse mwe dizuwa dya kuuyuka kulawa mwe file, yudya mvele naande wa ani mwe wadya wose? Kwaviya woseni mfungate nawamlomba yudya.” ");
INSERT INTO ngp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu niyo awahitula, “Mwaga! Mmanya nii? Kwaviya hamuumanyize Mawandiko hamwenga no udahi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwaviya waneza kuuyuka, hawalombe mna kulombigwa. Nawende enga mtumigwa ywa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kwe mbuli yo kuuyuka kwa want'hu wabanike, ivi hamsomile mwe kitabu cha Musa mbuli ya kaziti kakukweela? Hadya iwandikwe kugamba, Mnungu nakamgamba Musa, ‘Miye ni Mnungu wa Ibulahimu na Mnungu wa Isaka na Mnungu wa Yakobo.’ ");
INSERT INTO ngp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yehe ni Mnungu wa wagima, hiyo Mnungu wa wadya wabanike. Ivo nyuwe mwagilisa!” ");
INSERT INTO ngp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mhinizi yumwenga wa Miko andaga hadya naho nakeva milosi. Eze aone Yesu nakamhitula vedi yudya Sadukayo, niyo amwizila Yesu na kumuuza, “Mwe Sigilizi zose, Sigilizi ink'hulu ni ihi?” ");
INSERT INTO ngp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu niyo amhitula, “Sigilizi ink'hulu ni ino. ‘Tegeleza weye Izilaeli! Zumbe Mnungu ywetu ni Zumbe yumwenga ekedu. ");
INSERT INTO ngp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Muungise Zumbe Mnungu ywako kwo umoyo wako wose naho kwa moyo wako wose no kwa ubala wako yose no ludole lwako lwose.’ ");
INSERT INTO ngp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na mwiko wa kaidi ink'hulu, ‘Muunge miyao enga viya ukukeunga weye mwenye.’ Haihali sigilizi nt'huhu ikujink'ha izi zimbuli.” ");
INSERT INTO ngp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yudya mhinizi we Miko niyo amgamba Yesu, “Mhinizi, kulonga kindedi! kugamba Mnungu ni yumwenga naho hahali Mnungu mtuhu mna yehe. ");
INSERT INTO ngp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","No kumuunga Zumbe Mnungu ywako kwo moyo wako wose na kwa ubala wako wose na kwa ludole lwako lwose, no kumuunga miyao enga viya ukukeunga weye mwenye ni vedi kujink'ha kumlavila Mnungu nt'hambiko na malavo yo kokigwa.” ");
INSERT INTO ngp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu naye eze aone yudya mnt'hu kamhitula vedi, niyo amgamba, “Weye hwihale no Useuta wa Mnungu.” Kukongela hadya hahandile mnt'hu yeyose amuuzile mbuli yoyose. ");
INSERT INTO ngp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu eze ande ahiniza mwe Nyumba nk'hulu ya Mnungu, niyo awauza, “Wahinizi we Miko wadaha vivihi kugamba Kilisito naalawe mwo welekwa wa Daudi? ");
INSERT INTO ngp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwenye nakalonga kwa udahi wa Muye ywa Mnungu. ‘Zumbe nakamgamba, Zumbe dyangu, Wikale kulume kwangu, mpaka aho huunga niwaike wank'hondo wako hasi he viga vako.’ ");
INSERT INTO ngp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daudi mwenye nakamgamba ni ‘Zumbe.’ Yanda vivihi Kilisito ande ywo welekwa wa Daudi?” Idifyo dya want'hu wandile hadya nawakamtegeleza Yesu kwa kinyemi. ");
INSERT INTO ngp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Niyo awagambila mwe mahinizo yakwe, “Indeni na wengele na wahinizi we Miko. Wakuungisa kugenda wavaile nk'hanzu na kulamswa kwa kutunywa mwa magwilo, ");
INSERT INTO ngp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","naho waungisa kwikala mwo ukalo wa kulongole mwe nyumba ya Mnungu na mwe zifugo. ");
INSERT INTO ngp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wawahujila wabanikilwe ni wagosi zawe, uku wakaketenda kumlombeza Mnungu kwa milosi mingi. Mwe dizuwa dyo usengelo nawasengelwe masulumizo makulu” ");
INSERT INTO ngp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ekalaga hagihi ne kindolo akawakaula kaula want'hu ivo wakugela malavo yawe mwe kindolo. Wagoli wengi wagelaga matundu mengi. ");
INSERT INTO ngp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Niyo eza mvele yumwenga mkiwa abanikilwe ni mgosiwe, niyo alava watundu wakwe waidi wadodo wa matundu. ");
INSERT INTO ngp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu niyo awetanga wanamp'hina wakwe na kuwagamba, “Nawagambilani ikindedi, uyu mvele mkiwa abanikilwe ni mgosiwe kagelesa kujink'ha wose wakugela matundu mwe kindolo. ");
INSERT INTO ngp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwaviya wose nawakagela visumpuule mo ugoli wawe, mna uyu mvele mo ukiwa wakwe, kagela vose viya endile navo.” ");
INSERT INTO ngp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu viya endile naakalawa mwe Nyumba nk'hulu ya Mnungu, yumwenga mwe wadya wanamp'hina wakwe niyo amgamba, “Mhinizi, hake kaula ivo yeli yedi aya maiwe na mazengo!” ");
INSERT INTO ngp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu niyo amhitula, “Wayaona aya amazengo makulu? Hadihali iwe dikuunga disigale mnanga mwa miyawe, nayamoligwe yose.” ");
INSERT INTO ngp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu ekalaga mwo mnima we Mizeituni akakaula kwe Nyumba ya Mnungu, umwo Petulo na Yakobo na Yohana na Anduleya wamwizilaga kwa kinyele. ");
INSERT INTO ngp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Niyo wamuuza, “Hake kigambile, mbuli izi nezilaile ini? Naho vilagiso vakwe ni vihi kugamba mbuli izi zi hagihi kulaila?” ");
INSERT INTO ngp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu niyo akonga kuwagambila, “Hangi nyuwe wenye, mnt'hu asekuwadant'hilizani. ");
INSERT INTO ngp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Want'hu wengi wakadidamanyila ndima dizina dyangu kila yumwenga akagamba, ‘ni miye Kilisito!’ Ivo nawawadant'hilize wengi. ");
INSERT INTO ngp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Msekogoha umwo mkeva nk'hunga za nk'hondo na seselo za nk'hondo. Yose ayo yaungwa kulaila, mnaalo udya uheelo ukei. ");
INSERT INTO ngp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Isi na itoane na isi, na useuta nawo nautoane na useuta mtuhu. Naho kila hant'hu na hande na visingisa va isi, naho na kwinde na gumbo. Mbuli izi nezinde enga viya ukukonga kwa usungu wa mvele akuunga ukweleka. ");
INSERT INTO ngp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nyuwe nanywe kauliseni! Namgwiligwe na kwigalwa mwo kusengeelwa. Namtoigwe mwe nyumba ya Mnungu. Namguhigwe hameso ye vilongozi na maseuta kwajili yangu vileke muwone uwona wangu hameso yawe. ");
INSERT INTO ngp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Uheelo ukei kubula, Mbuli Yedi ya Mnungu yaungigwa kubilikizwa kwa want'hu wa isi zose. ");
INSERT INTO ngp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Naho wanawagwila na kuwegala mwe vitala, msekogoha mkafanyanya yadya mkunga mlonge. Dyodyose mkunga mwink'higwe mwo lupisi udya longeni idyo. Kwaviya hiyo nyuwe mkulonga, mna ni Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Want'hu nawawalongele udant'hi ndugu zawe vileke wakomigwe, na tate nawadamanye enga ivo kwa wana wawe. Wana nawawahituke welesi uleke wakomigwe. ");
INSERT INTO ngp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Want'hu wose nawamwiihieni kwa ajili yangu. Mna yudya akuunga afinyilize na kubula ko uheelo, niye akuunga ayokolwe. ");
INSERT INTO ngp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Aho mkeza kuwona kiku ihiza naho kikubananga kiink'hana Hant'hu hiyo hakwe, mnt'hu akusoma akombaganye, niho wadya wandile Uyahudi wanyilikile kwe vigulu. ");
INSERT INTO ngp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yudya endile kulanga ye nyumba asekuseela hasi naho asekwingila mwe nyumba yakwe kuguha kint'hu. ");
INSERT INTO ngp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mnt'hu endile ko mgunda asekuuya kaya kuguha suke yakwe. ");
INSERT INTO ngp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mnaalo wata nda na wadya wakonk'heza niyo wakunga waonese mwe mazuwa ayo! ");
INSERT INTO ngp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mlombezeseni Mnungu mazuwa ayo yanase yalaile mwe nt'hondo. ");
INSERT INTO ngp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwaviya mazuwa ayo nayande na masulumizo, kukongela aho Mnungu aumbile isi mpaka dyelo, naho haaize ilaile vituhu! ");
INSERT INTO ngp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Naho uneva Zumbe hanayakant'hize mazuwa ayo, hahali hata mnt'hu yuwenga akuunga ayokolwe. Mnaalo kwajili ya wadya want'hu wakwe awasagule, kayatenda mazuwa ayo yende mageke. ");
INSERT INTO ngp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mwe mazuwa ayo, uneva mnt'hu anawagambani, ‘Kauleni, Kilisito eyuku!’ Hegu, ‘Ekudya!’ Msekumhuwila.” ");
INSERT INTO ngp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwaviya nawalaile wakilisito wo udat'hi hamwenga na walotezi wo udant'hi. Nawadamanye vilagiso hamwenga na vihungi vileke wawadant'he hata wadya wasagulwe ni Mnungu, vinadahika. ");
INSERT INTO ngp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ivo nyuwe kauliseni! Kwaviya himigambilani kale yadya yakuunga yalaile. ");
INSERT INTO ngp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mwe mazuwa yadya makunt'ho yakaheza, zuwa nadigeligwe lwiza. Mnenge nawo haulave umwanga wakwe, ");
INSERT INTO ngp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nt'hondo nazo nezigwe kulawa kwe mbingu, ludole lwa kwe mbingu nolu singisike. ");
INSERT INTO ngp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aho Mwana wa Mnt'hu naalaile akeza mwa mavunde kwa udahi mkulu no uwedi utendese. ");
INSERT INTO ngp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Naye naasigile mtumigwa ywa kwe mbingu nt'endelo zose za isi vileke wawaduganye want'hu wose wasagulwe ni Mnungu, kulawa nt'hendelo imwenga ya isi mpaka nt'hendelo ya mbingu. ");
INSERT INTO ngp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Hineni hinizo idi dya mliganyizo kulawa ko mtini. Ditambi dyakwe dinanda teke na kusuka mani, mwamanya fula zi hagihi. ");
INSERT INTO ngp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nyuwe nanywe iviya, mnaziona zimbuli izi zikalaila, mmanye Mwana wa Mnt'hu e hagihi ko lwivi kwiza. ");
INSERT INTO ngp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Naho manyeni cheleko iki hechomboke, mpaka ayo yose yakint'he. ");
INSERT INTO ngp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mbingu ne isi nazomboke, mna ulosi wangu hawomboke. ");
INSERT INTO ngp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Hahali mnt'hu yeyose adimanyize dizuwa hegu isa, hi mtumigwa ywa kwe Mbingu hegu Mwana wakumanya, mna ni Tate mwenye du amanyize. ");
INSERT INTO ngp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Indeni meso, mwikale lumwe kwaviya hammanyize isa iyo neizile. ");
INSERT INTO ngp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Neinde enga mnt'hu akuhalawa kaya, awasile wandima awo awenk'hile udahi wa kudamanya. Niyo amsiigila mwamizi ande na wengele. ");
INSERT INTO ngp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Indeni meso, kwaviya hammanyize aho akwizila zumbe mta inyumba, yadaha ikanda nekisingi hegu kilo gati hegu mazilizili hegu kilokilo. ");
INSERT INTO ngp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Anasekwiza luholuho niyo awabwiilani mgona. ");
INSERT INTO ngp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Idi huwagambilani nyuwe nawagambila na want'hu watuhu, indeni meso!” ");
INSERT INTO ngp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nayasigala mazuwa maidi kubula mwe zuwa dya kinyemi dye Pasaka na zuwa dya kinyemi dye mikate heigeligwe ugwadu. Wakulu wa walava nt'hambiko hamwenga na wahinizi wa Sigilizi niyo wazungula sila uleke wamgwile Yesu kwa upapala uleke wamkome. ");
INSERT INTO ngp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nawalonga, “Kisekumgwila mwe wila we Pasaka inase kulaila want'hu wakatenda nk'humbizi.” ");
INSERT INTO ngp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Viya Yesu endile Besania mwe nyumba ya Simoni ahumaga matana, naho andaga akadya, niyo eza mvele yumwenga na kashupa kena mavuta yedi, naho yakuguligwa na matundu mengi. Niyo akagubula kadya kashupa na kuyetila yadya mavuta mo mtwi wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Want'hu wandile hadya nawaihiwa na mbuli idya, niyo wauzana, “Ni mbwai mavuta aya matana yasambazika? ");
INSERT INTO ngp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kwaviya nayakadahika kutagwa kwa utana utendese niyo amatundu ayo wenk'higwa wakiwa.” Niyo wamtivilisa yudya mvele. ");
INSERT INTO ngp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu niyo alonga, “Mlekeni! Kwa mbwai kumvigaviga? Mbuli adamanye kwangu ni mbuli yedi vidala. ");
INSERT INTO ngp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kwaviya mazuwa yose mnanao wakiwa, naho mwadaha kuwambiza lupisi wowose viya mkuunga. Mna miye hakihamwenga mazuwa yose. ");
INSERT INTO ngp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mvele uyu kadamanya viya adahile. Kalongola kuugela mavuta yedi umwili wangu kwa ajili ye kumoswa msanga. ");
INSERT INTO ngp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ikindedi nawagambilani, hohose hadya hakubilikizwa Mbuli Yedi mwe isi yose, ivi adamanye uyu nevilongigwe kwa kumkumbuka.” ");
INSERT INTO ngp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuda Isikaliyote, yumwenga ya wadya wanamp'hina mlongo na waidi niyo waita kwa Wakulu wa walava nt'hambiko vileke amsezenge Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Walava nt'hambiko wakulu weze weve, niyo welelwa, waika ndagano kumwink'ha matundu. Niyo Yuda azungula sila ye kumsezenga Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mwe zuwa dya nk'hongo dye migate heigeligwe ugwadu, zuwa dya kuchinja Mwanangoto wa Pasaka, awanamp'hina wakwe niyo wamuuza, “Ni kuhi ukuunga kiite kikaike lumwe uleke uidye nk'hande ya Pasaka?” ");
INSERT INTO ngp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Niyo awasigila waidi mwe wanamp'hina wakwe, awagamba, “Iteni ko mzi, nambwilane na mgosi enule dibiga dya mazi. Mtongeleni, ");
INSERT INTO ngp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","na hadya akuunga engile, mgambileni mta inyumba, Mhinizi auza, ‘Kikuhi ichumba che wageni uleke niidye nk'hande ye Pasaka hamwenga na wanamp'hina wangu?’ ");
INSERT INTO ngp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yehe mwenye naawalagise chumba kikulu kimnanga kiikigwe lumwe, aho tengeni.” ");
INSERT INTO ngp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wanamp'hina niyo waita ko mzi, niyo wabwila iviya Yesu awagambile. Niyo waikila lumwe ink'hande ya Pasaka. ");
INSERT INTO ngp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ize ibuze nekisingi, Yesu niyo abula hamwenga na wanamp'hina wakwe mlongo na waidi. ");
INSERT INTO ngp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Weze wende mo ukudya, Yesu niyo alonga, “Ikindedi nawagambileni, yumwenga wenyu, naho adya hamwenga name, naanisezenge.” ");
INSERT INTO ngp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Niyo wengilwa ni kinyulu, no kukonga kumuuza Yesu yumwe yumwe, “Haluse ni miye?” ");
INSERT INTO ngp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu niyo awagamba, “Ni yumwenga mwe nyuwe mlongo na waidi, naho yehe akuunga achank'hize hamwenga name mwe kikombe. ");
INSERT INTO ngp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwana wa Mnt'hu aita enga viya awandikilwe. Mna nk'hondo yakwe mnt'hu yudya akumsezenga. Neviwagilwa mnt'hu yudya helekigwa!” ");
INSERT INTO ngp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Viya wandile wakadya, niyo Yesu aguha mgate, auvikila, niyo aubendula na kawenk'ha wanamp'hina wakwe, niyo awagamba, “Guheni, uno nuwo umwili wangu.” ");
INSERT INTO ngp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Akajika niyo aguha ikikombe cha divai, amtogola Mungu na kuwenk'ha, wose niyo wakinyweela. ");
INSERT INTO ngp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Niyo awagamba, “Ino niyo isakame yangu ye ndagano ikwitika kwa want'hu wengi. ");
INSERT INTO ngp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nawagambilani ikindedi, miye heninywele naho icheleko cho mzabibu mpaka zuwa diya huunga nize ninywe wedi vitendese mwe Useuta wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Viya weze wajike ukukema wila, niyo waita kwe lugulu lwe Mizeituni. ");
INSERT INTO ngp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu niyo awagambila, “Kilo cha dyelo, nyose namninyilike, enga viya iwandikwe, ‘Nanimtoe mdimi, na zingoto nazaganyike.’ ");
INSERT INTO ngp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mnaalo ninauyuka, neninawalongoele kwiita Galilaya.” ");
INSERT INTO ngp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo niyo amgamba, “Woseni wananyilika, mna hiyo miye!” ");
INSERT INTO ngp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mnaalo Yesu niyo amgambila, “Ikindedi nakugambila weye, kilo cha dyelo, viya zogolo dikei kwila kaidi, naunilemele malavo nt'hatu.” ");
INSERT INTO ngp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mnaalo Petulo niyo agendeela ukulonga, “Hata naungigwe kubanika hamwenga na weye, hehulemele!” Niyo wanamp'hina wose walonga iivo. ");
INSERT INTO ngp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Niyo waita mpaka hant'hu hakwitangwa Getisemani. Yesu niyo awagambila wanamp'hina wakwe, “Ikaleni aha kidogo uleke nilombeze.” ");
INSERT INTO ngp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Niyo awaguha Petulo na Yakobo hamwenga na Yohana, na akonga kwingila kinyulu na usungu mo umoyo. ");
INSERT INTO ngp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Niyo awagambila, “Usungu nnanawo mwo moyo, ukula vitendese, vikudaha kunikoma. Ikaleni aha mcheleze.” ");
INSERT INTO ngp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Niyo agendeela ludodo, agwa kifudifudi na kulombeza uneva inadahika asekwingila mwe isa idya ya masulumizo. ");
INSERT INTO ngp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Niyo alombeza, “Tate, Aba! Mbuli zose kwako zadahika. Nihausile ikikombe iki cha masulumizo, mna hiyo enga viya huunga miye, mna viya ukuunga weye.” ");
INSERT INTO ngp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aze eze, niyo awabwiila wadya wanamp'hina wakwe watatu wagona nt'hongo. Amgambila Petulo, “Simoni, haluse kugona? Hudahile kucheleza sa dimwenga du?” ");
INSERT INTO ngp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Niyo awagamba wanamp'hina wose, “Lombezeni msekwingila mwo kugezigwa. Muye yaunga, mna umwili uhwa.” ");
INSERT INTO ngp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Niyo aita vituhu kulombeza, na akalonga iviya. ");
INSERT INTO ngp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Niyo eza vituhu na kuwabwila wagona kwaviya meso yawe nayanda yazama. Naho nawanda hawamanyize dya kumgambila. ");
INSERT INTO ngp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Niyo eza malavo ya katatu na kuwagamba, “Haluseelo goneni muhumule. Yakint'ha! Isa ibula, kaula Mwana wa Mnt'hu agelwa mwe mikono ya wata wavu. ");
INSERT INTO ngp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kimaleni! Kiteni! Kauleni yudya akuunga anisezenge e hagihi.” ");
INSERT INTO ngp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Viya endile mo kulonga, Yuda, yumwenga ya wadya wanamp'hina mlongo na waidi niyo abula. Hamwenga na yehe, andaga na fyo dya want'hu wenule mabamba na malungu. Nawasigilwa ni Wakulu wa walava nt'hambiko na wahinizi wa Sigilizi hamwenga na wadala vilongozi. ");
INSERT INTO ngp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda nakawenk'ha kilagiso kugamba, “Yudya huunga ni mlamse kwa kumbusu ni yehe mkumunga, mgwileni na kumwigala kwa kumwamila anase anyilike.” ");
INSERT INTO ngp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ahadya Yuda eze abule, niyo aita kwa Yesu na kugamba, “Mhinizi!” Niyo amlamsa kwa kilagiso cha lukunde ");
INSERT INTO ngp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wadya want'hu niyo wamgwila na kumkaka. ");
INSERT INTO ngp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yumwenga mwe wadya wakimale hadya niyo aguha dibamba dyake, amtowa nadyo mtumwa ywo Mkulu wa walava nt'hambiko na kumsenga digutwi dyakwe. ");
INSERT INTO ngp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu niyo awagamba, “Haluse kwa mbwai kwiza na mabamba na malungu kunigwila miye enga mbavi? ");
INSERT INTO ngp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mazuwa yose nahinda na nyuwe hawahiniza mwe Nyumba ya Mnungu, mna hamnigwiile. Mna aya yalaila vileke Mawandiko Yakukile yakint'he.” ");
INSERT INTO ngp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Niyo wanamp'hina wakwe wose wamleka na kunyilika. ");
INSERT INTO ngp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mbwanga yumwenga akegubike mgolole andaga akamtimila Yesu. Viya wandile wakaunga kumgwila, ");
INSERT INTO ngp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","niyo auleka udya mgolole wakwe, aguluka kimbwigili. ");
INSERT INTO ngp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Niyo wamwigala Yesu kwe inyumba ya Mkulu wa walava nt'hambiko, uko walava nt'hambiko wakulu, wahinizi wa Sigilizi hamwenga na wadala vilongozi wose niyo waduganyika. ");
INSERT INTO ngp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulo nae niyo amtimila Yesu kwa luhalehale, niyo engila ko uwa we nyumba ya Mkulu wa walava nt'hambiko niyo ekala hamwenga na wamizi, akotela moto. ");
INSERT INTO ngp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Niyo Wakulu wa walava nt'hambiko hamwenga na want'hu wose we Kitala che Wayahudi dya wayahudi wazungula uwona uleke wamkome Yesu, mnaalo hawaone. ");
INSERT INTO ngp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Want'hu wengi nawamlongela Yesu mbuli zo udant'hi, mnaalo uwona wawe hauligane. ");
INSERT INTO ngp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mna want'hu watuhu niyo wakimala wakamlongela mbuli zo udant'hi kugamba, ");
INSERT INTO ngp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Suwe nakimwiva akalonga, ‘Miye neniimole ino Nyumba nk'hulu ya Mnungu idamanywe kwe mikono ya want'hu, naho mwe mazuwa matatu, nenizenge nyumba nt'huhu heizengigwe kwe mikono ya want'hu.’ ” ");
INSERT INTO ngp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mna hata ivo uwona uwo haupatikane. ");
INSERT INTO ngp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Niyo Mkulu wa walava nt'hambiko, akimaala hagati na kumuuza Yesu, “Haukuhitula kint'hu chochose mwa ayo wakukulongeleza?” ");
INSERT INTO ngp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mna yehe niyo anyamala, hawahitule kint'hu chochose. Mkulu wa walava nt'hambiko niyo amuuza vituhu, “Weye nie Kilisito, Mwana wakwe Mnungu Mtogolwa?” ");
INSERT INTO ngp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu niyo agamba, “Heye, miye ni yehe! Nanywe nyose nomumuwone Mwana wa Mnt'hu kekala kulume kwa Mnungu Mta Udahi, naho nommuwone akeza mwa mavunde ya kwe mbingu.” ");
INSERT INTO ngp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mkulu wa walava nt'hambiko niyo atatula suke yakwe na kugamba, “Hakikuunga naho uwona wowose! ");
INSERT INTO ngp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwiva ivo akumlonga vihile Mnungu. Haluse mwagaaze mwa yehe?” Wose wamsengela akomwe. ");
INSERT INTO ngp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Want'hu watuhu niyo wakonga kumtweela mate, naho nawamsint'ha kwa meso na kumtoa na kumgamba, “Lotela ni ani akutoile?” Niyo wank'hondo wamguha na kumtoa mikotya. ");
INSERT INTO ngp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Umwo Petulo endaga akei hadya ho uwa, mvele yumwenga andaga mtumwa ywa Mkulu wa walava nt'hambiko amwizilaga. ");
INSERT INTO ngp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Eze amwone Petulo akotela moto, niyo amkaulisa na kumgamba, “Weye nawe nokunda hamwenga na Yesu Mnazaleti.” ");
INSERT INTO ngp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mna Petulo niyo alemela na kugamba, “Himmanyize naho hikukombaganya kiya ukulonga.” Niyo afosa hadya he nk'hili, na ahadya dizogolo niyo dyaila. ");
INSERT INTO ngp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yudya mndima eze amuone hadya andile, akongaga kuuiya kulonga kwa wadya wakimale hadya akagamba, “Uyu naye ni yumwenga mwa woho.” ");
INSERT INTO ngp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petulo niyo alemela naho. Ludodo ahadya naho, niyo wadya wakimale hagihi na Petulo wamgamba, “Hukudaha kulemela kugamba weye hwi yumwenga mwa woho, kwaviya weye nawe wi Mgalilaya.” ");
INSERT INTO ngp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petulo niyo akelisa kugamba, “Namigambilani ikindedi, Mnungu naanik'he diihiye uneva hikulonga kindedi! Himmanyize uyo mkulonga zimbuli zakwe!” ");
INSERT INTO ngp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ahadya niyo zogolo dyaila kaidi, niyo Petulo akumbukila viya Yesu amgambilaga, “Kilo cha diyelo, viya zogolo dikei kwila kaidi, naunilemele malavo nt'hatu.” Petulo eze akumbukile ailisaga. ");
INSERT INTO ngp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mtondotondo, Wakulu wa walava nt'hambiko, wadala vilongozi, wahinizi wa Sigilizi hamwenga na wat'hu wose wa kitala nawaika waikaga mzungu. Weze wajike niyo want'hu wamgela sigi Yesu na kumwigala kwa Pilato. ");
INSERT INTO ngp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato niyo amuuza Yesu, “Weye niye zumbe we Wayahudi?” Yesu niyo amhitula, “Heiye, enga ivo ukulonga weye.” ");
INSERT INTO ngp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wakulu wa walava nt'hambiko niyo wamziga Yesu kwa kumlongela mbuli nyingi. ");
INSERT INTO ngp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato niyo amuuza Yesu vituhu, “Hukuunga kuhitula mbuli! Hukuona weyao ivo wakukulongeleza kwa mbuli nyingi?” ");
INSERT INTO ngp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu niyo agendeela kunyamala, Pilato niyo ehelwa. ");
INSERT INTO ngp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato azoelaga kumlekela mvugailwa yumwenga want'hu wakumuunga mwe kila zuwa dya kinyemi dye Pasaka. ");
INSERT INTO ngp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mwe lupisi icho, nahenda na mnt'hu yumwenga endile mwe divugailo akwitangwa Balaba. Yehe hamwenga na wat'hu watuhu nawasaguka hamwenga na kukoma wat'hu. ");
INSERT INTO ngp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Want'hu niyo wamwizila Pilato na kumlombeza vileke awakomwoele mtumwa yumwanga enga viya akutendaga. ");
INSERT INTO ngp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato niyo awauza wadya want'hu, “Haluse mwaunga miye nimkomoele zumbe we Wayahudi?” ");
INSERT INTO ngp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nakalonga ivo kwaviya nakamanya wakulu wa walava nt'hambiko nawamlava Yesu kwa kumuwonela finju. ");
INSERT INTO ngp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mna wakulu wa walava nt'hambiko wawatigiza want'hu wamgambile Pilato awakomoele Balaba. ");
INSERT INTO ngp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Niyo Pilato awauza vituhu, “Haluse mwaunga miye nidamanye mbwai na uyu mkumwitanga zumbe we Wayahudi?” ");
INSERT INTO ngp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Niyo watoa lwasu, “Muwambe mo mti wa masulmizo!” ");
INSERT INTO ngp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato niyo awauza naho vituhu, “Viya ni wiihi wani uwo adamanye?” Mna niyo wose kwa hamwenga watoa lwasu kugamba, “Awambigwe mo msalaba!” ");
INSERT INTO ngp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato nakaunga awabwedeze wadya want'hu, niyo amkomoela Balaba. Niyo amlava Yesu atoigwe mikotya, akajika awambigwe mo mti wa masulmizo. ");
INSERT INTO ngp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wank'hondo niyo wamguha Yesu na kumwigala kwe nk'hili ya nyumba ya Pilato, mkulu we isi. Niyo want'hu wose we kitala wadugana hamwenga. ");
INSERT INTO ngp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Niyo wamvala suke ya langi ye zambalau, niyo wadamanya taji ya miwa, no kumvala Yesu mwo mtwi. ");
INSERT INTO ngp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Naho wakongaga kumlamsa kwa kumbela, “Ndamsa, Zumbe ywa Wayahudi!” ");
INSERT INTO ngp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Niyo wamtoa na ngoda mo mtwi, wamtweela mate, no wamfikila madi na kumfunamila. ");
INSERT INTO ngp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Weze wajike kumbela, niyo wamhambula idya suke ye zambalau, niyo wamvala zisuke zakwe ye mwenye na kumguha kuse vileke wamuwambe mo mti wa masulmizo. ");
INSERT INTO ngp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mwe sila, niyo wadugana na mnt'hu yumwenga akwitangwa Simoni, mnt'hu ywa isi ya Kilene, tati yawe Alekizanda na Lufo. Mnt'hu uyo naakalawa kwe nk'honde naakaita mo mzi. Niyo wamkakalisa enule msalaba wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Niyo wamwigala Yesu mpaka hant'hu hakwitangwa Goligota, nuko kugamba “Hant'hu ha Kibela.” ");
INSERT INTO ngp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Niyo wamwink'ha divai ihangaywe na mti wa kunywa ukwitangwa manemane, mna Yesu kalemela kuinywa. ");
INSERT INTO ngp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Niyo wamuwamba no kuzitoela kula zisuke zakwe kwa kupilisa tundu kugamba yuhi enk'higwe ihi. ");
INSERT INTO ngp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Naho nainda yabula saa nt'hatu mtondo hadya wamuwambile mo mti wa masulmizo. ");
INSERT INTO ngp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Halanga ho msalaba hawandikagwa mbuli zikumlongeleza. “Seuta ywa Wayahudi.” ");
INSERT INTO ngp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hamwenga na yehe, nahanda na wabavi waidi wawambigwe mwe viwambilo, yumwenga mkono wake wa kulume na mtuhu mkono wakwe wa kumoso. ");
INSERT INTO ngp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ivo, Mawandiko yakint'ha yadya yakugamba, “Nakawambigwa hamwenga na wata uwavu.” ");
INSERT INTO ngp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Want'hu wandile wakomboka mwe sila, nawakamhomola wakasingisasingisa mitwi yawe wakagamba, “Ha! Weye ukudaha kuimola Nyumba nk'hulu ya Mnungu na kuizenga mwe mazuwa matatu! ");
INSERT INTO ngp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kehonye we mwenye, usele aho he msalaba!” ");
INSERT INTO ngp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wakulu wa walava nt'hambiko hamwenga na wahinizi wa Sigilizi niyo wambela Yesu wakalonga woho kwa woho, “Nakahonya watuhu, mna hakudaha kukehonya yehe mwenye! ");
INSERT INTO ngp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Leka kimuwone Kilisito, zumbe wa Waizilaeli aseele kulawa mwo msalaba mo mti wa masulmizo, naswe nekimhuwile!” Wadya want'hu waidi wawambigwe mwe viwambilo hamwenga na Yesu nawo niyo wamliga. ");
INSERT INTO ngp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ize ibuze saa mtandatu nomsi, niyo handa na lwiza mwe isi yose, naho mpaka saa kanda nomsi. ");
INSERT INTO ngp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa kanda nomsi, Yesu niyo alonga kwa izwi kulu kugamba, “Eloi, Eloi, lama sabakitani?” Nuko kugamba, “Mnungu wangu, Mnungu wangu, nii kunasa?” ");
INSERT INTO ngp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Want'hu watuhu wandile hadya niyo wagamba, “Tegelezeni, amwitanga Eliya!” ");
INSERT INTO ngp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mnt'hu yumwenga niyo aguluka na kumemeza divai igwaduke mwe disambu, niyo adigela kulanga kwe mwanzi na kumywesa Yesu, niyo agamba, “Lekeni kikaule uneva Eliya neze kumseleza mo mti wa masulmizo!” ");
INSERT INTO ngp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu niyo alava izwi kulu, niyo aseleza umoyo. ");
INSERT INTO ngp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dipazia dye Nyumba nk'hulu ya Mnungu niyo dyatatuka vipande viidi kulawa kulanga mpaka hasi. ");
INSERT INTO ngp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mkulu yumwenga wa wank'hondo akimale hadya eze aone viya Yesu akaseleza umoyo, niyo agamba, “Ikindedi, mnt'hu uyu andaga Mwana wa Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nahanda na wavele wakimale kwa hale wakakaula. Wavele awo nawanda ni Maliamu Magedalena, Maliamu mami yawe dya Yakobo mdodo na Yose hamwenga na Salome. ");
INSERT INTO ngp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wano niyo watimilane naye viya andile Galilaya na kumtuma. Wavele watuhu wengi wezile naye kulawa Yelusalemu nawanda ahadya. ");
INSERT INTO ngp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Neinda kisingi cha Zuwa dya kwika lumwe kwe dizuwa dya Kuhumula. ");
INSERT INTO ngp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusufu akulawa ko mzi wa Alimatayo, mnt'hu we kitala che Wayahudi akutegelezeswa niyo abula. Mnt'hu uyo naakagoja kwiza ko Useuta wa Mnungu. Niyo ambasa Pilato haheina kogoha na kumlombeza amwink'he umwili wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato niyo ehelwa kwiva Yesu kabanika kale. Niyo amwitanga mkulu wa wank'hondo na kumuuza uneva Yesu kabanika kale. ");
INSERT INTO ngp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Naye eze agambilwe ni yudya mnk'hondo kugamba kindedi Yesu kabanika kale, niyo amgamba Yusufu akauguhe umwili wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu niyo agula isanda, auseleza umwili wa Yesu hadya halanga na kuuvika sanda. Niyo auwika mwe kikuta kisongolwe mwe diiwe dikulu. Akajika, atongolosa iwe kulu na kudiika mo umnango wa kiya kikuta. ");
INSERT INTO ngp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliamu Magedalena hamwenga na Maliamu nine dya Yose wa haona hant'hu hadya uikigwe umwili wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dizuwa dya Kuhumula dize dyomboke, Maliamu Magedalena na Maliamu nine dya Yakobo hamwenga na Salome niyo wagula mavuta yedi uleke wakahake mavuta umwili wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mazilizili mwe dizuwa dya nk'hongo, idyo nidyo Jumapili na waita kwe kikuta. ");
INSERT INTO ngp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Umwo wandile mwe sila, nawakeuza woho wenye, “Ni ani akuunga akakitongolosele diiwe diya mo mnango we kikuta?” ");
INSERT INTO ngp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mna weze wakaule, niyo waona diiwe diya dikulu dyandile hadya ho mnango wa kikuta ditongoloswa kale. ");
INSERT INTO ngp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Niyo wengila mwe kikuta no kumbwiila ndugu ywetu availe zisuke zing'alise. ");
INSERT INTO ngp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Niyo awagamba, “Msekwehelwa, himanya mwamzungula Yesu Mnazaleti andile kawambigwa. Hahali aha, kauyuka! Kauleni hant'hu wamwikile. ");
INSERT INTO ngp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Haluse iteni mkawagambile wanamp'hina wakwe hamwenga na Petulo kugamba, ‘Yesu kawalongoela kwiita Galilaya, kudya nomkamuwone enga viya awagambilagani.’ ” ");
INSERT INTO ngp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Niyo wafosa kuse ye kikuta, niyo waguluka uku wakazingiza na kwehelwa. Hawamgambilga mnt'hu yeyose mbuli idya kwaviya nawakogoha. ");
INSERT INTO ngp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu eze auyuke kulawa mwe file, mtootondo mwe dizuwa dya pili, niyo amlaila Maliamu Magedalena, yudya amlavaga mp'hepo mfungate. ");
INSERT INTO ngp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yudya mvele nae niyo aita na kuwagambila weyawe, wadya andile wakagendeela kuila na kuhongeza. ");
INSERT INTO ngp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Weze weve viya akulonga Yesu kauyuka naho kamlaila, hawahuwile. ");
INSERT INTO ngp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Niho elo Yesu awalaila wanamp'hina wakwe waidi mwe futa nt'huhu viya wandile mwe sila wakaita kwe kaya. ");
INSERT INTO ngp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Niyo wauya na kuwagambila wadya watuhu wamtimile Yesu, mna woho hawahuwile. ");
INSERT INTO ngp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Niho elo Yesu awalaila wanamp'hina mlongo na yumwenga Umwo wandile wakadya. Niyo awativila kwaviya waswesile mhuwi, naho nawanda wadala kuwahuwilai wadya wamuwone. ");
INSERT INTO ngp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Niyo awagamba, “Iteni mwe isi yose mkabilikize Mbuli Yedi kwa want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mnt'hu yeyose naahuwile na kubatizwa, naayokolwe, mna mnt'hu yeyose heekuhuwila naasengelwe. ");
INSERT INTO ngp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wadya wakuhuwila naweenk'higwe udahi wo kudamanya vilagiso, kwa zina dyangu, nawalave mp'hepo, na nawalonge kwa milosi mihya. ");
INSERT INTO ngp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wanatoza nyoka hamwenga na kunywa kint'hu chochose cha kukoma, hawakudaha kubanangwa. Nawageleke mikono mwa wanyonge, na wanyonge nao nawahone.” ");
INSERT INTO ngp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ivo Zumbe Yesu eze ajink'he kulonga na woho, niyo enulwa kulanga kwe mbingu no kwikala kulume kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wana mp'hina niyo waita na kubilikiza Mbuli Yedi kila hant'hu. Naho Zumbe nakadamanya ndima na wa woho, na kalagisa kugamba e hamwenga na woho kwe vilagiso nevitimilane ne milosi yawe.");
INSERT INTO ngp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mkulu Teofilo Want'hu wengi wagezaga vedi kwaviya wadahile kuwandika izimbuli ze vint'hu vilaile mgati mwetu. ");
INSERT INTO ngp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wawandikaga vint'hu viya kisimuilwe ni wadya waonaga vint'hu ivo kukongela nk'hongo, na wadya wabilikizaga Imbuli Yedi. ");
INSERT INTO ngp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kwa ivo mkulu Teofilo, kwaviya name hizungula ukindedi we zimbuli izi kukongela nk'hongo, hiona vedi niwawandikile kwa uwedi vint'hu ivo vose vilaile. ");
INSERT INTO ngp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hitenda ivi vileke weye nawe umanye kindedi che vint'hu vose uhinizwe. ");
INSERT INTO ngp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Umwo Helode andaga seuta ywa Uyahudi, handaga na mlava nt'hambiko zina dyakwe Zakalia. Uyo andaga yumwenga mwe difyo dya walava nt'hambiko dya Abiya. Mkaziwe etangagwa Elizabeti, naye andaga ni ywa lukolo lwa mlava nt'hambiko etangwe Haluni. ");
INSERT INTO ngp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wose waidi wandaga wazumilwa kunda wedi ha meso ha Mnungu, naho waitozaga kwa kindedi Imiko yose ya Zumbe. ");
INSERT INTO ngp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wandaga hawana mwana kwaviya Elizabeti andaga hana cheleko, naho wose waidi wadalahalisaga. ");
INSERT INTO ngp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zuwa dimwenga Zakalia andaga mwe Nyumba nk'hulu ya Mnungu akadamanya ndima yakwe yo ulava nt'hambiko, enga viya akudamanyaga mwo luzo lwakwe. ");
INSERT INTO ngp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Enga viya chandile kihendo cha walava nt'hambiko, usaguzi umgweela Zakalia kwingila mwe Nyumba nk'hulu ya Zumbe kufunk'hiza ubani. ");
INSERT INTO ngp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Fyo dya want'hu dyandaga dikuse dimlombeza Mnungu umo ubani wandaga ukafunk'hizwa. ");
INSERT INTO ngp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Niyo mtumigwa ywa Zumbe amlaila no kukimala hakulume he kilingo cho kufunk'hizila ubani. ");
INSERT INTO ngp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia eze amuone, niyo etuka na kwingilwa ni wogofi. ");
INSERT INTO ngp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mna yudya mtumigwa ywa kwe Mbingu niyo amgamba Zakalia, “Usekogoha! Mnungu keva kulombeza kwako. Mkazio Elizabeti naakwelekele mwana kilume, nawe noumwitange Yohana. ");
INSERT INTO ngp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Weye nawe nounde na kinyemi na kusekeela, naho want'hu wose nawande na kinyemi kwa kwelekwa kwakwe. ");
INSERT INTO ngp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Naande mkulu ha meso ha Zumbe, naho haanywe divai hegu mp'hombe. Naamemezwe Muye ywa Mnungu kukongela dizuwa dyo kwelekwa kwakwe. ");
INSERT INTO ngp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Naawavuze want'hu wengi wa Izilaeli kwa Zumbe Mnungu ywawe. ");
INSERT INTO ngp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Naye naamlongoele Zumbe kwa Muye wa Eliya no ludole lwakwe vileke aihitule mioyo ya welesi waivane na wana wawe no kuwagela want'hu wasaguke ubala wa want'hu watendigwe kunda wedi hameso ha Mnungu no kumwiikila Mnungu want'hu waikilwe lumwe.” ");
INSERT INTO ngp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia niyo amgamba mtumigwa ywa kwe Mbingu, “Nenimanye vivihi zimbuli izi? Miye hidalahala, naho hata mkazangu naye kadalahala.” ");
INSERT INTO ngp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mtumigwa ywa kwe mbingu niyo amgamba, “Ni miye Gabilieli hukimala hameso ha Mnungu anitumile nize nilonge na weye na kukugambila mbuli ino iyedi. ");
INSERT INTO ngp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mna kwaviya huhuwile ulosi wangu, houdahe kulonga kubula mwe dizuwa idyo, aho zimbuli izo nezilaile.” ");
INSERT INTO ngp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Want'hu wandile kuse wakamgoja Zakalia, niyo weheelwa kwaviya ekalise kufosa kwe Nyumba ink'hulu ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eze afosele kuse, niyo anda hakudaha kulonga nawo. Woho nawo niyo wabunk'hula kugamba nakaona maona mwe Nyumba nk'hulu ya Mnungu. Kwaviya hadahile kulonga, naakalonga nawo kwa vilagiso. ");
INSERT INTO ngp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakalia eze abinde indima yakwe niyo auya kaya. ");
INSERT INTO ngp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yeze yomboke mazuwa mageke, Elizabeti uyo mkaziwe niyo enula nda, niyo yanda hahalaile he nyumba yakwe kwa miezi mishano. ");
INSERT INTO ngp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Niyo agamba, “Zumbe kanidamanyila mbuli ino! Haluse kanionela mbazi, naho kaniusila soni zangu mwa want'hu.” ");
INSERT INTO ngp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mwo mwezi wa mtandatu wo ubovu wa Elizabeti, Mnungu amtumaga mtumigwa ywa kwe Mbingu etangwe Gabilieli kwe isi ye Galilaya, mwo mzi ukwitangwa Nazaleti. ");
INSERT INTO ngp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nakanda na ulosi kwa mwali na mazanga akwitangwa Maliamu. Mndele uyu andaga katumizwa ni mgosi yumwenga etangagwa Yusufu, andaga ywo lukolo lwa zumbe Daudi. ");
INSERT INTO ngp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mtumigwa ywa kwe mbingu niyo amwizila mwali uyo niyo amgamba, “Ndamsa! Zumbe e hamwenga na weye, naho kakuvikila vitendese.” ");
INSERT INTO ngp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliamu niyo engilwa ni kinyulu kwa udya ulosi wa mtumigwa ywa kwe mbingu, naho niyo ehelwa mbuli idya nivo yagaaze. ");
INSERT INTO ngp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mna mtumigwa ywa kwe mbingu niyo amgamba, “Maliamu, usekogoha! Mnungu kakulagisa uwedi wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kaula, nowinule nda, naho noweleke mwana kilume, zina dyakwe noumwitange Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Naande mkulu naho neetangwe Mwana ywa Mnungu e Kulanga. Zumbe Mnungu naamwink'he difumbi dyo useuta enga viya andaga mkale ywakwe Daudi. ");
INSERT INTO ngp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Naande Seuta we cheleko cha Yakobo mazuwa yose, naho uzumbe wakwe wa ulo na ulo!” ");
INSERT INTO ngp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliamu niyo amgamba yudya mtumigwa ywa kwe mbingu, “Miye ni mwali na mazanga. Elo neinde vihi mbuli ino?” ");
INSERT INTO ngp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mtumigwa ywa kwe mbingu niyo amhitula, “Muye ywa Mnungu naakwizile, naho ludole lwa Mnungu ekulanga nelukugubike. Kwaivo mwana akuunga elekwe neetangwe, akukile Mwana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Naho, kaula nduguyo Elizabeti kenula ubovu wa mwana kilume mwo udala wakwe naho uno ni mwezi wa mtandatu. Naakalongwa hakudaha kweleka, mna ivi haluse mbovu ywa miezi mtandatu iivo adalahale. ");
INSERT INTO ngp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwaviya hadihali Mnungu heekudaha kudidamanya!” ");
INSERT INTO ngp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliamu niyo amgamba, “Miye ni mndima ywa Zumbe, nevinde kwangu enga ivo ukulonga.” Mtumigwa ywa kwe mbingu niyo ahalawa no kuita. ");
INSERT INTO ngp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Akajika aho, Maliamu niyo akeika lumwe na kutenda ludole kwita ko mzi umwe vigulu va isi ya Uyahudi. ");
INSERT INTO ngp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Niyo engila kwe nyumba ye Zakalia niyo kumlamsa Elizabeti. ");
INSERT INTO ngp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti eze eve Maliamu akamlamsa, kazana niyo katugusa mwe inda mwakwe. Elizabeti nakamemezwa Muye ywa Mnungu, ");
INSERT INTO ngp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","niyo alonga kwa izwi kulu, “Weye kuvikilwa kujink'ha wavele wose, na mwana ukuunga umweleke kavikilwa! ");
INSERT INTO ngp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nii mbuli ino ink'hulu ikanilaila miye, nine dya Zumbe ywangu kwiza kunitalamkila? ");
INSERT INTO ngp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nize nive du indamsa yako, kazana kwe zinda zangu niyo katugusa kwa kinyemi. ");
INSERT INTO ngp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kaula kinyemi unanacho weye uhuwile mbuli ya Zumbe, kwaviya neinde kindedi kwako.” ");
INSERT INTO ngp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliamu niyo agamba, “Moyo wangu wamtogola Zumbe, ");
INSERT INTO ngp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","no muye wangu welelwa kwa mbuli ya Mnungu, Mlokozi ywangu, ");
INSERT INTO ngp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kwaviya anikumbukile, mndima ywakwe mkiwa! Kukongela dielo na kugendeela, want'hu wose nawanitange mvikilwa, ");
INSERT INTO ngp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwe zimbuli zakwe zink'hulu Mnungu wo Udahi anidamanyile. Zina dya Mnungu dikuka. ");
INSERT INTO ngp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kukongela cheleko iki na kugendeela kalagisa mbazi kwa wadya wakumhuwila. ");
INSERT INTO ngp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kadamanya vint'hu vikulu kwa mkono wakwe. Kawatenda wasambale wadya wakukefenya mwe mioyo yawe. ");
INSERT INTO ngp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawakinya maseuta kulawa mwe difumbi dyo useuta, na kuwenula want'hu waoneke kunda wasokezi. ");
INSERT INTO ngp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kawegusa wata sala kwa vint'hu vedi, naho kawagulusa wagoli heweena kint'hu. ");
INSERT INTO ngp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kamwambiza mtumwa ywakwe Izilaeli, naho hajaile kulagisa zimbazi zakwe ");
INSERT INTO ngp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kwa tati yetu Ibulahimu, hamwenga na cheleko chakwe ulo na ulo!” ");
INSERT INTO ngp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliamu nakekala na Elizbeti miezi mitatu, niyo auya kaya kwakwe. ");
INSERT INTO ngp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lupisi lwa Elizabeti wa kweleka uze ubule, niyo eleka mwana kilume. ");
INSERT INTO ngp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Want'hu we haguhi naye hamwenga na wanduguze weze weve ivo Zumbe kamuwonela mbazi, niyo wanda na kinyemi hamwenga naye. ");
INSERT INTO ngp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Umwana eze abule mazuwa mnane, niyo want'hu wagenda kumvina. Waungaga wamwink'he zina niye Zakalia, idizina dya ise. ");
INSERT INTO ngp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mna nine niyo alemela no kuwagamba, “Bule! Dizina dyakwe neetangwe Yohana.” ");
INSERT INTO ngp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Niyo wamgamba, “Mna hahali mnt'hu mwe lukolo lwenyu mta dizina idyo?” ");
INSERT INTO ngp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Niyo wamuuza ise kwa vilagiso vileke awagambile kugamba umwana etangwe ani. ");
INSERT INTO ngp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalia niyo alombeza kabao kakwe kwo kuwandikila, niyo awandika mwe kabao kadya, “Zina dyakwe ni Yohana.” Want'hu wose niyo weheleswa! ");
INSERT INTO ngp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ahadya Zakalia niyo apata udahi wa kulonga naho, naho niyo akonga kumtogola Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Want'hu we haguhi naye niyo wengilwa ni wogofi, niyo imbuli idya yagendezwa mwe vigulu ve isi ya Uyahudi. ");
INSERT INTO ngp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na wose wevile zimbuli izo niyo nawakeuza mwe mioyo yawe, “Mwana uyu na ande mwana ywa vivihi? Kwaviya ludole lwa Zumbe lwihamwenga na yehe.” ");
INSERT INTO ngp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia, ise dya Yohana niyo amemezwa Muye ywa Mnungu, niyo akonga kulotela. ");
INSERT INTO ngp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Atogolwe Zumbe, Mnungu ywa Izilaeli! Kwaviya keza kuwambiza want'hu wakwe no kuwakombola. ");
INSERT INTO ngp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kakikimalisila uyokozi una ludole, mwe nyumba ya Daudi mndima ywakwe. ");
INSERT INTO ngp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Enga viya alongaga kwa milomo ya walotezi wakwe wakukile kukongela uko kale ");
INSERT INTO ngp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kugamba naakiyokole kulawa mwa wank'hondo wetu, na kulawa mwo ludole lwa wadya wose wakukiihiya. ");
INSERT INTO ngp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nakagamba nawaonele mbazi wakale wetu, naho naakumbukile ndagano yakwe ikukile. ");
INSERT INTO ngp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nakamlapila Ibulahimu mkale ywetu ");
INSERT INTO ngp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kugamba naakikombole suwe kulawa mwe mikono ya waihi wetu. Naho naakitende kidahe kumdamanyila ndima haheina wogofi, ");
INSERT INTO ngp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kwa kukuka na kuzumilwa kunda wedi hameso hakwe, mwa mazuwa yose yo ugima wetu. ");
INSERT INTO ngp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nawe mwanangu, nowitangwe mlotezi ywa Mnungu ekulanga vitendese. Kwaviya noumlongoele Zumbe, umdamanyile isila, ");
INSERT INTO ngp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kuwagambila want'hu wakwe kugamba nawayokolwe, kwa kuusilwa wavu wawe. ");
INSERT INTO ngp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mnungu ywetu ana mbazi na moyo wedi. Naakimulikele ung'azi wa ukombola kulawa kulanga, ");
INSERT INTO ngp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kuwamulikila want'hu wose wakwikala kwe kizuli che file, na kuzilongoza nk'hacho zetu mwe sila ya utondowazi.” ");
INSERT INTO ngp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yudya mwana niyo akula akongozekela umwili hamwenga no muye. Niyo ekala kwe nyika mpaka mwe dizuwa diya awalailaga want'hu wa Izilaeli. ");
INSERT INTO ngp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mazuwa yadya, Agusto, seuta ywa Kilumi asigiilaga kugamba luwandikwe ludongo lwa mazina ya want'hu wose mwe isi zose. ");
INSERT INTO ngp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ludongo ulu nulo lwandaga lwa nk'hongo want'hu kuwazigwa, aho Kolinelio andaga mkulu wa isi ya Silia. ");
INSERT INTO ngp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ivo want'hu wose niyo wagenda kuwazigwa kwawe kila yumwenga. ");
INSERT INTO ngp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu naye ahalawaga kwo mzi wa Nazaleti mwo mkowa wa Galilaya, niyo akwela kuita Uyahudi mwo mzi wa Betelehemu, hant'hu elekagwa zumbe Daudi. Nakaita ukwo kwaviya yehe andaga mwo lukolo lwa Daudi ");
INSERT INTO ngp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","vileke awandikwe hamwenga na Maliamu, uyo amposaga, mna andaga mbovu. ");
INSERT INTO ngp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Umwo wandaga uukwo, mazuwa ya Maliamu yo kwingila nyumba yabulaga. ");
INSERT INTO ngp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Niyo amweleka mwana kilume wa nk'hongo, no kumvika suke za kititi, niyo amtambalika mwo luhondo lwo kudiila ng'ombe kwaviya hahandaga na hant'hu mwe nyumba ya wageni. ");
INSERT INTO ngp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Naho mwe isi idya kwandaga na wadimi wakwikala mwe zink'honde wakudima ngoto zawe kwa luzo nekilo. ");
INSERT INTO ngp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Niyo mtumigwa ywa kwe mbingu awalaila, uwedi wa zumbe utendese wa Zumbe niyo wawang'aila nt'hendelo zose, niyo wengilwa ni wogofi mkulu. ");
INSERT INTO ngp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yudya mtumigwa ywa kwe mbingu niyo awagamba, “Msekogoha! Nawegailani mbuli yedi ya kinyemi kikulu kwa want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kwaviya dielo mwo mzi wa Daudi kelekwa Myokozi ywenyu, nuyo Zumbe Kilisito. ");
INSERT INTO ngp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na iki nicho kilagiso kwenyu. Namumbwile mwana, kavikigwa suke za mwana, naho katambalikwa mwo luhondo lwo kudiila ng'ombe.” ");
INSERT INTO ngp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ahadya fyo kulu dya watumigwa wa kwe mbingu kulawa kulanga dyadugana na yudya mtumigwa yumwenga, niyo wakonga kumtogola Mnungu wakagamba, ");
INSERT INTO ngp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Uwedi utendese ni wa Mnungu ywa kwe mbingu, na utondowazi kwa want'hu elelwe nawo mwe isi!” ");
INSERT INTO ngp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Watumigwa wadya weze wauye Kulanga, wadya wadimi niyo wagambana, “Haya kiteni mpaka Betelehemu kikakaule idyo dilaile, kigambilwe ni Zumbe.” ");
INSERT INTO ngp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Niyo wasunguza kuita, wawabwila Maliamu hamwenga na Yusufu na yudya mwana katiti katambalikwa mwo luhondo lwo kudiila ng'ombe. ");
INSERT INTO ngp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wadimi awo weze wakaone katiti niyo wasimuila viya mtumigwa ywa kwe mbingu awagambile mwe mbuli ya yudya mwana katiti. ");
INSERT INTO ngp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wose wevile niyo wehelwa kwa ayo wagambilwe ni wadimi. ");
INSERT INTO ngp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mna Maliamu niyo awiika ulosi uwo wose akaufanyanya mwo moyo wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wadya wadimi niyo wauya kwe nyika, wakamwink'ha uwedi utendese na kumtogola Mnungu kwa mbuli zose wevile na kuwona enga ivo mtumigwa ywa kwe mbingu awagambilaga. ");
INSERT INTO ngp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yeze yabule mazuwa mnane, zuwa dyo kumvina mwana dize dibule, niyo wamwink'ha zina niye Yesu. Dizina idyo nakenk'higwa ni mtumigwa ywa kwe Mbingu kukongela aho andaga akei kwelekwa. ");
INSERT INTO ngp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lupisi lwabulaga lwa Yusufu hamwenga na Maliamu kudamanya kihendo cho kukukizwa enga viya miko ya Musa ivo ikulonga. Niyo wamguha umwana na kumwigala kwo mzi wa Yelusalemu kumwigala kwa Zumbe ");
INSERT INTO ngp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","enga viya iwandikwe mwe miko ya Zumbe kugamba, “Kila mwana kilume kifungula nda aungwa kwigalwa hameso ya Zumbe.” ");
INSERT INTO ngp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Niyo wagenda kulava malavo enga viya ikuungwa mwe miko ya Zumbe. “Suwa mbili hegu makinda maidi ya mp'hugi.” ");
INSERT INTO ngp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mwo lupisi kiya, hadya Yelusalemu handaga na mnt'hu yumwenga zina dyakwe Simioni. Mnt'hu uyo andaga ywedi, akumwogoha Mnungu. Naakagoja kwiza kwo kusangalazwa kwa wa Izilaeli, na Muye ywa Mnungu andaga na yehe. ");
INSERT INTO ngp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Naye nakagambilwa ni Muye ywa Mnungu kugamba haabanike uneva akei kumuwona Kilisito ywa Zumbe. ");
INSERT INTO ngp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Welesi wa Yesu weze wamwigale umwana kwe Nyumba Ink'hulu ya Mnungu vileke wamdamanyile enga ivo miko ya Musa ikuwaunga, niyo Muye ywa Mnungu amlongoza Simoni kwingila kwe nyumba iyo Ink'hulu ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni niyo amhokela umwana mwe mikono yakwe, niyo amtogola Mnungu akagamba, ");
INSERT INTO ngp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Haluse Zumbe mlekele mtumwa ywako aite mp'heho, enga ivo ulongile. ");
INSERT INTO ngp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwaviya kwa meso yangu hiuona ukombola wako, ");
INSERT INTO ngp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","uutendile uoneke kwa want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ung'azi wa kulagisa viya ukuunga weye kwa want'hu hi Wayahudi, no kunda uwedi utendese wako kwa want'hu wako wa Izilaeli.” ");
INSERT INTO ngp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ise na nine ywa Yesu niyo wehelwa kwa yadya yandile yakalongwa ni Simoni. ");
INSERT INTO ngp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioni niyo awavikila, akamgamba Maliamu nine dya Yesu, “Kaula, mwana uyu kasagulwa ni Mnungu kwa kugwa na kwinuka kwa want'hu wengi mwe Izilaeli. Naande kilagiso kulawa kwa Mnungu, na want'hu wengi nawamnemele. ");
INSERT INTO ngp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","We mwenye nawe dibamba nadikwingile mo umoyo wako vileke zigubulwe fanyanyi za mioyo mingi.” ");
INSERT INTO ngp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nahanda na mlotezi yumwenga we kivele, dizina dyakwe Ana mwana wa Fanueli we kabila dya Asheli. Mvele uyu nakekala na mgosi kwa myaka mfungate kukongela ukulombigwa kwakwe. ");
INSERT INTO ngp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Niyo andaga abanikilwe ni mgosiwe, na lupisi icho andaga na myaka milongo mnane na mine. Lupisi chose icho andaga hakulawa mwe nyumba ya Mnungu, andaga Umwo kilo na msi akavika kwa kufunga ukudya na kulombeza. ");
INSERT INTO ngp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Isa iidya, mvele uyo alaila na kumtogola Mnungu no kulonga mbuli za yudya mwana kwa want'hu wose wandile wakaugoja ukombola wa Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusufu na Maliamu weze wajike kuyadamanya yose enga viya yasigilwe mwe miko ya Zumbe, niyo wauya Galilaya mpaka ko mzi wawe wa Nazaleti. ");
INSERT INTO ngp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yudya mwana niyo akula, ongezeka ludole, amema zihekima na uwedi wa Mnungu neziinda na yehe. ");
INSERT INTO ngp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Welesi wakwe Yesu nawenda na kihendo cha kwiita Yelusalemu kila mwaka mwa mazuwa ya zuwa dya kinyemi ye Pasaka. ");
INSERT INTO ngp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mbwanga Yesu eze abule myaka mlongo na miidi, niyo waita Yelusalemu enga viya kihendo kikuwaunga. ");
INSERT INTO ngp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Weze wabinde zuwa dya kinyemi, niyo wakonga kuuya kaya. Yesu niyo asigala Yelusalemu haheina welesi wakwe kumanya. ");
INSERT INTO ngp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Woho nawakafanyanya kugamba e hamwenga na fyo dya want'hu mo utafi, niyo wagenda msi mgima. Niyo wakonga kumzungula kwa ndugu zawe hamwenga na wambuya zawe. ");
INSERT INTO ngp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Weze wamswese, niyo wauya Yelusalemu wakamzungula. ");
INSERT INTO ngp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mwe dizuwa dya katatu, niyo wambwila mwe nyumba ya Mnungu kekala hamwenga na wahinizi we Kiyahudi, nakawategeleza na kuwauza mbuli. ");
INSERT INTO ngp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Woseni wamtegeleze niyo wahelwa kwa yadya mahituzi yakwe viya yendile ya ubala. ");
INSERT INTO ngp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Welesi wakwe weze wamuwone, niyo weheleswa. Nine niyo amgamba, “Mwanangu, ni mbwai ukakitenda ivi? Kaula, miye na tati yako nekinda kikakuzungula kwa kwangadika.” ");
INSERT INTO ngp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu niyo awahitula, “Kwa mbwai kunizungula? Hammanyize kugamba hiungigwa ninde mwe nyumba ya Tate?” ");
INSERT INTO ngp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mna woho hawakombaganye ulosi uwo awagambile. ");
INSERT INTO ngp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Niyo auya nawo Nazaleti, naye andaga akawategeleza. Nine niyo ayaika ayo yose mo umoyo wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu niyo ongezekela kukula na kunda na mizungu, akamwelela Mnungu hamwenga na want'hu. ");
INSERT INTO ngp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mwaka wa mlongo na mishano wo useuta wakwe seuta ywa Kilumi etangwe Tibeliyo, Pontio Pilato andaga mkulu we isi ya Uyahudi na Helode naye andaga mkulu wa Galilaya na Filipo nduguye andaga mkulu wa Ituleya ne isi ya Tilakoniti, Lisania andaga mkulu we Abilene. ");
INSERT INTO ngp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa wandaga wakulu wa walava nt'hambiko. Lupisi ulo Mbuli ya Mnungu yamwizilaga Yohana mwana Zakalia ukwo kwe nyika. ");
INSERT INTO ngp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Niyo aita kila hant'hu mwe isi yose yo mto Yolodani akawabilikiza want'hu, “Lekeni uwavu wenyu mkabatizwe, Mnungu naawausileni uwavu wenyu.” ");
INSERT INTO ngp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Enga viya iwandikwe mwe kitabu cho mlotezi ywa Mnungu Isaya. “Mnt'hu akubongeela kwe nyika, ‘Ikeni lumwe sila ya Zumbe, chululeni lwombokelo lwakwe. ");
INSERT INTO ngp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila kolongo dyaungwa kusilizwa, na kila lugulu na kagulu vaungwa kuselezwa. Sila zigonjile zaungwa kugololwa, sila za makolongo zaungwa kusalahazwa. ");
INSERT INTO ngp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Naho want'hu wose nawauone ukombola wa Mnungu!’ ” ");
INSERT INTO ngp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Niyo Yohana awagamba want'hu wambasile vileke wabatizwe, “Nyuwe cheleko che nyoka! Ni ani awagambileni kugamba mwadaha kunyilika maya ya Mnungu yakwiza? ");
INSERT INTO ngp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lagiseni kwa udamanyi kugamba muuleka uwavu wenyu. Naho msekukegamba, ‘Ibulahimu ni tati yetu!’ Nawagambilani, Mnungu adaha kuguha maiwe aya niyo amdamanyila Ibulahimu welekwa mwa maiwe aya! ");
INSERT INTO ngp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na ivo haluse hoya diikigwa kale mwe zink'holo ze miti, mti wowose howiina cheleko chedi nousengwe no kokigwa mwo moto.” ");
INSERT INTO ngp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Want'hu niyo wamuuza, “Haluse kitende vivihi?” ");
INSERT INTO ngp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Niyo awahitula, “Mta nk'hazu mbili naamwink'he heena nk'hazu, naho mta nk'hande atende iivo.” ");
INSERT INTO ngp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wakuduganya kodi nao niyo weza wakaunga kubatizwa. Niyo wamuuza, “Mhinizi, suwe naswe kitende vivihi?” ");
INSERT INTO ngp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Niyo awahitula, “Msekuguha vint'hu kujink'ha viya mkuungwa kuguha.” ");
INSERT INTO ngp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Watowani watuhu nao niyo wamuuza, “Suwe naswe kidamanyei?” Niyo awahitula, “Msekuguha matundu kwa mnt'hu yeyose haheina mwivano, naho mzumilane na maliho yenyu.” ");
INSERT INTO ngp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kwaviya want'hu nawanda wakagoja kwiza kwa Kilisito, ivo niyo wakonga kukeuza mwe mioyo yawe, mwe mbuli ya Yohana “Hangi uyu niye Kilisito?” ");
INSERT INTO ngp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana niyo awahitula, “Miye nawabatizani na mazi, mna eza mta ludole kunijink'ha miye. Miye hina wedi hata kunda mtumwa ywakwe. Yehe naawamibatizeni kwa Muye ywa Mnungu na kwa moto wa usengelo. ");
INSERT INTO ngp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Uyo ana lungo mwo mkono wakwe, ahetele ngano yakwe na kuiika mwe digulu dyakwe, mna mahofya naayoke mwo moto houkuzima.” ");
INSERT INTO ngp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Naho kwa milosi mituhu mingi Yohana nakawabilikiza want'hu Mbuli Yedi. ");
INSERT INTO ngp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mna Yohana nakamtivila zumbe Helode, mkulu wa Galilaya kwaviya nakamlomba Helodiya, mkaza mvunawe, na kwa vint'hu vituhu vingi viihile ivo Helode adamanye. ");
INSERT INTO ngp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Niyo Helode adamanya wiihi utendese kwa kumgela Yohana mwe divugailo. ");
INSERT INTO ngp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Want'hu wose weze wajike kubatizwa, niyo Yesu naye abatizwa. Umwo andile akalombeza Mnungu, mbingu niyo zagubuka, ");
INSERT INTO ngp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Muye ywa Mnungu niyo aseela no kumkima mnanga mwakwe enga wa suwa. Naho izwi dyevikaga kulawa kwe mbingu dikagamba, “Weye niwe mwanangu, hukuungisa. Weye kunelela.” ");
INSERT INTO ngp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu akongaga ndima yakwe umwo akanda na myaka milongo mitatu. Want'hu wandaga wakagamba andaga mwana Yusufu, mwana Eli. ");
INSERT INTO ngp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli andaga mwana wa Matati, andile mwana Lawi, mwana Meliki, mwana Yana, mwana Yusufu, ");
INSERT INTO ngp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","andile mwanawe Matatiya, mwana Amosi, mwana Nahumu, mwana Esili, mwana Nagai, ");
INSERT INTO ngp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","andile mwana Maati, mwana Matatiya, mwana Semeyi, mwana Yoseki, mwana Yuda, ");
INSERT INTO ngp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","andile mwana Yoana, mwana Lesa, mwana Zelubabeli, mwana Shealitieli, mwana Neli, ");
INSERT INTO ngp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana Meliki, mwana Adi, mwana Kosamu, mwana Elimadamu, mwana Eli, ");
INSERT INTO ngp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","andile mwana Yoshua, mwana Eliezeli, mwana Yolimu, mwana Matati, mwana Lawi, ");
INSERT INTO ngp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","andile mwana Simioni, mwana Yuda, mwana Yusufu, mwana Yonamu, mwana Eliakimu, ");
INSERT INTO ngp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","andile mwana Meleya, mwana Mena, mwana Matasa, mwana Natani, mwana Daudi, ");
INSERT INTO ngp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","andile mwana Yese, mwana Obedi, mwana Boazi, mwana Salimoni, mwana Nahashoni, ");
INSERT INTO ngp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","andile mwana wa Aminadabu, mwana Alamu, mwana Heziloni, mwana Pelesi, mwana Yuda, ");
INSERT INTO ngp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","andile mwana Yakobo, mwana Isaka, mwana Ibulahimu, mwana Tela, mwana Naholi, ");
INSERT INTO ngp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","andile mwana Selugi, mwana Lagau, mwana wa Pelegi, mwana Ebeli, mwana Sala, ");
INSERT INTO ngp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","andile mwana Kenani, mwana Alifakisadi, mwana Shemu, mwana Nuhu, mwana Lameki, ");
INSERT INTO ngp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","andile mwana Metusela, mwana Henoko, mwana Yaledi, mwana Mahalaleli, mwana wa Kenani. ");
INSERT INTO ngp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Andile mwana Enoshi, mwana Seti, mwana Adamu, mwana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu eze afose mwo mto Yolodani, andaga na udahi mkulu wa Muye ywa Mnungu. Niyo uyo Muye amlongoza kuita mpaka kwe dijangwa. ");
INSERT INTO ngp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uko agezagwa nu Mwavu kwa mazuwa milongo mine. Mazuwa ayo yose, andaga hakudya kint'hu, niyo akeiva sala. ");
INSERT INTO ngp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mwavu niyo amgamba, “Uneva weye niwe Mwana wa Mnungu, digambe diiwe idi dinde mkate.” ");
INSERT INTO ngp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu niyo amhitula, “Iwandikwa, ‘Mnt'hu haande mgima kwa ludyo du.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mwavu niyo akweza Yesu kwo lunenengwa no kumlagisa useuta wose we isi yose kwa lupisi lugihi. ");
INSERT INTO ngp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mwavu niyo amgamba, “Nohwink'he weye useuta wose na uwedi wakwe utendese kwaviya vose vimwe mikono yangu, name namwink'ha yoyose enga ivo huunga. ");
INSERT INTO ngp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ivo vose nevinde vako weye uneva unanivika.” ");
INSERT INTO ngp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu niyo amhitula, “Iwandikwa, ‘Mvike Zumbe, Mnungu ywako du, naho umdamanyile ndima yehe du!’ ” ");
INSERT INTO ngp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Naho Mwavu niyo amwigala Yesu aite Yelusalemu no kumkweza kwo lunenengwa lwe nyumba nk'hulu ya Mnungu. Niyo amgamba, “Uneva weye niwe Mwana Mnungu, keduule hasi ");
INSERT INTO ngp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kwaviya iwandikwa, ‘Mnungu naawagambe watumigwa vileke wakwamile, ");
INSERT INTO ngp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","wakupoele mwe mikono yawe vileke usekukobadisa ikiga chako mwe diiwe.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mna Yesu niyo ahitula, “Iwandikwa, ‘Usekumgeza Zumbe Mnungu ywako.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aho Mwavu eze abinde kumgeza kwa kila sila, amnekaga kwa lupisi. ");
INSERT INTO ngp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu niyo auya mwe isi ya Galilaya, kamema ludole lwa Muye ywa Mnungu. Niyo mbuli zakwe zagendezwa Galilaya na mwe si zose zi mgihi. ");
INSERT INTO ngp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naye andaga akahiniza mwe nyumba za Mnungu, naho andaga akatogolwa ni want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Niyo Yesu aita Nazaleti, hant'hu alekelwe. E enga ivo kili kihendo chakwe Yesu, mwe dizuwa dyo kuhumula engila mwe nyumba ya Mnungu niyo akimaala vileke asome Mawandiko Yakukile. ");
INSERT INTO ngp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Niyo enk'higwa kitabu cha mlotezi Isaya. Akigubulaga, niyo asoma hant'hu hawandikwe kugamba, ");
INSERT INTO ngp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Muye wa Zumbe wimnanga mwangu, kwaviya kanisagula miye niwabilikize wakiwa mbuli yedi. Naho kanisigiila hawagambile wavugailwa kulekelwa kwawe, na mant'hunt'hu kuwona vituhu, naho kuwakombola wanamakunt'ho. ");
INSERT INTO ngp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Hamwenga na kubilikiza kose kugamba lupisi lubula lwa Zumbe kuwakombola want'hu wakwe.” ");
INSERT INTO ngp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Niyo Yesu akigubika ikitabu no kumwink'ha mndima, niyo ekala. Want'hu wose wandile mwe nyumba ya Mnungu wamn'goelaga meso. ");
INSERT INTO ngp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Akongaga kuwagamba, “Mawandiko aya diyelo yakint'ha enga ivo mwivile.” ");
INSERT INTO ngp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Want'hu wose wamzumilaga wakehelwa kwa milosi yo uwedi ayo alongaga. Wakagamba, “Ivi uyu hiyo mwana Yusufu?” ");
INSERT INTO ngp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu niyo awagamba, “Himanya nomnigambile mliganyizo uno kugamba, ‘Mlaguzi kelagule mwenye! Mbuli zose kivile uzidamanye uko Kapelinaumu, zidamanye aha naho he isi yako mwenye.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Niyo agendeela kuwagamba, “Mlotezi hakuzumilwa mwe isi yakwe mwenye. ");
INSERT INTO ngp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Mna nawagambilani ikindedi handaga na wavele wengi wafiilagwa ni wagosi zawe mwe isi ya Izilaeli mwo lupisi ulo Eliya andaga aho. Lupisi ludya fula hainyele kwa myaka mitatu na miezi mtandatu niyo kwanda na gumbo kulu mwe isi yose. ");
INSERT INTO ngp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mna Eliya niyo hatumigwe kwa mnt'hu yeyose mwe isi ya Izilaeli ila kwa abanikilwe ni mgosiwe andile akekala Salefati mwe isi ya Sidoni. ");
INSERT INTO ngp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Naho mwo lupisi lwa mlotezi Elisha, nahanda na want'hu wengi wata matana mwe isi ya Izilaeli. Mna hahali mnt'hu yoyose akukizwe mna ni Naamani du, mnt'hu wa isi ya Siliya.” ");
INSERT INTO ngp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Want'hu wose wandile mwe idya nyumba ya Mnungu weze weve zimbuli izo, niyo wengila maya. ");
INSERT INTO ngp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Niyo walundumka, no kumfoseza Yesu kuse kwo mzi no kumkweza ho lunenengwa vileke wamdule hasi. ");
INSERT INTO ngp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mna yeye niyo omboka mgati mwawe niyo akeitila. ");
INSERT INTO ngp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Niyo aita mpaka Kapelinaumu, mzi wi Galilaya. Ukwo ahinizaga mwe dizuwa dyo Kuhumula. ");
INSERT INTO ngp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Niyo weheeleswa kwa mahinizo yakwe kwaviya andaga akahiniza kwa udahi. ");
INSERT INTO ngp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mdya mwe idya nyumba ya Mnungu, mwandaga na mnt'hu mta mp'hepo aihile. Niyo agutila akagamba, ");
INSERT INTO ngp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Uuwi! Yesu wa Nazaleti, waunga ukitendei? Kwiza ukikome? Hikumanya kugamba weye niwe ani. Weye wi Akukile ywa Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu niyo aitivila idya imp'hepo iihile, “Nyamala, naho umlawe mnt'hu uyo!” Niyo mp'hepo idya yamkinya hasi uyo mnt'hu mgati mwawe no kumfosa haheina kumlumiza. ");
INSERT INTO ngp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Want'hu wose niyo wehelwa no kukonga kuuzana kugamba, “Ino mbuli yani? Mnt'hu uyu ana udahi na ludole lwa kuwativila mp'hepo waihile, nawo niyo wafosa!” ");
INSERT INTO ngp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ivo mbuli za Yesu niyo zagendezwa kila hant'hu mwe isi idya. ");
INSERT INTO ngp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu afosaga nyumba ya Mnungu, niyo aita kwe inyumba ya Simoni. Nine dya mkaziwe Simoni andaga mwo lusazi hakudaha, niyo wamlombeza Yesu vileke amhonye. ");
INSERT INTO ngp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu niyo akimala hagihi na yudya mvele, aufank'hila udya unyonge niyo wamlekela. Ahadya niyo mvele yudya enuka no kuwadamanyila ndima. ");
INSERT INTO ngp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Zuwa dize diswe, want'hu wose niyo wamwigaila Yesu want'hu wata maine ye hengi, niyo aika mikono yakwe mnanga mwa kila yumwenga no kuwahonya wose. ");
INSERT INTO ngp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mp'hepo nawo niyo wawalawa want'hu wengi wakagutila wakagamba, “Weye wi Mwana Mnungu!” Yesu niyo awafank'hila, naho hawalekele walonge kwaviya nawammanya kugamba nuyo Kilisito. ");
INSERT INTO ngp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kwize kuche, Yesu niyo afosaga niuyo aita hant'hu haheina want'hu. Want'hu niyo wakonga kumzungula, weze wamuwone waunga wamlemeze asekuhalawa kwawe. ");
INSERT INTO ngp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mna niyo awagamba, “Naungwa habilikize Mbuli Yedi ya Useuta wa Mnungu mwe mizi mituhu, kwaviya iki niicho Mnungu anisiigile kudamanya.” ");
INSERT INTO ngp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Niyo abilikiza mwe zinyumba zo kumvika Mnungu mwe isi ya Uyahudi. ");
INSERT INTO ngp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Zuwa dimwenga Yesu andaga kakimala hank'handa he diziwa dya Genezaleti. Want'hu wengi nawammemela no kukefint'hafint'ha wakategeleza Mbuli ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Niyo aona ngalawa mbili zandile mnk'handa mwe diziwa zilekigwe ni walowa wandile wakasunt'ha zinyavu zawe. ");
INSERT INTO ngp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu niyo engila mwe ngalawa imwenga, naho neinda yakwe Simoni, niyo amuunga aigale hale ludodo kulawa mnk'handa mwe diziwa. Yesu ekalaga mnanga mwe ngalawa no kukonga kuhiniza. ");
INSERT INTO ngp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eze abinde kulonga, niyo amgamba, “Simoni igale, ingalawa kwa mazi matali vileke mkalowe zisamaki.” ");
INSERT INTO ngp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni niyo amhitula, “Zumbe,” “kidamanya ndima kilo kigima haheina kupata kint'hu chochose. Mna kwaviya weye kulonga, nakidule ziwavu!” ");
INSERT INTO ngp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Weze wadule zinyavu, niyo wavula samaki nyingi vitendile zinyavu zawe zaunga kukant'hika. ");
INSERT INTO ngp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Niyo wawahungila mikono weyawe wandile mwe ngalawa nt'huhu weze wawambize. Niyo weza no kumemeza samaki mwe ngalawa zose mbili, nazo zaungaga kudidimila mwe mazi. ");
INSERT INTO ngp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petulo eze aone diya dilaile, niyo amfikila madi Yesu, agamba, “Zumbe, halawe hangu! Miye ni mta wavu!” ");
INSERT INTO ngp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni hamwenga na weyawe niyo wehelwa kwa zisamaki zinyingi wapatile. ");
INSERT INTO ngp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Naho weyawe wa Simoni, Yakobo na Yohana wana wa Zebedayo nawo wehelwa. Yesu niyo amgamba Simoni, “Usekogoha, kukongela ivi haluse nounde walowa want'hu.” ");
INSERT INTO ngp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Niyo zingalawa zawe wazigamiza mp'wani, walekaga kila kint'hu niyo wamtimila Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu eze atende emwe mzi umwenga, nahenda na mnt'hu mta matana. Naye eze amwone Yesu, niyo amfikila madi no kumnombeza, niyo agamba, “Zumbe, ukaunga, wadaha kunisunt'ha!” ");
INSERT INTO ngp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu naye niyo akusula umkono wakwe, amdosa na kumgamba, “Naunga, sunt'hika!” Ahadya matana niyo yamlawa mnt'hu yudya. ");
INSERT INTO ngp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu niyo amgamba, “Usekumgambila mnt'hu yoyose imbuli ino. Mna ita ukakilagise kwa mlava nt'hambiko, ukalave malavo kwa mbuli ya kusunt'hika kwako enga viya Musa alagize uleke want'hu wose wamanye kugamba kuhona.” ");
INSERT INTO ngp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mna izimbuli za Yesu niyo zatendesa kugendezwa kila hant'hu. Want'hu wengi niyo weza wakamtegeleza na kuhonyigwa maine yawe. ");
INSERT INTO ngp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mna Yesu niyo aita hant'hu haheina want'hu, niyo amlombeza Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Zuwa dimwenga Yesu andaga akahiniza. Mafalisayo wamwenga hamwenga na wahinizi wa Sigilizi walaile mwe kila mzi wa Galilaya na Yudeya na Yelusalemu nawanda aho. Na udahi wa Zumbe nawinda aho uleke ahonye. ");
INSERT INTO ngp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Niyo weza want'hu wenule mwo lusazi mnt'hu aholomp'hale. Nawakaunga wamwigale kundani hameso ha Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mna kwaviya want'hu nawamema, niyo wadunduga kumwigala kundani. Ivo wamkwezaga kulanga kwe nyumba, niyo waponk'hola langa no kumseleza mwo lusazi lwakwe na kumwika hagati he difyo dya want'hu, hameso ha Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu eze aone mhuwi wawe, niyo amgamba yudya mnyoge, “Mbuyangu, kuusilwa wavu wako.” ");
INSERT INTO ngp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Niyo wahinizi we zimiko hamwenga na Mafalisayo wakongaga kulafya wakagamba, “Uyu ni ani akumlonga vihile Mnungu? Ni ani akudaha kuusila uwavu? Mnungu ekedu niye akudaha kuusila uwavu!” ");
INSERT INTO ngp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu nakamanya viya wakubanikanyanya, niyo awagamba, “Nii mwafanyanya mbuli izo mwe mioyo yenyu? ");
INSERT INTO ngp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dihuhile ni dihi, kugamba, ‘Kuusilwa uwavu wako,’ hegu kugamba, ‘Inuka uite’? ");
INSERT INTO ngp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mna naunga mmanye kugamba, Mwana wa Mnt'hu ananao udahi wo kuwausila want'hu uwavu wawe.” Niyo amgamba yudya mnt'hu aholomp'hale, “Nakugamba, kimala, inula lusazi lwako wite kaya kwako!” ");
INSERT INTO ngp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ahadya mnt'hu yudya niyo akimaala hameso yawe, niyo aketwika lusazi lwakwe, niyo aita kaya kwake uku akamtogola Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Want'hu wose niyo weheleswa na kwingilwa ni wogofi, niyo wamtogola Mnungu wakagamba, “Dyelo kiona mbuli za kwehela!” ");
INSERT INTO ngp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Akajika, Yesu niyo afosa kuse. Amuonaga mnt'hu andile akakisanya kodi akwitangwa Lawi kekala he nyumba ya kukisanyila kodi. Yesu niyo amgamba, “Nitimile.” ");
INSERT INTO ngp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi niyo enuka, niyo aleka kila kint'hu no kumtimila Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Akajika Lawi niyo amdamanyila Yesu wila mkulu mwe nyumba yakwe. Fyo kulu dya watoza kodi hamwenga na want'hu watuhu wandaga aho. ");
INSERT INTO ngp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Niyo Mafalisayo wamwenga hamwenga na wahinizi wamwenga we miko walaile mwe difyo dyawe wakongaga kuwakalaliza wanamp'hina wa Yesu wakagamba, “Nii mwadya no kunywa hamwenga na wakutoza kodi na wata uwavu?” ");
INSERT INTO ngp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu niyo awahitula, “Want'hu wagima hawakumuunga mlaguzi, mna wanyonge nayo wakumuunga mlaguzi. ");
INSERT INTO ngp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Hizile kuwetanga want'hu wedi ila wata wavu wakweiile wavu wawe, ila wata wavu.” ");
INSERT INTO ngp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Niyo want'hu wamwenga wamgambaga Yesu, “Nkanana nyingi wahamp'hina wa Yohana hamwenga na wa Mafalisayo wafunga na kumlombeza Mnungu, mna wanamp'hina wako wadya no ukunywa!” ");
INSERT INTO ngp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mna Yesu niyo awagamba, “Ivi want'hu walalikwe kwe ndoza wadaha vivihi kufunga wakanda hamwenga no mlombi? Haikudahika! ");
INSERT INTO ngp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mna mazuwa nayeze hadya mlombi akuunga ahauswe. Mna nedize zuwa aho mlombi neze auswe kwawe, aho niho nawafunge.” ");
INSERT INTO ngp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Niyo Yesu awagambila mliganyizo, “Hahali mnt'hu akusenga kilaka kulawa mwe suke mp'hya na kukigela mwe suke isakale. Uneva anadamanya ivo, naatatule idya suke mp'hya, naho kiya kilaka che idya suke mp'hya hakiligane ne suke ibunt'hike. ");
INSERT INTO ngp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Naho hahali mnt'hu akugela divai mp'hya mwe vizembe visakale. Uneva anatenda ivo, idya idivai imp'ya neivitule viya vizembe, naho neiitike, vizembe navo nevibanike. ");
INSERT INTO ngp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mna divai mp'hya yaungigwa kugeligwa mwe vizembe vihya. ");
INSERT INTO ngp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Naho hahali mnt'hu akuunga kunywa idivai mp'hya ananywa idya ya kale. Kwaviya naagambe, ‘Divai ya kale niyo iyedi.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mwe dizuwa dimwenga dyo Kuhumula, Yesu na wanamp'hina wakwe wandaga wakaita kombokela mwe migunda ya uhemba. Niyo awanamp'hina wakwe wakonga kukwanyula vikole vo uhemba, naho nawakauhugusa no kuvidya. ");
INSERT INTO ngp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafalisayo wamwenga niyo wauza, “Nii nyuwe mwadamanya kint'hu kilemezwe kudamanywa mwe dizuwa dyo Kuhumula?” ");
INSERT INTO ngp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu niyo awahitula, “Ivi hamsomile kiya adamanyaga Daudi na weyawe umwo andaga na sala? ");
INSERT INTO ngp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yehe engilaga mwe nyumba ya Mnungu, niyo aguha mikate alavilwe Mnungu, kaidya no kuwenk'ha weyawe. Naho Sigilizi zawafingiza want'hu watuhu kuidya imikate iyo, mna ni walava nt'hambiko du.” ");
INSERT INTO ngp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Niyo Yesu awagamba, “Mwana Mnt'hu niye Zumbe we dizuwa dyo Kuhumula.” ");
INSERT INTO ngp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mwe dizuwa dituhu dyo Kuhumula, Yesu agendaga kuhiniza kwe nyumba ya Mnungu. Mna mwe idya nyumba mwandaga na mnt'hu aholole mkono wa kulume. ");
INSERT INTO ngp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wahinizi we miko hamwenga na Mafalisayo watuhu nawanda wazungula mzungu wo kumgwiila Yesu. Niyo wakaula uneva naamhonye yudya mnyonge mwe dizuwa dyo Kuhumula. ");
INSERT INTO ngp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mna Yesu niyo abunk'hula ivo wakufanyanya, niyo amgamba yudya mta mkono uholole, “Inuka ukimale hagati.” Yudya mnt'hu niyo enuka na kukimala hagati. ");
INSERT INTO ngp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Niyo Yesu awagamba, “Nawauzani nyuwe, ivi miko yetu yakigamba suwe kidamanyei mwe dizuwa dyo Kuhumula? Kudamanya mbuli zedi hegu mbuli ziihiye? Kuhonya ugima wa mnt'hu hegu kuukoma?” ");
INSERT INTO ngp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ahitukaga nt'hendelo zose akawakaula, niyo amgamba yudya mnt'hu mta mkono uholole, “Chulula mkono wako.” Yudya mnt'hu niyo atenda enga ivo agambilwe, mkono wakwe niyo wanda mgima naho. ");
INSERT INTO ngp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wose niyo wafa maya, nakufanyanya woho kwa woho kugamba wamtendei Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mwa mazuwa yadya, Yesu niyo ahalawa no kuita kwo lugulu, uko amlombezaga Mnungu kilo kigima. ");
INSERT INTO ngp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mtondo mwe dizuwa ditimile, Yesu ewetangaga wanamp'hina wakwe. Niyo asagula mlongo na waidi mwa awo no kuwetanga wegala ulosi ");
INSERT INTO ngp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni uyo enk'higwe zina dya Petulo ni Yesu na Anduleya nduguye na Yakobo na Yohana hamwenga na Filipo na Batolomayo, ");
INSERT INTO ngp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo na Tomasi na Yakobo mwana Alufayo na Simoni akwitangwa Zelote, ");
INSERT INTO ngp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana wa Yakobo na Yuda Isikaliyote, uyo amsezenge Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu eze aseele kulawa kwo mnima na wegala ulosi wakwe, akimalaga hant'hu hatindimale. Fyo kulu dya wanamp'hina wakwe dyandaga aaho. Naho handaga na want'hu wengi kulawa Uyahudi na Yelusalemu ne mizi ya mp'wani ya Tilo na Sidoni. ");
INSERT INTO ngp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Want'hu awo wezaga kumtegeleza Yesu hamwenga na kuhonywa maine yawe. Hata wadya wandile wakasulumizwa ni zimp'hepo, wezaga niyo wahonywa. ");
INSERT INTO ngp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Want'hu wose waungisaga wamdose Yesu kwaviya ludole nolukafosa mwakwe niyo lwawahonya want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu awakaulaga wanamp'hina wakwe niyo agamba, “Mna kinyemi nyuwe awakiwa, kwaviya Useuta wa Mnungu ni wenyu! ");
INSERT INTO ngp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mvikilwa nyuwe mne sala ivi haluse, kwaviya nomwigute! Mvikilwa mkuila ivi haluse, kwaviya nomseke! ");
INSERT INTO ngp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mvikilwa uneva want'hu wana waihiyani, no kuwalemelani no kuwahomolani no kuwa onani kugamba mwiwasavu, mna kwa mbuli ya Mwana wa Mnt'hu! ");
INSERT INTO ngp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Indeni na kinyemi na kwanga uneva ayo yakalaila, kwaviya nt'hunyo ni nk'hulu kwe mbingu. Kwaviya wakale wawe nivo wawatendaga walotezi wawalongoeleni nyuwe. ");
INSERT INTO ngp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mna hangi nyuwe wenye wagoli, kwaviya mpata kale wikazi wedi! ");
INSERT INTO ngp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hangi nyuwe wenye nyuwe mwigute ivi haluse, kwaviya nomwize mnde na sala! Hangi nyuwe wenye mkuseka ivi haluse, kwaviya nomwize muile hamwenga na kuhongeza! ");
INSERT INTO ngp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Hangi nyuwe wenye uneva mnatogolwa ni want'hu! Kwaviya wakale wawe nivo wawatendelaga walotezi wo udant'hi. ");
INSERT INTO ngp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mna nyuwe mkunitegeleza nawagambani, waungeni wadya wank'hondo wenyu, wadamanyileni yedi wose wakuwatendelani yaihile. ");
INSERT INTO ngp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wavikileni wakuwaligitani, naho walombezeleni yedi kwa Mnungu wadya wakuwaihiyani. ");
INSERT INTO ngp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Uneva mnt'hu anakutowa funda imwenga, mleke akutowe na ya kaidi. Naho uneva mnt'hu akukuhoka koti dyako, mwink'he ne nk'hazu nayo. ");
INSERT INTO ngp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mwink'he yeyose akukulombeza, naho uneva mnt'hu anakuhoka kint'hu chako usekuunga akuvuzile. ");
INSERT INTO ngp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Watendeleni want'hu watuhu enga viya nyuwe mkuunga want'hu wawatendeleni. ");
INSERT INTO ngp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Uneva mnawaunga want'hu wadya wakuwaungani, ivi mwalagisa uwedi wani? Kwaviya hata wata wavu wawaunga wadya wakuwaunga! ");
INSERT INTO ngp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Naho uneva mnadamanya mbuli zedi kwa wadya wakuwadamanyizila mbuli zedi du, ivi mwalagisa uwedi wani? Hata wata uwavu watenda iivo! ");
INSERT INTO ngp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Naho uneva mnawenk'ha wadya mkumanya wadaha kuwaliha, ivi mwalagisa uwedi wani? Kwaviya hata wata uwavu wadamanya iivo, wakakawiila kuvuzilwa. ");
INSERT INTO ngp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mna waungeni wadya wakuwaihia na wadamanyileni mbuli zedi, wakopesheni want'hu naho msekukawiila kuvuzilwa. Niho nt'hunyo yenyu neinde nk'hulu, nanywe nomnde wana wa Mnungu e Kulanga vitendese. Kwaviya yehe ni ywedi kwa heweena nt'hogola na waihi. ");
INSERT INTO ngp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Naho indeni na mbazi, enga viya eli Tati yenyu. ");
INSERT INTO ngp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Msekuwasengela want'hu watuhu, Mnungu naye haawasengeleni nyuwe. Msekuwalonga wamwenga vihile, Mnungu naye hawalongileni vihile. Walekeleni wadya wawatendeleni yaihile, nanywe nomlekelwe ni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wenk'heni want'hu vint'hu, Mnungu naye naamwink'heni nyuwe. Nomhokele kihimo kimemile na kusint'hwa na kusegeswa kikuta kwitika, nicho Mnungu naakiike mwe mikono yenyu. Kwaviya kihimo kiya ukuwahimila watuhu, nicho Mnungu naawahimileni.” ");
INSERT INTO ngp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu niyo awagambila mliganyizo, “Mant'hunt'hu hakudaha kumlongoza mant'hunt'hu miyawe. Uneva anatenda ivo, nawaingile wose mwe dibome. ");
INSERT INTO ngp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwanamp'hina hakudaha kumjink'ha mhinizi ywakwe. Mna kila mwanamp'hina akabinda mahinizo yakwe, adaha kuligana na mhinizi ywakwe. ");
INSERT INTO ngp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nii wakaula putiputi mwe diziso dya nduguyo mna weye una basi mwe diziso dyako? ");
INSERT INTO ngp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hegu, noudahe vivihi kumgamba nduguyo, ‘Ndugu yangu, goja huuse putiputi mwe diziso dyako,’ mna hukudiona dibasi di mwe diziso dyako? Weye mtondwe! Konga kuusa idibasi di mwe diziso dyako, niho noudahe kukausa kaputiputi mwe diziso dya nduguyo. ");
INSERT INTO ngp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Hahana mti wedi ukudaha kunda na cheleko kiihile, naho hahana mti wiihile ukudaha kunda na cheleko chedi. ");
INSERT INTO ngp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kwaviya kila mti wamanyika kwa cheleko chakwe. Want'hu hawakudaha kwaha tini kulawa mwe miwa, naho hawakudaha kwaha zabibu mwe miwambangoma. ");
INSERT INTO ngp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mnt'hu ywedi alava yadya ayedi kulawa mwe kindolo chakwe chedi cho umoyo wakwe, mna mnt'hu mwavu alava yadya yaihile kulawa mwe kindolo chakwe kiihile cho moyo wakwe. Kwaviya mnt'hu alonga yadya yamemile mwo moyo wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Naho nii mwanitanga ‘Zumbe, Zumbe,’ mna hamkudamanya yadya hulonga? ");
INSERT INTO ngp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mnt'hu yoyose akwiza kwangu na kwiva ulosi wangu na kuudamanya ");
INSERT INTO ngp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","uyo naande enga mnt'hu azengile nyumba, naho nk'hongelo yakwe kaizenga moluwe. Fula nk'hulu ize inye, mazi mengi yaitowa idya inyumba, mna haigwele kwaviya izengigwa vedi. ");
INSERT INTO ngp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mna mnt'hu yoyose akwiva zimbuli zangu mna hanatendile ivo zikumuunga, uyo naande enga mnt'hu azengile nyumba yakwe mwo msanga haheina nk'hongelo. Fula nk'hulu ize inye, mazi niyo yaitowa, yaisingisa no kuikinya, niyo yabanikisa!” ");
INSERT INTO ngp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu eze ajike kulonga zimbuli izo kwa want'hu, niyo ahalawa na kuita Kapelinaumu. ");
INSERT INTO ngp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mtumwa ywa mkulu yumwenga ywa watowani wa Kilumi andilisaga mnyonge. Naho mkulu uyo naakamuungisa. ");
INSERT INTO ngp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mkulu uyo eze eve zimbuli za Yesu, niyo asigiila wadala vilongozi wamwenga wa Kiyahudi kwa Yesu wamlombeze vileke eze amhonye mtumwa ywakwe. ");
INSERT INTO ngp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nawo weze wabule kwa Yesu, wamweilisa wakamgamba, “Mnt'hu uyu kawagilwa umtendele imbuli ino ");
INSERT INTO ngp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kwaviya nakawaungisa want'hu, naho kakizengela nyumba ya Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ivo Yesu niyo aita hamwenga nawo. Hata eze ande e haguhi ne kaya ya yudya mkulu wawa watowani, niyo yudya mkulu wa wa watowani asigiila mnt'hu kwakwe akamgamba, “Zumbe, usekwangadika kwiza kwangu, kwaviya miye hina wedi ukukutenda weye wingile kwangu, ");
INSERT INTO ngp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","naho miye name hina wedi wakunitenda kwiza kwako. Mna longa mbuli du, mtumwa ywangu naahone. ");
INSERT INTO ngp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwaviya miye name ni mnt'hu mta udahi, naho nnanawo watowani we hasi yangu. Hamgamba yumwenga, ‘Ita!’ Naye aita, naho hamgamba mtuhu, ‘So!’ Eza, naho hamgamba mtumwa ywangu, ‘Damanya ivi!’ Adamanya.” ");
INSERT INTO ngp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu eze eve ayo, niyo ehelwa, niyo awahitukila want'hu wandile wakamtimila no kuwagamba, “Nawagambilani, hinati nione mnt'hu mta mhuwi enga uno mwe isi ya Izilaeli!” ");
INSERT INTO ngp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Naho wadya want'hu watumigwe weze wauye kaya kwa yudya mkulu wawa watowani, niyo wambwiila yudya mtumwa mnyonge kahona. ");
INSERT INTO ngp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eze ajike aho, niyo Yesu hamwenga na wanamp'hina wakwe waita kwo mzi ukwitangwa Naini. Fyo kulu dya want'hu niyo dyawatimila. ");
INSERT INTO ngp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Weze wabule he nk'hili yo mzi, waduganaga na want'hu wenule mnt'hu abanike, wagenda kumosa msanga. Mbwanga uyo abanike andaga mwana ikedu ywa mvele yumwenga andile kabanikilwa ni mgosiwe, naho want'hu wengi wo mzi uwo nawanda hamwenga naye. ");
INSERT INTO ngp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Zumbe eze amuone yudya mvele abanikilwe ni mgosiwe, niyo amwonela mbazi, niyo amgamba, “Usekuila.” ");
INSERT INTO ngp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Niyo asogela no kudidosa dijeneza, wadya wadinule niyo wakimala. Yesu niyo agamba, “Mbwanga, nakugamba, inuka!” ");
INSERT INTO ngp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yudya mbwanga niyo enuka no kwikala, niyo akonga kulonga. Yesu niyo amwink'hiza kwa nine. ");
INSERT INTO ngp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Want'hu wose niyo wengilwa ni wogofi, niyo wakonga kumtogola Mnungu no kugamba, “Mlotezi mkulu keza kwetu, naho Mnungu kawakombola want'hu wakwe!” ");
INSERT INTO ngp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Niyo mbuli za Yesu zagendezwa mwe isi yose ya Uyahudi na mwe ziisi za hagihi. ");
INSERT INTO ngp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wanamp'hina wa Yohana niyo wamgambila Yohana zimbuli izo zose. Yohana niyo awetanga waidi wawe, ");
INSERT INTO ngp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","niyo awasigila kwa Zumbe vileke wakamuuze kugamba, “Ivi weye ni yudya Yohana agambile neeze, hegu kimgojele mtuhu?” ");
INSERT INTO ngp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Weze wabule kwa Yesu, niyo wamgamba, “Yohana Mbatizi kakituma kwako kikuuze kugamba, weye ni yudya akwiza, hegu kikawiile mtuhu.” ");
INSERT INTO ngp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Umwo wandaga wakamuuza, Yesu nakahonya want'hu wengi wandile wanyonge na wata masungusungu no kulava mp'hepo ziihile, naho awatendaga mant'hunt'hu wengi wadahe kuwona. ");
INSERT INTO ngp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Niyo Yesu awahitula wanamp'hina wa Yohana kugamba, “Iteni mkamgambile Yohana yadya muyaone na kuyeva, mant'hunt'hu waona, viwete wagenda, wata matana wakukizwa, wata magutwi heyekwiva weva, wabanike wauyuka, na wakiwa wabilikizwa Mbuli Yedi. ");
INSERT INTO ngp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wavikilwa want'hu wadya heihizwe kwa yadya huyadamanya!” ");
INSERT INTO ngp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wadya want'hu watumigwe ni Yohana weze wahalawe, niyo Yesu akonga kuwagambila want'hu mbuli za Yohana. “Mwize mwiite kwe nyika, ivi nomgenda kukaulai? Kukaula kanyazi kakusingiswa ni mp'heho? ");
INSERT INTO ngp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ivi nomgenda kukaulai? Mnt'hu availe suke zedi? Manyeni kugamba want'hu wavaile suke zedi na want'hu wana wikazi wedi weyuko kwe mazumba ye kiseuta! ");
INSERT INTO ngp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mna nigambileni, ivi nomgenda kukaulai? Mlotezi? Heiye, naho eli mkulu kujink'ha mlotezi. ");
INSERT INTO ngp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kwaviya Yohana niye awandikilwe mwa Mawandiko Yakukile kugamba, ‘Mnungu agamba, kaula namtuma mwigala mbuli ywangu akulongowele, uyo naakwikile lumwe sila yako.’ ");
INSERT INTO ngp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu niyo agamba, nawagambilani,” “Hahali mkulu kumjink'ha Yahana mwe want'hu wose we isi ino. Mna mnt'hu yoyose mdodo kujink'ha wose mwo Useuta wa Mnungu, uyo ni mkulu kumjink'ha Yohana.” ");
INSERT INTO ngp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Want'hu wose, hata waduganya kodi weze weve ayo, wamzumilaga uwedi wa Mnungu kwaviya nawabatizwa ubatizo wa Yohana. ");
INSERT INTO ngp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mna Mafalisayo na wahinizi we zimiko nawalemela kumzumila Mnungu kwaviya hawabatizwe ni Yohana. ");
INSERT INTO ngp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu niyo agamba, “Ivi niwaliganye na kint'hu chani want'hu we cheleko iki? Ivi want'hu awa waligana na mbwai? ");
INSERT INTO ngp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Waligana na wana wekale kwe digwilo. Fyo dimwenga dikwitangana na tuhu kugamba, ‘Nakiwatoela mluli mna hamvinile, naho nekiwakemela wila wa kuhongeza mna hamwiile!’ ");
INSERT INTO ngp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana Mbatizi nakeza, hakudya nk'hande naho hakunywa divai, nanywe niyo mwagamba, ‘Ana mp'hepo!’ ");
INSERT INTO ngp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana Mnt'hu keza, akadya no kunywa, nanywe niyo mwagamba, ‘Mkauleni mnt'hu uyu, mhank'hu naho mkozi. Wambuyaze ni waduganya kodi na wata wavu!’ ");
INSERT INTO ngp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mna mzungu wa Mnungu uoneka kunda kindedi kwa want'hu wose wakuuzumila.” ");
INSERT INTO ngp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mnt'hu yumwenga Mfalisayo niyo amlalika Yesu kaya kwakwe akadye nk'hande ya kilo. Yesu niyo aita kwe nyumba ya yudya Mfalisayo no kwikala vileke adye. ");
INSERT INTO ngp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mwo mzi udya, kwandaga na mvele yumwenga mta wavu. Niyo eva kugamba Yesu adya nk'hande mwe nyumba ya yudya Mfalisayo. Niyo eza na kashupa kandaga na mavuta yana mhemp'he. ");
INSERT INTO ngp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Niyo akimala kunyuma, hagihi ne iviga va Yesu, niyo aila masozi yakwe yatomokela mwe viga va Yesu. Akajika mvele yudya avihangusa iviga va Yesu kwafili zakwe na kuvinonela hamwenga na kuvihaka mavuta ya mhemp'he. ");
INSERT INTO ngp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yudya Mfalisayo amlalike Yesu eze aone viya, niyo alonga mwo umoyo wakwe, “Mnt'hu uyu uneva andile mlotezi, nakamanya mvele uyu akumdosa kugamba ni mnt'hu ywa vivihi, hegu nakamanya kugamba ni mta uwavu!” ");
INSERT INTO ngp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu niyo amhitula yudya Mfalisayo na kugamba, “Simoni, iyuko mbuli huunga hugambile.” Simoni niyo agamba, “Heiye, longa Mhinizi.” ");
INSERT INTO ngp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Niyo Yesu amgamba, “Kwandaga na want'hu waidi wakopaga matundu kwa mnt'hu akukopesha. Yumwenga akopaga dinali magana mashano na wakaidi akopaga dinali milongo mishano. ");
INSERT INTO ngp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wose waidi niyo hawana cho kuliha, ivo mnt'hu yudya awakopeshe niyo awalekela wose. Ivi mwe awo waidi, ni yuhi akuunga amuungise yudya mnt'hu awakopeshe?” ");
INSERT INTO ngp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni niyo amhitula, “Naona ni yudya alekelwe ase kuliha matundu mengi” Yesu niyo amgamba, “Kulonga vedi.” ");
INSERT INTO ngp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu niyo amhitukila yudya mvele na kumgamba Simoni, “Kumuwona uyu mvele? Hingila kwako, mna hunink'hile mazi ya kuhaka viga vangu, mna uyu kasunt'ha iviga vangu kwa masozi yakwe hamwenga na kuvihangusa ne zifili zakwe. ");
INSERT INTO ngp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Weye huninonele, mna mvele uyu kukongela ivo ningile halekile kuvinonela iviga vangu. ");
INSERT INTO ngp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hunihakile mavuta mwo mtwi wangu, mna uyu kanihaka iviga vangu mavuta ya mhemp'he. ");
INSERT INTO ngp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nakugambila, kwaviya uwavu wakwe mwingi uusigwa, ivo yehe naye kaungisa. Mna mnt'hu akuusilwa uwavu mgeke, yehe naye aunga ludogo.” ");
INSERT INTO ngp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu niyo amgamba yudya mvele, “Uwavu wako uusigwa.” ");
INSERT INTO ngp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Want'hu wamwenga wandile hadya niyo wakonga kulonga mwe imioyo yawe, “Mnt'hu uyu ni mnt'hu ywani hata auwausile want'hu wavu?” ");
INSERT INTO ngp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mna Yesu niyo amgamba yudya mvele, “Mhuwi wako ukuyokola. Keitile kwa utondowazi.” ");
INSERT INTO ngp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yeze yajike ayo, Yesu naakazungulukila mwe mizi na mwe zikaya, akabilikiza Mbuli Yedi yo Useuta wa Mnungu. Wadya wanamp'hina mlongo na waidi wandile nae, ");
INSERT INTO ngp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","hamwenga na wavele wamwenga walavigwe mp'hepo na kuhonyigwa maine yawe. Wavele awo wandaga ni Maliamu akwitangwa Magedalena alavigwe mp'heho mfungate, ");
INSERT INTO ngp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Yoana mkaza Kuza andile mkulu mwe kitala cha Helode, na Susana na wavele watuhu wengi wandile wakamdamanyila ndima Yesu na wanamp'hina wakwe kwa vint'hu vawe. ");
INSERT INTO ngp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Want'hu wengi wandaga wakamwizila Yesu kulawa kila mzi. Fyo kulu dya want'hu dize didugane hamwenga, Yesu alongaga nawo kwa mliganyizo uno. ");
INSERT INTO ngp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mhandi agendaga kuhanda mbeyu. Umwo akazimyaga, zimwenga zagweelaga mwe sila, niyo zajatangizwa, wadege niyo wazidya. ");
INSERT INTO ngp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zimwenga zagweelaga mwo luwe, zize zikonge kuhota, niyo zahomp'hala kwa kuswesa uwolo. ");
INSERT INTO ngp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zimwenga zagweelaga mgati mwe miwa, imiwa niyo yakula hamwenga nazo, niyo yazivigaviga. ");
INSERT INTO ngp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Zimwenga zagweelaga mwo ulongo wedi. Zakulaga no kweleka, kila imwenga malavo gana.” ");
INSERT INTO ngp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wanamp'hina wakwe niyo wa muuza Yesu, “Mliganyizo uwo nivo wagaaze?” ");
INSERT INTO ngp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu niyo awahitula, “Nyuwe hiwagambilani mbuli zo Useuta wa Mnungu. Mna kwa want'hu watuhu nalonga kwa miliganyizo, vileke wakakaula wase kuwona, wakategeleza, wase kukombaganya. ");
INSERT INTO ngp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Uno nuwo ulosi wo mliganyizo uno, mbeyu, ni Imbuli ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeyu ziya zigweele mwe sila zaliganywa na want'hu wakuiva Imbuli ya Mnungu, mna Mwavu eza kuiusa mwe mioyo yawe vileke wanase kuhuwila no kuyokolwa. ");
INSERT INTO ngp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeyu zigweele mwo luwe, zaliganyizwa na want'hu wakuiva imbuli ya Mnungu, niyo waihokela kwa kinyemi, mna haikuika maizi kwaviya waswesa ulongo. Wahuwila ludodo du, wakagezigwa nu Mwavu, wadunduga no kuuleka mhuwi wawe. ");
INSERT INTO ngp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeyu zigweele he miwa zaliganyizwa na want'hu wakuiva imbuli ya Mnungu, mna wakagendeela, mbuli iyo yavigwavigwa ni wogofi wo wikazi uno, no ugoli no kuungisa vint'hu ve isi. Want'hu awa hawakwelela chochose. ");
INSERT INTO ngp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbeyu zigwele mwo ulongo wedi zaliganyizwa na want'hu wakuiva Imbuli ya Mnungu, niyo waihokela na kuihuwila mwe mioyo yawe, naho wafinyiliza mpaka weleke matunda. ");
INSERT INTO ngp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Hakuli mnt'hu akukweleza lumuli no kulugubika ne kihungu hegu kulwiika kwe divungu, mna alwiika henukile vileke kila akwingila auone ung'azi wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Kwaviya kila mbuli igubikwe neigubulwe, naho ifisigwe, neilaile kung'aile. ");
INSERT INTO ngp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Elo indeni na wengele kwa ayo mkuyeva, kwaviya kila mta kint'hu noongezelwe, mna mnt'hu heina kint'hu naahokigwe hata kiya kidodo akufanyanywa kunda nacho.” ");
INSERT INTO ngp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nine na wanduguze dya Yesu niyo wambasa, mna hawadahile kumsogeela hagihi kwaviya fyo dya want'hu nedindilisa kulu. ");
INSERT INTO ngp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mnt'hu yumwenga niyo amgamba Yesu, “Nyokwe na wanduguzo we kuse, waunga wakuone.” ");
INSERT INTO ngp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu niyo awagamba want'hu wose, “Mnala na wandugu zangu ni wadya wakuiva Mbuli ya Mnungu no kuihuwila.” ");
INSERT INTO ngp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Zuwa dimwenga Yesu hamwenga na wanamp'hina wakwelaga mwe ngalawa. Niyo awagamba, “Nekijink'hanyeni int'hendelo int'huhu ye diziwa.” Ivo niyo wakonga kuita. ");
INSERT INTO ngp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Weze wakonge kuita, Yesu niyo agona nt'hongo. Aaho, nk'hung'unt'ho nk'hulu yakongaga kuvumila mwe bahali, ngalawa niyo yakonga kumema mazi, niyo wanda hagihi no kwangamila. ");
INSERT INTO ngp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wana mp'hina wamwinulaga, wakamgamba, “Zumbe, Zumbe! Changamila!” Yesu niyo enuka, niyo aitivila ink'hung'unt'ho idya hamwenga na mazi ye diziwa, niyo kwanda mp'heho tondolo. ");
INSERT INTO ngp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Niyo Yesu awagamba wanamp'hina wakwe, “Wikuhi mhuwi wenyu?” Weheelagwa na kogoha, wakagambana, “Uyu ni mnt'hu ywa vivihi? Akutivila nk'hung'unt'ho ne mijubwaniso ye bahali, navo vamwiva!” ");
INSERT INTO ngp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na wanamp'hina wakwe niyo wagendeela ne nt'hambo, niyo wabula mwe isi ya Wagelasi imwe nt'hendelo nt'huhu ye bahali ya Galilaya. ");
INSERT INTO ngp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu eze afose mwe ingalawa, aduganaga na mt'hu yumwenga wo mzi uwo mta mp'hepo. Mnt'hu uyo andaga kimbwigili mazuwa mengi, naho haakekala kwe kaya mna yehe naakekala kwe vikuta. ");
INSERT INTO ngp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Eze amwone Yesu, niyo aila kwa izwi kulu, niyo amgweela Yesu heviga na kuguta, akagamba, “Yesu, Mwana Mnungu e Kulanga! Togola, waunga unitende vivihi? Nakeiila kwako, use kunisulumiza!” ");
INSERT INTO ngp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yudya mnt'hu nakalonga ivo kwaviya Yesu nakamgamba yudya mp'hepo amlawe. Nk'hanana nyingi mp'hepo yudya naakamwizila. Naho hamwenga mnt'hu uyo naakata kwamilwa kwa kuvugailwa kwe divugailo no kukakigwa mp'hingu na kwe viga ne mikono, mna naakadaha kuzikant'ha zimp'hingu akakilizwe nazo, niyo mp'hepo zamwigala kwe nyika. ");
INSERT INTO ngp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu amuuzaga, “Weye wetangwa ani?” Niyo ahitula, “Netangwa Fyo.” Ahitulaga ivo kwaviya andaga na mp'hepo waihile wabindile ingi. ");
INSERT INTO ngp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Niyo mp'hepo wadya wakeiila kwa Yesu asekuwagulusila kwe isi ya want'hu wabanike. ");
INSERT INTO ngp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hagihi na hadya handaga na fyo kulu dya nguluwe dyandaga dikadima mwe diwandamo dyo mnima. Niyo mp'hepo wadya wakweiila kwa Yesu vileke wakengile mwe difyo idyo. Yesu niyo awazumila. ");
INSERT INTO ngp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Niyo wadya mp'hepo wamlawa yudya mnt'hu no kwingila mwe difyo idyo. Difyo nadyo niyo dyagulukisa kuhinga kwe bahali, niyo dyanywa nk'habu. ");
INSERT INTO ngp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wadimi wa nguluwe weze waone diya dilaile, niyo wanyilika no kugendeza kose imbuli mwo mzi na mwe migunda. ");
INSERT INTO ngp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Want'hu niyo wagenda kukaula diya dilaile. Weze wabule kwa Yesu, niyo wamuona yudya mnt'hu alavigwe mp'hepo kekala he viga va Yesu, kavala suke zakwe, naho ana ubala ukint'hile. Wose niyo wogohesa. ");
INSERT INTO ngp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wadya wayaone ayo niyo wawatambalisa weyawe ivo yudya mnt'hu andile na mp'hepo waihile ahonyigwe. ");
INSERT INTO ngp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Niyo want'hu wose we isi ya Wagelasi wamnombezaga ahalawe mwe isi yawe kwaviya nawengilwa ni wogofi. Ivo Yesu engilaga mwe ngalawa no kuhalawa. ");
INSERT INTO ngp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yudya mnt'hu alavigwe mp'hepo waihile, amlombezaga Yesu kugamba waitanye, mna Yesu niyo amsigiila, akamgamba, ");
INSERT INTO ngp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uya kaya ukawagambile want'hu ivo Mnungu akutendele.” Yudya mnt'hu niyo aita kila hant'hu, akawagambila ivo Yesu amdamanyile. ");
INSERT INTO ngp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu eze auye kwe nt'hendelo nt'huhu ye diziwa, want'hu wamhokelaga kwa kinyemi, kwaviya wose wandaga wakamgoja. ");
INSERT INTO ngp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Niyo eza mnt'hu yumwenga akwitangwa Yailo, naye ni mkulu we nyumba yo kuvikila. Eze ambwiile Yesu, amgweela mwe viga, akeiila kwa Yesu waitanye kwakwe ");
INSERT INTO ngp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwaviya mwanawe ywa kike heendile na miyawe naakatoweela. Mwana uyo andile na myaka mlongo na miidi. Umwo Yesu andile akaita, want'hu nawakamgela lugovyagovya nt'hendelo zose. ");
INSERT INTO ngp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mwa awo want'hu, andaga umwo mvele yumwenga andaga na unyonge wa kulawigwa ni sakame kwa malavo mlongo na miidi. Mvele uyo azaga vint'hu vingi kwa kuwenk'ha walaguzi, mna hakwandile na yoyose adahile kumhonya. ");
INSERT INTO ngp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Niyo amwiziila Yesu kwa kumtimila kunyuma, niyo adosa imp'hindilo ye suke ya Yesu. Aaho, niyo isakame yaleka kumlawa. ");
INSERT INTO ngp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu niyo auza, “Ni ani anidosile?” Want'hu wose weze wakane, Petulo niyo amgamba, “Zumbe, fyo dikuzunguluka na kukuvigaviga!” ");
INSERT INTO ngp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mna Yesu niyo agamba, “Eyuko mnt'hu anidosile. Hibunk'hula ivo kwaviya hiona ludole lukanilawa.” ");
INSERT INTO ngp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yudya mvele eze aone hakudaha kukekifisa, niyo amwiziila Yesu akazingiza, niyo akeduula heviga va Yesu. Ahadya mwekiyeti cha want'hu amgambilaga Yesu kiya chamtendile akamdosa, na ivo ahonile aaho eze amdose. ");
INSERT INTO ngp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu niyo amgamba yudya mvele, “Mwanangu, mhuwi wako ukuhonya, ita na utondowazi.” ");
INSERT INTO ngp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Umwo Yesu andile akalonga ayo, ezaga mnt'hu kulawa kwe kaya ya Yailo. Niyo amgamba Yailo, “Use kumgela lugovyagovya Mhinizi. Mwanao kabanika kale.” ");
INSERT INTO ngp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mna Yesu eze eve ayo, niyo amgamba Yailo, “Use kogoha, weye huwila du, mwanao naa hone.” ");
INSERT INTO ngp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eze abule kwe kaya ya Yailo, hazumile mnt'hu yoyose engile naye kwe nyumba, ila Petulo na Yohana na Yakobo, hamwenga na ise na nine dya yudya mwana. ");
INSERT INTO ngp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Want'hu wose nawanda wakaila no kuhongeza ifile ya yudya mwana. Yesu niyo awagamba, “Msekuila, mwana habanike, kagona du!” ");
INSERT INTO ngp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Want'hu niyo wamsekesa kwaviya nawamanya kugamba mwana yudya kabanika kale. ");
INSERT INTO ngp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mna Yesu niyo amtoza mkono niyo amgamba, “Mwanangu, inuka!” ");
INSERT INTO ngp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ugima wakwe niyo wamuuiya, aaho niyo enuka. Yesu niyo awagamba wamwink'he nk'hande. ");
INSERT INTO ngp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Welesi wakwe niyo weheleswa, mna Yesu niyo awafingiza wasekumgambila mnt'hu yoyose diya dilaile. ");
INSERT INTO ngp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu niyo awetanga wadya mlongo na waidi, awenk'haga ludole na udahi wa kulava mp'hepo wose waihile na kuhonya maine. ");
INSERT INTO ngp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Niyo awasigiila waite kokubilikiza mbuli yo Useuta wa Mnungu hamwenga na kuhonya wanyonge, ");
INSERT INTO ngp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","akawagamba, “Msekuguha kint'hu mwe nt'hambo yenyu. Msekuguha nk'home, hegu nk'hoba, hegu nk'hande, hegu matundu, naho msekuguha hata nk'hazu mbili. ");
INSERT INTO ngp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba yoyose mkwingila niyo mwetikilwa, ikaleni umwo mpaka mhalawe mwo mzi uwo. ");
INSERT INTO ngp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Want'hu wanalemela kuwahokela, foseni mwo mzi uwo, naho mkafosa kung'unt'heni luvumbi mwe viga venyu inde uwona kugamba wawalemelani.” ");
INSERT INTO ngp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Niyo wasambala wakazunguluka mwe zikaya zose wakabilikiza Mbuli Yedi hamwenga na kuhonya want'hu kila hant'hu. ");
INSERT INTO ngp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Zumbe Helode niyo eva zimbuli zose zilaile, niyo engilwa ni wogofi kwaviya want'hu wamwenga nawakagamba Yohana Mbatizi kauyuka. ");
INSERT INTO ngp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wamwenga nawo nawakagamba Eliya kalaila, watuhu nawo nawakagamba yumwenga mwa walotezi wa kale kauyuka. ");
INSERT INTO ngp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mna Helode niyo agamba, “Yohana nehimkant'ha umtwi. Haluse uyu naye ni ani hwiva zimbuli zakwe?” Niyo aunga kumuwona Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wadya wegala ulosi weze wauye, niyo wamgambila Yesu mbuli zose zidamanyike uko. Yesu niyo awaguha no kuita mpaka kwo mzi ukwitangwa Betisaida. ");
INSERT INTO ngp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Fyo dya want'hu dize dive, niyo dyambasa, Yesu naye awahokelaga niyo alonga nawo mbuli zo Useuta wa Mnungu na kuwahoya want'hu waungile kuhonywa. ");
INSERT INTO ngp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kwize kunde kisingi, wadya wanamp'hina wakwe mlongo na waidi niyo wambasa na kumgamba, “Walage want'hu waite mwe zikaya ne zink'honde zimgihi vileke wakazungule nk'hande hamwenga na hant'hu ha kugona kwaviya aha ni he nyika.” ");
INSERT INTO ngp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mna Yesu niyo awagamba, “Wenk'heni nyuwe nk'hande.” Niyo woho wamhitula, “Hakina kint'hu ila mikate mishano na samaki mbili du. Haluse waunga suwe kiite kikagule nk'hande kwa fyo dyose idi?” ");
INSERT INTO ngp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wagosi du awo wandaga aaho wabulaga magana milongo mishano. Yesu niyo awagamba wanamp'hina wakwe wawekazeni want'hu hasi mwe vibunga vya want'hu milongo mishano shano. ");
INSERT INTO ngp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wanap'hina weze wajike kuwekaza, ");
INSERT INTO ngp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu niyo aguha idya mikate mishano ne zisamaki ziya zimbuli. Niyo akaula kulanga kwe mbingu no kumtogola Mnungu kwa ivo, avibendula no kuwenk'ha awanamp'hina wakwe wawapangile want'hu. ");
INSERT INTO ngp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Want'hu wose niyo wadya no kwiguta, naho niyo waduganya wabesu wasigale wakubula nt'hangulu mlongo na mbili. ");
INSERT INTO ngp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Zuwa dimwenga, Yesu akanda mwenye ekedu andaga mwo kulombeza Mnungu. Wanamp'hina wakwe nawamwiitila, yehe niyo awauza, “Ivi want'hu wanigamba miye ni miye ani?” ");
INSERT INTO ngp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Niyo wamhitula, “Wamwenga wagamba weye niye Yohana Mbatizi, wamwenga wagamba niwe Eliya na watuhu nao wagamba weye u yumwenga mwe walotezi wa kale wauyuke wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu niyo awauza, “Nyuwe nanywe mwanigamba miye ni miye ani?” Petulo niyo amhitula, “Weye niwe Kilisito ulaile kwa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mna Yesu niyo awafingiza wasekumgambila mnt'hu yoyose mbuli idya. ");
INSERT INTO ngp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Niyo agendeela kugamba, “Mwana ywa Mnt'hu naapatise masulumizo, naho naalemelwe ni wadala vilongozi na wakulu wa walava nt'hambiko hamwenga na wahinizi we Zisigilizi. Naho naakomigwe, mna zuwa dya katatu kukongela hadya akomigwe naauyuke.” ");
INSERT INTO ngp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Niyo awagamba want'hu wose, “Mnt'hu yoyose akuunga kunibasa, yaungwa akekane ye mwenye, enule msalaba wakwe kila zuwa, niyo eza kwangu. ");
INSERT INTO ngp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwaviya mnt'hu akuunga kuukombola ugima wakwe nawazaganye, mna yoyose akuunga awazaganye ugima wakwe kwa kunizungula miye naa uyokole. ");
INSERT INTO ngp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ivi mnt'hu anapata kila kint'hu mwe isi yose, mna anawazaganya ugima wakwe, mnt'hu uyo naapatei? ");
INSERT INTO ngp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Uneva mnt'hu ananionele soni miye hamwenga na mbuli zangu, Mwana ywa Mnt'hu naye naamuwonele soni mnt'hu uyo akezakwiza mwo wedi wakwe utendese na wa Ise na watumigwa wa kwe mbingu wakukile. ");
INSERT INTO ngp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nawagambilani kindedi, weyuko watuhu aha hawabanike mpaka aho nawauone Useuta wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yeze yomboke mazuwa mnane kukongela hadya eze alonge ayo, niyo awaguha Petulo na Yohana na Yakobo niyo akwela nawo kwo lugulu vileke akalombeze Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Umwo andile mwo kulombeza, futa yakwe yahitukaga, zisuke zakwe nazo zandaga na ung'azi wa kumwekamweka. ");
INSERT INTO ngp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ahadya want'hu waidi wandaga want'hu waidi wandaga wakasimuila hamwenga na yehe. Want'hu awo wandaga ni Musa na Eliya ");
INSERT INTO ngp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","waonekaga mwo uwedi utendese wa kwe mbingu wakalonga na Yesu ivo naakaungwa kubindiliza yadya aungile Mnungu, kwa yehe kubanika kukuunga kulaile Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulo hamwenga na weyawe wandaga wagona nt'hongo. Weze wenuke, niyo wauona uwedi utendese wa Yesu na wadya want'hu waidi wakimale hamwenga naye. ");
INSERT INTO ngp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wadya want'hu weze wamwase Yesu, Petulo niyo amuuza, “Zumbe, kaula ivo vili vedi suwe kinde aha! Nekidamanye viheha vitatu, kamwenga kako, katuhu ka Musa na katuhu ka Eliya.” Petulo hamanyaga yadya naakalonga. ");
INSERT INTO ngp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Umwo Petulo andile akalonga, niyo halaila vunde dyagubikaga, woho niyo wogohesa umwo weze wagubikwe ni diya divunde. ");
INSERT INTO ngp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Izwi niyo dyevika kulawa kwe mbingu dikagamba, “Uyu niye Mwanangu nimsagule, mtegelezeni yehe!” ");
INSERT INTO ngp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Izwi idyo dize divike, Yesu niyo aoneka ekedu. Wanamp'hina niyo wanyamala, hawamgambile mnt'hu yoyose zimbuli ziya wazione. ");
INSERT INTO ngp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Zuwa ditimile, Yesu hamwenga na wadya wanap'hina watatu waseelaga kulawa kudya kwo lugulu. Fyo kulu dya want'hu niyo dyadugana na Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mnt'hu yumwenga mwe difyo diya niyo agutila, “Mhinizi! Nakulombeza mkaule mwanangu, mwanangu nuuyo du! ");
INSERT INTO ngp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nkanana nyingi mp'hepo aihile akamwizila, amtenda agutile, naho amgela kifutu na kulawa fulo. Hakumlekela mpaka amlumizise, niho amlekela. ");
INSERT INTO ngp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nehiwalombeza wanamp'hina wako wamlave, mna wadunduga.” ");
INSERT INTO ngp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu niyo awahitula, “Nyuwe cheleko hekikuhuwila, chagile! Nenikale na nyuwe na kugigimiza mpaka ini?” Niyo amgamba yudya mnt'hu, “Mlete mwanao aha.” ");
INSERT INTO ngp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Umwo yudya mbwanga andile akegalwa kwa Yesu, mp'hepo aihile niyo amkinya hasi na kumgela kifutu. Yesu niyo amtivila yudya mp'hepo, niyo amhonya yudya mbwanga na kumvuza kwa ise. ");
INSERT INTO ngp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Want'hu wose niyo wehelwa kwa udahi mkulu wa Mnungu. Umwo want'hu wandile wakehelwa kwe zimbuli naakadamanya Yesu, niyo awagamba wanamp'hina wakwe, ");
INSERT INTO ngp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Msekujala kiya huwagambilani! Mwana ywa Mnt'hu agenda kugeligwa mwe mikono ya want'hu.” ");
INSERT INTO ngp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mna wanamp'hina hawaimanyaga imbuli idya kugamba yagaaze, kwaviya neifisigwa kwawe vileke wase kuikombaganya, naho nawakogoha kumuuza Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Niyo wanamp'hina wa Yesu wakonga kuuzana kugamba ni ani akuunga ande mkulu mgati mwawe. ");
INSERT INTO ngp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu nakamanya ivo wakufanyanya mwe mioyo yawe, niyo amguha mwana mdodo na kumkimalisa haguhi naye. ");
INSERT INTO ngp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Niyo awagamba, “Mnt'hu yoyose akumhokela mwana enga uyu kwa ajili yangu, anihokela miye. Yudya naye akuunga anihokele miye, amhokela yudya akisigiile. Kwaviya e mdodo mwa nyuwe, niye mkulu kujink'ha wose.” ");
INSERT INTO ngp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana niyo amgamba Yesu, “Zumbe, nekimuwona mnt'hu akulava mp'hepo waihile kwa dizina dyako, niyo chamfingiza kwaviya hakutimilana na suwe.” ");
INSERT INTO ngp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu niyo amhitula Yohana, “Msekumfingiza, kwaviya mnt'hu yoyose heekuhigana na nyuwe e hamwenga na nyuwe.” ");
INSERT INTO ngp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mazuwa ya Yesu yo kuguhigwa kulanga yeze yande hagihi kubula, aungisaga kuita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Awasigilaga want'hu wamlongoele, awo waitaga niyo wengila mwe kaya ya Wasamalia wakaike lumwe kila kint'hu. ");
INSERT INTO ngp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mna wakaya wa Samaliya hawamhokele kwaviya wamanyaga kugamba andaga akaita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wanamp'hina wakwe, Yakobo na Yohana weze waone ayo, niyo wagamba, “Zumbe, waunga kilagize moto usele kulawa kulanga uwakome pele wose?” ");
INSERT INTO ngp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu niyo awahitukila na kuwativila. ");
INSERT INTO ngp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Niyo Yesu na wanamp'hina wakwe waita kwe kaya nt'huhu. ");
INSERT INTO ngp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Umwo wandile mwe sila, mnt'hu yumwenga niyo amgamba, “Nohutongele kokose kudya ukunga wiite!” ");
INSERT INTO ngp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu niyo amgamba, “Mauzi yana mp'hanga, na wadege wa mwo ulanga nawo wana masasa, mna Mwana ywa Mnt'hu hana hant'hu ho kuke humuza.” ");
INSERT INTO ngp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu niyo amgamba mnt'hu mtuhu, “Nitongele.” Mna mnt'hu yudya niyo amgamba, “Zumbe, goja hande kummosa msanga tate.” ");
INSERT INTO ngp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu niyo amhitula, “Waleke want'hu wabanike wawamose msanga wabanike weyawe, mna weye ita ukabilikize Useuta wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mnt'hu mtuhu niyo amgamba Yesu, “Zumbe, nohubase, mna goja hawalage wandugu zangu kaya.” ");
INSERT INTO ngp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu niyo amgamba, “Mnt'hu yoyose anawaluka mna niyo akaula kunyuma, hakuzumilwa kwo Useuta wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yeze yajike ayo, Zumbe asagulaga watuhu milongo mfungate na waidi, no kuwatuma wamlongoele kwa kila mzi na kila kaya, kudya yemwenye akawiile kuita. ");
INSERT INTO ngp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Niyo awagamba, “ulozo utenda mwingi, mna wavuni wageke. Mlombezeni Zumbe wo ulozo egale wavuni. ");
INSERT INTO ngp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Iteni! Nawegalani enga ngoto mwe difyo dya mauzi. ");
INSERT INTO ngp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Msekuguha mfuko hegu nk'hoba hegu vilatu, naho mse kwikalisa mkalamsa want'hu mwe sila. ");
INSERT INTO ngp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Uneva mkengila he nyumba, walamseni mkagamba, ‘Utondowazi unde mwe nyumba ino.’ ");
INSERT INTO ngp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Uneva naande aaho awagilwe utondowazi, lekeni ndamsa yenyu ikale naye, mna uneva hahali, iguheni indamsa yenyu yo utondowazi. ");
INSERT INTO ngp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ikaleni mwe nyumba iiyo, dyeni, no kunywa vovose nomwink'higwe, kwaviya, wandima wawagilwa maliho. Msekusama sama kulawa nyumba ino, kuita nt'huhu. ");
INSERT INTO ngp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mneva mnaita kwo mzi niyo want'hu wakwe wanawahokelani, dyeni viya mkuunga mwiikilwe ho ludyo, ");
INSERT INTO ngp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","honyeni wanyonge mwo mzi uwo, naho muwagambe want'hu wa aho, ‘Useuta wa Mnungu ubula hagihi na nyuwe.’ ");
INSERT INTO ngp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mna mnaita mwo mzi niyo hawa wahokeleni, halaweni aho, niyo mkabula kwe sila gambeni, ");
INSERT INTO ngp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘No luvumbi lulawile mwo mzi wenyu, lung'ang'anile mwe viga vetu, chawakunk'hunt'hilani. Mna mmanye kugamba, Useuta wa Mnungu wiza hagihi na nyuwe!’ ");
INSERT INTO ngp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nawagambilani kindedi kugamba, mwe di zuwa dyo usengelo Mnungu naawafiile mbazi Sodoma, kujink'ha umzi uwo. ");
INSERT INTO ngp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Hangi we mwenye, Kolazini, hangi we mwenye Betisaida, kwaviya vihungi vidamanywe kwako vadamanywe Tilo na Sidoni, hegu wa keiilaga kale kwa Mnungu, wakavala suke za magunia, na kuhaka maivu. ");
INSERT INTO ngp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mna kwe dizuwa dyo usengelo, Mnungu naalagise mbazi kwa Tilo na Sidoni kuwajink'ha nyuwe. ");
INSERT INTO ngp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Weyawe Kapelinaumu, Noukekweze mpaka kulanga? Bule, noukulumulwe mpaka hasi kwe isi ya wabanike!” ");
INSERT INTO ngp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu niyo awagamba wanamp'hina wakwe, “Yeyose akuwategeleza nyuwe anitegeleza miye, na yudya akuwalemela nyuwe anilemela miye na yudya akunilemela miye amlemela yudya anigale.” ");
INSERT INTO ngp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Niyo wadya milongo mfungate na waidi wauya kwa kinyemi kikulu wakagamba, “Zumbe, hata mp'hepo ziihile zikiva kwe dizina dyako.” ");
INSERT INTO ngp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu niyo awahitula, “Nehimuwona Mwavu, akagwa enga lumwemwe kulawa kulanga. ");
INSERT INTO ngp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kauleni, hiwenk'ha udahi wa kujata nyoka na visuse hamwenga na kuluhuma ludole lwose lwo Mwavu, naho hakihali kint'hu kikuunga kiwanyulikeni. ");
INSERT INTO ngp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mna msekunda na kinyemi Kwaviya mp'hepo zimivani, mna indeni ne kinyemi Kwaviya amazina yenyu yawandikwa kwa Mnungu” ");
INSERT INTO ngp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lupisi uludya Yesu nakamemezwa kinyemi na Muye ywa Mnungu no kugamba, “Tate ywa Mazumbe wa kulanga na hasi, nakutogola kwaviya kuwalagisa heweemanyize viya vifisigwe kwa wamanyize na wadya wasomile,. Heiye Tate ivi nivo uungile vilaile. ");
INSERT INTO ngp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tate kanink'ha vint'hu vose. Hahali ammanyize Mwana ila ni Tate naho hahali ammanyize Tate ila ni umwana, na wadya umwana awasagule wamanye.” ");
INSERT INTO ngp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesu niyo awahitukila wanamp'hina wakwe na kuwagamba, kwa kinyele, “Wavikilwa wadya wakuwona zimbuli izi mkuziona. ");
INSERT INTO ngp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Namigambilani, walotezi hamwenga na mazumbe wengi nawakaunga kuyaona aya muyaone, mna hawayaone. Naho nawakaunga kwiva yadya mwivile mna hawadahile.” ");
INSERT INTO ngp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mhinizi we Miko na keza vileke amgeze Yesu, “Mhinizi, Nitendei vileke nihokele ugima wa ulo na ulo”? ");
INSERT INTO ngp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu niyo amhitula, “Mawandiko Ukukile yagaaze? Weye waukombaganya vivihi?” ");
INSERT INTO ngp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yudya mnt'hu niyo amhitula Yesu, “ ‘Muunge Zumbe Mnungu ywako, kwa moyo wako wose, na kwa ugima wako wose no udahi zako zose, no ubala wako wose’, naho ‘umuunge miyao enga viya ukukeunga weye mwenye.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu niyo amhitula, “Kulonga kindedi. Damanya ayo naunde no ugima.” ");
INSERT INTO ngp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mna vileke aketende ywedi, niyo amuuza Yesu, “Miyangu ni ani?” ");
INSERT INTO ngp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu niyo amhitula, “Mnt'hu yumwenga naakasela kulawa Yelusalemu kuita Yeliko, Niyo want'hu waihile wamgwila no kumhambula zisuke, niyo wamtoa na kumlumizisa, niyo wanyilika wamwasa hagihi no kubanika. ");
INSERT INTO ngp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Niyo mlava nt'hambiko yumwenga aselaga ne sila idya, eze amuone yudya mnt'hu niyo ombokela kunk'handa. ");
INSERT INTO ngp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Niyo eza Mlawi, yehe naye eze amuone niyo ombokela kunk'handa. ");
INSERT INTO ngp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Niyo msamalia yumwenga ombokela hadya haguhi, eze amuone niyo amuwonela mbazi. ");
INSERT INTO ngp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Niyo amfunga zink'wenge zakwe, no kuzigela mafuta na divai, niyo amguha yudya mnt'hu no kumkweza mwe mp'hunda yakwe na kumwigala mwe nyumba ya wageni vileke wamkaule. ");
INSERT INTO ngp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Zuwa ditimile niyo aguha matundu na kuwenk'ha wadya wata inyumba, no kumgamba, ‘Umkaule uyu mnt'hu, kint'hu chochose kiya akuunga umwink'he miye nenize nilihe hauya.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu niyo abindiliza kwa kugamba, “Mwa want'hu ao watatu, ni ani miyawe dya yudya akump'hukilwe ni wahoki?” ");
INSERT INTO ngp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yudya mhinizi we miko iyo ahitula, “Ni yudya amwonele mbazi.” Yesu ni amhitula, “Ita ukadamanye enga ivo.” ");
INSERT INTO ngp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Umwo Yesu na wanamp'hina wakwe wandaga mwo utafi wawe, wengilaga mwe kaya imwenga niyo mvele yumwenga akwitangwa Masa, awahokelaga kwe nyumba yakwe. ");
INSERT INTO ngp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naho andaga na lumbudye etangagwa Maliamu, ekale he viga va Zumbe akamtegeleza mahinizo yakwe. ");
INSERT INTO ngp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Masa andaga akangadika ne zindima, niyo eza na kumgamba, “Zumbe hukuona hiyo vedi uyu ndugu yangu kunasila zindima nikedu? Hake mgambe eze anambize.” ");
INSERT INTO ngp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zumbe niyo amhitula, “Masa! Masa wangadika no kwingila kinyulu mwe kudamanya mbuli nyingi!” ");
INSERT INTO ngp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mna kint'hu kimwenga du kikuungwa, naho Maliamu kasagula mbuli yedi naho heiuswe mwakwe. ");
INSERT INTO ngp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aho Yesu eze abinde kulombeza Mnungu, yumwenga mwa wanamp'hina wakwe niyo amgamba, “Zumbe ukihinize kumlombeza Mnungu enga viya Yohana awahinize wanamp'hina wakwe.” ");
INSERT INTO ngp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu niyo awagamba, “Mnanda mwo kumlombeza Mnungu, gambeni, ‘Tati yetu wi kwe mbingu, Zina dyako ditogolwe, Useuta wako wize, ");
INSERT INTO ngp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ukink'he ludyo lwetu lwa dielo. ");
INSERT INTO ngp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kiusile uwavu wetu, enga viya suwe kikuwausila wavu wawe wadya wakidamanyile wavu, naho usekukigela mwa magezo.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu niyo awagamba wanamp'hina wakwe, “Uneva yumwenga ywenyu aita kwa mbwiyaye kilogati niyo amgamba yudya mbwiyaye, ‘Mbuyangu nikopeshe mikate mitatu. ");
INSERT INTO ngp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Hizilwa ni mbuyangu akulawa nt'hambo, naho hina kint'hu cha kumwink'ha adye!’ ");
INSERT INTO ngp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naho uneva mbuyayo anakuhitula kulawa kwe nyumba, ‘Usekunigela nk'huswank'huswa! Hivugala kale lwivi, naho miye hamwenga wana wangu kigona kale hikudaha kwinuka hwi'nkhe kint'hu chochose.’ ");
INSERT INTO ngp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Neenuke niyo amwink'ha, hiyo kwaviya ni mbwiyaye du, mna neenuke niyo amwink'ha kwaviya halekile kumlombeza kwe yadya akuunga. ");
INSERT INTO ngp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Naho namigambilani, lombezeni namhokele, zunguleni naho namuwone, gambeni, Kuno, nomkomoelwe. ");
INSERT INTO ngp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwaviya wadya wakulombeza nawahokele, wadya nawo wakuzungula nawaone, naho lwivi naukomwolwe kwa wadya wakugamba, Kuno! ");
INSERT INTO ngp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hegu eyuko mwa nyuwe akwitangwa tate, uneva mwanawe amlombeza samaki yehe naamwink'he nyoka? ");
INSERT INTO ngp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Hegu naamwink'he kisuse analombeza tagi? ");
INSERT INTO ngp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Togoleni want'hu waihile enga nyuwe, mna mwadaha kuwenk'ha wana wenyu vint'hu vedi, Togoleni havitendese kwa Tati yetu ywa kwe mbingu kuwenk'ha Muye ywakwe akukile wadya wakumlombeza?” ");
INSERT INTO ngp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu andaga akalava mp'hepo aihile ywa kimumu, naho mp'hepo yudya aihile eze afose yudya mnt'hu niyo akonga kulonga, want'hu niyo weheelwa, ");
INSERT INTO ngp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mna want'hu watuhu niyo wagamba, “Alava mp'hepo waihile kwa udahi wa Belizebuli, Mkulu wa mp'hepo waihile.” ");
INSERT INTO ngp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Watuhu niyo wamgeza Yesu wakaunga vilagiso vikulawa kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu niyo amanya zifanyanyi zawe niyo awahitula, “Useuta ukukediila gaina woho wenye, nounde uke pusa, naho nyumba ina nk'humbizi haikutoga. ");
INSERT INTO ngp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Naho uneva Mwavu kakediila gaina yehe mwenye, useuta wakwe noukimale vivihi? Kwaviya nyuwe mwagamba Belizebuli anink'ha udahi wa kulava mp'hepo. ");
INSERT INTO ngp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Uneva miye nalava mp'hepo kwa udahi wa belizebuli, wana wenyu walava vivihi? Wadya wakumitimilani wamanya kugamba, mna masa. ");
INSERT INTO ngp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mna uneva miye nalava mp'hepo kwa udahi wa Mnungu, Useuta wa Mnungu umizilani kale. ");
INSERT INTO ngp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mnt'hu mta ludole aguhile vitoanilo vakwe anayamila inyumba yakwe, yose neinde mp'heho tondolo. ");
INSERT INTO ngp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mna uneva mnt'hu mta ludole kujink'ha izakwe anamwizila no kumhuma, naamhoke vitowanilo vakwe vose akuvihuwila no kuwapanganiza wadya awatahile. ");
INSERT INTO ngp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mnt'hu he hamwenga na miye, uyo e kinyume na miye, naho mnt'hu uyo hakuduganya mna amwaganisa. ");
INSERT INTO ngp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Mp'hepo iihile inamfosa mnt'hu, yombokela hant'hu haheina mazi, ikazungula hant'hu ho kuhumuila, hanahaone akegamba, ‘Neniiuiye inyumba yangu nilaile.’ ");
INSERT INTO ngp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mna anauya niyo aibwila inyumba ihagilwa na kuhambwa, ");
INSERT INTO ngp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","naho, naaite no kuguha mp'hepo watuhu waihile kujink'ha yehe mwenye niyo wengila na kwikala umwo, naho mnt'hu yudya hali yakwe yanda iha kujink'ha idya ya nk'hongo.” ");
INSERT INTO ngp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Umwo Yesu andile akalonga ivo, mvele yumwenga mwe difyo iyo niyo alonga kwa izwi kulu, “Kavikilwa mvele akweleke, hamwenga na kukulela.” ");
INSERT INTO ngp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mna Yesu niyo ahitula niyo amgamba, “Wavikilwa wadya wakwiva ulosi wa Mnungu no kuutimila!” ");
INSERT INTO ngp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Want'hu viya wandile wakammemela niyo akonga kulonga, “Cheleko iki kiha, chazungula vilagiso, mna hakihali kilagiso mkuunga mwink'higwe ila kilagiso cha Yona. ");
INSERT INTO ngp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Enga viya Yona andile kilagiso kwa want'hu wa Ninawi, nivo akuunga ande mwana Adamu mwe cheleko iki. ");
INSERT INTO ngp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dizuwa dyo usengelo dikabula malikia kulawa Seba naakimale nokuwasengela want'hu wa dielo, kwaviya agendaga kulawa kwe isi yakwe kugenda kumtegeleza Seuta Sulemani na mahinizo yakwe ya mizungu. Naho nawagambilani, hana kint'hu aha kikulu kumjink'ha Sulemani. ");
INSERT INTO ngp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Want'hu wa Ninawi nawakimale nawo mwe dizuwa dyo usengelo no kuwasengelani nyuwe kunda na masa kwaviya wahituka kulawa mwo wavu wawe weze weve mabilikizi ya Yona. Naho nawagambilani ikindedi eyuko mkulu aha kumjink'ha Yona. ");
INSERT INTO ngp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Hahali mnt'hu akukweleza lumuli no kulwiika hant'hu hakefisile hegu no kulugubika ne nyungu, mna lwaikwa henukile vileke wakwingila waone ung'azi wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lumuli lwo umwili ni diziso, uneva ziso dyako dinanda dyedi umwili wako wose nao wanda wedi, mna dinanda dibanika umwili wako wose wanda na ziza. ");
INSERT INTO ngp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Elo kaulisa, ung'azi unanao mwo mwili wako unase kunda ziza. ");
INSERT INTO ngp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Uneva umwili wako wose una ung'azi hahana hant'hu hana ziza, umwili wako wose nounde no ung'azi enga viya lumuli lukukumulikila.” ");
INSERT INTO ngp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Umwo andile akalonga ayo Falisayo yumwenga niyo amwitanga aite kwakwe akadye nk'hande, niyo engila no kwikala adye nk'hande. ");
INSERT INTO ngp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Falisayo uyo eze amwone Yesu adya nk'hande haheina kuhaka mikono enga viya ikuungwa niyo ehelwa. ");
INSERT INTO ngp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Zumbe niyo amgamba, “Nyuwe Mafalisayo mwasunt'ha vint'hu va kudiila kwa kuse, mna mndani mwenyu mmema wavu na wiihi. ");
INSERT INTO ngp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nyuwe wahezi! Mnungu hiye yehe avidamanye va kuse na vakundani? ");
INSERT INTO ngp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mna wenk'heni wakiwa vint'hu vimwe vikombe na mwe zinyiga, vose mkuunga mnadamanye, nevinde vedi kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Hangi nyuwe wenye Mafalisayo, kwaviya mwalava zaka za mnanaa, no mchicha hamwenga ne zimboga naho mwaleka mbuli za mahinizo yedi no lukunde lwa Mnungu, mwaungigwa mdamanye ayo haheina kuyaleka yadya matuhu. ");
INSERT INTO ngp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Hangi nyuwe wenye nyuwe Mafalisayo, kwaviya mwaungisa kwikala mwo ukalo wa kulongole mwe zinyumba zo kumvikila Mnungu hamwenga na kulamswa kwa kogohwa mwa magwilo. ");
INSERT INTO ngp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Hangi nyuwe wenye kwaviya mwikala enga vikuta heviwakigwe, naho want'hu wakwomboka mnanga mwawe hawavimanyize.” ");
INSERT INTO ngp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mnt'hu yumwenga mwe wahinizi we Miko iyo amhitula, “Mhinizi, ukalonga ayo wakilongeleza hata suwe.” ");
INSERT INTO ngp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu niyo ahitula, “Hangi nyuwe wenye, nyuwe wahinizi we Miko mwawatwika want'hu nt'wika hezikwinulika, mna nyuwe wenye hamkuzidosa zint'wika izo hata na wadole wenyu. ");
INSERT INTO ngp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hangi nyuwe wenye, kwaviya mwaviwaka vikuta va walotezi mna watati zenyu nawo wawakomile. ");
INSERT INTO ngp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kwa ivo mwalonga uwona na kuzumila yadya yadamanywe ni watati zenyu, woho nawawakoma nyuwe nanywe mwaviwaka vikuta vawe. ");
INSERT INTO ngp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwe mbuli iyo mzungu wa Mnungu nougamba, ‘Kaula, neniwegaile walotezi na wegala ulosi, woho nawawakome, hamwenga na kuwasulumiza wamwenga.’ ");
INSERT INTO ngp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kwe mbuli iyo want'hu we cheleko iki nawasengelwe kwa kuwakoma walotezi kukongela kuumbigwa kwe isi. ");
INSERT INTO ngp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kukongela sakame ya Habili mpaka sakame ya Zakalia, akomigwe hagati ye vilingo ne nyumba ya Mnungu. Naho nawagambilani ikindedi kugamba, sakame iyo naiungigwe kulawa mwe cheleko iki. ");
INSERT INTO ngp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Hangi nyuwe wenye nyuwe wahinizi we miko kwaviya mkiusa kiya kikomoelo cho ubala wo kwingila kwa Mnungu, wenye hamwingile wadya nawo wandile wakengila mwawafingiza.” ");
INSERT INTO ngp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu eze afose umwo, wahinizi we Miko na Mafalisayo, nawakamviga viga hamwenga na kumgeza kwa maswali yabindile ingi. ");
INSERT INTO ngp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Naho nawakamongola vileke wamgwile kwa mbuli ikulawa mwo mnomo wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mo wingi wa want'hu wamzungulukaga Yesu, niyo want'hu wata kujatana, Yesu niyo akonga kuwagambila wanamp'hina wakwe, “Indeni na wengele mkeamile no ugwadu wa mafalisayo. ");
INSERT INTO ngp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mna haihali mbuli ya kifiso heize imanyike naho hata diya difisigwe nedize dimanyike. ");
INSERT INTO ngp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwa ivo yadya yose myalongele mwo lwiza nayeze yevike kungaile, na yadya mtile kutakamizana kwe chumba kundani, nayeze yabilikizwe kulanga kwe zinyumba. ");
INSERT INTO ngp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nawagambilani nyuwe wambuya zangu, mse kuwogoha wadya wakudaha kukoma umwili niyo hawakudaha kudamanya chochose kiihile, ");
INSERT INTO ngp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","mna neniwalagise yudya mkuungigwa mmogohe, mwogoheni Mnungu yehe akudaha kukoma mnt'hu na kumgela mwo moto houkuzima wa ulo na ulo, namigambilani mwogoheni uyo! ");
INSERT INTO ngp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Watolondo waidi hawakutagigwa kwa matundu mageke? Naho hakakujaligwa hata kamwenga mwa meso ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mna hata fili zimwe imitwi yenyu zoseni ziwazwa, msekogoha nyuwe wedi vitendese, kujink'ha madege. ");
INSERT INTO ngp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nawagambilani ikindedi yudya akuunga ana nzumile mwa meso ya want'hu, mwana wa Mnt'hu naye naamzumile hameso ya mtumigwa ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mna yoyose akuunga anilemele, kwa want'hu, name nenimlemele mwa meso ya mtumigwa ywa kwe Mbingu ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yeyose akumlongela mbuli yeyose iihile mwana wa mnt'hu, naausilwe wavu wakwe, mna akumhomola Muye ywa Mnungu haausilwe wavu wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Wanamigalani mwe nyumba za Mnungu, hamwenga na kwa maliwali na wata udahi, msekogoha mkafanyanya viya mkunga muwahitule na kulonga. ");
INSERT INTO ngp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwaviya Muye ywa Mnungu naawahinizize yadya mkuunga mlonge.” ");
INSERT INTO ngp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mnt'hu yumwenga mdya mwo diya difyo, niyo amgambila Yesu, “Mhinizi, mgambile ngugu ywangu anink'he kipe changu mwo udya chasilwe ni tati yetu.” ");
INSERT INTO ngp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu niyo ahitula, “Mbuyangu, ni ani anitendile miye ninde mlamuzi mwa nyuwe?” ");
INSERT INTO ngp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Niyo awagamba, “Hangi nyuwe wenye, msekunda na ugubaguba wi hengi, Kwaviya, ugima wa, mnt'hu haumuli mwe wingi we vint'hu vakwe ananavo.” ");
INSERT INTO ngp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu niyo awagambila mliganyizo, “Mgunda wa mnt'hu yumwenga mgoli na welekesaga, ");
INSERT INTO ngp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mnt'hu yudya niyo akonga kubanikanyanya ko umoyo wakwe, na kugamba, ‘Nenitende vivihi Kwaviya hina hant'hu ho kuikila ulozo uno? ");
INSERT INTO ngp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Niyo agamba, nenidamanye ivi,’ nenimole magulu yangu yose niyo nazenga matuhu makulu, ‘mwa magulu ayo neniike nk'hande yangu yose na vint'hu vangu. ");
INSERT INTO ngp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aho, neniugambe umoyo wangu, haluse hikwiikila nk'hande ye myaka yose, kehumuile, udye, unywe, unde ne kinyemi!’ ");
INSERT INTO ngp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mna Mnungu niyo amgamba, ‘Weye u mhezi, kilo iki cha dyelo waunga umoyo wako, ivint'hu vose wiikile ne vinde vaani?’ ” ");
INSERT INTO ngp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu niyo abindiliza kwa kugamba, “Nivo vili kwa mnt'hu akukeikila ugoli mna hakukeika lumwe kwe mbuli ya Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Niyo Yesu awagamba wanamp'hina wakwe, “Kwa mbuli iyo nawagambilani, msekufanyanya nomdyei, hegu nomvalei. ");
INSERT INTO ngp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwaviya ugima wajink'ha nk'hande, umwili nao wajink'ha suke. ");
INSERT INTO ngp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hake kauleni amakungulu, hayakuhanda, hayakuvuna naho hayana magulu, mna Mnungu ayenk'ha nk'hande. Nyuwe mwi wedi vitendese kujink'ha wadege. ");
INSERT INTO ngp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni yuhi mwa nyuwe akudaha kukeongezela utali wakwe hata mkono umwenga? ");
INSERT INTO ngp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Uneva hamkudaha dodo sa idyo, ni kugoha izimbuli zint'huhu? ");
INSERT INTO ngp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kauleni mabwali ivo yakuhota, haya kudamanya ndima naho hayakukedamanyila suke, namigambilani, hata zumbe Sulemani no uwedi utendese wakwe akei kuvaligwa vedi enga bwali dyodyose mwa aya. ");
INSERT INTO ngp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Uneva Mnungu ayavala vedi mani ya kwe mbago, yoho dielo yeaho mna luvi yaduulwa kwe mbago, ivo haawadamanyileni nyuwe vitendese, nyuwe mhungukilwe ni mhuwi? ");
INSERT INTO ngp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Nyuwe msekwangadika kwa kiya mkuunga mdye na kiya mkuunga mnywe, naho msekunda na kituletule, ");
INSERT INTO ngp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","kwaviya ayo yose want'hu we isi, wangadika wakayazungula. Mna Tati yenyu wa kwe mbingu kamanya kugamba mwayaunga ayo. ");
INSERT INTO ngp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kongeni kuuzungula Useuta wa Mnungu ayo yose namwongezelwe. ");
INSERT INTO ngp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nyuwe bunga dodo, msekogoha, kwaviya Tati yenyu kelelwa kuwenk'hani Kiseuta. ");
INSERT INTO ngp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tageni ivint'hu venyu vose mkawenk'he wakiwa, kedamanyileni nk'hoba hezikusakala, kindolo heikuhunguka ukwo kwe mbingu hant'hu hahakubuligwa ni mbavi naho hezidingwe ni vuvu. ");
INSERT INTO ngp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwaviya vindolo venyu hadya vikuunga vinde naaho imioyo yenyu ikuunga ikale. ");
INSERT INTO ngp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Keikeni lumwe kwa mbuli yoyose idya ikuunga ilaile, naho vimuli venyu vinde vakweela. ");
INSERT INTO ngp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nanywe indeni enga want'hu wakumgojela zumbe ywawe akuunga auye kulawa kwe ndoza, vileke aneza na kugamba kuno, wamkomwoele. ");
INSERT INTO ngp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wavikilwa wadya wandima zumbe ywawe uneva akauya naawabwiile we meso. Nawagambilani ikindedi, naahambule dikoti dyakwe niyo awagamba wahumule hasi niyo awaikila nk'hande. ");
INSERT INTO ngp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wavikilwa uneva aneza mwe kilo gati niyo awabwiila we meso. ");
INSERT INTO ngp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mna mmanye kugamba, mta nyumba amanyize lupisi akwizila mbavi hegu nakekala meso, seka nyumba yakwe ikamoligwa. ");
INSERT INTO ngp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nyuwe nanywe keikeni lumwe, kwaviya mwana Mnt'hu neeze mwo lupisi ludya hemwilumanyize.” ");
INSERT INTO ngp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulo niyo amgamba, “Zumbe mliganyizo uno wetu suwe, hegu wa want'hu wose?” ");
INSERT INTO ngp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Zumbe niyo amhitula, “Ni ani elo mndima mhuwilwa mbala, akuunga aikigwe ni zumbe ywakwe kunda mkimalizi mwo undima wakwe wose, akuwenk'ha nk'hande mwo lupisi ludya lukuungwa? ");
INSERT INTO ngp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kavikilwa mtumwa uyo, umwo zumbe ywakwe akauya ambwiila akadamanya enga ivo. ");
INSERT INTO ngp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ikindedi nawagambilani, naamwiike ande mkimalizi we vint'hu vakwe vose. ");
INSERT INTO ngp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mna uneva mtumwa yudya analonga mwo moyo wakwe kugamba, mkulu ywakwe hakusunguza kuuya niyo akonga kuwatoa wandima watuhu, we kigosi na we kivele, hamwenga na kukonga kudya na kunywa no kukolwa, ");
INSERT INTO ngp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mkulu ywakwe mtumwa uyo naauye zuwa hedikumanyika naho mwo lupisi helukumanyika. Uyo mkulu ywakwe naamsengele niyo amwiika hamwenga na wadya hi wahuwilwa. ");
INSERT INTO ngp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mna mtumwa yudya amanyize ivo akuunga mkulu ywakwe, mna hadamanye viya akuunga uyo mkulu nywakwe naamsulumizise. ");
INSERT INTO ngp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mna yudya hemmanyize mna kadamanya vikuungwa naatoigwe ludodo. Naho kila enk'higwe vingi kulawa kwakwe neviungwe vingi, naho yudya amwikile ukulu we vint'hu vingi kulawa kwakwe awaunge vingi. ");
INSERT INTO ngp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Hiza vileke isi inde mwo moto, naho ivi naluse moto ukimp'huka! ");
INSERT INTO ngp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mna nnanawo ubatizo nikuungigwa nibatizwe, name nna makunt'ho yatendese mpaka niyakint'hize. ");
INSERT INTO ngp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Togoleni mwagamba hiza kwigala utondowazi mwe isi? Hiyo ivo hiza vileke kunde na kupangana. ");
INSERT INTO ngp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kukongela ivi haluse, nyumba ya want'hu washano ne inde ikepanga, watatu kwa waidi, waidi kwa watatu. ");
INSERT INTO ngp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Watate hawaivane na wana wawe wana nawo hawaivane na watati zawe. Wamnala nao hawaivane na wana wawe we kike, wana kike nawo hawaivane na wamamizawe. Wamnala hawaivane na wake wana wawe, wake wana nawo hawaivane na wamamizawe vyala.” ");
INSERT INTO ngp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu alonga na want'hu naho kugamba, “Mnaona vunde ditandala kwo uswelo wa zuwa, mwagamba fula yeza naho yanda ivo, ");
INSERT INTO ngp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mnaona mp'heho nk'hali yavuguta, mwagamba nokubwikane, naho vanda iivo. ");
INSERT INTO ngp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nyuwe watondwe Mwamanya kubunk'hula hali ye isi no ulanga, yanda vihi kunda hammanyize kuvumbula zimbuli zo lupisi ulu? ");
INSERT INTO ngp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nii hamkudaha kulamula nyuwe wenye mbuli zo wedi zo kudamanya? ");
INSERT INTO ngp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kwaviya unatimilana na yudya akukulogeleza mkaita kwa mlamuzi, kombeka mwivane umwo mwe sila, mnase kukwigala mlamuzi, yudya mlamuzi naakwigale mtowani akuunga akugele mwa masa naho naakuvugaile mwe divugailo. ");
INSERT INTO ngp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nakugambila, houfose umwo mpaka ulihe pele tundu ukutigizwa.” ");
INSERT INTO ngp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mwo lupisi ludya handaga na want'hu wamgambilaga Yesu mbuli ya Wagalilaya wakomigwe ni Pilato umwo wandaga wakalava nt'hambiko kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu niyo awahitula akawagamba, “Nyuwe mwagamba wadya wagalilaya nawandilisa wavu, kujink'ha wagalilaya watuhu, vikaleka wakomwe? ");
INSERT INTO ngp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nawagambani hiyo ivo, mna nyuwe nanywe hamnakweiile wavu wenyu, nanywe nombanike enga viya wabanike woho. ");
INSERT INTO ngp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hegu wadya mlongo na mnane, wagweelwe nu mnala kudya Siloamu niyo wabanika, mwagamba watenda wavu kujink'ha watuhu wose wakwikala Yelusalemu? ");
INSERT INTO ngp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ikindedi hiyo ivo, Naho nawagambilani kugamba, hamna kweiile wavu wenyu, nombanike enga viya wabanike woho.” ");
INSERT INTO ngp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Niyo Yesu awagambila mliganyizo uno ukugamba, “kwandaga na mnt'hu ahandaga tini mwe nk'honde ye mizabibu. Agendaga kukaula uneva naapate tunda dyakwe, mna niyo aswesa. ");
INSERT INTO ngp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Niyo amgamba yudya akwamila, kaula myaka mitatu hinda heza vileke nikaule ntini mwo mtini uno, mna hikuona chochose, usenge ugwe hasi niiwakula kwa kubananga isanga bule? ");
INSERT INTO ngp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mna yudya mwamizi niyo amhitula, ‘Zumbe, vileke naho mo umwaka uno, niuhailile na kuugeela uwolo. ");
INSERT INTO ngp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Niho, u neva uneleka mo mwaka ukwiza, nevindilise ni vedi, mna hauneleke wadaha kuusegela hasi.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Zuwa dimwenga dyo kuhumula, Yesu andaga aka hiniza mwe nyumba yo kuvikila. ");
INSERT INTO ngp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aaho handaga na mvele yumwenga andaga na mp'hepo, yamtendaga ande mnyonge kwa myaka mlongo na mnane, naho nakabunt'hika, heekudaha kukimaala kwa kuchuluka. ");
INSERT INTO ngp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu eze amuone niyo amwitanga, no kumgamba mnala kuhonyigwa unyonge wako. ");
INSERT INTO ngp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Niyo amwikila mikono, ahadya mwili wakwe niyo wachuluka, niyo akonga kumtogola Mnungu ");
INSERT INTO ngp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mna mkulu we nyumba ya kuvikila, ahigagwa kwaviya Yesu amhonyaga Mnt'hu mwe dizuwa dyo kuhumula, ivo niyo awagamba want'hu, “yeyuko mazuwa nt'hatu ya kudamanya ndima, ivo mwize mwa mazuwa ayo mwize mhonywe!” ");
INSERT INTO ngp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mna Zumbe Yesu niyo amhitula, “Nyuwe watondwe! Kila yumwenga ywenyu hakukomoela mp'hunda yakwe hegu ng'ombe kulawa kwe didewa no kugenda kuinywesa kwa mazi mwe di zuwa dyo kuhumula? ");
INSERT INTO ngp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Uyu mvele ni ywa cheleko cha Ibulahimu, kazinganizwa ni Mwavu kwa myaka mlongo na mnane, togola hivo vedi kuhonyigwa mwe dizuwa dyo kuhumula?” ");
INSERT INTO ngp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Eze alonge ayo wahigani wakwe wose wengilaga soni, mna want'hu waonaga kinyemi kwe zimbuli ziya Yesu andamanyaga. ");
INSERT INTO ngp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu niyo auza, “Useuta wa Mnungu ni kint'hu chani? Naho niuliganyize nai? ");
INSERT INTO ngp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wikala enga ivi. Mt'hu yumwenga aguhaga kabeyu kadodo kujink'ha vibeyu vose vidodo vi mwe isi, niyo akamyaga mwe nk'honde yakwe, niyo kakula no kutenda ziti kulu, niyo madege yeza kuzenga masasa yawe mwa matambi yakwe.” ");
INSERT INTO ngp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Niyo auza naho, “Neni uliganyize na kint'hu chani Useuta wa Mnungu? ");
INSERT INTO ngp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wikala enga ivi, Mvele yumwenga aguhaga kint'hu cho ugwadu, niyo ahanganya na mp'hishi milongo mine yo unga, niyo unga wose wagwaduka.” ");
INSERT INTO ngp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ombokelaga mwe mizi na mwe zi kaya, akahiniza want'hu no kugendeela ne nt'hambo yakwe kuita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mnt'hu yumwenga niyo amwuza, “Zumbe, niwant'hu wageke wakuunga wayokolwe?” Yesu amhitulaga kugamba, ");
INSERT INTO ngp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mkombeke kombokela mwo lwivi lufinyu, kwaviya want'hu wengi nawaungise kwingila mwo lwivi ulo, mna hawadahe. ");
INSERT INTO ngp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aho mta inyumba naakimale no kuvugala ulwivi, niho mkeza kukimaala kuse no kuita ho lwivi no kugamba, ‘Kikomoele Zumbe!’ Naawahituleni kugamba, ‘Hiwamanyizeni uko mkulawa!’ ");
INSERT INTO ngp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Niho nomkonge kugamba suwe niwadya nekikadya no kunywa hamwenga na weye, nawe nouka kihiniza mwe mizi yetu. ");
INSERT INTO ngp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mna naahitule kugamba, ‘Hiwamanyizeni uko mkulawa, halaweni aha nyuwe awavu.’ ");
INSERT INTO ngp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Niho nokunde na ndilo no kugwegwejula meno, aho nomuwaone Ibulahimu, Isaka na Yakobo na walotezi wa Mnungu wose mo useuta wa Mnungu, umwo nyuwe mkaduulwa kuse. ");
INSERT INTO ngp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Want'hu naweze kulawa uailo na usweelo wa zuwa, na nt'hendelo zose ze isi, nokwikala hasi ho Useuta wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nivo wose weko uheelo nawande wa nk'hongo, wadya wa nk'hongo nawo nawazigiile.” ");
INSERT INTO ngp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lupisi uludya Mafalisayo wamwenga wambasaga Yesu, niyo wamgamba, “Halawe aha wiite hant'hu hatuhu, kwaviya Helode aunga akukome.” ");
INSERT INTO ngp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu niyo awahitula, “Iteni mka digambile idyo diuzi kugamba, ‘diyelo na luvi nagulusa mp'hepo na kuhonya wanyonge, naho zuwa dya katatu neni bindilize indima yangu.’ ");
INSERT INTO ngp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hata ivo vaniunga kutoza sila yangu dielo na luvi na kisindo, kwaviya hivo vedi kwa mlotezi kukomwa hant'hu hohose ila mwe Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yelusalemu! Weye, Yelusalemu, wawakoma walotezi na kuwatoa maiwe wadya wasigiilwe ni Mnungu kwako, malavo nyingahi niungile niwakunyatile want'hu wako enga viya nguku ikuya kunyatila hamwenga makinda yakwe, mna weye huungile. ");
INSERT INTO ngp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kauleni nawasilani inyumba yenyu. Nawagambilani ikindedi homnione naho, mpaka aho nomwize mgambe, ‘kavikilwa ni Mnungu yehe akwiza kwa zina dya Zumbe.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zuwa dimwenga dya kuhumula Yesu nakaita kudya mkande kwe kaya ya mnt'hu yumwenga kilongozi ywa Mafalisayo, aho handaga na want'hu wandaga wakampelemba Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Naho, handaga na mnt'hu yumwenga andile na unyonge wa belebele amwizilaga Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu niyo awauza wahinizi we Miko hamwenga na Mafalisayo kugamba ni vedi, “Miko yetu yakilekela kiwahonye want'hu mwe dizuwa dyo kuhumula?” ");
INSERT INTO ngp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mna niyo wanyamala. Yesu amtozaga yudya mnyonge niyo amhonya niyo amlekela akeitile. ");
INSERT INTO ngp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Eze ajike, niyo wawagamba, “Uneva yumwenga ywenyu anamwana hegu ng'ombe yakwe ingile mwe dibome, naho ni mwe dizuwa dyo kuhumula, haailave kwaviya ni zuwa dya kuhumula?” ");
INSERT INTO ngp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Niyo wadunduga kumhitula mbuli ino. ");
INSERT INTO ngp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu nakaona wadya walalikwe ivo nandaga wakasagula nk'halo zikulongole niyo awagambila mliganyo uno, ");
INSERT INTO ngp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Uneva unalalikwa mwe ndoza, use kwikala mwe zink'halo zikulongole inase kunda kuna mtuhu kukujink'ha weye alalikwe nu mkulu, ");
INSERT INTO ngp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","yudya naye awalalike aneza naakugambe, ‘Mwink'he sila miyao ekale mwo ukalo uno.’ Niho kwa soni noukekale kwo ukalo wa kunyuma. ");
INSERT INTO ngp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mna unalalikwa, ita ukekale kwo ukalo ukunyuma, vileke yudya akulalike aneza akugambe, ‘Mbuyangu, so uku kulongole.’ Ino neikwink'he uwedi utendese mwa meso ya wose mwikalanye hamwenga. ");
INSERT INTO ngp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwaviya wadya wakukekweza, nawaselezwe yudya naye akukeseleza naakwezwe.” ");
INSERT INTO ngp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu niyo amgamba yudya amlalike mwo wila, “Uneva unadamanya wila, usekulalika wambuyazo, hegu nduguzo, hegu ugoli, kwa idi unase kunda kulihigwa kwa yadya udamanye. ");
INSERT INTO ngp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mna unadamanya wila, uwalalike wadya hewena kint'hu, hamwenga na wadya hewekudaha kugenda, waholomp'hale, na hamwenga na mant'hunt'hu, ");
INSERT INTO ngp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","unatenda ivo no unde kuvikilwa kwaviya woho hawana kint'hu cha kukuliha, noulihigwe mwo kuuyulwa kwa wadya wedi wasagulwe ni Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mnt'hu yumwenga mwa wadya wekale na Yesu he nk'hande eze eve ivo niyo amgamba Yesu, “Nawande na kinyemi wadya wose wakuunga wekale hamwenga na Zumbe ho ludyo kwo Useuta wa Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu niyo amhitula, “Mnt'hu yumwenga na kadamanya wila mkulu niyo alalika want'hu wengi. ");
INSERT INTO ngp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wila wize ubule niyo amsigiila mtumwa ywakwe akawetange wadya wose awalalike kwaviya kila kint'hu nekiika lumwe. ");
INSERT INTO ngp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kila yumwenga mwa wadya walalikwe wandaga hawabuile. Ywa nk'hongo agambaga, ‘higula nk'honde, ivo vaniunga hailaule, nakweiila, nnekele haikaule.’ ");
INSERT INTO ngp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mtuhu niyo agamba, ‘Higula ng'ombe mlongo za kulimila ivo nagenda kuzigeza, nilekele niite.’ ");
INSERT INTO ngp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mtuhu niyo amgamba, ‘Hilomba mvele, kwaivo henize.’ ");
INSERT INTO ngp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Yudya mtumwa auyaga niyo amgambila zumbe ywakwe mbuli zose ivo zilaile. Yudya mkulu ahigagwa niyo amgamba mtumwa ywakwe, ‘Ita kwe zisila zi mk'handa na mwo mzi ukawaguhe haweena kint'hu ne viwete, na mant'hunt'hu, hamwenga na wadya waholomp'hale.’ ");
INSERT INTO ngp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Yudya mtumwa eze auye niyo agamba, ‘zumbe, hidamanya enga viya ulagize mna nyumba ikei kumema.’ ");
INSERT INTO ngp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Zumbe niyo amgamba mtumwa ywakwe, ‘Ita mwe zisila mp'handa na kwe mihaka yo mzi ukawatigize want'hu weze vileke nyumba yangu imeme. ");
INSERT INTO ngp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwa ivo nawagambilani hahali hata yumwenga mwe wadya walalikwe nk'hongo, akuunga auvine uwila wangu!’ ” ");
INSERT INTO ngp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Aho, Yesu awahitukilaga want'hu wengi awo wandaga wakamtimila, no kuwagamba, ");
INSERT INTO ngp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Uneva mnt'hu yeyose anibasa, hakudaha kunda mwanamp'hina ywangu uneva hakuniungisa miye kujink'ha welesi wakwe, na mkaziwe na wanawe na nduguze wa kigosi, na walumbuze, hamwenga na kujink'ha ivo akuungisa ugima wakwe mwenye. ");
INSERT INTO ngp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Heekudaha kwinula msalaba wakwe niyo anibasa hakudaha kunda mwanamp'hina ywangu. ");
INSERT INTO ngp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nauza, Ni yuhi mwa nyuwe anaunga kuzenga mnala hakwikala hasi na kuwaza ndima akuunga aidamanye na maliho yakwe vileke amanye kugamba ana matundu yakudaha kuibinda indima? ");
INSERT INTO ngp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Anase akadunduga kubindiliza anajika kusimba ink'hongelo du, niyo want'hu wose wamseka, ");
INSERT INTO ngp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wakagamba, ‘Mnt'hu uyu akakongaga kuzenga mna habindile!’ ");
INSERT INTO ngp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Hegu eyuko zumbe yeyose anaunga kugenda kutoana na zumbe miyawe, hakwikala hasi na kufanyanya kugamba yehe hamwenga na want'hu alufu nawadahe kutowana na yudya akwiza na want'hu alufu mbili? ");
INSERT INTO ngp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Hegu anaona haadahe, neegale ulosi aunge utondowazi, umwo yudya zumbe miyawe akei ehale. ");
INSERT INTO ngp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Enga kila yumwenga ywenyu” uneva hakudaha kwasa viya “ananavo hakudaha kunda mwanamp'hina ywangu. ");
INSERT INTO ngp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munyu, wedi, mna unabanika noutendigwe vivihi vileke unde wedi naho? ");
INSERT INTO ngp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haikuwagila mwe isi, hegu du hata kwe dizala, waduulwa hale vitendese. Mta magutwi neeve!” ");
INSERT INTO ngp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Zuwa dimwenga watoza ushulu wengi hamwenga na wata wavu wagendaga kumtegeleza Yesu, ");
INSERT INTO ngp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafalisayo na wahinizi we Miko iyo wakongaga kulafya, “Mnt'hu uyu awetanga wata wavu naho adya nao!” ");
INSERT INTO ngp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu niyo awagambila mliganyizo uno, ");
INSERT INTO ngp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Uneva yumwenga ywenyu ana ngoto gana imwenga niyo yaga, naatende vivihi? Naazileke ziya milongo kenda na kenda niyo aita kuizungula idya yagile mpaka aione. ");
INSERT INTO ngp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Anaiona akepika mwa maega kwa kinyemi, ");
INSERT INTO ngp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","no kuuya nayo kaya. Akabula kaya awetanga wambuyaze na nduguze niyo awagamba, ‘Indeni na kinyemi, kwaviya hiiona ingoto yangu yagile.’ ");
INSERT INTO ngp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Namigambilani, ivo nivo kukuunga kunde na kinyemi kwe mbingu kwa mbuli ya mta wavu yumwenga alekile wavu wakwe, kujink'ha wadya milongo kenda na kenda wandile wedi kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Hegu eyuko mvele yeyose mta matundu yakwe mlongo, anaza dimwenga haakweleze lumuli lwakwe no kuhagila nyumba ingima niyo azungula mpaka adione? ");
INSERT INTO ngp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Anadiona naawetange wambuyaze na wemgihi niyo kuwagamba, ‘Indeni na kinyemi kwaviya ne hyaza tundu dyangu mna hidiona.’ ");
INSERT INTO ngp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nawagambilani ikindedi, viligane na ivo, nivo wakunda na kinyemi watumigwa wa kwe mbingu uneva mnt'hu yumwenga mta wavu anamuuiya Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu niyo agendeela kulonga, “Mnt'hu yumwenga na kanda na wana waidi, ");
INSERT INTO ngp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","yudya umdodo niyo amgamba ise, ‘Tate nink'he ukipe wangu.’ Ise azumilaga niyo kumwink'ha. ");
INSERT INTO ngp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yeze yomboke mazuwa mageke yudya mwana niyo aguha vint'hu vakwe vose no kutamba isi ya hale. Niyo abinda ugoli wakwe wose kwa mbuli ya uhabwasi. ");
INSERT INTO ngp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Eze abinde vose viya endile navo niyo kwengila gumbo kulu mwe isi yose idya, yehe naye niyo anda hana kint'hu. ");
INSERT INTO ngp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Niyo alombeza ndima kwa mnt'hu yumwenga mwe idya isi. Yudya mnt'hu niyo amwigala kwe nk'honde yakwe akenk'hize zinguluwe nk'hande. ");
INSERT INTO ngp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naaka munk'hwa adye usiga zisigaze zinguluwe, mna hahali mnt'hu amwink'haga. ");
INSERT INTO ngp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Eze ekale hasi na kufanyanya, niyo alonga mo moyo wakwe, ‘Kudya kaya, tate ana wandima wakudya nk'hande na kusigaza, mna miye nafa sala! ");
INSERT INTO ngp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Neniite kwa tate niyo namgamba, Tate, hitenda wavu kwa Mnungu hamwenga na weye, ");
INSERT INTO ngp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","hiwagilwe kwitangwa mwanao, nitende enga yumwenga mwa watumwa wako.’ ");
INSERT INTO ngp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Niyo akonga nt'hambo ya kuuya kwa ise. “Eze ande hagihi na kaya, ise niyo amuona. Eze amuone, niyo amgulukila kwa mbazi na kumlamsa kwa kumkumbatila. ");
INSERT INTO ngp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yudya mwana niyo amgambila ise, ‘Tate hidamanya wavu kwa Mnungu hamwenga na kwako, hiwagilwe kwitangwa mwanao naho.’ ");
INSERT INTO ngp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mna ise niyo awagamba wandima wakwe, ‘Sunguzeni mmwigaile suke yedi mumvike, mgeleni na mp'hete mwa kadole niyo mwamvala vilatu. ");
INSERT INTO ngp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Leteni ndama igimbale muichinje vileke kidye no kunda na kinyemi. ");
INSERT INTO ngp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwaviya uyu mwanangu andaga enga kabanika mna kauyuka naho agaga mna kaoneka.’ Niyo wakonga kwanga. ");
INSERT INTO ngp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Yudya mwanawe mkulu andaga kwe nk'honde umwo andile akauya na kubula hagihi ne nyumba niyo eva want'hu wakwanga. ");
INSERT INTO ngp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Niyo amwitanga mtumwa yumwenga no kumuuza, ‘Kuna mbwai?’ ");
INSERT INTO ngp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yudya mtumwa niyo amhitula, ‘Nduguyo kauya,’ ‘naho iso kamchinjila ndama igimbale kwaviya kampata akei mgima.’ ");
INSERT INTO ngp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Yudya mwana mkulu niyo aihiwa no kulemela kwingila kaya. Ise niyo afosa kuse na kumhembeleza engile kwe nyumba. ");
INSERT INTO ngp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mna niyo amhitula ise, ‘Tate hake kaula, mazuwa yose nakudamanyila ndima enga mtumwa, naho hikwihiye mwe mbuli yoyose. Kunink'hai? Hunink'hile hata kabuzi vileke nidamanye wila na wambuyazangu, ");
INSERT INTO ngp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","mna uyu mwanao adile ugoli wako hamwenga na mapamp'he, eze auye niyo wamchinjila ndama idya igimbale!’ ");
INSERT INTO ngp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ise niyo amhitula, ‘mwanangu,’ ‘weye wi hamwenga na miye mazuwa yose, chochose kiya nnanacho ni chako. ");
INSERT INTO ngp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nevinda vedi kudamanya wila na kunda na kinyemi kwaviya uyu nduguyo andaga enga kabanika, mna kauyuka naho agaga mna kalondoka.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu niyo awagamba wanamp'hina wakwe, “Na handa na mnt'hu yumwenga, mgoli andile na mkimaila mbuli ywakwe. Nakalongelezwa kugamba naakabulunk'hanya ugoli wakwe.” ");
INSERT INTO ngp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yudya mgoli niyo amwitanga no kumuuza, “Ino mbuli yani hwiva umwako? Nink'he uwazilo wo ukimalizi wako kwaviya hukudaha kugendeela kunda mkimalizi.” ");
INSERT INTO ngp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yudya mkimalizi mbuli niyo akelongela mwo umoyo wakwe, “Nitende vivihi? Kwaviya zumbe ywangu aunga aniuse mwe ndima ino. Miye name hikudaha kulima naho hata kulombeza naona soni! ");
INSERT INTO ngp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Himanya idyo huunga nidamanye vileke wananifoseza mwo umkimalizi wanizumile mwe zinyumba zawe.” ");
INSERT INTO ngp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Niyo awetanga wadya wose wakudaiwa ni zumbe ywakwe, kukongela mnt'hu ya nk'hongo mpaka kwa mtuhu, niyo akonga kumgamba yudya ywa nk'hongo, “Zumbe ywangu ukudai yombe dyani?” ");
INSERT INTO ngp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Niyo amhitula, “Mavuta misungi gana.” ");
INSERT INTO ngp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Niyo amwuza mgeni mtuhu, “Weye wadaiwa yombe dyani?” Niyo amhitula, “Uhule magunia gana dimwenga.” Yudya mkimalizi niyo amgamba, “Guha ikalatasi yako ye dideni uwandike milongo mnane.” ");
INSERT INTO ngp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yudya zumbe niyo amtogola yudya mkimalizi aihile kwa yadya adamanye kwa ubala, kwaviya wana we isi ino mwe cheleko chawe wanda na ubala kujink'ha wana wo ung'azi. ");
INSERT INTO ngp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu niyo agamba, “Name nawagambilani, ketendeleni wambuya kwa ugoli wa wiihi wa mwe isi, vileke unasila wawalalikeni mwo mzi wa ulo na ulo.” ");
INSERT INTO ngp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mnt'hu yeyose mhuwilwa mwe mbuli ndodo na ende mhuwilwa mwe mbuli nk'hulu. Yudya naye hi mhuwilwa mwe mbuli ndodo na ande hi mhuwilwa mwe mbuli nk'hulu. ");
INSERT INTO ngp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Uneva nyuwe hamwandile wahuwilwa mwe mbuli ziihile za mwe isi, niani akuunga awahuwile mwo ugoli wa kulanga? ");
INSERT INTO ngp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hegu mkaswesa uhuwilwa mwe vint'hu va want'hu, niyuhi akuunga awenk'heni vint'hu venyu nyuwe wenye? ");
INSERT INTO ngp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hahali mtumwa akudaha kunda mtumwa ywa mazumbe waidi, kwaviya naamwihie yumwenga na kumwungisa mtuhu, hegu naaivane na yumwenga na kulemana na mtuhu. Hamkudaha kumdamanyila ndima Mnungu na kuudamanyila ndima ugoli. ");
INSERT INTO ngp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mna kwaviya mafalisayo wenye wandaga wakaungisa matundu, weze weve ayo yose, niyo wamtendela lubezo Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu niyo awagamba, “Nyuwe mwaketenda want'hu wedi kujink'ha watuhu, mna Mnungu kamanya imioyo yenyu, kwaviya kint'hu kikuoneka kunda chedi kwa want'hu, kwa Mnungu chaoneka hi kint'hu. ");
INSERT INTO ngp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sigilizi za musa enk'higwe ni Mnungu hamwenga na mawandiko ya walotezi vandaga uko mpaka mwe lupisi che Yohana mbatizi, kukongela aho Useuta wa Mnungu wabilikizwa naho kila yumwenga awingila kwa ludole. ");
INSERT INTO ngp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mna ni vihufu vitendese mbingu ne Isi komboka, mna haikudahika kuusa hata helufi imwenga mndani mwe miko. ");
INSERT INTO ngp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mnt'hu yoyose akumwasa mkaziwe niyo alomba mtuhu, ahabwasa. Na yudya akuunga amlombe yudya asigwe ahabwasa. ");
INSERT INTO ngp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Handaga na mnt'hu yumwenga mgoli, Availe suke zedi vidala na kwikala wikazi wedi vitendese. ");
INSERT INTO ngp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naho, handaga na mkiwa yumwenga akwitangwa Lazalo, mkiwa uyo na kanda na nkhenge mwili wose, want'hu nawakamgoneza ho lwivi we inyumba ya yudya mgoli. ");
INSERT INTO ngp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yudya mkiwa naakaungisa adye masigazi yatomokaga hasi kulawa mwe meza idya akudiila mgoli. Naho makuli nayakeza yakamlambita mnengenkwenge zakwe hadya agonile. ");
INSERT INTO ngp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Yudya mkiwa niyo abanika, mtumigwa ywa kwe Mbingu niyo wamguha akwikala haguhi na Ibulahimu. Yudya mgoli naye niyo abanika na kumoswa msanga. ");
INSERT INTO ngp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mgoli niyo anda na masulumizo vidala kudya masinyungu, eze enule meso yakwe, kwa hale niyo amuwona Ibulahimu kekala hagihi na Lazalo. ");
INSERT INTO ngp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Niyo etanga kwa Izwi kulu, ‘Tate Ibulahimu, nonele mbazi. Mgambe Lazalo achank'hize kadole mwa mazi vileke ausangalaze lulimi lwangu. Kwaviya ni mwe masulumizo makulu mwo umoto uno.’ ");
INSERT INTO ngp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ibulahimu niyo amhitula, ‘Mwanangu, kumbukila weye viya uhokele yedi mwe wikazi wako kwe isi, mna Lazalo nakahokela yaihile. Mna ivi haluse yehe ahokela yedi mna weye wasulumizwa. ");
INSERT INTO ngp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Naho mna, hagati hetu, nyuwe na suwe hana bome kulu vileke wadya wakunga kulawa nt'hendelo imwenga kwita nt'huhu wasekudaha.’ ");
INSERT INTO ngp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yudya mgoli niyo agamba, ‘Haluse, Tate nakulombeza umsigile kwe inyumba ya wandugu zangu, ");
INSERT INTO ngp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwaviya nnanawo wandugu washano vileke akawagambile, woho nao wanase wabule hant'hu aha ha masulumizo.’ ");
INSERT INTO ngp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mna Ibulahimu niyo amgamba, ‘Wanduguzo nawamtegeleze Musa hamwenga na walotezi wa Mnungu watuhu.’ ");
INSERT INTO ngp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mna yudya mgoli niyo agamba, ‘Hiyo ivo tate Ibulahimu uneva mnt'hu anauyuka kulawa uku nawamhitukile Mnungu.’ ");
INSERT INTO ngp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mna Ibulahimu niyo amhitula, ‘Uneva hawanawevile Musa na walotezi wa Mnungu watuhu, hata anauyuka mnt'hu anawabasa hawamwive.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu niyo awagamba wanamp'hina wakwe, “Mbuli zikumtenda mnt'hu agwe mwe wavu zaungigwa zilaile, mna naakaulise mnt'hu uyo akutenda mbuli izo zilaile.” ");
INSERT INTO ngp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ne vinda vedi mnt'hu uyo iwe kulu difungigwe mwe singo yakwe akadulwe mwe bahali. Mna kujink'ha kumwazaganya yumwenga mwa wadodo awa niyo wadamanya wiihi. ");
INSERT INTO ngp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hangi nyuwe wenye! Uneva nduguyo anakutendela viihile mkanye, naho anakeiila muusile wavu. ");
INSERT INTO ngp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Hegu anakwihiza malavo mfungate mwe zuwa dimwenga na kwiza kwako malavo mfungate na kukugamba hikudamanyila viihile! Muusile uwavu. ");
INSERT INTO ngp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wegala ulosi niyo wamgamba, “Zumbe uchongezele mhuwi.” ");
INSERT INTO ngp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zumbe naye niyo awahitula, “Mwandile na mhuwi mdodo enga mbeyu ye haladali, namkadaha kuugambila mti uno, ‘Ng'oka wite kwe bahali, nao niyo wakutegeleza.’ ");
INSERT INTO ngp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Uneva yumwenga wenyu ana mtumwa ywakwe akulima kwo mgunda, hegu akudima magoto naho anauya kulawa kwo mgunda naamgambe, soo udye nk'hande? ");
INSERT INTO ngp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Haikudahika! Naamgambe, ‘Nitengele nk'hande yangu, naho nigojele ninde kudya hakuheza naaho weye ukonge kukedamanyila nk'hande yako.’ ");
INSERT INTO ngp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Naamtogole yudya mtumwa kwaviya katimila yadya agambilwe? ");
INSERT INTO ngp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iviya, hata nyuwe mnadamanya yadya yose mgambilwe gambeni, ‘Suwe kiwandima mzungu kint'hu naho kidamanya yadya nekikaungigwa kidamanye.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Umwo Yesu andile mwe int'hambo ya kwita Yelusalemu, nakombokela mwe imihaka ye Samalia na Galilaya. ");
INSERT INTO ngp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Viya andile akengila mwe kaya, niyo adugana na want'hu mlongo wandile wakahuma matana. Wakimalaga hale, ");
INSERT INTO ngp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","niyo wakweza izwi wakagamba, “Zumbe Yesu, ukionele mbazi,” ");
INSERT INTO ngp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eze awaone niyo awagamba, “Iteni kwa walava nt'hambiko, mkakelagise.” Mna Umwo wakaita, niyo amatana yawe yahona. ");
INSERT INTO ngp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumwenga eze aone kahonywa niyo auya uku akamtogola Mnungu kwa izwi kulu. ");
INSERT INTO ngp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Niyo amfikila Yesu madi na kumtogola, naho mnt'hu uyo andaga Msamalia. ");
INSERT INTO ngp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu niyo agamba, “Wahonyigwe na wanda mlongo, wadya kanda weihi? ");
INSERT INTO ngp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hahali mtuhu auiye kwiza kumtogola Mnungu mna nu uyu Mgeni du?” ");
INSERT INTO ngp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu niyo amgamba, “Kimala ukeitile, mhuwi wako ukuhonya.” ");
INSERT INTO ngp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafalisayo watuhu niyo wamuuza Yesu kugamba, Useuta wa Mnungu nowize ini? Yesu niyo awahitula, “Useuta wa Mnungu howize kwa kuukaula kaula. ");
INSERT INTO ngp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Naho hahali akudaha kugamba, ‘Kaula!’ Wi uku. ‘Hegu wi kudya!’ kwaviya Useuta wa Mnungu wi mndani mwenyu.” ");
INSERT INTO ngp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Niyo awagamba wanamp'hina wakwe, “Mazuwa yeza yadya nomuungise kuwona dimwenga mwa mazuwa ya mwana ywa mnt'hu, mna homuwone hata dimwenga. ");
INSERT INTO ngp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Naho want'hu nawamigambeni, ‘Kauleni e kudya hegu e uku!’ Msekuita naho msekuwatimila. ");
INSERT INTO ngp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwaviya enga lumwemwe ukukweela na kulangaza uko na uko nivo nainde imiziile yakwe mwana wa Adamu mwe dizuwa idyo. ");
INSERT INTO ngp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mna aungigwa ande kusulumizwa na kulemelwa na want'hu wa amazuwa aya. ");
INSERT INTO ngp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Enga viya vandile mwe ulupisi cha Nuhu, nivo vikunga vinde mwe ulupisi cha Mwana wa Adamu. ");
INSERT INTO ngp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Want'hu nawakadya na ukunywa, nawakalomba na kulombigwa mpaka lupidi ludya Nuhu eze engile mwe safina. Mazi niyo yalaila na kuwakoma wose. ");
INSERT INTO ngp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nainde enga viya valailaga mwe ulupisi cha Lutu, want'hu nawakadya na ukunywa, wakagula na kutaga, wakamyaga na kuzenga. ");
INSERT INTO ngp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mna mwe zuwa diya Lutu eze ahalawe mwe Isi ye Sodoma niyo kwalaila moto wa kibiliti kulanga na kuwakoma want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ivo niivo vikunga vinde zuwa dia akwizila Mwana wa Mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Zuwa idyo mnt'hu yeyose emnanga mwe digulu asekuseela kwita kwe nyumba kuguha ivint'hu vakwe. Sa ivo mnt'hu ekwe nk'honde asekuuya kaya. ");
INSERT INTO ngp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukileni yadya yampataga mkaza Lutu ");
INSERT INTO ngp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mnt'hu yeyose akuunga awazaganye umoyo wakwe naauhonye, na yudya akuunga auhonye na awaze. ");
INSERT INTO ngp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nawagambilani, mwe kilo cha zuwa idyo, want'hu waidi nawende wagona hamwenga, yumwenga naaguhigwe, na mtuhu naasigwe. ");
INSERT INTO ngp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wavele waidi nawande hamwenga mwo kubunda, yumwenga naaguhigwe na mtuhu naasigwe.” ");
INSERT INTO ngp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Want'hu waidi nawande kwo mgunda yumwenga naguhigwe yudya mtuhu naasigwe ");
INSERT INTO ngp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wana mp'hina niyo wamuuza Yesu, “Zumbe ni kuhi?” Yesu niyo awahitula, “Hadya hane kimba naho hakukimala ndege nyika.” ");
INSERT INTO ngp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu niyo awagambila wanamp'hina wakwe mliganyizo, uwahinize kugamba, waungwa kulombeza haheina kuhwa moyo. ");
INSERT INTO ngp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Kwandaga na mlamuzi mwo mzi umwenga, hemogohaga Mnungu hegu mnt'hu yeyose. ");
INSERT INTO ngp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Umwo mwandaga na mvele yumwenga abanikilagwa ni mgosiwe. Nakamwitila itila yudya mlamuzi akamgamba ‘Hake kilamuile miye no mwiihi ywangu!’ ");
INSERT INTO ngp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa mazuwa mengi yudya mlamuzi andaga akalemela, mna vize vigendeele niyo agamba hata uneva hikumogoha Mnungu na want'hu, ");
INSERT INTO ngp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kwe nk'huswa nk'huswa akunink'ha uyu mvele, neni ikaule imbuli yakwe nimwink'he yadya awagilwe. Hinamwink'hile naanisokeze kwa kunibasa basa!” ");
INSERT INTO ngp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naho Zumbe agendelaaga akagamba, “Tegelezeni mlamuzi aihile ivo alongaga. ");
INSERT INTO ngp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Togleni! Kigambe Mnungu haawatowanile wadya awasagule wakumwiila kilo na msi? Naho naande na kisese mo kuwambiza awant'hu awo? ");
INSERT INTO ngp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nawagambilani, naawenk'he ludole yadya wawagilwe. Mna Mwana wa Mnt'hu naabwiile mhuwi umwo akeza?” ");
INSERT INTO ngp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iviya iviya Yesu nakawagambila mliganyizo want'hu wadya wakukeona wedi naho wawasinyaga watuhu. ");
INSERT INTO ngp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kwandaga na want'hu waidi waitaga ko kumlombeza Mnungu, yumwenga andaga mfalisayo, mtuhu naye andaga mtoza kodi. ");
INSERT INTO ngp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yudya mfalisayo niyo akimaala akamlombeza Mnungu ko umoyo wakwe akagamba, “Mnungu, nakutogola kwaviya miye hiyo enga want'hu watuhu wagubaguba, hewekuhuwilwa, wahabwasi, naho hiyo enga uyu mtoza kodi. ");
INSERT INTO ngp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Miye nafunga mazuwa maidi mwa kila mazuwa mfungate naho naliha imwenga ya mlongo mwe viya hupata.” ");
INSERT INTO ngp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mna mtoza kodi, akimaalaga luhale niyo yanda ogohaga hata kwinuila meso yakwe kulanga, akatowa mwekifua chakwe na kugamba, “Mnungu, nifiile mbazi miye Mwavu!” ");
INSERT INTO ngp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu niyo agamba, “Nawagambilani, mtoza kodi, aitaga kaya amuwagile Mnungu, kujink'ha yudya mfalisayo, kwaviya yudya akukeinula naakinywe hasi, mna akukebela naatunywe.” ");
INSERT INTO ngp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Want'hu niyo wamwigaila Yesu wana wadodo vileke awagelekele mikono. Wanamp'hina weze wawaone, niyo wawativila. ");
INSERT INTO ngp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mna Yesu niyo awetanga wadya wana akagamba, “Walekeni wana wadodo weze kwangu, msekuwafingiza, kwaviya wana wadodo enga awa Useuta wa Mnungu wiikiwa want'hu enga awa. ");
INSERT INTO ngp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nawagambilani ikindedi, mnt'hu yeyose hakuuhokela Useuta wa Mnungu enga mwana mdodo heingile uko,” ");
INSERT INTO ngp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mnt'hu yumwenga Mkulu, amuuzaga Yesu akamgamba, “Mhinizi ywedi, nitende vivihi vileke ningile ko ugima wa ulo na ulo?” ");
INSERT INTO ngp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu niyo amuuza, “Nii wanigamba ywedi? Hakuli mnt'hu ywedi, ywedi ni yumwenga du, naye ni Mnungu ekedu. ");
INSERT INTO ngp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kuimanya imiko, ‘Usekunda mhabwasi, usekukoma, usekubawa, usekudant'ha, uwogohe mamiyako na tati yako.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yudya mnt'hu niyo ahitula kugamba, “Ayo yose hiyatoza kukongela udodo wangu.” ");
INSERT INTO ngp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu eze eve ivo, niyo amgamba yudya mnt'hu, “Kusigaza kint'hu kimwenga cho kudamanya. Taga vose viya unanavo, uwapangile wakiwa amatundu, niho nounde no ugoli uko kulanga, akajika wize unitimile.” ");
INSERT INTO ngp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mna yudya mnt'hu eze eve ivo, niyo engila kinyulu, kwaviya andilisaga mgoli. ");
INSERT INTO ngp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu nakamuona yudya mnt'hu kugamba kengilwa ni kinyulu, “Niyo agamba, vidala vitendese kwa mta ugoli kwingila ko Useuta wa Mnungu! ");
INSERT INTO ngp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Naho ni vihufu vitendese ngamia kombokela mwe dilanga dye singano kujink'ha mgoli kwingila mo Useuta wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wadya want'hu weze weve niyo wamuuza Yesu, “Haluse ni ani naayokolwe?” ");
INSERT INTO ngp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu niyo ahitula, “Heyekudahika kwa want'hu, kwa Mnungu yadahika.” ");
INSERT INTO ngp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petulo niyo amgamba, “Kaula suwe kileka kaya zetu niyo chakutimila weye.” ");
INSERT INTO ngp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu niyo awagamba, “Heiye, naho nawagambilani ikindedi, yeyose akuleka kaya yakwe, na mkaziwe na wandugu na welesi wakwe, kwa kuuzungula Useuta wa Mnungu, ");
INSERT INTO ngp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","naahokele vitendese ivi haluse, akajika naho ugima wa ulo na ulo kwa mazuwa ya kwiza.” ");
INSERT INTO ngp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu niyo awaguha wadya mlongo na waidi no kuwagamba, “Kauleni chaita Yelusalemu, kudya kila kiya kiwandikwe na walotezi, mo Mwana ywa Mnt'hu nekilaile. ");
INSERT INTO ngp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwaviya naageligwe mwe mikono ya want'hu hewemmanyize Mnungu, nawambele, nawamtendele kasidi, nokumtweela mate. ");
INSERT INTO ngp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nawamtowe mikotya no kumkoma mna mwe dizuwa dya katatu, naauyuke.” ");
INSERT INTO ngp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mna hawakombaganye dyodyose mwa ayo alongile, kia alongile nekikefisa kwawe, naho hawamanyize yadya alongile. ");
INSERT INTO ngp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu eze ande hagihi na Yeliko, handaga na mnt'hu yumwenga mant'hunt'hu, ekale hagihi ne sila akalombeza. ");
INSERT INTO ngp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eze eve idifyo dya want'hu dyomboka, niyo auza, “Kuna mbwai?” ");
INSERT INTO ngp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Niyo wamgamba, “Yesu wa Nazaleti omboka.” ");
INSERT INTO ngp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Niyo agutila akagamba, “Yesu, mwana Daudi nifiile mbazi!” ");
INSERT INTO ngp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wadya want'hu walongole niyo wamtivila no kumgamba anyamale, Mna yehe niyo ongezelesa kugutila akagamba, “Mwana wa Daudi nifiile mbazi.” ");
INSERT INTO ngp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Niyo Yesu akimaala no kusigila wamwigale kwakwe yudya mant'hunt'hu. Eze abule hagihi niyo Yesu amuuza, ");
INSERT INTO ngp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Waunga hutendelei?” Niyo ahitula, “Zumbe, naunga nivuzilwe ukuona.” ");
INSERT INTO ngp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu niyo amgamba, “Ona, mhuwi wako ukuhonya.” ");
INSERT INTO ngp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aaho niyo anda akaula vedi, niyo amtimila Yesu akamtogola Mnungu. Want'hu weze waone ayo niyo wamtogola Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu niyo engila mo mzi wa Yeliko, Umwo akajink'ha mwe izisila zo mzi uwo, ");
INSERT INTO ngp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","niyo alaila mn'thu yumwenga zina dyakwe Zakayo. Uyo na kanda kilongozi mkulu wa watoza ushulu naho andaga mgoli. ");
INSERT INTO ngp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zakayo naakaungisa amwone Yesu, mna Kwaviya no kunda na lukudidi lwa want'hu lulongozane na yehe andaga mgihi ivo niyo adunduga kumuwona. ");
INSERT INTO ngp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mna niyo aguluka kulongole, nokukwela mnanga mwo mkuyu vileke amwone Yesu viya akomboka. ");
INSERT INTO ngp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mna Yesu eze abule hadya ho mkuyu niyo asinya kulanga, amgamba Zakayo, “Zakayo sela, dyelo nenisinde kwe inyumba yako.” ");
INSERT INTO ngp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayo niyo asela nguvu, nakumhokela kwa kinyemi. ");
INSERT INTO ngp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Want'hu wose weze waone ayo, niyo wakonga kunung'uzika wakagamba, “Kagenda kwikala na mnt'hu mta wavu.” ");
INSERT INTO ngp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mna Zakayo niyo akimaala nokumgambila Yesu, “Zumbe, tegeleza, miye neniwenk'he wakiwa hindi dyo ugoli wangu, naho hegu himhoka mnt'hu kint'hu chochose nenimvuzile malavo kane.” ");
INSERT INTO ngp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu niyo amgamba, “Dyelo uhonyi ubula mwe nyumba ino, Kwaviya uyu naye ni mwe lukolo lwa Ibulahimu. ");
INSERT INTO ngp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwaviya mwana wa Adamu keza kuzungula hamwenga na kuhonya kiya chagile.” ");
INSERT INTO ngp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Viya want'hu wandaga wagendeela kumtegeleza, Yesu niyo awagambila mliganyo, Kwaviya na kanda hagihi na Yelusalemu, naho woho nawamanya kugamba Useuta wa Mnungu u haguhi kwiza. ");
INSERT INTO ngp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yesu niyo awagamba, “Na handa na mnt'hu yumwenga mkulu aitaga nt'hambo kwe isi ya hale vileke ahokele ukulu we kiseuta, niyo auya. ");
INSERT INTO ngp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mna viya andile akei kuhalawa niyo awetanga wandima wakwe mlongo, niyo awenk'ha kila yumwenga tundu dye zahabu, no kuwagamba, Kauleni ivo mkuunga mdamanye na amatundu aya Umwo nnanda kwe nt'hambo.” ");
INSERT INTO ngp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mna want'hu we Isi idya na wanda hawakumuunga yudya mkulu, ivo niyo wasigila want'hu waite wakamgambile, “Hakikumuunga mnt'hu uyu kunda Zumbe dyetu.” ");
INSERT INTO ngp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yudya mnt'hu na kaupata kale Useuta, eze auye niyo awetanga wandima wadya awenk'hile amatundu vileke amanye upati uwo wapatile. ");
INSERT INTO ngp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mndima wa nk'hongo niyo alaila na kumgamba, “Mkulu, hipata kint'hu malavo mlongo kulawa mwe diya tundu dimwenga.” ");
INSERT INTO ngp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Niyo amgamba, “Vedi, weye wi mndima mhuwilwa. Kwaviya kudamanya vedi mwe mbuli ndodo na winde mdahi mwe mizi mlongo.” ");
INSERT INTO ngp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mndima wa kaidi niyo eza na kugamba, “Mkulu hipata kint'hu malavo shano kulawa mwe diya tundu dimwenga unink'hile.” ");
INSERT INTO ngp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yudya naye niyo amgamba, “Nounde mkulu mwe mizi mishano.” ");
INSERT INTO ngp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mndima mtuhu niyo eza, nokumgamba, zumbe, “Guha tundu dyako, nahidifundika vedi mwe kitambala. ");
INSERT INTO ngp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ne hukogoha Kwaviya weye wi mdala, wahausa kint'hu hukiikile naho wavuna hant'hu hwi hahandile.” ");
INSERT INTO ngp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Niyo amgamba, “Weye ni mtumwa wiihile, nousengelwe kwa yadya ulongile weye mwenye. Kumanya kugamba miye ni mnt'hu mdala nahausa kint'hu hikiikile no kuvuna hant'hu hihandile. ");
INSERT INTO ngp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ni huikize tundu dyangu kwe kindolo hegu nedyeleka?” ");
INSERT INTO ngp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Niyo awagamba wadya wakimale hagihi, ‘Guheni ditundu idyo ananadyo nokumwink'ha yudya mta matundu mlongo.’ ");
INSERT INTO ngp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mna niyo wamgamba, ‘Mkulu, mna uyu mna ananayo mlongo?’ ");
INSERT INTO ngp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mna Yesu niyo awahitula, ‘Mta ikint'hu noongezelwe na yudya heena kint'hu hata kiya kidodo ananacho naahokigwe. ");
INSERT INTO ngp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Naho wadya hewekuunga ninde Zumbe wawe, waleteni aha muwakome!’ ” ");
INSERT INTO ngp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu eze abinde kulonga ayo, niyo awalongoela kwita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Viya eze atende ehagihi na Betifage na Besania, hagihi no lugulu lwe mizeituni, niyo awasigila wanamp'hina wakwe waidi, ");
INSERT INTO ngp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","niyo awagamba, “Iteni mwe kaya i hagihi na nyuwe, nombwiile mwana mp'hunda kakakigwa luzigi naho akei kwinula mnt'hu yeyose. Mfunguleni mumnetele aha.” ");
INSERT INTO ngp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Uneva mnt'hu yeyose anamiuzani, nii mwamfungula mwana mp'hunda, mgambileni ivi, Zumbe amwunga. ");
INSERT INTO ngp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Niyo waita, nakumbwiila yudya mwana mp'hunda enga viya wagambilwe. ");
INSERT INTO ngp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Umwo wakamfungula yudya mp'hunda, wenye niyo wauza, “Nii mwaifungula imp'hunda iyo?” ");
INSERT INTO ngp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Niyo wahitula, “Zumbe aiunga.” ");
INSERT INTO ngp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Niyo waigala idya mp'hunda kwa Yesu, niyo watandika izisuke zawe mnanga mwe mp'hunda, Yesu niyo akwela mnanga. ");
INSERT INTO ngp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu niyo agendeela ne int'hambo mnanga mwe imp'hunda, na want'hu watandikaga izisuke zawe mwe isila. ");
INSERT INTO ngp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eze atende ehagihi na Yelusalemu mwe seleza yo lugulu lwe mizeituni, wanamp'hina wakwe wangaga wakamtogola Mnungu kwe mbuli nk'hulu wazione. ");
INSERT INTO ngp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Niyo wakonga kugamba, “Katogoleswa Zumbe akwiza kwa zina dya Mnungu, utondowazi kwe mbingu na uwedi utendese kwa Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mafalisayo watuhu wadile mwe difyo niyo wamgamba, “Mhinizi, wagambile wanamp'hina wako wanyamale.” ");
INSERT INTO ngp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu niyo awahitula, “Nawagambilani wanakimala awa, amaiwe yadaha kutoa nk'helegele.” ");
INSERT INTO ngp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Eze abule hagihi na kuusinya udya umzi wa yelusalemu, Yesu niyo awiila. ");
INSERT INTO ngp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Niyo amgamba, “Uneva wamanyize yadya yakuungigwa dyelo kwe mbuli yo utondowazi, mna ivi haluse ifisigwa kwako.” ");
INSERT INTO ngp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mna mazuwa nayabule, wadya hewe kukuunga nawakuzungulusile ukuta, na kukukump'hukila mp'hande zose. ");
INSERT INTO ngp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nawakukome weye na wanao, hawakwasile iwe mnanga mwe iwe Kwaviya hwamanyize umuda wa Mnungu kwiza kukukombola. ");
INSERT INTO ngp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu niyo engila mwe nyumba ya Mnungu na kukonga kuwalava wadya wandile wakataga ivint'hu, ");
INSERT INTO ngp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","niyo awagamba, “Iwandikwa, inyumba yangu ne inde nyumba ya kulombeza Mnungu, mna nyuwe mwaitenda mp'hanga ya wabavi.” ");
INSERT INTO ngp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kila zuwa Yesu naakahiniza mwe inyumba ya Mnungu, mna wakulu wa walava nt'hambiko hamwenga na wahinizi we miko na vilongozi nawakazungula sila uleke wamkome. ");
INSERT INTO ngp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mna hawaone sila ya kumkomela, Kwaviya want'hu wose na wakamtegeleza vedi vidala. ");
INSERT INTO ngp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Zuwa dimwenga Yesu umwo andaga mwe nyumba ya Mnungu akahiniza want'hu, hamwenga na kubilikiza Mbuli Yedi ya Mnungu, wakulu wa walava nt'hambiko hamwenga na wahinizi we miko, na wadala vilongozi niyo weza. ");
INSERT INTO ngp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Niyo wagamba, “Kigambile, wadamanya mbuli izi kwa udahi waani?” ");
INSERT INTO ngp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu niyo awahitula, “Name neniwauzeni mbuli imwenga. Nigambileni, ");
INSERT INTO ngp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohana naakabatiza kwa udahi kulawa kwo ulanga hegu kwa want'hu?” ");
INSERT INTO ngp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mna niyo wakonga kulafya woho wenye, “Nemkigeeze? ‘Kinagamba yalawa kwa Mnungu,’ yehe naye naakiuze, ‘Nii hamwamhuwilaga?’ ");
INSERT INTO ngp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Naho kinagamba noulawa kwa want'hu, want'hu awa wadaha kukitoa maiwe, Kwaviya nawamhuwila Yohana kugamba ni Mlotezi.” ");
INSERT INTO ngp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mna niyo wamhitula, “Hakimanyize uko ulaile.” ");
INSERT INTO ngp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu niyo awagamba, “Name hikuwagambilani nadamanya aya, kwa udahi wa ani.” ");
INSERT INTO ngp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu niyo agendeela kuwagambila mliganyizo uno, “Mnt'hu yumwenga nakalima mgunda wakwe we mizabibu, niyo aikiza kwa wandima, yehe mwenye niyo atamba kwiita isi ya hale na kwikala uko kwa lupisi mtali. ");
INSERT INTO ngp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lupisi uvuni wize ubuze, yudya mnt'hu niyo amsigila mtumwa ywakwe kwa wadya wandima akaguhe ulozo yapatikane. Mna wadya wandima niyo wamtoa yudya mtumwa na kumleka auye haheina kumwink'ha kint'hu chochose. ");
INSERT INTO ngp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yudya mnt'hu niyo amsigila mtumwa mtuhu, yudya nae niyo wamtoa enga viya wamtoile yudya wa nk'hongo, na kumtendela viihile na kumvuza heheina kumwink'ha kint'hu chochose. ");
INSERT INTO ngp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Niyo asigila mtuhu wa katatu, uyu naye niyo wamtoa na kumgela nkwenge niyo naho wamdula kuse. ");
INSERT INTO ngp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yudya zumbe mta mgunda niyo afanyanya, ‘Nentende vivihi? Nenimsigiile mwanangu humwungisa, wadaha wakamwiva.’ ");
INSERT INTO ngp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wadya wandima weze wamuwone yudya mwana niyo wagambilana, ‘Uyu nuyo mkipe, haluse kimkome vileke uno ulisi unde wetu.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Niyo wamlava mwe idya ink'honde, wamkoma. Yesu niyo auza, “Uyu zumbe mta mgunda naatende mbwai na wadya wandima?” ");
INSERT INTO ngp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Neeze awakome wadya wandima na kuwenk'ha wandima watuhu idya ink'honde.” Want'hu weze weve zia izimbuli niyo wamhinga wagamba, “Iyo ivo haikudahika.” ");
INSERT INTO ngp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu niyo awakaula na kuwauza, “Haluse uno Mawandiko Akukile yanakibwani? ‘Iwe wadilemele wazesi, Ditenda iwe kulu dikuungiswa kujink'ha yose.’ ");
INSERT INTO ngp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mnt'hu yeyose anagwa mnanga mwe diya idiiwe naakant'hike vitilitili, naho dinamgwela mnt'hu yeyose nemdimtigint'he tiki tiki.” ");
INSERT INTO ngp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wahinyi we miko hamwenga na wakulu wa walava nt'hambiko niyo wazungula kumgwila lupidi ludya mna niyo wogoha want'hu Kwaviya nawamanya mliganyo udya naukawalonga woho. ");
INSERT INTO ngp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mna niyo wazungula mizungu ya kumgwila Yesu, nawasigila want'hu waketendile enga want'hu wedi vileke wamgwile mwo kulonga kwakwe uleke wamwigale kwe uzumbe na kwa wata udahi. ");
INSERT INTO ngp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wadya wasigilwe niyo wamgamba Yesu, “Mhinizi kimanya kugamba walonga na kuhiniza mbuli za kindedi, naho hukukaula ukulu wa mnt'hu mna wahiniziza mbuli ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hake kigambile, ni vedi kuliha kodi kwa Seuta ywa Kilumi?” ");
INSERT INTO ngp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mna Yesu nakamanya ubala wawe niyo awagamba, ");
INSERT INTO ngp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","nilagiseni iditundu. Ifuta ne dizina ni va ani? Niyo wamhitula, “Va Seuta ywa Kilumi.” ");
INSERT INTO ngp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu niyo awagamba, “Vedi, mwink'heni Seuta ywa Kilumi va Kaisali na Mnungu mwink'heni vakwe.” ");
INSERT INTO ngp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Niyo elo, hawadahile kumgwila kwa mbuli yoyose hadya ha want'hu, nawekehelwa na viya endile akawahitula niyo wanyamala. ");
INSERT INTO ngp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mna masadukayo, wadya wakugamba hakuhali kuuyuka, niyo wamuuza Yesu, ");
INSERT INTO ngp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mhinizi, “Musa nakakiwandikila kugamba, ‘Uneva mnt'hu anabanikilwa na nduguye mta mvele mna hana mwana yudya mnt'hu adaha kumguha yudya mvele uleke ampatile nduguye mwana.’ ");
INSERT INTO ngp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","No kunda na wandugu mfungate, wa nk'hongo nakalomba mvele niyo abanika hana mwana. ");
INSERT INTO ngp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wakaidi niyo amguha yudya mvele nae niyo abanika haheina kwasa mwana, ");
INSERT INTO ngp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na wakatatu. Niyo vanda ivo kwa ndugu wose mfungate. Wose niyo wafa haheina kweleka mwana. ");
INSERT INTO ngp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Niyo yudya mvele naye abanika. ");
INSERT INTO ngp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Haluseelo, mwe dizuwa dyo kuuyuka kwa wabanike, yudya mvele na ande mkazaani Kwaviya wose nawamlomba.” ");
INSERT INTO ngp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu niyo awahitula, “Want'hu mwe ino isi walomba na kulombigwa, ");
INSERT INTO ngp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","mna wadya wakunga wauyulwe kulawa kwe file na kwikala kwa Mnungu, hawakulomba na kulombigwa. ");
INSERT INTO ngp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Naho hawabanike vituhu, Kwaviya na watende enga mtumigwa ywa kwe Mbingu. Na wende wana wa Mnungu Kwaviya wauyuka kulawa kwe file. ");
INSERT INTO ngp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mna mbuli ya kuuyuka nk'hindedi, hata Musa kailonga mwa maandiko Akukile wakwe. Mwe mbuli idya ya kadya kaziti kakuhya, hadya amwitange Zumbe kugamba ni ‘Mnungu wa Ibulahimu, na Mnungu wa Isaka na Yakobo.’ ");
INSERT INTO ngp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yehe ni Mnungu wa wadya wa wagima hiyo wadya wabanike Kwaviya kwa yehe wose wana ugima.” ");
INSERT INTO ngp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wahinyi watuhu we miko iyo wamhitula no kugamba, “Mhinizi kuhitula vedi vidala.” ");
INSERT INTO ngp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Niyo hawamuuzile vituhu. ");
INSERT INTO ngp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu niyo awauza, “Want'hu wagaaze kugamba Kilisito ni mwana wa Daudi? ");
INSERT INTO ngp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","‘Kwaviya Daudi ye mwenye nakalonga mwe ikitabu chakwe che zabuli, zumbe nakamgamba zumbe ywangu ikala nt'hendelo yangu ya kulume, ");
INSERT INTO ngp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mpaka niwatende wadya waihi wako kunda kint'hu che kwiikila iviga vako.’ ");
INSERT INTO ngp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daudi amwitanga Yesu ‘Zumbe’ naatende vivihi mwanawe?” ");
INSERT INTO ngp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Umwo want'hu wandaga mwo kumtegeleza niyo awagamba wanamp'hina wakwe, ");
INSERT INTO ngp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Wakauliseni wahinizi we miko wakuungisa kugenda wavaile nk'hanzu na kulamswa mwa magwilo hamwenga na kwikala mwe nyumba za Mnungu na mwo ukalo wakulongole mwe zifugo. ");
INSERT INTO ngp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wakudya mwe zinyumba za wabanikilwe ni wagosi wawe. Kwa udant'hi wawe wamlombeza Mnungu kwa milosi mingi, woho nawasengelwe.” ");
INSERT INTO ngp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu niyo enula meso yakwe na kukaula wagoli ivo wakulava, malavo mwe kindolo. ");
INSERT INTO ngp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Naho niyo amuwona mvele yumwenga abanikilwe ni mgosiwe alavile watundu wakwe waidi. ");
INSERT INTO ngp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu niyo agamba, “Nawagambilani ikindedi, mvele uyu abanikilwe ni mgosiwe kalava malavo makulu mwe iki kindolo kujink'ha wose. ");
INSERT INTO ngp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwaviya want'hu wose walava malavo yawe mwe amatundu yadya yongezekele, mna uyu mvele na ukiwa ananao kalava kia kikuunga kimwambize mwe wikazi wakwe.” ");
INSERT INTO ngp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Want'hu watuhu nawakalonga mbuli ye nyumba ya Mnungu, uwedi wakwe na viya dihambigwe kwa maiwe hamwenga na malavo want'hu nawakalava, Yesu niyo agamba, ");
INSERT INTO ngp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Yano yose mkuyakaula, mazuwa yeza hadisigale iwe mnanga mwa mnyawe hedimoligwe.” ");
INSERT INTO ngp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mna niyo wamwuza, “Mhinizi mbuli izo nezilaile ini? Naho mbuli zani zikunga zilagise kugamba mbuli izo zihagihi kulaila?” ");
INSERT INTO ngp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu niyo awahitula, “Kauleni sema mnadantilizwe. Kwaviya want'hu wengi naweze kwe dizina dyangu wakagamba, ‘Miye nuyo Yesu!’ na ‘udya umuda wihagihi!’ mna nyuwe msekuwabasa. ");
INSERT INTO ngp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mna mneva mbuli za nk'hondo, na seselo za nk'hondo msekogoha, mbuli izo zaungigwa zinde kulaila. Mna udya umwisho nounde ukei.” ");
INSERT INTO ngp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu niyo agendeela kuwagambila, “Isi naitoane na isi nt'huhu, na useuta nautoane na useuta mtuhu.” ");
INSERT INTO ngp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nokunde na visingisa va isi kila hant'hu, na gumbo, na unyonge wa tauni kila hant'hu na mbuli za wogofi hamwenga na vilagiso kulawa kulanga. ");
INSERT INTO ngp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Umwo yose ayo hayanati kulaila, nawamigwileni na kuwatoa, hamwenga na kuwegalani mwe zinyumba za Mnungu na kuwavugaila mndani, na mlongelezwe kwa mazumbe na maliwale mwe mbuli ye dizina dyangu. ");
INSERT INTO ngp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aho elo naho mkuungigwa mlonge uwona mwe mbuli yedi ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mna msekogoha na kubanikanyanya mwe imioyo yenyu kugamba nomlonge mbwai. ");
INSERT INTO ngp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwaviya neniwenk'heni mbuli zedi zo ukulonga zikunga zileke wakumihiya wasekudaha kuhigana nanywe. ");
INSERT INTO ngp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nomlemelwe na welesi wenyu na wandugu zenyu hamwenga na wambuya zenyu, na watuhu nao nawamikomeni. ");
INSERT INTO ngp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Want'hu wose nawamiihieni Kwaviya mkunitimila miye. ");
INSERT INTO ngp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mna hata fili imwenga mwe imitwi yenyu heyage. ");
INSERT INTO ngp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwaviya mkufinyiliza, nomhonye imioyo yenyu. ");
INSERT INTO ngp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aho mkunga muwone mzi wa Yelusalemu uzungulukwa na wank'hondo, naho kumbukileni kugamba umuda wakwe wa kubanangwa ubula. ");
INSERT INTO ngp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Niyo elo wadya we Yudeya wagulukile kwe imilima, wadya we kwo mzi wafose, na wadya we kwe zink'honde wasekuya kwo mzi wa yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwaviya mazuwa ayo ni amazuwa ya masulumizo, vileke yakelavilize yadya yawandikwe. ");
INSERT INTO ngp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nk'hondo ina wavele wabovu na wadya wakonk'heza mwe amazuwa ayo, Kwaviya nokunde na masulumizo mengi mwe isi na maya ya Mnungu nayawezile want'hu awa. ");
INSERT INTO ngp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Watuhu nawakomwe na mabamba, watuhu nawatahigwe kulawa mwe zisi zose, na mzi wa Yelusalemu nouguhigwe na want'hu wa isi nt'huhu mpaka lupisi wawe wize usile. ");
INSERT INTO ngp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nokutende na vilagiso kwe dizuwa, no umnenge na kwe zint'hondo. Isi zose nezitende na masulumizo, wose nawengile mtuso ko msindo wo mjubwaniso we ibahali. ");
INSERT INTO ngp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Want'hu wengilaga kizingizo cha wogofi, kwa yadya yakuunga yalaile mwe isi yose, kwaviya udahi wa kwe mbingu nousingisike. ");
INSERT INTO ngp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aaho niho nawamwone Mwana wa Adamu akaseela na mavunde kulawa kwa Mnungu, kamema udahi mkulu na uwedi utendese. ");
INSERT INTO ngp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Umwo izimbuli izo zikakonga kulaila sangalaleni, nokwinula imitwi yenyu Kwaviya uhonyi wenyu uhagihi. ");
INSERT INTO ngp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu niyo awagambila umliganyizo uno, “Ukauleni ivo wili mtini ne miti mituhu yose. ");
INSERT INTO ngp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mtini unakonga kusuka mani, aho nommanye umuda we kiangazi wihaguhi. ");
INSERT INTO ngp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Saivo, mneza kuwona mbuli izo zikalaila mmanye kugamba Useuta wa Mnungu wihagihi. ");
INSERT INTO ngp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nawagambilani ikindedi, cheleko iki, hechomboke ayo yakanda yakei kulaila. ");
INSERT INTO ngp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mbingu ne isi vyose nevomboke, mna ulosi wangu howomboke na zuwa. ");
INSERT INTO ngp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mkekaulise, imiyoyo yenyu, inase ikazamilwa ni uhank'hu na ukolwa ne zimbuli zo wikazi aya, zuwa diya niyo dyamizilani enga viya mtego ukugwila. ");
INSERT INTO ngp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwaviya zuwa idyo nediwezile enga viya mtego ukufyuka kwa wose wakwikala mwe Isi. ");
INSERT INTO ngp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sinyiseni, lombezeni Mnungu mazuwa yose vileke mpate udahi ukunga vileke mjink'he vedi mwe izimbuli zose zikunga zilaile, naho uleke mnde na udahi wakukimala kwakwe mwana wa Adamu.” ");
INSERT INTO ngp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kila zuwa Yesu naakahiniza mwe nyumba ya nk'hulu ya Mnungu, naho nekilo naakaita ko kugona kwo lugulu lwe mizeituni. ");
INSERT INTO ngp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Want'hu wose na wakaita kwe Nyumba nk'hulu ya Mungu vileke wamtegeleze. ");
INSERT INTO ngp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Zuwa dye kinyemi che mikate heigeligwe ugwadu, dikwitangwa pasaka, dyandaga hagihi. ");
INSERT INTO ngp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wakulu wa walava nt'hambiko, na wahinizi wasigilwe, wandaga wakawogoha want'hu, na ivo wandaga wakageza kuzungula mizungu ya kumkoma Yesu kinyele. ");
INSERT INTO ngp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mwavu amwingilaga Yuda akwitangwa Isikaliyote yumwenga mwa wadya mlongo na waidi. ");
INSERT INTO ngp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda niyo agenda kulonga na wakulu wa walava nt'hambiko, wakulu wa wank'hondo, wamizi we Nyumba ink'hulu yo kuvikila, ivo akuunga amsezenge Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Welelagwa vidala niyo wamgeleka matundu. ");
INSERT INTO ngp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda azumilaga, niyo akonga kuzungula luneka lwedi, lwakumgela Yesu mwe mikono yawe kwa kinyele. ");
INSERT INTO ngp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Niyo dyabula di zuwa dye mikate heigeligwe ugwadu, dizuwa dyo kuchinja ingoto ye pasaka ");
INSERT INTO ngp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Niyo Yesu awasigiila Petulo, na Yohana akawagamba, “Iteni mka kiikile lumwe ludyo lwe pasaka kize kidye.” ");
INSERT INTO ngp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Niyo wamuuza, “Waunga kikaikilehi lumwe ludyo lwe pasaka?” ");
INSERT INTO ngp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Niyo awagamba, “Umwo mkengila mo mzi, nombwiilane na mnt'hu aketwikile biga dya mazi, mtimileni mkengile kwenyumba akugenda kwingila. ");
INSERT INTO ngp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mgambeni mta inyumba, ‘Zumbe auza chumba akuunga adiile uludyo lwe pasaka hamwenga na wanamp'hina wakwe?’ ");
INSERT INTO ngp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naawalagiseni chumba kikulu chedi kwe digulu, uko nombwiile vint'hu vose viikilwa lumwe.” ");
INSERT INTO ngp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Waitaga niyo wakubwiila enga viya Zumbe Yesu awagambile, niyo nao waikila lumwe uludyo lwe pasaka. ");
INSERT INTO ngp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Umwo sa ize ibuze niyo ekala ho ludyo hamwenga na wegala ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Niyo awagamba wanamp'hina wakwe, “Hionesa kunda vedi vitendese kudya pasaka ino hamwenga na nyuwe, hinati kusulumizwa.” ");
INSERT INTO ngp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwaviya nawagambilani, heniidye naho ino mpaka ikeza kukelaviliza mwo useuta wa Mnungu ");
INSERT INTO ngp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Niyo naho Yesu akiguha kikombe, nokutogola Mnungu, niyo agamba, “Nyweeleni nyose mwe kikombe iki. ");
INSERT INTO ngp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nawagambilani kugamba, heniywe naho mazi aya ye zabibu mpaka Useuta wa Mnungu wize.” ");
INSERT INTO ngp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Niyo auguha mkate, atogola Mnungu, niyo aubendula nokuwenk'ha akawagamba, “Uno nuwo umwili wangu ukulavilwa kwajili yenyu, tendeni ivi kwa kunikumbukila.” ");
INSERT INTO ngp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Viligane naivo, weze wabinde ludyo lwa mwalagulo, niyo awenk'ha kikombe akawagamba, “Ikikombe iki niyo indagano imp'ya ya Mnungu mwe sakame yangu, ikwitika kwajili yenyu.” ");
INSERT INTO ngp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Mna kauleni, yudya akunisezenga ehamwenga na miye ha ludyo. ");
INSERT INTO ngp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mwana Mnt'hu naafe enga viya Mnungu aungile Mna naaligitwe mnt'hu yudya akuunga amsezenge.” ");
INSERT INTO ngp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Niyo wakonga kuuzana woho wenye kwa wenye ni ani mwa woho akuunga atende ivo. ");
INSERT INTO ngp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Niyo kwalaila mahigano mwa wanamp'hina, kugamba ni ani mwa woho akufanyanywa kunda mkulu ywawe. ");
INSERT INTO ngp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu niyo awagamba, “Maseuta wa want'hu hewe mmanyize Mnungu we kindedi, wana udahi mwa want'hu wawe, na wakulu nawo wakeink'ha ukulu wakakegamba, ‘Wambuya wa want'hu.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mna kwenyu hivo ivo, mkulu umwenyu, aungwa ande mdodo kujink'ha wose, naho, kilongozi naye, aungwa ande mtumwa wa want'hu. ");
INSERT INTO ngp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mna niani mkulu, ni yudya akwikala hasi ho ludyo, hegu yudya akunda mndima? Ikindedi ni yudya akuhumula hasi. Mna hata inanda ivo miye ni mwenyu enga mndima. ");
INSERT INTO ngp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nyuwe mnda na miye mo kugezigwa kwangu, ");
INSERT INTO ngp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","naho enga viya Tate aniikile mo Useuta, miye name nawaikani mo uzumbe uuwo. ");
INSERT INTO ngp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nomdye na kunywa ho ludyo ko uzumbe wangu, naho nomwikale mwe difumbi dyo Useuta kuzilamula kabila mnongo na mbili za Wazilaeli. ");
INSERT INTO ngp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu niyo agamba, “Simoni! Simoni! Kaula Mwavu kenk'wa kuwageza nyuwe nyose, kuwapanga awedi na waihile, enga viya mlimi akuiheta ingano. ");
INSERT INTO ngp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mna hikulombezela kwa Mnungu weye, Simoni, unase kuhungukilwa nu mhuwi, vileke ukeza kuniuiya uwagele nguvu wanduguzo.” ");
INSERT INTO ngp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petulo niyo amhitula, “Zumbe miye hikeika lumwe kugenda kuvugailwa kwedi vugailo naho hegu kubanika nife hamwenga na weye.” ");
INSERT INTO ngp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu niyo amgamba, “Nakugambila Petulo, zogolo he diile, weye nounde kunilemela malavo nt'hatu kugamba hunimanyize.” ");
INSERT INTO ngp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu niyo awauza wanamp'hina wakwe, “Viya nawasigilagani, hewiina pochi hegu mkwiji na vilatu, mwahungukilagwa ni chochose?” Niyo wamhitula, “Hachahungukilwe na chochose.” ");
INSERT INTO ngp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu niyo agamba, “Mna haluse, mta pochi hegu mkwiji, naaguhe, heena bamba, naaungwe kutaga dikoti vileke agule bamba. ");
INSERT INTO ngp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwaviya nawagambilani, yadya niwandikilwe yakugamba, ‘Naawazigwe hamwenga na wabanangi,’ yaungwa yakelavilize naho kindedi yadya niwandikilwe haluse yabula.” ");
INSERT INTO ngp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wana mp'hina niyo wagamba, “Zumbe kaula, aha kina mabamba maidi.” Yesu niyo agamba, “Ni vedi!” ");
INSERT INTO ngp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu ahalawaga ho mzi niyo aita ko mlima we mizeituni, enga ivo akutendaga, wanamp'hina nao niyo waita nae. ");
INSERT INTO ngp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Eze abule hant'hu aho niyo awagamba, “Mlombeze kugamba msekugwa mwo kugezigwa.” ");
INSERT INTO ngp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Niyo asogela hank'handa nao uhale wa kuvigita iwe, niyo afika madi na kumnombeza Mnungu akagamba. ");
INSERT INTO ngp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Niyo agamba, “Tate, uneva waunga, niusile masulumizo aya, hiyo kwa kuunga kwangu, mna viya ukuunga weye nevinde.” ");
INSERT INTO ngp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mtumigwa ywa kwe mbingu wa Mnungu amwiziilaga na kumgela nguvu. ");
INSERT INTO ngp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kwaviya andile mwe makunt'ho, ongezaga kumnombeza Mnungu, niyo kiluke chakwe chanda enga matwent'he ya sakame ya kutomoka mwe sanga. ");
INSERT INTO ngp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Eze alawe mo kumnombeza Mnungu niyo awauiya wanamp'hina wakwe, niyo awabwiila wagona Kwaviya nawanda na kinyulu. ");
INSERT INTO ngp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Niyo Yesu awagamba, “Nii mwagona? Inukeni mlombeze Mnungu, mnase kwingila mo kugezigwa.” ");
INSERT INTO ngp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Umwo Yesu andile akagendeela kulonga, dyabulaga fyo dikalongozwa ni Yuda, yumwenga mwa wadya wanamp'hina mlono na waidi. Ezaga na kumbusu Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mna Yesu niyo amgamba, “Yuda wamsezenga Mwana wa Mnt'hu kwa utondwe?” ");
INSERT INTO ngp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Umwo wadya wanamp'hina weze wayaone yadya yakulaila niyo wamuuza, “Zumbe, togola kiwasenge na mabamba yetu?” ");
INSERT INTO ngp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yumwenga wawe niyo amtowa mtumwa ywo mkulu wa mlava nt'hambiko, na kumsenga digutwi dyo kulume. ");
INSERT INTO ngp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mna Yesu niyo agamba, “Yaungigwa muyazumile yano!” Niyo amtozaga yudya mnt'hu digutwi dyakwe disengigwe, nakumhonya. ");
INSERT INTO ngp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Awagamba wakulu wa walava nt'hambiko na wadya wakulu wa wamizi we nyumba ink'hulu ya Mnungu, hamwenga ne wadala vilongozi, awo wezaga kumgwila Yesu, “Mwiza na mabamba na malungu, enga miye ni mhoki? ");
INSERT INTO ngp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nandaga na nyuwe mazuwa yose mwe nyumba nk'hulu ya Mnungu mna hamwagezile kunigwila. Mna dielo dibula dizuwa dyenyu, udahi wo uzumbe we diziza kukehuwila.” ");
INSERT INTO ngp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wamgwilaga Yesu niyo waita nae kwe nyumba yo mlava nt'hambiko mkulu Petulo naye andaga akatimila kwa luhale. ");
INSERT INTO ngp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Weze wande wagima moto hagati he kiwasa cho usengelo, Petulo alunganaga na wadya wandaga wekale bunga kuuzunguluka. ");
INSERT INTO ngp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mvele yumwenga eze amuone Petulo kekala hadya ho moto, amngoelaga meso Petulo akagamba, “Mnt'hu uyu nae nawandanya na Yesu!” ");
INSERT INTO ngp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mna Petulo niyo alemela akagamba, “We mvele, miye himmanyize mt'hu uyo!” ");
INSERT INTO ngp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ludodo naho mgosi yumwenga nakamuona Petulo, niyo agamba, “Weye nawe uyumwenga mwa woho,” Mna Petulo niyo amgamba, “Weye mnt'hu, himanyize icho ukulonga,” ");
INSERT INTO ngp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sa nt'huhu lupisi, mnt'hu mtuhu niyo alonga kwa kubilikiza, akagamba, “Hana kindedi chose kugamba, mnt'hu uyu nae nawandanya na Yesu, kwaviya yehe nae Mgalilaya!” ");
INSERT INTO ngp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mna Petulo niyo amhitula, “Weye mnt'hu, himanyize icho ukulonga!” Aho, niyo zogolo dyaila. ");
INSERT INTO ngp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Zumbe Yesu niyo ahituka no kumkaula Petulo, Niyo Petulo akumbukila yadya agambilwe ni Yesu kugamba, “Zogolo hadinati kuila nekilo, nounde kunilemela malavo nt'hatu kugamba hunimanyize.” ");
INSERT INTO ngp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petulo niyo aita kuse, niyo ailisa kwa usungu. ");
INSERT INTO ngp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wadya wandaga wakamwamila Yesu niyo wamtendela lubezo no kumtoa mikotya. ");
INSERT INTO ngp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wamsitaga ameso niyo wamuuza wakamgamba, “Ni ani akutoile?” ");
INSERT INTO ngp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Niyo wamlonga mbuli nyingi zakumhomola. ");
INSERT INTO ngp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kwize kuche, difyo dye vilongozi wa want'hu, wakulu wa walava nt'hambiko, na wahiniza miko, waduganaga hamwenga niyo Yesu aletwa he kitala. ");
INSERT INTO ngp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Niyo wamgamba, “Kigambile, weye ni weye Kilisito?” Niyo ahitula, “Hata uneva nna wagambilani, homnihuwile. ");
INSERT INTO ngp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Naho nnawauzani, homnihitule. ");
INSERT INTO ngp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mna, kulawa ivi haluse, Mwana ywa Mnt'hu naande kekala kulume ko Useuta wa Mnungu ywo Udahi wose.” ");
INSERT INTO ngp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Niyo wose wagamba, “Haluse, weye niwe Mwana Mnungu?” Niyo awahitula, “Ivo mkulonga nivo nili.” ");
INSERT INTO ngp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Niyo wagamba, “Chazungula ikindedi kihi naho? Kiva yehe mwenye ivo alongile.” ");
INSERT INTO ngp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Want'hu wose niyo wenuka, wamlongaza Yesu kwita kwa Pilato. ");
INSERT INTO ngp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Uko wakongaga kumlongeleza wakagamba, “uyu mnt'hu kimbwiila akawadant'hiliza want'hu, naakawafingiza want'hu wasekuliha kodi kwa Seuta ywa Kilumi, naho nakagamba yehe mwenye niye Zumbe Yesu Kilisito.” ");
INSERT INTO ngp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato niyo amuuza Yesu, “Weye wi Zumbe wa Wayahudi?” Yesu niyo amhitula, “ivo ukulonga niivo” ");
INSERT INTO ngp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato niyo awagamba wakulu wa walava nt'hambiko hamwenga na wadya wose wandile hadya, “Hikuona wavu wowose mwe uyu mnt'hu.” ");
INSERT INTO ngp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mna wose niyo wagamba, “Awadant'hiliza want'hu na mahinyo yakwe mwe isi yose yo Uyahudi, kakongela Galilaya mna ivi haluse eyaha.” ");
INSERT INTO ngp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato eze eve ayo niyo auza, “Ivi mnt'hu uyu ni mkaya wa Galilaya?” ");
INSERT INTO ngp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Eze amanye kugamba Yesu kalawa mwo udahi wa Helode, niyo amwigala kwa Helonde, lupisi ulwo Helode andaga Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode niyo ehelwa vidala eze amwone Yesu. Kwaviya nakeva kale izimbuli zakwe, ivo naakaungisa amwone. Naho naakakawiila amwone Yesu akadamanya vihungi. ");
INSERT INTO ngp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ivo niyo amuuza Yesu maswali yabindile ingi, mna yehe Yesu hahitule dyodyose. ");
INSERT INTO ngp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wakulu wa walava nt'hambiko na wahinizi we Sigilizi, niyo wakimala wakamlongeleza kwa kuvilikiza vidala. ");
INSERT INTO ngp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ivo Helode hamwenga na watowani wakwe, niyo wamtendela lubezo Yesu, na kumlongela mbuli za soni, niyo wamvala suke za kiseuta na kumvuza kwa Pilato. ");
INSERT INTO ngp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mwe dizuwa diya Helode na Pilato niyo watenda wambuya Kwaviya aho nk'hongo na wanda want'hu walemane. ");
INSERT INTO ngp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ivo Pilato niyo etanga kitala cha wakulu wa walava nt'hambiko hamwenga na vilongozi na want'hu watuhu, ");
INSERT INTO ngp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","awagamba, “Mniletela mnt'hu uyu mwagamba nakawadant'hiliza want'hu. Mna miye hiona izimbuli zakwe mwa meso yenyu naho hione mbuli yoyose iihile mwe ziya mumlongeleze. ");
INSERT INTO ngp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Naho hiyo miye du, Helode naye haone wavu wowose, nivo vilekile kamvuza kwangu. Ni kindedi kugamba mnt'hu uyu hadamanye dyodyose dikuleka akantilwe kukomwa. ");
INSERT INTO ngp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Miye nenizumile mumtoe niyo namlekela aite.” ");
INSERT INTO ngp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kwaviya neikamunga kuwakomwoela mvugailwa yumwenga mwe zuwa dyo wila we Pasaka. ");
INSERT INTO ngp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mna niyo wose watoa lwasu kwa lumwe, wakagamba, “Muuse uyo umfungule Balaba.” ");
INSERT INTO ngp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba nakavugailwa kwa kusaguka na kwajili yakukoma want'hu. ");
INSERT INTO ngp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato nakaunga amlekele Yesu, “Ivo niyo alonga naho vituhu.” ");
INSERT INTO ngp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mna woho niyo watoa lwasu wakagamba, “Muwambe, muwambe.” ");
INSERT INTO ngp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato niyo awauzaga malavo ya katatu, “Mna kadamanya wiihi wani? Hikuona kint'hu chochose kiihile icho adamanye kikumuunga abanike. Nanizumile mumtoe akajika nenimlekele aite. ");
INSERT INTO ngp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mna woho wagendeela kutoesa lwasu kugamba,” Yesu aungigwa awambigwe. Niyo elo lwasu lwawe lwahuma. ");
INSERT INTO ngp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato niyo azumila kugamba wadamanye ivo wakunga. ");
INSERT INTO ngp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Niyo amkomwoela kulawa kwe divugailo yudya wakumuunga, yudya ageligwe kwedivugailo kwa kusaguka na kukoma want'hu. Pilato amlavaga Yesu kwawe vileke wamtendele viya wakuunga. ");
INSERT INTO ngp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Umwo wakamwigala, wabwilana na mnt'hu yumwenga akwitagwa Simoni mnt'hu wa Kilene, andile akalawa ko mgunda, niyo wamtwika msalaba kunyuma haguhi na Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Fyo dya want'hu nedikamtimila, naho no kunda na wavele wandile wakamwiila Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu niyo awahitukila na kuwagamba, “Nyuwe wavele wa Yelusalemu, msekuniila miye keiileni nyuwe wenye na wana wenyu. ");
INSERT INTO ngp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwaviya mazuwa nayeze aho wakunga wagambe, ‘nevinde nivedi kwa wadya hewena wana, nawadya heweleke na kulela wana!’ ");
INSERT INTO ngp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aho noubuze lupisi want'hu wakunga wayagambe amagulu, yawagweele na kuwagubika vileke wafe. ");
INSERT INTO ngp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwaviya uneva nawatenda ivo mwo mti heunyaile, neinde vivihi umti unanyala?” ");
INSERT INTO ngp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Niyo wegalwa want'hu watuhu waidi wandile wabanangi vileke wawambigwe hamwenga na Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Weze wabule hant'hu hakwitangwa kibela cho mtwi, niyo wamuwamba Yesu hamwenga na wadya wabanangi waidi, yumwenga kulume kwakwe na mtuhu kumoso. ");
INSERT INTO ngp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu niyo agamba, “Tate uwausile wavu wawe, kwaviya hawamanyize idyo wakudamanya,” Niyo wapangilana izisuke zakwe kwa kutoa kula. ");
INSERT INTO ngp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Want'hu nawakimala hadya wakakaula, vilongozi nawakambela, wakagamba, “Kayokola watuhu haluse naakeyokole mwenye, uneva yehe nuyo Kilisito asagulwe ni Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wank'hondo nawo niyo wambela, nawambasa Yesu hagihi niyo wamwink'ha siki. ");
INSERT INTO ngp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Wamgamba, “Uneva kindedi weye u Zumbe ywa wayahudi, keyokole weye mwenye!” ");
INSERT INTO ngp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Halanga ho msalaba wakwe na hawandika, “Uyu niye Seuta ywa Wayahudi.” ");
INSERT INTO ngp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumwenga mwe wadya wadamanye wiihi wawambigwe mwe viwambilo, niyo amhomola Yesu akamgamba, “Weye hikugamba niwe Kilisito? Hake keyokole wemwenye hamwenga na suwe.” ");
INSERT INTO ngp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mna yudya mtuhu niyo amtivila miyawe akamgamba, “Weye hukumogoha Mnungu! Mna umwe usengelo enga iyo? ");
INSERT INTO ngp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Weye na miye kiwagilwa kwink'higwa usengelo enga ino, mwe yadya kidamanye mna uyu hadamanye mbuli yoyose iihile!” ");
INSERT INTO ngp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eze abinde ukulonga niyo agamba Yesu, “We Yesu unikumbukile Umwo ukeza mo Useuta wako.” ");
INSERT INTO ngp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu niyo amhitula amgamba, “Nakugambila, dyelo ino nekindanye kwa Useuta wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ize ibuze saa mtandatu niyo kwenda na lwiza mwe isi yose, mpaka mwe saa kanda. ");
INSERT INTO ngp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Zuwa niyo dyatenda na lwilwa, pazia dye nyumba nk'hulu ya Mnungu niyo dyatatuka hagati. ");
INSERT INTO ngp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu niyo aila kwa izwi kulu, “Tate mwe mikono yako nauika umoyo wangu.” ");
INSERT INTO ngp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yudya mkulu wa wank'hondo eze aone izimbuli viya zilaile, niyo amtogola Mnungu agamba, “Kindedi uyu mnt'hu na kanda mnt'hu wedi.” ");
INSERT INTO ngp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Want'hu wose wadugane hadya, he idya imbuli, weze waone izimbuli zilaile, niyo wauya mwe zikaya zawe wakaketoa mwe vifuwa kwa usungu. ");
INSERT INTO ngp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mbuyaze Yesu hamwenga na wadya wavele wezile kulawa Galilaya nawakimala kwa hale ludodo wakakaula idyo dikulaila. ");
INSERT INTO ngp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","No kunda na mnt'hu yumwenga zina dyakwe Yusufu, mnt'hu uyo na kanda mnt'hu ywedi naho naakekala mo mzi umwenga wa wayahudi ukwitangwa Alimasaya. ");
INSERT INTO ngp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Na kanda mnt'hu wa Alimatayo mzi umwenga wa Wayahudi, ywedi akutogolwa, naakagoja ukwiza kwa Useuta wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ivo yehe niyo aita kwa Pilato, aulombeza umwili wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Eze azumilwe niyo auseleza kwe umsalaba, auvika sanda yedi niyo akuumosa mwe mp'hanga ipukigwe mwo luwe lukulu, naho ne dinda hadinati kumwoselwa mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Zuwa idyo na inda ijumaa, ye dizuwa dya kuhumula nayakonga. ");
INSERT INTO ngp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wadya wavele wezile na Yesu kulawa Galilaya, nawamtimila Yusufu, niyo waiona idya imp'hanga uikigwe umwili wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Niyo wauya kwe zikaya zawe, waika vedi mafuta yedi yakuuhaka umwili wa Yesu. Zuwa dyo ukuhumula niyo wahumula hahena ndima yoyose, enga viya Umwiko ikulonga. ");
INSERT INTO ngp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jumapili mtootondo, wadya wavele niyo waita kwe mp'hanga na yadya mavuta yawe yo mhemp'he ayo wayaikile lumwe. ");
INSERT INTO ngp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Niyo wadibwila dia diiwe ditongoloswa hale ne imp'hanga. ");
INSERT INTO ngp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Niyo wengila mndani mna hawauone umwili wa Zumbe Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Umwo wandile wakei wakehelwa, niyo kwalaila want'hu waidi wakimale hagihi na woho, wavalaga suke zikumwekamweka. ");
INSERT INTO ngp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wadya wavele niyo wengilwa ni wogofi na kufunama hasi uku wakanda wafika madi, wadya want'hu niyo wawagamba, “Nii mwamzungula mgima mwe want'hu wabanike? ");
INSERT INTO ngp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Hahali, kauyuka, kumbukileni ivo amigambilgani umwo andaga Galilaya. ");
INSERT INTO ngp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Vaungwa mwana mnt'hu alavigwe mwe want'hu waihile na kuwambigwa mo msalaba na kuuyuka zuwa dya katatu.’ ” ");
INSERT INTO ngp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aaho, wadya wavele niyo wakumbukila ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Niyo wahalawa kudya kwe imp'hanga niyo wagenda kuwagambila wadya wanamp'hina wakwe mlongo na yumwenga hamwenga na want'hu watuhu izimbuli zose. ");
INSERT INTO ngp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wavele wadya wandaga ni Maliamu Magedalena na Yoana na Maliamu nine dya Yakobo, hamwenga na wadya wavele wandile we hamwenga, woho nawo wawagambile wegala ulosi izimbuli zose. ");
INSERT INTO ngp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mna wadya wanamp'hina nawakafanyanya kugamba yadya wagambigwe ni wadya wavele na hayandaga hiyo kindedi. ");
INSERT INTO ngp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mna Petulo niyo afosa niyo atula nguluko mpaka kwe imp'hanga niyo afunama asungile mndani, mna aonaga isanda iyo du. Niyo ehelwa kwa mbuli ziya azione niyo auya kaya. ");
INSERT INTO ngp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mwe dizuwa idyo, want'hu waidi mwe wanamp'hina wakwe nawakaita mwe kaya imwenga ikwitagwa Emau, kaya iyo ihale no mzi wa Yelusalemu enga lugendo lwa masa maidi. ");
INSERT INTO ngp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Naho nawakalonga woho wenye diya dilaile, ");
INSERT INTO ngp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Umwo nawakalonga na kuuzana wo wenye, Yesu mwenye niyo alaila alongozana nawo, ");
INSERT INTO ngp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nawamuona kwa meso mna hawammanyize kugamba ni Yesu. ");
INSERT INTO ngp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu niyo awagamba, “Mwasimuila mbuli yani uku mwagenda?” Woho niyo wakimala wanyamale wamemile kugela mbazi mwo uso. ");
INSERT INTO ngp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yumwenga akwitangwa Kileopa, niyo amuuza, “Weye wi mgeni mo mzi uno wa Yelusalemu, vikutende humanyize idyo dilaila mwe yano amazuwa?” ");
INSERT INTO ngp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu niyo awauza, “Kulaila mbwai?” Woho niyo wamhitula, “Mbuli za Yesu wa Nazaleti,” yudya endile mlotezi, “Mta udahi wa kudamanya na kulonga hameso ha Mnungu na want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wakulu wa walava nt'hambiko na awakulu wetu hamwenga na vilongozi, nawamsengela kubanika niyo wamuwamba. ");
INSERT INTO ngp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Naho suwe nakikakawiila kugamba yehe nuyo akuunga aikombole Izilaeli, mna dyelo ni zuwa dya katatu kukonge hadya zilaile izo izimbuli. ");
INSERT INTO ngp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Naho weyuko wavele wachehele, nawaita mtootondo kwe kikuta, ");
INSERT INTO ngp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mna hawaubwiile umwili wakwe! Wauya nakugamba, walailwa ni mtumigwa ywa kwe Mbingu niyo awagambila kugamba, Kauyuka. ");
INSERT INTO ngp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Weetu watuhu nawaita kwe kikuta niyo waona ivo walotezi wadya awavele, mna yehe hawamuwone.” ");
INSERT INTO ngp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Niyo Yesu awagamba, “Nii mwi wahezi ivo? Nii mwi wadala kuhuwila mbuli walotezi wa Mnungu! ");
INSERT INTO ngp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Haiungigwe Kilisito kusulumizwa mwe zimbuli zose, na kwingila mwo uwedi utendese wo Useuta wakwe?” ");
INSERT INTO ngp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Niyo awagambila zimbuli zose awandikilwe mwa maandiko Akukile, kukongela mlotezi Musa mpaka walotezi wa Mnungu wose. ");
INSERT INTO ngp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Weze wabule hagihi ne ikaya idya nawakaita, Yesu niyo awageza enga agendeela ne int'hambo, ");
INSERT INTO ngp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","niyo woho wamlombeza kugamba, “Usekwita, zuwa diswa.” Ivo niyo engila he ikaya na kwikala nao. ");
INSERT INTO ngp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Eze ekale na kudya nk'hande hamwenga nao, aguhaga mkate no kuuvikila, niyo aubendula no kuwenk'ha. ");
INSERT INTO ngp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ahadya meso yawe niyo yagubulwa, no wabunk'hula kugamba ni Yesu, mna naho niyo ahalawa mwa meso yawe iviya wakakaula. ");
INSERT INTO ngp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Niyo wagambana, “Togoleni, imyoyo yetu haikimpuke moto mndani, aho naakalonga naswe mwe sila, no kukigubuila Mawandiko Akukile?” ");
INSERT INTO ngp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Niyo wahalawa isa idya, no kuuya Yelusalemu. Uko wawabwilaga wadya mlongo na yumwenga, wadugana hamwenga na wadya watuhu. ");
INSERT INTO ngp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Niyo wagamba, “Zumbe, kauyuka kindedi, naye kamlaila simoni!” ");
INSERT INTO ngp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niyo wawasimwiila yadya yalaile kwe sila, na viya wambunkhule Zumbe mwe kuubendula mkate. ");
INSERT INTO ngp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Umwo nawakawagambila ayo, Yesu mwenye niyo alaila no kukimala hagati hawe, awagamba, “Utondowazi unde na nyuwe.” ");
INSERT INTO ngp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Niyo wehelwa no kwingilwa ni wogofi mkulu, wakafanyanya kugamba walailwa ni mzimu. ");
INSERT INTO ngp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mna yehe awagamba, “nii mwanda na kinyulu? Nii mwanda na shaka mwe imioyo yenyu? ");
INSERT INTO ngp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kauleni mikono ne iviga vangu, vileke mmanye ni miye. Nitozeni mnione, Kwaviya mzimu hauna mwili na mavuha enga ivi mkuniyona.” ");
INSERT INTO ngp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eze alonge ayo, niyo awalagisa miko ne iviga. ");
INSERT INTO ngp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Viya weze wanda wakei kuzumila kwa kinyemi wandile nacho, Yesu niyo awauza, “Mna kint'hu chochose cho ukudya?” ");
INSERT INTO ngp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Niyo waamwink'ha ntili ye samaki ikasigwe. ");
INSERT INTO ngp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesu aiguhaga, na kuidya iviya wose wakamkaula. ");
INSERT INTO ngp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Niyo awagamba, “Ino niyo imbuli nawagambilagani, viya chandile hamwenga, kugamba nehiungigwa kuyombokela yose nawandikilagwa mwe miko ya Musa enk'higwe ni Mnungu na mwe vitabu va walotezi hamwenga na mwe kitabu che Zabuli.” ");
INSERT INTO ngp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Niyo zifanyanyi zawe zagubuka, wakombaganya Mawandiko Akukile. ");
INSERT INTO ngp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Naho niyo awagamba, “Ivo nivo iwandikwe kugamba. Kilisito naasulumizwe mna mwe dizuwa dya katatu naauyuke. ");
INSERT INTO ngp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Naho kwa zina dyakwe, want'hu wose kukongela Yelusalemu, nayabilikizwe kugamba want'hu waungigwa wakeiile vileke wausilwe wavu wawe. ");
INSERT INTO ngp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Naho ni nyuwe muwone izi zimbuli. ");
INSERT INTO ngp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Miye mwenye neniwegaileni yudya Tate alagane naamtume kwenyu, mna ikaleni umu mo mzi mpaka mwink'higwe udya udahi ukulawa kulanga.” ");
INSERT INTO ngp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Niyo awalongoza mpaka Besania, uko nuko enulaga mikono yakwe no kuwavikila. ");
INSERT INTO ngp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Umwo akawavikila, niyo akepagula no kuwasa, niyo aguhigwa kulanga kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wamvikaga niyo wauya Yelusalemu uuku wana kinyemi kitendese. ");
INSERT INTO ngp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nawo nawekekala kwe inyumba nk'hulu ya Mnungu mazuwa yose, wakamtogola Mnungu.");
INSERT INTO ngp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aho nk'hongo handaga na Ulosi, naho uyo Ulosi andaga hamwenga na Mnungu, naho uyo Ulosi andaga Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kukongela nk'hongo Ulosi andaga hamwenga na Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yehe niye alekaga vose vikalaila, andile hiyo yehe, hakwalaile kint'hu chochose. ");
INSERT INTO ngp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yehe andaga chotoko cho ugima. Naho udya ugima wandaga ung'azi wa want'hu. ");
INSERT INTO ngp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ung'azi wang'ala mwe diziza, naho diziza hadikuudaha. ");
INSERT INTO ngp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Halailaga mnt'hu asiigilwe ni Mnungu, etangagwa Yohana. ");
INSERT INTO ngp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Uyo ezaga vileke alonge uwona wo ung'azi, vileke want'hu wose wahuwile kwombokela kwa uwo. ");
INSERT INTO ngp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mna yehe andaga hiyo udya ung'azi mna ezaga vileke alonge uwona wo ung'azi. ");
INSERT INTO ngp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Uno wandaga ung'azi we kindedi, ung'azi ukwiza kwe isi no kuwang'azila want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Andaga mwe Isi naho kwombokela yehe, Mnungu aumbaga isi, mna want'hu we isi waswesa kumkombaganya. ");
INSERT INTO ngp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ezaga mwe isi yakwe mwenye mna want'hu we isi yakwe hawamhokele. ");
INSERT INTO ngp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mna wadya wamhokele na kudihuwila dizina dyakwe, awenk'haga udahi kunda wana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hawelekwe kimnt'humnt'hu kunda wanda Mnungu hegu kwa miungile ya mnt'hu, mna ni kwa kuunga kwakwe Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yudya Ulosi niyo anda mnt'hu no kwikala kwetu, naswe nekiuona uwedi wakwe utendese, uwedi utendese enga wa Mwana haheina mtuhu enga yehe alaile kwa Tate, kamema uwedi ne ikindedi. ");
INSERT INTO ngp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana naakawagambila want'hu ikindedi che zimbuli za yudya Ulosi kwa kubongeela akagamba, “Uyo niye nalongaga zimbuli zakwe, ‘Eyuko akwiza kunyuma kwangu mna nakanilongoela kwaviya andaga uuko, umwo miye nandaga hinati kunda uuko.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kulawa mo uwingi we wedi wakwe Mnungu choseni kihokela uvikilwa, akakink'ha suwe uvikilwa ubindile wingi. ");
INSERT INTO ngp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwaviya Mnungu nakenk'hiza miko kombokela kwa Musa, uwedi ne kindedi neviletwa ni Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hahali mnt'hu amuonaga Mnungu lupisi lwolwose, ila Mwana haheina mtuhu enga yehe eli Mnungu, andile hagihi na Mnungu Tate, niye akigambile mbuli za Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","uno nuwo uwona ulavigwe ni Yohana mwo Wayahudi wawasigiilaga walava nt'hambiko hamwenga na Walawi kulawa Yelusalemu waite kwa Yohana wakamuuze, “Weye ni weye ani?” ");
INSERT INTO ngp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana halemele kuwahitula, awagambilaga haheina kifiso akawagamba, “Miye hiyo Kilisito.” ");
INSERT INTO ngp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Niyo wamuuza, “Haluse weye ni weye ani? Weye niweye Eliya.” Niyo awahitula, “Miye hiyo Eliya.” Niyo wamuuza vituhu, “Haluse ni weye yudya mlotezi?” Niyo awagamba, “Hiyo miye.” ");
INSERT INTO ngp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Naho niyo wamuuza, “Haluse weye ni weye ani? Uleke kikawagambile wadya wakisigiile. Weye mwenye wakegamba ni weye ani?” ");
INSERT INTO ngp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana niyo awahitula kugamba, “Miye ni yudya alongaga Mlotezi ywa Mnungu Isaya zimbuli zangu kugamba, ‘Izwi dya mnt'hu akubongeela kwe nyika. Ichululeni sila ya Zumbe.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na wadya wasigiilwe nawatumigwa ni Mafalisayo. ");
INSERT INTO ngp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Niyo wamuuza kugamba, “Nii wabatiza want'hu uneva weye hiyo Kilisito, naho hiyo Eliya hegu yudya mlotezi?” ");
INSERT INTO ngp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana niyo awahitula, “Miye nabatiza kwa mazi mna mgati mwenyu eyaho akimale uyo nyuwe hemwimmanyize. ");
INSERT INTO ngp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yehe eza kunyuma kwangu mna miye hiwagilwe mbwitu kuhambula luzigi lwe vilatu vakwe.” ");
INSERT INTO ngp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mbuli izi zalailaga Besania ng'ambu yo mto Yolodani, kudya andagaga Yohana akabatiza. ");
INSERT INTO ngp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Zuwa ditimile Yohana niyo amuona Yesu eza kwakwe, niyo agamba, “Kauleni, Mwanangoto ywa Mnungu ikuusa wavu we ino isi. ");
INSERT INTO ngp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uyu ni yudya nandaga halonga izimbuli zakwe, ‘Eyuko akwiza kunyuma kwangu mna ni mkulu kujink'ha miye Kwaviya na kanda uuko kukongela miye hinati nelekwe.’ ");
INSERT INTO ngp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naho miye hyammanyize, mna ni kwa kuunga Izilaeli wammanye, nivo valekile heza kubatiza want'hu kwa mazi.” ");
INSERT INTO ngp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Naho Yohana nakalonga uwona kugamba, “Nehimuona Muye ywa Mnungu akaseela kulawa kwe mbingu enga suwa, no kukima mwa Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Naho miye hyammanyize, mna yudya aniletile miye nibatize want'hu kwa mazi nie anigambile, ‘Yudya ukuunga unamuwone Muye akaseela na kumkima hamwenga na kwikala mwakwe, uyo niye akubatiza kwa Muye ywa Mnungu.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohana na kagamba, “Miye mwenye hiona naho nalonga uwona kugamba uyu niye Mwana Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Zuwa ditimile Yohana andaga kakimala naho hamwenga na wanamp'hina wakwe waidi. ");
INSERT INTO ngp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yohana naakamkaula Yesu umwo andile akagenda niyo agamba, “Kaula uyu nuyo Mwanangoto ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wadya wanamp'hina wakwe waidi weze weve ivo alongile, niyo wamtimila Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu niyo ahituka no kuwaona wamtimila, niyo awagamba, “Mwaungai?” Niyo wamgamba, “Labi, nuko kugamba mhinizi wekalahi?” ");
INSERT INTO ngp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Niyo awahitula, “Soni mkaule.” Niyo waita, nokuhaona hadya akwikala niyo wasindanya naye msi wose, naho neinda yabula saa mlongo nekisingi. ");
INSERT INTO ngp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anduleya nduguye dya Simoni Petulo andaga yumwenga ywa wadya waidi wamwivile Yohana niyo wamtimila Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bosi, niyo Anduleya amzungula mkuluwe Simoni niyo amgamba, “Kimuona Masiha.” Uyo niye Kilisito Mlokozi. ");
INSERT INTO ngp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Niyo amwigala kwa Yesu. Yesu niyo amkaula no kummgamba, “Weye niwe Simoni Mwana Yohana. Weye nowitangwe Kefa.” Nuko kugamba kwa Kigiliki, Petulo hegu “iwe”. ");
INSERT INTO ngp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Zuwa ditimile Yesu aonaga vedi aite Galilaya, kudya ambwiilaga Filipo niyo amgamba, “Nitimile.” ");
INSERT INTO ngp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo andaga mkaya ywa Betisaida, mzi ukwo wakwikala Anduleya hamwenga na Petulo. ");
INSERT INTO ngp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo niyo ambwiila Natanaeli niyo amgamba, “Kimuona yudya Musa alongaga zimbuli zakwe mwe miko naho walotezi nao nawawandika zimbuli zakwe, Yesu Mwana Yusufu mnt'hu wa Nazaleti.” ");
INSERT INTO ngp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaeli niyo auza, “Kint'hu chedi chadahika ivivihi kulawa Nazaleti?” Filipo naye niyo amgamba, “Soo ukaule,” ");
INSERT INTO ngp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu eze amuone Natanaeli eza kwakwe amgambaga, “Kauleni Muizilaeli we kindedi heina nyambi yoyose.” ");
INSERT INTO ngp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaeli niyo amuuza Yesu, “Weye kunimanya vivihi?” Yesu niyo amhitula, “Nehikuona hasi yo mtini umwo Filipo andile akei kukwitanga.” ");
INSERT INTO ngp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaeli niyo amhitula, “Mhinizi, weye Mwana Mnungu, Seuta ywa Izilaeli.” ");
INSERT INTO ngp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu niyo amgamba, “Kwaviya nehikugamba hikuona hasi ho mtini, nivo vilekile ukahuwila? Nouone mbuli nk'hulu zikujink'ha izi.” ");
INSERT INTO ngp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Niyo amgamba, “nawagambilani ikindedi, namuwone ulanga ugubuke, watumigwa wa kwe mbingu wa Mnungu wakakwela na kuseela mwo Mwana Mnt'hu.” ");
INSERT INTO ngp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Zuwa dya katatu niyo kwanda na ndoza uko Galilaya ko mzi ukwitangwa Kana, nine dya Yesu naye andaga uuko. ");
INSERT INTO ngp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu hamwenga na wanamp'hina wakwe nawalalikwa mwe indoza iyo. ");
INSERT INTO ngp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divai ize isile nine dya Yesu niyo amgamba, “Divai yawe isila.” ");
INSERT INTO ngp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu niyo amgamba nine, “Mnala, kina mbwai miye na weye? Isa yangu ikei kubula.” ");
INSERT INTO ngp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nine niyo awagamba wandima, “Dyodyose akuunga awagambileni, damanyeni.” ");
INSERT INTO ngp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kwandaga na mabiga mtandatu yakuikila mazi ye kuhaka kuligana na vihendo va Kiyahudi, yadamanywe kwa maiwe, kila dimwenga dikudaha kumema madumu ya mazi yakubula mtandatu kubula mfungate. ");
INSERT INTO ngp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu niyo awagamba, “Memezeni mabiga mazi.” Niyo woho nao wayamemeza mazi. ");
INSERT INTO ngp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Niyo awagamba, “Tekeni amazi mmwigaile seuta,” Niyo watenda ivo. ");
INSERT INTO ngp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yudya seuta eze ayalume yadya mazi yahituke divai naho hamanyize uko ilaile mna wandima nawamanya, wadya wayatahile yadya mazi Yudya seuta niyo amwitanga yudya mlombi, ");
INSERT INTO ngp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","niyo amgamba, “Want'hu wose wakaga lumwe divai yedi, wakajika ukunywa idya iyedi niho wegale idya iihile, weye kuika divai yedi kubula ivi haluse.” ");
INSERT INTO ngp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Vilagiso ivi va nk'hongo, Yesu avidamanyaga uko Kana ya Galilaya vileke aulavanye uwedi wakwe utendese. Wanamp'hina wakwe niyo wamhuwila. ");
INSERT INTO ngp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Akajika, Yesu na nine na wanduguze, hamwenga na wanamp'hina wakwe, waitaga Kapelinaumu niyo wekala uko mazuwa mageke. ");
INSERT INTO ngp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wila wa Wayahudi we Pasaka nounda uhagihi, Yesu niyo akwela kuita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mwe nyumba ya Mnungu niyo aona want'hu wakutaga, ng'ombe, ngoto hamwenga na suwa manga. Naho no kunda na watuhu wakusakanya matundu. ");
INSERT INTO ngp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Niyo aluka kube no kudifundika fundo, no kukonga kuwagulusa kwa kuwatoa wose wandile mwe nyumba ya Mnungu, hamwenga na magoto ne zing'ombe na wadya wandile wakasakanya matundu, niyo ayetila matundu yawe hamwenga nakuzikindula zimeza zawe. ");
INSERT INTO ngp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Niyo awagamba wadya nawakataga suwa manga, “Yafosezeni aya, msekuitenda nyumba ya Tate kunda hant'hu ha uchuuzi.” ");
INSERT INTO ngp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wanamp'hina wakwe niyo wakumbukila ivo iwandikwe, “Neningilwe ni finju ye nyumba yako.” ");
INSERT INTO ngp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wayahudi niyo wamgamba, “Iki ni kilagiso chani kwa aya ukudamanya?” ");
INSERT INTO ngp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu niyo awahitula, “Imoleni Inyumba ino ya Mnungu, miye neni izenge mwa mazuwa matatu.” ");
INSERT INTO ngp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wadya wayahudi niyo wamhitula, “Nyumba ino ya Mnungu neizengigwa kwa myaka milongo mine na mtandatu, mna weye wagamba nouizenge kwa mazuwa matatu du?” ");
INSERT INTO ngp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mna inyumba ya Mnungu andile akaisimuila nu umwili wakwe. ");
INSERT INTO ngp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aho eze auyuke wanamp'hina wakwe niyo wakumbukila viya alongaga. Niyo wayahuwila mawandiko ya Mnungu hamwenga na ivo alongaga Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Umwo andile Yelusalemu mwo we Pasaka want'hu wengi wahuwilaga dizina dyakwe kwaviya wavionaga vilagiso vingi andaga akavidamanya. ");
INSERT INTO ngp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mna Yesu hakehuwilise kwakwe kwaviya nakawamanya wose. ");
INSERT INTO ngp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hakwaungigwe mnt'hu yeyose ywa kumlongela zimbuli zawe kwaviya yehe mwenye amanyaga zimbuli zi mwe mioyo yawe. ");
INSERT INTO ngp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Handaga na mnt'hu yumwenga ywa Mafalisayo zina dyakwe etangwagwa Nikodemo naho andaga kilongozi wa Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Amwizilaga Yesu kilo kimwenga niyo amgamba, “Labi, kikumanya weye u mhinizi wizile kulawa kwa Mnungu, kwaviya hahali mnt'hu yeyose akudaha kudamanya vihungi ukudamanya weye uneva Mnungu hehamwenga nayehe.” ");
INSERT INTO ngp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu niyo amgamba, “Nakugambila ikindedi, mnt'hu hanelekwe kaidi hakudaha kuuona Useuta wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo niyo amgamba, “Yadahika vivihi mnt'hu kwelekwa kaidi uneva kadalahala kale? Neidahike vivihi kwingila mwe inda ya nine niyo elekwa kaidi?” ");
INSERT INTO ngp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu niyo amhitula, “Nakugambila ikindedi mnt'hu hanelekwe kwa mazi na kwa Muye Msuntila, hakudaha kwingila ko Useuta wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mwili weleka mwili mna Muye weleka Muye. ");
INSERT INTO ngp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Usekwehelwa kwa mbuli iyo hugambile kwaviya yaungigwa welekwe malavo ya kaidi. ");
INSERT INTO ngp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Muye yavuma ivo ikuunga naho mvumilo wakwe wevika mnaalo hukumanya uko ikulawa na uko ikuita naho ni ivo akuunga mnt'hu elekwe ni Muye Msuntila.” ");
INSERT INTO ngp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo niyo amhitula Yesu kugamba, “Mbuli izi zadahika ivivihi.” ");
INSERT INTO ngp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu niyo amgamba, “Weye umhinizi wa Izilaeli mna zimbuli izi hukuzimanya? ");
INSERT INTO ngp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nakugambila kindedia, ‘Diya kikudimanya chadilonga, na diya kidione chadilongela uwona, mna uwona wetu hamkuuzumila.’ ");
INSERT INTO ngp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Uneva himigambilani mbuli za mwe isi mna hamhuwile, nomhuwile vivihi nnawagambilani mbuli za kwe mbingu? ");
INSERT INTO ngp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Naho hahali mnt'hu akweile kwe mbingu, ila yehe ezile kulawa uko, uyo Mwana Mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Enga iviya Musa ainulaga inyoka idya ye shaba mnanga mwo mti kudya kwe nyika, niivo vili kwa Mwana Mnt'hu, naye neenulwe kulanga, ");
INSERT INTO ngp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","vileke kila yumwenga akumhuwila ande na ugima wa ulo na ulo mwa Yehe. ");
INSERT INTO ngp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwaviya Mnungu nakawaungisa want'hu wa mwe isi niyo amwigala Mwanawe heena miyawe vileke kila yumwenga akumhuwila asekwaga mna ande no ugima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwaviya Mnungu hamletile Mwanawe mwe isi vileke awasengele want'hu wa mwe isi, mna keza vileke isi iyokolwe kwombokela yehe. ");
INSERT INTO ngp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Akumhuwila Mwana hakusengelwa, mna wose hewe kumhuwila wasengelwa kale, kwaviya hawadihuwile dizina dya Mwana Mnungu eli ikedu. ");
INSERT INTO ngp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Naho usengelo wenye nuuno, ung'azi nowiza mwe isi, want'hu niyo waungisa ziza no kuulemela ung'azi, kwaviya yadya udamanyi wawe nounda wiha. ");
INSERT INTO ngp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila akudamanya yaihile aulemela ung'azi naho hakwiza kwo ung'azi kwaviya hakuunga yadya akudamanya yaoneke. ");
INSERT INTO ngp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mna yeyose akudamanya yadya yakumwelela Mnungu eza kwo ung'azi vileke, yadya akudamanya yaoneke yadamanywa kwa kumwogoha Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ize yajike iyo, Yesu hamwenga na wanamp'hina wakwe waitaga mwe isi ya Uyahudi, niyo asinda uuko hamwenga na wanamp'hina wakwe, akabatiza want'hu. ");
INSERT INTO ngp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana naye andaga akabatiza kint'hu kukwitangwa Ainoni, hagihi na Salimu kwaviya nokunda na mazi mengi, want'hu niyo waita kwakwe vileke wakabatizwe. ");
INSERT INTO ngp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ayo yalailaga umwo Yohana andaga akei kuvugailwa mwe divugailo. ");
INSERT INTO ngp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Niyo wahigana. Wanamp'hina wa Yohana Mbatizi hamwenga na Myahudi yumwenga mwe mbuli yo kukuka. ");
INSERT INTO ngp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Waitaga kwa Yohana niyo wamgamba, “Mhinizi, yudya mwandanye hamwenga kudya ng'ambu yo mto Yolodani, Yudya walongaga zimbuli zakwe, abatiza naho want'hu wose waita kwakwe.” ");
INSERT INTO ngp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana niyo awahitula, “Hakudaha mnt'hu kuhokela kint'hu uneva henk'higwe kulawa kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nyuwe wenye mwasimuila kugamba miye nehilonga, ‘miye hiyo Kilisito Mkombozi mna himlongoela yehe.’ ");
INSERT INTO ngp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mta mlombigwa niye Mlombi, mna mbwiyaye dyo mlombi akukin'ha no kumtegeleza, anda na kinyemi kikulu akeva diizwi dyo mlombi. Haluse! Ikinyemi changu kigenyela ");
INSERT INTO ngp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yehe aungwa kunda mkulu miye name ninde mdodo.” ");
INSERT INTO ngp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yehe akwiza kulawa kwe mbingu ni mkulu ywa yose. Yeyose alaile mwe isi ni wa mwe isi, naho alonga zimbuli za mwe isi. Yehe akwiza kulawa kulanga, ekulanga kwa mbuli zose. ");
INSERT INTO ngp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yadya ayaone nakuyeva nayo akuyasimuila, naho hahali akuzumila yadya akulonga. ");
INSERT INTO ngp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yehe akuuzumila ulosi wakwe, kazumila kugamba, Mnungu ni mkindedi. ");
INSERT INTO ngp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yehe asigiilwe ni Mnungu alonga mbuli za Mnungu, kwaviya kenk'higwa Muye ywa Mnungu haheina kihimo. ");
INSERT INTO ngp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tate amuungisa Mwanawe naho kamwink'ha vose mwe mikono yakwe. ");
INSERT INTO ngp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Akumzumila Umwana naande no ugima wa ulo na ulo. Mnt'hu akumlemela Umwana hana ugima, naho naande mwe masulumizo ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo na weva kugamba Yesu andaga na wanamp'hina wengi hamwenga nakubatiza kujink'ha Yohana. ");
INSERT INTO ngp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ikindedi Yesu yemwenye habatize want'hu, mna wanamp'hina wakwe nao nawakabatiza want'hu. ");
INSERT INTO ngp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ivo Yesu eze eve ivo nawakalonga alawa Yudeya no kuuya naho Galilaya. ");
INSERT INTO ngp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Naho nevimuunga ombokele Samalia. ");
INSERT INTO ngp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Niyo abula kwo mzi wa Samalia ukwitangwa Sikali, hagihi na udya mgunda wa Yakobo amwink'haga Mwanawe Yusufu. ");
INSERT INTO ngp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hadya handile ne disima dya Yakobo, kwaviya Yesu na kanda kasokela kwajili ye nt'hambo yakwe, niyo ekala hagihi ne disima. Naho ne inda nomsi. ");
INSERT INTO ngp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Niyo heza mvele we Kisamalia aungaga ateke mazi. Yesu niyo amgamba, “Nink'he mazi ninywe.” ");
INSERT INTO ngp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Wanamp'hina wakwe nawaitaga kwo mzi wakagule nk'hande. ");
INSERT INTO ngp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yudya mvele we Kisamalia niyo amgamba Yesu, “Inda vivihi weye Myahudi unilombeze miye mvele we Kisamalia amazi yo ukunywa?” Kwaviya Wayahudi na Wasamalia hawakuhangana. ");
INSERT INTO ngp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu niyo amhitula, “Wamanyize uwedi ya Mnungu, naho ni ani akukulombeza mazi yo ukunywa, hegu nawe waungile no kumlombeza, heye amazi, hegu nakakwink'ha mazi yo ugima.” ");
INSERT INTO ngp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yudya mvele niyo amgamba, “Zumbe, weye huna kint'hu cho kutekela mazi sima nadyo tali, haluse kulavahi amazi ayo yo ugima? ");
INSERT INTO ngp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Haluse weye umkulu kujink'ha Tati yetu Yakobo akink'hile idisima idi, niyo yehe mwenye anywa amazi ye disima idi hamwenga na wanawe hamwenga ne mifugwa yakwe yose?” ");
INSERT INTO ngp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu niyo amhitula, “Akunywa amazi aya naaone nk'hilu naho, ");
INSERT INTO ngp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mna mnt'hu akuunga anywe mazi aya yo ugima huunga nimwink'he, heeze aone nk'ilu naho, yadya mazi yo ugima huunga nimwink'he nayatende nchoko za mazi yo ugima zikubwiluka mndani mwakwe, no kwink'hiza ugima wa ulo na ulo.” ");
INSERT INTO ngp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yudya mvele niyo amgamba, “Zumbe nink'he miye mazi ayo nise kunda nk'hilu naho, nisekwiza naho ha vileke niteke mazi.” ");
INSERT INTO ngp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu niyo amgamba, “Ita ukamwitange Mgosio wize naye aha!” ");
INSERT INTO ngp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yudya Mvele niyo amhitula, “Hina mgosi.” Yesu niyo amgamba, “Kulonga vedi, ‘Hina mgosi.’ ");
INSERT INTO ngp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwaviya no kunda na wagosi washano, naho yudya unanaye ivi haluse hiyo ywako, aho kulonga kindedi.” ");
INSERT INTO ngp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yudya mvele niyo amgamba, “Zumbe, naona weye umlotezi. ");
INSERT INTO ngp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wakale wetu wavikaga mwo lugulu ulu na nyuwe mwagamba hant'hu hawagilwe kumvika Mnungu ni Yelusalemu.” ");
INSERT INTO ngp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu niyo amgamba, “Mvele unihuwile, isa yeza, naho homumvike Tate mwo lugulu ulu, hegu kudya Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyuwe mwavikila hemkummanya, suwe chavikila kimmanyize, Kwaviya ukombola walawa kwa Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mna isa yeza naho ibula, wadya wakuvika kindedi nawamvikile Tate mwe kindedi mwe mioyo. Kwaviya Tate awazungula want'hu enga awo wakumvika. ");
INSERT INTO ngp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mnungu ni Muye woho nao wakumvika waungwa wamvike mwe mioyo yawe na kwa kindedi.” ");
INSERT INTO ngp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yudya mvele niyo amgamba, “Himanya neeze Masiha akwitangwa Kilisito, uyo aneza naakigambile kila kint'hu.” ");
INSERT INTO ngp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu niyo amgamba, “Miye hulonga na weye nu uuyo!” ");
INSERT INTO ngp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aaho wanamp'hina wakwe wauyaga mna weheelagwa kwaviya Yesu andaga akalonga na mvele, mna hakwandaga na yeyose amuuzile kugamba “Waungai?” Hegu nii walonga naye? ");
INSERT INTO ngp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yudya mvele niyo aleka idibiga dyakwe, nokuita kwo mzi niyo awagamba want'hu, ");
INSERT INTO ngp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Soni mkaule mnt'hu anigambile mbuli zangu zose nidamanye, mafani uyu niye Kilisito.” ");
INSERT INTO ngp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Niyo wahalawa kwo mzi na kuita kudya eli Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Umwo wandile woho wenye, wanamp'hina wakwe wamhembelezaga wakamgamba Mhinizi dya nk'hande. ");
INSERT INTO ngp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Niyo awagamba, “Miye nnanayo nk'hande hemkuimanya.” ");
INSERT INTO ngp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wanamp'hina wakwe niyo wauzana woho wenye, “Haluse eyuko mnt'hu amwigaile nk'hande?” ");
INSERT INTO ngp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu niyo awagamba, “Ikande yangu ni ino,” nidamanye yadya “akuunga yudya aniletile niibindilize indima yakwe. ");
INSERT INTO ngp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nyuwe hamkulongaga isigala miezi mine vileke kibule mwo uvuni? Mna miye nawagambilani, inuleni meso yenyu mkaule migunda, iikwa lumwe kwa kuvuna. ");
INSERT INTO ngp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na yudya akuvuna ahokela maliho hamwenga na kukisanya matunda kwa mbuli yo ugima wa ulo na ulo, vileke yudya akuhanda na yudya akuvuna welelwe hamwenga. ");
INSERT INTO ngp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwaviya aho elo ulosi watenda kindedi kugamba, yumwenga ahanda na mtuhu avuna. ");
INSERT INTO ngp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Miye nehiwasigiila mkavune yadya hamyadamanyile ndima, watuhu nawadamanya ndima, nanywe mwengila mwe ndima.” ");
INSERT INTO ngp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamalia wengi wo mzi udya, niyo wamhuwila kwa yadya alongile yudya mvele kugamba, “Kanigambila zimbuli zangu zose nidamanye.” ");
INSERT INTO ngp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Niyo wadya wasamalia weze waite kwakwe, nawamhembelezesa vileke ekale kwawe. Yehe naye niyo ekala kwawe mazuwa maidi. ");
INSERT INTO ngp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Want'hu wengi vitendese, niyo wahuwila kwa mbuli ya udya ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Niyo wamgamba yudya mvele, “Haluseelo kihuwila naho hiyo kwa yadya ulongile du, mna kiiva suwe wenye naho chamanya ikindedi mnt'hu uyu nie mlokozi ywe Isi.” ");
INSERT INTO ngp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yeze yajike mazuwa maidi niyo ahalawa kudya no kuita Galilaya. ");
INSERT INTO ngp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwaviya Yesu ye mwenye nakalonga uwona kugamba, mlotezi hakutologwa kwawe, mwe Isi yakwe ye mwenye. ");
INSERT INTO ngp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Viya eze abule Galilaya wadya want'hu wa Galilaya niyo wamhokela Kwaviya nawaziona mbuli zose Yesu adamanye kudya Yelusalemu mwe wila, Kwaviya wadya nao nawaita kwe wila. ");
INSERT INTO ngp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Niyo abula vituhu mo Mzi wa Kana wandile Galilaya hadya ahitule amazi kunda divai. Nahanda na mkulu yumwenga wa selikali, Mwanawe na kanda mnyonge uko Kapelinaumu. ");
INSERT INTO ngp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Uyo eze eve Yesu keza kulawa Uyahudi mpaka Galilaya niyo aita kwake, amlombezaga vileke asele, aite akamhonye Mwanawe ywa kibwanga, kwaviya na kanda hagihi na kubanika. ");
INSERT INTO ngp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu niyo amgamba, “Haheina kuwona kilagiso na vihungi, hamkudaha kuhuwila.” ");
INSERT INTO ngp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yudya mkulu wa selekali niyo amgamba, “Zumbe hakeseleza seka Mwanangu anabanike.” ");
INSERT INTO ngp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu niyo amgamba, “Keitile, mwanao mgima!” Yudya mt'hu niyo ahuwila viya Yesu amlongile niyo atimila sila no kuita kwake. ");
INSERT INTO ngp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Viya ndile akei mwe sila, wandima wakwe niyo wambwila na mbuli kugamba, “mwanawe kahona kale udya unyonge!” ");
INSERT INTO ngp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eze awauze umuda mwanawe ahonile niyo wamgamba, “Unyonge umleka gulo msi wa saa mfungate.” ");
INSERT INTO ngp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aaho ise niyo amanya umuda ni udya agambilwe na Yesu, “Mwanao, mgima kahona”. Niyo ahuwila yehe hamwenga na wose wandile mwe nyumba yakwe. ");
INSERT INTO ngp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Icho ni kilagiso cha kaidi adamanye Yesu viya alaile Uyahudi kubula Galilaya. ");
INSERT INTO ngp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Niyo handa na zuwa dya kinyemi ya Wayahudi, Yesu nae niyo akwela kwita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Naho Yelusalemu, hagihi ne nk'hili ikwitangwa nk'hili ya ngoto handaga na kawa dya mazi dikwitangwa kwa kiibulania Betisaza, naho nedinda na wazila washano wazunguluke wa kombokela. ");
INSERT INTO ngp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Naho wanyonge wengi, mant'hunt'hu, viwete na waholole, nawagona mwe ziya zisila zo kombokela. ");
INSERT INTO ngp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nawakagoja mazi yatibulwe, Kwaviya hamwenga aha mtumwa ywa Mnungu naakeza he dikawa na kuyatibula amazi. Mnyonge ywa nk'hongo kwingila mwa mazi umwo mmazi yakanda yatibulwa naakahona unyonge wowose andile nao. ");
INSERT INTO ngp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hadya nahanda na mnt'hu andile mnyonge kwa myaka milongo mitatu na mnane. ");
INSERT INTO ngp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu eze amuone yudya agonile, amanyaga kugamba andaga iivo kwa lupisi lutali, niyo amuuza, “Waunga unde mgima?” ");
INSERT INTO ngp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yudya mnyonge niyo amhitula, “Zumbe, miye hina mnt'hu akuunga anigele mwe dikawa dya mazi viya mazi yanatibulwa, viya miye heza, kuna mnt'hu mtuhu akunilongoela.” ");
INSERT INTO ngp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu niyo amgamba, “Kimala ketwike kigonelo chako wiite.” ");
INSERT INTO ngp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ahadya yudya mnyonge niyo anda mgima, aketwika kigonelo chakwe na kugenda, naho zuwa diya nedinda dya kuhumula. ");
INSERT INTO ngp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Vilongozi wa Wayahudi niyo wamgamba yudya ahonyigwe, “Dyelo ni zuwa dya kuhumula naho havikuungwa kwa weye kwinula ikigonelo.” ");
INSERT INTO ngp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Niyo awahitula, “Yudya atendile miye ninde mgima niye anigambile niketwike ikigonelo nigende.” ");
INSERT INTO ngp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Niyo wamuuza, “Mnt'hu uyo akugambile uketwike wiite ni ani?” ");
INSERT INTO ngp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mna yudya mnt'hu ahonyigwe andaga hammanyize yudya amhonyile, Kwaviya hadya na handa na want'hu wengi Yesu andaga kahalawa. ");
INSERT INTO ngp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Niyo elo Yesu ambwiila Yudya mt'hu mwe nyumba yo kumvika Mnungu, Yesu niyo amgamba, “Kaula kunda mgima, usekudamanya wavu naho, dinase dikakubwiila buli tuhu diihile kujink'ha idi.” ");
INSERT INTO ngp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yudya mnt'hu niyo akeitila nokuwagambila vilongozi wa Wayahudi mnt'hu amhonyile ni Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwaviya Yesu nakahonya mnt'hu mwe dizuwa dya kuhumula Wayahudi niyo wakonga kumsunk'hasunk'ha. ");
INSERT INTO ngp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu niyo awagamba, “Tate adamanya ndima mpaka ivi haluse, miye name nadamanya.” ");
INSERT INTO ngp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mwe zimbuli izo, vilongozi wa Wayahudi niyo watendesa kuzungula sila yo kumkoma, naho hiyo du kwa mbuli ya kudamanya ndima mwe zuwa dya kuhumula, mna hamwenga na kumwitanga Mnungu ise mwenye, naho nakuketenda kaligana na Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu niyo awahitula, “Ikindedi nawagambilani, Mwana hakudaha kudamanya ndima yoyose kwa udahi wakwe, mna idya amwuone Ise akadamanya Kwaviya yadya akudamanya Tate, naayo akuyadamanya Mwana. ");
INSERT INTO ngp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwaviya Tate amuungisa Mwana naho amlagisa yose akudamanya yehe mwenye, naho naamlagise mbuli nk'hulu ikujink'ha izi, nanywe nomwehelwe. ");
INSERT INTO ngp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Enga viya Tate akuuyula want'hu wabanike nakuwatenda wande wagima, iviya iviya Mwana naye awatenda wagima wadya akuwaunga. ");
INSERT INTO ngp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Naho Tate hakumsengela mnt'hu yeyose mna udahi wo usengelo kamwink'ha Mwana, ");
INSERT INTO ngp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","vileke want'hu wamwive Mwana enga viya wakumwogoha Tate amwigale Umwana. Mnt'hu heekumwogoha Mwana, hakumwogoha Tate amwigale Umwana. ");
INSERT INTO ngp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Namigambilani ikindedi, mnt'hu akuutegeleza ulosi wangu hamwenga nokumhuwila yudya aniletile ana ugima wa ulo na ulo, naho hakwingila mo usengelo mna na ande komboka kulawa ko file kengila ko ugima wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Namigambilani ikindedi, isa yeza, naho ibula, wadya wabanike naweve izwi dya Mwana wa Mnungu naho wadya wakunga weve nawande wagima. ");
INSERT INTO ngp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Enga viya Tate kunda ni chotoko cho ugima, kwe sila iiyo kamtenda Umwana naye kunda chotoko cha ugima. ");
INSERT INTO ngp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Naye niyo amwink'ha Umwana udahi wa kusengela, Kwaviya yehe ni Mwana wa Mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Msekwehelwa, Kwaviya isa yeza want'hu wose wandile mwe vikuta naweve izwi dyakwe. ");
INSERT INTO ngp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Naho nawauyuke, wadya watendile mbuli zedi kwa uuyulo wo ugima, na wadya watendile mbuli ziihile kwa uuyulo wo masulumizo. ");
INSERT INTO ngp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Hikudaha kudamanya mbuli kwa udahi wangu miye mwenye, nalamula enga viya Mnungu anilagize, naho usengelo wangu miye wa kindedi, Kwaviya hikuzungula yadya huunga miye mwenye mna ya yudya aniletile. ");
INSERT INTO ngp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Mbuli zangu nnazilonga miye mwenye, nezinde hiyo kindedi. ");
INSERT INTO ngp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mna eyuko mnt'hu akunilongela mbuli zangu, naho miye himanya mbuli ziya akunilongela ni za kindedi. ");
INSERT INTO ngp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyuwe nomsigila want'hu kwa Yohana naye niyo alonga uwona we kindedi mwe zimbuli zangu. ");
INSERT INTO ngp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mna miye hikuhokela uwona uwo wakulonga want'hu, mna nalonga ivi vileke nyuwe myokolwe. ");
INSERT INTO ngp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana na kanda enga lumuli lukukwela kulangaza, naho nyuwe nomkeikila lumwe kuonela kinyemi ulumuli ulo kwa lupisi. ");
INSERT INTO ngp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mna uwona nnanawo miye ni mkulu kujink'ha udya wa Yohana Kwaviya zindima ziya anink'hile Tate nizidamanye zanilongela, naho zalagisa kugamba Tate niye anisigiile miye. ");
INSERT INTO ngp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tate aniletile kalonga kale uwona mwa miye, nyuwe hamnati mmuwone ifuta yakwe, naho hata kwiva izwi dyakwe. ");
INSERT INTO ngp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ulosi wakwe haumuli mwe mioyo yenyu, Kwaviya nyuwe hamkumhuwila yudya asigilwe ni Tate. ");
INSERT INTO ngp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mwakaulisa yadya yawandikwe kwaviya mmanya mndani mwakwe umwo mna ugima wa ulo na ulo. Mawandiko wenye wanilongela miye. ");
INSERT INTO ngp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hamkuunga kwiza kwangu vileke mnde na ugima. ");
INSERT INTO ngp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Hiyo kugamba nazungula kutogolwa kulawa kwa want'hu. ");
INSERT INTO ngp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mna hiwamanyani kugamba mwe mioyo yenyu hamna lukunde kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miye hiza kwa udahi wa Tate, mna nyuwe hamkunihokela, mna mtuhu aneza kwe dizina dyakwe yehe mwenye uyo nomumhokele. ");
INSERT INTO ngp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nomdahe ivivihi kunihuwila nyuwe mkuhokela ukulu kulawa mwenyu, mna hamkuzungula ukulu kulawa kwa Mnungu? ");
INSERT INTO ngp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Msekugamba neniwalongelezeni kwa Tate, eyuko akuwalongelezeni nyuwe, yehe ni Musa yudya nyuwe mkumkawiila. ");
INSERT INTO ngp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Uneva mwamhuwile Musa, hegu nomnihuwila name Kwaviya yehe nakawandika zimbuli zangu. ");
INSERT INTO ngp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mnaalo Kwaviya hamyahuwile yadya awandike Musa, nomhuwile vivihi aya miye hulonga?” ");
INSERT INTO ngp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu niyo aita gundi ye bahali ye Galilaya. ");
INSERT INTO ngp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Fyo kulu dya want'hu niyo dyamtimila Kwaviya nawaviona vilagiso awadamanyile wanyonge. ");
INSERT INTO ngp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu niyo akwela ko lugulu no kwikala uko na wanamp'hina wakwe. ");
INSERT INTO ngp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wila wa wayahudi ye pasaka neinda ihagihi. ");
INSERT INTO ngp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu niyo enula meso yakwe, eze akaule niyo aona want'hu wengi wakumtimila, niyo amgamba Filipo, “Chakugulahi nk'hande ikuunga iweguse want'hu awa?” ");
INSERT INTO ngp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nakalonga viya vileke amgeze filipo, Kwaviya ye mwenye nakamanya diya akumgamba adamanye. ");
INSERT INTO ngp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo niyo amhitula, “Hata chandile na matundu yakubula dinali magana maidi, haya kudaha kugula mikate niyo kila yumwenga adye egute.” ");
INSERT INTO ngp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yumwenga wa wanamp'hina wakwe akwitangwa Anduleya mvunawe dya simoni Petulo, niyo agamba, ");
INSERT INTO ngp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kuna ndugu ywetu yumwenga anamikate mishano na samaki mbili. Mna ivi navikint'he mbwai mwa want'hu enga awa?” ");
INSERT INTO ngp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu niyo awagamba, “Wekazeni want'hu hasi”. Kwaviya na handa na mani mengi want'hu niyo wekala hasi, wagosi na wanda wabula elufu shano. ");
INSERT INTO ngp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu niyo aguha idya mikate nakumtogola Mnungu niyo awenk'ha wadya want'hu wekale hasi hamwenga na viya visamaki viidi kila yumwenga viya vikumkint'ha. ");
INSERT INTO ngp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Want'hu wose weze wegute niyo awagamba wanamp'hina wakwe, “Kisanyeni wabesu wasigale kusekwaga kabesu kokose.” ");
INSERT INTO ngp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","“Niyo waduganya awabesu wadya no kumemeza nt'hangulu mlongo na mbili.” ");
INSERT INTO ngp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Want'hu weze waone vilagiso viya adamanye Yesu, niyo wagamba, “Ikindedi uyuo ni yudya mlotezi chandile kikagoja.” ");
INSERT INTO ngp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu eze amanye nawakaunga kumtozeleza vileke ande Zumbe wawe, niyo ahalawa ikedu nokuita kwo lugulu. ");
INSERT INTO ngp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ize ibuze nekisingi wanamp'hina wakwe niyo waseleza kuita kwe diziwa. ");
INSERT INTO ngp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Niyo wengila kwe ngalawa no kukonga kujink'hanya kuita Kapelinaumu, umuda uo kaziza nakakonga kwingila, Yesu nae na kanda akei kulaila. ");
INSERT INTO ngp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lupisi uo heho kulu nedikavumila, ibahali nayo neikonga kuhilukila. ");
INSERT INTO ngp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wana mp'hina wakwe weze wagambigwe wagendalugendo ukubula maili mnane, niyo wamuona Yesu agenda mnanga mwa mazina ehagihi ne ngalawa, wogohesa. ");
INSERT INTO ngp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mna Yesu niyo awagamba, “Ni miye msekogoha.” ");
INSERT INTO ngp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Niyo wanda na kinyemi kikulu no kumhokela mwe ingalawa, lupisi ulo niyo wanda wabula kudya wandile wakaita. ");
INSERT INTO ngp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Zuwa dya kaidi wadya want'hu wekale nt'hendelo idya ya kaidi nawaona kugamba handaga na ngalawa imwenga du, naho Yesu na kanda haitile na wanamp'hina wakwe, awanamp'hina wakwe nawahalawa woho wenye. ");
INSERT INTO ngp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mna zimashua nt'huhu kulawa Tibelia nazinda hagihi nakubula hadya hant'hu wadile imikate viya Yesu eze amtogola Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wadya want'hu weze wabunk'hule Yesu na kanda hahali hamwenga na wanamp'hina wakwe niyo wengila mwe zia zingalawa na kwiita Kapelinaumu kumzungula. ");
INSERT INTO ngp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Weze wambwile Yesu gundi ye diziwa niyo wamuuza, “Mhinizi, kubula ini uku?” ");
INSERT INTO ngp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu niyo awahitula, “Nyuwe hamkunizungula kwaviya vilagiso hamwenga na vilagiso viya hudamanya, mna mwanizungula kwaviya no mdya imikate niyo mweguta. ");
INSERT INTO ngp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Msekuidamanyila ndima nk'hande ikubanika mna damanyileni ndima nk'hande heikusila, nk'hande yo ugima wa ulo na ulo ink'hande iyo nomwink'higwe ni Mwana wa Mnt'hu naho Tate Mnungu ye mwenye kalagisa kugamba, kamsagula na kumzumila.” ");
INSERT INTO ngp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Niyo wamuuza, “Haluse kitende vivihi vileke kidahe kudamanya viya Mnungu akuunga kidamanye?” ");
INSERT INTO ngp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu niyo awahitula, “Kiya mkuungwa ni Mnungu mdamanye ni kugamba, mumhuwile yudya asigilwe.” ");
INSERT INTO ngp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Niyo wamgamba, “Noudamanye kilagiso chani kikione vileke kikuhuwile? Noudamanye kint'hu chani? ");
INSERT INTO ngp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wakale wetu, nawadya nk'hande ikwitangwa mana mwe nyika enga yadya yawandikwe yakulonga, ‘Nakawenk'ha mikate kulawa kwa Mnungu niyo wadya.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu niyo awahitula, “Nawagambileni ikindedi, hiyo Musa awenk'heni imikate kulawa kwo ulanga Tate niye awenk'heni mkate we kindedi kulawa kwo ulanga. ");
INSERT INTO ngp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwaviya mkate wa Mnungu ni yudya aseele kulawa kwa Mnungu na yehe niye akwink'hiza ugima want'hu wa mwe Isi.” ");
INSERT INTO ngp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Niyo wamgamba, “Zumbe, kink'he iyo nk'hande mazuwa yose.” ");
INSERT INTO ngp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu niyo awagamba, “Miye niye nk'hande ikwink'hiza ugima, mnt'hu akwiza kwangu haaone sala naho, naho yudya akunihuwila haaone nk'hilu naho. ");
INSERT INTO ngp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mna himigambilani, mwaniyona mna mkei hamkuunga kunihuwila. ");
INSERT INTO ngp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wadya wose Tate anink'hile naweze kwangu naho yudya akwiza kwangu henimduule kuse. ");
INSERT INTO ngp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwaviya hizile kulawa kwa Mnungu vileke nidamanye yadya huunga miye, mna hiza vileke nidamanye yadya akuunga yudya akisigiile. ");
INSERT INTO ngp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Viya akuunga yudya akisigiile ni ivi, ‘Nisekumwaza hata yumwenga mwe wadya anink'hile mna vileke niwauyule wose mwe dizuwa diya dyo uheelo. ");
INSERT INTO ngp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwaviya mbuli akuunga Tate ni ino, wose wamuwone umwana no kumhuwila wande na ugima wa ulo na ulo name neniwauyule mwe dizuwa dyo uheelo.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Wayahudi niyo wakonga kun'gung'uzika Kwaviya naakagamba, “Miye ni mkate nizile kulawa kulanga kwa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Niyo wauza, “Uyo hiyo Yesu mwana ywa Yusufu? Naho ise na nine hikugamba kiwamanya? Haluse ni mbwai akigamba kaseela kulawa kwa Mnungu?” ");
INSERT INTO ngp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mna Yesu niyo awagamba, “Mse kungunguzika, ");
INSERT INTO ngp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hahali mnt'hu akudaha kwiza kwangu uneva Tate anitumile miye hamletile kwangu, name nenimuuyule mwe zuwa dyo uheelo. ");
INSERT INTO ngp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Enga walotezi wa Mnungu viya wawandike, ‘Wose nawahinizwa na Mnungu.’ Yehe akumtegeleza Tate hamwenga na kuhina kulawa kwakwe, neeze kwangu. ");
INSERT INTO ngp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Uko nuko kugamba hakuna mnt'hu amuone Tate, mna ni yudya alaile kwa Mnungu, nie amuone kale Tate. ");
INSERT INTO ngp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Namigambilani ikindedi, akunihuwila ananao ugima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Miye niye nk'hande yo ugima, ");
INSERT INTO ngp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tati zenu na wadya mana kwe dijangwa mna niyo wabanika. ");
INSERT INTO ngp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mna aha hana nk'hande ilaile kwa Mnungu, naho mnt'hu yeyose anadya haabanike, ");
INSERT INTO ngp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Miye niyo ink'hande ilaile kwa Mnungu, Mnt'hu yeyose anadya iyo ink'hande neekale ulo na ulo. Naho nk'hande yenye niino, umwili wangu huunga niulave vileke want'hu wose mwe isi wande na ugima.” ");
INSERT INTO ngp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aho wayahudi niyo wakonga kuhigana wenye kwa wenye wakauzana, “Mnt'hu uyu adaha vivihi kukink'ha suwe umwili wakwe kiudye?” ");
INSERT INTO ngp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu niyo awagamba, “Namigambilani ikindedi, hamna udile umwili wakwe Mwana wa Adamu hamwenga na kuinywa isakame yakwe, hamkudaha kunda na ugima mndani mwenyu.” ");
INSERT INTO ngp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wadya wakuudya umwili wangu hamwenga na kuinywa isakame yangu wananao ugima wa ulo na ulo. Naho miye neniwauyule mwe dizuwa dyo uheelo. ");
INSERT INTO ngp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwaviya umwili wangu niyo nk'hande ye kindedi na isakame yangu nicho cho ukunywa che kindedi. ");
INSERT INTO ngp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wakuudya umwili wangu nakuinywa isakame yangu wekala mndani mwangu name nekala mndani mwawe. ");
INSERT INTO ngp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tate emgima kanisigila miye, miye name ni mgima kwa Tate, Ivi yudya akuunga anidye naende mgima umwangu. ");
INSERT INTO ngp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ino niyo ink'hande ikuseela kulawa kwa Mnungu hiyo enga viya Tati zenyu wadile idya nk'hande niyo wafa, mna akuunga adye ino nk'hande naande mgima ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mbuli izi nakazilonga mwe nyumba yo kuvikila uko Kapelinaumu. ");
INSERT INTO ngp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wanamp'hina wakwe wengi weze weve mabilikizi yakwe niyo wagamba, “Mabilikizi yakwe ni madala, akuunga ayatongele ni ani?” ");
INSERT INTO ngp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mwe umoyo wakwe Yesu niyo abunk'hula kugamba, wanamp'hina wakwe wangunguzika mwe yadya alongile, niyo awagamba, “Haluse ulosi uno umilumizani mwe mioyo? ");
INSERT INTO ngp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Haluse neinde vivihi mkamuona Mwana wa Adamu akwela akaita kudya alawaga? ");
INSERT INTO ngp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kikugela ugima ni Muye ywa Mnungu, mnt'hu hana udahi wowose. Mbuli nimigambileni nuwo ugima, na Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mna mwa nyuwe kuna watuhu wakei kuhuwila” Yesu na kanda kamanya kukongela aho nk'hongo yudya hehuwile hamwenga na yudya akuunga amsenge. ");
INSERT INTO ngp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Niyo agendeela ukulonga, “Ivo nivo vilekile hamigambilani, hahali mnt'hu akudaha kwiza kwangu uneva Tate haungile.” ");
INSERT INTO ngp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mbuli iyo niiyo ilekile wengi mwa wanamp'hina wakwe wauye kunyuma waleke kumtimila. ");
INSERT INTO ngp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu niyo awagamba wadya mlongo na waidi, “Togoleni nyuwe nanywe mwaunga mhalawe?” ");
INSERT INTO ngp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petulo niyo amhitula, “Zumbe kiite kwaani? Weye una mbuli zo ugima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Suwe kikuhuwila naho kibunk'hula kugamba weye niwe msuntilwa ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu niyo amhitula, “Togoleni, miye himisaguleni nyuwe mlongo na waidi mna yumwenga ywenyu ni Mwavu?” ");
INSERT INTO ngp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Naakalonga Yuda mwana ywa Simoni Isikaliyote. Yehe na kanda yumwenga mwa wanamp'hina wa Yesu mna niye andile nakaunga amsezenge. ");
INSERT INTO ngp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Akajika Yesu andaga akagenda uko Galilaya, andaga hakuunga akomboka mwo Uyahudi kwaviya Wayahudi nawanda wakamzungula vileke wamkome. ");
INSERT INTO ngp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Naho dizuwa dya kinyemi dya Wayahudi dye viheha nedinda dihagihi. ");
INSERT INTO ngp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nduguze niyo wamgamba, “Halawe aha uite Uyahudi, vileke wanamp'hina wako wakaule zindima zako ukudamanya.” ");
INSERT INTO ngp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kwaviya hahali mnt'hu akuunga adamanye zindima kwa kinyele, mna ye mwenye aunga amanyike. Kwaviya weye wadamanya izimbuli izi, leka want'hu wose wa mwe Isi wakumanye. ");
INSERT INTO ngp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kwaviya hata wanduguze na wanda hawakumhuwila. ");
INSERT INTO ngp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu niyo awagamba, “Lupisi lwangu ukei kubula, kila lupisi niwedi kwenyu. ");
INSERT INTO ngp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Want'hu wa mwe isi hawakudaha kumiihieni, mna waniihia miye, Kwaviya miye nalonga uwona mwa yehe kugamba udamanyi wakwe wiha. ");
INSERT INTO ngp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nyuwe iteni kwe wila mna miye nikei Kwaviya umuda wangu ukei kubula.” ");
INSERT INTO ngp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu nakalonga ivi niyo asigala ukudya Galilaya. ");
INSERT INTO ngp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nduguze weze waite kwe wila Yesu nae niyo aita, Mna nakaita kwa kifiso vileke asekuoneka. ");
INSERT INTO ngp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Wakulu wa wayahudi nawakamzungula kudya kwe wila wakauzana, “E kuhi uyu?” ");
INSERT INTO ngp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Want'hu wengi na wanda mwe vibungi wakasimuila zi mbuli zakwe. Wamwenga nawakagamba, “uyuno ni mnt'hu ywedi.” Awatuhu nao niyo wagamba, “Hiyo mnt'hu ywedi Kwaviya awazaganya want'hu.” ");
INSERT INTO ngp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mna hahali mnt'hu alongile mwe kieti Kwaviya nawaka wogoha wayahudi. ");
INSERT INTO ngp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mgati mwe wila Yesu niyo akwela no kwingila mwe nyumba ya Mnungu no kukonga kuhiniza. ");
INSERT INTO ngp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wayahudi niyo wehelwa wakagamba, “Uyu kalavai umanyi wa aya yose nae hasomile heusomile?” ");
INSERT INTO ngp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu niyo awahitula, “Yano huhiniza hiyo mahinyo yangu, mna lawa kwa Tate aniletile miye. ");
INSERT INTO ngp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mnt'hu akuunga adamanye zimbuli ziya Mnungu akuunga, naamanye uneva aya huhiniza yalawa kwa Mnungu hegu ni yangu miye mwenye. ");
INSERT INTO ngp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mnt'hu akukelongela ye mwenye aunga akeink'he uwedi utendese ye mwenye. Mna yudya akuunga amwinule yudya amletile uyu niwakindedi naho hauhali wiihi mndani mwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa hawenk'heni miko? Mna hahali hata yumwenga mwa nyuwe azitozile. Nii mwaunga mnikome miye?” ");
INSERT INTO ngp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Idifyo diya dya want'hu niyo dyamhitula, “Una mp'hepo! Uyo akuunga akukome weye ni ani?” ");
INSERT INTO ngp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu niyo awahitula, “Nehidamanya kihungi nyuwe nyose niyo mwehelwa. ");
INSERT INTO ngp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa nakawasigila muwavinile wana wenyu wa kigosi Mna neinda hiyo Musa aungile na wanda Tati zenyu walongole naho mwavinila wana mwe dizuwa dyo kuhumula. ");
INSERT INTO ngp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Uneva mwana wa kigosi kavinilwa mwe dizuwa dya kuhumula, vileke miko ya Musa isekubanangwa, nii mwanifila maya Kwaviya nitendile mnt'hu ande mgima mwe zuwa dyo kuhumula? ");
INSERT INTO ngp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Msekulava usengelo kwa kukaula kwa kuse mna laveni usengelo kwa kukaula ikindedi.” ");
INSERT INTO ngp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Want'hu watuhu we Yelusalemu niyo wagamba, “Yuno hiyo yudya mnt'hu wakunga wamkome? ");
INSERT INTO ngp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kauleni alonga mwe kiyeti mna hawakulonga dyodyose. Togoleni, vilongozi wamanya ikindedi kugamba yuno niye Kilisito? ");
INSERT INTO ngp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mna Kilisito aneza hahali mnt'hu akuunga amanye uko alaile. Mna suwe chose kimanya kudya akulawa yuno mnt'hu.” ");
INSERT INTO ngp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu eze enda ahiniza mwe nyumba ya Mnungu niyo alonga kwa izwi kulu, “Icho nk'hindedi kugamba mnimanya miye, na kudya nilaile. Hizile kwa udahi wangu miye mwenye. Yudya anigale miye, yehe ni mkindedi, mna hamummanyize. ");
INSERT INTO ngp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mna miye himmanya Kwaviya hiza kulawa kwakwe naho yehe niye aniletile.” ");
INSERT INTO ngp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Niyo wageza kumgwila, mna hahali hata yumwenga amtozile Kwaviya umuda wakwe nawanda ukei. ");
INSERT INTO ngp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Niyo want'hu wengi mwe difyo diya wamhuwila na kulonga, “Aho aneza Kilisito, naadamanye vilagiso vingi enga ivi adamanye yuno?” ");
INSERT INTO ngp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo niyo weva viya want'hu wakungungula mwe mbuli izi za Yesu, niyo woho hamwenga ne wakulu wa walava nt'hambiko wasigila wamizi we nyumba ya Mnungu uleke waite wakamgwile Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu niyo alonga, “Usigala lupisi mdodo wa kunda na nyuwe, nikakuheza neniite zangu kwa yudya aniletile. ");
INSERT INTO ngp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Namunzungule mna hamnione, kwaviya hamkudaha kwiita kudya huunga ninde.” ");
INSERT INTO ngp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Niyo wayahudi wauzana, “Ni kuhi uko aite, uko hekimuwone? Haluse aunga aite kwe mizi ye Wagiliki kudya want'hu wetu wakwikala nakuwahiniza Wagiliki? ");
INSERT INTO ngp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nivo naakagaaze umwo akagamba, nomnizungule mna hamnione naho homdahe kwiita kudya huunga niite?” ");
INSERT INTO ngp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mwe zuwa dya uheelo, zuwa diya kulu mwe zuwa dya kinyemi, Yesu niyo akimaala alonga kwa izwi kulu, “Mnt'hu yudya ane nk'hilu eze kwangu anywe. ");
INSERT INTO ngp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Enga viya iwandikwe, ‘Yudya akunihuwila, vizuto va mazi yo ugima navilawe kulawa mndani mwakwe.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu nakalonga ivi kwa mbuli ye Muye ywa Mnungu, yudya wadya wakumhuwila nawamhokele. Mwe lupisi kiya Muye na kanda akei kwiza kwaviya Yesu na kanda akei kutogoleswa ni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Want'hu wamwenga naweva viya alongile niyo walonga, “Mnt'hu uyu, kindedi ni Mlotezi.” ");
INSERT INTO ngp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Want'hu watuhu niyo wagamba, “Uyu ni Kilisito!” Mna watuhu niyo wagamba, “Vyadahika Kilisito kulawa Galilaya? ");
INSERT INTO ngp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mawandiko wakigambila, Kilisito naalaile mwo lukolo lwa Zumbe Daudi naho neelekigwe Betelehemu mzi ekalaga Daudi.” ");
INSERT INTO ngp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Niyo handa na kupangana kwa want'hu kwa mbuli yakwe Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Watuhu nawakaunga kumgwila, mna hahali amtozile. ");
INSERT INTO ngp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wadya wamizi wa nyumba ya Mnungu wasigilwe weze wauye, wakulu wa walava nt'hambiko hamwenga na Mafalisayo niyo wawauza, “Nii hammwigale?” ");
INSERT INTO ngp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wadya wamizi wa Nyumba ya Mnungu niyo wahitula, “Hahalailaga hata mnt'hu yumwenga akulonga enga mnt'hu uyu!” ");
INSERT INTO ngp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafalisayo niyo wawauza, “Hata nyuwe mwazaganywa?” ");
INSERT INTO ngp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Nyuwe mummanya yeyeso mwe Vilongozi hegu mwe Mafalisayo akumhuwila yehe? ");
INSERT INTO ngp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Want'hu wano hawamanyize miko ya Musa, waligitwa ni Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mwe wadya mafalisayo, Nikodemo andagaaho, yudya aitaga kwa Yesu, niyo awagambila weyawe, ");
INSERT INTO ngp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mwe miko ya kwetu hakikudaha kumsengela mnt'hu uneva kikei kumtegeleza na kumanya idyo adamanye.” ");
INSERT INTO ngp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Niyo wamhitula, “Weye nawe kulaila Galilaya? Kaula mo Mawandiko Akukile naho nauone hahali mlotezi ezile kulawa Galilaya.” ");
INSERT INTO ngp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Niyo kila yumwenga aita kwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu niyo aita ko Mnima lwe Mizeituni. ");
INSERT INTO ngp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mtootondo, niyo auya naho kwe Nyumba ya Mnungu. Want'hu wose wamzungulukaga niyo yehe ekala hasi no kukonga kuwahiniza. ");
INSERT INTO ngp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wahinizi we miko hamwenga na Mafalisayo niyo wamwigaila mvele agwiligwe akadamanya uhambwasi, niyo wamkimalisa hameso ya want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Niyo wamgamba Yesu, “Mhinizi, mvele uyu kagwiligwa akadamanya uhabwasi. ");
INSERT INTO ngp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mwe miko yetu Musa kakigamba, mvele enga uyu aungigwa atoigwe maiwe mpaka abanike. Weye wagaaze?” ");
INSERT INTO ngp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nawalonga ivi kumtegela Yesu vileke wamlongeleze. Mna yehe niyo afunamaga hasi niya akonga kuwandika hasi na kadole kakwe. ");
INSERT INTO ngp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Weze wande wakagendeela kumuuza maswali, Yesu akimaalaga nakuwagamba, “Mnt'hu yeyose mwenyu heena wavu ande ywa nk'hongo kumduila iwe.” ");
INSERT INTO ngp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Niyo afunama naho nakuwandika hasi. ");
INSERT INTO ngp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Weze weve ivi, wose niyo wahalawa, yumwe yumwe wakakongela wadala vilongozi. Yesu niyo asigala ekedu na yudya mvele endile akei kakimala. ");
INSERT INTO ngp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu niyo akimaala, amgamba yudya mvele, “Wekuhi? Hasigale hata yumwenga akukulongeleza?” ");
INSERT INTO ngp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yudya mvele niyo amhitula, “Zumbe hawahali.” Yesu niyo agamba, “Vedi. Hata miye hikukusengela keitile, mna unasekudamanya wavu naho.” ");
INSERT INTO ngp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu niyo alonga vituhu na Mafalisayo, “Miye niye ung'azi we isi.” Niyo agendeela, “Yudya akunitimila na ande na ung'azi wa ugima naho haagendele mwo lwiza.” ");
INSERT INTO ngp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafalisayo niyo wamgamba, “Weye walava uwona wako mwenye, na izo ukukelongela uwona hiyo za kindedi.” ");
INSERT INTO ngp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu niyo awahitula, “Hata nnakelongela uwona mbuli idya hukelongela ni kindedi, Kwaviya himanya kudya hulawa na kudya huita. Nyuwe hammanyize kudya hulawa hamwenga na kudya huita. ");
INSERT INTO ngp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyuwe mwasengela kimnt'humnt'hu, miye himsengele mnt'hu yeyose. ");
INSERT INTO ngp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mna uneva nnadamanya ivo, usengelo wangu nounde wakindedi. Kwaviya miye hikedu, Tate yudya anigale e hamwenga na miye. ");
INSERT INTO ngp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Iwandikwa mwe miko yenyu kugamba, ‘Uneva want'hu waidi wanalava uwona ukuligana, icho wakulonga, ni kindedi.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","“Nalonga uwona wa miye mwenye, Tate yangu nae anigale anilongela uwona.” ");
INSERT INTO ngp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Niyo wamuuza, “Iso eihi?” Yesu niyo awahitula, “Hamnimanyize miye naho hamummanyize Tate. Mwanimanyize miye hata Tate hegu nomummanya.” ");
INSERT INTO ngp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu nakalonga yose aya viya andile akahiniza mwe Nyumba ya Mnungu. Mwe chumba kikuikigwa ikindolo cha malavo Naho hahali hata yumwenga amgwiile Kwaviya umuda wakwe no unda ukei kubula. ");
INSERT INTO ngp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu niyo alonga nao vituhu, “Nenihalawe nanywe nomnizungule, mna nomfe mwo wavu wenyu. Hamkudaha kuita kudya miye huita.” ");
INSERT INTO ngp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Vilongozi wa Wayahudi niyo wagamba, “Agamba hakikudaha kuita kudya akuunga aite, haluse kigambe aunga akekome yehe mwenye?” ");
INSERT INTO ngp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu niyo awahitula, “Nyuwe ni wa aha he isi, mna miye hiza kulawa kulanga kwa Mnungu. Nyuwe mwalawa mwe isi ino mna miye hiyo wa ino isi. ");
INSERT INTO ngp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ivo nivo vilekile hamigambilani nomfe kwo wavu uwo mnanawo, naho nomfe mwo wavu wenyu uneva hamkuhuwila kugamba, ‘Miye ni Yehe.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Niyo wamuuza, “Weye ni ani?” Yesu niyo awahitula, “Idiya nawagambilani kukongela aho nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nnanazo mbuli nyingi za kulonga mwa want'hu wose wamwe isi, na za kuwasengela nyuwe, yudya anigale miye yehe ni Mkindedi. Naho nawagambila want'hu diya nivile kulawa kwakwe.” ");
INSERT INTO ngp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hawabunk'hule kugamba Yesu nakawagambila mbuli ya Ise. ");
INSERT INTO ngp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu niyo awagamba, “Mnamwinula Mwana wa Mnt'hu nommanye, ‘Miye niye Yehe.’ Naho nommanye hikudamanya mbuli yoyose kwa udahi wangu miye mwenye, mna nalonga dia Tate anisigiile nnonge. ");
INSERT INTO ngp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Naho yudya anigale miye e hamwenga na miye, hakunasa nikedu, Kwaviya nadamanya mbuli ziku mbwedeza.” ");
INSERT INTO ngp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Want'hu wengi wevile Yesu viya naakasimuila, niyo wamhuwila. ");
INSERT INTO ngp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu niyo awagambila wadya Wayahudi wakumhuwila, “Mnayazumila amahinizo yangu, nomnde wanamp'hina wangu kindedi, ");
INSERT INTO ngp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","naivo nommanye ikindedi, naho icho ikindedi, nekimiikeni vilekelwa.” ");
INSERT INTO ngp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Niyo wamhitula, “Suwe ni welekwa wa Ibulahimu, naho hakinati kinde watumwa wa mnt'hu yeyose. Nii ukagamba, ‘Nomnde walekelwa?’ ” ");
INSERT INTO ngp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu niyo awagamba, “Namigambilani ikindedi, kila mnt'hu akudamanya wavu ni mtumwa wo wavu. ");
INSERT INTO ngp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mtumwa hi mwana wa mwe kaya mazuwa yose, mna mwana mwelekwa yehe ni wa umudya mndani mazuwa yose. ");
INSERT INTO ngp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Uneva Mwana anawatenda mnde vilekelwa, nomnde vilekelwa kindedi. ");
INSERT INTO ngp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Hiwamanyani nyuwe ni cheleko che Ibulahimu, mna mwaunga mnikome, Kwaviya hamkuyaunga mahinyo yangu. ");
INSERT INTO ngp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nalonga diya Tate anilagise, mna nyuwe mwadamanya diya mgambilwe ni tati yenyu.” ");
INSERT INTO ngp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Niyo wamhitula, “Tati yetu ni Ibulahimu.” Yesu niyo awahitula, “Uneva mwandile wana Ibulahimu, hegu mwadamanye zimbuli enga ziya adamanye. ");
INSERT INTO ngp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yose nidamanye, nikumigambilani kindedi nivile kulawa kwa Mnungu mna mwaunga mnikome. Ibulahimu hadamanye mbuli enga izi! ");
INSERT INTO ngp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwadamanya mbuli enga ziya tati yenyu adamanye.” Niyo wamhitula, suwe hachelekwe mwo uhabwasi. “Kina Tate yetu yumwenga du niye Mnungu. Suwe naswe kiwana wakwe wa kindedi.” ");
INSERT INTO ngp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu niyo awagamba, “Mnungu andile tati yenyu kindedi, hegu nomniunga kwaviya nalawa kwakwe naho hiza. Hizile miye mwenye mna yehe niye aniletile. ");
INSERT INTO ngp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nii hamkukombaganya diya hulonga? Kwaviya hamkuunga kwiva ulosi wangu. ");
INSERT INTO ngp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nyuwe wana wa tati yenyu Mwavu, naho mwaunngisa kuyatimila yadya tati yenyu akuyaunga. Kukongela nk'hongo na kanda mkomi, naho akei ande mwe kindedi, Kwaviya hamna ikindedi mndani mwakwe, kwaviya aho akalonga uudant'hi, alagisa viya eli, kwaviya yehe mwenye ni mdant'hi na tate wo udant'hi. ");
INSERT INTO ngp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Name Kwaviya nalonga ikindedi nivo vikuleka hamkunihuwila. ");
INSERT INTO ngp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni yuhi mwa nyuwe akudaha kulagisa kugamba miye hidamanya wavu? Miye nnalonga ikindedi nii nyuwe hamkunihuwila? ");
INSERT INTO ngp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mnt'hu ywa Mnungu eva yadya ya Mnungu, Mna nyuwe hamkwiva Kwaviya hiyo wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wayahudi niyo wamhomola Yesu wakagamba, “Haluse suwe hakikulonga ikindedi kugamba weye hwi Msamalia naho una mp'hepo?” ");
INSERT INTO ngp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu niyo awahitula, “Miye hina mp'hepo. Namtunya Tate, mna nyuwe hamkunitunya. ");
INSERT INTO ngp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mna miye hikuzungula ukulu, eyuko akuzungula ukulu uwo, niyehe akuunga asengele. ");
INSERT INTO ngp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ikindedi namigambilani, mnt'hu aneva yadya hulonga haabanike chu.” ");
INSERT INTO ngp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mna Wayahudi niyo wamgamba, “Haluse kibunk'hula kugamba una mp'hepo iihile. Ibulahimu kabanika hamwenga na walotezi wose mna weye wagamba, Mnt'hu anatoza mahinizo yako haabanike chu.” ");
INSERT INTO ngp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Weye umkulu kujink'ha tati yetu Ibulahimu abanike. Na walotezi wose wa Mnungu wabanika, weye waketenda niwe ani? ");
INSERT INTO ngp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu niyo amhitula, “nakeink'ha ukulu miye mwenye, nt'hunyo yangu hiyo kint'hu, akunitunya ni Tate, yudya nyuwe mkugamba Mnungu ywenyu. ");
INSERT INTO ngp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Naho nyuwe hamummanyize mna miye himmanya, nnagamba himmanyize neninde mlulimi enga nyuwe, mna miye himmanya naho hitoza ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tati yenyu Ibulahimu na kanda na kinyemi kikulu, Kwaviya akuunga adione dizuwa dyo kwiza kwangu naho niyo adiona na kwelelwa.” ");
INSERT INTO ngp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wayahudi niyo wamgamba, “Weye ukei kubuza myaka milongo mishano mna kumuwona Ibulahimu!” ");
INSERT INTO ngp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu niyo awagamba, “Ikindedi nawagambileni,” “Ibulahimu umwo andaga akei kwelekwa, ‘Miye ni aho’.” ");
INSERT INTO ngp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Niyo walogota maiwe vileke wamtoe, Yesu niyo akefisa nakufosa mwe nyumba ya Mnungu no kuhalawa. ");
INSERT INTO ngp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Umwo Yesu andile akomboka, amuwonaga mnt'hu andaga mant'hunt'hu kukongela kwelekwa kwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wanamp'hina wakwe niyo wamuuza, “Mhinizi, mnt'hu uyu na wadya wamweleke ni yuhi adamanye wiihi vilekile akalekwa mant'hunt'hu?” ");
INSERT INTO ngp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu niyo ahitula, “Yuno hadamanye wiihi naho hata wadya wamweleke. Mna ivi vilaila vileke ndima za Mnungu zioneke. ");
INSERT INTO ngp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Naho yaungigwa kizidamanye zindima zakwe yehe akisigiile kukei nomsi, kilo cheza naho mnt'hu haadahe kudamanya ndima. ");
INSERT INTO ngp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lupisi nili mwe isi, miye ni ung'azi we isi” ");
INSERT INTO ngp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Eze ajink'he kulonga ivo, niyo atwa mate hasi, adamanya nt'hope kwa yadya mate, amhaka int'hope idya mwa meso, yudya andile nt'hunt'hu. ");
INSERT INTO ngp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Niyo amgamba, “Ita ukahake mwe dibilika dya Siloamu.” Zina Siloamu ni ulosi wa Kiibulania, nuko kugamba, “Atumigwe.” Basi niyo aita nao kuhaka mazi, niyo auya meso yakwe yaona. ");
INSERT INTO ngp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Want'hu we haguhi naye na wadya wamuwone kale viya endile hakuona, naho viya endile mlombezi, niyo wauza, “Haluse yuno hi yudya endile akekala na kulombeza?” ");
INSERT INTO ngp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Watuhu niyo wagamba, “Hiyo yehe mna kakaeiga du.” Mna yehe mwenye niyo agamba, “Miye ni yehe.” ");
INSERT INTO ngp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Niyo wamgamba, “Kutenda vivihi vilekile ukaona?” ");
INSERT INTO ngp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yehe niyo awahitula, “Mnt'hu yudya akwitangwa Yesu nakadamanya nt'hope, niyo anihaka mwe meso, anigamba, ‘Ita Siloamu ukahake.’ Niyo naita nahaka mazi vatenda naona.” ");
INSERT INTO ngp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Niyo wamgambila, “E kuhi uyo?” Yehe nae niyo awahitula, “Miye himanyize.” ");
INSERT INTO ngp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Niyo wamwigala kwe Mafalisayo yudya endile hakuona. ");
INSERT INTO ngp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Naho na inda mwe zuwa dya Kuhumula viya Yesu adamanye ziya nt'hope na kumgela yudya mnt'hu akanda aona. ");
INSERT INTO ngp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mafalisayo niyo wamuuza vituhu viya vendile niyo meso yakwe yanda yaona. Yehe niyo awagamba, “Nakanigela nt'hope mwe meso niyo nahaka mazi valekile ivi haluse naona.” ");
INSERT INTO ngp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafalisayo watuhu niyo wagamba, “Mnt'hu uyo halaile kwa Mnungu, kwaviya hakuitoza miko ya zuwa dya kuhumula.” Mna watuhu niyo wauza, “Yadahika vivihi mnt'hu mta wiihi kudamanya vilagiso va vihungi?” Niyo woho wenye wanda wapangana. ");
INSERT INTO ngp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mafalisayo niyo wamuza vituhu uyo mnt'hu endile matunt'hu, “Togola, we mwenye wamgaze mnt'hu uyo akufumbule ameso yako?” Niyo awagamba, “Mnt'hu uyo ni mlotezi!” ");
INSERT INTO ngp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Vilongozi wa Wayahudi niyo wenda hawakuhuwila kugamba mnt'hu uyo andaga hakuona mpaka weze wawetange wadya wamweleke. ");
INSERT INTO ngp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Niyo wawauza kugamba, “Yuno niye mwana wenyu mkugamba nakelekwa hakuona? Inda vivihi inde aona?” ");
INSERT INTO ngp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Welesi wakwe niyo wawahitula, “Suwe kimanya yuno niye mwana wetu, naho kimanya nakelekwa matunt'hu. ");
INSERT INTO ngp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mna inda vivihi akanda aona, suwe hakimanyize, naho hakimanyize uyo atendile akaona. Muuzeni yehe mwenye, Kwaviya yehe ni mnt'hu mkulu naawagambileni!” ");
INSERT INTO ngp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Welesi wakwe nawalonga ivo Kwaviya nawakawogoha vilongozi wa Wayahudi Kwaviya vilongozi awo nawagambilana kugamba, mnt'hu yeyose analonga kugamba Yesu ni Kilisito naaguluswe mwe nyumba ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nivo vilekile welesi wakwe wakalonga, “Ni mnt'hu mkulu muuzeni yehe mwenye.” ");
INSERT INTO ngp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Niyo wamwitanga kaidi yudya andile nt'hunt'hu, niyo wamgamba, “Mwink'he uwedi utendese Mnungu, ulonge kindedi! Suwe kimanya mnt'hu uyo ni mta wavu.” ");
INSERT INTO ngp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yudya mnt'hu niyo awahitula, “Uneva yehe ni mta wavu miye himanyize, himanya mbuli imwenga, nehinda nt'hunt'hu mna ivi haluse naona.” ");
INSERT INTO ngp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Basi niyo wamuuza, “Nakakudamanyila mbwai? Nakakugubula meso vivihi yani?” ");
INSERT INTO ngp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Niyo awahitula, “Himigambilani, mna hamkunihuwila. Kwa mbwai mwaunga kwiva naho vituhu? Nyuwe nanywe mwaunga mwinde wanamp'hina wakwe?” ");
INSERT INTO ngp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Niyo wamhomola kugamba, “Weye u mwanamp'hina wakwe! Suwe ki wanamp'hina wa Musa. ");
INSERT INTO ngp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Suwe kimanya Mnungu nakalonga na Musa, mna yudya hakimmanyize uko alaile!” ");
INSERT INTO ngp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yudya mnt'hu niyo awahitula, “Mbuli iyo ni ya kwehelesa! Nyuwe hammanyize uko alaile mna katenda meso yangu yande yaona! ");
INSERT INTO ngp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kimanya kugamba Mnungu hakuwategelaza wata wavu, awategeleza want'hu wakumwogoha Mnungu na kudamanya yadya akuunga. ");
INSERT INTO ngp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kukongela nk'hongo ye isi hakinati kive kugamba kuna mnt'hu agubule meso ya mnt'hu elekwe matunt'hu. ");
INSERT INTO ngp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Uneva mnt'hu uyo halaile kwa Mnungu, heedahile kudamanya mbuli yoyose.” ");
INSERT INTO ngp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Niyo wamhitula, “Weye nokwelekwa na kukuila mo wavu! Ivi wadaha kukihiniza suwe?” Niyo wamgulusa kuse. ");
INSERT INTO ngp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu niyo eva kugamba wamgulusa mwe nyumba, umnt'hu yudya amhonyile, eze amuone, niyo amuuza, “Weye wamhuwila Mwana wa Mnt'hu?” ");
INSERT INTO ngp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yudya mnt'hu niyo amhitula, “Zumbe, ni yuhi uyo vileke nimhuwile?” ");
INSERT INTO ngp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu niyo amhitula, “Kumuwona, naho yudya akulonga na weye ivi haluse ni yehe!” ");
INSERT INTO ngp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yudya mnt'hu niyo amvika nokumgamba, “Zumbe, nahuwila.” ");
INSERT INTO ngp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu niyo agamba, “Miye hiza umu mwe isi kwa mbuli ya usengelo wadya hewekuona waone, na wadya wakuanyanya kugamba waona wande mant'hunt'hu.” ");
INSERT INTO ngp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafalisayo watuhu wandile hamwenga na yehe niyo weva viya alongile, niyo wamgamba, “Haluse wakigamba suwe naswe kimant'hunt'hu?” ");
INSERT INTO ngp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu niyo awagamba, “Mwandile mant'hunt'hu heguamwandile no uwavu mna mwagamba ‘Chaona’ ivo elo uwavu wenyu wekala.” ");
INSERT INTO ngp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu niyo awagamba, “Ikindedi namigambilani, yehe hekwingila mwe nk'hili yo mngo we zingoto mna ombokela kunk'handa uyo ni mbavi naho ni mhoki. ");
INSERT INTO ngp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Akwingila mo lwivi yehe ni mdimi we zingoto. ");
INSERT INTO ngp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mwamizi amkomoela mdimi Kwaviya ngoto zammanya dizwi dyakwe, naho Kwaviya kazimanya amazina yawe azitanga no kuzigala kuse. ");
INSERT INTO ngp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yanafosa kuse amagoto yakwe yose alongola na magoto yamtimila Kwaviya yamanya izwi dyakwe. ");
INSERT INTO ngp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mtakwiza hazikumtimila kwaviya hazimmanyize diizwi dyakwe.” ");
INSERT INTO ngp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu nakawagambila mliganyizo uwo, mna woho hawakombaganye imbuli iyo awagambile. ");
INSERT INTO ngp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu niyo awagambila vituhu, “Ikindedi nawagambilani, miye nie ulwivi lwa magoto. ");
INSERT INTO ngp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wose wanilongoele ni wabavi naho ni wahoki, naho magoto hayaweve. ");
INSERT INTO ngp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Miye nulo umnango. Mnt'hu akuunga engile kwa kombokela miye naahone, naaingile nakufosa naho naapate nk'hande. ");
INSERT INTO ngp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mbavi aneza eza vileke abawe, achinje, hamwenga na kubananga, miye hiza vileke wande na ugima naho wande nao wakubanikaluka. ");
INSERT INTO ngp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Miye nie mdimi wedi, mdimi ywedi adaha kulava ugima wakwe kwajili yamagoto yakwe. ");
INSERT INTO ngp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mnt'hu akulihwa hiyo mdimi, Kwaviya yehe zingoto hiyo zakwe, anayaona magwema yeza azileka zingoto nokunyilika. Naho digwema dyazigwila na hamwenga nakuzimwaganisa. ");
INSERT INTO ngp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yehe anyilika kwaviya ni mnt'hu ywa kulihwa naho mbuli ye zingoto hiyo kint'hu kwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Miye nuyo mdimi ywedi, wadya wakwangu hiwamanya, wadya awangu wanimanya miye. ");
INSERT INTO ngp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Enga viya Tate akunimanya, miye name nammanya. Miye naulava ugima wangu kwa mbuli ye zingoto. ");
INSERT INTO ngp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Naho nnanazo ngoto nt'huhu zandile hiyo zo umngo uno zoho nazo naungigwa nizilete, naho nezive mluzi wangu. Naho nakunde na fyo dimwenga na mdimi yumwenga. ");
INSERT INTO ngp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ivo elo niivo vilekile Tate akaniungisa, kwaviya naulava ugima wangu akajika nauguha naho vituhu. ");
INSERT INTO ngp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hahali mnt'hu akuulava ugima wangu mna ni miye mwenye. Name nnanawo udahi wakuulava, nnanawo udahi wa kuuguha naho vituhu. Mwiko uwo nehiink'higwa ni Tate.” ");
INSERT INTO ngp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nia kwanda na kupangana mwe wayahudi kwa mbuli ye yadya Yesu alongile. ");
INSERT INTO ngp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Awengi wawe niyo wagamba, “Uyu ana mp'hepo iihile naho mhezi! Mwamtegeleza wai?” ");
INSERT INTO ngp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Watuhu niyo wagamba, “Ulosi uwo hiyo wa mta mp'hepo iihile, haluse mp'hepo iihile yadaha kumtenda mnt'hu aone?” ");
INSERT INTO ngp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kudya Yelusalemu no kunda na zuwa dya kinyemi ya kukumbukila ukuki we nyumba ya Mnungu naho neinda ni mwe nyota. ");
INSERT INTO ngp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu andaga akagenda mwe nyumba ya Mnungu mwe ukumbi ya Sulemani. ");
INSERT INTO ngp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wayahudi niyo wamzunguluka wakamgamba, “Haluse noukigele nk'huswank'huswa mpaka ini? Uneva weye niwe Kilisito Mkombozi hake kigambile ikindedi.” ");
INSERT INTO ngp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu niyo awahitula, “Nehiwagambila mna nyuwe hamkunihuwila, ndima izi hudamanya kwa zina dya Tate niizo zikunilavila uwona. ");
INSERT INTO ngp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mna nyuwe hamkuunga hamkunihuwila Kwaviya hiyo ngoto zangu. ");
INSERT INTO ngp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Zigoto zangu zawiva mluzi wangu, miye hizimanya zoho nazo zanitimila. ");
INSERT INTO ngp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Miye name nazink'ha ugima wa ulo na ulo, nazo hezibanike, naho hahali mnt'hu akuunga azipokole kulawa mwe mikono yangu. ");
INSERT INTO ngp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tate anink'hile awant'hu awa ni mkulu kujink'ha wose. Naho hahali mnt'hu akudaha kuwaguha kulawa mwe mikono ya Tate. ");
INSERT INTO ngp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Miye na Tate ni kitu kimwenga.” ");
INSERT INTO ngp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wayahudi niyo walogota maiwe vituhu vileke wamtoe. ");
INSERT INTO ngp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu niyo awahitula, “Zindima zedi nyingi zikulawa kwa Tate hiwalagisani, mwe indima ihi mwe izo ikutenda mnitoe maiwe?” ");
INSERT INTO ngp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wayahudi niyo wamhitula, “Mwe zindima izedi hakikukutoa maiwe, mna kwe mbuli ya kumlonga vihile Mnungu, naho Kwaviya weye umnt'hu mna waketenda Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu niyo awahitula, “Togoleni haiwandikwe mwe miko yenyu kugamba, ‘miye hilonga nyuwe milungu?’ ");
INSERT INTO ngp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kimanya kugamba diya diwandikwe mwe Mawandiko Akukile nikindedi mazuwa yose, naho Mnungu kawetanga wadya want'hu milungu, want'hu wadya wenk'higwe ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Tate kanisagula miye naho kanisigila mwe isi, togoleni ivi mwadaha kugamba namhomole Kwaviya hilonga miye nuuyo Mwana ywa Mnungu? ");
INSERT INTO ngp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Uneva hikudamanya zindima za Tate zia akuunga nizidamanye, msekunihuwila. ");
INSERT INTO ngp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mna nnazidamanya uneva hamkunihuwila miye huwileni zindima, vileke mmanye Tate ekala mndani mwangu name nekala mndani mwa Tate.” ");
INSERT INTO ngp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Niyo wazungula naho kumgwila, mna niyo achupuluka mwe mikono yawe. ");
INSERT INTO ngp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Niyo akeitila gundi yo mto Yolodani mpaka hadya hant'hu Yohana andile akabatiza want'hu, niyo ekala uko. ");
INSERT INTO ngp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Want'hu wengi niyo wambasa wakagamba, “Yohana hadamanye kilagiso chochose mna yose ayalongile Yohana mwe milosi na yanda ya kindedi.” ");
INSERT INTO ngp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Niyo want'hu wengi hadya wamhuwila Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kuna mnt'hu akwitangwa Lazalo endile akekala Besania, mnt'hu uyu andaga mnyonge. Besania na winda mzi akwikala Maliamu na lumbudye Masa. ");
INSERT INTO ngp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliamu uyu ni yudya amhakile mavuta Zumbe, yo mhemp'he mwo mtwi wakwe nakumhangusa ne zifili zakwe. Mkuluwe akwitangwa Lazalo nie andaga mnyonye. ");
INSERT INTO ngp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Wadya walumbuze niyo wamwigaila ulosi Yesu, kugamba, Zumbe “mbuyayo Lazalo alumwa.” ");
INSERT INTO ngp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu eze eve mbuli ino niyo alonga, “Unyonge uno homtende Lazalo abanike, unyonge uno ulaila vileke Mnungu enk'higwe ukulu ino naitende Mwana wa Adamu ahokele ukukile.” ");
INSERT INTO ngp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu nakawaunga Masa na lumbudye hamwenga na Lazalo. ");
INSERT INTO ngp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu eze eve Lazalo mnyonge niyo enda ukudya endile kwa mazuwa matuhu maidi. ");
INSERT INTO ngp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Niyo awagamba wanamp'hina wakwe, “Kiteni zatu Yudeya.” ");
INSERT INTO ngp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wanamp'hina wakwe niyo wamhitula, “Mhinizi, mazuwa mageke yomboke Wayahudi kudya nawakaunga kukutowa maiwe naho waunga kuuya uko?” ");
INSERT INTO ngp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu niyo awahitula, “Msi hikugaa una masaa mlongo na maidi, naho mnt'hu anagenda mwe ungazi wa nomsi hakukehamiza Kwaviya kuna nulu. ");
INSERT INTO ngp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mna anagenda nekilo naagwe kwaviya kuna ziza.” ");
INSERT INTO ngp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu nakalonga ivi naho niyo ongezela, “Mbuyetu Lazalo kabanika mna nenite hamwinule.” ");
INSERT INTO ngp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wanamp'hina wakwe niyo wamhitula, “Zumbe uneva kagona mnyonge naahone.” ");
INSERT INTO ngp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mna Yesu na kanda na ivo vo kugamba kabanika, mna woho nawakagamba na kanda kabanika kagona. ");
INSERT INTO ngp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu niyo awagambila pwilili, “Lazalo kabanika.” ");
INSERT INTO ngp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mna miye nnakinyemi Kwaviya na kinda hakihamwenga na yehe vikuunga nyuwe mhuwile, haluseelo kiteni kwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi yudya akwitangwa pasa niyo awagambila wanamp'hina weyawe, “Kiteni chose hamwenga na mhinizi vileke kibanike hamwenga.” ");
INSERT INTO ngp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu eze abule niyo abwiila lazalo kabanika mwe mazuwa matatu yomboke. ");
INSERT INTO ngp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Besania na handa hagihi na Yelusalemu, enga maili zikubula nt'hatu, ");
INSERT INTO ngp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","naho wayahudi wengi na weza kuwasangalaza Masa hamwenga na Maliamu kwa mbuli ya file ya ndugu yawe. ");
INSERT INTO ngp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Masa eze eve Yesu keza niyo afosa kuse vileke wadugane, mna Maliamu niyo asigala kundani kwe nyumba. ");
INSERT INTO ngp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Masa niyo amgambila Yesu, “Zumbe, wandile aha mkulu ywangu hegu habanike! ");
INSERT INTO ngp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mna himanya Mnungu adaha akakwika dyodyose diya ukunga ulombeze hata ivi haluse.” ");
INSERT INTO ngp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu niyo amgammba, “nduguyo naauyuke.” ");
INSERT INTO ngp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Masa niyo amhitula, “Himanya naauyuke mwe zuwa dya uheelo.” ");
INSERT INTO ngp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu niyo amgamba, “Miye nuwo uyulo no ugima. Wose wakunihuwila, wakeza kubanika nawande wagima. ");
INSERT INTO ngp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Naho wose wakwikala na kunihuwila haweze wabanike. Weye wahuwila mbuli ino?” ");
INSERT INTO ngp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Niyo amhitula, “Heiye Zumbe!” “Nahuwila kugamba weye ni we Kilisito, Mwana Mnungu naakaungwa kwiza.” ");
INSERT INTO ngp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Masa eze ajike kulonga ayo auyaga niyo amwitanga Maliamu lumbudye kwa kinyele akamgamba, “Mhinizi e aha naho akuuza weye.” ");
INSERT INTO ngp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia eze eve niyo atenda nguvu aita kuse vileke akadugane naye. ");
INSERT INTO ngp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu na kanda akei kubula mwe kaya mna na kanda hant'hu abwiilane na Masa. ");
INSERT INTO ngp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Elo Wayahudi wandile hamwenga na Maliamu wakamhembeleza niyo wamtimila weze wamuwone atenda nguvu kwinuka na kwiita kuse. Nawakagamba aita kwe kikuta kwiila uko. ");
INSERT INTO ngp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliamu niyo abula hadya andaga Yesu, eze ambwiile niyo agwa mwe viga akamgamba, “Zumbe wandile aha ndugu yangu hegu habanike!” ");
INSERT INTO ngp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu niyo amkaula ivo andaga akaila, niyo akaula wadya Wayahudi wandile hamwenga na Maliamu ivo nawakaila. Yesu niyo engilwa ni mbazi mwo moyo wakwe. ");
INSERT INTO ngp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu niyo awauza, “Mummoselahi msanga?” Niyo wamhitula, “Zumbe so ukaule.” ");
INSERT INTO ngp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu niyo anyukumila. ");
INSERT INTO ngp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wayahudi niyo wagamba, “Kauleni ivo naakamuungisa.” ");
INSERT INTO ngp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Watuhu niyo wagamba, “Hikugamba awatendaga mant'hunt'hu waone, nii hamtendile Lazalo asekubanika?” ");
INSERT INTO ngp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu umwo andile akei na kinyulu mwo moyo abulaga he kikuta, iyo yandaga mp'hanga igubikwe na iwe mnanga mwo lwingiilo lwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu niyo awagamba. “Diuseni diiwe.” Masa lumbudye dya mto kubanika niyo amhitula, “Zumbe, anunk'ha kwaviya ana mazuwa mane kukongela aho eze abanike” ");
INSERT INTO ngp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu niyo amgamba, “Hikugambile una huwila nauone ukulu wa Mnungu?” ");
INSERT INTO ngp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Niyo wadihausa diiwe, Yesu niyo akaula kulanga niyo agamba, “Tate nakutogola kwaviya wanitegeleza. ");
INSERT INTO ngp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mna nalonga ivi kwa mbuli ya awa want'hu vileke wahuwile kugamba weye niwe uniletile.” ");
INSERT INTO ngp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eze ajink'he kulonga ivi niyo alonga kwa izwi kulu, “Lazalo, so kuse!” ");
INSERT INTO ngp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazalo niyo afosa kuse, mikono yakwe hamwenga na viga vikakigwa sanda, kihanga chakwe nacho kigubikwa kitambala. Yesu niyo awagamba, “Mhauseni isanda, naho mlekeni aite.” ");
INSERT INTO ngp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Elo Wayahudi wengi wezile kwa Maliamu niyo waiona mbuli idya Yesu adamanye, niyo wamhuwila. ");
INSERT INTO ngp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Watuhu niyo waita kwa Mafalisayo wakuwagambila ivo Yesu adamanye. ");
INSERT INTO ngp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wakulu wa walava nt'hambiko na Mafalisayo hamwenga na wakulu wose niyo wadugana ne kitala chose wakagamba, “Kitende vivihi haluse? Kauleni vihungi ivo akudamanya!” ");
INSERT INTO ngp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Uneva kinamleka agendeele na ivi akudamanya, want'hu nawamhuwile naho Walumi naweze niyo wabananga nyumba ya Mnungu hamwenga na kukikaila. ");
INSERT INTO ngp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yumwenga ywawe andaga aketangwa Kayafa andaga mkulu wa walava nt'hambiko mwo mwaka udya niyo awagamba, “Nii mwanda wahezi! ");
INSERT INTO ngp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Haluse hammanyize nevinde vedi mnt'hu yumwenga abanike kwa mbuli ya want'hu wengi kujink'ha kuleka isi ngima ikabanika?” ");
INSERT INTO ngp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ikindedi halongile ivi kwa mbuli yakwe yehe mwenye, mna kwa kunda mlava nt'hambiko mkulu mwaka udya, naakalotela ukubanika kwa Yesu naafe kwa ajili ya Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Naho hiyo kwa woho du Mna kuwaduganya hamwenga mo umwili umwenga want'hu wose wa Mnungu wasaguke. ");
INSERT INTO ngp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kutimila zuwa diya, Wayahudi niyo wazungula sila ya kumkoma Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yesu hagendaga akaoneka mwa Wayahudi. Ahalawaga niyo aita hant'hu hagihi ne dijangwa ko mzi ukwitangwa Efulaimu ukwo ekalaga hamwenga na wanamp'hina wakwe. ");
INSERT INTO ngp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wila wa Wayahudi wa Pasaka wandaga hagihi. Want'hu wakwelaga kulawa kwe zink'honde zawe kwiita Yelusalemu, vileke wakekukize kwaviya na wakeika lumwe kwa Pasaka. ");
INSERT INTO ngp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Niyo wamzungula Yesu. Umwo weze wadugane mwe nyumba ya kumvika Mnungu, niyo wakonga kuuzana woho kwa woho, “Wafanyanya mbwai? Kigambe haeze mwe zuwa dya kinyemi!” ");
INSERT INTO ngp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wakulu wa walava nt'hambiko hamwenga na Mafalisayo nawasigila kugamba uneva kuna mnt'hu yeyose avile uko Yesu eli alonge vileke wamgwile. ");
INSERT INTO ngp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mazuwa sita kubula mwe zuwa dya Pasaka Yesu niyo aita Besania kaya kwa Lazalo yudya Yesu amuuyula kulawa kwe file. ");
INSERT INTO ngp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Niyo wamwambikila nk'hande ya nomsi, Masa niyo amdamanyila ndima. Lazalo na kanda yumwenga ya wadya wekale hamwenga na Yesu ");
INSERT INTO ngp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Niyo Maliamu aguha nusu lita ya mavuta ya mhemp'he, amhake mavuta ayo Yesu mwe viga, naho niyo amhangusa ne zifili zakwe. Niyo idya inyumba yose yanda na mhemp'he wedi. ");
INSERT INTO ngp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yumwenga mwe wanamp'hina wa Yesu akwitangwa Yuda Isikaliyote, Yudya akuunga eze amsezenge niyo agamba, ");
INSERT INTO ngp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nii mavuta yano yedi yasekutagwa kwa matundu mengi naho niyo wenk'higwa want'hu haweena kint'hu?” ");
INSERT INTO ngp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nakalonga ivi naho hiyo Kwaviya naakawaungisa want'hu haweena kint'hu, mna Kwaviya na kanda mbavi naho yehe niye naakatoza umkoba wandile na matundu. ");
INSERT INTO ngp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mna Yesu niyo alonga, “Mlekeni! Adamanya ivi kwa mbuli ye maziko yangu. ");
INSERT INTO ngp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mazuwa yose mnanao want'hu haweena kint'hu mna homnde na miye mazuwa yose.” ");
INSERT INTO ngp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wayahudi wengi niyo weva kugamba Yesu emwo mzi wa Besania niyo waita kudya andile naho hiyo Kwaviya Yesu na kanda kudya, mna uleke wakamkaule Lazalo, yudya Yesu amuuyule mwe file. ");
INSERT INTO ngp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Naho niyo wakulu wa walava nt'hambiko wazungula sila vileke wamkome Lazalo, ");
INSERT INTO ngp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kwaviya mbuli idya neikatenda Wayahudi wengi kuwalemela woho nakumhuwila Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Zuwa dya kaidi want'hu wengi wezile mwe wila ye Pasaka niyo weva kugamba Yesu keza Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Niyo waguha matambi ye mitende nakugenda kumsingiila, kwa izwi nawakagamba, “Zumbe atogolwe, Mnungu amwink'he uvikilwa yudya akwiza kwa zina dya Zumbe, Mnungu amwink'he uvikilwa Zumbe we Izilaeli.” ");
INSERT INTO ngp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu niyo akwela mp'hunda enga viya iwandikwe, ");
INSERT INTO ngp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mzi wa Sayuni usekogoha Zumbe ywako eza akweile mwana mp'hunda.” ");
INSERT INTO ngp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wanamp'hina wakwe hawabunk'hule imbuli idya, mna Yesu eze atogolwe niyo wabunk'hula viya iwandikwe. ");
INSERT INTO ngp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Want'hu wandile na Yesu hadya amwitange Lazalo kulawa mwe kikuta na kunda mgima niyo wasimwila viya vilaile. ");
INSERT INTO ngp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ivo niivo valekaga want'hu wengi wakamwizila kwaviya na weva ivilagiso ve vihungi viya adamanye. ");
INSERT INTO ngp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafalisayo niyo wagambilana, “Kauleni ivo kikudunguga naho ulumwengu mgima wamtimila Yehe!” ");
INSERT INTO ngp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mwe wadya want'hu wezile Yelusalemu mwe zuwa dya kinyemi watuhu nawanda Wagiliki. ");
INSERT INTO ngp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Niyo waita kwa Filipo, mnt'hu wa Betisaida mwe isi ya Galilaya wamgamba, “Zumbe, chaunga kimwone Yesu.” ");
INSERT INTO ngp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo niyo agenda kumgambila Anduleya, wose waidi niyo waita wakumgambila Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu niyo awahitula, “Isa ibula Mwana wa Mnt'hu akuunga atogolwe. ");
INSERT INTO ngp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nawagambilani ikindedi, mp'huluzi ye uhemba neisigale iivo imwenga hainahandigwe mwe ulongo niyo yafa. Uneva inabanika neyeleke mp'huluzi nyingi. ");
INSERT INTO ngp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wadya wakuuunga wikazi wawe nawazaganye na wadya hewekuunga wikazi wawe mwe ino isi nawawiike kwa mbuli ya wikazi wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yudya akuunga kunidamanyila ndima miye naanitongele Kwaviya hadya huunga ninde mtumwa ywangu naande naye aho. Naho yudya akuunga anidamanyile ndima Tate naamwink'he ukulu.” ");
INSERT INTO ngp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Haluse moyo wangu una kinyulu, haluse nigeeze? ‘Tate niyokole mwo lupisi ulu lukunizila.’ Mna iyo nivo vilekile miye heza vileke nombokele mwo lupisi ulo lwa masulumizo. ");
INSERT INTO ngp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tate, uketogole dizina dyako.” Niyo Izwi dyevika kulawa kwo ulanga, “Hiketogola kale naho neniketogole naho.” ");
INSERT INTO ngp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Fyo dya want'hu wandile hadya niyo weva diya izwi, watuhu niyo walonga, “Neinda mtint'hilo naho watuhu niyo wagamba na kanda mtumigwa ywa kwe Mbingu alongile.” ");
INSERT INTO ngp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mna Yesu niyo awagambila, “Izwi idi hadivike kwa mbuli yangu miye mna kwa mbuli ya nyuwe. ");
INSERT INTO ngp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Naho uno nuwo umuda wa ino isi kusengelwa, naho Mwavu mkulu we isi ino, naadulwe. ");
INSERT INTO ngp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Umwo nnenulwa kulawa hasi, neniwaguhe want'hu wose kwangu.” ");
INSERT INTO ngp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mwo kulonga ivi, naakalongela ifile yakwe. ");
INSERT INTO ngp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Fyo dya want'hu niyo wamhitula, “Miko yakigambila Kilisito neekale mazuwa yose, nii weye naho wakigamba Mwana wa Mnt'hu neenulwe kulanga? Uyu Mwana ywo Mnt'hu ni yuhi?” ");
INSERT INTO ngp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu niyo awahitula, “Ung'azi nounde na nyuwe kwa mda mguhi, gendeleeni Kwaviya mna ung'azi, ziza dinase kuwahumani, kwaviya yudya akugenda mwe diziza hamanyize kudya akwiita. ");
INSERT INTO ngp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kwaviya mnanao ung'azi uhuwileni, vileke mnde want'hu wo ung'azi. Yesu eze ajink'he kulonga ivi niyo ahalawa na kugenda kukefisa.” ");
INSERT INTO ngp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hamwenga nakugamba Yesu nakadamanya vilagiso mwa meso yawe mna woho hawahuwile. ");
INSERT INTO ngp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ivo niyo viya valongagwa ni Mlotezi Isaya vakelaviliza. “Zumbe, ni ani akuhuwila mbuli kikulonga? Ni kwa ani udahi wa Mnungu ukunga ukelavilize?” ");
INSERT INTO ngp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Naho nawenda hawakuunga kuhuwila, Kwaviya Mlotezi Isaya nakalonga naho, ");
INSERT INTO ngp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mnungu kawagela u nt'hunt'hu ameso yawe, hamwenga na kuitenda mioyo yawe inde midala, wanase wakanihitukila vileke niwahonye. Naho mioyo yawe inase ikakombaganya, wanase wakanihitukila, vileke miye niwahonye,” ");
INSERT INTO ngp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya nakalonga ivi Kwaviya nakauona ukulu wakwe Yesu na kuzilonga zimbuli zakwe. ");
INSERT INTO ngp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Naho mwe wakulu we Wayahudi nomnda na watuhu wengi wandile wakamhuwila Yesu, mna kwa ajili ye Mafalisayo nawanda hawakulonga imbuli ino mwe kiyeti wanase wakaguluswa kulawa mwe nyumba ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kwaviya nawakaungisa kwink'higwa ukulu na want'hu kujink'ha ikwink'higwa ukulu na Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu niyo alonga kwa kubongeela, “Yudya akunihuwila miye hiyo anihuwila miye du, mna amhuwila na yudya aniletile. ");
INSERT INTO ngp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yudya anione miye kamuwona hata yudya aniletile. ");
INSERT INTO ngp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Hiza mwe Isi ninde ung'azi vileke yudya akunihuwila miye asekwingila mwo lwiza. ");
INSERT INTO ngp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yudya akwiva ulosi wangu niyo hakuutimila hikumsengela, miye hizile kwa mbuli ya kuwasengela want'hu wa isi mna kuwahonya. ");
INSERT INTO ngp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wadya wakunilemela miye hamwenga na ulosi wangu eyuko yumwenga akuunga awasengele. Ulosi udya nilongile nuwo ukuunga uwasengele mwe dizuwa dya uheelo. ");
INSERT INTO ngp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iki ni kindedi kwaviya hilongile kwa udahi wangu miye mwenye mna Tate yudya aniletile miye nie anisigiile yo kulonga. ");
INSERT INTO ngp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Naho himanya miko yakwe zenk'hiza ugima wa ulo na ulo, yadya nilongile ni yadya Tate akisigiile miye nilonge.” ");
INSERT INTO ngp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Neinda disigala zuwa dimwenga kubula zuwa dya Pasaka. Yesu nakamanya isa yakwe ibula ya kuhalawa mwe isi na kuita kwa Ise. Naho naakawaunga wadya wandile wakwe mwe isi. Mazuwa yose naakawaunga. ");
INSERT INTO ngp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu na wanamp'hina wakwe nawanda mwe nk'hande ya nekilo. Mwavu nakamwingila kale Yuda mwana wa Simoni Isikaliyote mo umoyo uleke amsezenge Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu nakamanya kugamba Tate kaika kila kint'hu mwo udahi wakwe. Nakamanya keza kulawa kwa Mnungu naho naauye uko kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Niyo akimaala hadya andile niyo aita kunk'handa no kuhambula isuke yakwe yandile mnanga mwe kitambala kituhu, niyo akekaka mwe kigudi. ");
INSERT INTO ngp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yesu niyo agela mazi mwe dikalai, no kukonga kuwasunt'ha wanamp'hina wakwe iviga hamwenga na kuwahangusa na kitambala chandile mwe kigudi. ");
INSERT INTO ngp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Niyo abula kwa Simoni Petulo, mna Simoni niyo amuuza, “Zumbe, weye unisunt'he iviga vangu?” ");
INSERT INTO ngp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu niyo amhitula, “Haukudaha kukombaganya ivi haluse imbuli ino hudamanya, mna nouwize ubunk'hule mwa mazuwa yakwiza.” ");
INSERT INTO ngp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulo niyo amgambila Yesu, “Weye hukudaha kunisunt'ha miye iviga vangu.” Yesu niyo amhitula, “Hinakusunt'hile iviga vako, hukudaha kunda mwanamp'hina ywangu.” ");
INSERT INTO ngp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulo niyo amhitula, “Zumbe usekunisunt'ha iviga vangu du mna hata mikono hamwenga no mtwi wangu.” ");
INSERT INTO ngp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu niyo agamba, “Ahakile kale hakuungwa kuhaka umwili mna ahaka iviga du. Kwaviya kasunt'hika kale umwili wakwe. Nyuwe msunt'hika mna hiyo wose.” ");
INSERT INTO ngp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu nakamanya yudya akuunga amsezenge nivo vilekile akalonga, “Hiyo wose msunt'hike.” ");
INSERT INTO ngp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yeu eze ajinke kuwasunt'ha iviga vawe niyo avala idya isuke yakwe na kuuya hadya hant'hu hakwe andile nakekala no na kuwauza wanamp'hina wakwe, “Togoleni, mwakombaganya ayo nimidamanyileni?” ");
INSERT INTO ngp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Mwanitanga miye Mhinizi hamwenga na Zumbe, naho mwadamanya vedi ivo mkudamanya, kwaviya ivo niivo nili. ");
INSERT INTO ngp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Miye ni Zumbe na Mhinizi ywenyu naho hiwasunt'ha iviga vyenyu nyuwe nanywe mwaungwa msunt'hane iviga. ");
INSERT INTO ngp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Hidamanya mliganyizo vileke nyuwe nanywe mdamanye enga viya miye niwa damanyileni. ");
INSERT INTO ngp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Namigambilani ikindedi, mtumwa hiyo mkulu kujink'ha zumbe ywakwe, naho mwigala ulosi hiyo mkulu kujink'ha yudya amwigale. ");
INSERT INTO ngp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Naho ivo mmanyize kindedi neinde vedi mdamanye enga ivo mmanyize. ");
INSERT INTO ngp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Hikulonga kwa nyuwe nyose, hiwamanya wadya niwasagule, mna vileke yadya yawandikwe yakint'he, kugamba, ‘Yumwenga kikudya hamwenga kanihituka no kunitendela vihile!’ ");
INSERT INTO ngp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Namigambilani, mbuli ino ikei kulaila vileke inalaila mhuwile kugamba, ‘Miye ni Yehe.’ ");
INSERT INTO ngp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nawagambilani kindedi, yudya akumhokela yudya ni mwigale anihokela miye, na akunihokela miye amhokela yudya anigale miye.” ");
INSERT INTO ngp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu eze ajink'he kulonga ivi, niyo abanika mnyunk'humilo mo umoyo wakwe. Niyo awagamba, “Namigambilani ikindedi yumwenga ywenyu naanisezenge.” ");
INSERT INTO ngp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wanamp'hina wakwe niyo wakaulana woho wenye, wakauzana uyo akulongigwa ni ani? ");
INSERT INTO ngp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mwanamp'hina yumwenga, yudya naakaungiswa na Yesu nakeekala hagihi na Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petulo niyo amhungila mkono akamgamba, “Muuze Zumbe uyo akulongigwa ni ani?” ");
INSERT INTO ngp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Niyo yudya mwanamp'hina asogelesa hagihi na Yesu na kumuuza, “Zumbe, mnt'hu uyo ni ani?” ");
INSERT INTO ngp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu niyo amhitula, “Uyo huunga nchank'hize mkate mwe kaziga, na kumwink'ha ni yehe.” Niyo aguha kabesu ko mkate na kukachank'hiza mwe kaziga na kumwink'ha Yuda mwana Simoni Isikaliyote. ");
INSERT INTO ngp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda eze ajink'he kuudya udya mkate Mwavu niyo amwingila. Yesu naye niyo amgamba, “Tenda nguvu idyo ukudamanya.” ");
INSERT INTO ngp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Naho hahali hata mnt'hu yumwenga akombaganye, nii Yesu nakalonga viya kwa Yuda. ");
INSERT INTO ngp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwaviya Yuda andaga akatoza mkoba wa matundu, wanamp'hina watuhu nawakafanyanya kugamba Yesu nakamsigila aite kokuguha vint'hu nevikaungigwa kwa mbuli ye zuwa dya kinyemi ye Pasaka hegu kuwenk'ha wakiwa. ");
INSERT INTO ngp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda niyo ahokela umkate nakufosa kuse, naho neinda nekilo. ");
INSERT INTO ngp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda eze afose Yesu niyo agamba, “Haluse elo Mwana ywa Mnungu katogolwa na Mnungu Katogolwa mndani mwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Uneva ukulu wa Mnungu ugubulwa mndani mwo Mwana, Ivo Mnungu na alagise ukulu wo Mwana mndani mwakwe mwenye Naho naatende ivo nguzu. ");
INSERT INTO ngp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wana wangu, heninde na nyuwe lupisi lutali mna nomnizungule, nawagambila viya niwagambile wakulu wa Wayahudi, ‘Hamkudaha kuita kudya huunga nite miye.’ ");
INSERT INTO ngp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Naho ivi haluse nawenk'hani sigilizi mp'hya, ‘Muungane enga viya miye niwaungile, kila yumwenga amuunge miyawe.’ ");
INSERT INTO ngp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mnaungana, kila yumwenga naamanye kugamba muwanamp'hina wangu.” ");
INSERT INTO ngp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulo niyo amuuza Yesu, “Zumbe waitahi?” Yesu amhitula, “Uko huita hukudaha kunitimila haluse, mna nowize unitimile.” ");
INSERT INTO ngp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulo niyo amuuza, “Zumbe, nii hikudaha kukutimila ivi haluse, miye nadaha kubanika kwa mbuli yako weye.” ");
INSERT INTO ngp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu niyo amhitula, “Kindedi weye wadaha kubanika kwa mbuli yangu miye? Nakugambila ikindedi, iviya zogolo dikei kuila, diyelo naulonge nk'hanana nt'hatu kugamba hunimanyize!” ");
INSERT INTO ngp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu niyo awagamba wanamp'hina wakwe, “Msekogoha, mwamhuwila Mnungu, nihuwileni miye name. ");
INSERT INTO ngp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mwe nyumba ya Tate, mna wikazi mwingi, naho miye nagenda kuwaikilani lumwe hant'hu ho kwikala, vandile hiyo ivo hegu nehimigambilani. ");
INSERT INTO ngp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nnaita nnajika kumiikilani lumwe, nenize niwaguheni vileke mnde hadya huunga ninde miye. ");
INSERT INTO ngp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Naho muimanya isila idya ikuita kudya huunga niite.” ");
INSERT INTO ngp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi niyo amgamba Yesu, “Zumbe hakimanyize kudya ukuita haluse nekimanye vivihi isila ikuunga ikibuze uko?” ");
INSERT INTO ngp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu niyo amhitula, “Ni miye sila ne ikindedi, no ugima, Hahali akuunga aite kwa Tate hanombokele kwangu.” ");
INSERT INTO ngp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yesu niyo awagamba, “Kwaviya mnimanya miye nomumanye Tate naye, naho kukongela ivi haluse mummanya Tate naho mmuona.” ");
INSERT INTO ngp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo niyo amgamba, “Zumbe, suwe icho kikuunga ukilagise Tate.” ");
INSERT INTO ngp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu niyo amhitula, “Filipo kwa lupisi lutali nehinda na nyuwe nyose, mna hamnimanyize? Anione miye, kamuona Tate. Nii naho mwanigamba, ‘Kilagise Tate?’ ");
INSERT INTO ngp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filipo, mkei hamkuhuwila kugamba miye nimndani mwa Tate, na Tate naye emndani mwangu? Ulosi humigambilani haukulawa kwangu” mna Tate emndani mwangu nie akudamanya izindima. ");
INSERT INTO ngp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Huileni viya hulonga kugamba, Tate emndani mwangu miye name ni mndani mwakwe. Uneva hukuhuwila idyo huwila ziya zindima hudamanya. ");
INSERT INTO ngp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Namigambilani ikindedi, wadya wakunihuwila nawadamanye yadya hudamanya miye, kindedi, naho nawadamanye mbuli zikujink'ha izi, kwaviya miye naita kwa Tate. ");
INSERT INTO ngp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Naho nenidamanye chochose kiya mkuunga kwa zina dyangu, vileke ukulu wa Mnungu uoneke kombokela kwa Mwanawe. ");
INSERT INTO ngp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mnalombeza chochose kwa zina dyangu, neniwadamanyileni. ");
INSERT INTO ngp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mnaniunga miye, nomyatoze yadya huwasigiilani. ");
INSERT INTO ngp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nenimlombeze Tate naho naawenk'heni mwambizi mtuhu akuunga ekale na nyuwe ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yehe ni Muye akulonga ikindedi cha Mnungu. Want'hu wa mwe isi hawakudaha kumhokela Kwaviya hawakudaha kumuwona naho hawammanyize. Mna nyuwe mummanya Kwaviya ekala na nyuwe naho e mndani mwenyu. ");
INSERT INTO ngp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ninaita, hamkudaha kusigala nyuwe wenye, neniwaamileni naho. ");
INSERT INTO ngp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mwe lupisi mgeke ukwiza want'hu wa mwe Isi hawakudaha kuniyona naho vituhu, mna nyuwe namnione, naho Kwaviya ni mgima hata nyuwe na mwinde wagima. ");
INSERT INTO ngp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Zuwa idyo dinabula, nammanye kugamba miye nimndani mwa Tati ywangu naho na nyuwe mndani mwangu, enga viya miye nendile mndani mwenyu. ");
INSERT INTO ngp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Wadya wakutimila miko yangu nakuitimila, awo nawo wakuniunga. Tate yangu naawabwede wadya wakuniunga miye, hata miye neniwabwede nakukelaviliza kwa woho.” ");
INSERT INTO ngp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda, Mna hiyo Yuda Isikaliyote niyo amgambila Yesu, “Zumbe, nainde vivihi kwa weye kukelaviliza kwa suwe naho hiyo kwa want'hu wamwe Isi?” ");
INSERT INTO ngp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu niyo amhitula, “Yudya akuniunga naayazumile mahinyo yangu, Tate naambwede, naho miye hamwenga na Tate nakize kwakwe nakwikala kwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yudya hakuniunga miye, hakuyazumila mahinizo yangu, naho mahinizo myevile hiyo yangu, mna yeza kulawa kwa Tate yudya aniletile miye mwe ino Isi. ");
INSERT INTO ngp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Himigambilani ivi, Kwaviya nikei nili na nyuwe. ");
INSERT INTO ngp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mwambizi, Muye ywa Mnungu, Yudya Tate akuunga amwigale kombokela dizina dyangu, naawahinizize nyuwe kila kint'hu, naho naawakumbuseni nyuwe mbuli zose niwahinizizeni. ");
INSERT INTO ngp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Utondowazi namwasilani nyuwe, utondowazi wangu nawenk'kani. Hikuwenk'hani enga viya isi ikuwenk'ha. Msekogoha naho msekunda na kinyulu. ");
INSERT INTO ngp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na mwiva miye himigambilani, ‘Namwasani mna nenize naho vituhu.’ Uneva namniunga namuunga kugamba miye naita kwa Tate, Kwaviya yehe ni mkulu kujink'ha miye. ");
INSERT INTO ngp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Himigambilani mbuli izi zikanda zikei kulaila, vileke yanalaila nyuwe mhuwile. ");
INSERT INTO ngp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Hikudaha kugendeela kulonga na nyuwe, Kwaviya yudya akulongoza ino isi eza. Hana udahi kunijika miye, ");
INSERT INTO ngp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mna si zose zaungwa zimanye kugamba namuunga Tate, ivo nivo vilekile nadamanya kila kint'hu kiya akunigamba nidamanye. “Soni! Kihalaweni aha hant'hu. ");
INSERT INTO ngp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Miye nie mzabibu we kindedi, naho Tate yehe niye mkulima. ");
INSERT INTO ngp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tambi hedikweleka adihausa mwangu, naho ayahogowela vedi matambi yadya yakweleka vedi, vileke yande hang'aile yelekese. ");
INSERT INTO ngp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nyuwe msunt'higwa kale kwaviya yo ulosi udya niwek'heni. ");
INSERT INTO ngp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ikaleni mndani mwangu, name nenikale mndani mwenyu. Tambi hadikudaha kweleka dikanda ikedu, mna dyadaha dikeleka dinanda mwo mzabibu, enga iivo hamkudaha kweleka hamnekale mndani mwangu. ");
INSERT INTO ngp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ni miye mzabibu nyuwe nanywe mwi matambi. Wadya wakwikala mndani mwangu, miye name mndani mwawe, nawelekese, kwaviya hamkudaha kudamanya dyodyose hamnandile na miye. ");
INSERT INTO ngp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mnt'hu hanekale mndani mwangu naadulwe kuse enga tambi, niyo dya nyala, matambi ayo yaduganywe hamwenga nakugeligwa mwo moto vileke yahye. ");
INSERT INTO ngp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mnekala mndani mwangu niyo ulosi wangu wekala mndani mwenyu, lombezeni chochose mkuunga, nanywe nomwink'higwe. ");
INSERT INTO ngp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nyuwe mna damanya mbuli zedi Tate naatogolwe, naivo nemanyike kindedi kugamba mwi wanamp'hina wangu. ");
INSERT INTO ngp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Miye nawaunga enga viya Tate akuniunga miye. ");
INSERT INTO ngp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mnazumila miko yangu namwikale mwe lukunde lwangu, enga viya miye nizumile miko ya Tate ywangu nakwikala mwe lukunde lwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Himigambilani ivi vileke ikinyemi changu kinde mndani mwenyu na kinyemi changu kikint'he ");
INSERT INTO ngp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sigilizi yangu ni ino. Muungane enga viya miye niwaungile nyuwe. ");
INSERT INTO ngp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lukunde lutendese mnt'hu ananawo ni udya ukulava ugima wakwe kwa wambuya zakwe. ");
INSERT INTO ngp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nyuwe mwinde wambuya zangu Mkudamanya yadya huwagamba. ");
INSERT INTO ngp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Miye hikuwetangeni naho nyuwe wandima, Kwaviya mtumwa hamanyize yadya akudamanya Zumbe wakwe, mna nawetanga wambuya Kwaviya hiwagambilani kila kint'hu nikivile kulawa kwa Tate. ");
INSERT INTO ngp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nyuwe hamnisagule miye, mna miye himisaguleni nyuwe nakuwasigilani mwite na kweleka matunda yakuunga yekale. Naho Tate naawenk'he kint'hu chochose kiya mkunga kombokela dizina dyangu. ");
INSERT INTO ngp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Vino niivo humigambilani, Muungane kila yumwenga na mnyawe. ");
INSERT INTO ngp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Uneva want'hu wanawaihiyeni mmanye kugamba nawakonga kuniihiwa miye. ");
INSERT INTO ngp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Uneva nyuwe ni wa ino isi, want'hu we isi hegu nawawaunga kwaviya ni wa ino isi. Mna himisaguleni nyuwe kulawa mwe ino isi, icho niicho kilekile want'hu wakawaihiya. ");
INSERT INTO ngp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbukileni viya nimigambileni, wandima hiyo wakulu kujink'ha Zumbe wawe, uneva want'hu nawanisulumiza miye hata nyuwe nawawasulumizeni, uneva nawatimila mahinizo yangu nawatimile ya kwenyu. ");
INSERT INTO ngp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mna nawawadamanyizile mbuli zose izi Kwaviya nyuwe ni wa kwangu miye, Kwaviya hawammanyize yudya akisigiile miye nize. ");
INSERT INTO ngp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Uneva hezile na kulonga nawo hawandile na wiihi enga ivi haluse kwaviya hawana dyodyose wakudaha kukegombela. ");
INSERT INTO ngp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mnt'hu akuunga aniihiye miye amwihiya Tate. ");
INSERT INTO ngp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Uneva hidamanye mbuli izo niwadamanyizile, naho hahali mnt'hu yeyose akudaha kudamanya nawende hawana masa yo wiihi, mnawaona ivo miye nidamanye niyo wani ihiya miye hamwenga na Tate. ");
INSERT INTO ngp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mna ino ilaila vileke imbuli iwandikwe mwo Mwiko ikilavilize, ‘Nawaniihiya haheina chotoko chochose.’ ");
INSERT INTO ngp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mwambizi neeze, Muye akuunga alavilize ikindedi cha Mnungu, yehe akulawa kwa Tate. Muye ywe kindedi naalonge uwona mwa miye. ");
INSERT INTO ngp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Naho hata nyuwe namlonge mbuli zangu kwaviya mwandaga na miye kukongela aho nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nahiwagambileni vileke mnasemkaileka imani yenyu. ");
INSERT INTO ngp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Namguluswe mwe zinyumba za kumvikila Mnungu, naho lupisi naubuze, want'hu nawamanye kugamba yudya akuwakoma nyuwe naende mwe kudamanya Ibada kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Want'hu nawawadamanyizileni vint'hu ivi Kwaviya hawammanyize Tate. ");
INSERT INTO ngp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mna himigambilani ivi vileke umuda unabula wa woho kudamanya ivi, nakumbukile ivo miye niwagambileni. “Aho nk'hongo himigambilani ivi Kwaviya na hinda hamwenga na nyuwe. ");
INSERT INTO ngp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mna ivi haluse naita kwa yudya aniletile, mna hahali hata yumwenga akunuuza uko hwiita. ");
INSERT INTO ngp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mna Kwaviya himigambilani imioyo yenyu inda na kinyulu. ");
INSERT INTO ngp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mna nawagambilani ikindedi, na inde vedi kwa nyuwe uneva nnaita Kwaviya hinaitile mwambizi heeze kwenyu, mna nnaita naho waleteleni umwambizi. ");
INSERT INTO ngp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aho aneza naawa lavanyile want'hu we isi ino kugamba hawe mwe kindedi mwe mbuli yo wavu hamwenga na mbuli zo kwelela na usengelo wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mwe imbuli yo wavu waga Kwaviya hawakunihuwila miye. ");
INSERT INTO ngp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mwe mbuli ye ikindedi waga Kwaviya naita kwa Tate naho hamnione, ");
INSERT INTO ngp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Naho waga mwe imbuli ye usengelo Kwaviya mkulu we isi ino kasengelwa kale. ");
INSERT INTO ngp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nnanazo mbuli nyingi zakuwagambila mna ivi haluse homdahe kuyafinyiliza. ");
INSERT INTO ngp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Muye aneza akuunga alavilize ikindedi cha Mnungu naawaigale mwe kindedi, haalonge zimbuli zakwe yehe mwenye mna naalonge zimbuli ziya akutegeleza, naho naawagambileni mbuli ziya zikwiiza. ");
INSERT INTO ngp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yehe eze anitogole miye Kwaviya naaguhe yadya miye hulonga nakuwagambilani nyuwe. ");
INSERT INTO ngp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yose ananayo Tate ni yangu miye ivo nivo vilekile miye halonga, Muye naaguhe ya kwangu miye nakuwagambilani nyuwe. ");
INSERT INTO ngp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Mwe lupisi mdodo ukwiza hamnione, naho mwe lupisi mdodo ukwiza namnione vituhu” ");
INSERT INTO ngp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wanamp'hina wakwe niyo wauzana woho wenye, “Ino ina maana yani? Kakigambila kugamba, mwe lupisi mdodo ukwiza hakimuwone naho, vituhu mwe lupisi mdoodo ukwiza nakimuwone, naho kalonga, ‘Kwaviya naita kwa Tate.’ ");
INSERT INTO ngp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Na kanda na maana yani viya akalonga, ‘Lupisi mdodo?’ Hakimanyize idyo akulonga.” ");
INSERT INTO ngp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu na kamanya kugamba waunga wamuuze niyo awagamba, “Hilonga, ‘Mwe lupisi kidodo hamnione, naho mwe lupisi mdodo namnione.’ Mbuli ino niyo mkukiuza nyuwe wenye? ");
INSERT INTO ngp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Namigambilani ikindedi, na mwiile na kwiila, mna want'hu wa isi na wande na kinyemi. Na minde na kiholozi mna ikiholozi chenyu na kihituke kunda kinyemi. ");
INSERT INTO ngp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mvele ananda haguhi a kweleka, anda na kinyulu kwaviya lupisi lwakwe lwe masulumizo lubula, mna uneva mwana anelekwa ajala amasulumizo yose, kwaviya ana kinyemi kwa mwana elekwa mwe isi. ");
INSERT INTO ngp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ivo niivo mnanavo nyuwe. Ivi haluse mna kinyulu, mna nakaona naho vituhu mioyo yenyu imemile kinyemi. Ikinyemi icho hahali mnt'hu akuunga awahoke. ");
INSERT INTO ngp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mwa dizuwa idyo, homniuze kint'hu chochose. Nawagambilani ikindedi, Tate naawenk'he chochose mlombeza kwa zina dyangu. ");
INSERT INTO ngp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kubula ivi haluse mkei kulombeza kint'hu chochose kwa dizina dyangu, lombezeni naho nomhokele vileke ikinyemi chenyu kikint'he. ");
INSERT INTO ngp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Hilonga kwa miliganyizo kuwagambilani zimbuli izi, mna lupisi nolubule henilonge naho kwa miliganyizo. Mna nenilonge pwilili mwe mbuli ya Tate. ");
INSERT INTO ngp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mwe dizuwa idyo, nomlombeze kwa zina dyangu. Naho hikuwagambilani kugamba, neniwalombezeleni, ");
INSERT INTO ngp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kwaviya Tate mwenye awaungani. Awaunga kwaviya nyuwe nanywe mwaniungaga, naho mhuwila kugamba hiza kulawa kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Hiza kulawa kwa Tate naho hiza kwe isi, naho ivi haluse nahalawa mwe isi naita kwa Tate.” ");
INSERT INTO ngp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Niyo wanamp'hina wakwe wamgamba, “Ivi haluse walonga haheina kifiso, naho hiyo kwa miliganyizo. ");
INSERT INTO ngp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kimanya ivi haluse kugamba wamanya kila kint'hu. Hukuunga mnt'hu akuuze mbuli. Kwa ivi cha huwila kugamba kulawa kwa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu niyo awahitula, “Haluse mwahuwila? ");
INSERT INTO ngp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lupisi lweza naho lubula, hadya nyuwe nyose nomsambale kila yumwenga naaite kwe kaya naho nomnase nikedu. Mna miye hikedu kwaviya Tate e hamwenga na miye. ");
INSERT INTO ngp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Himigambileni ivi vileke mnde na utondowazi mwa miye mani kwa kunda mlunganyika hamwenga na miye. Mwe si mna makunt'ho, mna keink'heni moyo miye hiihuma si.” ");
INSERT INTO ngp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu eze abinde ukulonga yano niyo akaula kulanga na kulonga, “Tate udya lupisi ubula, Mtogole mwanao ulehe yehe naye akutogole. ");
INSERT INTO ngp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwaviya nakumwink'ha mwanao udahi mwa want'hu wose, vileke awenk'he ugima wa ulo na ulo wadya wose umwink'hile. ");
INSERT INTO ngp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na ugima wa ulo na ulo ni uno, kukumanya wenye we ekedu Mnungu wa kindedi hamwenga na Yesu Kilisito umsigile. ");
INSERT INTO ngp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Miye hikutogola hano he isi, naho hiibindiliza idya ndima unink'hile niidamanye. ");
INSERT INTO ngp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Haluse Tate, unink'he ukulu udya nandile nao aho isi ikei kuumbigwa. ");
INSERT INTO ngp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Hikutenda umanyike kwa wadya want'hu unink'hile kulawa kwe isi, nawanda want'hu wako ni weye wanink'ha wande want'hu wangu nawo wauzumila ulosi wako. ");
INSERT INTO ngp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Haluse wamanya kugamba kila kiya unink'hile kilawa kwako. ");
INSERT INTO ngp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Miye hiwenk'ha udya ulosi unink'hile, woho nao wauhokela naho wamanya kindedi kugamba ulawa kwako hamwenga na kuzumila kugamba kindedi hilawa kwako naho weye niye unisigile. ");
INSERT INTO ngp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nawalombelezela woho, hikuilombelezela isi mna nawalombelezela wadya unink'hile, Kwaviya ni wako. ");
INSERT INTO ngp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yose nnanayo ni yako, naho ya kwako ni ya kwangu, naho ukulu yangu wonekana kwa wadya unink'hile. ");
INSERT INTO ngp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naho ivi haluse neza kwako, himuli mwe isi mna woho wamwe isi, Tate msuntilwa kwa udahi dizina dyako unink'hile, naungisa uwaike wande kint'hu kimwenga enga viya sue kili umwenga. ");
INSERT INTO ngp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Viya nendile hamwenga nao nahiwaika vedi kwa udahi we dizina dyako unink'hile. Miye nahiwaamila naho hahali hata yumwenga mwe woho agile, mna ni yudya mwana agile uleke Mawandiko Akukile ukelavilize. ");
INSERT INTO ngp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Mna ivi haluse neza kwako, mna hilonga mbuli izi mwe isi vileke washiliki hamwenga na miye ikinyemi nnanacho. ");
INSERT INTO ngp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Miye hiwenk'ha ulosi wako naho want'hu wa isi niyo wawaihiwa Kwaviya woho hiyo wa isi enga viya miye name hiyo wa isi. ");
INSERT INTO ngp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hikulombeza uwahause kulawa mwe isi, mna nalombeza uwahonye na yudya Mwavu. ");
INSERT INTO ngp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Woho hiyo wa mwe isi enga viya miye. ");
INSERT INTO ngp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Waike wande wakukizwe mwe kindedi, ulosi wako ni kindedi. ");
INSERT INTO ngp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Enga viya unisigile miye mwe isi, miye name nawasigila woho mwe isi. ");
INSERT INTO ngp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Naho kwa mbuli ya woho miye mwenye nakeika nikukizwe vileke woho nawo wande wakukizwe mwe kindedi. ");
INSERT INTO ngp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Hikuwalombezela woho du mna Nawalombeza hata woho wakunga wahuwile kwa ulosi wao. ");
INSERT INTO ngp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nalombeza vileke wose wande kint'hu kimwenga. Tate, Nalombeza wande mndani mwetu enga viya weye undile mndani mwangu name mndani mwako. Nalombeza wande kint'hu kimwenga uleke want'hu wa mwe isi wahuwile kugamba weye niye unisigile. ");
INSERT INTO ngp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Miye hiwenk'ha ukulu udya unink'hile miye vileke wande kint'hu kimwenga enga viya suwe kili umwenga. ");
INSERT INTO ngp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Miye ninde mndani mwawe nawe mndani mwangu, nalombeza wakint'hizwe kunda kint'hu kimwenga, vileke isi imanye kugamba weye nakunisigila. Naho wawaunga woho enga viya ukuniunga miye. ");
INSERT INTO ngp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tate naunga wadya unink'hile wande hamwenga na miye hadya huunga nili, vileke wauone udya ukulu wangu unink'hile Kwaviya nakuniunga kukongela viya isi ikei kuumbigwa. ");
INSERT INTO ngp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tate ywedi, isi haikukumanya, mna miye hikumanya. Wano nao wakumanya kugamba weye niye unisigile. ");
INSERT INTO ngp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Hikutenda umanyike kwawe naho nenigendeele kukutenda ivo, vileke lukunde wandile nao kwangu unde mndani mwawe name ninde mndani mwawe.” ");
INSERT INTO ngp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu eze alonge ayo, niyo aita ng'ambu yo mto Keduloni, hamwenga na wanamp'hina wakwe. Hant'hu aho handaga na bustani, Yesu niyo engila Umwo hamwenga na wanap'hina wakwe. ");
INSERT INTO ngp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, Yudya amsezenge Yesu, nakahamanya hant'hu aho kwaviya nk'hanana nyingi Yesu naakadugana na wanamp'hina wakwe uko. ");
INSERT INTO ngp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Niyo, Yuda aguha kafyo ka watowani na wamizi kulawa kwa wakulu wa walava nt'hambiko na Mafalisayo, nokwizanao kwe ibustani. Nawanda na vimuli na magala hamwenga na vitoanilo. ");
INSERT INTO ngp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, Kwaviya nakamanya yadya yose yakuunga yamlaile niyo awezila na kuwauza, “Mwamzungula ani?” ");
INSERT INTO ngp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Woho nao niyo wamhitula, “Yesu Mnazaleti!” Yesu niyo awagamba, “Ni miye.” Yuda yudya akumsezenga na kanda kakimala haguhi na woho. ");
INSERT INTO ngp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Umwo Yesu eze awagambe, “Ni miye.” Niyo wauya kunyuma, na kugwa hasi. ");
INSERT INTO ngp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu awauza naho, “Mwamzungula ani?” Niyo wamhitula, “Yesu Mnazaleti!” ");
INSERT INTO ngp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu niyo awagamba, “Hiwagambilani kale kugamba ni miye, haluse uneva mwanizungula miye walekeni wano watuhu wakeitile.” ");
INSERT INTO ngp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nakalonga ivo vileke yadya alongaga yakelavilize, “Tate hezile hata yumwenga mwe wadya unink'hile.” ");
INSERT INTO ngp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petulo andaga na bamba, niyo adisomola no kumsenga digutwi dya kulume mtumwa wa mlava nt'hambiko mkulu. Mndima uyo naaketangwa Maliko. ");
INSERT INTO ngp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu niyo amgamba Petulo, “Vuza idibamba dyako mwe yala. Togola, nise kunywela ikikombe che masulumizo anink'hile Tate?” ");
INSERT INTO ngp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wadya wank'hondo wawayahudi, niyo wamgwila Yesu na kumkakiliza luzigi, ");
INSERT INTO ngp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","naho niyo wanda kumwigala kwa Anasi. Anasi na kanda ise vyala dya Kayafa yehe andile mlava nt'hambiko mkulu mwe mwaka uwo. ");
INSERT INTO ngp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Naho Kayafa nuyo awagambile Wayahudi kugamba, yaungigwa mnt'hu yumwenga abanike hant'hu ha want'hu wengi. ");
INSERT INTO ngp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petulo hamwenga na mwanamp'hina niyo wamtimila Yesu. Yudya mwanamp'hina mtuhu na kanda kamanyika kwa mlava nt'hambiko mkulu, niyo engila hamwenga na Yesu kundani hant'hu hakuduganikila ha mlava nt'hambiko mkulu. ");
INSERT INTO ngp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mna Petulo andaga kakimala kuse hagihi no umnango, Mna yudya mwanamp'hina mtuhu andile akamanyika na Mlava nt'hambiko mkulu niyo afosa kuse na kulonga na mvele yumwenga andile ho mnango amlekela Petulo engile kundani. ");
INSERT INTO ngp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yudya mvele ho mnango niyo amgamba Petulo, “Weye wi yumwenga mwa wanamp'hina wa uyu mnt'hu?” Petulo niyo amhitula, “Miye hiyo mwa woho.” ");
INSERT INTO ngp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wandima hamwenga na wamizi nawakweleza moto niyo wanda wotela Kwaviya na kunda na mp'heho. Petulo naye na kanda hamwenga na woho akotela moto. ");
INSERT INTO ngp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Niyo mlava nt'hambiko mkulu amuuza Yesu, mwe mbuli ya wanamp'hina wakwe hamwenga na mahinizo yakwe. ");
INSERT INTO ngp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu niyo amhitula, “Nehilonga na kila mnt'hu haheina kukefisa, Lupisi wose nahihiniza mwe zinyumba nk'hulu za Mnungu hamwenga na mwe nyumba za Mnungu mdya wakuduganikila wayahudi wose naho hina idyo nilongile kwa kukefisa. ");
INSERT INTO ngp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ni mbwai kuniuza miye? Wauze wadya wanivile. Wauzeni yadya niwagambile, wayamanya yadya niwagambile.” ");
INSERT INTO ngp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Eze alonge ayo mwamizi yumwenga andile kakimala aho niyo amtowa Yesu, no kumgamba, “Togola, nivo ukumhitula mlava nt'hambiko mkulu?” ");
INSERT INTO ngp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu amhitula, “Uneva hilonga vihiye, lagisa uwo wiihi. Mna uneva hilonga vedi, wanitoelai?” ");
INSERT INTO ngp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Niyo Anasi amwigala Yesu ivo akakilizwe, kwo mlava nt'hambiko mkulu uyo Kayafa. ");
INSERT INTO ngp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni naye Petulo andaga akei aaho akotela moto. Basi, niyo wamuza, “Togola, weye nawe wiyumwo mwa wanamp'hina wakwe?” Petulo niyo ahitula. “Bule, hiyo miye.” ");
INSERT INTO ngp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yumwenga mwa wandima wa mlava nt'hambiko mkulu yudya akantigwe idigutwi ni Petulo, amuzaga, “Togola, miye hikuwone weye kwe bustani hamwenga na uyu?” ");
INSERT INTO ngp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petulo alemelaga naaho, aaho zogolo niyo dyaila, ");
INSERT INTO ngp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Basi, niyo wamguha Yesu kulawa kwa Kayafa, no kumwigala kwe nyumba ye kiseuta. Yandaga kilokilo, vileke wadahe kudya pasaka, hawengile mwe nyumba yo uzumbe wanase kugeligwa usavu. ");
INSERT INTO ngp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kwa ivo, Pilato awabasaga uko kuse no agamba, “Mna mlahowani no mnt'hu uyu?” ");
INSERT INTO ngp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Niyo wamhitula, “Uneva uyu hiyo Mwavu hegu hakimletile kwako.” ");
INSERT INTO ngp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato niyo awagaba, “Hayani, mguheni nyuwe wenye, mkamsengele vikuligana ne miko yenyu.” Wayahudi niyo wamhitula, “Suwe hakina udahi wa kumkoma mnt'hu yoyose.” ");
INSERT INTO ngp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nevinda ivo vileke ukelavilize ulosi udya Yesu alongaga kugamba, naafe file yani. ");
INSERT INTO ngp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato niyo engila vituhu kwenyumba ikwitangwa ikulu, amwitanga Yesu na kumuza, “Hambwe weye niwe Zumbe ywa Wayahudi?” ");
INSERT INTO ngp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu niyo amhitula, “Togola, izi ni mbuli zako hegu want'hu wakugambilaga zimbuli zangu?” ");
INSERT INTO ngp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato niyo amhitula, “Togola, Miye ni Myahudi? Kabila dyako naho wakulu wa walava nt'hambiko wakuleta kwangu. Kubanangai?” ");
INSERT INTO ngp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu niyo amhitula, “Useuta wangu hiyo we isi ino, Uneva Useuta wangu wandile we isi ino, wandima wangu na wanigombela nisekugeligwa mwe mikono ya Wayahudi. Mna haluse Useuta wangu hiyo wa aha.” ");
INSERT INTO ngp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aho Pilato niyo amgamba, “Haluse weye wi Zumbe.” Yesu amhitula, “Weye kulonga kugamba miye ni Zumbe. Miye hyelekwa kwa mbuli ino imwenga, kulonga ikindedi, mkindedi yeyose naanitegeleze.” ");
INSERT INTO ngp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato niyo amgamba, “Ikindedi ni kint'hu chani?” Pilato eze alonge ivo, niyo awabasa naho Wayahudi niyo awagamba, “Miye hione mbuli yoyose iihile kwakwe. ");
INSERT INTO ngp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mna yaungigwa miye niwakomoele mvugailwa yumwenga mwe pasaka. Haluse mwaunga niwakomoele Zumbe ywa Wayahudi?” ");
INSERT INTO ngp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aho niyo wata kubongeela, “Bule! Hiyo uyo, kikomoele Balaba!” Uyo Balaba andaga mhoki wa vint'hu want'hu. ");
INSERT INTO ngp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Niyo Pilato amguha Yesu no kugenda kumtoa mikotya. ");
INSERT INTO ngp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wank'hondo niyo wadamanya taji ya miwa niyo wamvala mo mtwi, naho niyo waguha suke ye zambalau nakumvala. ");
INSERT INTO ngp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Niyo wamwizila nakumgamba, “Wikale mp'heho Zumbe wa wayahudi.” Naho niyo wagendeela kumtoa. ");
INSERT INTO ngp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato niyo afosa kuse kaidi nokudigamba idifyo dya want'hu. “Kauleni, mguheni mnt'hu uyu vileke mmanye kugamba miye hikuona wiihi wowose mwo mnt'hu uyu.” ");
INSERT INTO ngp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Niyo Yesu afosa kuse availe taji ye miwa mwo mtwi naho kavaligwa suke ya zambalau. Pilato niyo awagamba, “Kauleni mnt'hu uyu.” ");
INSERT INTO ngp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Niyo wadya wakulu wa walava nt'hambiko hamwenga na wandima wawe weze wamuwone wakonga kugutila wakagamba, “Muwambe! Muwambe Pilato!” ");
INSERT INTO ngp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayahudi niyo wamhitula, “Kina miko ikugamba aungwa kukomwa, kwaviya aketanga Mwana wa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato eze eve ivo niyo engilwa na wogofi mkulu. ");
INSERT INTO ngp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Niyo auya kwe nyumba yo ulava nt'hambiko no kumuuza Yesu, “Weye kulawahi?” Mna Yesu hamhitule. ");
INSERT INTO ngp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato niyo amgamba Yesu, “Hukuunga kulonga na miye? Umanye, nna udahi wa kukulekela weye unde mwenye nyumba naho nna udahi wakukuwamba mwo mti wa masulmizo.” ");
INSERT INTO ngp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu niyo amhitula, “Una udahi mwa miye Kwaviya nokwink'higwa ni Mnungu, yudya aniletile kwako anawiihi mkulu.” ");
INSERT INTO ngp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato eze eve ivo, niyo azungula sila ya kumlekela Yesu. Mna idifyo dya Wayahudi niyo dyagutila, “Uneva unamlekela hounde mbuya na Seuta ywa Kilumi, mnt'hu yeyeso anaketenda Zumbe naende haaivane na seuta ywa Kilumi.” ");
INSERT INTO ngp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato eze eve ivo want'hu nawakalonga, niyo amguha Yesu no kuita naye kuse no kwikala mwe ukalo wakwe wo usengelo hant'hu hakwitangwa sakafu ya maiwe kwa ulosi wa Kiibulania nahaketangwa, “Gabasa.” ");
INSERT INTO ngp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Naho neinda nomsi want'hu wakakeika lumwe kwa pasaka. Pilato niyo awagamba Wayahudi, “Zumbe wenyu uyu eaha.” ");
INSERT INTO ngp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Niyo wagutila, Mkome, mkome, muwambe! Pilato niyo awauza, “Nyuwe mwaunga miye nimkome Zumbe wenyu?” Wakulu wa walava nt'hambiko niyo wamhitula, “Suwe hakina Zumbe yeyose mna Seuta ywa Kilumi uuyo du.” ");
INSERT INTO ngp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilato niyo amwink'hiza mwe mikono yawe vileke awambigwe. Niyo wamguha Yesu vileke wamuwambe. ");
INSERT INTO ngp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu niyo afosa kuse no kwinula msalaba wakwe wa masulumizo mpaka hant'hu hakwitangwa “Kibela cha mtwi” kwa Kiibulania Goligota. ");
INSERT INTO ngp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wamuwambaga hadya, hamwenga na want'hu watuhu waidi, Yumwenga kumoso na wakaidi mkono wakwe wa kulume, Yesu nae andaga hagati. ");
INSERT INTO ngp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato nakawandika mwe kabao niyo kaikigwa halanga he msalaba, “YESU MNAZALETI ZUMBE WA WAYAHUDI.” ");
INSERT INTO ngp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wayahudi wengi nawasoma Kwaviya hant'hu hadya Yesu awambilwe na handa hiyo hale na ho mzi. Naho nayaandikwa kwa Kiibulania, kilumi hamwenga na Kigiliki. ");
INSERT INTO ngp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mlava nt'hambiko mkulu niyo amgamba Pilato, “Usekuwandika, ‘Zumbe wa wayahudi mna uyu mnt'hu naakagamba, miye ni miye Zumbe wa wayahudi.’ ” ");
INSERT INTO ngp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato niyo awahitula, “Yadya niwandike haya kuhitulwa.” ");
INSERT INTO ngp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wank'hondo weze wajike kumuwamba Yesu, niyo waguha isuke yakwe nakuipanga mafungu mane, kila yumwenga na fungu dyakwe. Naho niyo waguha nk'hazu yakwe naho nk'hanzu idya ne inda haisumigwe mna ita kufumigwa kukongela kulanga. ");
INSERT INTO ngp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wadya wank'hondo niyo wagambana, “Kisekuitatula mna kitowe kula kikaule ni ani akuunga aink'higwe.” Uleke ukelavilize Mawandiko Akukile udya Mawandiko Akukilegwe, “Naawakepangila zisuke zangu, no kuitoela kula nk'hanzu yangu.” Iivi nivo wadamanye wadya wank'hondo. ");
INSERT INTO ngp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Wandaga hagihi no msalaba hadya awambilwe Yesu wandaga, ni nine dya Yesu, lumbudye dya nine dya Yesu, Maliamu mkaziwe dya Kiliopa, hamwenga na Malia Magedalena. ");
INSERT INTO ngp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu niyo amuwona nine hamwenga na yudya mwanamp'hina amuungisaga wakimala, niyo amgamba nine, “Uyo nuyo umwanao.” ");
INSERT INTO ngp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Naho niyo amgamba yudya mwanamp'hina ywakwe, “Uyo nuyo nyokwe.” Kukongela aho yudya mwanamp'hina niyo amgumha yudya nine no kugenda kwikala nae kwe nyumba yakwe. ");
INSERT INTO ngp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kukongela hadya, Yesu nakamanya kugamba kila kint'hu nechajika, naho vileke kila Mawandiko Akukile ukint'he, niyo agamba, “Naona nk'hilu.” ");
INSERT INTO ngp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nahanda na kiyamp'ha kimemile siki, niyo watufika ditambala idyo mwe kiyamp'ha kine siki, niyo wadi zinganiza mwa kaziti katali, niyo wamwink'hiliza mwo mnomo. ");
INSERT INTO ngp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu eze ajink'he kuinywa idya siki niyo afunamiza mtwi hasi akagamba, “Isila.” ");
INSERT INTO ngp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Niyo wadya wakulu wa wayahudi waita na kumlombeza Pilato vileke awenk'he kuwavuna iviga wadya want'hu wawambigwe, hamwenga no kuiseleza imili yawe. Nawamuuza ivi Kwaviya neinda ijumaa, naho hawaungile imili iyo ikale mwe misalaba viwambilo mwe dizuwa dyo kuhumula. ");
INSERT INTO ngp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Niyo wank'hondo waita na kuvuna iviga va yudya mnt'hu wa nk'hongo hamwenga na mtuhu, wadya want'hu wawambigwe hamwenga na Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mna weze wabule kwa Yesu niyo wambwila kabanika kale vilekile hawamvunile iviga vakwe. ");
INSERT INTO ngp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mnk'hondo yumwenga niyo mtunga Yesu na mkuki wakwe mwo lubavu lwakwe, aaho niyo mwalawa sakame na mazi. ");
INSERT INTO ngp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yudya aone na kalonga naho yadya alongile ni ya kindedi naho kamanya kugamba alonga kindedi naho alonga ivo vileke nyuwe nanywe mhuwile. ");
INSERT INTO ngp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ino na inda ivi vileke yadya yawandikwe yande kindedi, “Hadihali hata vuha dyakwe dimwenga divunigwe.” ");
INSERT INTO ngp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Naho yeyuko Mawandiko matuhu ya Mnungu yakugamba, “Want'hu nawamkaule yudya wamjungile mkuki.” ");
INSERT INTO ngp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yeze yajike, na handa na mnt'hu yumwenga etangagwa Yusufu, endile akekala ko mzi wa Alimatayo, niyo aita kwa Pilato na kumlombeza umwili wa Yesu, Mnt'hu uyu andaga mwanamp'hina Yesu kwa kinyele Kwaviya naakawogoha vilongozi we Kiyahudi. Pilato niyo amzumila uleke auguhe mwili wa Yesu, Yosefu aitaga niyo auguha umwili wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo yudya aitaga kwa Yesu nekilo, niyo aita hamwenga na Yusufu naho nakaguha manemane hamwenga na udi ukubula madebe maidi. ");
INSERT INTO ngp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wagosi awa waidi niyo wauguha umwili wa Yesu na kuuvunganiza sanda, enga viya wayahudi wandaga wakadatenda, mwo kuuikia lumwe umwili vileke umoswe msanga. ");
INSERT INTO ngp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na handa na nk'honde haguhi na hadya Yesu awambigwe, naho na handa na kikuta chandile kikei kumosa msanga mnt'hu yeyose ");
INSERT INTO ngp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kwaviya neinda mwe kuikila lumwe kwa Wayahudi mwa zuwa ya kuhumula, niyo wauwika umwili wa Yesu kwe mp'hanga yandile hagihi. ");
INSERT INTO ngp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mtootondo zuwa dya nk'hongo dya juma, Umwo kwandile kukei mavukuvuku, Maliamu Magedalena nakaita kwe kikuta, niyo abwiila diiwe dihauswa kulawa mwe mnango we kikuta. ");
INSERT INTO ngp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Niyo aguluka kuita kwa Simoni Petulo hamwenga na mwanamp'hina mtuhu yudya Yesu naakamuungisa, niyo awagambila, “Wauguha umwili wa Zumbe mwe kikuta, naho hakimanyize aho waikile!” ");
INSERT INTO ngp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Niyo Petulo hamwenga na wanamp'hina watuhu waita mwe kikuta. ");
INSERT INTO ngp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Waidi wawe niyo waguluka, mna yudya mwanamp'hina mtuhu niyo agulukisa kumjink'ha Petulo, awo wanda wa nk'hongo kubula he kikuta. ");
INSERT INTO ngp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Niyo afunama akaula kundani, no kuiona isanda ihank'handa, mna heingile kundani. ");
INSERT INTO ngp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kunyuma kwakwe niyo eza Simoni petulo, yehe niyo ita kundani kwe kikuta. No kubwiila vitambala ve isanda vihank'handa. ");
INSERT INTO ngp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Hamwenga na suke afungilwe Yesu mwo mtwi wakwe. Havandile hamwenga ne sanda, ila neivunyangizwa hank'handa yoho yenye. ");
INSERT INTO ngp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Niyo mwanamp'hina mtuhu yudya andile wa nk'hongo kubula he kikuta, niyo yehe naye engila kundani kwe kikuta niyo aona hamwenga nakuhuwila. ");
INSERT INTO ngp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Niyo wanda hawakombaganye Mawandiko Akukile udya noukagamba naauyuke kulawa mwo kubanika. ");
INSERT INTO ngp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Niyo wadya wanamp'hina wajuya kaya. ");
INSERT INTO ngp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliamu niyo akimaala akaila haise he kikuta. Viya andile akei akaila, niyo afunama akakaula kundani mwe kikuta. ");
INSERT INTO ngp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Niyo awaona mtumigwa ywaidi wavaile suke zing'aile wekale hant'hu handile no umwili wakwe Yesu, yumwenga ko mtwi na wakaidi kwe viga. ");
INSERT INTO ngp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Niyo wamuuza, “Mvele wailai?” Niyo amhitula, “Wamguha Zumbe ywangu, Naho himanyize uko wamwiikile!” ");
INSERT INTO ngp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Niyo ahituka kunyuma amuwona Yesu kakimala, mna habunk'hule kugamba andaga ni Yesu. ");
INSERT INTO ngp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu niyo amuuza, “Mvele wailai? Wamzungula ani?” Maliamu akafanyanya kugamba uyo andaga ni yudya akuikaula ibustani, akamgamba, “Mkulu, nigambile uko umwikile name nehamguhe.” ");
INSERT INTO ngp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu niyo amgamba, “Maliamu!” Niyo amhitukila nokulonga naye mwe Kiibulania, “Laboni!” Nuko kugamba, “Mhinizi.” ");
INSERT INTO ngp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu niyo amgamba, “Usekunitoza, Kwaviya nikei kuuya kulanga kwa Tate. Mna ita ukawagambile ndugu zangu kugamba, nauya kwa Tate yangu naho hata woho ni Tati yawe. Mnungu wangu naho Mnungu ywawe.” ");
INSERT INTO ngp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Niyo Maliamu Magedalena aita nakuwagambila wanamp'hina kugamba kamuwona Zumbe. Naho kamsigiila eze awagambile. ");
INSERT INTO ngp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Neinda nekisingi zuwa dya nk'hongo dya juma, wanamp'hina nawanda we mwe nyumba wakevugaila zinyivi Kwaviya nawakawogoha wakulu wa wayahudi. Yesu niyo awalaila akimaala hagati hawe na kuwagamba, “Utondowazi nounde na nyuwe.” ");
INSERT INTO ngp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Eze ajink'he kulonga ivi, niyo awalagisa mikono yakwe hamwenga no lubavu lwakwe. Wanamp'hina wakwe niyo wanda na kinyemi kikulu Kwaviya wamuwone Zumbe. ");
INSERT INTO ngp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu niyo awagamba naho, “Utondowazi nounde na nyuwe, enga viya tate anisigiile miye, miye name nawasigiilani nyuwe.” ");
INSERT INTO ngp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eze ajink'he niyo awavikila no kuwagamba, “Hokeleni Muye ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mnawausila want'hu wavu wawe nawausilwe, hamna wausile hawakudaha kuusilwa. ");
INSERT INTO ngp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yumwenga mwe wadya mlongo na waidi, akwitangwa Tomasi hegu pasa, andaga hahali hamwenga na wadya wanamp'hina weyawe viya Yesu akawalaila. ");
INSERT INTO ngp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wanamp'hina watuhu niyo wamgamba, “Kimuona Zumbe!” Tomaso niyo awagamba, “Uneva hione zink'hovu ze mitunga mwe mikono yakwe hamwenga na kugela kadole mwe zink'hovu na kugela mkono mwo lubavu lwakwe, hikudaha kuhuwila.” ");
INSERT INTO ngp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Juma dimwenga dizedyomboke wanamp'hina na wanda hamwenga kwe nyumba, Tomasi na kanda hamwenga na woho. Umnango nounda uvugalwa mna Yesu niyo eza no kwingila niyo akimaala hagati na kuwagamba, “Utondowazi nounde na nyuwe.” ");
INSERT INTO ngp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yesu niyo amgamba Tomasi, “Gela kadole kako aha, naho kaula mikono yangu. Naho lete umkono wako uugele mwo lubavu lwangu. Usekukunda hwiina mhuwi uhuwile!” ");
INSERT INTO ngp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi niyo amhitula, “Zumbe ywangu na Mnungu ywangu!” ");
INSERT INTO ngp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Niyo Yesu amgamba, “Kuhuwila kwaviya kaniona? Ni vedi kwa wadya wakuhuwila haheina kuniyona.” ");
INSERT INTO ngp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mwa meso ya wanamp'hina wakwe Yesu nakadamanya vilagiso vingi heviwandikwe mwe kitabu iki. ");
INSERT INTO ngp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mna aya yawandikwa vileke want'hu wahuwile kugamba Yesu niye Kilisito Mwana ywa Mnungu, na kwa kuhuwila mdahe kunda na ugima kwa ludole lwe dizina dyakwe. ");
INSERT INTO ngp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesu eze awalaile naho wanamp'hina wakwe kwe bahali ya Tibelia, vandaga ivi, ");
INSERT INTO ngp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petulo na Tomasi akwitangwa pasa hamwenga na Natanaeli mkaya wa Kana ya Galilaya na wana waidi wa Zebedayo hamwenga na wanamp'hina wakwe watuhu waidi. ");
INSERT INTO ngp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petulo niyo awagamba, “Nagenda kulowa zisamaki.” Niyo wamhitula, “Nekiitanye hamwenga na weye.” Niyo waita kuse na kwingila mwe ngalawa, mna mwe kiya kilo chose hawapatile samaki. ");
INSERT INTO ngp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mtondo zuwa dika tontomoka, Yesu niyo akimaala hank'handa he bahali, mna wanamp'hina wakwe na wanda hawabunk'hule kugamba ni yehe. ");
INSERT INTO ngp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Niyo Yesu awetanga no kuwauza, “Wambuyazangu, togoleni! Hamgwiile chochose?” Niyo wamhitula, “Hakipatile kint'hu.” ");
INSERT INTO ngp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Niyo awagamba, “Duleni lwavu lwenyu mkono wo kulume we ingalawa, nomlowe.” Ivo niyo waduula no kudunduga kwinula lwavu kundani kwe ngalawa kwaviya nawalowa samaki zibindile ingi. ");
INSERT INTO ngp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Niyo yudya mwanamp'hina aungiswe ni Yesu amgamba Petulo, “Uyu ni Zumbe Yesu.” Simoni Petulo eze eve kugamba yudya andaga ni Zumbe Yesu, niyo akevala suke yakwe idya aihambule umwo andile mwa mazi, niyo apilika mwa mazi. ");
INSERT INTO ngp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wanamp'hina wamwenga niyo wamtimila ne ngalawa wakavuta lwavu lumemile samaki, kwaviya na wanda hawehale no kunk'handa kwe bahali, na wanda enga nk'hacho gana dimwenga, kubula kunk'handa kwe bahali. ");
INSERT INTO ngp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Weze waseele hasi, niyo wabwiila moto hamwenga na samaki ikokigwa, hamwenga na mkate. ");
INSERT INTO ngp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu niyo awagamba, “Nink'heni samaki izo mlowile.” ");
INSERT INTO ngp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Niyo Simoni Petulo aita mwe ngalawa akonga kuvuta ulwavu kulawa kwa mazi lumemile samaki nk'hulu zikubula gana dimwenga na milongo mishano na nt'hatu. Samaki nezinda nyingi mna lwavu halutatuke. ");
INSERT INTO ngp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu niyo awagamba, “Soni mdye!” Hahali hata mwanamp'hina yeyose amuuzile Yesu kugamba, “Weye niwe ani?” Kwaviya nawammanya andaga ni Zumbe. ");
INSERT INTO ngp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu niyo aguha mkate nokuwenk'ha, niyo atenda iivo kwe samaki. ");
INSERT INTO ngp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Naho ino neinda malavo ya Yesu ya katatu akawalaila wanamp'hina wakwe umwo eze ande kauyuka. ");
INSERT INTO ngp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Weze wajike ukudya, Yesu niyo amgamba Simoni Petulo, “Simoni mwana Yohana, weye waniunga kujink'ha woseni awa?” Simoni niyo amhitula, “Heiye Zumbe, kumanya kugamba nakuungisa.” Yesu niyo amgamba, “Dima Zingoto zangu.” ");
INSERT INTO ngp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kaidi naho, Yesu niyo amgamba, “Simoni mwana Yohana, waniungisa?” Niyo ahitula, “Heiye Zumbe, kumanya kugamba nakuungisa.” Yesu niyo amgamba, “Dima zingoto zangu.” ");
INSERT INTO ngp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Katatu naho, Yesu niyo amgamba, “Simoni mwana Yohana, waniunga?” Petulo niyo engilwa ni kinyulu kwaviya Yesu nakamuuza nk'hanana ya katatu “Weye waniunga?” Niyo amgamba, “Zumbe kumanya kila kint'hu, kumanya kugamba miye nakuunga!” Yesu niyo amgamba, “Dima zingoto zangu. ");
INSERT INTO ngp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ikindedi nakugambila, umwo wandile mdodo noukahina na kuita kokose kudya noukaunga, mna unadalahala nowinule mikono yako niyo mnt'hu mtuhu akuguha nakukwigala kunt'hu hwikukuunga.” ");
INSERT INTO ngp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu alongaga ivi akalagisa ivo Petulo akuunga abanike nakumwink'ha Mnungu ukulu. Yesu niyo amgamba, “Nitimile.” ");
INSERT INTO ngp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petulo niyo ahituka kunyuma, niyo amuwona yudya mwanamp'hina naakaungiswa ni Yesu atimila. Niye yudya ekeegamile mwe kifua cha Yesu umwo wandile holudyo no kumuuza, “Zumbe akuunga akusezenge niani?” ");
INSERT INTO ngp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petulo eze amuone, niyo amuuza Zumbe Yesu, “Zumbe, uyu mnt'hu naye?” ");
INSERT INTO ngp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu niyo amhitula, “Uneva naunga ekale mpaka aho heza kuuya, weye waiungilai!” ");
INSERT INTO ngp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Niyo mbuli idya yagendezwa mwa wandugu awo kugamba mwanamp'hina yudya haabanike. Mna Yesu halongile kugamba habanike mna nakagamba, “Uneva nnaunga ekale mpaka aho heza kuuya, weye wayaungilai?” ");
INSERT INTO ngp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mwanamp'hina uyu niye alongile zimbuli izi, naho ni yehe ayawandike, naho nakamanya yadya naakayalonga ayawandike ya kindedi. ");
INSERT INTO ngp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Naho kuna mbuli zibindile ingi Yesu azidamanye, uneva zose zawandikagwa imwe imwe, nikindedi kugamba si yose hayakint'hile, ivitabu ivo.");
INSERT INTO ngp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kwa zumbe Teofilo. Mwe kitabu changu che nk'hongo nehiwandika zimbuli zose adamanye Yesu no kuhiniza kwakwe, kulawa aho akongaga indima, ");
INSERT INTO ngp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","no kubula mwe dizuwa enuilagwa kuita kulanga. Umwo andaga akei kwinulwa kuita kulanga, awenk'haga sigilizi kwa udahi wa Muye ywa Mnungu wadya want'hu awasagulaga kunda wegala ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kwa malavo na sila nyingi mwa mazuwa milongo mine, kulawa file yakwe, awalailaga wanamp'hina wakwe vileke awalagise kugamba emgima, no kuusa kuswesa kuhuwila kwawe. Wamuonaga naho alongaga nao mwe mbuli yo Useuta wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Naho Umwo wandaga hamwenga awenk'haga sigilizi ino, akawagamba. “Mse kuhalawa mwe Yelusalemu, mna gojeleni nt'hunyo idya niwagambileni, lagano Tate awaikilagani. ");
INSERT INTO ngp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana abatizaga na mazi, mna mwa mazuwa mageke ya kwiza no mbatizwe kwa Muye ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Umwo wanamp'hina wandaga hamwenga na Yesu, wamuuzaga wakamgamba, “Zumbe, togola ivi haluse nivo waunga uvuze useuta kwa want'hu wa Izilaeli?” ");
INSERT INTO ngp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu niyo awagamba, “Haimwenyu kumanya lupisi no msimo. Tate niye ayaikile mwo udahi wakwe.” ");
INSERT INTO ngp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mna, nomhokele udahi umwo akawezilani Muye ywa Mnungu, nomnde walonga uwona wangu, mwo mzi wa Yelusalemu na mwe isi yose ya Yuda ne isi ya Samalia na mwe isi zose. ");
INSERT INTO ngp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eze abinde kulonga ivi, niyo enulwa kulanga iivi wakamsinya, niyo vunde dya mgubika iivi wakamsinya. ");
INSERT INTO ngp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Umwo wandile wakei wenule meso yawe kulanga umwo Yesu andile akaita, wagosi waidi wavaile suke zing'aile mbe, nawakimala hagihi yawe. ");
INSERT INTO ngp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Niyo wawagamba, “Nyuwe want'hu wa Galilaya mkimalizwa nii aho mkakaula kulanga? Uyu Yesu aguhuhigwe kulawa mwenyu, naauye enga iivi mmuwone akaita kulanga.” ");
INSERT INTO ngp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Niyo wanamp'hina wa Yesu wauya mwo mzi wa Yelusalemu kulawa kwo lugulu lwe Mizeituni, hana uhale wa lugendo lwa mazuwa mfungate kulawa kwo mzi. ");
INSERT INTO ngp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wengilaga mwo mzi no kwita mpaka kwe chumba ukwo nawakekala. Awo wandaga ni wakina Petulo na Yohana na Yakobo na Anduleya na Filipo na Tomasi na Batolomayo na Matayo na Yakobo mwana Alufayo hamwenga na Simoni akwitangwa “Mtowanila isi ya Izilaeli” na Yuda mwana Yakobo. ");
INSERT INTO ngp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Awa wose wandaga wakavika Mnungu hamwenga na wavele wamwenga, wakina Maliamu nine dya Yesu na wanduguze. ");
INSERT INTO ngp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mazuwa mageke kulongole kwandaga na mdugano wa wandugu wahuwila, wabulaga gana na milongo miidi woseni kwa hamwenga. Petulo niyo akimala no kugamba. ");
INSERT INTO ngp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wandugu zangu wahuwila,” Mawandiko Yakukile aya yaungwa yakint'he, yudya Muye ywa Mnungu alongaga kombokela kwa Daudi mwe mbuli ya Yuda uyo awalongozaga wadya wamgwilaga Yesu, ");
INSERT INTO ngp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda andaga ni yumwenga mwe difyo dyetu, kwaviya naye asagulagwa kunda miyetu mwe ndima yetu. ");
INSERT INTO ngp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na matundu yadya Yuda aguhaga kwa mbuli yo wiihi wakwe agulaga mgunda aho agwaga no kubanika, atulikaga izinda niyo utumbo wakwe wafant'hukila kuse. ");
INSERT INTO ngp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Want'hu wose nawakekala Yelusalemu waivaga imbuli iyo, na ivo mwe milosi yawe wenye wawitanga mgunda udya Akelidama, nuko kugamba “Mgunda ya sakame”. ");
INSERT INTO ngp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Kwaviya nivo iwandikwe mwe kitabu che Zabuli. ‘Nyumba yakwe neinde heiina kint'hu, isekwikalwa ni mnt'hu yeyose.’ Naho iwandikwa. ‘Hant'hu hakwe nahaguhigwe ni mtuhu.’ ");
INSERT INTO ngp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Naivo mtuhu naaungwe kukelunga na suwe, ko ulonga uwona, wo uuyulo wa Zumbe Yesu. Uyo aungwa kunda ni yumwenga mo umwenga wetu kukongela umwo Zumbe Yesu andaga hamwenga na suwe, kukongela kudya Yohana andaga akabilikiza ulosi wo ubatizi, mpaka mwe dizuwa aguhilagwa Yesu kulanga kulawa kwetu.” ");
INSERT INTO ngp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ivo niyo walavilizwa want'hu waidi, Yusufu etangagwa Balisaba, zina tuhu Yusito, ywakaidi ni Matiya. ");
INSERT INTO ngp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Niyo wamlombeza Mnungu wakagamba, “Zumbe kumanya fanyanyi za kila mnt'hu, ivo ukilagise ni yuhi mwa awa waidi uyo umsagule ");
INSERT INTO ngp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","adamanye ndima ya wigala ulosi hant'hu ha Yuda uyo ahalekaga niyo aita hant'hu awagilwe kunda.” ");
INSERT INTO ngp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Niyo wadamanya usaguzi mwa waidi awo, naho asagulagwa andaga ni Matiya, naivo niyo awazigwa kunda hamwenga na wegala ulosi mlongo na yumwenga. ");
INSERT INTO ngp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dizuwa dye Pent'hekosite dize dibule, wahuwila wose waduganaga hamwenga hant'hu hamwenga. ");
INSERT INTO ngp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aaho niyo halaila mvumilo kulawa mwo ulanga mvumilo enga peho kulu dikuvumila, niyo dya memeza inyumba yose mdya wandile wakekala. ");
INSERT INTO ngp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Niyo waona enga ndilija za moto zitilwe niyo zawekaila kila yumwenga ywawe. ");
INSERT INTO ngp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wose wamemezagwa ni Muye ywa Mnungu, na kukonga kulonga kwa milosi mituhu, enga ivo Muye ywa Mnungu awenk'haga udahi wo kulonga. ");
INSERT INTO ngp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kwandaga na Wayahudi uko Yelusalemu, wandaga wakamvika Mnungu, walawaga mwe kila isi. ");
INSERT INTO ngp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Weze weve divumilo diya dikulu niyo wakeduganya. Wose wehelwagwa kwaviya kila yumwenga ywawe awevega wahuwila wakalonga kwa milosi yawe wenye. ");
INSERT INTO ngp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kwa kwehelwa no kuhungila, niyo wagamba, “Togola want'hu awa wakulonga enga ivi hiyo Wagalilaya! ");
INSERT INTO ngp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yanda vivihi suwe choseni chaweva ivo wakulonga, mwe milosi yetu wenye? ");
INSERT INTO ngp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Suwe kilawa Pasia wamwenga Media na Waelamu na watuhu ni wakaya wa Mesopotamia na Yuda na Kapadokia na Ponto na Asia, ");
INSERT INTO ngp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","wamwenga kulawa Filigia na a Pamfilia, wamwenga kulawa Misili na nt'hendelo za Libiya hagihi na Silene, wamwenga mwa suwe ni kulawa Lumi, ");
INSERT INTO ngp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","want'hu woseni, Wayahudi na want'hu hi Wayahudi watendigwe kutimila dini ye Kiyahudi, naho wamwenga wetu walawa Kilete na kwa Waalabu, mna suwe chose kikei cheva walonga mwe milosi iyetu wenye, ni vilagiso vikulu akudamanya Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wehelwagwa no kwaganikilwa, niyo wakeuza kila yumwenga wakagamba, “Ino niyo imbwai?” ");
INSERT INTO ngp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mna wamwenga niyo wawabela wakagamba, “Want'hu awa wakozi!” ");
INSERT INTO ngp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mna Petulo akimaalaga hamwenga na wadya wegala ulosi mlongo na yumwenga, naho kwa izwi kulu niyo akonga kulonga ne difyo diya dya want'hu akagamba, “Wambuya zangu Wayahudi, na nyuwe nyose mkwikala mwe Yelusalemu, nitegelezeni niwagambileni ino niyo imbwai. ");
INSERT INTO ngp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Want'hu awa hiyo wakozi enga ivo mkuwafanyanya, ivi haluse ni mtondo wa saa nt'hatu. ");
INSERT INTO ngp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Naho ino niyo alongaga Mlotezi Yoeli. ");
INSERT INTO ngp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mnungu agambaga, ‘Ivo nivo nenitende mwa mazuwa yo kubindiliza, nenigele Muye ywa Mnungu, mwa want'hu wose. Wana kilume na wakike nawabilikize ulosi wangu, wana wenyu we kilume nawaone maona, na wadala wenyu nawalote sozi. ");
INSERT INTO ngp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Heiye, hata mwa wandima wangu, wagosi na wavele, nenitile Muye ywangu mwa mazuwa ayo, nawabilikize mbuli yangu. ");
INSERT INTO ngp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nenidamanye vilagiso mnanga mo ulanga na vilagiso hasi he isi. No kunde sakame, moto na zosi dizamile, ");
INSERT INTO ngp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zuwa nedigeligwe lwiza, no mnenge nawo noudumile unk'hundu enga sakame wiziilo we dizuwa dikulu dyo ukulu wa Zumbe umwo dikanda dikei kwiza. ");
INSERT INTO ngp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aho yeyose naamwitange Zumbe kwa wambizi, naayokolwe.’ ");
INSERT INTO ngp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Tegelezeni zimbuli izi nyuwe wambuya zangu we Kiizilaeli! Yesu wa Nazaleti andaga mnt'hu mta udahi ulawile kwa Mnungu ulavilizwe kwenyu kwa vihungi no kweheela kudamanywe ni Mnungu kombokela kwakwe. Nyuwe wenye ni waona wa aya, kwaviya yalailaga mwenyu. ");
INSERT INTO ngp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kwaviya aungile mwenye Mnungu, Yesu nakaungwa kugeligwa mwe mikono yenyu, naho mwamkomaga kwa kuwalekela want'hu wata wavu wamkome kwa kumuwamba mo msalaba. ");
INSERT INTO ngp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mna Mnungu amuuyulaga no kumtenda kunda mlekelwa mo usungu we file, kwaviya havadahike file imtozeleze. ");
INSERT INTO ngp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kwaviya Daudi alongaga mwa yehe kugamba, ‘Himuona Zumbe kanilongoela mazuwa yose, yehe ehagihi na miye ivo henizingize. ");
INSERT INTO ngp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Na ivo miye himema kwelelwa, ne zimbuli zangu zimema kinyemi, hata handa no mwili wo kubanika nenikale kwa kukawiila, ");
INSERT INTO ngp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwaviya weye Mnungu hounase mwe isi ya wazimu houmlekele mtumwa ywako Akukile aowele kwe kikuta. ");
INSERT INTO ngp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kunilagisa miye sila ikunilongoza ko ugima, naho undiilo wako, nounimemeze kinyemi.’ ");
INSERT INTO ngp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Wambuya zangu, niwagambileni haheina kogoha, zimbuli zo mkale ywetu mkulu Daudi, abanikaga niyo amoswa msanga, naho kikuta chakwe kiaha hetu hata mwa mazuwa aya. ");
INSERT INTO ngp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Daudi andaga mlotezi, naho amanyaga kiya Mnungu alagisaga kwa kilapi, Mnungu amwikilaga kilapi kugamba naamwink'he yumwenga mwo welekwa wakwe kunda seuta enga viya Daudi andaga. ");
INSERT INTO ngp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi amanyaga kiya Mnungu nakaunga adamanye kulongole, na ivo asimuilaga imbuli yo kuuyuka kwa Kilisito Mkombozi asagulwe ni Mnungu umwo akagamba, ‘Haasigale mwe isi ya wazimu, mwili wakwe mwe kikuta.’ ");
INSERT INTO ngp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mnungu nakamuuyula Yesu, naswe kiwalonga uwona we kindedi iki. ");
INSERT INTO ngp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kenulwa na kuikwa mwo Useuta wa Mnungu, Ise, naho ahokelaga Muye ywa Mnungu kulawa kwakwe, enga viya amwikilaga ndagano. Iki mkukiona no kukiva ivi haluse niye nt'hunyo kitiilwe ni Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwaviya Daudi hiyo yehe enulwe kulanga, mna niye agambaga. ‘Zumbe amgambaga Zumbe dyangu. Ikala kulume kwangu ");
INSERT INTO ngp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mpaka niwaike wank'hondo wako hasi ye viga vako.’ ");
INSERT INTO ngp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Want'hu wose wa Izilaeli, wamanye ikindedi kugamba yudya Yesu Kilisito mwa muwambaga mwo msalaba niye atendigwe ni Mnungu kunda Zumbe na Mkombozi!” ");
INSERT INTO ngp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Want'hu weze weve ivo, niyo wengilwa ni kinyulu mwe mioyo yawe nokumgamba Petulo na wegala ulosi watuhu, “Haluse wandugu zetu, kitende vivihi?” ");
INSERT INTO ngp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petulo niyo awahitula kugamba, “Kila yumwenga ahituke kulawa mo wavu, no kubatizwa mwe dizina dya Yesu Kilisito, vileke muusilwe wavu wenyu, niho nomhokele geleko dya Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kwaviya indagano aikile Mnungu ni kwa nyuwe na wana wenyu na wose wehale, wose wetangwe ni Zumbe Mnungu kwakwe mwenye.” ");
INSERT INTO ngp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petulo abilikizaga kwa milosi mingi awakanyaga akagamba, “Keyokoleni nyuwe wenye kulawa mwa maya ya Mnungu yakukiziila cheleko iki cho wavu!” ");
INSERT INTO ngp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wengi wahuwilaga mo ulosi wakwe niyo wabatizwa, want'hu wabuile magana milongo mitatu nawongezekela mwe dizuwa idyo. ");
INSERT INTO ngp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Niyo wanda wakahinizwa ni wegala ulosi, wekalaga hamwenga mwe midugano ya wahuwila, wakabendula mkate no kumvika Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Vihungi vingi na va kwehela nevikadamanywa ni wegala ulosi, kila yumwenga niyo engilwa ni wogofi. ");
INSERT INTO ngp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wahuwila wose wagendeelaga kunda hamwenga na kuhangila vint'hu vawe kwa kila yumwenga. ");
INSERT INTO ngp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na wakataga vint'hu, no ugoli wawe na kukepangila matundu kuligana na viya kila yumwenga naakaviunga. ");
INSERT INTO ngp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kila zuwa dikutimila na wakadugana enga viya fyo mwe Nyumba ya Mnungu, naho nawakadya ndala, wakadya kwa kinyemi na mioyo ya ukise, ");
INSERT INTO ngp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","wakamtogola Mnungu no kuwatende want'hu wose welelwe. Naho kila zuwa Zumbe naakawagenyeza kwe difyo dyawe, kwa wadya nawakayokolwa. ");
INSERT INTO ngp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Zuwa dimwenga Petulo na Yohana wandaga wakaita hamwenga kwe nyumba ya Mnungu saa kenda kisingi, mwe sa yo kumvika Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hadya he Nk'hili Int'hana enga ivo ikwitangwa, handaga na mnt'hu aholomp'hale viga mo wikazi wakwe wose. Mazuwa yose naakegalwa kwe nk'hili akalombeze matundu kulawa kwa want'hu wandaga wakaita kwe Nyumba ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Eze awaone Petulo na Yohana wakengila mwe nyumba ya Mnungu, awalombezaga wamwink'he chochose. ");
INSERT INTO ngp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petulo na Yohana wamkaulisaga mnt'hu uyo, niyo Petulo amgamba, “Kikaule suwe!” ");
INSERT INTO ngp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ivo niyo awakaulisa akakawiila kwink'higwa chochose. ");
INSERT INTO ngp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mna Petulo amgambaga, “Miye hina matundu, mna nakwink'ha kiya nnanacho, kwe dizina dya Yesu Kilisito ywa Nazaleti, nakugamba Kimala ugende!” ");
INSERT INTO ngp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Niyo amwinula kwa mkono wakwe wo kulume, no kumwambiza akimale. Aaho iviga ne zink'hungu ze viga vakwe vapataga ludole. ");
INSERT INTO ngp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Niyo apilika no kukimala ne viga vakwe, naho niyo akonga kugenda genda, niyo engila nawo kwe Nyumba ya Mnungu, akagenda na kupilika pilika akamtogola Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Want'hu nawamuona akagenda no kumtogola Mnungu, ");
INSERT INTO ngp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","naho umwo weze wamuwone kugamba ni yudya kilombezi andaga akekala he nk'hili ikwitangwa Nnk'hili Nt'hana, wose weehelagwa na kuhungwa mwe kiya kimlaile yudya mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Umwo yudya mnt'hu andaga hamwenga nawo Petulo na Yohana, want'hu wose weheelesagwa, naivo niyo wawagulukila hant'hu hakwitangwa ho ukumbi wa Sulemani. ");
INSERT INTO ngp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petulo eze awaone awant'hu niyo awagamba, Wandugu zetu wa Izilaeli, nii mwehelwa mwe mbuli ino, naho nii mwakikaulisa suwe? Nyuwe mwagamba aya yadamanyika kwa udahi wetu suwe, hegu kwo uwedi kinanao kimtenda mnt'hu uyu agende? ");
INSERT INTO ngp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mnungu ywa Ibulahimu na ywa Isaka na ywa Yakobo na Mnungu ywa wakale wetu, kamwink'ha ukulu mtumwa ywakwe Yesu, mna no mumgela mwe mikono ya maseuta, niyo mwamlemela hameso ha Pilato, hata hadya Pilato aungaga amlekele. ");
INSERT INTO ngp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nakanda mnt'hu akukile naho azumilwe ni Mnungu, mna mwamlemelaga, vitendese no mumlombeza Pilato awambizeni kumlekela yudya mkomi. ");
INSERT INTO ngp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nomumkoma yudya akulongoza kwita ko ugima mna Mnungu nakamuuyula, naswe nisuwe kiyaone ayo. ");
INSERT INTO ngp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nu udahi we dizina dyakwe umgeile ludole uyu mnt'hu agende. Uyu mkumuona mummanya kadamanyilwa ayo kwa mhuwi kwa zina dya Yesu, nu mhuwi mwa Yesu nuwo umhonyile, enga ivo nyose mkudaha kuwona. ");
INSERT INTO ngp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Naho elo, ndugu zangu, hiyamanya yadya mumdamanyile Yesu nyuwe ne vilongozi wenyu, mdamanya kwaviya nomnda hamanyize. ");
INSERT INTO ngp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mnungu ayalongaga kombokela walotezi wakwe kugamba Kilisito Mkombozi nasulumizwe, naho haluse kayatenda yadamanyike kwe sila ino. ");
INSERT INTO ngp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kweiileni, mumhitukile Mnungu, vileke Mnungu awausile wavu wenyu. Mnatenda ivo, ");
INSERT INTO ngp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","lupisi va kugeligwa ludole nolwize kulawa kwa Zumbe, naho naawegaileni Yesu uyo Kilisito Mkombozi msaguilwe. ");
INSERT INTO ngp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Neekale uko kulanga mpaka Umwo vikabubula aho vint'hu vose nevidamanywe uhya, enga viya Mnungu alongile kombokela kwa walotezi wakwe awo wandaga uuko kale. ");
INSERT INTO ngp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwaviya Musa agambaga, ‘Zumbe Mnungu wenyu naawasaguileni mlotezi mgati mwa wandugu zenyu enga ivo anigale miye, naho naande yumwenga mwa want'hu wa kwenyu, muyategeleze yose naawagambileni myadamanye. ");
INSERT INTO ngp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Uneva mnt'hu yeyose hana mtegeleze mlotezi uyo, naalavigwe kulawa mwa want'hu wa Mnungu niyo kukomwa.’ ");
INSERT INTO ngp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Walotezi wose wandile no ulosi, Samweli na wose wamtimile woho nawo walongaga iki kikulaila mwa mazuwa aya. ");
INSERT INTO ngp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ndagano za Mnungu kwombokela kwa walotezi wakwe ni kwa nyuwe, naho mwihamwenga mwe yadya Mnungu alagane na wakale wenyu. Enga ivo alongaga na Ibulahimu, ‘Kombokela ko lukolo neniwavikile want'hu wose mwe isi.’ ");
INSERT INTO ngp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Naivo Mnungu kamsagula mtumwa ywakwe naho nk'hongo kamwigala kwenyu, kuwavikila kwa kuwatenda kila yumwenga ywenyu kuhituka kulawa mwe zisila zenyu ziihile.” ");
INSERT INTO ngp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petulo na Yohana wandaga wakei kusimuila na want'hu umwo walava nt'hambiko na Mkulu wa wamizi we Nyumba ya Mnungu hamwenga na Masadukayo waweziilaga. ");
INSERT INTO ngp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wandaga na maya kwaviya wegala ulosi awa waidi wawahinizaga want'hu kugamba Yesu auyukaga, kikwigala uwona kugamba, wabanike nawauyuke. ");
INSERT INTO ngp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ivo niyo wawagwila nokuwavugaila kubula zuwa ditimile, kwaviya zuwa nediswa. ");
INSERT INTO ngp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mna wose wawivaga uwo ulosi wahuwilaga, naho mwa awo wagosi du wandaga milongo magana mashano. ");
INSERT INTO ngp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mwe dizuwa dya kaidi, vilongozi wa Wayahudi na wadala vilongozi hamwenga na wahinizi wa sigilizi, wakeduganyaga mwo mzi wa Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Waduganaga hamwenga na Mlava nt'hambiko Mkulu Anasi, hamwenga na Kayafa na Yohana, na Alekizanda hamwenga na watuhu we nyumba yo Ulava nt'hambiko Mkulu. ");
INSERT INTO ngp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wawaikaga Wegala Ulosi, Petulo na Yohana hameso yawe niyo wawauza, “Mwayadamanya aya kwa ludole lwani? Naho kwa udahi wa dizina dyaani?” ");
INSERT INTO ngp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petulo akanda kamema Muye ywa Mnungu, niyo awahitula, “wadala Vilongozi wa want'hu, na wakulu, ");
INSERT INTO ngp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","uneva kiletwa dielo nakuuzwa kilonge izimbuli izedi adamanyilwe uyo aholomp'hale, naivo ahonyigwe, ");
INSERT INTO ngp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nyuwe nyose hamwenga na want'hu wose wa Izilaeli mmanye. Mnt'hu uyu akimale hameso henyu, mgima ngungulu, kwa zina dya Yesu Kilisito ywa Nazaleti, yudya mwamuwambaga mo msalaba, uyo auyulwe ni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Uyu Yesu niye yudya awandikagwa mwo Mawandiko Yakukile kugamba, ‘Diiwe diya mwadilemelaga nyuwe wazesi, dinda iwe kulu hediikuungwa kusweswa kujink'ha yose.’ ");
INSERT INTO ngp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Uyokozi walawa kwa yehe ekedu, mwe isi yose hadihali zina dyodyose hasi ye mbingu kink'higwe ni Mnungu dikudaha kukiyokola.” ");
INSERT INTO ngp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Want'hu we kitala weheelegwa kuuona weduvi wa Petulo na Yohana, nokubunk'hula kugamba wandaga ni enga want'hu watuhu wose ivo weli, naho heweina umanyi. Wabunk'hulaga naho kugamba wandaga hamwenga na Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mna hawandaga na dyodyose wadahile kulonga kwaviya nawamuona yudya mnt'hu ahonile kakimala hamwenga na wakina Petulo na miyawe Yohana. ");
INSERT INTO ngp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ivo niyo wawagamba wafose kuse ye kitala, niyo vilongozi we kitala cha Wayahudi wakonga kutalaula wohowenye. ");
INSERT INTO ngp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wakeuzaga wenye wakagamba, “Nekitende vivihi mwa want'hu awa?” “Kila mnt'hu mwo mzi wa Yelusalemu kamanya kia kihungi kikulu kidamanywe ni Petulo na Yohana, naho hakikudaha kukilemela. ");
INSERT INTO ngp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mna chaungwa kuwafingiza want'hu awa wasekulonga naho na mnt'hu yeyose kwa zina dya Yesu, vileke imbuli ino ise kugendesa mwe isi yose.” ");
INSERT INTO ngp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ivo niyo wawetanga naho kwe nyumba no kuwafingiza kugamba wasekulonga naho mwekieti hegu kuhiniza kwa zina dya Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mna Petulo na Yohana niyo wawahitula kugamba, “Lamuleni nyuwe kiya ichedi kikwelela ha meso ya Mnungu, kuwatimilani nyuwe hegu kumtimila Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwaviya hakikudaha kuleka kulonga kiya kikione na kukiva suwewenye.” ");
INSERT INTO ngp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ivo vilongozi we kitala wagendeelaga kuwafingiziza, niyo chawalekela. Nawaona kugamba nevinda vidala kuwasulumiza, kwaviya want'hu nawakamwink'ha ukulu Mnungu kwe kiya kilaile. ");
INSERT INTO ngp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yudya mnt'hu adamanyilwe ikihungi andaga na myaka ijink'hile milongo mine. ");
INSERT INTO ngp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aaho Petulo na Yohana weze walekelwe, wauyaga kwa weyawe no kuwagambila kiya wakulu wa walava nt'hambiko na wadala vilongozi ivo walongile. ");
INSERT INTO ngp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Umwo wahuwila weze weve ivo, wakeduganyaga hamwenga kwa kumlombeza Mnungu kwa moyo umwenga wakagamba, “Zumbe Muumbi wo ulanga ne isi ne bahali na vose vimndani mwawe! ");
INSERT INTO ngp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Walongaga no mkale ywetu Daudi, mtumwa ywako, kwa udahi wa Muye ywa ywako, ukagamba, ‘Nii want'hu we isi yose waihiwa, nii want'hu waikaga minyanyiko ya kihezi? ");
INSERT INTO ngp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mazumbe we isi wakeika lumwe, vilongozi nao wakeduganya hamwenga wakamhiga Zumbe na Kilisito Mkombozi amsagule.’ ");
INSERT INTO ngp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kwaviya ikindedi Helode na Pontio Pilato waduganaga mwo mzi hamwenga na want'hu hi Wayahudi na want'hu wa Izilaeli kumhiga Yesu, Mndima ywako Akukile, uyo umsagule, Kilisito Mkombozi. ");
INSERT INTO ngp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nawadamanya kila kint'hu kiya ukiikile lumwe kwa udahi no kuunga kwako kugamba nekilaile. ");
INSERT INTO ngp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Naho haluse, weye Zumbe, kaula ukutisa kwawe, naho ukizumile suwe wandima wako, kibilikize ulosi wako kwa kukeduvya. ");
INSERT INTO ngp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Chulula mkono wako uwahonye want'hu, naho damanya vilagiso va na kwehela kwa kombokela zina dyo mtumwa ywako Yesu Akukile.” ");
INSERT INTO ngp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Weze wabinde kulombeza Mnungu, hadya wandile niyo hasingisika. Wose hadya niyo wamemezwa Muye ywa Mnungu no kubilikiza Mbuli ya Mnungu kwa weduvi. ");
INSERT INTO ngp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Fyo dya wahuwila wandaga wamwenga mwe zifanyanyi zawe na mwe mioyo yawe. Hakwandile na yeyose adahile kugamba kint'hu chakwe mwenye, ila wahangilaga vint'hu vose wandaga navo. ");
INSERT INTO ngp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kwa udahi mkulu wegala ulosi walavaga uwona mwe mbuli yo kuuyuka kwa Zumbe Yesu, naho niyo Mnungu awenk'ha uwedi mwingi. ");
INSERT INTO ngp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mwo umwenga wawe hakwandaga na yumwenga andaga na uswesi wa kint'hu. Wamwenga wandaga na vint'hu vawe wavitagaga no kwink'hiza matundu yalaile mwediyombe, ");
INSERT INTO ngp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nokuzink'hiza kwa wegala ulosi, naho matundu nayapangigwa kwa kila mnt'hu kuligana viya akuviunga. ");
INSERT INTO ngp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kwandaga na Mlawi yuwenga mwelekwa ywa Kipulo, akwitangwa Yusufu, uyo wegala ulosi wakumwitanga Banaba nuko kugamba “Mgela moyo want'hu”, ");
INSERT INTO ngp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","atagaga nk'hode yakwe, niyo kuyaguha matundu nokuyenk'hiza kwa wegala ulosi. ");
INSERT INTO ngp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kwandaga na mnt'hu yumwenga etangagwa Anania, hamwenga na mkaziwe Safila, nao watagaga mgunda wawe. ");
INSERT INTO ngp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Anania afisaga matundu yamwenga, mkaziwe naye amanyaga, niyo enk'hiza yadya yasigale kwa wegala ulosi. ");
INSERT INTO ngp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petulo niyo amgamba, “Anania, nii ukamlekela Mwavu umoyo wako, niyo wamdant'hiliza Muye ywa Mnungu kwa kufisa matundu yamwenga uyapatile mokutaga umgunda wako? ");
INSERT INTO ngp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Umwo wandile ukei kuutaga mgunda, nounda wako, naho hata wize uutage matundu nayanda yako. Haluse nii ukapata ulamuzi wa kudamanya ivo? Huwadant'hilize want'hu, mna kumdant'hiliza Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aaho Anania eze eve ivo, niyo agwa hasi no kubanika. Want'hu wose wevaga imbuli iyo wengilagwa niwogofi mkulu. ");
INSERT INTO ngp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wabwanga wezaga no kuuvika sanda kimba chakwe no kugenda kukizika uko kuse. ");
INSERT INTO ngp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lupisi lwa masaa matatu ivi, mkaziwe nakengila mwe nyumba idya akanda hamanyize chochose kilaile. ");
INSERT INTO ngp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petulo niyo amgamba, “Nigambile, matundu aya nayo ye diyombe dye kindedi mtagile umgunda?” Yudya mvele niyo amhitula, “Heiye, naayo.” ");
INSERT INTO ngp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ivo Petulo niyo amuuza Yudya mvele, “Nii weye na mgosiyo mwivana kumgeza Muye ywa Zumbe? Want'hu wammosaga msanga mgosiyo weyaha homnango, naho nawakwinule weye nawe!” ");
INSERT INTO ngp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aaho yudya mvele niyo agwa no kubanika. Wadya wabwanga niyo weza no kuwona kugamba nakafa, ivo niyo wamwinula no kummosa msanga hagihi na mgosiwe. ");
INSERT INTO ngp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Fyo dya wahuwila wa Kilisito dyose na want'hu watuhu nawengilwa ni wogofi. ");
INSERT INTO ngp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Vihungi vingi na vakwehela nevikadamanywa ni wegala ulosi mgati mwa want'hu. Wahuwila wose nawakadugana kwa moyo umwenga mwo ukumbi wa Sulemani. ");
INSERT INTO ngp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hakwandile na yeyose wakuse ye dibunga agezile kukelunga nawo hata vandile want'hu nawaka walongela vedi. ");
INSERT INTO ngp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mna want'hu wengi wagosi na wavele nawakelunga mwe difyo dyao, nokutenda fyo dya wakumhuwila Zumbe dyongezekela. ");
INSERT INTO ngp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Niyo vanda mwa yadya nayakadamanywa ni wegala ulosi, wanyonge nawakenulwa mwe zisila no kuikwa mwe vigonelo vileke kizuli du cha Petulo kiwagubike wamwenga umwo akomboka. ");
INSERT INTO ngp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Naho mafyo ya want'hu yezaga kulawa kwe mizi izunguluke Yelusalemu, wakawegala wose wandile wakalumwa, wadya wandile na mp'hepo, na wose wahonyagwa. ");
INSERT INTO ngp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wakulu wa walava nt'hambiko, hamwenga na want'hu wose we dibunga dya Masadukayo, niyo wengila finju kwe wegala ulosi, ivo nawalamula kuwa tendela vihile. ");
INSERT INTO ngp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nawawagwila wegala ulosi niyo wawagela kwe divugailo. ");
INSERT INTO ngp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mna kilo ikia mtumigwa ywa Zumbe akomolaga ulwivi lwe divugailo, na kuwalava kuse wegala ulosiwa, niyo awagamba, ");
INSERT INTO ngp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Iteni mkakimale kwe Nyumba ya Mnungu, muwagambile want'hu mbuli zose zo ugima mhya.” ");
INSERT INTO ngp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wagela Ulosi niyo watoza isigilizi, iviya kisingi wengilaga kwe Nyumba ya Mnungu no kukonga kuhiniza. Wakulu wa walava Nt'hambiko hamwenga na weyawe, wawetangaga want'hu wose we kitala na wadala vilongozi we Kiizilaeli, niyo wasigila uko kwe divugailo kuwaguha wegala ulosi no kuwaleta hameso yawe. ");
INSERT INTO ngp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mna wamizi we Nyumba ya Mnungu weze wabule, hawawaonaga wegala ulosi awo mwe divugailo, ivo wauyaga kwe Kitala no kuwagambila, ");
INSERT INTO ngp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kize kibule kwe divugailo nekidibwila divugailo divugalwa ndindili, naho wamizi wose nawanda meso mwe zink'hili, mna kize kikomole zinyivi hakione mnt'hu yeyose kundani!” ");
INSERT INTO ngp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Umwo Wakulu wa walava nt'hambiko na yudya mkulu wa wamizi we Nyumba ya Mnungu weze weve ivo, na weheelwa kugamba wegala ulosi wadigwa nii. ");
INSERT INTO ngp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Niho aweziilaga mnt'hu akawagamba, “Tegelezeni! Want'hu wadya muwavugaile kwedivugailo wekwe Nyumba ya Mnungu, wahiniziza want'hu!” ");
INSERT INTO ngp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ivo mkulu wa wamizi, hamwenga na want'hu wakwe, wagendaga kuwavuza kwa mp'hahalahole kwaviya wogohaga want'hu sema wana watowe maiwe. ");
INSERT INTO ngp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wawengizaga kundani, na kuwakimalisa hameso ye kitala, niyo mkulu wa walava nt'hambiko awauza mbuli wegala ulosi. ");
INSERT INTO ngp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Niyo awagamba, “Nyuwe nekiwalemezesa mse kubilikiza kwa dizina dyo mnt'hu uyu. Mna kauleni ivo mdamanye! Mgendeza mahinizo yenyu mwe Yelusalemu yose, naho mwaunga mkitende kugamba suwe nisuwe kimkomile!” ");
INSERT INTO ngp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Niyo Petulo na wegala ulosi weyawe wahitula, “Chaungwa kumwogoha Mnungu, hiyo mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mnungu ywa wakale wetu amuuyulaga Yesu aho nyuwe mwize mumkome kwa kuhweleza mwo mti. ");
INSERT INTO ngp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mnungu amwikaga mwe nt'hunyo yakwe kwa kumtenda kilongozi na mlokozi, kuwenk'ha Wazilaeli luneka lwa kweiila no kuusilwa wavu wawe. ");
INSERT INTO ngp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nisuwe kikulonga uwona we zimbuli izi, hamwenga na Muye ywa Mnungu, uyo niye enk'hizwe kwa wose wakumwiva Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wadya want'hu we kitala weze weve ivo niyo wafa maya, wakaunga wawakome wadya wegala ulosi. ");
INSERT INTO ngp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mna yumwenga mwa Mafalisayo etangagwa Gamalieli andaga mhinizi wa sigilizi, naho uyo azumilagwa vitendese ni want'hu wose, akimaalaga he Kitala, niyo awagambaga wegala ulosi wande kufosa kuse ludodo. ");
INSERT INTO ngp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Niyo awagamba want'hu we Kitala, “Wambuyazangu Waizilaeli mnde na wengele kwa kia mkuunga muwadamanyile want'hu awa. ");
INSERT INTO ngp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mwakumbukila kugamba alailaga Teuda mazuwa yomboke akaketogola kunda mnt'hu mkulu, niyo want'hu wabulaga magana mane wamzumilaga na kukelunga naye, Mna niyo akomwa, wose nawakamtimila niyo wa mwaganika, kafyo kakwe niyo kaganika. ");
INSERT INTO ngp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Akajika naho, niyo alaila Yuda ywa Wagalilaya, mo kuwaza want'hu, uyu naye apataga want'hu wabindile wingi mna naye akomagwa, niyo want'hu wamtimila wamwaganika. ");
INSERT INTO ngp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Naivo nawagambilani, mwe mbuli ino msekuwatenda dyodyose want'hu awa, walekeni wenye. Uneva iki wakudamanya chalawa mwe zifanyanyi za want'hu, nekisunguze kwaganika, ");
INSERT INTO ngp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","mna uneva ni cha Mnungu, homdahe kuwafingiza, kwaviya nomkebwiile mmo kuhigana na Mnungu!” Kitala chatimilaga milosi ya Gamalieli. ");
INSERT INTO ngp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wawetangaga naho awo wegala ulosi, niyo wawatowa mikotya, no kuwafingiza wase kuhiniza naho kwe dizina dya Yesu niyo wawalekela. ");
INSERT INTO ngp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Wagela Ulosi weze wafose mwe kitala wandaga na kinyemi kwaviya Mnungu awenk'haga kuwagilwa kugeligwa soni kwajili ye dizina dya Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Naho mazuwa yose mwe Nyumba ya Mnungu na mwe zinyumba za want'hu, wegala ulosi wagendeelaga kuhiniza no kubilikiza Mbuli Yedi ya Yesu Kilisito kugamba niye Mkombozi asagulwe. ");
INSERT INTO ngp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ize yajike aho, enga ivo wanamp'hina nawakongezekela, kwa swesaga muivano mwa Wayahudi wakulonga Kigiliki, na Waibulania. Wayahudi wakulonga Kigiliki nawakalabila kugamba wavele wakwawe wabanikilwe na walume zawe, wajaligwa mwo upasi we nk'hande wa kila zuwa. ");
INSERT INTO ngp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kwa ivo wadya wegala ulosi mlongo na waidi niyo wetanga idifyo digima dya wanamp'hina wose na kuwagamba, haviwagilwe kwa suwe kuleka kubilikiza mbuli ya Mnungu, vileke kikaule mbuli yo upasi we vint'hu. ");
INSERT INTO ngp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Elo wandugu zetu, saguleni want'hu mfungate mwa nyuwe wamanyike kunda na Muye ywa Mnungu no umanyi, nekiwaike kunda wakimalizi we mbuli ino yo upasi. ");
INSERT INTO ngp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Naivo suwe nekinde ne ndima yo kumlombeza Mnungu no kubilikiza. ");
INSERT INTO ngp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Fyo dyose dyelelagwa ne zifanyanyi za wegala ulosi, niyo wawasagula Sitefano mnt'hu mta mhuwi mkulu na Muye ywa Mnungu na Filipo na Pulokola na Nikono na Timoni na Palamena hamwenga na Nikolasi hi myahudi kulawa Antiokia, uyo atendagwa kunda mwe dini ye Kiyahudi aho nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kafyo ako kegalagwa kwa wegala ulosi, niyo wegala ulosi wawageleka mikono no kuwavikila. ");
INSERT INTO ngp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Naivo mbuli ya Mnungu yageendelaga kugendezwa, wanamp'hina mwe Yelusalemu wagenyelaga na kugenyela, naho walava nt'hambiko wabindile ingi wamhuwilaga Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitefano enk'hagwa uwedi wa Mnungu vitendese na kwink'hwa udahi ni Mnungu, adamanyaga vilagiso na kweheela mwa want'hu. ");
INSERT INTO ngp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mna na ahigagwa ni want'hu wamwenga we nyumba yo mviko neiketangwa nyumba ya walekelwa, yawaduganyaga hamwenga Wayahudi kulawa Kilene, na Alekizandilia. Awa wandaga Wayahudi wandaga watumwa, mna wenk'hagwa ulekelwa wawe. Vandaga ni hamwenga na Wayahudi kulawa Kilene na Ekizandilia. Woho na wayahudi watuhu kulawa mikoa ya Kilikia na Asia wakongaga kuhigana na Sitefano. ");
INSERT INTO ngp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mna Muye ywa Mnungu amwink'haga Sitefano umanyi wedi naho umwo andile akalonga, hawadahile kumhuma. ");
INSERT INTO ngp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ivo wazungulaga want'hu no kuwenk'ha matundu vileke walonge lulimi kugamba, “Nekimwiva akambela vihile Musa na kumbela Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwa ivo na wakasongeleza want'hu, wadala vilongozi, na wahinizi wa miko ya Musa. Wamgwilaga Sitefano kumwigala kwe Kitala. ");
INSERT INTO ngp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Niyo wetanga want'hu kwiza kulonga udant'hi mwa Sitefano. Niyo wagamba, “Mnt'hu uyu hakuleka kuibela vihile Nyumba ikukile ya Mnungu, hamwenga ne miko ya Musa. ");
INSERT INTO ngp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Chamwivaga akagamba, uyu Yesu wa Nazaleti naaimole Inyumba ya Mnungu no kuihitula miko yose kiihokele kwa Musa!” ");
INSERT INTO ngp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wose wekalaga he kitala wamn'goelaga meso Sitefano no kuwona kugamba ifuta yakwe yang'alaga enga futa ya mtumigwa ywa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mlava nt'hambiko Mkulu amuuzaga Sitefano, “Iki kindedi?” ");
INSERT INTO ngp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefano niyo ahitula, “Wandugu zangu, nitegelezeni! Umwo mkale ywetu Ibulahimu andaga akei kuita uko Halani, Mnungu ywo ukulu amlailaga uko Mesopotamia ");
INSERT INTO ngp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","niyo amgamba, ‘Waleke want'hu wako ne isi yako naho uite kwe isi huunga hulagise.’ ");
INSERT INTO ngp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ibulahimu ailekaga isi yakwe ya Wakalidayo niyo agenda kwikala Halani. Aho ise dya Ibulahimu eze abanike, Mnungu amtendaga Ibulahimu asogele mwe isi ino mkwikala ivi haluse. ");
INSERT INTO ngp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mnungu hamwink'haga hohose mwe isi iyo kunda hakwe hata hant'hu hadodo mwe isi, Mna Mnungu amwikilaga ndagano kumwink'ha isi iyo, naho iyo neikanda yakwe hamwenga ne cheleko chakwe. Umwo Mnungu aikaga indagano iyo Ibulahimu andaga heina mwana. ");
INSERT INTO ngp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Naivi nivo alongaga Mnungu kwa Ibulahimu, ‘Cheleko chako nekikale kutanga, naho uko nawande watumwa, naho nawatendelwe yaihile kwa myaka milongo mine. ");
INSERT INTO ngp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mna nenombose usengelo kwa wadya wa kuwatendani watumwa, Mnungu kagamba, akajika nenikilave cheleko chenyu mwe isi iyo naivo nawanivike miye hant'hu aha.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Niyo Mnungu atenda wila wa kumvina Ibulahimu kunda kilagiso che ndagano. Ivo Ibulahimu niyo amvina Isaka mazuwa mtandatu du eze elekwe, Isaka niyo eza kumvina mwanawe Yakobo, Yakobo naye niyo eza kuwavina wadya wanawe mlongo na waidi, awakale wo lukolo lwetu. ");
INSERT INTO ngp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Wana Yakobo wamuwonelaga finju ndugu ywawe Yusufu niyo wamtaga kwo utumwa uko Misili. Mna Mnungu andaga hamwenga naye Yusufu, ");
INSERT INTO ngp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","niyo amkombola mwa makunt'ho yakwe. Mnungu amwink'haga Yusufu uwedi wakwe na umanyi hameso ya seuta ywa Misili akwitangwa Falao, Yudya Seuta ywa Misili niyo amtenda Yusufu kunda mkulu mwe isi na mwe nyumba yakwe yose. ");
INSERT INTO ngp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Niyo kwalaila gumbo kulu mwe isi ya Misili ne isi ya Kanani, yawatendaga wakale wetu kunda na makunt'ho makulu. Wakale wetu hawadahaga kupata chochose cho kudya. ");
INSERT INTO ngp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo eze eve kugamba Misili kuna nk'hande, niyo awatuma wadya wanawe awo wakale wetu, waite Misili malavo yao ya nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mwe nt'hambo yawe ya kaidi Yusufu akelavanyaga kwa wanduguze, Falao niyo aimanya imp'huga ya Yusufu. ");
INSERT INTO ngp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu egalaga want'hu kwa ise Yakobo, amgambile hamwenga ne mp'huga yose, uwazilo wawe wandaga ni milongo mfungate na shano, weze Misili. ");
INSERT INTO ngp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ivo Yakobo aitaga Misili yehe hamwenga na wakale wetu watuhu, na uko nuko wafiilaga. ");
INSERT INTO ngp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Vimba vawe vegalagwa mpaka Shekemu, niyo wamosigwa msanga mwe kikuta agulaga Ibulahimu kwa want'hu wa kabila dya Hamoli kwa matundu heyemanyike uwazilo wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Want'hu wetu kudya Misili wagenyelaga niyo wanda wabindile ingi aho Mnungu andaga akaunga akint'hize indagano yakwe aikaga na Ibulahimu. ");
INSERT INTO ngp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kulongole, seuta yumwenga hammanyaga Yusufu, akongaga kunda seuta ywa Misili. ");
INSERT INTO ngp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Awatendelaga want'hu wetu ukwank'walu, kuwadamanyila wiihi kuwatigiza wawaduule kuse wana wawe wakembe vileke wabanike. ");
INSERT INTO ngp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aho niho elekagwa Musa mwana mkembe mtana. Alelagwa kwawe kaya kwa miyezi mitatu, ");
INSERT INTO ngp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","eze aikigwe kuse ye kaya yawe, mwana kindele ywa Falao amguhaga Musa no kumlela enga mwanawe. ");
INSERT INTO ngp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa ahinizwagwa umanyi wose wa Wamisili, niyo akula kwa milosi na udamanyi. ");
INSERT INTO ngp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musa eze abule myaka milongo mine afanyanyaga kuwaona wanduguze Waizilaeli. ");
INSERT INTO ngp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aonaga Mzilaeli yumwenga akatoigwa nu Mmisili, niyo agenda kumwambiza no kumlihizila kwa kumkoma uyo Mmisili. ");
INSERT INTO ngp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Agambaga mafa wanduguze Wazilaeli wadahaga kumanya kugamba Mnungu aunga awakombole kwa kombokela yehe Musa, mna hawakombaganyaga. ");
INSERT INTO ngp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Zuwa ditimile awaonaga Wazilaeli waidi wakatoana, agezaga kuwalamula. ‘Tegelezeni, nyuwe want'hu, mwindugu wa hamwenga Wazilaeli, Mwatowanilanai?’ ");
INSERT INTO ngp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mna yudya yumwenga naakamtoesa miyawe niyo amsindikila kunk'handa Musa, akamgamba, ‘Niani akuikile kunda mkulu na mlamuzi ywetu?’ ");
INSERT INTO ngp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Waunga mnikome enga viya umkomile Mmisili gulo?’ ” ");
INSERT INTO ngp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa eze eve ivo, niyo anyilika Misili kuita Midiani. Uko elekaga wana wakilume waidi. ");
INSERT INTO ngp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ize yomboke myaka milongo mine, Mtumigwa ywa kwe mbingu amlailaga Musa mwo lulija lukwaka mwa kasaka, ukwo kwe dijangwa hagihi no mnima wa Sinai. ");
INSERT INTO ngp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa ehelwagwa kwa ayo ayaonaga, niyo asogela hagihi hakasaka vileke akaule vedi. Mna niyo eva izwi dya Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ni miye Mnungu ywa wakale wako, Mnungu ywa Ibulahimu, Mnungu ywa Isaka na Yakobo.’ Musa ogohaga na kuzingiza hagezile kukaula. ");
INSERT INTO ngp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Zumbe niyo amgamba Musa, ‘Hambula vilatu vako, aho ukimale ni hant'hu hakukile. ");
INSERT INTO ngp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Hiuona ukwank'walu uwo wakutendelwa want'hu wangu ukwo Misili. Hiiva indilo yawe, hiseela kwiza kuwakombola. Nohutume uite Misili.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa niye yudya alemelwagwa ni Waizilaeli. Wamuuzaga. ‘Niani akugambile unde mkulu na kunda mlamuzi ywetu?’ Niyehe uyo atumigwe ni Mnungu kuwalongoza want'hu no kuwakombola kwa wambizi wa mtumigwa ywa kwe mbingu, uyo amlailaga mwa kasaka kakukweela moto. ");
INSERT INTO ngp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Awalongozaga mwo kufosa Misili, akadamanya vilagiso na kwehela ukwo Misili na kwe bahali ink'hudu, na kwe dijangwa kwa myaka milongo mine. ");
INSERT INTO ngp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa niye awagambaga watu wa Izilaeli, ‘Mnungu na awasaguileni Mlotezi enga miye, kulawa mwa wandugu zenyu.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Niye yudya andaga hamwenga na want'hu wa Izilaeli wakeduganyaga kwe dijangwa, andaga uuko hamwenga na wakale wetu hamwenga no mtumigwa ywa kwe Mbingu alongaga naye kwo mnima wa Sinai, naho ahokelaga milosi yo ugima eze akigambile suwe. ");
INSERT INTO ngp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mna wakale wetu wamlemelaga kumwiva niyo wamsukumizila kunk'handa, no kunyemwa nyemwa kuuya Misili. ");
INSERT INTO ngp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wamgambaga Haluni, ‘Kidamanyile mnungu akuunga akilongoze, kwaviya hakikumanya ayo yambwiile Musa, uyo akilavile Misili.’ ");
INSERT INTO ngp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wadamanyaga hili dikeigile njeku, wakaditendela nt'hambiko, wakavika kint'hu wakidamanye woho wenye. ");
INSERT INTO ngp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ivo Mnungu niyo awasa, na kuwaleka wavike nt'hondo zo ulanga, enga ivo viwandikwe mwe kitabu cha walotezi kugamba. ‘Nyuwe want'hu wa Izilaeli! Hamwandile mwi wangu hiyo miye nomkanilavila nt'hambiko kwa malavo milongo mine mwe dijangwa. ");
INSERT INTO ngp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nyuwe nomwinula heha dya Moleki, ne kizuli cha Lefani, yumwenga mwe milungu nt'hondo yenyu, nayanda mahili mwayadamanyaga nt'hambiko. Ivo elo neniwasamizeni mwite kujink'ha Babiloni.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Wakale wetu wandaga ne Dihema dya ulonga uwona uko kwedijangwa. Dyadamanyagwa enga viya mwenye Mnungu amsigiilaga Musa, kugamba didamanywe enga iviya Musa alagiswe. ");
INSERT INTO ngp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Akajika naho, wakale wetu wadihokelaga diheha kulawa kwa watatizawe wandaga nadyo umwo wakanda na Yoshua, no kuzitaha ziisi kulawa kwe zink'holo zia Mnungu azigulusaga enga viya waziguhaga. Naho nedikala mpaka mwa mazuwa ya Daudi. ");
INSERT INTO ngp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi ahokelaga uwedi, niyo amlombeza Mnungu amwink'he hant'hu hakumzengela wikazi Mnungu ywa Yakobo. ");
INSERT INTO ngp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mna niyo Sulemani amzengela Mnungu nyumba. ");
INSERT INTO ngp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Mna Mnungu ekulanga mwa yose hakwikala mwe zi nyumba zizengigwe ni mikono ya want'hu enga viya mlotezi akulonga, ");
INSERT INTO ngp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Zumbe agamba, ‘Mbingu nidyo difumbi dyangu dyo Useuta, isi niyo huikila iviga vangu. Ni nyumba ya vivihi mkudaha kunizengela? Heihi aho miye huunga nikale? ");
INSERT INTO ngp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Vint'hu ivi voseni himiye nividamanye?’ ” ");
INSERT INTO ngp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Niyo Sitefano agendeela kulonga, “Nyuwe mna kigungu mtwi! Mioyo yenyu inda midala, magutwi yenyu hayakwiva ulosi wa Mnungu! Mnda enga wakale wenyu, nyuwe nanywe mwaungisa kumhiga Muye ywa Mnungu! ");
INSERT INTO ngp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Togoleni eyuko mlotezi yeyose hesulumizwe ni wakale wenyu? Wawakomaga walotezi, awo walongaga ukwiza kwa yudya Mndima wo Uwedi. Naho haluse mumsezenga no kumkoma. ");
INSERT INTO ngp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ni nyuwe mwaihokelaga miko ya Mnungu idya yegalagwa ni mtumigwa ywa kwe Mbingu, mna mwiibela.” ");
INSERT INTO ngp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Umwo wadala we Kitala weze weve ivo Sitefano akulonga, wafaga maya niyo wagwegwejula meno kwa maya. ");
INSERT INTO ngp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mna Sitefano, amemigwe ni Muye ywa Mnungu, asinyaga kulanga no kuuona ukulu wa Mnungu, Yesu naye kakimala kulume kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Niyo Sitefano agamba, “Kauleni nauona ulanga ukomoka, naho Mwana Mnt'hu kakimala kulume kwa Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Wadala we Kitala wagutilisaga, kwa mikono yawe wasitaga magutwi. Niyo wose kwa hamwenga wamkump'hukila, ");
INSERT INTO ngp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","no kumduula kuse yo mzi niyo wamtowa maiwe. Wadya waone niyo waika suke zawe kwa ndugu ywetu akwitangwa Sauli. ");
INSERT INTO ngp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Umwo wandile wakamtowa maiwe Sitefano, yehe amlombezaga Mnungu akagamba, “Zumbe Yesu, hokela umuye wangu!” ");
INSERT INTO ngp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Afikaga madi niyo aila kwa izwi kulu akagamba, “Zumbe! Use kukumbukila wavu wawe!” Alongaga ivo niyo abanika. ");
INSERT INTO ngp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Naho Sauli alongaga uwona wo ukomi wakwe. Mwe dizuwa diya want'hu wamhuwile Kilisito mwe Yelusalemu wakongaga kukunt'hizwa kikwank'walu. Want'hu wose, kuleka wegala ulosi, wasambalaga uko Yuda na Samalia. ");
INSERT INTO ngp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Want'hu wa Mnungu wamwenga wammosaga msanga Sitefano, no kumhongezela kwa ndilo nk'hulu. ");
INSERT INTO ngp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sauli agezaga kudisulumiza difyo dya wahuwila wa Kilisito. Awalavaga kuse ye zinyumba Zawe awo wahuwila, na kuwagela kwe divugailo. ");
INSERT INTO ngp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wadya wahuwila wasambalaga kose kudya wanyilikilaga wabilikizaga Mbuli Yedi. ");
INSERT INTO ngp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo aitaga kwe mizi ya Samalia na kumbilikiza kugamba Yesu Kilisito niye Mkombozi. ");
INSERT INTO ngp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mafyo ya want'hu wandaga na nt'hegelezi mwa yadya naakalonga Filipo, kwaviya nawakamwiva, no kuwona vilagiso vingi adamanyaga. ");
INSERT INTO ngp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mp'hepo nezikawafosa want'hu kwa maizwi makulu ya ndilo, na wose wabindile ingi waholomp'hale ne viwete wose wahonyagwa. ");
INSERT INTO ngp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Naivo kwandaga na kinyemi kikulu mwo mzi udya. ");
INSERT INTO ngp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kwandaga na mnt'hu yumwenga ekalaga aho, zina dyakwe etangagwa Simoni, awehelaga want'hu wo mzi wa Samalia kwa kudamanya usai wakwe. Naaka keduvya kugamba yehe andaga mnt'hu yumwenga mkulu, ");
INSERT INTO ngp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","naho kila yumwenga mwo mzi uwo mwa malika yose, wamwogohesaga, wakagamba, “Yehe niye udahi wa mnungu amanyike enga ‘Udahi Mkulu’,” ");
INSERT INTO ngp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nawakamwogohesa kwaviya kwa lupisi lutali naaka wehela ko usai wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Umwo weze wahuwile Filipo akabilikiza Mbuli Yedi yo Useuta wa Mnungu, na za Yesu Kilisito, wabatizagwa wose wogosi kwa wavele. ");
INSERT INTO ngp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni mwenye naye ahuwilaga, naho ize inde kabatizwa, ekalaga hagihi na Filipo naho ehelagwa umwo aonaga vakwehela vikulu na vihungi vandaga vikadamanywa. ");
INSERT INTO ngp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wegala Ulosi wa Yelusalemu wevaga kugamba want'hu wa Samalia wahokela mbuli ya Mnungu, ivo niyo wawegaila Petulo hamwenga na Yohana. ");
INSERT INTO ngp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Weze wabule nawalombezelaga kwa Mnungu vileke wahokele Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kwaviya Muye ywa Mnungu andaga akei kwiza kwa yeyose mwawe, nawabatizwa du kwe dizina dya Zumbe Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Niho Petulo na Yohana wawageleka mikono mwawe, niyo wahokela Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni aonaga kugamba wahuwila wahokela Muye ywa Mnungu aho wegala ulosi weze wawageleke mikono. Ivo aungaga kuwenk'ha matundu Petulo na Yahana, ");
INSERT INTO ngp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","no kuwagamba, “Nink'heni udahi uno name vileke inde kila huunga nimgeleke mikono ahokele Muye ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mna Petulo niyo amhitula kugamba, “Weye na matundu yako kagiileni hale, kwaviya weye wagamba udahi wa Mnungu waguligwa kwa matundu. ");
INSERT INTO ngp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Huna hant'hu, hegu kuhangila mwe ndima yetu kwaviya moyo wako hauwagilwe mwa meso ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kwaivo mhitukile Zumbe vileke zifanyanyi zako ziihile, naho mnombeze vileke akuusile weye zifanyanyi enga izi. ");
INSERT INTO ngp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Naona kugamba kumemwa ni finyu naho umvugailwa wa wavu.” ");
INSERT INTO ngp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni niyo awagamba Petulo na Yohana, “Nilombezeleni kwa Zumbe, disekunilaila dyodyose mwa aya mkulonga.” ");
INSERT INTO ngp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petulo na Yohana weze wajike kulava uwona no kugendeza kose ulosi wa Zumbe, niyo wauya Yelusalemu. Umwo mwe sila wabilikizaga Mbuli Yedi ya Mnungu mwe zikaya zibindile ingi za Samalia. ");
INSERT INTO ngp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mtumigwa ywa Zumbe amgambaga Filipo, “Keike lumwe wiite kwa mwenye mzi, kwe sila ikulawa Yelusalemu kuita Gaza.” Sila ino haikugendwa mazuwa aya. ");
INSERT INTO ngp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipo akeikaga lumwe niyo aita. Mnt'hu yumwenga ywa Isiopia andaga mgosi afunt'higwe, naho andaga mnt'hu mkulu amanyike, mkulu we kindolo chose cha Kandake, seuta ywe kivele ywa Isiopia. Andaga uko Yelusalemu akamvika Mnungu, ");
INSERT INTO ngp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","andaga akauya kaya Mwe ditololi dyakwe. Umwo andaga akagendeza, andaga kagubula kitabu cha mlotezi Isaya. ");
INSERT INTO ngp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Muye ywa Mnungu niyo amgamba Filipo, “Ita hagihi ne diya ditololi, unde hagihi nadyo.” ");
INSERT INTO ngp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo adigulukila niyo amwiva yudya mnt'hu akasoma kulawa mwe kitabu cho mlotezi Isaya. Filipo amuuzaga, “Togola wakombaganya icho ukusoma?” ");
INSERT INTO ngp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mkulu niyo ahitula, “Nenikombaganye vivihi haheina mnt'hu wa kunitambalisa?” Niyo amgamba Filipo akwele mwe ditololi no kwikala hamwenga naye. ");
INSERT INTO ngp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Uwo Mawandiko Yakukile naakasoma uyo mnt'hu yandaga ivi. “Enga viya ngoto ikwigalwa ko kuchinjwa, enga viya Mwanangoto heekuila akamogigwa mazoya, halongile mbuli. ");
INSERT INTO ngp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nakagelekwa uhuza, na kuswesa kuwagilwa kwakwe. Niani akudaha kusimuila, mbuli ze cheleko chakwe, Kwaviya wikazi wakwe mwe isi ubula kwo uheelo.” ");
INSERT INTO ngp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yudya mkulu niyo amgamba Filipo, “Hake nigambile, niyuhi akulongwa nu mlotezi? Akelonga mwenye, hegu eyuko mtuhu?” ");
INSERT INTO ngp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo akongaga kulonga, akakongela nk'hongo yo ulosi wo Mawandiko Yakukile, akamgambila Mbuli Yedi ya Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Umwo wandile wakagenda hasi mwe sila, wabulaga hant'hu hana mazi, niyo mkulu yudya agamba, “Aha hana mazi, nafingizwa nii nisekubatizwa?” ");
INSERT INTO ngp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo niyo amgamba, “Wadaha kubatizwa uneva wahuwila kwo umoyo wako wose.” Yudya mnt'hu niyo ahitula, “Nahuwila, nahuwila kugamba Yesu Kilisito ni Mwana ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yudya mkulu niyo asigiila ditololi dikimale, niyo Filipo hamwenga na yudya Mkulu waseela hasi mwa mazi, niyo Filipo ambatiza. ");
INSERT INTO ngp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Umwo weze wafose mwa mazi, Muye ywa Mnungu niyo amguha Filipo, niyo ahalawa ha meso ya yudya mkulu. Yudya mkulu hamuwone naho, mna nakagendeela no utafi wakwe amemigwe ni kinyemi. ");
INSERT INTO ngp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo naketukila kabula uko Azoto, niyo agendeela no kubula Kaisalia, mwe sila abilikizaga Mbuli Yedi ya Mnungu mwe kila mzi. ");
INSERT INTO ngp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mna Sauli agendeelaga kutisa na kufanyanya kuwakoma wanamp'hina wa Zumbe. Aitaga kwa Mlava nt'hambiko Mkulu ");
INSERT INTO ngp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","niyo alombeza baluwa zikumwink'ha udahi wa kuita kwe zinyumba zo kuvika uko Damesiki, vileke anawabwiila want'hu we sila iyo ya Zumbe wagosi na wavele, awagwile no kuwegala Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sauli eze abule hagihi no mzi wa Damesiki, aaho ung'azi kulawa kulanga wa mmwekelaga nt'hendelo zose. ");
INSERT INTO ngp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Agwaga hasi niyo eva izwi dikumwitanga, “Sauli! Sauli! Nii wanigela makunt'ho?” ");
INSERT INTO ngp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli niyo auza, “Weye niwe ani, Zumbe?” Izwi niyo dya hitula, “Ni miye Yesu, ukunigela makunt'ho.” ");
INSERT INTO ngp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Mna kimala wingile mwo mzi, ukwo noukagambilwe yo kudamanya.” ");
INSERT INTO ngp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wadya want'hu wandaga hamwenga na Sauli, wakimalaga heweeina dya kulonga, wadiivaga idizwi mna hawaonaga mnt'hu yeyose. ");
INSERT INTO ngp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli akimaalaga na kufinyula meso yakwe, mna haonaga chochose. Ivo niyo wamtoza mkono no kumlongoza kwo mzi wa Damesiki. ");
INSERT INTO ngp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kwa mazuwa matatu hadahaga kukaula, aho hose andaga hakudya naho hakunywa chochose. ");
INSERT INTO ngp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kwandaga na mwanamp'hina yumwenga mwo mzi wa Damesiki etangagwa Anania. Enk'hagwa uwona ni Mnungu akamgamba, “Anania!” Anania niyo etika, “Longa na miye Zumbe” ");
INSERT INTO ngp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Zumbe niyo amgamba, “Keike lumwe uite kwe sila ichumile, kwe nyumba ya Yuda, ukauze mnt'hu alaile Taso zina dyakwe Sauli. Alombeza Mnungu ");
INSERT INTO ngp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","naho mwo uwona wakwe, kaona mnt'hu akwitangwa Anania akengila no kumgeleka mikono vileke adahe kuwona kaidi.” ");
INSERT INTO ngp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania niyo amhitula, “Zumbe, want'hu wengi wanigambila zimbuli zo mnt'hu uyo, no makunt'ho yose awatendele want'hu wako uko Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naho ivo keza Damesiki akanda na udahi kwa kutumigwa ni wakulu wa walava nt'hambiko, awagwile wose wakukuvika weye.” ");
INSERT INTO ngp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Zumbe niyo amhitula Anania, “Ita, kwaviya himsagula kunda mndima ywangu, kuditenda zina dyangu dimanyike kwa wadya hi Wayahudi, na kwa mazumbe, na kwa want'hu wa Izilaeli. ");
INSERT INTO ngp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Naho miye mwenye nenimlagise yose akuunga asulumizwe kwe dizina dyangu.” ");
INSERT INTO ngp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ivo Anania aitaga no kwingila mwe nyumba idya andaga umwo Sauli, nokumgeleka mikono. Anania niyo amgamba Sauli, “Ndugu yangu Sauli, Zumbe Yesu yudya akulaile mwe sila umwo wandile ukeza aha, kanituma vileke wink'we kuwona vituhu, naho uhokele Muye ywa Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aho vint'hu vikwinga makobembe ya samaki yatomokaga kulawa mwa meso ya Sauli, niyo adaha kukaula naho. Akimaalaga niyo abatizwa, ");
INSERT INTO ngp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","eze adye nk'hande niyo nguvu zamuuiya naho. Sauli ekalaga kwa mazuwa mageke na wanamp'hina aho Damesiki. ");
INSERT INTO ngp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Aitaga luholuho kwe nyumba yo kuvikila no kukonga kubilikiza kugamba Yesu mi mwana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wose wamwivaga Sauli wehelagwa na kuuza, “Uyu hiye yudya andaga akawakoma wose nawakamvika Yesu kudya Yelusalemu? Naho hezile aha mwe mbuli yo kuwagwila want'hu no kuwegala kwa wakulu wa walava nt'hambiko?” ");
INSERT INTO ngp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mna mabilikizo ya Sauli yagendeelaga kunda na udahi mkulu, no ulavanyi wakwe kugamba Yesu niye Kilisito Mkombozi asagulwe ni Mnungu, nouwatenda Wayahudi wandaga wakekala Damesiki wase kudaha kuuza dyodyose. ");
INSERT INTO ngp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mazuwa mengi yeze yande yagendeela, Wayahudi wekalaga hamwenga wakaika mzungu wo kumkoma Sauli, ");
INSERT INTO ngp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mna Sauli nakagambilwa mizungu yawe. Kilo na msi nawakamogola mwe mizi vileke wamkome. ");
INSERT INTO ngp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mna kilo kimwenga, wanamp'hina awo wandaga na Sauli wamguhaga niyo wamlava kwa kumseleza mwe dilanga dyo lukazi lwa zungulukaga mzi akanda mwe digahu dinyinyigwe luzigi. ");
INSERT INTO ngp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli aitaga Yelusalemu niyo ageza kukelunga na wanamp'hina mna hawamzumilaga kugamba andaga mwanamp'hina kindedi, naho wose wandaga wakamogoha. ");
INSERT INTO ngp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Banaba ezaga kumguhuha na kumwambiza kumwigala kwa wanamp'hina. Awatambalisaga vedi ivo Sauli amuone Zumbe na ivo walonganye. Awagambilaga iviya iviya ivo Sauli naakabilikiza kwa kweduvya mwe dizina dya Yesu uko Damesiki. ");
INSERT INTO ngp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sauli ekalaga nawo naho waitanyaga Yelusalemu wakabilikiza kwa weduvi mwe dizina dya Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Naho atalaulaga na Wayahudi wakulonga Kigiliki mna hawamzumile, naho wagezaga kumkoma. ");
INSERT INTO ngp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wandugu wahuwila weze wabunk'hule ivo, wamwigalaga Sauli kwo mzi wa Kaisalia, no kumtuma aite Taso. ");
INSERT INTO ngp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Naivo aho niyo idifyo dya want'hu wamhuwile Kilisito dyekala mp'heho tondolo, mose mwe Yuda na Galilaya na Samalia. Kwa wambizi wa Muye ywa Mnungu, want'hu wa Mnungu nawenk'higwa udahi naho na wagenyela wakalongozwa ni Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petulo andaga akagenda kila hant'hu. Zuwa dimwenga agendaga kuwatalamkila want'hu wa Mnungu wandaga wakekala Luda. ");
INSERT INTO ngp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kudya abwiilaga mnt'hu yumwenga etangagwa Ainea, andaga kaholomp'hala, naho hadahaga kwinuka mwo lusazi kwa miyaka mnane. ");
INSERT INTO ngp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petulo niyo amgamba, “Ainea, Yesu Kilisito akuhonya. Kimala udamanye lusazi lwako.” Aaho niyo Ainea akimaala. ");
INSERT INTO ngp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Want'hu wose nawakekala Luda na Shaloni nawamuona Ainea, niyo wose wamhitukila Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kwandaga na mvele yumwenga uko Yopa etangagwa Tabisa, andaga mhuwila. Zina dyakwe kwe Kigiliki etangwa Dokasi, nuko kugamba kapala yehe ni mdamanya yedi mazuwa yose, na kuwambiza wakiwa. ");
INSERT INTO ngp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ahumaga niyo abanika, umwili wakwe wahakagwa mazi no kulambalikwa mwe chumba cha halanga. ");
INSERT INTO ngp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa hakwandaga hale vitendese kulawa Luda, naho wanamp'hina wezeweve kugamba Petulo eyuko Lida, wawatumaga want'hu waidi wenk'higwe baluwa ikugamba, “Usunguze kwiza kwetu.” ");
INSERT INTO ngp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ivo Petulo akeikaga lumwe niyo waitanya. Eze abule wamwigalaga kwe chumba cha halanga, uko wose wabanikilwe niwagosi zawe wamzungulukaga Petulo wakaila, no kumlagisa zisuke zia Dokasi adamanyaga umwo andaga mgima. ");
INSERT INTO ngp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petulo awalavaga kuse ye chumba want'hu wose, niyo afika madi no kumlombeza Mnungu, Niyo amhitukila yudya abanike no kumgamba, “Tabisa, inukila!” Niyo agubula meso yakwe, eze amuone Petulo niyo atakwikala. ");
INSERT INTO ngp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petulo amtozaga mkono no kumwambiza kukimala, niyo awetanga wadya wahuwila wa Yesu wose hamwenga na wadya wafilwe ni wagosi zawe, niyo awenk'ha uyo Tabisa akanda mgima. ");
INSERT INTO ngp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mbuli ino niyo ya gendezwa mwe Yopa yose, naho want'hu wengi niyo wamhuwila Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petulo ekalaga mazuwa mengi aho Yopa hamwenga na Simoni mdamanya nk'hingo. ");
INSERT INTO ngp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kwandaga na mnt'hu mwe Kaisalia etangagwa Kolinelio, andaga mkulu wa fyo dya wank'hondo wa Kilumi dyetangagwa, “Fyo dya Kiitalia”. ");
INSERT INTO ngp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Andaga mnt'hu ywa Mnungu, yehe ne mp'huga yakwe mwe nyumba wandaga ni want'hu wakumvika Mnungu. Iviya iviya adamanyaga yabindile ingi yakuwambiza wakiwa, naho naakamvika Mnungu mazuwa yose. ");
INSERT INTO ngp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yandaga saa kenda kisingi umwo aonaga maona ayo. Mwa maona yao amuonaga mtumigwa ywa Mnungu akamwizila kwe nyumba no kumgamba, “Kolinelio!” ");
INSERT INTO ngp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Niyo amkaulisa kwa kogoha, niyo amgamba, “Kuna mbwai Zumbe?” Yudya mtumigwa ywa kwe Mbingu niyo amhitula, “Mnungu kelelwa na malavo yako hamwenga ne ndima yako yo ukise naho haakujale, kakeika lumwe kukuhitula. ");
INSERT INTO ngp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Haluse tuma want'hu waite Yopa, kwa mnt'hu yumwenga akwitangwa Simoni Petulo. ");
INSERT INTO ngp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yehe ni mgeni mwe nyumba ya mnt'hu yumwenga mdamanya nk'hingo akwitagwa Simoni, akwikala hagihi ne bahali.” ");
INSERT INTO ngp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yudya mtumigwa ywa kwe Mbingu niyo akeitila, Kolinelio etangaga watumwa wakwe waidi, naho mnk'hondo ywakwe yumwenga andaga mnt'hu amwelele Mnungu mwa wandima wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Awagambilaga yose yalaile niyo awatuma kuita Yopa. ");
INSERT INTO ngp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Zuwa ditimile umwo wandaga wakaita, weze wande hagihi na Yopa, umwo yandaga msi wa gati, Petulo akwelaga kulanga kwe nyumba vileke akamlombeze Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Akeivaga sala niyo aunga kint'hu cha kudya, umwo nk'hande yandaga ikaikwa lumwe aonaga maona. ");
INSERT INTO ngp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Aonaga ulanga ukagubuka, no kuwona kint'hu kikaseela hasi kikale enga golole kulu dikuselezwa ditozigwe zimp'hembe zakwe izine. ");
INSERT INTO ngp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Umwo, mwandaga na nk'holo zose za makala na magondo na madege. ");
INSERT INTO ngp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Evaga Izwi dikamgamba, “Petulo, kimala guha uchinje udye!” ");
INSERT INTO ngp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mna Petulo niyo agamba, “Havikudahika Zumbe. Hyanda nidye chochose kisavu.” ");
INSERT INTO ngp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Izwi niyo dyalonga naye naho, “Use kukifanyanya kunda kisavu chochose kitendigwe ni Mnungu kunda kikukile.” ");
INSERT INTO ngp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ino yalailaga nk'hanana nt'hatu. Ize yajike niyo kint'hu kiya chavuzwa kulanga. ");
INSERT INTO ngp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Umwo Petulo andaga akafanyanya amaona ya nivo yagaaze, wadya want'hu watumigwe kulawa kwa Kolinelio weze waimanye inyumba ya Simoni, na wakimala kulongole kwe nk'hili. ");
INSERT INTO ngp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wetangaga wakauza, “Hana mnt'hu mgeni aha akwitangwa Simoni Petulo?” ");
INSERT INTO ngp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petulo andaga akagendeela kufanyanya kugamba maona yadya nivo yagaaze, Muye ywa Mnungu amgambaga, “Tegeleza! Want'hu watatu wakuzungula. ");
INSERT INTO ngp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ivo keike lumwe useele hasi, naho usekunda na nk'hangamizi kunda nawo kwaviya ni miye niwatumile.” ");
INSERT INTO ngp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ivo Petulo aseelaga hasi niyo awagamba wadya want'hu. “Nimiye mnt'hu yudya mkumzungula. Haya hunguleni?” ");
INSERT INTO ngp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Niyo wahitula, “Mkulu ywa wank'hondo Kolinelio kakituma, yehe ni mnt'hu ywedi akumvika Mnungu naho Wayahudi wose wamhuwilisa. Mtumigwa ywa kwe mbingu kamgamba akulalike kwakwe, akutegeleze kiya ukulonga.” ");
INSERT INTO ngp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petulo kawahokela want'hu awo kwe nyumba no kuwenk'ha hant'hu ha kugona. Zuwa ditimile Petulo nakakeika lumwe niyo aitanya nawo naho wandugu wamwenga kulawa Yopa walongolaga hamwenga naye. ");
INSERT INTO ngp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Zuwa ditimile abulaga Kaisalia, uko Kolinelio naakamgoja hamwenga na wanduguze na wambuya wa hagihi naye, wadya awalalike. ");
INSERT INTO ngp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Umwo Petulo andaga akengila kwe nyumba, Kolinelio amsingilaga, niyo amgweela heviga vakwe, no kumwinamila hasi hakwe. ");
INSERT INTO ngp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mna Petulo niyo amwinula akamgamba, “Kimala, miye name ni mnt'hu du enga weye.” ");
INSERT INTO ngp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petulo agendeelaga kulonga na Kolonelio umwo andile akengila kwe nyumba, uko abwiilaga want'hu wengi wadugane. ");
INSERT INTO ngp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Awagambaga want'hu awo, “Nyuwe mmanya vedi kugamba Wayahudi hawawagilwe, kwe dini yawe kuwatalamkila hegu kukehanganya na want'hu hi Wayahudi, mna Mnungu kanilagisa miye kugamba, hikuungwa kumfanyanya mnt'hu yeyose kugamba msavu. ");
INSERT INTO ngp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ivo mwize mnitumile want'hu nehiza ha heina nk'hangamizi yoyose. Nawauzani elo mnitumilai want'hu?” ");
INSERT INTO ngp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolinelio niyo ahitula, “Neinda saivi haluse, mazuwa matatu yomboke kugamba nandaga halombeza Mnungu kwe nyumba yangu saa kenda kisingi, Luholuho nakimailagwa kulongole kwangu ni mnt'hu availe suke zikumweka ");
INSERT INTO ngp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","niyo anigamba, ‘Kolinelio! Mnungu keva kulombeza kwako naivo hajaile zindima zako zo ukise. ");
INSERT INTO ngp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tuma mnt'hu aite Yopa kwe mnt'hu yumwenga akwitangwa Simoni Petulo, Yehe ni mgeni mwe nyumba ya Simoni mdamanya nk'hingo, akwikala hagihi ne bahali.’ ");
INSERT INTO ngp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Naivo niyo zasunguza kukutumila mnt'hu, naho nevinda vedi kwa weye kwiza. Haluse wose kiaya mwo undiilo wa Mnungu, kikageza kwiva chochose Zumbe akuunga akusigiile kulonga.” ");
INSERT INTO ngp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petulo akongaga kulonga akagamba, “Haluse namanya ni kindedi kugamba Mnungu awatendela want'hu wose yakuligana. ");
INSERT INTO ngp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wadya wose wakumvika no kudamanya ayedi naawazumile hata uneva walawa kokose. ");
INSERT INTO ngp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Muumanya ulosi awegaile want'hu wa Izilaeli, udya ukulonga Mbuli yedi ya Mnungu yo utondowazi kombokela kwa Yesu Kilisito uyo Zumbe ywa want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mmanya yalaile mwe isi ye Wayahudi kukongela mwe Galilaya aho Yohana eze abilikize ulosi wo ubatizo. ");
INSERT INTO ngp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mummanya Yesu wa Nazaleti na ivo Mnungu ammemeze Muye ywakwe no udahi. Aitaga kila hant'hu akadamanya mbuli zedi no kuwahonya wose wekailwe ni ludole lwo mwavu, kwaviya andaga na Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nisuwe kione no kulonga kila kint'hu kiya adamanye mwe isi yo Uyahudi na mwe Yelusalemu. Naho wamkomaga kwa kumuwamba mwo msalaba. ");
INSERT INTO ngp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mna Mnungu amuuyulaga mwe dizuwa dya katatu no kumtenda akelavilize, ");
INSERT INTO ngp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","hiyo kwa kila mnt'hu, ila kwa wadya waona wakwe wasagulwe lumwe ni Mnungu, nao ni suwe kidile na kunywa hamwenga na yehe aho eze auyuke. ");
INSERT INTO ngp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nakakisigiila kubilikiza Mbuli Yedi kwa want'hu, no kuwawenk'ha kindedi kugamba Yesu niye asagulwe ni Mnungu kuwasengela wagima na wabanike. ");
INSERT INTO ngp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Walotezi wose nawalonga mwa yehe kugamba, wose wakuunga wanande, na mhuwi mwa yehe, wavu wawe nouusigwe kwo udahi we dizina dyakwe.” ");
INSERT INTO ngp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Umwo Petulo andile akagendeela kulonga, Muye ywa Mnungu aseelaga mwa wose wadya nawakamtegeleza mwo ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wahuwila we Kiyahudi wezaga hamwenga na Petulo kulawa Yopa, weehelwagwa digeleko dya Muye ywa Mnungu hata kwa wadya hi Wayahudi wose. ");
INSERT INTO ngp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwaviya nawaweva wakalonga kwe milosi mihya, na kuutogola ukulu wa Mnungu. Petulo niyo agamba. ");
INSERT INTO ngp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Want'hu awa wahokela Muye ywa Mnungu, enga viya suwe chahokelaga. Mnt'hu yeyose hakudaha kuwa kindila wase kubatizwa na mazi?” ");
INSERT INTO ngp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ivo niyo alagiza wabatizwe kwe dizina dya Yesu Kilisito. Niyo wamlombeza Petulo ekale nawo kwa mazuwa mageke. ");
INSERT INTO ngp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Wegala Ulosi na wandugu wahuwila watuhu mwo Uyahudi yose wevaga kugamba want'hu hi Wayahudi nawo wahokela Mbuli ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Umwo Petulo aitaga Yelusalemu, wadya wose wandile no mhuwi mwo kuvinilwa, nawaka mkalaliza wakamgamba. ");
INSERT INTO ngp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Nokunda mgeni mwa want'hu hewevinilwe naho kudya hamwenga nowo!” ");
INSERT INTO ngp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petulo niyo awagambila ikindedi ivo mbuli iyo ilaile kukongela nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Umwo nandile halombeza Mnungu mwo mzi wa Yopa, naonaga maona. Naonaga kint'hu chaseelaga kulawa kulanga, chandaga, enga mgolole mkulu ukakuselezwa utozigwe mwe zimp'hembe zakwe zine, niyo dyeza halongole kwa hadya miye nandile. ");
INSERT INTO ngp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nadisinyaga kwa hagihi mndani mwakwe, naonaga mifugwa na makala mbago, magondo, na madege mbago. ");
INSERT INTO ngp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Niyo neva Izwi dikunigamba. ‘Petulo inuka uchinje udye!’ ");
INSERT INTO ngp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mna nahitulaga kugamba, ‘Havikudahika, Zumbe! Mnomo wangu haunati wingile ni kint'hu kisavu na zuwa dimwe.’ ");
INSERT INTO ngp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Izwi dyalongaga na miye kaidi, ‘Use kukigamba kisavu, kiya Mnungu akitendile kunda kikukile.’ ");
INSERT INTO ngp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mbuli ino ilaila nk'hanana nt'hatu, akajika niyo yavuzwa kwe mbingu. ");
INSERT INTO ngp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ahadya want'hu watatu watumagwa kwangu kulawa Kaisalia, wabulaga he nyumba hadya nandaga. ");
INSERT INTO ngp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Muye ywa Mnungu anigambaga niite nawo haheina nk'angamizi, Wandugu wahuwila awa mtandatu kulawa Yopa wanisindikizaga kuita Kaisalia, niyo chose chaita kwe nyumba ya Kolinelio. ");
INSERT INTO ngp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nakakigambila ivo amuone mtumigwa ywa kwe Mbingu akimale he nyumba yakwe amgambile, ‘Tuma mnt'hu aite Yopa kwa mnt'hu akwitangwa Simoni Petulo. ");
INSERT INTO ngp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Naalonge mbuli kwako, mwe imbuli Yedi iyo weye ne nyumba yako yose nomyokolwe.’ ");
INSERT INTO ngp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Naho nize nikonge kulonga, Muye ywa Mnungu aweziilaga kulawa kulanga enga viya vandaga kwetu suwe kudya nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Niho nakumbukile kiya alongaga Zumbe, ‘Yohana abatizaga kwa mazi, mna nyuwe nombatizwe kwa Muye ywa Mnungu.’ ");
INSERT INTO ngp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Naho imanyika kugamba Mnungu kawenk'ha wose hi wayahudi, digeleko diya akink'haga suwe umwo chamhuwilaga Zumbe Yesu Kilisito Mkombozi, Miye ni miye ani inde nimhige Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Weze weve ivo niyo waleka kulonga ila kumtogola Mnungu wakagamba, “Mnungu kawenk'ha want'hu hi Wayahudi nawo vileke wakweiile no kwingila kwo ugima!” ");
INSERT INTO ngp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Wahuwila wamwenga wadya wasambalaga kwa masulumizo yalailaga umwo Sitefano akomagwa, waitaga hale Foeniki na Kipulo na Antiokia wakabilikiza mwa Wayahudi aawo du. ");
INSERT INTO ngp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mna wahuwila watuhu waitaga Antiokia, wakombokela Kipulo na Kilene wakabilikiza kwa Wayahudi we Kigiliki, Mbuli Yedi ya Zumbe Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Udahi wa Zumbe nounda hamwenga nawo, fyo kulu dya want'hu dyahuwilaga no kumhitukila Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ulosi uwo wawabwiilaga want'hu wamhuwile Kilisito wa uko Yelusalemu, ivo niyo wamtuma Banaba aite Antiokia. ");
INSERT INTO ngp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Umwo eze abule no kuwona Mnungu ivo awenk'hile want'hu uwedi wakwe, nakelelwa no kuwagela moyo wande no mhuwi we kindedi kwa Zumbe mwe mioyo yawe. ");
INSERT INTO ngp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba andaga mnt'hu ywedi amemile Muye ywa Mnungu no mhuwi, naho want'hu wengi wegalagwa kwa Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banaba niyo aita Taso akamkaule Sauli. ");
INSERT INTO ngp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Eze amuone amguhaga niyo waitanya Antiokia, naho mwo mwaka mgima waidi awa wadugana na fyo dya wahuwila wa Kilisito wakahiniza fyo kulu dya want'hu. Ni kudya Antiokia aho wanamp'hina wakongaga kwitangwa Wakilisito. ");
INSERT INTO ngp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mwo lupisi ulo walotezi wamwenga waitaga Antiokia wakalawa Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yumwenga mwa woho etangagwa Agabo, akimalaga kwa udahi wa Muye ywa Mnungu akalotela kugamba gumbo kulu nedingile mwe isi. Gumbo idyo dyalailaga umwo Kilaudia andaga Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wanamp'hina wa Kilisito wafanyanyaga kugamba nawakadaha kila yumwenga mo udahi wakwe, kuwambiza wandugu zawe wahuwila nawekekala Uyahudi. ");
INSERT INTO ngp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Wadamanyaga ivo no kwigala matundu kwe wadala vilongozi we idifyo dya wahuwila wa Kilisito kwa kombokela kwa Banaba no miyawe Sauli. ");
INSERT INTO ngp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Aha niho Zumbe Helode akongaga kuwakunt'hiza want'hu we difyo dya wahuwila wa Kilisito. ");
INSERT INTO ngp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mkuluwe dya Yohana uyo naaketangwa Yakobo, akomigwa kwa kukant'higwa mtwi kwa bamba. ");
INSERT INTO ngp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Eze aone diya diwelela Wayahudi agendeelaga kwa kumgwila Petulo. Ino yalailaga aho kwandaga na zuwa dya kinyemi dya mikate heigeligwe ugwadu. ");
INSERT INTO ngp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Petulo eze agwilwe niyo ageligwa kwe divugailo, uko naakamilwa ni vibunga vine vina wamizi wane kila kabunga kamwenga, Helode akawiilaga kumlavila he kiyeti cha want'hu umwo Pasaka ikajika. ");
INSERT INTO ngp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ivo Petulo Avugailwagwa kwedivugailo mna want'hu wamhuwile Kilisito, wamlombezela Mnungu kwajili yakwe. ");
INSERT INTO ngp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nekilo Helode akei kugenda kumlava Petulo kwe kitala kwa want'hu, Petulo agonaga hagatigati ha wank'hondo waidi wandaga wakamdima, akakilizagwa mp'hingu mbili umwenga kulume na mtuhu kumoso, naho kwenk'hili kwandaga na wamizi. ");
INSERT INTO ngp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Aaho mtumigwa ywa kwe Mbingu ywa Zumbe akimalaga hadya no kugela ung'azi mwe chumba chose. Mtumigwa ywa kwe mbingu amsingisaga Petulo mwediyega, akamgamba, “sunguza kwinuka!” Aho idya mp'hingu niyo yatomoka kulawa mwe mikono ya Peulo. ");
INSERT INTO ngp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yudya mtumigwa ywa kwe Mbingu niyo amgamba Petulo, “Sunguza, vala vilatu vako no mkoa wako.” Petulo atendaga ivo mtumigwa ywa kwe Mbingu amgambilaga, Naho niyo mtumigwa ywa kwe Mbingu ywa Mnungu amgamba Petulo, “Vala suke yako unitimile.” ");
INSERT INTO ngp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petulo niyo amtimila kuse ye divugailo, hamanyize dyodyose, uneva ayo naakayadamanya uyo mtumigwa ywa kwe Mbingu uneva nayanda ya kindedi, Petulo naakagamba yadya akuona ni maona. ");
INSERT INTO ngp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wombokaga ho mwamizi ywa nk'hongo, na ywa kaidi, niyo weza kubindiliza kwe nk'hili ye chuma ikuhinga kwo mzi, nk'hili yakomokaga yoho yenye, niyo wafosa kuse. Wandaga wakagenda mwe sila imwenga aaho yudya mtumigwa ywa kwe Mbingu niyo amleka Petulo. ");
INSERT INTO ngp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Niyo Petulo akombaganya kiya kilaile no kugamba, “Haluse namanya kugamba iki ni kindedi kugamba Zumbe kanitumila mtumigwa ywa kwe Mbingu kunikombola kulawa ko udahi wa Helode no kulawa kwe kila kint'hu kikauilwe ni Wayahudi kulaila.” ");
INSERT INTO ngp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Petulo eze amanye ivo vili, aita kwe kaya ya Maliamu, nine dya Yohana Maliko, uko want'hu wengi wandaga wakadugana wakalombeza Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petulo atoaga hodi, niyo mwambizi etangagwa Loda ezaga kumkomoela. ");
INSERT INTO ngp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nakadikombaganya diizwi dya Petulo, niyo engilwa ni kinyemi mwo moyo, vilekile agulukaga kuuya kunyuma kwe nyumba haheina kukomola umnango no kuwagambila kugamba Petulo andaga kakimala kuse. ");
INSERT INTO ngp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Niyo wamgamba, “Weye umkilalu!” Mna niyo akombeka kulonga kugamba ni kindedi. Ivo niyo wahitula, “Yadahika ni mtumigwa ywa kwe Mbingu.” ");
INSERT INTO ngp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mna Petulo nakagendeela kutoa hodi, niyo wamkomoela umnango, naho weze wamuwone Petulo naweehelwa. ");
INSERT INTO ngp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Niyo awahunga mkono vileke wanyamale, naho niyo awagambila ivo Zumbe amfoseze kulawa kwe divugailo akagamba, “Mgambileni Yakobo na wandugu wahuwila watuhu,” niyo ahalawa no kuita kunt'hu kutuhu. ");
INSERT INTO ngp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kwize kuche niyo kwanda na nk'humbizi mwa wamizi kugamba Petulo kaitahi? ");
INSERT INTO ngp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode asigiilaga kumzungula Petulo, mna hawadahile kumuwona. Awetangaga awo wamizi no kuwauza mbuli, niyo asigiila wamizi awo wakomigwe. Yeze yomboke ayo, Helode alawaga Uyahudi no kugenda kwikala mwe isi ya Kaisalia. ");
INSERT INTO ngp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode andilisaga na maya na want'hu wa Sidoni na Tilo. Want'hu awo we mizi iyo miidi, wakeduganyaga hamwenga kugenda kumuwona. Nk'hongo wamluvyaga Bulasito vileke ande kwawe, uyo mnyamp'hala mkulu we nyumba yo uzumbe no kumlombeza wekale kwa utondowazi kwaviya isi zawe nezink'higwa nk'hande kulawa kwe isi ze kiseuta. ");
INSERT INTO ngp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mwe dizuwa disagulwe, Helode avalaga suke zakwe ze kiseuta no kwikala mwe kikailo cho uzumbe, niyo akonga kubilikiza kwa want'hu. ");
INSERT INTO ngp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Niyo wanga wakagamba, “Idi hidyo izwi dya mnt'hu, ni izwi dya yumwenga we milungu!” ");
INSERT INTO ngp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aaho mtumigwa ywa kwe Mbingu amkubilaga Helode mpaka hasi, kwaviya Helode alemelaga kumwink'ha ukulu Mnungu niyo adigwa ni mp'hingu no kubanika. ");
INSERT INTO ngp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mna mbuli ya Mnungu neigendeela kwenela no kukula. ");
INSERT INTO ngp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba na Sauli wabindaga ubilikizi wawe, no kuuya Yelusalemu wakamguha Yohana etangagwa Maliko. ");
INSERT INTO ngp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Wamwenga mwe difyo dya wahuwila wa Kilisito dya Antiokia, wandaga walotezi, watuhu nao wandaga wahinizi. Banaba na Simioni etangagwa Mtitu, hamwenga na Lukia kulawa Kilene na Sauli, na Manaeni alelagwa ni Helode. ");
INSERT INTO ngp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Umwo wandaga wakamvika Zumbe no kufunga, Muye ywa Mnungu awagambaga, “Nipaguileni hank'handa Banaba na Sauli, wadamanye ndima idya niwetangile.” ");
INSERT INTO ngp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wafungaga na kumlombeza Mnungu no kuwageleka mikono, no kuwatuma awo Banaba na Sauli waite Kipulo. ");
INSERT INTO ngp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Weze wegalwe ni Muye ywa Mnungu, Sauli na miyawe Banaba waitaga Seleukia watambaga mwe bahali kubula mwe visiwa va Kipulo. ");
INSERT INTO ngp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Weze wabule kudya Salami, wabilikizaga Mbuli ya Mnungu mwe zinyumba zo kuvikila za Kiyahudi. Wandaga hamwenga na Yohana mndima ywawe, akawambiza indima. ");
INSERT INTO ngp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Umwo wandaga wakajink'hanya kisiwa kuita Pafo, kudya waduganaga na mnt'hu yumwenga msai etangagwa Bali Yesu, Myahudi agambagwa kunda mlotezi. ");
INSERT INTO ngp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Andaga hamwenga na mbwiyaye ywo mkulu we kisiwa etangagwa Segio Paulo, andaga no udahi wo ukombaganyi. Uyo mkulu awetangaga Sauli na Banaba kwaviya aungaga ategeleze mbuli ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mna msai yumwenga etangagwa Elima kwaviya idyo ni zina dyakwe mwe Kigiliki, awahigaga kwa kugeza kuvuza kunyuma uhuwila wo mkulu yudya. ");
INSERT INTO ngp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sauli uyo Paulo umwo andaga amemile Muye ywa Mnungu amng'oelaga meso yudya msai ");
INSERT INTO ngp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","niyo amgamba, “Weye mwana wo Mwavu! Weye ywi mnk'hondo ywa kila kint'hu kikuzumilwa kunda chedi, kumema upapala wi hengi wiihile naho mazuwa yose wageza kuhitula sila zichumile za Zumbe kunda udant'hi! ");
INSERT INTO ngp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mkono wa Zumbe noukutoe ivi haluse, nounde nt'hunt'hu naho houone ung'azi wo umsi kwa lupisi.” Aaho Elima aonaga lwiza lukagubika ameso yakwe, niyo akonga kutunt'husa akazungula mnt'hu wa amlongoze kwa kumtoza mkono. ");
INSERT INTO ngp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yudya mkulu eze aone kiya kilaile, ahuwilaga, kwaviya eheelagwa kwa mahinizo ya Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo na weyawe watambaga ne ngalawa kulawa Pafo no kubula Pega, mzi wa Pamfilia, kudya Yohana uyo Maliko awasaga woho no kuuya Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Wagendeelaga kulawa Pega no kubula Antiokia mo mzi wa Pisidia. Mwe dizuwa dyo kuhumula wengilaga mwe nyumba yo kuvikila ya Wayahudi niyo wekala hasi. ");
INSERT INTO ngp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Weze wajike kusoma mwe kitabu che miko ya Musa na mwa Mawandiko Yakukile ya walotezi, mkulu we nyumba ya kuvika Mnungu niyo awegaila ulosi akawagamba, “Wandugu zangu, chaunga mlonge na want'hu uneva mna ulosi wowose wa kuwagela moyo.” ");
INSERT INTO ngp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo akimaalaga, akawahunga no mkono niyo agamba, “Wambuya zangu Wazilaeli na want'hu wose aha mkumvika Mnungu, mnitegeleze! ");
INSERT INTO ngp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mnungu wa want'hu wa Wazilaeli, awasagulaga wakale wetu niyo awatenda want'hu kunda taifa kulu umwo wandaga wageni mwe si ya Misili, Mnungu awaguhaga kulawa Misili kwa udahi mkulu, ");
INSERT INTO ngp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","naho kwa myaka milongo mine, kafinyiliza mwa woho uko kwe dijangwa. ");
INSERT INTO ngp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ayakomaga makabila mfungate, mwe isi ya Kanani no kuwenk'ha want'hu wakwe isi idya inde yawe. ");
INSERT INTO ngp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yano yose yaguhaga myaka magana mane na milongo mishano. “Yeze yajike aya, awenk'haga walamuzi, mpaka kubula mwa Mlotezi Samweli. ");
INSERT INTO ngp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Naho weze walombeze kwinkwa Zumbe, Mnungu awegailaga Sauli, mwana Kishi, kabila dya Benjamini kunda seuta ywawe kwa myaka milongo mine. ");
INSERT INTO ngp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eze ausigwe, Mnungu amwikaga Daudi kunda Zumbe ywawe, naivi nivo Mnungu alongaga mwa yehe kugamba, ‘Hiyo na kugamba Daudi mwana Yese ni mnt'hu mwa wadya huunga, ni mnt'hu akudamanya yose yadya huunga yehe adamanye.’ ");
INSERT INTO ngp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Andaga ni Yesu mwana Daudi atendigwe ni Mnungu kunda Mlokozi ywa Wazilaeli, enga viya amwink'hile ndagano. ");
INSERT INTO ngp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Umwo Yesu andaga akei kukonga indima yakwe, Yohana mbatizi awabilikizaga want'hu wose wa Izilaeli waleke wavu wawe no kubatizwa. ");
INSERT INTO ngp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohana eze ande abindiliza indima yo ubilikizi, niyo awagamba want'hu, ‘Mwagamba ni miye Mkombozi? Miye hiye yudya mkumgoja, mna tegelezeni! Eza kunyuma yangu, naho hiwagiliswe kuhambula vilatu vakwe kulawa mwe viga vakwe.’ ");
INSERT INTO ngp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Wandugu zangu Wazilaeli, cheleko cha Ibulahimu, na want'hu watuhu wose aha wakumvika Mnungu, ulosi uno wo kukombolwa kigailwa suwe. ");
INSERT INTO ngp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kwaviya want'hu wakwikala Yelusalemu ne vilongozi vawe, hawamanyaga kugamba yehe nie Mkombozi, hawakombaganyaga milosi ya walotezi wa Mnungu yaikilagwa lumwe kila zuwa dya kuhumula. Waitendaga milosi ya walotezi wa Mnungu kunda kindedi kwa kumsengela Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Naho hamwenga na kugamba hawadahile kuwona vikuleka wamsengele kukomwa, wamlombezaga Pilato amsengele kumkoma. ");
INSERT INTO ngp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Naho weze wande wadamanya kila kiya kiwandikwe mwa maandiko Akukile kwa yehe, wamselezaga kulawa mwo msalaba niyo wamtambalika mwe kikuta. ");
INSERT INTO ngp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mna Mnungu amwinulaga mo kubanika, ");
INSERT INTO ngp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Naho kwa mazuwa mengi awalailaga wadya wose wagendaganya kulawa Galilaya kuita Yelusalemi. Haluse woho ni waona, kwa yehe mwa want'hu wa Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nasuwe kiaha kuwegailani Mbuli Yedi. Kiya Mnungu awenk'haga ndagano wakale wetu ");
INSERT INTO ngp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nicho akudamanya kwetu, suwe ivyezukulu vawe, kwa kumwinula Yesu mwo kubanika enga viya viwandikwe mwe Zabuli ya kaidi kugamba, ‘Weye hwi Mwanangu ywa kilume, dielo hinda nimiye Iso.’ ");
INSERT INTO ngp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na ivi nivo alongaga Mnungu yo kuuyuka kwa Yesu, haaole mwe kikuta, ‘Nohwink'he uvikilwa we kindedi udya namwink'haga ndagano Daudi.’ ");
INSERT INTO ngp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Naho alonga mo Mawandiko Akukile mtuhu kugamba, ‘Mnungu haamneke mtumwa ywakwe msuntilwa aole mwe kikuta.’ ");
INSERT INTO ngp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mna hiyo Daudi abindaga ndima ya Mnungu, niyo eze abanike wanawe niyo wammosa msanga mwe kikuta, niyo mwili wakwe waola Umwo mwe kikuta. ");
INSERT INTO ngp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mna hivo ivo vilaile kwa yudya auyulwe ni Mnungu mo kubanika. ");
INSERT INTO ngp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Wandugu zangu Wazilaeli chaunga mmanye kugamba, kwa sila ya Yesu mwabilikizilwa imbuli yo kuusilwa wavu, ");
INSERT INTO ngp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","na kugamba kila yumwenga akuunga amhuwile Yesu naande mlekelwa ko wavu udya miko ya Musa heikudaha kuwakombolani. ");
INSERT INTO ngp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mkaulisise, sema yadya yalongigwe na walotezi wa Mnungu yanase yawalaileni nyuwe, kugamba, ");
INSERT INTO ngp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nyuwe wabezi! Ehelweni naho mfe! Kwa kiya hudamanya dielo kint'hu hamkudaha kuhuwila, hata uneva mnt'hu ana wagambilani!’ ” ");
INSERT INTO ngp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Umwo Paulo na Banaba wandaga wakahalawa he nyumba yo kuvikila, want'hu wawalalikaga, weze naho kwe dizuwa dituhu dya kuhumula vileke weze wawongezele kuwagambila zimbuli izi. ");
INSERT INTO ngp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Want'hu weze wahalawe ho mdugano, Paulo na Banaba watimilagwa ni Wayahudi wabindile ingi hamwenga na want'hu watuhu watendigwe kunda Wayahudi, Yesu wawagelaga moyo wadya wegala ulosi kugamba wekale mwo uwedi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Zuwa dyo kuhumula ditimile, awengi mo mzi, wezaga kwiva mbuli ya Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wayahudi weze waone idifyo dya want'hu wengilagwa ni finju, niyo wawafingiza want'hu mwa mahinizo ya Paulo no kumhomola. ");
INSERT INTO ngp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paulo na Banaba wagendeelaga kulonga kwa weduvi mkulu wakagamba, “Neviungwa Mbuli ya Mnungu inde kubilikizwa kwenyu aho nk'hongo, mna Kwaviya mlemela, naho hamkukewaza nyuwe wenye kwo ugima wa ulo na ulo, nekimilekeni niyo chaita kwa want'hu hi Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwaviya ivi nivo akisigiile Zumbe, ‘Himitendani nyuwe mng'aze want'hu hi Wayahudi, vileke want'hu wose we isi wakombolwe.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Want'hu hi Wayahudi weze weve ivo, niyo wengilwa ni kinyemi no kugamba Ulosi wa Mnungu ni mtogolwa, na wadya wose wasagulwe kwingila kwo ugima wa ulo na ulo wandaga wakuhuwila Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ulosi wa Zumbe wenelaga kila hant'hu mwe isi idya. ");
INSERT INTO ngp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Vilongozi Wayahudi wawasongelezaga vilongozi we isi na wavele hi Wayahudi wandaga want'hu wakulu wandaga wakamvika Mnungu, niyo wakonga kuwasulumiza Paulo na Banaba no kuwagulusa kulawa mwe isi yawe. ");
INSERT INTO ngp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paulo na Banaba wakung'unt'haga int'hifu ye sanga yandaga mwe viga vawe enga kilagiso cha kuwakanya want'hu wo mzi uwo, niyo wahalawa kuita Ikonia. ");
INSERT INTO ngp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wanamp'hina wa Kilisito wa Antiokia wandaga na kinyemi kikulu, no kumemwa ni Muye ywa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kint'hu enga iicho nekilaila uko Ikonia. Paulo na Banaba wengilaga mwe nyumba yo kuvikila no kubilikiza, vitendile wayahudi wengi na want'hu hi Wayahudi wande wahuwila. ");
INSERT INTO ngp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mna wadya Wayahudi wandaga hiwahuwila, wawachakulaga want'hu awo wahuwila hi Wayahudi, na kuwatenda wande wawahiga awa wandugu wahuwila. ");
INSERT INTO ngp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Wegala ulosi wekalaga ahadya kwa lupisi lutali wakabilikiza kwa weduvi mwe mbuli ya Mnungu uyo awalagise mo uwedi wakwe na kuwenk'ha udahi wa kudamanya vilagiso na vihungi. ");
INSERT INTO ngp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Want'hu mo mzi wakepangaga, wamwenga kwa Wayahudi, wamwenga nao kwe Wegala Ulosi. ");
INSERT INTO ngp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Naho wayahudi wamwenga, hamwenga ne vilongozi vawe, wafanyanyaga kuwatendela vihile Wagela Ulosi no kuwatoa maiwe. ");
INSERT INTO ngp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Wagela Ulosi weze wabunk'hule ayo wanyilikilaga kwe mizi ya Lisitila na Debe, mwe isi ya Likonia na isi zimgihi mwakwe. ");
INSERT INTO ngp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Uko wabilikizaga Mbuli Yedi. ");
INSERT INTO ngp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Uko Lisitila kwandaga mnt'hu kiwete heekudaha kugenda kukongela kwelekwa kwakwe. ");
INSERT INTO ngp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ekalaga aho akategeleza milosi ya Paulo, Paulo amuonaga kugamba ahuwilaga naho naakadaha kuhonyigwa, ivo niyo amkaulisa mnt'hu uyo ");
INSERT INTO ngp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","no kumlonga kwa izwi kulu, “Kimala uchuluke ne viga vako!” Yudya mnt'hu niyo akimaala no kupilika niyo akonga kugenda. ");
INSERT INTO ngp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Idifyo dyose dya want'hu dize dione kiya Paulo adamanye, wakongaga kugutila mwe milosi yawe ya Kilikonia, “Milungu indile enga want'hu iza kwetu!” ");
INSERT INTO ngp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Wamwink'haga Banaba zina dya Zeusi, Paulo naye zina dya Hemesi, kwaviya niye andile mlongi umkulu. ");
INSERT INTO ngp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mlava nt'hambiko ywa Zeusi yumwenga mwe milungu mta nyumba yakwe yandile kuse ludodo ye mzi, egalaga majeku no unga he nk'hili, kwaviya yehe ne difyo dya want'hu waungaga kulava nt'hambiko kwe wegala ulosi wa Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Umwo Banaba na Paulo weze weve ivo nawakaunga watende, walwebulaga zisuke zawe kulagisa kulemela kiya nekikalaila, niyo wagenda kukimala mgati mwe nk'hisanyo ya want'hu wakalonga kwa izwi kulu. ");
INSERT INTO ngp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nii mwadamanya ivi? Suwe na swe kiwant'hu enga nyuwe! Kiaha kwa kubilikiza mbuli ya Mnungu, kuwahitula mfose mnengembuli hezina ukulu kwa Mnungu ywetu mto udahi aumbile ulanga ne isi ne bahali ne vose viumo. ");
INSERT INTO ngp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Uko kale awalekelaga want'hu wadamanye viya wakuunga wenye. ");
INSERT INTO ngp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mna alavaga vilagiso vikulavanya ikindedi cho undiilo wakwe kwa mbuli zedi akudamanya, amwink'hani fula kulawa kulanga, no uwedi kwa hadya ukuunga, amink'hani mkande no kuwenk'hani kinyemi mwe mioyo.” ");
INSERT INTO ngp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hamwenga ne milosi iyo ye wegala ulosinevinda vidala kwa kuwafingiza want'hu awo kuwatambikila wegala ulosi. ");
INSERT INTO ngp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Wayahudi wamwenga kulawa Antiokia, uko Pisidia, na Ikonia, wawaluvyaga weyawe no kukelunga nao niyo wamtoa Paulo kwa maiwe no kumbulumuila kuse yo mzi wakamanya kugamba kabanika kale. ");
INSERT INTO ngp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mna wanamp'hina wa Kilisito weze wamduganyikile hamwenga, enukilaga niyo auya ko mzi. Zuwa ditimile yehe na Banaba waitaga uko Debe. ");
INSERT INTO ngp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo na Banaba wabilikizaga Mbuli Yedi uko Debe na want'hu wengi wahuwilaga. Weze walawe aho niyo wauya Lisitila na uko Ikonia hamwenga na Antiokia uko Pesidia. ");
INSERT INTO ngp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wawagelaga nguvu wanamp'hina no kuwasangalaza wekale kindedi mo mhuwi. Wahinizaga kugamba, “Chaungwa kombokela mwe mank'hunto mengi ko kwingila ko Useuta wa Mnungu,” ");
INSERT INTO ngp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mwe kila fyo dya wahuwila wa Kilisito, dyasagulaga wadala vilongozi, naho kwa kufunga no kumlombeza Mnungu wawaikaga mo udimi wa Zumbe, waikaga ukawiilo wawe mwa Yehe. ");
INSERT INTO ngp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Weze waite kombokela mwe isi ya Pisidia wabulaga Pamfilia. ");
INSERT INTO ngp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kudya wabilikizaga ulosi uko Pega niyo naho waita Atalia, ");
INSERT INTO ngp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","naho weze walawe aho, wagendelaga mwe ngalawa kuuya Antiokia, kudya kunt'hu wakeikaga mo udimi wa uwedi wa Mnungu, no undiilo wakwe kwe ndima idya waibindilize. ");
INSERT INTO ngp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Wagela Ulosi weze wabule antokia wawaduganyaga hamwenga want'hu we difyo dya wahuwila wa Kilisito, nokuwagambila yose yadya Mnungu adamanye hamwenga nao, na ivo Mnungu awakomoele wayahudi isila yo kuhuwila. ");
INSERT INTO ngp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naho wekalisaga nawo wanamp'hina. ");
INSERT INTO ngp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wezaga want'hu wamwenga walawile Yudeya kwiza Antiokia, no kukonga kuwahiniza wadya wandugu wahuwila kugamba, “Homdahe kuyokolwa uneva hamnavinilwe enga viya miko ya Musa zikuunga.” ");
INSERT INTO ngp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo na Banaba wengilaga moulafya nawo mwe mbuli ino, ivo yafanyanyagwa kugamba Paulo na Banaba hamwenga na watuhu uko Antiokia waungagwa waite Yelusalemu wakawaone Wegala ulosi hamwenga ne wadala vilongozi we idifyo dya wahuwila wa Kilisito mwe mbuli ino. ");
INSERT INTO ngp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kwaivo nawegalwa ni want'hu wamhuwile Kilisito, naho umwo wandile wakaita kombokela Foeniki Samalia walongaga ya want'hu hi Wayahudi wamhitukilaga Mnungu, ulosi uno wawatendaga wandugu wahuwila wose welelwe. ");
INSERT INTO ngp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Weze wabule Yelusalemu wahokelwagwa ni want'hu wamhuwile Kilisito na wegala ulosi, hamwenga na wadala Violongozi. Awo wawagambilaga yose wayadamanye kwa udahi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mna wahuwila wamwenga we mwe dibunga dya Mafalisayo, wakimalaga na kugamba, “Want'hu hi Wayahudi vaungwa wavinilwe no kugambigwa watimile Miko ya Musa.” ");
INSERT INTO ngp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Wegala ulosi hamwenga ne wadala vilongozi waduganaga hamwenga kutalaula ulosi uwo. ");
INSERT INTO ngp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ulafya uwo mtali wize womboke niyo Petulo akimaala niyo kugamba, “Wandugu zangu mmanya kugamba mazuwa mengi yomboke Mnungu anisagulaga miye mwenyu nibilikize Mbuli Yedi kwa want'hu hi Wayahudi, naivo wadahe kwiva no kuhuwila. ");
INSERT INTO ngp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Naho Mnungu amanyize fanyanyi za kila yumwenga, kalonga uwona kwa want'hu hi Wayahudi, kwa kuwenk'ha Muye ywa Mnungu enga viya akitendele suwe. ");
INSERT INTO ngp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kakitenda chose kunda wamwenga, suwe na woho, kawakukiza mioyo yawe kwaviya wamhuwila Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mwaungilai kumgeza Mnungu kwa kuwatwika wanamp'hina zint'wika izo zidundugwe ni wakale wetu na, hata suwe wenye hakikudaha kuzinula? ");
INSERT INTO ngp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bule! Chahuwila naho wahonywa nu uwedi wa Zumbe Yesu, enga woho ivo weli.” ");
INSERT INTO ngp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Fyo dyose dyanyamalaga kwaviya nawakawategeleza Banaba na Paulo wakalonga ulosi we vilagiso no kweheela ivo Mnungu avidamanye, mwa ya want'hu hi Wayahudi kombokela kwawe. ");
INSERT INTO ngp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Weze wajike kulonga, Yakobo niyo agamba, “Wandugu zangu nitegelezeni! ");
INSERT INTO ngp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni kasimuila ivo Mnungu mwe nk'hongo alagise kuwazumila kwakwe want'hu hi Wayahudi, kwa kuwasagula wamwenga wawe wande wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mbuli ino yazumilana no ulosi wa walotezi wa Mnungu, enga viya Mawandiko Akukilegwe. ");
INSERT INTO ngp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Zumbe agamba, ‘Akajika neniuye, no kuizenga idya nyumba ya Daudi. Neniyadamanye mahame yakwe no kuyatenda yatoge naho. ");
INSERT INTO ngp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Naivo want'hu watuhu wose, want'hu we isi zose niwetange wande wangu, nawamzungule Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nivo akulonga Zumbe, aitendile imbuli ino imanyike kukongela aho kale.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobo agendeelaga kulonga, “Niyo ifanyanyi yangu kugamba kisekuwagela nk'huswank'huswa, want'hu hi Wayahudi wakumhitukila Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Vituhu vakwe kiwawandikileni kuwagambila wasekudya nk'hande zigeligwe usavu kwa kutambikilwa milungu, wakenege no uhabwasi, wasekudya sakame. ");
INSERT INTO ngp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwaviya mazuwa mengi milosi ya Musa inda ikasomigwa mwe zinyumba zo kuvikila kila zuwa dyo kuhumula, naho mbuli zakwe zibilkizwa mwe kila mzi.” ");
INSERT INTO ngp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Wegala ulosi ne wadala vilongozi, hamwenga ne fyo dya wahuwila wa Kilisito wasagulaga want'hu mwawe no kuwawatuma kuita Antiokia wakanda wose na Paulo na Banaba. Wasagulaga want'hu waidi wazumilagwa ni wandugu wahuwila, uyo Yuda akwitangwa Balisaba, na miyawe Sila, ");
INSERT INTO ngp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","niyo wawenk'ha baluwa ino, “Suwe Wegala Ulosi hamwenga na wadala vilongozi, chamink'hani ndamsa nyuwe wandugu zetu hi Wayahudi, nyuwe mkwikala Antiokia, Silia, na Kilikia. ");
INSERT INTO ngp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kiva kugamba want'hu watuhu kulawa uku kwetu, wawahanganyani kwe milosi yawe, niyo waigela mioyo yenyu nk'huswank'huswa, Mna wadamanya ivo kwafanyanyi zawe hazilaile kwetu. ");
INSERT INTO ngp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Naivo kwa hamwenga kiivana kusagula want'hu no kuwatuma kwenyu. Hamwenga na Banaba na Paulo awo kiwaungile, ");
INSERT INTO ngp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","wakuwink'ha ugima wawe kwajili ye dizina dya Zumbe dyetu Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Elo ivo chawatuma Yuda na Sila kwenyu, nawawagambileni woho wenye yadya kiwawandikileni. ");
INSERT INTO ngp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Naivo Muye ywa Mnungu hamwenga nasuwe kizumila kisekuwatwikani ntwika zijink'hile mbuli izi zikubidi, ");
INSERT INTO ngp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","msekudya nk'hande zilavigwe nt'hambiko kwe vizi mnt'hu, msekunywa sakame, msekudya nyama itile kunyulikwa, naho wink'heni sila uhabwasi, nomde mdamanya vedi uneva hamna yadamanye ayo. Muye yedi.” ");
INSERT INTO ngp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Weze wawalage, wasigilwa awo wahingaga Antiokia, uko wawaduganyaga wahuwila wa Kilisito niyo wawenk'ha ibaluwa iyo. ");
INSERT INTO ngp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Weze waisome iyo ibaluwa, milosi yakwe neiwagela moyo niyo welelwa vitendese. ");
INSERT INTO ngp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila kwaviya nawo nawanda walotezi, wasimuilaga mbuli nyingi na wandugu wahuwila wa Kilisito wakawagela moyo no kuwatenda watoge. ");
INSERT INTO ngp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Weze wekale ikale uuko, wandugu wahuwila wa Antiokia niyo wawalaga kwa utondowazi niyo wauya kwa wadya wawatumile. ");
INSERT INTO ngp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Mna Sila andaga na ulamuzi wa kwikala ahadya. ");
INSERT INTO ngp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo na Banaba wekalaga uuko Antiokia kwa lupisi hamwenga na want'hu watuhu wengi, Wahinizagwa no kubilikiza mbuli ya Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mazuwa yeze yomboke Paulo niyo amgamba Banaba, “Kiuye kikawatalamikile wandugu wadya mwa kila mzi kudya kibilikize mbuli ya Zumbe, kikakaule ivo wakugendeela.” ");
INSERT INTO ngp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba naakaunga amguhe na Yohana akwitangwa Maliko hamwenga nawo, ");
INSERT INTO ngp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","mna Paulo haone kugamba neviwagilwa wamguhe Yohana Maliko, kwaviya awasaga aho nk'hongo kudya Pamfilia. ");
INSERT INTO ngp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kwandaga na mahigano makulu, niyo wapangana. Banaba amguhaga Yohana Maliko nokukwela ngalawa kuita Kipulo. ");
INSERT INTO ngp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo eze amsagule Sila nokuhalawa wandugu wahuwila wa aho nawawaika mo wamizi wo uwedi wa Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mwe nt'hambo iyo nawombokela Silia, na Kilikia, wakayatenda mafyo ya wahuwila wa Kilisito yatoge ");
INSERT INTO ngp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo abulaga Debe na Lisitila, uko ekalaga mwanamp'hina yumwenga akwitangwa Timoseo. Nine naye andaga mhuwila ywa Kilisito, andaga Myahudi, Mna ise andaga Mgiliki. ");
INSERT INTO ngp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wandugu wahuwila wa Kilisito wa uko Lisitila na Ikonia walongaga uwona wedi mwa Timoseo. ");
INSERT INTO ngp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo naakaunga wande wose mwe nt'hambo, ivo niyo amvinila. Nakadamanya ivo kwaviya Wayahudi wose wekale hamwenga mwe ziisi izo nawamanya kugamba ise dya Timotheo andaga Mgiliki. ");
INSERT INTO ngp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Umwo wandile wakomboka mwe imizi idya wawenk'haga wadya want'hu miko yalavagwa ni wadala vilongozi ne wegala ulosikudya Yelusalemu niyo wawagamba wazitoze. ");
INSERT INTO ngp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Naivo mafyo ya wahuwila wa Kilisito yatendagwa kunda yatogile mwo mhuwi, nokongezekela kwa wahuwila kila zuwa. ");
INSERT INTO ngp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nawombokela Filigia na Galatia na kwaviya Muye ywa Mnungu hawalekele kubilikiza uwo ulosi uko Asia. ");
INSERT INTO ngp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Weze wabule mwe mihaka ya Misia, Wagezaga kwingila mwe isi ya Besania, mna Muye ywa Mnungu ywa Yesu hawalekele kutenda ivo. ");
INSERT INTO ngp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ivo nawagenda vedi kombokela, Misia no kuita Toloa. ");
INSERT INTO ngp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mwe kilo kiya Paulo aonaga Maona, akaona want'hu wa Makedonia wakimale wakakeila kwakwe wakagamba, “Paulo wize kaidi Makedonia wize uchambize!” ");
INSERT INTO ngp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Aaho Paulo eze aone maona ayo, nakakeikila lumwe kale kuilawa Makedonia, haheina kucheelwa kwaviya nekimanya kugamba Mnungu kakitanga kwiza kubilikiza Mbuli Yedi kwa want'hu wa kudya. ");
INSERT INTO ngp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nekilawa Toloa, nokutamba kwa ngalawa, mpaka Samosileki, niyo luvi yakwe chaika nt'hulwe Neapoli. ");
INSERT INTO ngp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kilawa uko nokuita mpaka Ufilipi mzi mkulu we wilaya ya nk'hongo ya Makedonia naho wandaga ni uzumbe wa Waloma. Chahekalisaga hadya. ");
INSERT INTO ngp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Zuwa dyo kuhumula chafosaga kuse niyo chaita hank'handa yo mto, hant'hu Wayahudi wakutendelaga mviko kwa Mnungu, chekalaga kikasimuila na wavele wakeduganyaga aho. ");
INSERT INTO ngp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mwa wadya wandaga wakakitegeleza, andaga umwo mvele yumwenga, akumvika Mnungu, akwitangwa Ludia, mkaya ywa Tiatila andaga akataga suke za utana utendese. Zumbe niyo augubula umoyo wakwe niyo ayahokela yadya alongile Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Uyo mvele hamwenga na nine na wandugu zawe weze wajike kubatizwa, niyo akilalika akagamba, “Uneva nikindedi muwona kugamba miye namhuwila Zumbe, soni mwikale kwe nyumba yangu.” Niyo akitigiza kiite. ");
INSERT INTO ngp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Zuwa dimwenga umo chaitaga mwo kuvika na mndele mtumwa yumwenga andaga na mp'hepo yandaga ika mwink'ha udahi kukawiila mbuli zikwiza, uyo mtumwa mndele naakawapatila mazumbe wakwe matundu yabindile ingi yakulawa mo ulaguzi wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mndele uyo ambasaga Paulo na suwe, akagutiila akagamba, “Want'hu awa ni wandima wa Mnungu Mkulu! Nawagambileni ivo mkudaha kukombolwa!” ");
INSERT INTO ngp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Niyo anda akadamanya ivo kwa mazuwa mengi, mpaka zuwa dimwenga Paulo niyo aihiwa, no kumhitukila no kumgamba yudya mp'hepo, “Nakuunga umlawe mnt'hu uyo haluse ivi, kwe dizina dya Yesu Kilisito!” Aaho niyo mp'hepo yamlawa. ");
INSERT INTO ngp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wadya wagoli weze waone makawiilo yawe yo kupata matundu yasila, niyo wawagwila Paulo na miyawe Sila, niyo wawabulumula mpaka kwe kitala kwa wakulu. ");
INSERT INTO ngp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wawegalaga kwe kitala wakawalongeleza kugamba, “Want'hu awa ni Wayahudi wakigela nk'humbizi mo mzi wetu. ");
INSERT INTO ngp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wahiniza vihendo hivo vetu, suwe kiwa Lumi, hakikudaha kuvizumila na kuvidamanya.” ");
INSERT INTO ngp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Niyo want'hu wose kwahamwenga wawa kumpukilaga Paulo na Miyawe Sila. Wasenga masa wawahambulaga zisuke Paulo na Sila, niyo wenk'hiza miko ya kutoigwa mikotya Paulo na miyawe. ");
INSERT INTO ngp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Weze wajike kutoigwa kwa usungu niyo wasukumilwa kwe divugailo, niyo wadya wamizi wasigiilwa kuwakakiliza mp'hingu. ");
INSERT INTO ngp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Weze wahokele miko iyo, wamizi we divugailo wawagelaga, kwe chumba cha kundani mwedivugailo niyo wakakilizwa iviga vawe mwe difingo. ");
INSERT INTO ngp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mwe kilogati Paulo na Sila wandaga wakakema mila ya kumlombeza Mnungu, na wadya wavugailwa weyawe wandaga wakawategeleza. ");
INSERT INTO ngp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Aaho niyo halaila kisingisa, chasingisaga milango ye divugailo niyo yakomoka, ne zimp'hingu wakakilizilwe wadya wavugailwa zatohokaga. ");
INSERT INTO ngp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mwamizi we divugailo nakenuka o kuwona zinyivi ze divugailo zikomoka, naakagamba wavugailwa wanyilika ivo niyo asomola digola dyakwe akaunga akekome. ");
INSERT INTO ngp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mna Paulo niyo agutila kwa izwi kulu, “Usekukekoma! Suwe chose kiaha!” ");
INSERT INTO ngp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mwamizi alagizaga lumuli no kugulukila kundani, uku akazingiza he viga va Paulo na Sila. ");
INSERT INTO ngp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Niyo awalongoza kuse nokuwauza, “Nyuwe wakulu, nitende vivihi niyokolwe?” ");
INSERT INTO ngp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Niyo wamhitula, “Mhuwile Zumbe Yesu, nouyokolwe weye na want'hu mwe nyumba yako.” ");
INSERT INTO ngp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Niyo wabilikiza mbuli ya Zumbe kwa yudya mwamizi na want'hu watuhu wose mwe inyumba yakwe. ");
INSERT INTO ngp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kukongela hadya, yudya mwamizi awaguhaga Paulo na Sila no kusunt'ha zinkwenge zawe, aaho niyo yehe hamwenga na wanawe wabatizwa. ");
INSERT INTO ngp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Niyo awaguha Paulo na Sila kwe kaya yakwe no kuwenk'ha nk'hande. Yehe na wanawe wose wandaga na kinyemi kikulu kwaviya haluse nawaka mhuwila Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Zuwa dya kaidi mtondo, uzumbe we Kiloma, watumaga wakulu wawank'hondo, ne miko kugamba, “Walekeleni want'hu awo waite.” ");
INSERT INTO ngp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ivo yudya mwamizi awagambaga Paulo na Sila, “Wakulu wasigiila mfosezwe, elo foseni mwite kwa utondowazi.” ");
INSERT INTO ngp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mna Paulo niyo awagamba wamizi hachaoneke na masa yoyose, “Mna wakitoa mikotya mwe kieti, naswe Kiwaloma! Niyo naho wakigela kwe divugailo naho haluse waunga wakilekele kwa kinyele, Hivo ivo! Chaunga wakulu wenye we Kilumi weze wakilekele.” ");
INSERT INTO ngp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Wadya wakulu waamizi wagendaga kuwagambila ivo wakulu we Kilumi, weze weve kugamba Paulo na Sila ni Walumi, niyo wogoha. ");
INSERT INTO ngp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ivo wawabasaga Paulo na Sila niyo wakeila kwawe, naho wawalongozaga kuse ye divugailo na kuwagamba wahalawe ho mzi. ");
INSERT INTO ngp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo na Sila niyo wafosa kwedivugailo, niyo waita kwe nyumba ya Ludia. Hadya nawabwila wandugu wahuwila wa Kilisito, wawenk'haga milosi ya kugela moyo, niyo wahalawa. ");
INSERT INTO ngp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo na Sila waitaga wokombokela Amfipoli na Apolonia, no kwingila Sesalonike uko kwandaga ne nyumba ya kuvikila ya Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kwaviya azoele, Paulo aitaga kwe nyumba ya kuvikila. Andaga aaho kwa majuma matatu akalonga na want'hu wakahigana mwe Mawandiko Yakukile, ");
INSERT INTO ngp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","akawagambila ikindedi kugamba, vaungwa Kilisito asulumizwe no kwinuka kulawa mo kubanika. “Niye Yesu huwagambilani.” Paulo niyo agamba, “niye Kilisito Mkombozi.” ");
INSERT INTO ngp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wamwenga wawe nawazumila no kumtimila Paulo na Sila, na wavele wengi hamwenga na fyo kulu dya Wagiliki wandaga wakamvika Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mna Wayahudi wandaga wawaonelega gaina wakina Paulo na miyawe sila, wawaduganyaga want'hu wahezi heweina ndima, mwe zisila, niyo watenda kafyo, niyo wawagamba wadamanye fyo mo mzi wose vileke waitahe nyumba ya mnt'hu yumwenga akwitangwa Yasoni, enga mzungu wa kuwapata Paulo na Sila, na kuwegala kwa want'hu ao. ");
INSERT INTO ngp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mna weze wawaswese, niyo wamgwila Yasoni na wamwenga mwa wanduguze, niye wawegala kwa wakulu we isi wakagutila wakagamba, “Want'hu awa waleta nk'humbizi kila hant'hu! Haluse weza mwo mzi wetu, ");
INSERT INTO ngp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni naye kawahokela kwakwe, wose kwa hamwenga wabananga Imiko ya Seuta ywa Loma, wakagamba hambwe eyuko Zumbe mtuhu akwitangwa Yesu.” ");
INSERT INTO ngp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wakulu wo mzi na want'hu wose weze weve ivo, niyo wengilwa ni kituletule. ");
INSERT INTO ngp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Niyo wawatoza mhambulo Yasoni na weyawe, no kuwalekela waite. ");
INSERT INTO ngp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kilo kize kibule wandugu wahuwila, wawegalaga Paulo na Sila uko Belea, Weze wabule niyo wengila kwe Nyumba ya Kuvikila ya Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Want'hu wa Belea wandaga wabala wanaumanyi kuwajink'ha want'hu wa Sesalonike, nawakategeleza ulosi kwa kunyemwanyemwa nk'hulu, naho kila zuwa nawakakehiniza mo Mawandiko Akukile vileke wakaule ikindedi che milosi ya Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wengi wawe wahuwilaga, naho hata wavele wengi, wakulu we Kigiliki, na wagosi we Kigiliki nawo wahuwilaga. ");
INSERT INTO ngp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mna wayahudi wa Sesalonike weze wabunk'hule kugamba Paulo abilikiza mbuli ya Mnungu uko Belea wakongaga kutenda nk'humbizi, na kusongeza idifyo dya want'hu. ");
INSERT INTO ngp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wadya wandugu wahuwila niyo wasunguza kumsindikiza Paulo aite mp'wani, mna Sila na Timoseo wasigalaga Belea. ");
INSERT INTO ngp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wadya want'hu wamsindikize Paulo na waitanyaga nae mpaka Asene, niyo wauya na miko kugamba Sila na Timoseo wa mtimile nguvu kwavovose vikudahika. ");
INSERT INTO ngp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Umwo Paulo andile akawagoja Silana na Timoseo uko Asene, engilaga kinyulu Kwaviya aonaga ivo mzi umemile milungu vimumu. ");
INSERT INTO ngp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ivo wandaga wakalava na Wayahudi na wannt'hu watuhu mwe nyumba ya Mnungu, na want'hu watuhu nawakamvika Mnungu, naho kila zuwa naakalangilizana na want'hu wowose wakelavilizaga. ");
INSERT INTO ngp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Wamwenga nawatimila umanyi wa Epikulo na Sitoiki, nawakahigana naye. Wamwenga nawauza, “Aunga akigambile ubwalasi wani uyu?” Wamwenga niyo wahitula, “Uyu naakabilikiza Mbuli ya milungu mihya.” Nawakalonga ivo kwaviya Paulo naaka bilikiza Mbuli ya Yesu no kuuyuka. ");
INSERT INTO ngp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ivo niyo wamguha Paulo no kumwigala kwe kitala dyo mzi dikwitangwa Aleopago, wakamgamba, “Chaunga kimanye mahinizo aya mahya ukuhiniza. ");
INSERT INTO ngp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Vint'hu vimwenga kikuviva ukulonga, ni maizwi mahya kwetu naho nekikaungisa kivimanye vagaaze.” ");
INSERT INTO ngp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kwaviya wekazi awengi wa Asene, na wadya wageni, wandaga wakekala hadya wakaungisa kutenda lupisi lwawe kusimulizilana no kwiva mbuli mp'hya. ");
INSERT INTO ngp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo akimaalaga kulongole ye kitala dyo mzi wa Aleopago niyo agamba, “Hiona kugamba kwavovose, nyuwe want'hu wa Asene mu want'hu waidi kindedi ndedi. ");
INSERT INTO ngp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwaviya higenda mo mzi no kuwona mudya mkutendela miviko yenyu, hiviona vilingo viwandikwe, ‘Kwa Mnungu heemanyike’. Uyo mkumvika, hata uneva hamummanyize uyo niye huwabilikizilani. ");
INSERT INTO ngp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mnungu, adamanye isi na kila kiyumo mndani, niye Zumbe ywa kulanga ne isi, heekwikala mwe nyumba nk'hulu Izengigwe kwe mikono ya want'hu. ");
INSERT INTO ngp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Naho hahungukilwe ni dyodyose kikudaha kumdamanyila, kwaviya niyehe mwenye akukink'ha ugima, no muye, na kila kint'hu kituhu kwa want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kulawa mwa mnt'hu yumwenga Mnungu aumbaga want'hu wose mwe isi no kuwenk'ha udahi wa wikazi kwenela mwe isi yose, Afanyanyaga no kupanga iviya kukei kugamba niini, naho ni hii want'hu awo nawekale. ");
INSERT INTO ngp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nakatenda ivo vileke want'hu awo wamzungule hata uneva kwa kubabasa babasa wadahe kumbwiila, hata ivo mna Mnungu he hale na suwe chose, ");
INSERT INTO ngp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","enga viya mnt'hu yumwenga alongile, ‘Mwa yehe suwe chekala, chekedaha, na naho kiyuko.’ Ni enga viya wakemi wenyu ivo walongile ‘Suwe naswe kiwanawe.’ ");
INSERT INTO ngp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Haluse uneva suwe kiwana Mnungu hakikuungwa kumfanyanya Mnungu enga hili dya zahabu, hili dya matundu, hegudu hata iwe disongolwe ni mnt'hu no kugeligwa unt'handa. ");
INSERT INTO ngp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Aho handaga ho uhezi, Mnungu aketendaga enga hakuona, mna haluse asigiila want'hu wose kila hant'hu wakeiile. ");
INSERT INTO ngp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwaviya kaika kale dizuwa dyo usengelo we isi kwaviya viwagile, kombokela kwa mnt'hu yumwenga amsagule, Mnungu kawalavilizila wose imbuli ino kwa kumuuyula mnt'hu uyo.” ");
INSERT INTO ngp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Weze weve Paulo alonga imbuli yo kuuyuka, niyo wamwenga watumbula seko, mna wamwenga niyo wagamba, “Chaunga kikwive ukalonga imbuli ino naho.” ");
INSERT INTO ngp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ivo Paulo niyo ahalawa hekitala. ");
INSERT INTO ngp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mna want'hu wamwenga niyo wamtimila Paulo, niyo wahuwila. Yumwenga mwa woho andaga ni Dionisio wa Aleopago yumwenga wa want'hu wekitala, na mvele yumwenga akwitangwa Damali hamwenga na watuhu. ");
INSERT INTO ngp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Akajika aho, Paulo ahalawaga Asene no kuita Kolinso. ");
INSERT INTO ngp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Uko ambwilaga Myahudi yumwenga akwitangwa Akula, mwelekwa ywa Ponto, Akula hamwenga na mkaziwe akwitangwa Pilisikila wauyaga kulawa Italia mwa mazuwa aayo, kwaviya Kaisalia Kilaudia andaga kasigiila Wayahudi wose wakulawe Loma. Paulo agendaga kuwakaula, ");
INSERT INTO ngp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","naho kwaviya wandaga ni wata umanyi wa kusuma mahema enga yehe, Paulo ekalaga nao akadamanya ndima iidya nawakadamanya. ");
INSERT INTO ngp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila zuwa dyo kuhumula andaga na ulafya mwe zinyumba za Mnungu, akageza kuwavuta Wayahudi na Wagiliki. ");
INSERT INTO ngp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Umwo Timoseo na Sila weze wauye kulawa Makedonia, Paulo nakakelavya lupisi lwakwe lutali kubilikiza ulosi no kuwalavanyila Wayahudi kugamba Yesu Kilisito niye Masiha. ");
INSERT INTO ngp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Mna Wayahudi weze wamhige no kumhomola, akung'unt'haga zisuke zakwe availe mwa meso yawe, akawagamba, “Uneva mkaga ni nyuwewenye, miye henikalalizwe kwa dyodyose mwe idi! Naho kukongela ivi haluse neniwabase want'hu hi Wayahudi.” ");
INSERT INTO ngp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ivo elo kulawa aho niyo agenda kwikala kwa mnt'hu yumwenga hi Myahudi akwitangwa Tito Yusito, uyo inyumba yakwe yandaga hagihi ne nyumba ya Mnungu, inyumba yakwe yandaga ya kaidi kulawa he nyumba yo kuvikila. ");
INSERT INTO ngp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo, uyo andaga mkulu wenyumba ya Mnungu, yehe ne nyumba yakwe yose wamhuwilaga Zumbe, na want'hu watuhu wengi mwe Kolinso wevaga ulosi, wahuwilaga naho wabatizwagwa. ");
INSERT INTO ngp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kilo kimwenga mwa maona, Zumbe amgambaga Paulo, “Use kogoha gendeela kubilikiza, naho use kuhwa moyo, ");
INSERT INTO ngp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kwaviya miye nihamwenga na weye hahali yeyose akuunga ageze kukunyulika, kwaviya ho mzi uno weyaho want'hu wangu.” ");
INSERT INTO ngp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ivo Paulo niyo ekala uuko akahiniza mbuli ya Mnungu kwawe kwa mwaka umwenga na nusu. ");
INSERT INTO ngp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mna umwo Galiyo andaga mkulu wo mkoa wa Akaya, Wayahudi wamkumpukilaga Paulo kwa hamwenga niyo wa mwigala kwe kitala. ");
INSERT INTO ngp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Want'hu awa wagambaga, “Mnt'hu uyu,” “awatenda want'hu wamvike Mnungu kwe sila ikuhigana ne miko!” ");
INSERT INTO ngp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo andaga akei kulonga, Galiyo nakawagamba Wayahudi, “Tegelezani nyuwe wayahudi, Uneva mbuli ino yandile kindedi mwe wavu abanange, hegu nehimitegelezani. ");
INSERT INTO ngp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mna uneva ni mbuli ya mahigano mwe milosi, na mazina, na miko yenyu, Lamuleni nyuwe wenye miye heninde mlamuzi mwe zimbuli izi.” ");
INSERT INTO ngp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Niyo awagulusa hekitala. ");
INSERT INTO ngp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Woseni hamwenga niyo wamgwila Sositenesi uyo andile mkulu we nyumba ya Mnungu, niyo wamtowa hameso ye kitala. Mna Galiyo haone ukulu we mbuli iyo hata hadodo. ");
INSERT INTO ngp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo agendeelaga kwikala na wadya wandugu wahuwila wa Kolinso kwa mazuwa mengi, ahalawe aho niyo ahalawa no kukwela ingalawa kuita Silia, hamwenga na Pilisikila, na Akula uko Kenk'helea, eze amoge mtwi wakwe kwe kilapi aikaga. ");
INSERT INTO ngp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wabulaga Uefeso, aho niho Paulo awalekaga want'hu wa Pilisikila na Akula, niyo aita mwe nyumba ya Mnungu, niyo wanda wakalawa na Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wamlombezaga ekale nao lupisi lutali, mna yehe haungile. ");
INSERT INTO ngp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mna Umwoakahalawa nakawagamba, “Mnungu anaunga neniwauiyeni naho.” Niyo agendeela mwe ngalawa kuita Efeso. ");
INSERT INTO ngp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Eze abule Kaisalia, Paulo niyo agenda kuwalamsa want'hu wamhuwile Kilisito uko Yelusalemu, akajika aho niyo aita Antiokia. ");
INSERT INTO ngp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ekalaga uko mazuwa hi mengi niyo agendeela ne nt'hambo kwa kombokela mtendelo za Galatia na Filigia akawagela nguvu wanamp'hina wose. ");
INSERT INTO ngp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Myahudi yumwenga akwitagwa Apolo mwelekwa ywa Alekizandilia, Nakeza kwa Waefeso. Andaga ni mnt'hu mloga kindedi naho mta umanyi mkulu mwa Mawandiko Yakukile ywe mbuli ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nakahinyizwa mwe Sila ya Zumbe, naho akanda no lubwikanizi, asimulizilaga mbuli ya Yesu, naho ahinizaga mwe kindedi, hamwenga na kugamba nakamanya ubatizo wa Yohana uuwo du. ");
INSERT INTO ngp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Akongaga kuhiniza kwa weduvi mwe nyumba ya Mnungu. Pilisikila na Akula weze wamwive ivo akusimuila, niyo wamguha waitanye kwawe kaya wakamhiniza vedi Isila ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo eziilagwa ni ulamuzi wo kuita Akaya, wadya wandugu wahuwila nawamgela nguvu kwa kuwagondela wanamp'hina wa kudya Akaya vileke wamhokele. Eze abule kudya, kwa wambizi wa uwedi wa Mnungu, nakadaha kuwambizisa wadya wahuwila wenk'higwe kunda wahuwila. ");
INSERT INTO ngp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kwa uhigi wakwe mkulu nakawahuma Wayahudi mwekiyeti akalavanya kwa Mawandiko Akukile kugamba Yesu Kilisito niye Masiha. ");
INSERT INTO ngp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Umwo Apolo andaga Kolinso, Paulo ombokelaga mgati gati ye isi niyo abula Efeso uko awabwiilaga wanamp'hina wamwenga ");
INSERT INTO ngp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","niyo awauza, “Mwamhokelaga Muye ywa Mnungu aho mwize mnde wahuwila?” Niyo wamhitula, “Hata ukwiva kugamba eyuko Muye ywa Mnungu hakinati,” ");
INSERT INTO ngp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Vedi, Elo, mhokela ubatizo wa vivihi?” Niyo wamhitula, “Kibatizwa udya ubalizo wa Yohana du,” ");
INSERT INTO ngp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo niyo agamba, “Ubatizo wa Yohana wandaga kwa wadya walekile wavu wawe, naho awagambaga want'hu wa Izilaeli wamhuwile yumwenga akwiza kunyuma yakwe, nuko kugamba ni Yesu.” ");
INSERT INTO ngp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Weze weve ivo, niyo wabatizwa kwe dizina dya Zumbe Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo awagelekaga mikono niyo Muye ywa Mnungu aweziila, walongaga kwe milosi mihya no kugendeza kose ulosi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wandaga wabuile wagosi mlongo na waidi mwa want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo aitaga kwe nyumba ya Mnungu, naho kwa mazuwa milongo kanda andaga akalonga kwa weduvi na want'hu, akalangilizana nao no kugeza kuwalagilisa ikindedi cho Useuta wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mna wamwenga nawanda wamkulano, naho walemela kuhuwila, no kukonga kulonga vihile mwe iyo isila ya Zumbe mwe want'hu wengi wadugane. Aho Paulo niyo apangana nao, niyo aguha wadya wanamp'hina wakwe, akasimuila nawo mazuwa yose mwe dizumba dyo kuhinila dya mnt'hu akwitangwa Tulanosi. ");
INSERT INTO ngp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Agendeelaga kutenda ivo kwa myaka miidi, vitendile wekazi wose wa Asia, Wayahudi, na watuhu hi wayahudi wevaga imbuli ya Zumbe. ");
INSERT INTO ngp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mnungu adamanyaga vilagiso va kweheela kwa Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Want'hu wandaga wakaguha vitambala ne zisuke zint'huhu andaga akavala akanda mwe ndima, Paulo azigala kwa wanyonge, wanyonge niyo wahonywa maine yawe, nawadya wandile ne zi mp'hepo niyo wahonywa. ");
INSERT INTO ngp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wayahudi wamwenga waitaga uko na uko wakaditumia zina dya Zumbe Yesu, kwa wadya wavalukwe ni mp'hepo, wandaga wakagamba “Nawagambani kwe dizina dya Yesu yudya akubilikizwa ni Paulo.” ");
INSERT INTO ngp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wabwanga mfungate wa Sikewa Mlava Nt'hambiko mkulu wa Wayahudi, wandaga wakatenda ivo. ");
INSERT INTO ngp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mna uyo mp'hepo niyo awahitula, “Himmanya Yesu, naho himmanya Paulo, mna nyuwe ni nyuwe wahi?” ");
INSERT INTO ngp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Niyo yudya avalukwe awapilikila kwa nguvu wadya want'hu niyo awahuma nguvu wana Sikewa no kuwatatuila zisuke. Watulaga nguluko waka wakafosa kwe nyumba idya wekimbwigili, naho wagelwa nkwenge. ");
INSERT INTO ngp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kila mnt'hu uko Efeso, ande Wayahudi na hi Myahudi, waivaga imbuli iyo, niyo wengilwagwa ni wogofi no kutogolesa dizina dya Zumbe Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Wahuwila wengi wakelavilizaga niyo walonga mwe kiyeti zimbuli wandaga wakadamanya. ");
INSERT INTO ngp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wose wadya wandaga wasai wavigalaga vitabu vawe kwa hamwenga no kuvoka moto mwekiyeti. Wawazaga diyombe dye vitabu ivo dyabulaga matundu yakulihwa mnt'hu kwa zuwa, magana mlongo milongo mishano. ");
INSERT INTO ngp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Naivo kwa udahi wa Zumbe ulosi wa Mnungu wandaga ukongezekela kugendezwa no kukulisa. ");
INSERT INTO ngp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Yeze yomboke ayo Paulo aungaga kuita Yelusalemu, kwa kombokela Makedonia na Akaya, Nakagamba. “Hajika kuita uko, hawaone wa Loma nao.” ");
INSERT INTO ngp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ivo nakawatuma waidi mwa wambizi wakwe, Timoseo na Elasito, walongole kuita Makedonia, Yehe niyo anda kusigala kwa mazuwa mageke ko mkowa wa Asia. ");
INSERT INTO ngp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Aha niho halailaga nk'humbizi uko Efeso mwe mbuli ye sila iyo ya Zumbe Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kwandaga na msana vilama etangagwa Demetilio, adamanyaga mahili ye nyumba ya mnungu wa kivele akwitagwa Atemi, naho ndima iyo yawenk'haga wasani wakwe kint'hu kikulu. ");
INSERT INTO ngp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetilio awa kisanyaga wasani ao hamwenga na watuhu wandaga ne indima iyo no kuwagamba, “Mmanya kugamba ugoli wetu walawa mwe ndima ino. ");
INSERT INTO ngp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Haluse mwadaha kukeonela wenye ivo Paulo akutenda. Agamba milungu idamanywe ni want'hu hiyo milungu ya kindedi, naho kadaha kuwapata want'hu wengi, aha Efeso na hata kutuhu mo mkowa wa Asia yose. ");
INSERT INTO ngp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kuna nk'hondo kugamba, diyombe dyetu nedipate zina diihile. Hiyo ivo du mna yadahika kunda nyumba ya mnungu Atemi kunda hicho kint'hu cha ukulu no ukulu wakwe uyo akuvikwa ni Asia ne isi yose noubanangwe. Ulungu ukuvikwa nikila yumwenga mwe Asia ne isi yose!” ");
INSERT INTO ngp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Idifyo dize dive mbuli izi niyo dyanywa maya no kukonga kugutila wakagamba, “Atemi wa Efeso niye mkulu!” ");
INSERT INTO ngp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mzi wose niyo wenela nk'humbizi. Idifyo niyo dwawakump'hukila Gayo na Alistaliko, wakaya wa Makedonia watafi weyawe wa Paulo, niyo waguluka nao mpaka kwo ukumbi we misezigo. ");
INSERT INTO ngp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo yehe mwenye aungaga kukelaviliza ha meso ye difyo, mna wanamp'hina weyawe wamfingizaga. ");
INSERT INTO ngp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wakulu wamwenga we isi ya Asia wandaga wambuyaze dya Paulo, wamwigailaga ulosi wakamlombezesa Paulo kugamba ase kuke laviliza ko ukumbi we misezigo. ");
INSERT INTO ngp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Aaho aho kila mnt'hu andaga akavava, uyu ivi na watuhu ivi, niyo udya mdugano wabanika, kwaviya wengi hawamanyaga kiya kiwatendile wadugane hamwenga. ");
INSERT INTO ngp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wamwenga nawamtenda Alekizanda ande na chokulonga, kwaviya Wayahudi nawamtenda aite kulongole. Ivo niyo Alekizanda awalagisa want'hu kwa kuhunga mkono akaunga wanyamale, niyo ageza kukegombela kwa ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mna weze wabunk'hule kugamba yehe ni Myahudi, wagutiilaga wose wakalonga imbuli iidya kwa masaa maidi, “Atemi niye mkulu wa Efeso!” ");
INSERT INTO ngp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ukouko kalani wo mzi adahaga kuwanyamaza want'hu akagamba, “Wandugu Waefeso!” Kila yumwenga kamanya kugamba mzi uno wa Efeso ni mwamizi mkulu we nyumba yo mkulu Atemi, naho ni mwamizi we diiwe dyo kuvila diselezwe kulawa kulanga. ");
INSERT INTO ngp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hahali akudaha kulemela zimbuli izo, ivo nyamaleni msekudamanya dyodyose haheina wengele. ");
INSERT INTO ngp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Muwetanga want'hu awa aha hata uneva hawailongile vihile nyumba ya mnungu naho hata uneva hawamhomole mnungu ywetu ywe kivele. ");
INSERT INTO ngp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Mna uneva Demetilio na wandima wakwe wana malongelezo yawe kwa yeyose, yeyaho mazuwa yekitala masa yakudaha yakalahigwa uko. ");
INSERT INTO ngp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mna uneva kiuko kint'hu kituhu kujink'ha icho, ikaleni mwe mdugano ukuzumilwa. ");
INSERT INTO ngp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwaviya iyuko nk'hondo kugamba nekilongelezwe kwe nk'humbizi idya yadielo, nk'humbizi ino hayawagilwe ilaile, hekilekelwe mwe nk'humbizi ino, naho hegu nekidunduga kukehonya kwa vovose mwe nk'humbizi iyo. ");
INSERT INTO ngp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Eze abinde kulonga ivi, alekaga want'hu wa mdugano wakeagale. ");
INSERT INTO ngp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nk'humbizi ize itondowale, Paulo awetangaga wanamp'hina kwa milosi ya kugela moyo awalagaga niyo ahalawa no kuita Makedonia. ");
INSERT INTO ngp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ambokelaga mwe ziisi zia zose akawagela want'hu nguvu kwa milosi mingi, Niyo abula Uyunani. ");
INSERT INTO ngp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ekalaga uko kwa miyezi mitatu. Akeikaga lumwe kuita Silia, aho eze abunk'hule kugamba Wayahudi wandaga wakampangila maihi, ivo niyo atenda ulamuzi wa kuuya na kombokela Makedonia. ");
INSERT INTO ngp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopatolo mwana Pihilo kulawa Belea, niye atimilane naye, iviyaiviya Alistaliko hamwenga na Sekudo kulawa Sesalonike, Gayo kulawa Debe, Tukiko, na Tolofimo kulawa ko mkowa Asia, na Timoseo. ");
INSERT INTO ngp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Wakilongoelaga no kukigojela Toloa. ");
INSERT INTO ngp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Chaitaga kwa ngalawa kulawa Ufilipi ize yomboke siku kuu ye mikate heigwadulwe, naho yeze yomboke mazuwa mashano, chakelungaga nao umwo Toloa, uko chekalaga mazuwa mfungate. ");
INSERT INTO ngp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mwe dizuwa dya nk'hongo dye dijuma, cha duganaga vileke kibendule umkate. Kwaviya Paulo naakakawiila kuhalawa luvi yakwe, aguhaga lupisi lutali akalonga na want'hu viitile kubula kilo gati. ");
INSERT INTO ngp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Vakwelezwagwa vimuhi vingi mwe nyumba ye golofa Umwo chaduga. ");
INSERT INTO ngp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mbwanga yumwenga etangagwa Eotiko, andaga kekala hedilanga, umwo Paulo andile akagendeela kubilikiza. Eutiko akongaga kukupila mp'halahole niyo atozwa ni nt'hongo no kugwa hasi. Weze wamwinule andaga kabanika kale. ");
INSERT INTO ngp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mna Paulo aseelaga hasi, niyo afunama no kumkunyatila, niyo agamba, “Msekunda na kiyangayanga,” “akei mgima!” ");
INSERT INTO ngp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Niyo Paulo akwela naho kwegolofa no kubendula umkate niyo adya, nakagendeela kubilikiza kwa lupisi lutali mpaka mtondo, niyo Paulo ahalawa. ");
INSERT INTO ngp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Want'hu wadya waitanyaga na yudya Mbwanga kaya akanda mgima ngungulu, niyo wanda welelwa. ");
INSERT INTO ngp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Chakwelaga mwe ngalawa niyo chalongola kuita Aso kudya nekikamguha Paulo. Nivo apangaga kwaviya aungaga kombokela mwe isi nk'havu. ");
INSERT INTO ngp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Eze akibwiile kudya Aso, chamkwezaga mwe ngalawa no kuita Mitulene. ");
INSERT INTO ngp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kulawa uko chatambaga no kubula Kio, mwe dizuwa ditimile, zuwa dya kaidi chaikaga nt'hulwe uko Samo, naho luvi yakwe niyo chengila Mileto. ");
INSERT INTO ngp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo aungaga kugendeela no utafi we ngalawa haheina kombokela Efeso, vileke asunguze uko ko mkowa wa Asia, andaga ne kinguvu nguvu cho kubula Yelusalemu kwe wila ye Pent'hekosite uneva vadahike. ");
INSERT INTO ngp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kulawa Mileto Paulo atumaga ulosi kwa vilongozi wadala we idifyo dya wahuwila wa Kilisito dya Efeso vileke wadugane nae. ");
INSERT INTO ngp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Weze wabule kwakwe awagambaga, “Mmanya ivo nikale na nyuwe mazuwa yose, kukongela mwe dizuwa dia dya nk'hongo hadya nabulaga momkowa wa Asia. ");
INSERT INTO ngp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kwa kweseleza kose nadamanyaga ndima ya Zumbe molupisi lwa makunt'ho yanipatile kulawa kwe minyanyiko iihile ya Wayahudi wamwenga. ");
INSERT INTO ngp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mmanya kugamba hyandile na nk'hangamizi hata ludodo kuwabilikiza mwe kieti, na mnengenyumba zenyu, no kuwahiniza chochose chadahile kuwambizani. ");
INSERT INTO ngp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nehiwagamba Wayahudi, na hi Wayahudi, wamhitukile Mnungu no kumhuwila Zumbe dyetu Yesu. ");
INSERT INTO ngp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Naho haluse, uku hamtegeleza Muye ywa Mnungu, naita Yelusalemu haheina kumanya yakuunga yanilaile uko. ");
INSERT INTO ngp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kiya humanya ni kugamba Muye ywa Mnungu naakanilavanyila mwe kila mzi kugamba kuvugailwa na masulumizo yangu nayo yakunigojela. ");
INSERT INTO ngp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mna hiuone ugima wangu kunda kint'hu kitendese, mna du niunk'hintize udya utume wangu ne ndima idya nink'higwe ni Zumbe Yesu niidamanye, niilonge mwa want'hu Mbuli Yedi ya uwedi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Homboka mwa wamwenga mwa nyuwe habilikiza Useuta wa Mnungu, mna himanya haluse kugamba hahali yumwenga mwa nyuwe naanione naho. ");
INSERT INTO ngp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ivo dielo nawalavanyilani kugamba, ineza kulaila yumwenga ywenyu kaga, Miye hina kukalalizwa kokose. ");
INSERT INTO ngp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwaviya hindile na nk'hangamizi mo kuwagambila kukawiila kose akuunga Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mkeamile nyuwewenye hamwenga ne difyo diya Muye ywa Mnungu awenk'hileni mdilele. Dimeni awant'hu we idifyo dya wahuwila wa Kilisito dya Mnungu wadya awapatile kwa kulava sakame ya mwanawe mwenye. ");
INSERT INTO ngp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Hivimanyisa vedi kugamba nnahalawa mauzi makali nayadikome naho hayadisigaze idifyo idyo. ");
INSERT INTO ngp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hata mwa nyuwe wenye nawalaile want'hu wakuunga wawadant'hilize wanamp'hina wa Kilisito no kuwatenda wawatimile woho du. ");
INSERT INTO ngp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ivo indeni meso mkakumbukila kugamba kwa masulumizo, mengi kilo na msi, nawahinizagani kila yumwenga ywenyu kwa myaka mitatu. ");
INSERT INTO ngp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Haluse nawaika nyuwe hasi yo udimi wa Mnungu, no ulosi wo wedi wa wakwe, udya ukudaha kuwazenga na kuwagela nguvu, mpate uvikilwa udya awaikile want'hu wakwe wose wakukizwe. ");
INSERT INTO ngp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Miye hyaungise matundu hegu zahabu, hegu suke za mnt'hu yeyose. ");
INSERT INTO ngp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nyuwe wenye mmanya hidamanya ndima kwa mikono yangu mwenye vileke nikepatile yadya huunga na wambuyazangu. ");
INSERT INTO ngp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Hiwalagisani kwa kila kint'hu kugamba kwa kudamanya ndima enga ivo, kiwambize hewekukedaha, kikakumbukila milosi ya Zumbe Yesu mwenye akagamba, ‘Kiyuko kinyemi mo kulava kujink'ha kuhokela’.” ");
INSERT INTO ngp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo eze abinde kulonga ayo, afikaga madi na want'hu wose niyo wamvika Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wose nawanda wakaila, na kumtoza Paulo mkono no wakamlaga kwa lukunde lukulu. ");
INSERT INTO ngp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Mbuli itendese yawageile kinyulu niidya agambile, hawadahe kumuwona naho, naivo niyo wamsindikiza kwe ngalawa. ");
INSERT INTO ngp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kize chajike kulagana nao, chakwelaga mwe ngalawa mpaka Kosi, luvi yakwe chabulaga Lode, na kulawa uko nekiita Patala. ");
INSERT INTO ngp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Uko nekibwiila ngalawa yandile ikaita Foeniki, niyo chakwela no kukonga utafi. ");
INSERT INTO ngp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Cha wabulaga hant'hu nekikadaha kuiona Kipulo niyo chombokela nt'hendelo ya kusini yo mzi wa Silia. Chaitaga Tilo, aho ingalawa yaselezwagwa mizigo yakwe. ");
INSERT INTO ngp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Uko chabwiilaga wanamp'hina wa Kilisito niyo chekala nao juma dimwenga wahuwila wa Kilisito ao walonga kwa udahi wa Muye ywa Mnungu, niyo wamgamba Paulo usekuita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mna lupisi lwetu wize usile niyo chahalawa, wavele na wana wawe hamwenga wakisindikizaga mpaka kuse yo mzi, kize kibule mp'wani wose chafikaga madi no kumvika Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Niyo chalagana, suwe chakwelaga mwe ngalawa, woho nao niyo wauya kwezikwawe. ");
INSERT INTO ngp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Chahalawaga kuita Tilo, niyo chabula Tolemaisi aho chawalamsaga wandugu wahuwila wa Kilisito zetu, niyo chekalanya nao zuwa dimwenga. ");
INSERT INTO ngp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Luvi yakwe chahalawaga kuita Kaisalia. Uko chekalaga kwe nyumba ya mbilikizi we Mbuli Yedi Filipo, yehe andaga mwa wadya mfungate wasagulwa kunda wambizi kudya kwe fyo dya wahuwila wa Kilisito dya Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Andaga na wanawe wane wa kivele hewelombigwe wandaga wakalonga ulosi wa Mnungu wandaga wakenk'hingwa. ");
INSERT INTO ngp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kize kikale uko mazuwa mengi, mlotezi ywa Mnungu yumwenga akwitangwa Agabo wa Yudeya abulaga. ");
INSERT INTO ngp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Akibasaga niyo aguha mkoa wa Paulo, nokukekakiliza mikono ne viga niyo agamba, “Muye ywa Mnungu agamba, mta mkoa uno naakakilizwe enga ivi ni Wayahudi kudya Yelusalemu, no kumgela mwe mikono ya want'hu hewemmanyize Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kize kive ivo, suwe na wadya want'hu watuhu nekilombezesa Paulo asekuita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mna Paulo niyo awahitula, “Mwadamanyai? Ivo mkuta kuila no kunikant'ha tama? Miye hikeika lumwe hiyo kuvugailwa du kudya Yelusalemu, mna hata ukubanika mwe mbuli ya Zumbe Yesu.” ");
INSERT INTO ngp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nekidunduga kumluvya Paulo, niyo chabanika chevu niyo chagamba, “Viya aungile Zumbe nevinde iivo.” ");
INSERT INTO ngp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kize kikale hadya kwa Lupisi niyo chakeikilaga lumwe kugendeela no utafi kuita Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wamwenga mwa wanamp'hina kulawa Kaisalia, chaitanyaga, niyo wakigala kwe nyumba yo mhula ywa Kilisito chandaga kikagenda kwikala naye. Mnasoni mkaya wa Kipulo andaga mhula ywa Kilisito kukongela mazuwa ya aho nk'hongo. ");
INSERT INTO ngp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Aho kize kibule Yelusalemu, wandugu wahuwila wa Kilisito wakihokelaga vedi vitendese. ");
INSERT INTO ngp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Luvi yakwe Paulo aitaga na suwe kokumlamsa Yakobo, wadala vilongozi wose we idifyo dya wahuwila wa Kilisito wandaga aaho. ");
INSERT INTO ngp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Weze wajike kuwalamsa, Paulo niyo awagambila yose yadamanywe ni Mnungu kwa want'hu hi Wayahudi kwa ndima adamanye. ");
INSERT INTO ngp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Weze wajike kumtegeleza niyo wamtogolesa Mnungu. Niyo wamgamba Paulo, “Ndugu wadaha kuwona kugamba magana milongo magana ya Wayahudi wanda wahuwila naivo wakuitoza Imiko. ");
INSERT INTO ngp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nawagambilwa zimbuli zako kugamba noukawahiniziza Wayahudi wa kwikala kwe zi isi za want'hu hi Wayahudi, kugamba wase kukaula miko ya Musa, wasekuvinilwa wana wawe, naho wase kutimila vihendo va Kiyahudi. ");
INSERT INTO ngp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Weva kindedi kugamba kubula kale. Nekitende vivihi elo? ");
INSERT INTO ngp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Haluse utende enga ivi kikukulangiliza, aha kinanao want'hu wane waikile kilapi. ");
INSERT INTO ngp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Timilana nao ao kwo mviko wo kukesunt'ha kumanya miko ya Mnungu, ukalihe maliho yakuungwa akajika wamogigwe zifili zawe, ivo want'hu wose nawamanye kugamba yadya wagambilwe mwa weye hayana kindedi chochose no kugamba weye mwenye ukei watimila miko ya Musa. ");
INSERT INTO ngp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Naho mwa wadya want'hu hi Wayahudi watendile wahuwilwa wa Kilisito, nekiwaandikile kale kuwagambila zimbuli kifanyanye, wasekudya chochose kitendelwe nt'hambiko kwe milungu ya kidant'hi, wase kunywa sakame wasekudya nyama inyogotolwe, naho mkenege no uhabwasi.” ");
INSERT INTO ngp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ivo, zuwa ditimile Paulo awaguhaga wadya want'hu no kugenda kukesunt'ha hamwenga nawo, akajika niyo engila kwe Nyumba ya Mnungu, awagambilaga watu miwazile ya mazuwa yo kubinda ukukesunt'ha, naho niini malavo yakuunga yalavigwe kwajili ya kila yumwenga ywawe. ");
INSERT INTO ngp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mazuwa ayo mfungate yeze yande hagihi no kusila, Wayahudi walawaga mo mkowa wa Asia nawamuona Paulo kwe Nyumba ya Mnungu, niyo wasongeza maya kwe difyo dyose dya want'hu, no kumvugaila Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Wagutilaga wakagamba, “Want'hu wa Izilaeli, chambizeni! Uyu niyudya akugenda kila hant'hu, kuhiniza want'hu wose kuhigana na want'hu wa Isilaeli ne miko ya Musa ne Nyumba ya Mnungu, hata ivi haluse kawengiza kwe nyumba ya Mnungu want'hu hi Wayahudi, naho wahagela usavu hakukile ha Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Vilekile wakalonga ivo nikugamba wamuonaga Tolofimo mkaya wa Efeso akanda hamwenga na Paulo kwo mzi, niyo wafanyanya, Paulo nakamwingiza kudya kwe Nyumba ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mzi wose nowenela nk'humbizi, wezaga want'hu kulawa nt'hendelo zose, niyo wamgwila Paulo no kumbulumula, na kumlavila kuse ye nyumba nk'hulu ya Mnungu, aho nyivi ze Nyumba ya Mnungu zavugalagwa. ");
INSERT INTO ngp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Waungaga wamkome Paulo, mna ulosi wabulaga ko mkulu wa wank'hondo we Kilumi kugamba, Yelusalemu yose yamemaga nk'humbizi. ");
INSERT INTO ngp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Aaho mkulu we difyo dye Kilumi aguhaga wank'hondo ne vilongozi wawe, niyo wawagulukila wadya want'hu, nawo weze wamuwone mkulu we difyo dye Kilumi, niyo waleka kumtoa Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mkulu we difyo dye Kilumi amgulukilaga Paulo niyo amgwila no kusiigila Paulo akakilizwe mp'hingu mbili, akajika niyo auza, “Uyu niani? Naho kabalangai?” ");
INSERT INTO ngp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Mwedi fyo diya wamwenga nawakalonga ivi, wamwenga nawo walonga viya, kwe nk'humbizi iyo mkulu we difyo dya wank'hondo nakadunduga kumanya icho kilaile, ivo elo asigilaga awant'hu wakwe wamwigale Paulo kwe nk'hambi ya wank'hondo. ");
INSERT INTO ngp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo eze abule ho mhindo neviwaunga wank'hondo watekumwinula, kwe nk'humbizi ya want'hu. ");
INSERT INTO ngp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kwaviya fyo kulu dya want'hu dyandaga dika mtimila wakagamba, “Mkome, mkome.” ");
INSERT INTO ngp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Umwo yudya mkulu wa wank'hondo andile wakamwigala kwe divugailo, Paulo niyo amgamba, “Nadaha kukugambila kint'hu?” Yudya mkulu niyo amuuza, “Ha! Kumbeke kudaha kulonga Kigiliki” ");
INSERT INTO ngp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Ivo weye hiyo yudya Mmisili, mwe mazuzi akongile kusaguka na kuwalongowela wadya makank'halu magana milongo mine mpaka kwenyika?” ");
INSERT INTO ngp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo niyo ahitula, “Miye ni Myahudi, mwelekwa wa Taso uko Kilikia, mzi umanyikise. Nakulombeza vitendese nilonge na want'hu. ");
INSERT INTO ngp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yudya mkulu wa wank'hondo niyo amwink'ha luneka, ivo Paulo akimaalaga mwo mhindo, niyo awahunga mkono wadya want'hu vileke wanyamale, naho weze wanyamale akongaga kulonga nao Kiibulania. ");
INSERT INTO ngp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Wandugu zangu na watate, nitegelezeni, haluse nakegombela mwa meso yenyu!” ");
INSERT INTO ngp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Weze weve akalonga nawo Kiibulania, niyo wanyamalisa kujink'ha hadya nk'hongo, Paulo niyo agendeela kulonga. ");
INSERT INTO ngp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Miye ni Myahudi mwelekwa wa Taso mwe Kilikia, mna nehileligwa aaha ho mzi wa Yelusalemu, kwa Mhinizi Gamalieli. Nehihinyizwa kindedi ndedi miko ya wakale wetu, nakelavaga kwa moyo wose kwa Mnungu, enga nyuwe wenye ivo mwili ivi dielo. ");
INSERT INTO ngp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nehiwasulumiza wadya want'hu watimile sila ino, nehiwakakiliza wavele kwa wagosi no kuwaduula kwedivugailo. ");
INSERT INTO ngp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mlava nt'hambiko mkulu no wadala vilongozi wose we kitala wadaha kulonga viya waione imbuli ino kulawa kwawe nahokelaga baluwa wawandikilagwa wadya Wahuwila Wekiyahudi, wadya wandile Damesiki, nehiita Damesiki vileke hawagwile want'hu awo no kuwegala mpaka Yelusalemu iviya wakakilizigwe, vileke wakasulumizwe. ");
INSERT INTO ngp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Umwo nandaga haita, mwe sila hagihi na Damesiki, yandaga sa mtandatu nomsi, aaho ung'azi utendese ko ulanga wanilailaga luholuho, niyo wawang'aila ndendelo zose. ");
INSERT INTO ngp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Aha nagwaga hasi niyo neva izwi dikunigamba, ‘Sauli, Sauli! Nii wanisulumiza?’ ");
INSERT INTO ngp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Name niyo nagamba, ‘Niwe ani Zumbe?’ Naye niyo anigamba, ‘Nimiye Yesu wa Nazaleti, uyo weye ukunisulumiza.’ ");
INSERT INTO ngp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wadya wambuyazangu wauonaga ung'azi udya, mna hawadivile diizwi dya yudya nalongaga naye. ");
INSERT INTO ngp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Niyo nauza, ‘Zumbe nitende vivihi?’ Zumbe niyo anigamba, ‘Kimala, uite Damesiki, uko nuko nougambilwe yose ukuungwa udamanye.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kwo ung'azi udya mkulu hyadahile kukaula ivo wadya wambuyazangu nawaungwa wanitoze mkono wanilongoele mpaka Damesiki. ");
INSERT INTO ngp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Mwo mzi udya kwandaga na mnt'hu yumwenga zina dyakwe Anania, mnt'hu ywa Mnungu akutoza miko ya Musa, naho wayahudi wose wekalaga Damesiki walongaga uwona wedi mwa mnt'hu uyo. ");
INSERT INTO ngp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yehe ezaga kuniona, niyo akimaala hagihi na miye no kugamba, ‘Sauli! Ona kaidi!’ Aaho niyo nanda naona no kumkaula. ");
INSERT INTO ngp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Anania niyo agamba, ‘Mnungu wa wakale wetu kakusagula umanye ivo akuunga, naho ummanye mtumwa ywakwe mkindedi no kumwiva yadya akulonga mwenye. ");
INSERT INTO ngp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwaviya noulonge kwa want'hu yadya uyaone no kuyeva. ");
INSERT INTO ngp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Haluse wagojai? Kimala ubatizwe naho uusilwe wavu wako, ulombeze mwe dizina dyakwe.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nauyaga Yelusalemu, naho Umwo nandaga havika kwenyumba ya Mnungu nehiona maona, ");
INSERT INTO ngp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","mwaayo namuonaga Zumbe akanigamba, ‘Sunguza naho uhalawe nguvu Yelusalemu, Kwaviya want'hu wa aha hawazumile uwona wako mwa miye.’ ");
INSERT INTO ngp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Name niyo namhitula, ‘Zumbe, kunimanyisa vedi kugamba ni miye nandaga haita kwe zinyumba za Mnungu hawagwila no kuwatoa wose wandaga wakakuhuwila weye. ");
INSERT INTO ngp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Naho umwo muwona ywako Sitefano akakomwa, miye nehinda aaho haona kukomwa kwakwe niyo nazumila kwamila zisuke za wadya wakomi.’ ");
INSERT INTO ngp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Zumbe, Mnungu, niyo anigamba, ‘Ita, kwaviya nohwigalise hale kwa want'hu hi Wayahudi.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Wadya want'hu wamtegelezaga Paulo, mna eze alonge milosi iyo, wakongaga kugutila wakagamba, “Muuseni aha! Mkomeni! Mnt'hu enga uyo hawagilwe kulekwa mgima!” ");
INSERT INTO ngp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wagendeelaga kutowa lwasu, uku wakakusula kusula makoti yawe, no kutimula luvumbi mwo ulanga kwa maya. ");
INSERT INTO ngp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mkulu we difyo dye Kiloma asigiilaga want'hu wakwe wamwigale Paulo kwe nk'hambi ya wank'hondo, no kuwagamba wamtoe Paulo mikotya vileke wamanye kilekile Wayahudi wakamtowela vugo. ");
INSERT INTO ngp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mna ize inde wamkakiliza kale vileke wamtowe mikotya, Paulo niyo awauza wakulu wadya wakimalaga hadya, “Togoleni mwe miko yadahika kumtowa mikotya mnt'hu ywa Lumi akanda akei kukantilwa?” ");
INSERT INTO ngp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yudya mkulu eze eve ayo, niyo amuuza yudya mkulu we difyo dye Kilumi, “Watendai? Mnt'hu uyu Mloma!” ");
INSERT INTO ngp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Yudya mkulu we difyo dye Kilumi, amwitilaga Paulo no kumuuza, “Nigambile, weye umwikazi ywa Loma?” Paulo niyo ahitula, “Heiye,” ");
INSERT INTO ngp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Yudya mkulu we wank'hondo niyo agamba, “Miye hinda mnt'hu ywa Loma kwa kuliha matundu yabindile wingi.” Paulo niyo ahitula, “Miye ni Mloma ywa kwelekwa.” ");
INSERT INTO ngp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wadya want'hu wakeikile lumwe kumuuza Paulo, wakeyagilizaga aaho no kuhalawa, hata yudya mkulu we difyo dye Kilumi niyo ogoha aho weze wabunk'hule kugamba Paulo ni Mloma mna naho wamkakiliza. ");
INSERT INTO ngp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mtondo wakwe, mkulu we difyo dye Kilumi, aungaga kumanya yadya yalekile Wayahudi wakamlongeleza, ivo amloholaga Paulo impingu yakwe niyo naho asigiila Wakulu wa walava nt'hambiko ne kitala dyose wadugane, akajika amletaga Paulo niyo amkimalisa hameso ye kitala. ");
INSERT INTO ngp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo niyo awang'oela meso wadya Wadala we Kitala niyo agamba, “Wandugu zangu Wazilaeli! Mpaka dielo idi hinda na wikazi wa ukawiilo wedi hameso ya Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Aho Mlava nt'hambiko Mkulu Anania niyo asigiila wadya wakimale hagihi naye Paulo wamtowe kofi mo mnomo. ");
INSERT INTO ngp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulo niyo amgamba, “Yehe mwenye Mnungu naakutowe kofi weye mtondwe! Togola wadaha vivihi kwikala aho vileke unisengele kutimila miko, mna weye mwenye wi mwavu we miko kwa kuwatuma wanitowe!” ");
INSERT INTO ngp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Want'hu wadya wakimalaga hadya niyo wamgamba Paulo, “Weye wamhomola Mlava nt'hambiko Mkulu ywa Mnungu!” ");
INSERT INTO ngp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo niyo ahitula, “Wandugu zangu, Wazilaeli, miye himanyize kugamba yehe ni Mlava nt'hambiko Mkulu, kwaviya Mawandiko Akukile wagamba, ‘Usekulonga yaihile kwo mkulu ywa want'hu wako.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo eze amanye kugamba wamwenga mwa want'hu wekitala wandaga Masadukayo, wamwenga nao Wafalisayo, ivo niyo alonga kwa izwi kulu akagamba, “Wandugu zangu miye ni Mfalisayo mwana Mfalisayo, higalwa hekitala kwaviya nakawiila kugamba wabanike nawauyuke!” ");
INSERT INTO ngp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Eze alonge ayo, niyo kwa laila vugo kulu mwa Wafalisayo na Wasadukayo, niyo mdugano wake panga haidi. ");
INSERT INTO ngp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mbuli iyenye ni kugamba, Masadukayo wagamba wabanike hawakuuyuka, hahali mtumigwa ywa kwe Mbingu, hegu muye ukugela ugima nazo haukuli, mna Wafalisayo wayazumila ayo yose matatu. ");
INSERT INTO ngp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Vugo dyagendeelaga vitendese, nawamwenga mwa wahinizi we miko kafyo kakwe Mafalisayo nawakimala no kuhiga kwa nguvu wakagamba, “Hakikuona wavu wowose mwo mnt'hu uyu! Yadahika kugamba ni muye ywa ugima hegu mtumigwa ywa kwe Mbingu kalonga naye!” ");
INSERT INTO ngp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Vugo niyo dyongezekela hata mkulu we difyo dye Kilumi engilwa ni woga kugamba wadaha kumlatula Paulo vibesu besu, ivo niyo awasigiila wadya wank'hondo wakwe wamguhe Paulo no ku mwingiza kundani kwe nk'hambi ya wank'hondo. ");
INSERT INTO ngp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kilo kiya, Zumbe akimaalaga hagihi na Paulo niyo amgamba, “Usekogoha! Kwinkwa kuwagambila mbuli zangu want'hu wa Yelusalemu, waungwa utende iivo uko Loma.” ");
INSERT INTO ngp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kwize kuche, Wayahudi wekalaga hamwenga kwa kinyele, niyo waika kilapi kugamba, hawadye hegu kunywa mpaka aho nawande wamkoma kale Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Want'hu wajink'hile milongo mine waikaga kilapi kwa hamwenga. ");
INSERT INTO ngp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Waitaga kwa wakulu wa walava nt'hambiko na wadala vilongozi, no kugamba, “Suwe kiika kilapi cha hamwenga kugamba, hekilume no kudya chochose mpaka aho nekinde kimkoma Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Haluse elo, nyuwe hamwenga ne kitala tumeni want'hu kwo mkulu ywe difyo dye Kilumi vileke amwigale Paulo kwenyu mkakezige kugamba mwaunga mpate ikindedi mwa yehe. Mna nekikeike lumwe kumkoma hata uneva akei kubula hagihi.” ");
INSERT INTO ngp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mna mhwawe dya Paulo nakeva umzungu uwo, ivo aitaga kundani kwe digomela no kumgambila Paulo imbuli iyo. ");
INSERT INTO ngp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulo amwitangaga mkulu yumwenga mwa wank'hondo, niyo amgamba, “Mwigaleni ndugu ywetu uyo kwo mkulu we difyo dye Kilumi, ana kint'hu cha kumgambila.” ");
INSERT INTO ngp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mkulu uyo amguhaga uyo ndugu ywetu niyo amwigala mpaka ko mkulu we difyo dye Kilumi, yudya mnk'hondo niyo amgamba, “Yudya mvugailwa Paulo nakanitanga niyo anituma nimlete uyu ndugu ywetu kwako, kwaviya ana dya kukugambila.” ");
INSERT INTO ngp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yudya mkulu we difyo dye Kilumi, amtozaga mkono nokumwigala haheina want'hu niyo amuuza, “Una kint'hu chani cha kunigambila?” ");
INSERT INTO ngp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yehe niyo agamba, “Wayahudi waivana wakulombeze umwigale Paulo kwe kitala wakakeziga kugamba, kitala chaunga kive ikindedi kulawa kwakwe. ");
INSERT INTO ngp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mna weye usekuzumila kwaviya weyuko want'hu wajink'hile milongo mine wakefisile wakamgoja kumnk'hupukila. Waika kilapi kugamba hawadye no kunywa chochose, mpaka wamkome. Haluse wakeika lumwe kutenda ivo, elo wagoja ulamuzi wako.” ");
INSERT INTO ngp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mkulu we difyo dye Kilumi niyo amleka aite, mna nakamkanya akamgamba, “Use kumgambila yoyose kugamba kwiza kunink'ha lwazi.” Niyo amleka yudya ndugu ywetu aite. ");
INSERT INTO ngp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Basi mkulu we difyo dye Kilumi awetangaga wank'hondo waidi niyo awagamba, “Ikeni lumwe wank'hondo magana maidi, wezi falasi milongo mfungate, na watuhu magana maidi wande ne mikuki waite Kaisalia, mkeike lumwe kwinuka hainati kubula sant'hatu kilo cha dielo. ");
INSERT INTO ngp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ikeni falasi zimwenga kwajili ya Paulo, mbuzeni kwa vedi kwa Felikisi mkulu we Kilumi mwe isi ya Uyahudi.” ");
INSERT INTO ngp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Mkulu uyo wedifyo dye Kilumi nakawandika baluwa ikugamba. ");
INSERT INTO ngp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Miye Kilaudia Lusia nakuwandikila weye zumbe Felikisi Mkulu we Kilumi mwe isi ya Uyahudi. Nakulamsa! ");
INSERT INTO ngp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Wayahudi nawamgwila uyu mnt'hu naho waunga wamkome. Nehibunk'hula kugamba mnt'hu uyo ni Mlumi na ivo niyo naita na wank'hondo wangu ko kumkombola. ");
INSERT INTO ngp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nehimwigala kwe kitala chawe kikulu hazungula kumanya kilekile wakamlongeleza. ");
INSERT INTO ngp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nehibunk'hula kugamba, malongelezo yenye nayanda mwe kuhigana mwe zimbuli ze miko yawe, hiyone kugamba kabananga chochose kimuwagile avugailwe kwe divugailo hegu kukomwa. ");
INSERT INTO ngp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nize nigambilwe kugamba Wayahudi waunga wamkome nehiona vedi nimwigale kwako, niyo nawagamba walongelezi wakwe wakwigaile malongelezo yawe kwako.” ");
INSERT INTO ngp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Basi wadya wank'hondo nawamwigala Paulo enga ivo wagambigwe, no kumwigala kilo iikiya mpaka ko mzi wa Antipatili. ");
INSERT INTO ngp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Zuwa ditimile wank'hondo we viga nawauya kwe digomela no kuwaleka wadya wank'hondo we zifalasi wagendeele no utafi hamwenga na Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Weze wabulaga Kaisalia, wamwink'haga mkulu wo mkoa ibaluwa idya no kumwink'hiza Paulo mwe mikono yakwe. ");
INSERT INTO ngp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felikisi eze aisome ibaluwa, amuuzaga Paulo kugamba kulawa mkoa uhi? Eze agambilwe kugamba kalawa mkoa wa Kilikia, ");
INSERT INTO ngp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","niyo agamba, “Nenitegeleze masa yako aho walongelezi wako wanabula.” Niho akisigiila Paulo aikwe mo ukaulwa mndani mo ukumbi wo mkulu wo mkowa etangwe Helode. ");
INSERT INTO ngp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Yeze yomboke mazuwa mashano, Anania Mlava nt'hambiko Mkulu abulaga Kaisalia akanda hamwenga na wadala vilongozi wamwenga no mkimaila mbuli akwitangwa Tetulo, nawamwitila yudya mkulu wo mkoa niyo wamgambila malongelezo yawe mwa Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulo naketangwa, Tetulo niyo akonga malongelezo enga ivi, “Zumbe Felikisi, ulongozi wako wedi ukigaila utondowazi mkulu no kugolola kukuungwa mkukigala uwedi kwetu. ");
INSERT INTO ngp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Chaihokela imbuli ino kwa kinyemi mazuwa yose na kulava ukulu zitendese hohose kwako. ");
INSERT INTO ngp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mna haheina kwaza lupisi chakulombeza utegeleze ulosi wetu mguhi. ");
INSERT INTO ngp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kibunk'hula kugamba mnt'hu uyu nk'hondo itendese, yehe ni nk'hongelo ya nk'humbizi mwa Wayahudi hant'hu hohose mwe isi naho ni kilongozi wo umwenga wa Wanazaleti. ");
INSERT INTO ngp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Naho nakageza kuilonga vihile inyumba yo kuvikila, niyo suwe chamgwila. Nekikaunga kimsengele viligane ne miko yetu. ");
INSERT INTO ngp_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ivo Lusia mkulu we difyo dye Kilumi kwa nk'humbizi nk'hulu niyo akihoka mnt'hu uyo kulawa kwetu. Asigiilaga walongelezi wa Paulo weze kwako, ");
INSERT INTO ngp_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Mneva unamlaha, wadaha ukabunk'hula zimbuli izi zose kikumlongelezela.” ");
INSERT INTO ngp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Wayahudi wayagwaga mgongo malongelezo ayo yose wakagamba, yose ayo na yanda ni kindedi. ");
INSERT INTO ngp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mkulu wa Uyahudi Filikisi niyo amwink'ha Paulo kilagiso vileke alonge, Paulo niyo agamba, “Himanya kugamba kunda mlamuzi mwe ditaifa idi kwa myaka mingi, naivo nna kinyemi kukegombela mwa meso yako. ");
INSERT INTO ngp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wadaha kunda ne kindedi kugamba hayakujink'ha mazuwa mlongo na maidi yomboke, kukongela hadya naitile Yelusalemu kugenda kuvika. ");
INSERT INTO ngp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wayahudi hawanione halafya na mnt'hu yeyose, hawanibwiile hawasongeza want'hu kwe Nyumba za kuvikila, hegu mwe zinyumba za Mnungu, hegu hant'hu hatuhu hohose mwo mzi uwo. ");
INSERT INTO ngp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Naho hawakudaha kulavanya malongelezo yawe kwangu. ");
INSERT INTO ngp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kint'hu huzumila mwa meso yako ni kugamba, miye na mvika Mnungu wakale wetu kwa kutimila Sila idya woho wakuigamba lulimi, Mna naho nahuwila mbuli zose ziwandikwe mwe vitabu ve miko ya Musa, hamwenga na walotezi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nna makawiilo kwa Mnungu, ayadya woho nawo wakukukawiila kugamba want'hu wedi na waihile nawauyuke. ");
INSERT INTO ngp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kwa ivo nakombeka mazuwa yose kunda na moyo wedi mwa meso ya Mnungu na want'hu. ");
INSERT INTO ngp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Nize nikale hale na Yelusalemu kwa mazuwa mengi, nehiita uuko Yelusalemu kugenda kuguha matundu kwa wandugu zangu vileke niwegaile wambuyazangu wambizi na kulava malavo. ");
INSERT INTO ngp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Umwo nandile hadamanya ayo niho wanibwiilaga kwe nyumba ya Mnungu, naho nehinda hidamanya kale mviko wo kukesunt'ha hakwandile na fyo dya want'hu hegu nk'humbizi yoyose. ");
INSERT INTO ngp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Mna nokunda na Wayahudi wamwenga kulawa kwe isi ya Asia ndodo, awo nawo wawagilwe kunda mwa meso yako dielo aha, no kulonga malongelezo yawe uneva wananayo yoyose yo kulonga mwa miye. ");
INSERT INTO ngp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Hegu du waleke awa weyaha walonge wiihi uwo waone umwo nakimale hameso ye kitala chawe, ");
INSERT INTO ngp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","uneva hiyo ino du milosi nilongile Umwo nakimale hameso yawe, ‘mwanisengela dielo kwaviya hitozeleza ulosi wa kugamba wabanike nawauyuke.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Aho Felikisi yudya adimanyaga vedi difyo dya wamhuwile Yesu Kilisito nakawagamba, “Nenilave fanyanyi mwa masa aya aho neezile Lusia, Mkulu we difyo dye Kilumi.” ");
INSERT INTO ngp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Felikisi amgambaga yudya mkulu we difyo dya wank'hondo, Paulo amilwe mna ande no vilekelwa ludodo, naho wambuyaze wasekufingizwa kumwink'ha vint'hu mo uungi wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Yeze yomboke mazuwa mageke, Felikisi nakabula hamwenga na mkaziwe Dulusila, uyo andaga Myahudi. Aungaga Paulo egalwe kwakwe, amtegeleze ivo akulonga naivo akumhuwila Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mna Paulo Umwo andaga akagendeela kulonga mbuli yo kumwelela, na kukefingiza, ne dizuwa dyo Usengelo, Felikisi nakogoha niyo agamba, “Kwa haluse wadaha kuita nenize hwitange naho heza kupata luneka,” ");
INSERT INTO ngp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Aaho naaka kawiila kugamba Paulo naamfumbase matundu, valeka naaka mwitanga itanga Paulo nokusimuila nae. ");
INSERT INTO ngp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ize yomboke myaka miidi Pokio Fesito na kuguha ukulu hant'hu ha Felikisi. Kwaviya Felikisi aungaga kuwadamanyila Wayahudi uwedi, amwasaga Paulo kwe divugailo. ");
INSERT INTO ngp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Yeze yomboke mazuwa matatu, Fesito abulaga mwo mkoa wakwe, alawaga Kaisalia kuita Yelusalemu, ");
INSERT INTO ngp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","uko wakulu wa walava nt'hambiko hamwenga na vilongozi wa Wayahudi wegalaga malongelezo yawe mwa Paulo. Nawamlombeza Fesito ");
INSERT INTO ngp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Awadamanyile mbuli yedi ya kumwigala Paulo uko Yelusalemu, kwaviya nawaunga mzungu wakumkomela Paulo mwe sila. ");
INSERT INTO ngp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesito awahitulaga, “Paulo kavugailwa uko Kaisalia, name neniuye uuko nguvu. ");
INSERT INTO ngp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Gojeni niitanyene vilongozi wenyu wakamlongeleze uko uneva ana idyo abanange.” ");
INSERT INTO ngp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesito ekalaga nao kwa mazuwa mnane hegu mlongo, niyo aita Kaisalia. Mwedizuwa ditimile, Fesito ekalaga hekiti che kitala no kusigiila Paulo egalwe kwakwe. ");
INSERT INTO ngp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paulo eze abule, Wayahudi walawile Yelusalemu wakimalaga wakanda wamzunguluka no kukonga kulava malongelezo yabindile ingi hewedahile kuya lavila uwona wakwe. ");
INSERT INTO ngp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mna Paulo akegombelaga akagamba, “Miye hitendile dyodyose diihile dya kuhiga miko ya Wayahudi, hegu kuhiga Nyumba yo kuvika, hegu kuuhiga Seuta ywa Loma.” ");
INSERT INTO ngp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mna Fesito nakaunga kuwadamanyila uwedi Wayahudi, ivo niyo amuuza Paulo, “Waunga hwigale Yelusalemu vileke ukasengelwe uko mwa meso yangu, mwa malongelezo aya?” ");
INSERT INTO ngp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo niyo ahitula, “Nakakimala hameso ye kitala cha Seuta ywa Kilumi, Ivo hiwagilwa kwinkwa usengelo aaha. Hiwadamanyile Wayahudi wiihi wowose wemwenye kumanya vedi. ");
INSERT INTO ngp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Mna uneva hibananga miko ya kuniunga kukomwa, hikulombeza kuusilwa usengelo uwo, Mna uneva hakihali kindedi mwa malongelezo yawe ayo wayalongile, hahali akudaha kunink'hiza kwawe, Nalombeza kuhimbiluka kwa Seuta ywe Kilumi.” ");
INSERT INTO ngp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesito, eze dione hamwenga na walangilizi wakwe, nakamgamba Paulo, “Kukant'ha Lufani kwa Seuta ywe Kilumi, vedi, nowigalwe kwa Seuta ywe Kilumi.” ");
INSERT INTO ngp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mazuwa mageke kulongole, Zumbe Agilipa na Benike wabulaga Kaisalia kumnamsa Fesito Seuta ywe Kilumi. ");
INSERT INTO ngp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Wandaga uuko mazuwa mengi, Fesito niyo amgambila Zumbe amasa ya Paulo, “Eyaha mnt'hu yumwenga atozelezagwa ni Felikisi. ");
INSERT INTO ngp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nize niite Yelusalemu, Wakulu wa walava nt'hambiko, na wadala vilongozi wa Wayahudi, nawamlongeleza, niyo wanilombeza amgele Paulo mwa masa asulumizwe. ");
INSERT INTO ngp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mna miye nehiwahitula kugamba hiyo kihendo cha Walumi kumlava mnt'hu asulumizwe uneva akei kulongelezwa no kudugana na walongelezi wakwe, no kwink'higwa luneka lwa kukegombela mwa yadya alongelezwe. ");
INSERT INTO ngp_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Elo weze wabule aha nehisunguza naho luvi yakwe nehitanga kitala, niyo nasigiila kugamba mnt'hu uyo egalwe aha. ");
INSERT INTO ngp_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Walongelezi wakwe wakimalaga, mna hawadahaga kulonga mbuli yoyose iihile mwa Paulo enga ivo nehakawiila. ");
INSERT INTO ngp_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nahanda du na mahigano na yehe mwe mbuli yo kuvika kwawe, ivo wakuhuwila mwa mnt'hu yumwenga abanikaga, akwitangwa Yesu, mna Paulo yehe agamba mnt'hu uyu emgima hata ivi. ");
INSERT INTO ngp_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Hione dyo kudamanya mwe imbuli ino, ivo nehimuuza Paulo uneva naakaunga kuita Yelusalemu vileke akauzwe uko mwa malongelezo ayo. ");
INSERT INTO ngp_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mna Paulo niyo ahimbiluka, alombezaga kutozelezwa na kumlekela mkulu we Kiloma aifanyanye imbuli ino, naivo niyo nasigiila atozelezwe mpaka aho nenimwigale kwa mkulu wa Kiloma.” ");
INSERT INTO ngp_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa niyo amgamba Fesito, “Nehaunga nimtegeleze umnt'hu uyu miye mwenye.” Fesito niyo amhitula, “Nomtegeleze luvi,” ");
INSERT INTO ngp_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ivo luvi yakwe, Agilipa na Benike wabulaga kwa kwanga hekitala hamwenga na wakulu wa mafyo ya wank'hondo ne vilongozi wo mzi, Fesito niyo agamba Paulo engizwe kundani kwe kitala. ");
INSERT INTO ngp_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesito niyo agamba, “Zumbe Agilipa hamwenga na wose mwiaha hamwenga nasuwe, Mwamuona mnt'hu akuwahiga Wayahudi wose waaha na wadya wa Yelusalemu, wamwigala kwangu kwa kulabila. Wagutilalaga wakagamba hawagilwe kunda mgima. ");
INSERT INTO ngp_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mna miye hione kugamba nakabalanga dyodyose mpaka asengelwe kukomwa, mna Kwaviya mwenye Paulo nakahimbiluka kwa mkulu wa Kiloma, niyo nasigiila egalwe Loma. ");
INSERT INTO ngp_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kwa miye hina ulosi we kindedi uwo hudaha kumwandikila mkulu wa Kiloma mwa Paulo, nivo vikuleka himleta aha hameso yenyu na Zumbe Agilipa, vileke habinda kupelemba ninde na dyo kulonga. ");
INSERT INTO ngp_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwaviya nevigele seko kumwigala mvugailwa haheina kuyalonga malongelezo yakumgweela.” ");
INSERT INTO ngp_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Zumbe Agilipa amgambaga Paulo, “Kwink'higwa luneka lwa kukegombela.” Aho Paulo na kuchulula mkono wakwe akakegombela saivi. ");
INSERT INTO ngp_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Zumbe Agilipa! Nakeona kunda mta masa, dielo kukegombela hameso yako mwa malongelezo yose yalongigwe ni Wayahudi mwa miye, ");
INSERT INTO ngp_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","vitendese kwaviya weye mwenye ummanyi we vihendo va Wayahudi hamwenga nezimbuli hewekuivana, ivo nakulombeza unitegeleze kwa kufinyiliza. ");
INSERT INTO ngp_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wayahudi waumanya wikazi wangu kulawa udodo, ivo nekale kukongela nk'hongo mwe isi yangu na Yelusalemu. ");
INSERT INTO ngp_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wammanya Lupisi lutali, uneva nawadahe wakalonga uwona wawe mwa miye uneva wakaunga, kugamba kukongela nk'hongo nehikala enga yumwenga mwa kafyo chandile na siasa nk'hali, wakwitangwa Wafalisayo. ");
INSERT INTO ngp_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Haluse niyaha nisengelwe kwaviya nakawiila lagano Mnungu awenk'haga wakale wetu, ");
INSERT INTO ngp_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ino niyo indagano idya ikukawiilwa na wakale wetu, wakamvika Mnungu msi na kilo. Zumbe dyangu, aya nayo yakuleka Wayahudi wakanilongeleza. ");
INSERT INTO ngp_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nii mwaona vihile kuhuwila kugamba Mnungu auyula want'hu wabanike? ");
INSERT INTO ngp_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Miye mwenye nehifanyanya kugamba nehaungwa kudamanya mbuli yoyose ya kuwahiga want'hu wakudihuwila dizina dya Yesu ywa Nazaleti. ");
INSERT INTO ngp_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Mbuli izo nizo nidamanye uko Yelusalemu, miye mwenye handa hink'higwa udahi ni wakulu wa walava nt'hambiko, nawavugailaga kwe divugailo want'hu wengi wa Mnungu, naho wakasengelwa kukomwa, nehigwa mgongo kuzumila kukomwa kwawe. ");
INSERT INTO ngp_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nkanana nyingi nehiwatenda wasulumizwe mnenge nyumba zawe za Mnungu, nokuwatigiza wa ulemele mhuwi wawe. Nandilisaga na maya mwa woho niyo nawazungula mpaka kwe mizi ya hale. ");
INSERT INTO ngp_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ivi nivo valekaga haita Damesiki handa hink'higwa udahi na miko ni wakulu wa walava nt'hambiko. ");
INSERT INTO ngp_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Zumbe, Umwo nandaga mwe sila, msi wa gati, naonaga ung'azi ukujink'ha ung'azi wedizuwa, kulawa kulanga, niyo wanizunguluka miye na watafi wambuyazangu. ");
INSERT INTO ngp_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Suwe chose chagwaga hasi, miye nevaga izwi dikunitanga kwa Kiibulania, ‘Sauli, Sauli, nii wanisulumiza? Wekelumiza bule enga mp'hunda ikutoa mazela ingoda ya zumbe ywakwe.’ ");
INSERT INTO ngp_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Miye namuuzaga, ‘Weye ni weye ani Zumbe?’ Yesu niyo ahitula, ‘Nimiye Yesu uyo weye ukunisulumiza. ");
INSERT INTO ngp_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mna haluse inuka, naho Kimala, hikulaila vileke hutende mtumwa ywangu, no uwalavile uwona watuhu zimbuli ziya uzione kwangu dielo, na yadya yakwiza kulongole nayo no hulagise. ");
INSERT INTO ngp_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","No hwamile mwa want'hu wa Izilaeli naho nohwamile mwa watuhu hi Waizilaeli wadya huunga hutume kwawe. ");
INSERT INTO ngp_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nouwenk'he kumanya, no kuwalava mo uhezi mwo udahi wa Mwavu, wamhitukile Mnungu vileke kwa kuhuwila wapate kuusilwa wavu wawe no kuhokela hant'hu hawe, mgati mwa wadya wasagulwe kunda want'hu wa Mnungu.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Na ivo, zumbe Agilipa, hidunduga kuzilemela mbuli za kulanga nilagiswe. ");
INSERT INTO ngp_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nk'hongo mwe Damesiki, na mwe Yelusalemu naho akajika mwo Uyahudi yose na mwa want'hu wamwenga hi Wayahudi, Nehiwabilikiza waleke wavu wawe, wamuuie Mnungu, no kulagisa kwa udamanyi kugamba wakeiila wavu wawe. ");
INSERT INTO ngp_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa ayo Wayahudi wanigwilaga Umwo nandile kwe Nyumba ya Mnungu, niyo wageza kunikoma. ");
INSERT INTO ngp_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mna Mnungu kanambiza mpaka mwedizuwa dya dielo, naho hikimala nitogile halava uwona wangu kwa wose, kwa wakulu, na wadodo. Hina dya kulonga mwa yadya yalongagwa ni Walotezi na Musa kugamba nayalaile. ");
INSERT INTO ngp_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Wakagamba, neviungwa Kilisito Mkombozi kusulumizwa no kunda wa nk'hongo kuuyuka kwa wabanike, kubwelekeza ung'azi wo ukombola kwa Wayahudi na want'hu wose.” ");
INSERT INTO ngp_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo eze abule aho mo kukegombela, Fesito niyo amkwank'hila kwa izwi kulu, “Paulo umkilalu! Kuhinisa kwako kwa kugela kilalu!” ");
INSERT INTO ngp_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Mna Paulo niyo agamba, “Zumbe Fesito, miye hiyo mkilalu, kiya hulonga ni kindedi kihala. ");
INSERT INTO ngp_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Zumbe, weye kuyamanya aya, kwa ivo na mwadaha kulonga haheina kogoha. Nna ikindedi kugamba aya yalaile yamanyika kwako, kwaviya mbuli izi hazidamanywe kifiso. ");
INSERT INTO ngp_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Togola zumbe Agilipa, weye una mhuwi na Walotezi? Himanya kugamba una mhuwi” ");
INSERT INTO ngp_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agilipa niyo amhitula Paulo, “Kwa lupisi luguhi ulu nounitende kunda mhuwila ywa Kilisito?” ");
INSERT INTO ngp_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo niyo ahitula kugamba namlombeza Mnungu, “Kwa lupisi luguhi hegu lutali, hiyo weye du, mna wose wakuniva dielo wadahe kunda enga ivo miye nili mna hiyo kwa mp'hingu izi!” ");
INSERT INTO ngp_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Aho niyo zumbe, mkulu wo mkoa, na Benike na wadya watuhu wose wandile hamwenga nawo nawakimala. ");
INSERT INTO ngp_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Weze wahalawe niyo wagambana, “Mnt'hu uyu habanange dyodyose diwagile usengelo wa kukomwa hegu kugenda kuvugailwa kwe divugailo.” ");
INSERT INTO ngp_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa naye niyo amgamba Fesito, “Mnt'hu uyu hegu nakalekelwa wandile hahimbiluke kwo mkulu wa Kiloma.” ");
INSERT INTO ngp_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Weze kibule mo ulamuzi wo kuita Italia nawamuiika Paulo na wafungwa weyawe watuhu mo wamizi wa Yulio, mkulu we difyo dya watowani dye Kilumi dikwitangwa “Fyo dya Augusito.” ");
INSERT INTO ngp_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Chakwelaga ngalawa ya Adilamito yandaga ikatamba no kombokela kwe zibandali zo mkoa wa Asia, niyo chakonga utafi. Alistaliko mkaya ywa Makedonia alaile Sesalonike, andaga hamwenga na suwe. ");
INSERT INTO ngp_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Luvi yakwe chaikaga nt'hulwe mwe bandali ya Sidoni. Yulio amtendelaga vedi Paulo kwa kumleka awaone wambuyaze vileke enk'hwe yadya andaga akayaunga. ");
INSERT INTO ngp_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kulawa uko nekigendeela, mna kwaviya nk'hung'unto neikakihingamila kwa nguvu, chombokelaga kwe nt'hendelo int'huhu ye kisiwa cha Kipulo. ");
INSERT INTO ngp_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Niyo chajink'hanya Ibahali ya Kilikia ne ye Pamfilia niyo chaika nt'hulwe aho Mula mzi wa Lukia. ");
INSERT INTO ngp_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Yudya mkulu niyo abwiila ngalawa ya Alekizandilia yandaga ikaita Italia niyo akikweza uumo. ");
INSERT INTO ngp_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kwa mazuwa mengi chagendaga mp'halahole, naho kwa udala utendese chabulaga hagihi na Nido, kwaviya ink'hung'unto yandaga ika kihingamila kisekugendeela mwe nt'hendelo idya, nekiseela nokombokela nt'hendelo ya Kilete hagihi ne isi nk'havu ya Salimoni ingile mwe bahali, kwandaga hekwiina nk'hung'unto nk'hulu. ");
INSERT INTO ngp_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nechombokela mnk'handa mwakwe mp'halahole niyo chabula hant'hu hakwitangwa, Bandali Yedi hagihi no mzi wa Lasea. ");
INSERT INTO ngp_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kiguha mazuwa mengi, mpaka yanda hatali kugendela mwa mazi kwaviya dizuwa dyo kuvina wila wo kufunga dyandaga dyomboka. Ivo Paulo niyo awakanya. ");
INSERT INTO ngp_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Wagosi, naona enga utafi uno nounde mdala naho nowaze ugoli ne ngalawa, hamwenga no ugima.” ");
INSERT INTO ngp_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mna yudya mkulu na keleleswa ne zifanyanyi za mgendeza ngalawa na za mta ingalawa kuzileka zifanyanyi za Paulo. ");
INSERT INTO ngp_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kwaviya bandali iyo hayandile ni hant'hu hedi hokwikala mwo lupisi we mp'heho, wengi waungisaga kugendeela no utafi, ikadahika wabule Foinike, Foenike ni bandali ya Kilete ikuhinga kwa mwenye mzi yo usweelo wa zuwa, na Kusini ulailo wa zuwa. ");
INSERT INTO ngp_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Basi mp'heho yedi ya kusini niyo yakonga kuvuguta, woho nawakagamba napate makawiilo yawe, ivo niyo wausa chuma kizamile kikutozeleza ingalawa no kugendeza ingalawa yawe hagihi vitendese ne mp'wani ya Kilete. ");
INSERT INTO ngp_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mna halwomboke lupisi, nk'hung'unto nk'hulu ikwitangwa nk'hung'unto ya “Kwa mwenye mzi” yakongaga kuvuguta kulawa kwe kisiwa no kuisindikila ingalawa kwe bahali. ");
INSERT INTO ngp_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nkung'unto neitoa ingalawa, naho kwaviya hachadahile kuhigana nayo chailekaga ingalawa isukumizwe ni ink'hung'nto iyo. ");
INSERT INTO ngp_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nekipata nk'hinga aho kize chombokele kusini ye kasiwa kamwenga kakwitangwa Kauda. Hadya handaga na udala, naivi nekiungwa kuuhonya mtumbwi we ngalawa. ");
INSERT INTO ngp_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nawauvuta udya mtumbwi kundani niyo wazinganiza sigi idya ingalawa no kuikakiliza, nawogoha kugamba nawakadaha kukwama kudya kwo uheelo we bahali, mp'wani yafilika ya kwa mwenye mzi uko Libia, ivo nawaseleza disuke dye ingalawa no kuileka ingalawa iguhigwe ni nk'hung'unto. ");
INSERT INTO ngp_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mjubwaniko nougendeela niyo luvi yakwe wakonga kuduula kuse imizigo yandile mwe ngalawa ");
INSERT INTO ngp_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","naho mwedizuwa dya katatu nawakonga kuuduula vidamanyilo ve ngalawa mwa mazi. ");
INSERT INTO ngp_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa mazuwa mengi hakione zuwa hegu nt'hondo no mjubwaniso wagendeelesaga, makawiilo yo ugima wetu nayaga. ");
INSERT INTO ngp_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Weze wekale mazuwa mengi haheina kudya nk'hande, Paulo akimaalaga hagati yawe na kugamba, “Wagosi! Nevinda vedi mwanitegeleze, no kuleka kutamba kulawa Kilete, hegu nekihona na ubanangi nowagilizi uno wose. ");
INSERT INTO ngp_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mna haluse nawalombezani keink'heni moyo, hahali hata yumwenga akuunga aze ugima wakwe ingalawa du niyo niyage. ");
INSERT INTO ngp_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kwaviya gulo nekilo Mtumigwa ywa kwe mbingu ywa Mnungu ywangu naho uyo Mnungu humvika, nakaniizila ");
INSERT INTO ngp_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Mtumigwa ywa kwe mbingu niyo anigamba, ‘Paulo usekogoha, waungwa kukimala hameso ha zumbe Seuta ywe Kilumi, naho kwajili ya wenye Mnungu naawakombole wadya wose ukutambanya nawo mwe ngalawa wasekwangamila.’ ");
INSERT INTO ngp_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ivo mazumbe keink'heni moyo! Kwaviya nahuwila Mnungu kugamba nevinde ivo nigambilwe. ");
INSERT INTO ngp_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mna chaungwa kiduulwe kwe kisiwa kimwenga.” ");
INSERT INTO ngp_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kilo cha zuwa dya mlongo na kane, nekika jubwaniswa ni nk'hung'unto uku na uku mwe bahali ya Meditelaniani. Mwe kilogati, wogelezi waonaga enga chandaga hagihi ne isi nk'havu. ");
INSERT INTO ngp_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ivo nawakazungula utali we ibahali kwa kuseleza luzigi lwa fundikagwa kint'hu kizamile, niyo wapata utali wa mikono milongo mine kuita hasi niyo wahima kaidi, no kupata mikono milongo mitatu. ");
INSERT INTO ngp_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kwa kogoha kukwama mwe zinyuwe, nawaseleza machuma mane yazamile yakutoza ingalawa kunyuma ye ngalawa, uku wakalombeza kusunguze kucha. ");
INSERT INTO ngp_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Wogelezi waungaga kunyilika naho nawaseleza kale umtumbwi mwa mazi wakakeziga kugamba wagenda kuseleza chuma kizamile kikutoza ingalawa ye ngalawa nt'hendelo ya kulongole ye ngalawa. ");
INSERT INTO ngp_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mna Paulo niyo amgamba yudya mkulu we difyo dye Kilumi na wank'hondo wakwe, “Uneva wogelezi hawana sigale umwo mndani mwe ngalawa, homkauile kuhona” ");
INSERT INTO ngp_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Aho wadya wank'hondo niyo wazisenga ziya zisigi zandile zitoza idya ingalawa indodo, niyo wauleka ukubigwe na mazi. ");
INSERT INTO ngp_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Aho kukaunga kuche, Paulo awatigizaga wose wadye nk'hande, “Kwa mazuwa mlongo na mane mwa mashaka naho haheina kudya chochose. ");
INSERT INTO ngp_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Elo nawalombezani mdye nk'hande niho mgendeele no ugima, kwaviya hata luvili lumwenga kwe mitwi yenyu holwage.” ");
INSERT INTO ngp_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Eze ajink'he kulonga ivo, Paulo aguhaga mkate na kuubendula na kumtogola Mnungu hameso yawe no kukonga kudya. ");
INSERT INTO ngp_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Aho wose niyo wapata moyo wo kudya nk'hande niyo nao wadya. ");
INSERT INTO ngp_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kwa hamwenga chandaga mwe ngalawa iyo, want'hu magana maidi na milongo mfungate na waidi. ");
INSERT INTO ngp_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kila yumwenga eze adye mkate no kwiguta nawahungula kuzama kwe ngalawa kwa kuiduula ink'hande mwe bahali. ");
INSERT INTO ngp_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kwize kuche wogelezi hawadahile kuikombaganya isi idya, ila nawaona bahali ndodo ingile mwe isi nk'havu yo msanga, niyo wafanyanya kugamba hegu vadahike nawaika nt'hulwe uuko. ");
INSERT INTO ngp_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ivo niyo wakant'ha machuma kizamile kikuitoza ingalawa nakuzileka mwe bahali, aaho nawazifungula zisigi zandile zikikaka kilongozela. Niyo watungika disuke dye ngalawa kulongole vileke ink'hung'unto iisukumize ingalawa kulongole no kuhamila mwo msanga we bahali. ");
INSERT INTO ngp_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mna wabula hamwenga hadugane bahali mbili, ngalawa niyo yakwama, kwa kulongole neididimila mwo msanga, haheina kusingisika, kwa kunyuma nako nokukonga kubogozoka mabasi basi, kwajili yo mjubwaniso wa mazi. ");
INSERT INTO ngp_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wank'hondo waungaga kuwa koma wavugailwa wose kwakogoha kugamba wavugailwa ao nawakadaha kogeela mpaka ng'ambu niyo wanyilika. ");
INSERT INTO ngp_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mna Kwaviya yudya mkulu we difyo dye Kilumi naakaunga amhonye Paulo nakawafingiza wasekutenda ivo, nakawalekela wadya wadahile kogeela wapilike kulawa mwe ngalawa no kogeela mpaka ng'ambu ");
INSERT INTO ngp_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","wamwenga wakaketozela mwa mabasi ye ngalawa ibogozoke. Ivi nivo wose kibuile ng'ambu kwa vedi. ");
INSERT INTO ngp_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kize kibule vedi mwe isi nk'havu, nekibunk'hula kugamba kisiwa kiya nekiketangwa Malita. ");
INSERT INTO ngp_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wakaya wa aho wandaga wedi vitendese kwetu fula neikakonga kunya naho nokukalosa, ivo niyo wagima moto na kukitanga. ");
INSERT INTO ngp_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo alogotaga kazilo kadodo kakwe nk'huni niyo azigeela mo moto, aaho kwajili ye kizihuye cho moto, niyo kwa laila nyoka mwe zink'huni na kumluma Paulo mwo mkono nokung'ang'anila ahadya. ");
INSERT INTO ngp_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wakaya wa hadya weze waione idya inyoka yaning'inila mwo mkono wakwe niyo wagamba, “Kindedi mnt'hu uyu kakoma, hamwenga na kugamba kayokolwa kulawa mwe kubanika mwe bahali, kuzumilwa kunda ywedi ha meso ha Mnungu hokumleke agendeele kunda mgima.” ");
INSERT INTO ngp_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mna Paulo nakaikung'unt'hila momoto idya inyoka naho halumizwe hohose. ");
INSERT INTO ngp_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wadya want'hu nawakakawiila kugamba hegu nakalulumka, naho hegu nakagwa na kubanika aaho. Mna weze wagojele kwa lupisi lutali, haheina kuwona kugamba Paulo kapatigwa ni mbuli yoyose iihile, nawahitula zifanyanyi zawe mwa yehe na kugamba, “Yehe mnungu!” ");
INSERT INTO ngp_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Handaga hiho hale na hant'hu hadya handaga ne migunda ya Pubilio, mkulu we kisiwa kiya. Pubilio Akihokelaga kwa kise, no kunda wageni wakwe kwa mazuwa matatu. ");
INSERT INTO ngp_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ise dya Pubilio andaga mnyonge wa molusazi, mnyonge wa misango ya kuhala, Paulo nakagenda kumuwona, eze abinde kuvika Mnungu agelekaga mikono mo mnyonge no kumhonya. ");
INSERT INTO ngp_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kwa kulaila idyo, wanyonge wose mwe kisiwa kiya naweza na kuhonyigwa. ");
INSERT INTO ngp_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Want'hu wakink'haga mageleko, naho kize kikonge naho utafi nawagela mwe ngalawa vint'hu vingi kikuviunga mwe nt'hambo. ");
INSERT INTO ngp_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ize yomboke miyezi mitatu, nekikonga naho utafi wetu mwe ngalawa imwenga ya Alekizandilia, ikwitangwa “Milungu Mapasa”, ngalawa iyo yaikaga nt'hulwe hekisiwa mo msimo wose we mp'heho. ");
INSERT INTO ngp_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nekibula mo mzi wa Silakusa, no kwikala aho mazuwa matatu. ");
INSERT INTO ngp_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kulawa uko nekikonga utafi na kuzunguluka no kubula mo mzi Legio. Dize dyomboke zuwa dimwenga ink'hung'unto neikonga kuvuguta kulawa kusini, naho yeze yomboke mazuwa maidi nekibula kwe bahali ya Potioli. ");
INSERT INTO ngp_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Uko chawabwiilagwa wandugu wahuwila wengi wakilombezaga kikale nao kwa juma dimwenga. Naivo nekibula Loma. ");
INSERT INTO ngp_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wahuwila wa kudya Loma weze weve zimbuli zetu, naweza kukihokela hant'hu ha gwilo dya Apio na nyumba nt'hatu, Paulo eze awaone, nakamtogola Mnungu no kupata nguvu. ");
INSERT INTO ngp_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kize kibule Loma Paulo nakalekwa kwikala ekedu kedu hamwenga na mnk'hondo kumwamila. ");
INSERT INTO ngp_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Mazuwa matatu yeze yomboke Paulo awetangaga wakulu we Kiyahudi wa hant'hu aho weze waduganyike, Paulo niyo awaganba, “Waizilaeli wambuyazangu, hata uneva miye hidamanye chochose kiihile hekikuzumilana na want'huwetu hegu vihendo viya kihokele kulawa kwa wakale wetu, nehitendigwa kunda mvugailwa kudya Yelusalemu no kwink'hizwa kwa Walumi. ");
INSERT INTO ngp_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Weze waniuze no kuwona kugamba hyandile na masa yoyose, nawaunga kunilekela. ");
INSERT INTO ngp_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mna Wayahudi wamwenga nawalemela imbuli iyo, name niyo yaniunga kukant'ha lufani kwa Seuta ywa Kilumi, hata uneva hyandile na cha kuwalongeleza Waizilaeli wambuyazangu. ");
INSERT INTO ngp_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ivo nivo vilekile hilombeza kudugana no kusimuila na nyuwe, kwaviya hikakigwa mp'hingu kwe mbuli ye kawiilo idyo dya Izilaeli.” ");
INSERT INTO ngp_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Woho niyo wamgamba, “Suwe hakihokele baluwa yoyose ilaile Yudeya, naho hahali mndugu yeyose abuile aha kukink'ha ulosi ukint'hile, hegu kulonga chochose kiihile mwa weye. ");
INSERT INTO ngp_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mna nekikaunga kive zifanyanyi zako we mwenye, izimbuli zimwo mtwi wako, kwaviya kimanya kugamba kila hant'hu want'hu wasimuila hevikuligana ne difyo dyenyu.” ");
INSERT INTO ngp_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Basi wapangaga naye zuwa dyedi dya kudugana naye, naho wengi niyo wabula uko ekalaga. Kukongela mtondo mpaka kisingi Paulo naakawasimuila ulosi wo Useuta wa Mnungu, akageza kuwatenda wazumile zikulongwa mwa Yesu kwa kulawa mwe vitabu ve miko va Musa na va walotezi. ");
INSERT INTO ngp_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Want'hu wamwenga mwa woho nawahuwila zimbuli zakwe, mna wamwenga hawahuwile. ");
INSERT INTO ngp_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Basi niyo kwanda na kupangana kwe zifanyanyi mgati mwawe, umwo Paulo eze alonge mbuli ino, “Muye ywa Mnungu nakalonga vedi kwombokela kwo mlotezi Isaya mwe mbuli ya wakale wenyu! ");
INSERT INTO ngp_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Kwaviya nakagamba, ‘Ita kawagambe want'hu awa, Nomtegeleze no kwiva, mna homkombaganye, nomkaule no kukaula, mna homuwone, ");
INSERT INTO ngp_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kwaviya ubala wa want'hu awa ubwalata, naho wasita magutwi yawe, no kufinya ameso yawe. Wanase kukaula niyo waona na meso yawe, hegu wanase kutegeleza niyo weva, no kukombaganya kwa ubala wawe, wanase kunihitukila, niyo nawahonya.’ ” ");
INSERT INTO ngp_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paulo niyo agamba, “Elo manyeni kugamba ulosi udya wa Mnungu wo kukombola want'hu, wigalwa kwa want'hu hi Wayahudi woho na wautegeleze!” ");
INSERT INTO ngp_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paulo eze alonge ivi, Wayahudi wahalawaga wakahigana woho kwa woho. ");
INSERT INTO ngp_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kwa myaka miidi migima Paulo naakekala mwe nyumba apangile yehe mwenye, niyo awahokela wose wezile kumlamsa. ");
INSERT INTO ngp_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nakanda akabilikiza Mbuli yo Useuta wa Mnungu, na kuhiniza mwa zumbe yesu Kilisito kwa weduvi haheina mafingizo yoyose.");
INSERT INTO ngp_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Miye Paulo, mtumwa ywa Yesu Kilisito nitangwe ni Mnungu kunda mwigala ulosi naho nisagulwe niwabilikize want'hu Mbuli Yedi. ");
INSERT INTO ngp_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Aho kale Mnungu alaganaga na want'hu Mbuli Yedi ino kombokela walotezi wakwe mwa Mawandiko Yakukile. ");
INSERT INTO ngp_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Mbuli Yedi ino yalonga mbuli za Mwana Mnungu, mwo unt'hu wakwe andaga mwelekwa ywa lukolo lwa Daudi, ");
INSERT INTO ngp_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","mna Muye Akukile aho eze amuuyule alagisaga kugamba Zumbe ywetu Yesu Kilisito ni Mwana Mnungu mta udahi. ");
INSERT INTO ngp_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kombokela yehe, kihokela uwedi na kakitenda wegala ulosi, vileke kiwatende want'hu we isi zose wahuwile na kumwiva. ");
INSERT INTO ngp_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ino ni hamwenga na nyuwe mkwikala Loma, nyuwe mwitangwe ni Mnungu kunda want'hu wa Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Naivo nawawandikilani nyuwe nyose mwi Loma muungiswe ni Mnungu, no kuwetanga nyuwe mnde want'hu wakwe. Uwedi no utondowazi wa Mnungu Tati yetu na Zumbe Yesu Kilisito vinde na nyuwe. ");
INSERT INTO ngp_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nk'hongo ya yose, namtogola Mnungu kwajili yenyu nyose kwa sila ya Yesu Kilisito, kwaviya mhuwi wenyu wevika mwe isi yose. ");
INSERT INTO ngp_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mnungu uyo miye humdamanyila ndima kwo moyo wangu wose, mwo kubilikiza Mbuli Yedi ya Mwanawe niye muwona ywangu kugamba hikuleka kuwalombezelani, ");
INSERT INTO ngp_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","namlombeza Mnungu kugamba nenibule uko kwenyu hapata luneka kwa ivo Mnungu naaunge. ");
INSERT INTO ngp_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kwaviya namunk'hwa kwiza kuwaona vileke niwatendeni mhokele vipe va kimuye va kuwatendani mtoge. ");
INSERT INTO ngp_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Icho hulonga ni iki, miye nigelwe moyo kwa sila yo mhuwi wenyu name niwageleni moyo kwa sila yo mhuwi wangu. ");
INSERT INTO ngp_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Wandugu zangu, naunga mmanye kugamba nk'hanana nyingi nehiunga kwiza kuwatalamkila, mna hata ivi hikindilwa. Nehaungisa niwatende want'hu wamhuwile Yesu Kilisito uko kwenyu enga viya nitendile kwa want'hu wa si nt'huhu. ");
INSERT INTO ngp_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Natigizwa kuwabilikiza want'hu wose, Wayunani na wa si nt'huhu, wasomile na hewesomile. ");
INSERT INTO ngp_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nivo vikuleka namunk'hwa kubilikiza Mbuli Yedi kwenyu nyuwe mkwikala Loma. ");
INSERT INTO ngp_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Hikuionela soni Mbuli Yedi, kwaviya ni ludole lwa Mnungu lukwigala uyokozi kwa wose wakuhuwila, nk'hongo Wayahudi, na want'hu hi Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kwaviya Mbuli Yedi yalagisa ivo Mnungu akuwazumila want'hu wande wedi hameso hakwe, mbuli ino yadamanywa kwa mhuwi du. Kukongela nk'hongo kubula kwo uheelo, enga viya iwandikwe, “Mnt'hu azumilwe kunda ywedi hameso ha Mnungu neekale kwa mhuwi.” ");
INSERT INTO ngp_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kulawa kwe mbingu Mnungu kalaviliza maya yakwe kwa wose wasaguke na wakudamanya mbuli ziihile na kwa wiihi wawe watenda ikindedi kisekumanyika. ");
INSERT INTO ngp_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kwaviya, mbuli zose za Mnungu zikudaha kumanyika zigubulwa kwawe, Mnungu mwenye niye agubule. ");
INSERT INTO ngp_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kukongela kuumbwa kwe isi, udahi wakwe wa ulo na ulo no umnungu wakwe, hamwenga na kunda havikuoneka kwa meso, vamanyika pwilili. Want'hu wadaha kuwona na kumanya mbuli izo kwombokela vint'hu aumbile Mnungu, kwaivo haihali sila yoyose ya kukegombela. ");
INSERT INTO ngp_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Hata uneva wamanya kugamba eyuko Mnungu mna hawakumtunya enga Mnungu, naho hawakumtogola, vituhu vakwe fanyanyi zawe zinda hi kint'hu, ne mioyo yawe ina uhezi imemile lwiza. ");
INSERT INTO ngp_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Waketogola kunda wabala mna kumbe wahezi. ");
INSERT INTO ngp_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Waleka kumvika Mnungu akwikala ulo na ulo, mna wahitukila kuvika mahili yekale enga mnt'hu heekwikala ulo na ulo na mahili yekale enga madege na makala na viumbwa vikutambala. ");
INSERT INTO ngp_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kwaivo Mnungu kawaleka wakegele usavu woho wenye kwa kutimila kumunk'hwamunk'hwa kwiihile kwe mioyo yawe, no kutendelana mbuli za soni mwe mili yawe. ");
INSERT INTO ngp_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wauhitula ukindedi mwa Mnungu kunda udant'hi, wavika no kudamanyila ndima vint'hu viumbigwe no kumleka Muumbi mwenye, uyo awagilwe kutogolwa ulo na ulo! Taile. ");
INSERT INTO ngp_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kwaivo, Mnungu kawaleka watimile kumunk'hwamunk'hwa kwawe kwa soni, wavele nao waleka kuwamunk'hila wagosi, niyo wamunk'hilana woho kwa woho. ");
INSERT INTO ngp_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Wagosi nawo waleka kuwamunk'hila wavele niyo wakonga kumunk'hilana woho kwa woho, watendelana mbuli za soni, na ivo wakegaila masulumizo yadya yawawagile kwo wavu wawe wakudamanya. ");
INSERT INTO ngp_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwaviya want'hu walemela kummanya Mnungu mwe zifanyanyi zawe mna niyo Mnungu awaleka watimile fanyanyi zawe ziihile, wadamanye mbuli ziya wakulemezwa kudamanya. ");
INSERT INTO ngp_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Wamema wiihi wi hengi, na kudamanya yaihile na ugubaguba na ubanangi naho wamema finju na ukomi na nk'humbizi na want'hu wakudant'hiliza. Naho ni wateti, ");
INSERT INTO ngp_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","na wakuwalonga watuhu viihile na wakumwiihiya Mnungu naho wank'hani na hi waivi naho wakukeduvya na wefenyi naho wafanyanya sila zi hengi zo kutenda wiihi naho hewekuweva welesi wawe, ");
INSERT INTO ngp_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","wahezi naho heweina mhuwi na heweena mbazi naho hawana lukunde. ");
INSERT INTO ngp_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Wamanya kugamba miko ya Mnungu yagamba want'hu wakudamanya ayo wawagilwa kubanika. Mna hamwenga na ayo wagendeela kudamanya du, mna wawazumila wadya wakuyadamanya ayo. ");
INSERT INTO ngp_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Elo, mbuyangu, uneva wawalaha watuhu hukudaha kukegombela hata uneva unanda ni weye ani. Kwaviya kwa kuwalaha watuhu wakesengela weye mwenye kwaviya weye mwenye wadamanya ayadya ukuwalaha. ");
INSERT INTO ngp_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Kimanya kugamba usengelo wa Mnungu ni wa kindedi kwa wadya wakudamanya mbuli enga izo. ");
INSERT INTO ngp_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Mbuyangu, umwo ukawalaha watuhu wakudamanya mbuli enga izo, mna weye mwenye wayadamanya, togola wagamba noukehonye no usengelo wa Mnungu? ");
INSERT INTO ngp_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Hegu waubela uwedi wakwe utendese na kufinyiliza kwakwe no kugojela kwakwe. Togola humanyize kugamba uwedi wa Mnungu wakukulongoza ukweiile? ");
INSERT INTO ngp_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Mna kwo udala wo moyo wako una nk'hani, wakelundikila masulumizo makulu kwe dizuwa diya Mnungu akeza kulaviliza maya yakwe na ulahi we kindedi. ");
INSERT INTO ngp_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kwaviya Mnungu naamlihe kila mnt'hu mwa yadya adamanye. ");
INSERT INTO ngp_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Wadya wakugendeela kufinyiliza kudamanya ayedi haheina kusokela no kumzungula Mnungu, no ukulu na wogofi na wikazi hewiina uheelo, Mnungu naawenk'he ugima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Mna want'hu wakuzungula mbuli zawe wenye, wakulemela mbuli ze kindedi, vileke watimile yadya yaihile, Mnungu naakupule maya no usengelo mwawe. ");
INSERT INTO ngp_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kila mnt'hu akudamanya wiihi naakunt'he no kusulumila, wakakonga Wayahudi akajika ni wadya Want'hu wa si nt'huhu. ");
INSERT INTO ngp_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Mna Mnungu naawenk'he ukulu na wogofi na utondowazi wadya wakudamanya ayedi, kukongela Wayahudi, na want'hu we si nt'huhu. ");
INSERT INTO ngp_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kwaviya Mnungu hakukaula futa ya mnt'hu. ");
INSERT INTO ngp_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Want'hu hi Wayahudi wadya wakutenda wavu haheina miko Mnungu amwink'hile Musa, nawage haheina miko. Wayahudi wadya wakudamanya wavu wekekailwa ni miko, nawasengelwe ne miko. ");
INSERT INTO ngp_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kwaviya, hiyo wakuiva miko nao wakuoneka kunda wedi hameso ha Mnungu, mna ni wadya wakutimila imiko. ");
INSERT INTO ngp_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Want'hu hi Wayahudi heweina miko Mnungu amwink'hile Musa, mna wadamanya viya vikuungwa ne Miko iyo, wakalongozwa ni mioyo yawe, vanda niyo imiko yawe. ");
INSERT INTO ngp_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Lugendo lwawe lwalagisa kugamba vikuunga miko viwandikwa mwe mioyo yawe. Naho udahi wa kumanya kusagula ayedi hegu yaihile walagisa imbuli ino, kwaviya hamwenga aha fanyanyi zawe zawalongeleza, hamwenga aha zawagombela, ");
INSERT INTO ngp_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ivo viligane ne Mbuli Yedi ya Yesu Kilisito ino hubilikiza, nivo nevinde umwo Mnungu akasengela zimbuli ze kinyele za want'hu, kombokela Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Togola nawe? Wakegamba we mwenye Umyahudi, wakawiila miko na kukeduvila kugamba weye ni ywa Mnungu, ");
INSERT INTO ngp_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kwa kwombokela miko kuyamanya yadya yakuungwa ni Mnungu naho wadaha kusagula ayedi, ");
INSERT INTO ngp_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","weye wakeona kugamba ukilongozi ywa mant'hunt'hu, no ung'azi kwa wadya we mwo lwiza, ");
INSERT INTO ngp_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","wakeona kugamba umlangilizi ywa wahezi, naho mhinizi ywa wadya hewetogile. Kwaviya kulawa kwe miko wamanya mbuli zo umanyi na za kindedi. ");
INSERT INTO ngp_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Elo, weye wawahinizaga watuhu, nii hukukehiniza weye mwenye? Wawabilikiza watuhu wasekubawa, mna weye mwenye wabawa? ");
INSERT INTO ngp_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Weye ukugamba mnt'hu, “Asekudamanya uhabwasi” Mna weye mwenye wadamanya uhabwasi, weye ukuyaihiya mahili mna weye mwenye wabawa vint'hu mwe zinyumba ze mahili. ");
INSERT INTO ngp_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Wakeduvya kugamba kuitoza miko ya Mnungu, togola hukuona kugamba wambela Mnungu kwa kubananga miko? ");
INSERT INTO ngp_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Enga ivo viwandikwe mwa Mawandiko Yakukile, “Want'hu hi Wayahudi wadihomola dizina dya Mnungu kwajili yenyu Wayahudi.” ");
INSERT INTO ngp_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kuvinilwa kwako nokunde kint'hu chedi uneva unaitoza miko, mna hunaitozile no kuitimila, kuvinilwa kwenyu nokunde hi kint'hu. ");
INSERT INTO ngp_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Uneva mnt'hu heevinilwe anadamanya vikuungwa nu umwiko, ikindedi naafanyanywe enga mnt'hu avinilwe? ");
INSERT INTO ngp_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Want'hu hewevinilwe nawakusengele weye uvinilwe uneva hutimile miko, kwaviya watimila imiko. Unanayo imiko iwandikwe mna hukuitimila. ");
INSERT INTO ngp_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nuko kugamba hiyo kila akuoneka kwa kuse kunda Myahudi ni Myahudi we kindedi, naho mnt'hu hakunda Myahudi we kindedi kwaviya kavinilwa du. Kuvinilwa kwe kindedi hiyo kudya kwa kuse. ");
INSERT INTO ngp_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Myahudi we kindedi ni yudya Myahudi kwa kundani, yudya avinilwe ko moyo. Ndima ino yadamanywa ni Muye ywa Mnungu, naho hiyo kwe miko iwandikwe. Mnt'hu enga uyo ahokela nt'hunyo, hiyo kulawa kwa want'hu, mna ni kulawa kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Haluse Myahudi anakibwai kitendese kujink'ha want'hu watuhu? Hegu kuvinilwa kwambizai? ");
INSERT INTO ngp_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Viyuko vint'hu vingi. Bosi, Mnungu nakawenk'ha Wayahudi ulosi wakwe. ");
INSERT INTO ngp_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Mna nevinde vivihi uneva wamwenga mwa woho hawanandile wahuwilwa? Nuko kugamba kuswesa kuhuwila kwao nokuhungule uhuwilwa wa Mnungu? ");
INSERT INTO ngp_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Bule! Mnungu naasigale kunda mkindedi mazuwa yose na kila mnt'hu ni mdant'hi. Enga ivo viwandikwe, “Icho nounalonge ni kindedi, naho nounde mhumi umwo ukasengelwa.” ");
INSERT INTO ngp_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mna uneva wiihi wetu walagisa kindedi kugamba Mnungu adamanya ivo vikuungwa, nekigeeze? Togola nekigambe hakudamanya vikuungwa umwo akakilagisa maya yakwe? Mna aya nalonga kimnt'hu. ");
INSERT INTO ngp_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Bule! Uneva Mnungu hakudamanya yakwelela adaha vivihi kuwasengela want'hu we isi? ");
INSERT INTO ngp_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mna uneva, udant'hi wangu walagisa ukulu wa Mnungu, nii naho nasengelwa kunda mta wavu? ");
INSERT INTO ngp_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Valigana no kugamba, “Kidamanye wiihi vileke kihokele ayedi”? Kindedi weyuko wamwenga wakukilongeleza na kukiziga kugamba nivo kihinize! Want'hu awa nawasengelwe ivo vikuungwa. ");
INSERT INTO ngp_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Elo kigeeze? Suwe Wayahudi kiwedi kujink'ha wadya hi Wayahudi? Havikudahika! Kwaviya hilagisa kale kugamba, Wayahudi na want'hu hi Wayahudi wose chalongozwa nu wavu. ");
INSERT INTO ngp_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Mawandiko Yakukile yagamba, “Hahali mnt'hu akuoneka ywedi hameso ha Mnungu, ");
INSERT INTO ngp_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","hahali mnt'hu mta umanyi hegu mnt'hu akumzungula Mnungu.” ");
INSERT INTO ngp_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wose wamleka Mnungu, wose wadamanya wavu, hahali akudamanya ayedi, hahali hata yumwenga. ");
INSERT INTO ngp_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Milosi yawe yakoma, nyimi zawe zimema udant'hi, mwe milomo yawe mwalawa mbuli zikutisa enga usungu wa nyoka, ");
INSERT INTO ngp_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Simulizi zawe zimema maligito na luhahila lutendese. ");
INSERT INTO ngp_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Wagulukisa kukoma, ");
INSERT INTO ngp_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Hohose wakuita wegala ubanangi na masulumizo. ");
INSERT INTO ngp_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Hawaimanyize isila yo utondowazi. ");
INSERT INTO ngp_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Hawakumwogoha Mnungu mbwitu. ");
INSERT INTO ngp_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Haluse kimanya kugamba kila kiya kimwe miko ni kwa wadya du wakulongozwa nu umwiko vileke wase kukegombela, ne isi yose isengelwe ni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kwaviya hahali mnt'hu yoyose akuzumilwa kunda ywedi hameso ha Mnungu kwa kudamanya viya miko ikuunga. Indima ye miko ni kukitenda suwe kimanye kugamba kidamanya wavu. ");
INSERT INTO ngp_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Haluse, sila ya Mnungu yo kuwatenda want'hu wazumilwe kunda wedi kwakwe ilagiswa kale, naho hiyo kwa kukawiila miko. Mbuli zo mwiko na mbuli za walotezi zalonga uwona mwa ayo. ");
INSERT INTO ngp_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Mnungu awazumila want'hu kunda wedi hameso hakwe kombokela mhuwi wawe mwa Yesu Kilisito. Mnungu ayadamanya aya kwa wose wakuhuwila Kilisito kwaviya hauhali uzaguzi wowose, ");
INSERT INTO ngp_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kwaviya wose wadamanya wavu no kuhungukilwa no ukulu wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Mna kwo uwedi wa Mnungu howiina maliho, wose wazumilwa kunda wedi kombokela Yesu Kilisito akuwakombola. ");
INSERT INTO ngp_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Mnungu amlavaga Yesu vileke kwe sakame yakwe ande sila yo kuwausila want'hu wavu wawe kwombokela mhuwi mwa yehe. Mnungu adamanyaga ivo vileke alagise kugamba yehe ni ywedi mazuwa yose. Aho kale Mnungu afinyilizaga haheina kuufanyanya wavu wa want'hu, mna ivi haluse Mnungu aukaulisa uwavu wa want'hu, kwa ayo Mnungu alavanya uwedi wakwe. ");
INSERT INTO ngp_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Kwa kutenda ivo Mnungu alagisa kugamba yehe mwenye ni ywedi naho amtenda mnt'hu yeyose akumhuwila Yesu ande ywedi. Mwe sila ino mwenye Mnungu alagisa kugamba yehe mwenye ni ywedi. ");
INSERT INTO ngp_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Haluse nikihi cho kukeduvila? Hakikuli! Nii! Ni kwaviya chatimila miko ya Musa? Bule, mna ni kwaviya chahuwila. ");
INSERT INTO ngp_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kwaviya Mnungu amzumila mnt'hu kunda ywedi hameso hakwe kwa mhuwi, mna hiyo kwa kudamanya kiya kikusigiilwa mwe miko. ");
INSERT INTO ngp_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Hegu Mnungu ni ywa Wayahudi awo du? Yehe hiye Mnungu ywa want'hu hi Wayahudi iviyaiviya? Heiye, ni Mnungu ywa hata want'hu hi Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Mnungu ni yumwenga, naye naawazumile Wayahudi kunda wedi hameso hakwe kwo mhuwi wananawo na wadya hi Wayahudi nawo naawazumile kunda wedi hameso hakwe kwo umhuwi wawe. ");
INSERT INTO ngp_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Togola, nuko kugamba chaiduula hale imiko kwo mhuwi uno? Bule! hiyo ivo, vituhu vakwe chatozesa miko. ");
INSERT INTO ngp_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Elo kigeeze mwa Ibulahimu tati yetu mwo lukolo lwetu? ");
INSERT INTO ngp_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Uneva Ibulahimu kazumilwa kunda ywedi hameso ha Mnungu kwa kukombeka kwakwe mwenye hegu andaga na kint'hu cha kukeduvila mna hiyo hameso ha Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Mawandiko Yakukile yagamba, “Ibulahimu nakamhuwila Mnungu, na kwo mhuwi uwo Mnungu amuwazaga kunda ywedi.” ");
INSERT INTO ngp_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mnt'hu akudamanya ndima maliho yakwe hayakuwazigwa enga kudamanyilwa uwedi, mna ni kint'hu akuungwa kwink'hwa. ");
INSERT INTO ngp_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Mna mnt'hu hakukawiila udamanyi wakwe mwenye, mna amhuwila Mnungu uyo akuwalekela want'hu wiihi wawe, elo, Mnungu aukaula mhuwi wa mnt'hu uyo, na kumzumila kunda ywedi hameso hakwe. ");
INSERT INTO ngp_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ivi nivo alongaga Daudi umwo akalonga kinyemi cha mnt'hu azumilwe ni Mnungu kunda ywedi haheina udamanyi wowose. ");
INSERT INTO ngp_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Wanakinyemi wose walekelwe wavu wawe, awo wausilwe wavu wawe! ");
INSERT INTO ngp_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ana kinyemi mnt'hu yudya Zumbe haaukumbukile wavu wakwe!” ");
INSERT INTO ngp_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Togola, kinyemi icho kikulongwa ni Daudi ni wadya wavinilwe du hegu ni hamwenga na wadya hewevinilwe? Kwaviya chalongaga, “Ibulahimu ahuwilaga, niyo azumilwa ni Mnungu kunda ywedi.” ");
INSERT INTO ngp_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Togoleni, Ibulahimu azumilwagwa umwo andaga akei kuvinilwa na hiyo umwo andaga avinilwe kale? Yandaga umwo andile akei kuvinilwa, hiyo umwo eze ande kavinilwa. ");
INSERT INTO ngp_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Kuvinilwa kwa Ibulahimu kwandaga ni kiwalo cho kulagisa kugamba nakazumilwa kunda ywedi hameso ha Mnungu umwo andile akei kuvinilwa. Aya nayadamanyika vileke Ibulahimu ande tate ywa wose wakumhuwila Mnungu haheina kuvinilwa, awo wazumilwe kunda wedi hameso ha Mnungu, hata uneva hawavinilwe. ");
INSERT INTO ngp_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Iviyaiviya yehe ni tate ywa wose wavinilwe, mna hiyo kwa wadya wavinilwe du, mna kwa wadya wakutimila sila iidya yo mhuwi iyo tati yetu Ibulahimu aitimilaga umwo andaga akei kuvinilwa. ");
INSERT INTO ngp_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mnungu alaganaga na Ibulahimu ne cheleko chakwe kugamba isi yose neinde yawe. Ibulahimu hatendigwe ivo kwaviya andaga akatimila miko, bule mna ni kwaviya nakahuwila niyo azumilwa ni Mnungu kunda ywedi. ");
INSERT INTO ngp_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Uneva awo nawande wakipe kwa kutimila Miko, ivo mhuwi hauna dyodyose, na kulagana kwa Mnungu hiyo kint'hu. ");
INSERT INTO ngp_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Miko yegala maya ya Mnungu mna hahanandile ne miko, hahakunda na wavu. ");
INSERT INTO ngp_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Kwaivo mbuli ino yakawiila mhuwi naivo lagano idyo dyegalwa kwa uwedi wa Mnungu naho ni kindedi kugamba lagano idyo ni kwajili ya want'hu wose hiyo kwa wadya du wakuitoza imiko, iviyaiviya ni kwa wadya wakwikala kwa mhuwi enga Ibulahimu, kwaviya yehe ni tati yetu chose. ");
INSERT INTO ngp_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Enga viya Mawandiko Yakukile yakugamba, “Hikuika unde tate ywa want'hu wengi.” Lagano idyo ni kindedi hameso ha Mnungu uyo Ibulahimu amhuwile, uyo Mnungu akuwenk'ha wabanike ugima na kuvitenda vint'hu hevihali vinde viyaho. ");
INSERT INTO ngp_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ibulahimu nakahuwila na kukawiila hata uneva hakwandile ne dikawiilo, na ivo niyo anda “tate ywa si zose.” Enga viya iwandikwe kugamba, “Welekwa wako nawande wengi.” ");
INSERT INTO ngp_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Mna mhuwi wakwe hauhwele hamwenga na kugamba nakamanya umwili wakwe nounda enga ubanika, kwaviya andaga mdala hagihi na myaka gana, naho Sala mkaziwe andaga mgumba. ");
INSERT INTO ngp_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ibulahimu handile na kiyangayanga mwo kuhuwila indagano ya Mnungu mna nakapata ludole kulawa mwo mhuwi wakwe, niyo amwink'ha ukulu Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Naho nakahuwila kindedindedi kugamba Mnungu naakadaha kudamanya yadya alagane. ");
INSERT INTO ngp_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Nivo vilekile afanyanywe kugamba ni ywedi hameso ha Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ikagambigwa “kafanyanywa ni Mnungu kunda ywedi,” Haikulongwa kwajili yakwe du. ");
INSERT INTO ngp_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Mbuli ino iviyaiviya ni kwajili yetu suwe kikumhuwila Mnungu amuuyule Zumbe ywetu Yesu. ");
INSERT INTO ngp_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yehe nakalavigwa akomigwe kwajili ya wavu wetu, niyo auyuka, vileke akitende kizumilwe kunda wedi hameso ha Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Haluse kwaviya kizumilwa kunda wedi hameso ha Mnungu kwa sila yo mhuwi, kina utondowazi na Mnungu kwa sila ya Zumbe ywetu Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kwa sila yo mhuwi wetu, yehe kakigala mwo uwedi wa Mnungu umwo kili ivi haluse, elo chakeduvila kawiilo kinanadyo kwa kunda hamwenga mwo ukulu wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Naho hiyo ivo du, chakeduvila masulumizo kinanayo kwaviya kimanya masulumizo yegela kufinyiliza, ");
INSERT INTO ngp_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","kufinyiliza nako kwegala lugendo lwedi naho lugendo lwedi ulo lwegala kawiilo. ");
INSERT INTO ngp_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Naho kawiilo idi hadikudaha kukidant'hiliza, kwaviya Mnungu kakink'ha kale uwingi wo lukunde lwakwe mwe mioyo yetu kwa Muye ywakwe akukile uyo akink'hile. ");
INSERT INTO ngp_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Umwo chandaga kikei wasokezi, lupisi lusagulwe ni Mnungu lwize lubule, Kilisito abanikaga kwajili ya want'hu wavu. ");
INSERT INTO ngp_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ni vidala kwa mnt'hu kubanika kwajili ya mnt'hu ywedi, hata uneva mnt'hu adaha kubanika kwajili ya mnt'hu ywedi. ");
INSERT INTO ngp_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mna Mnungu kakilagisa ivo akiungise, ni aho chandaga kikei wata wavu, Kilisito abanikaga kwajili yetu! ");
INSERT INTO ngp_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kwaviya kizumilwa kunda wedi hameso ha Mnungu kwa sakame ya Kilisito, ni pwilili kugamba nekiyokolwe mwa maya ya Mnungu! ");
INSERT INTO ngp_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ikanda hadya chandile wank'hondo wa Mnungu, Mnungu kakilunganya kwa sila ya file ya mwanawe. Haluse vitendesa kikanda kilunganywa naye naakiyokole kwa ugima wa Kilisito! ");
INSERT INTO ngp_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Mna hiyo ayo du, kina kinyemi mwa yadya yadamanywe ni Mnungu kwa sila ya Zumbe ywetu Yesu Kilisito, uyo akitendile kiivane na Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ivo elo, enga viya kwa mnt'hu yumwenga, wavu nowingila mwe isi, niyo wegala file, ivo file yenela mwa want'hu wose kwaviya wose wadamanya wavu. ");
INSERT INTO ngp_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Umwo kwandaga mwiko hunati wize, wavu wandaga mwe isi, mna wavu haukuwazwa haheina mwiko. ");
INSERT INTO ngp_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Mna kukongela mwa Adamu kubula mwa Musa, ukubanika kuwekaila want'hu wose hata kwa wadya hewedamanye wavu enga uudya adamanye Adamu umwo akamlemela Mnungu. Adamu andaga ni mliganyizo wa uyo andaga akeza. ");
INSERT INTO ngp_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Mna digeleko diya hadyandaga ni enga masa ya Adamu, kwaviya kwa masa ya mnt'hu yumwenga wabanika want'hu wengi, uwedi wa Mnungu utendesa ne digeleko dimwe uwedi wo mnt'hu uyu Yesu Kilisito kwajili ya want'hu wengi. ");
INSERT INTO ngp_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Naho havikuligana mwe digeleko dya Mnungu, no wavu wo mnt'hu yumwenga. Kwaviya mnt'hu yumwenga eze atende wavu, Mnungu nakenk'hiza usengelo, mna want'hu wengi weze watende wavu Mnungu nakawenk'ha geleko dyakwe kwa kuwausila wavu wawe. ");
INSERT INTO ngp_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ni kindedi kugamba kwo wavu wa mnt'hu yumwenga file yawekaila want'hu wose kwajili yo mnt'hu uyo yumwenga. Mna ikikulu kitendese ni kiya kilawane na kiya adamanye mnt'hu yumwenga Yesu Kilisito. Wose wahokela wedi wa Mnungu ne digeleko idyo dyo kuwatenda wazumilwe kunda wedi hameso ha Mnungu. Nawekale na kulongoza kwa sila ya mnt'hu uyo yumwenga, Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Elo! Enga viya wavu wa mnt'hu yumwenga wigale usengelo kwa want'hu wose, iivo kwa ndima yedi ya mnt'hu yumwenga iwegaila want'hu wose kuzumilwa kunda wedi hameso ha Mnungu na kuwenk'ha ugima. ");
INSERT INTO ngp_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Naho kwa mnt'hu yumwenga asaguke, want'hu wengi watendigwa kunda wata wavu, ni iivo kwa mnt'hu yumwenga evile want'hu wengi watendigwe kunda wedi hameso ha Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Miko neiza, niyo wavu wongezekela mna hadya wavu wize wongezekele uwedi wa Mnungu nowongezekelesa. ");
INSERT INTO ngp_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Naivo elo, enga viya wavu wikaile na kwigala file, iivo uwedi wa Mnungu nowikaile mwe sila ikuungwa no kwigala ugima wa ulo na ulo kwa sila ya Yesu Kilisito Zumbe ywetu. ");
INSERT INTO ngp_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Elo, nekigeeze? Kigendeele kwikala mwo wavu vileke wedi wa Mnungu wongezekele? ");
INSERT INTO ngp_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Bule! Suwe kibanike mwe zimbuli zo wavu nekigendele vivihi kudamanya wavu? ");
INSERT INTO ngp_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Hegu hammanyize suwe chose kibatizwe mwa Kilisito Yesu, nekibatizwa mwe file yakwe? ");
INSERT INTO ngp_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Kize kibatizwe nekimoswamsanga hamwenga naye mwe file yakwe, vileke, enga viya Kilisito auyulwe kwa ukulu wa Tate, suwe naswe kidahe kwikala mwo ugima mhya. ");
INSERT INTO ngp_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Uneva suwe kilungana naye mwo kubanika enga yehe, iviyaiviya nekilungane naye kwa kuuyulwa enga yehe. ");
INSERT INTO ngp_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Kimanya kugamba unt'hu wetu wa kale uwambigwa hamwenga na Yesu mwo msalaba, vileke udahi wo wavu ubanangwe, kisekunda watumwa wo wavu naho. ");
INSERT INTO ngp_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kwaviya mnt'hu abanike, kakombolwa mwo udahi wo wavu. ");
INSERT INTO ngp_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Elo uneva kibanika hamwenga na Kilisito, chahuwila kugamba nekikale hamwenga naye. ");
INSERT INTO ngp_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kwaviya kimanya kugamba Kilisito kauyulwa kale, naho haabanike kaidi. File heimdahe naho. ");
INSERT INTO ngp_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Kubanika kwakwe kwajili ya wavu kabanika kamwenga du, mna ugima wakwe wekala kwa kumwelela Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Naivo nanywe keoneni enga want'hu wabanike kwe mbuli yo wavu, mna mwi wagima hamwenga na Mnungu kwa kulungana na Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Wavu usekulongoza mili yenyu iyo ikubanika, naivo kutimila kumunk'hwamunk'hwa kwakwe kwiihile. ");
INSERT INTO ngp_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Naho msekwink'hiza kilungo chochose mwe mili yenyu kinde kint'hu cha kudamanyila wiihi no wavu. Vituhuvakwe kelaveni wenye kwa Mnungu, enga want'hu wauyulwe naho wagima, naho laveni vilungo venyu vose kwa Mnungu kwajili ya kudamanya mbuli zikuzumilwa ni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Hamkuungwa kulongozwa nu wavu, kwaviya hamkulongozwa nu mwiko mna kwo uwedi wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Haluse, kigeeze? Kidamanye wavu, kwaviya hakikulongozwa nu mwiko mna kimwo wedi wa Mnungu? Bule! ");
INSERT INTO ngp_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ikindedi mmanya kugamba uneva wi mtumwa kwa mnt'hu, umwekindedi kugamba umtumwa kwa uyo ukumtegeleza, uneva nu wavu, ukukwigala kwe file, hegu kumtegeleza Mnungu, vileke kizumilwe kunda wedi hameso ha Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Mna mtogoleni Mnungu, kwaviya hamwenga no kugamba nomnda watumwa wa wavu aho kale, haluse mwiva kwe mioyo yenyu yose, ikindedi kiya mhokele mwa mahinizo. ");
INSERT INTO ngp_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Naho mwize mnde mkombolwa kale mwo utumwa wa wavu, mnda watumwa wa kuzumilwa kunda wedi. ");
INSERT INTO ngp_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nalonga milosi ya mazuwa yose ya want'hu kwajili yo kuhwa kwenyu. Enga viya lupisi lumwenga, mwakelavaga nyuwe wenye kunda watumwa mwo usavu na ubanangi kwajili yo wavu. Enga iivo kelaveni nyuwe wenye kunda watumwa kwa mbuli zikumwelela Mnungu vileke mkuke. ");
INSERT INTO ngp_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Umwo mwandile watumwa wo wavu mwandaga mwi hale na kudamanya yadya yakumwelela Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Elo nompatai kulawa mwe zimbuli ziya mdamanye, izo haluse mkuzionela soni? Mbuli izi zegala file! ");
INSERT INTO ngp_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Mna haluse mkombolwa kale mwo wavu naho mnda watumwa wa Mnungu. Kiya mpatile ivi haluse nu kukuka kukwigala ugima wa ulo na ulo. ");
INSERT INTO ngp_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwaviya maliho yo wavu ni file, mna geleko dya Mnungu ni ugima wa ulo na ulo mwo kulungana na Yesu Kilisito Zumbe ywetu. ");
INSERT INTO ngp_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Wandugu zangu, kwavovose nomyakombaganye yadya huunga nilonge, kwaviya nyose muimanya imiko. Miko yamwikaila mnt'hu akanda mgima. ");
INSERT INTO ngp_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Mvele alombigwe, atozelezwa nu mwiko kwa mgosiwe mwo ugima wakwe wose, mna mgosiwe anabanika, anda kalekelwa mwe miko ikumtozeleza kwa mgosiwe. ");
INSERT INTO ngp_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Naivo, uneva ekala na mgosi mtuhu umwo mgosiwe akei mgima, aho neetangwe mhabwasi, mna uneva mgosiwe anabanika, mvele uyo heekailwe ni miko naho heetangwe mhabwasi analombigwa ni mgosi mtuhu. ");
INSERT INTO ngp_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Naivi nivo vili kwenyu, wandugu zangu. Nyuwe wenye mfa mwe mbuli ye miko, kwaviya nyuwe mlungana na Kilisito, naho mnda wakwe yehe auyulwe, vileke kidamanye mbuli zikuungwa mwe ndima ya Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kwaviya umwo chandile kikalongozwa ni mili yetu, kumunk'hwamunk'hwa kwiihile kwa wavu kukasongelezwa ni miko, nokudamanya ndima mwe mili yetu na yose kidamanye yaheela mwe file. ");
INSERT INTO ngp_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Mna haluse kilekelwa mwe divugailo dye miko, kwaviya kibanika mwe kiya kitendile suwe kunda wavugailwa. Haluse chatimila wikazi mhya wa Muye ywa Mnungu, hiyo udya wikazi wa kale we miko iwandikwe. ");
INSERT INTO ngp_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Togola kigeeze, miko nuwo wavu? Bule! Hiyo ivo! Kwaviya miko niyo ilekile miye hamanya uwavu ni kint'hu chani, kwaviya hegu hyakumanyize kumunk'hwamunk'hwa kwihile ni kint'hu chani uneva miko hayalongile usekumunk'hilwa. ");
INSERT INTO ngp_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Mna kwo mwiko uwo, wavu noupata luneka lwa kwimula kumunk'hwamunk'hwa kwihile mwangu, kwaviya haheina mwiko, wavu ni kint'hu kibanike. ");
INSERT INTO ngp_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Aho nk'hongo miye nandaga mgima hale ne miko, mna sigilizi izeize wavu niyo wakonga kudamanya ndima niyo nanda enga hibanika. ");
INSERT INTO ngp_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Niyo naona kugamba, isigilizi idya yaungigwe igale ugima, kwangu igala file. ");
INSERT INTO ngp_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kwaviya wavu upata luneka wink'higwe ni sigilizi, inidant'hiliza niyo yanikoma. ");
INSERT INTO ngp_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Naho haluse, miko iyenye ikuka, naho sigilizi ikuka, naho ni ya uwagilwa naho ni yedi. ");
INSERT INTO ngp_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Togola! Nuko kugamba kint'hu chedi kanigaila file? Bule! Nu wavu utendile ivo, mna vileke wavu umanyike kugamba ni wavu kindedi. Nowombokela kwa kiya ichedi na kunigaila file, ivo, kwa sila ye sigilizi idya wavu noutendesa kukelaviliza kunda ni kint'hu kiihise. ");
INSERT INTO ngp_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Kimanya kugamba miko ni ya kimuye, mna miye hiyo ywa kimuye, hitagwa kunda mtumwa wo wavu. ");
INSERT INTO ngp_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Hikumanya kiya hudamanya, kwaviya hikudamanya kiya huunga nidamanye, vituhuvakwe nadamanya yadya hikuyaunga. ");
INSERT INTO ngp_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Kwaviya kiya hudamanya ni kiya hikukiunga ino yalagisa kugamba nazumila uwedi we Miko. ");
INSERT INTO ngp_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Elo hiyo miye hudamanya kint'hu iki, mna ni udya wavu ukwikala mndani mwangu. ");
INSERT INTO ngp_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Himanya kugamba haihali mbuli yedi ikwikala mwangu ko unt'hu wangu uno. Hata uneva haungisa kudamanya ayedi hikudaha kuyadamanya. ");
INSERT INTO ngp_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kwaviya hikudamanya yedi huunga kudamanya, vituhuvakwe nadamanya maihi yadya hiikuyaunga kudamanya. ");
INSERT INTO ngp_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Uneva nadamanya diya hikudiunga kudamanya, ivi nuko kugamba, hiye miye hudamanya mna ni udya wavu ukwikala mwangu. ");
INSERT INTO ngp_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ivo nabunk'hula miko ino, kugamba kiyuko kikunikindila, umwo haunga nidamanye mbuli iyedi, aaho nadamanya mbuli ihile. ");
INSERT INTO ngp_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nauonela kinyemi umwiko wa Mnungu mndani mwo moyo. ");
INSERT INTO ngp_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Mna naona kugamba kuna kint'hu kituhu kikudamanya ndima mwo mwili wangu, u kint'hu kikuhigana na kiya kizumilwe nu ubala wangu, yanitenda kunda mtumwa kwo mwiko wo wavu ukudamanya ndima mwo mwili wangu. ");
INSERT INTO ngp_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Miye mkiwa, niani akuunga anikombole no mwili uno ukunigala kwe file? ");
INSERT INTO ngp_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Atogolwe Mnungu uyo akudamanya aya kwa sila ya Zumbe ywetu Yesu Kilisito. Naivi elo nivo nili, miye mwenye ko ubala wangu naidamanyila ndima miko ya Mnungu, mna kwo mwili wangu nadamanyila ndima miko yo wavu. ");
INSERT INTO ngp_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Elo, hauhali usengelo wa masulumizo kwa wadya walungane na Yesu Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kwaviya mwiko wo Muye uyo akukik'ha ugima kwa kulungana na Kilisito Yesu, inink'ha ulekelwa kulawa mwo mwiko wo wavu ne file. ");
INSERT INTO ngp_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mbuli idya idundugwe nu Mwiko wa Musa enk'higwe ni Mnungu, kwo usokezi wo mwili, Mnungu kaidamanya kwa kumtuma Mwanawe mta mwili, enga mwili wo wavu, vileke ausengele wavu mwo mwili. ");
INSERT INTO ngp_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Mnungu kayadamanya aya vileke kiya kiungigwe nu mwiko kikint'hizwe mndani mwetu kikwikala kwa kulongozwa na Muye ywa Mnungu, na hiyo kwa mwili wo wavu. ");
INSERT INTO ngp_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Wadya wose wakwikala enga viya mili yawe ikuunga, wekailwa ni fanyanyi zo mwili. Mna wadya wakwikala enga ivo Muye ywa Mnungu akuunga wekailwa ni fanyanyi za Muye. ");
INSERT INTO ngp_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kwaviya fanyanyi zikwikailwa nu mwili zegala file, mna fanyanyi zikwikailwa ni Muye ywa Mnungu zegala ugima no utondowazi. ");
INSERT INTO ngp_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kwaivo fanyanyi zikulongozwa nu mwili zanda mnk'hondo kwa Mnungu, kwaviya mwili haukuzumila miko ya Mnungu naho kindedi hazikudaha kuitimila. ");
INSERT INTO ngp_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Wadya wakulongozwa nu mwili hawakudaha kumwelela Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Mna nyuwe Muye ywa Mnungu akwikala mndani mwenyu, hamkulongozwa nu mwili, vituhu vakwe mwalongozwa nu Muye ywa Mnungu, uneva mnt'hu yeyose heena Muye ywa Kilisito uyo hiyo mnt'hu ywa Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Mna uneva Kilisito ekala mndani mwenyu, Muye awek'hani ugima kwaviya mtendigwa mzumilwe kunda wedi hameso ha Mnungu, hamwenga na kugamba miili yenyu ibanika kwajili yo wavu. ");
INSERT INTO ngp_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Uneva Muye ywa Mnungu yudya amuuyule Yesu ekala mwenyu, ivo uuyo Muye amuuyule Kilisito, naye naaink'he ugima mili yenyu yo kubanika, nadamanye ivo kwa Muye ywakwe akwikala mndani mwenyu. ");
INSERT INTO ngp_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Naivo wandugu zangu kina ndima, mna hiyo kwa kwikala enga imili ivo ikuunga, ");
INSERT INTO ngp_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","kwaviya mnekala mkatimila imili ikindedi nombanike, mna mnekala kwa kulongozwa ni Muye mwaukoma udamanyi wenyu wo wavu, ivo nomnde wagima. ");
INSERT INTO ngp_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kwaviya wose wakulongozwa ni Muye ywa Mnungu, nawo wana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kwaviya hamhokele Muye wo kuwatenda watumwa wo kwogoha naho, mna mhokela Muye ywa kuwatendani mnde wana Mnungu naho kwo Muye uyo, suwe chamwitanga, “Aba” nuko kugamba, “Tate!” ");
INSERT INTO ngp_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Naho uuyo Muye mwenye alonga uwona hamwenga ne mioyo yetu kugamba suwe kiwana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Elo, kwaviya suwe kiwana Mnungu nekihokele ukipe uwo awaikile want'hu wakwe naho nekihokele ukipe uwo hamwenga na Kilisito, kwaviya uneva kinanda ndala mwe masulumizo yakwe nekinde ndala iviyaiviya mwo ukulu wakwe. ");
INSERT INTO ngp_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Naona kugamba masulumizo ya ivi haluse hiyo kint'hu ikaliganyizwa no ukulu udya nougubulwe kwetu. ");
INSERT INTO ngp_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kwaviya viumbwa vose vagojela kwa kunyemwanyemwa kugubulwa kwa wana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kwaviya, viumbwa nevitendigwa vioneke hiyo kint'hu naho hiyo kwa kuunga venye, mna inda ivo kwa kuunga kwakwe Mnungu uku akanda na kawiilo, ");
INSERT INTO ngp_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kugamba viumbwa navo nevikombolwe kulawa mwo utumwa wo kuola, na kwiikwa ulekelwa mwo ukulu wa wana Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kwaviya kimanya kugamba mpaka ivi haluse viumbwa vose vaugula kwa usungu. ");
INSERT INTO ngp_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Naho hiyo awo viumbwa du, mna hata suwe kinanaye uyo Muye eli ywa nk'hongo ywe digeleko dya Mnungu, naswe chaugula mndani mwetu kikagojela kitendigwe wana Mnungu, nuko kugamba kukombolwa kwe mili yetu. ");
INSERT INTO ngp_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kwaivo kwa makawiilo ayo suwe kiyokolwa. Mna kawiilo hi kint'hu uneva chakiona kiya kikukawiila. Elo niani akukawiila kiya akukiona kale? ");
INSERT INTO ngp_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Uneva chakikawiila kiya hekiinati kukiona, ivo chakigoja kwa kufinyiliza. ");
INSERT INTO ngp_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Iviyaiviya Muye ywa Mnungu naye achambiza mwo usokezi wetu. Kwaviya hakimanyize kulombeza enga ivo vikuungwa, mna Muye mwenye akilombezela suwe kwa Mnungu kwa mbuli heikudahika kutambulwa. ");
INSERT INTO ngp_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Naye Mnungu akukaula kundani kwe mioyo, kamanya zifanyanyi za uyo Muye kwaviya uyo Muye awalombezela want'hu wa Mnungu viligane naivo Mnungu akuunga. ");
INSERT INTO ngp_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Kimanya kugamba, mwe zimbuli zose Mnungu adamanya ndima hamwenga na wadya wakumuunga, ni wadya awetange enga ivo yehe aungile. ");
INSERT INTO ngp_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kwaviya awo wasagulwe kukongela aho kale nawo awasagule wande enga Mwanawe vileke uyo umwana ande mwelekwa ywa nk'hongo mwa wandugu awengi. ");
INSERT INTO ngp_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Elo wadya wasagulwe ni Mnungu nawo awetange iviyaiviya, naho awo awetange wazumilwa kunda wedi hameso hakwe, nawo awazumile kunda wedi hameso hakwe kawatenda kunda ndala mwo ukulu wakwe. ");
INSERT INTO ngp_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Kigeeze elo kwa ayo? Uneva Mnungu ekwetu niani akudaha kukihiga? ");
INSERT INTO ngp_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Mnungu hamtozeleze Mwanawe amuungise, mna nakamlava kwajili yetu chose, uneva kadamanya ivo, togoleni mwafanyanya haadahe kukink'ha yose yedi hamwenga na yehe? ");
INSERT INTO ngp_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Niani akuunga awalongeleze wasagulwe ni Mnungu? Hahali, Mnungu mwenye kawawaza hawana masa! ");
INSERT INTO ngp_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Niani akuunga awasengele? Hahali, kwaviya Kilisito Yesu niye abanike, naho niyo auyuka, naho niyo akwikala kulume kwa Mnungu, yehe niye akukilombezela. ");
INSERT INTO ngp_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Niani akudaha kukipanga mwo lukunde lwa Kilisito? Togoleni, ni makunt'ho, hegu ni kinyulu hegu ni masulumizo, hegu ni sala, hegu ni sakaza, hegu nk'hondo, hegu file? ");
INSERT INTO ngp_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Enga ivo Mawandiko Yakukile yakugamba, “Kwaajili ya weye, kimwo kubanika kilo na msi chatendelwa enga ngoto ikugenda kuchinjwa.” ");
INSERT INTO ngp_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Mna mwe zimbuli izi zose suwe kipata uhumi mkulu kwa wambizi wakwe yehe akiungise. ");
INSERT INTO ngp_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kwaviya himanya ikindedi kugamba, hiyo file naho hiyo ugima naho hiyo watumigwa wa kwe mbingu, hegu udahi mtuhu wa kulanga naho hiyo mbuli za ivi haluse hegu mbuli zikwiza, hegu ludole, ");
INSERT INTO ngp_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","hiyo kulanga hegu hasi, hakihali kiumbwa chochose, kikudaha kukipanga no lukunde lwa Mnungu mwa Kilisito Yesu Zumbe ywetu. ");
INSERT INTO ngp_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Miye hilungana na Kilisito hikudaha kulonga udant'hi, nalonga ikindedi, moyo wangu na Muye ywa Mnungu walavanya uwona kugamba, ");
INSERT INTO ngp_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","nna kinyulu na usungu houkusila mwo moyo wangu. ");
INSERT INTO ngp_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Kwaajili ya wandugu zangu want'hu we kabila dyangu, uneva yandile kwajili ya kuwaambiza hegu nehizumila kuligitwa na kupagulwa kulawa mwa Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Awo ni Waizilaeli, awo Mnungu awasagule wande wanawe, niyo awatenda ndala mwo ukulu na kadamanya nawo ndagano no kuwenk'ha miko yakwe, nakawalagisa ivo vo kuvika na kulagana nawo. ");
INSERT INTO ngp_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Woho ni wezukulu wa wakale, naye Kilisito ezaga kulawa mwo lukolo ulo. Mnungu akulongoza vint'hu vose, atogolwe ulo na ulo. Taile. ");
INSERT INTO ngp_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Hikulonga kugamba kiya alongile Mnungu kidunduga, kwaviya hiyo want'hu wose wa Izilaeli ni want'hu wa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Hicho cheleko chose cha Ibulahimu, kugamba wanda ni wana Mnungu, mna Mnungu amgambaga Ibulahimu kugamba “Cheleko kulawa kwa Isaka noupate welekwa nawetangwe wakwako.” ");
INSERT INTO ngp_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nuko kugamba hiyo wana wakwelekwa kimnt'hu, nawo wakumanyika wana Mnungu, mna ni wadya welekigwe kulaila mwe kulagana kwa Mnungu nawo wakwitangwa wana wakwe. ");
INSERT INTO ngp_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kwaviya yadya alagane Mnungu ni aya, “Mwaka ukwiza lupisi enga ulu neniuye, naho Sala naande na mwana kilume.” ");
INSERT INTO ngp_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Naho hiyo ivo, Labeka naye apataga wana mapasa kwa tati yawe, uyo mkale ywetu Isaka. ");
INSERT INTO ngp_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Mnungu akint'hizaga usaguzi wakwe uwo houkuegamila udamanyi, mna wegamila lwitango, alagisaga ayo umwo wandaga hawanati kwelekwa na kumanya kusagula ayedi na yaihile. ");
INSERT INTO ngp_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Mnungu amgambaga Labeka kugamba yudya mkulu naamdamanyile ndima mvunawe. ");
INSERT INTO ngp_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Enga viya Mawandiko yakugamba, “Himuungisa Yakobo no kumwihia Esau.” ");
INSERT INTO ngp_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Togola, nekigambe Mnungu azagula? Bule! ");
INSERT INTO ngp_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kwaviya nakamgamba Musa, “Nenimuwonele mbazi mnt'hu yudya huunga kumuwonela mbazi, nenimuungise mnt'hu yudya nenimuungise” ");
INSERT INTO ngp_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Kwa ivo elo kila kint'hu chegamila mbazi za Mnungu hiyo kwaviya want'hu wakuunga kudamanya. ");
INSERT INTO ngp_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kwaviya Mawandiko Yakukile yamgamba Falao ywa Misili, “Hikutenda seuta vileke udahi wangu umanyike, naivo zina dyangu dibwelekezwe si yose.” ");
INSERT INTO ngp_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Kwa ivo elo, Mnungu amuwonela mbazi mnt'hu akuunga, naho uneva anaunga adaha kumtenda mnt'hu ande na moyo mdala. ");
INSERT INTO ngp_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Yumwenga adaha kuuza, “Uneva mbuli nivo zili, nimbwai Mnungu akei kukalaliza? Niani akudaha kukindila viya Mnungu akuunga?” ");
INSERT INTO ngp_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Mna weye niwe ani? Ni mnt'hu du. Wadaha kumhitula Mnungu? Ivi nyungu yadaha kumuuza muumbi wakwe, “Nii ukaniumba ivi?” ");
INSERT INTO ngp_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Muumbi wa nyungu adaha kuudamanyila ulongo viya akuunga. Kwa longo dimwenga, adaha kuumba nyungu imwenga kwa udamanyi wa nt'hogola, niyo longo dimwenga kwa udamanyi howiina nt'hogola. ");
INSERT INTO ngp_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Uneva Mnungu nakaunga alagise maya yakwe na udahi wakwe, adaha kufinyiliza kwa viya naakaunga avibanange. ");
INSERT INTO ngp_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Uneva nakaunga alagise ukulu wakwe mkulu kwa wadya aungile kuhokela mbazi zakwe, adaha kudamanya ivo. ");
INSERT INTO ngp_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Kadamanya ayo kwetu suwe akitange, hiyo kulawa kwa Wayahudi du, mna hamwenga na want'hu wakulawa kwe si nt'huhu. ");
INSERT INTO ngp_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Enga ivo Zumbe akulonga mwe kitabu cha mlotezi Hosea “Wadya want'hu wandaga hiyo wangu Neni wetange ‘want'hu wangu.’ Idya isi nandile hikuiyunga, Neniitange ‘Isihuiungisa.’ ");
INSERT INTO ngp_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na hadya wagambigwe, ‘Nyuwe hiyo want'hu wangu,’ aho nawetangwe wana Mnungu mta ugima.” ");
INSERT INTO ngp_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Na Isaya mlotezi ywa Mnungu, naye awaiilaga Waizilaeli na kulonga, “Hata uneva welekwa wa Izilaeli ni wengi enga msanga wa mp'wani, mna ni wageke du nawayokolwe. ");
INSERT INTO ngp_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Kwa ivo Zumbe naasunguze kudamanya usengelo wakwe ukint'hile mwe isi zose.” ");
INSERT INTO ngp_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Enga viya Isaya alongile aho nk'hongo “Uneva Zumbe mta udahi wose andile hakisigazile wamwenga mwa wana Izilaeli hegu nekinda enga Sodoma, nekinda enga Gomola.” ");
INSERT INTO ngp_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Elo kigeeze? Want'hu hi wayahudi hawazungule kunda wedi, wazumilwa kunda wedi hameso ha Mnungu kwa kuhuwila kwawe, ");
INSERT INTO ngp_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Mna Waizilaeli, wazungulaga kunda wedi kwa miko, mna waiswesa. ");
INSERT INTO ngp_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Nii wakaiswesa? Kwaviya nawakakawiila udamanyi wawe hant'hu ha kukawiila mhuwi. Wakobadika mwe diiwe dyo kukobadisa, ");
INSERT INTO ngp_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","enga viya Mawandiko Yakukile ivo yakulonga, “Kaula naika iwe mwe Sayuni nadyo nediwatende want'hu wakobadike, luwe lukuunga luwakinye. Na yeyose akuhuwila haageligwe soni.” ");
INSERT INTO ngp_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Wandugu zangu, naungisa kwo moyo wangu wose kugamba, Wayahudi wambuya zangu wayokolwe! Naho nawalombezela kwa Mnungu mazuwa yose. ");
INSERT INTO ngp_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Kwaviya miye ni muwona kugamba, wakombekesa kumzungula Mnungu mna kukombekesa uko hakuzengigwe mwo umanyi we kindedi. ");
INSERT INTO ngp_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Hawanati waimanye isila iyo Mnungu akuidamanya vileke awazumile want'hu kunda wedi, vituhu vakwe wakedamanyila sila zawe wenye, naivo hawaizumile sila iyo ya Mnungu yo kuwatenda want'hu wazumilwe kunda wedi hameso hakwe. ");
INSERT INTO ngp_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kwaviya Kilisito nuyo uheelo we miko, vileke yeyose akumhuwila azumilwe kunda ywedi hameso ha Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musa awandikaga ivi mwe mbuli yo uwedi hameso ha Mnungu kwa kutimila miko, “Mnt'hu yeyose akwiva viya vikuunga miko neekale.” ");
INSERT INTO ngp_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Mna mwe mbuli yo kuzumilwa kunda ywedi hameso ha Mnungu kwa sila yo mhuwi mawandiko yagamba ivi “Use kukeuza mwo moyo wako kugamba, niani naaite kulanga?” Uko ni kumseleza Kilisito hasi. ");
INSERT INTO ngp_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Naho usekugamba niani akuunga aite hasi ye isi ya want'hu wabanike?” Uko ni kumuuyula Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Mna Mawandiko Yakukile yagamba ivi, “Ulosi wa Mnungu wihagihi na weye, umwo mnomo wako na mo moyo.” Nuwo ulosi wo mhuwi kikubilikiza. ");
INSERT INTO ngp_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Unalonga kwa mnomo wako kugamba Yesu ni Zumbe, no kuhuwila mwo moyo wako kugamba Mnungu amuuyulaga, nouyokolwe. ");
INSERT INTO ngp_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kwaviya mnt'hu anahuwila mwo moyo azumilwa kunda ywedi hameso ha Mnungu, na kwa mnomo mnt'hu alonga na kuyokolwa. ");
INSERT INTO ngp_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Mawandiko Yakukile yagamba, “Mnt'hu yeyose akumhuwila yehe, haaone soni” ");
INSERT INTO ngp_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Hakuhali kwazagula mwa Wayahudi na want'hu hi Wayahudi, wose ni kint'hu kimwenga, kwaviya Zumbe ywa wose ni yumwenga, naye ni mta ukise kwa wose wakumwitanga. ");
INSERT INTO ngp_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Enga ivo Mawandiko Yakukile yakugamba, “Kila mnt'hu naetange kwa zina dya Zumbe, naayokolwe.” ");
INSERT INTO ngp_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Mna nawetange vivihi zina dya Zumbe hewe kumhuwila? Naho nawamhuwile vivihi uyo hewenati kumwiva? Naho naweve vivihi uneva hahali mnt'hu awabilikize? ");
INSERT INTO ngp_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Naho want'hu nawabilikize vivihi uneva hawanegalwe? Enga Mawandiko Yakukile yakulonga, “Ni kinyemi kikulu kwiza kwa wadya wakubilikiza Mbuli Yedi!” ");
INSERT INTO ngp_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Mna hiyo wose waizumile Mbuli Yedi, Isaya mlotezi ywa Mnungu agambaga, “Zumbe niani auhuwile ulosi wetu?” ");
INSERT INTO ngp_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Naivo elo mhuwi weza kwa kuwiva ulosi, no ulosi walawa mwe mbuli kwa kumbilikiza Kilisito. ");
INSERT INTO ngp_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Mna nauza, togoleni ni kindedi hawawivile ulosi? Ikindedi weva kwaviya Mawandiko Yakukile yagamba, “Izwi dyawe digenda isi yose, milosi yawe ibilikizwa kubula kwo uheelo we isi yose.” ");
INSERT INTO ngp_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Nauza naho, want'hu wa Izilaeli hawa kombaganye? Nk'hongo Musa alongaga, “Neniwatende muwaonele finju, Want'hu hewena isi. Neniwatende unde na maya kwa isi ya wahezi.” ");
INSERT INTO ngp_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Isaya alongaga haheina kogoha kugamba, “Wadya hewenizungule wanipata, hikelaviliza kwa want'hu hewenitange.” ");
INSERT INTO ngp_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Mna kwe mbuli ya Izilaeli agamba, “Msi mgima hiwachuluila mikono kuwetanga want'hu wasaguke na wadya hewekuniva.” ");
INSERT INTO ngp_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Elo nauza, Mnungu kawalemela want'hu wakwe Wayahudi? Bule! Miye mwenye ni Mwizilaeli mwelekwa ywa Ibulahimu, mwe dikabila dya Benjamini. ");
INSERT INTO ngp_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Mnungu hawalemele want'hu wakwe, awasagulaga kukongela aho nk'hongo. Mmanya kiya kikulongwa ni Mawandiko Yakukile mwa Eliya umwo andaga akawakalaliza waizilaeli kwa Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Kaula Zumbe, wawakoma walotezi wako, no kumola vilingo va kukuvika. Hisigala miye nikedu, naho waunga wanikome” ");
INSERT INTO ngp_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Mna Mnungu amhitulagai? “Agambaga hikeika wagosi watuhu magana milongo mfungate heweevikile milungu ikwitangwa Baali.” ");
INSERT INTO ngp_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Naho hata ivi haluse, weyuko want'hu wageke wasigale wasagulwe ni Mnungu kwa uwedi wakwe. ");
INSERT INTO ngp_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Usaguzi wakwe ni kwa wedi wakwe, hiyo kwa yadya want'hu wadamanye, kwaviya usaguzi wa Mnungu wandile ni kwa yadya want'hu wadamanye, uwedi wakwe hawandile uwedi. ");
INSERT INTO ngp_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Togoleni haluse? Waizilaeli hawakione kiya nawakazungula. Nawanda want'hu watuhu wakione, awo wasagulwe ni Mnungu. Watuhu watendigwa kunda na mioyo midala. ");
INSERT INTO ngp_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Enga ivo Mawandiko Yakukile yakulonga, “Mnungu katenda ubala wawe ne mioyo yawe kunda midala, kubula mazuwa aya hawakudaha kwiva naho hawakudaha kuwona” ");
INSERT INTO ngp_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Naho Daudi agamba, “Zifugo zawe zinde mtego wo kuwagwiila, walihwe kwa masulumizo! ");
INSERT INTO ngp_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Meso yawe yageligwe lwiza yase kuwona, naho migongo yawe neigolome mazuwa yose.” ");
INSERT INTO ngp_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Elo nauza! Wayahudi wakobadika niyo wagwa? Bule! Kwaajili ye dilema dyawe uyokozi wiza kwa want'hu hi Wayahudi vileke Wayahudi wande na finju. ");
INSERT INTO ngp_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Enga lema dya Wayahudi digala wingi wa uvikilwa mwe isi, naho kuswesa kwawe kumhuwila Mnungu kwigala uvikilwa kwa want'hu hiyo Wayahudi na ivo nokunde na uvikilwa utendese umwo Wayahudi wose wakeza kuyokolwa. ");
INSERT INTO ngp_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Haluse nalonga na nyuwe hi Wayahudi. Nikagendeela kunda mwigala ulosi ywa want'hu hi Wayahudi, kwa lupisi lwose naitogola indima yangu. ");
INSERT INTO ngp_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Mafa nenidahe kuwatenda want'hu wangu Wayahudi wande na finju na ivo vidahike kuwayokola wamwenga wawe. ");
INSERT INTO ngp_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Uneva kulemelwa kwawe kwegalaga mwivano kwa Mnungu ne isi, neize inde vivihi umwo wakeza kuivana na Mnungu? Wabanike nawande wagima naho! ");
INSERT INTO ngp_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Uneva kabesu kakwe nk'hongo ko mkate kenk'hizwa kwa Mnungu, ivo mkate wose nounde wakwe, naho uneva maizi yo mti yenk'hizwa kwa Mnungu, matambi nayo yose nayande yakwe. ");
INSERT INTO ngp_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Matambi yamwenga yo mzeituni uhandigwe usengigwa na matambi ya mzeituni wa kwe mbago yahasikwa mwakwe. Nyuwe hi Wayahudi nawo matambi yo mzeituni wa kwe mbago, naho haluse mna luneka lwa kimuye lutogile mwa Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Elo mse kuwabela wadya wasengigwe enga matambi. Nomdahe kukeduvya vivihi? Nyuwe matambi hamkudaha kuyagela nguvu maizi, mna maizi yamigelani nguvu nyuwe matambi. ");
INSERT INTO ngp_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Mna nomgambe, “Heiye mna matambi nayasengigwa vileke nihasikwe hant'hu hakwe” ");
INSERT INTO ngp_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Icho ni kindedi. Nayasengigwa kwa kuswesa mhuwi kwawe, mna nyuwe mkimala kwaviya nomhuwila. Mse kukeduvya, mna wogohe. ");
INSERT INTO ngp_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Uneva Mnungu hadahaga kuwaonela mbazi Wayahudi awo wandaga enga matambi ya nk'hongo, mafani haawaonele mbazi nyuwe. ");
INSERT INTO ngp_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Kaula elo Mnungu ivo eli ywedi naho mkali. Yehe mkali kwajili ya wadya wasaguke, mna ywedi kwa nyuwe uneva mnagendeela kunda mwo uwedi wakwe, hegu nanywe nomsengigwe enga woho. ");
INSERT INTO ngp_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Uneva Wayahudi nawo wanaleka udala wawe wo kuhuwila nawahasikwe hant'hu hawe naho, kwaviya Mnungu ana udahi wo kuwahasika naho. ");
INSERT INTO ngp_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Nyuwe hi Wayahudi mwi chotoko, mnda enga matambi ye mzeituni wa kwe mbago, uhauswa ukwo niyo weza kuhasikwa mwo mzeituni utile kuhailwa. Mna Wayahudi mwe chotoko mwandaga enga mzeituni utile kuhandigwa, naho nevindilise vihufu kuhasikwa naho mwo mti uuwo. ");
INSERT INTO ngp_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Wandugu zangu naunga mmanye ikinyele iki, kwaviya naunga mse kukefanyanya kunda wabala. Ni kugamba nk'hani za Waizilaeli hiyo kugamba hezisile, kubula hadya Mnungu naakint'hize miwazile ya want'hu hi Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Naho ivi nivo Waizilaeli wose nawayokolwe. Enga ivo mawandiko yakugamba, “Mkombozi naalawe Sayuni no kuusa wiihi wose wa welekwa wa Yakobo. ");
INSERT INTO ngp_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Neniike ndagano na woho Umwo hawausila wavu wawe.” ");
INSERT INTO ngp_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kwaviya walemela Mbuli Yedi, Wayahudi wanda wank'hondo wa Mnungu kwaajili yenyu. Mna kwo usaguzi wa Mnungu, Wayahudi waungiswa ni Mnungu kwajili ya wakale wawe. ");
INSERT INTO ngp_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kwaviya mageleko na lwitango lwa Mnungu halukuhituka. ");
INSERT INTO ngp_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Enga viya mwili nyuwe hii Wayahudi, aho nk'hongo homkamtegeleza Mnungu, mna haluse mhokela mbazi za Mnungu kwa kusaguka kwawe Wayahudi. ");
INSERT INTO ngp_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Elo kwaviya muwonelwa mbazi, Wayahudi nawo haluse hawakumwiva Mnungu, vileke nawo waonelwe mbazi ni Mnungu. ");
INSERT INTO ngp_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kwaviya Mnungu kawatenda want'hu wose kunda wavugailwa mwo kusaguka kwawe, vileke alagise mbazi zakwe kwa want'hu wose. ");
INSERT INTO ngp_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ugoli wa Mnungu ni mkulu! Ubala wakwe no umanyi vitendesa! Usengelo wakwe haukupelembwa? Hahali akudaha kuzikombaganya zisila zakwe? ");
INSERT INTO ngp_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Enga ivo Mawandiko yakugamba, “Niani akumanya zifanyanyi za Zumbe? Niani akudaha kumlangiliza? ");
INSERT INTO ngp_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Niani amwink'hile chochose, vileke eze alihigwe ni Zumbe?” ");
INSERT INTO ngp_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kwaviya vint'hu vose vaumbagwa ni yehe na vose venk'hwa ugima ni yehe kwajili yakwe. Yehe enk'higwe ukulu wa ulo na ulo. Taile. ");
INSERT INTO ngp_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Naivo wandugu zangu, kwa mbazi za Mnungu, nawaungani kwa moyo wose, mkelave kwajili ya ndima ya Mnungu mnde nt'hambiko ina ugima kwakwe, ikukile naho ikumwelela, nuko kumvika Mnungu kwa kindedi. ");
INSERT INTO ngp_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Mse kutimila zimbuli ze isi, mna, Mnungu adamanye uhituzi wa kundani mwe zifanyanyi zenyu, vileke mdahe kumanya yadya yakuungwa ni Mnungu naho ni kihi chedi naho kikumwelela naho kikint'hile. ");
INSERT INTO ngp_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Naho kwo uwedi nink'higwe ni Mnungu, nawasigiilani kila yumwenga, mse kukefanyanya nyuwe wenye kwa kukeduvya kujink'ha viya mkuungwa, vituhu vakwe muungise kuidaha mioyo, viligane no mhuwi mwink'higwe ni Mnungu kwa kila yumwenga. ");
INSERT INTO ngp_vpl V