﻿USE sofia;
DROP TABLE IF EXISTS sofia.nfa_vpl;
CREATE TABLE nfa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nfa_vpl WRITE;
INSERT INTO nfa_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Uru-uru tèka, Ama Lamatua pajꞌajꞌi dedha-liru dènge rai-haha. ");
INSERT INTO nfa_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Lodꞌo rai-haha jꞌajꞌi mèka, aaꞌi-aaꞌi dhae mèci mèka. Dhu abhu, èi. Aa maroga aatu-aatu saguru nare ne. Ka Roh Lamatua lela ètu dedha èi èèna. ");
INSERT INTO nfa_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hèia Ama Lamatua peka, “Hudꞌi ku dènge saraa.” Ropa peka nare sèmi neꞌe, ka saraa jꞌajꞌi dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ropa nèdhi saraa ne, dꞌara Na karejꞌe, lula ngaa dhu Na adꞌu, mema beꞌa. Hèia Na hagꞌe eele saraa nèti maroga, sèna ka èci-èci ka dènge taa na. ");
INSERT INTO nfa_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ka pangare saraa ne ‘mèu’, aa maroga na ‘mèda’. Neꞌe ne, lodꞌo ka èci kèna. ");
INSERT INTO nfa_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Hèia Ama Lamatua lii hari, Na peka, “Hudꞌi dènge ku era talele, sèna ka hagꞌe eele èi. Nèti èèna ka, èi re dedha, aa abhu kahèi èi re haha.” Ropa peka nare sèmi èèna, hèia èi bꞌagi dènge mi dua. ");
INSERT INTO nfa_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ka Na pangare èi re dedha na, ‘liru’. Neꞌe ne, lodꞌo ka dua kèna. ");
INSERT INTO nfa_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hèia Ama Lamatua peka hari, aku Nèngu na, “Èi re haha hudꞌi pakaboko ku mi ca era, sèna ka abhu rai kamango.” Ropa padhai lii nare sèmi neꞌe, jꞌajꞌi dènge ka rai mango. ");
INSERT INTO nfa_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ka era rai mango, Na pangare na ‘rai-dedha’; aa era èi dhu kaboko èèna, Na pangare na ‘dhasi’. Ropa nèdhi aaꞌi-aaꞌi ne, dꞌara Na karejꞌe, lula ngaa dhu Na adꞌu, mema beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ka Ama Lamatua lii hari, peka na, “Rai hudꞌi pamamuri ku rupa-rupa ana aajꞌu. Sèna ka abhu ajꞌu dhu hua, dhu dènge lamusi, aa dhu dènge rèu mangèru. Sèna ka ajꞌu-ajꞌu se, hua-hela madhutu rupa rèngu.” Ropa padhai lii nare sèmi neꞌe, jꞌajꞌi dènge ka ana aajꞌu aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ètu dedha-rai, ana aajꞌu se hua-hela ka madhutu rupa rèngu. Ropa nèdhi aaꞌi-aaꞌi se, dꞌara Na karejꞌe, lula ngaa dhu Na adꞌu, mema beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Neꞌe ne, lodꞌo ka tèlu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Hèia Ama Lamatua lii hari, aku Nèngu na, “Re bèka dedha, hudꞌi abhu ku mèdha dhu saraa, ho pasaraa rai-haha ne. Hudꞌi abhu mèdha dhu pasaraa re mèu, aa abhu kahèi dhu pasaraa re mèda. Rèngu aaꞌi-aaꞌi se, jꞌajꞌi tadha, ho sèna ka bisa ige lodꞌo, hèru, dènge tèu.” Ropa padhai lii nare sèmi neꞌe, mèdha dhu heo aaꞌi-aaꞌi ra jꞌajꞌi dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ka Na tao ka mèdha kapai dua dhu pasaraa rai-haha. Dhu kapai risi, pasaraa re mèu; aa dhu ako ana iiki, pasaraa re mèda. Aa Na tao hua-hètu kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Na tèke mèdha dhu saraa sèra ètu dedha-liru, sèna ka loti mai asa rai-haha. ");
INSERT INTO nfa_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ka mèdha se, pasaraa ka re mèu, aa pasaraa re mèda. Dènge jꞌara neꞌe, Na hagꞌe eele saraa nèti maroga. Ropa nèdhi aaꞌi-aaꞌi se, dꞌara Na karejꞌe, lula ngaa dhu Na adꞌu, mema beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Neꞌe ne, lodꞌo ka èpa kèna. ");
INSERT INTO nfa_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Hèia Ama Lamatua padhai lii hari, peka na, “Hudꞌi abhu ku ae-ae dhu mamuri ètu dꞌara èi. Dènge hudꞌi abhu ku rupa-rupa manu-bhui dhu lela ètu dedha rai-haha ne.” ");
INSERT INTO nfa_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ka Na tao ka iꞌa aaꞌi-aaꞌi dènge badha kapai dhu mamuri ètu dꞌara èi. Na pajꞌajꞌi kahèi manu-bhui aaꞌi-aaꞌi. Ropa nèdhi aaꞌi-aaꞌi se, dꞌara Na karejꞌe, lula ngaa dhu Na adꞌu, mema beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ka Na padhai lii ho sèna ka hia berkat mi aaꞌi-aaꞌi dhu mamuri, peka na, “Iꞌa se, hudꞌi laa bèba-kacanga sèna ka papènu èi ètu mia-mia. Aa manu-bhui, asa tabha kahèi.” ");
INSERT INTO nfa_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Neꞌe ne, lodꞌo ka lèmi kèna. ");
INSERT INTO nfa_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Ka Ama Lamatua peka hari, na, “Hudꞌi abhu ku rupa-rupa badha dhu mamuri ètu rai-dedha. Sèmi: badha-manu dhu ani, badha hui, dènge badha dhu rodꞌo, èci-èci ka dènge rupa na.” Ropa padhai lii nare sèmi neꞌe, badha aaꞌi-aaꞌi ra jꞌajꞌi dènge ka. Ropa nèdhi aaꞌi-aaꞌi se, dꞌara Na karejꞌe, lula ngaa dhu Na adꞌu, mema beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ka Ama Lamatua peka hari, aku Nèngu na, “Hua iia, mai Ta pajꞌajꞌi dhèu, madhutu rupa Èdhi. Hudꞌi laa ra leru dènge ator iꞌa aaꞌi-aaꞌi ètu dꞌara dhasi, manu-bhui aaꞌi-aaꞌi ètu dedha-liru, badha-manu dhu ani, dènge badha leo aaꞌi-aaꞌi ra dhu mamuri ètu rai-haha ne.” ");
INSERT INTO nfa_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hèia Na pajꞌajꞌi dhèu rai-haha ne madhutu rupa Na. Na pajꞌajꞌi si, dhèu mone dènge dhèu bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ka Na padhai lii ho sèna ka hia berkat mi rèngu, aku Nèngu na, “Miu hudꞌi bèba-kacanga ku, sèna ka pea papènu rai-haha ne, ho mi ator ne. Jaꞌa hia miu koasa, sèna ka mi ator iꞌa, manu-bhui, dènge badha-manu aaꞌi-aaꞌi ra ètu rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mi nanene paie-iie! Jaꞌa hia miu rupa-rupa ngangaꞌa ètu rai-haha neꞌe. Sèmi: ana aajꞌu dhu dènge hua, dhu dènge lamusi, aa dhu dènge rèu mangèru. ");
INSERT INTO nfa_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Jaꞌa hia rupa-rupa ana aajꞌu kahèi sèna ka jꞌajꞌi ngangaꞌa badha. Ngangaꞌa hia badha-manu dhu ani, badha hui, badha dhu rodꞌo, dènge manu-bhui.” Ropa padhai lii nare sèmi neꞌe, ngangaꞌa badha sèra aaꞌi-aaꞌi ra jꞌajꞌi dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ropa nèdhi aaꞌi-aaꞌi se, dꞌara Na karejꞌe, lula ngaa dhu Na adꞌu, mema beꞌa. Neꞌe ne, lodꞌo ka èna kèna. ");
INSERT INTO nfa_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Dènge jꞌara sèmi èèna ka, Ama Lamatua pajꞌajꞌi dedha-liru, rai-haha, dènge isi ra aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ropa Na sabꞌa èle, asa bèli èèna, lèke dènge lodꞌo ka pidhu. Hèia Na ae nèti sasabꞌa-laꞌa Na. ");
INSERT INTO nfa_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Dènge jꞌara neꞌe, Na tao lodꞌo ka pidhu ne, lodꞌo dhu kapai risi nèti lodꞌo dhu leo sèra. Na tao sèmi èèna, lula Na paꞌèle aaꞌi le sasabꞌa Na, ka ètu dꞌara lodꞌo ka pidhu na, Na ae. ");
INSERT INTO nfa_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Dꞌai sange neꞌe ka, lii lolo Ama Lamatua pajꞌajꞌi dedha-liru dènge rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Lodꞌo Ama LAMATUA heka pajꞌajꞌi dedha-liru dènge rai-haha èèna, ");
INSERT INTO nfa_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","dhae abhu mèka ana aajꞌu, lula Na papuru mèka èjꞌi. Taa èèna, dhoka sèbꞌu èi di, mai nèti dꞌara rai ho pabasa rai re dedha. Aa abhu mèka dhèu rai-haha dhu tao oka-tedhe. ");
INSERT INTO nfa_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Èle èèna ka, Ama LAMATUA nare rai ciki, ka Na pajꞌajꞌi dhèu rai-haha. Hèia Na tiu aꞌae Na asa dꞌara sahènga dhèu na, ka na mamuri dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hèia Ama LAMATUA bhoke oka cue ètu rai Eden, re bèka dhimu. Hèia Na hia dhèu ne pea ètu dꞌara oka na. ");
INSERT INTO nfa_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ètu dꞌara oka èèna, Na pamamuri rupa-rupa ajꞌu dhu beꞌa, dhu dhèu bisa raꞌa. Aa Na pamamuri kahèi ajꞌu dua kapua ètu talora aae oka èèna. Ladhe dhèu raꞌe hua nèti ajꞌu èci, na mamuri taa-taa. Aa ladhe dhèu raꞌe hua nèti ajꞌu èci hari, neꞌa hagꞌe mia dhu beꞌa, aa mia dhu karehe. ");
INSERT INTO nfa_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ètu era èèna, abhu loko èci dhu hae nèti dꞌara oka èèna. Loko èèna, èpa kacanga. ");
INSERT INTO nfa_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kacanga ka èci na, ngara na Pison. Nèngu ka dhu hae pale-lème rai Hawila dhu abhu hualaa ae-ae. ");
INSERT INTO nfa_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ètu era èèna ka, abhu poe-pai, ajꞌu dhu raa na hèu mèngi, dènge hadhu kaleꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kacanga ka dua, ngara na Gihon. Kacanga ne, hae pale-lème rai Kus. ");
INSERT INTO nfa_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kacanga ka tèlu, ngara na Tigris. Kacanga neꞌe ka, jꞌajꞌi mi too rai Asyur re ca bèka dhimu. Kacanga ka èpa, ngara na Efrat. ");
INSERT INTO nfa_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ka Ama LAMATUA hia dhèu pea ètu dꞌara Eden, ho na ladhe-leru oka èèna. ");
INSERT INTO nfa_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Hèia Na hia paredha mi dhèu ne, aku Nèngu na, “Hua aajꞌu aaꞌi-aaꞌi ètu dꞌara oka ne, èu bisa muꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Te ngaa èci dhu èu bisa boe muꞌa. Nuka hua nèti ajꞌu dhu neꞌa hagꞌe mia dhu beꞌa, aa mia dhu karehe. Ladhe muꞌa, èu madhe dènge.” ");
INSERT INTO nfa_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ka Ama LAMATUA tuhu haru lii Na, aku Nèngu na, “Babeꞌa na aadꞌo, ladhe dhèu ne mamuri mesa na. De Jaꞌa neo pajꞌajꞌi hia ne, anga ca dhèu dhu pamèci dènge ne.” ");
INSERT INTO nfa_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Lodꞌo èèna, Ama LAMATUA nare rai ciki, ka Na tao rupa-rupa badha dènge manu-bhui. Hèia Na pangèdꞌu si asa dhèu ne, sèna ka na pangare si. Ka dhèu ne pangare badha se dènge manu-bhui aaꞌi-aaꞌi ra, èci-èci ka dènge ngara ra. Te ngaa dhèu ne abhu mèka anga dhu pamèci dènge nèngu. ");
INSERT INTO nfa_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hèia Ama LAMATUA pabhèjꞌi luu dhèu neꞌe. Ropa na bhèjꞌi, Ama Lamatua nare rui karasa na calaa, ka Na pakateme hari nuꞌa deo na. ");
INSERT INTO nfa_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nèti rui ne, Na pajꞌajꞌi bhèni ca dhèu. Hèia Na pangèdꞌu bhèni ne mi dhèu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ropa ladhe nèdhi bhèni ne, ka dhèu na peka, aku nèngu na, “Waaa! Neꞌe ne ku! Sèmi neꞌe ku, heka pamèci dènge jaꞌa kèna! Rui na, sama èci èèna ka dènge rui jaꞌa. Aa isi na, sama kahèi dènge isi jaꞌa. Lula nèngu ne, jꞌajꞌi nèti dhèu mone, nèti èèna ka jaꞌa pangare ne, ‘dhèu bhèni’.” ");
INSERT INTO nfa_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nèti èèna ka, dhèu mone hudꞌi tèke eele ku ina-ama na, ho laꞌe mamuri dꞌara èci dènge dhèu èmu-kamali na, lula dua ra, jꞌajꞌi le èci. ");
INSERT INTO nfa_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Lodꞌo èèna, dua ra dhu dènge boe mèdha-papake, te ngaa ra makae boe. ");
INSERT INTO nfa_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nèti badha aaꞌi-aaꞌi dhu Ama LAMATUA pajꞌajꞌi ètu rai-haha ne, mege ka dhu mèu risi kapodꞌe-kabèli. Ca lodꞌo, mege karèi bhèni na, aku nèngu na, “Tareꞌa, do? Ama Lamatua kai miu baku miꞌa hua aajꞌu aaꞌi-aaꞌi ètu dꞌara oka neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Ka bhèni na bꞌala, “Aadꞌo! Jiꞌi bisa ngaꞌa! Dhodhoka ajꞌu ca kapua ètu talora oka ne, Ama Lamatua kai, baku ngaꞌa hua na. Na peka na, jiꞌi baku ngaꞌa, aa baku gꞌagꞌe hua èèna kahèi, te aadꞌo na, jiꞌi madhe!” ");
INSERT INTO nfa_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Te ngaa mege na dhaa, aku nèngu na, “Waa! Sèmi boe èèna! Miu se madhe boe! ");
INSERT INTO nfa_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ama Lamatua mema kai tareꞌa sèmi èèna, lula dhu neꞌa le, ladhe miꞌe hua aajꞌu èèna, miu jꞌajꞌi dꞌèlu-mèu sèmi Nèngu. Ho èèna na meꞌa mia dhu beꞌa, aa mia dhu karehe.” ");
INSERT INTO nfa_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Aa bhèni ne ladhe na ajꞌu ne beꞌa titu kèna, dènge hua na ele boe kee. Na ngee, “Ladhe jaꞌa kuꞌa hua ajꞌu neꞌe, jaꞌa dꞌèlu-mèu.” Hèia puu nare ka hua ajꞌu èèna, ka naꞌe. Naꞌe nare, nèti hia dhèu èmu na, ka naꞌa kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Raꞌa rare ka, heka reꞌa na rèngu dhu pake boe mèdha dhu hutu ua rèngu. Nèti èèna ka, ra lui rèu ajꞌu ho paꞌabhe era makae rèngu. ");
INSERT INTO nfa_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Dꞌai lodꞌo nihia, dua ra tadèngi lii core haga Ama LAMATUA ètu dꞌara oka èèna. Ka dua ra rai lasi luꞌu asa ca bèka ajꞌu, sèna ka LAMATUA baku nèdhi si. ");
INSERT INTO nfa_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Te ngaa Ama LAMATUA paroa mi dhèu mone èèna, aku Nèngu na, “Adam! Èu ètu mia?” ");
INSERT INTO nfa_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Hèia mone na dhaa, “Jaꞌa tadèngi lii Lamatua ètu neꞌe. Te ngaa jaꞌa makae, lula jaꞌa pake boe mèdha ètu ua. Nèti èèna ka, jaꞌa rai pahuni iisi.” ");
INSERT INTO nfa_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ka Lamatua peka na, “Cee ka dhu peka, na èu dhu pake boe mèdha-papake? De tasamia? Tatu èu muꞌa le hua ajꞌu dhu Jaꞌa kai na, sina ma?” ");
INSERT INTO nfa_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ka na bꞌala, peka na, “Bhèni dhu Èu hia ho paꞌanga dènge jaꞌa èèna, ka dhu hia jaꞌa kuꞌa!” ");
INSERT INTO nfa_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Hèia Ama LAMATUA peka dènge bhèni na, aku Nèngu na, “Nga tao ka, èu adꞌu madha jꞌara èèna?” Ka bhèni ne dhaa, peka na, “Te mege ne ka dhu agꞌo jaꞌa! Nèti èèna ka, jaꞌa kuꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Èle èèna ka, Ama LAMATUA dhoo mege èèna, aku Nèngu na, “Jaꞌa huku èu, lula tatao èu. Nèti badha aaꞌi-aaꞌi, dhoka èu di dhu abhu huku sèmi neꞌe. Mulai nèti deo neꞌe toke èu madhe, èu dhoka rodꞌo dènge kakara, aa muꞌa ètu rai di. ");
INSERT INTO nfa_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Jaꞌa tao sèna ka, èu loe boe pamusu dènge bhèni ne. Aa ana-èpu miu dua mi sèmi èèna kahèi. Ana-èpu èu, èèna na kadhi hui tèdhu dhèu. Te ngaa ca dhèu nèti ana-èpu bhèni ne, èèna na dhedhe palaho kètu èu.” ");
INSERT INTO nfa_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Èle èèna ka, Ama Lamatua peka dènge bhèni ne, “Èèna na, Jaꞌa pasusa tabha èu, ropa èu dènge babia; lodꞌo mora iisi, èu asa tabha jꞌèra. Masi ka sèmi èèna, dꞌara èu dꞌèi taruu dhèu èmu èu, aa nèngu ka dhu ator èu.” ");
INSERT INTO nfa_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ka Ama Lamatua peka dènge mone ne, “Èu madhutu boe lii paredha Jaꞌa, te ngaa èu nanene dhoka lii dhèu èmu èu di, ka èu muꞌa hua ajꞌu dhu Jaꞌa kai èèna. Nèti èèna ka, èu abhu huku kahèi. Aa rai lèke huku kahèi. Nèti deo neꞌe, toke dꞌai èu madhe, hudꞌi èu kabèli rai, heka èu abhu ngangaꞌa kèna. Dènge sabꞌa bia sèmi neꞌe ka, èu heka mamuri kèna. ");
INSERT INTO nfa_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Masi ka èu sèle rupa-rupa hini èèna ka, te ngaa dhu muri mai dhodhoka dhudhu-sete di. ");
INSERT INTO nfa_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Hudꞌi èu èi kabhèsu haa ku, heka rai hia èu ngangaꞌa kèna. Èu hudꞌi sabꞌa bia sèmi èèna ku, toke dꞌai lodꞌo èu madhe. Èu ne, Jaꞌa pajꞌajꞌi nèti rai. De ladhe èu madhe, èu jꞌajꞌi hari rai.” ");
INSERT INTO nfa_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Èle èèna ka, Adam pangare dhèu èmu na ‘Hawa’ (dhu sasoa na ‘dhu mamuri’), te nèngu ka jꞌajꞌi ina nèti dhèu dhu mamuri aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Hèia Ama LAMATUA tao mèdha-papake nèti kaꞌuri badha, ka papake dua ra. ");
INSERT INTO nfa_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ka Ama LAMATUA peka, “Limuri ne, dhèu reꞌa le, mia dhu beꞌa dènge mia dhu karehe, sèmi Èdhi kahèi. De mage dhoka, rèngu raꞌa hua ajꞌu dhu èci hari na, dhu hia mamuri taa-taa.” ");
INSERT INTO nfa_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Èle èèna ka, Na babèga eele si nèti dꞌara oka Eden èèna, ho lasi asa era leo, sèna ka ra mamuri dènge sabꞌe oka-tedhe. Lula dhèu jꞌajꞌi nèti rai, de mamuri kahèi nèti rai. ");
INSERT INTO nfa_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Babège nare si, ka Lamatua paredha ana pajuu Na nèti sorga, dhu dènge èla, ho lasi jꞌaga oka èèna re ca bèka dhimu. Rèngu dènge samala dhu heo haꞌa-haꞌa, dhu seru laꞌe-mai. Lamatua pua si bèdho eele jꞌara laꞌe sa dꞌara, te Nèngu dꞌèi boe dhèu puu rare hua ajꞌu dhu hia ra mamuri taa-taa èèna. ");
INSERT INTO nfa_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Hèia Adam jꞌunu dènge dhèu èmu na, Hawa. Ka bhèni ne dènge babia. Hèia nara iisi ana mone ca dhèu. Ka na peka, aku nèngu na, “Jaꞌa abhu le ana mone ca dhèu, lula Ama LAMATUA soru nare le jaꞌa.” Ka na pangare ana ne, Kaen (dhu sasoa na ‘abhu’). ");
INSERT INTO nfa_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hèia Hawa nara iisi hari ana mone èci. Ka na pangare ne Habel. Dua ra kapai ka, Habel jꞌajꞌi dhèu madhenge badha. Aa aꞌa na Kaen, sabꞌa oka-tedhe. ");
INSERT INTO nfa_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ca lodꞌo, Kaen nèti isi rai na cahagꞌe, ka hia LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel nèti ana-ana uuru kahibꞌi-kalèbho na. Na roro kahibꞌi-kalèbho se, ka nèti sisi dhu beꞌa hia Lamatua. Dꞌara Ama Lamatua karejꞌe ropa ladhe nèdhi korban nèti Habel ne. ");
INSERT INTO nfa_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Te ngaa Na dꞌèi boe korban unu Kaen. Hèia Kaen nasa bia, ka rèhu na mare boe. ");
INSERT INTO nfa_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ka LAMATUA lii dènge Kaen, aku Nèngu na, “Kaen! Nga tao ka èu nasa sèmi èèna, ka rèhu èu mare boe? ");
INSERT INTO nfa_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ladhe tatao èu beꞌa, na Jaꞌa sèmi èu dènge hua iia. De mu pangee uuru ku! Ladhe èu tao bhelu, na bhabhelu èèna naꞌe hari èu, sama sèmi meo neo pacèli maraho. De sèmi èu neo tao bhabhelu, beꞌa risi core eele ka!” ");
INSERT INTO nfa_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ca tèka, Kaen gale Habel, na peka na, “Mai lati ngadꞌo oka, we.” Ropa dua ra dꞌai dꞌara oka, Kaen kalabhe pamadhe ari na. ");
INSERT INTO nfa_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ka LAMATUA karèi Kaen, aku Nèngu na, “Kaen! Ari mu ka mia?” Hèia Kaen dhaa, aku nèngu na, “Jaꞌa keꞌa boe na ètu mia! Èu ngee na, jaꞌa dhèu kèpe haga na, do?” ");
INSERT INTO nfa_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ka Lamatua bꞌala, “Nga tao ka èu bhelu sèmi èèna? Baku pangee na, èu pahuni more le raa ari èu ètu dꞌara rai, te Jaꞌa dhu kèdhi aaꞌi-aaꞌi le! ");
INSERT INTO nfa_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","De lii dhoo lèke le mi dedha èu. Lodꞌo èu pamadhe ari èu, rai sakidꞌo nare raa na. De limuri ne, rai bisa heka nèti mamuri mi èu. ");
INSERT INTO nfa_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","De ladhe èu sabꞌa oka-tedhe, rai ne hia heka èu ngaa-ngaa. Nèti deo neꞌe, èu luꞌu sa haa-sa dhimu, sèmi dhèu dhu dènge boe era paleo-paluꞌu.” ");
INSERT INTO nfa_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Te ngaa Kaen bꞌala LAMATUA, aku nèngu na, “Haii! Ama Lamatua, ee! Lamatua dhoo jaꞌa bia titu kèna, de jaꞌa pasae mèke boe nga. ");
INSERT INTO nfa_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lula Lamatua bège eele jaꞌa nèti era neꞌe, jaꞌa kajꞌèu nèti Ama Lamatua. Jaꞌa kako lole-laa asa mia-mia. De ladhe paraga dènge dhèu, èèna na ra pamadhe jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Te ngaa LAMATUA dhaa na, “Aadꞌo sèmi èèna! Dhèu cee dhu pamadhe èu, èèna na Jaꞌa huku ne, babia na pidhu hari risi nèti èu.” Hèia LAMATUA tao tadha mi Kaen, sèna ka dhèu reꞌa ho baku pamadhe ne. ");
INSERT INTO nfa_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Hèia Kaen tèke eele dènge era èèna. Laꞌe pakajꞌèu nèti LAMATUA, asa era èci, ètu bèka dhimu oka Eden. Era neꞌe, ngara na Nod dhu sasoa na, ‘lole-laa’. Ka na pea ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Hèia Kaen leo-èmu, ka dhèu èmu na dènge babia. Ka nara iisi ana mone ca dhèu, dhu pangare na Henok. Hèia Kaen patitu rae cue, ngara na Henok, madhutu ngara ana na. ");
INSERT INTO nfa_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ka Henok matana Irad. Hèia Irad matana Mehuyael. Mehuyael matana Metusael. Aa ana Metusael, Lamek. ");
INSERT INTO nfa_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Dhèu èmu Lamek, dhèu dua. Èci ngara na Ada, aa ca dhèu hari, ngara na Sila. ");
INSERT INTO nfa_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ana Ada, ngara na Yabal. Ana-èpu na, jꞌajꞌi dhèu piara badha. Mamuri ra ètu boe ca era, aa ra pea dhoka ètu dꞌara paleo di. ");
INSERT INTO nfa_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ari Yabal, ngara na Yubal. Ana-èpu Yubal, jꞌajꞌi dhèu gai sasadhu, dènge tiu sakino. ");
INSERT INTO nfa_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Dhèu èmu Lamek èci hari, Sila, nara iisi Tubal Kaen. Ana-èpu na jꞌajꞌi tuka bèsi, ka ra tuku mèdha ae-ae tao nèti bèsi, dènge tabaga. Ana hèni Tubal Kaen, ngara na Naꞌama. ");
INSERT INTO nfa_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ca tèka, Lamek padedha iisi na ètu madha dhèu èmu dua ra, peka na, “Mi nanene, ee! Deo na, ana mone ngèru èci neo game jaꞌa. Te ngaa jaꞌa dhadhedhe ne, toke madhe. ");
INSERT INTO nfa_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Dhèu dhu pamadhe Kaen, abhu huku pidhu hari. Te ngaa cee ka dhu neo bꞌala ho pamadhe jaꞌa, abhu huku pidhu nguru pidhu hari.” ");
INSERT INTO nfa_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ka Hawa nara iisi hari ana mone ca dhèu. Hèia ra pangare ne, Set (dhu sasoa na, ‘hia’), lula aku Hawa na, “Ama Lamatua hia jaꞌa ana ne, sèna ka gati madha Habel, dhu Kaen pamadhe ne.” ");
INSERT INTO nfa_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Pe dꞌai nèbhu ku, Set abhu ana mone ca dhèu, dhu pangare na Enos. Tèu èèna, dhèu mulai manèngi-mangajꞌi mi Ama LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Lodꞌo Ama Lamatua pajꞌajꞌi dhèu rai-haha, Na tao si sama sèmi rupa Nèngu. Na pajꞌajꞌi si, dhèu mone dènge dhèu bhèni. Ka Na pangare si ‘dhèu rai-haha’, aa Na hia si berkat. Dhèu dhu uru, ngara na Adam. Ana-èpu Adam, nuka sèmi neꞌe ka: ");
INSERT INTO nfa_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Lodꞌo Adam dꞌai 130 (ca ngasu tèlu nguru) tèu, na matana ana mone ca dhèu, dhu rèhu na nare Adam. Ka pangare na, Set. ");
INSERT INTO nfa_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ka Adam mamuri hari dꞌai 800 (aru ngasu) tèu, hèia na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Umur Adam 930 (ceo ngasu tèlu nguru) tèu, heka madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Lodꞌo Set dꞌai 105 (ca ngasu lèmi) tèu, na abhu ana mone ca dhèu, ngara na Enos. ");
INSERT INTO nfa_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ka Set mamuri hari dꞌai 807 (aru ngasu pidhu) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Umur Set 912 (ceo ngasu canguru dua) tèu, heka madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Lodꞌo Enos mamuri dꞌai 90 (ceo nguru) tèu, na matana ana mone ca dhèu, ngara na Kenan. ");
INSERT INTO nfa_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ka Enos mamuri hari dꞌai 815 (aru ngasu canguru lèmi) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Umur Enos 905 (ceo ngasu lèmi) tèu, heka madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Lodꞌo Kenan dꞌai 70 (pidhu nguru) tèu, na matana ana mone ca dhèu, ngara na Mahalalel. ");
INSERT INTO nfa_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ka Kenan mamuri hari dꞌai 840 (aru ngasu èpa nguru) tèu, ka na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Umur Kenan 910 (ceo ngasu canguru) tèu, heka madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Lodꞌo Mahalalel dꞌai 65 (èna nguru lèmi) tèu, na abhu ana mone ca dhèu, ngara na Yared. ");
INSERT INTO nfa_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ka Mahalalel mamuri hari dꞌai 830 (aru ngasu tèlu nguru) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Umur Mahalalel 895 (aru ngasu ceo nguru lèmi) tèu, heka na madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Lodꞌo Yared dꞌai 162 (cangasu èna nguru dua) tèu, na abhu ana mone ca dhèu, ngara na Henok. ");
INSERT INTO nfa_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ka Yared mamuri dꞌai 800 (aru ngasu) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Umur Yared 962 (ceo ngasu èna nguru dua) tèu, heka madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ropa Henok mamuri dꞌai 65 (èna nguru lèmi) tèu, na matana ana mone ca dhèu, ngara na Metusalak. ");
INSERT INTO nfa_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ele èèna, Henok mamuri dꞌara èci dènge Ama Lamatua dꞌai 300 (tèlu ngasu) tèu. Ka na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Na mamuri dꞌara èci dènge Ama Lamatua. Hèia lodꞌo na dꞌai 365 (tèlu ngasu èna nguru lèmi) tèu, ka na ele, lula Ama Lamatua pacaꞌe ne sa dedha. ");
INSERT INTO nfa_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Lodꞌo Metusalak dꞌai 187 (cangasu aru nguru pidhu) tèu, na matana ana mone èci, ngara na Lamek. ");
INSERT INTO nfa_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Èle èèna ka, Metusalak mamuri hari dꞌai 782 (pidhu ngasu aru nguru dua) tèu, ka na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Umur Metusalak 969 (ceo ngasu èna nguru ceo) tèu, heka madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lodꞌo Lamek mamuri dꞌai 182 (ca ngasu aru nguru dua) tèu, na matana ana mone ca dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek pangare ne Noh (dhu sasoa na ‘pakarejꞌe dꞌara’), lula na peka na, “Ana ne, èèna na pakarejꞌe dꞌara èdhi nèti sasabꞌa dhu bia, ètu rai dhu Ama Lamatua dhoo le.” ");
INSERT INTO nfa_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ka Lamek mamuri taruu dꞌai 595 (lèmi ngasu ceo nguru lèmi) tèu, aa na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Umur Lamek 777 (pidhu ngasu pidhu nguru pidhu) tèu, heka na madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Lodꞌo Noh mamuri dꞌai 500 (lèmi ngasu) tèu, na matana ana mone dhèu tèlu, Sem, Yafet dènge Ham. ");
INSERT INTO nfa_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Taa èèna, dhèu rai-haha, asa bèba-kacanga. Ka ra papala-palème rai-haha. Dhèu se matana kahèi ana-ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ana-ana mone nèti Lamatua ladhe rèdhi ana bhèni nèti dhèu rai-haha se, bhèni iia hua. Ka lasi todhe rare ana bhèni mia dhu ra dꞌèi. ");
INSERT INTO nfa_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ka LAMATUA peka na, “Jaꞌa roca le dènge tatao dhèu dhu lèke-lèke boe se. Roh Jaꞌa dhu pamamuri rèngu sa, dꞌèi heka hia ra mamuri manèro. Hudꞌi rèngu madhe ku. De èèna na, mamuri rèngu se dhoka dꞌai 120 (ca ngasu dua nguru) tèu di.” ");
INSERT INTO nfa_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Taa èèna, dènge taa-tebho dhu limuri nèti èèna hari, abhu le dhèu raksasa ètu rai-haha ne. Ropa ana mone nèti Lamatua leo rare ana bhèni dhèu rai-haha se, ka rara iisi dhèu kapai, nuka: kapala musu, dhèu reꞌa madhutu lii lolo uru-uru sèra. ");
INSERT INTO nfa_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Taa èèna, LAMATUA ladhe nèdhi bhabhelu-katubꞌa dhèu rai-haha dhu seli-kolane. Dꞌara rèngu pangee dhoka bhabhelu di. ");
INSERT INTO nfa_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ka LAMATUA manyasa, lula Na pajꞌajꞌi le rèngu se ho pea ètu rai-haha ne. Tatao rèngu neꞌe ka dhu papèdꞌa dꞌara Lamatua. ");
INSERT INTO nfa_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nèti èèna ka, Na peka na, “Dènge tatao rèngu sèmi èèna na, Jaꞌa huku pamadhe dhèu rai-haha aaꞌi-aaꞌi dhu pajꞌajꞌi kore si le. Manu-bhui dènge badha leo sèra, Jaꞌa palaho aaꞌi si kahèi. Te Jaꞌa manyasa, nèti Jaꞌa ka pajꞌajꞌi si.” ");
INSERT INTO nfa_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Te ngaa Noh di dhu pakarejꞌe dꞌara LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Lii lolo Noh sèmi neꞌe ka: Ana mone na, dhèu tèlu, nuka Sem, Yafet dènge Ham. Noh mamuri dènge mola, koe-kapengo boe. Taa èèna, nèngu di dhu mamuri mola. Dꞌara na dhodhoka ètu Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Te ngaa dhèu leo se, Ama Lamatua ladhe ra bhelu aaꞌi mèu-mèu. Ètu mia-mia èèna ka, jꞌara mamuri dhèu se ele iie aaꞌi. Ama Lamatua nèdhi dhodhoka bhabhelu di, ètu rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hèia Ama Lamatua peka dènge Noh, aku Nèngu na, “Jaꞌa kèdhi dhoka bhabhelu dhèu di, dhu pale-lème rai-haha ne. Ka Jaꞌa pamaꞌète kore le, sèna ka Jaꞌa palaho aaꞌi rai-haha ne dènge isi na aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","De sèmi neꞌe, Noh! Èu tao kapa aae cue, dhu tao nèti ajꞌu adhu. Re dꞌara roa na, èu bagi mi kama-kama. Aa re dꞌara dènge liꞌu kapa, èu lame dènge èi dama. ");
INSERT INTO nfa_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mu sabꞌe kapa na, madhera na 133 (ca ngasu tèlu nguru tèlu) meter; bhabhèla na 22 (dua nguru dua) meter; dènge katitu na 13 (canguru tèlu) meter. ");
INSERT INTO nfa_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Èu tao èmu ètu dedha kapa na. Te ngaa paconga ca laa ai nèti kadidhi re dedha. Èu bagi kapa ne mi tèlu tadꞌa. Aa re karasa na, tao babèdho èci. ");
INSERT INTO nfa_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Sanèdꞌe paie-iie! Bèli-camèdꞌa, Jaꞌa papuru èi aae lala, ho pacène eele rai-haha ne, sèna ka pamadhe aaꞌi dhu mamuri. ");
INSERT INTO nfa_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Te ngaa Jaꞌa paꞌèki lii pajaji dènge èu. Èèna na, èu maso dꞌara kapa èèna, mèti dènge dhèu èmu èu, ana-ana èu, dènge dhèu èmu ana-ana èu. ");
INSERT INTO nfa_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Badha aaꞌi-aaꞌi ra, èu hagꞌe more ca pasa-ca pasa, eo mèti asa dꞌara kapa, ho ra abhu mamuri dènge èu kahèi. Sèmi: badha ani, manu-bhui, dènge badha dhu rodꞌo, sèna ka ra abhu mamuri. ");
INSERT INTO nfa_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Èu hudꞌi mèti dènge ngangaꞌa-nganginu, pala miu dènge pala badha sèra hèi.” ");
INSERT INTO nfa_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ka Noh sabꞌe madhutu sèmi lii paredha Ama Lamatua aaꞌi-aaꞌi sèra. ");
INSERT INTO nfa_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Èle èèna ka, LAMATUA peka dènge Noh, “Jaꞌa ladhe le palème, te ngaa abhu dhoka èu di dhu dꞌara mola. Nèti èèna ka, èu dènge bhèni-ana niki èu, lami ka asa dꞌara kapa. ");
INSERT INTO nfa_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Mèti dènge badha-badha dhu bisa miꞌa, aa bisa hia Jaꞌa kahèi, de mèti pidhu-pidhu pasa asa dꞌara kapa. Mèti kahèi rupa-rupa manu-bhui pidhu-pidhu pasa. Te ngaa badha dhu leo, mèti dhoka ca pasa-ca pasa di. Sèna ka badha dènge manu-bhui se, jꞌajꞌi hini, ho baku maꞌète. ");
INSERT INTO nfa_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Sanèdꞌe paie-iie, oo! Di pidhu lodꞌo ka, Jaꞌa papuru èjꞌi aae mai dhu bhoka boe ca lodꞌo sa, toke dꞌai èpa nguru lodꞌo mèu-mèda. Dènge sèmi neꞌe, Jaꞌa pamadhe aaꞌi ngaa-ngaa dhu mamuri ètu dedha-rai, dhu Jaꞌa pajꞌajꞌi kore le.” ");
INSERT INTO nfa_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ka Noh tao aaꞌi sèmi lii paredha LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Lodꞌo èi aae lala, umur Noh 600 (èna ngasu) tèu. ");
INSERT INTO nfa_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noh dènge dhèu èmu na, dènge ana niki na, aa dènge dhèu èmu ana ra di, lasi asa dꞌara kapa, ho ra abhu mamuri. ");
INSERT INTO nfa_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Madhutu lii paredha LAMATUA, ka Noh pamaso manu-bhui dènge badha leo sèra, èci-èci ka dènge pasa na, nèti dhu bisa raꞌa, dènge dhu bisa boe raꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ropa èle pidhu lodꞌo, cagꞌagꞌa laa èi aae lala, ka rai-haha ne, mulai cène. ");
INSERT INTO nfa_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Lèke dènge umur Noh 600 (èna ngasu) tèu, risi dua hèru, canguru pidhu lodꞌo, ka mulai èi aae lala. Lodꞌo èèna, sèmi babèdho liru dhu bhoke eele sa, ka èi na tao sabhori mai. Aa èi madha-èi madha ètu rai-haha sabhoka, ka sèmi tao sabhuu sa dedha. ");
INSERT INTO nfa_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ka èjꞌi bhori mai loe boe èpa nguru lodꞌo mèu-mèda. ");
INSERT INTO nfa_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Te ngaa lodꞌo èèna, Noh dènge dhèu èmu na, dènge ana mone na dhèu tèlu: Sem, Yafet dènge Ham, dènge dhèu èmu ra, maso lasi asa dꞌara kapa. ");
INSERT INTO nfa_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Lasi palere dènge badha aaꞌi-aaꞌi ra, sèmi: badha ani, badha hui, badha dhu rodꞌo, manu-bhui, dènge badha-badha leo dhu dènge èla sèra. ");
INSERT INTO nfa_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Ca pasa-ca pasa nèti aaꞌi-aaꞌi dhu mamuri, lasi asa dꞌara kapa palere dènge Noh, madhutu sèmi lii paredha Ama Lamatua. Ropa aaꞌi-aaꞌi ra dꞌai dꞌara kapa, LAMATUA bèdho babèdho kapa èèna. ");
INSERT INTO nfa_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Èjꞌi aae puru maꞌète boe dꞌai èpa nguru lodꞌo. Hèia kapa èèna talebꞌo. Èi caꞌe loe boe toke hutu nare kolo ledhe dhu dedha aae. ");
INSERT INTO nfa_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Èi caꞌe taruu, ka marèma na seli èpa rèpa risi nèti kolo ledhe sèra. ");
INSERT INTO nfa_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Dènge jꞌara èèna, ngaa-ngaa dhu mamuri ètu dedha-rai sèra, madhe aaꞌi mèu-mèu. Nuka: dhèu, badha ani, badha hui, badha dhu rodꞌo, dènge manu-bhui aaꞌi-aaꞌi ra. Ate dhoka Noh dènge aaꞌi-aaꞌi dhu ètu dedha kapa. ");
INSERT INTO nfa_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Èi na, kura boe toke 150 (ca ngasu lèmi nguru) lodꞌo. ");
INSERT INTO nfa_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Masi ka sèmi èèna, Ama Lamatua bhèlu boe Noh si dènge badha-manu aaꞌi-aaꞌi dhu ètu dedha kapa. Hèia Na hia ngèlu gꞌoro, ka èi na kura ka noo-noo. ");
INSERT INTO nfa_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Na katange èi madha aaꞌi-aaꞌi ètu rai-haha ne, aa Na taha èjꞌi kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ka èi kura noo-noo ka. Dꞌai cangasu lèmi nguru lodꞌo, èi marèma heka. ");
INSERT INTO nfa_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Lèke dènge hèru ka pidhu, risi canguru pidhu lodꞌo, kapa eta ètu kolo ledhe aae èci, ngara na Ararat. ");
INSERT INTO nfa_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Èi kura taruu toke lodꞌo ka èci, hèru ka canguru, ka kolo-kolo ledhe cèu noo-noo. ");
INSERT INTO nfa_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Risi nèti èpa nguru lodꞌo, hèia Noh bhoke jendela èci. ");
INSERT INTO nfa_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ka na patalale lakaa ciꞌu. Manu-bhui ne lela laꞌe-mai, toke èi puru. Ka na lèpa heka asa kapa. ");
INSERT INTO nfa_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hèia Noh patabuli hari, koro jꞌaha ciꞌu, sèna ka neo neꞌa èi na puru le, do dhae. ");
INSERT INTO nfa_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Te ngaa, lula èi hutu nare dedha-rai era, ka koro ne abhu boe era tèka. Ka lèpa hari asa kapa. Hèia Noh jꞌole ai na, kèpe nare, ka na pamaso hari asa dꞌara kapa. ");
INSERT INTO nfa_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ka Noh tatae hari dꞌai pidhu lodꞌo, hèia na patabuli hari koro jꞌaha deo na. ");
INSERT INTO nfa_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Dꞌara lodꞌo nihia sa, koro ne lèpa hari laꞌe asa Noh, tutu nèti dènge rèu saitun ca rèu dhu heka tutu nare kèna. Nèti èèna ka, Noh heka neꞌa kèna, èi na dhu puru le tareꞌa di. ");
INSERT INTO nfa_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ka na mate hari dꞌai pidhu lodꞌo, hèia na patalale hari koro jꞌaha ca hari ni. Te ngaa ca tèka ne, koro ne lèpa heka. ");
INSERT INTO nfa_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Lodꞌo Noh mamuri dꞌai 601 (èna ngasu ca) tèu, lèke lodꞌo ka èci hèru èci, èi mèti aaꞌi le. Hèia Noh bhoke jendela, ka na ladhe palème, nèdhi rai dhu mango le. ");
INSERT INTO nfa_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Dꞌai hèru ka dua, lodꞌo ka dua nguru pidhu, dedha-rai ne dhu mango meto le. ");
INSERT INTO nfa_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ka Ama Lamatua peka dènge Noh, ");
INSERT INTO nfa_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Aaꞌi-aaꞌi mi puru ka nèti dedha kapa èèna. ");
INSERT INTO nfa_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Papuru aaꞌi badha-manu sèra! Nuka: badha ani, badha hui, badha dhu rodꞌo, dènge manu-bhui aaꞌi-aaꞌi ra. Hudꞌi si, sèna ka ra bèba, papènu rai-haha ne.” ");
INSERT INTO nfa_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Èle èèna ka, Noh dènge dhèu èmu na, dènge ana-ana na, aa dènge dhèu èmu ana na sèra, aaꞌi-aaꞌi ra puru nèti dedha kapa èèna. Badha se, aaꞌi-aaꞌi ra, kalua ka madhutu anga ra èci-èci. ");
INSERT INTO nfa_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hèia Noh pudhi hadhu, tao mei korban hia LAMATUA. Nèti badha-badha dhu bisa raꞌa sèra, Noh nare ciꞌu-ciꞌu, ka na roro, tunu ètu dedha mei deo na, ho jꞌajꞌi mi tadha makasi mi LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ropa LAMATUA sangèdꞌu nare hèu gèmu korban deo na, dꞌara Na karejꞌe. Ka Na ngee na, “Nèti deo neꞌe ne, Jaꞌa huku heka rai-haha ne, lula bhabhelu-katubꞌa dhèu. Masi ka rèngu dhoka ngee bhabhelu di, Jaꞌa paꞌele iie heka ngaa-ngaa dhu mamuri, sèmi dhu Jaꞌa heka tao kore èèna. ");
INSERT INTO nfa_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Lodꞌo rai-haha ne era, hèru dènge tèu, kako madhutu atora. Sèmi: hèru sèla dènge hèru puu-gꞌètu, hèru pacuhi dènge hèru sagoro, hèru hadhu dènge hèru èjꞌi lai, mèu dènge mèda.” ");
INSERT INTO nfa_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Hèia Ama Lamatua pala-bagi berkat mi Noh dènge ana-ana na, peka na, “Miu matana paꞌae-ae, sèna ka papènu rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ladhe èèna na, badha hui, manu-bhui dènge iꞌa aaꞌi-aaꞌi ra madhaꞌu dènge miu. Miu ka dhu ator si. ");
INSERT INTO nfa_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Sisi badha aaꞌi-aaꞌi, miu bisa miꞌa, sèmi dhu miꞌa hua-hela, dènge rèu ana aajꞌu se. Aaꞌi-aaꞌi se, Jaꞌa hia miu. ");
INSERT INTO nfa_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Dhoka sisi dhu dènge raa era, miu madha mèu miꞌa, lula samanga badha ètu raa na. ");
INSERT INTO nfa_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Jaꞌa pajꞌajꞌi dhèu madhutu raropa Jaꞌa. Nèti èèna ka, baku pamadhe dhèu. Ladhe abhu dhèu, do badha, dhu pamadhe dhèu, na, pamadhe ne kahèi. Neꞌe, lii paredha nèti Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Miu se hudꞌi matana paꞌae-ae ku, sèna ka papènu hari rai-haha ne.” ");
INSERT INTO nfa_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ka Ama Lamatua tuhu hari lii padhai lii Na, ");
INSERT INTO nfa_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“De neꞌe ne, Jaꞌa pajaji dènge miu, toke dꞌai lai ana lai èpu. ");
INSERT INTO nfa_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Lii pajaji ne, lèke kahèi mi aaꞌi-aaꞌi dhu mamuri, sèmi: badha ani, badha hui, dènge manu-bhui. Peka ka laa, lèke aaꞌi-aaꞌi dhu kalua palere-lere dènge miu nèti dedha kapa. ");
INSERT INTO nfa_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Lii pajaji Jaꞌa sèmi neꞌe: Jaꞌa hia heka èi aae lala, ho pamadhe aaꞌi ngaa-ngaa dhu mamuri, aa dènge paꞌele iie rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Jaꞌa pasa saroo ètu dedha-liru, sèna ka jꞌajꞌi tadha pasanèdꞌe lii pajaji Jaꞌa dhu maꞌète boe dènge miu, dènge aaꞌi-aaꞌi dhu mamuri, aa dènge rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Ladhe abhu raꞌi-liru, ho saroo cèu, èèna na pasanèdꞌe Jaꞌa nèti lii pajaji èèna. Na peka na, èi aae paꞌele iie heka aaꞌi-aaꞌi dhu mamuri. Dènge jꞌara neꞌe ne ka, lii pajaji Jaꞌa dhu maꞌète boe, paꞌèki tèke le dènge miu, aa dènge aaꞌi-aaꞌi dhu mamuri.” ");
INSERT INTO nfa_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ana-ana Noh dhu puru nèti dedha kapa, Sem, Yafet dènge Ham (Ham èèna, ama Kanaꞌan). ");
INSERT INTO nfa_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Dhèu aaꞌi-aaꞌi ra ètu rai-haha ne, jꞌajꞌi nèti ana Noh dhèu tèlu sèra. ");
INSERT INTO nfa_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh èèna, dhèu sabꞌa oka-tedhe. Nèngu ka dhu uru jꞌara tao oka anggor. ");
INSERT INTO nfa_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ca tèka, na ninu èi anggor, ka na mahu titu kèna. Hèia na puru eele mèdha-papake nèti ua na. Ka na jꞌunu lega-loli dènge boe mèdha-papake ètu dꞌara paleo na. ");
INSERT INTO nfa_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ropa Ham ladhe nèdhi era makae ama na, ka rai liꞌu laꞌe, lolo dènge aꞌa na, Sem dènge Yafet. ");
INSERT INTO nfa_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Hèia dua ra rare sigꞌi-kalolo ca bèla, ka ra bhoke mema ètu kabela-kao ra. Ka dua ra kako kabodho lasi asa dꞌara paleo ama ra, sèna ka ra pahutu mi ngiꞌu na. Dènge sèmi èèna, rèdhi boe era makae ama ra. Èle èèna ka, ra kalua sa liꞌu. ");
INSERT INTO nfa_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ropa Noh maseꞌa, na neꞌa tatao nèti ana limuri na, Ham. ");
INSERT INTO nfa_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ka na peka, aku nèngu na, “He! Ama Kanaꞌan! Jaꞌa dhoo èu! Èu ne, èèna na jꞌajꞌi ènu nèti aꞌa mu si! ");
INSERT INTO nfa_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Koa-kio LAMATUA, lula Sem! Te ngaa Kanaꞌan jꞌajꞌi ènu Sem. ");
INSERT INTO nfa_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Hudꞌi laa, Ama Lamatua pataleo rai unu Yafet. Aa ana-èpu na mamuri mera-milu dènge ana-èpu Sem. Te ngaa hudꞌi Kanaꞌan jꞌajꞌi ènu Yafet.” ");
INSERT INTO nfa_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nèti èle èi aae lala, Noh mamuri era dꞌai 350 (tèlu ngasu lèmi nguru) tèu. ");
INSERT INTO nfa_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Umur Noh dꞌai 950 (ceo ngasu lèmi nguru) tèu, heka madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Èle èi aae, ka ana-ana Noh abhu ana-èpu. Nuka ana-èpu nèti Sem, Yafet, dènge Ham. ");
INSERT INTO nfa_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Ana-èpu Yafet, nuka: Gomer, Magog, Madai, Yawan, Tubal, Mesek dènge Tiras. Èci-èci ka dènge lii, suku, aa dènge rai ra. Ana-èpu Gomer, ka: Askenas, Rifat dènge Togarma. Ana-èpu Yawan, ka: Elisa, Tarsis, dhèu Kitim, dènge dhèu Dodanim dhu pea ètu sebhe dhasi. ");
INSERT INTO nfa_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ana-èpu Ham, ka: Kus, Misraim, Put, dènge Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ana-èpu Kus, ka: Seba, Hawila, Sabta, Raema dènge Sabteka. Ana-èpu Raema, ka: Syeba dènge Dedan. ");
INSERT INTO nfa_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ana mone Kus, ka, Nimrod. Nèngu ne, kapala musu dhu uru tèka, aa èra. ");
INSERT INTO nfa_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Aꞌèra na mai nèti LAMATUA, aa nèngu kahèi jꞌajꞌi dhèu dhu èra bia magèla badha. Nèti èèna ka, dhèu biasa peka na, “Sèna ka èu more dhèu dhu èra bia magèla badha, sèmi Nimrod, dhu abhu aꞌèra nèti LAMATUA.” ");
INSERT INTO nfa_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Era na, mulai uru nèti rae Babel, Erek Akad, toke Kalne. Rae se aaꞌi-aaꞌi ra, ètu rai Sinear. ");
INSERT INTO nfa_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nèti era sèra, na nare hari Asyur. Ka na patitu kota Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO nfa_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","dènge Resen, ètu talora aae Niniwe dènge Kala. Aaꞌi-aaꞌi sèra, kota-kota kapai hua. ");
INSERT INTO nfa_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ana-èpu Misraim, ka: dhèu Ludim, dhèu Ananim, dhèu Lehabim, dhèu Naftuhim, ");
INSERT INTO nfa_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","dhèu Patrusim, dhèu Kasluhim, dènge dhèu Kaftorim. Dhèu Kasluhim nuka bèi-baki nèti dhèu Pilistin. ");
INSERT INTO nfa_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ana uuru Kanaꞌan, nuka, Sidon. Kanaꞌan jꞌajꞌi bèi-baki nèti dhèu Het, ");
INSERT INTO nfa_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","dhèu Yebusi, dhèu Amori, dhèu Girgasi, ");
INSERT INTO nfa_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","dhèu Hiwi, dhèu Arki, dhèu Sini, ");
INSERT INTO nfa_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","dhèu Arwadi, dhèu Semari, dènge dhèu Hamati. Ana-èpu Kanaꞌan se, pea palème dꞌai era dhu kajꞌèu, ");
INSERT INTO nfa_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","toke too rai rèngu mulai nèti Sidon taruu asa Gerar, dꞌai Gasa. Nèti èèna, laꞌe dꞌai Sodom, Gomora, Adma dènge Seboim, dꞌai kota Lasa. ");
INSERT INTO nfa_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Rèngu aaꞌi-aaꞌi sèra, ana-èpu Ham. Èci-èci dènge lii, suku, aa dènge rai ra. ");
INSERT INTO nfa_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, aꞌa Yafet, nèngu ka jꞌajꞌi bèi-baki dhèu Eber. ");
INSERT INTO nfa_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ana-èpu Sem, ka: Elam, Asyur, Arpaksad, Lud dènge Aram. ");
INSERT INTO nfa_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ana-èpu Aram ka: dhèu Us, dhèu Hul, dhèu Geter, dènge dhèu Mas. ");
INSERT INTO nfa_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ana Arpaksad ka, Sela. Ana Sela ka, Eber. ");
INSERT INTO nfa_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ana Eber, mone dhèu dua. Ana uuru, ngara na Pelek (dhu sasoa na ‘palème era’), lula taa èèna dhèu pea palème ètu rai-haha ne. Ngara ari na, Yoktan. ");
INSERT INTO nfa_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ana-èpu Yoktan, ka: Almodad, Selef, Hasar-Mawet, Yera, ");
INSERT INTO nfa_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO nfa_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO nfa_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, dènge Yobab. Rèngu aaꞌi-aaꞌi se, ana-èpu Yoktan. ");
INSERT INTO nfa_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Era pea rèngu, mulai nèti Mesa, taruu dꞌai Sefar, nuka era dhu kabhuku re sebhe dhimu. ");
INSERT INTO nfa_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Rèngu aaꞌi-aaꞌi se, ana-èpu Sem. Èci-èci ka dènge lii, suku, aa dènge rai ra. ");
INSERT INTO nfa_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aaꞌi-aaꞌi se, ana-èpu Noh, èci-èci ka dènge suku ra. Ropa èi aae lala èle, rèngu seꞌe ka pea papènu lème rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Uru-uru tèka na, dhèu ètu rai-haha ne, dhoka lii èci di. ");
INSERT INTO nfa_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lodꞌo rèngu cahagꞌe lasi asa ca bèka dhimu, ra dꞌai era mera ètu Sinear, ka ra pea ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Rèngu aaꞌi-aaꞌi rare lii èci, aku rèngu na, “Aꞌari, ee! Mai ta patitu kota kapai aae cue. Ti tao hadhu bata; ti tunu paꞌadhu. Èèna na, èdhi pudhi sa dedha, ho ti tape dènge èi dama. Ho èèna na, ti patitu manara dedha aae èci, dhu kolo nèngu na dꞌai dedha-liru, sèna ka èdhi abhu kolongara kapai. Ho sèna ka èdhi jꞌajꞌi ca kabarai aae, dhu pahagꞌa ia ka.” ");
INSERT INTO nfa_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Hèia LAMATUA puru mai laladhe kota dènge manara dhu ra patitu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ka Na peka na, “Dhèu rai-haha se, aaꞌi-aaꞌi ra ca kabarai, dènge lii èci di. Ngaa dhu rèngu tao ne, heka mulai kèna. Bèli-camèdꞌa ladhe rèngu aaꞌi-aaꞌi ra jꞌajꞌi mi èci sèmi neꞌe, èèna na, ngaa dhu rèngu neo tao, jꞌajꞌi aaꞌi mèu-mèu. ");
INSERT INTO nfa_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","De beꞌa risi, Èdhi puru lati ho tao lii si baka-leo, ho sèna ka èci neꞌa boe lii èci.” ");
INSERT INTO nfa_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Hèia Lamatua puru, ka kakeho lii ra. Dènge jꞌara sèmi èèna, Na pacèri si palème rai-haha ne. Ka ra pakèdꞌi taruu heka kota deo na. ");
INSERT INTO nfa_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nèti èèna ka, ra pangare kota na, Babel (dhu sasoa na ‘pabꞌingu’), lula LAMATUA kakeho lii ra, aa pacèri eele si palème rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seꞌe se, ana-èpu Sem. Ropa èle èi aae lala dua tèu sa, Sem mamuri cangasu tèu kèna, ka na abhu ana mone ca dhèu, ngara na Arpaksad. ");
INSERT INTO nfa_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ka Sem mamuri hari dꞌai 500 (lèmi ngasu) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Lodꞌo umur Arpaksad dꞌai 35 (tèlu nguru lèmi) tèu, na abhu ana mone ca dhèu, ngara na Sela. ");
INSERT INTO nfa_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ka Arpaksad mamuri hari dꞌai 403 (èpa ngasu tèlu) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Lodꞌo umur Sela dꞌai 30 (tèlu nguru) tèu, na abhu ana mone ca dhèu, ngara na Eber. ");
INSERT INTO nfa_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ka Sela mamuri hari dꞌai 403 (èpa ngasu tèlu) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Lodꞌo umur Eber dꞌai 34 (tèlu nguru èpa) tèu, na abhu ana mone ca dhèu, ngara na Pelek. ");
INSERT INTO nfa_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ka Eber mamuri era dꞌai 430 (èpa ngasu tèlu nguru) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Lodꞌo umur Pelek dꞌai 30 (tèlu nguru) tèu, na matana ana mone ca dhèu, ngara na Rehu. ");
INSERT INTO nfa_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ka Pelek mamuri era dꞌai 209 (dua ngasu ceo) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Lodꞌo umur Rehu dꞌai 32 (tèlu nguru dua) tèu, na abhu ana mone èci, ngara na Seruk. ");
INSERT INTO nfa_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ka Rehu mamuri era dꞌai 207 (dua ngasu pidhu) tèu, na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Lodꞌo umur Seruk dꞌai 30 (tèlu nguru) tèu, na matana ana mone ca dhèu, ngara na Nahor. ");
INSERT INTO nfa_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ka Seruk mamuri era dꞌai 200 (dua ngasu) tèu, ka na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Lodꞌo umur Nahor dꞌai 29 (dua nguru ceo) tèu, na abhu ana mone èci, ngara na Tera. ");
INSERT INTO nfa_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ka Nahor mamuri era dꞌai 119 (cangasu canguru ceo) tèu, ka na abhu hari ana mone dènge ana bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Lodꞌo umur Tera dꞌai pidhu nguru tèu risi, na abhu ana mone, dhèu tèlu: Abram, Nahor, dènge Haran. ");
INSERT INTO nfa_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ana-èpu Tera, sèmi neꞌe: ana mone na, ka: Abram, Nahor, dènge Haran. Haran abhu ana mone ca dhèu, ngara na Lot. ");
INSERT INTO nfa_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran madhe ètu rae èta-èsu na, ngara na Ur, rai dhèu Kasdim. Lodꞌo èèna, ama na Tera mamuri era. ");
INSERT INTO nfa_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram madhèdi dènge Sarai. Nahor leo dènge ana bhèni Haran, ngara na Milka. Haran abhu ana mone èci kahèi, ngara na Yiska. ");
INSERT INTO nfa_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Te ngaa Sarai dènge boe ana. ");
INSERT INTO nfa_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ca tèka, Tera nèti ana na Abram, dènge Sarai dhèu èmu Abram, dènge èpu na Lot, lasi tèke eele rae Ur, neo lasi asa rai Kanaꞌan. Te ngaa lasi dꞌai rae Haran, rèngu pea ka ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera madhe ètu èèna, dènge umur na 205 (dua ngasu lèmi) tèu. ");
INSERT INTO nfa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Lodꞌo èèna, LAMATUA peka le dènge Abram, peka na, “Abram! Èu pakèdꞌi nèti era èu ne, tèke eele ina-ama èu, èmu ina-ama mu, dènge rae-lesa èu. Lamu asa era èci, dhu pe Jaꞌa peka dènge èu. ");
INSERT INTO nfa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Èèna na, Jaꞌa hia mèngi-nale mi èu. Aa ana-èpu èu, èèna na, bèba-kacanga, jꞌajꞌi suku dhu kapai, toke dhèu tadhe kolongara èu. Ho bèli-camèdꞌa, èu jꞌajꞌi berkat hia dhèu leo kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Èèna na, Jaꞌa hia berkat mi dhèu dhu hia berkat mi èu. Te ngaa Jaꞌa huku dhèu cee dhu dhoo èu. Nanene paie! Pe èèna na, dhèu aaꞌi-aaꞌi ètu rai-haha ne abhu berkat lula èu.” ");
INSERT INTO nfa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Lodꞌo èèna, umur Abram 75 (pidhu nguru lèmi) tèu. Na nèti dhèu èmu na Sarai, aa dènge ana ari na, Lot, dènge mèdha-panyau ra aaꞌi-aaꞌi, aa dènge dhèu sabꞌa na aaꞌi-aaꞌi dhu na abhu ètu kota Haran. Hèia Abram si lasi ka, tèke eele kota Haran, asa era dhu LAMATUA peka le dènge ne. Ka ra kako taruu, dꞌai rai èci, ngara na Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Dꞌai era èèna, Abram kako palème rai ne, toke dꞌai padètu dènge rae èci, ngara na Sikem. Ka ra pea taha ètu èèna, padètu dènge ajꞌu aae ca kapua ètu More. Lodꞌo èèna, dhèu Kanaꞌan dhu pea ètu èèna era. ");
INSERT INTO nfa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ètu era èèna ka, LAMATUA padꞌelo iisi Na mi Abram, peka na, “Èèna na, Jaꞌa hia ana-èpu èu rai neꞌe ne.” Ka Abram pudhi hadhu tao mei korban hia LAMATUA dhu padꞌelo iisi Na dènge nèngu ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Èle èèna ka, Abram si pidha hari asa ledhe re balèu. Ka ra pea taha ètu talora rae Betel dènge rae Ai. Ètu èèna, na patitu mei korban èci ho na mangajꞌi mi LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Èle èèna ka, na pidha-pidha era, dꞌai rai Negeb re ca bèka balèu nèti rai Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ca tèka, rai Kanaꞌan lèke manganga aae. Nèti èèna ka, Abram si lasi asa bèka balèu, ka ra dꞌai rai Masir. Ka ra manubha taha ètu nèi. ");
INSERT INTO nfa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ropa oe dꞌai Masir, Abram peka dènge dhèu èmu na, Sarai, aku nèngu na, “Sarai, èu bhèni iia, nia boe. ");
INSERT INTO nfa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","De ladhe dhèu Masir rèdhi èu bhèni iia sèmi neꞌe, mage dhoka ra pamadhe jaꞌa, lula jaꞌa dhèu èmu-kamali èu. Dènge sèmi èèna, ra parame rare èu. ");
INSERT INTO nfa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","De beꞌa risi, èu peka dènge ra, na jaꞌa ne, ana mone èu. Dènge sèmi èèna ka, rèngu pamadhe boe jaꞌa, aa ra beꞌa-beꞌa dènge jaꞌa, lula èu ne.” ");
INSERT INTO nfa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ropa Abram si dꞌai Masir, dhèu ètu èèna, ladhe laa na, Sarai ne bhèni iia titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ropa dhèu sabꞌa dhèu aae sèra ladhe rèdhi ne, aa ra koa bhabhèni iia na ètu madha dhèu aae. Ka rèti bhèni ne, asa èmu dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Hèia dhèu aae beꞌa-beꞌa ka dènge Abram, lula Sarai. Ka na parasee Abram mèdha rupa-rupa. Nuka badha sèmi: kahibꞌi-kalèbho, kahibꞌi-kaꞌia, sapi, keledꞌei, dènge onta. Na parasee kahèi, ènu dhèu mone dènge dhèu bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Lula na nare dhèu èmu dhèu asa dꞌara èmu na, nèti èèna ka, LAMATUA hia huku rupa-rupa mi dhèu aae dènge isi èmu na. ");
INSERT INTO nfa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Hèia dhèu aae Masir paroa Abram, ka na karèi ne, aku nèngu na, “Èu ne tao tasamia mi jaꞌa ne? Nga tao ka èu peka boe na, bhèni ne dhèu èmu èu? ");
INSERT INTO nfa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Te ngaa aku èu na, nèngu ne ana hèni èu! Nèti èèna ka, jaꞌa oe kore ne jꞌajꞌi dhèu èmu jaꞌa! Dhèu èmu èu ka neꞌe! More hari ka, aa pakajꞌèu ka nèti madha jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Hèia dhèu aae paredha dhèu sabꞌa na sèra, babège eele Abram, dhèu èmu na, rèti dènge dhèu aa mèdha-panyau aaꞌi-aaꞌi ra, kalua nèti rai èèna. ");
INSERT INTO nfa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ka Abram si tèke eele Masir, lasi asa rai Negeb. Laꞌe dènge dhèu èmu na, aa dènge dhèu aa mèdha-panyau aaꞌi-aaꞌi ra. Ana ari na Lot madhutu ra kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram èèna, kaja ae titu kèna. Badha-manu na, mèdha hualaa dènge mèdha hualaa-pudhi na, ae titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nèti Negeb, ra pidha-pidha era, ka dꞌai hari talora rae Betel dènge rae Ai. Dhu uru èèna, ra pea rèdhi le ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Aa dhu Abram patitu le kahèi mei korban, ho na mangajꞌi mi LAMATUA ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot dhu madhutu Abram èèna, unu badha-manu dènge dhèu sabꞌa ae kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Te ngaa era èèna taleo boe, ho Abram dènge Lot aa dènge kakaja ra bisa pea paꞌèci. Nèti èèna ka, ana madhenge badha Abram dènge Lot sèra jꞌajꞌi patao-palaha, lula jꞌuꞌu ètu era èèna dꞌai boe hia badha rèngu. (Lodꞌo èèna, dhèu Kanaꞌan dènge dhèu Feris, dhu pea ètu èèna era.) ");
INSERT INTO nfa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ka Abram peka dènge Lot, aku nèngu na, “Èdhi se, paꞌaꞌari. Mage dhoka èdhi, èci dènge èci beꞌa boe, lula dhèu sabꞌa èdhi se patao-palaha taruu. ");
INSERT INTO nfa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","De hua iia dua ti pahagꞌa ka laa. Rai ne, taleo. De ladhe èu dꞌèi rai ca bèka kariu na, jaꞌa abhu re ca bèka gꞌana. Te ngaa ladhe èu dꞌèi re ca bèka gꞌana, na jaꞌa re ca bèka kariu.” ");
INSERT INTO nfa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Hèia Lot ladhe palème. Ka na ladhe nèdhi rai taleo ètu sebhe loko Yarden dhu madha èi ae, toke dꞌai rae Soar. Era ne, rai hèu mèngi sama sèmi oka LAMATUA, dènge rai Masir kahèi. (Lodꞌo èèna, LAMATUA dhae huku mèka kota Sodom dènge kota Gomora. De rai èèna, beꞌa era.) ");
INSERT INTO nfa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hèia Lot pili nare era sebhe loko Yarden èèna. Ka dua ra pahagꞌe ka. De Lot laꞌe sa ca bèka dhimu. ");
INSERT INTO nfa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Te ngaa Abram pea taruu ètu rai Kanaꞌan. Aa Lot laꞌe pea ètu rae-rae dhu padètu dènge kota Sodom ètu sebhe loko Yarden. ");
INSERT INTO nfa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Te ngaa dhèu-dhèu Sodom sèra bhelu-katubꞌa titu kèna. Rèngu roꞌo boe nanene LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ropa Lot pacèri dènge Abram, ka LAMATUA padhai lii dènge Abram, peka na, “Èu ladhe palème aaꞌi ku, rai aaꞌi-aaꞌi nèti era titu èu èèna. Ladhe paie re madha, re kabodho, re ca bèka gꞌana, dènge ca bèka kariu mu. ");
INSERT INTO nfa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Rai aaꞌi-aaꞌi dhu èu ladhe mèdhi sèi, bèli-camèdꞌa Jaꞌa hia mi èu, dènge ana-èpu èu, sèna ka jꞌajꞌi pusaka ra, toke dꞌai mia-mia. ");
INSERT INTO nfa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Èèna na Jaꞌa pajꞌajꞌi ana-èpu èu ae sama sèmi salae dhasi, toke dhèu ige rare boe. ");
INSERT INTO nfa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","De lamu kako palème madhutu madhera dènge bhabhèla na. Te rai se aaꞌi-aaꞌi ra, Jaꞌa hia mi èu.” ");
INSERT INTO nfa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Hèia Abram si lèpa hari asa era pea ra, dhu dètu dènge ajꞌu-ajꞌu aae ètu Mamre, dhu padètu dènge Hebron. Èle èèna ka, na pudhi hadhu tao mei korban ho na mangajꞌi LAMATUA ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Tèu èèna, dhèu aae èpa dhu paꞌèci. Rèngu se ka: Amrafel, dhèu aae rai Sinear. Ariok, dhèu aae rai Elasar, Kedarlaomer, dhèu aae rai Elam. Dènge Tideal, dhèu aae rai Goyim. ");
INSERT INTO nfa_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Lodꞌo èèna, dhèu aae leo dhèu lèmi, paꞌèci kahèi. Nuka: Bera, dhèu aae rai Sodom. Birsa, dhèu aae rai Gomora. Sinab, dhèu aae rai Adema. Semeber, dhèu aae rai Seboim. Dènge Bela, dhèu aae rai Soar. Ka èpa dhèu aae se, lasi pamusu dènge lèmi dhèu aae sèra. ");
INSERT INTO nfa_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Dhèu aae, dhèu lèmi sèra pakaboko dènge sordadꞌu ra, ètu dꞌara mamoo Sidim, (dhu limuri ne, ngara na Dhasi Madhe). ");
INSERT INTO nfa_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Jꞌajꞌajꞌi pamusu na, sèmi neꞌe ka: Uru èèna, dhèu aae, dhèu lèmi se dhu taꞌalo mi dhèu aae Kedarlaomer, canguru dua tèu kèna. Te dꞌai tèu ka canguru tèlu, ka rèngu aaꞌi-aaꞌi ra labꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ka maso tèu ka canguru èpa, Kedarlaomer dènge angalai na dhèu aae dhèu tèlu sera, mai dènge sordadꞌu ra. Hèia ra pamusu ka, ka ra segi pèri-pèri rai. Nuka: dhèu Refaim ètu rai Asterot-Karnaim; dhèu Susim ètu rai Ham; dhèu Emim ètu rai Sawe-Kiryataim, ");
INSERT INTO nfa_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","dènge dhèu Hori dhu ètu ledhe Seir, dꞌai sebhe mamoo El Paran. ");
INSERT INTO nfa_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Èle èèna ka, ra lèpa hari asa En Mispat (dhu limuri ne ngara na Kades). Ka ra segi rai dhèu Amalek, dènge dhèu Amori dhu pea ètu rae Haseson-Tamar. ");
INSERT INTO nfa_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Hèia, lèmi dhèu aae se ator sordadꞌu ra ètu dꞌara mamoo Sidim, ka lasi pamusu dènge dhèu aae dhèu èpa sèra. ");
INSERT INTO nfa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ètu dꞌara mamoo èèna, dhu abhu mananga èi dama pèri-pèri. Ropa ra pamusu, dhèu aae Sodom dènge dhèu aae Gomora dènge sordadꞌu ra, rai. Ka cahagꞌe manahu asa dꞌara mananga èi dama se. Aa cahagꞌe hari rai asa ledhe lasi. ");
INSERT INTO nfa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ka èpa dhèu aae dhu segi se, lasi parame rèti mèdha-panyau dènge ngangaꞌa-nginu nèti Sodom dènge Gomora. Èèna ka, ra lèpa dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Te ngaa Lot, ana ari Abram, dhu pea ètu Sodom. Ka èpa dhèu aae sèra, ère rèti Lot si, dènge mèdha-panyau ra aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Te ngaa dhèu èci rai nèti era èèna. Ka laꞌe lolo dènge Abram, dhèu Ibrani èèna. (Lodꞌo èèna, dhèu Amori èci, ngara na Mamre. Aa Abram pea dètu dènge ajꞌu-ajꞌu aae unu Mamre. Aꞌari Mamre dhèu dua, ngara na Eskol dènge Aner. Rèngu se dhu paꞌanga dènge Abram.) ");
INSERT INTO nfa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ropa Abram tadèngi na dhèu kèpe rèti le Lot, ana ari na, ka Abram pakaboko nare dhèu-dhèu sabꞌa na dhu reꞌa pamusu. Aaꞌi-aaꞌi ra 318 (tèlu ngasu canguru aru) dhèu. Ka lasi magèla èpa dhèu aae sèra, asa badae aae lasi dꞌai rae Dan. ");
INSERT INTO nfa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ètu era èèna, Abram hagꞌe dhèu na sèra, mi pèri-pèri kaboko. Dꞌara mèda èèna kahèi, lasi age si, dènge jꞌara paꞌoke. Ka Abram si lasi bate dhèu se dꞌai rae Hoba, ètu bèka badae kota Damsik. ");
INSERT INTO nfa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hèia Abram abhu hari Lot, dènge dhèu-dhèu nèngu, aa dènge mèdha-panyau ra aaꞌi-aaꞌi. Na abhu kahèi dhèu-dhèu leo. ");
INSERT INTO nfa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ropa Abram segi nare dhèu aae èpa sèra, ka na lèpa. Hèia dhèu aae Sodom mai soru ne ètu dꞌara mamoo Sawe (dhu dhèu biasa peka na, Mamoo Dhèu Aae). ");
INSERT INTO nfa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Tèu èèna, Melkisedek, jꞌajꞌi dhèu aae kota Salem. Aa nèngu ne jꞌajꞌi kahèi ama agama nèti Ama Lamatua dhu Dedha Risi Eele. Na mai soru Abram, nèti roti dènge èi hua anggor. ");
INSERT INTO nfa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Ka na padhai lii ho hia berkat mi Abram, aku nèngu na, “Jaꞌa sanao sèna ka Ama Lamatua, dhu Dedha Risi Eele èèna, dhu pajꞌajꞌi dedha-liru dènge rai-haha ne, hia mèngi-nale mi dedha èu. Koa-kio Ama Lamatua dhu hia le èu segi musu.” Èle èèna ka, Abram bagi hia Melkisedek ca pala nèti canguru pala mèdha-panyau dhu na abhu hari sèra. ");
INSERT INTO nfa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Hèia dhèu aae Sodom èèna pahaha iisi na mi Abram, peka na, “Ama. Mèdha-panyau dhu èu abhu hari nèti musu jaꞌa sèra, hudꞌi laa ama ku abhu aaꞌi si. Te ngaa dhu jaꞌa manèngi hari, dhoka dhèu-dhèu jaꞌa sèra.” ");
INSERT INTO nfa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Hèia Abram bꞌala ne, peka na, “Jaꞌa subha ètu madha Ama Lamatua dhu Dedha Risi Eele, dhu tao dedha-liru dènge rai-haha, ");
INSERT INTO nfa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","na, jaꞌa kore boe mèdha-panyau èu, masi ka ciki èèna ka. Masi ka loa hèngu caꞌèta sa, jaꞌa kore boe. Dènge jꞌara sèmi neꞌe, èu baku peka na, ‘Kakaja Abram sèra mai nèti jaꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Jaꞌa parluu boe ngaa-ngaa. Dhoka mia dhu dhèu jaꞌa se pake le, sèra èle le, ale ia ka. Aa hudꞌi laa, angalai jaꞌa dhèu tèlu se: Aner, Eskol dènge Mamre, hagꞌe rare unu rèngu di.” ");
INSERT INTO nfa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Èle èèna ka, LAMATUA padꞌelo iisi Na mi Abram. Ka Na peka, aku Nèngu na, “Abram! Èu baku madhaꞌu. Lula Jaꞌa ka dhu jꞌajꞌi mi tami ho bhiri èu nèti musu. Aa Jaꞌa hia aꞌoto mi dedha èu.” ");
INSERT INTO nfa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Te ngaa, aku Abram na, “Masi ka Ama Lamatua hia ae-ae èèna ka, jꞌajꞌi boe mi ngaa sa èci. Lula jaꞌa ne dènge boe ana matana, ho hia jaꞌa ana-èpu. De dhu neo unu ae-ae sèmi èèna, tao mi ngaa? Neu-neu ka, noto mi ènu jaꞌa Elieser, dhèu Damsik èèna. Nèngu ka dhu sèmi nare aaꞌi-aaꞌi.” ");
INSERT INTO nfa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Te ngaa LAMATUA dhaa na, “Jꞌara na sèmi boe èèna! Ana dꞌèlu èu ku, dhu unu pusaka sèra. Ènu èu abhu boe.” ");
INSERT INTO nfa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Hèia nèti Abram asa liꞌu, ka Na peka, “Èu ladhe ku asa dedha-liru nèi. Ladhe paie ku hua-hètu sèi. Bisa iga more, do aadꞌo? Bèli-camèdꞌa, ana-èpu èu sama sèmi hua-hètu sèi!” ");
INSERT INTO nfa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ka Abram sèmi nare lii padhai LAMATUA. Aa LAMATUA tadhe ne, dhèu mola, lula Abram lèka Ne. ");
INSERT INTO nfa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Èle èèna ka, LAMATUA tuhu hari lii Na, “Jaꞌa ne, Ama Lamatua. Jaꞌa ka dhu lere kèti èu nèti rae Ur, ètu rai dhèu Kasdim sèra. Aa rai neꞌe ne, Jaꞌa hia èu, sèna ka jꞌajꞌi pusaka mu.” ");
INSERT INTO nfa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Te ngaa Abram karèi, aku nèngu na, “Tasamia, LAMATUA? Dènge jꞌara sa mia ka ho jaꞌa keꞌa na, rai ne jꞌajꞌi pusaka jaꞌa?” ");
INSERT INTO nfa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ka Na dhaa, peka na, “Sèmi neꞌe! Mai ti tao madha jꞌara èci, dhu paꞌèki lii padhai lii Jaꞌa deo na. De lamu more sapi rena ciꞌu, kahibꞌi rena ciꞌu, dènge kahibꞌi-kalèbho mone ciꞌu. Aaꞌi-aaꞌi sèra hudꞌi dhu umur tèlu tèu. Aa mèti kahèi koro iia ciꞌu, dènge koro jꞌaha ciꞌu.” ");
INSERT INTO nfa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ka Abram laꞌe nare badha sèra. Hèia na kacèbꞌe bagi mi dua, sapi, kahibꞌi, dènge kahibꞌi-kalèbho sèra. Ka na pale sisi se mi rai, dhu èci patangara dènge èci, jꞌajꞌi mi dua bꞌaris. Te ngaa na kacèbꞌe boe manu-bhui sèra. ");
INSERT INTO nfa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ka manu-bhui dhu tema raꞌa sisi sèra, mai ho neo raꞌa sisi seꞌe. Te ngaa Abram bhabhoo eele si. ");
INSERT INTO nfa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ropa lodꞌo cèna, Abram bhèjꞌi luu. Na nii, kuri na maroga mai sarimu nare nèngu, ka na madhaꞌu titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Ka Ama Lamatua peka dènge ne, “Abram! Èèna na èu mamuri toke heka bhoro, aa madhe dènge beꞌa, ka ra padhane èu dènge beꞌa. Te ngaa ana-èpu èu, èèna na jꞌajꞌi dhèu tao mai ètu kabarai dhèu. Ho èèna na, dhèu isi rai sèra, tao si sèmi ènu sa, ka ra ènyi aa pajꞌèra si, toke èpa ngasu tèu. Te, ladhe èèna na, Jaꞌa huku si. Ho èèna na, Jaꞌa kèti hari ana-èpu èu nèti era èèna, aa dènge mèdha-panyau ra ae-ae. ");
INSERT INTO nfa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Aa èèna na, Jaꞌa ator ho ana-èpu èu dhu ka lèmi kèti hari si asa neꞌe mai. Limuri ne, dhèu Amori dhu pea ètu rai neꞌe. Dhèu seꞌe dhèu bhelu, te ngaa dhae bhelu iia mèka. Ladhe ana-èpu èu sèra lèpa hari asa era neꞌe, Jaꞌa neo pake si ho huku palaho dhèu Amori sèra. Lula dꞌai taa èèna, bhabhelu ra asa hino.” ");
INSERT INTO nfa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ropa dꞌai mèda sa, cagꞌagꞌa laa ètu era èèna, abhu èru rai èci dhu sèbꞌu poka-poka, dènge badhu ai èci dhu heo, kako re sasanga sisi dua baris se. ");
INSERT INTO nfa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Lodꞌo èèna, LAMATUA paꞌèki lii pajaji dènge Abram. Na peka na, “Jaꞌa jaji mema èu kèna, bèli-camèdꞌa Jaꞌa pangèdꞌu mi ana-èpu èu rai neꞌe ne, mulai nèti loko Masir, dꞌai loko Efrat, ");
INSERT INTO nfa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","dènge rai dhèu Keni, dhèu Kenas, dhèu Kadmon, ");
INSERT INTO nfa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","dhèu Het, dhèu Feris, dhèu Refaim, ");
INSERT INTO nfa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","dhèu Amori, dhèu Kanaꞌan, dhèu Girgasi, dènge dhèu Yebus.” ");
INSERT INTO nfa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Tèu èèna, Abram lèpa hari le nèti Masir, ka na pea le canguru tèu ètu Kanaꞌan. Dhèu èmu na Sarai abhu mèka kolo. Sarai dènge ènu bhèni ca dhèu nèti Masir, ngara na Hagar. Ca lodꞌo, Sarai peka dènge Abram, aku nèngu na, “Aꞌa. LAMATUA hia boe jaꞌa ana. De hua iia, lamu jꞌunu dènge ènu jaꞌa, Hagar, sèna ka na hia jaꞌa ana.” Ka Abram madhutu lii dhèu èmu na. Ka Sarai hia Hagar jꞌajꞌi dhèu èmu ka dua Abram. ");
INSERT INTO nfa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Hèia Abram jꞌunu dènge Hagar, ka na dènge babia. Ropa Hagar neꞌa nèngu dènge babia le, ka na padedha iisi na, aa na pahae heka Sarai. ");
INSERT INTO nfa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ka Sarai peka dènge Abram, aku nèngu na, “Jaꞌa ka dhu hia nèngu mi èu jꞌajꞌi dhèu èmu ka dua. Te ngaa ropa na dènge babia, na pusi pahae heka jaꞌa! Neꞌe ne, sala èu! De hudꞌi laa, sèna ka LAMATUA ka dhu pamaꞌète lii èdhi dua ti! Heka èu meꞌa kèna!” ");
INSERT INTO nfa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ka Abram dhaa, peka na, “Sèmi neꞌe, wee! Èu ne, dhèu èmu uru. Aa nèngu, dhèu èmu limuri. De èu ne dhu mèdꞌu paredha. De èu neo tao ne tasamia, èèna ètu èu na!” Ka Sarai mulai tao sakaa hua dènge Hagar, hèia na rai. ");
INSERT INTO nfa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Na rai dꞌai dꞌara mamoo. Hèia ana pajuu LAMATUA nèti sorga ca dhèu, rage ne dètu dènge madha èi, ètu jꞌara laꞌe asa Sur. ");
INSERT INTO nfa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ka na lii, aku nèngu na, “Èu ne Hagar, ènu Sarai. Nga tao ka èu ètu neꞌe? Èu mai nèti mia, aa lamu mia?” Hèia Hagar dhaa, aku nèngu na, “Jaꞌa rai nèti dꞌara èmu lamatua jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ka ana pajuu èèna pamako ne, aku nèngu na, “Sèmi neꞌe! Beꞌa risi, èu lèpa hari asa adhe-aai Sarai, lamatua èu. Masi ka na tao èu tasamia èèna ka, sèmi la. ");
INSERT INTO nfa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Baku madhaꞌu. Bèli-camèdꞌa, Jaꞌa pabèba ana-èpu èu paꞌae-ae, toke dhèu ige rare boe. ");
INSERT INTO nfa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Èu dhu dènge babia. Nèbhu heka, èu mora iisi ana mone ca dhèu. Èèna na mu pangare ne Ismael (dhu sasoa na ‘Lamatua tadèngi’), lula LAMATUA tadèngi le lii roma iisi èu. ");
INSERT INTO nfa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ropa ana ne kapai, na mamuri pakajꞌèu nèti aꞌari na. Lula nèngu ne, sama sèmi jara hui dhu dꞌèi boe nanene lii paredha. Sadꞌi dhèu cee èèna ka, na sisu. Aa dhèu aaꞌi-aaꞌi labꞌa ne kahèi.” ");
INSERT INTO nfa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ropa tadèngi nare, Hagar ngee ka ètu dꞌara na, aku nèngu na, “Jaꞌa kèdhi le LAMATUA, dhu ladhe-leru aa madhenge jaꞌa.” Hèia na hia ngara mi Lamatua, “Lamatua dhu ladhe-leru jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nèti èèna ka, dhèu pangare madha èi na, Beer Lahai Roi, dhu sasoa na “Madha èi nèti Nèngu dhu mamuri, dhu ladhe-leru jaꞌa.” Era na, ètu talora aae nèti rae Kades dènge rae Beret. Madha èi ne, abhu era toke dꞌai sange neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Èle èèna ka, Hagar lèpa hari. Hèia nara iisi ana mone ca dhèu. Abram pangare ne Ismael. ");
INSERT INTO nfa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Lodꞌo Hagar nare iisi Ismael, umur Abram 86 (aru nguru èna) tèu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ropa umur Abram dꞌai 99 (ceo nguru ceo) tèu, LAMATUA mai padꞌelo iisi dènge ne. Ka Na peka dènge Abram, aku Nèngu na, “Jaꞌa ne, Ama Lamatua dhu Koasa Risi Eele. Èu hudꞌi madhutu taruu dadꞌèi Jaꞌa, dènge jꞌara mamuri èu hudꞌi mola. ");
INSERT INTO nfa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Jaꞌa neo paꞌèki lii pajaji dènge èu. Aa Jaꞌa neo pabèba kacanga ana-èpu èu.” ");
INSERT INTO nfa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Hèia Abram patitu kètu urutuu, ka na pacudꞌu kètu dꞌai rai. Ka Ama Lamatua tuhu hari lii padhai lii Na, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Lii pajaji Jaꞌa dènge èu sèmi neꞌe ka: èèna na, èu jꞌajꞌi bèi-baki nèti suku ae-ae. Nèti èèna ka, èu pake ia ka ngara èu Abram (dhu sasoa na ‘ama dhu dhèu tadhe’), te ngaa Abraham (dhu sasoa na ‘bèi-baki nèti suku ae-ae’). ");
INSERT INTO nfa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Jaꞌa neo pabèba kacanga ana-èpu èu ae-ae. Jaꞌa pajꞌajꞌi si suku ae-ae. Aa Jaꞌa dedꞌe dhèu aae ae nèti rèngu sèra. ");
INSERT INTO nfa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Jaꞌa sanèdꞌe taruu lii pajaji Jaꞌa dènge èu, aa dènge ana-èpu èu sèra. Lii pajaji ne maꞌète boe toke taa-taa, lula Jaꞌa neꞌe ka Ama Lamatua nèti èu dènge ana-èpu mu. ");
INSERT INTO nfa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Rai Kanaꞌan ne aaꞌi-aaꞌi, bèli-camèdꞌa Jaꞌa hia mi èu dènge ana-èpu èu. Neꞌe ne, èu dhoka pea manubha di ètu neꞌe. Te ngaa èèna na, jꞌajꞌi mi unu ana-èpu èu toke taa-taa. Aa Jaꞌa jꞌajꞌi Ama Lamatua rèngu sèra kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Te ngaa èu dènge ana-èpu èu sèra, hudꞌi kèpe paꞌèra lii pajaji ne, dènge dꞌara kateme ku. Dhèu mone aaꞌi-aaꞌi ra, hudꞌi suna ku. ");
INSERT INTO nfa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Neꞌe ne, mone aaꞌi-aaꞌi hudꞌi suna, mulai nèti umur aru lodꞌo. Aꞌari èu, dhèu-dhèu sabꞌa èu, dènge ènu dhu èu hèli more nèti rai leo, aaꞌi-aaꞌi ra hudꞌi suna si. Suna na jꞌajꞌi tadha mi ngiꞌu miu, dhu paꞌèki èdhi taa-taa. ");
INSERT INTO nfa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mone mia dhu suna boe, rèngu sèra maso boe ètu dꞌara lii pajaji Jaꞌa ne, aa rèngu sèra jꞌajꞌi boe dhèu Jaꞌa kahèi.” ");
INSERT INTO nfa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Èle èèna ka, Ama Lamatua peka hari, aku Nèngu na, “Nèti deo neꞌe ne, èu paroa ia ka ngara dhèu èmu mu Sarai, te ngaa Sara. ");
INSERT INTO nfa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Èèna na Jaꞌa hia mamèngi ae-ae mi Sara, sèna ka nara iisi hia èu, ana mone ca dhèu. Tareꞌa! Bèli-camèdꞌa, Sara jꞌajꞌi bèi nèti suku ae-ae. Aa èèna na, Jaꞌa dedꞌe dhèu aae ae-ae nèti ana-èpu nèngu.” ");
INSERT INTO nfa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Hèia Abraham patitu kètu urutuu ka pacudꞌu kètu dꞌai rai. Te ngaa na mari ètu dꞌara. Na pangee, na, “Mone heka bhora dhu cangasu tèu sama sèmi jaꞌa ne, bisa abhu ana era? Aa Sara dhu heka gagoo-gagehu ne, dhu ceo nguru tèu kèna, nara iisi hari sa mia?” ");
INSERT INTO nfa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ka na peka dènge Lamatua, aku nèngu na, “Hudꞌi ka laa, Ismael ka dhu abhu pusaka jaꞌa èèna ka, ngaa-ngaa tao boe.” ");
INSERT INTO nfa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Te ngaa aku Ama Lamatua na, “Aadꞌo sèmi èèna! Bèli-camèdꞌa, dhèu èmu mu Sara, nara iisi ana mone ca dhèu. Pangare ne Isak. Lii jaji Jaꞌa ne, lèke mi nèngu dènge ana-èpu na toke mia-mia. ");
INSERT INTO nfa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Jaꞌa tadèngi le ngaa dhu èu manèngi kahèi, hia Ismael. Nèti èèna ka, Jaꞌa hia berkat mi nèngu kahèi, aa hia ana-èpu na tabha ae. Bèli-camèdꞌa ana-èpu Ismael ne, jꞌajꞌi mi canguru dua kapala suku. Aa ana-èpu na suku èci dhu kapai. ");
INSERT INTO nfa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Masi ka sèmi èèna, lii pajaji Jaꞌa ne, lèke dhoka mi ana mu Isak di. Tèu mai ni, hèru sèmi neꞌe kahèi, Sara nara iisi le.” ");
INSERT INTO nfa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ropa padhai lii nare, ka Ama Lamatua tèke eele Abraham. ");
INSERT INTO nfa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Lodꞌo èèna kahèi, Abraham tao dènge ka, madhutu sèmi lii paredha Ama Lamatua. Ka na suna. Na suna ana na, Ismael, dènge dhèu mone aaꞌi-aaꞌi dhu pea dènge ne. Lodꞌo èèna, umur Abraham 99 (ceo nguru ceo) tèu le, aa Ismael 13 (canguru tèlu) tèu. ");
INSERT INTO nfa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ca tèka, Abraham pea padètu dènge ajꞌu aae canau ètu Mamre. LAMATUA mai padꞌelo iisi Na mi nèngu ètu era èèna. Lii lolo na sèmi neꞌe ka: lodꞌo èèna, sagoro ae titu kèna, ka Abraham madhèdi ètu hèbꞌa paleo na, sèna ka abhu ngèlu gꞌoro ciki. ");
INSERT INTO nfa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ropa Abraham boti kètu na, ladhe nèdhi dhèu tèlu dhu titu kajꞌèu boe nèti era èèna. Hèia na rai laꞌe soru nare si. Ropa na dꞌai madha si, na patitu kètu urutuu na, ");
INSERT INTO nfa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ka na peka, aku nèngu na, “Ama si. Mai dhuli ku ho minu èi ciki. ");
INSERT INTO nfa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ama si ae ciki mi mamaho neꞌe. Ho ana-ana iiki rèti èi, sèna ka rasa haga miu. ");
INSERT INTO nfa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Pe jaꞌa laku lalau ngangaꞌa-nginu ho ama si miꞌa ciki, sèna ka ako kadhii ciki, heka lami taruu kèna. Te jaꞌa karejꞌe bisa lalau ama si.” Ka ra dhaa, aku rèngu na, “Ooo. Jiꞌi dhuli.” ");
INSERT INTO nfa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Hèia Abraham pamèri sa dꞌara paleo, laꞌe peka dènge Sara, aku nèngu na, “Mèri! More tarigu dhu beꞌa risi, ca saku, ho tao roti!” ");
INSERT INTO nfa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ka rai laꞌe hari asa era sapi na, hèia kèpe ana sapi kabèbꞌu ciꞌu. Ka na pua dhèu sabꞌa na sa, pare. ");
INSERT INTO nfa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Hèia laꞌe nare susu, keju dènge sisi dhu heka nasu èèna, nèti hia tamu sèra raꞌa. Abraham titu taruu ètu mamaho ajꞌu, ho na lalau si. ");
INSERT INTO nfa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Hèia ra karèi ne, aku rèngu na, “Dhèu èmu mu Sara, ka mia?” Na dhaa, aku nèngu na, “Nuka dꞌara paleo èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ka ca dhèu nèti rèngu se padhai lii, aku nèngu na, “Pe dꞌai tèu mai nèi, Jaꞌa lèpa hari mai. Lodꞌo èèna, dhèu èmu èu Sara nare iisi le ana mone ca dhèu.” Ropa rèngu padhai lii èèna, Sara nanene nèti kabodho babèdho. ");
INSERT INTO nfa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Lodꞌo èèna, Abraham dènge Sara dhu heka bhoro le, ngaa hari Sara dhu abhu heka hèru. ");
INSERT INTO nfa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ropa Sara tadèngi padhue-padhai rèngu se, ka na mari kèmu. Na pangee na, “Jaꞌa dhu heka roto-roto sèmi neꞌe ne, aa dhèu èmu jaꞌa dhu roe nia heka. Tasamia jiꞌi bisa tao sèmi ana ngèru dhu leo-èmu hiu, ho abhu ana?” ");
INSERT INTO nfa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ka LAMATUA peka dènge Abraham, aku Nèngu na, “Nga tao ka Sara mari? Ele boe na ngee na, lii padhai Jaꞌa ne jꞌajꞌi boe, lula nèngu heka le. ");
INSERT INTO nfa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Jaꞌa ne, LAMATUA! Abhu boe ngaa èci sa dhu Jaꞌa bisa boe tao. Sanèdꞌe paie. Tèu mai, ladhe Jaꞌa lèpa hari mai, Sara dhu nara iisi le, ana mone ca dhèu.” ");
INSERT INTO nfa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ropa tadèngi lii èèna, Sara jꞌajꞌi madhaꞌu. Ka na pasili, aku nèngu na, “Jaꞌa mari boe, nga!” Te ngaa Lamatua bꞌala, na, “Deo na, èu mari, nga.” ");
INSERT INTO nfa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Èle ka, dhèu tèlu se pakèdꞌi neo lasi asa kota Sodom. Ka Abraham lere si dꞌai talora jꞌara. Nèti era èèna, ladhe rèdhi kota Sodom. ");
INSERT INTO nfa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ka LAMATUA ngee ètu dꞌara Na, “Hua iia Jaꞌa peka dènge Abraham, Jaꞌa neo palaho kota Sodom. ");
INSERT INTO nfa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Te ladhe èèna na, ana-èpu na asa tabha ae, aa suku dhu kapai. Aa nèngu ne, èèna na, jꞌajꞌi berkat mi suku aaꞌi-aaꞌi ètu rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Jaꞌa hagꞌe kore le nèngu, ho na nori ana-èpu na dènge dhèu leo, sèna ka madhutu taruu jꞌara LAMATUA, ho ra mamuri dènge mola. Ladhe rèngu mamuri sèmi èèna, Jaꞌa tao aaꞌi lii dhu Jaꞌa pajaji dènge Abraham.” ");
INSERT INTO nfa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Hèia LAMATUA peka dènge Abraham, aku Nèngu na, “Sèmi neꞌe! Jaꞌa tadèngi le, lii roma iisi dhèu ae, peka na, dhèu kota Sodom dènge Gomora bhabhelu ra seli-kolane. ");
INSERT INTO nfa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nèti èèna ka, Jaꞌa puru madha ku mai, sèna ka kèdhi unu ku, ngaa dhu Jaꞌa tadèngi sèra, tareꞌa, do aadꞌo. Ladhe aadꞌo, pe Jaꞌa keꞌa unu ku.” ");
INSERT INTO nfa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ropa LAMATUA padhai lii era dènge Abraham, dhèu dua se lasi taruu sa kota Sodom. ");
INSERT INTO nfa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Hèia Abraham laꞌe padètu dènge Lamatua, ka na pamako Na, peka na, “Tasamia? Ama neo pamadhe aaꞌi dhèu-dhèu beꞌa paꞌèci dènge dhèu-dhèu bhelu, do? ");
INSERT INTO nfa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ladhe abhu dhèu lèmi nguru dhu beꞌa ètu dꞌara kota èèna, Ama pamadhe si hèi? Do, Ama palaho heka kota sèra, lula rèngu seꞌe, do? ");
INSERT INTO nfa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ama baku tao sèmi èèna! Mage dhoka, dhèu beꞌa sèra madhe hèi, lula Ama neo pamadhe dhèu bhelu sèra. Ama ka dhu pamaꞌète lii ètu dedha-liru dènge rai-haha. De Ama ku unu Mu dhu meꞌa jꞌara èèna adil boe.” ");
INSERT INTO nfa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ka LAMATUA dhaa, peka na, “Ladhe abhu dhèu beꞌa lèmi nguru dhèu ètu kota Sodom, Jaꞌa huku boe kota èèna, lula rèngu.” ");
INSERT INTO nfa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Hèia Abraham padhai lii hari, aku nèngu na, “Ama, jaꞌa manèngi abho, lula jaꞌa neo padhai lii hari ciki. Jaꞌa ne dhoka dhèu goa di, dhu keꞌa boe ngaa-ngaa. ");
INSERT INTO nfa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Sèmi dꞌai boe dhèu lèmi nguru dhu beꞌa, te ngaa dhoka èpa nguru lèmi di, tasamia? Kura dhoka dhèu lèmi di, na Ama neo palaho eele kota èèna, do?” Ka Lamatua bꞌala, aku Nèngu na, “Ladhe Jaꞌa abhu dhèu beꞌa èpa nguru lèmi, Jaꞌa palaho boe kota èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ka Abraham pamako hari, na, “Sèmi abhu dhoka èpa nguru dhèu beꞌa di, tasamia, Ama?” Ka Na dhaa, “Ladhe Jaꞌa abhu èpa nguru dhèu beꞌa, Jaꞌa huku boe si.” ");
INSERT INTO nfa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham pamako hari, aku nèngu na, “Ama baku nasa. Te abhu dhoka tèlu nguru dhèu beꞌa di, na tasamia?” Hèia Na dhaa, “Ladhe Jaꞌa abhu tèlu nguru dhèu beꞌa, Jaꞌa huku boe si.” ");
INSERT INTO nfa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Hèia Abraham peka hari, “Ama mage nasa ladhe jaꞌa karèi hari ciki. Sèmi abhu dhoka dhèu dua nguru di dhu beꞌa, na tasamia?” Ka Na dhaa hari, aku Nèngu na, “Sèmi abhu dhèu dua nguru di dhu beꞌa, Jaꞌa palaho eele boe kota èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ka Abraham katange lii padhai na, aa na karèi, peka na, “Ama! Jaꞌa padhai lii hari ca tèka, te ngaa baku nasa dènge jaꞌa. Tasamia, ladhe abhu dhoka canguru dhèu di dhu beꞌa?” Hèia Na dhaa, “Ladhe Jaꞌa abhu canguru dhèu dhu beꞌa ètu era èèna, Jaꞌa palaho boe kota èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Padhai lii èle sèmi èèna, LAMATUA laꞌe dènge ka, aa Abraham lèpa kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ètu dꞌara Lamatua dhu padhue-padhai era dènge Abraham, ana pajuu Na dhèu dua, lasi le asa kota Sodom. Dꞌai nèi, lodꞌo oe cèna kèna. Ka Lot dhu madhèdi ètu hèbꞌa tedhe kota. Ropa nèdhi dhèu dua se, laꞌe soru nare si. Ka na patitu kètu urutuu, aa pacudꞌu kètu ètu madha ra. ");
INSERT INTO nfa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ka na padhai lii, aku nèngu na, “Mai lati dhuli ku èmu jaꞌa la. Sèna ka ama si rase haga, aa jꞌunu ètu èmu jaꞌa. Pe bèli madꞌae, heka ama si kako hari kèna.” Ra dhaa, aku rèngu na, “Makasi. Te ngaa repo ia ka. Hudꞌi laa jiꞌi jꞌunu ètu dꞌara lapa.” ");
INSERT INTO nfa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Te ngaa Lot pamako si loe boe, ka lasi manubha asa èmu na. Ka Lot si tunu roti, lalau mei, ka raꞌa-rinu paꞌèci. ");
INSERT INTO nfa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Dhu dua ra lasi mèka jꞌunu, cagꞌagꞌa laa, dhèu mone Sodom aaꞌi-aaꞌi, ana mone ngèru toke dꞌai mone heka, mai reo rare èmu Lot. ");
INSERT INTO nfa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Dhèu seꞌe paꞌoo-parodha, peka mi Lot, aku rèngu na, “He, Lot! Mone dua deo sa, ètu mia? Bhabhodho si mai, sèna ka jiꞌi jꞌunu dènge ra!” ");
INSERT INTO nfa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Hèia Lot liꞌu laꞌe, ka na bèdho hari èmu. ");
INSERT INTO nfa_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ka na lii, aku nèngu na, “Aꞌari, ee! Baku miu tao bhelu mi tamu jaꞌa se. ");
INSERT INTO nfa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mi nanene ku jaꞌa laa! Ana bhèni jaꞌa, dhèu dua. Dua ra dhu paꞌèci mèka dènge dhèu mone. Jaꞌa hia miu. Mere, ho mi tao tasamia èèna ka, sadꞌi madhutu dadꞌèi miu. Sadꞌi miu baku tao karehe mi tamu jaꞌa dhèu dua se. Lula madhutu adꞌa èdhi, jaꞌa ka dhu hudꞌi jꞌaga si.” ");
INSERT INTO nfa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Masi ka sèmi èèna, dhèu Sodom se paꞌoo maꞌète boe, aku rèngu na, “Èu ne, baku patabha! Te èu ne, dhèu tao mai ètu kabarai jiꞌi ne! De èu dènge boe hak ho kai jiꞌi. Hua iia, èu pakajꞌèu nèti era neꞌe. Te, ladhe lamu boe, jiꞌi tao èu bia risi nèti dhèu dua seꞌe!” Ka ra tule eele Lot, hèia aaꞌi-aaꞌi ra rai lasi jꞌèje babèdho èmu. ");
INSERT INTO nfa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Te ngaa dhèu dua se soro kacui-aai ra, ère pamaso Lot, ka ra patèke èmu nèti dꞌara. ");
INSERT INTO nfa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Dua ra tao pabèdhu ana madha dhèu Sodom aaꞌi-aaꞌi ra, ka rèdhi heka ngaa-ngaa. Ra gogo tenge babèdho, te ngaa abhu boe. ");
INSERT INTO nfa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Hèia tamu dhèu dua se, peka dènge Lot, aku rèngu na, “LAMATUA neꞌa le, bhabhelu-katubꞌa dhèu Sodom se. Nèti èèna ka, Na paleha jiꞌi dua mi mai, sèna ka palaho eele kota ne. De èu dhu dènge aꞌari leo dhu ètu dꞌara kota ne, do aadꞌo? Ladhe dènge ana mone, do ana bhèni, do dhèu èmu ana èu, do, sadꞌi cee èèna ka, lamu more si, ho rai ka nèti dꞌara kota ne lai-lai!” ");
INSERT INTO nfa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hèia Lot laꞌe paraga dènge ana mone dhèu dua, dhu lii dꞌai ana bhèni na. Ka na peka, “Dua mi nanene paie! Rai ka nèti dꞌara kota ne, te LAMATUA neo palaho eele ne!” Te ngaa ra pangee na, Lot padhai lii paleko di. ");
INSERT INTO nfa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bèli madꞌae aae era, ana pajuu Lamatua dhèu dua se, pakaseti Lot si, ho lasi karohe asa era kajꞌèu. Ra peka na, “Lami ka! Ère mèti dhèu èmu mu, dènge ana bhèni èu dhèu dua sèra, ho rai ka. Tèke eele kota neꞌe! Mage dhoka miu madhe aaꞌi palere-lere dènge kota ne.” ");
INSERT INTO nfa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Te ngaa Lot neka-neka era, masi ka LAMATUA neo hia ne mamuri. Nèti èèna ka, tamu dhèu dua se nuni Lot, dhèu èmu na, dènge ana bhèni dhèu dua sèra, rèti asa liꞌu kota. ");
INSERT INTO nfa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Hèia ca dhèu nèti tamu dhèu dua sèra paredha si, peka na, “Rai palasa, sèna ka abhu sodꞌa! Mage mi kabibꞌa kabodho! Baku ae ètu dꞌara mamoo! Rai taruu, asa ledhe nèi, sèna ka miu baku madhe!” ");
INSERT INTO nfa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Te ngaa Lot peka, aku nèngu na, “Iraa ee! Baku sèmi èèna! ");
INSERT INTO nfa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mema ama si pamamuri le jiꞌi se. Te ngaa ledhe nèi kajꞌèu bia nèti neꞌe! Mage dhoka jiꞌi dꞌai mèka nèi, jꞌajꞌèra dhu magee nare le jiꞌi èèna, ètu talora jꞌara. ");
INSERT INTO nfa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ama ladhe ku laa. Rae iiki cue dhu kajꞌèu boe nèti era neꞌe. Rae nèi dhu kolongara aadꞌo. Ladhe ama dꞌèi, jiꞌi laꞌa pasoru iisi asa nèi!” ");
INSERT INTO nfa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ka na dhaa, peka na, “Oo! Lami ka! Te èèna na, jaꞌa palaho boe rae nèi. ");
INSERT INTO nfa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","De rai karohe ka, lami asa nèi! Te jaꞌa tao mèka ngaa-ngaa, ladhe miu dꞌai mèka era nèi.” Karèi nèti lodꞌo èèna, dhèu pangare rae ne Soar, dhu sasoa na ‘ana iiki-iiki’. ");
INSERT INTO nfa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ropa lodꞌo rea, Lot si dꞌai Soar. ");
INSERT INTO nfa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Cagꞌagꞌa laa, LAMATUA sadutu ai dènge èi nasu nèti dedha-liru asa Sodom dènge Gomora. ");
INSERT INTO nfa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","LAMATUA pakèpu-ladhu ai kota dènge rae aaꞌi-aaꞌi ètu dꞌara rai èèna, dènge ngaa-ngaa dhu mamuri ètu èèna, nuka: dhèu, badha-manu, dènge ana aajꞌu. ");
INSERT INTO nfa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lodꞌo rèngu rai, dhèu èmu Lot kabibꞌa kabodho. Cagꞌagꞌa laa, na jꞌajꞌi agarii masi. ");
INSERT INTO nfa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Asa bèli èèna, dhu madꞌae aae era, Abraham laꞌe asa era dhu medꞌa na, na pamako LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Hèia na ladhe sa haha asa Sodom dènge Gomora, aa asa dꞌara mamoo èèna. Na ladhe laꞌa na, sèbꞌu poka-poka sèna, dhu caꞌe asa dedha-liru. Aa ai naꞌe aaꞌi le ngaa-ngaa. ");
INSERT INTO nfa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ama Lamatua patalale Lot si nèti hahuku èèna, ropa Na pakèpu-ladhu ai kota-kota sèra, lula Na ngee nèdhi lii pajaji Na dènge Abraham. ");
INSERT INTO nfa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lodꞌo èèna, Lot madhaꞌu pea taruu ètu rae Soar. Nèti èèna ka, nèngu dènge ana bhèni na dhèu dua sèra, lasi asa ledhe ka ra pea ètu dꞌara loe cue. ");
INSERT INTO nfa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ca lodꞌo, ana bhèni uru èèna, peka dènge ari na, aku nèngu na, “Ètu era neꞌe ne, abhu boe dhèu mone ca dhèu sa, dhu bisa leo dènge èdhi se. Aa ama èdhi asa heka, de ladhe èèna na, na bisa heka abhu ana. ");
INSERT INTO nfa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","De beꞌa risi, ti hia ne ninu mahu, sèna ka èdhi dua ti jꞌunu dènge ne, ho ti abhu kolo hia ama èdhi.” ");
INSERT INTO nfa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ka ropa dꞌai mèda, dua ra hia ama ra ninu èi anggor toke mahu. Hèia ana bhèni uru èèna, laꞌe jꞌunu dènge ama na. Lula ama na dhu mahu ae, ka neꞌa boe nèngu dhu jꞌunu dènge ana na. ");
INSERT INTO nfa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Hèia asa bèli èèna, aꞌa na peka dènge ari na, aku nèngu na, “Mèda deo na, jaꞌa jꞌunu le dènge ama èdhi. De mèda neꞌe, èu kèna. Èdhi hia ne hari ninu mahu, ho lamu jꞌunu dènge ne. Sèna ka èdhi dua ti abhu ana, ho hia ana-èpu mi ama èdhi.” ");
INSERT INTO nfa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ka dꞌara mèda na, dua ra hia hari ama ra ninu mahu. Ka ana bhèni limuri ne, laꞌe ka jꞌunu dènge ama na. Te ngaa, lula ama ra dhu mahu titu kèna, nèti èèna ka, neꞌa boe ngaa dhu nèngu tao mi dedha ana bhèni na. ");
INSERT INTO nfa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Dènge jꞌara neꞌe ne ka, dua ra dènge babia nèti ama dꞌèlu rèngu. ");
INSERT INTO nfa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Hèia ana bhèni uru èèna nara iisi ana mone ca dhèu. Ka na pangare na Moab (dhu sasoa na ‘mai nèti ama’). Ana neꞌe ka dhu jꞌajꞌi bèi-baki nèti dhèu Moab. ");
INSERT INTO nfa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ka ana bhèni limuri ne, nara iisi ana mone èci kahèi. Na pangare na Ben Ami (dhu sasoa na ‘mai nèti dhèu jaꞌa’). Ana ne ka dhu jꞌajꞌi bèi-baki nèti dhèu Amon. ");
INSERT INTO nfa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Èle èèna, ka Abraham nèti Mamre, pidha asa rai Negeb, dhu ètu re balèu, ka na pea ètu talora rae Kades, dènge rae Syur. Te ngaa na pea nèbhu boe, ka pidha hari asa rae Gerar. ");
INSERT INTO nfa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Hèia na peka dènge dhèu ètu sèra, aku nèngu na, “Sara ne, ana hèni jaꞌa.” Nèti èèna ka, Abimelek dhèu aae Gerar, pua dhèu lasi lii dꞌai Sara. Ka nèti ne mai asa dꞌara èmu dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Dꞌara ca mèda sa, Ama Lamatua padꞌelo iisi Na dènge dhèu aae ètu dꞌara nii. Na peka, “Mamadhe èu ne dètu kèna! Lula èu more dhèu èmu dhèu.” ");
INSERT INTO nfa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Hèia Abimelek dhaa, peka na, “Lamatua! Jaꞌa dhae paꞌèci mèka dènge bhèni na. Aa jaꞌa sasala aadꞌo. Abraham unu na ka dhu peka, bhèni na, ana hèni nèngu! Aa bhèni na dhaa sèmi èèna kahèi. Nèti èèna ka, jaꞌa hia dhèu lasi lii dꞌai ne, dènge dꞌara mola. De Lamatua baku padꞌui jaꞌa sasala!” ");
INSERT INTO nfa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ka Lamatua dhaa, peka na, “Tareꞌa. Mema Jaꞌa keꞌa dꞌara èu mola. Nèti èèna ka, Jaꞌa ka dhu taha èu, ho baku paꞌèci dènge ne. Dènge jꞌara sèmi èèna, èu tao boe sala mi Jaꞌa hèi. ");
INSERT INTO nfa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","De èu mèti hari ka bhèni ne, lèpa sa dhèu èmu na. Mone na ka dhu nèti lii padhue-padhai Jaꞌa. De lamu manèngi ne, sèna ka na sabajꞌa hia èu, ho èu baku madhe. Sanèdꞌe paie! Ladhe èu hia boe bhèni na lèpa, èu dènge kabarai èu madhe aaꞌi mèu-mèu.” ");
INSERT INTO nfa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Bèli madꞌae aae èèna, dhèu aae pakaboko nare dhèu-dhèu kapai na aaꞌi-aaꞌi, ka na lolo lii nii na. Hèia aaꞌi-aaꞌi ra madhaꞌu. ");
INSERT INTO nfa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ka dhèu aae paroa Abraham. Na karèi, aku nèngu na, “Jaꞌa tao sala ngaa mi èu, ka èu neo pajꞌèra jaꞌa dènge kabarai jaꞌa? Èu ne ele-hoꞌa ka dènge tao madha jꞌara sèmi neꞌe ne. ");
INSERT INTO nfa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ngangee èu tasamia ka, mu tao sèmi neꞌe ne?” ");
INSERT INTO nfa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ka Abraham dhaa, peka na, “Ama dhèu aae! Jaꞌa pangee na, miu aaꞌi-aaꞌi mi, kabarai ne dhèu dhu tadhe boe Ama Lamatua. De ele boe cahagꞌe neo pamadhe jaꞌa, sèna ka parame rare dhèu èmu jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Mema jaꞌa dhu peka tareꞌa, nèngu ne, ana hèni jaꞌa. Lula jiꞌi dua mi ca ama, te ngaa ina baka-leo. Nèti èèna ka, jiꞌi dua mi paleo. ");
INSERT INTO nfa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ka ropa Ama Lamatua pua jiꞌi ho tèke eele era paleo-paluꞌu jiꞌi, lodꞌo èèna jaꞌa peka dènge dhèu èmu jaꞌa, aku jaꞌa na, ‘Ladhe èdhi lati asa era leo, ho dhèu karèi èu, dhu èdhi se dhèu èmu-kamali, ladhe èu dhu sue jaꞌa, na dhaa la, peka na èdhi se, dua ti paꞌaꞌari.’ ” ");
INSERT INTO nfa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Èle èèna ka, dhèu aae Abimelek pangèdꞌu hari Sara laꞌe asa Abraham. Ka na peka dènge Sara, “Èèna na, jaꞌa hia ana mone mu doi iia ca riho, sèna ka jꞌajꞌi tadha jaꞌa tao boe sala ngaa-ngaa mi èu. Ho hudꞌi sène, dhèu aaꞌi-aaꞌi ra reꞌa!” Hèia dhèu aae peka dènge Abraham, aku nèngu na, “Kabarai jaꞌa ne, dhu bhoke tèke hia èu. Èu neo pea mi era mia èèna ka, jaꞌa hia èu.” Ka Abimelek hia Abraham sapi, kahibꞌi-kaꞌia, dènge kahibꞌi-kalèbho. Na hia kahèi ènu dhèu mone dènge dhèu bhèni. ");
INSERT INTO nfa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Uru èèna, lula Abimelek nare dhèu èmu Abraham, ka LAMATUA hutu eele era ana nèti bhèni aaꞌi-aaꞌi dhu pea ètu kabarai dhèu aae èèna. Te ngaa ropa Abimelek hia Sara lèpa hari sa dhèu èmu na, ka Abraham sabajꞌa ho Lamatua bhoke hari era ana nèti bhèni se. Ka ra abhu hari ana. ");
INSERT INTO nfa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Èle èèna ka, LAMATUA hia Sara mèngi-nale madhutu lii pajaji Na. Lodꞌo Sara dènge babia, Abraham dhu heka le. Ropa Sara nara iisi, umur Abraham dꞌai cangasu tèu kèna. Lodꞌo Sara dꞌai hèru, ka nara iisi ana mone ca dhèu. Ka Abraham pangare ne, Isak (dhu sasoa na ‘na mari’). Sara peka hèi, aku nèngu na, “Ama Lamatua tao jaꞌa mari, lula jaꞌa karejꞌe. Dhèu ae ka dhu pangee na, jaꞌa ètu dꞌara heka sèmi neꞌe ne, abhu heka ana. Masi ka dhèu èmu jaꞌa heka bhoro le, te jaꞌa bisa kora iisi ana hia ne. Èèna na, ladhe dhèu tadèngi jꞌara neꞌe, rèngu aaꞌi-aaꞌi ra mari kahèi dènge jaꞌa ne.” Ropa Isak dꞌai aru lodꞌo, Abraham suna ne, madhutu paredha Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isak kapai ka noo-noo. Ropa oe dꞌai lodꞌo luri susu, Abraham tao tatao aae. ");
INSERT INTO nfa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Ca tèke, Sara ladhe nèdhi Ismael, ana nèti dhèu èmu limuri Abraham, padadisi dènge Isak. Ropa nèdhi sèmi èèna, Sara peka dènge dhèu èmu na, “Bège eele ènu Masir nèi dènge ana na! Te, jaꞌa koꞌo boe ana ènu èèna unu pusaka, masi ka ciki ooꞌe èèna ka. Dhoka ana jaꞌa Isak di, dhu abhu sèra aaꞌi-aaꞌi.” ");
INSERT INTO nfa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ropa Abraham tadèngi lii padhai Sara ne, ka dꞌara na ako beꞌa boe, lula Ismael ne, ana dꞌèlu na kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Te ngaa Ama Lamatua lii dènge Abraham, peka na, “Abraham! Èu baku ngee paꞌae dhèu èmu limuri èu, dènge ana na. Madhutu la dadꞌèi Sara ne, lula bèli-camèdꞌa, èu abhu ana-èpu dhu Jaꞌa moa tèke èèna, nèti Isak neꞌe ka. ");
INSERT INTO nfa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Te ngaa Jaꞌa hia kahèi mèngi-nale mi ana nèti dhèu èmu limuri mu, lula nèngu ne, ana dꞌèlu èu kahèi. Bèli-camèdꞌa, ana-èpu na jꞌajꞌi suku èci kahèi.” ");
INSERT INTO nfa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Bèli madꞌae aae èèna, Abraham tao gee jꞌara hia Hagar, aa na kadhoe èi dꞌara baboꞌi cue mi kabela-kao na. Hèia na patabuli ka bhèni ne dènge ana na Ismael, ho lasi. Ka ra kako palème dꞌara mamoo dhu dètu dènge Beer-Syeba. ");
INSERT INTO nfa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ropa èle èi rinu ra, Hagar tèke eele ana na ètu dꞌara mamaho ajꞌu iiki ca kapua. ");
INSERT INTO nfa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ka na pangee ètu dꞌara na, “Dꞌara jaꞌa laꞌe boe, ladhe jaꞌa kèdhi mamadhe ana jaꞌa.” Ka na madhèdi ako kajꞌèu nèti ana na, pe dꞌai lèmi nguru meter sa. Ka na tangi dènge lii roma iisi. ");
INSERT INTO nfa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Lula Ama Lamatua dhu tadèngi lii tangi Ismael, ka ana pajuu Na mai nèti sorga, ka paroa Hagar, aku nèngu na, “Hagar! Nga tao ka, èu jꞌèra ae sèmi neꞌe ne? Baku madhaꞌu ia ka, te Lamatua tadèngi le lii tangi ana èu. ");
INSERT INTO nfa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","De kèdꞌi lamu more ana nèi. Paꞌèra dꞌara na, te bèli-camèdꞌa Jaꞌa pajꞌajꞌi ana-èpu na, suku èci dhu kapai.” ");
INSERT INTO nfa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ka Ama Lamatua pasaraa musi madha na. Cagꞌagꞌa laa nèdhi dènge, èi ca madha ètu era èèna. Hèia laꞌe soli èi asa dꞌara baboꞌi, ka na panginu ana na Ismael. ");
INSERT INTO nfa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ka Ismael dènge ina na Hagar pea dènge ka ètu dꞌara mamoo Paran. Ismael asa na kapai, aa neꞌa mèu kataki. Ka ina na paleo ne dènge ana bhèni Masir ca dhèu. Seꞌe se jꞌajꞌi, lula Ama Lamatua bera-bera dènge Ismael. ");
INSERT INTO nfa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lodꞌo èèna, dhèu aae Abimelek dènge kètu kapai sordadꞌu na, Fikol, mai pangadꞌo dènge Abraham. Hèia dhèu aae padhai lii, ka na peka, “Abraham! Jiꞌi se ngeꞌa Ama Lamatua bera-bera dènge èu. Nèti èèna ka, sadꞌi èu adꞌu ngaa sa èci, jꞌajꞌi dènge beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","De jaꞌa manèngi, sèna ka èu subha ètu katanga madha Ama Lamatua, dhu peka na, èu bisa boe kapodꞌe-kabèli jaꞌa, dènge ana-èpu jaꞌa aaꞌi-aaꞌi ra. Sèmi dhu jaꞌa tao le beꞌa mi èu, na, èu hudꞌi tao beꞌa kahèi mi jaꞌa dènge kabarai jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ka aku Abraham na, “Ooo! Jaꞌa subha.” ");
INSERT INTO nfa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Te ngaa èle èèna ka, Abraham lapor dènge dhèu aae, aku nèngu na, “Dhèu-dhèu ama dhèu aae parame rare èi jaꞌa ca madha.” ");
INSERT INTO nfa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tadèngi sèmi èèna, hèia na peka, “Waa! Jaꞌa heka tadèngi kèna jꞌara neꞌe ne. Tasamia ka karèi nèti ca hari ni, èu peka boe dènge jaꞌa? Jaꞌa dhae keꞌa mèka, neꞌe ne tatao cee ka ne.” ");
INSERT INTO nfa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Èle èèna ka, Abraham dènge Abimelek paꞌèki lii pajaji. Ka Abraham hia Abimelek sapi dènge kahibꞌi-kalèbho. Èle èèna ka, Abraham hagꞌe nare hari kahibꞌi-kalèbho èni pidhu ngiꞌu. ");
INSERT INTO nfa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Hèia dhèu aae karèi ne, peka na, “Nga tao ka èu tao sèmi èèna?” ");
INSERT INTO nfa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ka Abraham peka, aku nèngu na, “Ama dhèu aae. Sèmi la kalèbho èni pidhu ngiꞌu se, sèna ka jꞌajꞌi tadha dhu ama peka le na, jaꞌa ka dhu kèi èi na.” ");
INSERT INTO nfa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Lula dua ra dhu paꞌèki le soo-subha ètu èèna, ka era na ra pangare na Beer-Syeba (dhu sasoa na, ‘madha èi soo-subha’). ");
INSERT INTO nfa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ropa pasubha èle, ka dhèu aae dènge kètu kapai sordadꞌu na lèpa ka, asa era rèngu, rai dhèu Pilistin. ");
INSERT INTO nfa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Èle èèna ka, Abraham sèle ajꞌu tamareska ca kapua ètu Beer Syeba. Karèi nèti lodꞌo èèna, ajꞌu ne pasanèdꞌe Abraham, lula ètu era èèna ka, nèngu mangajꞌi LAMATUA dhu Mamuri Toke Dꞌai Mia-Mia. ");
INSERT INTO nfa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ka Abraham pea dènge ka ètu talora dhèu Pilistin sèmi dhèu tao mai. ");
INSERT INTO nfa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nèbhu boe, hèia Lamatua sèku neo neꞌa dꞌara Abraham. Neo neꞌa Abraham madhutu Lamatua, do aadꞌo. Ka Lamatua paroa ne, aku Nèngu na, “Abraham!” Hèia na dhaa, peka na, “Ooo, Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ka Ama Lamatua peka dènge ne, “Mu nanene paie-iie! More ana pasue èu mone mesa na. Mèti ne asa rai Moria, ho tao ne jꞌajꞌi korban tunu hia Jaꞌa. Pe dꞌai nèi, Jaꞌa heka pajꞌujꞌu era dhu ètu ledhe èci.” ");
INSERT INTO nfa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Dꞌai bèli madꞌae aae na, Abraham sègꞌi ajꞌu sèna ka tao kadhèna. Na èki, ka na hue asa dedha keledꞌei. Ka dua ra dènge Isak, aa dènge dhèu sabꞌa na dhèu dua, pakèdꞌi asa era dhu Lamatua peka dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ra kako taruu, ka dꞌai camèdꞌa èèna, Abraham nèdhi le era èèna nèti kajꞌèu. ");
INSERT INTO nfa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Hèia na peka dènge dhèu dua sèra, aku nèngu na, “Dua mi mate taha mi neꞌe dènge keledꞌei ne. Jaꞌa dènge ana jaꞌa laꞌa asa dedha nèi, ho mangajꞌi Ama Lamatua. Ladhe èle na, jiꞌi lèpa hari mai.” ");
INSERT INTO nfa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ka Abraham nare kadhèna dhu neo tunu korban, ka na tao mi kabela-kao Isak. Aa nèngu nèdꞌu tudꞌi, dènge suu ai. Ropa dua ra palere lasi, ");
INSERT INTO nfa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","hèia Isak paroa ama na, aku nèngu na, “Ama!” Ka Abraham dhaa, aku nèngu na, “Nga tao, ana?” Hèia Isak karèi, aku nèngu na, “Èdhi neo lati tunu korban. De ai dènge kadhèna ka seꞌe le. Te ngaa ana kahibꞌi-kalèbho dhu èdhi pake jꞌajꞌi korban, ka mia?” ");
INSERT INTO nfa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Te ngaa, aku Abraham na, “Pe Ama Lamatua unu Na ka dhu hia ana kalèbho, sèna ka jꞌajꞌi mi korban.” Ka dua ra caꞌe lasi taruu. ");
INSERT INTO nfa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ropa dua ra dꞌai era dhu Lamatua peka èèna, ka Abraham pudhi hadhu ho tao mei korban. Hèia na paloko kadhèna ètu dedha mei korban ne. Ka kèpe ana na Isak, èki patarenga ne ètu dedha kadhèna. ");
INSERT INTO nfa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ka nare tudꞌi, ho neo kèjꞌi pamadhe ana na. ");
INSERT INTO nfa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Cagꞌagꞌa laa, ana pajuu LAMATUA lii nèti dedha-liru, peka na, “Abraham! Mata ku!” Ka Abraham dhaa, aku nèngu na, “Nga tao, Lamatua?” ");
INSERT INTO nfa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ka na peka hari, na, “Baku pamadhe ana èèna! Baku tao ngaa-ngaa mi nèngu. Jaꞌa keꞌa le, èu ne tareꞌa-reꞌa madhutu dadꞌèi Lamatua. Lula èu dènge dꞌara kateme hia ana èu ca dhèu mesa èèna, sèna ka jꞌajꞌi mi korban hia Ne.” ");
INSERT INTO nfa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Hèia Abraham ladhe nèdhi kahibꞌi-kalèbho mone ciꞌu, dhu tadhu na pakai nare dadana aajꞌu dhu karoki. Ka na laꞌe kèpe nare, ho tunu jꞌajꞌi mi korban hia Ama Lamatua, gati ana na. ");
INSERT INTO nfa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ka Abraham pangare era èèna, na, ‘Lamatua sadia tèke ngaa dhu parluu.’ Nèti èèna ka, dꞌai sange neꞌe, dhèu peka na, “Ètu ledhe LAMATUA èèna, Na sadia tèke ngaa dhu parluu.” ");
INSERT INTO nfa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Èle èèna ka, ana pajuu Lamatua lii hari nèti dedha-liru, peka na, ");
INSERT INTO nfa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“LAMATUA unu Na, peka, ‘Jaꞌa subha dènge kolongara Jaꞌa mesa ku, sèmi neꞌe: èu sadia le hia Jaꞌa ana mu ca dhèu mone mesa na ho jꞌajꞌi mi korban. Nèti èèna ka, ");
INSERT INTO nfa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","bèli-camèdꞌa, Jaꞌa pala-bagi èu dènge ana-èpu èu mèngi-nale ae-ae. Èèna na, ra bèba-kacanga, toke dhèu ige rare boe, sèmi hua-hètu ètu dedha-liru, aa salae ètu sebhe dhasi. Ana-èpu èu sèra, èèna na, segi aaꞌi musu rèngu sèra. ");
INSERT INTO nfa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nèti ana-èpu èu, dhèu aaꞌi-aaꞌi ètu rai-haha ne abhu mèngi-nale lula èu madhutu le lii paredha Jaꞌa.’ ” ");
INSERT INTO nfa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Èle hèia, Abraham dènge Isak, lèpa hari asa era dhu dhèu sabꞌa na sèra. Ka lasi palere asa Beer-Syeba. Dꞌai nèi, Abraham si pea dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ca lodꞌo, Abraham tadèngi na, dhèu èmu ari na Nahor, dhu ngara na Milka, nara iisi ana na. ");
INSERT INTO nfa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ana uru, ngara na Us. Ari na, Bus. Èle ka, nara iisi hari Kemuel (dhu jꞌajꞌi ama Aram.) ");
INSERT INTO nfa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ka na abhu hari Kesed, Haso, Pildas, Yidlaf, dènge Betuel. ");
INSERT INTO nfa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel èèna, ama nèti Ribka. ");
INSERT INTO nfa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor abhu ana kahèi nèti bhèni piara na, ngara na Reuma. Ana Reuma, nuka: Teba, Gaham, Tahas, dènge Maaka. ");
INSERT INTO nfa_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Lodꞌo Sara madhe, umur na 127 (ca ngasu dua nguru pidhu) tèu le. Lodꞌo na madhe èèna, Abraham si pea ètu rae Kiryat-Arba (nuka Hebron), ètu rai Kanaꞌan. Ka Abraham beke aa tangi dhèu èmu na dènge dꞌara pèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Hèia Abraham kèdꞌi laꞌe paraga dènge dhèu-dhèu Het. Ka na peka dènge si, aku nèngu na, ");
INSERT INTO nfa_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Jaꞌa ne, dhèu tao mai ètu talora miu se. Jaꞌa dhu dènge boe rai ca kasibꞌi sa, sèna ka padhane dhèu èmu jaꞌa. De ladhe miu sue jaꞌa, jaꞌa hèli kore rai miu dꞌai ca kasibꞌi sa, ho tao era padhane ne.” ");
INSERT INTO nfa_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hèia ra dhaa, aku rèngu na, ");
INSERT INTO nfa_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Sèmi neꞌe, ama! Nèbhu nare sange neꞌe, jiꞌi se tadhe le ama, dhu sama sèmi ca dhèu, dhèu heka dhu jiꞌi pakabꞌua. De sadꞌi ama dꞌèi rai mia dhu beꞌa, dhu pamèci dènge dadꞌèi ama. Jiꞌi se dhoka ngoꞌo di; dhèu èci sa dhu magee boe.” ");
INSERT INTO nfa_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Hèia Abraham pacudꞌu iisi ho hia hormat mi lamatua rai, dhèu Het sèra. ");
INSERT INTO nfa_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ka na padhai lii, peka na, “Ladhe miu sèmi lii jaꞌa na, jaꞌa manèngi ho peka dènge ana mone Sohar, dhu ngara na Efron. ");
INSERT INTO nfa_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Peka dènge ne, ladhe na dꞌèi, na pahia dènge jaꞌa loe na, Makpela, dhu ètu karasa oka na. Na manèngi ca ngaa èèna ka, jaꞌa tihe. Jaꞌa neo tihe pamaꞌète kabꞌua na, ètu madha miu aaꞌi-aaꞌi mi, sèna ka rai èèna jꞌajꞌi unu jaꞌa. Jaꞌa neo tao era èèna, jꞌajꞌi mi roꞌa dhèu madhe jiꞌi.” ");
INSERT INTO nfa_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Lodꞌo èèna, Efron madhèdi ètu era èèna kahèi, dènge dhèu-dhèu Het sèra. Ka na tadèngi kahèi lii padhai lii Abraham deo na. Hèia na kèdꞌi titu, ka na bꞌala Abraham ètu madha dhèu heka aaꞌi-aaꞌi ra ètu sèra, aku nèngu na, ");
INSERT INTO nfa_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Baku sèmi èèna, ama! Sèmi neꞌe ka laa! Oka dènge loe Makpela èèna, jaꞌa hia iia ama. Sèna ka mu padhane dhèu èmu èu mi èèna. Jaꞌa pangèdꞌu rai èèna mi ama, ètu madha dhèu-dhèu jaꞌa se. Sèna ka rèngu aaꞌi-aaꞌi ra jꞌajꞌi sakasii!” ");
INSERT INTO nfa_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ka Abraham pacudꞌu kètu hari mi dhèu Het se. ");
INSERT INTO nfa_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Hèia na peka dènge Efron, aku nèngu na, “Sèmi èèna oo, beꞌa kahèi. Te ngaa miu nanene lii jaꞌa, la ma. Jaꞌa neo hèli pamaꞌète rai na, sèna ka jꞌajꞌi era padhane dhèu-dhèu jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Hèia, aku Efron na, “Rai èèna, kabꞌua na, dhoka èpa ngasu doi pudhi di. Guna ngaa èdhi dua ti padhue kabꞌua rai ciki ooꞌe èèna, dhu sasoa na aadꞌo. De lamu ka, ho mèti dhèu madhe na, sèna ka padhane ne ètu nèi.” ");
INSERT INTO nfa_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ka Abraham dꞌèi kahèi dènge kabꞌua na sange èèna, madhutu sèmi lii Efron. Hèia ètu madha dhèu ae-ae sèra, na ige nare doi pudhi èpa ngasu, tihe kabꞌua rai èèna mi Efron. ");
INSERT INTO nfa_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","De dènge jꞌara sèmi èèna, Abraham abhu dènge rai ne nèti Efron, jꞌajꞌi mi unu na. Rai na nuka ètu Makpela, padètu dènge Mamre (nuka Hebron). Na hèli pamaꞌète rai ne dènge oka na, dènge loe na, aa dènge ajꞌu aaꞌi-aaꞌi ra. Dhèu-dhèu heka nèti suku Het, aaꞌi-aaꞌi ra ka dhu jꞌajꞌi sakasii, peka na, rai èèna dènge isi aaꞌi-aaꞌi jꞌajꞌi le unu Abraham. Èle èèna ka, Abraham laꞌe padhane Sara ètu dꞌara loe èèna, ètu rai Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Dènge sèmi èèna, dhu uru èèna oka dènge loe na unu dhèu Het, limuri ne jꞌajꞌi le rai unu Abraham. Ka na tao jꞌajꞌi mi era udhu rui ra. ");
INSERT INTO nfa_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Tèu-tèu mamuri Abraham madhera titu kèna. LAMATUA ladhe-leru ne dènge beꞌa, aa hia ne mamuri dènge mera-milu. ");
INSERT INTO nfa_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Abraham dhu dènge dhèu èci dhu na lèka ho ladhe-leru mèdha-panyau na. Ca lodꞌo, Abraham paroa nare, ka peka dènge ne, aku nèngu na, “Mu pasa dhilu èu paie-iie! Jaꞌa manèngi sèna ka èu subha madhe dènge kolongara LAMATUA. Nèngu ka, Ama Lamatua dhu tao dedha-liru dènge rai-haha ne. Dhu peka na, èu bisa boe more ana bhèni nèti dhèu Kanaꞌan, ho paleo dènge ana jaꞌa Isak. ");
INSERT INTO nfa_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Te ngaa èu hudꞌi lamu ku asa rai èta-èsu jaꞌa, asa aꞌari jaꞌa. Ho tenge ètu rèngu sèi, ana bhèni ca dhèu, ho mu paleo dènge ana jaꞌa ne.” ");
INSERT INTO nfa_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Hèia dhèu sabꞌa ne karèi Abraham, aku nèngu na, “Beꞌa, ama! Te ngaa, sèmi ana bhèni na dꞌèi boe mai asa neꞌe, na tasamia? Ladhe sèmi èèna, hudꞌi jaꞌa kèti ana ama ku, ho hia ne leo-èmu ètu nèi, do tasamia?” ");
INSERT INTO nfa_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Hèia, aku Abraham na, “Èu nanene paie! Masi ka tasamia èèna ka, mage èu mèti ana jaꞌa ne, asa nèi kahèi! ");
INSERT INTO nfa_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mu sanèdꞌe, te LAMATUA dhu nèdꞌu koasa ètu dedha-liru, ka dhu lere jaꞌa nèti rai èta-èsu jaꞌa, asa dedha-rai neꞌe ne. Aa dhu Na paꞌèki le lii pajaji dènge jaꞌa, dhu peka na, ‘Èèna na, Jaꞌa hia rai ne aaꞌi-aaꞌi mi ana-èpu èu.’ De èu baku madhaꞌu. Sadꞌi lamu. Te èèna na, Lamatua pua ana pajuu Na nèti sorga, mai bhoke jꞌara hia èu, sèna ka èu paraga dènge ana bhèni, dhu èèna na jꞌajꞌi dhèu èmu ana jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Te ngaa ladhe ana bhèni na dꞌèi boe mai asa neꞌe, lii soo-subha ne lèke boe èu. Masi ka tasamia na, èu bisa boe mèti ana jaꞌa asa nèi.” ");
INSERT INTO nfa_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Hèia dhèu ne, dedꞌe subha dènge Abraham, ka na peka, èèna na, nèngu tao madhutu dadꞌèi Abraham aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ka dhèu èèna pili nare badha onta canguru ngiꞌu. Hèia na hua rupa-rupa mèdha dhu kabꞌua asa dedha onta se. Hèia laꞌe ka asa kota Nahor, ètu rai Mesopotamia. ");
INSERT INTO nfa_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Nèbhu-nèbhu ka mone ne dꞌai kota èèna. Hèia na ae kabhèsu dènge onta sèra ètu sebhe kota èèna, dètu dènge madha èi èci. Na ae èèna dꞌara lodꞌo nihia le, ropa ana bhèni-ana bhèni kota èèna mai rara èi ètu madha èi èèna. ");
INSERT INTO nfa_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Hèia dhèu ne sabajꞌa, peka na, “LAMATUA, Èu ka dhu jꞌajꞌi Ama Lamatua nèti lamatua jaꞌa, Abraham. Bhoke jꞌara hia jaꞌa, sèna ka kakako jaꞌa ne dènge kabꞌua. Padꞌelo sasue Èu mi lamatua jaꞌa, aa baku bhèlu lii pajaji ne dènge jaꞌa. De hia la jaꞌa paraga dènge ana bhèni dhu èèna na jꞌajꞌi dhèu èmu Isak. ");
INSERT INTO nfa_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lamatua, jaꞌa ka titu ètu karasa madha èi ne. Aa ana bhèni-ana bhèni nèti kota ne, mai rara èi ètu neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","De jaꞌa manèngi sèmi neꞌe: ladhe jaꞌa padhai lii dènge ana bhèni èci, peka na, ‘Ana, ee! Papuru ku èru èi èu hia jaꞌa kinu.’ Ho ladhe na dhaa, peka na, ‘Ama, minu la! Aa, pe jaꞌa hia dènge onta ama, rinu hèi!’ Jꞌara neꞌe ne jꞌajꞌi tadha dhu peka na, ana bhèni ne ka dhu Ama Lamatua pajꞌujꞌu, jꞌajꞌi mi dhèu èmu Isak! Dènge tadha sèmi neꞌe, jaꞌa keꞌa na Lamatua padꞌelo le babeꞌa mi Abraham, lamatua jaꞌa èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Dhu na sabajꞌa nare mèka, ana bhèni ca dhèu mai. Ngara na Ribka. Nèngu ne, èpu nèti ari Abraham, nuka Nahor, dènge dhèu èmu na, Milka. Ama Ribka, ngara na Betuel. Ribka ne, bhèni iia nia boe, aa paꞌèci nèdhi mèka dènge mone. Dꞌai era èèna, puru asa dꞌara èi laꞌe, ka na isi èru èi na. Nèbhu boe, ka caꞌe mai sa dedha. ");
INSERT INTO nfa_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ropa nare dedha, ka dhèu sabꞌa Abraham èèna, laꞌe padètu dènge ne. Hèia na manèngi, peka na, “Ana. Hia ku jaꞌa kinu ciki.” ");
INSERT INTO nfa_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ka na dhaa, “Minu la, ama!” Hèia na papuru ka èru èi na, ka na hia dhèu ne ninu. ");
INSERT INTO nfa_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ropa ninu èle, ka ana bhèni ne peka na, “Pe jaꞌa laku dhui hari èi, sèna ka hia onta ama se, rinu toke bècu.” ");
INSERT INTO nfa_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ka laꞌe bhori èi dhu risi, asa dꞌara karabꞌa badha. Hèia na caꞌe-laꞌe mai pèri-pèri hari, dhui èi, ho hia onta se rinu toke bècu. ");
INSERT INTO nfa_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Te ngaa dhèu sabꞌa Abraham, titu ka mau-mau, na taru kira ka ana bhèni ne sabꞌa. Ka na pangee ètu dꞌara na, aku nèngu na, “Ele boe nèngu èèna ka neꞌe, dhu Lamatua pajꞌujꞌu.” ");
INSERT INTO nfa_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Onta se rinu toke bècu. Hèia dhèu ne nare kadheli sahènga, dènge kanau ca pasa. Mèdha se dhu tao nèti hualaa. Ka na pasa mi sahènga dènge pasaluu mi ai kariu dènge gꞌana ana bhèni ne. ");
INSERT INTO nfa_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Èle èèna ka, dhèu ne karèi ne, aku nèngu na, “Ana, ama mu, ngara na cee? Ladhe moꞌo, na jaꞌa manubha taha ètu èmu ama mu.” ");
INSERT INTO nfa_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Hèia na dhaa, “Ngara ama ku, na Betuel. Aa ngara baki ku, Nahor. Dènge ngara bèi ku, Milka. ");
INSERT INTO nfa_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ètu èmu jiꞌi, era jꞌunu ae, de dꞌai miu jꞌunu. Aa jꞌuꞌu ae kahèi, ho hia badha miu se raꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Hèia dhèu sabꞌa ne pahaha iisi ho mangajꞌi mi LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ka na peka, aku nèngu na, “Koa-kio kolongara Lamatua! Ama Lamatua bhoke le jꞌara hia jaꞌa, ka jaꞌa paraga le dènge aꞌari lamatua jaꞌa Abraham ètu kabarai neꞌe. Dènge jꞌara neꞌe, Lamatua padꞌelo sasue Na mi lamatua jaꞌa, Abraham, aa tao madhutu sama sèmi lii pajaji na dènge jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Èle èèna ka, ana bhèni ne rai laꞌe asa èmu, na lolo dènge isi èmu na ngaa dhu jꞌajꞌi le èèna. ");
INSERT INTO nfa_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ana mone Ribka, ngara na Laban. Ropa Laban ladhe nèdhi mèdha hualaa se, aa na tadèngi lii lolo ana hèni na, ka rai asa liꞌu laꞌe. Laꞌe soru dhèu sabꞌa Abraham dhu titu era dènge onta ra ètu madha èi. ");
INSERT INTO nfa_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Hèia Laban peka, aku nèngu na, “Ama! LAMATUA ka dhu lere miu mai dènge karejꞌe-karae dꞌai neꞌe. De baku titu mi liꞌu ne! Mai lati sa èmu jiꞌi, te jiꞌi lalau ngare le kama. Ngangaꞌa hia badha se, dhu tesa.” ");
INSERT INTO nfa_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hèia dhèu sabꞌa Abraham ne, madhutu dènge ka Laban, lasi èmu Betuel. Ka Laban si papuru mèdha-panyau nèti dedha onta se. Èle èèna ka, ra pangaꞌa onta se. Rèti èi, hia dhèu sabꞌa dènge anga na se, ho rase haga. ");
INSERT INTO nfa_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ropa lalau rare ngangaꞌa-nginu ètu dedha mei, dhèu sabꞌa ne padhai lii, aku nèngu na, “Jiꞌi neo ngaꞌa ne, te ngaa jaꞌa lole uuru ku, mamai jaꞌa ne.” Ka Laban dhaa, peka na, “Ama, mu padhai lii ngaa, na peka ka laa.” ");
INSERT INTO nfa_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Hèia dhèu èèna peka, aku nèngu na, “Jaꞌa ne, dhèu sabꞌa nèti baki miu Abraham. ");
INSERT INTO nfa_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","LAMATUA hia Abraham, lamatua jaꞌa èèna, mèngi-nale ae titu kèna, ka na kaja-suꞌi. Lamatua pala-bagi ne doi hualaa pudhi dènge hualaa iia; ènu dhèu bhèni dènge dhèu mone, dènge badha-manu ae-ae, sèmi: sapi, onta, keledꞌei, kahibꞌi-kaꞌia, dènge kahibꞌi-kalèbho. ");
INSERT INTO nfa_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Lodꞌo lamatua jaꞌa se, bhèni-mone dꞌai heka ku, ka Sara nara iisi ana mone ca dhèu. Nèngu ka dhu bèli-camèdꞌa unu aaꞌi pusaka ama na. ");
INSERT INTO nfa_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ka Abraham pua jaꞌa subha, peka na, ‘Mage èu more ana bhèni Kanaꞌan kahèi, ho paleo dènge ana jaꞌa, Isak. ");
INSERT INTO nfa_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Te ngaa èu hudꞌi more ana bhèni nèti aꞌari jaꞌa unu ku, ho sèna ka jꞌajꞌi dhèu èmu na.’ ");
INSERT INTO nfa_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Hèia jaꞌa karèi ne, aku jaꞌa na, ‘Tasamia, ladhe ana bhèni ne, noꞌo boe madhutu jaꞌa mai sa neꞌe?’ ");
INSERT INTO nfa_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ka na peka, ‘LAMATUA dhu jaꞌa madhutu dadꞌèi Na, pe Na paleha ana pajuu Na nèti sorga, mai bhoke jꞌara hia èu, sèna ka èu abhu ana bhèni ca dhèu nèti aꞌari jaꞌa unu ku, ho jꞌajꞌi mi dhèu èmu ana jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Te ngaa ladhe aꞌari jaꞌa seꞌe roꞌo boe ana bhèni na mai asa neꞌe, lii subha na lèke boe mi dedha èu ne.’ ");
INSERT INTO nfa_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ka deo na, ropa jaꞌa dꞌai madha èi èèna, jaꞌa manèngi-mangajꞌi ètu dꞌara, peka na, ‘LAMATUA nèti lamatua jaꞌa Abraham. Bhoke ku jꞌara hia jaꞌa, sèna ka mamai jaꞌa ne dènge kabꞌua. Ho sèna ka jaꞌa abhu ana bhèni dhu èèna na jꞌajꞌi dhèu èmu Isak. ");
INSERT INTO nfa_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Lamatua, jaꞌa titu ètu sebhe madha èi ne. Aa ana bhèni-ana bhèni nèti dꞌara kota ne mai rara èi ètu neꞌe. De jaꞌa manèngi sèmi neꞌe: ladhe jaꞌa peka dènge ana bhèni èci, aku jaꞌa na, “Ana, ee! Papuru ku èru èi èu, ho jaꞌa kinu èi ciki.” ");
INSERT INTO nfa_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ho ladhe na dhaa na, “Oo. Minu! Aa èle na, jaꞌa panginu badha ama se kahèi!” Ladhe jꞌajꞌi madhutu sèmi lii jaꞌa ne, na èèna ka dhu jꞌajꞌi tadha, ana bhèni ne ka dhu Lamatua pajꞌujꞌu nare hia ana lamatua jaꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Jaꞌa dhu dhae èle mèka manèngi-mangajꞌi, te Ribka dhu nare le era èèna nèti dènge èru èi na. Ropa na caꞌe mai nèti dꞌara èi, jaꞌa lii dènge ne, aku jaꞌa na, ‘Ana, ee! Hia ku jaꞌa kinu èi ciki.’ ");
INSERT INTO nfa_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ka na papuru dènge ka èru èi na, ka na peka, ‘Oo. Minu! Aa pe jaꞌa panginu onta ama se kahèi.’ Hèia jaꞌa kinu, aa onta jaꞌa se oo rinu kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ka jaꞌa karèi ne, ‘Ama mu, ngara na cee?’ Ka na dhaa, peka na, ‘Ama ku, ngara na Betuel. Aa baki ku, ngara na Nahor. Dènge ngara bèi ku, Milka.’ Hèia jaꞌa papake ne kadheli mi sahènga na, dènge pasaluu kanau hualaa ca pasa mi ai kariu dènge ai gꞌana na. ");
INSERT INTO nfa_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Èle èèna ka, jaꞌa pacudꞌu kètu ho mangajꞌi mi Lamatua, ka jaꞌa peka na, ‘Koa-kio kolongara Lamatua! Lamatua bhoke le jꞌara hia jaꞌa, nèti èèna ka, jaꞌa paraga le dènge aꞌari lamatua jaꞌa Abraham ètu era neꞌe ne. Aa paraga le kahèi dènge ana bhèni dhu èèna na jꞌajꞌi dhèu èmu Isak!’ ");
INSERT INTO nfa_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","De neꞌe ne, ladhe ama si neo padꞌelo sasue mi lamatua jaꞌa Abraham, na mi peka pamèu dènge jaꞌa. Te ngaa ladhe aadꞌo, peka la mola-mola dènge jaꞌa. Ho jaꞌa keꞌa, sèna ka tao hari ngaa.” ");
INSERT INTO nfa_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ropa dhèu sabꞌa ne padhai lii nare, ka Laban dènge Betuel dhaa, aku rèngu na, “Ladhe LAMATUA dhu adꞌu nare le madha jꞌara ne, jiꞌi peka lii ngaa hari. ");
INSERT INTO nfa_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ribka ka neꞌe ne. More ho mèti, sèna ka na jꞌajꞌi mi dhèu èmu ana Abraham, madhutu sèmi dhu LAMATUA ator èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ropa na tadèngi nare, dhèu sabꞌa ne pacudꞌu kètu dꞌai rai, ka na manèngi makasi mi LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Èle èèna ka, nare mèdha nèti hualaa iia dènge hualaa pudhi sèra, dènge mèdha-papake dhu saraga, ka na hia mi Ribka. Aa na hia kahèi mi ana mone na dènge ina na, mèdha-mèdha dhu kabꞌua aae. ");
INSERT INTO nfa_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Èle aaꞌi ka, heka dhèu sabꞌa ne dènge anga na madhèdi raꞌa-rinu aaꞌi-aaꞌi ra. Ka ra jꞌunu ètu èèna. Bèli madꞌae èèna, dhèu sabꞌa ne palangu lii dènge lamatua èmu se, aku nèngu na, “Hia ka jaꞌa ho lèpa la asa lamatua jaꞌa Abraham.” ");
INSERT INTO nfa_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Te ngaa ana mone dènge ina ana bhèni na, peka na, “Te neo hari lèpa lai-lai, tao ngaa ne? Hudꞌi Ribka pea hari ku dènge jiꞌi dꞌai canguru lodꞌo sa laa ma, heka lami kèna.” ");
INSERT INTO nfa_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Te ngaa dhèu sabꞌa èèna dhaa, peka na, “Waa! Baku kai jaꞌa! Te LAMATUA sue le jaꞌa, ka toke jaꞌa rage le bhèni dhu èèna na jꞌajꞌi dhèu èmu Isak. De patabuli ka jiꞌi se, laꞌa peka ku dènge lamatua jiꞌi Abraham.” ");
INSERT INTO nfa_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Hèia ra dhaa, aku rèngu na, “Sèmi neꞌe ka laa! Mai ti karèi Ribka, sèna ka teꞌa dadꞌèi na tasa mera mia?” ");
INSERT INTO nfa_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Hèia ra paroa ne, aku rèngu na, “Ribka! Di aku èu kèna. Èu neo lamu dènge ka dènge dhèu neꞌe do, tasamia?” Ka Ribka dhaa, peka na, “Jaꞌa koꞌo.” ");
INSERT INTO nfa_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Hèia ra hia Ribka dènge bhèni dhu leru ne karèi nèti ana iiki ka, ho lasi palere dènge dhèu sabꞌa Abraham sèra. Ka ra hia Ribka mèngi-nale, aku rèngu na, “Jiꞌi sanao-maena sèna ka Ama Lamatua hia èu mora iisi ana ae-ae, ho ana-èpu mu dꞌai riho-kehi. Aa jiꞌi sanao kahèi, sèna ka ana-èpu èu sèra segi aaꞌi musu rèngu sèra!” ");
INSERT INTO nfa_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Èle èèna ka, Ribka dènge bhèni dhu leru nèngu na lalau ka mèdha ra, ka ra caꞌe onta, pakèdꞌi dènge ka, madhutu dhèu sabꞌa Abraham sèra. ");
INSERT INTO nfa_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak pea ètu rai Negeb. Lodꞌo èèna, na heka lèpa kèna nèti madha èi Beer Lahai Roi. ");
INSERT INTO nfa_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Dꞌara lodꞌo nihia ca lodꞌo, na kalua nèti dꞌara paleo na, laꞌe pasiar ciki. Ropa na boti kètu, na ladhe laa na onta-onta kako mai asa era nèngu na. ");
INSERT INTO nfa_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ropa Ribka ladhe nèdhi Isak, hèia na puru lai-lai nèti dedha onta. ");
INSERT INTO nfa_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ka na karèi dhèu sabꞌa Abraham, aku nèngu na, “Dhèu mone cee ka mai nèi?” Ka dhèu ne dhaa, peka na, “Nèngu na, ana lamatua jaꞌa kèna.” Hèia Ribka nare salalu na, paꞌabhe rèhu na. ");
INSERT INTO nfa_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ka dhèu sabꞌa ne lolo dènge Isak, aaꞌi-aaꞌi dhu jꞌajꞌi le. ");
INSERT INTO nfa_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Hèia Isak todhe nèti ka Ribka lasi asa dꞌara paleo ina na, ka dua ra paleo ka èmu. Lula Isak sue seli eele Ribka, ka na susa heka dènge mamadhe ina na. ");
INSERT INTO nfa_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ka Abraham leo hari èmu dènge bhèni èci, ngara na Ketura. ");
INSERT INTO nfa_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Hèia Ketura matana ana hia ne. Ana se, ngara ra: Simran, Yoksan, Medan, Midian, Isbak, dènge Sua. ");
INSERT INTO nfa_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ana Yoksan ka: Seba dènge Dedan. Ana-èpu Dedan nuka, dhèu Asyur, dhèu Letus, dènge dhèu Leum. ");
INSERT INTO nfa_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ana Midian ka: Efa, Efer, Henok, Abida dènge Eldaa. Rèngu aaꞌi-aaꞌi se, ana-èpu Ketura. ");
INSERT INTO nfa_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Lodꞌo dhu Abraham mamuri era, na hagꞌe nare le mèdha-panyau hia ana Hagar dènge ana-ana Ketura, èci-èci ka dènge unu na. Èle èèna ka, Abraham pua si lasi pea re bèka dhimu rai Kanaꞌan, sèna ka ra pakajꞌèu nèti ana na Isak. Ka pusaka na aaꞌi-aaꞌi, na pangèdꞌu mi ana na Isak. ");
INSERT INTO nfa_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Lodꞌo umur Abraham dꞌai 175 (ca ngasu pidhu nguru lèmi) tèu, na madhe. ");
INSERT INTO nfa_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Ka ana na, Isak dènge Ismael, padhane ne ètu dꞌara loe Makpela, dhu padètu dènge Mamre. Rai ne, dhu uru èèna, Abraham hèli nare nèti Efron, ana Sohar, dhèu Het. Ka dhu uru èèna, ra padhane le Sara ètu dꞌara loe èèna. ");
INSERT INTO nfa_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Èle madha Abraham, ka Ama Lamatua hia mèngi-nale mi Isak, ka na mamuri mera-milu. Lodꞌo èèna, Isak pea dètu dènge madha èi Beer Lahai Roi. ");
INSERT INTO nfa_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Neꞌe ne, lii lolo nèti mamuri Ismael. Nèngu ne, ana Abraham dènge dhèu èmu limuri na, Hagar, dhu jꞌajꞌi ènu Sara nèti Masir. ");
INSERT INTO nfa_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ana-ana Ismael, mone dhèu canguru dua. Ngara ra dhu madhutu nèti dhu uru tèka dꞌai ana limuri tèka, nuka: Nebayot, Kedar, Adbeel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis, dènge Kedma. Ana-ana sèra ka, jꞌajꞌi bèi-baki nèti canguru dua suku, dhu èci-èci ka dènge kabarai ra. Ra pangare kabarai ra èci-èci, madhutu ngara bèi-baki ra. ");
INSERT INTO nfa_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ropa umur Ismael dꞌai 137 (cangasu tèlu nguru pidhu) tèu, ka na madhe. ");
INSERT INTO nfa_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Te ngaa ana-èpu na sèra, èci pamusu dènge èci. Ka ra pea pahagꞌa, mulai nèti rai Hawila dꞌai rai Syur, dhu palane dènge rai Masir, toke dꞌai rai Asyur. ");
INSERT INTO nfa_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Neꞌe ne, lii lolo nèti mamuri Isak, ana Abraham. ");
INSERT INTO nfa_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Lodꞌo Isak madhèdi dènge Ribka, umur na 40 (èpa nguru) tèu le. Ama Ribka, ngara na Betuel. Ana mone Ribka, ngara na Laban. Rèngu se, dhèu Aram, nèti Padan Aram. ");
INSERT INTO nfa_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribka dhu dènge mèka ana. Nèti èèna ka, Isak manèngi-mangajꞌi mi LAMATUA, sèna ka Na bhoke era ana Ribka. Hèia LAMATUA tadèngi lii manèngi Isak, ka Ribka dènge babia. ");
INSERT INTO nfa_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Te ngaa ana dhu Ribka kadꞌo ne, dhèu dua. Aa ana se paliku taruu ètu dꞌara kabake ina ra. Ka Ribka ngee ka ètu dꞌara na, “Nga tao ka ana dua se, sèmi neꞌe?” Hèia na pakarèi dènge LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ka LAMATUA dhaa, peka na, “Ètu dꞌara kabake èu na, abhu dua suku, dhu èèna na loe boe dènge pamusu. Dhu limuri èra risi nèti dhu uru. Ka aꞌa na, lalau-laloꞌo ari na.” ");
INSERT INTO nfa_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ropa lodꞌo dꞌai, Ribka nara iisi ana mone dhèu dua. ");
INSERT INTO nfa_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Dhu aꞌa, isi na mea, dènge ngiꞌu na pènu dènge rèu. Nèti èèna ka, ra pangare ne, Esau (dhu sasoa na ‘dènge rèu’). ");
INSERT INTO nfa_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Èle èèna ka, ari na heka kalua kèna. Te ngaa dhu na kèpe hui tèdhu aꞌa na. Nèti èèna ka, ra pangare ne, Yakob (dhu sasoa na ‘hui tèdhu’). Lodꞌo Ribka nara iisi ana na se, umur Isak 60 (èna nguru tèu) kèna. ");
INSERT INTO nfa_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Lodꞌo ana dua se kapai, Esau dhu neꞌa mèu kasiro badha hui. Ae ka dhu na pea ètu dꞌara jꞌami. Te ngaa Yakob dhu mau-mau, dhu dꞌèi dhoka pea ètu dꞌara èmu di. ");
INSERT INTO nfa_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak dꞌèi naꞌa sisi badha hui. Nèti èèna ka, na sue risi Esau. Te ngaa Ribka sue risi Yakob. ");
INSERT INTO nfa_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ca lodꞌo, Yakob dhu tao bubur kabꞌui, aa Esau heka lèpa nèti kasiro badha hui kèna. Na lèpa dènge manganga, ka roe titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ka na peka dènge Yakob, aku nèngu na, “Ari, ee! Hia ku jaꞌa bubur kabꞌui mea ciki ètu dꞌara èru èèna, ho jaꞌa kuꞌa! Te jaꞌa manganga bia.” (Nèti èèna ka, ra pangare na, Edom, dhu sasoa na ‘mea’.) ");
INSERT INTO nfa_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ka, aku Yakob na, “Beꞌa aꞌa. Te ngaa pasilu ku dènge hak aꞌa èèna!” ");
INSERT INTO nfa_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Hèia Esau dhaa, aku nèngu na, “Hak aꞌa ne, ngaa kèna, hudꞌi nèngu sèna! Neo more, na more la. Te jaꞌa manganga bia. Sodꞌe mèti bubur èèna lai-lai mai, te jaꞌa taha heka.” ");
INSERT INTO nfa_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Te ngaa, aku Yakob hari na, “Mata ku aꞌa! Èu subha uuru ku, dhu peka na, èu pangèdꞌu le hak aꞌa èèna mi jaꞌa ne.” Ka Esau dedꞌe subha sèmi dhu Yakob peka. ");
INSERT INTO nfa_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Hèia Yakob sodꞌe dènge ka hia ne bubur kabꞌui deo na dènge roti. Ropa naꞌa-ninu nare, ka laꞌe dènge ka. Dènge jꞌara neꞌe ka, Esau pusi boe dènge hak aꞌa na. ");
INSERT INTO nfa_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ca tèka, ètu dꞌara rai èèna, lèke tèu manganga, èci èèna ka dènge tèu Abraham mamuri era. Ka Isak laꞌe manèngi Abimelek, dhèu aae Pilistin, sèna ka na pea ètu Gerar. ");
INSERT INTO nfa_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Na tao sèmi èèna, lula LAMATUA dhu padꞌelo le iisi Na mi nèngu, peka na, “Mage lamu ka asa Masir hèi. Pea la mi era dhu èèna na Jaꞌa pajꞌujꞌu hia èu. ");
INSERT INTO nfa_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Ladhe èu manubha ètu era èèna, Jaꞌa sama-sama dènge èu, aa pala-bagi èu mèngi-nale rupa-rupa. Èèna na, Jaꞌa pabèba ana-èpu èu sama sèmi hua-hètu ètu dedha-liru. Aa Jaꞌa hia kateme rai ne mi èu dènge ana-èpu èu. Nèti ana-èpu èu ka, dhèu aaꞌi-aaꞌi ètu rai-haha ne abhu mèngi-nale. Dènge jꞌara neꞌe, Jaꞌa tao madhutu lii pajaji dhu Jaꞌa paꞌèki le dènge ama mu Abraham. ");
INSERT INTO nfa_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Jaꞌa tao sèmi neꞌe ne, lula ama mu madhutu dadꞌèi Jaꞌa, paredha Jaꞌa, dènge atora Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ka Isak pea taha ètu Gerar. ");
INSERT INTO nfa_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ribka ne, bhèni iia titu kèna. Ka ropa dhèu ètu Gerar ladhe rèdhi ne, ra pakarèi. Te ngaa Isak peka na, “Ribka ne, ana hèni jaꞌa.” Na madhaꞌu, ladhe na peka na dhèu èmu nèngu, dhèu se pamadhe ne, aa Ribka parame rare. ");
INSERT INTO nfa_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak dhu pea nèbhu le ètu nèi, hèia ca lodꞌo, dhèu aae nèdhi nèti roꞌa jendela na, ladhe laa na Isak dènge Ribka dhu paꞌango. ");
INSERT INTO nfa_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ka na pua dhèu lasi paroa Isak, hèia na peka, “Isak! Jaꞌa dhu keꞌa le, bhèni ne dhèu èmu èu! Te ngaa tasamia ka, èu peka na, nèngu ne ana hèni èu?” Hèia Isak dhaa, aku nèngu na, “Sèmi neꞌe ama! Jaꞌa ne madhaꞌu, ladhe jaꞌa peka na nèngu ne dhèu èmu jaꞌa, mage dhoka dhèu pamadhe jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ka dhèu aae dhaa, peka na, “Sèmi dhèu ètu seꞌe jꞌunu dènge dhèu èmu èu, tatu èu pasala jiꞌi! Tasamia ka, èu adꞌu jꞌara neꞌe mi dedha jiꞌi se?” ");
INSERT INTO nfa_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Èle èèna ka, dhèu aae Abimelek pasanèdꞌe ana kabarai na, aku nèngu na, “Miu nanene paie-iie! Cee ka dhu bani gagu dhèu neꞌe, do dhèu èmu na, èèna na jaꞌa huku pamadhe ne.” ");
INSERT INTO nfa_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Tèu èèna, Isak sèle hini ètu dedha rai dhèu seꞌe. Lodꞌo dꞌai puu-gꞌètu, ka na abhu isi rai cangasu hari, lula LAMATUA hia ne mamèngi. ");
INSERT INTO nfa_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Lula mèdha-panyau na asa ae, ka na kaja titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Badha-manu na sèmi sapi, kahibꞌi-kalèbho asa tabha ae. Dhèu-dhèu sabꞌa na, ae kahèi. Nèti èèna ka, dhèu Pilistin tèka dꞌara dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Uru èèna, Abraham, ama Isak, dhu kèi èi ae-ae. Te ngaa limuri ne, dhèu Pilistin dhènu eele aaꞌi si dènge rai. ");
INSERT INTO nfa_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ka dhèu aae Abimelek peka dènge Isak, aku nèngu na, “Isak! Beꞌa risi èu pakèdꞌi ka nèti kabarai neꞌe. Lula koasa èu, risi eele le nèti jiꞌi se.” ");
INSERT INTO nfa_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Èle èèna ka, Isak pakèdꞌi nèti era èèna, ka lasi pea hari ètu dꞌara mamoo Gerar. ");
INSERT INTO nfa_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ètu era neꞌe, ra kèi hari madha èi dhu uru èèna, dhèu Pilistin dhènu eele aaꞌi si. Ka na pangare madha èi se madhutu ngara dhu ama na pangare. ");
INSERT INTO nfa_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ropa dhèu sabꞌa Isak se kèi èi ètu dꞌara mamoo Gerar, hèi lèke èi madha dhu sabhoka mai. ");
INSERT INTO nfa_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Lula madha èi neꞌe ka, dhèu-dhèu madhenge badha nèti Gerar, patao dènge dhèu madhenge badha Isak. Dhèu se peka na, “Neꞌe ne, madha èi jiꞌi!” Nèti èèna ka, Isak pangare madha èi na Esek, dhu sasoa na ‘patao-palaha’. ");
INSERT INTO nfa_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hèia dhèu-dhèu Isak se, kèi hari èi leo ca madha. Te ngaa ra patao-palaha hari, lula èi èèna. Nèti èèna ka, Isak pangare na Sitna, dhu sasoa na ‘palabꞌa’. ");
INSERT INTO nfa_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Èle èèna ka, Isak tèke eele era èèna, laꞌe kèi hari èi èci. Dꞌai neꞌe ne, ra patao-palaha heka. Ka Isak pangare madha èi ne Rehobot, dhu sasoa na ‘era taleo’. Hèia na peka, aku nèngu na, “Limuri ne, Lamatua hia le èdhi pea ètu era taleo. Ho ètu era neꞌe ne, èdhi asa bèba-kacanga.” ");
INSERT INTO nfa_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ka nèti era neꞌe, Isak si lasi hari era pea asa Beer Syeba. ");
INSERT INTO nfa_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ka mèda na, LAMATUA padꞌelo iisi Na mi Isak, hèia Na peka, “Isak! Jaꞌa ne, Ama Lamatua nèti ama mu Abraham. De mage mu madhaꞌu, te Jaꞌa ladhe-leru èu. Èèna na, Jaꞌa pala-bagi èu mèngi-nale. Aa ana-èpu èu asa bèba-kacanga. Jaꞌa adꞌu madha jꞌara neꞌe, lula lii pajaji Jaꞌa dènge ama mu.” ");
INSERT INTO nfa_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hèia Isak pudhi hadhu, tao mei korban ètu èèna. Ka na manèngi makasi mi LAMATUA. Hèia, na pea ètu era èèna, ka dhèu sabꞌa na kèi hari èi. ");
INSERT INTO nfa_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Lodꞌo èèna, dhèu aae Abimelek mai nèti Gerar. Angalai na Ahusat, dènge kètu kapai sordadꞌu na, Fikol, mai dènge ne, ho paraga dènge Isak. ");
INSERT INTO nfa_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ka Isak karèi, aku nèngu na, “Ama dhèu aae! Uru èèna, miu se dhu babège eele jaꞌa nèti kabarai miu. De neꞌe ne, miu se mai tao ngaa hari?” ");
INSERT INTO nfa_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Hèia ra peka na, “Sèmi neꞌe. Jiꞌi dhu ngeꞌa le, Lamatua dhu jꞌaga paꞌère èu. Nèti èèna ka, jiꞌi pangee, hua iia èdhi dua ti paꞌèki lii pajaji dhu peka sèmi neꞌe: èu jꞌoka subha, peka na, ");
INSERT INTO nfa_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","miu se baku tao karehe dènge jiꞌi, aa jiꞌi kahèi baku tao karehe dènge miu. Mema jiꞌi se dꞌara beꞌa dènge miu. Nèti èèna ka, ca hari ni, miu se lami dènge mera-milu nèti kabarai jiꞌi ne. Jiꞌi dhu ngeꞌa le, LAMATUA ka dhu pala-bagi mèngi-nale mi miu.” ");
INSERT INTO nfa_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Èle èèna ka, Isak tao pesta, ka raꞌa-rinu aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ka asa bèli madꞌae èèna, rèngu jꞌoka lii soo-subha. Hèia Isak patalala si lèpa dènge dame. ");
INSERT INTO nfa_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Lodꞌo èèna kahèi, dhèu sabꞌa Isak mai peka lula-nèti èi dhu rèngu kèi, na, “Ama! Jiꞌi rage le èi.” ");
INSERT INTO nfa_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Hèia Isak pangare madha èi ne Syeba (dhu sasoa na ‘subha’). Ka ra pangare kota èèna Beer Syeba, toke sange neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ropa umur Esau dꞌai èpa nguru tèu, na leo dènge bhèni dhèu dua nèti suku Het. Bhèni èci, ana nèti Beeri, ngara na Yudit. Èci hari, ana Elon, ngara na Basmat. ");
INSERT INTO nfa_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bhèni dhèu dua se, papèdꞌa dꞌara Isak dènge Ribka. ");
INSERT INTO nfa_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ropa Isak manahu asa dꞌara heka, nèdhi heka ngaa-ngaa, lula musi madha na ahu le. Ka na paroa ana uuru èèna, dhu na sue risi èèna, peka na, “Esau. Mai ku sa neꞌe!” Hèia Esau dhaa, aku nèngu na, “Tasamia, ama?” ");
INSERT INTO nfa_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ka Isak peka hari, “Sèmi neꞌe! Jaꞌa ne, ètu dꞌara heka le. Keꞌa boe, pèri lodꞌo jaꞌa ne madhe. ");
INSERT INTO nfa_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","De more rèka èu, lamu kataki mèti badha hui ciꞌu hia jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mu pananasu pabeꞌa-beꞌa, madhutu dadꞌèi jaꞌa, ho mèti mai hia jaꞌa. Ladhe kuꞌa-kinu kora, jaꞌa hia mema èu mèngi-nale. Sadꞌi èu unu le mèngi-nale èèna, jaꞌa madhe èèna ka, ngaa-ngaa tao heka.” ");
INSERT INTO nfa_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Hèia Esau laꞌe dènge ka, kataki badha hui. Te ngaa Ribka dhu tadèngi kahèi lii padhai Isak deo na. ");
INSERT INTO nfa_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ka Ribka laꞌe peka dènge Yakob, aku nèngu na, “Yakob! Èu nanene ku! Deo na, jaꞌa tadèngi ama mu pua Esau sèmi neꞌe: ");
INSERT INTO nfa_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Lamu kataki more ku badha hui ciꞌu, mai mu pananasu pabeꞌa-beꞌa hia jaꞌa. Ladhe kuꞌa-kinu kora, jaꞌa hia èu mèngi-nale ètu katanga madha LAMATUA.’ ");
INSERT INTO nfa_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","De mu nanene paie-iie! Mu madhutu mola-mola lii paredha jaꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","De lamu ka asa era badha èdhi sèi, ho kèpe more kalèbho èni dhu kabèbꞌu dua ngiꞌu. Roro ho mèti sisi mai asa jaꞌa. Pe jaꞌa pananasu madhutu dadꞌèi ama mu. ");
INSERT INTO nfa_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ladhe panasu kore, mèti hia ama mu naꞌa. Ho èle na, na hia èu mèngi-nale, heka na madhe kèna. Dènge sèmi neꞌe ka, èu ka dhu abhu mèngi-nale èèna. Aꞌa mu abhu boe.” ");
INSERT INTO nfa_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Te ngaa Yakob peka dènge ina na, “Ina! Aꞌa ku Esau, ngiꞌu na dhu pènu dènge rèu, te ngaa jaꞌa ne, isi dhu milu aadha-aadha! ");
INSERT INTO nfa_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mage dhoka ama ku gꞌagꞌe isi jaꞌa, ladhe na neꞌa na jaꞌa dhu leko-monya na. Hèia na dhoo jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ka ina na dhaa, aku nèngu na, “Èu baku cagꞌagꞌa! Hudꞌi laa ina ka dhu ator! Ladhe ama mu dhoo èu, pe ina ka pasae! Mu mate ia ka, la more ka kahibꞌi sèra.” ");
INSERT INTO nfa_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ka Yakob laꞌe nare kahibꞌi dua ngiꞌu sèra, hèia na roro, ka nèti hia ina na. Hèia Ribka pananasu madhutu dadꞌèi Isak. ");
INSERT INTO nfa_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ka Ribka laꞌe nare mèdha-papake Esau dhu beꞌa, ho na papake mi Yakob. ");
INSERT INTO nfa_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Hèia na pahutu kahèi kacui-aai dènge ladhe goro Yakob, pake kaꞌuri kahibꞌi deo sa. ");
INSERT INTO nfa_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ka na pangèdꞌu Yakob ngangaꞌa dhu pananasu nare deo na, dènge roti dhu tunu nare. ");
INSERT INTO nfa_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Hèia Yakob dedꞌe nèti ngangaꞌa seꞌe, hia ama na naꞌa. Ka na lii, aku nèngu na, “Ama. Jaꞌa mai hari le.” Hèia Isak dhaa, peka na, “Hee! Èu ne, cee?” ");
INSERT INTO nfa_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ka Yakob dhaa, peka na, “Jaꞌa, Esau ana mone uuru ama ku! Jaꞌa sabꞌe le, madhutu sèmi dhu ama pua deo na. Kèdꞌi, ho muꞌa-minu ka. Lula jaꞌa pananasu kore le sisi badha hui dhu jaꞌa kèti nèti dꞌara jꞌami. Muꞌa, ho èle na, ama pala-bagi jaꞌa mèngi-nale.” ");
INSERT INTO nfa_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Hèia Isak peka, aku nèngu na, “Èu ne, bia tai nga! Abhu malai titu kèna, badha hui èèna!” Hèia Yakob dhaa, “Jaꞌa abhu le, lula LAMATUA dhu èu mangajꞌi èèna, ka dhu tulu jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ka Isak paroa Yakob, aku nèngu na, “Padètu ku asa neꞌe mai, sèna ka jaꞌa gꞌagꞌe sèku èu. Èu ne, tareꞌa ana jaꞌa Esau, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Hèia Yakob laꞌe padètu-dètu dènge ama na, ka ama na gꞌagꞌe ne. Ka Isak peka, “Lii ne, sèmi lii Yakob! Te ngaa kacui-aai na, kacui-aai Esau.” ");
INSERT INTO nfa_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Te ngaa Isak dhu tadhe iia boe Yakob, lula kacui-aai na rèu sèmi Esau. Ka ropa na neo hia mèngi-nale mi Yakob, ");
INSERT INTO nfa_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","na karèi hari era, aku nèngu na, “Èu ne, tareꞌa-reꞌa Esau, do?” Hèia Yakob dhaa, peka na, “Tareꞌa-reꞌa ama. Jaꞌa ne, Esau!” ");
INSERT INTO nfa_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ka Isak peka na, “Na, jꞌole ka sisina mai, sèna ka jaꞌa kuꞌa. Èle ku, pe jaꞌa hia èu mèngi-nale.” Hèia Yakob hia sisi dènge èi anggor hia ama na naꞌa-ninu. ");
INSERT INTO nfa_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Naꞌa nare ka, Isak lii, aku nèngu na, “Ana, ee! Mai padètu asa neꞌe, ho mu uu ku jaꞌa laa.” ");
INSERT INTO nfa_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ka ropa Yakob padètu dènge ne, ho uu ne, Isak sangèdꞌu nare hèu mèdha-papake Esau. Hèia na padhai lii hia mèngi-nale mi Yakob, aku nèngu na, “Hèu ana jaꞌa tareꞌa-reꞌa sèmi hèu jꞌuꞌu ètu dꞌara padꞌa, dhu abhu mamèngi nèti LAMATUA. ");
INSERT INTO nfa_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hudꞌi laa Ama Lamatua patiri èi paringi nèti dedha-liru, sèna ka oka-tedhe èu jꞌajꞌi mi rai hèu mèngi. Hudꞌi laa Na hia èu are dhu udhu sobhu-sobhu, dènge hua anggor dhu pènu ako-pènu èru. ");
INSERT INTO nfa_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Suku-suku jꞌajꞌi mi ènu èu, Aa dhèu-dhèu leo pahaha iisi mi dedha èu. Èu jꞌajꞌi mi lamatua nèti aꞌari èu. Aa rèngu patitu kètu urutuu ètu madha èu. Dhèu cee dhu dhoo èu, rèngu abhu dhoo kahèi. Aa dhèu cee dhu hia mèngi-nale mi èu, rèngu abhu mèngi-nale kahèi.” ");
INSERT INTO nfa_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ropa Isak hia nare mèngi-nale mi Yakob, ka heka bhodho liꞌu laꞌe tèke eele ama na, cagꞌagꞌa laa Esau lèpa nèti kataki badha hui. ");
INSERT INTO nfa_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Hèia laꞌe pananasu, ka sodꞌe nèti hia ama na. Ka na parèi ama na, aku nèngu na, “Ama, kèdꞌi muꞌa. Jaꞌa lalau kore le sisi badha dhu jaꞌa kataki kore. Muꞌa more ku, pe hia jaꞌa berkat.” ");
INSERT INTO nfa_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Te ngaa Isak malaa, ka na karèi, “Hee! Te èu ne, cee hari ne?” Hèia Esau dhaa, aku nèngu na, “Jaꞌa neꞌe, Esau! Ana uuru ama ku.” ");
INSERT INTO nfa_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ka Isak cagꞌagꞌa, hèia na karèi, aku nèngu na, “Ladhe sèmi èèna, deo na cee ka dhu hia jaꞌa sisi, ka jaꞌa kuꞌa èèna? Ka jaꞌa hia ne mèngi-nale. Aa mèngi-nale èèna, bisa heka ère hari.” ");
INSERT INTO nfa_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ropa tadèngi nare, Esau roe ai ca palèpa, ka na tangi dꞌara pèdꞌa dènge roma iisi, aku nèngu na, “Tasamia ne, ama, ee! Bagi hia jaꞌa berkat hèi ma.” ");
INSERT INTO nfa_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Hèia Isak peka, “Ari mu ka monya jaꞌa, ka parame nare berkat dhu pala èu di.” ");
INSERT INTO nfa_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ka aku Esau na, “Nèngu na leko-monya jaꞌa dua hari kèna. Uru èèna, parame nare hak aꞌa. Ka neꞌe ne, parame nare hari berkat dhu madhutu iia-iia na unu jaꞌa. Nèka na, ngara na ‘Yakob’ Te ngaa ele boe ama dhu dènge berkat era, ho hia jaꞌa. Do, aadꞌo heka?” (Yakob sasoa na ‘kèpe hui tèdhu’, te ngaa sasoa dhu leo ‘tuka leko-monya’.) ");
INSERT INTO nfa_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Hèia Isak dhaa, aku nèngu na, “Jaꞌa dhu dedꞌe le nèngu, jꞌajꞌi lamatua èu. Aa aꞌari na aaꞌi-aaꞌi ra, jꞌajꞌi mi ènu na. Jaꞌa hia na le, unu are pènu soka-pènu karo, dènge hua anggor pènu ako-pènu èru. De ana, ee! Mamèngi tasamia hari, dhu jaꞌa ne pala-bagi mi èu?” ");
INSERT INTO nfa_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Masi ka tadèngi nare le sèmi èèna, te ngaa Esau loe boe dènge pamako ama na, peka na, “Mamèngi na dhodhoka èci di, do? Tatu ama dènge hari mamèngi dhu leo hia jaꞌa. Masi ka ciki ooꞌe èèna ka, sadꞌi jaꞌa ne abhu!” Ka Esau tangi hari dènge dꞌara laho mae-mae. ");
INSERT INTO nfa_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ka Isak bꞌala ne, peka na, “Mamuri èu ne, èèna na kajꞌèu nèti oka-tedhe dhu hèu mèngi, lula èi paringi patiri boe nèti dedha-liru mai, ho pabasa rai èu. ");
INSERT INTO nfa_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Èu ne, mamuri dhoka nèti samala èu di. Aa tasa mera mia èèna ka, èu ne jꞌajꞌi ènu ari mu. Dhodhoka ladhe bèli-camèdꞌa, èu bani labꞌa ne, èèna na èu heka rai eele nèti dꞌara adhe-aai na.” ");
INSERT INTO nfa_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Lula jꞌara sèmi neꞌe ne ka, Esau tèke dꞌara dènge ari na Yakob, lula parame nare mamèngi na. Ka Esau pangee na, “Nèbhu heka, ama ku madhe. De hudꞌi laa, pe dꞌai ku lodꞌo. Ladhe èle beke, jaꞌa pamadhe ne!” ");
INSERT INTO nfa_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Ropa Ribka tadèngi Esau dhu neo adꞌu jꞌara karehe, ka na peka dènge Yakob, aku nèngu na, “Èu nanene ku lii ne! Aꞌa mu neo bꞌala dꞌara pèdꞌa na, de na neo pamadhe èu. De beꞌa risi, èu ne rai lai-lai asa toꞌo mu Laban, ètu kota Haran. ");
INSERT INTO nfa_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Lamu asa nèi, pea ako nèbhu, toke èle nanasa aꞌa mu. ");
INSERT INTO nfa_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ladhe na bhèlu eele ku tatao èu ne, pe jaꞌa pua dhèu dhiu paroa èu, sèna ka èu lèpa hari mai. Lula jaꞌa koꞌo boe, sèna ka ana jaꞌa dua-dua mi ele parènga dꞌara ca lodꞌo èèna ka.” ");
INSERT INTO nfa_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hèia Ribka roma iisi dènge Isak, peka na, “Jaꞌa ruꞌa le dènge dhèu èmu Esau, dhèu Het se! De ladhe Yakob todhe nare hari kahèi ana bhèni nèti dhèu Het se, hua iia jaꞌa madhe ka laa.” ");
INSERT INTO nfa_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hèia Isak paroa nare Yakob, ka hia ne mèngi-nale aa holo ne, peka na, “Sanèdꞌe paie! Èu mage leo ka dènge ana bhèni Kanaꞌan hèi. ");
INSERT INTO nfa_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","De lamu ka asa Padan Aram, asa baki mu Betuel. Lamu madhèdi dènge ana bhèni toꞌo mu Laban ca dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Hudꞌi laa Ama Lamatua dhu Koasa Risi Eele na, hia èu mamèngi, sèna ka ana-èpu èu bèba-kacanga, ho nèti rèngu ka jꞌajꞌi suku ae-ae dhu kapai. ");
INSERT INTO nfa_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Hudꞌi laa, lii pajaji Ama Lamatua dènge Abraham èèna, noto mi dedha èu ne, dènge ana-èpu èu. Sèna ka èu unu rai dhu Ama Lamatua jaji tèke le mi Abraham.” ");
INSERT INTO nfa_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Padhai lii nare, ka Isak hia Yakob laꞌe asa Padan Aram, asa èmu toꞌo na Laban, dènge baki na Betuel. ");
INSERT INTO nfa_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau dhu tadèngi le kahèi, dhu peka na Isak hia Yakob mamèngi, aa kai ne sèna ka baku leo dènge bhèni Kanaꞌan. Aa na tadèngi hèi, dhu Isak hia Yakob leo dènge ana bhèni toꞌo na Laban ètu Padan Aram. ");
INSERT INTO nfa_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ka Yakob madhutu lii paredha ina dènge ama na, ka pakèdꞌi laꞌe asa Padan Aram. ");
INSERT INTO nfa_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Aa Esau dhu neꞌa le kahèi, ama na dꞌèi boe dhèu èmu na, bhèni Kanaꞌan dua sèra. ");
INSERT INTO nfa_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hèia na laꞌe asa ama aae na Ismael, ka leo hari èmu dènge ana bhèni Ismael ca dhèu, ngara na Mahalat. Mahalat ne, ana mone na ka Nebayot. ");
INSERT INTO nfa_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ka Yakob tèke eele Beer Syeba, laꞌe asa Haran. ");
INSERT INTO nfa_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ropa lodꞌo cèna, Yakob dꞌai era èci, ka na jꞌunu ètu era èèna. Na neo jꞌunu, nare hadhu cue, tao lalaka kètu na. ");
INSERT INTO nfa_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Dꞌara mèda èèna, na nii. Na ladhe nèdhi langa èci dhu patitu ètu rai, suu na dꞌai dedha-liru. Ka ana pajuu Ama Lamatua nèti sorga, caꞌe-puru ètu dedha langa èèna. ");
INSERT INTO nfa_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ètu dꞌara nii na, Yakob ladhe nèdhi LAMATUA dhu titu ètu karasa nèngu, hèia na lii, aku nèngu na, “Jaꞌa ne LAMATUA, Ama Lamatua nèti baki mu Abraham, dènge ama mu Isak. Èèna na, Jaꞌa hia rai ne mi èu dènge ana-èpu èu. ");
INSERT INTO nfa_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Bèli-camèdꞌa, ana-èpu èu ae-ae, sama sèmi ahu rai ne. Rèngu se, èèna na, pea palème era-era ètu rai-haha ne. Nèti ana-èpu èu ka, suku aaꞌi-aaꞌi ètu rai-haha ne, abhu mèngi-nale. ");
INSERT INTO nfa_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mage mu bhèlu! Èu ne ètu mia èèna ka, Jaꞌa bera-bera dènge èu. Ladhe èèna na, Jaꞌa lere kèti hari èu mai asa dedha-rai neꞌe. Jaꞌa bhera boe èu. Aa èèna na, Jaꞌa tao aaꞌi madhutu sèmi lii pajaji Jaꞌa dènge èu.” ");
INSERT INTO nfa_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ropa Yakob kèdꞌi nèti bhèjꞌi, na padhai lii, aku nèngu na, “Jaꞌa heka keꞌa kèna, LAMATUA dhu ètu era neꞌe kahèi.” ");
INSERT INTO nfa_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Na madhaꞌu, ka na pangee, na, “Boo! Era neꞌe ne pamadhaꞌu jaꞌa, nga. Tatu Èmu Ama Lamatua ètu era neꞌe ne! Aa era neꞌe ne, jꞌajꞌi hèbꞌa babèdho sorga.” ");
INSERT INTO nfa_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Dꞌara madꞌae aae era, Yakob kèdꞌi le èèna. Ka nare hadhu dhu na tao lalaka deo na. Hèia na patitu jꞌajꞌi mi tadha. Ka na bhori èi mènyi asa dedha hadhu èèna, hèia na mangajꞌi mi Lamatua. ");
INSERT INTO nfa_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ka na pangare era ne Betel, dhu sasoa na ‘Èmu Lamatua’. (Uru èèna, era ne ngara na Lus.) ");
INSERT INTO nfa_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Èle èèna ka, Yakob dedꞌe subha, aku nèngu na, “Ladhe Ama Lamatua dhu dènge jaꞌa, aa jꞌaga jaꞌa ètu dꞌara kakako jaꞌa ne, aa pangaꞌe dènge papake jaꞌa, ");
INSERT INTO nfa_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","toke jaꞌa lèpa dènge sodꞌa, èèna na LAMATUA jꞌajꞌi mi Ama Lamatua jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Hadhu dhu jaꞌa patitu ne, jꞌajꞌi mi era sogo-tagu mi Ama Lamatua. Aa aaꞌi-aaꞌi dhu Lamatua pala-bagi mi jaꞌa, jaꞌa hia Na ca pala nèti canguru pala.” ");
INSERT INTO nfa_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hèia Yakob kako hari ka asa bèka dhimu. ");
INSERT INTO nfa_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ca lodꞌo, ladhe nèdhi èi ca madha, dètu dènge rae cue. Padètu-dètu dènge madha èi èèna, abhu tèlu kaboko kahibꞌi-kalèbho, dhu mate rinu èi. Te ngaa hadhu aae cue dhu ra pasaguru mi hèbꞌa èi na. ");
INSERT INTO nfa_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Dhu tema le, ladhe kahibꞌi tesa aaꞌi-aaꞌi ra, ana-ana madhenga kahibꞌi se, lasi bhoke hadhu na, heka ra dhui kèna, panginu kahibꞌi si. Panginu rare na, ra katange hari hadhu na laꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ka Yakob kako laꞌe asa madha dhèu madhenge kahibꞌi se, hèia na karèi, aku nèngu na, “Miu se, dhèu mia?” Hèia ra dhaa, “Jiꞌi se, nèti rae Haran neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ka Yakob karèi hari, aku nèngu na, “Miu tadhe toꞌo jaꞌa, Laban, do? Nèngu na, ana Nahor.” Ka ra dhaa, “Jiꞌi tadhe ne.” ");
INSERT INTO nfa_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Hèia Yakob karèi hari, aku nèngu na, “Na beꞌa-beꞌa, sina ma?” Ka ra peka, “Oo, na beꞌa-beꞌa. Ladhe, ana bhèni na ka nèi. Ngara na, Rahel. Nuka eo nèti kahibꞌi ama na mai sa neꞌe, ho hia rinu ètu neꞌe. Mate ne.” ");
INSERT INTO nfa_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Hèia Yakob peka hari, “Loo nètu era. De beꞌa risi, badha mia ètu seꞌe le, panginu ka si. Sèna ka lere mèti hari asa dꞌara padꞌa, ho raꞌa hari jꞌuꞌu.” ");
INSERT INTO nfa_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Te ngaa ra peka, “We, jꞌara na aadꞌo sèmi èèna! Jiꞌi mate toke tesa aaꞌi ku, heka jiꞌi pakeso hadhu ne, heka panginu badha se kèna.” ");
INSERT INTO nfa_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob padhai lii era, Rahel dꞌai le era èèna dènge kahibꞌi ama na. Nèngu ka dhu biasa ladhe-leru si. ");
INSERT INTO nfa_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ropa Yakob nèdhi Rahel dènge kahibꞌi sèra, laꞌe dènge ka paꞌeso eele hadhu dhu saguru hèbꞌa èi na. Ka na panginu badha toꞌo na sèra. ");
INSERT INTO nfa_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Èle ka, laꞌe uu Rahel, dènge tangi. ");
INSERT INTO nfa_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ka na lolo dènge Rahel, aku nèngu na, “Ari! Jaꞌa ne, ana nèti Ribka, ana hèni ama mu.” Hèia Rahel rai sa èmu laꞌe, peka dènge ama na. ");
INSERT INTO nfa_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ropa Laban tadèngi lii lolo Rahel, dhu peka na Yakob ana nèti ana hèni na Ribka, ka laꞌe dènge ka, soru nare Yakob. Ropa na dꞌai, liku nare Yakob, ka na uu, hèia gale nèti dènge ka, lasi asa èmu na. Ka Yakob lolo aaꞌi-aaꞌi dènge toꞌo na. ");
INSERT INTO nfa_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Hèia Laban lii, aku nèngu na, “Mema tareꞌa! Èdhi dua ti dhu paꞌaꞌari.” ");
INSERT INTO nfa_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Ropa Yakob pea dènge rèngu dꞌai ca hèru, ");
INSERT INTO nfa_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban padhai lii dènge ne, aku nèngu na, “Yakob! Jaꞌa koꞌo boe, sèna ka èu sabꞌa hia jaꞌa dènge iia-iia dꞌara, lula èdhi se dhu paꞌaꞌari. De èu neo sèna ka rui-jꞌajꞌèra èu jaꞌa bꞌae ca ngaa?” ");
INSERT INTO nfa_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban ne, dhu dènge ana bhèni dhèu dua. Dhu uru, ngara na Lea. Aa ari na, ngara na Rahel. ");
INSERT INTO nfa_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea ne, musi madha na ako ahu. Te ngaa Rahel, rèhu na bhèni iia, aa ngiꞌu na saraga bia. ");
INSERT INTO nfa_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob dꞌèi risi Rahel. Ka na peka dènge Laban, “Ladhe toꞌo ku moꞌo, jaꞌa sabꞌa hia toꞌo ku pidhu tèu, sadꞌi toꞌo ku hia jaꞌa madhèdi dènge Rahel.” ");
INSERT INTO nfa_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Hèia Laban dhaa, aku nèngu na, “Jaꞌa koꞌo! Beꞌa risi, jaꞌa paleo èu dènge Rahel, lula èdhi dua ti dhu aꞌari. Mage dhoka na madhèdi dènge dhèu leo. De mu pea mi neꞌe, sèna ka sabꞌa hia jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ka Yakob sabꞌa hia Laban pidhu tèu, sèna ka na bisa madhèdi dènge Rahel. Lula na dꞌèi madhe-madhe Rahel, nèti èèna ka, pidhu tèu èèna, na pangee nuka sèmi pèri-pèri lodꞌo di. ");
INSERT INTO nfa_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ropa risi nèti pidhu tèu, ka na pasanèdꞌe Laban, aku nèngu na, “Toꞌo! Jaꞌa sabꞌa le hia toꞌo ku pidhu tèu, de paleo ka jaꞌa dènge Rahel.” ");
INSERT INTO nfa_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Hèia Laban tao tatao, ka na nèru aaꞌi rae lesa ètu rae èèna. ");
INSERT INTO nfa_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Ropa dꞌai mèda èèna, Laban hia boe Rahel, te ngaa na pua Lea maso asa dꞌara paleo Yakob. Ka Yakob jꞌunu dènge ne. Asa bèli èèna, Yakob heka neꞌa kèna, nèngu dhu leo dènge Lea di. Hèia Yakob laꞌe patao dènge Laban, aku nèngu na, “Nga tao ka, toꞌo pasèru jaꞌa sèmi neꞌe? Jaꞌa sabꞌa sèmi ènu pidhu tèu kateme hia mi èu, sèna ka bisa abhu Rahel! Nga tao ka toꞌo pasilu dènge Lea?” Ka Laban dhaa, “Baku nasa ku! Madhutu adꞌa jiꞌi ètu rai neꞌe, ari bisa boe leo uuru èmu nèti aꞌa. De beꞌa risi sèmi neꞌe! Èu mate hari ku pidhu lodꞌo, dꞌai èle tatao ne, heka èu abhu Rahel kèna. Sadꞌi èu sabꞌa hari hia jaꞌa pidhu tèu.” Hèia Laban pangèdꞌu dènge ènu bhèni èci, hia mi Lea. Ngara na Silpa. ");
INSERT INTO nfa_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Lii padhai Laban deo na, Yakob dꞌèi kahèi. Nèti èèna ka, èle tatao ne pidhu lodꞌo, ka Laban pamadhèdi hari Yakob dènge Rahel. ");
INSERT INTO nfa_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ka Laban hia ènu na dhèu bhèni èci, ngara na Bilha, sèna ka jꞌajꞌi mi ènu Rahel. ");
INSERT INTO nfa_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Hèia Yakob paꞌèci ka dènge Rahel. Na dꞌèi risi Rahel nèti Lea. Ka Yakob sabꞌa hari hia toꞌo na pidhu tèu. ");
INSERT INTO nfa_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Te ngaa LAMATUA neꞌa le, Yakob sue risi Rahel nèti Lea. Nèti èèna ka, Na hia Lea nara iisi ana. Te ngaa Rahel abhu boe ana. ");
INSERT INTO nfa_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Hèia Lea dènge babia, ka nara iisi ana mone ca dhèu. Na pangare ne, Ruben (dhu sasoa na ‘mèdhi si, abhu ana’), lula na peka na, “LAMATUA ladhe nèdhi le sasusa jaꞌa. Nèti èèna ka, limuri ne, dhèu èmu jaꞌa tao madha-dhilu mi jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ka Lea dènge hari babia, hèia nara iisi hari ana mone èci. Na pangare ne, Simeon (dhu sasoa na, ele boe ‘dhèu tadèngi le’), lula na peka na, “LAMATUA dhu neꞌa na, dhèu èmu jaꞌa sue boe jaꞌa. Tu dꞌai èèna ka, Na hia jaꞌa ana dhèu èci hari.” ");
INSERT INTO nfa_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Èle èèna ka, Lea kadꞌo hari ana èci, ka nara iisi ana mone ca dhèu. Na pangare na Lewi, lula na peka na, “Dènge ana neꞌe ne, èle dènge lii langu jaꞌa. Dꞌara dhèu èmu jaꞌa, paꞌèki dènge jaꞌa, lula jaꞌa matana hia ne ana mone, dhèu tèlu kèna.” ");
INSERT INTO nfa_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ka Lea dènge hari babia ca tèka, hèia nara iisi ana mone èci. Na pangare na, Yahuda (dhu sasoa na ele boe ‘koa-kio’), lula na peka na, “Dènge jꞌara neꞌe ne, jaꞌa neo koa-kio LAMATUA!” Èle ka, Lea dènge heka ana. ");
INSERT INTO nfa_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Te ngaa Rahel dhu abhu mèka ana. Nèti èèna ka, nèngu tèke dꞌara dènge aꞌa na. Hèia na peka dènge dhèu èmu na, “Aꞌa! Hia ku jaꞌa ana laa, ma. Ladhe aadꞌo, beꞌa risi jaꞌa madhe ka laa.” ");
INSERT INTO nfa_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Te ngaa Yakob jèke ne, aku nèngu na, “Èu ngee na, jaꞌa ne, Lamatua, ho bisa hia èu ana!?” ");
INSERT INTO nfa_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ka Rahel bꞌala na, “Sèmi neꞌe: hua iia èu more Bilha, ènu jaꞌa na. Jꞌunu dènge ne, sèna ka na matana hia jaꞌa ana.” ");
INSERT INTO nfa_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Hèia na pangèdꞌu Bilha mi dhèu èmu na. Ka Yakob jꞌunu dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ka Bilha dènge babia, hèia nara iisi ana mone ca dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Hèia Rahel padhai lii, aku nèngu na, “Ama Lamatua nanene le lii manèngi-mangajꞌi jaꞌa. Nèti èèna ka, Na hia jaꞌa ana mone ca dhèu. Ama Lamatua pamaꞌète le, lii langu jaꞌa dènge mola-mola.” Ka na pangare ana ne, Dan (dhu sasoa na ‘pamaꞌète lii’). ");
INSERT INTO nfa_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Èle èèna ka, Bilha dènge hari babia, ka nara iisi ana mone èci. ");
INSERT INTO nfa_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ka Rahel peka, aku nèngu na, “Jaꞌa limuri ne paꞌuji dènge aꞌa ku, ka jaꞌa segi.” Nèti èèna ka, na pangare ana na, Naftali (dhu sasoa na ‘paꞌuji’, do ‘paꞌère’). ");
INSERT INTO nfa_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ropa Lea neꞌa na nèngu ne dènge heka ana, ka na paleo ènu na Silpa dènge Yakob. ");
INSERT INTO nfa_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ka Silpa nara iisi ana mone ca dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Hèia Lea peka na, “Kalua jaꞌa, mèngi le.” Ka na pangare na, Gad (dhu sasoa na ‘kalua mèngi’). ");
INSERT INTO nfa_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ka Silpa nara iisi hari ana mone èci. ");
INSERT INTO nfa_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Hèia Lea padhai lii, peka na, “Waa! Limuri ne, jaꞌa heka karejꞌe kèna! Mi laladhe ee, te bèli-camèdꞌa, dhèu bhèni aaꞌi-aaꞌi ra, peka na jaꞌa ne oto bia.” Nèti èèna ka, na pangare ana ne, Aser (dhu sasoa na ‘karejꞌe’). ");
INSERT INTO nfa_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ca lodꞌo, lèke dènge hèru puu-gꞌètu are, Ruben laꞌe asa dꞌara jꞌami. Na rage ana aajꞌu ca kapua dhu jꞌajꞌi sèmi èi naꞌi ho hia dhèu bhèni abhu kolo. Ka Ruben nèti hia ina na Lea. Ropa Rahel nèdhi, ka na peka dènge Lea, aku nèngu na, “Aꞌa! Bagi ku jaꞌa ciki, èi naꞌi dhu Ruben nèti èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Te ngaa Lea bꞌala, aku nèngu na, “Wee! Èu ne seli-kolane! Parame more le dhèu èmu jaꞌa. Te ngaa roca mèka na. Mu neo hari unu ajꞌu èi naꞌi èèna nèti ana jaꞌa? Meꞌa heka makae dꞌara!” Te ngaa Rahel dhaa, “Sèmi neꞌe, aꞌa! Ladhe jaꞌa abhu èi naꞌi na, mèda neꞌe èu paꞌèci dènge Yakob.” Ka Lea dꞌèi kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ka pe dꞌai loo nihia sa, Yakob lèpa nèti dꞌara oka. Lea laꞌe soru nare ne, ka na peka, “Aꞌa! Mèda ne, èu jꞌunu dènge jaꞌa! Lula jaꞌa dhu hèli kore le èu, dènge kabꞌua èi naꞌi ana jaꞌa!” Ka mèda na, Yakob jꞌunu dènge Lea. ");
INSERT INTO nfa_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ka Ama Lamatua tadèngi lii manèngi-mangajꞌi Lea. Nèti èèna ka, na dènge babia, hèia nara iisi ana mone ka lèmi. ");
INSERT INTO nfa_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Hèia Lea pangare ana na, Isaskar, (dhu sasoa na, ‘bꞌae jꞌajꞌèra’), lula na peka na, “Ama Lamatua bꞌae-bajꞌa le jꞌajꞌèra jaꞌa, lula jaꞌa hia le Silpa madhèdi dènge dhèu èmu jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Èle èèna ka, Lea dènge babia hari, hèia nara iisi ana mone ka èna. ");
INSERT INTO nfa_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ka na peka, aku nèngu na, “Ama Lamatua parasee jaꞌa mèdha dhu beꞌa. Ka limuri ne, dhèu èmu jaꞌa hudꞌi pakabꞌua ku jaꞌa, lula jaꞌa matana hia ne ana mone dhèu èna.” Nèti èèna ka, na pangare ana ne, Sebulon (dhu sasoa na ‘pakabꞌua’). ");
INSERT INTO nfa_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ka Lea nara iisi hari, te ngaa ana bhèni, ka na pangare na, Dina. ");
INSERT INTO nfa_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Te ngaa Ama Lamatua dhu bhèlu boe Rahel, ka sèmi lii manèngi-mangajꞌi na. Nèti èèna ka, Na bhoke era ana na. ");
INSERT INTO nfa_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hèia Rahel dènge babia, ka nara iisi ana mone ca dhèu. Ka na peka, “Ama Lamatua saku eele le dꞌara makae jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Hèia na pangare ana na Yusuf (dhu sasoa na ele boe ‘hudꞌi laa na hia tabha hari’), lula aku nèngu na, “Jaꞌa manèngi, sèna ka Ama Lamatua hia jaꞌa ana mone ca dhèu hari.” ");
INSERT INTO nfa_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Lodꞌo Rahel nara iisi Yusuf, Yakob peka dènge Laban, aku nèngu na, “Toꞌo! Ladhe moꞌo, jaꞌa neo lèpa asa rai ètu-èsu jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Jaꞌa neo laku dènge ana-dhèu èmu jaꞌa. Toꞌo, èu dhu meꞌa le, jaꞌa ne sabꞌa tèu-tèu nèti madꞌae dꞌai loo nihia. De jaꞌa bꞌae pamaꞌète le rèngu se. Nèti èèna ka, rèngu se, jꞌajꞌi le unu jaꞌa ka teme aae.” ");
INSERT INTO nfa_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Hèia, aku toꞌo na, “Ana, ee! Èu nanene ku lii jaꞌa laa! Madhutu lii malare dhu jaꞌa abhu, Lamatua hia jaꞌa mamèngi lula èu. ");
INSERT INTO nfa_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","De èu neo manèngi ca ngaa, peka, sèna ka jaꞌa bꞌae! Sadꞌi èu baku tèke eele jaꞌa, te ngaa sabꞌa taruu hia jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ka Yakob peka, “Toꞌo! Èu mèdhi unu mu le, sasabꞌa-laꞌa jaꞌa. Nèti èèna ka, badha-manu toꞌo se, bèba-kacanga. ");
INSERT INTO nfa_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Lodꞌo dhu jaꞌa dhae mai mèka, mèdha-panyau toꞌo ku ae èèna mèka. Te ngaa limuri ne, toꞌo kaja le. Lamatua pala-bagi le toꞌo ku mamèngi, lula sasabꞌa-laꞌa jaꞌa ka. Te dꞌai le lodꞌo na, sèna ka jaꞌa sabꞌa hia ana-dhèu èmu jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Hèia Laban karèi ne, aku nèngu na, “De sèmi èèna na, jaꞌa bꞌae èu tasamia?” Ka Yakob dhaa, peka na, “Toꞌo ku, hia ia ka jaꞌa ngaa-ngaa. Te ngaa badha-manu toꞌo ku, jaꞌa ladhe-leru taruu, sadꞌi mu tao ku jꞌara èci. ");
INSERT INTO nfa_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ladhe moꞌo, deo neꞌe kahèi, jaꞌa laku asa badha-manu toꞌo sèi, ho hagꞌe si. Mia dhu dènge boe katèdꞌa aa dènge boe karata, sèra sa unu toꞌo ku taruu. Te ngaa mia dhu dènge katèdꞌa aa dhu karata, hia mi jaꞌa. Dènge kahibꞌi-kalèbho dhu mèdhi, jaꞌa kora aaꞌi si. Seꞌe se, hudꞌi laa jꞌajꞌi mi babꞌae rui-jꞌajꞌèra jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Dꞌai lodꞌo limuri, pe toꞌo meꞌa jaꞌa ne sabꞌa dènge mola, do aadꞌo. Sadꞌi lake more, mai ho mu parisa badha-manu jaꞌa. Ladhe mu abhu kahibꞌi-kaꞌia dhu dènge boe katèdꞌa, aa dhu karata boe, do, kahibꞌi-kalèbho dhu pudhi, èèna na, dhu meꞌa le èèna, jaꞌa manaꞌu badha-manu toꞌo.” ");
INSERT INTO nfa_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ka Laban dꞌèi kahèi, aku nèngu na, “Oo! Jꞌara na sèmi èèna ka.” ");
INSERT INTO nfa_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Te ngaa ètu dꞌara lodꞌo èèna kahèi, Laban hagꞌe dènge badha dhu katèdꞌa, dhu karata, dènge kahibꞌi-kalèbho dhu mèdhi. Ka na pangèdꞌu mi ana na si, ho ladhe-leru. ");
INSERT INTO nfa_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Hèia eo rèti ka badha se asa era èci dhu kajꞌèu na tèlu lodꞌo kako haga nèti era Yakob si. Ka Yakob madhenge ka badha dhu ata se. ");
INSERT INTO nfa_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Èla èèna ka, Yakob poro nare dadana aajꞌu nèti ajꞌu tèlu rupa. Ka na caci pakarata kaꞌuri ajꞌu sèra, tao strep-strep. ");
INSERT INTO nfa_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Hèia ajꞌu dhu strep-strep se, na tèke asa dꞌara karabꞌa kahibꞌi. Badha se dhu tema le paꞌango aa paleo ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","De ladhe badha se paleo ètu madha ajꞌu strep-strep se, ra matana ana dhu rèu ra katèdꞌa dènge karata. ");
INSERT INTO nfa_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ka ladhe badha Laban se neo paleo, Yakob patangare si asa kahibꞌi dhu katèdꞌa dènge karata sèra. Hèia ana dhu ra matana sa rèu ra katèdꞌa dènge karata kahèi. Dènge jꞌara sèmi èèna ka, badha na asa ae. Ka na pacèri eele si nèti badha Laban sèra. ");
INSERT INTO nfa_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ropa badha dhu èra neo paleo, Yakob nare kadhèli ajꞌu dhu strep-strep sèra, tao mi dꞌara karabꞌa ètu madha si. ");
INSERT INTO nfa_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Te ngaa ladhe kahibꞌi dhu roe dènge malaka-godꞌa neo paleo, Yakob soro tèke si. Ka badha dhu roe, sèra unu toꞌo na Laban. Aa mia dhu èra, sèra unu nèngu. ");
INSERT INTO nfa_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Dènge jꞌara neꞌe ne, Yakob jꞌajꞌi dhèu kaja-suꞌi. Ka kahibꞌi-kaꞌia na, kahibꞌi-kalèbho na, onta na, keledꞌei na, dènge ènu na bhèni-mone, udhu sobhu-sobhu. ");
INSERT INTO nfa_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ca tèka, Yakob tadèngi lii padhai ana-ana Laban se, aku rèngu na, “Kakaja-sasuꞌi Yakob sèra, lula na kao nare aaꞌi mèdha-panyau ama èdhi.” ");
INSERT INTO nfa_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob nèdhi kahèi rèhu toꞌo Laban mare heka, aa beꞌa heka dènge ne, sèmi uru èèna. ");
INSERT INTO nfa_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hèia LAMATUA peka dènge Yakob, “Dꞌai le lodꞌo, ho èu lèpa asa ina dènge ama mu. Jaꞌa palere-lere dènge èu.” ");
INSERT INTO nfa_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ka Yakob hia dhèu lasi paroa Rahel dènge Lea, sèna ka mai paraga dènge ne ètu era ani badha, ètu dꞌara mamoo. ");
INSERT INTO nfa_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Hèia na peka dènge ra, aku nèngu na, “Limuri ne, jaꞌa ladhe-ladhe na, ama miu na rèhu na mare heka dènge jaꞌa. Aa babeꞌa na mi jaꞌa, sèmi heka uru èèna. Te ngaa Ama Lamatua dhu ama ku sogo-tagu èèna, palere-lere dènge jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Miu dua mi se meꞌa le, nèbhu nare sange neꞌe, jaꞌa jꞌajꞌi kuli ètu ama miu! ");
INSERT INTO nfa_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Te ngaa sèmi èèna, dꞌara na laꞌe kahèi, ka na kapodꞌe-kabèli taruu jaꞌa. Ka na ubꞌa rui-jꞌajꞌèra jaꞌa, canguru hari kèna. Masi ka sèmi èèna, Ama Lamatua jꞌaga paꞌèra jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Lodꞌo ama miu peka na, ‘Badha dhu rèu ra katèdꞌa sèra jꞌajꞌi mi unu èu,’ ho ladhe lodꞌo badha se matana, ana dhu katèdꞌa hua-hua. Lodꞌo leo hari, na peka, ‘Badha dhu karata sèra, jꞌajꞌi mi unu èu,’ ka badha se matana ana karata aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ama Lamatua adꞌu sèmi èèna na, sèna ka nare aaꞌi badha-manu ama miu èèna, ho hia mi jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ca tèka, ropa badha se paleo, jaꞌa kèdhi ètu dꞌara nii, dhu peka na, badha mone aaꞌi-aaꞌi dhu paleo, abhu dhu katèdꞌa aa dhu karata hèi. ");
INSERT INTO nfa_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ka ana pajuu Lamatua nèti sorga paroa jaꞌa, peka na, ‘Yakob!’ Hèia jaꞌa dhaa, ‘Tasamia, Lamatua?’ ");
INSERT INTO nfa_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ka na lii, ‘Ladhe ku laa! Badha mone dhu paleo sèra, dhodhoka dhu karata dènge katèdꞌa di. Jaꞌa ka adꞌu sèra sa, lula Jaꞌa dhu kèdhi le, ngaa dhu Laban tao mi dedha èu. ");
INSERT INTO nfa_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Jaꞌa ne, Ama Lamatua, dhu padꞌelo iisi mi èu ètu Betel èèna. Ètu era nèi, èu patitu hadhu, ka mu bhori èi mènyi ètu dedha na, ka èu sogo-tagu Jaꞌa. Ka èu paꞌèki lii pajaji dènge Jaꞌa ètu nèi. De kèdꞌi ka, tèke eele ka rai neꞌe ne, lamu ka asa kabarai ina-ama èu.’ ” ");
INSERT INTO nfa_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Hèia Rahel dènge Lea bꞌala lii na, aku rèngu na, “Laꞌa ma! Jiꞌi dènge heka pusaka ngaa-ngaa nèti ama jiꞌi Laban. ");
INSERT INTO nfa_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nèbhu nare sange neꞌe, mone heka ne tao jiꞌi sèmi dhèu leo kara sa. Na pahie eele le jiꞌi se. Ka naꞌe aaꞌi le kabꞌua-kadheli jiꞌi se. ");
INSERT INTO nfa_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","De mèdha-panyau dhu Ama Lamatua nare sèra nèti ama jiꞌi Laban, aaꞌi-aaꞌi sèra jꞌajꞌi le unu èdhi dènge ana-ana èdhi se. De ladhe aku Lamatua tasa mera mia, teꞌa dhoka madhutu di!” ");
INSERT INTO nfa_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Èle èèna ka, Yakob lalau mèdha-panyau na. Hèia na pacaꞌe ana-dhèu èmu na asa dedha onta lasi, aa na eo nèti badha-manu na aaꞌi-aaꞌi, dènge mèdha-panyau dhu na abhu ètu Padan Aram, ho lasi asa rai Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lodꞌo èèna, Laban dhu laꞌe gꞌute rèu kahibꞌi-kalèbho na. Ka Rahel manaꞌu nare patung mèdha sogo-tagu ama na. ");
INSERT INTO nfa_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Aa Yakob si lasi palangu boe lii dènge toꞌo na. ");
INSERT INTO nfa_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Na bau nèti aaꞌi mèdha-panyau na, ka ra kako pamèri-mèri, lasi re loko Efrat, asa ledhe Gilead. ");
INSERT INTO nfa_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Rarai Yakob si èèna dꞌai tèlu lodꞌo ku, heka Laban neꞌa kèna. ");
INSERT INTO nfa_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Hèia Laban oru nare ka dhèu-dhèu na, lasi bate Yakob si. Dꞌai pidhu lodꞌo ku, heka ra paraga dènge si ètu ledhe Gilead. ");
INSERT INTO nfa_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ka dꞌara mèda èèna, Lamatua padꞌelo iisi Na mi Laban ètu dꞌara nii. Na peka na, “Laban! Ladhe èu padhai lii dènge Yakob, jꞌaga paie hèbꞌa èu na.” ");
INSERT INTO nfa_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Mèda èèna, Yakob si dhu patitu paleo ètu ledhe Gilead. Aa Laban si patitu unu ra kajꞌèu boe nèti era èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Èle ka, Laban mai paraga dènge Yakob. Hèia na lii, aku nèngu na, “Nga tao ka, èu rai mèti ana bhèni jaꞌa se, dènge boe lii ugu-geꞌe sa hèi? Mu tao si sèmi dhèu dhu èu segi ètu dꞌara papara-pakèjꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Èu ne adꞌa aadꞌo, palangu boe sa hèi dènge jaꞌa! Ladhe èu peka dènge jaꞌa beꞌa-beꞌa, ele boe jaꞌa tao sisi-kau, ho taꞌa-tinu boko-boko, ho lere miu dènge lii sodꞌa, heka jiꞌi patabuli miu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Sasala èu èci hari ka, èu hia boe jaꞌa uu ana-èpu jaꞌa hèi. Tatao èu ne goa titu kèna! ");
INSERT INTO nfa_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Carui boe, ladhe jaꞌa ne neo pajꞌèra èu! Te ngaa malo-malo ka mèda-mèda na, Ama Lamatua dhu ama mu sogo-tagu èèna, kai jaꞌa peka na, ladhe jaꞌa padhai lii dènge èu, jaꞌa hudꞌi jꞌaga paie-iie ku hèbꞌa jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mema, jaꞌa dhu keꞌa le, èu pakèdꞌi lula èu dhu neo le lèpa. Te ngaa tasamia ka, èu manaꞌu mèti patung mèdha sogo-tagu jaꞌa?” ");
INSERT INTO nfa_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Hèia Yakob bꞌala, aku nèngu na, “Toꞌo baku nasa ku dènge jaꞌa! Jaꞌa pakèdꞌi mau-mau èèna, lula jaꞌa mage dhoka moꞌo boe jaꞌa kèti ana-ana se!” ");
INSERT INTO nfa_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Te ngaa Yakob dhu neꞌa nare boe, na dhèu èmu na Rahel ka dhu manaꞌu nèti. Ka na lii, aku nèngu na, “Toꞌo! Mèdha sogo-tagu èèna, mu tenge ne! Ladhe mèdhi ètu cee, huku pamadhe ne. Parisa aaꞌi mèu-mèu. Ladhe abhu kahèi pusaka toꞌo dhu leo, more aaꞌi si. Hudꞌi laa, dhèu seꞌe se jꞌajꞌi sakasii.” ");
INSERT INTO nfa_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Hèia Laban laꞌe parisa ka asa dꞌara paleo se èci-èci. Na laꞌe uru asa dꞌara paleo Yakob. Èle ka, laꞌe asa dꞌara paleo Lea. Èle ka, laꞌe asa dꞌara paleo ènu se dua ra. Te ngaa abhu boe ngaa-ngaa. Paleo Rahel limuri tèka. ");
INSERT INTO nfa_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Te ngaa Rahel dhu huni le mèdha sogo-tagu sèra ètu dꞌara lalaka onta. Ka na madhèdi ètu dedha. Dꞌai dꞌara paleo ne, Laban tenge paie-iie, te ngaa na rage boe. ");
INSERT INTO nfa_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Hèia Rahel peka dènge ama na, aku nèngu na, “Ama mage mu nasa kahèi. Te jaꞌa bisa boe titu, lula jaꞌa abhu hèru.” Masi ka sèmi èèna, Laban tenge taruu, te ngaa abhu boe mèdha sogo-tagu sèra. ");
INSERT INTO nfa_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ka Yakob nasa, hèia na pajèka dènge Laban, aku nèngu na, “Jaꞌa ne tao bhelu ngaa mi toꞌo? Ka toꞌo mai bate jaꞌa, sèmi dhu jaꞌa ne, dhèu bhelu-katubꞌa sa! ");
INSERT INTO nfa_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Mèdha-panyau jaꞌa, toꞌo cebꞌe eele si. De mu abhu ngaa? More ka mai tèke mi madha ne, sèna ka aaꞌi-aaꞌi ti tèdhi. Aa hudꞌi laa, dhèu seꞌe ka dhu pamaꞌète mèdha èèna unu cee. ");
INSERT INTO nfa_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Dua nguru tèu kèna, jaꞌa sabꞌa kuli mi toꞌo. Lodꞌo jaꞌa madhenga badha-manu toꞌo, ciꞌu sa legu boe. Aa kuꞌa kèdhi boe ciꞌu sa hèi! ");
INSERT INTO nfa_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ladhe badha hui-hahi hui, kadhi pamadhe badha toꞌo ciꞌu, jaꞌa peka boe, te ngaa jaꞌa gati. Aa ladhe dhèu manaꞌu, toꞌo pua jaꞌa gati, masi ka jaꞌa sala boe. ");
INSERT INTO nfa_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ladhe re mèu, madha lodꞌo ai pamango jaꞌa. Aa ladhe mèda, jaꞌa maringi rigꞌi-rigꞌi. Jaꞌa pasaruru boe ciki sa, toke mèu rai, lula madhenge badha-manu toꞌo. ");
INSERT INTO nfa_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Mema tareꞌa, dua nguru tèu èèna! Jaꞌa sabꞌa canguru èpa tèu, sèna ka abhu ana bhèni toꞌo, dhèu dua se. Ka jaꞌa sabꞌa hari èna tèu, sèna ka jaꞌa unu badha-manu seꞌe. Jꞌajꞌi kuli nèbhu nare sange èèna, te ngaa toꞌo pakura rui-jꞌajꞌèra jaꞌa dꞌai canguru hari. ");
INSERT INTO nfa_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Malo-malo ka, dènge Ama Lamatua, dhu baki ku Abraham, dènge ama ku Isak, dhu sogo-tagu Ne. Ladhe Na leru boe jaꞌa ne, ele boe toꞌo hia jaꞌa lèpa dènge ai hua daꞌu-daꞌu. Te ngaa Ama Lamatua dhu paꞌabhe boe musi madha Na mi jꞌajꞌèra jaꞌa, aa Na tao madha-dhilu mi sasabꞌa-laꞌa jaꞌa aaꞌi-aaꞌi. Nèti èèna ka, mèda deo na, Na mai kai toꞌo, sèna ka baku lii sakaa dènge jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ropa nanene nare lii padhai Yakob, ka Laban dhaa, aku nèngu na, “Sèmi neꞌe! Bhèni dua se, ana jaꞌa. Ana dhu ra matana se, aaꞌi-aaꞌi ra èpu jaꞌa. Badha-manu aaꞌi-aaꞌi se, unu jaꞌa. Aaꞌi-aaꞌi dhu èu ladhe mèdhi ètu seꞌe se, unu jaꞌa. Te ngaa jaꞌa neo tao si, tasamia? Jaꞌa bisa boe magee si. ");
INSERT INTO nfa_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","De beꞌa risi, èdhi dua ti paꞌèki lii pajaji. Sèna ka lii pajaji èèna ka dhu èki èdhi dua ti.” ");
INSERT INTO nfa_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hèia Yakob nare ka hadhu aae cue, na patitu ètu èèna, sèna ka jꞌajꞌi mi tadha. ");
INSERT INTO nfa_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Hèia Yakob pua dhèu sabꞌa na, lasi udhu hadhu. Ka ra madhèdi raꞌa-rinu ètu era èèna, padètu dènge hadhu sèra. ");
INSERT INTO nfa_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Hèia Laban pangare hadhu udhu sèra, Yegar Sahaduta. Te ngaa Yakob pangare na, Galeed. ");
INSERT INTO nfa_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ka Laban padhai lii, aku nèngu na, “Hadhu udhu se, jꞌajꞌi sakasii mi èdhi dua ti.” Nèti èèna ka, era èèna ngara na, Galeed. ");
INSERT INTO nfa_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban pangare kahèi era èèna, Mispa (dhu sasoa na ‘era jꞌaga dhu dedha’), lula na peka na, “Pe èèna na, LAMATUA ka dhu jꞌaga èdhi dua ti, ho masi ka dua ti pakajꞌèu, baku kako eele lii pajaji ne. ");
INSERT INTO nfa_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ladhe èu tao karehe ana jaꞌa se, do leo-èmu dènge bhèni leo hari, tatu jaꞌa keꞌa boe. Te ngaa mu sanèdꞌe! Ama Lamatua ka dhu jꞌajꞌi sakasii mi èdhi dua ti. ");
INSERT INTO nfa_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Èu ladhe ku hadhu dhu patitu ne, dènge hadhu dhu udhu se. Sanèdꞌe, hadhu seꞌe ka dhu jꞌajꞌi mi too dènge lane. Èu bisa boe kako seli hadhu se, ho tao bhelu mi jaꞌa. Aa jaꞌa kahèi bisa boe kako seli hadhu se, ho tao bhelu mi èu. ");
INSERT INTO nfa_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Dua ti paꞌèki lii pajaji ne, dènge kolongara Ama Lamatua nèti bèi-baki èdhi. Nuka Ama Lamatua nèti baki mu Abraham dènge baki jaꞌa Nahor. Nèngu èèna ka, dhu jꞌajꞌi hakim, sèna ka pamaꞌète lii èdhi dua ti.” Ropa nanene nare, hèia Yakob jꞌoka soo-subha dènge kolongara Ama Lamatua, dhu ama na Isak sogo-tagu. ");
INSERT INTO nfa_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Èle èèna ka, Yakob roro badha, ho jꞌajꞌi mi korban hia mi Lamatua ètu ledhe èèna. Hèia na paroa dhèu aaꞌi-aaꞌi mai raꞌa-rinu paꞌèci, ka ra beke dꞌai lodꞌo rea. ");
INSERT INTO nfa_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Asa bèli madꞌae èèna, Laban laꞌe liku dènge uu ana-èpu na aaꞌi-aaꞌi ra. Ka na hia si mèngi-nale, hèia na lèpa hari asa rai na. ");
INSERT INTO nfa_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Èle èèna ka, Yakob si kako taruu. Hèia ana pajuu Lamatua nèti sorga sèra mai paraga dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ropa ladhe nèdhi si, na lii, aku nèngu na, “Era neꞌe ne, sèmi era ae sordadꞌu Lamatua!” Nèti èèna ka, era èèna na pangare na, Mahanaim (dhu sasoa na ‘dua era ae iisi’). ");
INSERT INTO nfa_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ka Yakob pua dhèu na pèri-pèri lasi uuru asa rai Edom (nuka Seir), sèna ka lasi peka dènge aꞌa na Esau, ho neꞌa mamai na. ");
INSERT INTO nfa_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Hèia Yakob peka dènge si, aku nèngu na, “Lami peka dènge aꞌa ku Esau, sèmi neꞌe: ‘Lamatua Esau! Ènu mu Yakob, hia jiꞌi ngèti lii karejꞌe-karae mi aꞌa na. Peka na, “Karèi nèti jaꞌa pakèdꞌi, toke sange neꞌe ne, jaꞌa pea ètu dꞌara èmu toꞌo Laban. ");
INSERT INTO nfa_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Limuri ne, ènu lamatua na dènge le unu sapi, keledꞌei, rupa-rupa kahibꞌi, dènge ènu bhèni-mone. Jaꞌa hia uru dhèu seꞌe dhiu, ho peka dènge aꞌa ku, mamai jaꞌa ne. Jaꞌa sanao sèna ka aꞌa ku sèmi jaꞌa dènge dꞌara kateme.”’ ” Èle ka dhèu se lasi. ");
INSERT INTO nfa_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ropa dhèu se lèpa hari mai, ra lolo dènge Yakob, aku rèngu na, “Jiꞌi paraga le dènge aꞌa mu Esau. Nuka na mai re limuri nèi, dènge dhèu na èpa ngasu dhèu mone, neo mai paraga dènge èu.” ");
INSERT INTO nfa_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ropa na tadèngi nare, sangasa Yakob rèbha-rèbha, aa na madhaꞌu ae. Ka na hagꞌe eele dhèu na dènge badha-manu jꞌajꞌi mi dua kaboko. ");
INSERT INTO nfa_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Na pangee, “Ladhe Esau mai, ho na age kaboko dhu uru, na kaboko dhu limuri bisa rai, tenge sodꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Hèia Yakob manèngi-mangajꞌi, aku nèngu na, “Ama Lamatua! Èu jꞌajꞌi Lamatua nèti baki jaꞌa Abraham, aa nèti ama ku Isak. Nanene ku lii manèngi jaꞌa la! Uru èèna, Lamatua ka dhu hia jaꞌa lèpa asa aꞌari jaꞌa, ètu kabarai neꞌe. Lamatua ka dhu moa tèke, peka na pe Lamatua uri pamola jꞌara. ");
INSERT INTO nfa_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Jaꞌa ne madhutu mola-mola na, bisa boe abhu sasue dènge mamako Lamatua. Uru èèna, lodꞌo jaꞌa pège loko Yarden, jaꞌa kèti dhoka tatea di. Te ngaa limuri ne, jaꞌa lèpa kèti dènge dhèu dua nau, aa dènge badha-manu ae. ");
INSERT INTO nfa_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Jaꞌa mangingi, mage dhoka aꞌa jaꞌa Esau, mai pare pamadhe jiꞌi aaꞌi-aaꞌi mi. De jaꞌa manèngi sèna ka Ama Lamatua hia mamuri mi jaꞌa, dènge ana-dhèu èmu-kamali aaꞌi-aaꞌi mi. ");
INSERT INTO nfa_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Lamatua dhu jaji tèke, èèna na pala-bagi mi dedha jaꞌa mamèngi ae-ae, aa hia ana-èpu jaꞌa bèba-kacanga, sama sèmi salae ètu nebhe dhasi, dhu dhèu ige rare boe.” ");
INSERT INTO nfa_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Èle ka, Yakob si jꞌunu ètu era èèna. Asa bèli èèna, na hagꞌe badha pèri-pèri ngiꞌu ho rèti hia aꞌa na. ");
INSERT INTO nfa_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Na pili nare kahibꞌi rena dua ngasu ngiꞌu, kahibꞌi mone dua nguru ngiꞌu, kahibꞌi-kalèbho rena dua ngasu ngiꞌu, kahibꞌi-kalèbho mone dua nguru ngiꞌu, ");
INSERT INTO nfa_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","onta rena tèlu nguru ngiꞌu dènge ana susu, sapi rena èpa nguru ngiꞌu, canguru ngiꞌu sapi mone, keledꞌei rena dua nguru ngiꞌu, dènge canguru ngiꞌu keledꞌei mone. ");
INSERT INTO nfa_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ka na hagꞌe ka badha se, èci-èci ka dènge anga na. Hèia na papala ka, èci-èci dènge ana madhenge na. Ka na peka dènge dhèu seꞌe, aku nèngu na, “Miu kako uuru. Pe jaꞌa dhiu. Te ngaa mi palaladha ho kaboko èci pakajꞌèu nèti kaboko dhu leo sèra.” ");
INSERT INTO nfa_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ka na peka dènge kaboko dhu uuru tèka, aku nèngu na, “Ladhe aꞌa ku Esau paraga dènge èu, aa na karèi, peka na, ‘Èu lamu mia? Èu ne, ènu nèti cee? Badha-manu se, unu cee?’ ");
INSERT INTO nfa_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Na mi dhaa, peka na, ‘Badha-manu se, unu ènu mu, Yakob. Na paꞌadhu hia aꞌa na, Esau. Te ngaa nèngu nuka nèti limuri nèi.’ ” ");
INSERT INTO nfa_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Lii sèmi èèna, na peka kahèi dènge dhèu madhenga badha cahagꞌe sèra hèi, aku nèngu na, “Ladhe mi paraga dènge aꞌa ku Esau, mi hia ne badha-manu se. Aa mi peka dènge ne, jaꞌa re limuri.” Lula madhutu aꞌabhu Yakob, na hia badha se aaꞌi-aaꞌi mi Esau, èèna na Esau sèmi nèngu dènge beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nèti èèna ka, na hia uuru rèti badha se. Te ngaa mèda èèna, nèngu pea ètu èèna era. ");
INSERT INTO nfa_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mèda na, Yakob kèdꞌi, ka na pua dhèu èmu na dhèu dua, dènge dhèu èmu piara dhèu dua, dènge ana na dhèu canguru èci sèra, lasi uuru pège asa cabèka loko Yabok. ");
INSERT INTO nfa_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ropa ra dꞌai ca bèka loko, ka na hia aaꞌi mèdha-panyau na asa nèi. ");
INSERT INTO nfa_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Te ngaa Yakob pea ka mesa-mesa ètu èèna. Hèia dhèu mone èci mai, ka dua ra palèka dꞌai oe mèu. ");
INSERT INTO nfa_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ropa mone ne neꞌa na nèngu segi boe Yakob, ka na kalabhe mi kolo keja Yakob, ka gage na tabodꞌa eele nèti era na. ");
INSERT INTO nfa_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Hèia mone ne lii, aku nèngu na, “Patabuli jaꞌa, te ciki hari, lodꞌo rea kèna.” Te ngaa, aku Yakob na, “Èu hia jaꞌa mèngi-nale, heka jaꞌa patabuli èu kèna!” ");
INSERT INTO nfa_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ka mone ne karèi ne, “Ngara èu ne, cee?” Na dhaa, peka na, “Yakob.” ");
INSERT INTO nfa_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Hèia mone ne lii hari, aku nèngu na, “Èu ngara heka Yakob. Te ngaa mulai nèti deo neꞌe ne, dhèu paroa èu, Israꞌel, lula èu labꞌa le dhèu rai-haha dènge Ama Lamatua, ka èu segi.” (Ngara Israꞌel sasoa na ‘dhu palèka dènge Ama Lamatua’.) ");
INSERT INTO nfa_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ka Yakob karèi ne, “Èu peka ku ngara èu la.” Te ngaa mone ne peka na, “Èu neo meꞌa ngara jaꞌa, tao ngaa?” Hèia na hia mèngi-nale mi Yakob ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ka Yakob padhai lii, aku nèngu na, “Jaꞌa kèdhi le Ama Lamatua madha dènge madha, te ngaa jaꞌa mamuri era.” Nèti èèna ka, Yakob pangare era èèna, Peniel, dhu sasoa na, ‘Rèhu Lamatua’. ");
INSERT INTO nfa_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ropa Yakob tèke eele era èèna, lodꞌo dhu rea le. Te ngaa na kako gedꞌa, lula gage na tabodꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nèti èèna ka, toke dꞌai sange neꞌe, dhèu Israꞌel raꞌa boe sisi isi lasona, lula Lamatua kalabhe patabodꞌa eele gage bèi-baki ra Yakob. ");
INSERT INTO nfa_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ètu dꞌara lodꞌo èèna kahèi, Yakob ladhe nèdhi Esau, dènge dhèu na èpa ngasu sèra, mai asa rèngu. Ka na papala ana na mi ina ra èci-èci. ");
INSERT INTO nfa_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Na hia dhèu èmu piara sèra dènge ana ra kako uuru. Èle ka, Lea dènge ana-ana na, heka Rahel dènge ana na Yusuf limuri tèka. ");
INSERT INTO nfa_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Te ngaa Yakob kako uuru nèti rèngu aaꞌi-aaꞌi ra. Ropa na padètu dènge aꞌa na, na patitu kètu urutuu, ka na pacudꞌu dꞌai rai pidhu hari. ");
INSERT INTO nfa_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Te ngaa lodꞌo Esau ladhe nèdhi ari na, rai dènge ka, laꞌe liku nare Yakob. Dua ra paliku dènge paꞌuu. Hèia dua ra tangi dꞌara pèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ropa Esau nèdhi bhèni dènge ana-ana si, ka na karèi, aku nèngu na, “Seꞌe se, cee ka seꞌe?” Ka Yakob peka, “Rèngu seꞌe se, dhu Ama Lamatua pala-bagi hia jaꞌa, ènu aꞌa ku ne.” ");
INSERT INTO nfa_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hèia dhèu èmu piara na, dènge ana niki ra lasi pahaha iisi ètu madha Esau. ");
INSERT INTO nfa_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Èle ka, Lea dènge ana-ana na, lasi pahaha iisi mi Esau kahèi. Dhu lasi limuri, Yusuf dènge ina na Rahel lasi pahaha iisi mi Esau kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Èle èèna ka, Esau karèi, aku nèngu na, “Èu paꞌadhu badha pèri nau sèi, èu neo tao ngaa?” Hèia Yakob dhaa, aku nèngu na, “Sèmi neꞌe, aꞌa! Jaꞌa hia mi aꞌa ku, sèna ka aꞌa ku sèmi jaꞌa dènge dꞌara taleo.” ");
INSERT INTO nfa_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Te ngaa Esau peka, “Jaꞌa dènge mèdha-panyau ae kahèi. De hia ia ka jaꞌa ngaa-ngaa.” ");
INSERT INTO nfa_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Te ngaa Yakob bꞌala, peka na, “Baku, aꞌa. Aꞌa ku hudꞌi sèmi la mèdha se, sèna ka jꞌajꞌi mi tadha, peka na, aꞌa ku sèmi jaꞌa dènge dꞌara taleo. Te ropa aꞌa ku bꞌui mari, ka jaꞌa sèmi dhu kèdhi bꞌui mari nèti Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","De jaꞌa manèngi, aꞌa ku sèmi la mèdha-panyau dhu kabꞌua aadꞌo se. Lula Ama Lamatua beꞌa titu kèna dènge jaꞌa ne. Nèti èèna ka, Na hia jaꞌa unu ngaa-ngaa se aaꞌi-aaꞌi.” Lula Yakob pamako taruu, noꞌo do noꞌo boe èèna ka, Esau sèmi nare kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hèia Esau peka dènge Yakob, aku nèngu na, “Ladhe sèmi èèna, miu paꞌèra ho lati palere. Jaꞌa lere miu.” ");
INSERT INTO nfa_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Te ngaa aku Yakob na, “Hudꞌi laa, aꞌa! Aꞌa ku ladhe mèdhi unu mu. Ana mu se, ana iiki ae era. Rèngu se dhae èra èèna mèka. Aa badha ae ka dhu heka matana. Ladhe ta pakaseti si kako pamèri, ètu dꞌara ca lodꞌo, èèna na madhe aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","De beꞌa risi, aꞌa ku si kako uuru. Pe jiꞌi kako mau-mau dhiu. Ladhe èèna na, jaꞌa dhiu ngadꞌo aꞌa ku ètu Seir.” ");
INSERT INTO nfa_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Hèia Esau lii hari, na peka, “Ladhe sèmi èèna, jaꞌa tèke eele dhèu jaꞌa se cahagꞌe, sèna ka padꞌelo jꞌara hia miu.” Te ngaa, aku Yakob na, “Hudꞌi laa, aꞌa, ee! Sadꞌi jaꞌa keꞌa le, aꞌa ku sèmi jaꞌa dènge beꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tadèngi nare, Esau pakèdꞌi ka, tèke eele si, lèpa asa Seir. ");
INSERT INTO nfa_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Te ngaa nèti era èèna, Yakob laꞌe asa Sukot. Dꞌai nèi, na tao èmu dènge oka hia badha aaꞌi-aaꞌi ra. Nèti èèna ka, era èèna ra pangare na Sukot (dhu sasoa na ‘èmu pea taha’). ");
INSERT INTO nfa_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Te ngaa nèbhu boe ka, Yakob si kako nèti Padan Aram, lasi dꞌai rae Sikem ètu rai Kanaꞌan dènge sodꞌa-mole. Hèia ra patitu paleo, sèna ka ra pea padètu dènge rae èèna. ");
INSERT INTO nfa_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Rai dhu Yakob patitu paleo ne, hèli nare nèti Hemor, ana Sikem. Kabꞌua rai ne, ca ngasu doi iia. ");
INSERT INTO nfa_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ètu era ne, na pudhi hadhu, tao mei korban. Ka na pangare era neꞌe, El-Elohe-Israꞌel, dhu sasoa na ‘Ama Lamatua nèti Israꞌel’. ");
INSERT INTO nfa_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ca lodꞌo, Dina, ana bhèni Yakob dènge Lea, laꞌe pangadꞌo dènge bhèni anga-aangalai na ètu rae èèna. ");
INSERT INTO nfa_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Dhèu aae kabarai ne, ngara na Hemor, nèti suku Hewi. Ngara ana mone na, Sikem. Ca tèka, Sikem ladhe nèdhi Dina, ka rai nèti ne, hèia na tao pakarehe ne. ");
INSERT INTO nfa_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikem dꞌèi madhe-madhe Dina ne. Ka na solo mako, sèna ka Dina noꞌo dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Hèia Sikem peka dènge ama na, aku nèngu na, “Ama! Lamu karèi Dina hia jaꞌa, sèna ka jaꞌa madhèdi dènge ne.” ");
INSERT INTO nfa_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Tatao Sikem ne, Yakob dhu tadèngi le, te ngaa na mau-mau, aa tao boe ngaa-ngaa. Te lodꞌo èèna, ana mone na sèra, ètu dꞌara padꞌa madhenge badha rèngu. Ka na mate si mai ku. ");
INSERT INTO nfa_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Lodꞌo èèna, Hemor, ama Sikem, mai padhai lii dènge Yakob, ho neo karèi Dina hia Sikem. ");
INSERT INTO nfa_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ètu talora dua ra padhue-padhai era, ana-ana Yakob lèpa nèti dꞌara padꞌa. Ropa ra tadèngi Sikem dhu tao pakarehe le ana hèni ra, ka dꞌara ra pèdꞌa, ka ra nasa bia. Ka ra peka, “Madha jꞌara dhu sèmi neꞌe ne, lèke boe ètu Israꞌel. De jiꞌi se sèmi boe dhèu tao bhelu-katubꞌa sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ka Hemor pamako Yakob, aku nèngu na, “Ana jaꞌa Sikem dꞌèi tareꞌa-reꞌa ana èu Dina. De jaꞌa manèngi dꞌara èu, sèna ka moꞌo la, paleo ana bhèni èu dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ladhe moꞌo ana-ana èdhi se paleo iisi-aanga ra. Ana-ana mone nèti miu, madhèdi dènge ana-ana bhèni nèti jiꞌi. Sèmi èèna kahèi, ana-ana mone jiꞌi madhèdi dènge ana-ana bhèni miu. ");
INSERT INTO nfa_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Sèna ka èdhi pea paꞌoru paꞌèci ètu dꞌara rai neꞌe. Sadꞌi miu dꞌèi era mia èèna ka, mi pea la dènge boe ngaa-ngaa. Mi dꞌaga, sèna ka abhu kakaja ètu neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Hèia Sikem peka dènge ama Dina dènge aꞌa na sèra, peka na, “Miu se, sadꞌi manèngi ngaa, jaꞌa dhoka madhutu di. Masi ka miu manèngi doi pamèu madha, dènge kabꞌua pèri-pèri èèna ka, jaꞌa hia. Sadꞌi moꞌo jaꞌa leo dènge ana hèni miu.” ");
INSERT INTO nfa_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Te ngaa ana-ana Yakob se reꞌa le, Sikem dhu tao pakarehe ana hèni ra Dina. Hèia ra karihu-kahadhu, ka ra bèle, peka mi Sikem dènge ama na Hemor, ");
INSERT INTO nfa_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","aku rèngu na, “Jiꞌi bisa boe hia ana hèni jiꞌi leo dènge dhèu dhu suna boe. Te èèna na, era makae jiꞌi èèna! ");
INSERT INTO nfa_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Te ngaa jꞌara na sèmi neꞌe: Miu se, hudꞌi sama ku sèmi jiꞌi, mone aaꞌi-aaꞌi ra, ana iiki, dhèu kapai, hudꞌi suna ku. ");
INSERT INTO nfa_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ladhe miu madhutu jꞌara neꞌe, èdhi heka paleo kèna. Aa jiꞌi pea ètu rai neꞌe hèi, sèna ka èdhi jꞌajꞌi mi èci. ");
INSERT INTO nfa_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Te ngaa ladhe miu madhutu boe dadꞌèi jiꞌi, aa moꞌo boe suna, jiꞌi ngare hari ana hèni jiꞌi, ho kèdꞌi eele rai neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hèia Hemor dènge ana na Sikem roꞌo kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Te ngaa Sikem noꞌo heka mate, lula dꞌara na dꞌèi ae Dina. Dhèu isi rai ètu èèna pakabꞌua Sikem ne titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ka Hemor dènge Sikem lasi asa era pamaꞌète lii, ètu hèbꞌa tedhe rae èèna, hèia ra padhue lii ne dènge kabarai sèra. Ra peka, aku rèngu na, ");
INSERT INTO nfa_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Aꞌari aaꞌi-aaꞌi! Dhèu Israꞌel se, dꞌèi mamuri mera-milu dènge èdhi. De hudꞌi laa ta pea paꞌèci dènge rèngu ètu dedha-rai neꞌe. Rai ne taleo, de èdhi bisa pea paꞌèci aaꞌi-aaꞌi ti. Èdhi se bisa leo dènge ana bhèni rèngu. Aa rèngu bisa madhèdi dènge ana bhèni èdhi kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Lii manèngi rèngu dhoka èci di, nèti èdhi se. Ra manèngi, èdhi mone se aaꞌi-aaꞌi hudꞌi suna ku, madhutu adꞌa rèngu. ");
INSERT INTO nfa_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ladhe èdhi se pabꞌali le dènge rèngu, èèna na badha-manu dènge mèdha-panyau ra jꞌajꞌi unu èdhi. De beꞌa risi èdhi toꞌo la madhutu dadꞌèi ra. Mai sèna ka aaꞌi-aaꞌi ti suna! Moꞌo, sina ma?” ");
INSERT INTO nfa_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ka dhèu aaꞌi-aaꞌi ètu sèra sa, sèmi lii padhai lii Hemor dènge ana na Sikem. Hèia dhèu mone aaꞌi-aaꞌi ètu rai èèna suna palere-lere. ");
INSERT INTO nfa_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Dꞌara lodꞌo ka tèlu, ropa rèngu dhu suna se, nuꞌa ra dhu pèdꞌa era, ka ana mone Dina, Simeon dènge Lewi, rare samala ra, kako mau-mau, lasi asa dꞌara kota. Ka dua ra pare pamadhe aaꞌi-aaꞌi dhèu mone sèra. ");
INSERT INTO nfa_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hemor dènge Sikem, ra pare pamadhe kahèi. Hèia ra rèti dènge ka Dina nèti dꞌara èmu Sikem, lèpa èmu rèngu. ");
INSERT INTO nfa_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Aa ana Yakob dhu cahagꞌe sèra, maso asa dꞌara kota èèna, ra parama rèti aaꞌi mèu-mèu isi kabarai èèna. Ra nasa, lula dhèu tao pakarehe ana hèni ra ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ra parama rèti mèdha-panyau dhèu nèti dꞌara èmu ra, dènge eo rèti badha-manu aaꞌi-aaꞌi ètu dꞌara padꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Rèti aaꞌi bhèni dènge ana-ana, aa parame rare aaꞌi mèdha dhu kabꞌua nèti kabarai ne. ");
INSERT INTO nfa_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ropa Yakob neꞌa jꞌara dhu jꞌajꞌi èèna, na peka dènge Simeon dènge Lewi, “Miu dua mi se, goa ngaa ka neꞌe? Miu pajꞌèra jaꞌa! Èèna na, dhèu Kanaꞌan dènge dhèu Peris dènge dhèu aaꞌi-aaꞌi ra ètu dedha rai neꞌe, tèka dꞌara dènge èdhi se. Rèngu se, dhèu ae-ae. Te ngaa èdhi se, dhèu ciki di. Ladhe rèngu se mai age èdhi, na, ra palaho aaꞌi èdhi.” ");
INSERT INTO nfa_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Te ngaa ana se dhaa dènge lii nasa, peka na, “Ama! Ama pangee na hudꞌi laa jiꞌi soro tèke si, sèna ka ra tao ana hèni jiꞌi ne, bhèni kajeo!” ");
INSERT INTO nfa_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Èle èèna ka, Ama Lamatua padhai lii dènge Yakob, peka na, “Jaꞌa ne, Ama Lamatua dhu padꞌelo iisi mi èu, lodꞌo èu rai nèti madha aꞌa mu Esau. Kèdꞌi, lamu dènge ka asa Betel. Ladhe dꞌai nèi, mu patitu mei korban hia Jaꞌa. Aa pea dènge ka ètu èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Ka Yakob peka dènge isi èmu na aaꞌi-aaꞌi, aku nèngu na, “Aaꞌi-aaꞌi ti lati dènge ka asa Betel. Uru èèna, lodꞌo jaꞌa ètu dꞌara jꞌajꞌèra, Ama Lamatua ka dhu ladhe-leru jaꞌa ètu èèna. Jaꞌa neo tao mei korban ètu nèi. De mi core eele mèdha sogo-tagu miu. Aa mi pamèu iisi mi, ho mi gati mèdha-papake leo, te èdhi neo pahaha iisi mi Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ka ra oru mèdha sogo-tagu, dènge ate-ate ra aaꞌi-aaꞌi ra. Hèia Yakob dhènu mèdha se aaꞌi-aaꞌi ra ètu kapua ajꞌu aae ca kapua dhu padètu dènge rae Sikem. ");
INSERT INTO nfa_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ropa Yakob dènge dhèu na aaꞌi-aaꞌi pakèdꞌi nèti Sikem, Ama Lamatua hia dꞌara madhaꞌu mi dhèu-dhèu dhu pea ètu dꞌara rae-rae dhu padètu dènge rae Sikem, ka ra bani boe tao karehe mi Yakob si. ");
INSERT INTO nfa_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ka Yakob si dꞌai dènge sodꞌa ètu Betel (dhu uru èèna, ngara na Lus), ètu rai Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ètu neꞌe, Yakob pudhi hadhu, tao mei korban. Ka na pangare era ne, El Betel, (sasoa na ‘Betel unu Ama Lamatua’), lula uru èèna Ama Lamatua padꞌelo iisi mi Yakob ètu era èèna, lodꞌo nèngu rai nèti madha aꞌa na. ");
INSERT INTO nfa_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Padètu dènge rae Betel, abhu ajꞌu aae ca kapua, ngara na Alon Bakut. Sasoa na ‘ajꞌu tangi dhèu madhe’. Pake ngara ne, lodꞌo Debora, ina dhu lalau-laloꞌo Ribka, madhe, ka padhane ètu karasa ajꞌu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Lodꞌo Yakob lèpa nèti Padan Aram, Ama Lamatua padꞌelo hari iisi Na, ka hia na berkat. ");
INSERT INTO nfa_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Hèia Lamatua peka dènge ne, “Nèti deo neꞌe ne, èu ngara heka Yakob, te ngaa Israꞌel. ");
INSERT INTO nfa_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Jaꞌa ne, Ama Lamatua dhu Koasa Risi Eele. De èu matana paꞌae-ae, aa ana-èpu èu sèmi èèna kahèi. Bèli-camèdꞌa, suku-suku mai nèti ana-èpu èu. Aa nèti ana-èpu èu sèra, cèu dhèu aae-dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Rai dhu pangèdꞌu mi baki mu Abraham, dènge ama mu Isak, Jaꞌa hia mi èu dènge ana-èpu èu.” ");
INSERT INTO nfa_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Lodꞌo Ama Lamatua peka nare, Yakob patitu dènge hadhu ètu era èèna, sèna ka jꞌajꞌi mi tadha ho na baku bhèlu eele lii Lamatua. Ka na bhori èi anggor dènge èi mènyi mi dedha hadhu na, hèia na mangajꞌi mi Lamatua. ");
INSERT INTO nfa_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Era èèna, na pangare ‘Betel’. ");
INSERT INTO nfa_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Èle èèna ka, Yakob si pakèdꞌi nèti Betel. Ropa rèngu kajꞌèu èèna mèka nèti rae Efrata (nuka Betlehem èèna), Rahel dhu dꞌai le lodꞌo nara iisi na. Te ngaa nara iisi carui, hèia na roe titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ka ropa na pèngu stenga madhe, dhèu ai tadha peka dènge ne, “Paꞌèra dꞌara èu, te mora iisi hari ana mone ca dhèu! De baku paroe iisi.” ");
INSERT INTO nfa_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Lodꞌo Rahel oe maꞌète aꞌae, na pangare ana ne, Ben-Oni, (dhu sasoa na ‘ana nèti jꞌajꞌèra jaꞌa’). Ka heka na madhe kèna. Te ngaa Yakob hia ana ne ngara Benyamin, (dhu sasoa na ‘ana ai gꞌana’). ");
INSERT INTO nfa_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ka ra padhane Rahel ètu sebhe jꞌara dhu laꞌe asa Efrata, (dhu limuri ne, ngara na Betlehem). ");
INSERT INTO nfa_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Hèia Yakob pudhi lutu bhatu ètu roꞌa dhèu èmu na èèna. Dꞌai sange neꞌe, roꞌa Rahel ne era. ");
INSERT INTO nfa_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Èle èèna ka, Yakob pea boe mi ca era sa. Ca tèka, na patitu paleo ètu sebhe manara Eder. ");
INSERT INTO nfa_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Lodꞌo rèngu ètu era èèna, Ruben jꞌunu dènge Bilha, dhèu èmu piara ama na. Èèna ka, Yakob neꞌa jꞌara neꞌe kahèi. Ana mone Yakob, canguru dua dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ana-ana nèti Lea, nuka: Ruben (ana uuru Yakob), Simeon, Lewi, Yahuda, Isaskar, dènge Sebulon. ");
INSERT INTO nfa_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ana-ana Rahel, nuka: Yusuf dènge Benyamin. ");
INSERT INTO nfa_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ana-ana nèti Bilha, ènu Rahel: Dan dènge Naftali. ");
INSERT INTO nfa_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Aa ana-ana nèti Silpa, ènu Lea, nuka: Gad dènge Aser. Rara iisi ana se ètu Padan Aram. ");
INSERT INTO nfa_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Èle èèna ka, Yakob laꞌe ngadꞌo ama na Isak asa Mamre, dhu dètu dènge Kiryat-Arba (dhu limuri ne, ngara na Hebron). Uru èèna, baki na Abraham pea ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Umur Isak dꞌai 180 (ca ngasu aru nguru) tèu, heka madhe kèna. Ka ana na Esau dènge Yakob padhane ne. ");
INSERT INTO nfa_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Neꞌe ne, ana-èpu Esau. Ngara Esau dhu leo, Edom. ");
INSERT INTO nfa_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau leo dènge ana bhèni Kanaꞌan dhèu dua. Èci dhèu Het, ana bhèni nèti Elon, ngara na Ada. Dhèu èmu na èci hari, dhèu Hewi, ngara na Oholibama. Ama na, ngara na Anah, aa baki na Sibeon. ");
INSERT INTO nfa_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau leo kahèi dènge ana Ismael, ngara na Basmat. Ana mone Basmat, ngara na Nebayot. ");
INSERT INTO nfa_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada, dhèu èmu uuru Esau, nara iisi Elifas. Basmat matana Rahuel. ");
INSERT INTO nfa_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aa Oholibama matana Yeus, Yalam dènge Kora. Ana Esau aaꞌi-aaꞌi ra sèra rara iisi si ètu rai Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ca tèka, Esau pidha asa rai leo cue dhu kajꞌèu nèti Yakob. Laꞌe nèti aaꞌi bhèni-ana niki, dhèu-dhèu sabꞌa, badha-manu, dènge mèdha-panyau na. ");
INSERT INTO nfa_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau pacèri dènge Yakob, lula badha-manu ra dènge mèdha-panyau ra ae dꞌai seli. Nèti èèna ka, era pea rèngu katata ètu rai èèna. ");
INSERT INTO nfa_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Hèia Esau (nuka Edom) laꞌe pea ètu ledhe ètu Seir. ");
INSERT INTO nfa_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Seꞌe se, ana-èpu Esau dhu ra peka na ‘dhèu Edom’. Rèngu pea ètu era ledhe Seir. ");
INSERT INTO nfa_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Ada, dhèu èmu Esau, nara iisi ana mone ca dhèu, ngara na Elifas. Elifas ne, ana mone na, dhèu lèmi, nuka: Teman, Omar, Sefo, Gatam dènge Kenas. Dhèu èmu piara Elifas, ngara na Timna. Nara iisi ana mone ca dhèu, ngara na Amalek. Dhèu èmu Esau, Basmat, nara iisi ana mone ca dhèu, ngara na Rehuel. Rehuel abhu ana mone dhèu èpa, nuka: Nahat, Sera, Syama, dènge Misa. ");
INSERT INTO nfa_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Dhèu èmu Esau, Oholibama, ana nèti Anah, aa èpu nèti Sibeon, nara iisi ana mone dhèu tèlu, nuka: Yeus, Yalam, dènge Kora. ");
INSERT INTO nfa_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Ana-èpu Esau se pahagꞌa lème, ka jꞌajꞌi mi suku ae-ae. Èci-èci ka dènge kapala suku ra. Ana-ana Elifas, dhu ana uuru nèti Esau, jꞌajꞌi kapala suku nèti suku Teman, suku Omar, suku Sefo, suku Kenas, suku Kora, suku Gatam dènge suku Amalek. Rèngu aaꞌi-aaꞌi seꞌe, ana-èpu nèti Esau dènge dhèu èmu na Ada. ");
INSERT INTO nfa_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ana-ana Rehuel, dhu ana nèti Esau, jꞌajꞌi kapala suku nèti suku Nahat, suku Sera, suku Syama, dènge suku Misa. Aaꞌi-aaꞌi se, ana-èpu Esau dènge dhèu èmu na, Basmat. ");
INSERT INTO nfa_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ana-ana nèti Esau dènge dhèu èmu na, Oholibama, jꞌajꞌi kapala suku nèti suku Yeus, suku Yalam, dènge suku Kora. ");
INSERT INTO nfa_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Suku seꞌe aaꞌi-aaꞌi ra nèti ana-èpu Esau. ");
INSERT INTO nfa_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ètu era èèna, abhu dhèu Hori èci, ngara na Seir. Ana-ana na pahagꞌa palème rai, ka jꞌajꞌi suku ae-ae. Èci-èci ka dènge kapala suku na. Èle èèna ka, ana-ana na se jꞌajꞌi kapala suku nèti suku Lotan, suku Sobal, suku Sibeon, suku Anah, suku Dison, suku Eser, dènge suku Disan. ");
INSERT INTO nfa_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ana Lotan nuka: Hori dènge Heman. (Ana hèni Lotan, nuka Timna.) ");
INSERT INTO nfa_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ana-ana Sobal, nuka: Alwan, Manahat, Ebal, Sefo, dènge Onam. ");
INSERT INTO nfa_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ana-ana nèti Sibeon, nuka: Aya, dènge Anah. Anah neꞌe ka dhu rage madha èi pana ètu dꞌara mamoo, lodꞌo na madhenga keledꞌei ama na. ");
INSERT INTO nfa_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Ana bhèni nèti Anah, nuka Oholibama. Aa ana mone na, nuka, Dison. Ana-ana Dison, nuka: Hemdan, Esban, Yitran, dènge Keran. ");
INSERT INTO nfa_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ana-ana Eser, nuka: Bilhan, Saawan, dènge Akan. ");
INSERT INTO nfa_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ana-ana Disan, nuka: Us, dènge Aran. ");
INSERT INTO nfa_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","De kapala-kapala suku nèti dhèu Hori sèra, nuka: Lotan, Sobal, Sibeon, Anah, Dison, Eser, dènge Disan. Rèngu aaꞌi-aaꞌi se pea ètu rai Seir. ");
INSERT INTO nfa_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Lodꞌo dhu kabarai Israꞌel dènge mèka dhèu aae, te ngaa ètu rai Edom dènge le dhèu aae. Ngara dhèu aae se, dhutu-dhutu, nuka: ");
INSERT INTO nfa_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ra dedꞌe Bela, ana nèti Beor, jꞌajꞌi dhèu aae ètu kota Dinhaba. ");
INSERT INTO nfa_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ropa Bela madhe, ra dedꞌe Yobab ho gati ne, jꞌajꞌi dhèu aae. Ama na, ngara na Sera, nèti rae Bosra. ");
INSERT INTO nfa_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ropa Yobab madhe, ra dedꞌe Husam ho gati na, jꞌajꞌi dhèu aae. Husam ne, nèti rai dhèu Teman. ");
INSERT INTO nfa_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ropa Husam madhe, ra dedꞌe Hadad ho gati na, jꞌajꞌi dhèu aae. Ama na, ngara na Bedad, nèti rae Awit. (Nèngu ka dhu segi dhèu Midian, lodꞌo ra pamusu ètu Moab.) ");
INSERT INTO nfa_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ropa Hadad madhe, ra dedꞌe Samla ho gati na, jꞌajꞌi dhèu aae. Nèngu ne, nèti rae Masreka. ");
INSERT INTO nfa_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ropa Samla madhe, ra dedꞌe Saul ho gati na, jꞌajꞌi dhèu aae. Saul èèna, nèti rae Rehobot, dhu ètu sebhe loko. ");
INSERT INTO nfa_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ropa Saul madhe, ra dedꞌe Baal-Hanan ho gati na, jꞌajꞌi dhèu aae. Ama na, ngara na Akbor. ");
INSERT INTO nfa_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ropa Baal-Hanan madhe, ra dedꞌe Hadar ho gati na, jꞌajꞌi dhèu aae. Hadar ne, nèti rae Pau. Aa dhèu èmu na, ngara Mehetabel. Ama Mehetabel, ngara na Matret. Aa baki na, Mesahab. ");
INSERT INTO nfa_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","De kapala-kapala suku dhu jꞌajꞌi nèti ana-èpu Esau, nuka: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, dènge Iram. Rèngu se èci-èci pangare rai ra madhutu ngara rèngu unu ra. De aaꞌi-aaꞌi seꞌe, lii lolo nèti ana-èpu Esau, dhèu Edom èèna. ");
INSERT INTO nfa_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Neꞌe ne, lii lole nèti Yakob si. Ca tèka ka, Yakob laꞌe pea hari asa rai Kanaꞌan. Èèna, era pea ama na Isak nèti uru ka. ");
INSERT INTO nfa_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Tèu èèna, ana Yakob èci, nèti dhèu èmu na Rahel, ngara na Yusuf. Yusuf neꞌe, ropa umur na dꞌai 17 (canguru pidhu) tèu, nèngu dènge aꞌa na si, tema le jꞌaga kahibꞌi-kalèbho rèngu. Aꞌa na sèra, ana nèti ina leo hari, ngara na Bilha dènge Silpa. Te ngaa Yusuf neꞌe tuka tenge lii mi dedha aꞌa na si, ho laꞌe panaꞌe ama na. ");
INSERT INTO nfa_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Lodꞌo dhu rara iisi Yusuf na, ama na dhu heka le. Nèti èèna ka, na sue Yusuf ne risi eele nèti ana-ana na leo sèra. Ca lodꞌo ka, Yakob jꞌau kodho madhera èci dhu saraga bia hia Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ropa aꞌa na si ladhe-ladhe laꞌa na ama na sue risi Yusuf, hèia ra mulai tèka dꞌara dènge ne, roꞌo boe padhai lii dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Mèda ca lodꞌo ka Yusuf nii. Kèdꞌi nèti bhèjꞌi ka, na lolo dènge aꞌa na si lii nii deo na, aku nèngu na, “We! Mi nanene ku la! Jaꞌa nii, na èdhi aaꞌi-aaꞌi ti, èki are ètu dꞌara oka. Kabèdhi laa, are dhu jaꞌa èki titu dhoo-dhoo. Te ngaa are miu, oke mere are jaꞌa deo na, ka pacudꞌu mi unu jaꞌa.” Ra nanene rare sèmi èèna, hèia aꞌa na seꞌe tabha nasa hari dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Hèia ra jèke ne, aku rèngu na, “We! Èu ngee na, èu neo jꞌajꞌi dhèu kapai kèna, ho neo paredha jiꞌi, do?” Taga na lolo lii nii neꞌe, hèia asa ra nasa dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nèbhu boe, Yusuf nii hari ca tèka. Na lolo hari dènge aꞌa na si, aku nèngu na, “We! Jaꞌa nii hari, sèmi neꞌe ka. Jaꞌa kèdhi madha lodꞌo, hèru, dènge hua-hètu canguru èci. Aaꞌi-aaꞌi sèra, pahaha iisi mi jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Hèia Yusuf lolo hari lii nii deo na dènge ama na, aa dènge aꞌa na sèra. Ka ama na jèke ne, aku nèngu na, “Lii nii ngaa, kèna! Èu ngee na, jaꞌa dènge ina mu, dènge aꞌari èu sèra, mai uu kabajꞌèla èu, do? Èu nia ae le èèna, nga!” ");
INSERT INTO nfa_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nèti èèna ka, aꞌa na sèra tèka dꞌara bia dènge ne. Te ngaa ama na pangee taruu lii nii èèna ètu dꞌara na. ");
INSERT INTO nfa_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ca tèka ka, aꞌa Yusuf sèra rèti kahibꞌi-kalèbho ama na, asa era jꞌuꞌu dètu dènge rae Sikem. ");
INSERT INTO nfa_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Nèbhu boe ka, ama na peka dènge Yusuf, aku nèngu na, “Aꞌa mu si jꞌaga kahibꞌi-kalèbho dètu dènge Sikem. De èu paꞌèra, ho lamu ladhe ku si la.” Ka Yusuf dhaa, aku nèngu na, “Jaꞌa laku, ama.” ");
INSERT INTO nfa_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Hèia ama na peka hari, aku nèngu na, “Èu lamu ladhe aꞌa mu si, dènge kahibꞌi-kalèbho èdhi. Ladhe ra samia na, mai peka dènge jaꞌa.” Ka Yusuf pakèdꞌi ka nèti dꞌara padꞌa Hebron, laꞌe taruu dꞌai Sikem. ");
INSERT INTO nfa_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Dꞌai nèi, na tenge aꞌa na si, palème dꞌara padꞌa èèna. Na paraga dènge dhèu mone èci, ka dhèu èèna karèi ne, aku nèngu na, “Èu tenge ngaa?” ");
INSERT INTO nfa_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuf dhaa, aku nèngu na, “Jaꞌa tenge aꞌa jaꞌa. Rèngu eo kahibꞌi-kalèbho dètu ètu era neꞌe. De ama, èu paraga dènge si, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Hèia, dhèu deo na peka, aku nèngu na, “Ra aadꞌo heka ètu neꞌe. Te jaꞌa tadèngi, ra peka na lasi padètu dènge rae Dotan.” Hèia Yusuf laꞌe taruu, ka paraga dènge si ètu rae Dotan. ");
INSERT INTO nfa_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ropa ladhe rèdhi Yusuf nèti kajꞌèu, ra padhue rare lii èci neo pamadhe ne. ");
INSERT INTO nfa_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Èci peka dènge èci, aku rèngu na, “Miu ladhe ku la! Mone eele tuka nii na, nuka mai nèi! ");
INSERT INTO nfa_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","De mai ho ti pamadhe ne. Ho èèna na, ti core eele ne asa dꞌara madha èi madhe èèna. Ladhe dꞌai èmu na, ti peka dènge ama peka na, badha hui raꞌe ne. Ho èèna na, ti ladhe sèku, lii nii na sèra sa mia!” ");
INSERT INTO nfa_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ropa nanene èèna, hèia aꞌa na Ruben tenge jꞌara ho patabuli eele Yusuf. Hèia na kai ari na si, aku nèngu na, “We! Èdhi baku pamadhe ne! ");
INSERT INTO nfa_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Beꞌa risi èdhi kèpe ne, ti tao asa dꞌara madha èi madhe nèi. Ètu èèna, era dhu dhèu aadꞌo, de èci sa rèdhi boe ne. Sadꞌi baku pasuti raa na.” Na peka sèmi èèna, lula na tenge jꞌara ho patalale Yusuf, ho hia na lèpa hari èmu. ");
INSERT INTO nfa_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ropa Yusuf dꞌai madha aꞌa na si, ra kèpe ne, ka ra rèbhi eele kodho dhu saraga aae ètu ua na. ");
INSERT INTO nfa_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ka ra nuni paꞌoro ne, hèia ra tule ne asa dꞌara madha èi madhe èèna. ");
INSERT INTO nfa_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Èle èèna ka, ra lèpa, lasi raꞌa-rinu. Ètu talora raꞌa-rinu, kabèdhi la ra ladhe rèdhi dhèu canau mai re èèna. Dhèu sèra kako rèti dènge badha onta ra, hue dènge mèdha dꞌaga, sèmi raa ajꞌu hèu mèngi, bubhu-bubhu dènge èi naꞌi rupa-rupa. Dhèu sèra sa, dhèu Ismael, dhu mai nèti rae Gilead neo lasi kajꞌèu dꞌai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Èle èèna hèia, Yahuda peka dènge aꞌari na sèra, aku nèngu na, “Ee! Beꞌa risi sèmi neꞌe. Èdhi baku pamadhe ne. Aꞌoto na ngaa? Tasa mera mia èèna ka, èdhi bisa boe pahuni raa na. ");
INSERT INTO nfa_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Beꞌa risi èdhi pahie ne dènge dhèu Ismael sèi. Èdhi tao ne samia èèna ka oo, nèngu neꞌe ari dꞌèlu èdhi. Nèti èèna ka, baku èdhi pamadhe ne!” Aaꞌi-aaꞌi ra dꞌèi kahèi dènge lii Yahuda èèna. ");
INSERT INTO nfa_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ropa dhèu dꞌaga sèra dꞌai era èèna, hèia aꞌa Yusuf sèra lasi ère rare ne, nèti dꞌara madha èi madhe deo na. Ka ra pahie ne mi dhèu Ismael sèra dènge kabꞌua 20 (dua nguru) bua doi pudhi. Ka dhèu Ismael sèra rèti Yusuf asa rai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lodꞌo ra pahie Yusuf ne, Ruben neꞌa boe. Ropa na laꞌe patigi sa dꞌara madha èi madhe na, capa na kabèdhi, ladhe laꞌa na Yusuf aadꞌo heka ètu dꞌara. Nèti èèna ka, na ciu pamae kodho ètu ngiꞌu na, lula dꞌara na pèdꞌa ae titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Hèia na laꞌe sa ari na si, ka na peka, aku nèngu na, “Ira ii! Ari èdhi aadꞌo heka ètu era èèna! Jaꞌa tao samia hari?” ");
INSERT INTO nfa_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hèia ra roro kahibꞌi ciꞌu, ka rare kodho Yusuf dhu saraga aae èèna, cèbꞌu sa dꞌara raa kahibꞌi deo na. ");
INSERT INTO nfa_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Hèia ra lèpa ka rèti dènge kodho deo na, padꞌelo dènge ama na, ka ra peka, aku rèngu na, “Ama! Jiꞌi pili ngare kodho neꞌe. Ama ku ladhe sèku la. Tao-tao neꞌe kodho ari jiꞌi Yusuf.” ");
INSERT INTO nfa_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ropa nèdhi kodho deo na, Yakob tadhe dènge. Hèia na peka, aku nèngu na, “Ira ii! Neꞌe kodho ana jaꞌa. Èle boe badha hui raꞌe ana jaꞌa. Ira iiii! Ana jaꞌa madhe le!” ");
INSERT INTO nfa_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Nèti èèna ka, Yakob ciu pamae kodho ètu ngiꞌu na, ka na pake karo, taga nèti dꞌara na susa titu kèna. Na tangi lii ooi-ooi sène nare lodꞌo nèbhu aae. ");
INSERT INTO nfa_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ana na, ana mone dènge ana bhèni sèra aaꞌi-aaꞌi ra, mai padhai lii pakarejꞌe dꞌara ama ra, te ngaa tao rare boe ne. Aku nèngu na, “Aadꞌo! Sasusa jaꞌa ne bisa dꞌai madhe kèti. Te jaꞌa bisa boe bhèlu ana èci neꞌe.” Mema dꞌara Yakob jꞌèra taruu, lula na ngee nèdhi ana na Yusuf dhu madhe èèna. ");
INSERT INTO nfa_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Lodꞌo-lodꞌo dhu Yakob ètu dꞌara susa era, dhèu dꞌaga sèra dꞌai le Masir. Dꞌai nèi, ka lasi pahie eele Yusuf dènge dhèu kapai èci ètu nèi, ngara na Potifar. Dhèu neꞌe komedhaa jꞌaga nèti dhèu aae Masir. ");
INSERT INTO nfa_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Èle èèna ka, Yahuda tèke eele aꞌari na, ka laꞌe pea dènge angalai na èci, ngara na Hira, ètu rae Adulam. ");
INSERT INTO nfa_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ètu èèna, dhèu mone èci, dhèu Kanaꞌan, ngara na Sua. Yahuda dꞌèi ana bhèni na èci, ka nare jꞌajꞌi dhèu èmu na. Dhèu èmu Yahuda neꞌe nara iisi ana mone pagodꞌo-pagodꞌo dhèu pèri-pèri. ");
INSERT INTO nfa_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ana uuru èèna, ngara na Er. ");
INSERT INTO nfa_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ana ka dua, ngara na Onan. ");
INSERT INTO nfa_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Aa ana ka tèlu, ngara na Sela. Lodꞌo ina na nara iisi Sela na, Yahuda si pidha le asa rae Kesib. ");
INSERT INTO nfa_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ropa ana mone uuru, dhu ngara na Er èèna kapai, ka ama na laꞌe tenge dhèu hia ne. Ngara ana bhèni na Tamar. Ka dua ra jꞌajꞌi paleo èmu. ");
INSERT INTO nfa_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Lula Er ne, bhelu-katubꞌa, ka Ama Lamatua huku pamadhe ne. Nèti èèna ka, nèngu dènge boe kolo. ");
INSERT INTO nfa_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Hèia Yahuda paroe nare ana mone ka dua na, ka na peka, aku nèngu na, “Onan! Aꞌa mu Er madhe, dènge boe ana. Madhutu adꞌa èdhi na, èu hudꞌi leo hari ku dènge dhèu èmu aꞌa mu ne. Sèna ka èu bisa hia kolo hia aꞌa mu.” ");
INSERT INTO nfa_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mema Onan neꞌa le adꞌa sèmi neꞌe. Te ngaa na noꞌo boe hia kolo mi aꞌa na Er. Nèti èèna ka, ladhe rèngu jꞌunu paꞌèci, na pasuti eele hua hini nèngu asa liꞌu, sèna ka Tamar baku dènge babia. ");
INSERT INTO nfa_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Taga tatao Onan sèmi neꞌe ka, Lamatua nasa bia dènge ne. Nèti èèna ka, Lamatua huku pamadhe ne kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ropa Yahuda nèdhi ana mone na dua sèra dhu leo dènge Tamar madhe sèmi èèna, hèia Yahuda madhaꞌu. Ka na pangee mage dhoka ana mone ka tèlu èèna, leo hari dènge Tamar na madhe kahèi. Nèti èèna ka, laꞌe peka dènge Tamar, aku nèngu na, “Beꞌa risi èu lèpa hari asa dꞌara adhe-aai ina dènge ama mu. Ladhe ana jaꞌa Sela kapai, na èu lèpa hari mai ho leo dènge ne.” Hèia Tamar lèpa dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Nèbhu-nèbhu hèia, dhèu èmu Yahuda madhe. Na jꞌèra toke dꞌai paꞌèle lodꞌo sasusa na. Ka na laꞌe gale nare angalai na Hira, ka lasi asa rae Timna. Ètu èèna, dhèu rame-rame gꞌute rèu kahibꞌi-kalèbho ho pahia. ");
INSERT INTO nfa_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Dhèu lolo dènge Tamar, peka na, “Toꞌo mu laꞌe leru dhèu gꞌute rèu kahibꞌi-kalèbho ètu rae Timna.” ");
INSERT INTO nfa_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Lodꞌo èèna, ana limuri Yahuda, ngara na Sela, kapai le. Te ngaa Tamar neꞌa le, na, toꞌo na noꞌo boe paleo Sela dènge ne. Nèti èèna ka, Tamar tenge jꞌara neo katèju hak nèngu. Na bhoke eele mèdha-papake bhèni balu ètu ngiꞌu na, ka na silu mèdha-papake dhu beꞌa. Na pake salalu pahutu kètu dènge rèhu na. Ka laꞌe madhèdi ètu hèbꞌa tedhe sebhe jꞌara rae Enaim, dhu biasa dhèu kako re èèna lasi rae Timna. ");
INSERT INTO nfa_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ropa Yahuda kako re èèna, na ladhe nèdhi dhèu bhèni èci madhèdi ètu èèna. Na neo laa na dhèu bhèni kajeo, te Tamar dhu lalau iisi dènge mèdha-papake saraga, aa pahutu rèhu na kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda neꞌa nare boe na dhèu bhèni na, dhèu èmu ana na dhu madhe sèra. Hèia na kako laꞌe padètu dènge bhèni deo na ka, na peka dènge ne, aku nèngu na, “Ee! Sèmi jaꞌa dènge èu na, èu manèngi ca ngaa?” Hèia Tamar dhaa, aku nèngu na, “Èèna nèti dꞌara dꞌèi ama.” ");
INSERT INTO nfa_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Aku Yahuda na, “Sa mia! Sèmi jaꞌa hia èu kahibꞌi ciꞌu?” Hèia Tamar dhaa hari, aku nèngu na, “Bisa ama. Sadꞌi ama hia ku jaꞌa mèdha èci ho jaꞌa kèdꞌu. Pe pèri lodꞌo ho ama paꞌadhu kahibꞌi èèna mai oo, ngaa-ngaa tao boe.” ");
INSERT INTO nfa_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Hèia Yahuda karèi hari, aku nèngu na, “De jaꞌa tèka mèdha ngaa mi èu?” Tamar dhaa, aku nèngu na, “Ama tèke eele cap, dènge dhari dhu ama inu, dènge tatea dhu ama kèpe èèna hèi.” Nanene nare ka, Yahuda hia mèdha sèra laꞌe. Hèia dua ra lasi bhèjꞌi ka. Èle èèna ka, Tamar lèpa laꞌe èmu. Dꞌai èmu ka, na bhoke mèdha-papake saraga dènge salalu, ka gati dènge mèdha-papake bhèni balu. Nèti èèna ka, Tamar dènge babia. ");
INSERT INTO nfa_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Nèbhu boe hèia, Yahuda manèngi tolong angalai na Hira, aku nèngu na, “Èu mèti kahibꞌi neꞌe hia dhèu bhèni kajeo dhu ètu Enaim èèna, ho mèti hari mèdha jaꞌa dhu ètu nèngu sèra.” Lodꞌo Hira laꞌe dꞌai nèi, na karèi palème, te ngaa paraga boe dènge bhèni èèna. ");
INSERT INTO nfa_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ka na karèi dhèu-dhèu ètu sèra, aku nèngu na, “Eee! Miu mèdhi dhèu bhèni kajeo dhu biasa madhèdi ètu hèbꞌa tedhe èèna, do? Na ètu mia, ee?” Dhèu sèra dhaa, aku rèngu na, “Ama, ètu neꞌe bhèni kajeo aadꞌo!” ");
INSERT INTO nfa_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hèia Hira lèpa hari peka dènge Yahuda, aku nèngu na, “Jaꞌa paraga boe dènge bhèni èèna. Jaꞌa tenge palème, te ngaa dhèu ètu sèra peka aku rèngu na, ètu rae èèna bhèni kajeo aadꞌo.” ");
INSERT INTO nfa_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda dhaa, aku nèngu na, “Hudꞌi ka la, nèngu abhu mèdha sèra! Sadꞌi dhèu baku pamakae èdhi! Jaꞌa neo bꞌae, te ngaa èdhi paraga boe dènge bhèni èèna na.” ");
INSERT INTO nfa_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ropa dꞌai tèlu hèru hèia, dhèu lasi lolo dènge Yahuda, peka na, “Dhèu èmu ana èu na tao ngiꞌu na sèmi dhèu bhèni kajeo. Ka na dènge babia le.” Nanene nare èèna hèia, Yahuda nasa bia. Hèia na pua dhèu, aku nèngu na, “Lami nuni paꞌoro ne mai, ho labhu asa dꞌara ai laꞌe!” ");
INSERT INTO nfa_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ka dhèu lasi ka nuni rèti Tamar mai. Te ngaa na padꞌelo cap dènge tatea èèna. Ka na pua dhèu lasi peka dènge toꞌo na, aku nèngu na, “Parisa ku mèdha seꞌe. Dhèu dhu unu cap dènge tatea neꞌe ka dhu adꞌu-ue tatao neꞌe, ka jaꞌa dènge babia ne.” ");
INSERT INTO nfa_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ropa nèdhi mèdha seꞌe, Yahuda tadhe dènge, na mèdha sèra unu nèngu. Hèia na padhai lii dènge ka, aku nèngu na, “Mema dhèu bhèni neꞌe sala boe. Jaꞌa ka dhu sala. Madhutu iia na, jaꞌa ka dhu paleo bhèni neꞌe dènge ana jaꞌa Sela. Te ngaa jaꞌa ka koꞌo boe.” Karèi nèti èèna ka, Yahuda paꞌèci heka dènge Tamar. ");
INSERT INTO nfa_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Dꞌai hèru ka Tamar nara iisi ana dhèu dua. ");
INSERT INTO nfa_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Lodꞌo Tamar nara iisi na, kabèdhi laa ana èci pacèu uuru kacui-aai èci sa liꞌu mai. Ka dhèu ai tadha dhu panara iisi na nare loa hèngu mea, ka èki mi kanau riti na. Bhèni na peka, aku nèngu na, “Ana uuru ka neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Te ngaa ana èèna ère hari kacui-aai na sa dꞌara. Hèia, ana èci na kalua uuru hari. Nèdhi sèmi èèna hèia, bhèni ai tadha èèna peka, aku nèngu na, “Waa! Èu èra titu kèna! Nèti èèna ka, èu paseti ho kalua uuru sa liꞌu.” Bhèni na pangare ne, Peres, (dhu sasoa na, ‘paseti sa liꞌu’). ");
INSERT INTO nfa_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Èle èèna ka, dhu èki dènge loa hèngu mea deo na kalua. Ra pangare ne Sera (sasoa na ‘mea gèu-gèu’). ");
INSERT INTO nfa_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Dhèu Ismael sèra rèti Yusuf dꞌai Masir, hèia ra pahie eele ne dènge dhèu kapai èci ètu nèi, ngara na Potifar. Dhèu neꞌe komedhaa sordadꞌu dhu jꞌaga ètu dhèu aae Masir. Yusuf jꞌajꞌi ènu ètu èmu Potifar. Ètu èèna, LAMATUA dènge Yusuf, ka sasabꞌa ngaa dhu na tao, nèti babeꞌa hua-hua. ");
INSERT INTO nfa_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Dhèu kapai neꞌe ladhe-ladhe na, sasabꞌa Yusuf nèti babeꞌa hua, ka na ngee ètu dꞌara na, LAMATUA tareꞌa-reꞌa dènge Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nèti èèna ka, komedhaa neꞌe dꞌèi Yusuf, ka na lèka ne. Hèia na dedꞌe ne jꞌajꞌi madho ètu èmu na. Aa, na hia ne paredha dꞌara èmu nèngu, sèmi èèna kahèi, mèdha-panyau na aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Lula Yusuf pea ètu èèna, ka Lamatua hia mamuri hua iia mi lamatua èmu, dhèu Masir èèna. Isi èmu na, mèdha-panyau na, oka-tedhe na, aa sasabꞌa-laꞌa na, jꞌajꞌi dènge beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Lula Potifar ladhe-ladhe laꞌa na Yusuf sabꞌa dènge beꞌa, ka na pangee heka ngaa-ngaa, dhoka naꞌa-ninu di. Yusuf ne, mone iia. ");
INSERT INTO nfa_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Na pea ètu èèna nèbhu mèka. Te ngaa dhèu èmu Potifar na, dꞌèi Yusuf. Ka na mai pamako ne ho dua ra jꞌunu paꞌèci. ");
INSERT INTO nfa_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Te ngaa Yusuf noꞌo boe. Ka na peka sèmi neꞌe ka, “Baku ina ee! Jaꞌa ne, ènu Potifar, dhu na pangèdꞌu le koasa ho jaꞌa tao ai-hèbꞌa mi sasabꞌa nèngu aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ètu dꞌara èmu neꞌe, abhu boe dhèu èci sa dhu koasa risi nèti jaꞌa. Aaꞌi-aaꞌi dhu ètu dꞌara èmu neꞌe, na saraka mi kacui-aai jaꞌa. Dhodhoka ina ku di, aadꞌo. Tasamia ka, jaꞌa bisa tao jꞌara karehe neꞌe. Èèna lèke boe dènge dadꞌèi Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Masi ka sèmi èèna, dhèu èmu Potifar ne pakaseti taruu bèli-bèli. Te ngaa Yusuf ne tao boe madha-dhilu dènge ne. ");
INSERT INTO nfa_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ca tèka, Yusuf kako laꞌe asa dꞌara èmu, ho sabꞌa sasabꞌa nèngu. Lodꞌo èèna, dhèu leo aadꞌo èci sa ètu èmu. ");
INSERT INTO nfa_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ka dhèu èmu Potifar na raga mai ka, na kèpe kodho Yusuf, ka na ère ne, hèia na peka, aku nèngu na, “Mai! Ata dhodhoka èdhi dua ti. De mai ho ti jꞌunu.” Te ngaa Yusuf dꞌèi boe. Ka na parui, hèia kodho na bhoke eele nèti ua na, ka na rai asa liꞌu. Aa kodho deo na ètu kacui-aai bhèni èèna era. ");
INSERT INTO nfa_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ropa dhèu èmu Potifar ladhe laa, na, Yusuf rai liꞌu le laꞌe, aa kodho na tèke eele, ");
INSERT INTO nfa_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","hèia na paroa dhèu sabꞌa sèra, ka na peka, aku nèngu na, “We! Miu mai ladhe ku laa! Deo na, ana mone dhèu Ibrani na, maso sa dꞌara kama jaꞌa. Na neo pamakae jaꞌa. Malo ka jaꞌa paꞌoo, ka na rai, tèke eele kodho na ètu jaꞌa ne. Dhèu èmu jaꞌa ne, nèti dhèu bhelu asa dꞌara èmu, ho hia èdhi taꞌe makae!” ");
INSERT INTO nfa_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Bhèni na kèpe paꞌère kodho èèna, toke dꞌai dhèu èmu na lèpa. ");
INSERT INTO nfa_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ropa dhèu èmu na nare dꞌara èmu, na lolo peka na, “Aꞌa! Dhèu Ibrani dhu mèti mai sa èmu neꞌe, deo na maso asa dꞌara kama jaꞌa, neo pakarehe jaꞌa! ");
INSERT INTO nfa_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Malo ka jaꞌa paꞌoo, paroa ana sabꞌa seꞌe. Hèia na rai tèke eele kodho na, ka neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tadèngi nare lii lolo dhèu èmu na, Potifar nasa bia. ");
INSERT INTO nfa_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Hèia na paredha ka dhèu lasi kèpe Yusuf. Ka ra pamaso asa dꞌara bèdho dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Te ngaa LAMATUA bhèlu boe Yusuf. Nèti èèna ka, LAMATUA ladhe-leru ne taruu, ka kapala ètu dꞌara bèdho èèna, sue Yusuf ae titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Na lèka Yusuf, ka hia ne jꞌajꞌi madho ho laladhe ana bèdho sèra aaꞌi-aaꞌi ra. Aa, hia na lalau sasabꞌa ètu èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Lula lèka ne, ka kapala èmu bèdho na, tao heka ai-hèbꞌa mi ngaa-ngaa ètu dꞌara bèdho èèna. LAMATUA ladhe-leru taruu Yusuf, nèti èèna ka, sasabꞌa ngaa ètu dꞌara bèdho na kako dènge beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Ètu dꞌara bèdho èèna, abhu kahèi dhèu dua, dhu uru na jꞌajꞌi kapala urusan ètu dꞌara èmu dhèu aae Masir. Èci lalau dhua èi dhèu aae. Aa èci hari lalau roti dhèu aae. Dua ra tao pasala dhèu aae. Nèti èèna ka, dhèu aae nasa, ka na pamaso si asa dꞌara bèdho. Dua ra pea ètu era èci dènge Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kapala èmu bèdho na, paredha Yusuf lalau dhèu dua seꞌe. Ra ètu dꞌara bèdho na, ele boe ca tèu do dua tèu le. ");
INSERT INTO nfa_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Mèda ca lodꞌo ka, dua ra nii. Ca dhèu ka dènge nii na. Aa, lii nii dua sèra, èci-èci ka dènge sasoa na. ");
INSERT INTO nfa_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Bèli madꞌae èèna, Yusuf ladhe na dua ra rèhu susa. ");
INSERT INTO nfa_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ka na karèi si, aku nèngu na, “Nga tao ka madꞌae neꞌe, miu dua mi roe-roe?” ");
INSERT INTO nfa_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Hèia ra dhaa, peka na, “Mèda deo na, jiꞌi nii. Te ngaa jiꞌi ngeꞌa boe sasoa na samia!” Hèia Yusuf peka dènge dua ra, aku nèngu na, “Dhèu aaꞌi-aaꞌi ètu rai-haha neꞌe, èci sa reꞌa boe sasoa nii, dhodhoka Ama Lamatua di. De miu lolo ku laa. Pe èèna ho jaꞌa karèi sasoa nèti Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Hèia dhèu dhu lalau dhua èi hia dhèu aae èèna, lolo uuru peka na, “Ètu dꞌara nii, jaꞌa ladhe kèdhi ajꞌu anggor ca kapua. ");
INSERT INTO nfa_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ajꞌu anggor ne dadana nèngu tèlu di. Ajꞌu na muri mai ka dènge rèu, hela, dènge hua giru-gari dhu madhasa. ");
INSERT INTO nfa_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Aa jaꞌa kèdꞌu galaa dhu dhèu aae biasa pake ninu. Jaꞌa puu hua anggor, ka pacèli èi sa dꞌara galaa deo na. Hèia kèti asa dhèu aae, hia na ninu.” ");
INSERT INTO nfa_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Tadèngi nare hèia, Yusuf peka dènge ne sèmi neꞌe ka, “Ama, ee. Sasoa nii na sèmi neꞌe ka: dadana tèlu, sasoa na di tèlu lodꞌo ka. ");
INSERT INTO nfa_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ètu dꞌara tèlu lodꞌo ne, dhèu aae kalua eele ama nèti dꞌara bèdho neꞌe. Ho na hia hari, ama lalau dhua èi hia dhèu aae sèmi uru na. ");
INSERT INTO nfa_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ladhe ama abhu babeꞌa sèmi èèna, baku bhèlu jaꞌa, ee? Ladhe ama sue jaꞌa, peka dènge dhèu aae kalua eele jaꞌa nèti era neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Te jaꞌa ne, madhutu madha jꞌara na dhu mola, rèngu se rare jaꞌa dènge laka-seti, nèti rae dhèu Ibrani. Dꞌai era neꞌe, jaꞌa tao boe sasala ngaa èci sa. Te ngaa rèngu pamaso jaꞌa asa dꞌara bèdho neꞌe. Rèngu tao jaꞌa sèmi dhèu bhelu-katubꞌa sa.” ");
INSERT INTO nfa_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ropa tadèngi nare sasoa nii neꞌe beꞌa mi dedha angalai na, hèia dhèu èci dhu lalau roti na, lolo hari nii nèngu, peka na, “Ari Yusuf. Nii jaꞌa sèmi neꞌe ka: jaꞌa tèdꞌu soe pagodꞌo-godꞌo tèlu. ");
INSERT INTO nfa_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ètu dꞌara soe re dedha tèka na, pènu dènge koki dhèu aae, dhu rupa ae titu kèna. Te ngaa manu-bhui lela mai ka raꞌe aaꞌi koki dꞌara soe dhu ètu kètu jaꞌa na.” ");
INSERT INTO nfa_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ropa Yusuf tadèngi nare, ka na dhaa, peka na, “Sasoa lii nii ama, sèmi neꞌe ka: soe tèlu sèra, sama kahèi dènge tèlu lodꞌo. ");
INSERT INTO nfa_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dꞌara tèlu lodꞌo ne, mu ladhe, te dhèu aae pua dhèu mai poro rare kètu èu. Ho èèna na, ra kadhoe ngiꞌu aae èu ètu agarii. Hèia manu-bhui tutu raꞌe aaꞌi sisi èu.” ");
INSERT INTO nfa_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ropa dꞌai tèlu lodꞌo, dhu lèke dènge lodꞌo hari jadi dhèu aae, na tao tatao dhu kapai hia dhèu kapai na aaꞌi-aaꞌi sèra. Na paredha ho dhèu lasi kalua eele dhèu dua sèra nèti dꞌara bèdho. ");
INSERT INTO nfa_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ka na hia hari mone dhu lalau dhua èi na, sabꞌe sasabꞌa nèngu uru na. ");
INSERT INTO nfa_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Te ngaa dhèu dhu lalau roti dhèu aae èèna, ra poro eele kètu na, ka ra kadhoe ngiꞌu na, sama sèmi ngaa dhu Yusuf peka dènge rèngu dua ra. ");
INSERT INTO nfa_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Te ngaa mone dhu lalau dhua èi dhèu aae ne, sanèdꞌe heka Yusuf. Na bhèlu eele lii moa Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Pe dꞌai dua tèu risi sa, hèia dhèu aae Masir nii. Na nii na, nèngu dhu titu ètu sebhe loko Nil. ");
INSERT INTO nfa_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kabèdhi laa, nèngu nèdhi sapi pidhu ngiꞌu dhu kabèbꞌu bia. Kaꞌuri ra kaleꞌe. Ra kalua nèti dꞌara loko, ka raꞌa jꞌuꞌu ètu sebhe loko èèna. ");
INSERT INTO nfa_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nèbhu boe, sapi pidhu ngiꞌu dhu leo hari, kalua nèti dꞌara loko deo na. Ngiꞌu sapi sèra malaka-godꞌa. Ra titu padètu dènge sapi kabèbꞌu sèra. ");
INSERT INTO nfa_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Hèia sapi malaka pidhu ngiꞌu sèra, dhèle aaꞌi pidhu sapi dhu kabèbꞌu sèra. Hèia dhèu aae kabèdhi, ka na marèi dènge. ");
INSERT INTO nfa_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nèbhu boe ka, dhèu aae bhèjꞌi luu hari. Ka na nii hari ca tèka. Lii nii na sèmi neꞌe ka: nèngu ladhe nèdhi are pidhu huri dhu isi pènu, bhodho nèti laa are dhu subꞌu. ");
INSERT INTO nfa_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Èle èèna ka, nèdhi hari are pidhu huri dhu isi aadꞌo, aa dhu kamale dhae-dhae sène, lèke lai ngèlu dhu pana. ");
INSERT INTO nfa_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ka pidhu huri are dhu isi aadꞌo sèra, dhèle aaꞌi pidhu huri are dhu isi pènu deo sa. Hèia dhèu aae kabèdhi ka nèti bhèjꞌi. Heka nèngu neꞌa kèna, nèngu dhu nii hari di. ");
INSERT INTO nfa_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Madꞌae aae èèna, dꞌara isi na beꞌa boe. Hèia, na paredha dhèu lasi paroa aaꞌi dhèu ai tadha dènge dhèu dꞌèlu-mèu, ètu rai Masir mai paraga dènge ne. Ka na lolo lii nii na sèra dènge si. Te ngaa dhèu èci sa bisa boe peka sasoa lii nii deo sa mi dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ka mone dhu lalau dhua èi dhèu aae èèna, heka sanèdꞌe nèdhi Yusuf kèna. Hèia laꞌe peka dènge dhèu aae, aku nèngu na, “Ama! Jaꞌa mangaku sala. ");
INSERT INTO nfa_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Uru èèna, dhu ama ku nasa dènge jaꞌa, dènge angalai ku èci na, ka pamaso jiꞌi asa dꞌara bèdho, ");
INSERT INTO nfa_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","mèda ca lodꞌo ka, jiꞌi dua mi nii. Èci-èci ka dènge nii na. Aa sasoa nii seꞌe, sama boe kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ètu dꞌara bèdho na, abhu ana mone Ibrani èci. Kapala èmu bèdho nedhe ana mone ne, jꞌajꞌi kapala urusan ho lalau jiꞌi. Jiꞌi lolo lii nii jiꞌi dènge ne, ka na peka sasoa lii nii sèra dènge jiꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nèti èèna ka, ama dhèu aae dedꞌe hari jaꞌa. Aa angalai jaꞌa na, abhu huku madhe. Seꞌe se jꞌajꞌi sama sèmi ngaa dhu ana mone Ibrani na peka.” ");
INSERT INTO nfa_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Nanene nare lii neꞌe hèia, dhèu aae pua dhèu lasi lai-lai rare Yusuf nèti dꞌara bèdho mai. Ka Yusuf pamèu iisi na, aa na gati mèdha-papake na, ka na laꞌe paraga dènge dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ropa na dꞌai madha hèia, dhèu aae peka, “Jaꞌa nii, te ngaa dhèu èci sa reꞌa boe sasoa lii nii sèra. Te ngaa dhèu peka na èu meꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Hèia Yusuf dhaa, aku nèngu na, “Ama dhèu aae. Jaꞌa èèna ka oo, keꞌa boe ngaa-ngaa kahèi. Dhoka Ama Lamatua di dhu neꞌa, ho Na peka sasoa lii nii sa, dènge lèke. Na neo peka lii dhu beꞌa mi ama dhèu aae.” ");
INSERT INTO nfa_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Hèia dhèu aae lolo ka, lii nii sèra dènge ne, aku nèngu na, “Ètu dꞌara nii èèna, jaꞌa titu ètu sebhe loko Nil. ");
INSERT INTO nfa_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Jaꞌa ladhe laꞌa na sapi pidhu ngiꞌu dhu kabèbꞌu bia, dènge kaꞌuri dhu kaleꞌe. Ra kalua nèti dꞌara loko mai, ka raꞌa jꞌuꞌu ètu sebhe loko èèna. ");
INSERT INTO nfa_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Hèia sapi pidhu ngiꞌu dhu leo mai hari. Rèngu seꞌe dhu malaka-godꞌa. Ètu rai Masir neꞌe, jaꞌa kèdhi mèka sapi dhu malaka-godꞌa sèmi èèna! ");
INSERT INTO nfa_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Dhu pamalaa jaꞌa, pidhu sapi dhu malaka-godꞌa sèra, kabèdhi laa dhèle aaꞌi pidhu sapi dhu kabèbꞌu se. ");
INSERT INTO nfa_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Sapi dhu malaka sèra dhèle aaꞌi, te ngaa ngiꞌu ra malaka taruu sèmi èèna ka. Hèia jaꞌa kabèdhi dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Èle èèna ka, jaꞌa bhèjꞌi luu hari, ka nii hari ca tèka. Jaꞌa kèdhi pidhu huri are dhu isi pènu, kalua nèti laa are ca kapua dhu subꞌu. ");
INSERT INTO nfa_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Èle èèna ka, jaꞌa kèdhi hari, pidhu huri are dhu isi aadꞌo, aa dhu kamale dhae-dhae, lèke lai ngèlu pana. ");
INSERT INTO nfa_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ka pidhu huri are dhu bèdhu sèra dhèle aaꞌi pidhu huri are dhu isi pènu sèra. Èle èèna ka, jaꞌa kèdꞌi nèti bhèjꞌi. Ka jaꞌa lolo lii nii seꞌe mi dhèu dꞌèlu-mèu seꞌe, te ngaa èci sa bisa boe peka sasoa lii nii sèra.” ");
INSERT INTO nfa_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Hèia Yusuf padhai lii, peka na, “Ama dhèu aae! Lii nii dua sèra, sasoa na dhoka èci di. Ama Lamatua peka le, mi ama dhèu aae, ngaa dhu Na neo tao. ");
INSERT INTO nfa_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sasoa na sèmi neꞌe ka: pidhu sapi dhu kabèbꞌu, dènge pidhu huri are dhu isi pènu sèra, sasoa na, tèu dhu bècu-manèsa pidhu tèu. Sasoa ra dhoka èci di. ");
INSERT INTO nfa_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sèmi èèna kahèi, pidhu sapi dhu malaka-godꞌa, dènge pidhu huri are dhu isi aadꞌo, sasoa na, tèu manganga pidhu tèu. ");
INSERT INTO nfa_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","De Lamatua dhu peka mema le, ngaa dhu Nèngu neo tao. Èèna sama kahèi, dènge ngaa dhu jaꞌa peka deo na. ");
INSERT INTO nfa_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ladhe bèli-camèdꞌa, ètu rai Masir neꞌe, dꞌara pidhu tèu, èdhi abhu bècu-manèsa palème rae. ");
INSERT INTO nfa_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Èle èèna na, heka èdhi abhu manganga dꞌara pidhu tèu. Dꞌara pidhu tèu na, manganga madèu aae. Toke èdhi abhu boe ngangaꞌa calamusi sa, ètu dedha rai Masir neꞌe. Dhèu aaꞌi-aaꞌi manganga ae titu kèna, ka ra bhèlu eele uru na dhu rèngu abhu le babècu pidhu tèu. ");
INSERT INTO nfa_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","De ladhe ama dhèu aae abhu nii dua hari, sasoa na, Ama Lamatua ka dhu ator tèke. Nèbhu heka, ngaa dhu Na ator ne, jꞌajꞌi kèna. ");
INSERT INTO nfa_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Nèti èèna ka, jaꞌa manèngi sèmi neꞌe: beꞌa risi ama dhèu aae tenge dhèu dꞌèlu-mèu èci, dhu bisa tao ai-hèbꞌa laꞌa dènge beꞌa. Aa dedꞌe ne, ho ladhe-leru kabarai neꞌe dènge beꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Dꞌara pidhu tèu dhu bècu èèna, beꞌa risi ama dhèu aae dedꞌe hari dhèu, ho ra oru-pakaboko ngangaꞌa dhu risi eele. Ngangaꞌa dhu risi sèra, bagi mi lèmi ho tèke ca pala. ");
INSERT INTO nfa_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ana kabarai neꞌe, hudꞌi madhutu dènge beꞌa paredha ama dhèu aae, ho pakaboko are-are dhu risi eele, nèti rae-rae ètu rai Masir neꞌe. Aa ra soli sa dꞌara soka ho jꞌaga paie. ");
INSERT INTO nfa_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Sèna ka pidhu tèu dhu manganga nèi mai te, èdhi dhu sadia le ngangaꞌa. Dènge jꞌara sèmi neꞌe, èci sa madhe boe manganga.” ");
INSERT INTO nfa_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ropa tadèngi lii padhai lii Yusuf ne, dhèu aae dènge dhèu kapai sèra, sèmi ngaa dhu na peka dènge dhèu aae èèna. ");
INSERT INTO nfa_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ka dhèu aae padhai lii, peka na, “Roh Ama Lamatua hia le koasa mi Yusuf neꞌe. Nèti èèna ka, èdhi abhu heka dhèu dhu risi nèti nèngu.” ");
INSERT INTO nfa_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Èle èèna ka, dhèu aae padhai lii dènge Yusuf, peka na, “Ama Lamatua peka dènge èu, ngaa-ngaa seꞌe aaꞌi-aaꞌi. Nèti sèmi neꞌe ka, heka jiꞌi ngeꞌa kèna èu neꞌe tareꞌa-reꞌa dhèu mèu. Aa mamèu èu ne, risi eele dhèu ètu mia-mia. ");
INSERT INTO nfa_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nèti èèna ka, deo neꞌe kahèi jaꞌa dedꞌe èu jꞌajꞌi ai gꞌana jaꞌa. Sèna ka èu jꞌajꞌi dhèu kapai ètu dꞌara èmu jaꞌa. Aa ana kabarai jaꞌa nanene lii paredha èu. Dhoka jaꞌa di dhu risi nèti èu.” ");
INSERT INTO nfa_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Èle èèna ka, dhèu aae puru eele kadheli dhu dènge cap nèti ai na, ka na pasaluu mi ai Yusuf. Ka na padhai lii, aku nèngu na, “Dènge neꞌe ne, jaꞌa dedꞌe èu, jꞌajꞌi ai gꞌana jaꞌa ètu rai Masir.” Hèia na papake kodho madhera dhu milu èci mi Yusuf, aa na paꞌinu rate hualaa cakoko mi ladha-goro na. ");
INSERT INTO nfa_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Èle èèna ka, dhèu aae hia hari Yusuf kareta ka dua nèngu. Ka na hia dhèu lasi uuru, ho paꞌoo peka na, “We! Patalele jꞌara oo! Pahaha iisi mliu! Dhèu kapai neo re neꞌe!” Dènge jꞌara neꞌe, dhèu aae dedꞌe le Yusuf, jꞌajꞌi ai gꞌana na ètu rai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Hèia dhèu aae padhai lii dènge Yusuf, peka na, “Sèmi neꞌe. Èu dhu meꞌa le jaꞌa ne dhèu aae. Te ngaa jaꞌa peka le dènge ana kabarai Masir aaꞌi-aaꞌi, peka na, ladhe èu hia boe ijin, rèngu bisa boe tao ngaa èci sa.” ");
INSERT INTO nfa_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Èle ka, dhèu aae pangare Yusuf madhutu ngara Masir, na Safnat Panea. Aa, na hia Yusuf madhèdi dènge ana bhèni èci, ngara na Asnat. Ama dhèu èmu na, ngara na Potifera. Nèngu neꞌe ka dhu jꞌajꞌi ama agama ètu dꞌara kota On. Dènge jꞌara neꞌe, Yusuf jꞌajꞌi dhèu kapai ètu rai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Lodꞌo na jꞌajꞌi dhèu kapai ètu rai Masir, umur nèngu 30 (tèlu nguru) tèu le. Hèia na kako palème rai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ètu dꞌara pidhu tèu dhu bècu-manèsa neꞌe, oka-tedhe pènu dènge ngangaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Hèia Yusuf kaboko ngangaꞌa dhu risi, ka na tèka paia si. Ètu era mia dhu na pakaboko ngangaꞌa, ètu èèna kahèi na soli asa dꞌara soka. ");
INSERT INTO nfa_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Are dhu pakaboko nare, ae titu kèna. Èci èèna ka, dènge salae ètu nebhe dhasi, ka dhèu uku rare heka. ");
INSERT INTO nfa_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Dꞌai mèka tèu manganga, dhèu èmu Yusuf, Asnat nara iisi le ana mone dhèu dua. ");
INSERT INTO nfa_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ka Yusuf padhai lii, peka na, “Ama Lamatua tao jꞌara neꞌe, sèna ka pabhèlu jaꞌa nèti jꞌajꞌèra dhu lodꞌo jaꞌa kalua nèti dꞌara èmu ama ku.” Nèti èèna ka, ana uuru, na pangare ne Manase (dhu sasoa na ele boe ‘bhèlu’). ");
INSERT INTO nfa_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Lodꞌo na abhu ana ka dua, na padhai lii hari, peka na, “Jaꞌa abhu jꞌajꞌèra ae dꞌai seli ètu era neꞌe. Te ngaa sasue dènge ladhe-leru Ama Lamatua ka, jaꞌa abhu ana ètu neꞌe.” Ka na pangare ana neꞌe Efraim. ");
INSERT INTO nfa_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nèbhu boe ka, èle pidhu tèu dhu bècu-manèsa na. ");
INSERT INTO nfa_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Aa pidhu tèu manganga madèu dꞌai kèna, sama sèmi dhu uru èèna Yusuf peka le. Ètu era leo, dhèu manganga le. Te ngaa rae-rae ètu Masir ngangaꞌa ae era. ");
INSERT INTO nfa_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Te ngaa nèbhu-nèbhu, kabarai Masir manganga kahèi. Ka lasi asa dhèu aae ho ra manèngi ngangaꞌa. Aa dhèu aae pua si lasi asa Yusuf, sèna ka ra madhutu paredha Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Te ngaa rai manganga ètu mia-mia asa tabha, toke dꞌai rae-rae ètu rai Masir. Nèti èèna ka, Yusuf bhoke aaꞌi soka ngangaꞌa sèna ka pahie dènge dhèu Masir. ");
INSERT INTO nfa_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Lula manganga ae titu kèna, ka dhèu nèti mia-mia mai hèli ngangaꞌa ètu Yusuf ètu rai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Tèu èèna, Yakob tadèngi dhèu palolo na abhu are ètu Masir. Ka na peka dènge ana na si, aku nèngu na, “Ana ee! Miu nga tao madhèdi mau-mau ka laa? ");
INSERT INTO nfa_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Jaꞌa tadèngi na ètu Masir pahia ngangaꞌa. Hua iia lami hèli, sèna ka èdhi baku madhe manganga.” ");
INSERT INTO nfa_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ka aꞌa Yusuf canguru dhèu seꞌe paꞌèra ka, lasi hèli ngangaꞌa asa Masir. ");
INSERT INTO nfa_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Te ngaa Yakob hia boe ari Yusuf dhu ngara na Benyamin, laꞌe dènge aꞌa na si. Te, na pangee, “Mage dhoka, ana neꞌe abhu hari jꞌajꞌèra ètu talora jꞌara.” ");
INSERT INTO nfa_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Lula dhèu ae nèti mia-mia tadèngi le abhu ngangaꞌa ètu Masir, ka ra lasi hèli asa nèi. Manganga ne dꞌai le rai Kanaꞌan kahèi. Ka ana-ana Yakob se, lasi hèli kahèi asa Masir. ");
INSERT INTO nfa_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tèu èèna, Yusuf jꞌajꞌi ai gꞌana dhèu aae Masir. Ladhe dhèu nèti mia-mia mai hèli are, Yusuf ka dhu pahia. Nèti èèna ka, lodꞌo aꞌa na si dꞌai nèi, rèngu patitu kètu urutuu, ho tabꞌe Yusuf toke rèhu rèngu oe dꞌai rai. ");
INSERT INTO nfa_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Ropa Yusuf ladhe nèdhi aꞌa na si, na tadhe le èèna. Te ngaa Yusuf tao iisi sèmi dhèu Masir. Nèti èèna ka, rèngu tadhe boe ne hèi. Hèia na jèka si, aku nèngu na, “Ee! Miu se nèti mia?” Hèia ra dhaa, aku rèngu na, “Jiꞌi se nèti Kanaꞌan. Jiꞌi mai hèli ngangaꞌa sa ama wakil.” ");
INSERT INTO nfa_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Hèia Yusuf sanèdꞌe lii nii na uru na. Ka na pamadhaꞌu si, aku nèngu na, “Jaꞌa lèka boe! Miu seꞌe dhèu mata-mata. Miu mai tenge rahasia rai Masir, ho èèna na mai musu rai jiꞌi!” ");
INSERT INTO nfa_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Te ngaa ra dhaa peka na, “Aadꞌo, ama! Jiꞌi seꞌe dhoka ana pua-paleha nèti ama di. Tareꞌa-reꞌa jiꞌi mai sa neꞌe ne, neo hèli ngangaꞌa di. Leo nèti èèna, aadꞌo. ");
INSERT INTO nfa_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Jiꞌi aaꞌi-aaꞌi seꞌe, ana nèti ca ama di. Jiꞌi mai mata-mata boe rai ama ku si neꞌe. Jiꞌi seꞌe dhèu beꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Te ngaa Yusuf jèka si dènge lii mèdhu hari, peka na, “He! Omo koso! Baku kapodꞌe-kabèli jaꞌa. Miu seꞌe tareꞌa-reꞌa dhèu bhelu. Miu mai tenge rahasia rai neꞌe!” ");
INSERT INTO nfa_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ka ra peka, “Aadꞌo ama! Jiꞌi seꞌe ana pua-paleha ama ku di. Jiꞌi mai nèti rai Kanaꞌan. Jiꞌi aaꞌi-aaꞌi mi nèti ca ama, canguru dua dhèu. Ari jiꞌi dhu limuri tèka, pea dènge ama jiꞌi. Aa ari jiꞌi èci aadꞌo heka!” ");
INSERT INTO nfa_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Hèia Yusuf dhaa, aku nèngu na, “Aadꞌo! Lèke sèmi lii jaꞌa deo na! Miu seꞌe dhèu mata-mata. ");
INSERT INTO nfa_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Na! Karèi sèmi èèna, na miu hia ku tadha èci, sèna ka jaꞌa keꞌa lii padhai lii miu deo sa, tareꞌa, do aadꞌo. Jaꞌa subha ee! Ladhe ari miu dhu limuri na, dꞌai boe neꞌe, miu èci sa bisa boe kalua nèti rai neꞌe! ");
INSERT INTO nfa_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","De hua iia miu pua dhèu èci laꞌe, ho nèti ari miu dhu limuri èèna asa neꞌe mai. Aa miu dhu leo se, jaꞌa taha. Jaꞌa neo keꞌa miu seꞌe peka tareꞌa, do aadꞌo. Ladhe aadꞌo, miu seꞌe tareꞌa-reꞌa mata-mata.” ");
INSERT INTO nfa_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ka Yusuf pua taha si dꞌara bèdho tèlu lodꞌo. ");
INSERT INTO nfa_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Dꞌai lodꞌo ka tèlu, Yusuf laꞌe padhai lii dènge ra ètu dꞌara bèdho, peka na, “Jaꞌa neꞌe, ca dhèu dhu madhaꞌu dènge Lamatua. Aa jaꞌa madhutu dadꞌèi Na taruu. Sèna ka miu mamuri, jaꞌa neo patabuli miu. Te ngaa hudꞌi dènge ku lii pajaji. ");
INSERT INTO nfa_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ladhe miu seꞌe tareꞌa padhai lii dhu mola, miu padꞌelo ku ngaa èci jꞌajꞌi mi tadha. Jꞌara na sèmi neꞌe: jaꞌa taha ca dhèu ètu dꞌara bèdho neꞌe. Dhèu leo lèpa ho mèti ngangaꞌa hia aꞌari miu, te ra tatae miu lami mèti ngangaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Dꞌai nèi, miu mèti ari miu dhu limuri èèna mai asa neꞌe, ho jꞌajꞌi bukti, tareꞌa miu seꞌe dhèu beꞌa. Sèna ka jaꞌa baku huku pamadhe miu.” Ropa ra tadèngi rare neꞌe, ra dꞌèi kahèi sèmi èèna. ");
INSERT INTO nfa_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ka ra padhue-padhai ka èci dènge èci, peka na, “Waa! Neꞌe ne, èdhi heka abhu bꞌala kèna, lula sala dhu èdhi adꞌu-ue mi dedha ari èdhi uru na. Èdhi ladhe tèdhi nèngu jꞌèra titu kèna, dꞌai na manèngi sasue èdhi, te ngaa èdhi pusi boe ne. Nèti èèna ka, èdhi abhu jꞌajꞌèra sèmi neꞌe ne.” ");
INSERT INTO nfa_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Hèia Ruben pasanèdꞌe si, peka na, “We! Ari-ari jaꞌa, ee! Uru na jaꞌa kai le miu, ho baku pajꞌèra ana èèna, si? Te ngaa miu-miu seꞌe ka dhu moꞌo boe nanene lii jaꞌa. Nèti èèna ka, lodꞌo neꞌe èdhi dui tare raa ari èdhi Yusuf èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Rèngu padhai lii ae-ae sèmi èèna, reꞌa boe na Yusuf neꞌa lii rèngu kahèi. Lodꞌo Yusuf padhai lii dènge rèngu, na pake lii Masir, ho èèna na dhèu leo lole hari pake lii Ibrani. ");
INSERT INTO nfa_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tadèngi ra padhai lii sèmi èèna hèia, Yusuf kèdꞌi eele si, laꞌe tangi asa era leo. Tangi nare, laꞌe hari paꞌèci dènge si. Ka na pua dhèu èki Simeon ètu madha aꞌari na sèra. ");
INSERT INTO nfa_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Èle èèna ka, Yusuf paredha dhèu sabꞌa sèra, ho soli are asa dꞌara karo aꞌa na si. Aa tao hari doi kabꞌua are sèra, asa dꞌara karo ra èci-èci. Ra tèke ètu hèbꞌa karo sèra. Na pua dhèu sabꞌa seꞌe, ho hia si dènge gee. Ka dhèu sabꞌa seꞌe lalau ka, madhutu ngaa dhu Yusuf paredha. ");
INSERT INTO nfa_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Èle ka, aꞌa na si hua karo ngangaꞌa sèra asa dedha badha keledꞌei. Ka ra pakèdꞌi dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ropa dꞌai talora jꞌara, ra ae. Dhèu èci bhoke karo na, ho neo ani keledꞌei na. Na ladhe laꞌa na, doi na ètu dedha are, ètu dꞌara karo èèna. ");
INSERT INTO nfa_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Capa na cagꞌagꞌa! Hèia na paroa aꞌa na si, peka na, “Irii! Miu mai ladhe ku laa! Madhe èdhi kèna. Ra tao hari doi jaꞌa asa dꞌara karo ne.” Ladhe rèdhi èèna ka, ra ele ngangee, aa madhaꞌu bia. Ka ra papeka ka, aku rèngu na, “Ama Lamatua tao èdhi samia ka ne?” ");
INSERT INTO nfa_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Hèia ra kako taruu ka, lasi dꞌai Kanaꞌan. Dꞌai nèi ka, ra lolo dènge ama ra, ngaa dhu rèngu paraga ètu rai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ra lolo, peka na, “Ama, ee! Ai gꞌana dhèu aae Masir èèna, bhelu titu kèna. Na jèka taruu jiꞌi. Na peka na jiꞌi laꞌa jꞌajꞌi mata-mata ho neo paꞌele iie rai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ka jiꞌi dhaa, peka na, ‘Aadꞌo! Jiꞌi seꞌe padhai lii mola-mola. Jiꞌi mata-mata boe. ");
INSERT INTO nfa_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Jiꞌi seꞌe, dhèu beꞌa-beꞌa. Jiꞌi aaꞌi-aaꞌi mi, jꞌajꞌi nèti ca ama, dhèu canguru dua. Te ngaa èci madhe le. Aa ari dhu limuri èèna, dènge ama jiꞌi ètu Kanaꞌan.’ ");
INSERT INTO nfa_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Na peka hari, aku nèngu na, ‘Jaꞌa neo kèdhi, na, miu seꞌe dhèu beꞌa, do aadꞌo! Miu èci, pea mi neꞌe. Aa leo lèpa mèti ngangaꞌa hia aꞌari miu, sèna ka ra baku madhe manganga. ");
INSERT INTO nfa_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Hudꞌi miu mèti ku ari miu èèna mai sa neꞌe, heka jaꞌa keꞌa kèna, tareꞌa-reꞌa miu seꞌe dhèu beꞌa, mata-mata boe. Èèna na, heka jaꞌa patabuli dhèu miu dhu jaꞌa taha ne. Aa dènge sèmi èèna, jaꞌa heka koꞌo kèna, miu kako palème dedha rai neꞌe.’ ” ");
INSERT INTO nfa_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Lolo èle hèia, heka ra bhoke karo-karo rèngu dhu pènu dènge are sèra. Te ngaa ra cagꞌagꞌa ladhe laꞌa na doi rèngu sèra aaꞌi-aaꞌi ra, ètu hèbꞌa karo. Rèdhi sèmi èèna, Yakob dènge ana-ana na madhaꞌu titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Hèia Yakob padhai lii dènge si, peka na, “Miu se, paꞌele le ana-ana jaꞌa. Yusuf aadꞌo heka. Sèmi èèna kahèi, Simeon. Neꞌe miu neo mèti hari Benyamin kèna? Miu seꞌe, tareꞌa-reꞌa neo pajꞌèra jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hèia Ruben peka dènge ama na, aku nèngu na, “Ama, ee! Pangèdꞌu laa Benyamin asa jaꞌa mai. Jaꞌa tago kore. Jaꞌa jaji kèna mi ama ku, èèna jaꞌa kèti hari na mai. Te ngaa ladhe aadꞌo, na jaꞌa hia ana jaꞌa, mone dhèu dua sèra ho ama pamadhe aaꞌi si.” ");
INSERT INTO nfa_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Te ngaa Yakob dhaa hari, peka na, “Bisa boe! Miu bisa boe mèti Benyamin. Te aꞌa na Yusuf, madhe le. Neꞌe, di nèngu ka mesa na. Ladhe na abhu calaka ètu jꞌara, miu tabha babia mi jaꞌa, toke madhe kèti.” ");
INSERT INTO nfa_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tèu èèna, ètu rai Kanaꞌan asa tabha manganga. ");
INSERT INTO nfa_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Isi èmu Yakob raꞌa aaꞌi le ngangaꞌa dhu ca hari na, ana na si lasi hèli ètu Masir. Ka na padhai lii dènge ana na si, “Beꞌa risi lami hari hèli ngangaꞌa asa rai Masir.” ");
INSERT INTO nfa_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Te ngaa Yahuda bꞌala, peka na, “Ama, ca hari na ai gꞌana dhèu aae Masir dhu pasanèdꞌe le jiꞌi, aku nèngu na, jiꞌi bisa boe padꞌelo rèhu mi nèngu, ladhe jiꞌi ngèti boe ari jiꞌi dhu limuri, Benyamin èèna. ");
INSERT INTO nfa_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nèti èèna ka, ama ku hudꞌi laa hia jiꞌi ngèti Benyamin. Heka jiꞌi bisa laꞌa hèli ngangaꞌa hia ama ku kèna. ");
INSERT INTO nfa_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Te ngaa ladhe ama patabuli boe nèngu, jiꞌi oo laꞌa boe kahèi. Lula dhèu Masir na peka le sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Hèia Yakob jèke si, peka na, “Nga tao ka miu lolo dènge dhèu èèna, peka na, miu dènge ari èci era? Miu tenge jꞌara ho pajꞌèra tabha jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ka ra dhaa, peka na, “Baku nasa ama, ee! Te lula dhèu ne, karèi taruu-taruu neo neꞌa aꞌari èdhi. Na karèi peka na, ‘Tasamia? Ama mi era, do? Miu dènge hari ari dhèu mone dhu leo, do?’ Sèmi èèna na, jiꞌi dhaa tasamia hari? Pakaseti ka jiꞌi dhaa ka laa, dènge mola-mola. Te pe, cee neꞌa na pua jiꞌi ngèti hari ari jiꞌi sa nèi?” ");
INSERT INTO nfa_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Ka Yahuda padhai lii hari, aku nèngu na, “Ama hudꞌi patabuli ku Benyamin laꞌe dènge jiꞌi. Jaꞌa jaji mema, ladhe jꞌajꞌi ngaa-ngaa mi ngiꞌu ari jiꞌi neꞌe, jaꞌa ka dhu gati ne. Ladhe jaꞌa kèti heka nèngu mai asa dꞌara kacui-aai ama ku dènge mamuri, hudꞌi laa sasala na ama ku pasae mi dedha jaꞌa toke madhe. Nèti èèna ka, ama ku hia la, ho jiꞌi sama-sama laꞌa dènge ne, te jiꞌi neo pakèdꞌi kèna. De karohe mai lati ka, sèna ka cahagꞌe baku madhe manganga. ");
INSERT INTO nfa_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ladhe sèmi èdhi mate boe panèbhu sèmi neꞌe, na, èdhi lati-mai dua hari le.” ");
INSERT INTO nfa_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Hèia ama ra padhai lii, peka na, “Ladhe sèmi èèna, na, miu nanene! Lami mere isi rai èdhi dhu beꞌa risi, sèmi: dhua nasu oni, bubhu-bubhu, raa ajꞌu hèu mèngi, èi naꞌi salap, kanari dènge kabꞌui dhu leo sèra. Ho sèna ka mèti hia ai gꞌana dhèu aae Masir èèna. Aa peka dènge ne, neꞌe ne tadha mata. ");
INSERT INTO nfa_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Aa miu mèti doi risi eele nèti ca hari ni, sèna ka miu bisa hia hari doi kabꞌua are uru sèra laꞌa, dhu miu mèdhi ètu dꞌara karo miu sèra. Tao-tao dhèu sèra reꞌa boe, ka tèka sala. ");
INSERT INTO nfa_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Miu mèti ari mu. De èèna na lèpa hari lai-lai! ");
INSERT INTO nfa_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Jaꞌa sanao-maena, sèna ka, Ama Lamatua dhu dènge Koasa Kapai Risi Eele èèna, sabꞌa mi dꞌara ai gꞌana dhèu aae Masir èèna, sèna ka na sue miu. Aa na hia hari Benyamin dènge Simeon lèpa palere dènge miu. Te, ladhe ana jaꞌa se ele, hudꞌi laa jaꞌa pasae jꞌajꞌèra neꞌe taruu.” ");
INSERT INTO nfa_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hèia lasi pakaboko tadha mata sèra dènge doi, ka lasi asa Masir. Rèti kahèi dènge Benyamin. Dꞌai nèi ka lasi paraga dènge Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ropa Yusuf nèdhi Benyamin dènge aꞌa na si, na pua kapala urusan na, aku nèngu na, “Lere mèti dhèu seꞌe sa èmu jaꞌa! Ho èèna na, pare sapi ciꞌu, mi pananasu ngangaꞌa dhu beꞌa. Sèna ka lodꞌo nètu none, raꞌa dènge jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Hèia kapala urusan èèna, tao sama sèmi lii paredha Yusuf èèna. Na lere nèti dhèu sèra asa èmu Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ropa ra kako lasi èmu èèna, aꞌa na sèra madhaꞌu bia. Ètu talora jꞌara, ra papeka, aku rèngu na, “We! Nga tao ka na pua rèti èdhi sa neꞌe? Mage dhoka na neo pasusa èdhi. Lula doi dhu ra tao hari asa dꞌara karo èdhi ca hari na. Ra sangaja rèti èdhi sa neꞌe, sèna ka ra kèpa èdhi jꞌajꞌi ènu nèngu. Ho èèna na, ra parama rara keledꞌei èdhi sèra.” ");
INSERT INTO nfa_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Nèti èèna ka, ropa ra dètu èmu Yusuf na, ra padhai lii dènge kapala urusan èèna, peka na, ");
INSERT INTO nfa_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ama! Baku nasa dènge jiꞌi, te ca hari na dhu jiꞌi mai hèli ngangaꞌa ètu neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Ropa jiꞌi lèpa dꞌai talora jꞌara, jiꞌi ae ngara iisi, ho bhèjꞌi ciki. Hèia jiꞌi bhoke karo ho neo pangaꞌa badha. Ladhe laꞌa na, doi babꞌae jiꞌi èci-èci ka ètu dꞌara karo sèra. Jiꞌi ngeꞌa boe cee ka dhu tao laꞌa! Nèti èèna ka, jiꞌi ngèti hari doi sèra ka seꞌe. Jiꞌi manèngi sèna ka ama ku baku nasa. Aa jiꞌi ngèti doi ka risi kahèi, neo hèli hari ngangaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Hèia kapala urusan èèna dhaa, aku nèngu na, “Mau-mau, baku madhaꞌu! Ele boe Lamatua miu èèna ka dhu hia miu berkat ètu dꞌara karo sèra. Ca hari na, jaꞌa sèmi le doi miu aaꞌi-aaꞌi. Miu pakèlu boe!” Dꞌai èmu ka, na patalale Simeon paꞌèci dènge rèngu. ");
INSERT INTO nfa_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ka aaꞌi-aaꞌi ra lasi asa dꞌara èmu Yusuf. Hèia kapala urusan èèna hia èi ho ra rase haga ra. Aa na ani keledꞌei si hèi. ");
INSERT INTO nfa_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ka na peka dènge si, aku nèngu na, “Ladhe èèna na, lodꞌo nètu miu miꞌa dènge ai gꞌana dhèu aae.” Dꞌara ra tatae Yusuf lèpa, rèngu lalau paie tadha mata ra sèra. ");
INSERT INTO nfa_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ropa Yusuf dꞌai èmu, aaꞌi-aaꞌi ra patitu kètu urutuu ètu madha na. Ka ra jꞌole tadha mata sa hia ne. ");
INSERT INTO nfa_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Hèia Yusuf karèi si, peka na, “Tasamia? Miu beꞌa-beꞌa, do? Tasamia dènge ama miu dhu heka èèna? Na beꞌa-beꞌa, do?” ");
INSERT INTO nfa_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ra dhaa, aku rèngu na, “Ènu ama dhu heka na, dhu ama matana jiꞌi, beꞌa-beꞌa.” Hèia ra patitu kètu urutuu pahaha iisi hari mi Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Hèia Yusuf ladhe palème, ka nèdhi ari na Benyamin. Rèngu dua ra se, ina-ama èci. Hèia, aku nèngu na, “Ooo! Neꞌe ne ka ari miu dhu limuri, dhu ca hari na miu lolo èèna, do?” Ka na lii dènge Benyamin, aku nèngu na, “Ana, ee! Jaꞌa sanao, sèna ka Ama Lamatua hia èu mamuri dènge mera-milu.” ");
INSERT INTO nfa_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ropa ladhe nèdhi Benyamin ne, dꞌara Yusuf karejꞌe bia, lula na sue ari na ae titu kèna. Na taha nare heka dꞌara na. Ka na kako eele si laꞌe sa dꞌara kama na. Ka na tangi ngobꞌi-ngobꞌi ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tangi nare hèia, laꞌe riu katanga madha na. Èle èèna ka, na paꞌèra dꞌara na, ka laꞌe hari paraga dènge si. Hèia na pua dhèu sabꞌa sèra lasi lalau ngangaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ra lalau ngangaꞌa hia Yusuf mei leo. Aa aꞌari na sèra raꞌa mei leo. Dhèu sabꞌa dhèu Masir sèra, raꞌa ètu mei rèngu mesa ra. Lula dhèu Masir sèra madenge ladhe madhèdi raꞌa paꞌèci dènge dhèu Ibrani. ");
INSERT INTO nfa_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kapala urusan èèna ator sèna ka aꞌari Yusuf sèra, madhèdi patangara dènge Yusuf. Na ator hia si madhèdi mulai nèti aꞌa uru, padhutu-dhutu toke ari ra dhu limuri. Ropa ra ladhe rèdhi jꞌara madhèdi sèmi èèna, ra malaa. ");
INSERT INTO nfa_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusuf pua dhèu sabꞌa sèra, bagi ngangaꞌa nèti mei nèngu, hia aꞌari na sèra. Aaꞌi-aaꞌi ra abhu ngangaꞌa dhu ae sama. Dhoka Benyamin di abhu ae risi aꞌa na si lèmi hari. Ka raꞌa-rinu dꞌai bècu. ");
INSERT INTO nfa_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Raꞌa-rinu rara hèia, Yusuf paholo dènge kapala urusan na, aku nèngu na, “Ssst! Èu lamu isi are asa dꞌara karo dhèu sèi, papènu dꞌai hèbꞌa. Èle èèna na, èu tao hari doi ra, asa dꞌara karo ra èci-èci. ");
INSERT INTO nfa_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Aa more moo hualaa pudhi jaꞌa èèna, ho tao asa dꞌara hèbꞌa karo ari ra dhu limuri èèna.” Ka na laꞌe tao madhutu lii paredha Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Asa bèli dꞌara cika lii sa, Yusuf hia si lèpa. Rèti ngangaꞌa dènge keledꞌei rèngu. ");
INSERT INTO nfa_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ra lasi dhae kajꞌèu mèka nèti dꞌara kota, ka Yusuf paredha kapala urusan, peka na, “Èu karohe lamu magèla si. Ladhe paraga dènge si, èu peka sèmi neꞌe: ‘Nga tao ka miu pake dꞌara aapa sèmi èèna mi ai gꞌana dhèu aae? Miu bꞌala babeꞌa na dènge tatao karehe sèmi neꞌe! ");
INSERT INTO nfa_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nga tao ka, miu manaꞌu mèti moo hualaa pudhi na? Miu meꞌa boe, do? Mèdha èèna na, na pake boe ho dhoka ninu di! Te ngaa biasa na pake ho neꞌa tasamia dènge mamuri dhèu. Èèna, mèdha sogo-tagu! Tatao miu ne, mema seli-kolane!’ ” ");
INSERT INTO nfa_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Èle èèna ka, kapala urusan èèna laꞌe magèle si toke abhu. Ropa na raga si, hèia na peka sèmi ngaa dhu Yusuf moa èèna. ");
INSERT INTO nfa_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ka ra bari ne, aku rèngu na, “Ama peka ngaa èèna? Jiꞌi subha. Jiꞌi seꞌe bisa boe tao karehe sèmi èèna! ");
INSERT INTO nfa_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ama, èu meꞌa era, si ma? Doi-doi ca hari sa, dhu ètu dꞌara karo jiꞌi sèra, jiꞌi hia hari le sa ama, to? Tasamia ka jiꞌi bisa manaꞌu hualaa iia do hualaa pudhi ètu dꞌara èmu dhèu kapai èèna! Bisa boe! ");
INSERT INTO nfa_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ama parisa la! Ladhe abhu mèdha èèna ètu dꞌara karo cee, na huku pamadhe ne! Aa hudꞌi laa, jiꞌi dhu leo seꞌe, jꞌajꞌi ènu èu.” ");
INSERT INTO nfa_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Hèia kapala urusan na dhaa, peka na, “Aadꞌo! Sèmi neꞌe. Ladhe abhu moo èèna ètu cee, na dhoka nèngu di jꞌajꞌi ènu jaꞌa. Miu dhu leo lèpa.” ");
INSERT INTO nfa_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ra papuru ka karo sèra. Ka ra bhoke dènge. ");
INSERT INTO nfa_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Hèia kapala urusan èèna parisa karo sèra èci-èci, mulai nèti karo unu aꞌa na, toke dꞌai ari limuri tèka. Ka nèdhi moo èèna, ètu dꞌara karo Benyamin. ");
INSERT INTO nfa_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Rèdhi sèmi èèna hèia, dꞌara aꞌa na sèra jꞌèra maꞌète mae-mae sène. Hèia ra pacaꞌe hari ka karo deo sa asa dedha keledꞌei, ka ra lèpa hari asa dꞌara kota. ");
INSERT INTO nfa_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ropa ra dꞌai èmu Yusuf, na ètu èmu era. Hèia ra patitu kètu urutuu ètu madha na. ");
INSERT INTO nfa_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusuf jèka si, aku nèngu na, “He! Nga tao ka miu tao neꞌe mi jaꞌa! Miu meꞌa boe, jaꞌa ne dhèu kapai ètu neꞌe. Jaꞌa pake naꞌi dhu bisa keꞌa tatao dhèu, dhu dhèu leo reꞌa boe!” ");
INSERT INTO nfa_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Hèia Yahuda dhaa, aku nèngu na, “Irii! Te Ama Lamatua pasabhoka kèna sasala èdhi. Pe jiꞌi peka lii mia hari, ama? Jiꞌi sili iisi sa mia hari? Ladhe ama neo taha ari jiꞌi neꞌe, na beꞌa risi, taha jiꞌi aaꞌi-aaꞌi mi. More jiꞌi aaꞌi-aaꞌi, jꞌajꞌi mi ènu ama ka laa.” ");
INSERT INTO nfa_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Te ngaa Yusuf dhaa, aku nèngu na, “Aadꞌo! Abhu moo èèna ètu cee, na nèngu di dhu jꞌajꞌi ènu jaꞌa. Miu dhu leo, lèpa hari dènge mera-milu sa ama miu!” ");
INSERT INTO nfa_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Hèia Yahuda laꞌe padètu asa madha Yusuf, ka na padhai lii, aku nèngu na, “Ama wakil! Jaꞌa keꞌa koasa ama sama sèmi koasa dhèu aae! Uru nèti èèna, jaꞌa manèngi ama baku nasa dènge jaꞌa. Jaꞌa neo padhai lii ciki dènge ama. ");
INSERT INTO nfa_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Medꞌa na, ama karèi le jiꞌi, peka na, ‘Ama miu, dènge ari miu dhu èci na, era do?’ ");
INSERT INTO nfa_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ka jiꞌi dhaa peka na, ‘Ama jiꞌi heka dꞌai seli le. Aa ari jiꞌi dhu limuri èci. Lodꞌo nara iisi ari jiꞌi neꞌe, ama jiꞌi na heka le. Ari jiꞌi dhu limuri neꞌe dènge aꞌa dꞌèlu na èci, te ngaa na aadꞌo heka. Ina ra madhe le. Ka di nèngu ka mesa na. Nèti èèna ka, ama jiꞌi ne sue ne titu kèna!’ ");
INSERT INTO nfa_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ka ama pua ho jiꞌi ngèti ari jiꞌi na mai, sèna ka ama nèdhi ne. ");
INSERT INTO nfa_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ka jiꞌi dhaa na, ‘Ana èèna, bisa boe tèke eele ama na mesa na. Ladhe na tèke eele, na ama jiꞌi na tatu madhe dènge kèna.’ ");
INSERT INTO nfa_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Hèia ama dhaa na, ‘Ladhe miu mèti boe ari miu na, baku mi padꞌelo hari rèhu mi sa neꞌe.’ ");
INSERT INTO nfa_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Èle èèna ka, jiꞌi lèpa. Dꞌai nèi ka, jiꞌi lolo lii dhu mu moa sèra dènge ama jiꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nèbhu-nèbhu, ngangaꞌa jiꞌi èla. Hèia ama jiꞌi pua hari jiꞌi mai hèli ngangaꞌa sa Masir neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Te ngaa jiꞌi dhaa na, ‘Ama, ee! Jiꞌi laꞌa heka sa nèi. Te ai gꞌana dhèu aae na dhu moa le, aku nèngu na, ladhe jiꞌi ngèti boe ari jiꞌi dhu limuri na, bisa heka jiꞌi padꞌelo rèhu sa nèi. De ladhe ari jiꞌi laꞌe hèi, na heka jiꞌi laꞌa kèna.’ ");
INSERT INTO nfa_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ama jiꞌi peka hari, aku nèngu na, ‘Miu meꞌa kahèi, si ma? Dhèu èmu jaꞌa Rahel èèna, ana na dhoka dua di. ");
INSERT INTO nfa_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ana uuru èèna, aadꞌo heka. Ele boe badha hui naꞌe aaꞌi le. Nèti èèna ka, jaꞌa kèdhi heka rèhu na toke dꞌai sange neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ladhe miu mèti hari ana limuri ne, ho sèmi na abhu jꞌajꞌèra, èèna miu pajꞌèra jaꞌa dhèu heka neꞌe. Ladhe sèmi èèna na, jaꞌa madhe dènge kèna.’ ");
INSERT INTO nfa_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Nèti èèna ka, ama, ladhe jaꞌa lèpa kèti boe dènge ari jiꞌi ne, ama jiꞌi madhe dènge kèna. Te samanga na dhu paꞌèki dènge ana neꞌe di. Dènge ètu dꞌara haheka na neꞌe, ladhe jiꞌi tao ne tabha jꞌèra, tatu na madhe dènge kèna. ");
INSERT INTO nfa_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ngaa hari, jaꞌa moa le mi ama ku, peka na, ‘Jaꞌa ka dhu tago ana neꞌe. Ladhe jaꞌa kèti heka ana neꞌe mai sa madha ama, jaꞌa ka tago sasala na, toke dꞌai jaꞌa madhe.’ ");
INSERT INTO nfa_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Nèti èèna ka, jaꞌa manèngi sèmi neꞌe, ama wakil: hudꞌi laa jaꞌa ka pea mi neꞌe gati nèngu, sèna ka jaꞌa jꞌajꞌi ènu ama wakil. Hia ne lèpa dènge aꞌa na si. ");
INSERT INTO nfa_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ladhe ana neꞌe laꞌe boe, jaꞌa bisa boe lèpa kahèi. Dꞌara jaꞌa laꞌe boe ladhe jꞌajꞌèra ama jiꞌi toke madhe.” ");
INSERT INTO nfa_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ropa tadèngi nare lii Yahuda na, dꞌara Yusuf roe bhilu, toke taha nare boe ètu madha dhèu sabꞌa na sèra. Nèti èèna ka, na hia ra lasi asa liꞌu, sèna ka mesa na di, dènge aꞌari na ètu dꞌara èmu. Dènge jꞌara neꞌe, nèngu bisa patadhe iisi na, mi aꞌari na sèra. ");
INSERT INTO nfa_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Hèia dhèu sabꞌa seꞌe kalua asa liꞌu, ka Yusuf tangi dènge dꞌara pèdꞌa. Lii tangi na mèdhu, ka dhèu-dhèu Masir ètu liꞌu sèra tadèngi kahèi. Mesa boe dhèu ètu liꞌu sèra, te dhèu ètu èmu dhèu aae tadèngi kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ka Yusuf peka mola-mola dènge aꞌari na si, aku nèngu na, “Aꞌari, ee! Jaꞌa neꞌe ka Yusuf èèna! Ama ku mamuri era, do?” Ropa tadèngi rare, aꞌa na sèra madhaꞌu titu kèna. Ra bisa heka bhoke hèbꞌa padhai lii ngaa èci sa. ");
INSERT INTO nfa_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Hèia Yusuf paroa si, peka na, “Mai ku padètu-dètu dènge jaꞌa.” Ka ara lasi padètu sa madha Yusuf. Ka na peka hari, “Jaꞌa ne, Yusuf, dhu uru èèna, miu pahia eele asa Masir neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Miu se tareꞌa pahie eele jaꞌa. Te ngaa mage miu madhaꞌu, aa baku peka cee ka dhu sala. Lula Ama Lamatua ka dhu hia uuru jaꞌa mai sa neꞌe. Ho dènge jꞌara neꞌe, Na pake jaꞌa ho hia mamuri mi dhèu ae. Sèna ka baku madhe manganga. ");
INSERT INTO nfa_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Rai manganga ne heka dua tèu kèna. Lèmi tèu era. Bèli-camèdꞌa dhèu tao heka oka-tedhe, sèla heka, aa abhu heka ngangaꞌa hèru èjꞌi lai. ");
INSERT INTO nfa_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dènge jꞌara dhu èdhi teꞌa boe ne, Ama Lamatua hia jaꞌa mai asa neꞌe uru nèti miu. Sèna ka, miu dènge ana-èpu miu abhu mamuri. ");
INSERT INTO nfa_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","De dhu lèke, nèti boe tatao miu ka jaꞌa dꞌai era neꞌe, te ngaa tatao Ama Lamatua di. Nèngu ka dhu hia jaꞌa jꞌajꞌi ai gꞌana dhèu aae Masir. Ka jaꞌa jꞌajꞌi mi kapala urusan ètu dꞌara èmu dhèu aae. Abhu boe dhèu leo èci sa dhu kapai risi nèti jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","De miu lami ka lai-lai ne, ho peka lii padhai lii jaꞌa ne dènge ama ku, sèmi neꞌe: ‘Yusuf, ana ama ku, mamuri era! Nèngu jꞌajꞌi le dhèu kapai ètu rai Masir. Na manèngi ama ku laꞌe lai-lai asa nèi. ");
INSERT INTO nfa_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ho èèna na, ama pea ètu rai Gosen padètu dènge nèngu. Era na beꞌa aa taleo. Sèna ka ama bisa piara kahibꞌi-kalèbho, kahibꞌi-kaꞌia dènge sapi aaꞌi-aaꞌi ra. Aa na manèngi kahèi ho ama laꞌe dènge ana-èpu, dènge isi èmu, dènge mèdha-panyau, ho pea taruu mi nèi. ");
INSERT INTO nfa_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ladhe ama pea ètu Gosen, nèngu ladhe-leru ama ètu nèi. Te rai manganga lèmi tèu era. Sèna ka na tenge jꞌara ho ama dènge ana-èpu, aa dènge badha-manu bisa mamuri dènge beꞌa.’ ” ");
INSERT INTO nfa_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusuf peka nare hèia, na padhai lii hari, peka na, “Miu unu mi mèdhi le, si? Aa èu kahèi, Benyamin. Jaꞌa neꞌe, tareꞌa-reꞌa Yusuf. ");
INSERT INTO nfa_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","De miu peka dènge ama èdhi, na, jaꞌa neꞌe dènge koasa kapai titu kèna, ètu kabarai Masir neꞌe. Aa lolo dènge ama, ngaa aaꞌi-aaꞌi dhu miu mèdhi le ètu neꞌe. Ho èèna na, karohe mèti ama sa neꞌe mai!” ");
INSERT INTO nfa_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Èle èèna ka, liku nare ari na Benyamin, hèia dua ra tangi. ");
INSERT INTO nfa_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Sèmi èèna kahèi, na liku nare aꞌa na si èci-èci, ka na uu si. Ka heka ra bani padhai lii dènge ne kèna. ");
INSERT INTO nfa_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ropa dhèu aae dènge dhèu-dhèu kapai na sèra, tadèngi rare aꞌari Yusuf mai asa Masir, ra karejꞌe kahèi. ");
INSERT INTO nfa_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ka dhèu aae peka dènge Yusuf, aku nèngu na, “Ari! Peka dènge aꞌari èu sèra, ho hua ka ngangaꞌa asa dedha keledꞌei rèngu, sèna ka rèti sa Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Aa peka dènge si, rèti ama mu dènge ana-èpu aaꞌi-aaꞌi, mai pea sa neꞌe. Dꞌai neꞌe, pe jaꞌa hia rèngu rai, era dhu hèu mèngi risi, sèna ka rèngu bisa mamuri nèti isi rai èèna. ");
INSERT INTO nfa_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Aa hia rèti mema dènge kareta pèri-pèri nèti neꞌe, ho sèna ka hua ana iiki-ana iiki dènge ama mu. ");
INSERT INTO nfa_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Baku ra pangee mèdha-panyau dhu rèngu bisa boe nedhe rèti, te, ngaa-ngaa dhu beꞌa ètu rai Masir ne, èèna na jꞌajꞌi unu rèngu.” ");
INSERT INTO nfa_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Tadèngi sèmi èèna, ka Yusuf hia si kareta pèri-pèri bua, dènge parèko raꞌa jꞌara, sama sèmi lii paredha dhèu aae. Aa aꞌari na paꞌèra ka, ho lèpa madhutu lii paredha dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ka Yusuf hia si mèdha-papake dhu hiu, ca dhèu ca pasa. Te ngaa Benyamin, na hia doi iia tèlu ngasu, dènge mèdha-papake dhu hiu, lèmi pasa. ");
INSERT INTO nfa_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yusuf paꞌadhu mèdha-panyau dhu beꞌa risi nèti Masir hia ama na. Rèngu hua mi dedha keledꞌei canguru ngiꞌu. Sèmi èèna kahèi, na hia are, roti, dènge ngangaꞌa ae-ae, dhu jꞌajꞌi parèko jꞌara, lodꞌo dhu rèngu mulai pakèdꞌi nèti Kanaꞌan asa Masir. Ngangaꞌa se, ra hua ètu dedha keledꞌei dhu leo hari canguru ngiꞌu. ");
INSERT INTO nfa_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Èle èèna ka, na hia si lèpa, aa na moa si, aku nèngu na, “Miu baku patao-palaha ètu talora jꞌara, ee!” ");
INSERT INTO nfa_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Hèia ra pakèdꞌi ka lasi sa ama ra ètu Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Dꞌai nèi ka, ra lolo dènge ama ra, peka na, “Ama! Ana mu Yusuf na, dhu mamuri era di. Na jꞌajꞌi le dhèu kapai, ka na paredha ètu rai Masir!” Yakob tadèngi hiu-hiu na, loo-loo sène, te na lèka boe. ");
INSERT INTO nfa_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Te ngaa ropa na tadèngi nare lii lolo rèngu sèra, aa na ladhe nèdhi kareta dhu Yusuf paꞌadhu mai ho hua ne asa Masir, heka na lèka kèna. ");
INSERT INTO nfa_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Hèia na padhai lii, aku nèngu na, “Hea! De ana jaꞌa dhu mamuri era di! Jaꞌa heka karejꞌe kèna. Jaꞌa hudꞌi laku kèdhi ku ne, heka jaꞌa madhe dènge karejꞌe kèna.” ");
INSERT INTO nfa_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Èle èèna ka, Yakob si paꞌèra ka mèdha ra, ka ra pakèdꞌi nèti Kanaꞌan. Ropa ra dꞌai rae Barseba, ka na roro badha tao korban hia Lamatua, dhu uru na ama na Isak mangajꞌi. ");
INSERT INTO nfa_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mèda ca lodꞌo ka na nii. Ètu dꞌara nii neꞌe, na tadèngi na Ama Lamatua paroa ne, peka na, “Yakob! Yakob! Èu kèdꞌi ho nanene ku la!” Hèia na dhaa, peka na, “Nga tao, Ama?” ");
INSERT INTO nfa_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ka Lamatua peka na, “Jaꞌa ne, Ama Lamatua dhu ama mu mangajꞌi nèti uru ka. Mage èu madhaꞌu kahèi lamu Masir. Te èèna na, Jaꞌa tao ana-èpu èu jꞌajꞌi suku kapai ètu rai nèi. ");
INSERT INTO nfa_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Jaꞌa laku hèi Masir sama-sama dènge èu. Ho ladhe èèna na, Jaꞌa kahèi dhu kèti hari ana-èpu èu lèpa asa rai Kanaꞌan neꞌe. Ropa èu madhe, na, ana mu Yusuf madhèdi ètu baboa èu.” ");
INSERT INTO nfa_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Èle èèna ka, Yakob dènge ana-ana na sèra, lasi taruu tèke eele rae Barseba. Ra pacaꞌe ne dènge bhèni-ana iiki na asa kareta sèra dhu dhèu aae Masir paꞌadhu hia si. ");
INSERT INTO nfa_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Rèti aaꞌi mèu-mèu mèdha-panyau dènge badha-manu dhu jꞌajꞌi kakaja rèngu ètu rai Kanaꞌan. Hèia Yakob dènge ana-èpu na, bhèni-mone aaꞌi-aaꞌi ra pakèdꞌi ka lasi rai Masir. ");
INSERT INTO nfa_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ana-èpu Yakob dhu madhutu lasi asa Masir, nuka seꞌe: Ruben, ana uuru na. ");
INSERT INTO nfa_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ana-ana na ka: Henok, Palu, Hesron dènge Karmi. ");
INSERT INTO nfa_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon, dènge ana-ana na: Yemuel, Yamin, Ohat, Yakin, dènge Sohar. Dènge Saul kahèi, ana na nèti dhèu èmu na bhèni Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi, dènge ana-ana na: Gerson, Kehat, dènge Merari. ");
INSERT INTO nfa_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda, dènge ana-ana na: Sela, Peres, dènge Sera. Ana Yahuda dhu leo, Er dènge Onan, madhe le ètu Kanaꞌan. Na nèti dènge ana-ana Peres, Hesron dènge Hamul. ");
INSERT INTO nfa_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar, dènge ana-ana na: Tola, Pua, Ayub, dènge Simron. ");
INSERT INTO nfa_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon, dènge ana-ana na: Seret, Elon, dènge Jahleel. ");
INSERT INTO nfa_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Rèngu seꞌe, ana-ana nèti Yakob dènge dhèu èmu na Lea, lodꞌo rèngu pea ètu Mesopotamia. Ana bhèni rèngu èci, ngara na Dina. Ana-èpu nèti Yakob dènge Lea, aaꞌi-aaꞌi ra 33 (tèlu nguru tèlu) dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Aa Yakob abhu ana-ana dènge dhèu èmu dhu leo hari. Nuka: Gad, dènge ana-ana na: Sifion, Hagi, Suni, Esbon, Eri, Arodi dènge Areli. ");
INSERT INTO nfa_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser, dènge ana-ana na: Yimna, Yiswa, Yiswi, Beria, dènge ana hèni ra èci, ngara na Sera. Beria, dènge ana le kahèi: Heber dènge Malkiel. ");
INSERT INTO nfa_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Rèngu aaꞌi-aaꞌi ra, canguru èna dhèu. Ana-èpu nèti Yakob dènge dhèu èmu na Silpa. Silpa neꞌe ka dhu Laban hia jꞌajꞌi ènu nèti Lea, dhèu èmu uru Yakob na. ");
INSERT INTO nfa_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Aa ana-ana nèti Yakob dènge dhèu èmu na bhèni leo hari, ngara na Rahel, nuka: Yusuf dènge Benyamin. ");
INSERT INTO nfa_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Lodꞌo èèna, Yusuf leo le dènge Asnat ètu Masir. Ama Asnat èèna, ama agama ètu kota On. Ngara na, Potifera. Ana-ana Yusuf dènge Asnat: Efraim dènge Manase. ");
INSERT INTO nfa_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin madhutu hèi lasi Masir dènge ana-ana na: Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim dènge Aret. ");
INSERT INTO nfa_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ana-èpu Yakob dènge dhèu èmu na Rahel, canguru èpa dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dhèu èmu Yakob èci hari, ngara na Bilha. Ana-ana ra, Dan, dènge Naftali. Ana Dan, ngara na Husim. ");
INSERT INTO nfa_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ana nèti Naftali: Yasel, Guni, Yeser dènge Silem. ");
INSERT INTO nfa_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob dènge dhèu èmu na Bilha, ana-èpu rèngu dhèu pidhu. Bilha ne, ènu nèti Rahel, dhu na abhu nèti ama na Laban. ");
INSERT INTO nfa_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","De ana-èpu Yakob dhu lasi Masir, aaꞌi-aaꞌi ra dhèu 66 (èna nguru èna) dhèu. Seꞌe se, ige mèka dènge dhèu èmu nèti ana-ana nèngu sèra. ");
INSERT INTO nfa_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ladhe tabha dènge ana-ana Yusuf dhu ina na nara iisi ètu Masir dhèu dua, na Yakob dènge ana-èpu aaꞌi-aaꞌi ra si, 70 (pidhu nguru) dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ropa ra dètu dènge Masir, Yakob pua Yahuda laꞌe uuru, paroa Yusuf ho mai paraga dènge ne ètu Gosen. Ropa ra dꞌai Gosen, ");
INSERT INTO nfa_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf caꞌe nare kareta na, mai paraga dènge ama na. Ropa ra paraga, liku nare ama na, ka na tangi nèbhu bia. ");
INSERT INTO nfa_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Hèia Yakob padhai lii dènge Yusuf, aku nèngu na, “Ana, ee! Jaꞌa unu ku kèdhi le èu. Aa jaꞌa keꞌa le èu mamuri era. De ladhe jaꞌa madhe èèna ka oo, ngaa-ngaa tao heka.” ");
INSERT INTO nfa_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ka Yusuf peka dènge aꞌari na aaꞌi-aaꞌi, peka na, “Jaꞌa laku peka ku dènge dhèu aae, sèna ka neꞌa na aꞌari jaꞌa mai le nèti Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Aa, pe jaꞌa peka kahèi dènge ne, miu biasa ani kahibꞌi-kalèbho dènge sapi. Nèti èèna ka, miu mèti dènge badha-manu dènge mèdha-panyau miu nèti Kanaꞌan. ");
INSERT INTO nfa_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","De ladhe dhèu aae paroa miu, ho na karèi miu biasa sabꞌa ngaa, ");
INSERT INTO nfa_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","na, miu dhaa ne peka na, miu se aaꞌi-aaꞌi mi nèti ana iiki ka mai piara badha, sama sèmi bèi-baki jiꞌi. Sèna ka na pua miu pea ètu rai Gosen.” Yusuf peka sèmi èèna, lula dhèu Masir madenge pea paꞌèci dènge ana madhutu badha. ");
INSERT INTO nfa_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Èle èèna ka, Yusuf dènge aꞌari na dhèu lèmi, lasi paraga dènge dhèu aae. Dꞌai madha dhèu aae, ka Yusuf patadha si dènge dhèu aae, ka na peka na, “Ama dhèu aae! Ama ku dènge aꞌari ku mai le nèti Kanaꞌan. Rèngu mai dènge kahibꞌi-kalèbho, sapi, dènge mèdha-panyau aaꞌi-aaꞌi ra. Nuka ra ètu rai Gosen nèi.” ");
INSERT INTO nfa_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Dhèu aae karèi si, aku nèngu na, “Sasabꞌa miu ngaa?” Ra dhaa, peka na, “Jiꞌi se, ana madhutu badha, sama sèmi bèi-baki jiꞌi sèra. ");
INSERT INTO nfa_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Limuri neꞌe, ètu rai jiꞌi Kanaꞌan, hèru hadhu madhera, ka ngangaꞌa dènge jꞌuꞌu tèdhi heka. Nèti èèna ka, jiꞌi mai taha asa kabarai neꞌe. Ngèti dènge badha-manu jiꞌi. De jiꞌi manèngi ama dhèu aae, ho hia jiꞌi pea ètu rai Gosen, sèna ka jiꞌi piara badha jiꞌi ètu nèi.” ");
INSERT INTO nfa_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Hèia dhèu aae padhai lii dènge Yusuf sèmi neꞌe: “Ama mu dènge aꞌari mu ètu neꞌe le. ");
INSERT INTO nfa_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","De hudꞌi laa rèngu tao kabarai neꞌe, sama sèmi kabarai rèngu. Madhutu kakeꞌa jaꞌa, Gosen èèna era dhu beꞌa risi nèti era leo ètu rai Masir neꞌe. De beꞌa risi rèngu pea ètu èèna ka la. Aa ladhe rèngu cee dhu ladhe-leru badha dènge hua iia, na jaꞌa hia badha jaꞌa ho na piara si ètu èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Èle èèna hèia, Yusuf patadhe ama na dènge dhèu aae. Ka Yakob manèngi mi Ama Lamatua, sèna ka hia mèngi-nale mi dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Dhèu aae karèi Yakob, aku nèngu na, “Ama umur pèri tèu kèna?” ");
INSERT INTO nfa_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob dhaa, “Umur jaꞌa cangasu tèlu nguru tèu kèna, te ngaa jaꞌa pea boe mi ca era sa. Bèi-baki jaꞌa sèmi èèna kahèi. Ladhe pakasame dènge rèngu, na umur jaꞌa kura nèti rèngu. Te ngaa mamuri jaꞌa pènu dènge jꞌajꞌèra.” ");
INSERT INTO nfa_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hèia Yakob manèngi parmisi neo lèpa. Te ngaa kalua mèka nèti dꞌara èmu, na manèngi hari ca tèka mi Lamatua ho sèna ka hia berkat mi dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Èle èèna ka, Yusuf padꞌelo era pea hia aꞌari na si ètu Gosen, madhutu lii pua dhèu aae deo na. Era èèna beꞌa titu kèna. (Ra pangare era èèna ‘Rameses’.) Ka ama na dènge aꞌari na sèra pea taruu ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Hèia Yusuf sadia ngangaꞌa hia ama na, aꞌari na, dènge ana dhèu èmu ra, aaꞌi-aaꞌi ra, nèti dhèu kapai toke dꞌai ana susu. ");
INSERT INTO nfa_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Taa èèna, rai manganga titu kèna, tèdhi boe ngangaꞌa ca lamusi sa ètu mia-mia. Nèti Masir toke Kanaꞌan, dhèu-dhèu manganga roe ca palèpa, taga nèti raꞌa-rinu heka. Dhèu bisa heka sabꞌa ngaa-ngaa, lula manganga titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Dhèu-dhèu nèti dꞌara rae-rae ètu Masir, sèmi èèna kahèi dhèu-dhèu nèti dꞌara rae-rae ètu Kanaꞌan, mai hèli ngangaꞌa ètu Yusuf. Doi-doi dhu na sèmi sèra, na pakaboko aaꞌi ka, laꞌe tèke asa èmu dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tèu èèna, èla aaꞌi doi dhèu Masir dènge dhèu Kanaꞌan ka ra bisa heka hèli ngangaꞌa. Hèia ra mai roma iisi mi Yusuf, aku rèngu na, “Ama wakil! Hia ku jiꞌi ngangaꞌa ciki la, sèna ka jiꞌi baku madhe manganga. Te doi jiꞌi, èla aaꞌi mèu-mèu le.” ");
INSERT INTO nfa_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Hèia Yusuf dhaa, peka na, “Ladhe tareꞌa doi miu aadꞌo heka, na sèmi neꞌe ka la! Mèti badha miu, ho pasilu dènge ngangaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ka dhèu seꞌe mai pasilu badha ra dènge ngangaꞌa. Badha-badha sèmi jara, kahibꞌi-kaꞌia, kahibꞌi-kalèbho, sapi, dènge keledꞌei. Lula tèu èèna, Yusuf dhu moa tèke le. ");
INSERT INTO nfa_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tèu mai na, rèngu mai hari sa madha Yusuf, ka ra peka, “Ama wakil, ee! Jiꞌi peka tareꞌa-reꞌa kèna. Doi jiꞌi dènge badha jiꞌi ama pasilu aaꞌi-aaꞌi le. Limuri neꞌe, jiꞌi dènge heka ngaa-ngaa. Dhu ètu jiꞌi dhodhoka ngiꞌu dènge rai jiꞌi di. ");
INSERT INTO nfa_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Baku tèke eele jiꞌi madhe manganga. Te ladhe jiꞌi madhe na, cee ka dhu sabꞌa oka-tedhe seꞌe? De hua iia, ama wakil more jiꞌi, ho jꞌajꞌi ènu mu. Aa more aaꞌi rai jiꞌi kahèi. Pe, èèna na, ama hia hini ho jiꞌi sèla hia ama. Gaji dènge kabꞌua rai jiꞌi, ama pasilu dènge ngangaꞌa. Sadꞌi jiꞌi baku madhe manganga.” ");
INSERT INTO nfa_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Lula rai manganga ae, ka dhèu Masir pahie aaꞌi rai rèngu. Nèti èèna ka, Yusuf hèli nara aaꞌi rai ètu Masir jꞌajꞌi mi pusaka dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Dènge jꞌara sèmi èèna ka, dhèu Masir aaꞌi-aaꞌi ra jꞌajꞌi ènu nèti dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Dhoka rai unu ama agama sèra di, Yusuf hèli nare boe, te dhèu aae hia taruu dhèu se ngangaꞌa na. Nèti èèna ka, dhèu se pahie boe rai rèngu. ");
INSERT INTO nfa_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Lodꞌo èèna, Yusuf peka dènge ana kabarai sèra, aku nèngu na, “Naa! Miu jꞌajꞌi le ènu nèti dhèu aae. Jaꞌa hèli kore aaꞌi le, rai miu hia dhèu aae. De mere hini seꞌe ho lami sèla ka mi dedha rai sèra. ");
INSERT INTO nfa_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ladhe miu puu-gꞌètu na, bagi mi lèmi. Ho ca pala hia dhèu aae. Aa èpa pala sèra, miu tao hini dènge mi pake miꞌa-minu dènge aꞌari miu.” ");
INSERT INTO nfa_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Hèia ra dhaa, aku rèngu na, “Ama pamamuri jiꞌi le, de jiꞌi manèngi tarima kasi. Jiꞌi neo jꞌajꞌi ènu nèti dhèu aae.” ");
INSERT INTO nfa_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nèti èèna ka, Yusuf tao madha jꞌara neꞌe, jꞌajꞌi adꞌa kabarai ètu Masir. Ladhe ra puru rare are na, ra bagi mi lèmi pala. Ho ca pala rèngu hia mi dhèu aae. Aa èpa pala rèngu abhu. Te ngaa rai ama agama sèra, dhèu aae hèli boe. Adꞌa èèna, ra pake taruu. ");
INSERT INTO nfa_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Karèi nèti lodꞌo èèna, dhèu Israꞌel pea taruu ka ètu Masir, ètu rai Gosen. Ra jꞌajꞌi dhèu kaja, aa ana-èpu rèngu asa tabha ae. ");
INSERT INTO nfa_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ètu Masir, Yakob mamuri hari 17 (canguru pidhu) tèu era. Jꞌajꞌi umur Yakob aaꞌi-aaꞌi ra, 147 (cangasu èpa nguru pidhu) tèu. ");
INSERT INTO nfa_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Lodꞌo dètu na madhe èèna, na paroa Yusuf, ka na padhai lii dènge ne, aku nèngu na, “Ana Yusuf! Jaꞌa rasa na, mamuri jaꞌa madhera heka. Nèbhu heka, Lamatua paroa jaꞌa lèpa kèna. Èèna ka jaꞌa manèngi sèna ka ladhe èu sue jaꞌa, èu subha sèna ka baku padhane jaꞌa ètu rai Masir neꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Èu hudꞌi mèti ngiꞌu aae jaꞌa, ho padhane asa era roꞌa bèi-baki èdhi. Ho èu padhane jaꞌa ètu èèna. Neꞌe ne, dadꞌèi dꞌara ama.” Ka Yusuf dhaa ne, aku nèngu na, “Beꞌa ama! Ladhe dadꞌèi ama ku kèna, na jaꞌa madhutu.” ");
INSERT INTO nfa_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ka Yakob padhai lii hari, peka na, “De ladhe sèmi èèna, èu hudꞌi subha uuru ku, ho keꞌa na èu madhutu dadꞌèi ama.” Hèia Yusuf subha madhutu dadꞌèi Yakob. Ka Yakob patitu kètu urutuu ètu dedha era jꞌunu na, ka na manèngi makasi mi Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nèbhu boe ka, dhèu lasi peka dènge Yusuf na, ama na pèdꞌa aae. Hèia laꞌe nèti dènge ana na, Efraim dènge Manase, sèna ka lasi ladhe baki ra Yakob. ");
INSERT INTO nfa_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ropa Yakob tadèngi Yusuf si mai le, ka na pakaseti madhèdi. ");
INSERT INTO nfa_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Hèia na padhai lii dènge Yusuf, aku nèngu na, “Ana Yusuf, ee! Ama Lamatua dhu dènge Koasa Kapai Risi na, uru èèna, Na padꞌelo le iisi Na dènge jaꞌa ètu rae Lus, ètu rai Kanaꞌan. Ètu nèi, Na moa tèke mi jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Na padhai lii, peka na, ‘Bèli-camèdꞌa Jaꞌa hia ana-èpu èu jꞌajꞌi ae, ho rèngu jꞌajꞌi suku dhu kapai. Rai neꞌe ne, jaꞌa hia jꞌajꞌi unu rèngu, ho jꞌajꞌi pusaka ra toke dꞌai rai-haha èle.’ ");
INSERT INTO nfa_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Aa ana èu Efraim dènge Manase èèna, hak rèngu sèmi neꞌe ka: lodꞌo dhu jaꞌa dꞌai Masir na, mere iisi le rèngu dua ra. Masi ka sèmi èèna, jaꞌa tao rèngu sèmi ana dꞌèlu jaꞌa, sama sèmi Ruben dènge Simeon. ");
INSERT INTO nfa_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Aa ladhe bèli-camèdꞌa èu abhu hari ana, na èèna di unu èu kèna. Jaꞌa tao boe rèngu sèmi ana dꞌèlu jaꞌa. Pe pusaka ra, rèngu abhu nèti aꞌa ra, Efraim dènge Manase. ");
INSERT INTO nfa_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Jaꞌa tao sèmi èèna, sèna ka èdhi sanèdꞌe ina mu Rahel. Lodꞌo jiꞌi mai nèti Mesopotamia asa Kanaꞌan, dꞌai talora jꞌara, ina mu madhe ropa nara iisi aaꞌi. Èèna na, jiꞌi dètu rae Efrata ètu rai Kanaꞌan. Lodꞌo èèna, jaꞌa susa dꞌai seli. Ka jaꞌa padhane ne ètu sebhe jꞌara laꞌe asa rae Efrata.” (Limuri ne, rae èèna ra gati ngara na Betlehem.) ");
INSERT INTO nfa_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ropa Yakob padhai lii nare sèmi èèna hèia, na boti kètu na, ladhe nèdhi ana-ana Yusuf ètu èèna. Hèia na karèi Yusuf, aku nèngu na, “Seꞌe se, ana cee?” ");
INSERT INTO nfa_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ka Yusuf dhaa, “Seꞌe, ana dhu Ama Lamatua hia jaꞌa ètu Masir.” Yakob peka hari, “Ladhe sèmi èèna, na hia ra mai padètu dènge jaꞌa, ho jaꞌa manèngi Ama Lamatua hia si mèngi-nale.” ");
INSERT INTO nfa_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakob heka le, aa musi madha na ahu le. Na ladhe nèdhi beꞌa heka. Hèia Yusuf nèti ana na sèra padètu asa madha Yakob, ka na liku nare si, aa na uu si dua ra. ");
INSERT INTO nfa_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ka na peka dènge Yusuf, aku nèngu na, “Nèbhu nare sange neꞌe, jaꞌa pangee na, jaꞌa bisa heka kèdhi rèhu èu. Te ngaa Ama Lamatua, tao risi eele nèti ngaa dhu jaꞌa ngee, toke jaꞌa bisa kèdhi ana-ana èu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Hèia Yusuf hari eele ana na dhèu dua sèra nèti madha Yakob, ka na patitu kètu urutuu na, aa na pacudꞌu rèhu na dꞌai rai, ètu madha ama na. ");
INSERT INTO nfa_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Èle èèna ka, Yusuf kèdꞌi. Na nare ana na dhèu dua sèra, ka na hia ra titu padètu-dètu dènge ama na. Na patitu ana uuru na Manase, re bèka gꞌana Yakob. Aa ana ka dua, Efraim, re bèka kariu Yakob. ");
INSERT INTO nfa_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Te ngaa ropa Yakob soro ai na neo manèngi mèngi-nale hia ana dua sèra, na soro ai gꞌana na mi kètu Efraim, aa ai kariu mi kètu Manase. ");
INSERT INTO nfa_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ka na manèngi Ama Lamatua hia berkat mi Yusuf, peka na, “Baki mu Isak, dènge ama na Abraham, dua ra madhutu taruu dadꞌèi Ama Lamatua. Ama Lamatua ladhe-leru jaꞌa kahèi, nèti ana ngèru toke dꞌai deo neꞌe ne. ");
INSERT INTO nfa_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Na pakajꞌèu jaꞌa nèti rupa-rupa sasusa. De jaꞌa manèngi sèna ka Na hia mèngi-nale mi ana èu seꞌe, dènge ana-èpu ra. Aa ladhe ra manèngi-mangajꞌi mi Ama Lamatua, ra bhèlu boe ale kolongara baki Abraham, kolongara Isak, aa kolongara jaꞌa, sèna ka ana-èpu rèngu asa bèba-kacanga, ho jꞌajꞌi kapai ètu rai-haha neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Te ngaa ropa Yusuf ladhe nèdhi ama na tao ai gꞌana na mi kètu Efraim, hèia kèpe nare ai ama na, ho tao sa kètu aꞌa na Manase. ");
INSERT INTO nfa_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ka na peka dènge ama na, “Ama, ee! Baku tao sèmi èèna. Nèngu ne, ari Efraim. Nèngu ana limuri. De ai gꞌana ama hudꞌi tao sa kètu aꞌa na Manase. Lula èèna hak ana uuru.” ");
INSERT INTO nfa_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Te ngaa ama na Yakob dꞌèi boe. Ka na peka na, “Ana, ee! Jaꞌa keꞌa. Ladhe èèna na, Manase jꞌajꞌi èra, aa ana-èpu na tabha ae, ho jꞌajꞌi suku kapai. Te ngaa ari na Efraim èèna, bèli-camèdꞌa kapai risi hari nèti nèngu. Sèmi èèna kahèi ana-èpu na ae risi eele hari, ho ladhe èèna na, rèngu jꞌajꞌi suku-suku dhu kapai aae.” ");
INSERT INTO nfa_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ka na peka dènge ana se dua ra, “Ladhe dhèu Israꞌel manèngi Ama Lamatua ho hia mamèngi-nale mi dhèu, rèngu ale ngara miu dua mi hèi. Ladhe èèna na, ra peka sèmi neꞌe: ‘Jiꞌi sanao sèna ka Ama Lamatua hia mamèngi-nale mi èu, sama sèmi Na hia mi Efraim dènge Manase.’ ” Dènge jꞌara neꞌe, Yakob ale uuru ngara Efraim nèti ngara aꞌa na Manase. ");
INSERT INTO nfa_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Èle èèna, hèia Yakob padhai lii dènge Yusuf, peka na, “Ana, ee! Jaꞌa nèbhu heka madhe. Te ngaa Ama Lamatua dènge miu, ho èèna na nèti hari miu asa era pea-paluꞌu bèi-baki miu. ");
INSERT INTO nfa_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Te ngaa neꞌe ne, jaꞌa hia èu risi eele nèti aꞌari èu. Aa jaꞌa hia tabha èu, ledhe ètu rai Kanaꞌan èèna, dhu uru na jaꞌa kore nèti dhèu Amori, lodꞌo jaꞌa segi rèngu ètu dꞌara pamusu.” ");
INSERT INTO nfa_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hèia Yakob pua ana na aaꞌi-aaꞌi ra pakaboko. Ropa ra kaboko aaꞌi, na peka dènge si, aku nèngu na, “Ana jaꞌa aaꞌi-aaꞌi! Mai padètu dènge jaꞌa. Te jaꞌa neo peka dènge miu jꞌara mamuri mi èci-èci lodꞌo limuri.” ");
INSERT INTO nfa_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ka na peka mema dènge ana-ana na si, aku nèngu na, “Sèmi neꞌe, ana-ana Yakob! Mai titu lingu mere jaꞌa. Mi nanene, ama miu Israꞌel ne, neo padhai lii. ");
INSERT INTO nfa_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! Èu ne, ana jaꞌa dhu uru tèka! Èu neꞌe tatea jaꞌa, dènge ai gꞌana jaꞌa. Dhèu pakabꞌua risi èu. ");
INSERT INTO nfa_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Te ngaa dꞌara èu èra boe, sama sèmi rii dhasi dhu laꞌe-mai laꞌe-mai. Cagꞌagꞌa laa, èu lamu jꞌunu dènge dhèu èmu jaꞌa, ka pakajꞌalu era jꞌunu ama èu. Tatao èu èèna ka, pamanahu eele kolongara ca dhèu aꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon dènge Lewi! Miu dua mi ca rupa. Miu dua mi, malai titu kèna dedꞌe samala, ho pajꞌèra dhèu. ");
INSERT INTO nfa_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ladhe miu pare pamaꞌète kalua haga sapi, ho ra kapodꞌe reo-reo ètu era, na lèke dadꞌèi miu kèna. Aa bhabhelu miu hari, ladhe miu kadhi ngutu, na mi pamadhe dhèu. Nèti èèna ka, jaꞌa pahae boe lii padhai lii miu. Aa jaꞌa dꞌèi boe tao madha-dhilu mi lii langu miu. ");
INSERT INTO nfa_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nèti èèna ka, jaꞌa dhoo bhelu-katubꞌa miu ne, te seli-kolane nga! Dènge nanasa miu dhu dènge boe sasue ciki sa hèi. Ladhe èèna na, miu pasae unu mi, bhelu-katubꞌa miu sèra. Ho èèna na, Lamatua cebꞌe ana-èpu miu, asa gꞌana asa kariu. Ka ra pacebꞌa asa mia-mia, ètu dedha rai Israꞌel. ");
INSERT INTO nfa_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! Ngara èu ne, sasoa na, ‘koa-kio’. Aꞌari èu èèna na ra koa èu, aa ra pacudꞌu kètu ho pakabꞌua èu. Èu ne, jꞌèli musu èu, toke ra bisa heka doa kètu. ");
INSERT INTO nfa_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Èu ne, sama sèmi singa ngèru dhu èra, ho tenge ngangaꞌa unu mu. Aa èu ne, sama sèmi singa mone, dhu tèku iisi neo bhèjꞌi; èci sa bani boe pagagai dènge èu. Èu kahèi sèmi singa rena, dhu madhenge ana; èci sa bani boe gagu. Èci èèna ka dènge èu. Dhèu èci sa bani boe padadisi, aa bani boe tao macam-macam mi dedha èu. ");
INSERT INTO nfa_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Èèna na èu mèdꞌu paredha. Ana-èpu èu oo rèdꞌu paredha padhutu-dhutu, toke abhu èci dhu hak nèngu risi eele nèti cahagꞌe, ho nèdꞌu paredha na. Ka dhèu aaꞌi-aaꞌi ètu rai-haha neꞌe, pahaha iisi ho nanene lii paredha nèngu hèi. ");
INSERT INTO nfa_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Èèna na, èu ne mamuri dènge karejꞌe-karae. Èu neo ngaa, na abhu. Èu neo tao ngaa, na jꞌajꞌi! Aa ladhe èèna na, badha-manu, dènge isi rai nèti oka-tedhe èu, asa ae dꞌai cebꞌe lebhe eele hèi. ");
INSERT INTO nfa_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ngangaꞌa-nginu èu, dhu beꞌa hua, aa dhu èle boe. ");
INSERT INTO nfa_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebolon! Rai pusaka dhu èu unu, kapai seli, nèti nebhe dhasi toke dꞌai too dènge kota Sidon. Kapa-kapa mai nèti mia-mia ho panahu dènge beꞌa ètu dꞌara hèbꞌa-namo dhasi èu. ");
INSERT INTO nfa_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! Èu ne, sama sèmi keledꞌei dhu èra, te ngaa èu kètu hadhu papake na aadꞌo. Ladhe èu jꞌunu ètu talora jꞌara, dhèu èci sa bisa boe pakèdꞌi èu ho kako taruu. Te ngaa ladhe èu mèdhi rae ètu ca bèka nèi beꞌa, èci sa dhae pua mèka èèna ka, mu pasae mèti le mèdha-panyau èu ho lamu. Tatu èu sama sèmi èèna ka! ");
INSERT INTO nfa_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! Ngara èu ne, sasoa na, ‘dhèu pamaꞌète lii’. Aa èu ne, dènge ana-èpu èu, ladhe bèli-camèdꞌa pamaꞌète lii nèti dhèu èu Israꞌel sèra, dènge boe bia ca bèka. ");
INSERT INTO nfa_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Aa èu ne, sama èci èèna ka dènge mege kaisao dhu jꞌunu ètu sebhe jꞌara. Dhèu caꞌe jara ho èèna na, èu kadhi haga jara èèna nèti kabodho, toke dhèu manahu sa rai. ");
INSERT INTO nfa_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O LAMATUA! Jaꞌa keꞌa na Èu hia mamuri mi jiꞌi aaꞌi-aaꞌi mi. ");
INSERT INTO nfa_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! Ngara èu, lii na oe èci èèna ka dènge, ‘age’. Ladhe èèna na, dhèu parapo mai age èu, te ngaa èu kabèli hari age si, ka mu segi si. ");
INSERT INTO nfa_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Ladhe èèna isi rai nèti oka-tedhe èu beꞌa risi, dꞌai èu tao koki dhu beꞌa bia, ka dhèu aae-dhèu kapai mai hèli ètu èu. ");
INSERT INTO nfa_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! Èu ne sama sèmi rusa hui, dhu dhèu èci sa ator rare boe èu. Ana-ana matana èu, bhèni iia dènge mone iia. ");
INSERT INTO nfa_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf! Èu ne, sama sèmi ajꞌu loro dhu dètu dènge madha èi. Dadana na loro asa tembok dhu dedha aae. ");
INSERT INTO nfa_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Abhu kahèi dhèu tèka dꞌara dènge èu, sama èci èèna ka, dènge musu dhu neo kataki èu. ");
INSERT INTO nfa_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Te ngaa Ama Lamatua dhu jaꞌa mangajꞌi na, bera-bera dènge èu. Ho Na paꞌèra ai èu, ka èu kataki si hari, masi ka nèti kajꞌèu èèna ka. Èu segi si, lula Ama Lamatua dhu tolong èu. Mema koasa Na risi aaꞌi ngaa-ngaa! Nèti èèna ka, Nèngu jꞌajꞌi era sarai jaꞌa, lula Nèngu na ka dhu madhenge jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Aa Nèngu madhenge èu kahèi. Dènge Na pala-bagi hia èu mèngi-nale nèti dedha-liru, nèti rai-haha, dènge berkat ho matana ana ae-ae dhu ngiꞌu èra. ");
INSERT INTO nfa_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ledhe-ledhe ra ele boe. Aa mamèngi-nale dhu jaꞌa peka mi èu ne, dedha risi nèti ledhe aaꞌi-aaꞌi ra. Sèna ka hudꞌi laa berkat se aaꞌi-aaꞌi sabhori asa èu, lula èu ne risi nèti aꞌari èu se aaꞌi-aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! Babani èu sama sèmi busa hui dhu manganga. Madꞌae aae era, na kèdꞌi le èèna, ho bata-magèla badha hui, ho jꞌajꞌi mi ngangaꞌa na. Aa, ladhe dꞌai ka mèda, laꞌe papala dhu sisa hia mi ana-ana nèngu. Babeꞌa ana-èpu èu sèmi èèna kahèi.” ");
INSERT INTO nfa_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Sange neꞌe ka, Yakob peka dènge ana-ana na, tasa mera mia mamuri rèngu pala lodꞌo limuri, èci-èci ka dènge ana-èpu rèngu. Rèngu aaꞌi-aaꞌi seꞌe ka, jꞌajꞌi mi bèi-baki nèti canguru dua suku dhèu Israꞌel. ");
INSERT INTO nfa_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Èle èèna ka, Yakob manèngi sèna ka ana-ana na pajaji mema, peka na, “Nèbhu heka, jaꞌa madhe. Ladhe bèli-camèdꞌa jaꞌa madhe, na miu hudꞌi padhane ku jaꞌa asa dꞌara roꞌa baki ku Abraham. Roꞌa ne, ètu dꞌara loe padètu dènge rae Makpela, dènge Mamre ètu rai Kanaꞌan. Uru na baki Abraham ka dhu hèli loe dènge oka na, ho jꞌajꞌi mi era roꞌa nèngu. Na hèli pamaꞌète nèti dhèu suku Het, ngara na Efron. ");
INSERT INTO nfa_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ètu era èèna, ra padhane baki èdhi Abraham dènge bèi èdhi Sara; ama jaꞌa Isak dènge ina ku Ribka ètu èèna kahèi. De èèna na, miu hudꞌi padhane jaꞌa mi era èèna, ètu sebhe roꞌa dhèu èmu jaꞌa Lea. ");
INSERT INTO nfa_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","De mage mi bhèlu, padhane jaꞌa ètu dꞌara loe dhu baki Abraham ku hèli nare èèna.” ");
INSERT INTO nfa_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob padhai lii nare sèmi èèna, na bhèjꞌi dènge ka ètu dedha koi na, hèia na madhe dènge ka. ");
INSERT INTO nfa_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Hèia Yusuf liku nare ama na, ka na tangi. Na uu ama na pèri-pèri hari. ");
INSERT INTO nfa_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ka na paredha dhèu dhu tuka urus dhèu madhe mai lalau ngiꞌu aae ama na dènge bubhu-bubhu, sèna ka baku ele iie. ");
INSERT INTO nfa_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Sasabꞌa tuka lalau ngiꞌu aae ama na, dꞌai èpa nguru lodꞌo, madhutu jꞌara sasabꞌa rèngu. Dhèu Masir aaꞌi-aaꞌi madhutu tangi kahèi mamadhe Yakob neꞌe. Ra beke pidhu nguru lodꞌo, tao sèmi dhèu kapai rèngu madhe. ");
INSERT INTO nfa_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Èle beke pidhu nguru lodꞌo, hèia Yusuf peka dènge dhèu sabꞌa na sèra, “Mi nanene! Mèti ku lii jaꞌa ne asa dhèu aae, peka sèmi neꞌe: ");
INSERT INTO nfa_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Lodꞌo ama ku oe madhe, na moa sèna ka jaꞌa laku padhane ne asa rai Kanaꞌan. De jaꞌa manèngi ho ama dhèu aae hia jaꞌa ijin laku padhane ama ku. Ladhe èle na, jaꞌa lèpa hari mai.’ ” ");
INSERT INTO nfa_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ropa tadèngi, hèia dhèu aae dhaa, peka na, “Ladhe èu dhu moa le mi ama mu sèmi èèna na, lamu ho padhane ne ètu nèi.” ");
INSERT INTO nfa_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ka Yusuf pakèdꞌi ka, laꞌe padhane ama na. Dhèu ae madhutu lasi dènge ne kahèi. Sèmi kapala urusan nèti dhèu aae, dènge dhèu kapai aaꞌi-aaꞌi nèti Masir. ");
INSERT INTO nfa_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Aꞌari Yusuf dènge dhèu-dhèu sabꞌa ra aaꞌi-aaꞌi, lasi padhane Yakob. Dhu ata ètu Gosen dhoka dhèu èmu ra, ana iiki, dènge badha-manu ra di. ");
INSERT INTO nfa_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sordadꞌu ae madhutu kahèi. Cahagꞌe caꞌe kareta, aa cahagꞌe hari caꞌe jara. Taga dhèu dhu madhutu na, ae dꞌai seli, nèti èèna ka, rombongan dhu rèti dhèu madhe ne, madhera titu kèna. ");
INSERT INTO nfa_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Rèngu lasi, ka ra pège loko Yarden ètu era èci, ngara na Atad. Era neꞌe, dhèu biasa mai jꞌèli are. Dꞌai era neꞌe, Yusuf si tangi mamadhe ama na. Aa ra beke hari pidhu mèda. ");
INSERT INTO nfa_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ropa dhèu Kanaꞌan ètu sèra, ladhe na ra jꞌèra ae titu kèna, hèia ra papeka, aku rèngu na, “We! Miu laladhe ku laa! Babeke mamadhe dhèu Masir se, ra susa bia nga! Jꞌara tatangi rèngu sèmi nèi ni ka.” Nèti èèna ka, ra pangare era èèna, ngara na Abel-Misraim. Sasoa na, ‘sasusa dhèu Masir’. ");
INSERT INTO nfa_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hèia ana-ana Yakob se, tao madhutu sèmi lii moa rèngu uru na. ");
INSERT INTO nfa_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ka nedhe rèti ngiꞌu aae Yakob na, lasi padhane asa dꞌara loe dhu padètu dènge rae Makpela dènge Mamre. Abraham hèli nare era neꞌe nèti dhèu suku Het, ngara na Efron, ho jꞌajꞌi mi era udhu rui rèngu. ");
INSERT INTO nfa_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusuf padhane nare ama na, hèia nèngu dènge aꞌari na lèpa hari asa Masir. Sama-sama dènge dhèu leo dhu madhutu sèra. ");
INSERT INTO nfa_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ropa rèngu dꞌai Masir, aꞌa Yusuf se mulai madhaꞌu. Lula ama rèngu aadꞌo heka, ka ra papeka, aku rèngu na, “We! Ta pangee ku la! Sèmi Yusuf tèka dꞌara dènge èdhi era, ho na bꞌala tatao karehe èdhi mi nèngu uru èèna, na èdhi tasamia?” ");
INSERT INTO nfa_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hèia rare lii èci, ka ra hia lii laꞌe asa Yusuf, peka na, “Ama wakil. Jiꞌi sanèdꞌe era, lodꞌo ama èdhi mamuri era, na pua jiꞌi ");
INSERT INTO nfa_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ho padhai lii dènge ama wakil, peka na, ‘Yusuf hudꞌi bhabhèlu eele ka sasala aꞌa na si. Lula uru na ra pajꞌèra ne.’ Jiꞌi ngeꞌa kahèi ama èdhi ne, karèi nèti uru ka mai, na mangajꞌi dhoka mi Ama Lamatua di. Jiꞌi kahèi jꞌajꞌi ana pajuu Lamatua. Nèti èèna ka, jiꞌi mai manèngi abho, lula uru na jiꞌi pajꞌèra le, ama wakil.” Ropa tadèngi lii neꞌe, hèia Yusuf tangi. ");
INSERT INTO nfa_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Èle èèna ka, aꞌa na si mai unu ra, ka patitu kètu urutuu ètu madha na. Hèia ra padhai lii, peka na, “Hudꞌi laa ama tao jiꞌi jꞌajꞌi ènu ama.” ");
INSERT INTO nfa_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Te ngaa Yusuf padhai lii dènge ra, “Miu se aꞌa jaꞌa! Miu baku madhaꞌu ia ka! Dhoka Ama Lamatua di, dhu dènge hak hia huku mi dhèu. Te jaꞌa ne, aadꞌo. ");
INSERT INTO nfa_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mema tareꞌa, uru na miu mere lii èci, ho neo pajꞌèra jaꞌa. Te ngaa Ama Lamatua ka dhu ubꞌa eele tatao miu dhu karehe èèna, jꞌajꞌi mi babeꞌa. Nèti èèna ka, Na dedꞌe jaꞌa jꞌajꞌi dhèu kapai ètu neꞌe, sèna ka dhèu ae abhu mamuri dènge karejꞌe. ");
INSERT INTO nfa_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nèti èèna ka, jaꞌa peka dènge miu kèna! Baku madhaꞌu ia ka. Jaꞌa pamoa dènge miu se, èèna na, ladhe-leru miu, dènge ana-èpu miu aaꞌi-aaꞌi ra.” Dènge lii padhai lii sèmi neꞌe ne, Yusuf paꞌèra hari dꞌara aꞌa na si. ");
INSERT INTO nfa_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Èle èèna ka, Yusuf pea taruu ètu rai Masir, dènge aꞌari na si, aaꞌi-aaꞌi ra. Nèngu mamuri dꞌai 110 (cangasu canguru) tèu. ");
INSERT INTO nfa_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Nèngu dꞌai hari nèdhi ana-èpu Efraim kahèi. Aa na leru èpu Manase, nuka ana-ana nèti Makir. ");
INSERT INTO nfa_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusuf peka mi aꞌa na si, aku nèngu na, “Aꞌa ku si ee! Jaꞌa rasa na mamadhe jaꞌa dètu le! Te ngaa jaꞌa parcaya, Ama Lamatua tatu ladhe-leru miu. Bèli-camèdꞌa Nèngu ka dhu lere miu kalua nèti rai neꞌe. Nèngu kahèi dhu nèti hari miu lèpa asa rai dhu Na padhadha le pake lii subha, ho hia mi baki èdhi Abraham, Isak dènge ama èdhi Yakob.” ");
INSERT INTO nfa_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ka Yusuf manèngi mi aꞌari na si, sèna ka ra subha, peka na, “Miu hudꞌi jaji ku mi dedha jaꞌa. Ladhe lodꞌo dꞌai Ama Lamatua nèti hari miu asa rai Kanaꞌan, miu hudꞌi mèti ngiꞌu aae jaꞌa asa nèi.” ");
INSERT INTO nfa_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Èle èèna ka, Yusuf madhe ètu Masir, dènge umur nèngu 110 (cangasu canguru) tèu. Hèia ra tao bubhu mi ngiꞌu aae na. Ka ra tao asa dꞌara kopa. ");
INSERT INTO nfa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Sasuri ne, lole jꞌara mamuri nèti Yesus Kristus, nuka Dhèu dhu Ama Lamatua padhadha mema ho neo pua mai. Yesus ne, ana-èpu dhèu aae Daud dènge Abraham. Karèi nèti Abraham toke dhèu aae Daud, abhu 14 (canguru èpa) bèi-baki. Kabhia Na sèmi neꞌe: Abraham matana Isak, Isak matana Yakob, Yakob matana Yahuda dènge aꞌari na, ");
INSERT INTO nfa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda matana Peres dènge Sera (ina ra, ngara na Tamar) Peres matana Herson, Herson matana Ram, ");
INSERT INTO nfa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram matana Aminadab, Aminadab matana Nahason, Nahason matana Salmon, ");
INSERT INTO nfa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon matana Boas (ina na, ngara na Rahab) Boas matana Obet (ina na, ngara na Rut), Obet matana Isai, ");
INSERT INTO nfa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai matana Daud. ");
INSERT INTO nfa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Nèti Daud toke lodꞌo dhu ra babège suku Israꞌel asa Babel, abhu hari 14 (canguru èpa) bèi-baki, nuka: Daud matana Soleman (ina na, uru èèna dhèu èmu Uria). Soleman matana Rehabeam, Rehabeam matana Abia, Abia matana Asaf, Asaf matana Yosafat, Yosafat matana Yoram, Yoram matana Usia, Usia matana Yotam, Yotam matana Ahas, Ahas matana Heskia, Heskia matana Manase, Manase matana Amos, Amos matana Yosias, Yosias matana Yekonya dènge ari na, lodꞌo babège si asa Babel. ");
INSERT INTO nfa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Lodꞌo babège si asa Babel, toke dꞌai rara iisi Yesus, abhu 14 (canguru èpa) bèi-baki, nuka: Yekonya matana Saltiel, Saltiel matana Serubabel, Serubabel matana Abihut, Abihut matana Elyakim, Elyakim matana Asor, Asor matana Sadok, Sadok matana Akim, Akim matana Eliut, Eliut matana Eliasar, Eliasar matana Matan, Matan matana Yakob, Yakob matana Yusuf, Yusuf ne, dhèu èmu Maria. Maria ne ka dhu nara iisi Yesus Kristus. ");
INSERT INTO nfa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","De karèi nèti Abraham toke Daud, abhu 14 (canguru èpa) bèi-baki; nèti Daud toke lodꞌo ra babège si asa Babel abhu 14 (canguru èpa) bèi-baki; aa nèti lodꞌo ra babège si asa Babel dꞌai Maria nara iisi Yesus, abhu 14 (canguru èpa) bèi-baki. ");
INSERT INTO nfa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lii lolo Maria nara iisi Yesus sèmi neꞌe ka: Maria dhu tunanga le dènge Yusuf. Dua ra paꞌèci rèdhi mèka sama sèmi dhèu èmu-kamali, te ngaa teꞌa boe na, Maria dhu dènge le babia nèti Roh Ama Lamatua dhu Mola-Mèci. ");
INSERT INTO nfa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ropa Yusuf neꞌa, ka na neo pamaꞌète lii rèngu dua ra. Te ngaa na dꞌèi boe pamakae Maria ètu madha dhèu ae, lula nèngu ne ca dhèu dhu dꞌara mola. Nèti èèna ka, na neo pamau eele lii rèngu ne. ");
INSERT INTO nfa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Te ngaa lodꞌo dhu na pangee era, dꞌara ca mèda sa, ka nèngu nii. Ètu dꞌara nii ne, ladhe nèdhi ana pajuu Ama Lamatua nèti sorga mai peka dènge ne, aku nèngu na, “Yusuf! Èu ne, ana-èpu dhèu aae Daud. Èu mage makae leo dènge Maria. Te ana dhu na kadꞌo èèna, jꞌajꞌi nèti Roh Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bèli-camèdꞌa Maria nara iisi ana mone ca dhèu. Aa èu hudꞌi pangare Ne, Yesus, te Nèngu ka dhu patabuli dhèu unu Ama Lamatua nèti koasa sasala-sasigo ra.” ");
INSERT INTO nfa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jꞌara ne jꞌajꞌi sèmi èèna, lula Ama Lamatua dhu peka mema nèti uru ka, re dhèu nèti lii padhai Na, ngara na Yesaya, dhu suri, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mi nanene! Bèli-camèdꞌa abhu ana bhèni ca dhèu dhu kalora iisi, teꞌa boe na, nèngu dhu dènge babia le. Èèna na nara iisi Ana Mone ca dhèu. Ka ra pangare Ne, Imanuel.” (Lii Ibrani, ‘Imanuel’ sasoa na: Ama Lamatua bera-bera dènge èdhi.) ");
INSERT INTO nfa_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ropa nii èle, Yusuf kèdꞌi nèti bhèjꞌi na. Ka na madhutu ka lii padhai Ama Lamatua dhu na tadèngi ètu dꞌara nii deo na. Ka nare Maria jꞌajꞌi dhèu èmu na. ");
INSERT INTO nfa_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Te ngaa na jꞌunu paꞌèci boe dènge Maria, toke Maria nara iisi aaꞌi. Nara iisi nare ka, Yusuf pangare Ana ne, Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Lodꞌo rara iisi Yesus ètu rae Betlehem, ètu propensi Yudea, dhèu aae Herodes dhu nèdꞌu paredha ètu èèna. Lodꞌo èèna, dhèu pèri-pèri nèti era kajꞌèu, mai nèti bèka dhimu asa kota Yerusalem. Rèngu se, dhu reꞌa mèu ladhe hua-hètu. ");
INSERT INTO nfa_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ropa ra dꞌai Yerusalem dhèu se pakarèi, aku rèngu na, “Dhèu Aae nèti dhèu Yahudi, dhu heka rara iisi hiu èèna, era na buli mia, ee? Jiꞌi ngèdhi hua-hètu cue ètu bèka dhimu, dhu jꞌajꞌi mi tadha dhu peka na, rara iisi le Nèngu. Nèti èèna ka, jiꞌi mai neo pahaha iisi mi Nèngu.” ");
INSERT INTO nfa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ropa dhèu aae Herodes tadèngi lii neꞌe, hèia dꞌara na susa. Nèti èèna ka, dhèu aaꞌi-aaꞌi ètu Yerusalem sèra, dꞌara ra susa kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Èle èèna ka, dhèu aae Herodes paroa nare kètu agama Yahudi dènge mese agama aaꞌi-aaꞌi sèra, ka na karèi si, peka na, “Miu peka sèku dènge jaꞌa la! Kristus, dhu Ama Lamatua padhadha tèke èèna, rara iisi Ne ètu mia?” ");
INSERT INTO nfa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hèia ra dhaa, aku rèngu na, “Ètu rae Betlehem, propensi Yudea. Te ca dhèu nèti lii padhai Ama Lamatua, ngara na Mika, dhu suri tèke le karèi nèti uru ka, na: ");
INSERT INTO nfa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wee! Miu dhèu Betlehem ètu propensi Yudea sèra. Baku pangee na, rae miu ne, ca rae iiki dhu dhèu ige boe. Te bèli-camèdꞌa dhèu kapai ca dhèu cèu mai nèti rae neꞌe. Èèna na Nèngu jꞌajꞌi dhèu madhenga mi dhèu Jaꞌa, dhèu Israꞌel.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ropa tadèngi nare sèmi èèna, hèia dhèu aae Herodes paroa mau-mau dhèu dhu dꞌèlu-mèu ladhe hua-hètu sèra. Ka na karèi, na, “Lodꞌo mia miu ladhe mèdhi hua-hètu ne cèu ètu dedha-liru?” Hèia ra peka dènge ne. ");
INSERT INTO nfa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Èle ka, na hia si lasi asa Betlehem. Na moa dènge ra, peka na, “Lami ho tenge palème era, ètu mia Ana ne. Ladhe miu rage, na, lèpa hari mai sèna ka peka dènge jaꞌa. Te jaꞌa neo laku pahaha iisi mi Nèngu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ropa tadèngi rare lii padhai dhèu aae, hèia lasi dènge ka. Kacaꞌa laa, rèngu rèdhi hari hua-hètu dhu uru èèna rèdhi ètu bèka dhimu. Hua-hètu ne cèu ètu madha rèngu, na kako uru nèti rèngu, hèia tèja ètu dedha era Ana ne pea. ");
INSERT INTO nfa_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ropa rèdhi, hèia ra karejꞌe titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Èle ka lasi asa dꞌara èmu, hèia ladhe rèdhi Ana ne dènge ina Na Maria. Hèia ra patitu kètu urutuu ho pahaha iisi mi Ana ne. Ka dhèu se bhoke mèdha dhu kabꞌua rèti hia Ana ne. Ra hia hualaa, kemenyan dènge raa ajꞌu hèu mèngi. ");
INSERT INTO nfa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nèbhu boe, ka dhèu se abhu nii nèti Ama Lamatua, peka na, “Lami ia ka asa dhèu aae Herodes.” Nèti èèna ka, ra lèpa hari asa rai rèngu re jꞌara leo. ");
INSERT INTO nfa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lodꞌo dhèu dꞌèlu-mèu ladhe hua-hètu se lèpa, hèia ana pajuu Lamatua èci nèti sorga, mai peka dènge Yusuf ètu dꞌara nii, aku nèngu na, “Yusuf! Pakèdꞌi dènge ka dꞌara lai-lai ne! Mèti Ana ne dènge ina Na lami asa Masir. Pea ètu nèi, toke Jaꞌa peka dꞌai lodꞌo mia miu lèpa hari. Te dhèu aae Herodes tenge jꞌara ho pamadhe Ana ne!” ");
INSERT INTO nfa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hèia Yusuf kèdꞌi nèti bhèjꞌi. Ka mèda èèna kahèi, nèti dhèu èmu na dènge Ana ne, rai lasi asa Masir. ");
INSERT INTO nfa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ra pea ètu nèi toke dhèu aae Herodes madhe. Jꞌara èèna, nuka sèmi ca dhèu nèti lii padhai Ama Lamatua, ngara na Hosea, suri tèke karèi nèti uru ka, na, “Jaꞌa paroa hari Ana Ku, ho lèpa ka nèti Masir.” ");
INSERT INTO nfa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ropa dhèu aae Herodes neꞌa nare, na, dhèu dꞌèlu-mèu ladhe hua-hètu sèra leko-monya ne, hèia na nasa titu kèna. Na paredha sordadꞌu na sèra, aku nèngu na, “Lami asa rae Betlehem nèi, aa asa rae-rae leo dhu padètu ètu èèna. Pamadhe aaꞌi ana mone iiki dhu dua tèu asa haha mai.” Herodes hia paredha ne, lula na sanèdꞌe lii lolo nèti dhèu dꞌèlu-mèu sèra. Na ige karèi nèti rèngu rèdhi hiu-hiu hua-hètu cèu ètu dedha-liru. ");
INSERT INTO nfa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jꞌara seꞌe aaꞌi-aaꞌi jꞌajꞌi madhutu ngaa dhu dhèu nèti lii padhai Ama Lamatua, ngara na Yermia, suri tèke, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Abhu lii tangi dènge lii roma iisi dhèu nèti kota Rama. Rahel tangi dꞌara pèdꞌa, lula ana-ana na madhe aaꞌi. Na dꞌèi boe ca dhèu sa mai pamako ne, lula ana-ana na, aadꞌo heka ca dhèu sa.” ");
INSERT INTO nfa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nèbhu-nèbhu ka, dhèu aae Herodes madhe. Lodꞌo èèna, Yusuf si ètu Masir era. Hèia Ama Lamatua pua ana pajuu Na ca dhèu mai nèti sorga, padꞌelo rèhu na mi nèngu ètu dꞌara nii. ");
INSERT INTO nfa_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ana pajuu ne lii, aku nèngu na, “Yusuf! Kèdꞌi ka! Mèti ka Ana ne dènge ina Na asa Israꞌel. Te dhèu dhu neo pamadhe Ana ne, madhe le.” ");
INSERT INTO nfa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ropa tadèngi nare, hèia Yusuf kèdꞌi. Èle ka nèti si asa rai Israꞌel. ");
INSERT INTO nfa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Te ngaa ropa Yusuf tadèngi na, Arkalaus, ana dhèu aae Herodes, dhu jꞌajꞌi dhèu aae limuri ne ètu propensi Yudea, ka na madhaꞌu laꞌe asa Yudea. Èle èèna ka, Ama Lamatua peka hari dènge ne ètu dꞌara nii, na, “Yusuf, èu baku pea ètu Yudea.” Nèti èèna ka, lasi pea asa propensi Galilea, ");
INSERT INTO nfa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ètu rae Nasaret. Dènge jꞌara ne lii padhai Ama Lamatua lèke tareꞌa, nuka sèmi ngaa dhu dhèu rèti lii padhai Na suri tèke, na “Bèli-camèdꞌa dhèu paroa Ne, Dhèu Nasaret.” ");
INSERT INTO nfa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lodꞌo Yesus dhu kapai le, hèia Yohanis tuka sarani mulai ajꞌa-nori dhèu ètu era dhu dhèu pea boe ètu propensi Yudea. ");
INSERT INTO nfa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Na ajꞌa peka na, “Aꞌari pasue! Miu hudꞌi mangaku aa tèke eele ku sasala-sasigo miu, ho lèpa asa Ama Lamatua. Te limuri ne dhèu aaꞌi-aaꞌi bisa jꞌajꞌi dhèu unu Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Uru èèna, ca dhèu nèti lii padhai Ama Lamatua, ngara na Yesaya, suri le lula-nèti Yohanis ne, aku nèngu na, “Bèli-camèdꞌa abhu dhèu paꞌoo-parodha ètu dꞌara mamoo, peka na, ‘Dhèu aaꞌi-aaꞌi paꞌèra sèna ka tao pabeꞌa jꞌara, ho sèmi mamai Ama Lamatua! Tao pamola jꞌara hia Ne!’ ” ");
INSERT INTO nfa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jꞌara mamuri Yohanis ne, ca ropa dènge dhèu rèti lii padhai Ama Lamatua uru sèra. Mèdha-papake na tao nèti rèu badha onta. Dhari hake na nèti kaꞌuri badha. Ngangaꞌa na, kabara dènge dhua nasu oni. ");
INSERT INTO nfa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lodꞌo èèna, dhèu ae mai neo paraga dènge Yohanis. Rèngu mai nèti kota Yerusalem, nèti kabarai propensi Yudea aaꞌi-aaꞌi, dènge nèti rae-rae dhu dètu loko Yarden. ");
INSERT INTO nfa_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ra bhoka dꞌara ra, aa mangaku sasala-sasigo aaꞌi-aaꞌi, èle ka Yohanis sarani si ètu dꞌara loko Yarden. ");
INSERT INTO nfa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lodꞌo èèna, dhèu ae nèti partei agama Parisi dènge dhèu partei agama Saduki, lasi asa era èèna kahèi, manèngi Yohanis sarani si. Te ngaa ropa Yohanis ladhe nèdhi si, hèia na jèke si, peka na, “Heeh! Miu se cakaraa mege dhu kapodꞌe-kabèli. Bèli-camèdꞌa Ama Lamatua huku mi, lula tatao miu dhu bhelu-katubꞌa sèra. Mage mi pangee na, miu bisa rai nèti hahuku Na. ");
INSERT INTO nfa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","De beꞌa risi miu lèpa sa Ama Lamatua, aa tèke eele sasala miu sèra. Èle na, tao jꞌara-jꞌara dhu beꞌa, sèmi ajꞌu dhu hua beꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mage mi pangee na, miu se abhu mamuri, lula jꞌajꞌi ana-èpu Abraham. Mi sanèdꞌe lii jaꞌa, ee! Te Ama Lamatua bisa tao hadhu se jꞌajꞌi ana-èpu Abraham kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Baku pamudꞌe! Te abhu dhu kèpe mema kataka, paꞌèra patue aaꞌi-aaꞌi ajꞌu dhu hua beꞌa boe, sèna ka core asa dꞌara ai. ");
INSERT INTO nfa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Limuri ne, jaꞌa sarani miu pake èi, ho jꞌajꞌi mi tadha dhu peka na, miu se tèke eele sasala-sasala miu. Te ngaa pe abhu ca Dhèu dhu kapai risi nèti jaꞌa, bèli-camèdꞌa mai. Masi ka jꞌajꞌi ana pua-paleha Na, jaꞌa nia boe sa hèi. Èèna na, Nèngu papènu dꞌara miu dènge Roh Ama Lamatua dhu Mola-Mèci. Nèngu tao miu jꞌajꞌi mola-mèci kahèi, sama sèmi dhèu pake ai ho bhubhu maruru. ");
INSERT INTO nfa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Te Nèngu dhu nèdꞌu kokotai dènge laludhu ètu dꞌara, ho neo tatai eele èto na. Èle èèna, Na bhori laludhu asa dꞌara soka. Te ngaa èto sèra, Na dutu asa dꞌara ai dhu heo robhe-robhe dhu madhe boe.” ");
INSERT INTO nfa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lodꞌo èèna, Yesus puru mai nèti Galilea, laꞌe asa loko Yarden. Na mai sèna ka manèngi Yohanis sarani Ne. ");
INSERT INTO nfa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Te ngaa Yohanis noꞌo boe. Na pabꞌala peka na, “Tasamia ka jaꞌa sarani Èu? Sale ne, sina ma? Hudꞌi Èu ku dhu sarani jaꞌa. Te èèna ka dhu jaꞌa parluu!” ");
INSERT INTO nfa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Te ngaa Yesus dhaa, aku Nèngu na, “Pangee ia ka. Te ngaa doe neꞌe, hudꞌi laa èu di dhu sarani Jaꞌa. Dènge jꞌara sèmi neꞌe, èdhi tao madhutu dadꞌèi Ama Lamatua.” Ropa tadèngi nare, ka Yohanis bꞌala, aku nèngu na, “Sadꞌi aku Èu” Hèia Yohanis sarani Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ropa sarani èle, ka Yesus kalua nèti dꞌara loko. Cagꞌagꞌa laa, liru bhoke eele. Hèia ladhe nèdhi Roh Ama Lamatua puru mai, nuka sèmi koro jꞌaha dhu mai tèka mi Nèngu. ");
INSERT INTO nfa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hèia ra tadèngi lii Ama Lamatua nèti dedha-liru, peka na, “Nèngu ne, Ana pasue Jaꞌa. Nèngu pakarejꞌe taruu dꞌara Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Èle ka, Roh Ama Lamatua nèti Yesus asa dꞌara mamoo, sèna ka dhèu aae nidhu sèku Ne. ");
INSERT INTO nfa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ètu era neꞌe, Yesus naꞌa-ninu boe èpa nguru lodꞌo mèu-mèda. Hèia Na manganga titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ropa Na manganga sèmi èèna, hèia dhèu aae nidhu mai sèku Ne, peka na, “Èu ne tareꞌa-reꞌa Ana Ama Lamatua, do? Ladhe tareꞌa, na, paredha hadhu se, ho jꞌajꞌi ngangaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Te ngaa Yesus dhaa, na, “Dhu suri ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, peka na: ‘Dhèu rai-haha mamuri mesa boe nèti ngangaꞌa di. Te ngaa rèngu hudꞌi nanene ku Lii Holo-Nori Ama Lamatua, aa tao madhutu dadꞌèi Na kahèi.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ka dhèu aae nidhu nèti Yesus asa kota Yerusalem, kota Lamatua dhu mola-mèci èèna. Èle ka, na nèti Yesus asa era dhu dedha risi ètu Èmu Kapua Manèngi-Mangajꞌi. ");
INSERT INTO nfa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hèia nidhu ne, peka, “Ladhe Èu ne tareꞌa-reꞌa Ana Ama Lamatua, Èu ridhu sèku asa haha nèi. Te dhu suri tèke ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, na, ‘Pe Ama Lamatua pua ana pajuu nèti sorga, sèna ka jꞌaga Èu.’ Aa ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, dhu suri kahèi, ‘Pe ra kanata ai ra, ho sibhe Èu, sèna ka ngiꞌu Èu pèdꞌa boe, aa haga Èu goi lèke boe hadhu sa hèi.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Te ngaa Yesus bꞌala, aku Nèngu na, “Abhu kahèi dhu suri tèke ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, dhu peka na, ‘Ama Lamatua èèna, Lamatua èu. De èu baku pua Ne pake koasa Na, sèna ka padꞌelo bukti, peka na, Nèngu èèna, tareꞌa-reꞌa Ama Lamatua.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Èle èèna ka, dhèu aae nidhu ne nèti hari Yesus asa kolo ledhe dhu dedha aae. Hèia na padꞌelo aaꞌi saraga dènge babeꞌa negara aaꞌi-aaꞌi ètu rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ropa na padꞌelo nare, hèia dhèu aae nidhu ne peka, aku nèngu na, “Sadꞌi Èu patitu kètu urutuu, sèna ka pahaha iisi mi jaꞌa, pe jaꞌa hia aaꞌi seꞌe se mi Èu.” ");
INSERT INTO nfa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Te ngaa Yesus jèke ne, peka na, “He, nidhu! Pakajꞌèu nèti era neꞌe ne! Te Sasuri Mola-Mèci Ama Lamatua, suri na, ‘Èu hudꞌi pahaha iisi mi Ama Lamatua, aa èu ne hudꞌi sabꞌa ku dhoka hia Nèngu di.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ropa dhèu aae nidhu tadèngi lii ne, hèia na tèke eele Yesus. Te ngaa ana pajuu Ama Lamatua nèti sorga mai uri Ne. ");
INSERT INTO nfa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tèu èèna, dhèu aae Herodes pamaso Yohanis tuka sarani asa dꞌara èmu bèdho. Ropa Yesus tadèngi, hèia Na lèpa asa Galilea. ");
INSERT INTO nfa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Laꞌe asa rae Na Nasaret, èle ka laꞌe taruu pea ètu rae Kapernaum. Rae èèna ètu sebhe dano Galilea, ètu rai Sebulon dènge Naftali. ");
INSERT INTO nfa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dènge jꞌara ne, Na tao madhutu ngaa dhu dhèu nèti lii padhai Ama Lamatua, ngara na Yesaya, suri tèke, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Rai Sebulon dènge rai Naftali dhu padètu dènge dano Galilea ètu sebhe haa loko Yarden. Dhèu Yahudi boe pea ètu era sèra kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Rèngu dhu mamuri ètu dꞌara maroga, te ngaa limuri ne, rèdhi le saraa. Aa saraa ne heo le palème mi dhèu aaꞌi-aaꞌi dhu tadhe mèka Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Karèi nèti lodꞌo èèna, Yesus mulai ajꞌa-nori dhèu, peka na, “Miu hudꞌi soro kabodho aa tèke eele sasala-sasigo miu, ho mamuri ka dènge mola-mèci! Te limuri ne dhèu aaꞌi-aaꞌi bisa le jꞌajꞌi dhèu unu Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ca tèka, Yesus kako re sebhe dano Galilea. Na paraga dènge dhèu dua dhu paꞌaꞌari. Èci ngara na Simon, dhu tema paroa ne, Petrus. Aa ari na, Anderias. Dua ra dhu pèku iꞌa ètu dano Galilea, lula dua ra dhèu sabꞌa dhasi. ");
INSERT INTO nfa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hèia Yesus paroa si, aku Nèngu na, “Mai ku madhutu Jaꞌa! Miu biasa tenge iꞌa, te ngaa limuri ne Jaꞌa neo ajꞌa miu ho jꞌajꞌi tuka tenge dhèu.” ");
INSERT INTO nfa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ropa ra tadèngi rare, hèia dua ra tèke eele dènge ka pèku ra, lasi madhutu Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Èle ka, Yesus kako hari ciki, hèia ladhe nèdhi ana Sabadeus, dhèu dua. Aꞌa, ngara na Yakobis, aa ari na, Yohanis. Dua ra dhu lalau paie pèku ètu dedha koha sama-sama dènge ama ra. Hèia Yesus paroa dua ra, sèna ka madhutu Ne. ");
INSERT INTO nfa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ropa ra tadèngi rare, hèia ra tèke eele ama dènge koha ra, lasi madhutu Ne. ");
INSERT INTO nfa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Èle ka, Yesus si kako palème propensi Galilea, ho Na ajꞌa-nori dhèu ètu dꞌara èmu sabajꞌa dhèu Yahudi. Na ajꞌa Lii Lolo Beꞌa Ama Lamatua, aa Na peka jꞌara-jꞌara tasamia, sèna ka dhèu bisa madhutu paredha Ama Lamatua. Aa Na puri-paꞌèle kahèi dhèu nèti rupa-rupa papèdꞌa-tarègu. ");
INSERT INTO nfa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nèbhu boe ka, tatao Yesus ne dhèu lolo palème toke dꞌai propensi Siria aaꞌi-aaꞌi. Hèia dhèu rèti dhèu ra dhu lèke rupa-rupa papèdꞌa asa Yesus. Dhèu se rèti kahèi dhèu dhu nidhu tao, dhu hujꞌu kahibꞌi, dènge dhu karuku. Ka Na puri-paꞌèle aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lodꞌo èèna, dhèu ae-ae mai madhutu Ne. Dhèu se mai nèti propensi Galilea, aa nèti rai Canguru Kota, dhu ra peka na, Dekapolis. Dhèu cahagꞌe mai nèti kota Yerusalem, nèti propensi Yudea, aa nèti cabèka dhimu loko Yarden. ");
INSERT INTO nfa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ropa Yesus ladhe nèdhi dhèu ae-ae mai madhutu Ne, hèia Na caꞌe laꞌe asa ledhe iiki cue, ka Na madhèdi ètu èèna. Ana-ana madhutu dhu Na hagꞌe nare sèra, mai padètu sèna ka nanene Ne. ");
INSERT INTO nfa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hèia Na ajꞌa-nori si, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Dhèu kasia, rèngu oto, lula Ama Lamatua mesa Na, ka Dhèu Aae rèngu dhu hua iia. ");
INSERT INTO nfa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dhèu dhu ètu dꞌara sasusa, rèngu oto, lula Ama Lamatua mesa Na ka dhu pamahoꞌo dꞌara si. ");
INSERT INTO nfa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Dhèu haha oto, lula rèngu ka dhu bèli-camèdꞌa sèmi rare mèngi-nale aaꞌi-aaꞌi dhu Ama Lamatua moa tèke. ");
INSERT INTO nfa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dhèu dhu dꞌara kateme dènge Ama Lamatua, rèngu oto, lula èèna na, Nèngu ka dhu hia si ngaa dhu ra neo. ");
INSERT INTO nfa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Dhèu dhu padꞌelo rasa kasia mi dhèu leo, rèngu oto, lula èèna na, Ama Lamatua kasia rèngu kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dhèu dhu dꞌara mola-mèci, rèngu oto, lula èèna na, rèngu unu ra ladhe rèdhi Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Dhèu dhu tema padame dhèu, rèngu oto, lula èèna na Ama Lamatua ka dhu peka na, ‘Rèngu seꞌe ka, ana Jaꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dhèu dhu pasae jꞌajꞌèra, lula ra madhutu Ama Lamatua, rèngu oto, lula Lamatua mesa Na ka, Dhèu Aae rèngu dhu hua iia. ");
INSERT INTO nfa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ladhe dhèu leo pajꞌèra miu, lula miu madhutu Jaꞌa, miu oto kahèi. Ladhe dhèu padhai kakedꞌu miu, aa lole paꞌele iie kolongara miu, miu oto kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Masi ka sèmi èèna, te ngaa miu hudꞌi pakasee iisi aa pakarejꞌe dꞌara, lula Ama Lamatua dhu sadia nare le pala dhu ae hia miu ètu sorga. Te ngaa sanèdꞌe! Mesa boe miu di dhu dui jꞌajꞌèra sèmi èèna, te lodꞌo uru sèra dhèu dhu pajꞌèra le kahèi dhèu rèti lii padhai Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ladhe èdhi dꞌèi sèna ka ngangaꞌa jꞌajꞌi beꞌa, na, èdhi tao ku masi. Sèmi èèna kahèi dènge dhèu dhu mamuri ètu rai-haha ne, rèngu parluu miu. Te ngaa ladhe masi sèro heka, gaguna na, ngaa? Dhoka core eele di ètu jꞌara, ho dhèu jꞌèli ne. ");
INSERT INTO nfa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Miu hudꞌi mamuri ku sèmi labhu kahèi, sèna ka dhèu ae bisa ladhe rèdhi miu dènge beꞌa. Miu hudꞌi heo loꞌa-loꞌa ku, nuka sèmi kota ètu kolo ledhe, dhu dhèu aaꞌi-aaꞌi ladhe rèdhi ne. ");
INSERT INTO nfa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ladhe dhèu paheo labhu iiki, ra saguru boe ne dènge èru rai, te ngaa ra padhèdi labhu ne ètu era dedha, ho pasaraa aaꞌi dꞌara èmu. ");
INSERT INTO nfa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Miu hudꞌi mamuri ku sèmi èèna. Mamuri miu hudꞌi saraa ku, sèna ka dhèu leo ladhe rèdhi mamuri miu dhu beꞌa. Ropa dhèu ladhe rèdhi mamuri miu sèmi èèna, ra dedꞌe padedha-dedha kolongara Ama Lamatua, peka na, ‘Ira ii! Ama miu ètu sorga, kapai titu kèna, nga!’ ” ");
INSERT INTO nfa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mage miu pangee na, mamai Jaꞌa asa rai-haha ne, sèna ka tao eele atora Ama Lamatua dhu pangèdꞌu mi Musa. Aa baku pangee na, Jaꞌa pusi-pahae boe dènge ngaa dhu uru èèna, dhèu rèti lii padhai Ama Lamatua peka tèke le. Te mamai Jaꞌa ne, sèna ka pamèci jꞌara aaꞌi-aaꞌi, nuka sèmi mia dhu ra peka tèke. ");
INSERT INTO nfa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nèti èèna ka, nanene paie-iie! Liru dènge rai-haha bisa mèka laho aaꞌi, ladhe aaꞌi-aaꞌi jꞌajꞌi mèka madhutu atora Ama Lamatua. Masi ka ca katèdꞌa èèna ka, bisa boe ele nèti atora se. ");
INSERT INTO nfa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nèti dhèu unu Ama Lamatua aaꞌi-aaꞌi, ladhe abhu dhu sisu atora Ama Lamatua, lula na pangee, na, ‘Atora ne, ana iiki-iiki di, de gaguna na aadꞌo!’ Hèia na ajꞌa sèmi èèna kahèi mi dhèu leo, pe Ama Lamatua ètu sorga, tao ne jꞌajꞌi mi ca dhèu ana iiki. Te ngaa bagi mi dhèu dhu tao madhutu aaꞌi atora Ama Lamatua, hèia na ajꞌa-nori dhèu leo sèmi èèna, bèli-camèdꞌa Ama Lamatua pakabꞌua ne. ");
INSERT INTO nfa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Parcaya la Jaꞌa! Miu hudꞌi mamuri mola, risi nèti mese agama dènge dhèu partei agama Parisi sèra. Ladhe aadꞌo, na, miu bisa boe jꞌajꞌi dhèu unu Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Miu dhu meꞌa le atora Musa dhu hia mi bèi-baki èdhi, peka na, ‘Baku pamadhe dhèu, te dhèu cee dhu pamadhe dhèu nèngu lèke huku.’ ");
INSERT INTO nfa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Te ngaa Jaꞌa peka dènge miu sèmi neꞌe: baku panasa, te dhèu cee dhu nasa dènge aꞌari na, èèna na nèngu lèke huku. Dhèu dhu jèke aꞌari na, ka peka na, ‘Èu bodꞌo kabao!’ pe nèngu laꞌe dhaa asa dhèu heka-dhèu heka agama. Aa dhèu cee dhu jèke aꞌari na, ‘Goa, ee!’ nèngu lèke huku ètu ai naraka. ");
INSERT INTO nfa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","De ladhe èu dhu mèti mèdha persembahan hia Ama Lamatua, te ngaa èu sanèdꞌe, na, abhu aꞌari dhu nasa era dènge èu, ");
INSERT INTO nfa_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tèke eele uuru ku mèdha persembahan sèra. Hèia lamu padame ku dènge aꞌari mu, èle, na heka mai hia persembahan se asa Ama Lamatua kèna. ");
INSERT INTO nfa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ladhe ca dhèu neo tao lii langu dènge èu, beꞌa risi lamu lai-lai ho padame dènge ne. Ladhe aadꞌo, dhèu ne nèti èu asa hakim. Hèia hakim saraka èu sa polisi, ka ra pamaso èu asa dꞌara bèdho. ");
INSERT INTO nfa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jaꞌa pasanèdꞌe tareꞌa-reꞌa mi èu ne! Èèna na èu pea taruu ètu dꞌara bèdho, toke bꞌae aaꞌi mèu-mèu kèlu-gꞌètu èu sèra.” ");
INSERT INTO nfa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Miu dhu meꞌa le atora Musa, dhu peka na, ‘Baku bersina.’ ");
INSERT INTO nfa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Te ngaa Jaꞌa neo peka na, sèmi neꞌe: dhèu dhu ladhe nèdhi dhèu bhèni èci, hèia dꞌara na neo jꞌunu paꞌèci dènge ne, na, dhèu mone ne bersina le dènge bhèni ne ètu dꞌara na. ");
INSERT INTO nfa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ladhe èu tao sala pake musi madha gꞌana èu, na, edꞌo eele ne. Te beꞌa risi èu maso sorga dènge musi madha cabèka di, aa baku ra pèci mu asa dꞌara ai naraka dènge musi madha dua-dua. ");
INSERT INTO nfa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aa ladhe èu tao sala dènge kacui-aai gꞌana èu, poro eele kacui-aai ne. Te beꞌa risi èu maso sorga dènge kacui-aai cabèka di, aa baku ra pèci mu asa dꞌara ai naraka dènge kacui-aai dhu kateme iisi.” ");
INSERT INTO nfa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Miu dhu meꞌa le atora Musa, na, ‘Dhèu dhu paꞌia dènge dhèu èmu-kamali na, nèngu hudꞌi hia ku sasuri paꞌia mi bhèni èèna.’ ");
INSERT INTO nfa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Te ngaa Jaꞌa peka sèmi neꞌe: ladhe abhu dhèu dhu ia eele dhèu èmu na, te ngaa bhèni ne tao nèdhi boe jꞌara makae, hèia bhèni ne leo hari èmu, na, dhèu èmu uuru èèna ka dhu tao nèngu jꞌajꞌi bersina. Aa ladhe abhu dhèu mone dhu leo nare bhèni dhu dhèu èmu na ia eele, na, rèngu dua ra bersina kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Miu dhu meꞌa le atora Musa dhu na hia mi bèi-baki èdhi, peka na, ‘Ladhe èu pajaji pake lii soo-subha, dhu ale kolongara Ama Lamatua, na, èu dhu paꞌèki le dènge soo-subha èèna.’ ");
INSERT INTO nfa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Te ngaa Jaꞌa peka sèmi neꞌe: ladhe èu neo pajaji, na, mage mu jꞌoka subha. Baku subha dènge ngara sorga, lula sorga èèna era pea Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mage subha pake ngara rai-haha, lula rai-haha ne, era bane haga Ama Lamatua. Aa mage subha pake ngara Yerusalem, lula Yerusalem èèna, kota nèti Dhèu Aae Kapai. ");
INSERT INTO nfa_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Baku subha pake ngara kabꞌa kètu miu. Te miu dènge boe koasa ho paredha rèu kètu miu, sèna ka ca loa sa jꞌajꞌi mèdhi do jꞌajꞌi pudhi. ");
INSERT INTO nfa_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","De ladhe miu neo pajaji, dhu peka oo, na, peka la ‘oo’ di. Te ngaa ladhe aadꞌo, na, peka la, ‘aadꞌo’ di. Ladhe miu peka risi nèti èèna, sèra sa jꞌajꞌajꞌi nèti nidhu.” ");
INSERT INTO nfa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Miu dhu meꞌa le atora Musa, dhu peka na, ‘Ladhe dhèu cee dhu paꞌele iie musi madha miu, na, paꞌele iie kahèi musi madha na. Aa ladhe abhu dhèu dhu pakabhui eele ngutu èu, na, pakabhui eele ngutu na kahèi.’ ");
INSERT INTO nfa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Te ngaa Jaꞌa peka dènge miu sèmi neꞌe: baku bꞌala bhabhelu dènge bhabhelu. Ladhe dhèu tèbꞌe ripi èu cabèka, na hudꞌi laa, na tèbꞌe hari ripi dhu leo. ");
INSERT INTO nfa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ladhe dhèu neo tenge lii langu dènge èu, ho neo nare kodho èu, na, hia ne kodho pana èu kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ladhe sordadꞌu ca dhèu laka-seti èu ho pasae mèdha na kako dꞌai ca kilometer, na, èu pasae mèti kajꞌèu na toke dua kilometer. ");
INSERT INTO nfa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ladhe dhèu neo manèngi nare mèdha èu èci, na, hia la. Aa ladhe dhèu neo pija mèdha èu, na, hia la.” ");
INSERT INTO nfa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Miu tadèngi le, dhu peka na, ‘Sue la aꞌari èu, aa nasa la dènge dhèu dhu nasa dènge èu.’ ");
INSERT INTO nfa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Te ngaa Jaꞌa peka sèmi neꞌe: èu hudꞌi sue ku dhèu dhu nasa dènge èu, aa manèngi ho Lamatua hia mèngi-nale mi dhèu dhu pajꞌèra èu. ");
INSERT INTO nfa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ladhe èu tao sèmi èèna, èu padꞌelo, na, èu ana Ama ètu sorga. Lula Nèngu ka tao madha lodꞌo hia dhèu dhu beꞌa, dènge dhèu dhu bhelu. Na papuru èjꞌi hia dhèu dhu tao madhutu paredha Na, aa mi dhèu dhu labꞌa paredha Na kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","De ladhe èu sue dhoka dhèu dhu sue èu, èu ngee na Ama Lamatua hudꞌi bꞌala hia èu mèngi-nale, do? Aadꞌo! Te dhèu bhelu kahèi neꞌa sue angalai na, dhu sue nèngu. ");
INSERT INTO nfa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","De ladhe èu meꞌa dhoka hia lii mahoꞌo mi angalai èu, na, kolo-karisi na ngaa? Te dhèu dhu parcaya boe Ama Lamatua, reꞌa adꞌu-ue jꞌara sèmi èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","De sanèdꞌe, ee! Ama mu ètu sorga sue dhèu aaꞌi-aaꞌi. De èu hudꞌi tao madhutu ku sèmi èèna kahèi!” ");
INSERT INTO nfa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus ajꞌa taruu, peka na, “Sanèdꞌe! Mage mi madhutu atora agama di, sèna ka dhèu padꞌiri miu. Te ladhe miu tao sèmi èèna, Ama miu ètu sorga bꞌala boe rui-jꞌajꞌèra miu. ");
INSERT INTO nfa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ladhe miu neo soru-bara dhèu kasia, mage lami palolo asa mia-mia. Te ladhe miu se tao sèmi èèna, miu ca ropa dènge dhèu dhu padhai lii leo, tao leo. Dhèu sèmi sèra, dꞌèi lasi karihu asa dꞌara èmu sabajꞌa ho dhèu koa si, peka na, ‘Ira ii! Dhèu ne majꞌèni madhutu atora agama, nga!’ Jaꞌa peka mola-mola kèna! Dhèu dhu tema sèmi rare lii koa-kadꞌiri nèti dhèu, rèngu se abhu le pala ra. ");
INSERT INTO nfa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","De ladhe miu neo soru-bara dhèu dhu dènge boe ngaa-ngaa, mage mi palolo kahèi! ");
INSERT INTO nfa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dènge sèmi èèna, dhèu ètu rai-haha ne reꞌa boe. Te ngaa Ama miu ètu sorga dhu neꞌa ngaa dhu miu tao pahuni. Pe Nèngu ka dhu bꞌala hia miu berkat ae-ae.” ");
INSERT INTO nfa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Lodꞌo miu sabajꞌa, miu baku tao nuka sèmi dhèu dhu padhai lii leo, tao leo. Dhèu se dꞌèi lasi asa jꞌara dhu dhèu ae-ae, aa titu ètu dꞌara èmu manèngi-mangajꞌi ho dhèu koa-kadꞌiri si, peka na, ‘Dhèu se, dhèu mola-mèci!’ Te ngaa nanene pabeꞌa-beꞌa! Dènge rèngu abhu koa sèmi èèna, rèngu sèmi rare le pala ra. ");
INSERT INTO nfa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Te ngaa miu baku sèmi èèna. Ladhe miu manèngi-mangajꞌi, lami asa dꞌara kama ho bèdho babèdho na. Èle èèna, heka mi sabajꞌa mau-mau hia Ama mi ètu sorga. Masi ka dhèu leo rèdhi boe, te ngaa Ama miu ladhe nèdhi. Bèli-camèdꞌa Na bꞌala hia miu berkat ae-ae. ");
INSERT INTO nfa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ladhe miu sabajꞌa, baku padhai lii dhu dènge boe kolo-kapua. Te dhèu dhu tadhe boe Ama Lamatua sabajꞌa sèmi èèna ka. Rèngu pangee, na, Ama Lamatua dꞌèi nanene lii manèngi ra dhu madhera lola-lola èèna. ");
INSERT INTO nfa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mage mi madhutu jꞌara rèngu sèra! Te masi ka miu dhae manèngi mèka ngaa-ngaa nèti Ama mi ètu sorga, te ngaa Nèngu dhu neꞌa mema le, ngaa dhu miu parluu. ");
INSERT INTO nfa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","De ladhe sabajꞌa, na, madhutu la conto sèmi neꞌe: ‘Ama ètu sorga! Kolongara Ama dhu mola-mèci. Hudꞌi laa dhèu aaꞌi-aaꞌi, dedꞌe padedha-dedha kolongara Ama dhu kapai èèna. ");
INSERT INTO nfa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Hudꞌi laa Ama jꞌajꞌi Dhèu Aae mi dhèu aaꞌi-aaꞌi! Hudꞌi laa dhèu aaꞌi-aaꞌi, tao madhutu paredha Ama ètu rai-haha ne, nuka sèmi ana pajuu Ama, tao madhutu paredha Ama ètu sorga. ");
INSERT INTO nfa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ama, hia la jiꞌi ngangaꞌa-nganginu dhu dꞌai bèli-bèli. ");
INSERT INTO nfa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jiꞌi manèngi, ho Ama saku eele aaꞌi sasala-sasigo jiꞌi, nuka sèmi jiꞌi kahèi pabhèlu eele sasala dhèu dhu ra tao mi jiꞌi. ");
INSERT INTO nfa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ama, jꞌaga la jiꞌi, sèna ka jiꞌi baku tao bhabhelu. Aa pakajꞌèu la jiꞌi nèti koasa nidhu, Te Ama ka Dhèu Aae dhu koasa kapai risi eele. Aa Ama ka dhu mèdꞌu paredha, toke dꞌai mia-mia laꞌe. Sabajꞌa jiꞌi dꞌai sange neꞌe ka, Ama. Amin.’ ");
INSERT INTO nfa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Te ngaa sanèdꞌe, ee! Ladhe miu pabhèlu eele sasala dhu dhèu tao mi miu, èèna na Ama mi ètu sorga saku eele sasala-sasigo miu kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Te ngaa ladhe miu moꞌo boe pabhèlu eele sasala dhu dhèu tao mi miu, bèli-camèdꞌa Ama mi bhèlu boe sasala miu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ladhe miu manèngi-mangajꞌi aa puasa, mage mi tao rèhu susa, nuka sèmi dhèu dhu padhai lii leo, tao leo. Te ra adꞌu-ue jꞌara èèna, ho dhèu padꞌiri si, peka na, ‘Dhèu seꞌe se, dhèu mola-mèci!’ Te ngaa sanèdꞌe, ee! Dènge sèmi rare koa-kadꞌiri sèmi èèna, na, rèngu abhu le pala ra. ");
INSERT INTO nfa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Te ngaa ladhe miu puasa, lèu pamèu-mèu rèhu mi, aa sageri paie kètu miu! ");
INSERT INTO nfa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","De ladhe dhèu rèdhi miu, reꞌa boe na, miu dhu puasa. Te ngaa Ama miu neꞌa. Pe Na pala hia miu mèngi-nale ae-ae.” ");
INSERT INTO nfa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Miu baku sabꞌa taruu, ho dhodhoka pakaboko mèdha-panyau ae-ae ètu rai-haha ne di. Te hubꞌu dènge rutu paꞌele iie aaꞌi si. Aa dhèu manaꞌu mai paꞌele iie era tatèka mèdha-panyau, aa manaꞌu rèti si. ");
INSERT INTO nfa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Te ngaa beꞌa risi miu majꞌèni sabꞌa, sèna ka pakaboko mèdha-panyau ae-ae ètu sorga. Te ètu era nèi, abhu boe hubꞌu dènge rutu dhu paꞌele iie si, aa abhu boe dhèu manaꞌu, ho mai manaꞌu rèti. ");
INSERT INTO nfa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Te ladhe miu tèka mèdha-panyau miu ètu era mia, na, tatu dꞌara miu ètu èèna kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Musi madha dhèu, nuka sèmi labhu dhu pasaraa dꞌara ra. Ladhe musi madha na mèu, nèngu madhutu jꞌara mamuri dhu hua iia, èci èèna ka dènge dhèu dhu kako ètu dꞌara saraa. ");
INSERT INTO nfa_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Te ngaa ladhe musi madha na ahu, nèngu bisa boe kako madhutu madha jꞌara mola, nuka sèmi dhèu dhu gogo ai lae-lae ètu dꞌara maroga. De ladhe saraa ètu dꞌara miu jꞌajꞌi maroga, na miu mamuri dꞌara maroga kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Dhèu bisa boe sabꞌa hia dua lamatua, lula èèna na nèngu dꞌèi risi ca dhèu di. Bisa kahèi nèngu madhutu lamatua èci, aa pusi-pahae boe dhu leo. Nèti èèna ka, èu bisa boe peka na, ‘Ama Lamatua èèna, Lamatua jaꞌa,’ ladhe èu tao doi-dhari jꞌajꞌi mi lamatua èu. ");
INSERT INTO nfa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nèti èèna ka, Jaꞌa peka dènge miu sèmi neꞌe: baku bhute pangee, na, jaꞌa mamuri tasa mera mia, kuꞌa-kinu ngaa, pake ngaa? Miu pangee na, mamuri ne dhoka taꞌa-tinu, di? Aa ngiꞌu ne, dhoka pake mèdha-papake, di? Aadꞌo sèmi èèna. ");
INSERT INTO nfa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ladhe ku manu-bhui dhu lela ètu talora liru. Rèngu bhute rèdhi boe sèla hini, dènge puu-gꞌètu, ho tèka ngangaꞌa ètu dꞌara soka. Te ngaa Ama miu ètu sorga piara manu-bhui sèra taruu. Tatu Nèngu kabꞌoi miu risi eele nèti rèngu. De ngee pabeꞌa-beꞌa. Te Ama Lamatua pakabꞌua miu risi nèti manu-bhui sèra. ");
INSERT INTO nfa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ladhe dhèu titu ètu madha tèru, ho na bhute dènge lalau ngiꞌu na, nèngu bisa pamadhera hari ngiꞌu na, do? Bisa boe! ");
INSERT INTO nfa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ladhe bisa boe, na, nga tao ka miu bhute dènge pangee hari mèdha-papake? Lami ladhe ku hela bunga dhu muri tabꞌa ètu dꞌara padꞌa sodꞌa. Rèngu manyèru boe hèngu, aa manènu boe sigꞌi sa hèi. ");
INSERT INTO nfa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Te ngaa sanèdꞌe ku la! Mèdha-papake dhèu aae Soleman dhu kabꞌua risi, saraga na bisa boe segi saraga hela bunga ne. ");
INSERT INTO nfa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Te Ama Lamatua taru kira mi bunga dhu muri dhoka doe neꞌe, aa bèli madhe, ho dhèu core asa dꞌara ai. Ladhe Na tao sèmi èèna, tatu Nèngu papake miu risi eele nèti hela bunga sèra. De tasamia ka miu parcaya paꞌèra boe mi Nèngu? ");
INSERT INTO nfa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","De baku mi pangee na, ‘Jiꞌi neo ngaꞌa ngaa?’ do, ‘Neo nginu ngaa?’ do, ‘Neo pake ngaa?’ ");
INSERT INTO nfa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dhèu dhu parcaya boe Ama Lamatua, rèngu sabꞌa loe boe ho neo abhu aaꞌi-aaꞌi se. Te ngaa miu baku tao sèmi èèna, te Ama miu ètu sorga dhu neꞌa aaꞌi le, ngaa-ngaa dhu miu parluu. ");
INSERT INTO nfa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Te ngaa miu hudꞌi pakako uuru ku sasabꞌa Na, aa hudꞌi madhutu ku paredha Na, heka Na hia miu aaꞌi-aaꞌi dhu miu parluu. ");
INSERT INTO nfa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","De baku bhute pangee, na, bèli miu parluu ngaa. Te bèli èèna dènge bhabhute unu na. Sasusa lodꞌo doe neꞌe, èle ètu doe neꞌe kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Miu baku galaa dhèu, sèna ka Ama Lamatua baku pasala miu kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ladhe miu nile dhèu sèmi mia, pe Ama Lamatua nile miu sèmi èèna kahèi. Ladhe miu ige sasala dhèu sèmi mia, bèli-camèdꞌa Ama Lamatua ige sasala miu sèmi èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Masi ka sasala dhèu ciki ooꞌe èèna ka, èu bhèlu boe. Te ngaa sasala èu dhu kapai, èu pameꞌa boe ciki sa. Èci èèna ka dènge èu ladhe mèdhi ahu ca katèdꞌa ètu dꞌara madha angalai èu, te ngaa abhu agarii aae ca laa dhu paꞌabhe nare musi madha èu, dhu èu meꞌa more boe. ");
INSERT INTO nfa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nga tao ka èu bani peka na, ‘Angalai! Mai ho jaꞌa tiu eele ahu nèti dꞌara madha èu’. Aa te ngaa èu mesa mu bisa boe mèdhi ngaa-ngaa, lula agarii aae dhu hutu nare musi madha mu. ");
INSERT INTO nfa_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Heeh! Èu ne, mema dhèu dhu padhai lii leo, tao leo! Tao eele uuru ku agarii nèti musi madha èu, heka ladhe mèdhi ahu ca katèdꞌa ètu dꞌara madha angalai mu, sèna ka èu bisa tiu eele ahu ne kèna. ");
INSERT INTO nfa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Baku ajꞌa jꞌara Lamatua dhu mola-mèci mi dhèu dhu dꞌèi pahahe dhèu. Lula dhèu sèra nuka sèmi busa pakadhi, dhu ra kabèli mai kadhi hari miu. Rèngu sèra goa sama sèmi hahi kahèi. Ladhe dhèu hia ne mutiara dhu kabꞌua, na pusi boe! Te neꞌa dhoka jꞌèli palaho di.” ");
INSERT INTO nfa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ladhe miu sabajꞌa, baku loe manèngi mi Lamatua; te èèna na, Na hia. Ladhe patangi-tenge; pe Na padꞌelo jꞌara. Ladhe kadꞌeu taruu babèdho; pe Na bhoke. ");
INSERT INTO nfa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Te dhèu aaꞌi-aaꞌi dhu loe boe manèngi mi Lamatua, èèna na ra sèmi rare. Dhu patangi-tenge, pe ra abhu. Dhu kadꞌeu taruu, pe Na bhoke èmu. ");
INSERT INTO nfa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Miu pangee sèku! Ladhe ana manèngi roti, tatu ama na hia boe ne hadhu, si? ");
INSERT INTO nfa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Do, ladhe ana manèngi iꞌa, ama na hia boe mege, sina ma? ");
INSERT INTO nfa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ama mi ètu sorga, mema dꞌara Na hua iia titu kèna! De ladhe dhèu rai-haha dhu bhelu-katubꞌa sèmi miu, meꞌa hia mèdha dhu beꞌa mi ana miu, ngaa hari Ama mi! Tatu Na bagi hia miu ngaa dhu miu manèngi. ");
INSERT INTO nfa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","De, ngaa dhu èu neo dhèu leo tao mi èu, na, èu hudꞌi tao sèmi èèna kahèi hia nèngu. Lula neꞌe ne ka, jꞌajꞌi mi kapua nèti aaꞌi-aaꞌi dhu Musa dènge dhèu rèti lii padhai Ama Lamatua dhu peka-padhai karèi nèti uru ka.” ");
INSERT INTO nfa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ladhe dhèu neo maso sorga, nèngu hudꞌi maso ku re hèbꞌa kota dhu kobꞌo. Te ngaa mage-mage, oo! Abhu kahèi jꞌara leo dhu mudꞌa, aa hèbꞌa dhu taleo, dhu dhèu ae-ae lasi re èèna. Te jꞌara sèmi èèna ka dhu lere dhèu asa naraka, ka ra cèri eele nèti Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Dhèu dhu neo maso sorga, hudꞌi madhutu ku jꞌara dhu susa, aa maso re hèbꞌa dhu kobꞌo. Te, masi ka dhèu ciki di dhu kako re jꞌara èèna, te ngaa jꞌara dhu kobꞌo èèna ka, dhu nèti dhèu asa Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Baku pamudꞌe dènge dhèu dhu tema kapodꞌe-kabèli, dhu dꞌèi padedha iisi, peka na, rèngu se dhèu rèti lii padhai Ama Lamatua. Te rèngu tao ngiꞌu ra beꞌa nuka sèmi kahibꞌi-kalèbho. Te ngaa rèngu se dhèu bhelu-katubꞌa, èci èèna ka dènge busa hui dhu mai kadhi kahibꞌi-kalèbho. ");
INSERT INTO nfa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tasamia ho miu bisa tadhe dhèu dhu kapodꞌe sèmi sèra? Ladhe la nèti tatao rèngu. Èèna sèmi dhèu ladhe rèdhi hua, hèia tadhe dènge ana aajꞌu ne. Hua dhu beꞌa, mai boe nèti ajꞌu dhu karehe. ");
INSERT INTO nfa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Te ajꞌu dhu beꞌa ladhe dꞌai hua, hua na beꞌa kahèi. Te ngaa ajꞌu dhu karehe ladhe na hua, hua na karehe kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Abhu ètu mia, ajꞌu dhu beꞌa, hua na karehe, aa ajꞌu dhu karehe, hua na beꞌa? ");
INSERT INTO nfa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ajꞌu dhu hua na karehe, tatu ra patue eele, ho core asa dꞌara ai. ");
INSERT INTO nfa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sèmi èèna kahèi dènge rèngu dhu rèti lii padhai kapodꞌe-kabèli sèra. Miu tadhe si nèti tatao ra.” ");
INSERT INTO nfa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Èèna na abhu dhèu dhu paroa Jaꞌa, na, ‘Lamatua!’ Te ngaa rèngu dhoka ale ètu hèbꞌa di. Bèli-camèdꞌa Ama Lamatua ètu sorga tule eele si. Te dhodhoka dhèu dhu dꞌèi tao madhutu dadꞌèi Nèngu di, dhu Na sèmi nare rèngu jꞌajꞌi dhèu unu Na. ");
INSERT INTO nfa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pe ropa dꞌai èle rai-haha ne, dhèu ae mangaku, peka na, Jaꞌa ne Lamatua rèngu. Aa dènge lii solo-mako, ra peka na, ‘Lamatua! Jiꞌi se laꞌa pakako aꞌajꞌa Lamatua ètu mia-mia, babège nidhu dènge kolongara Lamatua, aa tao tadha-tadha malaa pake koasa nèti Lamatua.’ ");
INSERT INTO nfa_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Masi ka rèngu solo-mako Jaꞌa sèmi èèna, te ngaa èèna na Jaꞌa peka dènge rèngu, na, ‘Miu se, cee? Jaꞌa tadhe boe miu, te miu mamuri boe madhutu dadꞌèi Ama Lamatua. De mi pakajꞌèu ka nèti neꞌe!’ ” ");
INSERT INTO nfa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Dhèu dhu mai nanene Jaꞌa, hèia ra tao madhutu lii padhai Jaꞌa, rèngu se nuka sèmi dhèu dhu dꞌèlu-mèu, dhu patitu èmu ra ètu dedha hadhu kapua. ");
INSERT INTO nfa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nèbhu boe, ka èjꞌi aae mai toke èi lala, aa ngèlu aae lèke èmu ne. Te ngaa èmu ne guri boe, lula patitu ètu dedha hadhu kapua. ");
INSERT INTO nfa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dhèu dhu mai nanene Jaꞌa, te ngaa tao boe madhutu lii padhai Jaꞌa, nèngu ne èci èèna ka dènge dhèu goa dhu patitu èmu na ètu dedha salae. ");
INSERT INTO nfa_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nèbhu boe, ka èjꞌi aae mai toke èi lala. Ngèlu aae lèke èmu ne kahèi. Hèia èmu ne guri eele, toke laho tebꞌo-tebꞌo.” ");
INSERT INTO nfa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ropa Yesus padhai lii nare, hèia dhèu aaꞌi-aaꞌi ra malaa-maloha, lula nanene aꞌajꞌa Na, ");
INSERT INTO nfa_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","te Nèngu neꞌa mèu isi nèti aꞌajꞌa ne. Na ajꞌa-nori sèmi boe mese agama sèra. ");
INSERT INTO nfa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lodꞌo Yesus puru nèti ledhe, hèia dhèu ae-ae lasi madhutu Ne. ");
INSERT INTO nfa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kabèdhi laa, ca dhèu dhu pèdꞌa kusta mai paraga dènge Ne. Hèia na patitu kètu urutuu ètu madha Yesus, ho manèngi, aku nèngu na, “Lamatua! Sue ku jaꞌa la! Ladhe moꞌo, na, puri ku papèdꞌa jaꞌa ne, sèna ka dhèu madenge ia ka dènge jaꞌa, aa jaꞌa bisa hari sabajꞌa ètu dꞌara èmu manèngi-mangajꞌi.” ");
INSERT INTO nfa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ropa tadèngi nare, hèia Yesus jꞌole kacui-aai Na ka Na gꞌagꞌe dhèu ne, hèia Na lii, aku Nèngu na, “Jaꞌa koꞌo! Èu èle kèna!” Kabèdhi la, èi papèdꞌa dhèu ne èle dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hèia Yesus peka dènge ne, “Sanèdꞌe paie! Èu èle le nèti papèdꞌa-tarègu, te ngaa baku èu lolo dènge dhèu èci sa. Aa èu hudꞌi madhutu ku atora Musa. De lamu asa ama agama ho na parisa ngiꞌu èu, sèna ka neꞌa na èi papèdꞌa mu ele le, tareꞌa, do dhae. Èle na, èu hia persembahan tadha makasi, sèna ka dhèu reꞌa, na, èu ne èle tareꞌa-reꞌa le nèti papèdꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Èle èèna, hèia Yesus maso asa dꞌara rae Kapernaum. Ètu era neꞌe, komedhaa sordadꞌu Roma ca dhèu, mai manèngi ho Yesus soru-bara ne, aku nèngu na, ");
INSERT INTO nfa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ama! Ana sabꞌa jaꞌa ca dhèu, pèdꞌa aae, ka na jꞌèra titu kèna ètu èmu. Na bisa boe puru nèti era jꞌunu na.” ");
INSERT INTO nfa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ka Yesus dhaa, peka na, “Oo! Pe Jaꞌa dhiu puri-paꞌèle ne.” ");
INSERT INTO nfa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te ngaa komedhaa ne bꞌala, aku nèngu na, “Ama! Ama roca ia ka mai asa èmu jaꞌa, lula jaꞌa nia boe sèmi Ama asa dꞌara èmu jaꞌa. Sadꞌi Ama ku peka dhoka lii ca hèbꞌa di nèti neꞌe, tatu ana sabꞌa jaꞌa ne èle dènge nèti papèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jaꞌa keꞌa jꞌara ne, lula jaꞌa dènge dhèu paredha dedha kahèi, dhu dènge koasa ho paredha jaꞌa. Aa jaꞌa dènge koasa kahèi, sèna ka paredha sordadꞌu jaꞌa sèra. Ladhe jaꞌa pua, peka na, ‘Lamu sa nèi!’ tatu na laꞌe dènge. Aa ladhe jaꞌa peka, ‘Mai asa neꞌe!’ tatu na mai. Aa ladhe jaꞌa paleha dhèu sabꞌa jaꞌa, peka na, ‘Sabꞌa neꞌe!’ tatu na tao madhutu. De sadꞌi Ama ku lii di, tatu ana sabꞌa jaꞌa èèna, èle dènge nèti papèdꞌa na.” ");
INSERT INTO nfa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ropa Yesus tadèngi nare, hèia Na malaa. Ka Na padhai lii dènge dhèu ae sèra, aku Nèngu na, “Nèbhu nare sange neꞌe, Jaꞌa dhae paraga kèdhi mèka dènge ca dhèu sa nèti dhèu Yahudi dhu lèka èra sama sèmi dhèu Roma ne! ");
INSERT INTO nfa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nanene paie-iie! Te bèli-camèdꞌa dhèu leo rai kara ae-ae, nuka sèmi dhèu Roma ne, mai nèti haa, nèti dhimu, ho madhèdi raꞌa-rinu mei èci dènge Abraham, Isak dènge Yakob ètu dꞌara èmu Ama Lamatua ètu sorga. ");
INSERT INTO nfa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Masi ka Lamatua dhu hagꞌe nare le dhèu Yahudi, sena ka jꞌajꞌi dhèu unu Na, te ngaa ae ka dhu pusi-pahae boe Ne. Èèna na, Lamatua tule eele si asa era dhu maroga kiu-kiu. Ètu era neꞌe, ra tangi roma iisi dꞌara pèdꞌa, aa ra jꞌèra titu kèna.” ");
INSERT INTO nfa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Padhai lii nare, hèia Yesus peka dènge komedhaa ne, “Lèpa ka. Te ana sabꞌa èu èèna èle le, madhutu sèmi parcaya èu ne.” Ka lodꞌo dhu Na padhai èèna, ana ne èle dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ca tèka, Yesus laꞌe asa èmu Petrus. Na ladhe nèdhi ina dhèu èmu Petrus dhu jꞌunu ètu dedha koi, dhu pèdꞌa maringi-sagoro. ");
INSERT INTO nfa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ka Yesus kèpe kacui-aai na, hèia ina ne èle nèti papèdꞌa na. Hèia na kèdꞌi, ka laꞌe lalau ngangaꞌa hia Yesus si. ");
INSERT INTO nfa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ropa lodꞌo oe cèna, hèia dhèu sèra mai rèti dhèu rèngu dhu nidhu tao. Hèia Na paredha nidhu se, peka na, “Eee, nidhu! Rai pakajꞌèu nèti neꞌe!” Hèia nidhu se kalua dènge ka. Na puri-paꞌèle kahèi dhèu aaꞌi-aaꞌi nèti papèdꞌa-tarègu ra. ");
INSERT INTO nfa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na tao jꞌara se, ho pamèci dènge lii dhèu nèti lii padhai Ama Lamatua, ngara na Yesaya, dhu suri tèke le, peka na, “Na puri-paꞌèle papèdꞌa-tarègu èdhi. Aa pasae nare jꞌajꞌèra èdhi.” ");
INSERT INTO nfa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Èle èèna ka, Yesus nèdhi dhèu ae-ae mai kalibhu rare Ne. Hèia Na peka dènge ana-ana madhutu Na, aku Nèngu na, “Mai pakèdꞌi lati asa cabèka dano.” ");
INSERT INTO nfa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hèia mese agama ca dhèu mai, padhai lii dènge Ne, peka na, “Ama Mese! Sadꞌi Ama asa mia èèna ka, jaꞌa bera-bera dènge Ama!” ");
INSERT INTO nfa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ka Yesus dhaa, peka na, “Beꞌa kahèi do! Te ngaa sanèdꞌe. Dhèu rai-haha aa badha-manu aaꞌi-aaꞌi, dhu dènge era pea-paluꞌu. Busa hui lèpa asa roꞌa na. Manu-bhui laꞌe asa rèdꞌa na. Te ngaa Jaꞌa Dhèu Rai-haha Tareꞌa-reꞌa ne dènge boe era pea-paluꞌu. Nanèlu ho bane kètu dènge boe kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Èle ka, dhèu èci hari mai peka dènge Yesus, na, “Ama! Jaꞌa neo madhutu Ama, te ngaa hudꞌi jaꞌa ladhe-leru ku ina-ama jaꞌa. Ladhe ama ku madhe, ho padhane kore, heka jaꞌa madhutu kèna.” ");
INSERT INTO nfa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Te ngaa Yesus padhai lii, peka na, “Sèmi neꞌe! Hudꞌi laa dhèu leo dhu parcaya boe Lamatua padhane dhèu madhe. Te ladhe èu neo madhutu Jaꞌa, na, madhutu la dènge dꞌara kateme!” ");
INSERT INTO nfa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Èle èèna ka, Yesus caꞌe asa dedha koha, palere dènge ana-ana madhutu Na. ");
INSERT INTO nfa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ropa rèngu ètu talora dano era, Yesus bhèjꞌi. Kacaꞌa laa, ngèlu aae mai. Naha aae tèbꞌe koha ne, toke èi maso asa dꞌara. ");
INSERT INTO nfa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ropa ladhe rèdhi sèmi èèna, hèia ana madhutu se lasi parèi Yesus, aku rèngu na, “Ama! Ama! Kèdꞌi ku la! Bara ku jiꞌi, te èdhi molo madhe aaꞌi ti kèna!” ");
INSERT INTO nfa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hèia Yesus dhaa, peka na, “Wee! Nga tao ka miu se madhaꞌu sèmi neꞌe ne? Miu parcaya boe Jaꞌa, do?” Ka Na kèdꞌi. Èle ka Na kai ngèlu dènge naha ètu dꞌara dano ne, peka na, “Mau ka!” Hèia naha dènge ngèlu mau dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ka ana madhutu Yesus se malaa-maloha. Ra papeka na, “Ira ii! Cee ka Dhèu neꞌe ne? Tasamia ka Na bisa paredha ngèlu dènge naha, ka madhutu dadꞌèi Na?” ");
INSERT INTO nfa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nèbhu boe ka rèngu dꞌai cabèka dano, ètu rai Gadꞌara. Ètu era nèi, abhu dhèu dua dhu nidhu tao. Rèngu pea ètu era roꞌa dhèu madhe. Dua ra seꞌe bhelu titu kèna, toke abhu boe ca dhèu sa hèi dhu bani kako re era èèna. Ropa rèdhi Yesus mai, hèia ");
INSERT INTO nfa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ra paꞌoo, peka na, “We, Ana Ama Lamatua! Nga tao ka Èu mai gagu jiꞌi se? Masi ka dꞌai mèka lodꞌo ho hia hahuku mi jiꞌi, te ngaa Èu mai le ho neo pajꞌèra jiꞌi!” ");
INSERT INTO nfa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kajꞌèu boe ètu era èèna, abhu hahi canau dhu nyuu rai, tenge ngangaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hèia nidhu se manèngi Yesus, aku rèngu na, “Ladhe babèga eele jiꞌi, na, pua la jiꞌi maso asa dꞌara hahi sèi!” ");
INSERT INTO nfa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hèia Yesus paredha nidhu se, peka na, “Lami ka!” Hèia nidhu kalua tèke eele dhèu dua se, lasi maso asa dꞌara hahi deo sa. Ka hahi se rai pacebꞌa re sebhe ledhe ka manahu asa dꞌara dano, hèia ra cèna, ka madhe aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ropa ladhe rèdhi sèmi èèna, dhèu madhenga hahi, rai lasi asa dꞌara rae, hèia ra lolo ngaa dhu jꞌajꞌi ne. ");
INSERT INTO nfa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ropa tadèngi rare, dhèu ae lasi asa era èèna. Dꞌai nèi, ra rèdhi Yesus. Hèia ra pakaseti Yesus, ho pakèdꞌi nèti rae rèngu ne. ");
INSERT INTO nfa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Èle èèna, Yesus si caꞌe hari koha, lèpa asa ca bèka dano. Ka rèngu puru ètu kota Na. ");
INSERT INTO nfa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ètu era neꞌe dhèu jꞌèru rèti angalai ra dhu karuku asa Yesus. Ropa ladhe nèdhi, Yesus neꞌa le, na, rèngu parcaya Ne, peka na, Nèngu bisa puri-paꞌèle angalai ra. Hèia Na peka dènge dhèu karuku ne, aku Nèngu na, “Ana! Paꞌèra dꞌara èu! Te Jaꞌa saku eele le sasala èu.” ");
INSERT INTO nfa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te ngaa ètu era èèna, abhu pèri-pèri mese agama Yahudi dhu tadèngi lii padhai Yesus èèna. Ka ra nasa, hèia ra papeka, na, “Dhèu neꞌe ne bani titu kèna peka sèmi èèna! Dhodhoka Ama Lamatua di dhu bisa abho sasala-sasigo dhèu. Te ngaa lii padhai Dhèu ne tao iisi Na sama sèmi Ama Lamatua sa. Nèngu ne pahaha Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Te ngaa Yesus neꞌa dꞌara rèngu. Nèti èèna ka Na lii, aku Nèngu na, “Nga tao ka miu se pangee, na, Jaꞌa ne pahaha Ama Lamatua? ");
INSERT INTO nfa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mia ka dhu mudꞌa risi? Ladhe Jaꞌa peka dènge dhèu karuku ne, ‘Jaꞌa saku eele le sasala èu,’ do, Jaꞌa peka na, ‘Kèdꞌi, ho lèpa ka.’ ");
INSERT INTO nfa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ladhe na kèdꞌi dènge ka, miu heka mèdhi, na, Jaꞌa ne Dhèu Rai-haha Tareꞌa-reꞌa. Te Jaꞌa dènge hak ho abho sasala dhèu.” Hèia Yesus paredha dhèu karuku ne, peka na, “Kèdꞌi ka! Dedꞌe mèti ka karadꞌa èu, ho lèpa ka!” ");
INSERT INTO nfa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ka dhèu karuku ne kèdꞌi, hèia na lèpa dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ropa ladhe rèdhi, hèia rèngu aaꞌi-aaꞌi ra malaa-maloha. Hèia ra dedꞌe padedha-dedha kolongara Ama Lamatua, peka na, “Ama Lamatua, kapai risi eele! Na hia koasa kapai sèmi neꞌe, hia mi dhèu rai-haha.” ");
INSERT INTO nfa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Èle ka Yesus laꞌe nèti era èèna, hèia ladhe nèdhi ca dhèu roro doi bea dhu sabꞌa ètu kantor bea. Ngara dhèu ne, Mateos. Hèia Yesus gale ne, peka na, “Mai madhutu Jaꞌa!” Ropa tadèngi nare, hèia Mateos kèdꞌi dènge ka, laꞌe madhutu Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ka Mateos nèru Yesus si lasi raꞌa-rinu asa èmu na. Na nèru kahèi mone aanga-angalai na dhèu roro bea sèra, aa tamu dhu leo kahèi, ho raꞌa-rinu dènge rèngu. ");
INSERT INTO nfa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te ngaa abhu pèri-pèri dhèu nèti partei Parisi, mai kaꞌugu ètu madha ana-ana madhutu Yesus, peka na, “Nga tao ka mese miu madhèdi naꞌa-ninu dènge dhèu-dhèu dhu guna boe se, nuka sèmi dhèu roro bea dènge angalai ra dhu bhelu-katubꞌa sèra?” ");
INSERT INTO nfa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Te ngaa Yesus peka dènge rèngu, aku Nèngu na, “Dhèu pèdꞌa parluu dote-matarii, te ngaa dhèu dhu pèdꞌa boe parluu boe. ");
INSERT INTO nfa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Beꞌa risi lami parisa paie-iie Lii Holo-Nori Ama Lamatua. Te uru èèna, Na pua Hosea, ca dhèu nèti lii padhai Na, dhu suri peka na, ‘Dadꞌèi Jaꞌa nuka, dhèu-dhèu Jaꞌa hudꞌi pasue ku èci dènge èci, aa padꞌelo rasa kasia. Ladhe ra tao boe madhutu sèmi èèna, na, badha korban rèngu dhu rèti hia Jaꞌa, dènge boe kabꞌua.’ Neꞌe ne ka dhu Ama Lamatua peka tèke le. Nèti èèna ka, Jaꞌa mai boe ho uri dhèu dhu pangee na, rèngu dhèu mola, te ngaa Jaꞌa mai sèna ka ladhe-leru dhèu dhu laku-laku boe.” ");
INSERT INTO nfa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Èle èèna ka, ana madhutu Yohanis tuka sarani sèra, mai sa Yesus. Dhèu se karèi, aku rèngu na, “Jiꞌi dhu madhutu Yohanis tema puasa. Aa dhèu Parisi puasa kahèi. Te ngaa tasamia ka ana madhutu Ama sèra loe boe raꞌa-rinu? Rèngu reꞌa boe puasa, do?” ");
INSERT INTO nfa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Te ngaa Yesus dhaa dènge lii pakasame, na, “Sèmi neꞌe: ladhe pesta kabꞌi, tamu sèra puasa boe, te ngaa raꞌa toke bècu. Ladhe pengantin mone dènge rèngu era, aaꞌi-aaꞌi ra raꞌa-rinu palere-lere. Te ngaa ladhe dhèu leo rai rèti ka pengantin mone ne, hèia mone aanga-angalai Na, dꞌara ra susa, de heka ra puasa kèna. ");
INSERT INTO nfa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Dhèu bisa boe rare bèla hiu ca èta, ho kalape mi kodho dhui dhu mae. Te ropa base kodho ne, bèla hiu dhu kalape laꞌa deo na karuku, na kodho deo na asa mae aae. ");
INSERT INTO nfa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jꞌara sèmi èèna kahèi, dènge dhua dhu heka rèti mai nèti kapua, bisa boe bhori asa dꞌara sabha dhui. Te aadꞌo na sabha ne madhore, hèia dhua bhori eele asa rai laꞌe. De dhua dhu hiu hudꞌi bhori ku asa dꞌara sabha hiu, sèna ka dua ra beꞌa taruu!” Dènge sèmi neꞌe, Yesus nori si, peka na, aꞌajꞌa Na dhu hiu, baku pakihu dènge aꞌajꞌa dhu dhui. ");
INSERT INTO nfa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ètu dꞌara Yesus padhai lii era dènge ana madhutu Yohanis sèra, hèia kapala nèti èmu manèngi-mangajꞌi mai paraga dènge Ne. Ka na patitu kètu urutuu ètu madha Yesus. Hèia na manèngi, aku nèngu na, “Ama, ee! Sue ku jaꞌa la! Te ana bhèni jaꞌa heka madhe kèna. De lati ho Ama bane ai mi ana ne, sèna ka na mamuri hari.” ");
INSERT INTO nfa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ropa Na tadèngi, hèia Yesus dènge ana madhutu Na, madhutu dènge ka dhèu deo na. ");
INSERT INTO nfa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ètu talora jꞌara, ca dhèu ina kako laꞌe madhutu si. Bhèni ne lèke papèdꞌa bhèni, dhu loe boe ciki sa dꞌai canguru dua tèu kèna. Na pangee, na, “Sadꞌi jaꞌa gai lèke kodho Yesus di, tatu èi papèdꞌa jaꞌa ne èle.” Nèti èèna ka, na ara padètu laꞌe, hèia na gai lèke suu kodho Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus dhu neꞌa, hèia Na kabibꞌa, ladhe sa ina ne. Ka Na lii, peka na, “Ina, ee! Paꞌèra la dꞌara èu. Te, lula èu parcaya Jaꞌa tareꞌa-reꞌa, nèti èèna ka èu èle nèti papèdꞌa.” Hèia bhèni ne èle dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Èle ka, Yesus si lasi taruu asa èmu nèti kapala èmu manèngi-mangajꞌi èèna. Dꞌai era nèi, maso laꞌe asa dꞌara, hèia Na ladhe nèdhi dhèu dhu tema karihu musiik mamadhe, dènge dhèu ae dhu tangi dꞌara pèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Te ngaa Yesus peka dènge ra, aku Nèngu na, “Ae eele ka tangi, aa lami ka èmu miu! Te ana ne madhe boe, dhoka na bhèjꞌi di.” Te ngaa dhèu se mari dènge pakapengo hèbꞌa mi Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Èle ka, dhèu se aaꞌi-aaꞌi lasi asa liꞌu. Ka Yesus maso asa dꞌara kama ana bhèni ne. Na kèpe ai ana ne, hèia ana ne mamuri dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ropa ladhe rèdhi jꞌara ne, ka dhèu mulai palolo lème ètu kabarai ra, lula-nèti ngaa dhu Yesus tao ne. ");
INSERT INTO nfa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Èle, hèia Yesus kako taruu. Ètu talora jꞌara, abhu dhèu bèdhu dhèu dua dhu madhutu Ne. Dua ra rodhe, peka na, “Ana-èpu dhèu aae Daud! Sue ku jiꞌi la!” ");
INSERT INTO nfa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ropa Yesus maso asa dꞌara èmu cue, dhèu bèdhu se lasi paraga dènge Ne. Ka Yesus karèi dua ra, peka na, “Miu se lèka tareꞌa-reꞌa, na, Jaꞌa ne dènge koasa ho puri-paꞌèle miu, sèna ka bisa ladhe mèdhi, do?” Hèia dua ra dhaa, aku rèngu na, “Ama karèi ia ka, te jiꞌi dhu lèka mema-mema le.” ");
INSERT INTO nfa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ropa tadèngi lii dhaa dua ra, hèia Yesus gꞌagꞌe musi madha ra, ka Na peka na, “Ladhe sèmi èèna, na, jꞌajꞌi ka madhutu parcaya miu.” ");
INSERT INTO nfa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus padhai lii èle, hèia dua ra ladhe rèdhi dènge ka. Te ngaa Yesus pasanèdꞌe si, peka na, “Baku miu peka dènge ca dhèu sa, ngaa dhu jꞌajꞌi le!” ");
INSERT INTO nfa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Te ngaa dhèu se taha rare boe dꞌara ra. Ka ra kako palème kabarai èèna, lole dènge dhèu aaꞌi-aaꞌi, tatao Yesus mi rèngu dua ra. ");
INSERT INTO nfa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ropa dhèu bèdhu se lasi, dhèu rèti dhèu leo hari èci asa Yesus. Dhèu ne bisa boe padhai lii, lula nidhu tao ne. ");
INSERT INTO nfa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ropa ladhe nèdhi, hèia Yesus paredha nidhu kalua nèti dhèu lii aadꞌo ne. Nidhu èèna kalua, ka dhèu ne padhai lii dènge ka. Hèia dhèu ae ètu era èèna malaa, ka ra peka na, “Ira ii! Èdhi dhèu Yahudi paraga tèdhi mèka madha jꞌara sèmi neꞌe ne!” ");
INSERT INTO nfa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Te ngaa dhèu Parisi kaꞌuu, peka na, “Dhèu aae nidhu ka dhu hia Ne koasa, sèna ka Na bisa babège eela nidhu.” ");
INSERT INTO nfa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Èle èèna ka, Yesus kako palème kota-kota dènge rae-rae, sèna ka ajꞌa-nori dhèu ètu dꞌara èmu sabajꞌa sèra. Na ajꞌa dhèu nèti Lii Holo-Nori Ama Lamatua, aa jꞌara tasamia rèngu bisa jꞌajꞌi dhèu unu Ama Lamatua. Na puri-paꞌèle kahèi dhèu nèti papèdꞌa-tarègu ra. ");
INSERT INTO nfa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ropa Yesus ladhe nèdhi dhèu ae se, hèia Na taha nare boe dꞌara, lula dhèu se reꞌa heka tao sèmi ngaa sa. Te rèngu nuka sèmi kahibꞌi-kalèbho dhu dènge boe dhèu madhenga. ");
INSERT INTO nfa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Èle ka, Yesus padhai lii dènge ana madhutu Na, aku Nèngu na, “Dhèu ae se, nuka sèmi ngangaꞌa ae-ae ètu dꞌara oka-tedhe. Masi ka ngangaꞌa ae titu kèna, te ngaa dhèu sabꞌa dꞌai boe ho puu-gꞌètu, sèna ka tèke asa dꞌara gudꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nèti èèna ka, miu hudꞌi manèngi ku mi Lamatua oka, sèna ka Na tabha hari dhèu sabꞌa, ho lasi puu-gꞌètu isi oka se.” ");
INSERT INTO nfa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Èle ka, Yesus paroa ana madhutu Na, sèna ka mai pakaboko. Hèia Na hia si koasa ho babège eele nidhu aa puri-paꞌèle dhèu nèti papèdꞌa-tarègu ra. ");
INSERT INTO nfa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ana madhutu Na dhu Na pua sèra, dhèu canguru dua, nuka: Partama, ngara na Simon (dhu dhèu tema paroa ne, ‘Petrus’), dènge ari na, Anderias, Yakobis, dènge ari na, Yohanis (dua ra ana Sabadeus), ");
INSERT INTO nfa_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pelipus, Bertolomeos, Tomas, Mateos (dhèu roro doi bea), Yakobis dhu leo (nuka ana Alpius), Tadius, ");
INSERT INTO nfa_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon (nèti partei politik Selot), dènge Yudas Iskariot (dhu èèna na pahie Yesus). ");
INSERT INTO nfa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Èle èèna ka, Yesus pua ana madhutu Na canguru dua dhèu sèra, aa paredha si, peka na, “Jaꞌa pua miu lami asa dhèu èdhi dhèu Yahudi sèra, lula ae nèti rèngu dhu madhutu boe jꞌara mamuri Ama Lamatua dènge mola. Rèngu cakaraa kahibꞌi-kalèbho dhu sala jꞌara. Nèti èèna ka, baku lami asa dhèu Yahudi boe, nuka sèmi dhèu Samaria. ");
INSERT INTO nfa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lami peka dènge dhèu Israꞌel èdhi sèra, na, ‘Neꞌe ne, dꞌai lodꞌo kèna, sèna ka dhèu aaꞌi-aaꞌi ra bisa jꞌajꞌi dhèu unu Ama Lamatua.’ ");
INSERT INTO nfa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aa lami puri-paꞌèle dhèu pèdꞌa, pamamuri hari dhèu madhe, paꞌèle dhèu kusta, aa babège eele nidhu. Ama Lamatua hia le miu ae-ae, te ngaa Na manèngi hari boe ca ana maa sa. De lami ka ho pala paꞌae-ae mi dhèu leo, te ngaa mage mi manèngi hari ngaa-ngaa kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Pakèdꞌi dènge ai hua. Baku mèti doi, ");
INSERT INTO nfa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","gee jꞌara, mèdha silu, salapa, do tatea. Te dhèu hudꞌi hia ku dhèu sabꞌa, ngaa dhu pantas ho ra bisa mamuri. ");
INSERT INTO nfa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ladhe miu maso asa dꞌara kota do rae èci, na, miu hudꞌi tenge ku dhèu dhu neo sèmi rare miu. Hèia miu pea ètu èmu èèna, toke miu pakèdꞌi tèke eele era èèna. ");
INSERT INTO nfa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ladhe miu maso asa dꞌara èmu dhèu, peka la dènge rèngu, ‘Saloom! Lamatua hia miu mèngi-nale.’ ");
INSERT INTO nfa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ladhe dhèu ètu dꞌara èmu ne, sèmi rare miu dènge beꞌa, na, miu manèngi sèna ka Lamatua hia si berkat. Te ngaa ladhe ra roꞌo boe sèmi rare miu, na, Lamatua hia boe rèngu berkat. ");
INSERT INTO nfa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ladhe dhèu roꞌo boe nanene lii padhai miu, mi kalua nèti èmu èèna, do kota èèna, hèia miu caro eele ahu nèti haga miu, sèna ka jꞌajꞌi mi tadha, peka na, ladhe roꞌo boe nanene, pe rèngu dꞌui rare pala ra. ");
INSERT INTO nfa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bèli-camèdꞌa, lodꞌo Ama Lamatua huku dhèu ètu rai-haha neꞌe, tatu Na pabia mi dhèu Sodom dènge Gomora dhu uru èèna bhelu titu kèna. Te ngaa sanèdꞌe! Èèna na, Nèngu huku bia risi hari mi dhèu dhu roꞌo boe sèmi rare miu!” ");
INSERT INTO nfa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Sanèdꞌe paie! Te Jaꞌa pua miu ne, èci èèna ka Jaꞌa patabuli kahibꞌi-kalèbho asa talora aae busa hui. Nèti èèna ka, ngangee miu hudꞌi sèmi mege dhu dꞌèlu-mèu. Aa dꞌara mi hudꞌi mola ku nuka sèmi koro jꞌaha dhu neꞌa boe tenge lii langu. ");
INSERT INTO nfa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Te ngaa baku pamudꞌe! Te bèli-camèdꞌa dhèu pajꞌèra miu, sama sèmi busa hui kadhi pamadhe kahibꞌi-kalèbho. Èèna na, rèngu nuni rèti miu asa era parisa lii langu agama. Aa dhèu hake paparu miu ètu dꞌara èmu sabajꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pe rèngu ère rèti miu asa madha gubernur dènge dhèu aae, lula miu madhutu Jaꞌa. Te ngaa miu hudꞌi pake lodꞌo sèra, ho peka-padhai dènge ra Lii Lolo Beꞌa nèti Jaꞌa. Dènge jꞌara neꞌe, dhèu dhu tadhe boe Ama Lamatua tadèngi kahèi kolongara Jaꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Te ngaa ladhe rèngu nuni rèti miu sèmi èèna, mage miu madhaꞌu, peka na, ‘Èèna na, jaꞌa peka tasamia?’ Do, ‘Jaꞌa neo dhaa peka sèmi ngaa?’ Baku jꞌajꞌi mi ngangee, te ladhe dꞌai lodꞌo na, Ama mi ètu sorga ka dhu peka dènge miu, nèti jꞌara mia ka dhu miu hudꞌi peka-padhai. ");
INSERT INTO nfa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Lodꞌo èèna, ngaa dhu miu padhai, mai boe nèti dꞌara miu unu mi, te Roh Lamatua dhu Mola-Mèci èèna ka dhu ajꞌa-nori ètu dꞌara miu, sèna ka miu padhai sèmi ngaa sa. ");
INSERT INTO nfa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Sanèdꞌe, te bèli-camèdꞌa ètu dꞌara èmu cue, ladhe abhu ca dhèu parcaya Jaꞌa, èèna na aꞌari nèngu mesa na, ka dhu tenge jꞌara ho pamadhe ne. Aa ladhe ana ka dhu parcaya, èèna na ama na ka dhu pamadhe ne. Ladhe ina-ama ka dhu parcaya, bèli-camèdꞌa ana-ana ra ka dhu pamadhe si. ");
INSERT INTO nfa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sanèdꞌe! Te bèli-camèdꞌa dhèu aaꞌi-aaꞌi tèka dꞌara dènge miu, lula miu parcaya Jaꞌa ne. Te ngaa dhèu dhu taha taruu, èèna na Ama Lamatua hia ne mamuri. ");
INSERT INTO nfa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ladhe dhèu pajꞌèra miu ètu dꞌara kota cue, rai lami asa kota leo! Lèke kèna! Jaꞌa ne Dhèu Rai-haha Tareꞌa-reꞌa. Bèli-camèdꞌa ropa miu palème aaꞌi mèka kota-kota ètu Israꞌel, te ngaa Jaꞌa dhu lèpa hari mai le èèna. ");
INSERT INTO nfa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Biasa dhèu pakabꞌua ca dhèu mese risi nèti ana sakola na sèra. Aa dhèu pakabꞌua ca dhèu lamatua risi nèti ènu na sèra. ");
INSERT INTO nfa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ladhe ana sakola mèu sama sèmi mese na, nèngu pangee na dꞌai le. Aa ladhe ènu dꞌèlu-mèu sama sèmi lamatua na, nèngu ngee na dꞌai le. De sanèdꞌe paie! Ladhe dhèu paroa lamatua èmu, peka na, ‘Èu ne, Baalsebul, dhèu aae nidhu!’ tatu isi èmu na abhu kolongara dhu karehe risi hari.” ");
INSERT INTO nfa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“De miu baku madhaꞌu dènge dhèu dhu labꞌa miu. Te, ngaa dhu dhèu tao pahuni, bèli-camèdꞌa dhèu aaꞌi-aaꞌi ladhe rèdhi. ");
INSERT INTO nfa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngaa dhu Jaꞌa ajꞌa-nori le miu mesa mi, miu hudꞌi lami lole ku mi dhèu aaꞌi-aaꞌi. Aa ngaa dhu Jaꞌa paholo le dènge miu, miu se hudꞌi lami peka ku palème era. ");
INSERT INTO nfa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Baku madhaꞌu dènge dhèu rai-haha, te rèngu bisa dhoka pamadhe ngiꞌu aae dhèu di, te ngaa bisa boe paꞌele iie samanga. Nèti èèna ka, miu hudꞌi madhaꞌu ku dènge Ama Lamatua, te dhoka Nèngu di dhu dènge koasa ho pamaso ngiꞌu aae dhèu dènge samanga kateme, asa dꞌara dhasi ai dhu heo na loe boe ciki sa. ");
INSERT INTO nfa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","De paꞌèra dꞌara miu. Dhèu pahie ana mangungu ètu dꞌara pasa dènge kabꞌua ciki ooꞌe di. Te ngaa ciꞌu sa bisa boe madhe, ladhe Ama mi ètu sorga noꞌo mèka. ");
INSERT INTO nfa_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ama miu ètu sorga dhu loe boe ladhe-leru miu, toke jꞌara-jꞌara dhu ana iiki-iiki. Dꞌai rèu kètu ètu kabꞌa kètu miu, Na ige nare aaꞌi hèi. ");
INSERT INTO nfa_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","De baku madhaꞌu! Lula Ama Lamatua pakabꞌua miu risi nèti ana mangungu aaꞌi-aaꞌi ra.” ");
INSERT INTO nfa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hèia Yesus tuhu hari lii padhai Na, peka na, “Dhèu dhu bani mangaku Jaꞌa ètu madha dhèu ae ètu rai-haha ne, pe Jaꞌa kahèi mangaku nèngu ètu katanga madha Ama Ku ètu sorga, peka na, ‘Nèngu ne dhèu Jaꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Te ngaa dhèu dhu pasili Jaꞌa ètu madha dhèu ae, peka na nèngu tadhe boe Jaꞌa, bèli-camèdꞌa Jaꞌa peka dènge Ama Ku ètu sorga kahèi, na, ‘Jaꞌa tadhe boe dhèu neꞌe.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mage mi pangee na, Jaꞌa ne mai kèti dame asa rai-haha ne. Te mamai Jaꞌa ne, sèna ka dhèu rai-haha ne èci labꞌa èci. ");
INSERT INTO nfa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Jaꞌa mai asa rai-haha ne, madhutu ngaa dhu dhèu rèti lii padhai Ama Lamatua peka tèke èèna, ‘Èèna na, ana mone labꞌa ama na, ana bhèni labꞌa ina na, aa bhèni dhèu èmu ana na, labꞌa ina nèti dhèu èmu na, ");
INSERT INTO nfa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","te isi èmu mae-manyèla, lula èci labꞌa èci.’ ");
INSERT INTO nfa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","De dhèu dhu neo madhutu Jaꞌa tareꞌa-reꞌa, nèngu hudꞌi sue ku Jaꞌa, risi nèti aaꞌi-aaꞌi, risi nèti ina-ama na, aa risi nèti ana niki na. Ladhe aadꞌo, na, nèngu nia boe jꞌajꞌi dhèu unu Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Te dhèu dhu neo madhutu Jaꞌa, te ngaa dꞌèi boe pasae jꞌajꞌèra, nèngu nia boe jꞌajꞌi dhèu unu Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dhèu dhu sadia madhe lula na madhutu Jaꞌa, bèli-camèdꞌa nèngu abhu mamuri taruu dènge Ama Lamatua. Te ngaa dhèu dhu dhoka neo mamuri hia ngiꞌu nèngu unu na, èèna na, mamuri na ele iia dꞌara!” ");
INSERT INTO nfa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Dhèu dhu sèmi nare miu dènge beꞌa, nèngu sèmi nare Jaꞌa kahèi. Aa dhèu dhu sèmi nare Jaꞌa, nèngu kahèi sèmi nare Ama Lamatua dhu pua Jaꞌa mai. ");
INSERT INTO nfa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dhèu dhu sèmi nare dhèu nèti lii padhai Ama Lamatua, lula na padhue-padhai Lii Holo-Nori Ama Lamatua, pe Lamatua bꞌala nèngu sama sèmi Na bꞌala mi ca dhèu nèti lii padhai Nèngu. Aa dhèu dhu sèmi nare ca dhèu dꞌara mola, lula dhèu èèna madhutu tareꞌa-reꞌa dadꞌèi Ama Lamatua, pe Lamatua bꞌala nèngu sama sèmi Na bꞌala mi ca dhèu dꞌara mola. ");
INSERT INTO nfa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dhèu dhu sèmi nare ca dhèu dhu haha dꞌai seli, lula nèngu madhutu Jaꞌa, tatu Ama Lamatua bꞌala ne. Masi ka dhèu hia èi hua ca galaa di, tatu Ama Lamatua bhèlu boe ne.” ");
INSERT INTO nfa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ropa Yesus hia nare lii moa mi canguru dua ana madhutu Na, hèia Na laꞌe kako palème rae-rae ètu rai èèna, sèna ka ajꞌa dhèu ètu sèra. Aa Na peka-padhai Lii Lolo Beꞌa Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lodꞌo èèna, Yohanis ètu dꞌara bèdho. Ropa na tadèngi jꞌara aaꞌi-aaꞌi dhu Yesus tao, hèia na pua ana madhutu na ho lasi karèi Yesus, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ama Lamatua dhu pajaji tèke le karèi nèti uru ka, na, Nèngu neo pua Kristus mai, sèna ka pala mamuri mi èdhi dhèu Yahudi. Ama ne, Kristus, do? Do, èdhi hudꞌi mate hari ku dhèu leo?” Ka lasi karèi Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ropa tadèngi nare, hèia Yesus dhaa, aku Nèngu na, “Miu se tadèngi le, aa mèdhi unu mi dènge madha. De lèpa ho lami peka dènge Yohanis, aaꞌi-aaꞌi dhu jꞌajꞌi, nuka sèmi ngaa dhu dhèu nèti lii padhai Ama Lamatua, Yesaya, suri tèke le, peka na: ");
INSERT INTO nfa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dhèu bèdhu, ladhe rèdhi. Dhèu karuku, kèdꞌi kako. Dhèu pèdꞌa kusta, kaꞌuri ra milu hari. Dhèu katele-katipa, bisa tadèngi. Dhèu madhe, mamuri hari. Dhèu unu aadꞌo, nanene Lii Lolo Beꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","De sèmi neꞌe: lami peka dènge Yohanis, bèli-camèdꞌa nèngu abhu aꞌoto, ladhe na parcaya Jaꞌa taruu. Nèti èèna ka, Ama Lamatua hia mèngi-nale mi dhèu dhu parcaya Jaꞌa paꞌèra-èra!” ");
INSERT INTO nfa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ropa ana madhutu Yohanis se lèpa, hèia Yesus peka dènge dhèu ae se, lula-nèti Yohanis ne, aku Nèngu na, “Lodꞌo miu neo paraga dènge Yohanis ètu dꞌara padꞌa sodꞌa, miu pangee, na, neo paraga dènge dhèu dhu sèmi ngaa sa? Tatu boe, miu paraga dènge dhèu dhu roe aala-aala, nuka sèmi kalai èèu dhu bhabheu madhutu ngèlu di! ");
INSERT INTO nfa_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aa tatu boe miu mèdhi dhèu dhu pake mèdha-papake dhu kabꞌua aae, te dhèu sèmi èèna era pea na dhodhoka ètu dꞌara èmu dhèu aae di! ");
INSERT INTO nfa_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","De lami ladhe dhèu sèmi ngaa sa ètu nèi? Mi pangee na, miu lami tenge dhèu nèti lii padhai Ama Lamatua! Tareꞌa! Te nèngu ne, ca dhèu nèti lii padhai Lamatua dhu kapai risi. ");
INSERT INTO nfa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Te ètu dꞌara sasuri Ama Lamatua dhu Mola-Mèci èèna, dhu suri tèke le lula-nèti Yohanis ne, peka na, ‘Nanene! Jaꞌa pua dhèu Jaꞌa, sèna ka bhoke jꞌara hia Èu.’ ");
INSERT INTO nfa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nanene paie! Ètu rai-haha ne, abhu boe ca dhèu sa dhu kapai risi nèti Yohanis ne. Te ngaa nèti dhèu rai-haha aaꞌi-aaꞌi dhu mangaku Ama Lamatua sama sèmi Dhèu Aae, dhèu dhu haha dꞌai seli èèna ka, nèngu dhu kapai risi nèti Yohanis. ");
INSERT INTO nfa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Karèi nèti Yohanis pakako sasabꞌa na, dꞌai sange neꞌe ne, abhu dhèu ae-ae dhu jꞌajꞌi le dhèu unu Ama Lamatua. Te ngaa abhu dhèu leo dhu pangee sala, peka na rèngu hudꞌi pamusu ku, sèna ka laka-seti dhèu ho jꞌajꞌi dhèu unu Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Toke dꞌai lodꞌo mamai Yohanis tuka sarani, èdhi dhèu Yahudi dhu tema madhutu atora Musa, dènge atora dhèu rèti lii padhai Ama Lamatua leo sèra. ");
INSERT INTO nfa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","De parcaya la Jaꞌa! Yohanis ne, nuka Elia, dhu dhèu rèti lii padhai Ama Lamatua, peka mema le lula-nèti mamai na. ");
INSERT INTO nfa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","De dhu neo meꞌa mèu, hudꞌi nanene ku paie-iie! ");
INSERT INTO nfa_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jaꞌa neo hia lii pakasame, sèna ka miu meꞌa, rupa sèmi mia ka dhèu taa limuri ne. Te rèngu se cakaraa dènge ana-ana dhu madhèdi ètu dꞌara pasa. Rèngu dhu paꞌoo-parodha dènge angalai ra, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Jiꞌi aaꞌi-aaꞌi mi tiu sakino dènge karejꞌe-karae, te ngaa miu roge-ledho boe. Hèia jiꞌi sodꞌa lii beke dhèu madhe, te ngaa miu tangi boe.’ ");
INSERT INTO nfa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Miu se sama sèmi ana iiki dhu reꞌa boe roca. Lodꞌo Yohanis mai, nèngu dꞌèi puasa, aa ninu boe èi anggor. Te ngaa dhèu peka na, ‘Nèngu, nidhu tao!’ ");
INSERT INTO nfa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Te ngaa Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, mai le. Jaꞌa puasa boe, aa kinu èi anggor. Te ngaa dhèu peka na, ‘Nèngu èèna, dhèu gagoo-gagehu! Dhèu tema mahu bia! Laꞌe paꞌangalai dènge dhèu roro bea! Paꞌèci dènge dhèu dhu laku-laku boe. Nèngu dhu neꞌa boe makae!’ Te ngaa mi patadhe lii padhai Jaꞌa ne! Mamèu Ama Lamatua èèna, cèu ètu dꞌara mamuri dhèu unu Na.” ");
INSERT INTO nfa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Èle èèna ka, Lamatua Yesus pasanèdꞌe dhèu-dhèu dhu pea ètu pèri-pèri rae. Na tao le tadha-tadha malaa ae risi ètu nèi, te ngaa roꞌo boe ae eele nèti sasala ra, ho madhutu jꞌara mamuri Ama Lamatua dhu mola. ");
INSERT INTO nfa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus jèke si, peka na, “Heh! Miu dhèu Korasin, aa miu dhèu Betsaida! Mate unu miu! Bèli-camèdꞌa pasae mere mamadhe-mamopo! Jaꞌa tao le rupa-rupa tadha malaa ètu katanga madha miu, te ngaa miu moꞌo boe parcaya Ama Lamatua. Masi ka miu dhèu Yahudi dhu peka na, miu tadhe Lamatua, te ngaa ladhe sèmi tadha malaa dhu Jaꞌa tao seꞌe ètu kota Tirus dènge kota Sidon, tatu nèbhu nare sange neꞌe, dhèu-dhèu ètu sèra èle le hoꞌa, aa tèke eele le sasala-sasigo ra ho madhutu Ama Lamatua. Aa tatu ra pake le bèla mèdhi, dènge tao ahu mi kètu ho jꞌajꞌi mi tadha, na, rèngu manyasa nèti sasala ra. Masi ka dhèu Tirus dènge dhèu Sidon sèra dhèu Yahudi boe, dhu mangaku na, tadhe Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jaꞌa monya boe! Bèli-camèdꞌa mèdhi unu mi! Dꞌai lodꞌo dhu Ama Lamatua pamaꞌète lii langu dhèu aaꞌi-aaꞌi ra, hahuku dhèu Tirus dènge dhèu Sidon samaa risi nèti hahuku miu. ");
INSERT INTO nfa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Miu dhèu Kapernaum! Mage-mage, ee! Mage mi pangee, na, Ama Lamatua pacaꞌe miu lami asa sorga. Aadꞌo! Èèna na Lamatua pèci mi asa dꞌara naraka! Ladhe sèmi tadha-tadha malaa dhu Jaꞌa tao ètu rae miu dhu jꞌajꞌi uuru le ètu kota Sodom, tatu Ama Lamatua parluu boe labhu pakèpu kota èèna. Te ladhe dhèu Sodom rèdhi tadha malaa se, tatu ra rai eele le nèti bhabhelu-katubꞌa ra. ");
INSERT INTO nfa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tareꞌa! Pe mèdhi unu mi! Ladhe dꞌai ka lodꞌo Ama Lamatua pamaꞌète lii langu dhèu aaꞌi-aaꞌi, hahuku dhèu Sodom samaa risi nèti hahuku miu se!” ");
INSERT INTO nfa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ropa padhai lii nare, hèia Yesus sabajꞌa, peka na, “Ama! Ama dhu jꞌajꞌi Lamatua ètu dedha-liru dènge rai-haha. Jaꞌa manèngi makasi ae-ae, lula Ama pahuni pamèno-mèno jꞌara-jꞌara dhu Ama hia huku mi dhèu-dhèu dhu pangee na, rèngu dꞌèlu-mèu, aa dhu padedha iisi ra. Te ngaa Ama bhoke patalele jꞌara seꞌe aaꞌi-aaꞌi mi dhèu haha dènge dhu pahaha iisi ra. ");
INSERT INTO nfa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tareꞌa, Ama! Te sèmi èèna ka, dhu pakarejꞌe dꞌara Ama!” ");
INSERT INTO nfa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ropa sabajꞌa nare, hèia Yesus peka dènge dhèu-dhèu ètu sèra, na, “Nanene paie-iie! Ama Ku ètu sorga pangèdꞌu le koasa aaꞌi-aaꞌi mi Jaꞌa ne. Dhu tadhe mèu Jaꞌa, dhoka Ama ku di. Aa dhu tadhe mèu Ama, dhoka Ana Na, nuka Jaꞌa ne. Aa Jaꞌa hagꞌe kore dhèu leo, sèna ka peka dènge ra, ho rèngu tadhe mèu Ne kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Miu aaꞌi-aaꞌi mi dhu roe lula sabꞌa bia, mai madhutu Jaꞌa! Aa miu aaꞌi-aaꞌi mi dhu pasae bia, mai la asa Jaꞌa! ");
INSERT INTO nfa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ladhe miu sèmi mere aꞌajꞌa Jaꞌa, ho kako palere-lere dènge Jaꞌa, na, èdhi ca ropa dènge sapi dua ngiꞌu dhu nuni kataka pare rai èci. Te Jaꞌa ne, dꞌara hua iia, aa lii mako. Ladhe miu madhutu Jaꞌa, miu jꞌajꞌi èra hari. ");
INSERT INTO nfa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Lula aꞌajꞌa Jaꞌa, carui boe. Aa paredha Jaꞌa, bia boe kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ca lodꞌo, lèke dènge ae sasabꞌa dhèu Yahudi, Yesus dènge ana-ana madhutu Na dhu kako re karasa oka dhèu. Ana madhutu Na manganga, hèia ra gꞌètu are-gandum ka raꞌa noo-noo. ");
INSERT INTO nfa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ètu èèna, abhu pèri-pèri dhèu nèti partei agama Parisi dhu madhutu paꞌèra adꞌa dhèu Yahudi ra. Ropa ladhe rèdhi ana madhutu Yesus se tao sèmi èèna, hèia ra kai Ne, peka na, “Ana madhutu Mu, gꞌètu gandum lèke dènge lodꞌo ae sasabꞌa-laꞌa! Rèngu baku tao sèmi neꞌe! Te tatao ne sisu atora èdhi.” ");
INSERT INTO nfa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Te ngaa Yesus bꞌala, aku Nèngu na, “Tasamia, ee? Miu teko bhèlu lii lolo Daud, si? Daud dènge ana-ana madhutu na dhu manganga titu kèna. Hèia na maso asa dꞌara Paleo Manèngi-Mangajꞌi Ama Lamatua, ka nare roti dhu ama agama hia le mi Lamatua, ka rèngu raꞌa. Te ngaa dhu bisa raꞌe roti se dhodhoka ama agama sèra. Dhèu leo bisa boe. Èle ka Daud si raꞌa, te ngaa ca dhèu sa pasala boe si. Miu nuka sèmi dhèu dhu baca mèdhi boe sasuri Lii Holo-Nori Ama Lamatua! ");
INSERT INTO nfa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te ètu dꞌara sasuri èèna, suri kahèi nèti sasabꞌa ama agama Yahudi sèra, ètu dꞌara èmu sabajꞌa, lèke dènge lodꞌo ae sasabꞌa. Te ngaa rèngu sala boe ngaa-ngaa. ");
INSERT INTO nfa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nanene! Uru èèna, èmu sabajꞌa ka dhu kabꞌua, te ngaa limuri ne abhu dhu kabꞌua risi, nuka Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, Na peka na, ‘Dadꞌèi Jaꞌa sèmi neꞌe: dhèu Jaꞌa sèra hudꞌi padꞌelo ku rasa kasia èci dènge èci. Ladhe ra tao boe madhutu jꞌara ne, na, badha korban dhu rèngu rèti hia Jaꞌa, dènge boe kabꞌua.’ De ladhe miu meꞌa mèu sasoa nèti lii padhai Lamatua ne, tatu miu pasala boe ana madhutu Jaꞌa se. Te ra tao boe sala ngaa-ngaa! ");
INSERT INTO nfa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Te Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Jaꞌa ka dhu dènge hak ho pamaꞌète, peka na, dhèu bisa sabꞌa ngaa, lèke dènge lodꞌo ae sasabꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Èle ka Yesus tèke eele era èèna, laꞌe asa dꞌara èmu sabajꞌa ra. ");
INSERT INTO nfa_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ètu neꞌe, abhu mone ca dhèu dhu kacui-aai madhe cabèka. Dhèu Parisi sèra dhu tenge-tenge jꞌara ho pasala Yesus, ladhe sèmi Na puri-paꞌèle dhèu dhu kacui-aai madhe cabèka ne, lèke dènge lodꞌo ae sasabꞌa. Hèia ra karèi Ne, peka na, “Madhutu atora agama èdhi, dhèu bisa puri-paꞌèle dhèu, lèke dènge lodꞌo ae sasabꞌa-laꞌa, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hèia Yesus dhaa, aku Nèngu na, “Ladhe kahibꞌi-kalèbho ciꞌu manahu asa dꞌara roꞌa, lèke dènge lodꞌo ae sasabꞌa, dhèu unu na mai name nare, sina ma? ");
INSERT INTO nfa_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","De Ama Lamatua sue dhèu rai-haha, risi nèti dhèu unu kahibꞌi-kalèbho deo na. Nèti èèna ka, dhèu bisa tao jꞌara dhu beꞌa lèke dènge lodꞌo ae sasabꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ka Na lii dènge dhèu dhu ai madhe cabèka na, “Jꞌole kacui-aai èu mai!” Hèia, na jꞌole kacui-aai dhu madhe èèna, kacaꞌa la èle dènge ka, sama dènge kacui-aai dhu iia èèna. ");
INSERT INTO nfa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ropa dhèu Parisi se rèdhi sèmi èèna, hèia ra nasa titu kèna. Èle ka ra kalua tèke eele èmu sabajꞌa ne, hèia lasi pareꞌa, aku rèngu na, “Èdhi hudꞌi tenge ku jꞌara, sèna ka pamadhe Ne!” ");
INSERT INTO nfa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Te ngaa Yesus dhu neꞌa ngangee rèngu dhu karehe ne, nèti èèna ka laꞌe asa era leo. Dhèu ae madhutu Ne, hèia Na puri-paꞌèle dhèu dhu pèdꞌa aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te ngaa Na kai si, peka na, “Mage lami palolo kahèi dènge dhèu leo lula-nèti Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nèngu tao sèmi èèna, madhutu sèmi lii padhai Ama Lamatua dhu peka le mi dhèu nèti lii padhai Na, ngara na Yesaya, dhu suri tèke, na, ");
INSERT INTO nfa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ladhe ku laa! Nèngu ne, Dhèu pajuu-paleha Jaꞌa, dhu Jaꞌa hagꞌe kore le. Jaꞌa sue Ne, aa dꞌara Jaꞌa karejꞌe taruu dènge Ne. Èèna na, Jaꞌa pangèdꞌu Ne Roh Jaꞌa, ho laꞌe ajꞌa-nori dhèu nèti suku aaꞌi-aaꞌi lula-nèti jꞌara mamuri Jaꞌa dhu mola. ");
INSERT INTO nfa_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nèngu ne, neꞌa boe tèbꞌa kakara. Nèngu ne, neꞌa boe padedha iisi. ");
INSERT INTO nfa_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Dꞌara Na hua iia. Dhu neꞌa boe pajꞌèra dhèu. Ajꞌu dhu oe padhe, Na lèku eele boe. Labhu dhu saruru, Na tiu pamadhe boe. Na loe boe ajꞌa-nori dhèu, toke dhèu aaꞌi-aaꞌi tao madhutu jꞌara mamuri dhu mola nèti Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dhèu nèti suku aaꞌi-aaꞌi èèna na parcaya Ne, lula reꞌa na, Nèngu ne, cee.” ");
INSERT INTO nfa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ca tèka, rèti asa Yesus ca dhèu dhu nidhu tao toke bèdhu aa ele lii. Hèia Yesus paꞌèle ne dènge babège eele nidhu nèti dhèu neꞌe. Ka dhèu ne bisa nèdhi, aa bisa padhai lii. ");
INSERT INTO nfa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dhèu ae se, ropa rèdhi sèmi èèna, hèia ra malaa-maloha. Ra papeka na, “Nèngu neꞌe, ele boe ana-èpu Daud, dhu dhèu rèti lii padhai Ama Lamatua suri tèke karèi nèti uru ka! Nèngu neꞌe, tatu Dhèu dhu èdhi mate tae-tae èèna!” ");
INSERT INTO nfa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Te ngaa ropa dhèu Parisi tadèngi rare, hèia ra roꞌo boe parcaya. Ka ra papeka, na, “Wee! Dhèu ne bisa babège nidhu, lula dhèu aae nidhu Baalsebul ka dhu pangèdꞌu Na koasa.” ");
INSERT INTO nfa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Te ngaa Yesus neꞌa lii padhai dhèu Parisi se. Hèia Na peka dènge dhèu seꞌe, aku Nèngu na, “Lii padhai miu ne, lèke boe! Ladhe ètu dꞌara rai cue, ana kabarai na patao-palaha, tasa mera mia ho rai ne bisa taha! Sèmi èèna kahèi, ladhe dhèu ètu dꞌara kota èci, do dꞌara èmu cue, èci patao dènge èci, tatu ra mae-manyèla, toke laho mae-mae, si! ");
INSERT INTO nfa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","De ladhe nidhu pamusu dènge nidhu, aa palabꞌa èci dènge èci, tatu dhèu aae ra nèdꞌu paredha nèbhu boe! ");
INSERT INTO nfa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sanèdꞌe paie! Dhèu miu reꞌa kahèi babège eele nidhu. Ra pake koasa nèti nidhu, do? Aadꞌo! De miu baku padhai lii ore dhu peka na, Jaꞌa pake koasa nidhu, ho babège eele nidhu. Pe dhèu miu unu mi ka dhu pamaꞌète, peka na, ngaa dhu miu galaa ne, lèke boe jꞌara. ");
INSERT INTO nfa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Te ngaa ladhe Jaꞌa tareꞌa-reꞌa babège eele nidhu pake koasa nèti Roh Ama Lamatua, èèna padꞌelo na, Lamatua èèna tareꞌa-reꞌa Dhèu Aae dhu ètu le katanga madha miu. ");
INSERT INTO nfa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ladhe dhèu neo lasi manaꞌu èmu dhèu èci dhu èra, nèngu hudꞌi èki-karadhe uuru ku dhèu lamatua èmu ne. Heka na manaꞌu nèti mèdha-panyau na sèra. ");
INSERT INTO nfa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Sanèdꞌe, ee! Te dhèu dhu paꞌèci boe dènge Jaꞌa, nèngu pamusu dènge Jaꞌa. Aa dhèu dhu soru-bara boe Jaꞌa ètu dꞌara sabꞌa-laꞌa, nèngu neꞌa dhoka paꞌiu dhèu di. ");
INSERT INTO nfa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","De nanene paie-iie lii padhai Jaꞌa ne! Ama Lamatua dhu sadia saku eele sasala-sasigo dhèu. Ladhe dhèu padhai lii pakarehe kolongara dhèu leo, Ama Lamatua sadia abho ne era. Te ngaa ladhe abhu dhèu dhu bani padhai pakarehe Roh Ama Lamatua dhu Mola-Mèci, Ama Lamatua saku eele boe sasala na èèna. ");
INSERT INTO nfa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ladhe dhèu pakarehe Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, Ama Lamatua sadia saku eele sasala na. Te ngaa cee ka dhu bani padhai lii pahahe Roh Ama Lamatua, te ngaa Ama Lamatua saku eele boe sasala na, masi ka toke dai mia-mia laꞌe!” ");
INSERT INTO nfa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Hèia Yesus padhai lii taruu dènge dhèu Parisi se, peka na, “Ngee paie-iie! Ajꞌu dhu beꞌa, hia hua dhu beꞌa. Te ngaa ajꞌu dhu karehe, hia hua dhu karehe. Nèti hua na, dhèu bisa tadhe ajꞌu ne, beꞌa do karehe. ");
INSERT INTO nfa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Te ngaa miu se ca ropa dènge mege, dhu neꞌa dhoka kapodꞌe-kabèli di! Miu meꞌa boe padhai lii dhu beꞌa. Lula ngaa dhu tèke ètu dꞌara, èèna ka dhu kalua mai nèti dꞌara hèbꞌa na. ");
INSERT INTO nfa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dhèu beꞌa, tatu lii padhai na beꞌa, lula ètu dꞌara na abhu jꞌara dhu beꞌa. Te ngaa dhèu bhelu, tatu lii padhai na karehe, lula ètu dꞌara na dhu pènu dènge bhabhelu-katubꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lèka la lii Jaꞌa ne! Te bèli-camèdꞌa lodꞌo èle rai-haha, Ama Lamatua parisa lii langu dhèu aaꞌi-aaꞌi. Lodꞌo èèna, dhèu èci-èci ka hudꞌi dhaa lii-lii nèngu dhu dènge boe kolo-kapua. ");
INSERT INTO nfa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","De mage-mage! Te bèli-camèdꞌa èèna, Ama Lamatua dadoo lii-lii miu sèra, aa pamaꞌète peka na, miu lèke huku do, aadꞌo.” ");
INSERT INTO nfa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ropa tadèngi lii padhai Yesus sèmi èèna, hèia pèri-pèri mese agama dènge dhèu Parisi, peka dènge Yesus, aku rèngu na, “Ama Mese! Jiꞌi neo ngèdhi tadha malaa èci, sèna ka jꞌajꞌi mi tadha, peka na, koasa Ama, tareꞌa nèti Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Te ngaa Yesus jèke si, peka na, “Weh! Miu dhèu taa limuri ne, moꞌo boe madhutu Ama Lamatua! Miu se meꞌa dhodhoka adꞌu-ue bhelu-katubꞌa di! Masi ka miu manèngi tadha malaa, te ngaa Jaꞌa tao boe. Lula uru èèna, Lamatua hia le tadha malaa re Yunus, dhèu nèti lii padhai Na. Èèna dꞌai le! ");
INSERT INTO nfa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus pea tèlu mèu-tèlu mèda ètu dꞌara kabake iꞌa aae ciꞌu. Sèmi èèna kahèi dènge Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne. Bèli-camèdꞌa Jaꞌa kahèi ètu dꞌara roꞌa dhèu madhe, tèlu mèu-tèlu mèda. ");
INSERT INTO nfa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ladhe dꞌai lodꞌo èle rai-haha ne, Lamatua jꞌajꞌi hakim. Aa dhèu Niniwe se titu jꞌajꞌi sakasii ho galaa miu, peka na, ‘Miu aaꞌi-aaꞌi se, goa!’ Uru èèna, ropa dhèu Niniwe sèra tadèngi lii padhai Yunus, dhèu nèti lii padhai Ama Lamatua, hèia ra tèke eele sasala ra. Te ngaa miu sèmi boe èèna. Masi ka limuri ne, abhu le Dhèu ètu talora aae miu, dhu kapai risi nèti Yunus, nuka Jaꞌa ne. Te ngaa miu se pusi-pahae boe Jaꞌa ciki sa hèi. ");
INSERT INTO nfa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pe, ètu dꞌara lodꞌo èle rai-haha ne, ladhe Lamatua jꞌajꞌi hakim, bhèni aae Syeba nèti balèu, jꞌajꞌi sakasii kahèi. Na pajꞌujꞌu ai na mi miu, ho na galaa miu aaꞌi-aaꞌi dhu ana loo-limuri ne, peka na, ‘Miu aaꞌi-aaꞌi mi, goa!’ Uru èèna, bhèni aae ne mai nèti rai kajꞌèu ho neo nèdhi unu na mamèu dhèu aae Soleman. Te ngaa limuri ne, abhu ca Dhèu ètu talora aae miu dhu kapai risi nèti dhèu aae Soleman, nuka Jaꞌa ne. Te ngaa miu pusi-pahae boe Jaꞌa ciki sa hèi.” ");
INSERT INTO nfa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ladhe babège eele nidhu nèti ca dhèu, nidhu ne laꞌe pea asa era dhu kaliu, ho jꞌajꞌi mi era ae iisi na. Te ngaa abhu boe era dhu mèci ho na pea kalili. ");
INSERT INTO nfa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hèia na pangee, peka na, ‘Abhu boe era dhu beꞌa sèmi nèi, hua iia jaꞌa lèpa hari asa dhèu dhu uru èèna jaꞌa pea.’ Ka laꞌe hari asa era nèngu uru èèna. Na ladhe na, era ne mèu bia, aa dhu lalau rare pabeꞌa-beꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hèia nidhu ne laꞌe paroa nare angalai na dhèu pidhu dhu bhabhelu ra risi nèti nèngu. Ka lasi pea ètu dꞌara dhèu ne, hèia aaꞌi-aaꞌi ra kakeho ne. De limuri ne, mamuri dhèu ne asa ele iie-iie. Sèmi èèna kahèi lèke mi dhèu bhelu-katubꞌa taa limuri ne.” ");
INSERT INTO nfa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lodꞌo èèna, Yesus padhai lii era dènge dhèu ae. Hèia ina dènge ari Na sèra, mai neo paraga dènge Ne. Rèngu titu ètu liꞌu, ka ra pua dhèu lasi paroa Ne. ");
INSERT INTO nfa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hèia dhèu mai peka dènge Ne, aku rèngu na, “Ama! Ina dènge ari Ama ètu liꞌu nèi. Rèngu neo paraga dènge Ama.” ");
INSERT INTO nfa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ka Yesus peka dènge ra, “Cee ka ina Ku, aa cee ka aꞌari Jaꞌa dhu tareꞌa-reꞌa?” ");
INSERT INTO nfa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hèia Na pajꞌujꞌu asa dhèu-dhèu dhu madhutu Ne, ka Na lii, aku Nèngu na, “Rèngu seꞌe se ka, ina dènge aꞌari Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Te dhèu dhu tao madhutu dadꞌèi Ama Ku ètu sorga, rèngu ka ina Ku aa aꞌari Jaꞌa dhu tareꞌa-reꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lodꞌo èèna kahèi, Yesus kalua nèti èmu èèna, laꞌe madhèdi asa sebhe dano Galilea. ");
INSERT INTO nfa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hèia dhèu ae-ae mai lingu rare Ne. Ka laꞌe madhèdi asa dedha koha cue, dhu panahu ètu era èèna, ho ajꞌa dhèu sèra. Dhèu aaꞌi-aaꞌi ètu dae sèra nanene Ne. ");
INSERT INTO nfa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Hèia Na ajꞌa madha jꞌara ae-ae mi rèngu pake lii pakasame. Na lole, peka na, “Abhu ca dhèu sabꞌa oka-tedhe, dhu cebꞌe hini ètu dꞌara oka na. ");
INSERT INTO nfa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ropa na cebꞌe hini se, abhu dhu lèke ètu jꞌara. Hèia manu-bhui mai, ka tutu raꞌe aaꞌi hini se. ");
INSERT INTO nfa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te ngaa hini cahagꞌe lèke ètu rai dhu dènge hadhu. Hini se muri malai, lula abhu rai ciki di. ");
INSERT INTO nfa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Te ngaa ropa lodꞌo rea, hèia ana aajꞌu se kamale, ka mango eele si. Te amo ra marèma boe ètu dꞌara rai. ");
INSERT INTO nfa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Abhu hini cahagꞌe dhu lèke ètu era jꞌuꞌu padhudhu. Hèia jꞌuꞌu padhudhu se hèlu pamadhe aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Te ngaa abhu hini cahagꞌe lèke ètu rai isi. Hini se muri, ka ra kapai toke hua-hela. Abhu dhu tèlu nguru hari, abhu dhu èna nguru hari, aa abhu dhu dꞌai cangasu hari. ");
INSERT INTO nfa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Cee dhu dènge roꞌa dhilu, na nanene paie-iie!” ");
INSERT INTO nfa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Èle èèna ka, ana madhutu Yesus mai karèi Ne, aku rèngu na, “Nga tao ka Ama ajꞌa dhèu ae pake lii pakasame?” ");
INSERT INTO nfa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hèia Yesus dhaa, aku Nèngu na, “Lula miu se neo meꞌa tareꞌa-reꞌa paredha Ama Lamatua, nèti èèna ka Jaꞌa peka mema sasoa nèti lii pakasame ne. Te ngaa mi dhèu leo, Jaꞌa ajꞌa pake lii pakasame. ");
INSERT INTO nfa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Te dhèu dhu tareꞌa-reꞌa neo reꞌa dadꞌèi Ama Lamatua, pe Lamatua hia ne asa neꞌa ae. Te ngaa dhèu dhu pusi-pahae boe dadꞌèi Lamatua, pe Lamatua tao ne asa tabha goa. ");
INSERT INTO nfa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jaꞌa ajꞌa-nori si pake dhoka lii pakasame di, lula: ‘Rèngu rèdhi le, te ngaa roꞌo boe reꞌa. Rèngu tadèngi le, te ngaa ra pusi-pahae boe.’ ");
INSERT INTO nfa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Rèngu se cakaraa dènge dhèu dhu Yesaya suri mema le. Yesaya èèna, nuka dhèu nèti lii padhai Ama Lamatua, dhu suri, na, ‘Miu èèna na tadèngi, te ngaa miu pakatele dhilu. Miu èèna na ladhe mèdhi, te ngaa moꞌo boe pameꞌa ngaa dhu jꞌajꞌi le. ");
INSERT INTO nfa_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Lula dꞌara dhèu seꞌe adhu sèmi hadhu, ra pakatele dhilu ra, aa ra pabèdhu musi madha ra. De hudꞌi rèngu sène, sèna ka roꞌa dhilu ra katele-katipa, aa soro tèke si, sèna ka musi madha ra bèdhu sèmi èèna. Hudꞌi laa, ho Jaꞌa puri-paꞌèle ia ka si, lula rèngu pusi-pahae boe Jaꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Te ngaa miu se, oto! Lula miu ladhe mèdhi dènge musi madha, aa tadèngi dènge roꞌa dhilu miu unu mi. ");
INSERT INTO nfa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Parcaya la Jaꞌa! Uru èèna, dhèu rèti lii padhai Ama Lamatua, dènge dhèu dhu dꞌara mola, dꞌara ra neo rèdhi ngaa dhu limuri ne miu ladhe mèdhi, te ngaa bisa boe. Dꞌara ra neo kahèi tadèngi ngaa dhu limuri ne miu tadèngi le, te ngaa bisa boe.” ");
INSERT INTO nfa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ropa padhai lii nare, hèia Yesus peka dènge ra, “De mi nanene ka sasoa nèti lii pakasame deo na. ");
INSERT INTO nfa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hini dhu lèke ètu jꞌara, nuka dhèu dhu nanene Lii Holo-Nori nèti Ama Lamatua nèdꞌu paredha, te ngaa nèngu neꞌa iia boe. Hèia dhèu aae nidhu mai parame nare Lii Holo-Nori nèti dꞌara dhèu ne. ");
INSERT INTO nfa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Hini dhu cebꞌe lèke ètu rai dhu pènu dènge hadhu, nuka dhèu dhu nanene Lii Holo-Nori Ama Lamatua, hèia na sèmi nare dènge dꞌara karejꞌe. ");
INSERT INTO nfa_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Te ngaa Lii Holo-Nori ne, amo na marèma boe. Nèti èèna ka, nare boe nèbhu ètu dꞌara dhèu ne. Ropa dhèu leo pajꞌèra ne lula na sèmi nare Lii Holo-Nori ne, ka dhèu ne kèpe paꞌèra heka aꞌajꞌa sèra. ");
INSERT INTO nfa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aa hini dhu lèke ètu talora aae jꞌuꞌu padhudhu, nuka dhèu dhu nanene Lii Holo-Nori. Te ngaa nèngu bhute dènge rupa-rupa jꞌara, ho pakarejꞌe mamuri na. Hèia bhabhute seꞌe ka seti eele Lii Holo-Nori ne nèti dꞌara nèngu, toke dènge heka kabꞌua. ");
INSERT INTO nfa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Te ngaa hini dhu lèke ètu rai isi, nuka dhèu dhu pasa paie dhilu na, sèna ka sèmi nare Lii Holo-Nori, aa tao madhutu dadꞌèi Lamatua. Hèia na tao jꞌara-jꞌara dhu beꞌa, sama sèmi hini dhu muri toke kapai, ka na hua ae-ae. Abhu dhu tèlu nguru hari, abhu kahèi èna nguru hari, aa abhu dhu dꞌai cangasu hari.” ");
INSERT INTO nfa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus lolo hari lii pakasame èci, aku Nèngu na, “Paredha Ama Lamatua ne, nuka sèmi abhu ca dhèu laꞌe cebꞌe hini dhu beꞌa ètu dꞌara oka na. ");
INSERT INTO nfa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dꞌara mèda èèna, ropa dhèu aaꞌi-aaꞌi bhèjꞌi luu, hèia dhèu bhelu mai, ka na cebꞌe lamusi jꞌuꞌu ètu dꞌara oka ne. ");
INSERT INTO nfa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ropa hini ètu dꞌara oka ne dꞌai hua-hela, hèia dhèu sabꞌa se, ladhe rèdhi jꞌuꞌu dhu muri palere-lere dènge hini se. ");
INSERT INTO nfa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ka lasi peka dènge lamatua oka ne, aku rèngu na, ‘Ama! Ca hari ni jiꞌi sèle hini dhu beꞌa ètu dꞌara oka ama, si? Nga tao ka muri mai pabꞌali dènge jꞌuꞌu ae-ae?’ ");
INSERT INTO nfa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lamatua oka ne dhaa, peka na, ‘Èèna tatao nèti dhèu bhelu.’ Hèia dhèu sabꞌa se peka, aku rèngu na, ‘Ama, jiꞌi laꞌa koꞌo eele jꞌuꞌu sèi, do?’ ");
INSERT INTO nfa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te ngaa na bꞌala, peka na, ‘Hudꞌi laa, te ladhe miu koꞌo eele jꞌuꞌu se, ana ngangaꞌa èdhi se lèke bete kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hudꞌi rèngu sène ra muri palere-lere toke hèru puu-gꞌètu. Pe dꞌai lodꞌo na, jaꞌa peka dènge dhèu sabꞌa se, na, “Miu pakaboko uru ku jꞌuꞌu sèra. Hèia èki si ca èki-ca èki ho tunu eele si. Èle ku, heka ta pakaboko isi oka kèna, sèna ka pamaso asa dꞌara babesi.”’ ” ");
INSERT INTO nfa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Èle, ka Yesus peka hari, na, “Jaꞌa pake hari lii pakasame èci, sèna ka miu meꞌa tasamia Ama Lamatua jꞌajꞌi Dhèu Aae mi dhèu ae-ae. Dhèu unu Na sèra, mulai nuka sèmi lamusi dhu ana iiki titu kèna, dhu dhèu sèle ètu dꞌara oka na. ");
INSERT INTO nfa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masi ka lamusi ne ana iiki dꞌai seli, te ngaa ladhe na muri mai, jꞌajꞌi ajꞌu dhu kapai aae ètu dꞌara oka ne. Toke manu-bhui tao rèdꞌa ètu dadana-dadana na.” ");
INSERT INTO nfa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus peka hari lii pakasame èci, aku Nèngu na, “Dhèu-dhèu unu Ama Lamatua, èci èèna ka dènge ragi dhu bhèni èci nare, pabꞌali dènge tarigu ca sak. Hèia roti ne caꞌe toke kapai, lula ragi dhu ciki ooꞌe deo na.” ");
INSERT INTO nfa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus ajꞌa dhèu ae dènge lii lolo rupa-rupa. Lii padhai Na, aaꞌi-aaꞌi se, dhodhoka pake lii pakasame di. ");
INSERT INTO nfa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na ajꞌa sèmi èèna, sèna ka madhutu sèmi lii nèti dhèu rèti lii padhai Ama Lamatua dhu suri tèke, peka na, “Pe Jaꞌa ajꞌa-nori pake lii pakasame. Pe Jaꞌa lole jꞌara-jꞌara dhu dhèu tadèngi rèdhi mèka, karèi nèti Lamatua pajꞌajꞌi rai-haha toke dꞌai sange neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Èle ka, Yesus lèpa èmu tèke eele dhèu ae sèra. Hèia ana madhutu Na sèra mai manèngi, na, “Ama! Peka ku dènge jiꞌi sasoa nèti lii pakasame jꞌuꞌu deo sa!” ");
INSERT INTO nfa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ka Yesus dhaa, na, “Dhèu dhu cebꞌe hini dhu beꞌa èèna, nuka Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aa oka èèna, nuka rai-haha ne. Hini dhu beꞌa èèna, nuka dhèu-dhèu dhu jꞌajꞌi le ana-èpu Ama Lamatua. Aa jꞌuꞌu sèra, nuka ana pajuu nèti dhèu aae nidhu. ");
INSERT INTO nfa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aa dhèu bhelu dhu mai cebꞌe lamusi jꞌuꞌu, nuka dhèu aae nidhu. Aa lodꞌo puu-gꞌètu èèna, nuka dꞌai èle rai-haha ne. Dhèu sabꞌa dhu pakaboko isi oka se, nuka ana pajuu Ama Lamatua nèti sorga. ");
INSERT INTO nfa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ropa dꞌai èle rai-haha ne, ra oru rare jꞌuꞌu se ho tunu pakèpu si. ");
INSERT INTO nfa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, bèli-camèdꞌa pua ana pajuu nèti sorga mai. Rèngu èèna na pakaboko dhèu-dhèu dhu pusi-pahae boe madhutu paredha Ama Lamatua. Aa rèngu oru rare kahèi dhèu-dhèu dhu dadugu-rariu dhèu leo, sèna ka baku madhutu paredha Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Èèna na ra core dhèu bhelu-katubꞌa aaꞌi-aaꞌi se asa dꞌara ai naraka, nuka sèmi jꞌuꞌu dhu ai naꞌe pakèpu si. Ètu nèi, dhèu se rasa jꞌèra titu kèna, aa tangi dꞌara maꞌète mae-mae loe boe ciki sa. ");
INSERT INTO nfa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Te ngaa dhèu dhu mamuri mola madhutu dadꞌèi Ama Lamatua, rèngu pea taruu dènge Ama Dhèu Aae ra ètu sorga. Ètu nèi, dhèu se haꞌa-haꞌa, hèti-hèti, nuka sèmi madha lodꞌo. De dhèu dhu neo tadhe mèu Jaꞌa, pasa dhilu paie-iie!” ");
INSERT INTO nfa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus tabha hari lii pakasame èci, aku Nèngu na, “Dhèu dhu neo tadhe mèu Ama Lamatua nèdꞌu paredha, rèngu nuka sèmi dhèu dhu neo abhu mèdha kabꞌua aae, dhu dhèu huni tèke ètu dꞌara rai cakasibꞌi. Ka dhèu ne laꞌe kèi, hèia na abhu mèdha ne, nèti èèna ka na karejꞌe-karae. Èle èèna ka, na dhènu hari mèdha deo na. Hèia na lèpa hari lai-lai, laꞌe pahia aaꞌi mèdha-panyau na. Ka laꞌe hèli nare rai ne, sèna ka na unu mèdha dhu kabꞌua aae deo na.” ");
INSERT INTO nfa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus tuhu hari lii pakasame, peka na, “Dhèu dhu neo tadhe mèu Ama Lamatua nèdꞌu paredha, èci èèna kahèi dènge dhèu dꞌaga ca dhèu dhu dꞌara na neo abhu mutiara dhu kabꞌua aae titu kèna. Èle ka, na patangi-tenge mutiara ho neo hèli. ");
INSERT INTO nfa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ropa na rage mutiara cue dhu beꞌa titu kèna, hèia na lèpa lai-lai, sèna ka pahia aaꞌi mèdha-panyau na. Hèia laꞌe tihe mutiara ne, sèna ka jꞌajꞌi mi unu na.” ");
INSERT INTO nfa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus peka hari, na, “Paredha Ama Lamatua, nuka sèmi pèku èci dhu dhèu sabꞌa dhasi lasi lolo ètu dꞌara dano. Ka pèku ne lèke rupa-rupa iꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ropa pèku ne pènu dènge iꞌa, dhèu pèku se dedꞌe rèti asa dedha nebhe. Hèia ra madhèdi kabhili iꞌa nèti pèku ne. Iꞌa dhu beꞌa, ra tao asa dꞌara kalera. Te ngaa iꞌa dhu karehe, ra core eele. ");
INSERT INTO nfa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Èci èèna ka, ladhe dꞌai lodꞌo èle rai-haha ne. Èèna na ana pajuu Lamatua mai nèti sorga, sèna ka hagꞌe eele dhèu dhu dꞌara mola nèti dhèu bhelu-katubꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dhèu dhu bhelu-katubꞌa aaꞌi-aaꞌi ra, core si asa dꞌara ai naraka. Ètu nèi, rèngu heka reꞌa jꞌajꞌèra, aa loe boe tangi roma iisi.” ");
INSERT INTO nfa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ropa padhai lii nare, hèia Yesus karèi ra, aku Nèngu na, “Miu meꞌa aaꞌi ngaa dhu Jaꞌa peka-padhai se, do?” Ra dhaa peka na, “Ngeꞌa, Ama!” ");
INSERT INTO nfa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hèia Yesus bꞌala, peka na, “Beꞌa! Te mese agama aaꞌi-aaꞌi dhu reꞌa tareꞌa-reꞌa Lii Holo-Nori Lamatua dhu suri tèke karèi nèti uru èèna, ka ra kèpe paꞌèra aꞌajꞌa Jaꞌa, na, rèngu ca ropa dènge lamatua èmu dhu dꞌèi bhoke gudꞌa na, ho padꞌelo mèdha-panyau na dhu dhui, dènge mèdha-panyau na dhu hiu.” ");
INSERT INTO nfa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ropa Yesus ajꞌa nare dhèu ae sèra, pake lii pakasame, hèia laꞌe, tèke eele era èèna, ");
INSERT INTO nfa_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ho lèpa asa rae Na. Dꞌai nèi, maso laꞌe asa dꞌara èmu sabajꞌa, ho ajꞌa-nori dhèu. Dhèu aaꞌi-aaꞌi dhu tadèngi lii padhai Na malaa-maloha. Ka ra papeka, aku rèngu na, “Ira ii! Dhèu ne dꞌèlu-mèu titu kèna, nga! Na sakola ètu mia ne? Tasamia ka Na bisa tao tadha malaa seꞌe? ");
INSERT INTO nfa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nèngu ne dhoka Ana nèti ca dhèu tuka ajꞌu di. Èdhi patadha beꞌa dènge ina Na Maria; aa dènge ari Na aaꞌi-aaꞌi, nuka Yakobis, Yusuf, Yudas dènge Simon. ");
INSERT INTO nfa_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Èdhi tadhe ana hèni Na kahèi, te èdhi pea ètu dꞌara rae cue! De Na abhu mamèu Na nèti mia? Aa Na abhu koasa kapai ne nèti cee hari?” ");
INSERT INTO nfa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nèti èèna ka, dhèu se kacèki, toke ra roꞌo heka nanene lii padhai Na. Te ngaa Yesus peka dènge ra, aku Nèngu na, “Mema tareꞌa! Dhèu dꞌèi risi pakabꞌua dhèu nèti lii padhai Ama Lamatua dhu mai nèti era leo, te ngaa ra pakabꞌua boe dhèu nèti lii padhai Ama Lamatua dhu mai nèti rae rèngu unu ra.” ");
INSERT INTO nfa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Lula dꞌara ra adhu, toke ra parcaya boe Yesus, nèti èèna ka Na tao tadha malaa ae boe ètu dꞌara rae Na. ");
INSERT INTO nfa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tèu èèna, dhèu aae Herodes nèdꞌu paredha ètu propensi Galilea. Nèngu ne dhu tadèngi le kahèi rupa-rupa jꞌara lula-nèti Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na peka dènge dhèu sabꞌa na sèra, aku nèngu na, “Ele boe Yesus ne, nuka Yohanis tuka sarani, dhu ca hari ni jaꞌa pua dhèu poro rare kètu na. Limuri ne, na mamuri hari le! Nèti èèna ka, na abhu koasa, tao tadha-tadha malaa sèra.” ");
INSERT INTO nfa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Dhèu aae Herodes peka sèmi èèna, lula uru èèna nèngu dhu tao lii langu dènge Yohanis, toke na kèpe Yohanis aa pamaso asa dꞌara bèdho. Jꞌajꞌajꞌi lii langu ne, sèmi neꞌe ka: dhèu aae Herodes leo nare dhèu èmu ari na Pelipus, ngara na Herodias. Aa te ngaa Pelipus dènge Herodias dhae paꞌia-paꞌela mèka. ");
INSERT INTO nfa_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nèti èèna ka, Yohanis kai ne pahari-pahari, peka na, “Ama dhèu aae, baku paleo èmu dènge dhèu èmu ari mu. Te jꞌara ne, pamèci boe dènge adꞌa èdhi dhèu Yahudi!” ");
INSERT INTO nfa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Te ngaa Herodes dale boe lii kai na, hèia leo nare Herodias. Madhutu iia-iia na, Herodes neo pamadhe Yohanis tuka sarani. Te ngaa na madhaꞌu dènge dhèu ae sèra, lula ra parcaya na, Yohanis ne, ca dhèu nèti lii padhai Ama Lamatua. Nèti èèna ka, na pua dhèu sabꞌa na pamaso Yohanis asa dꞌara bèdho. ");
INSERT INTO nfa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Te ngaa nèbhu-nèbhu, hèia Herodes tao pesta hari jadi na. Lodꞌo èèna, ana bhèni nèti bhèni aae Herodias laꞌe roge ètu madha tamu se. Na roge beꞌa titu kèna, toke dꞌara Herodes karejꞌe bia. ");
INSERT INTO nfa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Na roge nare, hèia Herodes paroa ne, ka na peka, “Èu neo manèngi hadia ngaa nèti jaꞌa, na peka la! Te èèna na jaꞌa hia èu. Jaꞌa leko boe-monya boe. Aa jaꞌa subha dènge kolongara Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ropa na tadèngi dhèu aae peka sèmi èèna, hèia ina na kakèjꞌi ne. Nèti èèna ka, ana ne laꞌe peka na, “Ama! Jaꞌa manèngi kètu nèti Yohanis tuka sarani. Tèke ne mi dꞌara dula, ho rèti mai asa neꞌe hia jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ropa tadèngi lii manèngi ana bhèni ne, hèia dꞌara Herodes roe dènge. Te ngaa nèngu bisa boe ère nare hari lii subha na, te tamu aaꞌi-aaꞌi dhu tadèngi le. Nèti èèna ka, na madhutu dhoka dadꞌèi ana bhèni ne di. ");
INSERT INTO nfa_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ka na paredha dhèu lasi poro rare kètu Yohanis ètu dꞌara bèdho. ");
INSERT INTO nfa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ropa ra poro rare, hèia ra tèke mi dꞌara dula ho rèti lasi hia mi ana bhèni ne. Ropa ana bhèni ne sèmi nare dula, hèia nèti asa ina na. ");
INSERT INTO nfa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lodꞌo ana madhutu Yohanis se tadèngi, ka mai rare ngiꞌu aae na, ho lasi padhane. Èle ka, lasi peka dènge Yesus jꞌara dhu jꞌajꞌi ne. ");
INSERT INTO nfa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lodꞌo Yesus tadèngi ngaa dhu jꞌajꞌi mi Yohanis, hèia Nèngu dènge ana-ana madhutu Na tèke eele era èèna. Hèia ra caꞌe koha, ho lasi asa era dhu dhèu pea boe, sèna ka ra ae rare ciki. Te ngaa dhèu ae ladhe rèdhi koha Yesus si dhu oro-oro re sebhe dano. Ka dhèu se mai nèti rae-rae, kako karohe-karohe re dedha rai. Nèti èèna ka, dhèu se dꞌai uuru nèti Yesus si. ");
INSERT INTO nfa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ropa Na puru nèti dedha koha, hèia nèdhi dhèu ae-ae dhu mate le Nèngu. Ka Na rasa kasia mi rèngu. Hèia Na puri-paꞌèle papèdꞌa-tarègu ra. ");
INSERT INTO nfa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dꞌai lodꞌo nihia, hèia ana madhutu Na, peka dènge Ne, “Ama! Hua iia Ama pua dhèu se, sèna ka lasi hèli ngangaꞌa ètu rae-rae dhu padètu ètu seꞌe. Te lodꞌo nihia le! Ètu neꞌe ngangaꞌa aadꞌo.” ");
INSERT INTO nfa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Te ngaa Yesus bꞌala si, peka na, “Baku! Miu ka dhu pangaꞌa si.” ");
INSERT INTO nfa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Te ngaa ra dhaa, aku rèngu na, “Ira ee, Ama! Jiꞌi se dènge boe ngaa-ngaa, ho pangaꞌa dhèu ae-ae sèmi neꞌe ne. Jiꞌi tao tasamia? Te abhu dhoka roti lèmi bua di, aa iꞌa dua ngiꞌu di!” ");
INSERT INTO nfa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Te ngaa Yesus lii, peka na, “Oo! Beꞌa kèna. Mèti ku mai!” ");
INSERT INTO nfa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ka Na pua dhèu se aaꞌi-aaꞌi ra madhèdi kaboko ètu dedha jꞌuꞌu. Èle èèna ka, Yesus nare roti lèmi bua dènge iꞌa dua ngiꞌu sèra. Hèia Na ladhe asa dedha, ho manèngi makasi mi Ama Lamatua. Èle ka, Na pamae roti se, hèia jꞌole asa ana madhutu Na, sèna ka ra papala mi dhèu se aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ka dhèu se raꞌa toke bècu. Raꞌa rara, hèia ana madhutu se pakaboko rare dhu ata, pènu canguru dua soe. ");
INSERT INTO nfa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dhèu aaꞌi-aaꞌi dhu raꞌa se, dhèu mone pe dꞌai lèmi riho sa, iga mèka dhèu bhèni dènge ana iiki. ");
INSERT INTO nfa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ropa dhèu aaꞌi-aaꞌi se raꞌa rare, hèia Yesus pua ana madhutu Na caꞌe koha, sèna ka lasi uru asa cabèka dano. Te ngaa Nèngu ètu èèna era, sena ka pua dhèu se lèpa. ");
INSERT INTO nfa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ropa rèngu lèpa aaꞌi mèu-mèu, hèia Yesus caꞌe laꞌe asa ledhe èci, ho sabajꞌa. Toke mèda, Nèngu mesa Na ètu èèna era. ");
INSERT INTO nfa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lodꞌo èèna, koha ana madhutu Na dꞌai le talora aae dano. Te ngaa rèngu tuku dꞌai madhe, lula ngèlu nèti madha, aa naha kapai tatèbꞌe koha ra. ");
INSERT INTO nfa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Oe dꞌai mèu, hèia Yesus laꞌe madhutu si. Te ngaa Nèngu dhu kako re dedha èi. ");
INSERT INTO nfa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ropa ladhe rèdhi, ana madhutu se cagꞌagꞌa, hèia ra padhai dènge lii madhaꞌu, aku rèngu na, “Heeh! Nidhu kèna!” ");
INSERT INTO nfa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Te ngaa Yesus lii dènge ra, peka na, “Miu baku madhaꞌu! Te Jaꞌa ne, Yesus! Mau-mau la!” ");
INSERT INTO nfa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ropa ra tadèngi lii neꞌe, hèia Petrus peka na, “Ladhe Ama kèna, pua la jaꞌa kako re dedha èi ne, dhiu asa Ama.” ");
INSERT INTO nfa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ka Yesus dhaa peka na, “Mai ka!” Hèia Petrus puru nèti dedha koha, laꞌe re dedha èi, asa Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Te ngaa ropa Petrus rasa na ngèlu aae, hèia na madhaꞌu bia. Ka na mulai cène, hèia na paꞌoo, aku nèngu na, “Ira oo, Ama, ee! Soru ku jaꞌa la!” ");
INSERT INTO nfa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus jꞌole dènge ka kacui-aai Na, ka kèpe nare Petrus. Hèia Yesus padhai lii, aku Nèngu na, “Petrus, ee! Nga tao ka dꞌara èu kajari? Èu parcaya èra boe mi Jaꞌa, do?” ");
INSERT INTO nfa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ka dua ra caꞌe lasi asa dedha koha, hèia ngèlu mau dènge. ");
INSERT INTO nfa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ropa rèdhi sèmi èèna, ana madhutu Na koa-kio padedha-dedha Ne, peka na, “Ira ii! Ama ne, mema tareꞌa-reꞌa Ana Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ropa rèngu dꞌai cabèka dano, hèia ra puru lasi asa dedha nebhe nèti rae Genesaret. ");
INSERT INTO nfa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Lodꞌo ra puru èèna, dhèu ae dhu tadhe le. Hèia dhèu paꞌoo, peka na, “Wee! Yesus mai le!” Ra rai lasi peka palème, hèia dhèu rèti dhèu pèdꞌa aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ra manèngi sèna ka ra goi lèke kodho Yesus. Te ra pangee na, “Sadꞌi dhèu pèdꞌa goi lèke suu kodho Na, tatu dhèu se èle dènge nèti papèdꞌa ra.” Ka dhèu dhu pèdꞌa aaꞌi-aaꞌi se goi kodho Yesus, ka ra èle dènge nèti papèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ca tèka, dhèu Parisi dènge mese agama ca nau mai nèti Yerusalem, ho paraga dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Dhèu Parisi kèpe paꞌèra adꞌa Yahudi rèngu. Lodꞌo rèngu tadèngi, na, ladhe ana madhutu Yesus raꞌa-rinu dhu jꞌamo boe kacui-aai madhutu adꞌa ra, hèia ra nasa. Ka rèngu mai ho pasala Yesus, peka na, “Nga tao ka ana madhutu Èu se raꞌa-rinu jꞌamo uuru boe ai? Èèna na, sisu le adꞌa bèi-baki èdhi!” ");
INSERT INTO nfa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Te ngaa Yesus dhaa, aku Nèngu na, “Miu se, dhèu dhu padhai lii leo tao leo! Miu dꞌèlu-mèu labꞌa paredha Ama Lamatua, sèna ka madhutu adꞌa tatao nèti bèi-baki miu di. ");
INSERT INTO nfa_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Te Ama Lamatua paredha, peka na, ‘Pakabꞌua ina-ama miu.’ Aa peka hari, na, ‘Ladhe ca dhèu padhèdꞌa aapa ina do ama na, hudꞌi huku pamadhe ne.’ ");
INSERT INTO nfa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ama Lamatua ajꞌa sèmi èèna ka, te ngaa miu ajꞌa leo. Miu peka na, ‘Ca dhèu parluu boe pake mèdha-panyau na, sèna ka soru-bara ina-ama na, masi ka rèngu ètu dꞌara jꞌajꞌèra, ladhe na pamoa le neo hia mèdha ne asa Lamatua’ Te ngaa dènge ajꞌa sèmi èèna, miu core eele le paredha Ama Lamatua, ho gati dènge atora unu miu. ");
INSERT INTO nfa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nèti èèna ka, deo na Jaꞌa dhu peka le, miu se, dhèu dhu padhai lii leo tao leo! Èèna na, nuka sèmi Yesaya, dhèu nèti lii padhai Ama Lamatua, dhu suri tèke, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Abhu dhèu dhu koa-kio Jaꞌa, dhoka dènge hèbꞌa di, te ngaa dènge boe dꞌara. ");
INSERT INTO nfa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Masi ka rèngu tao sèmi èèna, te ngaa parcuma. Ra pusi-pahae boe Jaꞌa, te rèngu sèra pahae dhoka atora dhèu rai-haha di.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Èle èèna ka, Yesus paroa dhèu leo ètu èèna, ka Na ajꞌa si, peka na, “Pasa dhilu pabeꞌa-beꞌa, sèna ka miu bisa meꞌa mèu! ");
INSERT INTO nfa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ngaa dhu maso asa dꞌara hèbꞌa, pakajꞌalu boe dhèu. Te ngaa dhu mai nèti dꞌara hèbꞌa, èèna ka dhu pakajꞌalu dhèu.” ");
INSERT INTO nfa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Èle ka, ana madhutu Na mai karèi Ne, aku rèngu na, “Ama meꞌa, do? Dhèu Parisi se dꞌara pèdꞌa ropa tadèngi lii padhai Ama.” ");
INSERT INTO nfa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Te ngaa Yesus dhaa, peka na, “Ama Ku ètu sorga, èèna na core eele dhèu dhu ajꞌa madhutu boe dadꞌèi Na. Èèna nuka sèmi dhèu koꞌo eele jꞌuꞌu dhu na dꞌèi boe. ");
INSERT INTO nfa_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","De baku pusi-pahae dènge dhèu Parisi sèi! Te rèngu ca ropa dènge dhèu bèdhu dhu pakako dhèu bèdhu. Èèna na ra manahu palere-lere asa dꞌara roꞌa lasi.” ");
INSERT INTO nfa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ka Petrus lii, peka na, “Ama, lole ku dènge jiꞌi la, sasoa nèti lii pakasame deo na!” ");
INSERT INTO nfa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus bꞌala, aku Nèngu na, “Miu meꞌa mèka kahèi? ");
INSERT INTO nfa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sasoa na sèmi neꞌe: ngaa dhu èdhi taꞌa, maso asa dꞌara hèbꞌa, laꞌe taruu asa kabake, èle èèna kalua hari laꞌe asa dꞌara kakus. ");
INSERT INTO nfa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Te, ngaa dhu mai nèti dꞌara hèbꞌa, èèna ka dhu pakajꞌalu dhèu, toke Ama Lamatua madenge dènge ne, aa dꞌèi boe paꞌèci dènge ne. ");
INSERT INTO nfa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Te jꞌara-jꞌara karehe, ae ka dhu mai nèti dꞌara dhèu! Nuka sèmi: ngangee dhu bhelu, pamadhe dhèu, bersina, tao jꞌara makae dènge dhèu dhu dhèu èmu nèngu boe, manaꞌu, sakasii kapodꞌe-kabèli, dènge pakarehe kolongara dhèu. ");
INSERT INTO nfa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jꞌara-jꞌara seꞌe ka dhu pakajꞌalu dhèu. Te ngaa ladhe dhèu dhoka raꞌa jꞌamo boe ai madhutu adꞌa, èèna sala boe ngaa-ngaa.” ");
INSERT INTO nfa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Èle èèna ka, Yesus tèke eele era neꞌe, kako laꞌe asa kota Tirus dènge kota Sidon. ");
INSERT INTO nfa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ètu nèi, abhu ina ca dhèu dhu jꞌajꞌajꞌi na nèti rai neꞌe. Nèngu dhèu Yahudi boe. Ropa na tadèngi nare Yesus mai le asa neꞌe, hèia laꞌe manèngi, peka na, “Ana-èpu dhèu aae Daud! Sue ku jaꞌa la! Te ana bhèni jaꞌa, lèke nidhu tao. Kasia ku jiꞌi la! Te na jꞌèra dꞌai seli.” ");
INSERT INTO nfa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Te ngaa Yesus mau-mau, aa dhaa boe ngaa-ngaa ciki sa. Hèia ana madhutu Na mai peka dènge Ne, “Ama, ina ne paꞌoo-parodha loe boe. Beꞌa risi Ama babège eele ne nèti neꞌe!” ");
INSERT INTO nfa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hèia Yesus dhaa, peka na, “Ama Lamatua pua Jaꞌa mai, ho soru-bara dhèu èdhi dhèu Yahudi, lula rèngu kako sala jꞌara, nuka sèmi kahibꞌi-kalèbho dhu reꞌa heka jꞌara. Te Na pua boe Jaꞌa sèna ka soru-bara dhèu leo.” ");
INSERT INTO nfa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Te ngaa ina ne mai padètu-dètu asa Yesus. Ka na patitu kètu urutuu dènge lii manèngi, “Ama! Sue ku jaꞌa la!” ");
INSERT INTO nfa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Te ngaa Yesus core lii padhai Na, aku Nèngu na, “Pantas boe tare ngangaꞌa nèti ana-ana, ka hia mi busa.” Dènge lii dhu pacele, sasoa na, Yesus hudꞌi soru-bara uuru ku dhèu Yahudi Nèngu unu Na, heka bisa ladhe-leru dhèu leo kèna. ");
INSERT INTO nfa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Te ngaa ina ne bꞌala, aku nèngu na, “Tareꞌa Ama! Te ngaa busa dhu mate mema ètu roꞌa mei. Rèngu raꞌa kahèi ngangaꞌa dhu bèbhe eele nèti dꞌara pega ana sèra.” Sasoa na, ropa ana-ana raꞌa, busa kahèi abhu raꞌa. Masi ka Yesus soru-bara dhèu unu Na, te ngaa Nèngu hudꞌi ladhe-leru dhèu Yahudi boe kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ropa tadèngi nare, ka Yesus peka na, “Ira ii! Ina parcaya Jaꞌa tareꞌa-reꞌa! De lèpa ka, lula ngaa dhu ina manèngi èèna, jꞌajꞌi le!” Èle èèna ka, na lèpa, ka na ladhe nèdhi ana na dhu èle le nèti papèdꞌa na. ");
INSERT INTO nfa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Èle ka, Yesus dènge ana-ana madhutu Na tèke eele era neꞌe, hèia ra kako madhutu re sebhe dano Galilea. Ka ra caꞌe asa ledhe cue, hèia Yesus madhèdi ho ajꞌa-nori si. ");
INSERT INTO nfa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Èle èèna ka, dhèu ae-ae mai asa Yesus. Ra rèti dènge dhèu haga roe cabèka, dhèu bèdhu, dhèu karuku, dhèu lii aadꞌo, dènge dhèu-dhèu dhu pèdꞌa leo kahèi. Ra pamadhèdi dhèu pèdꞌa se padètu-dètu dènge haga Yesus. Ka Na puri-paꞌèle si. ");
INSERT INTO nfa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ropa ladhe rèdhi, hèia dhèu ae se malaa. Ra papeka na, “Ira ii! Malaa titu kèna, nga! Dhèu haga roe cabèka, bisa kako èra hari. Dhèu bèdhu, bisa rèdhi. Dhèu karuku, bisa kako. Aa dhèu lii aadꞌo, bisa padhai lii! Seꞌe se, tatu tatao Ama Lamatua. Aa Lamatua èèna ka, dhu uru-uru sèra bèi-baki èdhi pahaha iisi mi Nèngu.” ");
INSERT INTO nfa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Lalu eele pèri-pèri lodꞌo, hèia Yesus paroa ana madhutu Na, ka Na peka, aku Nèngu na, “Jaꞌa rasa kasia dènge dhèu ae-ae se. Abhu dhu mai nèti era kajꞌèu, ra pakaboko ètu neꞌe tèlu lodꞌo kèna, toke gee ra èle aaꞌi le. Beꞌa risi baku hia si lèpa dènge kabake manganga. Mage dhoka ra bèbha ètu talora jꞌara.” ");
INSERT INTO nfa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Te ngaa ana madhutu Yesus dhaa, aku rèngu na, “Ama! Era neꞌe kajꞌèu nèti rae. Tatu, èdhi bisa boe pangaꞌa tare dhèu ae-ae sèmi seꞌe.” ");
INSERT INTO nfa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Te ngaa Yesus karèi si, aku Nèngu na, “Roti miu pèri bua?” Ra dhaa, aku rèngu na, “Dhoka pidhu di, dènge iꞌa pèri ngiꞌu di!” ");
INSERT INTO nfa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ka Yesus pua dhèu seꞌe madhèdi ètu rai. ");
INSERT INTO nfa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hèia nare roti pidhu bua dènge iꞌa sèra, ka Na manèngi makasi mi Ama Lamatua. Ka Na pamae roti se, hèia Na jꞌole asa ana madhutu Na, sèna ka ra papala mi dhèu aaꞌi-aaꞌi sèra. ");
INSERT INTO nfa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hèia aaꞌi-aaꞌi raꞌa toke bècu. Ka ra kaboko rare ngangaꞌa dhu ata, pènu pidhu soe hahake. ");
INSERT INTO nfa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dhèu aaꞌi-aaꞌi dhu raꞌa se, dhèu mone ele boe dꞌai èpa riho dhèu sa. Dhae ige mèka bhèni dènge ana iiki sèra. ");
INSERT INTO nfa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Èle ka, Yesus pua dhèu ae-ae sèra lèpa. Hèia Na caꞌe asa dedha koha, ho lasi asa rai Magadan. ");
INSERT INTO nfa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ca tèka, pèri-pèri dhèu Parisi dènge dhèu Saduki, mai paraga dènge Yesus. Rèngu neo pakarèi dènge Ne, sèna ka tenge jꞌara neo pamanahu Yesus. Nèti èèna ka, ra manèngi sèmi neꞌe ka, “Ama! Tao ku tadha malaa, sèna ka jꞌajꞌi tadha, dhu peka na, Ama abhu koasa nèti Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Te ngaa Yesus bꞌala, peka na, “Ladhe èdhi tèdhi liru mea ropa lodꞌo cèna, èdhi teꞌa, na, ‘Bèli èjꞌi mai boe.’ ");
INSERT INTO nfa_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aa ladhe lodꞌo rea, aa liru mèdhi, na èdhi teꞌa, na, ‘Doe neꞌe, oe èjꞌi.’ De ladhe miu bisa patadhe mere tadha ètu liru sèmi sèra, nga tao ka miu bisa boe patadhe mere sasoa nèti tadha-tadha jaman? ");
INSERT INTO nfa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Miu dhèu lodꞌo limuri ne, meꞌa dhodhoka adꞌu-ue bhabhelu di! Miu pusi-pahae boe Ama Lamatua! Masi ka miu manèngi tadha malaa, te ngaa Jaꞌa dale boe tao. Lula uru èèna, Lamatua dhu tao le tadha malaa re Yunus, ca dhèu nèti lii padhai Ama Lamatua. De èèna dꞌai le!” Ropa padhai lii nare, hèia Yesus tèke eele si. ");
INSERT INTO nfa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ropa Yesus si lasi asa ca bèka dano, hèia ana madhutu Na, heka sanèdꞌe, na, rèngu rèti boe roti tao gee jꞌara. ");
INSERT INTO nfa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tadèngi rèngu padhai lii sèmi èèna, hèia Na peka na, “Miu baku pamudꞌe dènge ragi dhèu Parisi dènge dhèu Saduki.” ");
INSERT INTO nfa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ropa tadèngi rare, hèia ana madhutu Na bingu, ka ra peka, “Na peka ngaa nèi? Ele boe neꞌa na, èdhi tèti boe roti, sina ma?” ");
INSERT INTO nfa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Te ngaa Yesus neꞌa ngangee rèngu. Ka Na padhai lii, aku Nèngu na, “Wee, miu seli-kolane, nga! Nga tao ka miu padhue dhoka roti di! Miu parcaya boe Jaꞌa, do? ");
INSERT INTO nfa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Miu dhae meꞌa iia mèka koasa Jaꞌa, do? Te lodꞌo Jaꞌa pamae lèmi bua roti ho pangaꞌa lèmi riho dhèu sèra, dhu sisa, miu pakaboko mere pèri soe? ");
INSERT INTO nfa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aa tasamia hari dènge roti pidhu bua dhu Jaꞌa pangaꞌa èpa riho dhèu sèra? Abhu pèri soe hahake dhu miu pakaboko nèti dhu raꞌa risi sèra? ");
INSERT INTO nfa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nga tao ka miu moꞌo boe meꞌa dènge lii padhai Jaꞌa deo na? Jaꞌa padhue-padhai boe lula roti. Te Jaꞌa neo pasanèdꞌe miu, sèna ka miu baku pamudꞌe dènge tatao dhèu Parisi dènge dhèu Saduki. Te lii ajꞌa-nori ra bisa ère rare dhèu ae, nuka sèmi ragi dhu tao roti jꞌajꞌi kapai.” ");
INSERT INTO nfa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ropa Yesus padhai lii sèmi èèna, hèia heka rèngu reꞌa kèna, na Nèngu peka boe roti. Te ngaa Na padhue-padhai nèti aꞌajꞌa dhu sale nèti dhèu Parisi dènge dhèu Saduki. ");
INSERT INTO nfa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Èle, hèia Yesus si lasi asa rai dhu padètu dènge kota Kaisarea Pilipi. Ètu talora jꞌara, Na karèi ana madhutu Na, aku Nèngu na, “Madhutu lii papeka dhèu, Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, cee?” ");
INSERT INTO nfa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ra dhaa, peka na, “Abhu dhu peka na, Ama ne, Yohanis tuka sarani dhu mamuri hari. Cahagꞌe peka na, ele boe Ama ne, Elia. Cahagꞌe hari ale na, Yermia. Ladhe aadꞌo, na, ca dhèu leo nèti dhèu rèti lii padhai Ama Lamatua uru-uru sèra.” ");
INSERT INTO nfa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ka Yesus karèi hari si, “Ladhe madhutu miu mesa mi, Jaꞌa ne, cee?” ");
INSERT INTO nfa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hèia Simon Petrus dhaa, aku nèngu na, “Ama ne, Kristus, nuka Dhèu dhu uru èèna Ama Lamatua pajaji tèke ho neo hia mai! Aa Ama ne, Ana Ama Lamatua dhu mamuri toke dꞌai mia-mia!” ");
INSERT INTO nfa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Èle èèna ka, Yesus lii, peka na, “Simon, ana Yunus! Èu ne, oto kapai! Te nèti boe dhèu rai-haha dhu peka lii neꞌe dènge èu. Te ngaa Ama Ku ètu sorga ka peka dènge èu. ");
INSERT INTO nfa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nanene, ee! Karèi nèti deo neꞌe ne, Jaꞌa pangare èu, ‘Petrus’. Dhu sasoa na, hadhu. Lula parcaya èu, èra sèmi hadhu, èèna na èu jꞌajꞌi era padhèdi nèti dhèu-dhèu Jaꞌa dhu parcaya. Masi ka rèngu abhu jꞌajꞌèra toke madhe, te ngaa rèngu taha taruu. ");
INSERT INTO nfa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jaꞌa èèna na hia èu hak, sèna ka èu uri dhèu-dhèu Jaꞌa, nuka sèmi èu mèdꞌu gagoe sorga. Te, ngaa dhu èu kai ètu rai-haha, èèna na Lamatua kai ètu sorga kahèi. Dènge ngaa dhu èu hia isin ètu rai-haha ne, Lamatua hia le isin ètu sorga kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Padhai lii nare sèmi èèna, ka Yesus kai si ho rèngu baku peka dènge dhèu, na, Nèngu ne, Kristus. ");
INSERT INTO nfa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Karèi nèti lodꞌo èèna, Yesus peka dènge ana madhutu Na sèra, aku Nèngu na, “Jaꞌa hudꞌi laku ku asa Yerusalem. Te ngaa ètu nèi, Jaꞌa abhu jꞌajꞌèra ae-ae, nèti dhèu heka-dhèu heka adꞌa, kètu agama Yahudi dènge mese agama sèra. Èèna na ra pamadhe Jaꞌa, te ngaa camèdꞌa èèna, Jaꞌa mamuri hari.” ");
INSERT INTO nfa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ropa Yesus padhai lii nare, hèia Petrus ère nare Yesus asa karasa, ka na kai, aku nèngu na, “Ama, baku padhai lii sèmi èèna! Tatu Ama Lamatua soro tèke boe jꞌara ne jꞌajꞌi!” ");
INSERT INTO nfa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Te ngaa lii padhai Petrus ne, madhutu boe dadꞌèi Lamatua. Nèti èèna ka, Yesus kabibꞌa, ka jèke ne, peka na, “Heh! Pakajꞌèu nèti neꞌe! Lii padhai èèna nèti dhèu aae nidhu! Èu baku bhabhae Jaꞌa! Èu ne dhodhoka pangee madhutu dadꞌèi dhèu rai-haha di, te ngaa madhutu boe dadꞌèi Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Èle èèna ka, hèia Yesus ajꞌa ana madhutu Na sèra, aku Nèngu na, “Dhèu dhu neo madhutu Jaꞌa, nèngu hudꞌi taha taruu ku bèli-bèli! Nèngu hudꞌi paꞌuru ku dadꞌèi Ama Lamatua, aa pabhèlu eele dadꞌèi nèngu unu na. Masi ka dhèu neo pamadhe ne, nèngu hudꞌi madhutu Jaꞌa taruu, sama sèmi dhèu pasae ajꞌu palolo-palèbha na, laꞌe asa era mamadhe na. ");
INSERT INTO nfa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Te dhèu dhu sadia madhe lula na madhutu Jaꞌa, bèli-camèdꞌa nèngu abhu mamuri taruu dènge Ama Lamatua. Te ngaa dhèu dhu dꞌèi dhoka mamuri hia ngiꞌu aae na di, èèna na mamuri nèngu ele iie dꞌara! ");
INSERT INTO nfa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nanene paie-iie! Ladhe èu abhu aaꞌi isi rai-haha ne, te ngaa ladhe Lamatua core eele èu, aꞌoto na ètu mia? Masi ka èu pasae mèti aaꞌi isi rai-haha ne, èu bisa boe pasilu dènge samanga èu! ");
INSERT INTO nfa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jaꞌa peka mema dènge miu jꞌara aaꞌi-aaꞌi ra, lula Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Bèli-camèdꞌa Jaꞌa mai hari dènge dadedha nèti Ama Ku, palere-lere dènge ana pajuu Na nèti sorga. Lodꞌo èèna, pe Jaꞌa bꞌala mi ca dhèu-ca dhèu madhutu tatao ra. ");
INSERT INTO nfa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sanèdꞌe paie! Nèti miu aaꞌi-aaꞌi se, bèli-camèdꞌa abhu cahagꞌe dhu madhe boe, toke ra rèdhi Jaꞌa, nuka Dhèu Rai-haha Tareꞌa-reꞌa ne, jꞌajꞌi Dhèu Aae dhu kèdꞌu paredha.” ");
INSERT INTO nfa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Èle èna lodꞌo, ka Yesus paroa Petrus, Yakobis dènge ari na Yohanis, sèna ka lasi asa ledhe dhu dedha èci, ho pea mesa ra ètu nèi. ");
INSERT INTO nfa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dꞌai nèi, ra ladhe na, rupa Yesus leko-leo. Rèhu Na kahaꞌa nuka sèmi madha lodꞌo, aa mèdha-papake Na jꞌajꞌi pudhi kaleꞌe. ");
INSERT INTO nfa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kacaꞌa la, rèngu ladhe rèdhi Yesus dhu padhai lii dènge Musa dènge Elia. ");
INSERT INTO nfa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hèia Petrus bingu, ka na padhai lii leli, aku nèngu na, “Ama! Jiꞌi karejꞌe titu kèna ètu era neꞌe ne! De beꞌa risi jiꞌi patitu paleo tèlu bua. Cue hia Ama, cue hia Musa, aa cue hari hia Elia.” ");
INSERT INTO nfa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lodꞌo Petrus padhai lii sèmi èèna era, cagꞌagꞌa laa, raꞌi-liru puru mai sarimu nare rèngu. Hèia rèngu malaa-maloha tadèngi lii èci dhu kalua nèti dꞌara raꞌi-liru ne, peka na, “Nanene! Yesus ne, Ana pasue Jaꞌa. Nèngu neꞌe ka dhu pakarejꞌe taruu dꞌara Jaꞌa. Nanene Ne paie-iie!” ");
INSERT INTO nfa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ropa tadèngi lii ne, hèia ana madhutu Na madhaꞌu titu kèna, ka ra bèbha sagèbꞌa ètu rai. ");
INSERT INTO nfa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Te ngaa Yesus mai gai si, ka Na peka na, “Mi kèdꞌi ka, baku madhaꞌu!” ");
INSERT INTO nfa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ka ana madhutu se boti kètu ra, te ngaa ra ladhe rèdhi heka dhèu èci sa ètu era èèna, dhoka Yesus di. ");
INSERT INTO nfa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Èle ka, ra puru nèti ledhe ne. Hèia Yesus kai si, aku Nèngu na, “Ngaa dhu heka ladhe mèdhi deo na, mage peka dènge dhèu èci sa kahèi! Te Jaꞌa Dhèu Rai-haha Tareꞌa-reꞌa ne, hudꞌi madhe uuru ku. Èle èèna, ladhe Jaꞌa mamuri hari, heka miu lole dènge dhèu kèna.” ");
INSERT INTO nfa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Hèia ra karèi Ne, aku rèngu na, “Ama ne mema Kristus, te ngaa Elia ètu mia? Te mese agama se ajꞌa, peka na, Elia hudꞌi mai uuru ku, èle èèna, heka Kristus mai kèna. Te ngaa madhutu Ama, tasamia?” ");
INSERT INTO nfa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ka Yesus dhaa, aku Nèngu na, “Mema lèke. Elia hudꞌi mai uuru ku, ho bhoke jꞌara hia Kristus. ");
INSERT INTO nfa_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nanene paie! Elia mai le, te ngaa dhèu tadhe boe ne. Rèngu pajꞌèra ne, madhutu dadꞌèi ra. Sèmi èèna kahèi, bèli-camèdꞌa rèngu pajꞌèra Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne.” ");
INSERT INTO nfa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ropa ra tadèngi rare, ana madhutu Na heka reꞌa, na, Elia dhu Yesus peka ne, nuka Yohanis tuka sarani. ");
INSERT INTO nfa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Èle ka, ropa rèngu lèpa, paraga dènge dhèu ae dhu mate le. Hèia ama ca dhèu mai patitu kètu urutuu, ka na manèngi Yesus, ");
INSERT INTO nfa_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na peka, “Ama! Sue ku ana jaꞌa la! Te nèngu dhu hujꞌu kahibꞌi, aa na jꞌèra titu kèna. Ladhe èi papèdꞌa ne cèu, na bèbhe sa dꞌara èi, do dꞌara ai. Ama sue ku la! ");
INSERT INTO nfa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ana ne, jaꞌa kèti le asa ana-ana madhutu Ama ku, te ngaa ra tao rare boe ne.” ");
INSERT INTO nfa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ropa Na tadèngi sèmi èèna, hèia Yesus jèke ana madhutu Na sèra, aku Nèngu na, “Heh! Miu se seli-kolane! Jaꞌa ajꞌa le miu pahari-pahari, te ngaa miu meꞌa mèu boe. Aa miu parcaya boe Jaꞌa dènge dꞌara kateme. Jaꞌa hudꞌi mate hari ku miu, dꞌai pèri lodꞌo? Mèti ana èèna mai!” ");
INSERT INTO nfa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hèia, rèti ana ne, ka Yesus babège eele nidhu nèti ana neꞌe. Ka nidhu rai tèke eele ne, hèia ana ne èle dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Èle èèna ka, ropa Yesus mesa Na dènge ana madhutu sèra, ka ra karèi Ne, peka na, “Ama! Nga tao ka jiꞌi bisa boe babège ngare nidhu deo na?” ");
INSERT INTO nfa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ka Yesus dhaa, na, “Miu babège mere boe, lula miu parcaya boe dènge dꞌara kateme. Sanèdꞌe! Ladhe miu parcaya Jaꞌa tareꞌa-reꞌa, masi ka ciki ooꞌe èèna ka sama sèmi lamusi ana iiki-iiki èci, miu bisa paredha ledhe èci, peka na, ‘Hee ledhe, hari sa nèi, lamu!’ Tatu na hari kahèi. De miu bisa tao ngaa èèna ka, sadꞌi parcaya dènge dꞌara kateme. ");
INSERT INTO nfa_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Te ngaa sanèdꞌe! Nidhu sèmi seꞌe se, mema bhelu titu kèna. Ladhe miu sabajꞌa boe aa puasa boe, ho manèngi mi Ama Lamatua, na, miu babège mere boe nidhu sèmi sèra.” ");
INSERT INTO nfa_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ca lodꞌo, Yesus dènge ana madhutu Na dhu pakaboko ètu propensi Galilea. Na peka dènge rèngu, na, “Nèbhu heka, te ra neo pahie Jaꞌa asa dhèu leo rai kara. ");
INSERT INTO nfa_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hèia ra pamadhe Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne. Mema tareꞌa Jaꞌa madhe, te ngaa asa camèdꞌa Jaꞌa mamuri hari.” Ropa ana madhutu Na sèra tadèngi lii deo na, hèia dꞌara ra susa titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lodꞌo Yesus dènge ana madhutu Na lasi asa rae Kapernaum, hèia dhèu roro bea mai paraga dènge Petrus, ka ra karèi ne, na, “Mese miu bꞌae bea Èmu Kapua Manèngi-Mangajꞌi do, aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hèia Petrus dhaa, “Na bꞌae!” Ropa Petrus lepa, ka Yesus karèi dènge ka, aku Nèngu na, “Simon, èu pangee ku la! Dhèu aae-dhèu aae ètu rai-haha ne abhu bea nèti cee? Nèti ana matana ra, do, nèti dhèu leo?” ");
INSERT INTO nfa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus dhaa, na, “Nèti dhèu leo!” Ka Yesus tuhu lii padhai Na, peka na, “Ladhe sèmi èèna, ana dhèu aae di dhu bꞌae boe, si? ");
INSERT INTO nfa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sèmi èèna kahèi dènge bea Èmu Kapua Manèngi-Mangajꞌi. Te ngaa hudꞌi laa, sèna ka dhèu roro bea se baku nasa dènge èdhi. De beꞌa risi lamu madulu iꞌa asa dꞌara dano. Iꞌa dhu èu abhu uuru èèna, èu bhoke hèbꞌa na. Pe èu abhu doi iia cue. More, ho bꞌae bea èdhi dua ti. Te doi ne, dꞌai le bea èdhi dua ti.” ");
INSERT INTO nfa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lodꞌo èèna, ana madhutu Yesus lasi karèi Ne, peka na, “Ama! Nèti dhèu-dhèu unu Ama Lamatua, cee ka dhu kapai risi?” ");
INSERT INTO nfa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hèia Yesus paroa nare ana iiki èci, mai patitu asa talora aae rèngu. ");
INSERT INTO nfa_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ka Na peka dènge ra, “Nanene paie-iie! Dhèu dhu neo jꞌajꞌi dhèu unu Lamatua, rèngu hudꞌi ubꞌa ngangee ra, ho jꞌajꞌi sama sèmi ana iiki dhu neꞌa boe padedha iisi. ");
INSERT INTO nfa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lula dhèu dhu neꞌa pahaha iisi sama sèmi ana iiki ne, nèngu èèna ka dhu kapai risi ètu madha Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aa dhèu dhu sèmi nare dhèu haha nuka sèmi ana iiki ne, lula na parcaya Jaꞌa, na, nèngu sèmi nare le Jaꞌa ne.” ");
INSERT INTO nfa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Èle èèna ka, Yesus padhai lii hari, peka na, “Ladhe abhu dhèu dhu tao ana iiki sèna ka madhutu jꞌara dhu sale, toke ana ne parcaya heka Jaꞌa, na, mata unu na! Beꞌa risi dhèu èki hadhu aae cue, mi ladha goro na, ho pacène ne asa dꞌara dhasi marèma. ");
INSERT INTO nfa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Rai-haha ne mema era dhu pènu dènge dhudhu-sete, lula abhu jꞌara ae dhu pamanahu dhèu asa dꞌara sasala-sasigo. Te ngaa dhèu dhu dui babia risi, nuka dhèu dhu tenge-tenge jꞌara ho soro dhèu asa dꞌara sasala. ");
INSERT INTO nfa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ladhe èu tao sala, pake kacui-aai èu, do, haga èu, na, poro eele ne! Te beꞌa risi èu maso asa dꞌara sorga dènge ai cabèka, do, haga calaa. Mage dhoka ra core èu asa dꞌara ai naraka, dènge ai do haga dhu tesa. ");
INSERT INTO nfa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ladhe èu tao sala, pake musi madha èu, na, cèru eele ne! Te beꞌa risi èu maso asa dꞌara sorga dènge musi madha cabèka. Mage dhoka ra core èu asa dꞌara ai naraka, dènge musi madha dhu tesa.” ");
INSERT INTO nfa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ka Yesus tuhu hari lii Na, aku Nèngu na, “Sanèdꞌe, ee! Baku mi pahaha ana iiki sèmi seꞌe se. Te abhu ana pajuu Ama Lamatua nèti sorga dhu madhenga si. Aa ana pajuu se dhu lasi taruu, peka dènge Ama Lamatua ngaa-ngaa dhu jꞌajꞌi mi ana se. ");
INSERT INTO nfa_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Mi pangee paie-iie, te Jaꞌa hia lii pakasame èci sèmi neꞌe ka: abhu dhèu èci dhu kahibꞌi-kalèbho na, cangasu ngiꞌu. Ca lodꞌo, ciꞌu nèti kahibꞌi-kalèbho se, kako sala jꞌara. Madhutu ngangee miu, dhèu madhenga ne tao tasamia? Tatu na tèke eele ceo nguru ceo ngiꞌu sèra ètu ledhe, ho laꞌe tenge ciꞌu dhu ele ne. Ladhe na abhu hari, tatu na karejꞌe, ropa na ladhe nèdhi ciꞌu ne, risi nèti kahibꞌi-kalèbho na ceo nguru ceo ngiꞌu dhu ele boe sèra. Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, mai ho hia mamuri mi dhèu dhu kako sale nèti jꞌara dhu mola. ");
INSERT INTO nfa_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Te, masi ka ana iiki ca dhèu di dhu kako sala jꞌara, te ngaa Ama Ku ètu sorga dꞌèi boe kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus lii hari, aku Nèngu na, “Ladhe aꞌari èu dhèu parcaya tao sale mi èu, na, èu mesa mu lamu paraga dènge ne. Ladhe miu dua mi mesa mi, heka èu peka sasala nèngu kèna. Ladhe na sèmi nare lii padhai èu, na, miu dua mi pabeꞌa hari le kèna. ");
INSERT INTO nfa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Te ngaa ladhe noꞌo boe sèmi nare lii padhai èu, lamu paroa more angalai mu ca dhèu do dua dhèu, ho lami paraga dènge ne, sèna ka padhai lii hari. Te ètu dꞌara Sasuri Mola-Mèci Ama Lamatua dhu suri tèke, peka na, ‘Ètu dꞌara lii langu èci, hudꞌi abhu ku dua-tèlu sakasii dhu lii èci, heka sèmi rare lii galaa ra.’ ");
INSERT INTO nfa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te ngaa ladhe noꞌo boe nanene lii miu, lami lole dènge jumaꞌat. Aa ladhe na dꞌèi boe nanene lii jumaꞌat kahèi, tao ne nuka sèmi ca dhèu dhu tadhe boe Lamatua. Ladhe aadꞌo na, cap ne nuka sèmi dhèu bhelu, conto sèmi dhèu roro bea sèra. ");
INSERT INTO nfa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Sanèdꞌe paie-iie lii padhai Jaꞌa ne! Ngaa dhu miu oro ètu rai-haha ne, èèna ka dhu Lamatua oro le ètu sorga. Aa ngaa dhu miu hia isin ètu rai-haha ne, èèna ka Lamatua hia le isin ètu sorga kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Aa Jaꞌa peka hari, na, ladhe abhu dhèu dua dhu sabajꞌa dènge dꞌara èci, pe Ama Ku ètu sorga hia ngaa dhu ra manèngi. ");
INSERT INTO nfa_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te, ladhe abhu dua, do tèlu dhèu, pakaboko sabajꞌa sama-sama, lula rèngu dhèu Jaꞌa, na, Jaꞌa ètu talora aae rèngu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Èle èèna, ka Petrus karèi Yesus, aku nèngu na, “Ama, jaꞌa neo karèi ciki. Ladhe aꞌari jaꞌa tao sale pahari-pahari mi jaꞌa, èèna na dꞌai pèri hari jaꞌa hudꞌi hia ne abho? Dꞌai pidhu hari, do?” ");
INSERT INTO nfa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Hèia Yesus dhaa, peka na, “Aadꞌo! Èu hudꞌi abho ne pidhu kali pidhu nguru hari, toke èu ige more heka. ");
INSERT INTO nfa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Miu hudꞌi tao ku sèmi èèna, lula Ama Lamatua nuka sèmi dhèu aae dhu ige kèlu na ètu pegawi na. ");
INSERT INTO nfa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ropa na ige nare, hèia na pua dhèu lasi paroa pegawi dhu pakèlu toke riho kehi. ");
INSERT INTO nfa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Te ngaa pegawi ne bꞌae nare boe kèlu na. Ka dhèu aae paredha, peka na, ‘Lami pahie eele dhèu ne dènge bhèni-ana niki na aaꞌi-aaꞌi, sèna ka ra jꞌajꞌi ènu. Aa mèdha-panyau na, pahie aaꞌi kahèi, ho bꞌae kèlu-gꞌètu na.’ ");
INSERT INTO nfa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ropa pegawi ne tadèngi nare, hèia na pabèbha iisi, ho patitu kètu urutuu ètu madha dhèu aae, ka pamako, aku nèngu na, ‘Ira ee! Ama dhèu aae hia jaꞌa tebho dꞌai ciki sa! Sèna ka jaꞌa bꞌae kèlu jaꞌa aaꞌi-aaꞌi ra.’ ");
INSERT INTO nfa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ropa tadèngi, hèia dhèu aae rasa kasia dènge ne. Ka dhèu aae pabhèlu eele aaꞌi mèu-mèu kèlu na, ka pua na lèpa. ");
INSERT INTO nfa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Te ngaa ropa na dꞌai liꞌu, hèia pegawi ne paraga dènge angalai na dhu pakèlu nèngu doi ciki di. Ka na kèpe angalai ne, hèia pacèli ladha goro na, aa na jèke ne, aku nèngu na, ‘Weh! Bꞌae ka dꞌara lai-lai ne kèlu èu sèra!’ ");
INSERT INTO nfa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ropa angalai na tadèngi, hèia na patitu kètu urutuu, ka pamako ne, peka na, ‘Ira ee! Angalai, ee! Hia ku jaꞌa tebho dꞌai ciki sa! Pe jaꞌa bꞌae kèlu jaꞌa sèra!’ ");
INSERT INTO nfa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Te ngaa pegawi ne peka na, ‘Bisa boe! Jaꞌa mate heka panèbhu. Èu bꞌae dènge ka lodꞌo doe neꞌe kahèi!’ Èle ka, laꞌe pamaso angalai na asa dꞌara bèdho, toke na bꞌae aaꞌi kèlu na. ");
INSERT INTO nfa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ropa pegawi dhu leo ladhe rèdhi ngaa dhu jꞌajꞌi ne, hèia dꞌara ra susa. Ka lasi lolo dènge dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ropa tadèngi nare, hèia dhèu aae ne paroa pegawi dhu neꞌa boe manèngi makasi ne. Dhèu aae jèke ne, aku nèngu na, ‘Heh, dhèu bhelu-katubꞌa! Lula èu ne manèngi sèna ka jaꞌa sue èu, nèti èèna ka jaꞌa pabhèlu eele le kèlu èu sèra. ");
INSERT INTO nfa_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Te ngaa, nga tao ka èu kasia boe angalai èu sa hèi, sama sèmi jaꞌa kasia èu ne?’ ");
INSERT INTO nfa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ka dhèu aae nasa bia dènge ne, hèia na pua pamaso dhèu ne asa dꞌara bèdho, sèna ka ra pajꞌèra ne, toke na bꞌae aaꞌi kèlu na sèra.” ");
INSERT INTO nfa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hèia Yesus paꞌèle lii pakasame Na, peka na, “Ama Ku ètu sorga paꞌiga sèmi èèna kahèi mi dedha miu. Pe Na huku miu, ladhe miu moꞌo boe pabhèlu eele sasala nèti aꞌari miu dhèu parcaya sèra.” ");
INSERT INTO nfa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ropa Yesus ajꞌa nare aaꞌi jꞌara sèra, hèia laꞌe tèke eele Galilea asa propensi Yudea, ètu cabèka loko Yarden. ");
INSERT INTO nfa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dhèu ae ka dhu madhutu Ne, ka Na puri-paꞌèle dhèu-dhèu pèdꞌa ètu nèi. ");
INSERT INTO nfa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Abhu pèri-pèri dhèu Parisi dhu madhutu kahèi, dhu neo pamanahu Ne. Ka ra karèi Yesus, peka na, “Ama! Madhutu atora agama èdhi, ladhe dhèu mone leo le èmu, bisa ia eele dhèu èmu na, sadꞌi na abhu jꞌara dhu laꞌe asa paꞌie-paꞌela. Sèmi èèna, do?” ");
INSERT INTO nfa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Te ngaa Yesus bꞌala si, na “Miu se dhu meꞌa mèu agama. Te ngaa tasamia ka miu meꞌa boe isi Sasuri Mola-Mèci Ama Lamatua? Te ètu dꞌara sasuri nèti lii lolo uru tèka, dhu suri peka na, ‘Ama Lamatua pajꞌajꞌi dhèu rai-haha, dhèu mone dènge dhèu bhèni.’ ");
INSERT INTO nfa_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aa dhu suri kahèi, peka na, ‘Nèti èèna ka, dhèu mone hudꞌi tèke eele ina-ama na, sèna ka laꞌe mamuri dꞌara èci dènge dhèu èmu-kamali na, te dua ra dhu jꞌajꞌi le èci.’ ");
INSERT INTO nfa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nèti èèna ka, ladhe Ama Lamatua unu Na dhu hia dua ra jꞌajꞌi le èci, na, dhèu rai-haha baku pacèri si hari!” ");
INSERT INTO nfa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ropa tadèngi rare Yesus peka sèmi èèna, dhèu Parisi se karèi hari Ne, peka na, “Ladhe sèmi èèna, nga tao ka Musa peka na, dhèu bisa paꞌia-paꞌela, sadꞌi nèngu tao uuru ku sasuri paꞌia hia dhèu èmu na?” ");
INSERT INTO nfa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hèia Yesus dhaa, aku Nèngu na, “Musa soro tèke bèi-baki miu paꞌia-paꞌela dènge dhèu èmu-kamali ra, lula rèngu sèra kètu hadhu èci èèna ka dènge miu! Te ngaa lodꞌo Ama Lamatua pajꞌajꞌi rai-haha ne, dadꞌèi Na sèmi boe èèna. ");
INSERT INTO nfa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nèti èèna ka, Jaꞌa pasanèdꞌe mema miu, ee! Ladhe bhèni adꞌu uuru madha jꞌara makae, dhèu èmu na bisa ia eele ne. Te ngaa ladhe ia eele bhèni ne dhu adꞌu boe jꞌara makae, hèia dhèu mone na leo hari dènge bhèni leo, nèngu ne tao le jꞌara makae!” ");
INSERT INTO nfa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ropa tadèngi lii neꞌe, hèia ana madhutu Na sèra, peka na, “Ladhe sèmi èèna, beꞌa risi baku leo-èmu.” ");
INSERT INTO nfa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hèia Yesus bꞌala si, aku Nèngu na, “Dhèu ae ka dhu roꞌo boe sèmi rare lii padhai lii Jaꞌa ne. Dhodhoka dhèu dhu Ama Lamatua hagꞌe nare si. ");
INSERT INTO nfa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Te abhu dhèu dhu leo boe èmu, lula karèi nèti rara iisi ne, nèngu sèmi èèna ka. Abhu kahèi dhu leo boe èmu, lula dhèu tao ne sèmi èèna. Aa abhu kahèi dhu noꞌo boe leo-èmu, lula na neo pakako sasabꞌa Ama Lamatua di. Dhèu dhu reꞌa mèu aꞌajꞌa ne, hudꞌi laa nèngu sèmi dènge beꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lodꞌo èèna, dhèu saꞌu rèti ana-ana ra asa Yesus, sèna ka Yesus tao kacui-aai Na mi rèngu, aa dènge hia lii mèngi-nale. Te ngaa ana madhutu Na kai dhèu se. ");
INSERT INTO nfa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hèia Yesus nasa dènge ana madhutu Na, ka Na lii, aku Nèngu na, “Hudꞌi laa ana se mai asa Jaꞌa! Baku bhabhae si! Te dhèu dhu sèmi rèngu seꞌe ka, dhu jꞌajꞌi dhèu unu Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Èle èèna ka Yesus tao kacui-aai Na mi ana se, aa Na manèngi ho Ama Lamatua hia si mèngi-nale. Èle, hèia Yesus pakèdꞌi laꞌe, tèke eele era èèna. ");
INSERT INTO nfa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ca tèke, dhèu èci mai karèi Yesus, peka na, “Ama Mese! Jaꞌa hudꞌi tao ku jꞌara dhu hua iia tasamia, sèna ka keꞌa tareꞌa, na, jaꞌa bisa maso sorga? Te jaꞌa neo mamuri taruu sama-sama dènge Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hèia Yesus dhaa, peka na, “Nga tao ka, èu karèi Jaꞌa lula-nèti ngaa dhu hua iia? Dhodhoka Ama Lamatua di, dhu hua iia. Te ladhe èu neo mamuri taruu dènge Ne, na, mamuri la madhutu paredha Na.” ");
INSERT INTO nfa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ka dhèu ne karèi hari, aku nèngu na, “Paredha dhu mia èèna?” Hèia Yesus bꞌala ne, peka na, “Baku pamadhe dhèu; baku tao jꞌara makae dènge dhèu dhu dhèu èmu boe èu; baku manaꞌu; baku jꞌajꞌi sakasii dhu kapodꞌe-kabèli; ");
INSERT INTO nfa_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pakabꞌua ina-ama mu; aa sue ku dhèu èu, sama sèmi èu sue ngiꞌu èu mesa mu.” ");
INSERT INTO nfa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dhèu ne dhaa, na, “Paredha aaꞌi-aaꞌi sèra jaꞌa tao madhutu le. De, ngaa hari dhu kura?” ");
INSERT INTO nfa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ropa tadèngi lii dhèu ne, hèia Yesus peka na, “Ladhe èu neo madhutu aaꞌi dadꞌèi Ama Lamatua, lèpa ho pahia aaꞌi mèdha-panyau èu, sèna ka papala hia dhèu dhu dènge boe ngaa-ngaa sèra. Èle èèna, mai ho madhutu Jaꞌa. Te èèna na, Ama Lamatua pala hia èu mèdha-panyau ae-ae ètu sorga.” ");
INSERT INTO nfa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ropa na tadèngi nare lii Yesus, hèia dhèu ne lèpa dènge dꞌara pèdꞌa laho mae-mae, lula nèngu kaja titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Èle èèna, ka Yesus padhai lii dènge ana madhutu Na, aku Nèngu na, “Lèka la Jaꞌa, te dhèu kaja carui titu kèna maso sorga. ");
INSERT INTO nfa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Carui èèna, nuka sèmi badha onta dhu kapai, maso laꞌe asa dꞌara oka na re roꞌa jꞌajꞌau.” ");
INSERT INTO nfa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ropa ana madhutu se tadèngi rare, rèngu malaa, hèia ra dhaa, peka na, “Ladhe sèmi èèna, cee ka dhu bisa maso sorga?” ");
INSERT INTO nfa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hèia Yesus ladhe patae si, ka Na lii, peka na, “Ladhe dhèu rai-haha dhu tao, mema bisa boe. Te ngaa ladhe Ama Lamatua ka dhu tao, aaꞌi-aaꞌi bisa jꞌajꞌi!” ");
INSERT INTO nfa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hèia Petrus pasanèdꞌe, aku nèngu na, “Ama! Jiꞌi se tèke eele le mèdha-panyau jiꞌi aaꞌi-aaꞌi, ho madhutu Ama. De jiꞌi abhu ngaa?” ");
INSERT INTO nfa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na dhaa, peka na, “Parcaya la Jaꞌa ne! Pe dꞌai lodꞌo Ama Lamatua tao pahiu aaꞌi mèu-mèu, Jaꞌa Dhèu Rai-haha Tareꞌa-reꞌa ne, madhèdi ètu dedha kadera paredha aae èèna. Lodꞌo èèna kahèi, miu dhu madhutu Jaꞌa, madhèdi kahèi ètu dedha kadera paredha canguru dua sèra, sèna ka jꞌajꞌi hakim mi canguru dua suku èdhi dhèu Israꞌel! ");
INSERT INTO nfa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dhèu dhu tèke eele èmu na, aꞌari na, ina-ama na, ana niki na, aa oka-tedhe na, ho madhutu Jaꞌa, bèli-camèdꞌa èèna abhu hari cangasu kali. Aa dꞌai ka lodꞌo èle rai-haha ne, nèngu kahèi abhu mamuri taruu dènge Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","De sanèdꞌe paie! Madhutu ngangee Ama Lamatua, dhèu ae dhu padedha iisi na, rèngu sèra ka dhu jꞌajꞌi mi ana iiki. Te ngaa dhèu dhu peka na, nèngu dhèu haha, aa te ngaa madhutu aꞌabhu Lamatua, nèngu ka dhu kapai.” ");
INSERT INTO nfa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Èle èèna, ka Yesus ajꞌa peka na, “Paredha Ama Lamatua èci èèna ka dènge lii pakasame ne: abhu ca dhèu lamatua oka anggor, dhu kèdꞌi madꞌae aae dꞌara hake èna sa. Na laꞌe tenge dhèu sèna ka sabꞌa ètu dꞌara oka na. ");
INSERT INTO nfa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na abhu dhèu sabꞌa, hèia rare lii èci, ho sabꞌe dꞌara ca lodꞌo, babꞌae na, ca doi iia. Dhèu se dꞌèi kahèi, ka lamatua oka ne pua lasi sabꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pe dꞌara hake ceo sa, laꞌe asa dꞌara pasa. Ètu era nèi, nèngu paraga dènge dhèu pèri-pèri dhu madhèdi iia dꞌara. ");
INSERT INTO nfa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hèia na lii dènge ra, ‘Miu se neo sabꞌa ètu dꞌara oka jaꞌa, do? Pe jaꞌa bꞌae miu madhutu kabꞌua dhu lèke.’ Ropa tadèngi rare, roꞌo kahèi, hèia lasi dènge ka sabꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dꞌai lodꞌo titu mera sa, dènge hake tèlu lodꞌo nihia, lamatua oka ne laꞌe tenge hari dhèu sabꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dꞌara hake lèmi lodꞌo nihia sa, laꞌe hari. Na laladhe, na, abhu dhèu dhu titu iia dꞌara era. Ka na lii dènge ra, aku nèngu na, ‘Nga tao ka karèi nèti madꞌae toke sange neꞌe ne, miu se titu iia dꞌara, sabꞌa boe ngaa-ngaa?’ ");
INSERT INTO nfa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ka dhèu se dhaa, peka na, ‘Ama, ee! Abhu boe ca dhèu sa dhu hia jiꞌi sasabꞌa.’ Ka lamatua oka ne peka, ‘Ladhe sèmi èèna, lami sabꞌa asa dꞌara oka jaꞌa!’ ");
INSERT INTO nfa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Toke dꞌai èle jam sabꞌa, hèia lamatua oka ne pua madho na, peka na, ‘Paroa dhèu sabꞌa se, sèna ka bꞌae rui sasabꞌa ra èci-èci. Mulai nèti dhèu sabꞌa limuri tèka, toke dhèu sabꞌa uuru.’ ");
INSERT INTO nfa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ka madho ne paroa uuru dhèu dhu sabꞌa hake lèmi nihia. Na bꞌae si ca dhèu, ca doi iia. ");
INSERT INTO nfa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Èle ka, na paroa dhèu sabꞌa dhu leo sèra, toke dhèu dhu sabꞌa mulai nèti hake èna madꞌae deo na. Dhèu se, pangee na, ele boe rèngu abhu risi nèti dhèu dhu sabꞌa hake lèmi nihia. Reꞌa boe na, rèngu abhu kahèi ca dhèu, ca doi iia. ");
INSERT INTO nfa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ropa ra sèmi rare, hèia ra kaꞌugu dènge lamatua oka èèna, aku rèngu na, ");
INSERT INTO nfa_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ira, iii! Bisa boe sèmi neꞌe, ama! Rèngu dhu mai limuri tèka, dhoka sabꞌa ca jam di. Te ngaa jiꞌi dhu karèi madꞌae aae ka, sabꞌa toke èi kabhèsu hae! Te ngaa tasamia ka ama bꞌae jiꞌi èci èèna ka dènge rèngu se?’ ");
INSERT INTO nfa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hèia lamatua oka ne dhaa, na, ‘Angalai! Jaꞌa tipu boe èu. Lula èu mesa mu moꞌo kahèi sabꞌa ètu dꞌara ca lodꞌo dhu babꞌae na ca doi iia. Tareꞌa si? De jaꞌa bꞌae madhutu sèmi lii pamaꞌète èdhi dua ti, si? ");
INSERT INTO nfa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","De beꞌa risi more doi jꞌajꞌèra èu ho lèpa ka. Ladhe jaꞌa neo bꞌae mi dhèu dhu sabꞌa limuri tèka nèti èu, èci èèna ka dènge jaꞌa neo bꞌae èu, èèna na madhutu dadꞌèi jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Lula doi-dhari jaꞌa, jaꞌa bisa pake madhutu dadꞌèi dꞌara jaꞌa. Tasamia ka, angalai nasa lula babeꞌa dꞌara jaꞌa?’ ");
INSERT INTO nfa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sèmi èèna kahèi, lodꞌo Ama Lamatua jꞌajꞌi Dhèu Aae mi dhèu aaꞌi-aaꞌi. Na pala-bagi hia dhèu-dhèu unu Na, madhutu dadꞌèi dꞌara Na. De dhèu dhu mai limuri tèka, èèna na abhu pala sama sèmi dhèu dhu mai uuru. Aa dhèu dhu mai uuru, pe na abhu pala nuka sèmi dhèu dhu mai limuri tèka.” ");
INSERT INTO nfa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Èle ka, Yesus si mulai lasi asa Yerusalem. Ètu talora jꞌara Na paroa ana madhutu Na, sèna ka rèngu mesa ra di. Ka Na lii hari, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mi nanene paie! Neꞌe ne, èdhi lati asa Yerusalem. Te ngaa ètu nèi dhèu pahie Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, asa kètu agama Yahudi dènge mese agama sèra. Èle èèna, ra huku pamadhe Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Hèia ra soro Jaꞌa asa dhèu leo rai kara dhu tadhe boe Ama Lamatua. Ka ra padhai lii pamakae Jaꞌa, aa ra hake paru isi Jaꞌa. Èle èèna, heka ra paku pamadhe Jaꞌa ètu ajꞌu palolo-palèbha. Jaꞌa tareꞌa-reꞌa madhe, te ngaa asa camèdꞌa èèna, Jaꞌa mamuri hari.” ");
INSERT INTO nfa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hèia dhèu èmu Sabadeus palere-lere dènge ana na, Yohanis dènge Yakobis, lasi paraga dènge Yesus. Ka na patitu kètu urutuu ho neo pamako Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ka Yesus karèi ne, “Mama neo ngaa?” Hèia na dhaa, “Sèmi neꞌe, Ama! Lodꞌo Ama mèdꞌu paredha, jaꞌa manèngi sèna ka Ama dedꞌe ana jaꞌa dhèu dua se rèdꞌu paredha sama-sama dènge Ama. Jaꞌa manèngi ho Ama hia ca dhèu madhèdi re baboa gꞌana, aa ca dhèu re baboa kariu Ama.” ");
INSERT INTO nfa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ropa tadèngi lii manèngi ne, hèia Yesus peka Yakobis dènge Yohanis, na, “Miu se, meꞌa boe ngaa dhu miu manèngi. Te bèli-camèdꞌa Jaꞌa abhu jꞌajꞌèra ae-ae. De tasamia? Miu pangee na, miu bisa pasae kahèi jꞌajꞌèra se, sama-sama dènge Jaꞌa, do?” Dua ra dhaa dhu dènge boe pake ngangee, aku rèngu na, “Oo, bisa, Ama!” ");
INSERT INTO nfa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka Yesus lii dènge ra, “Mema, èèna na miu pasae jꞌajꞌèra kahèi sèmi Jaꞌa. Te ngaa bèli-camèdꞌa cee ka dhu madhèdi ètu baboa gꞌana do kariu Jaꞌa, Jaꞌa dènge boe hak ho pamaꞌète. Èèna hak Ama Lamatua. Na pamaꞌète nare le, cee-cee ka dhu madhèdi ètu era sèra.” ");
INSERT INTO nfa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ropa ana madhutu dhèu canguru sèra tadèngi lii manèngi dua ra, hèia ra nasa. ");
INSERT INTO nfa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Te ngaa Yesus paroa nare si aaꞌi-aaꞌi ra, hèia Na peka, “Sèmi neꞌe! Miu dhu meꞌa le, si? Dhèu aae-dhèu kapai dhu rèdꞌu paredha, ènyi kabarai ra toke ra bisa boe kalau sa kahèi. Aa dhèu kapai kabarai ètu rai-haha ne, dhu tadhe boe Ama Lamatua, hia paredha risi eele, toke kabarai ra abhu boe dꞌoa kètu ciki sa. ");
INSERT INTO nfa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Te ngaa baku miu tao sèmi èèna! De nèti miu se cee ka dhu neo jꞌajꞌi dhèu aae-dhèu kapai, nèngu hudꞌi jꞌajꞌi ku nuka sèmi ènu, sèna ka lalau dhèu leo. ");
INSERT INTO nfa_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aa cee dhu neo jꞌajꞌi kètu, nèngu hudꞌi tao iisi na nuka sèmi ènu. ");
INSERT INTO nfa_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nanene! Jaꞌa sèmi èèna kahèi. Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, mai sèna ka ladhe-leru dhèu. Jaꞌa mai boe, sèna ka dhèu lalau-laloꞌo Jaꞌa. Te mamai Jaꞌa ne, sèna ka soro ngiꞌu Jaꞌa kateme iisi, ho sui dhèu ae nèti sasala-sasigo ra.” ");
INSERT INTO nfa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ka Yesus si kako taruu. Ropa rèngu kalua nèti kota Jeriko, dhèu ae dhu madhutu rèngu. ");
INSERT INTO nfa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ètu èèna, abhu dhèu bèdhu dhèu dua dhu madhèdi ètu sebhe jꞌara. Ropa dua ra tadèngi na, Dhèu dhu kako re èèna, nuka Yesus nèti Nasaret, hèia ra parodha, peka na, “Ama! Ana-èpu Daud! Jiꞌi se dhu tatae Ama, karèi nèbhu ka! Sue ku jiꞌi la!” ");
INSERT INTO nfa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ropa dhèu tadèngi ra parodha sèmi èèna, ka ra kai si, aku rèngu na, “Hee! Miu dua mi baku maruru!” Te ngaa dua ra asa hino, peka na, “Ama! Ana-èpu Daud! Sue ku jiꞌi la!” ");
INSERT INTO nfa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ropa Yesus tadèngi lii paroa ne, hèia Na titu, ka karèi si, peka na, “Miu se neo sèna ka Jaꞌa tao ngaa hia miu?” ");
INSERT INTO nfa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka dua ra dhaa, na, “Ama! Hia la jiꞌi se bisa ngèdhi!” ");
INSERT INTO nfa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tadèngi lii dhaa dua ra, hèia Yesus rasa kasia. Ka Na gꞌagꞌe musi madha ra, hèia dua ra rèdhi dènge ka. Èle ka, dua ra lasi dènge madhutu Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ka Yesus si lasi taruu, dꞌai rae Betfage, ètu sebhe ledhe Saitun. Rae ne dhu dètu le dènge kota Yerusalem. Ètu era neꞌe, rèngu ae taha. Hèia Na pua ana madhutu Na dhèu dua lasi uuru. ");
INSERT INTO nfa_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Na paredha si, peka na, “Dua mi lami asa rae nèi. Ladhe miu dꞌai nèi, miu ladhe mèdhi keledꞌei rena ciꞌu dènge ana na dhu ra èki ètu era èèna. Lami lècu mere ne, ho mèti mai hia Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te ngaa ladhe dhèu karèi miu, peka na, ‘Nga tao ka miu ère mèti keledꞌei dhèu?’ Mi dhaa, peka na, ‘Lamatua neo pake ne. Ladhe pake nare, pe Na hia hari mai.’ ");
INSERT INTO nfa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aaꞌi-aaꞌi se hudꞌi jꞌajꞌi ku sama sèmi lii padhai nèti dhèu rèti lii padhai Ama Lamatua, dhu suri tèke, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Miu dhèu Yerusalem sèra! Mai laladhe ku la! Te Dhèu Aae miu mai. Na mai dènge pahaha iisi. Na mai dhu manyaꞌe keledꞌei ngèru.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ka ana madhutu Na lasi ka, aa ra tao madhutu aaꞌi dhu Yesus moa le dènge ra. ");
INSERT INTO nfa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ère rèti keledꞌei rena dènge ana na asa Yesus. Èle ka, ra hèle sigꞌi-kalolo, hèia Yesus manyaꞌe, lasi asa dꞌara kota. ");
INSERT INTO nfa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ropa rèngu oe dꞌai dꞌara kota, hèia dhèu ae ka dhu hèle sigꞌi-kalolo dènge salalu ra mi jꞌara. Abhu kahèi cahagꞌe lasi pare rèu palam, ho ra tao ètu talora jꞌara. Dènge jꞌara neꞌe, rèngu tao tadha dhu peka na, rèngu soru Yesus sama sèmi dhèu kapai. ");
INSERT INTO nfa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abhu kahèi dhèu cahagꞌe dhu kako uuru nèti Yesus, aa cahagꞌe kako re limuri. Dhèu se paꞌoo-parodha palere-lere, peka na, “Hosana! Jiꞌi koa-kio Ama Lamatua! Lula ana-èpu Daud mai le! Hosana! Jiꞌi koa-kio Ama Lamatua! Lula Ama Lamatua ka dhu pua Dhèu neꞌe mai. Hosana! Jiꞌi koa-kio Ama Lamatua! Lula Ama Lamatua dhu nèdꞌu mema paredha ètu dedha-liru dhu dedha risi!” ");
INSERT INTO nfa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ropa Yesus maso asa Yerusalem dènge dhèu dhu pakelu oobꞌa, hèia isi kabarai aaꞌi-aaꞌi ètu dꞌara kota kalua mai, ka ra pakarèi, peka na, “Ira ii! Cee ka dhu mai ne?” ");
INSERT INTO nfa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dhèu ae se dhaa, aku rèngu na, “Nèngu ne, Dhèu nèti lii padhai Ama Lamatua. Ngara Na Yesus, dhèu Nasaret, nèti propensi Galilea.” ");
INSERT INTO nfa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ka Yesus si lasi taruu asa dꞌara Èmu Kapua Manèngi-Mangajꞌi Ama Lamatua. Ètu madha Èmu Manèngi-Mangajꞌi ne, dhèu tao nuka sèmi pasa, ho pahia-pahèli koro jꞌaha dhu dhèu tema pake jꞌajꞌi mèdha korban lodꞌo sabajꞌa. Ropa ladhe nèdhi sèmi èèna, hèia Yesus babèga eele si nèti era èèna. Na lege eele mei-mei dhu ra pake pasilu doi, aa Na paguri eele bagu-bagu dhu ra pake pahia manu-bhui. ");
INSERT INTO nfa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hèia Yesus peka dènge dhèu seꞌe, aku Nèngu na, “Dhèu rèti lii padhai Lamatua dhu suri tèke le, peka na, ‘Jaꞌa patitu Èmu ne, sèna ka dhèu mai manèngi-mangajꞌi ètu neꞌe.’ Dadꞌèi Lamatua sèmi èèna ka, te ngaa miu tao Èmu ne, nuka sèmi era kaboko dhèu parapo!” ");
INSERT INTO nfa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Èle, ka dhèu bèdhu dènge dhèu karuku mai sa Yesus ètu Èmu Sabajꞌa Ama Lamatua. Ka Na puri-paꞌèle aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ètu era neꞌe, abhu kahèi kètu agama Yahudi dènge mese agama sèra. Ropa rèdhi Yesus tao tadha malaa, hèia ra kaꞌuu-kamuki. Risi-risi hari, ropa ra tadèngi ana-ana paꞌoo palere-lere ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi ne, dhu peka na, “Hosana! Jiꞌi koa-kio Ama Lamatua! Lula ana-èpu dhèu aae Daud mai le!” ");
INSERT INTO nfa_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ka kètu kapai se lii dènge Yesus, aku rèngu na, “Eeh! Èu tadèngi lii padhai lii ana-ana se? Èèna lèke boe!” Te ngaa Yesus bꞌala si, na, “Oo, Jaꞌa tadèngi. Te, nga tao? Miu baca mèdhi mèka ètu dꞌara Sasuri Mola-Mèci Ama Lamatua lula-nèti ana-ana dhu koa-kio Ama Lamatua, do? Te ètu dꞌara sasuri èèna dhu suri, na, ‘Ama Lamatua dhu sadia nare le, ana rara iisi hiu, dènge ana-ana iiki, ho koa-kio Ne.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Hèia Yesus si tèke eele kota ne, lasi jꞌunu asa rae Betania. ");
INSERT INTO nfa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Asa bèli madꞌae aae na, Yesus si lèpa hari asa kota Yerusalem. Te ngaa ètu talora jꞌara, Nèngu manganga le. ");
INSERT INTO nfa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na ladhe nèdhi ajꞌu ca kapua buli sebhe jꞌara dhu dhèu tema raꞌa hua na. De laꞌe ka padètu-dètu dènge ajꞌu neꞌe, ho neo ladhe sèku dhu hua le, do dhae. Te ngaa ropa dꞌai kapua aajꞌu ne, Na nèdhi boe hua cue sa, lula rèu heka subꞌu mai kèna. Hèia Na peka mi ajꞌu ne, aku Nèngu na, “Lula èu hia boe Jaꞌa hua cue sa, de èèna na èu hua heka!” Ropa Na lii nare sèmi èèna, hèia ajꞌu ne mango dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ropa ana madhutu Na ladhe rèdhi jꞌara ne, hèia ra malaa. Ka ra karèi, peka na, “Tasamia ka ajꞌu ne mango?” ");
INSERT INTO nfa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hèia Yesus dhaa, na, “Nanene paie-iie! Ladhe miu lèka tareꞌa-reꞌa Lamatua, aa dènge boe dꞌara kajari, miu kahèi bisa tao sama sèmi dhu Jaꞌa tao ne. Miu bisa tao risi hari nèti neꞌe. Sèmi: miu bisa paredha ledhe pidha asa dꞌara dhasi laꞌe. Tatu Ama Lamatua pidha eele kahèi ledhe ne nèti era na, sadꞌi miu parcaya Nèngu tareꞌa-reꞌa! ");
INSERT INTO nfa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te aaꞌi-aaꞌi dhu miu manèngi nèti Ama Lamatua, èèna na miu abhu, sadꞌi miu parcaya Ne tareꞌa-reꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Dꞌai Yerusalem, Yesus si maso hari asa Èmu Kapua Manèngi-Mangajꞌi. Ropa Nèngu ajꞌa dhèu madha jꞌara Ama Lamatua, hèia kètu agama Yahudi, mese agama sèra, dènge dhèu heka-dhèu heka adꞌa, mai karèi Yesus, na, “Medꞌa na, cee ka dhu pua Èu tao maruru ètu era neꞌe ne? Cee ka dhu hia Èu hak?” ");
INSERT INTO nfa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Te ngaa Yesus dhu neꞌa, na, dhèu se dhu neo pamanahu Ne. Hèia Na bꞌala, aku Nèngu na, “Jaꞌa neo karèi miu kahèi. Miu dhaa uuru ku, heka Jaꞌa dhaa miu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Lii karèi Jaꞌa sèmi neꞌe ka: miu aaꞌi-aaꞌi mi tadhe Yohanis tuka sarani, si? Cee ka dhu hia ne hak, ho sarani dhèu? Ama Lamatua do, dhèu rai-haha?” Ka ra papeka isi-aanga ra, aku rèngu na, “Waa! Nara le èdhi, nga! Ladhe èdhi dhaa, peka na, ‘Ama Lamatua ka dhu hia hak’, pe Na bꞌala èdhi, peka na, ‘Ladhe sèmi èèna, nga tao ka miu parcaya boe Yohanis!’ ");
INSERT INTO nfa_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te ngaa ladhe èdhi dhaa na, ‘Dhèu rai-haha ka dhu hia hak’, mage dhoka dhèu aaꞌi-aaꞌi patao dènge èdhi. Lula rèngu parcaya, na, Yohanis ne, dhèu nèti lii padhai Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nèti èèna ka, ra dhaa peka na, “Jiꞌi ngeꞌa boe.” Hèia Yesus bꞌala si, aku Nèngu na, “Ladhe sèmi èèna, Jaꞌa parluu boe peka na, cee ka dhu hia Jaꞌa hak.” ");
INSERT INTO nfa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus padhai lii taruu dènge kètu kapai sèra, aku Nèngu na, “Miu pangee sèku dènge lii lolo ne. Abhu ca dhèu ama, dènge ana mone na dhèu dua. Na peka dènge ana uuru èèna, ‘Ana, deo neꞌe èu lamu sabꞌa asa dꞌara oka.’ ");
INSERT INTO nfa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te ngaa ana ne dhaa, aku nèngu na, ‘Eeh! Jaꞌa laku boe.’ Te ngaa nèbhu boe ka, na manyasa, ka laꞌe. ");
INSERT INTO nfa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ka ama ra pua ana limuri, peka na, ‘Deo neꞌe, èu lamu sabꞌa asa dꞌara oka.’ Ka ana ne dhaa, aku nèngu na, ‘Beꞌa, ama! Pe jaꞌa laku.’ Te ngaa teꞌa boe na, nèngu dhu laꞌe boe.” ");
INSERT INTO nfa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ropa lole nare, hèia Yesus karèi dhèu seꞌe, peka na, “Jaꞌa neo karèi sèmi neꞌe: nèti ana dhèu dua se, mia ka dhu tao madhutu lii paredha ama ra?” Hèia ra dhaa, aku rèngu na, “Ana uuru!” Ka Na peka, aku Nèngu na, “Oo. Te ngaa nanene paie, te Jaꞌa peka dhu lèke kèna. Te dhèu dhu miu cap, na, dhèu dhu laku-laku boe, sama sèmi dhèu roro bea, dènge bhèni kajeo, bèli-camèdꞌa rèngu seꞌe ka dhu jꞌajꞌi uuru dhèu unu Ama Lamatua, nèti miu. Te miu dhoka sadꞌi dhaa di, peka na, ꞌooꞌ mi Ama Lamatua, te ngaa tao boe madhutu dadꞌèi Na. ");
INSERT INTO nfa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Uru èèna, Yohanis tuka sarani, ajꞌa le miu jꞌara tasamia, sèna ka miu bisa mamuri mola. Te ngaa miu parcaya boe ne. Aa te ngaa ropa dhèu laku-laku boe sèra, nanene lii aꞌajꞌa nèti Yohanis, rèngu tèke eele sasala ra, sèna ka tao madhutu aꞌajꞌa èèna. Miu dhu meꞌa le. Te ngaa miu loe boe nèti adꞌu-ue sasala-sasigo, ho madhutu dadꞌèi Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus lole nare, ka Na lolo hari lii pakasame èci, aku Nèngu na, “Abhu ca dhèu lamatua rai dhu laꞌe tao oka, ho sèle anggor ètu dedha rai na ca kasibꞌi. Ka na tao tedhe rai reo. Aa na tao bak cue era pacèli èi anggor. Dhèu ne patitu kahèi era madhenge dhu dedha aae èci. Èle, ka na hia oka ne mi dhèu sebꞌa, sèna ka dꞌai hèru puu-gꞌètu, ra pabagi èi anggor. Hèia laꞌe ka asa rai kajꞌèu. ");
INSERT INTO nfa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ropa dꞌai hèru puu-gꞌètu, lamatua oka ne pua dhèu sabꞌa na, lasi asa dhèu sebꞌa se, sèna ka rare pala nèngu. ");
INSERT INTO nfa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Te ngaa dhèu sebꞌa oka seꞌe, pusi-pahae boe dènge dhèu-dhèu sabꞌa nèti lamatua oka ne. Abhu dhu lèke game, abhu dhu ra pamadhe, aa abhu dhu lèke pèci dènge hadhu. ");
INSERT INTO nfa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ka lamatua oka ne pua hari dhèu sabꞌa na canau, ae risi nèti dhèu sabꞌa dhu lasi uuru sèra. Te ngaa dhèu sebꞌa oka se tao hari bhabhelu sèmi èèna kahèi mi dhèu sabꞌa se aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nèbhu-nèbhu ka lamatua oka ne, pua ana dꞌèlu na laꞌe. Na pangee, na, ‘Ladhe jaꞌa pua ana dꞌèlu jaꞌa laꞌe, tatu ra sèmi na dènge beꞌa, aa ra pakabꞌua ne kahèi.’ ");
INSERT INTO nfa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Te ngaa ropa dhèu sebꞌa se ladhe rèdhi ana ne, hèia ra papeka, ‘Wee, mi laladhe ku laa! Te mone heka nèi hia ana dꞌèlu na mai. Nèngu neꞌe ka dhu bèli-camèdꞌa, unu aaꞌi mèdha-panyau mone heka ne. De ta pamadhe ne, sèna ka èdhi unu oka ne.’ ");
INSERT INTO nfa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hèia kèpe rare ana ne, ka ra nuni asa liꞌu oka, hèia ra pamadhe ne.” ");
INSERT INTO nfa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ka Yesus paꞌèle lii lolo Na, ka Na karèi dhèu seꞌe, aku Nèngu na, “Jaꞌa neo karèi miu sèmi neꞌe: ladhe lamatua oka ne lèpa mai, madhutu ngangee miu, na tao dhèu sebꞌa oka se tasa mera mia?” ");
INSERT INTO nfa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Hèia kètu kapai Yahudi sèra dhaa, peka na, “Tatu na pamadhe dhèu bhelu se aaꞌi-aaꞌi. Èle, na hia hari dhèu leo sebꞌa oka ne, dhu èèna na pabagi dènge beꞌa, ropa dꞌai hèru puu-gꞌètu.” ");
INSERT INTO nfa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ka Yesus peka dènge ra, aku Nèngu na, “Ele boe miu se baca mèdhi boe, ngaa dhu suri tèke ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, dhu peka na, ‘Abhu hadhu cue dhu tuka hadhu core eele, te ngaa limuri ne, jꞌajꞌi le hadhu era padhèdi èmu! Ama Lamatua mesa Na ka dhu kabhili nare, aa Na pamadhèdi hadhu ne. Nèti èèna ka, èdhi ladhe na beꞌa titu kèna!’ ” ");
INSERT INTO nfa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Èle èèna ka, Yesus tuhu hari lii padhai Na, peka na, “De miu sanèdꞌe paie-iie. Uru èèna, Ama Lamatua hagꞌe nare èdhi dhèu Yahudi se, ho jꞌajꞌi dhèu unu Na. Te ngaa, lula miu pusi-pahae boe Jaꞌa, èèna na Lamatua pili nare dhèu leo rai kara. Te dhèu dhu mamuri madhutu dadꞌèi Na, dhu nia jꞌajꞌi dhèu unu Na. ");
INSERT INTO nfa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jaꞌa peka paledꞌa-ledꞌa dènge miu. Jaꞌa ka, hadhu padhèdi èèna. Dhèu dhu bèbhe lèke hadhu ne, èèna na nèngu laho kao-kao. Aa ladhe hadhu ne bèbhe lèke dhèu, èèna na dhèu ne laho kao-kao.” ");
INSERT INTO nfa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ropa kètu kapai Yahudi dènge dhèu Parisi tadèngi lii padhai Yesus, hèia reꞌa, na, lii ne padhèto dènge rèngu. Rèngu se ca ropa dènge dhèu sebꞌa oka anggor, aa dènge tuka dhu core eele hadhu era padhèdi èmu. ");
INSERT INTO nfa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","De ra nasa titu kèna. Ka rèngu mulai tenge jꞌara ho kèpe Ne. Te ngaa rèngu madhaꞌu dènge dhèu ae, dhu peka na Yesus ne, Dhèu nèti lii padhai Ama Lamatua. Nèti èèna ka, rèngu bani boe tao ngaa-ngaa mi dedha Nèngu. ");
INSERT INTO nfa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ka Yesus padhai lii hari dènge rèngu pake lii upama, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Paredha Ama Lamatua èèna, nuka sèmi dhèu aae ca dhèu dhu tao pesta kabꞌi ana mone na. ");
INSERT INTO nfa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ropa dhèu pananasu rare, hèia na pua dhèu sabꞌa na, sèna ka lasi peka dhèu-dhèu dhu abhu nèru, ra peka na, ‘Mai ka, te dꞌai tadha taꞌa-tinu kèna.’ Te ngaa dhèu dhu abhu nèru se roꞌo boe mai. ");
INSERT INTO nfa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Hèia dhèu sabꞌa se lèpa, lasi peka dènge dhèu aae. Ropa na tadèngi, hèia dhèu aae pua dhèu sabꞌa na dhu leo hari, aku nèngu na, ‘Lami peka hari dènge dhèu sèra ho mai ka, te pesta neo mulai kèna. Jaꞌa para sapi, ka pananasu kore le dhu beꞌa titu kèna. Peka si mai ka, raꞌa-rinu, te aaꞌi-aaꞌi tesa le.’ ");
INSERT INTO nfa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dhèu sabꞌa se lasi peka sèmi dhu dhèu aae moa èèna. Te ngaa dhèu dhu lèke nèru se, pusi-pahae boe. Abhu dhu lasi ladhe oka ra, abhu dhu lasi era sasabꞌa ra, ");
INSERT INTO nfa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","aa cahagꞌe hari ra kèpe rare dhèu sabꞌa se nèti dhèu aae ne, ho ra game toke madhe. ");
INSERT INTO nfa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ropa na tadèngi, hèia dhèu aae nasa bia. Ka na paredha sordadꞌu na, lasi pamadhe aaꞌi dhèu-dhèu dhu pamadhe dhèu sabꞌa na sèra. Hèia sordadꞌu se tunu pakèpu-ladhu ai kota ne toke mera dènge rai. ");
INSERT INTO nfa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Èle, ka dhèu aae paroa nare dhèu sabꞌa dhu leo sèra, ka na peka, ‘Pesta kabꞌi ne tesa aaꞌi le, te ngaa dhèu-dhèu dhu jaꞌa nèru, nia boe madhèdi ètu dꞌara pesta jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","De lami ka asa jꞌara oka-hoo, sèna ka nèru cee dhu sadꞌi miu paraga.’ ");
INSERT INTO nfa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ka dhèu sabꞌa se lasi asa jꞌara oka-hoo. Hèia rèti mai dhèu ae-ae dhu ra paraga ètu jꞌara, sèna ka raꞌa-rinu ètu pesta kabꞌi ne. Dhèu seꞌe, nuka dhèu dhu beꞌa dènge dhèu dhu bhelu-katubꞌa, mai papènu ètu era kakabꞌi ne. ");
INSERT INTO nfa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ka dhèu aae laꞌe asa era pesta ne ladhe palème tamu sèra. Hèia ladhe nèdhi tamu ca dhèu dhu pake boe mèdha-papake pesta. ");
INSERT INTO nfa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ka dhèu aae karèi ne, peka na, ‘Hee, angalai! Èu nga tao ka mai asa neꞌe pake boe mèdha-papake pesta?’ Te ngaa dhèu ne loo-loo sène. ");
INSERT INTO nfa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hèia dhèu aae paredha dhèu-dhèu sabꞌa na, aku nèngu na, ‘Ujꞌu haga dènge ai dhèu neꞌe ne, ho core ne asa liꞌu laꞌe. Hudꞌi laa na tangi dènge abhu jꞌèra ètu era dhu maroga kiu-kiu nèi.’ ");
INSERT INTO nfa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sèmi èèna kahèi, Ama Lamatua paroa dhèu ae, te ngaa dhodhoka dhu ciki di dhu kabhili nare jꞌajꞌi dhèu unu Na.” ");
INSERT INTO nfa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ropa tadèngi rare lii padhai Yesus, hèia dhèu-dhèu Parisi rare lii èci ho neo pamanahu aa galaa Ne. ");
INSERT INTO nfa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ka dhèu se pua dhèu rèngu palere-lere dènge dhèu-dhèu nèti partei politik Herodes, sèna ka lasi pakarèi dènge Yesus. Dhèu se koa-kadꞌiri Yesus, peka na, “Ama Mese! Jiꞌi ngeꞌa dꞌara Ama mola. Ama dhu meꞌa boe kapodꞌe-kabèli, aa dhu ladhe boe rèhu dhèu. Ama dhu tema ajꞌa-nori Lii Holo-Nori Ama Lamatua dènge boe koe-kapengo. ");
INSERT INTO nfa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mamai jiꞌi ne, neo karèi jꞌara èci. Madhutu atora agama Yahudi, èdhi bisa bꞌae bea mi dhèu aae kapai Roma, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Te ngaa Yesus neꞌa mema, na, rèngu neo madulu dꞌara Na, sèna ka Nèngu padhai lii labꞌa dhèu paredha Roma. Hèia Yesus dhaa, aku Nèngu na, “Miu mema dhèu hoꞌa tema! Tasamia ka miu neo pamanahu Jaꞌa dènge jꞌara neꞌe? ");
INSERT INTO nfa_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Padꞌelo sèku Jaꞌa doi iia cue, dhu dhèu pake ho bꞌae bea!” Hèia ra padꞌelo doi iia ne mi Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ka Na karèi si, “Neꞌe ne, rèhu cee? Aa neꞌe ne, ngara cee?” ");
INSERT INTO nfa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ra dhaa, aku rèngu na, “Èèna keser, dhèu aae kapai paredha Roma.” Hèia Yesus peka dènge ra, na, “Ladhe sèmi èèna hia la mi dhèu paredha ngaa dhu jꞌajꞌi hak dhèu paredha. Aa hia la mi Ama Lamatua ngaa dhu jꞌajꞌi hak Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ropa ra tadèngi hèia rèngu aaꞌi-aaꞌi malaa, lula ngaa dhu Na peka sèra lèke tareꞌa-reꞌa. Nèti èèna ka, rèngu bisa boe abhu jꞌara ho pamanahu Yesus. Hèia lasi ka tèke eele Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ètu era neꞌe, abhu kahèi dhèu nèti partei Saduki. Dhèu seꞌe ka dhu ajꞌa, peka na, dhèu madhe bisa heka mamuri. Lodꞌo èèna, dhèu seꞌe kahèi dhu tenge jꞌara ho pamanahu Yesus. Nèti èèna ka, rèngu mai pakarèi dènge Ne, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ama Mese! Musa dhu suri tèke le atora hia jiꞌi, dhu peka na: ladhe dhèu mone ca dhèu madhe tèke eele dhèu èmu na dhu dènge boe ana, na, ari nèti dhèu mone ne, hudꞌi leo nare hari bhèni balu ne, sèna ka abhu kolo gati madha aꞌa na. ");
INSERT INTO nfa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mema uru èèna Musa ajꞌa sèmi èèna ka. Te ngaa jiꞌi neo karèi sèmi neꞌe: abhu ana mone dhèu pidhu dhu paꞌaꞌari. Ana partama leo-èmu, te ngaa madhe dènge boe kolo. Hèia ari na leo nare bhèni balu ne. ");
INSERT INTO nfa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nèbhu boe ka, na madhe, dènge boe ana kahèi. Sèmi èèna kahèi dènge ari ka tèlu na; nèngu madhèdi kahèi dènge bhèni balu ne, te ngaa madhe kahèi dènge boe ana. Sèmi èèna ka toke ari na dhu limuri tèka, madhe kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ka bhèni balu ne madhe. ");
INSERT INTO nfa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","De dhu jiꞌi neo karèi, sèmi neꞌe ne: bhèni balu ne dhu leo nèdhi dènge mone dhèu pidhu se. Bèli-camèdꞌa lodꞌo èle rai-haha ne, ropa Ama Lamatua pamamuri hari dhèu madhe sèra, na, bhèni ne jꞌajꞌi mi dhèu èmu cee?” ");
INSERT INTO nfa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Èle èèna ka, Yesus bꞌala si, peka na, “Ladhe lii pakarèi miu sèmi èèna, miu se sala kapai le! Te miu se meꞌa mere boe isi sasuri Ama Lamatua. Aa meꞌa boe kahèi koasa Na dhu kapai aae èèna. ");
INSERT INTO nfa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Dhu lèke ka sèmi neꞌe! Pe Ama Lamatua pamamuri hari dhèu nèti mamadhe ra, rèngu se paleo heka èmu, sama sèmi ana pajuu Na ètu sorga dhu leo boe èmu. ");
INSERT INTO nfa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aa Jaꞌa neo peka kahèi, lula-nèti dhèu madhe bisa mamuri hari, do aadꞌo. Ètu dꞌara sasuri Musa, dhu lole na, ajꞌu iiki ca kapua dhu ai naꞌe te ngaa kèpu boe. Nèti lii lolo ne, èdhi bisa teꞌa, na, dhèu madhe bisa mamuri hari. Te ètu dꞌara sasuri èèna, Ama Lamatua peka dènge Musa, na, ");
INSERT INTO nfa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Jaꞌa ne Ama Lamatua nèti bèi-baki èu. Nuka Abraham, Isak dènge Yakob. Rèngu aaꞌi-aaꞌi ra pahaha iisi era mi Jaꞌa toke dꞌai sange neꞌe ne.’ De èdhi teꞌa, na, lodꞌo Ama Lamatua peka sèmi èèna, baki èdhi se dhu madhe nèbhu le. Te ngaa Ama Lamatua peka na, Nèngu jꞌajꞌi Lamatua rèngu era. Nèti èèna ka, èdhi dhu teꞌa na, samanga rèngu dhu mamuri era, masi ka rèngu dhu madhe nèbhu le. De masi ka madhe, te ngaa ra mamuri hari. Te dhodhoka dhèu mamuri di, dhu pahaha iisi mi Ama Lamatua, dhèu dhu madhe, aadꞌo, si?!” ");
INSERT INTO nfa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ropa ra tadèngi rare lii padhai Yesus ne, hèia dhèu Saduki se reꞌa heka bꞌala. Te ngaa dhèu ae se malaa-maloha, ka ra papeka na, “Ira ii! Lii padhai Dhèu neꞌe ne beꞌa seli eele, nga!” ");
INSERT INTO nfa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ropa dhèu Parisi tadèngi, na, Yesus segi le dhèu Saduki, hèia ra pakaboko ho lasi pakarèi dènge Ne. ");
INSERT INTO nfa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nèti rèngu se, abhu ca dhèu dhu dꞌèlu-mèu jꞌara-jꞌara agama, laꞌe pakarèi dènge Yesus, aku nèngu na, ");
INSERT INTO nfa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ama Mese! Jaꞌa neo karèi sèmi neꞌe ka: atora nèti adꞌa dènge agama èdhi, ae dꞌai seli. Paredha aaꞌi-aaꞌi dhu nèti Musa, mia ka dhu dedha risi?” ");
INSERT INTO nfa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hèia Yesus dhaa, peka na, “Paredha dhu dedha risi ètu dꞌara Sasuri Mola-Mèci Ama Lamatua suri, peka na: ‘Ama Lamatua èèna, tareꞌa Lamatua miu. De miu se hudꞌi sue risi Ne nèti ngaa aaꞌi-aaꞌi. Nèti èèna ka, miu hudꞌi sanao-maena taruu mi Nèngu, tadhe paie Ne, dènge sabꞌa paꞌèra ho madhutu dadꞌèi Na.’ ");
INSERT INTO nfa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Neꞌe ne ka, paredha dhu dedha dènge kapai risi! ");
INSERT INTO nfa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aa abhu paredha ka dua dhu peka na: ‘Èu hudꞌi sue ku dhèu leo, nuka sèmi èu sue ngiꞌu èu mesa mu.’ ");
INSERT INTO nfa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dua paredha se, nuka kapua nèti atora Musa dènge lii ajꞌa-nori aaꞌi-aaꞌi ra nèti dhèu rèti lii padhai Ama Lamatua. Dhèu tatu boe madhutu paredha leo, ladhe nèngu madhutu uuru boe dua paredha dhu dedha risi se.” ");
INSERT INTO nfa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ropa dhèu Parisi dhu pakaboko era ètu èèna, ka Yesus karèi si, peka na, ");
INSERT INTO nfa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Karèi nèti uru ka, Ama Lamatua dhu padhadha tèke le, ho pua Kristus mai, sèna ka hia mamuri mi dhèu unu Na. De madhutu aꞌabhu miu, na, Kristus èèna ana-èpu cee?” Hèia ra dhaa peka na, “Nèngu èèna, ana-èpu nèti dhèu aae Daud.” ");
INSERT INTO nfa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus lii hari, aku Nèngu na, “Ladhe sèmi èèna, nga tao ka Roh Mola-Mèci èèna peka dènge dhèu aae Daud, na, nèngu paroa Kristus, ‘Lamatua’? Te Daud suri tèke na, ");
INSERT INTO nfa_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ama Lamatua peka mema le dènge lamatua jaꞌa, na, “Mai ho madhèdi ètu era hua iia ne, ètu baboa gꞌana Jaꞌa. Te bèli-camèdꞌa Jaꞌa tao musu-musu èu sèra, pahaha iisi mi èu.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","De nèti lii neꞌe ne, èdhi teꞌa, na, dhèu aae Daud mesa na paroa Kristus ne, ‘Lamatua’. De ladhe dhèu peka na, Kristus dhoka ana-èpu Daud di, èèna dhae dꞌai mèka. Lula Nèngu Lamatua nèti dhèu aae Daud kahèi!” ");
INSERT INTO nfa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ropa ra tadèngi lii padhai Yesus, dhèu Parisi se nuka sèmi dhèu goa sa, te ca dhèu sa bisa boe dhaa lii Yesus. Nèti èèna ka, nèti lodꞌo èèna, rèngu bani heka tenge jꞌara ho pakarèi Ne. ");
INSERT INTO nfa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Èle èèna ka, Yesus ajꞌa ana madhutu Na dènge dhèu ae leo dhu palere dènge rèngu. ");
INSERT INTO nfa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Na peka dènge ra, aku Nèngu na, “Mese agama dènge dhèu Parisi sèra abhu hak ho ajꞌa-nori atora Musa mi dhèu. ");
INSERT INTO nfa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nèti èèna ka, miu hudꞌi nanene si, aa tao madhutu lii aꞌajꞌa ra. Te ngaa mage mi madhutu ngaa dhu ra adꞌu-ue, lula rèngu mesa ra madhutu boe lii aꞌajꞌa rèngu sèra. ");
INSERT INTO nfa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rèngu laka-seti dhèu sèna ka madhutu atora agama ra dhu pabia dhèu. Te ngaa rèngu mesa ra roꞌo boe soru-bara dhèu, sèna ka madhutu atora sèra. ");
INSERT INTO nfa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aaꞌi-aaꞌi dhu ra adꞌu-ue sèra, sèna ka dhèu koa-kadꞌiri si. Nuka sèmi: ètu katanga rèi ra, dhu èki dènge mèdha èci dhu suri Lii Holo-Nori Ama Lamatua, aa ètu lele aai ra kahèi. Te ngaa rèngu tao parisi hari, sèna ka dhèu padedha si, peka na, ‘Ira ii! Dhèu se, dhèu mola!’ ");
INSERT INTO nfa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ladhe rèngu maso asa dꞌara èmu gareja, do, dꞌara pesta rèngu dꞌèi tenge era dhu beꞌa risi, sèna ka dhèu ae ladhe rèdhi si. ");
INSERT INTO nfa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ladhe lasi asa dꞌara pasa, rèngu dꞌèi dhèu pakabꞌua si. Ra tenge jꞌara, sèna ka dhèu pahaha iisi mi rèngu, aa dꞌèi dhèu paroa ra, ‘Ama mese, dhu hua iia.’ ");
INSERT INTO nfa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Te ngaa miu baku madhutu jꞌara rèngu seꞌe! Dhèu baku paroa miu ‘ama mese’, lula Mese miu dhoka ca dhèu di. Aa miu aaꞌi-aaꞌi mi seꞌe, paꞌaꞌari. ");
INSERT INTO nfa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mage jꞌoka padedha dhèu ètu rai-haha ne, peka na, ‘ama’, lula Ama miu ètu sorga dhoka èci di. ");
INSERT INTO nfa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dhèu baku paroa miu kahèi, ‘lamatua’, lula Ama Lamatua miu dhodhoka èci di, nuka Jaꞌa ne, dhu Ama Lamatua pajaji mema karèi nèti uru ka. ");
INSERT INTO nfa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nèti èèna ka, Jaꞌa pasanèdꞌe mema miu, mage padedha iisi mi, nuka sèmi dhèu dhu dꞌèi dhoka dhèu pakabꞌua ra. Nèti miu se, cee ka dhu neo jꞌajꞌi dhèu kapai, nèngu hudꞌi jꞌajꞌi ku nuka sèmi ènu, sèna ka lalau-laloꞌo dhèu leo. ");
INSERT INTO nfa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te dhèu dhu pamone-pabhèni, èèna na Lamatua pamanahu ne. Te ngaa dhèu dhu pahaha iisi nuka sèmi ana iiki, bèli-camèdꞌa Lamatua dedꞌe padedha ne.” ");
INSERT INTO nfa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ka Yesus tuhu hari lii padhai Na, aku Nèngu na, “Hee, miu mese agama dènge dhèu Parisi se! Miu mema dhèu dhu padhai lii leo, tao leo! Bèli-camèdꞌa miu dui mere pala miu, lula miu moꞌo boe parcaya Jaꞌa, nuka Dhèu dhu Ama Lamatua pamoa tèke pua mai. Aa dhu bhelu risi hari, miu bhabhae dhèu neo mai asa dꞌara rai paredha Ama Lamatua, sèna ka ra baku parcaya Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Hee, miu mese-mese agama dènge dhèu-dhèu Parisi! Mema miu dhèu dhu padhai lii leo, tao leo! Bèli-camèdꞌa miu pasae mere mamadhe-mamopo, lula miu dꞌèi kapodꞌe-kabèli bhèni balu, sèna ka parame mere èmu ra. Te ngaa ètu madha dhèu ae, miu paꞌabhe bhabhelu miu, dènge jꞌara sabajꞌa panèbhu-nèbhu, ho dhèu peka na, miu dhèu dꞌara mola. Te ngaa èèna na, Ama Lamatua hia huku dhu bia risi mi miu. ");
INSERT INTO nfa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hee, miu mese agama dènge dhèu Parisi sèra! Mema miu dhèu dhu padhai leo, tao leo! Bèli-camèdꞌa miu pasae mere mamadhe-mamopo, lula miu lami asa mia èèna ka, palème lèu, do, caꞌe-puru ledhe, neo tenge dhoka ca dhèu di, sèna ka maso partei agama miu. Te ngaa ropa na maso, miu adꞌu-ue mamuri na asa bhelu risi, toke na abhu hahuku dhu babia na, dua hari risi nèti miu ètu dꞌara naraka. ");
INSERT INTO nfa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Wee! Dꞌara miu dhu bèdhu le. Nga tao ka limuri ne miu neo padꞌelo jꞌara hia dhèu leo? Pe miu abhu mamadhe-mamopo, lula miu ajꞌa leli, peka na, ‘Ladhe dhèu pajaji pake soo-subha dhu ale Èmu Kapua Manèngi-Mangajꞌi, na, dhèu ne paꞌèki boe dènge lii pajaji na èèna. Te ngaa ladhe na pajaji pake subha dènge ale mèdha hualaa ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi, na, nèngu heka paꞌèki dènge lii pajaji na.’ ");
INSERT INTO nfa_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Miu goa kabao! Miu pangee na, Ama Lamatua pakabꞌua risi mèdha hualaa sèra nèti Èmu Kapua Manèngi-Mangajꞌi Na, do? Aadꞌo! Te Èmu neꞌe ka dhu tao mèdha sèra jꞌajꞌi mola-mèci! ");
INSERT INTO nfa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Miu se ajꞌa ore-leli kahèi, peka na, ‘Ladhe dhèu pajaji pake subha ale mei korban dhu ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi, dhèu ne paꞌèki boe dènge lii pajaji na. Te ngaa ladhe na pajaji pake subha aa ale mèdha ètu dedha mei korban, na, dhèu ne heka paꞌèki dènge lii pajaji na kèna.’ ");
INSERT INTO nfa_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Miu mema bèdhu tareꞌa-reꞌa. Tatu mei korban ne, kabꞌua risi nèti mèdha ètu dedha mei èèna. Te mei èèna ka dhu tao mèdha korban rèngu jꞌajꞌi mola-mèci mi Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nèti èèna ka, ladhe dhèu subha ale mei korban ne, na, beꞌa risi ale mei dènge aaꞌi-aaꞌi dhu ètu dedha mei èèna. ");
INSERT INTO nfa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aa ladhe dhèu subha ale Èmu Kapua Manèngi-Mangajꞌi, na, beꞌa risi ale kahèi Èmu Kapua Manèngi-Mangajꞌi dènge kolongara Ama Lamatua. Te Nèngu ka dhu pea ètu talora aae na. ");
INSERT INTO nfa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aa ladhe dhèu subha ale sorga, na, èèna èci èèna ka dènge nèngu ale kadera paredha Ama Lamatua, palere-lere dènge kolongara Na, te Nèngu ka dhu madhèdi nèdꞌu paredha ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hee, miu mese agama dènge dhèu Parisi sèra! Mema miu dhèu dhu padhai leo, tao leo! Pe miu abhu mamadhe-mamopo, lula miu dꞌèlu-mèu titu kèna paꞌiga capala nèti canguru pala dhu miu hia Lamatua. Miu paꞌiga aaꞌi mèu-mèu, toke bubhu nèti dꞌara oka, èci sa tèke eele boe. Miu ige toke lutu-sela nuka sèmi, rèu dꞌare, kaꞌunyi, dènge lasona. Te ngaa miu pabhèlu eele atora dhu kabꞌua risi nèti Ama Lamatua! Te mamuri miu mola boe. Miu sue boe dhèu dhu unu aadꞌo. Aa mamuri miu madhutu boe dadꞌèi Lamatua. Beꞌa risi miu tao madhutu aaꞌi dhu pakarejꞌe dꞌara Lamatua, heka mi paꞌige kèna bubhu-bubhu dhu lutu sèra, dhu miu neo hia mi Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Dꞌara miu bèdhu, te ngaa tasamia ka neo era pajꞌujꞌu jꞌara hia dhèu leo? Miu tao atora toke lutu, ho pua dhèu madhutu, te ngaa atora dhu kabꞌua risi nèti Ama Lamatua, miu mesa mi pusi-pahae boe. Nuka sèmi miu sule eele kikidui dhu ana iiki-iiki nèti èi dhu miu minu, te ngaa badha aae sèmi kabao, miu dhèle kateme! ");
INSERT INTO nfa_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hee, miu mese agama dènge dhèu Parisi sèra! Mema miu dhèu dhu padhai leo, tao leo! Pe miu abhu mamadhe-mamopo, lula miu rase pega-mago toke mèu kaleꞌe, te ngaa dhoka re liꞌu di. Masi ka re dꞌara na dhu kajꞌalu titu kèna nèti manaꞌu miu dènge dèu ngara miu. Mamuri miu sèmi èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wee, dhèu Parisi dhu bèdhu, ee! Rase uuru ku re dꞌara pega-mago miu sèra! Dènge sèmi èèna, re liꞌu na jꞌajꞌi mèu kahèi! ");
INSERT INTO nfa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Wee, miu mese agama dènge dhèu Parisi sèra! Mema miu dhèu dhu padhai leo, tao leo! Pe miu abhu mamadhe-mamopo, lula miu ca ropa dènge roꞌa dhèu madhe dhu lame dènge èi dama pudhi. Dhèu ladhe re liꞌu na, beꞌa titu kèna. Te ngaa ètu dꞌara, pènu dènge rui dhèu madhe, aa dhu hèu oone-oone. ");
INSERT INTO nfa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Miu èci èèna ka! Miu dꞌèi tao iisi mi sèmi dhèu dhu mola-mèci. Nèti liꞌu dhèu rèdhi, na, miu nuka sèmi dhèu dꞌara mola. Te ngaa ètu dꞌara, miu cakaraa dhèu bhelu-katubꞌa. Te miu padhai lii leo, tao leo, aa pabhèlu eele paredha Ama Lamatua sèra. ");
INSERT INTO nfa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hee, miu mese agama dènge dhèu Parisi sèra! Mema miu dhèu dhu padhai leo, tao leo! Pe miu abhu mamadhe-mamopo! Miu pakapai roꞌa nèti dhèu rèti lii padhai Ama Lamatua, aa dule pabeꞌa-beꞌa roꞌa dhèu dꞌara beꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te ngaa miu peka na, ‘Sèmi jiꞌi se mamuri tèu èci èèna ka dènge bèi-baki jiꞌi, tatu jiꞌi madhutu boe pamadhe dhèu dhu rèti lii padhai Ama Lamatua sèra.’ ");
INSERT INTO nfa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dènge jꞌara neꞌe, miu unu mi bhoke rahasia miu, na, miu bhelu èci èèna ka dènge bèi-baki miu. ");
INSERT INTO nfa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","De laꞌa, sina ma. Miu tao taruu la bhabhelu toke dꞌai èle, madhutu tatao bèi-baki mi! ");
INSERT INTO nfa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Miu tareꞌa-reꞌa bhelu-katubꞌa, èci èèna ka dènge mege dhu dènge raco. Miu pangee, na, Ama Lamatua huku boe miu? Aadꞌo! Tatu Na pèci miu asa dꞌara ai naraka! ");
INSERT INTO nfa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sanèdꞌe paie! Pe Jaꞌa pua ana madhutu Jaꞌa mai, ho ra ajꞌa-nori dènge padꞌelo miu jꞌara mamuri Lamatua dhu lèke. Te ngaa èèna na miu pamadhe cahagꞌe, aa cahagꞌe hari miu paku pamadhe si ètu ajꞌu palolo-palèbha. Abhu kahèi dhu miu hake-paru si ètu dꞌara èmu-èmu sabajꞌa, aa abhu cahagꞌe kahèi miu pajꞌèra si toke ra rai nèti kota èci asa kota leo. ");
INSERT INTO nfa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lodꞌo uru sèra, bèi-baki miu pamadhe Habel. Masi ka nèngu ne, dꞌara dhu mola. Bèi-baki miu dhu loe boe pamadhe dhèu dhu dꞌara mola nèti lai ana-lai èpu. Toke dꞌai Sakaria, ana nèti Barakia. Ra pamadhe ne ètu madha Èmu Kapua Manèngi-Mangajꞌi padètu dènge mei korban. Lula miu madhutu bhabhelu bèi-baki mi, nèti èèna ka miu hudꞌi tago mere raa nèti dhèu dhu dꞌara mola seꞌe. ");
INSERT INTO nfa_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mema lèke tareꞌa! Te miu ana lodꞌo limuri ne, bèli-camèdꞌa abhu huku lula jꞌara-jꞌara bhabhelu dhu bèi-baki miu adꞌu-ue karèi nèti uru ka mai.” ");
INSERT INTO nfa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Hee, miu dhèu Yerusalem! Miu dhu loe boe pamadhe dhèu-dhèu rèti lii padhai Ama Lamatua, aa pèci pamadhe dhèu pajuu-paleha Na dhu mai soru-bara miu. Jaꞌa keꞌa boe roca pamako miu, sèna ka lèpa mai asa Jaꞌa ne, nuka sèmi manu rena dhu bhiri-sarobho ana na ètu dꞌara èla na. Te ngaa miu pusi-pahae boe Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nèti èèna ka, Lamatua pusi-pahae heka dènge èmu miu. Ka bèli-camèdꞌa, èmu èèna dhèu pea heka ètu dꞌara. ");
INSERT INTO nfa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nanene paie-iie! Te bèli-camèdꞌa miu mèdhi heka Jaꞌa toke dꞌai lodꞌo na, miu mangaku, peka na, ‘Èdhi manèngi sèna ka Ama Lamatua pala-bagi mamèngi-nale mi Dhèu neꞌe, lula Lamatua ka dhu pua Na mai.’ Miu mangaku sèmi èèna, heka mèdhi hari Jaꞌa kèna.” ");
INSERT INTO nfa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ka Yesus neo tèke eele Èmu Kapua Manèngi-Mangajꞌi. Ropa Na kalua, ana madhutu Na mai pajꞌujꞌu babeꞌa Èmu Kapua Manèngi-Mangajꞌi ne. ");
INSERT INTO nfa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Te ngaa Yesus peka dènge ra, na, “Èmu ne, mema saraga. Te ngaa nanene, ee! Nèbhu heka dhèu mai paguri eele aaꞌi hadhu se.” ");
INSERT INTO nfa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hèia Yesus laꞌe madhèdi asa ledhe Saitun. Ka ana madhutu Na mai padhai lii mesa ra dènge Ne, peka na, “Ama! Peka hari ku laa, lii padhai Ama deo na. Jꞌajꞌajꞌi na pèri lodꞌo? Mamai hari Ama na lodꞌo mia? Aa tadha-tadha na tasamia? Tasamia kahèi dènge lodꞌo èle rai-haha?” ");
INSERT INTO nfa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ka Yesus dhaa, peka na, “Jꞌaga paie mamuri miu, sèna ka dhèu baku kapodꞌe-kabèli miu. ");
INSERT INTO nfa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Te bèli-camèdꞌa dhèu ae mai tèbꞌa kakara, peka na, ‘Jaꞌa ne, Kristus, Dhèu dhu Ama Lamatua padhadha karèi nèti uru ka.’ Dènge jꞌara ne, rèngu monya dhèu ae. ");
INSERT INTO nfa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ladhe miu mèdhi ka, dhèu pamusu, do, tadèngi lii palolo dhèu papara-pakèjꞌi ètu mia-mia, na, miu baku madhaꞌu kahèi. Te jꞌara seꞌe se, hudꞌi jꞌajꞌi uuru ku, te ngaa lodꞌo èle rai-haha ne dhae dꞌai mèka. ");
INSERT INTO nfa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dhèu nèti ca suku, èèna na pamusu dènge suku leo. Negara èci pamusu, labꞌa negara leo. Ètu mia-mia abhu rai opo, aa manganga-madꞌèu dhu kapai titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Te ngaa sèra sa, heka tadha partama kèna, dhu peka na, lodꞌo èle rai-haha dètu ae le. Èèna nuka sèmi bhèni dhu mulai kabake pèdꞌa neo nara iisi. ");
INSERT INTO nfa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","De miu hudꞌi jꞌaga paie ku ngiꞌu miu! Te bèli-camèdꞌa dhèu mai pajꞌèra dènge pamadhe miu. Aa dhèu nèti suku aaꞌi-aaꞌi, èèna na dꞌèi boe miu, lula miu madhutu Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Taa èèna, dhèu ae ka dhu soro kabodho dènge roꞌo heka madhutu Jaꞌa. Rèngu panasa èci dènge èci, aa èci pahie èci. ");
INSERT INTO nfa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Èèna na abhu dhèu dhu tema leko-monya se, peka na, rèngu dhèu rèti lii padhai Lamatua. Ka dhèu ae ka dhu lèka si. ");
INSERT INTO nfa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bèli-camèdꞌa bhabhelu dhèu asa tabha, toke dhèu reꞌa heka pasue èci dènge èci. ");
INSERT INTO nfa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Te ngaa dhèu dhu taha taruu toke madhe, tatu Ama Lamatua pala hia ne mamuri. ");
INSERT INTO nfa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Te dhèu hudꞌi palolo pale-lème ku Lii Lolo Beꞌa Ama Lamatua, toke suu-suu rai dꞌai roꞌa kakilu ètu rai-haha ne, sèna ka dhèu aaꞌi-aaꞌi reꞌa mèu jꞌara mamuri Lamatua. Èle èèna ku, rai-haha ne heka èle kèna.” ");
INSERT INTO nfa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus padhai lii hari, aku Nèngu na, “Daniel, ca dhèu nèti dhèu rèti lii padhai Ama Lamatua, dhu suri tèke le, peka na, bèli-camèdꞌa dhèu èci dhu bhelu-katubꞌa risi eele mai. Èèna na maso titu ètu era laluri ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi Ama Lamatua. Dènge jꞌara ne, nèngu pahera eele era neꞌe. Nèti èèna ka, Ama Lamatua soro kabodho tèke eele era neꞌe. De ropa miu mèdhi ka sèmi èèna, na mi pajiko paie-iie ka! (Dhèu cee dhu baca sasuri neꞌe hudꞌi pajiko paie-iie ku!) ");
INSERT INTO nfa_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Te neꞌe ne jꞌajꞌi tadha dhu peka na, lodꞌo-lodꞌo jꞌajꞌèra dètu ae le. Ropa mèdhi ka sèmi èèna, dhèu ètu propensi Yudea, rai ka asa ledhe. ");
INSERT INTO nfa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ladhe abhu dhèu dhu kalua nèti dꞌara èmu le, na maso ia ka mere mèdha-panyau. Te ngaa rai dènge ka, sèna ka baku lèke mamadhe-mamopo. ");
INSERT INTO nfa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dhèu ètu dꞌara oka, lèpa ia ka mere mèdha-papake mi. Te ngaa rai dènge ka! ");
INSERT INTO nfa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dhu jꞌèra risi ka, ina dhu dènge babia, aa ina-ina dhu pasusu ana dhu heka rara iisi hiu sèra. Te rèngu se bisa boe rai pamèri. ");
INSERT INTO nfa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","De hua iia miu sabajꞌa, manèngi sèna ka lodꞌo jꞌajꞌèra èèna mage lèke dènge hèru èjꞌi lai, do, lodꞌo ae sasabꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Te lodꞌo èèna jꞌèra titu kèna! Karèi nèti Ama Lamatua pajꞌajꞌi rai-haha ne, toke dꞌai sange neꞌe ne, dhèu dhae ladhe rèdhi mèka jꞌajꞌèra dhu kapai sèmi èèna na. Aa èèna na, dhèu paraga heka dènge jꞌajꞌèra dhu sèmi èèna. ");
INSERT INTO nfa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te ngaa miu oto kapai, te Ama Lamatua pabꞌabꞌe lodꞌo èèna. Ladhe aadꞌo, na, abhu boe ca dhèu sa dhu bisa taha mamuri. Te ngaa, lula Ama Lamatua sue dhèu unu Na dhu hagꞌe nare sèra, nèti èèna ka Na pabꞌabꞌe lodꞌo jꞌajꞌèra sèra. ");
INSERT INTO nfa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ladhe lodꞌo èèna dꞌai ka, miu tadèngi dhèu, peka na, ‘Ladhe ku la! Kristus ka neꞌe!’ Aa dhèu leo peka na, ‘Kristus ka nèi!’ Te ngaa baku miu parcaya! ");
INSERT INTO nfa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Te èèna na, abhu dhèu mai tèbꞌa kakara, peka na, ‘Jaꞌa ne, Kristus!’ Aa dhèu leo peka na, ‘Jaꞌa ne, dhèu kèti lii padhai Ama Lamatua.’ Èèna na rèngu tao tadha malaa rupa-rupa, pake koasa nidhu, sèna ka kapodꞌe-kabèli dhèu. Dhèu se tenge jꞌara ho dhèu unu Ama Lamatua sèra lèke tipu kahèi! ");
INSERT INTO nfa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","De miu hudꞌi jꞌaga paie-iie mamuri miu! Lodꞌo-lodꞌo jꞌajꞌèra se, dhae dꞌai mèka, te ngaa Jaꞌa pasanèdꞌe mema le miu! ");
INSERT INTO nfa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ladhe dhèu peka dènge miu, na, ‘Kristus ètu le dꞌara tana lapa nèi!’, na baku lami kahèi. Aa ladhe abhu dhu peka na, ‘Kristus nuka ètu dꞌara èmu!’, na, baku miu parcaya kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Te Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Bèli-camèdꞌa ladhe Jaꞌa mai hari asa rai-haha ne, dhèu aaꞌi-aaꞌi ladhe rèdhi Jaꞌa, nuka sèmi dhèu ladhe rèdhi bela kahaꞌa nèti dhimu asa haa. ");
INSERT INTO nfa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ladhe Jaꞌa lèpa hari mai, pe miu meꞌa Jaꞌa ètu era mia. Nuka sèmi dhèu reꞌa na, ladhe dhèu rèdhi manu-bhui dhu tema raꞌa sisi badha madhe, ra lela paꞌoru ètu mia, na ra reꞌa èèna jꞌajꞌi mi tadha, na, tatu abhu sisi hèu ètu era èèna.” ");
INSERT INTO nfa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Èle èèna ka, Yesus tuhu hari lii padhai Na, ho peka dènge ana madhutu Na sèra, aku Nèngu na, “Ladhe oe èle ka lodꞌo jꞌajꞌèra sèra, ‘Èèna na, madha lodꞌo maroga kiu-kiu, hèru heo heka. Hua hètu-hua hètu kabhui nèti dedha-liru, aa koasa-koasa ètu dedha-liru patogo èci dènge èci.’ ");
INSERT INTO nfa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ka dhèu aaꞌi-aaꞌi ladhe rèdhi kahèi tadha ètu dedha-liru, dhu padꞌelo, peka na, Dhèu Rai-haha Tareꞌa-reꞌa neo mai hari kèna. Ropa rèdhi sèmi èèna, hèia suku aaꞌi-aaꞌi ètu rai-haha ne jꞌajꞌi madhaꞌu toke ra tangi. Te bèli-camèdꞌa Jaꞌa puru mai dènge raꞌi-liru, heka rèngu ladhe rèdhi koasa dènge dadedha Jaꞌa kèna. ");
INSERT INTO nfa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ka Jaꞌa pake lii tèbhe dhu mèdhu ho pua ana-ana pajuu Ama Lamatua nèti sorga, sèna ka pakaboko rare dhèu aaꞌi-aaꞌi dhu Jaꞌa kabhili kore le, nèti suu-suu rai-haha, nèti haa toke dhimu, nèti badae toke balèu.” ");
INSERT INTO nfa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Jaꞌa pakasame sèmi ajꞌu ca kapua. Ladhe rèu na mulai karara, tadha na, oe dètu hèru hadhu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sèmi èèna kahèi, ladhe miu mèdhi ka dꞌai lodꞌo-lodꞌo jꞌajꞌèra, nuka sèmi dhu Jaꞌa peka-padhai deo na, èèna tadha, na, mamai Jaꞌa dhu dètu iiki le. ");
INSERT INTO nfa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nanene paie-iie! Nèti dhèu aaꞌi-aaꞌi dhu mamuri loo-limuri ne, èèna na abhu cahagꞌe dhu dhae madhe mèka, te lodꞌo jꞌajꞌèra se dhu jꞌajꞌi le. ");
INSERT INTO nfa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Masi ka liru dènge rai-haha ne ele, te ngaa lii padhai Jaꞌa ne ca lamusi sa bisa boe ele.” ");
INSERT INTO nfa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ca dhèu sa reꞌa boe pèri lodꞌo Jaꞌa mai hari. Ana pajuu Ama Lamatua ètu sorga reꞌa boe kahèi. Jaꞌa mesa ku keꞌa boe kahèi. Dhodhoka Ama Ku mesa Na dhu neꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Te Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Bèli-camèdꞌa ropa Jaꞌa mai hari, nuka sèmi taa uru sèra, lodꞌo Noh mamuri era. ");
INSERT INTO nfa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Èi aae dhae jꞌajꞌi mèka lala, te ngaa dhèu-dhèu dhu raꞌa-rinu, aa paleo èmu sèmi biasa. Dhèu sèra tao taruu sèmi èèna, toke Noh maso asa dꞌara kapa aae èèna. ");
INSERT INTO nfa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Te ngaa ropa èi aae lala, hae nèti aaꞌi si, rèngu heka kabèdhi kèna, lula ngaa dhu jꞌajꞌi sèra. Èci èèna ka dènge mamai Jaꞌa bèli-camèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lodꞌo èèna, ladhe abhu dhèu dua ètu dꞌara oka, cagꞌagꞌa laa Ama Lamatua dedꞌe nèti ca dhèu, aa ca dhèu hari tèke eele. ");
INSERT INTO nfa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ladhe dhèu bhèni dhèu dua dhu majꞌu are, kacaꞌa la Ama Lamatua dedꞌe nèti ca dhèu, aa ca dhèu hari tèke eele. ");
INSERT INTO nfa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nèti èèna ka, miu hudꞌi bori paꞌèra mema kahèi, te miu meꞌa boe pèri lodꞌo Lamatua miu lèpa hari mai. ");
INSERT INTO nfa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pangee paie-iie! Ladhe lamatua èmu dhu neꞌa mema, na, mèda none dhèu manaꞌu mai, tatu na pasaruru boe musi madha na, sèna ka dhèu manaꞌu baku maso asa dꞌara èmu. ");
INSERT INTO nfa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nèti èèna ka, miu hudꞌi paꞌèra mema kahèi. Te mamai hari Jaꞌa èèna, dènge sahèka!” ");
INSERT INTO nfa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ka Yesus tuhu hari lii padhai Na, peka na, “Miu hudꞌi jꞌajꞌi ku nuka sèmi dhèu sabꞌa dhu madhutu dhodhoka dadꞌèi lamatua na. Te ladhe lamatua na neo laꞌe rai kajꞌèu, na dedꞌe dhèu sabꞌa dhu sèmi èèna ku, ho uri ngangaꞌa-nganginu hia isi èmu na. ");
INSERT INTO nfa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ladhe lamatua na lèpa, ladhe nèdhi dhèu sabꞌa na dhu sabꞌe dènge beꞌa, tatu na karejꞌe. ");
INSERT INTO nfa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Parcaya la Jaꞌa, te bèli-camèdꞌa lamatua èmu hia dhèu sabꞌa ne koasa, sèna ka ladhe-leru mèdha-panyau na aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Te ngaa ladhe dhèu sabꞌa ne, dhèu bhelu, tatu na ngee ètu dꞌara na, ");
INSERT INTO nfa_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Beꞌa kèna! Lamatua jaꞌa laꞌe le, de cee neꞌa na pèri lodꞌo lèpa hari mai!’ Nèti ngangee sèmi neꞌe ne, hèia na kalabhe dhèu sabꞌa leo sèra. Aa nèngu madhèdi naꞌa-ninu mau-mau bera-bera dènge dhèu mahu sèra. ");
INSERT INTO nfa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Te ngaa dhu neꞌa nare boe, na, cagꞌagꞌa laa lamatua na lèpa hari mai. ");
INSERT INTO nfa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hèia lamatua na capa pajꞌèra ne, ka core ne asa liꞌu, sèna ka na paꞌèci dènge dhèu padhai lii leo, tao leo sèra. Ètu era neꞌe, dhèu aaꞌi-aaꞌi ra tangi dꞌara pèdꞌa, lula ra jꞌèra dꞌai seli.” ");
INSERT INTO nfa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Èle èèna, hèia Yesus tuhu hari lii lula-nèti Ama Lamatua nèdꞌu paredha, aku Nèngu na, “Miu hudꞌi bori mema-mema ho soru mamai Jaꞌa, nuka sèmi lii pakasame ne. Sèmi neꞌe: ca tèka dhèu bhèni dhèu canguru dhu kalua re mèda, lasi soru broit dhèu mone, rèti dènge labhu èi mènyi asa èmu angalai ra. ");
INSERT INTO nfa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Te ngaa nèti rèngu canguru dhèu se, abhu lèmi dhu goa, aa lèmi dhu dꞌèlu-mèu. ");
INSERT INTO nfa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lèmi dhu goa se, rèti boe èi mènyi dhu risi. ");
INSERT INTO nfa_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Te ngaa lèmi dhu dꞌèlu-mèu se, rèti parisi. ");
INSERT INTO nfa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Dꞌai èmu, broit dhèu mone dhae mai mèka. Nèbhu-nèbhu ka, dhèu bhèni se musi madha ra sakaa, hèia ra bhèjꞌi luu titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Reꞌa rare boe te, dꞌai talora mèda sa, hèia tadèngi lii paꞌoo, peka na, ‘Wee! Broit mai le! Mai lati soru ne!’ ");
INSERT INTO nfa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ropa ra tadèngi, hèia dhèu bhèni se kèdꞌi ka. Ka ra kèpe ka labhu ra èci-èci. ");
INSERT INTO nfa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Te ngaa dhèu bhèni dhu goa se, peka dènge bhèni aanga ra, aku rèngu na, ‘Angalai, ee! Bagi hia jiꞌi èi mènyi miu ciki la, te labhu jiꞌi di ruru-ruru kèna!’ ");
INSERT INTO nfa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Te ngaa dhèu bhèni dhu dꞌèlu-mèu se dhaa, aku rèngu na, ‘Irii! Baku nasa, te bisa boe. Te èi mènyi jiꞌi dꞌai boe èdhi aaꞌi-aaꞌi ti! De beꞌa risi lami hèli ètu era dhu pahia èi mènyi.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hèia lasi ka hèli èi mènyi. Te ngaa ropa rèngu lasi, broit dhu dꞌai le. Ka dhèu bhèni dhu dꞌèlu-mèu se, lasi ka asa dꞌara pesta, palere-lere dènge broit dènge tamu aaꞌi-aaꞌi ra. Ropa rèngu aaꞌi-aaꞌi dꞌai dꞌara, ka ra bèdho èmu. ");
INSERT INTO nfa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hèia dhèu bhèni dhèu lèmi dhu goa se, lèpa mai. Ka ra paroa peka na, ‘Ama! Ama! Conge ku èmu hia jiꞌi la!’ ");
INSERT INTO nfa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Te ngaa ama ne dhaa, aku nèngu na, ‘Wee, bisa boe, te miu se cee, jaꞌa tadhe boe!’ ");
INSERT INTO nfa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nèti èèna ka, miu hudꞌi paꞌèra taruu, te miu meꞌa boe kahèi, lodꞌo do hake pèri Jaꞌa lèpa hari mai.” ");
INSERT INTO nfa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ka Yesus peka hari lii pakasame èci, aku Nèngu na, “Ropa Jaꞌa tèke eele miu, na, miu hudꞌi sabꞌa paie-iie hia Jaꞌa, nuka sèmi lii pakasame ne: abhu lamatua ca dhèu neo pakèdꞌi laꞌe asa rai kajꞌèu. Ropa na paꞌèra neo laꞌe, hèia na paroa nare dhèu-dhèu sabꞌa na, ka na paredha si, aku nèngu na, ‘Miu pake doi ne, tao mi poko. Ladhe jaꞌa lèpa mai, miu padꞌelo dènge jaꞌa, miu abhu leto ca ngaa.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka na pabagi doi hualaa mi dhèu sabꞌa ka èci, lèmi saku, sèna ka pabꞌunge ne. Dhèu sabꞌa ka dua abhu doi dua saku, aa ka tèlu abhu doi ca saku, madhutu aꞌèra rèngu èci-èci ra. Ka lamatua ne pakèdꞌi laꞌe ka. ");
INSERT INTO nfa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ropa sèmi rare doi ne, hèia dhèu sabꞌa ka èci laꞌe dènge dꞌaga. Nèbhu boe, na abhu leto doi lèmi saku hari. ");
INSERT INTO nfa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sèmi èèna kahèi dènge dhèu sabꞌa ka dua. Na abhu leto, doi dua saku hari. ");
INSERT INTO nfa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Te ngaa dhèu sabꞌa ka tèlu dhu abhu doi ca saku deo na, laꞌe kèi roꞌa ka na padhènu doi lamatua na asa dꞌara. ");
INSERT INTO nfa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nèbhu ae ku, heka lamatua rèngu lèpa. Hèia na paroa dhèu sabꞌa na sèra, ho parisa doi na, dhu na hia si uri. ");
INSERT INTO nfa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dhèu sabꞌa ka èci, laꞌe ka saraka doi canguru saku, ka na peka, ‘Ama! Doi ama ka neꞌe. Ca hari ni, ama hia jaꞌa doi lèmi saku. Te ngaa limuri ne, jaꞌa abhu leto lèmi saku kahèi.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ropa lamatua na tadèngi, hèia na karejꞌe. Ka na peka, na, ‘Beꞌa! Èu ne dhèu sabꞌa dhu beꞌa. Èu ne majꞌèni, aa dꞌèi madhutu taruu lii paredha jaꞌa, masi ka jaꞌa aadꞌo. Lula èu ne bisa uri dhu ciki sèmi neꞌe, de èèna na jaꞌa dedꞌe èu sèna ka uri jꞌara dhu kapai aae hari. Pe jaꞌa tao pesta, sèna ka taꞌa-tinu sama-sama.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Èle ka, dhèu sabꞌa ka dua, laꞌe saraka mi lamatua na, doi èpa saku, ka na peka na, ‘Ama! Ca hari ni, ama hia jaꞌa doi dua saku. Te ngaa ladhe ku la, jaꞌa abhu leto dua saku kahèi.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ka lamatua ne karejꞌe kahèi, ka na peka na, ‘Beꞌa! Èu ne dhèu sabꞌa dhu beꞌa kahèi. Èu ca dhèu dhu majꞌèni, aa madhutu taruu lii paredha jaꞌa, masi ka jaꞌa aadꞌo. Lula èu bisa uri dhu ciki sèmi neꞌe ne, de èèna na jaꞌa dedꞌe èu ho uri dhu kapai hari. Pe jaꞌa tao pesta, sèna ka taꞌa-tinu sama-sama.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Èle èèna ka, dhèu sabꞌa ka tèlu, laꞌe peka dènge lamatua na, aku nèngu na, ‘Ama! Jaꞌa keꞌa na, ama ca dhèu dhu dꞌara adhu. Te ama more ngaa dhu dhèu leo tao, aa puu more ngaa dhu dhèu leo sèle. ");
INSERT INTO nfa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ka jaꞌa madhaꞌu, mage doi se ele, hèia ama huku jaꞌa. Nèti èèna ka, jaꞌa huni paie-iie ne. Ka seꞌe, ama! De more hari ka, te doi ama se, kura boe ca ana ma sa!’ ");
INSERT INTO nfa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ropa lamatua ne tadèngi nare, hèia na jèke dhèu sabꞌa ne, aku nèngu na, ‘Wee, èu ne dhèu sabꞌa dhu bhelu aa bai-eedꞌa! Èu dhu meꞌa, na, jaꞌa kore ngaa dhu dhèu leo tao, aa puu kore ngaa dhu dhèu leo sèle, ");
INSERT INTO nfa_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nga tao ka èu lamu boe tèke doi ne mi bank? Sèna ka ropa jaꞌa lèpa, jaꞌa kore bunga na, masi ka ciki ooꞌe, ngaa-ngaa tao boe!’ ");
INSERT INTO nfa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ka lamatua ne pua dhèu sabꞌa dhu leo sèra, aku nèngu na, ‘Mere doi nèti nèngu ne, ho hia mi dhèu sabꞌa dhu abhu leto lèmi saku èèna. ");
INSERT INTO nfa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Te dhèu dhu uri paie-iie ngaa dhu ètu adhe-aai na, èèna na, na abhu ae hari. Te ngaa dhèu dhu roꞌo boe uri ngaa dhu ètu dꞌara adhe-aai na, èèna na rare aaꞌi nèti nèngu. ");
INSERT INTO nfa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kèpe mere dhèu sabꞌa dhu guna boe ne. Nuni paꞌoro ne, pèci asa liꞌu nèi. Soro tèke ne, sèna ka na tangi, aa dui nare jꞌajꞌèra ètu era maroga aatu-aatu nèi!’ ” ");
INSERT INTO nfa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ka Yesus tuhu hari lii padhai Na, aku Nèngu na, “Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, bèli-camèdꞌa puru mai dènge dadedha nèti Ama Ku, palere-lere dènge ana pajuu Na nèti sorga. Èle na Jaꞌa madhèdi ètu kadera paredha dhu dedha risi, sèna ka parisa mamuri dhèu aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bèli-camèdꞌa dhèu aaꞌi-aaꞌi dhu mamuri rèdhi ètu rai-haha, mai asa madha Jaꞌa. Pe Jaꞌa hagꞌe si, nuka sèmi dhèu madhenga badha pacèri kahibꞌi-kalèbho nèti kahibꞌi-kaꞌia, sèna ka jꞌajꞌi mi dua kaboko. ");
INSERT INTO nfa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dhèu-dhèu dhu mamuri madhutu dadꞌèi Ama Lamatua, Jaꞌa hia si re gꞌana Jaꞌa. Te ngaa dhu leo sèra, Jaꞌa hia si re kariu Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lodꞌo èèna, Jaꞌa kèdꞌu paredha nuka sèmi Dhèu Aae. Èèna na dhèu-dhèu ètu gꞌana Jaꞌa, Jaꞌa peka dènge rèngu, na, ‘Miu seꞌe se, ka dhu abhu mèngi-nale nèti Ama Ku. Mai lati asa dꞌara èmu Na, dhu Na tao tèke hia miu, karèi nèti uru ka. ");
INSERT INTO nfa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Jaꞌa nèru miu, lula uru èèna lodꞌo Jaꞌa manganga, miu ka dhu pangaꞌa Jaꞌa. Aa lodꞌo Jaꞌa koko kamango, miu ka hia Jaꞌa kinu. Jaꞌa mai nuka sèmi dhèu leo kara, te ngaa miu hia Jaꞌa manubha ètu dꞌara èmu miu. ");
INSERT INTO nfa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jaꞌa dènge boe mèdha-papake, te ngaa miu ka dhu papake Jaꞌa. Jaꞌa ètu dꞌara papèdꞌa-tarègu, te ngaa miu ka dhu lalau-laloꞌo Jaꞌa. Jaꞌa ètu dꞌara bèdho, aa miu ka dhu mai paꞌasu-pareo dènge Jaꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ropa dhèu-dhèu ètu sebhe gꞌana Jaꞌa se tadèngi lii Jaꞌa ne, ra dhaa peka na, ‘Lamatua, neꞌe ne tasamia kèna? Lamatua peka na, Lamatua manganga, ka jiꞌi pangaꞌa. Lamatua koko kamango, ka jiꞌi hia minu. ");
INSERT INTO nfa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lamatua sèmi dhèu leo kara, ka jiꞌi hia manubha ètu dꞌara èmu jiꞌi. Lamatua dènge boe mèdha-papake, ka jiꞌi papake Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lamatua pèdꞌa, ka jiꞌi lalau-laloꞌo Lamatua, Lamatua ètu dꞌara bèdho, ka jiꞌi dhiu paꞌasu-pareo. Te ngaa jꞌara seꞌe se, lodꞌo mia ka dhu jiꞌi tao mi Lamatua?’ ");
INSERT INTO nfa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pe Jaꞌa dhaa si, peka na, ‘Parcaya la Jaꞌa! Te lodꞌo miu tao jꞌara seꞌe se mi dhèu unu Jaꞌa, masi ka tao mi dhèu dhu haha dꞌai seli èèna ka, sèra sa miu tao le mi dedha Jaꞌa kahèi!’ ");
INSERT INTO nfa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Èle èèna, dhèu-dhèu dhu ètu sebhe kariu Jaꞌa, Jaꞌa peka dènge rèngu, na, ‘Hee, dhèu bhelu-katubꞌa! Ama Lamatua dhu dhoo le miu. Pakajꞌèu nèti neꞌe ne! Pe Jaꞌa paredha dhèu mai kèpe miu, sèna ka pèci asa dꞌara ai naraka dhu heo robhe-robhe. Te Ama Lamatua dhu sadia nare le era jꞌajꞌèra ne, hia mi nidhu dènge dhèu aae ra. ");
INSERT INTO nfa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Jaꞌa babège eele miu, lula lodꞌo Jaꞌa manganga, miu hia boe Jaꞌa kuꞌa. Aa lodꞌo Jaꞌa koko kamango, miu hia boe Jaꞌa kinu. ");
INSERT INTO nfa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jaꞌa mai nuka sèmi dhèu leo kara, te ngaa miu soru boe Jaꞌa asa dꞌara èmu mi. Jaꞌa dènge boe mèdha-papake, te ngaa miu papake boe Jaꞌa. Lodꞌo Jaꞌa pèdꞌa-tarègu, miu lalau-laloꞌo boe Jaꞌa. Jaꞌa ètu dꞌara bèdho, te ngaa miu paꞌasu-pareo boe Jaꞌa sa kahèi.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ropa dhèu bhelu-katubꞌa se tadèngi lii Jaꞌa sèmi èèna, hèia ra bꞌala, peka na, ‘Lamatua ne tasamia kèna? Lamatua peka na, Lamatua manganga, te ngaa jiꞌi hia boe muꞌa. Lamatua koko kamango, te ngaa jiꞌi hia boe minu. Lamatua nuka sèmi dhèu leo kara, te ngaa jiꞌi ngoꞌo boe hia manubha ètu dꞌara èmu jiꞌi. Lamatua dènge boe mèdha-papake, te ngaa jiꞌi papake boe. Lamatua ètu dꞌara papèdꞌa-tarègu, te ngaa jiꞌi lalau-laloꞌo boe. Lamatua ètu dꞌara bèdho, te ngaa jiꞌi paꞌasu-pareo boe. Te ngaa jꞌara seꞌe se, jiꞌi tao mi Lamatua lodꞌo mia?’ ");
INSERT INTO nfa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pe Jaꞌa dhaa mi rèngu, peka na, ‘Parcaya la Jaꞌa! Te lodꞌo miu soru-bara boe dhèu-dhèu dhu haha ae dꞌai seli, èci èèna ka dènge miu soru-bara boe Jaꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ka dhèu bhelu-katubꞌa abhu jꞌajꞌèra, toke dꞌai mia-mia. Te ngaa dhèu-dhèu dhu dꞌara mola, abhu mamuri taa-taa, toke dꞌai mia-mia dènge Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ropa Yesus ajꞌa nare jꞌara se aaꞌi-aaꞌi ra, hèia Na lii dènge ana madhutu Na, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Miu meꞌa le, na, di dua lodꞌo ka dꞌai lodꞌo babeꞌa èdhi, nuka Pesta Paska. Lodꞌo èèna, abhu dhèu dhu pahie Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne. Èle èèna, ra paku pamadhe Jaꞌa ètu ajꞌu palolo-palèbha.” ");
INSERT INTO nfa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lodꞌo èèna, kètu agama Yahudi dènge dhèu heka adꞌa sèra, dhu pakaboko ètu dꞌara èmu Kayafas. Kayafas ne, nuka kètu kapai risi agama Yahudi. ");
INSERT INTO nfa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rèngu se tenge jꞌara ho neo kèpe Yesus pahuni-pahuni, sèna ka pamadhe Ne. ");
INSERT INTO nfa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Te ngaa rèngu rare lii èci, peka na, “Mata ku! Mage èdhi kèpe Ne ètu dꞌara lai-lai ne, lula lodꞌo-lodꞌo beꞌa dètu le. Mage dhoka dhèu ae dhu dꞌèi Nèngu, tao maruru.” ");
INSERT INTO nfa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ètu rae Betania, abhu ca dhèu ngara na Simon. Uru èèna, dhèu madenge dènge ne, lula nèngu dhu lèke èi papèdꞌa kusta. Te ngaa limuri ne, èle le nèti papèdꞌa na. Lodꞌo dhu dꞌai mèka lodꞌo babeꞌa dhèu Yahudi, Yesus si raꞌa ètu dꞌara èmu Simon. ");
INSERT INTO nfa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ropa rèngu raꞌa era, bhèni ca dhèu mai paraga dènge Yesus. Nèngu nèdꞌu boto cue dhu tao nèti hadhu dhu kabꞌua. Boto ne dhu isi na, èi hèu mèngi dhu kabꞌua titu kèna. Ka bhèni ne hake pamae katanga boto ne. Hèia na pahae mau-mau èi hèu mèngi ne mi kètu Yesus, sèna ka jꞌajꞌi tadha, nèngu pakabꞌua Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te ngaa ropa ana madhutu Na ladhe rèdhi tatao bhèni ne, hèia ra nasa. Ka ra pakaꞌuu, aku rèngu na, “Heh! Bhèni ne bhori eele iia dꞌara, èi hèu mèngi dhu kabꞌua aae ne. Baku na tao sèmi èèna! ");
INSERT INTO nfa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Beꞌa risi nèngu pahie! Sèna ka kabꞌua na bagi mi dhèu-dhèu dhu unu boe ngaa-ngaa.” ");
INSERT INTO nfa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Te ngaa Yesus neꞌa ngangee rèngu, hèia Na lii peka na, “Miu se baku pasusa bhèni ne! Hudꞌi laa! Jaꞌa karejꞌe, lula na pahae le èi hèu mèngi ne mi ngiꞌu Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Te dhèu dhu unu boe ngaa-ngaa paꞌèci taruu dènge miu. Te ngaa Jaꞌa ne mamuri nèbhu heka dènge miu. ");
INSERT INTO nfa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aa bhèni dhu pahae èi hèu mèngi mi ngiꞌu Jaꞌa ne, sèmi ngaa te, nèngu pahèu mèngi mema le ngiꞌu aae Jaꞌa. Te mamuri Jaꞌa nèbhu heka. ");
INSERT INTO nfa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ngee paie-iie! Sadꞌi ètu mia èèna ka, ladhe dhèu palolo Lii Lolo Beꞌa Ama Lamatua palème rai-haha ne, tatu rèngu papeka kahèi babeꞌa bhèni ne, sèna ka dhèu aaꞌi-aaꞌi sanèdꞌe ne.” ");
INSERT INTO nfa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ca dhèu nèti canguru dua ana madhutu Yesus se, dhu ngara na Yudas Iskariot. Lodꞌo èèna kahèi, kalua laꞌe tenge kètu agama Yahudi sèra, sèna ka neo pahie Yesus mi rèngu. ");
INSERT INTO nfa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ropa Yudas dꞌai dhèu seꞌe, hèia na karèi, peka na, “Ama-ama! Ladhe jaꞌa bhoke jꞌara ho miu bisa kèpe Yesus, miu hia jaꞌa ngaa?” Hèia dhèu se dhaa, peka na, “Ladhe èu neo pahie Ne dènge jiꞌi, na jiꞌi bꞌae.” Ka ra ige rare 30 (tèlu nguru) doi iia, aa ra jꞌole asa Yudas. ");
INSERT INTO nfa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Èle, ka Yudas liꞌu ka laꞌe, hèia na tenge jꞌara ho saraka Yesus asa dꞌara adhe-aai rèngu. ");
INSERT INTO nfa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dꞌara tèu mai-tèu mai, abhu lodꞌo babeꞌa dhèu Yahudi dhu nanèbhu na pidhu lodꞌo. Ra pangare lodꞌo babeꞌa se, na, ‘Pesta Roti dhu Pake boe Ragi’. Ropa pesta èèna neo mulai, ana madhutu Yesus se mai karèi Ne, aku rèngu na, “Ama! Mèda neꞌe, èdhi bhoke lodꞌo babeꞌa èdhi. De Ama neo sèna ka jiꞌi laꞌa roro kahibꞌi-kalèbho, aa lalau era pesta Paska ètu mia?” ");
INSERT INTO nfa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ka Yesus bꞌala si, peka na, “Lami asa dꞌara kota, pe mi paraga dènge ama ca dhèu. Miu peka dènge ne sèmi neꞌe, ‘Ama! Ama Mese rasa lodꞌo mamadhe Na nèbhu heka. Hèia Na manèngi era èci ètu dꞌara èmu ama, sèna ka Na tao kalela Paska dènge ana-ana madhutu Na.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ropa ra tadèngi rare, hèia ana-ana madhutu Na, tao sèmi dhu Na peka. Ka ra lalau ngangaꞌa kalela Paska ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ropa dꞌai mèda, hèia Yesus dènge ana-ana madhutu Na, dhèu canguru dua sèra, madhèdi raꞌa-rinu. ");
INSERT INTO nfa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ropa dhu raꞌa era, hèia Na lii, peka na, “Mi nanene! Ca dhèu nèti miu se, èèna na pahie Jaꞌa asa adhe-aai dhèu leo kara.” ");
INSERT INTO nfa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ropa ra tadèngi sèmi èèna, dꞌara rèngu roe-bhilu. Ka rèngu èci-èci karèi Yesus, peka na, “Dhèu dhu Ama peka deo na, jaꞌa aadꞌo, sina ma?” ");
INSERT INTO nfa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hèia Na peka, na, “Dhèu dhu cèbꞌu roti na palere-lere dènge Jaꞌa asa dꞌara mago ne, nèngu ka dhu pahie Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sanèdꞌe, ee! Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, hudꞌi madhe ku, nuka sèmi dhu suri tèke ètu dꞌara Sasuri Mola-Mèci Ama Lamatua. Te ngaa mate unu na! Dhèu dhu neo pahie Jaꞌa, bèli-camèdꞌa pasae nare pala na! Hua iia risi, ina na baku nara iisi ne!” ");
INSERT INTO nfa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Èle èèna ka, Yudas karèi kahèi, peka na, “Tatu dhèu dhu Ama peka deo na, jaꞌa aadꞌo, sina ma?” Hèia Yesus bꞌala ne, “Mema tareꞌa èu unu mu ka dhu peka lii èèna. De cee hari?” ");
INSERT INTO nfa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Rèngu dhu raꞌa era, hèia Yesus dedꞌe nare roti cue, aa Na manèngi makasi mi Ama Lamatua. Ka Na pamae roti ne, hèia jꞌole asa ana-ana madhutu Na, aa Na peka, “Roti neꞌe ne, ngiꞌu Jaꞌa. Mere ho miꞌe ka!” ");
INSERT INTO nfa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Èle ka, Yesus nare galaa dhu pènu dènge èi anggor, ka Na manèngi makasi mi Ama Lamatua. Hèia Na jꞌole asa ana-ana madhutu Na, aa Na lii, peka na, “Miu aaꞌi-aaꞌi mi, mere ho minu. ");
INSERT INTO nfa_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Te èi anggor neꞌe ne, raa Jaꞌa kèna. Èèna na Jaꞌa madhe, te ngaa raa Jaꞌa suti, sèna ka sui kore dhèu ae nèti koasa sasala-sasigo ra. Raa neꞌe jꞌajꞌi mi tadha ho pasanèdꞌe dhèu, peka na, ngaa dhu Ama Lamatua pajaji èèna, mema limuri ne jꞌajꞌi le. De mere ho minu ka! ");
INSERT INTO nfa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Te ngaa nanene paie-iie! Mulai nèti mèda ne, Jaꞌa kinu heka èi anggor. Pe Jaꞌa dènge Ama Ku madhèdi ngèdꞌu paredha sama-sama ètu sorga, heka Jaꞌa kinu hari kèna dènge miu.” ");
INSERT INTO nfa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Èle èèna, hèia rèngu sodꞌa lii sodꞌa èci, ho koa-kio Ama Lamatua. Ka mèda èèna kahèi, rèngu lasi dènge ka asa ledhe Saitun. ");
INSERT INTO nfa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ropa ètu dꞌara kakako rèngu, Yesus peka dènge ana madhutu Na, aku Nèngu na, “Ciki hari ètu dꞌara mèda neꞌe kahèi, miu aaꞌi-aaꞌi mi rai tèke eele Jaꞌa mesa-mesa Ku. Te dhu suri tèke le ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, peka na, ‘Èèna na, Ama Lamatua pamadhe ana madhenga badha, ka kahibꞌi-kalèbho na rai pajꞌala.’ ");
INSERT INTO nfa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jaꞌa madhe tareꞌa, te ngaa ladhe Jaꞌa mamuri hari, laku mate miu ètu propensi Galilea.” ");
INSERT INTO nfa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Te ngaa Petrus dꞌèi boe nanene lii Na, ka na peka, “Ama! Masi ka dhèu leo rai tèke eele Ama, te ngaa jaꞌa rai boe!” ");
INSERT INTO nfa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hèia Yesus bꞌala aku Nèngu na, “Petrus! Sèmi èèna, do? Lèka la lii Jaꞌa ne! Ètu dꞌara mèda neꞌe ne kahèi, manu dhae kokotoo mèka, te èu dhu pasili le tèlu hari, peka na, èu tadhe boe Jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Te ngaa Petrus noꞌo boe sèmi. Ka na peka, “Aadꞌo, Ama! Ladhe Ama madhe, jaꞌa madhe kahèi. Te jaꞌa rai boe, tèke eele Ama!” Angalai Petrus se, peka sèmi èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ka Yesus si kako taruu asa ledhe Saitun, dꞌai dꞌara oka cue, ngara na Getsemani. Ètu era neꞌe Yesus peka dènge ana madhutu Na, “Miu madhèdi uuru ku mi neꞌe, te Jaꞌa neo laku manèngi-mangajꞌi asa nèi.” ");
INSERT INTO nfa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Te ngaa Na paroa nare Petrus, Yakobis dènge Yohanis, ho lasi palere-lere dènge Ne. Mulai nèti èèna ka, dꞌara Na maꞌète laho mae-mae, aa roe-bhilu. ");
INSERT INTO nfa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Rèngu kako kajꞌèu mèka, te Na peka dènge rèngu, aku Nèngu na, “Dꞌara Jaꞌa susa titu kèna! Jaꞌa nuka sèmi oe madhe sa. Miu madhèdi, mate Jaꞌa mi neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ka laꞌe ako kajꞌèu ciki, hèia Na patitu kètu urutuu ho sabajꞌa, aku Nèngu na, “Ama pasue! Ladhe Ama dꞌèi na, Jaꞌa baku pasae jꞌajꞌèra neꞌe. Te ngaa baku madhutu dadꞌèi Jaꞌa, hudꞌi laa madhutu dadꞌèi Ama di.” ");
INSERT INTO nfa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sabajꞌa nare, hèia lèpa laꞌe asa era ana madhutu Na dhèu tèlu sèra. Te ngaa rèngu dhu bhèjꞌi luu. Ka Yesus parèi si, hèia Na lii dènge Petrus, peka na, “Hee, Petrus! Nga tao ka miu se bhèjꞌi? Jaꞌa ètu nèi nèbhu boe, te ngaa miu lake mere boe beke ciki sa mate Jaꞌa! ");
INSERT INTO nfa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ruri pamako musi madha miu. Kèdꞌi ho beke dènge Jaꞌa. Te dꞌara miu mema dꞌèi tao dhu beꞌa, te ngaa ngiꞌu miu èra boe. De hua iia miu sabajꞌa, sèna ka ladhe lèke dadugu-rariu miu bisa taha.” ");
INSERT INTO nfa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ka Yesus laꞌe hari sabajꞌa, peka na, “Ama! Ladhe Jaꞌa hudꞌi pasae ku jꞌajꞌèra neꞌe, hudꞌi laa madhutu dadꞌèi Ama di.” ");
INSERT INTO nfa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sabajꞌa nare, hèia na mai hari asa era ana madhutu Na dhèu tèlu se. Te ngaa dhu ra bhèjꞌi hari, lula musi madha ra sakaa titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka Na tèke eele si, laꞌe hari manèngi-mangajꞌi catèka. Na manèngi-mangajꞌi hari mi Ama, sèna ka baku soro tèke Nèngu pasae jꞌajꞌèra èèna, te ngaa hudꞌi laa madhutu dhoka dadꞌèi Ama di. ");
INSERT INTO nfa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sabajꞌa nare ka, Na lèpa hari, laꞌe parèi ana madhutu Na, peka na, “Miu se bhèjꞌi taruu, do? Kèdꞌi ka! Te dhèu dhu neo pahie Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, dètu le. Dhèu se mai ho kèpe Jaꞌa kèna, ho saraka asa adhe-aai dhèu bhelu-katubꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wee, kèdꞌi ka! Bhoke musi madha miu, ladhe ku asa nèi. Te dhèu dhu pahie Jaꞌa, nuka mai nèi.” ");
INSERT INTO nfa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ropa Yesus padhai lii era, Yudas dhu nare le era èèna dènge dhèu ae-ae. Dhèu se mai rèti hela dènge ajꞌu cèki ho neo kèpe Ne. Rèngu tao sèmi neꞌe, lula madhutu paredha nèti kètu agama Yahudi, dènge dhèu heka adꞌa sèra. ");
INSERT INTO nfa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas dhu peka mema le mi dhèu seꞌe, na, “Miu ladhe paie-iie! Dhèu dhu jaꞌa uu, Nèngu ka dhu miu kèpe! Te Nèngu ka dhu miu tenge!” ");
INSERT INTO nfa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ropa rèngu dꞌai madha Yesus, hèia Yudas lii dènge ka, “Saloom, Ama Mese!” Hèia Yudas uu Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Èle ka, Yesus peka dènge ne, “Hee, Yudas! Tao ka laa, madhutu dadꞌèi èu.” Ka dhèu ae sèra ara lasi neo kèpe Ne. ");
INSERT INTO nfa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Te ngaa dhu reꞌa boe, na, dhèu unu Yesus ca dhèu dhu bete hela na, ka seru pamaꞌète rèu dhilu dhèu èci. (Dhèu dhu nuꞌa ne, nuka ca dhèu ènu nèti kètu kapai risi agama Yahudi.) ");
INSERT INTO nfa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ropa ladhe nèdhi sèmi èèna, hèia Yesus lii dènge ne, aku Nèngu na, “Pasaluu hela èu èèna asa dꞌara sope na. Te dhèu dhu pake rèka ho neo uri pamere lii langu, èèna na nèngu madhe dènge rèka kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Èu meꞌa boe, do? Jaꞌa bisa manèngi Ama Ku, ho Na hia ana pajuu Na dꞌai nguru riho mai nèti sorga, sèna ka soru-bara Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Te ngaa hudꞌi laa, ra kèpe Jaꞌa. Te aaꞌi-aaꞌi dhu suri tèke le ètu dꞌara Sasuri Mola-Mèci Ama Lamatua lula-nèti Jaꞌa ne, hudꞌi jꞌajꞌi ku.” ");
INSERT INTO nfa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Èle èèna ka, Yesus peka dènge dhèu-dhèu dhu mai kèpe Ne, aku Nèngu na, “Madhutu miu, Jaꞌa ne dhèu bhelu, do? Nga tao ka miu mai kèpe Jaꞌa ne, mèti dènge hela dènge ajꞌu cèki? Bèli-bèli Jaꞌa ajꞌa miu ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi Ama Lamatua, te ngaa dhèu èci sa tao boe ngaa-ngaa mi Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Te ngaa hudꞌi laa! Mai ka, kèpe Jaꞌa! Te jꞌara neꞌe ne, dhu suri tèke le karèi nèti uru ka, ètu dꞌara Sasuri Mola-Mèci Ama Lamatua.” Ropa ana madhutu Yesus rèdhi sèmi èèna, ra madhaꞌu titu kèna. Hèia ra rai tèke eele Ne mesa-mesa. ");
INSERT INTO nfa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Èle èèna, hèia dhèu dhu kèpe Yesus, rèti Ne asa èmu kètu kapai risi agama Yahudi dhu ngara na, Kayafas, lula dhèu kapai sèra dhu pakaboko le ètu era èèna. Dhèu se nuka, kètu agama Yahudi, mese agama, aa dhèu heka adꞌa sèra. ");
INSERT INTO nfa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ropa ra rèti Yesus, Petrus madhutu nèti limuri, toke dꞌai èmu kètu kapai risi agama Yahudi èèna. Petrus laꞌe kahèi asa madha èmu, ho madhèdi dènge dhèu-dhèu dhu ètu sèra. Te neo neꞌa, ngaa ka dhu jꞌajꞌi. ");
INSERT INTO nfa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ètu dꞌara èmu ne, kètu agama Yahudi sèra dhu padhue-padhai dènge dhèu-dhèu dhu madhèdi uri lii langu agama. Rèngu aaꞌi-aaꞌi ra tenge jꞌara, sèna ka pamanahu Yesus, lula ra neo huku pamadhe Ne. ");
INSERT INTO nfa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Masi ka rèngu hia sakasii monya ae kahèi, te ngaa rèngu abhu boe sasala èci sa dhu rèngu bisa pake. Nèbhu boe ka, rèngu abhu sakasii dhèu dua. ");
INSERT INTO nfa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Dhèu dua se, peka na, “Jiꞌi tadèngi le kahèi, Dhèu ne peka na, ‘Bèli-camèdꞌa Jaꞌa paguri eele Èmu Kapua Manèngi-Mangajꞌi. Te ngaa ètu dꞌara tèlu lodꞌo, Jaꞌa patitu kore hari.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ka kètu kapai risi agama Yahudi, kèdꞌi titu ètu madha dhèu aaꞌi-aaꞌi dhu madhèdi ètu era èèna. Hèia na karèi Yesus, peka na, “Èu tadèngi le lii galaa dhèu seꞌe dhu ra galaa Èu. Nga tao ka Èu bꞌala boe ca hèbꞌa sa?” ");
INSERT INTO nfa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Te ngaa Yesus dhaa boe ngaa-ngaa. Hèia kètu kapai ne karèi hari, na, “Jaꞌa neo karèi! Te ngaa Èu hudꞌi dhaa tareꞌa-reꞌa ku, nuka sèmi Èu dhaa mi Ama Lamatua dhu mamuri ètu sorga. Abhu dhèu dhu peka na, Èu ne, Kristus, Ana Ama Lamatua dhu Na moa tèke karèi nèti uru ka. Tareꞌa sèmi èèna, do?” ");
INSERT INTO nfa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Hèia Yesus bꞌala, peka na, “Tareꞌa, nuka sèmi lii ama èèna. Te ngaa sanèdꞌe! Te bèli-camèdꞌa miu mèdhi Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne. Pe Jaꞌa madhèdi ètu baboa gꞌana Ama Lamatua ètu sorga, sèna ka kèdꞌu paredha sama-sama dènge Ne, dhu koasa Na kapai risi eele èèna. Èle na, Jaꞌa puru mai hari ètu dedha raꞌi-liru.” ");
INSERT INTO nfa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ropa na tadèngi nare Yesus peka sèmi èèna, hèia kètu kapai ne nasa bia, toke na ciu pamae kodho madhera na. Hèia na paꞌoo mi dhèu aaꞌi-aaꞌi dhu madhèdi ètu sèra, aku nèngu na, “Èdhi parluu sakasii tao ngaa hari era! Miu unu mi tadèngi le dènge roꞌa dhilu miu, lii padhai Na. Nèngu tao iisi Na jꞌajꞌi Ana Ama Lamatua. Neꞌe ne pahaha Ama Lamatua! Miu aaꞌi-aaꞌi mi meꞌa le, na, madhutu atora agama èdhi, ladhe abhu dhèu dhu tao iisi na nuka sèmi Ama Lamatua, na, dhèu ne hudꞌi madhe ku! ");
INSERT INTO nfa_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","De miu neo pamaꞌète sèmi mia hari?” Hèia aaꞌi-aaꞌi ra parodha, peka na, “Dhèu neꞌe ne mema sala tareꞌa! De hudꞌi huku pamadhe Ne!” ");
INSERT INTO nfa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ka dhèu pèri-pèri lasi sabhuu ilu mi Yesus. Hèia ra hake-paru, aa tèbꞌe paꞌoke Ne. ");
INSERT INTO nfa_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Èle ka, ra lalangu Ne, peka na, “Wee! Èu neꞌe ka Kristus, si? Èu peka sèku! Dhèu cee ka dhu jꞌubhu Èu?” ");
INSERT INTO nfa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lodꞌo èèna, Petrus madhèdi era ètu madha èmu. Ka ènu bhèni ca dhèu mai lii dènge ne, peka na, “Deo na, èu kahèi palere-lere dènge Yesus, dhèu Nasaret èèna, si?” ");
INSERT INTO nfa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Te ngaa na pasili ètu madha dhèu ae sèra, peka na, “Aadꞌo! Nga tao ka èu karèi sèmi èèna! Jaꞌa tadhe boe Ne.” ");
INSERT INTO nfa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ka Petrus kalua laꞌe titu ètu hèbꞌa oka. Hèia bhèni leo hari èci ladhe nèdhi ne ètu èèna. Ka bhèni ne peka dènge dhèu ètu sèra, aku nèngu na, “Deo na jaꞌa kèdhi dhèu neꞌe ne palere-lere dènge Yesus, dhèu Nasaret èèna.” ");
INSERT INTO nfa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hèia Petrus jèke ne, peka na, “Èu ne tao-tao hujꞌu! Jaꞌa bani subha! Jaꞌa tadhe boe Dhèu nèi!” ");
INSERT INTO nfa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nèbhu boe ka dhèu leo ètu sèra sa peka dènge ne, “Hee! Èu ne baku kapodꞌe-kabèli dꞌara lii, dhu peka na, èu kako palere boe dènge Dhèu ne! Te nèti lii padhai èu, èci èèna ka dènge laloe lii dhèu Galilea!” ");
INSERT INTO nfa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Te ngaa na padhèdꞌa, ka bꞌala, aku nèngu na, “Wee! Jaꞌa subha dènge kolongara Ama Lamatua! Jaꞌa tadhe boe Dhèu neꞌe ne!” Ropa na peka nare sèmi èèna, hèia manu kokotoo dènge. ");
INSERT INTO nfa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ropa na tadèngi lii kokotoo manu, hèia Petrus ngee nèdhi lii Yesus, dhu peka na, “Manu dhae kokotoo mèka, te èu dhu pasili le tèlu hari, peka na, èu tadhe boe Jaꞌa.” Sanèdꞌe nare lii neꞌe, hèia laꞌe asa liꞌu ka tangi dꞌara pèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Madꞌae aae era, dhèu aaꞌi-aaꞌi dhu uri lii langu agama sèra, rare lii èci sèna ka neo pamadhe Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nèti èèna ka, ra èki Ne rèti asa madha gubernur Pilatus. Te rèngu dꞌèi sèna ka gubernur huku pamadhe Ne. ");
INSERT INTO nfa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ropa Yudas tadèngi na, Yesus abhu hahuku madhe, hèia na manyasa, lula nèngu ka dhu pahie Yesus. Ka laꞌe hari asa kètu agama Yahudi dènge dhèu heka adꞌa sèra, ho neo hia hari laꞌa doi iia 30 (tèlu nguru) bua sèra. ");
INSERT INTO nfa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Na peka na, “Jaꞌa tao le sasala-sasigo, lula jaꞌa pahie le Dhèu dhu dènge boe sasala.” Te ngaa dhèu se bꞌala, aku rèngu na, “Wee! Jiꞌi se pusi-pahae heka èu ne! Èu mesa mu ka dhu dꞌui more sasala èèna.” ");
INSERT INTO nfa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ka Yudas cebꞌe eele doi sèra asa dꞌara Èmu Kapua Manèngi-Mangajꞌi. Hèia laꞌe kadhoe iisi na, toke na madhe aapa. ");
INSERT INTO nfa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hèia kètu agama Yahudi sèra kaboko rare doi dhu na cebꞌe eele sèra. Ra padhue, aku rèngu na, “Doi seꞌe mage èdhi tao asa dꞌara boaraka doi, lula doi se doi kajꞌalu. ");
INSERT INTO nfa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","De beꞌa risi èdhi hèli tare rai ca kasibꞌi nèti dhèu tao èru rai sèi. Ladhe dhèu mai nèti rai leo, do, dhèu dhu èdhi tadhe boe madhe, èdhi padhane si ètu era neꞌe ne.” ");
INSERT INTO nfa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ka ra hèli rai ne, kabꞌua na nèti doi deo sa. Nèti èèna ka, rai ne, toke dꞌai sange neꞌe, dhèu pangare na, ‘Rai Raa’. ");
INSERT INTO nfa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dènge jꞌara neꞌe, rèngu madhutu lii nèti ca dhèu nèti lii padhai Ama Lamatua, ngara na Yermia, dhu suri tèke na, “Rèngu pake doi iia 30 (tèlu nguru) bua ho hèli rai. Rèngu pake doi se, lula doi se kabꞌua nèti hèli dhèu, madhutu sèmi dhu dhèu Israꞌel pamaꞌète rare le. ");
INSERT INTO nfa_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rai ne, rèngu hèli nèti dhèu tao èru rai, madhutu lii paredha dhu Ama Lamatua hia mi jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ropa dhèu se rèti Yesus dꞌai gubernur, hèia na karèi Yesus, “Tasamia? Èu ne, tareꞌa-reꞌa Dhèu Aae dhèu Yahudi, do?” Na dhaa, peka na, “Tareꞌa. Ama peka lèke kèna.” ");
INSERT INTO nfa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Te ngaa ropa kètu agama Yahudi dènge dhèu heka adꞌa sèra galaa Ne dènge lii langu ae-ae, Na dhaa boe ca hèbꞌa sa hèi. ");
INSERT INTO nfa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ka gubernur karèi hari Ne, peka na, “Èu tadèngi boe lii padhai lii rèngu, do? Dhèu se hia sasala ae-ae mi dedha Èu. Te ngaa tasamia ka Èu bꞌala boe si hèi?!” ");
INSERT INTO nfa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Te ngaa Na dhaa boe ca hèbꞌa sa hèi, toke gubernur malaa. ");
INSERT INTO nfa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tèu mai-tèu mai, dhu tema le, ladhe dꞌai ka lodꞌo kalela Paska, dhèu Yahudi hagꞌe rare ana bèdho ca dhèu, sèna ka gubernur patabuli ne. ");
INSERT INTO nfa_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tèu èèna, dhèu bèdho ca dhèu, ngara na Barabas. Dhèu aaꞌi-aaꞌi tadhe le nèngu ne, lula nèngu ca dhèu bhelu-katubꞌa titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lodꞌo èèna kahèi, dhèu ae lasi asa gubernur Pilatus ho manèngi, sèna ka patabuli dhèu bèdho èci, sèmi biasa. Hèia Pilatus karèi si, aku nèngu na, “Beꞌa. De jaꞌa patabuli cee? Ètu neꞌe Barabas, aa abhu kahèi Yesus, dhu dhèu paroa Ne, Kristus. Mia ka dhu jaꞌa patabuli? Miu ka dhu pamaꞌète.” ");
INSERT INTO nfa_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Gubernur peka sèmi èèna, te neꞌa na kètu agama Yahudi rèti Yesus asa nèngu, lula rèngu se tèka dꞌara dènge Yesus.) ");
INSERT INTO nfa_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gubernur ètu dꞌara uri lii langu ne era, dhèu èmu na moa lii, peka na, “Ama! Mage-mage, oo! Te Yesus ne dhu dènge boe sasala. Lula Nèngu neꞌe ka, mèda deo na, jaꞌa nii aapa. Toke dꞌai sange neꞌe, dꞌara jaꞌa dhae tèka mèka.” ");
INSERT INTO nfa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Te ngaa kètu agama Yahudi dènge dhèu heka adꞌa sèra, dadugu dhèu ae ètu èèna, ho ra manèngi gubernur patabuli Barabas, aa huku pamadhe Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ka na karèi hari si, aku nèngu na, “Nèti dhèu dua se, mia ka dhu jaꞌa patabuli?” Hèia aaꞌi-aaꞌi ra dhaa, peka na, “Barabas! Patabuli Barabas di!” ");
INSERT INTO nfa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Èle ka na karèi si, aku nèngu na, “Ladhe sèmi èèna, jaꞌa tao tasa mera mia mi Yesus, dhu ra peka na Kristus ne?” Hèia aaꞌi-aaꞌi ra paꞌoo-parodha peka na, “Paku pamadhe Ne asa ajꞌu palolo-palèbha!” ");
INSERT INTO nfa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Èle èèna ka, gubernur karèi hari, peka na, “Te sala Na, ngaa? Jaꞌa parisa le, te ngaa abhu boe sasala Na èci sa!” Te ngaa ra asa paꞌoo-parodha, aku rèngu na, “Pamadhe Ne! Paku Ne asa ajꞌu palolo-palèbha!” ");
INSERT INTO nfa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nèbhu boe, na neꞌa heka tao tasamia hari, lula dhèu seꞌe asa ka ra hino neo patao. Nèti èèna ka, nare èi ho jꞌamo ai ètu madha dhèu ae-ae sèra, aa na peka dènge ra, aku nèngu na, “Jaꞌa tago boe mamadhe Dhèu neꞌe ne! Miu aaꞌi-aaꞌi mi ka dhu hudꞌi pasae mere mamadhe Na!” ");
INSERT INTO nfa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hèia dhèu seꞌe dhaa dènge lii paꞌoo-parodha peka na, “Oo, hudꞌi laa! Hudꞌi laa jiꞌi dènge ana-èpu jiꞌi tago ngare raa Na!” ");
INSERT INTO nfa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ropa tadèngi nare, hèia na peka, “Laꞌa, sina ma.” Hèia na patabuli Barabas madhutu dadꞌèi ra. Èle èèna ka, na pua dhèu jꞌaga, lasi kalabhe Yesus pake gui. Game rare, ka sordadꞌu rèti Yesus, sèna ka neo paku pamadhe Ne ètu ajꞌu palolo-palèbha. ");
INSERT INTO nfa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Èle èèna ka, sordadꞌu ère rèti Yesus asa tana lapa ètu dꞌara benteng rèngu. Dꞌai nèi, rèngu paroa rare angalai ra ca batalion. ");
INSERT INTO nfa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hèia ra papake Ne kodho madhera èci dhu mea aae. ");
INSERT INTO nfa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ka rare loro ajꞌu padhudhu ra ènyu tao sèmi solo. Hèia ra ènyi solo ne mi kètu Yesus, ho ra sasei Ne, tao nuka sèmi rèngu dedꞌe dhèu aae hiu, dhu pake solo dhèu aae. Èle èèna ka, ra jꞌole hia Ne ajꞌu caꞌèta asa ai gꞌana Na, nuka sèmi tatea paredha. Hèia ra patitu kètu urutuu ra, patangara dènge Yesus, aa ra pamakae Ne, peka na, “Pakabꞌua dhèu aae dhèu Yahudi.” ");
INSERT INTO nfa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hèia ra sabhuu Ne ilu, aa rare ajꞌu caꞌèta dhu Na kèpe deo na, ka ra dꞌeu kètu Na. ");
INSERT INTO nfa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ropa ra sasei rare Ne, hèia ra bhoke eele kodho madhera. Èle èèna ka, ra papake hari mèdha-papake Na. Ka rèti Ne asa liꞌu kota Yerusalem, ho neo paku Ne mi ajꞌu palolo-palèbha. ");
INSERT INTO nfa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ropa ra ère rèti Yesus, dꞌai talora jꞌara paraga dènge dhèu kota Kirene èci dhu neo laꞌe asa dꞌara kota. Ngara na, Simon. Dhèu se laka-seti ne, sèna ka pasae ajꞌu palolo-palèbha gati Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ka ra dꞌai era èci, ngara na Golgota. (Ètu dꞌara lii Aram, sasoa na, “Era rui kètu.”) ");
INSERT INTO nfa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ètu era neꞌe, dhèu seꞌe hia Yesus ninu èi anggor dhu pabꞌali rare le dènge èi naꞌi dhu pèdꞌu, sèna ka bisa taha rarii. Ka Yesus camuci, hèia juku eele. ");
INSERT INTO nfa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Èle èèna ka, dhèu seꞌe paku Yesus asa ajꞌu palolo-palèbha. Hèia sordadꞌu se ère lot, sèna ka nèti rèngu, cee ka dhu abhu mèdha-papake Na. ");
INSERT INTO nfa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ka ra madhèdi madhenge Yesus ètu era neꞌe. ");
INSERT INTO nfa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ra suri kahèi ètu papa èci, peka na, “NEꞌE NE YESUS, DHÈU AAE DHÈU YAHUDI” Ka ra paku papa ne re dedha kètu Yesus, sèna ka dhèu reꞌa nga tao ka rèngu huku Ne. ");
INSERT INTO nfa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ètu era neꞌe, ra paku pamadhe parapo dhèu dua kahèi. Ca dhèu re bèka gꞌana Yesus, aa èci hari re bèka kariu Na. ");
INSERT INTO nfa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dhèu aaꞌi-aaꞌi dhu kako re sèra, laladhe Ne. Hèia ra pakapengo hèbꞌa ra, ho lalangu Ne. ");
INSERT INTO nfa_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Dhèu seꞌe rodhe Ne, peka na, “Eeh! Èu peka na, Èu bisa paguri eele Èmu Kapua Manèngi-Mangajꞌi Ama Lamatua, ho èèna na patitu hari ètu dꞌara tèlu lodꞌo, si? Ladhe Èu tareꞌa-reꞌa Ana Ama Lamatua, na, papuru ngiꞌu Mu nèti ajꞌu palolo-palèbha èèna.” ");
INSERT INTO nfa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sèmi èèna kahèi dènge kètu agama Yahudi, mese agama, dènge dhèu heka adꞌa sèra. Ra pahahe Yesus, aku rèngu na, ");
INSERT INTO nfa_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nèngu ne pamamuri le dhèu leo, te ngaa Na bisa boe patabuli eele ngiꞌu Nèngu unu Na. Nèngu mesa Na peka na, Nèngu dhèu aae Israꞌel! Ladhe sèmi èèna, beꞌa risi Na puru ka nèti ajꞌu palolo-palèbha èèna. Ladhe jiꞌi ngèdhi ka jꞌajꞌi sèmi èèna, jiꞌi heka parcaya Nèngu kèna. ");
INSERT INTO nfa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ladhe Nèngu ne tareꞌa-reꞌa Ana Ama Lamatua, hudꞌi laa, ‘Na maena mi Ama Lamatua. De ladhe Lamatua dꞌèi Ne, hudꞌi laa Lamatua ka dhu pamamuri Ne.’ ” ");
INSERT INTO nfa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dhèu parapo dhèu dua se, pahahe Ne sèmi èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Èle èèna ka, maroga kiu-kiu saguru nare era neꞌe, karèi nèti lodꞌo titu mera toke dꞌai hake tèlu nihia. ");
INSERT INTO nfa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dꞌai hake tèlu, hèia Yesus paꞌoo pake lii Aram, na, “Eli! Eli! Lema sabaktani?” (Sasoa na, “Ama Lamatua Jaꞌa! Lamatua Jaꞌa! Nga tao ka Ama soro kabodho ho tèke eele Jaꞌa mesa-mesa Ku sèmi neꞌe ne?”) ");
INSERT INTO nfa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Abhu pèri-pèri dhèu dhu dètu ètu sèra, tadèngi lii Na sèmi èèna, hèia ra papeka, “Mi nanene ku laa. Na paroa Elia, ca dhèu nèti lii padhai Ama Lamatua dhu uru sèra!” ");
INSERT INTO nfa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ka ca dhèu rai laꞌe nare ula, cèbꞌu asa dꞌara èi anggor manyilu. Hèia na èki mi suu tatea èci, ka jꞌole asa hèbꞌa Yesus sèna ka Na camuci. ");
INSERT INTO nfa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Te ngaa cahagꞌe hari peka na, “Èdhi ladhe sèku, teko-teko Elia mai pamamuri Ne, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ka Yesus paꞌoo hari dènge lii mèdhu, hèia Na madhe. ");
INSERT INTO nfa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi, abhu bèla dhu bhèla aae kadhoe paꞌabhe Kama Luri Mola-Mèci Ama Lamatua. Lèke dènge Yesus maꞌète aꞌae èèna, bèla dhu bhèla aae ne mae, cèri mi dua, nèti dedha toke haha. Hèia rai opo, toke hadhu aae-hadhu aae mae sègꞌi bagi mi dua. ");
INSERT INTO nfa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Roꞌa-roꞌa dhèu madhe bhoke kahèi. Aa dhèu unu Ama Lamatua dhu madhe le, abhu dhu Na pamamuri hari. ");
INSERT INTO nfa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ropa Yesus mamuri hari le nèti mamadhe Na, hèia dhèu madhe sèra bhodho mai nèti dꞌara roꞌa, ka lasi asa Yerusalem. Ètu era neꞌe dhèu ae rèdhi si. ");
INSERT INTO nfa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ètu Golgota, abhu komedhaa dènge sordadꞌu na dhu jꞌaga ètu ajꞌu palolo-palèbha Yesus èèna. Ropa ladhe rèdhi rai opo, dènge aaꞌi-aaꞌi dhu jꞌajꞌi seꞌe, rèngu madhaꞌu titu kèna. Ka ra papeka, na, “Ira ii! Dhèu neꞌe ne, tareꞌa-reꞌa Ana Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ètu era neꞌe, abhu bhèni pèri-pèri dhèu dhu laladhe mamadhe Yesus nèti kajꞌèu. Rèngu seꞌe ka dhu madhutu Ne nèti Galilea, te rèngu ka dhu lalau-laloꞌo Ne karèi nèti uru. ");
INSERT INTO nfa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dhèu bhèni seꞌe, nuka Maria nèti rae Magdala, Maria èci hari (nuka ina Yakobis dènge Yusuf), aa dènge dhèu èmu Sabadeus (nuka ina nèti Yakobis dènge Yohanis). ");
INSERT INTO nfa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ètu èèna, abhu dhèu kaja èci nèti rae Arimatea, ngara na Yusuf. Nèngu ne dhu nèbhu le madhutu aꞌajꞌa Yesus. Lodꞌo mamadhe Yesus lèke hari Jumat. Asa bèli èèna, lèke dènge lodꞌo sabajꞌa dhèu Yahudi. Nèti èèna ka, ropa lodꞌo oe cèna, hèia Yusuf tenge jꞌara ho neo papuru ngiꞌu aae Yesus nèti ajꞌu palolo-palèbha. ");
INSERT INTO nfa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Hèia laꞌe asa gubernur Pilatus, sèna ka manèngi papuru ngiꞌu aae Yesus. Ka gubernur paredha, sèna ka ngiꞌu aae Yesus saraka mi Yusuf. ");
INSERT INTO nfa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ka Yusuf laꞌe asa Golgota, hèia na papuru ngiꞌu aae Yesus nèti ajꞌu palolo-palèbha. Hèia na hutu pabeꞌa-beꞌa ngiꞌu aae ne dènge bèla hiu dhu kabꞌua. ");
INSERT INTO nfa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tèu èèna, dhèu heka pae rare roꞌa èci ètu ledhe hadhu, sèna ka tao tèke roꞌa hia Yusuf dènge aꞌari na, ladhe dꞌai lodꞌo rèngu madhe. De Yusuf si nedhe rèti ngiꞌu aae Yesus ne, lasi pajꞌunu asa roꞌa deo na. Ka ètu hèbꞌa roꞌa ne, ra saguru dènge hadhu kabela aae cue, ho ra bèdho pabeꞌa-beꞌa hèbꞌa roꞌa ne. Èle èèna ka Yusuf si lèpa. ");
INSERT INTO nfa_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Lodꞌo èèna, Maria nèti Magdala, dènge Maria dhu leo èci madhutu dꞌai era èèna kahèi. Ra madhèdi patangara dènge roꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Asa bèli èèna, lèke dènge lodꞌo ae sasabꞌa dhèu Yahudi. Hèia kètu agama Yahudi dènge dhèu Parisi lasi paraga dènge gubernur. ");
INSERT INTO nfa_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ra peka, “Ama. Jiꞌi sanèdꞌe era, lodꞌo dhèu kapodꞌe-kabèli èèna mamuri era, Na peka, na, ‘Jaꞌa madhe tareꞌa, te ngaa èle tèlu lodꞌo, Jaꞌa mamuri hari.’ ");
INSERT INTO nfa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nèti èèna ka, ama paredha ku sordadꞌu sèra, ho ra jꞌaga paie-iie roꞌa èèna dꞌai tèlu lodꞌo. Dènge jꞌara neꞌe, ana madhutu Na bani boe manaꞌu rèti ngiꞌu aae Na, sèna ka ra monya peka na, Nèngu mamuri hari. Te ladhe rèngu kapodꞌe-kabèli sèmi èèna, risi eele nèti mamonya rèngu uru sèra, lodꞌo dhu ra peka na, Nèngu ne nuka Kristus.” ");
INSERT INTO nfa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ropa tadèngi nare, hèia gubernur dhaa, aku nèngu na, “Beꞌa kahèi! Te ngaa miu dènge dhèu madhenga kahèi. Beꞌa risi miu pua si, ho lasi jꞌaga paie-iie roꞌa nèi.” ");
INSERT INTO nfa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Èle ka lasi asa era èèna, rèti dènge dhèu madhenga ra. Dꞌai era neꞌe, ra segel madhe babèdho roꞌa ne. Hèia ra pua dhèu sèra madhenga, sèna ka dhèu leo baku mai rare ngiꞌu aae Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ka ètu dꞌara hari Migu madꞌae aae era, Maria nèti Magdala, dènge Maria dhu leo èci, lasi asa roꞌa Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kacaꞌa la rai opo kapai titu kèna. Ana pajuu Ama Lamatua ca dhèu puru mai nèti sorga, hèia na loli eele hadhu aae dhu saguru roꞌa. Ka na madhèdi ètu dedha hadhu ne. ");
INSERT INTO nfa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rèhu ana pajuu ne kaleꞌe sèmi kahaꞌa bela, aa mèdha-papake na pudhi mèu. ");
INSERT INTO nfa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dhèu madhenga se, madhaꞌu bia toke ra karèbha, ka rèngu bisa boe kalau-karèto, nuka sèmi dhèu madhe sa. ");
INSERT INTO nfa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hèia ana pajuu nèti sorga ne, lii dènge dhèu bhèni seꞌe, aku nèngu na, “Miu baku madhaꞌu! Jaꞌa keꞌa miu se mai tenge Yesus, Dhèu dhu ra paku pamadhe ètu ajꞌu palolo-palèbha èèna. ");
INSERT INTO nfa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Te ngaa Nèngu aadꞌo heka ètu era neꞌe. Te Na mamuri hari le, sama sèmi dhu Na peka le uru èèna. Maso mai, sèna ka mèdhi unu mi era dhu ra pajꞌunu ngiꞌu aae Na. Era ne ngaa-ngaa aadꞌo heka! ");
INSERT INTO nfa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","De pamèri lèpa ka! Lami lolo dènge ana madhutu Na, peka na, Yesus mamuri hari le. Laꞌe uuru le asa Galilea. Rèngu hudꞌi lasi paraga uuru ku dènge Ne ètu nèi, sèmi dhu uru èèna, Na moa mema mi rèngu. Parcaya la. Lèpa ka, lami lole ngaa dhu jaꞌa peka ne!” ");
INSERT INTO nfa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hèia bhèni se rai liꞌu lasi, tèke eele era neꞌe. Ra madhaꞌu, te ngaa ra karejꞌe-karae kahèi. Ka ra pamèri-mèri lèpa, lasi peka jꞌara se aaꞌi-aaꞌi ra mi ana madhutu Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Te ngaa ropa dꞌai talora jꞌara, kabèdhi la Yesus mai paraga dènge ra. Ka Na lii, aku Nèngu na, “Saloom!” Ropa ladhe rèdhi, hèia lasi padètu-dètu, liku rare haga Na, dènge pahaha iisi ra mi Yesus. ");
INSERT INTO nfa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hèia Na padhai lii, peka na, “Baku madhaꞌu! Lami peka dènge ana madhutu Jaꞌa, sèna ka ra lasi mate jaꞌa ètu Galilea nèi.” ");
INSERT INTO nfa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lodꞌo dhèu bhèni se ètu talora jꞌara era, dhèu madhenga se lèpa le asa kota. Rèngu lasi lole ngaa dhu jꞌajꞌi se mi kètu agama Yahudi sèra. ");
INSERT INTO nfa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hèia kètu agama Yahudi rare lii èci dènge dhèu heka adꞌa sèra, sèna ka bꞌae doi ae-ae mi dhèu jꞌaga ho ra hutu hèbꞌa. ");
INSERT INTO nfa_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kètu agama Yahudi sèra peka, na, “Ladhe dhèu karèi miu, dhaa sèmi neꞌe: dꞌara mèda, ropa jiꞌi bhèjꞌi luu, ngeꞌa boe, na, ana madhutu Na mai manaꞌu rèti ngiꞌu aae Na. ");
INSERT INTO nfa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aa ladhe gubernur tadèngi, mage miu madhaꞌu, te jiꞌi ka dhu ator dènge ne.” ");
INSERT INTO nfa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hèia dhèu madhenga se rare doi. Aa ra tao madhutu dadꞌèi kètu agama seꞌe. Nèti èèna ka, toke dꞌai sange neꞌe dhèu-dhèu Yahudi parcaya era lii lolo kapodꞌe-kabèli ne. ");
INSERT INTO nfa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ropa tadèngi rare lii lolo nèti dhèu bhèni seꞌe, hèia ana madhutu Yesus dhèu canguru èci, lasi paraga dènge Yesus asa propensi Galilea, ètu ledhe èci, madhutu lii moa Na. ");
INSERT INTO nfa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ropa ra ladhe rèdhi Ne, ka ra pahaha iisi mi Nèngu. Masi ka sèmi èèna, te ngaa abhu kahèi dhu dꞌara ra kajari era. ");
INSERT INTO nfa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hèia Na ara mai padètu-dètu dènge ra, ka Na lii, “Ama Lamatua pangèdꞌu le koasa mi Jaꞌa, sèna ka Jaꞌa paredha aaꞌi-aaꞌi ètu sorga, aa dènge aaꞌi-aaꞌi ètu rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","De miu lami asa mia-mia, miu hudꞌi peka-padhai ku dènge dhèu nèti suku aaꞌi-aaꞌi ra, Lii Lolo Beꞌa Jaꞌa ne. Aa miu hudꞌi ajꞌa si paie-iie, ho sèna ka rèngu jꞌajꞌi ana madhutu Jaꞌa. Aa miu hudꞌi sarani si ho jꞌajꞌi mi tadha, peka na, rèngu dhu paꞌèki le dènge Ama, dènge Ana, aa dènge Roh Na dhu Mola-Mèci. ");
INSERT INTO nfa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aa nori si sèna ka ra tao madhutu paredha aaꞌi-aaꞌi dhu Jaꞌa peka tèke le dènge miu. Sanèdꞌe, ee! Jaꞌa bera-bera dènge miu toke èle rai-haha ne.” ");
INSERT INTO nfa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Neꞌe ne, Lii Lolo Beꞌa lula-nèti Ana Ama Lamatua. Ngara na Yesus Kristus, dhu Ama Lamatua pajꞌujꞌu karèi nèti uru ka mai. Lii lolo Na mulai sèmi neꞌe: ");
INSERT INTO nfa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lodꞌo Yesus sabꞌa mèka sasabꞌa Na, Ama Lamatua pua uru dhèu èci, ngara na Yohanis, laꞌe tao tèke jꞌara hia Yesus dhu mai bèli-camèdꞌa. Lula uru èèna, Ama Lamatua peka le dènge dhèu nèti lii padhai Na, ngara na Yesaya. Na suri tèke, peka na, “Nanene! Jaꞌa pua le dhèu èci, ho bhoke jꞌara hia Èu. ");
INSERT INTO nfa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dhèu èèna laꞌe asa dꞌara mamoo, ho na rodhe, peka na, ‘Miu aaꞌi-aaꞌi mi tao pabeꞌa ku jꞌara, sèna ka sèmi mere mamai Lamatua! Pamera jꞌara ho soru mamai Na.’ ” ");
INSERT INTO nfa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Ra pangare dhèu neꞌe, Yohanis, tuka sarani dhèu. Era pea nèngu ètu dꞌara mamoo. Kodho na tao nèti rèu badha onta, dhara hake na, tao nèti kaꞌuri badha. Ngangaꞌa nèngu kabara dènge dhua nasu oni. Lodꞌo èèna, dhèu ae nèti kota Yerusalem dènge propensi Yudea, mai paraga dènge Yohanis ètu era pea na. Dhèu se mai neo rèdhi Yohanis, aa nanene lii holo-nori na. Na peka, “Hua iia miu ele-hoꞌa nèti tatao karehe, sèna ka Ama Lamatua saku eele sasala-sasigo miu. Èle èèna miu sarani uuru ku jꞌajꞌi mi tadha, na, miu beꞌa le dènge Lamatua.” Nèti èèna ka, dhèu seꞌe bhoka sasala rèngu, ka Yohanis sarani si ètu loko Yarden. ");
INSERT INTO nfa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ka na peka hari, “Bèli-camèdꞌa dhèu èci mai, dhu kapai risi nèti jaꞌa. Lula jaꞌa ne haha dꞌai seli, neo jꞌajꞌi ana pua-paleha èèna ka, lèke boe sa hèi. ");
INSERT INTO nfa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jaꞌa ne dhodhoka sarani miu dènge èi di, te ngaa Nèngu tao risi eele nèti jaꞌa. Te Na papènu dꞌara miu dènge Roh Ama Lamatua dhu Mola-Mèci.” ");
INSERT INTO nfa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ca lodꞌo hari, Yesus laꞌe nèti rae Nasaret ètu rai Galilea, ka Na paraga dènge Yohanis. Èle èèna ka Yohanis sarani Ne ètu loko Yarden. ");
INSERT INTO nfa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ropa Yesus bhodho nèti dꞌara èi mai, Na ladhe, na, liru bhoke eele, ka Roh Ama Lamatua puru mai sama sèmi koro jꞌaha ciꞌu, puru mai asa Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kacaꞌa la, ra tadèngi lii Ama Lamatua nèti dedha-liru, peka na, “Èu ne, Ana pasue Jaꞌa, Èu pakarejꞌe taruu dꞌara Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nèbhu boe ka, Roh Ama Lamatua jajuku Yesus asa dꞌara mamoo laꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na pea dènge badha hui ètu èèna, èpa nguru lodꞌo. Ka dhèu aae nidhu mai dadugu tenge jꞌara sèna ka Yesus madhutu nèngu, te ngaa tao nare boe. Èle èèna ka, ana pajuu nèti Ama Lamatua puru mai lalau-laloꞌo Ne. ");
INSERT INTO nfa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lodꞌo dhu kèpe rare Yohanis tuka sarani pamaso asa dꞌara bèdho, nèbhu boe ka Yesus pakèdꞌi laꞌe propensi Galilea. Laꞌe lole Lii Lolo Beꞌa nèti Ama Lamatua ètu nèi. ");
INSERT INTO nfa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ka Na peka, “Mi nanene! Lodꞌo Ama Lamatua dꞌai kèna! Limuri ne, dhèu aaꞌi-aaꞌi reꞌa, na, Ama Lamatua nèdꞌu le paredha karèi nèti uru ka. Nèti èèna ka, miu hudꞌi tèke eele ka tatao karehe sèra, ho lèpa madhutu Ama Lamatua. Hèia parcaya ka Lii Holo-Nori Nèngu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ca lodꞌo hari, Yesus kako re sebhe dano Galilea, ka nèdhi dhèu dua, ngara ra Simon dènge ari na Anderias. Sasabꞌa rèngu bèli-bèli èèna, jꞌala iꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ka Yesus paroa nare dua ra, peka na, “We! Mai madhutu Jaꞌa! Miu tema tenge iꞌa, te ngaa Jaꞌa neo ajꞌa miu, sèna ka jꞌajꞌi dhèu tenge samanga.” ");
INSERT INTO nfa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ropa ra nanene rare, hèia ra tèke eele jꞌala rèngu, ka lasi dènge madhutu Ne. ");
INSERT INTO nfa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Èle èèna ka, Yesus kako hari ciki, ka nèdhi ana-ana Sabadeus, aꞌa ngara na Yakobis, aa ari ngara na Yohanis. Dua ra lalau paie pèku ètu dedha koha. ");
INSERT INTO nfa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ka Yesus paroa dua ra, peka na, “Mai we! Madhutu Jaꞌa!” Ropa ra tadèngi rare lii Yesus, ka dua ra tèke eele ama ra, dènge dhèu sabꞌa sa ètu dedha koha, lasi dènge ka madhutu Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Èle èèna ka, Yesus dènge ana madhutu Na dhèu èpa sèra lasi dꞌai kota Kapernaum. Lodꞌo èèna, lodꞌo manèngi-mangajꞌi dhèu Yahudi. Ka Yesus laꞌe asa dꞌara èmu manèngi-mangajꞌi, ka Na lole Lii Holo-Nori Ama Lamatua ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dhèu ae sèra malaa, nanene lii padhai Na, lula Nèngu neꞌa mèu lii dhu Nèngu lole, risi nèti mese-mese agama Yahudi. ");
INSERT INTO nfa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lodꞌo èèna, abhu dhèu èci dhu nidhu tao. Dhèu neꞌe laꞌe asa dꞌara èmu manèngi-mangajꞌi kahèi. Kacaꞌa laa na pakèce, peka na, ");
INSERT INTO nfa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“We! Yesus, dhèu Nasaret! Ngaa unu Èu dènge jiꞌi! Èu mai ho paꞌele iie jiꞌi, do? Jiꞌi tadhe Èu. Èu neꞌe ka dhu mai nèti Ama Lamatua. Èu neꞌe Dhèu dhu dènge boe sasala-sasigo.” ");
INSERT INTO nfa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ka Yesus jèke ne, “Hutu hèbꞌa èu na! Rai eele nèti dhèu neꞌe!” ");
INSERT INTO nfa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kacaꞌa laa nidhu tèku ngiꞌu dhèu neꞌe, sama sèmi dhèu dhu pèdꞌa rèdha. Ka na rai eele nèti dhèu neꞌe, dènge lii pakèce. ");
INSERT INTO nfa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hèia dhèu ètu dꞌara èmu manèngi-mangajꞌi sèra, malaa-maloha. Ka ra padhue èci dènge èci, “Eea! Ngaa ka neꞌe? Neꞌe ne, lii holo-nori dhu hiu, do? Lii padhai lii Mone heka ne, ele madha, nga! Na paredha nidhu se, ka ra kalua kahèi, madhutu dadꞌèi Na.” ");
INSERT INTO nfa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hèia dhèu palolo lème era, ètu dꞌara rae-rae propensi Galilea. ");
INSERT INTO nfa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lodꞌo rèngu lèpa nèti dꞌara èmu manèngi-mangajꞌi, hèia Yesus dènge ana madhutu Na, lasi asa èmu Simon dènge Anderias. ");
INSERT INTO nfa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ina dhèu èmu Simon pèdꞌa maringi-sagoro, ka dhu jꞌunu. Ropa Yesus dènge ana madhutu Na dꞌai dꞌara èmu èèna, dhèu mai peka dènge Ne, “Bhèni heka ne, pèdꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nèti èèna ka, Yesus laꞌe ladhe bhèni heka ne. Hèia Na kèpe kacui-aai na, ho pamadhèdi ne. Kacaꞌa laa papèdꞌa maringi-sagoro èèna èle dènge. Hèia bhèni heka ne kèdꞌi laꞌe lalau ngangaꞌa-nganginu hia si. ");
INSERT INTO nfa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ropa lodꞌo cèna, dhèu pakako rèti asa Yesus aꞌari rèngu dhu pèdꞌa, dènge dhèu-dhèu dhu nidhu tao, sèna ka Na puri-paꞌèle si. ");
INSERT INTO nfa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nèti èèna ka, ca kabarai mai pakaboko pènu tao cèci ètu madha èmu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Èi papèdꞌa ra rupa-rupa, te ngaa Yesus puri-paꞌèle aaꞌi mèu-mèu si. Hèia Na lalèta eele nidhu ae nèti dhèu sèra. Yesus hia boe tebho nidhu seꞌe padhai lii, lula ra tadhe Ne. ");
INSERT INTO nfa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Bèli èèna madꞌae aae era, ako maroga, Yesus kèdꞌi ka laꞌe asa era èci dhu nee-nee, ka Na manèngi-mangajꞌi mi Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ropa Simon si kèdꞌi, rèdhi heka Yesus, ka lasi tenge Ne. ");
INSERT INTO nfa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ra paraga dènge Yesus, ka ra peka, “Ama, dhèu canau mai tenge Ama ku.” ");
INSERT INTO nfa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Te ngaa Yesus dhaa lii rèngu, aku Nèngu na, “Èèna beꞌa kahèi. Te ngaa beꞌa risi lati uru asa rae-rae leo, ho Jaꞌa ajꞌa Lii Holo-Nori Ama Lamatua. Te èèna sasabꞌa-laꞌa Jaꞌa na.” ");
INSERT INTO nfa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Èle èèna ka, rèngu kako palème era ètu propensi Galilea, ho lole Lii Lolo Beꞌa Ama Lamatua. Ètu dꞌara èmu manèngi-mangajꞌi, Na babège-lalèta eele nidhu nèti dhèu sèra. ");
INSERT INTO nfa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dhèu èci dhu lèke papèdꞌa kusta mai paraga dènge Yesus, ka na patitu kètu urutuu ètu madha Yesus. Na manèngi, aku nèngu na, “Ama, ee! Sue ku jaꞌa laa. Tao paꞌèle ku papèdꞌa jaꞌa ne. Jaꞌa keꞌa, na, Ama bisa paꞌèle papèdꞌa jaꞌa ne, sèna ka dhèu madenge heka dènge jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nèti lii roma iisi na, ka dꞌara Yesus roe, ka Na jꞌole kacui-aai ho kèpe ne. Hèia Na peka, “Tareꞌa! Jaꞌa bisa! Èu èle kèna!” ");
INSERT INTO nfa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kacaꞌa laa, papèdꞌa èèna ele dènge. Ka dhèu èèna pèdꞌa heka. ");
INSERT INTO nfa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Èle èèna ka, Yesus pua dhèu èèna lèpa dènge pasanèdꞌe ne, peka na, ");
INSERT INTO nfa_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Mu nanene! Èu èle le, te ngaa baku lole dènge cee-cee! Èu hudꞌi madhutu ku lii paredha Musa uru èèna. De lamu uru ku asa ama agama, ho na parisa ngiꞌu mu. Sèna ka neꞌa èi papèdꞌa èu na ele le, do dhae. Èle èèna ka, heka èu hia mèdha èci sèmi tadha makasi, sèna ka dhèu aaꞌi-aaꞌi reꞌa èu èle le tareꞌa-reꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Masi ka Yesus kai baku peka dènge cee-cee, te ngaa ropa laꞌe dꞌai liꞌu, ka na lolo lème dènge dhèu. Èle èèna ka, dhèu ae neo paraga dènge Yesus. Te ngaa, lula lii dhèu èèna, ka Yesus bisa boe padꞌelo iisi Na asa dꞌara kota. Nèti èèna ka, Yesus pea dhoka ètu era mau èci ètu liꞌu kota. Te ngaa dhèu mai paraga dènge Ne nèti mia-mia. ");
INSERT INTO nfa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Èle pèri-pèri lodꞌo, hèia Yesus lèpa hari asa Kapernaum. Ka ra papeka dꞌai mia-mia, peka na, Yesus dꞌai le èmu. ");
INSERT INTO nfa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nèti èèna ka, dhèu mai nèti mia-mia. Lula dhèu ae seli, ka ètu dꞌara èmu pènu risi, toke dꞌai hèbꞌa èmu. Èle èèna ka, Yesus lole dènge ra dadꞌèi Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ètu talora Na padhai lii era, dhèu èpa jèru dhèu karuku èci neo asa madha Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Te ngaa, lula dhèu ae dꞌai seli, ka rèngu abhu boe sasanga ho rèti dhèu èèna asa madha Yesus. Hèia caꞌe lasi asa kolo èmu, bhoke eele rèu èmu re dedha kètu Yesus. Ropa ra bhoke rare rèu èmu, hèia ra papuru dhèu karuku èena dènge dhèpi na. ");
INSERT INTO nfa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ropa Yesus ladhe nèdhi si, Nèngu neꞌa le dhèu seꞌe parcaya tareꞌa-reꞌa Nèngu. Ka na padhai lii dènge dhèu karuku ne, aku Nèngu na, “Ana, ee! Jaꞌa saku eele le sasala èu!” ");
INSERT INTO nfa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ètu èèna kahèi, abhu pèri-pèri mese agama Yahudi. Ropa ra tadèngi rare lii padhai lii Yesus, ka dꞌara ngangee rèngu beꞌa boe. ");
INSERT INTO nfa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Hèia ra papeka, “Boo! Dhèu neꞌe bani titu kèna, padhai lii sèmi nèi! Dhodhoka Ama Lamatua di, dhu dènge hak ho saku eele sasala dhèu. Te ngaa dhèu neꞌe tao ngiꞌu na èci èèna ka dènge Ama Lamatua. Nèngu pakarehe kolongara Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Te ngaa Yesus neꞌa le ngangee rèngu. Hèia Na peka, “Heh! Miu baku pangee sèmi èèna. ");
INSERT INTO nfa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Mia dhu beꞌa risi? Ladhe Jaꞌa peka mi dhèu karuku ne, ‘Sasala èu saku eele le,’ miu meꞌa boe, na, jꞌajꞌi do aadꞌo. Te ngaa ladhe Jaꞌa peka, ‘Kèdꞌi ka! Nedhe dhèpi èu, ho lèpa ka.’ Ladhe na kèdꞌi ho miu ladhe mèdhi kahèi, heka miu meꞌa kèna, Jaꞌa ne Dhèu Rai-haha Tareꞌa-reꞌa. Aa Jaꞌa dènge koasa kahèi, ho saku eele sasala-sasigo dhèu!” Èle èèna ka, Yesus padhai lii dènge dhèu karuku èèna, peka na, ");
INSERT INTO nfa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Èu nanene, ee! Èu èle le ne! Kèdꞌi ka, nedhe dhèpi èu ho lamu ka.” ");
INSERT INTO nfa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ropa tadèngi nare, cagꞌagꞌa laa dhèu ne kèdꞌi titu. Na nedhe dhèpi na, hèia laꞌe ka asa liꞌu. Dhèu-dhèu ètu sèra rèdhi dènge musi madha ra. Rèngu aaꞌi-aaꞌi ra malaa-maloha, ka ra peka, “Ira ii! Èdhi heka tèdhi ka! Ama Lamatua tareꞌa-reꞌa kapai dꞌai seli!” ");
INSERT INTO nfa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Èle èèna ka, Yesus laꞌe hari asa sebhe dano Galilea. Ka dhèu ae titu kèna mai paraga dènge Ne, hèia Na lole dadꞌèi Ama Lamatua mi rèngu. ");
INSERT INTO nfa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ètu èèna, abhu dhèu èci ngara na Lewi, ana nèti Alpius. Sasabꞌa na roro doi bea. Lodꞌo Yesus kako re èèna ka ladhe nèdhi Lewi. Ka Na peka dènge ne, “Wee! Mai madhutu Jaꞌa!” Ropa tadèngi lii Yesus ne, Lewi kèdꞌi dènge ka laꞌe madhutu Ne. ");
INSERT INTO nfa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Èle èèna ka, Yesus si raꞌa ètu dꞌara èmu Lewi, paꞌèci dènge angalai Lewi dhèu roro doi bea sèra. Abhu kahèi dhèu-dhèu leo madhèdi raꞌa dènge rèngu. Madhutu ngangee dhèu Yahudi, dhèu seꞌe dhèu karehe. Nèti dhèu-dhèu dhu madhèdi raꞌa se abhu dhèu ae kahèi dhu dꞌèi nanene lii padhai lii Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lodꞌo èèna, abhu pèri-pèri mese agama nèti partei Parisi dhu rèdhi Yesus madhèdi naꞌa-ninu dènge tuka roro doi bea, dènge dhèu karehe sèra. Ka ra karèi ana madhutu Yesus, peka na, “Nga tao ka mese miu madhèdi naꞌa-ninu dènge dhèu roro doi bea dènge dhèu dhu laku-laku boe sèra?” ");
INSERT INTO nfa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus tadèngi lii karèi rèngu èèna, ka Na dhaa, peka na, “Dhèu pèdꞌa mema parluu dote, te ngaa dhèu dhu pèdꞌa boe, parluu boe dote. Mamai Jaꞌa ne sèna ka lalau dhèu dhu laku-laku boe. Te Jaꞌa mai boe ho uri dhèu dhu rasa ngiꞌu na mola.” ");
INSERT INTO nfa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ca tèka, dhèu nèti partei agama Parisi puasa. Rèngu rèdhi ana madhutu Yohanis tuka sarani, puasa kahèi. Te ngaa rèdhi boe ana madhutu Yesus puasa sèmi rèngu. Hèia dhèu rèngu mai paraga dènge Yesus, ka ra karèi, aku rèngu na, “Ama. Jiꞌi puasa sama sèmi ana madhutu Yohanis kahèi. Te, nga tao ka, ana madhutu Ama puasa boe?” ");
INSERT INTO nfa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Hèia Yesus dhaa, peka na, “Mema miu meꞌa le, ladhe abhu pesta kabꞌi, dhèu dhu abhu nèru sèra puasa boe, ka raꞌa toke bècu. Ladhe mone dhu kabꞌi èèna era, dhèu sèra aaꞌi-aaꞌi raꞌa-rinu. ");
INSERT INTO nfa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Te ladhe dꞌai lodꞌo ho ra kèpe rèti dhèu mone dhu kabꞌi èèna, ka mone aanga-angalai na sèra dꞌara susa, heka ra puasa kèna. ");
INSERT INTO nfa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sèmi èèna kahèi, bèla hiu baku kalape mi kodho dhui. Te ladhe base, na, bèla hiu èèna karuku, hèia kodho èèna asa ka mae aae. ");
INSERT INTO nfa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sèmi èèna kahèi, miu baku edhe dhua pèdꞌu ètu dꞌara sabha dhui. Te aadꞌo na, sabha èèna mae, aa dhua pèdꞌu na bhori eele asa rai.” Nèti èèna ka Yesus peka dènge si, baku pakihu-kee lii holo-nori Nèngu dhu hiu, dènge lii holo-nori dhèu Parisi dhu dhui. ");
INSERT INTO nfa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ca tèka, lèke lodꞌo manèngi-mangajꞌi dhèu Yahudi, Yesus si kako re jꞌara ètu dꞌara oka. Ka ana madhutu Na gꞌètu rèti are gandum. ");
INSERT INTO nfa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ropa dhèu Parisi ladhe rèdhi, ka ra karèi Yesus, “Tasamia ka, ana madhutu Èu madhutu boe jꞌara-jꞌara agama èdhi? Rèngu se gꞌètu are gandum lèke lodꞌo aꞌoro sasabꞌa. Miu baku tao sèmi èèna!” ");
INSERT INTO nfa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Hèia Yesus dhaa, “Samia, ee? Miu sanèdꞌe heka lii lolo Daud. Tèu èèna, Abyatar jꞌajꞌi kètu kapai risi agama Yahudi. Lodꞌo èèna, Daud dènge dhèu madhutu na aaꞌi-aaꞌi ra manganga bia. Ka ra maso asa dꞌara Paleo Ama Lamatua, hèia raꞌa roti dhu ama agama hia le mi Lamatua. Madhutu atora agama èdhi, dhèu dhu bisa raꞌa roti èèna, dhoka ama-ama agama di; dhèu leo bisa boe. Daud dènge ana madhutu na sèra, raꞌe rare roti èèna, te ngaa dhèu èci sa peka boe, na, Daud si sala.” ");
INSERT INTO nfa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Èle èèna ka, Yesus lole hari dènge rèngu, “Miu baku bhèlu! Lamatua hia lodꞌo aꞌoro sasabꞌa hia èdhi dhèu rai-haha. Lamatua pajꞌajꞌi boe èdhi dhèu rai-haha, ho madhutu dhoka atora lodꞌo aꞌoro sasabꞌa di. ");
INSERT INTO nfa_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Jaꞌa ne ka dhu peka ho dhèu sabꞌa, do aadꞌo, lèke dènge lodꞌo aꞌoro sasabꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Èle èèna ka, Yesus lèpa hari laꞌe asa èmu manèngi-mangajꞌi. Dꞌai nèi, ka Yesus paraga dènge dhèu èci dhu ai na roe cabèka. ");
INSERT INTO nfa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ètu èèna, abhu pèri-pèri dhèu dhu patangi-tenge sasala Yesus. Ra maꞌu Yesus, neo reꞌa Na puri-paꞌèle dhèu pèdꞌa lèke lodꞌo aꞌoro sasabꞌa, do aadꞌo. ");
INSERT INTO nfa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hèia Yesus paroa dhèu dhu ai roe cabèka èèna, aku Nèngu na, “Mai ku! Titu ku mi madha Jaꞌa ne.” ");
INSERT INTO nfa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ka Na karèi dhèu ae ètu sèra sa, aku Nèngu na, “Madhutu atora agama èdhi, èdhi bisa tao ngaa lodꞌo aꞌoro sasabꞌa? Tao madha jꞌara dhu beꞌa, do karehe? Tao pabeꞌa dhèu, do pamadhe dhèu?” Te ngaa dhèu sèra èci sa bani boe bhoke hèbꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nèti èèna ka, Yesus dꞌara pèdꞌa, lula rèngu madhutu dhoka adꞌa di, tao boe madha-dhilu mi dhèu ai roe cabèka ne. Yesus nasa, ka Na ladhe lème dhèu sèra. Hèia Na peka mi dhèu ai roe cabèka, aku Nèngu na, “Jꞌole kacui-aai èu mai sa neꞌe!” Ka dhèu èèna soro kacui-aai asa Yesus laꞌe. Kabèdhi laa, èle dènge papèdꞌa na. ");
INSERT INTO nfa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ropa dhèu Parisi ladhe rèdhi Yesus paꞌèle kacui-aai dhèu èèna lèke lodꞌo aꞌoro sasabꞌa, aaꞌi-aaꞌi ra kalua nèti dꞌara èmu manèngi-mangajꞌi. Ka lasi padhue dènge dhèu partei politik Herodes, ho tenge jꞌara neo pamadhe Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ca lodꞌo, Yesus dènge ana madhutu Na lasi asa sebhe dano Galilea. Te ngaa, lula dhèu ae sèra reꞌa le ngaa dhu Nèngu tao, ka dhèu aaꞌi-aaꞌi mai nèti rae-rae ho madhutu Ne. Rèngu mai nèti propensi Galilea, propensi Yudea, aa propensi Idumea. Abhu kahèi dhu mai nèti kota Yerusalem, kota Sidon dènge kota Tirus. Abhu kahèi cahagꞌe dhu mai nèti cabèka dhimu loko Yarden. Aaꞌi-aaꞌi sèra neo mai paraga dènge Ne. ");
INSERT INTO nfa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Taga dhèu dhu mai sèra ae seli, ka Yesus pua ana madhutu Na lasi tenge koha cue hia Nèngu. Na neo padhai lii dènge dhèu ae sèra nèti dedha koha, sèna ka rèngu aaꞌi-aaꞌi ra bisa ladhe rèdhi rèhu Na, aa tadèngi lii padhai lii Na hèi. ");
INSERT INTO nfa_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ca hari ni, Na puri-paꞌèle dhèu pèdꞌa ae titu kèna. Nèti èèna ka, dhèu ae mai paseti èci dènge èci, neo gꞌagꞌe Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ropa dhèu dhu nidhu tao sa ladhe rèdhi Yesus, ka ra bèbha dꞌai rai ètu madha Yesus. Hèia ra taraa, aku rèngu na, “Èu ne mema tareꞌa Ana Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Te ngaa Yesus kai rèngu, aku Nèngu na, “Miu baku ale dènge dhèu èci sa hèi, Jaꞌa ne cee!” ");
INSERT INTO nfa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Èle èèna ka, Yesus kako laꞌe asa kolo ledhe èci. Na paroa pèri-pèri dhèu dhu Nèngu dꞌèi. Ka dhèu se mai madhutu Ne. ");
INSERT INTO nfa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Èle èèna ka, Na hagꞌe nare dhèu canguru dua. Ka Na peka, “Jaꞌa pili miu ho madhutu taruu Jaꞌa, jꞌajꞌi dhèu pajuu-paleha Jaꞌa. Jaꞌa neo pua miu, lami lole Lii Lolo Beꞌa Ama Lamatua mi dhèu aaꞌi-aaꞌi.” ");
INSERT INTO nfa_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Sèmi èèna kahèi Jaꞌa neo hia miu koasa, sèna ka miu bisa babège-lalèta nidhu nèti dꞌara dhèu.” ");
INSERT INTO nfa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ngara dhèu canguru dua sa, nuka: Simon (dhu Yesus pangare na, Petrus), Yakobis, Yohanis, (Yakobis dènge ari na, Yohanis ne, dua ra ana Sabadeus. Yesus pangare rèngu dua ra, ngara na ‘Boanerges’, dhu sasoa na ‘sama sèmi dꞌoro’.) Anderias, Pelipus, Bertolomeos, Mateos, Tomas, Yakobis (ana Alpius), Tadius, Simon (dhu madhutu partei politik Selot), dènge Yudas Iskariot (dhu èèna na pahie eele Yesus). ");
INSERT INTO nfa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Èle èèna ka, Yesus dènge ana madhutu Na sèra puru hari nèti kolo ledhe deo na. Ka lasi asa dꞌara èmu èci. Dhèu ae titu kèna mai oke rare Ne, ka Na bisa boe naꞌa-ninu. ");
INSERT INTO nfa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Rèdhi sèmi èèna, hèia ra papeka, aku rèngu na, “Miu ladhe ku Yesus! Neꞌa heka lalau iisi Na.” Ropa aꞌari Na tadèngi lii palolo dhèu, ka ra mai neo rare Ne. ");
INSERT INTO nfa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lodꞌo èèna, mese-mese agama nèti Yerusalem mai peka dènge dhèu ètu sèra, aku rèngu na, “Heh! Pasa dhilu miu! Baku madhutu Yesus. Te dhèu aae nidhu, dhu ra paroa ngara na Baalsebul, maso asa dꞌara Yesus, ka hia Ne koasa, ho bata-magèla nidhu nèti dꞌara dhèu.” ");
INSERT INTO nfa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ropa Yesus tadèngi nare lii padhue rèngu èèna, heia Na paroa nare rèngu aaꞌi-aaꞌi ra, ka Na peka, “Lèke boe dènge ngangee dhèu! Tasamia ka dhèu aae nidhu bisa babège ngiꞌu mesa na!? ");
INSERT INTO nfa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ladhe ètu dꞌara paredha dhèu aae èci, ana kabarai sèra èci patao-palaha dènge èci, paredha dhèu aae èèna taha nèbhu boe. ");
INSERT INTO nfa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sèmi èèna kahèi ètu dꞌara èmu, ladhe isi èmu èci patao dènge èci, isi èmu èèna mae-manyèla! ");
INSERT INTO nfa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sèmi èèna kahèi dènge nidhu. Ladhe èci pamusu dènge èci, rèngu mae-manyèla kahèi. Sèmi èèna na, heka rèngu laho kao-kao. ");
INSERT INTO nfa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ladhe dhèu parapo neo mai parapo èmu dhèu èra èci, na hudꞌi èki-karadhe uuru ku lamatua èmu na, heka bau nèti mèdha-panyau kèna. ");
INSERT INTO nfa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nèti èèna ka, Jaꞌa peka mema dènge miu: Ama Lamatua sadia saku eele sasala dhèu. Ladhe dhèu padhai lii karehe mi dedha dhèu leo, Ama Lamatua bisa saku eele sasala na era. ");
INSERT INTO nfa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Te ngaa lii padhai lii karehe mi dedha Roh Ama Lamatua dhu Mola-Mèci, Ama Lamatua saku eele boe sasala nèngu, toke dꞌai mia-mia laꞌe!” ");
INSERT INTO nfa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus peka sèmi èèna, lula dhèu sèra peka na, “Dhèu èèna, nidhu tao.” ");
INSERT INTO nfa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Èle èèna ka, ina dènge ari Yesus sèra mai tenge Ne. Dꞌai èmu dhu Yesus madhèdi ètu dꞌara na, rèngu lasi boe asa dꞌara, te ngaa ra titu ètu liꞌu, ka ra hia dhèu lasi paroa Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lasi, na, Yesus madhèdi padhai lii dènge dhèu ae. Ka dhèu sèra peka dènge Ne, “Ama, ee! Ina Mu dènge aꞌari Mu nuka ètu liꞌu si. Ra neo paraga dènge Ama.” ");
INSERT INTO nfa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Te ngaa Yesus dhaa, peka na, “Cee ka dhu tareꞌa-reꞌa jꞌajꞌi ina dènge aꞌari Jaꞌa?” ");
INSERT INTO nfa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Hèia Na ladhe palème asa dhèu dhu madhèdi ètu sèra, ka Na peka, “Miu seꞌe se ka dhu tareꞌa-reꞌa jꞌajꞌi ina dènge aꞌari Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Te cee ka dhu madhutu dadꞌèi Ama Lamatua, rèngu sèra ka dhu tareꞌa-reꞌa jꞌajꞌi ina dènge aꞌari Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ca lodꞌo, Yesus laꞌe hari asa dano Galilea. Dꞌai nèi dhèu ae mai oke rare Ne. Ka Yesus caꞌe laꞌe madhèdi asa dedha koha cue dhu panahu. Na ajꞌa dhèu sèra dènge lii pakasame. Dhèu dhu titu ètu dedha salae sèra aaꞌi-aaꞌi nanene Yesus ajꞌa Lii Holo-Nori Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na ajꞌa si lii holo-nori rupa-rupa pake lii pakasame. Aku Nèngu sèmi neꞌe ka: ");
INSERT INTO nfa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nanene paie-iie! Dhèu èci laꞌe cebꞌe hini ètu dꞌara oka na. ");
INSERT INTO nfa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ropa na cebꞌe hini sèra, cahagꞌe lèke ètu sebhe jꞌara. Kabèdhi laa, manu-bhui mai ka raꞌa aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Cahagꞌe hari lèke ètu era rai dhu pènu dènge hadhu. Hini sèra muri, te ngaa rai isi dhoka ciki ooꞌe di. ");
INSERT INTO nfa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ropa lodꞌo rea mai, ana ngangaꞌa sèra kamale eele hèia madhe aaꞌi si, lula amo dꞌai boe dꞌara rai. ");
INSERT INTO nfa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hini cahagꞌe lèke ètu dedha rai dhu pènu dènge jꞌuꞌu padhudhu. Ropa jꞌuꞌu sèra muri, hèlu rare ana ngangaꞌa sèra, ka jꞌajꞌi boe hua-hela. ");
INSERT INTO nfa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Te ngaa hini cahagꞌe lèke ètu dedha rai hèu mèngi. Hini sèra muri dènge sega. Hua ae titu kèna. Cahagꞌe dhu abhu dꞌai tèlu nguru hari, cahagꞌe èna nguru hari, aa cahagꞌe dꞌai cangasu hari. ");
INSERT INTO nfa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","De ladhe cee dènge roꞌa dhilu, na, nanene paie!” ");
INSERT INTO nfa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ca tèka, Yesus mesa Na. Hèia ana madhutu Na dhèu canguru dua dènge pèri-pèri dhèu dhu tadèngi le lii holo-nori Na, mai paraga dènge Ne. Ka ra karèi sasoa nèti lii pakasame èèna. ");
INSERT INTO nfa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hèia Yesus dhaa, “Lula miu tareꞌa-reꞌa neo meꞌa Lii Holo-Nori Ama Lamatua, Jaꞌa neo peka dènge miu. Te ngaa mi dhèu leo, Jaꞌa pake lii pakasame. ");
INSERT INTO nfa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tatao dhèu leo sèra sama sèmi dhèu nèti lii padhai Ama Lamatua suri tèke, peka na, ‘Rèngu rèdhi le, te ngaa roꞌo boe reꞌa. Rèngu tadèngi le, te ngaa roꞌo boe tèke ètu dꞌara. Ladhe sèmi èèna, hudꞌi rèngu sène. Ra parcaya ia ka Lamatua, sèna ka Lamatua saku eele ia ka sasala ra.’ ” ");
INSERT INTO nfa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Èle èèna ka, Yesus peka dènge dhèu sèra sasoa lii pakasame hini èèna, aku Nèngu na, “Ladhe miu meꞌa boe sasoa nèti lii upama deo na, carui risi hari miu meꞌa sasoa lii pakasame dhu leo. ");
INSERT INTO nfa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","De sasoa na sèmi neꞌe ka: dhèu dhu cebꞌe hini èèna, nuka dhèu dhu lole Lii Holo-Nori Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Hini dhu lèke ètu sebhe jꞌara ka manu-bhui mai raꞌa aaꞌi, nuka sèmi dhèu dhu nanene Lii Holo-Nori Ama Lamatua. Te ngaa nèbhu boe, dhèu aae nidhu mai parame rare Lii Holo-Nori nèti dꞌara dhèu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aa hini dhu lèke ètu dedha hadhu, nuka sèmi dhèu dhu nanene, ka na sèmi nare Lii Holo-Nori èèna dènge dꞌara karejꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Te ngaa Lii Holo-Nori ne, taha nèbhu boe ètu dꞌara dhèu èèna. Ropa nèngu paraga jꞌajꞌèra lula na sèmi nare lii neꞌe, na tèke eele. ");
INSERT INTO nfa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aa hini dhu lèke ètu talora jꞌuꞌu dhu padudhu, èci èèna ka dènge Lii Holo-Nori Ama Lamatua dhu dhèu nanene. ");
INSERT INTO nfa_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Te ngaa dhèu èèna bhute dhoka dènge rupa-rupa madha jꞌara rai-haha dhu pakarejꞌe ngiꞌu na. Nèti èèna ka, jꞌara seꞌe seti eele Lii Holo-Nori Ama Lamatua nèti dꞌara nèngu, ka jꞌajꞌi heka ngaa-ngaa. ");
INSERT INTO nfa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Te ngaa hini dhu lèke ètu dedha rai hèu mèngi, nuka sèmi dhèu dhu pasa dhilu ho nanene Lii Holo-Nori Ama Lamatua dènge karejꞌe-karae. Tatao nèngu madhutu dadꞌèi Ama Lamatua dènge dꞌara kateme. Dhèu neꞌe tao jꞌara-jꞌara dhu pakarejꞌe dꞌara Ama Lamatua, sama sèmi hini dhu nèti hua-hela. Abhu kahèi dꞌai tèlu nguru hari, cahagꞌe dꞌai èna nguru hari, aa abhu kahèi dhu dꞌai cangasu hari.” ");
INSERT INTO nfa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nèti dedha koha, Yesus tuhu hari lii padhai Na. Na peka hari lii upama èci, aku Nèngu na, “Tasamia, ee! Miu mèdhi le, do dhae? Dhèu suru rare labhu, ka saguru eele hari dènge soe! Ka ra tèke asa roꞌa koi laꞌe! Aadꞌo, sina ma? Te ladhe sèmi èèna, tèdhi boe saraa nèngu. Dhèu hudꞌi tao labhu ètu era dhu dedha, sèna ka dhèu rèdhi saraa nèngu. ");
INSERT INTO nfa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ngaa dhu dhèu pahuni deo neꞌe, bèli-camèdꞌa dhèu rèdhi aaꞌi. Te ngaa dhu dhèu reꞌa boe lodꞌo deo neꞌe, bèli-camèdꞌa dhèu reꞌa aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","De ladhe cee dhu dènge roꞌa dhilu, na, nanene paie! ");
INSERT INTO nfa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nanene paie-iie! Ladhe miu tenge sasala dhèu, na, dhèu leo tenge sasala miu kahèi. Sèmi èèna kahèi, Ama Lamatua tenge sasala miu. Te ngaa Na tao bia risi hari nèti èèna. ");
INSERT INTO nfa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ladhe dhèu èci neo tenge tareꞌa-reꞌa dadꞌèi Lamatua, nèngu asa dꞌèlu-mèu. Te ngaa ladhe dhèu pusi-pahae boe dadꞌèi Lamatua, nèngu jꞌajꞌi asa goa.” ");
INSERT INTO nfa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Èle èèna ka, Yesus tuhu hari lii padhai Na, aku Nèngu na, “Paredha Ama Lamatua asa tabha kapai, sama sèmi hini dhu dhèu cebꞌe ètu dꞌara oka na. ");
INSERT INTO nfa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nèngu cebꞌe nare, ka laꞌe bhèjꞌi. Tao heka ai hèbꞌa mi hini sèra. Te ngaa hini sèra muri, ka asa kapai. ");
INSERT INTO nfa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hini se muri unu ra. Mulai ti rèu, hela, toke dꞌai huri. ");
INSERT INTO nfa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ropa kasere nare ngangaꞌa dhu ètu dꞌara oka mami, dhèu unu oka heka laꞌe puu-gꞌètu kèna. Sèmi èèna kahèi, paredha Ama Lamatua. Lamatua ka dhu adꞌu-ue aaꞌi-aaꞌi sèra.” ");
INSERT INTO nfa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Èle èèna ka, Yesus padhai lii hari, “Jaꞌa peka hari lii upama èci sèmi neꞌe ka: miu ladhe sèku, dhèu dhu jꞌajꞌi unu Lamatua sèra. Uru èèna ciki di, nèbhu-nèbhu jꞌajꞌi ae. ");
INSERT INTO nfa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Èèna sama sèmi lamusi ajꞌu dhu ana iiki-iiki. ");
INSERT INTO nfa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ladhe èdhi sèla lamusi èèna, na muri mai, jꞌajꞌi ajꞌu dhu kapai aae. Manu-bhui nèti mia-mia mai tèka tenge mamaho, dènge tao rèdꞌa ètu kolo ajꞌu èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jꞌara-jꞌara aꞌajꞌa Yesus madhutu rareꞌa dhèu. ");
INSERT INTO nfa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ladhe Na ajꞌa dhèu leo, Na pake lii pakasame. Te ngaa ladhe Na ajꞌa ana madhutu Na, Nèngu peka aaꞌi-aaꞌi sasoa lii pakasame sèra. ");
INSERT INTO nfa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dꞌai lodꞌo nihia na, Yesus ajꞌa dhèu nèti dedha koha era. Hèia Na pua ana madhutu Na sèra, peka na, “Mai èdhi pakèdꞌi lati asa cabèka dano.” ");
INSERT INTO nfa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ka ra caꞌe koha èci dènge Yesus. Ra pakèdꞌi tèke eele dhèu ae sèra ètu èèna. Te ngaa dhèu cahagꞌe caꞌe koha leo madhutu Yesus si. ");
INSERT INTO nfa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Lodꞌo èèna, Yesus pasaluu kètu Na mi nanèlu, ka bhèjꞌi luu ètu hui koha. Nèbhu boe ka, ngèlu aae mai. Naha kapai, ka èi tao sabhori oe pènu koha Yesus si. Nèti èèna ka, ana madhutu Yesus sèra madhaꞌu bia. Hèia ra parèi Ne, “Ama! Kèdꞌi ku laa! Èdhi oe molo kèna! Te ngaa Ama pusi-pahae boe!” ");
INSERT INTO nfa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ropa Yesus tadèngi lii parèi ra, ka Na kèdꞌi, hèia Na kai ngèlu, peka na, “Mau ka!” Ka Na paredha naha, aku Nèngu na, “Mera ka!” Hèia ngèlu mau, aa naha mera dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Èle èèna ka, Yesus jèke ana madhutu Na, peka na, “Nga tao ka miu madhaꞌu sèmi èèna? Miu parcaya Jaꞌa, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Rèngu aaꞌi-aaꞌi ra madhaꞌu dènge malaa, ka èci peka dènge èci, “Te dhèu ngaa ne? Ka bisa ngèlu dènge naha, madhutu lii paredha Nèngu?” ");
INSERT INTO nfa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Èle èèna ka, Yesus dènge ana madhutu Na sèra dꞌai cabèka dano Galilea. Era èèna, ngara na Garasa. ");
INSERT INTO nfa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Ètu èèna, abhu dhèu mone èci dhu nidhu tao, ka na hujꞌu. Dhèu hujꞌu ne pea ètu era padhane dhèu madhe. Mèu-mèda na kako caꞌe-puru ledhe ètu èèna, dènge pake boe mèdha-papake. Na paꞌoo-parodha maꞌète boe, aa na nare hadhu ho tuku iisi na toke dꞌai nuꞌa. Na èra titu kèna. Nèti èèna ka, dhèu èci sa bisa boe èki ne. Masi ka ra èki dènge rate bèsi èèna ka, bisa boe kahèi. Pèri-pèri hari, dhèu ujꞌu haga-ai na kahèi, pake rate dènge kanau bèsi, te ngaa na pamaꞌète aaꞌi si. Dhèu ne èra bia, nèti èèna ka, èci sa taha boe ne. Ropa Yesus dènge ana madhutu Na puru nèti dedha koha, dhèu hujꞌu èèna ladhe nèdhi rèngu nèti kajꞌèu. Hèia na kalua nèti era padhane dhèu madhe, ka na mai patitu kètu urutuu ètu madha Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ropa ladhe nèdhi rèhu dhèu neꞌe, hèia Yesus peka, na, “Hee, nidhu bhelu! Kalua pakajꞌèu nèti dhèu neꞌe.” Èle èèna ka, dhèu èèna pajèka, aku nèngu na, “Weh! Èu neo tao ngaa mi jaꞌa? Jaꞌa keꞌa Èu ne Yesus, Ana nèti Ama Lamatua dhu Koasa Risi Eele. Jaꞌa manèngi Èu baku pajꞌèra jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Hèia Yesus karèi ne, “Ngara èu cee?” Na dhaa, aku nèngu na, “Ngara jaꞌa Legion, lula jiꞌi ae titu kèna, sama sèmi ca kaboko sordadꞌu!” ");
INSERT INTO nfa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Èle èèna ka, nidhu sèra peka re dhèu hujꞌu èèna, ho manèngi Yesus, sèna ka baku pua rèngu kalua nèti dꞌara rae ne. ");
INSERT INTO nfa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kajꞌèu boe nèti èèna, abhu hahi ca oka dhu dhèu madhenge. Ele boe hahi sèra dua riho ngiꞌu. Dhu tenge ngangaꞌa ètu sebhe ledhe. ");
INSERT INTO nfa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ka nidhu sèra manèngi Yesus, aku rèngu na, “Hia jiꞌi maso asa dꞌara hahi sèra.” ");
INSERT INTO nfa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tadèngi nare sèmi èèna, hèia Yesus dꞌèi kahèi. Ka nidhu sèra kalua nèti dꞌara dhèu èèna, ka lasi asa dꞌara hahi sèra. Hèia hahi sèra rai pajꞌala, ka lasi asa sebhe tèbhi, ka ra manahu asa dꞌara dano, hèia madhe aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ropa dhèu jꞌaga hahi sèra ladhe rèdhi madha jꞌara dhu jꞌajꞌi èèna, ra madhaꞌu titu kèna. Ka rai lasi peka palème dènge dhèu ètu dꞌara rae-rae dhu dètu ètu era èèna. Nèbhu boe dhèu canau-kateme mai neo reꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dhèu sèra mai paraga dènge Yesus, ka ra ladhe laꞌa, na, dhèu dhu nidhu tao èèna, madhèdi ètu èèna kahèi. Dhèu èèna pake le mèdha-papake. Kahadhu na maseꞌa le. Rèdhi sèmi èèna, hèia dhèu sèra madhaꞌu. Lula rèngu reꞌa le, ladhe dhèu cee dhu bisa babège eele nidhu nèti dꞌara dhèu hujꞌu èèna, nèngu tareꞌa-reꞌa dhèu èra risi. ");
INSERT INTO nfa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Èle èèna ka, dhèu aaꞌi-aaꞌi sèra lasi peka palème ètu mia-mia, aku rèngu na, “Jiꞌi ngèdhi le dènge madha, dhèu hujꞌu ne èle le. Sèmi èèna kahèi hahi dhu madhe ètu dꞌara dano.” ");
INSERT INTO nfa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ka dhèu kabarai èèna mai manèngi ho Yesus tèke eele ka rai rèngu. ");
INSERT INTO nfa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ropa Yesus neo caꞌe hari asa dedha koha, ka dhèu dhu èle nèti hujꞌu dhu nidhu tao èèna manèngi Yesus, sèna ka nèngu madhutu Ne kahèi. ");
INSERT INTO nfa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Te ngaa Yesus kai. Ka Na peka dènge dhèu èèna, aku Nèngu na, “Beꞌa risi èu lèpa ka asa èmu, ho peka dènge aꞌari èu, ngaa dhu Ama Lamatua tao le mi dedha èu. Peka dènge si, mema Ama Lamatua sue èu titu kèna.” ");
INSERT INTO nfa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Èle èèna, hèia dhèu èèna pakèdꞌi laꞌe palème rae-rae nèti canguru kota, dhu ngara na ‘Dekapolis’. Na lole ngaa dhu Yesus tao le mi dedha nèngu. Dhèu-dhèu dhu tadèngi lii lolo na, malaa aaꞌi mèu-mèu, aku rèngu na, “Mema lèke tareꞌa!” ");
INSERT INTO nfa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Èle ka, Yesus si pakèdꞌi hari dènge koha asa cabèka dano. Ropa ra puru nèti dedha koha, dhèu ae mai lingu rare Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dhèu èci mai, ngara na Yairus. Nèngu ne, kètu èmu manèngi-mangajꞌi dhèu Yahudi ètu kota èèna. Ropa nèngu nèdhi Yesus, ka mai patitu kètu urutuu ètu madha Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ka na pamako, peka na, “Ama, ee! Ana bhèni jaꞌa, heka canguru dua tèu, pèdꞌa oe madhe. Mai lati ku asa èmu jaꞌa, sèna ka puri-paꞌèle ne nèti papèdꞌa na.” ");
INSERT INTO nfa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Hèia Yesus laꞌe dènge ka, madhutu Yairus asa èmu na. Te ngaa ètu dꞌara kakako rèngu, dhèu ae titu kèna, ka ra seti Ne nèti haa, nèti dhimu. ");
INSERT INTO nfa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ètu talora dhèu ae sèra, abhu dhèu bhèni èci dhu pèdꞌa dhèu bhèni. Papèdꞌa ne loe boe canguru dua tèu kèna. ");
INSERT INTO nfa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mèdha-panyau dènge doi-dhari dhèu bhèni neꞌe, èle aaꞌi mèu-mèu ho bꞌae dote. Te ngaa papèdꞌa na èle boe, asa na hoe. ");
INSERT INTO nfa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Bhèni ne tadèngi ae le dhèu palolo ngaa dhu Yesus tao. Nèti èèna ka, na mai pasuki asa talora dhèu ae sèra, ho na padètu dènge Yesus. Na pangee, na, “Sadꞌi jaꞌa gai lèke sebhe kodho Na di, tatu papèdꞌa jaꞌa èle.” Ropa na gai lèke sebhe kodho Yesus, kabèdhi laa raa bhèni ne tèja eele dènge. Hèia na rasa, na beꞌa le. ");
INSERT INTO nfa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lodꞌo èèna kahèi, Yesus rasa aꞌèra kalua nèti dꞌara ngiꞌu Na. Ka Na kabibꞌa asa kabodho, ho ladhe asa dhèu ae sèra, ka Na karèi, peka na, “Nèti miu se, cee ka dhu gai lèke kodho Jaꞌa?” ");
INSERT INTO nfa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka ana madhutu Na dhaa, aku rèngu na, “Ama, ladhe ku laa. Dhèu ae paseti sèmi neꞌe. Nga tao ka Ama karèi, peka na, ‘Cee ka dhu gai kodho Jaꞌa?’ ” ");
INSERT INTO nfa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Te ngaa Yesus ladhe pala-lème, neo neꞌa cee ka dhu gai lèke sebhe kodho Na. ");
INSERT INTO nfa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ropa Yesus karèi sèmi èèna, hèia bhèni èèna madhaꞌu bia. Èle èèna ka, na mai patitu kètu urutuu ètu madha Yesus, ka na mangaku, “Ama! Jaꞌa ka dhu gai lèke sebhe kodho Ama ku deo na.” ");
INSERT INTO nfa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hèia Yesus peka mi bhèni ne, aku Nèngu na, “Lula èu parcaya Jaꞌa dènge dꞌara kateme, nèti èèna ka, èu èle le. Lamu ka èmu, dènge dꞌara karejꞌe-karae.” ");
INSERT INTO nfa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ropa Yesus padhai lii era, hèia dhèu èci mai nèti èmu Yairus, aku nèngu na, “Ira ii! Ana mu madhe le. De baku pajꞌèra ia ka Ama Mese. Nèngu laꞌe ia ka sa nèi.” ");
INSERT INTO nfa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Te ngaa Yesus pusi boe dènge lii padhai lii dhèu neꞌe. Ka Na peka dènge Yairus, “Èu baku madhaꞌu, ee! Parcaya mi Ama Lamatua di.” ");
INSERT INTO nfa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Hèia Yesus laꞌe dènge ka, tèke eele ana madhutu Na cahagꞌe. Nèti dhoka Petrus, Yakobis dènge Yohanis. ");
INSERT INTO nfa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ropa dꞌai èmu Yairus, rèngu rèdhi dhèu jau oobꞌa-jau oobꞌa, aa tadèngi cahagꞌe tangi dꞌara pèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus maso asa dꞌara, ka Na karèi si, aku Nèngu na, “Nga tao ka miu maruru dènge tangi sèmi neꞌe? Ana neꞌe madhe boe! Nèngu dhoka bhèjꞌi di.” ");
INSERT INTO nfa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dhèu ètu sèra tadèngi Yesus peka sèmi èèna, ka ra mari pakapengo hèbꞌa dènge Ne. Hèia Na pua dhèu sèra kalua aaꞌi nèti dꞌara kama ana dhu madhe èèna. Ka Na paroa ina-ama ana bhèni ne, dènge ana madhutu Na dhèu tèlu sèra, maso asa dꞌara. ");
INSERT INTO nfa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Hèia Yesus kèpe kacui-aai ana dhu madhe ne, ka Na padhai lii pake lii rèngu, lii Aram, aku Nèngu na, “Talita kum!” (Sasoa na, “Ana bhèni! Kèdꞌi ka!”) ");
INSERT INTO nfa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Kabèdhi laa, ana dhu madhe èèna mamuri hari. Hèia na kèdꞌi titu, ka na kako. Hèia Yesus peka dènge ina na, aku Nèngu na, “Hia ana neꞌe naꞌa-ninu!” Dhèu ae ètu sèra dhu rèdhi jꞌara dhu jꞌajꞌi ne, ra malaa titu kèna. Hèia Yesus kai si, peka na, “Mage mi peka dènge dhèu èci sa, Jaꞌa ka dhu pamamuri hari ana ne.” ");
INSERT INTO nfa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Èle èèna ka, Yesus dènge ana madhutu Na sèra aaꞌi-aaꞌi ra, lèpa hari asa rae Na, Nasaret. ");
INSERT INTO nfa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lodꞌo èèna lèke dènge lodꞌo sabajꞌa dhèu Yahudi. Hèia Yesus laꞌe asa dꞌara èmu manèngi-mangajꞌi ho Na ajꞌa Lii Holo-Nori Ama Lamatua ètu èèna. Lodꞌo èèna, dhèu ae lasi manèngi-mangajꞌi. Ropa ra tadèngi Yesus ajꞌa Lii Holo-Nori Ama Lamatua, hèia dhèu aaꞌi-aaꞌi sèra malaa, aku rèngu na, “Dhèu ne mèu samia ne! Na dènge koasa kahèi! Tasamia ka Na sèmi èèna, ee? ");
INSERT INTO nfa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nèngu neꞌe dhoka tuka ajꞌu di. Èdhi tadhe ina Na, Maria. Sèmi èèna kahèi ari Na, Yakobis, Yoses, Yudas dènge Simon, dènge ari Na dhèu bhèni sèra. Rèngu dènge èdhi pea ca rae.” Dhèu seꞌe ngee ètu dꞌara rèngu na, rèngu mèu risi nèti Yesus. Nèti èèna ka, ra dꞌèi heka nanene Ne. ");
INSERT INTO nfa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ka Yesus peka, “Mema tareꞌa! Dhèu pakabꞌua risi dhèu nèti lii padhai Ama Lamatua nèti rae leo. Te ngaa ra pakabꞌua boe dhèu nèti lii padhai Ama Lamatua dhu nèti rae nèngu.” ");
INSERT INTO nfa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Dꞌara dhèu sèra adhu sèmi hadhu, ka ra parcaya boe lii padhai lii Yesus. Nèti èèna ka, Na malaa, hèia Na pake boe koasa Na. Ka Na puri-paꞌèle dhoka dhèu pèri di, ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Èle èèna ka, Yesus kako palème asa rae-rae dhu padètu ètu sèra, ho ajꞌa dhèu jꞌara mamuri Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na paroa nare ana madhutu Na dhèu canguru dua sèra, ka Na pua rèngu lasi dua-dua ho lole Lii Lolo Beꞌa nèti Ama Lamatua. Na hia si koasa kahèi, ho babège eele nidhu nèti dꞌara dhèu. ");
INSERT INTO nfa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Na peka dènge si, aku Nèngu na, “Miu baku mèti mèdha ae ètu dꞌara kakako miu. Baku mèti ngangaꞌa, doi, dènge tas. Mèti dhoka tatea, salapa ètu haga, dènge kodho ètu ua di. ");
INSERT INTO nfa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ladhe cee dhu sèmi rare miu ètu èmu ra, miu pea dhoka ètu èèna di, toke dꞌai pakèdꞌi hari. ");
INSERT INTO nfa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te ngaa ladhe miu lami asa era èci, hèia dhèu ètu sèra sèmi rare boe miu, aa ra dꞌèi boe nanene lii padhai lii miu, tèke eele era èèna. Aa peka mi dhèu sèra, na, ‘Miu moꞌo boe nanene, si! De bèli-camèdꞌa sèmi mere pala mi!’ ” ");
INSERT INTO nfa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Èle èèna ka, ra lasi lole Lii Lolo Beꞌa. Ra peka, dhèu aaꞌi-aaꞌi hudꞌi ele hoꞌa nèti sasala-sasigo ra, ka lèpa ho mamuri madhutu dadꞌèi Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ka ra babège eele nidhu nèti dꞌara dhèu. Ra pasuti èi lèngi mi kètu dhèu pèdꞌa, aa sabajꞌa ho paꞌèle si nèti papèdꞌa. Ka ra èle dènge. ");
INSERT INTO nfa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lodꞌo èèna, dhèu ètu mia-mia tadhe aaꞌi le Yesus. Dhèu aae Herodes tadèngi le lii lolo lula-nèti koasa Yesus kahèi. Dhèu palolo ètu mia-mia, aku rèngu na, “Yohanis tuka sarani èèna, mamuri hari le ètu dꞌara ngiꞌu Yesus! Nèti èèna ka, Na bisa tao tadha malaa sèra.” ");
INSERT INTO nfa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te ngaa dhèu cahagꞌe hari peka, aku rèngu na, “Aadꞌo! Neꞌe ne, Elia dhu mamuri hari dꞌara ngiꞌu Yesus.” Aa dhèu cahagꞌe hari, peka na, “Dhèu neꞌe ne, dhèu nèti lii padhai Ama Lamatua dhu leo hari nèti uru sèra.” ");
INSERT INTO nfa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ropa dhèu aae Herodes tadèngi nare lii lolo dhèu seꞌe lula-nèti Yesus, ka na dhaa, peka na, “Èèna Yohanis tuka sarani, dhu ca hari ni jaꞌa hia dhèu pare pamadhe le, te ngaa na mamuri hari!” ");
INSERT INTO nfa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Dhèu aae Herodes pua sèmi èèna, lula nèngu lii langu dènge Yohanis. Lii lolo na sèmi neꞌe ka: dhèu aae Herodes leo nare dhèu èmu ari na, Pelipus, ngara na Herodias. Aa te ngaa Pelipus dènge Herodias dhae paꞌia mèka. Nèti èèna ka, Yohanis kai pahari-pahari, peka na, “Ama dhèu aae baku leo dènge dhèu èmu ari mu. Te èèna sisu adꞌa èdhi dhèu Yahudi.” Masi ka sèmi èèna, te ngaa Herodes leo nare bhèni neꞌe kahèi. Hèia na pua dhèu lasi kèpe rare Yohanis, ho pamaso ne asa dꞌara bèdho. ");
INSERT INTO nfa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Lula Yohanis kai pèri hari le, hèia bhèni ne tèka dꞌara dènge ne, ka na neo pamadhe ne. Te ngaa lake nare mèka, te Herodes dhu pamaso le Yohanis asa dꞌara bèdho laꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ka na pua sordadꞌu sèra madhenge paie ne ètu dꞌara bèdho. Herodes madhaꞌu dènge Yohanis. Na neꞌa tareꞌa, Yohanis ne dhèu dhu Ama Lamatua pua mai. Aa Yohanis ne dhèu dꞌara mola. Herodes dꞌèi nanene lii padhai lii Yohanis kahèi. Te ngaa stèka-stèka, dꞌara na pèdꞌa nanene lii padhai lii Yohanis. ");
INSERT INTO nfa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ka ca tèka, Herodias abhu lodꞌo dhu beꞌa, sèna ka na bꞌala dꞌara pèdꞌa na. Lodꞌo èèna, lèke dènge hari jadi Herodes. Ka ra nèru dhèu aae-dhèu kapai mai raꞌa-sisi hari jadꞌi. Dhèu dhu mai sèra, ama-ama dhu paredha, ama-ama sordadꞌu, dènge dhèu heka-dhèu heka adꞌa ètu Galilea. ");
INSERT INTO nfa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ètu dꞌara talora tatao èèna, ana bhèni Herodias laꞌe roge. Na roge beꞌa risi eele, ka dꞌara Herodes dènge dhèu dhu nèru sèra karejꞌe bia. Nèti èèna ka, Herodes paroa ne mai asa madha, ka na karèi, aku nèngu na, “Èu neo manèngi ngaa? Èu peka ho jaꞌa hia. ");
INSERT INTO nfa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Èu manèngi era paredha jaꞌa ne bagi dua, hia èu cabèka èèna ka, jaꞌa koꞌo kahèi. Jaꞌa subha dènge ngara Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ka ana bhèni èèna laꞌe karèi ina na, aku nèngu na, “Ina, ee! Madhutu ngangee ina ku, na, jaꞌa manèngi ngaa dhu beꞌa risi nèti ama ku?” Ka ina na dhaa, aku nèngu na, “Lamu asa madha ama mu ho peka dènge ne, jaꞌa manèngi dhoka kètu Yohanis di.” ");
INSERT INTO nfa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ka ana bhèni ne laꞌe asa madha Herodes, ka na peka, aku nèngu na, “Ama! Jaꞌa manèngi kètu Yohanis, tao ètu dꞌara dula èci hia jaꞌa. Deo neꞌe ne, kahèi!” ");
INSERT INTO nfa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ropa Herodes tadèngi nare lii manèngi ana bhèni na, ka dꞌara na cagꞌagꞌa. Te ngaa nèngu bisa heka ère hari lii subha nèngu deo na, lula dhèu ètu sèra tadèngi aaꞌi le. ");
INSERT INTO nfa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Èle èèna ka, Herodes paredha komedhaa sordadꞌu lasi poro rare kètu Yohanis nèti dꞌara bèdho. ");
INSERT INTO nfa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ropa ra poro rare, ra tao asa dꞌara dula èci, ka rèti laꞌa asa ana bhèni èèna. Na sèmi nare, hèia nèti asa ina na laꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ropa ana madhutu Yohanis sèra tadèngi ra poro rèti le kètu Yohanis, rèngu mai nedhe rèti ngiꞌu nèngu lasi padhane. Dꞌai sange neꞌe ka, lii lolo mamadhe Yohanis. ");
INSERT INTO nfa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ca lodꞌo hari, ana madhutu Yesus dhu Na pua lasi asa rae-rae ho ajꞌa dhèu jꞌara mamuri Ama Lamatua sèra, lèpa hari mai, ka ra pakaboko hari dènge Ne. Ra lolo dènge Yesus ngaa dhu rèngu tao dènge ajꞌa mi dhèu. ");
INSERT INTO nfa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lodꞌo èèna, dhèu ae mai patangi-tenge Yesus. Lula dhèu ae seli eele, ka Yesus dènge ana madhutu Na abhu boe tebho raꞌa-rinu hèi. Nèti èèna ka, Yesus ale dènge ana madhutu sèra, peka na, “Beꞌa risi èdhi pakèdꞌi nèti era neꞌe lati tenge era èci dhu mau, sèna ka èdhi ae tara ciki.” ");
INSERT INTO nfa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ka ra caꞌe koha cue lasi asa era dhu mau, kajꞌèu nèti dꞌara rae. ");
INSERT INTO nfa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Te ngaa dhèu ae ètu sèra sa, ladhe rèdhi koha rèngu kako re sebhe dano. Hèia ra kalua nèti rae ka kako pamèri madhutu re dedha rai. Nèti èèna ka, rèngu dꞌai uuru Yesus si. ");
INSERT INTO nfa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ropa Yesus puru nèti dedha koha, ladhe laa, na, dhèu ae dhu mate Ne. Dhèu seꞌe reꞌa heka tao iisi ra tasamia. Nèti èèna ka, dꞌara Yesus sue si, te rèngu sama sèmi kahibꞌi-kalèbho dhu dènge boe ana madhenga. Èle èèna ka, Na ajꞌa si jꞌara mamuri Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Na ajꞌa nèti loo nètu, toke dꞌai nihia laꞌe. Hèia ana madhutu Na sèra mai padhue dènge Ne, aku rèngu na, “Ama! Hua iia Ama ku pua si lasi hèli ngangaꞌa ètu rae dhu dètu ètu era seꞌe. Te oe mèda kèna, aa ètu era neꞌe ngangaꞌa aadꞌo.” ");
INSERT INTO nfa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Te ngaa Yesus bꞌala lii rèngu, aku Nèngu na, “Baku tao sèmi èèna! Hudꞌi laa, pe miu pangaꞌa si.” Hèia ra karèi hari Ne, “Ira, ee! Ladhe èdhi pangaꞌa dhèu ae sèmi neꞌe, èdhi kalua doi ae bia, nga. Sama sèmi gaji tuka ca tèu kateme, nga! Aa èdhi tare doi sèra, nèti mia hua kèna!” ");
INSERT INTO nfa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus dhaa, peka na, “Miu lami karèi sèku dhèu sèra, teko cee dhu nèti ngangaꞌa mèra.” Hèia ra lasi karèi, ka mai peka dènge Ne, “Abhu dhoka roti lèmi bua, dènge iꞌa dua ngiꞌu di.” ");
INSERT INTO nfa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hèia Yesus pua dhèu aaꞌi-aaꞌi sèra ho madhèdi cakaboko-cakaboko ètu dedha jꞌuꞌu. ");
INSERT INTO nfa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dhèu seꞌe madhèdi sèmi dhu Yesus pua. Abhu kaboko dhu dhèu cangasu-cangasu, aa abhu kaboko dhu dhèu lèmi nguru-lèmi nguru. ");
INSERT INTO nfa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hèia Yesus nare roti lèmi bua dènge iꞌa dua ngiꞌu sèra, ka na ladhe asa dedha. Na manèngi makasi mi Ama Lamatua. Èle èèna ka, nare roti lèmi bua, ka Na kuꞌu pamae caꞌèta-ꞌèta. Hèia Na hia mi ana madhutu Na, ho lasi papala hia dhèu dhu madhèdi sèra. Na pala-bagi iꞌa dua ngiꞌu sèra kahèi. ");
INSERT INTO nfa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ka dhèu sèra raꞌa toke bècu. ");
INSERT INTO nfa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Raꞌa èle, hèia ana madhutu Na sèra lasi pakaboko ngangaꞌa dhu risi eele sèra, pènu canguru dua soe. ");
INSERT INTO nfa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Dhèu dhu raꞌa sèra, dhèu mone di, lèmi riho dhèu, ige mèka bhèni dènge ana iiki. ");
INSERT INTO nfa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Èle ka, Yesus pua ana madhutu sèra pakèdꞌi uuru dènge koha asa rae Betsaida ètu cabèka dano. Te Nèngu dhae laꞌe mèka, ho Na pua dhèu ae sèra lèpa. ");
INSERT INTO nfa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ropa dhèu sèra lèpa, Na laꞌe asa ledhe èci ètu èèna, ho Na manèngi-mangajꞌi. ");
INSERT INTO nfa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Lodꞌo mèda le, ka Yesus puru mai. Na ladhe nèdhi ana madhutu Na sèra dènge koha lasi dꞌai talora dano le. Lula ngèlu madha mèdhu ae, ka ra tuku koha dꞌai madhe. Dꞌara oe mèu sa, Yesus heka laꞌe madhutu si kèna. Te ngaa Na kako re dedha èi. Ropa Na kako oe seli koha ra, ana madhutu sèra ladhe rèdhi Ne, ka ra madhaꞌu titu kèna. Hèia èci karèi èci, aku rèngu na, “Irii! Ngaa nèi? Nidhu, do?” Hèia Yesus lii dènge si, aku Nèngu na, “We! Miu baku madhaꞌu! Te Jaꞌa ne!” ");
INSERT INTO nfa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ropa Yesus caꞌe laꞌe asa dedha koha, kabèdhi laa, ngèlu mau dènge. Ana madhutu Na sèra malaa bia. ");
INSERT INTO nfa_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Rèngu heka rèdhi kèna, Yesus pake koasa Na, lodꞌo pangaꞌa lèmi riho dhèu èèna. Te ngaa rèngu reꞌa iia boe koasa Yesus, lula dꞌara rèngu adhu sèmi hadhu. ");
INSERT INTO nfa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ropa rèngu dꞌai cabèka dano, ra panahu koha ètu dae Genesaret. ");
INSERT INTO nfa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ropa ra puru nèti dedha koha, dhèu ae ladhe rèdhi si. Ka ra rodhe lème, aku rèngu na, “Ee! Yesus mai le!” ");
INSERT INTO nfa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Dhèu sèra aaꞌi-aaꞌi ra lasi peka palème rae, nèti èèna ka, dhèu mai nèti mia-mia, jèru rèti aꞌari rèngu dhu pèdꞌa asa Yesus. Sadꞌi ra tadèngi Yesus ètu era èci, na, rame-rame nedhe rèti dhèu pèdꞌa mai. Ra pajꞌunu si ètu dꞌara tana lapa ètu èèna. Te ra pangee, na, “Sadꞌi dhèu pèdꞌa sèra goi lèke sebhe kodho Yesus di, èle dènge nèti papèdꞌa ra.” Ka dhèu goi lèke kodho Na, hèia èle nèti papèdꞌa ra. ");
INSERT INTO nfa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ca lodꞌo, dhèu partei agama Parisi canau dènge mese-mese agama mai nèti kota Yerusalem neo paraga dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Dhèu Parisi kèpe paꞌèra adꞌa Yahudi. Nuka sèmi, dhèu neo raꞌa-rinu hudꞌi jꞌamo uuru ku kacui-aai madhutu atora adꞌa. Sèmi èèna kahèi, ladhe lèpa nèti dꞌara pasa, hudꞌi diu uuru ku èi. Toke mèdha dapu rèngu sèmi èru-pangala, pega, curu, galaa, cere, hudꞌi rase uuru ku madhutu atora adꞌa, heka bisa pake raꞌa-rinu kèna. Ladhe dhèu Yahudi cahagꞌe madhutu boe adꞌa rèngu sèmi èèna, dhèu Parisi nasa. Nèti èèna ka, ra nasa ropa rèdhi ana madhutu Yesus sèra raꞌa-rinu jꞌamo boe kacui-aai madhutu atora adꞌa rèngu. Ka rèngu mai pasala Yesus, peka na, “Nga tao ka ana madhutu èu se raꞌa-rinu jꞌamo uuru boe kacui-aai? Sèra sa, pasala dènge adꞌa nèti bèi-baki èdhi!” ");
INSERT INTO nfa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Te ngaa Yesus dhaa, aku Nèngu na, “Miu se mema padhai lii leo, tao leo! Nèti uru nèka mai Yesaya suri tèke le, lii padhai lii Ama Lamatua sèmi neꞌe, ‘Abhu dhèu dhu koa-kio kolongara Jaꞌa, dhoka dènge hèbꞌa di, te ngaa nèti boe dꞌara. Tatao rèngu sèmi èèna na, lèke boe. Rèngu pusi-pahae boe dadꞌèi Jaꞌa, te ngaa rèngu madhutu dhoka atora dhèu rai-haha di.’ Miu èci èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Miu tèke eele le paredha Ama Lamatua, ho madhutu atora dhèu rai-haha. Tatao miu ne, dꞌèlu-mèu bia! ");
INSERT INTO nfa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Karèi nèti uuru èèna, Musa peka le lii paredha Ama Lamatua sèmi neꞌe ka, ‘Pakabꞌua ina-ama miu.’ Aa tabha hari, peka na, ‘Ladhe ana èci padhèda ama na, do ina na, hudꞌi ra huku pamadhe ne.’ ");
INSERT INTO nfa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Ama Lamatua ajꞌa sèmi èèna, te ngaa miu ajꞌa leo. Miu peka na, ‘Ladhe dhèu èci pamoa le neo hia ngaa èci mi Ama Lamatua, masi ka ina dènge ama na jꞌèra oe madhe èèna ka, te ngaa pake boe mèdha èèna ho soru-bara si, lula nèngu moa le neo hia mi Lamatua.’ ");
INSERT INTO nfa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nèti èèna ka, deo na Jaꞌa peka le, miu pake heka dadꞌèi Ama Lamatua, te ngaa miu gati eele dènge atora miu dhu hiu. Atora ae le dhu miu gati eele sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hèia Yesus paroa hari dhèu leo ètu sèra, ka Na peka na, “Pasa dhilu ho nanene paie, sèna ka miu meꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ngaa dhu maso asa dꞌara dꞌèlu, pakajꞌalu boe. Te ngaa dhu kalua mai nèti dꞌara, èèna ka dhu pakajꞌalu dhèu. ");
INSERT INTO nfa_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cee dènge roꞌa dhilu, na, nanene.” ");
INSERT INTO nfa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Èle èèna ka, Yesus dènge ana madhutu Na tèke eele dhèu sèra, ka lasi asa dꞌara èmu èci. Ka ana madhutu sèra karèi sasoa nèti lii pakasame deo na. ");
INSERT INTO nfa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Hèia Yesus dhaa, peka na, “Miu meꞌa boe kahèi? Sasoa na sèmi neꞌe ka: ngaa dhu dhèu raꞌa, èèna beꞌa. Te ngaa dhu kalua mai, karehe. Èèna beꞌa boe. Ngaa dhu èdhi taꞌa, maso asa dꞌara dꞌèlu, ho èèna na kalua hari asa liꞌu laꞌe. (Lii Yesus èèna neo peka mi èdhi, ngangaꞌa aaꞌi-aaꞌi, èci sa dhu luri boe). ");
INSERT INTO nfa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ngaa dhu mai nèti dꞌara, èèna ka dhu paꞌele iie dhèu, nèti èèna ka, Ama Lamatua dꞌèi boe paꞌèci dènge ne. ");
INSERT INTO nfa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Te jꞌara bhelu-katubꞌa ae ka dhu kalua nèti dꞌara dhèu! Nuka sèmi: ngangee karehe, tao jꞌara makae dènge dhèu dhu dhèu èmu boe nèngu, manaꞌu, pamadhe dhèu, ");
INSERT INTO nfa_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gagoo-gagehu, bersina, bhelu-katubꞌa, leko-monya, dhèu dhu taha nare boe dꞌara, dꞌèi boe dhèu risi nèngu, padhai lii pamanahu dhèu, padedha iisi, tatao dhu lèke boe, dènge kètu hadhu. ");
INSERT INTO nfa_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jꞌara karehe aaꞌi-aaꞌi sèra mai nèti dꞌara dhèu. Sèra ka dhu paꞌele iie dhèu. Ama Lamatua dꞌèi boe dènge dhèu sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Èle ka, Yesus tèke eele era èèna, ka laꞌe asa kota èci, ngara na Tirus. Dꞌai nèi, lasi asa dꞌara èmu èci, lula Yesus dꞌèi boe dhèu reꞌa Nèngu ètu èèna. Te ngaa Nèngu bisa boe pahuni ngiꞌu. ");
INSERT INTO nfa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ètu èèna, abhu dhèu bhèni dintiu èci dhu nèti rai Finisia ètu propensi Siria. Ropa na tadèngi Yesus ètu èèna, na mai manèngi Yesus babège eele nidhu nèti ana bhèni na. ");
INSERT INTO nfa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Te ngaa Yesus core lii èci, peka na, “Ana-ana hudꞌi raꞌa uuru ku, ho sisa na, ra core hia busa kèna.” Dènge lii pacele èèna, Yesus hudꞌi soru-bara uuru ku dhèu Yahudi Nèngu, heka dhèu leo kèna. ");
INSERT INTO nfa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te ngaa bhèni èèna bꞌala, aku nèngu na, “Mema tareꞌa Ama. Te ngaa busa mate le ètu roꞌa mei. Nèngu abhu kahèi ngangaꞌa dhu bèbhe nèti dꞌara pega ana iiki sèra.” Madhutu bhèni èèna, lodꞌo ana raꞌa, na, busa naꞌa kahèi. Masi ka Yesus soru-bara dhèu unu Na, te ngaa Nèngu hudꞌi soru-bara dhèu leo kahèi. ");
INSERT INTO nfa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ropa Yesus tadèngi lii dhaa bhèni ne, hèia Na peka, aku Nèngu na, “Tareꞌa! Lii padhai lii èu èèna, mola-mola na kèna! Lèpa ka! Te nidhu rai le nèti ana èu.” ");
INSERT INTO nfa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hèia bhèni ne laꞌe ka. Na dꞌai èmu, ana na dhu bhèjꞌi luu. Nidhu kalua le. ");
INSERT INTO nfa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Èle èèna ka, Yesus si pakèdꞌi nèti kota Tirus, kako lasi madhutu nebhe dhasi re kota Sidon. Nèti era èèna, rèngu lasi taruu dꞌai dano Galilea. Hèia ra lasi asa rai èci dhu dènge canguru kota, dhu ra biasa pangare na, ‘Dekapolis’. ");
INSERT INTO nfa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ètu èèna, abhu dhèu èci dhu lii aadꞌo aa katele-katipa. Angalai na lere rèti ne asa Yesus. Ra manèngi sèna ka Yesus tao ai mi kètu na, sèna ka na èle. ");
INSERT INTO nfa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hèia Yesus tèke eele dhèu ae sèra, ka laꞌe mesa Na dènge dhèu èèna. Yesus pamaso kacui-aai Na asa roꞌa dhilu dhèu eèna dua-dua. Èle èèna ka, Na tao ilu ètu kacui-aai Na, ka Na gꞌagꞌe heꞌo dhèu neꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Hèia Yesus ladhe asa dedha, Na ère aꞌae madhera, ka Na paredha, aku Nèngu na, “Efata.” (Sasoa na, “Bhoke ka!”) ");
INSERT INTO nfa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na peka dhoka sèmi èèna di, kabèdhi laa, dhilu dhèu èèna tadèngi dènge. Sèmi èèna kahèi, heꞌo dhu sakaa èèna, mako ka na padhai lii dènge. ");
INSERT INTO nfa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Èle èèna ka, dua ra lasi asa era dhèu ae sèra. Ka Yesus kai si, aku Nèngu na, “Nanene, ee! Baku lolo dènge dhèu, peka na, Jaꞌa ka dhu paꞌèle dhèu neꞌe ne.” Masi ka Na kai si, te ngaa dhèu seꞌe lasi lolo palème dꞌai mia-mia. ");
INSERT INTO nfa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dhèu-dhèu dhu tadèngi lii lolo èèna, malaa bia. Ra papeka isi-aanga ra, aku rèngu na, “Dhèu neꞌe, dhèu di, nga! Nèngu tao pabeꞌa aaꞌi mèu-mèu. Dhèu katele bisa tadèngi, aa dhèu lii aadꞌo bisa padhai lii.” ");
INSERT INTO nfa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Ca lodꞌo hari, dhèu ae mai kamue rare Yesus neo nanene lii holo-nori Na. Dhèu sèra tèlu lodꞌo kèna ètu era èèna dènge Yesus. Nèti èèna ka, gee ra èle aaꞌi le. Hèia Yesus paroa ana madhutu Na, ka Na peka, “Jaꞌa rasa kasia dènge dhèu ae seꞌe. Cahagꞌe mai nèti rae kajꞌèu, ètu era neꞌe dꞌai tèlu lodꞌo kèna, ka ngangaꞌa rèngu aadꞌo heka ciki sa. Baku hia ra lèpa dènge kabake manganga. Mage dhoka ra madꞌea ho bèbha ètu jꞌara.” ");
INSERT INTO nfa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ka ana madhutu Yesus sèra dhaa, peka na, “Ama. Era ne kajꞌèu nèti rae. Èdhi pangaꞌa tare boe dhèu ae sèmi neꞌe!” ");
INSERT INTO nfa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Hèia Yesus karèi si, peka na, “Roti miu pèri bua era?” Ka ra dhaa peka na, “Ama. Roti jiꞌi ate dhoka pidhu bua di.” ");
INSERT INTO nfa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ropa nanene nare, hèia Na pua dhèu ae sèra madhèdi ètu rai. Ka nare roti pidhu bua sèra, hèia Na sabajꞌa manèngi makasi mi Ama Lamatua. Sabajꞌa nare, hèia Na pamae roti pidhu bua sèra. Ka Na hia ana madhutu Na papala mi dhèu aaꞌi-aaꞌi sèra. ");
INSERT INTO nfa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Rèngu dènge iꞌa pèri ngiꞌu kahèi. Ka Yesus sabajꞌa hari manèngi makasi. Èle èèna ka, Na hia ana madhutu Na papala hari mi dhèu ae sèra. ");
INSERT INTO nfa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Dhèu aaꞌi-aaꞌi sèra ele boe dꞌai èpa riho sa. Ra raꞌa toke bècu. Raꞌa rare, hèia ana madhutu Yesus pakaboko ngangaꞌa sisa, ka ra ige pidhu soe hahake. Èle èèna ka, Yesus pua dhèu se lèpa. ");
INSERT INTO nfa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ropa dhèu se lèpa, Yesus dènge ana madhutu Na caꞌe koha pakèdꞌi asa rae èci, ngara na Dalmanuta. ");
INSERT INTO nfa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lodꞌo Yesus si dꞌai Dalmanuta, dhèu partei Parisi pèri-pèri mai paraga dènge Yesus. Ra tenge jꞌara neo pamanahu Ne. Ra manèngi, peka na, “Ama. Padꞌelo tadha malaa, sèna ka jꞌajꞌi tadha, peka na, Èu tareꞌa-reꞌa abhu koasa nèti Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hèia Yesus ère aꞌae madhera, ka Na dhaa si, peka na, “Ladhe Jaꞌa madhutu lii padhai lii miu ne, Jaꞌa manyasa! Nga tao ka miu manèngi tadha malaa? Baku sèmi èèna. Jaꞌa bisa tao tadha malaa. Te ngaa Jaꞌa parluu boe padꞌelo mi miu.” ");
INSERT INTO nfa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hèia Yesus tèke eele dhèu Parisi sèra, laꞌe hari asa dedha koha. Ka Na pakèdꞌi dènge ana madhutu Na sèra asa cabèka dano. ");
INSERT INTO nfa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ropa Yesus si dꞌai talora dano, hèia ana madhutu Na sèra heka sanèdꞌe kèna, na, rèngu rèti boe ngangaꞌa leo, dhoka roti cue di. ");
INSERT INTO nfa_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tadèngi ra ale roti, hèia Yesus peka dènge si, aku Nèngu na, “Miu mage-mage ku! Baku lèke pangaru karehe nèti dhèu aae Herodes dènge dhèu Parisi. Pangaru rèngu, sama sèmi ragi dhu dhèu pakihu tao roti.” ");
INSERT INTO nfa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ra tadèngi Na padhai lii sèmi èèna, ka ana madhutu sèra malaa. Ka ra papeka isi-aanga si, peka na, “Mone heka nèi, peka ngaa ne? Tao-tao èdhi tèti boe roti, ka Na lii sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te ngaa Yesus neꞌa lii padhai rèngu. Ka Na peka, aku Nèngu na, “Nga tao ka miu padhue dhoka roti di! Miu meꞌa mere boe ngaa dhu Jaꞌa peka na, do? Mema kahadhu miu kateme. ");
INSERT INTO nfa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Miu mèdhi dènge madha le, te ngaa moꞌo boe meꞌa! Èci èèna ka dènge miu mèdhi mèka. Miu tadèngi dènge roꞌa dhilu le, te ngaa moꞌo boe nanene. Èci èèna ka dènge miu tadèngi mèka. Miu bhèlu le, do? ");
INSERT INTO nfa_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Roti lèmi bua dhu Jaꞌa pamae kore ka hia dhèu lèmi riho sèra raꞌa, si? Ca hari ni, miu pakaboko mere roti dhu risi sèra pèri soe?” Ka ra dhaa, aku rèngu na, “Canguru dua soe, Ama.” ");
INSERT INTO nfa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ka na karèi hari, aku Nèngu na, “Miu sanèdꞌe era lodꞌo Jaꞌa pamae kore roti pèri bua sèra, ka hia dhèu èpa riho raꞌa sa, do aadꞌo? Miu pakaboko mere sisa pèri soe hahake?” Ka ra dhaa, na, “Pidhu, Ama.” ");
INSERT INTO nfa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hèia Na peka, na, “Mema tareꞌa! Miu mèdhi dènge madha le. Te ngaa, nga tao ka miu meꞌa mèka koasa Jaꞌa kapua nèti mia?” ");
INSERT INTO nfa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ropa Yesus si dꞌai rae Betsaida, dhèu rèti dhèu bèdhu èci mai asa Yesus. Ra manèngi sèna ka Yesus paꞌèle musi madha dhèu bèdhu ne. ");
INSERT INTO nfa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ka Yesus kadhèi nare kacui-aai dhèu ne, ka dua ra lasi asa liꞌu rae. Èle èèna ka, Yesus sabhuu ilu mi musi madha dhèu ne, hèia Na gꞌagꞌe. Ka Na karèi, peka na, “Samia? Èu mèdhi le, do dhae?” ");
INSERT INTO nfa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ka dhèu èèna padoa kètu, ka na ladhe sa gꞌana-kariu, hèia na dhaa, peka na, “Oo! Jaꞌa kèdhi dhèu kako rango-rango era, nuka sèmi ana aajꞌu dhu kako.” ");
INSERT INTO nfa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hèia Yesus caro hari kacui-aai Na ca tèka mi musi madha dhèu neꞌe. Ka na ladhe patae hari, ho neo neꞌa, na, musi madha na beꞌa le, do dhae. Neꞌe ne, heka nèdhi dènge mèu kèna. ");
INSERT INTO nfa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ka Yesus pua na lèpa, te ngaa pasanèdꞌe ne, aku Nèngu na, “Èu lamu ka, te ngaa madhutu jꞌara leo. Re ia ka Betsaida.” ");
INSERT INTO nfa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Èle èèna ka, Yesus si kako palème rae-rae ètu Kaisarea Pilipi. Ètu talora jꞌara, Yesus karèi ana madhutu Na, peka na, “Madhutu lii lolo dhèu, na, Jaꞌa ne, cee?” ");
INSERT INTO nfa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ka ra dhaa, peka na, “Dhèu cahagꞌe peka, na, Èu ne, Yohanis tuka sarani dhu madhe le, te ngaa mamuri hari. Abhu cahagꞌe peka na, Èu ne, Elia, ca dhèu nèti lii padhai Ama Lamatua uru sèra. Aa abhu cahagꞌe hari peka na, Ama ne, dhèu nèti lii padhai Ama Lamatua dhu leo.” ");
INSERT INTO nfa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ka Yesus karèi hari rèngu, “Madhutu aꞌabhu miu, Jaꞌa ne, cee?” Petrus dhaa, peka na, “Ama ne, Kristus, dhu Ama Lamatua pajꞌujꞌu nèti uru ka.” ");
INSERT INTO nfa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Hèia Yesus pasanèdꞌe si, aku Nèngu na, “Baku lolo mi cee-cee kahèi, ee!” ");
INSERT INTO nfa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Èle èèna ka, Yesus mulai peka dènge ana madhutu Na sèra, aku Nèngu na, “Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Bèli-camèdꞌa Jaꞌa abhu jꞌajꞌèra ae titu kèna, lula dhèu heka-dhèu heka Yahudi, kètu agama Yahudi, dènge mese agama sèra, aaꞌi-aaꞌi ra sèmi rare boe Jaꞌa. Ho èèna na, ra pamadhe Jaꞌa, te ngaa dꞌai camèdꞌa, na, Jaꞌa mamuri hari.” ");
INSERT INTO nfa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus peka boe dènge pahuni, hèia Petrus ère Ne asa karasa na, ka na kai, aku nèngu na, “Ama, baku padhai lii sèmi èèna! Jaꞌa koꞌo boe dhèu tao Ama ku sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lii padhai lii Petrus èèna, madhutu boe dadꞌèi Ama Lamatua. Hèia Yesus kabibꞌa, ka ladhe asa ana madhutu dhu leo sèra. Ka Na nasa dènge Petrus, aku Nèngu na, “Weh! Èèna lii dhèu aae nidhu! Èu pakajꞌèu nèti neꞌe! Èu madhutu dhoka dadꞌèi dhèu rai-haha di. Madhutu boe dadꞌèi Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Èle èèna ka, Yesus paroa dhèu ae sèra ho mai pakaboko dènge ana madhutu Na. Ka Na ajꞌa si, peka na, “Dhèu dhu neo madhutu Jaꞌa, hudꞌi taha taruu bèli-bèli. Nèngu hudꞌi tèke eele dadꞌèi na, ho madhutu dadꞌèi Lamatua di. Masi ka dhèu neo pamadhe ne, te ngaa nèngu hudꞌi taha taruu kahèi, nuka sèmi dhèu pasae ajꞌu palolo-palèbha nèngu unu na ho laꞌe asa era ra pamadhe ne. ");
INSERT INTO nfa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Te dhèu dhu mamuri dhoka lalau ngiꞌu aae na di, bèli-camèdꞌa mamuri nèngu ele iie dꞌara! Te ngaa dhèu dhu sadia madhe lula madhutu Jaꞌa, aa lula na peka-padhai jꞌara mamuri Ama Lamatua, bèli-camèdꞌa nèngu abhu mamuri dhu maꞌète boe dènge Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mi nanene, ee! Ladhe èu abhu aaꞌi isi rai-haha ne, te ngaa Ama Lamatua core eele èu, aꞌoto na ngaa? ");
INSERT INTO nfa_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Masi ka èu bau mèti aaꞌi kakaja rai-haha ne, te ngaa bisa boe pasilu dènge samanga èu. ");
INSERT INTO nfa_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sanèdꞌe paie! Dhèu ètu rai-haha limuri ne, bhelu-katubꞌa rupa-rupa. Rèngu pusi-pahae boe madhutu Ama Lamatua. De cee dhu makae madhutu Jaꞌa, do makae madhutu lii holo-nori Jaꞌa, bèli-camèdꞌa Jaꞌa makae kahèi mangaku nèngu ètu madha Ama Lamatua. Te Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, bèli-camèdꞌa mai hari nèti sorga, palere dènge ana pajuu Ama Lamatua sèra. Jiꞌi puru mai dènge dadedha Ama ku, heka dhèu reꞌa mèu kèna, Jaꞌa ne cee. ");
INSERT INTO nfa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Miu baku bhèlu lii padhai lii Jaꞌa ne. Abhu nèti miu cahagꞌe dhu madhe mèka, pe mèdhi Ama Lamatua nèdꞌu paredha dènge koasa kapai.” ");
INSERT INTO nfa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Èle èna lodꞌo, hèia Yesus gale nèti Petrus, Yakobis, Yohanis, lasi asa ledhe èci dhu dhèu pea boe. Ropa dꞌai ledhe èèna, rèngu ladhe, na, Yesus leko-leo. ");
INSERT INTO nfa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aa mèdha-papake Na pudhi kaleꞌe. Abhu mèka mèdha dhu pudhi sèmi èèna ètu rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Cagꞌagꞌa laa, rèngu rèdhi Yesus padhai lii dènge Elia dènge Musa. ");
INSERT INTO nfa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ka Petrus si madhaꞌu bia. Hèia Petrus malaa, ka na padhai lii ore leli. Hèia na peka dènge Yesus, aku nèngu na, “Ama! Èdhi ètu era neꞌe, beꞌa titu kèna! Hua iia risi, jiꞌi tao paleo tèlu bua, cue hia Ama, cue hia Musa, aa cue hari hia Elia.” ");
INSERT INTO nfa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nèbhu boe ka, raꞌi-liru puru mai sarimu nare si. Hèia ra tadèngi lii èci nèti raꞌi-liru èèna, peka na, “Mi nanene! Yesus ne, Ana pasue Jaꞌa. Miu nanene paie Ne!” ");
INSERT INTO nfa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ropa tadèngi lii èèna, Petrus si laladhe palème, te ngaa rèdhi heka dhèu leo ètu èèna. Ate dhoka Yesus mesa Na. ");
INSERT INTO nfa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Èle èèna ka, Yesus dènge ana madhutu Na sèra puru nèti ledhe èèna. Ka Yesus kai si, peka na, “Ngaa dhu miu mèdhi deo na, baku lolo dènge dhèu èci sa. Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, hudꞌi madhe uuru ku. Ho lodꞌo dꞌai Jaꞌa mamuri hari, na, miu heka lolo dènge dhèu leo kèna.” ");
INSERT INTO nfa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rèngu tèke paꞌèra lii moa èèna ètu dꞌara ra. Ra ale boe dènge dhèu èci sa. Te ngaa tèlu ra pakarèi isi-aanga, “Na padhai lii ngaa ne, peka na, ‘Nèngu mamuri hari nèti mamadhe’? Tasamia, ee?” ");
INSERT INTO nfa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hèia ra karèi Ne, peka na, “Mese agama sèra peka na, ‘Elia hudꞌi mai uru ku, heka Kristus mai kèna.’ Te ngaa madhutu Ama, tareꞌa, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Hèia Yesus dhaa, peka na, “Mema tareꞌa. Elia hudꞌi mai uuru ku, ho bhoke jꞌara hia Kristus, dhèu dhu Ama Lamatua pajꞌujꞌu karèi nèti uru ka. Te ngaa tasamia? Miu meꞌa mèka ngaa dhu suri rare le ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, lula-nèti Dhèu Rai-haha Tareꞌa-reꞌa? Dhu suri rare le, peka na, ladhe lodꞌo Na mai, dhèu pajꞌèra Ne, toke ra pamadhe Ne. ");
INSERT INTO nfa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nèti èèna ka, miu pasa paie dhilu miu! Elia mai le. Te ngaa dhèu pajꞌèra ne madhutu dadꞌèi rèngu. Èèna lèke dènge ngaa dhu baki-baki èdhi sèra suri tèke le karèi nèti uuru ka.” ");
INSERT INTO nfa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ropa Yesus dènge ana madhutu Na, dhèu tèlu sèra, paraga hari dènge ana madhutu leo sèra, ka ladhe rèdhi dhèu ae pakaboko ètu èèna. Dhèu ae sèra mai ho ra neo nanene ana madhutu Yesus dhu leo sèra pabꞌala lii dènge mese agama ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ropa dhèu ae sèra ladhe rèdhi Yesus, ka ra cagꞌagꞌa, te rèngu neo laa, na, Yesus ètu ledhe era. Hèia ra rai mai soru Ne. ");
INSERT INTO nfa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Hèia Yesus karèi si, peka na, “Miu pabꞌala lii ngaa na?” ");
INSERT INTO nfa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dhèu èci nèti talora dhèu ae sèra ara sa madha, ka na dhaa, aku nèngu na, “Ama, mu nanene ku laa! Jaꞌa mai kèti ana mone jaꞌa dhu pèdꞌa, ho Ama ku puri-paꞌèle ne. Nèngu lii aadꞌo, bisa boe padhai lii, lula nidhu tao ne. ");
INSERT INTO nfa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ladhe nidhu maso asa dꞌara ngiꞌu na, na hake ngiꞌu ana ne mi rai. Ho hèbꞌa na horo karaka, na naꞌe ngutu na kico-kico sèna. Ho ngiꞌu na patèku sèmi ajꞌu. Jaꞌa manèngi le ana madhutu Ama ku babège eele nidhu èèna. Te ngaa ra bisa boe.” ");
INSERT INTO nfa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ropa Na nanene nare, hèia Yesus jèke si, peka na, “Heh! Miu seli-kolane! Jaꞌa ajꞌa miu pahari-pahari, te ngaa miu meꞌa boe ngaa-ngaa. Miu parcaya èra boe mi Jaꞌa! Jaꞌa mate miu nèbhu sange mia hari ku? Mèti ana èèna asa neꞌe mai!” ");
INSERT INTO nfa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hèia ra saꞌu rèti ana èèna asa madha Yesus. Te ngaa ropa nidhu ladhe nèdhi Yesus, na kalabhe ana ne mi rai, ka ana ne bèbhe kapodꞌe ètu rai, aa hèbꞌa na horo karaka. ");
INSERT INTO nfa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ka Yesus karèi ama na, “Nèngu sèmi neꞌe ne, pèri lodꞌo kèna?” Ka ama na dhaa, “Karèi nèti ana iiki ka mai. ");
INSERT INTO nfa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nidhu èèna nèbhu ae le neo pamadhe ana neꞌe. Na tule ne pèri-pèri hari kèna asa dꞌara ai, aa na pacène le kahèi asa dꞌara èi. De Ama ku sue jaꞌa. Ladhe bisa, na, Ama puri-paꞌèle ku ana jaꞌa la.” ");
INSERT INTO nfa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus dhaa, peka na, “Nga tao ka èu peka na ‘ladhe bisa’? Jaꞌa bisa tao aaꞌi mèu-mèu, te ngaa hudꞌi èu parcaya uuru ku!” ");
INSERT INTO nfa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nèti èèna ka, mone èèna dhaa dènge oe tangi, aku nèngu na, “Ama, mema jaꞌa parcaya, te ngaa paꞌèra hari ku lalèka jaꞌa neꞌe!” ");
INSERT INTO nfa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ropa Yesus nèdhi dhèu ae mai lingu, ka Na paredha nidhu èèna, aku nèngu na, “Heh! Nidhu bhelu! Kalua pakajꞌèu ka nèti ana neꞌe! Sèna ka na bisa tadèngi aa na padhai lii kahèi. Èu baku maso ia ka asa dꞌara ana neꞌe!” ");
INSERT INTO nfa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ropa nidhu tadèngi lii Yesus, hèia na pakèce. Ka na hake ana ne mi rai, ka na rèbha-rèbha sène, heka nidhu kalua nèti dꞌara ana èèna kèna. Ana èèna kalau heka, nuka sèmi dhu madhe le. Ka dhèu ètu sèra sa peka, aku rèngu na, “Waa! Ana ne madhe le!” ");
INSERT INTO nfa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Te ngaa Yesus kèpe kacui-aai ana ne, ka Na pakèdꞌi ne. Hèia na kèdꞌi dènge ka. ");
INSERT INTO nfa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Èle èèna ka, Yesus dènge ana madhutu Na, tèke eele era èèna, lasi dhuli èmu cue. Ètu èmu èèna, rèngu mesa ra, ka ra karèi Yesus, peka na, “Ama! Nga tao ka jiꞌi bisa boe babège eele nidhu èèna?” ");
INSERT INTO nfa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Hèia Yesus peka dènge si, aku Nèngu na, “Mi nanene paie! Nidhu sèra mema bhelu. De ladhe miu manèngi boe aꞌèra nèti Lamatua, na, miu bisa boe babège eele nidhu sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Èle ka, Yesus dènge ana madhutu Na tèke eele era èèna, lasi taruu asa propensi Galilea. Lodꞌo èèna, Yesus dꞌèi boe dhèu reꞌa Nèngu ètu èèna, ");
INSERT INTO nfa_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","lula Na neo ajꞌa ana madhutu Na di. Ka Na lole dènge si, “Nèbhu heka dhèu pahie eele Jaꞌa dènge dhèu leo. Hèia ra pamadhe Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne. Mema Jaꞌa madhe, te ngaa dꞌai camèdꞌa, Jaꞌa mamuri hari.” ");
INSERT INTO nfa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus padhai lii sèmi èèna, te ngaa ana madhutu Na sèra malaa. Rèngu bani heka karèi sasoa lii padhai lii Nèngu. ");
INSERT INTO nfa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Èle èèna ka, Yesus si lasi dꞌai Kapernaum. Ropa ra maso asa dꞌara èmu èci, Yesus karèi si, peka na, “Deo na miu pasisu ngaa ètu talora jꞌara?” ");
INSERT INTO nfa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Èci sa bani boe dhaa, lula ètu talora jꞌara deo na, rèngu ako pasala dꞌara, nèti ra pasisu, cee ka dhu kapai risi ètu talora rèngu. ");
INSERT INTO nfa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hèia Yesus madhèdi, ka Na holo si, peka na, “Cee dhu neo jꞌajꞌi dhèu kapai, mamuri nèngu hudꞌi sama sèmi dhèu haha dhu lalau-laloꞌo dhèu.” ");
INSERT INTO nfa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Èle èèna ka, Yesus saꞌu nare ana iiki èci, ka laꞌe asa talora rèngu aaꞌi-aaꞌi ra. Hèia Na peka, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Dhèu dhu madhutu Jaꞌa, ho na lalau-laloꞌo dhèu sèmi ana iiki ne, èèna sama sèmi nèngu lalau-laloꞌo Jaꞌa kahèi. Aa nèngu lalau-laloꞌo Ama ku kahèi, dhu pua Jaꞌa mai asa rai-haha ne.” ");
INSERT INTO nfa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Èle èèna ka, ana madhutu Yesus dhu ngara na Yohanis, peka na, “Ama! Ca tèka jiꞌi ngèdhi ca dhèu pake kolongara Ama ku, ho na babège eele nidhu. Te ngaa jiꞌi kai ne, lula nèngu dhèu èdhi boe.” ");
INSERT INTO nfa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Te ngaa Yesus dhaa, aku Nèngu na, “Baku mi kai ne! Te dhèu dhu pake kolongara Jaꞌa, ho na tao tadha malaa, nèngu paꞌele iie boe kolongara Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ladhe nèngu palabꞌa boe dènge èdhi, nèngu na dhèu èdhi. ");
INSERT INTO nfa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","De mi sanèdꞌe paie! Ladhe abhu dhèu neꞌa, na, miu madhutu Kristus, ka na soru-bara miu, tatu Ama Lamatua bhèlu boe rui-jꞌajꞌèra nèngu. Masi ka dhèu dhu hia miu èi iia ca galaa èèna ka, Ama Lamatua bhèlu boe tatao nèngu èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Èle èèna ka, Yesus padhai lii hari dènge ra, peka na, “Mage-mage, ladhe abhu dhèu dhu tao ana iiki èci kako sala jꞌara, toke ana ne parcaya heka Jaꞌa! Beꞌa risi hia dhèu èèna, rare hadhu aae cue, ho èki mi ladha goro ne, ho pacène ne asa talora dhasi. ");
INSERT INTO nfa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ladhe èu tao sala pake kacui-aai èu, na, poro eele ne. Te beꞌa risi èu maso sorga dènge kacui-aai cabèka di. Baku dꞌai ra core èu asa dꞌara ai heo robhe-robhe dènge kacui-aai kateme. ");
INSERT INTO nfa_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naraka èèna, mema era jꞌajꞌèra. Ai na madhe boe. Sèmi èèna kahèi, èru-èru kamoke dènge raꞌa taruu ngaa-ngaa dhu hèu ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ladhe èu tao sala pake haga èu, na, poro eele ne. Te beꞌa risi èu maso sorga dènge haga cabèka di. Baku dꞌai ra core èu asa dꞌara ai heo robhe-robhe dènge haga kateme. ");
INSERT INTO nfa_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naraka èèna, mema era jꞌajꞌèra. Ai na madhe boe. Sèmi èèna kahèi, èru-èru kamoke dènge raꞌa taruu ngaa-ngaa dhu hèu ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ladhe èu tao sala pake musi madha èu, na, edꞌo eele ne. Te beꞌa risi èu maso sorga dènge musi madha cabèka di. Baku dꞌai ra core èu asa dꞌara ai heo robhe-robhe dènge musi madha kateme. ");
INSERT INTO nfa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Naraka èèna, mema era jꞌajꞌèra. Ai na, madhe boe. Sèmi èèna kahèi, èru-èru kamoke dènge raꞌa taruu ngaa-ngaa dhu hèu ètu èèna.’ ");
INSERT INTO nfa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Aꞌajꞌa Jaꞌa ne, mema bia. De ladhe cee dhu madhutu Jaꞌa, nèngu hudꞌi taha taruu, sèmi dhèu dhu neo paga sisi hudꞌi masi uuru ku, sèna ka sisi paga èèna taha nèbhu. ");
INSERT INTO nfa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masi mema beꞌa. Èdhi pake ho pasèro ngangaꞌa. Te ngaa ladhe masi sèro heka, guna na ngaa? Dhoka bhori eele di. Miu hudꞌi jꞌajꞌi sèmi masi kahèi, sèna ka mamuri pasue dènge dhèu leo aaꞌi-aaꞌi. De mi pasisu ia ka, peka na, cee ka dhu kapai, aa cee ka dhu ana iiki.” ");
INSERT INTO nfa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Èle èèna ka, Yesus si lasi asa propensi Yudea dènge era-era ètu cabèka dhimu loko Yarden. Ètu mia-mia, dhèu ae mai lingu rare Yesus. Hèia Na ajꞌa si, sèmi biasa. ");
INSERT INTO nfa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dhèu Parisi pèri-pèri mai neo pamanahu Ne. Ra karèi Ne sèmi neꞌe ka, “Madhutu aꞌabhu agama èdhi, ladhe mone dhu dènge le dꞌara èmu, bisa paꞌia hari, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus dhaa, peka na, “Miu sanèdꞌe, do? Atora dhèu èmu-kamali dhu Musa hia èdhi uru èèna, tasamia?” ");
INSERT INTO nfa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ra dhaa, peka na, “Nanori Musa peka, dhèu bisa paꞌia-paꞌela, sadꞌi dhèu mone tao uru ku sasuri paꞌia dènge dhèu èmu na.” ");
INSERT INTO nfa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hèia Yesus bꞌala si, peka na, “Nanene, ee! Musa suri sèmi èèna, lula miu kètu hadhu. ");
INSERT INTO nfa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Baku bhèlu lii lolo dhu uru tèka, lodꞌo Lamatua pajꞌajꞌi dedha-liru dènge rai-haha! Dhu suri tèke, peka na, ‘Ama Lamatua pajꞌajꞌi dhèu rai-haha, mone dènge bhèni. ");
INSERT INTO nfa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nèti èèna ka, dhèu mone tèke eele ina-ama na, ho mamuri dꞌara èci dènge dhèu èmu na, ");
INSERT INTO nfa_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","sèna ka dua ra jꞌajꞌi mi èci.’ ");
INSERT INTO nfa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ladhe Lamatua paꞌèci le rèngu dua ra, dhèu rai-haha baku pacèri eele si!” ");
INSERT INTO nfa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Èle èèna ka, Yesus dènge ana madhutu Na lasi mesa ra asa dꞌara èmu cue. Ètu èèna, rèngu karèi Ne lii ajꞌa deo sa. ");
INSERT INTO nfa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus dhaa, peka na, “Dhèu mone cee dhu ia eele dhèu èmu na, ho na madhèdi hari dènge dhèu bhèni leo, nèngu bersina. ");
INSERT INTO nfa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Èci èèna ka, dènge dhèu bhèni. Ladhe nèngu ia eele dhèu èmu na, ho na leo hari dènge mone leo, nèngu bersina kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ca tèka, dhèu rèti ana-ana rèngu asa Yesus. Ra manèngi sèna ka Yesus sabajꞌa hia si, ho hia lii mèngi-nale. Te ngaa ana madhutu Yesus kai dhèu sèra. ");
INSERT INTO nfa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus ladhe nèdhi sèmi èèna, ka Na nasa dènge ana madhutu Na sèra, aku Nèngu na, “Hudꞌi laa ana iiki sèra mai asa Jaꞌa. Baku magee si. Te dhèu sèmi sèra ka dhu jꞌajꞌi dhèu unu Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Miu sanèdꞌe paie! Dhèu cee dhu neo mai asa katanga-madha Lamatua, dꞌara na kateme hudꞌi dꞌèi paraga dènge Ne, èci èèna ka ana iiki dhu dꞌara dꞌèi paraga dènge ina-ama ra. Ladhe sèmi boe èèna, rèngu bisa boe jꞌajꞌi dhèu unu Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Èle èèna ka, Yesus liku nare ana iiki se, ka Na tao kacui-aai Na mi dedha kètu ana iiki se èci-èci, ho Na hia si lii mamèngi. ");
INSERT INTO nfa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ropa Yesus si neo pakèdꞌi, dhèu kaja èci rai mai neo paraga dènge Ne. Hèia na pacudꞌu ètu madha Yesus, ka na karèi Ne, aku nèngu na, “Ama mese dhu hua iia! Jaꞌa neo karèi ciki. Jaꞌa tao tasamia, sèna ka jaꞌa keꞌa tareꞌa-reꞌa, na, jaꞌa ne maso sorga ho mamuri taruu paꞌèci dènge Ama Lamatua?” ");
INSERT INTO nfa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Hèia Yesus dhaa, peka na, “Nga tao ka èu ne peka na, Jaꞌa ne ‘hua iia’? Dhèu rai-haha ne èci sa dhu hua iia boe. Dhoka Ama Lamatua di dhu hua iia. ");
INSERT INTO nfa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Èu meꞌa le, lii paredha Ama Lamatua sèra nèti uru ka, dhu peka na: ‘Baku pamadhe dhèu; Baku tao jꞌara makae dènge dhèu dhu dhèu èmu-kamali boe èu; Baku manaꞌu; Baku jꞌajꞌi sakasii kapodꞌe-kabèli; Baku monya ho parame more mèdha-panyau dhèu; Aa pakabꞌua ina-ama èu.’ ” ");
INSERT INTO nfa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dhèu èèna dhaa, peka na, “Tareꞌa, Ama Mese! Nèti ana ngèru ka mai, jaꞌa madhutu le lii paredha sèra aaꞌi-aaꞌi si.” ");
INSERT INTO nfa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus rasa kasia dènge dhèu neꞌe, hèia Na peka, “Tareꞌa! Te ngaa jꞌara èci era. Lèpa ka asa èmu èu, lamu pahia aaꞌi suꞌi-kakaja èu. Kabꞌua na lamu pala-bagi mi dhèu dhu unu boe ngaa-ngaa. Èle èèna, heka mai kèna, ho madhutu Jaꞌa. Pe bèli-camèdꞌa Lamatua pala-bagi hia èu hari kakaja-sasuꞌi dhu leo ètu sorga.” ");
INSERT INTO nfa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ropa dhèu ne tadèngi nare lii padhai lii Yesus èèna, dꞌara na laho mae-mae. Laꞌe ka èmu dènge dꞌara dhu pèdꞌa bia, lula nèngu dhèu kaja tareꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hèia Yesus ladhe laꞌe-mai, aa peka dènge ana madhutu Na sèra, aku Nèngu na, “Mi nanene! Dhèu kaja carui titu kèna maso sorga!” ");
INSERT INTO nfa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ropa tadèngi rare lii padhai lii Yesus èèna, ana madhutu Na bingu. Ka Yesus tuhu hari lii padhai Na, “Mi nanene paie! Mema carui ladhe dhèu neo jꞌajꞌi dhèu unu Ama Lamatua. Baku ngee èèna mudꞌa! ");
INSERT INTO nfa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dhèu kaja maso sorga ho jꞌajꞌi dhèu unu Ama Lamatua, sama carui dènge badha onta ciꞌu dhu kapai maso asa oka na re roꞌa jꞌajꞌau.” ");
INSERT INTO nfa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lii padhai lii Yesus ne asa pamalaa dhèu seꞌe aaꞌi-aaꞌi si. Ka ra pakarèi, peka na, “Ladhe tareꞌa sèmi èèna, cee ka dhu bisa abhu mamuri dènge Ama Lamatua?” ");
INSERT INTO nfa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ka Yesus ladhe si èci-èci, hèia Na peka, aku Nèngu na, “Madhutu dhèu rai-haha, na, carui. Te ngaa baku bhèlu, madhutu Ama Lamatua, aaꞌi-aaꞌi bisa jꞌajꞌi.” ");
INSERT INTO nfa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Èle èèna ka, Petrus padhai lii, peka na, “Ama, jiꞌi tèke eele le ngaa-ngaa dhu jꞌajꞌi unu jiꞌi, ho madhutu Èu. De jiꞌi abhu babꞌala na ngaa?” ");
INSERT INTO nfa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ka Yesus dhaa, peka na, “Jaꞌa neo peka dènge miu sèmi neꞌe: dhèu dhu madhutu Jaꞌa, aa tèke eele ina-ama na, aꞌari na, ana-èpu na, oka-tedhe na, sasabꞌa-laꞌa na, dènge isi èmu aaꞌi-aaꞌi, ho laꞌe peka-padhai Lii Lolo Beꞌa Ama Lamatua mi dhèu ètu mia-mia, lèpa loo limuri, nèngu abhu hari ngaa-ngaa sèra, dꞌai cangasu hari. Aaꞌi-aaꞌi dhu nèngu tèke eele sèra, èèna na nèngu abhu risi hari. Aa nèngu abhu jꞌajꞌèra kahèi, lula madhutu Jaꞌa. Te ngaa ladhe dꞌai lodꞌo èle rai-haha ne, nèngu mamuri taruu paꞌèci dènge Ama Lamatua. Babꞌala nèngu, sèmi èèna ka. ");
INSERT INTO nfa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sanèdꞌe paie! Dhèu dhu padedha iisi, madhutu ngangee Ama Lamatua, limuri mai nèngu jꞌajꞌi dhèu haha dꞌai seli. Te ngaa dhèu dhu ngee, na, nèngu dhèu haha di, madhutu ngangee Ama Lamatua, limuri mai nèngu jꞌajꞌi dhèu kapai.” ");
INSERT INTO nfa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Lodꞌo èèna, Yesus dènge ana madhutu Na lasi asa kota Yerusalem. Yesus kako uuru. Ana madhutu Na dhèu canguru dua dènge dhèu leo dhu kako paꞌèci madhutu Ne re limuri. Rèngu sanèdꞌe lii padhai dhu Yesus peka dènge rèngu uru èèna, peka na, dhèu neo pamadhe Ne ètu Yerusalem. Nèti èèna ka, rèngu bingu dènge madhaꞌu. Hèia Yesus paroa nare ana madhutu Na sèra mesa ra, ho Na peka hari dènge rèngu dhèu neo tao ngaa mi dedha Nèngu ètu Yerusalem. ");
INSERT INTO nfa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesus peka dènge si, “Mi nanene! Èdhi neo lati asa Yerusalem. Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Ètu nèi, dhèu neo pahie eele Jaꞌa asa kètu agama Yahudi dènge mese agama sèra. Èle èèna, ra uku-kedꞌi pamadhe Jaꞌa. Ra tule eele Jaꞌa asa dhèu leo dhu tadhe boe Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Èle èèna ka, ra padhai lii pamakae Jaꞌa. Ra paruꞌe ilu mi Jaꞌa. Aa ra dhedhe pamae iisi Jaꞌa. Èle èèna, heka ra pamadhe Jaꞌa kèna. Mema Jaꞌa madhe tareꞌa. Te ngaa dꞌai camèda, Jaꞌa mamuri hari.” ");
INSERT INTO nfa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Èle èèna ka, ana Sabadeus, nuka Yakobis dènge Yohanis, mai asa Yesus. Ka ra manèngi, peka na, “Ama mese! Jiꞌi neo padhai lii dènge Ama ciki.” ");
INSERT INTO nfa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ka Yesus karèi si, “Miu neo ngaa?” ");
INSERT INTO nfa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ra dhaa, peka na, “Sèmi neꞌe, Ama! Bèli-camèdꞌa, ladhe Ama mèdꞌu paredha, jiꞌi manèngi Ama pamadhèdi jiꞌi dua mi, èci re sebhe gꞌana, èci hari re kariu, sèna ka jiꞌi paredha hèi.” ");
INSERT INTO nfa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus dhaa, peka na, “Miu dua mi se meꞌa boe lii manèngi miu èèna. Èèna na, Jaꞌa abhu jꞌajꞌèra ae. De tasamia? Miu ngee, na, miu se bisa pasae jꞌajꞌèra dènge Jaꞌa toke madhe, do?” ");
INSERT INTO nfa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ka ra dhaa, peka na, “Jiꞌi bisa, Ama!” Ka Yesus bꞌala, peka na, “Mema, èèna na, miu pasae jꞌajꞌèra kahèi, sama sèmi Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Te ngaa cee dhu madhèdi re sebhe gꞌana, do sebhe kariu Jaꞌa, èèna hak Jaꞌa aadꞌo. Te dhu hak ka Ama Lamatua dhu pamaꞌète mema le, na, cee-cee ka dhu madhèdi ètu era sèra.” ");
INSERT INTO nfa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ropa ana madhutu dhu leo sèra tadèngi lii manèngi Yakobis dènge Yohanis sèmi èèna, ka ra nasa bia. ");
INSERT INTO nfa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hèia Yesus paroa aaꞌi-aaꞌi si, ka Na peka, aku Nèngu na, “Miu meꞌa le, sina ma? Dhèu-dhèu kapai dhu rèdꞌu paredha jꞌeli ana kabarai sèna ka rèngu bisa boe kalau-karèto. Dhèu kapai kabarai dhu tadhe boe Lamatua hia paredha risi eele, ka ana kabarai bisa heka doa kètu. ");
INSERT INTO nfa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Te ngaa miu baku tao sèmi èèna! Nèti talora miu, cee dhu neo jꞌajꞌi dhèu kapai, nèngu hudꞌi jꞌajꞌi ku ana pua-paleha ho lalau dhèu leo. ");
INSERT INTO nfa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cee dhu neo jꞌajꞌi dhèu kapai, nèngu hudꞌi tao ngiꞌu na sama sèmi ènu. ");
INSERT INTO nfa_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Jaꞌa mai hia boe dhèu lalau-laloꞌo Jaꞌa. Te ngaa Jaꞌa mai ho lalau-laloꞌo dhèu ae, dènge hia mamuri Jaꞌa ho sui kore dhèu ae nèti koasa sasala-sasigo rèngu.” ");
INSERT INTO nfa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus dènge ana madhutu Na, dènge dhèu ae titu kèna kako lasi kota Jeriko. Ropa rèngu neo kako taruu, dhèu bèdhu èci madhèdi ètu sebhe jꞌara, na kanata ai ho manèngi ngaa-ngaa nèti dhèu dhu kako re èèna. Ngara na Bartimeos, ana nèti Timeos. ");
INSERT INTO nfa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ropa na tadèngi dhèu dhu kako mai sèra, Yesus nèti rae Nasaret na kahèi, ka na rodhe, peka na, “Yesus! Ana-èpu Daud, ee! Jiꞌi mate Èu nèbhu ae le! Sue ku jaꞌa laa!” ");
INSERT INTO nfa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ropa ra nanene lii rodhe na, hèia dhèu sèra jèke ne, aku rèngu na, “Èu mau-mau ku laa!” Te ngaa na rodhe asa aae, peka na, “Yesus! Ana-èpu Daud, ee! Sue ku jaꞌa laa!” ");
INSERT INTO nfa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Hèia Yesus titu taha, ka Na peka, “Mèti ku na mai sa neꞌe!” Ka ra lasi peka dènge dhèu bèdhu èèna, peka na, “Èu mau-mau ka laa! Te Ama mese paroa èu nèi. De mai lati ka!” ");
INSERT INTO nfa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ropa nanene nare, ka Bartimeos pèci eele sigꞌi kalolo na, hèia na kèdꞌi titu laꞌe paraga dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ka Yesus karèi ne, peka na, “Èu parluu ngaa?” Dhèu bèdhu ne dhaa, aku nèngu na, “Ama, ee! Jaꞌa manèngi ho jaꞌa bisa kèdhi.” ");
INSERT INTO nfa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus peka hari dènge ne, “Lula èu parcaya, Jaꞌa bisa tao paie musi madha èu. Neꞌe ne kahèi musi madha èu èle dènge! De lamu ka!” Ka musi madha Bartimeos èle dènge. Èle ka laꞌe madhutu Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ropa ra dètu dènge kota Yerusalem, ka ra dhuli uuru dua rae, ngara na Betfage dènge Betania, ètu sebhe ledhe Saitun. Ètu èèna, Yesus si mate ciki ooꞌe di. Ka Na pua ana madhutu Na dhèu dua lasi uuru. ");
INSERT INTO nfa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Na pua si, peka na, “Miu dua mi lami uuru asa dꞌara rae nèi. Ropa miu maso lami, miu mèdhi ana badha keledꞌei ciꞌu, dhu ra èki ètu èèna, dhu dhèu dhae manyaꞌe mèka. Lami ho lècu eele dhari aꞌèki na, ho ère mèti mai asa neꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te ngaa ladhe dhèu karèi miu, ‘Nga tao ka miu ère mèti ana keledꞌei ne?’ Mi peka dènge si, ‘Lamatua jiꞌi neo pake ne. Ladhe pake nare, na, Na hia hari mai.’ ” ");
INSERT INTO nfa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Èle èèna ka, ana madhutu Na dhèu dua sèra lasi, ka rèdhi ana keledꞌei ciꞌu dhu èki tèke ètu madha èmu cue ètu sebhe jꞌara. Ra lècu eele dhari èki na, ka ra ère rèti mai. ");
INSERT INTO nfa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ka dhèu-dhèu dhu titu ètu èèna, peka na, “We! Nga tao ka miu pakako mèti keledꞌei dhèu?” ");
INSERT INTO nfa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ka ra dhaa, peka na, “Lamatua jiꞌi neo pake ne. Ho ladhe Na pake nare, na, jiꞌi ngèti hari mai.” Ka dhèu sèra soro tèke si lasi pakako rèti ana keledꞌei èèna. ");
INSERT INTO nfa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hèia ra rèti ana keledꞌei èèna asa Yesus. Ka ra hèle sigꞌi-kalolo rèngu mi dedha keledꞌei, ka Yesus manyaꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ropa oe maso dꞌara kota, ka dhèu ae rare sigꞌi-kalolo, ka ra hèle mi dedha jꞌara oka-hoo. Dhèu cahagꞌe lasi para rèu palam ètu sebhe jꞌara, ho ra tao mi talora jꞌara oka-hoo. Tatao sèmi èèna na, sama sèmi tadha èci dhu peka na, rèngu pakabꞌua Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dhèu cahagꞌe kako uru ètu madha Yesus; aa cahagꞌe kako limuri. Ka ra paꞌoo, peka na, “Hosana! Mai ti koa-kio kolongara Ama Lamatua! Lamatua hia berkat mi dhèu dhu mai pake kolongara Na, lula Ama Lamatua hia Ne mai! ");
INSERT INTO nfa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Mai ti koa-kio kolongara Ama Lamatua! Lula Lamatua neo pakèdꞌi hari paredha dhèu aae Daud! Hosana! Mai ti koa-kio kolongara Ama Lamatua! Lula Lamatua madhèdi nèdꞌu paredha ètu era dedha risi eele!” ");
INSERT INTO nfa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ropa ra dꞌai dꞌara kota, ka Yesus si maso asa madha Èmu Kapua Manèngi-Mangajꞌi. Ka Yesus ladhe palème era Èmu èèna. Te ngaa, lula lodꞌo nihia ae le, ka ra lèpa hari asa rae Betania. ");
INSERT INTO nfa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Asa bèli madꞌae aae èèna, ka rèngu kalua nèti Betania lasi asa Yerusalem. Dꞌai talora jꞌara ka Yesus manganga. ");
INSERT INTO nfa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ka Na ladhe nèdhi ana aajꞌu èci ètu sebhe jꞌara. Hua ajꞌu na, dhu dhèu raꞌa. Yesus laꞌe padètu ho neo neꞌa ajꞌu na, hua do aadꞌo. Na ladhe ajꞌu èèna hua boe cue sa. Te mema dꞌai mèka hèru hua. Rèu heka mare kèna. ");
INSERT INTO nfa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ka Yesus peka mi ajꞌu èèna, “Lula èu hia boe Jaꞌa hua, mulai ti deo neꞌe, èu bisa heka hia hua èu asa dhèu leo!” Ana madhutu Yesus sèra tadèngi Na padhai lii dènge nasa sèmi èèna. ");
INSERT INTO nfa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus si kako taruu asa Yerusalem, dꞌai nèi ka Yesus maso asa Èmu Kapua Manèngi-Mangajꞌi. Ètu madha Èmu èèna, dhèu tao pasa ho ra pahia koro jꞌaha dhu biasa dhèu pake tao korban ho ra sabajꞌa. Ropa Yesus nèdhi sèmi èèna, ka Na lalèta si asa liꞌu. Na tule eele mei dhu ra pake ho pasilu doi sèra, aa Na tule paguri eele bagu dhu ra pake pahia manu-bhui sa. ");
INSERT INTO nfa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ka Yesus kai si aaꞌi-aaꞌi ra, sèna ka ra rèti ia ka mèdha rèngu re dꞌara madha Èmu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ka Na ajꞌa si, peka na, “Miu meꞌa le lii dhu dhèu nèti lii padhai Ama Lamatua suri tèke le, peka na: ‘Jaꞌa tao èmu neꞌe, sèna ka suku aaꞌi-aaꞌi mai sabajꞌa ètu neꞌe.’ Te ngaa miu tao Èmu ne jꞌajꞌi era pakaboko dhèu parapo.” ");
INSERT INTO nfa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ropa kètu agama Yahudi dènge mese agama sèra reꞌa rare tatao Yesus sèmi èèna, ka ra nasa dènge Ne. Ka ra tenge jꞌara ho neo pamadhe Ne. Te ngaa ra madhaꞌu, lula dhèu ae dhu dꞌèi lii holo-nori Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dꞌara lodꞌo cèna sa, Yesus si kalua hari nèti kota Yerusalem lèpa lasi jꞌunu asa rae Betania. ");
INSERT INTO nfa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Bèli madꞌae èèna, Yesus si lasi hari asa Yerusalem. Dꞌai talora jꞌara, ka ra rèdhi ajꞌu dhu Yesus padhai lii medꞌa na. Ka ana madhutu Yesus sèra malaa, lula rèngu rèdhi ajꞌu èèna mango le dꞌai amo. Hèia Petrus sanèdꞌe lii padhai lii Yesus medꞌa na. Ka na peka na, “Ama! Ladhe ku! Ajꞌu dhu Ama dhoo medꞌa na, madhe le!” ");
INSERT INTO nfa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus dhaa, peka na, “Tareꞌa, we! Sadꞌi miu parcaya Ama Lamatua sèmi èèna, na, jꞌajꞌi kahèi. ");
INSERT INTO nfa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ladhe miu parcaya dènge dꞌara kateme, miu bisa pua ledhe hia na pidha asa dꞌara dhasi. Pe Lamatua pidha eele ledhe èèna, sadꞌi miu baku parcaya dènge dꞌara cabèka. Miu parcaya mi Ama Lamatua, hudꞌi dènge dꞌara kateme ku. ");
INSERT INTO nfa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Baku bhèlu! Sadꞌi miu parcaya dènge dꞌara kateme, ngaa dhu miu manèngi, tatu Ama Lamatua bisa hia miu. ");
INSERT INTO nfa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ladhe dhèu èci sabajꞌa, aa te ngaa na tèka dꞌara era dènge dhèu leo, nèngu hudꞌi laꞌe pabeꞌa uuru ku dènge dhèu èèna. Ladhe miu tao sèmi èèna, Ama miu ètu sorga heka saku eele sasala miu kèna. ");
INSERT INTO nfa_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ladhe abhu nèti miu dhu tèka dꞌara dènge dhèu, ho moꞌo boe hia abho, na, tatu Ama miu ètu sorga noꞌo boe pabhèlu eele sasala miu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Èle èèna ka, Yesus si lasi taruu. Ropa dꞌai Yerusalem, ka ra maso hari asa Èmu Kapua Manèngi-Mangajꞌi. Ropa maso asa madha Èmu èèna, kètu agama Yahudi, mese agama, dènge dhèu heka-dhèu heka Yahudi sèra mai, ");
INSERT INTO nfa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ka ra karèi Yesus, peka na, “Cee ka dhu pua èu mai tao maruru ètu neꞌe medꞌa na? Cee ka hia èu hak!” ");
INSERT INTO nfa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Te ngaa Yesus neꞌa, na, rèngu neo tenge jꞌara ho pamanahu Ne. Ka Na bꞌala si, peka na, “Jaꞌa neo karèi miu kahèi. Miu dhaa uuru ku Jaꞌa, heka Jaꞌa dhaa miu kèna. ");
INSERT INTO nfa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jaꞌa neo karèi miu sèmi neꞌe: miu aaꞌi-aaꞌi mi tadhe Yohanis, tuka sarani èèna, sina ma? Cee ka dhu pua nèngu laꞌe sarani dhèu? Lamatua do, dhèu rai-haha?” ");
INSERT INTO nfa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ra pajiko laꞌe-mai, ka ra padhue, peka na, “Eea! Nara èdhi le! Ladhe èdhi dhaa, peka na, ‘Ama Lamatua ka dhu pua Yohanis,’ na bꞌala hari, peka na, ‘Nga tao ka miu parcaya boe Yohanis!’ ");
INSERT INTO nfa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te ngaa èdhi bisa boe peka kahèi, na, ‘Dhèu rai-haha dhu pua ne.’ Te aadꞌo na, dhèu ae tao dènge èdhi. Lula dhèu ae parcaya, Yohanis èèna, dhèu nèti lii padhai Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ka ra dhaa, peka na, “Jiꞌi ngeꞌa boe!” Ka Yesus dhaa hari si, peka na, “Ladhe sèmi èèna, Jaꞌa koꞌo boe peka kahèi, cee ka dhu pua Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Èle ka, Yesus padhai lii hari dènge kètu agama Yahudi, mese agama, dènge dhèu heka-dhèu heka adꞌa Yahudi sèra. Ka Na lole pake lii upama èci, peka na, “Dhèu èci laꞌe tao oka ho neo sèla anggor ètu dedha rai na. Ka na tao tedhe reo nare oka èèna, aa tao bak cue ho kanate èi anggor asa dꞌara laꞌe kahèi. Hèia na patitu èmu madhenga oka cue dhu dedha. Èle èèna ka, na hia dhèu leo sebꞌa oka èèna, ho ra pabagi èi anggor. Hèia na pakèdꞌi asa rai leo laꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lodꞌo dꞌai hèru puu-gꞌètu hua anggor, ka lamatua oka pua ana paleha na èci laꞌe asa dhèu sabꞌa oka sèra, ho na manèngi pala na. ");
INSERT INTO nfa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ropa dꞌai nèi, ka dhèu sebꞌa sèra kèpe rare, ka game ne. Hèia ra pua ne lèpa dènge ai hua daꞌu-daꞌu. ");
INSERT INTO nfa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ka lamatua oka pua hari ana paleha leo èci. Te ngaa dhèu sebꞌa sèra dhedhe panuꞌa kètu na. Ka ra pamakae ne, dènge magèle eele ne. ");
INSERT INTO nfa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hèia lamatua oka èèna pua hari ana paleha leo èci laꞌe. Te ngaa dhèu sebꞌa sèra hake pamadhe ne. Ra tao samia èèna ka, lamatua oka pua taruu ana paleha na laꞌe. Te ngaa dhèu sebꞌa sèra game cahagꞌe, aa pamadhe cahagꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ate eele dhodhoka ana mone mesa dhu pasue nèti lamatua oka. Lula na abhu heka jꞌara dhu leo, ka lamatua oka na pua ana dꞌèlu na laꞌe. Na pajiko, peka na, ‘Sèmi jaꞌa pua ana dꞌèlu jaꞌa laꞌe, na, rèngu sèmi rare dènge beꞌa, aa ra nanene ne.’ ");
INSERT INTO nfa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hèia na pua ana na laꞌe. Ropa dhèu sebꞌa sèra rèdhi ana na mai, ka ra papeka isi-aanga ra, peka na, ‘We! Mi ladhe ku laa! Mone heka nèi pua ana dꞌèlu na mai! Ladhe ama na madhe, nèngu neꞌe ka dhu sèmi nare aaꞌi-aaꞌi mèdha pusaka ama na. De mai ti pamadhe ne, sèna ka èdhi tare pusaka na!’ ");
INSERT INTO nfa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ka aaꞌi-aaꞌi ra kèpe, ka ra pamadhe ne, hèia ra core eele ngiꞌu aae na asa liꞌu tedhe laꞌe. Lii pakasame ne, dꞌai sange neꞌe ka.” ");
INSERT INTO nfa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Èle èèna ka, Yesus karèi dhèu kapai sèra, peka na, “Madhutu ngangee miu, na, lamatua oka èèna tao dhèu sebꞌa sèra tasa mera mia? Madhutu ngangee Jaꞌa, tatu nèngu mai ho pamadhe aaꞌi dhèu sebꞌa sèra, sèna ka na hia dhèu leo hari sebꞌa oka anggor na. ");
INSERT INTO nfa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Èdhi aaꞌi-aaꞌi ti baca le ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, peka na, ‘Abhu hadhu cue dhu tuka hadhu sèra core eele le, Te ngaa limuri ne, jꞌajꞌi le hadhu padhèdi. ");
INSERT INTO nfa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ama Lamatua mesa Na dhu pili nare, ka Na pamadhèdi hadhu ne. Nèti èèna ka, èdhi ladhe, na, beꞌa titu kèna!’ ” ");
INSERT INTO nfa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dhèu kapai sèra reꞌa dènge, na, Yesus padhai lii paraga, pake lii pakasame èèna. Rèngu sèra sama sèmi dhèu sebꞌa oka anggor èèna. Hèia ra tenge jꞌara ho neo kèpe Yesus. Te ngaa ra madhaꞌu dènge dhèu ae dhu dꞌèi lii holo-nori Yesus. Ka ra kako eele Ne. ");
INSERT INTO nfa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Èle èèna ka, dhèu kapai Yahudi se pua pèri-pèri dhèu Parisi dènge dhèu nèti partei Herodes, lasi pakarèi dènge Yesus, ho ra neo sahèdhe Ne. ");
INSERT INTO nfa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ka ra karèi Ne, peka na, “Ama Mese! Jiꞌi ngeꞌa, na, dꞌara Ama ku mola, aa dꞌèi boe kapodꞌe-kabèli. Ama meꞌa dꞌara dhèu. Ama peka dadꞌèi Lamatua dènge mola-mola, lula Ama pili boe rèhu dhèu. De, jiꞌi neo karèi Ama ku ca jꞌara. Madhutu atora agama Yahudi, èdhi bisa bꞌae bea asa dhèu aae kapai dhu paredha Roma, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Te ngaa Yesus neꞌa le, na, rèngu neo sahèdhe Ne, sèna ka Na padhai lii labꞌa paredha Roma. Ka Yesus bꞌala si, peka na, “Nga tao ka miu neo sahèdhe Jaꞌa dènge lii karèi sèmi èèna! Cobꞌa padꞌelo ku mi Jaꞌa doi pudhi cue!” ");
INSERT INTO nfa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ka ra jꞌole doi pudhi cue hia Ne. Hèia Yesus nare, ka laladhe. Ka Na karèi si, peka na, “Rèhu dènge ngara cee ètu doi pudhi ne?” Ka ra dhaa, peka na, “Èèna dhèu aae kapai paredha Roma!” ");
INSERT INTO nfa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ka Yesus peka, “Naa, ladhe sèmi èèna, ngaa dhu unu dhèu paredha, hia asa dhèu paredha laꞌe. Te ngaa dhu unu Ama Lamatua, hia asa Ama Lamatua laꞌe.” Ropa tadèngi rare, lii bꞌala Na, ka ra malaa, lula Yesus peka dhu lèke. Nèti èèna ka, dhèu sèra bisa heka sahèdhe Ne. ");
INSERT INTO nfa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Abhu partei agama dhu leo èci, ngara na partei Saduki. Rèngu ajꞌa, peka na, dhèu madhe bisa heka mamuri. Ca tèka, abhu dhèu Saduki pèri-pèri mai neo sahèdhe Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ka ra padhai lii dènge Yesus, peka na, “Ama Mese! Musa suri tèke le hia èdhi atora, peka na: ladhe dhèu mone èci madhe tèke eele dhèu èmu na, te ngaa rèngu dènge boe kolo, na, ari dhèu mone na bisa leo nare hari bhèni balu èèna, sèna ka abhu kolo ho baku paꞌele kolongara aꞌa na dhu madhe èèna. ");
INSERT INTO nfa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mema Musa ajꞌa sèmi èèna. Te ngaa jiꞌi neo karèi Ama sèmi neꞌe: abhu dhèu pidhu dhu paꞌaꞌari. Mone uru leo uuru èmu, te ngaa madhe, abhu mèka kolo. ");
INSERT INTO nfa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ka ari na leo nare bhèni balu èèna. Nèbhu boe ka ari na madhe, te ngaa abhu boe kolo kahèi. Ari na ka tèlu, sèmi èèna kahèi; na leo nare bhèni balu èèna, te ngaa abhu mèka kolo, nèngu madhe. ");
INSERT INTO nfa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Taruu-taruu sèmi èèna ka, dꞌai ana limuri tèka madhe kahèi. Nèbhu boe, hèia bhèni balu èèna madhe. ");
INSERT INTO nfa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naa! Jiꞌi neo karèi Ama sèmi neꞌe: dhèu bhèni èèna, leo le dènge mone dhèu pidhu! Dꞌai lodꞌo èle rai-haha ne, ho Lamatua pamamuri hari dhèu madhe, bhèni ne jꞌajꞌi dhèu èmu cee, nèti dhèu pidhu sèra?” ");
INSERT INTO nfa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus dhaa, peka na, “Lii karèi miu sèra, tadha, na, miu meꞌa iia mèka isi Sasuri Mola-Mèci Ama Lamatua! Miu meꞌa boe koasa Lamatua kahèi. De miu sala titu kèna! ");
INSERT INTO nfa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mi nanene! Sèmi neꞌe: ètu sorga dhèu paleo boe èmu. Dhèu madhe aaꞌi-aaꞌi dhu Lamatua pamamuri hari, ra paleo heka èmu. Sèmi èèna kahèi, ana pajuu Ama Lamatua ètu sorga. ");
INSERT INTO nfa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aa Jaꞌa peka mi miu lula-nèti dhèu madhe mamuri hari, do aadꞌo. Musa suri tèke lula-nèti ana aajꞌu dhu ai naꞌe, te ngaa kèpu boe. Miu sanèdꞌe lii lolo èèna, do aadꞌo? Ropa ai naꞌe ana aajꞌu èèna, Ama Lamatua peka dènge Musa, na, ‘Jaꞌa ne, Ama Lamatua nèti bèi-baki èu, nuka Abraham, Isak, dènge Yakob. Toke dꞌai sange neꞌe, rèngu aaꞌi-aaꞌi manèngi-mangajꞌi mi Jaꞌa era.’ ");
INSERT INTO nfa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Èdhi teꞌa, na, bèi-baki èdhi sèra madhe nèbhu le. Te ngaa, lula Ama Lamatua peka nare le, na, Nèngu jꞌajꞌi Lamatua rèngu era. Nèti èèna ka, èdhi teꞌa, na, rèngu mamuri hari le. De masi ka dhèu madhe le, te ngaa ra mamuri hari. De dhèu mamuri dhu manèngi-mangajꞌi mi Ama Lamatua, te ngaa dhèu madhe aadꞌo, sina ma? Nèti èèna ka, ladhe miu kèpe taruu aꞌajꞌa dhu peka na, dhèu madhe mamuri heka, èèna miu sala ae!” ");
INSERT INTO nfa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ètu lodꞌo èèna, abhu mese agama èci dhu nanene Yesus padhai lii dènge dhèu nèti partei Saduki sèra. Madhutu aꞌabhu mese agama èèna, na, Yesus dhaa lèke le lii karèi rèngu. Hèia na karèi Yesus, peka na, “Ama! Jaꞌa neo karèi sèmi neꞌe: atora adꞌa dènge lii paredha agama èdhi ae titu kèna. Madhutu aꞌabhu Ama, nèti lii paredha dhu mai nèti Musa, mia ka dhu hua iia risi?” ");
INSERT INTO nfa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ka Yesus dhaa, peka na, “Lii paredha dhu hua iia risi, peka sèmi neꞌe ka: ‘Miu dhèu Israꞌel aaꞌi-aaꞌi mi! Mi nanene paie! Ama Lamatua èèna, mema Lamatua èdhi, aa Kètu èdhi kahèi. Nèngu dhoka mesa Na di, lamatua leo aadꞌo. ");
INSERT INTO nfa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","De miu hudꞌi sue risi eele Ne nèti aaꞌi-aaꞌi. Nèti èèna ka, miu hudꞌi dꞌèi paꞌèci dènge Ne dènge dꞌara kateme, aa tadhe mèu Ne, dènge sabꞌa èra ho madhutu dadꞌèi Na.’ ");
INSERT INTO nfa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aa lii paredha ka dua peka na: ‘Èu hudꞌi sue ku dhèu leo, sama sèmi èu sue ngiꞌu èu unu mu.’ Dua paredha seꞌe ka dhu hua iia risi. Abhu heka lii paredha leo dhu risi eele nèti dua paredha seꞌe.” ");
INSERT INTO nfa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ka mese agama èèna bꞌala hari, peka na, “Tareꞌa! Ama ku peka lèke kèna. Te Ama Lamatua jꞌajꞌi Kètu èdhi. Lamatua leo aadꞌo. ");
INSERT INTO nfa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Èdhi hudꞌi sue risi Ne, toke dꞌara dꞌèi ho paꞌèci dènge Ne, tadhe mèu Ne, dènge sabꞌa èra ho madhutu dadꞌèi Na. Èdhi hudꞌi sue dhèu leo kahèi sama sèmi èdhi sue ngiꞌu èdhi unu ti. Lamatua dꞌèi risi eele tatao sèmi èèna, nèti èdhi madhutu dhodhoka atora agama di. Tatao sèmi èèna beꞌa risi, nèti èdhi tèti badha ho lati tunu hia Lamatua, do tèti mèdha leo hia Ne.” ");
INSERT INTO nfa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ropa Yesus nanene nare dhèu ne dhaa sèmi èèna, ka Na pangee, na, mese agama ne neꞌa dènge beꞌa le. Hèia Yesus peka na, “Èu oe jꞌajꞌi unu Ama Lamatua kèna.” Èle èèna ka, dhèu leo sèra bani heka pakarèi dènge Yesus, lula dhèu èci sa segi boe Ne. ");
INSERT INTO nfa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Èle èèna ka, Yesus ajꞌa dhèu ae sèra ètu Èmu Kapua Manèngi-Mangajꞌi era. Ka Na karèi si, peka na, “Madhutu ngangee miu, na, tasamia? Mese agama sèra ajꞌa, peka na, Kristus èèna dhu Lamatua pajꞌujꞌu nèti uru ka mai. Madhutu ngangee rèngu, na, Kristus èèna dhoka ana-èpu Daud. Te ngaa aꞌajꞌa sèmi èèna dꞌai lèke mèu mèka. ");
INSERT INTO nfa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lula, nèti uru ka mai, Roh Ama Lamatua dhu Mola-Mèci pake Daud ho suri, peka na, ‘Ama Lamatua peka le mi lamatua jaꞌa, na, “Mai ho madhèdi mi era dhu hua iia, re babꞌoa gꞌana Jaꞌa. Pe èèna na Jaꞌa tao musu èu pahaha iisi, toke ra bisa boe dedꞌe kètu mi èu.’ ” ");
INSERT INTO nfa_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","De èdhi teꞌa, na, dhèu aae Daud paroa Kristus èèna, peka na, ‘Lamatua’ na. Nèti èèna ka, ladhe dhèu sèra peka, na, Kristus èèna dhoka ana-èpu Daud di, èèna dꞌai mèka. Lula Nèngu èèna jꞌajꞌi lamatua nèti Daud kahèi.” ");
INSERT INTO nfa_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Ropa Yesus peka nare sèmi èèna, dhèu ae sèra dꞌèi titu kèna nanene Ne. ");
INSERT INTO nfa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ka Yesus peka hari si, “Miu hudꞌi pajiko paie ku mese agama. Rèngu dꞌèi pasia pake kodho madhera dꞌai rai, lasi paraga dènge dhèu ae, sèna ka dhèu dhu rèdhi rèngu sèra, koa si, peka na, ‘Ladhe ku laa! Dhèu sèra, dhèu kapai!’ ");
INSERT INTO nfa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ladhe sèmi rèngu maso asa èmu manèngi-mangajꞌi, do lasi raꞌa-sisi, ra tenge era madhèdi dhu beꞌa risi, sèna ka dhèu ae rèdhi si. ");
INSERT INTO nfa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","De hua iia mi pajiko paie! Rèngu kapodꞌe-kabèli bhèni balu ho parame rare èmu bhèni balu sèra. Te ngaa ètu madha dhèu ae, rèngu pahuni bhabhelu ra sèra dènge jꞌara titu ho sabajꞌa pamadhera aae, sèna ka dhèu peka na, rèngu se dhèu mola. Te ngaa limuri mai, na, Ama Lamatua hia huku dhu bia risi asa rèngu.” ");
INSERT INTO nfa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Èle èèna ka, Yesus laꞌe madhèdi patangara dènge boaraka derma ètu Èmu Kapua Manèngi-Mangajꞌi. Na ladhe dhèu mai pamaso doi kolete asa dꞌara boaraka èèna. Ka Na ladhe dhèu kaja sèra parèu doi ae. ");
INSERT INTO nfa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te ngaa abhu bhèni balu èci dhu dènge boe ngaa-ngaa èci sa mai manèngi-mangajꞌi, ka na pamaso dua doi asa dꞌara boaraka èèna. Dua doi dhu na pamaso èèna, kabꞌua ciki oodꞌe di. ");
INSERT INTO nfa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Èle èèna ka, Yesus gape ana madhutu Na, ka Na peka, “Mi ladhe ku bhèni balu dhu dènge boe ngaa-ngaa nèi. Na pamaso dhoka dua doi di, te ngaa nèngu hia risi eele nèti dhèu leo sèra. ");
INSERT INTO nfa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dhèu leo sèra hia kolete nèti doi sisa rèngu. Te ngaa bhèni balu ne hia aaꞌi mèu-mèu doi nèngu asa Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Èle èèna ka, Yesus dènge ana madhutu Na sèra kalua nèti dꞌara Èmu Kapua Manèngi-Mangajꞌi. Ropa rèngu dꞌai liꞌu, hèia ana madhutu Na èci pajꞌujꞌu asa Èmu Kapua Manèngi-Mangajꞌi, ka na peka, “Ama! Ladhe ku Èmu neꞌe! Ra tao rare, saraga bia. Ra pagodꞌo rare hadhu sèra, mera titu kèna!” ");
INSERT INTO nfa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Hèia Yesus dhaa, peka na, “Èmu ne mema saraga titu kèna! Te nèbhu heka, dhèu paguri eele ne. Ka hadhu-hadhu sèra, èci sa pamadhèdi heka ètu dedha èci.” ");
INSERT INTO nfa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Èle èèna ka, Yesus si lasi asa ledhe Saitun, ka Na madhèdi ètu era dhu patangara dènge Èmu Kapua Manèngi-Mangajꞌi. Hèia Petrus, Yakobis, Yohanis dènge Anderias mai padhai lii dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ra karèi, aku rèngu na, “Ama! Lole hari ku, lii dhu Ama ku peka dènge jiꞌi deo na. Lodꞌo mia sèra sa jꞌajꞌi? Aa tadha-tadha na, samia?” ");
INSERT INTO nfa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hèia Yesus dhaa, aku Nèngu na, “Sadꞌi miu pajiko paie-iie, sèna ka baku lèke tipu. ");
INSERT INTO nfa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Te ladhe èèna na, dhèu ae mai tèbꞌa kakara, ho ra peka na, ‘Jaꞌa ne Kristus, Dhèu dhu Ama Lamatua moa nèti uru ka mai.’ Aa ra leko-monya dhèu ae. ");
INSERT INTO nfa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ladhe miu mèdhi dhèu pamusu, do tadèngi lii lolo dhèu papara-pakèjꞌi dènge pakasiro ètu mia-mia, miu baku madhaꞌu kahèi. Sèra sa hudꞌi jꞌajꞌi uuru ku. Te ngaa lodꞌo èle rai-haha èèna dhae dꞌai mèka. ");
INSERT INTO nfa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dhèu nèti ca suku mai pamusu dènge suku leo, rai èci mai pamusu dènge rai leo. Ètu mia-mia, jꞌajꞌi rai opo dènge kabake-manganga. Sèra sa jꞌajꞌi tadha sama sèmi dhèu bhèni èci dhu kabake pèdꞌa neo nara iisi. ");
INSERT INTO nfa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","De hua iia, na, miu mage-mage! Te èèna na dhèu mai kèpa miu, ho ra nuni asa dhèu paredha agama dhu pamaꞌète lii agama. Aa ra game miu ètu dꞌara èmu-èmu manèngi-mangajꞌi. Ho èèna na rèti miu asa madha dhèu dhu dènge koasa, lula miu madhutu Jaꞌa. Te ngaa beꞌa kahèi, neꞌe ne miu abhu tebho ho peka kolongara Jaꞌa mi rèngu. ");
INSERT INTO nfa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te dhèu unu Ama Lamatua hudꞌi lasi uuru ku lole Lii Lolo Beꞌa Jaꞌa mi suku aaꞌi-aaꞌi ètu rai-haha ne, heka lodꞌo èle rai-haha ne dꞌai kèna. ");
INSERT INTO nfa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sanèdꞌe, ee! Ladhe ra èki rèti miu asa era pamaꞌète lii langu, miu baku madhaꞌu, peka na, ‘Èèna na jaꞌa neo padhai lii ngaa? Do, jaꞌa neo dhaa ngaa?’ Ladhe dꞌai lodꞌo èèna, miu padhai lii madhutu ngaa dhu Roh Mola-Mèci Ama Lamatua peka dènge miu. ");
INSERT INTO nfa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ètu dꞌara èmu cue, ladhe abhu dhèu dhu parcaya Jaꞌa, èèna na aꞌari nèngu tenge jꞌara ho pamadhe ne. Sèmi èèna kahèi, ladhe abhu ana dhu parcaya Jaꞌa, èèna na ama dꞌèlu na tenge jꞌara ho pamadhe ne. Sèmi èèna kahèi, ladhe abhu ina-ama dhu parcaya Jaꞌa, èèna na ana dꞌèlu rèngu tenge jꞌara ho pamadhe si. ");
INSERT INTO nfa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","De èèna na, dhèu dꞌèi boe miu, taga miu madhutu Jaꞌa. Te ngaa dhèu cee dhu bisa taha toke dꞌai èle lodꞌo èèna, tatu Ama Lamatua hia mamuri mi nèngu.” ");
INSERT INTO nfa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus tuhu hari lii padhai Na, aku Nèngu na, “Èèna na, abhu dhèu èci dhu bhelu-katubꞌa risi eele mai. Ho na mai maso ka titu ètu era laluri ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi, dhu madhutu iia-iia na, nèngu bisa boe ètu era èèna, ho na pahera era èèna. Nèti èèna ka, Ama Lamatua tèke eele era èèna. Ladhe miu mèdhi le sèmi èèna, na, mi pajiko paie-iie! (Cee dhu baca lii neꞌe, pajiko paie kahèi!) Èèna jꞌajꞌi mi tadha, peka na, lodꞌo-lodꞌo jꞌajꞌèra, dètu ae le. Ladhe mèdhi sèmi èèna, na, dhèu-dhèu ètu propensi Yudea lega-rai asa kolo ledhe lasi. ");
INSERT INTO nfa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Rèngu hudꞌi rai pamèri-mèri, sèna ka baku abhu jꞌajꞌèra. Ladhe dhèu mai le asa liꞌu, lèpa ia ka rare mèdha asa dꞌara èmu. ");
INSERT INTO nfa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sèmi èèna kahèi, dhèu ètu dꞌara oka, baku lèpa èmu rare mèdha-papake. ");
INSERT INTO nfa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dhu jꞌèra risi, dhèu bhèni dhu dènge babia, dènge ina dhu pasusu ana rara iisi hiu, lula rèngu rai rare boe. ");
INSERT INTO nfa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","De hua iia risi miu sabajꞌa, sèna ka lodꞌo jꞌajꞌèra sèra baku lèke dènge hèru èjꞌi lai. ");
INSERT INTO nfa_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Te jꞌajꞌèra lodꞌo èèna, bia titu kèna! Mulai nèti Ama Lamatua tao rai-haha, toke dꞌai sange neꞌe, dhèu rèdhi mèka jꞌajꞌèra dhu bia sèmi èèna. Jꞌajꞌèra bia sèmi èèna, lodꞌo limuri, jꞌajꞌi heka hari. ");
INSERT INTO nfa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ladhe Ama Lamatua pabꞌabꞌe boe lodꞌo jꞌajꞌèra sèra, abhu boe dhèu èci sa dhu mamuri. Te ngaa, taga Ama Lamatua sue dhèu dhu Na hagꞌe nare sèra, ka Na pabꞌabꞌe lodꞌo-lodꞌo jꞌajꞌèra sèra. ");
INSERT INTO nfa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ladhe lodꞌo dꞌai na, miu tadèngi dhèu mai peka, aku rèngu na, ‘Ladhe ku! Kristus ètu neꞌe!’ Aa dhèu leo hari peka, aku rèngu na, ‘Aadꞌo! Kristus ètu nèi!’ Miu baku nanene kahèi! ");
INSERT INTO nfa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Te ladhe èèna na, dhèu mai ho tèbꞌa kakara, peka na, ‘Jaꞌa ne, Kristus!’ Aa cahagꞌe hari peka na, ‘Jaꞌa ne, dhèu nèti lii padhai Ama Lamatua.’ Èèna na ra tao tadha malaa ae-ae dènge koasa nidhu, ho kapodꞌe-kabèli dhèu. Rèngu patangi-tenge jꞌara sèna ka dhèu unu Ama Lamatua lèke tipu kahèi! ");
INSERT INTO nfa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nèti èèna ka, miu pajiko paie-iie! Mema lodꞌo jꞌajꞌèra bia èèna dꞌai mèka, te ngaa Jaꞌa pasanèdꞌe uuru miu!” ");
INSERT INTO nfa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Èle èèna ka, Yesus peka hari dènge ana madhutu Na sèra, aku Nèngu na, “Ladhe èle lodꞌo jꞌajꞌèra sèra, na, ‘Madha lodꞌo jꞌajꞌi maroga, aa hèru heo heka. ");
INSERT INTO nfa_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hua hètu-hua hètu bèbha nèti dedha-liru mai, aa koasa-koasa ètu dedha-liru jꞌajꞌi kaco-balo.’ ");
INSERT INTO nfa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Èle èèna, heka dhèu ladhe rèdhi Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne. Èèna na Jaꞌa mai dènge raꞌi-liru nèti dedha. Hèia dhèu aaꞌi-aaꞌi ladhe rèdhi aꞌèra dènge dadedha Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ka Jaꞌa paredha ana pajuu Ama Lamatua nèti sorga, ho puru lasi oru-kaboko dhèu aaꞌi-aaꞌi dhu Jaꞌa hagꞌe kore nèti mia-mia ètu rai-haha ne; nèti suu haa dꞌai suu dhimu, nèti suu badae toke dꞌai suu balèu.” ");
INSERT INTO nfa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus tuhu hari lii padhai Na, peka na, “Jaꞌa kore upama nèti ana aajꞌu. Ladhe rèu na mulai karara, èèna tadha hèru hadhu dètu le! ");
INSERT INTO nfa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sèmi èèna kahèi, ladhe miu mèdhi lodꞌo-lodꞌo jꞌajꞌèra sèra jꞌajꞌi, sama sèmi lii peka Jaꞌa deo na, èèna jꞌajꞌi mi tadha, peka na, mamai Jaꞌa dètu ae le. ");
INSERT INTO nfa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Neꞌe ne Jaꞌa peka dènge miu kèna! Nèti dhèu aaꞌi-aaꞌi dhu mamuri se, èèna na abhu cahagꞌe dhu dhae madhe mèka, te lodꞌo-lodꞌo dhu pènu dènge jꞌajꞌèra na dꞌai le. ");
INSERT INTO nfa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Masi ka liru dènge rai-haha ne ele, te ngaa lii holo-nori Jaꞌa ele boe, toke dꞌai mia-mia laꞌe.” ");
INSERT INTO nfa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus tuhu hari lii, peka na, “Dhèu èci sa reꞌa boe lodꞌo do jam dhu Jaꞌa mai hari. Ana pajuu Ama Lamatua ètu sorga sèra reꞌa boe kahèi. Jaꞌa mesa ku, keꞌa boe kahèi. Dhoka Ama Ku mesa Na di, dhu neꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nèti èèna ka, miu aaꞌi-aaꞌi mi hudꞌi pajiko paie, lula miu meꞌa boe lodꞌo dꞌai na. ");
INSERT INTO nfa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nèbhu heka, Jaꞌa laku tèke eele miu kèna, te ngaa èèna na Jaꞌa mai hari. Sama sèmi dhèu dhu laꞌe tèke eele èmu nèngu, ho laꞌe asa rai kajꞌèu. Na pua ana-ana nèngu jꞌaga paie èmu. Aa na bagi hia si sasabꞌa. Ka na paredha ana madhenga èmu, sèna ka na jꞌaga paie, toke dꞌai nèngu lèpa hari. ");
INSERT INTO nfa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Miu hudꞌi jꞌaga mèda-mèu kahèi, lula miu meꞌa boe lodꞌo mia Jaꞌa mai hari, sama sèmi ana madhenga èmu neꞌa boe lodꞌo lamatua èmu na lèpa. Lèpa lodꞌo nihia, talora mèda, oe mèu, lodꞌo rea, do lodꞌo nètu; miu meꞌa boe jam èèna. ");
INSERT INTO nfa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mage dhoka na mai sahèka, te abhu miu dhu bhèjꞌi luu era. ");
INSERT INTO nfa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","De, ngaa dhu Jaꞌa peka dènge miu neꞌe, Jaꞌa peka lème dènge dhèu leo kahèi, ‘Miu hudꞌi pajiko paie, ho mi soru mamai Jaꞌa.’ ” Dꞌai sange neꞌe ka, Lamatua Yesus padhai lii lula-nèti lodꞌo-lodꞌo jꞌajꞌèra dhèu rai-haha, dènge ana madhutu Na sèra ètu ledhe Saitun. ");
INSERT INTO nfa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Èle èèna ka, kètu agama Yahudi dènge mese agama sèra tenge jꞌara neo kèpe Yesus dènge mau-mau. Te rèngu neo pamadhe Ne. Te ngaa ètu dꞌara padhue èèna, ra peka na, “Taha ku! Baku parai kèpe Ne, lula lodꞌo kalela dètu le. Mage dhoka dhèu ae sèra patao dènge èdhi.” Rèngu padhai lii sèmi èèna, lula dii dua lodꞌo ka, dꞌai lodꞌo kalela dhèu Yahudi, dhu biasa ra peka na, ‘Paska’ dènge ‘Pesta Roti dhu pake boe Ragi’. Kalela se pasanèdꞌe rèngu lodꞌo bèi-baki ra kalua nèti rai Masir. ");
INSERT INTO nfa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ètu rae Betania, abhu ca dhèu ngara na Simon. Uru èèna, dhèu madenge dènge ne, lula nèngu pèdꞌa kusta. Te ngaa limuri ne, èle le nèti papèdꞌa na. Hèia lodꞌo kalela dhae dꞌai mèka, na, Yesus dènge ana madhutu Na sèra lasi raꞌa-rinu ètu èmu Simon. Ètu talora raꞌa-rinu era, dhèu bhèni èci mai paraga Yesus. Nèdꞌu dènge boto èci dhu ra tao nèti hadhu. Isi boto ne, èi hèu mèngi asli dhu kabꞌua titu kèna, dhu ra tao nèti amo aajꞌu hèu mèngi. Hèia bhèni ne pamae hèbꞌa boto èèna, ka na pasuti èi hèu mèngi mi kètu Yesus, ho jꞌajꞌi mi tadha, peka na, nèngu pakabꞌua Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te ngaa ètu èèna, abhu dhèu leo dhu raꞌa-rinu paꞌèci kahèi. Ropa dhèu se rèdhi dhèu bhèni ne tao sèmi èèna, hèia ra nasa. Ka ra padhai lii padedha iisi, peka na, “Ngaa ka unu bhèni nèi? Na bhori eele èi hèu mèngi kabꞌua aae èèna! ");
INSERT INTO nfa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Beꞌa risi nèngu pahie èi hèu mèngi èèna, ho laꞌe papala doi ae sèra, mi dhèu dhu dènge boe unu. Te kabꞌua èi hèu mèngi ne, èci èèna ka dènge gaji tuka dꞌara ca tèu.” Hèia ra jèke bhèni ne. ");
INSERT INTO nfa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Te ngaa Yesus bꞌala lii rèngu, aku Nèngu na, “Miu baku pasusa bhèni ne! Hudꞌi laa! Jaꞌa karejꞌe lula nèngu pasuti le ngiꞌu Jaꞌa dènge èi hèu mèngi neꞌe! ");
INSERT INTO nfa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dhèu kasia sèra, bèli-bèli ètu talora miu. De lodꞌo mia èèna ka dhu miu lake mere, na, miu bisa soru-bara si. Te ngaa nèbhu heka, Jaꞌa paꞌèci heka dènge miu. ");
INSERT INTO nfa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mamuri Jaꞌa nèbhu heka ètu rai-haha ne. Dènge tatao bhèni ne, nèngu lalau ngiꞌu Jaꞌa, sama sèmi nèngu pahèu mèngi mema ngiꞌu aae Jaꞌa, ho padhane. ");
INSERT INTO nfa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Miu patadhe, ee! Èèna na, ladhe dhèu lole Lii Lolo Beꞌa Ama Lamatua ètu mia-mia, na, ra palolo kahèi tatao beꞌa bhèni neꞌe. Sèna ka dhèu aaꞌi-aaꞌi sanèdꞌe nèngu.” ");
INSERT INTO nfa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Èle èèna ka, abhu ca dhèu nèti ana madhutu Yesus dhèu canguru dua sèra, ngara na Yudas Iskariot. Nèngu kalua laꞌe tenge kètu agama Yahudi sèra ho neo pahie Yesus mi rèngu. Ropa na paraga dènge rèngu, ka na peka naneo na. ");
INSERT INTO nfa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lodꞌo kètu agama sèra tadèngi naneo Yudas, ka ra karejꞌe titu kèna. Hèia ra jaji, peka na, “Ladhe èu neo pahie Yesus dènge jiꞌi, tatu jiꞌi bꞌae.” Hèia Yudas kalua, ka na mulai tenge jꞌara ho pahie Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lodꞌo èèna, lèke dènge lodꞌo partama nèti lodꞌo kalela dhèu Yahudi. De dꞌara lodꞌo èèna, rèngu tema tunu roti dhu dènge boe ragi, aa roro kahibꞌi-kalèbho kahèi. Hèia ana madhutu Yesus sèra mai karèi Ne, aku rèngu na, “Ama! Doe neꞌe ne, lodꞌo kalela Paska èdhi kèna. De Ama neo jiꞌi lalau era kalela Paska ètu mia?” ");
INSERT INTO nfa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hèia Yesus pua ana madhutu Na dhèu dua, aku Nèngu na, “Miu lami uuru ku asa dꞌara kota. Ètu nèi, miu paraga dènge dhèu mone èci, dhu pasae èi dꞌara gꞌala iiki cue. Lami madhutu ne nèti limuri. ");
INSERT INTO nfa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ladhe na maso asa èmu mia èèna ka, na, miu madhutu ne asa dꞌara. Hèia miu peka mi lamatua èmu èèna, sèmi neꞌe, ‘Ama Mese jiꞌi manèngi kama èci, ho Na neo tao kalela Paska dènge ana madhutu Nèngu.’ ");
INSERT INTO nfa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pe dhèu èèna pajꞌujꞌu kama aae èci ètu èmu dedha na, dhu na sadia nare le. De miu dua mi dhoka lami lalau ngangaꞌa di.” ");
INSERT INTO nfa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hèia dua ra lasi ka asa dꞌara kota. Dꞌai nèi, rèngu rèdhi tareꞌa, sama sèmi ngaa dhu Yesus moa deo na. Ka ra sadia aaꞌi-aaꞌi, ho Yesus si raꞌa kalela Paska ètu era èèna. Èle èèna ka, dua ra lasi paroa Yesus si. ");
INSERT INTO nfa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ropa lodꞌo oe cèna, hèia Yesus dènge ana madhutu dhèu canguru dua sèra dꞌai era èèna. ");
INSERT INTO nfa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ka ra madhèdi raꞌa sama-sama. Ètu talora raꞌa era, Yesus padhai lii dènge si, aku Nèngu na, “Miu nanene ku! Èèna na dhèu èci nèti miu se pahie eele Jaꞌa mi dhèu leo.” ");
INSERT INTO nfa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ropa tadèngi lii èèna, ana madhutu Yesus sèra cagꞌagꞌa dènge manyasa. Ka rèngu èci-èci mulai karèi Yesus, peka na, “Dhèu dhu Ama peka èèna, jaꞌa aadꞌo, sina ma?” ");
INSERT INTO nfa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hèia Yesus dhaa, aku Nèngu na, “Dhèu dhu cèbꞌu roti palere-lere dènge Jaꞌa asa dꞌara mago ne, nèngu ka dhu pahia Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mi sanèdꞌe! Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Jaꞌa hudꞌi madhe ku, sama sèmi dhu suri tèke le, ètu dꞌara Sasuri Mola-Mèci Ama Lamatua. Te ngaa kasia, dhèu dhu neo pahia Jaꞌa èèna, bèli-camèdꞌa nèngu dui nare pala na! Hua iia risi, ina na baku nara iisi ne!” ");
INSERT INTO nfa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ropa rèngu ètu talora raꞌa era, Yesus nare roti cue, hèia Na manèngi makasi mi Ama Lamatua. Ka Na pamae roti ne, hèia Na jꞌole asa ana madhutu Na sèra. Ka Na peka na, “Roti neꞌe ne, ngiꞌu Jaꞌa kèna. Mere ho miꞌa.” ");
INSERT INTO nfa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Èle èèna ka, Na nare galaa dhu isi dènge èi hua anggor. Na manèngi makasi mi Ama Lamatua kahèi. Ka Na jꞌole galaa èèna asa ana madhutu Na, sèna ka rinu. ");
INSERT INTO nfa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hèia Na peka, “Èi anggor neꞌe ne, raa Jaꞌa kèna, dhu suti sèna ka hia mamuri mi dhèu ae. Raa ne, jꞌajꞌi mi tadha ho pasanèdꞌe, peka na, ngaa dhu Ama Lamatua moa le èèna, limuri ne jꞌajꞌi le tareꞌa. Mere ho minu ka! ");
INSERT INTO nfa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mi sanèdꞌe paie! Nèti mèda neꞌe ne, Jaꞌa kinu heka èi anggor. Toke dꞌai Jaꞌa dènge Ama Ku ngèdꞌu paredha sama-sama ètu sorga, heka kinu hari kèna.” ");
INSERT INTO nfa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Èle èèna ka, ra sodꞌa lii sodꞌa èci, ho ra koa-kio kolongara Ama Lamatua. Ka mèda èèna kahèi, lasi dènge asa ledhe Saitun. ");
INSERT INTO nfa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ètu dꞌara kakako rèngu èèna, Yesus padhai lii, peka na, “Dꞌara mèda neꞌe ne, miu aaꞌi-aaꞌi mi rai tèke eele Jaꞌa mesa Ku. Sama sèmi dhu ra suri le ètu dꞌara Sasuri Mola-Mèci Ama Lamatua, peka na, ‘Èèna na Ama Lamatua pamadhe ana madhenga badha, ka kahibꞌi-kalèbho na rai pajꞌala asa haa, asa dhimu.’ ");
INSERT INTO nfa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Èèna na Jaꞌa madhe tareꞌa. Te ngaa lodꞌo Jaꞌa mamuri hari, Jaꞌa laku uru nèti miu asa propensi Galilea!” ");
INSERT INTO nfa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ka Petrus bꞌala, peka na, “Ama! Masi ka dhèu leo rai eele Ama, te ngaa jaꞌa rai boe!” ");
INSERT INTO nfa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hèia Yesus dhaa, “Petrus! Mu patadhe! Mèda neꞌe kahèi, manu kokotoo dꞌai mèka dua hari, te ngaa èu pasili le Jaꞌa tèlu hari, peka na, èu tadhe boe Jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ka Petrus pajèka dènge Ne, peka na, “Aadꞌo sèmi èèna, Ama! Ladhe Ama madhe, jaꞌa madhe dènge Ama kahèi. Te ngaa Jaꞌa pasili boe Ama, aa rai eele boe!” Angalai Petrus sèra lii èci èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hèia Yesus si lasi dꞌai dꞌara oka cue ètu ledhe Saitun, ngara na ‘Getsemani’. Dꞌai èèna, hèia Yesus peka dènge ra, “Miu madhèdi mate Jaꞌa mi neꞌe. Jaꞌa neo laku manèngi-mangajꞌi asa nèi.” ");
INSERT INTO nfa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ka Yesus gale nèti Petrus, Yakobis, dènge Yohanis lasi dènge Ne. Mulai nèti èèna ka, Na rasa dꞌara Nèngu maꞌète laho mae-mae. ");
INSERT INTO nfa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hèia Na peka dènge ana madhutu Na sèra, aku Nèngu na, “Dꞌara Jaꞌa pèdꞌa titu kèna! Jaꞌa rasa sèmi oe madhe sa. Miu madhèdi mate mi neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Hèia laꞌe ako kajꞌèu ciki nèti era èèna, ka Na patitu kètu urutuu Na ètu rai, ka Na sabajꞌa, peka na, “Ama pasue! Ladhe sèmi Ama dꞌèi, na, Jaꞌa baku pasae jꞌajꞌèra neꞌe dꞌai madhe. Jaꞌa keꞌa le, ètu madha Ama, abhu boe ngaa èci sa dhu Ama bisa boe tao. De ladhe bisa, na, Ama pakajꞌèu eele babia neꞌe nèti kabela-kao Jaꞌa. Masi ka sèmi èèna, baku madhutu dadꞌèi Jaꞌa; te ngaa hudꞌi madhutu dadꞌèi Ama Ku ka laa.” ");
INSERT INTO nfa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Èle èèna ka, Na lèpa asa ana madhutu Na, dhèu tèlu sèra, te ngaa ra bhèjꞌi luu. Hèia Na parèi si, ka Na padhai lii dènge Petrus, peka na, “Petrus! Èu bhèjꞌi, do? Jaꞌa nèbhu boe ètu nèi, te ngaa miu bisa boe beke mate Jaꞌa ciki sa! ");
INSERT INTO nfa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kèdꞌi ho pamako musi madha èu. Kèdꞌi ka, ho beke dènge Jaꞌa! Dꞌara miu neo tao beꞌa kahèi, te ngaa ngiꞌu miu roe. De beꞌa risi miu sabajꞌa, sèna ka ladhe miu lèke dadugu-rariu, miu baku manahu.” ");
INSERT INTO nfa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Èle èèna ka, Yesus laꞌe manèngi-mangajꞌi ca tèka hari. Nèngu manèngi hari mi Ama Lamatua, aku Nèngu na, “Ama! Ladhe bisa, na, Ama pakajꞌèu eele babia ne nèti Jaꞌa. Te ngaa hudꞌi madhutu dadꞌèi Ama Ku ka laa.” ");
INSERT INTO nfa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ka Na lèpa hari asa era ana madhutu Na dhèu tèlu sèra. Te ngaa rèngu bhèjꞌi hari le, lula musi madha ra sakaa titu kèna. Hèia Na parèi hari si, te ngaa rèngu reꞌa boe dhaa sèmi ngaa mi Nèngu. ");
INSERT INTO nfa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hèia Yesus tèke eele si, ka laꞌe manèngi-mangajꞌi dꞌai tèlu hari kèna. Èle èèna ka, Na lèpa laꞌe parèi ana madhutu Na sèra. Na peka, “Miu bhèjꞌi taruu era? Sange èèna ka laa! Kèdꞌi ka! Te dhèu dhu neo pahie Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, nuka mai dènge angalai nèngu sèra. Rèngu mai kèpe Jaꞌa, ho saraka mi dhèu bhelu-katubꞌa si. ");
INSERT INTO nfa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kèdꞌi ka! Pamako musi madha miu, ho ladhe ku asa nèi! Dhèu dhu neo pahie Jaꞌa ne, nuka mai nèi. Mai ho lati paraga dènge si!” ");
INSERT INTO nfa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ropa Yesus padhai lii era, hèia Yudas dꞌai madha Yesus dènge dhèu ae titu kèna. Rèngu mai rèti dènge hela dènge cèki, ho kèpe Yesus. Dhèu se tao sèmi èèna, lula ra madhutu lii paredha nèti kètu agama Yahudi, mese agama, dènge dhèu heka-dhèu heka adꞌa sèra. ");
INSERT INTO nfa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas hia mema tadha mi dhèu ae se, peka na, “Ladhe dꞌai nèi, jaꞌa uu cee, na, Nèngu kèna. De mi kèpe Ne.” ");
INSERT INTO nfa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ropa Yudas si dꞌai era èèna, na laꞌe asa madha Yesus. Ka na lii, aku nèngu na, “Ama mese!” Hèia na liku nare Yesus, ka na uu Ne. ");
INSERT INTO nfa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hèia dhèu ae sèra ara asa madha Yesus, ka ra kèpe Ne. ");
INSERT INTO nfa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Te ngaa ana madhutu Yesus èci bete hela na, ka na pare pamaꞌète rèu dhilu dhèu èci. Dhèu dhu nuꞌa ne, ènu nèti kètu kapai risi agama Yahudi. ");
INSERT INTO nfa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Hèia Yesus peka dènge dhèu ae dhu mai kèpe Nèngu sèra, aku nèngu na, “Tasamia? Miu ngee, na, Jaꞌa ne dhèu bhelu, do? Ka miu mai kèpe Jaꞌa mèti hela dènge cèki? ");
INSERT INTO nfa_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bèli-bèli Jaꞌa ajꞌa miu ètu Èmu Kapua Manèngi-Mangajꞌi, te ngaa miu èci sa kèpe boe Jaꞌa. Mai ka, kèpe Jaꞌa! Te jꞌara ne jꞌajꞌi sèmi dhu suri tèke le ètu dꞌara Sasuri Mola-Mèci Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ana madhutu Yesus sèra madhaꞌu titu kèna. Hèia ra rai tèke eele Yesus mesa Na ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Ètu era èèna, abhu ana mone ngèru èci kahèi dhu madhutu Yesus re limuri. Ana ne pahutu isi na dènge sigꞌi ca bèla. Dhèu sèra neo kèpe ne kahèi, ka na rai tèke eele sigꞌi na ètu kacui-aai dhèu sèra, lula na madhaꞌu. Hèia na rai dènge boe mèdha-papake ètu ua na. ");
INSERT INTO nfa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Èle èèna ka, ra rèti Yesus asa èmu kètu kapai risi agama Yahudi. Ètu èèna, dhèu kapai sèra pakaboko le. Rèngu sèra, nuka: kètu agama Yahudi, mese agama, dènge dhèu heka-dhèu heka adꞌa sèra. ");
INSERT INTO nfa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ropa ra kèpe rèti Yesus, Petrus madhutu mau-mau nèti limuri. Hèia na maso kahèi dꞌai madha èmu kètu kapai risi agama Yahudi, ka na madhèdi manyiru ai sama-sama dènge dhèu jꞌaga ètu sèra. ");
INSERT INTO nfa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ètu dꞌara èmu èèna, kètu agama Yahudi sèra padhue dènge dhèu-dhèu dhu madhèdi jꞌue lii langu agama. Ra patangi-tenge bukti ho pamanahu Yesus, lula ra neo pamadhe Ne. Te ngaa rèngu abhu boe bukti èci sa. ");
INSERT INTO nfa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ka ra paroa dhèu ae asa madha ho jꞌajꞌi sakasii, sèna ka neo pabèbhe Yesus. Te ngaa lii sakasii rèngu sèra, èci dènge èci pamèci boe. ");
INSERT INTO nfa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Abhu pèri-pèri dhèu sakasii leo dhu kèdꞌi titu, ka ra pakapodꞌe lii, peka na, ");
INSERT INTO nfa_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Jiꞌi tadèngi dhèu neꞌe peka na, ‘Èèna na Jaꞌa paguri eele Èmu Kapua Manèngi-Mangajꞌi dhu dhèu rai-haha tao dènge kacui-aai ra. Te ngaa èle tèlu lodꞌo ka, Jaꞌa patitu kore hari le Èmu èèna, dènge boe pake kacui-aai dhèu.’ ” ");
INSERT INTO nfa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Te ngaa lii lolo rèngu sèra èci dènge èci baka-leo hua. ");
INSERT INTO nfa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hèia kètu kapai risi agama Yahudi èèna, kèdꞌi titu ètu talora dhèu ae dhu madhèdi ètu sèra. Ka na karèi Yesus, aku nèngu na, “Dhèu ae mai le galaa Èu. Nga tao ka Èu mau-mau, moꞌo boe dhaa lii galaa sèra?” ");
INSERT INTO nfa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Te ngaa Yesus mau-mau, lii boe ca hèbꞌa sa. Èle èèna ka, kètu kapai risi agama Yahudi ne, karèi hari Ne ca tèka, “Èu peka ku laa! Tareꞌa-reꞌa Èu ne Kristus, Ana Ama Lamatua dhu Na moa nèti uuru èèna, do?” ");
INSERT INTO nfa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ka Yesus dhaa, aku Nèngu na, “Mema tareꞌa sèmi èèna! Nèngu èèna ka, Jaꞌa ne! Bèli-camèdꞌa miu ladhe mèdhi Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, madhèdi re babꞌoa gꞌana Ama Lamatua ètu sorga. Koasa Nèngu kapai risi eele! Ladhe èèna na, Jaꞌa dènge Nèngu, ngèdꞌu paredha sama-sama. Èle èèna na, Jaꞌa puru mai nèti sorga dènge raꞌi-liru.” ");
INSERT INTO nfa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ropa tadèngi nare lii padhai Yesus, kètu kapai risi agama Yahudi ne nasa titu kèna, hèia na ciu pamae kodho madhera ètu ua na. Ka na pajèka peka dènge dhèu-dhèu dhu madhèdi ètu sèra, aku nèngu na, “Èdhi parluu heka sakasii! ");
INSERT INTO nfa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Miu tadèngi le dènge roꞌa dhilu miu, si? Nèngu unu Na ka dhu peka sèmi èèna! Nèngu padedha iisi Na, jꞌajꞌi Ana Ama Lamatua. Lii neꞌe ne, lii dhu paꞌele iie kolongara Ama Lamatua! Madhutu atora agama èdhi, dhèu dhu tao iisi na sama sèmi Ama Lamatua, dhèu èèna hudꞌi lèke huku madhe ku! De mi pamaꞌète tasamia?” Hèia rèngu aaꞌi-aaꞌi pamaꞌète, peka na, “Dhèu neꞌe ne, tareꞌa-reꞌa sala! De Nèngu ne hudꞌi lèke huku pamadhe!” ");
INSERT INTO nfa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hèia pèri-pèri dhèu kèdꞌi lasi sabhuu ilu mi rèhu Yesus. Ra hutu musi madha Na, ka ra game Ne. Hèia ra karèi Ne, aku rèngu na, “Ladhe Èu jꞌajꞌi dhèu mèti lii padhai Ama Lamatua, na, Èu peka sèku! Cee ka dhu jꞌubhu Èu?” Èle èèna ka, ra pua dhèu dhu madhenge Èmu Kapua Manèngi-Mangajꞌi, ho mai pakako rèti Yesus. Ropa ra kako, ra tèbꞌe paꞌoke Ne nèti haa, nèti dhimu. ");
INSERT INTO nfa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Mèda èèna, Petrus madhèdi era ètu madha èmu èèna. Hèia ènu dhèu bhèni èci nèti kètu kapai risi agama Yahudi, mai ka nèdhi Petrus madhèdi manyiru ai. Na ladhe kaloo ka rèhu Petrus, ka karèi, aku nèngu na, “Deo na èu sama-sama dènge Yesus, dhèu Nasaret èèna, si?” ");
INSERT INTO nfa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Te ngaa Petrus dhaa, peka na, “Aadꞌo! Nga tao ka èu karèi sèmi èèna! Jaꞌa tadhe boe Dhèu èèna.” Hèia Petrus kalua, ka laꞌe titu ètu hèbꞌa tedhe. Kabèdhi laa, manu kokotoo. ");
INSERT INTO nfa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hèia dhèu bhèni èèna ladhe nèdhi hari Petrus. Ka na peka dènge dhèu ètu sèra, aku nèngu na, “Nèngu ne ca dhèu nèti rèngu kahèi!” ");
INSERT INTO nfa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Te ngaa Petrus pasili hari, ka na peka, “Tao-tao èu hujꞌu! Jaꞌa tadhe boe Dhèu neꞌe!” Nèbhu boe ka, dhèu èci ètu èèna kahèi, peka hari mi Petrus, aku nèngu na, “Èu ne baku pasili, peka na, èu dènge boe dhèu seꞌe se! We! Miu se aaꞌi-aaꞌi mi, dhèu Galilea, si?” ");
INSERT INTO nfa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ka Petrus pabꞌala hari, aku nèngu na, “Jaꞌa bani subha! Jaꞌa tadhe boe Dhèu nèi!” ");
INSERT INTO nfa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Petrus dhu padhai lii nare mèka, kabèdhi laa, manu kokotoo ka dua hari kèna. Hèia Petrus sanèdꞌe lii dhu Yesus peka dènge nèngu, “Ladhe manu kokotoo dꞌai mèka dua hari, te èu pasili le Jaꞌa tèlu hari peka na èu tadhe boe Jaꞌa!” Ropa ngee nèdhi, hèia Petrus tangi dꞌara pèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Madꞌae aae era, dhèu-dhèu jꞌue lii langu agama Yahudi sèra pareꞌa lii ho pamadhe Yesus. Ka ra èki rèti Ne, lasi asa madha gubernur Pilatus. ");
INSERT INTO nfa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ropa dꞌai madha gubernur, ka na karèi Yesus, aku nèngu na, “Tasamia? Èu ne tareꞌa Dhèu Aae Yahudi, do?” Yesus dhaa, aku Nèngu na, “Tareꞌa. Ama gubernur peka lèke kèna.” ");
INSERT INTO nfa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hèia kètu agama Yahudi sèra peka dènge gubernur, aku rèngu na, “Dhèu neꞌe tao sala ae titu kèna!” Hèia ra lolo ka sasala Na èci-èci. ");
INSERT INTO nfa_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ka gubernur karèi hari Yesus, “Èu tadèngi boe lii padhai dhèu seꞌe, do? Dhèu seꞌe, pasala le Èu ae-ae. Èu bꞌala ku laa!” ");
INSERT INTO nfa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Te ngaa Yesus bꞌala boe ca hèbꞌa sa, ka gubernur malaa. ");
INSERT INTO nfa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tèu mai-tèu mai, dhu tema le, ladhe dꞌai lodꞌo kalela Paska dhèu Yahudi, dhèu ae sèra pajꞌujꞌu ana bèdho èci, ho gubernur patalale ne. ");
INSERT INTO nfa_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lodꞌo èèna, ana bèdho èci, ngara na Barabas. Uru èèna, ra kèpe ne, taga na palabꞌa dènge dhèu paredha Roma, aa na pamadhe dhèu kahèi. ");
INSERT INTO nfa_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lula lodꞌo tatao Paska èèna oe dètu le, dhèu ae lasi manèngi gubernur Pilatus, ka ra paꞌoo-parodha, peka na, “Ama gubernur! Lodꞌo tatao Paska dètu le! Lodꞌo sèmi neꞌe, Ama gubernur patabuli ku ana bèdho èci, sama sèmi tèu-tèu uru sèra.” ");
INSERT INTO nfa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hèia gubernur bꞌala lii rèngu, “Ladhe sèmi èèna, jaꞌa patabuli cee? Tasamia, ladhe jaꞌa patabuli Dhèu Aae Yahudi miu, do? Miu moꞌo, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Gubernur peka sèmi èèna, lula nèngu neꞌa le, kètu agama Yahudi ka rèti Yesus mai asa nèngu, taga ra kacèki dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hèia kètu agama Yahudi se dadugu dhèu ae sèra, ho manèngi gubernur, peka na, “Jiꞌi ngoꞌo boe Nèngu! Jiꞌi dꞌèi dhoka patabuli Barabas di!” ");
INSERT INTO nfa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ka gubernur karèi hari dhèu ae sèra, “Ladhe sèmi èèna, Yesus, dhu ra pangare na ‘Dhèu Aae Yahudi’ èèna, jaꞌa tao Ne, tasamia?” ");
INSERT INTO nfa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka aaꞌi-aaꞌi ra paꞌoo, peka na, “Pamadhe Ne! Paku Ne mi ajꞌu palolo-palèbha!” ");
INSERT INTO nfa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Hèia gubernur karèi si, aku nèngu na, “Sasala Na ngaa? Jaꞌa parisa kore le. Te ngaa abhu boe sasala Na èci sa, dhu Nèngu tao!” Te ngaa dhèu se asa ka hino paꞌoo-parodha, aku rèngu na, “Pamadhe Ne! Paku Ne mi ajꞌu palolo-palèbha!” ");
INSERT INTO nfa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Lula gubernur neo pakarejꞌe dꞌara dhèu ae sèra, ka na patabuli Barabas madhutu dadꞌèi rèngu. Ka na paredha dhèu jꞌaga sèra lasi kalabhe Yesus pake gui. Game rare Ne, hèia sordadꞌu sèra rèti ka Yesus lasi neo paku pamadhe Ne ètu ajꞌu palolo-palèbha. ");
INSERT INTO nfa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Èle èèna ka, sordadꞌu sèra ère rèti Yesus asa era dhu taleo èci ètu madha èmu gubernur. Ka ra paroa anga sordadꞌu dhu leo sèra ca batalion, ho pakaboko. ");
INSERT INTO nfa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ra papake Yesus kodho madhera aae èci, dhu mea oe sèmi mangèru sa, sama sèmi mèdha-papake dhèu aae-dhèu aae. Ka rare loro ajꞌu dhu padhudhu, ho ènyu solo. Hèia ra ènyi solo padhudhu èèna mi kètu Yesus. Ka ra tao Ne, sèmi dhèu aae dhu dedꞌe hiu, dhu pake solo dhèu aae. ");
INSERT INTO nfa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rèngu aaꞌi-aaꞌi ra sangaja pakabꞌua Yesus. Ra peka, aku rèngu na, “Ama Dhèu Aae Yahudi dhu hua iia!” ");
INSERT INTO nfa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aa ra sangaja pacudꞌu kètu ho pakabꞌua Yesus. Ka ra sabhuu ilu pèri-pèri hari mi rèhu Yesus. Sèmi èèna kahèi, ra dꞌeu kètu Yesus dènge gui pahari-pahari. ");
INSERT INTO nfa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ropa ra tao rare sèmi èèna, ka ra bhoke eele kodho madhera nèti ua Na. Ka ra papake hari mèdha-papake Na. Èle ka, rèti Yesus asa liꞌu Yerusalem, ho neo paku Ne ètu ajꞌu palolo-palèbha dꞌai madhe. ");
INSERT INTO nfa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ropa rèngu kalua nèti Yerusalem, dꞌai talora jꞌara paraga dènge dhèu kota Kirene èci. Ngara na Simon, ama nèti Aleksander dènge Rufus. Ropa na neo maso asa Yerusalem, sordadꞌu sèra pakaseti ne pasae ajꞌu palolo-palèbha Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ère rèti Yesus asa era èci, ngara na Golgota. (Sasoa na, ‘era rui kètu’.) ");
INSERT INTO nfa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dꞌai era èèna, ra neo hia Yesus ninu èi hua anggor manyilu dhu pabꞌali dènge èi naꞌi, sèna ka Na taha rarii nèti nuꞌa-nuꞌa ètu ngiꞌu Na sèra. Te ngaa Yesus noꞌo boe ninu. ");
INSERT INTO nfa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Hèia ra paku kacui-aai dènge haga Yesus ètu ajꞌu palolo-palèbha. Paku rare ka, ra patitu ajꞌu palolo-palèbha èèna, ele boe dꞌara hake ceo madꞌae sa. Èle èèna ka, sordadꞌu sèra ère lot, ho reꞌa cee ka dhu abhu mèdha-papake Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ka ra suri ètu papa èci dhu ra paku re dedha kètu Yesus, peka na, “Neꞌe ne, Dhèu Aae Yahudi” Rèngu pake alasan èèna ka, ho huku pamadhe Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ètu èèna, ra paku parapo dhèu dua kahèi paꞌèci dènge Yesus. Èci re cabèka gꞌana, aa èci hari re cabèka kariu Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dènge jꞌara ne, rèngu madhutu sama sèmi dhu ra suri tèke ètu dꞌara Sasuri Ama Lamatua, peka na, “Ra tao Ne sama sèmi dhèu bhelu.” ");
INSERT INTO nfa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dhèu aaꞌi-aaꞌi dhu kako re èèna, ladhe rèdhi Yesus dhu ra paku ètu ajꞌu palolo-palèbha. Ka ra pakareko kètu, aa ra padhai lii pamakae Yesus, aku rèngu na, “Heh! Èu ne peka na, Èu bisa paguri eele Èmu Kapua Manèngi-Mangajꞌi, ho dꞌara tèlu lodꞌo, Èu pakèdꞌi hari, si? ");
INSERT INTO nfa_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Èu puru sèku nèti ajꞌu palolo-palèbha èèna, ho patabuli ngiꞌu Èu! Ladhe sèmi èèna, heka jiꞌi parcaya, na, Èu ne, Ana Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sèmi èèna kahèi, kètu agama Yahudi sèra, padhai lii pamakae Yesus, aku rèngu na, “Nèngu ne, patabuli le dhèu leo nèti rupa-rupa jꞌajꞌèra, te ngaa Nèngu bisa boe patabuli ngiꞌu Nèngu unu Na nèti jꞌajꞌèra neꞌe. ");
INSERT INTO nfa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nèngu peka unu Na, Nèngu ne ‘Kristus’, dhu uru èèna Ama Lamatua moa tèke le. Dhèu leo peka na, Nèngu ne Dhèu Aae Israꞌel. Ladhe tareꞌa sèmi èèna, hudꞌi laa Na puru nèti ajꞌu palolo-palèbha ne, sèna ka jiꞌi ngèdhi Ne. Heka jiꞌi parcaya Ne kèna.” Dhèu dua dhu ra paku sama-sama dènge Yesus sèra, padhai lii pamakae Yesus kahèi. ");
INSERT INTO nfa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dꞌara lodꞌo titu mera sa, era èèna maroga, toke dꞌai hake tèlu loo nihia. ");
INSERT INTO nfa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dꞌai hake tèlu nihia, hèia Yesus paꞌoo pake lii Aram, peka na, “Eloi! Eloi! Lema sabaktani?” (Dhu sasoa, peka na, “Lamatua Jaꞌa! Lamatua Jaꞌa! Nga tao ka, Ama Ku tèke eele Jaꞌa sèmi neꞌe?”) ");
INSERT INTO nfa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abhu pèri-pèri dhèu ètu èèna, tadèngi lii paꞌoo Yesus. Ka ra peka, “Miu nanene ku laa! Te Na paroa Elia, dhèu nèti lii padhai Ama Lamatua uru èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ka dhèu èci rai laꞌe nare ula dhasi, ka na cèbꞌu asa dꞌara èi hua anggor manyilu. Hèia nare ula èèna, èki ètu suu tatea èci, ka na soro asa panyoro Yesus ho Na camuci. Dhèu èèna peka, “Èdhi tatae sèku. Cee neꞌa, tao-tao Elia mai, ho papuru Ne nèti ajꞌu palolo-palèbha èèna.” ");
INSERT INTO nfa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hèia Yesus paꞌoo hari ca tèka, heka Na madhe kèna. ");
INSERT INTO nfa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi abhu bèla dhu bhèla aae, ra kadhoe paꞌabhe Kama Luri Mola-Mèci. Ropa Yesus maꞌète aꞌae, bèla ne mae cèri bagi mi dua, nèti dedha toke dꞌai haha. ");
INSERT INTO nfa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ètu Golgota abhu komedhaa sordadꞌu jꞌaga dhu titu dètu ajꞌu palolo-palèbha Yesus. Ropa ladhe nèdhi mamadhe Yesus, na cagꞌagꞌa. Hèia na peka, aku nèngu na, “Ira ii! Mema tareꞌa! Dhèu neꞌe ne, Ana Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Abhu pèri-pèri dhèu bhèni dhu madhutu lasi asa era èèna kahèi. Ra titu nèti kajꞌèu, ladhe rèdhi mamadhe Yesus ètu ajꞌu palolo-palèbha èèna. Rèngu se ka dhu uru èèna lalau-laloꞌo Yesus ètu Galilea. Rèngu sèra, nuka: Salome, Maria nèti rae Magdala, dènge Maria èci hari (nuka ina Yakobis dènge Yoses), dènge dhèu bhèni leo hari dhu mai asa Yerusalem, sama-sama dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ropa lodꞌo oe cèna, hèia dhèu èci tenge jꞌara ho papuru ngiꞌu aae Yesus nèti ajꞌu palolo-palèbha. Dhèu èèna, ngara na Yusuf, nèti kota Arimatea. Nèngu neꞌe kahèi, ca dhèu dhu jꞌue lii langu agama Yahudi. Nèngu dhèu dꞌara beꞌa kahèi. Aa nèngu mate nèbhu le paredha Ama Lamatua mai. Lodꞌo Yesus madhe èèna, lèke hari Jumat. Bèli na, lèke lodꞌo manèngi-mangajꞌi dhèu Yahudi. Nèti èèna ka, Yusuf neo papuru eele ngiꞌu aae Yesus ètu dꞌara lodꞌo hari Jumat èèna. Ka na pabani iisi na, laꞌe paraga dènge gubernur Pilatus, manèngi ho papuru ngiꞌu aae Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ropa gubernur tadèngi lii manèngi Yusuf ne, na malaa. Hèia na peka, aku nèngu na, “Eea! Nga tao ka, dhèu Ne madhe malai sa mia ne! Jaꞌa ngee, na, dhae madhe mèka!” Hèia na pua dhèu lasi paroa komedhaa, ka na karèi ne, aku nèngu na, “Sa mia? Yesus madhe le, do dhae?” ");
INSERT INTO nfa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Komedhaa èèna bꞌala, peka na, “Tareꞌa, ama! Na madhe le karèi deo na.” Ropa gubernur tadèngi nare lii dhaa èèna, hèia na hia Yusuf laꞌe nare ngiꞌu aae Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Hèia Yusuf laꞌe hèli bèla madhera dhu kabꞌua èci, ka na laꞌe asa Golgota. Dꞌai nèi, ka na papuru ngiꞌu aae Yesus nèti ajꞌu palolo-palèbha. Na pahutu ngiꞌu aae Yesus dènge bèla hiu. Tèu èèna, ra heka pae rare roꞌa èci ètu dꞌara hadhu aae. Hèia ra nedhe rèti ngiꞌu aae Yesus asa dꞌara roꞌa èèna. Ka ra loli rare hadhu kabela dhu kapai èci, ho ra bèdho paie hèbꞌa roꞌa èèna. Èle èèna ka, Yusuf si lèpa. ");
INSERT INTO nfa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Lodꞌo èèna, Maria nèti rae Magdala, dènge Maria èci hari, (ina Yoses), madhutu dꞌai era èèna kahèi. Dua ra rèdhi era dhu ra padhane Yesus, ka ra patadhe paie era èèna. ");
INSERT INTO nfa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bèli èèna, lèke hari Sabtu, nuka lodꞌo sabajꞌa dhèu Yahudi. Ropa lodꞌo cèna laꞌe, Maria nèti rae Magdala, Maria dhu leo hari (ina Yakobis), dènge Salome, lasi hèli èi hèu mèngi, sèna ka bèli rèngu bisa lasi pasuti mi ngiꞌu aae Yesus madhutu adꞌa dhèu Yahudi. ");
INSERT INTO nfa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ropa hari Migu madꞌae aae èèna, tèlu ra lasi asa roꞌa Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ètu talora jꞌara, tèlu ra padhue, aku rèngu na, “Waa! Dꞌai nèi, na, cee ka dhu bisa loli eele hadhu aae èèna nèti hèbꞌa roꞌa? Èdhi tèlu ti bisa boe, lula hadhu èèna kapai bia!” Te ngaa ropa rèngu dꞌai roꞌa èèna, rèdhi hadhu èèna dhu hari eele le nèti hèbꞌa roꞌa. ");
INSERT INTO nfa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hèia bhèni se maso asa dꞌara. Rèngu cagꞌagꞌa titu kèna, lula ètu dꞌara roꞌa èèna, rèdhi ana mone ngèru èci madhèdi ètu sebhe gꞌana rèngu, dhu pake mèdha pudhi lao-lao. ");
INSERT INTO nfa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hèia mone ngèru èèna, peka dènge rèngu, “Baku madhaꞌu! Jaꞌa keꞌa, na, miu mai tenge Yesus dhèu Nasaret, dhu ra paku pamadhe ètu ajꞌu palolo-palèbha. Na aadꞌo heka ètu neꞌe, lula Na mamuri hari le! Mai ho ladhe unu mi, te ngiꞌu Yesus aadꞌo heka ètu era dhu ra pajꞌunu Na. ");
INSERT INTO nfa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","De lami ka lai-lai, ho lole dènge Petrus si, peka na, Yesus mamuri hari le! Na laꞌe uuru le asa Galilea. Èèna na rèngu paraga dènge Yesus ètu nèi, sèmi dhu uru èèna Na peka mema le dènge rèngu. De lami ka!” ");
INSERT INTO nfa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ropa bhèni se rèdhi heka ngiꞌu Yesus ètu era dhu ra pajꞌunu Na, rèngu cagꞌagꞌa. Ka rai asa liꞌu lasi. Hèia rèngu lèpa dènge ka, ra peka boe dènge dhèu èci sa ètu jꞌara, lula rèngu madhaꞌu titu kèna. ");
INSERT INTO nfa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hari Migu madꞌae aae era, Yesus padꞌelo uuru ngiꞌu Na mi Maria nèti Magdala, dhu uru èèna, Yesus babège eele nidhu pidhu nèti nèngu. ");
INSERT INTO nfa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ropa na nèdhi nare Yesus, hèia laꞌe dènge ka, peka dènge dhèu-dhèu dhu uru èèna madhutu Yesus. Dhèu sèra pakaboko taruu ètu era èci. Rèngu ètu dꞌara susa era, taga ra ngee mamadhe Yesus. ");
INSERT INTO nfa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ka Maria peka dènge rèngu, aku nèngu na, “Nga tao ka miu susa era? Susa ia ka, te Yesus mamuri hari le! Deo na, jaꞌa heka paraga dènge Ne kèna!” Te ngaa rèngu aaꞌi-aaꞌi dhaa, aku rèngu na, “Èu ne, monya! Jiꞌi lèka boe.” ");
INSERT INTO nfa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Èle èèna ka, dhèu madhutu Yesus dhèu dua lasi asa rae èci. Ropa dꞌai talora jꞌara, Yesus padꞌelo ngiꞌu dènge si. Te ngaa Nèngu ubꞌa le. Nèbhu boe, heka ra tadhe Ne. ");
INSERT INTO nfa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hèia dua ra lèpa hari, lasi peka dènge angalai ra sèra, aku rèngu na, “Wee! Miu nanene ku laa! Lai-lai deo na, jiꞌi paraga le dènge Yesus ètu jꞌara!” Te ngaa angalai ra aaꞌi-aaꞌi dhaa, aku rèngu na, “Eeh! Miu baku monya sèmi èèna!” ");
INSERT INTO nfa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Èle èèna ka, Yesus paraga dènge ana madhutu Na sèra, dhèu canguru èci, ropa ra madhèdi raꞌa-rinu. Ka Na jèke si, aku Nèngu na, “Wee! Miu kètu hadhu paꞌae sa mia ne! Dhèu peka le dènge miu, rèngu rèdhi le Jaꞌa dènge musi madha rèngu, te ngaa miu parcaya boe! Aku miu na, dhèu sèra monya! De neꞌe ne, Jaꞌa unu ku mai. Mema tareꞌa Jaꞌa madhe, te ngaa Jaꞌa mamuri hari le! De mèdhi le, sina ma! ");
INSERT INTO nfa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","De lami ka asa mia-mia palème rai-haha ne. Peka dènge dhèu aaꞌi-aaꞌi ra Lii Lolo Beꞌa Jaꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dhèu cee dhu parcaya Jaꞌa aa abhu sarani, èèna na Ama Lamatua hia ne mamuri sèna ka na bisa pea taruu dènge Ne ètu sorga. Te ngaa cee dhu parcaya boe Jaꞌa, èèna na nèngu abhu huku nèti Lamatua, ka Lamatua core eele ne asa liꞌu laꞌe, ho na pea taruu ètu nèi. ");
INSERT INTO nfa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aa dhèu dhu parcaya Jaꞌa sèra, rèngu tao rupa-rupa tadha malaa, sèna ka dhèu aaꞌi-aaꞌi sèra reꞌa, peka na, “Koasa ra mema mai nèti Ama Lamatua!” Conto sèmi, èèna na rèngu bisa babège eele nidhu pake kolongara Jaꞌa. Ladhe èèna na, Ama Lamatua hia si padhai lii pake lii leo dhu rèngu mesa ra dhane rare boe. ");
INSERT INTO nfa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ladhe rèngu kèpe mege dhu dènge raco, do, rinu lèke raco, ngaa-ngaa tao boe. Ladhe ra tao kacui-aai asa dhèu pèdꞌa, dhèu èèna èle nèti papèdꞌa-tarègu na.” ");
INSERT INTO nfa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ropa padhai lii èle dènge ana madhutu Na sèra, hèia Ama Lamatua pacaꞌe Yesus asa sorga. Ètu nèi, Nèngu jꞌajꞌi ai gꞌana Ama Na, ka rèdꞌu paredha sama-sama. ");
INSERT INTO nfa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Èle èèna, hèia ana madhutu Na sèra madhutu paredha Na. Rèngu lasi asa mia-mia, ho lole mi dhèu aaꞌi-aaꞌi Lii Lolo Beꞌa Yesus. Hèia Ama Lamatua hia si koasa ho ra tao tadha-tadha malaa dhu Yesus peka le dènge rèngu. Nèti èèna ka, dhèu ae parcaya Yesus, taga rèngu reꞌa le Lii Lolo Beꞌa èèna, lèke tareꞌa-reꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Ama Teofilus dhu jaꞌa pakabꞌua. Lii mahoꞌo nèti jaꞌa. Dhèu ae dhu suri sèku le lii lolo nèti mamuri dènge sasabꞌa-laꞌa Yesus dhu jꞌajꞌi ètu talora aae jiꞌi. Rèngu suri lii lolo sèra pake lii lolo dhu parai reo nèti jiꞌi asa jiꞌi karèi nèti uru ka, dhu jiꞌi ngeꞌa nèti dhèu-dhèu dhu dètu dènge Lamatua Yesus, aa nèti dhèu leo dhu ladhe rèdhi dènge musi madha ra. Lii lolo seꞌe, lèke mola-mola dènge mamoa Ama Lamatua karèi nèti uru kèna. De jaꞌa parisa kore le toke lutu dènge beꞌa, jꞌara sèra aaꞌi-aaꞌi ra, mulai nèti jꞌajꞌajꞌi ra. Hèia jaꞌa pamaꞌète ho sèna ka suri si paie-iie ètu dꞌara sasuri neꞌe karèi nèti jꞌajꞌajꞌi ra. Dènge jꞌara ne, ama bisa meꞌa mèu ngaa dhu jꞌajꞌi le. ");
INSERT INTO nfa_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aa ama bisa parcaya ngaa dhu dhèu lole sèra, lii dhu monya boe. Aaꞌi-aaꞌi se jꞌajꞌi tareꞌa! ");
INSERT INTO nfa_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jꞌajꞌajꞌi lii lolo ne sèmi neꞌe: lodꞌo dhèu aae Herodes nèdꞌu paredha ètu propensi Yudea, abhu ca dhèu, dhu ngara na Sakaria. Nèngu ne, ca dhèu ama agama Yahudi. Aa nèngu kahèi, ca dhèu nèti kaboko ama agama Abia. Dhèu èmu Sakaria, ngara na Elisabet, ca dhèu ana-èpu nèti ama agama kahèi. Te Elisabet ne, ana-èpu nèti Harun, aꞌa Musa. ");
INSERT INTO nfa_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dua ra mamuri mola madhutu paredha dènge atora aaꞌi-aaꞌi nèti Ama Lamatua. Aa dhèu pakabꞌua si kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dua ra dhu heka le, te ngaa dhu abhu boe kolo, te era ana nèti Elisabet dhu bèdho mèno. ");
INSERT INTO nfa_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ca tèka, Sakaria dènge dhèu dꞌara kaboko Abia lèke lodꞌo rèngu sabꞌa ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi ètu kota Yerusalem. ");
INSERT INTO nfa_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Madhutu atora ama agama, hudꞌi ère lot, ho reꞌa cee ka dhu maso asa Kama Mola-Mèci dhu ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi. Ètu era èèna, dhèu ne hudꞌi pasèbu ai pake ajꞌu hèu mèngi ètu madha Ama Lamatua. Lodꞌo èèna, Sakaria lèke lot. ");
INSERT INTO nfa_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hèia laꞌe dènge ka asa dꞌara. Nèngu dhu talora pasèbu ai ètu dꞌara Kama èèna, dhèu ae-ae dhu sabajꞌa ètu madha Èmu. ");
INSERT INTO nfa_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Cagꞌagꞌa laa, ana pajuu Ama Lamatua ca dhèu nèti sorga titu re bèka gꞌana era tunu ajꞌu hèu mèngi ne. ");
INSERT INTO nfa_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ropa ladhe nèdhi, Sakaria madhaꞌu titu kèna, ka neꞌa heka tao sèmi ngaa. ");
INSERT INTO nfa_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Te ngaa ana pajuu ne lii, aku nèngu na, “Sakaria! Baku madhaꞌu! Te Ama Lamatua tadèngi le lii manèngi-mangajꞌi èu. De bèli-camèdꞌa, dhèu èmu èu nara iisi ana mone ca dhèu. Èu hudꞌi pangare ne, Yohanis. ");
INSERT INTO nfa_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Èèna na dhèu ae karejꞌe kahèi sama-sama dènge miu, lula miu abhu ana. Bèli-camèdꞌa, ana ne pakarejꞌe dꞌara èu. ");
INSERT INTO nfa_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Koasa nèti Roh Lamatua dhu Mola-Mèci, bera-bera dènge ne, karèi nèti ina na kadꞌo nèngu era. Nèngu ne hudꞌi luri ninu dhua ara-dhua pèdꞌu. Ropa na kapai, Ama Lamatua pake ne jꞌajꞌi dhèu dhu dènge kolongara. ");
INSERT INTO nfa_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bèli-camèdꞌa èèna pamako nare dhèu Israꞌel ae-ae, ho ra lèpa hari asa Ama Lamatua rèngu. ");
INSERT INTO nfa_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tatao dènge koasa na nuka sèmi Elia, ca dhèu dhu nèti lii padhai Ama Lamatua karèi uru. Nèngu ne mai uuru nèti Lamatua èdhi. Nèngu ne bisa kabèli dꞌara ina-ama, ho sue hari ana-ana ra. Aa dhèu dhu rai nèti madha Lamatua, na adꞌu si ho ra lèpa hari madhutu dadꞌèi Lamatua. Nèti sèmi èèna, nèngu tao dhèu sèna ka sadia dꞌara ra sèmi mamai Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Te ngaa Sakaria karèi ana pajuu ne, aku nèngu na, “Bisa boe, sina ma?! Jaꞌa dènge dhèu èmu jaꞌa, dꞌara heka sèmi neꞌe ne! Tasamia jaꞌa bisa keꞌa, na, jꞌara se bisa jꞌajꞌi?” ");
INSERT INTO nfa_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ka ana pajuu ne dhaa, peka na, “Sèmi neꞌe! Jaꞌa ne Gabriel, dhèu pajuu Ama Lamatua. Nèngu ka paleha jaꞌa mai, sèna ka peka dènge èu lii lolo dhu beꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Te ngaa èu moꞌo boe lèka lii padhai jaꞌa ne. De tadha dhu èu manèngi, sèmi neꞌe! Heꞌo èu èèna na sakaa, ho èu bisa heka padhai lii, nèti deo neꞌe ne, toke miu abhu ana. Pe èu mèdhi unu mu. Te ngaa dhu jaꞌa peka ne, bèli-camèdꞌa jꞌajꞌi, lèke dènge lodꞌo na.” ");
INSERT INTO nfa_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dhèu-dhèu dhu sabajꞌa ètu liꞌu sèra, bingu titu kèna, lula Sakaria tao bhodho boe. ");
INSERT INTO nfa_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ropa na kalua mai, nèngu bisa heka padhai lii. Ka na hia tadha re kacui-aai na, heka dhèu seꞌe reꞌa, na, Lamatua hia tanila ropa nèngu ètu dꞌara Kama Mola-Mèci èèna. ");
INSERT INTO nfa_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ropa èle sasabꞌa ra, hèia Sakaria lèpa asa èmu na. ");
INSERT INTO nfa_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Nèbhu boe ka Elisabet dènge babia. Ka na pea dhoka ètu dꞌara èmu toke lèmi hèru. Na peka, aku nèngu na, “Koa-kio Lamatua! Lodꞌo dꞌai kèna, Lamatua padꞌelo dꞌara hua iia Na mi jaꞌa. Ladhe jaꞌa ne dènge ka kolo, dhèu pamakae heka jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ropa Elisabet dènge babia dꞌai èna hèru, hèia Ama Lamatua pua ana pajuu Na nèti sorga, laꞌe asa rae cue ètu propensi Galilea, ngara na Nasaret. Ngara ana pajuu ne, Gabriel. ");
INSERT INTO nfa_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ètu Nasaret, abhu ana bhèni ngèru ca dhèu, ngara na Maria. Nèngu ne dhèu dhu lii dꞌai le, ngara na Yusuf. Yusuf ne, ana-èpu dhèu aae Daud. Gabriel laꞌe paraga dènge Maria. ");
INSERT INTO nfa_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka na padꞌelo iisi na mi ana bhèni ne, hèia na lii, peka na, “Salama, Maria, ee! Ama Lamatua dhu hagꞌe nare le èu, ho neo adꞌu jꞌara hua iia èci hia èu. Aa Nèngu bera-bera dènge èu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tadèngi nare sèmi èèna, ka Maria bingu, lula neꞌa boe sasoa nèti lii padhai ana pajuu ne. ");
INSERT INTO nfa_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hèia ana pajuu ne tuhu hari lii padhai na, aku nèngu na, “Maria! Baku madhaꞌu. Te Ama Lamatua neo padꞌelo dꞌara hua iia Na mi èu. ");
INSERT INTO nfa_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nèbhu heka, èu dènge babia, ho èèna na, èu mora iisi ana mone ca dhèu. Èu hudꞌi pangare Ne, Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nèngu ne, bèli-camèdꞌa jꞌajꞌi Dhèu kapai. Èèna na Lamatua pangare ne, ‘Nèngu ne, Ana dꞌèlu Jaꞌa.’ Nuka, Ana nèti Ama Lamatua dhu Dedha Risi Eele. Pe Ama Lamatua dedꞌe Ne, sèna ka nèdꞌu paredha, nuka sèmi baki Na, dhèu aae Daud. ");
INSERT INTO nfa_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nèngu ka dhu nèdꞌu paredha taa-taa mi dhèu Israꞌel. Te paredha Na dhu dènge boe too-lane.” ");
INSERT INTO nfa_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Te ngaa Maria karèi Gabriel, peka na, “Jaꞌa ne jꞌunu kèdhi mèka dènge dhèu mone èci sa! Tasa mera mia ka jaꞌa dènge babia?” ");
INSERT INTO nfa_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hèia Gabriel dhaa, peka na, “Sèmi neꞌe! Roh Lamatua dhu Mola-Mèci puru mai asa èu. Aa koasa nèti Ama Lamatua dhu Dedha Risi Eele, èèna na mai sarimu nare èu. Dènge jꞌara neꞌe, Ana dhu bèli-camèdꞌa èu more iisi èèna, tareꞌa-reꞌa mola-mèci, lula Nèngu èèna, Ana Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Baku malaa! Te aꞌari èu ca dhèu, ngara na Elisabet, dènge le babia kahèi. Dhèu peka na, nèngu èèna bisa heka nara iisi, lula nèngu dhu heka le. Te ngaa limuri ne, nèngu dènge babia èna hèru kèna. ");
INSERT INTO nfa_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Te bagi Ama Lamatua, aaꞌi-aaꞌi bisa jꞌajꞌi!” ");
INSERT INTO nfa_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ka Maria dhaa, peka na, “Beꞌa. Jaꞌa ne ènu Ama Lamatua. Hudꞌi laa aaꞌi-aaꞌi se jꞌajꞌi madhutu sèmi lii èu èèna ka. Jaꞌa keꞌa dhoka madhutu dadꞌèi Lamatua di.” Èle ka ana pajuu nèti sorga ne lèpa, tèke eele Maria. ");
INSERT INTO nfa_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Èle pèri-pèri lodꞌo, hèia Maria pakèdꞌi nèti Nasaret, laꞌe lai-lai asa rae Sakaria, ètu ledhe-ledhe propensi Yudea. Dꞌai nèi, laꞌe dènge ka asa dꞌara èmu Sakaria. Ka na hia lii mahoꞌo mi Elisabet. ");
INSERT INTO nfa_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ropa Elisabet tadèngi lii mahoꞌo nèti Maria, hèia ana ètu dꞌara kabake Elisabet pasèja. Aa Roh Lamatua dhu Mola-Mèci, maso sa Elisabet. ");
INSERT INTO nfa_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ka Elisabet paꞌoo, peka na, “Maria! Bèli-camèdꞌa dhèu dedꞌe padedha-dedha kolongara èu, risi nèti dhèu bhèni aaꞌi-aaꞌi ra ètu rai-haha ne! Èèna na dhèu aaꞌi-aaꞌi ra jꞌoke padedha-dedha kahèi Ana dhu èu kadꞌo èèna. ");
INSERT INTO nfa_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ra pakabꞌua jaꞌa kahèi, lula ina nèti Lamatua jaꞌa mai pangadꞌo dènge jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ropa èu mèti lii mahoꞌo mi dedha jaꞌa, cagꞌagꞌa laa ana dhu jaꞌa kadꞌo ne pasèja ètu dꞌara kabake jaꞌa, lula karae. ");
INSERT INTO nfa_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ama Lamatua padꞌelo le dꞌara hua iia Na mi èu, lula èu ne parcaya, peka na, Nèngu tao madhutu lii dhu Na moa tèke.” ");
INSERT INTO nfa_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria bhoka hèbꞌa, peka na, “Nèti dꞌara iiki jaꞌa, jaꞌa dedꞌe padedha-dedha Lamatua! ");
INSERT INTO nfa_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Dꞌara jaꞌa karejꞌe-karae, lula Ama Lamatua hia jaꞌa mamuri! ");
INSERT INTO nfa_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nèngu ne tao le madha-dhilu mi jaꞌa, nuka ana pua-paleha Na dhu dènge boe kabꞌua ne. Karèi nèti deo neꞌe, dhèu aaꞌi-aaꞌi ngee na, jaꞌa ne, bhèni dhu kalua mèngi titu kèna, ");
INSERT INTO nfa_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","lula Lamatua tao jꞌara malaa mi dedha jaꞌa. Nèngu ne, dhu Koasa Dedha Risi aa dhu Mola-Mèci Risi. ");
INSERT INTO nfa_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ama Lamatua loe boe padꞌelo sasue Na mi dhèu aaꞌi-aaꞌi dhu pakabꞌua aa dhu pahaha iisi ra mi Nèngu, nèti lai ana-lai èpu. ");
INSERT INTO nfa_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Na pake koasa Na, sèna ka tao pakaco dhèu-dhèu dhu padedha iisi sèra. ");
INSERT INTO nfa_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Na pamanahu dhèu aae-dhèu kapai dhu rèdꞌu koasa, lula ra padedha iisi. Te ngaa Na jꞌoka padedha-dedha dhèu-dhèu dhu pahaha iisi. ");
INSERT INTO nfa_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na pangaꞌa dhèu dhu manganga toke bècu, te ngaa Na babège-lalèta dhèu-dhèu kaja ho lasi dènge ai hua daꞌu-daꞌu. ");
INSERT INTO nfa_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Na soru-bara dhèu Israꞌel Na, dènge loe boe padꞌelo sasue Na mi rèngu. ");
INSERT INTO nfa_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Uru èèna, Na paꞌèki tèke le lii pajaji dènge bèi-baki èdhi, nuka baki Abraham dènge ana-èpu na aaꞌi-aaꞌi ra. Dꞌai sange neꞌe, lii pajaji èèna paꞌèki mèno.” ");
INSERT INTO nfa_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Hèia Maria pea dènge Elisabet toke tèlu hèru, heka lèpa asa èmu na ètu Nasaret. ");
INSERT INTO nfa_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ropa dꞌai hèru, ka Elisabet nara iisi ana mone ca dhèu. ");
INSERT INTO nfa_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lii neꞌe, ra palolo dꞌai aꞌari na dènge rae lesa, aku rèngu na, Ama Lamatua padꞌelo le dꞌara hua iia Na, ka Na hia Elisabet ana mone ca dhèu. Hèia rèngu aaꞌi-aaꞌi ra karejꞌe kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lodꞌo ana ne dꞌai aru lodꞌo, ka ra suna ne, madhutu atora dhèu Yahudi. Ra neo pangare ana ne, Sakaria, madhutu ngara ama na. ");
INSERT INTO nfa_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Te ngaa ina na bꞌala ra, aku nèngu na, “Aadꞌo sèmi èèna! Ngara na hudꞌi Yohanis ku!” ");
INSERT INTO nfa_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Te ngaa ra bꞌala ne, “Nga tao ka pili ngara Yohanis? Nèti aꞌari miu, ca dhèu sa dhu ngara dhae, sèmi mèka èèna!” ");
INSERT INTO nfa_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ka ra senen ho karèi Sakaria, sèna ka neo pangare ana ne ngara na ngaa. ");
INSERT INTO nfa_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hèia Sakaria senen ho manèngi lei. Ra hia ne lei, ka na suri peka na, “Ngara na Yohanis!” Ka dhèu aaꞌi-aaꞌi malaa titu kèna. ");
INSERT INTO nfa_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cagꞌagꞌa laa, heꞌo na dhu sakaa mèno èèna, mako dènge ka. Ka na koa-kio kolongara Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hèia dhèu aaꞌi-aaꞌi dhu pea padètu ètu sèra sa, madhaꞌu dènge malaa. Ka lii neꞌe mulai ra palolo nèti hèbꞌa sa hèbꞌa, toke dhèu-dhèu ètu ledhe-ledhe ètu propensi Yudea reꞌa aaꞌi kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dhèu-dhèu dhu tadèngi lii lolo èèna, ra pangee, peka na, “Tatu koasa nèti Lamatua bera-bera dènge ana ne. Bèli-camèdꞌa, ladhe na kapai mai, na jꞌajꞌi dhèu sèmi mia, oo?” ");
INSERT INTO nfa_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Èle ka, Roh Lamatua dhu Mola-Mèci maso asa Sakaria. Ka na padhai lii, peka na, ");
INSERT INTO nfa_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Koa-kio Ama Lamatua dhèu Israꞌel! Te Na mai le ho sui nare dhèu unu Na, sèna ka rèngu baku jꞌajꞌi sèmi ènu sa. ");
INSERT INTO nfa_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lamatua dedꞌe le ca Dhèu dhu koasa Na kapai titu kèna, ho hia èdhi mamuri. Nèngu ne, ana-èpu dhèu aae Daud. ");
INSERT INTO nfa_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Lamatua moa mema, karèi nèti uru ka, re dhèu dhu majꞌèni rèti lii padhai Na. ");
INSERT INTO nfa_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Limuri ne Na neo patabuli èdhi nèti musu-musu èdhi, aa nèti dhèu dhu dꞌara pèdꞌa dènge èdhi. ");
INSERT INTO nfa_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Na padꞌelo dꞌara hua iia Na mi bèi-baki èdhi, lula Na sanèdꞌe taruu lii pajaji Na mi rèngu, dhu Na paꞌèki dènge baki Abraham. ");
INSERT INTO nfa_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Na patabuli le èdhi nèti musu-musu èdhi, sèna ka ta pahaha iisi mi Nèngu, dhu dènge heka dꞌara madhaꞌu. ");
INSERT INTO nfa_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Na patalale le èdhi, sèna ka èdhi bisa mamuri mola-mèci dènge beꞌa taa-taa, ètu katanga madha Na. ");
INSERT INTO nfa_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yohanis, ee! Èu ne, ana jaꞌa. Bèli-camèdꞌa dhèu tadhe èu, na, dhèu nèti lii padhai Ama Lamatua dhu Dedha Risi aaꞌi. Èèna na, lamu peka-padhai dènge dhèu, sèna ka ra pakabhèle kacui-aai ra ho soru mamai Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Bèli-camèdꞌa, lamu pajꞌujꞌu jꞌara hia mi dhèu unu Lamatua, sèna ka reꞌa, na, Ama Lamatua hia mamuri mi rèngu, lula Nèngu ka dhu saku eele sasala-sasigo ra. ");
INSERT INTO nfa_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Lula dꞌara Lamatua taleo aa rasa kasia mi dedha èdhi, nèti èèna ka, Na hia èdhi taa-tebho dhu hiu, nuka sèmi lodꞌo hiu nèti saraa dhu hiu. Èdhi dhu mamuri ètu dꞌara maroga, aa èdhi dhu pea dènge dꞌara madhaꞌu ètu sanabhu mamadhe, lula pabeꞌa mèka dènge Lamatua, bèli-camèdꞌa abhu saraa ho lere èdhi asa jꞌara dhu nèti mera-milu.” ");
INSERT INTO nfa_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ka Yohanis asa kapai noo-noo. Aa Roh Lamatua paꞌèra ne. Na kapai mai, hèia laꞌe pea ka ètu dꞌara mamoo, toke dꞌai lodꞌo na pakako sasabꞌa mi dhèu Israꞌel sèra. ");
INSERT INTO nfa_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Ca tèka, ètu dꞌara Kirenius jꞌajꞌi gubernur ètu Siria, dhèu aae kapai Agustus, hia paredha, dhu peka na, “Dhèu aaꞌi-aaꞌi ètu paredha Roma, hudꞌi lèpa asa rae èta-èsu ra ho madhutu sensus!” Èèna heka hiu-lai kèna, dhèu paredha Roma ige ana kabarai na. ");
INSERT INTO nfa_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ka dhèu aaꞌi-aaꞌi lèpa asa rai èta-èsu ra, sèna ka madhutu sensus. ");
INSERT INTO nfa_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Lodꞌo èèna, Yusuf pea ètu rae Nasaret, ètu propensi Galilea. Nèngu dhu lii dꞌai ana bhèni ca dhèu, ngara na Maria, dhu dènge le babia. Yusuf ne, ana-èpu nèti dhèu aae Daud. Ka nèngu hudꞌi lèpa ku asa kota Daud, nuka Betlehem ètu propensi Yudea, sèna ka madhutu sensus. Nèti èèna ka, dua ra lasi asa kota Betlehem. ");
INSERT INTO nfa_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ropa dua ra ètu nèi, Maria dꞌai lodꞌo nara iisi. ");
INSERT INTO nfa_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Te ngaa ètu èèna, dua ra abhu boe kama ètu dꞌara losmen. Nèti èèna ka, dua ra maso lasi asa dꞌara oka badha. Hèia Maria nara iisi Ana uuru, mone ca dhèu. Ka pasigꞌi Ne dènge kahaꞌi bèla, aa pajꞌunu ètu dꞌara karabꞌa, era badha raꞌa-rinu. ");
INSERT INTO nfa_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mèda èèna, abhu ana madhenga badha dhèu pèri-pèri dhu beke madhenge kahibꞌi-kalèbho ètu dꞌara padꞌa ètu liꞌu kota. ");
INSERT INTO nfa_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kacaꞌa laa, rèngu rèdhi ana pajuu Ama Lamatua nèti sorga. Hèia saraa Lamatua rai-reo nare rèngu, ka ra madhaꞌu bia. ");
INSERT INTO nfa_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Te ngaa ana pajuu ne peka, “Baku madhaꞌu! Nanene pabeꞌa-beꞌa! Te jaꞌa ne mai ho peka lii lolo beꞌa èci hia miu. Cee dhu tadèngi lii neꞌe, tatu rèngu karejꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lii lolo beꞌa ne, sèmi neꞌe ka: Deo neꞌe, ca dhèu ina nara iisi le Kristus ètu Betlehem, nuka kota dhèu aae Daud. Kristus neꞌe ka dhu Ama Lamatua pajaji tèke le karèi nèti uru ka. Lamatua hia Na mai, sèna ka Na patabuli dhèu nèti koasa sasala-sasigo ra. Nèngu neꞌe, èèna na dhèu paroa Na, ‘Lamatua’! ");
INSERT INTO nfa_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pe miu tadhe Ne sèmi neꞌe ka: miu paraga dènge Ana rara iisi hiu ca dhèu dhu pahutu dènge sigꞌi. Ra pajꞌunu Ne ètu dꞌara karabꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ropa na padhai lii nare, hèia cagꞌagꞌa laa, ana pajuu Ama Lamatua ae-ae mai nèti sorga. Ka ra paꞌèci dènge ne. Hèia ra koa-kio kolongara Ama Lamatua dènge lii sodꞌa, peka na, ");
INSERT INTO nfa_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Jiꞌi dedꞌe padedha-dedha kolongara Ama Lamatua! Nèngu dhu nèdꞌu paredha ètu dedha-liru dhu dedha risi. Ama Lamatua neo hia dame dènge mera-milu mi dhèu rai-haha, dhu pakarejꞌe dꞌara Na!” ");
INSERT INTO nfa_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Èle ka, ana pajuu se lèpa hari asa sorga. Hèia ana madhenga badha se padhai lii, peka na, “Mai lati ku asa Betlehem, ho ladhe ku Ana nèi! Te Lamatua paꞌadhu le lii ne hia èdhi.” ");
INSERT INTO nfa_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hèia lasi ka lai-lai asa Betlehem. Ka rèngu paraga Maria dènge Yusuf. Aa ladhe rèdhi kahèi Ana dhu heka rara iisi, dhu bhèjꞌi ètu dꞌara karabꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ropa rèngu rèdhi Ana ne, hèia ra lolo, peka na, “Deo na ana pajuu Ama Lamatua nèti sorga dhu peka le dènge jiꞌi, lula-nèti Ana neꞌe ne!” Ka ra lolo aaꞌi-aaꞌi toke èle. ");
INSERT INTO nfa_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dhèu aaꞌi-aaꞌi malaa-maloha, tadèngi lii lolo ana madhenga badha se. ");
INSERT INTO nfa_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Te ngaa Maria tèke ka ètu dꞌara na, aaꞌi-aaꞌi dhu jꞌajꞌi le. Aa na pangee mau-mau, ho neo neꞌa sasoa na tasa mera mia. ");
INSERT INTO nfa_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Èle ka, ana madhenga badha se lèpa hari asa era kahibꞌi-kalèbho ra. Hèia ra dedꞌe padedha-dedha kolongara Ama Lamatua. Ra manèngi makasi mi Lamatua, lula dhu rèngu tadèngi aa rèdhi dènge musi madha ra, lèke tareꞌa-reꞌa sèmi ngaa dhu ana pajuu Ama Lamatua peka sèra. ");
INSERT INTO nfa_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ropa Ana iiki ne dꞌai aru lodꞌo, ka ra suna Ne madhutu atora Musa. Hèia ama dènge ina Na pangare Ne, ‘Yesus’. Ngara ne, ngara dhu ana pajuu nèti sorga peka le dènge rèngu, lodꞌo ina Na dènge mèka babia. ");
INSERT INTO nfa_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Atora èci nèti baki Musa peka na, bhèni dhu rara iisi rare, dꞌai èpa nguru lodꞌo hudꞌi madhutu ku adꞌa, pamèu iisi ra ètu Èmu Kapua Manèngi-Mangajꞌi. Dènge jꞌara neꞌe, rèngu bisa maso sèmi biasa asa dꞌara èmu sabajꞌa. Nèti èèna ka, Yusuf dènge Maria lasi asa kota Yerusalem, sèna ka tao madhutu adꞌa. Lasi rèti dènge Ana iiki èèna asa dꞌara Èmu Kapua Manèngi-Mangajꞌi, ho saraka Ne, sèna ka jꞌajꞌi unu Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Rèngu madhutu atora Lamatua dhu peka na, “Bhèni dhu nara iisi ana mone uuru, nèngu hudꞌi saraka ana ne jꞌajꞌi unu Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Madhutu atora Lamatua, ladhe saraka ana èèna mi Lamatua, ina-ama hudꞌi hia ku koro iia ca pasa, do koro jꞌaha ngèru dua ngiꞌu. Nèti èèna ka, Yusuf dènge Maria tao madhutu atora èèna. ");
INSERT INTO nfa_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Taa èèna, abhu mone heka ca dhèu ngara na Simeon, dhu pea ètu kota Yerusalem. Nèngu ne dhèu dꞌara mola, aa dꞌèi Lamatua. Roh Lamatua dhu Mola-Mèci peka le dènge ne, na, nèngu hudꞌi nèdhi ku Kristus, heka na madhe kèna. Kristus èèna ka, dhu bèli-camèdꞌa hia mamuri mi dhèu Israꞌel. ");
INSERT INTO nfa_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Lodꞌo èèna, Roh Lamatua lere Simeon laꞌe asa Èmu Kapua Manèngi-Mangajꞌi. Lodꞌo èèna kahèi, ina-ama Yesus rèti Ne, ho saraka jꞌajꞌi unu Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ropa ladhe nèdhi Ana ne, ka Simeon saꞌu nare Ne, hèia na koa-kio kolongara Ama Lamatua, aku nèngu na, ");
INSERT INTO nfa_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Koa-kio kolongara Lamatua! Lamatua tao le madhutu lii pajaji Na mi dedha jaꞌa. De neꞌe ne Lamatua bisa le patabuli jaꞌa, sèna ka jaꞌa madhe dènge mera-milu, ");
INSERT INTO nfa_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","te jaꞌa kèdhi le Dhèu dhu Lamatua pua mai, ho patabuli jiꞌi nèti koasa sasala-sasigo jiꞌi! ");
INSERT INTO nfa_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Lamatua neo pake Ana neꞌe, sèna ka hia mamuri mi suku aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nèngu nuka sèmi saraa, dhu pakabꞌua suku-suku Israꞌel, dhèu Lamatua sèra. Nèngu kahèi èci èèna ka dènge saraa, dhu padꞌelo jꞌara Lamatua, pala mi suku-suku leo kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ropa tadèngi sèmi èèna, hèia Yusuf dènge Maria malaa lula lii padhai dhu Simeon peka lula-nèti Ana rèngu ne. ");
INSERT INTO nfa_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Èle ka Simeon padhai lii hia si mèngi-nale. Hèia na peka dènge Maria, aku nèngu na, “Ina Yesus! Bèli-camèdꞌa dhèu ae ètu Israꞌel tule eele Ana èu ne. Te ngaa tatao rèngu mi dedha Nèngu ne, èèna na pamanahu hari rèngu. Ana neꞌe, bèli-camèdꞌa pakarejꞌe dꞌara dhèu ae kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Dènge jꞌara èèna, Lamatua bhoke patalele dꞌara dhèu. Te ngaa èu, Maria, pe mu paraga dènge jꞌajꞌèra ae-ae, nuka sèmi samala dhu lose adhe-usu èu.” ");
INSERT INTO nfa_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ètu Èmu Kapua Manèngi-Mangajꞌi, abhu kahèi bhèni heka ca dhèu, ngara na Hana. Umur na, aru nguru èpa tèu kèna. Ngara ama na Fanuel, nèti suku Aser. Na leo-èmu pidhu tèu, ka dhèu èmu na madhe. Hana ne, dhèu nèti lii padhai Ama Lamatua. Nèngu loe boe sabajꞌa dènge puasa ètu Èmu Kapua Manèngi-Mangajꞌi, ho pahaha iisi mi Ama Lamatua mèda-mèu. ");
INSERT INTO nfa_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lodꞌo Simeon padhai lii dènge Yusuf dènge Maria era, hèia Hana mai padètu-dètu. Ka nanene si padhai lii, hèia na koa-kio kolongara Ama Lamatua. Ka na padhai lii lula-nèti Yesus mi dhèu aaꞌi-aaꞌi dhu tatae mamai Dhèu Aae dhu Lamatua lii dhu moa tèke neo pua mai, sèna ka patabuli dhèu Israꞌel. ");
INSERT INTO nfa_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ropa Yusuf dènge Maria tao le madhutu atora nèti baki Musa ètu kota Yerusalem, ka ra lèpa asa rae Nasaret, ètu propensi Galilea. ");
INSERT INTO nfa_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ka Yesus asa kapai, asa èra, asa dꞌèlu-mèu dènge neꞌa madha jꞌara ae-ae. Aa Ama Lamatua padꞌelo dꞌara hua iia Na mi Yesus kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yusuf dènge Maria dhu tema le, tèu mai-tèu mai lasi asa kota Yerusalem ho madhutu kalela Paska ètu nèi. ");
INSERT INTO nfa_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ca tèka, ropa umur Yesus canguru dua tèu, hèia laꞌe palere dènge ina-ama Na asa Yerusalem, lasi raꞌa kalela Paska sèmi biasa. ");
INSERT INTO nfa_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Lodꞌo èle Paska, Yusuf dènge Maria mulai lèpa lasi asa Nasaret palere-lere dènge dhèu ae dhu lèpa asa Galilea. Te ngaa rèngu reꞌa boe, na, Yesus ètu Yerusalem era. Ra pangee, na, Nèngu palere dènge mone aanga-angalai Na. Te ngaa ropa dꞌai lodꞌo nihia, Yusuf dènge Maria rèdhi boe Ne. Ka dua ra mulai patangi-tenge kèna. Lasi pakarèi mi aꞌari ra, aa mone aanga-angalai ra. ");
INSERT INTO nfa_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lula rage boe Ne, hèia dua ra lèpa hari sa Yerusalem, lasi tenge Ne ètu nèi. ");
INSERT INTO nfa_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dꞌai nèi, ra patangi-tenge Ne toke tèlu lodꞌo kateme, heka paraga dènge Ne kèna, ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi. Nèngu dhu madhèdi padhue-padhai dènge mese agama Yahudi sèra. ");
INSERT INTO nfa_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Dhèu aaꞌi-aaꞌi dhu nanene lii dhaa Na, malaa-maloha, lula Nèngu tareꞌa-reꞌa neꞌa mèu isi Sasuri Mola-Mèci Ama Lamatua, aa Na neꞌa dhaa lii karèi dènge mola. ");
INSERT INTO nfa_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Rèdhi sèmi èèna ka, ina-ama Na malaa kahèi. Hèia ina Na lii, aku nèngu na, “Yesus! Nga tao ka Èu pajꞌèra jiꞌi sèmi neꞌe? Ama Mu dènge jaꞌa patangi-tenge Èu heo dꞌèlu!” ");
INSERT INTO nfa_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Te ngaa Yesus dhaa, peka na, “Nga tao ka ina dènge ama pajꞌèra iisi tenge Jaꞌa? Meꞌa, si? Jaꞌa dènge urusan ètu Èmu Ama Ku.” ");
INSERT INTO nfa_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Te ngaa rèngu reꞌa rare boe sasoa lii Na. ");
INSERT INTO nfa_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hèia aaꞌi-aaꞌi ra lèpa asa Nasaret. Ka Yesus madhutu kahèi dadꞌèi ina dènge ama Na. Ka ina Na tèke aaꞌi-aaꞌi seꞌe ètu dꞌara na. ");
INSERT INTO nfa_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Hèia Yesus asa tabha kapai, asa tabha dꞌèlu-mèu, asa pakarejꞌe dꞌara Ama Lamatua, dènge dhèu rai-haha asa tabha dꞌèi Ne. ");
INSERT INTO nfa_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Taa èèna, Tiberius jꞌajꞌi dhèu aae kapai dhu nèdꞌu paredha ètu Roma, canguru lèmi tèu kèna. Pontius Pilatus jꞌajꞌi gubernur ètu propensi Yudea. Herodes jꞌajꞌi gubernur ètu propensi Galilea. Aꞌa Herodes ka Pelipus, jꞌajꞌi gubernur ètu propensi Iturea dènge propensi Trakonitis. Aa Lisanias jꞌajꞌi gubernur ètu propensi Abilene. Taa èèna kahèi Hanas dènge Kayafas, dhu jꞌajꞌi kètu kapai risi agama Yahudi ètu kota Yerusalem. Lodꞌo èèna, Yohanis, ana Sakaria, dhu pea ètu era kajꞌèu nèti rae. Ètu era neꞌe, Lamatua pangèdꞌu ne lii. ");
INSERT INTO nfa_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ropa tadèngi nare, hèia Yohanis laꞌe asa dꞌara rae dhu dètu dènge loko Yarden, ho peka dènge dhèu-dhèu ètu sèra, aku nèngu na, “Miu hudꞌi ele-hoꞌa ku, aa tèke eele sasala-sasigo miu aaꞌi-aaꞌi, sèna ka Ama Lamatua saku eele sasala sèra. Èle èèna, miu sarani uuru ku, sèna ka jꞌajꞌi mi tadha, peka na, miu pabeꞌa le dènge Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Uru-uru sèra, baki Yesaya, dhèu nèti lii padhai Lamatua, suri tèke le lula-nèti Yohanis ne, peka na, “Abhu dhèu dhu ètu dꞌara mamoo, paꞌoo, peka na: ‘Dhèu aaꞌi-aaꞌi paꞌèra, sèna ka tao paie-iie jꞌara, ho sèmi mamai Lamatua! Pamola jꞌara sèna ka lami soru Ne. ");
INSERT INTO nfa_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dhènu pamera era kajèlo aaꞌi-aaꞌi. Tao pamera-mera ledhe aaꞌi-aaꞌi. Tao pamola jꞌara dhu koe-kalèko, tao pamilu jꞌara dhu ako kabhuku. ");
INSERT INTO nfa_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sèna ka dhèu nèti suku aaꞌi-aaꞌi ra bisa reꞌa, na, Ama Lamatua neo pakajꞌèu dhèu nèti sasala-sasigo ra.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dhèu ae mai nèti mia-mia, manèngi ho Yohanis sarani si. Te ngaa na jèke si, peka na, “Miu se dhèu kapodꞌe-kabèli! Miu èci èèna ka mege dhu dènge raco! Mage miu pangee na miu bisa pakajꞌèu nèti hahuku Lamatua, sadꞌi dhoka ele-hoꞌa di! Aadꞌo! Nèbhu heka Lamatua huku dhèu aaꞌi-aaꞌi dhu tareꞌa-reꞌa ele boe hoꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mage miu pangee na, ‘Jaꞌa ne lèke boe huku, lula jaꞌa ana-èpu baki Abraham.’ Abhu ètu mia sèmi èèna? Jꞌajꞌi ana-èpu Abraham bisa boe tao miu jꞌajꞌi dhèu mola-mèci. Lamatua bisa tao hadhu se, sèna ka jꞌajꞌi ana-èpu Abraham. Jaꞌa peka kèna! Padꞌelo ètu dꞌara mamuri miu, dhu peka na, miu tèke eele le sasala-sasigo miu, aa mai ho madhutu Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Miu hudꞌi tao ku jꞌara beꞌa. Ladhe aadꞌo, na, hahuku Lamatua dhu bia, bèbhe mai lèke miu, nuka sèmi dhèu pake kataka ho patue ajꞌu nèti amo na. Nuka sèmi èèna ka! Ajꞌu dènge boe guna, ladhe hua-hela na nèti boe babeꞌa! De beꞌa risi patue ne, aa core eele asa dꞌara ai laꞌe.” ");
INSERT INTO nfa_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hèia dhèu ae karèi Yohanis, “Ladhe sèmi èèna, jiꞌi se tasamia?” ");
INSERT INTO nfa_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ka na dhaa, peka na, “Ladhe èu dènge kodho dua bèla, hia èci sa dhèu dhu dènge boe kodho. Aa ladhe èu dènge ngangaꞌa, bagi hia dhèu dhu dènge boe ngangaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Hèia dhèu roro bea mai manèngi kahèi, sèna ka Yohanis sarani si. Ka ra karèi, peka na, “Ama mese! Jiꞌi se hudꞌi tao sèmi ngaa ku?” ");
INSERT INTO nfa_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ka na dhaa, “Miu se dꞌèi kapodꞌe-kabèli. De nèti deo neꞌe, miu hudꞌi sabꞌa ku dènge mola. Baku roro bea risi nèti atora paredha. Hudꞌi laa kabarai bꞌae madhutu atora na.” ");
INSERT INTO nfa_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Abhu kahèi sordadꞌu pèri-pèri ètu sèra. Ra karèi, na, “Jiꞌi se hudꞌi tao ku sèmi ngaa?” Hèia Yohanis bꞌala, peka na, “Baku parama doi-dhari dhèu madhutu dadꞌèi miu. Aa baku galaa leli dhèu. Ladhe sèmi mere gaji, miu hudꞌi manèngi makasi mi Lamatua, aa rasa dꞌai le dènge gaji èèna.” ");
INSERT INTO nfa_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ropa ra tadèngi rare, dhèu se mulai pagagai aa pakaꞌuu èci dènge èci, peka na, “Eeh! Tao-tao Yohanis ne, Kristus, dhu Lamatua peka karèi nèti uru ka, neo hia mai èèna!” ");
INSERT INTO nfa_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Te ngaa Yohanis bꞌala si, peka na, “Nanene paie! Bèli-camèdꞌa, Dhèu èci mai dhu kapai risi nèti jaꞌa. Masi ka jꞌajꞌi ana pua-paleha Na, jaꞌa ne bisa boe sa hèi. Jaꞌa ne sarani miu dhoka pake èi di, te ngaa bèli-camèdꞌa Na tao risi eele nèti jaꞌa, te Na papènu dꞌara miu dènge Roh Lamatua dhu Mola-Mèci. Aa Na pamèu dꞌara miu nuka sèmi dhèu pake ai ho tunu maruru. ");
INSERT INTO nfa_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Na huku dhèu dhu adꞌu-ue sasala, tao si cakaraa dhèu sabꞌa oka, dhu patiri are ho ngèlu tiu eele kètu na. Èle ku, heka soli are dhu mèu asa dꞌara soka, aa kètu dènge kajꞌalu are sèra, tunu pakèpu si. Nuka sèmi èèna kahèi, bèli-camèdꞌa Kristus huku dhèu dhu adꞌu-ue sasala, dènge jꞌara pèci si asa dꞌara ai dhu heo robhe-robhe dhu madhe nèdhi boe.” ");
INSERT INTO nfa_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dènge jꞌara neꞌe Yohanis pasanèdꞌe dhèu nèti rupa-rupa madha jꞌara, aa lole dènge ra Lii Lolo Beꞌa Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Taa èèna, Yohanis padhai lii pahuni heka, jꞌara-jꞌara dhu Herodes adꞌu-ue. Lii langu Herodes nuka sèmi neꞌe ka: Herodes ne, gubernur ètu propensi Galilea. Sasala na udhu sèmi kadhèna hèru hadhu sa. Sasala na èci ka, parame nare Herodias, dhèu èmu ari na, masi ka ari na mamuri era, dhu dhae paꞌia mèka. Jꞌara mamuri Herodes sèmi neꞌe, ka Yohanis kai dènge madha na, toke Herodes nasa dènge ne. Nèti èèna ka, Herodes kèpe ne, hèia pamaso asa dꞌara èmu bèdho. ");
INSERT INTO nfa_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Uru èèna, lodꞌo dhu ra kèpe mèka Yohanis ne, nèngu sarani dhèu ae le. Aa na sarani Yesus kahèi. Sarani èle, ka Yesus sabajꞌa, kabèdhi laa, liru bhoka eele. ");
INSERT INTO nfa_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Hèia Roh Lamatua dhu Mola-Mèci puru mai sa Yesus. Roh ne rupa na sèmi koro jꞌaha sa. Hèia lii nèti dedha-liru peka na, “Èu ne, Ana pasue Jaꞌa. Èu ne, loe boe pakarejꞌe dꞌara Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Lodꞌo Yesus mulai lole dènge dhèu jꞌara mamuri Lamatua, umur Na pe dꞌai tèlu nguru tèu sa. Dhèu tadhe Yesus ne, Ana nèti Yusuf. Bèi-baki Yusuf sèmi neꞌe: Yusuf, ama na, Eli. ");
INSERT INTO nfa_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli, ama na, Matat. Matat, ama na, Lewi. Lewi, ama na Melki. Melki, ama na, Yanai. Yanai, ama na, Yusuf. ");
INSERT INTO nfa_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf, ama na, Matatias. Matatias, ama na, Amos. Amos, ama na, Nahum. Nahum, ama na, Hesli. Hesli, ama na, Nagai. ");
INSERT INTO nfa_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai, ama na, Maat. Maat, ama na, Matatias. Matatias, ama na, Semein. Semein, ama na, Yosek. Yosek, ama na, Yoda. ");
INSERT INTO nfa_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda, ama na, Yohanan. Yohanan, ama na, Resa. Resa, ama na, Serubabel. Serubabel, ama na, Sealtiel. Sealtiel, ama na, Neri. ");
INSERT INTO nfa_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, ama na, Melki. Melki, ama na, Adi. Adi, ama na, Kosam. Kosam, ama na, Elmadam. Elmadam, ama na, Er. ");
INSERT INTO nfa_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, ama na, Yosua. Yosua, ama na, Elieser. Elieser, ama na, Yorim. Yorim, ama na, Matat. Matat, ama na, Lewi. ");
INSERT INTO nfa_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi, ama na, Simeon. Simeon, ama na, Yahuda. Yahuda, ama na, Yusuf. Yusuf, ama na, Yonam. Yonam, ama na, Elyakim. ");
INSERT INTO nfa_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim, ama na, Melea. Melea, ama na, Mena. Mena, ama na, Matata. Matata, ama na, Natan. Natan, ama na, Daud. ");
INSERT INTO nfa_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud, ama na, Isai. Isai, ama na, Obet. Obet, ama na, Boas. Boas, ama na, Salmon. Salmon, ama na, Nahason. ");
INSERT INTO nfa_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason, ama na, Aminadab. Aminadab, ama na, Admin. Admin, ama na, Arni. Arni, ama na, Hesron. Hesron, ama na, Peres. Peres, ama na, Yahuda. ");
INSERT INTO nfa_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda, ama na, Yakob. Yakob, ama na, Isak. Isak, ama na, Abraham. Abraham, ama na, Tera. Tera, ama na, Nahor. ");
INSERT INTO nfa_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor, ama na, Seruk. Seruk, ama na, Rehu. Rehu, ama na, Pelek. Pelek, ama na, Eber. Eber, ama na, Sela. ");
INSERT INTO nfa_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela, ama na, Kenan. Kenan, ama na, Arpaksad. Arpaksad, ama na, Sem. Sem, ama na, Noh. Noh, ama na, Lamek. ");
INSERT INTO nfa_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek, ama na, Metusalak. Metusalak, ama na, Henok. Henok, ama na, Yared. Yared, ama na, Mahalalel. Mahalalel, ama na, Kenan. ");
INSERT INTO nfa_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan, ama na, Enos. Enos, ama na, Set. Set, ama na, Adam. Adam neꞌe ka, paꞌue-ai Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ropa Yohanis sarani nare Yesus, hèia Yesus laꞌe, tèke eele loko Yarden. Roh Ama Lamatua bera-bera dènge Ne, ka pakako Ne asa dꞌara mamoo èci. ");
INSERT INTO nfa_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ka Yesus pea ètu èèna toke èpa nguru lodꞌo. Ètu era neꞌe, naꞌa-ninu boe ngaa-ngaa, ka Na manganga titu kèna. Aa dhèu aae nidhu mai sèku Ne. ");
INSERT INTO nfa_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na peka dènge Yesus, aku nèngu na, “Ladhe Èu ne tareꞌa Ana Ama Lamatua, Èu dènge koasa. De tao hadhu se jꞌajꞌi roti, ho muꞌa si.” ");
INSERT INTO nfa_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Te ngaa Yesus bꞌala ne, peka na, “Èu hari! Meꞌa boe, do? Dhu suri tèke le ètu dꞌara Sasuri Ama Lamatua, peka na, ‘Mamuri dhèu rai-haha, mesa boe dhoka nèti ngangaꞌa-nganginu di!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Èle èèna ka, dhèu aae nidhu nèti hari Yesus asa era èci dhu dedha aae, hèia na pajꞌujꞌu dènge Yesus aꞌèra dènge koasa paredha aaꞌi-aaꞌi ètu rai-haha ne. Hèia na pamako Yesus, na, “Aꞌèra dènge koasa paredha aaꞌi-aaꞌi sèra, ètu dꞌara kacui-aai jaꞌa. De jaꞌa dènge hak ho pangèdꞌu mi cee èèna ka, sadꞌi jaꞌa koꞌo. ");
INSERT INTO nfa_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aaꞌi-aaꞌi se, jaꞌa neo hia mi Èu. Te ngaa sadꞌi Èu tao ku ca jꞌara, heka jaꞌa hia Èu kèna. Mudꞌa iiki-iiki! Èu pahaha iisi mi jaꞌa! Dhoka èèna di.” ");
INSERT INTO nfa_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Te ngaa Yesus dhaa, peka na, “Abhu ètu mia jꞌara na sèmi èèna? Te ètu dꞌara Sasuri Ama Lamatua, dhu suri, na, ‘Èu dhoka pahaha iisi mi Ama Lamatua di. Aa èu sogo-tagu dhoka mi Nèngu di.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Èle ka, dhèu aae nidhu nèti hari Yesus asa kota Yerusalem. Dꞌai era neꞌe, na pacaꞌe Yesus asa era dhu dedha risi ètu Èmu Kapua Manèngi-Mangajꞌi. Ka na peka, “Ladhe tareꞌa-reꞌa Èu ne Ana Ama Lamatua, na, ridhu asa haha nèi! ");
INSERT INTO nfa_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Te dhu suri ètu dꞌara Sasuri Ama Lamatua, peka na, ‘Pe Ama Lamatua pua ana pajuu Na nèti sorga, ho mai jꞌaga Èu. ");
INSERT INTO nfa_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Èèna na ra sibhe Èu, sèna ka haga Èu goi lèke boe hadhu sa hèi.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Te ngaa Yesus bꞌala lii nidhu ne, “Èu baku karihu kahadhu dènge Jaꞌa ne. Lula dhu suri tèke ètu dꞌara Sasuri Ama Lamatua, na, ‘Baku sèku Ama Lamatua.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Dhèu aae nidhu ne tenge jꞌara rupa-rupa ho sèku Yesus, te ngaa tao nare boe. Ka laꞌe tèke eele Yesus, na mate hari lodꞌo dhu beꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Èle èèna ka, Yesus lèpa hari asa propensi Galilea, te Roh Lamatua dhu Mola-Mèci hia Ne koasa. Nèbhu boe ka dhèu-dhèu ètu dꞌara rai èèna, mulai tadhe kolongara Na. ");
INSERT INTO nfa_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na ajꞌa-nori dhèu ètu dꞌara èmu manèngi-mangajꞌi dhèu Yahudi ètu mia-mia. Ka dhèu koa-kio Ne, peka na, “Yesus ne dhu ele madha, nga!” ");
INSERT INTO nfa_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ca tèka, Yesus mai asa rae Na Nasaret. Lèke dènge lodꞌo manèngi-mangajꞌi dhèu Yahudi, dhu ra pangare na ‘sabat’, hèia laꞌe asa dꞌara èmu sabajꞌa sèmi dhu tema Na tao. Ka Na kèdꞌi titu ho neo baca nèti Sasuri Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ka ra jꞌole hia Ne sasuri nèti baki Yesaya. Hèia Na bhoke tenge ayat, ka Na baca, peka na, ");
INSERT INTO nfa_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Koasa Roh Ama Lamatua abhu ètu Jaꞌa. Nèti èèna ka, Na pajꞌujꞌu Jaꞌa, ho peka-padhai Lii Lolo Beꞌa Ama Lamatua mi dhèu-dhèu dhu unu aadꞌo. Nèngu pua le Jaꞌa mai, ho lole, na, dhu ana bèdho, èèna na patalala si; dhu bèdhu, èèna na bisa rèdhi hari; dhu lèke ènyi nèti dhèu, èèna na patabuli eele. ");
INSERT INTO nfa_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Te limuri ne dꞌai le lodꞌo Lamatua, sèna ka pala mamuri mi dhèu unu Na.” ");
INSERT INTO nfa_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Baca nare sasuri ne, ka Yesus lulu hari, hèia Na jꞌole asa ama dhu nèdꞌu kasasi, ka Na madhèdi. Dhèu aaꞌi-aaꞌi ètu dꞌara èmu sabajꞌa èèna ladhe patae Ne. ");
INSERT INTO nfa_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hèia Na peka dènge ra, “Dhu miu tadèngi nèti Sasuri Ama Lamatua deo na, neꞌe ne, jꞌajꞌi le!” ");
INSERT INTO nfa_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ka dhèu sèra mulai padhai lii padedha Yesus, aku rèngu na, “Waa! Ngaa dhu Na padhai lii deo na, beꞌa titu kèna! Te ngaa Nèngu ne Ana Yusuf, si? Tasamia ka Na bisa sèmi neꞌe ne?” ");
INSERT INTO nfa_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hèia Yesus lole dènge si, “Tatu miu tadèngi le lii dhu peka na, ‘Wee, dote! Puri uuru ku ngiꞌu èu!’ Miu neo pake lii èèna, ho kabèli hari sa Jaꞌa, peka na, ‘Nga tao ka Èu tao boe tadha malaa èci hia jiꞌi ètu neꞌe, sèmi dhu Èu tao le ètu kota Kapernaum nèi?’ ");
INSERT INTO nfa_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mamola na sèmi neꞌe: dhèu roꞌo boe sèmi rare dhèu rèti lii padhai Ama Lamatua nèti dꞌara rae unu na. ");
INSERT INTO nfa_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Tare conto nuka sèmi baki Elia, ca dhèu nèti lii padhai Ama Lamatua. Ca tèka, èjꞌi mai boe tèlu tèu catenga. Taa èèna, abhu bhèni balu ae ètu Israꞌel. Te ngaa Lamatua hia boe Elia ho soru-bara si ètu Israꞌel sèra. Lamatua dhoka pua laꞌe asa ca dhèu bhèni balu ètu rae Sarfat, dhu dètu dènge kota Sidon. Masi ka bhèni ne dhèu Yahudi boe, te ngaa na parcaya koasa Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tare hari conto leo nèti Elisa, dhèu nèti lii padhai Ama Lamatua. Taa èèna, dhèu Yahudi ae dhu lèke èi papèdꞌa kusta ètu Israꞌel. Te ngaa Lamatua paꞌèle boe si nèti papèdꞌa ra. Ama Lamatua dhoka pua Elisa laꞌe puri-paꞌèle dhèu kusta èci, ngara na Naaman, masi ka nèngu ne dhèu Siria, dhèu Yahudi boe. Te ngaa na parcaya koasa Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ropa ra tadèngi lii padhai lii Yesus ne, hèia aaꞌi-aaꞌi ra nasa titu kèna dènge Ne. ");
INSERT INTO nfa_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ka ra kèdꞌi aaꞌi-aaꞌi, ra babège eele Ne nèti dꞌara èmu sabajꞌa èèna. Hèia ra nuni rèti Ne asa karasa rae, ho neo tule Ne nèti dedha tèbhi ètu èèna, asa haha laꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Te ngaa Na kako asa liꞌu laꞌe re talora aae rèngu, ka tèke eele si ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Èle èèna ka, Yesus puru laꞌe asa kota Kapernaum ètu sebhe dano Galilea. Dꞌai lodꞌo-lodꞌo sabajꞌa, Na ajꞌa-nori dhèu ètu dꞌara èmu manèngi-mangajꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dhèu sèra malaa ladhe ra nanene lii padhai Na, te neꞌa mèu isi lii holo-nori sèra. ");
INSERT INTO nfa_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ca tèka, ropa Yesus ajꞌa-nori ètu dꞌara èmu manèngi-mangajꞌi, abhu ca dhèu dhu nidhu tao, na paꞌoo-parodha, peka na, ");
INSERT INTO nfa_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ee! Yesus, Dhèu Nasaret! Èu neo tao ngaa mi jiꞌi? Èu mai sèna ka palaho jiꞌi, do? Jiꞌi se tadhe Èu. Èu ne, Dhèu Mola, dhu uru èèna Ama Lamatua pajaji tèke ho hia mai.” ");
INSERT INTO nfa_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Te ngaa Yesus jèke ne, peka na, “Rèno laa! Hutu hèbꞌa èu na! Kalua ka nèti dhèu neꞌe!” Cagꞌagꞌa laa, nidhu dedꞌe kalabhe dhèu ne asa rai, ètu talora aae dhèu sèra. Ropa pabèbhe nare, hèia nidhu ne kalua tèke eele aa papèdꞌa boe isi dhèu ne hèi. ");
INSERT INTO nfa_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Dhèu aaꞌi-aaꞌi malaa-maloha, ka ra peka na, “Ira ii! Lii padhai Dhèu neꞌe, dènge koasa kapai bia! Toke nidhu madhutu paredha Na kahèi, ka kalua nèti dhèu!” ");
INSERT INTO nfa_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hèia lii lolo lula-nèti Yesus pale-lème rai èèna aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lodꞌo rèngu kalua nèti èmu sabajꞌa, Yesus laꞌe asa èmu dhèu èci, ngara na Simon. Lodꞌo èèna, teto na dhu pèdꞌa maringi-sagoro isi pana bia. Hèia ra manèngi Yesus, peka na, “Ama! Puri-paꞌèle ku bhèni heka ne, laa!” ");
INSERT INTO nfa_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ka Yesus laꞌe titu ètu sebhe koi, ka puri papèdꞌa bhèni heka ne. Cagꞌagꞌa laa, èi papèdꞌa na ele dènge ka. Hèia na kèdꞌi laꞌe lalau ngangaꞌa hia si raꞌa-rinu. ");
INSERT INTO nfa_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ètu dꞌara lodꞌo nihia èèna kahèi, ropa lodꞌo oe cèna, dhèu lere rèti dhèu pèdꞌa ae-ae mai asa Yesus. Èi papèdꞌa ra rupa-rupa. Hèia Na bane ai mi dhèu pèdꞌa seꞌe, ka aaꞌi-aaꞌi ra èle nèti papèdꞌa-tarègu ra. ");
INSERT INTO nfa_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nèti dhèu pèdꞌa se abhu kahèi dhu nidhu tao. Hèia Yesus paredha nidhu se, sèna ka kalua nèti dhèu sèra. Ra rai kalua dènge lii taraa, peka na, “Èu ne, Ana Ama Lamatua!” Te nidhu se reꞌa, na, Nèngu ne Kristus, dhu Ama Lamatua pajaji karèi nèti uru ka, ho hia mai. Nèti èèna ka, Yesus kai si sèna ka bisa boe ra padhai ca hèbꞌa sa, lula-nèti Nèngu. ");
INSERT INTO nfa_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Asa bèli dꞌara oe mèu sa, Yesus kèdꞌi, ka laꞌe asa era dhu kaliu èci ètu liꞌu kota. Hèia dhèu tenge Ne asa mia-mia. Ropa paraga dènge Ne, ka ra pamako Ne, aku rèngu na, “Ama pea ka dènge jiꞌi laa! Lamu iia ka asa era leo!” ");
INSERT INTO nfa_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Te ngaa Na dhaa, aku Nèngu na, “Jaꞌa hudꞌi laku asa rae-rae leo, ho peka-padhai Lii Lolo Beꞌa nèti paredha Ama Lamatua. Te Ama Lamatua pua Jaꞌa mai ne, sèna ka pakako sasabꞌa èèna.” ");
INSERT INTO nfa_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hèia Na kako nèti rae èci asa rae leo, ho ajꞌa-nori dhèu ètu dꞌara èmu-èmu sabajꞌa ètu propensi Yudea. ");
INSERT INTO nfa_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ca tèka, Yesus ajꞌa dhèu ètu sebhe dano Galilea. Dhèu ae mai sèna ka neo nanene Lii Holo-Nori Ama Lamatua. Rèngu mai toke ra kalibhu rare Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Padètu dènge era èèna, abhu dhèu dhu pamèu pèku ra ètu dedha nebhe. Ka Yesus nèdhi koha dua bua dhu panahu ètu era èèna. ");
INSERT INTO nfa_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Cue nèti koha se, unu Simon. Èle ka, Yesus caꞌe asa dedha koha ne, ka Na manèngi sèna ka Simon tobꞌe asa era marèma ciki. Hèia Na madhèdi ho ajꞌa dhèu ae sèra. ");
INSERT INTO nfa_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ajꞌa nare, hèia Na padhai lii dènge Simon, peka na, “Simon! Padedha hari ku asa dꞌara marèma, ho core pèku laꞌa. Te èèna na miu abhu iꞌa ae.” ");
INSERT INTO nfa_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ka Simon dhaa, peka na, “Te ngaa, Ama. Jiꞌi sabꞌa dꞌai madhe dꞌara camèdꞌa kateme kèna, te abhu boe ciꞌu sa hèi! Te ngaa lula Ama ku peka le sèmi èèna, jaꞌa madhutu! Jaꞌa papuru sèku.” ");
INSERT INTO nfa_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hèia ra papuru pèku. Ropa ra neo ère pacaꞌe hari, reꞌa boe na pèku ne dhu pènu dènge iꞌa, ka mulai mae. ");
INSERT INTO nfa_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hèia Simon rodhe angalai na ètu koha leo sèra, ho mai bara rèngu ère pèku. Ka ra daꞌu iꞌa tao asa dꞌara koha, toke koha dua bua se pènu dènge iꞌa, ka oe cène. ");
INSERT INTO nfa_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Angalai Simon se, nuka Yakobis dènge Yohanis, ana nèti Sabadeus, ètu era èèna kahèi. Rèngu se malaa, lula ra abhu iꞌa ae titu kèna. Ropa Simon Petrus ladhe nèdhi ngaa dhu jꞌajꞌi ne, hèia na patitu dènge ka, kètu urutuu na ètu madha Yesus, hèia na peka, “Jaꞌa ne, ca dhèu dhu ue le sasala ae-ae. De beꞌa risi, Lamatua padètu ia ka dènge jaꞌa.” Te ngaa Yesus dhaa, peka na, “Simon! Pangee ia ka jꞌara neꞌe, te Jaꞌa neo pake miu se. Miu tema le tenge iꞌa. Te ngaa deo neꞌe ne, Jaꞌa ajꞌa miu sèna ka tenge dhèu ho madhutu Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Èle ka, rèngu nuni dènge ka koha ra asa dedha nebhe. Ka lasi tèke eele ka ngaa-ngaa ra aaꞌi-aaꞌi, lasi madhutu Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ètu rae èci, Yesus paraga dènge ca dhèu dhu ngiꞌu na pènu dènge èi papèdꞌa kusta. Ropa dhèu ne nèdhi Yesus, ka laꞌe patitu kètu urutuu na, aa na pacudꞌu dꞌai rai. Hèia na lii, aku nèngu na, “Ama! Sue ku jaꞌa laa! Te jaꞌa keꞌa, na, Ama bisa puri-paꞌèle papèdꞌa jaꞌa ne, sèna ka dhèu madenge ia ka dènge jaꞌa. Sadꞌi Ama moꞌo.” ");
INSERT INTO nfa_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ka Yesus jꞌole kacui-aai Na ho gꞌagꞌe ne. Aa Na peka, “Jaꞌa koꞌo! Èu èle dènge kèna!” Ropa Na padhai lii nare, èi papèdꞌa dhèu ne èle dènge. ");
INSERT INTO nfa_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hèia Yesus pasanèdꞌe ne, peka na, “Baku bhèlu, ee! Èu èle le, te ngaa baku peka dènge dhèu èci sa! Èu hudꞌi madhutu uuru ku paredha baki Musa. De lamu asa ama agama, ho na parisa ngiꞌu èu, sèna ka neꞌa èi papèdꞌa ne èle tareꞌa, do dhae. Èle èèna na, èu hia mèdha èci sèmi tadha makasi, sèna ka dhèu aaꞌi-aaꞌi reꞌa, èu ne èle tareꞌa le nèti papèdꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Masi ka Yesus kai, te ngaa lii lolo nèti koasa Na, pale-lème nèti dhèu èci asa èci dꞌai mia-mia. Ka dhèu mai sèmi tao cèci sa, ho ra nanene Na ajꞌa-nori. Hèia Na puri-paꞌèle dhèu ae nèti rupa-rupa èi papèdꞌa ra. ");
INSERT INTO nfa_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Te ngaa catèka-catèka, Yesus dꞌèi kahèi patalele iisi, ho laꞌe manèngi-mangajꞌi asa era dhu kaliu. ");
INSERT INTO nfa_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ca lodꞌo, Yesus ajꞌa dhèu ètu dꞌara èmu cue. Lodꞌo èèna, abhu kahèi dhèu nèti partei agama Parisi, dènge pèri-pèri mese agama, mai ho nanene lii padhai Na. Dhèu se mai nèti rae-rae ètu propensi Galilea, propensi Yudea, dènge kota Yerusalem. Ama Lamatua hia Yesus koasa, sèna ka paꞌèle dhèu-dhèu pèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Lodꞌo èèna, dhèu pèri-pèri dedꞌe rèti dhèu karuku èci ètu dedha karadꞌa. Rèngu tenge-tenge jꞌara, sèna ka Yesus puri-paꞌèle ne. Te ngaa ètu dꞌara èmu ne, dhèu sèmi tao cacèci sa, ka rèngu bisa boe pasuki asa dꞌara. Nèti èèna ka, ra dedꞌe dhèu ne asa kolo èmu. Rare dedha, ka ra bèdi eele rèu èmu, sèna ka tao roꞌa, ho dulu dhèu karuku ne dènge karadꞌa kateme asa haha laꞌe. Ra dulu dhèu neꞌe asa talora aae dhèu ae-ae se, lèke mola-mola ètu madha Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ropa nèdhi sèmi èèna, hèia Yesus neꞌa, na, rèngu se parcaya, na, Nèngu bisa paꞌèle angalai ra nèti karuku na. Ka Na lii dènge dhèu karuku ne, aku Nèngu na, “Ana, ee! Jaꞌa saku pamèu le sasala èu.” ");
INSERT INTO nfa_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ropa tadèngi Yesus padhai lii sèmi èèna, ka dhèu Parisi dènge mese agama sèra, pakarèi, na, “Eeh! Dhoka Ama Lamatua dhu dènge hak di, ho saku eele sasala-sasigo dhèu. Cee ka Nèngu ne, ka Na tao iisi Na nuka sèmi Ama Lamatua! Neꞌe ne paꞌele iie kolongara Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Te ngaa Yesus dhu neꞌa dꞌai dꞌara rèngu. Hèia Na peka, “Nga tao ka miu se ngee, na, Jaꞌa ne padhai lii paꞌele iie kolongara Lamatua? ");
INSERT INTO nfa_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Jaꞌa ne Dhèu Rai-haha Tareꞌa-reꞌa. Aa Jaꞌa ne dènge hak kahèi, ho abho sasala-sasigo dhèu. Ladhe Jaꞌa lii dènge dhèu karuku ne, ‘Jaꞌa abho le sasala èu,’ miu mèdhi boe koasa Jaꞌa ètu rai-haha ne. Te ngaa ladhe Jaꞌa peka na, ‘Kèdꞌi ka! Dedꞌe karadꞌa èu, ho lèpa ka.’ Ladhe nèngu kèdꞌi dènge ka, na, miu heka mèdhi koasa Jaꞌa. Nèti èèna ka, Jaꞌa neo puri-paꞌèle dhèu karuku ne, sèna ka miu meꞌa, na, Jaꞌa dènge hak ho abho sasala-sasigo dhèu.” Ka Na piku asa dhèu karuku ne, aa lii, peka na, “Titu ka! Dedꞌe karadꞌa èu, ho lèpa ka!” ");
INSERT INTO nfa_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cagꞌagꞌa laa, dhèu ne kèdꞌi titu ètu madha dhèu ae sèra, ka kèpe nare karadꞌa na. Hèia na lèpa ka dènge koa-kio kolongara Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rèdhi sèmi èèna, ka dhèu aaꞌi-aaꞌi se malaa. Ka ra dedꞌe padedha-dedha kolongara Ama Lamatua, peka na, “Lamatua kapai risi eele! Deo neꞌe ne, èdhi tèdhi le dènge musi madha èdhi unu ti, tadha malaa dhu kapai!” ");
INSERT INTO nfa_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nèbhu boe ka Yesus kalua nèti dꞌara èmu, hèia ladhe nèdhi dhèu roro bea ca dhèu, dhu madhèdi ètu era roro doi bea. Ngara dhèu ne, Lewi. Ka Yesus peka dènge ne, “Mai ka madhutu Jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ropa tadèngi lii paroa ne, hèia Lewi kèdꞌi dènge ka, tèke eele aaꞌi-aaꞌi sèra, laꞌe madhutu Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Èle ka, Lewi tao tatao kapai ètu èmu na, ka na nèru Yesus. Aa na nèru kahèi angalai na dhèu roro bea sèra, dènge tamu-tamu dhu leo ho lasi raꞌa-rinu. ");
INSERT INTO nfa_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Te ngaa pèri-pèri dhèu nèti partei agama Parisi, dènge mese-mese agama, kaꞌuu-kamuki mi ana madhutu Yesus, aku rèngu na, “Tasamia ka miu miꞌa-minu paꞌèci dènge dhèu dhu laku boe, nuka dhèu roro bea, dènge dhèu karehe sèra? Dhèu beꞌa bisa boe paꞌèci dènge dhèu sèmi sèra sa!” ");
INSERT INTO nfa_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ka Yesus lii dènge rèngu, peka na, “Dhèu pèdꞌa parluu dote-matarii. Te ngaa dhu pèdꞌa boe, parluu boe. ");
INSERT INTO nfa_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mamai Jaꞌa ne, ho lalau-laloꞌo dhèu karehe sèra. Te ngaa Jaꞌa mai boe ho uri dhèu dhu ngee na, ngiꞌu ra mola le.” ");
INSERT INTO nfa_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hèia dhèu nèti partei agama Parisi dènge mese-mese agama kaꞌugu mi Yesus, peka na, “Sèmi neꞌe, Ama! Ana madhutu Yohanis tuka sarani dhèu, rèngu tema puasa dènge sabajꞌa. Ana-ana madhutu dhèu Parisi sèmi èèna kahèi. Te ngaa tasamia ka, ana madhutu Ama sèra, loe boe dènge raꞌa-rinu? Rèngu se reꞌa boe puasa, do?” ");
INSERT INTO nfa_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ka Na dhaa pake lii pakasame, aku Nèngu na, “Miu meꞌa le, ladhe dhèu tao pesta kabꞌi, dhèu-dhèu dhu ra nèru sèra, bisa boe puasa, te ngaa raꞌa toke bècu. Ladhe mone dhu kabꞌi èèna, dènge rèngu era, tatu rèngu raꞌa palere aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Te ngaa ropa dhèu leo rai rèti mone dhu kabꞌi ne, hèia angalai na susa, heka ra puasa kèna.” ");
INSERT INTO nfa_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hèia Yesus padhai lii pakasame èci hari, peka na, “Abhu mèka dhèu dhu rare bèla hiu caꞌèta, ho kalape mi kodho dhui dhu mae. Te ladhe base kodho ne, bèla hiu dhu kalape laꞌa èèna karuku, na kodho ne asa mae aae. ");
INSERT INTO nfa_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Sèmi èèna kahèi, dhua dhu heka rèti nèti kapua, dhèu bhori boe asa sabha dhui. Te aadꞌo na, sabha madhore eele, aa dhua èèna soli soo-soo asa rai laꞌe. De dhua dhu hiu, hudꞌi bhori ku asa dꞌara sabha hiu. Sèmi èèna ka, Yesus ajꞌa si, peka na, lii ajꞌa Na dhu hiu bisa boe pabꞌali dènge lii ajꞌa dhu dhui nèti dhèu Parisi. ");
INSERT INTO nfa_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Dhèu dhu rinu rèdhi le èi anggor dhui, dꞌèi boe rinu dhu hiu. Te dhu reꞌa na, ‘Èi anggor dhu kee risi nuka èi anggor dhui!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ca tèka, lèke dènge lodꞌo aꞌae sasabꞌa dhèu Yahudi, Yesus dènge ana madhutu Na, kako re jꞌara ètu sebhe oka dhèu. Ka ana madhutu Na puru are-gandum dhu ètu madha rèngu sèra. Hèia ra sarodꞌe dꞌara kacui-aai, ka raꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ètu era èèna, abhu pèri-pèri dhèu nèti partei agama Parisi dhu kèpe paꞌèra adꞌa Yahudi ra. Ropa ladhe rèdhi ana madhutu Yesus tao sèmi èèna, ka ra kai Ne, peka na, “Tasamia ka ana-ana Èu se sisu atora agama èdhi? Rèngu sabꞌa lèke dènge lodꞌo aꞌae sasabꞌa! Ladhe ku laa! Rèngu puru are-gandum nèi. Baku tao sèmi èèna!” ");
INSERT INTO nfa_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Te ngaa Yesus bꞌala, peka na, “Tasamia, ee? Miu sanèdꞌe lii lolo baki Daud? Daud dènge dhèu madhutu na lula manganga ae, ka maso lasi asa dꞌara Paleo Manèngi-Mangajꞌi Ama Lamatua. Hèia raꞌe roti dhu ama agama hia le Lamatua. Te ngaa roti seꞌe dhodhoka ama agama di dhu bisa raꞌe. Dhèu leo bisa boe. Ka baki Daud si raꞌe, te ngaa ca dhèu sa peka boe, na, rèngu sale. Miu se, sèmi baca mèdhi boe Sasuri Mola-Mèci Ama Lamatua! ");
INSERT INTO nfa_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pasa dhilu ho nanene paie-iie! Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Jaꞌa dènge hak ho pamaꞌète, na, dhèu bisa sabꞌa ngaa, lèke dènge lodꞌo aꞌae sasabꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ca tèka, lèke dènge lodꞌo aꞌae sasabꞌa dhu leo, Yesus laꞌe ajꞌa ètu dꞌara èmu manèngi-mangajꞌi. Ètu era èèna, abhu dhèu mone èci, dhu ai madhe cabèka. ");
INSERT INTO nfa_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ètu èèna, abhu kahèi pèri-pèri mese agama, dènge dhèu nèti partei agama Parisi, dhu tenge jꞌara ho pamanahu Yesus. Ra tatae, tao-tao Na neo puri-paꞌèle dhèu dhu ai madhe cabèka ne, lèke dènge lodꞌo aꞌae sasabꞌa. Dènge jꞌara neꞌe, rèngu bisa abhu jꞌara ho galaa Ne ètu madha dhèu ae. ");
INSERT INTO nfa_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Te ngaa Yesus neꞌa ngangee rèngu. Nèti èèna ka, Na paroa dhèu dhu ai madhe cabèka ne, aku Nèngu na, “Angalai! Mai ku. Titu ètu talora aae ne!” Hèia laꞌe titu dènge ka ètu talora èèna. ");
INSERT INTO nfa_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ka Yesus karèi dhèu-dhèu ètu sèra, peka na, “Jaꞌa karèi ku miu laa. Madhutu atora agama èdhi, ngaa dhu èdhi bisa tao ètu lodꞌo aꞌae sasabꞌa? Èdhi tao dhu beꞌa, do, tao dhu karehe? Hia mamuri mi dhèu, do, paꞌele iie mamuri na?” ");
INSERT INTO nfa_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hèia Yesus ladhe palème rèngu aaꞌi-aaꞌi ra, ka Na lii dènge dhèu dhu ai madhe cabèka ne, peka na, “Jꞌole ai èu mai!” Ka na soro ai na, hèia èle dènge ka. ");
INSERT INTO nfa_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ropa rèdhi sèmi èèna, ka dhèu kapai se nasa titu kèna. Hèia ra peka, na, “Èdhi tenge hari ku jꞌara leo, sèna ka pamanahu Ne!” ");
INSERT INTO nfa_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nèbhu boe ka, Yesus laꞌe sabajꞌa asa ledhe èci. Na sabajꞌa ètu èèna camèdꞌa kateme. ");
INSERT INTO nfa_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Asa bèli madꞌae, Yesus paroa ana madhutu Na. Ka nèti rèngu aaꞌi-aaꞌi ra, hagꞌe nare canguru dua dhèu ho jꞌajꞌi dhèu pajuu-paleha Na. Dhèu dhu hagꞌe nare sèra, nuka: ");
INSERT INTO nfa_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (dhu Yesus pangare ne, ‘Petrus’) Anderias (ari Simon), Yakobis, Yohanis (ari Yakobis), Pelipus, Bertolomeos, ");
INSERT INTO nfa_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateos, Tomas, Yakobis (ana Alpius), Simon (nèti partei politik Selot), ");
INSERT INTO nfa_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (ana Yakobis), aa Yudas Iskariot (dhu èèna na pahia Yesus). ");
INSERT INTO nfa_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ropa puru mai nèti ledhe deo na, Yesus dènge ana madhutu Na, ae taha ètu era mera èci. Ètu èèna, abhu dhèu ae dhu pakaboko. Dhèu se mai nèti propensi Yudea, nèti kota Yerusalem, aa nèti Tirus dènge Sidon, nuka dua kota ètu sebhe dhasi. ");
INSERT INTO nfa_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Rèngu mai ho nanene lii padhai Yesus, aa abhu kahèi dhu neo manèngi sèna ka Na puri-paꞌèle dhèu pèdꞌa. Ka Yesus paꞌèle si. Na paꞌèle kahèi dhèu dhu nidhu tao, dènge magèle eele nidhu nèti dhèu sèra. ");
INSERT INTO nfa_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dhèu ae dhu neo goi Ne. Te ropa goi lèke Ne, dhèu se èle dènge nèti papèdꞌa ra, lula abhu koasa dhu kalua nèti Nèngu. ");
INSERT INTO nfa_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Èle ka Yesus kabibꞌa asa ana madhutu Na, hèia Na ajꞌa si, aku Nèngu na, “Dhèu unu aadꞌo sèra! Miu abhu aꞌoto, lula Ama Lamatua mesa Na, jꞌajꞌi Dhèu Aae miu dhu beꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Dhèu dhu kabake manganga sèra! Miu abhu aꞌoto, lula Lamatua ka dhu hia miu bècu-manèsa. Dhèu dhu tangi dènge dꞌara susa sèra! Miu abhu aꞌoto, lula èèna na dꞌara mi karejꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Ka dhèu dhu abhu susa lula madhutu Jaꞌa, miu abhu aꞌoto, lula èèna na Lamatua bꞌala rui-jꞌajꞌèra miu ètu sorga. Masi ka dhèu tèka dꞌara dènge miu, do pakarehe kolongara miu, do jꞌèli marèu miu, do bata eele miu, tao sèmi dhèu bhelu sa, miu abhu aꞌoto, lula èèna na Lamatua bhèlu boe miu ètu sorga. De ladhe dhèu pajꞌèra miu sèmi èèna, pakarejꞌe laa dꞌara miu! Aa karae laa dènge pasoa-pasoka! Mage malaa kahèi, lula dhèu dhu pajꞌèra miu limuri ne, bèi-baki ra dhu uru èèna, pajꞌèra le dhèu rèti lii padhai Lamatua sèra kahèi. De ladhe miu paraga dènge jꞌajꞌèra sèmi sèra, pakarejꞌe laa dꞌara miu, lula èèna na Lamatua bꞌala hia miu ae-ae ètu sorga! ");
INSERT INTO nfa_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Te ngaa dhèu kaja! Miu abhu mamadhe-mamopo, lula mamuri karejꞌe miu, dhoka dꞌai neꞌe di. ");
INSERT INTO nfa_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Dhèu dhu bècu-manèsa! Miu abhu mamadhe-mamopo, lula hèru manganga madèu dhu seli eele, mai salake nare miu. Dhèu dhu kea rae-rae sèra! Miu abhu mamadhe-mamopo, lula jꞌajꞌèra mai, tao miu tangi ngobꞌi-ngobꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Dhèu dhu dꞌèi dhèu koa-kadꞌiri! Miu abhu mamadhe-mamopo, lula uru sèra bèi-baki miu dꞌèi padꞌiri kahèi dhèu-dhèu dhu rèti lii leko-monya sèra!” ");
INSERT INTO nfa_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Hèia Yesus tuhu hari lii padhai Na, “Pasa dhilu ho nanene paie-iie! Èu hudꞌi sue ku musu èu, aa tao pabeꞌa laa mi dhèu dhu tèka dꞌara dènge èu. ");
INSERT INTO nfa_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sabajꞌa ho manèngi Ama Lamatua, sèna ka hia babeꞌa mi dhèu dhu dhoo èu. Aa manèngi sèna ka Lamatua hia mèngi-nale mi dhèu dhu pajꞌèra èu rupa-rupa. ");
INSERT INTO nfa_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ladhe dhèu tèbꞌe ripi èu cabèka, soro hari ripi cabèka ho na tèbꞌe. Ladhe dhèu parame rare kodho pana èu, na, hia hari laa kodho èu dhu leo. ");
INSERT INTO nfa_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ladhe dhèu manèngi mèdha èu èci, hia laa. Aa ladhe dhèu dedꞌe rèti mèdha èu èci, soro tèke sène. Mage mu manèngi hari! ");
INSERT INTO nfa_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Èu hudꞌi tao ku dhèu leo, nuka sèmi èu neo dhèu tao mi ngiꞌu èu. ");
INSERT INTO nfa_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Èu dꞌèi padꞌelo sasue mi dhèu èu mesa mu. Èèna beꞌa. Te ngaa kolo-karisi na ngaa? Te dhèu bhelu sue dhèu rèngu kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ladhe èu pabeꞌa dhoka dènge dhèu dhu beꞌa dènge èu di, kolo-karisi ètu mia? Te dhèu bhelu sèra, reꞌa bꞌala babeꞌa dhèu sèmi èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ladhe èu dhodhoka hia pija mi dhèu dhu bisa pula hari doi èu, kolo-karisi na ngaa? Te dhèu bhelu kahèi reꞌa hia dhèu leo pija doi, sadꞌi bèli-camèdꞌa sèmi aaꞌi hari dhu kateme iisi. ");
INSERT INTO nfa_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Te ngaa dhu lèke ka, sèmi neꞌe: sue la musu èu sèra! Aa tao la beꞌa mi rèngu. Ngaa dhu ra parluu, hia si pija. Baku pangee, na, ra pula hari do aadꞌo. Dènge jꞌara ne, èèna na Ama Lamatua bꞌala èu. Pe èu jꞌajꞌi ana nèti Ama Lamatua dhu Dedha Risi Eele. Lula mamuri èu sama sèmi Ama mu, dhu dꞌèi adꞌu-ue jꞌara hua iia hia dhèu bhelu. Nèngu dꞌèi kahèi tao jꞌara hua iia hia dhèu dhu reꞌa boe manèngi makasi. ");
INSERT INTO nfa_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","De èu hudꞌi padꞌelo ku kasia mi dhèu, nuka sèmi Ama mu ètu sorga dhu padꞌelo kasia Na mi èu.” ");
INSERT INTO nfa_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ka Yesus tuhu hari lii ajꞌa Na, peka na, “Baku lee dhèu, sèna ka dhèu baku lee hari èu. Baku kahèti leli lii padhai dhèu, te aadꞌo na dhèu tao hari èu sèmi èèna kahèi. Pabhèlu eele sasala dhèu, sèna ka rèngu baku nui sasala èu. ");
INSERT INTO nfa_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ladhe èu hia dhèu ngaa dhu ra parluu, pe èu abhu hari. Te bèli-camèdꞌa ra hia hari èu pènu ai. Èèna, nuka sèmi dhèu isi kabꞌui asa dꞌara balee aꞌuku, ka ra karèko ne, aa cèci ne, toke bua lale eele. Dhu èu abhu, sama èci èèna ka. Ladhe èu hia ciki, èu abhu hari ciki kahèi. Te ngaa ladhe èu hia ae, èu abhu hari ae-ae.” ");
INSERT INTO nfa_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus ajꞌa pake lii upama kahèi. Na lole, peka na, “Dhèu bèdhu bisa boe padꞌelo jꞌara hia dhèu bèdhu dhu leo. Te aadꞌo na, dua ra manahu asa dꞌara roꞌa lasi! ");
INSERT INTO nfa_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ana sakola bisa boe mèu risi nèti mese na! Te ngaa ladhe na madhutu dènge beꞌa lii aꞌajꞌa mese na, nèngu bisa jꞌajꞌi sama sèmi mese na. ");
INSERT INTO nfa_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Èu paꞌèki more sasala dhèu, masi ka ana iiki-iiki èèna ka. Te ngaa sasala èu dhu kapai, èu sèmi pameꞌa boe sa. Èèna, nuka sèmi èu mèdhi ahu ca katèdꞌa ètu musi madha dhèu. Masi ka agarii aae dhu paꞌabhe nare musi madha èu, te ngaa èu oe sèmi pameꞌa boe sa! ");
INSERT INTO nfa_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tasamia ka èu bani peka dènge angalai mu, na, ‘Mai, ho jaꞌa tiu eele ahu nèti dꞌara madha èu.’ Te ngaa èu mesa mu bisa boe ladhe mèdhi ngaa-ngaa, te agarii dhu paꞌabhe nare musi madha èu! Weeh! Èu ne, mema dhèu kapodꞌe-kabèli! Tao eele uru ku agarii nèti dꞌara madha èu, heka èu ladhe mèdhi, ho tiu eele ahu ca katèdꞌa èèna, nèti dꞌara madha angalai mu.” ");
INSERT INTO nfa_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ka Yesus tabha lii pakasame èci hari, peka na, “Abhu ètu mia, ajꞌu beꞌa, ladhe dꞌai lodꞌo hua, hua na karehe. Aa abhu boe ladhe ajꞌu karehe na hua, hua na beꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Dhèu bisa tadhe ladhe ajꞌu ca kapua, beꞌa do aadꞌo, mai nèti hua na. Dhèu aaꞌi-aaꞌi reꞌa, peka na, ètu mia dhèu puu lolobhangi, do, hua anggor nèti ajꞌu padhudhu. ");
INSERT INTO nfa_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sèmi èèna kahèi dènge dhèu dhu dꞌara mola-mèci, neꞌa tao jꞌara-jꞌara dhu beꞌa. Te ngaa dhèu dhu dꞌara kajꞌalu, tao jꞌara-jꞌara dhu bhelu-katubꞌa. Te nèti lii padhai na, èdhi bisa tadhe babeꞌa-karehe dhèu.” ");
INSERT INTO nfa_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hèia Yesus tuhu lii padhai Na, aku Nèngu na, “Miu se loe boe paroa Jaꞌa, na, ‘Lamatua’. Te ngaa tasamia ka miu moꞌo boe tao madhutu lii padhai Jaꞌa? ");
INSERT INTO nfa_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dhèu dhu mai nanene lii padhai Jaꞌa, ho na tao madhutu, nèngu ne èci èèna ka ");
INSERT INTO nfa_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","dènge dhèu dhu neo patitu èmu dhu èra. Na kèi roꞌa fanderen toke abhu hadhu. Hèia na padhèdi fanderen, heka na patitu èmu kèna. Ladhe èi aae lala, èmu ne gagedꞌo boe sa hèi, lula era padhèdi na èra. ");
INSERT INTO nfa_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Te ngaa dhèu nanene dènge dꞌara kajari, aa madhutu boe lii padhai Jaꞌa, nèngu ne èci èèna ka dènge dhèu dhu neo patitu èmu sadꞌi jꞌajꞌi di. Na tao boe fanderen, te ngaa na patitu èmu na ètu dedha rai ètu sebhe loko. Hèia ropa èi aae lala, èmu na guri laho mae-mae!” ");
INSERT INTO nfa_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ropa ajꞌa nare, ka Yesus lèpa asa kota Kapernaum. ");
INSERT INTO nfa_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ca dhèu komedhaa sordadꞌu Roma pea ètu neꞌe. Abhu dhèu sabꞌa na èci dhu nèngu parcaya. Dhèu sabꞌa ne dhu pèdꞌa oe madhe. ");
INSERT INTO nfa_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lodꞌo èèna, komedhaa tadèngi le tatao Yesus, hèia na pua dhèu heka Yahudi pèri-pèri lasi manèngi Yesus mai puri dhèu sabꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dꞌai nèi, ra pamako Yesus, sèna ka Na laꞌe palere dènge rèngu. Ra manèngi, peka na, “Dhèu Roma ne, dhèu beꞌa! Ama hudꞌi tolong ne. ");
INSERT INTO nfa_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Te nèngu ka patitu èmu sabajꞌa cue hia jiꞌi, lula na sue èdhi dhèu Yahudi.” ");
INSERT INTO nfa_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ka Yesus madhutu dènge si. Rèngu dhae rare mèka èmu, te ngaa komedhaa ne pua le angalai na laꞌe peka dènge Yesus, na, “Ama roca ia ka mai asa dꞌara èmu jaꞌa, te jaꞌa nia boe sèmi Ama asa dꞌara èmu jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Aa jaꞌa nia boe kahèi ara dhiu asa katanga madha Ama. Jaꞌa keꞌa Ama dènge koasa. De sadꞌi Ama padhai lii nèti èèna, tatu dhèu sabꞌa jaꞌa ne èle dènge nèti papèdꞌa na. Jaꞌa keꞌa jꞌara neꞌe ne, lula jaꞌa dènge dhèu paredha dedha kahèi, dhu dènge koasa ho paredha jaꞌa. Aa jaꞌa dènge koasa kahèi ho paredha sordadꞌu jaꞌa. Ladhe jaꞌa hia paredha mi sordadꞌu jaꞌa, peka na, ‘Lamu sa nèi!’ tatu laꞌe dènge. Aa ladhe jaꞌa peka, na, ‘Mai sa neꞌe’ tatu na mai. Aa ladhe jaꞌa pua dhèu sabꞌa jaꞌa, ‘Sabꞌa neꞌe’ tatu na sabꞌa madhutu kahèi. De sadꞌi Ama padhai lii di, dhèu sabꞌa jaꞌa ne, èle dènge.” ");
INSERT INTO nfa_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ropa tadèngi sèmi èèna, Yesus malaa. Ka Na kabibꞌa sa dhèu ae dhu madhutu Na sèra, hèia Na peka, “Nia kahèi nga! Nèbhu nare sange neꞌe, Jaꞌa paraga kèdhi mèka dènge dhèu Yahudi dhu lèka èra sama sèmi dhèu Roma ne!” ");
INSERT INTO nfa_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","De Yesus dꞌai dhoka era èèna di. Hèia angalai komedhaa se lèpa. Ropa dꞌai èmu komedhaa, ladhe na, dhèu sabꞌa ne èle le nèti papèdꞌa na. ");
INSERT INTO nfa_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Asa bèli èèna, Yesus dènge ana madhutu Na, pakèdꞌi lasi asa rae èci, ngara na Nain. Dhèu ae kako palere dènge Ne. ");
INSERT INTO nfa_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ropa rèngu oe dètu dènge hèbꞌa tedhe maso asa rae ne, ra paraga dènge dhèu ca nau lasi padhane dhèu madhe. Dhèu madhe ne, ana mone mesa nèti ca dhèu bhèni balu. ");
INSERT INTO nfa_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ropa Yesus nèdhi bhèni balu ne, ka dꞌara Na roe. Hèia Na lii dènge bhèni ne, aku Nèngu na, “Ina! Tangi ia ka!” ");
INSERT INTO nfa_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hèia Yesus laꞌe padètu-dètu, ka Na gꞌagꞌe karadꞌa dhèu madhe ne. Ka dhèu dhu pasae karadꞌa ne titu taha. Hèia Yesus lii dènge dhèu madhe, aku Nèngu na, “Ana! Kèdꞌi ka!” ");
INSERT INTO nfa_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ka ana ne mamuri hari, hèia na kèdꞌi madhèdi. Èle èèna ka, na padhai lii dènge dhèu ae dhu titu reo rare ne. Aa Yesus peka dènge bhèni balu ne, aku Nèngu na, “Ina! Ana mu ka neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dhèu aaꞌi-aaꞌi ètu sèra madhaꞌu titu kèna! Ka ra koa-kio Ama Lamatua, peka na, “Ama Lamatua pua le ca dhèu Na dhu kapai risi, dhu nèti lii padhai Na hia èdhi!” Abhu hari dhu leo, peka na, “Ama Lamatua mai le ètu talora aae èdhi, ho padꞌelo dꞌara hua iia Na!” ");
INSERT INTO nfa_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hèia lii lolo ne, ra palolo dꞌai mia-mia ètu propensi Yudea dènge era leo kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Ana madhutu Yohanis tadèngi aaꞌi le ngaa-ngaa dhu Yesus adꞌu-ue. Ka lasi lole dènge Yohanis ètu dꞌara bèdho. Hèia na pua dhèu dua lasi, ho karèi Ne, peka na, “Ama ne tareꞌa-reꞌa Kristus dhu jiꞌi mate tae-tae, do? Do, jiꞌi mate hari ku dhèu leo?” Èle ka ra paraga dènge Yesus, ka ra karèi sèmi èèna ka. ");
INSERT INTO nfa_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lodꞌo ana madhutu Yohanis se ètu èèna, Yesus puri-paꞌèle dhèu ae nèti papèdꞌa ra. Na bata eele nidhu nèti dhèu. Aa Na paꞌèle dhèu bèdhu, ka rèdhi hari. ");
INSERT INTO nfa_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ka Yesus peka dènge ra, “Lèpa ka ho mi peka dènge aꞌa Ku Yohanis, aaꞌi-aaꞌi dhu miu tadèngi dènge mèdhi unu mi, sèmi dhu dhèu nèti lii padhai Ama Lamatua, ngara na Yesaya, suri tèke, ‘Dhèu bèdhu rèdhi hari. Dhèu karuku, kèdꞌi ho kako hari. Dhèu pèdꞌa kusta, isi ra milu hari. Dhèu katele-katipa, tadèngi hari. Dhèu madhe, mamuri hari. Dhèu dhu dènge boe unu, nanene Lii Lolo Beꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Lami ho peka kahèi dènge aꞌa Ku Yohanis, na, ‘Dhèu dhu makae boe sèmi rare Jaꞌa, rèngu abhu aꞌoto.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ropa ana madhutu Yohanis se lèpa, hèia Yesus peka dènge dhèu ae sèra lula-nèti Yohanis, na, “Lodꞌo miu lami tenge Yohanis ètu dꞌara padꞌa sodꞌa èèna, miu pangee, na, paraga dènge dhèu dhu lalole na sèmi ngaa? Tatu miu lami boe ho paraga dènge dhèu dhu roe aai-roe èèla, nuka sèmi kalai èèu dhu bhabheu madhutu lai ngèlu di! ");
INSERT INTO nfa_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tatu lami boe ho ladhe dhèu dhu pake mèdha-papake dhu kabꞌua aae, te dhèu sèmi èèna, era pea na dhodhoka ètu dꞌara èmu dhèu aae di! ");
INSERT INTO nfa_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","De miu lami tenge dhèu cee ètu nèi? Miu pangee na lami tenge dhèu nèti lii padhai Ama Lamatua, do? Tareꞌa! Te nèngu risi nèti ca dhèu nèti padhai lii Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Te ètu dꞌara Sasuri Mola-Mèci dhu suri tèke le, na, ‘Nanene! Jaꞌa pua dhèu Jaꞌa, sèna ka bhoke jꞌara hia Èu.’ ");
INSERT INTO nfa_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ètu rai-haha ne, abhu boe ca dhèu sa dhu kapai risi nèti Yohanis. Te ngaa dhèu dhu ana iiki-iiki ètu talora aae dhèu unu Ama Lamatua, kapai risi nèti Yohanis.” ");
INSERT INTO nfa_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dhèu dhu tadèngi lii padhai Yesus, rèngu reꞌa le, peka na, jꞌara Lamatua èèna, jꞌara mamuri dhu lèke. Sèmi èèna kahèi dènge dhèu roro bea sèra. Lula rèngu uru èèna abhu sarani aa nanene kahèi lii ajꞌa-nori nèti Yohanis. ");
INSERT INTO nfa_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Te ngaa dhèu nèti partei agama Parisi dènge dhèu dꞌèlu-mèu atora agama Yahudi sèra, roꞌo boe madhutu dadꞌèi Ama Lamatua. Nèti èèna ka, ra manèngi boe Yohanis sarani si. ");
INSERT INTO nfa_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hèia Yesus karèi dhèu seꞌe, aku Nèngu na, “Jaꞌa pakasame dhèu-dhèu taa limuri seꞌe dènge ngaa? Dhèu sèmi ngaa ka see? ");
INSERT INTO nfa_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rèngu se, èci èèna ka dènge ana-ana dhu madhèdi ètu dꞌara pasa. Ra reꞌa dhoka paꞌoo-parodha dènge kaꞌuu-kamuki, peka na, ‘Jiꞌi aaꞌi-aaꞌi mi tiu sakino, te ngaa miu roge boe dènge karejꞌe. Aa jiꞌi sodꞌa lii beke dhèu madhe, te ngaa miu tangi boe.’ ");
INSERT INTO nfa_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Te, Yohanis tuka sarani ninu boe èi anggor, aa na dꞌèi puasa, miu kaꞌuu-kamuki, peka na, ‘Nèngu ne nidhu tao!’ ");
INSERT INTO nfa_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Te ngaa limuri ne, Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, tema kinu èi anggor dènge kuꞌa roti. Ka miu kaꞌuu-kamuki, peka na, ‘Dhèu ne, dhèu gagoo-gagehu! Aa tema mahu! Paꞌangalai dènge dhèu roro bea! Aa partei èci dènge dhèu dhu laku-laku boe! Dhu neꞌa heka ngiꞌu na!’ ");
INSERT INTO nfa_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Te ngaa mi patadhe lii Jaꞌa ne! Dhèu dhu reꞌa mèu, tatu rèngu madhutu dadꞌèi Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ètu dꞌara kota ne, abhu dhèu Parisi ca dhèu, ngara na Simon. Ca lodꞌo, na nèru Yesus si mai raꞌa asa èmu nèngu. Hèia Yesus si lasi madhèdi, ka neo raꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lodꞌo èèna, bhèni kajeo ca dhèu tadèngi kahèi, na, Yesus si neo raꞌa-rinu ètu èèna. Ka na maso laꞌe, nèdꞌu dènge èi hèu mèngi ca boto dhu kabꞌua aae. ");
INSERT INTO nfa_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na mai padètu dènge Yesus re kabodho Na. Hèia na patitu kètu urutuu na ètu haga Yesus. Na tangi dꞌara pèdꞌa dènge roma iisi, toke èi madha na hae lèke haga Yesus. Ka na seka haga Yesus pake rèu kètu na, aa na loe boe uu haga Yesus kahèi. Èle ka, na pasuti èi hèu mèngi èèna mi haga Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon neꞌa mèu jꞌara mamuri bhèni ne. Nèti èèna ka, na pajiko ètu dꞌara na, “Neꞌe jꞌajꞌi mi tadha, na, Yesus ne, dhèu dhu nèti boe lii padhai Ama Lamatua! Ladhe tareꞌa-reꞌa Ama Lamatua ka dhu pua Ne mai, tatu Nèngu neꞌa, na, bhèni dhu gꞌagꞌe Nèngu ne, bhèni kajeo. Dhèu rèti lii padhai Ama Lamatua, sèmi boe Nèngu ne, lula dhèu mola-mèci bisa boe padètu dènge dhèu kajꞌalu!” ");
INSERT INTO nfa_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Te ngaa Yesus neꞌa ngaa dhu Simon ngee. Ka Na peka, aku Nèngu na, “Simon! Sèmi neꞌe. Jaꞌa neo peka dènge èu ca jꞌara.” Hèia Simon dhaa, aku nèngu na, “Ama Mese, peka laa.” ");
INSERT INTO nfa_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ka Yesus core lii, peka na, “Abhu ca dhèu dhu tema hia dhèu pija doi na. Uru èèna, na hia nèdhi dhèu dua pija doi na. Dhèu èci, abhu lèmi ngasu doi iia, aa ca dhèu hari lèmi nguru di. ");
INSERT INTO nfa_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Te ngaa dꞌai lodꞌo pula doi seꞌe, dua ra bisa boe bꞌae rare. Ka dhèu dhu hia pija, rasa kasia mi rèngu dua ra. Nèti èèna ka, na peka mi dua ra, sèna ka bꞌae ia ka kèlu ra sèra. De madhutu èu, nèti dhèu dua se, cee ka dhu sue risi dhèu tema hia dhèu pija doi ne?” ");
INSERT INTO nfa_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ètu dꞌara ciki ooꞌe na kahèi, Simon dhaa, peka na, “Tatu dhèu dhu kèlu na ae risi!” Ka Yesus dhaa, na, “Mema tareꞌa!” ");
INSERT INTO nfa_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ka Yesus ladhe bhèni ne, hèia Na peka dènge Simon, aku Nèngu na, “Èu ladhe sèku bhèni ne. Deo na Jaꞌa maso asa dꞌara èmu èu, èu tèke boe èi sèna ka rase haga Jaꞌa, madhutu adꞌa èdhi. Te ngaa bhèni ne pabasa haga Jaꞌa dènge èi madha na, ka na seka pake rèu kètu na. ");
INSERT INTO nfa_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aa ropa èu soru Jaꞌa maso asa dꞌara èmu èu, èu uu boe Jaꞌa, madhutu adꞌa èdhi. Te ngaa karèi nèti Jaꞌa ètu dꞌara èmu èu, bhèni ne loe boe uu haga Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Èu bhèlu eele adꞌa dhu palona èi hèu mèngi mi kètu tamu, ropa Jaꞌa mai deo na. Te ngaa bhèni ne bhori le èi hèu mèngi dhu kabꞌua titu kèna mi haga Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Èu nanene paie! Sasala bhèni ne, mema ae. Te ngaa Lamatua saku eele aaꞌi le, lula na padꞌelo le sasue na dènge manèngi makasi ae-ae mi Jaꞌa. Te ngaa bagi dhèu dhu rasa na tao boe sasala ae, nèngu ngee na parluu boe abhu abho ae kahèi. Nèti èèna ka, nèngu neꞌa boe sue aa neꞌa boe manèngi makasi mi Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hèia Yesus lii dènge bhèni ne, peka na, “Jaꞌa saku eele le sasala èu aaꞌi-aaꞌi ra!” ");
INSERT INTO nfa_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dhèu aaꞌi-aaꞌi dhu madhèdi raꞌa palere-lere, pakaꞌuu, aku rèngu na, “Huuh! Na ngee na, Nèngu ne cee?! Na bani titu kèna saku eele sasala-sasigo dhèu! Jꞌara neꞌe ne dhodhoka Ama Lamatua mesa Na, dhu dènge hak ho saku eele sasala dhèu!” ");
INSERT INTO nfa_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Te ngaa Yesus peka dènge bhèni ne, aku Nèngu na, “Lula èu lèka le Jaꞌa, nèti èèna ka Lamatua hia le èu mamuri. Lèpa ka dènge mera-milu!” ");
INSERT INTO nfa_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nèbhu boe ka Yesus dènge ana madhutu Na, dhèu canguru dua sèra, kako palème kota-kota dènge rae-rae ètu sèra. Laꞌe lolo dènge dhèu dadꞌèi Ama Lamatua. Èèna ka dhu jꞌajꞌi lii lolo beꞌa hia rèngu aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ètu dꞌara kaboko rèngu, abhu kahèi pèri-pèri dhèu bhèni dhu madhutu. Bhèni se dhu uru èèna abhu rupa-rupa papèdꞌa, aa cahagꞌe dhu nidhu tao. Te ngaa Yesus ka dhu puri-paꞌèle aaꞌi si. Nuka sèmi Maria nèti rae Magdala, dhu uru èèna, Yesus bata eele pidhu nidhu nèti nèngu. ");
INSERT INTO nfa_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Abhu kahèi Susana, dènge mama Yohana. Yohana ne, dhèu èmu Kusa. Kusa ne, kapala urusan nèti èmu dhèu aae Herodes. Aa abhu ae kahèi bhèni leo dhu lasi palere-lere dènge Yesus si. Bhèni se pake doi-dhari rèngu mesa ra ho ogo Yesus si ètu jꞌara. ");
INSERT INTO nfa_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ca tèka, dhèu mai nèti rae-rae ho tenge Yesus. Ropa dhèu ae se pakaboko, hèia Na lolo dènge ra pake lii pakasame èci, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Abhu ca dhèu sabꞌa oka-tedhe, dhu laꞌe cebꞌe hini asa dꞌara oka na. Hini se cahagꞌe lèke ètu jꞌara. Ropa dhèu kako re èèna, jꞌèli lèke hini se. Aa manu-bhui mai ka tutu raꞌe aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hini cahagꞌe, lèke ètu dedha rai dhu pènu dènge hadhu. Hini se muri, te ngaa nèbhu boe hèia kamale dhae-dhae, lula èi kura. ");
INSERT INTO nfa_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hini cahagꞌe hari lèke ètu era ajꞌu padhudhu. Te ngaa ropa hini muri, ajꞌu padhudhu hèlu pamadhe aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aa hini dhu leo lèke ètu dedha rai hèu mèngi. Hini se muri dènge sega, toke kapai ka hua. Hua ae titu kèna, dꞌai cangasu hari.” Lolo èle ka, Yesus paꞌèle lii pakasame ne, dènge lii dhu mèdhu, aku Nèngu na, “Miu dhu pasa dhilu, na, ngee paie-iie!” ");
INSERT INTO nfa_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Èle èèna ka, ana madhutu Yesus karèi sasoa nèti lii pakasame deo na. ");
INSERT INTO nfa_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na dhaa, peka na, “Sèmi neꞌe! Lula miu se dꞌèi madhutu dadꞌèi Ama Lamatua dènge dꞌara kateme, nèti èèna ka Jaꞌa peka paledꞌa, ho miu meꞌa tasamia Lamatua neo paredha dhèu unu Na. Te ngaa dhèu leo roꞌo boe pareꞌa dènge dadꞌèi Lamatua. Nèti èèna ka, Jaꞌa ajꞌa-nori si pake lii pakasame di. Te dhèu nèti lii padhai Lamatua dhu suri tèke le, peka na, ‘Rèngu se rèdhi le, te ngaa roꞌo boe reꞌa. Rèngu tadèngi le, te ngaa roꞌo boe sèmi.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hèia Yesus peka sasoa nèti lii pakasame ne, aku Nèngu na, “Hini se, nuka Lii Holo-Nori Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hini dhu lèke ètu jꞌara, nuka dhèu dhu nanene Lii Holo-Nori Ama Lamatua, te ngaa dhèu aae nidhu mai parame nare nèti dꞌara rèngu. Dènge jꞌara neꞌe, rèngu parcaya boe Lamatua, aa abhu boe mamuri. ");
INSERT INTO nfa_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Hini dhu lèke dedha hadhu, nuka dhèu dhu nanene Lii Holo-Nori Ama Lamatua dènge dꞌara karejꞌe. Te ngaa amo na marèma boe. Rèngu parcaya, te ngaa ropa paraga dènge jꞌajꞌèra, rèngu manahu. ");
INSERT INTO nfa_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hini dhu lèke era ajꞌu padhudhu, nuka dhèu dhu tadèngi, ka ra sèmi rare Lii Lolo Beꞌa. Te ngaa nare nèbhu boe, ka rèngu bhèlu eele Lii Lolo Beꞌa, lula rèngu bhute dènge laladhe sasabꞌa-laꞌa rèngu, mèdha-panyau rèngu, aa dènge neo mamuri karejꞌe di. Nèti èèna ka, parcaya rèngu dènge boe kabꞌua ngaa-ngaa. ");
INSERT INTO nfa_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Te ngaa hini dhu lèke ètu dedha rai hèu mèngi, nuka dhèu dhu mamuri mola dènge dꞌara hua iia. Ropa rèngu tadèngi Lii Lolo Beꞌa Ama Lamatua, rèngu sèle asa dꞌara rèngu. Dènge jꞌara ne, rèngu parcaya taa-taa, aa adꞌu-ue jꞌara dhu beꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ka Yesus peka hari, na, “Abhu ètu mia, dhèu paheo rare labhu iiki, ho èèna na saguru dènge èru rai. Aa abhu ètu mia, dhèu tao labhu ètu roꞌa koi. Te ladhe tao sèmi èèna, dhèu bisa boe rèdhi heo na. Labhu dhu guna, nuka padhèdi ètu era dedha, sèna ka heo na bisa pasaraa dhèu dhu maso mai. ");
INSERT INTO nfa_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Èci èèna kahèi dènge aaꞌi-aaꞌi dhu pahuni limuri ne, bèli-camèdꞌa pasabhoka. Aa madha jꞌara-madha jꞌara dhu dhèu reꞌa boe limuri ne, èèna na dhèu bisa reꞌa mèu. ");
INSERT INTO nfa_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","De miu hudꞌi pangee paie-iie ku jꞌara seꞌe. Dhèu dhu neo tenge tareꞌa-reꞌa dadꞌèi Lamatua, nèngu asa dꞌèlu-mèu. Te ngaa rèngu dhu pusi pahae boe dadꞌèi Lamatua, rèngu asa goa.” ");
INSERT INTO nfa_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ca tèka, Yesus bhute dènge dhèu ae. Hèia ina dènge ari Na mai neo paraga dènge Ne. Te ngaa ra bisa boe lasi padètu, lula dhèu se, ae titu kèna. ");
INSERT INTO nfa_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ka abhu dhèu laꞌe peka dènge Yesus, na, “Ama! Ina dènge ari Ama, ètu liꞌu sèi. Ra neo paraga dènge Ama.” ");
INSERT INTO nfa_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ka Na dhaa, peka na, “Oo! Te ngaa sèmi neꞌe. Ina dènge aꞌari Jaꞌa, nuka rèngu dhu tareꞌa-reꞌa dꞌèi nanene Lii Lolo Beꞌa Ama Lamatua, aa tao madhutu.” ");
INSERT INTO nfa_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ca lodꞌo, Yesus gale dhèu pajuu-paleha Na, aku Nèngu na, “Mai lati ka asa cabèka dano.” Ka ra caꞌe koha cue, hèia pakèdꞌi lasi. ");
INSERT INTO nfa_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ropa rèngu ètu talora dano, Yesus bhèjꞌi. Nèbhu boe cagꞌagꞌa laa, ngèlu aae mai. Naha tèbꞌe koha, hèia èi maso sa dꞌara, ka oe molo. ");
INSERT INTO nfa_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ropa rèdhi sèmi èèna, hèia ana madhutu se parèi Ne, peka na, “Ama! Ama! Kèdꞌi ho tolong ku laa! Te èdhi madhe aaꞌi kèna!” Ka Yesus kèdꞌi. Hèia Na kai ngèlu dènge naha, peka na, “Mau ka!” Kacaꞌa laa, ngèlu dènge naha mau dènge ka. ");
INSERT INTO nfa_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hèia Na pasanèdꞌe ana-ana madhutu Na, aku Nèngu na, “Nga tao ka miu parcaya mèka Jaꞌa?” Rèngu madhaꞌu dènge malaa, ka ra pakarèi èci dènge èci, aku rèngu na, “Cee ka Yesus ne? Tasamia ka Nèngu bisa paredha ngèlu dènge naha, ka ra madhutu dadꞌèi Na?” ");
INSERT INTO nfa_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nèbhu boe rèngu dꞌai rai Garasa, ètu sebhe dano Galilea. ");
INSERT INTO nfa_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Ètu era neꞌe, dhèu èci dhu nèbhu ae le, nidhu ae pahujꞌu ne. Dhèu ne dènge boe èmu, ka na pea ètu era roꞌa dhèu madhe. Bèli-bèli èèna kako laꞌe-mai, dhu pake boe mèdha-papake. Te nidhu sèra loe boe paredha ne. Dhèu dhu èki le pèri-pèri hari dènge rate aa pakanau ne dènge kanau bèsi, te ngaa na lèku èta si. Ka nidhu se laka-seti ne ho laꞌe asa era dhu kaliu. Ropa Yesus si puru nèti dedha koha, ka dhèu hujꞌu ne mai asa Yesus. Hèia na paꞌoo-parodha. Ka na pabèbhe iisi, aa na patitu kètu urutuu ètu haga Yesus. Hèia Yesus paredha nidhu sèra, aku Nèngu na, “Ee, nidhu! Rai eele nèti dhèu neꞌe!” Hèia dhèu hujꞌu ne paꞌoo, peka na, “Baku gagu jaꞌa! Te jaꞌa keꞌa Èu ne Yesus, Ana nèti Ama Lamatua dhu Dedha Risi Eele! Èu baku pajꞌèra jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ka Yesus karèi ne, “Ngara èu cee?” Hèia nidhu se dhaa, aku rèngu na, “Legion, te jiꞌi se ae, sèmi sordadꞌu riho-riho.” Na lii sèmi èèna, lula nidhu se ae-ae dhu maso ètu dꞌara ngiꞌu dhèu èèna. ");
INSERT INTO nfa_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nidhu se loe boe pamako Yesus, sèna ka baku pua rèngu lasi asa dꞌara Roꞌa Jꞌajꞌèra, nuka era taha koasa bhabhelu-katubꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Te ngaa dhu padètu ètu èèna, hahi canau kateme dhu nyuu rai ètu sebhe ledhe. Ka nidhu se manèngi Yesus, peka na, “Pua la jiꞌi maso asa dꞌara hahi sèi!” Hèia Yesus dꞌèi kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ka nidhu se kalua ka nèti dꞌara dhèu mone ne, lasi maso asa hahi. Hahi se aaꞌi-aaꞌi ra hujꞌu, ka ra rai pajꞌala puru nèti sebhe ledhe ne, hèia caroco asa dꞌara dano. Aa cène, ka madhe aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ropa rèdhi sèmi èèna, dhèu madhenge hahi se, rai lasi palème rae-rae ètu sèra, lolo aaꞌi-aaꞌi ngaa dhu jꞌajꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ropa dhèu ètu rae se tadèngi lii lolo se, ka lasi ae-ae sèna ka neo rèdhi unu ra tatao dhu jꞌajꞌi le. Dꞌai era èèna, rèngu ladhe, na, dhèu dhu nidhu tao èèna, madhèdi mau-mau padètu ètu haga Yesus. Nèngu pake le mèdha-papake, aa na hujꞌu heka. Ladhe rèdhi sèmi neꞌe, ka aaꞌi-aaꞌi ra jꞌajꞌi madhaꞌu. ");
INSERT INTO nfa_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hèia dhèu-dhèu dhu ladhe rèdhi ngaa dhu jꞌajꞌi ne, ra palolo dènge dhèu-dhèu dhu heka mai sèra, tasamia ka dhèu hujꞌu ne èle nèti papèdꞌa na. ");
INSERT INTO nfa_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ka dhèu Garasa aaꞌi-aaꞌi ra manèngi Yesus ho tèke eele rai rèngu, te rèngu madhaꞌu titu kèna. Hèia Yesus si caꞌe lasi asa dedha koha, sèna ka lèpa hari asa cabèka dano Galilea. ");
INSERT INTO nfa_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Te ngaa dhèu deo na dhu nidhu tao, loe boe pamako Yesus, aku nèngu na, “Ama! Hudꞌi laa jaꞌa madhutu Ama kahèi!” Te ngaa Yesus dhaa ne, peka na, ");
INSERT INTO nfa_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Sèmi neꞌe ku laa! Beꞌa risi èu lèpa ka asa aꞌari èu. Lamu lolo aaꞌi dènge ra, na, Ama Lamatua tao le jꞌara dhu beꞌa hia èu.” Hèia dhèu ne kako palème dꞌara kota ne, na palolo dènge dhèu aaꞌi-aaꞌi ra, peka na, Yesus ka dhu paꞌèle nèngu. ");
INSERT INTO nfa_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Èle èèna ka, Yesus si lasi hari dènge koha asa cabèka dano Galilea. Lodꞌo rèngu puru nèti dedha koha, dhèu ae dhu mate mema le Yesus. Dhèu se mai ae-ae ho soru Ne. ");
INSERT INTO nfa_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ètu neꞌe abhu ca dhèu, ngara na Yairus. Nèngu kapala èmu manèngi-mangajꞌi ètu dꞌara kota ne. Ana na dhoka ca dhèu di; ana bhèni, umur na canguru dua tèu. Ana bhèni ne dhu pèdꞌa aae, oe madhe. Ropa Yairus nèdhi Yesus mai, hèia laꞌe patitu kètu urutuu na ètu madha Yesus. Na manèngi ho Yesus dhuli èmu na, sèna ka puri-paꞌèle ana na. Dhaa nare ka, Yesus madhutu dènge ne asa èmu na. Aa dhèu ae madhutu rèngu. Ka rèngu paseti èci dènge èci. ");
INSERT INTO nfa_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Abhu kahèi dhèu bhèni èci dhu kako dènge rèngu. Bhèni ne dhu lèke papèdꞌa dhèu bhèni dhu loe boe canguru dua tèu kèna. Doi-dhari dènge mèdha-panyau na èle aaꞌi le, ho bꞌae dote-matarii. Te ngaa abhu boe dhu bisa puri-paꞌèle ne. Papèdꞌa na asa na hoe. ");
INSERT INTO nfa_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ka na ara padètu-dètu asa Yesus nèti kabodho. Hèia na gai lèke suu kodho Yesus. Ropa na gai lèke kodho Yesus ne, hèia papèdꞌa na èle dènge ka. ");
INSERT INTO nfa_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Cagꞌagꞌa laa, Yesus titu taha. Hèia Na karèi, peka na, “Cee ka dhu goi lèke Jaꞌa?” Te ngaa abhu boe ca dhèu sa dhu mangaku. Ka Petrus bꞌala, aku nèngu na, “Ama! Dhèu ae-ae ka dhu tao paseti aa patule-pajuku nèti kabodho. Sèmi neꞌe ne, teꞌa na cee ka dhu goi lèke Ama!” ");
INSERT INTO nfa_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Te ngaa Yesus peka dènge ne, “Aadꞌo! Deo na Jaꞌa rasa abhu koasa dhu kalua nèti ngiꞌu Jaꞌa. De Jaꞌa keꞌa, na, ca dhèu dhu sangaja gai Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ropa bhèni ne neꞌa, na, nèngu bisa boe pasili, hèia na madhaꞌu titu kèna. Isi na rèbha-rèbha, ka laꞌe patitu kètu urutuu ètu madha Yesus. Hèia na lolo mi dhèu ae sèra, nga tao ka nèngu gai Yesus. Aa na lolo kahèi, na, ropa nèngu gai lèke Yesus, nèngu èle dènge nèti papèdꞌa na. ");
INSERT INTO nfa_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Hèia Yesus lii dènge ne, peka na, “Ana hèni! Èu èle nèti papèdꞌa, lula èu parcaya Jaꞌa. Lèpa ka dènge mera-milu!” ");
INSERT INTO nfa_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lodꞌo Yesus padhai lii era dènge bhèni ne, ca dhèu nèti Yairus mai peka dènge ne, “Ama, ee! Ana ama aadꞌo heka. Na madhe le, de pajꞌèra ia ka Ama Mese.” ");
INSERT INTO nfa_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Te ngaa ropa Yesus tadèngi nare lii peka dhèu èèna, hèia Yesus lii dènge Yairus, “Mau-mau! Baku madhaꞌu! Parcaya mi Ama Lamatua di. Nèngu ka dhu hia mamuri mi ana èu.” ");
INSERT INTO nfa_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Ropa rèngu dꞌai èmu Yairus, dhèu ae le. Ra tangi dènge dꞌara pèdꞌa. Ka Yesus kai si, peka na, “Ae eele ka tangi laa! Ana ne madhe boe. Dhoka na bhèjꞌi di!” Te ngaa dhèu se pahae boe, ra mari pakapengo hèbꞌa, te rèngu rèdhi unu ra ana ne maꞌète aꞌae. Hèia Yesus manèngi sèna ka ina-ama nèti ana bhèni ne, Petrus, Yohanis dènge Yakobis maso lasi palere-lere dènge Ne. Dhèu leo sèra, Na hia si mate ètu liꞌu. ");
INSERT INTO nfa_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Rare dꞌara, ka Yesus kèpe ai ana ne, hèia Na paroa peka na, “Ana! Kèdꞌi ka!” ");
INSERT INTO nfa_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Cagꞌagꞌa laa, ana ne mamuri hari, ka na kèdꞌi titu. Hèia Yesus lii dènge ina ana bhèni ne, na, “Hia ana ne naꞌa!” ");
INSERT INTO nfa_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ina-ama ana ne malaa-maloha. Te ngaa Yesus pasanèdꞌe si, baku palolo dènge dhèu, ngaa dhu jꞌajꞌi ne. ");
INSERT INTO nfa_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ca lodꞌo, Yesus pakaboko nare ana madhutu Na, dhèu canguru dua sèra. Ka Na hia si koasa, ho babège eele nidhu, aa puri-paꞌèle dhèu nèti rupa-rupa èi papèdꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na pua si lasi lole jꞌara-jꞌara paredha Ama Lamatua, aa puri-paꞌèle papèdꞌa dhèu ètu mia-mia. ");
INSERT INTO nfa_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Te ngaa Na peka dènge si, aku Nèngu na, “Sanèdꞌe paie-iie! Baku mèti kahèi ngaa-ngaa ètu jꞌara. Kako dhoka dènge kodho ètu ua di. Baku mèti kodho silu. Baku mèti kahèi tatea, tas, gee jꞌara, do doi-dhari! ");
INSERT INTO nfa_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ladhe dꞌai ka dꞌara rae èci, abhu dhèu dhu soru miu, na lami pea dènge ne. Mage mi hagꞌe-hagꞌe èmu kahèi. Pea taruu ètu dꞌara èmu èèna, toke miu pakèdꞌi, tèke eele rae èèna. ");
INSERT INTO nfa_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ladhe miu maso asa dꞌara rae èci, hèia dhèu-dhèu ètu sèra roꞌo boe sèmi miu, aa roꞌo boe nanene lii padhai miu, na, pakèdꞌi tèke eele rae èèna. Lodꞌo miu tèke eele rae èèna, tao madhutu adꞌa ho caro eele ahu nèti haga miu. Aa mi peka dènge ra, ‘Miu se ladhe moꞌo boe nanene lii jiꞌi, pe miu sèmi mere pala mi!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Èle ka, ana madhutu se lasi ka asa rae-rae. Ra lole dènge dhèu-dhèu Lii Lolo Beꞌa Ama Lamatua. Aa puri-paꞌèle kahèi dhèu nèti papèdꞌa ètu mia-mia. ");
INSERT INTO nfa_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ca tèka, rupa-rupa lii lolo lula-nèti Yesus ne dꞌai le dhèu aae Herodes Antipas. Ropa na tadèngi lii lolo se, hèia na bingu, lula dhèu cahagꞌe peka na, “Yesus ne, nuka Yohanis tuka sarani, dhu mamuri hari le.” ");
INSERT INTO nfa_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aa cahagꞌe hari peka na, “Nèngu ne, baki Elia dhu mamuri hari.” Abhu dhu leo hari, peka na, “Nèngu ne, ca dhèu nèti dhèu rèti lii padhai Lamatua dhu uru-uru sèra.” ");
INSERT INTO nfa_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Te ngaa Herodes sanèdꞌe era, peka na, “Ca hari ni, jaꞌa pua le poro pamaꞌète kètu Yohanis. De na mamuri hari, do? Aa ca dhèu ne, cee hari?” Ka na tenge jꞌara, sèna ka patoo madha dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ca lodꞌo, ana madhutu dhu Yesus pua sèra, lèpa mai paꞌèci hari dènge Ne. Ra lolo dènge Ne aaꞌi-aaꞌi dhu rèngu tao. Ka Yesus si kako mesa-mesa ra asa era èci, dhu padètu dènge rae Betsaida, ho ra ae ètu èèna. ");
INSERT INTO nfa_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Te ngaa dhèu ae dhu reꞌa rare, na, Yesus si neo lasi sa mia, ka ra pakiꞌu re limuri. Yesus sèmi si, hèia Na paꞌèle dhèu pèdꞌa aaꞌi-aaꞌi, aa Na peka-padhai dènge ra, jꞌara-jꞌara Ama Lamatua nèdꞌu paredha. ");
INSERT INTO nfa_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ropa dꞌai lodꞌo nihia, ka canguru dua ana madhutu Yesus sèra, peka dènge Ne, “Beꞌa risi Ama pua dhèu seꞌe lasi asa rae-rae dhu padètu dènge era neꞌe, sèna ka ra tenge ngangaꞌa unu ra. Aa hudꞌi laa ra lasi tenge era ho jꞌunu taha. Te era dhu kajꞌèu nèti rae sèmi neꞌe, tasamia ka rèngu bisa abhu raꞌa-rinu?” ");
INSERT INTO nfa_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Te ngaa Yesus bꞌala si, peka na, “Sèmi neꞌe! Miu ka dhu pangaꞌa si!” Hèia ana madhutu se dhaa, peka na, “Ira ii! Ama, ee! Tasamia bisa sèmi èèna? Dhèu se risi nèti lèmi riho dhèu! Èèna dhèu mone di, ige mèka bhèni dènge ana niki! Ètu dꞌara adhe-aai jiꞌi, abhu dhoka roti lèmi bua, dènge iꞌa dua ngiꞌu di. Ladhe Ama neo sèna ka jiꞌi pangaꞌe dhèu seꞌe, tasa mera mia ho jiꞌi hèli ngangaꞌa ae-ae hia ra?!” Ka Yesus dhaa, “Pakaboko si madhèdi lèmi nguru-lèmi nguru dhèu, ca kaboko.” ");
INSERT INTO nfa_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hèia lasi tao sèmi èèna. ");
INSERT INTO nfa_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ropa dhèu se madhèdi, ka Yesus nare roti lèmi bua dènge iꞌa dua ngiꞌu sèra. Ka Na tangara sa dedha, ho Na manèngi makasi. Èle ka Yesus pamae roti dènge iꞌa sèra. Hèia Na jꞌole sa ana-ana madhutu Na, ho papala mi dhèu-dhèu sèra. ");
INSERT INTO nfa_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dhèu aaꞌi-aaꞌi se raꞌa toke bècu. Ka ngangaꞌa dhu risi sèra, kaboko rare pènu canguru dua soe. ");
INSERT INTO nfa_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ca tèka, Yesus laꞌe mesa Na ho sabajꞌa ètu era èci. Hèia ana madhutu Na mai ka paꞌèci dènge Ne. Sabajꞌa nare, ka Yesus karèi si, aku Nèngu na, “Miu tadèngi-tadèngi dhèu palolo na Jaꞌa ne, cee?” ");
INSERT INTO nfa_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hèia ra dhaa, “Cahagꞌe peka na, Yohanis tuka sarani. Aa cahagꞌe peka na, baki Elia. Ladhe aadꞌo, na, ca dhèu nèti dhèu rèti lii padhai Ama Lamatua uru-uru sèra dhu mamuri hari.” ");
INSERT INTO nfa_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hèia Yesus karèi hari si, peka na, “Madhutu aꞌabhu miu, na, Jaꞌa ne, cee?” Ka Petrus dhaa, “Ama ne, Kristus, nuka Dhèu dhu Ama Lamatua pajꞌujꞌu karèi nèti uru ka!” ");
INSERT INTO nfa_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Èle ka Yesus kai si, sèna ka baku ale dènge dhèu èci sa, peka na, Nèngu na, Kristus. ");
INSERT INTO nfa_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ka Yesus tuhu hari lii padhai Na, aku Nèngu na, “Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Jaꞌa hudꞌi pasae ku rupa-rupa jꞌajꞌèra dhu bia. Bèli-camèdꞌa dhèu heka adꞌa Yahudi, kètu agama Yahudi dènge mese agama sèra, roꞌo boe sèmi, ladhe peka, na, Jaꞌa ne Kristus. Aa èèna na, ra pamadhe Jaꞌa. Mema tareꞌa-reꞌa Jaꞌa madhe, te ngaa asa camèdꞌa èèna, Jaꞌa mamuri hari!” ");
INSERT INTO nfa_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Èle ka Na peka dènge dhèu ae se, aku Nèngu na, “Dhèu dhu neo madhutu Jaꞌa, nèngu hudꞌi madhutu dènge dꞌara kateme ètu lodꞌo bèli-lodꞌo bèli. Nèngu hudꞌi core eele ku dadꞌèi dꞌara na. Nèngu hudꞌi madhutu taruu, masi ka dhèu neo pamadhe ne, nuka sèmi dhèu pasae ajꞌu palolo-palèbha na, ho laꞌe asa era ra pamadhe ne. ");
INSERT INTO nfa_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te dhèu dhu sadia madhe lula madhutu Jaꞌa, bèli-camèdꞌa nèngu unu mamuri taa-taa dènge Ama Lamatua. Te ngaa dhèu dhu neo dhoka mamuri hia ngiꞌu aae na, bèli-camèdꞌa nèngu pakajꞌèu-jꞌèu nèti Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ladhe dhèu unu aaꞌi ngaa-ngaa ètu rai-haha ne, te ngaa Ama Lamatua tule eele ne, aꞌoto na ngaa? ");
INSERT INTO nfa_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. De dhèu dhu makae madhutu Jaꞌa, aa makae sèmi lii ajꞌa Jaꞌa, Jaꞌa kahèi makae mangaku nèngu ètu madha Ama Lamatua, lodꞌo Jaꞌa lèpa mai nèti sorga. Te bèli-camèdꞌa Jaꞌa puru mai dènge dadedha Ama Ku, palere-lere dènge ana-ana pajuu Na nèti sorga. ");
INSERT INTO nfa_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jaꞌa peka patareꞌa dènge miu. Abhu pèri-pèri nèti miu ètu seꞌe se, bèli-camèdꞌa ladhe rèdhi unu ra Lamatua nèdꞌu paredha, heka ra madhe kèna.” ");
INSERT INTO nfa_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Èle aru lodꞌo, ka Yesus nèti Petrus, Yohanis dènge Yakobis, lasi caꞌe asa ledhe èci, ho neo sabajꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dhu Na sabajꞌa era, rèhu Na jꞌajꞌi leko-leo, aa mèdha-papake Na pudhi lao-lao. ");
INSERT INTO nfa_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Cagꞌagꞌa laa, dhèu dua cèu mai. Dhèu se, nuka baki Musa dènge baki Elia. Ka ra padhai lii dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Dua ra ladhe na leꞌe-leꞌe hèti-hèti. Tèlu ra padhue-padhai lula-nèti mamadhe Yesus bèli-camèdꞌa ètu Yerusalem. ");
INSERT INTO nfa_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lodꞌo èèna, Petrus dènge angalai na dhèu dua sèra musi madha sakaa titu kèna, ka ra bhèjꞌi luu. Ropa ra kabèdhi, hèia rèdhi Yesus titu dènge dhèu dua. Aa rèdhi Yesus dhu kahaꞌa kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ropa Musa dènge Elia neo lèpa, Petrus bingu, neꞌa heka tao tasamia. Ka na padhai lii leli, na peka na, “Ama! Jiꞌi ètu neꞌe, beꞌa dꞌai seli! De hua iia jiꞌi tao paleo tèlu bua. Cue hia Ama, cue hia baki Musa, aa cue hari hia baki Elia.” ");
INSERT INTO nfa_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Te ngaa ropa Petrus padhai lii era, raꞌi-liru puru mai, ka saguru rare rèngu. Hèia Petrus si madhaꞌu bia. ");
INSERT INTO nfa_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ka ra tadèngi lii nèti dꞌara raꞌi-liru èèna, peka na, “Neꞌe ne, Ana Jaꞌa dhu Jaꞌa hagꞌe kore le! Ladhe Na padhai lii, nanene Ne paie-iie!” ");
INSERT INTO nfa_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ropa lii na èle, Petrus si ladhe rèdhi dhoka Yesus mesa-mesa na. Rèngu tèlu ra, peka boe dènge dhèu èci sa, ngaa dhu rèngu rèdhi le. Dꞌai nèbhu ku, heka ra palolo dènge dhèu leo kèna. ");
INSERT INTO nfa_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Asa bèli èèna, lodꞌo Yesus dènge Petrus si puru mai nèti ledhe, dhèu ae mai paraga dènge Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ka dhèu èci rodhe Ne, peka na, “Ama Mese! Ladhe ku ana mone jaꞌa ca dhèu ne laa! ");
INSERT INTO nfa_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Te abhu nidhu dhu loe boe kèpe ne, ka na pakèce sahèka, aa nyanyoko ne, toke hèbꞌa na horo karaka. Nidhu ne loe boe dhadhedhe ana ne, aa dꞌèi boe hia ana ne ae nare ciki sa. ");
INSERT INTO nfa_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jaꞌa manèngi le kahèi ana madhutu Ama se ho ra babège eele nidhu ne, te ngaa tao rare boe!” ");
INSERT INTO nfa_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ka Yesus jèke si, peka na, “Eeh! Miu se parcaya boe, na, Lamatua bisa paꞌèle dhèu nèti papèdꞌa ra. Miu mema dhèu dhu meꞌa boe mamuri madhutu jꞌara mola! De Jaꞌa hudꞌi tatae hari miu toke pèri lodꞌo?” Hèia Na peka dènge ama ana ne, “Mèti ana mu sa neꞌe mai!” ");
INSERT INTO nfa_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ropa pakako rèti ana ne asa Yesus, hèia nidhu hake pabèbhe, aa rarumu ne. Te ngaa Yesus paredha nidhu ho kalua tèke eele ana ne, hèia na èle dènge. Ka Yesus hia ana ne asa ama na laꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Dhèu-dhèu ètu sèra dhu ladhe rèdhi koasa Yesus, aaꞌi-aaꞌi ra malaa-maloha. ");
INSERT INTO nfa_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Ropa dhèu se padhue era tadha malaa dhu Yesus tao, Nèngu lii dènge ana madhutu Na, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Miu patadhe paie lii padhai Jaꞌa ne! Nèbhu boe dhèu neo pahie Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne. Ka ra soro Jaꞌa asa dꞌara adhe-aai dhèu leo.” ");
INSERT INTO nfa_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Te ngaa ana madhutu Na se bingu. Masi ka rèngu dhane rare boe sasoa na, te ngaa ra madhaꞌu karèi Ne, sasoa na ngaa. ");
INSERT INTO nfa_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ca lodꞌo, ana madhutu Yesus pasisu lula-nèti rèngu se, cee ka dhu bèli-camèdꞌa jꞌajꞌi dhèu re madha. ");
INSERT INTO nfa_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Te ngaa Yesus neꞌa ngaa dhu rèngu pasisu. Ka Na paroa nare ana iiki ca dhèu, hèia Na patitu ètu karasa Na. ");
INSERT INTO nfa_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ka Yesus peka dènge ra, “Nanene paie! Dhèu dhu madhutu Jaꞌa, ho na ladhe-leru dhèu haha, dhu sama sèmi ana iiki ne, sasoa na nèngu ladhe-leru Jaꞌa kahèi. Aa na ladhe-leru kahèi Ama Ku ètu sorga dhu pua Jaꞌa mai asa rai-haha ne. Abhu dhèu ae dhu pusi-pahae boe dhèu sèmi seꞌe se. Dhèu seꞌe, nuka: dhu unu aadꞌo, dhu susa, dhu laku-laku boe, dhu kalua aapa, aa dènge dhèu haha. De dhèu dhu dꞌèi lalau-laloꞌo dhèu sèmi seꞌe se, madhutu Ama Lamatua, nèngu ka dhu dhèu re madha.” ");
INSERT INTO nfa_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hèia Yohanis peka dènge Yesus, aku nèngu na, “Ama! Ca lodꞌo jiꞌi ngèdhi ca dhèu babège eele nidhu, dènge ale kolongara Ama. Ka jiꞌi kai ne, sèna ka na ale ia ka ngara Ama, lula nèngu ne dhèu èdhi boe.” ");
INSERT INTO nfa_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Te ngaa Yesus dhaa, peka na, “Baku! Te dhèu dhu labꞌa boe èdhi, nèngu èèna angalai èdhi.” ");
INSERT INTO nfa_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus neꞌa le lodꞌo Na caꞌe asa sorga dètu le. Ka Na pamaꞌète nare, ho laꞌe asa kota Yerusalem. ");
INSERT INTO nfa_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na pua dhèu lasi uuru, sèna ka ra lalau ngangaꞌa-nganginu. Ka dhèu lasi uuru se, maso lasi asa dꞌara rae cue ètu propensi Samaria, ho lalau mema era rèngu manubha. ");
INSERT INTO nfa_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Te ngaa dhèu ètu Samaria se, roꞌo boe sèmi rare Yesus si, lula Nèngu neo laꞌe sogo-tagu Ama Lamatua ètu kota Yerusalem. ");
INSERT INTO nfa_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ropa Yakobis dènge Yohanis tadèngi lii neꞌe, ka ra pamako Yesus, aku rèngu na, “Ama! Tasamia na ti manèngi Ama Lamatua papuru ai mai nèti dedha-liru, ho tunu pakèpu si?” ");
INSERT INTO nfa_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Te ngaa Yesus ladhe asa dua ra, hèia Na kai si, peka na, “Baku pangee sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Èle èèna ka, lasi hari asa rae leo. ");
INSERT INTO nfa_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ropa rèngu kako era, dhèu èci lii dènge Yesus, peka na, “Ama! Ama neo asa mia èèna ka, jaꞌa neo madhutu Ama taruu!” ");
INSERT INTO nfa_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hèia Yesus bꞌala, peka na, “Beꞌa kahèi! Te ngaa pangee ku laa. Dhèu aaꞌi-aaꞌi dènge era pea-paluꞌu. Sèmi èèna kahèi dènge badha-manu. Busa hui lèpa laꞌe asa dꞌara roꞌa na. Manu-bhui lasi asa dꞌara rèdꞌa ra. Te ngaa Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa, dènge boe era pea-paluꞌu ho pasoru iisi Jaꞌa ne. Era lalaka kètu, aadꞌo kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ca tèka, Yesus paroa dhèu leo ca dhèu, ka Na peka, “Mai madhutu Jaꞌa, ho jꞌajꞌi dhèu Jaꞌa.” Ka dhèu ne dhaa, aku nèngu na, “Beꞌa kahèi, do! Te ngaa sèmi neꞌe, Ama. Hudꞌi jaꞌa lèpa ku ladhe-leru ina-ama jaꞌa. Ladhe padhane kore ama ku, heka jaꞌa madhutu kèna.” ");
INSERT INTO nfa_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Te ngaa Yesus peka dènge ne, “Sèmi neꞌe! Hudꞌi laa dhèu dhu parcaya boe Lamatua, uri dhèu rèngu dhu madhe. Te ngaa miu dhu lèka Lamatua, sasabꞌa miu lami peka-padhai jꞌara-jꞌara paredha Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Abhu dhèu leo dhu peka na, “Beꞌa kahèi. Jaꞌa neo madhutu Ama taruu. Te ngaa hudꞌi jaꞌa laku palangu ku lii dènge aꞌari jaꞌa, heka jaꞌa mai madhutu Ama.” ");
INSERT INTO nfa_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te ngaa Yesus lii dènge ne, “Sèmi neꞌe. Ladhe dhèu neo pare rai, te ngaa tao hari ngaa-ngaa dhu leo, toke bhèlu sèle, tatu oka na jꞌajꞌi boe. Sèmi èèna kahèi dènge dhèu dhu pamaꞌète nare le neo madhutu Jaꞌa, te ngaa pangee taruu mamuri na lodꞌo dhu uru sèra. Dhèu sèmi èèna gaguna na aadꞌo jꞌajꞌi dhèu sabꞌa ètu dꞌara paredha Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Èle èèna, Yesus hagꞌe nare ana madhutu Na dhu leo, pidhu nguru dua dhèu. Ka Na hagꞌe si, dua-dua dhèu, sèna ka lasi uuru asa era-era dhu Nèngu neo laꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hèia Na pua si, aku Nèngu na, “Abhu dhèu ae dhu nuka sèmi are dhu karara le. Ka lamatua oka pua dhèu sabꞌa na lasi gꞌètu are se. De miu hudꞌi sabajꞌa, sèna ka Ama Lamatua hia tabha dhèu-dhèu sabꞌa Na, ho oru rare dhèu-dhèu dhu neo madhutu Jaꞌa. Lula dhèu dhu neo madhutu Jaꞌa, ae. Te ngaa dhèu sabꞌa dhoka ciki ooꞌe di. ");
INSERT INTO nfa_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","De lami ka! Jaꞌa pua miu lami asa dhèu ae. Te ngaa sanèdꞌe sèmi neꞌe. Miu èci èèna ka dènge ana kahibꞌi-kalèbho dhu lami asa talora aae busa hui dhu bhelu. ");
INSERT INTO nfa_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Miu baku mèti doi-dhari, tas tao mèdha-papake, do salapa dhu risi ètu dꞌara kakako miu. Mage core eele ai lodꞌo dènge padhai lii iia dꞌara dènge dhèu ètu talora jꞌara. ");
INSERT INTO nfa_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Ladhe miu maso asa dꞌara rae èci, miu baku pidha-pidha era pea. Ladhe dhèu sèmi rare miu dènge beꞌa ètu dꞌara èmu cue, pea dhoka ètu èèna toke miu pakèdꞌi tèke eele rae èèna. Ladhe miu maso asa èmu cue, miu hudꞌi manèngi sèna ka Ama Lamatua hia berkat mi dhèu isi èmu èèna. Ladhe lamatua èmu ètu sèra sèmi nare miu dènge beꞌa, tatu Lamatua padꞌelo dꞌara hua iia Na mi isi èmu èèna. Te ngaa ladhe roꞌo boe sèmi miu, na, hudꞌi laa Lamatua padꞌelo dꞌara hua iia Na hia miu mesa mi. Ladhe miu maso asa èmu cue, do, asa rae èci, ra hia miu ngangaꞌa, miꞌa-minu laa dènge karejꞌe. Te ra hia èèna pamèci dènge èi kabhèsu miu dhu hae. ");
INSERT INTO nfa_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Puri-paꞌèle dhèu rèngu dhu pèdꞌa. Aa peka-padhai dènge dhèu sèra, na, ‘Paredha Ama Lamatua ètu katanga madha miu le!’ ");
INSERT INTO nfa_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Te ngaa abhu kahèi rae dhu dhèu ra roꞌo boe sèmi rare miu. Ladhe ra tao miu sèmi èèna, na, lami titu asa jꞌara-jꞌara ètu dꞌara rae èèna, mi lii dènge ra, peka na, ");
INSERT INTO nfa_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nanene paie! Miu dhèu dhu ètu dꞌara rae ne. Jiꞌi mai le ngèti Lii Lolo Beꞌa Lamatua hia miu, te ngaa miu pusi-pahae boe. De jiꞌi caro eele ahu rae neꞌe nèti haga jiꞌi, ho jꞌajꞌi mi tadha dhu peka na, pe bèli-camèdꞌa sèmi mere pala mi! Te ngaa sanèdꞌe paie-iie! Paredha Ama Lamatua ètu katanga madha miu le.’ ");
INSERT INTO nfa_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Miu meꞌa, sina ma, bhabhelu dhèu kota Sodom? Jaꞌa pasanèdꞌe miu! Bèli-camèdꞌa, dꞌai lodꞌo èle rai-haha ne, Ama Lamatua huku dhèu-dhèu dhu roꞌo boe sèmi rare miu, bia risi nèti dhèu Sodom!” ");
INSERT INTO nfa_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ka Yesus tuhu hari lii padhai Na, aku Nèngu na, “Mate unu miu dhu pea ètu rae Korasin dènge miu ètu rae Betsaida! Miu dui mere jꞌajꞌèra! Jaꞌa tao tadha-tadha malaa ètu katanga madha miu, te ngaa miu moꞌo boe parcaya Lamatua. Ngaa hari miu dhèu Yahudi dhu peka na, miu tadhe Ne. Ladhe sèmi tadha-tadha malaa se, dhu Jaꞌa tao ètu rae miu, lèke ètu kota Tirus dènge kota Sidon, tatu nèbhu nare sange neꞌe dhèu sèra ele-hoꞌa le, aa ra tèke eele sasala-sasigo ra, ho mai madhutu Lamatua. Aa rèngu tatu pake le mèdha sasusa, dènge tao ahu ètu kètu ra jꞌajꞌi mi tadha dhu peka na, rèngu manyasa nèti sasala-sasigo ra. Te ngaa dhèu Tirus dènge dhèu Sidon sèra, dhèu Yahudi boe. De ra peka boe, na, rèngu dhèu dhu tadhe Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tareꞌa! Miu ladhe ku laa! Bèli-camèdꞌa dꞌai lodꞌo Lamatua pamaꞌète lii langu dhèu aaꞌi-aaꞌi, hahuku nèti Lamatua mi dhèu Tirus dènge dhèu Sidon samaa risi nèti hahuku miu. ");
INSERT INTO nfa_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mata unu miu, kabarai Kapernaum! Miu baku pangee, na, bèli-camèdꞌa Lamatua nedhe miu pamaso asa dꞌara sorga. Aadꞌo! Mola-mèu èi! Èèna na Lamatua pèci miu asa dꞌara naraka lami! ");
INSERT INTO nfa_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sanèdꞌe pabeꞌa-beꞌa. Dhèu dhu nanene lii miu, nuka sèmi rèngu nanene Jaꞌa. Aa dhèu dhu pusi boe nanene miu, èci èèna ka ra pahae boe Jaꞌa. Aa dhèu dhu roꞌo boe nanene Jaꞌa, èci èèna ka dènge rèngu dhu pusi-pahae boe Ama Lamatua, dhu pua Jaꞌa mai asa rai-haha ne.” ");
INSERT INTO nfa_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ropa ana madhutu pidhu nguru dua sèra lèpa hari mai, dꞌara ra karejꞌe bia. Ka ra lole dènge Yesus, aku rèngu na, “Ira ii! Kakako jiꞌi ne, beꞌa bia! Ropa jiꞌi pake kolongara Ama ho babège eele nidhu, na, nidhu sèra nanene lii jiꞌi, hèia ra rai bhalèta.” ");
INSERT INTO nfa_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Te ngaa Yesus bꞌala si, peka na, “Mema tareꞌa! Lodꞌo miu tao sèra sa, Jaꞌa ladhe kèdhi Ama Lamatua pèci eele nidhu dènge dhèu aae ra nèti dedha-liru nèi, nuka sèmi bela dhu kahaꞌa nèti haa, nèti dhimu! ");
INSERT INTO nfa_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sanèdꞌe! Dhèu aae nidhu èèna, musu èdhi. Aa nèngu dènge koasa kahèi. Te ngaa Jaꞌa pangèdꞌu le miu koasa, ho palaho koasa na. Ladhe miu jꞌèli lèke kaisao, do karaka rai, miu ngaa-ngaa tao boe. Ngaa èci sa bisa boe pajꞌèra miu. ");
INSERT INTO nfa_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Miu karejꞌe lula nidhu nanene miu. Beꞌa kahèi, te ngaa sèra sa ana iiki era! Dhu beꞌa risi, dꞌara miu karejꞌe, lula Lamatua suri nare le ngara miu, jꞌajꞌi ana kabarai Na ètu sorga.” ");
INSERT INTO nfa_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lodꞌo èèna, Roh Lamatua dhu Mola-Mèci tao dꞌara Yesus karejꞌe-karae. Hèia Na koa-kio Ama Lamatua, peka na, “Ama dhu jꞌajꞌi Lamatua ètu dedha-liru dènge rai-haha. Jaꞌa manèngi makasi ae-ae, lula Ama paꞌabhe jꞌara-jꞌara seꞌe nèti dhèu dhu tao iisi dꞌèlu-mèu dènge dhèu lela dedha. Te ngaa Ama bhoke patalele aaꞌi-aaꞌi se hia mi ana iiki-ana iiki dènge dhèu-dhèu dhu pahaha iisi. Tareꞌa Ama! Lula èèna ka dhu pakarejꞌe dꞌara Ama!” ");
INSERT INTO nfa_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Hèia Yesus peka dènge dhèu ae sèra, aku Nèngu na, “Nanene paie! Ama Ku ètu sorga pangèdꞌu aaꞌi le koasa mi Jaꞌa. Dhu tadhe mèu, Jaꞌa ne cee, dhoka Ama di. Aa dhu tadhe mèu, Ama èèna cee, dhoka Ana nèti Ama di, nuka Jaꞌa ne. Aa Jaꞌa hagꞌe kore dhèu leo, sèna ka nori si, ho ra tadhe mèu Nèngu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ka Yesus kabibꞌa asa ana madhutu Na, hèia Na peka dènge rèngu mesa ra, aku Nèngu na, “Miu se oto titu kèna, lula mèdhi le koasa Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Dhèu aae-dhèu aae dènge dhèu rèti lii padhai Lamatua uru-uru sèra, dꞌèi titu kèna neo rèdhi ngaa dhu miu limuri ne mèdhi, te ngaa rèdhi boe. Rèngu dꞌèi kahèi neo tadèngi ngaa dhu miu nanene ne, te ngaa ra tadèngi rèdhi boe.” ");
INSERT INTO nfa_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ca tèka, ca dhèu dꞌèlu-mèu atora agama Yahudi, titu ho neo sèku pamanahu Yesus. Na karèi peka na, “Ama Mese! Mu peka ku laa! Jaꞌa adꞌu jꞌara sèmi ngaa, sèna ka jaꞌa mamuri taa-taa dènge Ama Lamatua ètu sorga?” ");
INSERT INTO nfa_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ka Yesus bꞌala ne, aku Nèngu na, “Musa suri tasamia lula-nèti jꞌara neꞌe ne? Aa madhutu mameꞌa èu, tasamia?” ");
INSERT INTO nfa_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hèia dhèu ne dhaa peka na, “Na suri sèmi neꞌe ka: ‘Èu hudꞌi sue ku Ama Lamatua, risi nèti ngaa-ngaa aaꞌi-aaꞌi ra. Nèti èèna ka, dꞌara èu hudꞌi dꞌèi Nèngu titu kèna, sabꞌa paꞌèra ho madhutu dadꞌèi Na, aa tadhe mèu Ne.’ Dhu suri kahèi, peka na, ‘Èu hudꞌi sue ku dhèu èu, sama sèmi èu sue ngiꞌu èu mesa mu.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Hèia Yesus bꞌala ne, “Dhu lèke kèna! Ladhe èu tao madhutu sèmi sèra, na, èu mamuri taa-taa dènge Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Te ngaa dhèu ne, tao iisi na sèmi dhèu mola sa. Ka na karèi hari Yesus, aku nèngu na, “Te ngaa, ‘dhèu jaꞌa’ èèna, ka cee?” ");
INSERT INTO nfa_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hèia Yesus bꞌala ne, peka na, “Sèmi neꞌe. Jaꞌa neo lolo dènge èu lii pakasame èci. Pe èu mesa mu ka dhu peka, na, mia ka dhu tareꞌa-reꞌa ‘dhèu èu’. Lii pakasame ne, sèmi neꞌe ka: ca lodꞌo, abhu dhèu Yahudi ca dhèu pakèdꞌi nèti kota Yerusalem, puru laꞌe asa kota Jeriko. Te ngaa ropa dꞌai talora jꞌara, cagꞌagꞌa laa parapo mai game paroe ne. Ra game, aa parame rare aaꞌi doi-dhari dènge mèdha-papake dhèu ne. Ka parapo se core ne asa sebhe jꞌara laꞌe, aa ra rai tèke eele ne. Dhèu ne, oe madhe. ");
INSERT INTO nfa_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Te ngaa nèbhu boe, ka ama agama Yahudi ca dhèu puru mai re jꞌara èèna. Te ngaa ropa na ladhe nèdhi dhèu ne dhu diu raa, aa dhu tarenga ètu sebhe jꞌara, ama agama ne titu boe sa hèi, ho uri dhèu ne. Na kako paseli eele dhèu neꞌe, laꞌe asa cabèka jꞌara, ka na taruu. ");
INSERT INTO nfa_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nèbhu boe ka dhèu leo hari èci kako re èèna. Nèngu ne nèti suku Lewi dhu tema sabꞌa ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi Ama Lamatua. Ropa nèdhi dhèu ne dhu baa-baa ètu sebhe jꞌara, hèia laꞌe padètu-dètu ho ladhe, te ngaa na bara boe ne kahèi. Na sigo eele jꞌara, ka laꞌe taruu. ");
INSERT INTO nfa_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Nèbhu boe ka, dhèu èci nèti rai Samaria mai re jꞌara èèna dènge badha keledꞌei na. Dhèu Yahudi pahae boe dhèu Samaria. Te ngaa ropa dhèu Samaria ne nèdhi dhèu dhu lèke rapo èèna, ka dꞌara na mèke boe. Na mai padètu-dètu ho neo saradꞌe ne. Ka pamèu nuꞌa dhèu ne dènge èi anggor, hèia na panaꞌi dènge èi mènyi. Aa na parbaan nuꞌa na, èle ka na pacaꞌe asa keledꞌei na. Hèia nèti ne laꞌe asa dꞌara kota. Na pamaso ne asa dꞌara losmen, aa lalau pabeꞌa-beꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Asa bèli madꞌae èèna, dhèu ne laꞌe bꞌae uuru kètu, doi iia dua bua mi lamatua losmen ne, ka na peka, ‘Pake uuru doi ne ho lalau dhèu ne toke èle. Ladhe dꞌai boe, pake uuru doi èu. Pe jaꞌa lèpa, pula hari doi sèra.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Lii pakasame Yesus ne dꞌai sange neꞌe ka. Hèia Yesus karèi mi dhèu dꞌèlu-mèu atora agama Yahudi ne, aku Nèngu na, “Madhutu èu, mia ka dhu tareꞌa-reꞌa ‘dhèu nèngu,’ mi dhèu dhu lèke rapo ne?” ");
INSERT INTO nfa_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ka dhèu ne dhaa, peka na, “Tatu dhèu dhu lalau ne toke èle.” Hèia Yesus lii, peka na, “Tareꞌa! De lamu ka, tao madhutu sèmi èèna.” ");
INSERT INTO nfa_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Èle èèna ka, Yesus dènge ana madhutu Na, lasi taruu asa Yerusalem. Hèia ra dhuli ètu rae èci. Ètu era neꞌe, dhèu dua dhu paꞌaꞌari, ngara ra, Marta dènge Maria. Marta manèngi ho Yesus si manubha ètu èmu rèngu. Ka ra pea taha ètu èèna. Ropa Yesus madhèdi ho ajꞌa si, Marta bhute dènge pananasu. Te ngaa ari na Maria, madhèdi padètu-dètu haga Yesus, ho nanene lii padhai Na. Nèbhu boe ka Marta mai kaꞌugu ètu madha Yesus, aku nèngu na, “Ama! Tasamia, ee? Jaꞌa dꞌai madhe lalau ngangaꞌa-nganginu mesa-mesa ku, te ngaa ari jaꞌa madhèdi mau-mau. Peka ku dènge ne laa, sèna ka mai bara jaꞌa ètu dapu ne.” ");
INSERT INTO nfa_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Te ngaa Lamatua Yesus dhaa, na, “Marta. Èu ne bhute dènge ngangee rupa-rupa. ");
INSERT INTO nfa_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Beꞌa kahèi do, te ngaa jꞌara èci dhu beꞌa risi. Maria pili nare dhu beꞌa risi le, nuka madhèdi ho nanene Lii Lolo Beꞌa nèti Jaꞌa. Dhèu bisa boe parame rare nèti nèngu Lii Lolo Beꞌa ne.” ");
INSERT INTO nfa_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ca tèka, Yesus laꞌe manèngi-mangajꞌi. Manèngi-mangajꞌi nare, hèia ana madhutu Na ca dhèu mai, ka na manèngi, aku nèngu na, “Ama! Yohanis tuka sarani, ajꞌa ana madhutu na ka reꞌa sabajꞌa. Jiꞌi manèngi sèna ka Ama ajꞌa jiꞌi sabajꞌa kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ka Yesus peka, na, “Beꞌa! Sabajꞌa pake conto sèmi neꞌe: Ama! Kolongara Ama dhu mola-mèci. Hudꞌi laa dhèu aaꞌi-aaꞌi jꞌoka padedha-dedha kolongara Ama dhu kapai na. Hudꞌi laa Ama jꞌajꞌi Dhèu Aae mi dhèu aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ama hia laa jiꞌi bèli-bèli, ngangaꞌa dhu dꞌai. ");
INSERT INTO nfa_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jiꞌi manèngi Ama pabhèlu eele sasala-sasigo jiꞌi, nuka sèmi jiꞌi kahèi pabhèlu eele sasala-sasala dhèu dhu tao mi dedha jiꞌi. Ama magee jiꞌi, sèna ka jiꞌi baku adꞌu-ue bhelu-katubꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Èle èèna ka, Yesus nori hari si, jꞌara-jꞌara sabajꞌa. Na pake upama, peka na, “Sèmi dꞌai talora mèda, angalai èu mai nèti kajꞌèu, ho manubha ètu èmu èu. Te ngaa èu dhu dènge boe ngaa-ngaa, sèna ka hia ne naꞌa. Ka èu lamu asa èmu angalai dhu leo, ho pamako nèti liꞌu, peka na, ‘Lai aae na, ee! Hia taha ku jaꞌa roti dꞌai tèlu bua sa! Te jiꞌi abhu tamu ètu èmu, te ngaa jiꞌi dhu mola-mèu èi! De lai aae na, ee! Dhoka tèlu bua di. Pe jaꞌa gꞌati hari!’ ");
INSERT INTO nfa_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ladhe sèmi angalai èu dhaa, peka na, ‘Te aꞌa, ee! Dhèu bhèjꞌi luu, na, èu mai parèi! Babèdho dhu patèke le! Ana iiki se dhu bhèjꞌi aaꞌi le. De mage mu nasa kahèi! Pe lodꞌo leo hari ku laa!’ ");
INSERT INTO nfa_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Te ngaa masi ka sèmi èèna, ngee paie-iie. Masi ka dhèu ne kèdꞌi boe lula èu angalai nèngu, te ngaa ladhe èu loe boe pamako, tatu na kèdꞌi, ho hia èu roti sèra. ");
INSERT INTO nfa_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sèmi èèna kahèi, dènge manèngi-mangajꞌi. Manèngi taruu mi Lamatua; pe Na hia. Tenge taruu; pe Na pajꞌujꞌu jꞌara. Paroa taruu; pe Na bhoke hèbꞌa èmu. ");
INSERT INTO nfa_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Te dhèu aaꞌi-aaꞌi dhu manèngi taruu mi Ama Lamatua, èèna na rèngu sèmi. Dhu loe boe tenge, èèna na abhu. Dhu maꞌète boe paroa, pe Na bhoke babèdho. ");
INSERT INTO nfa_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Miu pangee ku laa. Abhu ètu mia ladhe ama, dhu ana na manèngi iꞌa, na hia mege? ");
INSERT INTO nfa_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Do, ladhe ana manèngi kanadhu manu, na hia karaka rai? Tatu aadꞌo, si? ");
INSERT INTO nfa_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dhèu rai-haha ne, mema bhelu. Te ngaa Ama miu ètu sorga, Nèngu ne mema beꞌa. De ladhe miu dhèu dhu bhelu, dꞌèi hia mèdha dhu beꞌa mi ana-ana miu, ngaa hari Ama! Nèngu ne hia, mesa boe ngaa dhu miu parluu, te ngaa risi nèti èèna. Na pala-bagi Roh Na dhu Mola-Mèci mi dhèu dhu manèngi mi Nèngu.” ");
INSERT INTO nfa_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ca lodꞌo, Yesus magèle eele nidhu nèti ca dhèu dhu lii aadꞌo. Ka dhèu ne bisa padhai lii hari. Dhèu-dhèu ètu sèra malaa. ");
INSERT INTO nfa_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Te ngaa abhu kahèi dhu peka na, “Mema, Nèngu bisa magèle eele nidhu, lula Nèngu abhu koasa nèti dhèu aae nidhu, nuka Baalsebul.” ");
INSERT INTO nfa_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abhu dhèu leo neo sèku Yesus. Ka ra manèngi ho Yesus tao tadha malaa èci hari, sèna ka dhèu reꞌa, na, koasa Na nèti Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Te ngaa Yesus neꞌa nare le kahadhu kajꞌalu rèngu sèra. Ka Na lii, peka na, “Ladhe ètu rai cue, kabarai na pamusu, tatu rai ne laho mae-mae. Sèmi èèna kahèi, ladhe ètu dꞌara èmu cue, isi èmu loe boe patao-palaha, tatu èmu ne jꞌajꞌi boe mi ngaa sa èci! ");
INSERT INTO nfa_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","De ladhe nidhu se pamusu aa pabata èci dènge èci, tatu dhèu aae ra bisa boe rèdꞌu paredha dènge nèbhu. De maso boe asa dꞌara kahadhu, ladhe miu peka, na, Jaꞌa pake koasa nidhu ho bata eele hari nidhu. ");
INSERT INTO nfa_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sanèdꞌe paie! Dhèu miu kahèi dhu reꞌa magèle eele nidhu. Rèngu pake koasa nèti nidhu, do? Aadꞌo, si! De miu baku sadꞌi padhai lii di, dhu peka na, Jaꞌa ne pake koasa nidhu sèna ka bata eele si. Pe dhèu miu ka dhu pamaꞌète, peka na, ngaa dhu miu galaa ne, lèke boe. ");
INSERT INTO nfa_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Te ngaa ladhe Jaꞌa tareꞌa-reꞌa bata nidhu pake koasa Ama Lamatua, èèna dhu peka na, paredha Lamatua ètu katanga madha miu le. Paredha ne abhu le, te ngaa miu oe sèmi pameꞌa boe sa. ");
INSERT INTO nfa_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ladhe dhèu èra èci dènge rèka, dhu bori tèke ètu keja gꞌana-kariu madhenge èmu na, tatu mèdha-panyau na, dhèu bani boe lasi manaꞌu. ");
INSERT INTO nfa_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Te ngaa ladhe abhu dhèu dhu èra risi nèti nèngu mai segi ne, aa parame nèti rèka na. Hèia na parame nèti mèdha-panyau na kahèi, ho papala mi dhèu-dhèu na. Nèbhu nare sange neꞌe lamatua èmu èèna maena dhoka mi rèka na. Te ngaa limuri ne, na maena heka rèka na sèra. ");
INSERT INTO nfa_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Sanèdꞌe paie-iie! Dhèu dhu paꞌèci boe dènge Jaꞌa, nèngu musu Jaꞌa. Aa dhèu dhu soru-bara boe ètu dꞌara sasabꞌa Jaꞌa, nèngu neꞌa dhoka adꞌu-ue jꞌara maruru di.” ");
INSERT INTO nfa_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus tuhu hari lii Na, aku Nèngu na, “Ladhe èdhi bata eele nidhu nèti ca dhèu, nidhu ne rai laꞌe asa era kaliu, ho tenge era ae iisi. Lula na abhu boe era dhu pamèci dènge dadꞌèi na, hèia na pangee na, ‘Aah! Abhu boe era ae iisi, beꞌa risi jaꞌa lèpa hari asa dhèu dhu uru èèna jaꞌa pea.’ ");
INSERT INTO nfa_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ropa na lèpa, rage hari era uru èèna, dhu mèu le, aa dhu lalau pabeꞌa-beꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hèia nidhu ne laꞌe paroa angalai na pidhu dhu bhelu risi nèti nèngu. Ka aaꞌi-aaꞌi ra lasi pea ètu dhèu èèna, ka ra madahu ne. De lèpa limuri, mamuri dhèu ne asa aae ka ele iie.” ");
INSERT INTO nfa_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lodꞌo Yesus padhai lii era dènge dhèu ae sèra, dhèu bhèni èci ètu èèna paꞌoo, peka na, “Ina Mu oto kapai, lula nara iisi Èu, aa pasusu Èu!” ");
INSERT INTO nfa_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ka Yesus bꞌala ne, peka na, “Tareꞌa ina! Te ngaa dhu oto risi, nuka dhèu dhu pasa dhilu ho nanene Lii Holo-Nori Ama Lamatua aa tao madhutu!” ");
INSERT INTO nfa_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lodꞌo Yesus padhai lii era, dhèu oke rare Ne, hèia Na peka, “Dhèu limuri ne reꞌa dhoka adꞌu-ue bhabhelu di. Rèngu loe boe manèngi ho Jaꞌa tao tadha malaa hia rèngu, sèna ka reꞌa, na, Jaꞌa ne tareꞌa-reꞌa dhèu unu Lamatua. Te ngaa Lamatua dhu tao le tadha malaa uru èèna, re dhèu nèti lii padhai Na, nuka Yunus. Èèna na dꞌai le! ");
INSERT INTO nfa_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngaa dhu lèke mi dedha Yunus èèna, jꞌajꞌi tadha hia dhèu ètu kota Niniwe, peka na, Ama Lamatua ka dhu paleha ne mai. Èci èèna ka dènge Dhèu Rai-haha Tareꞌa-reꞌa ne. Ngaa dhu lèke mi Jaꞌa, èèna na jꞌajꞌi mi tadha hia dhèu limuri ne, dhu peka na, mema Ama Lamatua ka dhu pua Jaꞌa mai. ");
INSERT INTO nfa_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ladhe lodꞌo dꞌai èle rai-haha ne, ho Lamatua jꞌajꞌi ka Hakim, pe bhèni aae nèti balèu mamuri hari ho na jꞌajꞌi sakasii. Na pajꞌujꞌu ho galaa miu aaꞌi-aaꞌi mi dhu mamuri taa limuri ne, peka na, ‘Miu aaꞌi-aaꞌi mi se, goa!’ Te uru èèna, bhèni aae mai nèti jꞌara kajꞌèu, ho nèdhi dènge madha na, mamèu dhèu aae Soleman. Te ngaa limuri ne abhu Dhèu ètu talora aae miu, dhu kapai risi nèti dhèu aae Soleman. Te ngaa miu pusi boe Ne! ");
INSERT INTO nfa_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mesa boe nèngu di! Èèna na dhèu-dhèu nèti Niniwe kèdꞌi titu ho pajꞌujꞌu ai asa miu dhu mamuri limuri ne, peka na, ‘Miu aaꞌi-aaꞌi mi se, goa!’ Ra peka sèmi èèna, lula uru èèna, ropa Yunus laꞌe peka dadꞌèi Lamatua dènge rèngu, hèia ra ele-hoꞌa dènge. Masi ka Dhèu dhu kapai risi nèti Yunus ètu talora aae miu, te ngaa moꞌo boe ele-hoꞌa sa hèi.” ");
INSERT INTO nfa_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus tuhu hari lii padhai Na, aku Nèngu na, “Dhèu suru labhu, na padhèdi ètu era dhu dedha, sèna ka pasaraa dꞌara kama hia dhèu aaꞌi-aaꞌi dhu maso asa era èèna. Abhu ètu mia dhèu suru labhu, ho saguru ne dènge soe, sèna ka pahuni ne! Èèna guna boe ngaa-ngaa! ");
INSERT INTO nfa_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Musi madha miu èci èèna ka dènge labhu. Nèngu ka dhu pasaraa dꞌara miu. Ladhe musi madha maroga, dhèu ladhe ngaa aaꞌi-aaꞌi dènge dꞌara dhu maroga. Te ngaa ladhe musi madha mèu, dhèu rèdhi dènge dꞌara dhu beꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tenge jꞌara sèna ka saraa ètu dꞌara miu, jꞌajꞌi mèu aae sèmi saraa madha lodꞌo. Saraa ètu dꞌara miu, mage sèmi heo hèru, dhu padꞌelo dhoka mamaho di. ");
INSERT INTO nfa_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ladhe dꞌara miu saraa, abhu boe sasanga èci sa dhu maroga, tatu mamuri miu jꞌajꞌi mèu, nuka sèmi labhu aae dhu dꞌelo mamuri miu.” ");
INSERT INTO nfa_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus padhai lii nare, ka dhèu èci nèti partei agama Parisi nèru Ne, lasi raꞌa asa èmu na. Dꞌai dꞌara èmu èèna, ka Yesus madhèdi ètu mei raꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Te ngaa lamatua èmu ne malaa ladhe Yesus madhèdi naꞌa, dhu jꞌamo uru boe ai, madhutu atora dhèu Parisi. ");
INSERT INTO nfa_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ka Yesus lii dènge ne, peka na, “Eeh! Miu dhèu Parisi se seli-kolane! Miu kèpe paꞌèra atora agama miu! Miu bhèlu boe rase pega dènge galaa re liꞌu toke kaleꞌe, te ngaa sanèdꞌe boe ho pamèu dꞌara miu dhu kajꞌalu, dhu bhelu-katubꞌa dènge mangaꞌa dèu ngara! ");
INSERT INTO nfa_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Goa, ee! Baku bhèlu. Ama Lamatua ka dhu pajꞌajꞌi re liꞌu, aa tao re dꞌara kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Te ngaa dhu beꞌa risi eele, miu pala-bagi dhèu dènge boe unu sèra, nèti ngaa dhu miu unu, sèna ka miu mola ètu katanga madha Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Miu dhèu Parisi! Bèli-camèdꞌa miu dui mere mamadhe-mamopo! Ca pala nèti canguru pala dhu miu hia mi Lamatua, miu paꞌiga taruu nèti dhu ana iiki toke kapai. Toke bubhu-lara dhu ana iiki-iiki dꞌara oka, miu paꞌiga hèi! Te ngaa miu pusi boe dènge jꞌara dhu kapai risi. Jꞌara-jꞌara sasue mi Ama Lamatua, aa dènge boe bia cabèka, miu pabhèlu eele! Mema tareꞌa, èdhi hudꞌi hia ku pala Lamatua, te ngaa baku bhèlu kahèi dènge jꞌara-jꞌara dhu kapai risi sèra. ");
INSERT INTO nfa_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bèli-camèdꞌa miu dui mere mamadhe-mamopo! Te miu dꞌèi dhoka tenge era re madha ètu dꞌara èmu sabajꞌa, aa dꞌèi dhèu pakabꞌua miu ètu madha dhèu ae. ");
INSERT INTO nfa_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bèli-camèdꞌa miu dui mere mamadhe-mamopo! Te miu nuka sèmi roꞌa dhèu madhe dhu pamera le dènge rai. Dhèu kako re dedha, te ngaa reꞌa boe, na, ètu èèna na abhu roꞌa dhèu madhe, lula roꞌa èèna ètu dedha na tèdhi na mèu, te ngaa dꞌara na laho kao-kao. Masi ka madhutu adꞌa èdhi, ladhe dhèu jꞌèli lèke roꞌa dhèu madhe, pakajꞌalu ngiꞌu na, de nèngu nia boe maso asa dꞌara èmu sabajꞌa. Miu dhèu Parisi se, ca ropa dènge roꞌa dhèu madhe èèna! Re liꞌu, miu mèu titu kèna. Te ngaa ètu dꞌara miu pènu dènge kajꞌalu. Dhèu dhu padètu dènge miu, jꞌajꞌi mi kajꞌalu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ètu èèna, abhu ca dhèu dꞌèlu-mèu atora agama Yahudi. Ropa na tadèngi lii Yesus, ka bꞌala dènge, aku nèngu na, “Lii padhai Ama deo na, lèke mi dedha jiꞌi!” ");
INSERT INTO nfa_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Hèia Yesus bꞌala lii na, peka na, “Tareꞌa! Miu dhèu dꞌèlu-mèu agama Yahudi, hudꞌi dui mamadhe-mamopo kahèi! Miu soru boe dhèu ho pasamaa si, te ngaa miu asa pasusa si dènge jꞌara pabia atora agama miu. Ka miu pua dhèu sèra pasae rupa-rupa babia nèti atora miu sèra. Te ngaa miu mesa mi, moꞌo boe pasae babia ne dènge kacui-aai miu ca laa sa hèi! ");
INSERT INTO nfa_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bèli-camèdꞌa miu dui mere mamadhe-mamopo! Te miu bhute dhoka pudhi hadhu tao tugu hia dhèu rèti lii padhai Ama Lamatua dhu uru sèra, sèna ka pakabꞌua si. Te ngaa bèi-baki miu seꞌe ka dhu pamadhe si! ");
INSERT INTO nfa_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Miu èci èèna kahèi dènge bèi-baki miu sèra. Rèngu tule eele dhèu rèti lii padhai Lamatua, ka ra pamadhe si. Hèia miu dame hadhu roꞌa ho jꞌajꞌi tadha, peka na, miu se moꞌo kahèi dènge tatao bèi-baki miu. ");
INSERT INTO nfa_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nèti èèna ka, Ama Lamatua dhu neꞌa aaꞌi, peka nèdhi le, na, ‘Pe Jaꞌa pua dhèu rèti lii padhai Jaꞌa, dènge dhèu pajuu-paleha dhu leo, sèna ka lasi asa dhèu sèra. Hèia dhèu sèra kalabhe pajꞌèra cahagꞌe, aa cahagꞌe hari ra pamadhe si.’ ");
INSERT INTO nfa_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Dhèu taa limuri ne, hudꞌi tago rare tatao nèti dhèu-dhèu dhu pamadhe dhèu rèti lii padhai Lamatua. Sèra sa, mulai ige nèti Lamatua pajꞌajꞌi rai-haha ne, karèi nèti mamadhe Habel, toke dꞌai dhèu dhu limuri tèka, nuka Sakaria. Nèngu neꞌe ka dhu ra pamadhe ne ètu talora aae mei korban dènge Kama Mola-Mèci ètu dꞌara Èmu Kapua Manèngi-Mangajꞌi. Miu se kahèi pasae mere hahuku ra! ");
INSERT INTO nfa_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Miu dhèu dꞌèlu-mèu atora agama Yahudi! Bèli-camèdꞌa miu dui mere mamadhe-mamopo! Te miu dhu mèdꞌu gagoe ho bisa bhoke babèdho, sèna ka dhèu reꞌa mèu dadꞌèi Ama Lamatua. Te ngaa miu mesa mi maso boe asa dꞌara. Dhu karehe risi hari, miu pahèbꞌe dhèu, ho baku ra lasi asa èèna!” ");
INSERT INTO nfa_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Ropa Yesus padhai lii nare, ka mese agama dènge dhèu Parisi sèra jèke Ne. Karèi nèti lodꞌo èèna ka, rèngu karèi rupa-rupa jꞌara, sèna ka neo pamanahu Ne. Ra loe boe tenge jꞌara ho pabèbhe Ne. ");
INSERT INTO nfa_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lodꞌo èèna, abhu dhèu pèri-pèri riho dhu mai ho nanene lii padhai Yesus. Dhèu se mai pasuki, lingu rare Ne. Ka Na peka uru dènge ana madhutu Na, aku Nèngu na, “Jꞌaga ngiꞌu ho baku madhutu jꞌara mamuri dhèu Parisi. Te rèngu padhai lii leo, tao leo. ");
INSERT INTO nfa_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Rèngu sangaja beꞌa, te ngaa bèli-camèdꞌa abhu hui. Te aaꞌi-aaꞌi dhu pahuni ne, bèli-camèdꞌa sabhoka. ");
INSERT INTO nfa_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ngaa dhu deo neꞌe miu padhai pahuni, bèli-camèdꞌa dhèu tadèngi dènge mèu. Ngaa dhu miu paholo ètu dꞌara kama, èèna na dhèu peka paledꞌa ètu madha dhèu ae.” ");
INSERT INTO nfa_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ka Yesus tuhu hari lii Na, aku Nèngu na, “Ana-ana, ee! Mage miu madhaꞌu, ladhe dhèu neo pamadhe miu. Te rèngu pamadhe dhoka ngiꞌu aae di, te ngaa ra bisa boe tao ngaa mi samanga miu. ");
INSERT INTO nfa_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","De Jaꞌa neo peka, na, miu hudꞌi madhaꞌu mi cee ku. Miu hudꞌi madhaꞌu ku dènge Ama Lamatua. Te Nèngu ka dhu bisa pamadhe miu, aa pèci asa dꞌara ai naraka. De miu hudꞌi madhaꞌu tareꞌa-reꞌa mi Nèngu. ");
INSERT INTO nfa_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Miu pangee sèku, ana mangungu kabꞌua ca ngaa? Mura titu kèna! Lèmi ngiꞌu, dua doi, si? Masi ka sèmi èèna, te ngaa Ama Lamatua bhèlu boe ciꞌu sa hèi. ");
INSERT INTO nfa_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aa sèmi èèna kahèi, Lamatua tao ai-hèbꞌa mi miu. Lamatua neꞌa mèu, abhu rèu kètu pèri loa ètu kaba kètu miu. De miu baku madhaꞌu, te Lamatua pakabꞌua miu risi nèti ana mangungu ae-ae sèra.” ");
INSERT INTO nfa_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Èle ka, Yesus padhai lii dènge ana madhutu Na, aku Nèngu na, “Pasa dhilu miu paie-iie! Ladhe dhèu bani mangaku Jaꞌa ètu madha dhèu ae ètu rai-haha ne, pe Jaꞌa mangaku nèngu kahèi ètu madha ana pajuu Ama Lamatua ètu sorga, peka na, nèngu ne dhèu Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Te ngaa dhèu dhu padhai lii ètu madha dhèu rai-haha, peka na, nèngu tadhe boe Jaꞌa, bèli-camèdꞌa ètu madha ana pajuu Ama Lamatua ètu sorga, Jaꞌa tadhe boe nèngu kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jaꞌa ne, Dhèu Rai-haha Tareꞌa-reꞌa. Ladhe abhu dhèu dhu padhai pakarehe kolongara Jaꞌa, Ama Lamatua sadia ho pabhèlu eele sasala na era. Te ngaa ladhe na padhai pakarehe kolongara Roh Lamatua dhu Mola-Mèci èèna, Ama Lamatua bhèlu boe sasala na. ");
INSERT INTO nfa_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ladhe dhèu ère rèti miu asa era uri lii langu agama, do, rèti miu asa dhèu paredha, lula miu parcaya Jaꞌa, mage miu pangee, na, tasamia miu bisa siri iisi. ");
INSERT INTO nfa_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Te ètu dꞌara lai-lai èèna kahèi, Roh Ama Lamatua dhu Mola-Mèci èèna, peka dènge miu lii dhu pamèci ho bꞌala dhèu sèra.” ");
INSERT INTO nfa_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Èle èèna ka, ca dhèu nèti dhèu ae sèra, karèi Yesus, aku nèngu na, “Ama Mese! Peka ku dènge aꞌa ku, ho pabagi dènge jaꞌa pusaka ama jiꞌi.” ");
INSERT INTO nfa_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Te ngaa Yesus bꞌala ne, “Waa! Dhèu cee ka dhu dedꞌe Jaꞌa jꞌajꞌi hakim, sèna ka pamaꞌète lii langu miu sèmi èèna?” ");
INSERT INTO nfa_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hèia Yesus peka mi dhèu ae sèra, aku Nèngu na, “Sanèdꞌe, ee! Miu baku jꞌajꞌi dhèu mangaꞌa. Te kakaja-sasuꞌi bisa boe nèti mamuri dhu mera-milu.” ");
INSERT INTO nfa_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Èle ka, Na padhai lii pake lii pakasame, aku Nèngu na, “Dhèu kaja ca dhèu, isi oka na ae titu kèna. ");
INSERT INTO nfa_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ka èmu-èmu dhu tèka ngangaꞌa na pènu tao cacèci, aa risi eele hèi, ka neꞌa heka tao tasamia. ");
INSERT INTO nfa_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ka na pamaꞌète, peka na, ‘Jaꞌa neo tao sèmi neꞌe ka! Èmu era tèka ngangaꞌa dhu dhui se, jaꞌa sagꞌe eele ho patitu hari dhu kapai risi, sèna ka tèke ngangaꞌa nèti dꞌara oka dènge mèdha-panyau jaꞌa aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ladhe jꞌajꞌi ka sèmi èèna, jaꞌa pamaꞌète kore, na, “Gudꞌa pènu le! Ngangaꞌa tesa le, kuꞌa dꞌai tèu-tèu. De kuꞌa-kinu pakarejꞌe iisi dènge pacapa haga!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Te ngaa Ama Lamatua peka dènge ne, na, ‘Heeh! Dhèu goa! Mèda neꞌe kahèi, èu madhe. Aa cee ka dhu abhu aaꞌi isi gudꞌa èu sèra?’ ");
INSERT INTO nfa_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","De sèmi neꞌe! Bisa kahèi, dhèu pakaboko mèdha-panyau ae-ae ètu rai-haha ne hia ngiꞌu na, te ngaa ètu dꞌara ngangee Ama Lamatua, nèngu ne, dhèu unu aadꞌo, lula pabeꞌa boe dènge Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ka Yesus ajꞌa tabha hari ana madhutu Na, aku Nèngu na, “Miu mage dhoka pangee mamuri miu bèli-bèli, nèti ngangaꞌa-nganginu, do mèdha-papake. ");
INSERT INTO nfa_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Te mamuri èdhi ne risi nèti ngaa dhu èdhi taꞌa, aa ngaa dhu èdhi pake. ");
INSERT INTO nfa_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ladhe sèku lakaa! Rèngu sèra sèla boe, puu-gꞌètu boe, dènge boe gudꞌa ho tèke ngangaꞌa, te ngaa Ama Lamatua kabꞌoi si. Ladhe sèmi èèna, tatu Nèngu piara miu kahèi. Lula Na pakabꞌua miu risi nèti manu-bhui sèra. ");
INSERT INTO nfa_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sèmi dhèu titu ètu madha tèru, ho lalau iisi na, nèngu bisa pamadhera mamuri na, do? Aadꞌo, sina ma! ");
INSERT INTO nfa_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","De ladhe bhute dènge ngaa-ngaa dhu ana iiki sèra, dhu dènge boe kolo-kapua, tasamia hari ka miu bhute dènge madha jꞌara dhu kapai? Aꞌoto na ngaa? ");
INSERT INTO nfa_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ladhe sèku bunga dhu muri tabꞌa ètu dꞌara jꞌami. Rèngu sabꞌa boe oka-tedhe, aa ra manènu boe sigꞌi-rabhi. Te ngaa mèdha-papake dhèu aae Soleman dhu kabꞌua aae, saraga risi boe hela bunga dhu muri tabꞌa ètu dꞌara jꞌami sèra. ");
INSERT INTO nfa_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Te Ama Lamatua piara jꞌuꞌu dhu ana iiki-iiki dhu kabꞌua aadꞌo, dhu dhoka mamuri deo neꞌe, aa bèli madhe, ho dhèu core asa dꞌara ai. Ladhe sèmi èèna, na, Nèngu bisa kabꞌoi miu dhu kabꞌua risi eele nèti jꞌuꞌu sèra. De tasamia ka parcaya miu èra boe mi Lamatua? ");
INSERT INTO nfa_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sèmi èèna kahèi, miu baku bhute dènge ngangaꞌa-nganginu. Te èèna na, Lamatua uri hia miu. ");
INSERT INTO nfa_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dhèu dhu tadhe boe Lamatua, rèngu sèra sabꞌa toke madhe, sèna ka tao jꞌara sèra. Te ngaa miu baku sèmi rèngu, te Ama miu ètu sorga dhu neꞌa aaꞌi le ngaa dhu miu parluu. ");
INSERT INTO nfa_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Te ngaa pakako uuru ku sasabꞌa Ama Lamatua, pe Na uri jꞌara seꞌe hia miu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Hèia Yesus tuhu hari lii padhai Na, peka na, “Miu nuka sèmi cakaboko iiki kahibꞌi-kalèbho dhu èra boe. Te ngaa baku madhaꞌu! Te Ama miu ètu sorga, Dhèu Aae Kapai. Ngaa dhu unu Nèngu, Na hia mi ana-ana Na dènge dꞌara karejꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","De lami pahie mèdha-panyau miu, ho kabꞌua na pabagi dènge dhèu dhu dènge boe unu. Dènge sèmi èèna, miu tèke le mèdha-panyau miu ètu sorga ètu era dhu ele iie boe taa-taa. Dhèu manaꞌu bisa boe lasi manaꞌu rare. Ana cangèpi bisa boe paꞌele iie. ");
INSERT INTO nfa_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sanèdꞌe paie-iie! Mèdha-panyau miu ètu mia, na, dꞌara miu ètu èèna kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesus padhai lii hari, peka na, “Mèda-mèu miu musti bori mema dhari ho lalau Lamatua. Nuka sèmi ènu dhu beke, mate lamatua èmu na lèpa nèti pesta kabꞌi. Ropa lamatua na kadꞌeu babèdho èmu, nèngu bhoke dènge. ");
INSERT INTO nfa_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ladhe lamatua mai nèdhi dhèu sabꞌa se dhu mate tae-tae, tatu rèngu oto. Pe lamatua ra padꞌelo dꞌara beꞌa na mi rèngu. Na pake mèdha-papake dhèu sabꞌa, ho laꞌe lalau ngangaꞌa beꞌa, sèna ka hia dhèu sabꞌa seꞌe raꞌa-rinu. ");
INSERT INTO nfa_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dhèu sabꞌa se mema oto, lula rèngu ladhe-leru lamatua ra dènge beꞌa. Masi ka lamatua ra lèpa èmu hake pèri èèna ka, dꞌara talora mèda, do oe mèu, rèngu dhu bori mema dhari. ");
INSERT INTO nfa_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sanèdꞌe paie-iie! Ladhe abhu lamatua èmu dhu neꞌa mema hake pèri dhèu manaꞌu mai manaꞌu, tatu na soro tèke boe ho dhèu manaꞌu huki èmu na. ");
INSERT INTO nfa_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","De miu hudꞌi bori mema dhari, te ca dhèu sa dhu reꞌa boe pèri lodꞌo Dhèu Rai-haha Tareꞌa-reꞌa èèna mai hari.” ");
INSERT INTO nfa_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hèia Petrus karèi Yesus, peka na, “Ama Mese! Lii pakasame Ama deo na, lèke dhoka mi jiꞌi do, lèke mi dhèu aaꞌi-aaꞌi?” ");
INSERT INTO nfa_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Ka Yesus dhaa, na, “Lii pakasame deo na lèke mi dhèu aaꞌi-aaꞌi dhu tao sèmi kapala urusan dhu satia. Nèngu dꞌèlu-mèu uri jꞌara-jꞌara dhu beꞌa hia mi lamatua na. Te èèna na, lamatua na dedꞌe ne, sèna ka papala ngangaꞌa hia mi dhèu sabꞌa dhu leo sèra. Ladhe nèngu majꞌèni sabꞌe madhutu sasabꞌa na sèmi èèna, masi ka lamatua na mai sange mera mia èèna ka, te ngaa nèngu ne dhu loe boe tao jꞌara dhu lèke. Hèia na oto, lula lamatua na dedꞌe ne ho ladhe-leru mèdha-panyau na aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Te ngaa carui bagi kapala urusan dhu pangee, na, ‘Ele boe nèbhu ku, heka lamatua ne lèpa kèna.’ Hèia na kalabhe dhèu sabꞌa dhu leo sèra, mone dènge bhèni. Ka na madhèdi naꞌa-ninu dènge kea rae-rae toke mahu. ");
INSERT INTO nfa_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Te ngaa ca tèka kapala urusan ne neꞌa nare boe, cagꞌagꞌa laa, lamatua na lèpa. Ka lamatua na kalabhe ne, hèia babège eele ne, sèna ka sèmi nare pala na ètu liꞌu, palere-lere dènge dhèu dhu satia boe, tao madhutu dadꞌèi lamatua ra. ");
INSERT INTO nfa_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Te dhèu sabꞌa dhu reꞌa dadꞌèi lamatua ra, te ngaa paꞌèra boe tao madhutu, do, dꞌèi boe sabꞌe madhutu, bèli-camèdꞌa ra dui rare hahuku dhu bia. ");
INSERT INTO nfa_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Te ngaa dhèu sabꞌa dhu sabꞌe sale, lula reꞌa boe dadꞌèi lamatua ra, rèngu abhu boe hahuku dhu bia. Te dhèu dhu abhu ae, ra manèngi ae nèti nèngu kahèi. Dhèu dhu abhu sasabꞌa kapai, dhadhaa na kapai kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Èle èèna ka, Yesus tuhu hari lii padhai Na, aku Nèngu na, “Mamai Jaꞌa ne ho cèri eele dhèu Jaꞌa nèti dhèu leo ètu rai-haha ne. Neꞌe nuka sèmi dhèu pake ai, ho tunu eele maruru. Dadꞌèi Jaꞌa ka ladhe ai ne mulai heo ètu mia-mia. ");
INSERT INTO nfa_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Te ngaa uru nèti èèna, Jaꞌa hudꞌi pasae ku jꞌajꞌèra dhu bia. Jaꞌa bèli-camèdꞌa jꞌèra ae, toke dꞌai èle sasabꞌa-laꞌa Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Miu pangee, na, Jaꞌa mai kèti dame ètu rai-haha, do? Aadꞌo! Jaꞌa mai sèna ka tao dhèu rai-haha ne patao-palaha dènge mae-manyèla, lula lii holo-nori Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nèti deo neꞌe, dhèu dhu paꞌaꞌari mae-manyèla. Ètu dꞌara èmu cue, dhèu tèlu labꞌa dhèu dua, dua labꞌa tèlu. ");
INSERT INTO nfa_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ama labꞌa ana, ana labꞌa ama. Ina labꞌa ana; ana labꞌa ina. Teto labꞌa ana mantu; ana mantu labꞌa teto na.” ");
INSERT INTO nfa_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hèia Yesus lii dènge dhèu ae sèra, aku Nèngu na, “Ladhe miu mèdhi raꞌi-liru mèdhi aae cèu nèti haa, miu peka na, ‘Neꞌe, tadha èjꞌi oe mai kèna.’ Mema lèke sèmi èèna. ");
INSERT INTO nfa_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ladhe ngèlu balèu mai, miu peka na, ‘Neꞌe, tadha lodꞌo pana titu kèna.’ Mema tareꞌa sèmi èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Weeh! Miu dhèu leko-monya dhu padhai lii leo, tao leo! Miu dꞌèlu-mèu titu kèna meꞌa peka mia lodꞌo èjꞌi, aa mia lodꞌo pana aae. Te ngaa tasamia ka moꞌo boe meꞌa dènge dadꞌèi Lamatua ètu taa limuri ne?” ");
INSERT INTO nfa_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Ka Yesus tuhu hari lii Na, aku Nèngu na, “Ladhe miu tao lii langu, nga tao ka miu bisa boe pamaꞌète unu mi, mia dhu lèke! Beꞌa risi uri uuru ku dame! Mage dhoka miu dꞌai katanga madha hakim, ho na pamaꞌète, na, miu maso asa dꞌara bèdho. ");
INSERT INTO nfa_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Te ladhe sèmi èèna, miu bisa boe kalua, ladhe miu bꞌae mere mèka dedha dhu hakim pamaꞌète nare èèna.” ");
INSERT INTO nfa_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lodꞌo èèna, dhèu mai peka dènge Yesus, na, gubernur Pilatus pamadhe le dhèu Yahudi pèri-pèri nèti Galilea, lodꞌo dhu mai asa Yerusalem, rèti korban asa Èmu Kapua Manèngi-Mangajꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ropa tadèngi nare, ka Yesus karèi si, “Madhutu miu, na, tasamia? Dhèu dhu ra pamadhe sèra, sasala ra kapai risi nèti dhèu Galilea dhu leo aaꞌi-aaꞌi ra, do? Nèti èèna ka, ra huku pamadhe si, do? ");
INSERT INTO nfa_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aadꞌo! Te ngaa ladhe miu tèke eele boe mamuri miu dhu bhelu, ho lèpa madhutu dadꞌèi Lamatua, lodꞌo limuri miu laho nuka sèmi rèngu kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aa tasa mera mia hari dènge canguru aru dhèu dhu madhe ca hari ni, ropa ètu Siloam manara guri, hèia kabhie nare si, èèna? Sasala si ae risi nèti dhèu aaꞌi-aaꞌi ètu Yerusalem, do? ");
INSERT INTO nfa_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aadꞌo! Te ngaa ladhe miu tèke eele boe mamuri miu dhu bhelu, ho lèpa asa jꞌara Lamatua dhu mola, miu èèna na laho sèmi rèngu kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hèia Yesus peka lii pakasame èci, na, “Abhu ca dhèu dhu dènge ana aajꞌu ètu dꞌara oka na. Bèli-bèli, na laꞌe patigi, teko-teko ana aajꞌu ne hua le, do dhae. Te ngaa ana aajꞌu ne dhae hua mèka. ");
INSERT INTO nfa_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ka na pua dhèu sabꞌa ètu dꞌara oka, aku nèngu na, ‘Tèlu tèu kèna, jaꞌa laku-mai ho ladhe ana aajꞌu ne hua le, do dhae, te ngaa jaꞌa abhu boe ngaa-ngaa. De patue eele ne, te nèngu ne dhoka naꞌe era di.’ ");
INSERT INTO nfa_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Te ngaa dhèu sabꞌa ne dhaa, peka na, ‘Ama baku pasori ku. Hudꞌi nèbhu hari ku ciki laa dꞌai ca tèu sa. Pe jaꞌa kakèi rai reo kapua na, sèna ka tao pupuk, ho na sega. ");
INSERT INTO nfa_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ladhe dꞌai tèu mai nèi, ajꞌu ne hua, na beꞌa. Ladhe aadꞌo, laꞌa sina ma, patue eele ka laa.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ca tèka, lèke dènge lodꞌo sabajꞌa dhèu Yahudi, Yesus laꞌe ajꞌa dhèu ètu dꞌara èmu sabajꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ètu neꞌe abhu bhèni ca dhèu dhu kabodho kapoꞌo canguru aru tèu kèna, lula nidhu tao ne. Bhèni ne bisa boe pamola kabodho na. ");
INSERT INTO nfa_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ropa Yesus ladhe nèdhi, hèia Na paroa ne, aku Nèngu na, “Ina! Lamatua patalale le jꞌajꞌèra nèti èu.” ");
INSERT INTO nfa_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ka Yesus tao ai mi bhèni ne. Kacaꞌa laa, kabodho bhèni ne mola dènge kahèi. Hèia bhèni ne manèngi makasi, aa koa-kio kolongara Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Te ngaa kapala èmu sabajꞌa ne nasa, lula Yesus puri-paꞌèle dhèu lèke dènge lodꞌo sabajꞌa. Ka na peka dènge dhèu ae sèra, aku nèngu na, “Dꞌara ca migu, dhèu sabꞌa èna lodꞌo. De beꞌa risi dhèu pèdꞌa mai lèke dènge lodꞌo-lodꞌo sabꞌa sèra, sèna ka tenge dhèu puri-paꞌèle si. Baku mai lèke dènge lodꞌo sabajꞌa!” ");
INSERT INTO nfa_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Te ngaa Yesus bꞌala ne, “Heeh! Dhèu kapodꞌe-kabèli! Ètu dꞌara lodꞌo sabajꞌa, miu sabꞌa kahèi, si? Te miu lami patabuli sapi dènge keledꞌei miu, sèna ka hia raꞌa-rinu, si? ");
INSERT INTO nfa_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bhèni ne, ana-èpu Abraham sama sèmi èdhi. Dhèu aae nidhu pajꞌèra ne canguru aru tèu kèna. Ladhe Jaꞌa patabuli ne nèti nidhu, lèke dènge lodꞌo manèngi-mangajꞌi, na èèna sala, do?” ");
INSERT INTO nfa_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ropa tadèngi rare sèmi èèna, ka musu Yesus sèra makae. Te ngaa dhèu ae dhu leo sèra karejꞌe, lula sasabꞌa Na sèra beꞌa titu kèna. ");
INSERT INTO nfa_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ka Yesus peka hari, na, “Jaꞌa pasoro dhèu-dhèu Lamatua sèmi ngaa hari? ");
INSERT INTO nfa_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hiu-hiu èèna rèngu ciki di, te ngaa nèbhu-nèbhu ka rèngu asa tabha ae. Rèngu sèmi ajꞌu dhu lamusi na ana iiki-iiki. Dhèu sèle ne ètu dꞌara oka. Ka muri mai, hèia jꞌajꞌi ana aajꞌu dhu kapai aae. Èèna ka manu-bhui mai tao rèdꞌa ètu dadana na sèra.” ");
INSERT INTO nfa_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hèia Yesus padhai lii hari, peka na, “Jaꞌa pasoro dhèu unu Lamatua sèmi ngaa hari? ");
INSERT INTO nfa_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nèngu ne nuka sèmi ragi dhu dhèu bhèni nare, ho na pabꞌali dènge tarigu dua saku, sèna ka tao roti paꞌae. Lula ragi dhu ciki ooꞌe èèna, pabꞌali dènge tarigu ae-ae, hèia caꞌe aaꞌi. Dhèu unu Lamatua pangaru ra asa tabha kapai sèmi èèna kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Èle ka, Yesus si mulai kako lasi asa kota Yerusalem. Rèngu kako, lasi dhuli kota-kota dènge rae-rae, ho Na ajꞌa dhèu. ");
INSERT INTO nfa_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dꞌai era èci, ka ca dhèu karèi Ne, “Ama Mese! Ele boe dhèu ciki di, dhu abhu sodꞌa, do?” ");
INSERT INTO nfa_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ka Yesus bꞌala, aku Nèngu na, “Hèbꞌa maso asa sorga èèna, kobꞌo. De tenge jꞌara paie-iie, sèna ka miu bisa maso re èèna. Te abhu dhèu ae dhu sèku neo maso, te ngaa bisa boe. ");
INSERT INTO nfa_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ladhe lamatua èmu patèke le babèdho, èèna na miu titu ètu liꞌu, ho kadꞌeu babèdho, dènge paꞌoo manèngi, peka na, ‘Ama! Bhoke ku laa!’ Te ngaa na bꞌala, aku nèngu na, ‘Miu sèra, cee? Jaꞌa tadhe boe miu!’ ");
INSERT INTO nfa_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hèia miu peka hari, na, ‘Nga tao ka ama tadhe boe jiꞌi? Jiꞌi se ka dhu tema madhèdi ngaꞌa-nginu dènge ama. Aa ama kahèi dhu tema ajꞌa-nori jiꞌi ètu jꞌara oka-hoo jiꞌi.’ ");
INSERT INTO nfa_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hèia na peka, aku nèngu na, ‘Deo na jaꞌa dhu peka le, na, jaꞌa tadhe boe miu! Miu se, dhèu dhu tema adꞌu-ue bhabhelu di. De pakajꞌèu nèti neꞌe ne!’ ");
INSERT INTO nfa_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ladhe dꞌai lodꞌo Ama Lamatua pamaꞌète lii langu dhèu aaꞌi-aaꞌi ètu rai-haha ne, miu tangi roma iisi dènge kadhi ngutu lii kico-kico. Te miu ladhe mèdhi baki Abraham, Isak dènge Yakob, dènge dhèu aaꞌi-aaꞌi dhu rèti lii padhai Ama Lamatua, madhèdi le ètu sorga. Te ngaa miu lèke babège asa liꞌu. ");
INSERT INTO nfa_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pe dhèu mai nèti suu-suu rai-haha ne, nèti dhimu, nèti haa; nèti badae, nèti balèu, ho aaꞌi-aaꞌi ra madhèdi paꞌèci, raꞌa-rinu rame-rame ètu dꞌara èmu Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Patadhe pabeꞌa-beꞌa jꞌara neꞌe: ladhe dꞌai ka lodꞌo Lamatua pamaꞌète lii langu dhèu aaꞌi-aaꞌi ètu rai-haha ne, abhu dhèu dhu uru èèna, pangee, na, nèngu ana iiki dꞌai seli, aa te ngaa nèngu kabꞌua titu kèna. Aa abhu dhu uru èèna peka, na, nèngu dhèu kapai, te ngaa ètu madha Lamatua, nèngu dhoka ana iiki di.” ");
INSERT INTO nfa_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lodꞌo èèna, abhu dhèu Parisi pèri-pèri, mai paraga dènge Yesus, ka ra peka, na, “Hua iia Ama Mese pakajꞌèu nèti era neꞌe, te dhèu aae Herodes neo pamadhe Ama.” ");
INSERT INTO nfa_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Ka Yesus dhaa, aku Nèngu na, “Herodes ne, cakaraa badha dhu dꞌèlu-mèu kapodꞌe-kabèli. Lami peka dènge nèngu, na, Jaꞌa bata eele nidhu dènge paꞌèle dhèu nèti papèdꞌa-tarègu ra, deo neꞌe ne dènge bèli. Camèdꞌa ku, sasabꞌa Jaꞌa ne heka èle kèna. Masi ka tasa mera mia èèna ka, nèti kakako Jaꞌa asa Yerusalem ne, Jaꞌa neo sabꞌa hari ku ciki. Te dhèu Yerusalem sèra, dhu dꞌèi pamadhe dhèu rèti lii padhai Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Waa, dhèu kabarai Yerusalem, ee! Miu dhu loe boe pamadhe dhèu rèti lii padhai Ama Lamatua, aa pèci pamadhe dhèu pajuu-paleha sèra dhu mai padꞌelo jꞌara hia miu. Pèri-pèri hari le, Jaꞌa neo kaboko miu ho bhiri mi nèti bhelu-katubꞌa, nuka sèmi manu rena dhu sarimu nare ana na ètu dꞌara èla na. Te ngaa miu moꞌo boe. ");
INSERT INTO nfa_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Limuri ne, Lamatua pusi-pahae heka èmu manèngi-mangajꞌi miu. Bèli-camèdꞌa nèngu jꞌajꞌi èmu paꞌela. Èèna na, miu mèdhi heka Jaꞌa, toke miu dhaa, na, ‘Ama Lamatua hia mèngi-nale mi dhèu dhu mai nèti kolongara Ama Lamatua, lula Ama Lamatua ka dhu hia Na mai!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ca lodꞌo, lèke dènge lodꞌo manèngi-mangajꞌi, ca dhèu ama nèti partei agama Parisi nèru Yesus ho raꞌa-sisi ètu èmu na. Ropa Yesus madhèdi naꞌa, abhu dhèu dhu maꞌu, neo rèdhi Ne tao ngaa lèke dènge lodꞌo manèngi-mangajꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Lodꞌo èèna, ca dhèu dhu pèdꞌa boho madhèdi ètu èèna kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hèia Yesus karèi dhèu dꞌèlu-mèu atora Yahudi dènge dhèu Parisi dhu madhèdi raꞌa ètu sèra kahèi, aku Nèngu na, “Madhutu atora nèti baki Musa, bisa paꞌèle dhèu pèdꞌa lèke dènge lodꞌo sabajꞌa, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Te ngaa dhèu èci sa bhoka boe hèbꞌa. Hèia Yesus gai dhèu pèdꞌa ne, ka na èle dènge nèti papèdꞌa na. Ka Yesus pua dhèu ne, sèna ka lèpa ka. ");
INSERT INTO nfa_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Èle ka Yesus karèi hari si, peka na, “Ladhe ana èci manahu asa dꞌara èi lèke dènge lodꞌo sabajꞌa, miu lami ère eele ana neꞌe, do aadꞌo? Ladhe sapi manahu asa dꞌara èi laꞌe, miu soro tèke, do, lami kaso ne asa liꞌu? Tatu miu kaso ne asa liꞌu. De èèna, sasoa na, miu sabꞌa le, sina ma?” ");
INSERT INTO nfa_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ropa tadèngi lii padhai Yesus ne, èci sa bisa boe dhaa. ");
INSERT INTO nfa_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lodꞌo èèna, Yesus taru kira mi dhèu mai raꞌa-sisi ètu dꞌara èmu ne. Dhèu ae ka dhu dꞌèi era re madha, ho lasi madhèdi. Ropa nèdhi sèmi èèna, Yesus peka, ");
INSERT INTO nfa_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Sanèdꞌe, ee! Ladhe dhèu nèru miu asa pesta kabꞌi, mage lami madhèdi ka asa era dhèu aae-dhèu kapai. Mage dhoka lamatua pesta ne nèru tamu dhu kapai risi. ");
INSERT INTO nfa_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ladhe sèmi èèna, lamatua pesta mai gai èu, peka na, ‘Mage mu nasa kahèi, ama! Ama pidha sa kabodho, ee. Te jaꞌa tèke kadera ne hia dhèu kapai nèi.’ Hèia èu kèdꞌi dènge makae, tèke eele kadera ne, ka lamu madhèdi asa kabodho. ");
INSERT INTO nfa_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","De ladhe èu abhu nèru, lamu madhèdi ètu kadera re kabodho tèka. Ropa lamatua pesta ladhe nèdhi èu, na mai peka, ‘Ama! Mai madhèdi asa madha ne.’ Dènge jꞌara ne, miu abhu pakabꞌua ètu madha tamu aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Te dhèu dhu padedha iisi ra, èèna na Lamatua pahaha si. Te ngaa dhèu dhu tao iisi ra sèmi dhèu haha, èèna na Lamatua dedꞌe padedha si.” ");
INSERT INTO nfa_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Èle èèna ka, Yesus peka dènge lamatua èmu ne, “Lodꞌo leo, ladhe ama neo tao tatao, mage nèru dhoka aꞌari ama dènge dhèu kaja sèra mesa ra! Te tatu rèngu bisa nèru hari ama. ");
INSERT INTO nfa_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Te ngaa ladhe ama tao tatao, nèru dhèu dhu dènge boe ngaa-ngaa, dhèu haga roe cabèka, dhèu karuku, dènge dhèu bèdhu sèra. ");
INSERT INTO nfa_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tatu rèngu bꞌala rare boe ama. Te ngaa ladhe ama nèru si, Ama Lamatua ka dhu bꞌala ama. Ladhe dꞌai lodꞌo Ama Lamatua pamamuri hari dhèu-dhèu parcaya dhu madhe le, Na bhèlu boe babeꞌa ama.” ");
INSERT INTO nfa_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ropa tadèngi lii padhai lii Yesus ne, ca dhèu dhu madhèdi ca mei dènge Yesus, padhai lii, peka na, “Dhu karejꞌe risi ka, rèngu dhu madhutu raꞌa paꞌèci ètu dꞌara èmu Ama Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ka Yesus bꞌala, peka na, “Jaꞌa lolo sèmi neꞌe: abhu ca dhèu dhu tao tatao kapai. Hèia na nèru dhèu ae titu kèna. ");
INSERT INTO nfa_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ropa dꞌai tadha dhèu raꞌa-rinu, ka na pua ènu na, laꞌe paroa dhèu dhu ra nèru sèra, peka na, ‘Mai lati ka, te neo mulai pesta kèna.’ ");
INSERT INTO nfa_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Te ngaa dhèu seꞌe padhai lii rupa-rupa, sèna ka lasi boe asa dꞌara pesta. Ca dhèu peka sèmi neꞌe, ‘Jaꞌa heka hèli kore oka cue, de neo laku ladhe sèku. De mage nasa, te jaꞌa lake kore boe.’ ");
INSERT INTO nfa_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Dhèu leo hari peka na, ‘Jaꞌa heka hèli kore sapi maroo rai lèmi pasa. De jaꞌa neo laku cobꞌa si. Baku nasa, te jaꞌa lake kore boe!’ ");
INSERT INTO nfa_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Dhèu leo hari peka na, ‘Jaꞌa heka kabꞌi kèna, de bisa boe dhiu.’ ");
INSERT INTO nfa_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ka ènu ne, lèpa peka dènge lamatua na. Ropa tadèngi nare, ka nasa titu kèna. Hèia na paredha ènu na, aku nèngu na, ‘Ladhe sèmi èèna, èu lamu lai-lai! Lamu asa jꞌara-jꞌara, dènge asa sasanga jꞌara ètu kota neꞌe, sèna ka nèru dhèu dhu dènge boe ngaa-ngaa, dhèu kasia, dhu haga roe cabèka, dhu bèdhu, dènge dhèu-dhèu karuku sèra.’ ");
INSERT INTO nfa_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ropa tadèngi nare, laꞌe dènge ka nèru dhèu-dhèu sèra. Ka na lèpa hari, hèia na peka dènge lamatua na, aku nèngu na, ‘Ama! Dhèu se, ka seꞌe le. Te ngaa era madhèdi ae era.’ ");
INSERT INTO nfa_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hèia lamatua na peka, ‘Ladhe sèmi èèna, lamu hari asa rae-rae ètu liꞌu kota, toke dꞌai dꞌara oka sèi. Lamu pamako sadꞌi cee èèna ka, mèti si mai ho ra madhèdi papènu dꞌara pesta ne. ");
INSERT INTO nfa_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nanene, ee! Dhèu dhu pahae boe dènge lii nèru jaꞌa ne, rèngu se reꞌa boe babeꞌa tatao ne ciki sa hèi!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ka Yesus si lasi taruu asa Yerusalem. Dhèu ae madhutu Ne. Hèia Na kabibꞌa ladhe sa rèngu, ka Na peka, na, ");
INSERT INTO nfa_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Dhèu dhu tareꞌa-reꞌa neo madhutu Jaꞌa, nèngu hudꞌi sue ku Jaꞌa risi nèti ngaa-ngaa aaꞌi-aaꞌi ra; risi nèti ina-ama na, risi nèti dhèu èmu-kamali na, risi nèti ana niki na, risi nèti aꞌari na, aa risi-risi hari nèti ngiꞌu nèngu unu na. Ladhe aadꞌo, dhèu ne nia boe jꞌajꞌi ana madhutu Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te dhèu dhu dꞌèi boe pasae jꞌajꞌèra lula nèngu madhutu Jaꞌa, nèngu nia boe jꞌajꞌi dhèu Jaꞌa. Dhèu dhu neo jꞌajꞌi dhèu Jaꞌa, masi ka dhèu neo pamadhe ne, te ngaa nèngu pasae jꞌajꞌèra na taruu. ");
INSERT INTO nfa_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","De ladhe neo madhutu Jaꞌa, ngee pabeꞌa-beꞌa ku. Nuka sèmi dhèu neo tao èmu dhu dènge tadꞌa-tadꞌa. Nèngu hudꞌi ige uuru ku, ogo dꞌai lutu sela. Mage dhoka doi dꞌai boe. ");
INSERT INTO nfa_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ladhe ige boe paie-iie, ele boe dꞌai fanderen di, doi dhu aadꞌo heka le. Ladhe sèmi èèna, dhèu mari madhe aa pamakae ne hèi, ");
INSERT INTO nfa_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","peka na, ‘Miu ladhe ku dhèu neꞌe laa! Heka na sabꞌe fanderen kèna, te ngaa doi na saku aaꞌi le!’ ");
INSERT INTO nfa_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Conto dhu leo, nuka sèmi dhèu lasi pamusu. Dhèu aae dhu neo laꞌe pamusu hudꞌi madhèdi ku, sèna ka pareꞌa uuru ku dènge angalai na. Ladhe sordadꞌu rèngu dhoka canguru riho dhèu di, bisa segi musu dua nguru riho dhèu, do aadꞌo? ");
INSERT INTO nfa_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ladhe ige rare, te ngaa rèngu bisa boe segi, beꞌa risi lodꞌo musu dhu kajꞌèu era, ra pua dhèu lasi peka sèna ka uri padame. ");
INSERT INTO nfa_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sama sèmi èèna kahèi, dènge dhèu dhu neo madhutu Jaꞌa. Nèngu hudꞌi kali bagi ku laꞌe-mai, dhu peka na, nèngu dhu paꞌèra le tèke eele aaꞌi ngaa-ngaa, do aadꞌo? Te ladhe aadꞌo, na, dhèu neꞌe nia boe jꞌajꞌi ana madhutu Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Yesus tuhu lii padhai pake lii pakasame dhu leo hari, na, “Masi ne, beꞌa. Èdhi pake ne ho pabeꞌa ngangaꞌa. Te ngaa ladhe na sèro heka, jꞌajꞌi ngaa hari? Bisa heka pake ne, ho pabeꞌa ngangaꞌa. Neo tao mi pupuk, bisa boe kahèi. Dhodhoka core eele iia dꞌara di. Dhèu cee dhu dènge roꞌa dhilu, nanene paie-iie!” ");
INSERT INTO nfa_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lodꞌo èèna, dhèu roro bea dènge dhèu dhu laku-laku boe mai ae-ae asa Yesus, sèna ka nanene lii padhai Na. Te ngaa dhèu Yahudi peka, na, rèngu sèra dhèu karehe. ");
INSERT INTO nfa_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ropa rèdhi sèmi èèna, hèia dhèu Parisi dènge mese agama Yahudi sèra kaꞌuu-kamuki, peka na, “Huuh! Dhèu ne paꞌangalai dènge dhèu-dhèu dhu laku boe se. Ngaa hari Na madhèdi naꞌa-ninu dènge si!” ");
INSERT INTO nfa_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ropa tadèngi sèmi èèna, ka Yesus lolo dènge ra lii pakasame èci, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ladhe nèti miu abhu ca dhèu dhu unu kahibꞌi-kalèbho cangasu ngiꞌu. Ka ciꞌu ele. Na tao tasamia? Tatu na tèke eele dhu ceo nguru ceo se ètu era dhu beꞌa, aa laꞌe tenge dhu ele deo na, toke rage ne. ");
INSERT INTO nfa_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ropa nèdhi hari kahibꞌi-kalèbho ne, ka na pasae nèti, dènge karejꞌe-karae. ");
INSERT INTO nfa_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Dꞌai èmu, ka na paroa angalai na aaꞌi-aaꞌi, hèia na peka dènge si, ‘Mai, sèna ka karejꞌe dènge jaꞌa! Te kahibꞌi-kalèbho jaꞌa dhu ele èèna, kèdhi hari le.’ ");
INSERT INTO nfa_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ètu sorga, sèmi èèna kahèi. Ladhe ca dhèu dhu tao sala, hèia ele-hoꞌa, ka na lèpa hari asa Lamatua, ana kabarai sorga aaꞌi-aaꞌi ra karejꞌe-karae. Rèngu karejꞌe risi lula ca dhèu dhu lèpa hari asa Lamatua, nèti ceo nguru ceo dhèu dhu mamuri mola, dhu sala boe jꞌara.” ");
INSERT INTO nfa_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ka Yesus lolo hari lii pakasame dhu leo èci, peka na, “Abhu ca dhèu ina, dhu doi iia na canguru bua. Neꞌa na, dhu ele ca doi. Ka na tao tasamia? Tatu laꞌe suru labhu ho dꞌelo palème era, aa saku èmu ne dꞌai roꞌa kakilu, sèna ka tenge doi cue dhu ele ne. ");
INSERT INTO nfa_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ropa nèdhi hari doi ne, na paroa dènge dhèu dhu ètu baboa èmu na sèra, hèia na peka, aku nèngu na, ‘Miu mai, ho karejꞌe sama-sama dènge jaꞌa. Te doi jaꞌa cue dhu ele deo na, kèdhi hari le!’ ");
INSERT INTO nfa_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ètu sorga sèmi èèna kahèi. Ladhe abhu ca dhèu dhu tao sala, ka na ele-hoꞌa, ho lèpa hari asa Ama Lamatua, tatu ana pajuu ètu sorga aaꞌi-aaꞌi ra karejꞌe-karae.” ");
INSERT INTO nfa_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hèia Yesus tuhu hari lii padhai Na dènge lii pakasame kahèi, peka na, “Ama ca dhèu dènge ana mone na dhèu dua. ");
INSERT INTO nfa_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ca lodꞌo, ana limuri peka dènge ama na, aku nèngu na, ‘Ama! Hia ka pala jaꞌa nèti pusaka sèra, deo neꞌe ne kahèi!’ Hèia ama na bagi hia dua ra pusaka na, sèna ka èci-èci dènge pala ra. ");
INSERT INTO nfa_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nèbhu boe ka ana limuri ne pahie unu na. Hèia na lalau mèdha na, ka laꞌe asa rae kajꞌèu. Ètu era nèi, ana limuri ne pasaku aaꞌi-aaꞌi doi-dhari na, ho pakarejꞌe iisi. ");
INSERT INTO nfa_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ropa doi na èle aaꞌi mèu-mèu, rai ne dhu lèke manganga bia, ka mamuri ana ne jꞌèra dꞌai seli. ");
INSERT INTO nfa_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ka laꞌe tenge sasabꞌa. Hèia ca dhèu nèti kabarai èèna hia na pangaꞌa hahi. ");
INSERT INTO nfa_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Lula ana ne manganga dꞌai seli, ka neo naꞌa ngangaꞌa hahi se. Te abhu boe ca dhèu sa hia ne naꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nèbhu-nèbhu, ka na pangee laꞌe-mai, aku nèngu na, ‘Anga ee! Jaꞌa ètu neꞌe, oe madhe manganga kèna. Te ngaa ètu dꞌara èmu ama ku, dhèu sabꞌa raꞌa toke bècu. ");
INSERT INTO nfa_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","De beꞌa risi jaꞌa lèpa hari asa ama ku, ho peka dènge ne, “Ama! Jaꞌa tao le sala dhu kapai titu kèna, mi Lamatua dènge ama. ");
INSERT INTO nfa_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jaꞌa nia boe jꞌajꞌi ana ama ku. Hudꞌi laa ama sèmi more jaꞌa ne jꞌajꞌi mi kuli ètu dꞌara èmu ama, ngaa-ngaa tao boe!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ropa pangee nare sèmi èèna, hèia na kèdꞌi dènge ka, lèpa laꞌe asa èmu ama na. Nèti kajꞌèu era, ama na ladhe nèdhi le nèngu, ka ama na rasa kasia. Ka na puru nèti èmu, rai laꞌe soru nare ana dhu lèpa hari ne. Hèia na liku nare, ka uu ne. ");
INSERT INTO nfa_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Èle èèna ka, ana ne peka dènge ama na, aku nèngu na, ‘Ama! Jaꞌa ne tao le sala dhu kapai mi dedha Lamatua dènge ama ku. Jaꞌa nia heka jꞌajꞌi hari ana ama.’ ");
INSERT INTO nfa_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Te ngaa ama na paredha dènge ka dhèu-dhèu sabꞌa na, peka na, ‘Karohe! Lami mere kodho madhera dhu beꞌa risi, ho papake ne. Mere kadheli, ho pasaluu mi kacui-aai na. Aa papake salapa mi haga na. ");
INSERT INTO nfa_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lami ère mere sapi kabꞌoi èèna ho pare, te èdhi neo taꞌa-tinu rame-rame. ");
INSERT INTO nfa_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Lula ana jaꞌa ne, nuka sèmi dhu madhe le, te ngaa na mamuri hari. Nèngu dhu ele le, te ngaa jaꞌa abhu hari ne.’ Na padhai lii èle sèmi èèna, ka mulai raꞌa-rinu aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Lodꞌo èèna, ana uuru dhu aadꞌo ètu èmu, te na sabꞌa ètu dꞌara oka. Ropa na lèpa, nèti kajꞌèu era, na tadèngi le dhèu karihu musiik dènge roge-ledho. ");
INSERT INTO nfa_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ka na paroa nare dhèu sabꞌa ca dhèu, hèia na karèi, aku nèngu na, “Ee! Tao rarame ngaa ètu neꞌe?” ");
INSERT INTO nfa_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hèia dhèu sabꞌa ne dhaa, peka na, ‘Ari mu lèpa hari le. De ama mu pua pare sapi, sèna ka tao pesta kapai, te ana na lèpa hari dènge sodꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ropa tadèngi nare, hèia ana uuru ne pasaree. Na noꞌo boe maso asa dꞌara èmu. Ka ama na laꞌe rarange ne. ");
INSERT INTO nfa_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Te ngaa na kaꞌugu, peka na, ‘Ama! Pangee ku laa! Nèbhu nare sange neꞌe, jaꞌa sabꞌa toke èi kabhèsu hae, nuka sèmi kuli sa, hia mi ama. Jaꞌa ne keꞌa boe sisu dadꞌèi ama. Masi ka sèmi èèna, abhu mèka ama hia ana kahibꞌi ciꞌu, sèna ka jaꞌa pakarejꞌe dènge mone aanga-angalai jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Te ngaa ropa ana ama dhu bhera-lelu doi-dhari ama, ho laꞌe karihu dènge bhèni karehe, lèpa hari mai, ka ama pare sapi kabꞌoi na, tao pesta aae hia ne.’ ");
INSERT INTO nfa_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Te ngaa ama na bꞌala, aku nèngu na, ‘Ana pasue, ee! Nanene paie-iie. Nèbhu nare sange neꞌe, èu ne bera-bera dènge jaꞌa. Aaꞌi-aaꞌi dhu unu jaꞌa, sèra sa unu èu kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Te ngaa limuri ne, èdhi hudꞌi karejꞌe dènge karae ku, lula ari mu ca dhèu ne. Uru èèna, nuka sèmi dhu madhe le, te ngaa limuri ne mamuri hari. Nèngu dhu ele le, te ngaa abhu hari.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ka Yesus hia lii upama èci mi ana madhutu Na, peka na, “Dhèu kaja ca dhèu dhu dedꞌe dhèu sabꞌa na èci jꞌajꞌi kapala urusan. Te ngaa nèbhu-nèbhu, na tadèngi dhèu palolo, peka na, kapala urusan ne mulai kapodꞌe-kabèli ka parugi nèngu. ");
INSERT INTO nfa_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hèia dhèu kaja ne paroa kapala urusan na, ka peka dènge ne, ‘Èu ne, tasamia? Jaꞌa tadèngi, na, èu kapodꞌe mèdha-panyau jaꞌa. De lamu suri ku ngaa dhu èu adꞌu-ue ètu dꞌara sasabꞌa èu, ho jaꞌa parisa ku. Ladhe parisa kore, jaꞌa kalua eele èu.’ ");
INSERT INTO nfa_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ropa na tadèngi nare, hèia kapala urusan ne mulai pajiko, na, ‘Jaꞌa ne jꞌèra kèna! Jaꞌa neo sabꞌa ngaa hari? Pare rai, jaꞌa èra boe. Jꞌajꞌi dhèu hèbꞌa mènyi, jaꞌa makae. ");
INSERT INTO nfa_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ladhe jaꞌa sabꞌa heka ètu neꞌe, jaꞌa hudꞌi tenge jꞌara ku, sèna ka dhèu leo bisa hari sèmi rare jaꞌa ho sabꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nèti èèna ka, na paroa nare aaꞌi dhèu dhu pakèlu lamatua na. Na karèi dhèu uru, aku nèngu na, ‘Ee! Kèlu èu ca ngaa ètu lamatua jaꞌa?’ ");
INSERT INTO nfa_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Dhèu ne dhaa, peka na, ‘Jaꞌa dhu pakèlu èi lèngi saitun èpa riho liter.’ Hèia kapala urusan ne peka, na, ‘Tareꞌa. Sasuri pakèlu èu ka neꞌe. Ciu eele ka, madhèdi ho suri gati sasuri kèlu dhu hiu, peka na, kèlu èu dua riho liter di.’ ");
INSERT INTO nfa_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ka karèi dhèu pakèlu ka dua, peka na, ‘Aa èu hari, kèlu ca ngaa?’ Ka dhèu ne dhaa, na, ‘Jaꞌa pakèlu are, cariho karo.’ Hèia kapala urusan ne peka, na, ‘Ciu eele sasuri dhui èèna, ho suri dhu hiu hari, peka na, kèlu èu, aru ngasu karo di.’ ");
INSERT INTO nfa_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na tao sèmi neꞌe ka, toke lamatua na neꞌa tatao nèngu. Te ngaa lamatua ne hudꞌi mangaku, na, dhèu kapala urusan dhu bhelu ne mema mèu kapodꞌe-kabèli. De Jaꞌa lolo lii upama ne, sèna ka miu meꞌa, na, ladhe pasoro dènge dhèu parcaya, dhèu dhu parcaya boe dꞌèlu-mèu risi tenge jꞌara ho paꞌoto ngiꞌu ra ètu talora aae kabarai limuri ne. ");
INSERT INTO nfa_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Miu ngee sèku. Masi ka dhèu rai-haha ne karihu kajꞌalu re mèdha-panyau ra, te ngaa beꞌa risi miu pake mèdha-panyau miu sèra, ho soru-bara dhèu. Dènge jꞌara sèmi èèna, miu abhu angalai ae. Masi ka mèdha se èle, te ngaa bèli-camèdꞌa Lamatua tao tèke era hia miu ètu sorga. ");
INSERT INTO nfa_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ladhe dhèu mola ètu jꞌara dhu ana iiki, tatu na mola kahèi ètu jꞌara-jꞌara dhu kapai. Te ngaa ladhe dhèu mèu kapodꞌe ètu jꞌara dhu ana iiki, tatu na kapodꞌe kahèi ètu jꞌara dhu kapai. ");
INSERT INTO nfa_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ladhe dhèu parcaya heka miu, ho uri mèdha-panyau ètu jꞌara-jꞌara dhu ana iiki ètu rai-haha ne, tasamia ka Lamatua parcaya miu ètu jꞌara-jꞌara dhu kapai? ");
INSERT INTO nfa_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ladhe miu bisa boe uri mèdha-panyau dhèu leo, na, dhèu cee ka dhu bani ho hia miu mèdha-panyau ra? ");
INSERT INTO nfa_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Dhèu sabꞌa èci bisa boe nanene dua lamatua. Te aadꞌo na, nèngu dꞌèi boe èci, aa sue èci. Nèngu dꞌara kateme dènge ca dhèu, te ngaa pusi boe dènge èci. Sèmi èèna kahèi dènge miu. Te dhèu bisa boe sue Ama Lamatua palere dènge sue doi-dhari.” ");
INSERT INTO nfa_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lodꞌo èèna, abhu dhèu Parisi pèri-pèri dhu nanene lii padhai Yesus deo na. Ka ra sasei Ne, lula rèngu se dhèu mangaꞌa doi-dhari. ");
INSERT INTO nfa_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Te ngaa Yesus peka dènge si, “Masi ka miu pamèu iisi ètu madha dhèu, te ngaa Ama Lamatua neꞌa dꞌara bhelu miu. Abhu jꞌara ae dhu dhèu rai-haha dedꞌe padedha-dedha, te ngaa Ama Lamatua peka na, jꞌara sèra karehe, aa dhu madenge dènge rèngu. ");
INSERT INTO nfa_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Toke mamai Yohanis tuka sarani, èdhi dhèu Yahudi muri madhutu atora nèti baki Musa aa nèti dhèu rèti lii padhai Lamatua. Te ngaa limuri ne, Lii Lolo Beꞌa nèti Lamatua pale-lème le ètu mia-mia. Dhèu ae dhu tenge le jꞌara, sèna ka ra mamuri madhutu dadꞌèi Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Masi ka dedha-liru dènge rai-haha ne ele, te ngaa Atora nèti Ama Lamatua ciki sa, ele boe. Ca katèdꞌa sa ele boe hèi! ");
INSERT INTO nfa_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dhèu dhu paꞌia-paꞌela dènge dhèu èmu na, aa na madhèdi hari dènge bhèni leo, nèngu bersina. Aa dhèu dhu leo dènge bhèni dhu paꞌia-paꞌela, nèngu bersina kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ka Yesus lole tabha hari, peka na, “Abhu dhèu kaja ca dhèu. Nèngu dꞌèi pake mèdha-papake dhu beꞌa-beꞌa, tao nèti bèla alus. Mèu-mèda naꞌa-ninu ngangaꞌa dhu beꞌa hua, aa karae taruu. ");
INSERT INTO nfa_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ètu kota neꞌe, abhu kahèi ca dhèu dhu dènge boe ngaa-ngaa. Ngara na, Lasarus. Ngiꞌu na dhu pènu dènge kamèu. Bèli-bèli angalai na rèti pamadhèdi ne ètu hèbꞌa tedhe dhèu kaja èèna. ");
INSERT INTO nfa_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Na sanao teko-teko abhu kahaꞌi ngangaꞌa nèti dhèu kaja ne, sèna ka bisa naꞌa, te ngaa na abhu boe ngaa-ngaa. Dhoka busa di mai, ho jꞌore nana kamèu na. ");
INSERT INTO nfa_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nèbhu boe ka, Lasarus madhe. Hèia ana pajuu Ama Lamatua mai nèti sorga, ka rèti lasi pamadhèdi ne ètu baboa Abraham. Aa nèbhu boe ka, dhèu kaja ne madhe kahèi, ka dhèu dedꞌe lasi padhane. ");
INSERT INTO nfa_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Te ngaa dhèu kaja ne maso boe sorga. Nèngu maso asa dꞌara naraka, sama-sama dènge dhèu-dhèu leo dhu madhe le. Ètu era nèi, dhèu kaja ne abhu jꞌajꞌèra taa-taa. Ca tèka na boti kètu, ka ladhe nèdhi Lasarus madhèdi ètu baboa baki Abraham. ");
INSERT INTO nfa_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hèia na paꞌoo, peka na, ‘Baki Abraham, ee! Sue ku jaꞌa laa! Pua ku Lasarus cèbꞌu kolo ai na asa dꞌara èi, sèna ka mai pabasa ku kolo heꞌo jaꞌa ne. Te jaꞌa jꞌèra titu kèna ètu dꞌara ai naraka ne!’ ");
INSERT INTO nfa_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Te ngaa Abraham dhaa, peka na, ‘Ana, ee! Sanèdꞌe ku! Uru èèna lodꞌo èu mamuri era ètu rai-haha nèi, èu abhu le aaꞌi-aaꞌi dhu beꞌa. Te ngaa Lasarus ne, unu dhodhoka sasusa di. Ka limuri ne, Lamatua pakarejꞌe ne ètu neꞌe, te ngaa èu pasae more jꞌajꞌèra. ");
INSERT INTO nfa_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Risi-risi hari, ètu talora aae èu dènge jiꞌi, Lamatua tao tèke loe aae èci dhu taleo dènge marèma. De dhèu nèti neꞌe bisa boe dhiu asa era èèna, aa dhèu nèti èèna bisa boe pège sa neꞌe mai.’ ");
INSERT INTO nfa_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hèia dhèu kaja ne pamako hari, aku nèngu na, ‘Ladhe sèmi èèna, baki Abraham pua Lasarus laꞌe asa èmu ama ku. ");
INSERT INTO nfa_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Te jaꞌa ne dènge ari dhèu mone, dhèu lèmi era. Sèna ka Lasarus laꞌe pasanèdꞌe si, ho ra lèpa ka asa Lamatua. Masi ka lodꞌo dꞌai ra madhe, rèngu maso ia ka asa era jꞌajꞌèra ne.’ ");
INSERT INTO nfa_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Te ngaa Abraham bꞌala ne, ‘Ama Lamatua hia le rèngu sasuri nèti baki Musa dènge dhèu rèti lii padhai Na. Ari mu si, bisa baca pahari-pahari ho reꞌa dadꞌèi Lamatua.’ ");
INSERT INTO nfa_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Te ngaa dhèu kaja ne pasisu, peka na, ‘Baki Abraham, ee! Èèna dhae dꞌai mèka. Rèngu sèi pahae boe Lii Holo-Nori Ama Lamatua! Hudꞌi abhu ku ca dhèu nèti talora dhèu madhe laꞌe asa rèngu, heka rèngu ele-hoꞌa, aa neo nanene kèna.’ ");
INSERT INTO nfa_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Te ngaa Abraham dhaa, peka na, ‘Ladhe rèngu sèi roꞌo boe nanene lii holo-nori nèti Musa dènge nèti dhèu rèti lii padhai Lamatua, na, masi ka dhèu madhe bhodho nèti dꞌara roꞌa ra, ho padhai lii dènge rèngu èèna ka, rèngu roꞌo boe nanene.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus peka dènge ana madhutu Na, “Ae ka dhèu manahu asa dꞌara sasala, lula tatao dhèu leo. Te ngaa dhèu dhu pamanahu dhèu asa dꞌara sasala èèna, pasae nare mamadhe-mamopo. ");
INSERT INTO nfa_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ladhe dhèu adꞌu-ue jꞌara karehe, toke ana iiki parcaya boe Jaꞌa, èèna na Ama Lamatua huku ne bia. Dhu samaa risi, ladhe èki ladha goro dhèu neꞌe dènge hadhu aae cue, ho parèu eele asa dꞌara dhasi ètu talora lèu. ");
INSERT INTO nfa_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","De jꞌaga ngiꞌu pabeꞌa-beꞌa, sèna ka miu baku pamanahu dhèu asa dꞌara sasala! Te ngaa ladhe aꞌari mu tao sala, pasanèdꞌe ne. Ladhe na ele-hoꞌa, hèia na mai manèngi abho, na pabhèlu eele sasala na. ");
INSERT INTO nfa_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ladhe aꞌari èu tao sala pidhu hari dꞌara ca lodꞌo, ka na ele-hoꞌa, hèia na mai pidhu hari ho manèngi abho, èu hudꞌi pabhèlu eele sasala na pidhu hari kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ca lodꞌo, ana madhutu se mai asa Yesus, ka ra manèngi, aku rèngu na, “Ama Mese! Parcaya jiꞌi se èra boe. De Ama paꞌèra ku parcaya jiꞌi.” ");
INSERT INTO nfa_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Hèia Yesus dhaa, peka na, “Ladhe miu parcaya koasa nèti Ama Lamatua, masi ka ciki ooꞌe èèna ka, te ngaa miu bisa paredha ajꞌu aae ne, ‘Tahoi eele, ho pidha asa dꞌara dhasi!’ Ka ajꞌu ne madhutu lii paredha miu.” ");
INSERT INTO nfa_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Èle ka Yesus lii, aku Nèngu na, “Tare conto èci. Nuka sèmi ènu dhu pare rai ètu dꞌara oka, do, ladhe kahibꞌi-kalèbho ètu dꞌara padꞌa sodꞌa. Sabꞌa nare, ka lèpa sa èmu. Tatu lamatua na peka boe dènge ne, ‘Mai ho dua ti taꞌa sama-sama!’ ");
INSERT INTO nfa_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aadꞌo, sina ma? Dhu lèke ka, lamatua paredha ne, peka na, ‘Lamu lalau mei hia jaꞌa. Kuꞌa-kinu kore ku, pe èu muꞌa-minu ètu kabodho nèi!’ ");
INSERT INTO nfa_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ladhe ènu ne lalau nare madhutu dadꞌèi lamatua na, miu ngee, na, lamatua ne manèngi makasi mi ènu ne, do? Aadꞌo! ");
INSERT INTO nfa_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Miu èci èèna kahèi. Ladhe sabꞌa mere aaꞌi dhu Lamatua paredha le, miu peka na, ‘Jiꞌi dhoka ana pua-paleha di. Jiꞌi tenge boe lii koa-kadꞌiri. Jiꞌi dhoka pakako sasabꞌa-laꞌa jiꞌi di.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lodꞌo Yesus si lasi asa Yerusalem, rèngu dꞌai too propensi Galilea dènge propensi Samaria. ");
INSERT INTO nfa_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ropa rèngu neo maso asa dꞌara rae cue ètu èèna, dhèu canguru dhu pèdꞌa kusta mai, neo paraga dènge Yesus. Rèngu se titu nèti kajꞌèu. ");
INSERT INTO nfa_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ka ra paꞌoo palere-lere, peka na, “Yesus! Mone Kapai, ee! Sue ku jiꞌi laa!” ");
INSERT INTO nfa_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ropa Yesus tadèngi lii paꞌoo ra, ka Na ladhe si, hèia Na pua, aku Nèngu na, “Lami padꞌelo uuru ku isi miu asa ama agama, sèna ka ra parisa papèdꞌa kusta miu sèra, èle le, do dhae!” Ra tadèngi sèmi èèna, ka lasi dènge. Te ngaa ropa dꞌai talora jꞌara, cagꞌagꞌa laa, rèngu dhu èle le nèti kusta. ");
INSERT INTO nfa_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Rèngu lasi taruu dènge karejꞌe-karae. Te ngaa abhu ca dhèu di, dhu lèpa hari mai asa Yesus. Na paꞌoo, peka na, “Koa-kio Lamatua! Te jaꞌa èle le nèti papèdꞌa!” ");
INSERT INTO nfa_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hèia na patitu kètu urutuu na, ho manèngi makasi ae-ae mi Yesus. (Teꞌa boe, te nèngu ne dhèu Yahudi boe. Nèngu ne ca dhèu Samaria dhu loe boe tao lii langu dènge dhèu Yahudi.) ");
INSERT INTO nfa_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ka Yesus karèi dhèu sèra dhu madhutu dènge Ne, aku Nèngu na, “Tasamia, ee? Deo na Jaꞌa paꞌèle dhèu canguru si? Dhu ceo, mia lasi? ");
INSERT INTO nfa_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tasamia ka dhoka dhèu leo kara neꞌe di, dhu lèpa mai ho manèngi makasi mi Ama Lamatua, dènge koa-kio kolongara Na?” ");
INSERT INTO nfa_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hèia Na peka mi dhèu ne, na, “Èu èle le, lula èu parcaya Jaꞌa tareꞌa-reꞌa. De kèdꞌi, lèpa ka dènge sodꞌa-mole!” ");
INSERT INTO nfa_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Ca lodꞌo, dhèu Parisi pèri-pèri mai karèi Yesus, peka na, “Ama Mese! Peka ku dènge jiꞌi, lodꞌo mia Ama Lamatua neo pakako paredha Na?” Ka Yesus dhaa, “Sèmi neꞌe. Mage mi pangee, na, Lamatua pakako paredha Na dènge rupa-rupa tadha ètu rai-haha ne, dhu dhèu bisa rèdhi dènge musi madha ra. Dhèu abhu boe tadha dhu peka na, ‘Ladhe ku asa neꞌe mai! Te Ama Lamatua pakako paredha Na ètu neꞌe!’ Do, ‘Na pakako paredha Na ètu nèi!’ Aadꞌo! Te Na pakako paredha Na ètu talora aae miu, ètu dꞌara dhèu aaꞌi-aaꞌi ra.” ");
INSERT INTO nfa_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hèia Yesus peka dènge ana-ana madhutu Na, “Nèbhu boe, na, Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, paꞌèci heka dènge miu. Dꞌai ka lodꞌo jꞌajꞌèra sèra, miu dꞌèi titu kèna neo mèdhi mamai hari Jaꞌa. Te ngaa dꞌai mèka lodꞌo mamai Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ladhe èèna na dhèu mai peka, na, ‘Kristus ètu neꞌe!’ do, ‘Kristus ètu nèi!’ Na, miu baku bhute ho patangi-tenge, te lii padhai rèngu sèra, kapodꞌe-kabèli. ");
INSERT INTO nfa_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Te ladhe Dhèu Rai-haha Tareꞌa-reꞌa ne, lèpa hari mai, tadha na dhu mèu aadha-aadha, nuka sèmi bela dhu heo kacèbꞌa ètu dedha-liru nèti suu asa suu. ");
INSERT INTO nfa_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Te ngaa Nèngu hudꞌi abhu uuru ku jꞌajꞌèra rupa-rupa. Ka dhèu rai-haha taa limuri ne, roꞌo boe nanene, aa neo tule eele Ne. ");
INSERT INTO nfa_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Te ngaa bèli-camèdꞌa, ladhe Na neo mai hari, dhèu mamuri karehe sama biasa, èci èèna ka dènge lodꞌo Noh mamuri era. ");
INSERT INTO nfa_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Taa èèna, rèngu raꞌa-rinu, tao pesta kabꞌi toke lodꞌo Noh maso asa dꞌara kapa na. Te ngaa rèngu roꞌo boe nanene kahèi. Kacaꞌa laa, èi aae lala, ka pamadhe aaꞌi si. ");
INSERT INTO nfa_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Sèmi èèna kahèi, lodꞌo Lot mamuri era, dhèu mamuri karehe titu kèna. Taa èèna, rèngu raꞌa-rinu, badꞌaga, sabꞌa oka-tedhe, patitu èmu, aa mamuri karehe sèmi biasa. ");
INSERT INTO nfa_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Te ngaa roꞌo boe nanene kahèi. Hèia madꞌae aae era, ropa Lot rai eele nèti kota Sodom, cagꞌagꞌa laa, èjꞌi ai dènge èi nasu bhori mai nèti dedha-liru, aa labhu pakèpu rèngu aaꞌi-aaꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","De miu baku pamudꞌe ku! Mage dhoka bèli-camèdꞌa Dhèu Rai-haha Tareꞌa-reꞌa ne, lèpa hari mai, dhèu mamuri dhoka sèmi biasa di. Te ngaa kacaꞌa laa, Na cèu mai. ");
INSERT INTO nfa_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lodꞌo èèna, dhèu ètu madha èmu, maso ia ka asa dꞌara ho lalau mèdha. Dhèu dhu sabꞌa ètu dꞌara oka, lèpa ia ka asa èmu ho rare mèdha ra. ");
INSERT INTO nfa_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sanèdꞌe ku ngaa dhu uru èèna jꞌajꞌi mi dhèu èmu Lot. Na madhe, lula nèngu ngee mèdha-panyau ètu èmu na. ");
INSERT INTO nfa_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dhèu dhu dꞌèi boe madhutu Jaꞌa lula sue ngiꞌu na, èèna na mamuri na ele iia dꞌara. Te ngaa dhèu dhu madhutu Jaꞌa toke soro mamuri na, lula sue Jaꞌa, bèli-camèdꞌa abhu sodꞌa-mole, aa mamuri taa-taa dènge Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jaꞌa pasanèdꞌe mema! Ropa Dhèu Rai-haha Tareꞌa-reꞌa ne, lèpa hari mai, ladhe dhèu dua jꞌunu ètu era èci, kabèdhi laa Lamatua dedꞌe pacaꞌe ca dhèu, aa tèke eele ca dhèu. ");
INSERT INTO nfa_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ladhe abhu dhèu bhèni dhèu dua dhu majꞌu are, èèna na Lamatua dedꞌe pacaꞌe ca dhèu, aa tèke eele ca dhèu. ");
INSERT INTO nfa_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ladhe abhu dhèu dua dhu sabꞌa ètu dꞌara oka, Lamatua mai dedꞌe nèti èci, aa tèke eele ca dhèu.” ");
INSERT INTO nfa_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ropa ana madhutu tadèngi rare, hèia ra karèi Yesus, “Ama Mese! Sèra sa bèli-camèdꞌa jꞌajꞌi ètu mia?” Ka Yesus core lii, peka na, “Sèmi neꞌe! Ladhe miu mèdhi ka manu-bhui dhu tema raꞌa sisi badha madhe, ra lela paꞌoru ètu mia, na, miu meꞌa èèna jꞌajꞌi mi tadha, dhu peka na, tatu abhu sisi hèu ètu era èèna.” Dènge sasoa dhu pahuni, peka na, ladhe Yesus Kristus lèpa hari mai, tadha na dhu mèu aadha-aadha, sadꞌi dhèu reꞌa baca tadha sèra. ");
INSERT INTO nfa_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ca tèka, Yesus padhai lii dènge ana madhutu Na, pake lii pakasame ho rèngu loe boe manèngi-mangajꞌi, aa baku maꞌète sanao-maena. Rèngu hudꞌi parcaya taa-taa Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Lii lolo na sèmi neꞌe ka: “Ètu dꞌara kota cue, abhu ca dhèu ama pamaꞌète lii langu, dhu pusi-pahae boe Ama Lamatua. Na pahae boe ca dhèu sa hèi. ");
INSERT INTO nfa_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ètu era èèna, abhu kahèi bhèni balu èci, dhu loe boe mai sa dhèu pamaꞌète lii ne, ho manèngi, peka na, ‘Ama hakim! Jꞌue ku lii langu jaꞌa dènge mola!’ ");
INSERT INTO nfa_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Hiu-hiu èèna, dhèu pamaꞌète lii ne pusi boe dènge bhèni balu ne. Te ngaa nèbhu-nèbhu ka, na roca nanene ne. Hèia na madhèdi pangee ka, ‘Mema jaꞌa ne pusi boe dènge Ama Lamatua, risi-risi dènge dhèu rai-haha. ");
INSERT INTO nfa_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Te ngaa bhèni ne pakaboꞌo kètu jaꞌa. De beꞌa risi jaꞌa pamaꞌète lii na dènge mola. Te ladhe jaꞌa panena, na mai taruu pajꞌèra jaꞌa.’ ");
INSERT INTO nfa_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","De miu pangee ku lii padhai dhèu pamaꞌète lii dhu bhelu ne. ");
INSERT INTO nfa_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ladhe nèbhu-nèbhu dhèu pamaꞌète lii ne tao ai-hèbꞌa mi bhèni balu ne, tatu Ama Lamatua kahèi neo tao ai-hèbꞌa mi dhèu unu Na dhu sabajꞌa mèu-mèda mi Nèngu ho manèngi sasue Na. Te ngaa Lamatua mate heka panèbhu. ");
INSERT INTO nfa_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Te Nèngu uri lii langu rèngu dènge boe pamata. De Jaꞌa neo karèi sèmi neꞌe: ladhe Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne mai hari, Jaꞌa bisa paraga dènge dhèu parcaya ètu rai-haha ne era, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ka Yesus lolo tabha hari pake lii pakasame lula-nèti dhèu dhu pangee na neꞌa aaꞌi mèu-mèu, aa dhu dꞌèi pahaha dhèu leo. Na peka na, ");
INSERT INTO nfa_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Abhu ama dhèu dua dhu lasi sabajꞌa asa dꞌara Èmu Kapua Manèngi-Mangajꞌi. Ca dhèu nèti partei agama Parisi, aa èci hari dhèu roro bea. Dhèu Yahudi peka na dhèu Parisi sèra, dhèu dhu mola. Te ngaa ra pangee, na, dhèu roro bea, dhèu karehe. ");
INSERT INTO nfa_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Dꞌai èmu sabajꞌa dhèu Parisi ne titu mesa-mesa na, ka na manèngi-mangajꞌi, peka na, ‘Makasi Lamatua, te jaꞌa ne dhèu beꞌa. Jaꞌa ne bhelu boe nuka sèmi dhèu leo sèra. Jaꞌa manaꞌu boe. Jaꞌa mangaꞌa boe. Jaꞌa dhèu dhu bersina boe. Makasi Lamatua, te jaꞌa ne bhelu boe nuka sèmi dhèu roro bea ne. ");
INSERT INTO nfa_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jaꞌa ne majꞌèni puasa ca migu dua hari. Aa jaꞌa dꞌèi hia ca pala nèti canguru pala nèti aaꞌi-aaꞌi dhu jaꞌa abhu.’ Dhèu Parisi ne, sabajꞌa sèmi èèna ka. ");
INSERT INTO nfa_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Te ngaa dhèu roro bea ne titu pakajꞌèu ètu kabodho nèi. Na bani boe boti kètu ho ladhe sa dedha. Nèngu dhoka pacudꞌu di, dhu dènge dꞌara maꞌète mae-mae. Na sabajꞌa, peka na, ‘Ama Lamatua! Sue ku jaꞌa, dhèu dhu pènu dènge sasala-sasigo ne! Abho eele ku sasala jaꞌa!’ ");
INSERT INTO nfa_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Lodꞌo dhèu dua se lèpa lasi asa èmu ra, cee ka dhu pabeꞌa dènge Ama Lamatua? Dhèu Parisi dhu pamone, do dhèu roro bea ne? Tatu Na sèmi dènge beꞌa, dhèu roro bea dhu pahaha iisi ne. Te ngaa Na pusi boe dènge dhèu Parisi ne. Te Ama Lamatua pahaha dhèu dhu pamone-pabhèni, te ngaa Na padedha dhèu dhu reꞌa pahaha iisi.” ");
INSERT INTO nfa_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ca tèka, dhèu saꞌu rèti ana ra dhu rara iisi hiu asa Yesus, sèna ka Na tao ai Na mi ana iiki se, aa padhai lii hia si mamèngi. Ropa rèdhi sèmi èèna, ana-ana madhutu Yesus kai dhèu seꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Te ngaa Yesus soru mamai ra dènge beꞌa. Hèia Na kai ana-ana madhutu Na, aku Nèngu na, “Hudꞌi laa ana iiki sèra mai asa Jaꞌa. Miu baku bhabhae si. Sanèdꞌe paie! Dhèu dhu neo jꞌajꞌi dhèu unu Ama Lamatua, nèngu hudꞌi sanao-maena dhoka mi Ama Lamatua, nuka sèmi ana iiki dhu sanao-maena dhoka mi ina-ama na.” ");
INSERT INTO nfa_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ca lodꞌo, dhèu kapai Yahudi èci, mai karèi Yesus, aku nèngu na, “Ama Mese dhu hua iia! Jaꞌa ne hudꞌi tao ku tasamia, sèna ka jaꞌa keꞌa tareꞌa, na, jaꞌa maso sorga, aa mamuri taruu dènge Ama Lamatua?” ");
INSERT INTO nfa_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ka Yesus dhaa, “Tasamia ka èu ne peka na, Jaꞌa ‘dhu hua iia’? Dhodhoka èci di dhu hua iia, nuka Ama Lamatua. ");
INSERT INTO nfa_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Èu meꞌa le atora Ama Lamatua karèi nèti uru ka, dhu peka na: Baku jꞌunu paꞌèci dènge dhèu dhu dhèu èmu boe èu; baku pamadhe dhèu; baku manaꞌu; baku jꞌajꞌi sakasii dhu leko-monya; aa pakabꞌua ina dènge ama mu.” ");
INSERT INTO nfa_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ka dhèu ne dhaa, na, “Tareꞌa, Ama! Jaꞌa dhu madhutu le atora sèra, karèi nèti jaꞌa ana iiki era.” ");
INSERT INTO nfa_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tadèngi sèmi èèna, ka Yesus peka, na, “Beꞌa! Te ngaa èu kura ca madha jꞌara era. Nuka, lamu ho pahie mèdha-panyau èu aaꞌi-aaꞌi. Kabꞌua ra, lamu pabagi hia dhèu dhu dènge boe ngaa-ngaa sèra. Èle na, èu lèpa hari mai sèna ka madhutu Jaꞌa. Te èèna na, Ama Lamatua bꞌala hari mèdha-panyau èu ètu sorga.” ");
INSERT INTO nfa_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ropa tadèngi nare sèmi èèna, hèia dhèu ne dꞌara na susa, te nèngu kaja dꞌai seli. ");
INSERT INTO nfa_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ropa Yesus nèdhi dhèu ne lèpa dènge dꞌara na laho mae-mae, hèia Na padhai lii dènge ana madhutu Na, peka na, “Dhèu kaja mema carui titu kèna maso sorga. ");
INSERT INTO nfa_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Èdhi pasèku ku dènge jꞌara leo. Mema bisa boe badha unta dhu kapai bisa maso asa dꞌara oka na re roꞌa jꞌajꞌau. Nuka sèmi èèna kahèi, dhèu dhu maena dhoka mèdha-panyau na, te ngaa maena boe Lamatua, tatu nèngu bisa boe maso sorga.” ");
INSERT INTO nfa_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dhèu dhu tadèngi Yesus padhai lii sèmi sèra, karèi Ne, aku rèngu na, “Ladhe dhèu kaja carui maso sorga, dhèu sèmi mia ka dhu bisa abhu mamuri taa-taa?” ");
INSERT INTO nfa_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ka Yesus bꞌala si, “Mi dhèu rai-haha, jꞌara ae-ae mema carui. Te ngaa bagi Ama Lamatua, aaꞌi-aaꞌi bisa jꞌajꞌi.” ");
INSERT INTO nfa_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hèia Petrus tuhu lii, peka na, “Ama! Jiꞌi tèke eele aaꞌi mèdha-panyau jiꞌi, ka mai madhutu Ama. Bèli-camèdꞌa jiꞌi abhu ngaa?” ");
INSERT INTO nfa_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ka Yesus dhaa, na, “Petrus! Nanene paie-iie. Dhèu dhu tèke eele èmu na, dhèu èmu-kamali na, aꞌari na, ina-ama na, do ana-ana na, lula nèngu pakako sasabꞌa Ama Lamatua, ");
INSERT INTO nfa_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tatu na abhu hari ae risi ètu rai-haha ne. Aa ladhe èle rai-haha ne, nèngu abhu mamuri taa-taa dènge Ama Lamatua kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ka Yesus gale nèti ana madhutu Na canguru dua dhèu sèra, ho lasi padhue-padhai mesa ra. Hèia Yesus peka dènge ra, “Miu se aaꞌi-aaꞌi mi meꞌa, na, èdhi kako ne, lati asa kota Yerusalem. Dꞌai nèi, jꞌara aaꞌi-aaꞌi nèti dhèu rèti lii padhai Lamatua sèra dhu suri tèke le, lula-nèti Dhèu Rai-haha Tareꞌa-reꞌa, pe jꞌajꞌi nuka sèmi dhu ra suri. ");
INSERT INTO nfa_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Èèna na, ra soro Jaꞌa asa dhèu leo dhu tadhe boe Ama Lamatua. Aa ra padhai lii pamakae Jaꞌa, pahahe Jaꞌa rupa-rupa, paruꞌe ilu ra mi Jaꞌa, ");
INSERT INTO nfa_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ra hake kalabhe Jaꞌa. Èle èèna ka, ra pamadhe Jaꞌa. Te ngaa asa camèdꞌa èèna, Jaꞌa mamuri hari.” ");
INSERT INTO nfa_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ropa tadèngi Yesus peka sèmi èèna, ana madhutu Na bingu, lula rèngu dhane rare mèka sasoa nèti lii padhai Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lodꞌo Yesus si oe maso kota Jeriko, abhu dhèu bèdhu ca dhèu dhu madhèdi kanata ai ètu sebhe jꞌara. ");
INSERT INTO nfa_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ropa na tadèngi dhèu ae kako re èèna, ka na karèi, aku nèngu na, “Ngaa ne?” ");
INSERT INTO nfa_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ka dhèu peka dènge ne, na, “Yesus nèti Nasaret dhu kako re neꞌe.” ");
INSERT INTO nfa_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hèia dhèu bèdhu ne rodhe pamèdhu-mèdhu, peka na, “Yesus! Ana-èpu dhèu aae Daud, ee! Sue ku jaꞌa!” ");
INSERT INTO nfa_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hèia dhèu dhu kako uuru nèti Yesus kai ne, sèna ka na mau-mau. Te ngaa asa na hino dènge lii rodhe, peka na, “Ana-èpu dhèu aae Daud, ee! Sue ku jaꞌa laa!” ");
INSERT INTO nfa_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ropa Yesus tadèngi, ka Na titu. Hèia Na pua dhèu lasi pakako rèti dhèu bèdhu ne. Dꞌai madha Na, ka Yesus karèi ne, ");
INSERT INTO nfa_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Èu neo Jaꞌa tao ngaa hia èu?” Ka na dhaa, “Ama! Jaꞌa manèngi sèna ka jaꞌa bisa kèdhi.” ");
INSERT INTO nfa_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus bꞌala ne, peka na, “Beꞌa. Lula èu lèka na Jaꞌa bisa paꞌèle èu, de èu bisa mèdhi dènge kèna.” ");
INSERT INTO nfa_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kacaꞌa laa, musi madha dhèu ne beꞌa dènge ka. Ka laꞌe madhutu Yesus dènge koa-kio kolongara Ama Lamatua. Dhèu aaꞌi-aaꞌi dhu ladhe rèdhi ne, koa-kio kolongara Lamatua kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ka Yesus si maso re kota Jeriko, ho neo lasi taruu. ");
INSERT INTO nfa_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ètu neꞌe, abhu ca dhèu kapala roro bea dhu roro doi hia dhèu paredha Roma. Ngara na Sakeos, aa nèngu ne dhèu kaja. ");
INSERT INTO nfa_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ropa na tadèngi Yesus kako re èèna, ka nèngu neo nèdhi. Te ngaa bisa boe nèdhi dènge beꞌa, lula katitu na babꞌa dꞌai seli, aa dhèu ae dhu kalibhu rare Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nèti èèna ka, na rai uru, ka na caꞌe asa kolo ajꞌu ca kapua ètu sebhe jꞌara, dhu Yesus neo re èèna. ");
INSERT INTO nfa_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ropa dꞌai kapua ajꞌu ne, Yesus ladhe asa dedha. Hèia Na paroa, peka na, “Sakeos! Puru ka! Karohe, te deo neꞌe kahèi, Jaꞌa neo manubha ètu dꞌara èmu èu.” ");
INSERT INTO nfa_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ka Sakeos malaa. Hèia na puru pamèri-pamèri, laꞌe dènge Yesus asa èmu na. Dꞌara na karejꞌe-karae. ");
INSERT INTO nfa_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Te ngaa dhèu ae dhu kaꞌugu, peka na, “Hmm! Sakeos ne, dhèu karehe! Nga tao ka Yesus manubha ètu dꞌara èmu na?! Dhèu aaꞌi-aaꞌi dhu reꞌa le!” ");
INSERT INTO nfa_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dꞌai dꞌara èmu, Sakeos titu ètu madha Yesus, ka lii, peka na, “Ama Mese! Nèti deo neꞌe ne, jaꞌa bagi mèdha-panyau jaꞌa mi dua, capala hia mi dhèu dhu dènge boe ngaa-ngaa. Ladhe jaꞌa roro bea parisi, jaꞌa bꞌae hari mi rèngu èpa kali lipat.” ");
INSERT INTO nfa_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ka Yesus bꞌala ne, peka na, “Beꞌa. Deo neꞌe kahèi, Ama Lamatua pala-bagi sodꞌa-mole mi èu dènge isi èmu èu aaꞌi-aaꞌi, lula èu parcaya Lamatua kahèi, nuka sèmi baki Abraham. ");
INSERT INTO nfa_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te Ama Lamatua pua Jaꞌa mai jꞌajꞌi Dhèu Rai-haha Tareꞌa-reꞌa ètu rai-haha ne. Mamai Jaꞌa ne, sèna ka tenge dhèu dhu sero nèti jꞌara Lamatua, ho hia si sodꞌa-mole.” ");
INSERT INTO nfa_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Lodꞌo èèna, dhèu ae nanene lii padhai Yesus. Rèngu oe dètu dènge kota Yerusalem. Rèngu pangee, na, Yesus neo pakako paredha Ama Lamatua ètu èèna, nuka sèmi dhèu aae. Hèia Yesus lolo dènge si lii pakasame èci. ");
INSERT INTO nfa_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Na peka na, “Abhu dhèu kapai èci. Neo laꞌe asa rai kajꞌèu, ho dhèu dedꞌe ne jꞌajꞌi dhèu aae ètu nèi. Ladhe èle, nèngu neo lèpa hari mai ho jꞌajꞌi dhèu aae ètu dꞌara kabarai na. ");
INSERT INTO nfa_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lodꞌo nèngu paꞌèra neo pakèdꞌi, paroa nare dhèu sabꞌa na canguru dhèu, ka na bagi hia si ca dhèu, juru cue. Na paredha si, peka na, ‘Miu pake doi se jꞌajꞌi mi poko. Te lodꞌo dꞌai jaꞌa lèpa, miu hudꞌi peka ku leto na ca ngaa.’ Èle èèna ka, na pakèdꞌi. ");
INSERT INTO nfa_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Te ngaa kabarai na dꞌèi boe ne. Ka ra hia dhèu lasi peka, na, ‘Jiꞌi ngoꞌo boe dhèu ne paredha jiꞌi.’ ");
INSERT INTO nfa_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Masi ka sèmi èèna, ra dedꞌe ne jꞌajꞌi dhèu aae. Hèia na lèpa hari ka. Dꞌai èmu na, ka na paroa dhèu sabꞌa na, dhèu canguru sèra, ka karèi si, peka na, ‘Miu se leto ca ngaa nèti juru dhu jaꞌa hia miu sèra?’ ");
INSERT INTO nfa_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dhèu sabꞌa dhu uru, peka na, ‘Ama dhèu aae! Jaꞌa leto juru canguru bua nèti poko dhu jaꞌa abhu!’ ");
INSERT INTO nfa_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ka dhèu aae peka dènge ne, ‘Beꞌa! Èu ne dhèu sabꞌa dhu majꞌèni. Lula jaꞌa bisa lèka èu nèti jꞌara dhu ana iiki, nèti èèna ka karèi nèti deo neꞌe, jaꞌa dedꞌe èu ho paredha canguru kota.’ ");
INSERT INTO nfa_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Èle ka dhèu sabꞌa ka dua, peka na, ‘Ama dhèu aae! Jaꞌa abhu leto juru lèmi bua nèti poko dhu jaꞌa sèmi.’ ");
INSERT INTO nfa_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ka dhèu aae peka, na, ‘Beꞌa! Ladhe sèmi èèna, jaꞌa dedꞌe èu ho paredha lèmi kota.’ ");
INSERT INTO nfa_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Te ngaa dhèu sabꞌa ka tèlu nèti hari juru na. Ka na peka, ‘Doi ama ka neꞌe! Jaꞌa rapi ka pahuni ne, mage ele. ");
INSERT INTO nfa_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jaꞌa tao sèmi èèna, lula madhaꞌu. Jaꞌa keꞌa ama, dhèu nasa. Te ama dꞌèi more ngaa dhu unu boe ama, aa dꞌèi puu hua dhu ama sèle boe!’ ");
INSERT INTO nfa_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ropa dhèu aae tadèngi sèmi èèna, ka na jèke ne, ‘Èu ne, dhèu goa dꞌara! Lii padhai èu ne pabia ngiꞌu èu mesa mu. Èu meꞌa, na, jaꞌa dhèu nasa, ho kore ngaa dhu unu boe jaꞌa, aa puu ngaa dhu jaꞌa sèle boe. ");
INSERT INTO nfa_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","De ladhe sèmi èèna, nga tao ka lamu boe tèke ne asa bank? Ho sèna ka lodꞌo jaꞌa lèpa, jaꞌa bisa abhu leto. Masi ka ciki di.’ ");
INSERT INTO nfa_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hèia dhèu aae ne pua dhèu leo ètu sèra, peka na, ‘Mere doi nèngu ne, sèna ka hia mi dhèu sabꞌa dhu abhu leto canguru deo na.’ ");
INSERT INTO nfa_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Te ngaa ra pasisu, peka na, ‘Ama! Dhèu ne abhu ae le. Nga tao ka neo more nèti dhèu dhu unu ciki, ho patabha sa nèngu hari?’ ");
INSERT INTO nfa_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Te ngaa dhèu aae bꞌala, peka na, ‘Pangee paie-iie ku! Ladhe dhèu dhu mèu uri ngaa dhu dhèu hia ne, èèna na nèngu abhu tabha hari. Te ngaa dhèu dhu bai-eedꞌa, èèna na rare aaꞌi ngaa dhu na unu. ");
INSERT INTO nfa_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","De lami kèpe mere musu jaꞌa, dhu roꞌo boe jaꞌa jꞌajꞌi dhèu aae. Mèti si mai sa neꞌe, sèna ka pamadhe si ètu madha jaꞌa. Lami ka!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ropa Yesus lolo èle, hèia lasi taruu ka asa Yerusalem. Yesus dhu kako uru. ");
INSERT INTO nfa_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ropa oe dètu dènge dua rae, nuka Betfage dènge Betania, dhu ètu karasa ledhe Saitun, ka Na pua ana madhutu Na dhèu dua lasi uru. ");
INSERT INTO nfa_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Na pua si peka na, “Miu dua mi lami asa rae dhu ètu madha nèi. Pe miu mèdhi keledꞌei ngèru ciꞌu dhu èki tèke ètu èèna. Keledꞌei ne, dhèu manyaꞌe rèdhi mèka. Mi lècu dhari na, pakako mèti mai. ");
INSERT INTO nfa_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te ngaa ladhe abhu dhèu dhu karèi, ‘Tasamia ka mi lècu eele dhari keledꞌei èèna?’ Mi peka dènge si, na, ‘Lamatua jiꞌi neo pake ne.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dua ra lasi ka, hèia ra rage keledꞌei ngèru nuka sèmi dhu Yesus peka. ");
INSERT INTO nfa_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ropa ra lècu dhari keledꞌei ne, ka lamatua badha ne karèi si, na, “Nga tao ka miu patabuli badha ne?” ");
INSERT INTO nfa_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ka ra dhaa, aku rèngu na, “Lamatua jiꞌi neo pake ne.” ");
INSERT INTO nfa_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lamatua badha ne dꞌèi kahèi, ka dua ra nuni rèti keledꞌei asa Yesus. Ra hèle sigꞌi-kalolo ra mi dedha kabodho keledꞌei ne. Èle èèna ka, ra pacaꞌe Yesus asa dedha na. ");
INSERT INTO nfa_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dhèu ae kahèi hèle sigꞌi-kalolo dènge salalu ra mi jꞌara, ho soru Yesus nuka sèmi soru dhèu kapai. ");
INSERT INTO nfa_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ropa Na puru nèti ledhe Saitun, ka dhèu se dènge ana-ana madhutu Na, mulai paꞌoo koa-kio kolongara Ama Lamatua, lula rèngu rèdhi le tadha-tadha koasa. ");
INSERT INTO nfa_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ra paꞌoo peka na, “Nèngu ne, Dhèu Aae dhu Ama Lamatua pua mai! Ama Lamatua hia Ne berkat! Dhèu rai-haha limuri ne, bisa padame le dènge Lamatua ètu sorga. Koa-kio kolongara Lamatua dhu madhèdi nèdꞌu paredha ètu dedha-liru dhu dedha risi.” ");
INSERT INTO nfa_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Te ngaa abhu kahèi dhèu-dhèu Parisi ètu talora aae dhèu ae sèra. Ka ra peka dènge Yesus, “Ama Mese! Kai ku dhèu se, ho baku ra pakii-pakèce sèmi neꞌe, te seli-kolane!” ");
INSERT INTO nfa_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Te ngaa Yesus dhaa, peka na, “Jaꞌa pasanèdꞌe mema! Ladhe dhèu seꞌe kutu hèbꞌa ra, èèna na, hadhu se ka dhu koa-kio kolongara Lamatua!” ");
INSERT INTO nfa_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ropa rèngu oe dètu Yerusalem, Yesus ladhe nèdhi kota ne, hèia Na tangi, ");
INSERT INTO nfa_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","peka na, “Ira ii! Dhèu Yerusalem, ee! Dadꞌèi Jaꞌa deo neꞌe, miu abhu dame dhu Jaꞌa kèti mai. Te ngaa lula miu pahae boe Lamatua, ka miu unu heka. Dame ne pakajꞌèu le nèti miu. ");
INSERT INTO nfa_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bèli-camèdꞌa musu miu mai udhu padedha rai palème liꞌu tedhe miu ne, hèia ra maso sa dꞌara, musu dènge miu. ");
INSERT INTO nfa_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ra dhedhe palaho kota miu, toke pamera dènge rai, hèia ra pamadhe aaꞌi miu dènge ana-ana mi. Ra tèke eele boe hadhu cue sa dhu titu, lula miu moꞌo boe tadhe Lamatua lodꞌo Na mai hia miu mamuri!” ");
INSERT INTO nfa_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Èle èèna ka, Yesus maso asa dꞌara Èmu Kapua Manèngi-Mangajꞌi. Ètu madha èmu ne, dhèu tao sèmi pasa sa, ho ra pahia badha korban. Ropa nèdhi, hèia Yesus babège si nèti era èèna. ");
INSERT INTO nfa_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ka Na jèke si, peka na, “Dhèu nèti lii padhai Lamatua dhu suri tèke le, peka na, ‘Jaꞌa patitu Èmu ne, ho dhèu aaꞌi-aaꞌi bisa mai manèngi-mangajꞌi ètu era neꞌe.’ Te ngaa mi tao ne nuka sèmi era pakaboko dhèu parapo.” ");
INSERT INTO nfa_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Èle èèna ka, bèli-bèli Yesus laꞌe ajꞌa-nori dhèu ètu Èmu Kapua Manèngi-Mangajꞌi. Te ngaa kètu agama Yahudi, mese agama, dènge dhèu heka adꞌa Yahudi sèra, patangi-tenge jꞌara ho neo pamadhe Ne. ");
INSERT INTO nfa_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Te ngaa ra abhu boe jꞌara, lula dhèu ae dhu dꞌèi titu kèna, nanene lii padhai Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ca lodꞌo, Yesus laꞌe asa Èmu Kapua Manèngi-Mangajꞌi, ka Na ajꞌa-nori Lii Lolo Beꞌa Lamatua ètu èèna. Hèia kètu agama Yahudi, mese agama, dènge dhèu heka-dhèu heka adꞌa Yahudi sèra, mai karèi Ne. ");
INSERT INTO nfa_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ra peka na, “Mu peka ku laa! Cee ka dhu hia Èu hak sèna ka adꞌu-ue maruru ètu neꞌe medꞌa na?” ");
INSERT INTO nfa_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ka Yesus bꞌala si, “Jaꞌa neo karèi miu ca madha jꞌara kahèi, heka Jaꞌa dhaa lii karèi miu kèna. ");
INSERT INTO nfa_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sèmi neꞌe: miu se tadhe Yohanis tuka sarani dhèu, do? Cee ka dhu hia ne koasa ho sarani dhèu? Ama Lamatua do, dhèu rai-haha?” ");
INSERT INTO nfa_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hèia ra papeka èci dènge èci, “Ira ee! Èdhi sèmi tare le pala ti ngaa. Ladhe èdhi peka na, ‘Ama Lamatua ka pua’, èèna Na bꞌala, aku Nèngu na, ‘Ladhe sèmi èèna, nga tao ka miu lèka boe Yohanis?’ ");
INSERT INTO nfa_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te ngaa ladhe èdhi dhaa, peka na, ‘dhèu rai-haha ka pua’, na dhèu ae sèra pèci pamadhe èdhi. Te dhèu sèra parcaya, na, Yohanis ne dhèu nèti lii padhai Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ka ra dhaa, peka na, “Jiꞌi ngeꞌa boe.” ");
INSERT INTO nfa_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hèia Yesus peka dènge ra, “Ladhe sèmi èèna, Jaꞌa koꞌo boe peka kahèi, cee ka dhu pua Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hèia Yesus lolo dènge dhèu ae sèra, pake lii pakasame, peka na, “Abhu dhèu èci dhu sèle anggor ètu dꞌara oka na. Na hia dhèu sebꞌa oka anggor ne, sèna ka rèngu pabagi isi rai nèti oka-tedhe ne. Ka na pidha laꞌe pea panèbhu asa rai kajꞌèu. ");
INSERT INTO nfa_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Dꞌai hèru puu-gꞌètu, hèia lamatua oka anggor ne pua ana paleha na ca dhèu, laꞌe nare pala nèngu. Te ngaa dhèu sabꞌa oka anggor se, game ana paleha ne, ka ra hia ne lèpa dènge ai hua. ");
INSERT INTO nfa_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Èle èèna ka, lamatua oka ne pua ana paleha na ca dhèu hari. Te ngaa dhèu sabꞌa oka se game, ka ra pamakae ne. Hèia ra babège ne lèpa dènge ai hua daꞌu-daꞌu. ");
INSERT INTO nfa_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Èle èèna ka, lamatua oka ne pua hari ana paleha na ka tèlu, te ngaa ra game ne, toke diu raa, ka ra core ne asa liꞌu oka. ");
INSERT INTO nfa_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hèia lamatua oka ne pangee ka, ‘Jaꞌa tao hari ku tasamia? Beꞌa risi jaꞌa pua ana pasue jaꞌa ka laꞌe. Ele boe ra pakabꞌua ne, de ra sèmi ne dènge beꞌa.’ De na pua ana dꞌèlu na laꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Te ngaa ropa dhèu sabꞌa oka anggor se ladhe rèdhi ne, hèia ra papeka èci dènge èci, aku rèngu na, ‘Mi ladhe ku laa! Te lamatua oka ne hia ana dꞌèlu na nuka mai nèi. Nèngu ne ka dhu bèli-camèdꞌa unu pusaka ama na aaꞌi-aaꞌi ra. De ta pamadhe ne! Sèna ka èdhi ka dhu unu oka anggor ne.’ ");
INSERT INTO nfa_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ropa ana ne dꞌai, hèia dhèu se nuni paꞌoro ne rèti asa liꞌu oka, ka ra pamadhe ne. De Jaꞌa neo karèi miu sèmi neꞌe: miu pangee, na, lamatua oka ne tao dhèu sabꞌa oka sèra tasamia? ");
INSERT INTO nfa_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Madhutu aꞌabhu Jaꞌa, tatu na mai pamadhe aaꞌi si, ka na hia hari dhèu leo sebꞌa oka ne.” Ropa dhèu se tadèngi lii padhai Yesus, rèngu peka na, “Ladhe bisa, na, jiꞌi baku abhu huku nèti Ama Lamatua sèmi èèna!” ");
INSERT INTO nfa_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hèia Yesus laladhe patae si, ka Na karèi, “Ladhe huku boe si sèmi èèna, nga tao ka dhèu nèti lii padhai Lamatua suri, na: ‘Hadhu cue dhu tuka hadhu core eele le, te ngaa limuri ne dhu jꞌajꞌi le era padhèdi agarii talora?’ ");
INSERT INTO nfa_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dhèu dhu kadhunu lèke hadhu ne, nèngu tatu laho tebꞌo-tebꞌo, lula abhu huku. Aa ladhe hadhu ne bèbhe lèke dhèu cee, nèngu laho kao-kao, lula lèke huku.” ");
INSERT INTO nfa_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ropa mese agama dènge kètu agama Yahudi se tadèngi lii lolo ne, rèngu reꞌa, na, Yesus padhai lii padhèto dènge rèngu pake lii pakasame. Rèngu se cakaraa dènge dhèu sebꞌa oka anggor deo sa. De ra nasa titu kèna. Ka ra tenge jꞌara ho neo kèpe Ne. Te ngaa rèngu madhaꞌu dènge dhèu ae sèra, dhu dꞌèi nanene lii ajꞌa Yesus. Ka lasi tèke eele Ne. ");
INSERT INTO nfa_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Èle ka, musu-musu Yesus maꞌu Ne. Rèngu tenge dhèu jꞌajꞌi mata-mata dhu bisa tao iisi ra sèmi dhèu mola, sèna ka ra kèpe Ne. Rèngu sanao sèna ka Yesus padhai lii dhu palabꞌa dènge dhèu paredha Roma, ho èèna na lasi peka dènge gubernur, sèna ka ra pua dhèu lasi kèpe Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ka ra pua mata-mata, sèna ka pakarèi dènge Yesus, aku rèngu na, “Ama Mese! Jiꞌi ngeꞌa Ama ca dhèu dhu dꞌara mola. Ama meꞌa boe kapodꞌe-kabèli, aa hagꞌe boe dhèu. Ama ajꞌa-nori dhèu madhutu Lii Lolo Beꞌa Ama Lamatua dènge mola. ");
INSERT INTO nfa_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","De jiꞌi neo karèi ca jꞌara: madhutu atora agama èdhi dhèu Yahudi, hudꞌi jiꞌi bꞌae ku doi bea mi dhèu aae kapai paredha Roma, do aadꞌo?” ");
INSERT INTO nfa_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Te ngaa Yesus neꞌa le ngangee kajꞌalu rèngu ho neo pamanahu Ne. Ka Na dhaa, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Padꞌelo sèku Jaꞌa doi iia cue.” Hèia ra padꞌelo dènge Ne doi èci. Ka Yesus karèi si, “Neꞌe ne, rupa cee ka ne? Aa ngara cee, ne?” Ra dhaa, peka na, “Èèna, dhèu aae kapai, Keser.” ");
INSERT INTO nfa_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hèia Yesus peka na, “Ladhe sèmi èèna, hia asa dhèu paredha, ngaa dhu unu rèngu. Aa hia mi Ama Lamatua ngaa dhu jꞌajꞌi hak Ama Lamatua.” ");
INSERT INTO nfa_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tadèngi sèmi èèna, dhèu se malaa, lula rèngu bisa boe sii pamanahu rare Ne ètu madha dhèu ae. Ka hèbꞌa ra kutu mèno. ");
INSERT INTO nfa_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Èle èèna ka, pèri-pèri dhèu nèti partei agama Saduki mai ho neo kèpe Yesus. Dhèu Saduki ajꞌa, na, dhèu madhe mamuri heka ètu lodꞌo èle rai-haha ne. Rèngu mai pakarèi dènge Yesus, na, ");
INSERT INTO nfa_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ama Mese! Atora Musa dhu suri tèke hia èdhi, peka na: ladhe dhèu mone madhe, aa dhu dènge mèka kolo, na, ari nèti dhèu madhe ne madhèdi nare hari bhèni balu ne, sèna ka abhu kolo hia aꞌa dhu madhe ne. ");
INSERT INTO nfa_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mema uru èèna baki Musa ajꞌa sèmi èèna ka. Te ngaa jiꞌi neo karèi sèmi neꞌe: ana mone dhèu pidhu dhu paꞌaꞌari. Dhu uru leo-èmu, te ngaa madhe dènge boe ana. ");
INSERT INTO nfa_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hèia ari na todhe nare hari bhèni balu ne. Nèbhu boe ka, na madhe, dhu dènge mèka kolo kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sèmi èèna kahèi dènge ana ka tèlu. Na leo dènge bhèni balu ne, te ngaa madhe kahèi dènge boe ana. Toke ari ra limuri tèka, madhe kahèi dènge boe kolo. ");
INSERT INTO nfa_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hèia bhèni balu ne madhe. ");
INSERT INTO nfa_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","De jiꞌi neo karèi Ama sèmi neꞌe: bhèni ne leo nèdhi le dènge ana mone dhèu pidhu sèra. Ladhe dꞌai èle rai-haha ne, ho Lamatua pamamuri hari dhèu madhe sèra, bhèni ne jꞌajꞌi mi dhèu èmu cee?” ");
INSERT INTO nfa_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ka Yesus bꞌala si, peka na, “Dhèu dhodhoka paleo èmu ètu rai-haha ne di. ");
INSERT INTO nfa_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Te ngaa ètu sorga dhèu paleo boe èmu. Aa ètu era nèi, dhèu madhe heka. Rèngu èci èèna ka dènge ana pajuu nèti Ama Lamatua ètu sorga. Te, lodꞌo Ama Lamatua pamamuri hari dhèu madhe, Na hagꞌe nare si, sèna ka jꞌajꞌi mi ana Na. ");
INSERT INTO nfa_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ètu dꞌara sasuri baki Musa, dhu lole ajꞌu iiki ca kapua dhu ai naꞌe, te ngaa kèpu boe. Nèti lii lolo ne, èdhi teꞌa, na, dhèu madhe bisa mamuri hari. Ètu èèna, Ama Lamatua peka dènge Musa, na, ‘Jaꞌa ne, Ama Lamatua nèti baki èu dhu uru-uru sèra. Nuka baki Abraham, Isak dènge Yakob. Rèngu se mangajꞌi taa-taa mi Jaꞌa toke dꞌai sange neꞌe ne.’ ");
INSERT INTO nfa_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Masi ka baki mu se madhe karèi jahi ali. Te ngaa, lula Ama Lamatua ka dhu peka na, Nèngu jꞌajꞌi mi Lamatua rèngu era, de èdhi teꞌa le, na, rèngu se mamuri era. De masi ka dhèu madhe le, te ngaa ra mamuri hari. Te dhoka dhèu dhu mamuri di, dhu pahaha iisi mi Ama Lamatua; dhèu madhe, aadꞌo si!” ");
INSERT INTO nfa_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tadèngi Yesus dhaa sèmi èèna, ka mese agama padhai lii, peka na, “Lii dhaa Ama Mese èèna, lèke kèna.” ");
INSERT INTO nfa_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nèti lodꞌo èèna, abhu heka ca dhèu sa dhu bani karèi Yesus, lula abhu boe jꞌara dhu bisa pamanahu rare Ne. ");
INSERT INTO nfa_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesus ajꞌa-nori dhèu ètu Èmu Kapua Manèngi-Mangajꞌi era. Ka Na karèi dhèu sèra, peka na, “Madhutu aꞌabhu miu, tasamia? Mese agama sèra, ajꞌa peka na, Kristus èèna, nuka Dhèu dhu Ama Lamatua pajꞌujꞌu karèi nèti uru-uru ka. Madhutu aꞌajꞌa rèngu, Nèngu ne dhodhoka ana-èpu dhèu aae Daud di. Te ngaa èèna dhae dꞌai mèka. ");
INSERT INTO nfa_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Lula uru èèna, dhèu aae Daud mesa na dhu suri le, ètu dꞌara Lii Sodꞌa Koa-kio, na, ‘Ama Lamatua peka le dènge Lamatua jaꞌa, na, “Mai madhèdi mi era dhu kabꞌua ètu babo gꞌana Jaꞌa ne. ");
INSERT INTO nfa_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Te bèli-camèdꞌa Jaꞌa tao musu-musu èu, toke ra pahaha iisi mi èu.’ ” ");
INSERT INTO nfa_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","De nèti sasuri ne, èdhi teꞌa, na, dhèu aae Daud mesa na paroa Kristus ne, ‘Lamatua’. Sasoa na, ladhe dhèu peka na Kristus ne dhoka ana-èpu nèti dhèu aae Daud di, èèna dhae dꞌai mèka! Lula Nèngu ne jꞌajꞌi Lamatua nèti dhèu aae Daud kahèi!” ");
INSERT INTO nfa_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ropa dhèu aaꞌi-aaꞌi taru kira mi lii padhai Yesus, hèia Na peka dènge ana-ana madhutu Na, aku Nèngu na, ");
INSERT INTO nfa_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Baku pamudꞌe dènge mese agama sèra. Te rèngu dꞌèi kako pake kodho robho rai, lasi paraga dènge dhèu ae, ho dhèu koa si, peka na, ‘Rèngu se dhèu kapai!’ Rèngu dꞌèi tenge era re madha ètu dꞌara èmu sabajꞌa, ètu dꞌara pesta, aa ètu era-era dhèu ae pakaboko. ");
INSERT INTO nfa_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","De miu baku pamudꞌe, lula rèngu dꞌèi kapodꞌe-kabèli bhèni balu ho parame rare èmu ra. Te ngaa ètu madha dhèu ae, rèngu pahuni bhabhelu ra dènge titu ho sabajꞌa panèbhu-nèbhu. Rèngu dꞌèi dhèu koa ra, peka na, rèngu dhèu mola. Te ngaa Lamatua neꞌa sasala ra, de èèna na Nèngu huku si bia risi.” ");
INSERT INTO nfa_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Lodꞌo Yesus ajꞌa ètu Èmu Kapua Manèngi-Mangajꞌi, ladhe nèdhi dhèu kaja mai pamaso doi asa dꞌara boaraka derma. ");
INSERT INTO nfa_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ladhe nèdhi kahèi bhèni balu ca dhèu dhu unu boe ngaa-ngaa mai madhutu sabajꞌa. Na pamaso kahèi doi dua sen asa dꞌara boaraka ne. Doi na seꞌe, kabꞌua ciki ooꞌe di. ");
INSERT INTO nfa_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ka Yesus lii dènge ana madhutu Na, peka na, “Nanene pabeꞌa-beꞌa! Bhèni balu ne, dhoka pamaso doi dua sen di, te ngaa na hia risi nèti dhèu aaꞌi-aaꞌi ra. ");
INSERT INTO nfa_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Dhèu leo se pamaso doi kolete nèti doi karisi rèngu. Te ngaa bhèni balu ne hia aaꞌi mèu-mèu doi na tao mi doi kolete. Masi ka nèti doi neꞌe, nèngu ako taha mamuri.” ");
INSERT INTO nfa_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lodꞌo èèna, ana madhutu Yesus dhu koa-kadꞌiri Èmu Kapua Manèngi-Mangajꞌi, peka na, “Ama! Ladhe ku laa, Èmu ne beꞌa titu kèna! Ra pake hadhu cetak dhu kapai hua, ka ra pacaꞌe mera titu kèna. Aa dhèu hia kahèi mèdha ra dhu kabꞌua, sèna ka pasaraga Èmu Lamatua ne!” Te ngaa Yesus bꞌala, na, ");
INSERT INTO nfa_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Èmu ne mema saraga. Te ngaa nèbhu heka, dhèu paguri eela hadhu se, toke mera dènge rai.” ");
INSERT INTO nfa_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hèia ana madhutu Yesus se karèi, peka na, “Ama Mese! Ngaa dhu Ama peka-padhai deo na, jꞌajꞌajꞌi na pèri lodꞌo? Ladhe lodꞌo na dètu le, tadha-tadha na sèmi ngaa sa?” ");
INSERT INTO nfa_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ka Yesus dhaa, aku Nèngu na, “Sadꞌi miu jꞌaga paie-iie, ho baku lèke tipu. Te èèna na rupa-rupa dhèu mai tèbꞌa kakara ra, peka na, ‘Jaꞌa ne, Kristus.’ Abhu kahèi dhu peka na, ‘Lodꞌo aꞌèle rai-haha dètu kèna!’ Te ngaa baku mi parcaya kahèi! ");
INSERT INTO nfa_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ladhe miu tadèngi ka dhèu palolo, peka na: dhèu patao-palaha, dènge papara-pakèjꞌi ètu mia-mia, baku mi cagꞌagꞌa. Sèra sa hudꞌi jꞌajꞌi uru ku. Te ngaa dꞌai mèka lodꞌo èle rai-haha ne. ");
INSERT INTO nfa_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bèli-camèdꞌa suku èci pamusu dènge suku leo. Negara èci papara-pakèjꞌi dènge negara leo. ");
INSERT INTO nfa_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Èèna na, jꞌajꞌi rai opo dhu kapai aae. Ètu mia-mia, manganga-madꞌèu dhu seli eele, aa èi papèdꞌa padꞌai cèu palème era. Bèli-camèdꞌa dhèu ladhe rèdhi kahèi tadha dhu pamadhaꞌu dhèu, aa tadha-tadha dhu kapai aae ètu dedha-liru. ");
INSERT INTO nfa_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Jꞌara seꞌe se jꞌajꞌi aaꞌi mèka, te ngaa èèna na dhèu mai kèpe rare miu, aa pajꞌèra miu, lula miu parcaya Jaꞌa. Hèia ra soro miu asa dhèu dhu uri lii langu ètu dꞌara èmu-èmu sabajꞌa, aa ra taha miu ètu dꞌara bèdho. Ra rèti miu asa madha dhèu aae-dhèu aae, dènge dhèu paredha leo. Aaꞌi-aaꞌi se jꞌajꞌi, lula miu madhutu Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Te ngaa miu hudꞌi pake lodꞌo neꞌe, sèna ka peka dènge rèngu Lii Lolo Beꞌa Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","De mage pangee tasamia miu siri iisi. ");
INSERT INTO nfa_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Te lodꞌo èèna, Jaꞌa hia miu lii-lii dhu pamèci dènge lii dhaa. Dènge sèmi èèna, musu miu sèra, reꞌa heka peka-padhai sèmi ngaa hari. ");
INSERT INTO nfa_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Bèli-camèdꞌa dhèu tèka dꞌara dènge miu, lula miu madhutu Jaꞌa. Abhu nèti aꞌari miu unu mi, sèmi ina-ama, aꞌari, kera baꞌi, rae lesa dènge mone anga-aangalai. Èèna na nèti rèngu seꞌe ka, tenge jꞌara ho pahie eele miu, toke ra pamadhe miu cahagꞌe. ");
INSERT INTO nfa_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Te ngaa miu baku madhaꞌu, te Lamatua bhèlu boe miu. Rèu kètu miu ca loa sa kabhui eele boe, ladhe dènge boe dadꞌèi Na. ");
INSERT INTO nfa_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ladhe miu taha mere taruu, tatu Ama Lamatua pala-bagi mamuri hia miu.” ");
INSERT INTO nfa_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesus padhai lii tabha hari, aku Nèngu na, “Ladhe miu mèdhi ka sordadꞌu mai pamusu reo rare Yerusalem, miu meꞌa le, na, dꞌai lodꞌo ele iie Yerusalem kèna. ");
INSERT INTO nfa_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ropa ladhe mèdhi sèmi èèna, dhèu ètu propensi Yudea rai dènge ka asa ledhe-ledhe. Dhèu ètu dꞌara kota kèdꞌi kahèi, sèna ka rai. Aa dhèu ètu rae, mai ia ka asa dꞌara kota. ");
INSERT INTO nfa_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Te Lamatua hia lodꞌo-lodꞌo sasusa sèra, ho huku dhèu-dhèu dhu roꞌo boe nanene Nèngu. Seꞌe se lèke nuka sèmi lii padhai nèti dhèu rèti lii padhai Ama Lamatua dhu suri tèke karèi nèti uru ka. ");
INSERT INTO nfa_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lodꞌo èèna, dhèu dhu jꞌèra risi, nuka, dhèu bhèni dhu dènge babia, aa ina-ina dhu dènge ana susu. Lodꞌo èèna, abhu susa palème rai-haha, aa dhèu Yahudi jꞌèra bia, lula Ama Lamatua nasa dènge rèngu sèra. ");
INSERT INTO nfa_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Èèna na musu mai pamadhe si cahagꞌe, aa taha cahagꞌe ho jꞌajꞌi ènu ètu mia-mia ètu rai-haha ne. Ka dhèu leo rai kara dhu tadhe boe Ama Lamatua, mai jꞌajꞌèli pakajꞌalu kota Yerusalem, aa koasa rare kabarai na, toke èle lodꞌo ra.” ");
INSERT INTO nfa_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Èle ka Yesus lole mamai hari Na, aku Nèngu na, “Bèli-camèdꞌa ladhe Dhèu Rai-haha Tareꞌa-reꞌa neo mai hari, abhu tadha ètu madha lodꞌo, hèru, dènge hua hètu-hua hètu. Ètu rai-haha ne abhu tadha kahèi, sèmi uli sea, dhasi koꞌa dhu loe boe, aa naha aae lalulu mai. Seꞌe se tao dhèu rai-haha ne, madhaꞌu dènge ele ngangee, toke reꞌa heka tao ngaa-ngaa. ");
INSERT INTO nfa_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Koasa-koasa ètu dedha-liru loe boe karèbha. Ropa ladhe rèdhi aaꞌi-aaꞌi, hèia ra madhaꞌu titu kèna, lula rai-haha ne oe ele iie kèna! ");
INSERT INTO nfa_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Èle ku heka dhèu ladhe rèdhi Jaꞌa kèna, ‘Dhèu Rai-haha Tareꞌa-reꞌa ne puru mai ètu dꞌara raꞌi-liru’. Jaꞌa mai dènge koasa, aa dènge dadedha dhu kapai risi eele. ");
INSERT INTO nfa_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ladhe mulai jꞌajꞌi ka tadha sèra, na, miu boti ka kètu miu, te lodꞌo dꞌai kèna, Lamatua hia mamuri mi miu.” ");
INSERT INTO nfa_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Èle èèna ka, Yesus lolo pake lii pakasame, aku Nèngu na, “Miu taru kira pabeꞌa-beꞌa ku mi ajꞌu sèra. ");
INSERT INTO nfa_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ladhe dꞌai ka hèru rèu ra karara, èèna tadha na hèru hadhu dètu le. ");
INSERT INTO nfa_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sèmi èèna kahèi dènge lodꞌo-lodꞌo sasusa. Ladhe cèu, èèna tadha na paredha Ama Lamatua dhu dètu iiki le. ");
INSERT INTO nfa_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Jaꞌa pasanèdꞌe mema miu! Nèti dhèu aaꞌi-aaꞌi dhu mamuri limuri ne, bèli-camèdꞌa cahagꞌe dhae madhe mèka, te lodꞌo-lodꞌo jꞌajꞌèra se mai le. ");
INSERT INTO nfa_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Masi ka liru dènge rai-haha ele, te ngaa Lii Holo-Nori Jaꞌa taha taa-taa.” ");
INSERT INTO nfa_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Hèia Yesus tuhu lii padhai Na, aku Nèngu na, “Mi jꞌaga-jꞌaga, te cagꞌagꞌa laa Jaꞌa mai hari sahèka! Mage dhoka miu taru kira heka, hèia miu mamuri dènge minu mahu, aa bhute dhoka tenge mamuri karejꞌe di. Mage dhoka miu meꞌa boe tadha ne, lula miu bhute dènge jꞌara dhu leo. ");
INSERT INTO nfa_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ladhe Jaꞌa lèpa hari mai, abhu boe ca dhèu sa dhu bisa pahuni iisi ra nèti madha Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","De miu hudꞌi mate tatae ku. Baku maꞌète manèngi-mangajꞌi, sèna ka miu bisa taha ètu talora aae sasusa sèra. Dènge sèmi èèna, ropa Jaꞌa lèpa hari mai, miu makae boe titu ètu madha Dhèu Rai-haha Tareꞌa-reꞌa ne.” ");
INSERT INTO nfa_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Bèli-bèli, ladhe re mèu, Yesus laꞌe ajꞌa Lii Holo-Nori Lamatua ètu Èmu Kapua Manèngi-Mangajꞌi. Te ngaa ladhe re mèda, kalua nèti Yerusalem ho laꞌe bhèjꞌi asa rae ètu ledhe Saitun. ");
INSERT INTO nfa_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Madꞌae aae era, dhèu ae-ae dhu mai le pakaboko ètu Èmu Kapua Manèngi-Mangajꞌi, ho nanene lii ajꞌa-nori Na. ");
INSERT INTO nfa_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lodꞌo èèna, oe dꞌai lodꞌo hua iia dhèu Yahudi, nuka pesta Roti dhu dènge boe Ragi. Ètu dꞌara lodꞌo hua iia se, ra roro kahibꞌi-kalèbho tao kalela Paska kahèi. Rèngu tao sèmi neꞌe, sèna ka pasanèdꞌe uru èèna, lodꞌo bèi-baki rèngu kalua nèti Masir. ");
INSERT INTO nfa_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Lodꞌo èèna, kètu agama Yahudi dènge mese agama sèra tenge jꞌara ho pamadhe Yesus. Te ngaa ra mage dhèu ae sèra maruru, lula dhèu se dꞌèi nanene Ne. ");
INSERT INTO nfa_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nèti dhèu pajuu-paleha Yesus, dhèu canguru dua sèra, èci ngara na Yudas Iskariot. Lodꞌo kètu agama Yahudi sèra tenge jꞌara ho pamadhe Yesus, dhèu aae nidhu maso asa dꞌara Yudas Iskariot. ");
INSERT INTO nfa_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hèia laꞌe tenge kètu agama Yahudi se dènge kètu nèti dhèu madhenga Èmu Kapua Manèngi-Mangajꞌi. Laꞌe neo paneꞌa dènge ra, sèna ka pahie Yesus dènge rèngu. ");
INSERT INTO nfa_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ropa tadèngi lii padhai Yudas, hèia ra karejꞌe titu kèna. Ra pamoa, peka na, “Laꞌa, ma! Ladhe èu neo pahie Yesus dènge jiꞌi, na jiꞌi bꞌae.” ");
INSERT INTO nfa_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ka Yudas dꞌèi, hèia na mulai tenge lodꞌo dhu lake nare, sèna ka dhèu ae baku reꞌa nèngu pahie eele Yesus. ");
INSERT INTO nfa_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hèia dꞌai ka lodꞌo hua iia dhèu Yahudi, dhu rèngu biasa roro ana kahibꞌi-kalèbho sèna ka tao kalela Paska. ");
INSERT INTO nfa_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ka Yesus pua Petrus dènge Yohanis, aku Nèngu na, “Dua mi lami uuru, sèna ka sadia tèke ngangaꞌa kalela Paska ho taꞌa sama-sama.” ");
INSERT INTO nfa_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ka dua ra karèi, “Ama! Jiꞌi laꞌa sadia ngangaꞌa asa mia?” ");
INSERT INTO nfa_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Hèia Na bꞌala, “Ladhe miu maso asa dꞌara kota Yerusalem, pe miu paraga dènge dhèu mone ca dhèu dhu pasae gꞌala èi cue. Madhutu ne toke dꞌai èmu na. ");
INSERT INTO nfa_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Peka dènge lamatua èmu ne, ‘Ama Mese jiꞌi manèngi ca kama, ho neo pake tao kalela Paska dènge ana-ana madhutu Na. Abhu, do?’ ");
INSERT INTO nfa_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Èèna na lamatua èmu ne padꞌelo dènge miu kama èci dhu taleo ètu èmu dedha. Nèngu lalau pamèci nare aaꞌi le kama èèna. Ate dhoka miu dua mi lami sadia ngangaꞌa ètu èèna.” ");
INSERT INTO nfa_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ka dua ra lasi. Hèia ra paraga ka nuka sèmi ngaa dhu Yesus peka le. Ka dua ra sadia ngangaꞌa-nganginu Kalela Paska ètu nèi. ");
INSERT INTO nfa_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ropa lalau rare aaꞌi, Yesus si mai. Yesus madhèdi ètu mei, aa ana-ana pajuu-paleha Na madhèdi kahèi raꞌa pesta. ");
INSERT INTO nfa_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hèia Yesus peka dènge si, “Jaꞌa dꞌèi titu kèna madhèdi kuꞌa kalela Paska dènge miu aaꞌi-aaꞌi mi, uru nèti Jaꞌa abhu jꞌajꞌèra. ");
INSERT INTO nfa_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Patadhe pabeꞌa-beꞌa. Te èle neꞌe ne, Jaꞌa madhèdi heka kuꞌa kalela Paska dènge miu. Ladhe dhèu aaꞌi-aaꞌi reꞌa mèu ku, peka na, Ama Ku nèdꞌu paredha, Jaꞌa heka kuꞌa hari kèna.” ");
INSERT INTO nfa_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hèia Na kèpe nare galaa cue dhu isi èi anggor. Ka Na manèngi makasi mi Ama Lamatua, èle ka Na soro galaa ne asa rèngu. Hèia Na padhai lii, aku Nèngu na, “Sèmi mere galaa ne, ho èci-èci minu. ");
INSERT INTO nfa_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sanèdꞌe paie-iie! Karèi nèti mèda neꞌe ne, Jaꞌa kinu heka èi anggor. Ladhe dhèu aaꞌi-aaꞌi reꞌa mèu ka, peka na, Ama Ku nèdꞌu paredha, Jaꞌa heka kinu hari kèna.” ");
INSERT INTO nfa_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hèia Na kèpe nare roti cue, ka manèngi makasi mi Ama Lamatua. Ka Na pamae roti ne, hèia Na soro sa rèngu aaꞌi-aaꞌi ra. Ka Na peka, “Roti neꞌe ne, ngiꞌu aae Jaꞌa dhu Jaꞌa hia sa miu aaꞌi-aaꞌi mi. Lodꞌo-lodꞌo dhu miu miꞌe ne, pasanèdꞌe taruu miu, lula tatao Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ropa raꞌa rare, ka Na dedꞌe nare galaa dhu isi èi anggor. Hèia Na lii, peka na, “Èi anggor neꞌe ne, raa Jaꞌa ka ne, dhu bhori mai sèna ka hia sodꞌa-mole mi miu. Nèti raa neꞌe ka, Ama Lamatua paꞌèki lii pajaji dhu hiu dènge miu. ");
INSERT INTO nfa_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mage pamudꞌe, te abhu dhèu dhu madhèdi sama-sama dènge èdhi ètu mei ne, èèna na, nèngu pahie eele Jaꞌa. ");
INSERT INTO nfa_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mema Jaꞌa, Dhèu Rai-haha Tareꞌa-reꞌa ne, hudꞌi madhe ku madhutu dadꞌèi Ama Lamatua. Te ngaa dhèu dhu pahie eele Jaꞌa, sanèdꞌe, ee! Te bèli-camèdꞌa, nèngu pasae nare mamadhe-mamopo!” ");
INSERT INTO nfa_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ropa ra tadèngi lii ne, ana-ana pajuu-paleha se pakarèi, peka na, “Cee ka dhu adꞌu-ue madha jꞌara bhelu ne mi dedha Na?” ");
INSERT INTO nfa_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ka ana madhutu Yesus se pasisu, peka na, nèti rèngu aaꞌi-aaꞌi ra, cee ka dhu dhèu re madha. ");
INSERT INTO nfa_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Te ngaa Yesus kai si, peka na, “Ètu rai-rai dhu kabarai ra tadhe boe Lamatua, dhèu aae ra hia paredha dhu bia risi mi kabarai rèngu. Te ngaa rèngu neo sèna ka kabarai paroa rèngu, peka na, ‘Ama dhu taru kira kabarai’. ");
INSERT INTO nfa_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Te ngaa miu baku madhutu jꞌara sèra. Cee dhu neo jꞌajꞌi dhèu kapai, mamuri na hudꞌi tareꞌa-reꞌa sama sèmi dhèu haha ho lalau-laloꞌo dhèu aaꞌi-aaꞌi ra. Dhu neo jꞌajꞌi kètu, hudꞌi ladhe-leru ku sama sèmi ana pua-paleha. ");
INSERT INTO nfa_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Miu pangee sèku, dhèu kapai sèra nuka mia? Dhèu dhu madhèdi ètu mei, do, dhu lalau mei? Tatu dhèu dhu madhèdi ne, dhèu kapai, si? Te ngaa Jaꞌa ne, tao boe ngiꞌu sèmi sèra. Jaꞌa mai lalau-laloꞌo miu. ");
INSERT INTO nfa_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Miu seꞌe ka dhu bera-bera dènge Jaꞌa, lodꞌo Jaꞌa paraga dènge jꞌajꞌèra. ");
INSERT INTO nfa_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ama Ku dedꞌe le Jaꞌa, sèna ka kèdꞌu paredha ètu era paredha Na. Ka limuri ne, Jaꞌa dedꞌe miu kahèi, ");
INSERT INTO nfa_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ho miu bèli-camèdꞌa madhèdi miꞌa dènge Jaꞌa ca mei ètu sorga. Jaꞌa hia koasa kahèi, sèna ka miu paredha canguru dua suku dhèu Israꞌel.” ");
INSERT INTO nfa_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ka Yesus lii dènge Petrus, peka na, “Petrus. Dhèu aae nidhu neo hia miu pacèri nèti Jaꞌa, nuka sèmi dhèu tatai ho hagꞌe eele èto nèti laludhu. ");
INSERT INTO nfa_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Te ngaa Jaꞌa sabajꞌa hia èu, Petrus, ho èu lèka Jaꞌa taruu. Ladhe èu lèpa hari mai asa Jaꞌa, na, èu hudꞌi paꞌèra ku dꞌara aꞌari èu, nuka dhèu unu Lamatua sèra.” ");
INSERT INTO nfa_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hèia Petrus bꞌala, aku nèngu na, “Aadꞌo, Ama! Masi ka tasamia èèna ka, jaꞌa bisa boe tèke eele Ama. Te jaꞌa paꞌèra maso bui sama-sama dènge Ama. Masi ka jaꞌa madhe palere-lere dènge Ama, ngaa-ngaa tao boe.” ");
INSERT INTO nfa_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Te ngaa Yesus peka na, “Petrus! Nanene paie. Mèda neꞌe kahèi, manu dhae kokotoo mèka, èu pasili le tèlu hari, na, èu tadhe boe Jaꞌa.” ");
INSERT INTO nfa_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Èle èèna ka, Yesus padhai lii dènge ra, aku Nèngu na, “Ca hari na, Jaꞌa pua miu lami lole Lii Lolo Beꞌa Jaꞌa asa mia-mia, Jaꞌa peka dènge miu, ho baku mèti doi, tas, dènge salapa. Lodꞌo èèna, miu kura ngaa?” Ka aaꞌi-aaꞌi ra dhaa, aku rèngu na, “Ca hari na, jiꞌi kura boe ngaa-ngaa èci sa!” ");
INSERT INTO nfa_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hèia Yesus peka tabha hari, na, “Te ngaa limuri ne, leo. Ladhe miu dènge doi, na todhe mèti. Ladhe dènge tas, na mèti kahèi. Ladhe dènge boe samala, pahia kodho miu, sèna ka hèli. ");
INSERT INTO nfa_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Te dhèu Yahudi pangee na, Jaꞌa ne dhèu bhelu. Hèia nèbhu heka, rèngu mai kèpe Jaꞌa. Jꞌara ne, nuka sèmi dhu baki Yesaya suri tèke le: ‘Ra tao Ne sèmi dhèu bhelu-katubꞌa!’ ” ");
INSERT INTO nfa_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ka ra peka na, “Ama! Jiꞌi ngèti hela dua.” Hèia Yesus peka, “Dꞌai le. Ale ia ka sèra!” ");
INSERT INTO nfa_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Raꞌa rare Paska, ka Yesus dènge ana madhutu Na lasi asa ledhe Saitun, sèmi biasa. ");
INSERT INTO nfa_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dꞌai nèi, Yesus peka dènge si, “Miu hudꞌi sabajꞌa ku, ho baku lèke dadugu-rariu.” ");
INSERT INTO nfa_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hèia Na tèke eele si, laꞌe kajꞌèu boe. Ka Na patitu kètu urutuu Na, ho sabajꞌa, peka na, ");
INSERT INTO nfa_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama! Ladhe Ama dꞌèi na, pakajꞌèu ku jꞌajꞌèra ne nèti Jaꞌa. Te ngaa mage madhutu dadꞌèi Jaꞌa; hudꞌi laa madhutu dhoka dadꞌèi Ama di.” ");
INSERT INTO nfa_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ka ana pajuu Ama Lamatua èci mai nèti sorga paꞌèra dꞌara Na. ");
INSERT INTO nfa_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lula dꞌara Na jꞌèra titu kèna, toke èi kabhèsu Na suti sèmi raa sa. ");
INSERT INTO nfa_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ropa sabajꞌa nare, Na kèdꞌi laꞌe paraga dènge ana madhutu Na. Te ngaa rèngu dhu bhèjꞌi, lula ngiꞌu roe aa dꞌara susa. ");
INSERT INTO nfa_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hèia Yesus lii dènge ra, “Tasamia ka miu se bhèjꞌi? Beꞌa risi miu sabajꞌa, ho ladhe paraga dènge dadugu-rariu, miu baku manahu.” ");
INSERT INTO nfa_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ropa Yesus padhai lii era, Yudas (ca dhèu nèti canguru dua ana madhutu Na), mai dènge dhèu ae-ae. Na mai padètu-dètu dènge Yesus, neo kèpe ho uu Ne. ");
INSERT INTO nfa_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Te ngaa Yesus lii dènge ne, peka na, “Yudas! Èu neo pahie eele Dhèu Rai-haha Tareꞌa-reꞌa dènge aꞌuu, do?” ");
INSERT INTO nfa_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ropa ana madhutu leo sèra reꞌa tatao bhelu nèti Yudas ne, ka ra karèi Yesus, peka na, “Ama! Jiꞌi labꞌa si, do? Te jiꞌi dhu ngèti hela.” ");
INSERT INTO nfa_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ka ca dhèu nèti rèngu se, bete hela na, ka na pare pamaꞌète rèu dhilu gꞌana nèti dhèu èci. Dhèu ne, ènu nèti kètu kapai risi agama Yahudi. ");
INSERT INTO nfa_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Te ngaa Yesus dhaa si, peka na, “Sange èèna ka! Baku labꞌa si.” Hèia Na gꞌagꞌe dhilu dhèu ne, ka paꞌèle. ");
INSERT INTO nfa_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dhèu-dhèu dhu mai kèpe Yesus, nuka: kètu agama Yahudi sèra, dhèu heka dꞌara rae, kètu nèti dhèu madhenga Èmu Kapua Manèngi-Mangajꞌi, dènge dhèu leo hari kahèi. Yesus karèi si, “Tasamia? Miu se ngee, na, Jaꞌa ne dhèu bhelu, ka mai kèpe Jaꞌa mèti samala dènge ajꞌu cèki, do? ");
INSERT INTO nfa_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bèli-bèli èèna, Jaꞌa ajꞌa miu ètu Èmu Kapua Manèngi-Mangajꞌi, te ngaa abhu boe ca dhèu sa dhu mai kèpe Jaꞌa. De hudꞌi laa! Neꞌe dꞌai lodꞌo miu. Neꞌe ne mai nèti koasa dhèu aae nidhu!” ");
INSERT INTO nfa_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hèia ra kèpe rare Lamatua Yesus, ka nuni rèti Ne asa èmu kètu kapai risi agama Yahudi. Petrus kako mau-mau re kabodho. ");
INSERT INTO nfa_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ètu madha èmu ne, dhèu tao ai raci. Hèia Petrus laꞌe manyiru ai kahèi. ");
INSERT INTO nfa_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ka bhèni sabꞌa ca dhèu ladhe nèdhi Petrus dhu manyiru ai. Na ladhe patae rèhu Petrus, ka peka dènge dhèu leo ètu sèra, aku nèngu na, “Dhèu neꞌe ne dhu madhutu Yesus kahèi!” ");
INSERT INTO nfa_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Te ngaa Petrus pasili, ka na peka, “Aadꞌo! Jaꞌa tadhe boe Dhèu ne. Èu meꞌa ngaa?” ");
INSERT INTO nfa_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nèbhu boe ka, ca dhèu ladhe sa Petrus, èle ka na lii, aku nèngu na, “Tareꞌa. Èu ne, mema ca dhèu nèti dhèu Yesus sèra, si?” Te ngaa Petrus pasili, ka na peka, “Aadꞌo! Èu peka leli na!” ");
INSERT INTO nfa_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pe dꞌai ca jam sa, ca dhèu leo hari, peka na, “Jaꞌa keꞌa dhèu neꞌe ne, ca dhèu nèti ana madhutu Yesus. Te nèngu ne, dhèu Galilea kahèi.” ");
INSERT INTO nfa_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Te ngaa Petrus pasili hari kahèi, aku nèngu na, “Èu monya èèna!” Ropa Petrus padhai lii sèmi èèna, kacaꞌa laa manu kokotoo. ");
INSERT INTO nfa_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hèia Yesus kabibꞌa sa nèngu. Ka Petrus sanèdꞌe lii Yesus deo na, dhu peka na, “Mèda neꞌe ne kahèi, manu dhae kokotoo mèka, te èu pasili le Jaꞌa tèlu hari kèna.” ");
INSERT INTO nfa_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ngee nèdhi sèmi èèna, hèia Petrus kalua nèti madha èmu ne, dènge tangi dhu dꞌara laho mae-mae. ");
INSERT INTO nfa_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Èle èèna ka, dhèu dhu jꞌaga Yesus, padhai lii pahaha Ne, dènge game paꞌoke Ne. ");
INSERT INTO nfa_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ra pahutu rèhu Na pake bèla, ka ra karèi Ne, aku rèngu na, “Wee! Ladhe èu ne dhèu mèti lii padhai Lamatua, na, èu peka sèku! Cee ka dhu jꞌubhu èu?” ");
INSERT INTO nfa_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Èle ka, ra padhèdꞌa aape Ne. ");
INSERT INTO nfa_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Madꞌae aae era, kètu agama Yahudi, mese agama, dènge dhèu heka-dhèu heka adꞌa Yahudi sèra, pakaboko le uri lii langu Yesus. Ka ra pua dhèu lasi nuni rèti Yesus asa era pamaꞌète lii langu agama. ");
INSERT INTO nfa_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ropa Yesus maso, ka ra karèi Ne, “Èu peka ku laa! 