﻿USE sofia;
DROP TABLE IF EXISTS sofia.new_vpl;
CREATE TABLE new_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES new_vpl WRITE;
INSERT INTO new_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","दक्‍वसिबय् न्‍हापां परमेश्‍वरं आकाश व पृथ्‍वी सृष्‍टि यानादिल। ");
INSERT INTO new_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्‍वी बां मलू, अले शून्‍य। ततःजाःगु समुद्रया च्‍वय् न्‍यंकभनं खिउँसे च्‍वं। परमेश्‍वरया आत्‍मा समुद्रया च्‍वँच्‍वं जुयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","परमेश्‍वरं धयादिल, “तुयुगु जः दयेमा।” अले तुयुगु जः दत। ");
INSERT INTO new_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","परमेश्‍वरं व जःयात स्‍वःबलय् वय्‌कःयात व बांलाः ताल। अले वय्‌कलं जःयात खिउँथासं अलग तयादिल। ");
INSERT INTO new_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेश्‍वरं जःयात “दिं” अले खिउँयात “चा” धकाः नां तयादिल। चा फुनाः सुथ जुल। थुकथं – छन्‍हु जुल। ");
INSERT INTO new_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","परमेश्‍वरं धयादिल, “लः निब्‍व दयेत दथुइ जाः दयेमा।” ");
INSERT INTO new_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","अले वय्‌कलं लःयात च्‍वय् व क्‍वय् यानाः निब्‍व दय्‌कादिल। अथे हे जुल। ");
INSERT INTO new_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेश्‍वरं च्‍वय्‌यागु ब्‍वयात “आकाश” धकाः नां तयादिल। चा फुनाः सुथ जुल। थुकथं – निन्‍हु जुल। ");
INSERT INTO new_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","अले परमेश्‍वरं धयादिल, “आकाशया क्‍वय् च्‍वंगु फुक्‍क लः छथाय् मुनेमा, अले गंगु बँ खनेदयेमा।” अथे हे जुल। ");
INSERT INTO new_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्‍वरं गंगु बँयात “पृथ्‍वी” धकाः नां तयादिल। अले मुंगु लःयात “समुद्र” धकाः नां तयादिल। वय्‌कःयात थ्‍व बांलाः ताल। ");
INSERT INTO new_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","परमेश्‍वरं धयादिल, “पृथ्‍वीं फुक्‍क कथंयागु घाँय्‌मा, पुसा दइगु स्‍वांसिमा व थथःगु कथंयागु पु दइगु फलफुलमा थथःगु कथं बुइकेमा।” अले अथे हे जुल। ");
INSERT INTO new_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","थुकथं पृथ्‍वीं फुक्‍क कथंयागु घाँय्, पुसा दुगु अन्‍नमा व फलफुल सइगु सिमात बुइकल। परमेश्‍वरयात थ्‍व बांलाः ताल। ");
INSERT INTO new_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","चा फुनाः सुथ जुल। थुकथं – स्‍वन्‍हु जुल। ");
INSERT INTO new_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","अले परमेश्‍वरं धयादिल, “न्‍हि व चा छुटे यायेत आकाशय् जः दयेमा। अले थ्‍व दिं, दँ व नखःचखः सीकेगु चिं जुइ। ");
INSERT INTO new_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","पृथ्‍वीइ जः खय्‌केत आकाशय् जः दयेमा।” अथे हे जुल। ");
INSERT INTO new_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","परमेश्‍वरं ततःधंगु निगू जः दय्‌कादिल – तःधंगु जः न्‍हिनय् थीत व चिधंगु जः चान्‍हय् थीत खः। वय्‌कलं नगुत नं दय्‌कादिल। ");
INSERT INTO new_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","वय्‌कलं इमित पृथ्‍वीइ जः बीमा, ");
INSERT INTO new_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","न्‍हिनय् नं चान्‍हय् नं थीमा, अले जःयात खिउँथासं छुटे यायेमा धकाः आकाशय् तयादिल। परमेश्‍वरयात थ्‍व बांलाः ताल। ");
INSERT INTO new_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","चा फुनाः सुथ जुल। थुकथं – प्‍यन्‍हु जुल। ");
INSERT INTO new_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","परमेश्‍वरं धयादिल, “लखय् थीथी जीवजन्‍तुत दयेमा, अले आकाशय् थीथी झंगःपंक्षीत ब्‍वयाजुइमा।” ");
INSERT INTO new_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","अले परमेश्‍वरं लखय् च्‍वनीपिं ततःधिपिं जन्‍तुत, फुक्‍क किसिमया लखय् नं बँय् नं जुइपिं जन्‍तुत व फुक्‍क किसिमया झंगःपंक्षीत दय्‌कादिल। परमेश्‍वरयात थ्‍व बांलाः ताल। ");
INSERT INTO new_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","परमेश्‍वरं इमित आशिष बियाः धयादिल, “मचाखाचा यक्‍व दयाः समुद्रय् जायेमा, अले झंगःपंक्षीत नं पृथ्‍वीइ यक्‍व दयेमा।” ");
INSERT INTO new_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","चा फुनाः सुथ जुल। थुकथं – न्‍यान्‍हु जुल। ");
INSERT INTO new_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","परमेश्‍वरं धयादिल, “पृथ्‍वीइ छेँय् लहीपिं, बँय् घिसय्‌ जुयाजुइपिं व जंगलय् च्‍वनीपिं फुक्‍क कथंया जन्‍तुत दयेमा।” अले अथे हे जुल। ");
INSERT INTO new_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","अले परमेश्‍वरं थीथी कथंयापिं जंगलय् च्‍वनीपिं, छेँय् लहीपिं, व बँय् घिसय्‌ जुयाजुइपिं जन्‍तुत दय्‌कादिल। वय्‌कःयात थ्‍व बांलाः ताल। ");
INSERT INTO new_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","अले परमेश्‍वरं धयादिल, “मनूयात झीपिं थें हे च्‍वंक व झीगु हे ख्‍वाःलसि वयेक दय्‌के। अले इमित समुद्रय् च्‍वंपिं न्‍यातय्‌त, आकाशय् च्‍वंपिं झंगःपंक्षीतय्‌त, छेँय् लहीपिं फुक्‍क जीवजन्‍तुतय्‌त, फुक्‍क पृथ्‍वीयात व पृथ्‍वीइ घिसय्‌ जुयाजुइपिं जीवजन्‍तुतय्‌त अधिकार याकेब्‍यु।” ");
INSERT INTO new_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","थुकथं परमेश्‍वरं मनूयात थःगु हे ख्‍वाःलसि वयेक दय्‌कादिल। परमेश्‍वरयागु हे ख्‍वाःलसि वयेक वय्‌कलं इमित दय्‌कादिल। वय्‌कलं इमित मिजं व मिसा यानाः दय्‌कादिल। ");
INSERT INTO new_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","परमेश्‍वरं इमित आशिष बियाः धयादिल, “छिमि मचाखाचा यक्‍व दयाः पृथ्‍वी जायेमा, अले पृथ्‍वीइ अधिकार यायेमा। समुद्रय् च्‍वंपिं न्‍या, आकाशय् च्‍वंपिं झंगःपंक्षी व बँय् घिसय् जुइपिन्‍त अधिकार यायेमा।” ");
INSERT INTO new_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","परमेश्‍वरं धयादिल, “न्‍यँ, जिं छिमित फुक्‍क कथंयागु पुसा दुगु अन्‍नमा व फल सइगु सिमात पुसा नापं बी। थ्‍व हे छिमिगु नसा जुइ। ");
INSERT INTO new_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","पृथ्‍वीइ च्‍वंपिं फुक्‍क जीवजन्‍तु, आकाशय् च्‍वंपिं झंगःपंक्षी व बँय् घिसय्‌ जुयाजुइपिं फुक्‍क जीवजन्‍तुतय्‌त नयेत जिं घाँय्‌मा बी।” अले अथे हे जुल। ");
INSERT INTO new_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","परमेश्‍वरं थःम्‍हं दय्‌कूगु फुक्‍क स्‍वयादिल। वय्‌कःयात थ्‍व तसकं बांलाः ताल। चा फुनाः सुथ जुल। थुकथं – खुन्‍हु जुल। ");
INSERT INTO new_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","थुकथं आकाश व पृथ्‍वी, अले थुकी च्‍वंगु फुक्‍कं दय्‌के क्‍वचाल। ");
INSERT INTO new_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","परमेश्‍वरं थःगु फुक्‍क ज्‍या खुन्‍हुं सिधय्‌काः न्‍हय्‌न्‍हु दुखुन्‍हु आराम कयादिल। ");
INSERT INTO new_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","परमेश्‍वरं न्‍हय्‌न्‍हु खुन्‍हुयात आशिष बियाः थ्‍व दिंयात पवित्र यानादिल। छाय्‌धाःसा थ्‍वखुन्‍हु परमेश्‍वरं सृष्‍टिया ज्‍या फुक्‍क क्‍वचाय्‌काः आराम कयादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","आकाश व पृथ्‍वी सृष्‍टि जूगु खँ थ्‍व हे खः। परमप्रभु परमेश्‍वरं आकाश व पृथ्‍वी सृष्‍टि यानादीगु दिंखुन्‍हु ");
INSERT INTO new_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","पृथ्‍वीइ घाँय्‌मा छमा नं मदु, सिमा छमा नं मदु। छाय्‌धाःसा उबलय् परमप्रभु परमेश्‍वरं वा वय्‌कामदीनि, अले बुँ ज्‍याइपिं मनूत नं छम्‍ह हे मदुनि। ");
INSERT INTO new_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","अथेसां बुंगाःचां लः पिहां वयाः फुक्‍क बँ प्‍याइगु खः। ");
INSERT INTO new_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","अले परमप्रभु परमेश्‍वरं बँय् च्‍वंगु चा कयाः मनू दय्‌कादिल, अले वयागु न्‍हासय् जीवनया सासः थनादिल। थुकथं मनू जीवन दुम्‍ह जुल। ");
INSERT INTO new_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","परमप्रभु परमेश्‍वरं पुर्बपाखे अदन धाःथाय् छगू क्‍यब दय्‌कादिल। अले वय्‌कलं दय्‌कादीम्‍ह मनूयात अन तयादिल। ");
INSERT INTO new_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","परमप्रभु परमेश्‍वरं अन स्‍वयेबलय् न्‍ह्याइपुसे च्‍वंगु व भिंगु भिंगु फल सइगु सिमात बुइकादिल। दथुइलाक जीवन बीगु सिमा व भिं व मभिंया ज्ञान बीगु सिमा नं दय्‌कादिल। ");
INSERT INTO new_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","क्‍यबयात प्‍याकेत अदनं लःया छगू खुसि पिहां वल। अले अनं व प्‍यंगू खुसि जुयाः बायावन। ");
INSERT INTO new_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","न्‍हापांगु खुसिया नां पीशोन खः। थ्‍व खुसि हवीला धाःगु लुँ दइगु देश चाःहिलावनी। ");
INSERT INTO new_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","थ्‍व देशया लुँ तसकं भिं। नापं थन तःजिगु धूप व तःजिगु ल्‍वहंत नं दु। ");
INSERT INTO new_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","निगूगु खुसिया नां गीहोन खः। थ्‍व कूश धाःगु देश चाःहिलावनी। ");
INSERT INTO new_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","स्‍वंगूगु खुसिया नां टाइग्रिस खः। थ्‍व अश्‍शूर धाःगु देशया पुर्बपाखे बाःवनी। प्‍यंगूगु खुसिया नां यूफ्रेटिस खः। ");
INSERT INTO new_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","अले परमप्रभु परमेश्‍वरं मनूयात बुँ ज्‍यायेत व थुकिया बिचाः यायेत अदन धाःगु क्‍यबय् यंकाः तयादिल। ");
INSERT INTO new_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","परमप्रभु परमेश्‍वरं वयात धयादिल, “थ्‍व क्‍यबय् च्‍वंगु फुक्‍क सिमाया फल नःसां ज्‍यू। ");
INSERT INTO new_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","भिं व मभिंया ज्ञान बीगु सिमाया फल छता धाःसा नये मज्‍यू। नल धाःसा छ उखुन्‍हु हे सी।” ");
INSERT INTO new_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","अले परमप्रभु परमेश्‍वरं धयादिल, “मनूयात याकःचा च्‍वनेगु बांलाः मजू। जिं वयात ग्‍वाहालि याइम्‍ह छम्‍ह पासा दय्‌काबी।” ");
INSERT INTO new_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","परमप्रभु परमेश्‍वरं बँय् च्‍वंगु धू कयाः व हे धुलं फुक्‍क पशुत व झंगःपंक्षीत दय्‌कादिल। अले थुमित छु छु नां तइ धकाः स्‍वयेत वय्‌कलं थुपिं फुक्‍कसित मनूयाथाय् हल। मनुखं थुमित छु छु नां तल व हे व हे थुमिगु नां जुल। ");
INSERT INTO new_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","थुकथं मनुखं फुक्‍क छेँय् लहीपिं पशुत, आकाशय् च्‍वंपिं झंगःपंक्षीत व जंगलय् च्‍वंपिं पशुतय्‌त नां तयाबिल। थुपिं मध्‍ये मनूयात ग्‍वाहालि यायेत ल्‍वःम्‍ह धाःसा छम्‍ह हे मदु। ");
INSERT INTO new_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","अले परमप्रभु परमेश्‍वरं मनूयात छुं हे मचाय्‌क न्‍ह्यः वय्‌काबिल। व न्‍ह्यः वय्‌काच्‍वंबलय् परमेश्‍वरं वयागु बपिक्‍वँय् छपु लिकयाः उकिया थासय् लां जाय्‌कादिल। ");
INSERT INTO new_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","परमप्रभु परमेश्‍वरं व हे बपि क्‍वँचं मिसा मनू छम्‍ह दय्‌काः मनूयाथाय् हयादिल। ");
INSERT INTO new_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","अले मनुखं धाल, “थ्‍व ला जिगु हे क्‍वँचं दुगु क्‍वँय् व लां दुगु ला खः। थ्‍वयात मिसा धकाः धायेगु जुइ। छाय्‌धाःसा वयात मिजंया म्‍हं लिकयाः दय्‌कूगु खः।” ");
INSERT INTO new_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","अय्‌जूगुलिं मनू थः मां बौयात त्‍वःताः थः कलाःलिसे च्‍वंवनी। अले इपिं छम्‍ह हे जुइ। ");
INSERT INTO new_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","मिजं व वया कलाः निम्‍हं नांगा जूसां इमिके मछाः धयागु मदु। ");
INSERT INTO new_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","परमप्रभु परमेश्‍वरं दय्‌कादीपिं पशुत मध्‍ये सर्प दक्‍वसिबय् धूर्तम्‍ह खः। वं मिसायात धाल, “परमेश्‍वरं धात्‍थें हे क्‍यबय् च्‍वंगु गुगुं नं सिमाय् च्‍वंगु फल नये मते धाःगु खः ला?” ");
INSERT INTO new_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","मिसां सर्पयात धाल, “क्‍यबय् च्‍वंगु न्‍ह्यागु सिमाय् च्‍वंगु फल नःसां ज्‍यू, ");
INSERT INTO new_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","तर परमेश्‍वरं ‘क्‍यबय् दथुइच्‍वंगु सिमाया फल छता नयेगु जक मखु, थी तक नं मते, मखुसा छिपिं सी धयादीगु दु।’” ");
INSERT INTO new_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","सर्पं धाल, “छिपिं सी मखु। ");
INSERT INTO new_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","थ्‍व नल कि छिपिं नं परमेश्‍वर थें हे जुइ, छिमिगु मिखा चाली, अले छिमिसं छु भिं छु मभिं धयागु सी धकाः परमेश्‍वरं स्‍यूगुलिं हे अथे धाःगु खः।” ");
INSERT INTO new_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","मिसां व सिमाय् च्‍वंगु फल नये हे साइख्‍वाः वःगु व ल्‍वःवनापुसे च्‍वंगु खन। अले हाकनं ज्ञां दय्‌केगु लोभ नं मनय् वःगुलिं वं सिमाय् च्‍वंगु फल खानाः नल। अले थः भाःतयात नं बिल। वया भाःतं नं व फल नल। ");
INSERT INTO new_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","व फल नयेवं इपिं निम्‍हय्‌सिगुं मिखा चाल। इमिसं थःपिं पचिनांगा धयागु वाःचाल। अले यःमरिमाया हःयागु लं सुयाः इमिसं थःपिनिगु म्‍ह त्‍वपुल। ");
INSERT INTO new_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","बहनी परमप्रभु परमेश्‍वर क्‍यबय् चाःह्यूवःगु सः इमिसं ताल। अले इमिसं परमेश्‍वरयापाखें थःपिन्‍त बिसिकेत सिमां किकाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","तर परमप्रभु परमेश्‍वरं मनूयात सःतादिल, “छ गन दु?” ");
INSERT INTO new_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","वं लिसः बिल, “जिं क्‍यबय् छिगु सः ताःगु खः। पचिंनांगा जूगुलिं ग्‍यानाः जि सुपिलाच्‍वना।” ");
INSERT INTO new_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","परमेश्‍वरं धयादिल, “छ पचिनांगा धकाः सुनां धाल? छं जिं नये मते धयागु सिमाया फल नया ला?” ");
INSERT INTO new_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","मनुखं लिसः बिल, “छिं जिलिसें तयेहःम्‍ह मिसां व सिमाया फल जितः बी हल। अले जिं नयाबिया।” ");
INSERT INTO new_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","परमप्रभु परमेश्‍वरं व मिसायात धयादिल, “छं अथे छाय् यानागु?” वं लिसः बिल, “सर्पं जितः झंगः लानाः व फल नकल।” ");
INSERT INTO new_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","अले परमप्रभु परमेश्‍वरं सर्पयात धयादिल, “छं थथे याःगुलिं छेँय् लहीपिं व जंगलय् च्‍वनीपिं फुक्‍क पशु स्‍वयाः छं अप्‍वः सराः फयेमाली। प्‍वाथं चुयाः छ न्‍यासि वनेमाली। अले मसीतले चा नयेमाली। ");
INSERT INTO new_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","छंगु व मिसाया दथुइ अले छं मस्‍त व मिसाया मस्‍तय् दथुइ जिं ल्‍वापु थनाबी। वं छंगु छ्यं तछ्याइ, छं वयागु ग्‍वालिइ न्‍याइ।” ");
INSERT INTO new_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","अले वय्‌कलं मिसायात धयादिल, “जिं छन्‍त मचाबू ब्‍यथा अज्‍ज अप्‍वय्‌काबी। छं तसकं दुःख सियाः मचा बुइकी। अय्‌नं छंगु इच्‍छा भाःतपाखे हे क्‍वसालाच्‍वनी। अले वं छन्‍त अधीनय् तइ।” ");
INSERT INTO new_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","अले वय्‌कलं मनूयात धयादिल, “छं थः कलाःयागु खँ न्‍यनाः जिं नये मते धयागु सिमायागु फल नःगुलिं बुं सराः फयेमाली। छं मसीतले तसकं दुःखकष्‍ट यानाः थुकिं अन्‍न सय्‌काः नयेमाली। ");
INSERT INTO new_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","वं छंगु लागि कंमा व न्‍हाय्‌कं सय्‌की। अय्‌सां छं धाःसा अन्‍न व वाउँचा नयेखनी। ");
INSERT INTO new_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","चाय् तना मवंतले छं हिचःति हाय्‌काः नयेमाली। छाय्‌धाःसा छन्‍त चां हे दय्‌कूगु खः। छ चा खः, अले चा हे जुयावनी।” ");
INSERT INTO new_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","अले आदमं थः कलाःयागु नां हव्‍वा तल। छाय्‌धाःसा व फुक्‍क मनूतय् मां खः। ");
INSERT INTO new_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","अले परमप्रभु परमेश्‍वरं आदम व वया कलाःया लागि छेंगूया वसः दय्‌काः पुंकेबिल। ");
INSERT INTO new_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","अनंलि परमप्रभु परमेश्‍वरं धयादिल, “आः मनू नं झीपिं थें भिं व मभिं स्‍यूम्‍ह जुइ धुंकल। वं जीवनया सिमायागु फल नयेदइ मखु, अले सदां म्‍वानाच्‍वने नं दइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","उकिं परमप्रभु परमेश्‍वरं मनूयात वयात दय्‌कूगु चाय् ज्‍या याकेत अदनया क्‍यबं पितिनाछ्वयादिल। ");
INSERT INTO new_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","मनूयात पितिनाछ्वये धुंकाः परमेश्‍वरं जीवनया सिमायागु लँ पाखे पाः तयेत अदनया क्‍यबया पुर्बपाखे करूबत व प्‍यखें चाःहिलाच्‍वनीगु दनदन च्‍यानाच्‍वंगु तरवार तयादिल। ");
INSERT INTO new_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","आदम व हव्‍वाया दथुइ लसपस जुल। अले हव्‍वाया प्‍वाथय् दयाः कयिनयात बुइकल। वं धाल “परमप्रभुया आशिर्वादं जिकाय् दत।” ");
INSERT INTO new_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","अनं लिपा वं मेम्‍ह काय् हाबिल बुइकल। हाबिल फैजवाः जुल, कयिन बुँज्‍या याइम्‍ह जुल। ");
INSERT INTO new_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","छुं ई लिपा कयिनं परमप्रभुयात थःगु बुँइ सय्‌कूगु छायेहल। ");
INSERT INTO new_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","हाबिलं नं दक्‍वसिबय् न्‍हापां बूपिं फैतय्‌गु पुचलं दक्‍वसिबय् स्‍वयेज्‍यूम्‍ह फैचा ल्‍ययाः बलि बी हल। परमप्रभुं हाबिल व वयागु देछायात यय्‌कादिल। ");
INSERT INTO new_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","कयिन व वयागु देछायात धाःसा यय्‌का मदिल। उकिं कयिन तसकं तंम्‍वल। वयागु ख्‍वाः खिउँसे च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","अले परमप्रभुं वयात धयादिल, “छ छाय् तंम्‍वयागु? छंगु ख्‍वाः छाय् खिउँसे च्‍वंगु?” ");
INSERT INTO new_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","छं भिंगु ज्‍या याःसा ला छन्‍त नं यय्‌कीगु खः नि। छं भिंगु ज्‍या मयात धाःसा पाप छंगु लुखाय् हे वयाच्‍वनी। वं छन्‍त ल्‍हातय् कायेत स्‍वइ, तर छं वयात बसय् काये हे माः। ");
INSERT INTO new_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","अले कयिनं थःकिजा हाबिलयात धाल, “बुँइ वनेनु।” बुँइ थ्‍यंकाः कयिनं थःकिजा हाबिलयात हय्‌काल, अले स्‍यानाबिल। ");
INSERT INTO new_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","अले परमप्रभुं कयिनयात धयादिल, “छिमि किजा हाबिल ग्‍व?” कयिनं लिसः बिल, “जिं मस्‍यू। जि जिमि किजाया जवाः खः ला?” ");
INSERT INTO new_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","परमप्रभुं धयादिल, “छं थ्‍व छु यानागु? छिमि किजायागु हिं जितः बँ दुनें सः बियाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","छं आः बँ स्‍वयाः अप्‍वः सराः फयेमाली। छाय्‌धाःसा थ्‍व बं छंगु ल्‍हातिं छिमि किजायागु हि फयेत म्‍हुतु वांखाःगु दु। ");
INSERT INTO new_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","छं बुँज्‍या याःसां छन्‍त वं अन्‍न बी मखु। छ पृथ्‍वीइ थाय्‌बाय् मदय्‌का उखेंथुखें जुइमाली।” ");
INSERT INTO new_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","अले कयिनं परमप्रभुयात धाल, “थ्‍व ला जिं सह याये मफइगु सजाँय जुल। ");
INSERT INTO new_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","स्‍वयादिसँ, थौं छिं जितः थ्‍व बं पितिनादिल। जि छिपाखें सुपिलाः जुइमाली। अले थाय्‌बाय् मदय्‌काः जुइमाली। अले जितः सुनानं स्‍याना नं बी फु।” ");
INSERT INTO new_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","परमप्रभुं धयादिल, “अथे मखु। कयिनयात स्‍याःम्‍हय्‌सित न्‍हय्‌दुगं अप्‍वः बदला काइ।” उकिं परमप्रभुं वयात सुनानं स्‍याये मफयेमा धकाः वयागु कपालय् छगू चिं तयाबियादिल। ");
INSERT INTO new_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","अले व परमप्रभुया थासं पिहां वनाः अदनया पुर्बपाखे च्‍वंगु नोद धयागु देशय् च्‍वंवन। ");
INSERT INTO new_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","कयिनया थः कलाःलिसे लसपस जुल। अले वया प्‍वाथय् दयाः हनोकयात बुइकल। कयिनं छगू शहर दय्‌कल। अले उकियात थः काय्‌या नामं हनोक धकाः नां तयाबिल। ");
INSERT INTO new_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","हनोकया पाखें ईराद बुल। ईरादया पाखें महूयाएल बुल। महूयाएलया पाखें मतूशाएल बुल। मतूशाएलया पाखें लेमेख बुल। ");
INSERT INTO new_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेखं निम्‍ह कलाः ब्‍याहा यात। छम्‍हय्‌सिगु नां आदा व मेम्‍हय्‌सिगु नां सिल्‍ला खः। ");
INSERT INTO new_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदाया पाखें याबाल बुल। व पशु लहीपिं व पालय् च्‍वनीपिनि पुर्खा खः। ");
INSERT INTO new_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","वया किजा यूबाल खः। व वीणा थाइपिं व बाँसुरी पुइपिनि पुर्खा खः। ");
INSERT INTO new_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्‍लां तूबल-कयिनयात बुइकल। व ली व नँया ज्‍याभः दय्‌कीपिनि पुर्खा खः। वया क्‍यहेँ नामा खः। ");
INSERT INTO new_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेखं तःधंछुयाः थः कलाःपिन्‍त धाल, “आदा व सिल्‍ला, जिगु खँ न्‍यँ, लेमेखया कलाःपिं, जिं धयागु खँ न्‍यँ, जिं छम्‍ह मनूयात जितः ल्‍हाः वाःगुलिं स्‍यानाबियागु दु। जितः घाः याःम्‍ह छम्‍ह ल्‍याय्‌म्‍हम्‍ह मनूयात। ");
INSERT INTO new_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","कयिनयात स्‍यात धाःसा वयागु न्‍हय्‌दुगं अप्‍वः बदला काइ सा, लेमेखयात स्‍यात धाःसा न्‍हयेन्‍हय्‌दुगं अप्‍वः बदला काइ।” ");
INSERT INTO new_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","आदमया थः कलाःलिसे हाकनं लसपस जुल। अले वं मेम्‍ह छम्‍ह काय् बुइकल। “परमेश्‍वरं जितः कयिनं स्‍यानाब्‍यूम्‍ह हाबिलया थासय् मेम्‍ह काय् बियादीगु दु” धकाः वं वयागु नां शेत तयाबिल। ");
INSERT INTO new_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेतया नं छम्‍ह काय् बुल। वं वयागु नां एनोश तल। उबलय्‌निसें मनूतय्‌सं परमप्रभुया नां कायेगु याना हल। ");
INSERT INTO new_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदमया सन्‍तानयागु धलः थुकथं दु, परमेश्‍वरं मनूया सृष्‍टि यानादीबलय् वय्‌कलं इमित थःगु हे ख्‍वाःलसि वयेक दय्‌कादिल। ");
INSERT INTO new_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","वय्‌कलं इमित मिजं व मिसा दय्‌कादिल। अले आशिष बियादिल। वय्‌कलं इमित “मनू” धकाः नां तयादिल। ");
INSERT INTO new_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","सच्‍छि व स्‍विदँ दुबलय् आदमया थःथें तुं च्‍वंम्‍ह काय् बुल। वं वयागु नां शेत तल। ");
INSERT INTO new_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","अनंलि आदम ८०० दँ तक म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","थुकथं आदम ९३० दँ तक म्‍वानाः सित। ");
INSERT INTO new_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","शेत १०५ दँ दुबलय् वया एनोश धाःम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","अनंलि शेत ८०७ दँ तक म्‍वात। थुलिया दुने वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","थुकथं शेत ९१२ दँ तक म्‍वानाः सित। ");
INSERT INTO new_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","एनोश ९० दँ दुबलय् वया केनान धाःम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","अनंलि व मेगु ८१५ दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","थुकथं एनोश ९०५ दँ तक म्‍वानाः सित। ");
INSERT INTO new_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","केनान ७० दँ दुबलय् वया महलालेल धाःम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","अनंलि व मेगु ८४० दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","थुकथं केनान ९१० दँ म्‍वानाः सित। ");
INSERT INTO new_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","महलालेल ६५ दँ दुबलय् वया येरेद धाःम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","अनंलि व मेगु ८३० दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","थुकथं महलालेल ८९५ दँ म्‍वानाः सित। ");
INSERT INTO new_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","येरेद १६२ दँ दुबलय् वया हनोक धाःम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","अनंलि व मेगु ८०० दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","थुकथं येरेद ९६२ दँ म्‍वानाः सित। ");
INSERT INTO new_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","हनोक ६५ दँ दुबलय् वया मतूशेलह धाःम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","अनंलि व ३०० दँ तक परमेश्‍वरं धाःथें जुइम्‍ह जुयाः जुल। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","हनोक मुक्‍कं ३६५ दँ म्‍वात। ");
INSERT INTO new_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","वं म्‍वातले परमेश्‍वरं धाःथें यानाः जुल। अले व तना वन छाय्‌धाःसा परमेश्‍वरं वयात थःनापं यंकादिल। ");
INSERT INTO new_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मतूशेलह १८७ दँ दुबलय् वया लेमेक धाःम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेक बुइधुंकाः मतूशेलह ७८२ दँ तक म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","थुकथं मतूशेलह ९६९ दँ तक म्‍वानाः सित। ");
INSERT INTO new_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","लेमेक १८२ दँ दुबलय् वया काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","वं वयागु नां “परमप्रभुं सराः ब्‍यूगु बँय् झीसं यानाच्‍वनागु ज्‍यापाखें थ्‍वं झीत छुत्‍कारा बी” धकाः नोआ तल। ");
INSERT INTO new_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","लेमेक मेगु ५९५ दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","थुकथं लेमेक ७७७ दँ म्‍वानाः सित। ");
INSERT INTO new_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नोआ ५०० दँ दुबलय् वया शेम, हाम व येपेत नांयापिं स्‍वम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","पृथ्‍वीइ मनूत यक्‍व दयावल, अले इमि म्‍ह्याय्‌पिं नं बुल, ");
INSERT INTO new_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","परमेश्‍वरया काय्‌पिन्‍सं मनूतय् बाबांलाःपिं म्‍ह्याय्‌पिं खनाः थःत यःयःपिं ल्‍ययाः ब्‍याहा यात। ");
INSERT INTO new_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","अले परमप्रभुं धयादिल, “जिगु आत्‍मा मनूतय्‌गु नुगलय् सदां च्‍वनी मखु। छाय्‌धाःसा इपिं सदां दइपिं मखु। आवंलि इपिं १२० दँ स्‍वया अप्‍वः म्‍वाइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","उबलय् व वयां लिपा तक नं पृथ्‍वीइ नेफिलीमत दुगु खः। परमेश्‍वरया काय्‌पिं व मनूतय् म्‍ह्याय्‌पिनि पाखें मस्‍त दत। इपिं उबलय्‌या बल्‍लाःपिं व नांजाःपिं खः। ");
INSERT INTO new_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","पृथ्‍वीइ च्‍वंपिं मनूत मभिनावःगु व इमिगु नुगलय् न्‍ह्याबलें मभिंगु खँ जक थानाच्‍वंगु खनाः परमप्रभुं थःम्‍हं ");
INSERT INTO new_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","पृथ्‍वीइ मनूत सृष्‍टि यानागुलिं पस्‍ताय् चायादिल। वय्‌कलं तसकं नुगः मछिंकादिल। ");
INSERT INTO new_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","अले परमप्रभुं धयादिल, “जिं सृष्‍टि यानापिं फुक्‍क मनूतय्‌त पृथ्‍वीं न्‍हंकाछ्वयाबी। अज्‍ज ला फुक्‍क पशु, बँय्‌ घिसय् जुयाजुइपिं जन्‍तुत व आकाशय् च्‍वंपिं पंक्षीतय्‌त तकं न्‍हंकाछ्वयाबी। छाय्‌धाःसा थुमित सृष्‍टि यानाः जि पस्‍ताय् चाये धुन।” ");
INSERT INTO new_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","नोआ खनाः धाःसा परमप्रभु लय्‌तायादिल। ");
INSERT INTO new_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नोआ व वया परिवारया खँ थथे दु, नोआ उगु इलय्‌याम्‍ह धर्मीम्‍ह व छुं दोष मदुम्‍ह मनू खः। व परमेश्‍वरं धाःथें जुइम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","वया स्‍वम्‍ह काय् दु – शेम, हाम व येपेत। ");
INSERT INTO new_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","परमेश्‍वरं पृथ्‍वीइ स्‍वयादीबलय् पृथ्‍वीइ च्‍वंपिं फुक्‍क मनूत मभिंपिं जुयावःगु व न्‍ह्याथासं ल्‍वापुख्‍यापु जक खनादिल। ");
INSERT INTO new_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","अले परमेश्‍वरं नोआयात धयादिल, “पृथ्‍वीइ च्‍वंपिं फुक्‍क मनूतय्‌त जिं न्‍हंकाछ्वयेगु क्‍वःछीधुन। जिं इमित पृथ्‍वी नापं सुचुक न्‍हंकाछ्वये। छाय्‌धाःसा पृथ्‍वी इमिगु ल्‍वापुख्‍यापुं जाये धुंकल। ");
INSERT INTO new_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“छं भिंगु सिँयागु जहाज छगू दय्‌कि। उकी दुने क्‍वथा दय्‌कि। अले उकिया दुनेपिने अलकत्रां पा। ");
INSERT INTO new_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","छं उकियात १५० मिटर हाकः, २५ मिटर ब्‍या व १५ मिटर जाः यानाः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","जः वय्‌केत जहाजया च्‍वय् छकु ति त्‍वःताः पौ दय्‌कि। जहाजयात स्‍वतँ जाः यानाः दय्‌कि। अले छखेपाखे लुखा दय्‌कि। ");
INSERT INTO new_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“छाय्‌धाःसा जिं पृथ्‍वीइ च्‍वंपिं फुक्‍कसित न्‍हंकेत खुसिबाः वय्‌के त्‍यनागु दु। पृथ्‍वीइ च्‍वंपिं फुक्‍कं सी। ");
INSERT INTO new_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","तर जिं छलिसे बाचा चिने। छ छिमि कलाः, काय्‌पिं व भौपिं ब्‍वनाः जहाजय् च्‍वंहुँ। ");
INSERT INTO new_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","अले ज्‍यान दुपिं फुक्‍क जातयापिं छज्‍वः छज्‍वः यानाः जहाजय् ति। इपिं नं छलिसे हे म्‍वायेमाः। इपिं फुक्‍कं भाले-पोथी जुइमाः। ");
INSERT INTO new_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","पृथ्‍वीइ च्‍वंपिं फुक्‍क जातयापिं झंगः, फुक्‍क जातयापिं वस्‍तु व बँय् घिसय्‌ जुयाजुइपिं छज्‍वः छज्‍वः म्‍वानाच्‍वनेत छलिसे वइ। ");
INSERT INTO new_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","छंगु व इमिगु लागि नयेत फुक्‍क कथंयागु नसा नं मुंकाः ति।” ");
INSERT INTO new_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","नोआं परमेश्‍वरं धाःथें फुक्‍कं यात। ");
INSERT INTO new_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","अले परमप्रभुं नोआयात धयादिल, “छ व छिमि परिवार फुक्‍क जहाजय् च्‍वंहुँ। छाय्‌धाःसा जिं थ्‍व पुस्‍ताय् छ हे छम्‍ह जक धर्मीम्‍ह मनू खना। ");
INSERT INTO new_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","शुद्धपिं फुक्‍क पशु भाले-पोथी यानाः न्‍हय्‌ज्‍वः न्‍हय्‌ज्‍वः व अशुद्धपिं पशु छज्‍वः छज्‍वः जक यंकि। ");
INSERT INTO new_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","अथे हे फुक्‍क जातयापिं झंगः नं भाले-पोथी यानाः न्‍हय्‌ज्‍वः न्‍हय्‌ज्‍वः यंकि। थुकथं फुक्‍क जातयापिं झंगःयात पृथ्‍वीइ ल्‍यंकातयेत थुमित म्‍वाकातयेमाः। ");
INSERT INTO new_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","थनिं न्‍हय्‌न्‍हु लिपा जिं पृथ्‍वीइ वा वय्‌के। थ्‍व वा पिइन्‍हु व पिइचा तक वइ। जिं दय्‌कापिं फुक्‍क प्राणीतय्‌त पृथ्‍वीं न्‍हंकाछ्वये।” ");
INSERT INTO new_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","नोआं परमप्रभुं धाःथें फुक्‍कं यात। ");
INSERT INTO new_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","पृथ्‍वीइ खुसिबाः वःबलय् नोआ ६०० दँ दुम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नोआ, वया कलाः, काय्‌पिं व भौपिं लखं बचय् जुइत जहाजय् दुहां वन। ");
INSERT INTO new_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","शुद्धपिं व अशुद्धपिं पशु, झंगः, बँय् घिसय्‌ जुयाजुइपिं फुक्‍कं ");
INSERT INTO new_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","परमेश्‍वरं धाःथें भाले-पोथी यानाः छज्‍वः छज्‍वः नोआलिसें जहाजय् वन। ");
INSERT INTO new_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","न्‍हय्‌न्‍हु दुखुन्‍हु वा वल। ");
INSERT INTO new_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","पृथ्‍वीया तःलय् च्‍वंगु लःया फुक्‍क धाः बँ तछ्यानाः पिहां वःबलय् नोआ ६०० दँ क्‍यनाच्‍वंगु खः। आकाशया लुखात चालावन, ");
INSERT INTO new_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","अले पिइन्‍हु व पिइचा तक पृथ्‍वीइ वा वयाच्‍वन। थ्‍व फुक्‍क उगु दँया निगूगु लाया झिंन्‍हय्‌न्‍हुखुन्‍हुनिसें शुरु जूगु खः। ");
INSERT INTO new_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","उखुन्‍हु हे नोआ व वया कलाः स्‍वम्‍ह काय्‌पिं शेम, हाम व येपेत व इमि कलाःपिन्‍त ज्‍वनाः जहाजय् दुहां वन। ");
INSERT INTO new_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","इपिं लिसें फुक्‍क जातयापिं पशु, लहीपिं व जंगली फुक्‍क जातयापिं पशु, पृथ्‍वीइ घिसय्‌ जुयाजुइपिं प्राणीत व फुक्‍क जातयापिं झंगः पंक्षी नं दुहां वन। ");
INSERT INTO new_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","सासः ल्‍हाइपिं फुक्‍क प्राणीत भाले-पोथी यानाः जहाजय् नोआयाथाय् वल। ");
INSERT INTO new_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","परमेश्‍वरं नोआयात धयादीथेंयापिं फुक्‍क प्राणी भाले-पोथी यानाः जहाजय् दुहां वल। अले परमप्रभुं जहाजया खापा तिनादिल। ");
INSERT INTO new_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","पिइन्‍हु तक वा व खुसिबाः वयाच्‍वन। अले लः तजाः जुयाः जहाजयात च्‍वय् च्‍वय् छ्वल। ");
INSERT INTO new_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","लः तसकं तजाः जुयाः जहाज ल्‍यहें ल्‍यहें पुल। ");
INSERT INTO new_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पृथ्‍वी स्‍वयां च्‍वय् च्‍वय् थ्‍यंक लः तजाः जुल, अले ततःजाःगु पहाडत नापं त्‍वपुल। ");
INSERT INTO new_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","लः तजाः जुयाः पहाडत स्‍वयाः झिंन्‍याकु च्‍वय् थ्‍यंक थाहां वन। ");
INSERT INTO new_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","पृथ्‍वीइ च्‍वंपिं झंगः, छेँय् लहीपिं, जंगलय् च्‍वनीपिं, बँय् घिसय्‌ जुयाजुइपिं पशु व मनूत, फुक्‍क प्राणी सित। ");
INSERT INTO new_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","पृथ्‍वीइ च्‍वंपिं सासः ल्‍हाइपिं फुक्‍क प्राणी सित। ");
INSERT INTO new_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","परमप्रभुं पृथ्‍वीइ च्‍वंपिं फुक्‍क मनू, छेँय् लहीपिं, बँय् घिसय्‌ जुयाजुइपिं प्राणीत व फुक्‍क झंगःपंक्षी न्‍हंकादिल। नोआ व नोआलिसे जहाजय् दुपिं प्राणीत जक ल्‍यन। ");
INSERT INTO new_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","पृथ्‍वी सच्‍छि व नेय्‌न्‍हु तक लखं जायाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","अले परमेश्‍वरं नोआ व वलिसे जहाजय् दुपिं फुक्‍क जंगलय् च्‍वनीपिं व छेँय् लहीपिं पशुतय्‌त लुमंकादिल। वय्‌कलं पृथ्‍वीइ फय् वय्‌कादिल। अले लः बुलुहुं सुनावन। ");
INSERT INTO new_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","वा वःगु पिइन्‍हु लिपा पृथ्‍वीया तःलय् च्‍वंगु फुक्‍क लःया धाः व आकाशय् च्‍वंगु ह्वः तित। वा वयेगु दित। ");
INSERT INTO new_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","पृथ्‍वीइ च्‍वंगु लः बुलुहुं सुनावन। सच्‍छि व नेय्‌न्‍हु दुखुन्‍हु लः भचा पाः जुल। ");
INSERT INTO new_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","थुकथं न्‍हय्‌गूगु लाया झिंन्‍हय्‌न्‍हु खुन्‍हु जहाज आरारातया पहाडय् जूवल। ");
INSERT INTO new_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","झिगूगु ला तक लः सुनावनाच्‍वन। झिगूगु लाया न्‍हापांगु दिंखुन्‍हु पहाडया च्‍वका खनेदत। ");
INSERT INTO new_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","पिइन्‍हु लिपा नोआं थःम्‍हं जहाजय् दय्‌कूगु झ्‍याः चाय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","अले क्‍वः छम्‍हय्‌सित ब्‍वय्‌काछ्वत। पृथ्‍वीइ लः मसुतले क्‍वः उखेंथुखें ब्‍वयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","अनंलि नोआं जमिनय्‌ लः सुत ला मसूनि ला धकाः स्‍वयेत सुकुभत्तु छम्‍ह ब्‍वय्‌काछ्वत। ");
INSERT INTO new_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","बँय् लःया लः जक जुयाच्‍वंगुलिं जुइगु थाय् तकं मदयाः सुकुभत्तु जहाजय् तुं लिहां वल। नोआं थःगु ल्‍हाः पित हयाः सुकुभत्तुयात ज्‍वनाः जहाजय् दूत काल। ");
INSERT INTO new_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","वं हाकनं न्‍हय्‌न्‍हु तक पिल। अले हाकनं सुकुभत्तुयात जहाजं ब्‍वय्‌काछ्वत। ");
INSERT INTO new_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","बहनिइ लिहां वःबलय् सुकुभत्तुया त्‍वाथय् नकतिनि त्‍वाथला हःगु जैतूनया हः छहः नं दु। अले नोआं पृथ्‍वीइ लः पाः जुइ धुंकल धकाः सीकाकाल। ");
INSERT INTO new_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","वं हाकनं मेगु न्‍हय्‌न्‍हु पिल। अले हाकनं सुकुभत्तुयात ब्‍वय्‌काछ्वत। थुबलय् धाःसा सुकुभत्तु लिहां मवल। ");
INSERT INTO new_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नोआ खुसः व दच्‍छि (६०१) दँ क्‍यंगु न्‍हापांगु लाया न्‍हापांगु दिं पृथ्‍वीइ च्‍वंगु लः सुत। नोआं जहाजया पौ चीकाः स्‍वःबलय् बँ गनावनाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","निगूगु लाया निइन्‍हय्‌न्‍हु खुन्‍हु बँ बांलाक गन। ");
INSERT INTO new_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","अले परमेश्‍वरं नोआयात धयादिल, ");
INSERT INTO new_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“छिमि कलाः, काय्‌पिं व भौपिं ब्‍वनाः जहाजं पिहां वा। ");
INSERT INTO new_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","छलिसें फुक्‍क सासः दुपिं, झंगः, पशु, व घिसय् जुयाजुइपिं फुक्‍कसित पित हति। अले इपिं पृथ्‍वीइ अप्‍वयावने मा, यक्‍व दयावनेमा।” ");
INSERT INTO new_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","अले नोआ थःकाय्‌पिं, कलाः व भौपिंलिसे जहाजं पिहां वल। ");
INSERT INTO new_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","फुक्‍क कथंया पशु, पृथ्‍वीइ घिसय्‌ जुयाजुइपिं व जात जातकथं झंगःपंक्षी नं छज्‍वः छज्‍वः यानाः जहाजं पिहां वल। ");
INSERT INTO new_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","नोआं परमप्रभुया लागि छगू बलि बीगु थाय् दय्‌कल। अले फुक्‍क कथंया शुद्धपिं पशु व पक्षी छम्‍ह छम्‍ह ल्‍ययाः होमबलि बिल। ");
INSERT INTO new_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","उकिं लय्‌तायाः परमप्रभुं मनं मनं धयादिल, “मनूया नुगलय् मचांनिसें हे मभिंगु खँ बुयावःसां आः हाकनं जिं मनूया कारणं पृथ्‍वीयात सराः बी मखुत। अले न्‍हापा याना थें आः हाकनं ज्‍यान दुपिं फुक्‍कसितं नाश याये मखुत। ");
INSERT INTO new_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","पृथ्‍वी दतले सिनाज्‍या व सामाज्‍या चिकु व तांन्‍वः ताल्‍ला व चिकुला न्‍हि व चा दयांच्‍वनी।” ");
INSERT INTO new_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","अले परमेश्‍वरं नोआ व वया काय्‌पिन्‍त आशिष बियाः धयादिल, “छिमि सन्‍तान यक्‍व दयाः पृथ्‍वी जायेमा। ");
INSERT INTO new_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","पृथ्‍वीइ च्‍वंपिं फुक्‍क पशुत, आकाशय् च्‍वंपिं झंगःपंक्षीत, बँय् घिसय्‌ जुयाजुइपिं व समुद्रय् च्‍वंपिं न्‍यात छिपिं खनाः ग्‍यायेमा। इपिं फुक्‍कसित छिमिगु हे ल्‍हातय् त्‍वःताबियागु दु। ");
INSERT INTO new_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","फुक्‍क पशु व पक्षीत छिमित नयेत बियागु दु। अन्‍नमा व वाउँचात बिया थें जिं छिमित फुक्‍कं बी। ");
INSERT INTO new_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","तर म्‍वाः हि दुगु ला छता नये मते। छाय्‌धाःसा हिइ हे जीवन दइ। ");
INSERT INTO new_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“जिं छिमिगु प्राण बीगु हिया ल्‍याःचाः काये। फुक्‍क पशुयाके व मनूतय्‌के जिं मनूया हिया ल्‍याःचाः काये। ");
INSERT INTO new_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“सुनां मनूया हि बाः वय्‌की वयागु नं हि बाः वइ, छाय्‌धाःसा प रमेश्‍वरं मनूयात थःथें हे च्‍वंक दय्‌कादीगु दु। ");
INSERT INTO new_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“आः छं थःपिनि सन्‍तान यक्‍व दय्‌काः पृथ्‍वी जाय्‌की।” ");
INSERT INTO new_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","परमेश्‍वरं नोआ व वया काय्‌पिन्‍त धयादिल, ");
INSERT INTO new_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“आः जिं छिमित, लिपा वइपिं छिमि सन्‍तानयात, ");
INSERT INTO new_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","अले छिपिंलिसे जहाजं पिहांवःपिं फुक्‍क झंगःत, लहीपिं व जंगली पशुत व पृथ्‍वीइ दुपिं प्राणीतलिसे जिं बाचा चिने। ");
INSERT INTO new_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","जिं छिपिंलिसे बाचा चिने, आः हाकनं खुसिबाः वयाः सुं हे प्राणी सी मखु, आः हाकनं खुसिबाः वयाः पृथ्‍वी नाश जुइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","परमेश्‍वरं धयादिल, “जिं छिमित व फुक्‍क प्राणीलिसे सदांया लागि चिनागु बाचाया चिंकथं ");
INSERT INTO new_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","जिं सुपाँचय् थःगु इन्‍द्रेणी तयाबी। थ्‍व जिं संसारलिसे चिनागु बाचाया चिं जुइ। ");
INSERT INTO new_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","गुबलय् जिं पृथ्‍वीया च्‍वय् सुपाँचं भुने, अले आकाशय् इन्‍द्रेणी खनेदइ, ");
INSERT INTO new_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","उबलय् जिं छिमित व फुक्‍क प्राणीलिसे चिनागु बाचा लुमंके। पृथ्‍वीइ आः हाकनं खुसिबाः वयाः फुक्‍क प्राणीत सी मखु। ");
INSERT INTO new_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","आकाशय् गुबलय् इन्‍द्रेणी खनेदइ, उकियात स्‍वयाः जिं पृथ्‍वीइ च्‍वंपिं फुक्‍क प्राणीलिसे सदांया लागि चिनागु बाचा लुमंके।” ");
INSERT INTO new_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","परमेश्‍वरं नोआयात हाकनं धयादिल, “पृथ्‍वीइ च्‍वंपिं फुक्‍क प्राणीलिसे चिनागु बाचाया चिं थ्‍व हे खः।” ");
INSERT INTO new_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","नोआलिसें जहाजं पिहांवःपिं वया काय्‌पिं शेम, हाम व येपेत खः। (हाम कनानया बौ खः।) ");
INSERT INTO new_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","नोआया थुपिं स्‍वम्‍ह काय् पृथ्‍वीया फुक्‍क मनूतय् तापाःबाज्‍यापिं खः। ");
INSERT INTO new_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","नोआं बुँज्‍या यात। दक्‍वसिबय् न्‍हापां दाखमा प्‍यूम्‍ह नोआ खः। ");
INSERT INTO new_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","छन्‍हु व दाखमद्य त्‍वनाः काय्‌काः पचिंनांगा थःगु पालय् द्यनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","कनानया बौ हामं बौयात पचिनांगां खनाः पिने वयाः थः दाजुपिन्‍त कन। ");
INSERT INTO new_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","अले शेम व येपेतं थःपिनिगु ब्‍वहलय् गा छपु पाछायाः लिखतं वनाः थः बौयात त्‍वपुयाबिल। फस्‍वयाच्‍वंगुलिं इमिसं बौम्‍हय्‌सिया पचिनांगागु म्‍ह मखं। ");
INSERT INTO new_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","दाखमद्यं त्‍वःतेवं नोआ दन अले दक्‍वसिबय् चीधीम्‍ह काय्‌नं थःत छु यात धयागु सीकल। ");
INSERT INTO new_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","अले वं धाल, “कनानयात सराः लायेमा। व थः दाजुकिजाया दासया नं दास जुइ।” ");
INSERT INTO new_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","वं हानं धाल, “शेमया परमप्रभुयात धन्‍य धा। कनान शेमया दास जुइ। ");
INSERT INTO new_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्‍वरं येपेतयात थकायेमा। वं शेमया पालय् बासं च्‍वनेदयेमा। कनान येपेतया दास जुइ।” ");
INSERT INTO new_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","खुसिबाः वयाः ३५० दँ तक नोआ म्‍वात। ");
INSERT INTO new_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","अले गुसः व न्‍यय्‌दँय् (९५०) व सित। ");
INSERT INTO new_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नोआया काय्‌पिं शेम, हाम व येपेतया सन्‍तानया खँ थथे दु। थुपिं खुसिबाः वःगुया लिपा बूगु खः। ");
INSERT INTO new_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेतया काय्‌पिं – गोमेर, मागोग, मादे, यावान, तूबल, मेशेक व तीरास। ");
INSERT INTO new_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेरया काय्‌पिं – अशकनज, रीपत व तोगर्मा। ");
INSERT INTO new_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावानया काय्‌पिं – एलीशाह, तर्शीश, कित्तीम व रोदानीम। ");
INSERT INTO new_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","थुमिपाखें हे समुद्र सिथय् च्‍वनीपिं मनूत न्‍यनावन। थुकथं येपेतया सन्‍तान थीथी थाय्, भाय्, जात व जाति जुयाः न्‍यनावन। ");
INSERT INTO new_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हामया काय्‌पिं – कूश, मिश्रइम, पूत व कनान। ");
INSERT INTO new_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूशया काय्‌पिं – सेबा, हवीला, सब्‍ता, रामाह व सब्‍तका। रामाहया काय्‌पिं – शेबा व ददान। ");
INSERT INTO new_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूशया निम्रोद धाःम्‍ह काय् नं दु। पृथ्‍वीइ न्‍हापांम्‍ह बल्‍लाःम्‍ह मनू व हे खः। ");
INSERT INTO new_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","परमप्रभुया मिखाय् व छम्‍ह तसकं बल्‍लाःम्‍ह शिकारी खः। धापू हे नं दु, “निम्रोद थें परमप्रभुया मिखाय् बल्‍लाःम्‍ह शिकारी” धकाः। ");
INSERT INTO new_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","वं थःगु राज्‍ययात दक्‍वसिबय् न्‍हापां बेबिलोन, एरेक, अक्‍कद व कल्‍नेहंनिसें न्‍ह्याकल। थ्‍व फुक्‍क शिनार देशय् लाः। ");
INSERT INTO new_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","अनं हे व अश्‍शूर धाःथाय् वन। अन वं निनवे, रहोबोत-इर व कालह शहर दय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","अनंलि वं निनवे व तःधंगु शहर कालहया दथुइ रेसेन शहर दय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिश्रइमया काय्‌पिं – लूदी, अनामी, लहाबी, नप्‍तूही, ");
INSERT INTO new_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पत्रुसी, कस्‍लूही व कप्‍तोरी खः। कस्‍लूहीपाखें पलिश्‍तीत पिहां वल। ");
INSERT INTO new_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनानं सीदोनयात बुइकल। ");
INSERT INTO new_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","कनान हित्ती, यबूसी, एमोरी, गिर्गशी ");
INSERT INTO new_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्‍वी, अरकी, सिनी ");
INSERT INTO new_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वादी, समारी व हमातीतय् तापाःबाज्‍या खः। अनंलि कनानया सन्‍तान न्‍ह्याथासं न्‍यनावन। ");
INSERT INTO new_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","थुकथं कनान वंशयागु लागा सीदोनंनिसें दच्‍छिनपाखे गाजाया लिक्‍क च्‍वंगु गरार तक, पुर्बपाखे सदोम, गमोरा, अदमा व लाशाया लिक्‍क च्‍वंगु सबोयीम तक थ्‍यन। ");
INSERT INTO new_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","हामया सन्‍तान थथःगु थीथी जात, जाति, भाय् व थाय्‌कथं च्‍वनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","येपेतया तःधीम्‍ह दाजु शेमया नं काय्‌पिं बुल। शेम एबेरया फुक्‍क सन्‍तानया तापाःबाज्‍या खः। ");
INSERT INTO new_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेमया काय्‌पिं – एलाम, अश्‍शूर, अर्पक्षद, लूद व अराम खः। ");
INSERT INTO new_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","अरामया काय्‌पिं – ऊज, हुल, गेतेर व मेशेक खः। ");
INSERT INTO new_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षदं शेलहयात बुइकल। शेलहं एबेरयात बुइकल। ");
INSERT INTO new_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबेरया निम्‍ह काय् दत। तःधीम्‍हसिया नां पेलेग खः। थ्‍वयागु हे इलय् पृथ्‍वीइ मनूत बायावंगु खः। वया किजाया नां योक्तान खः। ");
INSERT INTO new_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योक्तानं अल्‍मोदद, शेलेप, हसर्मवित, येरह ");
INSERT INTO new_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोरम, ऊजाल, दिक्‍ला ");
INSERT INTO new_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबमाएल, शेबा ");
INSERT INTO new_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला व योबाबयात बुइकल। थुपिं फुक्‍कं योक्तानया काय्‌पिं खः। ");
INSERT INTO new_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","इमिगु थाय्‌बाय् मेशांनिसें पुर्बया सपारा धाःगु पहाड तक थ्‍यंगु खः। ");
INSERT INTO new_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","शेमया थुपिं सन्‍तानत थथःगु जात जाति, थीथी भाय् व थाय्‌कथं च्‍वनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नोआया काय्‌पिनि सन्‍तान कथहं थुपिं हे खः। खुसिबाः वःगु लिपा थुपिं हे थीथी जात जातियापिं जुयाः पृथ्‍वीइ न्‍यनावन। ");
INSERT INTO new_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","उबलय् पृथ्‍वी न्‍यंक मनूतय्‌सं छगू हे भाय् व छगू हे कथंया खँग्‍वः छ्यलीगु खः। ");
INSERT INTO new_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","पुर्बपाखे न्‍ह्यज्‍याज्‍यां वंबलय् इपिं शिनार देशया छगू मैदानय् थ्‍यन। अले अन हे च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","इमिसं थःथवय् खँ ल्‍हात, “आः झीसं अप्‍पा दय्‌काः मिइ छुये।” अले इमिसं ल्‍वहंया थासय् अप्‍पा व चाया थासय् अलकत्रा छ्यल। ");
INSERT INTO new_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","अले इमिसं धाल, “आः छगू शहर दय्‌के, अले स्‍वर्ग तक थ्‍यनीगु धरहरा दय्‌काः झीगु नां तये। थुकथं झी पृथ्‍वी न्‍यंक छ्यालब्‍याल जुइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","परमप्रभु मनूतय्‌सं दय्‌काच्‍वंगु शहर व धरहरा स्‍वयेत कुहां झाल। ");
INSERT INTO new_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","अले वय्‌कलं धयादिल, “थुपिं फुक्‍क छगू हे जातियापिं व छगू हे भाय् ल्‍हाइपिं जुयाच्‍वन। थ्‍व ला इमिसं यायेत्‍यंगु ज्‍याया शुरु जक खः। आवंलि थुमिसं मनंतुंगु न्‍ह्यागुं याये फइ। ");
INSERT INTO new_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","कुहां वनेनु, अले झीसं इमिगु भाय्‌यात ल्‍वाकःबुकः याये। अले इमिसं थवंथवय् धाःगु खँ थुइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","थुकथं परमप्रभुं इमित पृथ्‍वी न्‍यंक छ्यालब्‍याल यानाबिल। अले इमिसं व शहर दय्‌केगु ज्‍या त्‍वःतल। ");
INSERT INTO new_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","अथे जुयाः उगु शहरयागु नां बाबेल च्‍वन। छाय्‌धाःसा परमप्रभुं अन मनूतय्‌गु भाय्‌यात ल्‍वाकःबुकः यानादीगु खः, अले इमित पृथ्‍वी न्‍यंक छ्यालब्‍याल यानादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेमया सन्‍तानया खँ थथे दु – खुसिबाः वःगु निदँ लिपा सच्‍छिदँ दुबलय् शेमया अर्पक्षद धाःम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अनंलि व मेगु ५०० दँ म्‍वात। वया मेमेपिं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","अर्पक्षद स्‍विन्‍यादँ दुबलय् वया शेलह नांयाम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","अनंलि व मेगु ४०३ दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","शेलह स्‍विदँ दुबलय् वया एबेर नांयाम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","अनंलि व मेगु ४०३ दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबेर स्‍वीपेदँ दुबलय् वया पेलेग नांयाम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","अनंलि व मेगु ४३० दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","पेलेग स्‍विदँ दुबलय् वया रऊ नांयाम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","अनंलि व मेगु २०९ दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रऊ स्‍विनिदँ दुबलय् वया सरूग नांयाम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","अनंलि व मेगु २०७ दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","सरूग स्‍विदँ दुबलय् वया नाहोर नांयाम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","अनंलि व २०० दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नाहोर निइगुदँ दुबलय् वया तेरह नांयाम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","अनंलि व मेगु ११९ दँ म्‍वात। वया मेमेपिं नं काय्‌पिं व म्‍ह्याय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरह ७० दँ दुबलय् वया अब्राम, नाहोर व हारान नांयापिं काय्‌पिं बुल। ");
INSERT INTO new_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरहया खँ थथे दु – व अब्राम, नाहोर व हारानया बौ खः। हारानया काय् लोत खः। ");
INSERT INTO new_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हारान वया बौ तेरह म्‍वानाच्‍वंबलय् हे थः बूगु थाय् ऊरय् सित। थ्‍व थाय् कल्‍दीतय्‌गु खः। ");
INSERT INTO new_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्रामं साराईलिसे ब्‍याहा यात। नाहोरं हारानया म्‍ह्याय् मिल्‍कालिसे ब्‍याहा यात। हारान यिस्‍काया नं बौ खः। ");
INSERT INTO new_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","साराई थारिम्‍ह मिसा खः। वया मस्‍त मदु। ");
INSERT INTO new_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरह थःकाय् अब्राम, हारानया काय् थः छय् लोत, अब्रामया कलाः थः भौ साराईयात ज्‍वनाः कनानपाखे वनेत कल्‍दीतय्‌गु शहर ऊर त्‍वःतावन। तर इपिं हारान शहरय् थ्‍यनाः अन हे च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरह २०५ दँ दुबलय् अन हे मन्‍त। ");
INSERT INTO new_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","परमप्रभुं अब्रामयात धयादिल, “छ थः बूगु दे, थःथिति व थः बौया छेँ त्‍वःताः जिं क्‍यनेत्‍यनागु देशय् हुँ। ");
INSERT INTO new_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“जिं छंगुपाखें तःधंगु जाति दय्‌के बी, जिं छन्‍त आशिष बी। जिं छन्‍त नांजाःम्‍ह मनू दय्‌के, अले छंगुपाखें मेपिन्‍त आशिष बीके। ");
INSERT INTO new_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","छन्‍त आशिष ब्‍यूपिन्‍त जिं नं आशिष बी, छन्‍त सराः ब्‍यूपिन्‍त जिं नं सराः बी। छपाखें हे संसारय् च्‍वंपिं दक्‍व जातितय्‌सं आशिष काइ।” ");
INSERT INTO new_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","परमप्रभुं हुँ धकाः धयादीगु थासय् अब्राम वन। लोत नं व नाप वन। अब्रामं हारान त्‍वःतूबलय् व ७५ दँ क्‍यनाच्‍वंम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्राम थः कलाः साराई, थः काय्‌चा लोत व हारानय् थःयाके दुगु दक्‍व सम्‍पत्ति, दास-दासीत ज्‍वनाः कनानपाखे वन। ");
INSERT INTO new_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम व देश जुयाः शकेमय् थ्‍यंकः वल। अन इपिं मोरे धाःगु थासय् सिमा क्‍वय् बाय् च्‍वन। अबलय् थ्‍व थाय् कनानीतय्‌गु खः। ");
INSERT INTO new_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","अले परमप्रभुं अब्रामयाथाय् झायाः धयादिल, “जिं थ्‍व देश छिमि सन्‍तानयात बी।” अले अब्रामं वयाथाय् झाःम्‍ह परमप्रभुया लागि अन छगू वेदी दय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","अनंलि व छगू पहाडपाखे वनाः अन पाल ग्‍वयाः च्‍वन। थ्‍व पहाडया पच्‍छिमपाखे बेथेल व पुर्बपाखे ऐ धयागु थाय् लाः। अन वं परमप्रभुया निंतिं छगू वेदी दय्‌काः परमप्रभुयात प्रार्थना यात। ");
INSERT INTO new_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","थुकथं व थाय् थासय् जुयाः नेगेव पाखे स्‍वयाः वनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","अबलय् अन तसकं अनिकाल जूगुलिं अब्राम छुं ईया लागि मिश्र देशय् च्‍वंवन। ");
INSERT INTO new_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","मिश्र देशय् थ्‍यनिथें च्‍वंकाः वं थः कलाः साराईयात धाल, “छ तसकं बांलाः। ");
INSERT INTO new_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","मिश्र देशय् च्‍वंपिन्‍सं छन्‍त खन कि, ‘थ्‍व ला वया कलाः खनि’ धकाः धाइ। अले इमिसं जितः स्‍याइ, छन्‍त धाःसा स्‍याइ मखु। ");
INSERT INTO new_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","उकिं छं छ जिमि केहेँ खः धकाः धा। अले इमिसं छंगु लागि जितः बांलाक व्‍यवहार याइ, जितः नं स्‍याइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","अब्राम मिश्र देशय् थ्‍यंबलय् अन च्‍वंपिन्‍सं वया कलाःयात तसकं बांलाःम्‍ह खन। ");
INSERT INTO new_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","दरबारया मनूतय्‌सं वयात खनाः इमिसं फारोयाथाय् वनाः वयागु तारिफ यात। अले वयात दरबारय् यंकल। ");
INSERT INTO new_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","फारों वयागु लागि अब्रामयात बांलाक व्‍यवहार यात। अब्रामयात सा, फै, गधा, ऊँट व दास-दासीत बिल। ");
INSERT INTO new_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","परमप्रभुं अब्रामया कलाः साराईया कारणं फारो व वया परिवारयात ततःधंगु ल्‍वय् छ्वयाहल। ");
INSERT INTO new_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","अले फारों अब्रामयात सःताः ब्‍वःबिल, “छं जितः छु यानागु? छं व थः कलाः खः धकाः छाय् मधयागु? ");
INSERT INTO new_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","छं छाय् वयात छिमि केहेँ धकाः धयागु? उकिं जिं वयात थः कलाः यायेत थन हयागु खः। थ्‍व छिमि कलाः खः, थ्‍वयात ज्‍वनाः हुँ।” ");
INSERT INTO new_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","अनंलि फारों थः मनूतय्‌त वया बारे उजं बिल। अले इमिसं वयात, वया कलाः व वयाके दुगु फुक्‍कं सम्‍पत्तिनापं अनं छ्वल। ");
INSERT INTO new_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","अब्राम व वया कलाः थःपिन्‍के दुगु फुक्‍क ज्‍वनाः मिश्र देशं नेगेव पाखे वन। लोत नं इपिं नाप वन। ");
INSERT INTO new_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम तसकं तःमिम्‍ह खः। वयाके यक्‍व फै-च्‍वलय् व सा द्वहं, लुँ व वहः दु। ");
INSERT INTO new_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","अब्राम नेगेवया थाय् थासय् जुयाः बेथेल व ऐया दथुइ लाःगु थासय् थ्‍यंकः वल। ");
INSERT INTO new_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","न्‍हापा वं अन वेदी दय्‌का थकूगु खः। अन वं परमप्रभुयात प्रार्थना यात। ");
INSERT INTO new_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","इपिं नाप वंम्‍ह लोतयाके नं यक्‍व फै-च्‍वलय्, सा द्वहं व पाल दु। ");
INSERT INTO new_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","थुकिं यानाः इपिं निम्‍हं नापं च्‍वनेत अन थाय् मगात। इपिं लिसे यक्‍व फै-च्‍वलय् दुगुलिं इमित अन नापं च्‍वनेत मछिन। ");
INSERT INTO new_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","अब्राम व लोतया पशु जवाःतय् दथुइ ल्‍वापु नं जुल। अबलय् अन कनानीत व परिज्‍जीत नं च्‍वनाच्‍वंगु खः। ");
INSERT INTO new_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","उकिं अब्रामं लोतयात धाल, “थुकथं झी व झी जवाःतय् दथुइ ल्‍वापु जुइगु बांलाः मजू। झी ला थःलाःपिं खः। ");
INSERT INTO new_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","छंगु लागि माक्‍व थाय् छंगु न्‍ह्यःने दु। उकिं झी आः बायाः वने। छ खव पाखे वंसा जि जवपाखे वने, छ जवपाखे वंसा जि खव पाखे वने।” ");
INSERT INTO new_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","लोतं प्‍यखें स्‍वल। वं यर्दनया ब्‍यासि सोअर शहर तक हे परमप्रभुया क्‍यब थें व मिश्र देश थें वाउँसे च्‍वंगु खन। थ्‍व परमप्रभुं सदोम व गमोरायात नाश याये न्‍ह्यःया खँ खः। ");
INSERT INTO new_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","उकिं लोतं थःगु लागि यर्दन ब्‍यासि ल्‍यल। अले व पुर्बपाखे स्‍वयाः वन। थुकथं इपिं बाल। ");
INSERT INTO new_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनानय् हे च्‍वन। लोत जक यर्दन ब्‍यासिया थीथी शहरय् च्‍वंवन। व सदोम तक थःगु पाल ग्‍वयाः च्‍वंवन। ");
INSERT INTO new_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोमया मनूत तसकं दुष्‍ट व परमप्रभुया विरोधय् पाप यानाजुइपिं खः। ");
INSERT INTO new_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","अब्राम व लोत बाये धुंकाः परमप्रभुं अब्रामयात धयादिल, “पुर्ब, पच्‍छिम, उत्तर, दच्‍छिन प्‍यखें स्‍व। ");
INSERT INTO new_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","जिं छन्‍त व छिमि सन्‍तानयात छं खँक्‍व जग्‍गा बी। थ्‍व सदां छंगु हे जुइ। ");
INSERT INTO new_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","जिं छिमि सन्‍तानयात पृथ्‍वीया धू थें यक्‍व दय्‌काबी। पृथ्‍वीया धू ल्‍याः खाये फुम्‍हय्‌सिनं जक छिमि सन्‍तान ल्‍याः खाये फइ। ");
INSERT INTO new_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","दँ, देया न्‍यंकभनं हुँ, छाय्‌धाःसा जिं छन्‍त थ्‍व फुक्‍क बीत्‍यनागु दु।” ");
INSERT INTO new_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","अब्रामं थःगु पाल ल्‍ह्ययाः हेब्रोनय् मम्रें पिनाथकूगु सिमा दुथाय् पाखे च्‍वंवन। अन वं परमप्रभुया लागि छगू वेदी दय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","थुबलय् हे शिनारया जुजु अम्रापेल, एल्‍लासारया जुजु अर्योक, एलामया जुजु कदोर्लाओमेर व गोयीमया जुजु तिदालं ");
INSERT INTO new_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","सदोमया जुजु बेरा, गमोराया जुजु बिर्शा, अदमाया जुजु शिनाब, सबोयीमया जुजु शेमेबेर व बेलाया (लिपाया सोअर) जुजुलिसें लडाइँ यात। ");
INSERT INTO new_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","इपिं फुक्‍क सिद्दीम अर्थात मृत सागरया ब्‍यासिइ मुन। ");
INSERT INTO new_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","झिंनिदँ तक जुजु कदोर्लाओमेरं क्‍वत्‍यलातःगु खः, झिंस्‍वदँय् इमिसं विद्रोह यात। ");
INSERT INTO new_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","झिंप्‍यदँय् कदोर्लाओमेर व नाप दुपिं जुजुपिन्‍सं वयाः अस्‍तेरोत कर्णेमया रपाईतय्‌त, हामया जुजीतय्‌त, शावेकिर्यातैमया एमीतय्‌त ");
INSERT INTO new_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","अथवा होरीतय्‌त सेइरया पहाडंनिसें एल-पारानया मरुभूमि तक थःगु अधीनय् काल। ");
INSERT INTO new_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","अनंलि इपिं लिहां वल। अले एन-मिशपातय् (लिपा कादेश) वनाः अमालेकीतय्‌गु फुक्‍क देश व हासेसोन-तामारया फुक्‍क एमोरीतय्‌त नं थःगु अधीनय् काल। ");
INSERT INTO new_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","सदोम, गमोरा, अदमा, सबोयीम व बेलाया (लिपाया सोअर) जुजुपिन्‍सं सिद्दीम ब्‍यासिइ वयाः ");
INSERT INTO new_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","एलामया जुजु कदोर्लाओमेर, गोयीमया जुजु तिदाल, शिनारया जुजु अम्रापेल, एल्‍लासारया जुजु अर्योकया विरोधय् ल्‍वायेत मुन। प्‍यम्‍ह जुजुया विरोधय् न्‍याम्‍ह। ");
INSERT INTO new_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","अन सिद्दीम ब्‍यासिइ थाय् थासय् अलकत्राया गाः दुगुलिं सदोम व गमोराया जुजुपिं बिस्‍युं वंबलय् इमि गुलिं मनूत अलकत्रा गालय् कुतुंवन, ल्‍यंदुपिं जक पहाडपाखे बिस्‍युं वन। ");
INSERT INTO new_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","थुपिं प्‍यम्‍ह जुजुपिन्‍सं सदोम व गमोराया फुक्‍क सम्‍पत्ति व नसाज्‍वलं तकं लाकाः यंकल। ");
INSERT INTO new_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","इमिसं सदोमय् च्‍वनाच्‍वंम्‍ह अब्रामया काय्‌चा लोत व वयागु सम्‍पत्तिनापं यंकल। ");
INSERT INTO new_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","लडाइँनं बिस्‍युं वःम्‍ह छम्‍हय्‌सिनं वयाः हिब्रू अब्रामयात थ्‍व खँ कन। उबलय् व एमोरी मम्रें पिनाथकूगु सिमात दुथाय् च्‍वनाच्‍वंगु खः। उबलय् व मम्रेया दाजु एश्‍कोल व आनेरलिसे मिले जुयाः च्‍वनाच्‍वंगु खः। ");
INSERT INTO new_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","अब्रामं थः काय्‌चा लोतयात ज्‍वना यंकूगु खँ न्‍यनाः थःथाय् हे बूपिं व ल्‍वायेगु सय्‌कातःपिं स्‍वसः व झिंच्‍याम्‍ह दासतय्‌त थःलिसें ब्‍वनाः शत्रुतय्‌त ख्‍याख्‍यां दान तक हे थ्‍यंकः वन। ");
INSERT INTO new_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","अब्रामं थः मनूतय्‌त पुचः पुचः दय्‌काः चान्‍हय् प्‍यखेरं हमला यानाः इमित बुकाछ्वत। अले दमस्‍कसया उत्तर पाखे च्‍वंगु होबा तक्‍क लिनाछ्वत। ");
INSERT INTO new_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","वं थः काय्‌चा लोत व वयागु सम्‍पत्ति लिसें शत्रुतय्‌सं त्‍याकाः यंकूपिं मिसात, मिजंत फुक्‍क लितहल। ");
INSERT INTO new_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","अब्राम कदोर्लाओमेर व व नाप दुपिं जुजुपिन्‍त त्‍याकाः वये धुंकाः सदोमया जुजु वयात नापलायेत शावेया ब्‍यासिइ वल। थ्‍व थाय्‌यात “जुजु बेसी” नं धाः। ");
INSERT INTO new_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","शालेमया जुजु मल्‍कीसेदेक मरि व दाखमद्य ज्‍वनाः वल। व दक्‍वसिबय् तःधंम्‍ह परमेश्‍वरया पुजाहारी खः। ");
INSERT INTO new_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","वं अब्रामयात थुकथं आशिष बिल, “जिं स्‍वर्ग व पृथ्‍वी दय्‌कादीम्‍ह दक्‍वसिबय् तःधंम्‍ह परमेश्‍वरया नामं छन्‍त आशिष बी। ");
INSERT INTO new_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","दक्‍वसिबय् तःधंम्‍ह परमेश्‍वरयात तःधंकी, गुम्‍हय्‌सिनं छिमि शत्रुतय्‌त छंगु ल्‍हातय् लःल्‍हानादिल।” अले अब्रामं थःम्‍हं हःगु फुक्‍क झिब्‍वय् छब्‍व वय्‌कःयात बिल। ");
INSERT INTO new_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","सदोमया जुजुं अब्रामयात धाल, “जितः मनूत जक ब्‍यु, धनसम्‍पत्ति छं थःम्‍हं हे ति।” ");
INSERT INTO new_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","अब्रामं सदोमया जुजुयात लिसः बिल, “स्‍वर्ग व पृथ्‍वी दय्‌कूम्‍ह दक्‍वसिबय् तःधंम्‍ह परमेश्‍वरयात जिं बचं बियागु दु, ");
INSERT INTO new_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","जिं छिगु सुका बापु तकं काये मखु। मखुसा ला छिं, ‘अब्रामयात जिं तःमि यानाबिया’ धकाः धाइ। ");
INSERT INTO new_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","जिमि मनूतय्‌सं नःगु बाहेक जितः छुं नं म्‍वाः। बरु जिनापं वःपिं आनेर, एश्‍कोल व मम्रेयागु भाग जक इमित बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","थथे जूगुयां छुं ई लिपा परमप्रभुं अब्रामयात दर्शन बियाः थथे धयादिल, “ग्‍याये मते अब्राम। जिं छन्‍त बचय् याये। जिं छन्‍त तःधंगु सिरपाः बी।” ");
INSERT INTO new_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","अब्रामं लिसः बिल, “हे परमप्रभु परमेश्‍वर, मचा हे मदय्‌क छिं जितः छु तःधंगु सिरपाः बियादी? जि सी धुंकाः जिगु फुक्‍क सम्‍पत्ति दमस्‍कसयाम्‍ह एलीएजरं काइ। ");
INSERT INTO new_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","छिं जितः छम्‍ह हे मचा बियामदी। अले जिम्‍ह थ्‍व दासं जिगु फुक्‍क सम्‍पत्ति काइ।” ");
INSERT INTO new_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","अले परमप्रभुं वयात धयादिल, “एलीएजर छंगु सम्‍पत्ति काइम्‍ह मनू जुइ मखु। छं थः हे काय् दइ। अले छंगु फुक्‍क हक वं हे काइ।” ");
INSERT INTO new_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","परमप्रभुं अब्रामयात पिने हयाः धयादिल, “आकाशय् स्‍व, अले नगुत ल्‍याः खाना स्‍व, छं ल्‍याः खाये फु ला?” वय्‌कलं हानं धयादिल, “छं सन्‍तान नं उलि हे दइ।” ");
INSERT INTO new_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","अले अब्रामं परमप्रभुयात विश्‍वास यात। परमप्रभुं वयात धर्मी मनूया ल्‍याखय् तयादिल। ");
INSERT INTO new_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","वय्‌कलं वयात धयादिल, “छन्‍त थ्‍व थाय् बीत कल्‍दीतय्‌गु ऊरं थन हयाम्‍ह परमप्रभु जि हे खः।” ");
INSERT INTO new_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","अब्रामं धाल, “परमप्रभु परमेश्‍वर, थ्‍व थाय् जिगु जुइ धकाः जिं गय् यानाः सीकेगु?” ");
INSERT INTO new_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","परमप्रभुं धयादिल, “जितः स्‍वदँ दुम्‍ह सा छम्‍ह, स्‍वदँ दुम्‍ह च्‍वलय् छम्‍ह, स्‍वदँ दुम्‍ह छम्‍ह फै, छम्‍ह सुकुभत्तु व छम्‍ह मचाम्‍ह बखुं हति।” ");
INSERT INTO new_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अब्रामं फुक्‍कं हल। अले वं इमित बाम्‍हय् लाक्‍क पालाः निकू निकू यानाः जवय् खवय् लाकाः तयाबिल। वं सुकुभत्तु व बखुंयात धाःसा निकू मयाः। ");
INSERT INTO new_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","गिद्धत स्‍यानातःपिं पशुपंछिया ला नयेत कुहां वःबलय् अब्रामं इमित ख्‍यानाछ्वत। ");
INSERT INTO new_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","निभाः बीथे च्‍वंकाः अब्रामयात छुं हे मचाय्‌क न्‍ह्यः वय्‌काबिल। अले वयात तसकं ख्‍वातुगु व ग्‍यानापुगु खिउँनं त्‍वपुल। ");
INSERT INTO new_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","अले परमप्रभुं अब्रामयात धयादिल, “थ्‍व खँ थुइकाति, छिमि सन्‍तान कर्पिनिगु देशय् परदेशी जुयाः च्‍वंवने माली, अले इपिं अन प्‍यसः दँ तक दास दासी जुयाः क्‍वत्‍यय्‌काः च्‍वनेमाली। ");
INSERT INTO new_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","जिं इमित दास दासी याःपिं जातियात सजाँय बी। अले इपिं अनं यक्‍व धनसम्‍पत्ति ज्‍वनाः पिहां वइ। ");
INSERT INTO new_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","छ जक छिमि तापाःबाज्‍यापिन्‍थाय् याउँक च्‍वंवनी। गाक्‍क बुरा जुइ धुंकाः छन्‍त थुनेयनी। ");
INSERT INTO new_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","प्‍यंगू पुस्‍ता लिपा छिमि सन्‍तान थन लिहां वइ। उबलय्‌तक एमोरीतय्‌गु पाप जाइ मखुनि।” ");
INSERT INTO new_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","निभाः बिनाः खिउँसे च्‍वन। अबलय् अब्रामं निब्‍व थलाः तयातःगु लाया दथुं कुँ पिहां वयाच्‍वंगु छगः मकः व च्‍यानाच्‍वंगु मिप्‍वाः छप्‍वाः वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","अबलय् हे परमप्रभुं अब्रामलिसे थुकथं बाचा चिनादिल, “जिं छिमि सन्‍तानयात मिश्र देशयागु खुसिंनिसें तःधंगु खुसि यूफ्रेटिसतकयागु थ्‍व देशत बियागु दु – ");
INSERT INTO new_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","केनी, कनज्‍जी, कदमोनी, ");
INSERT INTO new_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परिज्‍जी, रपाई, ");
INSERT INTO new_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरी, कनानी, गिर्गाशी व यबूसीतय्‌गु देश।” ");
INSERT INTO new_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्रामया कलाः साराईया पाखें मस्‍त मदु। वया छम्‍ह हागार धाःम्‍ह मिश्र देशयाम्‍ह दासी दु। ");
INSERT INTO new_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","साराईनं अब्रामयात धाल, “परमप्रभुं जितः छम्‍ह हे मचा बियामदी। उकिं जिम्‍ह दासीयाथाय् वनाः व नाप द्यँ। वयापाखें सां जितः सन्‍तान दइ ला।” अब्रामं साराईनं धाःगु खँ न्‍यन। ");
INSERT INTO new_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","साराईनं मिश्र देशयाम्‍ह थः दासी हागारयात हयाः थः भाःत अब्रामयात कलाः यायेत लःल्‍हाना बिल। अब्राम कनानय् वयाच्‍वंगु झिदँ लिपा थ्‍व जूगु खः। ");
INSERT INTO new_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","अब्राम हागारयाथाय् वन। अले हागारया प्‍वाथय् दत। हागारं थः प्‍वाथय् दुगु सीवं थः मालिकनी साराईयात क्‍वह्यंकाहल। ");
INSERT INTO new_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","अले साराईनं अब्रामयात धाल, “जितः जूगु दुःख फुक्‍क छिं यानाः जूगु खः। जिं हे छितः थः दासी लःल्‍हाना बियागु खः। आः वं थः प्‍वाथय् दत धयागु सिसांनिसें जितः क्‍वह्यंकाहल। आः परमप्रभुं हे छिगु व जिगु न्‍याय यानादी।” ");
INSERT INTO new_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","अब्रामं धाल, “छंम्‍ह दासी छंगु हे ल्‍हातिइ दु। छं छु याये मास्‍तेवः वयात अथे हे या।” अले साराईनं हागारयात दुःख बीगु यात। थुकिं यानाः हागार अनं बिस्‍युं वन। ");
INSERT INTO new_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","परमप्रभुया दूतं वयात मरुभूमिइ शूरपाखे वनेगु लँय् लाःगु लःया मुहान दुथाय् नापलात। ");
INSERT INTO new_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","अले वयात न्‍यनादिल, “साराईया दासी हागार, छ गनं वयागु, अले गन वनेत्‍यनागु?” वं लिसः बिल, “जि थः मालिकनी साराईपाखें बिस्‍युं वनाच्‍वनागु खः।” ");
INSERT INTO new_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","अले परमप्रभुया दूतं वयात धाल, “छ थः मालिकनीयाथाय् हे लिहां हुँ, अले वयागु हे अधीनय् च्‍वँ।” ");
INSERT INTO new_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","परमप्रभुया दूतं हाकनं धाल, “जिं छिमि सन्‍तानयात ल्‍याः खाये मफयेक यक्‍व दय्‌काबी।” ");
INSERT INTO new_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","वं धाल, “छं आः प्‍वाथय् दु। छं छम्‍ह काय् बुइकी। अले वयागु नां इश्‍माएल तइ। छाय्‌धाःसा परमप्रभुं छ ख्‍वःगु न्‍यनादीगु दु। ");
INSERT INTO new_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","मनूतय्‌गु दथुइ व जंगली गधा थें जुइ। व सकसिगुं विरोधय् दनी। अले सकलें वयागु विरोधय् दनी। व वया थःथितिपिं फुक्‍कलिसे अलग जुइ।” ");
INSERT INTO new_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","हागारं धाल, “जिं धात्‍थें हे परमप्रभुयात खना। अले वय्‌कःयात खनेधुंकाः नं जि म्‍वाना हे च्‍वना।” अले वं परमप्रभुयात थथे धकाः नां तल, “जितः स्‍वइम्‍ह परमप्रभु।” ");
INSERT INTO new_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","उकिं मनूतय्‌सं कादेश व बेरेदया दथुइ लाःगु बुंगाःचायात बेअर-लहै-रोइ धकाः नां तल। ");
INSERT INTO new_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","हागारं काय् बुइकल। अब्रामं हागारया पाखें दुम्‍ह थः काय्‌या नां इश्‍माएल तल। ");
INSERT INTO new_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","उबलय् अब्राम चयखुदँ (८६) दुम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","अब्राम गुइगुदँ दुबलय् परमप्रभु अब्रामयाथाय् खनेदय्‌कः झाल। अले वयात धयादिल, “जि दक्‍व शक्ति दुम्‍ह परमेश्‍वर खः। जिं धाःथें या, अले दोष मदय्‌क जु। ");
INSERT INTO new_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","जिं छलिसे छगू बाचा ची। जिं छिमि सन्‍तानयात ल्‍याः खाये मफयेक यक्‍व दय्‌काबी।” ");
INSERT INTO new_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","अब्राम बँय् भ्‍वपुल। परमेश्‍वरं धयादिल, ");
INSERT INTO new_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“जिं छलिसे थ्‍व बाचा चिनागु जुल, छ यक्‍व जातितय् अबु जुइ। ");
INSERT INTO new_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","छंगु नां आः अब्राम मखु, अब्राहाम जुइ। छाय्‌धाःसा जिं छन्‍त यक्‍व जातितय् अबु यानाबियागु दु। ");
INSERT INTO new_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","जिं छन्‍त यक्‍व सन्‍तान बी। लिपा इपिं ततःधंगु जाति जुइ। गुलिं ला जुजु नं जुइ। ");
INSERT INTO new_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","जिं छ व छिमि सन्‍तानलिसे चिनागु बाचा सदांया लागि म्‍वाकातये, छाय्‌धाःसा जि छं व इमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","जिं छन्‍त व इमित छ आः च्‍वंवयाच्‍वंगु कनानया फुक्‍क बँ सदां सदांया लागि बी। अले जि इमि परमेश्‍वर जुइ।” ");
INSERT INTO new_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","परमेश्‍वरं अब्राहामयात हानं धयादिल, “छं व छिमि सन्‍तानं जिगु बाचायात सदां मानय् यानाच्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","छं व छिमि सन्‍तानं मानय् यायेमाःगु जिगु बाचा छु धाल धाःसा, छिमि काय्‌मचा धाक्‍वसिनं म्‍हय् चिं तयेमाः। ");
INSERT INTO new_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","आवंनिसें छिमि मिजंमस्‍त फुक्‍कसिनं म्‍हय् चिं तयेमाः। थ्‍व हे छंगु व जिगु दथुइ चिनागु बाचाया चिं जुइ। ");
INSERT INTO new_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","आवंनिसें छिमि मिजंमस्‍तय्‌सं च्‍यान्‍हु दुखुन्‍हु म्‍हय् चिं तयेमाः। थथे छिमिगु छेँय् बूपिं थः मस्‍तय्‌त जक मखु, पिनें न्‍यानाहःपिन्‍त नं यायेमाः। ");
INSERT INTO new_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","फुक्‍कसिनं म्‍हय् चिं तयेमाः। थुकथं जिगु बाचा छिमिगु म्‍हय् सदांया लागि दयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","सुं नं मिजंनं म्‍हय् चिं मतल धाःसा व जिम्‍ह मनू जुइ मखु, छाय्‌धाःसा वं जिलिसें बाचा च्‍यूगु दइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","परमेश्‍वरं अब्राहामयात हानं धयादिल, “आवंनिसें छं छिमि कलाःयात साराई धकाः धाये मते, आवंलि वयागु नां सारा जुल। ");
INSERT INTO new_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","जिं वयात आशिष बी। जिं वयापाखें छन्‍त काय् छम्‍ह बी। जिं वयात आशिष बी। अले व यक्‍वः जातितय् मां जुइ। वया गुलिखे सन्‍तान जुजु जुइ।” ");
INSERT INTO new_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","अब्राहाम बँय् भ्‍वपुल। अले मनं मनं थथे धयाः न्‍हिल, “सच्‍छिदँ (१००) दुम्‍ह मनूपाखें नं सन्‍तान दइ ला? गुइदँ दये धुंकाः नं सारां मचा बुइकी ला?” ");
INSERT INTO new_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","वं परमेश्‍वरयात धाल, “इश्‍माएलयात हे छिगु आशिष बियादीसां ज्‍यूनि।” ");
INSERT INTO new_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","परमेश्‍वरं धयादिल, “मखु, छिमि कलाः सारां काय् बुइकी। अले वयागु नां इसहाक ति। जिं जिगु बाचा व अले वया सन्‍तानलिसे चिने। थ्‍व बाचा सदांया लागि जुइ। ");
INSERT INTO new_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","छं इश्‍माएलया खँ न्‍ह्यथंगु जिं न्‍यनेधुन। उकिं जिं वयात नं आशिष बी। अले वयात यक्‍व मस्‍त व सन्‍तान बी। व झिंनिम्‍ह शासकतय् अबु जुइ। जिं वया सन्‍तानयागु छगू तःधंगु जाति दय्‌काबी। ");
INSERT INTO new_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","जिगु बाचा धाःसा इसहाकलिसे जुइ। वयात सारां दच्‍छि लिपा थ्‍व हे इलय् बुइकी।” ");
INSERT INTO new_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","वलिसे खँ ल्‍हाये सिधय्‌काः परमेश्‍वर अब्राहामयात त्‍वःताः झाल। ");
INSERT INTO new_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","उखुन्‍हु हे अब्राहामं थःकाय् इश्‍माएल, थःगु छेँय् बूपिं व न्‍यानाहःपिं फुक्‍क दासत व थःगु छेँय् च्‍वंपिं फुक्‍क मिजंपिन्‍त यंकाः परमेश्‍वरं धयादी थें म्‍हय् चिं तय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","म्‍हय् चिं तःबलय् अब्राहाम गुइगुदँ दुम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","अले वया काय् इश्‍माएल झिंस्‍वदँ दुम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","अब्राहाम व वया काय् इश्‍माएल निम्‍हसिनं छन्‍हुं हे म्‍हय् चिं तल। ");
INSERT INTO new_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","अले वया छेँय् च्‍वंपिं फुक्‍क मिजंत, वयागु छेँय् बूपिं दास व न्‍यानाहःपिं दासत फुक्‍कसिनं इपिं नापं म्‍हय् चिं तल। ");
INSERT INTO new_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","छन्‍हु न्‍हिनय् तांन्‍वःबलय् अब्राहाम मम्रेया सिमा क्‍वय् च्‍वंगु थःगु पालया लुखाय् च्‍वना च्‍वंबलय् परमप्रभु वयाथाय् खनेदय्‌कः झाल। ");
INSERT INTO new_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","अब्राहामं थस्‍वःबलय् स्‍वम्‍ह मनू थःगु न्‍ह्यःने दनाच्‍वंगु खन। वं काचा काचां दनाः इमित नापलाः वन। अले बँय् थ्‍यंक क्‍वछुनाः भ्‍वपुल। ");
INSERT INTO new_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","अले वं धाल, “हे जिमि प्रभु, कृपा तयाः छिकपिनि थ्‍व दासयाथाय् दुमस्‍वसे झाये मते। ");
INSERT INTO new_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","जिं लः हये, छिकपिनि तुति सिलादिसँ। अले सिमा क्‍वय् झासु लनादिसँ। ");
INSERT INTO new_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","छिकपिन्‍सं जिथाय् झायाः जितः तःधंकादिल। जिं मरि हये। नयाः त्‍यानु लंकादिसँ। अले बुलुहुं झासँ।” इमिसं धाल, “ज्‍यू, छं स्‍वयाः या।” ");
INSERT INTO new_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","अब्राहामं पालय् दुने ब्‍वाँय् वनाः सारायात धाल, “याकनं न्‍याफा भिंगु छ्वचुं न्‍हायाः मरि छु।” ");
INSERT INTO new_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","अले वं द्वहंतय्‌गु पुचलय् दुहां वनाः छम्‍ह द्वहंचा ल्‍ययाः च्‍यःयात बिल। वं याकनं वयागु ला दय्‌काः हल। ");
INSERT INTO new_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","अनंलि अब्राहामं ला नापं धौ व दुरु हयाः इमिगु न्‍ह्यःने न्‍ह्यच्‍याकल। इमि नयाच्‍वंबलय् व इमिगु नापं सिमा क्‍वय् दनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","इमिसं न्‍यन, “छिमि कलाः सारा ग्‍व?” वं लिसः बिल, “दुने पालय्।” ");
INSERT INTO new_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","अले परमप्रभुं धयादिल, “जि दच्‍छि लिपा थ्‍व हे इलय् थन लिहां वये। उबलय् छिमि कलाः साराया मचा दये धुंकी।” सारां वय्‌कःया लिउने पालया लुखाय् च्‍वनाः न्‍यनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहाम व सारा तसकं बुराबुरी जुइ धुंकल। साराया मचाबुइकेगु ई नं पुलेधुंकल। ");
INSERT INTO new_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","उकिं सारां मनमनं न्‍हिलाः मतिइ तल, “जि नं बुरी जुइ धुंकल, अले जिमि भाःत नं बुरा जुइ धुंकल। जिं आः थ्‍व सुख कायेफइ तिनि ला?” ");
INSERT INTO new_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","अले परमप्रभुं अब्राहामयात धयादिल, “सारां छाय् न्‍हिलाः ‘जि थथे बुरी जुइ धुंकाः नं मचा दइतिनि ला’ धकाः धाःगु? ");
INSERT INTO new_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","परमप्रभुया लागि थाकुगु धयागु छु दु? जि दच्‍छि लिपा जिं धयागु इलय् छन्‍थाय् लिहां वये। उबलय् साराया काय् दये धुंकी।” ");
INSERT INTO new_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","सारा ग्‍यात। अले वं धाल, “मखु, जि मन्‍हिला।” अले वय्‌कलं धयादिल, “मखु, छ न्‍हिउगु हे खः।” ");
INSERT INTO new_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","पाहांत वनेत दन। अले सदोमपाखे स्‍वयाः वन। अब्राहाम नं इमित लँय् तक तःवन। ");
INSERT INTO new_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","अले परमप्रभुं मतिइ तयादिल, “जिं यायेत्‍यनागु ज्‍या अब्राहामयात मसीक याये ला? ");
INSERT INTO new_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहाम छगू तःधंगु व बल्‍लाःगु जाति जुइ। अले पृथ्‍वीया फुक्‍क जातिं वयापाखें हे आशिष काइ। ");
INSERT INTO new_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","जिं वयात ल्‍ययागुलिं वं थः मस्‍तय्‌त व सन्‍तानयात खःगु व भिंगु ज्‍या यानाः परमप्रभुया लँय् जुइत उजं बिइ। थुकिं हे परमप्रभुं अब्राहामलिसे चिनादीगु बाचा पूवंके फइ।” ");
INSERT INTO new_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","अले परमप्रभुं धयादिल, “सदोम व गमोराया विरोधय् यक्‍व सः थ्‍वयेधुंकल। इमिगु पाप तसकं तःधनेधुंकल। ");
INSERT INTO new_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","उकिं इमित पाः याःथें इमिसं यानाच्‍वंगु खः कि मखु स्‍वयेत जि कुहां वने।” ");
INSERT INTO new_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","निम्‍ह मनू सदोमपाखे स्‍वयाः वन, अब्राहाम धाःसा परमप्रभुया न्‍ह्यःने दनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","अले अब्राहामं परमप्रभुया लिक्‍क वनाः धाल, “छिं मभिंपिं मनूतय्‌त नाश यायेबलय् भिंपिं मनूतय्‌त नं नाश यानादी ला? ");
INSERT INTO new_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","गनं नेय्‌म्‍ह भिंपिं मनूत दुसा व नेय्‌म्‍ह भिंपिं मनूतय्‌गु बिचाः मयासें व थाय्‌यात नं नाश यानादी ला? ");
INSERT INTO new_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","छिं मभिंपिं मनूतलिसें भिंपिं मनूतय्‌त नं स्‍यानादी मखु। थथे जुल धाःसा ला भिंपिन्‍सं नं मभिंपिन्‍सं थें हे सजाँय फये मालिगु जुल। संसारया न्‍याय याइम्‍हय्‌सिनं खःकथं न्‍याय यानामदी ला?” ");
INSERT INTO new_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","परमप्रभुं धयादिल, “सदोम शहरय् नेय्‌म्‍ह जक भिंपिं मनूत दुसां जिं इमिगु लागि फुक्‍कसित त्‍वःताबी।” ");
INSERT INTO new_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","अब्राहामं हानं धाल, “जि ला थ्‍व पृथ्‍वीया धू व नौ जक जूसां जिं प्रभुलिसे थुकथं खँ ल्‍हायेफुगु दु। ");
INSERT INTO new_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","छुं जुयाः सदोमय् पिइन्‍याम्‍ह जक भिंपिं मनूत दुसा छिं शहर छगुलिं नाश यानादी ला?” परमप्रभुं धयादिल, “पिइन्‍याम्‍ह जक भिंपिं मनूत दत धाःसां जिं शहरयात नाश याये मखु।” ");
INSERT INTO new_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","अब्राहामं धाल, “पिइम्‍ह जक भिंपिं मनूत दत धाःसा लय्?” परमप्रभुं धयादिल, “पिइम्‍हया लागि जक जूसां जिं शहरयात नाश याये मखु।” ");
INSERT INTO new_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","अब्राहामं धाल, “जिं हाकनं न्‍ह्यसः यात धकाः तंचायादी मते प्रभु, व शहरय् स्‍विम्‍ह जक भिंपिं मनूत दत धाःसा छिं छु यानादी?” वय्‌कलं धयादिल, “स्‍विम्‍ह जक दत धाःसां जिं नाश याये मखु।” ");
INSERT INTO new_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","अब्राहामं हानं धाल, “जिं प्रभुयाके हाकनं न्‍यनेगु आँट याये फइ ला? निइम्‍ह जक भिंपिं मनूत दत धाःसा छिं छु यानादी?” परमप्रभुं धयादिल, “निइम्‍ह जक दत धाःसां जिं शहरयात नाश याये मखु।” ");
INSERT INTO new_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","दक्‍वसिबय् लिपा अब्राहामं हाकनं धाल, “जिं हाकनं छकः न्‍यने प्रभु, तंम्‍वयादी मते। अन झिम्‍ह जक भिंपिं मनूत दत धाःसा लय्?” वय्‌कलं धयादिल, “झिम्‍ह जक भिंपिं मनू दत धाःसां जिं शहरयात नाश याये मखु।” ");
INSERT INTO new_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","अब्राहामलिसे खँ ल्‍हाये धुंकाः परमप्रभु अनं झाल। अले अब्राहाम नं थःगु थासय् लिहां वन। ");
INSERT INTO new_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","उखुन्‍हु हे बहनिइ लोत सदोम शहरया ध्‍वाखाय् फ्‍यतुनाच्‍वंबलय् उपिं हे निम्‍ह स्‍वर्गदूतत सदोमय् वल। इमित खनाः लोतं दना वनाः बँय् थ्‍यंक क्‍वछुनाः धाल – ");
INSERT INTO new_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“दया यानाः छिकपिनि दासया छेँय् झासँ। अन हे तुति सिलादिसँ। अले चा च्‍वनादिसँ। अले कन्‍हय् सुथय् दनाः झासँ।” इमिसं वयात धाल, “मखु, थौं चच्‍छि जिपिं सतलय् हे च्‍वने।” ");
INSERT INTO new_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","लोतं इमिसं ज्‍यू मधातले कर यानां च्‍वन। अले इपिं व नापं छेँय् वन। वं मरि व भ्‍वय् ज्‍वरय् यात। अले इमिसं नल। ");
INSERT INTO new_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","इपिं द्यों वने न्‍ह्यः सदोमया फुक्‍क मनूत, ल्‍याय्‌म्‍ह व बुरा, फुक्‍क मिजंत वयाः लोतया छेँ घेरय् यात। ");
INSERT INTO new_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","अले लोतया नां कयाः ततःसलं हाल, “बहनिइ छन्‍थाय् वःपिं मनूत ग्‍व? इमित पिने हजि। जिमित इपिं नाप द्यनेब्‍यु।” ");
INSERT INTO new_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","लोत पिने वन, अले खापा तित। ");
INSERT INTO new_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","अले वं धाल, “पासापिं, थज्‍याःगु मभिंगु ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","जि ब्‍याहा मजूनिपिं निम्‍ह म्‍ह्याय्‌पिं दु। जिं इमित पिने हयाबी, अले छिमि यत्‍थे या। थुपिं मनूतय्‌त छता छुं याये मते। इपिं जिगु छेँय् वःपिं पाहांत खः।” ");
INSERT INTO new_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","इमिसं धाल, “जिमिगु लँ त्‍वःति। पिनें वःम्‍ह मनू जुयाः नं जिमित उजं बीम्‍ह का थ्‍व! आः जिमिसं इमित स्‍वयाः छन्‍त बांमलाःगु ज्‍या यानाबी।” थथे धयाः हुलं लोतयात घ्‍वानाः खापा तछ्याः वन। ");
INSERT INTO new_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","दुने च्‍वंपिं निम्‍ह मनूतय्‌सं ल्‍हाः पित हयाः लोतयात दुने सालाः काल। अले खापा तिनाबिल। ");
INSERT INTO new_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","इमिसं लुखा पिने च्‍वंपिं ल्‍याय्‌म्‍ह, बुरा, फुक्‍कसित कां यानाबिल। थुकिं यानाः इमिसं लुखा लुइके मफुत। ");
INSERT INTO new_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","उपिं निम्‍ह मनूतय्‌सं लोतयात धाल, “थन छिमि सुं नं थः मनू काय्‌म्‍ह्याय्, जिलाजं व मेपिं दुसा इमित ब्‍वनाः थ्‍व शहरं बिस्‍युं हुँ। ");
INSERT INTO new_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","छाय्‌धाःसा जिमिसं थ्‍व शहरयात नाश यायेत्‍यनागु दु। थनच्‍वंपिं मनूतय्‌गु बारे परमप्रभुं यक्‍व हे मभिंगु खँ न्‍यने धुंकल। उकिं वय्‌कलं जिमित थ्‍व शहरयात नाश यायेत छ्वयाहयादीगु खः।” ");
INSERT INTO new_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","अले लोतं पिने वनाः थः म्‍ह्याय्‌पिंलिसे ब्‍याहा याइपिं मनूतय्‌त धाल, “याकनं थ्‍व थाय् त्‍वःताः पिहां हुँ। परमप्रभुं थ्‍व शहरयात नाश यानादीत्‍यंगु दु।” वया जिलाजं जुइपिन्‍सं धाःसा वं ख्‍याः याःगु जुइ धकाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","कन्‍हय् खुन्‍हु सुथ न्‍हापां निम्‍ह दूतं वयाः लोतयात थथे धयाः हथाय् चाय्‌कल, “थः कलाः व निम्‍ह म्‍ह्याय्‌पिं ज्‍वनाः याकनं पिहां हुँ। मखुसा परमप्रभुं थ्‍व शहर नाश यानादीबलय् छिपिं नं सी।” ");
INSERT INTO new_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","लोत धाःसा अथें च्‍वनाच्‍वन। उकिं निम्‍ह मनुखं लोत, वया कलाः व निम्‍ह म्‍ह्याय्‌पिनिगु ल्‍हाः ज्‍वनाः शहर पिने ब्‍वनाहल। छाय्‌धाःसा परमप्रभुं इमित दया यानादीगु दु। ");
INSERT INTO new_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","शहरं पिने थ्‍यंकाः दूतं धाल, “थःगु ज्‍यान बचय् यायेत थनं बिस्‍युं हुँ, लिफः स्‍वये मते, थन गनं नं दी मते। पहाडपाखे बिस्‍युं हुँ। अले छिपिं बचय् जुइ।” ");
INSERT INTO new_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","लोतं धाल, “अथे धयादी मते, प्रभु। ");
INSERT INTO new_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","छिकपिन्‍सं जिगु लागि तःधंगु ज्‍या यानादिल। जितः बचय् यानादिल। जि पहाडय् थ्‍यंक बिस्‍युं वने मफु। अन थ्‍यने न्‍ह्यः थ्‍व शहर नाश जुइ लाइ। अले जिपिं नं सी। ");
INSERT INTO new_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","थनं नापसं छगू शहर दु। व शहर चिधं। जि व जिगु परिवार अन बचय् जुइ फइ। जितः अन हे छ्वयादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","इमिसं धाल, “ज्‍यू हुँ। जिं व शहरयात नाश याये मखु। ");
INSERT INTO new_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","याकनं हुँ। छिपिं अन मथ्‍यंतले जिमिसं छुं याये मखु।” (लिपा थ्‍व शहरयागु नां सोअर च्‍वन।) ");
INSERT INTO new_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लोत सोअरय् थ्‍यंबलय् निभाः त्‍वयेधुंकल। ");
INSERT INTO new_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","अले परमप्रभुं सदोम व गमोरा शहरय् मि व गन्‍धकयागु वा गाय्‌कादिल। ");
INSERT INTO new_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","वय्‌कलं उकिया जःखः च्‍वंगु गांतय्‌त व अन सःगु फुक्‍कं नाश यानादिल। ");
INSERT INTO new_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","लँय् वँवं लोतया कलातं लिफः स्‍वःगुलिं व चियागु थां जुल। ");
INSERT INTO new_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","कन्‍हय् खुन्‍हु सुथ न्‍हापां दनाः अब्राहाम थः परमप्रभुया न्‍ह्यःने दनाः खँ ल्‍हाथाय् वन। ");
INSERT INTO new_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","वं सदोम व गमोराया फुक्‍क थासय् स्‍वल। अले वं अगलं कुँत्‍याः पिहां वयाच्‍वं थें व थासं कुँ पिहां वयाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","थुकथं परमेश्‍वरं लोत च्‍वनाच्‍वंगु ब्‍यासीइ च्‍वंगु शहरयात नाश यानादीबलय् अब्राहामयात लुमंकादिल। अले लोतयात अनं बचय् यानाः हयादिल। ");
INSERT INTO new_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","सोअरय् च्‍वने ग्‍याःगुलिं लोत थः निम्‍हं म्‍ह्याय्‌पिं ब्‍वनाः पहाडय् वनाः छगू गुफाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","छन्‍हु तःधीम्‍ह म्‍ह्याय्‌म्‍हं थः केहेंयात धाल, “झी बाः बुरा जुइ धुंकल। झीत ब्‍याहा याइपिं थ्‍व संसारय् सुं हे मिजंत मदु। ");
INSERT INTO new_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","झी बाःयात दाखमद्य त्‍वंकाः वय्‌कः नापं द्यने नु। अले थः हे बौया पाखें मचा दय्‌के।” ");
INSERT INTO new_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","उखुन्‍हु चान्‍हय् इमिसं थः बौयात दाखमद्य त्‍वंकल। अले तःधीम्‍ह म्‍ह्याय् व नापं द्यन। दाखमद्यं तसकं काःगुलिं लोतं व द्योंवःगु व दनावंगु छुं हे मचाः। ");
INSERT INTO new_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","कन्‍हय् खुन्‍हु तताम्‍हय्‌सिनं केहेंम्‍हय्‌सित धाल, “म्‍हिगः बहनी जि बाःलिसे द्यना। थौं हाकनं दाखमद्य त्‍वंके नु। अले छ वय्‌कः नापं द्यँ। अले झी निम्‍हस्‍यां बाःपाखें मचा दइ।” ");
INSERT INTO new_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","उखुन्‍हु चान्‍हय् नं इमिसं बौम्‍हय्‌सित दाखमद्य त्‍वंकल। अले चिधीम्‍ह म्‍ह्याय् वनाः बौम्‍हलिसे द्यन। दाखमद्य यक्‍व त्‍वंगुलिं लोतं व द्योंवःगु व दनावंगु छुं हे मचाः। ");
INSERT INTO new_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","थुकथं लोतया म्‍ह्याय्‌पिं निम्‍हस्‍यां थः हे बौया पाखें प्‍वाथय् दत। ");
INSERT INTO new_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","तःधीम्‍ह म्‍ह्याय्‌या काय् बुल। वं वयागु नां मोआब तल। व थौंकन्‍हय्‌यापिं मोआबीतय् पुर्खा खः। ");
INSERT INTO new_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","चिधीम्‍ह म्‍ह्याय्‌या नं काय् बुल। वं वयागु नां बेन-अमी तल। व थौंकन्‍हय्‌यापिं अम्‍मोनीतय् पुर्खा खः। ");
INSERT INTO new_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","अब्राहाम मम्रें नेगेव पाखे वनाः कादेश व शूरया दथुइ च्‍वन। अनंलि व गरारय् वनाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","अन वं सकसितं थः कलाः सारायात थः केहेँ धकाः धाल। उकिं गरारया जुजु अबीमेलेकं सारायात थःथाय् यंकल। ");
INSERT INTO new_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","छन्‍हु चान्‍हय् म्‍हगसय् वयाः परमेश्‍वरं अबीमेलेकयात धयादिल, “छ आः याकनं सी, छाय्‌धाःसा छं हःम्‍ह मिसा ब्‍याहा जुइ धुंकूम्‍ह खः।” ");
INSERT INTO new_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","अबीमेलेकं सारायात थी तक नं मथ्‍यूनि। वं परमेश्‍वरयात धाल, “प्रभु! छिं निर्दोषपिं जातियात नं नाश यानादी ला? जिं छुं नं मस्‍यू। ");
INSERT INTO new_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","अब्राहामं थःम्‍हं हे वयात ‘जिमि केहेँ’ धकाः धाल। अले वं नं ‘जिमि दाजु’ धकाः धाल। जिगु मतिइ मभिंगु छुं हे मदु, अले छुं द्वंकागु मदु।” ");
INSERT INTO new_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","परमेश्‍वरं वयात म्‍हगसय् धयादिल, “छं मभिंगु नुगलं थथे याःगु मखु धकाः जिं स्‍यू। उकिं जिं छन्‍त जिगु विरोधय् पाप यायेगुपाखें बचय् यानातयागु खः। उकिं हे जिं छन्‍त वयात थीके मबियागु खः। ");
INSERT INTO new_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","आः छं व मिसायात वया भाःतयाथाय् लित यंकि। वया भाःत अगमवक्ता खः। वं छंगु लागि प्रार्थना यानाबी। अले छ सी मखु। छं वयात लित मयंकल धाःसा छ व छिमि मनूत फुक्‍कं सी।” ");
INSERT INTO new_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","कन्‍हय् खुन्‍हु सुथ न्‍हापां अबीमेलेकं थः भारदारत फुक्‍कसित सःताः जूगु फुक्‍क खँ कन। थ्‍व न्‍यनाः इपिं फुक्‍कं ग्‍यात। ");
INSERT INTO new_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","अले अबीमेलेकं अब्राहामयात सःताः न्‍यन, “छं जिमित छु यानागु? जिं छंगु छु स्‍यंकागु दु धकाः जितः व जिगु देशयात थपाय्‌धंगु द्वपं बीत्‍यनागु? छं जितः याये मज्‍यूगु ज्‍या यात। ");
INSERT INTO new_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","छं छाय् थथे यानागु?” ");
INSERT INTO new_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहामं धाल, “जिगु मतिइ थन च्‍वंपिन्‍सं परमेश्‍वरयात मानय् याइ मखु। अले जिमि कलाःयात यंकेत जितः स्‍याइ धकाः जिं थथे यानागु खः। ");
INSERT INTO new_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","व जिमि केहेँ नं खः। व जिमि बाःया म्‍ह्याय् खःसां जिमि मांया धाःसा मखु। जिं वयात ब्‍याहा याना। ");
INSERT INTO new_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","परमेश्‍वरं जितः जिमि बौया छेँ त्‍वःताः उखेंथुखें जुइम्‍ह यानादिसेंलि जिं सारायात ‘न्‍ह्याथाय् वंसां छं जितः दया यानाः जि छं दाजु खः धकाः धा’ धयागु खः।” ");
INSERT INTO new_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","अले अबीमेलेकं अब्राहामयात फैच्‍वलय्‌, साद्वहं व दासदासीत बिल। वया कलाः सारायात नं लित बिल। ");
INSERT INTO new_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","वं अब्राहामयात धाल, “थ्‍व फुक्‍क जिगु दे खः। छ मंदुथाय् च्‍वँ।” ");
INSERT INTO new_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","वं सारायात धाल, “छिमिसं छुं नं द्वंकूगु मदु धकाः सकसिनं सीमा धकाः जिं छिमि दाजुयात द्वःछि वहःया धिबा बियागु दु।” ");
INSERT INTO new_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","अब्राहामं परमेश्‍वरयात प्रार्थना यात। अले परमेश्‍वरं अबीमेलेक, वया कलाः व दासीतय्‌त नं लाय्‌कादिल। आः इपिं हानं मचा बुइकेफइपिं जुल। ");
INSERT INTO new_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","छाय्‌धाःसा परमेश्‍वरं अब्राहामया कलाः साराया हुनिं यानाः अबीमेलेकया कलाः व वया दासीपिन्‍त मचा बुइके मफइपिं यानादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","परमप्रभुं सारायात थःम्‍हं बचं बियादी थें दया यानादिल, अले थःम्‍हं धया थें यानादिल। ");
INSERT INTO new_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","अब्राहाम बुरा जुइ धुंकूसां परमेश्‍वरं धयादीगु हे इलय् सारां काय् बुइकल। ");
INSERT INTO new_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","अब्राहामं वयागु नां इसहाक तल। ");
INSERT INTO new_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","इसहाक च्‍यान्‍हु दुबलय् अब्राहामं परमेश्‍वरं धयादी थें वयात म्‍हय् चिं तय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","इसहाक बूबलय् अब्राहाम सच्‍छिदँ दये धुंकूम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","अले सारां धाल, “परमेश्‍वरं जितः लसताः बियादिल। थ्‍व खँ न्‍यनीपिं सकलें जि नाप लय्‌ताइ। ");
INSERT INTO new_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","आः तक अब्राहामयात सुनां जिं मचायात दुरु त्‍वंकी धकाः धायेफु। अय्‌नं जिं व बुरा जुइ धुंकाः वयापाखें काय् बुइका।” ");
INSERT INTO new_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","मचा तःधिकः जुयावल। मचायात दुरुं छीखुन्‍हु अब्राहामं तःधंगु भ्‍वय् न्‍याय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","छन्‍हु सारां हागारया काय् इश्‍माएलं थःकाय् इसहाकयात हाय्‌काच्‍वंगु खनाः ");
INSERT INTO new_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","अब्राहामयात धाल, “व मिश्री दासी व वया काय्‌यात थनं पितिनाछ्व। व दासीया काय्‌नं जिकाय् इसहाकं थें छंगु सम्‍पत्ति कायेखनि मखु।” ");
INSERT INTO new_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","थ्‍व खं अब्राहामया नुगः मछिन। छाय्‌धाःसा इश्‍माएल नं वया थः हे काय् खः। ");
INSERT INTO new_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","तर परमेश्‍वरं वयात धयादिल, “छं छिमि दासी कलाः व काय्‌या खँय् नुगः मछिंके मते। सारां धाःथें या। इसहाकया पाखें हे छिमि सन्‍तान न्‍ह्याइ। ");
INSERT INTO new_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","अथेसां व दासी मिसाया मचा नं छं हे काय् जूगुलिं वयापाखें नं जिं छगू तःधंगु जाति दय्‌काबी।” ");
INSERT INTO new_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","कन्‍हय् खुन्‍हु सुथ न्‍हापां अब्राहामं लः दुगु छेंगूया छगः थल व मरि हयाः हागारया ब्‍वहलय् तयाबिल। अले काय्‌म्‍हनापं वयात अनं छ्वयाबिल। इपिं बेर्शेबाया मरुभूमिइ उखेंथुखें जुयाः जुल। ");
INSERT INTO new_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","थलय् च्‍वंगु लः फुसेंलि हागारं काय्‌म्‍हय्‌सित छथाय् झालय् त्‍वःताः ");
INSERT INTO new_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","थः तापाक्‍क वनाः फेतुत। थः काय्‌यात सीगु स्‍वये मफयाः वं थथे याःगु खः। अले व अन च्‍वनाः ह्वाँय्‌ह्वाँय् ख्‍वल। ");
INSERT INTO new_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","परमेश्‍वरं काय्‌म्‍ह ख्‍वःगु सः ताल। अले परमेश्‍वरया दूतं स्‍वर्गं हागारयात धयाहल, “छन्‍त छु दुःख जुल, हागार? ग्‍याये मते। परमेश्‍वरं छिमि काय् ख्‍वःगु ताये धुंकल। ");
INSERT INTO new_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","दँ, वनाः छिमि काय्‌यात ल्‍हाः ज्‍वनाः थँ, अले वयात बल्‍लाक ज्‍वनाति। छाय्‌धाःसा जिं वयापाखें छगू तःधंगु जाति दय्‌के।” ");
INSERT INTO new_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","अले परमेश्‍वरं वयात छगू बुंगाःचा क्‍यनादिल। वं वनाः छेंगूया म्‍हिचाय् लः तयाः थःकाय्‌यात त्‍वंकल। ");
INSERT INTO new_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","परमेश्‍वर वया काय्‌म्‍हलिसे हे च्‍वनादिल। व मरुभूमिइ हे च्‍वनाः तःधि जुल। अले धनुष वाण कय्‌केगुलिइ जाःम्‍ह जुल। ");
INSERT INTO new_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","व पारान धाःगु मरुभूमिइ च्‍वनीगु खः। वया मामं वयात छम्‍ह मिश्रयाम्‍ह मिसा ब्‍याहा यानाबिल। ");
INSERT INTO new_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","थुबलय् हे अबीमेलेक व वया सेनापति पीकोलं अब्राहामयात धाल, “छिं यानादीगु न्‍ह्यागु ज्‍याय् नं छितः परमेश्‍वरं आशिष बियादिल। ");
INSERT INTO new_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","छिं आः जितः परमेश्‍वरया न्‍ह्यःने जितः व जिमि काय्‌म्‍ह्याय्‌पिं व छय्‌छुइपिन्‍त गुबलें हे धोखा बी मखु धकाः पाफयादिसँ। जिं छिगु लागि गथे व्‍यवहार यानागु दु, छिं नं अथे हे जि व थः च्‍वनाच्‍वनागु देशलिसे व्‍यवहार यानादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहामं धाल, “जिं पाफये।” ");
INSERT INTO new_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","अले अब्राहामं अबीमेलेकया दासतय्‌सं लाकाकाःगु तुंयागु खँ न्‍ह्यथन। ");
INSERT INTO new_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अले अबीमेलेकं धाल, “थ्‍व खँ जिं थौं हे तिनि न्‍यना। छिं थ्‍व खँ न्‍हापा हे छाय् धयामदिया? जिं मस्‍यू थथे सुनां यात।” ");
INSERT INTO new_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","अले अब्राहामं अबीमेलेकयात सा द्वहं व फै हयाबिल। थुकथं इपिं निम्‍हसिया दथुइ छगू सन्‍धि जुल। ");
INSERT INTO new_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहामं थःगु फैतय्‌गु पुचलं न्‍हय्‌म्‍ह भ्‍याःचात चीकल। ");
INSERT INTO new_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अले अबीमेलेकं धाल, “छिं छुकिया निंतिं थुपिं फैचात अलग्‍ग तयादियागु?” ");
INSERT INTO new_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","अब्राहामं लिसः बियाः धाल, “थ्‍व न्‍हय्‌म्‍ह भ्‍याःचात कयादिसँ। थुकिं थ्‍व तुं जिं म्‍हुयागु खः धकाः साक्षी बी।” ");
INSERT INTO new_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","थुकथं व थाय्‌यागु नां बेर्शेबा जुल। छाय्‌धाःसा इमिसं अन सन्‍धि याःगु खः। ");
INSERT INTO new_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","बेर्शेबाय् सन्‍धि याये धुंकाः अबीमेलेक व वया सेनापति पीकोल पलिश्‍तीतय्‌गु देशय् लिहां वन। ");
INSERT INTO new_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहामं बेर्शेबाय् तितिसिमा छमा पित। अले परमप्रभु सदां दयाच्‍वनीम्‍ह परमेश्‍वरया नां कयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","अब्राहाम तःन्‍हु तक पलिश्‍तीतय्‌गु देशय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","छुं ई लिपा परमेश्‍वरं अब्राहामयात जाँचय् यायेत सःतादिल, “अब्राहाम!” वं लिसः बिल, “प्रभु, जि थन हे दु।” ");
INSERT INTO new_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","परमेश्‍वरं धयादिल, “छिमि काय्, छं तसकं माया यानातःम्‍ह याकः काय् इसहाकयात ज्‍वनाः मोरीयाहया देशय् हुँ। जिं अन छगू पहाड क्‍यने, अन हे छं जिगु लागिं छिमि काय्‌यात होमबलि ब्‍यु।” ");
INSERT INTO new_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","कन्‍हय् खुन्‍हु सुथ न्‍हापां दनाः अब्राहामं मि च्‍याकेत सिँ फाल, गधाया म्‍हय् काठी चित। अले थःकाय् इसहाक व निम्‍ह दासयात ज्‍वनाः परमेश्‍वरं धयादी पाखे वन। ");
INSERT INTO new_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","स्‍वन्‍हु दुखुन्‍हु अब्राहामं तापाक्‍कं व थाय् खन। ");
INSERT INTO new_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","वं थः दासतय्‌त धाल, “छिपिं थन हे गधालिसे च्‍वँ। जि व जिमि काय् हुंकन वनाः प्रार्थना यानाः वये।” ");
INSERT INTO new_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","अब्राहामं इसहाकया ब्‍वहलय् होमबलि बीगु सिँ पाछाय्‌कल, थःम्‍हं मि व चुपि ज्‍वन। अले इपिं निम्‍हं नापं वन। ");
INSERT INTO new_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","इसहाकं थः बौ अब्राहामयात धाल, “बाः”। अब्राहामं धाल, “छु जुल, पुता?” “झीके मि व सिँ ला दु, होमबलि बीत भ्‍याःचा ग्‍व लय्?” ");
INSERT INTO new_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहामं धाल, “पुता, परमेश्‍वरं हे झीत होमबलि बीगु लागिं भ्‍याःचा बी।” थुकथं इपिं नापं वनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","परमेश्‍वरं वयात धयादीगु थासय् थ्‍यंकाः अब्राहामं छगू वेदी दय्‌काः उकी सिँ पँचित। अले थःकाय्‌यात न्‍याक्‍क चिनाः वेदी दुगु सिँपँय् थ्‍यन। ");
INSERT INTO new_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","वं थःकाय्‌यात स्‍यायेत चुपि पिकाल। ");
INSERT INTO new_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","उबलय् हे स्‍वर्गं परमप्रभुया दूतं वयात सःतल, “अब्राहाम, अब्राहाम!” वं धाल, “जि थन दु।” ");
INSERT INTO new_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","दूतं धयाहल, “छं छिमि काय्‌यात ल्‍हाः ल्‍ह्वने मते, अले वयात छुं हे याये मते। जिं सिल, छ धात्‍थें हे परमेश्‍वरं धाःथे याइम्‍ह खः। छाय्‌धाःसा छं थः याकः काय्‌यात तकं वय्‌कःया लागि होमबलि बीत स्‍वल।” ");
INSERT INTO new_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","अब्राहामं उखेंथुखें स्‍वल। वं झालय् न्‍यकू तक्‍यनाच्‍वंम्‍ह भ्‍याःचा छम्‍ह खन। वं वयात ज्‍वनाहयाः थः काय्‌या पलेसा होमबलि बिल। ");
INSERT INTO new_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","अब्राहामं व थाय्‌या नां “परमप्रभुं बियादी” तल। थौं तक नं मनूतय्‌सं “परमप्रभुं पर्वतय् बियादी” धकाः धायेगु याः। ");
INSERT INTO new_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","परमप्रभुया दूतं अब्राहामयात निकः खुसी स्‍वर्गं धयाहल – ");
INSERT INTO new_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“परमप्रभुं धयादीगु दु, जिं थःगु हे नामय् बाचा चिने। छं थथे जिगु लागिं थः याकः काय्‌यात तकं मधाःगुलिं जिं छन्‍त तःधंगु आशिष बी। ");
INSERT INTO new_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","जिं छन्‍त आकाशय् च्‍वंगु नगु व फिसलय् च्‍वंगु फि थें यक्‍व सन्‍तान दय्‌काबी। इमिसं थः शत्रुतय्‌त बुकाः इमिगु शहर त्‍याकाकाइ। ");
INSERT INTO new_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","छं जिं धाःथें याःगुलिं छिमि सन्‍तानपाखें संसारय् च्‍वंपिं फुक्‍कसिनं आशिष कायेखनि।” ");
INSERT INTO new_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","अब्राहाम व इसहाक थःपिनि दासत दुथाय् लिहां वन। इपिं अनं बेर्शेबाय् वन। अले अब्राहाम अन हे च्‍वनाछ्वत। ");
INSERT INTO new_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","छन्‍हु अब्राहामं वया किजा नाहोरया नं मिल्‍काया पाखें च्‍याम्‍ह मस्‍त दये धुंकल धकाः सिल। ");
INSERT INTO new_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","दक्‍वसिबय् तःधीम्‍ह ऊज, अनंलि बूज, आरामया बौ कमूएल, ");
INSERT INTO new_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","केसेद, हजो, पिलदाश, यिदलाप व बतूएल। ");
INSERT INTO new_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","थ्‍व बतूएल रिबेकाया बौ खः। थुपिं च्‍याम्‍ह काय्‌पिं अब्राहामया किजा नाहोरं मिल्‍काया पाखें बुइकूगु खः। ");
INSERT INTO new_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","नाहोरया मथ्‍याःम्‍ह कलाः रूमा पाखें नं प्‍यम्‍ह मस्‍त दु – तेबह, गहम, तहस व माका। ");
INSERT INTO new_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा सच्‍छि व निइन्‍हय्‌दँ दुबलय् ");
INSERT INTO new_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","कनानया किर्यत-अर्बा धाःथाय् सित (थौंकन्‍हय् हेब्रोन धाइ)। अब्राहाम व सीगुया दुःखं च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","वं हित्तीतय्‌थाय् वनाः धाल, ");
INSERT INTO new_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“जि छिकपिन्‍थाय् पिनें वयाः च्‍वनाच्‍वनागु खः। जिमि कलाःयात थुनेत जिके छकू नं बुँ मदु। उकिं जितः छकू बुँ मियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","इमिसं धाल, ");
INSERT INTO new_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“हे प्रभु, न्‍यनादिसँ, छि छम्‍ह तःधंम्‍ह मनू खः। छिं थः कलाःयात थुनेत दक्‍वसिबय् बांलाःगु बुँ ल्‍ययादिसँ। जिपिं सुनानं मज्‍यू धाये मखु।” ");
INSERT INTO new_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","अले अब्राहामं दनाः इमिगु न्‍ह्यःने क्‍वछुनाः धाल, ");
INSERT INTO new_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“छिकपिन्‍सं जितः जिमि कलाःयात थन हे थुनेबीगु खःसा सोहोरया काय् एप्रोनयात ");
INSERT INTO new_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","वयागु बुँनापं च्‍वंगु मक्‍पेला धाःगु गुफा जितः म्‍यु धयाबियादिसँ। जिं तूगु धिबा पुलाबी, अले छिकपिं फुक्‍कं साक्षी जुइ।” ");
INSERT INTO new_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","एप्रोन अन हे हित्तीतलिसे शहरया ध्‍वाखाय् च्‍वनाच्‍वंगु खः। वं अन च्‍वनाच्‍वंपिं फुक्‍कसिनं तायेक धाल, ");
INSERT INTO new_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“मखु, जिमि प्रभु, जिं छितः व गुफा जक मखु, फुक्‍क बुँ हे बी। थः मनूतय् न्‍ह्यःने हे व फुक्‍कं जिं छितः सीम्‍ह थुनेत सितिकं बी।” ");
INSERT INTO new_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","अब्राहाम हाकनं छकः हित्तीतय् न्‍ह्यःने क्‍वछुत। ");
INSERT INTO new_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","अले फुक्‍कसिनं तायेक एप्रोनयात धाल, “जिं व फुक्‍क बुँ धिबा पुलाः न्‍याये। जिं पुलागु धिबा कयादिसँ। अले जिं थः कलाःयात अन थुने।” ");
INSERT INTO new_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","एप्रोनं अब्राहामयात धाल – ");
INSERT INTO new_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“प्रभु, बुँया मू ला प्‍यसःकू वहःया म्‍वहः जक खः। थुलिचिया लागि झी छु हालाच्‍वनेगु? सीम्‍ह थुनादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","अब्राहामं एप्रोनया खँ न्‍यन। अले वं अन दुपिं फुक्‍कसिया न्‍ह्यःने वयात प्‍यसः वहःया म्‍वहः बिल। ");
INSERT INTO new_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","थुकथं एप्रोनं मक्‍पेलाया मम्रे लिक्‍क च्‍वंगु थःगु बुँ व अन च्‍वंगु गुफा व सिमात फुक्‍कं ");
INSERT INTO new_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","शहरया ध्‍वाखाय् मुं वयाच्‍वंपिं हित्तीत फुक्‍कसिया न्‍ह्यःने अब्राहामयात मिल। ");
INSERT INTO new_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","अले अब्राहामं थः कलाः सारायात मम्रेया लिक्‍क च्‍वंगु कनान देशया मक्‍पेला गुफाय् थुन। ");
INSERT INTO new_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","थुकथं हित्तीतय्‌गु बुँ व अन च्‍वंगु गुफा अब्राहामं सी थुनेगु थाय्‌कथं थःगु यानाः काल। ");
INSERT INTO new_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहाम तसकं बुरा जुइ धुंकल। वं याःगु दक्‍व ज्‍याय् परमप्रभुं आशिष बियादीगु दु। ");
INSERT INTO new_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","अब्राहामं थः दक्‍वसिबय् पुलांम्‍ह व छेँय् फुक्‍क ज्‍या स्‍वइम्‍ह च्‍यःयात सःताः धाल – ");
INSERT INTO new_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","“स्‍वर्ग व पृथ्‍वीया परमप्रभुया नामय् छं जिमि काय्‌यात थन कनानय् च्‍वंपिं मिस्‍त ब्‍याहा यानाबी मखु धकाः बचं ब्‍यु। ");
INSERT INTO new_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","जिगु थःगु हे देशय् थः हे मनूतय्‌थाय् वनाः जिम्‍ह काय् इसहाकयागु लागि भम्‍चा हयाब्‍यु।” ");
INSERT INTO new_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","अले व च्‍यलं अब्राहामयात धाल, “जिं ल्‍ययाम्‍ह मिसा जि लिसे थन वये मखु धाःसा छु छिं थःकाय्‌यात छि गनं झायागु खः, व हे देशय् जिलिसें लित छ्वयादीगु खः ला?” ");
INSERT INTO new_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहामं धाल, “छं जिमि काय्‌यात न्‍ह्याथे जूसां अन लित यंके मते। ");
INSERT INTO new_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","जितः जिमि अबुया छेँ व जि बूगु देशं थन हयादीम्‍ह स्‍वर्गया परमप्रभु परमेश्‍वरं जिलिसें, ‘थ्‍व दे जिमि सन्‍तानयात बी’ धकाः बचं बियादीगु दु। वय्‌कलं छंगु न्‍ह्यः न्‍ह्यः थःम्‍ह छम्‍ह दूत छ्वयाहयादी। अले छं जिमि काय्‌या लागि भम्‍चा माले फइ। ");
INSERT INTO new_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","छुं जुयाः व मिसां छलिसे वये मखु धकाः धाःसा छं थ्‍व बचं पूमवंकूसां ज्‍यू। जिमि काय्‌यात जक छं अन यंके मते।” ");
INSERT INTO new_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","अले व च्‍यलं अब्राहामयात वं “छु छु धाःगु खः, फुक्‍क याये” धकाः बचं बिल। ");
INSERT INTO new_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","अनंलि व थः मालिकया झिम्‍ह ऊँट व थिकय् थिकय्‌गु कोसेलि ज्‍वनाः अब्राहामया किजा नाहोर च्‍वनाच्‍वंगु शहर अराम-नहरैमपाखे वन। ");
INSERT INTO new_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","अन थ्‍यंकाः वं शहरं पिनेया छगः तुं लिक्‍क उँटतय्‌त झासु लंकेत त्‍वःतल। थुबलय् सन्‍ध्‍याकाः ई जुइ धुंकल। अले मिसामस्‍त लः काःवइगु ई नं जुइ धुंकल। ");
INSERT INTO new_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","वं मनमनं प्रार्थना यात, “हे जिमि मालिक अब्राहामया परमप्रभु परमेश्‍वर! दया यानाः थौं, जिगु ज्‍या तालाकादिसँ अले जिमि मालिक अब्राहामयात थःगु दया क्‍यनादिसँ। ");
INSERT INTO new_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","शहरया मिसामस्‍त थन तुंथिइ लः काः वइन। ");
INSERT INTO new_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","जिं इपिं मध्‍ये छम्‍हसित ‘जितः लः त्‍वनेत छंगु घःचा भचा क्‍वःछुकि’ धकाः धाये। वं जितः ‘भपि, जिं छिकपिनि उँटतय्‌त नं लः त्‍वंके’ धकाः धाल धाःसा छिं थः दास इसहाकयात ल्‍ययादीम्‍ह मिसा व हे खः धकाः सीकाकाये। अले छिं जिमि मालिकयात जिं बियागु बचं पूवंकादिल धकाः नं सीकाकाये।” ");
INSERT INTO new_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","वं प्रार्थना याये सिमधय्‌वं हे छम्‍ह ब्‍याहा मजूनिम्‍ह बांलाःम्‍ह मिसा लः कायेत घः ज्‍वनाः वल। व मिसा अब्राहामया किजा नाहोरया काय् बतूएलया म्‍ह्याय् रिबेका खः। नाहोरया कलाः मिल्‍का खः। रिबेका वया न्‍ह्यःने जुयाः तुंथिइ वन। अले लः सालाः लिहां वनेत्‍यन। ");
INSERT INTO new_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","वं ब्‍वाँय् वनाः वयात धाल, “जितः लः भचा त्‍वंकि लय्।” ");
INSERT INTO new_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","अले वं “ज्‍यू प्रभु, भपि” धकाः वयात घलं लः त्‍वंकल। ");
INSERT INTO new_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","अले वं लः त्‍वने धुंकाः व मिसामचां धाल, “छिकपिनि उँटतय्‌त नं जिं लः त्‍वंके।” ");
INSERT INTO new_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","वं याकनं याकनं फुक्‍क लः उँटतय् लः त्‍वनीगु थलय् प्‍वंकाबिल। अले इमि त्‍वने मगाःतले लः हयाबिल। ");
INSERT INTO new_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","परमप्रभुं ल्‍यःम्‍ह मिसामचा व हे खः कि मखु धकाः सीकेत वं नमवासे रिबेकां छु छु यात फुक्‍क स्‍वयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","रिबेकां उँटतय्‌त लः त्‍वंकेधुंकाः वं थःम्‍हं ज्‍वनावःगु बच्‍छि शेकेल ति दुगु लुँयागु चाःचा व झिगू शेकेल ति दुगु निपा लुँयागु चुरि लिकयाः वयात बिल। ");
INSERT INTO new_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","अले वं धाल, “छ सुया म्‍ह्याय् खः? छिमिगु छेँय् जि व जिमि मनूतय्‌त चा च्‍वनेत थाय् दइ ला?” ");
INSERT INTO new_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","वं लिसः बिल, “जिमि बाः नाहोर व मिल्‍काया काय् बतूएल खः। ");
INSERT INTO new_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","जिमिगु छेँय् छि व छिकपिनि मनूत च्‍वनेत थाय् दु। अले छिकपिनि उँटतय्‌त तयेत नं यक्‍व सु व नसा दु।” ");
INSERT INTO new_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","अले वं छ्यं क्‍वःछुकाः परमप्रभुयात प्रार्थना यात, ");
INSERT INTO new_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“जिमि मालिक अब्राहामया परमप्रभु धन्‍यम्‍ह खः। वय्‌कलं जिमि मालिकयात बियागु बचं पूवंकादिल। अले वय्‌कलं जितः तप्‍यंक हे जिमि मालिकया थःथितियाथाय् हयादिल।” ");
INSERT INTO new_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","रिबेकां थःगु छेँय् वनाः मां बौयात फुक्‍क खँ कन। ");
INSERT INTO new_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","रिबेकाया दाजु लाबानं थः केहेँनं धाःगु खँ न्‍यनाः अले केहेँनं न्‍ह्यानातःगु चुरि व न्‍हाय्‌पनय् चाःचा खनाः याकनं पिने ब्‍वाँय् वनाः तुं लिक्‍क ऊँटत नाप दनाच्‍वंम्‍ह अब्राहामया च्‍यःयाथाय् थ्‍यंकः वन। ");
INSERT INTO new_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","अले धाल, “परमप्रभुं आशिष बियातःम्‍ह छि जिगु छेँय् झासँ। थन पिने छाय् च्‍वनाच्‍वनादिया? जिं छिकपिन्‍त च्‍वनेत क्‍वथा अले उँटतय्‌त तयेत थाय् नं दय्‌कातयेधुन।” ");
INSERT INTO new_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","अब्राहामया च्‍यः लाबानलिसे वयागु छेँय् वन। लाबानं उँटतय्‌गु म्‍हय् च्‍वंगु कु क्‍वकाय्‌केबियाः इमित सु व नसा तयाबिल। अले अब्राहामया च्‍यः व वया मनूतय्‌त तुति सिलेत लः हयाबिल। ");
INSERT INTO new_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","अनंलि इमित नसा हयाबिल। अब्राहामया च्‍यलं धाल, “जि थन छाय् वयागु धयागु खँ मकंतले जिं नये मखु।” लाबानं धाल, “धयादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","वं धाल, “जि अब्राहामया छम्‍ह च्‍यः खः। ");
INSERT INTO new_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","परमप्रभुं जिमि मालिकयात तःधंगु आशिष बियादीगु दु। अले वय्‌कःयात तःमि नं यानादीगु दु। परमप्रभुं वय्‌कःयात ग्‍वाः ग्‍वाः फै-च्‍वलय्, सा द्वहं, ऊँट, गधाया नापं लुँ, वहः व दास-दासीत बियादीगु दु। ");
INSERT INTO new_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","“जिमि मालिकया कलाः साराया बुरी जुइ धुंकाः तकं मचा मबू। बुरी जुइ धुंकाः तिनि काय् छम्‍ह बुल। जिमि मालिकं वयात थःगु फुक्‍क सर्बय् बिल। ");
INSERT INTO new_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","जिमि मालिकं जितः थःम्‍हं धाःथें यायेत पाःफय्‌कादिल। अले धयादिल, ‘छं जिमि काय्‌यात जि आः च्‍वनाच्‍वनागु कनान देशया सुं नं मिसा ब्‍याहा यानाबी मते। ");
INSERT INTO new_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","बरु जिमि बाःया छेँ, जिमि थःथितितय् हे म्‍ह्याय्‌मचा छम्‍ह ल्‍ययाः हजि।’ ");
INSERT INTO new_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“अले जिं जिमि मालिकयाके न्‍यना, ‘जिं ल्‍ययाम्‍ह मिसां जिलिसें वये मखु धाःसा छु यायेगु लय्?’ ");
INSERT INTO new_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","वय्‌कलं धयादिल, ‘जिं न्‍ह्याबलें परमप्रभुं धयादी थें यानागु दु। वय्‌कलं जिमि बाःपाखेंया थःथितितय् दथुइ जिमि काय्‌या लागि भम्‍चा मालेत थः दूत छलिसे छ्वयादी। ");
INSERT INTO new_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","इमिसं थः थःथितियात छलिसे छ्वयामहल धाःसा छं थःगु बचं पूमवंकूसां ज्‍यू।’ ");
INSERT INTO new_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“थौं जिं थन तुंथिइ थ्‍यंकाः मनमनं प्रार्थना याना, ‘परमप्रभु, जिमि मालिक अब्राहामया परमेश्‍वर, जि छु ज्‍या यायेत थन वयागु खः, व ज्‍या पूवंकाबियादिसँ। ");
INSERT INTO new_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","जि थन तुंथिइ दनाच्‍वनागु दु। थन सु मिसामचा लः काःवइ, जिं वयात “छंगु घलं जितः लः भचा त्‍वंके ब्‍यु” धकाः धाये। ");
INSERT INTO new_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","वं जितः “भपि, जिं छिकपिनि उँटतय्‌त नं लः त्‍वंके” धकाः धाइ। अले व हे मिसा परमप्रभुं जिमि मालिकया काय्‌यात ल्‍ययादीगु जुइ।’ ");
INSERT INTO new_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“जिं प्रार्थना याये सिमधय्‌वं रिबेका घः ज्‍वनाः तुंपाखे वल। वं तुंथिं लः साल। जिं वयात धया, ‘जितः त्‍वनेत लः भचा ब्‍यु।’ ");
INSERT INTO new_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","वं याकनं थःगु घः क्‍वकयाः ‘भपियादिसँ, जिं छिकपिनि उँटतय्‌त नं लः त्‍वंके’ धाल। अले जिं लः त्‍वना। वं उँटतय्‌त नं लः तयाबिल। ");
INSERT INTO new_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“जिं वयाके न्‍यना, ‘छ सुया म्‍ह्याय् खः?’ “वं धाल, ‘जिमि बाः नाहोर व मिल्‍काया काय् बतूएल खः।’ “अले जिं वयागु न्‍हाय्‌पनय् चाःचा व ल्‍हातिइ चुरि न्‍ह्याकाबिया।” ");
INSERT INTO new_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","“जिं परमप्रभुया न्‍ह्यःने छ्यं क्‍वःछुकाः, अले जिमि मालिक अब्राहामया परमप्रभु परमेश्‍वरयात तःधंका। वय्‌कलं जिमि मालिकया किजाया छय् वय्‌कःया काय्‌यात चूलाकाबीत जितः तप्‍यंक छ्वयादिल। ");
INSERT INTO new_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","आः छिं जिमि मालिकयात धात्‍थें हे माया यानादीगु खःसा, खः धयादिसँ, मखुसा, मखु धयादिसँ। जि गन वनेमाःगु खः अन हे वने।” ");
INSERT INTO new_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","लाबान व बतूएलं धाल, “थ्‍व फुक्‍क परमप्रभुं हे यानादीगु खः। जिमिसं गथे यानाः ‘मज्‍यू’ धायेगु? ");
INSERT INTO new_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","रिबेकायात यंकादिसँ। अले परमप्रभुं धयादी थें छिकपिनि मालिकया काय्‌लिसें ब्‍याहा यानाबियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","थ्‍व न्‍यनाः अब्राहामया च्‍यलं छ्यं क्‍वःछुकाः परमप्रभुयात सुभाय् बिल। ");
INSERT INTO new_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","अले वं वसः, लुँ वहःया तिसा पिकयाः रिबेकायात बिल। वं वया मां व दाजुयात नं थिकय् थिकय्‌गु कोसेलि देछात। ");
INSERT INTO new_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","अनंलि अब्राहामया च्‍यः अले व नापं वःपिं फुक्‍कसिनं नयेत्‍वने यात। अले अन हे चा च्‍वन। सुथय् दनाः वं रिबेकाया मां व दाजुयात धाल, “आः जिमि मालिकयाथाय् वनेत जितः बिदा बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","इमिसं धाल, “रिबेकायात जिपिंलिसें च्‍यान्‍हु झिन्‍हु थन हे तयादिसँ। अले यंकादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","वं धाल, “जिमित थन च्‍वनेत धयादी मते। परमप्रभुं जिपिं थन वयागु ज्‍या पूवंकाबियादीगु दु। आः जिपिं जिमि मालिकयाथाय् लिहां वने।” ");
INSERT INTO new_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","इमिसं धाल, “रिबेकायात हे न्‍यनास्‍वये, वं छु धाइ।” ");
INSERT INTO new_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","अले इमिसं रिबेकायात सःताः न्‍यन, “छ वय्‌कःलिसे वनेगु खः ला?” वं धाल, “ज्‍यू, जि वने।” ");
INSERT INTO new_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","अले इमिसं रिबेका व वयात मचाबलय् दुरु त्‍वंकूम्‍ह मिसायात अब्राहामया च्‍यः व वया मनूतलिसे छ्वयाबिल। ");
INSERT INTO new_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","इमिसं रिबेकायात आशिष बियाः धाल – “परमेश्‍वरं छन्‍त यक्‍व सन्‍तान बियादीमा, अले छिमि सन्‍तानं थः शत्रुतय्‌त त्‍याकावने फयेमा।” ");
INSERT INTO new_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","अले रिबेका व वया दासीत अब्राहामया च्‍यःलिसे वनेत तयार जुयाः उँटय् च्‍वन। थुकथं इपिं अनं वन। ");
INSERT INTO new_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","इसहाक उबलय् बेअर-लहै-रोइपाखें व जक वःगु खः। छाय्‌धाःसा व नेगेवय् च्‍वनाच्‍वंम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","छन्‍हु सन्‍ध्‍याकाः ई पाखे इसहाक ध्‍यान यायेत ख्‍यलय् पाखे वनाच्‍वंबलय् वं ऊँटत वयाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबेकां इसहाकयात खनाः ऊँटं कुहां वल। ");
INSERT INTO new_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","अले वं अब्राहामया च्‍यःयाके न्‍यन, “हुं वयाच्‍वंम्‍ह मनू सु खः?” “व जिमि मालिक खः” च्‍यलं लिसः बिल। अले रिबेकां थःगु ख्‍वाः गां त्‍वपुल। ");
INSERT INTO new_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","च्‍यलं इसहाकयात थःम्‍हं यानागु फुक्‍क खँ कन। ");
INSERT INTO new_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","इसहाकं रिबेकायात थः मां च्‍वनेगु पालय् हल। अले व इसहाकया कलाः जुल। वं रिबेकायात तसकं माया याः। थुकथं वं थः मां मदुगु दुःख तंकल। ");
INSERT INTO new_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहामं मेम्‍ह छम्‍ह मिसालिसे ब्‍याहा यात। वयागु नां कतूरा खः। ");
INSERT INTO new_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","वयापाखें जिम्रान, योक्षान, मदान, मिद्यान, यिशबाक व शूह बुल। ");
INSERT INTO new_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षान शेबा व ददानया अबु खः। ददानया सन्‍तान अश्‍शूरी, लतूशी व लऊम्‍मीत खः। ");
INSERT INTO new_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यानया काय्‌पिं एपा, एपेर, हानोक, अबीदा व एल्‍दा खः। थुपिं फुक्‍कं कतूराया सन्‍तान खः। ");
INSERT INTO new_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","अब्राहामं थःके दुगु फुक्‍कं इसहाकयात त्‍वःताथकल। ");
INSERT INTO new_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","थः मसिवं हे अब्राहामं मेपिं कलाःपिनि पाखें दुपिं काय्‌पिन्‍त कोसेलि बियाः थःकाय् इसहाकया पाखें अलग यानाः पुर्बपाखे छ्वयाब्‍यूगु खः। ");
INSERT INTO new_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहाम मुक्‍कं १७५ दँ तक म्‍वात। ");
INSERT INTO new_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","व ताः आयु म्‍वानाः यक्‍व बुरा जुयाः सित। अले थः पुर्खापिंलिसे मिलय् जूवन। ");
INSERT INTO new_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","वया काय्‌पिं इसहाक व इश्‍माएलं वयात सोहोर धाःम्‍ह हित्तीया काय् एप्रोनयागु बुँइ च्‍वंगु मम्रेया लिक्‍कसं च्‍वंगु मक्‍पेलाया गुफाय् थुनाबिल। ");
INSERT INTO new_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","थ्‍व बुँ अब्राहामं हित्तीतय्‌के न्‍यानाकाःगु खः। अब्राहाम व वया कलाः सारा निम्‍हय्‌सितं थन हे थुंगु खः। ");
INSERT INTO new_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहाम सी धुंकाः परमेश्‍वरं वया काय् इसहाकयात आशिष बियादिल। उबलय् इसहाक बेअर-लहै-रोइ लिक्‍कसं च्‍वनाच्‍वंगु खः। ");
INSERT INTO new_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","साराया मिश्र देशयाम्‍ह दासी हागारया पाखें दुम्‍ह अब्राहामया काय् इश्‍माएलया सन्‍तानया खँ थथे दु – ");
INSERT INTO new_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","न्‍हापां बूकथं इमिगु नां थथे दु, नबायोत, केदार, अदबेल, मिब्‍साम, ");
INSERT INTO new_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्‍मा, दुमा, मस्‍सा, ");
INSERT INTO new_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश व केदमा। ");
INSERT INTO new_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इश्‍माएलया काय्‌पिं थुपिं हे खः। थुपिं हे झिंनिगू कुलया नायः जुल। इमिगु हे नामं गांया नां च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्‍माएल १३७ दँ दुबलय् सित। ");
INSERT INTO new_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","इश्‍माएलया काय्‌पिं मिश्रया पुर्बपाखे अश्‍शूर वनेगु लँय्, हबीलांनिसें शूर तक च्‍वनाच्‍वंगु खः। इपिं अब्राहामया मेपिं सन्‍तानलिसे मिले मजुसे अलग्‍ग च्‍वनाच्‍वंगु खः। ");
INSERT INTO new_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहामया काय् इसहाकया खँ थथे दु, अब्राहामया काय् इसहाक बुल। ");
INSERT INTO new_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","इसहाकं पिइदँ दुबलय् अरामी बतूएलया म्‍ह्याय् व लाबानया केहें रिबेकालिसे ब्‍याहा यात। इपिं पद्दन-आरामयापिं खः। ");
INSERT INTO new_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","रिबेका थारिम्‍ह मिसा जूगुलिं इसहाकं परमप्रभुयात वयापाखें मचा दय्‌काबीत प्रार्थना यात। परमप्रभुं वयागु प्रार्थना न्‍यनादिल। अले रिबेकाया प्‍वाथय् दत। ");
INSERT INTO new_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","रिबेकाया प्‍वाथय् निम्‍ह मचा दुगु जुयाच्‍वन। अले इपिं प्‍वाथय् दुने हे थवंथवय् ल्‍वायेगु यानाच्‍वन। उकिं वं थथे मतिइ तल, “जितः थथे छाय् जुल?” अले वं परमप्रभुयाके न्‍यन। ");
INSERT INTO new_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","परमप्रभुं वयात लिसः बियादिल, “छंगु प्‍वाथय् निगू जाति दु। इपिं बूसांनिसें हे अलग जुयाः बुइ। चीधीम्‍ह तःधीम्‍ह स्‍वयाः बल्‍लाइ। तःधीम्‍हय्‌स्‍यां चीधीम्‍हय्‌सिगु सेवा याइ।” ");
INSERT INTO new_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","मचाबुइगु ई जुल। रिबेकाया प्‍वाथय् धात्‍थें हे निम्‍ह मचा दयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","न्‍हापांम्‍ह मचा ह्याउँसे च्‍वंम्‍ह बुल। वयागु म्‍ह छम्‍हं सँया सं भुनातःगु दु। उकिं वयागु नां एसाव तल। ");
INSERT INTO new_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","वयां लिपा बूम्‍ह मचा थः दाजु एसावयागु ग्‍वालि ज्‍वनाः बुल। उकिं इमिसं वयागु नां याकूब तल। इपिं बूबलय् इसहाक खुइदँ दये धुंकल। ");
INSERT INTO new_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","इपिं तःधि जुसेंलिं एसाव छम्‍ह बांलाःम्‍ह शिकारी व पिने जुयाः जुइम्‍ह जुल। याकूब धाःसा सोझाम्‍ह व छेँज्‍या जक याइम्‍ह जुल। ");
INSERT INTO new_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","एसावं शिकार यानाः ला हयाबीगुलिं इसहाकं वयात अप्‍वः माया याः। रिबेकां धाःसा याकूबयात अप्‍वः माया याः। ");
INSERT INTO new_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","छन्‍हु याकूबं मुसूति दाय्‌का च्‍वंबलय् एसाव नयेपित्‍याकाः पिनें लिहां वल। ");
INSERT INTO new_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","वं धाल, “जि नये पित्‍यानाः सीन, उकिं जितः व ह्याउँगु सूप भचा ति।” (अय्‌जूगुलिं वयात एदोम नं धायेगु याः)। ");
INSERT INTO new_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","याकूबं धाल, “न्‍हापां जितः छिगु तःधीम्‍ह काय्‌या अधिकार निं बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसावं धाल, “जि नयेपित्‍यानाः सीन, उकिं जितः थ्‍व अधिकार छु यायेत?” ");
INSERT INTO new_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याकूबं धाल, “दक्‍वसिबय् न्‍हापां पा निं फयादिसँ।” अले वं पाफल। थुकथं वं थःम्‍ह तःधीम्‍ह काय्‌या अधिकार मियाबिल। ");
INSERT INTO new_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","याकूबं एसावयात मरि व ह्याउँगु सूप बिल। नयेनी यानाः एसाव थःगु लँ लिनावन। थुकथं एसाव थःगु तःधीम्‍ह काय्‌या अधिकारया च्‍यूताः मतसे वन। ");
INSERT INTO new_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","अब्राहामया पालय् जूगु अनिकाल लिपा हाकनं छकः अन अनिकाल जुल। उकिं इसहाक गरारय् पलिश्‍तीतय् जुजु अबीमेलेकयाथाय् वन। ");
INSERT INTO new_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","परमप्रभुं वयाथाय् खनेदय्‌कः वयाः धयादिल, “मिश्र देशय् वने मते। जिं धयाथाय् हे च्‍वँ। ");
INSERT INTO new_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","छ परदेशी जुयाः अन हे च्‍वँ। जि छलिसें हे दइ, अले जिं छन्‍त आशिष बी। छाय्‌धाःसा जिं छिमि बाः अब्राहामलिसे छन्‍त व छिमि सन्‍तानयात थ्‍व हे देश बी धकाः बाचा चिनागु खः। ");
INSERT INTO new_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","जिं छन्‍त आकाशय् च्‍वंगु नगु थें यक्‍व सन्‍तान बियाः इमित थ्‍व फुक्‍क देश बी। छिमि हे सन्‍तानपाखें संसारय् च्‍वंपिं फुक्‍कसिनं आशिष कायेखनि। ");
INSERT INTO new_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","छाय्‌धाःसा अब्राहामं जिं धाःथें फुक्‍क यात। वं जिं बियागु आज्ञा, नियम व स्‍यनाकना मानय् यात।” ");
INSERT INTO new_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","उकिं इसहाक गरारय् हे च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","इसहाकं थः कलाः रिबेका तसकं बांलाःगुलिं अन च्‍वंपिं मनूतय्‌सं वयात स्‍यानाः रिबेकायात यंकी धकाः ग्‍यानाः सुनानं वया कलाःया बारे न्‍यन कि “जिमि केहेँ” धकाः धायेगु यात। ");
INSERT INTO new_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","इसहाक अन च्‍वनाच्‍वंगु तःन्‍हु लिपा छन्‍हु जुजु अबीमेलेकं झ्‍यालं स्‍वःबलय् इसहाकं थः कलाःयात माया यानाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","अबीमेलेकं इसहाकयात दुने सःताः धाल, “रिबेका छंम्‍ह कलाः खः, छाय् वयात केहेँ धकाः धयागु?” इसहाकं धाल, “वयागु लागि थनच्‍वंपिं मनूतय्‌सं जितः स्‍याइ धकाः।” ");
INSERT INTO new_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेकं धाल, “छं जिमित थ्‍व छु यानागु? सुनानं छिमि कलाःयात बांमलाःगु ज्‍या याःगु जूसा छं जिपिं फुक्‍कसित दोषी यानाबीगु, मखु ला?” ");
INSERT INTO new_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","अले अबीमेलेकं दक्‍वसित थथे धकाः उजं बिल, “सुनानं थ्‍व मनूयात व थ्‍वया कलाःयात थिल जक धाःसां वयात स्‍याइ।” ");
INSERT INTO new_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","इसहाकं अन बुँ ज्‍यात। अले उगु दँय् वं सच्‍छिब्‍व अप्‍वः सय्‌काः बाली लल, छाय्‌धाःसा परमप्रभुं वयात आशिष बियादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","इसहाकया बुँज्‍या झन झन बांलानावन। अले थुकथं व तसकं तःमि जुल। ");
INSERT INTO new_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","वयाके यक्‍व फै-च्‍वलय् व दास-दासीत दयावःगुलिं पलिश्‍तीतय् व खनाः नुगः मुल। ");
INSERT INTO new_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","अले इमिसं वया बौ अब्राहामया दास-दासीतय्‌सं अब्राहाम म्‍वानाच्‍वंबलय् हे म्‍हुयातःगु तुं ल्‍वहं व चा क्‍वफानाः ल्‍हानाबिल। ");
INSERT INTO new_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","अबीमेलेकं नं इसहाकयात धाल, “छ जिमिगु देश त्‍वःताः हुँ, छाय्‌धाःसा छ जिपिं स्‍वयाः नं बल्‍लाये धुंकल।” ");
INSERT INTO new_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","उकिं इसहाक शहरं पिहां वनाः गरारया पिने गंगु खुसि दुगु थासय् लिक्‍कसं पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","इसहाकं अन थः बौ अब्राहामया पालय् म्‍हूगु व पलिश्‍तीतय्‌सं अब्राहाम सी धुंकाः ल्‍हानाब्‍यूगु तुं हाकनं म्‍हुइकेबिल। अले वं तुंतय्‌गु नां अब्राहामं तयातःगु हे तयाबिल। ");
INSERT INTO new_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","इसहाकया दासतय्‌सं गंगु खुसिइ गाः म्‍हूबलय् अन बुंगाःचा लुयावल। ");
INSERT INTO new_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","अले गरारय् च्‍वंपिं फैजवाःत इसहाकया जवाःतलिसें, “थ्‍व जिमिगु लः खः” धकाः ल्‍वाः वल। उकिं व बुंगाःचिगु नां “ल्‍वापु” धकाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","इसहाकया दासतय्‌सं मेगु तुं म्‍हुल। अन नं इपिं ल्‍वाः वल। उकिं उकियागु नां “शत्रु” च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","अनंलि इमिसं मेथाय् वनाः हाकनं मेगु तुं म्‍हुल। थुगुसी धाःसा सुं ल्‍वाः मवल। उकिं वं व तुंयागु नां थथे धकाः “रहोबोत” तयाबिल, “आः धाःसा परमप्रभुं झीत च्‍वनेत व अझ अप्‍वयावनेत थाय् बियादीगु दु।” ");
INSERT INTO new_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","व अनं बेर्शेबाय् वन। ");
INSERT INTO new_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","उखुन्‍हु हे चान्‍हय् परमप्रभुं वयाथाय् खनेदय्‌कः झायाः वयात धयादिल, “जि छिमि बौ अब्राहामया परमेश्‍वर खः। ग्‍याये मते, छाय्‌धाःसा जि छलिसें दु। जिं जिमि च्‍यः अब्राहामलिसे बाचा चिना थें छन्‍त आशिष बी, अले छं यक्‍व सन्‍तान दइ।” ");
INSERT INTO new_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","इसहाकं अन छगू वेदी दय्‌काः परमप्रभुयात प्रार्थना यात। वं थःगु पाल नं अन हे ग्‍वल। वया दासतय्‌सं अन तुं म्‍हुइगु ज्‍या छुत। ");
INSERT INTO new_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","छन्‍हु अबीमेलेक थःत सल्‍लाह बीम्‍ह अहुज्‍जत व सेनापति पीकोलयात ब्‍वनाः गरारं इसहाकयाथाय् वल। ");
INSERT INTO new_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाकं इमित धाल, “छिकपिं थन छाय् झायागु? न्‍हापा ला छिकपिन्‍सं जितः क्‍वह्यंकाः थःपिनिगु देशं पितिना हयादिल।” ");
INSERT INTO new_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","इमिसं धाल, “जिमिसं सिल, परमप्रभु छिलिसे दी। उकिं आः झी दथुइ छगू सन्‍धि याये। झीसं पाफयाः छगू थज्‍याःगु सन्‍धि याये। ");
INSERT INTO new_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","छिं जिमित छुं यानादी मखु। न्‍हापा जिमिसं नं छितः मभिंगु छुं मयाना, बरु बांलाक हे व्‍यवहार याना। अले छुं मयासें याउँक छ्वयाहया। अथे हे छिसं नं जिमित छुं यानादी मते। आः छितः परमप्रभुं आशिष बियादिल।” ");
INSERT INTO new_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","अले इसहाकं इमित तःधंक भ्‍वय् नकल। इपिं फुक्‍कसिनं नयेत्‍वने यात। ");
INSERT INTO new_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","कन्‍हय् खुन्‍हु सुथ न्‍हापां इसहाक व इमिसं छगू सन्‍धि यात। अले इसहाकं इमित याउँक बिदा बियाछ्वत। इपिं इसहाकलिसे लय्‌तायाः बायावन। ");
INSERT INTO new_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","उखुन्‍हु हे इसहाकया दासतय्‌सं वयाः वयात धाल, “जिमिसं लः लुइका।” ");
INSERT INTO new_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","वं उकियागु नां शिबा तल। उकिं व शहरयागु नां आः तक नं बेर्शेबा हे जुयाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","एसावं पिइदँ दुबलय् हित्ती बेरीया म्‍ह्याय् यहूदीत व हित्ती एलोनया म्‍ह्याय् बासमतयात ब्‍याहा यात। ");
INSERT INTO new_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","इपिं मिसातय्‌सं यानाः इसहाक व रिबेकायात म्‍वाये हे थाकुकाबिल। ");
INSERT INTO new_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","इसहाक तसकं बुरा जुयाः मिखां हे मछुयावसेंलि वं थः दक्‍वसिबय् तःधीम्‍ह काय् एसावयात सःतल। वं वयाः धाल, “जिं छु याये माल?” ");
INSERT INTO new_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसहाकं धाल, “जि आः बुरा जुइ धुन, अले न्‍ह्यागु इलय् नं सी फु। ");
INSERT INTO new_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","उकिं छ थःगु धनुष ज्‍वनाः शिकारय् हुँ। अले जिगु लागिं पशु स्‍यानाः हजि। ");
INSERT INTO new_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","अले जितः साक्‍क दय्‌काः नके हजि। जिं छन्‍त सी न्‍ह्यः आशिष बिया थके।” ");
INSERT INTO new_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","इसहाकं एसावयात थथे धाःगु रिबेकां न्‍यनाच्‍वन। एसाव शिकार यायेत पिहां वने धुंकाः ");
INSERT INTO new_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","वं थःकाय् याकूबयात धाल, “जिं छिमि बाःनं छिमि दाजु एसावयात थथे धयाच्‍वंगु ताया – ");
INSERT INTO new_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘जि सी न्‍ह्यः छं शिकार यानाहयाः जितः साक्‍क नकि। अले जिं परमप्रभुया न्‍ह्यःने छन्‍त आशिष बी।’ ");
INSERT INTO new_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","उकिं, आः जिगु खँ न्‍यँ, अले जिं धाःथें या। ");
INSERT INTO new_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","वनाः बांलाःपिं निम्‍ह भ्‍याःचा ज्‍वनाः वा, जिं छिमि बाःनं धाःथें साक्‍क इमिगु ला दय्‌काबी। ");
INSERT INTO new_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","छं व यंकाः छिमि बाःयात नकि। अले छिमि बाःनं सी न्‍ह्यः छन्‍त हे आशिष बी।” ");
INSERT INTO new_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकूबं धाल, “एसावया ला म्‍ह छम्‍हं सँ दु। जिके धाःसा सँ मदु। ");
INSERT INTO new_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","छुं जुयाः बाःनं जितः थियास्‍वल धाःसा जिं वय्‌कःयात झंगःलाःगु थें जुइ। अले जितः आशिषया थासय् सराः बियादी।” ");
INSERT INTO new_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","रिबेकां वयात धाल, “छन्‍त ब्‍यूगु सराः जितः लायेमा। छं जिं धाःथे जक भ्‍याःचा ज्‍वनाः वा।” ");
INSERT INTO new_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","उकिं याकूबं वनाः मांम्‍हय्‌सिनं धाःथें भ्‍याःचा ज्‍वनाः वल। रिबेकां याकूबया बौयात यःथें साक्‍क ला दय्‌काबिल। ");
INSERT INTO new_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","अले वं छेँय् दुगु एसावया भिंगु भिंगु लं हयाः याकूबयात फिकल। ");
INSERT INTO new_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","याकूबया ल्‍हाः व गःपतय् सँ मदुथाय् भ्‍याःचिया छेंगू तिकाबिल। ");
INSERT INTO new_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","अले थःम्‍हं साक्‍क दय्‌कूगु ला व मरि याकूबया ल्‍हातिइ तयाबिल। ");
INSERT INTO new_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","याकूबं थः बौयाथाय् वनाः धाल, “बाः, जि वये धुन।” बौम्‍हं न्‍यन, “छ जिमि गुम्‍ह काय् खः?” ");
INSERT INTO new_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूबं धाल, “जि एसाव खः, छिम्‍ह दक्‍वसिबय् तःधीम्‍ह काय्। जिं छिं धाःथे यानाः हये धुन। दनाः ला भपियादिसँ। अले जितः आशिष बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाकं न्‍यन, “छं गय् यानाः थुलि याकनं लुइका, पुता?” याकूबं लिसः बिल, “छिकपिनि परमप्रभु परमेश्‍वरं जितः लुइकेत ग्‍वाहालि यानादिल।” ");
INSERT INTO new_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","इसहाकं याकूबयात धाल, “जिगु लिक्‍क वा, छन्‍त थियाः छ जिमि काय् एसाव खः ला कि मखु स्‍वये।” ");
INSERT INTO new_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","याकूब इसहाकया लिक्‍क वन। इसहाकं वयात थियाः धाल, “छंगु सः याकूबयागु थें च्‍वं। छंगु ल्‍हाः धाःसा एसावया थें च्‍वं।” ");
INSERT INTO new_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","याकूबया ल्‍हातिइ एसावया थें सँ दुगुलिं वं याकूबयात म्‍हसीके मफुत। वं आशिष बीत हाकनं छकः न्‍यन – ");
INSERT INTO new_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“छ धात्‍थें एसाव खः ला?” “खः” वं लिसः बिल। ");
INSERT INTO new_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","इसहाकं धाल, “जितः ला भचा हजि। जिं थ्‍व नये धुंकाः छन्‍त आशिष बी।” याकूबं हयाबिल। वं व नल। याकूबं दाखमद्य नं हयाबिल। वं व नं त्‍वन। ");
INSERT INTO new_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","अले इसहाकं धाल, “जिगु लिक्‍क वा, पुता, अले जितः चुप्‍पा न।” ");
INSERT INTO new_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","याकूबं चुप्‍पा नयाच्‍वंबलय् इसहाकं वयागु वसःया बास कयाः म्‍हसीकल, अले धाल – “जिमि काय्‌या वसःया बास, परमप्रभुं आशिष बियादीगु बँयागु बास थें च्‍वं। ");
INSERT INTO new_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्‍वरं छन्‍त आकाशं सुति गाय्‌काः बुँइ यक्‍व सय्‌काः आशिष बियादीमा। अले यक्‍व अन्‍न व दाखमद्य बियादीमा। ");
INSERT INTO new_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","थीथी जातिं छंगु सेवा यायेमा, मनूतय्‌सं छन्‍त भागि यायेमा, छं दाजुकिजाया छ मालिक जुइमा, छं किजापिन्‍सं छन्‍त भागि यायेमा, छन्‍त सराः बीपिं फुक्‍कसित सराः लायेमा, छन्‍त आशिष बीपिं फुक्‍कसिनं आशिष कायेमा।” ");
INSERT INTO new_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाकं आशिष बीधुंकाः अले याकूब अनं पिहां वने धुंकाः वया दाजु एसाव शिकारं लिहां वल। ");
INSERT INTO new_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","वं नं साक्‍क नसाज्‍वलं दय्‌कल, अले थः बौयाथाय् यंकाः धाल, “बाः, दनादिसँ, जिं शिकारं हयागु ला भपियादिसँ, अले जितः आशिष बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","इसहाकं न्‍यन, “छ सु?” वं लिसः बिल, “छिम्‍ह दक्‍वसिबय् तःधीम्‍ह काय् एसाव।” ");
INSERT INTO new_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","थ्‍व न्‍यनाः इसहाक तसकं खात। अले धाल, “अय्‌जूसा छ वये न्‍ह्यः शिकार यानाः जितः ला नकेहःम्‍ह सु लय्? जिं वयात आशिष बी धुन। आः व आशिष वयागु हे जुइ।” ");
INSERT INTO new_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","बौया थ्‍व खँ न्‍यनाः एसाव ततःसलं हालाः ख्‍वल, अले धाल, “बाः, जितः नं छिगु आशिष बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","इसहाकं धाल, “छिमि किजां जितः वयाः झंगः लात। वं छन्‍त बीगु आशिष लाकाः यंकल।” ");
INSERT INTO new_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","एसावं धाल, “वयागु नां याकूब तःगु पाय्‌छि हे जुल। वं निकः निकः जितः झंगः लाये धुंकल। वं जिगु तःधीम्‍ह काय्‌यागु अधिकार लाकाः काल, आः जिं कायेगु आशिष नं लाकाः यंकल। छिके आः जितः बीगु छुं हे आशिष ल्‍यं मन्‍त ला?” ");
INSERT INTO new_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाकं लिसः बिल, “जिं वयात छं मालिक यानाबी धुन। फुक्‍क किजापिन्‍त वया च्‍यः यानाबी धुन। जिं वयात फुक्‍क अन्‍न व दाखमद्य नं बी धुन। आः छन्‍त बीत जिके छुं हे मदये धुंकल, पुता।” ");
INSERT INTO new_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसावं हाकनं धाल, “छिके छगुलिं अप्‍वः मेगु आशिष मदु ला, बाः? जितः नं आशिष बियादिसँ।” अले व ततःसलं ख्‍वल। ");
INSERT INTO new_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","इसहाकं वयात धाल, “छ च्‍वनीगु बँ अन्‍न सयेगु पाखें व आकाशं गाइगु सुति लः पाखें तापाइ। ");
INSERT INTO new_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","छ थःगु तरवारया बलं म्‍वाना च्‍वनेमाली। छं थः किजाया सेवा यायेमाली। गुबलय् छ थ्‍व पाखें हीचाइ उबलय् छं थःगु गःपतं वयागु ककुसिँ लिकयाः वांछ्वइ।” ");
INSERT INTO new_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","थः बौनं याकूबयात आशिष ब्‍यूगुलिं एसाव व खनाः तंम्‍वल। अले मनमनं धाल, “जिमि बौ सीवं जिं वयात स्‍यानाबी।” ");
INSERT INTO new_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","रिबेकां एसावया थ्‍व ग्‍वसाः सीकाः थःकाय् याकूबयात सःताः धाल, “छिमि दाजुं छन्‍त स्‍यानाः बदला कायेगु बिचाः यानाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","उकिं जिं धयागु खँ न्‍यँ। छ याकनं हे हारानय् जिमि दाजु लाबानयाथाय् बिस्‍युं हुँ। ");
INSERT INTO new_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","अले छिमि दाजुया तं क्‍वमलाःतले अन हे च्‍वँ। ");
INSERT INTO new_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","छं याःगु खँ ल्‍वःमनाः छिमि दाजुया तं क्‍वलासेंलि जिं छन्‍त काय्‌के छ्वयाहये। छन्‍हुं हे जि छाय् छिपिं निम्‍हंलिसे बायाच्‍वनेगु?” ");
INSERT INTO new_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","अले रिबेकां इसहाकयात धाल, “थनच्‍वंपिं हित्ती मिसातय्‌सं यानाः जि हीमी चायेधुन। याकूबं नं हित्ती मिसा हे ब्‍याहा यात धाःसा ला जि सीसां जिल।” ");
INSERT INTO new_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","इसहाकं याकूबयात सःताः आशिष बियाः धाल, “छं सुं हे कनानी मिसालिसे ब्‍याहा याये मते। ");
INSERT INTO new_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","पद्दन-आरामय् छिमि मांया बौ बतूएलया छेँय् वनाः छिमि पाजु लाबानया म्‍ह्याय्‌पिं मध्‍ये छम्‍हय्‌सित ब्‍याहा या। ");
INSERT INTO new_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","दक्‍व शक्ति दुम्‍ह परमेश्‍वरं छन्‍त आशिष बीमा। अले छं यक्‍व सन्‍तान दयाः छंपाखें यक्‍व जाति दयेमा। ");
INSERT INTO new_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","परमेश्‍वरं छन्‍त व छिमि सन्‍तानयात अब्राहामयात ब्‍यूगु आशिष बियादीमा। अले परमेश्‍वरं अब्राहामयात बी धाःगु व झी आः च्‍वनाच्‍वनागु देश नं परमेश्‍वरं छन्‍त बियादीमा।” ");
INSERT INTO new_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","अले इसहाकं याकूबयात पद्दन-आरामय् एसाव व याकूबया मां रिबेकाया दाजु, अरामी बतूएलया काय् लाबानयाथाय् छ्वत। ");
INSERT INTO new_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","एसावं थः बौ इसहाकं याकूबयात आशिष बियाः सुं नं कनानी मिसायात ब्‍याहा याये मते धकाः भम्‍चा मालेत पद्दन-आरामय् छ्वःगु खँ सिल। ");
INSERT INTO new_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","वं याकूब थः मांबौया खँ न्‍यनाः पद्दन-आरामय् वंगु खँ नं सिल। ");
INSERT INTO new_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","अले वं थः बौ इसहाकयात कनानी मिस्‍त गुलि तक मयः धयागु खँ वाः चाय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","उकिं वं थः कका अब्राहामया काय् इश्‍माएलयाथाय् वनाः वया म्‍ह्याय्, नबायोतया क्‍यहेँ महलतयात थः कलाःपिं दय्‌क दय्‌कं ब्‍याहा याना हल। ");
INSERT INTO new_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","बेर्शेबा त्‍वःताः याकूब हारानपाखे वन। ");
INSERT INTO new_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","खिउँयावसेंलि व छथाय् बासं च्‍वनेत दित। व ल्‍वहंया फुंग तयाः अन हे ग्‍वारातुल। ");
INSERT INTO new_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","वं म्‍हगसय् स्‍वर्ग पृथ्‍वी छस्‍वागु छपु स्‍वाहानेय् परमेश्‍वरया दूतत थाहां क्‍वहां जुयाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","परमप्रभुं वया लिक्‍क वयाः धयादिल, “जि परमप्रभु खः, छं तापाःबाज्‍या अब्राहामया परमेश्‍वर, अले इसहाकया परमेश्‍वर। जिं छन्‍त व छिमि सन्‍तानयात छ च्‍वनाच्‍वंगु देश बी। ");
INSERT INTO new_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","छिमि सन्‍तान पृथ्‍वीया धू थें जुइ। इपिं पुर्ब व पच्‍छिम, उत्तर व दच्‍छिन न्‍यनावनी। पृथ्‍वीया फुक्‍क मनूतय्‌सं छ व छिमि सन्‍तानपाखें आशिष काइ। ");
INSERT INTO new_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","जि छलिसें दु। छ न्‍ह्याथाय् वंसां जिं छन्‍त स्‍वयाच्‍वने। अले जिं छन्‍त थन हे लित हये। जिं छन्‍त बाचा चिनागु ज्‍या पूमवंतले त्‍वःते मखु।” ");
INSERT INTO new_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","याकूबया न्‍ह्यलं चासेंलि वं बिचाः यात, “परमप्रभु थन हे दी, जिं सीके मफुत।” ");
INSERT INTO new_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","अले वं ग्‍यानाः धाल, “थ्‍व थाय् ला मेगु मखुसे परमेश्‍वरया छेँ हे जुइमाः। थ्‍व थाय् ला स्‍वर्गया लुखा जुइमाः।” ");
INSERT INTO new_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","सुथ न्‍हापां याकूबं दनाः थःम्‍हं छ्यं दिकाः द्यनागु ल्‍वहंयात लुमन्‍तिया चिं थें धंकल। अले उकी च्‍वंनिसें चिकं लुत। ");
INSERT INTO new_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","वं व थाय्‌या नां बेथेल तल। न्‍हापा व थाय्‌या नां लुजः खः। ");
INSERT INTO new_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","अले याकूबं थथे धयाः भाकल यात, “परमेश्‍वर जिलिसें दु धयागु खःसा, अले जितः जि वँवंथाय् बचय् यानादी, नके, त्‍वंके व पुंके यानादी धयागु खःसा, ");
INSERT INTO new_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","जि हाकनं जिमि बाःयाथाय् याउँक लिहां वने फत धाःसा परमप्रभु हे जिम्‍ह परमेश्‍वर जुइ। ");
INSERT INTO new_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","अले जिं धंकागु थ्‍व ल्‍वहं परमेश्‍वरया छेँ जुइ। अले वय्‌कलं बियादीगु न्‍ह्यागुं झिब्‍वय् छब्‍व वय्‌कःयात देछाये।” ");
INSERT INTO new_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","याकूब थःगु लँ लिनाः वन। व पुर्बया देशय् थ्‍यन। ");
INSERT INTO new_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","अन वं छथाय् छगः तुं खन। तुंया लिक्‍कसं स्‍वबथां फैत च्‍वनाच्‍वंगु दु। व फैचातय्‌त व हे तुंयागु लः त्‍वंकीगु जुयाच्‍वन। तुंया म्‍हुतु तीगु छगः तग्‍वःगु ल्‍वहं दु। ");
INSERT INTO new_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","फैत फुक्‍क अन मुंवयेधुंकाः फैजवाःतय्‌सं तुंया म्‍हुतुं ल्‍वहं चीकाः लः त्‍वंकीगु व अले हाकनं व ल्‍वहँतं तुंया म्‍हुतु तिनाबीगु जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकूबं फैजवाःतय्‌के न्‍यन, “पासापिं, छिपिं गनं वयागु?” इमिसं लिसः बिल, “जिपिं हारानं वयापिं खः।” ");
INSERT INTO new_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","वं इमित धाल, “छिमिसं नाहोरया छय् लाबानयात म्‍हस्‍यू ला?” इमिसं लिसः बिल, “स्‍यू, जिमिसं म्‍हस्‍यू।” ");
INSERT INTO new_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","याकूबं इमित हाकनं धाल, “वय्‌कः म्‍हं फु ला?” इमिसं धाल, “वय्‌कः म्‍हं हे फु। वय्‌कःया म्‍ह्याय् राहेल फैत ज्‍वयाः थन हे वइतिनि।” ");
INSERT INTO new_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","वं धाल, “छिपिं थन छाय् मुनाच्‍वनागु? निभाः बीगु ई मजूनि। फैत मुंकेगु ई नं मजूनि। उकिं लः त्‍वंकाः फैतय्‌त हाकनं ज्‍वयेयंकि।” ");
INSERT INTO new_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","इमिसं धाल, “फुक्‍क फैत ममुंकं अले तुंया म्‍हुतुं ल्‍वहं मचीकं जिमिसं अथे याये फइ मखु। अथे जुइ धुंकाः तिनि जिमिसं फैतय्‌त लः त्‍वंके फइ।” ");
INSERT INTO new_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","याकूब इपिं लिसे खँ ल्‍हाना च्‍वंबलय् हे राहेल थः बौया फैत ज्‍वयाः अन थ्‍यंकः वल। वया बौया फैत वं हे जइगु जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","याकूबं थः पाजु लाबानया म्‍ह्याय् राहेल व वया फैत खनेवं वनाः तुंया म्‍हुतुइ च्‍वंगु ल्‍वहं चीकाः थः पाजुया फैतय्‌त लः त्‍वंकल। ");
INSERT INTO new_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","अले वं राहेलयात चुप्‍पा नल, अले लय्‌तायाः मिखां ख्‍वबि हाय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","वं राहेलयात “जि छिमि बाःया थःलाःम्‍ह रिबेकाया काय् खः” धकाः कन। थ्‍व न्‍यनाः राहेलं ब्‍वाँय् वनाः थः बौयात धाल। ");
INSERT INTO new_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","थः भिंचा याकूबया थ्‍व खँ न्‍यनाः लाबान हथाय् पथासं ब्‍वाँय् वयाः नापलाः वल। वं याकूबयात घय्‌पुयाः चुप्‍पा नल। अले थःगु छेँय् हल। याकूबं जूगु फुक्‍क खँ कन। ");
INSERT INTO new_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","अले लाबानं धाल, “छ जिगु हे ला व हि खः।” याकूब वलिसे च्‍वंगु लच्‍छि दये धुंकाः छन्‍हु ");
INSERT INTO new_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","लाबानं वयात धाल, “छ जिमि थः लायेवं छं सितिकं जिगु ज्‍या यायेगु ला? छन्‍त गुलि ज्‍याला माः, धा।” ");
INSERT INTO new_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबानया निम्‍ह म्‍ह्याय्‌पिं दु। तःधीम्‍हय्‌सिगु नां लेआ व चीधीम्‍हय्‌सिगु नां राहेल खः। ");
INSERT INTO new_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआया बांलाक मिखां मछू। राहेल धाःसा बांलानाः स्‍वये जिउ। ");
INSERT INTO new_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकूबं राहेलयात यय्‌कल। उकिं धाल, “जिं छिम्‍ह चिधीम्‍ह म्‍ह्याय्‌या लागि न्‍हय्‌दँ तक छिगु ज्‍या याये।” ");
INSERT INTO new_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबानं धाल, “वयागु ब्‍याहा मेपिंलिसे यानाबीगु स्‍वयाः ला छन्‍त बीगु हे बांलाः। उकिं छ जिलिसें हे च्‍वँ। ");
INSERT INTO new_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","अले राहेलया निंतिं याकूबं न्‍हय्‌दँ तक अन हे ज्‍या यानाः च्‍वन। वं राहेलयात तसकं यय्‌कूगुलिं थ्‍व ई वयात चिहाकः थें ताल।” ");
INSERT INTO new_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","अले वं लाबानयात धाल, “जिगु ई पूवन। आः जितः छिकपिनि म्‍ह्याय् बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","लाबानं अन च्‍वंपिं फुक्‍क मनूतय्‌त सःताः भ्‍वय् नकल। ");
INSERT INTO new_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","बहनिइ धाःसा लाबानं थः म्‍ह्याय् लेआयात याकूबयाथाय् हयाबिल। याकूब वलिसें द्यन। ");
INSERT INTO new_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","लाबानं थः दासी जिल्‍पा थः म्‍ह्याय् लेआयात दासी कथं बिल। ");
INSERT INTO new_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","कन्‍हय् खुन्‍हु सुथय् याकूबं थःनापं लेआयात खन। अले वं लाबानयात धाल, “छिं जितः थथे छाय् यानादियागु? जिं राहेलया निंतिं छिथाय् ज्‍या यानागु, मखु ला? छिं जितः छाय् झंगः लानागु?” ");
INSERT INTO new_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबानं धाल, “जिमि तःधीम्‍ह म्‍ह्याय् ब्‍याहा मजुइकं चिधीम्‍ह म्‍ह्याय्‌या ब्‍याहा यायेगु चलन मदु। ");
INSERT INTO new_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","उकिं न्‍हय्‌न्‍हु तक लेआलिसे हनाच्‍वँ। अले हाकनं राहेललिसे ब्‍याहा या। थुकिया पलेसा छं मेगु न्‍हय्‌दँ जिथाय् ज्‍या यायेमाः।” ");
INSERT INTO new_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","वं अथे हे यात। न्‍हय्‌न्‍हु लिपा लाबानं थः म्‍ह्याय् राहेलयागु ब्‍याहा याकूब नाप यानाबिल। ");
INSERT INTO new_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","लाबानं थः दासी बिल्‍हा थः म्‍ह्याय् राहेलयात दासी कथं बिल। ");
INSERT INTO new_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","याकूबं राहेलयात नं ब्‍याहा यात। वं लेआयात स्‍वयाः अप्‍वः राहेलयात माया याः। अले वं मेगु न्‍हय्‌दँ तक लाबानयाथाय् ज्‍या यात। ");
INSERT INTO new_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","लेआयात माया मयाःगु खनाः परमप्रभुं वयात प्‍वाथय् दय्‌काबिल। राहेलयात धाःसा थारि हे याना तल। ");
INSERT INTO new_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लेआया प्‍वाथय् दत, अले वं काय् बुइकल। वं व मचायागु नां थथे मतिइ तयाः रूबेन तल, “परमप्रभुं धात्‍थें हे जिगु दुःख खनादीगु दु। आः ला जितः जिमि भाःतं माया याइ।” ");
INSERT INTO new_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","वया हाकनं प्‍वाथय् दत, अले हानं मेम्‍ह काय् बुल। वं धाल, “जितः माया मयाः धकाः सीकाः हे परमप्रभुं जितः थ्‍व काय्‌नं बियादीगु खः।” उकिं वं वयागु नां शिमियोन तल। ");
INSERT INTO new_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","वया हाकनं प्‍वाथय् दयाः काय् बुल। अले वं धाल, “थुगुसी ला जिमि भाःतं जितः स्‍वइ, छाय्‌धाःसा वय्‌कःया लागि जिं स्‍वम्‍ह काय् बुइकेधुन।” उकिं वं वयागु नां लेवी तल। ");
INSERT INTO new_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","वया हाकनं प्‍वाथय् दयाः काय् बुल। वं धाल, “थुगुसी ला जिं परमप्रभुयात तःधंके।” उकिं वयागु नां यहूदा तल। अनंलि वया मचाबुइगु दित। ");
INSERT INTO new_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","राहेलं याकूबयात मचा बुइकाबी मफुगुलिं वया थः ततालिसे नुगः मुल। अले वं याकूबयात धाल, “जितः नं मस्‍त दय्‌काब्‍यु। मखुसा जि सिनावने।” ");
INSERT INTO new_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","याकूब व खनाः तंम्‍वल, अले धाल, “जि परमेश्‍वर खः ला छन्‍त मचा दय्‌काबीत?” ");
INSERT INTO new_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","“जिम्‍ह दासी बिल्‍हा थन हे दु। वयापाखें मचा दय्‌कादिसँ। अले जि वयापाखें मां जुइ दइ।” ");
INSERT INTO new_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","उकिं राहेलं याकूबलिसे थः दासी बिल्‍हायागु ब्‍याहा यानाबिल। ");
INSERT INTO new_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","बिल्‍हाया प्‍वाथय् दयाः काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","अले राहेलं धाल, “परमेश्‍वरं जिगु पँ लिनादिल। वय्‌कलं जिगु प्रार्थना न्‍यनाः जितः काय् बियादिल।” उकिं वं वयागु नां दान तल। ");
INSERT INTO new_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेलया दासी बिल्‍हाया हाकनं प्‍वाथय् दयाः मेम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","अले राहेलं धाल, “जिं जिमि ततालिसे तसकं थाकुक ल्‍वानाः त्‍याकागु दु।” उकिं वं वयागु नां नप्‍ताली तल। ");
INSERT INTO new_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","थःपाखें मचाबुइगु द्यूगुलिं लेआं थः दासी जिल्‍पायात याकूबलिसे ब्‍याहा यानाबिल। ");
INSERT INTO new_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","लेआया दासी जिल्‍पाया पाखें काय् छम्‍ह बुल। ");
INSERT INTO new_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","लेआं धाल, “जि गुलि भाग्‍यमानी।” अले वं वयागु नां गाद तल। ");
INSERT INTO new_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","लेआया दासी जिल्‍पां याकूबयापाखें हाकनं मेम्‍ह काय् बुइकल। ");
INSERT INTO new_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","अले लेआं धाल, “जि गुलि सुखी। मिसातय्‌सं जितः सुखीम्‍ह धकाः धाइ।” उकिं वं वयागु नां आशेर तल। ");
INSERT INTO new_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","छ्व लयेगु इलय् छन्‍हु रूबेन बुँइ वन। वं अन विशाखमूल लुइकाः थः मां लेआयाथाय् हल। राहेलं लेआयात धाल, “जितः नं छिमि काय्‌नं हःगु विशाखमूल भचा ब्‍यु लय्?” ");
INSERT INTO new_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","लेआं वयात धाल, “जिमि भाःतयात जक कयां मगाः ला? जिमि काय्‌या विशाखमूल नं कायेमाल ला?” राहेलं धाल, “अय्‌सा छिमि काय्‌या विशाखमूलया पलेसा थौं वय्‌कः छलिसे द्यनी।” ");
INSERT INTO new_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","उखुन्‍हु याकूब सन्‍ध्‍याकाः इलय् बुं लिहां वःबलय् लेआं वनाः वयात धाल, “छि थौं जिलिसें द्यनेमाः। जिं छितः जिमि काय्‌या विशाखमूलमालिसे त्‍याय्‌कयागु दु।” उकिं याकूब उखुन्‍हु वलिसे हे द्यन। ");
INSERT INTO new_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","परमेश्‍वरं लेआयागु प्रार्थना न्‍यनादिल। अले वया प्‍वाथय् दयाः न्‍याम्‍हम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","लेआं धाल, “जिं जिमि भाःतयात थः दासी लःल्‍हाना बियागुलिं परमेश्‍वरं जितः सिरपाः बियादिल।” उकिं वं वयागु नां इस्‍साखार तल। ");
INSERT INTO new_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लेआया हानं प्‍वाथय् दयाः खुम्‍हम्‍ह काय् बुल। ");
INSERT INTO new_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","अले लेआं धाल, “परमेश्‍वरं जितः तःधंगु सिरपाः बियादीगु दु। आः जितः जिमि भाःतं हनाबना तइ, छाय्‌धाःसा जिं वय्‌कःयात खुम्‍ह काय् बुइकाबियागु दु।” उकिं वं वयागु नां जबूलून तल। ");
INSERT INTO new_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","छुं ई लिपा वं छम्‍ह म्‍ह्याय् बुइकल। वं वयागु नां दीना तल। ");
INSERT INTO new_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","अले परमेश्‍वरं राहेलयात लुमंकादिल। वयागु प्रार्थना न्‍यनाः वय्‌कलं वयात प्‍वाथय् दय्‌काबिल। ");
INSERT INTO new_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","वं काय् बुइकल। अले वं धाल, “परमेश्‍वरं जिगु बदनामी चीकादिल।” ");
INSERT INTO new_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","वं वयागु नां योसेफ तल। अले वं हाकनं, परमप्रभुं जितः मेम्‍ह काय् नं बियादीमा धकाः प्रार्थना यात। ");
INSERT INTO new_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","योसेफ बुइधुंकाः याकूबं लाबानयात धाल, “जितः वनेबियादिसँ। जि थःगु हे देशय् वने। ");
INSERT INTO new_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","जिं छिथाय् ज्‍या यानाः दुपिं जिमि कलाःपिं व मस्‍त जितः यंके बियादिसँ। जिं छिथाय् गुलि बांलाक ज्‍या यानाः छिं सि हे स्‍यू।” ");
INSERT INTO new_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","लाबानं वयात धाल, “छं जितः माया वं धयागु खःसा थन हे च्‍वँ। परमप्रभुं जितः छंगुपाखें आशिष बियादीगु दु धकाः जिं सीके धुन। ");
INSERT INTO new_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","छन्‍त गुलि ज्‍याला माः धा। जिं उलि हे बी।” ");
INSERT INTO new_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकूबं वयात धाल, “जिं थन गुकथं ज्‍या याना धकाः छिं सि हे स्‍यू, अले जिगु सुसाःकुसाः दयाः छिगु सा द्वहं व फै-च्‍वलय् नं गुलि यक्‍व दये धुंकल छिं सि हे स्‍यू। ");
INSERT INTO new_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","जि वये न्‍ह्यः छिके यक्‍व मदु। आः छिके यक्‍व दये धुंकल। जिं ल्‍हाः तःथाय् तक्‍क परमप्रभुं छितः आशिष बियादीगु दु। आः धाःसा जिं थःगु हे परिवारया लागि छुं व्‍यवस्‍था यायेमाः।” ");
INSERT INTO new_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","लाबानं धाल, “जिं छन्‍त छु बी लय्?” याकूबं धाल, “छिं जितः छुं नं बियादीम्‍वाः। छिं जितः छिगु पशुया बथांया सुसाःकुसाः यानाः ज्‍वय्‌केबियादिसँ। ");
INSERT INTO new_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","“थौं जितः छिगु पशुया बथां मध्‍ये च्‍याःथाःपिं च्‍वलय्‌चात व हाकुपिं भ्‍याःचात ल्‍यय्‌के बियादिसँ। व हे जिगु ज्‍याला जुइ। ");
INSERT INTO new_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","जि गुलि इमानजमान दुम्‍ह धकाः छिं लिपा नं सीकाकाये फइ। छिं जितः ज्‍याला ब्‍यूगु फैचात व च्‍वलय्‌चात स्‍वः झासँ, उकी छम्‍ह हे जक च्‍याःमथाःम्‍ह च्‍वलय् व हाकु मजूम्‍ह फैचा लुल धाःसा जिं खुयाहःगु जुइ।” ");
INSERT INTO new_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबानं धाल, “ज्‍यू। छं धाःथें हे जुइ।” ");
INSERT INTO new_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","तर लाबानं धाःसा उखुन्‍हु हे च्‍याःथाःपिं दुगु व च्‍वलय्‌चात अले हाकुपिं भ्‍याःचात धाक्‍व थःम्‍हं हे ल्‍ययाः थः काय्‌पिन्‍त बियाछ्वत। ");
INSERT INTO new_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","अले लाबानया काय्‌पिं याकूब च्‍वनाच्‍वंगु थासं स्‍वन्‍हु तापाःगु थासय् वन। लाबानया ल्‍यंदुपिं फैच्‍वलय्‌या बथां स्‍वयेगु ज्‍या याकूबं यात। ");
INSERT INTO new_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","याकूबं लहरे पीपल, मर्स्‍याबरां व स्‍यांगुलिमाया कचा ध्‍यनाः उकियात तुइक बाला चिंक फायाः ");
INSERT INTO new_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","फै व च्‍वलय्‌तय्‌सं लः त्‍वंवइबलय् खने दइकथं लः त्‍वनीगु थलय् तयाबीगु यात। छाय्‌धाःसा फैच्‍वलय्‌या बथां अन वयाः पासा थ्‍वःवइगु वं स्‍यू। ");
INSERT INTO new_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","कचाबालाया न्‍ह्यःने वयाः पासा थ्‍वःवःपिनि मचात च्‍याःथाःपिं जुयाः बुल। ");
INSERT INTO new_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","याकूबं फैचातय्‌त च्‍वलय्‌चात पाखें अलग तयाः इमित हाकुपिं व च्‍याःथाःपिं फै-च्‍वलय् चूलाइकथं तयाबिल। थुकथं वं थः फै-च्‍वलय् लाबानया फैच्‍वलय्‌लिसे ल्‍वाकमछ्यासे अलग्‍ग तयाः लहिनाः यक्‍व दय्‌कायंकल। ");
INSERT INTO new_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","स्‍वयेज्‍यूपिं व बल्‍लाःपिं फैच्‍वलय्‌या बथां पासा थ्‍वःवइबलय् वं कचा बालात इमिगु न्‍ह्यःने लः त्‍वनेगु थलया लिक्‍क तयाबीगु। ");
INSERT INTO new_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","बमलाःपिनिगु न्‍ह्यःने धाःसा अथे कचा बाला तया मब्‍यू। थुकथं बल्‍लाःपिं फै-च्‍वलय् धाक्‍व याकूबयागु जुल, अले बमलाःपिं फै-च्‍वलय् धाक्‍व लाबानया जुल। ");
INSERT INTO new_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","थथे याकूब तसकं तःमि जुल। वया यक्‍व फै-च्‍वलय्, दास-दासीत, ऊँट व गधा दत। ");
INSERT INTO new_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","याकूबं लाबानया काय्‌पिन्‍सं थथे धयाच्‍वंगु ताल, “याकूबं जिमि बाःयागु फुक्‍कं काये धुंकल। वं जिमि बाःयागु सम्‍पत्तिं हे थ्‍व फुक्‍क दय्‌कूगु खः।” ");
INSERT INTO new_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","वं लाबान न्‍हापा थें मजुइधुंकूगु नं वाः चाय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","उबलय् हे परमप्रभुं याकूबयात धयादिल, “छिमि बाः व थःथितिपिनिगु थासय् हे लिहां हुँ। जि छलिसें हे दइ।” ");
INSERT INTO new_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","उकिं वं राहेल व लेआयात थः पशुतय् बथां दुथाय् सःतके छ्वत। ");
INSERT INTO new_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","वं इमित धाल, “छिमि बाः आः न्‍हापा थें मजुइ धुंकल। अय्‌सां जिमि बाःया परमेश्‍वर धाःसा जिलिसें हे दी। ");
INSERT INTO new_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","जिं थःम्‍हं फु थे छिमि बाःयागु सेवा यानागु ला छिमिसं सि हे स्‍यू। ");
INSERT INTO new_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","अय्‌नं छिमि बाःनं जितः झंगः लानाः झिकः तक जिगु ज्‍याला हिलाब्‍यूगु दु। परमेश्‍वरं धाःसा जितः वयापाखें छुं कथं मभिंके मब्‍यू। ");
INSERT INTO new_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","छिमि बाःनं च्‍याःथाःपिं धाक्‍व छंगु ज्‍याला जुल धाल, फुक्‍क फैच्‍वलय्‌या बथांनं च्‍याःथाःपिं हे बुइकल। वं ध्‍वःथाःपिं धाक्‍व छंगु ज्‍याला जुल धाल, फुक्‍क फैच्‍वलय्‌या बथांनं ध्‍वःथाःपिं हे बुइकल। ");
INSERT INTO new_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","परमेश्‍वरं छिमि बाःया पाखें फुक्‍क फैच्‍वलय्‌या बथां लाकाकाल, अले जितः बियादिल। ");
INSERT INTO new_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“छकः जिं फैच्‍वलय्‌या पासा थ्‍वइगु इलय् म्‍हगसय् दुगुचातय्‌सं च्‍याःथाःपिं व ध्‍वःध्‍वःथाःपिं च्‍वलय्‌चात पासा थ्‍वयाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","परमेश्‍वरया दूतं जितः म्‍हगसय् धयादिल, ‘याकूब!’ जिं ‘हजुर’ धया। ");
INSERT INTO new_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“वय्‌कलं धयादिल, ‘स्‍व, पासा थ्‍वयाच्‍वंपिं फुक्‍क दुगुचात च्‍याःथाःपिं व ध्‍वःथाःपिं जक दु। छाय्‌धाःसा जिं लाबानं छन्‍त याःगु फुक्‍कं खनागु दु। ");
INSERT INTO new_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","छं ल्‍वहं धंकाः चिकं लुनाः पाःफय्‌कूगु थाय् बेथेलया परमेश्‍वर जि हे खः। आः थ्‍व थाय् त्‍वःताः छ थः बूगु थासय् लिहां हुँ।’” ");
INSERT INTO new_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","अले राहेल व लेआं धाल, “आः जिमि बाःया छेँय् जिमिगु छुं हे हक मदये धुंकल। ");
INSERT INTO new_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","वय्‌कलं जिमित मेपिन्‍त थें व्‍यवहार मयाः ला? वय्‌कलं जिमित म्‍यूगु जक मखु, जिमिगु लागि पूगु धिबा नं छ्यलाबिल। ");
INSERT INTO new_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","परमेश्‍वरं वय्‌कःया पाखें लाकाकाःगु फुक्‍क सम्‍पत्ति जिमिगु व जिमि मस्‍तय्‌गु खः। छिं परमेश्‍वरं धयादी थें यानादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","उकिं याकूबं थः मस्‍तय्‌त व कलाःपिन्‍त उँटय् गय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","अले थःम्‍हं पद्दन-आरामय् मुंकूगु फुक्‍क फैच्‍वलय्‌या बथां व सम्‍पत्ति ज्‍वनाः थः बौ इसहाकयाथाय् कनान देशय् वनेत पिहां वल। ");
INSERT INTO new_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","उबलय् लाबान फैतय्‌त सँ चाकःवनाच्‍वंगु खः। थः बौ मदुबलय् राहेलं थः बौया छेँय् च्‍वंगु मूर्तित खुयाहल। ");
INSERT INTO new_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","याकूबं अरामी लाबानयात थःछेँ त्‍वःतावनेगु खँ मकंसे झंगः लात। ");
INSERT INTO new_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","व थःम्‍हं मुंकूगु दक्‍वं ज्‍वनाः हथाय् पथासं अनं बिस्‍युं वन। अले यूफ्रेटिस खुसि छिनाः गिलाद पहाडपाखे वन। ");
INSERT INTO new_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","स्‍वन्‍हु लिपा लाबानं याकूब बिस्‍युं वंगु खँ सिल। ");
INSERT INTO new_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","अले वं थः थःथितिपिं ज्‍वनाः न्‍हय्‌न्‍हु तक याकूबयात माः वन, अले गिलादया पहाडय् वं वयात लुइकल। ");
INSERT INTO new_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","उखुन्‍हु हे चान्‍हय् परमेश्‍वरं म्‍हगसय् वयाः लाबानयात धयादिल, “होश या, छं याकूबयात छुं कथं ख्‍याये मते।” ");
INSERT INTO new_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","लाबानं याकूबयात लुइकूबलय् व गिलादया गुँइ पाल ग्‍वयाः च्‍वनाच्‍वंगु खः। लाबान व वया थःथितिपिन्‍सं नं अन हे थःपिनिगु पाल ग्‍वल। ");
INSERT INTO new_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","लाबानं याकूबयात धाल, “छं जितः झंगः लानाः जिमि म्‍ह्याय्‌पिन्‍त छाय् लडाइँलय् ज्‍वनाहःपिन्‍त थें हयागु? ");
INSERT INTO new_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","छं जितः छाय् छुं मधासे बिस्‍युं वयाः झंगः लानागु? छं जितः धाःगु जूसा जिं छन्‍त लय्‌तातां दम्‍फु व वीणा थाथां म्‍ये हालाः छ्वयाहयेगु खः नि। ");
INSERT INTO new_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","छं जितः जिमि छय्‌पिन्‍त माया यायेगु व म्‍ह्याय्‌पिन्‍त चुप्‍पा तक हे नके मबिल। छं मूर्ख ज्‍या यात। ");
INSERT INTO new_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","जिं छन्‍त स्‍यंके नं फु। तर म्‍हिगः चान्‍हय् छिमि बाःया परमेश्‍वरं जितः धयादिल, ‘होश या, छं याकूबयात छुं कथं ख्‍याये मते।’ ");
INSERT INTO new_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","जिं स्‍यू छ थः बौया छेँय् वनेत आय्‌बूगुलिं थथे पिहां वःगु खःसां छं छाय् जिगु छेँया मूर्तित खुयाहयागु?” ");
INSERT INTO new_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकूबं लाबानयात धाल, “छिं थः म्‍ह्याय्‌पिन्‍त जिपाखें लिगनायनी धकाः जि ग्‍यात। ");
INSERT INTO new_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","छिगु मूर्ति सुयाके दु, व मनू सी माली। छिं झी थःथितिपिनिगु न्‍ह्यःने थःगु छु छु जिके दु मालाः कयादिसँ।” याकूबं राहेलं मूर्ति खुयाहःगु खँ मस्‍यू। ");
INSERT INTO new_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","अले लाबान याकूब, लेआ, व निम्‍ह दासीपिनिगु पाल दुने दुहां वन। अन वं छुं लुइके मफुत। व लेआया पालं पिहां वयाः राहेलया पाल दुने वन। ");
INSERT INTO new_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल धाःसा छेँया मूर्तित ऊँटया फ्‍यतुसाय् तयाः थः उकी द्यःने फ्‍यतुनाच्‍वन। लाबानं पाल दुने गुलि मालं नं लुइके मफु। ");
INSERT INTO new_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेलं थः बौयात धाल, “जिमि प्रभु, जि खनाः तंम्‍वयादी मते, बाः। जि थीमज्‍यू जूगुलिं जि छिगु न्‍ह्यःने दने मछिं।” उकिं वं न्‍ह्याक्‍व माःसां छेँया मूर्ति लुइके मफुत। ");
INSERT INTO new_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","याकूब तंम्‍वल। अले वं लाबानयात हक्‍काः धाल, “जिं छु मभिंगु ज्‍या यानागु दु? जिं छु पाप यानागु दु धकाः छिं जितः थथे लिनादियागु? ");
INSERT INTO new_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","छिं जिगु फुक्‍क सामान स्‍वयादीधुंकल। छिं थःगु छेँया छु सामान लुइकादिया? व जिगु व छिकपिनि थःथितिया न्‍ह्यःने तयादिसँ। इमिसं हे छिगु व जिगु न्‍याय याइ। ");
INSERT INTO new_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“जि निइदँ तक छिलिसे च्‍वना। छिकपिनि छम्‍ह फै व च्‍वलय्‌चिया नं मत्‍यवं मचा कुहां वः धयागु मजू! न त जिं छिम्‍ह छम्‍ह हे फै-च्‍वलय् हे नया। ");
INSERT INTO new_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","जंगलया पशुतय्‌सं स्‍याःपिं फै-च्‍वलय् तकं जिं छिथाय् महसे थःम्‍हं हे उकिया मू पुलाबिया। न्‍हिनय् तंपिं जुइमा कि चान्‍हय् तंपिं जुइमा फुक्‍क फैच्‍वलय्‌या पलेसा नं छिं जिके कयादिल। ");
INSERT INTO new_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","“न्‍हिनय्‌सिया निभालं व चान्‍हय्‌सिया चिकुं जिगु म्‍ह गुलि न्‍यल। जिगु मिखाय् न्‍ह्यः धयागु हे मवः। ");
INSERT INTO new_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","निइदँ जि थुकथं छिगु छेँय् च्‍वना। जिं झिंप्‍यदँ छिकपिनि निम्‍ह म्‍ह्याय्‌पिनिगु लागि छिथाय् ज्‍या याना, अले खुदँ छिकपिनि फैच्‍वलय्‌या लागि ज्‍या याना। छिं जिगु ज्‍याला झिकः तक हिलादिल। ");
INSERT INTO new_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","अब्राहामया परमेश्‍वर गुम्‍हय्‌सिया न्‍ह्यःने जिमि बाः इसहाक ग्‍यानादी जिलिसें मदुगु जूसा छिं जितः धात्‍थें हे खालि ल्‍हातिं लिछ्वयाहइगु खः। परमेश्‍वरं जिगु दुःख व ज्‍या खनादिल, उकिं म्‍हिगः चान्‍हय् छितः ब्‍वःबियादिल।” ");
INSERT INTO new_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबानं याकूबयात धाल, “थुपिं मिस्‍त जिमि म्‍ह्याय्‌पिं खः, थुमि मस्‍त नं जिमि मस्‍त खः। अले थ्‍व फैबथां नं जिगु हे खः। थन गुलि नं छं खनाच्‍वन, व फुक्‍क जिगु हे खः। अय्‌नं जिं थौं थःम्‍ह्याय्‌पिं व इमि मस्‍तय्‌त छु याये फु धकाः? ");
INSERT INTO new_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","उकिं आः छंगु व जिगु दथुइ सन्‍धि याये वा। अले थुकिया लुमन्‍ति कथं झीसं थन ल्‍वहं थनाथके।” ");
INSERT INTO new_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","अले याकूबं ल्‍वहं हयाः थां थें धंकल। ");
INSERT INTO new_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","वं थः थःथितिपिन्‍त नं ल्‍वहं मुंकाहयेत धाल। इमिसं ल्‍वहं हयाः अन ल्‍वहं द्वँ दय्‌कल। अले अन हे इमिसं सन्‍धिया भ्‍वय् नल। ");
INSERT INTO new_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबानं उकियात यगर-सहदूता नां तल, याकूबं गलेद धकाः नां तल। ");
INSERT INTO new_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबानं धाल, “थौं थ्‍व ल्‍वहं द्वँ छंगु व जिगु दथुइ साक्षी जुयाः दनाच्‍वंगु दु।” उकिं थुकियागु नां गलेद च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","वं हानं धाल, “झी थःथवय् बायावनेधुंकाः नं परमेश्‍वरं झीत स्‍वयादीमा।” उकिं थ्‍व ल्‍वहं थांयात मिज्‍पा नं धाल। ");
INSERT INTO new_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","लाबानं हाकनं धाल, “छं जिमि म्‍ह्याय्‌पिन्‍त मभिंकल, अले मेपिं मिसात ब्‍याहा याना हल धाःसां झीगु दथुइ सुं मदुसां होश या, परमेश्‍वर छंगु व जिगु साक्षी दु।” ");
INSERT INTO new_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","वं धाल, “जिं थन छंगु व जिगु दथुइ ल्‍वहंया थां व ल्‍वहंया द्वँ तयागु दु। ");
INSERT INTO new_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","जिं थ्‍व ल्‍वहंया द्वँ व थां पुलाः छन्‍त स्‍यंकः वये मखु, अले छं थ्‍व ल्‍वहंया द्वँ व थां पुलाः जितः स्‍यंकः वइ मखु धयागुया साक्षी खः। ");
INSERT INTO new_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","जिमि बाज्‍या नाहोर व छिमि बाज्‍या अब्राहामया परमेश्‍वरं झी दथुइ न्‍याय यानादीमा।” उकिं याकूबं परमेश्‍वरयागु नामय्, गुम्‍ह खनाः वया बाः इसहाक ग्‍याइगु खः, ल्‍वहंया लागा मानय् याये धकाः पाफय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","याकूबं अन गुँच्‍वकाय् हे बलि बियाः थः थःथितिपिन्‍त भ्‍वय् नकल। नयेत्‍वने यानाः इपिं अन हे द्यन। ");
INSERT INTO new_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","कन्‍हय् खुन्‍हु सुथ न्‍हापां दनाः लाबानं थः छय्‌पिन्‍त व म्‍ह्याय्‌पिन्‍त चुप्‍पा नयाः आशिष बिल। अले व अनं बिदा कयाः थःगु छेँपाखे वन। ");
INSERT INTO new_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूब नं अनं थःगु लँ लिनाः वन। लँय् परमेश्‍वरया दूततय्‌सं वयात नापलात। ");
INSERT INTO new_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","याकूबं इमित खनाः धाल, “थ्‍व ला परमेश्‍वरयाथाय् खः!” उकिं वं व थाय्‌यागु नां महनोम तल। ");
INSERT INTO new_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकूबं एदोम देशया सेइर धाःगु थासय् थः दाजु एसावयाथाय् थः मनूत छ्वत। ");
INSERT INTO new_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","वं इमित धयाः छ्वत, “छिमिसं वनाः जिमि मालिक एसावयात थथे धा, ‘छिम्‍ह दास याकूबं थथे धयाहःगु दु, आः तक जि लाबानयाथाय् च्‍वनाच्‍वनागु खः। ");
INSERT INTO new_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","जिके सा, च्‍वलय्, गधा, फै व यक्‍व दास-दासीत दु। आः जितः छिं स्‍वइ ला धकाः धाय्‌के छ्वयाहयागु खः।’” ");
INSERT INTO new_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","वं छ्वःपिं मनूतय्‌सं लिहां वयाः वयात धाल, “जिपिं छिकपिनि दाजु एसावयाथाय् वनाः वया। वय्‌कः आः छितः नापलायेत प्‍यसः मनू ज्‍वनाः वयाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","याकूब तसकं ग्‍यात। वं थः मनूत, सा, फै, च्‍वलय्, गधा, ऊँट फुक्‍कसित निथ्‍वः यानाः ब्‍वथल। ");
INSERT INTO new_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“छुं जुयाः एसावं छपुचःयात हय्‌क्‍काःसां मेगु पुचः बिस्‍युं वने फयेमा” धकाः मतिइ तयाः वं थथे याःगु खः। ");
INSERT INTO new_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","अले याकूबं प्रार्थना यात, “जिमि तापाःबाज्‍या अब्राहाम व जिमि बाः इसहाकया परमेश्‍वर! परमप्रभु, छिं जितः थःगु हे छेँय् लिहां वनेत धयादिल। छिं जितः छि जिलिसें हे दइ, अले फुक्‍कं बांलाइ धकाः धयादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","छिं थः दासयात क्‍यनादीगु दया माया व विश्‍वासया निंतिं जि मल्‍वः। छाय्‌धाःसा यर्दन खुसि छिनाबलय् जिके कथि छपु जक दुगु खः, आः जिके मनूतय्‌गु व पशुतय्‌गु निगू ततःधंगु पुचः दु। ");
INSERT INTO new_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","आः जितः जिमि दाजु एसावपाखें बचय् यानादिसँ। वं जितः जक मखु जिमि कलाःपिन्‍त व मस्‍तय्‌त तकं हय्‌क्‍काः वइ धकाः जि ग्‍याः। ");
INSERT INTO new_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","छिं जितः धयादीगु दु, ‘जिं छन्‍त धात्‍थें हे भिंगु याये। अले छं सन्‍तान समुद्रया फि थें ल्‍याः खाये मफय्‌क यक्‍व दय्‌काबी।’” ");
INSERT INTO new_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","उखुन्‍हु चान्‍हय् व अन हे च्‍वन। वं थः दाजु एसावया लागि धकाः थःके दुगु सम्‍पत्तिं थुकथं ल्‍यल – ");
INSERT INTO new_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","निसःम्‍ह च्‍वलय्, निइम्‍ह दुगु, निसःम्‍ह फै, निइम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","स्‍विम्‍ह मांउँट् व इमि मचा, पिइम्‍ह सा, झिम्‍ह द्वहं, अले निइम्‍ह मांगधा व झिम्‍ह गधा। ");
INSERT INTO new_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","वं इमित थः दासतय्‌त जिम्‍मा बियाः धाल, “छिपिं जिगु न्‍ह्यः न्‍ह्यः हुँ। अले छथ्‍वः व मेगु थ्‍वया दथुइ थाय् पाकाः हुँ।” ");
INSERT INTO new_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","वं दक्‍वसिबय् न्‍ह्यःने वनीम्‍ह दासयात स्‍यन, “जिमि दाजु एसावं नापलानाः छन्‍त, ‘छ सुया मनू, गन वनेत्‍यनागु, छंगु न्‍ह्यः न्‍ह्यः वनाच्‍वंगु बथां सुयागु’ धकाः न्‍यन धाःसा ");
INSERT INTO new_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","छं थथे धकाः धा, ‘थ्‍व छिम्‍ह दास याकूबयागु खः। थ्‍व फुक्‍क वया मालिक एसावया लागि कोसेलि छ्वयाहःगु खः। व जिमिगु लिउने वयाच्‍वंगु दु।’” ");
INSERT INTO new_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","वं वयां ल्‍यू वनीम्‍ह निम्‍हम्‍ह व स्‍वम्‍हम्‍ह दासयात व बथांया ल्‍यूल्‍यू वनीपिं फुक्‍कसित नं अथे हे धकाः स्‍यन, “एसावयात नापलाइबलय् छिमिसं नं अथे हे धा।” ");
INSERT INTO new_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","थथे धायेगु धाःसा ल्‍वःमंके मते, “छिम्‍ह दास याकूब जिमिगु लिउने वयाच्‍वंगु दु।” थःगु न्‍ह्यःने न्‍ह्यःने छ्वःगु कोसेलिं वयागु तं क्‍वलाके फइ, अले थः वयागु न्‍ह्यःने वनेबलय् वं लसकुस यानाः काइ धकाः मतिइ तयाः वं अथे याःगु खः। ");
INSERT INTO new_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","थुकथं याकूबया कोसेलि न्‍हापा न्‍हापा वन। व थः धाःसा उखुन्‍हु चान्‍हय् पालय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","उखुन्‍हु हे चान्‍हय् याकूबं दनाः थः निम्‍हं कलाः, निम्‍ह दासी व झिंछम्‍ह काय्‌पिन्‍त यंकाः यब्‍बोक खुसि छिकल। ");
INSERT INTO new_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","वं इमित खुसि छिके धुंकाः थःम्‍हं ज्‍वनावःगु फुक्‍क सम्‍पत्ति नं छ्वत। ");
INSERT INTO new_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","थुकथं याकूब याकःचा जुल। उबलय् छम्‍ह मनू वयाः सुथ मजुतले वलिसे कुश्‍ती ल्‍वानाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","व मनुखं याकूबयात बुके मफुगुलिं याकूबया प्‍यंपाय् लाक दाल। उकिं यानाः वया प्‍यंपाया साहा ब्‍यन। ");
INSERT INTO new_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","व मनुखं धाल, “सुथ जुइन, आः जितः वनेब्‍यु।” याकूबं धाल, “जितः आशिष मब्‍युतले जिं छितः छ्वये मखु।” ");
INSERT INTO new_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","अले व मनुखं न्‍यन, “छंगु नां छु?” वं धाल, “याकूब।” ");
INSERT INTO new_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","व मनुखं धाल, “आवंलि छंगु नां याकूब मखु, इस्राएल जुल। छाय्‌धाःसा छं परमेश्‍वर व मनूतलिसे कुश्‍ती ल्‍वानाः त्‍याकल।” ");
INSERT INTO new_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","याकूबं धाल, “छिगु नां छु?” वं धाल, “जिगु नां छाय् न्‍यने माल?” अले वं वयात आशिष बिल। ");
INSERT INTO new_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","उकिं याकूबं व थाय्‌यागु नां पनीएल तल। छाय्‌धाःसा वं मतिइ तल, “परमेश्‍वरलिसे चुलिंचू लानाः नं जि म्‍वाना हे च्‍वना।” ");
INSERT INTO new_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","वयागु प्‍यंपाया साहा ब्‍यंगुलिं व खू काकां न्‍यासि वनाः पनीएल पुले धुंकाः सूर्य लुल। ");
INSERT INTO new_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","याकूबया प्‍यंपाय् घाःपाः लाःगुलिं इस्राएलया मनूतय्‌सं आः तक नं सुं नं पशुयागु प्‍यंपाया सँय्‌प्वाँच नःगु मदु। ");
INSERT INTO new_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकूबं एसाव प्‍यसःम्‍ह मनूलिसे वयाच्‍वंगु खन। अले वं थः मस्‍तय्‌त लेआ, राहेल व निम्‍ह दासीतय् जिम्‍मा बियाः इमित अलग अलग छ्वत। ");
INSERT INTO new_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","दक्‍वसिबय् न्‍ह्यःने निम्‍ह दासी व इमि मस्‍त छ्वत। अनंलि लेआ व वया मस्‍त छ्वत। राहेल व योसेफयात दक्‍वसिबय् लिपा छ्वत। ");
INSERT INTO new_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","याकूब थः धाःसा इपिं स्‍वयाः न्‍ह्यःने वन। व थः दाजुया न्‍ह्यःने मथ्‍यंतले न्‍हय्‌कः तक बँय् भ्‍वसुलाः वन। ");
INSERT INTO new_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","एसावं ब्‍वाँय् वयाः वयात घय्‌पुयाः चुप्‍पा नल। अले इपिं निम्‍हं ख्‍वल। ");
INSERT INTO new_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","एसावं मिस्‍त व मस्‍त खनाः न्‍यन, “छलिसे वःपिं थुपिं सु खः?” याकूबं धाल, “परमेश्‍वरं छिम्‍ह दासयात दयामाया यानाः ब्‍यूगु जिमि मस्‍त खः।” ");
INSERT INTO new_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","अले निम्‍ह दासी व इमि मस्‍तय्‌सं न्‍ह्यःने वयाः एसावयात भागि यात। ");
INSERT INTO new_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","अनंलि लेआ व वया मस्‍तय्‌सं वयाः भागि यात। दक्‍वसिबय् लिपा योसेफ व राहेलं वयाः भागि यात। ");
INSERT INTO new_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","एसावं याकूबयाके न्‍यन, “जिं लँय् नापलानागु बथां छु खः?” याकूबं धाल, “छिं जितः दुनुगलं लसकुस यानादीमा धकाः खः।” ");
INSERT INTO new_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","एसावं धाल, “जिगु थःगु हे यक्‍व दु, जि किजा! थुपिं फुक्‍क छं हे ति।” ");
INSERT INTO new_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूबं धाल, “मखु! छिं जितः माया यानादियागु खःसा थ्‍व कोसेलि लःल्‍हानाकयादिसँ। छिं जितः दुनुगलंनिसें लसकुस यानादीबलय् जितः ला छितः नापलाःगु परमेश्‍वरयात नापलानागु थें हे जुल। ");
INSERT INTO new_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","आः जिं छिगु लागि धकाः हयागु थ्‍व कोसेलि कयादिसँ। परमेश्‍वरं दया यानाः जितः माक्‍व बियादीगु दु।” थुकथं याकूबं एसावं मकातले कर यानाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","अले एसावं धाल, “आः वनाछ्वये नु, जि नं छनापं वने।” ");
INSERT INTO new_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","याकूबं धाल, “छिं सि हे स्‍यू, थ्‍व मस्‍त क्‍यातुसे हे च्‍वं नि। अले हानं जि थ्‍व दुरु त्‍वंपिं पशुया बथां नं बिचाः यायेमाः। थुमित न्‍हिच्‍छि न्‍यासिकल धाःसा थुपिं सी। ");
INSERT INTO new_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","उकिं छि न्‍हापा झासँ। जि बुलुहुं थ्‍व मस्‍त व सा द्वहं, फै-च्‍वलय् नापं छितः सेइरय् नाप लाये।” ");
INSERT INTO new_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसावं धाल, “अय्‌सा जिं जिमि मनूतय्‌त छलिसे त्‍वःताथके।” याकूबं धाल, “अथे छाय् याये माल? जितः छिगु माया जक दःसा गाः।” ");
INSERT INTO new_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","उकिं एसाव उखुन्‍हु हे सेइर लिहां वन। ");
INSERT INTO new_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याकूब धाःसा सुक्‍कोतपाखे वन। वं अन थःगु लागि छेँ छखा दन, अले पशुतय्‌गु निंतिं बल्‍चात दय्‌कल। उकिं व थाय्‌यागु नां सुक्‍कोत धाल। ");
INSERT INTO new_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","पद्दन-आरामं वयाः याकूब कनानया शकेम धाःगु शहरया लिक्‍क याउँक हे थ्‍यन। वं अन शहरं पिने थःगु पाल ग्‍वल। ");
INSERT INTO new_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","वं व थाय् शकेमया बौ हमोरया काय्‌पिन्‍के सच्‍छिकू वहः बियाः न्‍यानाकाल। ");
INSERT INTO new_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","वं अन छगू वेदी दय्‌कल। अले उकियात एल-एलोह-इस्राएल धकाः नां तल। ");
INSERT INTO new_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","छन्‍हु याकूब व लेआया म्‍ह्याय् दीना अन च्‍वंपिं मिसातय्‌त नापलाः वन। ");
INSERT INTO new_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","व थाय्‌या जुजु हिव्‍वी हमोरया काय् शकेमं वयात खन। अले वं वयात ज्‍वनायनाः स्‍यंकाबिल। ");
INSERT INTO new_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","याकूबया म्‍ह्याय् दीनायात वं तसकं यय्‌कल। उकिं वं वयागु नुगः साला कायेत कुतः यात। ");
INSERT INTO new_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","वं थः बौयात वलिसे ब्‍याहा यानाब्‍यु धकाः धाल। ");
INSERT INTO new_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","याकूबं थः म्‍ह्याय् दीनायात शकेमं स्‍यंकाब्‍यूगु खँ सिल। उबलय् वया काय्‌पिं फुक्‍कं फै ज्‍वःवनाच्‍वंगुलिं व सुम्‍क च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","उबलय् हे शकेमया बौ हमोर खँ ल्‍हायेत याकूबयाथाय् थ्‍यंकः वल। ");
INSERT INTO new_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","याकूबया काय्‌पिं नं जूगु खँ न्‍यनाः नुगः मछिंकाः तमं मि जुयाः छेँय् लिहां वल। छाय्‌धाःसा याकूबया म्‍ह्याय्‌यात स्‍यंकाः शकेमं याये मज्‍यूगु ज्‍या याःगु व इस्राएलयात हे बेइज्‍जत याःगु खः। ");
INSERT INTO new_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","हमोरं इमित थथे धकाः धाल, “जिमि काय् शकेमया नुगः छिकपिनि म्‍ह्याय्‌पाखे क्‍वसाःगुलिं वलिसे दीनायागु ब्‍याहा यानाबियादिसँ। ");
INSERT INTO new_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","झी आः थवंथवय् ब्‍याहाया कालबिल याये। छिकपिनि म्‍ह्याय्‌मस्‍त जिमित बियादिसँ, जिमि म्‍ह्याय्‌मस्‍त छिकपिन्‍सं यंकादिसँ। ");
INSERT INTO new_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","छिकपिं जिपिंलिसें हे च्‍वनादिसँ। थ्‍व थासय् छिकपिं च्‍वनादीफु, अले न्‍ह्याथाय् नं वनेफु। थन हे बनेज्‍या यानादिसँ, अले सम्‍पत्ति मुंकादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","अले शकेमं दीनाया बौ व दाजुपिन्‍त धाल, “छिकपिन्‍सं जितः दया यानादिसँ, छिकपिन्‍सं धाःगु जिं बी। ");
INSERT INTO new_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","भम्‍चाया मू व कोसेलि गुलि माः धयादिसँ, जिं छिकपिन्‍सं धाक्‍व बी। जितः छिकपिनि म्‍ह्याय्‌मचालिसे जक ब्‍याहा यानाबियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","शकेमं थः क्‍यहेँ दीनायात स्‍यंका ब्‍यूगुलिं याकूबया काय्‌पिन्‍सं शकेम व हमोरयात जाः ग्‍वयाः लिसः बिल। ");
INSERT INTO new_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","इमिसं इमित धाल, “म्‍हय् चिं मतःम्‍ह मनूयात जिमिसं थः क्‍यहेँ बी फइ मखु। थथे यात कि जिमिगु इज्‍जत वनी। ");
INSERT INTO new_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","उकिं छिकपिनि मिजंत फुक्‍कसिनं जिमिसं थें म्‍हय् चिं तयेगु ज्‍या यात धाःसा जक जिमिसं छिकपिन्‍सं धाःथे याये फइ। ");
INSERT INTO new_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","अले तिनि जक जिमि म्‍ह्याय्‌मस्‍त छिकपिन्‍सं यंके फइ, छिकपिनि म्‍ह्याय्‌मस्‍त जिमिसं काये फइ। अले जिमिसं छिकपिं नापं च्‍वनाः छगू हे जातियापिं थें जुयाः च्‍वने फइ। ");
INSERT INTO new_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","छिकपिन्‍सं म्‍हय् चिं तयेत माने जुयामदिल धाःसा जिपिं थः क्‍यहेँ ज्‍वनाः थनं वने।” ");
INSERT INTO new_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","हमोर व वया काय् शकेमयात इमिगु खँ यल। ");
INSERT INTO new_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","शकेम छेँजःपिं मध्‍ये दक्‍वसिबय् अप्‍वः हनातःम्‍ह मनू खः। व याकूबया म्‍ह्याय्‌या मतिनाय् लायेधुंकूगुलिं वं थ्‍व ज्‍या यायेत लिबाका मच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","उकिं हमोर व वया काय् शकेमं शहरया मू ध्‍वाखाय् वनाः शहरय् च्‍वंपिन्‍त धाल, ");
INSERT INTO new_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“थुपिं भिंपिं मनूत खः। थुमित थन हे तयाः बनेज्‍या याकेबी। थुमित च्‍वनेत झीथाय् थाय् नं यक्‍व दु। अले झीसं थुमि म्‍ह्याय्‌मस्‍त ब्‍याहा याये नं फइ, झी म्‍ह्याय्‌मस्‍त नं थुमित बी फइ। ");
INSERT INTO new_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","झीथाय् च्‍वंपिं फुक्‍क मिजंतय्‌सं इमि मिजंतय्‌सं थें म्‍हय् चिं तयेगु ज्‍या यात धाःसा जक इपिं झीपिंलिसे च्‍वनाः छगू हे जातियापिं थें जुयाः च्‍वने फइ हं। ");
INSERT INTO new_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","थथे जुल धाःसा इमिगु फुक्‍क सा, फै, सम्‍पत्ति झीगु मजुइ ला? उकिं झीसं इमिसं धाःगु खँ न्‍यने, अले इमित थन हे तये।” ");
INSERT INTO new_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","शहरय् च्‍वंपिं फुक्‍कसिनं हमोर व वया काय् शकेमं धाःगु खँ न्‍यन। अले मिजंत धाक्‍वसिनं म्‍हय् चिं तय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","स्‍वन्‍हु लिपा, म्‍हय् चिं तःगु स्‍याःगु हे मतंनिबलय् याकूबया निम्‍ह काय्‌पिं दीनाया दाजुपिं शिमियोन व लेवी थथःगु तरवार ज्‍वनाः सुनानं मसीक शहरय् दुहां वनाः फुक्‍क मिजंतय्‌त स्‍यानाबिल। ");
INSERT INTO new_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","इमिसं हमोर व वया काय् शकेमयात नं तरवारं पालाः स्‍यानाबिल। अले दीनायात शकेमया छेँनं लिगनाः यंकल। ");
INSERT INTO new_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","याकूबया मेपिं काय्‌पिन्‍सं वयाः शहरय् लुटे यात। थुकथं इमिसं थः केहेँयात बेइज्‍जत याःगुया बदला काल। ");
INSERT INTO new_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","इमिसं इमिगु फुक्‍क फै, सा, गधा, अले शहरय् दुने व पिने च्‍वंगु फुक्‍क वस्‍तु नं यंकल। ");
INSERT INTO new_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","इमिसं इमिगु फुक्‍क सम्‍पत्ति, मस्‍त, मिस्‍त व छेँय् च्‍वंगु फुक्‍क ज्‍वनाः वन। ");
INSERT INTO new_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","याकूबं शिमियोन व लेवीयात धाल, “छिमिसं जितः आपतय् लाकाबिल। आः जितः कनानी, परिज्‍जी व थनच्‍वंपिं फुक्‍कसिनं मही। झी ल्‍याखं आपाः मदु। इपिं फुक्‍क जानाः झीपिंलिसे ल्‍वाः वल धाःसा झीपिं फुक्‍कं सी।” ");
INSERT INTO new_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","इमिसं लिसलय् धाल, “वं जिमि केहेँयात वेश्‍यायात थें याये ज्‍यू ला लय्?” ");
INSERT INTO new_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","परमेश्‍वरं याकूबयात धयादिल, “दँ, बेथेलय् वनाः अन हे च्‍वँ। अले छ थः दाजु एसावलिसे ग्‍यानाः बिस्‍युं वंबलय् छन्‍थाय् खनेदय्‌कः वःम्‍ह परमेश्‍वरया लागि छगू वेदी दय्‌कि।” ");
INSERT INTO new_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","उकिं याकूबं थः छेँजःपिन्‍त व थःलिसे दुपिं सकसितं धाल, “छिपिंलिसे दुगु कर्पिनिगु मूर्तियात वांछ्वयाब्‍यु, अले थःपिन्‍त शुद्ध यानाः मेगु लं फ्‍यु। ");
INSERT INTO new_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","झी आः थ्‍व थाय् त्‍वःताः बेथेलय् वनेत्‍यना। अन जिं जितः आपतय् ग्‍वाहालि यानादीम्‍ह व जि न्‍ह्याथाय् वंसां जिलिसें दीम्‍ह परमेश्‍वरया लागि छगू वेदी दय्‌के।” ");
INSERT INTO new_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","अले फुक्‍कसिनं याकूबयात थःपिन्‍के दुगु फुक्‍क मूर्ति व न्‍हाय्‌पनय् च्‍वंगु तिसा बिल। वं व फुक्‍क शकेमया नापसं च्‍वंगु स्‍वंसिमा क्‍वय् थुनाबिल। ");
INSERT INTO new_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","इपिं अनं वँसेंलि परमेश्‍वरं इमिगु जवंखवं च्‍वंगु शहरयात ग्‍याःचिकुं भुनाबिल। अले सुनानं याकूब व वया मनूतय्‌त लीमफुत। ");
INSERT INTO new_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकूब थः मनूतलिसे कनान देशया लुजः धाःथाय् थ्‍यंकः वल। थौंकन्‍हय् थ्‍व थाय्‌यात बेथेल धाइ। ");
INSERT INTO new_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","वं अन छगू वेदी दय्‌कल। वं व थाय्‌यागु नां एल-बेथेल धकाः तल। छाय्‌धाःसा व थः दाजुलिसे ग्‍यानाः बिस्‍युं वःबलय् परमेश्‍वरं वयात अन हे झायाः नापलानादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","अन रिबेकाया तुतुमां दबोरा सित। वयात बेथेलया क्‍वसं च्‍वंगु छमा स्‍वसिमाया क्‍वय् थुनाबिल। उकिं व थाय्‌यागु नां अल्‍लोन-बकुत तल। ");
INSERT INTO new_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकूब पद्दन-आरामं वये धुंकाः परमेश्‍वरं हाकनं वयाथाय् खनेदय्‌कः झायाः वयात आशिष बियादिल। ");
INSERT INTO new_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","परमेश्‍वरं वयात धयादिल, “छंगु नां याकूब खः। आः थनिंनिसें छंगु नां याकूब मखु, इस्राएल जुइ।” थुकथं वय्‌कलं वयागु नां इस्राएल तयादिल। ");
INSERT INTO new_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","वय्‌कलं वयात हाकनं धयादिल, “जि दक्‍व शक्ति दुम्‍ह परमेश्‍वर खः। छं यक्‍व सन्‍तान दयेमा। छंगुपाखें यक्‍व जात जाति दयावइ। छंगुपाखें यक्‍व जुजुपिं नं दयावइ। ");
INSERT INTO new_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","जिं अब्राहाम व इसहाकयात बी धयागु देश छन्‍त बी, अले थ्‍व सदांया लागि छिमि सन्‍तानयागु जुइ।” ");
INSERT INTO new_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","अले परमेश्‍वर अनं झाल। ");
INSERT INTO new_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","याकूबं अन ल्‍वहं छगः धंकाः उकी दाखमद्य व चिकं लुनाबिल। ");
INSERT INTO new_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","अले वं परमेश्‍वरं वलिसे नवाःगु व थाय्‌यागु नां बेथेल तल। ");
INSERT INTO new_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","इपिं बेथेलं वन। एप्रात थ्‍यनी थें च्‍वंकाः राहेलयात मचाबुइ ब्‍यथा जुल। ");
INSERT INTO new_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","वयात तसकं ब्‍यथा जुयाच्‍वंबलय् दिरिअजिं वयात धाल, “ग्‍याये मते, हाकनं काय् हे बुल।” ");
INSERT INTO new_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","राहेलं थः सीगु सीकाः सी न्‍ह्यः वं मचायागु नां बेन-ओनी तल। बौम्‍हं धाःसा वयागु नां बेन्‍यामीन तयाबिल। ");
INSERT INTO new_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","राहेल सित। वयात एप्रात वनेगु लँसिथय् थुनाबिल। थ्‍व थाय्‌यात थौंकन्‍हय् बेथलेहेम धाइ। ");
INSERT INTO new_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","याकूबं वयात थुंगु थासय् ल्‍वहं छगः धंकाबिल। थ्‍व आः तकं राहेलयात थुंगु थां कथं दनि। ");
INSERT INTO new_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","व अनं वन। वं मिग्‍दल-एदेरया मेखेपाखे थःगु पाल ग्‍वल। ");
INSERT INTO new_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","याकूब अन हे च्‍वनाच्‍वंबलय् रूबेन थः बौया मथ्‍याःम्‍ह कलाः बिल्‍हालिसे द्यन। याकूबं थ्‍व खँ सिल। याकूबया झिंनिम्‍ह काय् दु – ");
INSERT INTO new_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","लेआया पाखें, दक्‍वसिबय् तःधीम्‍ह रूबेन, अले शिमियोन, लेवी, यहूदा, इस्‍साखार व जबूलून। ");
INSERT INTO new_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेलया पाखें, योसेफ व बेन्‍यामीन। ");
INSERT INTO new_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेलया दासी बिल्‍हापाखें, दान व नप्‍ताली। ");
INSERT INTO new_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लेआया दासी जिल्‍पापाखें – गाद व आशेर। थुपिं फुक्‍क याकूब पद्दन-आरामय् च्‍वनाच्‍वंबलय् हे बूपिं खः। ");
INSERT INTO new_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकूब मम्रेय् थः बौ इसहाकयाथाय् लिहां वल। थ्‍वयात किर्यत-अर्बा व हेब्रोन नं धाः। अब्राहाम व इसहाक पिनें वयाः थन हे च्‍वंगु खः। ");
INSERT INTO new_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाक १८० दँ दुबलय् सित। ");
INSERT INTO new_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","व तसकं बुरा जुयाः सित अले थः बौ तापाःबाज्‍यापिं नापं मिलय् जूवन। वयात वया काय्‌पिं एसाव व याकूबं थुन। ");
INSERT INTO new_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एदोम धाःम्‍ह एसावया सन्‍तानया खँ थथे दु – ");
INSERT INTO new_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावं कनानया मिसात हित्ती एलोनया म्‍ह्याय् आदा, हिव्‍वी सिबोनया छय् व अनाया म्‍ह्याय् ओहोलीबामा, ");
INSERT INTO new_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","अले इश्‍माएलया म्‍ह्याय् व नबायोतया क्‍यहेँ बासमतयात ब्‍याहा यात। ");
INSERT INTO new_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","आदाया पाखें एलीपज व बासमतया पाखें रुएल बुल। ");
INSERT INTO new_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","अले ओहोलीबामा पाखें येऊश, यालाम व कोरह बुल। थुपिं एसावया कनान देशय् बूपिं काय्‌पिं खः। ");
INSERT INTO new_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसाव थः कलाःपिं, काय्‌म्‍ह्याय्‌पिं व थःगु छेँया फुक्‍क छेँजःपिं, सा द्वहं, फै-च्‍वलय् व मेमेगु फुक्‍क वस्‍तु, अले कनान देशय् थःम्‍हं मुंकूगु फुक्‍क सम्‍पत्ति ज्‍वनाः थःकिजा याकूबलिसे अलग जुयाः मेगु देशय् वन। ");
INSERT INTO new_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","इमिके यक्‍व सा द्वहं, फै-च्‍वलय् व मेमेगु यक्‍व वस्‍तुत दुगुलिं ज्‍वयेत थाय् मगानाः इपिं नापं च्‍वने मफुत। ");
INSERT INTO new_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","उकिं एदोम धाःम्‍ह एसाव पहाडय् लाःगु सेइर देशय् वनाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","पहाडय् लाःगु सेइर देशय् च्‍वंपिं एदोमीतय् तापाःबाज्‍या एसावया सन्‍तानया खँ थथे दु – ");
INSERT INTO new_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसावया काय्‌पिं थुकथं दु – आदाया पाखें दुम्‍ह एलीपज, बासमतया पाखें दुम्‍ह रुएल। ");
INSERT INTO new_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीपजया काय्‌पिं तेमान, ओमार, सपो, गाताम व कनज। ");
INSERT INTO new_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसावया काय् एलीपजया तीम्‍न धाःम्‍ह मथ्‍याःम्‍ह कलाः दु। वयापाखें नं वया अमालेक नांयाम्‍ह काय् छम्‍ह दु। एसावया आदाया पाखें दुपिं छय्‌पिं थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएलया काय्‌पिं – नहत, जेरह, शम्‍मा व मिज्‍जा। एसावया बासमतया पाखें दुपिं छय्‌पिं थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","सिबोनया छय् व अनाया म्‍ह्याय् ओहोलीबामाया पाखें दुपिं एसावया काय्‌पिं थुकथं दु – येऊश, यालाम व कोरह। ");
INSERT INTO new_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसावया सन्‍तान मध्‍ये मू मूंपिं कुलया नायः थुपिं हे खः – एसावया तःधीम्‍ह काय् एलीपजया काय्‌पिं – तेमान, ओमार, सपो, कनज ");
INSERT INTO new_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम व अमालेक कुलया नायःत। एदोम देशय् एलीपजया पाखें नायः जूपिं थुपिं हे खः। थुपिं आदाया छय्‌पिं खः। ");
INSERT INTO new_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसावया काय् रूएलया काय्‌पिं – नहत, जेरह, शम्‍मा व मिज्‍जा कुलया नायःत। एदोम देशय् रूएलया पाखें नायः जूपिं थुपिं हे खः। थुपिं एसावया कलाः बासमतया पाखेंया छय्‌पिं खः। ");
INSERT INTO new_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसावया कलाः अनाया म्‍ह्याय् ओहोलीबामाया काय्‌पिं – येऊश, यालाम व कोरह कुलया नायःत। ");
INSERT INTO new_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","थुपिं फुक्‍क कुल व थुमि नायःत एसावया सन्‍तान खः। थुमित एदोमी धाइ। ");
INSERT INTO new_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","सेइर देशय् हे च्‍वंम्‍ह होरी सेइरया काय्‌पिं थुकथं दु – लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO new_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर व दीशान। सेइरया थुपिं काय्‌पिं एदोम देशया होरी नायःत खः। ");
INSERT INTO new_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतानया काय्‌पिं – होरी व हेमान। तीम्‍न लोतानया क्‍यहेँ खः। ");
INSERT INTO new_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबालया काय्‌पिं – अल्‍बान, मानहत, एबाल, शपो व ओनाम। ");
INSERT INTO new_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोनया काय्‌पिं – अय्‌या व अना। थ्‍व हे अनां थः बौ सिबोनया गधात जःवंबलय् मरुभूमिइ क्‍वाःगु लःया धाः लुइकूगु खः। ");
INSERT INTO new_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अनाया काय्‌म्‍ह्याय्‌पिं – काय् दीशोन व म्‍ह्याय् ओहोलीबामा। ");
INSERT INTO new_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोनया काय्‌पिं – हेमदान, एश्‍बान, यित्रान व करान। ");
INSERT INTO new_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेरया काय्‌पिं – बिल्‍हान, जावान व अकान। ");
INSERT INTO new_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशानया काय्‌पिं – ऊज व आरान। ");
INSERT INTO new_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरीतय् नायःत थुपिं हे खः – लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO new_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन, एसेर व दीशान। सेइर देशय् इमिगु खलकं होरी नायः जूपिं थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","इस्राएलय् जुजु दये न्‍ह्यः एदोम देशय् राज्‍य याःपिं जुजुपिं थुकथं दु – ");
INSERT INTO new_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बओरया काय् बेला एदोमया जुजु जूबलय् वयागु राजधानी दिन्‍हावा खः। ");
INSERT INTO new_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला सी धुंकाः वयागु थासय् बोज्राय् च्‍वंम्‍ह जेरहया काय् योबाब अनयाम्‍ह जुजु जुल। ");
INSERT INTO new_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब सी धुंकाः तेमानीतय्‌गु देशय् च्‍वंम्‍ह हूशाम अनयाम्‍ह जुजु जुल। ");
INSERT INTO new_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","हूशाम सी धुंकाः मोआबय् मिद्यानयात बुकूम्‍ह बददया काय् हदद अनयाम्‍ह जुजु जुल। वयागु राजधानी अवीत खः। ");
INSERT INTO new_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदद सी धुंकाः मास्रेकाय् च्‍वंम्‍ह सम्‍ला वयागु थासय् जुजु जुल। ");
INSERT INTO new_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","सम्‍ला सी धुंकाः खुसि सिथय् च्‍वंगु रहोबोत शहरयाम्‍ह शौल अनयाम्‍ह जुजु जुल। ");
INSERT INTO new_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शौल सी धुंकाः अक्‍बोरया काय् बाल-हानान अनयाम्‍ह जुजु जुल। ");
INSERT INTO new_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अक्‍बोरया काय् बाल-हानान सी धुंकाः हदद वयागु थासय् जुजु जुल। वयागु राजधानीया नां पाऊ खः। वया कलाः महेतबेल खः। व मत्रेदया म्‍ह्याय् व मे-जाहाबया छय् खः। ");
INSERT INTO new_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एदोमीतय् तापाःबाज्‍या एसावया सन्‍तानपाखें दुपिं कुलया नायःत थुकथं दु – तीम्‍न, अल्‍वा, यतेत, ");
INSERT INTO new_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा, एलाह, पीनोन, ");
INSERT INTO new_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज, तेमान, मिब्‍सार, ");
INSERT INTO new_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्‍दीएल व ईराम। थुपिं एदोम देशया थीथी थासय् च्‍वंपिं खः। एदोमीतय् तापाःबाज्‍या एसावया खँ थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब थः बौ च्‍वनाच्‍वंगु कनान देशय् हे च्‍वनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","याकूबया खँ थथे दु – योसेफ झिंन्‍हय्‌दँ दुबलय् थः दाजुपिं लिसें फै-च्‍वलय् ज्‍वःवनीगु खः, उपिं थः चिरिमांपिं बिल्‍हा व जिल्‍पाया काय्‌पिं खः। छन्‍हु वं थः दाजुपिनिगु मभिंगु बानी थः बौयात कं वल। ");
INSERT INTO new_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","बुरा जुइ धुंकाः बूम्‍ह जूगुलिं इस्राएलं मेपिं काय्‌पिन्‍त स्‍वयाः योसेफयात अप्‍वः माया याः। वं योसेफयात छपाः बांलाःगु बुत्ता दुगु भान्‍तां लं सुयाबिल। ");
INSERT INTO new_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","वया दाजुपिन्‍सं थः बौनं थःपिन्‍त स्‍वयाः अप्‍वः वयात मायायाःगुलिं वयात महिल। इमिसं वलिसे बांलाक न नं मवाः। ");
INSERT INTO new_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","छकः योसेफया म्‍हगसय् म्‍हन। वं थःम्‍हं म्‍हंगु खँ दाजुपिन्‍त कन। वया दाजुपिन्‍सं वयात झन महिल। ");
INSERT INTO new_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","वं थः दाजुपिन्‍त धाल – “जि म्‍हगसय् म्‍हंगु खँ न्‍यनादिसँ। ");
INSERT INTO new_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","झीपिं फुक्‍क बुँइ छ्वमा लयाः चिनाच्‍वनागु। जिगु छ्वमा धस्‍वानावल, अले छिकपिनिगु छ्वमा चाःतुलाः जिगु छ्वमायात भागि यात।” ");
INSERT INTO new_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","वया दाजुपिन्‍सं वयात धाल, “छ छु धात्‍थें हे जिमि जुजु जुइ धयागु ला? अले छं जिमित शासन यायेगु धयागु ला?” अनंलि इमिसं वयागु म्‍हगसय्‌या खं यानाः वयात अज्‍ज अप्‍वः महिल। ");
INSERT INTO new_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","वया हाकनं मेगु म्‍हगसय् म्‍हन। अले थः दाजुपिन्‍त कन, “स्‍व, जिं हाकनं मेगु म्‍हगसय् खना। सूर्य, तिमिला व झिंछगः नगुं जितः भागि यानाच्‍वंगु।” ");
INSERT INTO new_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","वं थः बौयात नं थ्‍व खँ कन। वया बौनं वयात तमं हक्‍काः धाल, “छं छु धायेत्‍यनागु? छु आः जि, छिमि मां व छिमि दाजुपिं वयाः छन्‍त भागि यायेमाल धयागु ला?” ");
INSERT INTO new_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","वया दाजुपिनि व खनाः नुगः मुल। वया बौया धाःसा थ्‍व खँ नुगलय् वालाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","छन्‍हु योसेफया दाजुपिं थः बौया फै ज्‍वयेत शकेम वनाच्‍वंबलय् ");
INSERT INTO new_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","इस्राएलं वयात धाल, “छं दाजुपिं शकेमय् फै ज्‍वःवनाच्‍वंगु दु। छ अन हुँ।” योसेफं धाल, “ज्‍यू, जि वने।” ");
INSERT INTO new_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","इस्राएलं धाल, “वनाः छं दाजुपिं व फैत छु यानाच्‍वन स्‍व, अले जितः कंवा।” अले वं वयात हेब्रोन बेँसीं शकेमय् छ्वत। योसेफ शकेमय् थ्‍यंबलय् ");
INSERT INTO new_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","छम्‍ह मनुखं वयात उखेंथुखें जुयाच्‍वंगु खनाः न्‍यन, “छं छु माला च्‍वनागु?” ");
INSERT INTO new_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","वं धाल, “जिं जिमि दाजुपिं माला च्‍वनागु। छिं स्‍यू ला इपिं गन फै ज्‍वयाच्‍वंगु?” ");
INSERT INTO new_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","व मनुखं धाल, “इपिं थनं वने धुंकल। जिं इमित दोतानपाखे वनेगु धकाः हालाच्‍वंगु तायागु खः।” योसेफ नं थः दाजुपिन्‍त मामां दोतानय् वन। वं अन इमित लुइकल। ");
INSERT INTO new_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","इमिसं वयात तापाकंनिसें खन। अले इमिसं वयात स्‍यायेगु ग्‍वसाः ग्‍वल। ");
INSERT INTO new_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","इमिसं थःथवय् खँ ल्‍हात, “वल का, म्‍हगसय् म्‍हंका जुइम्‍ह। ");
INSERT INTO new_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","वयात स्‍यानाः थन छगः तुंथिइ कुर्काथके। अले जंगली पशुं स्‍यानाः नल धाये। अले स्‍वये का वयागु म्‍हगस छु जुइ थें।” ");
INSERT INTO new_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","थ्‍व न्‍यनाः रूबेनं वयात इमिगु ल्‍हातिं बचय् यायेत स्‍वल। वं धाल, “स्‍याये हे ला मज्‍यू। ");
INSERT INTO new_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","हि हाय्‌केगु खँ ल्‍हाये मते। बरु वयात थन हे मरुभूमिइ लः मदुगु तुंथिइ कुर्काथके। ल्‍हाः छता वाये मते।” रूबेनं वयात इमिगु ल्‍हातिं बचय् यानाः लिपा थः बौयाथाय् यंकेगु मतिइ तयाः थथे धाःगु खः। ");
INSERT INTO new_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","योसेफ इमिथाय् थ्‍यनेवं इमिसं वयात ज्‍वनाः वं फिनातःगु तःजिगु भान्‍तां लं त्‍वकाः काल। ");
INSERT INTO new_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","अले वयात लः मदुगु तुंथिइ वांछ्वयाबिल। ");
INSERT INTO new_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","इपिं नयेत फ्‍यतूबलय् तापाक गिलादं वयाच्‍वंपिं इश्‍माएलीतय्‌त खन। इमिगु ऊँटं नस्‍वाः वःगु मसला, पाय्‌गु वासः व मूर्र क्‍वबियातःगु दु। इपिं मिश्रपाखे वनेत्‍यंपिं खः। ");
INSERT INTO new_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","अले यहूदां थः दाजुकिजापिन्‍त धाल, “झीसं थः किजायात स्‍यानाः अले वयागु हि त्‍वपुयां झीत छु दइ धकाः? ");
INSERT INTO new_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","बरु वयात इश्‍माएलीतय्‌गु ल्‍हातिइ मियाछ्वये। वयात ल्‍हाः धाःसा मवाये। न्‍ह्यागु जूसां व झी किजा खः, झीगु हे ला हि खः।” फुक्‍कसिनं वयागु खँ न्‍यन। ");
INSERT INTO new_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","उकिं इमिसं व व्‍यापारीत व लँ जुयाः थ्‍यंकः वसेंलि योसेफयात तुंथिं थकाल। अले वयात इमिगु ल्‍हातिइ निइकू वहलं मियाछ्वत। इमिसं वयात मिश्र यंकल। ");
INSERT INTO new_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","रूबेनं लिहां वयाः तुंथिइ स्‍वःबलय् योसेफयात अन मखनाः वं थःगु लं खुत। ");
INSERT INTO new_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","वं थः किजापिन्‍थाय् वनाः धाल, “मचा ला अन मदुनि। आः जिं छु यायेगु?” ");
INSERT INTO new_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","इमिसं छम्‍ह भ्‍याःचा स्‍यानाः वयागु हि योसेफया भान्‍तां लनय् बुलाबिल। ");
INSERT INTO new_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","अले इमिसं व भान्‍तां लं थः बौयाथाय् यंकाः धाल, “जिमिसं थ्‍व लुइका। थ्‍व छि काय्‌यागु खः ला कि मखु?” ");
INSERT INTO new_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","वं व लं म्‍हसीकल, अले धाल, “थ्‍व जिमि काय्‌यागु लं खः। जंगली पशुतय्‌सं वयात स्‍यानाः कुचा कुचा यानाः नल जुइमाः।” ");
INSERT INTO new_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","वं थःगु लं खुत। वं थःगु म्‍हय् भांग्रां भुन। व थः काय्‌या लागि थुकथं तःन्‍हु तक दुःखं च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","वया फुक्‍क काय् म्‍ह्याय्‌पिन्‍सं वयाः वयात ह्यय्‌केत स्‍वत, व मानय् मजू। वं धाल, “जि थः काय्‌या दुःखं च्‍वँच्‍वं हे जिमि काय्‌या थासय् वने।” थुकथं वं थः काय्‌या लागि तसकं नुगः मछिंकल। ");
INSERT INTO new_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","थ्‍व हे इलय् योसेफयात न्‍याना यंकूपिं व्‍यापारीतय्‌सं वयात फारोया दरबारया पिवाःतय् नायः पोतीफरया ल्‍हातिइ मियाबिल। ");
INSERT INTO new_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","उबलय् यहूदा थः दाजु-किजापिन्‍त त्‍वःताः क्‍वय् अदुल्‍लामय् च्‍वंम्‍ह हिरा नांयाम्‍ह छम्‍ह मनूयाथाय् च्‍वंवन। ");
INSERT INTO new_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","वं अन शूआ नांयाम्‍ह छम्‍ह कनानीया म्‍ह्याय्‌यात नापलात। वं व मिसायात ब्‍याहा यात। ");
INSERT INTO new_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","वया प्‍वाथय् दयाः काय् बुल। वयागु नां एर् तल। ");
INSERT INTO new_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","वया हानं प्‍वाथय् दयाः मेम्‍ह काय् बुल। वं वयागु नां ओनान तल। ");
INSERT INTO new_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","वं हाकनं मेम्‍ह काय् बुइकल। वयागु नां शेलह तल। वं वयात बुइकूबलय् यहूदा कजीबय् च्‍वनाच्‍वंगु खः। ");
INSERT INTO new_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदां दक्‍वसिबय् तःधीम्‍ह काय् एरया लागि कलाः छम्‍ह हयाबिल। वयागु नां तामार खः। ");
INSERT INTO new_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","यहूदाया तःधीम्‍ह काय् एर् धाःसा परमप्रभुया मिखाय् मभिंम्‍ह मनू खः। उकिं वय्‌कलं वयात स्‍यानादिल। ");
INSERT INTO new_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","अले यहूदां ओनानयात धाल, “छं छिमि तताःजुयात ब्‍याहा या। अले छम्‍ह किजाभतं यायेमाःगु ज्‍या पूवंकि। थुकथं थः दाजुया लागि सन्‍तान दय्‌कि।” ");
INSERT INTO new_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","उकथं दइम्‍ह मचा थः सन्‍तान मजुइगु जूगुलिं ओनानं न्‍ह्याबलें थः तताःजुलिसे द्योंवनिबलय् थः दाजुया सन्‍तान मदयेमा धकाः वीर्य बँय् लाकाथकीगु। ");
INSERT INTO new_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","वयागु थ्‍व ज्‍या परमप्रभुया मिखाय् मभिंगु जुल। उकिं वय्‌कलं वयात नं स्‍यानादिल। ");
INSERT INTO new_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","थः मेम्‍ह काय् शेलह नं वया दाजुपिं थें सी ला धकाः ग्‍यानाः यहूदां थः भौ तामारयात धाल, “जिमि काय् शेलह तःधि मजुतले छ ब्‍याहा मयासें थःछेँय् हे वनाः च्‍वंहुँ।” उकिं तामार थःछेँय् हे वनाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","वयां तःन्‍हु लिपा, छन्‍हु शूआया म्‍ह्याय् यहूदाया कलाः सित। दुःखं च्‍वने क्‍वचायेवं यहूदा अदुल्‍लामय् च्‍वंम्‍ह थः पासा हीरायात ब्‍वनाः तिम्‍नाय् थः फैतय्‌गु सँ चाःगु स्‍वःवन। ");
INSERT INTO new_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","तामारं थः ससःबौ फैतय् सँ चाकेत तिम्‍नाय् वनेत्‍यन धयागु खँ सीकाः ");
INSERT INTO new_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","विधवाया वसः त्‍वःताः थःत म्‍हमसीक गां ख्‍वाः त्‍वपुयाः तिम्‍ना वनेगु लँय् लाःगु एनैमया लँय् वनाः च्‍वंच्‍वन। छाय्‌धाःसा शेलह तःधि जुइ धुंकाः नं थः वया कलाः जुइ मखंनिगु वं स्‍यू। ");
INSERT INTO new_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","यहूदां वयात खनाः ख्‍वाः त्‍वपुयातःगुलिं वेश्‍या जुइ धकाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","वं व थः हे भौ धकाः म्‍हमस्‍यूगुलिं वयागु लिक्‍क वनाः थःनाप द्यनेत धाल। वं धाल, “छिं जितः छु बियादी?” ");
INSERT INTO new_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","यहूदां धाल, “जिं छन्‍त छम्‍ह फैचा बी।” वं धाल, “छिं व छ्वयामहतले न्‍ह्यागु सां छता दि तयाथका दिसँ।” ");
INSERT INTO new_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदां धाल, “छु बिया थके?” वं धाल, “छिगु गःपतय् च्‍वंगु चिं व उकियागु का, अले छिं ज्‍वनाच्‍वंगु कथि।” वं व फुक्‍क वयात बियाः व नाप द्यन। अले वया प्‍वाथय् दत। ");
INSERT INTO new_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","छेँय् लिहां वयाः तामारं हाकनं विधवाया वसः पुन। ");
INSERT INTO new_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","यहूदां अदुल्‍लामय् च्‍वंम्‍ह थः पासा हीरायात फैचा छम्‍ह बियाः थःम्‍हं मिसायात त्‍वःताथकूगु दि लित कयाः हति धकाः छ्वत। हीरां व मिसायात लुइके मफुत। ");
INSERT INTO new_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","वं एनैमय् च्‍वंपिं मनूतय्‌के, “एनैमया लँसिथय् च्‍वनीम्‍ह वेश्‍या गन दु?” धकाः न्‍यन। इमिसं, “थन सुं हे वेश्‍या मदु” धकाः धाल। ");
INSERT INTO new_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","हीरां लिहां वनाः यहूदायात धाल, “जिं व मिसायात लुइके मफुत। एनैमय् च्‍वंपिं मनूतय्‌सं अन सुं हे वेश्‍या मदु धकाः धाल।” ");
INSERT INTO new_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यहूदां धाल, “व सामान वयात हे तय्‌के ब्‍यु। मखुसा झीत तसकं मछालापुसे च्‍वनी। जिं थ्‍व फैचा छ्वयागु हे खः। छं वयात लुइके मफुत।” ");
INSERT INTO new_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","स्‍वला लिपा यहूदां थः भौ तामार वेश्‍या थें जुयाजूगु व प्‍वाथय् दुगु खँ न्‍यन। अले वं, “वयात थन हयाः च्‍याकाः स्‍यानाब्‍यु” धकाः धाल। ");
INSERT INTO new_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","थःत लुयाहयाच्‍वंबलय् तामारं थः ससःबौयाथाय् थथे धकाः खबर छ्वत, “थ्‍व सुयागु खः, वयापाखें हे जि प्‍वाथय् दुगु खः। थ्‍व चिं, थ्‍व का व थ्‍व कथि सुयागु खः, स्‍यू ला?” ");
INSERT INTO new_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","यहूदां व फुक्‍क थःगु हे खः धकाः धाल। अले वं धाल, “व ला जि स्‍वयाः नं धर्मी खनी। छाय्‌धाःसा जिं थःकाय् शेलह नाप वयागु ब्‍याहा यानाबी धकाः याना मबिया।” अनंलि व वलिसे हाकनं मद्यन। ");
INSERT INTO new_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","मचाबुइगु ई जुसेंलि वया प्‍वाथय् निम्‍ह मस्‍त दुगु खँ सीदत। ");
INSERT INTO new_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","मचाबू ई ब्‍यथा जुसेंलि छम्‍हसिनं ल्‍हाः पिछ्वयाहल। दिरिअजिं वयागु ल्‍हातिइ ह्याउँगु का चिनाः धाल, “थ्‍व न्‍हापां बूम्‍ह खः।” ");
INSERT INTO new_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","याकनं व ल्‍हाः दुहां वन। अले मेम्‍ह न्‍हापां बुल। दिरिअजिं धाल, “छ गथे यानाः न्‍हापां बुया?” उकिं वयागु नां फारेस तल। ");
INSERT INTO new_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ल्‍हातिइ ह्याउँगु का चिनातःम्‍ह लिपा बुल। वयागु नां जेरह तल। ");
INSERT INTO new_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","योसेफयात मिश्रय् यंकल। मिश्रया फारोया दरबारया पिवाःतय् नायः पोतीफरं वयात इश्‍माएलीतय्‌गु ल्‍हातिं न्‍यानाकाल। ");
INSERT INTO new_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","परमप्रभु योसेफलिसे दीगुलिं वं याक्‍व ज्‍या भिनावल। व थः मिश्री मालिकया छेँय् च्‍वनीगु खः। ");
INSERT INTO new_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","वया मालिकं परमप्रभु व नापं दीगु व वं याःगु न्‍ह्यागुं ज्‍या परमप्रभुं पूवंकादीगु खँ सीकल। ");
INSERT INTO new_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","उकिं व खनाः व लय्‌ताल। अले वं वयात थःगु छेँय् ज्‍या याइपिनि नायः यानाबिल। वं थःगु छेँया फुक्‍क जिम्‍मा नं वयात हे बिल। ");
INSERT INTO new_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","वं थःगु छेँया फुक्‍क जिम्‍मा वयात ब्‍युसांनिसें योसेफया हुनिं परमप्रभुं व मिश्रीया छेँय् आशिष बियादिल। परमप्रभुया आशिष वयागु छेँय् दुनेपिने न्‍ह्याथासं लात। ");
INSERT INTO new_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","उकिं वं फुक्‍कं योसेफया जिम्‍माय् त्‍वःताबिल। थःम्‍हं नयेगु त्‍वनेगुलिइ बाहेक वं आः छुकी हे च्‍यूताः मतल। योसेफ बांलानाः यइपुसे च्‍वं। ");
INSERT INTO new_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","छुं ई लिपा वया मालिकया कलातं मिखा तयाः वयात धाल, “जि नाप द्यं वा।” ");
INSERT INTO new_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","वं थ्‍व खँ मन्‍यं, अले धाल, “जि थ्‍व छेँय् दुगुलिं जिमि मालिकं छुं खँय् हे च्‍यूताः मतः, वय्‌कलं थःके दुगु फुक्‍क जिगु जिम्‍माय् त्‍वःतादीगु दु। ");
INSERT INTO new_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","थ्‍व छेँय् जि स्‍वयाः च्‍वय् सुं मदु। वय्‌कलं छि छम्‍ह बाहेक जितः फुक्‍क बियादीगु दु। छाय्‌धाःसा छि वय्‌कःया कलाः खः। उकिं जिं गथे यानाः थज्‍याःगु मभिंगु ज्‍या यानाः परमेश्‍वरया विरोधय् पाप याये फइ?” ");
INSERT INTO new_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","वं न्‍हियान्‍हिथं धाःसां योसेफ व नाप द्यनेत व नापं च्‍वनेत तकं मानय् मजू। ");
INSERT INTO new_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","छन्‍हु योसेफ थःगु ज्‍या यायेत छेँय् दुहां वन। उबलय् छेँय् ज्‍या याइपिं छम्‍ह हे मदु। ");
INSERT INTO new_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","वं योसेफयागु गा ज्‍वनाः धाल, “जि नाप द्यँ।” योसेफ थःगु गा वयागु ल्‍हातिइ हे त्‍वःताः अनं बिस्‍युं वन। ");
INSERT INTO new_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","योसेफ थःगु गा वयागु हे ल्‍हातिइ त्‍वःताः बिस्‍युं वंगु खनाः ");
INSERT INTO new_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","वं छेँय् ज्‍या याइपिन्‍त सःताः धाल, “स्‍व, व हिब्रूयात ला थन झीत बेइज्‍जत याकेत धकाः हःगु जुयाच्‍वन। व जिलिसें द्यनेत थन दुहां वल। जि तसकं हालाबिया। ");
INSERT INTO new_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","जि तसकं हालागुलिं व थःगु गा थन हे त्‍वःताः बिस्‍युं वन।” ");
INSERT INTO new_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","वं थः भाःत छेँय् दुहां मवतले व गा थःम्‍हं हे कयातल। ");
INSERT INTO new_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","भाःतम्‍ह दुहां वयेवं वं व हे खँ वयात कन, “छिं हयादीम्‍ह व हिब्रू च्‍यः जितः बेइज्‍जत यायेत थन दुहां वल। ");
INSERT INTO new_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","जि तसकं हालाबिसेंलि व थःगु गा त्‍वःताः बिस्‍युं वन।” ");
INSERT INTO new_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“छिम्‍ह च्‍यलं थथे यात” धकाः कलाःया पाखें थथे न्‍यँसेंलि योसेफया मालिक तमं मि जुल। ");
INSERT INTO new_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","वं योसेफयात ज्‍वंकाः फारोया कैदीत कुनीगु झ्‍यालखानाय् कुंकेबिल। योसेफ झ्‍यालखानाय् लाःबलय् नं ");
INSERT INTO new_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","परमप्रभु व नाप हे दी। वय्‌कलं वयात दया यानाः झ्‍यालखानाया हाकिमयात वयात माया याइम्‍ह यानादिल। ");
INSERT INTO new_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","उकिं वं योसेफयात अन कुना तःपिं फुक्‍कसिया नायः यानाबिल। अले अन न्‍ह्यागु यायेमाःसां योसेफयागु जिम्‍माय् त्‍वःताबिल। ");
INSERT INTO new_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","योसेफया जिम्‍माय् लाःगु छुं ज्‍याय् हे वं च्‍यूताः मकाल। छाय्‌धाःसा परमप्रभु योसेफ नाप दी। अले वं याःगु न्‍ह्यागुं ज्‍या पूवंकादी। ");
INSERT INTO new_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","छुं ई लिपा फारोया दाखमद्य त्‍वंकीम्‍ह नायः व मरि छुइम्‍ह नायलं थः मालिकया विरोधय् मभिंगु ज्‍या यात। ");
INSERT INTO new_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","फारो इपिं निम्‍ह खनाः तसकं तंम्‍वल। ");
INSERT INTO new_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","अले वं इमित पिवाःतय् कप्‍तानया छेँय् दुगु झ्‍यालखानाय् कुनाबिल। योसेफयात नं अन हे कुनातःगु खः। ");
INSERT INTO new_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","पिवाःतय् कप्‍तानं इमित योसेफया जिम्‍माय् तयाबिल। छुं ई लिपा झ्‍यालखानाय् च्‍वना च्‍वंबलय् हे ");
INSERT INTO new_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","इपिं निम्‍हय्‌सिनं नं थीथी अर्थ दुगु म्‍हगस खन। ");
INSERT INTO new_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","सुथय् योसेफ अन वःबलय् इपिं भुगुलुं च्‍वनाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","उकिं वं इमिके न्‍यन, “थौं छिकपिं छाय् भुगुलुं च्‍वनाच्‍वनागु?” ");
INSERT INTO new_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","इमिसं धाल, “जिपिं निम्‍हय्‌सिनं नं म्‍हगसय् खना। उकिया अर्थ कनिपिं धाःसा थन सुं हे मदु।” अले योसेफं इमित धाल, “फुक्‍क म्‍हगसया अर्थ परमेश्‍वरयाके मदु ला? जितः छिकपिनिगु म्‍हगसया खँ कनादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","अले दाखमद्य त्‍वंकीपिनि नायलं थःगु म्‍हगसया खँ योसेफयात थुकथं कन, “जिं म्‍हगसय् जिगु न्‍ह्यःने दाखमा छमा खना। ");
INSERT INTO new_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","व दाखमाय् स्‍वकचा दु। उकी बुँ ह्वयेवं स्‍वां नं ह्वयावल, अले ज्‍वाँय्‌ज्‍वाँय् दाख सयाः पाकय् नं जुल। ");
INSERT INTO new_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","जिगु ल्‍हातिइ फारोया ख्‍वला दु, जिं दाख तिस्‍सिनाः व ख्‍वलाय् तयाः फारोयाथाय् यंकाः बिया।” ");
INSERT INTO new_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","योसेफं वयात धाल, “छिं म्‍हगसय् खंगु स्‍वकचाया अर्थ स्‍वन्‍हु खः। ");
INSERT INTO new_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","स्‍वन्‍हुया दुने हे फारों छितः छिगु ज्‍या लित बियाः छिगु छ्यं धस्‍वाकाबी। अले न्‍हापा याना थें छिं फारोया ख्‍वला वय्‌कःया ल्‍हातिइ तयादी खनी। ");
INSERT INTO new_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","छिगु भिं जुइ धुंकाः धाःसा छिं जितः लुमंकादिसँ। फारोयात जिगु खँ बिन्‍ति यानाः जितः थ्‍व झ्‍यालखानां पिकयादिसँ। ");
INSERT INTO new_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","छाय्‌धाःसा धात्‍थें धायेमाल धाःसा जितः हिब्रूतय्‌गु देशं खुयाहःगु खः। अले जिं थन झ्‍यालखानाय् लाइगु ज्‍या नं छुं यानागु मदु।” ");
INSERT INTO new_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","योसेफं म्‍हगसया अर्थ भिंगु कथं कंगुलिं मरि छुइम्‍ह नायलं नं वयात धाल, “जिं नं म्‍हगस छगू खनागु दु। म्‍हगसय् जिं मरि दुगु स्‍वंगः धकि छेनय् क्‍वबिया तयागु दु। ");
INSERT INTO new_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","दक्‍वसिबय् च्‍वय्‌यागु धकिइ फारोया लागि थीथी कथंया मरिचरि दु। झंगःपंक्षीतय्‌सं वयाः जिगु छ्यं च्‍वय्‌च्‍वंगु धकिइ मरि नयाच्‍वन।” ");
INSERT INTO new_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","योसेफं धाल, “थुकिया अर्थ खः, ‘स्‍वंगः धकि धयागु स्‍वन्‍हु खः। ");
INSERT INTO new_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","स्‍वन्‍हुया दुने हे फारों छिगु छ्यं ध्‍यनाबी, अले छितः थामय् यख्‍खाइ। झंगःपंक्षीतय्‌सं छिगु ला त्‍वाथं क्‍वात्तु क्‍वानाः नइ।’” ");
INSERT INTO new_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","स्‍वन्‍हु खुन्‍हु फारो बूगु दिं खः। उखुन्‍हु थःथाय् ज्‍या याइपिं फुक्‍क हाकिमतय्‌त भ्‍वय् सःतल। उपिं फुक्‍कसिया न्‍ह्यःने वं दाखमद्य त्‍वंकीम्‍ह नायः व मरि छुइम्‍ह नायःयात थने हल। ");
INSERT INTO new_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","दाखमद्य त्‍वंकीम्‍ह नायःयात वयागु ज्‍याय् हाकनं तल, ");
INSERT INTO new_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","मरि छुइम्‍ह नायःयात धाःसा यख्‍खानाः स्‍यात। थ्‍व फुक्‍क योसेफं धाःथें जुल। ");
INSERT INTO new_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","दाखमद्य त्‍वंकीम्‍ह नायलं धाःसा योसेफयात लुममंकू। वं वयात ल्‍वःमंकल। ");
INSERT INTO new_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","निदँ लिपा फारों छगू म्‍हगस खन। म्‍हगसय् व नील खुसिया सिथय् दनाच्‍वंगु। ");
INSERT INTO new_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","खुसिं न्‍हय्‌म्‍ह तसकं स्‍वय्‌ज्‍यूपिं व ल्‍ह्वंपिं सा पिहां वयाः तिंकथिया घाँय् नः वन। ");
INSERT INTO new_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","अनं लिपा मेपिं न्‍हय्‌म्‍ह बांमलाःपिं व क्‍वँय् खनेदुपिं गंसिपिं सा पिहां वयाः न्‍हापायापिं लिसें दंवन। ");
INSERT INTO new_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","अले छेंगू व क्‍वँय् जक दुपिं गंसिपिं सातय्‌सं ल्‍ह्वंपिं सातय्‌त नयाबिल। उबलय् हे फारोया न्‍ह्यलं चाल। ");
INSERT INTO new_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","व हाकनं द्यन, अले मेगु म्‍हगस खन। वं म्‍हगसय् छगू हे दंलय् बांलाःगु व दुकुलुगु अन्‍नया न्‍हय्‌गुँइँ सयाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","अनंलि वं सालुसे च्‍वंगु व पुर्बया फसं झ्‍वाः जूगु अन्‍नया न्‍हय्‌गुँइँ लुयावःगु खन। ");
INSERT INTO new_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","अले व सालुसे च्‍वंगु अन्‍नया न्‍हय्‌गुँइँ दुकुलुगु अन्‍नया न्‍हय्‌गुँइँयात नुनाछ्वत। अले फारोया न्‍ह्यलं चाल। वं थ्‍व म्‍हगसय् म्‍हंगु धकाः सिल। ");
INSERT INTO new_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","कन्‍हय् खुन्‍हु सुथय् फारोया मन मच्‍वनाः देशय् दक्‍व ज्‍योतिषतय्‌त व सःस्‍यूपिन्‍त सःतके छ्वत। वं इमित थःम्‍हं म्‍हगसय् खंगु खँ कन। इपिं सुनानं फारोया म्‍हगसया अर्थ धाःसा कने मफुत। ");
INSERT INTO new_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","अबलय् हे दाखमद्य त्‍वंकीम्‍ह नायलं धाल, “थौं जिं थःम्‍हं द्वंकागु खँ लुमन।” ");
INSERT INTO new_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","वं फारोयात धाल, “छकः महाराजं जि व मूम्‍ह मरि छुइम्‍हलिसे तंम्‍वयाः जिमित झ्‍यालखानाय् कुनाबिल। ");
INSERT INTO new_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","अबलय् अन जिपिं निम्‍हय्‌सिनं नं छन्‍हु हे चान्‍हय् थीथी अर्थ दुगु म्‍हगसय् खना। ");
INSERT INTO new_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","अन झ्‍यालखानाया हाकिमया छम्‍ह ल्‍याय्‌म्‍हम्‍ह हिब्रू च्‍यः नं जिपिंनापं दुगु खः। जिमिसं वयात थःपिनिगु म्‍हगसया खँ कना। वं जिपिं निम्‍हय्‌सिगुं म्‍हगसया अर्थ कनाबिल। ");
INSERT INTO new_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","अले वं गथे धाल अथे हे जुल। जि थःगु ज्‍याय् हाकनं लिहां वया, अले मरि छुइम्‍हय्‌सित यख्‍खाल।” ");
INSERT INTO new_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","थ्‍व न्‍यनाः फारों याकनं योसेफयात काय्‌के छ्वत। वयात झ्‍यालखानां पितहल। अले व सँ व दाह्रि खानाः मेगु वसः फिनाः फारोया न्‍ह्यःने दं वल। ");
INSERT INTO new_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फारों वयात धाल, “जिं छगू म्‍हगस खना। उकियागु अर्थ सुनानं कने मफुत। छं म्‍हगसयागु अर्थ कनेफु धकाः जिं न्‍यना।” ");
INSERT INTO new_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","योसेफं धाल, “महाराज! जि थःम्‍हं ला अथे याये मफु। परमेश्‍वरं धाःसा महाराजयात मनंतुंगु लिसः बियादी।” ");
INSERT INTO new_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","फारों योसेफयात धाल, “जिं म्‍हगसय् जि नील खुसिया सिथय् दनाच्‍वनागु खना। ");
INSERT INTO new_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","अले न्‍हय्‌म्‍ह स्‍वय्‌ज्‍यूपिं व ल्‍ह्वंपिं सा खुसिं पिहां वयाः तिंकथिया घाँय् नः वन। ");
INSERT INTO new_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","अनंलि न्‍हय्‌म्‍ह छेंगू व क्‍वँय् जक दुपिं गंसिपिं सा खुसिं पिहां वल। जिं अज्‍याःपिं सा मिश्रय् गुबलें हे मखनानि। ");
INSERT INTO new_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","व क्‍वँय् खनेदुपिं गंसिपिं सातय्‌सं न्‍हापायापिं स्‍वयेज्‍यूपिं व ल्‍ह्वंपिं सातय्‌त नयाबिल। ");
INSERT INTO new_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","इमिसं अथे नःसां इमिसं नःगु धकाः सुनानं धाये फइ मखु। छाय्‌धाःसा इपिं न्‍हापा गथे अथे हे गंसिया गंसि तुं। अबलय् हे जि न्‍ह्यलं चाल। ");
INSERT INTO new_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“जिं हाकनं मेगु म्‍हगसय् छगू हे दंलय् बांलाःगु व दुकुलुगु अन्‍नया न्‍हय्‌गुँइँ सयाच्‍वंगु खना। ");
INSERT INTO new_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","अले हानं सालुसे च्‍वंगु व पुर्बया फसं झ्‍वाः जूगु अन्‍नया न्‍हय्‌गुँइँ सल। ");
INSERT INTO new_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","व सालुगु व झ्‍वाः जूगु अन्‍नया न्‍हय्‌गुँइँनं बांलाःगु अन्‍नया न्‍हय्‌गुँइँयात नुनाछ्वत। जिं थ्‍व फुक्‍क ज्‍योतिषतय्‌त कना। सुनानं हे थुकिया अर्थ कने मफुत।” ");
INSERT INTO new_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","योसेफं फारोयात धाल, “महाराजया निगू म्‍हगसयागु नं अर्थ छगू हे खः। परमेश्‍वरं थःम्‍हं यायेत्‍यनागु खँ महाराजयात क्‍यनादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","न्‍हय्‌म्‍ह स्‍वयेज्‍यूपिं साया अर्थ न्‍हय्‌दँ खः, अले बांलाःगु अन्‍नया न्‍हय्‌गुँइँया अर्थ नं न्‍हय्‌दँ हे खः। निगुलिं म्‍हगसया अर्थ व हे खः। ");
INSERT INTO new_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","लिपा पिहांवःपिं न्‍हय्‌म्‍ह छेंगू व क्‍वँय् जक खनेदुपिं गंसिपिं साया अर्थ नं न्‍हय्‌दँ हे खः। अले सालुसे च्‍वंगु व पुर्बया फसं कयाः झ्‍वाः जूगु अन्‍नया न्‍हय्‌गुँइँया अर्थ नं न्‍हय्‌दँ हे खः। थुकिं न्‍हय्‌दँ अनिकाल जुइ धाःगु खः। ");
INSERT INTO new_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“जिं महाराजयात धयागु थ्‍व खँ परमेश्‍वरं थःम्‍हं यानादीत्‍यंगु खँ महाराजयात क्‍यनादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","मिश्र देशया न्‍यंकभनं न्‍हय्‌दँ तक तसकं बाली सइ। ");
INSERT INTO new_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","अनंलि मेगु न्‍हय्‌दँ अनिकाल जुइ। अले अनिकालं देशय् हाहाकार जुइ। थुकिं न्‍हापायागु भिंगु ईया खँ ल्‍वःमंकाबी। ");
INSERT INTO new_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","लिपा वइगु अनिकालं यानाः न्‍हापायागु भिंगु खँ ल्‍वःमनी, छाय्‌धाःसा थ्‍व अनिकाल तसकं ग्‍यानापुइ। ");
INSERT INTO new_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","महाराजया थथे लिसा कयाः म्‍हंगुया अर्थ परमेश्‍वरं थ्‍व क्‍वःछिनादी धुंकल, अले थथे याकनं जुइ धयागु खः। ");
INSERT INTO new_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“उकिं आः महाराजं छम्‍ह ज्ञां दुम्‍ह व छु यायेमाः धकाः स्‍यूम्‍ह मनूयात ल्‍ययाः मिश्र देशयागु जिम्‍मा बियादिसँ। ");
INSERT INTO new_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","अले हानं महाराजं न्‍हय्‌दँ बाली यक्‍व सइबलय् नं न्‍याब्‍वय् छब्‍व बाली मुंकेत मनूत ल्‍ययादिसँ। ");
INSERT INTO new_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","इमित याकनं वयेत्‍यंगु न्‍हय्‌दँया ई दुने बाली मुंकाः हयाः शहरया धुकुतिइ स्‍वथनेगु व पिवाः च्‍वनेगु अधिकार बियादिसँ। ");
INSERT INTO new_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","थ्‍व बाली मिश्रय् जुइत्‍यंगु न्‍हय्‌दँया अनिकालय् छ्यलेत मुंकातये फइ। थुकिं यानाः अनिकालया इलय् नं मनूतय् नये मखं धयागु दइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","फारो व भारदारत फुक्‍कसित थ्‍व ग्‍वसाः यल। ");
INSERT INTO new_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","वय्‌कलं इमित धाल, “थ्‍व थें ज्‍याःम्‍ह परमेश्‍वरया आत्‍मा दुम्‍ह मनू झीसं गनं लुइके फइ ला?” ");
INSERT INTO new_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","अले फारों योसेफयात धाल, “परमेश्‍वरं छन्‍त फुक्‍क खँ क्‍यनादीगु दु। छ थें ज्‍याःम्‍ह ज्ञां दुम्‍ह व सःस्‍यूम्‍ह मनू सु दइ? ");
INSERT INTO new_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","उकिं आः जिं छन्‍त हे मिश्र देशया हामा यानाबिया। फुक्‍क मनूतय्‌सं छंगु उजं न्‍यनी। थ्‍व सिंहासनं यानाः जक जि छ स्‍वयाः च्‍वय् लाइ।” ");
INSERT INTO new_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","फारों हानं धयादिल, “छ आः मिश्र देशया हामा जुल।” ");
INSERT INTO new_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","वं थःम्‍हं न्‍ह्यानातःगु अंगू त्‍वयाः योसेफया पतिनय् न्‍ह्याकाबिल। अले वयात भिंगु कापःया भान्‍तां लं फिकाः गःपतय् लुँयागु सिखः क्‍वखाय्‌कल। ");
INSERT INTO new_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","वं वयात गयेत थःगु स्‍वयाः क्‍वय्‌यागु बग्‍गी बिल। अले व गन गन वन मनूतय्‌सं न्‍ह्यःने न्‍ह्यःने वनाः “पुलिं चु, पुलिं चु” धकाः हालावन। थुकथं योसेफ मिश्र देशया हामा जुल। ");
INSERT INTO new_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","अले वं वयात धाल, “जि फारो खःसां छंगु उजं मदय्‌कं मिश्र देशय् सुनानं छुं यायेदइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फारों वयागु नां सापनत-पानेह तयाबिल। वयागु ब्‍याहा ओनय् च्‍वंम्‍ह पुजाहारी पोतीपेराया म्‍ह्याय् आसनतलिसे यानाबिल। अनंलि योसेफ मिश्र देशन्‍यंक चाःहिल। ");
INSERT INTO new_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","मिश्र देशया हामा जूबलय् योसेफ स्‍विदँ दुम्‍ह खः। फारोयाथासं पिहां वयाः व मिश्र देशय् न्‍यंक चाःहिल। ");
INSERT INTO new_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","न्‍हय्‌दँ तक अन तसकं अन्‍न सल। ");
INSERT INTO new_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","योसेफं व न्‍हय्‌दँया दुने अप्‍वः दुगु फुक्‍क अन्‍न मुंकाः शहरय् शहरय् स्‍वथना तल। वं फुक्‍क शहरय् अनया जःखः च्‍वंगु थाय्‌या अन्‍न मुंकाः तया तल। ");
INSERT INTO new_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","अन अन्‍न फिसःया फि थें च्‍वंक ल्‍याः खानां ल्‍याः खाये मफयेक मुंवःगुलिं योसेफं उकिया ल्‍याःचाः तयेगु तकं त्‍वःताबिल। ");
INSERT INTO new_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","अनिकाल वये न्‍ह्यः ओनया पुजाहारी पोटिपेराया म्‍ह्याय् आसनत पाखें योसेफया निम्‍ह काय् दये धुंकल। ");
INSERT INTO new_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","योसेफं “परमेश्‍वर जितः जिगु फुक्‍क दुःख ल्‍वःमंके बियादिल, अले जिमि बाःया छेँयागु फुक्‍क खँ नं ल्‍वःमंके बियादिल” धकाः थः न्‍हापांम्‍ह काय्‌यागु नां मनश्‍शे तल। ");
INSERT INTO new_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","अले वं निम्‍हम्‍ह काय्‌यागु नां “परमेश्‍वरं जितः जिं दुःखसियागु देशय् मस्‍त बियादिल” धकाः एफ्राइम तल। ");
INSERT INTO new_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","मिश्रया न्‍हय्‌दँया तसकं अन्‍न सइगु ई फुत। ");
INSERT INTO new_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","अले योसेफं धाःथें न्‍हय्‌दँया अनिकाल शुरु जुल। फुक्‍क थासय् अनिकाल जुल। मिश्रय् धाःसा फुक्‍क थासय् अन्‍न दु। ");
INSERT INTO new_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","मिश्रय् च्‍वंपिन्‍सं नं अनिकालं यानाः नयेमखँसेंलि फारोयाथाय् वनाः अन्‍नया लागि बिन्‍ति यात। वं इमित धाल, “योसेफयाथाय् हुँ, वं छु धाइ, अथे हे या।” ");
INSERT INTO new_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","देशन्‍यंक अनिकाल न्‍यँसेंलि योसेफं फुक्‍क अन्‍नया धुकू चाय्‌काबिल। अले मिश्रय् च्‍वंपिन्‍त अन्‍न मिल। छाय्‌धाःसा मिश्रय् न्‍यंकभनं तसकं अनिकाल जूगु खः ");
INSERT INTO new_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","फुक्‍क देशय् हे अनिकाल जूगुलिं मेमेगु देशय् च्‍वंपिं नं योसेफयाथाय् अन्‍न न्‍याःवल। ");
INSERT INTO new_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","मिश्रय् अन्‍न दु धकाः सिसेंलि याकूबं थः काय्‌पिन्‍त धाल, “छिपिं छाय् छुं मयासें ल्‍हाः प्‍वःचिनाच्‍वनागु? ");
INSERT INTO new_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","मिश्र देशय् अन्‍न दु धकाः जिं न्‍यना। म्‍वानाच्‍वनेगु खःसा अन वनाः अन्‍न न्‍याना हजि।” ");
INSERT INTO new_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","उकिं योसेफया झिम्‍ह दाजुपिं अन्‍न न्‍यायेत मिश्रय् वन। ");
INSERT INTO new_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","याकूबं योसेफया किजा बेन्‍यामीनयात धाःसा वयात नं छुं जुइ ला धकाः ग्‍यानाः वया दाजुपिंलिसे मछ्वः। ");
INSERT INTO new_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","थुकथं इस्राएलया काय्‌पिं मेपिंलिसे अन्‍न न्‍यायेत मिश्रय् वन। छाय्‌धाःसा कनान देशय् नं अनिकाल जूगु खः। ");
INSERT INTO new_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","उबलय् योसेफ मिश्र देशया हामा जुयाच्‍वंगु व वं हे अन्‍न मियाच्‍वंगुलिं वया दाजुपिन्‍सं वयात बँय् भ्‍वपुयाः भागि यात। ");
INSERT INTO new_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","वं थः दाजुपिन्‍त खनेवं म्‍हसिल। अय्‌नं म्‍हमस्‍यू पहः यानाः वं इमित तस्‍सलं न्‍यन, “छिपिं गनं वयापिं?” इमिसं धाल, “कनान देशं अन्‍न न्‍यायेत वयागु।” ");
INSERT INTO new_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफं इमित म्‍हसीकूसां इमिसं वयात म्‍हसीके मफुत। ");
INSERT INTO new_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","वं इमिगु बारे खंगु म्‍हगस लुमंकल, अले धाल, “छिपिं थन चेवा याःवःपिं खः। छिपिं जिमिगु देशया कमजोरी सीकःवःपिं खः।” ");
INSERT INTO new_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","इमिसं धाल, “मखु, प्रभु, अथे मखु। छिकपिनि दासत, जिपिं अन्‍न न्‍याः वयापिं खः। ");
INSERT INTO new_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","जिपिं सकले दाजुकिजापिं खः। जिपिं भिंपिं मनूत खः, चेवा याःवयापिं मखु।” ");
INSERT INTO new_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","योसेफं धाल, “मखु, छिपिं थ्‍व देशया कमजोरी सीकेत हे वःपिं खः।” ");
INSERT INTO new_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","इमिसं धाल, “जिपिं फुक्‍कं झिंनिम्‍ह दाजुकिजापिं दु। कनानय् च्‍वंपिं जिपिं छम्‍ह हे मनूया काय्‌पिं खः। दक्‍वसिबय् चिधीम्‍ह धाःसा जिमि बाःलिसे दु, छम्‍ह जक मदये धुंकल।” ");
INSERT INTO new_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","योसेफं इमित धाल, “जिं धया थें छिपिं चेवा याःवःपिं हे खः। ");
INSERT INTO new_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","आः जिं छिपिं धात्‍थें सु खः धकाः जाँचय् याये। जिं छिमित धाये, छिमि दक्‍वसिबय् चिधीम्‍ह किजा मवतले छिपिं थनं वने दइ मखु। ");
INSERT INTO new_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","छिपिं मध्‍ये छम्‍हसिनं वनाः वयात ब्‍वना हजि। मेपिं थन हे झ्‍यालखानाय् च्‍वँ। थुकथं छिमिसं धाःगु खँ खः कि मखु धकाः सी दइ। छिमिसं धाःगु मखुगु जुल धाःसा जिं धाये, छिपिं चेवा याःवःपिं हे खः।” ");
INSERT INTO new_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","योसेफं इपिं फुक्‍कसित स्‍वन्‍हु तक झ्‍यालखानाय् कुनातल। ");
INSERT INTO new_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","स्‍वन्‍हु दुखुन्‍हु वं इमित धाल, “जि परमेश्‍वरलिसे ग्‍याइम्‍ह मनू खः। छिमिसं थथे यात धाःसा छिपिं बचय् जुइ फइ। ");
INSERT INTO new_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","छिपिं धात्‍थें हे भिंपिं मनूत खःसा छिपिं मध्‍ये छम्‍ह थन हे झ्‍यालखानाय् च्‍वनाच्‍वँ, मेपिं फुक्‍क नये मखनाच्‍वंपिं थः मनूतय्‌त नकेत अन्‍न ज्‍वनाः थनं हुँ। ");
INSERT INTO new_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","छिमिसं छिमि दक्‍वसिबय् चिधीम्‍ह किजायात धाःसा महये मते। अले तिनि जिं छिमिसं धाःगु खँ खः कि मखु धकाः सीके फइ। अले छिपिं नं बचय् जुइ।” इमिसं “ज्‍यू” धाल। ");
INSERT INTO new_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","अले थःथवय् खँ ल्‍हात, “झीसं झी किजायात यानागु ज्‍यां झीसं थथे दुःख फये माल। वयात दुःख जूबलय् वं ग्‍वाहालि फ्‍वनं नं झीसं वास्‍ता मयाना। उकिं हे झीत आः थथे दुःख वःगु खः।” ");
INSERT INTO new_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रूबेनं धाल, “जिं वयात छुं याये मते धयागु मखु ला? छिमिसं जिगु खँ न्‍यँ हे मन्‍यं। आः झीसं वयागु हिया मू पुलेमाल, मखु ला?” ");
INSERT INTO new_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","योसेफं इमि खँ ल्‍हानाच्‍वंगु थू। इमि दथुइ भाय् हिलीम्‍ह मनू तयातःगुलिं इमिसं थःपिनिगु खँ वं थुइ मखु धकाः च्‍वनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","योसेफ फहिलाः ख्‍वल। अले हाकनं लिफः स्‍वयाः इपिं लिसे खँ ल्‍हात। वं शिमियोनयात यंकाः इमिगु न्‍ह्यःने हे चिनाबिल। ");
INSERT INTO new_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","योसेफं इमिगु बोरा जाय्‌क अन्‍न तयाबीत व इमिगु वहःयागु धिबा इमिगु हे बोराय् तयाबीत उजं बिल। वं इमित लँय् नयेत नं नसात्‍वँसा तयाब्‍यु धकाः उजं बिल। अथे यानाबी धुंकाः ");
INSERT INTO new_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","इपिं थःपिनिगु गधाया म्‍हय् अन्‍न क्‍वबिकाः अनं वन। ");
INSERT INTO new_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","बहनी बाय् च्‍वंथाय् इपिं मध्‍ये छम्‍हसिनं गधायात अन्‍न नकेत धकाः थःगु बोरा चाय्‌कूबलय् द्यःनेसं वहःयागु धिबा नं खन। ");
INSERT INTO new_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","वं मेपिन्‍त धाल, “जिगु वहः धिबा ला जितः हे लित बियाहल। थन बोराय् हे तया तल।” इमिगु नुगः भाराभारा मिन। इमिसं थवंथवय् ख्‍वाः स्‍वयाः धाल, “परमेश्‍वरं झीत थ्‍व छु यानादीगु?” ");
INSERT INTO new_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","कनान देशय् थः बौ याकूबयाथाय् थ्‍यने धुंकाः इमिसं वयात जूगु फुक्‍क खँ कन। इमिसं धाल, ");
INSERT INTO new_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“मिश्रया हामां जिपिंलिसें ततःसलं नवात, अले जिमित चेवा याःवःपिं धकाः व्‍यवहार यात। ");
INSERT INTO new_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","जिमिसं वयात ‘जिपिं भिंपिं मनूत खः, चेवा याःवयापिं मखु।’ ");
INSERT INTO new_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","जिपिं छम्‍ह हे बौया झिंनिम्‍ह दाजुकिजा दु। छम्‍ह मदये धुंकल, दक्‍वसिबय् चिधीम्‍ह कनानय् हे जिमि बौलिसे दु” धकाः धया। ");
INSERT INTO new_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","अले मिश्रया हामां जिमित धाल, “छिपिं धात्‍थें भिंपिं खः कि मखु धकाः जिं जाँचय् याये। छिमिसं थःपिं मध्‍ये छम्‍हय्‌सित थन हे त्‍वःताथकि, अले मेपिं नये मखनाच्‍वंपिं थःमनूतय्‌गु लागि अन्‍न ज्‍वनाः हुँ। ");
INSERT INTO new_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","छिमिसं थःपिनि चिधीम्‍हकिजायात धाःसा थन महये मते। अले जक जिं छिपिं भिंपिं मनूत खः, चेवा याःवःपिं मखु धकाः पत्‍याः याये फइ। अले छिमि दाजुयात नं त्‍वःताबी, छिमिसं थन व्‍यापार नं याये फइ।” ");
INSERT INTO new_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","इमिसं थथःगु बोरा फ्‍यनाः चाय्‌काः स्‍वःबलय् इमिगु वहःयागु धिबाप्‍वः नं उकी तयातःगु लुल। थ्‍व खनाः इपिं फुक्‍क व इमि बौ याकूब नं ग्‍यात। ");
INSERT INTO new_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","इमि बौ याकूबं धाल, “छिमिसं जिमि काय्‌पिं योसेफ व शिमियोनयात ला फाया यंके हे धुंकल। आः हाकनं बेन्‍यामीन नं यंकेत्‍यनागु ला? थ्‍व फुक्‍क जितः हे जुइमाःगु ला?” ");
INSERT INTO new_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","रूबेनं धाल, “बाः, जिं बेन्‍यामीनयात लित हये मफुत धाःसा जिमि निम्‍हं काय्‌या प्राण कयादिसँ। जितः विश्‍वास यानादिसँ। जिं वयात लित हये।” ");
INSERT INTO new_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","याकूबं धाल, “जिं बेन्‍यामीनयात छिपिंलिसे मिश्रय् छ्वये मखु। थ्‍वया दाजु ला मदये हे धुंकल। आः थ्‍व हे छम्‍ह जक दनि। जि आः बुरा जुइ धुन। थ्‍वयात लँय् छुं जुल धाःसा ला जि पीरं हे सिनावनी।” ");
INSERT INTO new_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","कनानय् अनिकाल अज्‍ज अप्‍वयावल। ");
INSERT INTO new_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","मिश्रं हःगु अन्‍न फुक्‍क फुसेंलि याकूबं थः काय्‌पिन्‍त धाल, “वनाः हाकनं अन्‍न न्‍याना हजि।” ");
INSERT INTO new_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","यहूदां धाल, “मिश्रया हामां जिमित थःकिजा ज्‍वनामवयेकं वये मते धकाः ख्‍याच्‍वः ब्‍यूगु दु। ");
INSERT INTO new_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","छिं जिमित बेन्‍यामीनयात नं नापं ब्‍वनायंकेबीगु खःसा जिपिं वने, ");
INSERT INTO new_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","मखुसा वने मखु। छाय्‌धाःसा हामां ‘छिमि किजा ज्‍वनाः मवयेकं जिथाय् वये मते’ धकाः धयाहःगु दु।” ");
INSERT INTO new_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","इस्राएलं धाल, “छिमिसं वयात मेम्‍ह नं किजा दु धकाः जितः छाय् थ्‍व दुःख बियागु?” ");
INSERT INTO new_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","इमिसं धाल, “व मनुखं जिमित ‘छिमि बाः म्‍वानाच्‍वंगु दनि ला, छिमि मेपिं नं दाजुकिजा दु ला’ धकाः दुवालाः न्‍यन। जिमिसं नं वयागु न्‍ह्यसःया लिसः बिया। वं अथे ‘छिमि किजायात थन हजि’ धाइ धकाः जिमिसं छु स्‍यू?” ");
INSERT INTO new_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","अले यहूदां थः बौ इस्राएलयात धाल, “बेन्‍यामीनयात जिगु जिम्‍माय् छ्वयादिसँ। जिपिं थनं थत्‍थें हे वनाछ्वये। थुकथं छि, जि व झी फुक्‍कं म्‍वाये फइ सी माली मखु। ");
INSERT INTO new_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","वयागु जिम्‍मा जि जुल। जिं वयात लित हये मफुत धाःसा जि छिगु न्‍ह्यःने सदांया लागि दोषी जुयाच्‍वने। ");
INSERT INTO new_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","छिसं थन म्‍वाःसां म्‍वाःसां लिबाका मच्‍वंगु जूसा जिपिं अन निकः वनावयेधुन जुइ।” ");
INSERT INTO new_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","अले इमि बौ इस्राएलं धाल, “अथे हे यायेमाः धयागु खःसा अथे हे या। व मनूयात थनया पायेगु वासः, भिंगु भिंगु कस्‍ति, मसला, मूर्र, पेस्‍ता व स्‍यांगुलि नं भचा भचा कोसेलि यंकि। ");
INSERT INTO new_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","अले निदुगं अप्‍वः वहः नं यंकि, छाय्‌धाःसा छिमिगु बोराय् लितवःगु धिबा नं लित पुले मानि। थथे द्वनाः जूगु नं जुइफु। ");
INSERT INTO new_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","छिमि किजायात नं यंकि। छिपिं थत्‍थें हे व मनूयाथाय् हुँ। ");
INSERT INTO new_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","दक्‍व शक्ति दुम्‍ह परमेश्‍वरं छिमित व मनूया न्‍ह्यःने दया यानादीमा। अले व मनुखं छिमि दाजु व बेन्‍यामीनयात नं छिपिंलिसें छ्वयाहयेमा। जि सन्‍तान मदयेक च्‍वनेमाःसां थजुइमा।” ");
INSERT INTO new_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","इपिं कोसेलि, निदुगं वहः व बेन्‍यामीनयात नं ज्‍वनाः हथाय् पथासं मिश्रय् योसेफयाथाय् वन। ");
INSERT INTO new_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","बेन्‍यामीनयात खनाः योसेफं छेँय् ज्‍या याइपिनि नायःयात धाल, “थुमित जिगु छेँय् यंकि। अले भ्‍वय् ज्‍वरय् या। थौं न्‍हिनय् थुमिसं जिलिसें नइ।” ");
INSERT INTO new_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","व मनुखं योसेफं धाःथें इमित योसेफया छेँय् यंकल। ");
INSERT INTO new_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","योसेफया छेँय् यंकूगुलिं इपिं ग्‍यात। इमिसं मतिइ तल, “न्‍हापा बोराय् लित बियाहःगु वहःया हुनिं थथे छेँय् हयाः झीत कुनाः दास याइगु जुइ। अले झीगु गधात नं काइगु जुइ।” ");
INSERT INTO new_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","उकिं इमिसं छेँया लुखाय् थ्‍यंकाः योसेफया छेँय् ज्‍या याइपिनि नायःयात धाल – ");
INSERT INTO new_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“हे जिमि प्रभु, जिपिं थन न्‍हापा अन्‍न न्‍यानाः लिहां वनाबलय् ");
INSERT INTO new_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","बहनी बाय् च्‍वनाथाय् जिमिसं थःपिनिगु बोरा चाय्‌काः स्‍वयाबलय् बोराया म्‍हुतुइ हे वहः लुल। उकिं जिमिसं व लित हयागु दु। ");
INSERT INTO new_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","जिमिसं अन्‍न न्‍यायेत मेगु वहः नं हयागु दु। जिमिगु बोराय् सुनां वहः तयाबिल जिमिसं मस्‍यू।” ");
INSERT INTO new_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","वं धाल, “ग्‍याये मते। छिमि व छिमि बौया परमेश्‍वरं छिमिगु बोराय् वहः तयाब्‍यूगु जुइ। छिमिसं ब्‍यूगु वहः ला जिं कयागु हे खः।” अले वं शिमियोनयात इमिथाय् हल। ");
INSERT INTO new_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","व मनुखं इमित योसेफया छेँय् यंकल। अले तुति सिलेत इमित लः बिल। इमिगु गधातय्‌त नसा नं बिल। ");
INSERT INTO new_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","इमिसं न्‍हिनय् योसेफयात बीगु कोसेलि ठीक यात। छाय्‌धाःसा इमित अन हे नयेत धाःगु खः। ");
INSERT INTO new_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","योसेफ छेँय् वःबलय् इमिसं थःपिन्‍सं ज्‍वनावःगु कोसेलि वयात बिल। अले पुलिं चुयाः भागि यात। ");
INSERT INTO new_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","योसेफं इमिके म्‍हंफु मफु न्‍यने धुंकाः धाल, “छिमिसं जितः थः बुराम्‍ह अबुयागु खँ कंगु खः। आः व गय् च्‍वं? आः तकं म्‍हं फु ला?” ");
INSERT INTO new_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","इमिसं धाल, “छिम्‍ह दास, जिमि बौ आः तकं म्‍हं फु।” अले हाकनं इमिसं वयात पुलिं चुयाः भागि यात। ");
INSERT INTO new_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","योसेफं थःकिजा, थः हे मांया काय् बेन्‍यामीनयात स्‍वयाः धाल, “छिमिसं धयाम्‍ह छिमि दक्‍वसिबय् चिधीम्‍ह किजा थ्‍व हे खः ला? ‘परमेश्‍वरं छन्‍त आशिष बियादीमा, बाबु।’” ");
INSERT INTO new_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","थःकिजा खनाः नुगः मछिना वःगुलिं व अनं फहिलाः थःगु क्‍वथाय् वनाः ख्‍वल। ");
INSERT INTO new_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ख्‍वाः सिलाः व क्‍वथां पिहां वल। अले थःत कःघाना धाल, “नयेगु हजि।” ");
INSERT INTO new_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","योसेफ, वया दाजुकिजापिं व अन भ्‍वय् वःपिं मिश्रीतय्‌त अलग अलग तयाः नकल। छाय्‌धाःसा मिश्रीतय्‌सं हिब्रूतलिसे नापं च्‍वनाः मनः। हिब्रूतलिसे च्‍वनाः नल कि थःपिं क्‍वह्यनी धकाः मिश्रीतय्‌सं ताय्‌कीगु खः। ");
INSERT INTO new_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","योसेफं इमित थकालिंनिसें क्‍वकालि तक झ्‍वःछुकाः फ्‍यतुकल। थ्‍व खनाः तसकं अजू चायाः इमिसं थवंथवय् ख्‍वाः स्‍वल। ");
INSERT INTO new_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","इमिगु ब्‍व योसेफयागु हे टेबिलं लिकया यंकूगु खः। बेन्‍यामीनयागु ब्‍व इमिगु स्‍वयाः न्‍यादुगं अप्‍वः तब्‍व। थुकथं इमिसं योसेफलिसे लय्‌तातां नयेत्‍वने यात। ");
INSERT INTO new_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","योसेफं थःगु छेँय् ज्‍या याइपिनि नायःयात उजं बिल, “थुपिं फुक्‍कसिगु बोराय् थुमिसं ज्‍वनावने फक्‍व अन्‍न तयाब्‍यु, अले फुक्‍कसिगु बोराया म्‍हुतुइ इमिगु वहः तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","जिगु वहःयागु ख्‍वला दक्‍वसिबय् चीधीम्‍हय्‌सिगु बोराय् वयागु वहःलिसें तयाब्‍यु।” वं योसेफं धाःथें यात। ");
INSERT INTO new_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","सुथ न्‍हापां हे इमित इमिगु गधालिसें इमिगु लँ लिकाः छ्वत। ");
INSERT INTO new_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","इपिं शहरं भचा पुलाः वनेवं योसेफं छेँय् ज्‍या याइपिनि नायःयात धाल, “ब्‍वाँय् वनाः इमित नापलाकः हुँ। इमित नाप लानाः थथे धा, ‘भिंया बदला छिमिसं छाय् मभिं यानागु? ");
INSERT INTO new_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","जिमि मालिकया त्‍वनेत छ्यलिगु व भिं मभिं स्‍वइगु ख्‍वला छिमिसं छाय् खुयाहयागु? छिमिसं थ्‍व तसकं बांमलाःगु ज्‍या यात।’” ");
INSERT INTO new_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","वं वनाः इमित नाप लानाः अथे हे धाल। ");
INSERT INTO new_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","इमिसं वयात धाल, “थ्‍व छु धयादियागु, प्रभु! छि दासतय्‌सं ला अथे याये हे फइ मखु। ");
INSERT INTO new_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","जिमिसं ला अज्‍ज कनान देशंनिसें थःपिनिगु बोराय् लुयावःगु वहः तकं लित हयाबिया। जिमिसं छाय् छिकपिनि मालिकया छेँनं लुँ वहः खुयाहयेगु? ");
INSERT INTO new_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","छिकपिनि दास मध्‍ये सुयाकें व लुयावल धाःसा वयात स्‍यानाछ्वयादिसँ, अले जिपिं नं फुक्‍कं छिकपिनि मालिकया दास जुयाः च्‍वने।” ");
INSERT INTO new_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","वं धाल, “ज्‍यू, छिमिसं धाःथे हे जुइ। बरु व सुयाके दइ, व हे जक जिम्‍ह दास जुइ, मेपिं फुक्‍कं वने फइ।” ");
INSERT INTO new_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","फुक्‍कसिनं थथःगु बोरा बँय् क्‍वकयाः फ्‍यन। ");
INSERT INTO new_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","व मनुखं थकालिंनिसें क्‍वकालि तक छम्‍ह छम्‍ह यानाः माल। अले बेन्‍यामीनया बोराय् व ख्‍वला लुयावल। ");
INSERT INTO new_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","थ्‍व खनाः इमिसं थःपिनिगु लं खुत। अले गधायात बोरा क्‍वबिकाः शहरय् लिहां वल। ");
INSERT INTO new_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","यहूदा व वया दाजुकिजापिं वःबलय् योसेफ छेँय् हे दु। इमिसं वयाः वयागु न्‍ह्यःने बँय् भ्‍वसुलाबिल। ");
INSERT INTO new_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफं इमित धाल, “छिमिसं थ्‍व छु यानागु? जिं खः मखु लुइके फु धकाः मस्‍यू ला?” ");
INSERT INTO new_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदां धाल, “जिमिसं छु धाये, प्रभु! जिमिसं गय् यानाः जिपिं निर्दोषपिं धकाः क्‍यने? परमेश्‍वरं जिमित दोषी धकाः क्‍यनादिल। आः जिपिं फुक्‍क छिकपिनि दास जुल, अज्‍ज अप्‍वः यानाः ला ख्‍वला दुम्‍ह जुल।” ");
INSERT INTO new_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","योसेफं धाल, “जिगुपाखें अथे जुइ मखु। ख्‍वला सुयाके लुयावःगु खः व हे जक जिम्‍ह दास जुइ। छिपिं फुक्‍क थः बौयाथाय् याउँक लिहां हुँ।” ");
INSERT INTO new_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","यहूदां न्‍ह्यःने वनाः धाल, “प्रभु, छि जुजु थें हे खः। जिं छुं खँ धाये, जिलिसें तंम्‍वयादी मते। ");
INSERT INTO new_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","“प्रभुं जिमिके थथे धकाः न्‍यनादीगु खः, ‘छिमि बौ व किजा दु ला?’ ");
INSERT INTO new_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","जिमिसं थः मालिकयात थथे लिसः बियागु खः, ‘जिमि बुराम्‍ह बौ दु। अले वय्‌कः बुरा जुइ धुंकाः जिमि दक्‍वसिबय् चिधीम्‍ह किजा बूगु खः। वया दाजु सी धुंकल, अले वया मांयापाखें व हे छम्‍ह जक दनि। जिमि बौनं वयात तसकं माया याः।’ ");
INSERT INTO new_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“अले छिं जिमित, ‘वयात जिथाय् हिँ, जिं वयात स्‍वये’ धयादिल। ");
INSERT INTO new_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","जिमिसं छितः, ‘व थः बौयात त्‍वःताः वये फइ मखु। वं अथे यात कि वया बौ सी’ धकाः धयागु खः। ");
INSERT INTO new_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","अले छिं जिमित, ‘छिमि चिधीम्‍हकिजा ज्‍वनाः मवतले जिगु ख्‍वाः स्‍वये फइ मखु’ धकाः धयादिल। ");
INSERT INTO new_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“जिमिसं जिमि बौयाथाय् वनाः छिं धयादीगु खँ कना। ");
INSERT INTO new_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","अले जिमि बाःनं धयादिल, ‘लिहां वनाः हाकनं भचा अन्‍न न्‍याना हजि।’ ");
INSERT INTO new_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","जिमिसं वय्‌कःयात, ‘जिपिं वने फइ मखु, जिमि दक्‍वसिबय् चिधीम्‍ह किजायात जिपिंलिसें छ्वयेगु खःसा जक जिपिं वने। छाय्‌धाःसा चिधीम्‍हकिजायात ज्‍वनामवंकं जिमित हामायात नापलाके बी मखु’ धकाः धाल। ");
INSERT INTO new_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“अले जिमि बाःनं जिमित, ‘छिमिसं सि हे स्‍यू, वया मांयापाखें जि निम्‍ह काय्‌पिं दु। ");
INSERT INTO new_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","छम्‍ह ला न्‍हापा हे मदये धुंकल। वयात कुचा कुचा थले धुंकल जुइमाः। वं जितः त्‍वःतावँसांनिसें जिं वयात मखनानि। ");
INSERT INTO new_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","आः छिमिसं थ्‍वयात नं यंकाः छुं जुल धाःसा जि ला पीरं सिना हे वनी’ धकाः धयादिल। ");
INSERT INTO new_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“उकिं आः जिपिं लिहां वनेबलय् वयात नं ब्‍वनायंके हे माः। जिमि बाःयागु प्राण हे वयाके थाना च्‍वंगुलिं ");
INSERT INTO new_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","वयात मखन कि ला वय्‌कः सिना हे वनी। थुकथं वय्‌कः सीगुया दोषी जिपिं हे ठहरय् जुइ। ");
INSERT INTO new_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","वयागु जिम्‍मा जिं कयावयागु दु। जिं जिमि बौयात, ‘जिं वयात लित हये मफुत धाःसा थुकिया दोष जिं मसीतले फयाच्‍वने’ धकाः धयावयागु दु। ");
INSERT INTO new_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“उकिं जिगु बिन्‍ति दु, वयागु थासय् जितः हे थः दास यानाः तयादिसँ, वयात वया दाजुपिंलिसे लित छ्वयादिसँ। ");
INSERT INTO new_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","वयात ब्‍वना मयंसे जि गथे यानाः जिमि बाःया न्‍ह्यःने वने? जिमि बाःयात जूगु दुःख जिं गथे यानाः स्‍वये?” ");
INSERT INTO new_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","योसेफं थःगु मन चीमफुसेंलि वं ज्‍या याइपिं फुक्‍कसित अनं पितिनाछ्वत। थः दाजुपिं जक ल्‍यं दसेंलि वं थः सु खः धकाः थः दाजुपिन्‍त कन। ");
INSERT INTO new_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","अले व ह्वाँय्‌ह्वाँय् ख्‍वल। व ख्‍वःगु अन च्‍वंपिं मिश्रीतय्‌सं नं ताल, अले थ्‍व खँ फारोया छेँय् नं सिल। ");
INSERT INTO new_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","योसेफं थः दाजुपिन्‍त धाल, “जि योसेफ खः, जिमि बाः आः तकं म्‍वानाच्‍वंगु दनि ला?” वया दाजुपिन्‍सं धाःसा ग्‍यानाः छुं हे लिसः बी मफुत। ");
INSERT INTO new_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","वं थः दाजुपिन्‍त धाल, “जिगु लिक्‍क वा।” इपिं वयागु लिक्‍क वँसेंलि वं धाल, “जि छिमिसं मिश्र देशय् मियाछ्वःम्‍ह छिमि किजा योसेफ खः। ");
INSERT INTO new_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","जितः थन मियाहःगुलिइ आः छिमिसं दुःख ताये मते, थः खनाः तं नं म्‍वये मते। जितः थन फुक्‍क मनूतय्‌त बचय् यायेत परमेश्‍वरं हे छ्वयाहयादीगु खः। ");
INSERT INTO new_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","निदँ न्‍ह्यवंनिसें देशय् अनिकाल जुयाच्‍वंगु दु, अले न्‍यादँ तक छुं नं पीगु व लयेगु ज्‍या जुइमखुनि। ");
INSERT INTO new_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","परमेश्‍वरं थुकथं छिमित व छिमि सन्‍तानयात म्‍वाकातयेत जितः थन छिपिं स्‍वयाः न्‍ह्यः छ्वयाहयादिल। ");
INSERT INTO new_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","उकिं जितः थन छ्वयाहःगु छिमिसं मखु, परमेश्‍वरं खः। वय्‌कलं हे जितः फारोया दरबारय् तःधंम्‍ह मनू यानादिल, अले मिश्र देशया हामा यानादिल। ");
INSERT INTO new_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“आः याकनं जिमि बाःयाथाय् वनाः वय्‌कःया काय् योसेफं धयाहःगु धकाः थथे धयाब्‍यु, परमेश्‍वरं जितः मिश्र देशया हामा यानादीगु दु। पलख हे लिमबाकुसे जिथाय् याकनं झासँ। ");
INSERT INTO new_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","छि थः मचाखाचा, छय्‌पिं व थःलिसे दुगु फुक्‍क वस्‍तु व सामान ज्‍वनाः गोशेनय् जिगु सत्तीक च्‍वं झासँ। ");
INSERT INTO new_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","अन जूसा जिं छिकपिन्‍त स्‍वये फइ। छाय्‌धाःसा अनिकालया न्‍यादँ अज्‍ज नं ल्‍यंदनि। मखुसा ला छिकपिं फुक्‍कं हाःनाः मदयावनी। ");
INSERT INTO new_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“आः छिपिं फुक्‍कसिनं अले बेन्‍यामीनं नं जि योसेफ हे खः धकाः सी हे धुंकल। ");
INSERT INTO new_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","मिश्र देशय् जि तःधंम्‍ह मनू जूगु अले छिमिसं थन खंगु फुक्‍क खँ जिमि बाःयात कँ। अले वय्‌कःयात थन याकनं हजि।” ");
INSERT INTO new_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","थथे धयाः व थःकिजा बेन्‍यामीनयात घय्‌पुयाः ख्‍वल। बेन्‍यामीन नं वयात घय्‌पुयाः ख्‍वल। ");
INSERT INTO new_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","व थः दाजुपिं फुक्‍कसित चुप्‍पा नयाः ख्‍वल। अले तिनि वया दाजुपिन्‍सं नं वलिसे खँ ल्‍हाये फत। ");
INSERT INTO new_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","योसेफया दाजुकिजापिं वःगु दु धयागु खँ फारोया दरबारय् थ्‍यंसेंलि फारो व वया भारदारत फुक्‍क लय्‌ताल। ");
INSERT INTO new_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","फारों योसेफयात धाल, “थः दाजुकिजापिन्‍त थथःगु गधायात कु क्‍वबिकाः कनानय् लिहां हुँ धयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","अले थः बौ व परिवारयात ज्‍वनाः थन लिहां वा। जिं इमित मिश्रया दक्‍वसिबय् भिंगु बुँ बी। अले अन सःगु अन्‍न नयाः आनन्‍दं च्‍वने फइ।” ");
INSERT INTO new_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","इमित थथे नं धयाब्‍यु, “थः मस्‍तय्‌त व कलाःपिन्‍त तयाः हयेत थनं गाडा नं यंकि। अले थः बौयात नं ब्‍वनाः थन वा। ");
INSERT INTO new_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","थःपिनिगु सामानया छुं नं च्‍यूताः तये मते। छाय्‌धाःसा मिश्रय् छु छु भिंगु दु व छिमिगु हे खः।” ");
INSERT INTO new_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","इस्राएलया काय्‌पिन्‍सं फारों धाःथें हे यात। योसेफं इमित गाडा व लँय् नयेत नसात्‍वँसा नं बियाछ्वत। ");
INSERT INTO new_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","इपिं फुक्‍कसित वं न्‍हू न्‍हूगु लं बिल, बेन्‍यामीनयात धाःसा वहःया स्‍वसः शेकेल व न्‍याजु वसः नं बिल। ");
INSERT INTO new_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","वं थः बौया लागि झिम्‍ह गधाया म्‍हय् मिश्रया भिंगु भिंगु सामान, झिम्‍ह गधाया म्‍हय् अन्‍न व मरि, अले लँय् नयेत मेमेगु नसात्‍वँसा नं तयाः छ्वत। ");
INSERT INTO new_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","थुकथं योसेफं थः दाजुकिजापिन्‍त अनं छ्वत। वने न्‍ह्यः वं इमित धाल, “लँय् ल्‍वाये मते।” ");
INSERT INTO new_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","थुकथं इपिं मिश्र देशं वनाः कनान देशय् थः बौ याकूबयाथाय् थ्‍यंकः वल। ");
INSERT INTO new_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","इमिसं वयात धाल, “योसेफ मसीनि। व ला मिश्र देशया हामा जुयाच्‍वन।” थ्‍व न्‍यनाः याकूबं छुं हे धाये मफुत। वं थ्‍व खँ पत्‍याः हे याये मफुत। ");
INSERT INTO new_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","योसेफं इमित धयाहःगु फुक्‍क खँ न्‍यनाः, अले थःत हयेत धकाः छ्वयाहःगु गाडा खँसेंलि याकूबया होश वल। ");
INSERT INTO new_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","अले वं धाल, “आः जि छिमिसं धाःगु खँय् पत्‍याः जुल, जिमि काय् योसेफ मसीनि। जिं वनाः वयात नाप लाये, अले सी न्‍ह्यः वयागु ख्‍वाः स्‍वये।” ");
INSERT INTO new_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","थःगु फुक्‍क सामान प्‍वःचिनाः इस्राएल मिश्रय् वन। बेर्शेबाय् थ्‍यंकाः वं थः बौ इसहाकया परमेश्‍वरयात बलि बिल। ");
INSERT INTO new_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","चान्‍हय् परमेश्‍वरं वयात दर्शन बियाः धयादिल, “याकूब, याकूब।” अले वं धाल, “जि थन दु।” ");
INSERT INTO new_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","परमेश्‍वरं धयादिल, “जि परमेश्‍वर खः, छिमि बाःया परमेश्‍वर, मिश्रय् वनेत छ ग्‍याये मते। जिं अन छंगुपाखें छगू तःधंगु जाति दय्‌के। ");
INSERT INTO new_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","जि छनापं मिश्रय् वने। जिं हे छिमि सन्‍तानयात अनं लित ब्‍वना हये। छ सीबलय् छिमि काय् योसेफ छनापं दइ।” ");
INSERT INTO new_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","अनंलि याकूब बेर्शेबां वन। वया काय्‌पिन्‍सं वयात, वया मस्‍तय्‌त व कलाःपिन्‍त फारों छ्वयाहःगु गाडाय् तयाः यन। ");
INSERT INTO new_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","इपिं थःपिनिगु फुक्‍क वस्‍तु, कनानय् मुंकातःगु फुक्‍क सामान व फुक्‍क सन्‍तान ज्‍वनाः मिश्र देशय् वन। ");
INSERT INTO new_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","थुकथं याकूब थःकाय्‌पिं, म्‍ह्याय्‌पिं, छय्‌पिं, फुक्‍क सन्‍तान ज्‍वनाः मिश्रय् वन। ");
INSERT INTO new_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","मिश्रय् वंपिं इस्राएलया काय्‌पिं अर्थात याकूबया सन्‍तान थथे दु – याकूबया तःधीम्‍ह काय् रूबेन। ");
INSERT INTO new_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रूबेनया काय्‌पिं – हानोक, पल्‍लु, हेस्रोन व कर्मी। ");
INSERT INTO new_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमियोनया काय्‌पिं – यमूएल, यामीन, ओहद, याकीन, सोहोर व कनानी कलाःपाखें दुम्‍ह काय् शौल। ");
INSERT INTO new_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेवीया काय्‌पिं – गेर्शोन, कहात व मरारी। ");
INSERT INTO new_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाया काय्‌पिं – शेलह, फारेस व जेरह। यहूदाया तःधिपिं निम्‍ह काय् एर् व ओनान कनानय् हे सीगु खः। फारेसया काय्‌पिं – हेस्रोन व हामूल। ");
INSERT INTO new_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्‍साखारया काय्‌पिं – तोला, पुवा, याशूब व शिम्रोन। ");
INSERT INTO new_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलूनया काय्‌पिं – सेरेद, एलोन व यहलेल। ");
INSERT INTO new_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","थुपिं पद्दन-आरामय् लेआपाखें बूपिं याकूबया काय्‌पिं खः। वयापाखें छम्‍ह म्‍ह्याय् दीना नं दु। लेआया पाखें याकूबया मुक्‍कं स्‍विस्‍वम्‍ह सन्‍तान दु। ");
INSERT INTO new_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गादया काय्‌पिं – सेफोन, हाग्‍यी, शूनी, यसबोन, एरी, अरोदी व अरेली। ");
INSERT INTO new_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","आशेरया काय्‌पिं – यिम्‍ना, यिश्‍वा, यिश्‍वी व बरीआ। इमि क्‍यहेँ सेरह खः। बरीआया काय्‌पिं – हेबेर व मल्‍कीएल। ");
INSERT INTO new_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","थुपिं लाबानं थः म्‍ह्याय् लेआयात बियाहःम्‍ह दासी जिल्‍पाया पाखें दुपिं याकूबया सन्‍तान खः। थुपिं मुक्‍कं झिंखुम्‍ह दु। ");
INSERT INTO new_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकूबया कलाः राहेलया काय्‌पिं – योसेफ व बेन्‍यामीन। ");
INSERT INTO new_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ओनयाम्‍ह पुजाहारी पोतीपेराया म्‍ह्याय् आसनतया पाखें मिश्रय् बूपिं योसेफया काय्‌पिं मनश्‍शे व एफ्राइम खः। ");
INSERT INTO new_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बेन्‍यामीनया काय्‌पिं – बेला, बेकेर, अश्‍बेल, गेरा, नामान, एही, रोश, मुप्‍पीम, हुप्‍पीम व आर्द। ");
INSERT INTO new_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","राहेलया पाखें बूपिं याकूबया सन्‍तान थुपिं हे खः। थुपिं मुक्‍कं झिंप्‍यम्‍ह दु। ");
INSERT INTO new_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दानया काय् – हुशीम। ");
INSERT INTO new_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्‍तालीया काय्‌पिं – यहसेल, गुनी, येसेर व शिल्‍लेम। ");
INSERT INTO new_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","थुपिं लाबानं थः म्‍ह्याय् राहेलयात बियाहःम्‍ह दासी बिल्‍हापाखें दुपिं याकूबया सन्‍तान खः। थुपिं मुक्‍कं न्‍हय्‌म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","भौपिं त्‍वःताः याकूबलिसें मिश्रय् वंपिं वया सन्‍तान जक मुक्‍कं खुइखुम्‍ह दु। ");
INSERT INTO new_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","मिश्रय् बूपिं योसेफया निम्‍ह काय् दु। थुकथं आः मिश्रय् याकूबया मुक्‍कं न्‍हयेम्‍ह सन्‍तान दत। ");
INSERT INTO new_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","याकूबं योसेफयात थःत नापलायेत गोशेनय् वा धकाः धाय्‌के छ्वयेत यहूदायात थः स्‍वयां न्‍हापा छ्वत। इपिं अन थ्‍यंबलय् ");
INSERT INTO new_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","योसेफ थःगु रथ तयार यानाः थः बौ इस्राएलयात गोशेनय् नापलायेत पिहां वल। वं थः बौयात नापलायेवं घय्‌पुयाः ताःईतक ख्‍वयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","इस्राएलं योसेफयात धाल – “जिं छन्‍त नाप लानाः ख्‍वाः स्‍वये खन, छ मसीनि धकाः सिल। आः जि याउँक सीदत।” ");
INSERT INTO new_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","योसेफं थः दाजुकिजा व इपिं लिसे वःपिं फुक्‍कसित धाल – “आः जिं वनाः जुजुयात कनानय् च्‍वंपिं जिमि बाः, दाजुकिजापिं व छेँजःपिं थन वःगु दु धकाः कने। ");
INSERT INTO new_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","जिं जुजुयात छिकपिं फैजवाःत खः, उकिं थःपिन्‍के दुगु सा फै फुक्‍क वस्‍तु व सामान नं ज्‍वनावःगु दु धकाः धयाबी। ");
INSERT INTO new_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","“फारों छिकपिन्‍त, ‘छिपिं छु ज्‍या याइपिं?’ धकाः न्‍यन धाःसा ");
INSERT INTO new_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‘जिपिं फैजवाःत खः, जिपिं न्‍हापांनिसें फै ज्‍वयावयाच्‍वनापिं खः’ धकाः धयादिसँ। अले वय्‌कलं छिकपिन्‍त गोशेनय् च्‍वनेत थाय् बी। मिश्रय् च्‍वंपिनि फै ज्‍वइपिं मनूत मयःगुलिं योसेफं अथे धाय्‌कूगु खः।” ");
INSERT INTO new_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","योसेफं थः न्‍याम्‍ह दाजु-किजापिन्‍त नापं ब्‍वना यंकाः फारोयाथाय् वनाः धाल, “जिमि बाः व दाजुकिजापिं थःपिनिगु सा, फै व थःपिन्‍के दुगु फुक्‍क वस्‍तु ज्‍वनाः कनानं थन वःगु दु। आः इपिं गोशेनय् च्‍वनाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","अले वं थः न्‍याम्‍ह दाजुकिजापिन्‍त म्‍हसीका बिल। ");
INSERT INTO new_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","फारों इमिके न्‍यन, “छिपिं छु ज्‍या याइपिं?” इमिसं धाल, “महाराज, जिपिं जिमिगु पुर्खानिसें हे फैजवाःत खः। ");
INSERT INTO new_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","कनान देशय् तसकं अनिकाल जुयाः फै ज्‍वयेत तकं थाय् मदयाः जिपिं थन च्‍वं वयागु खः। उकिं सरकारं जिमित थन गोशेनय् च्‍वनेबियादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","अले फारों योसेफयात धाल, “छिमि बाः व दाजुकिजापिं छन्‍थाय् वःगु दु। ");
INSERT INTO new_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","मिश्र देश छंगु न्‍ह्यःने दु। देशय् दुने दक्‍वसिबय् भिंगु थासय् छिमि बाः व दाजुकिजापिन्‍त ति। इमित गोशेनय् हे च्‍वनेब्‍यु। इपिं मध्‍ये सुं ल्‍वःपिं व सःपिं दुसा इमित जिगु वस्‍तुया जिम्‍मा बियाब्‍यूसां ज्‍यू।” ");
INSERT INTO new_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","अले योसेफं थः बौ याकूबयात फारोया न्‍ह्यःने हल। याकूबं फारोयात आशीर्वाद बिल। ");
INSERT INTO new_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","फारों याकूबयात न्‍यन, “छि ग्‍वःदँ दत?” ");
INSERT INTO new_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूबं धाल, “जि आः उखेंथुखें जुयागु सच्‍छि व स्‍विदँ दत। जिगु थ्‍व उमेर आपाः मदुसां तसकं दुःखं जाः। जिमि बाः बाज्‍यापिं म्‍वानावंगु ति ला जिगु उमेर थ्‍यं हे मथ्‍यंनि।” ");
INSERT INTO new_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","याकूबं हाकनं छकः फारोयात आशीर्वाद बिल, अले फारोयाथासं पिहां वन। ");
INSERT INTO new_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","योसेफं फारों धाःथें थः बौ व दाजुकिजापिन्‍त रामसेस धाःथाय् च्‍वंगु मिश्रया दक्‍वसिबय् भिंगु व बांलाःगु थाय् बियाः तल। ");
INSERT INTO new_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","योसेफं थः बौ, दाजुकिजा व फुक्‍कसित नसाज्‍वलं नं हयाबिल। ");
INSERT INTO new_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","तसकं अनिकाल जूगुलिं गनं हे अन्‍न मदु। मिश्र व कनान देशय् नं तसकं अनिकाल जूगुलिं अनयापिं मनूत नये मखनाः बमलात। ");
INSERT INTO new_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","मिश्र व कनान देशयापिं मनूतय्‌सं अन्‍न न्‍यानाः पूगु धिबा फुक्‍क मुंकाः योसेफं फारोया छेँय् तयेहयातल। ");
INSERT INTO new_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","मिश्र व कनान देशय् च्‍वंपिनि धिबा फुसेंलि मिश्रय् च्‍वंपिन्‍सं वयाः योसेफयात धाल, “जिमित अन्‍न बियादिसँ। मखुसा जिपिं छिगु न्‍ह्यःने हे सी। जिमिके दुगु धिबा फुक्‍कं फुइधुंकल।” ");
INSERT INTO new_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","योसेफं इमित धाल, “छिमिके दुगु धिबा फुइधुंकल सा वस्‍तु हिँ। छिमिगु वस्‍तुया पलेसा जिं छिमित अन्‍न बी।” ");
INSERT INTO new_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","उकिं इमिसं थःपिन्‍के दुगु छेँय् लहीपिं वस्‍तु हल। योसेफं अन्‍नया पलेसा इमिसं हःगु सल, फै, च्‍वलय्, सा व गधा काल। थुकथं उगु दँय् योसेफं अन्‍नया पलेसा इमिगु छेँय् लहीपिं वस्‍तु काल। ");
INSERT INTO new_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","मेगु दँय् इपिं हाकनं वयाः हाल, “जिमिसं थःपिनिगु खँ छिगु न्‍ह्यःने सुचुके मखु। जिमिगु फुक्‍क धिबा नं फुइधुंकल, वस्‍तु नं फुक्‍क छिगु जुइ धुंकल। आः जिमिके जिमिगु म्‍ह व बुँ बाहेक मेगु छुं हे मदये धुंकल। ");
INSERT INTO new_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","जिमित व जिमिगु बुँयात नाश यानादी मते। जिमित अन्‍न बियाः जिमित व जिमिगु बुँ कयादिसँ। थुकथं जिपिं जिमिगु बुँनापं फारोया दास दासी जुइ। जिमित पुसा बियादिसँ। अले जिपिं सी माली मखु, जिमिगु बुँ नं बाझः जुइ मखु।” ");
INSERT INTO new_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","थुकथं योसेफं मिश्रया फुक्‍क बुँ छकू छकू यानाः फारोया निंतिं न्‍यानाकाल। अन तसकं अनिकाल जूगुलिं फुक्‍क मिश्रीतय्‌सं थःपिनिगु बुँ मीमाल। थुकथं मिश्रया फुक्‍क बुँ फारोयागु जुल। ");
INSERT INTO new_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","अले मिश्रया फुक्‍क मनूत फारोया दास दासी जुल। ");
INSERT INTO new_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","अन च्‍वंपिं पुजाहारीतय्‌सं जक थःपिनिगु बुँ मीम्‍वाःल। छाय्‌धाःसा जुजुं हे इमित न्‍हियान्‍हिथं अन्‍न इनाबियातःगु दु। ");
INSERT INTO new_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","अले योसेफं फुक्‍कसित धाल, “आः छिपिं व छिमिगु बुँ फुक्‍क जुजुयागु जुइ धुंकल। जिं आः छिमित बुँइ पीत पुसा बी। ");
INSERT INTO new_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","लयेगु इलय् छिमिसं बुँइ सःगु न्‍याब्‍वय् छब्‍व जुजुयात बीहयेमाः, अले प्‍यब्‍व धाःसा छिमिसं पुसाया निंतिं व थथःगु परिवार व थः मस्‍तय्‌गु नसाया निंतिं तये फइ।” ");
INSERT INTO new_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","इमिसं धाल, “छिं जिमित बचय् यानादिल। जिमि प्रभुया दया जिमिके दयाच्‍वनेमा। जिपिं आः जुजुया दास जुयाच्‍वने।” ");
INSERT INTO new_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","उकिं मिश्र देशय् योसेफं बुँयागु छगू कानून हे दय्‌काबिल। मिश्रय् थ्‍व कानून आः तक नं दनि। थ्‍व कानूनकथं बुँयागु न्‍याब्‍वय् छब्‍व अन्‍न जुजुयागु जुइ। पुजाहारीतय्‌गु बुँ जक जुजुयागु मजुल। ");
INSERT INTO new_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","थुकथं मिश्रया गोशेनय् इस्राएलीतय्‌सं थःपिनिगु थाय्‌बाय् दय्‌कल। इमिसं अन यक्‍व सम्‍पत्ति दय्‌कल। इमि सन्‍तान नं यक्‍व दयावल। ");
INSERT INTO new_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","याकूब मिश्रय् झिंन्‍हय्‌दँ म्‍वात, मुक्‍कं सच्‍छि व पिइन्‍हय्‌दँय् क्‍यन। ");
INSERT INTO new_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","इस्राएलं थः सीत्‍यय्‌काः थःकाय् योसेफयात सःताः धाल, “छं जितः धात्‍थें हे माया यानागु खःसा जितः थन मिश्रय् थुने मखु धकाः बचं ब्‍यु। ");
INSERT INTO new_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","जि सी धुंकाः जितः थनं यंकाः जिमि बौ बाज्‍यापिं थुनातःथाय् हे थुनाब्‍यु।” वं धाल, “जिं छिं धाःथें हे याये।” ");
INSERT INTO new_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","इस्राएलं हाकनं धाल, “अथे याये धकाः पाफ।” अले योसेफं पाफल। अले इस्राएल थःगु लासाया छ्यंफुसय् भ्‍वपुल। ");
INSERT INTO new_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","छुं ई लिपा योसेफयात सुनानं वया बौ याकूब तसकं म्‍हंमफय्‌का च्‍वन धकाः कं वल। योसेफ थः निम्‍ह काय् मनश्‍शे व एफ्राइमयात ब्‍वनाः याकूबयात स्‍वःवन। ");
INSERT INTO new_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","याकूबयात सुनानं वया काय् योसेफ वयात नापलाः वःगु दु धकाः कन। व मफु मफु थः हे दनाः लासाय् फ्‍यतुत। ");
INSERT INTO new_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","याकूबं योसेफयात धाल, “दक्‍व शक्ति दुम्‍ह परमेश्‍वरं जितः कनान देशय् लुजःय् झायाः आशिष बियाः धयादिल – ");
INSERT INTO new_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘जिं छन्‍त यक्‍व सन्‍तान बी। छंपाखें जिं थीथी जाति दय्‌के। जिं छन्‍त थ्‍व थाय् बियाच्‍वना, अले सदां सदांया लागि थ्‍व छंगु व छिमि सन्‍तानयागु जुइ।’ ");
INSERT INTO new_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“जि थन मिश्रय् वये न्‍ह्यः थन हे बूपिं छं निम्‍ह काय् मनश्‍शे व एफ्राइम नं रूबेन व शिमियोन थें जिम्‍ह हे खः। ");
INSERT INTO new_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","वयां लिपा बूपिं धाःसा जिम्‍ह जुइ मखु, छंम्‍ह हे जुइ। इमिसं वया दाजुपिं मनश्‍शे व एफ्राइमपाखें अंश काइ। ");
INSERT INTO new_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","“जिं थथे छाय् यानागु धाःसा पद्दन-आरामं लिहां वयाच्‍वनाबलय् एप्रात (बेथलेहेम) थ्‍यने न्‍ह्यः हे कनान देशय् छिमि मां राहेल मन्‍त। जिं वयात अन हे लँसिथय् थुनेमाल।” ");
INSERT INTO new_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","योसेफया काय्‌पिन्‍त खनाः इस्राएलं न्‍यन, “थुपिं सु?” ");
INSERT INTO new_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","योसेफं धाल, “थुपिं जिमि काय्‌पिं खः। थुमित परमेश्‍वरं जितः थन हे मिश्रय् ब्‍यूगु खः।” वं धाल, “इमित जिगु लिक्‍क छ्वयाहिँ। जिं इमित आशिष बी।” ");
INSERT INTO new_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","इस्राएल तसकं बुरा जुइ धुंकूगुलिं वं बांलाक मिखां मछू। उकिं योसेफं थः काय्‌पिन्‍त वयागु लिक्‍क यंकाबिल। अले वं इमित चुप्‍पा नयाः घय्‌पुल। ");
INSERT INTO new_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","इस्राएलं योसेफयात धाल, “तःदँ तक ला जिं छ सी धुंकल धयाच्‍वनागु। अले छंगु ख्‍वाः स्‍वये खनी मखुत धयाच्‍वनागु। परमेश्‍वरं थौं जितः छिमि काय्‌पिन्‍त नापं स्‍वये दय्‌काबिल।” ");
INSERT INTO new_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","योसेफं थः काय्‌पिन्‍त इस्राएलया पुलिं क्‍वकाल, अले बँय् भ्‍वपुलाः इस्राएलयात भागि यात। ");
INSERT INTO new_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","योसेफं दनाः थःकाय्‌पिं एफ्राइमयात इस्राएलया खवय् व मनश्‍शेयात जवय्‌पाखे लाकाः न्‍ह्यःने यंकल। ");
INSERT INTO new_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","तर इस्राएलं थःगु जवगु ल्‍हाः यंकाः एफ्राइमया छेनय् तयाबिल, अले तःधीम्‍ह जूसां मनश्‍शेया छेनय् खव ल्‍हाः तयाबिल। ");
INSERT INTO new_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","इस्राएलं योसेफयात आशिष बियाः धाल – “जिमि बाज्‍या अब्राहाम व जिमि बाः इसहाकं सेवा याःम्‍ह परमेश्‍वर, अले जिगु जिवंकाछि जिम्‍ह जवाः जुयादीम्‍ह परमेश्‍वरं थ्‍व मस्‍तय्‌त आशिष बियादीमा। ");
INSERT INTO new_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","जितः दुःखय् ग्‍वाहालि यानादीम्‍ह स्‍वर्गदूतं थ्‍व मस्‍तय्‌त आशिष बियादीमा। अले थुमिपाखें हे जिगु नां, जिमि बाज्‍या अब्राहाम व बाः इसहाकयागु नां ल्‍यनाच्‍वने मा। पृथ्‍वीइ थुमि सन्‍तान यक्‍व दयाः न्‍यनावनेमा।” ");
INSERT INTO new_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","थः बौनं जवगु ल्‍हाः एफ्राइमयागु छेनय् तःगु योसेफयात मयल। उकिं वं एफ्राइमयागु छेनं थः बौया ल्‍हाः चीकाः मनश्‍शेया छेनय् तयाबीत स्‍वल। ");
INSERT INTO new_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","वं थः बौयात धाल, “थथे मखु बाः, थ्‍व न्‍हापां बूम्‍ह खः, थ्‍वयागु छेनय् जवगु ल्‍हाः तयादिसँ।” ");
INSERT INTO new_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","वया बौनं वयागु खँ मन्‍यंसे धाल, “जिं स्‍यू पुता, जिं बांलाक स्‍यू। थ्‍वया सन्‍तान नं यक्‍व दयाः तःधनी तिनि। अय्‌नं थ्‍वया किजा थ्‍व स्‍वयां यक्‍व तःधनी, अले वया सन्‍तान थीथी जातिया पुचः जुइ।” ");
INSERT INTO new_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","उखुन्‍हु इस्राएलं इमित थथे धकाः आशिष बिल, “इस्राएलय् च्‍वंपिन्‍सं छिमिगु नां कयाः थथे धकाः आशिष बी, ‘परमेश्‍वरं छन्‍त एफ्राइम व मनश्‍शे थें दय्‌केमा।’” थुकथं वं एफ्राइमयात मनश्‍शे स्‍वयाः न्‍ह्यःने तल। ");
INSERT INTO new_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","अले वं योसेफयात धाल, “छं खँ हे खन, जि आः यक्‍व म्‍वाइ मखुत। परमेश्‍वर छिपिंनापं दी। अले वय्‌कलं छिमित छिमि तापाःबाज्‍यापिनिगु देशय् हे लित यंकी। ");
INSERT INTO new_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","जिं छन्‍त छिमि दाजुकिजापिन्‍त स्‍वयाः अप्‍वः गुँइच्‍वंगु छकू बुँ बियागु दु। व बुँ जिं थःगु तरवार व धनुषया बलं एमोरीतय्‌पाखें त्‍याकाकयागु खः।” ");
INSERT INTO new_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","याकूबं थःकाय्‌पिं फुक्‍कसित सःताः धाल, “छिपिं फुक्‍क थन वा, छिमित लिपा छु छु जुइतिनि धकाः जिं छिमित धाये। ");
INSERT INTO new_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“सकसिनं न्‍यँ, याकूबया काय्‌पिं छिमि बाः इस्राएलं धाःगु खँ न्‍यँ। ");
INSERT INTO new_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","रूबेन, छ जिम्‍ह न्‍हापांम्‍ह काय् खः, छ जिगु बल खः, जिगु ल्‍याय्‌म्‍हसूया न्‍हापांम्‍ह काय् खः, जिगु दक्‍वसिबय् तःधंगु गौरव खः। ");
INSERT INTO new_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","छ थातं मच्‍वंगु लः थें खः, छ न्‍हापांम्‍ह जुयाच्‍वनी मखु, छाय्‌धाःसा छ थः बौया लासाय् द्यन, अले जिगु लासायात क्‍वह्यंकल। ");
INSERT INTO new_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","शिमियोन व लेवी निम्‍ह दाजुकिजां छगू हे कथंयापिं खः, थुमिगु तरवार ल्‍वापुख्‍यापुया ज्‍याभः खः। ");
INSERT INTO new_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","जिं गुबलें नं इमिगु ज्‍या व बिचालय् ब्‍वति मकया छाय्‌धाःसा इमिसं तमय् मनूत स्‍याःगु दु। अले थःयत्‍थें द्वहंतय्‌त पाःगु दु। ");
INSERT INTO new_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","इमिगु तंयात सराः लायेमा छाय्‌धाःसा व तसकं ग्‍यानापु। इमिगु तंयात सराः लायेमा छाय्‌धाःसा व तसकं छाः। जिं इमित ब्‍वथलाबी जिं इमित इस्राएलय् छ्यालब्‍याल यानाबी। ");
INSERT INTO new_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","यहूदा, छन्‍त छिमि दाजुकिजापिन्‍सं तःधंकी, छं थः शत्रुतय्‌त बुकाछ्वःगु दु छिमि बौया काय्‌पिन्‍सं छन्‍त भागि याइ। ");
INSERT INTO new_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","यहूदा सिंहया मचा खः, व शिकारय् हे ब्‍वलन, सिंह थें व घ्‍वंस्‍यानाः ग्‍वारातुली। सुनां वयात थनेगु आँट याइ? ");
INSERT INTO new_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाया ल्‍हातिइ न्‍ह्याबलें राजदण्‍ड दइ, वया सन्‍तानं न्‍ह्याबलें शासन याइ। जाति जातितय्‌सं वयात कोसेलि हइ अले इमिसं वयाः वयात भागि याइ। ");
INSERT INTO new_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","वं थः गधायात भिंगु दाखमाय् ची अले गधाया मचायात भिंगु कचाय् ची। वं थःगु वसः दाखमद्यय् ही अले भान्‍तां लंयात दाखया रसय् ही। ");
INSERT INTO new_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","वयागु मिखा दाखमद्य स्‍वयाः प्‍वालाप्‍वाला थी वयागु वा दुरु स्‍वयाः तुयुसे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","जबूलून समुद्रया सिथय् च्‍वंवनी व जहाज दिकेत ल्‍वःगु थाय् जुइ वयागु लागा सीदोन तक न्‍यनी। ");
INSERT INTO new_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","इस्‍साखार बल्‍लाःम्‍ह गधा खः, व पशुतय्‌गु बारया दथुइ ग्‍वतुलाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","झासु लनेत बांलाःगु थाय् लुयेवं, अले झःझः धाःगु देश खनेवं, वं कु क्‍वबीत थःगु ब्‍वह क्‍वछुकी अले दास थें ज्‍या याइपिं ज्‍यामि जुइ। ");
INSERT INTO new_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","दानं इस्राएलया मेमेगु कुलं थें थः मनूतय्‌त शासन याइ। ");
INSERT INTO new_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान लँसिथय् च्‍वंम्‍ह सर्प खः, व लँय् च्‍वंम्‍ह बिख दुम्‍ह सर्प खः। वं सलया ग्‍वालिइ न्‍याइ, अले सलया म्‍हय् च्‍वंम्‍ह कुतुं वनी। ");
INSERT INTO new_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","परमप्रभु! जि छिं उद्धार याइगु पियाच्‍वनागु दु। ");
INSERT INTO new_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","गादयात छथ्‍वःसिनं हय्‌क्‍काः वइ तर अःखतं वं इमित हय्‌क्‍कयाः लिनाछ्वइ। ");
INSERT INTO new_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","आशेरया यक्‍व अन्‍न सइ, वं जुजुयात माःगु भिंगु अन्‍न बी। ");
INSERT INTO new_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","नप्‍ताली जंगलय् च्‍वंम्‍ह चल्‍ला खः वं बाबांलाःपिं मस्‍त बुइकी। ");
INSERT INTO new_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","योसेफ बुंगाःचा नापं च्‍वंम्‍ह गधाया मचा थें खः, गुँच्‍वय् च्‍वंम्‍ह गधाया मचा थें। ");
INSERT INTO new_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","शत्रुतय्‌सं वयात वाणं कय्‌कःवइ इमिसं वयात थःपिनिगु धनुष वाण ज्‍वनाः लित्तुली। ");
INSERT INTO new_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","तर याकूबया दक्‍व शक्ति दुम्‍ह परमेश्‍वरया ग्‍वाहालिं, फैजवाः व इस्राएलया ल्‍वहँधीया ग्‍वाहालिं वयागु धनुष वाण तप्‍यना हे च्‍वनी, अले वयागु लप्‍पा नं बल्‍लाना च्‍वनी। ");
INSERT INTO new_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","छन्‍त थ्‍व ग्‍वाहालि छिमि बाःया दक्‍व शक्ति दुम्‍ह परमेश्‍वरपाखें वइ। परमेश्‍वरं छन्‍त स्‍वर्गं वा वय्‌काः पृथ्‍वीया तःलं लःधाः पिकयाः अले यक्‍व सन्‍तान बियाः आशिष बियादी। ");
INSERT INTO new_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","छिमि बाःयागु आशिष पहाड स्‍वयाः तःधं, यक्‍व पहाड स्‍वयाः तःधं। थ्‍व फुक्‍क आशिष छंगु छेनय् लायेमा छाय्‌धाःसा छ छिमि फुक्‍क दाजुकिजापिनि नायः खः। ");
INSERT INTO new_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","बेन्‍यामीन ग्‍यानापुम्‍ह फ्‍याकाध्‍वं खः। सुथय् वं शिकार यानाहःगु नइ, अले बहनी लुटे यानाहःगु इनी।” ");
INSERT INTO new_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","थुपिं इस्राएलया झिंनिगू कुल खः। इमि बौनं इमित ल्‍वयेक ब्‍यूगु आशिष थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","अले याकूबं इमित उजं बिल, “जि आः याकनं हे सिनाः जिमि तापाबाज्‍यापिंनाप मिलय् जू वने। जितः जिमि बौबाज्‍यापिंलिसें हित्ती एप्रोनया बुँइ च्‍वंगु गुफाय् थुनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","थ्‍व गुफा कनान देशय् च्‍वंगु मम्रे लिक्‍क च्‍वंगु मक्‍पेलाया बुँइ च्‍वंगु गुफा खः। अब्राहामं थ्‍व गुफा सी थुनेत धकाः बुँनापं हित्ती एप्रोनया ल्‍हातिं न्‍यानाकाःगु खः। ");
INSERT INTO new_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","अन हे अब्राहाम व वया कलाः सारायात थुंगु खः। अन हे इसहाक व वया कलाः रिबेकायात नं थुंगु खः। अले अन हे जिं लेआयात नं थुनागु खः। ");
INSERT INTO new_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","व बुँ व अन च्‍वंगु गुफा हित्तीतय्‌पाखें न्‍यानाकयातःगु खः।” ");
INSERT INTO new_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","थः काय्‌पिन्‍त थुकथं उजं बीधुंकाः याकूब लासाय् ग्‍वारातुल अले सित। ");
INSERT INTO new_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","योसेफ थः बौया म्‍हय् भ्‍वसुलाः चुप्‍पा नयाः ख्‍वल। ");
INSERT INTO new_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","अले वं थःथाय् च्‍वंपिं वैद्यतय्‌त थः बौया सीम्‍हय् नस्‍वाः वःगु मलम पाकेबिल। ");
INSERT INTO new_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","थ्‍व पिइन्‍हुया ज्‍या खः। मिश्रीत नं न्‍हयेन्‍हु तक दुःखं च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","दुःखं च्‍वनेगु न्‍हि क्‍वचायेवं योसेफं भारदारतय्‌त थथे धाल, “जिगु थुलि खँ फारोयाथाय् यंकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","जिमि बाःनं जितः थथे धकाः पाफय्‌काथकल, ‘जि सीत्‍यनागु दु। कनान देशय् जि थःम्‍हं हे म्‍हुयाथकागु चिहानय् जितः थुनाब्‍यु।’ उकिं जितः फारों वनेगु उजं बियादीसा जि वनाः वये।” ");
INSERT INTO new_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फारों धाल, “छिमि बाःनं पाफय्‌कू थें कनानय् वनाः थुनाः वा।” ");
INSERT INTO new_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","उकिं योसेफ थः बौयात थुनेत वन। व नापं फुक्‍क भारदारत, ततःधंपिं मनूत व मूमूपिं मनूत फुक्‍कं वन। ");
INSERT INTO new_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","योसेफया छेँजः सकलें, वया दाजुकिजापिं व वया बौया थःथितिपिं नं फुक्‍कं वन। थः मस्‍त, सा फै व वस्‍तु जक अन हे गोशेनय् त्‍वःताथकल। ");
INSERT INTO new_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","मनूत रथय् च्‍वनाः व सल गयाः नं व नापं वन। थ्‍व तसकं तःधंगु हुल खः। ");
INSERT INTO new_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","यर्दन लिक्‍क च्‍वंगु आतादया छ्व पाइगु ख्‍यलय् थ्‍यंसेंलि इमिसं तसकं दुःख यानाः ख्‍वल। योसेफ अन थः बौया न्‍हय्‌न्‍हुया दुःखं च्‍वन। ");
INSERT INTO new_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","अन च्‍वनीपिं कनानीतय्‌सं आतादया छ्व पाइगु ख्‍यलय् तसकं नुगः मछिंकाः ख्‍वःगु खनाः थथे धाल, “थ्‍व ला मिश्रीतय् सी हःगु जुयाच्‍वन खनी।” उकिं यर्दन लिक्‍कया व थाय्‌यात हाबिल मिश्रइम धायेगु यात। ");
INSERT INTO new_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","थुकथं याकूबं धाःथें वया काय्‌पिन्‍सं यात। ");
INSERT INTO new_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","इमिसं वयागु सीम्‍हयात कनान देशय् थ्‍यंक हे यंकाः अब्राहामं हित्ती एप्रोनपाखें न्‍यानाकयातःगु मम्रेया लिक्‍क च्‍वंगु मक्‍पेलाया बुँइ च्‍वंगु गुफाय् थुनाबिल। ");
INSERT INTO new_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","थः बौयात थुने धुंकाः योसेफ, थः दाजुकिजापिं अले व नापं वःपिं फुक्‍कलिसें मिश्रय् लिहां वल। ");
INSERT INTO new_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","थःपिनि बौ सीगु खनाः योसेफया दाजुपिनि थवंथवय् थथे खँ ल्‍हात, “योसेफं आः तक नं ईख तयाः झीसं वयात यानागुया बदला काःसा छु यायेगु?” ");
INSERT INTO new_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","उकिं इमिसं योसेफयाथाय् थथे धाय्‌के छ्वत, “सी न्‍ह्यः छिकपिनि बाःनं छितः थथे धायेत जिमित धयाथकूगु खः – ");
INSERT INTO new_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘छन्‍त मभिंकूगुलिइ छं छिमि दाजुपिन्‍त क्षमा या।’ उकिं आः छिकपिनि बाःया परमेश्‍वरया दासतय्‌त इमिसं याःगु द्वंबिद्वंया लागि क्षमा बियादिसँ।” थ्‍व न्‍यनाः योसेफ ख्‍वल। ");
INSERT INTO new_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","वया दाजुपिन्‍सं वयाः वयागु न्‍ह्यःने भ्‍वसुलाः धाल, “जिपिं छिकपिनि दास खः।” ");
INSERT INTO new_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","योसेफं इमित धाल, “ग्‍याये मते, जि छु परमेश्‍वर खः ला? ");
INSERT INTO new_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","छिमिसं जितः स्‍यंकेत स्‍वल, परमेश्‍वरं थुकिया पलेसा भिं यानादिल। थौं झी फुक्‍कं गुकथं बचय् जुयाच्‍वना, व उकिया हे लिच्‍वः खः। ");
INSERT INTO new_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","उकिं ग्‍याये मते। जिं छिमित व छिमि मचाखाचायात लही।” थुकथं वं थः दाजुपिन्‍त हपाः बिल। ");
INSERT INTO new_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ थः दाजुकिजापिंलिसे मिश्रय् हे च्‍वन। योसेफ सच्‍छि व झिदँ तक म्‍वात। ");
INSERT INTO new_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","योसेफं एफ्राइमया पाखें छुइ तकं खन। वं मनश्‍शेया काय् माकीरया नकतिनि बूपिं मस्‍त तकं थःगु मुलय् तये खन। ");
INSERT INTO new_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","सी न्‍ह्यः योसेफं थः दाजुकिजापिन्‍त धाल, “जि आः यक्‍व म्‍वाइ मखुत। परमेश्‍वरं छिमिगु बिचाः यानादी। अले छिमित थनं अब्राहाम, इसहाक व याकूबयात बचं बियादीगु देशय् यंकादी।” ");
INSERT INTO new_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","अले योसेफं इमित पाफय्‌केबिल, “परमेश्‍वरं छिमित यंकादीगु देशय् जिगु अस्‍थि यंके धकाः जितः बचं ब्‍यु।” ");
INSERT INTO new_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","थुकथं योसेफ सच्‍छि व झिदँ दय्‌काः मिश्रय् हे सित। वयागु म्‍हयात नस्‍वाः वःगु मलम पानाः बाकसय् तया तल।");
INSERT INTO new_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","थथःगु परिवार ज्‍वनाः याकूबनापं मिश्र देशय् वंपिं इस्राएलया काय्‌पिनिगु नां थथे दु– ");
INSERT INTO new_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमियोन, लेवी, यहूदा, ");
INSERT INTO new_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्‍साखार, जबूलून, बेन्‍यामीन, ");
INSERT INTO new_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्‍ताली, गाद व आशेर। ");
INSERT INTO new_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकूबया दक्‍वं यानाः न्‍हयेम्‍ह सन्‍तान दु। वया छम्‍ह काय् योसेफ न्‍हापांनिसें हे मिश्रय् दु। ");
INSERT INTO new_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","योसेफ, वया दाजुकिजापिं व वया पुस्‍तायापिं फुक्‍क मनूत सिनावन। ");
INSERT INTO new_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","इस्राएलया सन्‍तान धाःसा ब्‍वलनाः ल्‍याखय् अप्‍वः दयावन। गुकिं यानाः फुक्‍क देश इमिसं जाल। ");
INSERT INTO new_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","अनंलि मिश्रय् योसेफयात म्‍हमस्‍यूम्‍ह छम्‍ह न्‍हूम्‍ह जुजु गद्दीइ च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","वं थः मनूतय्‌त धाल, “स्‍व, इस्राएलीत झीपिं स्‍वयाः यक्‍व अप्‍वः दये धुंकल। इपिं बल्‍लाना वयाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","अथे जुयाः झीसं इपिं लिसे बुद्धिं ज्‍या कायेमाः। मखुसा इपिं ल्‍याखय् अप्‍वः जुयावनी। लडाइँ जुइबलय् नं इपिं झी शत्रुतलिसे मिलय् जुयाः झीपिंलिसे ल्‍वाः वइ, अले देश त्‍वःतावनी।” ");
INSERT INTO new_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","अथे जुयाः मिश्रीतय्‌सं इमित थाकुगु ज्‍या बियाः सास्‍ती यायेत इमिथाय् ज्‍यामि नायःत छ्वल। इमिसं फारोया निंतिं धुकू दय्‌केत पिताम व रामसेस धाःगु निगू शहर दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","अय्‌नं इमिसं गुलि गुलि इस्राएलीतय्‌त दुःखकष्‍ट बिल उलि उलि हे इमिगु ल्‍याः अप्‍वयावन। इपिं यक्‍व थासय् न्‍यना नं वन। अथे जुयाः इपिं इस्राएलीत खनाः तसकं ग्‍यात। ");
INSERT INTO new_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","अले इमिसं इस्राएलीतय्‌त दयामाया मयासें थाकुगु थाकुगु ज्‍या याकल। ");
INSERT INTO new_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","चा न्‍हायेगु, अप्‍पा छियेगु, थाकुगु थाकुगु बुँज्‍या याकाः इमिगु जीवनयात दुःखं जाय्‌काबिल। ");
INSERT INTO new_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","मिश्रया फारोनं शिप्रा व पूआ नांयापिं हिब्रू दिरिअजिपिन्‍त सःताः धाल, ");
INSERT INTO new_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“हिब्रू मिसातय् मचा बुइबलय् मचातइगु थलय् छिमिसं सुसाःकुसाः याःवनेबलय् काय् बूसा स्‍यानाछ्व, म्‍ह्याय् बूसा स्‍याये मते।” ");
INSERT INTO new_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","दिरिअजिपिं परमेश्‍वरया भय काइपिं जूगुलिं मिश्रया फारोनं उजं ब्‍यू थें मयासें इमिसं काय् बूसां मस्‍यासें हे त्‍वःताबीगु। ");
INSERT INTO new_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","अथे जुयाः मिश्रया फारोनं इमित सःताः न्‍यन, “छिमिसं थथे छाय् यानागु? छिमिसं काय् मस्‍तय्‌त छाय् मस्‍यानागु?” ");
INSERT INTO new_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","दिरिअजिपिन्‍सं फारोयात धाल, “हिब्रू मिसात मिश्री मिसात थें मखु। इपिं तसकं बल्‍लाः, दिरिअजितः थ्‍यने न्‍ह्यः हे इमिसं मचा बुइके धुंकीगु।” ");
INSERT INTO new_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","अले परमेश्‍वरं दिरिअजिपिन्‍त भिं यानादिल। इस्राएलीत ल्‍याखय् झन अप्‍वः दयावन। ");
INSERT INTO new_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","दिरिअजिपिन्‍सं परमेश्‍वरयागु भय काःगुलिं वय्‌कलं इमित नं सन्‍तान बियादिल। ");
INSERT INTO new_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","अले फारोनं थः फुक्‍क प्रजायात थथे धकाः उजं बिल, “हिब्रूतय् ग्‍वःम्‍ह काय्‌मस्‍त बुइ इपिं फुक्‍कसित नील खुसिइ यंकाः वांछ्व। म्‍ह्याय् मस्‍तय्‌त जक ल्‍यंका ति।” ");
INSERT INTO new_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","थ्‍व हे इलय् लेवी कुलयाम्‍ह छम्‍ह मिजंनं थःगु हे कुलयाम्‍ह छम्‍ह मिसानापं ब्‍याहा यात। ");
INSERT INTO new_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","अले व मिसाया प्‍वाथय् दत, वं छम्‍ह काय् बुइकल। मचा तसकं बांलाःगु खनाः वयात स्‍वला तक सुचुका तल। ");
INSERT INTO new_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","अय्‌नं वं स्‍वला स्‍वयाः अप्‍वः सुचुकातये मफुत। अले वं मचायात तयेत तिंकथियागु छगः पिचा दय्‌कल। उकी अलकत्रा इलाः लः दुहां मवनीगु यानाबिल। मचायात उकी तयाः नील खुसियागु सिथय् ताहाकःगु घाँय्‌या दथुइ त्‍वःताबिल। ");
INSERT INTO new_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","अले मचायात छुं जुइ ला धकाः स्‍वयेत वया तता तापाक्‍क दनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","थ्‍व हे इलय् फारोया म्‍ह्याय् नील खुसिइ म्‍वः ल्‍हुयेत वल। वया दासीत खुसि सिथय् चाःह्यूवंबलय् वं घाँय् दथुइच्‍वंगु पिचा खनाः थः दासीयात व काय्‌के छ्वल। ");
INSERT INTO new_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","वं पिचा चाय्‌काः स्‍वःबलय् ख्‍वयाच्‍वंम्‍ह मचायात खनाः वयात माया वन, अले वं धाल, “थ्‍व सुं हिब्रूतय् मचा खः।” ");
INSERT INTO new_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","उबले व मचाया ततां फारोया म्‍ह्याय्‌यात न्‍यन, “जिं वनाः सुं छम्‍ह हिब्रू मिसायात छिगु निंतिं मचायात दुरु त्‍वंकेत ब्‍वना हये ला?” ");
INSERT INTO new_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","फारोया म्‍ह्याय्‌नं वयात धाल, “ज्‍यू, हुँ।” अले व मिसामचां वनाः थः हे मांयात सःताः हल। ");
INSERT INTO new_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","फारोया म्‍ह्याय्‌नं व मिसायात धाल, “जिगु निंतिं थ्‍व मचायात यंकाः दुरु त्‍वंकेगु या, अले जिं छन्‍त ज्‍यालाबी।” व मिसां मचायात यंकाः दुरु त्‍वंकेगु यात। ");
INSERT INTO new_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","मचा तःधिकः जुइ धुंकाः वं वयात फारोया म्‍ह्याय्‌याथाय् हल। फारोया म्‍ह्याय्‌नं मचायात थःकाय् नालाकाल। अले वं “जिं थ्‍वयात लखं लिकयागु खः” धकाः वयागु नां मोशा तल। ");
INSERT INTO new_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","मोशा ल्‍याय्‌म्‍ह जुइ धुंकाः पिने थः इस्राएली दाजुकिजापिन्‍थाय् वन, अन वं इमिसं थाकुगु ज्‍या यानाच्‍वंगु खन। अले छम्‍ह मिश्रीं छम्‍ह हिब्रूयात तसकं दायाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","मोशां उखेंथुखें स्‍वल। सुं नं मदुगुलिं वं व मिश्रीयात स्‍यानाः वयागु सीम्‍ह फिइ सुचुकाबिल। ");
INSERT INTO new_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","कन्‍हय् खुन्‍हु हानं व अन वंबलय् निम्‍ह हिब्रूत थःथवय् हे ल्‍वानाच्‍वंगु खन। अले वं द्वंकूम्‍ह हिब्रूयात थथे धाल, “छं थः हे हिब्रूयात छाय् दायागु?” ");
INSERT INTO new_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","व मनुखं धाल, “छन्‍त सुनां जिमि शासक व न्‍यायाधीश दय्‌कल? छु छं जितः नं व मिश्रीयात स्‍याः थें स्‍याये त्‍यनागु ला?” थ्‍व न्‍यनाः मोशा ग्‍यात। वं बिचाः यात, “जिं यानागु खँ मनूतय्‌सं सी धुंकल।” ");
INSERT INTO new_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","थ्‍व खँ सियाः फारोनं मोशायात स्‍यायेगु बिचाः यात। मोशा धाःसा अनं मिद्यान देशय् बिस्‍युं वनाः छगः तुंया न्‍ह्यःने च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिद्यानया पुजाहारीया न्‍हय्‌म्‍ह म्‍ह्याय्‌पिं व हे तुंथिइ लः काःवल। इमिसं तुंथिइ च्‍वंगु लः सालाः थः बौया पशुतय्‌सं लः त्‍वनीगु थलय् तयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","उबले हे फैजवाःत वयाः इमित ख्‍याना छ्वयेत्‍यन। मोशा वयाः इमित ग्‍वाहालि यानाः इमि फैच्‍वलय्‌तय्‌त लः त्‍वंके बिल। ");
INSERT INTO new_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","इपिं थः बौ रूएलयाथाय् लिहां वःबलय् इमि बौनं इमित न्‍यन, “थौं छिपिं छाय् याकनं लिहां वयागु?” ");
INSERT INTO new_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","अले इमिसं धाल, “छम्‍ह मिश्रीं जिमित फैजवाःतय्‌गु ल्‍हातं बचय् यात। अले लः सालाः फैच्‍वलय्‌तय्‌त त्‍वंकल।” ");
INSERT INTO new_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","अले वं थः म्‍ह्याय्‌पिन्‍त धाल, “व मनू गन दु? वयात छिमिसं छाय् त्‍वःतावयागु? वनाः झीनापं नयेत वयात ब्‍वना हजि।” ");
INSERT INTO new_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","मोशा व मनूनापं च्‍वनेत मानय् जुल। वं थः म्‍ह्याय् सिप्‍पोरायात मोशानापं ब्‍याहा यानाबिल। ");
INSERT INTO new_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","सिप्‍पोरां काय् छम्‍ह बुइकल। मोशां “जि मेगु देशय् परदेशी जुयाच्‍वनागु दु” धकाः वयागु नां गेर्शोम तल। ");
INSERT INTO new_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","यक्‍व ई लिपा मिश्रयाम्‍ह जुजु सित। दास जुयाः च्‍वनेमाःगुलिं इस्राएलीतय्‌सं झसुकाः तयाः ग्‍वाहालि फ्‍वन। इमिगु सः परमेश्‍वरयाथाय् थ्‍यन। ");
INSERT INTO new_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","थथे इपिं पिच्‍यानाः हाःगु सः न्‍यनाः परमेश्‍वरं अब्राहाम, इसहाक व याकूबनापं थःम्‍हं यानागु बाचायात लुमंकादिल। ");
INSERT INTO new_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","अथे जुयाः परमेश्‍वरं इस्राएलीतय्‌त स्‍वयादिल अले इमिगु च्‍यूताः कयादिल। ");
INSERT INTO new_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मोशा थः ससःबौ मिद्यानया पुजाहारी यित्रोया फैच्‍वलय् ज्‍वयाच्‍वंगु जुल। अले मरुभूमिइ फैच्‍वलय् ज्‍वज्‍वं परमेश्‍वरया पर्वत होरेबय् थ्‍यंक हे यंकल। ");
INSERT INTO new_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","अन छगू झाःया दथुइ मि जलय् परमप्रभुया दूत खनेदत। मोशां व झालय् मि च्‍यानाच्‍वंसां झाः छुं मजूगु खन। ");
INSERT INTO new_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","अथे जुयाः मोशां, “जि लिक्‍क हे वनाः थ्‍व अजू चायापुगु मि स्‍वये, व झाः छाय् छुं मजूगु” धकाः मतिइ तल। ");
INSERT INTO new_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","च्‍यानाच्‍वंगु मि स्‍वयेत व लिक्‍क वःगु खनाः परमप्रभु परमेश्‍वरं वयात च्‍यानाच्‍वंगु झालं, “मोशा, अय् मोशा” धकाः सःतादिल। अले मोशां धाल, “जि थन हे दु।” ");
INSERT INTO new_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","परमेश्‍वरं धयादिल, “थुखे लिक्‍क वये मते। थःगु लाकां त्‍वः, छाय्‌धाःसा छ दनाच्‍वंगु थाय् पवित्रगु खः।” ");
INSERT INTO new_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","वय्‌कलं हानं धयादिल, “जि छिमि पुर्खाया परमेश्‍वर खः, अब्राहाम, इसहाक व याकूबया परमेश्‍वर खः।” अले मोशां थःगु ख्‍वाः त्‍वपुल, छाय्‌धाःसा परमेश्‍वरयात स्‍वयेत व ग्‍यात। ");
INSERT INTO new_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","परमप्रभुं धयादिल, “जिं धात्‍थें हे मिश्रय् च्‍वंपिं जि थः मनूतय्‌त तसकं सास्‍ती जूगु खनागु दु। अले मिश्रीतय्‌सं यानाः इपिं ख्‍वःगु सः जिं न्‍यनागु दु। इमिगु दुःख जिं स्‍यू, च्‍यूताः नं कयाच्‍वनागु दु। ");
INSERT INTO new_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","अथे जुयाः इमित मिश्रीतय्‌गु ल्‍हातं त्‍वःतकाः व देशं मेगु भिंगु व तःधंगु दुरु व कस्‍ति बाः वयाच्‍वंगु कनानी, हित्ती, एमोरी, परिज्‍जी, हिव्‍वी व यबूसीतय्‌गु देशय् हयेत जि क्‍वहां वयागु दु। ");
INSERT INTO new_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","आः इस्राएलीत तःसलं ख्‍वःगु सः जिथाय् थ्‍यंगु दु। मिश्रीतय्‌सं इमित गुलि सह याये मफय्‌क दुःख ब्‍यूगु दु व नं जिं खनागु दु। ");
INSERT INTO new_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","अथे जुयाः छ हुँ, जिं थः मनू इस्राएलीतय्‌त मिश्रं पित हयेत छन्‍त फारोयाथाय् छ्वये।” ");
INSERT INTO new_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","मोशां परमेश्‍वरयात धाल, “फारोयाथाय् वनाः इस्राएलीतय्‌त मिश्रं पित हये फुम्‍ह जि सु खः धकाः?” ");
INSERT INTO new_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","परमेश्‍वरं धयादिल, “जि छनापं दइ। अले जिं हे छन्‍त छ्वयागु खः धयागु खँया चिं थ्‍व जुइ, छं थः मनूतय्‌त मिश्रं पित हये धुंकाः छिमिसं थ्‍व हे पर्वतय् परमेश्‍वरयात आराधना याइ।” ");
INSERT INTO new_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मोशां परमेश्‍वरयात धाल, “जिं इस्राएलीतय्‌थाय् वनाः इमित ‘छिमि पुर्खाया परमेश्‍वरं हे जितः छिमिगु निंतिं छ्वयाहःगु खः’ धकाः धायेबलय्, इमिसं ‘वय्‌कःया नां छु खः?’ धकाः न्‍यन धाःसा जिं इमित छु धायेगु?” ");
INSERT INTO new_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","परमेश्‍वरं मोशायात धयादिल, “जि सु खः व हे खः। वय्‌कलं हाकनं धयादिल, छं इस्राएलीतय्‌त थथे धा, ‘जि खः धाःम्‍हय्‌सिनं जितः छिमिथाय् छ्वयाहःगु खः।’” ");
INSERT INTO new_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","परमेश्‍वरं हानं मोशायात धयादिल, “इस्राएलीतय्‌त धा, ‘परमप्रभु छिमि पुर्खाया परमेश्‍वर आर्थात अब्राहाम, इसहाक, याकूबया परमेश्‍वरं जितः छिमिथाय् छ्वयाहःगु खः।’ “न्‍ह्याबलेंया निंतिं जिगु नां थ्‍व हे खः। जिगु थ्‍व हे नामं जितः छिमिसं पुस्‍तां पुस्‍ता तक लुमंकेगु याइ। ");
INSERT INTO new_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“छ वनाः इस्राएलयापिं थकालित मुंकाः इमित थथे धा, ‘छिमि पुर्खा अब्राहाम, इसहाक, याकूबया परमप्रभु परमेश्‍वर जिथाय् न्‍ह्यःने खनेदय्‌कः झायाः थथे धयादीगु दु, जि छिमिथाय् वयागु दु, मिश्रय् छिमित गुलि दुःख ब्‍यूगु दु व नं जिं खनागु दु। ");
INSERT INTO new_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","अले जिं छिमित मिश्रीतय्‌सं याःगु दुःखं लिगनाः दुरु व कस्‍ति बाः वयाच्‍वंगु कनानी, हित्ती, एमोरी, परिज्‍जी, हिव्‍वी व यबूसीतय्‌गु देशय् यंकेत क्‍वःछिनागु दु।’ ");
INSERT INTO new_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“अले इस्राएलया थकालितय्‌सं छंगु खँ न्‍यनी। अनं लिपा छं इपिं नापं मिश्रया जुजुयाथाय् वनाः थथे धा, ‘हिब्रूतय् परमप्रभु परमेश्‍वरं जिमित नापलानादीगु दु। उकिं जिमित जिमि परमप्रभु परमेश्‍वरयात बां बीत स्‍वन्‍हुया लँपुया मरुभूमिइ वनेबियादिसँ धकाः इनाप याये।’ ");
INSERT INTO new_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","मिश्रयाम्‍ह जुजुं गुबलय् तक करं काइ मखु उबले तक छिमित वनेबी मखु धकाः जिं स्‍यू। ");
INSERT INTO new_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","अथे जुयाः जिं मिश्र देशपाखे थःगु ल्‍हाः ल्‍ह्वनाः इमित जिगु अजू चायापुगु ज्‍यां कय्‌के। अले तिनि वं छिमित वनेबी। ");
INSERT INTO new_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“जिं मिश्रीतय्‌त छिमित हनाबना तइपिं यानाबी। अले छिपिं अनं पिहां वनीबलय् ल्‍हातय् छुं मदय्‌क वनी मखु। ");
INSERT INTO new_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","फुक्‍क इस्राएली मिसातय्‌सं थथः मिश्री जःलाखःला व इमिगु छेँय् च्‍वनिपिं मिसातय्‌के लुँ, वहः, तिसा व वसः फ्‍वनी, अले छिमिसं व थःकाय् म्‍ह्याय्‌पिन्‍त पुंकी। थुकथं छिमिसं मिश्रीतय्‌गु धन ज्‍वनाः वइ।” ");
INSERT INTO new_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","मोशां धाल, “इमिसं जितः पत्‍याः मयाःसा अले जिगु खँ मन्‍यंसे, ‘परमप्रभु छन्‍थाय् खनेदय्‌कः झाःगु मखु’ धकाः लिसः बिल धाःसा छु यायेगु?” ");
INSERT INTO new_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","परमप्रभुं वयात धयादिल, “छंगु ल्‍हातय् छु दु?” वं धाल, “कथि।” ");
INSERT INTO new_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","परमप्रभुं धयादिल, “व बँय् वांछ्व।” मोशां व बँय् वांछ्वल। अले व छम्‍ह सर्प जुल। थ्‍व खनाः ग्‍यानाः मोशा तिंन्‍हुल। ");
INSERT INTO new_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","परमप्रभुं मोशायात धयादिल, “ल्‍हाः यंकाः वयागु न्‍हिप्‍यं ज्‍वँ।” मोशां न्‍ह्यःने वनाः वयात ज्‍वन। वयागु ल्‍हातय् व हानं कथि हे जुल। ");
INSERT INTO new_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","परमप्रभुं वयात धयादिल, “थ्‍व ज्‍यापाखें हे इमिसं जितः पत्‍याः यायेमा। अले जि हे इमि पुर्खा अब्राहाम, इसहाक व याकूबया परमेश्‍वर छन्‍थाय् खनेदय्‌कः वःगु खः धकाः इमिसं सीमा।” ");
INSERT INTO new_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","अले हाकनं परमप्रभुं धयादिल, “थःगु ल्‍हाः गाय् दुने दुछ्व।” वं थःगु ल्‍हाः गाय् दुने दुछ्वत। पिकाःबलय् वयागु ल्‍हाः कोह्रि ल्‍वचं कयाः च्‍वापु थें तुइसे च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","वय्‌कलं हानं धयादिल, “थःगु ल्‍हाः हानं गाया दुने दुछ्व।” अले वं थःगु ल्‍हाः हानं गाया दुने छ्वत। पिकाःबलय् वयागु ल्‍हाः न्‍हापा गथे खः अथे हे जुल। ");
INSERT INTO new_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","अले परमप्रभुं धयादिल, “इमिसं छंगु न्‍हापांगु अजू चायापुगु चिंयात पत्‍याः मयासां लिपायागु चिंयात पत्‍याः याये फु। ");
INSERT INTO new_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","अय्‌नं इमिसं थ्‍व निगूगु चिंयात नं पत्‍याः मयानाः छंगु खँ मन्‍यंसा छ वनाः नील खुसियागु लः भतिचा कयाः गंगु बँय् प्‍वंकाब्‍यु। बँय् व लः हि जुइ।” ");
INSERT INTO new_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","अले मोशां परमप्रभुयात धाल, “हे प्रभु जि उलि न्‍ववाये सःम्‍ह मखु, जि न्‍हापा नं बांलाक न्‍ववाये सःम्‍ह मखु अले छिलिसे न्‍ववाये धुंकाः नं जि बांलाक न्‍ववाये मसःनि। जि ध्‍वाथुइक न्‍ववाये सःम्‍ह मखु।” ");
INSERT INTO new_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","परमप्रभुं वयात धयादिल, “मनूतय्‌गु म्‍हुतु सुनां दय्‌कल? मनूतय्‌त लाता व ख्‍वाँय् सुनां याइ? मनूतय्‌त स्‍वये फुम्‍ह व कां सुनां याइ? छु जि परमप्रभुं हे, मखु ला? ");
INSERT INTO new_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","अथे जुयाः हुँ, जिं छन्‍त न्‍ववायेत ग्‍वाहालि याये, अले छं छु छु न्‍ववायेमाः व जिं स्‍यने।” ");
INSERT INTO new_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","मोशां धाल, “हे प्रभु, थुकिया निंतिं मेम्‍ह हे सुं छ्वयादिसँ।” ");
INSERT INTO new_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","अले परमप्रभुं तं पिकयाः धयादिल, “छु लेवी कुलयाम्‍ह हारून छिमि दाजु मखु ला? वं बांलाक न्‍ववाये सः धकाः जिं स्‍यू। व छन्‍त नापलायेत वयाच्‍वंगु दु। अले छन्‍त खनाः व तसकं लय्‌ताइ। ");
INSERT INTO new_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","छ व नापं खँ ल्‍हा अले छं धायेमाःगु खँ वयात धा। जिं छिपिं निम्‍हय्‌सितं न्‍ववायेत ग्‍वाहालि याये। अले छिमिसं यायेमाःगु खँ जिं स्‍यने। ");
INSERT INTO new_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","वं छंगुपाखें मनूतनापं खँ ल्‍हाइ, व छंगु निंतिं म्‍हुतु थें जुइ अले छ वया निंतिं परमेश्‍वर थें जुइ। ");
INSERT INTO new_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","थ्‍व कथि छं थःम्‍हं हे का, अले थुकिं छं अजू चायापुगु चिं क्‍यनेफइ।” ");
INSERT INTO new_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","अले मोशां थः ससःबौ यित्रोयाथाय् लिहां वया थथे धाल, “बिन्‍ति याये, मिश्रय् च्‍वनाच्‍वंपिं जिमि दाजुकिजापिं म्‍वाना हे च्‍वंगु दु कि मदु धकाः स्‍वयेत जितः वनेबियादिसँ।” यित्रों धाल, “ज्‍यू, बांलाक हुँ।” ");
INSERT INTO new_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","परमप्रभुं मिद्यान देशय् मोशायात धयादिल, “मिश्रय् लिहां हुँ, छाय्‌धाःसा अन छन्‍त स्‍यायेत स्‍वःपिं फुक्‍क मनूत सी धुकंल।” ");
INSERT INTO new_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","अथे जुयाः मोशा थः कलाः व काय्‌पिन्‍त गधा गय्‌काः परमेश्‍वरं बियादीगु कथि ज्‍वनाः मिश्र देशय् लिहां वन। ");
INSERT INTO new_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","परमप्रभुं मोशायात धयादिल, “छं मिश्रय् लिहां वनाः जिं छन्‍त बियागु शक्तिं फुक्‍क अजू चायापुगु ज्‍या फारोया न्‍ह्यःने याना क्‍यँ। अय्‌नं जिं वयागु नुगः छाय्‌काबी, अले वं मनूतय्‌त वनेबी मखु। ");
INSERT INTO new_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","छं फारोयात धा, ‘परमप्रभुं धयादी, इस्राएल जिमि दकलय् न्‍हापां बूम्‍ह काय् खः। ");
INSERT INTO new_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","जिं छन्‍त धयागु खः, “जिमि काय्‌यात जिगु निंतिं बां बीत वनेब्‍यु।” छं वयात वने मब्‍यू। उकिं जिं छिमि न्‍हापां बूम्‍ह काय्‌यात स्‍यानाबी।’” ");
INSERT INTO new_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","मोशा लँय् बाय् च्‍वंबलय् परमप्रभुं वयात नापलानादिल। अले वयात स्‍यायेत स्‍वयादिल। ");
INSERT INTO new_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","सिप्‍पोरां छगः च्‍वामुगु ल्‍वहं कयाः थः काय्‌यागु च्‍वफायेगुलिइ च्‍वंगु छेंगू ध्‍यनाः मोशायागु तुतिइ थीका बिल। अले वं धाल, “छ धात्‍थें हिं स्‍वापु तःम्‍ह जिमि भाःत जुल।” ");
INSERT INTO new_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","अनंलि परमप्रभुं वयात त्‍वःतादिल। (उबलय् सिप्‍पोरां धाल “हिं स्‍वापु तःम्‍ह भाःत।” अथे वं म्‍हय् चिं तःगुया कारणं धाःगु खः।) ");
INSERT INTO new_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","परमप्रभुं हारूनयात धयादिल, “मोशायात नापलायेत मरुभूमिइ हुँ।” अले वं परमेश्‍वरयागु पर्वतय् वनाः वयात नाप लानाः घय्‌पुल। ");
INSERT INTO new_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","अनंलि मोशां हारूनयात परमप्रभुं धाय्‌के छ्वयाहयादीगु फुक्‍क खँ कन। अले वय्‌कलं थःत यानाः क्‍यनेत उजं बियादीगु अजू चायापुगु चिंया बारे नं कन। ");
INSERT INTO new_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","अले मोशा व हारूनं इस्राएलीतय् फुक्‍क थकालितय्‌त छथाय् मुंकल। ");
INSERT INTO new_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","परमप्रभुं मोशायात धयादीगु फुक्‍क खँ हारूनं इमित धाल। अले मनूतय् न्‍ह्यःने हे वं अजू चायापुगु चिं नं क्‍यनाबिल। ");
INSERT INTO new_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","मनूतय्‌सं इमित पत्‍याः यात। परमप्रभुं इस्राएलीतय्‌गु च्‍यूताः कयादी अले इमित जुयाच्‍वंगु सास्‍ती नं खंगु दु धकाः न्‍यनाः इमिसं परमप्रभुया न्‍ह्यःने थःगु छ्यं क्‍वछुकाः आराधना यात। ");
INSERT INTO new_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","अनं लिपा मोशा व हारूनं वनाः फारोयात धाल, “परमप्रभु इस्राएलया परमेश्‍वरं थथे धयादिल, ‘जिमि मनूतय्‌त वनेब्‍यु, अले इमिसं मरुभूमिइ वनाः जिगु निंतिं नखः हनेमा।’” ");
INSERT INTO new_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","फारोनं धाल, “परमप्रभु सु खः? जिं छाय् वयागु खँ न्‍यनाः इस्राएलीतय्‌त वने बीगु? जिं परमप्रभुयात म्‍हमस्‍यू अले इस्राएलीतय्‌त नं वनेबी मखु।” ");
INSERT INTO new_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","अले मोशा व हारूनं धाल, “हिब्रूतय् परमेश्‍वरं जिमित नापलानादीगु दु। उकिं जिमि परमप्रभु परमेश्‍वरया निंतिं बां बीत स्‍वन्‍हु मरुभूमिया लँपुइ वनेबियादिसँ। मखुसा वय्‌कलं ल्‍वय् व ल्‍वापु छ्वयाहयाः जिमित स्‍यानादी।” ");
INSERT INTO new_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","फारोनं मोशा व हारूनयात धाल, “अय् मोशा व हारून, छिमिसं छाय् मनूतय्‌त ज्‍या याकेत पनाच्‍वनागु? छिपिं थथःगु ज्‍याय् लिहां हुँ।” ");
INSERT INTO new_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","फारोनं हाकनं हक्‍काः धाल, “आः देशय् थुपिं मनूत ल्‍याखय् अप्‍वः दये धुंकूगु दु। छिमिसं इमित ज्‍या यायेत पनाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","उखुन्‍हु हे फारोनं ज्‍या याकीपिन्‍त व इस्राएली ज्‍यामि नायःतय्‌त थुकथं उजं बिल, ");
INSERT INTO new_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“मनूतय्‌त थौं तक अप्‍पा दय्‌केत बियाच्‍वनागु छ्वालि आवंलि बी मते। थः हे वनाः इमिसं थःगु निंतिं छ्वालि मालेमा। ");
INSERT INTO new_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","अप्‍पा धाःसा न्‍हापा गुलि दय्‌का वयाच्‍वंगु खः, उलि हे दय्‌केमाः। छपा नं कम मजुइमाः। इपिं अल्‍छी जूगु दु। उकिं इपिं, ‘जिमि परमेश्‍वरया निंतिं बां बीत वनेब्‍यु’ धकाः हालाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","थुमिगु ज्‍या अज्‍ज अप्‍वः थाकुका ब्‍यु, थुकिं यानाः थुमित लिलाइ मखु, अले म्‍वाःमदुगु खँय् ध्‍यान नं बीलाइ मखु।” ");
INSERT INTO new_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","अले ज्‍या याकीपिं व ज्‍यामि नायःतय्‌सं वनाः मनूतय्‌त थथे धाल, “फारोनं धाःगु दु, ‘आवंलि छिमित छ्वालि छपु नं बी मखुत। ");
INSERT INTO new_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","छिपिं थःपिं हे वनाः गनं हयेफु हजि, ज्‍या धाःसा भचा नं पाः जुइ मज्‍यू।’” ");
INSERT INTO new_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","उकिं मनूत छ्वालि मालेत मिश्र देश न्‍यंकं उखेंथुखें जुल। ");
INSERT INTO new_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ज्‍या याकीपिन्‍सं इमित थथे धकाः तित्तुतिल, “न्‍हापा छ्वालि बियाच्‍वंबलय् न्‍हिं गुलि ज्‍या यायेगु खः आः नं उलि हे ज्‍या यायेमाः।” ");
INSERT INTO new_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","फारोया ज्‍या याकीपिं मनूतय्‌सं ज्‍या स्‍वइपिं इस्राएली ज्‍यामि नायःतय्‌त थथे धयाः दाइगु, “छिमिसं छाय् न्‍हापालिपा स्‍वयाः थौंकन्‍हय् कम अप्‍पा दय्‌कागु?” ");
INSERT INTO new_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","अले इस्राएली ज्‍यामि नायःतय्‌सं फारोयाथाय् वनाः थथे धाल, “छिं थः दासतय्‌त छाय् थथे यानादियागु? ");
INSERT INTO new_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","जिमित छ्वालि नं बी मखु, न्‍हापा ति हे अप्‍पा दय्‌केमाः धाइगु। अले जिमित दायेगु नं यानाच्‍वंगु दु, अय्‌नं द्वं छिकपिनि मनूतय्‌गु हे दु।” ");
INSERT INTO new_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","फारोनं धाल, “छिपिं अल्‍छीत खः, अल्‍छीत! अथे जुयाः हे छिमिसं, ‘जिमित परमप्रभुया निंतिं बां बीत वनेब्‍यु धकाः धयाच्‍वंगु दु।’ ");
INSERT INTO new_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","हुँ, ज्‍या या हुँ। छिमित छ्वालि छपु नं बी मखु। अय्‌नं छिमिसं न्‍हापा क्‍वःछिनातःगु गुलि खः, उलि हे अप्‍पा दय्‌केमाः।” ");
INSERT INTO new_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“छिमिसं न्‍हियान्‍हिथं बीमाःगु गुलि खः उलि हे अप्‍पा दय्‌केमाः” धाःगु न्‍यनाः इस्राएली ज्‍यामि नायःतय्‌सं थःपिं आः दुःखकष्‍टय् लात धकाः थुइकल। ");
INSERT INTO new_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","फारोयाथासं लिहां वयाच्‍वंबलय् इमिसं मोशा व हारूनयात लँय् पियाच्‍वंगु नापलात। ");
INSERT INTO new_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","अले इमिसं धाल, “परमप्रभुं छिकपिनिगु न्‍याय यानादीमा, छाय्‌धाःसा छिकपिन्‍सं यानाः जुजु व वया भारदारत जिपिंलिसें तंचाःगु दु, अले जिमित स्‍यायेत तरवार नं बियादीगु दु।” ");
INSERT INTO new_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","अले मोशां परमप्रभुयाथाय् लिहां वनाः थथे धाल, “हे प्रभु, छाय् छिं थुमित दुःखय् लाकादियागु? छाय् जितः थन छ्वया हयादियागु? ");
INSERT INTO new_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","फारोयाथाय् छिगु खँ ल्‍हायेत वनाबलय्‌निसें वं थुपिं मनूतलिसें बांमलाःगु व्‍यवहार याःगु दु। अले छिं थः मनूतय्‌त आः तक बचय् यानामदी।” ");
INSERT INTO new_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","परमप्रभुं मोशायात धयादिल, “फारोयात जिं छु याइ आः छं स्‍वये दइ। वं जिगु बल्‍लाःगु ल्‍हातं यानाः इमित वनेबी। वं जिगु शक्तिं यानाः हे इमित थःगु देशं पितिनाछ्वइ।” ");
INSERT INTO new_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","परमेश्‍वरं मोशायात धयादिल, “जि परमप्रभु खः।” ");
INSERT INTO new_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","अब्राहाम, इसहाक व याकूबयाथाय् जि दक्‍व शक्ति दुम्‍ह परमेश्‍वर कथं खनेदय्‌क वया, तर परमप्रभु धकाः जिं थःगु नामं इमित म्‍हसीके मबिया। ");
INSERT INTO new_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","इपिं कनान देशय् परदेशी जुयाः च्‍वनाच्‍वंबलय् जिं इपिं नाप व हे कनान देश इमित बी धकाः बाचा चिनागु दु। ");
INSERT INTO new_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","अज्‍ज ला, जिं मिश्रीतय्‌सं दास यानातःपिं इस्राएलीत ख्‍वःगु सः न्‍यनागु दु, अले जिं थःगु बाचा लुमंकागु दु। ");
INSERT INTO new_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“उकिं इस्राएलीतय्‌त धा, ‘जि परमप्रभु खः। जिं छिमित मिश्रीतय्‌गु दासत्‍वं पित हये। जिं थःगु ल्‍हाः ल्‍ह्वनाः इमित तःधंगु सजाँय बियाः छिमित बचय् याये। ");
INSERT INTO new_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","जिं छिमित थः मनू नालाकाये, अले जि छिमि परमेश्‍वर जुइ। अले मिश्रीतय्‌गु दासत्‍वं छिमित पितहःम्‍ह जि हे छिमि परमप्रभु परमेश्‍वर खः धकाः छिमिसं म्‍हसीकी। ");
INSERT INTO new_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","अले जिं छिमित अब्राहाम, इसहाक व याकूबयात बी धकाः बाचा यानागु देशय् हये। जिं व देश छिमित अधिकार यायेत बी। जि परमप्रभु खः।’” ");
INSERT INTO new_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मोशां इस्राएलीतय्‌त अथे हे धकाः न्‍यंकल। अय्‌नं तसकं क्‍वत्‍यय्‌काः च्‍वनेमाःगुलिं व नुगः क्‍वतुनाच्‍वंगुलिं इमिसं वयागु खँ मन्‍यन। ");
INSERT INTO new_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“छ वनाः मिश्रया जुजु फारोयात धा, ‘इस्राएलीतय्‌त थ्‍व देशं पिहां वनेब्‍यु।’” ");
INSERT INTO new_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","अय्‌नं मोशां परमप्रभुयात धाल, “इस्राएलीतय्‌सं हे जिगु खँ मन्‍यन धाःसा, जि खँ ल्‍हाये मसःम्‍हय्‌सिगु खँ फारोनं गथे यानाः न्‍यनी?” ");
INSERT INTO new_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","मोशा व हारूनयात परमप्रभुं थथे आज्ञा बियादिल, “जिं छिमित इस्राएलीतय्‌त मिश्रं पितः यंकेगु आज्ञा ब्‍यूगु दु धकाः इस्राएलीत व मिश्रयाम्‍ह जुजु फारोयात धा।” ");
INSERT INTO new_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","इस्राएलीतय् पुर्खा थुपिं हे खः – इस्राएलया दकलय् न्‍हापां बूम्‍ह काय् रूबेनया काय्‌पिं हनोक, पल्‍लु, हेस्रोन व कर्मी खः। थुपिं रूबेनया सन्‍तान खः। ");
INSERT INTO new_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमियोनया काय्‌पिं यमूएल, यामीन, ओहद, याकीन व सोहोर खः। अले कनानी मिसापाखेंयाम्‍ह काय् शौल खः। थुपिं शिमियोनया सन्‍तान खः। ");
INSERT INTO new_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेवीया काय्‌पिं गेर्शोन, कहात व मरारी खः। लेवी सछि व स्‍विन्‍हय्‌दँ तक म्‍वात। ");
INSERT INTO new_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोनया काय्‌पिं वया वंशकथं लिब्‍नी व शिमी खः। ");
INSERT INTO new_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहातया काय्‌पिं अम्राम, यिसहार, हेब्रोन व उज्‍जीएल खः। कहात सछि व स्‍विस्‍वदँ तक म्‍वात। ");
INSERT INTO new_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारीया काय्‌पिं महली व मूशी खः। लेवीया वंशत थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्रामं थः निनि योकेबेदनापं ब्‍याहा यात, वं हारून व मोशायात बुइकल। अम्राम सछि व स्‍विन्‍हय्‌दँ तक म्‍वात। ");
INSERT INTO new_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहारया काय्‌पिं कोरह, नेपेग व जिक्री खः। ");
INSERT INTO new_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्‍जीएलया काय्‌पिं मीशाएल, एलसाफान व सिथ्री खः। ");
INSERT INTO new_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारूनं अम्‍मीनादाबया म्‍ह्याय्, नहशोनया केहेँ एलीशेबानापं ब्‍याहा यात। वं वयापाखें नादाब, अबीहू, एलाजार व ईतामारयात बुइकल। ");
INSERT INTO new_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहया काय्‌पिं अस्‍सीर, एल्‍काना व अबिआसाप खः। कोरहया कुल थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारूनया काय् एलाजारं पतीएलया छम्‍ह म्‍ह्याय्‌नापं ब्‍याहा यात, अले वं वयापाखें पीनहासयात बुइकल। लेवीतय्‌गु पुर्खाया कुलयापिं मू मनूत थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","परमप्रभुं इस्राएलीतय्‌त पुचः पुचः यानाः मिश्रं पित हजि धकाः उजं बियादीपिं हारून व मोशा थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","मोशा व हारूनं इस्राएलीतय्‌त मिश्रं पित यंकेत मिश्रयाम्‍ह जुजु फारोलिसे खँ ल्‍हाःगु खः। ");
INSERT INTO new_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","परमप्रभुं मिश्रय् मोशानापं खँ ल्‍हानादीबलय् ");
INSERT INTO new_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","वय्‌कलं वयात थथे धयादिल, “जि परमप्रभु खः। जिं छन्‍त छु छु धाये व फुक्‍क मिश्रया जुजु फारोयात धा।” ");
INSERT INTO new_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","मोशां परमप्रभुयात लिसः बिल, “स्‍वयादिसँ, जि बांलाक न्‍ववाये सःम्‍ह मखु। अथे जुयाः फारोनं जिगु खँ गथे यानाः न्‍यनी?” ");
INSERT INTO new_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","अले परमप्रभुं मोशायात धयादिल, “स्‍व, जिं छन्‍त फारोया निंतिं परमेश्‍वर थें यानागु दु, अले छिमि दाजु हारून छंगुपाखें न्‍ववाइम्‍ह जुइ। ");
INSERT INTO new_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","जिं छन्‍त छु छु उजं बी व हे छं हारूनयात धा। अले छिमि दाजु हारूनं फारोयात इस्राएलीतय्‌त वयागु देशं वनेब्‍यु धकाः धाइ। ");
INSERT INTO new_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","मिश्र देशय् थःगु यक्‍व चिं व अजू चायापुगु ज्‍या यानाः क्‍यनेत जिं फारोया नुगः छाय्‌काबी। ");
INSERT INTO new_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","फारोनं छिमिगु खँ न्‍यनी मखु। अले जिं मिश्र देशय् थःगु ल्‍हाः तयाः मिश्रीतय्‌त तःधंगु सजाँय बियाः थः मनू इस्राएलीतय्‌त मिश्रं पित हये। ");
INSERT INTO new_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","जिं मिश्र देशय् ल्‍हाः तयाः इस्राएलीतय्‌त अनं पित हयेबलय् मिश्रीतय्‌सं जि परमप्रभु खः धकाः सीका काइ।” ");
INSERT INTO new_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","अले मोशा व हारूनं परमप्रभुं उजं बियादी थें हे यात। ");
INSERT INTO new_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","फारोलिसे खँ ल्‍हाः वंबलय् मोशा चय्‌दँ अले हारून चय्‌स्‍वदँ दुम्‍ह जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“फारोनं छिमित, ‘छुं अजू चायापुगु ज्‍या क्‍यँ,’ धकाः धाइबलय् छं हारूनयात धा, ‘छिं थःगु कथि फारोया न्‍ह्यःने वांछ्वयादिसँ,’ अले व सर्प जुइ।” ");
INSERT INTO new_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","मोशा व हारूनं फारोयाथाय् वनाः परमप्रभुं धयादी थें हे यात। हारूनं थःगु कथि फारो व वया भारदारतय् न्‍ह्यःने वांछ्वल। अले व सर्प जुल। ");
INSERT INTO new_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","अले फारोनं ग्‍यां दुपिं व जादु क्‍यनिपिं मनूतय्‌त सःतल। अले मिश्रया जादु क्‍यनिपिन्‍सं वयाः थथःगु जादुनं अथे हे यानाः क्‍यन। ");
INSERT INTO new_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","इमिसं थथःगु कथि वांछ्वल अले व सर्प जुल। अय्‌नं हारूनया कथिं इमिगु कथियात नुनाबिल। ");
INSERT INTO new_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","फारोया नुगः झन छानाः वल। अले परमप्रभुं धयादी थें हे वं इमिगु खँ मन्‍यं। ");
INSERT INTO new_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","अले परमप्रभुं मोशायात धयादिल, “फारोया नुगः तसकं छाःगु दु। वं मनूतय्‌त वनेबी मखु। ");
INSERT INTO new_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","सुथय् न्‍हापां फारो खुसिपाखे वनीबलय् छ वयात नापलाः हुँ। वयात नापलायेत नील खुसिया सिथय् दनाच्‍वँ अले व सर्प जूगु कथि नं ज्‍वनाः हुँ। ");
INSERT INTO new_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","वयात थथे धा, ‘परमप्रभु हिब्रूतय् परमेश्‍वरं जितः थथे धकाः छिथाय् छ्वयाहयादीगु दु। जिमि मनूतय्‌त मरुभूमिइ जितः आराधना यायेत वनेब्‍यु। अय्‌नं छं आः तक नं जिं धयागु खँ मन्‍यं। ");
INSERT INTO new_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","परमप्रभुं थथे धयादी, जि परमप्रभु खः धकाः छं सी। स्‍व, जिं नील खुसिया लखय् थःगु कथिं दाये, अले व हि जुइ। ");
INSERT INTO new_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","खुसिइ च्‍वंपिं न्‍या सी, अले खुसि नवइ। मिश्रीतय्‌सं खुसिया लः त्‍वनेफइ मखु।’” ");
INSERT INTO new_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","परमप्रभुं मोशायात धयादिल, “थःगु कथि कयाः मिश्रय् च्‍वंगु फुक्‍क खुसि, पुखू, धलय् थःगु ल्‍हाः न्‍ह्यज्‍याकादिसँ धकाः हारूनयात धा। अले अन च्‍वंगु लः फुक्‍क हि जुइ। मिश्रय् फुक्‍क थासय् हिया हि जक जुइ। सिँ व ल्‍वहंया लःथलय् च्‍वंगु लः तकं हि जुइ।” ");
INSERT INTO new_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","अले मोशा व हारूनं परमप्रभुं धयादी थें हे यात। फारो व वया भारदारतय् न्‍ह्यःने वं थःगु कथि ल्‍ह्वनाः नील खुसिया लखय् दाल, अले फुक्‍क लः हि जुयावन। ");
INSERT INTO new_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नील खुसियापिं न्‍या सित। खुसि तसकं नवयाः मिश्रीतय्‌सं उकिया लः त्‍वने मफुत। मिश्रया फुक्‍क थासय् च्‍वंगु लः हि जुल। ");
INSERT INTO new_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","मिश्रया जादु क्‍यनिपिन्‍सं नं थःगु जादुनं अथे हे यात। अले परमप्रभुं धयादी थें फारोया नुगः छाना वन। वं मोशा व हारूनया खँ मन्‍यन। ");
INSERT INTO new_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","फारोनं थुकिया च्‍यूताः तकं मतसे थःगु लाय्‌कूपाखे लिहां वन। ");
INSERT INTO new_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","मिश्रयापिं फुक्‍कसिनं त्‍वनेगु लःया निंतिं नील खुसिया जवंखवं गाः म्‍हुल, छाय्‌धाःसा इमिसं खुसिया लः त्‍वने मफुत। ");
INSERT INTO new_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","परमप्रभुं नील खुसिया लखय् दाःगु न्‍हय्‌न्‍हु दय् धुंकल। ");
INSERT INTO new_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","हाकनं परमप्रभुं मोशायात धयादिल, “फारोयाथाय् वनाः वयात धा, ‘परमप्रभुं थथे धयादी, जिगु आराधना यायेत जिमि मनूतय्‌त वनेब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","छं इमित वने मबिल धाःसा जिं ब्‍यांचा छ्वयाहयाः छंगु देशयात सास्‍ती बी। ");
INSERT INTO new_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","नील खुसि ब्‍यांचां जाइ, अले इपिं छंगु लाय्‌कुलिइ, छ द्यनिगु क्‍वथाय्, छंगु लासाय्, छिमि भारदारतय्‌गु छेँय्, छिमि मनूतय्‌थाय्, छिमि भुतुलिइ व छुचुं न्‍हाइगु बाताचाय् तकं वइ। ");
INSERT INTO new_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ब्‍यांचा छ, छिमि मनूत व छिमि भारदारतय्‌गु म्‍हय् तकं थहां वइ।’” ");
INSERT INTO new_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","परमप्रभुं मोशायात हानं धयादिल, “हारूनयात धा, ‘थःगु कथि ज्‍वनाः खुसि, धः व पुखूपाखे क्‍यँ, अले मिश्र देश न्‍यंकं ब्‍यांचा हे ब्‍यांचां जाइ।’” ");
INSERT INTO new_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","हारूनं मिश्र देशय् च्‍वंगु फुक्‍क लःपाखे थःगु ल्‍हाः न्‍ह्यज्‍याकल, अले देशय् हे त्‍वपुक ब्‍यांचा पिहां वल। ");
INSERT INTO new_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","जादु क्‍यनिपिन्‍सं नं थःगु जादुनं अथे हे यानाः मिश्र देशय् न्‍यंक ब्‍यांचा पिकाल। ");
INSERT INTO new_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","अले फारोनं मोशा व हारूनयात सःतके छ्वयाः धाल, “परमप्रभुयात प्रार्थना यानाः फुक्‍क ब्‍यांचातय्‌त जि व जिमि मनूतय्‌थासं लित यंकि धा। अले परमप्रभुया निंतिं बां बीत छिमि मनूतय्‌त वनेबी।” ");
INSERT INTO new_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशां फारोयात धाल, “धयादिसँ, जिं गुबलय् छिथासं, छिगु छेँनं अले छिकपिनि मनू व भारदारतय्‌थासं ब्‍यांचा चिलावनेमा, नील खुसिइ जक ल्‍यनेमा धकाः प्रार्थना यायेगु?” ");
INSERT INTO new_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फारोनं धाल, “कन्‍हय्।” मोशां लिसः बिल, “छिं धयादी थें जुइमा। अले छिं परमप्रभु जिमि परमेश्‍वर थें जाःम्‍ह मेपिं सुं मदु धकाः सीकादी। ");
INSERT INTO new_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ब्‍यांचा छिथासं, छिगु छेँनं अले छिकपिनि मनू व भारदारतय्‌थासं मदयावनी, नील खुसिइ जक दयाच्‍वनी।” ");
INSERT INTO new_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","अनं लिपा मोशा व हारून फारोयाथासं पिहां वल। मोशां फारोयाथाय् छ्वयाहःपिं ब्‍यांचा मदय्‌का छ्वयादिसँ धकाः परमप्रभुयात इनाप यात। ");
INSERT INTO new_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","परमप्रभुं मोशां धाःथें यानादिल। अले छेँय्, चुकय् व ख्‍यलय् च्‍वंपिं ब्‍यांचा फुक्‍कं सित। ");
INSERT INTO new_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","मिश्रीतय्‌सं ब्‍यांचा मुनाः द्वँचिन। उकिं देशन्‍यंक तसकं नवल। ");
INSERT INTO new_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ब्‍यांचा स्‍यूगु खंबलय् परमप्रभुं धयादी थें हे हाकनं फारोनं थःगु नुगः छाय्‌कल, अले वं मोशा व हारूनयागु खँ मन्‍यन। ");
INSERT INTO new_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","परमप्रभुं मोशायात हानं धयादिल, “थःगु कथि कयाः बँय् च्‍वंगु धुलय् दायादिसँ धकाः हारूनयात धा, अले धू मिश्र न्‍यंकं भुयुपति जुयावनी।” ");
INSERT INTO new_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","इमिसं अथे हे यात। हारूनं कथि कयाः ल्‍हाः न्‍ह्यज्‍याकाः बँय् च्‍वंगु धुलय् दाल। अले मनूतय्‌त व पशुतय्‌त भुयुपतिं त्‍वपुवल। मिश्र देशय् च्‍वंगु धू फुक्‍कं भुयुपति जुल। ");
INSERT INTO new_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","जादु क्‍यनिपिन्‍सं नं थःगु जादुं भुयुपति दय्‌केगु कुतः यात, अय्‌नं इमिसं दय्‌के मफुत। अले मनूतय्‌त, पशुतय्‌त व न्‍ह्याथासं भुयुपतिं भुनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","अले जादु क्‍यनिपिन्‍सं फारोयात धाल, “थुकी ला परमेश्‍वरयागु हे ल्‍हाः दु।” अय्‌नं परमप्रभुं धयादी थें हे फारोया नुगः छानाच्‍वन। वं इमिगु खँ मन्‍यन। ");
INSERT INTO new_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","परमप्रभुं मोशायात धयादिल, “सुथय् न्‍हापां दनाः फारो खुसिपाखे वनीबलय् वया न्‍ह्यःने दं हुँ। वयात धा, ‘परमप्रभुं थथे धयादी, जिगु आराधना यायेत जिमि मनूतय्‌त वनेब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","छं जिमि मनूतय्‌त वने मबिल धाःसा जिं छन्‍थाय्, छिमि भारदारतय्‌थाय्, छिमि प्रजायाथाय् अले छंगु लाय्‌कुलिइ ग्‍वाः ग्‍वाः भुजिं छ्वयाहये। मिश्रीतय्‌गु छेँ पतिकं व इपिं च्‍वनीगु बँ तक नं भुजिंनं जाइ। ");
INSERT INTO new_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“‘जिं जिमि मनूत च्‍वनीगु गोशेन लागायात धाःसा अलग्‍ग तये, अन भुजिं दइ मखु। अले जि परमप्रभु थ्‍व देशय् दु धकाः छं सी। ");
INSERT INTO new_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","जिं थः मनू व छिमि मनूतय्‌त अलग्‍ग तयाबी। थ्‍व अजू चायापुगु ज्‍या कन्‍हय् हे जुइ।’” ");
INSERT INTO new_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","अले परमप्रभुं अथे हे यानादिल। फारोया लाय्‌कू, वया भारदारतय्‌गु छेँय् ख्‍वातुक भुजिंनं त्‍वपुल, अले मिश्र देशन्‍यंक हे भुजिंनं जाल। ");
INSERT INTO new_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","अले फारोनं मोशा व हारूनयात सःताः धाल, “छिमिसं वनाः थ्‍व हे देशय् थः परमेश्‍वरया निंतिं बां ब्‍यु।” ");
INSERT INTO new_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","मोशां धाल, “थथे यायेगु पाय्‌छि जुइ मखु। छाय्‌धाःसा परमप्रभु जिमि परमेश्‍वरया निंतिं जिमिसं छायेगु बलिं मिश्रीतय्‌त घौचाय्‌की। छुं जुयाः मिश्रीतय् न्‍ह्यःने जिमिसं थज्‍याःगु बां बिल धाःसा छु इमिसं जिमित ल्‍वहँतं कय्‌काः मस्‍याइ ला? ");
INSERT INTO new_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","जिपिं स्‍वन्‍हुया लँपु जुयाः मरुभूमिइ परमप्रभु थः परमेश्‍वरं उजं बियादी थें वय्‌कःया निंतिं बां बीत वनेमाः।” ");
INSERT INTO new_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","फारोनं धाल, “जिं छिमित मरुभूमिइ परमप्रभु छिमि परमेश्‍वरया निंतिं बां बीत वनेबी, तर यक्‍व तापाक्‍क धाःसा वने दइ मखु। आः जिगु निंतिं नं प्रार्थना या।” ");
INSERT INTO new_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मोशां लिसः बिल, “जि थनं वनेवं कन्‍हय् हे फारो व वया भारदार व वया मनूतय्‌थासं फुक्‍क भुजिं चिलावनेमा धकाः परमप्रभुयात प्रार्थना याये। अय्‌नं फारोनं मनूतय्‌त परमप्रभुया निंतिं बां बीत वने मब्‍यूसे हानं ध्‍वंलायेगु ज्‍या मयायेमा धयागु खँ पक्‍का जुयेमाः।” ");
INSERT INTO new_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","अले मोशां फारोयाथासं पिहां वयाः परमप्रभुयात प्रार्थना यात। ");
INSERT INTO new_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","परमप्रभुं मोशां धाःथें यानादिल। अले फारो, वया भारदारत व वया मनूतय्‌थासं भुजिं चिला वन। छम्‍ह हे भुजिं ल्‍यं मन्‍त। ");
INSERT INTO new_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","हाकनं फारोनं थःगु नुगः छाय्‌कल। अले मनूतय्‌त वने मबिल। ");
INSERT INTO new_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","अले परमप्रभुं मोशायात धयादिल, “फारोयात वनाः धा, ‘परमप्रभु हिब्रूतय् परमेश्‍वरं थथे धयादी, “जिमि मनूतय्‌त जिगु आराधना यायेत वनेब्‍यु।” ");
INSERT INTO new_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","छं इमित वने मब्‍यूसे पना तल धाःसा ");
INSERT INTO new_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","परमप्रभुया ल्‍हातं छिमि पशु, सल, गधा, ऊँट, सा द्वहं, फैच्‍वलय् फुक्‍कसिके महामारी वइ। ");
INSERT INTO new_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","तर परमप्रभुं इस्राएलीतय् पशु व मिश्रीतय् पशुतय्‌त अलग यानाबी। इस्राएलीतय् पशुत छम्‍ह नं सी मखु।’” ");
INSERT INTO new_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","परमप्रभुं थुकिया ई क्‍वःछिनाः धयादिल, “कन्‍हय् हे थ्‍व देशय् परमप्रभुं थथे यानादी।” ");
INSERT INTO new_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","कन्‍हय् खुन्‍हु हे परमप्रभुं थथे यानादिल। मिश्रीतय् फुक्‍कं पशु सित, इस्राएलीतय् पशु धाःसा छम्‍ह हे मसी। ");
INSERT INTO new_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फारोनं अन छु जुल धकाः स्‍वयेत मनूत छ्वल। इमिसं इस्राएलीतय् पशु छम्‍ह हे मसीगु खन। अय्‌नं फारोया नुगः छाना हे च्‍वन, वं मनूतय्‌त वने मब्‍यू। ");
INSERT INTO new_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","परमप्रभुं मोशा व हारूनयात धयादिल, “छिपिं निम्‍हय्‌सिनं अगलं छम्‍हू छम्‍हू हाकःचुं का, अले मोशां उकियात फारोया न्‍ह्यःने आकाशपाखे ह्वलाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","अले थ्‍व नचुगु धू जुयाः मिश्र देय्‌न्‍यंक न्‍यनावनी। अले थुकिं मिश्रय् च्‍वंपिं फुक्‍क मनू व पशुतय्‌गु म्‍हय् कै पिचाय्‌की।” ");
INSERT INTO new_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","उकिं इपिं अगलय् च्‍वंगु हाकःचुं कयाः फारोया न्‍ह्यःने वन। मोशां उकियात आकाशपाखे ह्वलाबिल। अले थुकिं मनूत व पशुतय्‌गु म्‍हय् कै पिचाय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","कै पिचाःगुलिं जादु क्‍यनिपिं मोशाया न्‍ह्यःने दनाच्‍वने मफुत छाय्‌धाःसा सकल मिश्रीतय्‌गु म्‍हय् थें इमिगु म्‍हय् नं कै पिचाःगु खः। ");
INSERT INTO new_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","परमप्रभुं फारोया नुगः अझ छाय्‌कादिल। अले परमप्रभुं मोशायात धयादी थें वं इमिगु खँ मन्‍यन। ");
INSERT INTO new_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","परमप्रभुं मोशायात धयादिल, “सुथय् न्‍हापां दनाः फारोया न्‍ह्यःने हुँ अले वयात धा, ‘हिब्रूतय् परमप्रभु परमेश्‍वरं थथे धयादी, जिगु आराधना यायेत जिमि मनूतय्‌त वनेब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","मखुसा थ्‍वपालय् जिं छन्‍थाय्, छिमि भारदारतय्‌थाय् व छिमि प्रजायाथाय् तसकं तःधंगु महामारी छ्वयाहये। अले छं थ्‍व पृथ्‍वी न्‍यंक जि थें ज्‍याःम्‍ह मेम्‍ह सुं हे मदु धकाः सी। ");
INSERT INTO new_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","जिं थःगु ल्‍हाः न्‍ह्यज्‍याकाः छन्‍त व छिमि प्रजायात महामारीं कय्‌कूगु जूसा छ पृथ्‍वीं हे नाश जुयावने धुंकल जुइ। ");
INSERT INTO new_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","अय्‌नं जिगु शक्ति क्‍यनेत व पृथ्‍वीइ न्‍यंक जिगु नां कायेमा धकाः हे जिं छन्‍त म्‍वाकातयागु खः। ");
INSERT INTO new_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","छं आः तक नं तःधंछुयाः जिमि मनूतय्‌त वने ब्‍यूगु मखु। ");
INSERT INTO new_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","उकिं जिं कन्‍हय् थ्‍व हे इलय् तसकं बांमलाक प्‍वँ गाय्‌काबी। मिश्र देश दय्‌कूबलय्‌निसें आः तक नं थन थुकथं प्‍वँ गाःगु दइ मखुनि। ");
INSERT INTO new_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","आः हे ख्‍यलय् दुपिं पशुत, मनूत व ज्‍वलं फुक्‍क काय्‌के छ्व, मखुसा प्‍वँ दायाः पिनेलाःपिं मनूत व पशुत फुक्‍कं सी।’” ");
INSERT INTO new_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","परमप्रभुया खँ न्‍यनाः ग्‍याःपिं फारोया गुलिं गुलिं भारदारतय्‌सं थःपिनि च्‍यःतय्‌त व पशुतय्‌त दूत यंकल। ");
INSERT INTO new_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","परमप्रभुयागु वचनयात वास्‍ता मयाःपिन्‍सं धाःसा थःपिनि च्‍यःतय्‌त व पशुतय्‌त ख्‍यलय् हे त्‍वःतातल। ");
INSERT INTO new_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","परमप्रभुं मोशायात धयादिल, “थःगु ल्‍हाः आकाशपाखे ल्‍ह्वँ, अले मिश्र देय्‌न्‍यंक प्‍वँ गाइ। मिश्रयापिं फुक्‍क मनू, पशु व बुँइ बुयावःगु फुक्‍क माय् प्‍वँ गाइ।” ");
INSERT INTO new_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","अले मोशां थःगु कथि आकाशपाखे ल्‍ह्वन, परमेश्‍वरयागु शक्तिं आकाशय् नँ न्‍यात, प्‍वँ गात, अले पृथ्‍वीइ मलः जुत। थुकथं परमप्रभुं मिश्र देशय् प्‍वँवा गाय्‌कादिल। ");
INSERT INTO new_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","प्‍वँनापं मलः नं जुनाः च्‍वन। मिश्र देश पलिस्‍था जूसांनिसें थथे प्‍वँ गाःगु मदुनि। ");
INSERT INTO new_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","मिश्र देय्‌न्‍यंक ख्‍यलय् दुपिं मनूत व पशुत फुक्‍कं प्‍वँ दायाः सित। बुँयागु फुक्‍क बाली स्‍यन, सिमात क्‍वदल। ");
INSERT INTO new_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","इस्राएलीत च्‍वनाच्‍वंगु गोशेन धाःगु थासय् जक प्‍वँ मगाः। ");
INSERT INTO new_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","अले फारोनं मोशा व हारूनयात सःताः धाल, “थ्‍वपालय् जिं पाप यानागु दु, परमप्रभु धर्मीम्‍ह खः, जि व जिमि मनूत धाःसा अधर्मी खः। ");
INSERT INTO new_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","मलः जूगु व प्‍वँ गाःगु अप्‍वः जुइ धुंकल। आः परमप्रभुयात इनाप या। जिं छिमित वनेबी, छिमित पने मखु।” ");
INSERT INTO new_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशां वयात धाल, “शहरं पिहां वनेवं जिं परमप्रभुपाखे थःगु ल्‍हाः ल्‍ह्वने। अले नँ न्‍यायेगु व प्‍वँ गायेगु दी। थुकिं पृथ्‍वी परमप्रभुयागु हे खः धकाः छिं सी। ");
INSERT INTO new_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","अय्‌नं जिं स्‍यू, छिं व छिकपिनि भारदारतय्‌सं अज्‍ज नं परमप्रभु परमेश्‍वरयागु ग्‍याःभय मकाःनि।” ");
INSERT INTO new_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","अजिल स्‍वां व तछ्व बाली भज्‍यंक स्‍यन। छाय्‌धाःसा तछ्व बाली बुइ धुंकूगु व अजिल स्‍वां ह्वयेधुंकूगु खः। ");
INSERT INTO new_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","छ्वबालि धाःसा बुयाः मवःगुलिं छुं मजू। ");
INSERT INTO new_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","अले मोशा फारोयात त्‍वःताः शहरं पिने वन। वं थःगु ल्‍हाः परमप्रभुपाखे ल्‍ह्वन। अले नँ न्‍यायेगु, प्‍वँ गायेगु व वा वयेगु फुक्‍कं दित। ");
INSERT INTO new_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","फारोनं वा वयेगु, प्‍वँ गायेगु व नँ न्‍यायेगु द्युसेंलि हाकनं पापयात। वं व वया भारदारतय्‌सं थःपिनिगु नुगः छाय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","उकिं फारोया नुगः झन छात, अले परमप्रभुं मोशायात धयादी थें वं इस्राएलीतय्‌त वने मबिल। ");
INSERT INTO new_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","परमप्रभुं मोशायात धयादिल, “फारोयाथाय् हुँ, इमिगु दथुइ जिं थःगु अजू चायापुगु चिं क्‍यनेत हे जिं वयागु व वया भारदारतय्‌गु नुगः छाय्‌काबियागु खः। ");
INSERT INTO new_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","अले जिं गथे यानाः मिश्रीतय्‌त हेस्‍यानाः इमिगु दथुइ गज्‍याः गज्‍याःगु अजू चायापुगु चिं क्‍यना, छं थः काय्‌पिन्‍त व छय्‌पिन्‍त कँ। अले छिमिसं जि हे परमप्रभु खः धकाः सी।” ");
INSERT INTO new_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","उकिं मोशा व हारूनं वनाः फारोयात धाल, “हिब्रूतय् परमप्रभु परमेश्‍वरं थथे धयादी, ‘गुबलय् तक छ जिगु खँ मन्‍यंसे च्‍वनेगु? जिमि मनूतय्‌त जिगु आराधना यायेत वनेब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","छं जिमि मनूतय्‌त वने मबिल धाःसा जिं कन्‍हय् हे छंगु देशय् क्‍वःबुइँचात छ्वयाहये। ");
INSERT INTO new_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","इमिसं खने हे मदयेक बँयात त्‍वपुयाबी। प्‍वँ गाये धुंकाः ल्‍यं दुगु फुक्‍कं इमिसं नयाबी, अले गुँइच्‍वंगु फुक्‍क सिमासामा नं नयाबी। ");
INSERT INTO new_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","छंगु लाय्‌कू, छं भारदारतय्‌गु व फुक्‍क मिश्रीतय्‌गु छेँय् क्‍वःबुइँचातय्‌सं जाइ। छिमि बौ बाज्‍यापिन्‍सं पृथ्‍वीइ दुबलय्‌निसें थौं तक थथे जूगु खंगु मदुनि।’” अले मोशा फहिलाः फारोयाथासं पिहां वन। ");
INSERT INTO new_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फारोया भारदारतय्‌सं वयात धाल, “गुबलय् तक थ्‍व मनुखं झीत दुःख बियाच्‍वनीगु खः? वया मनूतय्‌त इमि परमप्रभु परमेश्‍वरया आराधना यायेत वनेबियादिसँ। छिं आः तक नं मिश्र देश गुलि स्‍यने धुंकल धयागु मस्‍यूनि ला?” ");
INSERT INTO new_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","अले मोशा व हारूनयात फारोयाथाय् हानं ब्‍वनाहल। वं इमित धाल, “छिपिं थः परमेश्‍वरया आराधना याः हुँ। अय्‌नं सु सु वनेगु खः?” ");
INSERT INTO new_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशां धाल, “जिपिं थः मचाखाचा, ल्‍यासे ल्‍याय्‌म्‍ह, बुराबुरी, फैच्‍वलय्, सा द्वहं दक्‍वं ज्‍वनाः वनेगु खः। छाय्‌धाःसा जिमिसं परमप्रभुया निंतिं नखः हनेमाः।” ");
INSERT INTO new_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फारोनं धाल, “छिमि परमप्रभु छिपिंलिसे हे दयेमा। जिं छिपिंनापं मस्‍त व मिस्‍त वनेबी हे मखु। छिमिगु मति मभिंगु खने दु। ");
INSERT INTO new_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","अहं, थथे जुइ फइ मखु। छिपिं मिजंत जक वनाः परमप्रभुयागु आराधना या। छिमिसं थ्‍व हे फ्‍वंगु खः।” अले मोशा व हारूनयात फारोयाथासं पितिनाछ्वत। ");
INSERT INTO new_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","अले परमप्रभुं मोशायात धयादिल, “थःगु ल्‍हाः मिश्र देशया च्‍वय् न्‍ह्यज्‍याकि, अले क्‍वःबुइँचात वयाः प्‍वँ गाये धुंकाः मिश्र देशय् ल्‍यं दुगु बुँइ सयाच्‍वंगु फुक्‍कं नयाबी।” ");
INSERT INTO new_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","मोशां थःगु कथियात मिश्रया च्‍वय् ल्‍ह्वन। अले परमप्रभुं उखुन्‍हु न्‍हिच्‍छि व चच्‍छि देय्‌न्‍यंक पुर्बं फय् वय्‌कादिल। कन्‍हय् सुथय् व फसं क्‍वःबुइँचात हल। ");
INSERT INTO new_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","क्‍वःबुइँचात मिश्र देश हे त्‍वपुक्‍क वल, अले देशया फुक्‍क थासय् च्‍वन। थुकथं क्‍वःबुइँचात मिश्र देशय् वःगु न न्‍हापा हे दु, न लिपा हे वइ। ");
INSERT INTO new_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","फुक्‍क बँ हे हाक्‍कुसे च्‍वंक इमिसं त्‍वपुल। इमिसं प्‍वँ गाये धुंकाः ल्‍यं दुगु बाली व सिमाय् च्‍वंगु फल फुक्‍कं नयाबिल। मिश्र देशय् गनं हे वाउँगु धयागु मन्‍त। ");
INSERT INTO new_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","अले फारोनं हथासं मोशा व हारूनयात सःतके छ्वल। अले वं धाल, “जिं छिमि परमप्रभु परमेश्‍वरयागु व छिमिगु विरोधय् हाकनं पाप यानागु दु। ");
INSERT INTO new_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","उकिं जिगु पापयात हानं छकः क्षमा यानाब्‍यु। अले परमेश्‍वरयात थ्‍व महामारीयात जिथासं चीकाबीत प्रार्थना या।” ");
INSERT INTO new_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","अले मोशां फारोयाथासं वनाः परमप्रभुयात प्रार्थना यात। ");
INSERT INTO new_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","अले परमप्रभुं फय्‌यात हीकाः पच्‍छिमं तसकं फय् वय्‌कादिल। व फसं दक्‍व क्‍वःबुइँचातय्‌त लाल समुद्रय् ब्‍वय्‌का यंकल। अले मिश्रया गनं हे छम्‍ह हे क्‍वःबुइँचा ल्‍यं मन्‍त। ");
INSERT INTO new_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","परमप्रभुं अज्‍ज नं फारोयागु नुगः छाय्‌कादिल। वं इस्राएलीतय्‌त वने मब्‍यू। ");
INSERT INTO new_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","परमप्रभुं मोशायात धयादिल, “थःगु ल्‍हाः आकाशपाखे न्‍ह्यज्‍याकि। अले मिश्र न्‍यंक खिउँसे च्‍वनेमा। ल्‍हातिं थी फइ थें च्‍वंक क्‍वात्तुक खिउँसे च्‍वनेमा।” ");
INSERT INTO new_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","अले मोशां थःगु ल्‍हाः आकाशपाखे न्‍ह्यज्‍याकल। मिश्र देय्‌न्‍यंक स्‍वन्‍हु तक तसकं खिउँसे च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","स्‍वन्‍हु तक सुनानं सुयातं खंके मखुत। अले सुं नं मिश्रीत थःगु थाय् त्‍वःताः तकं वने मफुत। इस्राएलीत च्‍वनाच्‍वंगु थाय् धाःसा खिउँसे मच्‍वं। ");
INSERT INTO new_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","अले फारोनं मोशायात सःतके छ्वयाः धाल, “छिपिं छिमि थः मिसात व मचाखाचा ज्‍वनाः परमप्रभुया आराधना याः हुँ। पशुत धाःसा छिमिसं यंके मते।” ");
INSERT INTO new_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","मोशां धाल, “परमप्रभु जिमि परमेश्‍वरया निंतिं बां बीत छिं जिमित मेलबलि व होमबलियाम्‍ह पशु नं बियादिमाः। ");
INSERT INTO new_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","जिमिसं हयापिं पशुत नं जिपिंनापं हे वनी। छम्‍ह हे त्‍वःतावने मज्‍यू। इपिं मध्‍ये हे छम्‍हय्‌सित जिमिसं परमप्रभु जिमि परमेश्‍वरयात छायेत ल्‍ययेमाः। अन जक जिमिसं परमप्रभुया आराधनाया निंतिं छु छु माः धकाः सी।” ");
INSERT INTO new_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","परमप्रभुं अज्‍ज नं फारोया नुगः छाय्‌कादिल। वं इमित वने मब्‍यू। ");
INSERT INTO new_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","फारोनं मोशायात धाल, “जिथासं वना हे छ्व। जिगु न्‍ह्यःने हानं खनेदय्‌कः वये मते। गुखुन्‍हु छं जिगु ख्‍वाः खनी उखुन्‍हु हे छ सी।” ");
INSERT INTO new_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मोशां धाल, “छिं धयादी थें हे जि हानं छिगु न्‍ह्यःने खनेदय्‌कः वये मखुत।” ");
INSERT INTO new_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","अले परमप्रभुं मोशायात धयादिल, “मेगु छगू महामारी जिं फारोयाथाय् व मिश्रय् हये। अनं लिपा वं छिमित थनं वनेबी। वं छिमित धात्‍थें हे थनं पितिनाछ्वइ। ");
INSERT INTO new_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","मिजंत व मिसात फुक्‍कसित थः जःलाखःलापिन्‍के लुँ व वहःया तिसा फ्‍वँ धा।” ");
INSERT INTO new_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","परमप्रभुं मिश्रीतय्‌त इस्राएलीतप्रति बांलाःगु व्‍यवहार याइपिं यानादिल। अले मोशा फारोया भारदारतय्‌गु व मिश्रीतय्‌गु मिखाय् तःधंम्‍ह मनू जुल। ");
INSERT INTO new_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","वने न्‍ह्यः मोशां फारोयात धाल, “परमप्रभुं थथे धयादी, ‘बाचा इलय् जि मिश्र देशय् जुयाः वने। ");
INSERT INTO new_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","मिश्रय् न्‍हापां बूपिं काय्‌पिं फुक्‍कं सी। गद्दीइ च्‍वनीम्‍ह फारोया न्‍हापां बूम्‍ह काय्‌निसें घः क्‍यलीम्‍ह दासी मिसाया न्‍हापां बूम्‍ह काय् तकं। अले पशुतय् तकं न्‍हापां बूपिं दक्‍वं सी। ");
INSERT INTO new_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","मिश्र देय्‌न्‍यंक हाहाकार जुइ। थुबलय् थें न्‍हापा गुबलें जूगु मदुनि, लिपा गुबलें जुइ नं मखु। ");
INSERT INTO new_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","इस्राएलीतय्‌गु दथुइ पशु वा मनूतय्‌गु विरोधय् खिचा छम्‍ह नं उइ मखु।’ थुकिं छिमिसं परमप्रभुं इस्राएलीत व मिश्रीतय्‌त पाकादी धकाः सी। ");
INSERT INTO new_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","अले छिमि फुक्‍क भारदारत वयाः जितः भागियानाः धाइ, ‘छिगु ल्‍यूल्‍यू जुइपिं फुक्‍कसित ब्‍वनाः छि थनं पिहां झासँ।’ अले जि थनं पिहां वने।” अनंलि मोशा तसकं तं पिकयाः फारोयाथासं वन। ");
INSERT INTO new_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","परमप्रभुं मोशायात धयादीगु दु, “मिश्रय् जिं थःगु अजू चायापुगु ज्‍या झन अप्‍वः याये फय्‌केत फारोनं छंगु खँ न्‍यनी मखु।” ");
INSERT INTO new_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मोशा व हारूनं फारोया न्‍ह्यःने थज्‍याःगु अजू चायापुगु ज्‍या फुक्‍क यानाक्‍यन, अय्‌नं परमप्रभुं फारोया नुगः छाय्‌कादिल। अले वं इमित थःगु देशं वने मबिल। ");
INSERT INTO new_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","मिश्र देशय् परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“थ्‍व ला छिमिगु निंतिं दँया न्‍हापांगु ला जुइ। ");
INSERT INTO new_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","इस्राएलीतय् फुक्‍क खलःयात थथे धा, थ्‍व लाया झिन्‍हु दुखुन्‍हु छिपिं फुक्‍कसिनं थथःगु परिवारया निंतिं छम्‍ह छम्‍ह चिधिकःम्‍ह भ्‍याःचा हयेमाः। ");
INSERT INTO new_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","सुयागुं परिवारय् छम्‍ह चिधिकःम्‍ह भ्‍याःचा नयेत मनूत कम जूसा वं थः छेँया सतिक च्‍वंम्‍ह जःलाखःलालिसे मिलय् जुयाः मनूतय्‌गु ल्‍याःकथं चिधिकःम्‍ह भ्‍याःचा हयेमाः। सुनां गुलि नयेफु, व हे ल्‍याखं ग्‍वःम्‍ह चिधिकःम्‍ह भ्‍याःचा माः क्‍वःछ्यु। ");
INSERT INTO new_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","चिधिकःम्‍ह भ्‍याःचा ल्‍ययेबलय् छिमिसं खू मदुम्‍ह, दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा ल्‍ययेमाः। च्‍वलेचा व फैया दथुं ल्‍ययेमाः। ");
INSERT INTO new_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“लाया झिंप्‍यन्‍हु खुन्‍हु तक चिधिकःम्‍ह भ्‍याःचायात बांलाक बिचाः यानाः ति। थ्‍वखुन्‍हु हे इस्राएलया फुक्‍क मनूत जानाः सन्‍ध्‍याकाः इलय् चिधिकःम्‍ह भ्‍याःचायात स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","अले चिधिकःम्‍ह भ्‍याःचाया हि कयाः भ्‍वय् नइगु छेँया लुखाया जवंखवं व फुसय् इलाबीमाः। ");
INSERT INTO new_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","उखुन्‍हु हे चान्‍हय् छिमिसं चिधिकःम्‍ह भ्‍याःचाया ला मिइ छुयाः खायुगु वाउँचा व सोडा मतःगु मरिनापं नयेमाः। ");
INSERT INTO new_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","लायात कचिकं नये मते, अले लखय् दय्‌काः नं नये मते। छ्यं तुति, म्‍ह दुने च्‍वंगु ला फुक्‍कं मिइ छुयाः न। ");
INSERT INTO new_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","सुथय् जुइ न्‍ह्यः ला फुक्‍कं फुकेमाः, ला ल्‍यं दुसा व ला फुक्‍कं मिइ छ्वय्‌का छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“छिमिसं थ्‍व ला नयेबलय् छिमिगु जँय् जँनी, तुतिइ लाकां व ल्‍हातिइ कथि दयेमाः। अले व हथासं नयेमाः। थ्‍व हे परमप्रभुया छुत्‍काराया नखः खः। ");
INSERT INTO new_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“उखुन्‍हु हे चान्‍हय् जि मिश्र जुयाः वने। अले मिश्रया न्‍हापां बूपिं मनूत व पशुत फुक्‍कं स्‍यानाबी। मिश्रया फुक्‍क द्यःतय्‌त सजाँय बी। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","हि इलातःगु छेँ छिपिं च्‍वनाच्‍वंगु छेँया चिं जुइ। व स्‍वयाः जिं छिमित त्‍वःताबी। जिं मिश्र देशयापिं मनूतय्‌त स्‍याइबलय् छिमित छुं जुइ मखु।” ");
INSERT INTO new_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“थ्‍व दिं छिमिगु निंतिं लुमन्‍तिया दिं जुइ। थ्‍वखुन्‍हु छिमिसं परमप्रभुया नखः हनेमाः। थ्‍व छिमित पुस्‍तां पुस्‍ता तकया निंतिं नियम जुल। ");
INSERT INTO new_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","न्‍हय्‌न्‍हु तक छिमिसं सोडा मतःगु मरि नयेमाः। न्‍हापांगु दिंखुन्‍हु छिमिसं थथःगु छेँनं सोडा वांछ्वयेमाः। सुनानं थ्‍व न्‍हय्‌न्‍हुया दुने सोडा तयातःगु छुं नं नल धाःसा वयात इस्राएली मनूतपाखें पितिनाछ्वइगु जुइ। ");
INSERT INTO new_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","न्‍हापांगु दिंखुन्‍हु व न्‍हय्‌न्‍हु खुन्‍हु परमप्रभुया आराधना यायेत पवित्र मुंज्‍या या। उखुन्‍हु छिमिसं नसात्‍वँसा दय्‌केगु ज्‍या त्‍वःताः मेगु छुं हे ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“छिमिसं सोडा मतःगु मरिया नखः हँ। छाय्‌धाःसा थ्‍वखुन्‍हु हे जिं छिमित पुचः पुचः यानाः मिश्रं पित हयागु खः। लिपा वइगु फुक्‍क पुस्‍ताय्‌ सदांया नियमकथं थ्‍व दिंयात हनेगु या। ");
INSERT INTO new_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","न्‍हापांगु लाया झिंप्‍यन्‍हु खुन्‍हुया बहनिनिसें निइछन्‍हु खुन्‍हुया बहनि तक सोडा मतःगु मरि न। ");
INSERT INTO new_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","न्‍हय्‌न्‍हु तक छिमिगु छेँय् सोडा दुगु मरि मदयेमाः। सुनां नं सोडा दुगु छुं नल धाःसा इस्राएली जूसां विदेशी जूसां वयात इस्राएलया खलकं पितिनाछ्वइगु जुइ। ");
INSERT INTO new_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","छिमिसं सोडा तयातःगु छुं नं नये मते। छिमिसं न्‍ह्याथाय् च्‍वंसां सोडा मतःगु मरि नयेमाः।” ");
INSERT INTO new_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","अले मोशां इस्राएलया फुक्‍क थकालितय्‌त सःतके छ्वयाः धाल, “छिमिसं वनाः थः छेँजःपिनिगु निंतिं भ्‍याःचा ल्‍ययाः छुत्‍काराया नखःया निंतिं स्‍या।” ");
INSERT INTO new_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","हिसप घाँय्‌मायात प्‍वाँय् चिनाः उकियात हिइ थुनाः लुखाया जवंखवं व फुसय् इलाब्‍यु। छिपिं सुं नं थःपिनिगु छेँनं सुथय् मजुतले पिहां वने दइ मखु। ");
INSERT INTO new_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","परमप्रभु मिश्रीतय्‌त स्‍यायेत मिश्र जुया झाइबलय् गुगु लुखाया जवंखवं व फुसय् हि इलातःगु खनी वय्‌कलं उगु लुखायात त्‍वःताः न्‍ह्यज्‍यानादी। अले नाश यायेत छ्वया हःम्‍हय्‌सित छिमित स्‍यायेत छिमिगु छेँय् दुहां वनेबी मखु। ");
INSERT INTO new_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“छिमिसं थ्‍वयात थः व थः सन्‍तानया निंतिं न्‍ह्याबलेंया नियमकथं मानय् या। ");
INSERT INTO new_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","परमप्रभुं बी धयादीगु देशय् दुहां वने धुंकाः नं छिमिसं थ्‍व नखः हँ। ");
INSERT INTO new_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","छिमि काय् म्‍ह्याय्‌पिन्‍सं छिमित ‘थ्‍व नखःया मतलब छु’ धकाः न्‍यन धाःसा ");
INSERT INTO new_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","इमित धा, ‘थ्‍व परमप्रभुया छुत्‍काराया नखःया पशु बां बीगु खः। वय्‌कलं मिश्रय् न्‍हापां बूपिन्‍त स्‍याःबलय् इस्राएलीतय्‌गु छेँय् दुहां मवंसे झीत व झीगु छेँयात बचय् यानादीगु खः।’” अले मनूतय्‌सं छ्यं क्‍वछुकाः आराधना यात। ");
INSERT INTO new_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","अले इस्राएलीतय्‌सं परमप्रभुं मोशा व हारूनयात उजं बियादी थें हे यात। ");
INSERT INTO new_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","चान्‍हय्‌सिया बाचा इलय् सिंहासनय् च्‍वंम्‍ह फारोया न्‍हापां बूम्‍ह काय्‌निसें झ्‍यालखानाय् च्‍वंम्‍ह कैदीया न्‍हापां बूम्‍ह काय् तकं, अले पशुतय् न्‍हापां बूपिं फुक्‍कसित परमप्रभुं स्‍यानादिल। ");
INSERT INTO new_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","मिश्र न्‍यंक तसकं हाहाकार जुल। फारो, वया भारदारत व मिश्रीत सकलें चान्‍हय् दन, छाय्‌धाःसा अन मनू मसी धयागु छखा छेँ हे मदु। ");
INSERT INTO new_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","फारोनं चान्‍हय् हे मोशा व हारूनयात सःतके छ्वयाः धाल, “छिपिं व छिमि इस्राएलीत फुक्‍कं जिमिगु देशं पिहां हुँ। वनाः छिमिसं धाःकथं हे परमप्रभुया आराधना या। ");
INSERT INTO new_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","छिमिसं धाःकथं हे थःपिनि फैच्‍वलय्, सा द्वहं फुक्‍कं ज्‍वनाः हुँ। अले जितः नं आशिष ब्‍यु।” ");
INSERT INTO new_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","अले मिश्रीतय्‌सं इस्राएलीतय्‌त थत्‍थें देश त्‍वःताब्‍यु धकाः बिन्‍ति यात। इमिसं धाल, “मखुसा जिपिं फुक्‍कं सी।” ");
INSERT INTO new_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","उकिं इस्राएलीतय्‌सं थःपिन्‍सं न्‍हायाच्‍वंगु छ्वचुं सोडा तये न्‍ह्यः हे थल नापं कापतय् प्‍वःचिनाः ब्‍वहलय् पाछाल। ");
INSERT INTO new_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","इस्राएलीतय्‌सं मोशां धाःथें यात। इमिसं मिश्रीतय्‌के लुँ, वहः, तिसा व वसः फ्‍वन। ");
INSERT INTO new_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","अले परमप्रभुं मिश्रीतय्‌त इस्राएलीतप्रति बांलाःगु व्‍यवहार याइपिं यानादिल। इमिसं छु छु फ्‍वन, मिश्रीतय्‌सं दक्‍वं बिल। थुकथं इस्राएलीतय्‌सं मिश्रीतय्‌गु धन ज्‍वनाः वइ। ");
INSERT INTO new_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इस्राएलीत रामसेसंनिसें सुक्‍कोत तक न्‍यासि वन, मिस्‍त व मस्‍त त्‍वःताः खुगू लाख ति मनूत दु। ");
INSERT INTO new_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","इपिं नापं मेपिं मनूत नं यक्‍व हे वन, अले यक्‍व सा द्वहं, फैच्‍वलय् नं वन। ");
INSERT INTO new_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","इमिसं सोडा मतसे हे मिश्रं ज्‍वनावःगु न्‍हायातःगु छ्वचुंया मरि छुल। मिश्रं हथासं पितछ्वयाहःगुलिं इमिसं न्‍हायातःगु छ्वचुंया मरि दय्‌के मलाःगु खः। ");
INSERT INTO new_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएलीत मिश्रय् च्‍वनाच्‍वंगु प्‍यसः व स्‍विदँ दये धुंकल। ");
INSERT INTO new_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","प्‍यसः व स्‍विदँ लिपा उखुन्‍हु हे परमप्रभुया फुक्‍क मनूतय्‌सं मिश्र देश त्‍वःतल। ");
INSERT INTO new_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","उखुन्‍हु चान्‍हय् हे परमप्रभुं इस्राएलीतय्‌त मिश्र देशं पित हया थःगु बचं पूवंकादिल। उकिं व चा वय्‌कःया निंतिं हनेमाः। थ्‍व परमप्रभुयागु चा खः। थुकियात पुस्‍तां पुस्‍ता तक इस्राएलीतय्‌सं हनेमाः। ");
INSERT INTO new_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","परमप्रभुं मोशा व हारूनयात धयादिल, “छुत्‍काराया नखःया विधि थुकथं दु, सुं विदेशीं थ्‍व नखःया भ्‍वय् नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","न्‍यानाहःम्‍ह दासं धाःसा म्‍हय् चिं तये धुंकाः नयेफु। ");
INSERT INTO new_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","अय्‌नं विदेशीं व ज्‍यामितय्‌सं थ्‍व भ्‍वय् नयेदइ मखु। ");
INSERT INTO new_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“भ्‍वय् ज्‍वरय् याःगु थासय् हे व फुक्‍क नयाः सिधय्‌केमाः। व छेँनं ला छकू नं पित हये मज्‍यू। व भ्‍वय्‌या निंतिं स्‍याःम्‍ह पशुया क्‍वँय् छकू नं त्‍वःथुले मज्‍यू। ");
INSERT INTO new_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्राएलया फुक्‍क मनूतय्‌सं थ्‍व नखः हनेमाः। ");
INSERT INTO new_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“छिपिंनापं च्‍वनाच्‍वंपिं पिनेयापिं मनूतय्‌सं परमप्रभुया छुत्‍काराया नखः हनेगु मनंतुन धाःसा इमि फुक्‍क मिजं मनूतय्‌सं म्‍हय् चिं तयेमाः। अले इमिसं नं अन हे बूपिन्‍सं थें नखः हने फइ। म्‍हय् चिं मतःपिन्‍सं थ्‍व भ्‍वय् नयेदइ मखु। ");
INSERT INTO new_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","नियम धाःसा अन हे च्‍वंपिं व पिनें वयाच्‍वंपिं निखलःयात नं छगू हे जुइ।” ");
INSERT INTO new_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","परमप्रभुं मोशा व हारूनयात उजं बियादी थें इस्राएलीतय्‌सं यात। ");
INSERT INTO new_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","परमप्रभुं उखुन्‍हु हे इस्राएलीतय्‌त इमिगु पुचः पुचः यानाः मिश्र देशं पितहयादिल। ");
INSERT INTO new_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“न्‍हापां बूम्‍ह इस्राएली काय्‌मचायात जिगु निंतिं फ्‍या। न्‍हापां बूम्‍ह मिजंमचा जिम्‍ह हे जुइ। छिमिसं न्‍हापां बूम्‍ह मिजंम्‍ह पशुयात नं जिगु निंतिं फ्‍या।” ");
INSERT INTO new_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","अले मोशां मनूतय्‌त धाल, “छिमिसं परमप्रभुं थःगु शक्तिं जाःगु ल्‍हातं छिमित छिपिं दास जुयाच्‍वंगु मिश्र देशं पित हयादीगु थ्‍व दिंयात लुमंका ति। थ्‍वखुन्‍हु सोडा तयातःगु छुं नं नये मते। ");
INSERT INTO new_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","छिपिं पिहां वंगु आबीब लाया थ्‍वखुन्‍हुयात लुमंकि। ");
INSERT INTO new_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","परमप्रभुं छिमि तापाःबाज्‍यापिन्‍त बी धयातःगु कनानी, हित्ती, एमोरी, हिव्‍वी व यबूसीतय्‌गु दुरु व कस्‍ति बाः वयाच्‍वंगु देशय् छिमित यंकादीधुंकाः नं थ्‍व हे लाय् छिमिसं थ्‍व नखः हँ। ");
INSERT INTO new_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","न्‍हय्‌न्‍हु तक छिमिसं सोडा मदुगु मरि न, अले न्‍हय्‌न्‍हु खुन्‍हु परमप्रभुया आराधना यायेत मुंज्‍या यानाः भ्‍वय् न। ");
INSERT INTO new_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","न्‍हय्‌न्‍हुयंकं छिमिसं सोडा मदुगु मरि जक नयेमाः। अले छिमिगु देशय् सोडा व सोडा दुगु छुं नं खने तकं मदयेमाः। ");
INSERT INTO new_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","उखुन्‍हु छिमिसं थःकाय्‌यात धा, ‘जि मिश्रं पिहां वयाबलय् परमप्रभुं जिगु निंतिं छु छु यानादिल, व हे जिं यानागु खः।’ ");
INSERT INTO new_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","परमप्रभुया व्‍यवस्‍था छिमिगु म्‍हुतुइ दयेमा धकाः थ्‍व छिमिगु ल्‍हातिइ व कपालय् लुमंकाबीगु चिं थें जुइ, छाय्‌धाःसा परमप्रभुं थःगु शक्तिं जाःगु ल्‍हातिं छिमित मिश्र देशं पित हयादीगु खः। ");
INSERT INTO new_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","थ्‍व हे नखः दँय्‌दसं क्‍वःछिनातःगु इलय् हनेगु या। ");
INSERT INTO new_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“छिपिं व छिमि पुर्खालिसें पाःफयादी थें परमप्रभुं छिमित कनानीतय्‌गु देशय् हयाः व देश छिमित बीधुंकाः ");
INSERT INTO new_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","छिमिसं न्‍हापां बूम्‍ह काय्‌मचा परमप्रभुया निंतिं फ्‍या। छिमि पशुतय् न्‍हापां बूपिं मिजंमचा परमप्रभुयागु जुइ। ");
INSERT INTO new_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","न्‍हापां बूम्‍ह गधाया मचायात भ्‍याःचा बियाः त्‍वःतकि, त्‍वःमतुकेगु जूसा वयागु गःपः त्‍वःथुला ब्‍यु। छिमिसं न्‍हापां बूम्‍ह काय्‌मचायात नं लिफ्‍याना कायेमाः। ");
INSERT INTO new_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“छिमि काय्‌पिन्‍सं लिपा, ‘थुकियागु अर्थ छु खः?’ धकाः छिमित न्‍यनीबलय् इमित धा, ‘परमप्रभुं थःगु शक्तिं जाःगु ल्‍हातिं जिमित दास यानातःगु देश मिश्रं पित हयादिल। ");
INSERT INTO new_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","फारोनं जिद्दी यानाः झीत वने मब्‍यूबलय् परमप्रभुं मिश्रय् च्‍वंपिं फुक्‍क मनू व पशुतय् न्‍हापां बूपिन्‍त स्‍यानादिल। अथे जुयाः झीसं न्‍हापां बूपिं फुक्‍क मिजं पशुतय्‌त परमप्रभुया निंतिं बां बीगु व न्‍हापां बूम्‍ह थःकाय्‌यात धिबा बियाः लिफ्‍यायेगु खः।’ ");
INSERT INTO new_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","परमप्रभुं झीत थःगु शक्तिं जाःगु ल्‍हातिं मिश्रं पित हयादीगु खः धकाः लुमंकेत थ्‍व छिमिगु ल्‍हातिइ व कपालय् छगू छगू चिं थें दइ।” ");
INSERT INTO new_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","फारोनं मनूतय्‌त वनेब्‍यूबलय् परमेश्‍वरं पलिश्‍तीतय्‌गु देशया लँपु चिहाकः जूसां इमित अनयागु लँपु जुयाः यंकामदी। मनूतय्‌सं लडाइँ खनीबलय् थःगु मन हिकाः मिश्रय् तुं लिहां वने फु धकाः परमेश्‍वरं अथे यानादीगु खः। ");
INSERT INTO new_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","उकिं परमेश्‍वरं इमित चाःहिकाः मरुभूमिया लँ जुकाः लाल समुद्रपाखे यंकादिल। इस्राएलीत लडाइँया निंतिं ल्‍वाभः घानाः मिश्रं वन। ");
INSERT INTO new_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","मोशां थःलिसें योसेफया अस्‍थि नं यंकल। छाय्‌धाःसा योसेफं थः दाजुकिजापिन्‍त थथे धकाः पाःफय्‌का थकूगु खः, “परमेश्‍वरं छिमित त्‍वःतकादीबलय् छिमिसं जिगु अस्‍थि नं थनं यंकि।” ");
INSERT INTO new_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","इपिं सुक्‍कोतं वनाः मरुभूमिया लिक्‍कसं लाःगु एथामय् पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","इपिं चान्‍हि वनाच्‍वने फयेमा धकाः इमित लँ क्‍यनेत न्‍हिनय् सुपाँय्‌या थामय् व चान्‍हय् मिया थामय् च्‍वनाः परमप्रभु न्‍ह्यः न्‍ह्यः झायेगु यानादिल। ");
INSERT INTO new_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","दिनय् सुपाँय्‌या थां व चान्‍हय् मिया थां इमिगु न्‍ह्यःनं गुबलें चिलामवं। ");
INSERT INTO new_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएलीतय्‌त थथे धा, थ्‍व हे लं फस्‍वयाः मिग्‍दोलपाखे हुँ। अले मिग्‍दोल व लाल समुद्रया दथुइ पी-हहीरोत सतिक्‍क, अले बाल-सेफोनया चुलिंचू लाकाः समुद्र सिथय् पाल ग्‍वयाः च्‍वँ। ");
INSERT INTO new_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","मिश्रया जुजु फारोनं बिचाः याइ, ‘इस्राएलीत लँ तनाः उखेंथुखें जुयाः मरुभूमिइ कुंका च्‍वनेमाल।’ ");
INSERT INTO new_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","जिं मिश्रया जुजु फारोया नुगः छाय्‌काबी, वं छिमित ल्‍यू वइ। जिं फारो व वया सेनायात त्‍याके, अले जिगु महिमा जुइ। मिश्रीतय्‌सं जि हे परमप्रभु खः धकाः सीकी।” इस्राएलीतय्‌सं अथे हे यात। ");
INSERT INTO new_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","मिश्रया जुजुयाथाय् इपिं बिस्‍युं वंगु खँ थ्‍यंबलय् फारो व वया भारदारतय्‌गु नुगः हिल। अले इमिसं धाल, “इस्राएलीतय्‌त दास यानामतसें झीसं इमित वनेबिया। झीसं थ्‍व छु यानागु?” ");
INSERT INTO new_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","उकिं वं थःगु रथ व सिपाइँतय्‌त तयार यात। ");
INSERT INTO new_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","वं दक्‍वसिबय् भिंगु भिंगु खुसः रथनापं मिश्रय् दुगु दक्‍व मेमेगु रथ व उकिया कप्‍तानत नं तयार यात। ");
INSERT INTO new_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","परमप्रभुं मिश्रया जुजु फारोया नुगः छाय्‌कादिल। उकिं वं इस्राएलीतय्‌त ल्‍यू वन, अय्‌नं इस्राएलीत मग्‍यासे वनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","मिश्रया सिपाइँत, फारोया सल, रथ व सल गयावःपिं फुक्‍कसिनं इस्राएलीतय्‌त लित। अले पी-हहीरोतया लिक्‍क बाल-सेफोनया चुलिंचू समुद्र सिथय् पाल ग्‍वयाः च्‍वनाच्‍वंबलय् इमित लुइकल। ");
INSERT INTO new_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","इस्राएलीतय्‌सं फारो व वया सेनायात थःपिंपाखे वयाच्‍वंगु खनाः ग्‍यानाः परमप्रभुयात ग्‍वाहालि फ्‍वन। ");
INSERT INTO new_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","इमिसं मोशायात धाल, “मिश्रय् सीगाः मदु धकाः जिमित थन मरुभूमिइ सीत हयादियागु ला? जिमित मिश्रं पित हयाः छिं छु यानादियागु? ");
INSERT INTO new_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","जिमिसं छितः मिश्रय्, ‘जिमित त्‍वःतादिसँ, जिपिं मिश्रीतय् हे दास जुयाच्‍वने’ धयागु, मखु ला? थन मरुभूमिइ थथे सीगु स्‍वयाः ला मिश्रीतय् दास जुयाच्‍वनेगु हे बांलाः।” ");
INSERT INTO new_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मोशां इमित धाल, “ग्‍याये मते। नुगः बल्‍लाकि। धिसिलाक्‍क च्‍वँ। अले परमप्रभुं छिमित थौं बियादीत्‍यंगु मुक्तियात स्‍व। थौं खंपिं मिश्रीतय्‌त छिमिसं गुबलें खनी मखुत। ");
INSERT INTO new_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","परमप्रभु हे छिमिगु निंतिं ल्‍वानादी। छिपिं सुम्‍क जक च्‍वँ।” ");
INSERT INTO new_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","अले परमप्रभुं मोशायात धयादिल, “छाय् जिलिसें हालाच्‍वनागु? इस्राएलीतय्‌त न्‍ह्यःज्‍या धकाः धा। ");
INSERT INTO new_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","छं थःगु कथि ल्‍ह्वनाः समुद्रपाखे न्‍ह्यःज्‍याकि, समुद्र निब्‍व जुइ। अले इस्राएलीत समुद्रया दथुं गंगु बँ जुयाः वने फइ। ");
INSERT INTO new_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","जिं मिश्रीतय्‌गु नुगः छाय्‌काबी। अले इमिसं छिमित अन नं ल्‍यू वनी। जिं थःगु शक्ति क्‍यनेत फारोया सिपाइँ, सल व रथयात नाश यानाबी। ");
INSERT INTO new_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","जिं इमित त्‍याकेधुंकाः मिश्रीतय्‌सं जि हे परमप्रभु खः धकाः सीकी।” ");
INSERT INTO new_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","इस्राएलीतय्‌गु न्‍ह्यः न्‍ह्यः वनाच्‍वंम्‍ह परमेश्‍वरया दूत चिलाः इमिगु ल्‍युने वन। अले सुपाँय्‌या थां नं इमिगु न्‍ह्यःनं चिलावनाः इमिगु ल्‍युने दंवन। ");
INSERT INTO new_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","व सुपाँय् मिश्री सिपाइँ व इस्राएली सिपाइँतय् दथुइ दं वल। चच्‍छि सुपाँचं मिश्रीतय्‌पाखे खिउँका बिल, अले इस्राएलीतय्‌पाखे जः बिल। उकिं उखुन्‍हु चान्‍हय् मिश्रीत इस्राएलीतय् सतिक वये मफुत। ");
INSERT INTO new_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","अले मोशां थःगु ल्‍हाः समुद्रया च्‍वय्‌पाखे न्‍ह्यज्‍याकल। परमप्रभुं चच्‍छिं पुर्बं तसकं फय् वय्‌काः समुद्रय् गंगु बँ दय्‌कादिल। समुद्र निब्‍व जुल। ");
INSERT INTO new_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","इस्राएलीत समुद्रया दथुं गंगु बँ जुयाः वन। इमिगु जवंखवं लः पखाः जुल। ");
INSERT INTO new_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","मिश्रीतय्‌सं इमित लित। फारोया सल, रथ व सल गयावःपिं इमित समुद्र दुने तक ल्‍यू वन। ");
INSERT INTO new_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","सुथय् जुइत्‍यंबलय् परमप्रभुं मि व सुपाँय्‌या थामं क्‍वस्‍वयाः मिश्री सिपाइँतय्‌त इतिमिति कंकाबिल। ");
INSERT INTO new_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","इमिगु रथया घःचाः तुनाच्‍वन, उकिं इमित रथ सालेत थाकुल। अले मिश्रीतय्‌सं धाल, “थनं बिस्‍युं वनेनु, परमप्रभु इस्राएलीतय्‌गु पंलिनाः झीपिंलिसे ल्‍वानाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","अले परमप्रभुं मोशायात धयादिल, “छं थःगु ल्‍हाः समुद्रया च्‍वय् न्‍ह्यज्‍याकि अले मिश्रीत, इमिगु रथ व सल गयावःपिन्‍त लखं त्‍वपुयेमा।” ");
INSERT INTO new_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मोशां थःगु ल्‍हाः समुद्रया च्‍वय् न्‍ह्यज्‍याकल। सुथ जुइत्‍यंबलय् लः थःगु थासय् लिहां वन। मिश्रीत अनं बिस्‍युं वनेत स्‍वल। परमप्रभुं इमित समुद्रय् हे चुइके छ्वयादिल। ");
INSERT INTO new_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","लः लिहां वयाः सल, रथ, सल गयावःपिं व इस्राएलीतय्‌त ल्‍यूवःपिं फारोया फुक्‍क सिपाइँतय्‌त लखं त्‍वपुल। इपिं छम्‍ह हे ल्‍यं मदय्‌क सित। ");
INSERT INTO new_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","इस्राएलीत धाःसा समुद्रया दथुं गंगु बँ जुयाः न्‍यासि वन। इमिगु जवंखवं लः पखाः जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","थुकथं उखुन्‍हु परमप्रभुं इस्राएलीतय्‌त मिश्रीतय्‌गु ल्‍हातं बचय् यानादिल। इमिसं मिश्रीतय्‌त समुद्रया सिथय् सिनाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","अले इस्राएलीतय्‌सं परमप्रभुं मिश्रीतय्‌गु विरोधय् क्‍यनादीगु तःधंगु शक्ति खनाः परमप्रभुयागु ग्‍याःभय काल। अले परमप्रभु व वय्‌कःया च्‍यः मोशायात पत्‍याः यात। ");
INSERT INTO new_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","अले मोशा व इस्राएलीतय्‌सं परमप्रभुया निंतिं थ्‍व म्‍ये हाल, जिं परमप्रभुया म्‍ये हाले छाय्‌धाःसा वय्‌कलं तःधंगु ज्‍या यानादीगु दु। अले सल व सल गयावःपिन्‍त वय्‌कलं समुद्रय् वांछ्वयादीगु खः। ");
INSERT INTO new_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","परमप्रभु हे जिगु शक्ति खः। वय्‌कलं जितः बचय् यानादी, वय्‌कः जिमि परमेश्‍वर खः, जिं वय्‌कःयात प्रशंसा याये। जिमि पुर्खाया परमेश्‍वर जिं वय्‌कःया नां तःधंके। ");
INSERT INTO new_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","परमप्रभु झीगु निंतिं ल्‍वानादीम्‍ह खः, वय्‌कःया नां परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","फारोया रथ व वया सेनायात वय्‌कलं समुद्रय् वांछ्वयादीगु दु। फारोया ततःधंपिं कप्‍तानत लाल समुद्रय् दुबित। ");
INSERT INTO new_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","तःजाःगु लखं इमित त्‍वपुल। इपिं ल्‍वहं थें तःजाःथाय् दुन। ");
INSERT INTO new_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","हे परमप्रभु छिगु जव ल्‍हातय् तःजिगु शक्ति दु। हे परमप्रभु छिगु जव ल्‍हातं शत्रुयात नाश यानाबिल। ");
INSERT INTO new_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","छिगु विरोधय् दनिपिन्‍त थःगु तःधंगु शक्तिं छिं बुकादिल। छिं थःगु तं क्‍यनाः उकिं इमित छ्वख्‍वः थें भस्‍म यानादिल। ");
INSERT INTO new_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","छिगु न्‍हाय्‌प्‍वाःयागु सासलं लः तःजाः जुयाः दनाबिल। लबु दनाच्‍वंगु लः नं पखाः जुयाः दनाबिल। तःजाःथाय् च्‍वंगु लः नं समुद्रया दुने धी चिनाबिल। ");
INSERT INTO new_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“शत्रुं फुइँ क्‍यनाः धाल, ‘जिं इमित लिनाः ज्‍वने लाका हयागु फुक्‍कं जिं इने। इमिगु नाशं यानाः जिगु म्‍ह याउँसे च्‍वनी, जिं थःगु तरवार लिकाये, जिगु हे ल्‍हातं इमित नाश याये।’” ");
INSERT INTO new_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","अय्‌नं छिं थःगु सासलं इमित पुइके छ्वयादिल अले समुद्रं इमित त्‍वपुल, लःयागु तःधंगु किसिद्वम्‍बलय् म्‍हः थें इपिं दुनावन। ");
INSERT INTO new_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","हे परमप्रभु, छि थें जाःम्‍ह सु द्यः दु धकाः? छि थें पवित्रम्‍ह सु दु धकाः? छि थें तःधंगु महिमां जाःम्‍ह व भय कायेबहःम्‍ह सु दु धकाः? छिं थें सुनां अजू चायापुगु ज्‍या क्‍यनेफु? ");
INSERT INTO new_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","छिं थःगु जव ल्‍हाः न्‍ह्यज्‍याकादिल पृथ्‍वीं इमित नुनाछ्वल। ");
INSERT INTO new_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“छिं थःगु दया मायाय् थःम्‍ह त्‍वःतकादीपिं मनूतय्‌त लँ क्‍यनादीगु दु। थःगु बलं छिं इमित थः च्‍वनादीगु पवित्र थासय् यंकादी। ");
INSERT INTO new_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","थ्‍व खँ न्‍यनाः जातित थुरथुर खात। पलिश्‍तीत देशय् च्‍वंपिनिगु नुगः हीसे च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोमयापिं नायःत तसकं ग्‍याइ, मोआबयापिं थकालित थुरथुर खाइ। कनानयापिं फुक्‍क मनूतय् नुगलय् ध्‍यांग्रा थाइ, ");
INSERT INTO new_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ग्‍याःभय इमिथाय् वइ। हे प्रभु, छिकपिनि मनूत, छिं त्‍वःतकादीपिं मनूत पुलाः मवंतले छिगु ल्‍हाःया बलं इपिं ल्‍वहं थें मसंसे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","छिं इमित हयाः थःम्‍हं ल्‍ययातःगु पर्वतय् पिनादी, हे परमप्रभु, छिं थः हे च्‍वनेत दय्‌कादीगु थासय् अले छिं थःगु हे ल्‍हातं दय्‌कादीगु नापलायेगु पाल लागाय् इमित तयादी। ");
INSERT INTO new_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","परमप्रभुं सदांया निंतिं राज्‍य यानादी।” ");
INSERT INTO new_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","फारोया सल, रथ व सल गयावःपिं मनूत समुद्रय् थ्‍यंबलय् परमप्रभुं समुद्रया लः लित हयाः इमित त्‍वपुयाबिल। इस्राएलीत जक समुद्रया दथुं गंगु बँ जुयाः वन। ");
INSERT INTO new_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","अले हारूनया तता मिरियम अगमवादिनीनं दम्‍फु काल। फुक्‍क मिसात नं दम्‍फु ज्‍वनाः प्‍याखं हुहुं वया ल्‍यूल्‍यू वल। ");
INSERT INTO new_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिरियमं थथे धकाः म्‍ये हाल, “परमप्रभुयागु म्‍ये हा छाय्‌धाःसा वय्‌कलं तःधंगु ज्‍या यानादीगु दु, सल व सल गयावःपिन्‍त वय्‌कलं समुद्रय् वांछ्वयादीगु दु।” ");
INSERT INTO new_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","अले मोशां इस्राएलीतय्‌त लाल समुद्रं शूर धयागु मरुभूमिपाखे यंकल। इपिं स्‍वन्‍हु तक मरुभूमिइ न्‍यासि वन नं लः छफुति हे लुइके मफुत। ");
INSERT INTO new_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","मारा धयागु थासय् थ्‍यंकाः इमिसं अनयागु लः त्‍वने मफुत, छाय्‌धाःसा अनयागु लः खाइसे च्‍वं। अथे जुयाः हे व थाय्‌यात मारा धयातःगु खः। ");
INSERT INTO new_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","अथे जुयाः मनूतय्‌सं “जिमि छु त्‍वनेगु?” धकाः मोशायात कचकच यात। ");
INSERT INTO new_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","अले मोशां परमप्रभुयात ग्‍वाहालिया निंतिं प्रार्थना यात। परमप्रभुं वयात सिँकुचा छकू क्‍यनादिल। वं उकियात लखय् वांछ्वल, अले लः सात। परमप्रभुं अन हे इमित छगू नियम बियाः स्‍यनेकने यानादिल। वय्‌कलं अन इमिगु विश्‍वास गुलि बल्‍लाः धकाः नं स्‍वयादिल। ");
INSERT INTO new_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","वय्‌कलं धयादिल, “छिमिसं थःपिनि परमप्रभु परमेश्‍वरया खँ ध्‍यान बियाः बांलाक न्‍यन धाःसा अले वय्‌कःया मिखाय् छु छु पाय्‌छि जू व यात धाःसा अले वय्‌कःया उजंयात न्‍हाय्‌पं बियाः न्‍यन धाःसा अले वय्‌कःया फुक्‍क नियमत बांलाक पालन यात धाःसा जिं मिश्रीतय्‌थाय् छ्वयाहयागु छुं हे ल्‍वय् छिमिथाय् छ्वयाहये मखु। छाय्‌धाःसा जि हे छिमित लंकाबीम्‍ह परमप्रभु खः।” ");
INSERT INTO new_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","अनंलि इपिं झिंनिगू बुँगाःचा व न्‍हयेमा ताय्‌गः सिमा दुगु एलीमय् थ्‍यंकः वल। इपिं अन हे लः दुथाय् पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","इस्राएलीतय्‌ फुक्‍क खलः एलीमं न्‍यासि वन। मिश्र त्‍वःतूगु निगूगु लाया झिंन्‍यान्‍हु खुन्‍हु इपिं एलीम व सीनैया दथुइ लाःगु सीनया मरुभूमिइ थ्‍यंकल। ");
INSERT INTO new_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","सकल इस्राएलीतय्‌सं अन मोशा व हारूनयात कचकच यात। ");
INSERT INTO new_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","इमिसं थथे धाल, “जिमित परमप्रभुं मिश्रय् हे स्‍यानादीगु जूसा ला ज्‍यूगु नि। मिश्रय् दुबलय् जिमिसं ला व मरि प्‍वाः जाय्‌क नये दु। जिपिं फुक्‍कसित नये मखंक स्‍यायेत छिकपिन्‍सं जिमित थ्‍व हे मरुभूमिइ छाय् हयादियागु?” ");
INSERT INTO new_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","अले परमप्रभुं मोशायात धयादिल, “स्‍व, जिं छिमिगु निंतिं स्‍वर्गं मरि गाय्‌काहये। मनूतय्‌सं न्‍हियान्‍हिथं पिने वनाः उखुन्‍हुयात थःत माक्‍व नसा मुनेमाः। थुकथं इपिं जिं धयाकथं जुइ कि मजुइ धकाः जिं स्‍वये। ");
INSERT INTO new_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","खुन्‍हु दुखुन्‍हु इमिसं मेबलय् स्‍वयाः निदुगं अप्‍वः हयाः ज्‍वरय् यायेमाः।” ");
INSERT INTO new_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","अले मोशा व हारूनं इस्राएलीत फुक्‍कसित धाल, “बहनी छिमिसं छिमित मिश्रं पित हयादीम्‍ह परमप्रभु हे खः धकाः सी। ");
INSERT INTO new_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","अले सुथय् छिमिसं परमप्रभुया महिमा खनी, छाय्‌धाःसा परमप्रभुयागु विरोधय् छिमिसं याःगु कचकच वय्‌कलं न्‍यनादीगु दु। जिपिं सु खः धकाः छिमिसं जिमित कचकच यायेत?” ");
INSERT INTO new_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","मोशां हानं धाल, “परमप्रभुं छिमित बहनिइ नयेत ला व सुथय् माक्‍व नसा बीबलय् छिमिसं थ्‍व फुक्‍क वय्‌कलं यानाच्‍वंगु खः धकाः सी। छाय्‌धाःसा वय्‌कलं छिमिसं वय्‌कःया विरोधय् याःगु कचकच न्‍यनादीगु दु। छिमिसं जिमिगु विरोधय् मखु, बरु परमप्रभुया विरोधय् कचकच यानाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","अले मोशां हारूनयात धाल, “इस्राएलीत फुक्‍कसित धयाब्‍यु, ‘परमप्रभुया न्‍ह्यःने वा, छाय्‌धाःसा वय्‌कलं छिमिगु कचकच न्‍यनादीगु दु।’” ");
INSERT INTO new_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","हारूनं इस्राएलया फुक्‍क खलःयात थथे धयाच्‍वंबलय् इमिसं मरुभूमिपाखे स्‍वल। अन सुपाँचय् परमप्रभुया महिमा खने दयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“इस्राएलीतय्‌गु कचकच जिं न्‍यनागु दु। इमित धा, ‘बहनी छिमिसं ला नयेखनी, अले सुथय् नसां प्‍वाः जाइ। अले जि परमप्रभु छिमि परमेश्‍वर खः धकाः छिमिसं सी।’” ");
INSERT INTO new_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","उखुन्‍हु बहनी बट्टाई झंगः वयाः ख्‍यः त्‍वपुक च्‍वन। सुथय् ख्‍यःया चाकःछिं सुति लः गायाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","सुति लः तनेधुंकाः मरुभूमिइ न्‍यंक पुगाःगु थें च्‍वंक बजिपौ थें च्‍वंगु खनेदत। ");
INSERT INTO new_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","व खनाः इस्राएलीतय्‌सं थःथवय् धाल, “थ्‍व छु खः?” व छु खः धकाः इमिसं मस्‍यूगुलिं मोशां धाल, “थ्‍व परमप्रभुं छिमित बियादीगु नसा खः। ");
INSERT INTO new_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","परमप्रभुं आज्ञा बियादीगु दु, ‘सकसिनं थःत माक्‍व मुंकि। फुक्‍क पालय्‌ च्‍वंपिं छम्‍ह छम्‍हय्‌सिगु निंतिं छगू छगू ओमेर मुंकि।’” ");
INSERT INTO new_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इस्राएलीतय्‌सं इमित धा थें हे यात। गुलिंसिनं यक्‍व गुलिंसिनं कम मुन। ");
INSERT INTO new_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","इमिसं व ओमेरं दाना स्‍वःबलय् अप्‍वः मुंकूपिनि अप्‍वः मजू, कम मुंकूपिनि मगाः मजू। फुक्‍कसिनं माःछि जक मुन। ");
INSERT INTO new_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","अले मोशां इमित धाल, “सुनानं कन्‍हय् सुथय् तक छुं नं ल्‍यंकातये मते।” ");
INSERT INTO new_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","अय्‌नं गुलिं गुलिंसिनं मोशां धाःगु खँ मन्‍यंसे सुथय् तकं ल्‍यंकातल। सुथय् उकी त्‍वँ दायाः नवयाः च्‍वन। थ्‍व खनाः मोशा इपिं लिसे तंम्‍वल। ");
INSERT INTO new_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","सकसिनं सुथय् थःत माक्‍व मुनीगु। अले निभाः छाइबलय् ल्‍यं दुगु नायावनीगु। ");
INSERT INTO new_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","खुन्‍हु दुखुन्‍हु इमिसं निदुगं अप्‍वः मुन, अथे धयागु छम्‍ह छम्‍हय्‌सिगु निंतिं निगू निगू ओमेर खः। अले खलःया फुक्‍क नायःतय्‌सं वयाः मोशायात थ्‍व खँ कन। ");
INSERT INTO new_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","अले वं इमित धाल, “परमप्रभुं थथे हे धयादीगु खः, ‘कन्‍हय् विश्रामबार खः। थ्‍व परमप्रभुया निंतिं पवित्र विश्रामबार खः। उकिं मनूतय् छु छुइ यः, व हे छु, छु दय्‌के यः, व हे दय्‌कि। ल्‍यंदुगु कन्‍हय् सुथय् तक तयाति।’” ");
INSERT INTO new_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","मोशां आज्ञा ब्‍यू थें इमिसं सुथय् तक ल्‍यंकातल। उकी त्‍वँ नं मदाः, नँ नं मवः। ");
INSERT INTO new_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","मोशां कन्‍हय् सुथय्‌खुन्‍हु धाल, “थौं छिमिसं थ्‍व न, थौं परमप्रभुया विश्रामबार खः। थौं छिमिसं बँय् छुं नं लुइके फइ मखु। ");
INSERT INTO new_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","खुन्‍हु तक छिमिसं मुंकि, न्‍हय्‌न्‍हु खुन्‍हु विश्रामबार जूगुलिं छुं नं दइ मखु।” ");
INSERT INTO new_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","अय्‌नं गुलिं गुलिंसिनं न्‍हय्‌न्‍हु खुन्‍हु नं माः वन, अय्‌नं छुं लुइके मफुत। ");
INSERT INTO new_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","अले परमप्रभुं मोशायात धयादिल, “गुबलय् तक छिमिसं जिगु नियमयात मानय् मयायेगु? ");
INSERT INTO new_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","स्‍व, परमप्रभुं छिमित विश्रामबार बियादीगु दु। उकिं परमप्रभुं छिमिगु निंतिं खुन्‍हु दुखुन्‍हु निन्‍हुयात नयेगु नसा बियादी। न्‍हय्‌न्‍हु खुन्‍हु छिपिं सकलें थथःगु थासय् हे च्‍वनाच्‍वनेमाः सुं नं थःगु थासं पिहां वने मज्‍यू।” ");
INSERT INTO new_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","अथे जुयाः मनूतय्‌सं न्‍हय्‌न्‍हु दुखुन्‍हु झासु लन। ");
INSERT INTO new_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएलीतय्‌सं व नसाया नां “मन्‍न” तल। व धन्‍यापु थें च्‍वं। उकियागु सवाः धाःसा कस्‍तिइ दय्‌कातःगु मरि थें च्‍वं। ");
INSERT INTO new_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मोशां धाल, “परमप्रभुं आज्ञा बियादीगु दु, ‘छिमित मिश्रं पित हयाबलय् मरुभूमिइ गज्‍याःगु नसा नकागु खः, लिपा वइपिं पुस्‍तातय्‌सं नं खनेमा धकाः इमिगु निंतिं छगू ओमेर कयाः तयाति।’” ");
INSERT INTO new_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","उकिं मोशां हारूनयात धाल, “छगः थल कयाः उकी छगू ओमेर मन्‍न तयादिसँ। लिपाया पुस्‍ताया निंतिं ल्‍यंकातयेत उकियात परमप्रभुया न्‍ह्यःने तयादिसँ।” ");
INSERT INTO new_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","अले परमप्रभुं मोशायात आज्ञा बियादीगुकथं हारूनं बाचाया सनूया न्‍ह्यःने दयाच्‍वनेमा धकाः मन्‍न तल। ");
INSERT INTO new_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएलीतय्‌सं बाचा चिनातःगु देशय् मथ्‍यंतले पिइदँ तक मन्‍न नयाच्‍वन। कनान देशय् मथ्‍यंतले इमिसं मन्‍न नयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","छगू ओमेर धयागु छगू एपाया झिब्‍वय् छब्‍व खः। ");
INSERT INTO new_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","परमप्रभुया आज्ञा कथं इस्राएलीतय् फुक्‍क खलः सीन धयागु मरुभूमिं वनाः थाय् थासय् जुयाः रपीदीमय् थ्‍यंकाः पाल ग्‍वयाः बाय् च्‍वन। अन धाःसा त्‍वनेत लः हे मदु। ");
INSERT INTO new_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","अथे जुयाः मनूतय्‌सं मोशायात कचकच यानाः धाल, “जिमित त्‍वनेगु लः बियादिसँ।” अले वं इमित धाल, “छिपिं जिलिसें छाय् कचकच याः वयागु? छिमिसं छाय् परमप्रभुयागु मन स्‍वयागु?” ");
INSERT INTO new_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","मनूतय्‌सं प्‍याः चाःगुलिं मोशालिसे कचकच याना तुं च्‍वन। इमिसं धाल, “छिं जिमित छाय् मिश्रं पित हयादियागु? जिमित जिमि मचाखाचा व पशुनापं लः त्‍वने मखंकाः स्‍यायेत ला?” ");
INSERT INTO new_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","अले मोशां परमप्रभुयात थथे धकाः इनाप यात, “जिं थुपिं मनूतय्‌त छु यायेगु? थुमिसं ला जितः ल्‍वहँतं कय्‌के त्‍यंगु दु।” ");
INSERT INTO new_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","परमप्रभुं मोशायात धयादिल, “इस्राएलीतय् छम्‍हनिम्‍ह थकालितय्‌त ज्‍वनाः मनूतय् न्‍ह्यः न्‍ह्यः हुँ। छं थःनापं नील खुसिया लखय् दाःगु कथि नं ज्‍वनाः हुँ। ");
INSERT INTO new_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","जि होरेबया ल्‍वहँतय् छंगु न्‍ह्यःने दंवये। छं ल्‍वहँतय् कथिं दा, अले अनं मनूतय्‌सं त्‍वनेगु लः पिहां वइ।” अले मोशां थकालितय्‌गु न्‍ह्यःने अथे हे यात। ");
INSERT INTO new_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","परमप्रभु जिमिगु दथुइ दी कि मदी धकाः इस्राएलीतय्‌सं परमप्रभुयात जाँचय् याःगु व कचकच याःगुलिं मोशां व थाय्‌या नां “मस्‍साह” व “मेरीबा” तल। ");
INSERT INTO new_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","रपीदीमय् च्‍वनाच्‍वंबलय् अमालेकीतय्‌सं वयाः इस्राएलीतय्‌त हमला यात। ");
INSERT INTO new_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","मोशां यहोशूयात धाल, “कन्‍हय् वनाः अमालेकीतलिसें ल्‍वायेत छं मनूत ल्‍य। परमप्रभुं जितः बियादीगु कथि ज्‍वनाः जि गुँच्‍वकाय् दने।” ");
INSERT INTO new_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","मोशां धाःथें यहोशू अमालेकीतलिसें ल्‍वाः वन। अले मोशा, हारून व हूर गुँच्‍वकाय् वन। ");
INSERT INTO new_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","मोशां थःगु ल्‍हाः ल्‍ह्वनाततले इस्राएलीत त्‍याइगु, वं ल्‍हाः क्‍वकाल कि अमालेकीत त्‍याइगु। ");
INSERT INTO new_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","मोशाया ल्‍हाः त्‍यानुयावसेंलि हारून व हूरं ल्‍वहं छगः हयाः उकी फ्‍यतुकल। अले निभाः मब्‍युतले हारूनं छखे व हूरं मेखे वयागु ल्‍हाः बल्‍लाःक ज्‍वनाः ल्‍ह्वनातल। ");
INSERT INTO new_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","थुकथं यहोशूं तरवारं अमालेकीतय्‌त बुकल। ");
INSERT INTO new_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","अमालेकीतय्‌त बुके धकाः परमप्रभुं मोशायात धयादिल, “थ्‍व खँयात लुमंका तयेत छगू सफुलिइ च्‍व। अले जिं अमालेकीतय्‌त पृथ्‍वीं भज्‍यंक नाश यानाबी धकाः यहोशूयात धा।” ");
INSERT INTO new_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","मोशां अन छगू वेदी दय्‌काः उकिया नां “परमप्रभु जिगु ध्‍वाँय्” धकाः तल। ");
INSERT INTO new_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","वं धाल, “परमप्रभुं पुस्‍तां पुस्‍ता तक अमालेकीतलिसें ल्‍वानादी धकाः वय्‌कलं पाफयादीगु दु।” ");
INSERT INTO new_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","परमेश्‍वरं मोशा व थः प्रजा इस्राएलया निंतिं छु छु यानादिल, गय्‌ यानाः परमप्रभुं इस्राएलीतय्‌त मिश्रं पित हयादिल धइगु खँ मिद्यान देशयाम्‍ह पुजाहारी, मोशाया ससःबौ यित्रों न्‍यन। ");
INSERT INTO new_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","मोशां छुं ईया लागि थः कलाः सिप्‍पोरा व वया निम्‍ह काय्‌पिन्‍त थःछेँय् छ्वःबलय् वया ससःबौ यित्रों इमित लसकुस यात। ");
INSERT INTO new_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","छम्‍ह काय्‌यागु नां गेर्शोम खः। मोशां “जि मेगु देशय् परदेशी जुयाच्‍वनागु दु” धकाः थथे नां छुना ब्‍यूगु खः। ");
INSERT INTO new_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","मेम्‍हय्‌सिगु नां एलीएजर खः। थुकिया अर्थ “जिमि बौया परमेश्‍वरं जितः ग्‍वाहालि यानाः फारोया तरवारं बचय् यानादिल।” ");
INSERT INTO new_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मोशाया काय्‌पिं व कलाःयात ज्‍वनाः यित्रो परमेश्‍वरया पर्वतया लिक्‍क मरुभूमिइ मोशा पाल ग्‍वयाः च्‍वनाच्‍वंगु थासय् वल। ");
INSERT INTO new_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","यित्रों मोशायात थथे धकाः बुखँ छ्वल, “जि छिमि ससःबौ यित्रो छिमि कलाः व छिमि निम्‍हं काय्‌पिन्‍त ज्‍वनाः छन्‍थाय् वयाच्‍वनागु दु।” ");
INSERT INTO new_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","मोशा थः ससःबौयात नापलायेत पिहां वल। वयात नाप लानाः भागि यानाः घय्‌पुल। इमिसं थःथवय् म्‍हंफु मफु न्‍यन। अले पालय् दुहां वन। ");
INSERT INTO new_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","मोशां थः ससःबौयात परमप्रभुं इस्राएलीतय्‌गु निंतिं फारो व मिश्रीतय्‌त यानादीगु फुक्‍क खँ, लँय् थःपिन्‍त जूगु दुःख व परमप्रभुं गथे यानाः इमित बचय् यानादीगु खः व फुक्‍क खँ कन। ");
INSERT INTO new_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","इस्राएलीतय्‌त मिश्रीतय्‌गु ल्‍हातं त्‍वःतकाः हयादीबलय् परमप्रभुं यानादीगु भिंगु ज्‍याखँ न्‍यनाः यित्रो तसकं लय्‌ताल। ");
INSERT INTO new_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","वं धाल, “छिमित मिश्रीत व फारोया ल्‍हातं त्‍वःतकादीम्‍ह परमप्रभुया जय जुइमा। ");
INSERT INTO new_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","मिश्रीतय्‌सं इस्राएलीतय्‌त क्‍वह्यंकूगुलिं परमप्रभुं इमित अथे यानादीगु दु। आः जिं परमप्रभु मेपिं द्यःत स्‍वयाः तःधंम्‍ह खः धकाः सिल।” ");
INSERT INTO new_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","अले यित्रों परमेश्‍वरया निंतिं होमबलि व मे मेगु बलि छाल। अले हारून व इस्राएलयापिं फुक्‍क थकालित मोशाया ससःबौ यित्रो नापं परमेश्‍वरया न्‍ह्यःने भ्‍वय् नयेत वल। ");
INSERT INTO new_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","कन्‍हय् खुन्‍हु मोशा मनूतय्‌गु न्‍याय यायेत फ्‍यतुल। सुथंनिसें बहनि तक मनूत वयागु जवंखवं दनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","यित्रों मोशां मनूतय्‌गु निंतिं यानाच्‍वंगु फुक्‍क ज्‍याखँ खनाः वयात न्‍यन, “छिं मनूतय्‌गु निंतिं यानाच्‍वनागु थ्‍व छु ज्‍या खः? छि याकःचा जक छाय् न्‍याय यायेत च्‍वनादियागु? थुलिमछि मनूत सुथंनिसें बहनी तक छिगु जवंखवं दनाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मोशां धाल, “जिं थथे यायेमाः छाय्‌धाःसा मनूत परमेश्‍वरयागु इच्‍छा थुइकेत वइगु। ");
INSERT INTO new_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","इमि दथुइ छुं कचवं पिहां वल कि इपिं जिथाय् वइ, अले जिं इमिगु दथुइ न्‍याय यानाबीगु। अले इमित परमेश्‍वरयागु नियम स्‍यनेकने यायेगु।” ");
INSERT INTO new_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","यित्रों वयात धाल, “छिं यानादीगु थ्‍व ज्‍या पाय्‌छि मजू। ");
INSERT INTO new_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","थुकिं छि व छिथाय् वइपिं थुपिं मनूत नं त्‍यानुचाइ। थ्‍व छिगु निंतिं तसकं थाकुगु ज्‍या खः। छि याकःचां थ्‍व ज्‍या कःघाये फइ मखु। ");
INSERT INTO new_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","जिं छितः छुं बांलाःगु सल्‍लाह बी। अले परमेश्‍वर छिलिसे दइ। छि मनूतय्‌पाखें इमिगु ल्‍वापुख्‍यापु परमेश्‍वरया न्‍ह्यःने यंकेगु थिक जुइ। ");
INSERT INTO new_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","छिं इमित परमेश्‍वरया विधि व नियम स्‍यनेगु यानादिसँ। अले इपिं वनेमाःगु लँपु व इमिसं यायेमाःगु ज्‍या स्‍यनादिसँ। ");
INSERT INTO new_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","उकिं परमेश्‍वरया ग्‍याःभय काइपिं, मभिंगु ज्‍याखं लबः मकाइपिं, पत्‍याः यायेबहःपिं मनूतय्‌त ल्‍ययाः इमित झिम्‍ह, नेय्‌म्‍ह, सछिम्‍ह, द्वःछिम्‍हय्‌सिया नायः यानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","इमिसं हे न्‍ह्याबलें मनूतय्‌गु न्‍याय यायेगु यायेमाः। थाकुगु मुद्दा जक छिथाय् हय्‌केबियादिसँ। चिचीधंगु मुद्दा इपिं थःपिन्‍सं हे क्‍वःछीमाः। थुकथं छिगु ज्‍या इमिसं इनाकाइगुलिं छितः अपुइ। ");
INSERT INTO new_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","छिं थथे यानादिल धाःसा अले परमेश्‍वरं थज्‍याःगु आज्ञा बियादिल धाःसा छिं ताः ई तक ज्‍या यानादी फइ, अले मनूत नं लय्‌तायाः वने फइ।” ");
INSERT INTO new_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","मोशां थः ससःबौयागु खँ न्‍यनाः वं धाःथें हे फुक्‍क यात। ");
INSERT INTO new_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","वं इस्राएलीतय् दथुं व ज्‍या यायेफुपिं मनूतय्‌त ल्‍ययाः इमित द्वःछिम्‍ह, सछिम्‍ह, नेय्‌म्‍ह व झिम्‍ह-झिम्‍हय्‌सिया नायः यानाबिल। ");
INSERT INTO new_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","उबलय्‌निसें इमिसं मनूतय्‌गु न्‍याय यायेगु यात। थाकुगु थाकुगु मुद्दा इमिसं मोशायाथाय् हयेगु यात। चिचीधंगु खँय् इमिसं थःपिन्‍सं हे क्‍वःछिना छ्वइगु जुल। ");
INSERT INTO new_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","अले मोशां थः ससःबौयात बिदा बिल। यित्रो थःगु देशय् लिहां वन। ");
INSERT INTO new_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","मिश्र त्‍वःतूगु स्‍वला क्‍यंबलय् इस्राएलीत सीनै मरुभूमिइ थ्‍यंकवल। ");
INSERT INTO new_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","रपीदीमं वयाः इपिं सीनैयागु मरुभूमिइ थ्‍यंकः वल। अले इपिं पर्वतया क्‍वय् हे पाल ग्‍वयाः बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","मोशा परमेश्‍वरयात नापलायेत पर्वतय् वन। परमप्रभुं वयात पर्वतं सःताः थथे धयादिल, “छं याकूबया सन्‍तान, इस्राएलीतय्‌त थथे धा, ");
INSERT INTO new_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘जिं मिश्रीतय्‌त छु याना, अले छिमित गुकथं इमां थः मचायात पपुतिइ क्‍वबियाहः थें क्‍वबियाः थःथाय् हया धकाः ला छिमिसं थःपिन्‍सं हे खंगु दु। ");
INSERT INTO new_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","उकिं आः छिमिसं जिगु खँ दुनुगलंनिसें न्‍यनाः जिगु बाचायात मानय् यात धाःसा फुक्‍क जाति स्‍वयाः छिपिं जिगु मू वंगु सम्‍पत्ति जुइ। फुक्‍कं पृथ्‍वी जिगु हे खःसां ");
INSERT INTO new_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","छिपिं जिगु निंतिं पुजाहारीतय्‌गु छगू राज्‍य व छगू पवित्र जाति जुइ।’ छं इस्राएलीतय्‌त धायेमाःगु खँ थ्‍व हे खः।” ");
INSERT INTO new_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","अले मोशां कुहां वनाः थकालितय्‌त सःताः परमप्रभुं आज्ञा बियादीगु फुक्‍क खँ इमिगु न्‍ह्यःने तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","मनूतय्‌सं छप्‍पँ जुयाः लिसः बिल, “परमप्रभुं छु छु या धयादिल फुक्‍कं जिमिसं याये।” अले मोशां इमिगु थ्‍व खँ परमप्रभुयात न्‍यंकल। ");
INSERT INTO new_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","परमप्रभुं वयात धयादिल, “स्‍व, जिं छनापं खँ ल्‍हाइबलय् मनूतय्‌सं तायेमा अले छन्‍त न्‍ह्याबलें पत्‍याः यायेमा धकाः जि छन्‍थाय् ख्‍वातुगु सुपाँचय् वये।” अले मनूतय्‌सं धाःगु खँ मोशां परमप्रभुयात कन। ");
INSERT INTO new_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","परमप्रभुं वयात धयादिल, “मनूतय्‌थाय् वनाः थौं व कन्‍हय् इमित पवित्र या। इमिसं वसः नं हीमाः। ");
INSERT INTO new_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","अले इपिं स्‍वन्‍हु खुन्‍हु तक तयार जुइमाः। छाय्‌धाःसा थनिं स्‍वन्‍हु लिपा परमप्रभु सीनै पर्वतय् सकसिनं खंक झाइ। ");
INSERT INTO new_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","पर्वतया प्‍यखें हे मनूत वने मजीक पनाः इमित धा, ‘होश या, छिमिसं पर्वत नं गये मते, अले पर्वतया सिमानायात थी नं मते। सुनां पर्वतयात थी, व मनू सी। ");
INSERT INTO new_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","थ्‍यूम्‍हय्‌सित हे ल्‍वहँतं कय्‌काः वा बानं कय्‌काः स्‍याइ। मनू जूसां पशु जूसां व सी माली।’ अय्‌नं तुरही ताःईतक पुइबलय् मनूत पर्वतय् थाहां वने फइ।” ");
INSERT INTO new_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","मोशां पर्वतं कुहां वल। अले परमेश्‍वरयात आराधना यायेत मनूतय्‌त तयार जुइत आज्ञा बिल। अले इमिसं थःपिनिगु वसः हिल। ");
INSERT INTO new_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","अले वं मनूतय्‌त धाल, “स्‍वन्‍हु खुन्‍हु तयार जु। उबलय्‌तक लसपस यायेगु ज्‍या याये मते।” ");
INSERT INTO new_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","स्‍वन्‍हु खुन्‍हु सुथय् पर्वतय् क्‍वात्तुक सुपाँय् खनेदत, नँ न्‍यात, हाबलासा त्‍वल। तस्‍सलं तुरही पुयाहल। छाउनीइ च्‍वनाच्‍वंपिं फुक्‍कं ग्‍यानाः थरथर खात। ");
INSERT INTO new_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","अले मोशां इमित परमेश्‍वरयात नापलाकेत छाउनीं पिने ब्‍वनाहल। अले इपिं पर्वतया क्‍वय् दनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","परमप्रभु मिनापं पर्वतय् कुहां झाःगुलिं पर्वत छगुलिं कुँया कुं जाल। अगलं कुँत्‍याः पिहां वः थें पर्वतं पिहां वल। पर्वत छधिकं खात। ");
INSERT INTO new_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","अले तुरहीयागु सः झन तःसः जुयावल। मोशां न्‍ववात व परमेश्‍वरं वयात नँ न्‍याःगु सलं लिसः बियादिल। ");
INSERT INTO new_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","परमप्रभुं सीनै पर्वतयागु च्‍वकाय् क्‍वहां झायाः मोशायात पर्वतयागु च्‍वकाय् सःतादिल। अले मोशा च्‍वय् थाहां वन। ");
INSERT INTO new_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","परमप्रभुं मोशायात धयादिल, “क्‍वय् वनाः मनूतय्‌त जितः स्‍वयेत सिमाना हाचां गयाः वये मते धकाः धा। मखुसा इपिं यक्‍व सी। ");
INSERT INTO new_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","परमप्रभुया न्‍ह्यःने वयेत पुजाहारीतय्‌सं नं थःपिन्‍त शुद्ध यायेमाः। मखुसा इमित नं नाश यानादी।” ");
INSERT INTO new_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मोशां परमप्रभुयात धाल, “मनूत सीनै पर्वतय् थाहां वये फइ मखु, छाय्‌धाःसा छिं हे जिमित, ‘पर्वतया प्‍यखें हे वने मजीक पँ’ धकाः ख्‍याच्‍वः बियादीगु दु।” ");
INSERT INTO new_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","परमप्रभुं वयात धाल, “कुहां वनाः हारूनयात थन ब्‍वनाः हजि। पुजाहारी व मनूत धाःसा सिमाना हाचां गयाः जिथाय् वये दइ मखु। मखुसा जिं इमित नाश यानाबी।” ");
INSERT INTO new_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","अले मोशां कुहां वनाः मनूतय्‌त थ्‍व खँ कन। ");
INSERT INTO new_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","अले परमेश्‍वरं थ्‍व फुक्‍कं खँ धयादिल, ");
INSERT INTO new_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“छिपिं दास दासी जुयाच्‍वंगु मिश्र देशं पित हयाम्‍ह जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","जि बाहेक मेपिं द्यःतय्‌त आराधना याये मते। ");
INSERT INTO new_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“थःगु निंतिं च्‍वय् आकाशय् च्‍वंगु, क्‍वय् पृथ्‍वीइ च्‍वंगु व लखय् दुने च्‍वंगु छुकिंयागु नं मूर्ति दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","छिमिसं उकियात भागि याये मते, पुजा नं याये मते। छाय्‌धाःसा जि हे परमप्रभु छिमि परमेश्‍वर खः। मेपिं द्यःतय्‌त पुजा याःगु जिं सह याये मफु। जिं जितः मयय्‌कूम्‍ह मनूया अधर्मया सजाँय वया छय् व छुइपिनिगु पालय् तक नं बीम्‍ह खः।” ");
INSERT INTO new_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","जितः माया याइपिं व जिगु आज्ञा मानय् याइपिन्‍त धाःसा वया द्वलंद्वः पुस्‍ता तकं जिं दया माया याये। ");
INSERT INTO new_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“जिगु नां कयाः मखुगु पाफयाः थः परमेश्‍वरया नां क्‍वह्यंके मते। म्‍वाय्‌कं म्‍वाय्‌कं वय्‌कःया नां काइम्‍हय्‌सित वय्‌कलं सजाँय बियादी। ");
INSERT INTO new_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“विश्रामबारयात पवित्रगु धकाः मानय् यायेत लुमंका ति। ");
INSERT INTO new_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","खुन्‍हु तक थःगु फुक्‍क ज्‍या या। ");
INSERT INTO new_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","न्‍हय्‌न्‍हु खुन्‍हु धाःसा परमप्रभु छिमि परमेश्‍वरया विश्रामबारया दिं खः। थुखुन्‍हु छिमिसं छुं ज्‍या याये मते। छिमि काय् म्‍ह्याय्‌पिन्‍सं, छिमि दास-दासीं, छिमि पशुतय्‌सं व छिपिंनापं च्‍वनाच्‍वंपिं परदेशीं नं छुं ज्‍या मयायेमाः। ");
INSERT INTO new_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","खुन्‍हु तक परमप्रभुं आकाश व पृथ्‍वी, समुद्र व उकी दुगु फुक्‍कं दय्‌कादिल। अले न्‍हय्‌न्‍हु खुन्‍हु आराम कयादिल। उकिं परमप्रभुं विश्रामबारयात आशिष बियाः उकियात पवित्र यानादिल। ");
INSERT INTO new_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“छिमिसं थः मां-बौयात हनाबना या। अले परमेश्‍वरं छिमित बीत्‍यंगु देशय् छिपिं ताःईतक म्‍वाइ। ");
INSERT INTO new_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“सुयातं स्‍याये मते। ");
INSERT INTO new_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“व्‍यभिचार याये मते। ");
INSERT INTO new_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“खुयाकाये मते। ");
INSERT INTO new_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“थः जःलाखःलाया विरोधय् मखुगु साक्षी बी मते। ");
INSERT INTO new_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“थः जःलाखःलाया छेँय्, कलाः, च्‍यःभ्‍वातिं, द्वहं, गधा व छुं खँय् नं ल्‍वःवंके मते।” ");
INSERT INTO new_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","हाबलासा त्‍वःगु व पर्वतय् कुँ पिहां वःगु खनाः, अले नँ न्‍याःगु व तुरही पुयाहःगु सः ताःबलय् फुक्‍क मनूत ग्‍यानाः थरथर खात। इमिसं तापाक्‍कं हे दनाः। ");
INSERT INTO new_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","मोशायात धाल, “छिं हे जिमित धयादिसँ, अले जिमिसं न्‍यने। परमेश्‍वर थः हे जिपिंलिसें खँ ल्‍हानादीसा जिपिं सी।” ");
INSERT INTO new_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मोशां इमित धाल, “ग्‍याये मते छाय्‌धाःसा परमेश्‍वरं छिमित जाँचय् यायेत, अले वय्‌कःया भय छिमिके दयेमा व छिमिसं पाप मयायेमा धकाः झायादीगु खः।” ");
INSERT INTO new_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","मनूत तापाक्‍क हे च्‍वनाच्‍वन। उबलय् मोशा परमेश्‍वरदीगु ख्‍वातुगु सुपाँय्‌पाखे वन। ");
INSERT INTO new_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","अले परमप्रभुं मोशायात धयादिल, “छं इस्राएलीतय्‌त थथे धा, ‘जिं छिपिंनापं स्‍वर्गं खँ ल्‍हानागु छिमिसं थःपिन्‍सं हे न्‍यंगु दु। ");
INSERT INTO new_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","जि त्‍वःताः छुकिंयागु नं मूर्ति दय्‌के मते। थःगु निंतिं छिमिसं लुँ वहःया मूर्ति दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“‘जिगु निंतिं चाया वेदी दय्‌काः उकी हे होमबलि, मेलबलि, फैच्‍वलय् व सा द्वहं देछा। गन गन जिं थःगु नांयात हनाबना याके अन वयाः जिं छिमित आशिष बी। ");
INSERT INTO new_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","छिमिसं जिगु निंतिं ल्‍वहंया वेदी दय्‌केमाल धाःसा ल्‍वहंयात कियाः दय्‌के मते। छाय्‌धाःसा छिमिसं उकी ज्‍याभः छ्यलाः उकियात अशुद्ध याइ। ");
INSERT INTO new_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","वेदी दय्‌केबलय् त्‍वाथः तये मज्‍यू। मखुसा छिपिं थाहां वनीबलय् छिमिसं थःपिनिगु म्‍हब्‍व उलीगु थें जुइ।’” ");
INSERT INTO new_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","अले परमप्रभुं मोशायात धयादिल, “छं इस्राएलीतय्‌त स्‍यनेमाःगु नियम थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“छिमिसं हिब्रू दास न्‍यात धाःसा वं खुदँ तक जक छिमिगु सेवा याइ। न्‍हय्‌गूगु दँय् वयात छुं मकासे त्‍वःताब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","व ब्‍याहा मजुवं याकःचा वःगु खःसा व याकःचा हे वनी। व वःबलय् हे वया कलाः दुगु खःसा वया कलाः नं व नापं वनी। ");
INSERT INTO new_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","“वया मालिकं वयात ब्‍याहा यानाब्‍यूगु जूसा, अले वयापाखें मचा नं दत धाःसा वया कलाः व वया मस्‍त मालिकं हे तये दइ। दास थः याकःचा जक वने खनी। ");
INSERT INTO new_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","दासं, ‘जितः जिमि मालिक, जिमि कलाः व मस्‍तया माया वं, जि इमित त्‍वःता वने मास्‍तिमवः’ धकाः धाल धाःसा, ");
INSERT INTO new_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","मालिकं वयात न्‍यायकर्तायाथाय् हयेमाः। अले वयात लुखाय् हयाः वयागु न्‍हाय्‌पं नतूचां प्‍वाः खनाबीमाः। अले व मसीतले वया दास जुइ। ");
INSERT INTO new_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“सुनानं थःम्‍ह्याय्‌यात दासी जुइत म्‍यूगु दुसा व मिसामचा दास थें मुक्त जुयाः वने दइ मखु। ");
INSERT INTO new_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","सुनानं वयात थः कलाः यायेत न्‍यानाकयाः लिपा न्‍याम्‍हय्‌सिनं वयात मयय्‌कल धाःसा वं व मिसायात मू पुलाः वया बौम्‍हय्‌सित हे लितबीमाः। अय्‌नं मालिकं वलिसे विश्‍वासघात याःगुलिं वं वयात मेपिं विदेशी मनूतय्‌गु ल्‍हातिइ मियाछ्वयेगु अधिकार दइ मखु। ");
INSERT INTO new_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","मालिकं वयात थः काय्‌यागु निंतिं ल्‍यःगु खःसा वयात म्‍ह्याय् थें याना तयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“मालिकं थःम्‍हं हे ब्‍याहा यानाः लिथु हल धाःसा वं वयात नयेगु, पुनेगु व न्‍हापा थें तुं अधिकार बिया तयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","छुं जुयाः वं थ्‍व स्‍वतां पूमवंकल धाःसा व दासी थः मालिकयात छुं हे मपुसें मुक्त जुइ। ");
INSERT INTO new_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“सुनानं सुयातं दायाः स्‍यात धाःसा वयात नं स्‍याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","छुं जुयाः सुनां नं स्‍याये धकाः स्‍याःगु मखुसे आकाझाकां जक जूगु खःसा वयात बिस्‍युं वनेत जिं थाय् क्‍यनाबी। ");
INSERT INTO new_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","सुनानं स्‍याये धकाः हे स्‍याःगु खःसा व शरण कायेत जिगु वेदीइ वःगु जूसां वयात अनं सालाः स्‍याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“सुनानं थः मां बौयात दाल धाःसा वयात स्‍याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“सुनानं सुयातं जबरजस्‍ती यंकाः मिल धाःसा वा थःनापं तया तल धाःसा वयात स्‍याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“सुनानं थः मां बौयात सराः बिल धाःसा वयात स्‍याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“सुनानं सुयातं थवंथवय् ल्‍वानाः मसीसां लासाय् ग्‍वारातुलेमायेक ल्‍वहँतं कय्‌काः वा ल्‍हातं दाल धाःसा ");
INSERT INTO new_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","अले व मनू दनाः कथिं चुयाः न्‍यासि जुइ फत धाःसा दाःम्‍ह मनूयात सजाँय जुइ मखु। अय्‌नं घाःपाः जूम्‍ह मनूयात वं ज्‍या याये मफुतले वयात ज्‍याला पुलेमाः, अले मलंतले वयात वासः यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“सुनानं थः दास व दासीयात कथिं दाःबलय् व सित धाःसा वयात सजाँय बीमाः। ");
INSERT INTO new_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","अय्‌नं छन्‍हुनिन्‍हुं हे दास वा दासी दनाजुल धाःसा वयात सजाँय लाइ मखु। छाय्‌धाःसा व वयागु सम्‍पत्ति खः। ");
INSERT INTO new_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“सुनानं ल्‍वापु जुयाः प्‍वाथय् दुम्‍ह मिसायात दायाः वया मचा क्‍वहां वल अय्‌नं वयात छुं मजू धाःसा, दाःम्‍ह मनूयात व मिसाया भाःतं धाःकथं अदालतं क्‍वःछ्यूगु धिबा पुइकेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","छुं जुयाः व मिसायात घाःपाः जुल धाःसा ज्‍यानया पलेसा ज्‍यान, ");
INSERT INTO new_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","मिखाया पलेसा मिखा, वाया पलेसा वा, ल्‍हाःया पलेसा ल्‍हाः, तुतिया पलेसा तुति, ");
INSERT INTO new_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","मिं पुइकूगुया पलेसा मिं पुकेगु, घाःया पलेसा घाः, दुघाःया पलेसा दुघाः। ");
INSERT INTO new_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“सुनानं थः दास वा दासीयात मिखाय् दायाः मिखां मखन धाःसा वं वयागु मिखाया पलेसा वयात त्‍वःताछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","सुनानं थः दास वा दासीयात दायाः वा त्‍वःथुलाबिल धाःसा वयागु वाया पलेसा वयात त्‍वःताछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“द्वहंनं मिसा मिजं सुयातं न्‍यकुलिं च्‍वयाः स्‍यात धाःसा द्वहंयात ल्‍वहँतं कय्‌काः स्‍यायेमाः। अले वयागु ला नये मज्‍यू। द्वहंया थुवाःयात धाःसा द्वपं लाइ मखु। ");
INSERT INTO new_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","अय्‌नं द्वहं न्‍हापांनिसें च्‍वयेयःम्‍ह, वया थुवाःयात थुकियागु सुचं बियाः नं वं द्वहंयात चिनामतः, अले व द्वहंनं मिसा वा मिजं सुयातं नं स्‍यात धाःसा द्वहंयात ल्‍वहँतं कय्‌काः स्‍यायेमाः, अले द्वहं थुवाःयात नं स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","अय्‌नं व मनूयात बं पुलाः थःगु ज्‍यान बचय् यायेत धाल धाःसा वं धाक्‍व बं पुलाः थःगु ज्‍यान बचय् याये फु। ");
INSERT INTO new_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“द्वहंनं सुं मिसामचा वा मिजंमचायात च्‍वयाः स्‍यात धाःसां अथे हे यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","द्वहंनं सुयां दास वा दासीयात च्‍वयाः स्‍यात धाःसा द्वहं थुवालं दास वा दासीया थुवाःयात वहःया स्‍विगू शेकेल बं पुलेमाः। द्वहंयात धाःसा ल्‍वहँतं कय्‌काः स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“सुनानं गाः म्‍हुयाः मल्‍हाःकूसे तया तल, अले व गालय् सुयां द्वहं वा गधा कुतुंवन धाःसा ");
INSERT INTO new_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","गाःम्‍हुइकूम्‍हंय्‌सिनं सीम्‍ह पशुया पलेसा पुलेमाः। वं द्वहं वा गधाया थुवाःयात बं पुलेमाः। सीम्‍ह पशु जक वयागु हे जुइ। ");
INSERT INTO new_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“सुयां द्वहंनं मेम्‍हय्‌सिया द्वहंयात च्‍वयाः स्‍यात धाःसा स्‍याःम्‍ह द्वहंयात मियाः इमिसं धिबा बच्‍छि बच्‍छि यानाः इनाः कायेमाः। अले सीम्‍ह द्वहंया ला नं इनाः कायेमाः। ");
INSERT INTO new_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","अय्‌नं द्वहं थुवालं द्वहंयात च्‍वयेयःम्‍ह धकाः सीक सीकं चिनामतसे तया तल धाःसा वं द्वहंया पलेसा द्वहं हे पुलेमाः। सीम्‍ह द्वहं वयागु हे जुइ।” ");
INSERT INTO new_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“सुनानं द्वहं वा फै खुयाः स्‍यात वा मिल धाःसा वं छम्‍ह द्वहंया पलेसा न्‍याम्‍ह द्वहं व छम्‍ह फैया पलेसा प्‍यम्‍ह फै पुलेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“चान्‍हय् छेँय् खुयाच्‍वंबलय् खुँयात ज्‍वनाः दाःबलय् व सित धाःसा वयागु हियागु दोष दाःम्‍हय्‌सित लाइ मखु। ");
INSERT INTO new_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","निभाः त्‍वयेधुंकाः स्‍याःगु जूसा वयागु हिया दोष लाइ। “खुं खुयायंकूगु फुक्‍कं लितबीमाः। लित बीत वयाके छुं हे मदुसा वयात मियाछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","खुया यंकूम्‍ह द्वहं, गधा वा फै म्‍वाःम्‍ह हे लुल धाःसा खुं निदुगं अप्‍वः द्वहं वा गधा पुलेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“सुनानं थः पशुयात त्‍वःताछ्वःबलय् उम्‍ह पशु मेपिनिगु बुँइ वा दाखक्‍यबय् न वन धाःसा व मनुखं थःगु बुँ वा दाखक्‍यबया दक्‍व भिंगु बालिं उकिया पलेसा पुलेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“कंझालय् मि च्‍याकूबलय् मि न्‍यनाः मेपिनिगु अन्‍न मुनातःगु थाय्, बुँयागु अन्‍न वा फुक्‍क बुँयात भस्‍म यानाबिल धाःसा मि च्‍याकूम्‍हय्‌सिनं उकिया पलेसा पुलाबीमाः। ");
INSERT INTO new_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“सुनानं थः जःलाखःलायात धिबा वा बसजाः तयेबियातःबलय् खुया यंकाः खुँयात ज्‍वन धाःसा खुं उकिया निदुगं पलेसा पुलेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","खुँ ज्‍वने मफुत धाःसा छेँथुवाःनं तयेबियातःम्‍हय्‌सिगु बसजालय् ल्‍हाः तःगु दु ला कि मदु धकाः स्‍वयेत न्‍याय याइम्‍हसिथाय् वनेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“सम्‍पत्तियागु खँय् जुइगु न्‍ह्यागु कथंयागु कचिंगः थजु, चाहे द्वहंयागु खँय् थजु, फैयागु खँय् थजु, चाहे वसःयागु खँय् थजु वा मेगु छुं नं सम्‍पत्तियागु खँय् थजु निम्‍हय्‌सिनं नं वं नं ‘जिगु’ वं नं ‘जिगु’ धाल धाःसा निम्‍हं न्‍याय याइम्‍हय्‌सिथाय् वनेमाः। न्‍याय याइम्‍हय्‌सिनं सुयागु दोष क्‍यनी वं थः जःलाखःलायात निदुगं पुलेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“सुनानं थः जःलाखःलायात गधा, द्वहं, फै वा छुं नं पशु तयेबियातःबलय् सुनानं मसीक सित, घाःपाः जुल वा सुनानं लाका यंकल धाःसा ");
INSERT INTO new_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","अले निम्‍हय्‌सिया दथुइया थ्‍व ल्‍वापु उम्‍ह जःलाखःलां मेम्‍ह मनूयागु पशु जिं खुयागु मदु धकाः परमप्रभुया न्‍ह्यःने वनाः पाफयाः ल्‍वापु मिलय् यायेमाः। अले पशु तयातःम्‍हय्‌सिनं छुं नं पलेसा पुलेम्‍वाः। ");
INSERT INTO new_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","जःलाखःलां खुया काःगु हे खःसा वं पशुया थुवाःयात पलेसा पुलेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","पशुयात गुँपशुत स्‍यानाब्‍यूगु खःसा साक्षीया निंतिं क्‍वँय् हयेमाः। अले पशु तयातःम्‍हय्‌सिनं पलेसा पुलेम्‍वाः। ");
INSERT INTO new_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“सुनानं थः जःलाखःलायाके पशु त्‍यायेकयाहयाः वया थुवाः न्‍ह्यःने मदुबलय् घाःपाः जुल वा सित धाःसा त्‍यायेकयाहःम्‍हय्‌सिनं वयागु पलेसा पुलेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","पशुया थुवाः नापं दुसा पलेसा पुलेम्‍वाः। त्‍यायेकयाहःम्‍ह पशु जूसा पशुया बाः जक पुसा गाः। ");
INSERT INTO new_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“सुनानं सुंनाप नं क्‍वःछिना मतःम्‍ह मिसामचायात हेय्‌काः स्‍यंकाबिल धाःसा वं भम्‍चाया मू पुलाः व मिसामचालिसे ब्‍याहा यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","छुं जुयाः मिसामचाया बौनं वयात थः म्‍ह्याय् बी मखु धाल धाःसा वं भम्‍चाया मू पुलेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“तन्‍त्रमन्‍त्र सःम्‍ह मिसायात म्‍वाये बी मते। ");
INSERT INTO new_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“सुं नं मनुखं पशुनाप मत्‍यःगु ज्‍या यात धाःसा वयात स्‍याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“सुनां परमप्रभु बाहेक मेपिं द्यःतय्‌त बलि छाइ, वयात नाश यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“पिनेंवःपिन्‍त बांमलाःगु व्‍यवहार याये मते, इमित क्‍वत्‍यले मते, छाय्‌धाःसा छिपिं नं मिश्र देशय् अथे हे जुयाः च्‍वनेधुंकूपिं खः। ");
INSERT INTO new_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“भाःत सीम्‍ह मिसा व मांबौ मदुम्‍ह मचापाखें लबः कायेगु ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","छुं जुयाः छिमिसं अथे यात, अले इमिसं जितः ग्‍वाहालिया निंतिं प्रार्थना यात धाःसा जिं इमिगु प्रार्थना धात्‍थें न्‍यने। ");
INSERT INTO new_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","जितः तं पिहां वइ। जिं छिमित तरवारं स्‍याये। छिमि कलाःपिनि भाःत दइ मखु छिमि काय् म्‍ह्याय्‌पिनि बौ दइ मखु। ");
INSERT INTO new_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“छिमिथाय् च्‍वंपिं मगाःमचाःपिं जिमि मनूतय्‌त छिमिसं त्‍यासा बीबलय् साहुतय्‌सं थें याये मते, इमिके ब्‍याज काये मते। ");
INSERT INTO new_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","छिमिसं थः जःलाखःलायागु गा बरः कथं तयागु दुसा निभाः बी न्‍ह्यः लितब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","छाय्‌धाःसा वयाके थःगु म्‍ह त्‍वपुयेत छपु हे जक गा दु। मखुसा वं छु फायाः द्यनी? वं जितः प्रार्थना यात धाःसा जिं वयागु प्रार्थना न्‍यने। छाय्‌धाःसा जि माया याइम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“परमेश्‍वरयात क्‍वह्यंके मते, अले छिमि मनूतय् शासकतय्‌त नं सराः बी मते। ");
INSERT INTO new_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“जितः थःगु बुँयागु बाली व दाखरस छायेत लिबाके मते। “छिमिसं थःपिनि न्‍हापां बूपिं काय्‌पिं जिगु निंतिं फ्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“छिमिसं थःपिनि सा व फैच्‍वलय्‌या न्‍हापां बूपिं मस्‍तय्‌त नं अथे हे या। न्‍हय्‌न्‍हु तक इपिं थः मांलिसे च्‍वनी, च्‍यान्‍हु खुन्‍हु जितः छा। ");
INSERT INTO new_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“छिपिं जिमि पवित्र मनू जुइ। उकिं छिमिसं जंगली पशुतय्‌सं स्‍याःम्‍ह पशुयागु ला नये मते, वयात छिमिसं खिचातय्‌त वान्‍छ्वया ब्‍यु।” ");
INSERT INTO new_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“मखुगु खँ ल्‍हाये मते। मभिंम्‍ह मनूलिसे जानाः मखुगु साक्षी बी मते। ");
INSERT INTO new_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“मखुगु ज्‍या यानाच्‍वंपिं मनूतय्‌गु हुलया ल्‍यूल्‍यू वने मते। साक्षी बीबलय् न्‍याय स्‍यनीकथं हुलयागु पंलिनाः साक्षी बी मते। ");
INSERT INTO new_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","न्‍याय याइबलय् चीमि धकाः सुयागुं पंली मते। ");
INSERT INTO new_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“थः शत्रुया द्वहं वा गधा मदुथाय् वनाच्‍वंगु खन धाःसा छिमिसं वयात ज्‍वनाः वयाथाय् यंकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","छिमिसं थःत मयःपिं मनूतय् गधायात कुं ल्‍हानाच्‍वंगु खन धाःसा वयात अथें त्‍वःताः वने मते। ग्‍वाहालि यानाः वयात थुनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“चीमिपिं मनूतय्‌त न्‍याय बीत लिचिले मते। ");
INSERT INTO new_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“मखुगु खँपाखें तापाक्‍क च्‍वँ। द्वं मदुम्‍ह व खःकथं जुइम्‍ह मनूयात स्‍याये मते, छाय्‌धाःसा द्वंयाःम्‍हय्‌सित जिं गुबलें नं द्वं मयाःम्‍ह ठहरे याये मखु। ");
INSERT INTO new_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“घुस नये मते छाय्‌धाःसा घुसं मनूतय्‌त कां यानाबी, अले खःगु खँयात अःखः यानाबी। ");
INSERT INTO new_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“परदेशीतय्‌त क्‍वत्‍यले मते। छिपिं थःपिं नं मिश्रय् परदेशी जुयाच्‍वने धुंकूगुलिं छिमिसं परदेशीतय्‌गु मन स्‍यू। ");
INSERT INTO new_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“खुदँ तक थःगु बुँइ पुसा ह्वलाः उकियागु बाली मुँ। ");
INSERT INTO new_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","अले न्‍हय्‌दँय् दिपाः कयाः छुं नं पी मते। अन अथें बुयावःगु छिमिथाय् च्‍वंपिं चीमिपिं मनूतय्‌सं नइ। इमिसं नयाः ल्‍यं दुगु गुँपशुतय्‌सं नइ। छिमिसं थःपिनिगु दाखया क्‍यब व जैतूनया ख्‍यःयात नं अथे हे या। ");
INSERT INTO new_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“खुन्‍हु तक थःगु ज्‍या या, न्‍हय्‌न्‍हु खुन्‍हु झासु लँ। थुकिं छिमि द्वहं, गधा, थःथाय् छेँय् बूपिं दासतय्‌सं व परदेशीतय्‌सं नं झासु लनेदइ। ");
INSERT INTO new_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“जिं धयागु फुक्‍क खँ बांलाक न्‍यँ। मेपिं द्यःतय्‌गु पुजा याये मते। इमिगु नां तक नं काये मते। ");
INSERT INTO new_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“दँय् स्‍वक्‍वः छिमिसं जिगु निंतिं नखः हनेगु या। ");
INSERT INTO new_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“छिमिसं सोडा मतःगु मरिया नखः हनेगु या। छिमित आज्ञा बिया थें आबीब लाया क्‍वःछिनातःगु इलय् न्‍हय्‌न्‍हु तक सोडा मतःगु मरि नयेगु या, छाय्‌धाःसा व हे लाय् छिपिं मिश्रं पिहां वःगु खः। “सु नं जिगु न्‍ह्यःने ल्‍हातय् छुं मदय्‌क खनेदः वये मते। ");
INSERT INTO new_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“थःगु बुँइ सःगु बालीया न्‍हापांगु फल छायाः सामाज्‍याया नखः हँ। “अले दक्‍वसिबय् लिपा थःगु बुँइ सःगु फल खानाः ‘फल खायेगु नखः’ हँ। ");
INSERT INTO new_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“दँय् स्‍वक्‍वः फुक्‍क मिजंत परमप्रभुया न्‍ह्यःने खनेदः वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“जितः बलि ब्‍यूम्‍ह पशुयागु हि सोडा दुगु मरिनापं छाये मते। “जिगु निंतिं नखःया बलि ब्‍यूम्‍ह पशुयागु दाः सुथय् तक तये मते। ");
INSERT INTO new_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“छिमिगु बुँइ सःगु दक्‍वसिबय् भिंगु न्‍हापांगु फल परमप्रभु थः परमेश्‍वरया छेँय् हजि। “च्‍वलय्‌चिया मचायात वया मांयागु दुरुइ दय्‌के मते।” ");
INSERT INTO new_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","परमप्रभुं धयादिल, “स्‍व, लँय् छिमिगु बिचाः यायेत अले जिं तयार यानागु थासय् छिमित हयेत जिं छम्‍ह दूत छिमि न्‍ह्यः न्‍ह्यः छ्वयाबी। ");
INSERT INTO new_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","वयागु न्‍ह्यःने होश यानाच्‍वँ अले वं धाःगु खँ न्‍यँ। वयागु विरोधय् वने मते। छाय्‌धाःसा वयाके जिगु नां दुगुलिं वं छिमिगु अपराध क्षमा याइ मखु। ");
INSERT INTO new_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","थथे छिमिसं वयागु खँ न्‍यन धाःसा अले जिं धाःथें यात धाःसा जि छिमि शत्रुतय् शत्रु व छिमि विरोधीतय् विरोधी जुइ। ");
INSERT INTO new_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","जिमि दूत छिमि न्‍ह्यःने न्‍ह्यःने वनी, अले एमोरी, हित्ती, परिज्‍जी, कनानी, हिव्‍वी व यबूसीतय्‌गु देशय् छिमित हइ। अले जिं इमित नाश यानाबी। ");
INSERT INTO new_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","इमि द्यःतय्‌त भागियाये मते, इमिगु पुजा याये मते। अय्‌नं उपिं द्यःतय्‌त स्‍यंकाब्‍यु। अले इमिसं पुजा याइगु ल्‍वहंतय्‌त तछ्यानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“छिमिसं परमप्रभु थः परमेश्‍वरयागु जक आराधना या अले वय्‌कलं छिमिगु नसा त्‍वंसाय् आशिष बियादी। अले जिं छिमिथासं ल्‍वय् चीकाछ्वये। ");
INSERT INTO new_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","छिमिगु देशय् सु नं मचा क्‍वहां वइम्‍ह वा बाझः जुइ मखु। अले जिं छिमिगु आयु पूवंकाबी। ");
INSERT INTO new_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“छिमिगु विरोध याइपिं मनूतय्‌त जिं जिगु भय काइपिं यानाबी। छिपिं वनीगु देशयापिं मनूतय्‌त इतिमिति कंकाबी। जिं छिमि शत्रुतय्‌त छिमिगु न्‍ह्यःनं लिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","जिं छिमिगु न्‍ह्यःने आतंक छ्वयाबी। इमिसं हिव्‍वी, कनानी व हित्तीतय्‌त छिमिगु लँपुं याकनं हे लिनाछ्वइ। ");
INSERT INTO new_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","जिं इमित छगू हे दँय् पितिनाछ्वये मखु, मखुसा देशय् झिजांमिजां दनी। अले जंगलया पशुत ल्‍याखय् अप्‍वः दयावइ। ");
INSERT INTO new_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","छिपिं न्‍ह्यज्‍यानाः व देश थःगु अधिकारय् मकातले भचा भचा यानाः जिं इमित छिमिगु न्‍ह्यःनं लिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“जिं छिमिगु सिमाना लाल समुद्रनिसें पलिश्‍तीतय्‌गु समुद्र तक, अले मरुभूमिंनिसें यूफ्रेटिस तक हे क्‍वःछिनाबी। जिं व देशयापिं मनूतय्‌त छिमिगु ल्‍हातय् बी, अले छिमिसं इमित लिनाछ्वइ। ");
INSERT INTO new_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“छिमिसं इपिं नापं अले इमि द्यःत नापं स्‍वापु तये मते। ");
INSERT INTO new_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","छिमिगु देशय् इमित च्‍वनेबी मते, मखुसा छिमित जिगु विरोधय् पाप याकेबी। छिमिसं इमि द्यःतय्‌त पुजायात धाःसा छिपिं धात्‍थे हे इमिगु जालय् तक्‍यनी।” ");
INSERT INTO new_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","हानं परमप्रभुं मोशायात धयादिल, “छ हारून, नादाब, अबीहू व न्‍हयेम्‍ह थकालित नापं जिथाय् च्‍वय् थहां वा अले तापाक्‍कं हे आराधना या। ");
INSERT INTO new_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","अय्‌नं छ जक जिथाय् वा, मेपिं न्‍ह्यःने मवयेमाः। मनूत धाःसा च्‍वय् थहां हे मवयेमाः।” ");
INSERT INTO new_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","अले मोशां मनूतय्‌थाय् वनाः परमप्रभुयागु फुक्‍कं वचन व नियम न्‍यंकल, अले इमिसं छसलं थथे धाल, “परमप्रभुं धयादीगु फुक्‍कं वचन व नियम जिमिसं मानय् याये।” ");
INSERT INTO new_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","अले मोशां परमप्रभुं धयादीगु फुक्‍कं आज्ञा बांलाक च्‍वल। कन्‍हय् खुन्‍हु सुथ न्‍हापां दनाः वं पर्वतयागु क्‍वसं छगू वेदी दय्‌कल। अले इस्राएलया झिंनिगू कुलकथं झिंनिगः ल्‍वहंयागु थां थन। ");
INSERT INTO new_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","अले वं इस्राएली ल्‍याय्‌म्‍हतय्‌त छ्वल, इमिसं परमप्रभुया निंतिं होमबलि व द्वहंयागु मेलबलि छाल। ");
INSERT INTO new_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","मोशां उकिया बच्‍छि हि कयाः ख्‍वल्‍चाय् तल, बच्‍छि हि धाःसा वेदीइ छ्वाकल। ");
INSERT INTO new_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","वया लिपा वं बाचाया सफू कयाः मनूतय्‌गु न्‍ह्यःने ब्‍वन। इमिसं लिसः बिल, “परमप्रभुं धयादीगु फुक्‍क खँ जिमिसं याये, अले वय्‌कःया आज्ञायात मानय् याये।” ");
INSERT INTO new_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","अले मोशां हि कयाः मनूतय्‌त छ्वाकाः थथे धाल, “थ्‍व परमप्रभुं छिपिंनापं फुक्‍कं वचनकथं चिनादीगु बाचायागु हि खः।” ");
INSERT INTO new_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","अनं लिपा मोशा, हारून, नादाब, अबीहू व न्‍हयेम्‍ह थकालित च्‍वय् थहां वन। ");
INSERT INTO new_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","इमिसं इस्राएलया परमेश्‍वरयात खन। परमेश्‍वर दनादीगु थाय् आकाश थें यचुगु नीलमणी थें खने दु। ");
INSERT INTO new_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","दक्‍व इस्राएली नायःतय्‌सं परमेश्‍वरयात खंसां वय्‌कलं इमित नाश यानामदी। अन हे इमिसं नयेगु त्‍वनेगु यात। ");
INSERT INTO new_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","परमप्रभुं मोशायात धयादिल, “पर्वतय् जिथाय् थहां वा अले थन च्‍वँ। छं इमित स्‍यनेत जिं च्‍वयागु व्‍यवस्‍था व आज्ञायागु ल्‍वहंपौ छन्‍त बी।” ");
INSERT INTO new_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","अले मोशा व वयात ग्‍वाहालि बीम्‍ह यहोशू परमेश्‍वरयागु पर्वतय् थहां वन। ");
INSERT INTO new_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","वने न्‍ह्यः मोशां थकालितय्‌त थथे धाल, “जिपिं मवतले छिपिं थन पिया च्‍वनाच्‍वँ। हारून व हूर छिपिंनापं च्‍वनी। सुयागुं ल्‍वापुख्‍यापु दःसा इमिथाय् वनेमा।” ");
INSERT INTO new_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","मोशा पर्वतय् थहां वन अले सुपाँचं पर्वतयात त्‍वपुल। ");
INSERT INTO new_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","परमप्रभुया जः सीनै पर्वतय् च्‍वन। अले सुपाँचं खुन्‍हु तक पर्वतयात त्‍वपुया तल। न्‍हय्‌न्‍हु खुन्‍हु परमप्रभुं सुपाँचं मोशायात सःतादिल। ");
INSERT INTO new_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएलीतय्‌गु मिखाय् परमप्रभुयागु जः पर्वतयागु च्‍वकाय् भस्‍म याइगु मि थें खनेदत। ");
INSERT INTO new_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","अले मोशा सुपाँय्‌या दथुं पर्वतया च्‍वकाय् थहां वन। व अन पिइन्‍हु व पिइचा तक च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“जिगु निंतिं देछा हयेमाः धकाः इस्राएलीतय्‌त धा, जिगु निंतिं दुनुगलंनिसें बीगु मनदुपिं मनूतय्‌सं बी हःगु देछा छं का। ");
INSERT INTO new_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","इमिगुपाखें कायेगु देछा थथे दु – लुँ, वहः, कँय्, ");
INSERT INTO new_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","वँचुगु, प्‍याजीगु, ह्याउँगु का व सूती कापः, च्‍वलेचिया सँ, ");
INSERT INTO new_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ह्याउँगु रंग छिनातःगु फैचायागु छेंगू, डल्‍फिनया छेंगू, खयःसिँ, ");
INSERT INTO new_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","पाल्‍चाया निंतिं जैतूनया चिकं, अभिषेक याइगु चिकं व नस्‍वाःगु गुँगू दय्‌केत मसला। ");
INSERT INTO new_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","अले एपोद व छाती-पाताय् घाकेत थीथी मू वंगु थी। ");
INSERT INTO new_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“जि इमिगु दथुइ च्‍वनेत इमिसं जिगु निंतिं छगू नापलायेगु पाल दय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","जिं छन्‍त क्‍यनेत्‍यनागु नमूनाकथं छं नापलायेगु पाल व उकियागु फुक्‍कं ज्‍वलं दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“छं खयःसिँयागु १.१ मि. हाकः, ६६ से.मि. ब्‍या व ६६ से.मि. तःजाःगु छगः सनू दय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","उकियागु दुने व पिने भिंगु लुं भुनाब्‍यु। अले उकिया प्‍यखेरं लुँया बाला दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","उकिया निंतिं लुँयागु प्‍यचाः चाः दय्‌काः उकियात सनूया प्‍यंगू ख्‍वःलय् तयाब्‍यु। थ्‍व छखे निचाः व मेखे निचाः तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","अले खयःसिँयागु निपु न्‍वः दय्‌कि अले उकियात लुं हिनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","सनू क्‍वबीत न्‍वःत निखें दुगु चालय् ति। ");
INSERT INTO new_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","उपिं न्‍वःत सनूया चाकलय्‌ हे दयाच्‍वनेमाः। उपिं अनं लिकाये मते। ");
INSERT INTO new_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","अले जिं छन्‍त बीत्‍यनागु बाचाया पौतय्‌त सनूइ तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“अले भिंगु लुँयागु १.१ मि. हाकः, ६६ से.मि. ब्‍या दुगु छगू प्रायश्‍चितया कृपा-आसन दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","मुगलं दायाः लुँया निम्‍ह करूब दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","करूबतय्‌त प्रायश्‍चितया कृपा-आसनया निखें सिथय् तयाब्‍यु। करूबतय्‌त व प्रायश्‍चितया कृपा-आसनयात छधी हे लुं दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","उपिं करूबतय्‌सं थथःगु पपू च्‍वय्‌पाखे चकंका च्‍वंगु व प्रायश्‍चितया कृपा-आसनयात थःगु पपूं त्‍वपुयातःगु जुइमाः। इमिगु ख्‍वाः चुलिंचू प्रायश्‍चितया कृपा-आसनपाखे स्‍वय्‌कातःगु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","जिं छन्‍त बीत्‍यनागु बाचाया पौ सनूया दुने ति। अले प्रायश्‍चितया कृपा-आसनयात सनूया द्यःने तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","अन जिं छनापं नाप लाये। प्रायश्‍चितया कृपा-आसन च्‍वय् निम्‍ह करूबतय्‌गु दथुं इस्राएलीतय्‌गु निंतिं फुक्‍कं उजं जिं छन्‍त बी। ");
INSERT INTO new_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“छं खयःसिँयागु ८८ से.मि. हाकः, ४४ से.मि. ब्‍या व ६६ से.मि. तःजाःगु छगू तेबिल दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","उकियात भिंगु लुं भुनाब्‍यु, अले उकिया प्‍यखेरं लुँया बाला दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","उकिया प्‍यखेरं ८ से.मि. ब्‍या दुगु बाला नं दय्‌कि। अले प्‍यखेरं सिधालय् लुँयागु मेगु बाला दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","तेबिलया निंतिं लुँयागु प्‍यचाः चाः दय्‌काः चाःतय्‌त प्‍यंगू तुति च्‍वय् प्‍यखें कुन्‍चाय् तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","तेबिल ल्‍ह्वनीगु न्‍वःत कताकेत चाः बाला लिक्‍कसं दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","थ्‍व न्‍वःत खयःसिँयागु दय्‌कि, अले लुं भुनाब्‍यु। व हे न्‍वलं जक तेबिल क्‍वबीगु यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","उकियागु पाःचागु थल, आम्‍खुरा व त्‍वँसाबलि प्‍वंकेगु करुवा व ख्‍वल्‍चा भिंगु लुँयागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","तेबिलय् जिगु न्‍ह्ययःने न्‍ह्याबलें देछाःगु मरि तयेगु या। ");
INSERT INTO new_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“छं भिंगु लुँयागु छगू त्‍वाःदेवा मुगलं दायाः दय्‌कि। उकियागु लिधंसा, चु, स्‍वां थें च्‍वंगु ख्‍वल्‍चा, चुलि व स्‍वांफ्‍वः फुक्‍कं भिंगु लुँयागु छगू हे कुचां दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","उकियागु खुपु कचा पिनेपाखे पिहां वःगु जुइमाः। स्‍वपु कचा त्‍वाःदेवाया छखेपाखे अले स्‍वपु कचा मेखेपाखे। ");
INSERT INTO new_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","छगू कचाय् मर्स्‍या बरांयागु स्‍वांफ्‍वः थें च्‍वंगु स्‍वंगः ख्‍वल्‍चा व नापं मुखू वयाच्‍वंगु स्‍वां व स्‍वांफ्‍वः दयेमाः। अले मेगुपाखे नं व थें हे स्‍वपु कचात पिहां वयाच्‍वनेमाः। थुकथं अन खुपु कचा दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","त्‍वाःदेवाया चुइ मर्स्‍या बरांया स्‍वांफ्‍वः थें च्‍वंगु प्‍यंगः ख्‍वल्‍चा, मुखू वयाच्‍वंगु स्‍वां व स्‍वांफ्‍वः नापं दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","चूं पिहां वःगु स्‍वज्‍व कचात मध्‍ये न्‍हापांगु ज्‍वः काचाया दथुइ छगूगु ग्‍वः, निगूगु ज्‍वःया दथुइ निगूगु ग्‍वः, स्‍वंगूगु ज्‍वःया दथुइ स्‍वंगूगु ग्‍वः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","त्‍वाःदेवा, उकियागु मुखू व कचात मुगलं दायातःगु भिंगु लुँयागु छगू हे कुचायागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“उकी न्‍हय्‌पाः पाल्‍चा दय्‌कि। उपिं पाल्‍चाय् त्‍वाःदेवाया न्‍ह्यःनेपाखे जः बीत मत च्‍याका ब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","त्‍वाःदेवायात माःगु चिम्‍ता व किस्‍ति नं भिंगु लुँयागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","स्‍विन्‍यागू किलोग्राम भिंगु लुं त्‍वाःदेवा व उकियात माःमाःगु ज्‍वलं दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","जिं छन्‍त गुँच्‍वकाय् क्‍यनागु नमूनाकथं थ्‍व फुक्‍कं बांलाक दय्‌कि।” ");
INSERT INTO new_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“छं झिपाः भिंगु वँचुगु प्‍याजी व ह्याउँगु रंगयागु सूती कापःयागु पवित्र पाल त्‍वपुइगु इलां दय्‌कि। ज्‍या सःम्‍ह शिल्‍पकारयात कापतय् भिंगु भिंगु कां करूबया बुत्ता भरय् याकेब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","छपाः छपाः कापः १२ मिटर हाकः व २ मिटर ब्‍या दुगु जुइमाः। फुक्‍क कापः अपाय्‌कू हे जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","न्‍याकू कापःयात स्‍वाना छकू हे या। अले मेगु न्‍याकू कापःयात नं अथे हे या। ");
INSERT INTO new_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","न्‍हापां स्‍वाःगु कापःया सिथय् वँचुगु कापःयागु स्‍वःतिपाँय् दय्‌कि। अथे हे लिपाः स्‍वाःगु कापःया सिथय् सिथय् नं वँचुगु कापःयागु स्‍वःतिपाँय् दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","अले न्‍हापां स्‍वाःगु कापःया सिथय् नेय्‌गू स्‍वःतिपाँय् अथे हे लिपा स्‍वाःगु कापःया सिथय् नं नेय्‌गू स्‍वःतिपाँय् दय्‌कि। स्‍वःतिपाँय् चुलिंचू लाःगु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","अनंलि लुँयागु अंकुसि दय्‌काः थुपिं अंकुसिं निकू कापःयात छकू यानाः स्‍वानाब्‍यु। थुकथं निकू कापः छकू जुइ। ");
INSERT INTO new_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“अनंलि थ्‍व कापःया इलांयात त्‍वपुयेत च्‍वलय्‌चिगु सँयागु झिंछकू कापः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","छपाः छपाः कापः १३ मिटर हाकः व २ मिटर ब्‍या दुगु जुइमाः। फुक्‍क कापः अपाय्‌कू हे जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","न्‍याकू कापःयात स्‍वाना छकू या, अले मेगु खुकू कापःयात स्‍वाना छकू या। खुकूगु कापःयात धाःसा पालया न्‍ह्यःनें भचा लथ्‍या। ");
INSERT INTO new_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","अले न्‍हापां स्‍वाःगु कापःया सिथय् नेय्‌गू स्‍वःतिपाँय् दय्‌कि, अथे हे लिपा स्‍वाःगु कापःया सिथय् नं नेय्‌गू स्‍वःतिपाँय् तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","अनंलि कँय्‌यागु नेय्‌गू अंकुसि दय्‌काः स्‍वःतिपाँय्‌लय् तयाः निकू कापःयात छकू हे यानाः स्‍वानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","13","पवित्र पाल त्‍वपुइबलय् इलांया निगूगु तँ पच्‍छिमपाखें छगू मिटर ति, दच्‍छिन व उत्तरपाखें धाःसा बच्‍छि मिटर क्‍वखायेमाः। ");
INSERT INTO new_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","थ्‍व हे इलांया निगूगु तँया द्यःने हानं नितँ तयेमाः। छगू ह्याउँगु रंग छिनातःगु फैया छेंगूयागु व मेगु डल्‍फिनया छेंगूयागु। ");
INSERT INTO new_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“पवित्र पालया इलां दिकेत खयःसिँया सिँपौ धंस्‍वाकाः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","फुक्‍क सिँपौ ४ मिटर हाकः व ६६ से.मि. ब्‍या दुगु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","फुक्‍क सिँपतिइ निगः निगः चूल तानाः स्‍वानातयेमाः। पवित्र पालया फुक्‍क सिँपौत थुकथं हे दय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","पवित्र पालया दच्‍छिनपाखे तयेत निइपौ सिँपौ दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","निइपौ सिँपौया तःलय् वहःयागु पिइगू लिधंसा दय्‌कि। फुक्‍क सिँपौया तःलय् निगू निगू लिधंसा। ");
INSERT INTO new_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","पवित्र पालया उत्तरपाखे तयेत निइपौ सिँपौ दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","अले निइपौ सिँपौया तःलय् वहःयागु पिइगू लिधंसा दय्‌कि। फुक्‍क सिँपौया तःलय् निगू निगू लिधंसा। ");
INSERT INTO new_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","पवित्र पाल ल्‍युने पच्‍छिमपाखे तयेत खुपौ सिँपौ दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","अले ल्‍यूनेया निगू कुन्‍चाया निंतिं निइपौ सिँपौ दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","थुपिं निपतिं च्‍वंनिसें क्‍वथ्‍यंक देतनातःगु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","थुकथं अन फुक्‍कं यानाः च्‍यापौ सिपौँ दयेमाः। अले छपौ सिँपौया तःलय् निगू निगू यानाः झिंखुगू वहःयागु लिधंसा दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“छं खयःसिँयागु झिंन्‍यागू खगः दय्‌कि अर्थात दच्‍छिनपाखे न्‍यागू खगः, ");
INSERT INTO new_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","उत्तरपाखे न्‍यागू खगः व पच्‍छिमपाखे न्‍यागू खगः। ");
INSERT INTO new_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","सिँपौतय् दथुइ दुगु खगः धाःसा छगू कुनं मेगु कुनय् तक थ्‍यंगु छगू हे खगः जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","अले सिँपौयात लुं हिनाब्‍यु। खगः दिकेगु चाःचात नं लुं हिनाब्‍यु। खगःयात नं लुं हिनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“जिं छन्‍त गुँच्‍वकाय् क्‍यनागु नमूनाकथं पवित्र पाल दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“अले वँचुगु, प्‍याजीगु व ह्याउँगु भिंगु सूती कापःयागु पर्दा दय्‌कि। उकी ज्‍या सःम्‍ह शिल्‍पकारयात भिंगु कां करूबया बुत्ता भरय् याकेब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","उकियात वहःयागु प्‍यंगू लिधंसाया द्यःने च्‍वंगु लुं हिनातःगु पर्दा खयः सिमायागु प्‍यंगः थामय् अंकुसि काकाः यख्‍खानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","थथे अंकुसि काकाः पर्दा यख्‍खाये धुंकाः उकिया ल्‍युने बाचाया सनू ति। व पर्दानं महा-पवित्र थाय्‌यात पवित्र थासं अलग्‍ग तयाबी। ");
INSERT INTO new_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“महा-पवित्रगु थासय् बाचाया सनूया द्यःने प्रायश्‍चितया कृपा-आसन तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","अले पर्दा पिने पवित्र थाय्‌या उत्तरपाखे तेबिल ति, अथे हे पवित्र थाय्‌या दच्‍छिनपाखे तेबिलया चुलिंचू त्‍वाःदेवा ति। ");
INSERT INTO new_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“पालया लुखाय् तयेत वँचुगु, प्‍याजीगु व ह्याउँगु भिंगु सूती कापःयागु बुत्ता भरय् यानातःगु पर्दा दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","थ्‍व पर्दाया निंतिं खयःसिँयागु न्‍यागः थां दय्‌कि। उकियात लुं हिनाब्‍यु। उकिया अंकुसि लुँयागु जुइमाः। अले न्‍यागः थांया निंतिं कँय्‌यागु न्‍यागू लिधंसा दय्‌कि।” ");
INSERT INTO new_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“छं खयःसिँयागु २.२ मि. हाकः, २.२ मि. ब्‍या व १.३ मि. तजाःदुगु छगू प्‍यकुंलाःगु वेदी दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","उकिया प्‍यकुनय् छपु छपु नेकू दय्‌कि। फुक्‍क नेकू व वेदी छगू हे सिँ कुचायागु जुइमाः। वेदीयात कँय्‌नं भुनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","वेदीया नउ तयेगु थल, नउ तुइगु चतं, बाता, ला लिकायेगु नतू व मिथल दय्‌कि। थुपिं फुक्‍क कँय्‌यागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","उकिया निंतिं कँय्‌यागु छगू चालिंचा दय्‌कि, वेदी क्‍वबीत प्‍यखें कँय्‌यागु हे प्‍यचाः चाः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","चालिंचायात वेदीया दुने प्‍यखेंया सिइ दिकाब्‍यु। थथे तयेबलय् जालि वेदीया दथुइ तक थ्‍यनेमाः। ");
INSERT INTO new_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","वेदीया निंतिं खयःसिँयागु न्‍वःत दय्‌काः कँय्‌नं हिनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","वेदी क्‍वबीत वेदीया निखेंया चालय् न्‍वः दुछ्व। ");
INSERT INTO new_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","सिँपौयागु वेदी फुसुलु दय्‌कि। जिं छन्‍त गुँच्‍वकाय् क्‍यनागु नमूनाकथं होमबलिया वेदी दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“पवित्र पालया चुक दय्‌केत प्‍यखेरं ख्‍वातुगु कापतं ग्‍व। उकिया दच्‍छिन ब्‍व ४४ मिटर हाकः दुगु जुइमाः। थुपिं ख्‍वातुगु कापः भिंगु सुति कां दय्‌कूगु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","उकियागु निंतिं निइगू कँय्‌यागु लिधंसाय् निइगः हे कँय्‌यागु थां दयेमाः। थांतय्‌गु अंकुसि व डण्‍डी धाःसा वहःयागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","अथे हे उत्तरया ब्‍वया निंतिं नं ४४ मिटर हाकः दुगु ख्‍वातुगु कापः दयेमाः। अले उकियागु थांत निइगः व लिधंसा नं कँय्‌यागु निइगः हे दयेमाः। अंकुसि व डण्‍डी धाःसा वहःयागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","चुकया पच्‍छिमपाखे २२ मिटर हाकःगु ख्‍वातुगु कापः व उकिया निंतिं झिगः थां व झिगू लिधंसा दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","चुकया पुर्बपाखेया ब्‍या २२ मिटर जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","ध्‍वाखाया निखें ६.५ मि. ६.५ मि. हाकःगु ख्‍वातुगु कापः दयेमाः अले उकिया निंतिं स्‍वंगः स्‍वंगः थां व लिधंसा दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“चुकया ध्‍वाखाया निंतिं वँचुगु, प्‍याजीगु ह्याउँगु भिंगु सूती कापःतय् बुत्ता भरय् यानातःगु ९ मिटर हाकःगु पर्दा दय्‌कि। थुकियात प्‍यंगः थां व प्‍यंगू लिधंसा दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","चुकया प्‍यखें च्‍वंगु थांत वहःयागु डण्‍डीत नापं स्‍वानाच्‍वंगु, उकियागु अंकुसि वहःयागु व लिधंसा कँय्‌यागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","चुक ४४ मिटर हाकः व २२ मिटर ब्‍या दुगु जुइमाः। अले जाः २.२ मि. दयेमाः। ख्‍वातुगु कापः भिंगु सुति कायागु व लिधंसा कँय्‌यागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","पालय् छ्यलिगु फुक्‍क थलबल, पालया की व चुकया की कँय्‌यागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“अले छं इस्राएलीतय्‌त न्‍हिं न्‍हिं त्‍वाःदेवा मदिक्‍क च्‍याकेत भिंगु जैतूनया चिकं हजि धकाः उजं ब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","पवित्र पालय् बाचा चिनातःगु सनूया न्‍ह्यःने च्‍वंगु पर्दाया पिने हारून व वया काय्‌पिन्‍सं सन्‍ध्‍याकाः ई निसें सुथय् तक परमप्रभुया न्‍ह्यःने पाल्‍चा मदिक्‍क च्‍याकेमाः। थ्‍व उजं इस्राएली व वया सन्‍तानयात न्‍ह्याबलेंया निंतिं जुइमाः।” ");
INSERT INTO new_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“छं इस्राएलीतय् दथुं छिमि दाजु हारून व वया काय्‌पिं नादाब, अबीहू, एलाजार व ईतामारयात जिगु निंतिं पुजाहारीया ज्‍या यायेत थःथाय् हजि। ");
INSERT INTO new_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","छं छिमि दाजु हारूनया निंतिं पवित्रगु वसः दय्‌कि। उकिं वयात इज्‍जत बी अले बांलाकी। ");
INSERT INTO new_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","जिं बुद्धि बियातयापिं थज्‍याःगु ज्‍या यायेफुपिं फुक्‍कसित सःती। इमित हारूनया निंतिं वसः सुइत उजं ब्‍यु। अले हारूनं पुजाहारी अभिषेक जुयाः जिगु सेवा याइ। ");
INSERT INTO new_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","इमिसं सुइमाःगु वसः थथे दु– छातिपाता, एपोद, पुजाहारीया लं, जामालं, बेतालि व जँनी। इमिसं छिमि दाजु हारून व वया काय्‌पिन्‍सं पुजाहारीया ज्‍या यायेगु निंतिं थुकथं पवित्र वसःत दय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","इमिसं वँचुगु, प्‍याजीगु, ह्याउँगु रंगयागु व लुँयागु का, अले भिंगु सूती कापः छ्यलेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“इमिसं एपोद वँचुगु, प्‍याजीगु व ह्याउँगु रंगयागु का, लुँयागु का व भिंगु सूती कापःयागु स्‍यल्‍लाक सुइमाः। ");
INSERT INTO new_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","अले थ्‍वयात कत्ताकातयेत निखेंया ब्‍वहलय् निगू ब्‍वहःकुचा स्‍वानातःगु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","एपोदया द्यःने वँचुगु, प्‍याजीगु व ह्याउँगु कां व लुँयागु कां हे बांलाक थानातःगु भिंगु सूती कापःयागु जँनी दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“छं निकू आनिक्‍स थी कयाः उकी इस्राएलया काय्‌पिनिगु नां क्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","जन्‍मदिं कथं इपिं मध्‍ये खुम्‍हय्‌सिगु नां छगः ल्‍वहंचाय् व मेपिं खुम्‍हय्‌सिगु नां मेगु ल्‍वहंचाय् क्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ल्‍वहंकःमिं ल्‍वहँतय् कतां कियेगु ज्‍या याइगु थें हे निगलं आनिक्‍स थीलय् इस्राएलया काय्‌पिनिगु नां क्‍यु। अले उकियात लुँयागु फाकुनय् थुनाः ब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","इस्राएलया झिंनिगू कुलया लुमन्‍ति कथं हारूनं थ्‍व निकुतिं ल्‍वहंयात ब्‍वहलय् तयाब्‍यु। थुकथं वं पवित्र पालय् वनीबलय् इमिगु नां घानावनी। उकिं जि परमप्रभुं थः मनूतय्‌त न्‍ह्याबलें लुमंकी। ");
INSERT INTO new_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","छं लुँयागु फाकुं दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","अले लुँयागु निलातःगु निपु सिखः दय्‌कि। थ्‍व सिखःयात फाकुनय् स्‍वानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“न्‍याय यायेत दकलय् तःधंम्‍ह पुजाहारीया निंतिं स्‍यल्‍लाःगु छातिपाता दय्‌कि। थ्‍व छातिपाता एपोद थें हे लुँयागु, वँचुगु, प्‍याजीगु व ह्याउँगु भिंगु सूती कापःयागु जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","थ्‍व प्‍यकुंलाःगु व निबः यानाः लथ्‍यानातःगु जुइमाः। अले थुकिया हाकः व ब्‍या क्‍वलाछि क्‍वलाछि दयेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","थुकी प्‍यझ्‍वः यानाः थीथी मणि थुनाब्‍यु। न्‍हापांगु झ्‍वलय् मानिक, पुष्‍पराज व फिरोजा, ");
INSERT INTO new_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","निगूगु झ्‍वलय् प्‍याजी रंगयागु मणि, नीलम व पन्‍ना, ");
INSERT INTO new_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","स्‍वंगूगु झ्‍वलय् कार्नेलेन, अकिक व प्‍याजी रंगयागु मणि। ");
INSERT INTO new_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","प्‍यंगूगु झ्‍वलय् पुखराज, कार्नेलेन व जास्‍पर दयेमाः। थ्‍व फुक्‍कयात लुँयागु फाकुनय् थुनेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","इस्राएलया झिंनिम्‍ह काय्‌पिनिगु नांकथं झिंनिगः मणिया थी दयेमाः। झिंनिगलय् हे झिंनिगू कुलयागु नां कियातयेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“छातिपातायात एपोदय् घायेत भिंगु लुँयागु निलातःगु सिखः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","अले लुँयागु निचाः चाः दय्‌काः उकियात छातिपाताया निखेंया कुनय् सुयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","लुँयागु निपुं सिखःयात छातिपाताय् च्‍वंगु निचालं लुँचालय् चिनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","लुँयागु सिखःया मेगु च्‍वःयात एपोदया ब्‍वहलय् न्‍ह्यःने च्‍वंगु लुँयागु फाकुनय् चिनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","लुँयागु मेगु निचाः चाः दय्‌काः छातिपाताया ल्‍यूनेया च्‍वःपाखे एपोदया जँनी नापसं उकियात सुयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","हानं मेगु निचाः लुँयागु चाः दय्‌काः जँनी चिनातःगु गथिया च्‍वसं सुयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","छातिपाताया चाः व एपोदया चाःयात वँचुगु पुतुं चिनाः जनीनापं स्‍वानाब्‍यु। थुकिं यानाः छातिपाता एपोदय् थुखे उखे सनी मखु। ");
INSERT INTO new_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“हारून पवित्र थासय् दुहां वनीबलय् परमेश्‍वरं सदां लुमंकेमा धकाः वं इस्राएलया काय्‌पिनिगु नां कियातःगु न्‍यायया छातिपाता नुगःया च्‍वय् घानाः वनेमा। ");
INSERT INTO new_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","न्‍यायया छातिपाताय् ‘ऊरीम’ व ‘तुम्‍मीम’ ति। थुकिं हारून परमप्रभुया न्‍ह्यःने वनीबलय् उपिं न्‍ह्याबलें वयाके दयाच्‍वनेमाः। थुकथं परमप्रभुया न्‍ह्यःने वनीबलय् हारूनं थःगु नुगःया च्‍वय् न्‍ह्याबलें इस्राएलीतय्‌गु न्‍याय यायेगु ज्‍याभः घानावनी। ");
INSERT INTO new_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एपोदया दुने फीगु पुजाहारीया लं ब्‍याक्‍क वँचुगु कापःयागु सु। ");
INSERT INTO new_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","दथुइलाक छ्यं दुछ्वयेत प्‍वाः दयेमाः अले मगुइमा धकाः गःतांया छचाःखेरं कापः सुया तयेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","पुजाहारीया लं सिथय् छचाःखेरं वँचुगु, प्‍याजी व ह्याउँगु कां धालेग्‍वः सुयाः घायेमाः, उकियागु दथुइ दथुइ लुँयागु गं नं घायेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","लुँयागु गं व धालेग्‍वःयात छगः छगः यानाः पुजाहारीया लं सिथय् छचाःखेरं अतः गाय्‌काः घायेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","हारूनं पवित्र थासय् परमप्रभुया सेवा याः वनीबलय् थ्‍व लं फीमाः। अले दुहां पिहां जुइबलय् थुकी घानातःगु गंया सः ताये दयेमा। थुकिं हारून मसीनि धकाः सी दइ। ");
INSERT INTO new_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“छं भिंगु लुँयागु बाला छगू दय्‌काः उकी ‘परमप्रभुया निंतिं पवित्र’ धकाः क्‍यु। ");
INSERT INTO new_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","थुकियात वँचुगु कां बेतालिइ च्‍यु। थ्‍व बेतालिया न्‍ह्यःने लायेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","थ्‍व हारूनया कपालय् दयेमाः। अले इस्राएलीतय्‌सं छाःगु फुक्‍क देछा परमप्रभुं फयाः कयादी। छुं जुयाः थुपिं पवित्र देछा हःगुलिइ दोष दत धाःसा फुक्‍क दोष हारूनं फयेमाः। इपिं परमप्रभुया न्‍ह्यःने नाले बहःगु जुइमा धकाः व न्‍ह्याबलें वया कपालय् दयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“जामालं भिंगु सूती कापःयागु सु। अले बेतालि नं भिंगु सूती कापःयागु हे सु। जँनी नं बुत्ता थानातःगु भिंगु सूती कापःयागु दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“छं हारूनया काय्‌पिनिगु निंतिं जामालं, बेतालि व जँनी दय्‌कि। उकिं इमित इज्‍जत बी अले बांलाकी। ");
INSERT INTO new_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","छं थ्‍व वसः थः दाजु हारून व वया काय्‌पिन्‍त फिकाः इमित अभिषेक या। इमित पवित्र या। थथे इमित पलिस्‍था याये धुंकाः इमिसं पुजाहारी जुयाः जिगु सेवा याये फइ। ");
INSERT INTO new_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“छं इमिगु म्‍ह त्‍वपुयेत सूती कापःयागु दुने न्‍ह्यायेगु बागः सुर्वाः सु। थ्‍व जँनिसें खम्‍पातक वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","हारून व वया काय्‌पिन्‍सं पवित्र पालय् दुहां वनेबलय् व वेदीया न्‍ह्यःने सेवा यायेत वनेबलय् थ्‍व वसः फिनावनेमाः। थुकथं इपिं दोषी ठहरे मजुइमा अले मसीमा।” “थ्‍व हारून व वया सन्‍तानयात नं न्‍ह्याबलेंया निंतिं नियम जुल।” ");
INSERT INTO new_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“हारून व वया काय्‌पिन्‍त जिगु सेवा यायेत पलिस्‍था यायेबलय् छं यायेमाःगु ज्‍या थ्‍व हे खः, छम्‍ह खू मदुम्‍ह द्वहंचा व निम्‍ह खू मदुपिं भ्‍याःचा हजि। ");
INSERT INTO new_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","सोडा मतःगु भिंगु छुचुं कयाः चिकं ल्‍वाकछ्यानातःगु मरि व चिकनं बुलातःगु सालुगु मरि दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","थ्‍व मरि छगः दालाचाय् तयाः द्वहंचा व निम्‍हं भ्‍याःचानापं हजि। ");
INSERT INTO new_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","अनंलि हारून व वया काय्‌पिन्‍त नापलायेगु पालया ध्‍वाखा लिक्‍क हयाः म्‍वःल्‍हुकि। ");
INSERT INTO new_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","वसः हयाः हारूनयात जामालं, पुजाहारीया लं, एपोद व छातिपाता फिकाः बांलाक थानातःगु जँनी एपोदया द्यःने चिनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","अले वयागु छेनय् बेतालि चिनाः बेतालिया न्‍ह्यःने लुँ बाला तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","अनं लिपा अभिषेक याइगु चिकं कयाः वयागु छेनय् प्‍वंका अभिषेक या। ");
INSERT INTO new_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","अले वया काय्‌पिन्‍त हयाः इमित जामालं फिकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","अले जँनी चिकाः इमित बेतालि हिनाब्‍यु। थुगु ज्‍यापाखें हारूनया सन्‍तानतय्‌सं पुजाहारीया सेवा न्‍ह्याबलें यायेमाः। थुकथं छं हारून व वया काय्‌पिन्‍त अभिषेक या। ");
INSERT INTO new_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“अनं लिपा व द्वहंचा नापलायेगु पालया ध्‍वाखाय् हजि, अले हारून व वया काय्‌पिन्‍सं द्वहंचाया छेनय् थथःगु ल्‍हाः तयेमाः। ");
INSERT INTO new_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","अले व द्वहंचायात परमप्रभुया न्‍ह्यःने नापलायेगु पालया ध्‍वाखाय् बां ब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","द्वहंचाया हि भतिचा थःगु पतिंचां कयाः वेदीया नेकुलिइ तिकाब्‍यु। ल्‍यं दुगु हि धाःसा वेदीया तःलय् प्‍वंकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","अले छं आतापति भ्‍वरि त्‍वपुइगु फुक्‍क दाः, सेँ त्‍वपुइगु पिलि व दाःनापया निगलं जलासेँ कयाः वेदीइ छ्वय्‌की। ");
INSERT INTO new_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","द्वहंचाया ला, छेंगू व सउ धाःसा छाउनी पिने मिइ छ्वय्‌काछ्व। व पापबलि खः। ");
INSERT INTO new_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“छं छम्‍ह भ्‍याःचा नं का, अले हारून व वया काय्‌पिन्‍सं चिधिकःम्‍ह भ्‍याःचायागु छेनय् थथःगु ल्‍हाः तयेमाः। ");
INSERT INTO new_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","व भ्‍याःचायात स्‍यानाः वयागु हि वेदीया जःखः छ्वाकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","व भ्‍याःचाया ला कुचा कुचा यानाः छ्यं अले आतापति भ्‍वरि व तुति लखं सिलाः ला कुचात व छ्यं नापं वेदीइ तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","भ्‍याःचाया म्‍ह छम्‍हं वेदीइ छ्वय्‌काछ्व। थ्‍व परमप्रभुया निंतिं विशेष देछा, नस्‍वाःगु होमबलि खः। ");
INSERT INTO new_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“छं मेम्‍ह छम्‍ह भ्‍याःचा का, अले हारून व वया काय्‌पिन्‍सं भ्‍याःचायागु छेनय् थथःगु ल्‍हाः तयेमाः। ");
INSERT INTO new_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","वयात स्‍यानाः भतिचा हि कयाः हारून व वया काय्‌पिनिगु जव जव न्‍हाय्‌पंया ज्‍वालय्, जव जव ल्‍हाःया बुरा-पतिंचाय् व जव जव तुतिया बुरा-पतिंचाय् तिकाब्‍यु। अले हि वेदीया जःखः छ्वाकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","अले वेदीइ च्‍वंगु हि व अभिषेकया भतिचा चिकं कयाः हारून व वया वसतय् अले वया काय्‌पिं व इमिगु वसतय् नं छ्वाकाब्‍यु। थथे हारून, वया काय्‌पिं व इमिगु वसः शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“छं भ्‍याःचायागु दाः, दाःखाःगु न्‍हिप्‍यं, आतापुति-भ्‍वरी त्‍वपुइगु फुक्‍क दाः, सेँ त्‍वपुइगु पिलि, दाः नापंया निगलं जलासेँ व जव खम्‍पा का। थ्‍व अभिषेकयाम्‍ह भ्‍याःचा खः। ");
INSERT INTO new_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","परमप्रभुया न्‍ह्यःने दुगु दालां सोडा मतःगु छपा मरि, छगः ग्‍वारमरि व चिकनं बुलातःगु मरि कयाः ");
INSERT INTO new_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","व फुक्‍कं हारून व वया काय्‌पिनिगु ल्‍हातय् तयाब्‍यु। अले परमप्रभुया न्‍ह्यःने संकाबीगु बलिकथं देछा। ");
INSERT INTO new_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","अनंलि व फुक्‍कयात इमिगु ल्‍हातं कयाः परमप्रभुयात यःगु नस्‍वाःकथं वय्‌कःयात विशेष देछा, होमबलिया वेदीइ छ्वय्‌काब्‍यु। थ्‍व परमप्रभुयात मिं छाःगु बलि खः। ");
INSERT INTO new_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","हारूनया अभिषेकयाम्‍ह भ्‍याःचायागु ह्याकुला कयाः परमप्रभुया न्‍ह्यःने संकि। थ्‍व छंगु हे ब्‍व जुइ। ");
INSERT INTO new_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“लिपतय् हारूनया अभिषेकयाम्‍ह भ्‍याःचाया ह्याकुला व खम्‍पा कयाः परमप्रभुया न्‍ह्यःने संकाबीगु बलिकथं संकि, थ्‍व छिमिगु हे ब्‍व जुइ। ");
INSERT INTO new_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","अले इस्राएलयापिं मनूतय्‌सं थ्‍व ब्‍वःयात हारून व वया काय्‌पिन्‍त बी। इस्राएलयापिं मनूतय्‌सं परमप्रभुयात मेलबलि छाइबलय् थ्‍व ब्‍व न्‍ह्याबलें पुजाहारीतय्‌गु जुइ। थ्‍व ब्‍व पुजाहारीतय्‌त बीबलय् परमप्रभुयात ब्‍यूगु थें हे जुइ। ");
INSERT INTO new_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","30","हारून सी धुंकाः वयागु पुजाहारीया वसः वया लिपा पुजाहारी जुइम्‍ह वया सन्‍तानयात बीमाः। अले अभिषेकया ज्‍याझ्‍वलय् न्‍हय्‌न्‍हु तक वं व वसः फिनाः पवित्र पालय् ज्‍या यानाः नापलायेगु पालय् च्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“अले अभिषेक यायेत हःम्‍ह भ्‍याःचायागु ला कयाः चुकय् छथाय् दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","इमिसं व भ्‍याःचायागु ला व दालाय् दुगु मरि नापलायेगु पालया दुने ध्‍वाखाया लिक्‍क च्‍वनाः नयेमाः। ");
INSERT INTO new_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","इमिसं पलिस्‍था यायेत व प्रायश्‍चित यायेत देछाःगु इमिसं नये ज्‍यू। व पवित्र जूगुलिं मेपिन्‍सं नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","अभिषेक यायेत हःम्‍ह भ्‍याःचायागु ला व मरि छुं सुथय् तक ल्‍यन धाःसा व ल्‍यं दुगु मिइ छ्वय्‌काछ्व। व नये मज्‍यू छाय्‌धाःसा व पवित्र खः। ");
INSERT INTO new_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“न्‍हय्‌न्‍हु तक जिं छन्‍त बियागु फुक्‍कं आज्ञा कथं हारून व वया काय्‌पिन्‍त पलिस्‍था या। ");
INSERT INTO new_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","छं न्‍हियान्‍हिथं प्रायश्‍चित यायेत पापबलियाम्‍ह द्वहंचा बां बीमाः। थुकिया हि कयाः वेदीयात शुद्ध या, अले वेदीयात पवित्र यायेत जैतूनया चिकनं अभिषेक या। ");
INSERT INTO new_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","न्‍हय्‌न्‍हु तक छं वेदीया निंतिं प्रायश्‍चित यानाः उकिं व शुद्ध जुइ। अले वेदी तच्‍वकं पवित्र जुइ। व उकियात थ्‍यूगु न्‍ह्यागु नं पवित्र जुइ। ");
INSERT INTO new_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“अले छं वेदीइ न्‍हियान्‍हिथं मदिक्‍क छायेमाःगु खँ थुपिं हे खः – दच्‍छि दुपिं निम्‍ह चिधिकःम्‍ह भ्‍याःचात। ");
INSERT INTO new_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","छम्‍ह सुथय् अले मेम्‍ह सन्‍ध्‍याकाः इलय् छा। ");
INSERT INTO new_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","छम्‍ह चिधिकःम्‍ह भ्‍याःचानापं भिंगु छगू हीनया प्‍यब्‍वय् छब्‍व जैतूनया चिकनय् न्‍हायातःगु एपाया झिब्‍वय् छब्‍व भिंगु छुचुं अले त्‍वँसाबलिया निंतिं छगू हीनया प्‍यब्‍वय् छब्‍व दाखमद्य छा। ");
INSERT INTO new_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","मेम्‍ह चिधिकःम्‍ह भ्‍याःचा सन्‍ध्‍याकाः इलय् छा। सुथय् थें अन्‍नबलि व त्‍वँसाबलि नापं छायेमाः। थ्‍व परमप्रभुया निंतिं नस्‍वाःगु विशेष देछा जुइ। ");
INSERT INTO new_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“छिमि पुस्‍तां पुस्‍ता तक नापलायेगु पालया ध्‍वाखाया लिक्‍क परमप्रभुया न्‍ह्यःने मदिक्‍क होमबलि छाना च्‍वनेमाः। नापलायेगु पालय् जि छनापं खँ ल्‍हायेत नापलाः वये। ");
INSERT INTO new_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","इस्राएलीत नापं जि व हे थासय् नापला वये। अले व थाय् जिगु महिमां पवित्र जुइ। ");
INSERT INTO new_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“थुकथं जिं नापलायेगु पालयात व वेदीयात पवित्र याये। अले हारून व वया काय्‌पिन्‍त जिगु निंतिं पुजाहारी जुयाः सेवा याकेत अभिषेक याये। ");
INSERT INTO new_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","जि इस्राएलीतय्‌गु दथुइ बाय् च्‍वने, अले जि इमि परमेश्‍वर जुइ। ");
INSERT INTO new_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","जि इमि दथुइ बाय् च्‍वनेत इमित मिश्र देशं पितहयाम्‍ह परमप्रभु इमि परमेश्‍वर खः धकाः इमिसं सी। जि परमप्रभु इमि परमेश्‍वर खः।” ");
INSERT INTO new_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“छं गुँगू थनेत खयःसिँयागु छगू वेदी दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","व ४५ से.मि. ताहाकःगु, ४५ से.मि. ब्‍या दुगु ९० से.मि. जाः दुगु व प्‍यकुंलाःगु जुइमाः। उकिया नेकूत व वेदी छगू हे सिँ कुचाया जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","उकिया च्‍वय्, प्‍यखेरं व नेकूतय्‌त भिंगु लुं भुनाब्‍यु। अले उकिया प्‍यखेरं लुँयागु बाला दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","वेदी क्‍वबीगु न्‍वः तयेत बालाया क्‍वय् निखेंपाखें निचाः चाः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","न्‍वः खयःसिँयागु दय्‌काः लुं भुनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","जिं छन्‍त नापलायेगु थाय् बाचाया सनूया द्यःने दुगु प्रायश्‍चितया कृपा-आसन खः। उकिया न्‍ह्यःने यख्‍खाया च्‍वंगु पर्दा पिने थ्‍व वेदी तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“हारूनं सुथय् पतिकं पाल्‍चा मिलय् याइबलय् वेदीइ नस्‍वाःगु गुँगू थनेमाः। ");
INSERT INTO new_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","हारूनं सन्‍ध्‍याकाः इलय् पाल्‍चा च्‍याकीबलय् गुँगू नं थनेमाः। थ्‍व गुँगू छिमि पुस्‍तां पुस्‍ता तक परमप्रभुया न्‍ह्यःने थनेगु यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","व वेदीइ छं मेगु कथंयागु गुँगू, होमबलि, अन्‍नबलि व त्‍वँसाबलि छाय् मते। ");
INSERT INTO new_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","हारूनं दँय् छक्‍वः वेदीया न्‍यकुली प्रायश्‍चित यायेमाः। छिमि पुस्‍ता पुस्‍ता तक दँय् छक्‍वः शुद्ध जुइगु बलिया हिं उकी प्रायश्‍चित यायेमाः। थ्‍व हे वेदी परमप्रभुयात तसकं पवित्र खः।” ");
INSERT INTO new_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","अनं लिपा परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“छं इस्राएलीत ल्‍याः खाइबलय् इमिके महामारी मवयेमा धकाः फुक्‍कसिनं थथः ल्‍याःखाःगु इलय् परमप्रभुयात छुत्‍काराया मू पुलेमाः। अले छं इमित ल्‍याःखाइबलय् महामारी वइ मखु। ");
INSERT INTO new_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","मिजंम्‍ह मनूत ल्‍याःखाइबलय् इपिं छम्‍ह छम्‍हय्‌सिनं पवित्र पालया शेकेलकथं बच्‍छि शेकेल बीमाः। थ्‍व छगू शेकेल धयागु निइगू गेरा खः। थ्‍व बच्‍छि शेकेल परमप्रभुयात देछा खः। पवित्र थाय्‌यागु शेकेलकथं छगू शेकेल १२ ग्राम वहः खः। ");
INSERT INTO new_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","निइदँ व व स्‍वयाः थंपिं मनूत ल्‍याःखाइबलय् थथे परमप्रभुयात देछा बीमाः। ");
INSERT INTO new_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","थःगु प्रायश्‍चितया लागिं परमप्रभुयात देछाः छाइबलय् तःमितय्‌सं बच्‍छि शेकेल स्‍वयाः अप्‍वः अले चीमितय्‌सं कम बी मते। ");
INSERT INTO new_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","इस्राएलीतय्‌के प्रायश्‍चितया धिबा कयाः नापलायेगु पालया सेवाया निंतिं छ्यला ब्‍यु। अले व छिमिगु प्राणया प्रायश्‍चित यायेत परमप्रभुया न्‍ह्यःने इस्राएलतय्‌गु निंतिं लुमन्‍ति जुइमाः।” ");
INSERT INTO new_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ल्‍हाः सिलेत कँय्‌यागु छगः बाता दय्‌कि। उकिया लिधंसा नं कँय्‌यागु हे जुइमाः। पवित्र पाल व होमबलिया वेदीया दथुइ तयाः उकी लः तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","उकी हारून व वया काय्‌पिन्‍सं थथःगु ल्‍हाःतुति सिलेमाः। ");
INSERT INTO new_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","21","इपिं पवित्र पालय् दुहां वनीबलय् वा वेदीया लिक्‍क विशेष देछा छ्वय्‌केत वनीबलय् इमिसं थथःगु ल्‍हाःतुति सिलेमाः। मखुसा इपिं सी। थ्‍व हारून व वया लिपा वइपिं सन्‍तानयात तकं सदांया नियम जुल।” ");
INSERT INTO new_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","हाकनं परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“छं भिंगु भिंगु नस्‍वाःगु मसला– न्‍यासः शेकेल छ्वालुगु मूर्र, निसः व नेयगू शेकेल दालचिनी, निसः व नेय्‌गू शेकेल नस्‍वाःगु सिँ व ");
INSERT INTO new_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","न्‍यासः शेकेल तेजपात। (थुपिं पवित्र पाल लागायागु शेकेलकथं जुइमाः।) अले छगू हीन जैतूनया चिकं कयाः ");
INSERT INTO new_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","अभिषेक यायेगु पवित्र चिकं दय्‌कि। अत्तर दय्‌के सःम्‍हय्‌सिनं दय्‌कूगु थें दय्‌कि। व अभिषेक यायेगु पवित्र चिकं जुइ। ");
INSERT INTO new_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","अले व चिकनं पवित्र पाल, बाचाया सनू, ");
INSERT INTO new_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","छायेहःगु मरि तयातःगु तेबिल व उकी माःमाःगु ज्‍वलं, त्‍वाःदेवा व उकिया ज्‍याभः, गुँगू थनेगु वेदी, ");
INSERT INTO new_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","होमबलिया वेदी व उकिया थलबल, अले बाता व उकिया लिधंसा नापं फुक्‍कयात अभिषेक या। ");
INSERT INTO new_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","छं थुपिं फुक्‍कयात पवित्र या अले उपिं तच्‍वकं पवित्र जुइ। सुनानं थथे अभिषेक यानातःगु मालतालयात थी व पवित्र जुइ। ");
INSERT INTO new_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“हारून व वया काय्‌पिन्‍त अभिषेक यानाः पवित्र या। इमिसं पुजाहारी जुयाः जिगु सेवा यायेमाः। ");
INSERT INTO new_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","इस्राएलीतय्‌त थथे धा, ‘थ्‍व छिमि पुस्‍तां पुस्‍ता तक जिगु निंतिं अभिषेकया पवित्र चिकं जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","थ्‍व चिकं मनूयागु म्‍हय् प्‍वंके मते। थ्‍व पवित्र जूगुलिं ल्‍वाकछ्यानाः थज्‍याःगु मेगु छुं दय्‌के मते। छिमिसं थज्‍याःगु अभिषेकया चिकं पवित्र मानय् या। ");
INSERT INTO new_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","सुं मनुखं थज्‍याःगु नस्‍वाःगु चिकं दय्‌कल धाःसा वा पुजाहारी मखुपिनिगु म्‍हय् तया ब्‍यूसां वयात थः मनूतय् दथुं पितिना छ्वयेमाः।’” ");
INSERT INTO new_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","हाकनं परमप्रभुं मोशायात धयादिल, “नस्‍वाःगु मसला- थाकुराः, हिं व मेगु छता गुँगू थनेगु मसला भिंगु गुँगू नापं उति उतिं कयाः ");
INSERT INTO new_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","उकियागु नस्‍वाःगु ल्‍वाकछ्यानातःगु गुँगूया अत्तर दय्‌के सःम्‍हय्‌सिनं थें हे दय्‌कि। उकी चि नं तयेमाः। थ्‍व फुक्‍क भिंगु व पवित्र जुइमाः। ");
INSERT INTO new_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","उकियागु छुं ब्‍वःयात कयाः निनाः चुं दय्‌कि। महा पवित्र थासय् जि छनापं नापलाय्‌गु थासय्‌ बाचाया सनूया न्‍ह्यःने थ्‍व चुं ति। थज्‍याःगु गुँगू छिमिसं पवित्र मानय् या। ");
INSERT INTO new_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","थुकथं ल्‍वाकछ्यानातःगु गुँगू छिमिसं थःगु हे निंतिं गुबलें दय्‌के मते। थुकियात छं परमप्रभुया न्‍ह्यःने पवित्र भाः प्‍यु। ");
INSERT INTO new_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","सुनानं नस्‍वाःया लागि व थें च्‍वंक छुं दय्‌कल धाःसा वयात थः मनूतय् दथुं पितिना छ्वयेमाः।” ");
INSERT INTO new_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“स्‍व, जिं यहूदा कुलयाम्‍ह हूरया छय्, ऊरीया काय् बजलेलयात ल्‍ययागु दु। ");
INSERT INTO new_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","अले जिं वयात परमेश्‍वरयागु आत्‍मां, सीपं, खुबीं व फुक्‍क कथंयागु ज्‍या यायेगु ज्ञानं जाय्‌का बियागु दु। ");
INSERT INTO new_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","वं लुँ, वहः व कँय्‌यागु ज्‍या, ");
INSERT INTO new_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ल्‍वहं तछ्यानाः फाकुनय् थुनेगु ज्‍या, सिँयागु ज्‍या व फुक्‍क कथंयागु कारीगरीया ज्‍या याइ। ");
INSERT INTO new_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","दान कुलयाम्‍ह अहीसामाकया काय् ओहोलीआबयात जिं वयात ग्‍वाहालि बीत ल्‍ययागु दु। जिं छन्‍त उजं बियागु फुक्‍कं दय्‌केत ज्‍याकःमितय्‌त नं सीप बियागु दु – ");
INSERT INTO new_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","पवित्र पाल, बाचाया सनू, उकिया च्‍वय्‌यागु प्रायश्‍चितया कृपा-आसन व पालयागु ज्‍वलं, ");
INSERT INTO new_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","तेबिल व उकिया ज्‍वलं, भिंगु लुँयागु त्‍वाःदेवा व उकिया ज्‍वलं व गुँगू थनेगु वेदी, ");
INSERT INTO new_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","अले होमबलिया वेदी व उकिया फुक्‍कं थलबल, बाता व उकिया लिधंसा, ");
INSERT INTO new_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","थानातःगु वसः, हारून पुजाहारीया पवित्र वसः व पुजाहारीया सेवा याइबलय् वया काय्‌पिन्‍सं फीगु वसः, ");
INSERT INTO new_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेक यायेगु चिकं व पवित्र थासय् च्‍याकेत नस्‍वाःगु गुँगू, थ्‍व फुक्‍कं जिं छन्‍त बियागु उजंकथं हे इमिसं दय्‌केमाः।” ");
INSERT INTO new_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","छं इस्राएलीतय्‌त थथे नं धा, “छिमिसं जिगु विश्रामबार हनेगु या। लिपाया पुस्‍ता पुस्‍ता तक थ्‍व जिगु व छिमिगु दथुइया चिं जुइ। जि छिमित पवित्र याइम्‍ह परमेश्‍वर खः धकाः छिमिसं सीका काइ।” ");
INSERT INTO new_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘छिमिसं विश्रामबार हनेगु यायेमाः। व छिमिगु निंतिं पवित्र खः। सुनां थुकियात मानय् याइ मखु वयात स्‍याना छ्वयेमाः। सुनानं थुखुन्‍हु ज्‍या याइ वयात थः मनूतय् दथुं नाश यानाः छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","खुन्‍हु तक ज्‍या यायेमाः, अय्‌नं न्‍हय्‌न्‍हु खुन्‍हु आराम कायेगु दिं खः। व परमप्रभुया निंतिं पवित्र खः। सुनानं विश्रामबार खुन्‍हु ज्‍या यात धाःसा वयात स्‍याना हे छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्राएलीतय्‌सं विश्रामबार हनेमाः, अले लिपा वइपिं पुस्‍तायात तकं सदांया नियमकथं थ्‍व दिंयात हनेगु या। ");
INSERT INTO new_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","थ्‍व जिगु व इस्राएलीतय्‌गु दथुइ सदांया चिं जुइ। छाय्‌धाःसा परमप्रभुं खुन्‍हु बिकाः आकाश व पृथ्‍वी दय्‌कादिल, न्‍हय्‌न्‍हु खुन्‍हु धाःसा वय्‌कलं विश्राम कयादिल।’” ");
INSERT INTO new_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","परमेश्‍वरं मोशा लिसें सीनै पर्वतय् खँ ल्‍हाये धुंकाः वय्‌कलं वयात थःगु पतिंचां च्‍वयादीगु निपाः ल्‍वहंपौ बियादिल। ");
INSERT INTO new_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","मनूतय्‌सं मोशायात गुँच्‍वकां क्‍वहां वयेत लिबाका च्‍वंगु खनाः हारूनयाथाय् मूं वनाः वयात थथे धाल, “जिमिगु न्‍ह्यः न्‍ह्यः वनेत द्यः दय्‌कादिसँ छाय्‌धाःसा जिमित मिश्रं पितहःम्‍ह मोशायात छु जुल जिमिसं मस्‍यू।” ");
INSERT INTO new_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","अले हारूनं इमित धाल, “छिमि कलाः व काय् म्‍ह्याय्‌पिनिगु न्‍हाय्‌पनय्‌ च्‍वंगु लुँया चाःचा त्‍वःकाः जिथाय् हजि।” ");
INSERT INTO new_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","अले फुक्‍कं मनूतय्‌सं थथःगु न्‍हाय्‌पनय्‌ च्‍वंगु लुँयागु चाःचा त्‍वःयाः हारूनयाथाय् हल। ");
INSERT INTO new_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","वं उकियात इमिगु ल्‍हातं कयाः नाय्‌काः कतां कियाः उकिं छम्‍ह द्वहंचाया मूर्ति दय्‌कल। अले मनूतय्‌सं थःथवय् धाल, “हे इस्राएलीत, छिमित मिश्रं पितहःम्‍ह छिमि द्यः थ्‍व हे खः।” ");
INSERT INTO new_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","थ्‍व खनाः हारूनं द्वहंचाया न्‍ह्यःने छगू वेदी दय्‌कल। वं थथे धकाः च्‍वय्‌कल, “कन्‍हय् परमप्रभुया निंतिं छगू नखः जुइ।” ");
INSERT INTO new_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","अले कन्‍हय् खुन्‍हु सुथय् न्‍हापां मनूतय्‌सं होमबलि छाल, अले मेलबलि नं हल। इपिं फेतुनाः नयेत्‍वने धुंकाः दनाः यःयःथें सन। ");
INSERT INTO new_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","अले परमप्रभुं मोशायात धयादिल, “याकनं क्‍वय् क्‍वहां हुँ छाय्‌धाःसा छं मिश्रं पित हःपिं मनूत स्‍यनावने धुंकल। ");
INSERT INTO new_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","इपिं जिं उजं बियागु लँपुपाखें याकनं हे फहिलाः मेखेपाखे वंगु दु। आः ला इमिसं थःगु निंतिं छम्‍ह द्वहंचाया मूर्ति दय्‌काः वयागु पुजायात, अले बलि छानाः थथे धाल, ‘हे इस्राएलीत, छिमित मिश्रपाखें पितहःम्‍ह द्यः थ्‍व हे खः।’” ");
INSERT INTO new_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","परमप्रभुं मोशायात धयादिल, “जिं थुपिं मनूतय्‌त खनागु दु, थुपिं जिराहा मनूत खः। ");
INSERT INTO new_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","आः जितः पने मते, छाय्‌धाःसा जिगु तं मि थें च्‍यानाच्‍वंगु दु। जिं इमित भस्‍म यानाछ्वये। अले छपाखें हे जिं तःधंगु जाति दय्‌के।” ");
INSERT INTO new_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","मोशां परमप्रभु थः परमेश्‍वरयात इनाप यानाः धाल, “हे परमप्रभु, छिगु तःधंगु शक्तिं व बल्‍लाःगु ल्‍हातं मिश्रं पित हयादीपिं थः मनूतपाखे छाय् मि थें च्‍याःगु तं पिकयादियागु? ");
INSERT INTO new_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","छिं इमित पर्वतय् स्‍यानाः थ्‍व पृथ्‍वीं इमिगु नां हे हुयाछ्वयेगु मभिंगु बिचालं पित यंकादीगु खः धकाः मिश्रीतय्‌त छाय् धाय्‌के बियेगु? छिगु व मि थें च्‍याःगु तंयात शान्‍त यानादिसँ। अले थःगु मन हिकाः थः मनूतय्‌त नाश जुइगुपाखें बचय् यानादिसँ। ");
INSERT INTO new_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","अब्राहाम, इसहाक व याकूबयात छिं थःगु नामं पाफयाः ‘जिं छिमि सन्‍तान आकाशय् च्‍वंगु नगु थें अप्‍वः दय्‌काबी, जिं बाचा यानागु थ्‍व हे देश छिमि सन्‍तानयात बी अले इमिसं न्‍ह्याबलें अन हे अधिकार याइ धकाः धयादीगु खँ लुमंकादिसँ।’” ");
INSERT INTO new_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","अले परमप्रभुं थः मनूतय्‌त स्‍यंकेगु बिचाःयात हीकादिल। ");
INSERT INTO new_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","अनं लिपा मोशा थःगु ल्‍हातय् बाचाया उपिं ल्‍वहंपौ ज्‍वनाः पर्वतं क्‍वय् क्‍वहां वल। उपिं ल्‍वहंपौलय् निखें च्‍वयातःगु दु। ");
INSERT INTO new_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","थुपिं निपां ल्‍वहंपौ परमेश्‍वरं दय्‌कादीगु खः। उकी च्‍वयातःगु आखः नं वय्‌कलं हे किया च्‍वयादीगु खः। ");
INSERT INTO new_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","यहोशूं मनूत तस्‍सलं हाःगु सः तायाः मोशायात धाल, “छाउनीइ ल्‍वापु जूगु थें सः ताये दयाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","मोशां लिसः बिल, “थ्‍व सः त्‍याःपिनिगु नं मखु बूपिनिगु नं मखु। जिं धाःसा म्‍ये हाःगु सः थें तायाच्‍वनागु दु।” ");
INSERT INTO new_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","मोशां छाउनी न्‍ह्यः वयेवं द्वहंचा व प्‍याखं हुलाच्‍वंगु खनाः तसकं तं पिकाल। अले वं ल्‍वहंपौत गुँया क्‍वय् वान्‍छ्वयाः तछ्यानाबिल। ");
INSERT INTO new_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","अले इमिसं दय्‌कूगु द्वहंचा कयाः वं मिइ छ्वय्‌काः उकियात चुंचुं यानाः लखय् ल्‍वाकछ्याना बिल। अले वं इस्राएलीतय्‌त त्‍वंके बिल। ");
INSERT INTO new_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","अनंलि मोशां हारूनयात धाल, “थुपिं मनूतय्‌सं छितः छु याःगु दु धकाः छिं थुमित थुलि तःधंगु पाप याके बियागु?” ");
INSERT INTO new_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारूनं लिसः बिल, “जिमि प्रभु, जि खनाः तंचायादी मते। थुपिं मनूतय्‌त छिं बांलाक म्‍ह हे स्‍यू। थुमिगु मन मभिंपाखे वनाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","इमिसं जितः धाल, ‘जिमि न्‍ह्यः न्‍ह्यः वनेत छम्‍ह द्यः दय्‌कि, छाय्‌धाःसा जिमित मिश्रं पितहःम्‍ह मोशायात छु जुल धकाः जिमिसं मस्‍यू।’ ");
INSERT INTO new_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","अथे जुयाः जिं इमित धया, ‘सुयाके सुयाके लुँयागु तिसा दु, व त्‍वयाः हजि।’ अले इमिसं जितः लुँ बिल। जिं लुँयात मिइ तयाबिया, अले थ्‍व द्वहंचा पिहां वल।” ");
INSERT INTO new_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","मोशां मनूत थः यःथें जुयाच्‍वंगु खन। हारूनं इमित कःमघासें थः यःथें वने ब्‍यूगुलिं इपिं थः शत्रुतय् न्‍ह्यःने न्‍हिलेगु हुनि जुल। ");
INSERT INTO new_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","अथे जुयाः मोशां छाउनीया ध्‍वाखाया लिक्‍क दनाः तसलं हालाः धाल, “परमेश्‍वरया पाखेयापिं जिथाय् वा।” अले लेवीया कुलयापिं फुक्‍कं वयाथाय् मूं वल। ");
INSERT INTO new_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","मोशां इमित धाल, “परमप्रभु इस्राएलया परमेश्‍वरं थथे धयादी, ‘छिपिं फुक्‍कसिनं थथःगु तरवार ज्‍वनाः छाउनीयागु छगू कुन्‍चांनिसें मेगु कुन्‍चाय् तक लुखा लुखाय् वनाः थःकिजा, थः पासा व थः जःलाखःलायात स्‍यास्‍यां हुँ।’” ");
INSERT INTO new_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","अले लेवीतय्‌सं मोशां धाःथें यात। व हे दिं स्‍वद्वःति मनूत सित। ");
INSERT INTO new_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","अले मोशां धाल, “थौं छिमिसं थःकाय् व किजापिन्‍त स्‍यानाः थःपिन्‍त परमप्रभुया निंतिं सेवा यायेत लःल्‍हाना ब्‍यूगु दु। थौं वय्‌कलं छिमित तःधंगु आशिष बियादीगु दु।” ");
INSERT INTO new_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","कन्‍हय् खुन्‍हु मोशां मनूतय्‌त धाल, “द्वहंचायात पुजा यानाः छिमिसं तःधंगु पाप याःगु दु। जि परमप्रभुयाथाय् पर्वतय् थहां वने। जिं छिमिगु पापया प्रायश्‍चित याये फइ ला?” ");
INSERT INTO new_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","अले मोशा परमप्रभुयाथाय् थहां वनाः थथे धाल, “मनूतय्‌सं गुलि तःधंगु पाप याःगु दु। इमिसं थःगु निंतिं लुँयाम्‍ह द्यः दय्‌कूगु दु। ");
INSERT INTO new_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","अय्‌जूसां थुमिगु पाप क्षमा यानादिसँ, मखुसा छिं च्‍वयादीगु सफुलिं जिगु नां हुयादिसँ।” ");
INSERT INTO new_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","अले परमप्रभुं मोशायात धयादिल, “सुनां जिगु विरोधय् पाप याःगु दु, वयागु नां हे जिं थःगु सफुलिं हुयाछ्वये। ");
INSERT INTO new_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","हुँ, जिं छन्‍त धयागु देशय् मनूतय्‌त ब्‍वनायंकि। जिम्‍ह दूत छंगु न्‍ह्यः न्‍ह्यः वनी। अथेजूसां जिं सजाँय बीगु ई वइबलय् इमित पापया सजाँय बी।” ");
INSERT INTO new_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","हारूनं दय्‌कूम्‍ह द्वहंचायात पुजा याःगुलिं परमप्रभुं इमिथाय् महामारी छ्वयादिल। ");
INSERT INTO new_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","अले परमप्रभुं मोशायात धयादिल, “छ व छं मिश्रं पित हःपिं मनूत थ्‍व थाय् त्‍वःताः जिं अब्राहाम, इसहाक व याकूबयात ‘छिमि सन्‍तानयात बी’ धकाः बचं बियागु देशय् हुँ। ");
INSERT INTO new_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","जिं छम्‍ह दूतयात छिमिगु न्‍ह्यः न्‍ह्यः छ्वयाबी अले कनानी, एमोरी, हित्ती, परिज्‍जी, हिव्‍वी व यबूसीतय्‌त लिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","दुरु व कस्‍ति बाः वयाच्‍वंगु देशय् हुँ। अय्‌नं जि छिपिंनापं वने मखु। छिपिं जिराहा मनूत जूगुलिं जिं छिमित लँय् हे नाश यायेगु जुइ।” ");
INSERT INTO new_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","मनूतय्‌सं थ्‍व मभिंगु खँ न्‍यंबलय् इमिसं नुगः मछिंकल। अले सुनानं थःगु तिसा मतिल। ");
INSERT INTO new_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","छाय्‌धाःसा परमप्रभुं मोशायात धयादीगु दु, “इस्राएलीतय्‌त धा, ‘छिपिं जिराहा मनूत खः। जि पलख जक छिमिगु दथुइ वःसा जिं छिमित भस्‍म यानाबी। आः छिमिसं थथःगु तिसा त्‍वः, अले छिमित छु यायेमाः जिं बिचाः याये।’” ");
INSERT INTO new_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","अथे जुयाः होरेब पर्वतय् इस्राएलीतय्‌सं थथःगु तिसा त्‍वल। ");
INSERT INTO new_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","मोशां छपा पाल कयाः छाउनी पिने भचा तापाक्‍क ग्‍वइ। उकियात मुनेगु पाल धकाः धाइगु। सुं मनुखं परमप्रभुलिसे छुं न्‍यने माःसा व छाउनी पिने थ्‍व हे मुनेगु पालय् वनीगु जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","मोशा पिहां वनीबलय् फुक्‍कं मनूत थथःगु पालया लुखाय् दनी, मोशा व पाल दुने दुहां मवंतले वयात हे स्‍वयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","मोशा पाल दुने दुहां वनेधुंकाः परमप्रभुं मोशालिसे खँ ल्‍हानादीबलय् सुपाँय्‌यागु थां पालया क्‍वय् लुखाय् दनी। ");
INSERT INTO new_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","मनूतय्‌सं सुपाँय्‌या थां पालया लुखाय् च्‍वंगु खनीबलय् इमिसं थथःगु पालया लुखाय् पिने क्‍वपुसां पुयाः आराधना याइ। ");
INSERT INTO new_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","परमप्रभु मोशालिसे थुकथं चुलिंचू थः पासापिंनापं थें खँ ल्‍हानादीगु जुयाच्‍वन। मोशा हाकनं छाउनीइ लिहांवनी। वयात ग्‍वाहालि याइम्‍ह ल्‍याय्‌म्‍ह नूनया काय् यहोशू धाःसा पालय् च्‍वनाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","मोशां परमप्रभुयात धाल, “छिं जितः थुपिं मनूतय्‌त ब्‍वनायंकि धकाः धयादीगु दु, अय्‌नं जिनापं सुयात छ्वयादी धकाः धयादीगु मदुनि। छिं धयादीगु दु, ‘जिं छन्‍त म्‍हस्‍यू, अले जिगु दया छंके दु।’ ");
INSERT INTO new_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","छि जिनापं लय्‌ताःसा जितः लँपु क्‍यनादिसँ। छितः म्‍हसीके फयेमा अले छिगु दया जिके दयाच्‍वनेमा। लुमंकादिसँ, थ्‍व जाति छिकपिनि हे मनूत खः।” ");
INSERT INTO new_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","परमप्रभुं लिसः बियादिल, “जि थः हे छनापं वने अले जिं छन्‍त विश्राम बी।” ");
INSERT INTO new_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","वं वय्‌कःयात धाल, “छि थः हे जिपिंनापं मझायेगु जूसा जिमित थनं न्‍ह्यःने यंकादी मते। ");
INSERT INTO new_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","जिपिंनापं मवंतले जि व जिमि मनूतय्‌सं छिगु दया जिमिके दु धकाः गथे यानाः सीकेगु? मेगु छु खं जि व छिकपिनि मनूत पृथ्‍वी च्‍वंपिं मनूत स्‍वयाः अलग जुइ?” ");
INSERT INTO new_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","अले परमप्रभुं मोशायात धयादिल, “छं धाःथें जिं याये, छाय्‌धाःसा जि छ खनाः लय्‌ताः अले जिं छन्‍त बांलाक हे म्‍हस्‍यू।” ");
INSERT INTO new_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","वं धाल, “आः जितः छिगु महिमा क्‍यनादिसँ।” ");
INSERT INTO new_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","वय्‌कलं धयादिल, “जिं छंगु न्‍ह्यःने हे थःगु फुक्‍कं भिंगु क्‍यने, अले छंगु न्‍ह्यःने हे परमप्रभुया नां च्‍वय्‌के। जिं सुयात कृपा याये मास्‍ति वइ वयात कृपा याये। सुयात जिं दया याये मास्‍ति वइ वयात दया याये।” ");
INSERT INTO new_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","अले वय्‌कलं धयादिल, “अय्‌नं छं जिगु ख्‍वाः स्‍वये फइ मखु, छाय्‌धाःसा जिगु ख्‍वाः स्‍वयाः सुं नं मनूत म्‍वानाच्‍वने फइ मखु।” ");
INSERT INTO new_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","अले परमप्रभुं धयादिल, “जिगु लिक्‍क तग्‍वःगु ल्‍वहँतय् छ दँ। ");
INSERT INTO new_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","जिगु महिमा अनं जुया वनीबलय् जिं छन्‍त व ल्‍वहंयागु कापिचाय्‌ तयाबी। अले अनं जुया मवंतले छन्‍त जिगु ल्‍हातं हे त्‍वपुयातये। ");
INSERT INTO new_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","हानं जिं ल्‍हाः लिकाये, अले छं जिगु म्‍हया ल्‍युनेपाखे जक खनी। जिगु ख्‍वाः धाःसा खनेदइ मखु।” ");
INSERT INTO new_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","परमप्रभुं मोशायात धयादिल, “न्‍हापा थें ल्‍वहंयागु निपाः पौ हजि। अले जिं उकी छं न्‍हापा तछ्याःगु पौतय् च्‍वयातःगु हे खँ च्‍वयाबी। ");
INSERT INTO new_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","छ सुथ न्‍हापां हे तयार जुयाः सीनै पर्वतया च्‍वकाय् जिगु न्‍ह्यःने थहां वा। ");
INSERT INTO new_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","छनापं सुं नं मनू मवयेमाः। उलि जक मखु पर्वतय् गन नं सुं मनू खने मदयेमाः। फैच्‍वलय् व सा द्वहं नं पर्वतया न्‍ह्यःने मज्‍वयेमाः।” ");
INSERT INTO new_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","अले मोशां न्‍हापायागु थें ल्‍वहंपौ निपाः चानाः दय्‌कल, अले परमप्रभुं आज्ञा बियादीगु थें सुथ न्‍हापां सीनै पर्वतय् थहां वन। ");
INSERT INTO new_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","अले परमप्रभु सुपाँचय् क्‍वहां झायाः व नापं अन दनाः थःगु पवित्र नां, “परमप्रभु” धकाः न्‍ववानादिल। ");
INSERT INTO new_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","अनंलि परमप्रभु वया न्‍ह्यःने झायाः थथे धकाः धयादिल, “परमप्रभु, परमप्रभु दयादुम्‍ह, सदां दयामाया यानादीम्‍ह, तंचायेत लिबाकादीम्‍ह व तसकं विश्‍वास याये बहःम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","वय्‌कः द्वलंद्वःयात माया यानादीम्‍ह, अधर्म, अपराध व पाप क्षमा यानादीम्‍ह खः। अय्‌सां वय्‌कलं द्वंयाःम्‍हय्‌सित सजाँय मब्‍यूसे त्‍वःतादी मखु। वय्‌कः पुर्खाया अधर्मया सजाँय इमि छय् व छुइया पालय् तकं नं बियादीम्‍ह खः।” ");
INSERT INTO new_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","अले मोशां हथासं बँय्‌पाखे क्‍वछुनाः आराधना यात। ");
INSERT INTO new_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","वं धाल, “हे परमप्रभु, छिं जिमित धात्‍थे माया यानादियागु खःसा छि जिपिंनापं झासँ। थ्‍व छगू जिराहा जाति जूसां जिमिगु अधर्म व पाप क्षमा यानादिसँ, अले जिमित थःगु हे सम्‍पत्ति थें नाला कयादिसँ।” ");
INSERT INTO new_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","अले परमप्रभुं धयादिल, “स्‍व, जिं छनापं छगू बाचा चिने। पृथ्‍वीइ फुक्‍कं जातितय् दथुइ गुबलें मजूगु अजू चायापुगु ज्‍या जिं छिमि मनूतय् न्‍ह्यःने यानाक्‍यने। अले छिमिगु दथुइ च्‍वनाच्‍वंपिं मनूतय्‌सं परमप्रभुया ज्‍या खनी, छाय्‌धाःसा जिं छपाखें छगू तःधंगु ज्‍या याये। ");
INSERT INTO new_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","थौं जिं छन्‍त बियाच्‍वनागु उजंयात मानय् या। स्‍व, जिं छंगु न्‍ह्यःनें एमोरी, कनानी, हित्ती, परिज्‍जी, हिव्‍वी व यबूसीतय्‌त लिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","बांलाक होश यानाच्‍वँ, व देय्‌यापिं मनूतलिसें छं सन्‍धि याये मते, मखुसा इपिं छिमिगु निंतिं तक्‍यनीगु जाः जुइ। ");
INSERT INTO new_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","इमिगु वेदीत स्‍यंकाब्‍यु। इमिगु पवित्र ल्‍वहंत तछ्यानाब्‍यु, अले इमि अशेरा द्यःमय्‌जुयागु थांतय्‌त पालाः क्‍वथलाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","छिमिसं मेम्‍ह सुं द्यःयागु पुजा याये मते। परमप्रभुया नां ‘नुगः मुइकादीम्‍ह’ खः। थ्‍व खनाः वय्‌कलं नुगः मुइकादी। ");
INSERT INTO new_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“होश यानाच्‍वँ, व देय्‌यापिं मनूतलिसें सन्‍धि याये मते, मखुसा इमिसं थः द्यःतय्‌त बां बियाः पुजा यानाः भ्‍वय् न्‍याय्‌कीबलय् छिमित नं सःती अले छिमिसं इमिगु भ्‍वय् नइ। ");
INSERT INTO new_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","अले छिमिसं उपिं जातयापिं भौमचात हयाः इमिसं थः द्यःतय्‌गु पुजा याइबलय् छिमि काय्‌पिन्‍त नं अथे हे याकेबी। ");
INSERT INTO new_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“छिमिसं थःगु निंतिं नाय्‌काः मूर्तित दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“सोडा मतःगु मरिया नखः हनेगु या। जिगु उजंकथं आबीब लाया क्‍वःछिनातःगु इलय् न्‍हय्‌न्‍हु तक सोडा मतःगु मरि नयेगु या। आबीब लाय् हे छिपिं मिश्र देशं पिहां वःगु खः। ");
INSERT INTO new_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“न्‍हापां बूपिं फुक्‍क काय्‌मस्‍त जिम्‍ह खः। अले सा द्वहं व फैच्‍वलय्‌तय् न्‍हापां बूपिं बाजात नं जिम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","न्‍हापां बूम्‍ह गधाया मचायात चिधिकःम्‍ह भ्‍याःचानापं लिफ्‍या, लिमफ्‍यायेगु जूसा वयागु गःपः त्‍वथुलाब्‍यु। छिमिसं न्‍हापां बूपिं काय् मस्‍तय्‌त नं लिफ्‍याना कायेमाः। “सुं नं जिगु न्‍ह्यःने ल्‍हातय् छुं मदय्‌क खनेदः वये मते। ");
INSERT INTO new_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“खुन्‍हु तक ज्‍या या, तर न्‍हय्‌न्‍हु खुन्‍हु आराम का। बुँ पुलेगु व छ्व लयेगु इलय् नं आराम का। ");
INSERT INTO new_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“छिमिसं बुँइ न्‍हापां सःगु छ्व नापं सामाज्‍याया नखः हनेगु या। हानं न्‍हय्‌गूगु लाय् थथःगु फल खाये धुंकाः मुनेगु नखः हनेगु या। ");
INSERT INTO new_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","दँय् स्‍वक्‍वः फुक्‍क मिजंत परमप्रभु इस्राएलया परमेश्‍वरया न्‍ह्यःने खनेदय्‌कः वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","जिं छिमिगु न्‍ह्यःने जातितय्‌त लिनाछ्वये। देशया लागि लागा अप्‍वः यानाः बी। दँय् स्‍वक्‍वः छिपिं परमप्रभु छिमि परमेश्‍वरया न्‍ह्यःने वनीबलय् सुनानं छिमिगु बुँयात ल्‍ववंकी मखु। ");
INSERT INTO new_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“जितः बलि छायेबलय् सोडा दुगु मरि छाय् मते। सुथ जुइ न्‍ह्यः तकं छुत्‍काराया बलिया ला फुकेमाः, ल्‍यंकातये मते। ");
INSERT INTO new_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“छिमिगु बुँयागु दकलय् भिंगु न्‍हापां सःगु अन्‍न व फल परमप्रभु छिमि परमेश्‍वरयाथाय् हजि। “सुं च्‍वलेचाया मचायात वया मांया दुरुइ दय्‌के मते।” ");
INSERT INTO new_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","अनं लिपा परमप्रभुं मोशायात धयादिल, “थुपिं वचन च्‍व, छाय्‌धाःसा थुपिं हे वचनकथं छ व इस्राएलीतनापं जिं बाचा चिनागु दु।” ");
INSERT INTO new_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मोशा अन परमप्रभुनापं पिइन्‍हु पिइचा तक छुं हे नयेत्‍वने मयासें च्‍वन। वं उपिं ल्‍वहँपतिइ बाचाया झिगू उजं च्‍वल। ");
INSERT INTO new_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","बाचा चिनादीगु निपाः ल्‍वहंपौ ज्‍वनाः सीनै पर्वतं क्‍वहां वःबलय् परमेश्‍वर व नापं खँ ल्‍हानादीगुलिं थःगु ख्‍वाः ज्‍वल्‍ल थीगु दु धकाः वं मस्‍यू। ");
INSERT INTO new_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","हारून व फुक्‍क इस्राएलीतय्‌सं मोशायागु ख्‍वाः थियाच्‍वंगु खनाः इपिं वयागु न्‍ह्यःने वयेत ग्‍यात। ");
INSERT INTO new_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","अय्‌नं मोशां इमित सःतल, अले हारून व खलःया थकालित वयाथाय् वल, अले वं इपिं नापं खँ ल्‍हात। ");
INSERT INTO new_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","अनंलि फुक्‍क इस्राएलीत वया न्‍ह्यःने वल, अले इमित परमप्रभुं सीनै पर्वतय् बियादीगु फुक्‍क उजं न्‍यंकाबिल। ");
INSERT INTO new_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","इपिं नापं खँ ल्‍हाये धुंकाः थःगु ख्‍वाः गाबलं त्‍वपुल। ");
INSERT INTO new_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","मोशा परमप्रभुया न्‍ह्यःने वय्‌कः नापं खँ ल्‍हायेत वनीबलय् धासाः वं पिने पिहां मवतले थःगु ख्‍वाः उलिगु याइ। अले परमप्रभुं वयात छु उजं बियादी पिने वयाः वं इस्राएलीतय्‌त न्‍यंकी। ");
INSERT INTO new_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","अले इस्राएलीतय्‌सं मोशायागु ख्‍वाः ज्‍वाल्‍ल थीगु खनीगु। परमप्रभुलिसे खँ ल्‍हायेत दुने दुहां मवंतले हे थःगु ख्‍वाः त्‍वपुया तइगु। ");
INSERT INTO new_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोशां इस्राएलया फुक्‍क मनूतय्‌त छथाय् मुंकाः इमित धाल, “परमप्रभुं उजं बियादीगु छिमिसं यायेमाःगु ज्‍या थथे दु – ");
INSERT INTO new_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","खुन्‍हु तक ज्‍या यायेगु या, अले न्‍हय्‌न्‍हु खुन्‍हुया दिं धाःसा छिमिगु निंतिं पवित्र खः। थ्‍व दिं परमप्रभुया निंतिं विश्रामबार खः। व दिं सुनानं ज्‍या यात धाःसा वयात स्‍याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","छिमिगु सुयागु छेँ विश्रामबार खुन्‍हु भुतुलिइ मि तक च्‍याके मते।” ");
INSERT INTO new_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मोशां फुक्‍क मनूतय्‌त थथे धाल, “परमप्रभुं उजं बियादीगु खँ थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","छिपिं थःपिनि दथुं परमप्रभुया निंतिं देछा मुँ। बीगु मनदुपिं फुक्‍कसिनं परमप्रभुयाथाय् लुँ, वहः, कँय्, ");
INSERT INTO new_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","वँचुगु, प्‍याजीगु व ह्याउँगु का अले भिंगु सूती कापः, च्‍वलय्‌चिगु सँ, ");
INSERT INTO new_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ह्याउँगु रंग छिया तःगु फैचायागु छेंगू, डल्‍फिनयागु छेंगू, खयःसिँ, ");
INSERT INTO new_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","मतःया निंतिं जैतूनयागु चिकं, अभिषेक याइगु चिकं व नस्‍वाःगु गुँगूयात मसला, ");
INSERT INTO new_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","अले एपोद व छातिपाताय् घाकेत थीथी मू वंगु थीत हजि। ");
INSERT INTO new_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“छिपिं मध्‍ये ज्‍या सःपिं वयाः परमप्रभुं उजं बियादीगु फुक्‍क दय्‌कि– ");
INSERT INTO new_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","नापलायेगु पाल, पवित्र पाल व त्‍वपुइगु इलां, अंकुसि, सिँपौ, खगः, थांत व लिधंसात। ");
INSERT INTO new_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","अले सनू व उकिया न्‍वःत, प्रायश्‍चितया कृपा-आसन व उकी न्‍ह्यःने यख्‍खानातःगु पर्दा, ");
INSERT INTO new_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","तेबिल व उकिया न्‍वःत, अले उकिया फुक्‍क ज्‍वलं, व देछायेगु मरि, ");
INSERT INTO new_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","त्‍वाःदेवा व उकिया ज्‍वलं, अले पाल्‍चाया निंतिं चिकं, ");
INSERT INTO new_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","गुँगूया वेदी व उकिया न्‍वःत, अभिषेक याइगु चिकं, नस्‍वाःगु गुँगू व पवित्र पालयागु लुखाया पर्दा, ");
INSERT INTO new_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","होमबलिया वेदी, व उकी च्‍वंगु कँय्‌यागु चालिंचा, उकिया न्‍वःत व फुक्‍कं ज्‍वलं। अले कँय्‌यागु ल्‍हाःतुति सिलेगु बाता व उकियागु लिधंसा। ");
INSERT INTO new_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","अले चुकया प्‍यखेरं च्‍वंगु ख्‍वातुगु कापः, उकियागु थां व लिधंसा, चुकया ध्‍वाखाया पर्दा। ");
INSERT INTO new_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","नापलायेगु पालया चुकयात थनेत नकिं व खिपः। ");
INSERT INTO new_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पवित्र पालय् सेवा यायेत थानातःगु वसः- हारून तःधंम्‍ह पुजाहारीयात पवित्र वसः अले पुजाहारीया सेवा यायेत वया काय्‌पिनिगु वसः।” ");
INSERT INTO new_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","अले इस्राएलया फुक्‍क खलः मोशाया न्‍ह्यःनं थथःगु पालय् लिहां वन। ");
INSERT INTO new_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","देछा छायेगु मनदुपिं फुक्‍क वल अले नापलायेगु पाल दय्‌केत, अन सेवा यायेत व पवित्र वसः सुइत परमप्रभुयाथाय् देछा हल। ");
INSERT INTO new_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","देछा छायेगु मनदुपिं मिसा व मिजंतय्‌सं मार्वरि, अंगू, चाः व सिखः थें ज्‍याःगु लुँयागु तिसा हल। ");
INSERT INTO new_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","सुयाके सुयाके वँचुगु, प्‍याजीगु व ह्याउँगु का, भिंगु सूती कापः, च्‍वलय्‌चिया सँ, ह्याउँगु रंग छिनातःगु फैचायागु छेंगू, डल्‍फिनयागु छेंगू दु, इमिसं व हल। ");
INSERT INTO new_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","वहः व कँय्‌यागु देछा छाइपिन्‍सं परमप्रभुयात देछा धकाः हल। सुयाके ज्‍या यायेत खयःसिँ दु, वं व हल। ");
INSERT INTO new_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ज्‍या सःपिं मिसातय्‌सं थःम्‍हं हे निलातःगु वँचुगु, प्‍याजीगु, ह्याउँगु का व सूती कापः हल। ");
INSERT INTO new_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","अले मनदुपिं व ज्‍या सःपिं फुक्‍क मिस्‍तय्‌सं च्‍वलेचिया सँया तँय निल। ");
INSERT INTO new_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","नायःतय्‌सं एपोद व छातिपाताय् तयेत आनिक्‍स व मेगु थीत हल। ");
INSERT INTO new_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","मत च्‍याकेत, अभिषेक यायेत व गुँगू थनेत मसला व जैतूनया चिकं हल। ");
INSERT INTO new_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","मनदुपिं इस्राएली मिसा व मिजंतय्‌सं परमप्रभुं मोशापाखें बियादीगु उजंकथं फुक्‍क ज्‍याया निंतिं परमप्रभुयाथाय् थः यःछि देछा हल। ");
INSERT INTO new_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","अले मोशां इस्राएलीतय्‌त धाल, “स्‍व, परमप्रभुं यहूदाया कुलयाम्‍ह, हूरया छय्, ऊरीया काय्, बजलेलयात नां कयाः सःतादीगु दु। ");
INSERT INTO new_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","अले वयात परमेश्‍वरया आत्‍मां सीप, खुबी व ल्‍हाःया फुक्‍क कथंया ज्‍याया ज्ञानं जाय्‌कादीगु दु। ");
INSERT INTO new_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","थ्‍व वं लुँ, वहः व कँय्‌यागु बांलाःगु बुत्ता दय्‌केगु, ");
INSERT INTO new_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","थुनेत थी चायेगु, सिँइ बुत्ता दय्‌केगु अले फुक्‍क कथंयागु ल्‍हाःया ज्‍या बांलाक यायेमा धकाः यानादीगु खः। ");
INSERT INTO new_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","परमप्रभुं वयात व दानया कुलयाम्‍ह अहीसामाकया काय् ओहोलीआब निम्‍हय्‌सित मेपिन्‍त स्‍यनेगु खुबी बियादीगु दु। ");
INSERT INTO new_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","वय्‌कलं इपिं ल्‍हाःया ज्‍या व नमूना दय्‌केगु ज्‍या वँचुगु, प्‍याजीगु व ह्याउँगु का अले भिंगु सुति कापतय् बुत्ता भरय् यायेगु व थायेगु ज्‍याय्, फुक्‍क कथंयागु बांलाक ज्‍या याये सःपिं जुइमाः धकाः इमित सीपं जाय्‌कादीगु दु।” ");
INSERT INTO new_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“बजलेल, ओहोलीआब व परमप्रभुं पवित्र पाल दय्‌केत सीप व खुबी बियादीपिं ज्‍या सःपिं मनूतय्‌सं परमप्रभुं उजं बियादीगुकथं ज्‍या यायेमाः।” ");
INSERT INTO new_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","अले मोशां बजलेल, ओहोलीआब व परमप्रभुं खुबी बियादीपिं व ज्‍या यायेत मनदुपिं फुक्‍कसित सःतल। ");
INSERT INTO new_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","पवित्र पाल दय्‌केत इस्राएलीतय्‌सं हःगु देछा फुक्‍कं इमिसं मोशाया ल्‍हातं काल। अय्‌नं मनूतय्‌सं हानं सुथ पतिकं नं थः यःछि देछा हया हे च्‍वन। ");
INSERT INTO new_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","अथे जुयाः पवित्र पाल लागाय् ज्‍या याइपिं थथःगु ज्‍या त्‍वःताः मोशायाथाय् वल। ");
INSERT INTO new_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","अले इमिसं थथे धाल, “मनूतय्‌सं परमप्रभुं दय्‌केत उजं बियादीगु ज्‍याया निंतिं माःगु स्‍वयाः अप्‍वः ज्‍वलं हयाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","अले मोशां छाउनी न्‍यंकं थथे धकाः च्‍वय्‌कल, “आवंलि सुं मिजं वा मिसां पवित्र पालया निंतिं देछायेत मेगु छुं नं हये मते।” अथे जुयाः मनूतय्‌सं मेगु देछा हयेगु दिकल। ");
INSERT INTO new_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","फुक्‍क ज्‍या यायेत इमिके माःगु स्‍वयाः अप्‍वः सामान दये धुंकल। ");
INSERT INTO new_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ज्‍या याये सःपिं मनूतय्‌सं भिंगु वँचुगु प्‍याजीगु व ह्याउँगु रंगयागु सूती कापःयागु झिपा कापःया इलां दय्‌कल। थुकी करूबया बांलाक बुत्ता भरय् यानातःगु दु। ");
INSERT INTO new_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","फुक्‍क कापः १२ मिटर हाकः व २ मिटर ब्‍या दुगु जुल। फुक्‍क कापः अपाय्‌कू हे दुगु जुल। ");
INSERT INTO new_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","न्‍याकू कापःयात सुयाः छपाः हे यात। अले मेगु न्‍याकू कापःयात नं अथे हे यात। ");
INSERT INTO new_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","न्‍हापां स्‍वाःगु कापःया सिथय् वँचुगु कापःयागु स्‍वःतिपाँय् दय्‌कल। अथे हे लिपाः स्‍वाःगु कापःया सिथय् सिथय् नं वँचुगु कापःयागु स्‍वःतिपाँय् दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","अले न्‍हापां स्‍वाःगु कापःया न्‍हापांगु कुचाय् नेय्‌गू स्‍वःतिपाँय् दय्‌कल। अथे हे लिपा स्‍वाःगु कापःया लिपांगु कुचाय् नं नेय्‌गू स्‍वःतिपाँय् दय्‌कल। उपिं चुलिंचू लाःगु जुल। ");
INSERT INTO new_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","अनंलि लुँयागु अंकुसि दय्‌काः थ्‍व हे अंकुसि निपाः कापःयात छपाः यानाः स्‍वानाबिल। थुकथं निकू कापः छकू जुल। ");
INSERT INTO new_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","अनंलि थ्‍व हे कापःया च्‍वय् त्‍वपुयेत च्‍वलय्‌चिगु सँयागु झिंछकू कापः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","फुक्‍क कापः अपाय्‌कू हे दुगु जुल। अले १३ मिटर हाकः व २ मिटर ब्‍या जुइक दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","न्‍याकू कापःयात स्‍वानाः छकू यानाः मेगु खुकू कापःयात नं स्‍वानाः छकू यात। ");
INSERT INTO new_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","अले न्‍हापां स्‍वाःगु कापःया लिपांगु कुचाय् नेय्‌गू स्‍वःतिपाँय् दय्‌कल। लिपा स्‍वाःगु कापः नं अथे यात। ");
INSERT INTO new_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","अनंलि कँय्‌यागु नेय्‌गू अंकुसि दय्‌काः निपाः कापःयात छपाः यानाः स्‍वानाबिल। ");
INSERT INTO new_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","पवित्र पाल त्‍वपुयेत हानं मेगु नितँ इलां तंछात। छगू ह्याउँगु रंग छिनातःगु फैया छेंगूयागु व मेगु डल्‍फिनयागु छेंगूयागु। ");
INSERT INTO new_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","इलां दिकेत खयः सिमाया सिँपौ दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","फुक्‍क सिँपौ ४ मिटर हाकः व ६६ से.मि. ब्‍या दुगु जुल। ");
INSERT INTO new_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","फुक्‍क सिँपौतय् निगू निगू चूल तानाः स्‍वानातल। पवित्र पालया फुक्‍क सिँपौत थुकथं हे दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","पवित्र पालया दच्‍छिनपाखे तयेत निइपौ सिँपौ दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","निइपौ सिँपौया तःलय् वहःयागु पिइगू लिधंसा दय्‌कल। छपौ छपौ सिँपौया तःलय् निगू निगू लिधंसा। ");
INSERT INTO new_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","पवित्र पालया उत्तरपाखे तयेत निइपौ सिँपौ दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","अले निइपौ सिँपौया तःलय् वहःयागु पिइगू लिधंसा दय्‌कल। छपौ छपौ सिँपौया तःलय् निगू निगू लिधंसा। ");
INSERT INTO new_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","पवित्र पालय् ल्‍युने पच्‍छिमपाखे तयेत खुपौ सिँपौ दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","अले ल्‍यूनेया निगू कुनय् निपौ सिँपौ दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","थुपिं निपतिं च्‍वंनिसें क्‍वथ्‍यंक देतनातःगु जुल। थुपिं कुन्‍चाय् च्‍वंगु सिँपौतय्‌त च्‍वय्‌निसें क्‍वय् तक हे स्‍वाकातःगु दु। निखें कुन्‍चाया लागि थुपिं सिँपौत थुकथं दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","थुकथं अन च्‍यापौ सिँपौ दय्‌कल। अले थुकिया निंतिं छपौ सिँपौया तःलय् निगू निगू यानाः झिंखुगू वहःयागु लिधंसा दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","खयःसिँयागु झिंन्‍यागू खगः दय्‌काः न्‍यागू खगः छखेपाखे, ");
INSERT INTO new_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","अले मेखेपाखे न्‍यागू खगः व पच्‍छिमपाखे ल्‍युने न्‍यागू खगः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","सिँपौतय् दथुइ तइगु खगः छगू कुनं मेगु कुनय् तक थ्‍यंगु छगू हे खगः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","अले सिँपौयात लुं हिनाबिल। खगः दिकेगु चाःचात नं लुँयागु दय्‌कल। खगःयात नं लुं हिनाबिल। ");
INSERT INTO new_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","अले वँचुगु, प्‍याजीगु व ह्याउँगु भिंगु सूती कापःयागु पर्दा दय्‌कल। कापतय् भिंगु कां करूबया बुत्ता भरय् याकेबिल। ");
INSERT INTO new_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","वं उकिया निंतिं खयःसिँयागु प्‍यंगः थां दय्‌काः लुं हिनाबिल। उकी काकिगु अंकुसि लुँयागु खः। वं इमिगु निंतिं वहःयागु प्‍यंगू लिधंसा दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","पालया लुखाय् तयेत वँचुगु, प्‍याजीगु व ह्याउँगु भिंगु सूती कापःयागु बुत्ता भरय् यानातःगु पर्दा दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","थ्‍व पर्दाया निंतिं खयःसिँयागु न्‍यागः थां दय्‌कल। उकियात लुं हिनाबिल। उकिया अंकुसि लुँयागु जुल। अले न्‍यागः थांयात कँय्‌यागु न्‍यागः लिधंसाय् दिकल। ");
INSERT INTO new_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बजलेलं खयःसिँयागु १.१ मि. हाकः, ३३ से.मि. ब्‍या व ३३ से.मि. तःजाःगु छगः सनू दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","उकियागु दुने व पिने भिंगु लुं भुनाबिल। अले उकिया प्‍यखेरं लुँया बाला दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","उकिया निंतिं लुँयागु प्‍यचाः चाः दय्‌काः उकियात सनूया प्‍यंगू ख्‍वःलय् तयाबिल। छखे निचाः व मेखे निचाः तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","अले खयःसिँयागु निपु न्‍वः दय्‌कल अले उकियात लुं हिनाबिल। ");
INSERT INTO new_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","सनू क्‍वबीत न्‍वःत निखें दुगु चालय् तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","वं भिंगु लुँयागु १.१ मि. हाकः व ३३ से.मि. ब्‍या दुगु छगू प्रायश्‍चितया कृपा-आसन दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","मुगलं दायाः लुँया निम्‍ह करूब दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","करूबतय्‌त प्रायश्‍चितया कृपा-आसन नाप छधी हे लुं दय्‌काः निखेंपाखे तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","उपिं करूबतय्‌सं थथःगु पपू च्‍वय्‌पाखे चक्‍कंकाः प्रायश्‍चितया कृपा-आसनयात त्‍वपुयातःगु दु। इमिगु ख्‍वाः चूलाकाः प्रायश्‍चितया कृपा-आसनपाखे स्‍वय्‌का तयातःगु दु। ");
INSERT INTO new_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","वं खयःसिँयागु ८८ से.मि. हाकः ४४ से.मि. ब्‍या व ३३ से.मि. तःजाःगु छगू तेबिल दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","उकियात भिंगु लुं भुनाः प्‍यखेरं लुँया बाला दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","उकिया प्‍यखेरं प्‍यलांगु ब्‍या दुगु बाला दय्‌कल। अले प्‍यखेरं लुँयागु मेगु बाला दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","तेबिलया निंतिं लुँयागु प्‍यचाः चाः दय्‌कल। अले उपिं चाःतय्‌त प्‍यंगू तुति च्‍वय् प्‍यखें कुन्‍चाय् तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","तेबिल ल्‍ह्वनीगु न्‍वःत कताकेत चाः बालाया लिक्‍कसं तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","थ्‍व न्‍वःत खयःसिँयागु दय्‌कल, अले लुं भुनाबिल। ");
INSERT INTO new_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","वं उकियागु पाःचागु थल, आम्‍खुरा व त्‍वँसाबलि प्‍वंकेगु करुवा व ख्‍वल्‍चा भिंगु लुँयागु दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","बजलेलं भिंगु लुँयागु छगू त्‍वाःदेवा मुगलं दायाः दय्‌कल। उकियागु लिधंसा, चु, स्‍वां थें च्‍वंगु ख्‍वल्‍चा, चुलि व स्‍वांफ्‍वः फुक्‍कं व छगू हे लुँ कुचां दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","बजलेलं भिंगु लुँयागु छगू त्‍वाःदेवा मुगलं दायाः दय्‌कल। उकियागु लिधंसा, चु, स्‍वां थें च्‍वंगु ख्‍वल्‍चा, चुलि व स्‍वांफ्‍वः फुक्‍कं व छगू हे लुँ कुचां दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","छगू कचाय् मर्स्‍या बरांयागु स्‍वांफ्‍वः थें च्‍वंगु स्‍वंगः ख्‍वल्‍चा व नापं मुखू वयाच्‍वंगु स्‍वां व स्‍वांफ्‍वः दय्‌कल। अले मेगुपाखे थथे हे स्‍वपु कचात पिहां वल। थथे यानाः अन खुपु कचा दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","त्‍वाःदेवालय् मर्स्‍या बरांया स्‍वां थें च्‍वंगु प्‍यंगः ख्‍वल्‍चात, अले मुखू स्‍वां व स्‍वांफ्‍वःत नापं दुगु खः ");
INSERT INTO new_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","अले चुं पिहां वःगु स्‍वज्‍व कचातय् चुया स्‍वांफ्‍वःया क्‍वय् निपु निपु कचातय् दथुइ छगः छगः ग्‍वः चुनापं दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","त्‍वाःदेवा, उकियागु मुखू व कचात मुगलं दायातःगु भिंगु लुँयागु छगू हे कुचायागु जुल। ");
INSERT INTO new_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","इमिसं भिंगु लुँयागु न्‍हय्‌पाः पाल्‍चा, इताः कुलेगु चिम्‍ता व किस्‍ति दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","इमिसं स्‍विन्‍यागू ति किलोग्राम भिंगु लुं त्‍वाःदेवा व उकियात माःमाःगु ज्‍वलं दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","बजलेलं खयःसिँयागु गुँगू थनेगु वेदी दय्‌कल। व ४५ से.मि. ताहाकःगु, ४५ से.मि. ब्‍या दुगु अले ९० से.मि. तःजाःगु व प्‍यकुंलाःगु जुल। उकिया नेकूत नं छस्‍वा यानाः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","उकिया च्‍वय्, प्‍यखेरं व नेकूतय्‌त भिंगु लुं भुनाबिल। अले उकिया प्‍यखेरं लुँयागु बाला दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","वेदी क्‍वबीगु न्‍वः तयेत बालाया क्‍वय् निखेंपाखें निचाः चाः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","न्‍वः खयःसिँयागु दय्‌काः लुं भुनाबिल। ");
INSERT INTO new_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","बजलेलं अभिषेक यायेगु पवित्र चिकं व अत्तर दय्‌के सःम्‍हय्‌सिनं थें नस्‍वाःगु भिंगु गुँगू दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","इमिसं खयःसिँयागु २.२ मि. हाकः २.२ मि. ब्‍या व १.३ मि. तःजाःगु छगू प्‍यकुंलाःगु वेदी दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","उकिया प्‍यकुनय् छपु छपु नेकू दय्‌कल। फुक्‍क नेकू छस्‍वा जुयाच्‍वंगु जुल। वेदीयात कँय्‌नं हिनाबिल। ");
INSERT INTO new_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","वेदीया नउ तयेगु थल, नउ तुइगु चतं, बाता, ला लिकायेगु नतू व मिथल दय्‌कल। थुपिं फुक्‍क कँय्‌यागु जुल। ");
INSERT INTO new_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","वेदीया सिइ तयेत उकिया दथुइ तक थ्‍यनिगु कँय्‌यागु चालिंचा दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","न्‍वःत दुछ्वयेत उकिया प्‍यखें कँय्‌यागु प्‍यचाः चाः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","वेदीया निंतिं खयःसिँयागु न्‍वःत दय्‌काः कँय्‌नं हिनाबिल। ");
INSERT INTO new_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","वेदी क्‍वबीत निखेंया चालय् न्‍वः दुछ्वत। वेदी सिँपौयागु व दथुइ गावंक दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","बजलेलं नापलायेगु पालया ध्‍वाखाय् ग्‍वाहालि याइपिं मिसातय्‌सं ब्‍यूगु न्‍हाय्‌कनं कँय्‌यागु ल्‍हाः सिलेगु बाता व उकियागु लिधंसा दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","इमिसं पवित्र पालया प्‍यखेरं ख्‍वातुगु कापतं ग्‍वयाः चुक दय्‌कल। उकिया दच्‍छिन ब्‍व ४४ मिटर हाकः दुगु जुल। थुपिं ख्‍वातुगु कापः भिंगु सुति कां दय्‌कूगु खः। ");
INSERT INTO new_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","उकियागु निंतिं निइगू कँय्‌यागु लिधंसाय् निइगः हे कँय्‌यागु थां दय्‌कल। थांतय्‌गु अंकुसि व डण्‍डी धाःसा वहःयागु दु। ");
INSERT INTO new_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","उत्तरपाखें नं इमिसं अथे हे यानाः कापतं ग्‍वल। अले उकियागु थांत निइगः व लिधंसा नं कँय्‌यागु हे निइगः दय्‌कल। अंकुसि व डण्‍डी धाःसा वहःयागु जुल। ");
INSERT INTO new_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","पच्‍छिम पाखेयागु ख्‍वातुगु कापः २२ मिटर ताहाकः। उकिया झिगः थां व झिगू लिधंसा दु। अंकुसि व डण्‍डी धाःसा वहःयागु जुल। ");
INSERT INTO new_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","चुकया पुर्ब वा सूर्य लुइगु पाखेया ब्‍या २२ मिटर दु। ");
INSERT INTO new_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","चुकया ध्‍वाखाया निखें ६.५ मिटर हाकःगु ख्‍वातुगु कापः दय्‌काः उकिया निंतिं स्‍वंगः स्‍वंगः थां व लिधंसा दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","चुकया प्‍यखें पाखेयागु ख्‍वातुगु कापः भिंगु सुति कां दय्‌कूगु खः। ");
INSERT INTO new_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","चुकया थांतय्‌गु लिधंसा कँय्‌यागु जुल। थुकथं चुकया फुक्‍क थांत वहःयागु डण्‍डीं स्‍वानाः च्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","चुकया ध्‍वाखाया पर्दा वँचुगु, प्‍याजीगु, ह्याउँगु भिंगु सूती कापः बुत्ता भरय् यानातःगु ९ मिटर हाकःगु जुल। व चुकया प्‍यखेरं ग्‍वयातःगु ख्‍वातुगु कापः २ मिटर तःजा। ");
INSERT INTO new_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","थुकियात प्‍यंगः थां व प्‍यंगू लिधंसा दय्‌कल। डण्‍डी व अंकुसि वहःयागु अले थांया च्‍वय्‌नं वहलं भुनातःगु दु। ");
INSERT INTO new_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","पालया कि व चुकया कि कँय्‌यागु जुल। ");
INSERT INTO new_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","23","बजलेलं वँचुगु, प्‍याजीगु व ह्याउँगु रंगयागु सुति कापतय् बुत्ता भरय् यायेसःम्‍ह व थायेसःम्‍ह ओहोलीआबयात नापं कयाः ज्‍या सिधय्‌कल। इपिं निम्‍ह जानाः परमप्रभुं मोशापाखें बियादीगु उजं पूवंकल। मोशां हारून पुजाहारीया काय् ईतामारयात नापलायेगु पालय् छ्यःगु लुँ, वहः व कँय्‌या ल्‍याःचा तयेगु जिम्‍मा बिल। ");
INSERT INTO new_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पवित्र पालया शेकेलकथं ज्‍याया निंतिं संकाबीगु बलिया लुँ पवित्र पालया शेकेलया ल्‍याःकथं द्वःछि किलोग्राम दु। ");
INSERT INTO new_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","खलःया ल्‍याःखापिं मनूतय्‌गु देछाया वहः पवित्र पालया शेकेलया ल्‍याःकथं ३,५२० किलोग्राम दु। ");
INSERT INTO new_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ल्‍याःखापिं निइदँ व वस्‍वयाः च्‍वय्‌यापिं मिजं मनूत ६,०३,५५० म्‍ह दु। छम्‍ह छम्‍ह मनूपाखें पवित्र पालया शेकेलया ल्‍याःकथं बच्‍छि शेकेल काल। ");
INSERT INTO new_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","थुकियागु मूं ३,४०० किलोग्राम वहः पवित्र पाल व पर्दाया लिधंसा दय्‌केत छ्य। इमिसं छगू छगू लिधंसाय् ३४ किलोग्राम वहः छ्यल। ");
INSERT INTO new_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","अले ल्‍यं दुगु २० किलोग्राम वहलं थांतय्‌गु अंकुसित व डण्‍डी दय्‌कल। अले थांया च्‍वय् वहलं भुनाबिल। ");
INSERT INTO new_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","देछायागु कँय् २,४२५ किलोग्राम दु। ");
INSERT INTO new_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","वं उकिं नापलायेगु पालया ध्‍वाखाया लिधंसात अले होमबलिया वेदी, उकिया कँय्‌यागु चालिंचा व थलबल ");
INSERT INTO new_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","अले चुकया प्‍यखेरं च्‍वंगु लिधंसात व चुकया ध्‍वाखाया लिधंसात अले नापलायेगु पालया चुकया प्‍यखेरंयागु नकि नं दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","हारूनया निंतिं परमप्रभुं मोशायात उजं बियादीगुकथं पवित्र पालय् सेवा यायेत इमिसं वँचुगु, प्‍याजीगु, ह्याउँगु कां थानातःगु कापःयागु पवित्र वसः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","इमिसं वँचुगु, प्‍याजीगु, व ह्याउँगु रंगयागु का, लुँयागु का व भिंगु सूती कापःयागु एपोद स्‍यल्‍लाक सुल। ");
INSERT INTO new_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","इमिसं लुँयात मुगलं दायाः सालुगु पातात दय्‌कल। अले पातायात चानाः तार दय्‌काः उकियात वँचुगु, प्‍याजीगु व ह्याउँगु कानापं भिंगु सुति कापतय् बांलाक बुत्ता भरय् याये सःम्‍हय्‌सिनं थें तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","अले थ्‍वयात कत्ताकातयेत निखेंया ब्‍वहलय् निगू ब्‍वहःकुचा स्‍वानाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","परमप्रभुं मोशायात उजं बियादीगुकथं इमिसं एपोदया द्यःने बांलाक थानातःगु व हे ज्‍वलं वँचुगु प्‍याजीगु व ह्याउँगु कां व लुँयागु कां थानातःगु भिंगु सूती कापःयागु जँनी दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","इमिसं आनिक्‍स ल्‍वहं कयाः उकियात लुँयागु फाकुनय् थुनाबिल। उपिं ल्‍वहँतय् इस्राएलया झिंनिम्‍ह काय्‌पिनिगु नां बांलाक कियाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","परमप्रभुं मोशायात उजं बियादीगुकथं इस्राएलया झिंनिगू कुलया नां लुमन्‍ति कथं हारूनं थ्‍व निकुतिं ल्‍वहंयात ब्‍वहलय् तल। ");
INSERT INTO new_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","दकलय् तःधंम्‍ह पुजाहारीया निंतिं स्‍यल्‍लाःगु छातिपाता दय्‌कल। थ्‍व छातिपाता एपोद थें हे लुँयागु, वँचुगु, प्‍याजीगु व ह्याउँगु भिंगु सूती कापःयागु दय्‌कूगु खः। ");
INSERT INTO new_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","थ्‍व प्‍यकुंलाःगु व निबः यानाः लथ्‍यानातःगु दु। अले थुकिया हाकः व ब्‍या क्‍वलाछि क्‍वलाछि दु। ");
INSERT INTO new_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","थुकी प्‍यझ्‍वः यानाः थीथी मणि थुनाबिल। न्‍हापांगु झ्‍वलय् मानिक, पुष्‍पराज व फिरोजा, ");
INSERT INTO new_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","निगूगु झ्‍वलय् प्‍याजीगु रंगयागु मणि, नीलम व पन्‍ना, ");
INSERT INTO new_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","स्‍वंगूगु झ्‍वलय् कार्नेलेन, अकिक व प्‍याजीगु रंगयागु मणि। ");
INSERT INTO new_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","प्‍यंगूगु झ्‍वलय् पुखराज, कार्नेलेन व जास्‍पर दय्‌कल। थ्‍व फुक्‍कयात लुँयागु फाकुनय् थुनाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","इस्राएलया झिंनिम्‍ह काय्‌पिनिगु नांकथं झिंनिगः मणिया थी दु। झिंनिगलय् झिंनिगू हे कुलयागु नां कियाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","छातिपातायात एपोदय् घायेत भिंगु लुँयागु निलातःगु सिखः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","अले लुँयागु निगू फाकुं व निचाः चाः दय्‌काः उकियात छातिपाताया निखेंया कुनय् सुयाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","लुँयागु निपुं सिखःयात छातिपाताय् च्‍वंगु निचालं लुँयागु चालय् चिनाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","लुँयागु सिखःया मेगु च्‍वःयात एपोदया ब्‍वहलय् च्‍वंगु लुँयागु फाकुनय् चिनाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","लुँयागु मेगु निचाः चाः दय्‌काः छातिपाताया ल्‍यूनेया च्‍वःपाखे एपोदया जँनी नापसं सुयाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","हानं मेगु निचाः लुँयागु चाः दय्‌काः एपोदया न्‍ह्यःनेपाखे निखें जँनी चिनातःगु गथिया च्‍वसं सुयाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","छातिपाता एपोदय् थाकेत छातिपाताया चाः व एपोदया चाःयात वँचुगु पुतुं जँनीलय् चिनाबिल। परमप्रभुं मोशायात उजं बियादीगुकथं थ्‍व फुक्‍कं दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","एपोदया दुने फीगु पुजाहारीया लं ब्‍याक्‍क वँचुगु बांलाक थानातःगु कापतं सुल। ");
INSERT INTO new_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","उकिया दथुइलाक छ्यं दुछ्वयेत प्‍वाः दय्‌कल, अले मगुइमा धकाः गःतांया छचाखेरं कापः तयाः सुयाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","क्‍वय् सिथय् सिथय् प्‍यखेरं वँचुगु, प्‍याजीगु व ह्याउँगु भिंगु सुति कां धालेग्‍वः सुयाः घानाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","क्‍वय् सिथय्‌या घानातःगु धालेग्‍वःया दथुइ दथुइ तयेत इमिसं भिंगु लुँया गं दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","परमप्रभुं मोशायात उजं बियादीगुकथं सेवा याः वनीबलय् फीगु पुजाहारीया लंया क्‍वय् सिथय् प्‍यखेरं लुँयागु गं व धालेग्‍वःयात छगः छगः अतः गाय्‌काः घानाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","29","हारून व वया काय्‌पिनिगु निंतिं इमिसं परमप्रभुं मोशायात उजं बियादीगुकथं थानातःगु भिंगु सूती कापःयागु जामालं, बेतालि, छ्यंबाला व बागः सुर्वाः, अले बुत्ता भरय् यानातःगु वँचुगु, प्‍याजीगु व ह्याउँगु सूती कापःयागु जँनी दय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","इमिसं छेनय् चीत भिंगु लुँयागु बाला छगू दय्‌काः उकी “परमप्रभुया निंतिं पवित्र” धकाः कियाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","अले परमप्रभुं मोशायात उजं बियादीगु थें इमिसं व वँचुगु कां बेतालिइ चिनाबिल। ");
INSERT INTO new_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","थुकथं नापलायेगु पालयागु फुक्‍क ज्‍या क्‍वचाल। परमप्रभुं मोशायात उजं बियादीगु थें हे मुक्‍कं इस्राएलीतय्‌सं यात। ");
INSERT INTO new_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","इमिसं नापलायेगु पालया फुक्‍क ज्‍वलं मोशायाथाय् हल – पवित्र पाल व उकिया फुक्‍क ज्‍वलं, उकिया अंकुसि, सिँपौ, खगः, थां, लिधंसा, ");
INSERT INTO new_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","पाल त्‍वपुइत इलांया स्‍वंगूगु व प्‍यंगूगु तँया इलां– ह्याउँगु रंग छिनातःगु फैया छेंगू व डल्‍फिनया छेंगूयागु अले सनूया न्‍ह्यःने च्‍वंगु पर्दा, ");
INSERT INTO new_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","बाचा चिनादीगु सनू व प्रायश्‍चितया कृपा-आसन व उकिया न्‍वःत, ");
INSERT INTO new_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","तेबिल व उकिया फुक्‍क ज्‍वलं व देछाया मरि, ");
INSERT INTO new_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","भिंगु लुँया त्‍वाःदेवा व उकिया पाल्‍चा व मेगु ज्‍वलं व भिंगु चिकं, ");
INSERT INTO new_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","लुँयागु वेदी, अभिषेक यायेगु चिकं, नस्‍वाःगु गुँगू, पवित्र पालया लुखाया पर्दा, ");
INSERT INTO new_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","कँय्‌यागु वेदी, उकिया कँय्‌यागु चालिंचा, उकिया न्‍वःत व फुक्‍क ज्‍वलं, बाता व उकिया लिधंसा, ");
INSERT INTO new_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","चुक थनेत खिपः व नकि अले ख्‍वातुगु कापः व उकिया थां व लिधंसा अले चुकया ध्‍वाखाया पर्दा। थथे इमिसं नापलायेगु पालया फुक्‍क ज्‍वलं व पवित्र पालय् सेवा यायेत ");
INSERT INTO new_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","हारून पुजाहारीया पवित्र वसः व वया काय्‌पिनिगु वसः मोशायाथाय् हल। ");
INSERT INTO new_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","परमप्रभुं मोशायात बियादीगु उजंकथं फुक्‍क ज्‍या इस्राएलीतय्‌सं यात। ");
INSERT INTO new_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","परमप्रभुं बियादीगु उजंकथं फुक्‍क ज्‍या जूगु खनाः मोशां इपिं सकसित सुवाः बिल। ");
INSERT INTO new_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“न्‍हापांगु लाया न्‍हापांगु दिंखुन्‍हु पवित्र पाल ग्‍वः। ");
INSERT INTO new_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","उकी बाचा चिनादीगु सनू तयाः उकिया न्‍ह्यःने पर्दा यख्‍खानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","तेबिल पवित्र थासय् हयाः उकी द्यःने ज्‍वलं ब्‍वयाब्‍यु। अले त्‍वाःदेवा नं हयाः उकिया पाल्‍चा च्‍याकेत मिलय् या। ");
INSERT INTO new_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","बाचाया सनूया न्‍ह्यःने दुगु पर्दाया पिने लुँयागु गुँगू थनेगु वेदी तयाब्‍यु, अले पवित्र पालया लुखाय् पर्दा यख्‍खानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“पवित्र पालया लुखाया लिक्‍क होमबलिया वेदी तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","अनं लिपा पवित्र पाल व वेदीया दथुइ ल्‍हाः सिलेगु बाता तयाः उकी लः जाय्‌काब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","अले छचाःखेरं चुकया ख्‍वातुगु कापः व थां थनाब्‍यु। ध्‍वाखाय् नं पर्दा यख्‍खानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“अभिषेक यायेगु चिकं हयाः पवित्र पाल व उकी दुगु फुक्‍क ज्‍वलंयात अभिषेक या। अले उकियात व फुक्‍क ज्‍वलं नापं पलिस्‍था या, अले व पवित्र जुइ। ");
INSERT INTO new_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","होमबलिया वेदी व उकिया फुक्‍क ज्‍वलं नापं अभिषेक यानाः उकियात पलिस्‍था या, अले व तच्‍वकं पवित्र जुइ। ");
INSERT INTO new_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","बाता व उकिया लिधंसा नं अभिषेक यानाः पलिस्‍था या। ");
INSERT INTO new_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“अनंलि हारून व वया काय्‌पिन्‍त नापलायेगु पालया ध्‍वाखा दुने हयाः इमित म्‍वःल्‍हुकि। ");
INSERT INTO new_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","अले हारूनयात पवित्र वसः फीकाः वयात अभिषेक या। अले पुजाहारी जुयाः सेवा यायेत वयात पलिस्‍था या। ");
INSERT INTO new_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","वया काय्‌पिन्‍त हयाः इमित जामालं फीका ब्‍यु। ");
INSERT INTO new_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","अले छं इमि बौयात गथे यानाः अभिषेक यानागु खः अथे हे यानाः इमित नं अभिषेक या। इमिगु अभिषेक धाःसा छगू सदांया पुजाहारीया ज्‍याकथं लिपा थ्‍यंकया पुस्‍ता तक जुइ।” ");
INSERT INTO new_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","मोशां फुक्‍क ज्‍या परमप्रभुं वयात उजं बियादीगुकथं हे यात। ");
INSERT INTO new_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","इस्राएलीतय्‌सं मिश्र देश त्‍वःतूगु दच्‍छि लिपा निगूगु दँया न्‍हापांगु लाया न्‍हापांगु दिंखुन्‍हु पवित्र पाल धस्‍वाकल। ");
INSERT INTO new_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","पवित्र पाल थुकथं धस्‍वाकल – वं लिधंसात तयेमाःगु थासय् तल, सिँपौ धस्‍वाका तल, खगः दुछ्वत अले थांत धस्‍वाका तल। ");
INSERT INTO new_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","अनंलि परमप्रभुं मोशायात उजं बियादीगुकथं इमिसं पवित्र पालया द्यःने नितँ इलां प्‍यनाः उकी द्यःने मेगु नितँ इलां तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","अले वं ल्‍वहंपौ हयाः बाचा चिनादीगु सनू दुने तयाः न्‍वःत सनूइ तयाबिल, अले प्रायश्‍चितया कृपा-आसन सनूया द्यःने तल। ");
INSERT INTO new_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","वं बाचाया सनूयात महा-पवित्र थासय् हल। परमप्रभुं मोशायात उजं बियादीगु थें वं पर्दा यख्‍खानाबिल। थुकथं बाचाया सनू खने मदय्‌क तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","अले वं पवित्र पालया उत्तरपाखे पर्दाया पिने तेबिल तल। ");
INSERT INTO new_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","परमप्रभुं मोशायात उजं बियादीगु थें वं मरियात उकिया च्‍वय् परमप्रभुया न्‍ह्यःने तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","वं त्‍वाःदेवायात पवित्र पालया दच्‍छिनपाखे तेबिलया चुलिंचू तयाबिल। ");
INSERT INTO new_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","अले परमप्रभुं मोशायात उजं बियादीगु थें वं परमप्रभुया न्‍ह्यःने पाल्‍चा च्‍याकल। ");
INSERT INTO new_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","मोशां पवित्र पालय् दथुइच्‍वंगु पर्दाया न्‍ह्यःने लुँयागु वेदी तल। ");
INSERT INTO new_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","परमप्रभुं मोशायात उजं बियादीगु थें उकी वं नस्‍वाःगु गुँगू च्‍याकल। ");
INSERT INTO new_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","अले वं पवित्र पालया लुखाय् पर्दा यख्‍खानाबिल। ");
INSERT INTO new_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","अले परमप्रभुं मोशायात उजं बियादीगु थें वं पवित्र पालया लुखाया लिक्‍क होमबलिया वेदी तयाः उकी होमबलि व अन्‍नबलि देछाल। ");
INSERT INTO new_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","वं पवित्र पाल व वेदीया दथुइ बातायात तयाः उकी लः तल। ");
INSERT INTO new_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","अले मोशा, हारून व वया काय्‌पिन्‍सं उकी थथःगु ल्‍हाःतुति सिलेगु यात। ");
INSERT INTO new_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","इपिं पवित्र पालय् वा वेदीइ वनीबलय् इमिसं थथःगु ल्‍हाःतुति सिलेगु याइ। गुकियात परमप्रभुं मोशायात उजं बियादीगु खः। ");
INSERT INTO new_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","दकलय् लिपा वं पवित्र पाल व वेदीया प्‍यखेरं घेरय् यानाः चुक दय्‌कल। अले चुकया ध्‍वाखाय् पर्दा यख्‍खानाबिल। थुकथं मोशां फुक्‍कं ज्‍या सिधय्‌कल। ");
INSERT INTO new_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","अले नापलायेगु पालयात सुपाँचं त्‍वपुल, व परमप्रभुयागु महिमां पवित्र पाल जाल। ");
INSERT INTO new_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","मोशा पवित्र पालय् दुहां वने मफुत छाय्‌धाःसा व सुपाँय् उकी च्‍वना हे च्‍वन अले परमप्रभुयागु महिमां पवित्र पाल जायाच्‍वन। ");
INSERT INTO new_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","व सुपाँय् पवित्र पालं चिला वनीबलय् इस्राएलीत थःगु लँपुइ न्‍ह्यःज्‍याइ। ");
INSERT INTO new_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","अय्‌नं ग्‍वःन्‍हु तक सुपाँय् च्‍वय् थहां वनी मखु इपिं अन हे च्‍वनाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","इस्राएलीतय्‌गु फुक्‍क यात्रा ज्‍वःछिं न्‍हिनय् परमप्रभुया सुपाँय् पवित्र पालया च्‍वय् खनेदइ, चान्‍हय् धाःसा उकी इमिसं मि खनी।");
INSERT INTO new_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","परमप्रभुं मोशायात पवित्र पालया दुनें सःताः धयादिल, ");
INSERT INTO new_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“इस्राएलीतय्‌त धा, ‘सुनानं परमप्रभुया निंतिं बलि बीबलय् वयागु बलि सा द्वहंया बथां वा फै दुगुचाया बथांपाखें जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“‘वं होमबलि सा द्वहंया बथांपाखें छायेगु खःसा व खू मदुम्‍ह मिजंम्‍ह जुइमा, वं व पशु नापलायेगु पालया ध्‍वाखाय् छाये हयेमाः अले व पशु परमप्रभुया न्‍ह्यःने वयागु लागिं नालेबहः जुइ। ");
INSERT INTO new_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","अले वं थःगु ल्‍हाः होमबलि पशुया छेनय् तयेमाः। अले वयागु प्रायश्‍चितया लागिं ग्रहण याइगु जुइ। ");
INSERT INTO new_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","व मनुखं द्वहंचायात परमप्रभुया न्‍ह्यःने स्‍यायेमाः। अले हारूनया पुजाहारी काय्‌पिन्‍सं द्वहंया हि कयाः नापलायेगु पालया ध्‍वाखाया दुने च्‍वंगु वेदीया छचाःखेरं छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","अनंलि होमबलि छाःम्‍ह मनुखं बलि बी धुंकूम्‍ह पशुया छेंगू तुनाः वयागु लायात ध्‍यनाः कुचा कुचा यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","पुजाहारी हारूनया काय्‌पिन्‍सं वेदीइ मि तयाः उकिया द्यने सिँ बांलाक मिले यानाः तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","अले वया काय्‌पिं अर्थात पुजाहारीतय्‌सं वेदीया च्‍वय् मिइ तयातःगु सिँया द्यःने बलि बी धुंकूम्‍ह पशुयागु छ्यं, दाः व ला बांलाक ब्‍वया तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","आतापुति भ्‍वरि व तुति धाःसा लखं सिलेमाः अले व फुक्‍कयात पुजाहारीं वेदीइ छ्वाकेमाः। थ्‍व परमप्रभुयात यःगु नस्‍वाः वःगु विशेष देछा, होमबलि खः। ");
INSERT INTO new_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“‘सुनानं परमप्रभुया निंतिं बथांपाखें फै वा दुगुचा बलि हल धाःसा वं खू मदुम्‍ह मिजंम्‍ह छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","वं परमप्रभुया न्‍ह्यःने वेदीया उत्तरपाखे छाःम्‍ह पशुयात पालाः स्‍यायेमाः, अले हारूनया पुजाहारी काय्‌पिन्‍सं वयागु हि वेदीइ जःखः छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","अले व मनुखं पशुयात कुचा कुचा यायेमाः। पुजाहारीं फुक्‍कयात वेदीइ मिया च्‍वय् सिँकाँय् ब्‍वया तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","वं बलि बीहःम्‍ह पशुयागु आतापुति भ्‍वरि व तुतियात लखं सिलेमाः। अले पुजाहारीं फुक्‍क यंकाः वेदीइ छ्वय्‌केमाः। थ्‍व परमप्रभुयात यःगु नस्‍वाः वःगु होमबलि, विशेष देछा खः। ");
INSERT INTO new_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“‘सुनानं परमप्रभुया निंतिं झंगःतय्‌गु होमबलि छायेगु खःसा व झंगः सुकुभत्तु वा बखुं जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","पुजाहारीं व छाःम्‍ह झंगः वेदी लिक्‍क हयाः छ्यं म्‍वःहिलाः चफुइमाः। झंगःया छ्यंयात वेदीइ छ्वय्‌केमाः। हि धाःसा वेदीया सिथय् थाथा यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","उकिं झंगःया गलः नापं भ्‍वरि लिकयाः वेदीया पुर्बपाखें नउ दुथाय् वांछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","उकी देछाःम्‍ह झंगःयात कुचा मयासें पपूया दथुं फायेमाः। पुजाहारीं वेदीइ दुगु मि च्‍वय् सिँइ झंगःयात छ्वय्‌केमाः। थ्‍व परमप्रभुयात यःगु नस्‍वाः वःगु होमबलि, विशेष देछा खः। ");
INSERT INTO new_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“‘सुनानं परमप्रभुया निंतिं अन्‍नबलि छाःसा भिंगु छुचुं हयेमाः। उकी जैतूनया चिकं प्‍वंकाः धुपाँय्‌ तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","अले वं हारूनया पुजाहारी काय्‌पिन्‍थाय् हयेमाः। उकिं पुजाहारीं थःगु ल्‍हाःया छम्‍हू भिंगु छुचुं व चिकं, अले फुक्‍क धुपाँय्‌ नाप लिकायेमाः। अले वं परमप्रभुयात यःगु नस्‍वाः वःगु विशेष देछा लुमन्‍तिकथं वेदीइ छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","अन्‍नबलिया ल्‍यं दुगु हारून व वया काय्‌पिनिगु जुइ। परमप्रभुया निंतिं मेमेगु विशेष देछा स्‍वयाः थ्‍व तसकं पवित्रगु खः। ");
INSERT INTO new_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“‘भुतुलिइ दय्‌कूगु अन्‍नबलि छायेगु इच्‍छा दुसा, चिकनय् बुलातःगु सोडा मतःगु भिंगु छुचुंया ग्‍वारमरि वा चिकनं इलातःगु सोडा मतःगु मरि जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","छिमिगु बलि ताप्‍केचाय् छूगु अन्‍नबलि खःसा, चिकं बुलातःगु सोडा मतःगु भिंगु छुचुंया जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","व कुचा कुचा यानाः उकी चिकं प्‍वंकेमाः व अन्‍नबलि खः। ");
INSERT INTO new_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","छिमिसं छाःगु अन्‍नबलि द्वालय् छूगु खःसा चिकं भिंगु छुचुंया जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","थज्‍याःगु अन्‍नबलि परमप्रभुया थासय् हयाः पुजाहारीयात लःल्‍हायेमाः। अले वं वेदीइ तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","पुजाहारीं अन्‍नबलिं लुमन्‍तिकथं छम्‍हु लिकयाः व परमप्रभुयात यःगु नस्‍वाः वःगु विशेष देछा वेदीइ छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","अन्‍नबलिं ल्‍यंगु ब्‍व हारून व वया काय्‌पिनिगु जुइमाः। परमप्रभुया निंतिं मेमेगु विशेष देछा स्‍वयाः थ्‍व तसकं पवित्र खः। ");
INSERT INTO new_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“‘छिमिसं परमप्रभुयाथाय् छायेहइगु फुक्‍क अन्‍नबलि सोडा मतय्‌कः दय्‌कूगु जुइमाः। छाय्‌धाःसा परमप्रभुया निंतिं छाइगु विशेष देछाय् छिमिसं सोडा व कस्‍ति छ्वय्‌के मते। ");
INSERT INTO new_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","व धाःसा न्‍हापांयागु फलया देछाकथं परमप्रभुया न्‍ह्यःने छाःसां ज्‍यू। नस्‍वाःया लागिं धाःसा उकियात वेदीइ छ्वय्‌के मते। ");
INSERT INTO new_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","छिमिसं छाःगु फुक्‍क अन्‍नबलिइ चि तयेमाः। परमप्रभुं छिपिंनाप सदांया लागिं चिनादीगु बाचाया चिं चि हे खः। थथे जूगुलिं न्‍ह्यागु हे बलिइ चि तये हे माः। ");
INSERT INTO new_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“‘परमप्रभुया निंतिं न्‍हापांगु फलयागु अन्‍नबलि छायेगु इच्‍छा दुसा छिमिसं मिं छूगु व क्‍यलातःगु ताजा अन्‍न छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","उकी चिकं व धुपाँय्‌ तयेमाः। व अन्‍नबलि जुइ। ");
INSERT INTO new_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","अले पुजाहारीं अन्‍नबलिं चिकं तयातःगु क्‍यलातःगु अन्‍न छुं ब्‍व व धुपाँय्‌ फुक्‍क कयाः लुमन्‍तिकथं छ्वय्‌केमा। परमप्रभुया निंतिं थ्‍व विशेष देछा खः। ");
INSERT INTO new_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“‘सुनानं परमप्रभुयात सा वा द्वहं मेलबलि छाल धाःसा व पशु खू मदुम्‍ह जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","व मनुखं थःगु ल्‍हाः पशुया छेनय् तयेमाः। अले व देछाःम्‍ह बलियात नापलायेगु पालया ध्‍वाखाय् पालाः स्‍यायेमाः। अले हारूनया पुजाहारी काय्‌पिन्‍सं बलिया हि वेदीइ जःखः छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","मेलबलिं विशेष देछाः परमप्रभुया निंतिं आतापुति भ्‍वरि त्‍वपुइगु दाः व उकिया च्‍वय्‌च्‍वंगु दाः फुक्‍क छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","निगः जलासेँ व उकिया च्‍वय् जँ नापं च्‍वंगु दाः, अले सेँया भिंगु ब्‍व वं लिकायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","व फुक्‍कयात हारूनया काय्‌पिन्‍सं वेदीइ मि च्‍वय् दुगु सिँइ तयाः छ्वय्‌केमाः। थ्‍व परमप्रभुयात यःगु नस्‍वाः वःगु विशेष देछा खः। ");
INSERT INTO new_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“‘सुनानं परमप्रभुयात मेलबलिया बथांपाखें फैचा वा दुगुचा छाल धाःसा मिजंम्‍ह जूसां मिसाम्‍ह जूसां खू मदुम्‍ह पशुयात छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","थःगु बलि चिधिकःम्‍ह भ्‍याःचा छायेगु खःसा वं वयात परमप्रभुया न्‍ह्यःने छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","वं थःगु बलिया छेनय् ल्‍हाः तयेमाः। अले वयात नापलायेगु पालया ध्‍वाखाय् स्‍यायेमाः। पुजाहारीं छाःम्‍ह पशुया हि वेदीया जःखः छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","अले व मनुखं मेलबलिपाखें परमप्रभुयात विशेष देछा छायेमाः। थथे दाः व दुगः क्‍वँय्‌या लिक्‍कनं अलग यानातःगु दाःखाःगु न्‍हिप्‍यं दुगु क्‍वँय् निसें फायाबीमाः, आतापुति भ्‍वरि त्‍वपुइगु दाः व उकिया च्‍वय्‌च्‍वंगु दाः नं फुक्‍क लिकायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","निगः जलासेँ व उकिया च्‍वय् जँ नापं च्‍वंगु दाः, अले सेँया भिंगु ब्‍व वं लिकायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","पुजाहारीं व परमप्रभुया निंतिं विशेष देछा वेदीइ नसाकथं छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“‘सुनानं दुगुचा छाल धाःसा वं परमप्रभुया न्‍ह्यःने छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","वं थःगु ल्‍हाः वयागु छेनय् तयेमाः, नापलायेगु पालया ध्‍वाखाय् वयात स्‍यायेमाः। अले हारूनया काय्‌पिन्‍सं वयागु हि वेदीया जःखः छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","वं उकिं थःगु बलि परमप्रभुया निंतिं विशेष देछाकथं छायेमाः। आतापुति भ्‍वरि त्‍वपुइगु दाः व उकिया च्‍वय्‌च्‍वंगु दाः फुक्‍क लिकायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","निगः जलासेँ व उकिया च्‍वय् जँ नापं च्‍वंगु दाः, अले जलासेँ व सेँया भिंगु ब्‍व वं लिकायेमाः। ");
INSERT INTO new_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","अले पुजाहारीं विशेष देछायात वेदीइ छ्वय्‌केमाः। थ्‍व परमप्रभुयात नस्‍वाः वःगु नसा थें जुइ। दाः दक्‍व परमप्रभुया लागिं जक खः। ");
INSERT INTO new_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“‘छिमिसं दाः व हि गुबलें नये मते। थ्‍व छिमि पुस्‍तौं पुस्‍ताया लागिं न्‍ह्याबलेंया नियम खः।’” ");
INSERT INTO new_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“इस्राएलीतय्‌त थथे धा, ‘परमप्रभुं याये मते धयादीगु ज्‍याखँ मसीकं सुनानं पाप यात धाःसा वं थथे यायेमाः, ");
INSERT INTO new_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“‘अभिषेक जूम्‍ह पुजाहारीं पापयात धाःसा फुक्‍क मनूतय्‌त दोष लाःगु जुइ। थथे जूगुलिं वं याःगु पापया निंतिं छम्‍ह खू मदुम्‍ह द्वहंचा परमप्रभुया न्‍ह्यःने पापबलिकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","वं द्वहंयात नापलायेगु पालया ध्‍वाखाय् परमप्रभुया न्‍ह्यःने हयाः वयागु छेनय् थःगु ल्‍हाः तयाः परमप्रभुया न्‍ह्यःने स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","अले अभिषेक जूम्‍ह पुजाहारीं द्वहंया हि कयाः पवित्र थाय्‌या दुने हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","पुजाहारीं थःगु पतिंचा हिइ थुनाः व हि पवित्र थाय्‌या दथुइच्‍वंगु पर्दाय् न्‍हय्‌कः छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","अले पुजाहारीं हि भतिचा कयाः पवित्र थासय् दुने परमप्रभुया न्‍ह्यःने च्‍वंगु गुँगू थनेगु वेदीया नेकुलिइ तिकेमाः। अले द्वहंया ल्‍यं दुगु हि नापलायेगु पालया ध्‍वाखाय् होमबलिया वेदीया तःलय् प्‍वंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","पापबलिया द्वहंया फुक्‍क दाः लिकायेमाः। आतापुति भ्‍वरि त्‍वपुइगु दाः व उकिया च्‍वय्‌च्‍वंगु दाः नं लिकायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","निगः जलासेँ व उकिया च्‍वय् जँ नापं च्‍वंगु दाः, अले जलासेँ व सेँया भिंगु ब्‍व वं लिकायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","मेलबलि थें छाःम्‍ह सा वा द्वहंया दाः लिकयाः पुजाहारीं व होमबलिया वेदीइ छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","तर द्वहंया छेंगू, फुक्‍क ला, छ्यं, तुति व आतापुति भ्‍वरि सौ नापं ");
INSERT INTO new_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","पुजाहारीं थ्‍व फुक्‍क छाउनी पिने नउ वाइगु विधिकथं शुद्ध जूगु थासय् यंकाः सिँ द्यःने तयाः छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“‘इस्राएलया फुक्‍क मनूतय्‌सं परमप्रभुं याये मते धयादीगु ज्‍याखँ मसीकं यात धाःसा इमिसं थथे यायेमाः – ");
INSERT INTO new_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","थःपिन्‍सं याःगु पाप पिज्‍वइबलय् इमिसं पापबलिया निंतिं द्वहंचा हयाः नापलायेगु पालया ध्‍वाखाय् छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","खलःया थकालिपिन्‍सं परमप्रभुया न्‍ह्यःने द्वहंयागु छेनय् थथःगु ल्‍हाः तयेमाः, अले व द्वहंयात परमप्रभुया न्‍ह्यःने स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","अनं लिपा अभिषेक जूम्‍ह पुजाहारीं व द्वहंयागु हि भतिचा कयाः पवित्र थासय् हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","पुजाहारीं थःगु पतिंचा हिइ थुनाः व हि दथुइच्‍वंगु पर्दाय् न्‍हय्‌कः छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","अनं लिपा पवित्र थाय्‌या दुने परमप्रभुया न्‍ह्यःने च्‍वंगु गुँगू थनिगु वेदीया नेकुलिइ व हि छुं भचा तिकेमाः। ल्‍यंगु हि धाःसा नापलायेगु पालया ध्‍वाखाय् होमबलिया वेदीया तःलय् प्‍वंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","द्वहंया फुक्‍क दाः लिकयाः वेदीइ छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","पापबलिया द्वहंयात वं गथे याःगु खः थ्‍व द्वहंयात नं अथे हे यायेमाः। थुकथं पुजाहारीं इमिगु निंतिं प्रायश्‍चित यायेमाः, अले इमित क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","पुजाहारीं व द्वहंयात छाउनी पिने यंकाः न्‍हापांयाम्‍हय्‌सित छ्वय्‌कू थें छ्वय्‌केमाः। थ्‍व इस्राएलया फुक्‍क मनूतय्‌गु निंतिं पापबलि खः। ");
INSERT INTO new_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“‘सुं नायलं मसीकं परमप्रभु वया परमेश्‍वरं याये मते धयादीगु ज्‍याखँय् पापयात धाःसा वं थथे यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","वं याःगु पाप वयाके पिज्‍वःसा वं छम्‍ह खू मदुम्‍ह दुगु थःगु बलिया निंतिं हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","वं दुगुया छेनय् थःगु ल्‍हाः तयेमाः। परमप्रभुया न्‍ह्यःने होमबलिया पशु स्‍याइगु थासय् वयात स्‍यायेमाः। थ्‍व पापबलि खः। ");
INSERT INTO new_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","अनंलि पुजाहारीं थःगु पतिंचां पापबलिया हि भतिचा कयाः होमबलिया वेदीया नेकुलिइ तिकेमाः। अले ल्‍यंगु हि वेदीया तःलय् प्‍वंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","उकिया फुक्‍क दाः मेलबलिया दाः थें वेदीइ छ्वय्‌केमाः। थथे पुजाहारीं नायःया पापया लागिं प्रायश्‍चित याइ, अले वयात क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“‘खलःयाम्‍ह सुनानं मसीकं परमप्रभुं याये मते धयादीगु ज्‍याखँ यात धाःसा वं थथे यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","वं याःगु पाप वयाके खनेदत धाःसा थःम्‍हं यानागु पापया निंतिं थःगु बलिकथं खू मदुम्‍ह च्‍वलय् हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","वं शुद्ध जुइगु बलिया छेनय् थःगु ल्‍हाः तयेमाः अले होमबलिया थासय् स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","अनंलि पुजाहारीं थःगु पतिंचां शुद्ध जुइगु बलि हि भतिचा कयाः होमबलिया वेदीया नेकुलिइ तिकेमाः। अले उकिया ल्‍यंगु हि वेदीया तःलय् प्‍वंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","उकिया फुक्‍क दाः मेलबलिया दाः थें लिकायेमाः। अले पुजाहारीं परमप्रभुया निंतिं नस्‍वाः वय्‌केत वेदीइ छ्वय्‌केमाः। थथे पुजाहारीं उकिया निंतिं प्रायश्‍चित याइ, अले वयात क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“‘सुनानं पापबलिया निंतिं फैया मचा हल धाःसा वं खू मदुम्‍ह मिसाम्‍ह चिधिकःम्‍ह फै हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","वं शुद्ध जुइगु बलिया छेनय् थःगु ल्‍हाः तयेमाः। होमबलिया पशुत स्‍याइगु थासय् वयात स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","अनंलि पुजाहारीं थःगु पतिंचां शुद्ध जुइगु बलि हि भतिचा कयाः होमबलिया वेदीया नेकुलिइ तिकेमाः। उकिया ल्‍यंगु हि धाःसा वेदीया तःलय् प्‍वंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","परमप्रभुयात छाःगु विशेष देछाया फुक्‍क दाः नापं मेलबलिया चिधिकःम्‍ह भ्‍याःचाया दाः थें पापबलिया फुक्‍क दाः वं लिकया उकियात पुजाहारीं वेदीइ छ्वय्‌केमाः। थथे वं याःगु पापया निंतिं पुजाहारीं वयागु लागिं प्रायश्‍चित याइ, अले वयात क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“‘सुनानं थःम्‍हं खंगु व न्‍यंगु खँया साक्षी बीमाः थाय् साक्षी मबिल धाःसा व पाप खः अले वं उकियागु निंतिं दोष फयेमाली। ");
INSERT INTO new_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“‘सुनानं मसीकं जंगली पशुया सीम्‍ह, लहीपिं पशुया सीम्‍ह, घिसय्‌ जुया जुइपिं पशुया सीम्‍ह, थज्‍याःगु अशुद्ध वस्‍तु थियाः लिपा वाःचाल धाःसा व अशुद्ध जुइ, अले वं पाप मानय् यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“‘सुनानं मसीकं मनूया म्‍हया छुं अशुद्धगु ब्‍व थियाः लिपा वाःचाल धाःसा व दोषी थहरय् जुइ। ");
INSERT INTO new_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“‘सुनानं मसीकं भिंगु वा मभिंगु न्‍ह्यागु खँय् जूसां बिचाः मयासें पाफयाः लिपा वाःचाल धाःसा व दोषी थहरय् जुइ। ");
INSERT INTO new_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“‘सुं मनू थथे दोषी थहरय् जुल धाःसा वं थःगु पाप स्‍वीकार यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","अले वं सजाँयकथं परमप्रभुयाथाय् बथांपाखें मिसाम्‍ह चिधिकःम्‍ह फै वा च्‍वलय् पापबलि छाये हयेमाः। पुजाहारीं वयागु पापया निंतिं प्रायश्‍चित यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“‘चिधिकःम्‍ह भ्‍याःचा हये मफुसा वं परमप्रभुयाथाय् थःगु पापया सजाँयकथं निम्‍ह सुकुभत्तु वा निम्‍ह बखुं हयेमाः। छम्‍ह पापबलिया निंतिं व छम्‍ह होमबलिया निंतिं। ");
INSERT INTO new_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","वं थुपिं पुजाहारीयाथाय् हयेमाः। पुजाहारीं न्‍हापां पापबलिया निंतिं छम्‍ह छाइ। वं थुमिगु गःपः चमफुसे म्‍वय् जक थ्‍याइ। ");
INSERT INTO new_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","वं पापबलिया हि भतिचा कयाः वेदीया छखेपाखे छ्वाकि, अले ल्‍यं दुगु हि फुक्‍क वेदीया तःलय् प्‍वंकाछ्वइ। थ्‍व पापबलि खः। ");
INSERT INTO new_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","अनंलि पुजाहारीं मेम्‍ह झंगःयात नियमकथं होमबलि यानाः छाइ। थुकथं वं याःगु पापया निंतिं पुजाहारीं प्रायश्‍चित यायेमाः। अले वयात क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“‘छुं जुयाः वं निम्‍ह सुकुभत्तु वा निम्‍ह बखुं नं हये मफुसा छगू एपाया झिब्‍वय् छब्‍व नचुगु छुचुं पापबलिया निंतिं हयेमाः। वं उकी चिकं वा धुपाँय्‌ मतयेमाः, छाय्‌धाःसा थ्‍व पापबलि खः। ");
INSERT INTO new_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","वं थ्‍व पुजाहारीयाथाय् हयेमाः। अले पुजाहारीं उकियात लुमन्‍तिकथं छम्‍हू छुचुं कयाः परमप्रभुया निंतिं वेदीइ विशेष देछाया च्‍वय्‌ छ्वय्‌केमाः। थ्‍व पापबलि खः। ");
INSERT INTO new_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","थुकथं पुजाहारीं वयागु पापया निंतिं प्रायश्‍चित यायेमाः, अले वयात क्षमा दइ। ल्‍यं दुगु छुचुं धाःसा अन्‍नबलि बीबलय् थें पुजाहारीयागु हे जुइ।’” ");
INSERT INTO new_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“सुनानं मसीकं परमप्रभुया पवित्र सम्‍पत्तिया छुं नं खँय् पापयात धाःसा वं सजाँयकथं परमप्रभुयाथाय् बथांपाखें खू मदुम्‍ह भ्‍याःचा छायेमाः। भ्‍याःचाया मू पवित्र पालया शेकेल कथं क्‍वःछी। थ्‍व दोषबलि खः। ");
INSERT INTO new_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","सुनानं थुकथं परमप्रभुयात छाये हयेमाःगु पवित्र खँय् द्वंकल धाःसा वं उकिया पलेसा पुले हे माः। अज्‍ज न्‍याब्‍वय् छब्‍व अप्‍वः तनेमाः। वं थ्‍व फुक्‍क व दोषबलिया भ्‍याःचा पुजाहारीयाथाय् हयेमाः। पुजाहारीं वयागु पापया निंतिं भ्‍याःचायात दोषबलिकथं छानाः प्रायश्‍चित याइ। अले वयात क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“सुनानं मसीकं परमप्रभुं याये मते धाःगु खँ यानाः पापयात धाःसा व दोषी थहरय् जुइ। अले उकिया सजाँय वं फयेमाली। ");
INSERT INTO new_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","वं दोषबलिकथं पुजाहारीयाथाय् बथांपाखें खू मदुम्‍ह भ्‍याःचा हयेमाः। भ्‍याःचाया मू शेकेलयाकथं क्‍वःछी। पुजाहारीं वं मसीकं याःगु वयागु दोषया निंतिं प्रायश्‍चित याइ। अले वयात क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","थ्‍व दोषबलि खः। थज्‍याःम्‍ह मनू धात्‍थें हे परमप्रभुया न्‍ह्यःने दोषी थहरय् जूगु खः।” ");
INSERT INTO new_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","परमप्रभुं मोशायात धयादीगु विधि थ्‍व हे खः, ");
INSERT INTO new_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“सुनानं तयेबियातःगु वस्‍तु लित मब्‍यूसे, दि तयातःगु वस्‍तु लित मब्‍यूसे, खुयाः वा जःलाखःलायात झंगः लानाः, ");
INSERT INTO new_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","सुयागुं तंगु वस्‍तु लुइकाः उकिया बारे मखुगु खँ ल्‍हानाः, मखुगु पाः फयाः परमप्रभुया विरोधय् पापयात धाःसा ");
INSERT INTO new_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","व दोषी थहरय् जूगु दु। वं थःत तयेबियातःगु वस्‍तु, दि तय्‌कातःगु वस्‍तु, खुयातःगु वस्‍तु, झंगः लानाः कयातःगु वस्‍तु, तंगु लुइकाहःगु वस्‍तु, ");
INSERT INTO new_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","वा मखुगु पाः फयातःगु खँया न्‍याब्‍वय् छब्‍व अप्‍वः तनाः पलेसा पुलेमाः। वं दोषबलि बीखुन्‍हु थ्‍व फुक्‍क थुकिया थुवाःयात पुलेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","वं पुजाहारीयाथाय् परमप्रभुयात दोषबलि बीत खू मदुम्‍ह भ्‍याःचा हयेमाः। भ्‍याःचाया मू शेकेलया मूकथं क्‍वःछी। ");
INSERT INTO new_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","थ्‍व विधिकथं पुजाहारीं वयागु निंतिं परमप्रभुया न्‍ह्यःने प्रायश्‍चित यायेमाः। अले वयात क्षमा दइ।” ");
INSERT INTO new_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“हारून व वया काय्‌पिन्‍त थथे आज्ञा ब्‍यु, ‘होमबलि बीगु विधि थथे खः – होमबलि चच्‍छि व सुथय् तक वेदीइ तयेमाः। वेदीइ मि च्‍यानाच्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","अले पुजाहारीं पुजाहारीया सुति वसः व दुनेया सुति वसः पुनाः होमबलिया नौ लिकयाः वेदीया छखे तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","अले वं फिनातःगु वसः त्‍वयाः मेगु वसः पुनाः नौयात छाउनी पिने छगू शुद्धगु थासय् यंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","वेदीइ मि च्‍याना हे च्‍वनेमाः, अले गुबलें मसीमाः। पुजाहारीं न्‍हिन्‍हिं सुथय् उकी सिँ तनेमाः, पुजाहारीं होमबलिया कुचात व मेलबलिया दाः मिया च्‍वय् मिलय् यानाः तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","वेदीइ मि मदिक्‍क च्‍याना हे च्‍वनेमाः, व गुबलें हे सी मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“‘अन्‍नबलि छायेगु विधि थथे खः – हारूनया काय्‌पिन्‍सं थुकियात परमप्रभुया न्‍ह्यःने वेदीइ हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","पुजाहारीं छम्‍हू भिंगु छुचुं व चिकं कयाः फुक्‍क धुपाँय्‌ तयाः च्‍याकाः अन्‍नबलिया चिंकथं परमप्रभुया निंतिं नस्‍वाः जुइत वेदीइ छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“‘ल्‍यं दुगु धाःसा हारून व वया काय्‌पिन्‍सं नइ। इमिसं थुकियात सोडा मतसे व नापलायेगु पालया चुकय् च्‍वनाः नयेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","थुकी सोडा ल्‍वाकछ्यानाः मदय्‌केमाः। जितः छाःगु विशेष बलिया ब्‍व जिं इमित बियागु दु। अले थ्‍व पापबलि व दोषबलि थें हे पवित्र खः। ");
INSERT INTO new_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","अले सदांया निंतिं हारूनया मिजंपिं सन्‍तानतय्‌सं थ्‍व नयेमाः। परमप्रभुयात छायेहःगु अन्‍नबलितपाखें थ्‍व इमिगु पुस्‍तौं पुस्‍ताया लागिं इमिगु ब्‍व खः। मेपिं सुनानं विशेष देछा थिल धाःसा उकियागु पवित्रताया शक्तिं वयात हानि याइ।’” ");
INSERT INTO new_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","परमप्रभुं मोशायात हानं धयादिल, ");
INSERT INTO new_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“हारून अभिषेक जू खुन्‍हु वं व वया काय्‌पिन्‍सं परमप्रभुयात छायेमाःगु बलि थुकथं दु – सुथय् बच्‍छि व बहनिइ बच्‍छि यानाः न्‍हिं छगू व बागू किलोग्राम भिंगु छुचुं अन्‍नबलिकथं न्‍ह्याबलें छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","थुकियात चिकंनाप वालाः द्वालय् छुयेमाः। अले कुचा कुचा यानाः परमप्रभुयात लय्‌ताय्‌केगु नस्‍वाः जुइत अन्‍नबलिकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","थुकथं हे न्‍ह्याबलें अभिषेक जुयाः वयागु थासय् पुजाहारी जुइम्‍ह वया सन्‍तानं हे अन्‍नबलि छायेमाः। थ्‍व परमप्रभुया न्‍ह्याबलेंया ब्‍व खः, अले थ्‍व फुक्‍कं छ्वय्‌का छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","पुजाहारीया फुक्‍क अन्‍नबलि छ्वय्‌का छ्वयेमाः। थ्‍व मनयेमाः।” ");
INSERT INTO new_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","परमप्रभुं मोशायात हानं धयादिल, ");
INSERT INTO new_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“हारून व वया काय्‌पिन्‍त धा, ‘पापबलि छायेगु विधि थथे खः। होमबलि ब्‍यूथाय् हे पापबलि नं परमप्रभुया न्‍ह्यःने बीमाः। थ्‍व तसकं पवित्रगु बलि खः। ");
INSERT INTO new_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","बलि छाइम्‍ह पुजाहारीं हे थुकिया ला नइ। नापलायेगु पालया चुकय् च्‍वनाः हे थ्‍व नयेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","सुनानं वा छुकिं व पशुया ला थी उकियागु पवित्रताया शक्तिं वयात हानि याइ। हि छफुतिं जक क्‍यूगु वसः नं पवित्रगु थासय् हीमाः। ");
INSERT INTO new_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ला चाया थलय् दय्‌कूगु खःसा व चाया थलयात तछ्यायेमाः। कँय्‌या थलय् दय्‌कूगु खःसा लखं बांलाक सिलाछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","पुजाहारी जुइपिं न्‍ह्याम्‍ह काय्‌मस्‍तय्‌सं नं थ्‍व नयेफु। थ्‍व तसकं पवित्र खः। ");
INSERT INTO new_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","पाप प्रायश्‍चित यायेत पवित्रगु थासय् पापबलिया पशुया हि छाये हःसा उम्‍ह पशुया ला नये मज्‍यू। व फुक्‍कं मिइ च्‍याका छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“‘दोषबलि छायेगु विधि थ्‍व खः। थ्‍व तसकं पवित्र जू। ");
INSERT INTO new_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","गुगु थासय् होमबलि स्‍याइ व हे थासय् दोषबलिया भ्‍याःचा नं स्‍यायेमाः। वयागु हि वेदीया जःखः छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","पुजाहारीं थुकिया फुक्‍क दाः वेदीइ छायेमाः। दाःखाःगु न्‍हिप्‍यं, दुलापिलायात भुनाच्‍वंगु दाः, ");
INSERT INTO new_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","जँया नापं च्‍वंगु दाः, भुनाच्‍वंगु निगुलिं जलासेँ व सेँया भिंगु ब्‍व लिकायेमाः। ");
INSERT INTO new_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","पुजाहारीं परमप्रभुया निंतिं विशेष देछाकथं व वेदीइ छ्वय्‌केमाः। थ्‍व दोषबलि खः। ");
INSERT INTO new_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","पुजाहारी जुइपिं न्‍ह्याम्‍ह काय्‌मस्‍तय्‌सं नं थ्‍व नयेफु। थ्‍व नापलायेगु पालया चुकय् च्‍वनाः नयेमाः। थ्‍व तसकं पवित्रगु खः। ");
INSERT INTO new_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“‘पापबलि थें हे दोषबलिइ नं अथे हे यायेगु खः। गुम्‍ह पुजाहारीं बलि छानाः इमिगु लागिं प्रायश्‍चित याइ, ला व हे पुजाहारीयागु जुइ। ");
INSERT INTO new_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","होमबलियागु छेंगू होमबलि छाःम्‍ह पुजाहारीयागु हे जुइ। ");
INSERT INTO new_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","भुतलिइ, द्वालय् व ताप्‍केचाय् दय्‌कूगु अन्‍नबलि छाःम्‍ह पुजाहारीयागु हे जुइ। ");
INSERT INTO new_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","चिकनय् बुलातःगु व गंगु फुक्‍क अन्‍नबलि हारूनया काय्‌पिन्‍त उतिग्‍यंक हे थइ। ");
INSERT INTO new_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“‘परमप्रभुयात मेलबलि छायेगु विधि थथे खः – ");
INSERT INTO new_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“‘सुनानं परमप्रभुयात सुभाय् देछायेत मेलबलि छायेगु खःसा बलि बीत हःम्‍ह पशुनापं सोडा ल्‍वाकमछ्याःगु चिकनय् बुलातःगु ल्‍वहंचा मरि छपा, सालुगु मरि छपा अले सोडा मतःगु चिकनय् न्‍हायातःगु घः मरि छपा कयाः ");
INSERT INTO new_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","सुभाय् बीत छायेहःगु मेलबलि नापं वं सोडा ल्‍वाकछ्यानातःगु मरि नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","गुकिं छगू छगू यानाः परमप्रभुया निंतिं विशेष भेटीया लागिं व छायेमाः। सोडा तःगु मरि मेलबलिया हि छ्वाकिम्‍ह पुजाहारीया जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","सुभाय्‌या मेलबलिया ला छाःगु हे दिं नयेमाः। कन्‍हय् खुन्‍हु थ्‍व नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“‘तर छाइगु बलि भाकल वा थः यःछिया बलि जूसा थज्‍याःगु बलि छाःगु हे दिंखुन्‍हु नयेमाः। ल्‍यं दुगु ला कन्‍हय् खुन्‍हु नं नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","कंस तक ल्‍यं दुगु बलिया ला धाःसा मिइ छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","मेलबलिया ला कंस तक सुनानं नल धाःसा व नालेबहः जुइ मखु। व ला छाःम्‍हय्‌सियागु निंतिं छाःगु ल्‍याः याइ मखु, तर व अशुद्ध जुइ। अले व नःम्‍ह मनू दोषी थहरय् जुइ। ");
INSERT INTO new_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“‘सुनानं अशुद्ध वस्‍तुं थ्‍यूगु ला नये मज्‍यू। व मिइ छ्वय्‌केमाः। विधिकथं शुद्ध जूम्‍ह मनुखं धाःसा ल्‍यं दुगु ला नयेफु। ");
INSERT INTO new_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","तर अशुद्ध जुयाः परमप्रभुया मेलबलिया ला सुनानं नल धाःसा वयात वया मनूतय् दथुं पितिना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","सुनानं मनूया अशुद्ध, पशुया अशुद्ध वा मेगु छुं घचाइपुगु वस्‍तु थियाः परमप्रभुया मेलबलिया ला नल धाःसा वयात वया मनूतय् दथुं पितिना छ्वयेमाः।’” ");
INSERT INTO new_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","हानं परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“इस्राएलीतय्‌त धा, ‘छिमिसं सा वा द्वहं, फै वा दुगुयागु दाः नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","अथे सीम्‍ह व जंगली पशुतय्‌सं स्‍याःम्‍ह पशुया दाः मेगु ज्‍याय् छ्योसां ज्‍यू तर छिमिसं व नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","परमप्रभुया निंतिं विशेष देछाया पशुया दाः सुं मनुखं नल धाःसा वयात वया मनूतय् दथुं पितिना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","छिपिं न्‍ह्याथाय्‌सं च्‍वंसां पशुपंक्षीया हि गुबलें नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","हि नःम्‍ह न्‍ह्याम्‍ह मनू जूसां वयात वया मनूतय् दथुं पितिना छ्वयेमाः।’” ");
INSERT INTO new_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“इस्राएलीतय्‌त धा, ‘परमप्रभुया निंतिं मेलबलि छाइम्‍हय्‌सिनं मेलबलिया छब्‍व बलिकथं परमप्रभुया थासय् हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","वं परमप्रभुया निंतिं विशेष देछा थःगु ल्‍हातिं हयेमाः। वं दाः ह्याकुला नाप हयाः परमप्रभुया न्‍ह्यःने संकाबीगु बलिया निंतिं देछायेमाः। ");
INSERT INTO new_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","पुजाहारीं दाः वेदीइ छ्वय्‌केमाः। ह्याकुला धाःसा हारून व वया काय्‌पिनिगु जुइ। ");
INSERT INTO new_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","छिमिसं जव खम्‍पा नं मेलबलिं भेटीकथं पुजाहारीयात बीमाः। ");
INSERT INTO new_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","मेलबलिया हि व दाः छाःम्‍ह हारूनया काय्‌यागु ब्‍व जव खम्‍पा जुइ। ");
INSERT INTO new_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","छाय्‌धाःसा इस्राएलीतय्‌गु मेलबलिं संकूगु ह्याकुला व खम्‍पा जिं छिमिके कयाः पुजाहारीतय्‌त इस्राएलीतय्‌गुपाखें न्‍ह्याबलेंया निंतिं बियागु दु।’” ");
INSERT INTO new_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","गुखुन्‍हु हारून व वया काय्‌पिं पुजाहारी पदय् अभिषेक जुयाः परमप्रभुया न्‍ह्यःने सेवाया निंतिं दनी, उखुन्‍हुनिसें परमप्रभुया निंतिं विशेष देछाया ब्‍व इमिगु खः। ");
INSERT INTO new_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","गुखुन्‍हु इपिं अभिषेक जुल उखुन्‍हु हे परमप्रभुं इस्राएली मनूतय्‌सं इमित थ्‍व भाग बी धकाः उजं बियादिल। पुस्‍तौं पुस्‍ताया निंतिं न्‍ह्याबलें थ्‍व इमिगु ब्‍व जुइ। ");
INSERT INTO new_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","थ्‍व हे होमबलि, अन्‍नबलि, पापबलि, दोषबलि, अर्पणबलि व मेलबलिया विधि खः। ");
INSERT INTO new_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","“छिमिसं थुकथं परमप्रभुयाथाय् बलि हयाः छायेमाः” धकाः परमप्रभुं मोशायात सीनै मरुभूमिइ सीनै पर्वतय् उजं बियादिल। ");
INSERT INTO new_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","हानं परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“छं हारून व वया काय्‌पिं नापं इमिगु वसः, अभिषेक याइगु चिकं, पापबलिया द्वहं, निम्‍ह भ्‍याःचा व सोडा मतःगु मरिया दाला ");
INSERT INTO new_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","नापलायेगु पालया ध्‍वाखाय् हजि। अले फुक्‍क खलःयात नं अन हे मुंकि।” ");
INSERT INTO new_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","थथे परमप्रभुं मोशायात उजं बियादीगु थें मोशां यात, अले नापलायेगु पालया ध्‍वाखाय् फुक्‍क खलः मुन। ");
INSERT INTO new_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","मोशां इमित धाल, “परमप्रभुं या धकाः उजं बियादीगु ज्‍या थ्‍व हे खः।” ");
INSERT INTO new_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","अले मोशां हारून व वया काय्‌पिन्‍त हयाः विधिकथं म्‍वःल्‍हुइकल। ");
INSERT INTO new_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","वं हारूनयात जामालं फिकाः जँनी चिनाबिल। पुजाहारीया लं फिकाः उकी एपोद तयाबिल। एपोदया बांलाःगु बुत्ता दुगु जँनिखं हिनाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","अनं लिपा वं हारूनयात छातिपाता फिकाः उकी हे ऊरीम व तुम्‍मीम तयाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","अले वयागु छेनय् फेटा चिनाः फेटाया च्‍वय् न्‍ह्यःने पवित्र चिं लुँपाता तयाः परमप्रभुं मोशायात उजं बियादीगु थें मोशां यानाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","अनंलि मोशां अभिषेक याइगु चिकं ज्‍वनाः पवित्र पाल व अन दुने दुगु फुक्‍क ज्‍वलंयात अभिषेक यानाः शुद्ध यानाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","उकिं भतिचा चिकं कयाः व वेदीइ न्‍हय्‌कः तक छ्वाकल। अले वेदी व अनया फुक्‍क थलबल, ल्‍हाःतुति सिलेगु बाता व उकिया लिधंसा नापं शुद्ध यायेत अभिषेक यानाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","हानं वं अभिषेक यायेगु चिकं ज्‍वनाः हारूनया छेनय् प्‍वंकाः वयात शुद्ध यायेत अभिषेक यानाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","अनंलि परमप्रभुं मोशायात उजं बियादीगु थें मोशां हारूनया काय्‌पिन्‍त न्‍ह्यःने हयाः जामालं फीकाबिल, अले जँनी चिकाः इमित बेतालिं हिनाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","अनं लिपा वं पापबलिया द्वहं हल, अले हारून व वया काय्‌पिन्‍सं पापबलिया द्वहंया छेनय् थथःगु ल्‍हाः तल। ");
INSERT INTO new_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","अले मोशां द्वहंयात स्‍यात। वं हि भतिचा कयाः थःगु पतिंचां वेदीया प्‍यंगू नेकुलिइ तिकाः वेदीयात शुद्ध यानाबिल। ल्‍यं दुगु हि धाःसा वं वेदीया तःलय् प्‍वंकल। थथे यानाः वं वयागु लागिं प्रायश्‍चित यायेत वेदी शुद्ध यानाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","अले मोशां आतापुति भ्‍वरि त्‍वपुइगु फुक्‍क दाः, सेँया भिंगु ब्‍व व दाःनापया निगः जलासेँ कयाः वेदीइ छ्वय्‌कल। ");
INSERT INTO new_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","परमप्रभुं मोशायात उजं बियादी थें वं द्वहंयागु छेंगू, ला व सौ नापं छाउनी पिने यंकाः मिं छ्वय्‌काबिल। ");
INSERT INTO new_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","अनं लिपा मोशां होमबलि छायेत भ्‍याःचा हल। हारून व वया काय्‌पिन्‍सं थथःगु ल्‍हाः भ्‍याःचाया छेनय् तल। ");
INSERT INTO new_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","अले मोशां भ्‍याःचायात स्‍यात। अनं लिपा मोशां हि वेदीया जःखः छ्वाकल। ");
INSERT INTO new_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","वं भ्‍याःचाया ला कुचा कुचा ध्‍यनाः अले छ्यं व दाः नापं छ्वय्‌कल। ");
INSERT INTO new_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","परमप्रभुं मोशायात उजं बियादी थें वं आतापुति-भ्‍वरी व तुति लखं सिल, अले व परमप्रभुया निंतिं विशेष देछा, नस्‍वाः वःगु होमबलिकथं वं भ्‍याःचाया फुक्‍क म्‍ह वेदीइ छ्वय्‌कल। ");
INSERT INTO new_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","अनंलि वं अर्पणयाम्‍ह भ्‍याःचा न्‍ह्यःने यंकल। थ्‍व भ्‍याःचायागु छेनय् हारून व वया काय्‌पिन्‍सं नं थथःगु ल्‍हाः तल। ");
INSERT INTO new_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","अले मोशां वयात स्‍यात। वं हि कयाः हारूनया जव न्‍हाय्‌पं फ्‍वलय्, जव ल्‍हाःया बुरा-पतिंचाय् व जव तुतिया बुरा-पतिंचाय् तिकाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","अनं लिपा मोशां हारूनया काय्‌पिन्‍त हल, इमिगु जव न्‍हाय्‌पं फ्‍वलय्, जव ल्‍हाःया बुरापतिंचाय् व जव तुतिया बुरापतिंचाय् हि तिकाबिल। अले हि वेदीया जःखः छ्वाकाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","अले वं दाः, दाःखाःगु न्‍हिप्‍यं, आतपुति-भ्‍वरी त्‍वपुइगु फुक्‍क दाः, सेँया भिंगु ब्‍व, दाः नापंया निगः जलासेँ व जव खम्‍पा काल। ");
INSERT INTO new_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","अले परमप्रभुया न्‍ह्यःने दुगु दालां सोडा ल्‍वाकमछ्याःगु ल्‍वहंचा मरि छपा, सोडा मतःगु चिकनय् बुलातःगु घः मरि छपा अले सालुगु मरि छपा कयाः दाः व जव खम्‍पाया द्यने तयाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","थ्‍व फुक्‍क हारून व वया काय्‌पिनिगु ल्‍हातिइ तयाबिल। अले इमिसं परमप्रभुया न्‍ह्यःने संकाबीगु बलिकथं छाल। ");
INSERT INTO new_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","अनं लिपा मोशां इमिगु ल्‍हातिं व कयाः परमप्रभुया निंतिं विशेष देछा, नस्‍वाःगु अर्पण बलिकथं होमबलिया वेदीइ छ्वय्‌कल। ");
INSERT INTO new_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","परमप्रभुं मोशायात उजं बियादीगु थें हे वं ह्याकुला कयाः संकाबीगु बलिकथं परमप्रभुया न्‍ह्यःने छाल। थ्‍व अर्पण बलियाम्‍ह मिजंम्‍ह फैया ब्‍व मोशायागु हे खः। ");
INSERT INTO new_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","अले मोशां अभिषेकया भतिचा चिकं व वेदीं हि भतिचा कयाः हारून व वया वसतय् अले वया काय्‌पिं व इमिगु वसतय् नापं छ्वाकल। थथे वं हारून व वया काय्‌पिनिगु वसः नापं शुद्ध यानाबिल। ");
INSERT INTO new_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","अले मोशां हारून व वया काय्‌पिन्‍त धाल, “छिमिसं नापलायेगु पालया चुक दुने ध्‍वाखाया लिक्‍क ला दय्‌काः व अभिषेक बलिया दालाय् दुगु मरिनापं अन हे च्‍वनाः न। ");
INSERT INTO new_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ल्‍यं दुगु ला व मरि धाःसा छ्वय्‌काब्‍यु! ");
INSERT INTO new_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","छिमिगु अभिषेकया विधि पूमवंतले न्‍हय्‌न्‍हु तक छिपिं नापलायेगु पालया ध्‍वाखां पिने वने मते, छाय्‌धाःसा छिमिगु अभिषेक न्‍हय्‌न्‍हु तक दयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","छिमिगु निंतिं प्रायश्‍चित यायेत गथे थौं याःगु खः अथे हे यायेगु उजं परमप्रभुं बियादीगु दु। ");
INSERT INTO new_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","अथे जुयाः छिपिं नापलायेगु पालया चुकय् न्‍हय्‌न्‍हु तक चां न्‍हिं च्‍वनेमाः। छिपिं सिना मवनेमा धकाः परमप्रभुयागु उजंयात मानय् यायेमाः छाय्‌धाःसा जितः थज्‍याःगु हे उजं बियादीगु खः।” ");
INSERT INTO new_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","अले परमप्रभुं मोशापाखें ब्‍यूगु फुक्‍क उजं हारून व वया काय्‌पिन्‍सं पालन यात। ");
INSERT INTO new_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","अभिषेकया कन्‍हय् खुन्‍हु मोशां हारून, वया काय्‌पिं व इस्राएलया थकालिपिन्‍त सःतल। ");
INSERT INTO new_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","अले वं हारूनयात धाल, “थःगु पापबलिया निंतिं छम्‍ह खू मदुम्‍ह द्वहंचा व होमबलिया निंतिं खू मदुम्‍ह भ्‍याःचा यंकाः परमप्रभुया न्‍ह्यःने बलि ब्‍यु। ");
INSERT INTO new_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","अले इस्राएलीतय्‌त धा, ‘पापबलिया लागिं छम्‍ह दुगु व होमबलिया लागिं दच्‍छि दुम्‍ह व खू मदुम्‍ह द्वहंचा व चिधिकःम्‍ह भ्‍याःचा छम्‍ह छम्‍ह ज्‍वँ। ");
INSERT INTO new_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","अले मेलबलिया लागिं छम्‍ह द्वहं व छम्‍ह भ्‍याःचा, चिकनं बुलातःगु अन्‍नबलि नापं परमप्रभुयाथाय् बलिया लागिं हजि। छाय्‌धाःसा परमप्रभु थौं छिमिथाय् खनेदय्‌कः झाइ।’” ");
INSERT INTO new_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","मोशां उजं ब्‍यू थें इमिसं फुक्‍क ज्‍वलं नापलायेगु पालया ध्‍वाखाय् हल, अले फुक्‍क मनूत परमप्रभुया न्‍ह्यःने दं वल। ");
INSERT INTO new_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","मोशां धाल, “परमप्रभुं उजं बियादीगु छिमिसं यायेमाःगु ज्‍या थ्‍व हे खः गुकिं यानाः परमप्रभुया महिमा छिमिथाय् खनेदइ।” ");
INSERT INTO new_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","मोशां हारूनयात धाल, “परमप्रभुं उजं बियादी थें वेदीया न्‍ह्यःने थःगु शुद्ध जुइगु बलि व होमबलियात छायाः थःगु व फुक्‍क मनूतय्‌गु लागिं प्रायश्‍चित या, अले मनूतय्‌सं छायेहःगु नं छायाः इमिगु लागिं प्रायश्‍चित या।” ");
INSERT INTO new_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","अनंलि वेदीया न्‍ह्यःने वयाः हारूनं थःगु निंतिं पापबलिया द्वहंचा स्‍यात। ");
INSERT INTO new_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","वया काय्‌पिन्‍सं हि वयागु ल्‍हातय् बिल। वं हिइ थःगु पतिंचा थुनाः वेदीया नेकुलिइ तिकल। अले ल्‍यं दुगु हि फुक्‍क वेदीया तःलय् प्‍वंकाबिल। ");
INSERT INTO new_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","पापबलिया दाः, जलासेँ व सेँया भिंगु ब्‍वयात वं परमप्रभुं मोशायात उजं बियादी थें वेदीइ छ्वय्‌काबिल। ");
INSERT INTO new_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ला व छेंगूयात वं छाउनी पिने मिइ छ्वय्‌काबिल। ");
INSERT INTO new_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","अनंलि हारूनं होमबलिया पशु स्‍यात, वया काय्‌पिन्‍सं हि वयागु ल्‍हातय् बिल, अले वं थुकियात वेदीया जःखः छ्वाकल। ");
INSERT INTO new_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","इमिसं होमबलिया ला व छ्यं ध्‍यनाः वयागु ल्‍हातय् तयाबिल, अले वं व वेदीइ छ्वय्‌काबिल। ");
INSERT INTO new_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","वं दुला, भ्‍वरि व तुति सिलाः वेदीइ होमबलिया च्‍वय् छ्वय्‌काबिल। ");
INSERT INTO new_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","अनंलि वं मनूतय्‌गु निंतिं बलि छायेहल। वं मनूतय्‌गु पापबलिया दुगुचायात स्‍यानाः न्‍हापा थें छाल। ");
INSERT INTO new_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","अनंलि वं होमबलि हयाः माःकथं छाल। ");
INSERT INTO new_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","वं अन्‍नबलि हयाः उकिं छम्‍हू अन्‍न कयाः वेदीइ छ्वय्‌कल। थ्‍व सुथसिया होमबलि बाहेकयागु देछा खः। ");
INSERT INTO new_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","वं मनूतय्‌गु निंतिं मेलबलिया द्वहं व भ्‍याःचा नं स्‍यात। वया काय्‌पिन्‍सं हि वयागु ल्‍हातय् बिल। अले वं व वेदीया जःखः छ्वाकल। ");
INSERT INTO new_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","द्वहंयागु दाः व भ्‍याःचायागु दाःखाःगु न्‍हिप्‍यं, जलासेँ व सेँया भिंगु ब्‍वयात ");
INSERT INTO new_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","वं ह्याकुलाया द्यःने तल। दाः जुक्‍व वेदीइ छ्वय्‌कल। ");
INSERT INTO new_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","मोशां उजं ब्‍यू थें वं ह्याकुला व जव खम्‍पाया लाफः नापं संकाः परमप्रभुया न्‍ह्यःने संकाबीगु बलिकथं छाल। ");
INSERT INTO new_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","अले हारूनं थःगु निपा ल्‍हाः मनूतपाखे ल्‍ह्वनाः इमित आशिष बिल। थुकथं पापबलि, होमबलि व मेलबलि छायाः व वेदीं क्‍वय् कुहां वल। ");
INSERT INTO new_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","अनंलि मोशा व हारून पवित्र पाल दुने दुहां वन, अले पिहां वयाः मनूतय्‌त आशिष बिल। अले परमप्रभुया महिमा फुक्‍क मनूतय्‌गु न्‍ह्यःने खनेदत। ");
INSERT INTO new_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","उबलय् हे परमप्रभुयापाखें मि पिहां वयाः वेदीइ च्‍वंगु होमबलि व दाःयात भस्‍म यात। थ्‍व खनाः मनूत तःसलं हालाः बँय् भ्‍वसुल। ");
INSERT INTO new_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","हारूनया काय्‌पिं नादाब व अबीहूं थथःगु गुँगू थनेगु मकः कयाः उकी मि थन, अले व मिइ धुपाँय्‌ तयाः परमप्रभुं उजं बियामदीगु मि तयाः वय्‌कःया न्‍ह्यःने छाल। ");
INSERT INTO new_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","उकिं परमप्रभुयापाखें मि पिहां वयाः इमित परमप्रभुया न्‍ह्यःने स्‍यानाबिल। ");
INSERT INTO new_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","अले मोशां हारूनयात धाल, “परमप्रभुं धयादीगु खँ थ्‍व हे खः, “‘जिगु न्‍ह्यःने वइपिंपाखें जिं जिगु पवित्रता क्‍यने। जिं फुक्‍क मनूतय्‌गु न्‍ह्यःने थःगु महिमा क्‍यने।’” हारून सुम्‍क च्‍वन। ");
INSERT INTO new_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","मोशां हारूनया कका उज्‍जीएलया काय्‌पिं मीशाएल व एलसाफानयात सःताः धाल, “पवित्र पालया न्‍ह्यःनं छिमि किजापिनिगु सीम्‍ह क्‍वबियाः छाउनीं पिने यंकि।” ");
INSERT INTO new_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","उकिं इमिसं मोशां आज्ञा ब्‍यू थें हे नादाब व अबीहूया सीम्‍हयात इमिगु हे लनय् प्‍वःचिनाः क्‍वबियाः छाउनी पिने यन। ");
INSERT INTO new_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","अले मोशां हारून व वया काय्‌पिं एलाजार व ईतामारयात धाल, “छिमिसं थःपिनिगु सँ भुलुसुलु दंका तये मते, अले लं खुइ मते। मखुसा छिपिं सी, अले फुक्‍क मनूतलिसे परमप्रभु तंम्‍वयादी। छिमि थःथितिपिं इस्राएलया फुक्‍क मनूत धाःसा परमप्रभुया मिं सीपिनिगु निंतिं ख्‍वयेमाली। ");
INSERT INTO new_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","छिपिं नापलायेगु पालया चुकं पिने वने मते, मखुसा छिपिं सी, छाय्‌धाःसा परमप्रभुया अभिषेकया चिकं छिमिके दु।” अथे जूगुलिं इमिसं मोशां धाःथें यात। ");
INSERT INTO new_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","अनं लिपा परमप्रभुं हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“नापलायेगु पालय् वनेबलय् छ व छिमि काय्‌पिन्‍सं दाखमद्य वा थ्‍वँ त्‍वनाः वने मते, मखुसा छिपिं सी। थ्‍व छिमि पुस्‍तौं पुस्‍तातय्‌गु निंतिं न्‍ह्याबलेंया नियम खः। ");
INSERT INTO new_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","पवित्र व साधारण अले शुद्ध व अशुद्धया दथुइ छिमिसं पाःगु म्‍हसीकेमाः। ");
INSERT INTO new_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","अले परमप्रभुं मोशापाखें इमित बियादीगु फुक्‍क शिक्षा छिमिसं इस्राएलीतय्‌त स्‍यनेमाः।” ");
INSERT INTO new_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","मोशां हारून व वया ल्‍यंदुपिं काय्‌पिं एलाजार व ईतामारयात धाल, “परमप्रभुयात विशेष देछा छाये धुंकाः ल्‍यं दुगु अन्‍नबलि यंकाः वेदी लिक्‍क सोडा ल्‍वाकमछ्यासे दय्‌काः न, छाय्‌धाःसा थ्‍व तसकं पवित्र जू। ");
INSERT INTO new_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","छिमिसं थ्‍व नापलायेगु पालया चुकय् च्‍वनाः न। छाय्‌धाःसा परमप्रभुया निंतिं छाःगु विशेष देछातपाखें थ्‍व छंगु व छिमि काय्‌पिनिगु ब्‍व खः। जितः थथे हे उजं ब्‍यूगु खः। ");
INSERT INTO new_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","संकाबीगु बलिया व ह्याकुला विशेष भेटी खम्‍पा धाःसा छ, छिमि काय्‌पिं व म्‍ह्याय्‌पिन्‍सं विधिकथं शुद्ध याःगु थासय् च्‍वनाः नयेमाः। छाय्‌धाःसा थ्‍व इस्राएलीतय्‌गु मेलबलिया पाखेंयागु छिमिगु ब्‍व खः। ");
INSERT INTO new_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","नये न्‍ह्यः धाःसा पुजाहारीं ह्याकुला व खम्‍पाया व द्यःने तयातःगु विशेष भेटीया दाः वेदी न्‍ह्यःने हयाः परमप्रभुया निंतिं संकाबीगु बलिकथं छाये हयेमाः। उबलय् जक परमप्रभुया उजंकथं थ्‍व सदांया निंतिं छ व छिमि काय् म्‍ह्याय्‌पिनिगु ब्‍व जुइ।” ");
INSERT INTO new_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","मोशां पापबलिया बारे न्‍यंनेकने याःबलय् छ्वय्‌के धुंकूगु सीकल। अले व हारूनया ल्‍यंदुपिं काय्‌पिं एलाजार व ईतामारलिसे तंम्‍वल। अले वं इमित धाल, ");
INSERT INTO new_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“छिमिसं छाय् पापबलि नापलायेगु पालया चुकय् मनयागु? व तसकं पवित्रगु खः। परमप्रभुं थ्‍व खलःया दोष हुयाछ्वयेगु निंतिं अले मनूतय्‌त शुद्ध यायेगु निंतिं परमप्रभुया न्‍ह्यःने प्रायश्‍चित यायेत छिमित बियादीगु खः। ");
INSERT INTO new_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","दुगुचिगु हि पवित्रगु थासय् दुने महःगुलिं छिमिसं जिं धाःथें वयागु ला नापलायेगु पालया चुकय् नयेमाःगु खः।” ");
INSERT INTO new_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","अले हारूनं मोशायात धाल – “थौं हे इमिसं थःगु पापबलि व होमबलि परमप्रभुया न्‍ह्यःने छाल। अले थौं हे जितः आपत जुल! जिं थौं पापबलि नःगु जूसा छु परमप्रभु लय्‌ताइ ला?” ");
INSERT INTO new_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","थ्‍व खँ न्‍यनाः मोशाया मन च्‍वन। ");
INSERT INTO new_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“इस्राएलीतय्‌त धा, ‘पृथ्‍वीइ च्‍वंपिं फुक्‍क पशुत मध्‍ये थुपिं पशुत छिमिसं नयेफु। ");
INSERT INTO new_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","तुतिख्‍वः बाःपिं व लिन्‍ह्ययाः नइपिं पशुत छिमिसं नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“‘अथे खःसां लिन्‍ह्ययाः जक नइपिं वा तुतिख्‍वः जक बाःपिं पशुत धाःसा नये मज्‍यू। गथेकि ऊँट, वं लिन्‍ह्ययाः नःसां वयागु तुतिख्‍वः मबाः। व छिमिगु निंतिं अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","अले शापन – वं लिन्‍ह्ययाः नःसां वयागु तुतिख्‍वः मबाः। व छिमिगु निंतिं अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","अथे हे खराचा – वं लिन्‍ह्ययाः नःसां वयागु तुतिख्‍वः मबाः। व छिमिगु निंतिं अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","अथे हे छिमिसं फा नं नये मज्‍यू। छाय्‌धाःसा वयागु तुतिख्‍वः बाःसां वं लिन्‍ह्ययाः मनः। उकिं व छिमिगु निंतिं अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","थुपिं पशुतय्‌गु ला छिमिसं नये मज्‍यू, अज्‍ज ला थुमिगु सीम्‍ह तक नं थीमज्‍यू। थुपिं अशुद्धपिं खः। ");
INSERT INTO new_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“‘लखय् च्‍वनिपिं पपू व बिखू दुपिं जन्‍तुत धाक्‍व छिमिसं नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","समुद्र व खुसिइ च्‍वनिपिं पपू व बिखू मदुपिं जन्‍तुत, चाहे ब्‍वया जुइपिं जुइमा वा लखय् च्‍वनिपिं मेपिं जन्‍तु जुइमा छिमिगु लागिं घच्‍चाइपुपिं खः। ");
INSERT INTO new_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","थज्‍याःपिं जन्‍तुत घच्‍चाइपुपिं जूगुलिं छिमिसं थुमिगु ला नये मज्‍यू, अज्‍ज ला थुमिगु सीम्‍ह तक नं थीमज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","लखय् च्‍वनिपिं पपू व बिखू मदुपिं जुक्‍व छिमिगु लागिं घच्‍चाइपुपिं खः। ");
INSERT INTO new_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","“‘झंगःत मध्‍ये थुपिं घचाइपुसे च्‍वंपिं खः धकाः थुइकि। गथेकि थीथी कथंयापिं गरूड, गिद्ध, हाकुम्‍ह गिद्ध, ह्याउँम्‍ह इमा, हाकुम्‍ह इमा, क्‍वः, अस्‍ट्रिच, हुचिल, लःहँय्, बाय्‌चा, न्‍हिकांझंगः, हाडगील, भुल्‍का, राजहंस, धनेस, न्‍या नइम्‍ह क्‍वः, सलांत्‍याः झंगः, न्‍याखुं ब्‍वह, कल्‍कि झंगः व चिकंलापा। थुमिगु ला नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“‘पपू दुपिं तुतिं चुइपिं कीत फुक्‍क छिमिगु लागिं घच्‍चाइपुपिं खः। ");
INSERT INTO new_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","पपू दुपिं तुतिं चुइपिंलय् नं तिंन्‍हुयेत तुतिइ स्‍वापु दुपिं कीत धाःसा नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","छिमिसं क्‍वःबुइँचा, बुइँचा व त्‍वाति नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","पपू दुपिं घिसय् जुयाः जुइपिं फुक्‍क कीत छिमिगु लागिं घच्‍चाइपुपिं खः। ");
INSERT INTO new_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“‘थुमिगुपाखें छिपिं अशुद्ध जुइ। सुनां थुमिगु सीम्‍ह थी, व सन्‍ध्‍याः ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","सुनां थुमिगु सीम्‍ह क्‍वबिइ वं थःगु वसः हीमाः, अले सन्‍ध्‍याः ईतक व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“‘तुतिख्‍वः बांलाक मबाःपिं पशु, लिन्‍ह्ययाः नइमखुपिं पशु फुक्‍क छिमिगु निंतिं अशुद्ध खः। सुनां इमिगु सीम्‍ह थी, व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","प्‍यपां चुयाः जुइपिं मध्‍ये पन्‍जांया बलं जुइपिं फुक्‍क पशु छिमिगु निंतिं अशुद्ध खः। सुनांनं इमिगु सीम्‍ह थी, व सन्‍ध्‍याः ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","इमिगु सीम्‍ह क्‍वबीपिन्‍सं थःगु वसः हीमाः, अले सन्‍ध्‍याः ईतक अशुद्ध जुइ। इपिं फुक्‍क छिमिगु निंतिं अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","“‘नवःचा, म्‍हालकाय्‌चा, छुँ, माय्‌बिलिचा, थज्‍याःपिं बँय् घिसय् जुया जुइपिं फुक्‍कं छिमिगु निंतिं अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","बँय् घिसय् जुया जुइपिं मध्‍ये थुपिं फुक्‍कं छिमिगु निंतिं अशुद्ध खः। सुनां थुमित व थुमिगु सीम्‍ह थी, व सन्‍ध्‍या ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","उपिं मध्‍ये सुं सीबलय् थुमिगु सीम्‍ह छुं चीजया लात धाःसा व अशुद्ध जुइ। सिँ, कापः, छेंगू, भांग्रा वा न्‍ह्यागुयागु दय्‌कातःगु जूसां सन्‍ध्‍या ईतक व अशुद्ध जुइ। उकियात लखय् थुना तयेमाः अले तिनि व शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","थुमिगु सीम्‍ह गुगुं नं कथंया चाया थलय् लात धाःसा उकी च्‍वंगु फुक्‍क वस्‍तु अशुद्ध जुइ। अले व चा थलयात तछ्याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","उकी च्‍वंगु लखं थ्‍यूगु व दय्‌कूगु फुक्‍क नसा अशुद्ध जुइ, थज्‍याःगु थलय् दुगु छुं नं त्‍वंसा अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","थुमिगु सीम्‍ह गुगुं कथंया चाया भुतू वा नसा दय्‌केगु थलय् कुतुंवन धाःसा व अशुद्ध जुइ। उकियात तछ्याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","बुंगाःचा व लः मुंकातःगु थाय् धाःसा शुद्ध जुइ। अथेसां सुनां अनं सीम्‍ह लिकाइ व धाःसा अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","गुगुं नं कथंयागु पीत तयातःगु पुसाय् थुमिगु सीम्‍ह लात धाःसा पुसा शुद्ध हे जुयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","लखय् माःबुइकातःगु पुसाय् थुमिगु सीम्‍ह कुतुंवन धाःसा पुसा अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“‘छिमिसं ला नये ज्‍यूम्‍ह पशु सित धाःसा, वयागु सीम्‍ह सुनां थी व सन्‍ध्‍या ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","सीम्‍ह पशुया ला नइम्‍ह व सीम्‍ह क्‍वब्यूम्‍हं थःगु वसः हीमाः, अले व सन्‍ध्‍या ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“‘बँय् घिसय् जुया जुइपिं फुक्‍क पशु घच्‍चायापुपिं खः इमिगु ला नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","प्‍वाथं चुयाः जुइपिं वा प्‍यपा व प्‍यपां अप्‍वः तुतिं बँय् घिसय् जुया जुइपिं पशुत फुक्‍क घच्‍चाइपुसे च्‍वंपिं खः। ");
INSERT INTO new_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","थुमित थी तक नं मते, मखुसा छिपिं अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","जि परमप्रभु छिमि परमेश्‍वर खः। छिमिसं थःपिन्‍त अर्पण यानाः पवित्र याना तयेमाः, छाय्‌धाःसा जि पवित्र खः। बँय् घिसय् जुया जुइपिं छुं नं कथंयाम्‍ह जन्‍तुपाखें छिपिं अशुद्ध जुइ मते। ");
INSERT INTO new_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","छाय्‌धाःसा जि छिमि परमेश्‍वर जुइत छिमित मिश्रंनिसें हयाम्‍ह परमप्रभु जि हे खः। उकिं छिपिं पवित्र जुइमाः, छाय्‌धाःसा जि पवित्र खः। ");
INSERT INTO new_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“‘पशुत, झंगःपंक्षीत अले लखय् च्‍वनिपिं व बँय् घिसय् जुया जुइपिं फुक्‍क प्राणीया बारे यायेमाःगु विधि थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","छिमिसं शुद्ध व अशुद्ध, अले नये ज्‍यूपिं व नये मज्‍यूपिं प्राणीत पाःगु म्‍हसीकेमाः।’” ");
INSERT INTO new_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“इस्राएलीतय्‌त धा – ‘प्‍वाथय् दयाः काय् बुइकूम्‍ह मिसा न्‍हय्‌न्‍हु तक अशुद्ध जुइ। थीमज्‍यू जूगु इलय् थें व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","च्‍यान्‍हु दुखुन्‍हु काय्‌या म्‍हय् चिं तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","अनंलि व मिसां हिबा वःगुपाखें शुद्ध जुइत स्‍विस्‍वन्‍हु तक मब्‍यंकुतले पीमाः। मब्‍यंकुतले वं गुगुं नं शुद्धगु वस्‍तु थीमज्‍यू अले पवित्रगु थासय् नं वने मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","म्‍ह्याय् बुइकल धाःसा व मिसा थीमज्‍यू जुइबलय् थें झिंप्‍यन्‍हु तक अशुद्ध जुइ। अनंलि खुइखुन्‍हु लिपा ब्‍यंके धुंकाः तिनि शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“‘शुद्ध जुइगु ई पूरा जुइ धुंकाः काय् बूसां म्‍ह्याय् बूसां वं होमबलिया निंतिं दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, व पापबलिया निंतिं बखुंचा वा सुकुभत्तु छम्‍ह परमप्रभुया न्‍ह्यःने नापलायेगु पालया ध्‍वाखाय् पुजाहारीयाथाय् हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","पुजाहारीं व फुक्‍क परमप्रभुया न्‍ह्यःने छानाः वयागु निंतिं प्रायश्‍चित याइ अले वयागु हिबा वःगुपाखें व शुद्ध जुइ। “‘मिसां काय् वा म्‍ह्याय् बुइके धुंकाः यायेमाःगु विधि थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","चिधिकःम्‍ह भ्‍याःचा हये मफुसा वं होमबलिया निंतिं छम्‍ह व पापबलिया निंतिं छम्‍ह यानाः सुकुभत्तु जूसां बखुं जूसां निम्‍ह हयेमाः। थुकथं पुजाहारीं वयागु निंतिं प्रायश्‍चित याइ। अले व शुद्ध जुइ।’” ");
INSERT INTO new_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“सुं मनूयागु म्‍हया छेंगुलिइ मनावल, इल्‍ल मिंक कै दयावल वा चातः दयावल धाःसा थ्‍व पुनेयःगु छेंगूया ल्‍वय् जुइफु। वयात पुजाहारी हारून वा वया काय्‌पिं मध्‍ये छम्‍ह पुजाहारीयाथाय् हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","थज्‍याःगु घाः पुजाहारीं स्‍वयेमाः अले वयागु ल्‍वचं काःगु थासय् बुयावःगु सँ तुयुसे च्‍वंसा वा व घाः छेंगू स्‍वयाः गाः वंगु खनेदत धाःसा, व पुनेयःगु ल्‍वय् खः। पुजाहारीं उकियात जाँचय् यानाः स्‍वये धुंकाः वयात अशुद्ध थहरय् यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","तर व चातः छेंगुलिइ तुयुसे च्‍वंसा, अले स्‍वइबलय् व छेंगू स्‍वया गाः वंगु खने मदुसा, अले उकी बुयावःगु सँ नं तुयुसे च्‍वनावःगु मदुसा, पुजाहारीं व ल्‍वगियात न्‍हय्‌न्‍हु तक अलग तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","न्‍हय्‌न्‍हु दुखुन्‍हु पुजाहारीं वयात जाँचय् यानाः स्‍वइबलय् व घाः न्‍हापां गथे खः अथे हे खनेदुसा अले छेंगुलिइ व घाः न्‍यनावंगु मदुसा पुजाहारीं वयात हानं न्‍हय्‌न्‍हु तक अलग तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","न्‍हय्‌न्‍हु खुन्‍हु पुजाहारीं वयात हानं जाँचय् यानाः स्‍वइबलय् ल्‍वय् कम जुइ धुंकूगु दु अले छेंगुलिइ न्‍यनावंगु मदुसा, पुजाहारीं वयात शुद्ध थहरय् यायेमाः। व चातः जक खः। वं थःगु वसः ही, अले व शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","तर शुद्ध थहरय् यायेत पुजाहारीयात क्‍यने धुंकाः व चातः छेंगुलिइ न्‍यनावन धाःसा, वं हानं पुजाहारीया थासय् वनाः थःत हे क्‍यनेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","अले पुजाहारीं जाँचय् यायेबलय् छेंगुलिइ चातः न्‍यनावन धाःसा पुजाहारीं वयात अशुद्ध थहरय् यायेमाः। थ्‍व पुनेयःगु ल्‍वय् खः। ");
INSERT INTO new_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“सुं मनूयात छेंगूया पुनेयःगु ल्‍वचं काल धाःसा वयात पुजाहारीयाथाय् हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","अले पुजाहारीं जाँचय् यानाः स्‍वइबलय् व छेंगुलिइ तुयुसे मनावःगु दुसा व उकियागु चिमिसँ तुयुसे च्‍वंगु अले मनावःगु थासय् न्‍हूगु घाः दुसा ");
INSERT INTO new_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","वयागु म्‍हय् दुगु थ्‍व धात्‍थें हे पुनेयःगु ल्‍वय् खः। अले पुजाहारीं वयात अशुद्ध थहरय् यायेमाः। व अशुद्ध थहरय् याय् धुकूंम्‍ह जूगुलिं पुजाहारीं वयात न्‍हय्‌न्‍हुया निंतिं अलग तयेम्‍वाः। ");
INSERT INTO new_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“तर ल्‍वय् छेंगुलिइ न्‍यनावना च्‍वंसा, अले उकियात पुजाहारीं स्‍वइबलय् ल्‍वगियागु छ्यनंनिसें तुति तकं छेंगुलि न्‍यनावंगु दुसा, ");
INSERT INTO new_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","पुजाहारीं वयात बांलाक स्‍वयाः व ल्‍वय् म्‍ह छम्‍हं न्‍यनावने धुंकूसा व मनूयात शुद्ध थहरय् यायेमाः। व ला धात्‍थें हे तुयुसे च्‍वने धुंकल, अले व शुद्धम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","तर उकी न्‍हूगु घाः खनेदत धाःसा व अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","पुजाहारीं वयागु न्‍हूगु घाः जाँचय् यानाः वयात अशुद्ध थहरय् यायेमाः। व न्‍हूगु घाः अशुद्ध खः, व पुनेयःगु ल्‍वय् खः। ");
INSERT INTO new_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","तर व न्‍हूगु घाः तुयुसे च्‍वन धाःसा व मनू पुजाहारीयाथाय् वनेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","अले पुजाहारीं वयात जाँचय् याइबलय् व चातः तुयुसे च्‍वने धुंकूसा पुजाहारीं व ल्‍वगियात शुद्ध थहरय् यायेमाः, व शुद्धम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“सुं मनूया छेंगुलि पिहां वःगु कै लाल धाःसा ");
INSERT INTO new_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","अले व कै दुगु थासय् तुयुसे च्‍वंक मनावल वा ह्याउँसे च्‍वंगु तुयुगु चातः दयावल धाःसा, वं पुजाहारीयात क्‍यनेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","अले वं जाँचय् यानाः स्‍वइबलय् व छेंगू स्‍वयाः गाः वंगु खनेदुसा अले अन दुगु चिमिसँ नं तुयुसे च्‍वंगु दुसा, पुजाहारीं वयात अशुद्ध थहरय् यायेमाः। व पुनेयःगु ल्‍वय् खः। व कैपाखें पिहां वःगु खः। ");
INSERT INTO new_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","तर पुजाहारीं जाँचय् याइबलय् उकी तुयुसे च्‍वंगु चिमिसँ मदुसा वा छेंगू स्‍वयाः गाः मवंसा तर चातः तनावना च्‍वंगु दुसा, पुजाहारीं वयात न्‍हय्‌न्‍हु तक अलग तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","व छेंगुलिइ न्‍यनावंगु दु धाःसा पुजाहारीं वयात अशुद्ध थहरय् यायेमाः व पुनेयःगु ल्‍वय् हे खः। ");
INSERT INTO new_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","तर तुयुसे च्‍वंगु चातः थःगु थासय् हे न्‍यनामवंसें च्‍वनाच्‍वंसा व घाःखू जक खः। पुजाहारीं व मनूयात शुद्ध थहरय् यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“सुं मनूया छेंगुलिइ मिं पुयाः घाः जुल धाःसा, अले व मिं पुनाजूगु घाःयागु न्‍हूगु ला ह्याउँसे च्‍वंगु तुयुगु चातः खनेदत धाःसा, ");
INSERT INTO new_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","पुजाहारीं वयात जाँचय् यायेमाः। अले व घालय् बुयावःगु चिमिसँ तुयुसे च्‍वनावःसा, व घाः जूगु थासय् स्‍वइबलय् छेंगू स्‍वयाः गाः वंगु खनेदःसा, पुजाहारीं वयात अशुद्ध थहरय् यायेमाः। व मिं पुनाजूगु घाःपाखें वःगु पुनेयःगु ल्‍वय् खः। ");
INSERT INTO new_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","“तर पुजाहारीं स्‍वइबलय् धात्‍थें व घालय् तुयुगु चिमिसँ बुयामवःसा, अले व छेंगू स्‍वयाः गाः मवंसा अले व गनावना च्‍वंसा, पुजाहारीं वयात न्‍हय्‌न्‍हु तक अलग तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","पुजाहारीं वयात न्‍हय्‌न्‍हु दुखुन्‍हु जाँचय् यायेमाः। वयागु ल्‍वय् छेंगुलि न्‍यना वंसा पुजाहारीं वयात अशुद्ध थहरय् यायेमाः। व पुनेयःगु ल्‍वय् खः। ");
INSERT INTO new_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","व घाःखू न्‍यनामवंसें मना जक वयाः अन हे च्‍वनाः गनावना च्‍वंगु दुसा व मिं पुया जूगु घाःखू खः। पुजाहारीं व मनूयात शुद्ध थहरय् यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“सुं मिजं वा मिसाया छेनय् वा मन्‍चाय् ल्‍वय् दुसा, ");
INSERT INTO new_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","पुजाहारीं व ल्‍वय् जाँचय् यायेमाः अले व छेंगू गाः वंगु दुसा अले उकियागु सँ सालुगु म्‍हासुसे च्‍वंसा, वं वयात अशुद्ध थहरय् यायेमाः। थ्‍व छ्यं वा मन्‍चाय् दुगु अशुद्धगु चासुइगु ल्‍वय् खः। ");
INSERT INTO new_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","तर पुजाहारीं व चासुइगु ल्‍वय् जाँचय् याःबलय् व छेंगू स्‍वयाः गाः मवंसा अले उकी हाकुगु सँ नं मदुसा, वं ल्‍वगियात न्‍हय्‌न्‍हु तक अलग तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","न्‍हय्‌न्‍हु दुखुन्‍हु पुजाहारीं व ल्‍वय्‌यात जाँचय् यायेमाः अले व चासुइगु ल्‍वय् न्‍यनावंगु मदुसा, उकी सँ म्‍हासुसे मच्‍वंसा, अले व चासुइगु ल्‍वय् स्‍वइबलय् छेंगू स्‍वयाः गाः वंगु खने मदुसा, ");
INSERT INTO new_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","पुजाहारीं व चासुइगु ल्‍वय् दुगु थाय् त्‍वःताः थःगु सँ व दाह्री खायेमाः। वयात हानं न्‍हय्‌न्‍हु तक अलग तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","न्‍हय्‌न्‍हु दुखुन्‍हु पुजाहारीं हानं जाँचय् यायेमाः। व चासुइगु ल्‍वय् न्‍यनामवंसें छेंगू स्‍वयाः गाः वंगु खने मदुसा पुजाहारीं वयात शुद्ध थहरय् यायेमाः। अले वं थःगु वसः हियाः शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","तर व शुद्ध थहरय् जुइ धुंकाः नं व चासुइगु ल्‍वय् छेंगुलि न्‍यनावन धाःसा ");
INSERT INTO new_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","पुजाहारीं वयात हानं जाँचय् यायेमाः। व चासुकइ छेंगुलिइ न्‍यनावंगु दुसा पुजाहारीं सँ म्‍हासुसे च्‍वं ला मच्‍वं धकाः जाँचय् याये म्‍वाः। छाय्‌धाःसा व मनू अशुद्धम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","तर पुजाहारीं जाँचय् यानाः स्‍वःबलय् व चासुइगु ल्‍वय् दुगु थाय् न्‍हापा गथे खः अथे हे जू, व उकी हाकुगु सँ बुयावःसा, व ल्‍वचं लाःगु खः। अले पुजाहारीं वयात शुद्ध थहरय् यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“सुं मिजं वा मिसायागु छेंगुलिइ तुयुसे च्‍वंगु चातः दःसा ");
INSERT INTO new_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","पुजाहारीं व जाँचय् यायेमाः अले वयागु म्‍हय् व चातः भतिचा जक तुयुसे च्‍वंसा व छेंगुलिइ पिहां वःगु दाग जक खः, व मनू शुद्धम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“सुं मनूयागु सँ हायावंगु दुसा व खउ छ्यंयाम्‍ह ला खः तर व शुद्धम्‍ह हे खः। ");
INSERT INTO new_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","वयागु छ्यंयागु न्‍ह्यःनेपाखें जक सँ मदयाः पाचुसे च्‍वंसा व शुद्धम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","तर वयागु छ्यंयागु न्‍ह्यःनेपाखें वा लिछ्यंपाखें सँ मदयाः पाचुसे च्‍वंगु थासय् ह्याउँगु ह्याउँगु वा तुयुसे च्‍वंगु घाः खने दया वःसा व पुनेयःगु ल्‍वय् खः। ");
INSERT INTO new_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","पुनेयःगु ल्‍वय् वइबलय् थें पुजाहारीं वयात जाँचय् यानाः स्‍वइबलय् सँ मदया पाचुसे च्‍वंगु थासय् मनावयाः ह्याउँसे ह्याउँसे च्‍वंगु तुयुगु घाः खनेदःसा ");
INSERT INTO new_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","व मनू ल्‍वगि व अशुद्धम्‍ह खः। वयागु छेनय् दुगु घाःया हुनिं पुजाहारीं वयात अशुद्ध थहरय् याइ। ");
INSERT INTO new_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“पुनेयःगु ल्‍वय् दुम्‍ह मनुखं खुनातःगु वसः फीमाः, अले वयागु छ्यंयागु सँ भुलुसुलु दंका तयेमाः। वं थःगु म्‍हुतु त्‍वपुयाः तःसलं ‘अशुद्ध! अशुद्ध! अशुद्ध!’ धकाः हालेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","गुबलय् वयात ल्‍वचं काइ उबलय् तक व अशुद्ध हे जुइ। व याकःचा हे च्‍वनेमाः। व छाउनी पिने हे च्‍वनेमाः।” ");
INSERT INTO new_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","49","“वसतय्, ऊनय् वा सुतिइ, अले सूती कापः वा ऊनयागगु, छेंगू वा छेंगुलिं दय्‌कूगु, न्‍ह्यागु हे वस्‍तुइ फ्‍वसा वयाः वाउँसे वा ह्याउँसे च्‍वंगु खनेदःसा पुजाहारीयात क्‍यनेमाः। छाय्‌धाःसा थ्‍व फ्‍वसां अशुद्ध जूगु खः। ");
INSERT INTO new_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","पुजाहारीं उकियात जाँचय् यायेमाः अले उकियात न्‍हय्‌न्‍हु तक अलग तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","उकियात न्‍हय्‌न्‍हु दुखुन्‍हु हानं जाँचय् यायेमाः, थानातःगु कापः वा छेंगुलिं दय्‌कूगु वस्‍तुइ नं व फ्‍वसा न्‍यनावंगु दुसा व ग्‍यानापुगु फ्‍वसा खः व चिज अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","अथे जुयाः व फ्‍वसा वःगु वसः थानातःगु ऊन, सुति वा छेंगूया न्‍ह्यागुयागु जूसां पुजाहारीं उकियात छ्वय्‌का छ्वयेमाः। छाय्‌धाःसा व ध्‍वग्‍गिगु फ्‍वसा खः। उकियात मिइ छ्वय्‌का छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“तर पुजाहारीं स्‍वइबलय् व फ्‍वसा वसः थानातःगु कापः वा छेंगूयागु वस्‍तुइ न्‍यनावंगु मदुसा ");
INSERT INTO new_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","व फ्‍वसा वःगु वस्‍तु हीमाः धकाः पुजाहारीं उजं बीमाः। अले हाकनं न्‍हय्‌न्‍हु तक उकियात अलग तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","फ्‍वसा वःगु वस्‍तुयात ही धुंकाः पुजाहारीं उकियात हानं स्‍वयेमाः। फ्‍वसा न्‍हापा थें हे खनेदःसा व न्‍यना मवंसां व अशुद्ध खः। व फ्वसा चाहे दुनेपाखें जुइमा वा पिनेपाखें जुइमा, छं उकियात मिं छ्वयेकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","व ही धुंकाः पुजाहारीं जाँचय् याइबलय् फ्‍वसा तना वनाच्‍वंगु दुसा व सुयातःगु वसः वा थानातःगु न्‍ह्यागुयागु कापः वा छेंगुलिं पुजाहारीं फ्‍वसा वःगु ब्‍व जक खुनाः छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","व फ्‍वसा हाकनं थानातःगु कापः वा सुयातःगु वसः वा छेंगूयागु हे वस्‍तुइ हानं खनेदत धाःसा व न्‍यनावंगु खः। व फ्‍वसा वःगु वस्‍तुयात मिं छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","तर थानातःगु वा सुयातःगु न्‍ह्यागु हे वस्‍तु जूसां ही धुंकाः उकी फ्‍वसा मवःसा उकियात हानं हीमाः अले व शुद्ध जुइ।” ");
INSERT INTO new_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","थानातःगु वा सुयातःगु वसः व ऊनया सुतिया वा छेंगूयागु न्‍ह्यागुयागु जूसां फ्‍वसा वइबलय् शुद्ध अशुद्ध धकाः क्‍वःछियेगु विधि थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“छेंगूया पुनेयःगु ल्‍वचं कःम्‍ह मनूयात शुद्ध यायेगु इलय् वयात पुजाहारीयाथाय् हइबलय् यायेमाःगु विधि थथे खः। थःगु ल्‍वय् लने धुंकू थें च्‍वंसा ");
INSERT INTO new_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","पुजाहारीयात छाउनीं पिने सःताः जाँचय् याकेगु। छेंगूया व पुनेयःगु ल्‍वय् लन धाःसा, ");
INSERT INTO new_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","पुजाहारीं निम्‍ह शुद्धपिं झंगः, थाकुराःमाया कचा, ह्याउँगु का व हिसपमा हयेत उजं बीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","पुजाहारीं छम्‍ह झंगःयात ताजा लः दुगु चाया थलया च्‍वय् तयाः स्‍यायेत उजं बीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","अले वं मेम्‍ह झंगः, थाकुराःमाया कचा, ह्याउँगु का व हिसपमा कयाः ताजा लःया च्‍वय् स्‍याःम्‍ह झंगःया हिइ थुनेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","वं न्‍हय्‌कः तक ल्‍वगिम्‍ह मनूयात उकिं हाः हाः यानाः शुद्ध थहरय् यायेमाः अले ल्‍यंम्‍ह झंगःयात चकंगु ख्‍यलय् त्‍वःताबीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“ल्‍वगिं थःगु वसः हियाः म्‍हय् च्‍वंगु फुक्‍क सँ खानाः म्‍वःल्‍हुइमाः। अले तिनि व धात्‍थें शुद्ध जुइ, अले छाउनीइ दुहां वने खनी। अय्‌जूसां न्‍हय्‌न्‍हु तक धाःसा व थःगु पालं पिने हे च्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","न्‍हय्‌न्‍हु दुखुन्‍हु वं हाकनं थःगु छेनय् च्‍वंगु सँ, दाह्रि, मिखाफुसि व म्‍हय् दक्‍व सँ खानाः, थःगु वसः हियाः म्‍वःल्‍हुइमाः। अले व धात्‍थें शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“च्‍यान्‍हु दुखुन्‍हु वं खू मदुपिं दच्‍छि दुपिं निम्‍ह चिधिकःपिं भ्‍याःचात व छम्‍ह मिसाम्‍ह चिधिकःम्‍ह फैचा, अन्‍नबलिया निंतिं जैतूनया चिकनय् बुलातःगु भिंगु छुचुं छगू एपाया झिब्‍वय् स्‍वब्‍व व छगू लिटरया स्‍वब्‍वय् छब्‍व चिकं हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","पुजाहारीं नापलायेगु पालया ध्‍वाखाय् परमप्रभुया न्‍ह्यःने ल्‍वगियात व वं हःगु फुक्‍क ज्‍वलं यंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“पुजाहारीं चिधिकःम्‍ह भ्‍याःचा छम्‍ह व १/३ लिटर चिकं कयाः दोषबलिकथं छायेमाः। वं संकाबीगु बलिकथं परमप्रभुया न्‍ह्यःने उकियात छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","अले वं पापबलि व होमबलि स्‍याइगु पवित्र इलाकाय् चिधिकःम्‍ह भ्‍याःचायात स्‍यायेमाः। छाय्‌धाःसा पापबलि पुजाहारीया जू थें दोषबलि नं वयागु हे जुइ। अले व तसकं पवित्र खः। ");
INSERT INTO new_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","अले पुजाहारीं दोषबलिया हि भचा कयाः ल्‍वगिया जव न्‍हाय्‌पंया फ्‍वः, जव ल्‍हाःया बुरापतिं व जव तुतिया बुरापतिनय् तिकाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","पुजाहारीं उगु १/३ लिटर मध्‍ये भचा चिकं कयाः थःगु खव ल्‍हाःपाय् तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","अले पुजाहारीं थःगु जव च्‍वलापतिं उकी थुनाः न्‍हय्‌कः तक परमप्रभुया न्‍ह्यःने हाः हाः यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","थःगु ल्‍हाःपाय् ल्‍यंगु चिकं भचा पुजाहारीं ल्‍वगिया जव न्‍हाय्‌पंया फ्‍वलय्, जव ल्‍हाःया बुरापतिं व जव तुतिया बुरापतिनय् दोषबलिया हिया द्यःने तिकाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","अले थःगु ल्‍हाःपाय् ल्‍यं दुगु चिकं फुक्‍क पुजाहारीं ल्‍वगिया छेनय् तयाबीमाः। अले परमप्रभुया न्‍ह्यःने वयागु निंतिं प्रायश्‍चित यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“अले पुजाहारीं पापबलि छायाः ल्‍वगियागु निंतिं प्रायश्‍चित यायेमाः। अनं लिपा वं होमबलि स्‍यानाः ");
INSERT INTO new_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","पुजाहारीं अन्‍नबलि नापं वेदीइ छायेमाः। अले ल्‍वगियागु निंतिं प्रायश्‍चित यायेमाः। थुकथं व शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“छुं जुयाः व उलिमछि छाये मफुम्‍ह जूसा वं थःगु प्रायश्‍चित याकेत, दोषबलिया निंतिं संकेत छम्‍ह जक चिधिकःम्‍ह भ्‍याःचा व अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् छब्‍व भिंगु छुचुं व छगू लिटरया स्‍वब्‍वय् छब्‍व चिकं, ");
INSERT INTO new_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","पापबलि व होमबलियात छम्‍ह छम्‍ह यानाः सुकुभत्तु जूसां बखुंचा जूसां निम्‍ह हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“च्‍यान्‍हु खुन्‍हु ल्‍वगिं थः शुद्ध जुइत नापलायेगु पालया ध्‍वाखाय् परमप्रभुया न्‍ह्यःने पुजाहारीयाथाय् थुपिं फुक्‍क हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","पुजाहारीं दोषबलियाम्‍ह चिधिकःम्‍ह भ्‍याःचा छम्‍ह व चिकं कयाः संकाबीगु बलिकथं परमप्रभुया न्‍ह्यःने देछायेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","पुजाहारीं चिधिकःम्‍ह भ्‍याःचायात दोषबलिया निंतिं स्‍यानाः दोषबलिया हि भचा कयाः ल्‍वगिया जव न्‍हाय्‌पंया फ्‍वः, जव ल्‍हाःया बुरापतिं व जव तुतिया बुरापतिनय् तिकाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","पुजाहारीं भचा चिकं कयाः थःगु खव ल्‍हाःपाय् तइ, ");
INSERT INTO new_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","अले पुजाहारीं थःगु जव च्‍वलापतिं उकी थुनाः न्‍हय्‌कः तक परमप्रभुया न्‍ह्यःने हाः यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","थःगु ल्‍हाःपाय् दुगु चिकं छुं भचा कयाः पुजाहारीं ल्‍वगिया जव न्‍हाय्‌पंया फ्‍वलय्, जव ल्‍हाःया बुरापतिं व जव तुतिया बुरापतिनय् दोषबलिया हिया द्यःने तिकाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","अले थःगु ल्‍हाःपाय् ल्‍यं दुगु चिकं फुक्‍क पुजाहारीं ल्‍वगिया छेनय् तयाबीमाः। अले परमप्रभुया न्‍ह्यःने वयागु निंतिं प्रायश्‍चित यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","अनंलि वं फु थें निम्‍ह सुकुभत्तुत वा निम्‍ह बखुंत, ");
INSERT INTO new_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","छम्‍ह पापबलिया निंतिं छम्‍ह होमबलिया निंतिं पुजाहारीं अन्‍नबलि नापं छायेमाः। थुकथं पुजाहारीं ल्‍वगिया निंतिं परमप्रभुया न्‍ह्यःने प्रायश्‍चित यायेमाः।” ");
INSERT INTO new_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","छेंगूया पुनेयःगु ल्‍वचं काःपिं ल्‍वगितय्‌सं व मगाःमचाःपिं ल्‍वगितय्‌सं थःम्‍हं फु थें शुद्ध जुइत यायेमाःगु विधि थथे हे खः। ");
INSERT INTO new_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“जिं छिमित सम्‍पत्तिकथं बीत्‍यनागु कनान देशय् छिपिं च्‍वंवने धुंकाः अन च्‍वंगु सुयागुं छेँय् जिं खाःचिलुइकाबिल धाःसा ");
INSERT INTO new_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","व छेँया थुवालं वनाः पुजाहारीयात थथे धायेमाः, ‘जिं जिगु छेँय् खाःचि थें छुं खनागु दु।’ ");
INSERT INTO new_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","पुजाहारीं छेँ स्‍वःवने न्‍ह्यः छेँ खालि यायेत उजं बीमाः। उबलय् तक छेँय् च्‍वंगु छुं नं वस्‍तु अशुद्ध जुइ मखु। अनंलि पुजाहारी छेँ स्‍वयेत वनेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","वं छेँय् खाःचिलूगु जाँच यायेमाः। छेँया अंगलय् वाउँक वा ह्याउँक अंगः स्‍वयाः गाःवंक खाःचिलुयाच्‍वंगु दुसा ");
INSERT INTO new_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","पुजाहारीं छेँनं पिहां वनाः न्‍हय्‌न्‍हु तक छेँय् तालं ग्‍वयाः तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","न्‍हय्‌न्‍हु दुखुन्‍हु वयाः पुजाहारीं हानं स्‍वयेमाः। छेँया अंगलय् च्‍वंगु खाःचि मेथाय् नं न्‍यनावनाच्‍वंगु दुसा ");
INSERT INTO new_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","पुजाहारीं खाःचिलुयाच्‍वंगु ल्‍वहंयात लिकयाः शहरं पिने विधिकथं अशुद्धगु थासय् वान्‍छ्‌वय्‌के छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","अले वं अंगः छपातिं खुर्के याकेबीमाः, खुर्के यानाः वःगु चा वं शहरं पिने अशुद्धगु थासय् वान्‍छ्‌वय्‌के छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","अनंलि वं अंगलय् न्‍हूगु ल्‍वहं हयाः तिनाबीमाः, अले हाकनं लेवं इलाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“अथे यानाः नं हाकनं खाःचिलुयावल धाःसा ");
INSERT INTO new_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","पुजाहारीं वनाः उकियात स्‍वयेमाः। अले खाःचि छेँय् न्‍यनावंगु दुसाः व छगू छगू नाश याइगु अशुद्धगु खाःचि खः। अले व छेँ अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","व छेँयात थुनाछ्वयेमाः, अर्थात थुकिया ल्‍वहं, सिँ, व चा फुक्‍कं थुना शहरं पिने अशुद्धगु थासय् वांछ्वये यंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“थ्‍व छेँ तिनातःबलय् सुं नं दुहां वन धाःसा सन्‍ध्‍याः ईतक व मनू अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","सुं नं थ्‍व छेँया दुने वनाः द्यन वा नल धाःसा वं थःगु वसः हीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“पुजाहारीं हाकनं छेँयात स्‍वःवइबलय् लेवं तये धुंकूबलय्‌निसें अशुद्धगु खाःचि खने मदयाच्‍वंसा व छेँयात वं शुद्ध भाःपीमाः। छाय्‌धाःसा आः खाःचि मदये धुंकल। ");
INSERT INTO new_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","अले छेँ शुद्ध यायेत पुजाहारीं निम्‍ह शुद्धपिं झंगः, थाकुराःमाया कचा, ह्याउँगु का व हिसपमा हयेत धाइ। ");
INSERT INTO new_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","पुजाहारीं छम्‍ह झंगःयात ताजा लः दुगु चाया थलया च्‍वय् तयाः स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","अले वं मेम्‍ह झंगः, स्‍वसिमामाया कचा, हिसपमा व ह्याउँगु का कयाः स्‍याःम्‍ह झंगःया हि व ताजा लखय् थुनाः न्‍हय्‌कः तक खाःचिलूगु छेँयात उकिं हाः यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","थुकथं वं झंगःया हि, ताजा लः, बलि मब्‍यूम्‍ह झंगः, स्‍वसिमामाया कचा, हिसपमा व ह्याउँगु का कयाः छेँ शुद्ध यानाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","अनंलि वं मस्‍याःम्‍ह झंगःयात शहरं पिने चकंगु ख्‍यलय् त्‍वःताबीमाः। थुकथं वं व छेँया निंतिं प्रायश्‍चित यायेमाः, अले व छेँ शुद्ध जुइ।” ");
INSERT INTO new_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","छेंगूया फुक्‍क कथंया पुनेयःगु ल्‍वय्, चासुल्‍वय्, ");
INSERT INTO new_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","छेँय् लुइगु खाःचि, वसतय् वइगु फ्‍वसा, ");
INSERT INTO new_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","मनावइगु, कै व दुबि ");
INSERT INTO new_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","शुद्ध खः ला कि अशुद्ध खः धकाः सीकेगु विधि थ्‍व हे खः। छेंगूया पुनेयःगु ल्‍वय् व फ्‍वसा वःगुपाखें शुद्ध जुइगु थुकथं खः। ");
INSERT INTO new_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“इस्राएलीतय्‌त धा, ‘सुं नं मिजंयात धातुया ल्‍वय् जुल धाःसा, व धातुया ल्‍वय्‌या हुनिं व मनू अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","वयागु म्‍हं धातु बाः वयाच्‍वंसा द्यूसां उकिं व मनूयात अशुद्ध याइ। ");
INSERT INTO new_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“‘धातुया ल्‍वय् दुम्‍ह मनू द्यंगु लासा व च्‍वंगु थाय् अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","सुनां वयागु लासा थी, वं थःगु वसः हीमाः, अले थःम्‍हं नं म्‍वःल्‍हुइमाः। सन्‍ध्‍याकाः ईतक व मनू अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","धातुया ल्‍वय् जूम्‍ह मनू च्‍वंगु थासय् च्‍वंम्‍ह मनुखं थःगु वसः हीमाः, अले म्‍वःल्‍हुइमाः। सन्‍ध्‍याकाः ईतक व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“‘सुनां धातुया ल्‍वय् दुम्‍ह मनूयात थी, वं थःगु वसः हीमाः, अले थःम्‍हं नं म्‍वःल्‍हुइमाः, सन्‍ध्‍याकाः ईतक व नं अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“‘धातुया ल्‍वय् दुम्‍ह मनुखं शुद्धम्‍ह मनूयात थुकलं बिल धाःसा वं थःगु वसः हीमाः, अले थःम्‍हं नं म्‍वःल्‍हुइमाः। सन्‍ध्‍याकाः ईतक व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“‘व सल गइबलय् फ्‍यतुइगु फुक्‍क अले व च्‍वंगु थाय् नं अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","सुनां वया तःलय् लाःगु वस्‍तु थी, व सन्‍ध्‍याकाः ईतक अशुद्ध जुइ। सुनां अज्‍याःगु वस्‍तु ल्‍ह्वनाः काइ, वं थःगु वसः हीमाः, अले थःम्‍हं नं म्‍वःल्‍हुइमाः। सन्‍ध्‍याकाः ईतक व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“‘धातुया ल्‍वय् दुम्‍ह मनुखं थःगु ल्‍हाः मस्‍युसे सुयातं थिल धाःसा व मनुखं थःगु वसः हीमाः, थःम्‍हं नं म्‍वःल्‍हुइमाः, अले व सन्‍ध्‍याकाः ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“‘व ल्‍वगिम्‍ह मनुखं चाया थल थिल धाःसा, थ्‍यूगु चाया थल तछ्याना छ्वयेमाः, सिँया थल जक लखं सिलाछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“‘धातुया ल्‍वय् दुम्‍ह मनुखं थःगु ल्‍वय् लाये धुंकाः न्‍हय्‌न्‍हु तक पीमाः। न्‍हय्‌न्‍हुया दुने वं थःगु वसः हीमाः, नीलखं म्‍वःल्‍हुइमाः। अले व शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","च्‍यान्‍हु खुन्‍हु वं निम्‍ह सुकुभत्तु वा बखुंया निम्‍ह मचा नापलायेगु पालया ध्‍वाखाय् परमप्रभुया न्‍ह्यःने यंकाः पुजाहारीयात बीमाः। ");
INSERT INTO new_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","पुजाहारीं छम्‍ह शुद्ध जुइगु बलि निंतिं व छम्‍ह होमबलिया निंतिं छायेमाः। थुकथं पुजाहारीं परमप्रभुया न्‍ह्यःने वयागु ल्‍वय्‌या निंतिं प्रायश्‍चित यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“‘सुं मिजंया वीर्य कुतुंवल धाःसा वं म्‍ह छम्‍हं म्‍वःल्‍हुइमाः। अले सन्‍ध्‍याकाः ईतक व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","वीर्य लाःगु वसः वा छेंगू नं लखं सिलाछ्वयेमाः, अले सन्‍ध्‍याकाः ईतक व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","सुं मिजं मिसालिसे द्यनीबलय् वीर्य लात धाःसा इपिं निम्‍हय्‌सिनं नं म्‍वःल्‍हुइमाः, अले इपिं सन्‍ध्‍याकाः ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“‘सुं मिसा थीमत्‍यः जुइबलय् व न्‍हय्‌न्‍हु तक अशुद्ध जुइ। सुनानं वयात थिल धाःसा सन्‍ध्‍याकाः ईतक व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“‘व द्यंगु थाय् व फ्‍यतूगु फुक्‍क थाय् अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","सुनां वयागु लासा थी, वं थःगु वसः हीमाः, थःम्‍हं नं म्‍वःल्‍हुइमाः, अले व सन्‍ध्‍याकाः ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","सुनां व च्‍वंगु वस्‍तु थी, वं थःगु वसः हीमाः, थःम्‍हं नं म्‍वःल्‍हुइमाः, अले सन्‍ध्‍याकाः ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","सुनानं व द्यंगु लासा वा व च्‍वंगु वस्‍तु थिल धाःसा व सन्‍ध्‍याकाः ईतक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“‘सुं नं मिजं व नापं द्यन धाःसा न्‍हय्‌न्‍हु तक व मिजं अशुद्ध जुइ। अले व द्यंगु लासा नं अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“‘सुं मिसाया थीमत्‍यः जुइगु ई बाहेक तःन्‍हु तक हि बावयाः च्‍वन धाःसा अले थीमत्‍यः जूगु ई स्‍वयाः यक्‍व दिं हि बाः वल धाःसा हि बाः वयाच्‍वंतले व थीमत्‍यः जुइबलय् थें हे अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","अले थीमत्‍यः जुइबलय् थें हे व द्यंगु लासा अले व फ्‍यतूगु थाय् हि खने दुबलय् तक हे अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","सुनां थुपिं वस्‍तुयात थी व अशुद्ध जुइ। वं थःगु वसः हीमाः, अले थःम्‍हं नं म्‍वःल्‍हुइमाः। सन्‍ध्‍याकाः ईतक व अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“‘हि खनेमदये धुंकाः न्‍हय्‌न्‍हु तक व मिसां पीमाः। अनंलि तिनि व शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","च्‍यान्‍हु खुन्‍हु वं निम्‍ह सुकुभत्तु वा बखुंया निम्‍ह मचा नापलायेगु पालया ध्‍वाखाय् परमप्रभुया न्‍ह्यःने यंकाः पुजाहारीयात बीमाः। ");
INSERT INTO new_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","पुजाहारीं छम्‍ह पापबलिया निंतिं व छम्‍ह होमबलिया निंतिं छायेमाः। थुकथं पुजाहारीं परमप्रभुया न्‍ह्यःने वयागु हि बावःगुया निंतिं प्रायश्‍चित यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“‘थुकथं छिमिसं इस्राएलीतय्‌त अशुद्ध याइगु खँपाखें अलग तयेमाः। मखुसा इमिसं थःपिन्‍थाय् च्‍वंगु जिगु पवित्र पालयात अशुद्ध याइ। अले इपिं थःपिनिगु अशुद्ध खँया हुनिं सी माली।’” ");
INSERT INTO new_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","धातुया ल्‍वय् दुपिं व वीर्य कुतुं वइपिं मिजंतय्‌गु विधि थ्‍व हे खः, ");
INSERT INTO new_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","अले थीमत्‍यः जुयाच्‍वंम्‍ह मिसा वा थीमत्‍यः जूगु बाहेक मेबलय् हिबा वयाच्‍वंम्‍ह मिसा, धातु ल्‍वय् दुम्‍ह मिजं, अले थीमत्‍यः जूम्‍ह मिसालिसे द्यनीम्‍ह मिजंलिसे गुकथं व्‍यवहार यायेमाः धयागु खँया विधि थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","हारूनया निम्‍ह काय्‌पिं परमप्रभुया न्‍ह्यःने वनाः सी धुंकाः परमप्रभुं मोशालिसें खँ ल्‍हानादिल। ");
INSERT INTO new_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","परमप्रभुं मोशायात धयादिल, “छिमि दाजु हारूनयात बाचा चिनादीगु सनूया द्यःने च्‍वंगु प्रायश्‍चितया कृपा-आसनया न्‍ह्यःने पर्दा दुने च्‍वंगु महा-पवित्र थासय् मंदुबलय् वये मते धा। मखुसा व सी। छाय्‌धाःसा जि अन सनूया च्‍वय् सुपाँचय् खनेदय्‌कः वयेगु खः। ");
INSERT INTO new_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“हारून महा-पवित्र थासय् दुहां वने न्‍ह्यः वं थुपिं उजं पालन यायेमाः, वं पापबलिया निंतिं छम्‍ह द्वहंचा व होमबलिया निंतिं छम्‍ह भ्‍याःचा हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","अले वं म्‍ह छम्‍हं म्‍वःल्‍हुयाः सूती कापःया लंसुर्वाः फिनाः, तुयुगु विशेष कापःया हे दुवसः, सूती कापःया जनी चिनाः सूती कापःया बेतालि पुयाः वयेमाः। थ्‍व पवित्र वसः खः। ");
INSERT INTO new_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","अले हारूनं इस्राएलीतय् खलःपाखें वयात पापबलिया निंतिं निम्‍ह दुगुचा व होमबलिया निंतिं भ्‍याःचा छम्‍ह हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“अनंलि हारूनं थःगु पापबलिया द्वहं छायेमाः अले थःगु व थः छेँजःया निंतिं प्रायश्‍चित यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","अले वं व निम्‍हं दुगुचा यंकाः नापलायेगु पालया ध्‍वाखाय् परमप्रभुया न्‍ह्यःने तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","अनं लिपा वं निम्‍ह दुगुचाय् गुम्‍ह परमप्रभुया निंतिं बलि बीगु अले गुम्‍ह त्‍वःताछ्वयेगु धकाः चिट्ठा तयेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","परमप्रभुया निंतिं लाःम्‍ह दुगुचायात हयाः हारूनं पापबलिकथं परमप्रभुयात छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","त्‍वःताछ्वयेगुलिइ लाःम्‍ह दुगुचायात म्‍वाःम्‍वाकं परमप्रभुया न्‍ह्यःने हयेमाः। अले मनूतय्‌गु पापया प्रायश्‍चितया निंतिं वयात मरुभूमिइ त्‍वःतेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“हारूनं थःगु व थःगु छेँजःया प्रायश्‍चितया निंतिं पापबलिया द्वहं हयेमाः। थःगु पापबलिया द्वहंयात स्‍याये धुंकाः ");
INSERT INTO new_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","वं परमप्रभुया न्‍ह्यःने च्‍वंगु वेदीं जायेक मि च्‍याकातःगु मकः व निपा ल्‍हातिं जायेक नस्‍वाः वःगु विशेष धुपाँय्‌चुं कयाः महा-पवित्र थासय् दुने यंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","वं परमप्रभुया न्‍ह्यःने मिइ धुपाँय्‌चुं तयेमाः। थुकिया कुं साक्षीया सनूया च्‍वय्‌च्‍वंगु प्रायश्‍चितया कृपा-आसनयात त्‍वपुइमाः, मखुसा व सी। ");
INSERT INTO new_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","अनंलि वं द्वहंया हि भतिचा कयाः थःगु पतिंचां प्रायश्‍चितया कृपा-आसनया पुर्बपाखे हाः हाः यायेमाः। प्रायश्‍चितया कृपा-आसनया न्‍ह्यःने न्‍हय्‌कः तक पतिंचां व हि छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“अले वं मनूतय्‌गु पापबलिया निंतिं दुगुयात स्‍यायेमाः। उकिया हि भचा कयाः महा-पवित्र थासय् यंकाः द्वहंया हि हाः याः थें प्रायश्‍चितया कृपा-आसनया च्‍वय् व न्‍ह्यःने छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","थुकथं वं इस्राएलीतय्‌गु पाप व अशुद्ध ज्‍याखँपाखें तच्‍वकं महा-पवित्रगु थाय्‌यात शुद्ध यायेत प्रायश्‍चित यायेमाः। अथे हे वं पवित्र पालया निंतिं नं अथे हे यायेमाः, छाय्‌धाःसा थ्‍व छाउनी इमिगु अशुद्धताया दथुइ दु। ");
INSERT INTO new_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","हारून प्रायश्‍चित यायेत महा-पवित्र थासय् दुहां वनाः थःगु, थःगु छेँजःया निंतिं व फुक्‍क इस्राएलीतय्‌गु निंतिं प्रायश्‍चित यानाः पिहां मवतले पवित्र पालय् सुं नं च्‍वने दइ मखु। ");
INSERT INTO new_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“अले वं पिहां वयाः परमप्रभुया न्‍ह्यःने च्‍वंगु वेदीया लागिं प्रायश्‍चित यायेमाः। वं द्वहंया हि व दुगुचाया हि भतिभति कयाः वेदीया प्‍यखेरं च्‍वंगु नेकुलिइ तिकाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","छुं भचा हि वं थःगु पतिंचां न्‍हय्‌कः तक उकी च्‍वय् हाः यानाः इस्राएलीतय्‌गु अशुद्ध ज्‍याखँपाखें वेदीयात शुद्ध व पवित्र यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“हारूनं महा-पवित्र थाय्, पवित्र पाल व वेदीया निंतिं प्रायश्‍चित याये धुंकाः ल्‍यंम्‍ह दुगुचा हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","अले हारूनं थःगु निपा ल्‍हाः दुगुचिया छेनय् तयाः इस्राएलीतय्‌गु फुक्‍क मभिंगु ज्‍या, पाप व अपराधयात नालाः व फुक्‍क दुगुचिया छेनय् चीकेमाः। अनंलि व दुगुचित मरुभूमिइ यंकीम्‍ह मनूयात बियाछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","थुकथं व दुगुचां इमिगु फुक्‍क पाप क्‍वबियायंकी। व मनुखं वयात मरुभूमिइ त्‍वःताबीमाः। ");
INSERT INTO new_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“अनंलि हारूनं पवित्र पाल दुने वनाः महा-पवित्र थासय् वने न्‍ह्यः पुंगु तुयुगु विशेष कापःया वसः त्‍वयाः अन हे त्‍वःताथकेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","अले पवित्र इलाकाय् हे म्‍वःल्‍हुयाः थःगु पुजाहारीया वसः पुनेमाः। अले अनं पिहां वयाः थःगु व मनूतय्‌गु निंतिं होमबलि छानाः प्रायश्‍चित यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","वं पापबलिया दाः नं वेदीइ छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“मरुभूमिइ दुगुचा त्‍वःतःवंम्‍ह मनुखं थःगु वसः हियाः म्‍वःल्‍हुइमाः। अले व छाउनीइ लिहां वये फइ। ");
INSERT INTO new_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","हिपाखें प्रायश्‍चित यायेत महा-पवित्रगु थासय् हःगु पापबलिया द्वहं व दुगुयात छाउनीं पिने यंकाः इमिगु छेंगू, ला व आतापुति मिइ छ्वयेका छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","छ्वयेकूम्‍ह मनुखं थःगु वसः हियाः म्‍वःल्‍हुइमाः, अले व छाउनीइ लिहां वने फइ। ");
INSERT INTO new_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“थ्‍व छिमिगु निंतिं न्‍ह्याबलेंया नियम खः। दँय्‌दसं न्‍हय्‌गूगु लाया झिन्‍हु खुन्‍हु छिमिसं छुं नये मते। अले छुं ज्‍या मयासें च्‍वनेमाः। थथे छिपिंनापं दुपिं पिनेयापिं मनूतय्‌सं नं यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","छाय्‌धाःसा उखुन्‍हु हे छिमित शुद्ध यायेत छिमिगु निंतिं प्रायश्‍चित याइ। अले परमप्रभुया न्‍ह्यःने छिमिगु फुक्‍क पापपाखें छिपिं शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","थ्‍व छिमिगु निंतिं झासु लनेगु विश्रामबार खः। थ्‍वखुन्‍हु छिमिसं छुं मनसें, छुं नं ज्‍या मयासें च्‍वनेमाः। थ्‍व छिमिगु निंतिं न्‍ह्याबलेंया नियम खः। ");
INSERT INTO new_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","अभिषेक जूम्‍ह व बौया पलेसा दकलय् तःधंम्‍ह पुजाहारी जूम्‍ह पुजाहारीं हे प्रायश्‍चित यायेगु ज्‍या यायेमाः, अले पवित्र तुयुगु विशेष कापःया वसः पुनाः यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","वं थ्‍व प्रायश्‍चित महा-पवित्र थाय्, पवित्र पाल, वेदी, पुजाहारीत व फुक्‍क इस्राएलीतय्‌गु निंतिं यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“छिमिसं आवंलि दँय् छकः न्‍ह्याबलें इस्राएलीतय्‌त इमिगु पापं शुद्ध यायेत थुकथं प्रायश्‍चित यायेगु थ्‍व छिमिगु लागिं न्‍ह्याबलेंया नियम खः।” अले परमप्रभुं मोशायात धयादी थें अथे हे यात। ");
INSERT INTO new_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“परमप्रभुं थ्‍व उजं बियादीगु दु धकाः हारून, वया काय्‌पिं अले सकलें इस्राएलीतय्‌त धा, ");
INSERT INTO new_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","‘इस्राएलीत मध्‍ये सुनानं सा वा द्वहं, चिधिकःम्‍ह भ्‍याःचा वा दुगुचापाखें जिगु निंतिं बलि बीबलय् नापलायेगु पालया ध्‍वाखाय् महःसें अन बाहेक मेगु गुगुं थासय् बलि बिल धाःसा वं परमप्रभुया नियम त्‍वःथुगु जुइ, वं हिबाः वय्‌कूगु थें खः। वयात थः मनूतपाखें पितिना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","इस्राएलीतय्‌सं खुल्‍लागु थासय् बियावयाच्‍वंगु बलि आवंलि नापलायेगु पालया ध्‍वाखाय् पुजाहारीतय्‌थाय् परमप्रभुया लागि हयाः वय्‌कःया लागि मेलबलिकथं छायेमाः धकाः थ्‍व आज्ञा ब्‍यूगु खः। ");
INSERT INTO new_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","पुजाहारीं व हि नापलायेगु पालया ध्‍वाखाय् परमप्रभुया वेदीइ छ्वाकेमाः, दाः धाःसा परमप्रभुया निंतिं नस्‍वाः यायेत छ्वय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","इमिसं आवंलि दुगुया ख्‍वाः वःपिं द्यःतय्‌त पुजा यानाः थःत हे वेश्‍या मदय्‌केमाः धयागु आजुं थ्‍व विधि दय्‌कूगु खः। इमि पुस्‍तौं पुस्‍ताया निंतिं थ्‍व न्‍ह्याबलेंया नियम खः।’ ");
INSERT INTO new_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“अले छं इमित थथे धा, ‘इस्राएलीत व इपिं नापं च्‍वनाच्‍वंपिं परदेशीत मध्‍ये सुनानं होमबलि वा मेगु न्‍ह्यागुं बलि छायेबलय्, ");
INSERT INTO new_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","थ्‍व नापलायेगु पालया ध्‍वाखाय् जक छायेमाः। सु मनुखं थथे याइ मखु वयात थःगु पुचलं पितिना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“‘इस्राएलीत वा इपिं नापं च्‍वनाच्‍वंपिं परदेशीत मध्‍ये सुनानं हि नल धाःसा जिं व हि नइम्‍ह मनूयागु विरोध याये, अले वयात थः मनूतपाखें पितिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","छाय्‌धाःसा प्राणीतय्‌गु प्राण हिलय् दयाच्‍वनी अले जिं उकियात छिमित वेदीइ प्रायश्‍चित यायेत बियागु खः। छाय्‌धाःसा उकी प्राण दुगुलिं हिपाखें हे प्रायश्‍चित जुइ। ");
INSERT INTO new_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","अथे जुयाः जिं इस्राएलीतय्‌त धयागु दु, “छिपिं सुनानं हि नये मज्‍यू, अले छिपिंनापं च्‍वनाच्‍वंपिं सुं परदेशीं नं हि नये मज्‍यू।” ");
INSERT INTO new_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“‘अथे जूगुलिं सुं इस्राएली वा सुं परदेशीं शिकार म्‍हिताः नये ज्‍यूम्‍ह पशु वा झंगः ज्‍वन धाःसा दकलय् न्‍हापा वं वयागु फुक्‍क हि पिकयाः हिया द्यःने चा तयाः त्‍वपुयाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","छाय्‌धाःसा म्‍हयागु प्राण हिलय् दु। अथे जुयाः जिं इस्राएलीतय्‌त धयागु दु, “सुनानं प्राणीयागु हि नये मज्‍यू छाय्‌धाःसा फुक्‍कं प्राणीतय्‌गु प्राण इमिगु हि हे खः। सुनां उकियात नइ वयात पितिना छ्वयेमाः।” ");
INSERT INTO new_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“‘सुं इस्राएली वा परदेशी मनुखं सुं थःगु कालं स्‍यूम्‍ह वा जंगली पशुं स्‍याःम्‍ह पशुया ला नल धाःसा वं थःगु वसः हीमाः, लखं म्‍ह छम्‍हं म्‍वःल्‍हुइमाः अले सन्‍ध्‍याकाः ईतक व अशुद्ध जुइ। अनं लिपा व शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","वं वसः महिल धाःसा अले म्‍वः नं मल्‍हुल धाःसा वं याःगु पापया दोष वयात हे लाइ।’” ");
INSERT INTO new_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“इस्राएलीतय्‌त धा, ‘जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","छिपिं न्‍हापा च्‍वंच्‍वनागु मिश्र देशयापिं मनूतय्‌सं याइगु थें ज्‍या याये मते अले आः यंकेत्‍यनागु देश कनानयापिं मनूतय्‌सं याइगु थें ज्‍या नं याये मते इमिगु विधि नं मानय् याये मते। ");
INSERT INTO new_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","जि परमप्रभु छिमि परमेश्‍वर खः। छिमिसं जिगु नियम व विधित पालन यानाः वकथं न्‍ह्यज्‍याहुँ। ");
INSERT INTO new_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","छिमिसं जिगु थ्‍व विधि व नियम मानय् यायेमाः छाय्‌धाःसा व मानय् याःपिं मनूत उकिं हे म्‍वानाच्‍वनी। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“‘छिपिं सुनानं थः स्‍याःपिं थःथितित नापं लसपस याये मते जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“‘छं छिमि मां नाप लसपस यानाः थः बौयात लज्‍या चाय्‌के मज्‍यू। छाय्‌धाःसा व छिमि थः हे मां खः। ");
INSERT INTO new_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“‘छं थः बौया कलाः चिरिमांनाप लसपस याये मते। अथे यानाः छं थः बौयात लज्‍या चाय्‌के मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“‘छं थः हे मांबौपाखें बूम्‍ह तताकेहेँ अले थः मां वा बौया न्‍ह्यसु म्‍ह्याय्‌नापं लसपस याये मज्‍यू। व थःगु हे छेँ बूम्‍ह जुइमा वा पिने बुयाः तःधीम्‍ह जूसां अथे याये मते। ");
INSERT INTO new_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“‘छं थः काय्‌पाखें वा म्‍ह्याय्‌पाखें बूम्‍ह मिसामचानाप लसपस याये मते थथे यानाः छं थःत लज्‍या चाय्‌की। ");
INSERT INTO new_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“‘छं थः चिरिमांपाखें बूम्‍ह म्‍ह्याय् नाप लसपस याये मते व छिमि केहेँ खः। ");
INSERT INTO new_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“‘छं थः निनि नाप लसपस याये मते व छिमि बौया स्‍याःपिं खः। ");
INSERT INTO new_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“‘छं थः मांया तःकेहेँपिं नाप लसपस याये मते इपिं छिमि मांया स्‍याःलाःपिं खः। ");
INSERT INTO new_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“‘छं थः तःधिमां व मामा नापं लसपस याये मते। थः बौया दाजुकिजायात लज्‍या चाय्‌के मज्‍यू। व छिमि हे तःमां व मामा खः। ");
INSERT INTO new_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“‘छं थः भौनाप लसपस याये मते व छिमि काय्‌या कलाः खः। ");
INSERT INTO new_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“‘छं थः तताःजु वा किजा भौनाप लसपस यानाः थः दाजुकिजायात लज्‍या चाय्‌के मते। ");
INSERT INTO new_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“‘सुयां कलाः व वया म्‍ह्याय् निम्‍ह नापं छं लसपस याये मते अले वया काय् वा म्‍ह्याय् पाखेंया छय् म्‍ह्याय्‌मचा नापं नं लसपस याये मते इपिं थःथवय् हिया स्‍वापु दुपिं खः। अथे यायेगु लज्‍या चायापुगु ज्‍या खः। ");
INSERT INTO new_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“‘छं थः कलाः मसीतले वया तताः वा केहेँयात लिथु हयाः लसपस याये मते। ");
INSERT INTO new_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“‘सुं मिसाया थीमत्‍यः जुयाः अशुद्ध जुइबलय् छं व नाप लसपस याये मते। ");
INSERT INTO new_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“‘छं मेपिनि कलाःनापं लसपस याये मते छं अथे यानाः थःत अशुद्ध याये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“‘थः काय्‌म्‍ह्याय् मोलेक द्यःया निंतिं मिइ छानाः थः परमेश्‍वरया नां अशुद्ध याये मते। जि हे परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“‘छं मिस्‍तनापं थें मिजंतनाप लसपस याये मते। व घचाइपुगु ज्‍या खः। ");
INSERT INTO new_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“‘छुं नं जातिया पशुप्राणी नाप लसपस यानाः छं थःत अशुद्ध याये मते, मिसा नं पशुप्राणी नापं द्येने मज्‍यू। थ्‍व घचाइपुसे च्‍वंगु ज्‍या खः। ");
INSERT INTO new_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“‘थुकथंया ज्‍यापाखें छिमिसं थःत अशुद्ध याये मज्‍यू, छाय्‌धाःसा थ्‍व फुक्‍कं ज्‍याया हुनिं जिं पितिना छ्वयेत्‍यनापिं फुक्‍क जातित अशुद्ध जुइ धुंकूगु दु। ");
INSERT INTO new_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","इमिगु देश नं अशुद्ध जुइ धुंकूगु दु। अथे जुयाः जिं इमिगु पापया सजाँय इमित हे बिया, अले व देशं थः मनूतय्‌त ल्‍ह्वयाः पितिनाछ्वल। ");
INSERT INTO new_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","अथे जूगुलिं छिमिसं जिगु नियम व विधियात मानय् यायेमाः अले इस्राएलीत जूसां वा इपिं नापं च्‍वनाच्‍वंपिं परदेशीत जूसां सुनानं थज्‍याःगु घचाइपुगु ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","छाय्‌धाःसा व देशया न्‍हापायापिं मनूतय्‌सं थज्‍याःगु हे फुक्‍क घचाइपुगु ज्‍या यानाः देश अशुद्ध जूगु खः। ");
INSERT INTO new_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","छिमिसं नं अथे हे अशुद्ध यात धाःसा छिमित नं व देशं न्‍हापायापिं जातियात ल्‍ह्वयाः पितिनाछ्वःगु थें छिमित नं ल्‍ह्वयाः पितिनाछ्वइ। ");
INSERT INTO new_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“‘थज्‍याःगु घचाइपुगु ज्‍या सुनानं यात धाःसा वयात थः मनूतपाखें पितिना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","थुकथं छिमिसं जिगु उजंयात मानय् यानाः च्‍वँ। न्‍हापायापिन्‍सं याइगु घचाइपुगु ज्‍या यानाः थःत अशुद्ध याये मज्‍यू। जि छिमि परमप्रभु परमेश्‍वर खः।’” ");
INSERT INTO new_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“सकलें इस्राएलयापिं मनूतय्‌त धा, ‘जि परमप्रभु छि परमेश्‍वर पवित्रम्‍ह जूगुलिं छिपिं नं पवित्रपिं जुयाच्‍वँ। ");
INSERT INTO new_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“‘छिपिं फुक्‍कसिनं थः मांबौया हनाबना ति। अले जिगु विश्रामबार मानय् या। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“‘मूर्तिपाखे छिपिं वने मते, अले छिमिसं थःगु निंतिं धातु नाय्‌काः द्यःत नं दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“‘छिमिसं परमप्रभुयात मेलबलि छायेबलय् परमेश्‍वरपाखें थः नालेबहः जुइकथं छा। ");
INSERT INTO new_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","छिमिसं उकियात छाःगु न्‍हिइ हे नयेमाः। कन्‍हय् खुन्‍हु नं व नये ज्‍यू। तर कंस खुन्‍हु छुं ल्‍यं दत धाःसा व मिइ छ्वय्‌काबीमाः। ");
INSERT INTO new_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","कंस तक व नल धाःसा व अशुद्ध जुइ। अले व नालेबहः जुइ मखु। ");
INSERT INTO new_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","सुनानं उकियात नल धाःसा थःगु पापया लागिं व मनू थः हे दोषी जुइ। छाय्‌धाःसा वं परमप्रभुया पवित्र खँ अशुद्ध यात। अले वयात थः मनूतपाखें पितिना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘छिमिसं थःगु बाली लइबलय् बुँया सिथ तक लये मज्‍यू। अले बुँइ कुतुं वंगु अन्‍न नं मुने मते। ");
INSERT INTO new_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","छिमिसं थःगु दाखक्‍यबं दाख खाइबलय् फुक्‍कं दाख खाये मते अले बँय् कुतुं वंगु दाख नं काये मते। व नये मखंपिं व परदेशीतय्‌गु निंतिं त्‍वःताब्‍यु। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“‘छिमिसं खुयाकाये मते। “‘मखुगु खँ ल्‍हाये मते। “‘छम्‍हं मेम्‍हय्‌सित झंगः लाये मते। ");
INSERT INTO new_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“‘जिगु नां कयाः मखुगु पाफयाः थः परमेश्‍वरया नां क्‍वह्यंके मते। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“‘छिमिसं जःलाखःलापिन्‍त ध्‍वंलानाः इमिगु छुं नं काये मते, अले इमिगु छुं नं लुतय् यानाः काये मते। “‘ज्‍याला कयाः ज्‍या याइपिनिगु धिबा वयात मब्‍यूसें सुथय् तक तयातये मते। ");
INSERT INTO new_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“‘न्‍हाय्‌पं ख्‍वाँय्‌यात क्‍वह्यंके मते। कांया न्‍ह्यःने लुफिं हाइगु वस्‍तु तये मते। तर छिमिसं परमेश्‍वरया भय कायेमाः। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“‘छिमिसं अन्‍याय याये मते। तःधंम्‍ह जूसां वा चिधीम्‍ह जूसां, मनूया ख्‍वाः स्‍वयाः मखु, तर सकलें मनूतय्‌गु पाय्‌छिकथं न्‍याय यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“‘मेपिं मनूतय्‌त क्‍वह्यंकाः खँ ल्‍हाना जुइ मते। “‘छिमिसं जःलाखःलापिनिगु जीवन आपतय् लाइगु छुं नं ज्‍या याये मते। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“‘छिमिसं थः जातियापिं दाजुकिजापिन्‍त दुनुगलंनिसें मयय्‌के मते। छिमि जःलाखःलापिन्‍त ब्‍वःब्‍यु। मखुसा छ नं वं याःगु पापया दोषी जुइ। ");
INSERT INTO new_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“‘थः मनूतलिसे बदला कायेगु स्‍वये मते, अले इबि नं तये मते, तर थः जलाःखलाःतय्‌त थःत थें हे माया या। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“‘छिमिसं जिगु नियम मानय् यायेमाः। “‘अले निगू जातियापिं पशुत छथाय् हयाः ज्‍वःचिंके मते। “‘छगू हे बुँइ निथी किसिमयागु पुसा ह्वले मते। “‘छिमिसं निगू किसिमयागु सुका दुगु वसः पुने मते। ");
INSERT INTO new_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“‘ब्‍याहा क्‍वःछी धुंकूम्‍ह तर न्‍याइम्‍ह मिजंनं थःगु यायेत धिबा मपुनिम्‍ह वा थः मालिकपाखें स्‍वतन्‍त्र मजूम्‍ह दासीनापं सुनानं लसपस यात धाःसा इपिं निम्‍हय्‌सित सजाँय बीमाः, तर इमित स्‍यायेगु धाःसा मखु, छाय्‌धाःसा व दासी स्‍वतन्‍त्र मजूनि। ");
INSERT INTO new_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","तर थ्‍व मनुखं नापलायेगु पालया ध्‍वाखाय् थःगु दोषबलिया निंतिं छम्‍ह भ्‍याःचा परमप्रभुयात छायेत हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","अले व मनूया पापया निंतिं प्रायश्‍चित यायेत दोषबलियाम्‍ह भ्‍याःचा पुजाहारीं परमप्रभुया न्‍ह्यःने छायेमाः। अनंलि व मनूयात क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“‘छिपिं व देशय् वनाः फलया सिमा पित धाःसा स्‍वदँ तक उकिया फल नयेजी मखु। स्‍वदँ तक उकिया फल नये मते। ");
INSERT INTO new_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","प्‍यंगूगु दँय् सयावःगु फल पवित्र जुइ, अले थ्‍व परमप्रभुया प्रशंसाया निंतिं देछायेमाः। ");
INSERT INTO new_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","तर न्‍यागूगु दँय् उकियागु फल छिमिसं नये ज्‍यू। अले अप्‍वः फल सयावइ। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“‘छिमिसं हि पिमकाःगु ला नये मते। “‘छिमिसं ज्‍वखना स्‍वयेगु व तन्‍त्रमन्‍त्र यायेगु ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“‘छिमिसं न्‍हकुइ च्‍वंगु सँ खाये मते। अले दाह्रीया कुन्‍चा कुन्‍चा नं चाये मते। ");
INSERT INTO new_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“‘छिमिसं दुखं च्‍वनीबलय् थःगु म्‍हया छेंगुलिइ घाः याये मते। अले उकी छुं नं च्‍वयेगु ज्‍या नं याये मते। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“‘छिमिसं थः म्‍ह्याय्‌पिन्‍त वेश्‍या दय्‌काः क्‍वह्यंके मते। मखुसा देशय् न्‍यंकं वेश्‍यावृतिं जायावनी। अले देश पापं जाइ। ");
INSERT INTO new_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“‘छिमिसं जिगु विश्रामबार मानय् यायेमाः, अले जिगु पवित्र पालयागु हनाबना तयेमाः। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“‘छिपिं तन्‍त्रमन्‍त्र ज्‍या याइपिं बोक्‍सियाथाय् वने मते। इमिगु सल्‍लाह कयाः थःत अशुद्ध याये मते। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“‘बुराबुरी मनूतय्‌गु न्‍ह्यःने दनाः इमिगु हनाबना तयेमाः। अले थः परमेश्‍वरया भय कायेगु। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“‘सुं परदेशी छिपिंनापं च्‍वनाच्‍वंगु दुसा वयात बांलाःगु व्‍यवहार यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","छिपिंनापं च्‍वनाच्‍वंम्‍ह परदेशीयात थःगु देशयाम्‍ह मनूयात थें हे व्‍यवहार यायेमाः। छिमिसं वयात थःत थें हे माया या, छाय्‌धाःसा छिपिं नं न्‍हापा मिश्रय् परदेशी जुयाच्‍वंगु खः। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“‘छिमिसं दायेबलय्, लनेबलय् व ल्‍याःखायेबलय् सुयातं ध्‍वंलाये मते। ");
INSERT INTO new_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","छिमिसं ठीक कथंयागु धःताल्‍जु अले ठीक कथंयागु नाप तौल नं तयेमाः। जि परमप्रभु छिमि परमेश्‍वर खः। जिं छिमित मिश्र देशं पित हया। ");
INSERT INTO new_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“‘अथे जुयाः छिमिसं जिगु नियम व विधि मानय् यायेमाः। जि परमप्रभु खः।’” ");
INSERT INTO new_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“इस्राएलीतय्‌त धा, ‘सुं इस्राएली वा इपिं नापं च्‍वनाच्‍वंम्‍ह परदेशी मनुखं मोलेक द्यःयात थःपिनि मचा छाल धाःसा वयात खलःयापिं फुक्‍कसिनं ल्‍वहँतं कय्‌काः स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","वं थः मचा मोलोखयात छाइबलय् जिगु पवित्र पालयात अशुद्ध याइ अले जिगु पवित्र नांयात क्‍वह्यंकी, अथे जुयाः जि थः हे वयागु विरोधय् वनाः वयात थः मनूतपाखें पितिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","वं थः मचा मोलोखयात छाःबलय् खलःयाम्‍ह सुनानं मखंछु यानाः व मनूयात मस्‍यात धाःसा ");
INSERT INTO new_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","व मनू, वया छेँजःपिं व वयागु ज्‍याय् ल्‍हाः तःपिं फुक्‍कसित जिं त्‍वःते मखु। जिं वयात वया थः मनूतपाखें पितिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“‘सुं मनू तन्‍त्रमन्‍त्रय् लगय् जुल धाःसा जिं वयात त्‍वःते मखु। छाय्‌धाःसा वं जिगु विरोधय् बेस्‍याया थें ज्‍या यात। जिं वयात वया थः मनूतपाखें पितिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“‘अय्‌जूगुलिं छिपिं थुपिं फुक्‍कपाखें अलग च्‍वनाः पवित्र जुयाच्‍वँ! छाय्‌धाःसा जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","छिमिसं जिं धया थें या, छिमित पवित्र याइम्‍ह परमप्रभु जि हे खः। ");
INSERT INTO new_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“‘सुंनानं थः मां व बौयात सराः बी, वयात स्‍याना छ्वयेमाः। थज्‍याःम्‍ह मनू तःधंगु अपराधया दोषी खः। ");
INSERT INTO new_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“‘सुनानं थः जःलाखःलाया कलाःनापं लसपस यात धाःसा मिसा व मिजं निम्‍हय्‌सितं स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“‘थः बौया कलाःनापं लसपस याइम्‍हय्‌सिनं थः बौयात लज्‍या चाय्‌कूगु खः। इपिं निम्‍हय्‌सितं स्‍याना छ्वयेमाः। थज्‍याःम्‍ह मनू तःधंगु अपराधया दोषी खः। ");
INSERT INTO new_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“‘सुनानं थः काय्‌भौनाप लसपस यात धाःसा इपिं निम्‍हय्‌सितं स्‍याना छ्वयेमाः। इमिसं याये मत्‍यःगु ज्‍या यात। थज्‍याःम्‍ह मनू तःधंगु अपराधया दोषी खः। ");
INSERT INTO new_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“‘सुनानं मिजनं मिसानाप लसपस याःथें मिजंनाप लसपस यात धाःसा व घचाइपुगु ज्‍या खः। इमित स्‍याना छ्वयेमाः। थज्‍याःम्‍ह मनू तःधंगु अपराधया दोषी खः। ");
INSERT INTO new_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“‘सुनानं मां व म्‍ह्याय् निम्‍हसितं कलाः तल धाःसा थ्‍व क्‍वह्यंगु ज्‍या खः। इपिं स्‍वम्‍हय्‌सितं मिइ छ्वय्‌का छ्वयेमाः। छिमि दथुइ थज्‍याःगु क्‍वह्यंगु ज्‍या मजुइमाः। ");
INSERT INTO new_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","16","“‘सुं नं मिजं वा मिसां पशुनाप लसपस यात धाःसा वयात स्‍याना छ्वयेमाः। नापं पशु नं स्‍याना छ्वयेमाः। थज्‍याःम्‍ह मनू तःधंगु अपराधया दोषी खः। ");
INSERT INTO new_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“‘सुनानं थः तःकेहेँपिं, थः बौ वा मांया पाखेंयाम्‍ह म्‍ह्याय्‌यात ब्‍याहा यानाः लसपस यात धाःसा व लज्‍या चायापुगु ज्‍या खः। इमित इमि थः मनूतपाखें पितिनाछ्वयेमाः। वं थः केहेँयात लज्‍या चायापुगु ज्‍या खः। अले व उकिया दोषी जुइ। ");
INSERT INTO new_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“‘सुनानं थीमज्‍यू जुयाच्‍वंम्‍ह मिसानाप लसपस यात धाःसा वं हिबा वःगु मूलयात उलाक्‍यना ब्‍यूगु दु, अले व मिसां नं व उला ब्‍यूगु दु। इपिं निम्‍हय्‌सितं इमि थः मनूतपाखें पितिनाछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“‘सुनानं थः मांबौया तःकेहेँपिं लिसे लसपस याये मते। थुकिं स्‍यःलाःपिं थःथितिया लज्‍या चाय्‌कूगु जुइ। अले इपिं निम्‍हं दोषी जुइ। ");
INSERT INTO new_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“‘सुनानं थः कका वा तःबाःया कलाःनापं लसपस यात धाःसा वं थः कका वा तःबाःयात लज्‍या चाय्‌कूगु जुइ। इपिं थःगु पापया निंतिं दोषी जुइ। अले इपिं मचाखाचा मदय्‌कं हे सी। ");
INSERT INTO new_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“‘सुनानं थः किजाभौ वा तताजु नाप लसपस यात धाःसा व याये मत्‍यःगु ज्‍या खः। वं थः दाजु वा किजायात लज्‍या चाय्‌कूगु जुइ। इपिं मचाखाचा मदय्‌कं सी। ");
INSERT INTO new_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“‘परमप्रभुं धयादिल, जिगु नियम व आज्ञा पालन या। मखुसा जिं छिमित यंके धयागु देशं छिमित ल्‍ह्वयाः वांछ्वइ। ");
INSERT INTO new_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","जिं छिमिगु न्‍ह्यःनें पितिनाछ्वये त्‍यनागु जातियापिन्‍सं याःथें छिमिसं याना जुइ मते। इमिगु याये मत्‍यःगु ज्‍याखं यानाः जिं इमित मयय्‌कागु खः। ");
INSERT INTO new_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","तर जिं छिमित धयागु दु, “छिमिसं इमिगु देश त्‍याकाः काइ, छाय्‌धाःसा थ्‍व देश जिं छिमित सर्बयकथं बी। जिं थःम्‍हं हे दुरु व कस्‍ति बाः वयाच्‍वंगु थ्‍व देशयात छिमित बी।” जि छिमित मेगु जातितपाखें अलग तइम्‍ह परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“‘उकिं छिमिसं शुद्धपिं व अशुद्धपिं झंगः व पशुत बांलाक म्‍हसीकि। जिं अशुद्ध धयापिं झंगः, पशु व बँय् घिसय् जुया जुइपिं पशुतपाखें छिमिसं थःपिन्‍त अशुद्ध याये मते ");
INSERT INTO new_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","छिपिं जिगु निंतिं पवित्र जुइमाः, छाय्‌धाःसा जि परमप्रभु पवित्र खः। अले जिं छिमित थः मनूत यायेत मेगु जातितपाखें अलग तयागु खः। ");
INSERT INTO new_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“‘सुनानं मिजं वा मिसां तन्‍त्रमन्‍त्रया ज्‍या यात धाःसा वयात स्‍याना छ्वयेमाः। वयात ल्‍वहँतं कय्‌काः स्‍यायेमाः। थज्‍याःम्‍ह मनू तःधंगु अपराधया दोषी खः।’” ");
INSERT INTO new_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","परमप्रभुं मोशायात धयादिल, “हारूनया पुजाहारी काय्‌पिन्‍त थथे धा, ‘पुजाहारीं सुं थःथिति सित धाःसा वयात थीमज्‍यू। थुकिं वयात अशुद्ध याइ। ");
INSERT INTO new_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","थः मांबौ, काय्‌म्‍ह्याय्, दाजुकिजा, ");
INSERT INTO new_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","व ब्‍याहा मजूनिपिं तःकेहेँया निंतिं जक इमिसं थःत अशुद्ध यायेमा। ");
INSERT INTO new_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ब्‍याहापाखें स्‍वापु दुपिं सुयागुं निंतिं नं इमिसं थःपिन्‍त अशुद्ध याये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“‘दुःखं च्‍वनीबलय् थःगु सँ खाये मते, दाह्रीया कुन्‍चा कुन्‍चा नं चाये मते, अले म्‍हय् घाः याये मते। ");
INSERT INTO new_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","थः परमेश्‍वरया निंतिं इपिं पवित्र जुइमाः, अले थः परमेश्‍वरया नां अशुद्ध मयायेमाः। छाय्‌धाःसा इमिसं विशेष देछा, परमेश्‍वरया नसा होमबलि छाइगु खः। उकिं इपिं पवित्र जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“‘इमिसं ल्‍यवःसिं मिसा, स्‍यनेधुंकूम्‍ह मिसा व भाःतं त्‍वःतूम्‍ह मिसा ब्‍याहा याये मज्‍यू। छाय्‌धाःसा इपिं पुजाहारीत थः परमेश्‍वरया निंतिं पवित्रपिं खः। ");
INSERT INTO new_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","मनूतय्‌सं इमित पवित्र भाःपीमाः, छाय्‌धाःसा इमिसं छिमि परमेश्‍वरयात अन्‍नबलि छाइ। मनूतय्‌सं इमित पवित्र भाःपीमाः, छाय्‌धाःसा जि छिमित पवित्र याइम्‍ह परमप्रभु पवित्र खः। ");
INSERT INTO new_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“‘सुं पुजाहारीया म्‍ह्याय्‌नं ल्‍यवःसिं ज्‍या यानाः थःत अशुद्ध यात धाःसा, वं थः बौया अपमान याइ। वयात मिइ छ्वय्‌काः स्‍याना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“‘दकलय् तःधंम्‍ह पुजाहारी, छेनय् अभिषेकया चिकं लुइ धुंकूम्‍ह व पुजाहारीया वसः पुंकेत अलग तये धुंकूम्‍हय्‌सिनं दुखं च्‍वनीबलय् सँ मचिसे मच्‍वनेमाः अले थःगु वसः नं मखुइमाः। ");
INSERT INTO new_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","सीम्‍ह दुथाय् वनाः वं थःत अशुद्ध याये मज्‍यू। वया थः मांबौ हे सीसां व वने मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","व नापलायेगु पालं पिहां मवनेमा, अले थः परमेश्‍वरया नापलायेगु पालयात अपवित्र मयायेमा। छाय्‌धाःसा परमेश्‍वरया अभिषेकया चिकनं वयात अर्पण याये धुंकूगु दु। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“‘वं कुमारी मिसामचा ब्‍याहा यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","वं भाःत सी धुंकूम्‍ह, भाःत त्‍वःते धुंकूम्‍ह मिसा, स्‍यंम्‍ह मिसा व ल्‍यवःसिं मिसा ब्‍याहा मयायेमाः। वं थःगु हे कुलयाम्‍ह कुमारी मिसामचा ब्‍याहा यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","मखुसा वया काय्‌म्‍ह्याय्‌पिं अशुद्ध जुइ। जि वयात पवित्र याइम्‍ह परमप्रभु खः।’” ");
INSERT INTO new_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“हारूनयात धा, ‘छं लिपाया पुस्‍ताय् म्‍हय् खू दुम्‍ह सुं छिमि सन्‍तान थः परमेश्‍वरयात बलि छायेत न्‍ह्यःने वये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","खू दुम्‍ह सुं नं न्‍ह्यःने वये दइ मखु। कां, खुत्‍यां काःम्‍ह, अंगभंग जूम्‍ह ");
INSERT INTO new_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ल्‍हाःतुति चाःतूम्‍ह, ");
INSERT INTO new_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","धुसि लूम्‍ह वा बागःचाम्‍ह, मिखा व छेंगूया ल्‍वय् दुम्‍ह, अण्‍डकोष स्‍यंम्‍ह जिगु न्‍ह्यःने वये दइ मखु। ");
INSERT INTO new_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","पुजाहारी हारूनया सन्‍तानय् खू दुम्‍ह सुं नं जितः विशेष देछा छायेत जिगु न्‍ह्यःने वये दइ मखु। वयाके खू दु। व थः परमेश्‍वरयात अन्‍नबलि बीत न्‍ह्यःने वये दइ मखु। ");
INSERT INTO new_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","पुजाहारीया सन्‍तान जूगुलिं वं थः परमेश्‍वरयात छायेहःगु विशेष देछा नये फइ। ");
INSERT INTO new_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","तर वयाके खू दुगुलिं वं पर्दा व वेदीया लिक्‍क वयाः जिगु पवित्र पालयात अशुद्ध यायेदइ मखु। छाय्‌धाःसा जि उकियात पवित्र याइम्‍ह परमप्रभु खः।’” ");
INSERT INTO new_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","अले मोशां हारून, वया काय्‌पिं व फुक्‍क इस्राएलीतय्‌त थ्‍व खँ न्‍यंकल। ");
INSERT INTO new_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“हारून व वया काय्‌पिन्‍त धा, इस्राएलीतय्‌सं जितः छायेहःगु पवित्र वस्‍तुया बारे होसियार जु, अले जिगु नांयात क्‍वह्यंकेगु याये मते। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“इमित धा, ‘छिमि पुस्‍तौं पुस्‍ताय् सुं अशुद्धम्‍ह मनू इस्राएलीतय्‌सं अर्पण याःगु पवित्र वस्‍तुया न्‍ह्यःने वन धाःसा वयात जिं जिगु न्‍ह्यःनं नाश यानाबी। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“‘हारूनया काय्‌पिं मध्‍ये सुं छेंगूया पुनेयःगु ल्‍वय् दुम्‍ह वा धातुया ल्‍वय् दुम्‍ह अशुद्ध जुइबलय् तक छायेहःगु पवित्र वस्‍तुं छुं नं मनयेमाः। सीम्‍ह थ्‍यूम्‍ह, धातुया अथें कुतुं वइम्‍हयात थ्‍यूम्‍ह अले ");
INSERT INTO new_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","घिसय् जुया जुइपिं जीवजन्‍तुतय्‌त थ्‍यूम्‍ह, गुगुं कथंयागु अशुद्ध दुम्‍ह मनू थ्‍यूम्‍ह, ");
INSERT INTO new_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","थज्‍याःम्‍ह मनू सन्‍ध्‍याकाः ईतक अशुद्ध जुइमाः। व म्‍वःमल्‍हुतले छाःगु पवित्र वस्‍तुं छुं नं नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","तर सन्‍ध्‍याकाः ई धुंकाः जक व शुद्ध थहरय् जुइ। अनंलि वं छाःगु पवित्र वस्‍तुं नःसा ज्‍यू छाय्‌धाःसा व वयागु नयेगु नसा खः। ");
INSERT INTO new_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","सुं पुजाहारीं थःगु कालं स्‍यूम्‍ह अले गुँपशुं स्‍याःम्‍ह जन्‍तु नयाः थःत अशुद्ध याये मज्‍यू। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“‘अथे जुयाः इमिसं जिगु विधियात मानय् यायेमाः, मखुसा इपिं जिगु विधियात मानय् मयाःगुलिं दोषी जुयाः सिनावनी। जि इमित पवित्र याइम्‍ह परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“‘पुजाहारी परिवारया मखुम्‍ह मनुखं पवित्र वस्‍तु मनयेमा। व पुजाहारीया पाहां जूसां वा ज्‍यालाय् ज्‍या याइम्‍ह मनू जूसां वं पवित्र वस्‍तु मनयेमा। ");
INSERT INTO new_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","तर पुजाहारीं सुं दासयात धिबा पुलाः न्‍यानाकाल धाःसा व दासं छाःगु बलिं नयेफु। पुजाहारीया छेँय् बूम्‍ह दासं नं उकिं नयेफु। ");
INSERT INTO new_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","मेगु कुलयाम्‍ह मिजंनापं पुजाहारीया म्‍ह्याय्‌या ब्‍याहा जूगु दुसा वं छाःगु विशेष पवित्र भेटीं छुं नं नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","तर पुजाहारीया म्‍ह्याय्‌या भाःत सीत धाःसा, वा भाःतं त्‍वःतकाः च्‍वम्‍ह जूसा अले व मचाखाचा मदयाः ब्‍याहा जुइ न्‍ह्यः थें थःछेँ च्‍वनाच्‍वंसा थः बौयागु नयेगु नसां नये ज्‍यू। तर पुजाहारी परिवार व वया दासपिन्‍सं बाहेक मेपिं सुनानं उकिं नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“‘तर सुं मनुखं मसीकं पवित्र वस्‍तुं नल धाःसा वं उकियागु न्‍याब्‍वय् छब्‍व तनाः उकियात पवित्र देछाकथं पुजाहारीयात बीमाः। ");
INSERT INTO new_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","पुजाहारीं इस्राएलीतय्‌सं छायेहःगु पवित्र देछायात अशुद्ध मयायेमाः। ");
INSERT INTO new_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","थथे देछां छुं कयाः नके मत्‍यःपिं मनूतय्‌त नकेगु मयायेमाः। मखुसा इमिसं सजाँय फयेमाली। जि इमित पवित्र याइम्‍ह परमप्रभु खः।’” ");
INSERT INTO new_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“हारून वया काय्‌पिं व फुक्‍क इस्राएलीतय्‌त धा, ‘इस्राएली वा इपिं नापं च्‍वनाच्‍वंम्‍ह परदेशीं भाकल वा थःयसेंया होमबलि परमप्रभुयात छाइबलय्, ");
INSERT INTO new_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","व नालेबहः जुइत द्वहं, फै वा दुगुचा न्‍ह्याम्‍ह हे जूसां खू मदुम्‍ह मिजंम्‍ह जक छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","खू दुम्‍हय्‌सित छिमिसं छाये मते, छाय्‌धाःसा व नालेबहः जुइ मखु। ");
INSERT INTO new_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“‘सुनानं मेलबलि वा थः यःछिया बलि फैच्‍वलय्‌या बथां वा सा द्वहंया बथांपाखें थःगु भाकल पूवंकेत छाल धाःसा नालेबहः जुइत व पशुयागु म्‍हय् छुं नं खू मदयेमाः। ");
INSERT INTO new_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","कांम्‍ह, म्‍हया छुं ब्‍व स्‍यंम्‍ह, अले खुत्‍यां काःम्‍ह, चासुइगु वा छेंगूया ल्‍वय् दुम्‍ह पशुयात छिमिसं वेदीइ छाये मज्‍यू, अले विशेष देछाकथं नं परमप्रभुयात छाये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","तर म्‍हय् छुं खू दुम्‍ह सा वा द्वहं, फै धाःसा वयात थः यःछि बलिकथं छाये फु, तर भाकल पूवंकेत व नालेबहः जुइ मखु। ");
INSERT INTO new_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","पशुयागु अण्‍ड तज्‍याःगु वा ध्‍यनाछ्वःगु, अले काचाकुचु जूगु दुसा वयात परमप्रभुया निंतिं छाये मज्‍यू। छिमिगु देशय् गन नं थज्‍याःगु ज्‍या याये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","सुं परदेशीयाके कयाः नं थज्‍याःम्‍ह पशु परमेश्‍वरया निंतिं छाये मज्‍यू। वयागु म्‍हय् स्‍यंगु ब्‍व दु, वयाके खू दु। अथे जुयाः व छिमिगु पलेसा नालेबहः जुइ मखु।’” ");
INSERT INTO new_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“साचा वा द्वहंचा, चिधिकःम्‍ह भ्‍याःचा वा दुगुचा बुइबलय् व न्‍हय्‌न्‍हु तक थः मां नापं हे च्‍वनेमाः। च्‍यान्‍हु खुन्‍हुनिसें व परमप्रभुया न्‍ह्यःने विशेष देछाकथं नालेबहः जुइ। ");
INSERT INTO new_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","सा वा द्वहं, फैयात वया मचानापं छन्‍हुं हे स्‍याये मते। ");
INSERT INTO new_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“छिमिसं परमप्रभुया निंतिं सुभाय् बलि छाइबलय् छिपिं नालेबहः जुइकथं व छायेगु यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","छाइगु न्‍हि हे उकियात नयेमाः। उकियागु छुं नं सुथय् तक ल्‍यंका तये मज्‍यू। जि परमप्रभु खः।” ");
INSERT INTO new_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“अथे जुयाः छिमिसं जिगु विधियात मानय् या। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","छिमिसं जिगु पवित्र नांयात क्‍वह्यंकेगु याये मते। इस्राएलीतय्‌सं जि पवित्र खः धकाः नाला कायेमाः। छिमित पवित्र याइम्‍ह परमप्रभु जि हे खः। ");
INSERT INTO new_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","छिमि परमेश्‍वर जुइत जिं हे छिमित मिश्रं पित हया। जि परमप्रभु खः।” ");
INSERT INTO new_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“इस्राएलीतय्‌त जिं ल्‍ययागु परमप्रभुया पवित्र नखःचखः थ्‍व हे खः धकाः धयाब्‍यु। ‘थुकियात छिमिसं पवित्र मुंज्‍या धकाः घोषणा या। ");
INSERT INTO new_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“‘खुन्‍हु तक छिमिसं ज्‍या या, न्‍हय्‌न्‍हु दुखुन्‍हु धाःसा झासु लनेगु विश्रामबार व पवित्र मुंज्‍या जुइ। उखुन्‍हु छिमिसं छुं नं ज्‍या याये मते। छिपिं न्‍ह्याथाय् च्‍वनाच्‍वंसां उखुन्‍हु छिमिसं परमप्रभुयात तःधंकेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“‘परमप्रभुं क्‍वःछिनातःगु जितः तःधंकेत छिमिसं थःथवय् मुनाः हनेमाःगु नखःचखः थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","न्‍हापांगु लाया झिंप्‍यन्‍हु खुन्‍हु सन्‍ध्‍याकाः इलय् परमप्रभुया छुत्‍काराया नखः शुरु जुइ। ");
INSERT INTO new_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","व हे लाया झिंन्‍यान्‍हु खुन्‍हुनिसें परमप्रभुया सोडा मतःगु मरिया नखः शुरु जुइ। न्‍हय्‌न्‍हु तक छिमिसं सोडा मतःगु मरि नयेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","न्‍हापां खुन्‍हु छिमिगु छगू पवित्र मुंज्‍या जुइमाः। उखुन्‍हु छिमिसं छुं नं न्‍हिज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","न्‍हय्‌न्‍हु तकं छिमिसं परमप्रभुया निंतिं विशेष देछा छायेगु। अले न्‍हय्‌न्‍हु दुखुन्‍हु हानं छिमिगु छगू पवित्र मुंज्‍या जुइमाः। उखुन्‍हु छिमिसं छुं नं न्‍हिज्‍या याये मते।’” ");
INSERT INTO new_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“इस्राएलीतय्‌त धा, ‘जिं छिमित बीत्‍यनागु देशय् वने धुंकाः छिमिसं बालीया न्‍हापांगु ब्‍वया छथू लयाः पुजाहारीयाथाय् हति। ");
INSERT INTO new_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","विश्रामबारया कन्‍हय् खुन्‍हु पुजाहारीं उकियात परमप्रभुया न्‍ह्यःने यंकाः संकाः देछायेमाः। अले जिं उकियात छिमिगुपाखें लःल्‍हानाकाये। ");
INSERT INTO new_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","उखुन्‍हु हे छिमिसं परमप्रभुयात होमबलि छायेत दच्‍छि दुम्‍ह खू मदुम्‍ह चिधिकःम्‍ह भ्‍याःचा छाये हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","थुकिया नापं परमप्रभुया निंतिं अन्‍नबलिकथं छिमिसं चिकनय् न्‍हायातःगु छगू एपाया झिब्‍वय् निब्‍व भिंगु छुचुं नस्‍वाःया लागिं परमप्रभुया निंतिं विशेष देछाकथं छाये हयेमाः। थ्‍व नापं छगू लिटर दाखमद्य नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","छिमिसं थः परमेश्‍वरयात थथे छाये महतले छिमिसं न्‍हूगु बालीया गुगुं नं कथंया मरि, सियातःगु, छुयातःगु अन्‍न नये मते। छिमिसं न्‍ह्याथाय् वंसां छिमि पुस्‍तौं पुस्‍ता तकं यायेमाःगु न्‍ह्याबलेंया नियम थ्‍व खः। ");
INSERT INTO new_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“‘विश्रामबारया कन्‍हय् खुन्‍हुनिसें अर्थात छिमिसं संकाः ब्‍यूगु बलिया थू हःगु न्‍हिखुन्‍हुं निसें न्‍हय्‌वाः ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","न्‍हय्‌गूगु विश्रामबार तक नेय्‌न्‍हु ल्‍याःखा, अले न्‍हूगु अन्‍नबलि परमप्रभुयात छाये हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","छिपिं न्‍ह्याथाय् जूसां छिमिसं न्‍हापांगु बालीया छगू एपाया झिब्‍वय् निब्‍व भिंगु छुचुंया सोडा ल्‍वाकछ्यानातःगु निपा मरि परमप्रभुया निंतिं संकाः बीगु बलिकथं छाये हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","मरिनापं छिमिसं दच्‍छि दुपिं न्‍हय्‌म्‍ह खू मदुपिं चिधिकःपिं भ्‍याःचात, छम्‍ह द्वहंचा व निम्‍ह भ्‍याःचा छाये हयेमाः। परमप्रभुया निंतिं थ्‍व होमबलि नापं इमिगु अन्‍नबलि व त्‍वँसाबलि छगू विशेष बलि जुइ, परमप्रभुया नस्‍वाःगु नस्‍वाः। ");
INSERT INTO new_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","अनंलि छिमिसं पापबलिया निंतिं छम्‍ह दुगु व मेलबलिया निंतिं दच्‍छि दुपिं निम्‍ह चिधिकःपिं भ्‍याःचात छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","पुजाहारीं परमप्रभुया न्‍ह्यःने, न्‍हापांगु फलया मरिनापं संकाः बीगु बलिकथं निम्‍ह चिधिकःपिं भ्‍याःचायात संकाः छायेमाः। थ्‍व पुजाहारीया निंतिं परमप्रभुयात छाःगु पवित्र बलि जुइ। ");
INSERT INTO new_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","उखुन्‍हु छिमिसं छुं नं न्‍हिज्‍या याये मते। छिमिगु छगू पवित्र मुंज्‍या जुइमाः। छिमि लिपाया पुस्‍तां पुस्‍ता तकया लागि छिपिं न्‍ह्याथाय् च्‍वंसां थ्‍व न्‍ह्याबलेंया नियम खः। ");
INSERT INTO new_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“‘छिमिसं बाली लयेबलय् बुँ सिथय् सिथय् थ्‍यंक लये मते। अले बाली लयेबलय् बँय् लाःगु नं मुने मते। छिमिसं उकियात नये मखंपिन्‍त व विदेशीपिन्‍त त्‍वःताब्‍यु। जि परमप्रभु छिमि परमेश्‍वर खः।’” ");
INSERT INTO new_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","परमप्रभुं मोशायात धयादिल- ");
INSERT INTO new_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“इस्राएलीतय्‌त धा, ‘न्‍हय्‌गूगु लाया न्‍हापांगु दिं फुक्‍कं झासु लनेगु दिं जुइमाः। उखुन्‍हु फैया नेकूया तुरही पुयाः परमेश्‍वरया छगू पवित्र मुंज्‍या जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","उखुन्‍हु छिमिसं छुं नं कथंया न्‍हिज्‍या याये मते। तर परमप्रभुया निंतिं विशेष देछा छा।’” ");
INSERT INTO new_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“न्‍हय्‌गूगु लाया झिन्‍हु खुन्‍हु प्रायश्‍चितया दिं जुइ। उखुन्‍हु छिमिसं छुं मनसें छगू पवित्र मुंज्‍या तयेमाः। अले परमप्रभुयात विशेष देछा छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","उखुन्‍हु छिमिसं छुं नं ज्‍या याये मते। छाय्‌धाःसा उखुन्‍हु परमप्रभु छिमि परमेश्‍वरया न्‍ह्यःने छिमिगु पापया प्रायश्‍चित यायेगु दिं खः। ");
INSERT INTO new_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","उखुन्‍हु अपसं मच्‍वंपिन्‍त जिं थः मनूतपाखें पितिनाछ्वये। ");
INSERT INTO new_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","उखुन्‍हु छुं कथंया ज्‍या याइपिन्‍त जिं नाश यानाबी। ");
INSERT INTO new_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","छिमिसं उखुन्‍हु छुं कथंया ज्‍या याये मते। छिपिं न्‍ह्याथाय् वनाच्‍वंसां छिमि पुस्‍तौं पुस्‍तातय्‌गु निंतिं थ्‍व छिमिगु न्‍ह्याबलेंया नियम खः। ");
INSERT INTO new_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","थ्‍व छिमिगु निंतिं फुक्‍कं झासु लनेगु विश्रामबारया दिं खः। गुन्‍हुया सन्‍ध्‍याकाः इलंनिसें कन्‍हय् खुन्‍हु सन्‍ध्‍याकाः ईतक छिमिसं छुं मनसें थ्‍व विश्रामबार हनेमाः।” ");
INSERT INTO new_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“इस्राएलीतय्‌त धा, ‘न्‍हय्‌गूगु लाया झिंन्‍यान्‍हु खुन्‍हुनिसें न्‍हय्‌न्‍हु तक परमप्रभुया बल्‍चाबाय्‌या नखः जुइ। ");
INSERT INTO new_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","नखःया न्‍हापांगु दिं परमेश्‍वरयात आराधना यायेत छिमिगु छगू पवित्र मुंज्‍या जुइमाः। सुनानं ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","न्‍हय्‌न्‍हुयंकं छिमिसं परमप्रभुया निंतिं वेदीइ विशेष देछा छायेमाः। च्‍यान्‍हु खुन्‍हु हाकनं छिमिगु छगू पवित्र मुंज्‍या जुइमाः। थ्‍व छगू तःधंगु मुंज्‍या जुइ। व दिनय् छिमिसं छुं नं ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“‘जिं ल्‍ययागु नखःचखः थुपिं हे खः। अले थुपिं नखतय् छिमिगु मुंज्‍याय् परमप्रभुयात तःधंकेगु निंतिं नखःकथं विशेष देछा होमबलि, अन्‍नबलि, व त्‍वँसाबलि छायेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","थुपिं नखःचखः छिमिसं न्‍ह्याबलें हनीगु विश्रामबारया बाहेक खः, अले बलि छायेगु नं न्‍ह्याबलें छायावयाच्‍वंगु बलि, भाकल व थःयसेंबलि बाहेकया बलि खः। अले छिमिसं परमप्रभुयात ब्‍यूगु बचं पूवंकेत ब्‍यूगु बलि खः। ");
INSERT INTO new_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“‘छिमिसं थःगु बुँया बाली लये धुंकाः न्‍हय्‌गूगु लाया झिंन्‍यान्‍हु खुन्‍हुनिसें न्‍हय्‌न्‍हु तक परमप्रभुया निंतिं थ्‍व नखः हनेमाः। थ्‍व नखःया न्‍हापांगु दिं व च्‍यान्‍हु खुन्‍हुया दिं विश्रामबार दि खः उखुन्‍हु छुं ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","न्‍हापांगु दिं छिमिसं थःथाय् सःगु भिंभिंगु फल, बल्‍चा दय्‌केत ताय्‌गः सिमाया कचा, ततःमागु सिमाया कचा, लहरे पिपलया कचा ज्‍वनाः न्‍हय्‌न्‍हु तक परमप्रभु छिमि परमेश्‍वरया न्‍ह्यःने लय्‌ताया च्‍वँ। ");
INSERT INTO new_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","दँय्‌दसं छिमिसं थुकियात परमप्रभुया निंतिं न्‍हय्‌न्‍हु तक नखःकथं हनेमाः। लिपा वइपिं छिमि पुस्‍तौं पुस्‍तातय्‌सं नं न्‍हय्‌गूगु लाय् थ्‍व नखः हनेमाः। थ्‍व न्‍ह्याबलेंया लागिं नियम खः। ");
INSERT INTO new_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","न्‍हय्‌न्‍हु तक फुक्‍क इस्राएलीत बल्‍चाय् च्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","थुकिं छिमि सन्‍तानतय्‌सं जिं इमि पुर्खायात मिश्रं पितहयाबलय् बल्‍चाय् तयागु खः धकाः सीमा। जि परमप्रभु छिमि परमेश्‍वर खः।’” ");
INSERT INTO new_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","थुकथं मोशां इस्राएलीतय्‌त परमप्रभुं क्‍वःछिनातःगु नखः हनेगु विधि बिल। ");
INSERT INTO new_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“इस्राएलीतय्‌त थथे उजं ब्‍यु, मत मदिक्‍क च्‍यानाः जः दयाच्‍वनेत छन्‍थाय् भिंगु जैतूनया शुद्धगु चिकं हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","पवित्र पालय् साक्षीया सनूया न्‍ह्यःने दुगु पर्दाया पिने, परमप्रभुया न्‍ह्यःने सन्‍ध्‍याकाः इलंनिसें सुथय् तक मदिक्‍क हारूनं मत च्‍याका तयेमाः। थ्‍व छिमि पुस्‍तौं पुस्‍ताया लागिं न्‍ह्याबलेंया नियम खः। ");
INSERT INTO new_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","हारूनं परमप्रभुया न्‍ह्यःने शुद्धगु लुँया त्‍वाःदेवाय् दुगु मतःयात न्‍हियान्‍हिथं बिचाः यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“अले भिंगु छुचुं कयाः छं झिंनिपा मरि छु। छपा छपा मरिइ छगू एपाया झिब्‍वय् निब्‍व छुचुं दयेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","खुपा-खुपाया निपँ पँचिनाः निगू पँ परमप्रभुया न्‍ह्यःने भिंगु लुं भुनातःगु तेबिलय् ति। ");
INSERT INTO new_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","अले थ्‍व मरिया निंतिं लुमन्‍तिकथं ब्‍व जुयाः परमप्रभुया निंतिं विशेष देछा जुइत छं पँपतिकं भिंगु धुपाँय् ति। ");
INSERT INTO new_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","विश्रामबार पतिकं हारूनं न्‍हूगु मरि परमप्रभुया न्‍ह्यःने ब्‍वयातयेमाः। थ्‍व इस्राएलीतय्‌त न्‍ह्याबलेंया लागिं विधि खः। ");
INSERT INTO new_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","अले थ्‍व मरि हारून व वया सन्‍तानतय्‌गु निंतिं खः। अले परमप्रभुयात छाःगु विशेष देछात मध्‍ये थ्‍व इमिगु न्‍ह्याबलेंया भाग तसकं पवित्र खः। अथे जुयाः इमिसं थ्‍व नापलायेगु पाल दुने नयेमाः।” ");
INSERT INTO new_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","छम्‍ह इस्राएली मिसाया काय् दु। वया अबु मिश्री खः। इस्राएली मिसाया व काय् इस्राएलीतनापं च्‍वनाच्‍वंगु खः। व छम्‍ह इस्राएली मनूनापं ल्‍वात। ");
INSERT INTO new_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","व इस्राएली मिसाया काय्‌नं उबले परमप्रभुया नांयात क्‍वह्यंकाः सराः बिल। अले मनूतय्‌सं वयात ज्‍वनाः मोशायाथाय् हल। वया मांया नां शलोमीत खः। व दानया कुलया दिब्रीया म्‍ह्याय् खः। ");
INSERT INTO new_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","परमप्रभुया इच्‍छा इमिसं मस्‍यूतले वयात कुनातल। ");
INSERT INTO new_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“व सराः ब्‍यूम्‍हय्‌सित छाउनी पिने यंकि अले वं धाःगु खँ न्‍यंपिं फुक्‍कसिनं थथःगु ल्‍हाः वयागु छेनय् तयेमाः, अनंलि फुक्‍क खलकं वयात ल्‍वहँतं कय्‌काः स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","छं इस्राएलीतय्‌त थथे धा, ‘सुनानं थः परमेश्‍वरयात सराः बी, थुकिया निंतिं वं सजाँय फयेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","सुं मनुखं परमप्रभुया नांयात क्‍वह्यंकाः सराः बिल धाःसा वयात फुक्‍क खलकं ल्‍वहँतं कय्‌काः स्‍यायेमाः। स्‍वदेशी जुइमा वा परदेशी जुइमा सुनानं परमप्रभुया नांयात क्‍वह्यंकाः सराः बिल धाःसा वयात स्‍याना हे छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“‘सुनानं सुयातं स्‍यात धाःसा वयात नं स्‍याना हे छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","सुं मनुखं सुं मनूयाम्‍ह पशुयात स्‍यात धाःसा स्‍याःम्‍हय्‌सिनं पशुया थुवाःयात उकिया पलेसा बीमाः। ");
INSERT INTO new_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","हानं सुं मनुखं थः जःलाखःलायात घाःपाः यानाबिल धाःसा वं गथे याःगु खः वयात नं अथे हे यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","क्‍वँय् त्‍वथूगु दुसा उकिया पलेसा क्‍वँय् त्‍वथुलेगु, मिखाया पलेसा मिखा, वाया पलेसा वा। गथे वं सुयातं घाःपाः यानाब्‍यूगु दु वयात नं अथे हे यायेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","पशु स्‍याःम्‍हय्‌सिनं उकियागु पलेसा पुलेमाः। मनू स्‍याःम्‍हय्‌सित धाःसा स्‍याना हे छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","स्‍वदेशीया निंतिं व विदेशीया निंतिं नियम छगू हे जुइमाः। जि परमप्रभु छिमि परमेश्‍वर खः।’” ");
INSERT INTO new_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","मोशां इस्राएलीतय्‌त थ्‍व खँ धाल। अले इमिसं व सराः ब्‍यूम्‍हय्‌सित छाउनी पिने हयाः ल्‍वहँतं कय्‌काः स्‍यानाबिल। थथे परमप्रभुं मोशायात उजं बियादी थें इस्राएलीतय्‌सं यात। ");
INSERT INTO new_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","परमप्रभुं सीनै पर्वतय् मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“इस्राएलीतय्‌त थथे धा, ‘जिं छिमित बीगु देशय् वने धुंकाः अनयागु बुँनं परमप्रभुया निंतिं झासु लनेमाः। ");
INSERT INTO new_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","छिमिसं खुदँतक थःगु बुँइ प्‍यु, दाखमाया कचा न्‍हा, अले उकियागु फल खायेगु या। ");
INSERT INTO new_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","न्‍हय्‌दँय् धाःसा परमप्रभुया नामय् बुँयात झासु लने ब्‍यु। न्‍हय्‌दँय् छिमिसं बुँइ छुं नं पी मज्‍यू, दाखमाया कचा न्‍हाये मते। ");
INSERT INTO new_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","थ्‍व दँ छिमिगु बुँ व दाखमाया निंतिं झासु लनेगु ई खः। उकिं उबलय् छिमिगु बुँइ सःगु अन्‍न लये मज्‍यू अले दाख खाये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","उगु दँय् छिमिगु बुँइ थःथम्‍हं सःगु अन्‍न हे छिमिगु, छिमि च्‍यःभ्‍वातिं, ज्‍यामि व पिनें वयाः छिमिथाय् च्‍वनाच्‍वंपिं परदेशीतय्‌गु नसा जुइ। ");
INSERT INTO new_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","अथे हे छिमिसं लहिनातःपिं पशुत व जंगलय् च्‍वंपिं पशुतय्‌गु नं नसा जुइ। बुँइ सःगु फुक्‍कं नःसां ज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“‘छिमिसं न्‍हय्‌गू विश्रामदँ अथे धयागु न्‍हय्‌दुगं न्‍हय्‌दँ ल्‍याःखा, थ्‍व फुक्‍क ल्‍याःखाय् बलय् पिइगुंगूदँय् छकः ");
INSERT INTO new_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","न्‍हय्‌गूगु लाया झिन्‍हु खुन्‍हु, प्रायश्‍चितया दिंखुन्‍हु छिमिसं देशय् न्‍यंकं फैया नेकूया तुरही पुइकि। ");
INSERT INTO new_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","छिमिसं नेय्‌गुगू दँयात अर्पण यायेमाः। थ्‍व लुँदँय् देशय् न्‍यंकं स्‍वतन्‍त्रताया नाय्‌खिं च्‍वय्‌कि। थ्‍व दँय् देशय् दक्‍वसिनं थथःगु सम्‍पत्ति लिफ्‍याना काइ, अले दासत थथःगु छेँय् लिहां वनेमा। ");
INSERT INTO new_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","थ्‍व नेय्‌गुगू दँ छिमिगु निंतिं लुँदँ खः। थ्‍व दँय् छिमिसं छुं नं पी मते, अले अथें सयावःगु अन्‍न व दाख नं लये मते। ");
INSERT INTO new_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","थ्‍व दँ छिमिगु निंतिं पवित्र दँ खः। थ्‍व लुँदँय् छिमिसं बुँइ अथें बुयावःगु अन्‍न जक नइ। ");
INSERT INTO new_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“‘थ्‍व दँय् फुक्‍क मनूतय्‌सं थथःगु सम्‍पत्ति लिफ्‍याना काइ। ");
INSERT INTO new_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“‘थः जःलाखःलालिसे बुँ न्‍यायेगु मीगु यायेबलय् छम्‍हं मेम्‍हय्‌सित क्‍वाये मते। ");
INSERT INTO new_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","बुँया भाः क्‍वःछीबलय् लुँदँ धुंकाः बुँज्‍या यायेगु ईया ल्‍याः तयाः क्‍वःछ्यु। लिपा वइगु लुँदँ तक ग्‍वदँतक जमिनं अन्‍न सय्‌के फइ, वकथं जमिनया मू क्‍वःछ्यु। ");
INSERT INTO new_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","गुलि अप्‍वः दँ ल्‍यंदनि बुँया भाः नं उलि हे अप्‍वइ, अले गुलि कम दँ ल्‍यं दइ, उलि हे बुँया भाः नं कम जुइ। छाय्‌धाःसा बालीया ल्‍याखं बुँया न्‍यायेमीगु ज्‍या जुइगु खः। ");
INSERT INTO new_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","छिमिसं छम्‍हं मेम्‍हय्‌सित क्‍वाये मते। परमप्रभुया ग्‍याःभय का। छाय्‌धाःसा जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“‘छिमिसं परमेश्‍वरं धाःथें या। अले छिपिं व देशय् सुरक्षित जुयाः म्‍वानाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","बुं अन्‍न सय्‌की, अले छिमिसं थःपिन्‍त छु माल व नयेखनी। अले छिपिं सुरक्षित जुयाः म्‍वानाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","सुनानं न्‍हय्‌गूगु दँय् छुं हे मप्‍युसे वा छुं लया महसे छु नयाच्‍वनेगु धकाः न्‍यनेफु। ");
INSERT INTO new_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","जिं खुगूगु दँय् छिमिथाय् थःगु आशिष छ्वयाहये, अले उगु दँय् स्‍वदँयात गाक्‍क बुं अन्‍न बी। ");
INSERT INTO new_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","छिमिसं च्‍यादँय् बुँइ पीबलय् पुलांगु हे बाली नयाच्‍वने दइ। गुँदँय् बाली लयेबलय् तकं छिमिसं पुलांगु हे बाली नयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“‘छिमिगु जग्‍गा जमिनया छुं नं ब्‍व न्‍ह्याबलेंया निंतिं मी मते छाय्‌धाःसा जग्‍गा जमिन जिगु खः। छिमित ला थ्‍व ज्‍यायेत जक बियातयागु खः। ");
INSERT INTO new_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","छिमिगु थःगु सम्‍पत्ति न्‍यायेमिइ यायेबलय् न्‍ह्याबलें लिफ्‍याये फइकथं म्‍यु। ");
INSERT INTO new_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“‘सुं नं इस्राएलीं गरीब जुयाः थःगु पुर्खौली सम्‍पत्ति मिल धाःसा वया दक्‍वसिबय् सत्तीम्‍ह थःथितिं वयाः व सम्‍पत्ति लिफ्‍याना कायेमाः। ");
INSERT INTO new_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","सुयां लिफ्‍यानाबीपिं सुं मनू मदुसा, अले व थः हे तःमि जुयाः लिफ्‍याये फत धाःसा ");
INSERT INTO new_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","वं मेगु लुँदँ तक ल्‍यंदनिगु दँया बालीया धिबा पुलाः थःगु सम्‍पत्ति लिफ्‍याना काये फइ। लेवीतय्‌सं नं न्‍ह्यागु हे इलय् इमित ब्‍यूगु लेवीतय्‌गु शहरय् च्‍वंगु छेँ लिफ्‍याना काये फु। ");
INSERT INTO new_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","वं अथे लिफ्‍याना काये मफुत धाःसा लुँदँ तक सम्‍पत्ति न्‍यानाकाःम्‍हय्‌सिगु हे ल्‍हातिइ लानाच्‍वनी। अले लुँदँबलय् सम्‍पत्ति धात्‍थेंम्‍ह थुवाःयात लित वनी। ");
INSERT INTO new_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“‘सुनानं पःखाः दुनेया शहरय् छेँ मिल धाःसा वं दच्‍छिया दुने थःगु छेँ लिफ्‍याना कायेफइ। ");
INSERT INTO new_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","दच्‍छिया दुने लिफ्‍याना काये मफुत धाःसा वं थःगु छेँ सदांया लागि लिफ्‍याना काये फइ मखु। वयागु छेँ सदांया लागि न्‍यानाकाःम्‍ह व वया पुस्‍तौं पुस्‍तायागु जुइ। लुँदँबलय् नं वं छेँ लिफ्‍याना काये दइ मखु। ");
INSERT INTO new_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","पःखाः पिनेया गांया छेँ धाःसा बुँ थें हे जुइ। छेँ थुवालं अज्‍याःगु छेँ लिफ्‍याना काये फइ। अले लुँदँबलय् लितबीमाः। ");
INSERT INTO new_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“‘लेबीतय्‌सं नं इमिगु अधिकारया शहरया छेँ न्‍ह्यागु इलय् नं लिफ्‍याना काये फु। ");
INSERT INTO new_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","छुं जुयाः इमिसं थःगु छेँ लिफ्‍याना काये मफुत धाःसा लुँदँबलय् इमित इमिगु सम्‍पत्ति लितबीमाः। छाय्‌धाःसा लेवीतय्‌गु शहरया छेँ इमित सदांया लागि बियातःगु खः। ");
INSERT INTO new_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","इमिसं शहरं पिनेया थःपिनिगु घाँय्‌ख्‍यः धाःसा मी दइ मखु। छाय्‌धाःसा व इमिगु न्‍ह्याबलेंया सम्‍पत्ति खः। ");
INSERT INTO new_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“‘छिमि सुं इस्राएली दाजुकिजा तसकं चीमि जुयाः थःम्‍हं थःत हे लहीमफया च्‍वन धाःसा छिमिसं इमित पिनें वयाच्‍वंपिन्‍त थें ग्‍वाहालि या। थुकिं इपिं छिपिंनापं तुं च्‍वनाच्‍वने फयेमा। ");
INSERT INTO new_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","इमित त्‍यासा ब्‍यूसां उकिया ब्‍याज काये मते। छिमिसं थः परमेश्‍वरया ग्‍याःभय का। अले थः इस्राएली दाजुकिजापिन्‍त थःनापं ति। ");
INSERT INTO new_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","छिमिसं इमित ब्‍याजय् धिबा बी मते। अले नसा म्‍यूसां लबः कयाः मी मते। ");
INSERT INTO new_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","छिमित कनान देश बीत व छिमि परमेश्‍वर जुइत मिश्र देशं छिमित पितहयाम्‍ह जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“‘छिमि सुं इस्राएली दाजुकिजां तसकं चीमि जूगुलिं थःत छिमिगु ल्‍हातिइ मिल धाःसा वयात दासयात थें ज्‍या याके मते। ");
INSERT INTO new_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","व छिमिथाय् ज्‍यालाज्‍यामि वा पिनें वयाः च्‍वंवःम्‍ह थें च्‍वनी। लुँदँ तक वं छिमिथाय् ज्‍या याइ। ");
INSERT INTO new_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","उबलय् व थः मचाखाचानापं छिमिथासं थः छेँजःपिन्‍थाय् व थःगु सम्‍पत्ति दुथाय् लिहांवनी। ");
INSERT INTO new_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","छाय्‌धाःसा इस्राएलीत जिमि दासदासीत खः। इमित जिं मिश्र देशं पित हयागु खः। इमित दासतय्‌त थें न्‍यायेमिइ याये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","छिमिसं इमित बांमलाःगु व्‍यवहार याये मते, बरु परमेश्‍वरया ग्‍याःभय का। ");
INSERT INTO new_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“‘छिमित दासदासीत माःसा छिमि जःखः च्‍वंपिं मेगु जातिया मनूतय्‌त न्‍यानाहये फु। ");
INSERT INTO new_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","छिमिसं छिमिथाय् पिनें च्‍वंवयाच्‍वंपिं परदेशीतय्‌त नं न्‍यानाः दासदासीत दय्‌के फु। अले छिमिगु देशय् बूपिं इमि मस्‍तय्‌त नं न्‍यानाः थःगु सम्‍पत्ति याये फु। ");
INSERT INTO new_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","छिमिसं इमित थः मस्‍तय्‌त नं थःगु सम्‍पत्ति थें लःल्‍हाये ज्‍यू, अले मसीतले दास तये ज्‍यू। थः इस्राएली दाजुकिजायात धाःसा बांमलाःगु व्‍यवहार याये मते। ");
INSERT INTO new_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“‘छुं जुयाः छिमिथाय् पिनें च्‍वंवयाच्‍वंम्‍ह मनू तःमि जुल, अले छिमि हे देशय् च्‍वंपिं दाजुकिजां चीमि जुयाः थःत वयागु ल्‍हातिइ मिल धाःसा ");
INSERT INTO new_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","इमित हाकनं लिफ्‍यानाः हये फु। वया हे दाजुकिजा मध्‍ये सुनानं वयात लिफ्‍याये फु। ");
INSERT INTO new_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","वया थः कका वा तःबा, कका वा तःबाःया काय्‌पिं व सत्तीक थःलाःपिं सुनानं नं वयात लिफ्‍याये फु। अले व मनुखं लिपा थःके धिबा दत धाःसा थःम्‍हं थःत नं लिफ्‍याये फु। ");
INSERT INTO new_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","व मनुखं थःत म्‍यूगु इलंनिसें लुँदँतकया ई ल्‍याः खानाः व ई तकया ज्‍यामिया ज्‍यालाया ल्‍याखं धिबा पुलाः थःत थःम्‍हं लिफ्‍याये फु। ");
INSERT INTO new_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","लुँदँ वयेत यक्‍व ई ल्‍यं दनिसा वं थःत लिफ्‍यायेत अप्‍वः धिबा पुलेमाः। ");
INSERT INTO new_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","लुँदँ वयेत कम जक ई ल्‍यं दनिसा कम हे जक धिबा पुसा गाः। ");
INSERT INTO new_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","वयात वया मालिकं ज्‍याला ज्‍यामियात थें जक व्‍यवहार यायेमाः। अले वयात वया मालिकं उकथं व्‍यवहार याः ला कि मयाः धकाः छिमिसं च्‍यूताः कायेमाः। ");
INSERT INTO new_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“‘छुं जुयाः वं गुकथं नं थःत लिफ्‍याये मफुत धाःसा लुँदँबलय् व अले वया मस्‍त थःथम्‍हं मुक्त जुइ। ");
INSERT INTO new_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","छाय्‌धाःसा इस्राएलीत जिमि दासदासीत खः। जिं हे इमित मिश्र देशं पित हयागु खः। जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“‘जि छिमि परमप्रभु परमेश्‍वर खः, अथे जुयाः छिमिसं थःगु लागि मूर्तित दय्‌के मज्‍यू। अले थःगु निंतिं पुजा यायेत गुगु नं झ्‍वाता, कियातःगु सिँया झ्‍वाता, ल्‍वहंया थां वा कियातःगु ल्‍वहं थने मज्‍यू। ");
INSERT INTO new_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“‘छिमिसं विश्रामबार हनेमाः, अले जिगु नापलायेगु पालयागु हनाबना तयेमाः। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“‘छिपिं जिगु नियमकथं न्‍हेज्‍यात धाःसा अले जिगु विधियात मानय् यात धाःसा, ");
INSERT INTO new_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","जिं छिमिगु निंतिं पाय्‌छि इलय् वा वयेकाबी, गुकें यानाः बुँइ बाली सयावइ अले ख्‍यलय् च्‍वंगु सिमाय् फल सयावइ। ");
INSERT INTO new_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","दाख मुनेगु ईतक छिमिसं बाली लयेगु ज्‍या याना हे च्‍वनी। अन्‍न पीगु इलय् नं छिमिसं दाख खानाच्‍वनी। छिमिसं लुधंक नयेखनी। छिपिं थःगु देशय् याउँक च्‍वनी। ");
INSERT INTO new_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“‘जिं छिमिगु देशय् शान्‍ति बी। छिपिं याउँक द्येने फइ। अले छिमित ख्‍याइपिं सुं दइ मखु। जिं देशं ग्‍यानापुपिं पशुत ख्‍याना छ्वये, अले छिमिगु देशय् लडाइँ जुइ मखु। ");
INSERT INTO new_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","छिमिसं थःपिनि शत्रुतय्‌त लिनाः तरवारं स्‍याये फइ। ");
INSERT INTO new_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","छिमि न्‍याम्‍हय्‌सिनं सच्‍छिम्‍हय्‌सित व सच्‍छिम्‍हय्‌सिनं झिद्वः मनूतय्‌त बुके फइ। छिमि शत्रुत छिमिगु तरवारं सिनावनी। ");
INSERT INTO new_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“‘जिं थःगु ख्‍वाः छिपिं पाखे स्‍वय्‌के, अले छिमित बांलाक ब्‍वलंकाः छिमिगु ल्‍याः अप्‍वय्‌काबी अले छिपिंनापं चिनातयागु बाचा पूवंकाबी। ");
INSERT INTO new_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","छिमिसं न्‍हूगु बाली लये धुंकाः नं पुलांगु बाली नयाच्‍वनी। अले न्‍हूगु बालीया लागिं पुलांगु बाली लिकयाः छ्वये माली। ");
INSERT INTO new_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","जि छिमिगु दथुइ थःगु हे पवित्र पालय् च्‍वंवये अले जिं छिमित मयय्‌के मखु। ");
INSERT INTO new_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","जि छिपिंनापं हे च्‍वनाच्‍वने, अले छिमि परमेश्‍वर जुयाच्‍वने, छिपिं धाःसा जिमि मनूत जुइ। ");
INSERT INTO new_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","जि छिमित मिश्र देशं पितहयाम्‍ह परमप्रभु छिमि परमेश्‍वर खः। छिपिं मिश्रीतय् दास जुयाच्‍वने मज्‍यू धकाः जिं छिमित मिश्रं पित हयागु खः। जिं छिमित झ्‍यातुगु कु लिकयाः छ्यं धस्‍वाकाः जुइपिं यानागु दु। ");
INSERT INTO new_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“‘तर छिमिसं जिगु नियम मानय् मयात धाःसा, जिगु खँ मन्‍यन धाःसा, ");
INSERT INTO new_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","जिगु नियमयात क्‍वह्यंकल धाःसा अले जिनापं चिनातःगु बाचा त्‍वथुल धाःसा, ");
INSERT INTO new_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","जिं नं छिमिथाय् आकाझाकां भय छ्वयाहये, अले म्‍ह सुकुगना वनीगु, मिखायात स्‍यंकीगु, ग्‍यानपुसे च्‍वंगु ल्‍वय् छ्वयाहये। छिमिसं ह्वलातःगु पुसा अथें सितिं वनी छाय्‌धाःसा छिमि शत्रुतय्‌सं बाली नयाबी। ");
INSERT INTO new_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","जिं थःगु ख्‍वाः फस्‍वय्‌के। गुकें यानाः छिपिं शत्रुतय्‌गु ल्‍हातिं बुइ। छिमित हेपय् याइपिन्‍सं छिमित शासन याइ, सुनानं लिनाच्‍वंगु मदुसां छिपिं बिस्‍युं वनाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“‘थुलि जुइ धुंकाः नं छिमिसं जिगु खँ मन्‍यन धाःसा जिं छिमित पापया न्‍हय्‌दुगं अप्‍वः सजाँय बी। ");
INSERT INTO new_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","जिं छिमिगु घमण्‍ड चुंचुं याये। छिमिगु च्‍वय्‌यागु आकाश नँ थें व छिमिगु क्‍वय्‌या जमिन कँय् थें याये। ");
INSERT INTO new_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","छिमिसं यक्‍व ज्‍या याःसां सितिं वनी छाय्‌धाःसा छिमिगु बुँइ अन्‍न सइ मखु। अले सिमाय् फल नं सइ मखु। ");
INSERT INTO new_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“‘छिपिं जिगु विरोधय् वना हे च्‍वन धाःसा अले जिं धा थें मयात धाःसा छिमिसं याःगु पापया हानं न्‍हय्‌दुगं अप्‍वः सास्‍ती छिमिथाय् छ्वया हये। ");
INSERT INTO new_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","अले जिं छिमिगु दथुइ गुँपशु छ्वया हये। इमिसं छिमि मस्‍तय्‌त नयाबी। अले छिमि लहिनातःपिं पशुतय्‌त स्‍यानाबी। छिमिगु ल्‍याः थुलि कम जुइकि छिमिगु लँपुइ जुइपिं मनूत हे दइ मखु। ");
INSERT INTO new_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“‘थ्‍व तःधंगु सजाँय जुइ धुंकाः नं छिपिं जिपाखे मवल धाःसा अले जिगु विरोधय् वन धाःसा ");
INSERT INTO new_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","जि नं छिमिगु विरोधय् वने, अले छिमिगु पापया लागिं जिं न्‍हय्‌दुगं अप्‍वः सजाँय बी। ");
INSERT INTO new_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","छिमिसं जिगु बाचा त्‍वथूगुलीं जिं धात्‍थें हे छिमित सजाँय बी, अले गुबलय् छिपिं थथःगु शहरय् मुनाच्‍वनी, जिं छिमिगु दथुइ ल्‍वय् छ्वया हये। छिमित शत्रुतय्‌गु ल्‍हातय् बी। ");
INSERT INTO new_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","अथे जूगुलिं जिं छिमिथाय् अन्‍न वय्‌केबी मखु। उबले झिम्‍ह मिसां छगू हे भुतुलिइ मरि छुइ। अले इमिसं छिमित नयेत बीबलय् सुयातं गाइ मखु। ");
INSERT INTO new_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“‘थ्‍व फुक्‍क जुयाः नं छिमिसं जिगु खँ मन्‍यन धाःसा जिगु विरोधय् वन धाःसा, ");
INSERT INTO new_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","जि तंचायाः छिमिगु विरोधय् वने, अले छिमिगु पापया लागिं जिं छिमित हानं न्‍हय्‌दुगं अप्‍वः सजाँय बी। ");
INSERT INTO new_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","छिमिसं थः हे काय् म्‍ह्याय्‌पिनिगु ला नयेमाली। ");
INSERT INTO new_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","जिं छिमिगु पुजा यायेगु देगःचात स्‍यंकाबी, अले छिमिगु धुपाँय्‌ च्‍याकेगु मकःयात नं स्‍यंकाबी, अले छिमिगु सीम्‍हयात उपिं जीवन मदुगु मूर्तितय्‌गु द्यःने तयाबी। जिं स्‍वइबलय् छिपिं घचाइपुसे च्‍वंपिं जुइ धुंकूगु दु। ");
INSERT INTO new_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","जिं छिमिगु शहरत नाश यानाबी, छिमिगु पुजा यायेगु थाय्‌यात भज्‍यंक स्‍यंकाबी, अले छिमिसं ब्‍यूगु नस्‍वाः वःगु बलि नालाकाये मखु। ");
INSERT INTO new_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","जिं देशयात नाश यानाबी। थ्‍व फुक्‍क खनाः अन च्‍वंवंपिं छिमि शत्रुत अजू चाइ। ");
INSERT INTO new_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","जिं छिमित जाति जातिया दथुइ छ्यालब्‍याल यानाबी, अले तरवारं छिमित लिना च्‍वनी। छिमिगु देश झिजांमिजां दनी अले शहरत भज्‍यंक स्‍यनी। ");
INSERT INTO new_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","गबले तक छिपिं शत्रुतय्‌गु देशय् च्‍वनाच्‍वनी, उबलय्‌तक छिमिगु थःगु देशं विश्राम काइ। देशं थःगु आरामया ई हनी। ");
INSERT INTO new_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","छाय्‌धाःसा बुँयात बीमाःगु न्‍हय्‌दँया झासु लनेगु ई छिमिसं थःगु बुँयात मब्‍यूगुलिं आः धाःसा झिजामिजा दंगु बुँनं झासु लनेगु ई काइ। ");
INSERT INTO new_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“‘छिपिं म्‍वानाच्‍वंपिं, शत्रुतय्‌गु देशय् छिमिसं लप्‍ते हः कुतुवंगु सः ताइबलय् नं छिपिं तरवारं ल्‍यू वःगु धकाः ग्‍यानाः बिस्‍युं वनी। ल्‍यूवःपिं सुं मदुसां छिपिं बँय् क्‍वदइ। ");
INSERT INTO new_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","सुनां ल्‍यू मवःसां छिपिं तरवार खनाः ग्‍यानाः बिस्‍युं वंपिं थें हे थःथवय् धक्‍का नयाः ग्‍वतुली। अथे जुयाः छिमि शत्रुतय्‌गु न्‍ह्यःने छिपिं दने फइ मखु। ");
INSERT INTO new_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","अले छिपिं मेगु जातितय्‌गु दथुइ नाश जुइ। छिमि शत्रुतय् देशं छिमित नयाबी। ");
INSERT INTO new_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","छिपिं मध्‍ये ल्‍यंदुपिं धाःसा शत्रुतय्‌गु देशय् थःगु व थः पुर्खातय्‌गु पापया हुनिं ध्‍वग्‍गिनावनी। ");
INSERT INTO new_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“‘थःम्‍हं व थः पुर्खातय्‌सं याःगु पाप व जिगु विरोधय् याःगु विश्‍वासघात व जि प्रति क्‍यंगु दुश्‍मनी मानय् यात धाःसा, ");
INSERT INTO new_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","इमिगु विरोधय् वनाः जिं इमित शत्रुतय्‌गु देशय् हःगु खः धकाः इमिसं छाःगु नुगःयात क्‍वमिलु यानाः पापया मू पुल धाःसा ");
INSERT INTO new_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","उबलय् जिं याकूबनापं चिनातयागु बाचा लुमंके। अले इसहाक नापं चिनातयागु बाचा व अब्राहामनापं चिनातयागु बाचा नं लुमंके। नापं जिं देशयात नं लुमंके। ");
INSERT INTO new_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","इमिसं देश त्‍वःतल, इपिं मदय्‌कं नं देशं झासु लनेगु ई हनाच्‍वनी। लिपतय् इमिसं थःगु अर्धमयागु सजाँययात स्‍वीकार याइ छाय्‌धाःसा इमिसं जिगु नियम व विधि मानय् मयाःगु खः। अले इमिसं जिगु विधियात तसकं मय्‌कल। ");
INSERT INTO new_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","थुलि जुयाः नं जिं शत्रुतय्‌गु देशय् च्‍वना च्‍वंसां इमित त्‍वःते मखु। अले इपिं नापं चिनातयागु बाचा नं त्‍वथुले मखु। इमित मयय्‌काः नाश याये नं मखु। छाय्‌धाःसा जि इमि परमप्रभु परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","तर जिं इमिगु लागिं इमि पुर्खातनापं चिनातयागु बाचा लुमंके। जि हे इमि परमेश्‍वर खः धकाः म्‍हसीकेत मेगु जातिं खंक हे इमित मिश्र देशं पित हयागु खः।’” ");
INSERT INTO new_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","परमप्रभुं इस्राएलीतय्‌गु निंतिं सीनै पर्वतय् मोशायात बियादीगु विधि, नियम व व्‍यवस्‍था थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“इस्राएलीतय्‌त धा, ‘सुं मनुखं भाकल पूवंकेत परमेश्‍वरयात सुं मनू देछाल धाःसा व मनूयागु मू थुकथं क्‍वःछ्यु। ");
INSERT INTO new_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","व मिजं निइदँनिसें खुइदँतकयाम्‍ह जूसा वयागु मू पवित्र पालयागु शेकेलकथं वहःयागु नेय्‌गू शेकेल जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","अले मिस्‍तय्‌गु मू धाःसा स्‍विगू शेकेल जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","न्‍यादँ निसें निइदँ तकयाम्‍ह मिजंया मू वहःया निइगू शेकेल व मिस्‍तय्‌गु मू धाःसा झिगू वहःया शेकेल जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","“‘लच्‍छि निसें न्‍यादँ तकयाम्‍ह मिजं मचाया मू वहःया न्‍यागू शेकेल, अले मिसा मचायागु मू धाःसा स्‍वंगू शेकेल जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","खुइदँ स्‍वयाः अप्‍वः दँ दये धुंकूम्‍ह मिजंया मू झिंन्‍यागू वहःया शेकेल व मिस्‍तय्‌गु मू धाःसा झिगू शेकेल जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","सुं मनुखं क्‍वःछ्यूगु मू पुले मफुत धाःसा अर्पण जुइम्‍ह मनूयात पुजाहारीयाथाय् हयेमाः। अले पुजाहारीं भाकल याःम्‍ह मनुखं मू पुले फइगुकथं क्‍वःछियेमाः। ");
INSERT INTO new_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“‘व भाकल परमप्रभुयात छाये ज्‍यूम्‍ह पशु खःसा व परमप्रभुयात छाःम्‍ह पशु पवित्र थहरय् जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","परमप्रभुयात छायेत भाकलयाम्‍ह पशुयात गुगुकथं नं महिलेमाः। वं बांलाःम्‍ह पशुयात बांमलाःम्‍ह पशुलिसें अले बांमलाःम्‍ह पशुयात बांलाःम्‍ह पशुलिसे महिलेमाः। वं भाकलयाम्‍ह पशुया पलेसा मेम्‍ह पशु छाल धाःसा निम्‍हं पशु पवित्र जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","व छाये मज्‍यूम्‍ह अशुद्ध पशु खःसा व पशुयात पुजाहारीयाथाय् हयेमाः। ");
INSERT INTO new_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","बांलाःम्‍ह पशु जूसां बांमलाःम्‍ह जूसां पुजाहारीं वया मू क्‍वःछिनाबीगु। अले पुजाहारीं गुलि मू तल उलि हे वया मू जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","व मनुखं मू पुलाः पशुयात लिफ्‍याइगु खःसा, क्‍वःछीगु मुलय् मेगु न्‍याब्‍वय् छब्‍व तनाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“‘सुनानं परमप्रभुयात थःगु छेँ देछाल धाःसा पुजाहारीं व छेँ बांलाः वा बांमलाः स्‍वयाः उकिया मू क्‍वःछिना बीमाः। पुजाहारीं गुलि क्‍वःछित उकिया मू उलि हे जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","तर छाःम्‍हय्‌सिनं मू पुलाः व लिफ्‍यायेगु इच्‍छायात धाःसा, क्‍वःछीगु मुलय् मेगु न्‍याब्‍वय् छब्‍व तनाः वं बीमाः। अले व छेँ हानं वयागु हे जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“‘सुनानं थः पुर्खाया सम्‍पत्तिया छुं ब्‍व परमप्रभुया निंतिं छाल धाःसा उकी गुलि पुसा वनी वःकथं उकिया मू क्‍वःछ्यु। गथेकि छगू होमेर तछ्वया पुसा वनीगु बुँया नेय्‌गू वहःयागु शेकेल। ");
INSERT INTO new_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","वं लुँदँ हनीगु नखःया दँनिसें हे थःगु बुँ छायेगु खःसा उकियागु मू पुजाहारीं क्‍वःछीगुकथं हे जुइमाः। ");
INSERT INTO new_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","तर वं थःगु बुँ लुँदँ हनीगु नखःया दँ लिपा छायेगु खःसा, मेगु नखःया दँ वयेत गुलि ल्‍यंदनि पुजाहारीं वःकथं हे उकिया मू ति। अले क्‍वःछीगु मुलय् व क्‍वकायाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","व बुँ छाःम्‍हय्‌सिनं हे मू पुलाः लिफ्‍याइगु खःसा क्‍वःछीगु मुलय् मेगु न्‍याब्‍वय् छब्‍व तनाबीमाः। अले व वयागु हे जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","तर वं व जमिन मू पुलाः लिमफ्‍याइगु धाःसा वा मेम्‍ह सुं मनूयात व बुँ मिल धाःसा वं गुबलय् नं उकियात लिफ्‍याना काये फइ मखु। ");
INSERT INTO new_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","व बुँ लुँदँया नखःया दँय् स्‍वतन्‍त्र जुइबलय् देछाःगु बुँ थें व परमप्रभुया निंतिं पवित्र जुइ। व पुजाहारीया हे सम्‍पत्ति थहरय् जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“‘सुं मनुखं बुँ देछाल धाःसा, गुगु बुँ न्‍यानाकाःगु खः थः पुर्खायागु मखु, ");
INSERT INTO new_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","पुजाहारीं लुँदँया नखःया दँ ल्‍याःखनाः उकिया गुलि मू क्‍वःछी वं परमप्रभुया निंतिं पवित्र भाःपियाः उखुन्‍हु हे क्‍वःछ्यूगु मू बीमाः। ");
INSERT INTO new_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","लुँदँया नखःया दँय् व बुँ छाःम्‍हय्‌सिनं सुयाके न्‍यानाकाःगु खः अले व बुँ सुयागु पुर्खौली सम्‍पत्ति खः वयात हे लितबीमाः। ");
INSERT INTO new_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","क्‍वःछ्यूगु मू फुक्‍कं पवित्र पालया वहःया शेकलकथं जुइमाः। निइगू गेराया छगू शेकेल खः। ");
INSERT INTO new_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“‘पशुतय्‌सं बुइकूम्‍ह न्‍हापायाम्‍ह मचा, सा वा द्वहंया जुइमा वा फैया जुइमा, इपिं न्‍हापांनिसें हे परमप्रभुया खः, वयात धाःसा देछाये मते। ");
INSERT INTO new_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","व अशुद्ध पशुं दकलय् न्‍हापा बुइकूम्‍ह खःसा क्‍वःछ्यूगु मुलय् हानं मेगु न्‍याब्‍वय् छब्‍व मू तनाः उकियात लिफ्‍याना कायेमाः। तर मू पुलाः लिफ्‍याइगु मखुसा क्‍वःछ्यूगु मुलय् मिया छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“‘तर परमप्रभुया निंतिं देछाःम्‍ह मनू, पशु वा थः पुर्खाया जमिन मी फइ मखु, अले देछाये नं फइ मखु। देछाःगु फुक्‍कं परमप्रभुया निंतिं तसकं पवित्र खः। ");
INSERT INTO new_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","मनूत मध्‍ये सुं मनूयात स्‍यायेगु लागिं देछाःगु खःसा वयात मू पुलाः लिफ्‍याये मज्‍यू। वयात स्‍याना हे छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“‘थुकथं बुँयागु अन्‍न व सिमाया फलयागु झिब्‍वय् छब्‍व परमप्रभुयागु हे खः अले व परमप्रभुया निंतिं पवित्र खः। ");
INSERT INTO new_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","अले सुनां झिब्‍वय् छब्‍वयागु छुं मू पुलाः लिफ्‍याइगु खःसा वं उकियागु न्‍याब्‍वय् छब्‍व तनाबीमाः। ");
INSERT INTO new_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","पशुत ल्‍याः खाइगु कथिया क्‍वय् जुयावनीपिं बथांयापिं सा द्वहं, फै दुगुचा झिम्‍हय् छम्‍ह परमप्रभुया निंतिं पवित्र जुइ। ");
INSERT INTO new_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","भिंम्‍ह वा मभिंम्‍ह पशु वं छुतय् याये मज्‍यू व हिले नं मज्‍यू। हिलेगु हे खःसा ह्यूपिं निम्‍हं हे पशु पवित्र जुइ। व मू पुलाः इमित लिफ्‍यने फइ मखु।’” ");
INSERT INTO new_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","परमप्रभुं इस्राएलीतय्‌गु निंतिं सीनै पर्वतय् मोशायात बियादीगु आज्ञा थुपिं हे खः।");
INSERT INTO new_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","इस्राएलीत मिश्र देशं पिहां वंगु निगूगु दँया निगूगु लाया न्‍हापांगु दिंखुन्‍हु सीनैया मरुभूमिइ पवित्र पालय् परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“इस्राएलया फुक्‍क खलःयात वंश व परिवारकथं ल्‍याःखा। छम्‍ह छम्‍ह मिजंतय्‌गु नां धलः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","छ व हारूनं निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं मिजंतय्‌त पुचः पुचःकथं ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","छगू छगू कुलं छम्‍ह छम्‍ह मनुखं छिमित ग्‍वाहालि यायेमाः। इपिं थथःगु परिवारया थकालि जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“छिमित ग्‍वाहालि बीपिनिगु नां थथे दु, “रूबेन कुलपाखें शदेऊरया काय् एलीसूर ");
INSERT INTO new_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","शिमियोन कुलपाखें सूरीशद्दैया काय् शलूमीएल ");
INSERT INTO new_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","यहूदा कुलपाखें अम्‍मीनादाबया काय् नहशोन ");
INSERT INTO new_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","इस्‍साखार कुलपाखें सूआरया काय् नतनेल ");
INSERT INTO new_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","जबूलून कुलपाखें हेलोनया काय् एलीआब ");
INSERT INTO new_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","योसेफया काय्‌पिं एफ्राइम कुलपाखें अम्‍मीहूदया काय् एलीशामा मनश्‍शे कुलपाखें पदासूरया काय् गमलिएल ");
INSERT INTO new_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","बेन्‍यामीन कुलपाखें गिदेओनीया काय् अबीदान ");
INSERT INTO new_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","दान कुलपाखें अम्‍मीशद्दैया काय् अहीएजेर ");
INSERT INTO new_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","आशेर कुलपाखें ओक्रानया काय् पगीएल ");
INSERT INTO new_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","गाद कुलपाखें दूएलया काय् एल्‍यासाप ");
INSERT INTO new_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","नप्‍ताली कुलपाखें एनानया काय् अहीरा।” ");
INSERT INTO new_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","खलःपाखें ल्‍यःपिं थथःगु पुर्खौली कुलया नायःत थुपिं हे खः। इपिं इस्राएलया वंशया नायःत खः। ");
INSERT INTO new_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","च्‍वय् नां च्‍वयातःपिं मनूतय्‌त मोशा व हारूनं काल, ");
INSERT INTO new_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","अले निगूगु लाया न्‍हापांगु दिंखुन्‍हु फुक्‍क खलःयात मुंकाः इमिगु वंश व छेँजःकथं निइदँ व वस्‍वयां च्‍वय्‌यापिं मिजंतय्‌गु नां धलः दय्‌कल, ");
INSERT INTO new_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","परमप्रभुं मोशायात उजं बियादीगु थें। मोशां सीनैया मरुभूमिइ इमित ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","इस्राएलया तःधिकःम्‍ह काय् रूबेनया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व छेँजःकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","रूबेनया कुलयापिं ल्‍याःखाःपिं मिजंत ४६,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","शिमियोनया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","शिमियोनया कुलयापिं ल्‍याःखाःपिं मिजंत ५९,३०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","गादया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","गादया कुलयापिं ल्‍याःखाःपिं मिजंत ४५,६५० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","यहूदाया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","यहूदाया कुलयापिं ल्‍याःखाःपिं मिजंत ७४,६०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","इस्‍साखारया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","इस्‍साखारया कुलयापिं ल्‍याःखाःपिं मिजंत ५४,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","जबूलूनया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","जबूलूनया कुलयापिं ल्‍याःखाःपिं मिजंत ५७,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","योसेफया काय्‌पिंपाखें – एफ्राइमया सन्‍तानया निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","एफ्राइमया कुलयापिं ल्‍याःखाःपिं मिजंत ४०,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","मनश्‍शेया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","मनश्‍शेया कुलयापिं ल्‍याःखाःपिं मिजंत ३२,२०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","बेन्‍यामीनया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","बेन्‍यामीनया कुलयापिं ल्‍याःखाःपिं मिजंत ३५,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","दानया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वने फुपिँ फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","दानया कुलयापिं ल्‍याःखाःपिं मिजंत ६२,७०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","आशेरया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","आशेरया कुलयापिं ल्‍याःखाःपिं मिजंत ४१,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","नप्‍तालीया सन्‍तानपाखें – निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं फुक्‍क मिजंतय्‌गु नां इमिगु वंश व परिवारकथं धलखय् च्‍वल। ");
INSERT INTO new_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","नप्‍तालीया कुलयापिं ल्‍याःखाःपिं मिजंत ५३,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","मोशा, हारून व थथःगु परिवारया इस्राएलीतय् झिंनिम्‍ह कुलनायःतय्‌सं मनूतय्‌त ल्‍याः खात अले इमिगु ल्‍याः थुलि हे खः। ");
INSERT INTO new_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं इस्राएलीतय्‌त इमिगु वंश व छेँजःकथं ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","इमिगु मुक्‍क ल्‍याः ६,०३,५५० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","लेवीया सन्‍तानयात धाःसा मेपिं नापं ल्‍याः मखाः। ");
INSERT INTO new_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","छाय्‌धाःसा परमप्रभुं मोशायात थथे धयादीगु खः, ");
INSERT INTO new_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“लेवीया कुलयात धाःसा छं ल्‍याः खाये मते। इस्राएलीतनापं इमित ल्‍याः खाये मते। ");
INSERT INTO new_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","उकिया पलेसा छं लेवीतय्‌त पवित्र पाल व उकी दुने च्‍वंगु फुक्‍क ज्‍वलंया जिम्‍मा ब्‍यु। छिमिसं थाय् हिलाजुइबलय् इमिसं पवित्र पाल व फुक्‍क ज्‍वलं क्‍वबीमाः। इमिसं व बांलाक स्‍वयेमाः, अले नापलायेगु पालया जवंखवं पाल ग्‍वयाः च्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","थाय् हिलेबलय् लेवीतय्‌सं हे पवित्र पाल क्‍वकायेगु यायेमाः अले लेवीतय्‌सं हे व धस्‍वाकेगु यायेमाः। पवित्र पालयात न्‍ह्यःने वने मत्‍यःम्‍ह सुं वन धाःसा वयात स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","इस्राएलीतय्‌सं थथःगु छाउनीइ, थथःगु झण्‍डाया न्‍ह्यःने पाल ग्‍वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","लेवीतय्‌सं हे नापलायेगु पालया रक्षा यायेमाः। अले जिगु तं इस्राएलया खलःयात मलायेमा धकाः लेवीतय्‌सं हे नापलायेगु पालया जवंखवं थःपिनिगु पाल ग्‍वयाः च्‍वनेमाः।” ");
INSERT INTO new_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","परमप्रभुं मोशायात बियादीगु उजंकथं हे इस्राएलीतय्‌सं फुक्‍क यात। ");
INSERT INTO new_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“इस्राएलीतय्‌सं नापलायेगु पालया प्‍यखेरं भचा तापाक थथःपिनिगु परिवारया झण्‍डा क्‍वय् थथःगु थासय् पाल ग्‍वयाः च्‍वनेमाः।” ");
INSERT INTO new_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","पुर्बय् सूर्य लुयावइगुपाखे यहूदा, इस्‍साखार व जबूलून छाउनीया पुचलं इमिगु झण्‍डाया क्‍वय् पाल ग्‍वइ। यहूदाया मनूतय् कुलनायः अम्‍मीनादाबया काय् नहशोन खः। ");
INSERT INTO new_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","यहूदाया पुचःयापिं ल्‍याःखाःपिं मिजंत ७४,६०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","इमिगु लिक्‍क इस्‍साखारया कुलं पाल ग्‍वइ। इस्‍साखारया कुलनायः सूआरया काय् नतनेल खः। ");
INSERT INTO new_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","इस्‍साखारया पुचःया ल्‍याःखाःपिं मिजंत ५४,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","इमिगु लिक्‍क जबूलूनया कुल दइ। जबूलूनया कुलनायः हेलोनया काय् एलीआब खः। ");
INSERT INTO new_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","जबूलूनया पुचःयापिं ल्‍याःखाःपिं मिजंत ५७,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","यहूदाया छाउनी पाखेयापिं ल्‍याःखाःपिनिगु मुक्‍क ल्‍याः थथःगु पुचःकथं १,८६,४०० म्‍ह दु। थुपिं हे दकलय् न्‍हापा न्‍ह्यज्‍याइ। ");
INSERT INTO new_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","दच्‍छिनपाखे रूबेन, शिमियोन व गादया छाउनीया पुचःत इमिगु झण्‍डाया क्‍वय् दइ। ");
INSERT INTO new_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","रूबेनया मनूतय् कुलनायः शदेऊरया काय् एलीसूर खः। इमिगु पुचःया ल्‍याःखाःपिं मिजंत ४६,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","इमिगु लिक्‍क शिमियोनया कुलं पाल ग्‍वयेमाः। शिमियोनया मनूतय् कुलनायः सूरीशद्दैया काय् शलूमीएल खः। ");
INSERT INTO new_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","इमिगु पुचःयापिं ल्‍याःखाःपिं मिंजंत ५९,३०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","अनंलि गादया कुल दइ। गादया मनूतय् कुलनायः दूएलया काय् एल्‍यासाप खः। ");
INSERT INTO new_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","इमिगु पुचःयापिं ल्‍याःखाःपिं मिजंत ४५,६५० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","रूबेनया छाउनीइ ल्‍याःखाःपिनिगु मुक्‍क ल्‍याः थःगु थःगु पुचःकथं १,५१,४५० म्‍ह दु। थुपिं निगूगु झ्‍वलय् न्‍यासि वनी। ");
INSERT INTO new_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","फुक्‍क छाउनीया दथुइ नापलायेगु पाल नापं लेवीतय्‌गु छाउनी दयेमाः। इपिं गुगु झ्‍वलय् पाल ग्‍वयाच्‍वनीगु खः व हे झ्‍वलय् च्‍वनाः थथःगु झण्‍डा नापं इपिं न्‍ह्यज्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","पच्‍छिमपाखे एफ्राइम, मनश्‍शे व बेन्‍यामीनया छाउनीया झण्‍डाया मनूत थथःगु पुचःकथं च्‍वनेमाः, इमि नायः अम्‍मीहूदया काय् एलीशामा खः, ");
INSERT INTO new_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","इमिगु पुचःया ल्‍याःखाःपिं मिजंत ४०,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","इमिगु लिक्‍क मनश्‍शेया कुल दइ। मनश्‍शेया मनूतय् कुलनायः पदासूरया काय् गमलिएल खः। ");
INSERT INTO new_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","अले इमिगु पुचःयापिं ल्‍याःखाःपिं मिजंत ३२,२०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","अनंलि बेन्‍यामीनया कुल दइ। बेन्‍यामीनया मनूतय् कुलनायः गिदेओनीया काय् अबीदान खः। ");
INSERT INTO new_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","इमिगु पुचःया ल्‍याःखाःपिं मिजंत ३५,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","एफ्राइमया छाउनीइ च्‍वनीपिनिगु ल्‍याः मुक्‍कं १,०८,१०० म्‍ह दु। थुपिं स्‍वंगूगु झ्‍वलय् न्‍ह्याइ। ");
INSERT INTO new_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","उत्तरपाखे दान, आशेर व नप्‍तालीया छाउनीया पुचःत इमिगु झण्‍डाया क्‍वय् दइ। दानया मनूतय् कुलनायः अम्‍मीशद्दैया काय् अहीएजेर खः। ");
INSERT INTO new_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","इमिगु पुचःया ल्‍याःखाःपिं मिजंत ६२,७०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","इमिगु लिक्‍क आशेरया कुलं पाल ग्‍वयेमाः। आशेरया मनूतय् कुलनायः ओक्रानया काय् पगीएल खः। ");
INSERT INTO new_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","इमिगु पुचःया ल्‍याःखाःपिं मिजंत ४१,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","अनंलि नप्‍तालीया कुल दइ। नप्‍तालीया मनूतय् कुलनायः एनानया काय् अहीरा खः। ");
INSERT INTO new_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","इमिगु पुचःया ल्‍याःखाःपिं मिजंत ५३,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","दानया छाउनीइ च्‍वनीपिनिगु ल्‍याः मुक्‍कं १,५७,६०० म्‍ह दु। इस्राएलीत थाय् हिलाः वनीबलय् थुमिगु पुचः दक्‍वसिबय् ल्‍युने थथःगु झण्‍डाया क्‍वसं न्‍ह्याइ। ");
INSERT INTO new_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","इस्राएलीतय् थथःगु छेँजःकथं ल्‍याःखाःपिं थुपिं हे खः। थथःगु पुचःकथं छाउनी छाउनीइ ल्‍याःखाःपिं मुक्‍क ६,०३,५५० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","परमप्रभुं मोशायात बियादीगु उजंकथं लेवीया सन्‍तानतय्‌त धाःसा थ्‍व ल्‍याखय् मतः। ");
INSERT INTO new_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","परमप्रभुं मोशायात बियादीगु उजंकथं इस्राएलीतय्‌सं थथःगु झण्‍डाया क्‍वय् छाउनी दय्‌कल। अले इपिं थथःपिनि वंश व परिवारया झण्‍डा क्‍वय् च्‍वनाः न्‍ह्यज्‍यात। ");
INSERT INTO new_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","परमप्रभुं मोशालिसें सीनै पर्वतय् खँ ल्‍हानादीबलय् हारून व मोशाया परिवारया खँ थथे दु – ");
INSERT INTO new_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","हारूनया काय्‌पिनिगु नां तःधिकःम्‍ह नादाब, अबीहू, एलाजार व ईतामार खः। ");
INSERT INTO new_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","हारूनया थुपिं काय्‌पिं अभिषेक याःपिं अले पुजाहारी जुयाः ज्‍या यायेत ल्‍यःपिं खः। ");
INSERT INTO new_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","नादाब व अबीहू धाःसा सीनैया मरुभूमिइ परमप्रभुयात छाये मत्‍यःगु मि छाःबलय् अन हे सित। इमि काय्‌मस्‍त नं मदुगुलिं एलाजार व ईतामारं जक थः बौ हारून म्‍वानाच्‍वंतले पुजाहारी जुयाः सेवा यात। ");
INSERT INTO new_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“लेवी कुलयापिन्‍त हारून पुजाहारीया न्‍ह्यःने हयाः इमित वयागु ज्‍याय् ग्‍वाहालि याकेब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","इमिसं नापलायेगु पालय् पवित्र पालया ज्‍या यानाः हारून व फुक्‍क खलःया निंतिं यायेमाःगु ज्‍या याइ। ");
INSERT INTO new_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","इमिसं नापलायेगु पालया फुक्‍क ज्‍वलंयागु जिम्‍मा कायेमाः। अले फुक्‍क इस्राएलीतय्‌गु निंतिं पवित्र पालया ज्‍या यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","लेवीत फुक्‍क इस्राएलीतपाखें ल्‍यःपिं खः, परमेश्‍वरं इमित हारून व वया काय्‌पिन्‍त पवित्र पालय् पुजाहारीया ज्‍याय् ग्‍वाहालि यायेत बियादीगु खः। ");
INSERT INTO new_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","छं हारून व वया काय्‌पिन्‍त पुजाहारी जुयाः सेवा यायेत ति। वने मत्‍यःपिं सुनानं नापलायेगु पालया सतिक वनेत स्‍वल धाःसा वयात स्‍यायेमाः।” ");
INSERT INTO new_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“जिं फुक्‍क इस्राएली मिसातय्‌पाखें न्‍हापां बूपिं काय्‌पिनिगु पलेसा लेवीतय्‌त कयागु दु। उकिं लेवीत जिमि थः मनू खः। ");
INSERT INTO new_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","छाय्‌धाःसा न्‍हापां बूपिं फुक्‍कं जिम्‍ह खः। मिश्रय् न्‍हापां बूपिं फुक्‍कसित स्‍यानागु दिं इस्राएलया न्‍हापां बूपिं मनूत व पशुतय्‌त जिं थःगु हे निंतिं अलग तया। इपिं फुक्‍कं जिम्‍ह खः। जि परमप्रभु खः।” ");
INSERT INTO new_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","सीनैया मरुभूमिइ परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“लेवीया सन्‍तानतय् लच्‍छि व लच्‍छिं च्‍वय्‌यापिं फुक्‍क मिजंत इमि वंश व परिवारकथं ल्‍याःखा।” ");
INSERT INTO new_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","थुकथं थःत उजं ब्‍यूगु थें परमप्रभुया वचनकथं मोशां इमित ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","लेवीया काय्‌पिनिगु नां थथे दु – गेर्शोन, कहात व मरारी। ");
INSERT INTO new_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","गेर्शोनया वंशया नां वया निम्‍ह काय्‌पिनिगु नामं तल – लिब्‍नी व शिमी। ");
INSERT INTO new_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","कहातया वंशया नां वया पेम्‍ह काय्‌पिनिगु नामं तल – अम्राम, यिसहार, हेब्रोन व उज्‍जीएल। ");
INSERT INTO new_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","मरारीया वंशया नां वया निम्‍ह काय्‌पिनिगु नामं तल – महली व मूशी। थथःगु परिवारकथं लेवीया वंशत थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","गेर्शोनपाखें लिब्‍नी व शिमीया वंशत दत। गेर्शोनया वंशत थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","थुमि लच्‍छि व लच्‍छिं च्‍वय्‌यापिं मिजंतय्‌गु ल्‍याः ७,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","गेर्शोनया वंशतय्‌सं नापलायेगु पालया लिक्‍क पच्‍छिमपाखे थःपिनिगु पाल ग्‍वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","गेर्शोनीतय् परिवारया नायः लाएलया काय् एल्‍यासाप खः। ");
INSERT INTO new_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","गेर्शोनीतय्‌त पवित्र पाल, उकिया इलां, पवित्र पालया लुखाया पर्दा, ");
INSERT INTO new_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","चुकया प्‍येखेरं ख्‍वातुगु कापः, चुकया ध्‍वाखाया पर्दा, उकिया खिपः व अन माःगु फुक्‍क ज्‍वलंया रेखदेख यायेगु जिम्‍मा बिल। ");
INSERT INTO new_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","कहातपाखें अम्रामी, यिसहारी, हेब्रोनी व उज्‍जीएलीतय् वंशत दत। कहातीयागु वंशत थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","इमि लच्‍छि व लच्‍छिं च्‍वय्‌यापिं मिजंतय्‌गु ल्‍याः ८,६०० म्‍ह दु। इमित पवित्र पाल रेखदेख यायेगु जिम्‍मा बियातःगु खः। ");
INSERT INTO new_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","कहातीतय् वंशतय्‌सं नापलायेगु पालया लिक्‍क दच्‍छिनपाखे थःगु पाल ग्‍वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","कहातीतय् वंशतय् परिवारया नायः उज्‍जीएलया काय् एलीजापान खः। ");
INSERT INTO new_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","इमित बाचाया सनू, तेबिल, त्‍वाःदेवा, गुँगू थनेगु वेदी व होमबलिया वेदी, महा-पवित्र न्‍ह्यःने दुगु पर्दा, अले पवित्र पालय् सेवा यायेत माःगु फुक्‍क ज्‍वलं, अले थ्‍व नापं स्‍वापु दुगु फुक्‍क सामान रेखदेख यायेगु जिम्‍मा बियातःगु खः। ");
INSERT INTO new_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","हारून पुजाहारीया काय् एलाजार लेवी कुलया मू नायः खः। पवित्र पालया जिम्‍मा कयातःपिं फुक्‍क मनूतय्‌त स्‍वयेत वयात ल्‍यःगु खः। ");
INSERT INTO new_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","मरारीपाखें महली व मूशीया वंश दत। मरारीया वंश थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","इमि लच्‍छि व लच्‍छिं च्‍वय्‌यापिं मिजंतय्‌गु ल्‍याः ६,२०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","मरारीतय् वंशतय् परिवारया नायः अबीहेलया काय् सूरीएल खः। इमिसं नापलायेगु पालया उत्तरपाखे थःगु पाल ग्‍वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","मरारीतय्‌त पवित्र पालया सिँपौ, खगः, थां, लिधंसा व उकिया फुक्‍क हलंज्‍वलं, ");
INSERT INTO new_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","अले प्‍यखेंया चुकया थां, लिधंसा, नकिं, खिपः अले उकी छ्यलेत माःगु फुक्‍क ज्‍वलं रेखदेख यायेगु जिम्‍मा ब्‍यूगु खः। ");
INSERT INTO new_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","मोशा, हारून व वया काय्‌पिन्‍सं पुर्बपाखे नापलायेगु पालया लिक्‍क थःगु पाल ग्‍वयेमाः। इमित इस्राएलीतय्‌गु निंतिं नापलायेगु पालया बिचाः यायेगु जिम्‍मा ब्‍यूगु खः। वने मत्‍यःपिं सुं उकिया सतिक वंसा वयात स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","परमप्रभुया उजंकथं मोशा व हारूनं ल्‍याःखाःपिं लेवीतय् लच्‍छि व लच्‍छिं च्‍वय्‌यापिं मिजंतय्‌गु ल्‍याः २२,००० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","परमप्रभुं मोशायात धयादिल, “इस्राएलीतय् न्‍हापां बूपिं लच्‍छि व लच्‍छिं च्‍वय्‌यापिं मिजंतय्‌त ल्‍याः खानाः इमिगु नां धलः दय्‌कि। ");
INSERT INTO new_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","इस्राएलीतय् न्‍हापां बूपिं काय्‌पिनिगु पलेसा छं लेवीतय्‌त का। अथे हे इस्राएलीतय् न्‍हापां बूपिं पशुतय् पलेसा लेवीतय् पशुतय्‌त का। जि परमप्रभु खः।” ");
INSERT INTO new_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","अथे जुयाः परमप्रभुं मोशायात उजं बियादीगु थें वं इस्राएलीतय् न्‍हापां बूपिन्‍त ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","लच्‍छि व लच्‍छिं च्‍वय्‌यापिं न्‍हापां बूपिनिगु मुक्‍क ल्‍याः २२,२७३ म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“इस्राएलीतय् न्‍हापा बूपिं काय्‌पिनिगु पलेसा लेवीत व इमि न्‍हापां बूपिं पशुतय् पलेसा लेवीतय् पशु का। लेवीत जिमि थः मनू जुइ। जि परमप्रभु खः। ");
INSERT INTO new_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","लेवीतय् ल्‍याः स्‍वयाः अप्‍वः दुपिं इस्राएलीतय् न्‍हापां बूपिं काय्‌पिनिगु ल्‍याः २७३ म्‍ह दु। थुमित लिफ्‍यायेत ");
INSERT INTO new_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","छम्‍हय्‌सियागु मूकथं इमिपाखें न्‍यागू न्‍यागू शेकेल का। थ्‍व पवित्र पालया शेकेलकथं जुइमाः। छगू शेकेलय् निइगू गेरा दइ। ");
INSERT INTO new_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","अले अप्‍वः दुपिं इस्राएलीतय्‌त लिफ्‍यायेगुकथं वःगु धिबा हारून व वया काय्‌पिन्‍त ब्‍यु।” ");
INSERT INTO new_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","थुकथं मोशां लेवीतपाखें त्‍वःतुकूपिं स्‍वयाः अप्‍वः दुपिं मनूतय्‌त लिफ्‍यायेगु मू काल। ");
INSERT INTO new_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","वं इस्राएलीतय् न्‍हापां बूपिनिपाखें पवित्र पालया शेकेलकथं १,३६५ शेकेल वहः काल। ");
INSERT INTO new_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","अले परमप्रभुं मोशायात उजं बियादी थें वं थ्‍व धिबा हारून व वया काय्‌पिन्‍त बिल। ");
INSERT INTO new_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","लेवीया सन्‍तान कहातीतय्‌त इमिगु वंश व परिवारकथं ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","“नापलायेगु पालय् सेवा यायेबहःपिं स्‍वीदंनिसें नेय्‌दँ तक याःपिं सकसितं ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“पवित्र पालय् तसकं पवित्रगु ज्‍वलं स्‍वयेगु ज्‍या कहातीतय्‌गु खः। ");
INSERT INTO new_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","छाउनी मेथाय् न्‍ह्याइबलय् हारून व वया काय्‌पिन्‍सं महा-पवित्रगु थासय् दुहां वनाः बाचा चिनातःगु सनूया न्‍ह्यःने पर्दा क्‍वकयाः उकिं सनूयात त्‍वपुयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","अले इमिसं उकिया द्यःने डल्‍फिन न्‍याया छेंगुलिं त्‍वपुयाः उकी वँचुगु रंग छिनातःगु कापतं भुनाबीमाः। अले न्‍वःत थासय् तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“परमप्रभुयात छाःगु मरि ब्‍वयातइगु तेबिलय् इमिसं वँचुगु कापः लायाः भु, थल, ख्‍वला, त्‍वँसाबलिया आम्‍खुरा व परमप्रभुयात छायेहःगु मरि तयेमाः। ");
INSERT INTO new_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","अले इमिसं उकी द्यःने ह्याउँगु कापः लायाः डल्‍फिन न्‍याया छेंगुलिं त्‍वपुयाः न्‍वःत थासय् तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“अले इमिसं वँचुगु कापतं त्‍वाःदेवा व उकिया पाल्‍चात, चिम्‍तात, किस्‍तित व चिकं तयेगु थल त्‍वपुयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","अले इमिसं थ्‍व फुक्‍कयात डल्‍फिन न्‍याया छेंगुलिइ प्‍वःचिनाः दुवालय् तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“अनंलि इमिसं लुँया वेदीयात वँचुगु कापतं त्‍वपुयाः द्यःने डल्‍फिन न्‍याया छेंगुलिं भुनाः न्‍वःत थासय् तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“इमिसं पवित्र पालय् दुगु फुक्‍क ज्‍वलं वँचुगु कापतय् प्‍वःचिनाः डल्‍फिन न्‍याया छेंगुलिं त्‍वपुयाः दुवालय् तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“इमिसं कँय्‌या वेदीं नउ लिकयाः उकी द्यःने प्‍याजीगु रंगया कापः लायाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","अले इमिसं उकिया द्यःने वेदीया सेवा यायेत छ्यलिगु ज्‍वलं नापं मिथल, ला लिकायेगु नतू, नउ तुइगु चतं व हि छ्वाकेगु बाता तयाः द्यःने डल्‍फिन न्‍याया छेंगुलिं त्‍वपुयाः न्‍वःत नं थासय् तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“हारून व वया काय्‌पिन्‍सं पवित्र पालयागु फुक्‍क पवित्र ज्‍वलंत त्‍वपुइ धुंकाः छाउनी न्‍ह्याइबलय् जक कहातीत फुक्‍क ज्‍वलं क्‍वबीत पालया दुने दुहां वये दइ। कहातीतय्‌सं तसकं पवित्रगु ज्‍वलं थीमज्‍यू, मखुसा इपिं सी। पवित्र पालया फुक्‍क ज्‍वलं कहातीतय्‌सं क्‍वबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“हारून पुजाहारीया काय् एलाजारयात त्‍वाःदेवाया चिकं, नस्‍वाःगु गुँगू, न्‍हियान्‍हिथंया अन्‍नबलि व अभिषेकया चिकं, अले पवित्र पाल व उकिया फुक्‍क पवित्र सामान व ज्‍वलं जिम्‍मा बियातःगु खः।” ");
INSERT INTO new_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“लेवीतय् दथुं कहातीतय् वंश नाश जुइके बी मते। ");
INSERT INTO new_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","इपिं तसकं पवित्रगु सामान दुथाय् वइबलय् मसीमा तर म्‍वानाच्‍वनेमा धकाः इमिगु लागि थथे या। हारून व वया काय्‌पिन्‍सं पवित्र थाय्‌या दुने वनाः इमिसं यायेमाःगु ज्‍या व क्‍वबी माःगु सामान क्‍यनाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","तर कहातीत पवित्र ज्‍वलं स्‍वयेत पलखया लागि जक नं दुहां मवनेमा, मखुसा इपिं सी।” ");
INSERT INTO new_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“गेर्शोनीतय्‌त नं इमि वंश व परिवारकथं ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","नापलायेगु पालय् ज्‍या याःवइपिं स्‍वीदंनिसें नेय्‌दँ तक दुपिं फुक्‍क मनूतय्‌त छं ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“गेर्शोनी वंशयापिन्‍सं यायेमाःगु ज्‍या व इमिसं क्‍वबी माःगु कु थुकथं दु – ");
INSERT INTO new_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","पवित्र पालया लुखाया पर्दा, पवित्र पालया इलां, उकिया द्यःने च्‍वंगु डल्‍फिन न्‍याया छेंगूयागु इलां, नापलायेगु पालया ध्‍वाखाया पर्दा, ");
INSERT INTO new_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","पवित्र पाल व वेदीया छचाःखेरं दुगु चुकया प्‍यखेरं च्‍वंगु क्‍वातूगु कापः व उकिया खिपः व अन माःगु फुक्‍क ज्‍वलं इमिसं क्‍वबीमाः। थ्‍व ज्‍वलंयागु फुक्‍क ज्‍या गेर्शोनीतय्‌सं यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","क्‍वबीगु थजु वा मेगु न्‍ह्यागु हे ज्‍या थजु इमिसं हारून व वया काय्‌पिन्‍सं धाःथें यायेमाः। इमिगु फुक्‍क ज्‍या छिमिसं हे इमित जिम्‍मा ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","नापलायेगु पालय् गेर्शोनीतय् वंशयागु ज्‍या थ्‍व हे खः। इमिसं हारून पुजाहारीया काय् ईतामारं धाःथें ज्‍या यायेमाः।” ");
INSERT INTO new_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","परमप्रभुं धयादिल, “मोशा, मरारीतय्‌त इमि वंश व परिवारकथं ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","नापलायेगु पालय् ज्‍या याःवइपिं स्‍विदंनिसें नेय्‌दँ दुपिं तक फुक्‍क मनूतय्‌गु नां धलखय् ति। ");
INSERT INTO new_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","इमिसं नापलायेगु पालय् यायेमाःगु ज्‍या थुकथं दु – पवित्र पालया सिँपौत, उकिया खगः, थांत व लिधंसात, ");
INSERT INTO new_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","चुकया प्‍यखेरं च्‍वंगु थांत व उकिया लिधंसात, पालया निंतिं माःगु नकिंत व खिपः, अले ज्‍याय् छ्यलिगु थीथी कथंया सामान क्‍वबीगु। अले छम्‍ह छम्‍हय्‌सिगु नां कयाः इमिसं यायेमाःगु ज्‍या व क्‍वबिये माःगु सामान क्‍वःछिनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","मरारीतय् वंशं नापलायेगु पालय् हारून पुजाहारीया काय् ईतामारं धाःथें यायेमाःगु ज्‍या थ्‍व हे खः।” ");
INSERT INTO new_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","मोशा, हारून व खलःया थकालितय्‌सं कहातीतय्‌त वंश व परिवारकथं ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","नापलायेगु पालय् ज्‍या याःवइपिं स्‍विदंनिसें नेय्‌दँ तक दुपिं फुक्‍क मनूतय्‌त ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","वंश वंशकथं इमिगु मुक्‍कं ल्‍याः २,७५० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","परमप्रभुं उजं ब्‍यूगुकथं मोशा व हारूनं ल्‍याःखाःपिं नापलायेगु पालय् ज्‍या याइपिं कहातीतय् वंशयापिनिगु मुक्‍क ल्‍याः थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","गेर्शोनीतय्‌त इमिगु वंश व परिवारकथं ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","स्‍वीदंनिसें नेय्‌दँ तक दुपिं नापलायेगु पालय् ज्‍या याःवइपिं, ");
INSERT INTO new_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","वंश वंश व परिवार परिवारकथं मिजंत मुक्‍कं यानाः २,६३० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","परमप्रभुया उजंकथं मोशा व हारूनं ल्‍याःखाःपिं नापलायेगु पालय् ज्‍या याइपिं गेर्शोनीतय् वंशयापिनिगु मुक्‍क ल्‍याः थुलि हे खः। ");
INSERT INTO new_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","मरारीतय्‌त इमिगु वंश व परिवारकथं ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","स्‍विदंनिसें नेय्‌दँ तक दुपिं मनूत नापलायेगु पालय् ज्‍या यायेत ल्‍यःपिं ");
INSERT INTO new_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","वंश वंशकथं मुक्‍कं ३,२०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","माशापाखें ब्‍यूगु परमप्रभुया उजंकथं मोशा व हारूनं ल्‍याःखाःपिं नापलायेगु पालय् ज्‍या याइपिं मरारीतय् वंशयापिनिगु मुक्‍क ल्‍याः थुलि हे खः। ");
INSERT INTO new_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","थुकथं मोशा, हारून व इस्राएलया थकालितय्‌सं फुक्‍क लेवीतय्‌त इमिगु वंश व परिवारकथं ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","स्‍वीदंनिसें नेय्‌दँ तक दुपिं नापलायेगु पालय् ज्‍या यायेत व कु क्‍वबीत वःपिं ");
INSERT INTO new_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","मनूतय्‌गु ल्‍याः मुक्‍कं ८,५८० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","परमप्रभुं मोशायात बियादीगु उजंकथं इपिं छम्‍ह छम्‍हय्‌सित ज्‍या यायेत व कु क्‍वबीत ल्‍यःगु खः। थुकथं परमप्रभुं मोशायात बियादीगु उजंकथं हे वं इमित ल्‍याः खात। ");
INSERT INTO new_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“इस्राएलीतय्‌त छेंगूयागु पुनेयःगु ल्‍वय् दुपिं, धातुया ल्‍वय् दुपिं व सीम्‍ह थियाः अशुद्ध जूपिं दक्‍वसित छाउनीं पितिनाछ्व धकाः उजं ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","मिसाम्‍ह जूसां मिजंम्‍ह जूसां इमित छाउनीं पितिनाछ्व। इमिसं यानाः जि च्‍वनेगु छिमिगु छाउनी अशुद्ध मजुइमा।” ");
INSERT INTO new_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","इस्राएलीतय्‌सं अथे हे यात। इमिसं अज्‍याःपिं मनूतय्‌त छाउनीं पितिनाछ्वत। परमप्रभुं मोशायात धयादी थें इस्राएलीतय्‌सं यात। ");
INSERT INTO new_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“इस्राएलीतय्‌त धा, ‘परमप्रभुयात विश्‍वासघात यानाः छिपिं सुनानं सुयातं पाप ज्‍या यात धाःसा व मनू दोषी जुइ, ");
INSERT INTO new_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","वं थःगु पापया प्रायश्‍चित यायेमाः। अले वं थःम्‍हं दुःख ब्‍यूम्‍ह मनूयागु छुं स्‍यंगु दुसा उकियागु पलेसा पुलेमाः। नापं न्‍याब्‍वय् छब्‍व अप्‍वः बं पुलेमाः। ");
INSERT INTO new_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","व मनू सित, अले वयापाखें बं काइपिं सत्तीपिं सुं थःथिति नं मदुसा व बं परमप्रभुयागु जुइ। अले व पुजाहारीयात बीमाः। प्रायश्‍चितया निंतिं भ्‍याःचा नं बीमाः। ");
INSERT INTO new_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","इस्राएलीतय्‌सं पुजाहारीयाथाय् परमप्रभुयात देछाये हःगु फुक्‍क पवित्र वस्‍तु पुजाहारीयागु जुइ। ");
INSERT INTO new_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","छम्‍ह छम्‍ह मनूया पवित्र कोसेलि वयागु थःगु हे खः, तर वं पुजाहारीयात छु बी व पुजाहारीयागु हे जुइ।’” ");
INSERT INTO new_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“इस्राएलीतय्‌त धा, ‘सुयां कलातं मखुगु लँपुइ वनाः थः भाःतयात विश्‍वासघात यात धाःसा ");
INSERT INTO new_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","अले मेम्‍ह मिजंनापं द्यनाः अशुद्ध जूसां वया भाःतं थ्‍व खँ मस्‍यू, अले थुकिया साक्षी नं सुं मदु, ");
INSERT INTO new_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","अथे हे भाःतम्‍हय्‌सित थः कलाः स्‍यंगु खःसां मखुसां शंका वन धाःसा ");
INSERT INTO new_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","वं थः कलाःयात पुजाहारीयाथाय् हयेमाः। वं थःनापं देछाकथं छगू एपाया झिब्‍वय् छब्‍व तछ्व चुं नं हयेमाः। तछ्व चुं चिकं व धुपाँय्‌ मतसे हयेमाः। छाय्‌धाःसा थ्‍व दोषयात लुमंकाबीगु अन्‍नबलि खः, अले नुगः मुयाः छायेहःगु बलि खः।’ ");
INSERT INTO new_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“‘पुजाहारीं व मिसायात परमप्रभुया न्‍ह्यःने थनेयंकेमाः। ");
INSERT INTO new_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","पुजाहारीं चाया थलय् नीलः भचा कयाः उकी पवित्र पालया बँय् च्‍वंगु धू कयाः तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","पुजाहारीं व मिसायात परमप्रभुया न्‍ह्यःने थनाः वयागु सँ फ्‍यनाबीमाः। अले वयागु ल्‍हातय् दसिया बलि अर्थात दाहया अन्‍नबलि तयाबीमाः। पुजाहारीं सराः लाइगु खायुगु लः थःगु ल्‍हातिइ कायेमाः। ");
INSERT INTO new_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","अले पुजाहारीं व मिसायात पाफय्‌काः थथे धायेमाः, “छ मेपिं सुं मिजंनाप द्यनागु मदुसा, छ थः भाःतनापं ह्वनाः च्‍वनाबलय् छं थःत अशुद्ध यानागु मदुसा, छन्‍त थ्‍व खायुगु लखं छुं याइ मखु। ");
INSERT INTO new_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","छ थः भाःत बाहेक मेम्‍हनापं जुयाः अशुद्ध जूगु दुसा, अले छिमि भाःत बाहेक मेम्‍ह मिजं छनापं द्यंगु दुसा” – ");
INSERT INTO new_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","पुजाहारीं सराःया पाफय्‌काः व मिसायात थथे धायेमाः – “परमप्रभुं थ्‍व सराः लाइगु लखं छंगु प्‍वाथय् दुहां वनाः छंगु प्‍वाः मनावय्‌का बीमा अले छंगु मचाछेँ ध्‍वग्‍गीका बीमा। परमप्रभुं थथे यानादीमा, मिसाम्‍हयसित व्‍यभिचारया निंतिं सजाँय बीबलय् मेपिं मनूतय्‌सं वयात सराः बी अले ब्‍वःबी। इमिसं लिपाया इलय् सुयातं सराः बीबलय् वयागु नां दसुकथं छ्यली। ");
INSERT INTO new_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","थ्‍व लः छंगु प्‍वाथय् दुहां वनाः प्‍वाः मनावयेमा, अले छंगु गर्भ ध्‍वग्‍गिकादीमा।” “‘अले व मिसां “आमेन, थथे हे जुइमा” धायेमा। ");
INSERT INTO new_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“‘पुजाहारीं थ्‍व सराः भ्‍वंथुलय् च्‍वयाः खायुगु लखय् सिला हुयाछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","अले वं सराः हइगु खायुगु लः मिसायात त्‍वंकेमाः। व दोषी खःसा, सराः लाइगु व लः वयागु म्‍हय् दुहां वनीबलय् उकिं वयात तसकं सास्‍ती याइ। ");
INSERT INTO new_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","पुजाहारीं व मिसायागु ल्‍हातिं तछ्व चुंयागु अन्‍नबलि कयाः परमप्रभुया न्‍ह्यःने ल्‍ह्वनाः वेदीइ छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","पुजाहारीं अन्‍नबलिं छम्‍हु कयाः लुमन्‍ति बलिकथं वेदीइ छ्वय्‌केमाः। अनंलि वं मिसायात लः त्‍वंकेमाः। ");
INSERT INTO new_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","व मिसां थः भाःतयात धोखा बियाः थःत अशुद्ध याःगु खःसा व सराः हइगु लखं वयात तसकं सास्‍ती याइ, वयागु प्‍वाः मनावइ, वयागु मचाछेँ ध्‍वग्‍गी। मनूतय्‌गु दथुइ वयागु नां हे सराः जुइ। ");
INSERT INTO new_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","अय्‌नं व मिसा अशुद्ध जूगु मदुसा अले शुद्धम्‍ह खःसा व दोषं मुक्त जुइ, अले व मस्‍त बुइके फुम्‍ह जुइ। ");
INSERT INTO new_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“‘दाहाया नियम थ्‍व खः, सुं मिसां थः भाःत बाहेक मेपिं मिजंतलिसे जुयाः थःत अशुद्ध याःसा, ");
INSERT INTO new_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","अले सुं मिजंयात थः कलाः खनाः शंका वन धाःसा यायेमाःगु दाहया नियम थ्‍व हे खः। मिजंनं थः कलाःयात परमप्रभुया न्‍ह्यःने हयेमाः। अले पुजाहारीं थथे यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","थज्‍याःगु ज्‍याय् मिजंयात छुं कथंया दोष लाइ मखु। मिसायागु दोष दत धाःसा वं सजाँय फयेमाली।’” ");
INSERT INTO new_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“इस्राएलीतय्‌त धा, ‘सुं नं मिसां वा मिजंनं थःत परमप्रभुया निंतिं फ्‍यायेत व नाजिरी जुइत भाकल याःगु दुसा ");
INSERT INTO new_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","वं थःत दाखमद्य, अय्‌लाः थ्‍वँपाखें तापाक तयेमाः। वं छुं कथंयागु दाखमद्य वा थ्‍वँ त्‍वने मज्‍यू, अले गंगु व प्‍याःगु छुं नं कथंयागु दाख नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","नाजिरी जुयाः च्‍वंतले वं दाखं दय्‌कातःगु छुं नं नये मज्‍यू, अज्‍ज दाखया पु व ख्‍वला तकं नये मज्‍यू। ");
INSERT INTO new_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“‘वं ग्‍वःन्‍हु तक अलग जुइगु भाकल याःगु खः वन्‍हु तक वं थःगु छेनय् ख्‍वःचा मछ्यलेमाः, गुबलय् तक परमप्रभुया निंतिं थःत अलग तइ, व ई पूमवंतले व शुद्ध जुयाच्‍वनेमाः। वं थःगु सँ ताहाकः जुइके बीमाः। ");
INSERT INTO new_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“‘ग्‍वःन्‍हु तक व परमप्रभुया निंतिं अलग च्‍वनी, वन्‍हु तक व गुगुं सीम्‍हया न्‍ह्यःने मवनेमाः। ");
INSERT INTO new_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","वया मां, वा बौ, वा दाजु, वा किजा, वा तता, वा केहेँ सीसां तबि इमिगु निंतिं वं थःत अशुद्ध मयायेमाः, छाय्‌धाःसा थः परमेश्‍वरया निंतिं अलग जूगु चिं वयागु छेनय् दु। ");
INSERT INTO new_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","नाजिरी जुयाच्‍वंतले व परमप्रभुयात देछानातःम्‍ह जुइ। ");
INSERT INTO new_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“‘सुं मनू वयागु न्‍ह्यःने हे आकाझाकां सिनाः वं अर्पण याःगु सँ अशुद्ध जुल धाःसा वं न्‍हय्‌न्‍हु दय्‌काः सँ खानाः थःत शुद्ध यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","च्‍यान्‍हु खुन्‍हु वं निम्‍ह सुकुभत्तु जूसां निम्‍ह बखुं जूसां नापलायेगु पालया ध्‍वाखाय् पुजाहारीया न्‍ह्यःने हयेमाः। ");
INSERT INTO new_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","सीम्‍ह मनूया न्‍ह्यःने दुगु जुयाः दोष लाःगुलिं पुजाहारीं वयागु निंतिं प्रायश्‍चित यायेत छम्‍ह पापबलि व छम्‍ह होमबलिकथं छायेमाः। उखुन्‍हु हे वं थःगु छ्यं नं शुद्ध यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","नाजिरीया लागि थः अलग जुइगु ई दतले वं परमप्रभुया निंतिं थःत छायेमाः, अले दोषबलिया निंतिं वं दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा छम्‍ह नं छाये हयेमाः। न्‍हापायागु दिं अशुद्ध जूगुलिं उकियागु ल्‍याः तइ मखु। ");
INSERT INTO new_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“‘नाजिरी जुयाः फ्‍यानातःगु ई पूवने धुंकाः यायेमाःगु ज्‍याखँ थथे दु। व नापलायेगु पालया ध्‍वाखाय् वनेमाः। ");
INSERT INTO new_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","अन वं होमबलिया निंतिं खू मदुम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा छम्‍ह, पापबलिया निंतिं खू मदुम्‍ह दच्‍छि दुम्‍ह मिसाम्‍ह फैचा छम्‍ह, व मेलबलिया निंतिं खू मदुम्‍ह भ्‍याःचा छम्‍ह, ");
INSERT INTO new_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","सोडा मतःगु ग्‍वारमरि व चिकं ल्‍वाकछ्यानातःगु सालुगु मरि छ दाला, माःकथंयागु अन्‍नबलि व त्‍वँसाबलि नं हयेमाः। ");
INSERT INTO new_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“‘पुजाहारीं परमप्रभुया न्‍ह्यःने न्‍हापां पापबलि व होमबलि छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","वं परमप्रभुया निंतिं मेलबलिकथं भ्‍याःचानापं दालाय् दुगु सोडा मतःगु मरि, उकियागु अन्‍नबलि व त्‍वँसाबलि नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“‘अनंलि नाजिरीं नापलायेगु पालया ध्‍वाखाया न्‍ह्यःने च्‍वनाः थःम्‍हं छाःगु सँ खायेमाः, अले उकियात मेलबलिया क्‍वय् मिइ तयाबीमाः। ");
INSERT INTO new_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“‘नाजिरीं थःगु सँ खाये धुंकाः पुजाहारीं भ्‍याःचायागु दय्‌कातःगु लां ब्‍वहयागु ला व दालां सोडा मतःगु ग्‍वारमरि व चिकं बुलातःगु सालुगु मरि छपा छपा कयाः वयागु ल्‍हातिइ तयाबी। ");
INSERT INTO new_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","अले पुजाहारीं उमित विशेष देछाकथं परमप्रभुया न्‍ह्यःने संकी, पुजाहारीया निंतिं विशेष देछाया छाति व परमप्रभुया न्‍ह्यःने संकूगु पवित्र देछाया खम्‍पानापं थुपिं पवित्र ब्‍व खः। थ्‍व ज्‍याखँ क्‍वचाय् धुंकाः नाजिरीं दाखमद्य त्‍वने फइ। ");
INSERT INTO new_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“‘भाकल यानाः परमप्रभुया निंतिं अर्पण याःपिं मनूतय्‌गु बारे यायेमाःगु विधि थ्‍व हे खः। उगु इलय् परमप्रभुयात थथे याना हे देछा छायेमाः। इमिसं मेगु देछा तनेफुसा इमिसं थथे यायेफु, इमिसं छु भाकल याःगु खः व नाजिरीया नियमकथं पूवंकेमाः।’” ");
INSERT INTO new_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“हारून व वया काय्‌पिन्‍त धा, ‘छिमिसं इस्राएलीतय्‌त सुवाः बीबलय् थथे धा, ");
INSERT INTO new_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“‘“परमप्रभुं छन्‍त सुवाः बियादीमा अले छंगु बिचाः यानादीमा, ");
INSERT INTO new_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","परमप्रभुं छंके थःगु ख्‍वाःया जः थीकादीमा, अले छन्‍त दया माया यानादीमा ");
INSERT INTO new_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","परमप्रभुं थःगु ख्‍वाः छपाखे हीकादीमा अले छन्‍त शान्‍ति बियादीमा।”’ ");
INSERT INTO new_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“हारून व वया काय्‌पिन्‍सं इस्राएलीतय्‌त सुवाः बियाः जिगु नां काइबलय् जिं इमित सुवाः बी।” ");
INSERT INTO new_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","मोशां नापलायेगु पाल धस्‍वाके धुंकाः उकियात व उकिया फुक्‍क ज्‍वलं, वेदी व उकिया फुक्‍क थलबल नापं अभिषेक यानाः पवित्र यात। ");
INSERT INTO new_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","अले इस्राएलया नायःत, गुपिं ल्‍याःखाःपिं मनूतय् नायःत खः, इमिसं देछात छाल, इपिं परिवारतय् कुलनायःत नं खः। ");
INSERT INTO new_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","इमिसं परमप्रभुया न्‍ह्यःने खुगः गाडा अले झिंनिम्‍ह द्वहं, निम्‍ह निम्‍ह कुल नायलं छगः छगः गाडा व नायःपतिकं छम्‍ह छम्‍ह द्वहं हयाः फुक्‍कयात नापलायेगु पालया ध्‍वाखाय् देछाल। ");
INSERT INTO new_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“छं थुपिं द्वहं व गाडा नापलायेगु पालया ज्‍याय् छ्यलेत इपिंपाखें का। अले लेवीतय्‌त थथःगु ज्‍याकथं इनाब्‍यु।” ");
INSERT INTO new_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","अथे जुयाः मोशां गाडा व द्वहं कयाः लेवीतय्‌त बिल। ");
INSERT INTO new_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","निगः गाडा व प्‍यम्‍ह द्वहं वं गेर्शोनीतय्‌त इमिगु ज्‍याकथं बिल। ");
INSERT INTO new_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","प्‍यंगः गाडा व च्‍याम्‍ह द्वहं हारून पुजाहारीया काय् ईतामारं ज्‍या ब्‍व थें याइपिं मरारीतय्‌त इमिगु ज्‍याकथं बिल। ");
INSERT INTO new_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","मोशां कहातीतय्‌त धाःसा द्वहं व गाडा छुं नं मब्‍यू, छाय्‌धाःसा तसकं पवित्र ज्‍वलं थःगु ब्‍वहलय् क्‍वबीगु जिम्‍मा इमिगु खः। ");
INSERT INTO new_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","वेदीयागु अभिषेक जूबलय् उकिया अर्पणया लागि नायःतय्‌सं थथःगु देछा हयाः वेदीया न्‍ह्यःने छाल। ");
INSERT INTO new_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","परमप्रभुं मोशायात धयादिल, “वेदीयात देछायेत न्‍हिं छम्‍ह छम्‍ह कुलनायलं थःगु देछा हयेमाः।” ");
INSERT INTO new_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","न्‍हापांगु दिंखुन्‍हु देछा छाःम्‍ह यहूदा कुलयाम्‍ह अम्‍मीनादाबया काय् नहशोन खः। ");
INSERT INTO new_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता– थुपिं निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुनं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","अले गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। अम्‍मीनादाबया काय् नहशोनया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","निन्‍हु दुखुन्‍हु इस्‍साखारया कुलयाम्‍ह नायः सूआरया काय् नतनेलं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता– थुपिं निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुनं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","अले गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","पापबलिया निंतिं छम्‍ह दुगु ");
INSERT INTO new_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु अले न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। सूआरया काय् नतनेलया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","स्‍वंन्‍हु दुखुन्‍हु जबूलूनया कुलयाम्‍ह नायः हेलोनया काय् एलीआबं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता – थुपिं निगुलिं थल अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुनं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","अले गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","पापबलिया निंतिं छम्‍ह दुगु ");
INSERT INTO new_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। हेलोनया काय् एलीआबया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","प्‍यंन्‍हु दुखुन्‍हु रूबेनया कुलयाम्‍ह नायः शदेऊरया काय् एलीसूरं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता– थुपिं निगुलिं थल अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुनं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","अले गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। शदेऊरया काय् एलीसूरया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","न्‍यान्‍हु दुखुन्‍हु शिमियोनया कुलयाम्‍ह नायः सूरीशद्दैया काय् शलूमीएलं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता – थुपिं निगुलिं थल अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुनं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। सूरीशद्दैया काय् शलूमीएलया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","खुन्‍हु दुखुन्‍हु गादया कुलयाम्‍ह नायः दूएलया काय् एल्‍यासापं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता – थुपिं निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुनं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। दूएलया काय् एल्‍यासापया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","न्‍हय्‌न्‍हु दुखुन्‍हु एफ्राइमया कुलयाम्‍ह नायः अम्‍मीहूदया काय् एलीशामां थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता– थुपिं निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। अम्‍मीहूदया काय् एलीशामाया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","च्‍यान्‍हु दुखुन्‍हु मनश्‍शेया कुलयाम्‍ह नायः पदासूरया काय् गमलिएलं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू (७०) शेकेल वहःयागु छगः छ्वाकेगु बाता– थुपिं निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल। ");
INSERT INTO new_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। पदासूरया काय् गमलिएलया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","गुन्‍हु दुखुन्‍हु बेन्‍यामीनया कुलयाम्‍ह नायः गिदेओनीया काय् अबीदानं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता – थुपिं निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। गिदेओनीया काय् अबीदानया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","झिन्‍हु दुखुन्‍हु दानया कुलयाम्‍ह नायः अम्‍मीशद्दैया काय् अहीएजेरं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता – थुपिं निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। अम्‍मीशद्दैया काय् अहीएजेरया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","झिंछन्‍हु दुखुन्‍हु आशेरया कुलयाम्‍ह नायः ओक्रानया काय् पगीएलं थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता– निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुनं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","पापबलिया निंतिं छम्‍ह दुगु, ");
INSERT INTO new_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","अले मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। ओक्रानया काय् पगीएलया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","झिंनिन्‍हु दुखुन्‍हु नप्‍तालीया कुलयाम्‍ह नायः एनानया काय् अहीरां थःगु देछा हल। ");
INSERT INTO new_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","वयागु देछा थथे दु – पवित्र पालया शेकेलकथं सच्‍छि व स्‍विगू शेकेल वहःयागु छपा भु, न्‍हयेगू शेकेल वहःयागु छगः छ्वाकेगु बाता – निगुलिं अन्‍नबलिया निंतिं चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुनं जाःगु खः, ");
INSERT INTO new_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","गुँगू जाय्‌क दुगु झिगू शेकेल लुँयागु छपा पाचिंगु थल, ");
INSERT INTO new_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा, व छम्‍ह दच्‍छि दुम्‍ह चिधिकःम्‍ह भ्‍याःचा, ");
INSERT INTO new_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","पापबलिया निंतिं छम्‍ह दुगु ");
INSERT INTO new_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","व मेलबलिया निंतिं निम्‍ह द्वहं, न्‍याम्‍ह भ्‍याःचा, न्‍याम्‍ह दुगु व न्‍याम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा। एनानया काय् अहीराया देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","वेदीयात अभिषेक याइगु दिं इस्राएलया कुलयापिं नायःतय्‌सं छाःगु देछा थुपिं हे खः – वहःयागु झिंनिपा भु, वहःयागु झिंनिगः छ्वाकेगु बाता, व झिंनिपा लुँयागु पाचिंगु थल। ");
INSERT INTO new_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","पवित्र पालया शेकेलकथं वहःयागु भु छपा पतिकं सच्‍छि व स्‍विगू शेकेल जुयाच्‍वन, वहःयागु छ्वाकेगु बाता छगः पतिकं न्‍हयेगू शेकेल जुयाच्‍वन। थुपिं फुक्‍क वहःयागु भु व बाता पवित्र पालया शेकेलकथं २,४०० शेकेल जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","अले गुँगू जाय्‌क दुगु लुँयागु झिंनिपा पाचिंगु थल पवित्र पालया शेकेलकथं छपा पतिकं झिगू शेकेल जुयाच्‍वन। थुपिं फुक्‍क लुँयागु गुँगू थल १२० शेकेल जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","होमबलिया निंतिं झिंनिम्‍ह द्वहंचा, झिंनिम्‍ह भ्‍याःचा, दच्‍छि दुपिं झिंनिम्‍ह चिधिकःपिं भ्‍याःचानापं अन्‍नबलि नं दुगु जुयाच्‍वन। अले पापबलिया निंतिं झिंनिम्‍ह दुगुचा छाल। ");
INSERT INTO new_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","अले मेलबलिया निंतिं मुक्‍कं निइप्‍यम्‍ह द्वहं, खुइम्‍ह भ्‍याःचा, खुइम्‍ह दुगु व खुइम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा छाःगु जुयाच्‍वन। वेदीया अभिषेक याये धुंकाः उकियात छायेत हःगु देछा थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","मोशा परमप्रभुलिसें खँ ल्‍हायेत महा-पवित्र थासय् वंबलय् बाचाया सनू द्यःने दुगु प्रायश्‍चितया कृपा-आसन च्‍वय्‌या निम्‍ह करूबतय् दथुं वं थःनापं नवानाच्‍वंगु सः ताल। अले परमप्रभुं व नापं खँ ल्‍हानादिल। ");
INSERT INTO new_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“हारूनयात धा, ‘छं न्‍हय्‌प्‍वाः मत तइबलय् त्‍वाःदेवाया न्‍ह्यःनेपाखे जः खइकथं ति।’” ");
INSERT INTO new_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","हारूनं अथे हे यात। परमप्रभुं मोशायात उजं बियादीगु थें त्‍वाःदेवाया न्‍ह्यःने जः खइकथं पाल्‍चा तल। ");
INSERT INTO new_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","परमप्रभुं मोशायात क्‍यनादीगु त्‍वाःदेवा थें हे च्‍वंक बांलुइक च्‍वंनिसें क्‍वथ्‍यंक मुगलं दायातःगु लुँयागु त्‍वाःदेवा दय्‌कातःगु खः। ");
INSERT INTO new_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“इस्राएलीत मध्‍ये लेवीतय्‌त कयाः विधिकथं शुद्ध या। ");
INSERT INTO new_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","इमित शुद्ध यायेत छं थथे या – इमित च्‍वख याइगु लखं छ्वाकि, अले इमिसं थःपिनिगु म्‍हय् च्‍वंगु सँ खानाः थथःगु वसः हियाः थःपिन्‍त विधिकथं शुद्ध यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","अले इमिसं छम्‍ह द्वहंचा व चिकं ल्‍वाकछ्यानातःगु भिंगु छुचुंया अन्‍नबलि हयेमाः। अले छं पापबलिया निंतिं मेम्‍ह छम्‍ह द्वहंचा हजि। ");
INSERT INTO new_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","छं लेवीतय्‌त नापलायेगु पालया न्‍ह्यःने हजि, अले इस्राएलया फुक्‍क खलःयात अन मुंकि। ");
INSERT INTO new_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","छं लेवीतय्‌त परमप्रभुया न्‍ह्यःने हजि। अले इस्राएलीतय्‌सं थथःगु ल्‍हाः लेवीतय्‌गु म्‍हय् तयेमाः। ");
INSERT INTO new_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","परमप्रभुया ज्‍या यायेत लेवीत तयार जुइमाः धकाः हारूनं लेवीतय्‌त इस्राएलीतपाखें संकाबीगु बलिकथं परमप्रभुया न्‍ह्यःने छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“अले लेवीतय्‌सं द्वहंतय्‌गु छेनय् थथःगु ल्‍हाः तयेमाः, अले लेवीतय्‌गु निंतिं प्रायश्‍चित यायेत छम्‍ह द्वहंचायात पापबलिकथं व निम्‍हय्‌सित होमबलिकथं छं परमप्रभुयात बलि छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","छं लेवीतय्‌त हारून व वया काय्‌पिनिगु न्‍ह्यःने थनाः परमप्रभुयात संकाबीगु बलिकथं इमित देछा। ");
INSERT INTO new_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","थथे छं लेवीतय्‌त इस्राएलीतपाखें अलग या, अले लेवीत जिगु जुइ। ");
INSERT INTO new_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“छं लेवीतय्‌त विधिकथं शुद्ध यानाः संकाबीगु बलिया निंतिं इमित देछाये धुंकाः पवित्र पालय् ज्‍या यायेत इपिं वनेमाः। ");
INSERT INTO new_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","इस्राएलीत मध्‍ये इपिं जितः देछाःपिं खः। दकलय् न्‍हापां प्‍वाथं पिहांवःपिं इस्राएलीतय् न्‍हापां बूपिंनिगु पलेसा जिं इमित कयागु दु। ");
INSERT INTO new_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","इस्राएलीतय् मनू जूसां पशु जूसां न्‍हापां बूपिं फुक्‍क जिम्‍ह हे खः। मिश्रीतय् सकल न्‍हापां बूपिन्‍त जिं स्‍यानागु दिं इमित जिं अलग याना। ");
INSERT INTO new_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","थुकथं इस्राएलीतय् न्‍हापां बूपिनिगु पलेसा जिं लेवीतय्‌त कयागु खः। ");
INSERT INTO new_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","फुक्‍क इस्राएलीतय्‌गु निंतिं जिं हारून व वया काय्‌पिनिगु निंतिं लेवीतय्‌त ल्‍ययागु दु। इमिसं नापलायेगु पालय् इस्राएलीतय्पाखें ज्‍या याइ, अले प्रायश्‍चित यायेत बलि बी। गुकिं यानाः पवित्र लागाया न्‍ह्यःने इपिं वनीबलय् इमित छुं नं विपत्ति मजुइमा।” ");
INSERT INTO new_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","परमप्रभुं लेवीतय्‌गु बारे मोशायात उजं बियादीगु थें मोशा, हारून व इस्राएलया फुक्‍क खलकं लेवीतय्‌त अथे हे यात। ");
INSERT INTO new_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","लेवीतय्‌सं थःपिन्‍त शुद्ध यानाः थथःगु वसः हिल। अले हारूनं इमित संकाबीगु बलिकथं परमप्रभुया न्‍ह्यःने देछाल। अले वं इमित शुद्ध यायेत इमिगु निंतिं प्रायश्‍चित यात। ");
INSERT INTO new_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","अनंलि दक्‍व लेवीत हारून व वया काय्‌पिनिगु न्‍ह्यःने नापलायेगु पालय् ज्‍या यायेत वल। परमप्रभुं लेवीतय्‌गु बारे मोशायात बियादीगु उजंकथं इमिसं यात। ");
INSERT INTO new_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","हानं परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“लेवीतय्‌सं ज्‍या यायेगु नियम थथे दु – निइन्‍यादँ व वस्‍वयां च्‍वय्‌यापिं नापलायेगु पालय् ज्‍या यायेत वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","अय्‌नं नेय्‌दँ दये धुंकाः इमिसं न्‍हिन्‍हिं यायेमाःगु ज्‍या त्‍वःतेमाः। अले हानं ज्‍या मयायेमाः। ");
INSERT INTO new_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","इमिसं नापलायेगु पालया ज्‍याय् थः दाजुकिजापिन्‍त ग्‍वाहालि बी फु, अय्‌नं छुं कथंयागु ज्‍या थःपिन्‍सं मयायेमा। अथे जुयाः लेवीतय्‌सं यायेमाःगु ज्‍याया बारे छं इमित थथे हे या।” ");
INSERT INTO new_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","इस्राएलीत मिश्रं पिहां वःगु निगूगु दँया न्‍हापांगु लाय् सीनैया मरुभूमिइ परमप्रभुं मोशालिसे थथे धकाः न्‍ववानादिल, ");
INSERT INTO new_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“क्‍वःछीगु इलय् इस्राएलीतय्‌सं छुत्‍काराया नखः हनेमाः। ");
INSERT INTO new_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","थ्‍व हे लाया झिंप्‍यन्‍हु दुखुन्‍हु सन्‍ध्‍याकाः इलय् क्‍वःछीगु इलय् छिमिसं थ्‍व नखः हँ। उकिया फुक्‍क नियम व विधिकथं छिमिसं हँ।” ");
INSERT INTO new_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","अले मोशां इस्राएलीतय्‌त छुत्‍काराया नखः हनेमाः धकाः धाल। ");
INSERT INTO new_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","इमिसं सीनैया मरुभूमिइ न्‍हापांगु लाया झिंप्‍यन्‍हु दुखुन्‍हु सन्‍ध्‍याकाः इलय् छुत्‍काराया नखः हन। परमप्रभुं मोशायात बियादीगु फुक्‍क उजंकथं इस्राएलीतय्‌सं यात। ");
INSERT INTO new_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","तर मनूया सीम्‍ह थियाः अशुद्ध जूपिं गुलिं मनूतय्‌सं व दिंखुन्‍हु छुत्‍काराया नखः हने मखन। अथे जुयाः इपिं व हे दिं मोशा व हारूनयाथाय् वल। ");
INSERT INTO new_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","अले मोशायात धाल, “जिपिं मनूया सीम्‍हया हुनिं अशुद्ध जूगु दु, तर क्‍वःछीगु इलय् मेपिं इस्राएलीतलिसें परमप्रभुया देछा जिमिसं छाय् छाये मज्‍यू?” ");
INSERT INTO new_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","मोशां इमित लिसः बिल, “आसे, परमप्रभुं छिमिगु बारे छु उजं बियादी व जिं न्‍यने।” ");
INSERT INTO new_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“इस्राएलीतय्‌त थथे धा, ‘छिमि छेँजः मध्‍ये सुं सीम्‍ह थियाः अशुद्ध जूगु दु वा तापाक्‍क वंगु दुसा, वं नं परमप्रभुया छुत्‍काराया नखः हनेमाः। ");
INSERT INTO new_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","निगूगु लाया झिंप्‍यन्‍हु खुन्‍हुया सन्‍ध्‍याकाः इलय् इमिसं नखः हनेमाः। इमिसं चिधिकःम्‍ह भ्‍याःचाया ला सोडा मदुगु मरि व खायुगु वाउँचा नापं नयेमाः। ");
INSERT INTO new_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","फैचाया ला सुथय् तक ल्‍यंकातये मते। फैचाया छुं नं क्‍वँय् त्‍वःथुले मते। थ्‍व नखःयात हनेगु छुत्‍काराया नखःया फुक्‍क नियमकथं हनेमाः। ");
INSERT INTO new_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","अय्‌नं शुद्धम्‍ह व यात्राय् मवंम्‍ह मनुखं छुत्‍काराया नखः महंसा वयात थः मनूत मध्‍ये नाश याना छ्वयेमाः। छाय्‌धाःसा वं क्‍वःछीगु इलय् देछा मछाः। व मनुखं थःगु पापयागु सजाँय भोगे यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“‘छिमिगु दथुइ च्‍वनिपिं परदेशीं परमप्रभुया छुत्‍काराया नखः हने मास्‍ति वय्‌कूसा उकियागु नियम व विधिकथं हनेमाः। नियम धाःसा अन हे बूपिं व पिनं वयाच्‍वंपिनिगु निंतिं छगू हे जुइ।’” ");
INSERT INTO new_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","गुखुन्‍हु साक्षीया पाल धकाः धाइगु पवित्र पाल धकस्‍वाकल उखुन्‍हु उकियात सुपाँचं वयाः त्‍वपुल। सन्‍ध्‍याकाः इलंनिसें सुथय् तक पवित्र पालया च्‍वय्‌यागु थ्‍व सुपाँय् मि थें खनेदत। ");
INSERT INTO new_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","थथे न्‍ह्याबलें जुइगु खः – दिनय् सुपाँचं त्‍वपुइगु व चान्‍हय् मि थें खने दइगु। ");
INSERT INTO new_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","पालया च्‍वय् सुपाँय् चिलावनेवं इस्राएलीत नं न्‍ह्याःवनी, अले सुपाँय् कुहां वयेवं इस्राएलीतय्‌सं अन हे पाल ग्‍वइगु। ");
INSERT INTO new_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","परमप्रभुया उजंकथं इस्राएलीत न्‍ह्याःवनी, अले परमप्रभुयागु हे उजंकथं पाल ग्‍वइ। पवित्र पालया च्‍वय् सुपाँय् दत्तले इपिं छाउनीइ हे च्‍वनाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","तःन्‍हु तक पवित्र पालया च्‍वय् सुपाँय् दयाच्‍वन धाःसा इस्राएलीत परमप्रभुया उजं मानय् यानाः अनं न्‍ह्याःवनी मखु। ");
INSERT INTO new_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","गुबलें गुबलें सुपाँय् छुं दिं जक पवित्र पालया च्‍वय् खने दयाच्‍वनी, न्‍ह्याबलें जूसां इमिसं परमप्रभुया उजंकथं पाल ग्‍वइगु अले वय्‌कःयागु हे उजंकथं इपिं न्‍ह्याःवनीगु। ");
INSERT INTO new_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","गुबलें सुपाँय् सन्‍ध्‍याकाः इलंनिसें सुथय् तक जक दयाच्‍वनी। सुथय् सुपाँय् चिलावनेवं इपिं न्‍ह्याःवनी। सुथय् बहनी न्‍ह्याबलें जूसां सुपाँय् चिलावनेवं इपिं न्‍ह्याःवनी। ");
INSERT INTO new_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","छुं जुयाः सुपाँय् पवित्र पालया च्‍वय् निन्‍हु, लच्‍छि, दच्‍छि व व स्‍वयाः अप्‍वः तक च्‍वनाच्‍वन धाःसां सुपाँय् दत्तले इपिं न्‍ह्याःवनी मखु। सुपाँय् चिलावनेवं इपिं न्‍ह्याःवनी। ");
INSERT INTO new_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","मोशापाखें परमप्रभुं बियादीगु उजंकथं इमिसं पाल ग्‍वइगु अले परमप्रभुया उजंकथं हे इपिं न्‍ह्याःवनीगु। ");
INSERT INTO new_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“वहःयात मुगलं दायाः निपु तुरही दय्‌कि। थ्‍व तुरही खलःयात मुंकेत व छाउनी न्‍ह्यःने न्‍ह्याकेत छ्यलेगु या। ");
INSERT INTO new_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","निपुं तुरही पुइबलय् फुक्‍क खलः नापलायेगु पालया ध्‍वाखाय् छंगु न्‍ह्यःने मुंवयेमाः। ");
INSERT INTO new_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","छपु जक तुरही पुइबलय् इस्राएलया वंशया नायःत छन्‍थाय् मुंवयेमाः। ");
INSERT INTO new_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“छुमांकथं छं चिहाकलं तुरही पुइबलय् पुर्बपाखेया छाउनीया मनूत न्‍ह्याःवनेमाः। ");
INSERT INTO new_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","निक्‍वः खुसी चिहाकलं तुरही पुइबलय् दच्‍छिन पाखेया छाउनी न्‍ह्याःवनेमाः। तुरहीया सः न्‍ह्याःवनेगुया छुमां खः। ");
INSERT INTO new_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","मनूतय्‌त मुंकाः मुँज्‍या यायेबलय् धाःसा ताहाकलं तुरही पुइमाः। तर न्‍ह्याःवनेगु छुमां थें मखु। ");
INSERT INTO new_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“हारूनया पुजाहारी काय्‌पिन्‍सं हे तुरही पुइमाः। थ्‍व छिपिं व छिमि लिपायापिं पुस्‍तातय्‌त सदां सदांया लागि नियम जुल। ");
INSERT INTO new_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“छिमित क्‍वत्‍यलातःपिं शत्रुतलिसें छिमिगु थःगु देशय् लडाइँ याः वनीबलय् नं चिहाकलं छुमांया तुरही पु। अले छिमित परमप्रभु छिमि परमेश्‍वरं लुमंकाः छिमि शत्रुतपाखें बचय् यानादी। ");
INSERT INTO new_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","छिमिसं लसताया ज्‍याखँय्, क्‍वःछिनातःगु नखःचखः व अमाइ पतिकं थःगु होमबलि व मेलबलि छायेबलय् नं तुरही पु। अले छिमि परमेश्‍वरयात छिपिं लुमनावइ। जि परमप्रभु छिमि परमेश्‍वर खः।” ");
INSERT INTO new_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","इस्राएलीतय्‌सं मिश्र त्‍वःता वंगु निगूगु दँया निगूगु लाया निइन्‍हु दुखुन्‍हु पवित्र पालया च्‍वं सुपाँय् चिला वन। ");
INSERT INTO new_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","अले इस्राएलीत सीनै मरुभूमि त्‍वःताः न्‍ह्याः वन। सुपाँय् पारानया मरुभूमिइ मदीतले इपिं छगू थासं मेगु थासय् न्‍ह्याःवनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","थुकथं मोशापाखें परमप्रभुं बियादीगु उजंकथं इपिं न्‍हापांखुसी न्‍ह्यज्‍यानावन। ");
INSERT INTO new_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","दक्‍वसिबय् न्‍हापां यहूदाया कुलया पुचः थःगु झण्‍डा ज्‍वनाः न्‍ह्याः वन। अम्‍मीनादाबया काय् नहशोन थ्‍व पुचःया न्‍ह्यलुवाः खः। ");
INSERT INTO new_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","अथे हे इस्‍साखार कुलया पुचःया न्‍ह्यलुवाः सूआरया काय् नतनेल खः। ");
INSERT INTO new_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","जबूलून कुलया पुचःया न्‍ह्यलुवाः हेलोनया काय् एलीआब खः। ");
INSERT INTO new_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","अले गेर्शोनी व मरारीतय्‌सं पवित्र पालयात क्‍वकयाः ल्‍ह्यल। ");
INSERT INTO new_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","अनंलि रूबेनया छाउनीया पुचः थःगु झण्‍डा ज्‍वनाः न्‍ह्याः वन। इमि न्‍ह्यलुवाः शदेऊरया काय् एलीसूर खः। ");
INSERT INTO new_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","शिमियोन कुलया पुचःया न्‍ह्यलुवाः सूरीशद्दैया काय् शलूमीएल खः। ");
INSERT INTO new_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","अले गाद कुलया पुचःया न्‍ह्यलुवाः दूएलया काय् एल्‍यासाप खः। ");
INSERT INTO new_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","अनं लिपा कहातीत पवित्र सामान व ज्‍वलं क्‍वबियाः न्‍ह्याः वन। इपिं थ्‍यने न्‍ह्यः हे मेगु छाउनीइ पवित्र पालयात धस्‍वाकातये धुंकीगु। ");
INSERT INTO new_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","अनंलि थःगु झण्‍डा ज्‍वनाः एफ्राइमया छाउनीया पुचः न्‍ह्यात। इमि न्‍ह्यलुवाः अम्‍मीहूदया काय् एलीशामा खः। ");
INSERT INTO new_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","मनश्‍शे कुलया पुचःया न्‍ह्यलुवाः पदासूरया काय् गमलिएल खः। ");
INSERT INTO new_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","बेन्‍यामीन कुलया पुचःया न्‍ह्यलुवाः गिदेओनीया काय् अबीदान खः। ");
INSERT INTO new_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","दक्‍वसिबय् लिपा दानया छाउनीया पुचः थःगु झण्‍डा ज्‍वनाः न्‍ह्यात। अम्‍मीशद्दैया काय् अहीएजेर इमि न्‍ह्यलुवाः खः। ");
INSERT INTO new_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","आशेर कुलया पुचःया न्‍ह्यलुवाः ओक्रानया काय् पगीएल खः। ");
INSERT INTO new_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","नप्‍ताली कुलया पुचःया न्‍ह्यलुवाः एनानया काय् अहीरा खः। ");
INSERT INTO new_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","थुकथं थथःगु पुचःकथं इस्राएलीत न्‍ह्यज्‍यां वनीगु खः। ");
INSERT INTO new_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","अले मोशां थः ससःबौ मिद्यानी रूएलया काय् होबाबयात धाल, “परमप्रभुं जिमित बी धकाः धयादीगु थासय् जिपिं वनेत्‍यनागु दु। छि नं जिपिंनापं झासँ, जिमिसं छितः भिं हे याये छाय्‌धाःसा परमप्रभुं इस्राएलया बारे भिंगु बाचा यानादीगु दु।” ");
INSERT INTO new_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","वं धाल, “जि वने मखु। जि थःगु हे देशय् थःथितिपिन्‍थाय् लिहां वने।” ");
INSERT INTO new_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","मोशां धाल, “जिमित त्‍वःताः झाये मते! छाय्‌धाःसा छिं मरुभूमिइ गन गन छाउनी तयेमाः धकाः बांलाक स्‍यू। छिं जिमित लँ क्‍यनादी फइ। ");
INSERT INTO new_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","छि जिपिंनापं झाल धाःसा परमप्रभुं जिमित छु आशिष बियादी व जिमिसं छिनापं इनाकाये।” ");
INSERT INTO new_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","परमप्रभुया पर्वत, सीनै त्‍वःताः इपिं स्‍वन्‍हु तक न्‍ह्याः वन। इमिगु निंतिं बाय् च्‍वनेगु थाय् मालेत परमप्रभुया बाचाया सनू थुपिं स्‍वन्‍हु तक हे इमिगु न्‍ह्यः न्‍ह्यः वन। ");
INSERT INTO new_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","इपिं छगू बाय् त्‍वःताः मेगु थासय् न्‍ह्याः वनीबलय् न्‍हिच्‍छि परमप्रभुया सुपाँय् इमि च्‍वंच्‍वं जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","बाचाया सनू न्‍ह्याकीगु इलय् मोशां न्‍ह्याबलें थथे धाइगु, “हे परमप्रभु, दनादिसँ! छिकपिनि शत्रुत छ्यालब्‍याल जुइमा! छितः घृणा याइपिं छिगु न्‍ह्यःनं बिस्‍युं वनेमा!” ");
INSERT INTO new_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","बाचाया सनूयात दिकीबलय् वं थथे धाइगु, “हे परमप्रभु, द्वलंद्वः इस्राएलया मनूतय्‌थाय् लिहांझासँ!” ");
INSERT INTO new_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","मनूतय्‌सं थःपिन्‍त जूगु सास्‍तीया बारे परमप्रभुं तायेक कचकच याना हल। परमप्रभु इमिगु खँ न्‍यनाः तंचायादिल। अले वय्‌कलं तमं इमिथाय् मि छ्वयादिल। मिं इमिगु छाउनीया पिनेया छुं ब्‍वत भस्‍म यात। ");
INSERT INTO new_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","मनूत मोशायाथाय् वयाः चिल्‍लाय् दना हालाः ग्‍वाहालि फ्‍वन। वं परमप्रभुयात प्रार्थना यात। अले मि सित। ");
INSERT INTO new_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","अथे जुयाः व थाय्‌या नां तबेरा तल। छाय्‌धाःसा अन परमप्रभुया मि इमिगु दथुइ च्‍याःगु खः। ");
INSERT INTO new_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","इमिगु पुचलय् दुपिं छपुचः ज्‍यालगय् मजूपिं नसिंचायावल। अले इस्राएलीतय्‌सं तकं ख्‍वख्‍वं थथे कचकच यात, “ला नये माल! ");
INSERT INTO new_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","मिश्रय् जिमिसं न्‍याया ला धिबा पुले म्‍वाय्‌क नयागु लुमंनि। तुसि, खर्बुजा, छाः, प्‍याज, लाभा नयागु जिमि लुमं। ");
INSERT INTO new_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","आः ला जिमिके बल हे मदयावने धुंकल। थन ला मन्‍न बाहेक मेगु छुं हे खने मदु।” ");
INSERT INTO new_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","मन्‍न धयागु धन्‍यापु थें च्‍वं। स्‍वय्‌बलय् थाकुराः थें खने दु। ");
INSERT INTO new_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","मनूतय्‌सं पिहां वनाः मन्‍न मुनीगु, अले ल्‍वहं घलय् क्‍यलेगु व ल्‍वहंमाय् नीगु याइ। अले उकियात लखय् तयाः ताःकुक दय्‌की अले उकिं ल्‍वहंचा मरि दय्‌की। थुकिया सवाः जैतूनया चिकनय् छुनातःगु मरि थें जुइ। ");
INSERT INTO new_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","चान्‍हय् छाउनीइ सुति लः गाइबलय् मन्‍न नं नापं गाइगु। ");
INSERT INTO new_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","फुक्‍क परिवारया मनूत थथःगु पालया लुखाय् च्‍वनाः ख्‍वयाच्‍वंगु मोशां ताल। परमप्रभु तसकं तंचायादिल। अले मोशां नुगः मछिंकल। ");
INSERT INTO new_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","मोशां परमप्रभुयात धाल, “छाय् छिं जिके थ्‍व संकट हयादियागु? अले छाय् छि जि खनाः लय्‌ताया मदीयागु? छिं छाय् थुपिं फुक्‍कसिगु भार जितः क्‍वबिकादियागु? ");
INSERT INTO new_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","छु थुपिं जिगु प्‍वाथय् दुगु खः ला? छु थुमित जिं थःम्‍हं बुइकागु खः ला? छिं छाय् जितः ‘अजिं मचायात बुया जूगु थें थुपिं फुक्‍कसित थुमि पुर्खायात पाफयादीगु देशय् तक बुयायंकि’ धायेगु? ");
INSERT INTO new_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","थुपिं फुक्‍कसिनं जितः ‘ला नकि’ धकाः कचकच याःवयाच्‍वन। थुपिं फुक्‍कसित जिं गन कयाः ला नकेगु? ");
INSERT INTO new_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","जिं याकःचां थुपिं फुक्‍कसिगु भार क्‍वबी मफु, थ्‍व ला जितः तसकं झ्‍यातुल। ");
INSERT INTO new_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","छिं जितः थज्‍याःगु हे व्‍यवहार यानादीगु खःसा जितः दया यानाः थत्‍थें स्‍यानादिसँ, जि थःम्‍हं थःगु दुःख ला स्‍वयेमाली मखु।” ");
INSERT INTO new_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","अले परमप्रभुं मोशायात धयादिल, “जिगु निंतिं छं इस्राएलीतय् धर्मगुरुत मध्‍ये मनूतय् नायःत व अधिकारीत खः धकाः थम्‍हं म्‍हस्‍यूपिं न्‍हयेम्‍हय्‌सित (७०) मुंकि। अले इमित नापलायेगु पालय् जिगु न्‍ह्यःने हयाः थःनापं तुं थँ। ");
INSERT INTO new_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","जिं कुहां वयाः छनापं खँ ल्‍हाये। छंके दुगु छुं छुं आत्‍मा कयाः इमिके तयाबी। अले इमिसं नं मनूतय्‌गु कु क्‍वबी, छ याकःचां जक क्‍वबी माली मखु। ");
INSERT INTO new_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“आः छं मनूतय्‌त धा ‘कन्‍हय्‌यागु निंतिं छिपिं थः शुद्ध जुयाच्‍वँ। छिमित नयेत ला दइ। छिमिसं, “ला नये माल! मिश्रय् हे जिमित थ्‍व स्‍वयाः बांलाःगु खः!” धकाः कचकच याःगु परमप्रभुं ताल। आः परमप्रभुं छिमित ला बियादी, छिमिसं ला नयेदइ। ");
INSERT INTO new_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","छिमिसं छन्‍हु, निन्‍हु, न्‍यान्‍हु, झिन्‍हु वा निइन्‍हुयागु जक मखु, ");
INSERT INTO new_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","अले छिमिगु न्‍हासं पिहां मवतले व छिपिं वाक्‍क मजुतले लच्‍छि यंकं नइ। छाय्‌धाःसा छिमिसं थःपिनि दथुइ दुम्‍ह परमप्रभुयात त्‍वःताः वय्‌कःया न्‍ह्यःने “जिपिं मिश्र त्‍वःताः मवःसां ज्‍यूगु” धकाः ख्‍वयाजुल।’” ");
INSERT INTO new_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","अय्‌नं मोशां धाल, “जिनापं न्‍यासि जुइपिं थन खुगू लाख मिजंत दु। छिं धाःसा ‘इमित नयेत लच्‍छि तक ला बी’ धकाः धयादिल। ");
INSERT INTO new_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","थुपिं फुक्‍क फैच्‍वलय्‌या बथां व सा द्वहंया बथांयात स्‍याना नं थुलिमछिसित नकेत गाइ ला? वा समुद्रय् च्‍वंपिं फुक्‍क न्‍या लासां इमित नकेत गाइ ला?” ");
INSERT INTO new_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","परमप्रभुं मोशायात लिसः बियादिल, “छु जिगु शक्ति कम जूगु दु ला? छं आः थत्‍थें हे जिं धयागु खँ जुइ कि मजुइ धकाः स्‍वये खनी।” ");
INSERT INTO new_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","अले मोशां पिहां वनाः मनूतय्‌त परमप्रभुं धयादीगु खँ न्‍यंकल। वं न्‍हयेम्‍ह थकालिपिं मनूत मुंकाः पालया प्‍यखेरं थन। ");
INSERT INTO new_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","अले परमप्रभु सुपाँचय् कुहां झायाः व नापं खँ ल्‍हानादिल। परमप्रभुं मोशायाके दुगु आत्‍मां छुं छुं आत्‍मा कयाः न्‍हयेम्‍ह थकालितय्‌के तयाबिल। इमिके आत्‍मा वयेवं इमिसं अगमवाणी यात, तर हानं लिपा गुबलें अथे मयाः। ");
INSERT INTO new_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","एल्‍दाद व मेदाद नांयापिं निम्‍ह मनूत थकालितय्‌गु धलखय् दुथ्‍यानाः नं मेपिं थकालित मुनाच्‍वंगु पालय् मवंसें छाउनीइ हे च्‍वनाच्‍वंगु जुयाच्‍वन। अथे जूसां आत्‍मा इमिके जूवयाः इमिसं छाउनीइ हे अगमवाणी यात। ");
INSERT INTO new_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","छम्‍ह ल्‍याय्‌म्‍ह ब्‍वाँय् वयाः “एल्‍दाद व मेदादं छाउनीइ अगमवाणी यानाच्‍वंगु दु” धकाः मोशायात कन। ");
INSERT INTO new_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ल्‍याय्‌म्‍हबलय्‌निसें मोशाया ग्‍वाहालिमि जुयाच्‍वंम्‍ह नूनया काय् यहोशूं मोशायात धाल, “जिमि प्रभु, इमित पनादिसँ!” ");
INSERT INTO new_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","मोशां वयात धाल, “जिगु लागि छ नुगः मुइकीम्‍ह जुइ धुनागु ला? परमप्रभुया फुक्‍क मनूत अमगवक्ता जूगु जूसा अले परमप्रभुं इपिं फुक्‍कसिके थःगु आत्‍मा तयादीगु जूसा गुलि बांलाइगु खः।” ");
INSERT INTO new_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","अले मोशा इस्राएलयापिं थकालित नापं छाउनीइ लिहां वल। ");
INSERT INTO new_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","अले परमप्रभुं फय् वय्‌कादिल। थुकिं समुद्रं ख्‍वांय्‌झंगःतय्‌त पुइकाहल। इपिं छाउनीया छचाःखेरं न्‍हिच्‍छि न्‍यासि वनेमाःगु लागा तक बँय् ३ फिट तजाः जुइक च्‍वंवल। ");
INSERT INTO new_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","उखुन्‍हु न्‍हिच्‍छि व चच्‍छि अले कन्‍हय् खुन्‍हु नं न्‍हिच्‍छि हे इमिसं ख्‍वांय्‌झंगःत मुन। दक्‍वसिबय् कम मुंम्‍हय्‌सिनं हे झिगू होमेर मुन। थुमिगु ला इमिसं छाउनी न्‍यंक पानातल। ");
INSERT INTO new_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ला म्‍हुतुइ दुबलय् हे, नये न्‍ह्यः हे परमप्रभुं इपिं खनाः तंम्‍वयाः छाउनीइ महामारी छ्वयादिल। ");
INSERT INTO new_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","अथे जुयाः व थाय्‌यागु नां किब्रोथ-हत्तावा तल। ");
INSERT INTO new_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","छाय्‌धाःसा अन नसिंचाःपिं मनूतय्‌त थुंगु खः। इस्राएलीत किब्रोथ-हत्तावां हसेरोतय् वन, अले अन हे च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","मोशां छम्‍ह कूशी मिसानापं ब्‍याहा यात। व मिसाया हुनिं मिरियम व हारूनं वयात कुंखिनाहल। ");
INSERT INTO new_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","इमिसं धाल, “छु! परमप्रभुं मोशापाखें हे जक खँ ल्‍हानादीगु दु ला? छु! वय्‌कलं जिपिंपाखें खँ ल्‍हानादीगु मदु ला?” परमप्रभुं थ्‍व खँ ताल। ");
INSERT INTO new_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","मोशा क्‍वमिलुम्‍ह मनू खः, व थें क्‍वमिलुम्‍ह मनू पृथ्‍वीइ सुं हे मदु। ");
INSERT INTO new_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","परमप्रभुं थत्‍थें मोशा, हारून व मिरियमयात धयादिल, “छिपिं स्‍वम्‍हं नापलायेगु पालया न्‍ह्यःने वा!” इपिं स्‍वम्‍हं अन वन। ");
INSERT INTO new_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","अले परमप्रभु सुपाँय्‌या थामय् कुहां झाल, अले नापलायेगु पालया ध्‍वाखाय् दनाः हारून व मिरियमयात सःतादिल। इपिं निम्‍हं न्‍ह्यःने वन। ");
INSERT INTO new_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","वय्‌कलं धयादिल, “जिगु खँ न्‍यँ! “छिमिगु दथुइ सुं अगमवक्ता दुसा अले जिं थःत वयात दर्शनय् क्‍यनेगु जिं व नाप म्‍हगसय् खँ ल्‍हायेगु। ");
INSERT INTO new_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","तर जिमि दास मोशालिसे धाःसा जिं अथे याये मखु। जिगु फुक्‍क घरानाय् जिं पत्‍याः यानाम्‍ह व हे खः। ");
INSERT INTO new_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","वलिसे जिं चुलिंचू च्‍वनाः खँ ल्‍हाये, मथुइक मखु, ध्‍वाथुइक वं परमप्रभुयागु रूप खनी। छिपिं छाय् जिमि दास मोशायात कुंखिना जुइत मग्‍यानागु?” ");
INSERT INTO new_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","परमप्रभु इपिं खनाः तसकं तंचायादिल। अले वय्‌कः अनं झाल। ");
INSERT INTO new_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","पालया च्‍वं सुपाँय् चिलावनेवं मिरियम कोह्रि जुयाः च्‍वापु थें तुइसे च्‍वन। हारूनं मिरियमपाखे स्‍वःबलय् व कोह्रि जुइ धुंकूगु खन। ");
INSERT INTO new_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","अले हारूनं मोशायात धाल, “हे जिमि मालिक, जिमिसं मूर्ख जुयाः यानागु पापया सजाँय जिमित बियादी मते! ");
INSERT INTO new_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","थ्‍वयात मांया प्‍वाथं पिहां वःबलय् हे बच्‍छि ला ध्‍वग्‍गिनाः सी धुंकूम्‍ह मचा थें जुइके बी मते!” ");
INSERT INTO new_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","अले मोशां परमप्रभुयात प्रार्थना यात, “हे परमेश्‍वर, बिन्‍ति दु, वयात लंकादिसँ!” ");
INSERT INTO new_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","परमप्रभुं मोशायात लिसः बियादिल, “वया बौनं वयागु ख्‍वालय् थुकलं ब्‍यूगु जूसा छु व न्‍हय्‌न्‍हु तक मछाला मच्‍वनी ला? वयात न्‍हय्‌न्‍हु तक छाउनीं पिने कुना ति! अनं लिपा लित हःसां ज्‍यू।” ");
INSERT INTO new_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","अथे जुयाः मिरियमयात न्‍हय्‌न्‍हु तक छाउनीं पिने कुनातल। वयात लित महतले मनूत अनं न्‍ह्यमज्‍याः। ");
INSERT INTO new_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","अनंलि इपिं हसेरोत त्‍वःताः न्‍ह्याः वन। अले पारानया मरुभूमिइ थ्‍यंकाः पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“कनान देशया चिवा कायेत छुं मनूत छ्व। व देश जिं इस्राएलीतय्‌त बीत्‍यनागु दु। थथःपिनि कुलपाखें छम्‍ह छम्‍ह नायः छ्व।” ");
INSERT INTO new_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","अथे जुयाः परमप्रभुया उजंकथं मोशां पारानया मरुभूमिं इमित छ्वल। इपिं सकलें इस्राएलीतय् नायःत खः। ");
INSERT INTO new_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","इमिगु नां थथे दु – रूबेनया कुलपाखें जक्‍कूरया काय् शम्‍मूअ, ");
INSERT INTO new_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","शिमियोनया कुलपाखें होरीया काय् शाफात, ");
INSERT INTO new_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","यहूदाया कुलपाखें यपुन्‍नेया काय् कालेब, ");
INSERT INTO new_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","इस्‍साखारया कुलपाखें योसेफया काय् यिगाल, ");
INSERT INTO new_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","एफ्राइमया कुलपाखें नूनया काय् होशिया, ");
INSERT INTO new_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","बेन्‍यामीनया कुलपाखें रफूया काय् पलती, ");
INSERT INTO new_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","जबूलूनया कुलपाखें सोदीया काय् गद्दीएल, ");
INSERT INTO new_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","योसेफया कुल आर्थात मनश्‍शेया कुलपाखें सूसीया काय् गेद्दी, ");
INSERT INTO new_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","दानया कुलपाखें गमल्‍लीया काय् अम्‍मीएल, ");
INSERT INTO new_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","आशेरया कुलपाखें मिखाएलया काय् सतूर, ");
INSERT INTO new_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","नप्‍तालीया कुलपाखें वोफ्‍सीया काय् नहबी, ");
INSERT INTO new_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","गादया कुलपाखें माकीया काय् गूएल। ");
INSERT INTO new_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","मोशां देशया चिवा कायेत छ्वःपिं मनूत थुपिं हे खः। नूनया काय् होशियायागु नां मोशां यहोशू छुनाबिल। ");
INSERT INTO new_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","मोशां इमित कनान देशपाखे चिवा कायेत छ्वःबलय् थथे धाल, “थनं वनाः नेगेव धाःगु दच्‍छिन लागां डाँडाय् च्‍वंगु देशपाखे थाहां हुँ, ");
INSERT INTO new_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","अले देश गथे च्‍वं, अन च्‍वंपिं मनूत बल्‍लाः कि बमलाः, यक्‍व दु कि मदु धकाः सीकि। ");
INSERT INTO new_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","इपिं च्‍वनाच्‍वंगु देश भिं कि मभिं गथे च्‍वं? इपिं च्‍वनीगु शहर गथे च्‍वं? इमिगु शहरय् छचाःखेरं पखाः दु वा मदु? ");
INSERT INTO new_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","जमिन गथे च्‍वं, लखं लाःगु भिंगु जमिन वा गंगु जमिन, अन गुँ दु कि मदु, व स्‍व! साहस या, अले अनयागु छुं सिसाबुसा हजि!” उबलय् न्‍हापांगु दाख सइगु ई जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","अथे जुयाः इपिं अनं थहां वन, जीन धयागु मरुभूमिंनिसें लेबो-हमातया न्‍ह्यःने रहोब तक देशया चिवा काल। ");
INSERT INTO new_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","इपिं नेगेवपाखें थहां वनाः हेब्रोनय् थ्‍यंकः वन। अन अनाकया सन्‍तान अहीमन, शेशै व तल्‍मै च्‍वनाच्‍वंगु जुल। हेब्रोन मिश्रया सोअन शहर स्‍वयाः न्‍हय्‌दँ न्‍ह्यः दय्‌कूगु खः। ");
INSERT INTO new_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","अनंलि इपिं एश्‍कोलया गालय् वन। अले अनं छज्‍वाँय् दाख दुगु कचा त्‍वाःथलाः उकियात निम्‍ह मनुखं न्‍वलय् तयाः क्‍वबिया हल। इमिसं धालेसि व यःमरिसि नं हल। ");
INSERT INTO new_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","इस्राएलीतय्‌सं अनं व दाखया ज्‍वाँय्‌ त्‍वाःथूगु जुयाः व थाय्‌या नां एश्‍कोलया गाः तःगु खः। ");
INSERT INTO new_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","पिइन्‍हु लिपा व देशया चिवा काये धुंकाः इपिं लिहां वल। ");
INSERT INTO new_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","इपिं पारानया मरुभूमि दुगु कादेशय् मोशा, हारून इस्राएलीया फुक्‍क खलःयाथाय् लिहां वल। अले इमिसं थःपिन्‍सं खंगु फुक्‍क खँ इमित व फुक्‍क खलःयात कन। अले थःपिन्‍सं ज्‍वनावःगु व देशया फलफुल नं क्‍यन। ");
INSERT INTO new_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","इमिसं मोशायात कन, “छिं जिमित छ्वयादीगु देशय् जिपिं वना। धात्‍थें हे अन दुरु व कस्‍ति बाः वयाच्‍वंगु जुयाच्‍वन, अले अनयागु फलफुल थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","तर अन च्‍वंपिं मनूत तसकं बल्‍लाः। इमिगु शहरत ततःधं। शहरतय् पःखाः ग्‍वयातःगु दु। उलि जक मखु – जिमिसं अन अनाकया सन्‍तान नं खना। ");
INSERT INTO new_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","नेगेव धाःगु दच्‍छिन लागाय् अमालेकीत व डाँडाय् च्‍वंगु देशय् हित्ती, यबूसी व एमोरीत, अले समुद्रया लिक्‍क व यर्दन खुसिया सिथय् कनानीत च्‍वनाच्‍वंगु दु।” ");
INSERT INTO new_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","कालेबं मोशाया न्‍ह्यःने मनूतय्‌गु म्‍हुतुप्‍वाः तिकाः थथे धाल, “झीसं थत्‍थें थाहां वनाः व देशय् अधिकार यायेमाः। धात्‍थें झीसं इमित त्‍याकेफइ।” ");
INSERT INTO new_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","तर व नापं वंपिं मनूतय्‌सं धाल, “झीसं उपिं मनूतय्‌त हमला याये फइ मखु। इपिं झीपिं स्‍वयाः बल्‍लाः।” ");
INSERT INTO new_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","इमिसं झीसं चिवा काःवनागु देशया बारे इस्राएलीतय्‌त बांमलाःगु खँ कनाः थथे धाल, “झीसं चिवा काःवनागु व देशं ला थः हे मनूतय्‌त घुर्काछ्वइगु, अले अन च्‍वंपिं मनूत नं तसकं ततःधिकःपिं जुयाः ग्‍यानपुसे च्‍वं। ");
INSERT INTO new_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","जिमिसं अन नेफिलीमत नं खना। अनाकीत नेफिलीमतय्‌पाखें हे वःगु खः। इमिगु न्‍ह्यःने जिमिसं थःपिन्‍त थःगु मिखाय् क्‍वःबुइँचात थें ताल। इमिगु मिखाय् नं जिपिं अथे हे खनेदत।” ");
INSERT INTO new_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","उखुन्‍हु चच्‍छि फुक्‍क खलः चिल्‍लाय् दनाः ह्वाँय्‌ह्वाँय् ख्‍वल। ");
INSERT INTO new_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","सकलें इस्राएलीतय्‌सं मोशा व हारूनया विरोधय् कचकच यात। फुक्‍क खलकं इमित धाल, “जिपिं मिश्रय् वा थ्‍व मरुभूमिइ हे स्‍यूगु जूसा बांलाःगु। ");
INSERT INTO new_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","परमप्रभुं छाय् झीत तरवारं स्‍याकेबीत थ्‍व थासय् हयाच्‍वंगु दु? झी मस्‍त व मिसातय्‌त लुतया सामान थें लाकायंकी। आः झीपिं मिश्र देशय् हे लिहां वनेगु बांलाइ!” ");
INSERT INTO new_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","अले इमिसं थवंथवय् थुकथं खँ ल्‍हात, “सुं छम्‍हय्‌सित नायः ल्‍ययाः झीपिं मिश्रय् लिहां वनेनु।” ");
INSERT INTO new_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","मोशा व हारून इस्राएलया फुक्‍क खलःया न्‍ह्यःने क्‍वपुसां पुल। ");
INSERT INTO new_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","अले चिवा काःवंपिं नूनया काय् यहोशू व यपुन्‍नेया काय् कालेबं थथःगु वसः खुनाः ");
INSERT INTO new_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","इस्राएलया फुक्‍क खलःयात धाल, “जिपिं स्‍वःवनागु व चिवा काःवनागु देश तसकं बांलाःगु देश खः। ");
INSERT INTO new_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","परमप्रभु झीपिंलिसे लय्‌ताःसा वय्‌कलं झीत व देशय् यंकादी, अले व दुरु व कस्‍ति बाः वयाच्‍वंगु देश झीत बियादी। ");
INSERT INTO new_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","उकिं छिपिं परमप्रभुया विरोधय् विद्रोह याये मते! अन च्‍वंपिं मनूतलिसे ग्‍याये मते, छाय्‌धाःसा इपिं झीगु शिकार खः। परमप्रभु झीपिं नाप दु, इमिके आः हाःनाः मदये धुंकल। इपिं खनाः ग्‍याये मते।” ");
INSERT INTO new_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","अय्‌नं थ्‍व न्‍यनाः फुक्‍क खलः इमित ल्‍वहँतं कय्‌कि धकाः हाला हल। अबलय् हे परमप्रभुया महिमा पवित्र पालय् फुक्‍क इस्राएलीतय्‌थाय् खनेदत। ");
INSERT INTO new_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","परमप्रभुं मोशायात धयादिल, “थुमिसं जितः गुबलय् तक हेला यानाच्‍वनी? जिं थुमिगु न्‍ह्यःने उलिमछि अजू चायापुगु ज्‍या याये धुन, अय्‌नं थुमिसं जितः गुबलय् तक विश्‍वास याइ मखु? ");
INSERT INTO new_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","जिं इमित महामारीं स्‍यानाबी। अले जिं छंगुपाखें इपिं स्‍वयाः तःधंगु व बल्‍लाःगु जाति दय्‌के।” ");
INSERT INTO new_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","मोशां परमप्रभुयात धाल, “थ्‍व खँ मिश्रीतय्‌सं न्‍यनी, छाय्‌धाःसा छिं हे थःगु शक्तिं थुमित मिश्रीतय् थासं पित हयादीगु खः। ");
INSERT INTO new_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","अले इमिसं थ्‍व देशयापिं मनूतय्‌त थ्‍व खँ कनाबी। इमिसं छि परमप्रभु इमिथाय् चुलिंचू खनेदइगु, छिगु सुपाँय् इमिगु च्‍वय् दिनाच्‍वनीगु, छिं थुमित न्‍हिनय् न्‍हिनय् सुपाँया थां जुयाः लँ क्‍यनादीगु अले बहनी बहनी च्‍यानाच्‍वंगु मि जुयाः लँ क्‍यनादीगु धकाः नं स्‍यू। ");
INSERT INTO new_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","छिं छम्‍ह हे म्‍वाका मतसे थुपिं फुक्‍क खलःयात स्‍यानादिल धाःसा छिगु खँ न्‍यनातःपिं जातितय्‌सं थथे धकाः खँ ल्‍हाइ, ");
INSERT INTO new_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘परमप्रभुं थ्‍व मनूतय्‌त थःम्‍हं बी धकाः पाफयातःगु देशय् हये मफुत। अथे जुयाः वय्‌कलं इमित मरुभूमिइ हे स्‍यानादिल।’ ");
INSERT INTO new_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“अथे जुयाः प्रभु, छिं थःगु तःधंगु शक्ति क्‍यनादिसँ। गथे छिं धयादीगु दु, ");
INSERT INTO new_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘परमप्रभु तसकं सह याये फुम्‍ह, सदां दयामाया यानादीम्‍ह, अधर्म व अपराध क्षमा यानादीम्‍ह खः। अय्‌नं द्वं याःम्‍हसित वय्‌कलं क्षमा यानादी मखु, अले पुर्खातय्‌सं याःगु अधर्मया सजाँय वया स्‍वंगू प्‍यंगू पुस्‍तायात तकं बियादीम्‍ह खः।’ ");
INSERT INTO new_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","बिन्‍ति याये, छिगु तःधंगु दयाकथं थुमिसं मिश्र देश त्‍वःतावःबलय्‌निसें आः तक क्षमा यानावयाच्‍वनादी थें थुपिं मनूतय्‌गु पाप क्षमा यानादिसँ।” ");
INSERT INTO new_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","परमप्रभुं धयादिल, “छं धाःकथं जिं थुमित क्षमा बिया। ");
INSERT INTO new_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","अय्‌नं धात्‍थें जि म्‍वाःम्‍ह खः, अले परमप्रभुया महिमां पृथ्‍वी जाः थें ");
INSERT INTO new_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","मिश्र देशय् व मरुभूमिइ जिगु महिमा व अजू चायापुगु ज्‍या खनाः नं जिगु उजं मानय् मयाःपिं अले तःकमछि जिगु मन स्‍वःपिं थुपिं इस्राएलीतय्‌सं, ");
INSERT INTO new_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","जिं थुमि पुर्खायात बी धकाः पाफयाः बचं बियागु देश स्‍वये खनी मखु। जितः हेला याइपिं सुनानं व देश गुबलें खनी मखु। ");
INSERT INTO new_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","तर जिमि दास कालेबयाके मेगु हे आत्‍मा दु। वं जितः दुनुगलंनिसें विश्‍वास याःगु दु। जिं वयात व वनावःगु देशय् यंके, अले वया सन्‍तानं अन अधिकार याइ। ");
INSERT INTO new_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","अमालेकी व कनानीत बेँसी बेँसीइ च्‍वनाच्‍वंगुलिं छिपिं कन्‍हय् हे फहिला वनाः लाल समुद्रया लँपु जुयाः मरुभूमिपाखे हुँ।” ");
INSERT INTO new_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“थ्‍व मभिंगु खलकं गुबलय् तक जिगु विरोधय् कचकच यानाच्‍वनी? इस्राएलीतय्‌गु कचकच जिं यक्‍व हे न्‍यनेधुन। ");
INSERT INTO new_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","इमित धयाब्‍यु, ‘धात्‍थें जि म्‍वाःम्‍ह खः, जि परमप्रभुं धयाच्‍वना, छिमिसं जिं ताय्‌क छु छु धाल जिं व हे छिपिंलिसें याये। ");
INSERT INTO new_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ल्‍याःखाःबलय् निइदँ व वस्‍वयां च्‍वय्‌यापिं जिगु विरोधय् कचकच याःपिं फुक्‍क मनूतय्‌गु सीम्‍ह थ्‍व हे मरुभूमिइ क्‍वदली। ");
INSERT INTO new_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","अले यपुन्‍नेया काय् कालेब व नूनया काय् यहोशू बाहेक छिपिं मध्‍ये सुं नं जिं ल्‍हाः ल्‍ह्वनाः छिमित तये धकाः पाफयागु देशय् वने दइ मखु। ");
INSERT INTO new_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","छिमिसं छिमि मस्‍तय्‌त लुतया सामान थें लाकायंकी धकाः धाल, तर जिं इमित उगु देशय् हये अले छिमिसं हेला याःगु देशयात इमिसं म्‍हसी। ");
INSERT INTO new_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","छिमिगु सीम्‍ह धाःसा थ्‍व हे मरुभूमिइ क्‍वदली। ");
INSERT INTO new_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","छिमिसं विश्‍वास मयाःगुलिं छिमि मस्‍त पिइदँ तक, छिमि दक्‍वसिबय् लिपाम्‍ह मनू मसीतले थन हे मरुभूमिइ जवाः जुयाः चाहिलाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","छिमिसं व देशय् चिवा कायेत पिइन्‍हु बिकूगु खः। उकिं छन्‍हुया दच्‍छि ल्‍याखं पिइदँ तक छिमिसं थःगु पापया सजाँय फयेमाली। थुकथं छिमिसं जिगु विरोध छु खः धकाः सी।’ ");
INSERT INTO new_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","जि परमप्रभुं धयाच्‍वना, जिगु विरोधय् मूंपिं छिपिं मभिंगु खलःया मनूतय्‌त जिं थथे हे याये। थ्‍व हे मरुभूमिइ छिपिं फुक्‍कं सिनावनी।” ");
INSERT INTO new_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","मोशां व देशया चिवा कायेत छ्वःपिं मनूतय्‌सं वयाः मभिंगु सुचं बियाः फुक्‍क खलःयात मोशाया विरोधय् कचकच याकल। ");
INSERT INTO new_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","मोशां चिवा कायेत छ्वःबलय् वया मभिंगु सुचं ब्‍यूपिं मनूत परमप्रभुया न्‍ह्यःने महामारीं कयाः सित। ");
INSERT INTO new_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","देशया चिवा काःवंपिं मनूत मध्‍ये यहोशू व कालेब जक ल्‍यन। ");
INSERT INTO new_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","मोशां इस्राएलीतय्‌त थ्‍व खँ कंबलय् इमिसं तसकं नुगः मछिंकल। ");
INSERT INTO new_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","कन्‍हय् खुन्‍हु सुथ न्‍हापां दनाः इपिं थथे धाधां डाँडाय् च्‍वंगु देशपाखे थहां वन, “झीसं परमप्रभुया विरोधय् वनाः पाप याना। आः झी परमप्रभुं बी धयादीगु थासय् वनेत तयार दु।” ");
INSERT INTO new_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","तर मोशां धाल, “छिमिसं छाय् परमप्रभुया उजंयात मानय् मयानागु? छिमिसं यायेत्‍यंगु ज्‍या ताःलाइ मखु। ");
INSERT INTO new_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","च्‍वय् थहां वने मते, मखुसा शत्रुतय्‌सं छिमित बुकी, छाय्‌धाःसा परमप्रभु छिपिंलिसे मदी। ");
INSERT INTO new_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","अमालेकीत व कनानीत ध्‍वदुइबलय् छिपिं लडाइँलय् सी। छाय्‌धाःसा छिपिं परमप्रभुपाखें फस्‍वयावंगुलिं वय्‌कः छिपिंनापं मदी।” ");
INSERT INTO new_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","अय्‌जूसां इपिं अप्‍वः जुयाः मोशा व परमप्रभुया बाचाया सनू मदयेक हे डाँडाय् च्‍वंगु देशय् न्‍ह्याः वन। ");
INSERT INTO new_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","डाँडाय् च्‍वंगु देशय् च्‍वंपिं अमालेकीत व कनानीतय्‌सं कुहां वयाः इमित हय्‌क्‍कयाः बुकल। अले होर्मा तक लिनाहल। ");
INSERT INTO new_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“इस्राएलीतय्‌त धा, ‘जिं छिमित बीत्‍यनागु देशय् थ्‍यने धुंकाः ");
INSERT INTO new_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","छिमिसं परमप्रभुयात लय्‌ताय्‌कीगु नस्‍वाःकथं होमबलि व विशेष देछा बीबलय् सा द्वहंया बथां वा फैच्‍वलय्‌या बथांपाखें जुइमाः, अथे हे भाकलया बलि, थःयसें छाइगु बलि व नखःचखःया बलि बीबलय् ");
INSERT INTO new_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","बलि छाइम्‍हय्‌सिनं छगू हीनया प्‍यब्‍वय् छब्‍व जैतूनया चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् छब्‍व भिंगु छुचुंया अन्‍नबलि परमप्रभुयात छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","होमबलिया छम्‍ह छम्‍ह चिधिकःम्‍ह भ्‍याःचानापं त्‍वँसाबलिकथं छगू हीनया प्‍यब्‍वय् छब्‍व दाखमद्य नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“‘भ्‍याःचा नापं छायेगु अन्‍नबलिया निंतिं छगू हीनया स्‍वब्‍वय् छब्‍व चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् निब्‍व भिंगु छुचुं व ");
INSERT INTO new_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","त्‍वंसाबलिया निंतिं छगू हीनया स्‍वब्‍वय् छब्‍व दाखमद्य छाये हयेमाः। थ्‍व फुक्‍क छिमिसं परमप्रभुया निंतिं नस्‍वाःकथं देछा। ");
INSERT INTO new_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“‘होमबलि, भाकल बलिकथं वा मेलबलिकथं परमप्रभुयात द्वहंचा छायेबलय् ");
INSERT INTO new_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","बच्‍छि हीन चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् स्‍वब्‍व भिंगु छुचुंयागु अन्‍नबलि नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","अले बच्‍छि हीन दाखमद्ययागु त्‍वँसाबलि नं छायेमाः। थ्‍व विशेष देछाया नस्‍वालं परमप्रभु लय्‌ताइ। ");
INSERT INTO new_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","छम्‍ह छम्‍ह द्वहं वा भ्‍याःचा, चिधिकःम्‍ह भ्‍याःचा वा दुगुचाया निंतिं थथे हे यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","छिमिसं ग्‍वम्‍ह पशुबलि बीगु खः, फुक्‍कसित थथे हे यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“‘परमप्रभुयात लय्‌ताय्‌कीगु नस्‍वाःगु विशेष देछा छायेबलय् इस्राएलीतय्‌सं थुकथं हे यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","छिपिंनापं च्‍वनाच्‍वंपिं परदेशी वा लिपा च्‍वंवइपिं पिनेयापिं सुनानं परमप्रभुयात लय्‌ताय्‌कीगु नस्‍वाःगु विशेष देछा छायेगु मनंतुन धाःसा इमिसं नं थुकथं हे यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","छिमिगु व छिपिंनापं च्‍वनाच्‍वंपिं मेगु जातियापिं मनूतय्‌गु लागिं खलःया सदां सदांया नियम छगू हे जुइमाः। परमप्रभुया न्‍ह्यःने छिपिं व मेगु जातियापिं मनूत उथें खः। ");
INSERT INTO new_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","छिमित व छिपिंनापं च्‍वनाच्‍वंपिं मेगु जातियापिं मनूतय्‌त छगू हे नियम व छगू हे विधि जुइ।’” ");
INSERT INTO new_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“इस्राएलीतय्‌त धा, ‘जिं यंकेगु देशय् थ्‍यने धुंकाः ");
INSERT INTO new_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","छिमिसं व देशया अन्‍न नइबलय् छगू ब्‍व परमप्रभुयात छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","छिमिसं न्‍हापां लःगु बालिं दक्‍वसिबय् न्‍हापां मरि छुइबलय् न्‍हापां छूगु मरियात खलां हःगु बाली थें परमप्रभुयात छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","पुस्‍तां पुस्‍ता तकं छिमिसं न्‍हापां मरि छुइबलय् परमप्रभुयात थुकथं हे छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“‘छिमिसं मसीकं परमप्रभुं मोशापाखें बियादीगु उजंत मध्‍ये छुं नं उजं मानय् मयात धाःसा, ");
INSERT INTO new_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","लिपा छिमि सन्‍तानतय्‌सं नं मसीकं परमप्रभुं मोशापाखें बियादीगु उजं मानय् मयात धाःसा, ");
INSERT INTO new_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","अले खलकं मसीकं मचायेकं व मभिंगु ज्‍या याःगु जूसा, फुक्‍क खलकं परमप्रभुयात यःगु नस्‍वाःकथं होमबलिया निंतिं छम्‍ह द्वहंचा, उकिया अन्‍नबलि व त्‍वँसाबलि नापं विधिकथं छायेमाः। अले नापं पापबलिया निंतिं छम्‍ह दुगु नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","अले पुजाहारीं इस्राएलया फुक्‍क खलःया लागिं प्रायश्‍चित यायेमाः, अले इमित क्षमा याइगु जुइ। छाय्‌धाःसा व मसीकं मचायेकं याःगु मभिंगु ज्‍या खः। इमिसं थःगु पापया निंतिं परमप्रभुया न्‍ह्यःने विशेष देछा व पापबलि हःगु दु। ");
INSERT INTO new_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","थुकथं इस्राएलीया फुक्‍क खलः व इपिं नापं च्‍वनाच्‍वंपिं मेगु जातियापिं मनूतय्‌त नं क्षमा दइ। छाय्‌धाःसा थ्‍व मभिंगु ज्‍या मनूतय्‌सं मसीकं मचायेकं याःगु खः। ");
INSERT INTO new_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“‘सुं मनुखं मसीसें मचाय्‌कं व मभिंगु ज्‍या यात धाःसा वं दच्‍छि दुम्‍ह च्‍वलय्‌चा शुद्ध जुइगु बलिया लागिं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","व मसीकं मचाय्‌कं व पाप ज्‍या याःम्‍ह मनूया प्रायश्‍चितया निंतिं पुजाहारीं परमप्रभुया न्‍ह्यःने प्रायश्‍चित यायेमाः, अले वयात क्षमा दइ। ");
INSERT INTO new_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","इस्राएली जूसां इपिं नाप च्‍वनाच्‍वंम्‍ह मेगु जातियाम्‍ह मनू जूसां फुक्‍कसितं मसीकं मचाय्‌कं याःगु मभिंगु ज्‍याया निंतिं छगू हे नियम जुइ। ");
INSERT INTO new_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“‘इस्राएली वा मेगु जातियाम्‍ह मनू न्‍ह्याम्‍हय्‌सिनं जूसां सीकं चायेकं पापयात धाःसा वं परमप्रभुयात हेला याःगु खः। वयात वया मनूतपाखें पितिना छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","छाय्‌धाःसा वं परमप्रभुयागु वचनयात हेला याःगु दु, अले वय्‌कःयागु उजंयात हाचांगाःगु दु। वयात नाश यानाः छ्वयेमाः अले वं थःगु पापया सजाँय फयेमाः।’” ");
INSERT INTO new_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","इस्राएलीत मरुभूमिइ दुबलय् इमिसं विश्रामबार खुन्‍हु सिँ मुनाच्‍वंम्‍ह छम्‍ह मनूयात खन। ");
INSERT INTO new_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","सिँ मुनाच्‍वंम्‍हय्‌सित इमिसं मोशा, हारून व फुक्‍क खलःयाथाय् हल। ");
INSERT INTO new_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","वयात बीमाःगु सजाँय मसियाः इमिसं वयात कुनातल। ");
INSERT INTO new_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","अले परमप्रभुं मोशायात धयादिल, “व मनूयात स्‍याना हे छ्वयेमाः! फुक्‍क खलकं वयात छाउनीं पिने ल्‍वहँतं कय्‌काः स्‍यायेमाः!” ");
INSERT INTO new_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","परमप्रभुं मोशायात उजं बियादीगु थें फुक्‍क खलकं वयात छाउनीं पिने हल, अले वयात ल्‍वहँतं कय्‌काः स्‍यानाबिल। ");
INSERT INTO new_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","परमप्रभुं हानं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“इस्राएलीतय्‌त धा, ‘लिपाया पुस्‍ता तकं छिमिसं थथःपिनिगु गाया सिथय् प्‍यकुनय् हे फुर्काय् वँचुगु का तयेमाः। ");
INSERT INTO new_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","थ्‍व फुर्कां छिमित परमप्रभुया उजं लुमंकेबी। अले छिमिसं थःगु मन व मिखाया ल्‍वभया बसय् लानाः वेश्‍या थें मजुसें परमप्रभुया उजं मानय् याइ। ");
INSERT INTO new_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","थ्‍व फुर्कां छिमित जिगु उजं मानय् यायेमाः धकाः लुमंके बियाः ग्‍वाहालि याइ, अले छिपिं थः परमेश्‍वरया निंतिं पवित्र जुइ। ");
INSERT INTO new_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","छिमि परमेश्‍वर जुइत छिमित मिश्र देशं पितहयाम्‍ह परमप्रभु छिमि परमप्रभु परमेश्‍वर जि हे खः।’” ");
INSERT INTO new_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","लेवीया कुल, कहातया वंशयाम्‍ह यिसहारया काय् कोरह अले एलीआबया काय्‌पिं दातान व अबीराम अले रूबेन कुलयाम्‍ह पेलेथया काय् ओन, ");
INSERT INTO new_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","खलःया नांजाःपिं निसः व नेय्‌म्‍ह (२५०) इस्राएली नायःत नापं जानाः मोशाया विरोधय् दन। ");
INSERT INTO new_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","इपिं मोशा व हारूनयागु विरोध यायेत मुनाः इमित धाल, “छिं थःत तसकं तःधंकादीगु दु! खलःया फुक्‍क मनूत पवित्र जू, अले परमप्रभु इमिगु दथुइ दी। छाय् छिकपिन्‍सं थःपिन्‍त परमप्रभुया मुँज्‍या स्‍वयाः तःधंकादियागु?” ");
INSERT INTO new_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","थ्‍व खँ न्‍यनेवं मोशा बँय् भ्‍वपुल। ");
INSERT INTO new_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","अले वं कोरह व वयागु फुक्‍क पुचःयात थथे धाल, “कन्‍हय् सुथय् वय्‌कःयाम्‍ह सु खः, पवित्रम्‍ह सु खः, अले वय्‌कःया न्‍ह्यःने वनेत्‍यःम्‍ह सु खः धकाः परमप्रभुं हे क्‍यनादी। थम्‍हं ल्‍ययादीम्‍हय्‌सित वय्‌कलं थःगु न्‍ह्यःने वय्‌केबी। ");
INSERT INTO new_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","अय् कोरह, थथे या, छं व छिमि फुक्‍क पुचलं गुँगू थनेगु मकः का, ");
INSERT INTO new_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","कन्‍हय् परमप्रभुया न्‍ह्यःने उकी मि व गुँगू ति। गुम्‍हय्‌सित परमप्रभुं ल्‍ययादी, व हे पवित्र जुइ। हे लेवीया सन्‍तान, छिमिसं थःत तसकं तःधंकूगु दु!” ");
INSERT INTO new_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","अले मोशां कोरहयात धाल, “अय् लेवीत न्‍यँ! ");
INSERT INTO new_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","इस्राएलयाम्‍ह परमेश्‍वरं थःगु पवित्र पालया ज्‍या यायेत व खलःया न्‍ह्यःने सेवा यायेत इस्राएलया फुक्‍क खलःपाखें छिमित ल्‍यःगु छु छिमित मगात ला? ");
INSERT INTO new_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","वय्‌कलं छनापं हे छिमि दाजुकिजा लेवीतय्‌त न्‍हापा हे थःगु न्‍ह्यःने हयादीगु दु! आः छिमित पुजाहारी जुइ मास्‍ति नं वः ला? ");
INSERT INTO new_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","छ व छिमि पासापिंनापं मुंगु परमप्रभुया विरोधय्‌ खः। हारून सु खः धकाः छिमिसं वयागु विरोधय् कचकच यानागु?” ");
INSERT INTO new_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","अले मोशां एलीआबया काय्‌पिं दातान व अबीरामयात सःतके छ्वत। तर इमिसं “जिपिं वये मखु धकाः धाल। ");
INSERT INTO new_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","जिमित दुरु व कस्‍ति बाः वयाच्‍वंगु देशं मरुभूमिइ सीत हयादिया नं छितः मगात ला? अले आः छितः जिमि मालिक नं जुइ मास्‍ति वः ला? ");
INSERT INTO new_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","छिं जिमित दुरु व कस्‍ति बाः वयाच्‍वंगु देशय् हयादीगु मदु। अले जिमिगु अधिकारय् बुँ व दाखया क्‍यब नं बियादीगु मदु। छु! छितः थुपिं मनूतय्‌त दासतय्‌त थें व्‍यवहार याये मास्‍ति वः ला? जिपिं वये हे मखु।” ");
INSERT INTO new_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","अले मोशां तसक्‍कं तंचायाः परमप्रभुयात धाल, “इमिगु देछा नाला कयादी मते! जिं इमिके छम्‍ह गधा तक नं कयागु मदु, न जिं इमिगु छुं स्‍यंकागु दु।” ");
INSERT INTO new_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","हानं मोशां कोरहयात धाल, “छ व छिमि फुक्‍क पुचः अले हारून नं कन्‍हय् परमप्रभुया न्‍ह्यःने वा। ");
INSERT INTO new_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","छिपिं फुक्‍कसिनं थथःगु गुँगू थनेगु मकः कयाः उकी गुँगू ति, अले फुक्‍कसिनं थथःगु गुँगू थनेगु मकः ज्‍वनाः वा। निसः व नेय्‌गू गुँगू थनेगु मकः परमप्रभुया न्‍ह्यःने हजि। हारून व छं नं थथःगु गुँगू थनेगु मकः हजि।” ");
INSERT INTO new_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","अले कन्‍हय् खुन्‍हु, इपिं छम्‍ह छम्‍हय्‌सिनं थथःगु गुँगू थनेगु मकः कयाः उकी मि च्‍याकाः गुँगू तल। अले इपिं मोशा व हारून नापं नापलायेगु पालया ध्‍वाखाय् दनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","कोरहं फुक्‍क खलःयात इमिगु विरोधय् नापलायेगु पालया ध्‍वाखाय् मुंकल। उबलय् परमप्रभुया महिमा फुक्‍क खलःयाथाय् खनेदत। ");
INSERT INTO new_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“थ्‍व खलःपाखें थःपिन्‍त अलग ति, जिं थुमित पलखं हे सिधय्‌काछ्वये।” ");
INSERT INTO new_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","अले मोशा व हारूनं बँय् भ्‍वपुयाः धाल, “हे परमेश्‍वर, फुक्‍क प्राणीतय्‌त सासः बियादीम्‍ह परमेश्‍वर, छम्‍ह मनुखं पाप याःगुलिं छु छि फुक्‍क खलःलिसें तं चायादियागु ला?” ");
INSERT INTO new_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","अनंलि परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“खलःयात धा, ‘कोरह, दातान व अबीरामया पालया न्‍ह्यःनं तापाक्‍क हुँ।’” ");
INSERT INTO new_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","मोशा दनाः दातान व अबीरामया थाय् वन, अले इस्राएलया थकालित नं वया ल्‍यू वन। ");
INSERT INTO new_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","खलःयात वं ख्‍याच्‍वः बिल, “थुपिं मभिंपिं मनूतय्‌गु पालपाखें तापाक्‍क च्‍वँ। अले इमिगु छुं नं थी मते, मखुसा इमिगु पापया हुनिं छिपिं नं मदयावनी।” ");
INSERT INTO new_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","अथे जुयाः कोरह, दातान व अबीरामया पालं इपिं तापाक्‍क वन। दातान व अबीराम इमि थथःपिनि कलाः व मचाखाचानापं थथःगु पालया लुखाय् दन। ");
INSERT INTO new_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","अले मोशां धाल, “थुकथं थुपिं फुक्‍क ज्‍या यायेत परमप्रभुं जितः छ्वयाहयादीगु खः धकाः छिमिसं सी। थ्‍व जिगु थःगु हे बिचाःकथं यानागु मखु। ");
INSERT INTO new_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","थुपिं मनूत नं फुक्‍क मेपिं मनूत थें कालगतिं सित धाःसा परमप्रभुं जितः छ्वयाहयादीगु मखु। ");
INSERT INTO new_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","तर परमप्रभुं छुं न्‍हूगु ज्‍या यानादिल धाःसा अले बँनं म्‍हुतु चाय्‌काः इमिगु फुक्‍क सामान नापं इमित नुनाछ्वल, अले इपिं म्‍वाः म्‍वाःकं पातालय् क्‍वहां वन धाःसा थुपिं मनूतय्‌सं परमेश्‍वरयात हेला याःगु हे दु धकाः छिमिसं सी।” ");
INSERT INTO new_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","वं थथे धाये धुंकाः इमिगु क्‍वय्‌या बँ चिरिबात। ");
INSERT INTO new_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","पृथ्‍वीं थःगु म्‍हुतु चाय्‌काः इमित, इमि छेँजः व कोरहया फुक्‍क मनूत व इमिगु फुक्‍क सम्‍पत्तिनापं घुर्काछ्वल। ");
INSERT INTO new_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","इपिं थःगु फुक्‍क सामान नापं म्‍वाःम्‍वाकं हे पातालय् क्‍वहां वन। पृथ्‍वीं इमित त्‍वपुल। इपिं खलःया दथुं नाश जुल। ");
INSERT INTO new_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","अन दुपिं मनूतय्‌सं इपिं चिल्‍लाय् दनाहाःगु सः न्‍यनाः “पृथ्‍वीं झीत नं घुर्का छ्वइ” धकाः धाधां बिस्‍युं वन। ");
INSERT INTO new_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","अले परमप्रभुया थासं मि पिहां वयाः गुँगू देछाःपिं निसः व नेय्‌म्‍ह मनूतय्‌त भस्‍म यानाबिल। ");
INSERT INTO new_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“हारून पुजाहारीया काय् एलाजारयात मिच्‍याःगु थासं गुँगू थनेगु मकःत लिका अले हेंग्‍वाःयात भचा तापाक्‍क यंकाः थुखे उखे ह्वलाब्‍यु धकाः धा। छाय्‌धाःसा उपिं गुँगू थनेगु मकःत पवित्रगु खः। ");
INSERT INTO new_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","पाप यानाः थःगु हे प्राणयात स्‍यंकूपिनिगु गुँगू थनेगु मकःतय्‌त मुगलं दादां वेदीइ हिनेगु पाता दय्‌कि। छाय्‌धाःसा उपिं परमप्रभुया न्‍ह्यःने देछाःगु जुयाः पबित्रगु खः। उपिं पाता धाःसा इस्राएलीतय्‌गु निंतिं चिं जुइमा।” ");
INSERT INTO new_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","एलाजार पुजाहारीं उपिं भस्‍म जूपिं मनूतय्‌सं देछाःगु कँय्‌यागु गुँगू थनेगु मकः काल, अले उपिं वेदीइ तयेत मुगलं दायाः पाता दय्‌कल, ");
INSERT INTO new_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","गथे परमप्रभुं मोशापाखें वयात धयादीगु खः। हारूनया सन्‍तान बाहेक मेम्‍ह सुं मनू गुँगू च्‍याकेत न्‍ह्यःने मवयेमा धकाः होशियार यायेत इस्राएलीतय्‌त थ्‍व फुक्‍क जूगु खः। मखुसा व नं कोरह व वया पुचः थें जुइ। ");
INSERT INTO new_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","कन्‍हय् खुन्‍हु इस्राएलया फुक्‍क खलकं मोशा व हारूनया विरोधय् थथे धकाः कचकच यात, “छिकपिन्‍सं हे परमप्रभुया मनूतय्‌त स्‍यानादीगु खः।” ");
INSERT INTO new_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","खलकं मोशा व हारूनया विरोधय् मुनाः नापलायेगु पालपाखे स्‍वःबलय् आकाझाकां उकियात सुपाचं त्‍वपुल, अले परमप्रभुयागु महिमा खनेदत। ");
INSERT INTO new_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","मोशा व हारून नापलायेगु पालया न्‍ह्यःने वल, ");
INSERT INTO new_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“छिपिं थ्‍व खलःपाखें चिला हुँ, अले जिं थुमित पलखं हे भस्‍म याये।” अले मोशा व हारून बँय् भ्‍वपुल। ");
INSERT INTO new_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","मोशां हारूनयात धाल, “छिगु गुँगू थनेगु मकः कयादिसँ, अले उकी वेदीं मि तयाः गुँगू तयादिसँ, अले याकनं हे व खलःयाथाय् यंकाः इमित प्रायश्‍चित याकि, छाय्‌धाःसा परमप्रभुया तं च्‍याये धुंकूगु दु, महामारी शुरु जूगु दु।” ");
INSERT INTO new_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","अले मोशां धाःथें हारून गुँगू थनेगु मकः ज्‍वनाः मुनाच्‍वंपिं मनूतय् दथुइ ब्‍वाँय् वन। महामारी वये धुंकूगुलिं वं गुँगू छायाः मनूतय्‌गु निंतिं प्रायश्‍चित यात। ");
INSERT INTO new_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","व सिनावनेधुंकूपिं व म्‍वानाच्‍वंपिं मनूतय्‌गु दथुइ दन, अले महामारी दित। ");
INSERT INTO new_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","कोरह नापं जानाः सीपिं त्‍वःता उबलय् महामारीं सीपिं झिंप्‍यद्वः व न्‍हय्‌सःम्‍ह (१४,७००) मनूत दु। ");
INSERT INTO new_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","महामारी दी धुंकाः हारून नापलायेगु पालय् मोशायाथाय् वल। ");
INSERT INTO new_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“इस्राएलीतलिसें खँ ल्‍हाः, अले इमि छगू छगू कुलया नायःपाखें छपु छपु यानाः झिंनिपु कथि का, अले छं इपिं फुक्‍कसिगु नां थथःगु कथिइ च्‍व। ");
INSERT INTO new_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","लेवीया कुलयागु कथिइ छं हारूनया नां च्‍व। छगू छगू कुलया नायःया निंतिं छपु छपु कथि दयेमाः। ");
INSERT INTO new_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","जिं छनापं नापलायेगु महा-पवित्र थासय् बाचाया सनूया न्‍ह्यःने उपिं तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","जिं ल्‍ययातःम्‍हय्‌सिगु कथिं चुलि पिहां वइ। थथे इस्राएलीतय्‌सं छंगु विरोधय् याना हे च्‍वनीगु कचकच मदय्‌काछ्वये।” ");
INSERT INTO new_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","अले मोशां इस्राएलीतय्‌त थ्‍व खँ न्‍यंकल। इमि नायःतय्‌सं थथःपिनि कुलकथं छम्‍ह छम्‍ह नायःया निंतिं छपु छपु यानाः झिंनिपु कथि वयात बिल। हारूनया कथि नं इमिगु कथिया दथुइ दु। ");
INSERT INTO new_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","मोशां उपिं कथि कयाः महा-पवित्र थासय् बाचाया सनूया न्‍ह्यःने तयाबिल। ");
INSERT INTO new_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","कन्‍हय् खुन्‍हु मोशा महा-पवित्र थासय् दुहां वन। अले लेवीया कुलया निंतिं तयातःगु हारूनया कथिं चुलि पिहां वःगु खन। उलि जक मखु, मुखू पिहां वयाः स्‍वां ह्वयाच्‍वंगु अले मर्स्‍याबरां नं सःगु जुल। ");
INSERT INTO new_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","अनंलि मोशां उपिं कथि परमप्रभुया न्‍ह्यःनं कयाः इस्राएलीतय्‌थाय् हल। अले इमिसं स्‍वयाः थथःगु कथि काल। ");
INSERT INTO new_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","परमप्रभुं मोशायात धयादिल, “विरोध याःपिनिगु निंतिं चिं थहरय् जुइत हारूनया कथियात बाचा चिनातःगु सनूया न्‍ह्यःने हानं यंका ति। अले जिगु विरोधय् याःगु इमिगु कचकचयात छं दिकाब्‍यु, मखुसा इपिं सिनावनी।” ");
INSERT INTO new_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","परमप्रभुं उजं बियादीगु थें मोशां फुक्‍क यात। ");
INSERT INTO new_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","इस्राएलीतय्‌सं मोशायात धाल, “स्‍वयादिसँ, जिपिं सिनावनी, जिपिं स्‍यन, जिपिं स्‍यन। ");
INSERT INTO new_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","परमप्रभुया नापलायेगु पालया सतिक वइम्‍ह न्‍ह्याम्‍ह नं सिनावनी। छु जिपिं फुक्‍क सिनावनी ला?” ");
INSERT INTO new_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","परमप्रभुं हारूनयात धयादिल, “पवित्र लागाय् जुइगु अपराधया जिम्‍मा छंगु, छिमि काय्‌पिनिगु व छिमि परिवारयागु जुइ। पुजाहारीया ज्‍या लिसे स्‍वापु दुगु ज्‍याखँयागु जिम्‍मा जक छंगु व छिमि काय्‌पिनिगु जुइ। ");
INSERT INTO new_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","छ व छिमि काय्‌पिन्‍सं नापलायेगु पालय् सेवा याः वनीबलय् छिमि लेवी कुलयापिं थःथितिपिन्‍त नं थःनापं ब्‍वनाहयेगु या। इमिसं छिमिगु ज्‍याय् ग्‍वाहालि बी। ");
INSERT INTO new_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","इमिसं छं धाःथें ज्‍या यायेमाः, अले नापलायेगु पालया ज्‍यायागु जिम्‍मा कायेमाः। तर इपिं पवित्र पालया सामान व वेदीया सतिक तक नं मवनेमाः, मखुसा इपिं नापं छिपिं नं सी। ");
INSERT INTO new_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","इमिसं छिमिगु क्‍वय् च्‍वनाः ज्‍या यायेमाः, अले नापलायेगु पालया ज्‍या यायेमाः। छिपिं दुथाय् मेपिं सुं नं मवयेमाः। ");
INSERT INTO new_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“छं हे पवित्र पाल व वेदीया रेखदेख यायेगु जिम्‍मा कायेमाः। गुकिं यानाः जिगु तं हाकनं इस्राएलीतय्‌त मलायेमा। ");
INSERT INTO new_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","जिं हे इस्राएलीतय्‌गु दथुं छिमि लेवी थःथितिपिन्‍त ल्‍ययागु दु। जिं इमित कोस्‍यालिकथं छन्‍त बियागु दु। इपिं नापलायेगु पालय् सेवा यायेत परमप्रभुयात अर्पण याःपिं खः। ");
INSERT INTO new_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","अय्‌नं छ व छिमि काय्‌पिन्‍सं जक वेदी व पवित्र पालया दुने वनाः पुजाहारीया ज्‍या याये फइ। जिं छिमित पुजाहारीया ज्‍या कोसेलिकथं बियागु दु। मेपिं सुं मनू अन वल धाःसा वयात स्‍यानाछ्वयेमाः।” ");
INSERT INTO new_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","हाकनं परमप्रभुं हारूनयात धयादिल, “इस्राएलीतय्‌सं जितः छायेहःगु फुक्‍क पवित्र देछा जिं छंगु जिम्‍माय् बियागु दु। छ पुजाहारी जुयाः ज्‍या याःगुलिं उपिं देछा छ व छिमि काय्‌पिन्‍त न्‍ह्याबलेंया भागकथं अलग यानागु दु। ");
INSERT INTO new_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","मिपाखें अलग यानातःगु तसकं पवित्रगु देछात छंगु हे जुइ। मनूतय्‌सं जितः छाय्‌हःगु तसकं पवित्रगु देछात अर्थात फुक्‍क अन्‍नबलि, पापबलि, व दोषबलिया व हे ब्‍व छ व छिमि काय्‌पिनिगु निंतिं जुइ। ");
INSERT INTO new_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","थ्‍व तसकं पवित्रगु ब्‍वकथं छं व न। फुक्‍क मिजंतय्‌सं व नयेमाः। थुकियात छं पवित्र ताय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“थुपिं नं छंगु जुइ, इस्राएलीतय्‌सं जितः छायेहःगु फुक्‍क संकाबीगु बलितपाखें अलग यानातःगु बलि। जिं थुकियात छ व छिमि काय् म्‍ह्याय्‌पिन्‍त न्‍ह्याबलेंया भागकथं बियागु दु। विधिकथं शुद्ध जूपिं छं छेँजःपिं फुक्‍कसिनं थ्‍व नये फइ। ");
INSERT INTO new_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“इस्राएलीतय्‌सं दँय्‌दसं जितः छायेहइगु न्‍हापांगु बालीया भिंगु भिंगु फुक्‍कं जिं छन्‍त हे बियागु दु, गथेकि, जैतूनया चिकं, न्‍हूगु दाखमद्य व अन्‍न। ");
INSERT INTO new_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","इमिसं परमप्रभुयात छायेहःगु सःगु फुक्‍ककथंयागु न्‍हापांगु फल छंगु हे जुइमाः। छंगु छेँजःयापिं शुद्ध जूपिं फुक्‍कसिनं व नयेफु। ");
INSERT INTO new_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“इस्राएलय् परमप्रभुयात देछाःगु न्‍ह्यागुं नं छंगु हे खः। ");
INSERT INTO new_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","परमप्रभुयात देछाःपिं न्‍हापां बूपिं मनू जूसां वा पशु जूसां छन्‍त हे खः। अय्‌नं काय्‌पिं वा अशुद्ध पशुतय् न्‍हापां बूपिन्‍त धाःसा छं लिफ्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","लच्‍छि दये धुंकाः पवित्र पालया शेकेलकथं छं क्‍वःछीगु न्‍यागू शेकेल मू पुलाः इमित लिफ्‍यायेमाः, छगू शेकेलया तौल निइगू गेरा दइ। ");
INSERT INTO new_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“अय्‌नं द्वहं, फै वा दुगुया न्‍हापां बूपिन्‍त लिफ्‍याये मते! इपिं पवित्रपिं खः। इमिगु हि वेदीइ छ्वाकि। अले परमप्रभुया निंतिं यःगु नस्‍वाः जुइत विशेष देछाकथं इमिगु दाः छ्वय्‌का छ्व। ");
INSERT INTO new_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","अले संकाबीगु बलिया ह्याकुला व जव खम्‍पा थें थुकियागु ला नं छंगु हे जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","इस्राएलीतय्‌सं परमप्रभुयात देछाइगु पवित्र बलिपाखें अलग तयातःगु फुक्‍क ब्‍व जिं छ व छिमि काय् म्‍ह्याय्‌पिन्‍त दया हे च्‍वनीगु भागकथं बियागु दु। परमप्रभुया न्‍ह्यःने छ व छिमि सन्‍तानया लागिं थ्‍व लिपाथ्‍यंक दयाच्‍वनीगु चियागु बाचा खः।” ");
INSERT INTO new_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","हानं परमप्रभुं हारूनयात धयादिल, “इस्राएलीतय् देशया जग्‍गा-जमिनय् छंगु सर्बय दइ मखु। इपिं नाप नापं छंगु छुं नं ब्‍व दइ मखु। इस्राएलीतय्‌गु दथुइ छंगु ब्‍व व सर्बय जि हे खः। ");
INSERT INTO new_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“लेवीया सन्‍तानतय्‌सं नापलायेगु पाललय् सेवा याःगुलिं इस्राएलीतय्‌सं जिथाय् हःगु झिब्‍वय् छब्‍व जिं इमित सर्बयकथं बियागु दु। ");
INSERT INTO new_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","आवंलि इस्राएलीत नापलायेगु पालया न्‍ह्यःने मवयेमाः। मखुसा इमिगु पापया कारणं इपिं सी। ");
INSERT INTO new_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","नापलायेगु पालया ज्‍या धाःसा लेवीतय्‌सं यायेमाः। उकिया विरोधय् जूगु अपराधया जिम्‍मा इमिसं हे कायेमाः। थ्‍व न्‍ह्याबलें इमिगु सन्‍तानया जिम्‍मा खः। इस्राएलीतय्‌गु दथुइ धाःसा इमिगु छुं नं सर्बय दइ मखु। ");
INSERT INTO new_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","थुकिया पलेसा जिं लेवीतय्‌त इमिगु सर्बयकथं इस्राएलीतय्‌सं परमप्रभुयात छाःगु झिब्‍वय् छब्‍व बी। अथे जुयाः ‘इस्राएलीतय् दथुइ इमित सर्बय दइ मखु’ धकाः जिं इमिगु बारे धयागु दु।” ");
INSERT INTO new_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“लेवीतय्‌त धा, ‘जिं छिमिगु सर्बयया निंतिं इस्राएलीतय्‌सं बी हःगु झिब्‍वय् छब्‍व कयाः वपाखें नं छिमिसं परमप्रभुयात झिब्‍वय् छब्‍व देछाकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","छिमिगु बलि खलाया अन्‍न व दाख तिस्‍सिगु सालया दाखमद्य थें ल्‍याः खाइ। ");
INSERT INTO new_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","थुकथं इस्राएलीतय्‌सं छिमित ब्‍यूगु झिब्‍वय् छब्‍वं छिमिसं नं परमप्रभुयात झिब्‍वय् छब्‍व देछा छायेमाः। उकिं परमप्रभुयात देछाःगु पुजाहारी हारूनयात बीमाः। ");
INSERT INTO new_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","छिमित ब्‍यूगु दकलय् भिंगु व पवित्र ब्‍व धाःसा देछाकथं परमप्रभुयात छायेमाः।’ ");
INSERT INTO new_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“छं लेवीतय्‌त धाः, ‘छिमिसं दकलय् भिंगु ब्‍व छाल धाःसा व छिमिगु निंतिं खलाया अन्‍न व दाख तिस्‍सिगु सालं दाखमद्य थें ल्‍याः खाइ। ");
INSERT INTO new_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","छिपिं व छिमि छेँजःपिन्‍सं न्‍ह्यागु हे थासय् थुकिया ल्‍यं दुगु नयेफु, छाय्‌धाःसा नापलायेगु पालय् छिमिसं याइगु ज्‍याया निंतिं थ्‍व छिमिगु ज्‍याला खः। ");
INSERT INTO new_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","छिमिसं भिंगु ब्‍व देछाये धुंकूगुलिं छिमित दोष लाइ मखु। अय्‌नं इस्राएलीतय् पवित्र देछा अशुद्ध मजुइमाः। अले छिपिं सी मखु।’” ");
INSERT INTO new_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","परमप्रभुं मोशा व हारूनयात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“परमप्रभुं बियादीगु व्‍यवस्‍थाया छगू नियम थ्‍व हे खः। ककुइ जुवा मलानिम्‍ह, खू मदुम्‍ह ह्याउँम्‍ह साचा छन्‍थाय् हजि धकाः इस्राएलीतय्‌त धा। ");
INSERT INTO new_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","छं एलाजार पुजाहारीयात व साचा ब्‍यु। वयात छाउनीं पिने यंकाः वयागु न्‍ह्यःने वयात स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","अनंलि एलाजार पुजाहारीं थःगु पतिंचां वयागु हि भतिचा कयाः नापलायेगु पालपाखे न्‍हय्‌कः छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","वं खंक हे व साचित, वयागु छेंगू, ला, हि व आतापुतिनापं छ्वयेका छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","अले पुजाहारीं देवदारुया सिँकचा, हिसपमा व ह्याउँगु का कयाः च्‍यानाच्‍वंम्‍ह साचाया च्‍वय् वांछ्वया बीमाः। ");
INSERT INTO new_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","अनंलि पुजाहारीं थःगु वसः हियाः लखं म्‍वःल्‍हुइमाः। अनंलि व छाउनीइ दुहां वयेफु। अय्‌नं व सन्‍ध्‍याकाः इलय् तक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","साचित छ्वय्‌कुम्‍हय्‌सिनं नं थःगु वसः हीमाः अले लखं म्‍वःल्‍हुइमाः। सन्‍ध्‍याकाः इलय् तक व नं अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“सुं छम्‍ह शुद्धम्‍ह मनुखं व साचायागु नउ मुंकेमाः, अले उकियात छाउनीं पिने छगू शुद्ध जूगु थासय् तयेमाः। थ्‍व नउ इस्राएली खलकं शुद्ध याइगु लखय् छ्यलेत तया तयेमाः। थ्‍व लः पाप चीकाछ्वयेगु ज्‍याझ्‍वलय् छ्यली। ");
INSERT INTO new_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","साचाया नउ मुंम्‍हय्‌सिनं थःगु वसः हीमाः अले सन्‍ध्‍याकाः इलय् तक व नं अशुद्ध जुइ। इस्राएलीत व इपिं नापं च्‍वंपिं परदेशीतय्‌गु निंतिं थ्‍व सदांया विधि जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“सीम्‍ह थ्‍यूम्‍ह मनू न्‍हय्‌न्‍हु तक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","वं थःत उगु लखं स्‍वन्‍हु खुन्‍हु व न्‍हय्‌न्‍हु खुन्‍हु शुद्ध यायेमाः, अले व शुद्ध जुइ। वं स्‍वन्‍हु खुन्‍हु व न्‍हय्‌न्‍हु खुन्‍हु थःत शुद्ध मयात धाःसा व शुद्ध जुइ मखु। ");
INSERT INTO new_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","सुनां सीम्‍ह थियाः थःत शुद्ध याइ मखु वं परमप्रभुया पवित्र पालयात अशुद्ध याइ। व मनूयात इस्राएलीतपाखें नाश याना छ्वयेमाः। शुद्ध यायेगु लखं वयात मछ्वाकूगुलिं व अशुद्धम्‍ह हे खः। वयागु अशुद्धता वयाके दया हे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“सुं मनू पालय् सित धाःसा उकियागु नियम थ्‍व हे खः, पालय् वइपिं व पाल दुने दुपिं मनूत न्‍हय्‌न्‍हु तक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","अले पुसां त्‍वपुयामतःगु थल फुक्‍क अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“हानं सुं मनुखं पिने तरवारं स्‍याःम्‍ह मनू वा थःगु कालगतिं सीम्‍ह मनूयात थिल धाःसा वा सीम्‍हयागु क्‍वँय् वा सीगाः थिल धाःसा व न्‍हय्‌न्‍हु तक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“व अशुद्धम्‍ह मनूयात शुद्ध यायेत शुद्ध जुइगु बलिकथं छ्वयेकूम्‍ह साया नउ कयाः थलय् तयाः उकी नीलः तयेमाः। ");
INSERT INTO new_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","अले छम्‍ह शुद्धम्‍ह मनुखं हिसपमा कयाः व लखय् थुनाः पाल, पालय् दुगु थलबल व अन दुपिं मनूतय्‌त छ्वाकेमाः। सीम्‍हया क्‍वँय्, स्‍याःम्‍ह मनूया सीम्‍ह, थःगु कालगतिं सीम्‍ह मनूयात वा सीगाःयात थ्‍यूम्‍ह मनूयात नं अथे हे छ्वाकेमाः। ");
INSERT INTO new_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","शुद्धम्‍ह मनुखं अशुद्ध जूम्‍ह मनूयात स्‍वन्‍हु खुन्‍हु व न्‍हय्‌न्‍हु खुन्‍हु व लखं छ्वाकेमाः। न्‍हय्‌न्‍हु खुन्‍हु वं अशुद्धम्‍ह मनूयात शुद्ध यायेमाः। अले शुद्ध जूम्‍हय्‌सिनं थःगु वसः हियाः म्‍वःल्‍हुइमाः, अले सन्‍ध्‍याकाः इलय् व शुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","अशुद्ध जूम्‍ह मनुखं थःत शुद्ध मयात धाःसा वयात खलःया दथुं नाश याना छ्वयेमाः, छाय्‌धाःसा वं परमप्रभुया पवित्र पालयात अशुद्ध यात। वयागु म्‍हय् शुद्ध यायेगु लखं मछ्वाकूगुलिं व अशुद्धम्‍ह हे जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","इमिगु निंतिं थ्‍व लिपा थ्‍यंकया नियम जुइमाः। “शुद्ध यायेगु लः छ्वाकूम्‍हय्‌सिनं नं थःगु वसः हीमाः। शुद्ध यायेगु लः थ्‍यूम्‍ह मनू नं सन्‍ध्‍याकाः इलय् तक अशुद्ध जुइ। ");
INSERT INTO new_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","अशुद्धम्‍ह मनुखं न्‍ह्यागु हे थ्‍यूसां व अशुद्ध जुइ। अले व थ्‍यूगु खँ मेम्‍हय्‌सिनं थिल धाःसा व नं सन्‍ध्‍याकाः इलय् तक अशुद्ध जुइ।” ");
INSERT INTO new_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","इस्राएलीतय्‌ फुक्‍क खलः न्‍हापांगु लाय् जीनयागु मरुभूमिइ थ्‍यंकः वयाः कादेशय् बाय् च्‍वन। मिरियम अन हे सित अले वयात अन थुनाबिल। ");
INSERT INTO new_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","खलःया निंतिं अन लः मदु। अले मोशा व हारूनया विरोधय् मनूत मुन। ");
INSERT INTO new_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","इमिसं मोशालिसे कचकच हालाः थथे धाल, “परमप्रभुया न्‍ह्यःने जिमि थःथितिपिं सीबलय् हे जिपिं नं सीगु जूसा ज्‍यूगु नि! ");
INSERT INTO new_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","आः ला जिमि पशुत नापं जिपिं सीगु जुल। छाय् परमप्रभुया खलःयात छिं थ्‍व मरुभूमिइ हयादियागु? ");
INSERT INTO new_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","छाय् जिमित मिश्रं थ्‍व ग्‍यानपुसे च्‍वंगु थासय् हयादियागु? थ्‍व थासय् अन्‍न, यःमरिसि, दाख व धालेसि छुं नं मदु। थन त्‍वनेगु लः नं मदु।” ");
INSERT INTO new_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","मोशा व हारून मूंपिं मनूतय्‌गु न्‍ह्यःनं नापलायेगु पालया ध्‍वाखाय् वनाः बँय् थ्‍यंक क्‍वछुनाः भ्‍वपुल। अन परमप्रभुया महिमा इमिथाय् खनेदत। ");
INSERT INTO new_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“थ्‍व कथि कयाः छ व छिमि दाजु हारून वनाः खलःयात मुंकि। इमिगु न्‍ह्यःने हे थ्‍व ल्‍वहंयात उजं ब्‍यु, अले ल्‍वहँतं लः पिहां वइ। छं थ्‍व ल्‍वहँतं इमित लः पिकाइ। थुकथं छं खलः व इमि सा द्वहंतय्‌त लः बी।” ");
INSERT INTO new_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","अले परमप्रभुं उजं बियादीगु थें मोशां वय्‌कःया न्‍ह्यःनं कथि काल। ");
INSERT INTO new_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","मोशा व हारूनं ल्‍वहंधीया न्‍ह्यःने खलःयात मुंकल। अले मोशां इमित धाल, “न्‍यँ, विद्रोही मनूत, छु जिमिसं छिमिगु निंतिं थ्‍व हे ल्‍वहँतं लः लिकयाबी ला?” ");
INSERT INTO new_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","मोशां थःगु ल्‍हाः ल्‍ह्वनाः निकः थःगु कथिं ल्‍वहँतय् दाल। उकिं लः पिहां वल। अले खलः व इमि पशुतय्‌सं त्‍वन। ");
INSERT INTO new_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","तर परमप्रभुं मोशा व हारूनयात धयादिल, “छिमिसं जितः विश्‍वास मयाःगुलिं अले जिगु पवित्रतायात इमिगु न्‍ह्यःने ब्‍वयेमफुगुलिं छिमिसं थ्‍व खलःयात जिं बियागु देशय् यंकेखनी मखु।” ");
INSERT INTO new_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","थ्‍व थाय्‌यात मेरीबाया लः धकाः धाल। थन हे इस्राएलीत परमप्रभुनापं कचकच याःगु खः। अन हे वय्‌कलं इमिगु दथुइ थःत पवित्र क्‍यनादीगु खः। ");
INSERT INTO new_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","मोशां कादेशं एदोमया जुजुयाथाय् थथे धकाः दूतत छ्वल, “छिमि इस्राएली थःथितिपिन्‍सं थथे धयाच्‍वन, जिमित जूगु दुःख छिं सी हे स्‍यू। ");
INSERT INTO new_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","जिमि पुर्खात मिश्र देशय् वंगु खः। अले जिपिं ताःई तक मिश्र देशय् च्‍वना। मिश्रीतय्‌सं जिपिं व जिमि पुर्खालिसें बांमलाःगु व्‍यवहार यात। ");
INSERT INTO new_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","अले परमप्रभुयात ग्‍वाहालिया निंतिं बिन्‍ति याना, वय्‌कलं जिमिगु बिन्‍ति न्‍यनादिल, अले छम्‍ह स्‍वर्गदूत छ्वयाहयाः जिमित मिश्र देशं लिगना हयादिल। “थुबलय् जिपिं छिगु देशया सिमाना लिक्‍क लाःगु कादेश शहरय् दु। ");
INSERT INTO new_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","दया यानाः जिमित छिगु देश जुयाः वनेबियादिसँ। जिपिं बुँ व दाखक्‍यब जुयावने मखु। जिमिसं छिगु तुंयागु लः त्‍वने मखु। जिपिं जुजुया मू लँ जक जुयाः वने। अले छिगु देशं पिहां मवंतले जिपिं जवय् खवय् वने मखु।” ");
INSERT INTO new_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","अय्‌नं एदोमं इमित धाल, “छिपिं जिमिगु देश जुयावने दइ मखु, मखुसा तरवार ज्‍वनाः जिमिसं छिमित हमला याः वये।” ");
INSERT INTO new_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","इस्राएलीतय्‌सं जुजुयाथाय् हानं धाय्‌के छ्वल, “जिपिं मू लँ जुया जक वने, अले जिमिसं व जिमि पशुतय्‌सं छिगु लः त्‍वंसा उकिया मू पुले। जिमित मेगु छुं मखु। छिगु देशं न्‍यासि वने जक बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","हानं इमिसं लिसः बिल, “छिपिं वये दइ मखु।” अले एदोमं छगू तःधंगु व बल्‍लाःगु सेना ज्‍वनाः इपिं लिसे ल्‍वायेत वल। ");
INSERT INTO new_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","थुकथं एदोमं इमिगु देश दुने जुयाः वने मब्‍यूगुलिं इस्राएलीत अनं लिहां वल। ");
INSERT INTO new_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","इस्राएलया फुक्‍क खलः कादेशं न्‍ह्यानाः होर पर्वतय् थ्‍यंकः वल। ");
INSERT INTO new_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","एदोम देशया सिमाना लिक्‍क होर पर्वतय् परमप्रभुं मोशा व हारूनयात थथे धयादिल, ");
INSERT INTO new_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“हारून सिनाः थः पुर्खातनापं मिलय् जू वनी। छिपिं निम्‍हं मेरीबाया लखय् जिगु वचनया विरोधय् वंगुलिं जिं इस्राएलीतय्‌त बीत्‍यनागु देशय् व वने दइ मखु। ");
INSERT INTO new_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","हारून व वया काय् एलाजारयात होर पर्वतया च्‍वय् ब्‍वनायंकि। ");
INSERT INTO new_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","अन हारूनयागु पुजाहारीया वसः त्‍वयेकाः वया काय् एलाजारयात फिकाब्‍यु। अनंलि हारून सिनाः थः पुर्खानापं मिलय् जू वनी, व अन हे सी।” ");
INSERT INTO new_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","परमप्रभुं उजं बियादीगु थें मोशां यात। फुक्‍क खलःया मिखाया न्‍ह्यःने हे इपिं होर पर्वतय् थहां वन। ");
INSERT INTO new_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","मोशां हारूनयागु पुजाहारीया वसः त्‍वय्‌काः वया काय् एलाजारयात फीकाबिल। अन हे पर्वतया च्‍वकाय् हारून सित। अले मोशा व एलाजार पर्वतं क्‍वय् कुहां वल। ");
INSERT INTO new_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","हारून सिनावंगु खँ फुक्‍क खलकं सिल, अले फुक्‍क इस्राएलीत स्‍विन्‍हु तक दुखं च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","नेगेवय् च्‍वनीम्‍ह आरादयाम्‍ह कनानी जुजुं इस्राएलीत अटारीम वनीगु लँ जुयाः वयाच्‍वंगु दु धयागु खँ न्‍यनाः व इपिं नापं ल्‍वाः वल। अले छुं मनूतय्‌त ज्‍वनाः यंकल। ");
INSERT INTO new_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","इस्राएलीतय्‌सं परमप्रभुयात थथे भाकल यानाः प्रार्थना यात, “छिं धात्‍थें हे थ्‍व मनूतय्‌त जिमिगु ल्‍हातय् बियादिल धाःसा जिमिसं इमित, इमिगु शहरतय्‌त छितः शर्त मतसें लःल्‍हाये अले इमित नाश याये।” ");
INSERT INTO new_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","परमप्रभुं इस्राएलीतय्‌गु बिन्‍ति न्‍यनाः कनानीतय्‌त इमिगु ल्‍हातय् बियादिल। इस्राएलीतय्‌सं इमित व इमिगु शहरतय्‌त भज्‍यंक नाश यानाबिल। अथे जुयाः व थाय्‌या नां होर्मा धकाः तल। ");
INSERT INTO new_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","इपिं एदोम देशं पिने पिने चाहिला वनेत होर पर्वतं लाल समुद्रया लँ जुयावन। अय्‌नं मनूत यात्राया हुनिं आय्‌बुल। ");
INSERT INTO new_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","अले इपिं परमेश्‍वर व मोशाया विरोधय् थथे धकाः हाल, “थ्‍व मरुभूमिइ सीत छाय् छिकपिन्‍सं जिमित मिश्र देशं हयादियागु? थन मरि मदु, लः नं मदु। थज्‍याःगु नसा नँनं जिपिं वाक्‍क जुइ धुंकल।” ");
INSERT INTO new_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","अले परमप्रभुं इमिगु थासय् बिख दुपिं सर्प छ्वयादिल अले सर्पतय्‌सं मनूतय्‌त न्‍यानाः तःम्‍ह हे इस्राएलीत सित। ");
INSERT INTO new_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","मनूत मोशाया न्‍ह्यःने वयाः धाल, “जिमिसं परमप्रभु व छिगु विरोधय् खँ ल्‍हानाः पाप यानागु दु। जिमिगु न्‍ह्यःनें सर्पत चीकादिसँ धकाः परमप्रभुयात प्रार्थना यानादिसँ।” अले मोशां इमिगु लागिं प्रार्थना यात। ");
INSERT INTO new_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","परमप्रभुं मोशायात धयादिल, “छं सर्पयागु छगू झ्‍वाता दय्‌काः उकियात थामय् यख्‍खानाब्‍यु। सर्पं न्‍याःपिं मनूतय्‌सं उकियात स्‍वये धुंकाः इपिं म्‍वाइ।” ");
INSERT INTO new_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","थथे मोशां कँय्‌याम्‍ह छम्‍ह सर्प दय्‌काः उकियात छगू थामय् यख्‍खानाबिल। अले सर्पं न्‍याःपिं मध्‍ये सुनां सुनां व कँय्‌याम्‍ह सर्पयात स्‍वल व मनू म्‍वात। ");
INSERT INTO new_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","इस्राएलीत न्‍ह्याः वनाः ओबोतय् पाल ग्‍वल। ");
INSERT INTO new_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ओबोतं न्‍ह्याः वनाः मोआबया पुर्बपाखे इये-अबारीमया मरुभूमिइ इमिसं पाल ग्‍वल। ");
INSERT INTO new_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","अनं इपिं न्‍ह्याः वनाः जेरेदया गालय् पाल ग्‍वल। ");
INSERT INTO new_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","अनं न्‍ह्याः वनाः इमिसं एमोरीतय्‌गु देशं पिहां वःगु मरुभूमिइ दुगु अर्नोन खुसियागु उखेपाखे पाल ग्‍वल। अर्नोन खुसि मोआब व एमोरीतय् दथुइच्‍वंगु सिमाना खः। ");
INSERT INTO new_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","अथे जुयाः परमप्रभुया युद्धयागु सफुलिइ थथे च्‍वयातःगु दु, “सूपाया वाहेब, न्‍हसिकापत व अर्नोन खुसि, ");
INSERT INTO new_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","अले तःगाःयागु पाचा, गुगु आर नांयागु शहरपाखे जुयाः मोआबयागु सिमानाय् तक वंगु दु।” ");
INSERT INTO new_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","अनं इपिं बेअरय् वन। परमप्रभुं मोशायात “मनूत मुं अले जिं इमित लः बी धकाः धयादीगु तुं अन हे दु।” ");
INSERT INTO new_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","उबलय् इस्राएलीतय्‌सं थ्‍व म्‍ये हाल, “हे तुं, लः पिका! उकिया बारे म्‍ये हा, ");
INSERT INTO new_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","व तुं शासकतय्‌सं म्‍हूगु खः। अले मनूतय् थकालितय्‌सं, लाय्‌कू कथिं व थःपिनिगु कथिं म्‍हूगु खः।” अले मरुभूमिं मत्तानाय् वन। ");
INSERT INTO new_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","मत्तानां नहलीएलय्, नहलीएलं बमोत तक वन। ");
INSERT INTO new_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","अनं इपिं मोआबया गालय् वन। अन दुगु पिसगाया च्‍वकां मरुभूमि खने दु। ");
INSERT INTO new_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","इस्राएलीतय्‌सं एमोरीतय् जुजु सीहोनयाथाय् थथे धयाः दूतत छ्वत, ");
INSERT INTO new_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“जिमित छिगु देश जुयावने बियादिसँ। जिपिं बुँ व दाखक्‍यबपाखे वने मखु। जिमिसं छिगु छगू नं तुंयागु लः त्‍वने मखु। छिगु देशं पिहां मवंतले जुजुया मू लँ जुयाः जक वने।” ");
INSERT INTO new_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","अय्‌नं सीहोनं इस्राएलीतय्‌त थःगु देशं जुयावने मब्‍यू। वं थः सेना मुंकाः इस्राएलीतनापं ल्‍वायेत मरुभूमिइ वयाः यहसाय् थ्‍यंकाः अन हे इपिं नापं ल्‍वात। ");
INSERT INTO new_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","अय्‌सां इस्राएलीतय्‌सं वयात तरवारं स्‍यात, अले अर्नोन खुसिंनिसें यब्‍बोक खुसि तक इमिगु देश त्‍याका काल। अम्‍मोनीतय्‌गु सिमाना तक जक त्‍याका काल, छाय्‌धाःसा इमिगु सिमाना बल्‍लाःगु खः। ");
INSERT INTO new_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","इस्राएलीतय्‌सं एमोरीतय्‌गु फुक्‍क शहर त्‍याका काल। इपिं एमोरीतय्‌गु फुक्‍क शहरय्, हेश्‍बोन व उकिया लिक्‍क लिक्‍क च्‍वंगु गामय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","हेश्‍बोन धाःसा एमोरीतय् जुजु सीहोनयागु शहर खः। छुं ई न्‍ह्यः वं मोआबया जुजुनापं ल्‍वानाः अर्नोन तक वयागु फुक्‍क देश वयागु ल्‍हातं लाकाकाःगु खः। ");
INSERT INTO new_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","अथे जुयाः चिनाखँमितय्‌सं थथे धाइगु, “हेश्‍बोनय् वा अले थ्‍व हानं दय्‌केमा, सीहोनया शहरयात हानं बांलाक दय्‌केमा। ");
INSERT INTO new_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","हेश्‍बोनं मि पिहां वल, सीहोनयागु शहरं छगू मिप्‍वाःला पिहां वल। उकिं मोआब देशयागु आर शहरयात अर्नोन खुसि च्‍वय्‌या ततःजाःगु थासय्‌यापिन्‍त भस्‍म यात। ");
INSERT INTO new_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","हे मोआब, छन्‍त धिक्‍कार दु! कमोश द्यःया प्रजा, छ नाश जुल! वं थः काय्‌पिन्‍त बिस्‍युं जूपिं थें व थः म्‍ह्याय्‌पिन्‍त दासी थें एमोरी जुजु सीहोनयात बिल। ");
INSERT INTO new_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","अय्‌नं आः ला जिमिसं इमित त्‍याकाःगु दु, हेश्‍बोननिसें दीबोन तक नाश जुइ धुंकल। जिमिसं नोपा व मेदबा तक नं इमित भज्‍यंक स्‍यंकाबी धुन।” ");
INSERT INTO new_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","थुकथं इस्राएली मनूत एमोरीतय्‌गु देशय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","मोशां याजेरय् चिवा काइपिं मनूत छ्वये धुंकाः इस्राएलीतय्‌सं उकिया प्‍यखेरं च्‍वंगु गां त्‍याका काल। अले अन दुपिं एमोरीतय्‌त लिनाछ्वत। ");
INSERT INTO new_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","अनंलि इपिं लिहां वयाः बाशान पाखेयागु लँ जुयाः थहां वन। बाशानयाम्‍ह जुजु ओग धाःसा इपिं नापं लडाइँ यायेत एद्रईलय् थः फुक्‍क सेनानापं पिहां वल। ");
INSERT INTO new_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","अले परमप्रभुं मोशायात धयादिल, “व खनाः ग्‍याये मते, छाय्‌धाःसा जिं वया फुक्‍क सेना व देशनापं छंगु ल्‍हातय् तयाबियागु दु। अले छं एमोरीतय् जुजु हेश्‍बोनय् च्‍वंम्‍ह सीहोनयात गथे यानागु खः वयात नं अथे हे या।” ");
INSERT INTO new_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","अथे जुयाः इमिसं वयात, वया काय्‌पिन्‍त अले वया फुक्‍क मनूतय् सुं छम्‍ह नं ल्‍यं मदय्‌क फुक्‍कसित स्‍यानाः इस्राएलीतय्‌सं इमिगु देश त्‍याका काल। ");
INSERT INTO new_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","अले इस्राएलीत न्‍ह्याः वनाः यरीहोया उखे यर्दन खुसिया सिथय् मोआबया ख्‍यलय् पालग्‍वया च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","इस्राएलीतय्‌सं एमोरीतय्‌त छु छु याःगु खः, व फुक्‍क मोआबया जुजु सिप्‍पोरया काय् बालाकं खन। ");
INSERT INTO new_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","इस्राएलीत यक्‍व अप्‍वः दुगुलिं मोआबीत ग्‍यात। इस्राएलीतय्‌गु हुनिं इपिं तसकं ग्‍यानाः थरथर खात। ");
INSERT INTO new_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","मोआबीतय्‌सं मिद्यानया थकालितय्‌त धाल, “थ्‍व हुलं झीगु प्‍यखेरं च्‍वंपिं फुक्‍क मनूतय्‌त द्वहं नं ख्‍यलय् च्‍वंगु वाउँगु घाँय् क्‍वाप्‍प नःगु थें क्‍वाप्‍प नयाबी।” उबलय् सिप्‍पोरया काय् बालाक मोआबया जुजु खः। ");
INSERT INTO new_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","वं यूफ्रेटिस खुसि लिक्‍क दुगु थःमनूतय्‌गु देश पतोरय् च्‍वंम्‍ह बओरया काय् बालामयाथाय् थथे धयाः दूतत छ्वत, “मिश्रं वःपिं मनूत वयाः देशया फुक्‍क थाय् त्‍वपुइ धुंकल। अले इपिं जिगु हे सिमानाय् वयाः बाय् च्‍वनाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","थुकथं झासँ, थुमित सराः बियादिसँ छाय्‌धाःसा इपिं जि स्‍वयाः बल्‍लाः। अथे यानादिल धाःसा सके जिं इमित त्‍याकाः देशं लिनाछ्वये फइ ला। छिं सुयात आशिष बियादी वयात आशिष लाइ, अले सुयात सराः बियादी वयात सराः लाइ धकाः जिं बांलाक स्‍यू।” ");
INSERT INTO new_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","मोआब व मिद्यानयापिं थकालितय्‌सं जुजुया ल्‍हातं भुलां ज्‍याला कयाः बालामयाथाय् वनाः जुजुयागु खँ न्‍यंकल। ");
INSERT INTO new_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","बालामं इमित धाल, “थौं चान्‍हय् थन हे च्‍वनादिसँ, अले परमप्रभुं जिनापं गथे खँ ल्‍हानादी व हे जिं छिकपिन्‍त कने।” अथे जुयाः मोआबी जुजुया मू मनूत व नापं बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","परमेश्‍वर बालामयाथाय् झायाः न्‍यनादिल, “छनापं च्‍वनाच्‍वंपिं थुपिं मनूत सु खः?” ");
INSERT INTO new_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","बालामं परमेश्‍वरयात धाल, “मोआबया जुजु सिप्‍पोरया काय् बालाकं जिथाय् थ्‍व खँ छ्वयाहयादीगु दु, ");
INSERT INTO new_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘मिश्रं वःपिं मनूत वयाः देशया फुक्‍क थाय् त्‍वपुइ धुंकल। छि झायाः जिगु निंतिं इमित सराः बियादिसँ। थथे यानादिल धाःसा सके जिं इपिं नापं ल्‍वानाः इमित लिनाछ्वये फइ ला।’” ");
INSERT INTO new_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","परमेश्‍वरं बालामयात धयादिल, “छ इपिं नापं वने मते। छं इमित सराः बी मते, छाय्‌धाःसा इपिं आशिष लाःपिं खः।” ");
INSERT INTO new_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","कन्‍हय् खुन्‍हु सुथ न्‍हापां बालाम दनाः बालाकया मू मनूतय्‌त धाल, “छिपिं थःगु देशय् लिहांझासँ छाय्‌धाःसा परमप्रभुं जितः छिकपिं नापं वने मते धकाः उजं बियादीगु दु।” ");
INSERT INTO new_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","अथे जुयाः मोआबीतय् मू मनूत बालाकयाथाय् लिहां वनाः धाल, “बालाम जिपिंलिसें वयेत मानय् मजुल।” ");
INSERT INTO new_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","अनंलि बालाकं हानं न्‍हापा स्‍वयाः यक्‍व व न्‍हापा स्‍वयाः तःधंपिं हाकिमत छ्वल। ");
INSERT INTO new_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","इमिसं बालामयाथाय् वयाः धाल, “सिप्‍पोरया काय् बालाकं थथे धयादी, छि जिथाय् वयेत छुकिं नं मपनेमाः। ");
INSERT INTO new_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","छाय्‌धाःसा जिं छितः ततःधंगु सिरपाः बियाः हनेगु याये। अले छिं छु धयादी जिं व हे याये। अथे जुयाः झासँ थुपिं मनूतय्‌त जिगु लागिं सराः बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","अले बालामं बालाकया दूततय्‌त थथे धकाः लिसः बिल, “बालाकं लुँ व वहलं जाःगु वयागु लाय्‌कू जितः ब्‍यूसां तबि जिमि परमप्रभु परमेश्‍वरया उजं चिधंगु वा तःधंगु खँपाखें जि तापाक वने मखु। ");
INSERT INTO new_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","अथे जुयाः न्‍हापायापिं थें छिकपिं नं थौं चान्‍हय् थन हेबाय् च्‍वनादिसँ, अले परमप्रभुं अज्‍ज मेगु छु धयादी व जिं सीके फइ।” ");
INSERT INTO new_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","परमेश्‍वर व चान्‍हय् बालामयाथाय् झायाः वयात धयादिल, “थुपिं मनूत छन्‍त सःतेत वःगुलिं इपिं नापं हुँ, अय्‌नं जिं छन्‍त छु छु धाये व हे जक छं या।” ");
INSERT INTO new_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","अले बालामं सुथ न्‍हापां दनाः थःगु गधाया म्‍हय् काठी चित, अले मोआबया नायःत नापं वन। ");
INSERT INTO new_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","व वंगुलिं परमेश्‍वर तंचायादिल, अले परमप्रभुया दूत वयाः वयागु लँ पनाबिल। व थःगु गधा गयावनाच्‍वंबलय् वया निम्‍ह च्‍यःत नं व नापं दुगु जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","परमप्रभुया दूतयात नांगा तरवार ज्‍वनाः लँय् दनाच्‍वंगु गधां खनाः गधा लँ त्‍वःताः बुँपाखे वन। गधायात लँय् हयेत बालामं वयात दाल। ");
INSERT INTO new_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","अनंलि निखेंपाखे पखाः दनातःगु निगू दाखक्‍यबया दथुइयागु चिब्‍यागु लँपुइ परमप्रभुया दूत दन। ");
INSERT INTO new_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","अले परमप्रभुया दूतयात खनाः गधा पःखालय् प्‍यपुन। थुकथं बालामयागु तुति पःखालं कात। अले वं वयात हानं दाल। ");
INSERT INTO new_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","अले परमप्रभुया दूत न्‍ह्यज्‍यायाः जव खव गन नं फहिले मज्‍यूगु चिब्‍यागु थासय् दन। ");
INSERT INTO new_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","गधा परमप्रभुया दूतयात खनेवं थचक्‍क फेतुत। बालामं तं पिकयाः थःगु कथिं गधायात दाल। ");
INSERT INTO new_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","अले परमप्रभुं गधायात नंवाकादिल। वं बालामयात धाल, “जिं छितः छु यानागु दु धकाः छिं जितः स्‍वकः दायादियागु?” ");
INSERT INTO new_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","बालामं गधायात धाल, “छं जितः हेस्‍यात। जिगु ल्‍हातय् तरवार दुगु जूसा जिं छन्‍त आः हे स्‍यानाबीगु।” ");
INSERT INTO new_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","गधां बालामयात धाल, “छु छिं थौं तक गयावयाच्‍वनाम्‍ह गधा जि हे मखु ला? जिं गुबलें छितः थथे यानागु दु ला?” अले वं धाल, “अथे याःगु मदु।” ");
INSERT INTO new_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","अले परमप्रभुं बालामया मिखा चाय्‌कादिल। वं नांगा तरवार ल्‍हातय् ज्‍वनाः दनाच्‍वंम्‍ह परमप्रभुया दूतयात खन, अले छ्यं क्‍वछुकाः व बँय् भ्‍वपुल। ");
INSERT INTO new_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","अले परमप्रभुया दूतं वयात धाल, “छं छाय् थः गधायात स्‍वकः दायागु? स्‍व! जि छंगु लँ पनेत वयागु दु, छाय्‌धाःसा जितः छंगु पहः भिं मता। ");
INSERT INTO new_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","थ्‍व गधां जितः खनाः स्‍वकः जिगु न्‍ह्यःनं चिला वन। व जिगु न्‍ह्यःनं चिलामवंगु जूसा जिं धात्‍थें छन्‍त स्‍याये धुन जुइ। गधायात धाःसा मस्‍यासे त्‍वःताबी धुन जुइ।” ");
INSERT INTO new_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","बालामं परमप्रभुया दूतयात धाल, “जिं पाप यानागु दु। छिं जिगु लँ पनेत दनाच्‍वनादीगु जिं मसिल। अथे जुयाः छितः थ्‍व मयःसा जि लिहां वने।” ");
INSERT INTO new_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","परमप्रभुया दूतं बालामयात धाल, “छ थुपिं मनूतनापं हुँ। अय्‌नं जिं छु छु धाये व हे जक छं धा।” अथे जुयाः बालाम बालाकया नायःत नापं वन। ");
INSERT INTO new_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","बालाकं बालाम वःगु खँ न्‍यनाः थःगु देशया यक्‍व पुर्बय् च्‍वंगु सिमानाय् लाःगु अर्नोन खुसि सिथय् च्‍वंगु मोआबया शहरय् वयात नापलाः वन। ");
INSERT INTO new_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","बालाकं बालामयात धाल, “जिं छितः सःतेत मनूत छ्वया, अय्‌नं छि छाय् याकनं जिथाय् झायामदीयागु? छु धात्‍थें जि छितः इज्‍जत याये बहःम्‍ह मजू ला?” ");
INSERT INTO new_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","अले बालामं बालाकयात धाल, “स्‍वयादिसँ! जि छिथाय् वयागु हे दु। अय्‌नं छु! जिं न्‍ह्यागु हे खँ धायेफु धकाः ला? परमेश्‍वरं जिगु म्‍हुतुइ छु तयादिल व हे जक जिं धायेफु।” ");
INSERT INTO new_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","बालाम बालाक नापं किर्यत-हुसोतय् वन। ");
INSERT INTO new_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","अन हे बालाकं द्वहं व फै बां बियाः बालाम अले व नापं वःपिं नायःतय्‌त नं छुं बिल। ");
INSERT INTO new_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","कन्‍हय् सुथय् बालाकं बालामयात बमोत-बालया च्‍वकाय् ब्‍वना यंकल। अनं बालामं इस्राएलीतय् छाउनीया छुं ब्‍व खन। ");
INSERT INTO new_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","बालामं बालाकयात धाल, “जिगु निंतिं थन न्‍हय्‌गू वेदी दय्‌कादिसँ, अले न्‍हय्‌म्‍ह द्वहं व न्‍हय्‌म्‍ह भ्‍याःचा नं तयार यानादिसँ।” ");
INSERT INTO new_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","बालामं धाःथें बालाकं यात, अले इमिसं वेदी पतिकं छम्‍ह छम्‍ह द्वहं व छम्‍ह छम्‍ह भ्‍याःचा छाल। ");
INSERT INTO new_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","अले बालामं बालाकयात धाल, “छि थःगु होमबलिया न्‍ह्यःने दनादिसँ। जि भचा उखे वने। जितः नापलायेत परमप्रभु झायादी ला! वय्‌कलं जितः छु क्‍यनादी व जिं छितः धाये।” उकिं व याकःचा हे बाझःगु डाँडाय् थहां वन। ");
INSERT INTO new_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","परमेश्‍वरं बालामयात नापलानादिल। बालामं वय्‌कःयात धाल, “जिं न्‍हय्‌गू वेदी दय्‌कागु दु। वेदी पतिकं छम्‍ह छम्‍ह द्वहंचा व भ्‍याःचा छायागु दु।” ");
INSERT INTO new_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","परमप्रभुं बालामया म्‍हुतुइ वचन तयादिल, अले धयादिल, “बालामयाथाय् लिहां वनाः छं धायेमाःगु खँ थ्‍व हे खः।” ");
INSERT INTO new_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","अले व लिहां वन। वं बालाक व मोआबया फुक्‍क नायःत थःगु होमबलिया लिक्‍क दनाच्‍वंगु खन। ");
INSERT INTO new_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","अले बालामं इमित थुकथं ईश्‍वरवाणी बिल, “झासँ, जिगु निंतिं याकूबयात सराः बियादिसँ! इस्राएलयात ख्‍याच्‍वः बियादिसँ! धकाः मोआबया जुजु बालाकं जितः अरामया पुर्बया डाँडांनिसें हल। ");
INSERT INTO new_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","परमेश्‍वरं सराः बियामदीपिन्‍त जिं गथे यानाः सराः बीगु? परमप्रभुं ब्‍वःबियामदीपिन्‍त जिं गथे यानाः ब्‍वःबियेगु? ");
INSERT INTO new_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ततःग्‍वःगु ल्‍वहं च्‍वकां जिं इमित खना ततःजाःगु गुँच्‍वकां जिं इमित स्‍वया। इपिं ला अलग च्‍वनीगु जाति खः। इमिसं थःपिन्‍त मेपिं स्‍वयाः अलग स्‍वइगु। ");
INSERT INTO new_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","याकूबया धू थें ग्‍वाः ग्‍वाः दुपिं सन्‍तानयात सुनां ल्‍याः खाये फइ? प्‍यब्‍वय् छब्‍व जक इस्राएलीतय्‌त नं सुनां ल्‍याः खाये फइ? जि धर्मीम्‍ह मनू थें सिनावने दयेमा! जिगु जीवन नं इमिगु थें फुनावने मा!” ");
INSERT INTO new_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","अले बालाकं बालामयात धाल, “छिं जितः छु यानादियागु? जिं छितः जिमि शत्रुतय्‌त सराः बीत सःतागु खः। छिं ला इमित छुं मयासें आशिष बियादिल।” ");
INSERT INTO new_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","वं लिसः बिल, “परमप्रभुं जिगु म्‍हुतुइ छु तयादिल व हे नवाये म्‍वाः ला?” ");
INSERT INTO new_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","अले बालाकं वयात धाल, “जिनापं मेथाय् झासँ। अनं इपिं मध्‍ये गुलिं गुलिंसित जक खनी। छिं इमित जक जूसां जिगु निंतिं सराः बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","बालाकं वयात पिसगाया च्‍वकाय् च्‍वंगु सोफीम धाःगु माथंवंगु थासय् यंकल। वं अन नं न्‍हय्‌गू वेदी दय्‌काः वेदी पतिकं छम्‍ह छम्‍ह द्वहं व छम्‍ह छम्‍ह भ्‍याःचा छाल। ");
INSERT INTO new_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","बालामं बालाकयात धाल, “जि परमप्रभुयात नापलाःवनेबलय् छि थन हे थःगु होमबलि नापं दनाच्‍वनादिसँ।” ");
INSERT INTO new_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","परमप्रभुं बाला मयात नापलानादिल। अले वयागु म्‍हुतुइ वचन तयाः थथे धयादिल, “बालाकयाथाय् लिहां हुँ अले वयात थथे धा।” ");
INSERT INTO new_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","अले व बालाकयाथाय् लिहां वन। बालाक व मोआबया नायःत थःगु होमबलिया न्‍ह्यःने दनाच्‍वन। बालाकं आय्‌बुयाः न्‍यन, “परमप्रभुं छु धयादीगु दु?” ");
INSERT INTO new_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","अले बालामं थ्‍व वचन धाल, “अय् बालाक दँ, अले न्‍यँ! अय् सिप्‍पोरया काय्, जिगु खँ न्‍यँ! ");
INSERT INTO new_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","परमेश्‍वर मनू थें मखु, मखुगु खँ ल्‍हायेत, वय्‌कः मनू मखु, थःगु मन हिलेत। वय्‌कलं धयादीगु खँ गुबलें मजूगु दु ला? वय्‌कलं बचं बियाः छु व पूवंकामदी ला? ");
INSERT INTO new_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","जितः ला आशिष बीगु उजं बियादीगु दु। वय्‌कलं इमित आशिष बियादीगु दु। उकिं जिं उकिया अःखः याये मफु। ");
INSERT INTO new_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","याकूबय् छुं मभिंगु खने मदु। अले इस्राएलय् छुं दुःख खने मदु। परमप्रभु इमि परमेश्‍वर इपिं नापं दी, इमिसं इमि जुजुया जय जुइमा धकाः च्‍वय्‌काच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","परमेश्‍वरं इमित मिश्रं पित हयादीगु दु। इमिगु बल जंगली द्वहंयागु थें च्‍वँ। ");
INSERT INTO new_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","याकूबयात छुं सरापं नं थी फइ मखु, छुं जादुं नं इस्राएलयात छुं याये फइ मखु। आः याकूब व इस्राएलया बारे थथे धाइ, ‘परमेश्‍वरं छु यानादिल व स्‍व!’ ");
INSERT INTO new_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","इपिं मिसाम्‍ह सिंह थें दनी, अले हय्‌क्‍कायेत्‍यंम्‍ह सिंह थें दनी। थःगु शिकार मस्‍यातले, अले वयागु हि मत्‍वंतले व सुम्‍क च्‍वनी मखु।” ");
INSERT INTO new_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","अले बालाकं बालामयात तमं धाल, “इमित सराः बीगु मखुसा आशिष नं बियादी मते!” ");
INSERT INTO new_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","बालामं बालाकयात धाल, “परमप्रभुं जितः छु धयादीगु खः जिं व हे यायेमाः धकाः धयागु मखु ला?” ");
INSERT INTO new_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","अले बालाकं बालामयात धाल, “झासँ, आः जिं छितः मेथाय् यंके। अनं ला परमेश्‍वरं छितः इमित सराः बीके बी ला?” ");
INSERT INTO new_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","अले बालाकं बालामयात पोर पर्वतया च्‍वकाय् यंकल। अनं मरुभूमि खने दु। ");
INSERT INTO new_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","बालामं बालाकयात धाल, “जिगु निंतिं थन न्‍हय्‌गू वेदी दय्‌काः न्‍हय्‌म्‍ह द्वहं व न्‍हय्‌म्‍ह भ्‍याःचा तयार यानादिसँ।” ");
INSERT INTO new_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","बालाकं बालामं धाःथें यानाः वेदी पतिकं छम्‍ह छम्‍ह द्वहं व छम्‍ह छम्‍ह भ्‍याःचा छाल। ");
INSERT INTO new_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","परमप्रभुं इस्राएलीतय्‌त आशिष बीगु मनंतुनादीगु खँ थुयाः बालामं न्‍हापालिपा थें तन्‍त्रमन्‍त्र यायेगु त्‍वःताः थःगु ख्‍वाः मरुभूमिपाखे फस्‍वय्‌कल। ");
INSERT INTO new_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","वं इस्राएलीतय्‌त कुल कुल जुयाः च्‍वनाच्‍वंगु खन। अले परमेश्‍वरयागु आत्‍मा वयाके वल। ");
INSERT INTO new_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","अले वं परमेश्‍वरयागु थ्‍व वचन नवात, “थ्‍व बओरया काय् बालामया अगमवाणी खः, मिखां बांलाक खंके फुम्‍ह मनूया अगमवाणी, ");
INSERT INTO new_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","परमेश्‍वरं धाःगु वचन न्‍यने फुम्‍ह दक्‍वसिबय् बल्‍लाःम्‍हपाखें दर्शन काये फुम्‍ह, अले मिखा चाय्‌काः बँय् भ्‍वपुइम्‍ह मनूया अगमवाणी। ");
INSERT INTO new_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","हे याकूब, छिमिगु पाल गुलि बांलाः! हे इस्राएल, छिमिगु छेँ गुलि यइपुसे च्‍वं! ");
INSERT INTO new_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ब्‍यासित तापाक्‍क न्‍यनावनाच्‍वंगु थें खुसि सिथय् च्‍वंगु क्‍यब थें परमप्रभुं पिनादीगु कुनुस्‍वां थें अले खुसि सिथय् च्‍वंगु देवदारुया सिमा थें, ");
INSERT INTO new_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","इमिगु घलं लः भय्‌बियावइ, इमिसं प्‍यूगु पुसायात माक्‍व लः दइ। इमि जुजु अगाग स्‍वयाः नं तःधं जुइ, इमिगु राज्‍य अज्‍ज तःधनावनी। ");
INSERT INTO new_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","परमेश्‍वरं इमित मिश्र देशं पित ब्‍वनाहल। इमिगु बल जंगली द्वहं थें च्‍वं। इमिसं थः शत्रुतय्‌त नुनाछ्वइ, अले इमिगु क्‍वँय् चुंचुं यानाबी, अले वाणं इमित सुयाबी। ");
INSERT INTO new_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","इपिं सिंहं थें फ्‍यतुनाच्‍वनी, मिसाम्‍ह सिंहयात थें इमित सुनां थने फइ? इमित आशिष ब्‍यूपिन्‍त आशिष लाइ, इमित सराः ब्‍यूपिन्‍त सराः लाइ।” ");
INSERT INTO new_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","बालाम खनाः बालाक तंम्‍वल। वं ल्‍हाः म्‍हुछ्यानाः बालामयात धाल, “जिं छितः जिमि शत्रुतय्‌त सराः बीत सःतागु खः, छिं ला इमित स्‍वकः स्‍वकः आशिष बियादिल। ");
INSERT INTO new_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","आः छि थनं लिहां झासँ! जिं छितः सिरपाः बी धकाः हयागु खः। परमप्रभुं छितः सिरपाः बीत पनादिल।” ");
INSERT INTO new_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","बालामं बालाकयात धाल, “छिं जिथाय् छ्वयाहयादीपिं दूततय्‌त जिं थथे धयागु मखु ला? ");
INSERT INTO new_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘बालाकं जितः लुँ व वहलं जाःगु थःगु लाय्‌कू ब्‍यूसां परमप्रभुया उजं त्‍वःताः जिं थःयसें भिं मभिं छुं नं याये मफु। परमप्रभुं छु धयादिल व हे जक जिं धाये फइ।’ ");
INSERT INTO new_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","आः जि थः मनूतय्‌थाय् लिहां वनेत्‍यना। वने न्‍ह्यः जिं छितः इस्राएलीतय्‌सं छिकपिनि मनूतय्‌त लिपा छु याइतिनि धकाः कनाथके।” ");
INSERT INTO new_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","अले वं परमेश्‍वरयागु थ्‍व वचन नवात, “थ्‍व बओरया काय् बालामया अगमवाणी खः, मिखां बांलाक खंके फुम्‍ह मनूया अगमवाणी, ");
INSERT INTO new_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","परमेश्‍वरं धाःगु वचन न्‍यने फुम्‍ह दक्‍व शक्ति दुम्‍ह परमेश्‍वरपाखें वःगु वचन न्‍यने फुम्‍ह। दक्‍वसिबय् बल्‍लाःम्‍हपाखें दर्शन काये फुम्‍ह अले मिखा चाय्‌काः बँय् भ्‍वपुइम्‍ह मनूया अगमवाणी। ");
INSERT INTO new_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","जिं वय्‌कःयात स्‍वये, तर आः थत्‍थें ला मखु। जिं वय्‌कःयात खंके, तर लिक्‍क हे ला मखु। याकूबं छगः नगु त्‍वइ, इस्राएलं छगू राजदण्‍ड पिहां वइ। वय्‌कलं मोआबया छ्यं तछ्यानादी। शेथया सन्‍तानयात नाश यानाबी। ");
INSERT INTO new_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","एदोमयात त्‍याकाकाइ। वया शत्रु सेइरयात नं त्‍याकाकाइ। इस्राएल झन झन बल्‍लानावइ। ");
INSERT INTO new_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","याकूबपाखें छम्‍ह शासक पिहां वइ अले वं अन च्‍वंपिं बचय्‌ जूपिं छम्‍ह छम्‍हय्‌सित नाश याइ।” ");
INSERT INTO new_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","बालामं अमालेकीतपाखे स्‍वयाः थुकथं थःगु वचन नवात, “अमालेक दक्‍वसिबय् तःधंगु जाति खः। तर नाश जुयाः थुपिं फुनावनी।” ");
INSERT INTO new_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","अले वं केनीतपाखे स्‍वयाः थुकथं वचन नवात, “छिपिं बल्‍लाक च्‍वनाच्‍वंगु दु, छिमिगु स्‍वँ ल्‍वहँतय् दय्‌कातःगु दु। ");
INSERT INTO new_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","तर अश्‍शूरीतय्‌सं छिमित ज्‍वना यंकीबलय्, छिपिं केनीत भज्‍यंक स्‍यनावनी।” ");
INSERT INTO new_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","वं थःगु वचन थथे धकाः नवात, “हाय, परमेश्‍वरं थथे यानादीबलय् सु जक ल्‍यनी? ");
INSERT INTO new_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","कित्तीमया सिथं जहाजत वइ, उमिसं अश्‍शूर व एबेरयात हमला याइ, तर इपिं नं न्‍हनावनी।” ");
INSERT INTO new_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","अनंलि बालाम थःगु छेँय् लिहां वन। बालाक नं थःगु लँ लिनावन। ");
INSERT INTO new_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","इस्राएलीत शित्तीमय् च्‍वनाच्‍वंबलय् इमिसं मोआबया म्‍ह्याय्‌पिं नापं व्‍यभिचार याना हल। ");
INSERT INTO new_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","इपिं मिस्‍तय्‌सं इमित थः द्यःतय्‌त बां बीगु नखःबलय् सःतल। मिजंतय्‌सं भ्‍वय् नयाः इमि द्यःतय्‌त पुजायात। ");
INSERT INTO new_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","थुकथं इस्राएलीतय्‌सं पोरया बालद्यःया पुजाय् ब्‍वति काल। अले इस्राएलीतलिसें परमप्रभु तंचायादिल। ");
INSERT INTO new_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","परमप्रभुं मोशायात धयादिल, “थुपिं मनूतय् सकल नायःतय्‌त ज्‍वँ! अले परमप्रभुया ग्‍यानपुसे च्‍वंगु तं इस्राएलीतपाखें चिलावनेमा धकाः परमप्रभुया न्‍ह्यःने इमित सकसिनं खंक सुयाः स्‍यानाब्‍यु।” ");
INSERT INTO new_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","मोशां इस्राएलयापिं न्‍यायाधीशतय्‌त धाल, “छिपिं छम्‍ह छम्‍हय्‌सिनं पोरया बालद्यःयात पुजाय् ब्‍वति काःपिं थः सकल मनूतय्‌त स्‍यायेमाः।” ");
INSERT INTO new_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","इस्राएलीत नापलायेगु पालया ध्‍वाखाय् ख्‍वयाच्‍वंबलय् हे छम्‍ह मनुखं मोशा व इस्राएलया फुक्‍क खलःया न्‍ह्यःने छम्‍ह मिद्यानी मिसायात थःगु छेँजःपिन्‍थाय् हल। ");
INSERT INTO new_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","व खनाः एलाजारया काय् पुजाहारी हारूनया छय् पीनहासं खलःया दथुं दनाः थःगु ल्‍हातय् भाला काल। ");
INSERT INTO new_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","अले व मिजंया ल्‍यूल्‍यू पाल दुने दुहां वनाः वयागु व मिसायागु प्‍वाथय् निम्‍हय्‌सितं छकलं पिचाय्‌कः भालां सुयाबिल। अनंलि इस्राएलीतय् दथुइ वःगु महामारी चिला वन। ");
INSERT INTO new_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","उगु महामारीइ २४,००० म्‍ह मनूत सिनावन। ");
INSERT INTO new_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","अले परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“एलाजारया काय्, हारून पुजाहारीया छय् पीनहासं उकिं यानाः जिगु तंयात इस्राएलीतपाखें फहिका बिल, छाय्‌धाःसा वयात इमिगु दथुइ जितः थें हे जोश वल। थुकथं थःगु जोशं जिं इमित नाश मयाना। ");
INSERT INTO new_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","अथे जुयाः जिं वलिसें जिगु शान्‍तिया बाचा ची धकाः धा। ");
INSERT INTO new_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","थ्‍व बाचाय् जिं वयात व वया सन्‍तानयात न्‍ह्याबलेंया लागिं पुजाहारी जुयाः ज्‍या यायेगु अधिकार बी। छाय्‌धाःसा परमेश्‍वरया लागिं वं नुगः मुइकल, अले इस्राएलीतय्‌गु निंतिं प्रायश्‍चित यात।” ");
INSERT INTO new_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","व मिद्यानी मिसानापं स्‍याःम्‍ह मनूया नां जिम्री खः, जिम्री सालूया काय् व शिमियोनया कुलया छगू छेँजःया नायः खः। ");
INSERT INTO new_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","अले व स्‍याःम्‍ह मिद्यानी मिसाया नां कोजबी खः, व मिद्यानया छेँजःया कुलनायः सूरया म्‍ह्याय् खः। ");
INSERT INTO new_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","हानं परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“मिद्यानीतय्‌त हमला यानाः नाश या। ");
INSERT INTO new_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","छाय्‌धाःसा पोरया हुनिं महामारी वःबलय् अले पोरया घटना व कोजबीया हुनिं छिमित ध्‍वंलाबलय् इमिसं छिमित हमला यात। कोजबी मिद्यानी नायःया म्‍ह्याय् व पोरया महामारी वःबलय् स्‍याःम्‍ह खः।” ");
INSERT INTO new_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","महामारी दी धुंकाः परमप्रभुं मोशा व हारून पुजाहारीया काय् एलाजारयात थथे धयादिल, ");
INSERT INTO new_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“इस्राएलया फुक्‍क खलःपाखें निइदँ व वस्‍वयां च्‍वय्‌यापिं लडाइँलय् वनेफुपिं मनूतय्‌त इमि थथःपिनि परिवारकथं ल्‍याःखा।” ");
INSERT INTO new_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","अले मोशा व एलाजार पुजाहारीं यरीहो शहरया उखे यर्दन खुसि सिथय् मोआबया ख्‍यलय् इमित मुंकाः थथे धाल, ");
INSERT INTO new_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“परमेश्‍वरं मोशायात उजं बियादी थें निइदँ व वस्‍वयां च्‍वय्‌यापिं मनूत ल्‍याःखा!” मिश्रं पिहांवःपिं इस्राएलीतय् सन्‍तान थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","इस्राएलया तःधिकःम्‍ह काय् रूबेनया सन्‍तान – हानोकपाखें हानोकीतय् वंश, पल्‍लुपाखें पल्‍लुईतय् वंश, ");
INSERT INTO new_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","हेस्रोनपाखें हेस्रोनीतय् वंश, कर्मीपाखें कर्मीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","रूबेनीया वंश थुपिं हे खः – इमि ल्‍याःखाःपिं मनूत ४३,७३० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","पल्‍लुया काय् एलीआब खः। ");
INSERT INTO new_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","एलीआबया काय्‌पिं नमूएल, दातान व अबीराम खः। दातान व अबीराम कोरहया पुचःनापं मिलय् जुयाः, मोशा व हारूनलिसे परमप्रभुया विरोध याःबलय् हाः वःपिं खलःया ल्‍ययातःपिं नायःत खः। ");
INSERT INTO new_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","पृथ्‍वीं थःगु म्‍हुतु चाय्‌काः इमित कोरह नापं हे नुनाछ्वःगु खः। कोरहया पुचःयापिं २५० म्‍ह मनूतय्‌त नं मिं नाश यात। अथे जुयाः इपिं छगू छुमां जुल। ");
INSERT INTO new_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","कोरहया काय्‌पिं धाःसा मसी। ");
INSERT INTO new_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","शिमियोनया सन्‍तान इमिगु वंशकथं थथे दु – नमूएलपाखें नमूएलीया वंश, यामीनपाखें यामीनीतय् वंश, याकीनपाखें याकीनीतय् वंश, ");
INSERT INTO new_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","जेरहपाखें जेरहातीतय् वंश, शौलपाखें शौलीतय् वंश, ");
INSERT INTO new_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","शिमियोनया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मनूत २२,२०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","गादया सन्‍तान इमि वंशकथं थथे दु – सेफोनपाखें सेफोनीतय् वंश, हाग्‍यीपाखें हाग्‍यीतय् वंश, शूनीपाखें शूनीतय् वंश, ");
INSERT INTO new_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ओजनीपाखें ओजनीतय् वंश, एरीपाखें एरीतय् वंश, ");
INSERT INTO new_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","अरोदीपाखें अरोदीतय् वंश, अरेलीपाखें अरेलीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","गादया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मनूत ४०,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","एर् व ओनान यहूदाया काय्‌पिं खः। तर इपिं कनान देशय् दुबलय् हे सित। ");
INSERT INTO new_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","यहूदाया सन्‍तान वंशकथं थथे दु – शेलाहपाखें शेलानीतय् वंश, फारेसपाखें फारेसीतय् वंश, जेरहपाखें जेरहातीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","फारेसया सन्‍तान थथे दु – हेस्रोनपाखें हेस्रोनीतय् वंश, हामूलपाखें हामूलीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","यहूदाया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मनूत ७६,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","इस्‍साखारया सन्‍तान वंशकथं थथे दु – तोलापाखें तोलाहीतय् वंश, पुवापाखें पुवातीतय् वंश, ");
INSERT INTO new_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","याशूबपाखें याशूबीतय् वंश, शिम्रोनपाखें शिम्रोनीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","इस्‍साखारया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मनूत ६४,३०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","जबूलूनया सन्‍तान वंशकथं थथे दु – सेरेदपाखें सेरेदीतय् वंश, एलोनपाखें एलोनीतय् वंश, यहलेलपाखें यहलेलीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","जबूलूनया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मनूत ६०,५०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","योसेफया सन्‍तान, मनश्‍शे व एफ्राइमया सन्‍तान वंशकथं थथे दु – ");
INSERT INTO new_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","मनश्‍शेया सन्‍तान – माकीरपाखें माकीरीतय् वंश। माकीरया काय् गिलादपाखें गिलादीतय् वंश। ");
INSERT INTO new_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","गिलादया सन्‍तान थुपिं हे खः ईएजेरपाखें ईएजेरीतय् वंश, हेलेकपाखें हेलेकीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","अस्रीएलपाखें अस्रीएलीतय् वंश, शकेमपाखें शकेमीतय् वंश, ");
INSERT INTO new_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","शमीदापाखें शमीदीतय् वंश, हेपेरपाखें हेपेरीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","हेपेरया काय् सलोफादया सुं काय् मदु, म्‍ह्याय्‌पिं जक दु। सलोफादया म्‍ह्याय्‌पिनिगु नां महला, नोअहा, होग्‍ला, मिल्‍का व तिर्सा खः। ");
INSERT INTO new_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","मनश्‍शेया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मनूत ५२,७०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","एफ्राइमया सन्‍तान वंशकथं थथे दु – शूतेलहपाखें शूतेलहीतय् वंश, बेकेरपाखें बेकेरीतय् वंश, तहनपाखें तहनीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","शूतेलहया सन्‍तान थथे दु – एरानपाखें एरानीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","एफ्राइमया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मिजंत ३२,५०० म्‍ह दु। योसेफया सन्‍तान वंशकथं थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","बेन्‍यामीनया सन्‍तान वंशकथं थथे दु – बेलापाखें बेलाहीतय् वंश, अश्‍बेलपाखें अश्‍बेलीतय् वंश, अहीरामपाखें अहीरामीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","शूपामपाखें शूपामीतय् वंश, हूपामपाखें हूपामीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","बेलाया सन्‍तान थथे दु – आर्दपाखें आर्दीतय् वंश, नामानपाखें नामानीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","बेन्‍यामीनया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मनूत ४५,६०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","दानया सन्‍तान वंशकथं थथे दु – शूहामपाखें शूहामीतय् वंश दत। दानया वंश थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","थुपिं सकल शूहामीतय् वंश खः। इमि ल्‍याःखाःपिं मनूत ६४,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","आशेरया सन्‍तान वंशकथं थथे दु – यिम्‍नापाखें यिम्‍नीतय् वंश, यिश्‍वीपाखें यिश्‍वीतय् वंश, बरीआपाखें बरीअतीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","अले बरीआया सन्‍तान थथे दु – हेबेरपाखें हेबेरीतय् वंश, मल्‍कीएलपाखें मल्‍कीएलीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","आशेरया म्‍ह्याय्‌या नां सेरह खः। ");
INSERT INTO new_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","आशेरया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मनूत ५३,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","नप्‍तालीया सन्‍तान वंशकथं थथे दु – यहसीलपाखें यहसीलीतय् वंश, गुनीपाखें गुनीतय् वंश, ");
INSERT INTO new_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","येसेरपाखें येसेरीतय् वंश, शिल्‍लेमपाखें शिल्‍लेमीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","नप्‍तालीया वंश थुपिं हे खः। इमि ल्‍याःखाःपिं मिजंत ४५,४०० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","इस्राएलया मुक्‍क ल्‍याःखाःपिं मिजं मनूत ६,०१,७३० म्‍ह दु। ");
INSERT INTO new_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“थुपिं पुर्खातय्‌त देश सर्बयया निंतिं इमिगु नांया ल्‍याःकथं इनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","तःधंगु पुचःयात तःधंगु सर्बय अले चिधंगु पुचःयात चिधंगु सर्बय ब्‍यु। फुक्‍कसित इमिगु थःगु सर्बय धलखय् दुथ्‍याःगु ल्‍याःकथं बीमाः। ");
INSERT INTO new_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","देश गोला तयाः इनाकायेमाः। फुक्‍क पुचःतय्‌त दइगु अंश इमिगु पुर्खायागु कुलया नांकथं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","तःधंगु पुचः जूसां चिधंगु पुचः जूसां इमिगु थथःगु सर्बय गोला तयाः इनाब्‍यु।” ");
INSERT INTO new_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","थथःगु वंशकथं ल्‍याःखाःपिं लेवीया सन्‍तानत थथे दु – गेर्शोनपाखें गेर्शोनीतय् वंश, कहातपाखें कहातीतय् वंश, मरारीपाखें मरारीतय् वंश दत। ");
INSERT INTO new_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","लेवीया कुलया वंशत थथे दु – लिब्‍नीतय् वंश, हेब्रोनीतय् वंश, महलीतय् वंश, मूशीतय् वंश, कोरहीतय् वंश। कहात अम्रामया पुर्खा खः। ");
INSERT INTO new_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","अम्रामया कलाःया नां लेवीया सन्‍तान योकेबेद खः। व लेवी कुलपाखें मिश्र देशय् बूम्‍ह खः। वं अम्रामपाखें हारून, मोशा व छम्‍ह म्‍ह्याय् मरियमयात बुइकल। ");
INSERT INTO new_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","नादाब, अबीहू, एलाजार व ईतामारया बौ हारून खः। ");
INSERT INTO new_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","नादाब व अबीहू धाःसा परमप्रभुया न्‍ह्यःने छाये मत्‍यःगु मि छाःबलय् सिनावन। ");
INSERT INTO new_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","लच्‍छि व लच्‍छिं च्‍वय्‌यापिं लेवी मिजंतय्‌गु ल्‍याः २३,००० म्‍ह दु। इमित मेपिं इस्राएलीतलिसें ल्‍याः मखा, छाय्‌धाःसा इमित इस्राएलीतय्‌गु दथुइ छुं सर्बय ब्‍यूगु मदु। ");
INSERT INTO new_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","मोशा व एलाजार पुजाहारीपाखें ल्‍याःखाःपिं थुपिं हे खः। इमिसं इस्राएलीतय्‌त यरीहो शहरया उखे यर्दन खुसिया सिथय् मोआबया ख्‍यलय् ल्‍याः खाःगु खः। ");
INSERT INTO new_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","मोशा व पुजाहारी हारूनं सीनैया मरुभूमिइ ल्‍याःखाःपिं छम्‍ह नं अन मदु। ");
INSERT INTO new_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","परमप्रभुं उपिं इस्राएलीतय्‌त मरुभूमिइ धात्‍थें सिनावनी धकाः धयादीगु खः। अथे जुयाः यपुन्‍नेया काय् कालेब व नूनया काय् यहोशू बाहेक उपिं मध्‍ये छम्‍ह नं मिजं म्‍वानामच्‍वं। ");
INSERT INTO new_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","सलोफाद हेपेरया काय् खः। हेपेर गिलादया काय् खः। गिलाद माकीरया काय् खः। माकीर मनश्‍शेया काय् खः, मनश्‍शे योसेफया काय् खः। सलोफादया न्‍याम्‍ह म्‍ह्याय्‌पिं दु। इमिगु नां महला, नोअहा, होग्‍ला, मिल्‍का व तिर्सा खः। ");
INSERT INTO new_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","इपिं वयाः नापलायेगु पालया ध्‍वाखाय् मोशा, एलाजार पुजाहारी, नायःत व फुक्‍क खलःया न्‍ह्यःने दनाः थथे धाल, ");
INSERT INTO new_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“जिमि बौ मरुभूमिइ सित। वय्‌कः परमप्रभुयागु विरोधय् दंम्‍ह कोरहया पुचलय् मदु। वय्‌कः थःगु हे पापया हुनिं सित, अले वय्‌कःया काय्‌पिं नं मदु। ");
INSERT INTO new_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","काय् मदुगुलिं जिमि बौया नां थःगु वंशपाखें छाय् न्‍हंकाछ्वयेगु? जिमि बौया थःथितिपिं नापं जिमित नं सम्‍पत्ति बियादिसँ।” ");
INSERT INTO new_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","इमिगु थ्‍व खँ मोशां परमप्रभुयाथाय् हल। ");
INSERT INTO new_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","परमप्रभुं वयात थथे धयादिल, ");
INSERT INTO new_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“सलोफादया म्‍ह्याय्‌पिन्‍सं पिकाःगु खँ पाय्‌छि जू। छं इमित इमि बौया थःथितिपिं नापं सर्बय‌कथं सर्बय बीमाः। छं इमिगु ल्‍हातय् इमि बौयागु सर्बय लःल्‍हानाब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“छं इस्राएलीतय्‌त थथे धा, ‘सुं मनू काय् मदय्‌क सिनावन धाःसा वयागु सर्बय वया म्‍ह्याय्‌यागु हे जुइ। ");
INSERT INTO new_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","वया सुं म्‍ह्याय् नं मदुसा वयागु सर्बय वया दाजुकिजापिन्‍त बीमाः। ");
INSERT INTO new_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","वया दाजुकिजापिं मदुसा वयागु सर्बय वया बौया दाजुकिजापिन्‍त बीमाः। ");
INSERT INTO new_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","वया बौया सुं दाजुकिजा नं मदुसा वयागु सर्बय वया वंशय् दकलय् सतिक थःलाःम्‍हय्‌सित ब्‍यु। अले वं उकियात थःगु यायेमाः। परमप्रभुं मोशायात उजं बियादी थें थ्‍व इस्राएलीतय्‌गु निंतिं न्‍याययागु नियम जुइ।’” ");
INSERT INTO new_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","परमप्रभुं मोशायात धयादिल, “छ थ्‍व अबीराम गुँझ्‍वलय् थहां हुँ। छं अनं जिं इस्राएलीतय्‌त बियागु देश स्‍व। ");
INSERT INTO new_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","छं व स्‍वये धुंकाः छ नं छिमि दाजु हारून थें सिनाः थः पुर्खानापं मिलय् जू वनी। ");
INSERT INTO new_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","छाय्‌धाःसा छिपिं निम्‍हय्‌सिनं जीनया मरुभूमिइ जिगु आज्ञाया विरोधय् विद्रोह यात। सकल इस्राएलया मनूतय्‌सं लःया निंतिं विद्रोह याःबलय् छिमिसं इमित जिगु पवित्रता क्‍यने मफुत।” (थ्‍व जीनया मरुभूमिइ मेरीबा कादेशया लखय् जूगु खः।) ");
INSERT INTO new_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","अले मोशां परमप्रभुयात धाल, ");
INSERT INTO new_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“फुक्‍क प्राणीतय्‌त सासः बियादीम्‍ह परमप्रभु परमेश्‍वरपाखें हे थ्‍व खलःया च्‍वय् छम्‍ह नायः ल्‍ययादिसँ! ");
INSERT INTO new_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","व इमिगु न्‍ह्यः न्‍ह्यः पिहां वनीम्‍ह व दुहां वइम्‍ह जुइमा, वं न्‍ह्यलुवाः जुयाः इमित यंकी, अले इमित दुने हइ। थुकथं परमप्रभुया मनूत जवाः मदुपिं फै थें जुइ मखु।” ");
INSERT INTO new_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","परमप्रभुं मोशायात धयादिल, “थज्‍याःगु आत्‍मा दुम्‍ह नूनया काय् यहोशूयात कयाः छं वयागु छेनय् थःगु ल्‍हाः ति। ");
INSERT INTO new_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","अले वयात एलाजार पुजाहारी व फुक्‍क खलःया न्‍ह्यःने थँ। इमिगु मिखाया न्‍ह्यःने हे वयात थ्‍व ज्‍या ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","इस्राएलया फुक्‍क खलकं वयात मानय् यायेमाः धकाः छं वयात छंगु छुं अधिकार ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","यहोशू पुजाहारी एलाजारया न्‍ह्यःने दनेगु यायेमाः, एलाजारं वयागु निंतिं परमप्रभुयाके ऊरीमपाखें फैसला न्‍यनेगु यायेमाः। यहोशूयागु हे उजंकथं फुक्‍क इस्राएलीत व नापं हे वयेगु व वनेगु यायेमाः।” ");
INSERT INTO new_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","थथे परमप्रभुं उजं बियादीकथं मोशां यात। वं यहोशूयात कयाः एलाजार पुजाहारी व फुक्‍क खलःया न्‍ह्यःने थन। ");
INSERT INTO new_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","परमप्रभुं मोशायात उजं बियादी थें वं थःगु ल्‍हाः यहोशूया छेनय् तल अले वयात मनूतय् नायः जुइगु जिम्‍मा बिल। ");
INSERT INTO new_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“इस्राएलीतय्‌त थथे धकाः उजं ब्‍यु, ‘जितः लय्‌ताय्‌कीगु नस्‍वाःगु विशेष देछा क्‍वःछीगु इलय् छायेत छिमिसं लुमंकि।’ ");
INSERT INTO new_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","“छं इमित थथे धा, ‘छिमिसं परमप्रभुया निंतिं छायेमाःगु विशेष देछा थ्‍व हे खः – निम्‍ह दच्‍छि दुपिं खू मदुपिं भ्‍याःचा न्‍हियान्‍हिथंया होमबलिकथं न्‍हिं न्‍हिं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","छम्‍ह भ्‍याःचा सुथय् अले मेम्‍ह सन्‍ध्‍याकाः इलय् छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","अन्‍नबलियात छगू हीनया प्‍यब्‍वय् छब्‍व भिंगु जैतून चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् छब्‍व भिंगु छुचुं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","थ्‍व सीनै पर्वतय् थापं याःगु न्‍ह्याबलेंया होमबलि खः। थ्‍व परमप्रभुयात लय्‌ताय्‌कीगु विशेष देछा नस्‍वाःगु होमबलि खः। ");
INSERT INTO new_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","न्‍हियान्‍हिथं न्‍हापांम्‍ह बां बीगु भ्‍याःचानापं त्‍वँसाबलिकथं छगू हीनया प्‍यब्‍वय् छब्‍व दाखमद्य वेदीइ छायेमाः। थ्‍व त्‍वँसाबलि नापलायेगु पालया चुकय् च्‍वंगु वेदीइ परमप्रभुया निंतिं प्‍वंकेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","सन्‍ध्‍याकाः इलय् मेम्‍ह भ्‍याःचायात सुथय् थें अन्‍नबलि व त्‍वँसाबलि नाप छायेमाः। थ्‍व परमप्रभुयात यःगु नस्‍वाःगु विशेष देछा खः। ");
INSERT INTO new_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘विश्रामबार खुन्‍हु निम्‍ह दच्‍छि दुपिं खू मदुपिं चिधिकःपिं भ्‍याःचा व उकी माःगु त्‍वँसाबलि व चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् निब्‍व भिंगु छुचुंया अन्‍नबलि नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","न्‍हियान्‍हिथं छाइगु होमबलि व त्‍वँसाबलि बाहेक विश्रामबार पतिकं छाइगु होमबलि थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘लायागु न्‍हापां खुन्‍हु छिमिसं परमप्रभुयात होमबलिया निंतिं निम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व दच्‍छि दुपिं न्‍हय्‌म्‍ह चिधिकःपिं भ्‍याःचा छायेमाः। थुपिं खू मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","छम्‍ह छम्‍ह द्वहंचानापं माःगु अन्‍नबलि थ्‍व जुइमाः – चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् स्‍वब्‍व भिंगु छुचुं। भ्‍याःचानापं माःगु अन्‍नबलि थ्‍व जुइमाः, चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् निब्‍व भिंगु छुचुं ");
INSERT INTO new_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","अले छम्‍ह छम्‍ह चिधिकःम्‍ह भ्‍याःचानापं माःगु अन्‍नबलि थ्‍व जुइमाः, चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् छब्‍व भिंगु छुचुं छायेमाः। थ्‍व परमप्रभुयात यःगु नस्‍वाःगु विशेष देछा, होमबलिया देछा खः। ");
INSERT INTO new_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","बां नाप माःगु त्‍वँसाबलि थथे जुइमाः, छम्‍ह छम्‍ह द्वहंचा नापं बच्‍छि हीन, भ्‍याःचानापं छगू हीनया स्‍वब्‍वय् छब्‍व, अले छम्‍ह छम्‍ह भ्‍याःचानापं छगू हीनया प्‍यब्‍वय् छब्‍व दाखमद्य छायेमाः। अमाइखुन्‍हु पतिकं छायेमाःगु होमबलि थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","होमबलि व त्‍वँसाबलि बाहेक शुद्ध जुइगु बलिया निंतिं दुगुचा छम्‍ह नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘न्‍हापांगु लाया झिंप्‍यन्‍हु दुखुन्‍हु परमप्रभुया छुत्‍काराया नखः हनेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","व लाया झिंन्‍यान्‍हुनिसें छवाः तक सोडा मतःगु मरिया नखः हनेगु यायेमाः। व नखःबलय् न्‍हय्‌न्‍हु तक सोडा मतःगु मरि नयेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","न्‍हापां खुन्‍हु पवित्र मुंज्‍या जुइमाः। उखुन्‍हु छिमिसं छुं हे न्‍हिज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","परमप्रभुयात विशेष देछाया निंतिं निम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा अले न्‍हय्‌म्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा होमबलिकथं छायेमाः। थुपिं फुक्‍क खू मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","इमिगु अन्‍नबलिया निंतिं छम्‍ह छम्‍ह द्वहंचा नापं चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् स्‍वब्‍व भिंगु छुचुं, भ्‍याःचानापं चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् निब्‍व भिंगु छुचुं हयेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","अले न्‍हय्‌म्‍ह भ्‍याःचानापं छम्‍ह पतिकं चिकं लुनातःगु छगू एपाया झिब्‍वय् छब्‍व भिंगु छुचुं नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","नापं छिमिगु प्रायश्‍चित यायेत छम्‍ह दुगुचा नं पापबलि यानाः छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","थ्‍व सोडा मतःगु मरिया नखःबलय् थ्‍व सुथया न्‍ह्याबलेंया होमबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","थुकथं न्‍हियान्‍हिथं छिमिसं नखःबलय् न्‍हय्‌न्‍हु तक हे परमप्रभुया निंतिं नस्‍वाःकथं विशेष देछा छायेमाः। थुपिं धाःसा न्‍हियान्‍हिथंया होमबलि व त्‍वँसाबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","अले न्‍हय्‌न्‍हु खुन्‍हु छिमिगु छगू पवित्र मुंज्‍या जुइमाः। उखुन्‍हु छुं हे न्‍हिज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘सामाज्‍याया नखःया न्‍हापांगु दिंखुन्‍हु, छिमिसं थःगु बुँइ सःगु बालीया न्‍हापांगु छ्व परमप्रभुयात छायेबलय् छिमिगु छगू पवित्र मुँज्‍या जुइमाः। उखुन्‍हु छिमिसं छुं हे ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","छिमिसं परमप्रभुयात लय्‌ताय्‌कीगु नस्‍वाःगु होमबलिकथं निम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व दच्‍छि दुपिं न्‍हय्‌म्‍ह भ्‍याःचा छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","अन्‍नबलिया निंतिं छम्‍ह छम्‍ह द्वहंचा नापं चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् स्‍वब्‍व भिंगु छुचुं, भ्‍याःचानापं छगू एपाया झिब्‍वय् निब्‍व ");
INSERT INTO new_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","अले न्‍हय्‌म्‍ह चिधिकःपिं भ्‍याःचानापं छम्‍ह पतिकं छगू एपाया झिब्‍वय् छब्‍व भिंगु छुचुं नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","छिमिगु प्रायश्‍चितया निंतिं छम्‍ह दुगुचा नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","न्‍हियान्‍हिथंया होमबलि व उकिया अन्‍नबलि बाहेक छिमिसं त्‍वँसाबलि नापं थुपिं नं छायेमाः। उपिं पशुत धाःसा खू मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘न्‍हय्‌गूगु लाया न्‍हापां खुन्‍हु छिमिगु छगू पवित्र मुँज्‍या जुइमाः। उखुन्‍हु छिमिसं छुं हे न्‍हिज्‍या याये मते। थ्‍व छिमिगु निंतिं फैया नेकूया तुरही पुइगु दिं खः। ");
INSERT INTO new_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","छिमिसं परमप्रभुयात लय्‌ताय्‌कीगु नस्‍वाःगु होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व न्‍हय्‌म्‍ह दच्‍छि दुपिं भ्‍याःचा छायेमाः। थुपिं फुक्‍क खू मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","इमिगु अन्‍नबलिया निंतिं द्वहंचा नापं चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् स्‍वब्‍व भिंगु छुचुं, भ्‍याःचानापं छगू एपाया झिब्‍वय् निब्‍व भिंगु छुचुं, ");
INSERT INTO new_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","अले न्‍हय्‌म्‍ह चिधिकःपिं भ्‍याःचानापं छम्‍ह पतिकं छगू एपाया झिब्‍वय् छब्‍व भिंगु छुचुं नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","नापं छिमिगु प्रायश्‍चित यायेत पापबलिया छम्‍ह दुगुचा नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","थुपिं न्‍हियान्‍हिथंया व अमाइ खुन्‍हुया होमबलि व उकियागु अन्‍नबलि व त्‍वँसाबलि बाहेक जुइमाः। थ्‍व परमप्रभुया निंतिं यःगु नस्‍वाःगु विशेष देछा खः। ");
INSERT INTO new_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘हानं व हे न्‍हय्‌गूगु लाया झिन्‍हु खुन्‍हु छिमिगु पवित्र मुंज्‍या जुइमाः। उखुन्‍हु छिमिसं छुं नये मते अले छिमिसं छुं हे ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","छिमिसं परमप्रभुयात लय्‌ताय्‌कीगु नस्‍वाःगु होमबलिकथं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व दच्‍छि दच्‍छि दुपिं न्‍हय्‌म्‍ह चिधिकःपिं भ्‍याःचायात देछायेमाः। थुपिं फुक्‍क खू मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","इमिगु अन्‍नबलिया निंतिं द्वहंचा नापं चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् स्‍वब्‍व भिंगु छुचुं, भ्‍याःचानापं छगू एपाया झिब्‍वय् निब्‍व, ");
INSERT INTO new_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","अले न्‍हय्‌म्‍ह चिधिकःपिं भ्‍याःचानापं छम्‍ह पतिकं छगू एपाया झिब्‍वय् छब्‍व छुचुं नं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","छिमिसं पापबलियात छम्‍ह दुगुचा नं छायेमाः। थ्‍व प्रायश्‍चितया पापबलि व न्‍ह्याबलेंयागु होमबलि व उकियागु अन्‍नबलि अले त्‍वँसाबलि बाहेक खः। ");
INSERT INTO new_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘न्‍हय्‌गूगु लाया झिंन्‍यान्‍हु खुन्‍हु छिमिगु छगू पवित्र मुँज्‍या जुइमाः। उखुन्‍हु छिमिसं छुं हे न्‍हिज्‍या याये मते। छिमिसं परमप्रभुया निंतिं न्‍हय्‌न्‍हु तक नखः हनेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","छिमिसं परमप्रभुयात लय्‌ताय्‌कीगु नस्‍वाःगु विशेष देछाकथं होमबलिया निंतिं खू मदुपिं झिंस्‍वँम्‍ह द्वहंचा, निम्‍ह भ्‍याःचा अले दच्‍छि दच्‍छि दुपिं झिंप्‍यम्‍ह चिधिकःपिं भ्‍याःचा छाये हयेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","उकियागु अन्‍नबलिया निंतिं छम्‍ह छम्‍ह द्वहंचा नापं चिकं ल्‍वाकछ्यानातःगु छगू एपाया झिब्‍वय् स्‍वब्‍व भिंगु छुचुं, छम्‍ह छम्‍ह भ्‍याःचानापं छगू एपाया झिब्‍वय् निब्‍व भिंगु छुचुं, ");
INSERT INTO new_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","अले झिंप्‍यम्‍ह छम्‍ह छम्‍ह चिधिकःम्‍ह भ्‍याःचा नापं छगू एपाया झिब्‍वय् छब्‍व भिंगु छुचुं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","पापबलियात छम्‍ह दुगुचा नं छायेमाः। थ्‍व न्‍हियान्‍हिथं छाइगु होमबलि अले उकिया अन्‍नबलि व त्‍वँसाबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘निन्‍हु खुन्‍हु छिमिसं झिंनिम्‍ह द्वहंचा, निम्‍ह भ्‍याःचा, झिंप्‍यम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा छायेमाः। थुपिं खू मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","द्वहंचात, भ्‍याःचात व फैचात नापं माःगु अन्‍नबलि व त्‍वँसाबलि इमिगु ल्‍याःकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","पापबलियात छम्‍ह दुगुचा नं छायेमाः। थ्‍व न्‍हियान्‍हिथं छाइगु होमबलि, उकिया अन्‍नबलि व इमिगु त्‍वँसाबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘हानं स्‍वन्‍हु खुन्‍हु छिमिसं झिंछम्‍ह द्वहंचा, निम्‍ह भ्‍याःचा व दच्‍छि दुपिं झिंप्‍यम्‍ह खू मदुपिं चिधिकःपिं भ्‍याःचात छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","द्वहंचात, भ्‍याःचात व चिधिकःपिं भ्‍याःचानापं माःगु अन्‍नबलि व त्‍वँसाबलि इमिगु ल्‍याःकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","पापबलिया निंतिं छम्‍ह दुगुचा नं छायेमाः। थ्‍व न्‍हियान्‍हिथं छाइगु होमबलि अले उकिया अन्‍नबलि व त्‍वँसाबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘प्‍यन्‍हु खुन्‍हु झिम्‍ह द्वहंचा, निम्‍ह भ्‍याःचा, खू मदुपिं झिंप्‍यम्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचा छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","द्वहंचात, भ्‍याःचात अले चिधिकःपिं भ्‍याःचातनापं माःगु अन्‍नबलि व त्‍वँसाबलि इमिगु ल्‍याःकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","पापबलियात छम्‍ह दुगुचा नं छायेमाः। थ्‍व न्‍हियान्‍हिथं छाइगु होमबलि उकियागु अन्‍नबलि व त्‍वँसाबलि बाहेक थ्‍व छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘हानं न्‍यान्‍हु खुन्‍हु गुम्‍ह द्वहंचा, निम्‍ह भ्‍याःचा, अले दच्‍छि दुपिं झिंप्‍यम्‍ह खू मदुपिं चिधिकःपिं भ्‍याःचात छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","द्वहंचात, भ्‍याःचात अले चिधिकःपिं भ्‍याःचातनापं माःगु अन्‍नबलि व त्‍वँसाबलि इमिगु ल्‍याःकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","पापबलिया निंतिं छम्‍ह दुगुचा नं छायेमाः। थ्‍व न्‍हियान्‍हिथं छाइगु होमबलि अले उकिया अन्‍नबलि व त्‍वँसाबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘हानं खुन्‍हु दुखुन्‍हु च्‍याम्‍ह द्वहंचा व निम्‍ह भ्‍याःचा व दच्‍छि दच्‍छि दुपिं झिंप्‍यम्‍ह खू मदुपिं चिधिकःपिं भ्‍याःचात छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","द्वहंचात, भ्‍याःचात व चिधिकःपिं भ्‍याःचातनापं माःगु अन्‍नबलि व त्‍वँसाबलि इमिगु ल्‍याःकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","पापबलियात छम्‍ह दुगुचा नं छायेमाः। थ्‍व न्‍हियान्‍हिथं छाइगु होमबलि व उकियागु अन्‍नबलि व त्‍वँसाबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘हानं न्‍हय्‌न्‍हु खुन्‍हु न्‍हय्‌म्‍ह द्वहंचा व निम्‍ह भ्‍याःचा, व दच्‍छि दच्‍छि दुपिं झिंप्‍यम्‍ह चिधिकःपिं भ्‍याःचात छायेमाः। थुपिं फुक्‍क पशुत खू मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","द्वहंचात, भ्‍याःचात व चिधिकःपिं भ्‍याःचातनापं माःगु अन्‍नबलि व त्‍वँसाबलि इमिगु ल्‍याःकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","पापबलियात छम्‍ह दुगुचा नं छायेमाः। थ्‍व न्‍हियान्‍हिथं छाइगु होमबलि व उकियागु अन्‍नबलि व त्‍वँसाबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘च्‍यान्‍हु खुन्‍हु छिमिगु छगू तःमुंज्‍या जुइमाः। उखुन्‍हु छुं नं न्‍हिज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","उखुन्‍हु छिमिसं परमप्रभुयात लय्‌ताय्‌कीगु नस्‍वाःगु विशेष देछाकथं छाइगु होमबलिया निंतिं छम्‍ह द्वहंचा, छम्‍ह भ्‍याःचा व न्‍हय्‌म्‍ह दच्‍छि दुपिं चिधिकःपिं भ्‍याःचात छायेमाः। थुपिं फुक्‍क पशुत खू मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","द्वहंचा, भ्‍याःचा व चिधिकःपिं भ्‍याःचातनापं माःगु अन्‍नबलि व त्‍वँसाबलि इमिगु ल्‍याःकथं छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","पापबलियात छम्‍ह दुगुचा नं छायेमाः। थ्‍व न्‍हियान्‍हिथं छाइगु होमबलि व उकियागु अन्‍नबलि व त्‍वँसाबलि बाहेक छायेमाः। ");
INSERT INTO new_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘छिमिगु थःयसेंया बलि व भाकल बाहेक छिमिसं होमबलि, अन्‍नबलि, त्‍वँसाबलि व मेलबलित छिमिगु क्‍वछिनातःगु नखःबलय् परमप्रभुयात छायेमाः।’” ");
INSERT INTO new_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","परमप्रभुं मोशायात उजं बियादीगु फुक्‍क खँ मोशां इस्राएलीतय्‌त न्‍यंकल। ");
INSERT INTO new_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","मोशां इस्राएली कुलनायःतय्‌त थथे धाल, “परमप्रभुं थ्‍व उजं बियादीगु दु – ");
INSERT INTO new_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","सुं मनुखं परमप्रभुलिसें भाकल यात धाःसा वा बचं बियाः पाफल धाःसा वं थःगु बचं पूवंकेमाः। वं थःगु वचन त्‍वःथुले मज्‍यू। वयागु म्‍हुतुं छु बचं पिहां वःगु खः वं व याये हे माः। ");
INSERT INTO new_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“थः बौया छेँय् च्‍वनाच्‍वंबलय् हे सुं ल्‍यासेम्‍ह मिसां परमप्रभुलिसें भाकल यात वा बचं बियाः पाफल धाःसा, ");
INSERT INTO new_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","अले व भाकल वा बचं ब्‍यूगु न्‍यनाः नं वया बौ सुम्‍क च्‍वन धाःसा पाफःगु व बचं ब्‍यूगु दया हे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","अय्‌नं वया बौनं न्‍यंगु दिनय् हे वयात पन धाःसा वं याःगु भाकल व थःत ब्‍यूगु बचं छगू नं दयाच्‍वनी मखु। वया बौनं वयात पंगु जुयाः परमप्रभुं वयात क्षमा यानादी। ");
INSERT INTO new_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“भाकल याये धुंकाः वा बिचाः मयासें बचं बीधुंकाः वयागु ब्‍याहा जुल धाःसा, ");
INSERT INTO new_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","अले वया भाःतं व खँ न्‍यनाः उखुन्‍हु वयात छुं मधाल धाःसा वयागु भाकल वा बचं ब्‍यूगु दया हे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","अय्‌नं वया भाःतं व खँ न्‍यनाः व हे दिनय् वयात पन धाःसा वयागु भाकल वा वं ब्‍यूगु बचं ज्‍यालगय् जुइ मखु। परमप्रभुं व मिसायात क्षमा यानादी। ");
INSERT INTO new_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“भाःत सी धुंकूम्‍ह वा भाःतनापं बिस्‍कं च्‍वने धुंकूम्‍ह मिसां याःगु भाकल वा ब्‍यूगु बचं धाःसा दया हे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“भाःतया छेँय् च्‍वनाच्‍वंम्‍ह सुं मिसां भाकल याःसा वा बचं बियाः पाफःसा ");
INSERT INTO new_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","अले व भाकल वा ब्‍यूगु बचं न्‍यनाः नं वया भाःत सुम्‍क च्‍वनाः मपन धाःसा व भाकल वा ब्‍यूगु बचं दया हे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","अय्‌नं वया भाःतं व न्‍यंगु दिनय् वयागु भाकल वा ब्‍यूगु बचंयात पन धाःसा वयागु म्‍हुतुं पिहां वःगु बचं ज्‍यालगे जुइ मखु। परमप्रभुं व मिसायात क्षमा यानादी। ");
INSERT INTO new_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","व मिसां थःगु जीवनयात दुःख बीगु भाकल वा बचं ब्‍यूगु दुसा वया भाःतं यःसा तयातये फइ, मयःसा तये फइ मखु। ");
INSERT INTO new_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","तर वया भाःतं न्‍हियान्‍हिथं छुं मधासें सुम्‍क च्‍वन धाःसा वयागु फुक्‍क भाकल वा ब्‍यूगु बचं दया हे च्‍वनी। न्‍यनाः नं व सुम्‍क च्‍वंगुलिं ज्‍यू धाःगु थें हे खः। ");
INSERT INTO new_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","तर वं थ्‍व न्‍यनाः छुं ई लिपा त्‍वाल्‍हात धाःसा थः कलाःया द्वं वं हे फयेमाः।” ");
INSERT INTO new_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","कलाः भाःतया दथुइ अले बौ व वया छेँय् च्‍वनीम्‍ह ब्‍याहा मजूम्‍ह म्‍ह्याय्‌या दथुइ मोशायात परमप्रभुं बियादीगु नियम थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“इस्राएलीतय्‌गु निंतिं मिद्यानीतय्‌त बदला का! अनं लिपा छ सिनाः थः पुर्खातनापं मिलय् जू वनी।” ");
INSERT INTO new_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","अथे जुयाः मोशां मनूतय्‌त थथे धाल, “मिद्यानीतलिसें ल्‍वायेत व इपिं नापं परमप्रभुया बदला कायेत छिपिं मध्‍ये छुं मिजंतय्‌त ल्‍वाभः ज्‍वंकि। ");
INSERT INTO new_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","इस्राएलया छगू छगू कुलं द्वःछिम्‍ह द्वःछिम्‍ह मनूत लडाइँ यायेत छ्व।” ");
INSERT INTO new_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","अथे जुयाः इस्राएलीतय् फुक्‍क वंशपाखें द्वःछिम्‍ह द्वःछिम्‍ह यानाः झिंनिद्वःम्‍ह ल्‍वाभः ज्‍वनातःपिं मनूत ल्‍यल। ");
INSERT INTO new_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","मोशां छगू छगू कुलं द्वःछिम्‍ह द्वःछिम्‍ह मनूतय्‌त लडाइँलय् छ्वत। एलाजार पुजाहारीया काय् पीनहास इमि नायः जुल। मोशां पीनहासयात पवित्र लागाया सामान व लडाइँ घोषणा याइगु तुरहीतय्‌गु जिम्‍मा बिल। ");
INSERT INTO new_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","परमप्रभुं मोशायात उजं बियादीगु थें इपिं मिद्यानीतलिसें लडाइँ यात। इमिसं इमि दक्‍व मिजंतय्‌त स्‍यानाबिल। ");
INSERT INTO new_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","स्‍यूपिं मनूत मध्‍ये मिद्यानया न्‍याम्‍ह जुजुपिं एवी, रेकेम, सूर, हूर व रेबा नं दुगु जुयाच्‍वन। इमिसं बओरया काय् बालामयात नं तरवारं स्‍यात। ");
INSERT INTO new_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","इस्राएलीतय्‌सं मिद्यानी मिस्‍तय्‌त व मस्‍तय्‌त ज्‍वनाः कुन अले इमि दक्‍व सा द्वहं, फैच्‍वलय्‌त व फुक्‍क सम्‍पत्ति लाकाकाल। ");
INSERT INTO new_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","अले इपिं च्‍वनाच्‍वंगु फुक्‍क शहरतय्‌त व छाउनीतय्‌त छ्वयेकाबिल। ");
INSERT INTO new_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","अले इपिं थःपिन्‍सं लाकाकाःगु सामान व थःपिन्‍सं ज्‍वंपिं मनूत व पशुत ज्‍वनाः वन। ");
INSERT INTO new_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","अले उपिं ज्‍वनातःपिं मनूतय्‌त, पशुतय्‌त व लाकाकाःगु सामान यरीहो शहरया उखे यर्दन खुसिया सिथय् मोआबया ख्‍यलय् दुगु छाउनीइ मोशा, एलाजार पुजाहारी व इस्राएलया फुक्‍क खलःयाथाय् हल। ");
INSERT INTO new_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","अले इपिं नापं नापलायेत मोशा, एलाजार पुजाहारी व खलःया फुक्‍क नायःत छाउनी पिने वल। ");
INSERT INTO new_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","लडाइँनं लिहांवःपिं द्वःछि द्वःछिम्‍ह सिपाइँतय्‌ नायःत व सछि सछिम्‍ह सिपाइँतय्‌ नायःत खनाः मोशा तंचाल। ");
INSERT INTO new_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","मोशां इमित धाल, “छु! छिमिसं सकल मिस्‍तय्‌त म्‍वाका हे तयागु ला? ");
INSERT INTO new_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","थुमिसं हे बालामया खँ न्‍यनाः इस्राएलीतय्‌त पोरय् परमप्रभुयागु विरोधय् विश्‍वासघात याकूगु खः। अथे जुयाः खलःया दथुइ महामारी वःगु खः। ");
INSERT INTO new_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","अथे जुयाः आः फुक्‍क मिजंमस्‍त व मिजंनापं द्यने धुंकूपिं मिसातय्‌त स्‍यानाछ्व। ");
INSERT INTO new_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","तर सकल कन्‍या मिस्‍तय्‌त धाःसा छिमिसं थःपिनिगु लागिं म्‍वाकाः हे ति। ");
INSERT INTO new_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“छिपिं मध्‍ये ग्‍वःम्‍हय्‌सिनं सुं मनूयात स्‍याःगु दु वा ग्‍वःम्‍हय्‌सिनं सीम्‍ह थ्‍यूगु दु इपिं फुक्‍क न्‍हय्‌न्‍हु तक छाउनीं पिने च्‍वनेमाः। स्‍वन्‍हु खुन्‍हु व न्‍हय्‌न्‍हु खुन्‍हु छिमिसं थःपिन्‍त व थः कैदीतय्‌त शुद्ध या। ");
INSERT INTO new_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","छिमिसं फुक्‍क वसः, छेंगूयागु फुक्‍क ज्‍वलं, दुगुचाया सँ, अले सिँयागु फुक्‍क सामान शुद्ध या।” ");
INSERT INTO new_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","अले एलाजार पुजाहारीं लडाइँलय् वंपिं मिजंतय्‌त धाल, “परमप्रभुं मोशायात थ्‍व विधि बियादीगु दु। ");
INSERT INTO new_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","लुँ, वहः, कँय्, न, जस्‍ता व म्‍हः ");
INSERT INTO new_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","अले मिं भस्‍म मयाइगु फुक्‍क ज्‍वलंयात मिइ तयाः शुद्ध यायेमाः। उकियात शुद्ध यायेगु लखं नं शुद्ध यायेमाः। मिइ भस्‍म जुयाः वनीगु ज्‍वलं व लखं शुद्ध यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","न्‍हय्‌न्‍हु खुन्‍हु छिमिसं थःगु वसः हीमाः। अले छिपिं शुद्ध जुइ। अनं लिपा छिपिं छाउनीइ वःसां ज्‍यू।” ");
INSERT INTO new_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“छ, एलाजार पुजाहारी व खलःया छेँजःतय् नायःतय्‌सं ज्‍वनाहःपिं मनूत व पशुत ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","अले फुक्‍कयात बच्‍छि बच्‍छि यानाः छब्‍व लडाइँलय् वंपिं सेनातय्‌त ब्‍यु, मेगु ब्‍व खलःयात ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","लडाइँलय् वंपिं सेनापाखें मनूत, सा द्वहं, गधा, फै-च्‍वलय् मध्‍यें न्‍यासःम्‍हय् छम्‍ह परमप्रभुयात करकथं ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","इमिगु बच्‍छि ब्‍व पाखेंयागु थ्‍व कर कयाः परमप्रभुया भागकथं पुजाहारी एलाजारयात ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","इस्राएलीतय्‌गु बच्‍छि ब्‍वपाखें मनूत, सा द्वहं, गधा, फै-च्‍वलय् व फुक्‍क पशुया नेय्‌म्‍हय् छम्‍ह कयाः परमप्रभुया नापलायेगु पाल स्‍वइपिं लेवीतय्‌त ब्‍यु।” ");
INSERT INTO new_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","परमप्रभुं मोशायात बियादीगु उजं थें मोशा व एलाजार पुजाहारीं यात। ");
INSERT INTO new_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","सेनातय्‌सं लाकाकाःगु बाहेक मेगु सम्‍पत्ति थ्‍व खः – फै-च्‍वलय् ६,७५,००० म्‍ह, ");
INSERT INTO new_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","सा द्वहं ७२,००० म्‍ह, ");
INSERT INTO new_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","गधा ६१,००० म्‍ह, ");
INSERT INTO new_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","मिजंनापं मद्यंपिं मिसात ३२,००० म्‍ह। ");
INSERT INTO new_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","लडाइँलय् वंपिं सेनातय्‌त लाःवःगु बच्‍छि ब्‍व थथे दु – फै-च्‍वलय् ३,३७,५०० म्‍ह, ");
INSERT INTO new_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","थुकिं परमप्रभुया निंतिं कर फै-च्‍वलय् ६७५ म्‍ह जुल। ");
INSERT INTO new_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","अले सा द्वहं ३६,००० म्‍ह। थुकिं ७२ म्‍ह परमप्रभुया निंतिं कर जुल। ");
INSERT INTO new_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","अले गधा ३०,५०० म्‍ह। थुकिं ६१ म्‍ह परमप्रभुया निंतिं कर जुल। ");
INSERT INTO new_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","मिजंत नापं मद्यंपिं मिसात १६,००० म्‍ह। थुकिं परमप्रभुया निंतिं कर ३२ म्‍ह जुल। ");
INSERT INTO new_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","परमप्रभुं मोशायात उजं बियादी थें परमप्रभुया देछाया कर मोशां एलाजार पुजाहारीयात बिल। ");
INSERT INTO new_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","लडाइँलय् वंपिं सेनातय्‌के बच्‍छि ब्‍व कयाः मोशां इस्राएलया खलःयात ब्‍यूगु थथे दु – ");
INSERT INTO new_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","फै-च्‍वलय् ३,३७,५०० म्‍ह, ");
INSERT INTO new_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","सा द्वहं ३६,००० म्‍ह, ");
INSERT INTO new_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","गधा ३०,५०० म्‍ह, ");
INSERT INTO new_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","व मिजंपिं नापं मद्यंपिं मिसात १६,००० म्‍ह। ");
INSERT INTO new_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","इस्राएलीतय्‌गु बच्‍छि ब्‍वपाखें परमप्रभुं मोशायात बियादीगु उजंकथं वं मनूत व पशुतपाखें नेय्‌म्‍हय् छम्‍ह हयाः परमप्रभुया नापलायेगु पाल जिम्‍मा काइपिं लेवीतय्‌त बिल। ");
INSERT INTO new_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","अले द्वःछि द्वःछिम्‍ह व सछि सछिम्‍ह सिपाइँतय्‌ कप्‍तानत मोशायाथाय् वयाः ");
INSERT INTO new_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","वयात धाल, “छि दासतय्‌सं जिमिगु जिम्‍माय् दुपिं सेनातय्‌त ल्‍याः खाःगु दु। जिमि मनूत छम्‍ह नं तंगु मदु। ");
INSERT INTO new_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","अथे जुयाः जिमिसं थथःपिन्‍सं हयागु लुँया तिसा, ल्‍हाः बाला, अंगूचा, मार्वरि व सिखः परमप्रभुयात छायाः जिमिगु प्रायश्‍चित यायेत परमप्रभुयात देछाकथं हयागु दु।” ");
INSERT INTO new_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","मोशा व पुजाहारी एलाजारं इमिगु ल्‍हातं फुक्‍क तिसा काल। ");
INSERT INTO new_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","द्वःछि द्वःछिम्‍ह सिपाइँतय्‌ कप्‍तानत व सछि सछिम्‍ह सिपाइँतय्‌ कप्‍तानतय्‌के कयाः इमिसं परमप्रभुयात देछाःगु लुँयागु तौल १६,७५० शेकेल दु। ");
INSERT INTO new_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","लडाइँलय् वंपिं सकल मनूतय्‌सं लाकाहःगु सामान थथःपिन्‍सं हे यंकूगु जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","मोशा व पुजाहारी एलाजारं द्वःछिम्‍ह व सछिम्‍ह सिपाइँतय्‌ कप्‍तानतपाखें लुँ कयाः परमप्रभुया न्‍ह्यःने इस्राएलीतय्‌गु निंतिं लुमन्‍ति जुइत नापलायेगु पाल दुने हल। ");
INSERT INTO new_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","रूबेन व गाद कुलयापिन्‍के यक्‍व हे पशुत दु। इमिसं याजेर व गिलाद देश खंबलय् व थाय् पशु लहित ज्‍यूगु खन। ");
INSERT INTO new_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","इमिसं मोशा, पुजाहारी एलाजार व खलःया नायःतय्‌थाय् वनाः धाल, ");
INSERT INTO new_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“अतारोत, दीबोन, याजेर, निम्रा, हेश्‍बोन, एलाले, सबाम, नेबो व बओन, ");
INSERT INTO new_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","थ्‍व फुक्‍क लागायात परमप्रभुं इस्राएलया खलःया निंतिं त्‍याकादीगु खः। थ्‍व पशुतय्‌गु निंतिं ल्‍वःगु थाय् खः। छिकपिनि दासतय्‌के यक्‍व पशुत दु। ");
INSERT INTO new_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","छिं जिपिं खनाः लय्‌ताः धइगु खःसा थ्‍व जमिन छिकपिनि दासतय्‌त जिमिगु सम्‍पत्ति जुइत बियादिसँ। जिमित यर्दन खुसिया उखे यंकादी मते।” ");
INSERT INTO new_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","मोशां गादी व रूबेनीतय्‌त धाल, “छिमि इस्राएली दाजुकिजापिं उखे लडाइँलय् वनेगु, अले छिपिं जक थन याउँक च्‍वनेगु धयागु ला? ");
INSERT INTO new_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","छिमिसं मेपिं इस्राएलीतय्‌त परमप्रभुं बियादीगु उखे पाखेयागु देशय् वनेत लिचिकेत स्‍वयागु ला? ");
INSERT INTO new_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","जिं छिमि बौपिन्‍त कादेश-बर्नेनं व थाय् स्‍वके छ्वयाबलय् छिमि बौपिन्‍सं नं थथे हे याःगु खः। ");
INSERT INTO new_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","इमिसं एश्‍कोल धाःगु गालय् वनाः व थाय्‌यात स्‍वयाः परमप्रभुं बियादीगु व थासय् वनेत इस्राएलीतय्‌त लिचिकाब्‍यूगु खः। ");
INSERT INTO new_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","अले परमप्रभुं तंचायाः उखुन्‍हु हे थथे धया पाफयाः बचं बियादीगु खः, ");
INSERT INTO new_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘इपिं दुनुगलंनिसें जिगु ल्‍यूल्‍यू मजूगुलिं अब्राहाम, इसहाक व याकूबयात बी धकाः बचं बियागु देशय् मिश्रं पित हयापिं निइदँ व निइदं च्‍वय्‌यापिं सुं नं दुहां वने खनी मखु। ");
INSERT INTO new_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","कनज्‍जी यपुन्‍नेया काय् कालेब व नूनया काय् यहोशू जक दुहां वने खनी। छाय्‌धाःसा इपिं दुनुगलंनिसें परमप्रभुया ल्‍यूल्‍यू जुल।’ ");
INSERT INTO new_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","परमप्रभुं तंचायादिल, अले परमप्रभुया मिखाय् मभिंगु ज्‍या याःगु पुस्‍ताया फुक्‍क मनूत सिनामवंतले पिइदँ तक वय्‌कलं इमित मरुभूमिइ उखेंथुखें जुइकातल। ");
INSERT INTO new_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“हे पापीतय् सन्‍तान! आः हाकनं छिपिं परमप्रभुयात इस्राएलीतलिसे अझ यक्‍व तं चाय्‌केत छिमि बौपिनि थासय् दंवयाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","छिपिं हाकनं वय्‌कःया ल्‍यूल्‍यू जुइगुपाखें फःहिला वन धाःसा वय्‌कलं थुपिं फुक्‍क मनूतय्‌त हाकनं मरुभूमिइ त्‍वःतादी। अले इमिगु नाशया कारण छिपिं जुइ।” ");
INSERT INTO new_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","अले इमिसं वयाथाय् वया धाल, “जिमित थन जिमि पशुतय्‌गु लागि गः व मिसात व मस्‍तय्‌गु लागि पःखाः दुगु शहरत दय्‌के मास्‍ति वः। ");
INSERT INTO new_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","अले जिपिं इस्राएलीतय्‌त इमिगु थासय् मथ्‍यंकुतले ल्‍वाभः ज्‍वनाः इमिगु न्‍ह्यः न्‍ह्यः लडाइँलय् वने। उबलय् जिमि मिस्‍त व मचाखाचा थ्‍व देशयापिं मनूतपाखें बचय् जुइत जिमिसं दय्‌कागु शहरय् पःखाः दुने च्‍वनाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","फुक्‍क इस्राएलीतय्‌सं इमित बी धयातःगु सर्बय मकातले जिपिं छेँय् लिहां वये मखु। ");
INSERT INTO new_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","जिमिसं यर्दनया उखे छुं नं सर्बय नं काये मखु। बरु जिपिं थन हे पुर्बपाखे थःगु सर्बय‌कथं वःगु थासय् हे च्‍वने।” ");
INSERT INTO new_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","अले मोशां इमित धाल, “छिमिसं थःपिन्‍सं धाःथें ल्‍वाभः ज्‍वनाः परमप्रभुया न्‍ह्यःने लडाइँलय् वन, ");
INSERT INTO new_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","अले परमप्रभुं थः शत्रुतय्‌त बुकाः लिना मछ्वतले परमप्रभुया न्‍ह्यःने ल्‍वाभः ज्‍वनाः यर्दन छिनावन धाःसा ");
INSERT INTO new_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","परमप्रभुया न्‍ह्यःने व देशयात त्‍याकेधुंकाः छिपिं लिहां वये फइ। अले परमप्रभु व इस्राएलीतय्‌गु लागि छिमिसं यायेमाःगु ज्‍या पूवनी। अले यर्दनया पुर्बपाखे च्‍वंगु थाय् परमप्रभुयापाखें छिमिगु सम्‍पत्ति जुइ। ");
INSERT INTO new_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“छिमिसं थःपिन्‍सं धाःथें मयात धाःसा छिमिसं परमप्रभुया न्‍ह्यःने पाप याःगु जुइ। अले छिमिगु पाप छिमित लाइ। ");
INSERT INTO new_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","छिमिसं थः मिस्‍त व मचाखाचाया लागि शहर व पशुतय्‌गु लागि गः दय्‌के फु, तर थःपिनिगु बचं पूवंकेमाः।” ");
INSERT INTO new_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","अले गादी व रूबेनीतय्‌सं मोशायात धाल, “प्रभु, छसपोलं उजं बियादी थें हे छःपिनि दासतय्‌सं याये। ");
INSERT INTO new_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","जिमि मचाखाचा, मिस्‍त, सा द्वहं, फै, दुगु-च्‍वलय् धाःसा थन गिलादया शहरय् हे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","अय्‌नं छिसं धयादी थें जिपिं लडाइँ याइपिं फुक्‍कं मनूत परमप्रभुया न्‍ह्यःने लडाइँ यायेत ल्‍वाभः ज्‍वनाः न्‍ह्यः न्‍ह्यः यर्दनया उखे वने।” ");
INSERT INTO new_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","अले मोशां इमिगु खँय् एलाजार पुजाहारी, नूनया काय् यहोशू व इस्राएलीतय् कुलया नायःतय्‌त उजं बिल। ");
INSERT INTO new_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","वं इमित धाल, “गादी व रूबेनीत छिपिंनापं परमप्रभुया न्‍ह्यःने लडाइँलय् ल्‍वाभः ज्‍वनाः यर्दनया उखे वंसा अले देश छिमिगु ल्‍हातय् दये धुंकाः छिमिसं गिलाद देश इमित सम्‍पत्तिकथं ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","इपिं ल्‍वाभः ज्‍वनाः छिपिंनापं यर्दन छिनाः मवन धाःसा इमित छिपिंनापं कनान देशय् हे जमिन दइ।” ");
INSERT INTO new_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","अले गादी व रूबेनीतय्‌सं थथे धाल, “परमप्रभुं जिमित छु धयादीगु दु जिमिसं व हे याये। ");
INSERT INTO new_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","जिपिं ल्‍वाभः ज्‍वनाः परमप्रभुया न्‍ह्यःने खुसिया उखेपाखे कनान देशय् वने, अय्‌नं जिमिगु थःगु सर्बय यर्दनया थुखे हे जुइमा।” ");
INSERT INTO new_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","अले मोशां गादीत, रूबेनीतय्‌त व योसेफया काय् मनश्‍शेया बच्‍छि कुलयात एमोरीतय् जुजु सीहोनयागु देश व बाशानया जुजु ओगयागु देश इमिगु सिमाना दुने लाःगु शहर नापं फुक्‍क देश बिल। ");
INSERT INTO new_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","अले गादीतय्‌सं दीबोन, अतारोत, अरोएर, ");
INSERT INTO new_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","अत्रोत-शोपान, याजेर, योगबहा, ");
INSERT INTO new_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","बेथ-निम्रा व बेथ-हारान नांयागु शहरतय्‌त पःखालं घेरय् यानाः दय्‌कल। अले फै, दुगु-च्‍वलय्‌तय्‌गु निंतिं गःत दय्‌कल। ");
INSERT INTO new_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","38","रूबेनीतय्‌सं हेश्‍बोन, एलाले व किर्यातैम, नेबो, बाल-मोन व सिब्‍मा हाकनं दय्‌कल। इमिसं थःपिन्‍सं दय्‌कूगु शहरतय्‌गु नां तल। ");
INSERT INTO new_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","मनश्‍शेया काय् माकीरया सन्‍तानतय्‌सं गिलादय् वनाः उकियात त्‍याकाः अन च्‍वंपिं एमोरीतय्‌त पितिनाछ्वत। ");
INSERT INTO new_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","अथे जुयाः मोशां मनश्‍शेया काय् माकीरया सन्‍तानतय्‌त गिलाद बिल अले इपिं अन हे च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","मनश्‍शेया सन्‍तान याईर वनाः गिलादया यक्‍व गां त्‍याका काल, अले उकिया नां हब्‍बात-याईर तल। ");
INSERT INTO new_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","नोबहं केनात व उकिया गां त्‍याकाः उकिया नां थःगु हे नामय् नोबह धकाः तयाबिल। ");
INSERT INTO new_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","मोशा व हारूनया न्‍ह्यलुवालय् मिश्रं इस्राएलीत पुचः पुचः जुयाः यात्रा याःबलय् इपिं थ्‍व थ्‍व थासय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","मोशां परमप्रभुया उजंकथं यात्राबलय् बाय् च्‍वंगु थाय्‌या धलः दय्‌कल। ");
INSERT INTO new_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","न्‍हापांगु लाया झिंन्‍यान्‍हु खुन्‍हु इपिं रामसेसं न्‍ह्याः वन। छुत्‍काराया नखःया कन्‍हय् खुन्‍हु इपिं फुक्‍क मिश्रीतय्‌सं खंक हे धूमधामं पिहां वन। ");
INSERT INTO new_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","उखुन्‍हु मिश्रीत परमप्रभुं स्‍यानादीपिं इमि न्‍हापां बूपिं काय्‌पिन्‍त ल्‍हाकाच्‍वंगु जुल। थथे यानाः परमप्रभुं इमि द्यःतय्‌त सजाँय बियादीगु खः। ");
INSERT INTO new_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","इस्राएलीत रामसेसं वनाः सुक्‍कोतय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","इपिं सुक्‍कोतं वनाः मरुभूमिया सिथय् एथामय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","एथामं वनाः इपिं बाल-सेफोनया चुलिंचू लाःगु पी-हहीरोतपाखे लिहां वल। अले मिग्‍दोलया न्‍ह्यःने पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","इपिं पी-हहीरोतं वनाः लाल समुद्र छिनाः मरुभूमिइ दुहां वन। इपिं एथामया मरुभूमिइ स्‍वन्‍हु तक वनाः माराय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","अले मारां वनाः एलीमय् थ्‍यंकः वल। अन झिंनिगू बुँगाःचा व न्‍हयेमा ताय्‌गः सिमा दु। इपिं अन हेबाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","इपिं एलीमं वनाः लाल समुद्र लिक्‍क बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","इपिं लाल समुद्रं वनाः सीनया मरुभूमिइ बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","इपिं सीनया मरुभूमिं वनाः दोफकाय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","इपिं दोफकां वनाः आलूशय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","इपिं आलूशं वनाः रपीदीमय् बाय् च्‍वन, अन मनूतय्‌त त्‍वनेत लः मदु। ");
INSERT INTO new_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","इपिं रपीदीमं वनाः सीनैया मरुभूमिइ बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","इपिं सीनैया मरुभूमिं वनाः किब्रोथ-हत्तावाय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","इपिं किब्रोथ-हत्तावां वनाः हसेरोतय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","इपिं हसेरोतं वनाः रित्‍माय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","इपिं रित्‍मां वनाः रिम्‍मोन-फारेसय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","इपिं रिम्‍मोन-फारेसं वनाः लिब्‍नाय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","लिब्‍नां वनाः रिस्‍साय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","इपिं रिस्‍सां वनाः केहेलाताय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","इपिं केहेलातां वनाः शेपेर पर्वतय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","इपिं शेपेर पर्वतं वनाः हरादाय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","इपिं हरादां वनाः मखेलोतय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","मखेलोतं वनाः तहतय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","इपिं तहतं वनाः तेरहय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","इपिं तेरहं वनाः मित्‍काय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","इपिं मित्‍कां वनाः हशमोनाय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","इपिं हशमोनां वनाः मसेरोतय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","इपिं मसेरोतं वनाः बने-याकानय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","इपिं बने-याकानं वनाः होर-हगिदगादय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","इपिं होर-हगिदगादं वनाः योतबाताय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","इपिं योतबातां वनाः अब्रोनाय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","इपिं अब्रोनां वनाः एस्‍योन-गेबेरय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","इपिं एस्‍योन-गेबेरं वनाः जीनयागु मरुभूमिइ दुगु कादेशय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","इपिं कादेशं वनाः एदोम देशया लागाय् दुगु होर पर्वतय् पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","इस्राएलीत मिश्रं पिहां वःगु पिइदँया न्‍यागूगु लाया न्‍हापां खुन्‍हु परमप्रभुया उजंकथं हारून पुजाहारी होर पर्वतय् थहां वनाः अन हे सित। ");
INSERT INTO new_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","हारून होर पर्वतय् स्‍यूबलय् व सछि व निइस्‍वदँ दुम्‍ह जुयाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","कनान देशया नेगेवय् च्‍वनीम्‍ह आरादया कनानी जुजुं इस्राएलीत वयाच्‍वंगु दु धयागु खँ न्‍यन। ");
INSERT INTO new_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","इपिं होर पर्वतं वनाः सलमोनाय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","इपिं सलमोनां वनाः पूनोनय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","इपिं पूनोनं वनाः ओबोतय् पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","इपिं ओबोतं वनाः मोआबया सिमानाय् दुगु इये-अबारीमय् पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","इपिं इयीमं वनाः दीबोन-गादय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","इपिं दीबोन-गादं वनाः आल्‍मोन-दिब्‍लातैमय् बाय् च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","इपिं अल्‍मोन-दिब्‍लातैमं वनाः नेबो पर्वतया लिक्‍क अबारीमया डाँडाय् पालग्‍वया च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","इपिं अबारीमं वनाः यरीहो शहरया उखे यर्दन खुसिया सिथय् च्‍वंगु मोआबया ख्‍यलय् पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","यर्दन खुसिया सिथय् मोआबया ख्‍यलय् बेथ-यशीमोतंनिसें कयाः हाबिल-शित्तिम तक हे इपिं पाल ग्‍वयाः च्‍वन। ");
INSERT INTO new_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","अले यरीहो शहरया उखे यर्दन खुसि सिथय् मोआबया ख्‍यलय् परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“इस्राएलीतय्‌त धा, ‘छिपिं यर्दन खुसि छिनाः कनान देशय् थ्‍यनीबलय् ");
INSERT INTO new_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","व देशयापिं मनूतय्‌त इमिगु देशं पितिनाछ्व। अले इमिगु कियातःगु झ्‍वाता व नाय्‌कातःगु मूर्ति फुक्‍कयात नाश यानाब्‍यु। इमिसं पुजा याइगु देगःचात नं स्‍यंकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","व देशयात त्‍याकाकयाः छिपिं अन हे च्‍वँ, छाय्‌धाःसा जिं व देश छिमित अधिकार यायेत बियागु दु। ");
INSERT INTO new_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","छिमिसं थथःगु सर्बयकथं व देशय् गोला तयाः जमिन इनाब्‍यु। अप्‍वः छेँजः दुगु कुलयात अप्‍वः अले कम छेँजः दुगु कुलयात छिमिसं कम सर्बय ब्‍यु। सुयागु गोला गन लाइ व वयागु हे जुइ। छिमिगु पुर्खाया कुलकथं थ्‍व इनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“‘अय्‌नं छिमिसं व देशयापिं मनूतय्‌त लिनामछ्वसे, छिमिसं अन च्‍वने ब्‍यूपिं मनूत छिमिगु मिखाय् च्‍वंगु कं व म्‍हय् कँथं कयेगु थें जुइ। छिपिं व देशय् न्‍ह्याथाय् च्‍वंसां इमिसं छिमित दुःख बी। ");
INSERT INTO new_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","अले जिं इमित छु याये धकाः मनय् तयागु खः व हे जिं छिमित यानाबी।’” ");
INSERT INTO new_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“इस्राएलीतय्‌त धा, ‘छिपिं कनान देश थ्‍यने धुंकाः जिं छिमित सर्बयकथं बी धयागु जमिन थुकथं जुइ। ");
INSERT INTO new_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“‘छिमिगु दच्‍छिन लागाय् एदोमया सिमानाय् जीनया मरुभूमिया छुं ब्‍व लाइ। छिमिगु दच्‍छिनयागु सिमाना पुर्बपाखे मृत सागर सिथंनिसें न्‍ह्यानाः ");
INSERT INTO new_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","अक्रब्‍बीमया भज्‍याङ्‌ग जुयाः जीनपाखे न्‍ह्यज्‍याःनाः कादेश-बर्नेया दच्‍छिन तक वनी। अनंलि व हसर-अद्दर जुयाः अज्‍मोन तक थ्‍यनी। ");
INSERT INTO new_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","अनं सिमाना अज्‍मोनं चाःहिलाः मिश्रया ब्‍यासि थ्‍यंकाः भूमध्‍यसागरय् क्‍वचाइ। ");
INSERT INTO new_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“‘छिमिगु पच्‍छिमया लागा भूमध्‍यसागरया सिथ तक जुइ। छिमिगु पच्‍छिमया सिमाना थ्‍व हे जुइ। ");
INSERT INTO new_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“‘छिमिगु उत्तरया लागा भूमध्‍यसागरंनिसें न्‍ह्यानाः होर पर्वत तक थ्‍यनी। ");
INSERT INTO new_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","अनं लेबो-हमात जुयाः सदाद तक थ्‍यनी। ");
INSERT INTO new_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","सदादं पुर्बपाखे न्‍ह्याः वनाः सिप्रोन जुयाः हसर-एनानय् वनाः क्‍वचाइ। छिमिगु उत्तरया सिमाना थ्‍व हे जुइ। ");
INSERT INTO new_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“‘छिमिगु पुर्बया लागा हसर-एनानंनिसें न्‍ह्याः वनाः सपाम तक थ्‍यनी। ");
INSERT INTO new_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","अनं क्‍वहां वनाः ऐनया पुर्बय् लाःगु रिब्‍ला तक थ्‍यनी। अनं गालीलया समुद्रया पुर्बया सिथय् च्‍वंगु डाँडाय् क्‍वहां वनी। ");
INSERT INTO new_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","अनंलि छिमिगु लागा यर्दन खुसिपाखे क्‍वहां वनाः मृत सागर तक थ्‍यनी। “‘थ्‍व हे छिमिगु देशया लागा जुइ।’” ");
INSERT INTO new_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","मोशां इस्राएलीतय्‌त उजं बिल, “थ्‍व देशयात सर्बय सर्बयकथं गोला तयाः इनाका। परमप्रभुं थुकियात गुंगू व बागू कुलयात ब्‍यु धकाः उजं बियादीगु दु। ");
INSERT INTO new_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","रूबेनया कुल, गादया कुल, व मनश्‍शेया बागू कुलया छेँजःतय्‌त इमिगु सर्बय दये धुंकल। ");
INSERT INTO new_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","थुपिं निगू व बागू कुलं यरीहोया मेखेपाखे यर्दन खुसिया पुर्बपाखे थथःगु सर्बय काये धुंकूगु दु।” ");
INSERT INTO new_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“छिमित सर्बयकथं जमिन इनाबीपिं मनूतय्‌गु नां थथे दु, पुजाहारी एलाजार व नूनया काय् यहोशू। ");
INSERT INTO new_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","थथे इनेत इमित ग्‍वाहालि बीत छगू छगू कुलं छम्‍ह छम्‍ह नायः नं ल्‍य। ");
INSERT INTO new_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","इमिगु नां थथे दु – “कुल – नायः यहूदा – यपुन्‍नेया काय् कालेब ");
INSERT INTO new_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","शिमियोन – मीहूदया काय् शेमुएल ");
INSERT INTO new_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","बेन्‍यामीन – किसलोनया काय् एलीदाद ");
INSERT INTO new_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","दान – योगलीया काय् बुक्‍की ");
INSERT INTO new_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","मनश्‍शे (योसेफया काय्) – एपोदया काय् हन्‍नीएल ");
INSERT INTO new_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","एफ्राइम (योसेफया काय्) – शिप्‍तानया काय् कमूएल ");
INSERT INTO new_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","जबूलून – पर्नाकया काय् एलीजापान ");
INSERT INTO new_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","इस्‍साखार – अजानया काय् पल्‍तिएल ");
INSERT INTO new_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","आशेर – शलोमीया काय् अहीहूद ");
INSERT INTO new_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","नप्‍ताली – अम्‍मीहूदया काय् पदहेल।” ");
INSERT INTO new_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","इस्राएलीतय्‌त कनान देश सर्बयकथं इनाबीत परमप्रभुं ल्‍ययादीपिं मनूत थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","परमप्रभुं यरीहो शहरया उखे यर्दन खुसिया सिथय् मोआबया ख्‍यलय् मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“इस्राएलीतय्‌त इमित ब्‍यूगु सर्बयलय् च्‍वंगु छुं छुं शहर लेवीतय्‌त च्‍वनेत ब्‍यु धकाः उजं ब्‍यु, अले उपिं शहरया जःखः च्‍वंगु घाँय्‌ख्‍यः नं लेवीतय्‌त ब्‍यु धकाः उजं ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","थुकथं इमित च्‍वनेत थाय् दइ। अले इमि सा द्वहं, फै-च्‍वलय् व मेपिं पशुत ज्‍वयेत ख्‍यः दइ। ");
INSERT INTO new_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“छिमिसं लेवीतय्‌त बीगु ख्‍यः शहरया पःखाःया पिने प्‍यखें द्वःछि द्वःछि कु (१,०००) दयेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","शहरया पिने शहरयात दथुइ तयाः पुर्बपाखे निद्वः कु (२,०००), दच्‍छिनपाखे निद्वः कु (२,०००), पच्‍छिमपाखे निद्वः कु (२,०००) अले उत्तरपाखे निद्वः कु (२,०००) नापय् या। इमिगु शहरया घाँय्‌ख्‍यः थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“छिमिसं लेवीतय्‌त बीगु शहरय् शरण बीगु खुगू शहर नं दइ। थ्‍व शहरय् छिमिसं आकाझाकांय् लानाः मनू स्‍यानाः बिस्‍युं वःपिन्‍त च्‍वनेत थाय् बी फइ। व बाहेकं छिमिसं इमित मेगु पिइनिगू शहर नं बीमाः। ");
INSERT INTO new_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","थुकथं ख्‍यः नापं मुक्‍कं पिइच्‍यागू शहर छिमिसं लेवीतय्‌त बीमाः। ");
INSERT INTO new_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","थुपिं शहरत इस्राएलीतय्‌गु सम्‍पत्तिपाखें वइ। तःधंगु कुलं यक्‍व अले चिधंगु कुलं कम शहर लेवीतय्‌त बी। फुक्‍क कुलं थथःगु सर्बयया आकारकथं लेवीतय्‌त शहर बीमाः।” ");
INSERT INTO new_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","परमप्रभुं मोशायात धयादिल, ");
INSERT INTO new_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“इस्राएलीतय्‌त धा, ‘छिपिं यर्दन खुसि छिनाः कनान देशय् थ्‍यने धुंकाः ");
INSERT INTO new_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","आकाझाकांय् लानाः मनू स्‍यानाः बिस्‍युं वःपिन्‍त तयेत शरण बीगु शहर ल्‍य। ");
INSERT INTO new_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","सीम्‍ह मनूया थःथितितय्‌सं वयात अन हिया बदला काये फइ मखु। थुकथं खलःया न्‍ह्यःने न्‍यायया ज्‍या पूमवंकं दोष लाःम्‍ह मनूयात स्‍याये फइ मखु। ");
INSERT INTO new_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","छिमिस बीगु शरण बीगु शहर खुगू दयेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","यर्दनया पुर्बपाखे स्‍वँगू शहर, कनान देशय् स्‍वँगू शहर शरण बीगु शहरकथं ब्‍यु। ");
INSERT INTO new_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","थुपिं खुगू शहर छिपिं इस्राएलीतय्‌गु लागि व छिपिंनापं च्‍वनाच्‍वंपिं मेगु जातियापिनिगु लागि शरण कायेगु थाय् जुइ। उकिं सुनानं आकाझाकांय् लानाः मनू स्‍यात धाःसा व मनू अन बिस्‍युं वने फइ। ");
INSERT INTO new_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“‘सुनानं सुयातं नँयागु ल्‍वाभलं कय्‌काः स्‍यात धाःसा व मनू ज्‍यानमारा खः। वयात स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","सुनानं सुयातं ल्‍वहँतं छ्यानाः स्‍यात धाःसा व मनू ज्‍यानमारा खः। वयात स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","सुनानं सुयातं सिँयागु ल्‍वाभलं कय्‌काः स्‍यात धाःसा व मनू ज्‍यानमारा खः। वयात स्‍यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","हिया बदला काइम्‍हसिनं वयात स्‍याये फइ। इमिसं वयात लुइकेवं स्‍याये फइ। ");
INSERT INTO new_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","अथे हे, सुनानं सुयातं तमय् घ्‍वानाः, छुकिंनं कय्‌का स्‍यात धाःसा ");
INSERT INTO new_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","वा ल्‍हातिं दायाः स्‍यात धाःसा वयात स्‍यायेमाः। व मनू ज्‍यानमारा खः। मनू स्‍याःगुया बदला काइम्‍हय्‌सिनं वयात स्‍याये फइ। इमिसं वयात लुइकेवं स्‍याये फइ। ");
INSERT INTO new_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“‘तर सुनानं सुयातं मसीसें घ्‍वानाः सित वा छुकिंनं कय्‌कूबलय् लानाः सित, ");
INSERT INTO new_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","वा आकाझाकां तःग्‍वःगु ल्‍वहं कुतुंवंबलय् लानाः सित धाःसा ");
INSERT INTO new_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","खलकं न्‍याय यायेबलय् स्‍याःम्‍ह मनू व हिया बदला काःवःम्‍हय्‌सिगु दथुइ थुपिं विधिकथं न्‍याय यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","अले खलकं द्वं मदुसा वयात हिया बदला काःवःम्‍हय्‌सिगु पाखें बचय् यानाः व बिस्‍युं वंगु शरण बीगु शहरय् हे छ्वयेमाः। अन व पवित्र चिकनं अभिषेक जूम्‍ह दकलय् तःधंम्‍ह पुजाहारी मसीतले च्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“‘छुं जुयाः व ज्‍यानमारा थः बिस्‍युं वंगु शरण बीगु शहरं गुगुं इलय् पिहां वनाः ");
INSERT INTO new_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","वयात हिया बदला कायेत स्‍वयाच्‍वंम्‍हय्‌सिनं नाप लानाः स्‍यात धाःसा वयात हिया दोष लाइ मखु। ");
INSERT INTO new_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","दकलय् तःधंम्‍ह पुजाहारी मसीतले व शरण बीगु शहरय् हे च्‍वनेमाः। दकलय् तःधंम्‍ह पुजाहारी सी धुंकाः जक व थःगु सम्‍पत्तिया जमिनय् लिहां वने फइ। ");
INSERT INTO new_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“‘छिपिं न्‍ह्याथाय् च्‍वंसां छिपिं व छिमि लिपाया फुक्‍क पुस्‍ताय् थ्‍व विधि दया हे च्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“‘सुनानं सुयातं स्‍यात धाःसा वयात साक्षीतय्‌सं ब्‍यूगु दसिकथं जक स्‍यायेमाः। छम्‍ह जक मनूया साक्षीं सुयातं स्‍यायेगु सजाँय बी मज्‍यू। ");
INSERT INTO new_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“‘स्‍यायेमाःम्‍ह ज्‍यानमाराया जीवनया निंतिं पलेसाकथं धिबा बं काये मते। वयात स्‍याना हे छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“‘शरण बीगु शहरय् बिस्‍युं वःम्‍ह मनुखं अन च्‍वनेगु पलेसा धिबा पुलाः थःगु छेँय् वनेत धाल धाःसा वयापाखें अज्‍याःगु बं काये मज्‍यू। दकलय् तःधंम्‍ह पुजाहारी मसीतले व अन हे च्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“‘छिमिसं थः च्‍वनेगु थाय् अशुद्ध याये मते। हिं देशयात अशुद्ध याइ। हिया प्रायश्‍चित यायेत हि बाः वय्‌कूम्‍ह मनूयागु हि हे माः। ");
INSERT INTO new_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","छिपिं च्‍वंवनेत्‍यंगु देशय् जि थः हे नं च्‍वनेगु जूगुलिं व देशयात अशुद्ध याये मते। जि परमप्रभु इस्राएलीतय् दथुइ च्‍वनीम्‍ह खः।’” ");
INSERT INTO new_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","योसेफया छुइ, मनश्‍शेया छय्, माकीरया काय् गिलादया वंशया थकालित मोशा व इस्राएली नायःतय्‌थाय् वयाः धाल, ");
INSERT INTO new_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“परमप्रभुं इस्राएलीतय्‌त सर्बय‌कथं गोला तयाः देश इनाबीत छितः उजं बियादीगु खः। अले जिमि किजा सलोफादया सर्बय वया म्‍ह्याय्‌पिन्‍त ब्‍यु धकाः नं परमप्रभुं छितः उजं बियादीगु खः। ");
INSERT INTO new_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","इमिसं मेगु कुलयापिं मिजंतलिसे ब्‍याहा यात धाःसा इमिगु सर्बय नं मिजंतय्‌गु सर्बय नापं ल्‍वाकज्‍याःवनी। थुकथं जिमिगु कुलया सर्बय कम जुयावनी। ");
INSERT INTO new_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","इस्राएलीतय्‌गु निंतिं लुँदँ वइबलय् इमिगु सर्बय इपिं ब्‍याहा याना वंगु कुलय् हे ल्‍वाकज्‍याःवनी। इमिगु सर्बय झी पुर्खातय्‌गु सर्बयपाखें लाका काइ।” ");
INSERT INTO new_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","अले मोशां थथे धकाः परमप्रभुया उजं इस्राएलीतय्‌त बिल, “योसेफया सन्‍तानया कुलं धाःगु खँ पाय्‌छि जू। ");
INSERT INTO new_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","सलोफादया म्‍ह्याय्‌पिनिगु खँय् परमप्रभुं थथे उजं बियादीगु दु – इमिसं थःपिन्‍त यःपिं थः बौया कुलया वंशया मिजंत नापं जक ब्‍याहा यायेमाः। ");
INSERT INTO new_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","थथे याःसा छगू कुलयागु सर्बय मेगु कुलय् वनी मखु। थुकथं फुक्‍क इस्राएलीत थथःगु पुर्खाया कुलया सर्बयया जमिनय् हे दयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","इस्राएलीतय्‌गु कुलय् सर्बयया अंश काइपिं सुं नं म्‍ह्याय्‌मस्‍त दुसा, वं थःगु हे कुलया वंशया मिजंनाप ब्‍याहा यायेमाः। थुकथं इस्राएलया फुक्‍क कुलयाके थःपिनि पुर्खाया सर्बयया अंश दयाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","छगू कुलया सर्बय मेगु कुलय् मवनेमा। थुकथं इस्राएलया फुक्‍क कुलया सर्बय न्‍हापा गुलि खः उलि हे दयाच्‍वनी।” ");
INSERT INTO new_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","सलोफादया म्‍ह्याय्‌पिन्‍सं परमप्रभुं मोशायात बियादीगु उजंकथं हे यात। ");
INSERT INTO new_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","सलोफादया म्‍ह्याय्‌पिं महला, तिर्सा, होग्‍ला, मिल्‍का व नोअहापिन्‍सं थः कका व तःबाःया काय्‌पिं नापं ब्‍याहा यात। ");
INSERT INTO new_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","इमिसं योसेफया काय् मनश्‍शेया वंशय् हे ब्‍याहा यात। थुकथं इमिगु कुलया सर्बय इमिगु कुलय् हे ल्‍यनाच्‍वन। ");
INSERT INTO new_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","परमप्रभुं यरीहो शहरया उखे यर्दन खुसिया सिथय् मोआबया ख्‍यलय् मोशापाखें इस्राएलीतय्‌त बियादीगु उजं व नियम थुपिं हे खः।");
INSERT INTO new_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","सूपया चुलिंचू च्‍वंगु अराबाय् पारान, तोफेल, लाबान, हसेरोत व दीसाहाबया दथुइ यर्दन खुसिया पुर्बपाखेयागु मरुभूमिइ सकल इस्राएलीतय्‌त मोशां धाःगु खँ थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(सेइर पर्वत वनेगु लँपु जुयाः होरेबं कादेश-बर्ने तक वनेत झिंछन्‍हु बी।) ");
INSERT INTO new_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","इमिसं मिश्र त्‍वःतूगु पिइगूगु दँया झिंछगूगु लाया न्‍हापांगु दिनय् मोशां परमप्रभुं इस्राएलीतय्‌त धा धकाः धयादीगु फुक्‍क आज्ञा इमित धाल। ");
INSERT INTO new_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","वं हेश्‍बोनय् राज्‍य याइम्‍ह एमोरीतय् जुजु सीहोन अले अस्‍तारोत व एद्रईलय् राज्‍य याइम्‍ह बाशानया जुजु ओगयात बूकेधुंकाः थ्‍व जूगु खः। ");
INSERT INTO new_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","यर्दनया पुर्बपाखे मोआब देशय् मोशां थ्‍व नियमयात ध्‍वाथुइकेत थुकथं कनाहल। ");
INSERT INTO new_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","होरेबय् परमप्रभु झी परमेश्‍वरं झीत थथे धयादिल, “छिपिं थ्‍व पर्वतय् च्‍वनाच्‍वंगु तःन्‍हु दये धुंकल। ");
INSERT INTO new_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","अथे जुयाः आः छिपिं थ्‍व थाय् त्‍वःताः थःगु यात्राय् न्‍ह्यज्‍या। एमोरीतय् पर्वतया देश व उकिया जःखः च्‍वंपिं फुक्‍क जातितय्‌थाय्, अराबाय्, पर्वतय्, पच्‍छिमया फेदी, नेगेवय् व समुद्रया सिथय् च्‍वंगु कनानीतय् देशय्, लेबनानय् अले तःधंगु खुसि यूफ्रेटिस तक हे हुँ। ");
INSERT INTO new_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","स्‍व! जिं थ्‍व देश छिमित बियागु दु। अन दुहां वनाः व देशयात अधिकार या। थ्‍व देश परमप्रभुं छिमि पुर्खा अब्राहाम, इसहाक व याकूबलिसें इमित व इमि लिपायापिं पुस्‍तायात बी धकाः पाफयाः धयादीगु खः।” ");
INSERT INTO new_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","उबले जिं छिमित धया, “जि याकःचां छिमिगु भार क्‍वबी मफु। ");
INSERT INTO new_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","परमप्रभु छिमि परमेश्‍वरं छिमिगु ल्‍याः अप्‍वय्‌कादीगु दु। अथे जुयाः थौं छिपिं आकाशया नगु थें अल्‍याख जूगु दु। ");
INSERT INTO new_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","परमप्रभु छिमि पुर्खाया परमेश्‍वरं छिमित द्वःछि दुगं अप्‍वय्‌कादीमा अले वय्‌कलं बाचा यानादीगु थें छिमित सुवाः बियादीमा। ");
INSERT INTO new_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","अय्‌नं गथे यानाः छिमिगु समस्‍यात, कचवं व ल्‍वापुख्‍यापुयात जि याकःचां क्‍वबी फइ? ");
INSERT INTO new_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","छिमिगु कुलपतिकं छिमिसं बुद्धिं जाःपिं, सःस्‍यूपिं व हनेबहःपिं मनूत ल्‍य, अले जिं इमित छिमि नायः यानाबी।” ");
INSERT INTO new_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","छिमिसं जितः लिसः बिल, “छिं याः धकाः धयादीगु खँ बांलाः।” ");
INSERT INTO new_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","अथे जुयाः जिं छिमि कुल कुलयापिं मूमू मनूत ल्‍यया। इपिं सकलें बुद्धिं जाःपिं व हनेबहःपिं मनूत खः। अले इमित छिमि कुलपतिकं द्वःछिम्‍ह, सछिम्‍ह, नेय्‌म्‍ह व झिम्‍हया नायःत ल्‍यया। फुक्‍क कुलया निंतिं कुलनायःत नं ल्‍यया। ");
INSERT INTO new_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","उबलय् छिमि न्‍यायधीसतय्‌त जिं थथे धकाः आज्ञा बिया “छिमिसं थः दाजुकिजापिनिगु दथुइया मुद्दा वा इस्राएलीतय् दाजुकिजापिनिगु व परदेशीतय्‌गु दथुइया ल्‍वापुख्‍यापुया मुद्दा न्‍यनाः पाय्‌छि जुइक न्‍याय या। ");
INSERT INTO new_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ख्‍वाः स्‍वयाः न्‍याय याये मते। छिमिसं तःधंपिं व चिधंपिं निखलःसिगुं खँ उत्‍थें न्‍यँ। सुयागुं पंली मते, सुं मनूत खनाः ग्‍याये मते छाय्‌धाःसा न्‍याय यायेगु परमेश्‍वरयागु ज्‍या खः। छिमिगु लागिं थाकुगु मुद्दा जिथाय् हजि, जिं व न्‍यने।” ");
INSERT INTO new_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","उबलय् छिमिसं यायेमाःगु ज्‍या जिं छिमित फुक्‍क धया। ");
INSERT INTO new_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","अनंलि परमप्रभु परमेश्‍वरं झीत आज्ञा बियादी थें झीपिं होरेबं पिहां वयाः छिमिसं खंगु मिखां न्‍ह्याये मदुगु व ग्‍यानपुस्‍से च्‍वंगु मरुभूमि जुयाः एमोरीतय्‌गु पर्वत देशपाखे वना। अले झीपिं कादेश-बर्ने थ्‍यंकः वना। ");
INSERT INTO new_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","अले जिं छिमित धया, “छिपिं परमप्रभु झी परमेश्‍वरं झीत बीत्‍यनादीगु एमोरीतय् पर्वत देशय् थ्‍यंकः वःगु दु। ");
INSERT INTO new_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","स्‍व! परमप्रभु छिमि परमेश्‍वरं थ्‍व देश छिमित बियादीगु दु। अथे जुयाः वनाः थः पुर्खाया परमप्रभु परमेश्‍वरं धयादी थें उकियात अधिकार या। छिपिं ग्‍याये मते, नुगः क्‍वतुंके मते।” ");
INSERT INTO new_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","उबलय् छिपिं सकलें जिथाय् वयाः धाल, “व देशया चिवा कयाः अन गुगु लँपु जुयाः वनेमा अले झीपिं वनेगु शहरत गथे च्‍वं धकाः खबर हयेत झीसं थःगु न्‍ह्यःने मिजंत छ्वयेनु।” ");
INSERT INTO new_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","थ्‍व खँ जितः यल। अले जिं फुक्‍क कुलं छम्‍ह छम्‍ह यानाः झिंनिम्‍ह मनूत ल्‍यया। ");
INSERT INTO new_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","इपिं पहाडय् थाहां वन, अले एश्‍कोलया ब्‍यासिइ थ्‍यंकः वनाः व देशया चिवा काल। ");
INSERT INTO new_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","इमिसं व देशया छुं फलफूल हल। अले इमिसं झीत “परमप्रभु परमेश्‍वरं बीत्‍यंगु देश छगू भिंगु देश खः” धकाः खबर बिल। ");
INSERT INTO new_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","अय्‌नं छिपिं अन वनेत मानय् मजू। छिमिसं परमप्रभु छिमि परमेश्‍वरयागु आज्ञाया विरोध यात। ");
INSERT INTO new_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","छिमिसं थथःगु पालय् कचकच यानाः धाल, “परमप्रभुं झीत तसकं मयय्‌कादीगुलिं झीत एमोरीतय्‌गु ल्‍हातय् बियाः नाश यायेत मिश्रं पित हयादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","झीपिं गन वनेगु? झीसं छ्वयापिं मनूतय्‌सं ‘अनयापिं मनूत झीपिं स्‍वयाः बल्‍ला व तःधिकः, अनयागु शहरत ततःधं अले आकाश थ्‍यंक हे पःखाः ग्‍वयातःगु दु, अले जिमिसं अन अनाकीत नं खना’ धकाः धयाः जिमित ख्‍यात।” ");
INSERT INTO new_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","अले जिं छिमित धया, “नुगः भाराभारा मिंके मते, इपिं खनाः ग्‍याये मते। ");
INSERT INTO new_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","छिमिगु न्‍ह्यःने झायादीम्‍ह, छिमि परमप्रभु परमेश्‍वर थः हे मिश्रय् छिमिगु मिखाया न्‍ह्यःने ल्‍वानादीगु थें हे छिमिगु पंलिनाः ल्‍वानादी। ");
INSERT INTO new_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","परमप्रभु छिमि परमेश्‍वरं छिपिं थन थ्‍यंकः मवतले गथे यानाः छम्‍ह बौनं काय्‌यात क्‍वब्‍यूगु थें लँ धुछि छिमित क्‍वबियाः हयादीगु खः व छिमिसं मरुभूमिइ नं खन।” ");
INSERT INTO new_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","थुलि जूसां नं छिमिसं परमप्रभु छिमि परमेश्‍वरयाके भलसा मतः। ");
INSERT INTO new_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","वय्‌कलं छिमिगु निंतिं बाय् च्‍वनेगु थाय् मालेत व छिपिं वनेमाःगु लँपु क्‍यनेत चान्‍हय् मि व न्‍हिनय् सुपाँचय् जुयाः यात्रा धुछि न्‍ह्यःने न्‍ह्यःने झायादिल। ");
INSERT INTO new_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","छिमिगु कचकच न्‍यनाः परमप्रभु तंचायाः थथे धकाः पाफयादिल, ");
INSERT INTO new_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“थ्‍व मभिंगु पुस्‍ताया छम्‍ह मनुखं नं जिं छिमि पुर्खातय्‌त बी धकाः पाफयाः बचं बियागु भिंगु देशयात स्‍वये खनी मखु। ");
INSERT INTO new_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","यपुन्‍नेया काय् कालेबं जक व देश स्‍वये खनी। दुनुगलंनिसें परमप्रभुया ल्‍यू जूगुलिं वं पला तःगु बँ जिं वयात व वया सन्‍तानयात बी।” ");
INSERT INTO new_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","छिमिसं यानाः परमप्रभु जि खनाः नं तंचायाः थथे धयादिल, “छ नं अन दुहां वने दइ मखु। ");
INSERT INTO new_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","अय्‌नं छन्‍त ग्‍वाहालि याइम्‍ह नूनया काय् यहोशू अन दुहां वनी। छं वयात हःपाः ब्‍यु, छाय्‌धाःसा वं हे इस्राएलया न्‍ह्यलुवाः जुयाः व देशयात इमिगु अधिकारय् हइ। ");
INSERT INTO new_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","छिमिसं ज्‍वना यंकी धकाः धाःपिं भिं व मभिं मस्‍युनिपिं छिमि मचाखाचात धाःसा अन दुहां वनी। जिं व देश इमित बी अले इमिसं हे उकियात अधिकार याइ। ");
INSERT INTO new_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","छिपिं धाःसा चाःहिलाः लाल समुद्रपाखे वनीगु मरुभूमिया लँपुइ हुँ।” ");
INSERT INTO new_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","अले छिमिसं जितः धाल, “जिमिसं परमप्रभुयागु विरोधय् पाप यानागु दु। परमप्रभु झी परमेश्‍वरं आज्ञा बियादीगु थें झीपिं थाहां वनाः ल्‍वाये।” व पर्वतया देशय् थाहां वने अपुइ थें च्‍वनाः छिपिं दक्‍वसिनं थथःगु ल्‍वाभः ज्‍वन। ");
INSERT INTO new_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","अय्‌नं परमप्रभुं जितः धयादिल, “इमित ‘थाहां वने मते अले ल्‍वाःवने मते’ धकाः धा, ‘छाय्‌धाःसा जि छिपिंनापं दइ मखु। छिमित छिमि शत्रुतय्‌सं बुकाबी।’” ");
INSERT INTO new_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","अथे जुयाः थ्‍व खँ जिं छिमित धया, अय्‌नं छिमिसं न्‍यं हे मन्‍यं। छिमिसं परमप्रभुया आज्ञाया विरोध यात अले तःधंछुयाः पर्वत देशय् थाहां वन। ");
INSERT INTO new_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","अले पर्वतय् च्‍वनीपिं एमोरीत छिपिंनापं ल्‍वायेत पिहां वयाः हातय्‌सं थें छिमित ल्‍यू वल, अले इमिसं सेइरनिसें होर्मा तक छिमित बुकल। ");
INSERT INTO new_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","अले छिपिं लिहां वयाः परमप्रभुया न्‍ह्यःने ख्‍वल, अय्‌नं वय्‌कलं छिमिगु ख्‍वःसः न्‍यनामदी, न्‍हाय्‌पं नं बियामदी। ");
INSERT INTO new_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","अथे जुयाः छिपिं कादेशय् यक्‍व दिं तक च्‍वनाच्‍वने माल। ");
INSERT INTO new_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","अले परमप्रभुं जितः धयादीगु थें झीपिं लाल समुद्र वनेगु लँ जुयाः मरुभूमिपाखे वना। यक्‍व दिं तक सेइरया पर्वत देशयागु सिथं सिथं चाःहिलाच्‍वना। ");
INSERT INTO new_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","अले परमप्रभुं जितः धयादिल, ");
INSERT INTO new_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“छिपिं थ्‍व पर्वत देशया सिथं सिथं चाचाःहिलाच्‍वंगु यक्‍व दिं दये धुंकल। आः फहिलाः उत्तरपाखे हुँ। ");
INSERT INTO new_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","अले छं मनूतय्‌त थथे धकाः आज्ञा ब्‍यु, ‘छिपिं सेइरय् च्‍वनिपिं एसावया सन्‍तान, थः हे दाजुकिजापिनिगु देश जुयाः वनेत्‍यंगु दु। इपिं छिपिं खनाः ग्‍याइ। अथे जुयाः बांलाक होश या। ");
INSERT INTO new_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","इमित ल्‍वायेत ग्‍वाके मते, छाय्‌धाःसा जिं छिमित इमिगु देशय् पला तयेगु तक नं थाय् बी मखु। सेइरया पर्वत देश जिं एसावया सन्‍तानया अधिकारय् बियागु दु। ");
INSERT INTO new_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","छिमिसं नयेगु नसा व त्‍वनेगु लः वहः बियाः न्‍यानाका।’” ");
INSERT INTO new_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","परमप्रभु परमेश्‍वरं छिमित ल्‍हातं यायेगु फुक्‍क ज्‍याय् सुवाः बियादीगु दु। वय्‌कलं छिमित थ्‍व तःधंगु मरुभूमिया यात्रा दुच्‍छि बिचाः यानादीगु दु। थुपिं पिइदँया इलय् परमप्रभु परमेश्‍वर छिपिंनापं च्‍वनादीगु दु। अले छिमित छुं नं मगाःमचाः जूगु मदु। ");
INSERT INTO new_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","अथे जुयाः सेइरय् च्‍वनिपिं एसावया सन्‍तान, झी दाजुकिजापिनिपाखें फःहिलाः झीपिं न्‍ह्यज्‍यानावना। एलात व एस्‍योन-गेबेरं वइगु अराबाया लँपु मवंसें झीपिं चाःहिलाः मोआबया मरुभूमिया लँपुइ वना। ");
INSERT INTO new_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","अले परमप्रभुं जितः धयादिल, “मोआबीतय्‌त दुःख बी मते, इमित ल्‍वायेत ग्‍वाके नं मते। जिं इमिगु देशया छुं नं अंश छिमित बी मखु, छाय्‌धाःसा जिं आरया फुक्‍क लागा लोतया सन्‍तानतय्‌गु अधिकारय् बियागु दु।” ");
INSERT INTO new_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(न्‍हापाया इलय् अन बल्‍लाःपिं, ल्‍याखय् अप्‍वः दुपिं अले अनाकीत थें ततःधिकःपिं एमीत च्‍वनाच्‍वंगु खः। ");
INSERT INTO new_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","अनाकीतय्‌त थें इमित नं रपाई हे धाइगु। अय्‌नं मोआबीतय्‌सं इमित एमी धाइगु। ");
INSERT INTO new_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","न्‍हापाया इलय् सेइरय् होरीत च्‍वनाच्‍वंगु खः। अय्‌नं एसावया सन्‍तानतय्‌सं इमित लिनाछ्वल। परमप्रभुं बियादीगु देश इस्राएलीतय्‌सं अधिकार यानाकाःगु थें इमित लिनाछ्वयाः एसावीत इमिगु थासय् च्‍वन।) ");
INSERT INTO new_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","अले परमप्रभुं धयादिल, “आः दनाः जेरेद खुसि छिना हुँ।” अथे जुयाः झीपिं जेरेद खुसियागु खोँच पुलाः उखे वना। ");
INSERT INTO new_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","कादेश-बर्ने त्‍वःता वयाः जेरेद खुसि छिनाबलय् तक झीत स्‍विच्‍यादँ बित। थ्‍व इलय् परमप्रभुं पाफयादीगु थें झीगु छाउनीं व पुस्‍तायापिं सकलें लडाइँ याइपिं मनूत नाश जुल। ");
INSERT INTO new_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","छाउनीं इपिं सकलें नाश जुया मवंतले परमप्रभुया ल्‍हाः इमिगु विरोधय् न्‍ह्यज्‍याना हे च्‍वन। ");
INSERT INTO new_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","मनूतय्‌गु न्‍ह्यःनं लडाइँ यायेफुपिं सकलें मनूत सी धुंकाः ");
INSERT INTO new_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","परमप्रभुं जितः थथे धयादिल, ");
INSERT INTO new_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“थौं छिपिं मोआबया लागा जुयाः आर पुलाः उखे वनेमाः। ");
INSERT INTO new_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","छिपिं अम्‍मोनीतय् सिमानाय् थ्‍यनीबलय् इमित दुःख बी मते। इमित ल्‍वायेत ग्‍वाके मते छाय्‌धाःसा जिं छिमित अम्‍मोनीतय्‌गु देशयागु छुं नं अंश अधिकारया निंतिं बी मखु। जिं व देशयात लोतया सन्‍तानयागु अधिकारय् बियागु दु।” ");
INSERT INTO new_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(न्‍हापा अन रपाईत च्‍वनाच्‍वंगु खः। अथे जुयाः व देशयात नं रपाईतय्‌गु धाइगु। अम्‍मोनीतय्‌सं धाःसा जमजुम्‍मीत धाइगु। ");
INSERT INTO new_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","इपिं बल्‍लाः, ल्‍याखय् अप्‍वः अले अनाकीत थें ततःधिकः। अय्‌नं परमप्रभुं इमित अम्‍मोनीतय्‌गु न्‍ह्यःने नाश यानादिल। अम्‍मोनीतय्‌सं इमित पितिनाछ्वल अले इपिं इमिगु थासय् च्‍वंवल। ");
INSERT INTO new_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","वय्‌कलं सेइरय् च्‍वनिपिं एसावया सन्‍तानतय्‌गु निंतिं नं थथे यानादिल। वय्‌कलं इमिगु न्‍ह्यःने होरीतय्‌त नाश यानादिल। इमित लिनाः थौं तक नं एदोमीत इमिगु थासय् च्‍वनाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","अले गाजा तक गांगामय् च्‍वनाच्‍वंपिं अव्‍वीतय्‌त कप्‍तोरं वःपिं कप्‍तोरीतय्‌सं नाश यानाबिल। अले इपिं इमिगु थासय् च्‍वन।) ");
INSERT INTO new_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“आः न्‍ह्यज्‍या हुँ, अर्नोन खुसिया न्‍हसिकाप पुलाहुँ। जिं हेश्‍बोनया जुजु एमोरी, सीहोन व वयागु देश छिमिगु ल्‍हातय् बियागु दु। अथे जुयाः व देश थःगु अधिकारय् हयेगु शुरु या अले व जुजुलिसें लडाइँ या। ");
INSERT INTO new_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","थनिंनिसें आकाशया क्‍वय् दुपिं सकलें जातितय्‌गु मनय् छिमिगु ग्‍याःचिकु तयाबी। छिमिगु खँ न्‍यनाः इपिं थुरथुर खाइ अले इमिगु नुगः भाराभारा मिनी।” ");
INSERT INTO new_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","कदेमोतया मरुभूमिं हेश्‍बोनया जुजु सीहोनयाथाय् शान्‍तिया थ्‍व खँ धायेत दूत छ्वया, ");
INSERT INTO new_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“जिमित छिगु देश जुयाः वनेबियादिसँ। जिपिं मूलँपु जुयाः जक वने, जिपिं जवंखवं वने मखु। ");
INSERT INTO new_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","जिमित नयेत नसा व त्‍वनेत लः वहः कयाः मियादिसँ। जिमित छिगु देशं जुयाः न्‍यासि वने जक बियादिसँ। ");
INSERT INTO new_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","सेइरय् च्‍वनिपिं एसावया सन्‍तान व आरय् च्‍वनिपिं मोआबीतय्‌सं याःगु थें छिं जिमित यानादिसँ। थुकथं जिपिं यर्दन खुसि छिनाः परमप्रभु जिमि परमेश्‍वरं बियादीगु देशय् थ्‍यंकः वने।” ");
INSERT INTO new_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","अय्‌नं हेश्‍बोनया जुजु सीहोनं झीत थःगु देश जुयाः वने मब्‍यू छाय्‌धाःसा परमप्रभु छिमि परमेश्‍वरं वयात छिमिगु ल्‍हातय् बीत वयागु मनयात जिराहा व अतेरि यानादिल। अले थौं तक व छिमिगु ल्‍हातय् दु। ");
INSERT INTO new_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","परमप्रभुं जितः धयादिल, “सीहोन व वयागु देश जिं छिमित बी। वयागु देशयात त्‍याकाः अधिकार यायेगु शुरु या।” ");
INSERT INTO new_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","सीहोनं थः सकलें सेना ज्‍वनाः जिपिंलिसें ल्‍वायेत यहसाय् वःबलय् ");
INSERT INTO new_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","परमप्रभु झी परमेश्‍वरं वयात झीगु ल्‍हातय् बियादिल। अले वयात, वया काय्‌पिन्‍त, वया सकलें सेनातय्‌त झीसं स्‍यानाबिया। ");
INSERT INTO new_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","उबलय् झीसं वयागु फुक्‍क शहर त्‍याकाकयाः उपिं शहरय् च्‍वंपिं मिजंत, मिसात व मस्‍तय्‌त भज्‍यंक नाश यानाबिया। झीसं छम्‍हय्‌सित नं मत्‍वःता। ");
INSERT INTO new_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","झीसं अधिकार यानागु शहरय् लाका कयागु सामान व पशुत धाःसा थःपिनिगु लागिं कया। ");
INSERT INTO new_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","अर्नोन खुसियागु न्‍हसिकाप च्‍वसं दुगु अरोएरनिसें अले न्‍हसिकापया दथुइ दुगु शहरंनिसें गिलाद तक झीसं त्‍याकाकाये मफुगु बल्‍लाःगु शहर छगू नं मदु। परमप्रभु झी परमेश्‍वरं दक्‍व झीत बियादिल। ");
INSERT INTO new_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","अय्‌नं परमप्रभु झी परमेश्‍वरं वने मते धकाः आज्ञा बियादीगु यब्‍बोक खुसिया सिथय् दुगु अम्‍मोनीतय्‌गु देशया लिक्‍क अले पर्वत देशया शहर शहरय् झीपिं मवना। ");
INSERT INTO new_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","अनंलि झीपिं फहिलाः बाशानपाखे वना। एद्रईलय् बाशानया जुजु ओग व वया सेना झीपिंलिसें ल्‍वायेत वल। ");
INSERT INTO new_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","परमप्रभुं जितः धयादिल, “व खनाः ग्‍याये मते, छाय्‌धाःसा वयात, वया फुक्‍क सेना व देशनापं छिमिगु ल्‍हातय् बियागु दु। छिमिसं हेश्‍बोनय् राज्‍य याइम्‍ह एमोरीतय् जुजु सीहोनयात गथे यानागु खः वयात नं अथे हे या।” ");
INSERT INTO new_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","थुकथं परमप्रभु झी परमेश्‍वरं बाशानया जुजु ओग व वया फुक्‍क सेनायात झीगु ल्‍हातय् बियादिल। झीसं छम्‍हय्‌सित नं मत्‍वःतुसें सकसितं स्‍यानाबिया। ");
INSERT INTO new_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","उबलय् हे झीसं बाशानय् ओगया राज्‍य अर्गोबया फुक्‍क लागानापं इमि फुक्‍क खुइगू शहर त्‍याकाकया। झीसं छगू शहर नं मत्‍वःता। ");
INSERT INTO new_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","थुपिं फुक्‍क शहरय् ततःजाःगु पःखाः ग्‍वयातःगु दु। अले शहरया मू ध्‍वाखाय् खगः दु। अन पःखाः ग्‍वयामतःगु यक्‍व गां नं दु। ");
INSERT INTO new_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","हेश्‍बोनया जुजु सीहोनयात नाश यानागु थें इमि फुक्‍क शहर, मिजं मिस्‍त व मस्‍तय्‌त भज्‍यंक नाश यानाबिया। ");
INSERT INTO new_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","अय्‌नं फुक्‍क पशुत व शहरय्‌ लुतय्‌ यानागु धनसम्‍पत्ति झीसं थःगु निंतिं कया। ");
INSERT INTO new_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","उबलय् झीसं थुपिं निम्‍ह एमोरी जुजुतय्‌गु ल्‍हातिं अर्नोन खुसिया न्‍हसिकापंनिसें हेर्मोन पर्वत तक यर्दनया पुर्बपाखेया देश कया। ");
INSERT INTO new_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(हेर्मोनयात सीदोनीतय्‌सं सिरिओन व एमोरीतय्‌सं सेनीर धाइगु।) ");
INSERT INTO new_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","तःजाःगु माथंवंगु थासय् लाःगु फुक्‍क शहर, गिलाद व बाशान अले बाशानय् दुगु ओगया देशयागु सलका व एद्रई शहर तक हे झीसं फुक्‍क कयाः। ");
INSERT INTO new_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(रपाईतय् दकलय् लिपांम्‍ह मनू बाशानया जुजु ओग खः। वयागु नँयागु खाताया हाकः गुंगू कु अले ब्‍या प्‍यंगू कु दु। व खाता आः तक नं अम्‍मोनीतय्‌गु शहर रब्‍बाय् दनि।) ");
INSERT INTO new_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","उबलय् झीसं व देश त्‍याकाकयाबलय् अर्नोन खुसियागु न्‍हसिकाप च्‍वसं दुगु अरोएरंनिसें कयाः गिलाद पर्वतया बच्‍छि ब्‍व व उकिया शहर जिं रूबेनी व गादीतय्‌त बिया। ");
INSERT INTO new_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","गिलादया ल्‍यं दुगु ब्‍व, अले ओगं राज्‍य यानाच्‍वंगु फुक्‍क बाशान जिं मनश्‍शेया बच्‍छि कुलयात बिया। (बाशानय् दुगु अर्गोबया फुक्‍क लागायात रपाईतय्‌गु देश धाइगु खः।) ");
INSERT INTO new_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","मनश्‍शेया सन्‍तान याईरं गशूरीतय्‌गु व माकातीतय्‌गु सिमाना तक अर्गोबया फुक्‍क लागा कयाः उकियात थःगु हे नां बिल। अथे जुयाः थौं तक नं बाशानयात हब्‍बात-याईर धाइगु। ");
INSERT INTO new_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","माकीरयात जिं गिलाद बिया। ");
INSERT INTO new_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","जिं रूबेनी व गादीतय्‌त गिलादंनिसें अर्नोन खुसि तक (खुसिया दथु अम्‍मोनीतय् दच्‍छिन सिमाना खः) अले उत्तरय् अम्‍मोनीतय्‌गु सिमाना यब्‍बोक खुसि तक बिया। ");
INSERT INTO new_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","उकियागु पच्‍छिमी सिमाना उत्तरय् किन्‍नरेत समुद्रंनिसें दच्‍छिनय् पिसगाया पाःचा क्‍वय् च्‍वंगु खारा समुद्र तक यर्दन खुसि खः। ");
INSERT INTO new_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","उबलय् जिं यर्दन पुर्ब च्‍वनाच्‍वनिपिन्‍त थ्‍व आज्ञा बिया, “परमप्रभु छिमि परमेश्‍वरं थ्‍व देश छिमित अधिकार यायेत बियादीगु खः। अय्‌नं छिमि सकलें सेना ल्‍वाभः ज्‍वनाः थः इस्राएली दाजुकिजातय्‌गु न्‍ह्यःने न्‍ह्यःने वनेमाः। ");
INSERT INTO new_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","अय्‌नं छिमि कलाःपिं, मस्‍त व पशुत जिं छिमित बियागु शहरय् हे च्‍वनी। (छिमिके यक्‍व पशुत दु धकाः जिं स्‍यू।) ");
INSERT INTO new_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","परमप्रभुं छिमित थें छिमि दाजुकिजापिन्‍त आराम बियामदीतले अले इमिसं नं परमप्रभु छिमि परमेश्‍वरं यर्दन पच्‍छिमय् इमित बियादीगु जमिन अधिकार मयातले छिमिसं थथे या। अनंलि जिं छिमिगु अधिकारय् बियागु देशय् फुक्‍क मिजंत लिहां वये फइ।” ");
INSERT INTO new_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","उबलय् जिं यहोशूयात थ्‍व आज्ञा बिया, “परमप्रभु छिमि परमेश्‍वरं थुपिं निम्‍ह जुजुयात छु यानादिल व फुक्‍क छं थःगु हे मिखां खंगु दु। छिपिं खुसिया पच्‍छिमय् वनीबलय् उपिं फुक्‍क देशतय्‌त नं परमप्रभुं अथे हे यानादी। ");
INSERT INTO new_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","इपिं खनाः ग्‍याये मते, छाय्‌धाःसा परमप्रभु छिमि परमेश्‍वर छिमिगु निंतिं ल्‍वानादी।” ");
INSERT INTO new_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","उबलय् जिं परमप्रभुयात थथे धकाः बिन्‍ति याना, ");
INSERT INTO new_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“परमप्रभु परमेश्‍वर छिं थः दासयात थःगु महिमा व बल क्‍यनादीत्‍यंगु दु। स्‍वर्ग व पृथ्‍वीइ छिं यानादीगु थें ज्‍याःगु ज्‍या व शक्ति क्‍यनेफुम्‍ह सु द्यः दु धकाः? ");
INSERT INTO new_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","यर्दनया उखेपाखे च्‍वंगु भिंगु देश, न्‍ह्याइपुसे च्‍वंगु पर्वतया देश व लेबनान स्‍वयेत जितः उखे वनेबियादिसँ।” ");
INSERT INTO new_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","अय्‌नं छिमिसं यानाः परमप्रभु जिलिसें तंचायाः जिगु खँ न्‍यनामदी। परमप्रभुं जितः धयादिल, “गात! आः थुकिया बारे जिनापं मेगु खँ ल्‍हाये मते! ");
INSERT INTO new_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","पिसगाया च्‍वकाय् हुँ अले पुर्ब, पच्‍छिम, उत्तर, दच्‍छिन प्‍यखेरं स्‍व। थःगु हे मिखां व देशयात स्‍व। छाय्‌धाःसा छ यर्दनया उखे वने खनी मखु। ");
INSERT INTO new_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","अय्‌नं यहोशूयात आज्ञा ब्‍यु, वयात हःपाः बियाः बल्‍लाकि, छाय्‌धाःसा वं हे छं खंगु देश अधिकारय् हयेत थुपिं मनूतय्‌त यर्दन खुसिया उखे यंकी।” ");
INSERT INTO new_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","अथे जुयाः झीपिं बेथ-पोरया न्‍ह्यःनेयागु ब्‍यासिइ च्‍वना। ");
INSERT INTO new_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","हे इस्राएल, आः जिं छिमित स्‍यनेत्‍यनागु विधि व नियमय् बांलाक ध्‍यान ब्‍यु! थुपिं पालन या गुकिं यानाः छिपिं म्‍वाइ अले छिमिसं छिमि पुर्खाया परमप्रभु परमेश्‍वरं छिमित बियादीत्‍यंगु देशय् दुहां वनाः अधिकार याइ। ");
INSERT INTO new_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","जिं छिमित बियागु आज्ञाय् छुं तने नं मते लिकाये नं मते। अय्‌नं जिं छिमित बियागु परमप्रभु छिमि परमेश्‍वरया आज्ञा मानय् या। ");
INSERT INTO new_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","बाल-पोरय् परमप्रभुं छु यानादिल व छिमिसं थःगु हे मिखां खंगु दु। पोरया बालद्यःया ल्‍यू जूपिं सकलें मनूतय्‌त परमप्रभु परमेश्‍वरं छिमिगु दथुं नाश यानादिल। ");
INSERT INTO new_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","अय्‌नं परमप्रभु छिमि परमेश्‍वरनापं च्‍वनाच्‍वंपिं सकलें थौंतक म्‍वानाच्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","स्‍व! परमप्रभु जिमि परमेश्‍वरं जितः आज्ञा बियादीगु थें, छिमिसं अधिकार याइगु देशय् थुपिं फुक्‍क मानय् यायेत जिं छिमित थुपिं विधि व नियम स्‍यनागु दु। ");
INSERT INTO new_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","छिमिसं परमप्रभुं धाःथें यात धाःसा मेगु जातितय्‌त छिमिगु बुद्धि व छिमिसं खँ थूगु क्‍यनी। अले इमिसं थुपिं आज्ञा न्‍यनाः धाइ, “धात्‍थें हे थ्‍व तःधं जातियापिं मनूत बुद्धि दुपिं व खँ थूपिं खः।” ");
INSERT INTO new_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","झीसं परमप्रभु झी परमेश्‍वरयात बिन्‍ति यानाबलय् वय्‌कः झीनापं गुलि सतिक जुयादिल। उलि सतिक जुइफुम्‍ह मेम्‍ह सुं नं द्यःत व तःधंगु जाति दु ला? ");
INSERT INTO new_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","जिं छिमित थौं बीगु नियम थें पाय्‌छिगु धार्मिक विधि व नियम दुपिं मेगु छुं नं तःधं जाति दु ला? ");
INSERT INTO new_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","तर बांलाक होश यानाच्‍वँ, छिमिसं मिखां खंगु खँ गुबलें ल्‍वममंकेत होश यानाच्‍वँ अले छिमिसं म्‍वानाच्‍वंतले थुपिं आज्ञा थःगु मनं चिला वंकेबी मते। अले थुपिं आज्ञा थः काय्‌म्‍ह्याय्‌पिं व छय्‌पिन्‍त बीगु पक्‍का या। ");
INSERT INTO new_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","छिपिं होरेबय् परमप्रभु थः परमेश्‍वरया न्‍ह्यःने दंगु दिंयात लुमंकि। उबलय् परमप्रभुं जितः धयादिल, “मनूतय्‌त जिगु न्‍ह्यःने मुंकि, अले इमित जिगु वचन न्‍यंकि। गुकिं यानाः जिं इमित बीत्‍यनागु देशय् म्‍वानाच्‍वंतले इमिसं जिगु ग्‍याःभय कायेमाः अले इमिसं थ्‍व हे खँ थःकाय् म्‍ह्याय्‌पिन्‍त स्‍यनेमाः।” ");
INSERT INTO new_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","उबलय् पर्वतय् मि ह्वानाः ह्वानाः च्‍यानाः आकाश तक हे थ्‍यन, अले ख्‍वातुगु सुपाँय्‌ वयाः अन तसकं खिउँसे च्‍वंबलय् छिपिं वयाः पर्वतया क्‍वय् दन। ");
INSERT INTO new_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","अले मिया दथुं परमप्रभु छिपिंनापं खँ ल्‍हानादिल। उबलय् छिमिसं वय्‌कःया सः जक ताल। वय्‌कःयात धाःसा मखं। ");
INSERT INTO new_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","वय्‌कलं छिमित थःगु बाचा व झिगू आज्ञा न्‍यंकादिल। उकियात मानय् यायेगु आज्ञा छिमित बियादिल। अले वय्‌कलं उपिं आज्ञायात ल्‍वहंयागु निपाः पौलय् च्‍वयादिल। ");
INSERT INTO new_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","उबलय् परमप्रभुं जितः छिमिसं यर्दन छिनावनाः अधिकार यायेगु देशय् थ्‍यंकाः मानय् यायेत विधि व नियम स्‍यँ धकाः धयादिल। ");
INSERT INTO new_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","होरेबय् परमप्रभु छिपिंलिसें मिया दथुं खँ ल्‍हानादीबलय् छिमिसं वय्‌कःयागु छुं नं रूप मखं। अथे जुयाः होश या, ");
INSERT INTO new_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","छिपिं मस्‍यनेमा धकाः, छिमिसं थःपिनि लागिं मिजंया जुइमा वा मिसाया जुइमा, ");
INSERT INTO new_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","वा पृथ्‍वीइ दुम्‍ह पशुयागु जुइमा, आकाशय् ब्‍वइम्‍ह झंगःयागु जुइमा ");
INSERT INTO new_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","चिचीधिकःम्‍ह जन्‍तु वा किचाकाचायागु जुइमा वा लखय् दुम्‍ह न्‍यायागु जुइमा छुकिंयागु नं मूर्ति दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","छिमिसं आकाशपाखे थस्‍वइबलय् अन दुगु सूर्य, तिमिला, नगुत व फुक्‍क ग्रह नक्षत्रतय्‌त खनाः उमित भागियाये मते, पुजा नं याये मते। उपिं परमप्रभुं पृथ्‍वीया फुक्‍क जातितय्‌गु निंतिं बियादीगु खः। ");
INSERT INTO new_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","छिमित धाःसा परमप्रभुं न नाय्‌कीगु मिगा थें ज्‍याःगु मिश्रं वय्‌कःया थः मनू व सर्बय दय्‌केत पिकयाहयादिल, थौं तक जूगु थें। ");
INSERT INTO new_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","अनंलि छिमिसं यानाः परमप्रभु जि खनाः तंचायाः थथे पाफयादिल, “छ यर्दनया उखे वने दइ मखु, अले परमप्रभु छिमि परमेश्‍वरं छिमिगु अधिकारय् बियादीगु व भिंगु देशय् वने दइ मखु।” ");
INSERT INTO new_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","जि थ्‍व हे देशय् सिनावनेमाली। जि यर्दनया उखे वने दइ मखु। छिपिं धासाः उखे वनी, अले व भिंगु देशयात अधिकार याइ। ");
INSERT INTO new_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","होश या! परमप्रभु छिमि परमेश्‍वरं छिपिंलिसें यानादीगु बाचा ल्‍वःमंके मते! वय्‌कलं दय्‌के मते धकाः धयादीगु छुकियागु नं मूर्ति दय्‌के मते! ");
INSERT INTO new_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","परमप्रभु छिमि परमेश्‍वर भस्‍म याइगु मि व नुगः मुइकादीम्‍ह परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","छिमिसं काय्‌म्‍ह्याय् व छय् बुइके धुंकाः यक्‍व दँ व देशय् च्‍वने धुंकाः स्‍यनाः मूर्ति कियाः परमप्रभु छिमि परमेश्‍वरयात मयःगु ज्‍या यानाः वय्‌कःयात तंचाय्‌कल धाःसा, ");
INSERT INTO new_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","थौं जिं स्‍वर्ग व पृथ्‍वीयात छिमिगु विरोधय् साक्षी तये। छिपिं देशयात अधिकार यायेत यर्दनया उखे वनेत्‍यंगु दु। अय्‌नं छिमिसं जिगु आज्ञा त्‍वाथुल धाःसा यक्‍व दँ तक अन च्‍वने दइ मखु। तर छिपिं भज्‍यंक नाश जुयावनी। ");
INSERT INTO new_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","परमप्रभुं छिमित जाति जातितय्‌गु दथुइ उखेलाः थुखेलाः यानाबी। वय्‌कलं छिमित लिनाछ्वःगु देश देशय् मेगु जातितय्‌गु दथुइ छिपिं कम जक म्‍वानाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","अन छिमिसं मनूतय्‌गु ल्‍हातं दय्‌कूपिं स्‍वये मफुपिं, न्‍यने मफुपिं, नये मफुपिं, नतुने मफुपिं सिँ व ल्‍वहंया द्यःतय्‌गु पुजा याइ। ");
INSERT INTO new_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","अय्‌नं अन नं परमप्रभु छिमि परमेश्‍वरयात छिमिसं माल धाःसा, अले छिमिसं दुनुगलं व आत्‍मां माल धाःसा वय्‌कःयात नापलाकी। ");
INSERT INTO new_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","लिपांगु इलय् छिमित आपत जुइबलय् अले थुपिं फुक्‍क खँ छिमित वइबलय् छिपिं थः परमप्रभु परमेश्‍वरपाखे लिहां वइ अले छिमिसं वय्‌कःया खँ मानय् याइ। ");
INSERT INTO new_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","वय्‌कलं छिमित त्‍वःतादी मखु, नाश यानादी मखु। छिमि पुर्खालिसें पाफयाः क्‍वःछिनादीगु बाचा ल्‍वःमंकादी मखु, छाय्‌धाःसा परमप्रभु छिमि परमेश्‍वर माया यानादीम्‍ह खः। ");
INSERT INTO new_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","न्‍हापायागु खँ बिचाः या, परमेश्‍वरं पृथ्‍वीइ मनूयात दय्‌कादीबलय्‌निसें थौं तक आकाशया छगू कुन्‍चांनिसें मेगु कुन्‍चा तक, छु थज्‍याःगु तःधंगु खँ गुबलें जूगु दु वा न्‍यनागु दु ला? ");
INSERT INTO new_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","परमेश्‍वर मिया दथुं न्‍ववानादीगु छिमिसं थें मेगु जातिं न्‍यनाः नं म्‍वानाच्‍वंपिं छिपिं थें ज्‍याःपिं सुं मनूत दु ला? ");
INSERT INTO new_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","छिमि परमप्रभु परमेश्‍वरं छिमित मिश्रय् यानादी थें छु सुं द्यवं मेगु जातिया दथुं पित हयाः थः मनूत दय्‌कूगु दु ला? छिमिसं खंक हे वय्‌कलं थःगु बल्‍लागु ल्‍हाः व चकंगु लँपु छ्यलादिल। वय्‌कलं महामारी व लडाइँ हयादिल, अले अजू चाइपुगु व ग्‍यानापुस्‍से च्‍वंगु ज्‍या यानादिल ला? ");
INSERT INTO new_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","परमप्रभु हे परमेश्‍वर खः, वय्‌कः बाहेक मेम्‍ह सुं मदु धकाः थुइकेत उपिं फुक्‍क छिमित क्‍यंगु खः। ");
INSERT INTO new_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","छिपिं खःकथं जुइमा धकाः वय्‌कलं आकाशं थःगु सः न्‍यंकादिल, अले पृथ्‍वीइ थःगु तःधंगु मि छिमित क्‍यनादिल। छिमिसं मिं वय्‌कःया सः न्‍यन। ");
INSERT INTO new_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","वय्‌कलं छिमि पुर्खातय्‌त माया यानादीगुलिं इमि सन्‍तानतय्‌त नं ल्‍ययादिल। वय्‌कः थम्‍हं हे थःगु तःधंगु शक्तिं छिमित मिश्रं पितहयादिल। ");
INSERT INTO new_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","छिमिसं थःपिं स्‍वयाः तःधं व शक्ति दुपिं जातितय्‌गु देशय् दुहां वनाः उकियात अधिकार यायेत वय्‌कलं इमित लिना छ्वयादीगु दु। व थौं तक छिमिगु अधिकारय् दु। ");
INSERT INTO new_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","परमप्रभु हे च्‍वय् स्‍वर्गय् व क्‍वय् पृथ्‍वीइ परमेश्‍वर खः अले वय्‌कः बाहेक मेम्‍ह सुं मदु धकाः छिमिसं थौं सीका का, अले नुगलय् ति। ");
INSERT INTO new_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","थौं जिं छिमित बीत्‍यनागु वय्‌कःया विधि व आज्ञा मानय् या, गुकिं यानाः छिमिगु व छिमि सन्‍तानतय्‌गु भिं जुइमा, अले परमप्रभु छिमि परमेश्‍वरं छिमित न्‍ह्याबलेंया निंतिं बियादीगु देशय् छिपिं ताःई तक म्‍वानाच्‍वनेमा। ");
INSERT INTO new_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","अले मोशां यर्दनया पुर्बपाखे शरण बीगु स्‍वंगू शहर ल्‍यल। ");
INSERT INTO new_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","सुं मनुखं ग्‍वसाः मग्‍वसे मसीकं सुं मेम्‍ह मनूयात स्‍यात धाःसा व मनू उपिं शहर मध्‍ये छगुलिइ बिस्‍युं वनाः थःत बचय् याये फु। ");
INSERT INTO new_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","उपिं शहर थथे दु, रुबेनीतय्‌गु लागिं मरुभूमिइ दुगु बेसेर, गादीतय्‌गु लागिं गिलादय् दुगु रामोत व मनश्‍शेया लागिं बाशानय् दुगु गोलान। ");
INSERT INTO new_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","मोशां इस्राएलीतय्‌त ब्‍यूगु नियम थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","इपिं मिश्रं पिहां वये धुंकाः मोशां इमित ब्‍यूगु आज्ञा, विधि व नियम थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","यर्दनया पुर्बय् बेथ-पोर न्‍ह्यःनेया ब्‍यासिइ मोशा व इस्राएलीतय्‌सं मिश्रं पिहां वये धुंकाः स्‍यानाब्‍यूम्‍ह हेश्‍बोनय् च्‍वनीम्‍ह एमोरीतय् जुजु सीहोनयागु देशय् थुपिं विधि, आज्ञा व नियम ब्‍यूगु खः। ");
INSERT INTO new_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","इमिसं वया देशयात त्‍याका काल अले बाशानया जुजु ओगया देशयात त्‍याका काल। थुपिं निम्‍ह एमोरी जुजुपिं यर्दनया पुर्बपाखे च्‍वनिपिं खः। ");
INSERT INTO new_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","इमिगु देशय् अर्नोन खुसियागु न्‍हसिकापया च्‍वसं दुगु अरोएर शहरंनिसें सियोन पर्वत तक लाःगु दु। (थुकियात हेर्मोन पर्वत नं धाः) ");
INSERT INTO new_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","यर्दनया पुर्बय् पिसगाया पाचाया क्‍वय् च्‍वंगु मृत सागर तक इस्राएलीतय्‌सं फुक्‍क अराबा त्‍याका काल। ");
INSERT INTO new_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","मोशां सकलें इस्राएलीतय्‌त सःताः धाल, हे इस्राएल, थौं जिं छिमित कनेत्‍यनागु विधि व नियम न्‍यँ! उपिं सय्‌काः बांलाक मानय् या! ");
INSERT INTO new_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","परमप्रभु झी परमेश्‍वरं झीपिंलिसे होरेबय् छगू बाचा चिनादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","थ्‍व बाचा परमप्रभुं झी पुर्खालिसें मखु अय्‌नं झीपिं थौं तक म्‍वानाच्‍वनापिंलिसें चिनादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","परमप्रभुं मिया दथुं छिपिंलिसें पर्वतय् चुलिंचू च्‍वनाः खँ ल्‍हानादिल। ");
INSERT INTO new_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(उबलय् छिपिं मि खनाः ग्‍यानाः पर्वतय् थाहां मवं, अथे जुयाः जि परमप्रभु व छिमिगु दथुइ वय्‌कःया वचन छिमित कनेत दनाच्‍वना।) अले परमप्रभुं धयादिल, ");
INSERT INTO new_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“छिमित छिपिं दास जुयाः च्‍वनाच्‍वंगु मिश्र देशं त्‍वःतका हयाम्‍ह जि परमप्रभु छिमि परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","जि बाहेक मेपिं द्यःतय्‌गु आराधना गुबलें याये मते।” ");
INSERT INTO new_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“थःगु निंतिं च्‍वय् आकाशय् च्‍वंगु, क्‍वय् पृथ्‍वीइ च्‍वंगु व लखय् च्‍वंगु छुकिंयागु नं मूर्ति दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","छिमिसं उकियात भागियाये मते, पुजा याये मते। छाय्‌धाःसा जि परमप्रभु छिमि परमेश्‍वर नुगः मुइकीम्‍ह परमेश्‍वर खः। जिं जितः मयय्‌कीम्‍ह मनूया पापया सजाँय वया स्‍वंगू प्‍यंगू पुस्‍ता तकया सन्‍तानयात बी। ");
INSERT INTO new_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","जितः माया याइपिं व जिगु आज्ञा मानय् याइपिन्‍त धाःसा वया द्वलंद्वः पुस्‍ता तकयात जिं सदां दयामाया याये।” ");
INSERT INTO new_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“म्‍वायेकं म्‍वायेकं परमप्रभु छिमि परमेश्‍वरयागु नां काये मते। म्‍वायेकं म्‍वायेकं वय्‌कःया नां काइम्‍हय्‌सित वय्‌कलं सजाँय बियादी।” ");
INSERT INTO new_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“परमप्रभु परमेश्‍वरं धयादीगु थें विश्रामबार हनेमाः। अले उकियात पवित्र याना तयेमाः। ");
INSERT INTO new_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","खुन्‍हु तक थःगु फुक्‍क ज्‍या या। ");
INSERT INTO new_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","न्‍हय्‌न्‍हु खुन्‍हु धाःसा परमप्रभु छिमि परमेश्‍वरया विश्रामबार खः। उखुन्‍हु छिमिसं, छिमि काय् म्‍ह्याय्‌पिन्‍सं, छिमि दास-दासीं, छिमि द्वहं वा गधा, अले न्‍ह्याम्‍ह पशु नं व छिमिगु शहरय् च्‍वनाच्‍वंपिं परदेशीतय्‌सं तकं छुं ज्‍या याये मते। छिमि दासदासीतय्‌सं नं छिमिसं थें झासु लनेमाः। ");
INSERT INTO new_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","छिपिं मिश्रय् दास जुयाच्‍वंबलय् गथे यानाः परमप्रभु छिमि परमेश्‍वरं थःगु बल्‍लाःगु ल्‍हाः व चक्‍कंगु लपुं छिमित पितहयादिल। व लुमंका ति! अथे जुयाः परमप्रभु छिमि परमेश्‍वरं विश्रामबार हनेत छिमित आज्ञा बियादीगु खः।” ");
INSERT INTO new_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“परमप्रभु छिमि परमेश्‍वरं आज्ञा बियादीगु थें छिमिसं थः मां-बौयात हनाबना या, अले परमेश्‍वरं बीत्‍यंगु देशय् छिपिं ताःई तक म्‍वाइ। अले अन छिमित भिं जुइ।” ");
INSERT INTO new_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“सुयातं स्‍याये मते।” ");
INSERT INTO new_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“व्‍यभिचार याये मते।” ");
INSERT INTO new_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“खुयाकाये मते।” ");
INSERT INTO new_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“मुद्दामामिलाय् थः जःलाखःलाया विरोधय् मखुगु साक्षी बी मते।” ");
INSERT INTO new_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“थः जःलाखःलाया कलाःयात मिखा वंके मते! थः जःलाखःलाया छेँ व जमिन लोभ याये मते! थः जःलाखःलाया च्‍यःभ्‍वातिं, द्वहं, गधा व छुं खँय् नं लोभ याये मते!” ");
INSERT INTO new_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","थुपिं वचन परमप्रभुं पर्वतय् मि व खिउँगु हाकुगु सुपाँय्‌या दथुं छिमि फुक्‍क खलःयात तस्‍सलं धयादिल। वय्‌कलं मेगु छुं धयामदी। अले उपिं आज्ञा निपाः ल्‍वहं पौलय् च्‍वयाः जितः बियादिल। ");
INSERT INTO new_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","छिमिसं खिउँगुया दथुं सः न्‍यंबलय् अले पर्वतय् मिं च्‍यानाच्‍वंबलय् छिमि कुलनायःत व थकालित जिगु न्‍ह्यःने वयाः ");
INSERT INTO new_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","थथे धाल, “परमप्रभु झी परमेश्‍वरं झीत झःझः धाय्‌क व महिमा क्‍यनादिल, अले झीसं मिया दथुं वय्‌कःया सः न्‍यना। परमेश्‍वरं मनूतलिसें न्‍ववानादीसां मनूत मस्‍यूगु थौं तिनि जिमिसं खना। ");
INSERT INTO new_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","आः झीपिं छाय् मिं भस्‍म जुयाः सिनावनेगु? परमप्रभु झी परमेश्‍वरयागु सः झीसं हानं न्‍यन धाःसा झीपिं सिनावनी। ");
INSERT INTO new_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","मिया दथुं म्‍वाःम्‍ह परमेश्‍वरं न्‍ववानादीगु न्‍यनाः नं झीपिं थें म्‍वाःपिं मेपिं व मसीपिं सु सीमाःपिं मनू दु? ");
INSERT INTO new_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","छि थः हे न्‍ह्यःने झासँ अले परमप्रभु झी परमेश्‍वरं धयादीगु फुक्‍क खँ जिमित धयादिसँ अले जिमिसं न्‍यने।” ");
INSERT INTO new_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","छिमिसं जितः धाःगु थ्‍व खँ परमप्रभुं ताल, अले वय्‌कलं जितः धयादिल, “मनूतय्‌सं छन्‍त छु खँ धाःगु खः व जिं ताः। इमिसं छु छु धाल व पाय्‌छि जू। ");
INSERT INTO new_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","जिगु भय काइगु व न्‍ह्याबलें जिगु आज्ञा मानय् याइगु इमिगु मन जूगु जूसा इपिं व इमि सन्‍तानतय्‌गु न्‍ह्याबलें भिं जुइ। ");
INSERT INTO new_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“छ वनाः इमित छिपिं थथःगु पालय् लिहां हुँ धकाः धा। ");
INSERT INTO new_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","छ धाःसा थन जिगु न्‍ह्यःने दनाच्‍वँ। अले इमित स्‍यने माःगु फुक्‍क आज्ञा, विधि व नियम जिं छन्‍त धाये, अले इमिगु अधिकारय् बीगु देशय् इमिसं उपिं मानय् यायेमाः।” ");
INSERT INTO new_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","अथे जुयाः परमप्रभु छिमि परमेश्‍वरया आज्ञाकथं जुइत लुमंका ति। छिपिं जव खवं गन नं वने मते। ");
INSERT INTO new_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","परमप्रभु छिमि परमेश्‍वरं छिमित बियादीगु आज्ञाकथं फुक्‍क लँपुइ हुँ। अले छिमिसं अधिकार यायेगु देशय् छिपिं म्‍वानाच्‍वनी व छिमिगु भिं जुइ, अले छिपिं ताःई तक म्‍वाइ। ");
INSERT INTO new_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","छिमिसं यर्दन छिनावनाः अधिकार यायेत्‍यंगु देशय् मानय् यायेमाः धकाः छिमित स्‍यनेत परमप्रभु छिमि परमेश्‍वरं जितः धयादीगु आज्ञा, विधि व नियम थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","जिवंकाछि परमप्रभु छिमि परमेश्‍वरयागु भय कयाः छिमि काय्‌म्‍ह्याय्‌पिं व छय्‌पिन्‍सं वय्‌कःया फुक्‍क आज्ञा व नियम मानय् यायेमाः। अले छिपिं ताःई तक म्‍वाइ। ");
INSERT INTO new_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","हे इस्राएल न्‍यँ, थुपिं फुक्‍क बांलाक्‍क मानय् या अले छिमिगु भिं जुइ। परमप्रभु छिमि पुर्खातय् परमेश्‍वरं छिमित बचं बियादीगु थें दुरु व कस्‍ति बाः वयाच्‍वंगु देशय् छिमिगु ल्‍याः यक्‍व अप्‍वः जुइ। ");
INSERT INTO new_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","हे इस्राएल न्‍यँ! परमप्रभु झी परमेश्‍वर छम्‍ह हे जक दु। ");
INSERT INTO new_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","परमप्रभु झी परमेश्‍वरयात दुनुगलंनिसें माया या, थःगु प्राण बिया तकं माया या, अले थःगु बलं फत्तले माया या। ");
INSERT INTO new_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","जिं थौं छिमित बीत्‍यनागु आज्ञा छिमिगु नुगलय् दया हे च्‍वनेमाः। ");
INSERT INTO new_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","उपिं आज्ञा छिमिसं थःकाय् म्‍ह्याय्‌पिन्‍त बांलाक स्‍यँ। छेँय् च्‍वनीबलय्, लँय् जुइबलय् ग्‍वार्तुला च्‍वनीबलय् अले दनीबलय् उकिया बारे खँल्‍हाबल्‍हा यायेगु या। ");
INSERT INTO new_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","उपिं आज्ञा व विधि चिंकथं ल्‍हातय् व कपालय् चिना ति। ");
INSERT INTO new_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","उपिं आज्ञा थथःगु छेँया लुखा दुवालय् व मूध्‍वाखाय् च्‍वया ति। ");
INSERT INTO new_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","अले परमप्रभु छिमि परमेश्‍वरं अब्राहाम, इसहाक व याकूब नांयापिं छिमि पुर्खालिसें छिमित बी धकाः पाफयादीगु देशय् हयादीबलय् व छिमिसं मदय्‌कूगु ततःधंगु बाबांलाःगु शहर ");
INSERT INTO new_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ज्‍वरय् मयाःगु भिंगु भिंगु सामानं जाःगु छेँ, मम्‍हूगु तुं, मप्‍यूगु दाखक्‍यब व जैतूनया सिमा, थुपिं फुक्‍कं वय्‌कलं छिमित बियादी। उबलय् छिमिसं नयाः प्‍वाः जाइबलय्, ");
INSERT INTO new_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","होश या! छिमित मिश्र देशं दासत्‍वं पितहयादीम्‍ह परमप्रभुयात ल्‍वःमंके मते। ");
INSERT INTO new_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","छिमिसं परमप्रभु छिमि परमेश्‍वरयागु ग्‍याःभय का, वय्‌कःयागु जक सेवा या अले वय्‌कःया हे नामय् पाफयेगु या। ");
INSERT INTO new_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","छिमिसं थः जःखः च्‍वंपिं जातितय् द्यःतय्‌त पुजा याये मते। ");
INSERT INTO new_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","छाय्‌धाःसा छिमिगु दथुइ च्‍वनादीम्‍ह परमप्रभु छिमि परमेश्‍वर नुगः मुइकादीम्‍ह परमेश्‍वर खः। अथे मयात धाःसा परमप्रभु छिमि परमेश्‍वरयागु तं छिमित लाइ, अले वय्‌कलं छिमित पृथ्‍वीं नाश यानादी। ");
INSERT INTO new_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","छिमिसं मस्‍साहय् यानागु थें परमप्रभु परमेश्‍वरयागु मन स्‍वये मते। ");
INSERT INTO new_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","परमप्रभु छिमि परमेश्‍वरयागु आज्ञा व वय्‌कलं छिमित बियादीगु आज्ञा, विधि व नियम बांलाक मानय् या। ");
INSERT INTO new_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","परमप्रभुयागु मिखाय् छु छु पाय्‌छि व भिं जू व हे जक या, अले छिमिगु भिं जुइ। अले छिमि पुर्खानापं परमप्रभुं पाफयाः बचं बियादीगु थें छिमिसं व भिंगु देश त्‍याकाकाये फइ। ");
INSERT INTO new_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","अनंलि परमप्रभुं धयादीगु थें छिमिसं सकल शत्रुतय्‌त थःगु न्‍ह्यःनं लिनाछ्वये फइ। ");
INSERT INTO new_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","लिपाया इलय् छिमि काय्‌नं “परमप्रभु झी परमेश्‍वरं बियादीगु थुपिं आज्ञा, नियम व विधितय्‌गु मतलब छु खः?” धकाः न्‍यनीबलय् ");
INSERT INTO new_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","छिमिसं वयात थथे धा, “झीपिं मिश्रय् फारोया दास जुयाच्‍वनागु खः, अले परमप्रभुं झीत मिश्रं थःगु बल्‍लाःगु ल्‍हातं पितहयादिल। ");
INSERT INTO new_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","परमप्रभुं झीगु मिखाया न्‍ह्यःने हे मिश्रीत, फारो व वया सकलें छेँजःतय्‌त तसकं ग्‍यानापुसे च्‍वंगु चिं व अजू चायापुगु ज्‍या क्‍यनादिल। ");
INSERT INTO new_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","झी पुर्खालिसें पाफयाः बी धकाः धयादीगु देशय् हयेत वय्‌कलं झीत अनं पितहयादिल। ");
INSERT INTO new_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","परमप्रभुं हे झीत थुपिं फुक्‍क नियम मानय् यायेगु व परमप्रभु झी परमेश्‍वरयागु भय कायेगु आज्ञा बियादीगु खः। अथे याःसा झीगु भिं जुया हे च्‍वनी, अले थौं तक थें वय्‌कलं झीत म्‍वाःकातइ। ");
INSERT INTO new_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","परमप्रभु झी परमेश्‍वरं बियादीगु थुपिं फुक्‍क आज्ञा झीसं बांलाक मानय् यात धाःसा, व हे झीगु धार्मिकता जुइ।” ");
INSERT INTO new_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","छिपिं अधिकार यायेत वनेत्‍यंगु देशय् परमप्रभु छिमि परमेश्‍वरं छिमित हयादीबलय् अले छिपिं स्‍वयाः यक्‍व ल्‍याः दुपिं व बल्‍लाःपिं थुपिं न्‍हय्‌गू जाति हित्ती, गिर्गाशी, एमोरी, कनानी, परिज्‍जी, हिव्‍वी व यबूसीतय्‌त छिमिगु न्‍ह्यःनं वय्‌कलं लिना छ्वयादीबलय् ");
INSERT INTO new_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","परमप्रभु छिमि परमेश्‍वरं इमित छिमिगु ल्‍हातय् बियादिल, छिमिसं इमित बुकीबलय् छिमिसं इमित भज्‍यंक नाश यानाब्‍यु। इपिंलिसें सन्‍धि याये मते। अले इमित माया याये मते। ");
INSERT INTO new_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","इपिंलिसे ब्‍याहा याये मते। छिमि म्‍ह्याय्‌पिं इमि काय्‌पिन्‍त बी मते, अले इमि म्‍ह्याय्‌पिं छिमि काय्‌पिनिगु लागि हये मते। ");
INSERT INTO new_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","छाय्‌धाःसा इमिसं छिमि काय्‌पिन्‍त परमप्रभुपाखें हीकाः मेपिं द्यःतय्‌गु पुजा याकेबी। अथे याःसा परमप्रभु छिपिं खनाः तसकं तंचायादी अले वय्‌कलं छिमित याकनं हे नाश यानाबी। ");
INSERT INTO new_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","छिमिसं थथे या – इमिगु वेदी थुनाब्‍यु, इमिगु पुजा याइगु ल्‍वहं तछ्यानाब्‍यु। इमिगु अशेरा द्यःमय्‌जुयागु थां पालाः क्‍वथलाब्‍यु। अले इमिगु मूर्तित मिइ छ्वय्‌काब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","परमप्रभु छिमि परमेश्‍वरया निंतिं छिपिं छगू पवित्र जाति खः। परमप्रभु छिमि परमेश्‍वरं पृथ्‍वीइ दुपिं सकलें मनूतय् दथुं थःगु निंतिं विशेष सम्‍पत्तिकथं छिमित ल्‍ययादिल। ");
INSERT INTO new_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","छिपिं ल्‍याखय् मेगु जाति स्‍वयाः अप्‍वः दयाः परमप्रभुं छिमित माया यानादीगु वा ल्‍ययादीगु मखु, छिपिं ला ल्‍याखय् मेगु जातित स्‍वयाः कम दु। ");
INSERT INTO new_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","अय्‌नं परमप्रभुं छिमित माया यानादीगुलिं अले वय्‌कलं छिमि पुर्खालिसें पाफयादीगु पूवंकादीत हे छिमित परमप्रभुं थःगु बल्‍लाःगु ल्‍हातं मिश्रया जुजु फारोया दासत्‍वं त्‍वःतकाः पितहयादिल। ");
INSERT INTO new_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","परमप्रभु हे छिमि परमेश्‍वर खः धकाः सीकाति। वय्‌कः विश्‍वास याये बहःम्‍ह परमेश्‍वर खः। सुनां वय्‌कःयात माया याइ व वय्‌कःया आज्ञा मानय् याइ वया द्वलंद्वः पुस्‍ता तक थःगु बाचा पूवंकादी अले इमित दयामाया याना हे च्‍वनादी। ");
INSERT INTO new_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","अय्‌नं वय्‌कःयात मयय्‌कीपिन्‍त वय्‌कलं हे नाश यानादी। इमित पलेसा कायेत नं लिबाकादी मखु। ");
INSERT INTO new_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","अथे जुयाः थौं जिं बीत्‍यनागु थुपिं आज्ञा, विधि व नियम बांलाक मानय् या। ");
INSERT INTO new_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","छिमिसं थुपिं नियम बांलाक न्‍यनाः मानय् यात धाःसा परमप्रभु छिमि परमेश्‍वरं छिमि पुर्खालिसें यानादीगु मायाया बाचा पूवंकादी। ");
INSERT INTO new_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","वय्‌कलं छिमित माया यानादी। अले सुवाः बियाः छिमिगु ल्‍याः अप्‍वः यानाबी। वय्‌कलं छिमि पुर्खालिसे छिमित बी धकाः पाफयादीगु देशय् छिमि मचाखाचातय्‌त, बुँया फल, अन्‍न, न्‍हूगु दाखमद्य व जैतूनया चिकं, अले सा द्वहं व फैच्‍वलय्‌तय् मस्‍तय्‌गु ल्‍याः नं अप्‍वय्‌काबी। ");
INSERT INTO new_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","छिमित मेपिं मनूत स्‍वयाः अप्‍वः सुवाः दइ। छिमि सुं मिजं वा मिसामचा मदुम्‍ह जुइ मखु। छिमि छम्‍ह नं पशु मचा मदुम्‍ह जुइ मखु। ");
INSERT INTO new_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","परमप्रभुं छिमित फुक्‍क कथंयागु ल्‍वय्‌पाखें तापाक्‍क तयादी। छिमिसं मिश्रय् खंगु ग्‍यानपुसे च्‍वंगु ल्‍वय् वय्‌कलं छिमिथाय् छ्वयाहयादी मखु। छिमित मयय्‌कीपिं मनूतय्‌थाय् धाःसा छ्वयाहयादी। ");
INSERT INTO new_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","परमप्रभु छिमि परमेश्‍वरं छिमिगु ल्‍हातय् बियादीपिं फुक्‍क जातितय्‌त छिमिसं नाश यानाब्‍यु। इमित माया याये मते। इमि द्यःतय्‌त पुजा याये मते, छाय्‌धाःसा व हे छिमित तक्‍यंकीगु जाः जुइ। ");
INSERT INTO new_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","छिमिसं मनमनं थथे धायेफु, “थुपिं जाति झीपिं स्‍वयाः बल्‍ला अले झीसं गथे यानाः इमित पितिनाछ्वये फइ?” ");
INSERT INTO new_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","अय्‌नं इपिं खनाः ग्‍याये मते। परमप्रभु छिमि परमेश्‍वरं फारो व मिश्र न्‍यंकं छु यानादिल व लुमंकि! ");
INSERT INTO new_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","छिमिसं अन हे थःगु मिखां ग्‍यानापुसे च्‍वंगु महामारी खनाः अले परमप्रभु छिमि परमेश्‍वरं अजू चाइपुगु चिं व ज्‍या यानाः थःगु बल्‍लाःगु ल्‍हाः व चकंगु लप्‍पूं छिमित पित हयादीगु दु। छिमित ख्‍याइपिं छिमि शत्रुतय्‌त नं परमप्रभु छिमि परमेश्‍वरं अथे हे यानादी। ");
INSERT INTO new_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","उलि जक मखु इपिं मध्‍ये बचय् जुयाः सुलाच्‍वंपिं नाश मजुतले परमप्रभु छिमि परमेश्‍वरं आतंक नं छ्वयादी। ");
INSERT INTO new_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","छिपिं इपिं खनाः ग्‍याये मते, छाय्‌धाःसा छिमिगु दथुइ च्‍वनाच्‍वंम्‍ह परमप्रभु छिमि परमेश्‍वर तःधंम्‍ह व ग्‍यानपुसे च्‍वंम्‍ह परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","परमप्रभु छिमि परमेश्‍वरं थुपिं जातितय्‌त छिमिगु न्‍ह्यःनेनं भतिभति यानाः पितिनाः छ्वयादी। छिमिसं इपिं फुक्‍कसित आः थत्‍थें सिधय्‌काछ्वये फइ मखु, मखुसा छिमिगु प्‍यखेरं गुँपशुतय्‌गु ल्‍याः अप्‍वः जुयाः छिमिगु मभिं जुइ। ");
INSERT INTO new_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","परमप्रभु छिमि परमेश्‍वरं इमित छिमिगु ल्‍हातय् लाकादी। अले इपिं नाश मजुतले इमित इतिमिति कंकातइ। ");
INSERT INTO new_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","अले वय्‌कलं इमि जुजुतय्‌त छिमिगु ल्‍हातय् बियादी, अले छिमिसं पृथ्‍वीं इमिगु नां हुयाछ्‌वइ। सुं छम्‍ह नं छिमिगु न्‍ह्यःने दनाच्‍वने फइ मखु। छिमिसं इमित नाश याइ। ");
INSERT INTO new_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","इमि द्यःतय्‌गु मूर्ति छिमिसं मिइ छ्वय्‌काब्‍यु। छिमिसं मूर्तिइ दुगु लुँ व वहः ल्‍वःवंकाः काये मते। छाय्‌धाःसा व हे छिमिगु निंतिं तक्‍यंकीगु जाः जुइ। थ्‍व परमप्रभु छिमि परमेश्‍वरयात घच्‍चाइपुगु खँ खः। ");
INSERT INTO new_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","छिमिसं घच्‍चाइपुगु मूर्ति थःगु छेँय् हये मते, मखुसा छिमित नं व थें नाशया लागिं देछाइ। छिपिं थज्‍याःगु मूर्ति खनाः घच्‍चायेमाः, छाय्‌धाःसा व नाशया लागि देछायेमाःगु खः। ");
INSERT INTO new_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","जिं थौं छिमित बियाच्‍वनागु फुक्‍क आज्ञा बांलाक मानय् या। अले छिपिं म्‍वानाः छिमिगु ल्‍याः अप्‍वयावनी। अनंलि परमप्रभु छिमि परमेश्‍वरं छिमि पुर्खायात पाफयाः बी धाःगु देशय् दुहां वनाः उकियात काये फइ। ");
INSERT INTO new_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","छिमित क्‍वमिलु यायेत, छिमिगु मन स्‍वयेत अले वय्‌कःया आज्ञा मानय् याइ कि मयाइ धकाः सीकेत थुपिं पिइदँ यंकं मरुभूमिया लँपुइ परमप्रभु छिमि परमेश्‍वर न्‍ह्यलुवाः जुयाः गथे यानाः छिमित हयादिल व लुमंकि। ");
INSERT INTO new_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","वय्‌कलं छिमित नये पित्‍याकादिल। अले छिमिसं व छिमि पुर्खातय्‌सं मस्‍यूगु मन्‍ना नकादिल। मनूत मरिं जक मखु अय्‌नं परमप्रभुया म्‍हुतुं पिहां वःगु छगू छगू वचनं म्‍वाइ धयागु खँ थुइकाबीत थथे यानादीगु खः। ");
INSERT INTO new_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","थुपिं पिइदँ तक छिमिगु वसः मगू अले छिमिगु तुति मना मवः। ");
INSERT INTO new_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","मनूतय्‌सं थःकाय्‌यात कजय् याःगु थें परमप्रभु छिमि परमेश्‍वरं छिमित कजय् यानादी धकाः छिमिसं सीकि। ");
INSERT INTO new_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","अथे जुयाः परमप्रभु छिमि परमेश्‍वरया भय कयाः वय्‌कःया लँपुइ हुँ अले वय्‌कःया आज्ञा मानय् या। ");
INSERT INTO new_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","छाय्‌धाःसा परमप्रभु छिमि परमेश्‍वरं छिमित छगू भिंगु देशय् ब्‍वनायंका च्‍वनादीगु दु। अन खुसित, मुहान व बुँगाःचां पिहां वःगु लः बेँसी व पहाड जुयाः न्‍ह्याइ। ");
INSERT INTO new_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","व देश छ्व, तछ्व, दाख, यःमरि, धालेसि, जैतूनया चिकं व कस्‍तिं जाःगु दु। ");
INSERT INTO new_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","व देशय् छिमित अन्‍न मगाःमचाः जुइ मखु। अन छिमित छुं नं कम जुइ मखु। व देशयागु ल्‍वहं थें हे नँ न्‍ह्याथाय्‌सं दइ, अले डाँडाय् डाँडाय् सिजः यक्‍व दइ। ");
INSERT INTO new_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","छिमिसं नयाः लुधने धुंकाः परमप्रभु छिमि परमेश्‍वरं छिमित भिंगु देश बियादीगुलिं वय्‌कःयात तःधंकि। ");
INSERT INTO new_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","होश या! परमप्रभु छिमि परमेश्‍वरयात ल्‍वमंके मते, जिं थौं छिमित बियाच्‍वनागु परमप्रभु छिमि परमेश्‍वरया आज्ञा, विधि व नियम मानय् मयासें वय्‌कःयात ल्‍वःमंके मते। ");
INSERT INTO new_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","मखुसा छिपिं लुधनीबलय् अले बांबांलाःगु छेँय् दय्‌काच्‍वनीबलय् ");
INSERT INTO new_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","छिमि फैच्‍वलय् व साद्वहंतय् ल्‍याः अप्‍वःया वनीबलय्, छिमिके दुगु लुँ, वहः व फुक्‍कं गाक्‍क दइबलय् ");
INSERT INTO new_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","छिपिं तःधंछु जुयाः छिमित दासत्‍वया देश मिश्रं पितहयादीम्‍ह परमप्रभु छिमि परमेश्‍वरयात ल्‍वःमंके मते। ");
INSERT INTO new_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","वय्‌कलं छिमित बिख दुपिं सर्प व बिच्‍छी दुगु, लः मदुगु व गंगु बँ दुगु भरायधंगु व ग्‍यानपुसे च्‍वंगु मरुभूमिया दथुं हयादिल। वय्‌कलं छिमिगु निंतिं छाःगु ल्‍वहँतं लः पिकयादिल। ");
INSERT INTO new_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","मरुभूमिइ छिमित क्‍वमिलु यायेत व छिमिगु मन स्‍वयाः लिपा छिमिगु भिं यायेत वय्‌कलं छिमित छिमि पुर्खातय्‌सं मस्‍यूगु मन्‍ना नकादिल। ");
INSERT INTO new_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","“झीगु थःगु ल्‍हाःया शक्ति व बलं हे थ्‍व धन-सम्‍पत्ति झीसं दय्‌कागु खः” धकाः छिमिसं मनमनं धायेफु। ");
INSERT INTO new_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","अय्‌नं परमप्रभु छिमि परमेश्‍वरयात लुमंकि! वय्‌कलं हे छिमि पुर्खालिसें चिनादीगु बाचा पूवंकादीत छिमित धन-सम्‍पत्ति दय्‌केत शक्ति बियादी। ");
INSERT INTO new_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","छिमिसं परमप्रभु थः परमेश्‍वरयात ल्‍वःमंकल धाःसा अले मेपिं द्यःतय्‌गु ल्‍यू वनाः इमित पुजा व भागि यात धाःसा छिपिं धात्‍थें नाश जुइ धकाः जिं थौं छिमित ख्‍याच्‍वः बी। ");
INSERT INTO new_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","परमप्रभु छिमि परमेश्‍वरया वचन मानय् मयात धाःसा परमप्रभु छिमि परमेश्‍वरं छिमिगु न्‍ह्यःने हे जातितय्‌त नाश यानादीगु थें छिमित नं नाश यानादी। ");
INSERT INTO new_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","न्‍यँ, हे इस्राएल, छिपिं स्‍वयाः ततःधंगु व बल्‍लाःगु जातित अले ततःजाःगु व आकाश थ्‍यंक पखाः ग्‍वयातःगु ततःधंगु शहर त्‍याका कायेत छिपिं यर्दनया उखे वनेत्‍यंगु दु। ");
INSERT INTO new_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","अनयापिं मनूत बल्‍लापिं व तःधिकःपिं अनाकीत खः। इमिगु खँ छिमिसं स्‍यू, अले इमिगु बारे थथे धाःगु नं छिमिसं न्‍यंगु दु, “अनाकीतय्‌गु न्‍ह्यःने दंवने फुम्‍ह सु दु?” ");
INSERT INTO new_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","अय्‌नं थौं छिमिसं थ्‍व खँ बांलाक सीकि, ह्वाना ह्वाना च्‍यानाच्‍वंगु मि थें छिमिगु न्‍ह्यःने न्‍ह्यःने झाइम्‍ह परमप्रभु छिमि परमेश्‍वर हे खः। वय्‌कलं इमित नाश यानादी अले छिमिगु न्‍ह्यःने क्‍वत्‍यलादी। परमप्रभुं छिमित बचं बियादीगु थें छिमिसं इमित लिनाछ्वयाः याकनं हे नाश याइ। ");
INSERT INTO new_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","परमप्रभु छिमि परमेश्‍वरं छिमिगु न्‍ह्यःने इमित पित छ्वयादी धुंकाः छिमिसं थःगु मनय् थथे धाये मते, “झीगु धार्मिकतां यानाः परमप्रभुं थ्‍व देशय् अधिकार यायेत झीत हयादीगु खः।” अथे मखु, इपिं जातितय्‌गु मभिंगु ज्‍यां यानाः परमप्रभुं इमित छिमिगु न्‍ह्यःनं लिनाछ्वयादी। ");
INSERT INTO new_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","छिपिं भिंपिं व नुगः यचुपिं जूगुलिं इमिगु देश त्‍याका कायेत वनेत्‍यंगु मखु। अय्‌नं इमिसं याःगु मभिंगु ज्‍यां यानाः वय्‌कलं छिमि पुर्खा अब्राहाम, इसहाक व याकूबलिसें पाफयादीगु खँ पूवंकादीत परमप्रभु छिमि परमेश्‍वरं इमित छिमिगु न्‍ह्यःनं लिनाछ्वयादी। ");
INSERT INTO new_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","अथे जुयाः छिमिगु भिंगु ज्‍यां यानाः थ्‍व भिंगु देश परमप्रभु छिमि परमेश्‍वरं छिमित ल्‍हातय् बियादीत्‍यंगु मखु धकाः ध्‍वाथुइकि। छिपिं ला जिराहा मनूत खः। ");
INSERT INTO new_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","मरुभूमिइ छिमिसं गथे यानाः परमप्रभु छिमि परमेश्‍वरयात तं चाय्‌कागु खः, व खँ लुमंकि, अले गुबलें ल्‍वःमंके मते। छिपिं मिश्र त्‍वःता वःगु दिंनिसें थन थ्‍यंकः वःगु दिं तक छिमिसं परमप्रभुयागु विरोध याना हे च्‍वंगु दु। ");
INSERT INTO new_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","होरेबय् नं छिमिसं परमेश्‍वरयात तसकं तंचाय्‌कल। अथे जुयाः वय्‌कलं छिमित भज्‍यंक नाश यानादीत्‍यंगु खः। ");
INSERT INTO new_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","परमप्रभुं छिपिंलिसें चिनादीगु बाचाया ल्‍वहं पौ कायेत जि पहाडय् थाहां वना। अले पिइन्‍हु व पिइचा जि व पहाडय् च्‍वना। जिं मरि नं मनया लः नं मत्‍वना। ");
INSERT INTO new_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","अबलय् परमप्रभुं जितः थःगु हे ल्‍हातं च्‍वयातःगु निपा ल्‍वहं पौ बियादिल। उकी वय्‌कलं छिपिं पहाडया क्‍वय् छथाय् मुंबलय् मिया दथुं धयादीगु खँ च्‍वयातःगु दु। ");
INSERT INTO new_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","अले पिइन्‍हु व पिइचा बीधुंकाः परमप्रभुं बाचायागु उपिं निपा ल्‍वहं पौ जितः बियादिल। ");
INSERT INTO new_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","परमप्रभुं जितः धयादिल, “आः थत्‍थें पहाडं क्‍वहां हुँ, छाय्‌धाःसा छं मिश्रं पित हःपिं मनूत स्‍यनावने धुंकल। जिं इमित बियागु आज्ञा इमिसं थत्‍थें हे त्‍वःताः इमिसं मूर्ति दय्‌कूगु दु।” ");
INSERT INTO new_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","परमप्रभुं जितः धयादिल, “थुपिं मनूत गुलि जिराहा धकाः जिं स्‍यू। थुमित जिं स्‍वये धुन। ");
INSERT INTO new_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","इमित नाश यायेत छं जितः पने मते। जिं इमिगु नां पृथ्‍वीं हे मदय्‌काः छ्वये। अले छपाखें हे इपिं स्‍वयाः तःधंगु व बल्‍लाःगु जाति दय्‌के।” ");
INSERT INTO new_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","अथे जुयाः ल्‍हातय् बाचाया निपा ल्‍वहं पौ ज्‍वनाः जि पर्वतं क्‍वय् कुहां वया। उबलय् पहाडय् मि च्‍यानाच्‍वन। ");
INSERT INTO new_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","अले छिमिसं परमप्रभु छिमि परमेश्‍वरया विरोधय् पाप यानाः थःगु निंतिं नाय्‌काः छम्‍ह द्वहंचाया मूर्ति दय्‌कूगु जिं खना। परमप्रभुं हुँ धकाः धयादीगु लँपुयात छिमिसं थुलि याकनं त्‍वःतावन। ");
INSERT INTO new_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","अथे जुयाः जिं उपिं निपा ल्‍वहं पौ थःगु हे ल्‍हातं कयाः वांछ्वयाबिया, छिमिसं खंक हे तछ्यानाबिया। ");
INSERT INTO new_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","छिमिसं परमप्रभुया मिखाय् पाप ज्‍या यानाः वय्‌कःयात तंचाय्‌कूगुलिं जि न्‍हापा थें पिइन्‍हु व पिइचा तक परमप्रभुया न्‍ह्यःने भ्‍वसुलाच्‍वना। जिं मरि मनया लः नं मत्‍वना। ");
INSERT INTO new_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","परमप्रभुया तं खनाः जि ग्‍यात, छाय्‌धाःसा वय्‌कलं तसकं तंचायाः छिमित नाश हे यानादीत्‍यंगु खः। अय्‌नं उबलय् नं परमप्रभुं जिगु बिन्‍ति न्‍यनादिल। ");
INSERT INTO new_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","परमप्रभु हारूनलिसे तसकं तंचायादिल, वय्‌कलं वयात तंम्‍वय् नाश यानादीत्‍यंगु खः। अय्‌नं उबलय् जिं हारूनया निंतिं नं प्रार्थना याना। ");
INSERT INTO new_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","अनंलि जिं छिमिगु व पापं जाःगु बस्‍तु, छिमिसं दय्‌कूम्‍ह द्वहंचा कयाः मिइ छ्वय्‌काबिया, अले उकियात निनाः चुंचुं यानाः पर्वतं क्‍वहां वयाच्‍वंगु खुसिइ वांछ्वयाबिया। ");
INSERT INTO new_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","छिमिसं तबेरा, मस्‍साह व किब्रोथ-हत्तावाय् नं परमप्रभुयात तंचाय्‌कल। ");
INSERT INTO new_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","परमप्रभुं छिमित कादेश-बर्नेनं थथे धयाः छ्वयादिल, “वनाः जिं छिमित बियागु देश अधिकार या।” अय्‌नं छिमिसं परमप्रभु छिमि परमेश्‍वरया आज्ञायागु विरोध यात। अले छिमिसं वय्‌कःयात पत्‍याः नं मया, वय्‌कःया खँ नं मन्‍यं। ");
INSERT INTO new_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","जिं छिमित म्‍हस्‍यूबलय्‌निसें हे न्‍ह्याबलें छिमिसं परमप्रभुया विरोध याःगु दु। ");
INSERT INTO new_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","परमप्रभुं छिमित नाश याये धकाः धयादीगुलिं परमप्रभुया न्‍ह्यःने जि पिइन्‍हु व पिइचा तक भ्‍वसुलाच्‍वना। ");
INSERT INTO new_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","जिं प्रार्थना यानाः धया, “हे परमप्रभु परमेश्‍वर, छिं ल्‍ययादीपिं थःगु तःधंगु बलं त्‍वःतकाः बल्‍लाःगु ल्‍हातं मिश्रं पित हयादीपिं थः मनूतय्‌त व थःगु सर्बययात नाश यानादी मते। ");
INSERT INTO new_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","थः च्‍यःपिं अब्राहाम, इसहाक व याकूबयात लुमंकादिसँ। थुपिं मनूतय्‌गु जिराहा, मभिंगु ज्‍या व पापपाखे स्‍वयादी मते, ");
INSERT INTO new_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","मखुसा मिश्रीतय्‌सं थथे खँ ल्‍हाइ, ‘परमप्रभुं बचं बियादीगु देशय् इमित यंके मफुगुलिं अले इमित यय्‌कामदीगुलिं वय्‌कलं इमित मरुभूमिइ स्‍यायेत यंकादिल।’ ");
INSERT INTO new_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","अय्‌नं थःगु तःधंगु बलं व थःगु चकंगु लप्‍पूं पित हयादीपिं थुपिं मनूत छिगु हे प्रजा व छिगु थःगु हे सर्बय खः।” ");
INSERT INTO new_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","उबलय् परमप्रभुं जितः धयादिल, “न्‍हापायागु थें कतां कियाः निपा मेगु ल्‍वहं पौ दय्‌कि, अले पहाडय् जिथाय् थाहां वा। छगः सिँयागु सनू नं दय्‌कि। ");
INSERT INTO new_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","उपिं पौलय्‌ छं तछ्याःगु न्‍हापायागु पौलय्‌ च्‍वयातःगु खँ हे जिं च्‍वयाबी। अनंलि छं उपिं पौयात सनूइ तयाब्‍यु।” ");
INSERT INTO new_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","अथे जुयाः जिं खयःसिँयागु छगः सनू दय्‌का, अले चानाः न्‍हापायागु निपा ल्‍वहं पौ थें ल्‍वहंयागु निपा पौ दय्‌का। अले थःगु ल्‍हातय् उपिं पौ ज्‍वनाः पहाडय् थाहां वना। ");
INSERT INTO new_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","परमप्रभुं छिपिं मुनाच्‍वंबलय् पहाडय् मिया दथुं छिमित बियादीगु झिगू आज्ञा न्‍हापा थें उपिं पौलय् च्‍वयाः जितः बियादिल। ");
INSERT INTO new_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","अनंलि जि पहाडं कुहां वया, अले परमप्रभुं जितः आज्ञा बियादीगु थें जिं दय्‌कागु सनूइ उपिं पौ तयाबिया। उपिं उकी हे दु। ");
INSERT INTO new_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(इस्राएलीत याकानीतय्‌गु तुंनिसें मोसेरा तक यात्रा यात। अन हारून सित, अले वयात अन हे थुनाबिल। वया काय् एलाजारं वयागु थासय् पुजाहारीया ज्‍या यात। ");
INSERT INTO new_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","अनं इस्राएलीत गुदगुदा तक न्‍यासि वन, अले गुदगुदां यक्‍व खुसिचात व बुँगाःचात दुगु योतबाताय् वल। ");
INSERT INTO new_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","थौं तक जुया वयाच्‍वंगु थें परमप्रभुयागु बाचाया सनू क्‍वबीत परमप्रभुया न्‍ह्यःने च्‍वनाः वय्‌कःयागु सेवा यायेत अले वय्‌कःया नामय् सुवाः बीत उबलय् परमप्रभुं लेवी कुलयात ल्‍ययादिल। ");
INSERT INTO new_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","अथे जूगुलिं परमप्रभुं लेवीया सन्‍तानतय्‌त मेगु इस्राएली कुलतय्‌त थें ब्‍व व सर्बय बियामदी। परमप्रभु छिमि परमेश्‍वरं इमित धयादीगु थें परमप्रभु हे इमिगु सर्बय खः।) ");
INSERT INTO new_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","न्‍हापा थें जि पहाडय् पिइन्‍हु व पिइचा तक च्‍वना। अले थ्‍वपालय् नं परमप्रभुं जिगु बिन्‍ति न्‍यनादिल अले छिमित नाश यायेगु इच्‍छा यानामदिल। ");
INSERT INTO new_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","परमप्रभुं जितः धयादिल, “मनूतय् न्‍ह्यलुवाः जुयाः इमित लँपु क्‍यँ। जिं इमि पुर्खालिसें बी धकाः पाफयाः बचं बियागु देशय् दुहां वनाः इमिसं अन अधिकार यायेमा।” ");
INSERT INTO new_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","हे इस्राएल, परमप्रभु छिमि परमेश्‍वरं छिमिसं छु याःगु यय्‌कादी? छिमिसं वय्‌कःया ग्‍याःभय काःगु, वय्‌कःया लँपुइ वंगु व वय्‌कःयात माया याःगु अले दुनुगलंनिसें व थःगु प्राणं वय्‌कःयागु सेवा याःगु यय्‌कादी ");
INSERT INTO new_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","अले हानं जिं थौं छिमिगु हे भिंया लागिं बियाच्‍वनागु परमप्रभुया आज्ञा व विधि मानय् या। ");
INSERT INTO new_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","आकाश व दकलय् ततःजागु स्‍वर्ग नं, पृथ्‍वी व उकी दुगु फुक्‍कं परमप्रभु छिमि परमेश्‍वरयागु हे खः। ");
INSERT INTO new_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","अय्‌नं छिमि पुर्खातय्‌त परमेश्‍वरं माया यानाः ल्‍ययादिल। अथे जुयाः मेगु फुक्‍क जातितय् दथुं वय्‌कलं छिपिं, इमि सन्‍तानतय्‌त ल्‍ययादिल। थथे छिपिं थौं तक नं वय्‌कःयागु ल्‍यःपिं मनूत खः। ");
INSERT INTO new_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","अथे जुयाः थथःगु मन हीकि, आवंलि जिराहा जुइ मते। ");
INSERT INTO new_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","परमप्रभु छिमि परमेश्‍वर हे ईश्‍वरतय्‌ परमेश्‍वर व प्रभुतय् नं प्रभु, अले दकलय् तःधंम्‍ह परमेश्‍वर खः। वय्‌कः ख्‍वाः स्‍वयाः ज्‍या यानामदीम्‍ह, घुस नयाःमदिम्‍ह, तःधंम्‍ह व भय कायेमाःम्‍ह परमेश्‍वर खः। ");
INSERT INTO new_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","वय्‌कलं मांबौ मदुपिं मस्‍त व भाःत सी धुंकूपिन्‍त रक्षा यानादी अले परदेशीतय्‌त माया यानाः नयेगु नसा व वसः बियादी। ");
INSERT INTO new_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","छिमिसं नं परदेशीतय्‌त माया यायेमाः, छाय्‌धाःसा मिश्र देशय् छिपिं नं परदेशी जुयाच्‍वंगु खः। ");
INSERT INTO new_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","थः परमप्रभु परमेश्‍वरया ग्‍याःभय का अले वय्‌कःया सेवा या। वय्‌कः नाप नापं जु, अले वय्‌कःया नामय् जक पाफयेगु या। ");
INSERT INTO new_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","वय्‌कः हे च्‍वछाये बहःम्‍ह छिमि परमेश्‍वर खः। वय्‌कलं छिमिगु निंतिं छिमिसं खंक हे तःधंगु व ग्‍यानपुसे च्‍वंगु अजू चाइपुगु ज्‍या यानादिल। ");
INSERT INTO new_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","छिमि पुर्खा ला न्‍हयेम्‍ह (७०) जक मिश्रय् वंगु खः, अय्‌नं आः परमप्रभु छिमि परमेश्‍वरं छिमित आकाशया नगु थें अल्‍याख यानादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","परमप्रभु थः परमेश्‍वरयात माया या, अले वय्‌कःया उपदेश, आज्ञा, विधि व नियम न्‍ह्याबलें मानय् या। ");
INSERT INTO new_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","थौं छिमिसं लुमंकि, छिमि मस्‍तय्‌सं परमप्रभु छिमि परमेश्‍वरया अनुशासन, वय्‌कःया महिमा, बल्‍लाःगु ल्‍हाः व चक्‍कंगु लप्‍पू, ");
INSERT INTO new_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","मिश्रया जुजु फारो व वया देश न्‍यंकभनं वय्‌कलं क्‍यनादीगु चिं व अजू चाइपुगु ज्‍या, ");
INSERT INTO new_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","अले मिश्रया सेना, सल व रथतय्‌सं छिमित ल्‍यू वयाच्‍वंबलय् परमप्रभुं गय् यानाः लाल समुद्रया लखं इमित त्‍वःपुयाः न्‍ह्याबलेंया लागि नाश यानादिल व फुक्‍क खंगु व अनुभव याःगु मदु। ");
INSERT INTO new_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","थ्‍व थासय् थ्‍यंकः मवतले मरुभूमिइ वय्‌कलं छु छु यानादिल व छिमि मचाखाचातय्‌सं खंगु मदु। ");
INSERT INTO new_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","रूबेनी एलीआबया काय्‌पिं दातान व अबीरामयात इमि छेँजःपिं, पाल व इमि दक्‍व पशुनापं गुकथं पृथ्‍वीं थःगु म्‍हुतु चाय्‌काः सकल इस्राएलीतय् न्‍ह्यःने हे घुतुका छ्वःगु खः व नं छिमि मचाखाचातय्‌सं खंगु मदु। ");
INSERT INTO new_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","छिमिसं धाःसा थःगु हे मिखां परमप्रभुं यानादीगु थुपिं फुक्‍क तःधंगु ज्‍या खंगु दु। ");
INSERT INTO new_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","अथे जुयाः छिमिसं जिं थौं कनाच्‍वनागु फुक्‍क आज्ञा मानय् या। अले छिपिं बल्‍लानाः यर्दन छिनाः अधिकार यायेत वनाच्‍वंगु देशयात छिमिसं थःगु याये फइ। ");
INSERT INTO new_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","अले परमप्रभुं छिमि पुर्खालिसें इमित व इमि सन्‍तानतय्‌त बी धकाः पाफयादीगु दुरु व कस्‍ति बाः वयाच्‍वंगु देशय् छिपिं ताःई तक म्‍वानाच्‍वने फइ। ");
INSERT INTO new_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","छिमिसं त्‍याकाकाये त्‍यंगु देश छिपिं पिहां वःगु मिश्र देश थें मच्‍वं। अन छिमिसं पुसा ह्वलाः वाउँचाया क्‍यबय् थें तुतिं लः तइगु। ");
INSERT INTO new_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","छिपिं त्‍याका कायेत यर्दनया उखे वनाच्‍वंगु देश धाःसा पहाड व ब्‍यासितय्‌गु देश खः। अन आकाशया लखं बँ प्‍याकी। ");
INSERT INTO new_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","व देशयात परमप्रभु परमेश्‍वरं हे बिचाःसंचाः यानादी। दँया शुरुंनिसें लिपाथ्‍यंक हे परमप्रभु छिमि परमेश्‍वरं उकियात मदिक्‍क हे स्‍वयाच्‍वनादी। ");
INSERT INTO new_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","अथे जुयाः परमप्रभु छिमि परमेश्‍वरयात माया या, अले दुनुगलंनिसें व प्राणंनिसें वय्‌कःया सेवा या धइगु जिं छिमित बियागु आज्ञायात बांलाक न्‍यन धाःसा, ");
INSERT INTO new_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","जिं छिमिगु देशय् न्‍हापांगु अले लिपांगु वा पाय्‌छिगु इलय् छ्वयाहये अले छिमिसं थःगु अन्‍न, न्‍हूगु दाखमद्य व जैतूनया चिकं मुंके फइ। ");
INSERT INTO new_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","जिं छिमि पशुतय्‌गु लागिं ख्‍यलय् घाँय् बुइकाबी। छिमिसं प्‍वाः जाय्‌क नइ व लुधनी। ");
INSERT INTO new_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","होश या! मखुसा छिमिसं धोखा नयाः मेपिं द्यःतय्‌गु ल्‍यू वनाः इमित पुजा यानाः भागि याइ। ");
INSERT INTO new_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","अले परमप्रभु छिपिं खनाः तंचायाः बुँनं थःगु बाली मबीमा धकाः वय्‌कलं आकाशं वइगु वा दिकादी, अले परमप्रभुं छिमित बियादीगु भिंगु देशं छिपिं याकनं हे नाश जुयावनी। ");
INSERT INTO new_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","अथे जुयाः छिमिसं जिगु थुपिं वचन थःगु नुगलय् व मतिइ ति अले थथःगु ल्‍हातय् व कपालय् चिंकथं चिनाब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","छिपिं थःगु छेँय् च्‍वनीबलय्, लँय् जुइबलय्, ग्‍वतुलीबलय् व दनीबलय् थुमिगु बारे खँल्‍हाबल्‍हा यानाः थःकाय् म्‍ह्याय्‌पिन्‍त स्‍यनेगु या। ");
INSERT INTO new_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","उपिं आज्ञा थथःगु छेँया लुखा दुवालय् व मूध्‍वाखाय् च्‍वयाः ति। ");
INSERT INTO new_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","अले परमप्रभुं छिमि पुर्खालिसें बी धकाः पाफयादीगु देशय् छिपिं व छिमि मचाखाचात पृथ्‍वीया आकाश दत्तले म्‍वानाच्‍वनी। ");
INSERT INTO new_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","छिमिसं जिं धयाच्‍वनागु आज्ञा बांलाक मानय् यानाः पूवंकल, थः परमप्रभु परमेश्‍वरयात माया यात, वय्‌कःया फुक्‍क लँपुइ वन अले वय्‌कःयात मत्‍वःतल धाःसा, ");
INSERT INTO new_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","परमप्रभुं उपिं फुक्‍क जातितय्‌त छिमिगु न्‍ह्यःनं पितिनाछ्वयादी। अले छिपिं स्‍वयाः ततःधंगु व बल्‍लाःगु जातितय्‌त छिमिसं बुकी अले इमिगु देश अधिकार याइ। ");
INSERT INTO new_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","छिमिसं पलाः तःक्‍व थाय् छिमिगु हे जुइ। दच्‍छिनय् नेगेवया मरुभूमिनिसें उत्तरय् लेबनान तक अले पुर्बय् यूफ्रेटिस खुसिनिसें पच्‍छिमय् भूमध्‍यसागर तक हे छिमिगु सिमाना जुइ। ");
INSERT INTO new_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","छिमिगु न्‍ह्यःने सुं नं दनाच्‍वने फइ मखु। परमप्रभु छिमि परमेश्‍वरं बचं बियादीगुकथं छिपिं वंगु दक्‍व थासय्‌यापिं मनूतय्‌गु नुगलय् छिमिगु ग्‍याःभय तयादी। ");
INSERT INTO new_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","स्‍व, जिं थौं छिमिगु न्‍ह्यःने सुवाः व सराः तयाबी। ");
INSERT INTO new_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","छिमिसं थौं जिं बियाच्‍वनागु आज्ञा न्‍यन धाःसा छिमित सुवाः दइ। ");
INSERT INTO new_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","परमप्रभु छिमि परमेश्‍वरयागु आज्ञा मानय् मयासें छिमिसं मस्‍यूपिं मेपिं द्यःतय्‌गु ल्‍यू वनाः जिं थौं आज्ञा बियागु लँपुं फस्‍वयावन धाःसा छिमित सराः लाइ। ");
INSERT INTO new_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","परमप्रभु छिमि परमेश्‍वरं छिपिं दुहां वनीगु देशय् छिमित हयादीबलय् छिमिसं सुवाः धाःसा गीरीज्‍जीम पर्वतं, सराः धाःसा एबाल पर्वतं न्‍यंकि। ");
INSERT INTO new_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","थुपिं निगू पर्वत यर्दनया उखे, मू लँया पच्‍छिमपाखे, सूर्य बिनावनीगुपाखे, अराबाय् च्‍वनिपिं कनानीतय्‌गु देशय् गिलगालया न्‍ह्यःने मोरेया स्‍वसिमायागु लिक्‍क दु धकाः छिमिसं सी हे स्‍यू। ");
INSERT INTO new_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","छिपिं परमप्रभु छिमि परमेश्‍वरं बियादीगु देश त्‍याका कायेत यर्दन खुसि छिनावने त्‍यंगु दु। छिपिं व थाय्‌यात त्‍याकाः अन च्‍वनाच्‍वनीबलय् ");
INSERT INTO new_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","जिं थौं छिमिगु न्‍ह्यःने तयागु थुपिं फुक्‍क विधि व नियम बांलाक मानय् या। ");
INSERT INTO new_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","परमप्रभु छिमि पुर्खातय् परमेश्‍वरं छिमित अधिकार यायेत बियादीगु देशय् छिपिं म्‍वानाच्‍वंतले बांलाक मानय् यायेमाःगु विधि व नियम थुपिं हे खः। ");
INSERT INTO new_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","छिमिसं व देश त्‍याकाकाइबलय् अनयापिं मनूतय्‌सं तःजाःगु डाँडाय्‌, ततःमागु सिमा क्‍वय् व पर्वत पर्वतय् थः द्यःतय्‌त पुजा याइगु थाय् छिमिसं भज्‍यंक स्‍यंकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","इमिगु वेदी थुनाब्‍यु अले पुजा याइगु ल्‍वहं तछ्यानाब्‍यु। इमि अशेरा द्यःमय्‌जुयागु थां मिइ छ्वयेकाछ्व। इमि द्यःतय् मूर्ति क्‍वथलाब्‍यु अले पुजा याइगु थासं इमिगु नां हे मदय्‌काछ्व। ");
INSERT INTO new_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","छिमिसं परमप्रभु छिमि परमेश्‍वरयागु आराधना इमिसं इमि द्यःयात आराधना याःथें याये मते। ");
INSERT INTO new_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","तर परमप्रभु छिमि परमेश्‍वरं थःगु नां तयेत छिमि खलःतय् दथुं गुगु थाय् ल्‍ययादी व थाय्‌यात मा। व थासय् हे छिपिं वनेगु या। ");
INSERT INTO new_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","अन हे छिमिसं थःगु होमबलि, बलित, झिब्‍वय् छब्‍व, अले पवित्रगु देछा, भाकलया देछा व थः यःछि बलि अले सा द्वहं, फैच्‍वलय्‌या न्‍हापां बूम्‍ह मचा यंकेगु या। ");
INSERT INTO new_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","अले अन हे छिमिसं व छिमि छेँजःपिन्‍सं परमप्रभु छिमि परमेश्‍वरया न्‍ह्यःने नयेत्‍वनेगु याइ। छिमिसं यायेगु फुक्‍क ज्‍याय् लसता हनी, छाय्‌धाःसा परमप्रभु छिमि परमेश्‍वरं छिमित सुवाः बियादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","व ई वइबलय् छिमिसं याना वयाच्‍वंगु थें याये मते, आः तक छिमिसं थः यःथें याना वयाच्‍वंगु खः, ");
INSERT INTO new_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","छाय्‌धाःसा छिपिं याउँक च्‍वनेगु थाय् व परमप्रभु परमेश्‍वरं छिमित बियादीत्‍यंगु सर्बयलय् आः तक नं मथ्‍यंनि। ");
INSERT INTO new_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","छिपिं यर्दन छिनाः परमप्रभु छिमि परमेश्‍वरं छिमित सर्बयकथं बियादीगु देशयात त्‍याकाः अन न्‍ह्याबलेंया निंतिं च्‍वनी। अले वय्‌कलं छिमित प्‍यखेरं च्‍वंपिं शत्रुतपाखें बचय् यानाः आराम बियादी। ");
INSERT INTO new_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","अन हे परमप्रभु छिमि परमेश्‍वरं थःगु नां तयेत ल्‍ययादीगु थासय् छिमित जिं आज्ञा बियागु छिमिगु होमबलि, मेमेगु बलित, झिब्‍वय् छब्‍व, थः यःछि बलि अले छिमिसं परमेश्‍वरयात बी धकाः भाकल याःगु भिंगु भिंगु देछा हजि। ");
INSERT INTO new_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","अन हे छिमि काय् म्‍ह्याय्‌पिन्‍सं, च्‍यःभ्‍वातिंत व छिमि शहरय् च्‍वनाच्‍वंपिं थःगु ब्‍व व सर्बय मदुपिं लेवीया सन्‍तानतय्‌सं परमप्रभु छिमि परमेश्‍वरयागु न्‍ह्यःने लसता हँ। ");
INSERT INTO new_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","होश यानाच्‍वँ! छिमिसं थःगु होमबलि छिमिसं खंगु न्‍ह्याथाय् नं छाये मते। ");
INSERT INTO new_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","परमप्रभुं छिमि कुलतपाखें ल्‍ययादीगु थासय् जक छा, अले जिं छिमित आज्ञा बियागु फुक्‍क ज्‍या अन हे या। ");
INSERT INTO new_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","अथेसां छिमिसं थथःगु शहरय् थःत यःछि व परमप्रभु थः परमेश्‍वरं बियादीगु सुवाःकथं हरिण व चल्‍ला थें थः पशु नं स्‍यानाः नयेफु। शुद्ध व अशुद्ध न्‍ह्याम्‍हय्‌सिनं नयेफु। ");
INSERT INTO new_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","हि धाःसा छिमिसं नये मते। उकियात लः थें बँय् प्‍वंकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","छिमिसं छिमिगु अन्‍न, न्‍हूगु दाखमद्य, जैतूनया चिकंया झिब्‍वय् छब्‍व वा सा द्वहं, फैच्‍वलय्‌या न्‍हापां बूम्‍ह पशु वा भाकलयागु न्‍ह्यागु नं देछा, थः यःछिं बलि वा मेगु देछा छिमिगु थथःगु शहर दुने नये मते। ");
INSERT INTO new_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","बरु छिपिं, छिमि काय्‌म्‍ह्याय्‌पिं, छिमि च्‍यःभ्‍वातिंत अले छिमिगु शहरय् च्‍वनाच्‍वंपिं लेवीया सन्‍तानत नापं वय्‌कलं ल्‍ययादीगु थासय् नयेगु या। परमप्रभु छिमि परमेश्‍वरया न्‍ह्यःने छिमिसं याइगु थःपिनिगु फुक्‍क ज्‍याय् लसता हँ। ");
INSERT INTO new_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","थःगु देशय् छिपिं म्‍वातले लेवीया सन्‍तानतय्‌त बांलाक बिचाः या। ");
INSERT INTO new_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","परमप्रभु छिमि परमेश्‍वरं थःगु बचंकथं छिमिगु देश तःकू यानाबी धुंकाः छिमित ला नये मास्‍ति वःसा थःत गुलि नये मास्‍ति व उलि न। ");
INSERT INTO new_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","परमप्रभु छिमि परमेश्‍वरं थःगु नां तयेत ल्‍ययादीगु थाय् छिमिगु छेँनं तापाः जूसा, परमप्रभु परमेश्‍वरं छिमित बियादीगु सा द्वहं वा फैच्‍वलय् जिं बियागु आज्ञाकथं स्‍यानाः थःगु शहरय् थःत गुलि यः उलि नयेफु। ");
INSERT INTO new_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","छिमिसं हरिण व चल्‍लाया ला न थें हे उपिं न। शुद्ध व अशुद्ध न्‍ह्याम्‍हय्‌सिनं व नयेफु। ");
INSERT INTO new_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","तर हि गुबलें नये मते छाय्‌धाःसा हि जीवन खः, अले छिमिसं ला नापं जीवन नये मते। ");
INSERT INTO new_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","छिमिसं हि नये मते। उकियात लःयात थें बँय् प्‍वंकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","छिमिसं उकियात नये मते, अले छिमिसं परमप्रभुया मिखाय् भिं ताःगु ज्‍या याःगुलिं छिपिं व छिमि लिपायापिं सन्‍तानतय्‌गु भिं जुइमा। ");
INSERT INTO new_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","अय्‌नं छिमिसं देछा व भाकलयागु देछा कयाः परमप्रभुं ल्‍ययादीगु थासय् हुँ। ");
INSERT INTO new_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","छिमिसं थःगु होमबलिया ला व हि परमप्रभु छिमि परमेश्‍वरयागु वेदीइ छा। बां ब्‍यूगुया हि परमप्रभु छिमि परमेश्‍वरयागु वेदीया लिकसं प्‍वंकाबीमाः, ला धाःसा छिमिसं नयेफु। ");
INSERT INTO new_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","जिं छिमित बियागु आज्ञा बांलाक न्‍यँ, अले छिमिसं परमप्रभु छिमि परमेश्‍वरयात यःगु ज्‍या याःगुलिं छिमिगु व छिमि सन्‍तानतय्‌गु भिं जुइ। ");
INSERT INTO new_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","छिमिसं लिनाछ्वये त्‍यंपिं जातितय्‌त परमप्रभु छिमि परमेश्‍वरं छिमिगु न्‍ह्यःनेनं नाश यानादी। अथे जूसां छिपिं इमिगु देशय् च्‍वनीबलय् ");
INSERT INTO new_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","होश यानाच्‍वँ! मखुसा इपिं नाश जुइ धुंकाः छिपिं नं इपिं थें जालय् तक्‍यनी। “इमिसं थः द्यःतय्‌त पुजा याःगु थें जिमिसं नं याये धकाः धयाः इमि द्यःतय्‌गु बारे न्‍यनेकने याये मते।” ");
INSERT INTO new_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","छिमिसं परमप्रभु थः परमेश्‍वरया आराधना इमिसं इमि द्यःयात आराधना याःथें याये मते, छाय्‌धाःसा इमि द्यःतय्‌त पुजा याइबलय् इमिसं परमप्रभुयात मयःगु फुक्‍क कथंयागु घच्‍चाइपुसे च्‍वंगु ज्‍या याइ। इमिसं थःकाय् म्‍ह्याय्‌पिन्‍त तक नं थः द्यःतय् लागिं मिइ तयेगु याः। ");
INSERT INTO new_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","जिं छु छु आज्ञा बियागु दु उपिं फुक्‍क बांलाक मानय् या। उकी छुं तने नं मते लिकाये नं मते। ");
INSERT INTO new_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","छिमिगु दथुइ सुं अगमवक्ता वा म्‍हगसय् म्‍हनीम्‍ह मनू वयाः छिमित छुं चिं वा अजू चाइपुगु ज्‍या जुइगु खँ कन धाःसा ");
INSERT INTO new_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","अले वं धाःगु चिं व अजू चायापुगु ज्‍या जुइ धुंकाः “छिमिसं म्‍हमस्‍यूपिं द्यःतय्‌गु ल्‍यू वनाः इमित पुजा याये नु” धकाः वं धाल धाःसा ");
INSERT INTO new_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","छिमिसं व अगमवक्ता वा म्‍हगसय् म्‍हनीम्‍ह मनूयागु खँ न्‍यने मते। व ला परमप्रभु छिमि परमेश्‍वरं छिमिसं थःगु प्राणं वय्‌कःयात माया या कि मया धकाः मन स्‍वयादीगु खः। ");
INSERT INTO new_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","छिपिं परमप्रभु छिमि परमेश्‍वरयागु जक ल्‍यूल्‍यू वनेमाः। वय्‌कःया भय कायेमाः। वय्‌कःया खँ न्‍यँ, वय्‌कःया आज्ञा मानय् या, वय्‌कःयात सेवा या, अले वय्‌कःयात त्‍वःते मते। ");
INSERT INTO new_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","व अगमवक्ता वा म्‍हगसय्‌या खँ कनीम्‍ह मनूयात स्‍याना हे छ्वयेमाः। छाय्‌धाःसा वं छिमित दासत्‍वया देश मिश्रं पित हयादीम्‍ह परमप्रभु छिमि परमेश्‍वरं आज्ञा बियादीगु लँपुपाखें हीकाः वय्‌कःया विरोध यायेगु स्‍यनेत कुतः यात। छिमिसं थज्‍याःगु मभिंगु ज्‍या छिमिगु दथुं चीकाः छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","छिमि थः हे दाजुकिजा, काय्‌म्‍ह्याय्, कलाः वा मिलय् जूम्‍ह पासां “छिमिसं व छिमि पुर्खातय्‌सं म्‍हमस्‍यूपिं द्यःतय्‌त पुजा याये नु” धकाः छिमित हेय्‌कल धाःसा ");
INSERT INTO new_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","इपिं छिमिगु जःखः च्‍वनिपिं मनूतय् द्यःत जुइमा वा तापापिं जुइमा अले देशया छगू कुन्‍चाय्‌निसें मेगु कुन्‍चा तकयापिं जुइमा ");
INSERT INTO new_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","व हेय्‌कूम्‍हय्‌सिगु खँ न्‍यने मते! छिमिसं वयात दया याये मते, छिमिसं वयात त्‍वःते मते वा वयात रक्षा याये मते! ");
INSERT INTO new_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","व मनूयात स्‍याना हे छ्व! वयात स्‍यायेत वयागु खँ न्‍यंम्‍ह मनुखं दकलय् न्‍हापा ल्‍वहँतं कय्‌केमाः। अले लिपा सकलें मनूतय्‌सं ल्‍वहँतं कय्‌केमाः। ");
INSERT INTO new_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","वयात ल्‍वहँतं कय्‌काः स्‍यायेमाः, छाय्‌धाःसा वं छिमित दासत्‍वया देश मिश्रं पित हयादीम्‍ह परमप्रभु छिमि परमेश्‍वरपाखें हीकाः मेखेपाखे यंकेगु कुतः यात। ");
INSERT INTO new_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","थथे जूगुलिं सकल इस्राएलीत थ्‍व खँ न्‍यनाः ग्‍याइ, अले थज्‍याःगु मभिंगु ज्‍या छिमिगु दथुइ गुबलें याइ मखु। ");
INSERT INTO new_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","परमप्रभु छिमि परमेश्‍वरं छिमित च्‍वनेत बियादीगु गुगुं शहरय् ");
INSERT INTO new_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","छिमिगु दथुं मभिंपिं पिहां वयाः थःगु शहरयापिं मनूतय्‌त “इमिसं न्‍हापा म्‍हमस्‍यूपिं द्यःतय्‌त पुजा याये नु” धकाः हेय्‌कूगु दु धइगु खँ छिमिसं न्‍यनेदत धाःसा ");
INSERT INTO new_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","छिमिसं बांलाक न्‍यनेकने या, उकियात दुवालाः स्‍व। अले अज्‍याःगु घच्‍चाइपुस्‍से च्‍वंगु ज्‍या धात्‍थें जूगु खःसा अले दसि लुल धाःसा ");
INSERT INTO new_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","छिमिसं व शहरय् च्‍वंपिं मनूतय्‌त तरवारं स्‍यानाछ्व, अले व शहरयात नाश यानाब्‍यु। अन दुपिं सा द्वहं नापं फुक्‍कसित तरवारं स्‍यानाछ्व। ");
INSERT INTO new_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","अनयागु फुक्‍क मालसामान शहरया लाछिइ मुंकाः व शहर व मालसामानयात छ्वय्‌काब्‍यु। परमप्रभु छिमि परमेश्‍वरयागु निंतिं व होमबलि थें जुइ। व शहर न्‍ह्याबलेंया लागि भस्‍म जुया हे च्‍वनेमाः। उकियात हानं दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","थथे देछाय्‌ मज्‍यूगु छुं नं यंके मते। थथे याःसा परमप्रभुया तं क्‍वलानाः वय्‌कलं छिमित दया माया यानाः छिमि पुर्खालिसें पाःफयादीगु थें छिमिगु ल्‍याः अप्‍वः दय्‌काबी। ");
INSERT INTO new_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","परमेश्‍वरयागु वचन न्‍यनाः थौं जिं धयाकथं वय्‌कःया फुक्‍क आज्ञा मानय् यात वा परमप्रभु छिमि परमेश्‍वरयात यःगु ज्‍याखँयात धाःसा थ्‍व जुइ। ");
INSERT INTO new_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","छिपिं परमप्रभु छिमि परमेश्‍वरया मनूत खः। सिनावंम्‍ह मनूया लागि दुखं च्‍वनीबलय् छिमिसं थःगु म्‍हय् घाः याये मते अथवा मेपिंन्‍सं याःथें छ्यंया न्‍ह्यःने च्‍वंगु सँ खाये मते। ");
INSERT INTO new_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","छाय्‌धाःसा छिपिं परमप्रभु छिमि परमेश्‍वरया लागिं छगू पवित्र जाति खः। परमप्रभुं पृथ्‍वीइ दुपिं जातितपाखें छिमित थः विशेष मनूत, मू वंगु सम्‍पत्ति जुइत ल्‍ययादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","छिमिसं घच्‍चाइपुगु छुं नये मते। ");
INSERT INTO new_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","छिमिसं नये ज्‍यूपिं पशुत थुपिं हे खः – द्वहं, फै, दुगु, ");
INSERT INTO new_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","चल्‍ला, धलयसा, हरिण, चिधिकःपिं चल्‍ला, गुँ दुगुचा, साबर दुगुचा, याःसा व गुँफै। ");
INSERT INTO new_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","पशुत मध्‍ये तुतिख्‍वः बाःपिं व लिन्‍ह्ययाः नइपिनिगु ला छिमिसं नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","अय्‌नं तुतिख्‍वः मबाःसां लिन्‍ह्ययाः नइपिं थुपिं नये मते – ऊँट, खराचा व शापान। थुपिं लिन्‍ह्यया नइपिं खःसां, थुपिं छिमिगु लागि अशुद्ध खः। ");
INSERT INTO new_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","फा नं अशुद्ध खः, छाय्‌धाःसा वयागु तुतिख्‍वः ला बाः अय्‌सां वं लिन्‍ह्ययाः मनः। छिमिसं इमिगु ला नये मते, इमिगु सीम्‍ह नं थी मते। ");
INSERT INTO new_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","लखय् च्‍वनिपिं पपू व बिखू दुपिं जन्‍तुत धाक्‍व छिमिसं नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","पपू व बिखू मदुपिं छिमिसं नये मते। उपिं छिमिगु लागिं अशुद्धपिं खः। ");
INSERT INTO new_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","छिमिसं शुद्धपिं झंगःत नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","अय्‌नं छिमिसं थुपिं नये मते – तःधिकःम्‍ह इमा, गिद्ध, हाकुम्‍ह गिद्ध, ");
INSERT INTO new_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ह्याउँम्‍ह बाय्‌चा, हाकुम्‍ह बाय्‌चा, थीथी कथंयापिं सतांचा, ");
INSERT INTO new_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","फुक्‍क कथंयापिं सँक्‍वः, ");
INSERT INTO new_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","तसक्‍कं हालिम्‍ह न्‍हिकांझंगः, हुचिल, समुद्री झंगः, फुक्‍क कथंयापिं बाज ");
INSERT INTO new_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","चिधिकःम्‍ह न्‍हिकांझंगः, तःधिकःम्‍ह न्‍हिकांझंगः व तुयुम्‍ह न्‍हिकांझंगः ");
INSERT INTO new_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","सीम्‍ह नइम्‍ह गिद्ध, हाडगील, लः क्‍वः, ");
INSERT INTO new_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","सारस, फुक्‍क कथंयापिं ब्‍वह झंगः, कल्‍कि झंगः व चिकंलापा। ");
INSERT INTO new_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","अले पपू दुपिं फुक्‍क कीचात छिमिगु लागि अशुद्धपिं खः उपिं नये मते। ");
INSERT INTO new_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","अय्‌नं पपू दुपिं दक्‍व शुद्धपिं छिमिसं नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","थःगु कालं सीम्‍ह पशुयात छिमिसं नये मते, छिमिसं छिमिगु शहरय् च्‍वंम्‍ह सुं परदेशीयात व नयेत बी ज्‍यू वा सुं मेपिं परदेशीतय्‌गु ल्‍हातय् मी फु। छिपिं धाःसा परमप्रभु छिमि परमेश्‍वरया लागिं छगू पवित्र जाति खः। च्‍वलय्‌या मचायात वया मांया दुरुइ दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","दँय्‌दसं बुँइ सःगु फलया झिब्‍वय् छब्‍व अलग तयाति। ");
INSERT INTO new_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","परमप्रभुं थःगु नां तयेत ल्‍ययादीगु थासय् जक थःगु अन्‍न, दाखमद्य, जैतून चिकंया झिब्‍वय् छब्‍व व थः सा द्वहं व फैच्‍वलय्‌या न्‍हापां बूपिं मस्‍तय्‌त वय्‌कःया न्‍ह्यःने नयेगु या। छिमिसं वय्‌कःयात न्‍ह्याबलें हनाबना तयेगु सय्‌केत थथे यायेगु या। ");
INSERT INTO new_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","परमप्रभु छिमि परमेश्‍वरं थःगु नां तयेत ल्‍ययादीगु थाय् छिमिगु थासं तापानाः छिमिसं वय्‌कलं सुवाः बियादीबलय् झिब्‍वय् छब्‍व यंके मफुत धाःसा ");
INSERT INTO new_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","थःगु झिब्‍वय् छब्‍व वहः कयाः म्‍यु, अले व वहः थःगु ल्‍हातय् ज्‍वनाः परमप्रभु छिमि परमेश्‍वरं ल्‍ययादीगु थासय् हुँ। ");
INSERT INTO new_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","थःत यःकथं सा द्वहं, फैच्‍वलय्, दाखमद्य वा थ्‍वँ, न्‍ह्यागु हे जूसां व हे वहलं न्‍यानाः थः छेँजःपिं नापं छिमिसं परमप्रभु छिमि परमेश्‍वरया न्‍ह्यःने नयाः लसता हँ। ");
INSERT INTO new_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","छिमिगु शहरय् च्‍वनिपिं लेवीया सन्‍तानतय्‌त बांलाक बिचाः या, छाय्‌धाःसा इमिके थःगु ब्‍वः व सर्बय मदु। ");
INSERT INTO new_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","स्‍वदँ स्‍वदँ फुइबलय् छिमिसं व दँया बालियागु फुक्‍क झिब्‍वय् छब्‍व शहरया धुकुतिइ तयाब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","अले छुं ब्‍व व सर्बय मदुपिं लेवीया सन्‍तानत, परदेशीत, मांबौ मदुपिं वा भाःत सी धुंकूपिं वयाः प्‍वाजाय्‌क नयेमा, अले परमप्रभु छिमि परमेश्‍वरं छिमिगु फुक्‍क ज्‍याय् छिमित सुवाः बियादीमा। ");
INSERT INTO new_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","न्‍हय्‌दँ न्‍हय्‌दँ फुइबलय् छिमिसं त्‍यासा त्‍वःताबीमाः। ");
INSERT INTO new_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","व थुकथं यायेमाः, सुं मनुखं मेम्‍ह इस्राएलीयात त्‍यासा ब्‍यूगु दुसा वं उकियात त्‍वःताबीमाः। वं त्‍यासा लित कायेगु कुतः मयायेमाः। छाय्‌धाःसा थ्‍व दँय् त्‍यासा त्‍वःताब्‍यु धकाः परमेश्‍वरं धयादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","परदेशीयाके धाःसा कर यानाः काये फु अय्‌नं दाजुकिजापिन्‍त बियागु त्‍यासा लित मकासें त्‍वःताबीमाः। ");
INSERT INTO new_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","अथे जूसाः छिमिगु दथुइ सुं नये मखंपिं जुइ मखु छाय्‌धाःसा परमप्रभु छिमि परमेश्‍वरं छिमित सर्बयकथं त्‍यासा कायेत बियादीत्‍यंगु देशय् सुवाः बियादी। ");
INSERT INTO new_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","छिमिसं छिमि परमप्रभुयागु वचन बांलाक न्‍यन धाःसा अले जिं छिमित कनेगु आज्ञा बांलाक मानय् यात धाःसा ");
INSERT INTO new_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","वय्‌कःया थःगु बचंकथं परमप्रभु छिमि परमेश्‍वरं छिमित सुवाः बियादी अले छिमिसं यक्‍व जातितय्‌त त्‍यासाबी। छिमिसं धाःसा त्‍यासाकाये मालि मखु। अले छिमिसं यक्‍व जातितय्‌त शासन याइ, अय्‌नं इमिसं छिमित शासन याये खनि मखु। ");
INSERT INTO new_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","परमप्रभु छिमि परमेश्‍वरं छिमित बियादीगु देशया शहरय् छिमि इस्राएलीतय् सुं नये मखंसा छिमिसं वयात बीत नुगः स्‍याके मते। ");
INSERT INTO new_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","बरु वयात छु छु माःगु खः नुगः मस्‍याकुसें त्‍याये ब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","होश या! सुं मनुखं त्‍यासा त्‍वःतेगु न्‍हय्‌गूगु दँ वइन धकाः मभिंगु बिचाः नुगलय् तयाः थः गरीब दाजुकिजायात छुं मबिल धाःसा व गरीबम्‍हय्‌सिनं परमप्रभुयाथाय् छंगु विरोधय् इनाप याइ, अले छन्‍त पापया द्वपं लाइ। ");
INSERT INTO new_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","छिमिसं वयात धात्‍थें हे ब्‍यु, वयात बीबलय् छिमिगु नुगः मस्‍यायेमाः छाय्‌धाःसा थुकिं यानाः परमप्रभु छिमि परमेश्‍वरं फुक्‍क ज्‍याय् व छिमिसं ल्‍हाः तइगु फुक्‍क खँय् सुवाः बियादी। ");
INSERT INTO new_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","देशय् नये मखंपिं न्‍ह्याबलें दइ। अथे जुयाः जिं छिमित धयाच्‍वनागु दु, थःगु देशय् च्‍वंपिं गरीबपिं व मगाःमचाःपिं मनूतय्‌त नुगः मस्‍याकुसें ब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","छिमि सुं हिब्रू दाजुकिजा वा तताकेहेँनं थःत थःम्‍हं छिमिगु ल्‍हातय् मिल अले वं खुदँ तक छिमिगु सेवा यात धाःसा न्‍हय्‌दँ क्‍यनीबलय् वयात त्‍वःताछ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","छिमिसं वयात त्‍वःताछ्वइबलय् खालि ल्‍हाः छ्वये मते। ");
INSERT INTO new_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","छिमिसं थःगु फैच्‍वलय्‌पाखें, थःगु खलां व थःगु दाखतिसिगु सालं नुगः मस्‍याकुसें वयात ब्‍यु। परमप्रभु छिमि परमेश्‍वरं छिमित गज्‍याःगु सुवाः बियादीगु दु, वकथं हे वयात ब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","मिश्रय् छिपिं दास जुयाच्‍वंबलय् परमप्रभु छिमि परमेश्‍वरं छिमित त्‍वःतकाहयादीगु खँ लुमंकि। अथे जुयाः थौं जिं छिमित थ्‍व आज्ञा बी। ");
INSERT INTO new_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","अय्‌नं छिमि च्‍यलं छन्‍त व छिमि छेँजःयात माया यानाः छिपिंलिसें लय्‌तायाः “छिमित त्‍वःतावने मखु” धकाः धाल धाःसा ");
INSERT INTO new_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","वयात लुखाय् यंकाः छपु नतूचा कयाः वयागु न्‍हय्‌पंप्‍वाः खनाब्‍यु। अले व म्‍वातले छिमि च्‍यः जुइ। थः भ्‍वातिंयात नं अथे हे या। ");
INSERT INTO new_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","च्‍यःयात त्‍वःतावने बीत थाकु चाये मते। छाय्‌धाःसा ज्‍याला कयाः ज्‍या याइम्‍ह ज्‍यामिनं काइगु ज्‍यालाया निदुगं मूया ज्‍या वं खुदँय् यात। अले परमप्रभु छिमि परमेश्‍वरं छिमित फुक्‍क ज्‍याय् सुवाः बियादी। ");
INSERT INTO new_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","छिमि सा द्वहं व फैच्‍वलय्‌या न्‍हापां बूम्‍ह न्‍ह्याम्‍ह बाजात नं परमप्रभु छिमि परमेश्‍वरया निंतिं अलग तयेमाः। छिमि न्‍हापां बूम्‍ह द्वहंचायात छुं ज्‍याय् छ्यले मते। अले न्‍हापां बूम्‍ह फैया सँ खाये मते। ");
INSERT INTO new_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","परमप्रभुं ल्‍ययादीगु थासय् वय्‌कःया न्‍ह्यःने छिमिसं थः छेँजःपिंलिसें दँय्‌दसं वयागु ला नयेगु या। ");
INSERT INTO new_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","सुं पशु लंग्रा वा मिखा मखंम्‍ह जूसा वा मेगु छुं कथंया ख्‍वं वयाके दुसा वयात परमप्रभु छिमि परमेश्‍वरया लागि बां बी मते। ");
INSERT INTO new_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","थःगु हे शहरय् व नयेगु या। हरिण व चल्‍लाया ला नः थें नियमकथं शुद्ध वा अशुद्ध मनुखं व नये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","छिमिसं हि धाःसा नये मते। उकियात लः थें बँय् प्‍वंकाब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","आबीब लायात लुमंकाः परमप्रभु छिमि परमेश्‍वरयागु छुत्‍काराया नखः हनेगु या, छाय्‌धाःसा आबीब लाय् हे वय्‌कलं छिमित चान्‍हय् मिश्रं पित हयादीगु खः। ");
INSERT INTO new_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","छिमिसं परमप्रभु छिमि परमेश्‍वरयात वय्‌कलं थःगु नां तयेत ल्‍ययादीगु थासय् छुत्‍काराकथं फैच्‍वलय्‌ व साद्वहंपाखें बां ब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","व नापं सोडा दुगु मरि नये मते। न्‍हय्‌न्‍हु तक सोडा मतःगु मरि धाःसा नयेगु या, थ्‍व दुःखया मरि खः। छाय्‌धाःसा मिश्रं छिपिं हथाय् चाचां वःगु खः। मिश्रं पिहां वःगु छिमिसं जिवंकाछि लुमंका तयेत थ्‍व नयेमाःगु खः। ");
INSERT INTO new_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","न्‍हय्‌न्‍हु तक छिमिगु देशय् सुनानं सोडा थःगु छेँय् तये मते। न्‍हापांगु न्‍हिया बहनी बां ब्‍यूम्‍ह पशुया ला सुथय् जुइ न्‍ह्यः तकं फुकेमाः, छकुचा नं ल्‍यंकातये मते। ");
INSERT INTO new_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","छुत्‍काराया नखःयाम्‍ह पशुयात छिमिसं परमप्रभु छिमि परमेश्‍वरं छिमित बियादीगु छुं नं शहरय् बां बी मते। ");
INSERT INTO new_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","परमप्रभु छिमि परमेश्‍वरं थःगु नां तयेत ल्‍ययादीगु थासय् जक बां बीगु या। आबीब लाया सूर्य बिनावनीगु इलय्, छिपिं मिश्रं पिहां वःगु लुमंकाः हनीगु दिनय् छुत्‍काराया पशु बां ब्‍यु। ");
INSERT INTO new_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","परमप्रभु छिमि परमेश्‍वरं ल्‍ययादीगु थासय् हे व पशुया ला छुयाः न। अले सुथय् थथःगु छेँय् लिहां हुँ। ");
INSERT INTO new_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","खुन्‍हु तक सोडा मतःगु मरि न, अले न्‍हय्‌न्‍हु खुन्‍हु परमप्रभु छिमि परमेश्‍वरयात आराधना यायेत पवित्र मुँज्‍या या। उखुन्‍हु छुं ज्‍या याये मते। ");
INSERT INTO new_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","सःगु बाली ईंचां लयेगु ज्‍या शुरु यायेगु इलंनिसें न्‍हय्‌वाः ल्‍याःखा। ");
INSERT INTO new_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","अले परमप्रभु थः परमेश्‍वरं छिमित बियादीगु सुवाःकथं थः यःछिं बलि छायाः परमप्रभु छिमि परमेश्‍वरया निंतिं सामाज्‍याया नखः हनेगु या। ");
INSERT INTO new_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","परमप्रभु छिमि परमेश्‍वरं थःगु नांया लागिं च्‍वनेगु ल्‍ययादीगु थासय् छिपिं, छिमि काय्‌म्‍ह्याय्‌पिं, दास दासी, शहरय् च्‍वंपिं लेवीया सन्‍तानत, परदेशीत, मांबौ मदुपिं मस्‍त व भाःत सी धुंकूपिं मिस्‍त, फुक्‍कसिनं थः परमेश्‍वरया न्‍ह्यःने लसता हँ। ");
INSERT INTO new_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","छिपिं मिश्रय् दास दासी जुयाच्‍वंगु खः धइगु खँ ल्‍वःमंके मते अले थुपिं नियम बांलाक मानय् या। ");
INSERT INTO new_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","थःगु खला व दाख तिसीगु थासं फुक्‍क मुंके धुंकाः छिमिसं न्‍हय्‌न्‍हु तक बल्‍चाबाय्‌या नखः हनेगु या। ");
INSERT INTO new_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","छिपिं, छिमि काय्‌म्‍ह्याय्‌पिं, दास दासी अले छिमिगु शहरय् च्‍वनिपिं लेवीया सन्‍तानत, परदेशीत, मांबौ मदुपिं मस्‍त व भाःत सी धुंकूपिं मिस्‍त फुक्‍कसिनं नखःबलय् लसता हँ। ");
INSERT INTO new_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","वय्‌कलं ल्‍ययादीगु थासय् परमप्रभु छिमि परमेश्‍वरया लागिं न्‍हय्‌न्‍हु तक नखः हनेगु या। छाय्‌धाःसा परमप्रभु छिमि परमेश्‍वरं छिमिगु फुक्‍क बाली व ज्‍याय् छिमित सुवाः बियादी अले छिपिं लय्‌ताया च्‍वँ। ");
INSERT INTO new_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","परमप्रभु छिमि परमेश्‍वरं ल्‍ययादीगु थासय् दँय् स्‍वक्‍वः छिमि मिजंत धाक्‍व वय्‌कःया न्‍ह्यःने खनेदः वनेमाः, सोडा मतःगु मरिया नखःबलय्, सामाज्‍याया नखःबलय् अले बल्‍चाबाय्‌या नखःबलय् परमप्रभुया न्‍ह्यःने सुं नं खालि ल्‍हातं वने मते। ");
INSERT INTO new_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","छिमि फुक्‍क मनूतय्‌सं परमप्रभु छिमि परमेश्‍वरं बियादीगु सुवाःकथं थथःगु देछा छायेमाः। ");
INSERT INTO new_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","परमप्रभु छिमि परमेश्‍वरं बियादीगु छिमिगु फुक्‍क शहरय् थथःगु कुलकथं न्‍याय याइपिं व मेपिं हाकिमत ल्‍य। इमिसं मनूतय्‌गु न्‍याय खःकथं यायेमाः। ");
INSERT INTO new_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","इमिसं सुयागु पंलिनाः ज्‍या मयायेमाः। घुस मनयेमाः छाय्‌धाःसा घुसं मनूतय्‌त कां यानाबी अले भिंम्‍ह मनूया बचंयात हीकाबी। ");
INSERT INTO new_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","खःगु खँया जक ल्‍यू हुँ। अले परमप्रभु छिमि परमेश्‍वरं बियादीगु देशयात त्‍याकाकयाः छिपिं म्‍वानाच्‍वने फइ। ");
INSERT INTO new_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","छिमिसं परमप्रभु थः परमेश्‍वरया निंतिं दय्‌कूगु वेदीया लिक्‍क अशेरा द्यःमय्‌जुया सिँया थां धस्‍वाके मते। ");
INSERT INTO new_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","छिमिसं पुजा याइगु ल्‍वहं धस्‍वाके मते। परमप्रभु छिमि परमेश्‍वरयात थ्‍व तसकं मयः। ");
INSERT INTO new_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","छिमिसं परमप्रभु छिमि परमेश्‍वरयात छुं खू दुम्‍ह वा ख्‍वं दुम्‍ह द्वहं वा फै बां बी मते। छाय्‌धाःसा वय्‌कःयात थ्‍व घच्‍चाइपुगु खँ खः। ");
INSERT INTO new_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","परमप्रभु छिमि परमेश्‍वरं छिमित बियादीगु शहरय् छिमिगु दथुइ च्‍वनीम्‍ह सुं मिसा वा मिजंनं परमप्रभु छिमि परमेश्‍वरयागु मिखाय् मभिंगु ज्‍या यानाः बाचायात त्‍वाथुलाः ");
INSERT INTO new_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","जिगु उजं मानय् मयासें द्यःत वा सूर्य, तिमिला वा आकाशया नगुतय्‌गु पुजा याःगु दुसा वा इमित भागि याःगु दुसा, ");
INSERT INTO new_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","अले थ्‍व खँ छिमित कन धाःसा वा छिमिसं न्‍यनेदत धाःसा उबलय् छिमिसं बांलाक न्‍यनेकने या। धात्‍थें इस्राएलय् थज्‍याःगु घच्‍याइपुस्‍से च्‍वंगु ज्‍या जूगु हे खःसा, ");
INSERT INTO new_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","सु मिसा वा मिजंनं थज्‍याःगु मभिंगु ज्‍या याःगु खः, व मिसा वा मिजंयात शहरया मू ध्‍वाखाय् हयाः ल्‍वहँतं कय्‌काः स्‍या। ");
INSERT INTO new_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","स्‍याना छ्वयेमाःम्‍ह मनूयात निम्‍ह वा स्‍वम्‍ह मनूया साक्षीं जक स्‍या, छम्‍ह हे जक मनूया साक्षीं वयात स्‍याये मते। ");
INSERT INTO new_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","वयात स्‍यायेत दकलय् न्‍हापालाक साक्षीतय्‌सं ल्‍वहँतं कय्‌केमाः। अनंलि मेपिं मनूतय्‌सं वयात ल्‍वहँतं कय्‌केमाः। छिमिसं थज्‍याःगु मभिंगु ज्‍या छिमिगु दथुं चीकाः छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","छिमिगु शहरय् मनू स्‍याःगु मुद्दा, सम्‍पत्तिया मुद्दा वा कचवं, ल्‍वापुख्‍यापुया मुद्दा क्‍वःछियेत थाकुल धाःसा परमप्रभु छिमि परमेश्‍वरं ल्‍ययादीगु थासय् हुँ। ");
INSERT INTO new_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","लेवी पुजाहारीतय्‌थाय् व उबलय्‌याम्‍ह न्‍यायकर्तायाथाय् वनाः न्‍यनेकने या अले वं क्‍वःछिनाबी। ");
INSERT INTO new_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","परमप्रभुं ल्‍ययादीगु थासय् इमिसं छिमित छु छु खँ धाल वकथं हे या, अले इमिसं स्‍यंगु नियमकथं जु। ");
INSERT INTO new_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","इमिसं छिमित स्‍यंगु नियम व क्‍वःछिनाब्‍यूगु खँकथं छिमिसं ज्‍या या। इमिसं छु धाल उकिं जव खव फहिले मते। ");
INSERT INTO new_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","सुं मनुखं परमप्रभु छिमि परमेश्‍वरयागु सेवा यायेत च्‍वनाच्‍वनीम्‍ह न्‍यायकर्ता वा पुजाहारीयात क्‍वह्यंकल धाःसा वयात स्‍यानाछ्व। छिमिसं थज्‍याःगु मभिंगु ज्‍या छिमिगु दथुं चीकाः छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","थ्‍व न्‍यनाः सकलें मनूत ग्‍याइ अले हानं क्‍वह्यंकी मखु। ");
INSERT INTO new_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","परमप्रभु छिमि परमेश्‍वरं बियादीगु देशय् वनाः उकियात त्‍याकाकयाः अन च्‍वनाः छिमिसं “जिमि प्‍यखेरं च्‍वनिपिं फुक्‍क जातितय्‌सं थें छम्‍ह जुजु दय्‌के” धकाः धाल धाःसा ");
INSERT INTO new_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","परमप्रभु छिमि परमेश्‍वरं ल्‍ययादीम्‍ह मनूयात हे छिमिसं जुजु दय्‌कि। छिमिगु दथुं हे सुं छम्‍हसित थः जुजु ल्‍ययेमाः। इस्राएली मखुम्‍ह परदेशीयात थः जुजु दय्‌के मते। ");
INSERT INTO new_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","व जुजुं यक्‍व सलत नं मतयेमाः, वा यक्‍व सल दयेमाः धकाः मनूतय्‌त मिश्रय् मछ्वयेमाः। छाय्‌धाःसा “व लँपु हाकनं लिहां वने मते” धकाः परमप्रभुं धयादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","वं थःके यक्‍व कलाः मतयेमाः, मखुसा वयागु मन मखुगु लँय् वनी। वं थःगु लागिं लुँ, वहः यक्‍व ममुंकेमाः। ");
INSERT INTO new_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","व जुजु जुयेवं लेवी पुजाहारीतय्‌के दुगु थ्‍व नियम कयाः थूतुलातःगु भोँतय् थःगु ल्‍हातं च्‍वयेमाः। ");
INSERT INTO new_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","थ्‍व वयाके दयेमाः, वं परमप्रभु थः परमेश्‍वरया ग्‍याःभय कायेत अले थ्‍व नियमया खँ व थुपिं विधि बांलाक मानय् यायेगु सय्‌केत थुकियात जिवंकाछि ब्‍वनेगु यायेमाः। ");
INSERT INTO new_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","थुकिं वयात थः दाजुकिजापिं स्‍वयाः तःधं भापिके बी मखु। अले व्‍यवस्‍थापाखें फहिला जव खव वनेबी मखु। थुकथं वं व वया सन्‍तानं जुजु जुयाः ताःई तक इस्राएलय् शासन याइ। ");
INSERT INTO new_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","लेवी पुजाहारीतय्‌त, धात्‍थें हे फुक्‍क लेवी कुलयात, मेपिं इस्राएलीतय्‌त थें बुँ दइ मखु। इपिं परमप्रभुयात छाःगु विशेष देछा नयाः म्‍वाइ। व हे इमिगु ब्‍व खः। ");
INSERT INTO new_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","इस्राएलया मेगु कुलतय्‌त थें इमित सर्बय दइ मखु। परमप्रभुं बचं बियादीगु थें वय्‌कः हे इमिगु सर्बय खः। ");
INSERT INTO new_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","सा द्वहं वा फैच्‍वलय् बां बीबलय् मनूतय्‌सं पुजाहारीतय्‌त ब्‍वहः, निपां न्‍यताः अले आतापुति बीमाः। पुजाहारीतय्‌गु ब्‍व थ्‍व हे खः। ");
INSERT INTO new_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","अन्‍न, न्‍हूगु दाखमद्य, जैतूनया चिकं व फैया न्‍हापां चाःगु सँ छिमिसं पुजाहारीतय्‌त बीमाः। ");
INSERT INTO new_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","छाय्‌धाःसा परमप्रभु छिमि परमेश्‍वरं छिमि फुक्‍क कुलया दथुं लेवी कुलयात परमप्रभुया नामं दनाः सेवा यायेत न्‍ह्याबलेंया लागि ल्‍ययादीगु दु। ");
INSERT INTO new_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","सुं लेवीया सन्‍तान थः च्‍वनाच्‍वंगु शहर त्‍वःताः परमप्रभुं ल्‍ययादीगु थासय् सेवा याये मंदयाःवल धाःसा ");
INSERT INTO new_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","अन परमप्रभुया न्‍ह्यःने सेवा याइपिं मेपिं सकल लेवीया सन्‍तानतय्‌सं थें वं नं परमप्रभु थः परमेश्‍वरया नामय् सेवा याये ज्‍यू। ");
INSERT INTO new_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","वयाके थः छेँजःया सम्‍पत्ति मियाः वःगु ध्‍यबा दुसां वयात बलि ब्‍यूगु व देछाःगुपाखें बराबर भाग दइ। ");
INSERT INTO new_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","परमप्रभुं छिमित बियादीगु देशय् छिपिं थ्‍यने धुंकाः अन च्‍वनिपिं जातितय्‌सं याइगु घच्‍चाइपुस्‍से च्‍वंगु ज्‍या सय्‌का सीकाकाये मते। ");
INSERT INTO new_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","थःकाय् वा म्‍ह्याय्‌यात मिइ बलि छाइम्‍ह, साइत स्‍वइम्‍ह, जादु क्‍यनीम्‍ह, छुक विछुक धाइम्‍ह, बोक्‍सी ज्‍या याइम्‍ह, ");
INSERT INTO new_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","तन्‍त्रमन्‍त्र याइम्‍ह, सीक दुबिना वइम्‍ह मनू, झाँक्री ज्‍या याइम्‍ह व सी धुंकूम्‍ह मनूयाके सल्‍लाह काइम्‍ह मनू छिमिगु दथुइ मदयेमाः। ");
INSERT INTO new_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","थज्‍याःगु ज्‍या याइम्‍ह मनू परमप्रभुयात घच्‍चाइपुस्‍से च्‍वंम्‍ह खः। थुपिं घच्‍चाइपुस्‍से च्‍वंगु चलनं यानाः परमप्रभु छिमि परमेश्‍वरं उपिं जातितय्‌त छिमिगु न्‍ह्यःनेनं पितिना छ्वयादी। ");
INSERT INTO new_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","परमप्रभु छिमि परमेश्‍वरयागु न्‍ह्यःने छिपिं द्वं मदुपिं जुइमाः। ");
INSERT INTO new_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","छिमिसं त्‍याके त्‍यंपिं जातित जादु मन्‍त्र याइपिं व लिपाया खँ धाइपिं मनूतय्‌गु खँ न्‍यनीपिं खः। छिमित धाःसा परमप्रभु छिमि परमेश्‍वरं अथे याकेबी मखु। ");
INSERT INTO new_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","परमप्रभु परमेश्‍वरं जितः थें छिमि इस्राएली दाजुकिजापिं मध्‍ये छम्‍हय्‌सित अगमवक्ता ल्‍ययादी। वय्‌कलं धाःगु फुक्‍क खँ छिकपिन्‍सं न्‍यनेमाः। ");
INSERT INTO new_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","होरेबय् छिपिं मुंबलय् परमप्रभु छिमि परमेश्‍वरयात छिमिसं थथे धकाः इनाप यात “झीसं आवंलि परमप्रभु झी परमेश्‍वरयागु सः न्‍यने म्‍वालेमा, अले थ्‍व तःधंगु मि नं स्‍वये म्‍वालेमा, मखुसा झीपिं सिनावनी।” ");
INSERT INTO new_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","परमप्रभुं जितः धयादिल, “इमिसं धाःगु खँ बांलाः, ");
INSERT INTO new_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","जिं इमि इस्राएली दाजुकिजातय् दथुं छ थें ज्‍याःम्‍ह छम्‍ह अगमवक्ता दय्‌के। जिं जिगु खँ वयागु म्‍हुतुइ तयाबी, अले वं जिं धयागु आज्ञा इमित कनाबी। ");
INSERT INTO new_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","सुं मनुखं व अगमवक्तां जिगु नामय् न्‍ववाःगु जिगु वचन मन्‍यन धाःसा जिं थःम्‍हं हे वयागु ल्‍याःचाः काये। ");
INSERT INTO new_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","अय्‌नं जिं आज्ञा मबियागु वचन जिगु नामय् न्‍ववाइम्‍ह वा मेपिं द्यःतय्‌गु नामय् न्‍ववाइम्‍ह अगमवक्तायात स्‍याना छ्वयेमाः।” ");
INSERT INTO new_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","छिमिसं थःथवय् थथे धायेफु, “सुं अगमवक्ताया वचन परमप्रभुपाखें वःगु खः कि मखु धकाः जिमिसं गथे यानाः सीकेगु?” ");
INSERT INTO new_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","सुं अगमवक्तां परमप्रभुया नामय् न्‍ववाःगु खँ मजूसा व खँ परमप्रभुं धयादीगु मखु, व खँ व अगमवक्तां तःधंछु जुयाः धाःगु खः। छिपिं व खनाः ग्‍याये मते। ");
INSERT INTO new_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","परमप्रभु छिमि परमेश्‍वरं छिमित बियादीगु देशया जातितय्‌त नाश यानादीबलय् अले इमिगु शहर व छेँ छिमिसं कयाः छिपिं अन च्‍वनीबलय् ");
INSERT INTO new_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","छिमिसं थःगु लागि परमप्रभु छिमि परमेश्‍वरं अधिकारय् बियादीगु देशया दथुइ स्‍वंगू शहर अलग या। ");
INSERT INTO new_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","सुयातं स्‍याःम्‍ह मनू अपुक बिस्‍युं वनेत परमप्रभु छिमि परमेश्‍वरं सर्बयकथं छिमित बियादीत्‍यंगु देशयात स्‍वब्‍व थलाः उपिं शहरय् वनीगु लँ नं दय्‌कि। ");
INSERT INTO new_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","थः जःलाखःलायात मसीसें वा ईख मदुसें स्‍यानाब्‍यूम्‍ह मनू बचय् जुइत अन बिस्‍युं वनेगु बारे थज्‍याःगु नियम दु। ");
INSERT INTO new_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","गथेकि निम्‍ह मनूत सिँ पालेत गुँइ वनेफु। सिमा पाःबलय् ज्‍वनेगु चुं पा कुतुवनाः छम्‍हसित लात अले व सित धाःसा मेम्‍ह मनुखं थुपिं शहर मध्‍ये छगुलिइ बिस्‍युं वनाः थःत बचय् याये फइ। ");
INSERT INTO new_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","वयात लँपु तापाः जुइ मज्‍यू, मखुसा हिया बदला काःवःम्‍हय्‌सिनं लँय् नापलाकाः वयात तंम्‍वय् स्‍यानाबी। व मनू स्‍याना छ्वयेमाःम्‍ह धाःसा मखु छाय्‌धाःसा वयागु थः जःलाखःलालिसें छुं ईख मदु। ");
INSERT INTO new_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","अथे जुयाः थःगु निंतिं स्‍वंगू शरण बीगु शहर अलग या धकाः जिं छिमित धया। ");
INSERT INTO new_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","परमप्रभु परमेश्‍वरं छिमि पुर्खालिसें पाफयाः बचं बियादीकथं छिमिगु देश तःकू यानादीबलय् अले वय्‌कलं इपिंलिसें बचं बियादीगु फुक्‍क देश बियादीबलय् ");
INSERT INTO new_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","जिं थौं बियागु आज्ञाकथं परमप्रभु छिमि परमेश्‍वरयात माया यात अले वय्‌कःया लँपुइ न्‍ह्याबलें वन धाःसा छिमिसं मेगु नं स्‍वंगू शहर अलग या। ");
INSERT INTO new_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","परमप्रभु छिमि परमेश्‍वरं छिमित सर्बयकथं बियादीगु देशय् द्वं मदुपिं मनूतय्‌गु हिबाः मवयेमा धकाः अले छिमित उकिया दोष मलायेमा धकाः छिमिसं थथे या। ");
INSERT INTO new_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","अथे जूसां सुं मनुखं ईख दयाः मेम्‍ह मनूयात लँय् पियाच्‍वंबलय् नापलाकल अले दायाः स्‍यानाः व ज्‍यानमारा उपिं शहर मध्‍ये छगुलिइ बिस्‍युं वंसा ");
INSERT INTO new_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","वयागु हे शहरयापिं थकालितय्‌सं मनू छ्वयाः वयात अनं ज्‍वनाहयाः हिया बदला काःवःम्‍हय्‌सिया ल्‍हातय् स्‍यायेत लःल्‍हाना बीमाः। ");
INSERT INTO new_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","वयात माया याये मते! द्वं मदुपिन्‍त स्‍यायेगु ज्‍या इस्राएलं न्‍हंकाः छ्वयेमाः। अले छिमिगु भिं जुइ। ");
INSERT INTO new_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","परमप्रभु छिमि परमेश्‍वरं छिमिगु अधिकारय् बियादीगु देशय् छिमिगु थःगु सर्बयलय् पुर्खातय्‌सं क्‍वःछिनाब्‍यूगु जःलाखःलाया सिमानाया ल्‍वहं चीके मते। ");
INSERT INTO new_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","छुं नं अपराध वा अधर्मय् सुं मनूयात छम्‍ह जक मनूया साक्षीं सजाँय बी मते। वयात सजाँय बीत निम्‍ह वा स्‍वम्‍ह मनुखं साक्षी बीमाः। ");
INSERT INTO new_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","सुं मनूयात दोष बीत सुं मभिंम्‍ह मनुखं साक्षी बिल धाःसा ");
INSERT INTO new_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","इपिं निम्‍हं मनूत उबलय्‌यापिं पुजाहारीत व न्‍यायाधीशतय्‌गु लिक्‍क परमप्रभुया न्‍ह्यःने वयेमाः। ");
INSERT INTO new_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","उपिं न्‍यायकर्तातय्‌सं बांलाक जाँचय् यायेमाः। व साक्षी ब्‍यूम्‍ह मनुखं मखुगु खँ ल्‍हाःगु थहरे जूसा अले व मनूया विरोधय् मखुगु साक्षी ब्‍यूगु जूसा ");
INSERT INTO new_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","छिमिसं व मखुगु साक्षी ब्‍यूम्‍ह मनूयात अथे हे या गथे व मनूयात यायेगु बिचाः यानागु खः। छिमिसं थज्‍याःगु मभिंगु ज्‍या छिमिगु दथुं चीकाः छ्वयेमाः। ");
INSERT INTO new_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","थ्‍व खँ न्‍यनाः मनूत ग्‍याइ, अले छिमिगु दथुइ थज्‍याःगु मभिंगु ज्‍या हानं गुबलें याइ मखु। ");
INSERT INTO new_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","थज्‍याःम्‍ह मनूयात माया याये मते। प्राणया पलेसा प्राण, मिखाया पलेसा मिखा, वाया पलेसा वा, ल्‍हाःया पलेसा ल्‍हाः व तुतिया पलेसा तुति कायेमाः। ");
INSERT INTO new_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","छिपिं थः शत्रुतलिसें लडाइँ याः वनीबलय