﻿USE sofia;
DROP TABLE IF EXISTS sofia.ndz_vpl;
CREATE TABLE ndz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ndz_vpl WRITE;
INSERT INTO ndz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ŋìnó a tà-ká-tà gítí ṛèngbó bà jò Jézù tí Bìndi-Mbíṛì, tí ꞌviì mì Dàvídè tí gbolò gba mì ndâ Ìzìrìyélì, tí ꞌviì mì Àbìráámò tí mbe jò ŋa ndâ Ìzìrìyélì ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ŋìnó a ṛè ndâ ká gù Jézù mbe ꞌbìtà ꞌdo tí Àbìráámò yee tí Dàvídè: Àbìráámò ká jò Ìzákò, Ìzákò giì jò Jàkóbè, Jàkóbè giì jò ndâ Júdàà ta ndâ náꞌvindí wó. ");
INSERT INTO ndz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Júdàà giì jò ndâ Pèrézì ta Zérà mítí Tàmárà, Pèrézì giì jò Èzìrónì, Èzìrónì giì jò Rámù, ");
INSERT INTO ndz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rámù giì jò Àmìnàdábì, Àmìnàdábì giì jò Nàsónì, Nàsónì giì jò Sàlìmónì, ");
INSERT INTO ndz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sàlìmónì giì jò Bòwázì mítí Ràꞌábù, Bòwázì giì jò Òbédì mítí Rútà, Òbédì giì jò Jésì, ");
INSERT INTO ndz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","bìndi  Jésì giì jò Dàvídè tí gbolò gba mì ndâ Ìzìrìyélì. Ŋìnó a ṛè ndâ gù Jézù mbe ꞌbìtà ꞌdo tí Dàvídè yee tí o bà kaa ndâ Ìzìrìyélì tí ndâ zà-za gó ꞌdo ꞌbá mì ndú ya tí  gí Bàbìlónìyà: Dàvídè tí gbolò gba mì ndâ Ìzìrìyélì giì jò Sólómònì mítí nawù wó Ùráyà, ");
INSERT INTO ndz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sólómònì giì jò Rèyòbòwámù, Rèyòbòwámù giì jò Àbíjà, Àbíjà giì jò Ásà, ");
INSERT INTO ndz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ásà giì jò Yòsàfátì, Yòsàfátì giì jò Yòrámù, Yòrámù giì jò Ùzáyà, ");
INSERT INTO ndz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ùzáyà giì jò Yòtámù, Yòtámù giì jò Àázì, Àázì giì jò Èzìkíyà, ");
INSERT INTO ndz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Èzìkíyà giì jò Mànásè, Mànásè giì jò Àmónì, Àmónì giì jò Yòsíyà, ");
INSERT INTO ndz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yòsíyà giì jò ndâ Jèkòníyà ta ndâ náꞌvindí wó. ꞌDo bà-i-nò à giì kaa ndâ Ìzìrìyélì tí ndâ zà-za gó ya tí  gí Bàbìlónìyà. ");
INSERT INTO ndz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ŋìnó a ṛè ndâ gù Jézù mbe ꞌbìtà ꞌdo tí o bà kaa ndâ Ìzìrìyélì tí ndâ zà-za gó ꞌdo ꞌbá mì ndú ya tí  gí Bàbìlónìyà yee tí o bà jò Jézù: Jèkòníyà giì jò Sèlìtìyélì si ndú Bàbìlónìyà, bìndi  Sèlìtìyélì giì jò Zèrùbàbélè, ");
INSERT INTO ndz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zèrùbàbélè giì jò Àbìyúdì, Àbìyúdì giì jò Èlìyàkímì, Èlìyàkímì giì jò Àzórì, ");
INSERT INTO ndz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Àzórì giì jò Zàdókì, Zàdókì giì jò Àkímì, Àkímì giì jò Èlìyúdì, ");
INSERT INTO ndz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Èlìyúdì giì jò Èlìyázàrà, Èlìyázàrà giì jò Màtánì, Màtánì giì jò Jàkóbè, ");
INSERT INTO ndz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","bìndi  Jàkóbè giì jò Jùzépè nó mbe kò Màríyà tí nawu Jézù nó tí Bìndi-Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Muu ndâ gù Jézù mbe ꞌbìtà ꞌdo tí Àbìráámò tí bu ndâ Ìzìrìyélì ꞌdáá gî, yee tí Dàvídè tí gbolò gba mì ndâ Ìzìrìyélì a bà ꞌdòkò bà jò tí tabà  muuꞌbì-nje nàꞌô. ꞌDo tí Dàvídè yee tí o bà kaa ndâ Ìzìrìyélì tí ndâ zà-za gó ya tí  gí Bàbìlónìyà ꞌdáá gî a bà ꞌdòkò bà jò tí tabà  muuꞌbì-nje nàꞌô. ꞌDo tí o bà kaa ndâ Ìzìrìyélì tí ndâ zà-za gó ya tí  gí Bàbìlónìyà yee tí o bà jò Jézù ꞌdáá gî a ndâ ꞌdakò muuꞌbì-nje nàꞌô. ");
INSERT INTO ndz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ṛèngbó bà jò Jézù tí Bìndi-Mbíṛì énô. Ta o tí nò Jùzépè ꞌvee káa có tí Màríyà tí nawu Jézù tí Bìndi-Mbíṛì jéé gî, káa ndú toko bà sili ta yí lá. Káa kùṛo bà ko yí gí ꞌbá, Màríyà giì tè nakáyì ta wotí mì Bèṛi-mì-Mbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jùzépè mâ giì ŋò énò, yí giì bàkà có bà dele ndi ndâ i mì wó ꞌdo tàkò Màríyà gbí ꞌdê có á tàbèngìì, tacó yí a tó ꞌdakò, káa go bà te nô á ṛo Màríyà mí kùṛo ndâ ꞌduù tí wó wálá. ");
INSERT INTO ndz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Káa si yí kû koṛo ŋa có tí nò, basìlì mì Mbíṛì giì gì gí muu wó gbí ṛiì, bìndi  yí giì ꞌdè có ji yí máa, «Jùzépè, ꞌviì mì Dàvídè, cì gúku tí bà kò Màríyà tí nawù lo lá. Tacó ꞌviì tí nò gbí yì wó nò a ꞌviì mì Bèṛi-mì-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yí bà jò a ꞌviì-ꞌdakò, bìndi  wò bà gbì ṛè wó tí Jézù, tacó yí bà ꞌvala ndâ ꞌduù mì yo ꞌdo gbí ndâ vò i mì ndú.» ");
INSERT INTO ndz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","I tí nò bàkà tí ꞌdáá ká tacó wàa có tí nó náa Mbíṛì táánò tuu ta ꞌbí mbe ꞌdòkò có mì wó máa, ");
INSERT INTO ndz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«ꞌBí ngbutu ꞌvinî bà giì tè nakáyì, yí bà jò ꞌviì tí nò tí ꞌviì-ꞌdakò, náa àá bà gbì ṛè wó tí Èmànùwélè (gbí  máa: Mbíṛì ta ndoo) nó» ꞌví dù tí  tí yúcó. ");
INSERT INTO ndz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jùzépè mâ giì ziya ꞌdo tí ṛì, yí giì ko Màríyà gí ꞌbá go có tí nó náa basìlì mì Mbíṛì ꞌdè ji yí gbí ṛiì nô. ");
INSERT INTO ndz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Káa ndú toko bà sili ta yí lá. Bìndi  Màríyà giì jò ꞌviì mì wó, tí ꞌviì-ꞌdakò, bìndi  Jùzépè giì gbì ṛè wó tí Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ta o tí nò, gbolò gba Jùdéyà a Èródè. Mâ giì zekeꞌo, ndâ ꞌbí ꞌdakò tí ndâ mbe ꞌdi gbí-o, tí ndâ mbe kû pà-có ndâ i ta ndâ yii, giì ŋò yii tí nó mbe tùbà o bà jò Jézù nó co gî, bìndi  ndú giì njè nó ya gí Jèrùzàlémè, kû ꞌvee ndâ ꞌduù, ");
INSERT INTO ndz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","máa, «Dó ꞌviì tí nó tí gbolò gba mì ndâ Jùdéyà nó ngò? Tacó ze ŋò yii mì wó si ze ꞌbá mì ze á Wàá, káa ze giì gì tacó bà ùlù yí.» ");
INSERT INTO ndz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Èródè tí gbolò gba mì ndâ Jùdéyà mâ giì ꞌdi có tí nò, líkíꞌo giì cee ꞌdo tí wó gî. Gúku bà ꞌdi có tí nò delè giì zèè ndâ ꞌduù Jèrùzàlémè ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Èródè bà-i-nò giì kili ndâ Kùṛo ndâ bu-Mbíṛì ta ndâ kpo-kpò ꞌduù mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà ꞌdáá gî, bìndi  yí giì ꞌvee ndú, máa, «À cu mí gbí wáràgà mì Mbíṛì máa, àá bà jò Bìndi-Mbíṛì mí ngò?» ");
INSERT INTO ndz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Káa ndú giì ꞌvìsì có ji yí, máa, «Àá bà jò yí mí gbí gbata Bétèlèmè, go có tí nó náa Míkà tí mbe ꞌdòkò có mì Mbíṛì cu mí gbí wáràgà mì wó táánò sàà, máa, ");
INSERT INTO ndz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Káa wò tí Bétèlèmè á gbí to mì Júdàà, wò me ꞌdé to á kùṛo ndâ gba kòtí Júdàà lá, tacó gba tí nó náa yí bà giì dù tí mbe kpolo tí ndâ ꞌduù mì ye tí ndâ Ìzìrìyélì nó bà gì ꞌdo mì lo.› » ");
INSERT INTO ndz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Èródè mâ giì ꞌdi có tí nò, yí giì tèꞌé tí ndâ mbe ꞌdi gbí-o tí nó mbe gì ꞌdo Wàá nó tàbèngìì, bìndi  yí giì ꞌvee ndú gítí kpédélé o bà ŋò yii tí nò mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bìndi  yí giì ꞌdè có ji ndú máa, ndú ya gí bà pà bàndò tí nó náa à jò ꞌviì tí nò mítí  á Bétèlèmè nô, ndú má ꞌde gî, ndú ꞌví dele ndi ndú gì gí bà ꞌdè có ji yì. Tacó wàa, yì ꞌví ya gí bà ùlù yí delè. ");
INSERT INTO ndz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ndâ mbe ꞌdi gbí-o tí nò mâ giì ꞌdi có tí nò náa Èródè ꞌdè ji ndú nò gî, ndú giì njè nó ꞌdo Jèrùzàlémè kû ya gí Bétèlèmè. Ndú mâ giì di kpokèjì, yii tí nó mbe kû tùbà kpokèjì ji ndú nó giì co ndi wó kákáꞌi mí kùṛo ndú kû tùbà kpokèjì ji ndú. Yii tí nò giì ko ndú yee Bétèlèmè, bìndi  yí giì ṛò tíyò á ꞌvii ta muu bàndò tí nó ta dó Jézù tí  nô. ");
INSERT INTO ndz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Líkíꞌo bà ŋò yii tí nò giì bàkà ndú ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ndú mâ giì ṛì gí tàꞌi, ndú giì ꞌde ndâ ꞌviì tí nò ta nawu wó Màríyà. Ndú bà-i-nò giì kucuku muungbó ndú mí kùṛo dó ꞌviì tí nò, bìndi  ndú giì ùlù yí go bà ùlù Mbíṛì. Bìndi  ndú giì njaanga gbí ndâ káꞌi mì ndú, ndú giì je ndâ i-nambeè ꞌdo tí dâꞌbì, ta dì, ta banga pó i bà ŋònòkò bàà ji ꞌviì tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Káa ta kùṛo o bà dele ndi ndú gí ꞌbá mì ndú, Mbíṛì giì kpo-gbí-tà-tù ndú gbí ṛiì, máa, ndú ꞌví dele co mì Èródè lá. Tacó énò, ndú giì waa to ꞌdo tí Èródè co tí ꞌbí kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ndâ mbe ꞌdi gbí-o tí nò mâ giì njè nó gî, basìlì mì Mbíṛì giì ꞌdè có ji Jùzépè gbí ṛiì, máa, «A gí yaà, wò ꞌví kaa ndâ ꞌviì tí nò ta nawu wó, wàa wò ꞌví fa ngèlè ta ndú ya gí Másìrì. Yo ꞌví dù ta ndú kà yee tí o tí nó náa ye bà tèꞌé tí lo. Tacó Èródè kû pà kpokèjì bà ꞌde ꞌviì tí nò, wàa yì ꞌví zi yí gî.» ");
INSERT INTO ndz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jùzépè mâ giì ziya ꞌdo tí ṛì, yí giì kaa ndâ Jézù ta nawu wó Màríyà, yí giì zèè kpokèjì Másìrì ta ndú ta bèbìlì tí nò, go có tí nò náa basìlì mì Mbíṛì ꞌdè ji yí gbí ṛiì nò. ");
INSERT INTO ndz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ndú giì dù á Másìrì yee tí o bà cì Èródè. I tí nò bàkà tí jé ká go có tí nó náa ꞌbí mbe ꞌdòkò có mì Mbíṛì ta ṛè wó a Òsíyà ꞌdè sàà, énó máa, Mbíṛì máa, «Ye tèꞌé tí ꞌviì mì ye ꞌdo Másìrì,» nô. ");
INSERT INTO ndz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Èródè mâ giì ꞌdi gbí  ni gî máa, ndâ mbe ꞌdi gbí-o tí nò mbe gì ꞌdo Wàá nò eendi yì gî, tàkòcò wó giì kpolo ngé ndii gî. Tacó énò, yí giì ꞌdè có ji ndâ àsìkérì mì wó, máa, ndú ya gí bà ziki ndâ dó ꞌviì-ꞌdakò gbí gbata Bétèlèmè ta ndâ to tí nó dê-dê seè Bétèlèmè nó ꞌdáá gî. Máa, ndú ꞌbìtà ꞌdo tí ndâ délékè dó ꞌviì yee tí ndâ ŋìnó ta ndoò tí ndú sósòꞌô, nô. Èródè ꞌdeke o tí nò ꞌvii ta o tí nó náa ndâ mbe ꞌdi gbí-o tí nó mbe gì ꞌdo Wàá nó ꞌdeke ji yí máa ndâ yì ꞌbìtà bà ŋò yii tí nò gbí  nô. ");
INSERT INTO ndz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ŋa i tí nò náa Èródè bàkà nò gì ká jé go có tí nó náa Jèrèmíyà tí mbe ꞌdòkò có mì Mbíṛì ꞌdè sàà táánò, máa, ");
INSERT INTO ndz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«À ꞌdi kòcò ꞌduù gí gbí gbata Rámà, ꞌduù tí nò kû wa gbí, ta bà tò kû ngéé gí yaà. A niì tí nó tí Ràkélè nó ká kû wa ndâ ꞌviì mì wó. Bà yìì yí kpo ndâ ꞌduù gî, tacó ndâ ꞌviì mì wó mìì ꞌdáá gî,» nô. ");
INSERT INTO ndz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bìndi bà cì Èródè, basìlì mì Mbíṛì giì ꞌdè có ji Jùzépè kákáꞌi gbí ṛiì, si yí Másìrì, ");
INSERT INTO ndz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","máa, «A gí yaà, wàa wò ꞌví kaa ndâ ꞌviì tí nò ta nawu wó, wò ꞌví dele ta ndú ya gí ꞌbá mì yo ndâ Ìzìrìyélì. Tacó ꞌduù tí nó táánò mbe kû jè ta bà zi yí nó cì gî.» ");
INSERT INTO ndz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jùzépè mâ giì ziya ꞌdo tí ṛì gî, yí giì kaa ndâ Jézù ta nawu wó Màríyà, bìndi  yí giì dele ta ndú ya gí ꞌbá mì ndú ndâ Ìzìrìyélì. ");
INSERT INTO ndz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Káa si ndú kálásê á kpokèjì, yí mâ giì ꞌdi có máa, a Àrìkálàwù tí ꞌbí ꞌviì mì Èródè ká le bèṛè bìndi bu wó á Jùdéyà, gúku bà ya gí Jùdéyà giì bàkà yí gî. Káa Mbíṛì giì ꞌdè có ji yí gbí ṛiì, máa, yí ya gí Jùdéyà lá. ");
INSERT INTO ndz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tacó énò, yí giì ya a i gí gbí gbata Názàrètì á gbí to Gàlìléyà, si ꞌdóó ꞌbá mì ndú Jùdéyà mí to, go có tí nó náa ndâ mbe ꞌdòkò có mì Mbíṛì ꞌdè sàà gî, máa, ndâ ꞌduù bà giì gbì ꞌbí ngú ṛè mí muu wó, máa, «Jézù Názàrètì» nô. ");
INSERT INTO ndz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ta o tí nó si Jézù kuu Názàrètì nó, ꞌbí ꞌdakò ta ṛè wó a Jòvánì tí mbe caka tí ndâ ꞌduù giì co gí gbí kángáá nga ngoò, á gbí to Jùdéyà kû kò-kò ji ndâ ꞌduù, ");
INSERT INTO ndz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","máa, «Yo ꞌvìsì muu yo ꞌdo tí ndâ vò i mì yo, tacó kùṛo o bà gì Gba-gbíṛì kpónó dooko gî.» ");
INSERT INTO ndz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ꞌDakò tí nó tí Jòvánì nò a ꞌduù tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì táánò kû ꞌdè có ji ndâ ꞌduù gítí wó, máa, «Kòcò ꞌbí ꞌduù kû tò kû gbí kángáá nga ngoò, máa, ‹Yo ꞌviindi kpokèjì mì Mbe tí yo, yo bàkà kpokèjì mì wó jáá,› » nô. ");
INSERT INTO ndz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ꞌDakò tí nò tí Jòvánì nò táánò kû yuu a bòngo náa à gò ꞌdo tí se tí jémèlè, yí giì eṛe mí ṛèꞌdè wó a wúꞌdè kû. Ndâ i-zó-zò mì wó táánò káa ndâ kòṛòngbò ta lí. ");
INSERT INTO ndz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ndâ ꞌduù me mbè giì kaa ya gí mì wó tàbèꞌdè Jòròdánìyà ꞌdo gbí gbata Jèrùzàlémè, ta ndâ sè ndâ ꞌbí to á gbí Jùdéyà ꞌdáá gî, ta ndâ ꞌduù ꞌdo gbí ndâ to yì Jòròdánìyà ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Káa si yí kû caka tí ndú á tà ngo gbí pù Jòròdánìyà, ndú giì yù gbí ndâ vò i mì ndú gí sè. ");
INSERT INTO ndz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Káa ta ꞌbí o gbaànjé, Jòvánì giì ŋò ndâ ꞌbí ŋa Jùdéyà tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, náa à kû nì mítí ndú a ndâ Fàrìzéyò ta ndâ ꞌbí ŋa Jùdéyà ŋìnó mbe ùnje gítí ꞌválá bìndi ku lá, náa à kû nì mítí ndú a ndâ Sàdùkáyò nó kaa gì gí mì wó tacó bà caka tí ndú. Káa yí giì ꞌdè có ji ndú, máa, «Ndí yo ndâ ꞌviì-kpoo! A ꞌdi ká ꞌdè có ji yo máa yo fa ngèlè ꞌdo tí kpo-tàkòcò tí nó mì Mbíṛì á kèjì nó? ");
INSERT INTO ndz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yo bàkà tó i tacó bà tùbà  máa, yo ꞌvìsì muu yo ꞌdo tí ndâ vò i mì yo gî. ");
INSERT INTO ndz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yo si bà koṛo có máa, ‹Ze a ndâ ꞌviì mì Àbìráámò,› nò mí to. Tacó go bà ꞌvìsì ndâ díí tí nò náa yo kû ŋò nò tí ndâ ꞌviì ji Àbìráámò má kuu tí Mbíṛì á gí bìndi yo, yí bà bàkà gî. ");
INSERT INTO ndz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kpêtí ká énò, à kpónó tee kàngó mítí teè ndâ mû gî; àá kèjì gí bà daaka ndâ mû ŋìnó mbe ṛì cèe ndo mû lá nó ꞌdáá gî gí to, wàa à ꞌví doo ndú ta wu. ");
INSERT INTO ndz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ye kû caka tí yo ta ngo, tacó bà tùbà  máa, yo ꞌvìsì muu yo ꞌdo tí ndâ vò i mì yo gî, gî. Káa wotí tí ꞌduù tí nó bà giì gì gí tàkò ye nó ndii ye gî, náa à kpêtí káa vòó bà dù tí mbe kû njaanga tàmà ꞌdo tí kò wó ye bà ꞌvii tí  wálá. Yí kèjì gí bà caka tí yo ta Bèṛi-mì-Mbíṛì; yí delè kèjì gí bà caka tí yo ta wu. ");
INSERT INTO ndz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yí kpónó zèè pìdíí mì wó mí ꞌbì wó gbí wàkpèè, tacó bà taa gbí cû mì wó gî. Yí bà kili cèe njì cû mì wó mí gbí gálá, bìndi  yí bà giì doo ndâ póṛó cû, ta zè cû ta wu búdúú gî.» ");
INSERT INTO ndz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gbí ndâ o tí nò si Jòvánì kû caka tí ndâ ꞌduù á tàbèꞌdè Jòròdánìyà nò, Jézù giì njè nó ꞌdo Gàlìléyà ya gí mì wó tacó yí ꞌví caka tí yì. ");
INSERT INTO ndz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Káa Jòvánì giì bàkà bà ꞌvìsì muu Jézù ꞌdo tí có tí nò, ta bà ꞌdè có ji yí, máa, «Àá kùtàá a wò ká bà caka tí ye, káa à kpónó giì dù ndíi a wò ká giì gì gí mì ye máa ye caka tí lo!» ");
INSERT INTO ndz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Káa Jézù giì ꞌvìsì có ji Jòvánì, máa, «Ndà si mítí ŋìnò mì ye nó kpónó. À nìkì máa ndà bàkà go có mì Mbíṛì.» Jòvánì mâ giì ꞌdi có tí nò, yí giì lò muu gìṛì ji Jézù gî. ");
INSERT INTO ndz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bìndi  yí giì caka tí Jézù. Káa Jézù mâ giì co gí sè ꞌdo tà ngo á bìndi bà caka tí wó mì Jòvánì, yí ngé giì ŋò njekèjì tàṛì njaanga tí gî. Bìndi  yí giì ŋò Bèṛi-mì-Mbíṛì kû gì gí muu wó go kùlè nô. ");
INSERT INTO ndz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bìndi  yí giì ꞌdi kòcò ꞌduù kû ꞌdè có ꞌdo gbíṛì máa, «Ŋìnó a ꞌdóó kpóló-kpolo ꞌviì mì ye náa tàkòcò ye peteke gítí wó ngé ndii gî ká nô.» ");
INSERT INTO ndz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bèṛi-mì-Mbíṛì giì a tàmuu Jézù á bìndi bà caka tí wó mì Jòvánì ya tí  gí gbí kángáá nga ngoò, tacó wàa Gba-vò-i ꞌví tala yí. ");
INSERT INTO ndz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jézù giì dù gbí kángáá nga ngoò kû kònò go co gbí go ṛi, co gbí bèbìlì, ta sili ziꞌduù-só. ");
INSERT INTO ndz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Gba-vò-i mâ giì ŋò máa, bà  cee ꞌdo mì Jézù ta go gî, gî, yí giì gì gí mì Jézù. Bìndi  yí giì tala yí, máa, «Wò dú má káa ꞌviì mì Mbíṛì, ꞌdè có ji ndâ díí tí nò máa ndú ꞌvìsì tí ndú tí ndâ kù kô.» ");
INSERT INTO ndz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Káa Jézù giì ꞌvìsì có ji Gba-vò-i, máa, «À cu mí gbí wáràgà mì Mbíṛì máa, ‹ꞌDuù kû ꞌvala me ká ta kù kô cuki lá, yí kû ꞌvala a i ta có ŋìnó mbe co ꞌdo gbí nje Mbíṛì,› nô.» ");
INSERT INTO ndz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bìndi  Gba-vò-i giì te Jézù ꞌdo gbí kángáá nga ngoò ya tí  gí gbí gbata Jèrùzàlémè, yí giì te yí ngé déꞌvéléé mí pí ꞌbá-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bìndi  yí giì ꞌdè có ji yí, máa, «Wò dú má káa ꞌviì mì Mbíṛì, o gí to, tacó à cu mí gbí wáràgà mì Mbíṛì énó máa, ‹Mbíṛì bà tuu ndâ basìlì gí bà lì ꞌbì ndú mí tà tí lo, tacó wò má ꞌdò kò lo mí to, díí ꞌví kpò kò lo lá.› » ");
INSERT INTO ndz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Káa Jézù giì ꞌvìsì có ji Gba-vò-i, máa, «À delè ngbá cu mí gbí wáràgà mì Mbíṛì énó máa, ‹Wò ꞌví tala Mbíṛì mì lo tí Mbe tí lo lá.› » ");
INSERT INTO ndz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bìndi ŋìnò, Gba-vò-i giì te Jézù ꞌdo muu ꞌbá-Mbíṛì, yí giì ꞌdò ta yí ya gí pí ꞌbí cèe njà gú. Bìndi  yí giì tùbà ndâ kpo-kpò bàndò á muu to tí nó ꞌdáá gî, ta ndâ ŋa ndâ banga i tí nó náa à gbí ndú nó ꞌdáá gî ji yí. ");
INSERT INTO ndz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jézù mâ giì ŋò ndú gî, Gba-vò-i giì ꞌdè có ji yí, máa, «Ye bà je ndâ i tí nò ꞌdáá gî náa wò kû ŋò nò ji wò tí ndâ ŋìndi lo, náa wò má kucuku muungbó lo mí kùṛo ye, wàa wò ꞌví ùlù ye gî, nò.» ");
INSERT INTO ndz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Káa Jézù giì ꞌvìsì có ji Gba-vò-i, máa «Ya ꞌdo tí ye gî, ndí lo Gba-vò-i, tacó à delè ngbá cu mí gbí wáràgà mì Mbíṛì máa, ‹Ùlù káa gbèe Mbíṛì mì lo tí Mbe tí lo. Wò delè ꞌví bàkà ká go có mì wó cuki.› » ");
INSERT INTO ndz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ꞌDo bà-i-nò, Gba-vò-i giì njè nó ꞌdo tí Jézù gî. Bìndi  ndâ basìlì mì Mbíṛì giì kaa gì kû kpolo tí wó. ");
INSERT INTO ndz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ta ꞌbí o gbaànjé bìndi o bà caka tí Jézù mì Jòvánì, Èródè tí gbolò gba mì ndâ Jùdéyà giì zèè Jòvánì mí gbí zàà. Jézù mâ giì ꞌdi có máa à zèè Jòvánì tí mbe caka tí ndâ ꞌduù mí gbí zàà gî, yí giì dele ndi wó ꞌdo gbí to Jùdéyà ya gí gbí to Gàlìléyà. ");
INSERT INTO ndz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Bìndi  yí giì ꞌdòkò ꞌdo gbí gbata Názàrètì ya gí Kàpàrànáwùmù tí ꞌbí gbata á yì kàpá Gàlìléyà, gbí òkò tí ndâ kòtí Zèbùlúnì ta kòtí Nàfìtálì, ");
INSERT INTO ndz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","go có tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì ꞌdè sàà gî, máa, ");
INSERT INTO ndz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ndâ ꞌduù kòtí Zèbùlúnì, ta ndâ ꞌduù kòtí Nàfìtálì, ta ndâ ꞌduù mbe sì ꞌbá tí kpokèjì gbolò ngo, ta ndâ mbe sì ꞌbá me ꞌdú tìto Jòròdánìyà, ta ndâ ꞌduù ŋìnó mbe ꞌdó-ꞌdo mbe gì ta ꞌbá gí Gàlìléyà, ");
INSERT INTO ndz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","tí ndâ ꞌduù tí nó táánò mbe kû ꞌvala gbí ꞌdíꞌdiꞌo nó, kpónó ꞌdáá ŋò gbolò ngbaꞌo gî. Ndú táánò ꞌdáá gî kû ꞌvala gbí vò i, káa Mbíṛì kpónó je à-cee-gî gítí ndâ vò i mì ndú gî,» nô. ");
INSERT INTO ndz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ꞌDo tí o tí nò, Jézù giì ꞌbìtà bà ma có ji ndâ ꞌduù, máa, «Yo ꞌvìsì muu yo ꞌdo tí ndâ vò i mì yo, tacó kùṛo o bà gì Gba-gbíṛì kpónó dooko gî.» ");
INSERT INTO ndz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ta ꞌbí o gbaànjé si Jézù kû nò nó ta yì kàpá Gàlìléyà, yí giì ŋò ndâ ꞌbí ꞌdakò sósòꞌô ta náꞌvindí wó, tí ndâ mbe gò ngo, ndâ Sìmónè náa à kû nì mítí wó a Pìyétòrò ta náꞌvindí wó Àndèréyà, kû ꞌva mbu. ");
INSERT INTO ndz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Bìndi  yí giì ꞌdè có ji ndú, máa, «Yo gì gí tàkò ye, wàa ye ꞌví bàkà yo tí ndâ mbe pà ndâ ꞌduù ji Mbíṛì á bìndi  bà pà ndâ sè.» ");
INSERT INTO ndz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ndú só ngé bà-i-nò giì kaa ndâ mbu mì ndú ꞌdo ꞌbì ndú mí to, bìndi  ndú giì njè nó ya gí bà ꞌbìtà nèté bà ṛu ndi Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jézù mâ giì yèè gí kùṛo ꞌdo tí bàndò bà ꞌde ndâ Sìmónè ta Àndèréyà nò, yí giì ŋò ndâ ꞌbí ꞌdakò kákáꞌi sósòꞌô ta náꞌvindí wó. Ndâ Jákòmò ta náꞌvindí wó Jòvánì tí ndâ ꞌviì mì ꞌbí ꞌdakò ta ṛè wó a Zèbìdéyò, kû eṛe gbí ndâ mbu mì ndú gbí gbâ ta ndâ bu ndú. Bìndi  Jézù mâ giì tèꞌé tí ndú, ");
INSERT INTO ndz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ndú giì jee ndâ mbu mì ndú mí gbí gbâ ji bu ndú, bìndi  ndú delè giì kaa ya gí gbí nèté bà ṛu ndi Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Bìndi bà tèꞌé tí ndâ Sìmónè ta Àndèréyà, ta ndâ Jákòmò ta Jòvánì mì Jézù, yí giì dù kû nò cèe gbí ndâ gbata gbí to Gàlìléyà ꞌdáá gî, kû nìbà i ji ndâ ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì, delè ta bà ma Banga-Ngú-Có gítí bà dù Mbíṛì tí gba ji ndú. Delè ta bà ꞌvala ndâ ꞌduù ꞌdo gbí ŋa ndâ nòꞌo ta ndâ ŋa ndâ séꞌi ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ṛè wó giì wu to ya me ꞌdú cee gbí ndâ to á Sírìyà ꞌdáá gî. Tacó énò, ndâ ꞌduù giì kaa ndâ mbe nòꞌo, ta ndâ ꞌduù ŋìnó mbe kû ci célè sé gbí dìì ndú nó, ta ndâ ꞌduù ŋìnó ta ndâ i-gbí-muu ndú nó, ta ndâ mbe bê, ta ndâ ꞌduù ŋìnó mbe gbeleꞌve gî nó gì tí  ji yí bìndi  yí, giì ꞌvala ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ndâ ꞌduù ta o tí nò me mbè giì kaa kû ṛu ndi wó ꞌdo gbí ndâ to me mbè, ꞌdo Gàlìléyà, ꞌdo tí ꞌbí wúngbó to ta ndâ gbata tí  muuꞌbì, náa à kû nì mítí  a Ndâ-gbata-muuꞌbì, ꞌdo tìto Jòròdánìyà, ꞌdo Jèrùzàlémè, delè ꞌdo gbí sè ndâ ꞌbí to Jùdéyà ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ta o tí nò, ndâ ꞌduù kili me mbè. Jézù mâ giì ŋò ndú, yí giì njè nó ya gí bà ki tí wó to pí gú ta kpéétí wó. Ndâ mbe tala có mì wó giì kaa ya gí tàkò wó pí gú kà. ");
INSERT INTO ndz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bìndi  yí giì ꞌbìtà bà nìbà i ji ndú, máa, ");
INSERT INTO ndz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ndâ mbe ŋò tí ndú ni tí ndâ mbe yê kùṛo Mbíṛì gî, a ndâ mbe tó pá, tacó ŋìnò a ŋa ndâ ꞌduù mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ndâ mbe kû kònò séꞌi gbí njembí ndú gítí ndâ i ŋìnó náa ndú bàkà  mbe kû bèè ṛo Mbíṛì á muu to tí nó a ndâ mbe tó pá, tacó Mbíṛì bà yìì ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ndâ mbe ꞌdê njembí a ndâ mbe tó pá, tacó a ndú ká bà ꞌde ndâ tó i tí nó náa Mbíṛì ci ndâ ꞌduù mì wó gítí  nô. ");
INSERT INTO ndz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ndâ mbe kû kònò go, delè mbe kû gee go ngo tacó bà co tí jáá kpokèjì mì Mbíṛì ta o ꞌdáá gî a ndâ mbe tó pá, tacó Mbíṛì bà je ndâ i ŋìnó ta go ndú gbí njembí ndú nó ji ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ndâ mbe si có gítí ndâ vò i tí nó náa ndâ ꞌbí ka ndú bàkà gítí ndú nó mí to a ndâ mbe tó pá, tacó Mbíṛì bà si có gítí ndâ vò i mì ndú delè mí to gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ndâ mbe dù tí ndâ bòò mì Mbíṛì ta njembí ndú gbaànjé a ndâ mbe tó pá, tacó a ndú ká bà ŋò Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ndâ mbe dù tí ndâ mbe jukì gbí òkò tí ndâ ꞌduù a ndâ mbe tó pá, tacó ṛè ndú bà dù a ndâ ꞌviì mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ndâ ꞌduù ŋìnó náa à kû mèèkèꞌi tí ndú á muu có bà bàkà ndâ i ŋìnó mbe nìkì tí Mbíṛì nó a ndâ mbe tó pá, tacó ŋìnò a ndâ bòò-gba mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«À tí yo a tó pá, ta o tí nó náa ndâ ꞌduù má kû ŋo ndi yo, à tí yo delè a tó pá ta o tí nó náa ndú má kû mèèkèꞌi tí yo, ta bà ꞌdè ndâ zu có ta ndeṛè ndú wálá mítí yo á muu ye, ");
INSERT INTO ndz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","yo ꞌví dù ta líkíꞌo tí yo, yo delè ꞌví dù ta pétékè tàkòcò yo, tacó Mbíṛì bà ko mboo ndâ vò i tí nò náa á kû me mítí yo nò ji yo ta gbolò tó i. Delè tacó àá táánò kû mèèkèꞌi tí ndâ mbe ꞌdòkò có mì Mbíṛì á kùṛo bà jò yo ká go ŋa ŋìnò náa à kû me ta yo nò. ");
INSERT INTO ndz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Yo go zi gbí mbí zi mì ndâ ꞌduù á muu to tí nô. Káa gó ngo zi má cì cee ꞌdo gbí tè zi gî, à kû te tè zi nò yee ká gí ꞌdè, tacó kpokèjì bà dele ta gó zi gí gbí  kákáꞌi wálá. ");
INSERT INTO ndz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yo delè go ngbaꞌo kùṛo ndâ ꞌduù muu to tí nó ꞌdáá gî. Yo delè go ꞌbá náa à bì mí pí gú, náa ndâ ꞌduù ꞌdáá gî kû ŋò . ");
INSERT INTO ndz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ndâ ꞌduù má òlò wu ta ꞌdíꞌdiꞌo mí tàꞌi, ndú ꞌbu i mí ṛo ngba wu lá. Ndú si ká ngbàà, tacó bà ŋò ta ndâ i tàꞌi ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Má énò, yo tù ngba yo ta bà bàkà tó i go ngba wu mí kùṛo ndâ ꞌduù ꞌdáá gî. Tacó ndú má ŋò ndâ tó i tí nó náa yo kû bàkà nó, ndú ꞌví ùlù Bu yo á gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Ndâ ꞌbí ꞌduù gbí òkò tí yo kû koṛo có énó máa, ye gì tacó bà njaanga miṛi yo ꞌdo gbí ndâ có mì Mòze, ta ndâ i ŋìnó náa ndâ mbe ꞌdòkò có mí Mbíṛì táánò nìbà ndú ji ndâ ꞌduù nô. Káa ŋìnò me ndeṛè bà gì ye gbaànjé ká nò lá. Ye gì a i tacó wàa ndâ có mì Mòze, ta ndâ i ŋìnó ꞌdáá náa ndâ mbe ꞌdòkò có mì Mbíṛì nìbà ndú ji ndâ ꞌduù nó ꞌví dù tí  tí yúcó. ");
INSERT INTO ndz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yo te mí gbí muu yo, máa, ndâ to tí nó ta tàṛì má ká kuu bàndò mì ndú, ndâ i bà bàkà tí go ndâ có mì Mòze ta ndâ có mì ndâ mbe ꞌdòkò có mì Mbíṛì gbaànjé gbaànjé ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Má énò, ꞌbí ꞌduù má biya bà ꞌdi kpêtí káa ꞌbí làmbu có gbaànjé cuki ꞌdo gbí òkò tí ndâ có tí nò, bìndi  yí giì nìbà ŋa kpokèjì tí nò ji ndâ ꞌbí ꞌduù, ꞌduù tí nò bà dù tí táángbà ꞌduù gbí òkò tí ndâ bòò-gba mì Mbíṛì wálá. Káa ꞌduù má ꞌdi ndâ có tí nò ꞌdáá gî ta bà mò ꞌbí  gí nje seè máa, ‹Ŋìnò a làmbu có,› nò lá, bìndi  yí giì nìbà ndú ji ndâ ꞌbí ka wó, ꞌduù tí nò bà dù tí gbolò ꞌduù kùṛo ndâ ꞌduù mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yo koṛo muu yo delè máa, ꞌduù má dù ta go bà bàkà ndâ i ŋìnó mbe nìkì tí Mbíṛì nó me gbolò ndii ndâ mbe ꞌdi gbí-o tí ndâ mbe kû kpolo tí tàkìì mì yo tí ndâ Jùdéyà nò lá, ꞌduù tí nò jé gí bà dù tí ꞌduù mì Mbíṛì wálá. ");
INSERT INTO ndz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Yo ꞌdi có tí nó náa Mòze táánò ꞌdè ji ndâ ká gù ndoo, máa, ‹Yo ꞌví zi ꞌduù lá,› nó gî; káa ꞌduù má zi ku, ndâ gba bà waa có ku mítí wó delè. ");
INSERT INTO ndz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Káa ye kû ꞌdè có ji yo, máa, ꞌbí ꞌduù má ò kòlòwò gítí ꞌbí ka wó, Mbíṛì bà ꞌvee gbí nje wó ta ꞌbí wúnò o gítí ndeṛè kòlòwò tí nò. ꞌBí ꞌduù delè má go ꞌbí ka wó máa yí a ŋónókó tí gbàꞌdá sínò, yí kû yuu a miṛi wó ta kpéétí wó gí gbí wu á bàndò mì ndâ vò ꞌduù á bìndi  ku mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Má énò, wò má kû je i-ꞌbì lo ji Mbíṛì, káa mbí lo giì ꞌva tí  máa, ndeṛè kòlòwò mì ꞌbí ꞌduù ta wò kuu, ");
INSERT INTO ndz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","te i-cí-ci tí nò mí to, bìndi  wò ꞌví ya gí mì ꞌduù nò. Yo máa ꞌviindi gbí òkò tí yo ta yí gî, wò ꞌví giì ya ta i tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Có má gbí òkò tí yo ta ꞌbí ꞌduù káa yí giì ꞌdè có máa yì bà ya gí bà kpì ngbàngà tí lo ji gba, à nìkì máa yo ꞌdè có tí nò cee ꞌdo gbí òkò tí yo ta kpéétí yo ta yì só, si yo yee kùṛo ndâ gba kálásê. Tacó yí má tù wò ji ndâ gba gî, ndâ gba bà je wò ji ndâ àsìkérì, bìndi  ndú bà te wò á mí gbí zàà. ");
INSERT INTO ndz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gbí  énó máa, wò bà dù gbí zàà yee tí o tí nó náa wò sì có tí nó náa a waa mítí lo nò ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Yo ꞌdi có tí nó náa Mòze táánò ꞌdè ji ndâ ká gù ndoo, máa, ‹Yo ꞌví bàkà bangbaya lá,› nó gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Káa ye kpónó kû ꞌdè có ji yo, máa, ꞌbí ꞌduù má zekeꞌo tí niì, bìndi  yí giì tee njembí wó gáꞌdáá mítí wó, gbí  énó máa, yí zingbà ta niì tí nò gbí njembí wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","À máa ṛo lo ŋìnó gbí kùꞌbì nó ká eendi lo gítí bà bàkà vò i, aaka ṛo lo tí nò ꞌdo gbí kù kélè, wò ꞌví ꞌva gí ꞌdè. À nìkì a bà bè gbí ꞌbí bà to tí lo gbaànjé á co tí bà ꞌva wò mì Mbíṛì ta kábà dìì lo mí gbí vò bàndò á bìndi ku mì lo. ");
INSERT INTO ndz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","À máa ꞌbì lo kùꞌbì ka kû si wò ꞌví bàkà vò i, da ꞌbì lo tí nò ꞌva gí ꞌdè. À nìkì a bà bè gbí ꞌbí ꞌbì lo gbaànjé á co tí bà ya ta kábà dìì lo gí gbí vò bàndò á bìndi ku mì lo. ");
INSERT INTO ndz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Mòze delè táánò ꞌdè có ji ndâ ká gù ndoo, máa, ‹ꞌDuù má bà njè niì mì wó, yí ꞌví cu ndeṛè bà njè tí ndú mí gbí wáràgà wàa yí ꞌví je mí ꞌbì niì tí nò.› ");
INSERT INTO ndz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Káa ye kpónó kû ꞌdè có ji yo, máa, ꞌbí ꞌduù má nje niì mì wó á muu ꞌbí tende có á bìndi có bà zingbà ꞌdakò, yí njaanga ji niì nò a kpokèjì bà zingbà ꞌdakò. Káa ꞌbí ꞌduù má giì kò niì tí nò á bìndi wó, ꞌduù tí nò kû zi a ngbà ta niì tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Ndâ ká gù ndoo delè táánò ꞌdè ji ndoo gî, máa, ‹ꞌDuù ꞌví see tí wó ji Mbíṛì ta ꞌvéṛè lá. Máa, wò tí ꞌduù má see tí lo ji Mbíṛì máa wò bà bàkà ꞌbí i, kózò tí lo ꞌví bàkà ká go po ngo nje lo nò.› ");
INSERT INTO ndz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Káa ye kpónó kû ꞌdè có ji yo, máa, yo ꞌví see tí yo ngé gî lá. Yo see tí yo, máa, ‹Go gbíṛì› lá, tacó gbíṛì a bàndò bà te jàlàmbà mì Mbíṛì tí gba. ");
INSERT INTO ndz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yo ꞌví see tí yo, máa, ‹Go to tí nó,› nò lá, tacó to tí nó a bàndò bà kaa kò Mbíṛì mí pí . Yo ꞌví see tí yo, máa, ‹Go Jèrùzàlémè› lá, tacó Jèrùzàlémè a gbolò gbata mì Gbolò Gba. ");
INSERT INTO ndz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yo delè ꞌví si bà see tí yo, máa, ‹Go muu ye› nò mí to, tacó wotí mì yo gítí bà si ꞌbí njì se muu yo gbaànjé ꞌví dù tí béé-bè , wàa ꞌbí  ꞌví tù undù nò wálá. Má énò, ye kû ꞌdè có ji yo máa, gbí ndeṛè bà see tí yo wálá. ");
INSERT INTO ndz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wò tí ꞌduù má bàkà i gî, ꞌdè káa có máa wò bàkà gî. Káa à tà má énò lá, wò delè ꞌví ꞌdè káa có máa wò bàkà wálá cuki. Tacó ꞌbí ŋa có mbe jò ògbù ndii ŋìnò gî, gì a i ꞌdo mì Vò-ꞌduù-tí-nò. ");
INSERT INTO ndz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«ꞌBí có kákáꞌi náa ndâ ká gù ndoo delè táánò ꞌdè ji ndoo a ŋìnó, máa, ‹Ṛo ta ṛo, wàa tì ta tì.› ");
INSERT INTO ndz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Káa ye kû ꞌdè có ji yo máa, yo ꞌví ko mboo vò i ta vò i lá. ꞌDuù má gbì gbí tù lo ŋìnó gbí kùꞌbì nó, wò ꞌví ꞌvìsì tù lo ŋìnó gbí gàlì nó ji yí, wàa yí ꞌví gbì delè. ");
INSERT INTO ndz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ꞌDuù delè má kpì ngbàngà tí lo ji ndâ gba, máa wò ja ndò bòngo tí nó náa wò kû yuu mì gbímbí lo á tà bòngo nó ji yì, ja ꞌdóó wòòkò bòngo tí nó náa wò kû yuu mì pí ndò bòngo tí nò nó ji yí gí tàkò ndò ŋìnò kpêkù. ");
INSERT INTO ndz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ꞌBí ꞌduù delè kpêtí má zèè wò gítí có gba tí wó, máa wò te káꞌi mì yì ya tí  gàà énó, te , wò ꞌví ko ta yí ndii to tí nò náa yí nì ji wò nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ꞌBí ꞌduù mbe zì i ꞌdo tí lo sàà kùṛo gî, má yù i ꞌdo tí lo, je i tí nò náa yí yù nò ji yí. Káa ꞌbí ꞌduù delè mbe biya bà wùù i ji wò sàà kùṛo gî, má gì tacó bà wùù i ꞌdo mì lo, wò ꞌví biya lá. ");
INSERT INTO ndz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ndâ ká gù ndoo táánò ꞌdè có máa, ndoo ꞌví zè ndâ mbe bàkà tó i ji ndoo nìkì maa, wàa ndoo ꞌví sogo ndâ mbe bàkà vò i ta ndoo. ");
INSERT INTO ndz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Káa ye kpónó kû ꞌdè có ji yo, máa, yo delè ꞌví zè ndâ mbe bàkà vò i ta yo nìkì go bà zè ndâ mbe bàkà tó i ji yo. Yo delè ꞌví ꞌdeke tí yo ji Mbíṛì máa yí ꞌví bàkà nambeè ji ndâ mbe kû mèèkèꞌi tí yo. ");
INSERT INTO ndz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yo kpolo tí có tí nó náa ye kû ꞌdè ji yo nô, tacó wàa, yo ꞌví dù tí ndâ mbe bàkà tó i go i mì Bu yo Mbíṛì á gbíṛì, tí mbe si ṛi kû co ta ngba wó ji ndâ tó ꞌduù ta ndâ vò ꞌduù, delè mbe si mù kû nì mí gbí njí mì ndâ tó ꞌduù ta ndâ vò ꞌduù ꞌvii ká ꞌvii. ");
INSERT INTO ndz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Káa yo má zè nìkì maa káa ndâ ꞌduù ŋìnó mbe kû zè yo nìkì maa nó cuki, ndeṛè bà bàkà tó i mì Mbíṛì ji yo ꞌví dù a yè? Ŋìnò me gbèe ŋa i tí nó náa ndâ ꞌduù ŋìnó náa a kû ꞌdè máa ndú a ndâ vò ꞌduù nó kû bàkà lá? ");
INSERT INTO ndz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yo delè má ꞌvee káa ꞌbì ndâ nambe yo cuki, ꞌbè gbí òkò tí yo ta ndâ ꞌbí ŋa tende ŋa ndâ ꞌduù ꞌví dù a yè? ");
INSERT INTO ndz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","«Má énò, yo dù ta tó muu yo, tacó Bu yo á gbíṛì a ꞌduù ŋìnó ta tó muu wó! ");
INSERT INTO ndz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Yo kpolo tí yo, máa yo ꞌví gbaa tí yo ta o tí nó náa yo má kû bàkà tó i ta ṛè mì Mbíṛì nó ji ndâ ꞌduù tacó wàa ndú ꞌví ŋò yo, nò lá. Yo má bàkà énò, Bu yo tí Mbíṛì á gbíṛì bà ko mboo ndâ tó i tí nó náa yo bàkà nó ji yo wálá. ");
INSERT INTO ndz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Má énò, yo má kû konì ndâ mbe yê, yo ꞌví si bà kò-kò tí  ji ndâ ꞌduù mí to. Yo delè ꞌví gbaa tí yo tí  go ŋa i mì ndâ mbe bàkà nambeè-ṛo náa ndú kû bàkà ta ndi tí ndâ bàndò bà kili ndâ ꞌduù, delè ta ndi tí ndâ kpokèjì, tacó bà tù ngba ndú wàa ndâ ꞌduù ꞌví wu ta gbí ndâ yì, nó lá. Yo kpolo tí yo, máa ꞌbí tó i náa ndú kákáꞌi gí bà ꞌde ꞌdo mì Mbíṛì gí tàkò ndâ i mì ndú náa ndú bàkà nò á bìndi bà wu gbí ndú mì ndâ ꞌduù á muu to tí nó, nó wálá. ");
INSERT INTO ndz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yo má kû konì ndâ mbe yê, yo ꞌví bàkà gbí kóó, tacó wàa, à kpêtí káa ndâ kpóló-kpolo kómbe yo, ndú ꞌví ŋò lá. ");
INSERT INTO ndz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yo konì ndâ mbe yê mí tàbèngìì, tacó Bu yo tí mbe kû ŋò ndâ i tí nó náa yo kû bàkà ta kpéétí yo á tàbèngìì nó ꞌví ko ta mboo tàkò ndú ji yo. ");
INSERT INTO ndz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ta o tí nó náa yo má kû ꞌdeke tí yo ji Mbíṛì nó, yo ꞌví si bà koṛo có bà bàkà go ŋa i mì ndâ mbe nambeè-ṛo, náa ndú kû ṛò tíyò á kùṛo ndâ ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì, delè ta ndi tí ndâ bà njèè ndâ kpokèjì náa ndâ ꞌduù kû ꞌva có tí  me mbè tacó wàa ndú ꞌví ŋò ndâ yì, nó lá. Yo te mí gbí muu yo máa, tó i náa ndú bà ꞌde gbí ŋa bà ꞌdeke tí ndú nò káa bà wu gbí ndú mì ndâ ꞌduù á muu to tí nó cuki. ");
INSERT INTO ndz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ta o tí nó náa yo má kû ꞌdeke tí yo á ji Mbíṛì nó, yo ꞌví yèè ndi yo á gí ndiì ꞌdo gbí òkò tí ndâ ꞌduù ta kpéétí yo, wàa yo ꞌví ꞌdeke tí yo ji Bu yo tí nó náa yo ŋò yí ta ṛo yo lá nô, bìndi  Bu yo tí mbe kû ŋò ndâ i tí nó náa à kû bàkà ndú gbí kóó nó, bà ko mboo bà ꞌdeke tí yo nò ji yo. ");
INSERT INTO ndz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yo delè ꞌví si bà ꞌdeke tí yo ta bà ꞌvanda mbè có cúú-cu-cù ta gbí  wálá go i mì ŋa ndâ ꞌduù ŋìnó mbe ŋò dúú kpokèjì bà bàkà nambeè ta Mbíṛì ni lá, nó mí to. Tacó ndâ ŋa ndâ ꞌduù tí nô kû koṛo có máa, Mbíṛì kû sè tù wó tí bà ꞌdeke tí ndâ yì tacó ndâ yì ni bà ꞌvanda có ngé má. Káa, à me énò là. ");
INSERT INTO ndz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yo mèlè ndi ndú lá. Tacó yo tà kpêtí má zi tí yo ta bà ꞌvanda mbè có lá, Bu yo tí Mbíṛì ŋò ŋa i tí nó mbe ꞌvii ta yo nó ni sàà á kùṛo o bà ꞌdeke tí yo nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Má énò, yo ꞌví ꞌdeke tí yo ká go énó máa, ‹Bu ze mbe kû dù gbíṛì, à ùlù ṛè lo. ");
INSERT INTO ndz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gì gí bà dù tì gba. À ꞌví bàkà go có mì lo á muu to tí nó, á go ŋìnó gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Je i-zó-zò mì ze náa ze kû zò ta ṛì ꞌdáá gî nó wúnó ji ze. ");
INSERT INTO ndz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wò delè ꞌví si có gítí ndâ vò i mì ze mí to go ŋìnó náa ze si ta có gítí ndâ vò i mì ndâ ꞌbí ka ze mí to gî nô. ");
INSERT INTO ndz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wò delè ꞌví si ze mí gbí ndâ i ŋìnó mbe kû eendi ze gítí vò i nó lá. Káa wò ꞌví ja ze á ꞌdo ꞌbì Vò-ꞌduù-tí-nò gî.› ");
INSERT INTO ndz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Yo má si có gítí ndâ vò i ŋìnó náa ndâ ꞌbí ꞌduù bàkà mítí yo nó mí to gî, Bu yo tí nó á gbíṛì nó bà si có gítí ndâ vò i ŋìndi yo mí to delè gî. ");
INSERT INTO ndz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Káa yo má biya bà si có gítí ndâ vò i ŋìndi ndâ ꞌbí ka yo mí to gî, Bu yo bà si có gítí ndâ vò i ŋìndi yo mí to delè wálá. ");
INSERT INTO ndz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ta o tí nó náa yo má kû kònò go tacó bà ꞌdeke tí yo ji Mbíṛì nó, yo ꞌví volo gbíṛo yo go ŋa i mì ndâ mbe nambeè-ṛo, nó lá. Ndú kû kpili gbíṛo ndú, tacó wàa, ndâ ꞌduù ꞌví ŋò tí  ni énó máa, ndâ yì kû kònò go. Yo te mí gbí muu yo, máa, ndú ꞌde i tàkò nèté mì ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ta o tí nó náa yo má kû kònò go nó, yo ꞌví te banga ta bà ꞌviindi se muu yo, ta bà toṛo bàà mí gbíṛo yo, ");
INSERT INTO ndz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tacó wàa, à káa Bu yo tí mbe kû ŋò ndâ i ŋìnó mbe kû bàkà tí gbí kóó nó cuki ká ꞌví ŋò ni . Bìndi  Bu yo tí mbe ŋò ndâ i ŋìnó ꞌdáá náa à kû bàkà ndú tàbèngìì nó bà je tó i ji yo. ");
INSERT INTO ndz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Yo si bà koṛo có kpolo ma ká gítí bà bì gálá, wàa yo ꞌví kili ndâ i mì yo mí gbí  mí muu to tí nó cuki mí to. Tacó ndâ ki, ta ndâ sû, ta ngbàza bà mìì ndâ i tí nò gî. Ndâ mbe ngbà delè bà ngbà ndâ ꞌbí  gî. ");
INSERT INTO ndz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","À nìkì go énó máa, yo je mbí yo kpolo a i gítí bà bì ndâ gálá bà kili ndâ i mì yo a i mí gbíṛì, tí bàndò tí nó náa ndâ i gbì ngbàza tí  lá, ndâ ki mbe kû da i, ta ndâ sû mbe kû pìì i, ta ndâ ꞌduù mbe kû ngbà i delè á kà wálá nô. ");
INSERT INTO ndz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tacó njembí ꞌduù ta o ꞌdáá gî kû dù ká tí bàndò ŋìnó ta ndâ i mì wó kû dù tí  nô. ");
INSERT INTO ndz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Ṛo ꞌduù a kùpò mì dìì wó. Ṛo ꞌduù má kû zekeꞌo ngbáṛángàꞌi, gbí  énó máa, dìì wó ꞌdáá gî gbí ngbaꞌo; ");
INSERT INTO ndz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","káa ṛo ꞌduù má zekeꞌo nìkì maa lá, dìì wó ꞌdáá gbí ꞌdíꞌdiꞌo. Káa ṛo ꞌduù má yoo gî, o bà me ji yí a njíkiṛí. ");
INSERT INTO ndz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«ꞌBí ꞌduù jé mbe bàkà nèté ji ndâ ꞌduù sósòꞌô ta njembí wó gbaànjé nò wálá. Yí má zè ꞌbí ꞌduù gbaànjé nìkì maa, yí bà dù ta ꞌbí  me ta njembí wó dúú-dúú lá. Yí má kû te duù mítí ꞌbí ꞌduù gbaànjé, yí bà si ꞌbí ka wó tí i maa-maa wálá. Má go énò, wotí bà zèè Mbíṛì ta ndâ i muu to tí nó ꞌdáá gî ta njembí lo gbaànjé delè wálá. ");
INSERT INTO ndz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Má énò, ye kû ꞌdè có ji yo, máa, njembí yo ꞌví si bà mù gítí bà ꞌvala yo, máa, ‹Ze taàbé ꞌví zò a yè! Ze taàbé bà njù a yè!› mí to. Yo delè ꞌví tee njembí yo mítí dìì yo, máa, ‹Ze bà yuu a ŋa yè, wè!› nò lá. À dú káa yúcó máa, có ꞌválá kpolo ndii có i-zó-zò gî, bìndi  có dìì ꞌduù kpolo ndii có bòngo gî. ");
INSERT INTO ndz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yo tala bà zeke káa ndâ nuù mbe kû o co gbí pípìṛi gi. Ndú jé ṛò njì ŋa lá. Ndú delè jé kili i ꞌdo gbí njí mí gbí gálá lá. Káa ta ŋa ŋìnò ꞌdáá gî, Bu yo tí nó gbíṛì nó kû ko ndú ta i-zó-zò. À kpónó má je ꞌbí ꞌduù gbaànjé, wàa à ꞌví je ꞌbí nuù gbaànjé, wàa à ꞌví ya gí bà mà ndú, àá bà ꞌde i me gbolò á i ꞌdo gbí ꞌdi? ");
INSERT INTO ndz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Káa ta ndâ bà gu tí yo tí nò ꞌdáá nò, ku kpónó má gì tacó bà zi ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí yo á kpónó mí to nò, wotí mì ꞌduù tí nò bà dù gítí bà ꞌdè có ji ku máa, yí si yì njíꞌdí gi, bà dù kuu tí ? ");
INSERT INTO ndz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Yo delè kû mù njembí yo tacó ndâ bòngo tacó yè? Yo tala káa bà zeke ndâ ꞌvì mû gbí jìlì gi. À tí ndú me ꞌbì bà gò bòngo lá. ");
INSERT INTO ndz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Káa ye kû ꞌdè có ji yo máa, à kpêtí káa Sólómònì, tí gbolò gba táánò náa àá mì wó a ndâ banga i mbe ògbù ta ŋa  wálá nó, yí jé yuu ꞌbí ŋa bòngo ta banga tí  ndii ꞌbí ꞌvì mû gbaànjé ꞌdo gbí òkò tí ndâ ꞌvì mû tí nò lá. ");
INSERT INTO ndz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Káa Mbíṛì má te ŋa banga tí nò mítí ndâ ꞌvì mbílì sínò, náa à taàbé dê nó bà doo ndú ta wu ꞌdáá gî, gî, yí bà je mbí wó gítí bà je bòngo ji yo wálá, ndâ mbe kpùṛù-kpùṛù njembí? ");
INSERT INTO ndz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Má énò, yo si bà mù mbí yo gítí có máa, ‹Ze wúnó bà zò a ŋa yè? Ze bà njù a ŋa yè? Ze bà ꞌde bòngo ngòó wè?› mí to! ");
INSERT INTO ndz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tacó à ꞌdáá nò a ndâ kpóló-kpolo ŋa bà koṛo có mì ndâ ꞌduù ŋìnó mbe tee njembí ndú mítí Mbíṛì lá nó ká nò. Bu yo tí nó á gbíṛì nó ŋò ŋa ndâ i ŋìnó tí ndâ kpóló-kpolo i tacó ꞌválá mì yo nó ni gî. ");
INSERT INTO ndz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Má énò, yo zèè kùṛo a có gítí bà dù tí ndâ ꞌduù mì Mbíṛì, ta có gítí bà bàkà ndâ i ŋìnó mbe lè á kùṛo Mbíṛì lá nó á má kózò gî, bìndi  a Mbíṛì ká bà wu sè ndâ i ŋìnó náa yí ŋò mbe ꞌvii ta yo nó ji yo delè. ");
INSERT INTO ndz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Má énò, yo si bà mù njembí yo gítí taàbé mí to. Tacó yo cee ta ndâ có ŋìndi wúnó lá. À káa taàbé ká bà ŋò ꞌdóó kpokèjì mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Yo ꞌviiki ndâ ꞌbí ka yo lá, tacó wàa Mbíṛì delè ꞌví ꞌviiki yo lá. ");
INSERT INTO ndz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tacó Mbíṛì bà ꞌviiki mítí yo káa cè ŋa bà ꞌviiki tí, tí nó náa yo ꞌviiki mítí ndâ ꞌbí ka yo nô. À delè bà ꞌvii i ji yo ká ta gbèe káꞌi bà ꞌvii i tí nó náa yo ꞌvii ta i ji ndâ ꞌbí ka yo nô. ");
INSERT INTO ndz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Má énò, wò kû ꞌdè có gítí njú-mû á tà ṛo ꞌbí ka lo tacó yè, káa kùsìlì-mû kuu kpùṛùꞌvù tà ṛo lo? ");
INSERT INTO ndz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wò bà ꞌde nje lo kòtí ꞌdi, wàa wò ꞌví ꞌdè ta có ji ꞌbí ka lo, máa njú-mû kuu tà ṛo wó, náa kùsìlì-mû má kuu kácá tà ṛo lo? ");
INSERT INTO ndz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ja a kùsìlì-mû tí nó mbe mbi mí tà ṛo lo nó kùṛo má kózò gî, bìndi  wò ꞌví giì òlò njú-mû ꞌdo tà ṛo nambe lo, ta ṛo lo ngbáṛángàꞌi, ndí lo mbe nambeè-ṛo. ");
INSERT INTO ndz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Je i-Mbíṛì ji ndâ bô lá. Ndú bà ꞌvìsì tí ndú bà ṛo wò. Wò delè ꞌví kaa banga njì wúꞌdè mí to á ꞌbá ta ndâ ngùù tí  lá, tacó ndú bà jaaka gbí  ta to. ");
INSERT INTO ndz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Wò má yù i ta njembí lo gbaànjé, àá bà je i tí nò ji wò gî. Wò má pà i ta njembí lo gbaànjé, wò bà ꞌde i tí nò gî. Wò má gbà njekèjì muu ꞌduù ta njembí lo gbaànjé, yí bà njaanga njekèjì ji wò gî. ");
INSERT INTO ndz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tacó à kû je i ta o ꞌdáá gî ji ndâ ꞌduù ŋìnó mbe yù i nô. Ndâ mbe pà i ta o ꞌdáá gî kû ꞌde i. Bìndi  à kû njaanga njekèjì ta o ꞌdáá gî ji ndâ mbe gbà njekèjì. ");
INSERT INTO ndz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ꞌViì mì ꞌbí ꞌduù ꞌdo gbí òkò tí yo nò kpónó má wa go mítí wó, ꞌduù tí nò bà je kpúṛú díí ji ꞌviì tí nò máa yí zò gî? ");
INSERT INTO ndz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ꞌViì mì ꞌbí ꞌduù gbí òkò tí yo nò kpónó má yù yâ-sè ꞌdo tí bu wó, ꞌduù nò bà je yâ-kpoo ta jâ kpoo tí  ji ꞌviì mì wó bìndi  yâ-sè gî? ");
INSERT INTO ndz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Káa ndâ vò ꞌduù, á go yo nò, má ni bà je tó i ji ndâ ꞌviì mì yo gî, Bu yo tí Mbíṛì á gbíṛì bà ni bà je tó i me gbolò ndii ndâ ŋìndi yo nò gî ji ndâ mbe yù i ꞌdo tí wó wálá? ");
INSERT INTO ndz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Co ta ndâ ꞌbí ka lo ká tí ŋa kpokèjì tí nó náa à gbí muu lo máa ndú ꞌví co ta wò tí  nô. Ŋìnò a gbí ndâ có mì Mòze, ta ndâ i tí nó náa ndâ mbe ꞌdòkò có mì Mbíṛì nìbà ndú ji ndâ ꞌduù nó, ká nò. ");
INSERT INTO ndz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Wò má ŋò kpokèjì gítí ꞌbá ṛú-ṛú-ṛú, co a i tí , kpokèjì tí nó ngáá-nga-ngà, náa ndâ ꞌduù me mbè kû ꞌva co tí  nó bà ya ta wò gí nje ku. ");
INSERT INTO ndz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Káa kpokèjì ꞌválá a làmbu kpokèjì tí nó ṛú-ṛú-ṛú, ta ndâ zèèngè i tí , náa ndâ ꞌduù me mbè là kû pembee tí ndú pembee co tí  nô. ");
INSERT INTO ndz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Yo kpolo tí yo ꞌdo tí ndâ sú mbe ma có mì Mbíṛì. Ndú kû bàkà tí ndú tí ndâ tó ꞌduù, káa ndú a cèe ndâ zò-ꞌboo. ");
INSERT INTO ndz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yo bà ŋò ndú ni ká ꞌdo tí ŋa bà bàkà ndâ i mì ndú, go bà ŋò ŋa mû ni ꞌdo tí ndo wó. Mû-bàà kû ṛì káa ndo bàà, bìndi  ꞌbelè kû ṛì káa ṛí ꞌbelè. ");
INSERT INTO ndz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tó mû kû ṛì káa tó ndo mû. Bìndi  vò mû delè kû ṛì káa vò ndo mû. ");
INSERT INTO ndz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tó mû bà ṛì vò ndo mû wálá, delè vò mû bà ṛì tó ndo mû wálá. ");
INSERT INTO ndz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Káa àá kèjì gí bà da mû ŋìnó mbe kû ṛì vò ndo mû nó, wàa à ꞌví doo ta wu. ");
INSERT INTO ndz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Má énò, yo bà ŋò ndâ sú mbe ma có mì Mbíṛì ni ꞌdo tí cè ŋa bà bàkà ndâ i mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Yo koṛo muu yo máa, ndâ ꞌduù ŋìnó mbe kû ꞌdè có máa ye a mbe tí ndâ yì ta tiṛì nó bà yee gbíṛì wálá. A káa ndâ mbe kû bàkà go có mì Bu ye ká bà ŋò gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ye kû ꞌdè có tí nò ji yo, tacó ndâ ꞌduù me mbè ta ndòngbú o wúnò bà ꞌvee ye gbí ngbàngà mì Mbíṛì, máa, ‹Ze táánò ma có mì Mbíṛì ta ṛè lo lá, mbe tí ze? Ze táánò mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ta ṛè lo lá? Ze táánò bàkà ndâ seṛè ta ṛè lo lá?› ");
INSERT INTO ndz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","«Bìndi  ye bà ꞌvìsì có ji ndú, máa, ‹Ye jé táánò ŋò yo ni lá. Yo co ꞌdo tí ye ngé gí kàzô, ndí yo ndâ vò ꞌduù.› ");
INSERT INTO ndz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Má énò, ꞌduù ŋìnó mbe ꞌdi ndâ có mì ye nò, bìndi  yí giì bàkà go ndâ có mì ye náa yí ꞌdi nò, go mbe bì ꞌbá ta muu tí wó, mbe bì ꞌbá mì wó mí pí díí. ");
INSERT INTO ndz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bìndi  mù giì nì mítí , ngo giì ò có tà , gbolò pípìṛi giì pì , káa ꞌbá tí nò ꞌva tí to lá, tacó à sè tà  mí pí díí. ");
INSERT INTO ndz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Káa ꞌduù ŋìnó mbe ꞌdi ndâ có mì ye nò, káa yí bàkà go ndú lá nó, go mbe ŋónókó mbe sè tà ꞌbá mì wó mí pí njì ngoò. ");
INSERT INTO ndz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mù mâ giì nì , ngo giì ò có tà , pípìṛi mâ giì pì ta wotí tí , ꞌbá tí nò giì kiꞌviki gí to, ꞌbùṛùkù gî.» ");
INSERT INTO ndz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jézù mâ giì cee bà ꞌdè ndâ có mì wó gî, nje ndâ ꞌduù ꞌdáá gî, giì ꞌdèè gî. ");
INSERT INTO ndz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tacó yí ꞌdè ji ndú ꞌdáá káa ndâ wu có mbe ya gí gbí muu ndú, me ndâ ꞌvìṛi có go i mì ndâ mbe ꞌdi gbí tàkìì mì ndú nó lá. ");
INSERT INTO ndz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ndâ Jézù ta ndâ mbè ndâ ꞌduù tí nó mbe kaa ya gí mì wó pí gú nó mâ giì kaa ꞌdo pí gú gì gí tàbù to gî, ");
INSERT INTO ndz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ꞌbí ꞌdakò tí mbe cì giì gì gí mì wó, bìndi  yí giì zèè kò Jézù ta bà ꞌdeke tí wó ji yí, máa, «Go bà yuku cì tí nó tí ye nó má kuu tí lo, wotí bà si kútí ye ꞌví dù ngbáṛángàꞌi kuu tí lo, buù.» ");
INSERT INTO ndz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jézù mâ giì ꞌdi có tí nò náa mbe cì tí nò ꞌdè nò, yí giì yaꞌva ꞌbì wó ya gí bà gbala ta yí, ta bà ꞌdè có, máa, «Go  kuu tí ye. Dù ta ngbáṛángà kútí lo.» À káa póó bà ꞌdè có tí nò mì Jézù, cì giì cee ꞌdo tí ꞌdakò tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bìndi  Jézù giì ꞌdè có ji yí, máa, «ꞌDi có tí nó náa ye kpónó bà ꞌdè ji wò nô. Ya kpédéléꞌi gí bà tùbà tí lo ji bu-Mbíṛì. Bìndi  wò ꞌví ci i ji Mbíṛì go có mì Mòze, tacó bà tùbà  ji ndâ ꞌduù máa cì cee ꞌdo tí lo gî. Wò ꞌví tùbà tí lo ji ꞌbí ꞌduù gbaànjé á kùṛo bà ya wò gí mí bu-Mbíṛì lá.» ");
INSERT INTO ndz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jézù giì njè nó ya gí gbí gbata Kàpàrànáwùmù. Mâ giì zekeꞌo, ꞌbí ꞌdakò tí kùṛo ndâ àsìkérì mì ndâ Ròmánò ziꞌduù-vô (100) giì gì gí mì wó, bìndi  yí giì ꞌdeke tí wó ji yí, máa, ");
INSERT INTO ndz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Bòò mì ye gbeleꞌve mí to ta sé gbí  tí wó ngé ndii gî, buù.» ");
INSERT INTO ndz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jézù mâ giì ꞌdi có tí nò, yí giì ꞌvìsì có ji ꞌdakò tí nò, máa, «À nìkì ma. Ye kèjì gí bà ꞌvala yí.» ");
INSERT INTO ndz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Káa ꞌdakò tí nò giì ꞌvìsì có ji Jézù, máa, «Ye ꞌvii tí ꞌduù ŋìnó náa wò ꞌví gì gí ꞌbá mì ye lá, buù. ꞌDè káa có ta nje lo cuki ꞌdo tí bàndò tí nó kpónó náa wò kuu tí  nô, wàa bòò mì ye bà ꞌde ꞌválá gî. ");
INSERT INTO ndz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tacó ye a ꞌduù ta ndâ kpo-kpò ꞌduù kùṛo ye kuu tí , náa ye kû ꞌdi có mì ndú. À delè kuu tí  tàkò ye a ndâ àsìkérì mbe kû ꞌdi có mì ye, náa ye má ꞌdè có ji ꞌbí ꞌduù gbaànjé gbí òkò tí ndú, máa, ‹Bàkà i ŋìnó!› Yí kû bàkà ; ye má ꞌdè có ji ꞌbí ꞌduù gbaànjé gbí òkò tí ndú, máa, ‹Ya énó!› Yí kû ya go có tí nò. Ye má tèꞌé tí ꞌduù máa, ‹Gì !› Yí kû gì go có mì ye nò. Ye má ꞌdè có ji bòò mì ye máa, ‹Bàkà i ŋìnó!› Yí kû bàkà i tí nò.» ");
INSERT INTO ndz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jézù mâ giì ꞌdi ŋa có tí nò náa ꞌdakò tí nò ꞌdè nò, nje wó giì ꞌdèè gî. Bìndi  yí giì ꞌdè có ji ndâ ꞌduù tí nó mbe kû ṛu ndi wó nó, máa, «Ye kû ꞌdè có ji yo ta yúcó, máa, ye jé ꞌde ꞌbí ꞌduù gbaànjé mbe tee njembí wó mítí Mbíṛì, kpêtí ꞌdo gbí òkò tí yo tí ndâ Ìzìrìyélì, go i mì ꞌdakò tí nó lá. ");
INSERT INTO ndz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ye kû ꞌdè có ji yo ta kponje tí  wálá, máa, ndâ ꞌbí tende ŋa ndâ ꞌduù ta ndòngbú o wúnò bà kaa ꞌdo muu to tí nó ꞌdáá gî gí bà zò i ta ndâ Àbìráámò ta Ìzákò, ta Jàkóbè gbí gbèe káꞌi ta líkíꞌo tí ndú gbí ngbàngà mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bìndi  àá bà giì mò yo tí ndâ Ìzìrìyélì, tí ndâ ꞌdóó ꞌviì gbí ngbàngà mì Mbíṛì nó gí gbí ꞌdíꞌdiꞌo, tí bàndò bà wa gbí, ta bà zò gbí tì ta séꞌi.» ");
INSERT INTO ndz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jézù mâ giì ꞌdè có ji ndâ mbè ndâ ꞌduù tí nò cee gî, yí giì ꞌvìsì có ji kùṛo ndâ àsìkérì mì ndâ Ròmánò tí nò, máa, «Má énò, ya gí ꞌbá mì lo, wàa có tí nó náa wò tee njembí lo á mítí  nò bà bàkà tí gî, tacó wò ùnje gî, máa, ye kpêtí má ꞌdè káa có ta nje ye sínò, bòò mì lo bà ꞌvala ꞌdo gbí nòꞌo gî.» À káa póó bà ꞌdè có tí nò mì Jézù, bòò mì ꞌdakò tí nò giì a gí yaà ꞌdo gbí nòꞌo mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jézù giì njè nó ꞌdo bàndò bà ꞌde tí ndú ta kùṛo ndâ àsìkérì mì ndâ Ròmánò nò ya gí ꞌbá mì Pìyétòrò. Yí mâ giì yee kà, yí giì ꞌde na gê Pìyétòrò kuu tísì ta côꞌo gbí dìì wó. ");
INSERT INTO ndz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yí mâ giì zèè ꞌbí niì tí nó, côꞌo ngé giì dò ꞌdo gbí dìì wó gî. Bìndi  yí giì a gí yaà ya gí bà bàkà i-zó-zò ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ta ꞌdêꞌo mì gbèe ṛi tí nò náa Jézù ꞌvala ta na gê Pìyétòrò ꞌdo gbí nòꞌo nò, ndâ ꞌduù giì kaa ndâ ꞌduù ŋìnó ta ndâ i-gbí-muu ndú nó, ta ndâ ꞌduù ŋìnó ta nòꞌo tí ndú nó ya tí  ji Jézù. Jézù giì mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù tí nò ta njì có gbaànjé. Bìndi  yí giì ꞌvala ndâ mbe nòꞌo, ");
INSERT INTO ndz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","go có tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì ꞌdè sàà gî, máa, «Yí bà ꞌvala ndoo ꞌdo gbí ndâ nòꞌo mì ndoo; yí delè kaa ndâ njì séꞌi ꞌdo gbí dìì ndoo ꞌdáá gî,» nô. ");
INSERT INTO ndz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jézù mâ giì ŋò ndâ ꞌduù kaa gì gí mì wó me mbè ngé ndii gî, yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, ndâ yì di kàpá gí tìto. ");
INSERT INTO ndz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ꞌBí ꞌdakò tí mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà mâ giì ꞌdi có tí nó, yí giì ꞌvìsì có ji Jézù, máa, «Mbe nìbà i, àá bà ja ye ꞌdo tàkò lo káa go ngo.» ");
INSERT INTO ndz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò, máa, «Ndâ gùù mì ndâ ngàmbé kuu tí . Ndâ bàndò bà tèṛì mì ndâ nuù tí nó mbe kû o co gbí pípìṛi nó ꞌdáá gî kuu tí , káa bàndò bà tì tàmuu ꞌViì-mì-ꞌDakò á mítí  wálá.» ");
INSERT INTO ndz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mâ giì zekeꞌo bà-i-nò ꞌbí ꞌdakò ꞌdo gbí òkò tí ndâ ꞌduù tí nó mbe kû ṛu ndi Jézù nó giì ꞌdè có ji yí, máa, «Buù, si ye má ya gí bà duu ku bu ye, má kózò gî, bìndi  ye ꞌví dele ndi ye gì gí ba ṛu ndi lo.» ");
INSERT INTO ndz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Káa Jézù giì ꞌvìsì có gí tàkò có mì ꞌdakò tí nò, máa, «Gì gí bà ṛu ndi ye, wàa wò ꞌví si ndâ ku ꞌví duu ndâ ꞌdóó ku mì ndú.» ");
INSERT INTO ndz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bìndi bà ꞌdè có mì Jézù ji ꞌdakò tí nò, yí giì njè nó ya gí gbí gbâ, bìndi  ndâ mbe tala có mì wó giì oloko gí tàkò wó gbí gbâ kà. ");
INSERT INTO ndz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mâ giì zekeꞌo, gundiṛi giì ꞌbìtà bà pì tí ŋa ŋìnó náa ngo kû giì ꞌbìtà có bà gbàngà gí gbí gbâ. Káa Jézù ta o tí nò kuu tísì kû tè ṛì gbí gbâ. ");
INSERT INTO ndz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bìndi  ndâ mbe tala có mì wó mâ giì ŋò máa, i kû giì vóló-volo, ndú giì gbà yí ꞌdo muu ṛì. Yí mâ giì ziya gî, ndú giì ꞌdè có ji yí, máa, «ꞌVala ndoo, buù, tacó ndoo kû míí-mìì!» ");
INSERT INTO ndz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Káa Jézù giì ꞌvee ndâ mbe tala có mì wó, máa, «Yo kû cì gúku tacó yè? Yo tee njembí yo mítí Mbíṛì me jéꞌdéé gî le!» Bìndi  yí bà-i-nò giì a gí yaà, yí giì do mítí ndâ gundiṛi tí nò mbe kû pì nò, ta kàpá tí nò mbe kû gbàngà nò. Ndâ i tí nò só giì ṛò tíyò ngbi-ngbìì gî. ");
INSERT INTO ndz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nje ndâ mbe tala có mì Jézù náa ndú ta ndú gbí gbâ nò ꞌdáá gî, giì ꞌdèè gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú, máa, «A ŋa wotí tí ꞌdakò yè ká énó, náa ndâ gundiṛi ta kàpá kû ꞌdi có mì wó nó?» ");
INSERT INTO ndz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì di ngo gí tìto kàpá á ꞌbí to ta ṛè to tí nò a Gàdárà, ndú giì ꞌde ndâ ꞌbí ꞌdakò sósòꞌô tí ndâ ꞌduù Gàdárà, ta ndâ i-gbí-muu ndú, mbe co ꞌdo gbí òkò ndâ muuꞌdú. Ndâ ꞌdakò tí nò tii tí ndú mítí kpokèjì tí nò mbe co ṛègbà ndâ muuꞌdú nò go ndâ gbù kàzà, tí ŋa ŋìnó náa gbèe ꞌduù mbe co tí kpokèjì tí nò ji ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Káa à káa póó bà giì ŋò Jézù mì ndú, ndú giì ꞌbìtà bà tò kû, máa, «Ákoo ꞌviì mì Mbíṛì! À gbí muu lo a có bà bàkà ŋa yè ta ze? Wò gì tacó bà waa có mítí ze si ꞌdóó o tí nò gí kùṛo kálásê?» ");
INSERT INTO ndz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Káa ta o bà ꞌde tí ndú nò, ndâ kàdùrúkù me mbè kû zò i á ꞌdê gbí to tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tacó énò, ndâ i tí nò gbí muu ndâ ꞌdakò tí nò, nò giì ꞌdeke tí ndú ji Jézù, máa, «Wò má mòkò ze ꞌdo gbí muu ndâ ꞌdakò tí nó gî, wò ꞌví si ze ꞌví ya gí gbí muu ndâ kàdùrúkù tí zô.» ");
INSERT INTO ndz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Bìndi  Jézù giì ꞌvìsì có ji ndâ i tí nò, máa, «Yo kaa ya !» Ndâ i tí nò bà-i-nò giì kaa ꞌdo gbí muu ndâ ꞌdakò tí nò ya gí gbí muu ndâ kàdùrúkù go có mì Jézù nò. Bìndi  ndâ kàdùrúkù tí nò giì njè ta ngèlè ta ndâ i tí nò gbí muu ndú, ndú giì oloko gí tà ngo ꞌdo tì njà gángá ngo, bìndi  ndú giì mìì ta ngo léé gî. ");
INSERT INTO ndz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ndâ mbe kû gbà ndâ kàdùrúkù tí nò giì kaa ya gí gbí gbata gí bà ꞌvanda ndi ndâ i tí nó mbe bàkà tí mítí ndâ kàdùrúkù, ta ndâ ꞌdakò tí nò sósòꞌô ta ndâ i-gbí-muu ndú nó gbaànjé-gbaànjé ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ndâ ꞌduù gbí gbata mâ giì ꞌdi ndâ có tí nò, ndú giì kaa ꞌdo gbí gbata ya gí mì Jézù. Ndú mâ giì ꞌde yí gî, ndú giì ꞌdeke tí ndú ji yí, máa yí njè nó ꞌdo gbí to ꞌbá mì ndâ yì gî. ");
INSERT INTO ndz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jézù mâ giì di ndi kàpá ꞌdo gbí to Gàdárà gí tìto gí gbí ꞌdóó gbata bà dù yí gî, ");
INSERT INTO ndz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ndâ ꞌduù giì làngà ꞌbí ꞌdakò mbe gbeleꞌve gî gì tí  ji yí. Jézù mâ giì ŋò bà tee njembí ndú mítí wó, yí giì ꞌdè có ji ꞌdakò tí nò mbe gbeleꞌve gî nò, máa, «Zèè njembí lo, ꞌviì mì ye, tacó à si có gítí ndâ vò i mì lo mí to gî.» ");
INSERT INTO ndz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Káa ndâ ꞌbí mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà gbí òkò tí ndâ ꞌduù tí nò mbe tì mí mì Jézù nò mâ giì ꞌdi có tí nò náa yí ꞌdè nò, ndú giì ꞌbìtà bà koṛo có gbí njembí ndú, máa, «ꞌDakò tí nò kû bàkà tí wó tí Mbíṛì ta wotí tacó yè? Yí ꞌde wotí bà je à-cee-gî gítí vò i mì ndâ ꞌduù ꞌdo kòtí ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jézù mâ giì ŋò ŋa có tí nó náa ndâ mbe ꞌdi gbí tàkìì tí nò kû koṛo gbí njembí ndú nó, yí giì ꞌvee ndú, máa, «Yo kû koṛo ŋa vò có énò gbí njembí yo tacó yè? ");
INSERT INTO ndz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bà ꞌdè có máa, ‹À je à-cee-gî gítí ndâ vò i mì lo gî,› ká peteke , wèè, a peteke a bà ꞌdè có, máa, ‹A gí yaà, wàa wò ꞌví nò nó?› ");
INSERT INTO ndz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Má énò, ye kpónó bà tùbà  ji yo máa àá mì ꞌViì-mì-ꞌDakò a wotí tacó bà je à-cee-gî gítí ndâ vò i mì ndâ ꞌduù á muu to tí nô.» Bìndi  yí giì ꞌdè có ji ꞌdakò tí nó mbe gbeleꞌve gî nó máa, «A gí yaà, wò ꞌví te kpâ-sili mì lo, wàa wò ꞌví ya gí ꞌbá.» ");
INSERT INTO ndz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ꞌDakò tí nò bà-i-nò ngé giì a gí yaà, bìndi  yí giì njè nó kû ya gí ꞌbá go có mì Jézù nò. ");
INSERT INTO ndz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nje ndâ mbè ꞌduù tí nó mbe kaa ya gí mì Jézù nó ꞌdáá gî giì ꞌdèè ta gúku bà ŋò ꞌdakò tí nò kû nò nó gî. Bìndi  ndú giì ùlù Mbíṛì tacó bà je ŋa wotí tí nò á ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jézù mâ giì njè nó ꞌdo tí bàndò bà ꞌvala ꞌdakò tí nò mbe gbeleꞌve gî nò, yí giì ŋò ꞌbí ꞌdakò tí Jùdéyà tí mbe kû kili i-mírì mì ndâ Ròmánò, ta ṛè wó a Màtéyò, kû ki tí wó to á bàndò bá gò i-mírì. Bìndi  yí giì ꞌdè có ji Màtéyò, máa, «Gì gí bà ṛu ndi ye.» Màtéyò bà-i-nò giì a gí yaà, bìndi  yí giì ya gí bà ṛu ndi Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Si Jézù kû zò i ta ṛi tí nò á ꞌbá mì Màtéyò, ndâ ꞌbí ka nèté mì Màtéyò me mbè, ta ndâ ŋa ndâ ꞌbí ꞌduù mbe kû gbètèkè tàkìì mì ndâ Jùdéyà giì kaa gì kû zò i ta ndâ Jézù ta ndâ mbe tala có mì wó gbí gbèe káꞌi. ");
INSERT INTO ndz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ndâ ꞌbí mbe kû kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ŋò ŋa i tí nò, ndú giì ꞌvee ndâ mbe tala có mì Jézù, máa, «Mbe nìbà i ji yo kû zò i gbí káꞌi ta ndâ ꞌduù ŋìnó mbe ꞌvii tí ndâ ꞌduù náa cèe ꞌduù ꞌví zò i ta ndú gbí tàkìì mì ndâ Jùdéyà lá nó tacó yè» ");
INSERT INTO ndz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jézù mâ giì ꞌdi ŋa ꞌvé tí nó náa ndâ ꞌduù tí nò kû ꞌvee ta ndâ mbe tala có mì wó nò, yí giì ꞌvìsì có ji ndú, máa, «A ndâ ꞌduù ŋìnó ta séꞌi tí ndú nó ká kû pà mbe yeè. Ndâ ꞌduù ŋìnó ta séꞌi tí ndú wálá nó pà mbe yeè lá. ");
INSERT INTO ndz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Má énò, yo ꞌviiki gbí có tí nó náa à cu mí gbí wáràgà mì Mbíṛì énò máa, ‹À tí ye tí Mbíṛì a go bà ŋò yê ṛo ndâ ꞌduù; go bà ci mbelè ndâ nò ji ye tí ye wálá.› Ye delè gì me tacó bà tèꞌé tí ndâ tó ꞌduù lá, ye gì a i tacó tí ndâ mbe bàkà vò i.» ");
INSERT INTO ndz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ta o tí nò, ndâ ꞌbí mbe tala có mì Jòvánì tí mbe caka tí ndâ ꞌduù giì gì gí mì Jézù, bìndi  ndú giì ꞌvee yí, máa, «Tacó yè, káa ze ta ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà kû kònò go ta ṛi bà kònò go mì ndâ Jùdéyà, káa ndâ mbe tala có mì lo kònò go lá?» ");
INSERT INTO ndz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Ndâ kpóló-kpolo kómbe mbe kò niì jé kû kònò go ta o tí nó náa kómbe ndú tí nó náa à kû ko niì mì wó gí ꞌbá nó má kuu ta ndú? Káa o bà je mbe kû kò niì tí nò ꞌdo gbí òkò tí ndú bà gì ká gì, bìndi  ndú bà giì kònò go ta o tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","À da ngú kô mí pí ká kô lá. ");
INSERT INTO ndz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ꞌBí ꞌduù jé mbe fuu pe ngú cû mí gbí ká káṛà ŋìnó ta gbí wó wuuku gî nó wálá. Tacó yí má bàkà énò, ta o tí nó náa pe ngú cû bà giì nì nó, káṛà tí nò bà ba gî. Bìndi  yí bà bè gbí ndâ káṛà ta pe só gî. Tacó énò, à ta o ꞌdáá gî kû fuu pe ngú cû ká mí gbí kpóló-kpolo káṛà tacó bà kpolo tí ndâ pe ta káṛà.» ");
INSERT INTO ndz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Káa si Jézù kálásê kû ꞌdè có ji ndâ mbe tala có mì Jòvánì, ꞌbí ꞌdakò tí gbolò ꞌduù giì gì gí mì wó, bìndi  yí giì zèè kò wó mí kùṛo ndâ ꞌduù ꞌdáá gî, ta bà ꞌdeke tí wó ji yí, máa, «Nájú ye cee gî, káa ye kû ꞌdeke a tí ye ji wò, máa wò ꞌví ya gí bà tee ꞌbì lo mítí wó wàa yí ꞌví ꞌvala ji ye.» ");
INSERT INTO ndz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jézù mâ giì njè nó kû ya gí ꞌbá mì gbolò ꞌduù tí nò, ndâ mbe tala có mì wó giì kaa kû ṛu ndi wó. ");
INSERT INTO ndz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Káa si ndú muu nó, ꞌbí niì náa mbelè kû yee tí wó ta ndoò muuꞌbì-nje só giì gì có kapí Jézù, bìndi  yí giì zèè nje bòngo tí wó, ");
INSERT INTO ndz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ta bà koṛo có, máa, «Ye kpêtí má zèè káa nje bòngo tí wó, ye bà ꞌde ꞌválá gî.» ");
INSERT INTO ndz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jézù mâ giì ꞌvìsì tí wó gí ndiì, yí mâ giì ŋò niì tí nò, yí giì ꞌdè có ji yí máa, «Zèè njembí lo, nájú ye, tacó bà tee njembí lo mítí ye ꞌvala wò gî.» ꞌDo tí bàndò tí nò, mbelè tí nó mbe kû yee ꞌdo tí niì tí nò, nó ngé giì ṛò tíyò gî. ");
INSERT INTO ndz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jézù mâ giì yee ꞌbá mì gbolò ꞌduù tí nò, yí giì ꞌde ndâ ꞌduù kû wa ku tàꞌi ta wotí ká tí . ");
INSERT INTO ndz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Bìndi  yí giì ꞌdè có ji ndú, máa, «Yo njè gí sè ꞌdo tàꞌi tí nò gî. Làmbu ꞌvinî tí nò cì me cí-cì lá. Yí kû tè a ṛì.» Káa ndâ ꞌduù tí nò giì ꞌbìtà bà ŋo Jézù ta ŋa có mì wó nò ŋó-ŋo. ");
INSERT INTO ndz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Káa ndú mâ giì njè gí sè go có tí nò gî, Jézù giì ṛì gí tàkò ku ꞌvinî tí nò tàꞌi. Yí mâ giì zèè ꞌbì wó, ꞌvinî tí nó giì a  ṛò tíyò. ");
INSERT INTO ndz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tàwo ngú có tí nò giì ya cee gbí to tí nò ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ta o bà njè nó mì Jézù ꞌdo bà ꞌvala nájú gbolò ꞌdakò tí nò, ndâ ꞌbí mbe sú ṛo sósòꞌô giì ṛu ndi wó ta bà tò kû á tàkò wó ta kòcò ndú ngéé gí yaà, máa, «Àá ꞌViì kòtí Dàvídè tí Bìndi-Mbíṛì, àá ꞌViì kòtí Dàvídè, ŋò yê ṛo ze!» ");
INSERT INTO ndz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jézù mâ giì ṛì gí tàꞌi ta o bà yee yí ꞌbá gî, ndâ mbe sú ṛo tí nò giì ṛì gí tàkò wó. Bìndi  yí giì ꞌvee ndú, máa, «Yo wálá ùnje gî, máa ye bà ꞌvala yo gî?» Káa ndú giì ꞌvìsì có ji yí, máa, «Ze ùnje gî, buù.» ");
INSERT INTO ndz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jézù mâ giì ꞌdi có tí nó náa ndâ mbe sú ṛo tí nò ꞌvìsì gí tàkò ꞌvé mì wó nò, yí giì gbala ṛo ndú ta bà ꞌdè có ji ndú, máa, «Ye bà njaanga ṛo yo gî, tacó yo ùnje ta njembí yo gbaànjé gî, máa wotí bà bàkà énò kuu tí ye.» ");
INSERT INTO ndz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jézù mâ giì ꞌdè có tí nò, ṛo ndâ mbe sú ṛo tí nò só nó giì njaanga tí gî. Bìndi  yí giì ꞌdè có ji ndú ta wotí tí , máa, «Yo kpolo tí nje yo máa, ꞌbí ꞌduù gbaànjé ꞌví ꞌdi có máa a ye ká njaanga ṛo yo nò lá.» ");
INSERT INTO ndz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Káa ndâ ꞌdakò tí nò mâ giì njè nó ꞌdo bà-i-nò gî, ndú giì nò ta bà ma ṛè Jézù ta ndi tí ndâ ꞌbá ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","À káa póó bà njè nó mì ndâ ꞌdakò tí nó náa Jézù njaanga ṛo ndú nó gî, à giì gì ta ꞌbí ꞌdakò mbe ꞌdè có lá ta i-gbí-muu wó ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jézù mâ giì mòkò i tí nò ꞌdo gbí muu ꞌdakò tí nò gî, ꞌdakò tí nò ngé giì ꞌbìtà bà ꞌdè có. Bìndi  nje ndâ mbè ndâ ꞌduù tí nó mbe tì mí mì Jézù nó giì ꞌdèè gî. Bìndi  ndú giì ꞌbìtà bà ꞌdè có gbí òkò tí ndú, máa, «À jé ŋò ꞌbí ŋa i go énó ꞌbá Ìzìrìyélì lá.» ");
INSERT INTO ndz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Káa ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà a gbí òkò tí ndâ ꞌduù tí nò ŋìndi ndú giì ꞌvìsì có gí tàkò có tí nò, máa, «A Gba-vò-i, tí gba mì ndâ i-gbí-muu, ká kû je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ji yí.» ");
INSERT INTO ndz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gbí ndâ o tí nò, Jézù giì nò nó cee gbí ndâ gbata, ta ndâ víí bàndò á sè ꞌdo gbí ndâ gbata ꞌdáá gî, kû nìbà i, ta bà ma Banga-Ngú-Có gítí có bà dù Mbíṛì tí gba ji ndâ ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì, delè ta bà ꞌvala ndâ ꞌduù ꞌdo gbí ndâ ŋa ndâ nòꞌo ta ndâ séꞌi ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Káa yê ṛo bà ŋò ndâ mbè ndâ ꞌduù tí nò náa Jézù kû nò ta bà nìbà i ji ndú nò giì bàkà yí ngé ndii gî. Tacó à tí ndú a gúku, ndú delè ŋò ꞌdóó i ŋìnó náa ndâ yì ꞌví bàkà nó lá, tacó ꞌduù kùṛo ndú wálá, go ndâ rómbo ta mbe gbà ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó, máa, «Ndâ i tacó bà kili ꞌdo gbí njí ògbù ngé, káa muu ndâ mbe bàkà nèté me njíꞌdí. ");
INSERT INTO ndz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Má énò, yo ꞌdeke tí yo ji mbe njí, tacó wàa, yí ꞌví tuu ndâ mbe bàkà nèté me mbè tacó bà kili ndú.» ");
INSERT INTO ndz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jézù giì ṛuka ndâ ꞌbí ꞌduù muuꞌbì-nje só ꞌdo gbí òkò tí ndâ mbe tala có mì wó, bìndi  yí giì je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù, ta wotí bà ꞌvala ndâ ꞌduù ꞌdo gbí ndâ ŋa ndâ nòꞌo ꞌdáá gî á bìndi wó ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ŋìnó a ṛè ndâ ꞌduù tí nó muuꞌbì-nje só náa Jézù ṛuka ndú nò: ndâ kpédélé ꞌduù a ndâ Sìmónè tí nó ta ꞌbí ṛè wó a Pìyétòrò nô, ta náꞌvindí wó Àndèréyà, bìndi  a ndâ Jákòmò ta náꞌvindí wó Jòvánì tí ndâ ꞌviì mì Zèbìdéyò, ");
INSERT INTO ndz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ta Fìlípò, ta Bàràtòlòméyò, ta Tòmázò, ta Màtéyò tí mbe kili i-mírì, ta Jákòmò tí ꞌviì mì Àlìféyò, ta Tàdéyò, ");
INSERT INTO ndz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ta Sìmónè tí nó tí tó ꞌviì-ꞌbá nô, ta Júdà Ìsìkàrìyótè tí mbe ba ngbù wó tí Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bìndi  Jézù giì tuu ndâ ꞌdakò tí nò muuꞌbì-nje só náa yí ṛuka ndú tí ndâ tú mì wó nò, káa ta kùṛo bà tuu ndú, yí giì kpo-gbí-tà-tù ndú, máa, «Yo ꞌví ꞌdò kò yo gbaànjé mí gbí to mì ndâ ꞌduù ŋìnó mbe kû ùlù ndâ ꞌbí tende ŋa i bìndi Mbíṛì nó lá. Yo delè ꞌví ya gí gbí ndâ gbata á gbí to Sàmárìyà lá. ");
INSERT INTO ndz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yo ya a i gí mì ndâ Ìzìrìyélì tí ndâ mbe giṛi á go ndâ rómbo gî, ");
INSERT INTO ndz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","wàa yo ꞌví kò-kò ji ndú, máa, ‹Kùṛo o bà gì Gba-gbíṛì kpónó dooko gî!› ");
INSERT INTO ndz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yo ꞌví ꞌvala ndâ mbe nòꞌo, yo ꞌví ꞌvala ndâ ku, yo ꞌví ṛo kútí ndâ mbe cì, yo ꞌví mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù. Yo sì wotí bà bàkà ndâ i tí nò náa ye ꞌdeke ndú ji yo nò me sí-sì lá. Má énò, yo delè ꞌví je mboo tàkò bà bàkà ndú ꞌdo mì ndâ ꞌduù lá. ");
INSERT INTO ndz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ta o tí nó náa yo má kû ya gí muu nó, yo ꞌví je ꞌbí làmbu i tacó bà sì ta ndâ ꞌbí i ngé gî lá. ");
INSERT INTO ndz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yo ꞌví je ndâ ꞌbí bòngo ta ndâ ꞌbí tàmà tacó bà ꞌvìsì ta ndâ ŋìnó á tí dìì yo nò á kùṛo kà lá. Yo delè ꞌví zèè ꞌbí i go mû-kóṛó mí ꞌbì yo tacó bà kpolo tí yo lá. Tacó ꞌduù má ka wuꞌo gî, àá bà si yí sínò wálá. ");
INSERT INTO ndz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yo má yee tí to, yo ꞌví pà a ꞌbá mì ꞌduù ŋìnó mbe nì ‹Yo ndi ye nò› ji yo ta njembí wó gbaànjé, wàa yo ꞌví dù tí , yee tí o bà njè nó mì yo ꞌdo tí to tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yo má yee tí ꞌbá, yo ꞌví nì ‹Ze yee gî› ji ndâ mbe ꞌbá ta bà cù ꞌdê ngo cù yo tù-tù-tù mítí ndú. ");
INSERT INTO ndz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ndú má nì ‹Yo ndi ze nò› ji yo ta ꞌdê njembí ndú, yo ꞌví dù ta ndú. Káa ndú má biya bà ꞌvìsì ꞌvé ji yo gî, yo ꞌví ndii ta nó mì yo, ta nambeè tí nó gbí njembí yo náa yo máa Mbíṛì ꞌví bàkà ji ndú nô. ");
INSERT INTO ndz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yo má yee tí to, káa ndâ ꞌduù má te wiṛi mítí yo lá, ndú delè má sè tù ndú tí có mì yo náa yo kû ꞌdè ji ndú nó lá, ta o tí nó náa yo má kû ꞌvìsì tàmuu yo gítí to tí nò, nó, yo ꞌví gbà njú to, to tí nò ꞌdo tí kò yo gî. Ŋìnò tacó bà tùbà  ji ndâ mbe to tí nò máa, Mbíṛì bà waa có mítí ndú, káa à me ꞌdo gbí có mì yo lá. ");
INSERT INTO ndz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ye kû ꞌdè có ji yo ta ꞌvéṛè tí  wálá, máa, Mbíṛì bà waa có mítí ndâ mbe to tí nò ta ndòngbú o ta wotí tí  ndii bà doo ndâ gbata Sòdómà ta Gòmórà á mì wó ta wu táánò nó gî. ");
INSERT INTO ndz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ye kû tuu yo gí gbí òkò tí ndâ ꞌduù ta zíꞌi ꞌbì yo tacó bà kpolo ta tí yo wálá, go ndâ rómbo á kùṛo ndâ siingiì. Má énò, yo ꞌví si ṛo yo ꞌví dù ngílí-ngílí go ṛo àcaꞌba. Wàa njembí yo ꞌví dù ꞌdèè kpóó go bèègú. ");
INSERT INTO ndz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","«Yo delè ꞌví te mí gbí muu yo máa, ndâ ꞌduù kèjì gí bà kaa yo ya tí  gí gbí ndâ ngbàngà mì ndâ Jùdéyà. Bìndi  ndâ gba bà giì waa có mítí yo máa, à gbì yo mí kùṛo ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Àá bà jaka yo ta wotí ya tí  gí kùṛo ndâ kpo-kpò ꞌduù ta ndâ kpo-kpò gba á muu ye. Káa ŋìnò bà njaanga ji yo a kpokèjì bà ma có tí ye ji ndâ kpo-kpò ꞌduù, ta ndâ kpo-kpò gba, ta ndâ ꞌduù ŋìnó náa ndú me ndâ Jùdéyà lá nô. ");
INSERT INTO ndz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Káa ta o tí nò náa ndú bà giì zèè yo nò, njembí yo ꞌví si bà mù énó máa, yo bà ya gí bà ꞌdè á kùṛo ndâ kpo-kpò ꞌduù kà a ŋa có yè wè, mí to. Njembí yo delè ꞌví mù énó máa, yo ꞌví ꞌdè a ŋa có yè wè, nò lá. Àá bà wu có tí nó náa yo ꞌví ꞌdè nó mí gbí nje yo ká kùṛo kà. ");
INSERT INTO ndz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tacó ta o tí nò, à me káa yo ká bà ꞌdè ꞌdóó có mì yo á ꞌdo gbí muu yo lá. A Bèṛi mì Bu ye ká bà je wotí bà ꞌdè có ji yo. ");
INSERT INTO ndz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Ta o tí nò, ndâ ꞌduù bà sì ndâ náꞌvindí ndú ta ndâ ꞌviì mì ndú ji ku. Ndâ ꞌviì delè bà ꞌvìsì tí ndú tacó bà pà kpokèjì bà ziki ndâ mbe jò ndú. ");
INSERT INTO ndz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ndâ ꞌduù ꞌdáá gî bà giì sogo yo á muu ye ta o tí nò. Káa ꞌduù ŋìnó gbí òkò tí yo mbe ꞌdò kò wó mí to tí kpoò yee tí ndòngbú o bà mèèkè ndâ i tí nò tí yo nó ká bà ꞌde ꞌválá. ");
INSERT INTO ndz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","À má kû mèèkèꞌi tí yo ta o tí nò gbí ꞌbí gbata, yo ꞌví kaa ta ngèlè ꞌválá ya gí gbí ꞌbí . Káa ye kû ꞌdè có ji yo ta ꞌvéṛè tí  wálá, máa, ꞌViì-mì-ꞌDakò bà gì gí muu to tí nó si yo nò ꞌbá mì ndâ Ìzìrìyélì ꞌdáá gî cee lá. ");
INSERT INTO ndz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mbe kû tala i me gbolò ndii ꞌduù tí nó mbe kû nìbà i ji yí nó lá; bòò delè me gbolò ndii mbe tí wó lá. ");
INSERT INTO ndz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","À tè ta mbe tala i káa bà je muu mì mbe nìbà i ji yí mítí wó; à delè giì tè ta bòò káa bà je muu mbe tí wó mítí wó. Káa ṛè bu-ꞌbá má mì ndú a Gba-wàtà, ndú bà gbì mí muu ndâ ꞌviì mì wó a ndâ vò ṛè mbe ndii ŋìnò gî. ");
INSERT INTO ndz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«À má énò, yo ꞌví cì gúku tí ndâ ꞌduù lá. Tacó ndâ ŋa ndâ i tí nó ꞌdáá náa ndâ ꞌduù kû ngùù ndú kpónó nó bà ꞌvanda ꞌdáá gí sè gî. Delè ndâ có tí nó náa ndú kû ꞌdè mí tàbèngìì nó bà dù á kà wálá. ");
INSERT INTO ndz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yo bà giì kò-kò ta ndâ có tí nó náa ye kpónó kû ꞌdè ji yo gbí ꞌdíꞌdiꞌo nó á ji ndâ ꞌduù gbí ngbàà ṛi. Bìndi  yo bà giì kò-kò ta ndâ có tí nó náa ye kû ꞌdè ji yo á gbí ngàngbùùtù nó ꞌdo pí cèléngé ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Káa yo ꞌví cì gúku tí ndâ ꞌduù lá, tacó ꞌbí i gbaànjé mì ndú náa ndú bà bàkà ta yo, á bìndi bà zi yo mì ndú nò wálá. Yo cì gúku a i tí Mbíṛì, tacó wotí bà zi yo ta wotí bà waa có mítí yo bìndi bà zi yo mì wó kuu tí wó. ");
INSERT INTO ndz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yo tala bà zeke ndâ víí nuù tí nó tí ndâ naṛù nó gi. ꞌBí làmbu i náa ꞌduù bà ꞌde gbí ndú gbaànjé wálá. Káa ꞌbí  gbaànjé ꞌdo gbí òkò tí ndú mbe cì gî, káa Bu yo ŋò bà ku wó lá, nò wálá. ");
INSERT INTO ndz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Káa à má gítí yo, yí ꞌdeke ndâ njì se muu yo gbaànjé-gbaànjé ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Má énò, yo ꞌví cì gúku lá, tacó yo kùṛo Mbíṛì a ndâ kpóló-kpolo i ndii ndâ naṛù gî. ");
INSERT INTO ndz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Má énò, ꞌduù má si ye tí i á kùṛo ndâ ꞌduù á muu to tí nó, ye delè wúnò bà si ꞌduù tí nò tí i á kùṛo Bu ye á gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Káa ꞌduù má biya ye á kùṛo ndâ ꞌduù á muu to tí nó, ye delè wúnò bà ꞌvìsì kapí ye gítí ꞌduù tí nò á kùṛo Bu ye á gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Yo si bà je mbí yo énó máa, ye gì ji yo ta ngú có mbe ꞌdèè njembí yo nò mí to. ");
INSERT INTO ndz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Có tí nó náa ye gì tí  nó a có mbe njèè gbí òkò tí ndâ ꞌviì ta ndâ bu ndú, ndâ niì ta ndâ nájú ndú. Có tí nò bà njèè gbí òkò tí ndâ nawu ndâ ꞌviì ta ndâ niì mì ndâ ꞌviì mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ndâ mbe sogo ꞌduù gí mì ku bà dù káa ndâ ꞌdóó ꞌviì mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«ꞌDuù má zèè có tí ndâ bu wó ta nawu wó kpolo ndii có tí ye gî, ŋa ꞌduù tí nò bà ꞌvii tí mbe dù tí ꞌduù mì ye wálá; ꞌduù delè má zè nìkì kpolo ma a ndâ bà wó ta ndâ nájú wó co tí ye, ŋa ꞌduù tí nò bà ꞌvii tí mbe dù tí ꞌduù mì ye wálá. ");
INSERT INTO ndz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ꞌDuù má ùnje gítí bà kònò séꞌi go ye wàa yí ꞌví gì gí bà ṛu ndi ye lá, yí bà ꞌvii tí mbe dù tí ꞌduù mì ye wálá. ");
INSERT INTO ndz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ꞌDuù mbe koṛo có kpolo ma ká gítí ꞌválá muu to tí nó bà ꞌde vò i bìndi ku mì wó. Káa ꞌduù ŋìnó mbe sì miṛi wó muu to tí nó ji ku a i gítí nèté mì ye ká bà ꞌde ꞌválá á bìndi ku mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«ꞌDuù mbe te wiṛi mítí yo ta ṛè ye, te wiṛi tí nò a i mítí ye, káa ndâ mbe te wiṛi mítí ye, te wiṛi tí nò a i mítí mbe tuu ye. ");
INSERT INTO ndz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ꞌBí ꞌduù má te wiṛi mítí mbe ꞌdòkò có mì Mbíṛì ta ṛè mì Mbíṛì, Mbíṛì bà je ꞌbí tó i tí nó náa yí bà je ji mbe ꞌdòkò có mì wó nò nó ji ꞌduù tí nó gî. ꞌBí ꞌduù delè má te wiṛi mítí tó ꞌduù gítí tó ṛè ꞌduù, tí nò, Mbíṛì bà je ꞌbí ŋa tó i tí nó náa yí tí Mbíṛì bà je ji tó ꞌduù tí nò nó ji ꞌduù tí nó mbe te wiṛi mítí wó nó gî. ");
INSERT INTO ndz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Káa ye kû ꞌdè có ji yo ta yúcó, máa, ꞌduù kpêtí má cu káa cèe ꞌdê ngo mì lú nó sínò ꞌdo gbí káṛà ji ꞌbí ŋa ꞌduù ŋìnó náa ṛè wó gbí u ꞌduù wálá ngé gî tacó náa táángbà ꞌduù tí nò a mbe tala có mì ye, yí bà ꞌde tó i tàkò ngo mì wó nò kpêkù.» ");
INSERT INTO ndz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jézù mâ giì cee ta nèté bà kpo-gbí-tà-tù ndâ mbe tala có mì wó muuꞌbì-nje só náa yí ṛuka ndú nó gî, yí giì njè nó ꞌdo bàndò tí nò kû nò ta ndi gbí ndâ gbata mì ndâ Jùdéyà kû ma Banga-Ngú-Có mì Mbíṛì ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ta o tí nò si Jézù kû ma Banga-Ngú-Có mì Mbíṛì ji ndâ ꞌduù ta ndi gbí ndâ gbata nò, Jòvánì tí mbe caka tí ndâ ꞌduù a i gbí zàà. Jòvánì mâ giì ꞌdi tàwo ndâ i tí nó náa Jézù tí Bìndi-Mbíṛì kû bàkà nó si yí gbí zàà kà, yí giì tuu ndâ ꞌbí mbe tala có mì wó máa ndú ya gí bà ꞌdè có ji Jézù, máa, «A Jòvánì tí nó tí mbe kû caka tí ndâ ꞌduù nó ká tuu ze, máa, ze gì gí bà ꞌvee wò, máa, ");
INSERT INTO ndz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wò a ꞌduù tí nó náa ze kû ù bà gì yí ꞌdo mì Mbíṛì nó, wèè, ꞌduù mì ze náa ze kû ù bà gì yí nò ká kpokèjì kálásê?» ");
INSERT INTO ndz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ndâ tú mì Jòvánì mâ giì ya gí bà ꞌvee Jézù go co tí nò náa Jòvánì tuu ta ndú nò, Jézù giì ꞌvìsì có ji ndú, máa, «Yo dele ndi yo ya gí bà dìtà ndâ có ŋìnó náa yo ꞌdi ta tù yo nó, ta ndâ i ŋìnó náa yo ŋò ta ṛo yo nó ji Jòvánì: ");
INSERT INTO ndz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ndâ ꞌduù ŋìnó táánò náa ṛo ndú yoo gî nó, kpónó kû zekeꞌo. Ndâ ꞌduù ŋìnó táánò ta kò ndú mbe gbeleꞌve gî nó, kpónó kû nò nó. Ndâ kà cì kpónó yuku ꞌdáá ꞌdo tí ndâ ꞌduù ŋìnó táánò ta cì tí ndú nó gî. Ndâ ꞌduù ŋìnó táánò tí ndâ mbe sú tù nó kpónó kû ꞌdi có. Ndâ ꞌduù ŋìnó táánò mbe cì tí yú ku gî nó, ꞌvala ndi ndú gî. À kû ma Banga-Ngú-Có ji ndâ yê. ");
INSERT INTO ndz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yo delè ꞌví ꞌdè có ji Jòvánì, máa, ꞌduù ŋìnó mbe tee njembí wó kácáá mítí có mì ye nó a mbe tó pá.» ");
INSERT INTO ndz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Káa si ndâ tú mì Jòvánì kû giì bàkà có bà dele ndi ndú, Jézù giì ꞌbìtà bà ꞌvee ndâ ꞌduù gítí Jòvánì, máa, «Gbí ndâ o tí nó táánò náa yo kû kaa ya gí mì Jòvánì si yí gbí kángáá nga ngoò nó, yo ta o tí nò kû koṛo có máa yo kû ya gí bà ŋò a ꞌdi? Gí bà ŋò ꞌbí ꞌduù ŋìnó ta ꞌdóó kóṛó-koṛo có mì wó wálá, mbe kû tè ká gí tàkò có mì ndâ ꞌbí ka wó nó? Káa à má me énò lá, ");
INSERT INTO ndz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","yo kaa ya gí bà ŋò a ꞌdi? Gí bà ŋò ꞌbí ꞌduù mbe zaa ta banga bòngo? Àá bà dù me énò lá, tacó ndâ mbe zaa ta ndâ banga bòngo kû dù a i ꞌbá mì ndâ kpo-kpò gba. ");
INSERT INTO ndz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nògí, má énò, yo táánò kaa ya gí sè gí gbí kángáá nga ngoò gí bà yè? Yo kaa ya me gí bà ŋò mbe ꞌdòkò có mì Mbíṛì lá? À énò. Ye kû ꞌdè có ji yo ta yúcó, máa, ꞌduù tí nò a gbolò ꞌduù ndii mbe ꞌdòkò có mì Mbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tacó Jòvánì a ꞌduù tí nó náa à cu có gítí wó mí gbí wáràgà mì Mbíṛì máa, Mbíṛì máa, ‹Ye bà tuu tú mì ye gí kùṛo lo, gí bà ꞌviindi kpokèjì ù ta ndi lo,› nô. ");
INSERT INTO ndz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ye kû ꞌdè có ji yo ta yúcó, máa, ꞌdo gbí òkò tí ndâ ꞌviì tí nó ꞌdáá gî náa a ndâ niì ká jò ndú nó, ꞌbí ꞌduù gbaànjé mbe gì tí gbolò ꞌduù ndii Jòvánì tí mbe caka tí ndâ ꞌduù yee tí kpónó wálá. Kpêtí ká énò, ꞌbí ꞌduù ŋìnó tí táángbà ꞌduù sínò gbí òkò tí ndâ ꞌduù tí nó tí ndâ Bòò-gba mì Gba-gbíṛì nó a gbolò ꞌduù ndii Jòvánì gî. ");
INSERT INTO ndz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Káa ꞌdo tí o bà ꞌbìtà bà kò-kò mì Jòvánì ta có mì Mbíṛì di tí wúnó, ꞌbá mì Gba-gbíṛì kû mbu ji bà te  ta wotí, ndâ vò ꞌduù kû paa ta zèè  ta wotí. ");
INSERT INTO ndz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Káa kùṛo bà gì Jòvánì, Mbíṛì táánò je wotí bà ꞌdè-kòcò a i ji ndâ Mòze ta ndâ mbe ꞌdòkò có mì wó tí Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yo má ùnje gítí ndâ có mì ndâ mbe ꞌdòkò có mì Mbíṛì ta ndâ có mì Mòze gî, Jòvánì a Èlíjà tí nó táánò tí mbe ꞌdòkò có mì Mbíṛì, náa ndú ꞌdè có máa yí bà dele ndi wó gì tacó bà gì gí bà ꞌviindi kpokèjì kùṛo bà gì Bìndi-Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Má énò, ndâ ꞌduù ŋìnó ta tù bà ꞌdi có tí muu ndú nó ꞌví ꞌdi có! ");
INSERT INTO ndz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Káa ye kpónó ꞌví ꞌvii yo ndâ ꞌduù tí nó á gbí o tí nó, nó mítí ŋa yè dú? Yo gbí ṛo ye ká go ndâ víí ꞌviì mbe kili kû ŋo ꞌdì gbí dùpì, ndú mâ giì ŋò ndâ ꞌbí ka ndú víí ꞌviì mbe kili ta ba muu ndú tende, ndú giì tèꞌé tí ndú máa, ");
INSERT INTO ndz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Yo gì gí mì ndoo, wàa ndoo ꞌví ŋo ꞌdì bà dù ṛu.› Káa ndâ ka ndú nò giì biya gî. Bìndi  ndú giì tèꞌé tí ndú kákáꞌi, máa, ‹Yo gì gí mì ndoo, wàa ndoo ꞌví ŋo ꞌdì bà wa ku.› Káa ndâ ka ndú nò giì biya delè gî. ");
INSERT INTO ndz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tacó Jòvánì táánò me mbe zò i lá, yí delè me mbe njù pe lá, káa ndâ ꞌduù giì kili nje ndú mítí wó, máa, ‹A i ká gbí muu wó.› ");
INSERT INTO ndz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ꞌViì-mì-ꞌDakò giì gì ŋìndi wó ta bà zò i, delè ta bà njù pe, ndâ ꞌduù kákáꞌi giì ꞌvìsì nje ndú énó, máa, ‹Yí a mbe gàmàtà, tí vò mbe njù pe, tí kómbe ndâ mbe kû gò i-mírì, tí ndâ mbe bàkà vò i!› Káa kpêtí ká énò, à ŋò bà ꞌdi gbí-o mì Mbíṛì ni mítí ndâ cè bà i mì wó.» ");
INSERT INTO ndz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bìndi  Jézù giì ꞌbìtà bà ꞌdeke tí wó ta sé có gítí ndâ ꞌduù gbí ndâ gbata tí nó náa yí bàkà ndâ seṛè ta ndi gbí ndú nô, tacó ndú biya bà ꞌvìsì muu ndú ꞌdo tí ndâ vò i mì ndú gî. Máa, ");
INSERT INTO ndz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Yo ndâ ꞌduù gbí gbata Kòràzínì ta ndâ ꞌduù gbí gbata Bètìsàyídà bà dù á nje ! Tacó ye táánò má bàkà ndâ kpo-kpò seṛè tí nó náa ye bàkà ji yo nó a i ji ndâ ꞌduù gbí ndâ gbata Tírò ta Sìdónì, ndú kpónó dù zùkùù gítí ndâ vò i mì ndú sàà gî. ");
INSERT INTO ndz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Káa ye kû ꞌdè có ji yo ta yúcó, máa, Mbíṛì bà waa có mítí yo wúnò ta ndòngbú o ta wotí tí  ndii ŋìndi ndâ ꞌduù gbí gbata Tírò ta ndâ ꞌduù gbí gbata Sìdónì gî. ");
INSERT INTO ndz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Káa yo, ndâ ꞌduù gbí gbata Kàpàrànáwùmù! Yo táánò máa yo bà oko tí yo énò yee tàṛì? Mbíṛì wúnò bà kaa yo mítí vò bàndò á bìndi ku mì yo. Tacó ndâ seṛè mì ye táánò náa ye bàkà ndú ji yo nó má a i ji ndâ ꞌduù gbí gbata Sòdómà, Mbíṛì táánò bà doo Sòdómà wálá. ");
INSERT INTO ndz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Má énò, yo kpolo tí yo máa Mbíṛì bà waa có mítí yo ta ndòngbú o ta vò tí  ndii bà doo ndâ ꞌduù mì wó á Sòdómà ta wu gî.» ");
INSERT INTO ndz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ta o tí nò Jézù giì ꞌdeke tí wó ji Mbíṛì, máa, «Ye ꞌdè nìkì maa ji wò tí Bu ye, tí mbe tí ndâ gbíṛì ta to, tacó bà ꞌdè gbí tí lo ji ndâ ꞌduù ŋìnó ta ṛo ndú mbe njaanga kálásê nó, si ndâ mbe ꞌdi gbí-o mí to. ");
INSERT INTO ndz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ìyoo, Bu ye, ye ùnje gî máa, àá táánò nìkì tí lo énò. ");
INSERT INTO ndz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Wò tí Bu ye kaa ndâ i ꞌdáá gî á mí ꞌbì ye gî. ꞌBí ꞌduù gbaànjé mbe ꞌdi gbí ꞌViì mì lo muu to tí nó wálá, à káa wò tí Bu ye. ꞌBí ꞌduù gbaànjé delè mbe ꞌdi gbí lo tí Bu ye á muu to tí nó wálá, à káa ye tí ꞌViì mì lo, giì toko mítí ndâ ꞌduù ŋìnó ta go bà tùbà tí lo ji ndú tí ꞌViì mì lo nô. ");
INSERT INTO ndz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Wo yo má co ta bà bàkà du nèté gî, wo yo má co ta bà te du i gî, yo gì gí mì ye, wàa yo ꞌví tèwo yo. ");
INSERT INTO ndz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yo zèè nje koṛi tí nó á pààpì ye nô, wàa ye ꞌví nìbà bà làngà koṛi ji yo, tacó ye a mbe zèè ndâ ꞌduù ta pétékè ꞌbì, tí mbe ꞌdê njembí, wàa yo ꞌví tèwo yo. ");
INSERT INTO ndz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tacó bà te koṛi tí nó á pààpì ye nó kpolo lá, káꞌi tí nò náa ye kû làngà nò delè me duù lá.» ");
INSERT INTO ndz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ta ꞌbí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gbaànjé, si ndâ Jézù ta ndâ mbe tala có mì wó kû nò ndô ta ndi gbí ndâ njí, ndâ mbe tala có mì wó giì nò ta bà kpaṛaka muu cû kû zò tí ꞌveè gítí go. ");
INSERT INTO ndz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ŋò ndú tí , ndú giì ꞌdè có ji Jézù ta kpo tàkòcò, máa, «Ŋò káa ŋa i tí nò náa ndâ mbe tala có mì lo kû bàkà nò gi! Ŋa i tí nò kpónó náa ndú kû bàkà nò me i bà báká-bàkà ta ṛi bà wotí gbí tàkìì mì ndoo tí ndâ Jùdéyà lá.» ");
INSERT INTO ndz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Yo jé ꞌdeke có tí nó gbí wáràgà mì Mbíṛì gítí ŋa i tí nó náa Dàvídè tí gbolò gba mì ndoo tí ndâ Jùdéyà bàkà táánò ta o tí nó náa go bàkà ta ndú ta ndâ mbe ko tàkò wó nó lá? ");
INSERT INTO ndz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Có tí nó gítí bà ṛì Dàvídè gí tà ꞌbá-Mbíṛì, bìndi  yí giì kaa ndâ kù kô tí nó náa à ci ndú ji Mbíṛì gî, ya tí  ji ndú ta ndâ mbe kû ko tàkò wó, bìndi  ndú giì zò ta ndú nó? Yo jé ꞌdi lá? Káa à kû zò ndâ kù kô tí nò náa à ci ndú ji Mbíṛì gî nò gbí tàkìì mì ndoo tí ndâ Jùdéyà káa ndâ bu-Mbíṛì cuki. ");
INSERT INTO ndz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","«Yo má ꞌdeke ŋìnò lá, yo jé ꞌdeke có tí nó gbí wáràgà mì Mòze máa, bà bàkà nèté gítí i-cí-ci mì ndâ bu-Mbíṛì ta ṛi bà wotí me vò i lá nó, lá? ");
INSERT INTO ndz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Káa ye kû ꞌdè có ji yo, máa, ꞌbí i mbe me gbolò á co tí ꞌbá-Mbíṛì gî kpónó kuu nô. ");
INSERT INTO ndz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yo táánò má ꞌdi gbí có tí nó náa à cu mí gbí wáràgà mì Mbíṛì máa, Mbíṛì máa, ‹À tí ye a go nambeè; go bà waa mbelè tí ye wálá› nó gî, yo kùtàá bà waa có mítí ndâ ꞌduù ŋìnó ta vò i mì ndú wálá nó wálá, tacó a yê ṛo ndú ká bà dù tí yo. ");
INSERT INTO ndz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tacó ꞌViì-mì-ꞌDakò a mbe tí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bìndi  Jézù giì njè nó ꞌdo bà-i-nò ya gítí ꞌbí bàndò bà kili ndâ Jùdéyà gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Bìndi  yí giì ꞌde ꞌbí ꞌdakò náa ꞌbì wó gbaànjé pizoo gî, gbí òkò tí ndâ ꞌduù á kà. Ndâ ꞌbí ꞌdakò ta go bà pà kpokèjì bà kpì ngbàngà tí Jézù tí ndú mâ giì ŋò Jézù, ndú giì ꞌvee yí, máa, «Bà ꞌvala ꞌduù ta ṛi bà wotí gbí tàkìì mì ndoo tí ndâ Jùdéyà a vò i?» ");
INSERT INTO ndz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Káa Jézù giì ꞌvìsì có ji ndú, ta bà ꞌvee ndú, máa, «I-kó-ko mì ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí yo nò kpónó má ꞌva tí gbí gùù ta ṛi bà wotí, yí bà ya gí bà ja yí ꞌdo gbí gùù tí nò gí sè wálá? ");
INSERT INTO ndz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Káa có tí ꞌduù kpolo ndii có tí i-kó-ko gî! Má énò, bà bàkà tó i ji ꞌduù ta ṛi bà wotí dú.» ");
INSERT INTO ndz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bìndi  Jézù giì ꞌdè có ji ꞌdakò tí nò ta pìzô ꞌbì wó nò, máa, «Yaꞌva gbí ꞌbì lo.» ꞌDakò tí nò mâ giì yaꞌva gbí ꞌbì wó go có tí nò náa Jézù ꞌdè ji yí nò, wu giì gì gí gbí ꞌbì wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ŋò bà ꞌvala ꞌdakò tí nò mì Jézù ta ṛi bà wotí, ndú giì kaa ta bà muu ndú ya gí ndiì ꞌdo gbí òkò tí ndâ mbè ꞌduù tí nò tacó bà pà kpokèjì gítí bà zi Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Có wàtà mì ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ꞌva tí gbí tù Jézù, yí giì njè nó ꞌdo bàndò tí nò gî. Káa ndâ ꞌduù me mbè giì kaa gí tàkò wó. Bìndi  yí giì ꞌvala ndâ mbe nòꞌo ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Káa yí giì kpo-gbí-tà-tù ndú máa, ndú ꞌví kpolo tí nje ndú ꞌdo tí ṛè yì, tacó go wo tí wó wálá. ");
INSERT INTO ndz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jé ká go có tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì ꞌdè sàà gî, máa, Mbíṛì máa, ");
INSERT INTO ndz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ŋìnó a bòò mì ye náa a ye ká cu ꞌbì ye mítí wó ꞌdo gbí òkò tí ndâ ꞌduù. Yí a bà ṛo ye, tí bà njembí ye, tí wú-gbí-ṛé ye. Ye bà si Bèṛi mì ye ꞌví je wotí ji yí, tacó wàa yí ꞌví nìbà yúcó mì ye ji ndâ ꞌduù muu to tí nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yí bà ꞌdèèkè mà ta bà tò kû wálá. ꞌBí ꞌduù bà ꞌdi kòcò wó ta ndi tí ndâ kpokèjì wálá. ");
INSERT INTO ndz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yí bà dù tí mbe zèè ndâ ꞌduù ŋìnó ta wotí tí wó ndii ndú gî nó ta pétékè ꞌbì. Yí bà ꞌvala ta ndâ ꞌduù ŋìnó ta dúú kpokèjì tí ndú wálá nó lèè énô, yee tí o bà lò muu gìṛì mì ndâ ꞌduù ji yúcó. ");
INSERT INTO ndz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ndâ ꞌduù ꞌdáá gî bà giì koṛo ꞌválá lì ká mítí wó.» ");
INSERT INTO ndz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bìndi  ndâ ꞌduù giì gì ta ꞌbí ꞌdakò tí mbe sú ṛo, ta i-gbí-muu wó mbe tii bà ꞌdè có ꞌdo tí wó gî. Bìndi  Jézù giì ꞌvala yí ꞌdo gbí ndâ nòꞌo mì wó nò ꞌdáá gî. Yí bà-i-nò giì ꞌbìtà bà ŋò ndâ i, ta bà ꞌdè có. ");
INSERT INTO ndz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nje ndâ ꞌduù ꞌdáá gî giì ꞌdèè gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú, máa, «Ŋìnó ꞌví dù a ꞌViì mì Dàvídè ká nó?» ");
INSERT INTO ndz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Káa ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ꞌdi có mì ndâ ꞌduù tí nò, ndú giì ꞌvìsì có gí tàkò , máa, «A Bèlìzèbúlù tí Gba-vò-i ká kû je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ji yí.» ");
INSERT INTO ndz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Káa Jézù mâ giì ŋò ŋa bà koṛo có mì ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà nò, yí giì ꞌvìsì có ji ndú, máa, «Có mì ndâ bòò mì gba má toko lá, gba tí nò bà zogo ꞌbá wálá. Có mì ndâ ꞌduù gbí gbata mì ndú má toko lá, gbí gbata tí nò bà dù wálá. Có mì ndâ ꞌduù á njekèjì mì ndú delè má kili tí lá, ꞌbá tí nò gí bà sì tí wálá. ");
INSERT INTO ndz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Má énò, Gba-vò-i má kû mòkò Gba-vò-i ꞌdo gbí muu ndâ ꞌduù, Gba-vò-i bà giì zèè ꞌbá ée? ");
INSERT INTO ndz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","À má dú káa yúcó máa Bèlìzèbúlù tí Gba-vò-i ká kû je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ji ye, à ꞌví dù a ꞌdi ká kû je wotí bà ko ndâ i ꞌdo gbí muu ndâ ꞌduù ji ndâ kpo-kpò mbe kû ko ndâ i ꞌdo gbí muu ndâ ꞌduù gbí òkò tí yo? Yo ꞌvee ndú wàa ndú ꞌví waa có tí nò ji ndoo. ");
INSERT INTO ndz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Káa ye má kû mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ta wotí mì Bèṛi-mì-Mbíṛì, gbí có tí nò go énó máa, Mbíṛì gì tí gba mì yo gî. ");
INSERT INTO ndz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«ꞌBí ꞌvé kákáꞌi náa yo ꞌví te mí gbí muu yo a ŋìnó máa: ꞌDuù bà ṛì gí tàꞌi mì wu ꞌdakò tacó bà tuṛu ndâ káꞌi mì wó ta wotí ée? Sè  káa ŋìnó máa mbe ngbà tí nò ꞌví dù a ngbílí mbe da gbí ka wó ngbílí, má wálá ndí  bà dù ká tó kà. ");
INSERT INTO ndz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ꞌDuù má me ꞌduù mì ye lá, yí a ka ye mbe có. Mbe biya bà kili i ta ye gî, a mbe jaaka gbí i. ");
INSERT INTO ndz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Má énò, ye kû ꞌdè có ji yo máa, Mbíṛì bà je à-cee-gî ji ndâ ꞌduù gítí ndâ ꞌbí ŋa vò i mì ndú, ta ndâ ŋa zu có ŋìnó náa ndú ꞌdè gítí wó tí Mbíṛì nó ꞌdáá gî, gî; káa ndâ mbe ꞌdè zu có gítí Bèṛi-mì-Mbíṛì bà ꞌde à-cee-gî wálá. ");
INSERT INTO ndz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mbíṛì delè bà je à-cee-gî ji ꞌduù mbe ꞌdè zu có gítí ꞌViì-mì-ꞌDakò gî; káa ꞌduù má ꞌdè zu có gítí Bèṛi-mì-Mbíṛì, Mbíṛì bà je à-cee-gî ji yí muu to tí nó wálá. Yí delè bà je à-cee-gî ji yí bìndi ku mì wó wálá. ");
INSERT INTO ndz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Ndâ kú i gbí njí má ta banga tí ndú, ndú kû jò ta banga tí . Káa ndú má soloko gî, banga tí bà jò ndú wálá. À ŋò banga kú i ni ká mítí ŋa bà jò yí. ");
INSERT INTO ndz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yo kû bàkà nambeè-nje ta ndâ ꞌduù, káa njembí yo go jâ kpoo. Tacó ꞌduù ta o ꞌdáá gî kû ꞌdè káa ŋa có tí nó mbe yè gbí njembí wó gî nô. ");
INSERT INTO ndz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tó ꞌduù ta tó có gbí njembí wó kû ꞌdè ji ndâ ꞌduù káa tó có tí nó gbí njembí wó nô. Káa vò ꞌduù ta vò có yè gbí njembí wó gî ta o ꞌdáá gî kû ꞌdè káa vò có. ");
INSERT INTO ndz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Má énò, ye kû ci yo gítí , máa, Mbíṛì bà waa có mítí ndâ ꞌduù ta ndòngbú o tacó ndâ ŋa ndâ có tí nó náa ndú kû ꞌdè ta bà koṛo gbí ndú lá nó gbaànjé-gbaànjé ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tacó ta o tí nò, à káa nje ꞌduù ká bà njaanga wú ꞌdo tí miṛi wó. À delè káa nje ꞌduù ká bà ga wú mítí miṛi wó.» ");
INSERT INTO ndz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bìndi  ndâ ꞌbí mbe ꞌdi gbí tàkìì, ta ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà giì ꞌdè có ji Jézù, máa, «Mbe nìbà i, go  kuu tí ze énó máa wò bàkà gbolò seṛè ji ze.» ");
INSERT INTO ndz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Ndâ ꞌduù tí nó gbí o tí nó nó káa cèe ndâ vò ꞌduù sínò ta mbíṛì mì ndú wálá. À tè ta yo káa seṛè mì Jónà tí mbe ꞌdòkò có mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jónà dígísèé dù gbí yì gbù sè ta ṛi taꞌô, ta bèbìlì delè taꞌô. Má énò, ꞌViì-mì-ꞌDakò delè kèjì gí bà dù á tà to ta ṛi taꞌô, ta bèbìlì delè ");
INSERT INTO ndz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mbíṛì wúnò bà waa có mítí ndâ ꞌduù tí nó gbí o tí nó nó ta ndòngbú o ꞌdo gbí có mì ndâ ꞌduù gbí gbata Nínèvà, tacó ndú táánò ꞌvìsì muu ndú ꞌdo tí ndâ vò i mì ndú bìndi bà kò-kò ta có mì Mbíṛì mì Jónà ji ndú gî. Káa kpónó ꞌbí ngú có bà kò-kò tí  mbe me gbolò ndii có tí nó náa Jónà kò-kò tí  dígísèé nó yee gî. ");
INSERT INTO ndz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gbolò gba-niì tí nó ta ꞌbá mì wó á gbí to Sébà nó, wúnò bà kpì ngbàngà tí yo ta o bà waa có. Tacó yí táánò gì ngé ꞌdo ꞌbá mì wó me ꞌdú gí bà ꞌdi có mì gbolò gba tí nó tí Sólómònì tí gbolò mbe ꞌdi gbí-o nó gî. Káa ye kû ꞌdè có ji yo ta yúcó, máa, ꞌbí i mbe me gbolò ndii Sólómònì gî kpónó kuu nô. ");
INSERT INTO ndz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«I má co ꞌdo gbí muu ꞌduù, i tí nò kû ya gí bà wùùkù to ta ndi gbí kángáá nga ngoò ta ngo gbí  wálá, kû pà bàndò bà dù tí . À má giì kpò yí gî, ");
INSERT INTO ndz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yí bà giì ꞌdè có máa, ‹Ngèlè-ndiì kpò a ngo. Má énò, ye bà dele ká gítí ká ꞌbá mì ye.› Yí má dele ndi wó gì gí bà ꞌde muu ꞌduù tí nò ngbáṛángàꞌi, ta ꞌbí i-gbí-muu wó wálá, ");
INSERT INTO ndz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","yí bà ya gí bà kaa ndâ ꞌbí i vô-nje só mbe volo ndii yí gî, bìndi  ndú bà ꞌvala ta ndú mí gbí muu ꞌduù tí nò gî. Gbí ndòngbú , ꞌduù tí nò bà volo ndii ŋìnó sàà kùṛo nó gî, ŋìnò a ŋa i tí nó bà bàkà tí mítí ndâ ꞌduù tí nó gbí o tí nó, nó ká nò.» ");
INSERT INTO ndz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Káa si Jézù kû ꞌdè có ji ndâ mbè ꞌduù tí nò kálásê, ndâ nawu wó ta ndâ náꞌvindí wó giì ṛò tíyò sè, tacó bà ꞌdè có ta yí. ");
INSERT INTO ndz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ꞌBí ꞌdakò mâ giì ŋò ndú, yí giì ꞌdè có ji yí, máa, «Ndâ nawu lo ta ndâ náꞌvindí lo kû ṛò tíyò sè, tacó bà ꞌdè có ta wò.» ");
INSERT INTO ndz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò, máa, «Nawu ye a ꞌdi? Ndâ náꞌvindí ye a ndâ ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bìndi  yí giì tù ꞌbì wó gítí ndâ mbe tala có mì wó, máa, «Ŋìnó a ndâ nawu ye. Ŋìnó a ndâ náꞌvindí ye. ");
INSERT INTO ndz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ꞌDuù má bàkà go có mì Bu ye á gbíṛì gî, ꞌduù tí nò a náꞌvindí ye, ꞌduù tí nò a námì ye, ꞌduù tí nò a nawu ye.» ");
INSERT INTO ndz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jézù giì njè nó ꞌdo ꞌbá ta gbèe ṛi tí nò ya gí bà ki tí wó to á yì kàpá. ");
INSERT INTO ndz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bìndi  ndâ ꞌduù me mbè ta ŋa  wálá giì kaa ya gí tàkò wó tàbèꞌdè kà. Bìndi  ndú giì tì jèlè yí ꞌdee gî. Ndâ ꞌduù tì me mbè tí ŋa ŋìnó náa Jézù giì co ꞌdo gbí òkò tí ndú ya gí bà ki tí wó gbí gbâ a ṛo ngo ta kpéétí wó jee ndâ ꞌduù ꞌdáá kû ṛò tíyò á tì ngo. ");
INSERT INTO ndz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bìndi  yí giì ꞌbìtà bà ꞌdè ndâ có ji ndú me mbè gbí lòkóꞌbò. Jézù giì lòkòꞌbò có ji ndâ ꞌduù, máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò giì ya gí bà va ŋa gbí njí mì wó, ");
INSERT INTO ndz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","káa ta o tí nó si yí kû va ŋa nó, ndâ ꞌbí njì ŋa giì ꞌvaka tí á ta ndi tí kpokèjì. Bìndi  ndâ nuù giì ṛuka ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ndâ ꞌbí  giì ꞌvaka tí ta ndi gbí ṛo ndâ díí mbe le ta gbí njí ta làmbu njú to ṛépè-ṛépè pí ndú. Síí ndú mâ giì yee gí sè, ");
INSERT INTO ndz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ṛi giì mìì ndú gî, tacó tà teè ndú ya gí tà to tè lá. ");
INSERT INTO ndz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ndâ ꞌbí njì ŋa giì ꞌvaka tí ta ndi gbí òkò ndâ bè kpeṛè náa à cutu ndú lá ta ndi gbí njí. Ndâ bè kpeṛè tí nò giì uu ꞌbuuku muu ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ndâ ꞌbí njì ŋa giì ꞌvaka tí gbí banga zì to. Bìndi  ndú giì jò ta banga muu ndú gbe-gbè, gbe-gbè, gbe-gbè. ");
INSERT INTO ndz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Má énò, ꞌduù ŋìnó ta tù kuu tí muu wó nó ꞌví ꞌdi có.» ");
INSERT INTO ndz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jézù mâ giì yee nje bà ꞌdè lòkóꞌbò gítí mbe va ŋa gî, ndâ mbe tala có mì wó giì yèè gí ṛègbà tí wó, bìndi  ndú giì ꞌvee yí, máa, «Wò kû ꞌdè có ji ndâ ꞌduù tí nò gbí lòkóꞌbò tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Káa yí giì ꞌvìsì có ji ndú, máa, «À je muu bà ꞌdi gbí ngìì ndâ có kóó mì Gba-gbíṛì ji yo gî. Káa à ꞌdè gbí ngìì tí nò ji ndú lá. ");
INSERT INTO ndz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tacó à kû je i gí bà i, káa i má mì ꞌduù wálá, àá bà aaka làmbu ŋìnó á kpátù ꞌbì wó nó gî. ");
INSERT INTO ndz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ye kû ꞌdè có ji ndú gbí lòkóꞌbò tacó ndú kû zekeꞌo, káa ndú ŋò i lá. Ndú delè kû ꞌdi kòcò, káa ndú ꞌdi gbí có tí nò lá. ");
INSERT INTO ndz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì táánò ꞌdè có gítí ŋa ndâ ꞌduù tí nò, énó máa, ‹Yo bà ꞌdi dú káa kòcò ꞌduù, káa yo bà ꞌdi gbí có tí nò náa yí kû ꞌdè nò wálá. Yo bà zeke ṛo yo ndo gî, káa yo bà ŋò i tí nò náa yo kû zeke nò wálá. ");
INSERT INTO ndz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tacó njembí ndâ ꞌduù tí nó gbì kàángbá gî, tù ndú me duù gítí bà ꞌdi có, ndú delè neke ṛo ndú gî, tacó à tí ndú a gúku bà ŋò ndâ i ta ṛo ndú. Ndú kû cì gúku máa ndâ yì má ꞌdi gbí có, ndâ yì bà giì ꞌvìsì muu ndâ yì ꞌdo tí ndâ vò kpokèjì mì ndâ yì, bìndi  ye bà giì ꞌvala ndâ yì.› ");
INSERT INTO ndz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Káa pá yo nìkì ngé ndii gî, tacó yo kû ŋò i ta ṛo yo, yo delè kû ꞌdi có ta tù yo. ");
INSERT INTO ndz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ye kû ꞌdè có ji yo ta yúcó máa, ndâ mbe ꞌdòkò có mì Mbíṛì, ta ndâ tó ꞌduù mì Mbíṛì táánò ùndi bà ŋò i tí nó kpónó náa yo kû ŋò nó kpòò, káa ndú ŋò lá. Ndú delè ù bà ꞌdi có tí nó náa yo kpónó kû ꞌdi nó kpòò, káa ndú ꞌdi lá. ");
INSERT INTO ndz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Má énò, yo sè tù yo, wàa ye ꞌví ꞌdè gbí lòkóꞌbò gítí mbe va ŋa ji yo. ");
INSERT INTO ndz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ndâ ꞌduù ŋìnó mbe ꞌdi có gítí bà dù Mbíṛì tí gba, káa ndú ꞌdi gbí  lá, go ndâ njì ŋa ŋìnó mbe ꞌvaka tí ta ndi tí kpokèjì. Vò-ꞌduù-tí-nò ṛa có tí nó náa à ṛò mí gbí njembí wó nò gálà gî. ");
INSERT INTO ndz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ndâ njì ŋa ŋìnó mbe ꞌvaka tí ta ndi pí ndâ díí nó, go ndâ ꞌduù ŋìnó mbe co gálà gí bà ꞌdi có tí nò ta pétékè tàkòcò ndú, ");
INSERT INTO ndz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","káa có tí nò ya gí gbí njembí ndú lá, tacó có tí nò dù gbí njembí ndú ká ta làmbu o gàà énô. À mâ giì pèè mbí ndú, ta bà gbùṛùngà ndú muu có tí nò, ndú giì jee mí to gî. ");
INSERT INTO ndz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ndâ njì ŋa ŋìnó mbe ꞌvaka tí ta ndi òkò ndâ bè kpeṛè nó, go ndâ ꞌduù ŋìnó mbe ꞌdi có tí nò, káa bà tee njembí ndú mítí ndâ i muu to tí nó, ta bà dù ta go ndâ kpo-kpò i giì tii bà bàkà nèté mì có tí nò gbí njembí ndú nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Káa ndâ njì ŋa tí nó mbe ꞌvaka tí ta ndi gbí banga zì to nó, go ndâ ꞌduù ŋìnó mbe ꞌdi có tí nò, bìndi  ndú giì bàkà tó i túkàꞌi, go ndâ kú i ŋìnó mbe jò gbí banga zì to, jùꞌbù-jùꞌbù, jùꞌbù-jùꞌbù nô.» ");
INSERT INTO ndz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ta o tí nò Jézù giì ꞌdè ꞌbí lòkóꞌbò kákáꞌi ji ndâ ꞌduù, máa, «Bà zogo to mì Gba-gbíṛì go énô: Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò giì ya gí bà ṛò tó ŋa cû mí gbí njí mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Káa ndâ ꞌduù mâ giì mìì ta ṛì ta bèbìlì gî, ꞌbí ꞌduù mbe kû sogo yí giì ngbà tí wó ya gí bà ṛò njì cû-kècè cee gbí òkò ṛó-ṛò i mì wó nò dí bà ndòngbú . ");
INSERT INTO ndz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ndâ cèe cû giì kù gí sè ŋònòkò ta cû-kècè, ndú giì uu gí yaà gbaànjé. À káa o bà giì jò cû, bìndi  ndâ mbe bàkà nèté gbí njí bà giì ŋò cû-kècè ni . ");
INSERT INTO ndz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bìndi  ndú giì ꞌvee mbe njí, máa, ‹Buù, ndoo táánò goòlá ṛò mí gbí njí a cèe ŋa cû le! Káa cû-kècè giì gì ꞌdo kòtí ꞌdi?› ");
INSERT INTO ndz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«Káa mbe njí giì ꞌvìsì có ji ndú, máa, ‹Àá bà dù a ꞌbí ꞌduù mbe kû sogo ye ká bà ṛò cû-kècè mí gbí njí mì ye.› «Bìndi  ndâ mbe nèté giì ꞌvee mbe njí, máa, ‹Má énò, ze ya gí bà ndoo ndâ cû-kècè ꞌdo gbí òkò cèe cû gî wàà?› ");
INSERT INTO ndz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Káa mbe njí giì ꞌvìsì có ji ndú, máa, ‹Énò lá, tacó tà teè ndú kpónó gò ŋònòkò ta teè cèe cû gî. ");
INSERT INTO ndz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yo si káa ndú má yù ꞌdáá ta ndâ cèe cû gbaànjé gî, bìndi  ndâ mbe waa cû ꞌví waa kùṛo a cû-kècè, ndú má doo ta wu gî, bìndi  ndú ꞌví giì waa cèe cû tacó bà ya tí  gí gbí gálá.› » ");
INSERT INTO ndz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jézù giì ꞌdè ꞌbí lòkóꞌbò kákáꞌi máa, «Bà zogo to tí nó mì Gba-gbíṛì ká go i-ꞌdì nô, go njì ndí náa wò má ŋò nékéléé go i-ꞌdì nô; káa ndú má kù tí mû gî, ");
INSERT INTO ndz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ꞌbí ŋa mû mbe gèè bè ꞌvii ta ndú wálá, náa ndâ nuù kû gèè ꞌbá mì ndú ta gbí .» ");
INSERT INTO ndz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jézù giì ꞌdè ꞌbí lòkóꞌbò ji ndâ ꞌduù, máa, «Bà zogo to tí nó mì Gba-gbíṛì ká go làmbu njú ṛúꞌbù náa niì kû soo mítí gbolò mò kô pe njíꞌdí-njíꞌdí yee tí o bà nì pe.» ");
INSERT INTO ndz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jézù ta o tí nò ꞌdè ndâ có ji ndâ ꞌduù ꞌdáá ká gbí lòkóꞌbò. Yí biya bà ꞌdè có jáá ji ndú gî, ");
INSERT INTO ndz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","go có tí nó náa ꞌbí mbe ꞌdòkò có mì Mbíṛì ꞌdè sàà énó, máa, «Ye bà ꞌdè có ji ndú gbí ndâ lòkóꞌbò, ye bà yù gbí ndâ có kóó tí nó náa ndú jé ꞌdi lá ꞌdo tí o bà suu to tí nó nó gí sè,» nô. ");
INSERT INTO ndz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jézù mâ giì njè nó ꞌdo mì ndâ mbè ꞌduù tí nó ya gí ꞌbá gî, ndâ mbe tala có mì wó giì ꞌdè có ji yí, máa, «ꞌDè gbí lòkóꞌbò tí nó náa wò ꞌdè gítí cû-kècè gbí njí nó ji ze.» ");
INSERT INTO ndz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bìndi  Jézù giì ꞌvìsì có ji ndú, máa, «ꞌDuù tí nó mbe ṛò tó ŋa cû nó a ꞌViì-mì-ꞌDakò. ");
INSERT INTO ndz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Njí tí nò náa yí ṛò nò a to tí nô. Ndâ tó njì ŋa a ndâ ꞌduù ŋìnó tí ndâ bòò gba mì Mbíṛì nô. Bìndi  ndâ cû-kècè a ndâ ꞌduù mì Gba-vò-i. ");
INSERT INTO ndz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ꞌDuù tí nó mbe kû sogo mbe njí, mbe ṛò njì cû-kècè mí gbí njí mì wó nó a Gba-vò-i. O bà kili ndâ i ꞌdo gbí njí a ndòngbú o. Bìndi  ndâ mbe kili ndâ i ꞌdo gbí njí a ndâ basìlì mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bà waaka ndâ cû-kècè à ꞌví doo ta wu ꞌdo gbí njí ꞌvii ká ꞌvii ta bà ");
INSERT INTO ndz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","tuu ndâ basìlì mì ꞌViì-mì-ꞌDakò ta ndòngbú o gí bà ṛuka ndâ mbe bàkà vò i, ta ndâ ꞌduù ŋìnó mbe kû eendi ndâ ꞌbí ka ndú gítí bà bàkà vò i nó ꞌdo gbí òkò tí ndâ bòò gba mì Mbíṛì, ");
INSERT INTO ndz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","bìndi  yí giì ꞌvaka ndú mí tà wu, tí bàndò bà wa gbí, ta bà ꞌvìì tì ta séꞌi. ");
INSERT INTO ndz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bìndi  ndâ tó ꞌduù mì Mbíṛì bà giì co go ṛi á ꞌbá mì Bu ndú. Má énò, yo sè tù yo, náa tù bà ꞌdi có má kuu tí muu yo nò!» ");
INSERT INTO ndz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jézù giì ꞌdè ꞌbí lòkóꞌbò ji ndâ ꞌduù, máa, «Bà zogo to tí nó mì Gba-gbíṛì go énô: ꞌBí ꞌduù giì ꞌde ꞌbí ŋa kpóló-kpolo i-banga náa à ngùù mí tà to gbí njí. Yí giì tòò to gí muu , bìndi  yí giì ya gí ꞌbá ta líkíꞌo tí wó. Yí giì sì ndâ i-ꞌbá ꞌdáá gî gí ꞌdè, bìndi  yí giì kaa mboo tàkò ndú ya gí bà sì ta njí tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Bà zogo to tí nó mì Gba-gbíṛì delè go mbe nò ꞌvélè mbe kû pà ꞌbí ŋa kpóló-kpolo i-banga, ");
INSERT INTO ndz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","yí má giì ꞌde gî, yí giì sì ndâ i-ꞌbá mì wó ꞌdáá gî á gí ꞌdè, bìndi  yí giì kaa i gbí ndú ya gí bà sì ta gbolò i-banga tí nò náa yí ꞌde nò.» ");
INSERT INTO ndz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jézù giì lòkòꞌbò ꞌbí có ji ndâ ꞌduù, máa, «Bà zogo to tí nó mì Gba-gbíṛì go mbu náa ꞌduù ꞌva mí tà ngo, bìndi  yí giì ja gí sè ta ndâ ŋa ndâ i tà ngo léé gî gbí . ");
INSERT INTO ndz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bìndi  mbe ꞌva mbu giì ṛuka ndâ tó sè gí gbí káꞌi. Yí giì jaka ndâ ꞌbí vò sè ta ndâ ꞌbí i ŋìnó ta i gbí ndú wálá nó ꞌvaka gí ꞌdè. ");
INSERT INTO ndz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ŋa i tí nò tí kpokèjì gí bà bàkà tí ta ndòngbú o: Ndâ basìlì mì Mbíṛì bà giì njèè gbí òkò tí ndâ tó ꞌduù ta ndâ vò ꞌduù go énò. ");
INSERT INTO ndz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ndú bà giì ꞌvaka ndâ vò ꞌduù mí tà wu, tí bàndò bà wa gbí ta bà zò gbí tì ta séꞌi.» ");
INSERT INTO ndz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bìndi  Jézù giì ꞌvee ndâ mbe tala có mì wó, máa, «Yo ꞌdi gbí ndâ có tí nò náa ye lòkòꞌbò nò ꞌdáá gî?» Bìndi  ndú giì ꞌvìsì có ji yí, máa, «Ìyoo.» ");
INSERT INTO ndz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bìndi  yí giì ꞌvìsì có ji ndú, máa, «Má énò, mbe nìbà có mì Mòze mbe gì tí mbe tala có mì Gba-gbíṛì, go mbe ꞌbá mbe kû kaa ndâ ngú i ta ndâ ká i ꞌdo gbí gálá mì wó gí sè.» ");
INSERT INTO ndz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jézù mâ giì cee ta bà ꞌdè ndâ lòkóꞌbò ji ndâ ꞌduù gî, ");
INSERT INTO ndz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yí giì njè nó ꞌdo bà-i-nò ya gí gbí ꞌdóó gbata mì ndú Názàrètì. Bìndi  yí giì ya gí bà nìbà i ji ndâ ꞌduù á bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì. Nje ndâ mbe ꞌdi bà nìbà i mì wó ꞌdáá gî giì ꞌdèè gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú, máa, «ꞌDakò tí nò ꞌde ŋa bà ꞌdi gbí-o tí nò ꞌdo mì ꞌdi? Yí ꞌdo ta wotí bà bàkà ndâ seṛè tí nò a kòtí ꞌdi? ");
INSERT INTO ndz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","À jé nó tà go ꞌviì tí nó náa bu wò a mbe no mû nó le! Nawu wó me niì tí nó ta ṛè wó a Màríyà nó lá? Ndâ Jákòmò, ta Jùzépè, ta Sìmónè, ta Júdà me ndâ náꞌvindí wó lá? ");
INSERT INTO ndz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ndâ námì wó ꞌdáá me kuu ta ndoo to nó lá? Má énò, yí ꞌdo ta wotí bà bàkà ndâ seṛè tí nò á kòtí ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tacó énò, ndú giì biya bà ꞌdi ndâ có mì wó gî. Káa Jézù giì ꞌvìsì có ji ndú, máa, «À káa ndâ ꞌduù gbí ꞌdóó gbata mì mbe ꞌdòkò có mì Mbíṛì, ta ndâ ꞌduù gbí yâ wó ká te duù mítí wó lá.» ");
INSERT INTO ndz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tacó énò, yí giì bàkà ndâ seṛè ji ndú me mbè lá, tacó ndú tee njembí ndú mítí wó lá. ");
INSERT INTO ndz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ta o tí nó Èródè tí gbolò gba mì ndâ ꞌduù Gàlìléyà mâ giì ꞌdi tàwo Jézù, ");
INSERT INTO ndz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yí giì ꞌdè có ji ndâ ꞌduù mì wó máa, «ꞌDuù tí nò bà dù a Jòvánì tí nó tí mbe caka tí ndâ ꞌduù náa ye táánò da miṛi wó nô! A yí ká ꞌvala ndi wó ꞌdo gbí muuꞌdú wó. Ŋìnò a gbí ndeṛè ndâ seṛè tí nò mbe kû bàkà tí nò ká nò.» ");
INSERT INTO ndz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tacó àá táánò a Èródè ká tuu ndâ àsìkérì mì wó ya gí bà zèè Jòvánì, ndú giì eṛe yí te mí gbí zàà. Yí bàkà énò á muu Èródìyà tí niì mì náꞌvindí wó Fìlípò, náa yí tí Èródè ká ja yí ꞌdo tí wó kò gî. ");
INSERT INTO ndz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Káa Jòvánì ta o ꞌdáá gî kû ꞌdè có ji Èródè, máa, «Àá mì lo me yúcó tacó bà ja niì mì náꞌvindí lo ꞌdo tí wó lá, tacó à ndoo gì ndu si ndu káa wuù lá.» ");
INSERT INTO ndz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","A gbí muu Èródè ta o tí nò a có bà zi Jòvánì, káa gúku ndâ ꞌduù mbe si Jòvánì tí mbe ꞌdòkò có mì Mbíṛì giì kpò yí gî. ");
INSERT INTO ndz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ta o kàrámà bà jò Èródè, nájú Èródìyà giì dù ṛu ji ndâ Èródè ta ndâ wiṛi mì wó. Ṛu mì ꞌvinî tí nó giì peteke tàkòcò Èródè ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bìndi  yí giì see tí wó ji ꞌvinî tí nó, máa yí kpêtí má yù ꞌdo tí yì káa ŋa yè wè, yì bà je ji yí gî. ");
INSERT INTO ndz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nawu ꞌvinî tí nò, tí Èródìyà, mâ giì ꞌdi có tí nò, yí giì ya gí gbí muu nájú wó, máa, yí ya gí bà ꞌdè có ji Èródè máa, «Je muu Jòvánì tí mbe caka tí ndâ ꞌduù ji ye mí gbí sânì kpónó mí kùṛo ndâ ꞌduù tí nò.» ");
INSERT INTO ndz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Gbí dìì Èródè giì ciki ta bà ꞌdi ŋa có mì ꞌvinî tí nò gî. Káa yí mâ giì koṛo có bà see tí tí nó náa yí see ta tí wó á mì kùṛo ndâ wiṛi mì wó ꞌdáá gî nó, nô bà ꞌvìsì muu wó giì kpò yí gî. Tacó énò, yí giì ꞌdè có ji ndâ àsìkérì mì wó, ");
INSERT INTO ndz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","máa, ndú ya gí bà da muu Jòvánì ꞌdo gbí zàà gì tí  ji ꞌvinî tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ndâ àsìkérì bà-i-nò giì ya gí bà da muu Jòvánì, ndú giì te mí gbí sânì, ndú giì ya tí  ji ꞌvinî tí nò. Bìndi  yí giì te ya tí  ji nawu wó. ");
INSERT INTO ndz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ndâ mbe tala có mì Jòvánì giì kaa ya gí bà te ku wó. Ndú mâ giì duu yí gî, ndú giì ya gí bà ꞌdè có  ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jézù mâ giì ꞌdi có ku Jòvánì, yí giì di ngo ta gbâ ta kpéétí wó kû ya gítí ꞌbí bàndò ta ndâ ꞌduù tí  wálá, tìto kàpá Gàlìléyà. Káa ndâ ꞌduù mâ giì ꞌdi có bà ya yí nò, ndú giì kaa ꞌdo gbí ndâ gbata ta kò ndú ya gí tàkò wó. ");
INSERT INTO ndz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yí mâ giì co gí to ꞌdo gbí gbâ, yí giì ŋò ndâ mbè ꞌduù tí nò, yê ṛo ndú giì bàkà yí ngé ndii gî. Bìndi  yí giì ꞌvala ndâ ꞌduù ŋìnó ta nòꞌo tí ndú nô. ");
INSERT INTO ndz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ndâ mbe tala có mì Jézù mâ giì ŋò ꞌdêꞌo bàkà tí gî, ndú giì ꞌdè có ji yí, máa, «O kpónó ndii gî, káa ndâ ꞌduù ta ꞌbá bà-i-nó wálá. Má énò, si ndâ mbè ꞌduù tí nó ꞌví nje gî, wàa ndú ꞌví ya gí bà pà i-zó-zò ꞌdo tí ndâ bàndò tí nó ta ndâ ꞌduù kuu tí  nô.» ");
INSERT INTO ndz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Káa Jézù giì ꞌvìsì có ji ndâ mbe tala có mì wó, máa, «Ndú bà ya wálá. Yo je i-zó-zò ji ndú wàa ndú ꞌví zò .» ");
INSERT INTO ndz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Káa ndâ mbe tala có mì Jézù giì ꞌvìsì có ji yí, máa, «Àá mì ze káa ndâ kù kô vô, ta ndâ sè sósòꞌô cuki.» ");
INSERT INTO ndz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Yo kaa ndú gì tí  ji ye.» ");
INSERT INTO ndz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Bìndi  yí giì ꞌdè có ji ndâ ꞌduù tí nò máa ndú ki tí ndú to gbí mbílì. Ndâ ꞌduù mâ, máa, giì ki tí ndú to go có mì wó nò gî, yí giì kaa ndâ kù kô nó vô, ta ndâ sè tí nó sósòꞌô náa ndâ mbe tala có mì wó kaa ji yí nó mí ꞌbì wó. Yí giì zekeꞌo gí gbíṛì, yí giì ꞌdè nìkì maa ji Mbíṛì. Bìndi  yí giì kiꞌviki gbí ndâ kù kô tí nò, bìndi  yí giì kaa ndú ji ndâ mbe tala có mì wó, bìndi  ndú giì njèè ji ndâ mbè ꞌduù tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ndâ ꞌduù ꞌdáá gî giì zò i yè yì ndú, bìndi  à giì kili ndâ sè i-zó-zò á bìndi ndú yeke ndâ kèè muuꞌbì-nje só. ");
INSERT INTO ndz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Muu ndâ ꞌdakò mbe zò i ta o tí nò; ꞌdáá gî álìfì vô. À ꞌdeke ndâ niì ta ndâ ꞌviì lá. ");
INSERT INTO ndz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ndâ ꞌduù mâ giì zò i cee gî, Jézù ngé giì je nó ji ndâ mbe tala có mì wó, máa, ndú o gbâ, wàa ndú ꞌví ya gí tìto kùṛo si yì mí ndiì kû njè ndâ mbè ꞌduù tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yí mâ giì njè ndâ mbè ꞌduù tí nò cee gî, yí giì ya gí pí gú ta kpéétí wó gí bà ꞌdeke tí wó ji Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ta ꞌdêꞌo tí nò, pípìṛi mbe kû pì ꞌdo kùṛo ndâ mbe tala có mì Jézù giì gbùṛùngà ndú gbí gbâ ta kpéétí ndú ta wotí ká tí . ");
INSERT INTO ndz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Káa Jézù giì ꞌbì nó ta kò wó có ṛo ngo á bìndi bà ꞌdo pí gú ta nje yé, kû ya gí tàkò ndú. ");
INSERT INTO ndz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ndâ mbe tala có mì Jézù mâ giì ŋò yí kèjì gítí ndú có ṛo ngo ta kò wó, gúku giì zèè ndú ꞌdáá gî. Bìndi  ndú giì ꞌdè có, máa, «A vuuvuu!» Bìndi  ndú giì pìì ta kû ta gúku. ");
INSERT INTO ndz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Káa Jézù giì ꞌdè có ji ndú, máa, «Yo zèè njembí yo! Yo cì gúku lá! A ye.» ");
INSERT INTO ndz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bìndi  a Pìyétòrò ká giì ꞌvìsì có ji yí, máa, «À dú má káa wò, ꞌdè có ji ye wàa ye ꞌví nò nó có ṛo ngo ya gí mì lo, Buù.» ");
INSERT INTO ndz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Bìndi  Jézù giì ꞌvìsì có ji Pìyétòrò, máa, «Gì !» Bìndi  Pìyétòrò giì co ꞌdo gbí gbâ kû nò nó ta kò wó có ṛo ngo kû ya gí mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Káa mbí wó má bà giì ꞌva tí pípìṛi, gúku giì zèè yí gî. Bìndi  yí giì ꞌbìtà bà ta gí tà ngo. Káa yí giì tò kû ji Jézù, máa, «ꞌVala ye, Buù!» ");
INSERT INTO ndz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jézù ngé giì yuu ꞌbì wó ya gí bà zèè ta Pìyétòrò. Bìndi  yí giì ꞌdè có ji yí, máa, «Wò kû koṛo có sósòꞌô tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ndâ Jézù ta Pìyétòrò mâ giì o gí gbí gbâ gî, pípìṛi giì ṛò bà pì gî. ");
INSERT INTO ndz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bìndi  ndâ mbe tala có mì wó gbí gbâ nó giì ùlù yí, máa, «Wò dú káa ꞌViì-mì-Mbíṛì!» ");
INSERT INTO ndz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ndâ Jézù giì di ngo ta ndâ mbe tala có mì wó ta o tí nò gí gbí to Jènèsàrétì. ");
INSERT INTO ndz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ndâ ꞌduù gbí to tí nò mâ giì ŋò Jézù ni gî, ndú giì tuṛu ndâ mbe nòꞌo gbí to tí nò ꞌdáá gî ya tí  ji yí. ");
INSERT INTO ndz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ndú giì ꞌdeke tí ndú ji yí, máa yí si ndâ mbe nòꞌo tí nò ꞌví gbala vòó nje bòngo tí wó. Ndâ mbe nòꞌo ŋìnó mbe gbala nje bòngo tí wó nó ꞌdáá giì ꞌde ꞌválá gî. ");
INSERT INTO ndz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ta o tí nò, ndâ ꞌbí mbe kpolo tí tàkìì tí ndâ ꞌbí mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà, mbe gì gí mì Jézù ꞌdo Jèrùzàlémè, giì ꞌvee yí, máa, ");
INSERT INTO ndz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ndâ mbe tala có mì lo bàkà go tàkìì mì ndâ ká gù ndoo lá tacó yè? Ndú caka ꞌbì ndú kùṛo bà zò i go i gbí tàkìì mì ndoo ndâ Jùdéyà lá.» ");
INSERT INTO ndz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Káa yo kû ṛu ndi tàkìì mì yo si có mì Mbíṛì mí to tacó yè? ");
INSERT INTO ndz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tacó Mbíṛì ꞌdè có énó máa, ‹Bàkà nèté ndâ bu lo ta nawu lo. Wàa ꞌduù má si ndâ bu wó ta nawu wó tí i lá, à ꞌví zi yí gî.› ");
INSERT INTO ndz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Káa yo giì ꞌdè có gbí tàkìì mì yo énó máa, ꞌduù má ꞌdè có ji ndâ bu wó ta nawu wó énó máa, yì ci bà i mì ndú nó náa yì máa yì bà konì ta ndú nó ji Mbíṛì gî, ");
INSERT INTO ndz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","gbí  énó máa, yí ja nó a miṛi wó ꞌdo tà nèté ndú gî. Yo kû si có mì Mbíṛì tí có ta gbí  wálá, bìndi  yo giì zèè tí kpoò a có tàkìì mì yo gbí ŋa kèjì tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yo kû eendi ndâ ꞌduù máa yo a ndâ tó ꞌduù mì Mbíṛì! Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì táánò ꞌdè gítí ŋa ndâ ꞌduù go yo nò a yúcó, máa, ");
INSERT INTO ndz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Mbíṛì máa, ‹Ndâ ꞌduù tí nó kû ùlù ye ká ta nje ndú cuki, káa njembí ndú me ꞌdú ꞌdo tí ye. ");
INSERT INTO ndz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gbí ndâ i mì ndú náa ndú kû bàkà ji ye nó wálá; ndâ có tí nó náa ndú kû nìbà nó ꞌdáá káa có mì ndâ ꞌduù.› » ");
INSERT INTO ndz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jézù giì tèꞌé tí ndâ ꞌduù me mbè. Bìndi  yí giì ꞌdè có ji ndú, máa, «Yo sè tù yo, wàa yo ꞌví ꞌdi gbí có tí nó náa ye kû ꞌdè ji yo nô! ");
INSERT INTO ndz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","À me i ŋìnó mbe ya gí gbí nje ꞌduù nó ká volo gbí yì lá. A ndâ i ŋìnó mbe co ꞌdo gbí yì ꞌduù nó ká volo yí.» ");
INSERT INTO ndz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ndâ mbe tala có mì Jézù giì ya gí mì wó bìndi bà ꞌdè có tí nò mì wó, bìndi  ndú giì ꞌvee yí, máa, «Wò ŋò ni gî máa, có tí nò náa wò ꞌdè nò zèè tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà ngé, nò gî?» ");
INSERT INTO ndz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Àá bà giì ndoo ndâ mû ŋìnó náa à me Bu ye ká ṛò ndú lá nó ta tà teè ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yo si káa ndú. Ndú a ndâ mbe sú ṛo mbe kû ja ndâ ꞌbí ka ndú mbe sú ṛo. Káa mbe sú ṛo má ja ꞌbí ka wó mbe sú ṛo, ndú só bà ꞌva tí ndú gbí gùù.» ");
INSERT INTO ndz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Káa Pìyétòrò giì ꞌdè có ji Jézù, máa, «ꞌDè gbí có tí nó náa wò ꞌdè gítí ndâ i ŋìnó mbe ya gí gbí yì ꞌduù, ta i ŋìnó mbe co ꞌdo gbí yì ꞌduù nò ji ze.» ");
INSERT INTO ndz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Muu yo di tí kpónó kpolo ká go muu sè ndâ ꞌbí ꞌduù delè. ");
INSERT INTO ndz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yo ŋò ni lá máa, i ŋìnó mbe co gbí nje ꞌduù ya gí gbí yì wó nó, kû ndii co gbí yì wó ya gí tà mbílì? ");
INSERT INTO ndz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A ndâ i ŋìnó mbe gì ꞌdo gbí yì ꞌduù nó ká volo ꞌduù, tacó ndú gì ꞌdo gbí njembí ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tacó ndâ vo-vò kóṛó-koṛo có, go: bà koṛo có gítí bà zi ꞌduù, ta bà koṛo có gítí bà bàkà bangbaya, ta bà koṛo có gítí bà-nò-vò-ndô, ta bà koṛo có gítí bà ngbà i, ta bà koṛo ꞌvéṛè gítí ndâ ꞌbí ꞌduù, ta bà koṛo vò có gítí ndâ ꞌbí ꞌduù, ");
INSERT INTO ndz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ta bà ꞌdè có gítí ŋa ndâ i tí nò ká kû volo ꞌduù. Káa bà caka ꞌbì a kùṛo bà zò i lá volo ꞌduù lá.» ");
INSERT INTO ndz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jézù giì njè nò ꞌdo Jènèsàrétì ya gí gbí ꞌbí to á dê ta ndâ gbata Tírò ta Sìdónì. ");
INSERT INTO ndz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mâ giì zekeꞌo, ꞌbí niì tí jú Kánànì ta ꞌbá mì ndú gbí to tí nò giì gì gí mì Jézù, bìndi  yí giì ꞌdeke tí wó ji yí ta bà wa gbí, máa, «Ákoo Buù, ꞌViì mì Dàvídè, ŋò yê ṛo ye. Nájú ye ta i-gbí-muu wó, káa i tí nò kû bàkà yí tí vò i.» ");
INSERT INTO ndz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Káa Jézù giì ꞌvìsì có gí tàkò có mì niì tí nò lá. Bìndi  ndâ mbe tala có mì Jézù giì ꞌdè có ji yí máa, «Si niì tí nò ꞌví co ta ŋa wo mì wó nò ꞌdo tàkò ndoo gî!» ");
INSERT INTO ndz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Káa Jézù giì ꞌvìsì có ji ndú, máa, «À tuu ye ká tacó tí ndâ Ìzìrìyélì ŋìnó go ndâ rómbo mbe giṛiꞌo gî nô cuki.» ");
INSERT INTO ndz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Káa niì tí nò giì zèè kò Jézù ta bà ꞌdeke tí wó máa, «Konì ye, Buù!» ");
INSERT INTO ndz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jézù giì ꞌvìsì có ji yí, máa, «Bà te i-zó-zò mì ndâ ꞌviì ji ndâ bô me dú lá.» ");
INSERT INTO ndz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Káa niì tí nò giì ꞌvìsì có ji Jézù, máa, «Có mì lo nò dú, Buù. Káa kpêtí ká énò, ndâ bô ngbá kû zò ndâ njúnjú i-zó-zò ŋìnó mbe kû ꞌvaka tí to ꞌdo mì ndâ mbe tí ndú nô.» ");
INSERT INTO ndz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Bìndi  Jézù giì ꞌvìsì có ji niì tí nò, máa, «Wò ùnje gítí ye ta njembí lo gbaànjé, naà! Má énò, àá bà je i mì lo ta gó  tí lo nò ji wò gî.» À káa bà ꞌdè có tí nò mì Jézù, nájú niì tí nò ngé giì ꞌde ꞌválá gî. ");
INSERT INTO ndz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jézù giì njè nó ꞌdo tí to tí nò a seè ndâ gbata Tírò ta Sìdónì nò co yì kàpá Gàlìléyà ya gí bà ki tí wó pí gú. ");
INSERT INTO ndz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bìndi  ndâ ꞌduù me mbè giì kaa ndâ mbe nòꞌo, ta ndâ mbe ósú, ta ndâ ꞌduù ŋìnó ta ndâ i-gbí-muu ndú nó ya tí  ji yí. Bìndi  yí giì ꞌvala ndú gbaànjé-gbaànjé ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nje ndâ mbè ꞌduù tí nò giì ꞌdèè ta bà ŋò ndâ ꞌduù ŋìnó ta mè ndú mbe eṛe tí gî nó kû ꞌdè có, ndâ ꞌduù ŋìnó tí ndâ mbe ósú nó gì tí ndâ cèe ꞌduù gî, ndâ ꞌduù ŋìnó ta kò ndú gbeleꞌve gî nó kû nò nó, ndâ mbe sú ṛo kû ŋò i. Bìndi  ndú giì ùlù Mbíṛì mì ndâ Ìzìrìyélì. ");
INSERT INTO ndz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Bìndi  Jézù giì tèꞌé tí ndâ mbe tala có mì wó. Yí giì ꞌdè có ji ndú, máa, «Yê ṛo ndâ ꞌduù tí nó ꞌdáá gî tí ye ngé. Tacó ndú kpónó bàkà ta ye bà-i-nó a sili taꞌô, káa i-zó-zò tacó bà je ji ndú wálá. Káa go bà njè ndú gí ꞌbá mì ndú ta go tí ndú tí ye wálá, tacó ndú bà ꞌdèè ta go mí kpokèjì.» ");
INSERT INTO ndz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Káa ndâ mbe tala có mì Jézù giì ꞌvìsì có ji yí, máa, «À ꞌví ꞌde i-zó-zò bà je ji ŋa mbè ꞌduù tí nó ꞌdo ngòó gbí ŋa to tí nó ta ndâ ꞌduù tí  wálá nó?» ");
INSERT INTO ndz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Káa Jézù giì ꞌvee ndú, máa, «Àá mì yo a ndâ kù kô ée?» Bìndi  ndú giì ꞌvìsì có ji yí, máa, «Àá mì ze a ndâ kù kô vô-nje só, ta ndâ ꞌbí vící sè.» ");
INSERT INTO ndz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jézù bà-i-nò giì ꞌdè có ji ndâ mbè ꞌduù tí nò, máa, ndú ki tí ndú to. ");
INSERT INTO ndz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bìndi  yí giì kaa ndâ kù kô tí nò á vô-nje só, ta ndâ vící sè tí nò á mì ndâ mbe tala có mì wó nò, yí giì ꞌdè nìkì maa ji Mbíṛì, bìndi  yí giì kiꞌviki gbí ndú, yí giì kaa ji ndâ mbe tala có mì wó, ndú giì njèè ji ndâ mbè ꞌduù tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ndâ mbè ꞌduù tí nò ꞌdáá gî giì zò i yè yì ndú go ŋìnó náa à nìkì tí ndú. Bìndi  à giì ṛuka sè i-zó-zò á bìndi  ndú yeke ndâ kèè vô-nje só. ");
INSERT INTO ndz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Muu ndâ ꞌdakò mbe zò i ta o tí nò ꞌdáá gî álìfì nàꞌô. À ꞌdeke ndâ niì ta ndâ ꞌviì lá. ");
INSERT INTO ndz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jézù mâ giì je nó ji ndâ mbè ndâ ꞌduù tí nò á bìndi bà zò i mì ndú gî, yí giì di ngo ta gbâ ꞌdo bà-i-nò gí gbí to Màgàdánì. ");
INSERT INTO ndz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ta o tí nò, ndâ ꞌbí mbe nìbà có gítí tàkìì mì ndâ Jùdéyà giì tala Jézù, máa yí bàkà ꞌbí i tacó bà tùbà  máa yí ꞌde wotí bà bàkà ndâ seṛè tí nó náa yí kû bàkà nó ꞌdo mì Mbíṛì ji ndâ yì. ");
INSERT INTO ndz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Tàṛì má bí-bi si ṛi ta jéé gî, yo ŋò ni gî máa, mù taàbé bà dù wálá. ");
INSERT INTO ndz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Káa tàṛì má bi tà fírí dúꞌo, yo máa, mù wúnó kèjì. Yo ŋò ŋa i tí nó kèjì gí bà bàkà tí nó ni ꞌdo tí cè tí tàṛì gî, káa ṛo yo yoo ꞌdo tí bà ŋò ndâ seṛè tí nó mbe kû bàkà tí mí kùṛo yo kpónó nó gî! ");
INSERT INTO ndz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ndâ ꞌduù tí nó mbe kû ꞌvala kpónó nó a ndâ vò ꞌduù tí ndâ mbe tee njembí ndú mítí Mbíṛì lá nó ká kû ꞌvee có seṛè! Káa àá bà tè ta ndú káa seṛè mì Jónà.» Tacó énò, Jézù giì njè nó bìndi bà ꞌdè có tí nò ꞌdo tí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ndâ Jézù má giì di ngo gí tìto gî, mbí ndâ mbe tala có mì wó bà giì ꞌva tí bà te i-zó-zò. ");
INSERT INTO ndz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Bìndi  Jézù giì ꞌdè có ji ndú, máa, «Yo kpolo tí yo ꞌdo tí ṛúꞌbù mì ndâ Fàrìzéyò ta ṛúꞌbù mì ndâ Sàdùkáyò.» ");
INSERT INTO ndz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Káa ndâ mbe tala có mì Jézù mâ giì ꞌdi có tí nò náa yí ꞌdè nò, ndú giì ꞌbìtà bà ꞌdè ngùṛù-ngùṛù có gbí òkò tí ndú, máa, «Yí kû ꞌdè có tí nò tacó ndoo gì ta i-zó-zò lá.» ");
INSERT INTO ndz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jézù mâ giì ꞌdi có tí nò náa ndâ mbe tala có mì wó kû fiini nò, yí giì ꞌvee ndú, máa, «Yo kû fiini có gbí òkò tí yo, máa, i-zó-zò wálá, tacó yè? Njembí yo gítí ye me dúú-dúú lá! ");
INSERT INTO ndz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Muu yo kpolo énò tacó yè? Bà mbí yo ò tí ndâ kù kô tí nó táánò vô náa ye kiꞌviki gbí ndú ji ndâ ꞌdakò álìfì vô nó gî? Yo ta o tí nò kili sè i-zó-zò bìndi ndú yeke a ndâ kèè ée? ");
INSERT INTO ndz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Káa ndâ kù kô tí nó vô-nje só náa ye táánò kiꞌviki gbí ndú ji ndâ ꞌdakò álìfì nàꞌô nó? Yo ta o tí nò kili sè i-zó-zò bìndi ndú yeke a ndâ kèè ée? ");
INSERT INTO ndz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Káa bà giì ꞌdi gbí  énó máa, ye kû ꞌdè có me gítí kù kô lá nò giì kpò yo ta ŋa kpokèjì ngàyi? Ye ꞌdè ji yo máa, yo kpolo tí yo ꞌdo tí ṛúꞌbù mì ndâ Fàrìzéyò ta ṛúꞌbù Sàdùkáyò.» ");
INSERT INTO ndz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ndâ mbe tala có mì Jézù bà-i-nò giì ꞌdi gbí  máa, yí kû ꞌdè có ji ndâ yì me gítí ṛúꞌbù bà bàkà kù kô lá. Yí kû ci a ndâ yì, máa ndâ yì ꞌví kpolo tí ndâ yì ꞌdo tí ndâ i tí nó náa ndâ Fàrìzéyò ta ndâ Sàdùkáyò kû nìbà ndú ji ndâ ꞌduù nô. ");
INSERT INTO ndz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ndâ Jézù mâ giì yee ta ndâ mbe tala co mì wó tí ꞌbí to á dê ta gbata Cèzàríyà mì Fìlípò gî, yí giì ꞌvee ndú, máa, «Ndâ ꞌduù kû ꞌdè có máa ꞌViì-mì-ꞌDakò a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Káa ndú giì ꞌvìsì có ji yí, máa, «Ndâ ꞌbí ꞌduù kû ꞌdè có máa yí a Jòvánì tí mbe caka tí ndâ ꞌduù. Ndâ ꞌbí ꞌduù máa yí a Èlíjà tí nó tí mbe ꞌdòkò có mì Mbíṛì nô. Ndâ ꞌbí ꞌduù máa yí a Jèrèmíyà tí nó tí mbe ꞌdòkò có mì Mbíṛì nô. Káa ndâ ꞌbí ꞌduù ŋìndi ndú máa yí a ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ká mbe ꞌdòkò có mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Káa Jézù giì ꞌvee ndú, máa, «Káa yo, yo ŋìndi yo kû ꞌdè có máa ye a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bìndi  Sìmónè giì ꞌvìsì có ji yí, máa, «Wò a Bìndi-Mbíṛì, tí ꞌViì mì wu Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jézù mâ giì ꞌdi có tí nò náa Sìmónè ꞌdè nò, yí giì ꞌvìsì có ji yí, máa, «Pá lo nìkì ngé, Sìmónè ꞌviì mì Jónà. Tacó à me ꞌbí ꞌduù ká ꞌdè gbí có tí nò náa wò ꞌdè nò ji wò lá. A Bu ye á gbíṛì ká ꞌdè ji wò. ");
INSERT INTO ndz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Má énò, ye kpónó kû ꞌdè có ji wò, máa, ṛè lo bà dù a ‹Pìyétòrò›, (gbí  máa ‹díí›). Ye bà bì ndâ ꞌduù mì ye á mbe kû kili ta ṛè ye nó á mí pí díí tí nò, náa à kpêtí káa ku, yí bà je bà i tí ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ye bà je i bà njaanga njekèjì bà ya gí gbí to mì Gba-gbíṛì á mí ꞌbì lo. I ŋìnó náa wò má ùnje gítí  muu to tí nó gî, àá bà ùnje gítí  gbíṛì gî. Káa wò má biya i muu to tí nó gî, à delè bà biya i tí nò gbíṛì gî.» ");
INSERT INTO ndz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bìndi  Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, ndú ꞌví ꞌdè gí sè máa yì a Bìndi-Mbíṛì nò gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ꞌDo tí o tí nò, Jézù giì ꞌbìtà bà ꞌdè có ji ndâ mbe tala có mì wó ngbáṛángàꞌi énó máa, «À cu mí gbí mbelè ye gî, máa ndâ kpo-ꞌduù-ꞌbá, ta ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà bà giì mèèkèꞌi tí ye. Ye bà giì kònò séꞌi me gbolò. Káa kózò tí ye bà ya gí Jèrùzàlémè. Ye ŋò ni gî máa, ndú bà giì zi ye gî. Káa bìndi sili taꞌô, ye bà ꞌvala ꞌdo gbí muuꞌdú ye gî.» ");
INSERT INTO ndz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pìyétòrò mâ giì ꞌdi có tí nò, yí giì tèꞌé tí Jézù gí ndiì ꞌdo gbí òkò tí sè ndâ ꞌbí mbe tala có mì wó, bìndi  yí giì ꞌdè kòlòwò gítí wó, máa, «Mbíṛì ꞌví je ŋa i tí nò ji wò ngé gî lá, buù!» ");
INSERT INTO ndz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Káa Jézù giì ꞌvìsì có ji Pìyétòrò, máa, «Ya ꞌdo tí ye gí kàzô, ndí lo Gba-vò-i! Wó kû nè kpokèjì mì ye, tacó wò kû koṛo me ŋa bà koṛo có mì Mbíṛì lá. Wò kû koṛo a ŋa bà koṛo có mì ndâ ꞌduù muu to tí nô.» ");
INSERT INTO ndz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Káa Jézù giì ꞌvìsì tí wó gítí sè ndâ ꞌbí mbe tala có mì wó, bìndi  yí giì ꞌdè có ji ndú, máa, «Go bà dù tí mbe tala có mì ye má tí ꞌduù, ꞌduù tí nò ꞌví ò-bà-mbí miṛi wó gî. Yí ꞌví gbì gbí njembí wó gítí bà kònò séꞌi, wàa yí ꞌví gì gí bà ṛu ndi ye. ");
INSERT INTO ndz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tacó ꞌduù má bàkà tí wó tí mbe lè ngaṛànga mí tà ṛo wó ta kpéétí wó, yí a ku. Káa ꞌduù mbe giṛi miṛi wó muu ye ká bà ꞌde ꞌválá. ");
INSERT INTO ndz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Má énò, ꞌduù bà ꞌde gbí ndâ i tí nó muu to tí nó a yè, náa yí kpêtí má ꞌde ndú kpónó ꞌdáá gî, bìndi  yí giì bè gbí cèe ꞌválá bìndi ku mì wó gî? ꞌDuù bà ꞌvìsì ndâ cèe ꞌválá bìndi ku mì wó ta ŋa yè á muu to tí nó? ");
INSERT INTO ndz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tacó kùṛo o bà gì ꞌViì-mì-ꞌDakò ꞌdo gbíṛì ta ndâ basìlì ta wotí ꞌdo mì Bu wó dooko gî. Yí bà gì gí bà ko mboo ndâ ŋa ndâ i mì ndâ ꞌduù náa ndú bàkà muu to tí nó nó gbaànjé-gbaànjé ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ye kû ꞌdè có ji yo ta yúcó máa, ndâ ꞌbí ꞌduù gbí òkò tí yo kpónó mbe kû ṛò tíyò nò bà ŋò o bà gì ꞌViì-mì-ꞌDakò tí gbolò gba gî.» ");
INSERT INTO ndz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ta sili vô-nje gbaànjé bìndi o tí nò, Jézù giì kaa ndâ Pìyétòrò, ta ndâ Jákòmò ta náꞌvindí wó Jòvánì, bìndi  ndú giì ya ta ndú gí pí ꞌbí njà gú ta kpéétí ndú jee sè ndâ ꞌbí mbe tala có mì wó mí tàgbà gú. ");
INSERT INTO ndz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Káa si ndú pí gú, Jézù giì ꞌvìsì cè kózò tí wó mí kùṛo ndâ mbe tala có mì wó taꞌô náa yí kaa ndú ta yí nó gî. Gbíṛo wó giì dù kû tòngbaà go ṛi, ndâ bòngo tí wó giì ce go ꞌvì ꞌbì. ");
INSERT INTO ndz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ndâ Pìyétòrò ta ndâ Jákòmò ta náꞌvindí wó Jòvánì mâ giì zekeꞌo, ndú giì ŋò ndâ Mòze ta Èlíjà kû ꞌdè nje mì ndú ta ndâ Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bìndi  Pìyétòrò giì ꞌdè có ji Jézù, máa, «Bà dù ndoo bà-i-nó nìkì ma, buù! Ye bà tò ndâ ndùúṛù taꞌô mí bà-i-nò, gbaànjé ji wò, gbaànjé ji Mòze, bìndi  gbaànjé ji Èlíjà, náa à má nìkì tí lo gî nò.» ");
INSERT INTO ndz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Káa si Pìyétòrò kû ꞌdè có tí nò ndú mâ giì zekeꞌo gí yaà, ndú giì ŋò kùlù mù mbe kû tòngbaà yiiga muu ndú gî. Bìndi  ndú giì ꞌdi kòcò ꞌduù kû ꞌdè có gbí kùlù mù tí nò, máa, «Ŋìnó a ꞌViì mì ye, tí wú-gbí-ṛé ye, náa tàkòcò ye peteke gítí wó á ngé ma.» ");
INSERT INTO ndz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ndú mâ giì ꞌdi có tí nò, ndú giì ꞌbuku gbíṛo ndú mí to ta gúku. ");
INSERT INTO ndz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Káa Jézù giì tee ꞌbì wó ta ndi tí ndú, bìndi  yí giì ꞌdè có ji ndú, máa, «Yo a gí yaà. Yo cì gúku lá.» ");
INSERT INTO ndz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ndú mâ giì te muu ndú gí yaà go có mì Jézù nò, ndú giì ŋò Jézù ta kpéétí wó. ");
INSERT INTO ndz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Káa si ndú kû giì dele ndi ndú gí tàgbà gú, Jézù giì ꞌdè có ji ndâ mbe tala có mì wó taꞌô nò, máa, «Yo ꞌví ꞌdè có i tí nó náa yo ŋò si ndoo pí gú nó ji ꞌbí ꞌduù gbaànjé lá, yee tí o bà ꞌvala ndi ꞌViì-mì-ꞌDakò ꞌdo gbí ku.» ");
INSERT INTO ndz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Káa ndú giì ꞌvee yí, máa, «Káa ndâ mbe ꞌdi gbí-o mì ndâ Jùdéyà kû ꞌdè có máa, Èlíjà ká bà gì gí kùṛo kózò gî, tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Káa Jézù giì ꞌvìsì có ji ndú, máa, «A Èlíjà ta yúcó ká bà gì gí kùṛo tacó bà ꞌviindi ndâ i ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Káa Èlíjà táánò dú giì gì á go có mì ndú nò gî, káa ndú tí ndâ mbe ꞌdi gbí-o mì ndâ Jùdéyà ta o tí nò giì ŋò yí ni lá; bìndi  ndú giì mèèkèꞌi tí wó go ŋìnó a nìkì tí ndú gî. Má énò, ndú delè kèjì gí bà mèèkèꞌi tí ꞌViì-mì-ꞌDakò ká go ŋa ŋìnó náa ndú táánò bàkà mítí Èlíjà nò.» ");
INSERT INTO ndz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ndâ mbe tala có mì Jézù mâ giì ꞌdi có tí nò náa yí ꞌdè ji ndú nò, ndú giì ŋò ni gî máa, yí kû ꞌdè có a i gítí Jòvánì tí mbe caka tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ndâ Jézù mâ giì dele ndi ndú ꞌdo pí gú, ndú giì ꞌde ndâ ꞌduù me mbè kû ùndi ndú mí mì sè ndâ mbe tala có mì wó tí nó náa yí si ndú mí tàgbà gù nô. Bìndi  ꞌbí ꞌdakò ꞌdo gbí òkò tí ndâ ꞌduù tí nò mbe tì nò giì njè nó ya gí bà zèè kò Jézù, ");
INSERT INTO ndz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ta bà ꞌdeke tí wó ji yí, máa, «Ŋò yê ṛo ꞌviì mì ye, buù! À tí wó a vò ŋa nòꞌo dó pì. À má tanga ta ndâ ꞌbí o, à kû ꞌva yí mí tà wu, à delè kû ꞌva yí ta ndâ ꞌbí o mí tà ngo. ");
INSERT INTO ndz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ye gì ta yí ji ndâ mbe tala có mì lo, máa ndâ-ꞌbî-lá, ndú bà ꞌvala yì, káa à giì kpò ndú gî.» ");
INSERT INTO ndz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò, máa, «Yo ndâ ꞌduù tí nó gbí o tí nó nó káa cèe ndâ vóló-volo ꞌduù mbe ùnje gítí Mbíṛì lá. Yo bà lè mí tà ṛo ye a ngaṛànga? Ye bà kònò yo énò yee tí ŋa o ngàyi?» Bìndi  yí giì ꞌdè có ji ꞌdakò tí nò máa, «Te ꞌviì tí nò gì tí  gí bà-i-nô.» ");
INSERT INTO ndz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ꞌDakò tí nò mâ giì te ꞌviì tí nò ya tí  ji Jézù gî, Jézù giì do mítí i tí nò gbí muu ꞌviì tí nò, máa yí co ꞌdo gbí muu wó gî. Mâ giì zekeꞌo, gbí dìì ꞌviì tí nò giì da mbóꞌvóó ká mí to nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bìndi  ndâ mbe tala có mì Jézù náa bà ꞌvala ꞌviì tí nò kpò ndú gî nó giì ꞌvee yí si ndú ta kpéétí ndú, máa, «Bà mòkò i tí nò ꞌdo gbí muu ꞌviì tí nò kpò ze gî tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Káa Jézù giì ꞌvìsì có ji ndú, máa, «À kpò yo tacó yo tee njembí yo mítí Mbíṛì dúú-dúú lá. Ye kû ꞌdè có ji yo ta yúcó, máa, yo má tee njembí yo mítí Mbíṛì gî, kpêtí ká njíꞌdíí énó, yo má ꞌdè có ji gbolò gú tí nò, máa, ‹Yèè ndi lo ꞌdo bà-i-nò gî,› gú tí nò bà yèè ndi wó go có mì yo nò gî. ꞌBí i mbe kpò yo delè bà dù wálá. ");
INSERT INTO ndz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","À kû mòkò i go ŋa i tí nò ꞌdo gbí muu ꞌduù ká ta bà ꞌdeke tí ji Mbíṛì, delè ta bà kònò go cuki.» ");
INSERT INTO ndz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ta ꞌbí o gbaànjé, ndâ Jézù ta ndâ mbe tala có mì wó ꞌdáá gî mâ giì kili mítí ꞌbí bàndò gbí to Gàlìléyà gî, Jézù giì ꞌdè có ji ndú máa, «Ndâ ꞌduù kèjì gí bà kpì ngbàngà tí ꞌViì-mì-ꞌDakò ji ndâ ꞌdakò. ");
INSERT INTO ndz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ndú bà giì zi yí gî. Káa bìndi sili taꞌô, yí bà giì ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî.» Ndâ mbe tala có mì Jézù mâ giì ꞌdi có tí nò, ndú giì dù zuku-zùkùù ta sé có tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ndâ Jézù mâ giì yee ta ndâ mbe tala có mì wó gbí gbata Kàpàrànáwùmù, ndâ ꞌbí mbe kû kili i ꞌdo mì ndâ ꞌduù gítí ꞌbá-Mbíṛì giì gì gí mì Pìyétòrò, bìndi  ndú giì ꞌvee yí, máa, «Mbe nìbà i ji yo kû gò i gítí ꞌbá-Mbíṛì?» ");
INSERT INTO ndz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Káa Pìyétòrò giì ꞌvìsì có ji ndú, máa, «Yí kû gò i.» Bìndi  Pìyétòrò mâ giì ṛì gí tàꞌi tàkò Jézù, Jézù giì co gálà gí bà ꞌvee yí á kùṛo bà ꞌdè có mì wó máa, «Sìmónè, wò koṛo có máa ndâ kpo-kpò gba muu to tí nó kû gò i ꞌdo mì ndâ ꞌdi? Á ꞌdo mì ndâ ꞌviì mì ndú, wèè, á ꞌdo mì ndâ mbe ꞌdó-ꞌdo?» ");
INSERT INTO ndz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Káa Pìyétòrò giì ꞌvìsì có ji yí, máa, «À ꞌdo mì ndâ mbe ꞌdó-ꞌdo.» Bìndi  Jézù giì ꞌdè có ji Pìyétòrò, máa, «Má énò, à mò ndâ ꞌviì-ꞌbá ꞌdo gbí bà gò i ji gba gî. ");
INSERT INTO ndz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Káa kpêtí ká énò, a me vò i lá. Ya gí bà gò liì tàbèꞌdè kàpá. Wò má ja kpédélé sè, wò ꞌví njaa gbí nje wó, bìndi  wò bà ꞌde njì gùrúsù ꞌdo tí ngbàṛà, wò ꞌví je ya gí bà gò gítí ꞌbá-Mbíṛì á muu ndà, tacó wàa tàkòcò ndâ ꞌduù tí nò ꞌví kpolo lá.» ");
INSERT INTO ndz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ta o tí nò, ndâ mbe tala có mì Jézù giì ꞌvee yí, máa, «Gbolò ꞌduù mbe ndii ndâ ꞌbí ka wó ꞌdáá gî gbí òkò tí ze gbí ngbàngà mì Mbíṛì wúnò bà dù a ꞌdi» ");
INSERT INTO ndz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Káa Jézù giì ꞌvìsì có gí tàkò ꞌvé mì ndú nò ta bà tèꞌé tí ꞌbí làmbu ꞌviì, bìndi  yí giì ṛò yí mí kùṛo ndú. ");
INSERT INTO ndz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Bìndi  yí giì ꞌdè có ji ndú, máa, «Ye kû ꞌdè có ji yo ta yúcó, máa, yo má ꞌvìsì tí yo tí ndâ víí ꞌviì go làmbu ꞌviì tí nó lá, yo jé gí bà dù tí ndâ ŋa ꞌduù tí nó náa Mbíṛì kû zogo ndú nó wálá. ");
INSERT INTO ndz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Má énò, ꞌduù ŋìnó mbe bàkà tí wó tí làmbu ꞌviì go làmbu ꞌviì tí nó nó a gbolò ꞌduù gbí òkò tí ndâ ꞌduù tí nó náa Mbíṛì kû zogo ndú nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ꞌBí ꞌduù má te wiṛi mítí ꞌbí làmbu ꞌviì go ŋìnó ta ṛè ye, gbí  énó máa, ꞌduù tí nò te wiṛi a i mítí ye. ");
INSERT INTO ndz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Káa à ꞌvii ta ꞌduù mbe eendi ꞌbí làmbu ꞌviì go ŋìnó mbe kû tee njembí mítí ye káa bà eṛe gbolò du i mítí miṛi wó, wàa à ꞌví ꞌva ta yí gí tà wúlú ngo. ");
INSERT INTO ndz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Vò pá tí ndâ ꞌduù muu to tí nó ngé, tacó ndâ vò i mbe kû volo muu ndú ꞌdo tí bà tee njembí ndú mítí Mbíṛì ùgbù á muu to tí nó ngé ndii gî. Ndâ vò i tí nò delè jé gí bà cee wálá. Káa à volo a i ji ndâ mbe kû kili wu á gí tà ndâ vò i tí nò! ");
INSERT INTO ndz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«À má a ꞌbí ꞌbì lo gbaànjé ká kû ŋònòkò gbí òkò tí yo ta Mbíṛì, da ꞌbì lo tí nò ꞌva gí ꞌdè. À nìkì a bà ya ta gbèe ꞌbì lo gí gbí dà á bìndi ku mì lo á co tí bà kpolo tí ndâ ꞌbì lo só kpónó, bìndi  wò giì ꞌde vò bàndò bìndi ku mì lo. ");
INSERT INTO ndz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Káa à má a ꞌbí ṛo lo gbaànjé má ká kû si wò kû bèè ṛo Mbíṛì, aa ṛo lo tí nò ꞌdo gbí kélè gí ꞌdè. À nìkì a bà ꞌde ꞌválá ŋìnó mbe cee lá nó ta gbèe ṛo lo á co tí bà ꞌva wò mì Mbíṛì mí gbí vò bàndò ta wu tí  bìndi ku mì lo ta ndâ ṛo lo sósòꞌô. ");
INSERT INTO ndz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Yo kpolo tí yo ꞌdo tí bà ꞌdè có ŋónókó gítí ndâ víí ꞌviì go ndâ ŋa ŋìnô, tacó ndâ basìlì mì ndú nanaka ká kácá mí kùṛo Bu ye gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Tacó ꞌViì-mì-ꞌDakò gì gí muu to tí nó a i tacó bà ꞌvala ndâ ꞌduù ŋìnó mbe giṛiꞌo gî nô.)» ");
INSERT INTO ndz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jézù giì lòkòꞌbò có ji ndâ mbe tala có mì wó máa, «Yo koṛo có máa, muu ndâ i-kó-ko mì ꞌduù má 100, bìndi  ꞌbí  gbaànjé giì giṛi gî, yí bà si sè ndâ i-kó-ko ŋìnó 99 nó mí bàndò, bìndi  yí ꞌví ya gí bà pà bà tí gbèe ŋìnó mbe giṛi nó wálá? ");
INSERT INTO ndz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ye kû ꞌdè có ji yo ta yúcó máa, yí má ꞌde ŋìnó mbe giṛi nò gî, líkíꞌo bà bàkà yí á co tí líkíꞌo ndâ ŋìnó 99 mbe giṛiꞌo lá nó gî. Tacó go  tí wó énò máa, ꞌbí i-kó-ko mì yì gbaànjé ꞌví giṛi nò wálá. ");
INSERT INTO ndz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Có mì Bu yo gbíṛì delè ká go énò, máa muu ꞌbí làmbu ꞌviì gbaànjé go ŋìnó kuu nó nó ꞌví ba lá. ");
INSERT INTO ndz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Náꞌvindí lo má bàkà ꞌbí ŋa i mbe lè gî gítí lo, ya gí mì wó, wàa yo ꞌví ꞌviiki gbí có tí nò gbí òkò tí yo ta yí sósòꞌô. Yí má ꞌdi có mì lo nò gî, gbí  énó máa wò gì ta náꞌvindí lo dê gítí lo gî. ");
INSERT INTO ndz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Káa yí má biya bà ꞌdi có mì lo gî, tèꞌé tí ndâ ꞌbí ꞌduù go só, go taꞌô, wàa wò ꞌví ꞌdè có ta yí mí kùṛo ndú gítí có mì kponje taàbé, go có tí nó náa à cu mí gbí wáràgà mì Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yí má biya bà ꞌdi có mì ndâ ꞌduù tí nò delè gî, wò ꞌví ya ta yí gí kùṛo ndâ ꞌbí náꞌvindí yo tí ndâ mbe kû kili ta ṛè ye tí Jézù. Yí má kpo muu yo delè gî, yo ꞌví bàkà ta yí go bà bàkà i gítí vò ꞌduù ta nèté mì yo ta yí wálá. ");
INSERT INTO ndz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ye kû ꞌdè có ji yo ta yúcó máa, yo má ùnje gítí ꞌbí ŋa i muu to tí nó gî, à delè bà ùnje gítí bà bàkà i tí nò á gbíṛì gî. Káa ꞌbí i ŋìnó náa yo mà biya gî máa à ꞌví bàkà muu to tí nó lá, à delè bà biya gî, máa à ꞌví bàkà i tí nò á gbíṛì lá. ");
INSERT INTO ndz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ꞌBí có náa ye bá ꞌdè ji yo kákáꞌi a ŋìnó máa, ndâ ꞌbí ꞌduù gbí òkò tí yo, kpêtí ká go ndâ ꞌduù sósòꞌô cuki, má toko muu ndú, bìndi  ndú giì ꞌdeke tí ndú ta njembí gbaànjé tacó ꞌbí ŋa i ꞌdo mì Bu ye gbíṛì, ta ṛè ye, Bu ye bà je i tí nò náa ndú yù nò ji ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tacó ndâ ꞌduù kpêtí go sósòꞌô, go taꞌô, má kili mítí ꞌbí bàndò ta ṛè ye, ye bà dù kuu toko ta ndú á kà.» ");
INSERT INTO ndz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bìndi  Pìyétòrò giì ꞌvee Jézù, máa, «Ye ꞌví si có gítí ndâ vò i mì náꞌvindí ye náa yí bàkà mítí ye mí to yee gbí ée, Buù? Yee gbí vô-nje só?» ");
INSERT INTO ndz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Káa Jézù giì ꞌvìsì có ji yí, máa, «Me ká ta bà  vô-nje só cuki lá. Ye nì ji yo a vô-nje só ta bà  vô-nje só ta bà  muuꞌbì.» ");
INSERT INTO ndz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jézù giì lòkòꞌbò ꞌbí có ji ndâ mbe tala có mì wó, máa, «Bà dù Gba-gbíṛì tí gbolò gba mì ndâ ꞌduù muu to tí nó ꞌvii ká ꞌvii ta ꞌbí gbolò gba gbaànjé mbe eṛe muu wó gítí có ba kili ndâ i mì wó ꞌdo mì ndâ kpo-kpò ꞌduù mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yí mâ giì ꞌbìtà bà tèꞌé tí ndú gbaànjé-gbaànjé, à giì gì ji yí kpédéléꞌi kùṛo a i ta ꞌduù ŋìnó náa i mì wó muu wó me gbolò ngé ndii gî nô. ");
INSERT INTO ndz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Káa kpokèjì bà dele ta ndâ i tí nò ji gba mâ giì kpò ꞌdakò tí nò gî, gba giì ꞌdè có máa, à ya gí bà mà ndâ ꞌdakò tí nò, ta niì mì wó, ta ndâ ꞌviì mì ndú, ta ndâ i-ꞌbá mì ndú ꞌdáá gî. À má sì ndú gî, à ꞌví kaa i gbí ndú gítí  á ji yì gí bìndi ndâ i mì yí. ");
INSERT INTO ndz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Káa ꞌdakò tí nò mâ giì ꞌdi có tí nò, yí giì zèè kò gba ta bà ꞌdeke tí wó, ji yí máa, ‹Je o ji ye, buù, wàa ye ꞌví pà kpokèjì bà sì có ndâ i mì lo ꞌdo muu ye ꞌdáá gî.› ");
INSERT INTO ndz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Gba mâ giì zeke ꞌdakò tí nò, yê ṛo wó giì bàkà yí ngé ndii gî. Bìndi  yí giì si có gítí ndâ i mì wó á muu wó nó ꞌdáá gî mí to. Bìndi  yí giì ꞌdè có ji yí máa, yí ya gí ꞌbá mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«ꞌDakò tí nò mâ giì co gí sè ꞌdo gbí ngbàngà mì gba, yí giì ꞌde ꞌbí ka wó náa ndú kû bàkà nèté ta ndú ꞌbá mì gba, ta làmbu i mì wó á muu wó, bìndi  yí giì nanaka mítí ka wó nò go cá tí ngbù tìítìí, máa, ‹I mì ye kuu muu lo. Je i mì ye ji ye! Je i mì ye ji ye!› ");
INSERT INTO ndz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«Ka wó mbe nèté nò giì ꞌva tí wó kùṛo wó, ta bà ꞌdeke tí wó ji yí, máa, ‹Je o ji ye, wàa ye ꞌví ì ngèlè gítí .› ");
INSERT INTO ndz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Káa yí giì biya bà ꞌdi có mì ka wó nò gî. Bìndi  yí giì te yí mí gbí zàà, máa yí dù á kà di tí o tí nó náa yí má sì có ndâ i mì yì cee ꞌdo muu wó gî, à ꞌví giì dò ꞌbì á ꞌdo tí wó. ");
INSERT INTO ndz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ndâ ꞌbí ka ndú náa ndú kû bàkà nèté ꞌbá mì gba ta ndú nó mâ giì ŋò ŋa i tí nò, tàkòcò ndú giì kpolo ngé ndii gî. Bìndi  ndú giì ya gí bà ꞌvanda ndi ŋa i tí nò náa ka ndú bàkà nò ꞌdáá gî ji gba. ");
INSERT INTO ndz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Gba bà-i-nò giì tuu ꞌduù gí tàkò ꞌdakò tí nò. À mâ giì gì ta yí gí kùṛo wó gî, yí giì do mítí wó, máa, ‹Ndí lo vò ꞌduù! Wò kùtàá ꞌdeke tí lo á ji ye, bìndi  ye giì si có gítí ndâ kpo-kpò i mì ye náa àá muu lo nó mí to gî. ");
INSERT INTO ndz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Káa wò kpónó ŋò yê ṛo ka lo náa yo kû bàkà nèté ta yí bà gbèe to nó lá, tacó yè?› ");
INSERT INTO ndz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tacó énò, gba giì te vò ꞌduù tí nò mí gbí zàà ta kpo tàkòcò. Máa, yí dù gbí zàà yee tí o tí nó náa yí má sì có ndâ i mì yì ꞌdáá gî delè.» ");
INSERT INTO ndz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jézù giì yee nje có mì wó, máa, «Bu ye á gbíṛì delè bà bàkà ta yo ꞌdáá gî ká énò, náa yo má je à-cee-gî ji ndâ náꞌvindí yo ta njembí yo gbaànjé lá nò.» ");
INSERT INTO ndz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jézù mâ giì cee ta bà ꞌdè có tí nò ji ndâ mbe tala có mì wó gî, ndú giì di ngo ꞌdo Gàlìléyà gítí ꞌbí to á tìto Jòròdánìyà á Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ndâ ꞌduù me mbè giì ṛu ndi wó gítí to tí nò. Bìndi  yí giì ꞌvala ndâ mbe nòꞌo gbí òkò tí ndú. ");
INSERT INTO ndz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mâ giì zekeꞌo, ndâ ꞌbí mbe kû kpolo tí tàkìì mì ndâ Jùdéyà giì gì gí mì Jézù, bìndi  ndú giì ꞌvee yí ta tiṛì tacó bà ŋò muu wó, máa, «ꞌDuù má njè niì mì wó ta ndeṛè  náa à ká gbí muu wó, a vò i gbí tàkìì mì ndoo tí ndâ Jùdéyà?» ");
INSERT INTO ndz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Yo ꞌdeke có tí nó náa à cu mí gbí wáràgà mì Mbíṛì, máa, do tí bà ꞌbìtà bà suu to tí nó, ꞌDuù tí nó mbe suu ndú nó, ‹suu ndú tí ndâ dì  ta na › nó lá? ");
INSERT INTO ndz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ŋìnò a gbí ndeṛè có tí nó náa yí tí Mbíṛì giì ꞌdè ta có, máa, ꞌdakò ꞌví si ndâ nawu wó, ta bu wó mí to, wàa yí ꞌví nanaka mítí nawù wó, wàa ndú ꞌví dù tí gbèe dìì nó ká nò. ");
INSERT INTO ndz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Má énò, ndú kákáꞌi me ndâ ꞌduù sósòꞌô lá. Ndú a gbèe dìì. Má énò, ꞌbí ꞌduù muu to tí nó ꞌví njèè gbí òkò tí ndâ i ŋìnó náa Mbíṛì ká toko ndú nó lá.» ");
INSERT INTO ndz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Káa ndâ mbe kû kpolo tí tàkìì mì ndâ Jùdéyà nò giì ꞌvee Jézù kákáꞌi máa, «Káa Mòze táánò ꞌdè có énò máa, ꞌduù ꞌví cu wáràgà ta ndeṛè bà njè tí ji nawù wó, wàa yí ꞌví njè yí, tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jézù bà-i-nò giì ꞌvìsì có ji ndú, máa, «Mòze táánò ꞌdè ji yo énò tacó tù yo tí ndâ Jùdéyà ꞌdi có lá. Káa àá táánò me go énò ta o bà ꞌbìtà bà suu ndâ ꞌdakò ta niì mì Mbíṛì lá. ");
INSERT INTO ndz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ye kû ꞌdè có ji yo ta yúcó, máa, ꞌbí ꞌduù má njè nawù wó á muu ꞌbí tende vò i á bìndi có ngbà-ꞌdakò, bìndi  yí giì kò ꞌbí ngú niì, yí kû zi a ngbà ta ngú niì tí nò.» ");
INSERT INTO ndz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bìndi  ndâ mbe tala có mì Jézù giì ꞌdè có ji yí, máa, «Cè có gítí ndâ niì ta ndâ kù ndú má énò, à nìkì káa bà dù ꞌduù tí dì banga.» ");
INSERT INTO ndz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Káa Jézù giì ꞌvìsì có ji ndú máa, «À káa ndâ ꞌduù ŋìnó náa Mbíṛì wu ji ndú máa ndú dù tí ndâ dì banga nó ká bà dù énò. À me káa ndâ ꞌduù sàkàmàà lá. ");
INSERT INTO ndz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tacó ndâ ŋa ndâ i mbe kû tii ndâ ꞌduù ꞌdo tí bà kò niì me a mbè: à volo ndâ ꞌbí ꞌduù ꞌdo ká gbí yì ndâ nawu ndú; à bàkà ndâ ꞌbí ꞌduù gítí bà dù énò ta wotí; ndâ ꞌbí ꞌduù biya bà kò niì tacó bà dù tí ndâ mbe bàkà nèté mì Mbíṛì. Wotí bà ꞌdi có tí nò má kuu tí ꞌduù, yí ꞌví ꞌdi .» ");
INSERT INTO ndz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ndâ ꞌbí ꞌduù giì gì ta ndâ víí ꞌviì mì ndú ji Jézù, máa yí cù ꞌdê ngo cù wó mítí ndú, wàa yí ꞌví ꞌdeke tí wó ji Mbíṛì tacó tí ndú. Káa ndâ mbe tala có mì Jézù giì do ta ndâ ꞌduù tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Káa Jézù giì ꞌdè có ji ndâ mbe tala có mì wó, máa, «Yo si ndâ ꞌviì tí nò ꞌví giì gí mì ye. Yo tii kpokèjì ꞌdo tí ndú lá, tacó ndâ mbe kû dù tí ndâ bòò-gba mì Gba-gbíṛì a ŋa ndâ ꞌduù ŋìnó go ndâ ꞌviì tí nò, nô.» ");
INSERT INTO ndz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","À mâ giì yee ta ndâ ꞌviì tí nò tí Jézù gî, yí giì cù ꞌdê ngo cù wó mítí ndú, bìndi  yí giì njè nó ꞌdo bàndò tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mâ giì zekeꞌo, ꞌbí ꞌviì-ꞌdakò ta ndâ i mì wó me gbolò giì gì gí mì Jézù, bìndi  yí giì ꞌvee yí, máa, «ꞌDuù ꞌví bàkà a ŋa tó i yè, tacó wàa yí ꞌví ꞌde ta ꞌválá ŋìnó mbe cee lá nó?» ");
INSERT INTO ndz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Káa Jézù giì ꞌvìsì có ji yí, máa, «Wò ꞌvee ye á gítí tó i tacó yè? Tó ꞌduù ká gbaànjé cuki. Go bà ꞌde ꞌválá ŋìnó mbe cee lá nó má kuu tí lo, kpolo tí ndâ có tí nô.» ");
INSERT INTO ndz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Káa ꞌviì-ꞌdakò tí nò giì ꞌvee Jézù kákáꞌi, máa, «Ndâ có ngàyi?» Káa Jézù bà-i-nò giì ꞌvìsì có ji yí, máa, «Ndâ có tí nó máa, ‹Wò ꞌví zi ꞌduù lá. Wò ꞌví bàkà bangbaya lá. Wò ꞌví zingbà i lá. Wò ꞌví ꞌdè ꞌvéṛè gítí ꞌduù lá. ");
INSERT INTO ndz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wò ꞌví tègàṛà ndâ bu lo ta nawu lo. Wò ꞌví zè ndâ ꞌbí ka lo nìkì go bà zè ꞌdóó tí lo nìkì mì lo,› nô.» ");
INSERT INTO ndz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Káa ꞌviì-ꞌdakò tí nò giì ꞌvee Jézù máa, «Ye kpolo tí ndâ có tí nò náa wò kpónó ꞌdeke mí to nò ꞌdáá gî; ꞌbí i ŋìnó kpòò mbe gboo ꞌdo mì ye gî nó a yè?» ");
INSERT INTO ndz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Káa Jézù giì ꞌvìsì có ji yí, máa, «Go bà dù tí cèe ꞌduù ta bà lê tí wó wálá má kuu tí lo, ya gí ꞌbá wàa wò ꞌví sì ndâ i mì lo ꞌdáá gî gí ꞌdè, wò ꞌví njèè ndâ i tí nó náa wò ꞌde gbí ndú nó ji ndâ mbe yê, bìndi  wò ꞌví gì gí bà ṛu ndi ye. Cì gúku lá, tacó wò bà ꞌde ndâ i me gbolò gí bìndi ndâ i mì lo nò ꞌdo gbíṛì gî.» ");
INSERT INTO ndz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ꞌViì-ꞌdakò tí nò mâ giì ꞌdi có tí nò náa Jézù ꞌdè ji yí nò, yí giì njè nó ꞌdo bà-i-nò ta máákà gbí dìì wó, tacó ndâ i mì wó me gbolò ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ꞌViì-ꞌdakò tí nò mâ giì ya gî. Jézù giì ꞌdè có ji ndâ mbe tala có mì wó, máa, «Ye kû ꞌdè có ji yo ta yúcó, máa, bà dù tí bòò-gba mì Mbíṛì mì ndâ mbe kpo-kpò i muu to tí nó kpolo ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ye bà ꞌdè gbí ndi có tí nò ji yo kákáꞌi, máa, à peteke a bà ndii ꞌbí ŋa gbolò nò go ya co gbí gùù ngbàndú á co tí bà dù ꞌduù ŋìnó ta ndâ kpo-kpò i ká mì wó nó tí bòò-gba mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nje ndâ mbe tala có mì Jézù giì ꞌdèè ta bà ꞌdi có tí nò gî. Bìndi  ndú giì ꞌvee yí, máa, «À má énò, a ꞌdi ká bà ꞌde ꞌválá?» ");
INSERT INTO ndz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Káa Jézù giì ꞌvìsì có ji ndú ta bà zekeꞌo tí ndú, máa, «Wotí mì ndâ ꞌduù gítí  wálá, káa ꞌbí i mbe kpò Mbíṛì wálá.» ");
INSERT INTO ndz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bìndi  Pìyétòrò giì ꞌvee Jézù, máa, «Káa ze, ŋò káa ze jee ndâ i muu to tí nó ꞌdáá gî mí to kû ṛu ndi lo. Ze bà ꞌde bìndi ndâ i mì ze náa ze jee ndú mí to nò a yè?» ");
INSERT INTO ndz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Káa Jézù giì ꞌvìsì có ji Pìyétòrò máa, «Ye kû ꞌdè có ji wò ta yúcó máa, ta o tí nó náa ndâ i má giì gì ꞌdáá tí ndâ ngú i gî, ꞌViì-mì-ꞌDakò bà giì ki tí wó dèngècè pí jàlàmbà mì wó, bìndi  yo tí ndâ ꞌduù tí nò muuꞌbì-nje só mbe kû ṛu ndi ye nó bà giì ki tí yo dengece-dèngècè to kû zogo ndâ ŋa ndâ Ìzìrìyélì muuꞌbì-nje só nô. ");
INSERT INTO ndz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bìndi  ndâ ꞌduù ŋìnó ꞌdáá mbe jee ndâ ꞌbá mì ndú, ta ndâ náꞌvindí ndú, ta ndâ námì ndú, ta ndâ bu ndú, ta ndâ nawu ndú, ta ndâ ꞌviì mì ndú mí to ta ṛè ye nó, bà ꞌde ndâ i me gbolò á gí bìndi ndâ i mì ndú ta ndâ ꞌduù mì ndú nò. Mbíṛì delè bà je ꞌválá ŋìnó mbe cee lá nó ji ndú á bìndi ku mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","«Káa yo ꞌví koṛo muu yo máa, ndâ ꞌduù ŋìnó kpónó tí ndâ kpo-kpò ꞌduù kùṛo ndâ ꞌbí ka ndú nó bà giì dù tí ndâ ndòngbú ꞌduù, bìndi  ndâ ꞌduù ŋìnó kpónó tí ndâ sílì ndâ ka ndú nó bà giì dù tí ndâ kùṛo ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jézù giì lòkòꞌbò có ji ndâ mbe tala có mì wó, máa, «Ŋa kpokèjì bà zogo to tí nó mì Gba-gbíṛì go i mì ꞌbí gbolò ꞌduù mbe gboꞌo ya gí bà pà ndâ ꞌduù tacó bà bàkà nèté gbí njí mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yí mâ giì ꞌde ndâ kpédélé ꞌduù gî, ndú giì ꞌvii có ta ndú gítí bà ko mboo nèté mì ndú, bìndi  yí giì tuu ndú gí gbí njí ta fírí dúꞌo. ");
INSERT INTO ndz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yí mâ giì ya gí bàndò ꞌvélè si ṛi yèè gàà gí yaà gî, yí giì ꞌde ndâ ꞌbí ꞌduù ta nèté mì ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Bìndi  yí giì kaa ndú ya tí  gí gbí njí mì wó, máa, ndú bàkà nèté, wàa yì bà je i ŋìnó mbe ꞌvii ta po nèté mì ndú ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yí mâ giì dele ndi wó ya gí bàndò ꞌvélè ta ṛi dê gítí gbúrú, yí giì ꞌde ndâ ꞌbí ꞌduù, bìndi  yí giì kaa ndú ya tí  gí gbí njí, máa, ndú bàkà nèté, wàa yì ꞌví je bà ꞌbì ndú ji ndú. Yí mâ giì ya ndi wó gí bàndò ꞌvélè si ṛi mò tí gî, yí giì ꞌde ndâ ꞌbí ꞌduù kû dù sínò, bìndi  yí giì kaa ndú ya tí  gí gbí njí, máa, ‹Yo bàkà nèté! Yo bà ꞌde káa bà ꞌbì yo.› ");
INSERT INTO ndz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yí mâ dele ndi wó gí bàndò ꞌvélè si o ꞌdèè gî, yí giì ꞌde ndâ ꞌbí ꞌduù ta nèté mì ndú wálá. Bìndi  yí giì ꞌvee ndú, máa, ‹Yo kû dù sínò bà-i-nó ꞌdo tí dúꞌo yee tí kpónó tacó yè?› ");
INSERT INTO ndz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«Káa ndâ ꞌduù tí nò giì ꞌvìsì có ji yí, máa, ‹Tacó mbe je nèté ji ze wálá.› Bìndi  yí giì ꞌvìsì có ji ndú, máa, ‹À má énò, yo ya gí gbí njí mì ye.› ");
INSERT INTO ndz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«O bà njè nèté mâ giì me tí gî, yí giì tuu mbe kû kpolo tí ndâ i gbí gálá mì wó, máa yí ya gí bà njè ndâ ꞌduù ꞌdo gbí nèté gî. Ndâ ꞌduù mâ giì gì ꞌdo gbí njí gí ꞌbá gî, yí giì ꞌdè có ji mbe kpolo tí ndâ i gbí gálá mì wó, máa, yí ko mboo nèté mì ndú ji ndú. Máa, yí ꞌbìtà bà je i kpédéléꞌi a i ji ndâ ndòngbú ꞌduù tí nó mbe gì gí gbí nèté ta ꞌdêꞌo nô, bìndi  ndâ mbe gì si ṛi mò tí gî, bìndi  ndâ mbe gì ta ṛi gbúrú, bìndi  ndâ mbe gì ta ṛi dúꞌo, bìndi  ndâ mbe gì ta fírí dúꞌo, wàa yí ꞌví je i ji ndú ꞌdáá gî ꞌvii ká ꞌvii. ꞌBí có máa, ꞌduù ŋìnó gì gí gbí nèté ta fírí dúꞌo, káa ŋìzó gì si nèté kû njé-njè nò, ꞌví dù lá. ");
INSERT INTO ndz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mbe kpolo tí ndâ i gbí gálá bà-i-nò giì ꞌbìtà bà ko mboo nèté mì ndâ ꞌduù ji ndú go có tí nó náa mbe njí ꞌdè ji yí nò. ");
INSERT INTO ndz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ndâ kpédélé ꞌduù tí nó náa mbe njí kaa ndú gí gbí nèté ta fírí dúꞌo nó giì gì ŋìndi ndú ta bà koṛo có énó máa, a ndâ yì ká bà ꞌde i me gbolò, káa ndú giì ꞌde káa gbèe ŋa i tí nó náa ndâ ꞌbí ka ndú ꞌde nô. ");
INSERT INTO ndz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","«Ndú bà-i-nò giì lì káa ꞌbì ndú gí ta i tí nó náa à je ji ndú nó gî, bìndi  ndú giì ya gí bà ꞌdè kòlòwò ji mbe njí, máa, ");
INSERT INTO ndz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Ndâ ndòngbú ꞌduù tí nó náa wò kaa ndú gì tí  kpónó-kpónó ta ꞌdêꞌo nó bàkà nèté ká ta làmbu o, káa wò giì ꞌvii ndú ta ze tí ndâ mbe ꞌbìtà bà ka wuꞌo si ṛi có lá yee tí ꞌdêꞌo ta ŋa kpokèjì ngàyi!› ");
INSERT INTO ndz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Káa mbe njí giì ꞌvìsì có ji ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ꞌduù tí nò mbe kû ꞌdè kòlòwò nò, máa, ‹Ye ŋonoko wò gbaànjé lá, kómbe ye. À kpónó ꞌbì lo nò me i tí nó kùtàá náa ndà ꞌvii có gítí  ta dúꞌo nó lá? ");
INSERT INTO ndz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Má énò, je i mì lo, wàa wò ꞌví ya . Ye je i ji ndâ ndòngbú ꞌduù tí nó mbe gì gí gbí nèté kpónó-kpónó si o bèè ꞌdáá gî nó ꞌvii ta yo ꞌdo ká gbí ꞌdóó có mì ye gbí muu ye. ");
INSERT INTO ndz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ṛè i ŋìnó mbe tii ye ꞌdo tí bà bàkà ta ndâ ꞌdóó i mì ye go có mì ye gbí muu ye ꞌví dù a ŋa yè? Wò kû tò a kiì tacó ŋa gbolò nambeè tí nó náa ye bàkà ji ndâ ꞌduù tí nó mbe gì gí gbí nèté kpónó-kpónó á kùṛo bà njè nèté nó?› » ");
INSERT INTO ndz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jézù giì yee nje có mì wó, máa, «Ndâ ndòngbú ꞌduù wúnò bà dù tí ndâ kpédélé ꞌduù, bìndi  ndâ kpédélé ꞌduù bà dù tí ndâ ndòngbú ꞌduù go ŋa i tí nó kpónó nô.» ");
INSERT INTO ndz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jézù mâ giì cee ta bà ꞌdè có gítí ndâ mbe kpo-kpò i gî, ndú giì kaa kû ya gí gbí gbata Jèrùzàlémè. Káa si ndú kpokèjì, yí giì kaa ndâ mbe tala có mì wó muuꞌbì-nje só ꞌdo gbí òkò tí ndâ ꞌduù gí ndiì, bìndi  yí giì ꞌdè có ji ndú, máa, ");
INSERT INTO ndz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ndoo kpónó kû ya gí gbí gbata Jèrùzàlémè, bìndi  ndâ ꞌduù kà bà giì kpì ngbàngà tí ꞌViì-mì-ꞌDakò ji ndâ kpo-kpò ꞌduù gbí ngbàngà mì ndâ Jùdéyà. Ndú bà giì waa có ku mítí wó, ");
INSERT INTO ndz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","bìndi  ndú bà giì je yí ji ndâ mbe ꞌdó-ꞌdo tacó bà zi yí. Ndâ mbe ꞌdó-ꞌdo tí nò bà giì ŋo ndi wó, ta bà ŋo yí, ta bà lè yí, ta bà gbì yí, bìndi  ndú bà giì zi yí ta bà gbì yí á mítí njèèkpè mû. Káa bìndi sili taꞌô yí bà giì ꞌvala ndi wó á ꞌdo gbí muuꞌdú wó gî.» ");
INSERT INTO ndz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nawu ndâ Jákòmò ta Jòvánì tí ndâ ꞌviì mì Zèbìdéyò giì kaa ndú ya tí  ji Jézù kùṛo bà yee ndú Jèrùzàlémè. Bìndi  yí giì zèè kò Jézù ta bà ꞌdeke tí wó. ");
INSERT INTO ndz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Káa Jézù giì ꞌdè có ji niì tí nò máa, «Nì ꞌdóó ṛè ŋa i tí nó ta go  tí lo nó gi.» Káa yí giì ꞌvìsì có ji Jézù máa, «Có gbí njembí ye énó máa, wò ci ye énó máa, wò má gì tí gbolò gba gî, wò bà bàkà ndâ ꞌviì mì ye sósòꞌô nó tí ndâ kpo-kpò ꞌduù gbí ngbàngà mì lo. ꞌBí ꞌduù gbaànjé gbí òkò tí ndú ꞌví dù tí mbe ki tí gbí kùꞌbì mì lo, wàa ꞌbí ꞌduù ꞌví dù tí mbe ki tí gbí gàlì mì lo.» ");
INSERT INTO ndz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Káa Jézù giì ꞌvìsì có ji ndâ niì tí nò ta ndâ ꞌviì mì wó, máa, «Yo ŋò ŋa i tí nó náa yo kû yù nó ni lá. Wotí bà njù ꞌvisî tí nó náa ye kèjì gí bà njù  nó kuu tí yo?» Káa ndú giì ꞌvìsì có ji yí, máa, «À kuu tí ze.» ");
INSERT INTO ndz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Yo bà njù ꞌvisî mì ye nò gî. Káa à má gítí có ndâ bàndò bà ki tí ṛègbà tí ye gbí ngbàngà mì ye, ndú me ndâ i mì ye tacó bà njèè ji ndâ ꞌduù lá. Ndâ bàndò tí nò a ndâ i mì ndâ mbe  náa Bu ye ꞌviindi tacó tí ndú sàà gî.» ");
INSERT INTO ndz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sè ndâ mbe tala có mì Jézù muuꞌbì nó mâ giì ꞌdi có tí nò náa ndâ Jákòmò ta náꞌvindí wó Jòvánì ꞌdè nò, tàkòcò ndú giì kpolo gítí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jézù mâ giì ŋò énò, yí giì kili ndâ mbe tala có mì wó muuꞌbì-nje só ꞌdáá gî, bìndi  yí giì ꞌdè có ji ndú, máa, «Yo ŋò ni gî máa, ndâ gba mì ndâ ꞌduù ŋìnó mbe ŋò dúú kpokèjì bà bàkà nambeè ta Mbíṛì ni lá nó kû toṛo nje ndâ bòò mì ndú ta to. Ndâ kpo-kpò ꞌduù kùṛo ndú delè kû bàkà ndú ká tí cèe ndâ bè bòò mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Káa àá bà dù gbí òkò tí yo me go énò lá. Tacó ꞌduù ŋìnó tí gbolò ꞌduù gbí òkò tí yo nó bà dù tí bòò mì ndâ ka wó. ");
INSERT INTO ndz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bìndi  ꞌduù ŋìnó tí kùṛo ndâ ka wó gbí òkò tí yo nó bà dù tí bòò mì yo. ");
INSERT INTO ndz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tacó à kpêtí káa ꞌViì-mì-ꞌDakò, yí gì gí muu to tí nó me tacó máa ndâ ꞌduù ꞌví bàkà nèté wó nò lá, yí gì a i tacó bà bàkà nèté ndâ ꞌduù, delè tacó bà sì miṛi wó ji ku á muu ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Si ndâ Jézù ta ndâ mbe tala có mì wó kû giì njè nó ꞌdo gbí gbata Jérìkò kû ya gí Jèrùzàlémè, ndâ ꞌduù me mbè ká ko ndú. ");
INSERT INTO ndz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ndâ ꞌbí ꞌdakò sósòꞌô tí ndâ mbe súṛo mbe kû ki tí ndú seè kpokèjì, máa giì ꞌdi có máa ŋìnó a Jézù ká kû ndii ta nó nò, ndú giì ꞌbìtà bà tò kû, máa, «ꞌViì mì Dàvídè! Ŋò yê ṛo ze!» ");
INSERT INTO ndz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ndâ mbè ꞌduù tí nó mbe kû ko tàkò Jézù nó giì do mítí ndâ mbe sú ṛo tí nò, máa ndú dù ngbìì. Káa ndâ mbe sú ṛo tí nò giì tò kû ngéé gí yaà ndii ŋìnó kùṛo nó gî, máa, «ꞌViì mì Dàvídè! Ŋò yê ṛo ze!» ");
INSERT INTO ndz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jézù giì ṛò tíyò, yí giì tèꞌé tí ndú, bìndi  yí giì ꞌvee ndú máa, «À tí yo a go ŋa yè, máa ye ꞌví bàkà ji yo?» ");
INSERT INTO ndz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Káa ndú giì ꞌvìsì có ji Jézù máa, «Si ze ꞌví zekeꞌo, Buù!» ");
INSERT INTO ndz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jézù giì ŋò yê ṛo ndú, bìndi  yí giì tee ꞌbì wó ta ndi tí ndâ ṛo ndú, bìndi  ndú ngé giì ꞌbìtà bà ŋò ndâ i, bìndi  ndú giì ṛu ndi Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ndâ Jézù mâ giì dooko ta gbata Jèrùzàlémè gî, si ndú pí Gú Mbâ, Jézù giì tuu ndâ ꞌbí mbe tala có mì wó sósòꞌô, ");
INSERT INTO ndz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","máa, «Yo ya gítí ndâ ꞌbá tí zó náa yo kû ŋò muu ndú ngéé kùṛo yo zô. À káa póó bà yee yo kà, yo bà ꞌde na kècè náa à eṛe yí gî, ta ꞌviì mì wó gbí wú ṛègbà tí wó. Yo ꞌví njaanga ndú ꞌdo gbí wú gî, bìndi  yo ꞌví gì ta ndú ji ye. ");
INSERT INTO ndz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ꞌBí ꞌduù má ꞌvee yo, yo ꞌví ꞌvìsì có ji yí, máa, ‹A Mbe tí ze ká tuu ze, máa ze ya ta ndú ji yì. Nèté mì wó má cee ta ndú gî, yí bà tuu ndú ngé gí bàndò mì ndú.› » ");
INSERT INTO ndz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","I tí nò bàkà tí go có tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì táánò ꞌdè énó máa, ");
INSERT INTO ndz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«ꞌDè có ji ndâ ꞌduù Jèrùzàlémè, máa, ‹Yo ŋò gbolò gba mì yo á kèjì tí ꞌdê ꞌduù pí kècè tí ngbú kècè,› nô.» ");
INSERT INTO ndz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ndâ mbe tala có mì Jézù sósòꞌô náa yí tuu ndú nó giì njè nó ya gí bà bàkà go có tí nò náa Jézù ꞌdè ji ndú nò. ");
INSERT INTO ndz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ndú bà-i-nò giì gbà ndâ ngbú ꞌviì-kècè tí nò ta nawu wó ya tí  ji Jézù. Ndú mâ giì yee ta ndú tí Jézù gî, ndú giì ki ndâ bòngo mí pí tí ngbú ꞌviì-kècè tí nò, bìndi  Jézù giì o yí, ya tí  gí gbí gbata Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ndâ ꞌduù me mbè gbí òkò tí ndâ ꞌduù tí nó mbe tì mí mì Jézù nó giì gò ndâ bòngo mì ndú mí to ta tí kpokèjì, ndâ ꞌbí  giì kiꞌviki ndâ kpâ gò mítí kpokèjì, tacó wàa Jézù ꞌví nò gbí , tacó bà te ꞌduù mítí bà ṛì yí gí gbí gbata Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bìndi  ndâ mbè ꞌduù giì ꞌbìtà bà ko Jézù ya tí  gí gbí gbata. Ndâ ꞌbí ꞌduù tè kùṛo wó, bìndi  ndâ ꞌbí ꞌduù tàkò wó ndiì, kû tò kû ta líkíꞌo, máa, «ꞌVala ze kpónó, ꞌViì mì Dàvídè! À ùlù yí tí mbe gì ta ṛè mì Mbíṛì! Àá Mbíṛì, ꞌvala ze kpónó!» ");
INSERT INTO ndz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Gbata Jèrùzàlémè giì ngaka a cèe tí ta o bà yee Jézù. Ndâ ꞌduù ta o tí nò kû giì ꞌvee a ꞌvé, máa, «Ŋìnó a ꞌdi? Ŋìnó a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Káa ndâ mbè ndâ ꞌduù tí nó mbe kû ko tàkò Jézù nó giì ꞌvìsì có ji ndâ mbe kû ꞌvee ꞌvé tí nó, máa, «A Jézù tí nó tí mbe ꞌdòkò có mì Mbíṛì mbe gì ꞌdo gbí gbata Názàrètì á gbí to Gàlìléyà nô.» ");
INSERT INTO ndz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jézù mâ giì yee gbí gbata Jèrùzàlémè gî, yí giì ṛì gí gbí ndùgù ꞌbá-Mbíṛì. Bìndi  yí giì mòkò ndâ mbe bàkà gbí ndùgù ꞌbá-Mbíṛì tí ꞌbá ꞌvélè nó ꞌdáá gî gí sè. Bìndi  yí giì ꞌbuku ndâ tàràbézà mì ndâ mbe kû ꞌvìsì gùrúsù, ta ndâ mbata mì ndâ mbe kû mà ndâ kùlè nó mí to. ");
INSERT INTO ndz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bìndi  yí giì ꞌdè có ji ndâ ꞌduù tí nò ta kpo tàkòcò, máa, «À cu mí gbí wáràgà mì Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì, máa: Mbíṛì máa, ‹ꞌBá mì ye a bàndò bà ꞌdeke tí ndâ ꞌduù ji ye.› Káa yo kpónó bàngû nó giì ꞌvìsì tí bàndò mì ndâ mbe kùmùkù ndâ i mì ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jézù mâ giì cee ta ndâ mbe bàkà gbí ndùgù ꞌbá-Mbíṛì tí ꞌbá ꞌvélè nó gî, ndâ mbe sú ṛo ta ndâ mbe ku kò giì kaa ya gí mì wó gbí ndùgù ꞌbá-Mbíṛì kà, bìndi  yí giì ꞌvala ndú. ");
INSERT INTO ndz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ndâ kpo-kpò bu-Mbíṛì ta ndâ mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà bà-i-nò mâ giì ŋò ŋa ndâ i-seṛè tí nò náa Jézù kû bàkà nó, ndú delè mâ giì ꞌdi ndâ kú tí nó náa ndâ víí ꞌviì kû tò ta gbí ndùgù ꞌbá-Mbíṛì, máa, «ꞌVala ze, ꞌViì mì Dàvídè! ꞌVala ze, ꞌViì mì Dàvídè!» nó, ndú giì ꞌde ndeṛè bà òkòlòwò gítí Jézù gî. ");
INSERT INTO ndz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ndú bà-i-nò giì ꞌvee Jézù máa, «Wò ꞌdi có tí nò náa ndâ ꞌviì tí nò kû tò ta kû nò gî?» Jézù bà-i-nò giì ꞌvìsì có ji ndú máa, «Ye ꞌdi gî. Káa yo jé ꞌdeke có tí nó gbí wáràgà mì Mbíṛì máa, ‹A wò tí Mbíṛì ká nìbà cèe kpokèjì bà ùlù wò ji ndâ víí ꞌviì, ta ndâ dó ꞌviì,› nó lá?» ");
INSERT INTO ndz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jézù giì njè nó ꞌdo Jèrùzàlémè bìndi ndâ có tí nò ya gí bà tè ṛì gbí gbata Bètánìyà. ");
INSERT INTO ndz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ta dúꞌo si Jézù kû dele ta go tí wó ꞌdo Bètánìyà gí Jèrùzàlémè, ");
INSERT INTO ndz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","yí giì ŋò ꞌbí mû-mbiìgá á seè kpokèjì. Yí giì ne tacó bà pà yú  wàa yì ꞌví zò gítí go tí nò tí yì nò. Káa yí giì ꞌde káa bè kpâ. Gbèe ṛi mbiìgá gbí mû wálá. Bìndi  yí giì ì njà mítí mû tí nò máa, «Wò ꞌví ṛì kákáꞌi lá.» Ndâ kpâ-mbiìgá tí nò ngé giì me ṛemo-ṛémòò, goòlá a wu ka co tí ndú nô. ");
INSERT INTO ndz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ndâ mbe tala có mì Jézù mâ giì ŋò bà lemere bè mbiìgá tí nò ta ku gálà énò, nje ndú giì ꞌdèè gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé máa, «A ŋa yè ká zi mû-mbiìgá tí nó gálà go có ꞌdì nó?» ");
INSERT INTO ndz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kû ꞌdè có ji yo ta yúcó máa, yo má ùnje gítí Mbíṛì ta njembí yo gbaànjé, yo bà bàkà cuki me káa ŋa i tí nó náa à bàkà mítí mû-mbiìgá tí nó, nó lá. Yo kpêtí má ꞌdè có ji ꞌbí gbolò gú, máa yí njè nó ꞌdo tí bàndò mì wó ya gí bà ꞌva tí tà kàpá, yí bà bàkà go có mì yo nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yo delè má ꞌdeke tí yo ji Mbíṛì tacó ꞌbí i ta njembí yo gbaànjé, Mbíṛì bà je i tí nò ji yo gî.» ");
INSERT INTO ndz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jézù mâ giì ṛì gí gbí ndùgù ꞌbá-Mbíṛì kû nìbà i ji ndâ ꞌduù gî, ndâ ꞌbí bu-Mbíṛì ta ndâ ꞌbí kpo-ꞌduù-ꞌbá mì ndâ Jùdéyà giì gì gí mì wó, bìndi  ndú giì ꞌvee yí máa, «A ꞌdi ká je wotí bà bàkà ndâ i tí nó náa wò kû bàkà nó ji wò?» ");
INSERT INTO ndz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kpónó delè kû giì ꞌvee yo ta ꞌvé gbaànjé, yo má ꞌvìsì có ji ye gí tàkò  gî, bìndi  ye ꞌví giì nì ṛè ꞌduù tí nó mbe je wotí bà bàkà ndâ i tí nó náa ye kû bàkà nó ji yo: ");
INSERT INTO ndz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A ꞌdi táánò ká je wotí bà caka tí ndâ ꞌduù ji Jòvánì? A Mbíṛì wèè, a ꞌbí ꞌduù wèè? Yí ꞌde wotí tí nò ꞌdo kòtí ꞌdi? Nògí, yo nì ṛè ꞌduù tí nò ji ye.» Káa ndú giì ꞌbìtà bà ꞌviiki gbí ꞌvé mì Jézù nò gbí òkò tí ndú ta kpéétí ndú máa, «Ndoo kpónó má ꞌvìsì có ji yí máa, Jòvánì ꞌde wotí tí nò táánò ꞌdo mì Mbíṛì, yí bà giì ꞌvee ndoo máa, ‹Káa yo ùnje gítí ndâ i tí nó náa yí kû bàkà nó lá, tacó yè?› ");
INSERT INTO ndz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Káa bà ꞌdè énó máa, Jòvánì táánò ꞌde wotí tí nò ꞌdo mì ndâ ꞌduù, delè káa bà le wú mítí miṛi ndoo, tacó ndâ ꞌduù ùnje gî máa, Jòvánì táánò a mbe ꞌdòkò có mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tacó énò, ndú giì ꞌvìsì có ji Jézù máa, «Ze ŋò bà  lá.» Káa Jézù giì ꞌdè có ji ndú máa, «À má énò, ye delè bà nì ṛè ꞌduù tí nó mbe je wotí bà bàkà ndâ i tí nò ji ye nó ji yo wálá. ");
INSERT INTO ndz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Yo kû koṛo có máa yè? ꞌBí ꞌdakò ta ndâ ꞌviì mì wó sósòꞌô táánò giì ya gí mì kpo ꞌviì mì wó, yí giì ꞌdè có ji yí énó máa, ‹ꞌViì, ya gí bà bàkà nèté gbí njí wúnó.› ");
INSERT INTO ndz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Káa ꞌviì tí nò giì ꞌvìsì có ji bu wó máa, ‹Ye tí nó wálá.› Káa ꞌviì tí nò mâ giì koṛo muu wó, yí giì ꞌvìsì muu wó gî, bìndi  yí giì ya gí gbí njí go có mì bu wó nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ꞌDakò tí nò giì ya gí mì làmbu ꞌviì mì wó, gí bà ꞌdè có ji yí máa, yí ya gí gbí njí. Káa ꞌviì tí nò giì eendi bu wó máa, ‹Ye bà ya gî, buù,› káa yí giì ya lá. ");
INSERT INTO ndz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","A ꞌdi ꞌdo gbí òkò tí ndâ ꞌviì tí nò sósòꞌô nò ká bàkà go có mì bu wó?» Káa ndú giì ꞌvìsì có ji yí máa, «A kpédélé ꞌviì mì ꞌdakò tí nò ká bàkà go có mì bu wó.» Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kû ꞌdè có ji yo ta yúcó máa, ndâ mbe kû kili i-mírì, ta ndâ mbe nò vò ndoò, bà ya gí ꞌbá mì Mbíṛì si yo mí ndiì. ");
INSERT INTO ndz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ye ꞌdè có tí nò ji yo tacó Jòvánì tí mbe caka tí ndâ ꞌduù táánò gì gí mì yo muu to tí nó tí mbe nìbà tó kpokèjì ji ndâ ꞌduù, káa yo táánò ùnje gítí ndâ có mì wó lá. A ndâ mbe kili i-mírì ta ndâ mbe nò vò ndoò nó táánò ká ùnje gítí ndâ có mì wó. Yo táánò ŋò ndú tí  gî, káa yo biya bà ꞌvìsì muu yo ꞌdo tí ndâ vò kpokèjì mì yo gî. ");
INSERT INTO ndz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Yo sè tù yo gítí ꞌbí có tí nó náa ye kû giì lòkòꞌbò ji yo nô. Ta ꞌbí o gbaànjé ꞌbí ꞌdakò giì ṛò njí mû-nèbítì mì wó, bìndi  yí giì ṛò ndâ ꞌbí mû tí ndùgù gí tàkò , bìndi  yí giì duu gùù tí bàndò bà pee nèbítì mí gbí , bìndi  yí giì duu cèléngé tacó bà gbà i mí gbí njí tí nò. Bìndi  yí giì kaa ndâ ꞌduù mí gbí , máa, ndú má pee nèbítì gî, bà ŋìndi ndú ꞌví dù énô, wàa bà ŋìndi yì ꞌví dù énô. Ndú mâ giì ꞌvii có ta ꞌdakò tí nò náa yí kaa ndú mí gbí njí nò cee gî, yí giì ya gí bà nò ndoò gí gbí tende muu to. ");
INSERT INTO ndz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Yí mâ giì ŋò o bà yù nèbítì dooko gî, yí giì tuu ndâ bòò mì wó ji ndâ mbe kû bàkà nèté gbí njí mì wó máa, ndú je bà nèbítì ŋìndi yì ji ndú wàa ndú ꞌví gì tí  ji yì. ");
INSERT INTO ndz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","«Ndâ bòò mì mbe njí mâ giì yee ta ŋa có tí nò náa mbe tí ndú tuu ta ndú nò tí ndâ ꞌdakò tí nò mbe kû bàkà nèté gbí njí mì wó nò, ndâ ꞌdakò tí nò giì bàkà gbínje ta ndú, ta bà gbì ndú, ta bà ꞌvaka ndú ta díí. Bìndi  ndú giì zi ꞌbí  gbaànjé gî. ");
INSERT INTO ndz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Có ŋa vò i tí nò náa ndâ ꞌduù tí nò bàkà ta ndâ bòò mì mbe njí nò mâ giì yee gbí tù wó, yí giì tuu ndâ ꞌbí bòò mì wó kákáꞌi, gbí ŋìnò me mbè ndii ndâ kpédélé ŋìnó gî ji ndú. Káa ndâ ꞌdakò tí nò giì bàkà káa ndi ŋa ndâ vò i tí nó náa ndú bàkà ta ndâ kpédélé bòò mì mbe njí nó mítí ndâ ŋìnò. ");
INSERT INTO ndz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bà taꞌô ꞌduù náa mbe njí giì tuu ji ndú a ꞌdóó ꞌviì mì wó ta bà koṛo có máa, ‹Ndú bà te duù mítí ꞌdóó ꞌviì mì ye gî.› ");
INSERT INTO ndz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Káa ndâ mbe bàkà nèté gbí njí mâ giì ŋò ꞌviì mì mbe njí kèjì, ndú giì ꞌdè có gbí òkò tí ndú máa, ‹Ŋìzó a ꞌdóó mbe mbèlè tí nó ká kèjì zô. Ndoo zi yí gî, wàa ndoo ꞌví dù tí ndâ mbe mbèlè tí nó bìndi wó.› ");
INSERT INTO ndz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ꞌViì tí nò mâ giì yee mì ndú, ndú giì ja yí ꞌdo gbí njí gí nje o, bìndi  ndú giì zi yí gî. ");
INSERT INTO ndz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","À má énò, yo kpónó kû koṛo ta muu yo máa, mbe njí tí nò bà giì bàkà a ŋa yè ta ndâ mbe nèté tí nò?» ");
INSERT INTO ndz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Káa ndú giì ꞌvìsì có ji yí máa, «Yí bà ziki ndâ vo-vò mbe nèté tí nò ꞌdáá gî, ta kponje gítí  wálá. Bìndi  yí bà giì pà ndâ ꞌbí cèe ngú mbe nèté mbe kû je bà i ŋìndi wó ji yí ta o bà kili i ꞌdo gbí njí.» ");
INSERT INTO ndz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jézù bà-i-nò giì ꞌvee ndú, máa, «Yo jé ꞌdeke có tí nó náa à cu mí gbí wáràgà mì Mbíṛì nó lá? Có tí nò máa, ‹ꞌDóó díí tí nó táánò náa ndâ mbe bì ꞌbá bè gî nó ká giì gì tí cèe yú díí bà sè tà ꞌbá nô. A Mbíṛì táánò ká bàkà énò, Káa à nìkì gbí ṛo ndoo ngé ndii gî.› ");
INSERT INTO ndz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Má énò, ye kû ꞌdè có ji yo máa, ‹Àá bà mò yo ꞌdo ꞌbá mì Mbíṛì gî, wàa à ꞌví je ꞌbá tí nò ji ndâ ꞌbí ŋa tende ꞌduù mbe kû bàkà tó i.› ");
INSERT INTO ndz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ꞌDuù má ꞌva tí wó pí díí tí nò náa ndâ mbe bì ꞌbá táánò bè gî nò, ꞌduù tí nò bà kiꞌviki tí vò ŋa ŋìnô. Káa à má díí tí nò ká ꞌva tí pí tí ꞌduù, díí tí nò bà ꞌbaꞌdaka gbí ꞌduù tí nò gî.» ");
INSERT INTO ndz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ndâ kpo-kpò ꞌduù gbí ngbàngà mì ndâ Jùdéyà mâ giì ꞌdi có tí nò náa Jézù lòkòꞌbò nò, ndú giì ŋò ni gî máa, yí kû lòkòꞌbò có tí nò a i gítí ndâ yì. ");
INSERT INTO ndz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tacó énò, ndú giì jè ta bà pà kpokèjì bà zèè yí, káa gúku ndâ mbè ꞌduù tí nò mbe kili mí mì Jézù nò giì kpò ndú gî. Tacó ndâ ꞌduù tí nò ŋò ni gî máa, Jézù a mbe ꞌdòkò có mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jézù giì lòkòꞌbò có ji ndâ ꞌduù kákáꞌi máa, ");
INSERT INTO ndz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ye bà ꞌvii Gba-gbíṛì mítí ꞌbí gbolò gba mbe bàkà i-zó-zò me gbolò ta o bà ko niì mì ꞌviì mì wó gí ꞌbá. ");
INSERT INTO ndz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bìndi  yí giì tuu ndâ bòò mì wó gí tàkò ndâ ꞌduù tí nó náa yí ma có bà ko niì ji ndú nô. Káa gbèe ꞌduù gbí òkò tí ndú giì gì lá. ");
INSERT INTO ndz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bìndi  yí giì tuu ndâ ꞌbí bòò mì wó kákáꞌi máa, ‹Yo ya gí bà ꞌdè có ji ndâ ꞌduù tí nó náa ye ma có bà ko niì mì ꞌviì mì ye ji ndú nó máa, ye bàkà i-zó-zò cee gî. Nògí, ndú gì gí bà zò i.› ");
INSERT INTO ndz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ndâ bòò mì gba giì ya gí bà ꞌvanda ndi kòcò gba ji ndâ ꞌduù tí nò gbaànjé-gbaànjé ꞌdáá gî. Káa có tí nò giì dù gbí tù ndú ká go mòngò gbí tù bô. Bìndi  ndú giì ꞌvaaka ya ta ndi gbí ndâ ꞌdóó nèté mì ndú gbí muu ndú. Ndâ ꞌbí ꞌduù ya gí gbí njí mì ndú, ndâ ꞌbí ꞌduù ꞌvaaka ya gí bà mà ꞌvélè, ");
INSERT INTO ndz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ndâ ꞌbí ꞌduù ŋìndi ndú giì zèè ndâ ꞌbí bòò mì gba náa yí tuu ndú nó, bìndi  ndú giì bàkà ndâ i-nô mítí ndú, ndâ ꞌbí ꞌduù giì ziki ndâ ꞌbí bòò mì gba náa yí tuu ndú nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Có ŋa ndâ i tí nò náa ndâ ꞌduù tí nò bàkà nò mâ giì yee tí gba, yí giì tuu ndâ àsìkérì mì wó máa ndú ya gí bà ziki ndâ ꞌduù tí nò, wàa ndú ꞌví cu wu mítí ndâ ꞌbá mì ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bìndi  yí giì tuu ndâ ꞌbí bòò mì wó kákáꞌi máa, ‹Ye bàkà ndâ i-zó-zò bà ko niì cee gî. Káa ndâ ꞌduù tí nó náa ye táánò ma có bà ko niì ji ndú nó ꞌvii tí ndâ mbe gì lá. ");
INSERT INTO ndz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Má énò, yo ya ta ndi tí ndâ kpokèjì, wàa yo má ꞌde ndâ ꞌduù, yo ꞌví tèꞌé tí ndú, wàa yo ꞌví njèè i-zó-zò ji ndú, tacó ndâ yâ bà kpílí-kpili.› ");
INSERT INTO ndz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ndâ bòò mì gba mâ giì kili ndâ ꞌduù go có mì wó nò gî, ndú giì kaa ndú mí tàꞌi bà zò i. ");
INSERT INTO ndz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Gba mâ giì gì tacó bà ꞌvee ndâ wiṛi mì wó, yí giì ŋò ꞌbí ꞌdakò gbí òkò tí ndú mbe yuu me bòngo bà ya gí bà ko niì lá. ");
INSERT INTO ndz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bìndi  gba giì ꞌvee ꞌdakò tí nò, máa, ‹Àá kómbe ye, wò ṛì gí tàꞌi tí nó ta ŋa kpokèjì ngàyi?› Káa bà ꞌvìsì có ji gba giì kpò ꞌdakò tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bìndi  gba giì ꞌdè có ji ndâ ꞌduù mì wó mbe kû kpolo tí ndâ wiṛi nó máa ndú eṛe ꞌbì ꞌdakò tí nò gî, wàa ndú ꞌví eṛe kò wó gî, wàa ndú ꞌví te yí ꞌva mí gbí ꞌdíꞌdiꞌo sè, tí bàndò bà wa gbí ta bà ꞌvìì tì ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tacó à tèꞌé tí ndâ ꞌduù me mbè, káa yí ṛuka ꞌdo gbí òkò tí ndú ká njíꞌdíí.» ");
INSERT INTO ndz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà giì kili bà muu ndú kákáꞌi tacó bà zèè Jézù ꞌdo tí mè wó. ");
INSERT INTO ndz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bìndi  ndú giì tuu ndâ ꞌbí mbe tala có mì ndú ta ndâ ꞌbí mbe kû tè gí tàkò có mì Èródè tí gbolò gba, máa ndú ya gí mì Jézù, wàa ndú ꞌví ꞌvee yí ta tiṛì máa, «Mbe nìbà i, ze ŋò wò ni tí ꞌduù ŋìnó jáá, mbe kû nìbà kpokèjì mì Mbíṛì ji ndâ ꞌduù me ta tiṛì lá gî. Wò delè cì gúku tí ꞌduù gbaànjé lá, tacó ndâ ꞌduù ꞌdáá gî kùṛo lo ká gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Có mì lo kpónó máa yè? Có mì lo máa, à dú tacó tí ndoo tí ndâ Jùdéyà bà gò i-mírì ji ngáángbá gba mì ndâ Ròmánò? ꞌDè ji ze gî.» ");
INSERT INTO ndz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Káa Jézù giì ꞌdi gbí tiṛì mì ndú nò gî. Tacó énò, yí giì ꞌvìsì có ji ndú, máa, «Yo kû tala ye tacó yè, ndi yo ndâ mbe nambeè-ṛo? ");
INSERT INTO ndz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yo tù ŋa njì gùrúsù tí nò náa yo kû gò ji ngáángbá gba mì ndâ Ròmánò nò ji ye gi.» Ndâ ꞌduù tí nò mâ giì tù ŋa njì gùrúsù tí nò ji Jézù gî, ");
INSERT INTO ndz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jézù giì ꞌvee ndú máa, «À ka mítí gùrúsù tí nó nó a muu ꞌdi, ta ṛè wó náa à cu mítí  nó?» ");
INSERT INTO ndz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Káa ndú giì ꞌvìsì có ji Jézù máa, «A muu ngáángbá gba mì ndâ Ròmánò, ta ṛè wó náa à cu nò.» Tacó énò, Jézù giì ꞌvìsì có ji ndú, máa, «Má énò, yo je ndâ i mì gba mì ndâ Ròmánò ji ngáángbá gba mì ndâ Ròmánò, wàa yo ꞌví je ndâ i mì Mbíṛì ji Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ndâ ꞌduù tí nò mâ giì ꞌdi ŋa có mì Jézù náa yí ꞌvìsì ji ndú gí tàkò ꞌvé mì ndú nò, nje ndú giì ꞌdèè gî, bìndi  ndú giì njè jee yí mí bàndò mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta gbèe ꞌdêꞌo tí nò, ndâ ꞌbí ŋa Jùdéyà ŋìnó mbe ùnje gítí bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú lá nó, giì gì gí mì Jézù, bìndi  ndú giì ꞌvee yí máa, ");
INSERT INTO ndz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Mbe nìbà i, Mòze táánò ꞌdè có énó máa, ꞌduù má kò niì, káa ku giì je yí gî, ndú má jò ta niì tí nò lá, náꞌvindí ku tí nó ꞌví zèè ꞌbì nawù ku tí nò. Mbíṛì má je ꞌviì-ꞌdakò ji ndú, ꞌviì tí nó ꞌví dù gbí mòòkò bìndi ku tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Káa ta ꞌbí o gbaànjé, ꞌbí ꞌviì-ꞌdakò náa nawu ndú jò ndú vô-nje só giì kò niì, káa ku giì je yí si ndú jò ta niì tí nò lá. ");
INSERT INTO ndz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ꞌBí náꞌvindí ꞌviì-ꞌdakò tí nò gbaànjé giì zèè ꞌbì nawù ku bìndi wó, káa ndú giì jò ta yí lá, bìndi  ku giì je ꞌviì-ꞌdakò tí nò gí tàkò náꞌvindí wó gî. Ndâ ꞌviì-ꞌdakò tí nò vô-nje só gbí yì mì nawu ndú nò ꞌdáá gî tèṛì á cìkii niì tí nò gî. Ku delè giì ṛuka ndú gbaànjé-gbaànjé ꞌdáá gî. Káa gbèe ꞌbí ꞌduù gbí òkò tí ndú mbe jò ꞌviì ta yí wálá. ");
INSERT INTO ndz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bìndi  niì tí nò giì cì tí ndòngbú ꞌduù gí tàkò ndú. ");
INSERT INTO ndz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Má énò, niì tí nò bà dù a niì mì ꞌdi gbí òkò tí ndú wúnò ta o bà ꞌvala ndi ndâ ku á ꞌdo gbí muuꞌdú ndú?» ");
INSERT INTO ndz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Káa Jézù giì ꞌvìsì có ji ndú máa, «Có mì yo nò lè gî. Tacó yo ꞌdi gbí ndâ có tí nó náa à cu mí gbí wáràgà mì Mbíṛì nó lá. Yo delè ꞌdi gbí ndâ kpokèjì bà bàkà ndâ i mì Mbíṛì lá. ");
INSERT INTO ndz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tacó ta o bà ꞌvala ndi ndâ ku á ꞌdo gbí muuꞌdú ndú wúnò, ndâ ꞌdakò ta ndâ niì bà kò tí ndú kákáꞌi wálá. Tacó ndâ ꞌduù ta o tí nò bà dù go ndâ basìlì á gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Káa à má gítí có bà ꞌvala ndi ndâ ku á ꞌdo gbí muuꞌdú ndú, yo jé ꞌdeke có tí nó gbí wáràgà mì Mbíṛì nó lá? ");
INSERT INTO ndz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Mbíṛì táánò ꞌdè có ji Mòze, máa, ‹Ye a Mbíṛì mì Àbìráámò, ye a Mbíṛì mì Ìzákò, ye a Mbíṛì mì Jàkóbè.› Káa Mbíṛì táánò ꞌdè có tí nò ji Mòze si ndâ ꞌduù tí nò náa yí ꞌdeke ndú, máa yì a Mbíṛì mì ndú nò, cì sàà gî. Káa yí kpòò káa Mbíṛì mì ndú. Gbí  énò máa, ndâ ꞌduù tí nò kpòò kû ꞌvala bìndi bà cì ndú.» ");
INSERT INTO ndz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ndâ mbè ꞌduù tí nò mbe tì mí mì Jézù nò mâ giì ꞌdi có tí nò náa yí ꞌvìsì ji ndâ ŋa ndâ Jùdéyà nò mbe ꞌdè có énó máa ndâ ku bà ꞌvala ndi ndú ꞌdo gbí muuꞌdú ndú wálá nò, nje ndú giì ꞌdèè gítí ŋa bà nìbà i mì wó nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ꞌdi có énó máa Jézù kpò nje ndâ ꞌbí ŋa Jùdéyà ŋìnó mbe kû ꞌdè có máa ndâ ku bà ꞌvala ndi ndú ꞌdo gbí muuꞌdú ndú wálá nó gî, ndú giì kili bà muu ndú, bìndi  ndú giì kaa ya gí mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Bìndi  ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndú tí cèe gbolò mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà giì ꞌvee Jézù ta tiṛì, máa, ");
INSERT INTO ndz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Mbe nìbà i, kpóló-kpolo có gbí òkò ndâ có mì Mòze ꞌdáá gî a có ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Káa Jézù giì ꞌvìsì có ji yí máa, «Kpóló-kpolo có gbí òkò ndâ có mì Mòze ꞌdáá gî a ŋìnó máa, ‹Wò ꞌví zè Mbíṛì tí Mbe tí lo nìkì ta njembí lo gbaànjé, ta lilí lo gbaànjé, delè ta bà koṛo có mì lo gbaànjé.› ");
INSERT INTO ndz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ŋìnò a kpédélé có, delè tí kpóló-kpolo có mbe ndii ndâ ꞌbí sè có mì Mòze ꞌdáá gî ká nò. ");
INSERT INTO ndz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ꞌBí có mì Mòze mbe giì kpolo gí tàkò ŋìnò a ŋìnó máa, ‹Wò ꞌví zè ndâ ꞌbí ká lo nìkì go ba zè ꞌdóó tí lo nìkì mì lo.› ");
INSERT INTO ndz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ndâ có mì Mòze, ta ndâ bà nìbà i mì ndâ mbe ꞌdòkò có mì Mbíṛì táánò mìì ꞌdáá ká mítí ndâ có tí nò sósòꞌô nò.» ");
INSERT INTO ndz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jézù giì ꞌvee ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà tí nó mbe tì ꞌdee yí gî nó máa, «Kóṛó-koṛo có mì yo kpónó gítí Bìndi-Mbíṛì máa yè? Yí a ꞌviì mì ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Káa ndú giì ꞌvìsì có ji yí máa, «Yí a ꞌviì mì Dàvídè.» ");
INSERT INTO ndz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Káa Jézù giì ꞌvee ndú kákáꞌi máa, «Má énò, à cu mí gbí wáràgà mì Mbíṛì máa, Dàvídè táánò ꞌdè kòcò ta wotí mì Bèṛi-mì-Mbíṛì gítí Bìndi-Mbíṛì máa, ");
INSERT INTO ndz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Mbíṛì ꞌdè có ji Mbe tí ye máa, «Ki tí lo to gbí kùꞌbì mì ye, yee tí o tí nó náa ye bà bàkà ndâ kuꞌdì mì lo tí ndâ i-tà-tàmà mì lo.» › ");
INSERT INTO ndz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Má énò, Dàvídè má kû nì mítí Bìndi-Mbíṛì a ‹Mbe tí ye,› Bìndi-Mbíṛì bà giì dù tí ꞌviì mì Dàvídè ta ŋa kpokèjì ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Káa bà ꞌvìsì có gí tàkò ꞌvé mì Jézù nò giì kpò ndú gî. Delè ꞌbí ꞌduù kákáꞌi mbe giì yeeke tí wó ta bà ꞌvee yí gítí ꞌbí có ꞌdo gbí ṛi tí nò kû ya gí kùṛo wálá. ");
INSERT INTO ndz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ta o tí nò Jézù giì kpo-gbí-tà-tù ndâ mbe tala có mì wó ta ndâ ꞌbí ꞌduù me mbè, máa, ");
INSERT INTO ndz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ndâ mbe ꞌdi gbí-o, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, a ndâ mbe ki tí pí jàlàmbà bìndi Mòze. ");
INSERT INTO ndz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Má énò, yo ꞌví kpolo tí ndâ có tí nó náa ndú kû ma ji yo nô. Yo delè ꞌví bàkà go ndâ có tí nò. Káa yo ꞌví mèlè ndi bà bàkà ŋa ndâ i mì ndú lá, tacó ndú kû ma ndâ có mì Mòze ji ndâ ꞌduù, káa ndú bàkà go ndâ có tí nò lá. ");
INSERT INTO ndz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","I tí ndú a bà ꞌdeeke du koṛi tacó bà ba ta gbímbí ndâ ꞌduù. Káa ndú jé gítí bà tee vòó sìlì ꞌbì ndú mítí ba koṛi tacó bà konì ndâ mbe kû òlú tí  nò wálá! ");
INSERT INTO ndz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ndú ta o ꞌdáá gî kû mà tí ndú ta bà bàkà ndâ i mì ndú ká mà, tacó wàa ndâ ꞌduù ꞌví ŋò ta ndâ yì. Ndâ kúúkpá mì ndú me kpo-kpò, bìndi  ŋa bà me vòngbò-vòngbò mì nje ndâ bòngo mì ndú mì sè ndâ ꞌbí ꞌduù wálá. ");
INSERT INTO ndz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","7","Ndú má yee tí bàndò ta mbè ndâ ꞌduù tí , à tí ndú káa go bà bàkà tí ndú, wàa ndâ ꞌduù ꞌdáá gî ꞌví ŋò ndâ yì ni tí ndâ cèe ꞌduù, delè tí ndâ kpo-kpò ꞌduù mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà ndii sè ndâ ꞌbí Jùdéyà ꞌdáá gî, gî. Có mì ndú gbí njembí ndú máa, ndâ ꞌduù ꞌví tèꞌé tí ndâ yì ká ta ndâ kpo-kpò ṛè, go ndâ ‹Mbe nìbà i›. ");
INSERT INTO ndz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Káa yo ꞌví si ꞌduù ꞌví nì ‹Mbe nìbà i› mítí yo lá, tacó mbe nìbà i ji yo ká gbaànjé, bìndi  yo ꞌdáá gî a ndâ náꞌvindí. ");
INSERT INTO ndz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wàa yo delè ꞌví nì ‹Buù› á mítí ꞌbí ꞌduù á muu to tí nó lá, tacó Bu yo ká gbaànjé gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ndâ ꞌduù ꞌví nì ndâ ‹Mbe tí ze› mítí yo delè lá, tacó mbe tí yo ká gbaànjé tí Bìndi-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ꞌDuù ŋìnó tí gbolò ꞌduù gbí òkò tí yo ꞌdáá gî nó ꞌví dù tí bòò mì yo. ");
INSERT INTO ndz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ꞌDuù má si tí wó tí cèe ꞌduù, Mbíṛì bà si yí tí i wálá, káa ꞌduù má si tí wó tí i lá, Mbíṛì bà te duù mítí wó.» ");
INSERT INTO ndz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jézù giì ꞌdè có ji ndâ mbe nìbà i, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, máa, «Yo tí ndâ mbe nìbà i, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, yo tí ndâ mbe nambeè-ṛo! Yo bà ŋò mítí yo, tacó yo nè njekèjì ꞌbá mì Mbíṛì ꞌdo tí ndâ ꞌduù gî. Yo jèjèèkè tí yo mí njekèjì mì Mbíṛì ji ndâ ꞌduù go bà jèjèèkè tí ndâ kî mí nje mbu. Ndú gí gbí mbu wálá, káa ndú delè gí bà si kpokèjì ji ndâ ꞌbí ŋa sè wàa ndú ꞌví ya tí  gí gbí mbu ká wálá. ");
INSERT INTO ndz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Yo tí ndâ mbe nìbà i, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, bà ŋò mítí yo, tacó yo a ndâ mbe nambeè-ṛo. Wúꞌdè ṛèꞌdè ndâ nawù ku zii ji yo mìì gî. Yo kû ꞌbuuku muu ndâ vò i mì yo ta bà bàkà tí yo tí ndâ mbe ꞌdeke tí yo ji Mbíṛì ta síí gbí  wálá. ");
INSERT INTO ndz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Yo tí ndâ mbe nìbà i, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, bà ŋò mítí yo! Yo si sè to lá, yo nò cee pí gú, cee muu ngo, máa, yo kû pà ndâ ꞌduù tacó wàa yo ꞌví gì ta ndú gí gbí tàkìì mì yo tí ndâ Jùdéyà. Káa yo má tò kò yo ta gbèe ꞌduù, yo giì bàkà yí gì tí vò ꞌduù ndii yo ta bà  sósòꞌô. ");
INSERT INTO ndz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Yo tí ndâ mbe sú ṛò mbe kû tùbà kpokèjì ji ndâ ꞌduù, yo bà ŋò mítí yo! Yo kû ꞌdè có máa, ꞌduù má be tí ꞌbá-Mbíṛì, ŋìnò me có ká nò lá. Káa ꞌduù má be tí dâꞌbì tí nó á tàꞌi ꞌbá-Mbíṛì nó, kózò tí wó ꞌví bàkà go có tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gbí có mì yo wálá! Kpóló-kpolo i kpónó a dâꞌbì wèè, kpóló-kpolo i a ꞌbá-Mbíṛì, tí ꞌbá tí nó náa á má te dâꞌbì á mí tà , káa dâꞌbì tí nó gì tí i mì Mbíṛì gî nó? ");
INSERT INTO ndz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ꞌBí có ŋónókó mì yo kákáꞌi a ŋìnó máa, ꞌduù má be tí bàndò bà te i-cí-ci ji Mbíṛì, ŋìnò káa làmbu có sínò. Káa ꞌduù má be tí i-cí-ci, yí ga wú mítí miṛi wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","À kpolo a có i-cí-ci wèè, à kpolo a có bàndò bà ci i ji Mbíṛì mbe bàkà i tí nò náa á ci nò tí i mì Mbíṛì nó? Yo a ndâ ŋónókó ꞌduù mbe ꞌdi gbí-o lá. ");
INSERT INTO ndz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Má énò, ꞌduù má be tí bàndò bà ci i ji Mbíṛì, yí be me káa tí kùnga bàndò cuki lá. Yí nì a ndâ bàndò tí nò ta i-cí-ci tí nó náa à tí  nô. ");
INSERT INTO ndz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ꞌDuù delè má be tí ꞌbá-Mbíṛì, yí nì me káa ꞌbá cuki lá. Yí be a tí Mbíṛì tí mbe kû ꞌvala tàꞌi tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bìndi  ꞌduù má be tí ṛì, yí kû be nò a tí ndâ jàlàmbà mì Mbíṛì ta Mbíṛì tí mbe kû ki tí pí jàlàmbà tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Yo tí ndâ mbe nìbà i, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, yo bà ŋò mítí yo, tacó yo a ndâ mbe nambeè-ṛo! Yo kû sì ṛo Mbíṛì ta bà gò ndâ víí i-gbí-njí ta i gbí ndú wálá, go ndâ kpátùyâ, go có mì Mòze. Yo kpêtí má bàkà énò gî, yo kùtàá ꞌví ò-bà-mbí ndâ kpóló-kpolo có mì Mòze, go ndâ có gítí bà waa có ta yúcó, ta bà ŋò yê ṛo ndâ ꞌduù, ta bà dù tí ndâ ꞌduù jáá nó lá. ");
INSERT INTO ndz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yo a ndâ mbe sú ṛò mbe kû tùbà kpokèjì ji ndâ ꞌduù! Yo a ndâ mbe sú ṛo mbe kû guu ngo njú-njù mì yo ta kùtà, máa, ndâ víí gûꞌi gbí ngo bà lì tàkòcò yo, káa yo kû miṛi kùùyù ya ta nó! ");
INSERT INTO ndz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Yo tí ndâ mbe nìbà i, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, bà ŋò mítí yo, tacó yo a ndâ mbe nambeè-ṛo! Yo kû ꞌdè líkí nje ji ndâ ꞌduù, káa à yè gbí njembí yo cuki káa có gítí bà kùmùkù ndâ i mì ndú ta wotí gítí miṛi yo; yo go ꞌduù ŋìnó mbe kû caka kapí ndâ káꞌi si gbí ndú ta bètí nô. ");
INSERT INTO ndz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yo tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà a ndâ mbe sú ṛo! Yo kùtàá bà caka a gbí ndâ káꞌi kùṛo má kózò gî, bìndi  yo ꞌví giì caka kapí ndú. ");
INSERT INTO ndz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Yo tí ndâ mbe nìbà i, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà bà ŋò mítí yo, tacó yo a ndâ mbe nambeè-ṛo! Yo go ndâ muuꞌdú náa à te banga mítí ndú ta bà toṛo cé-ce màŋò mítí ndú, káa tó i gbí gùù á tà banga tí nò bìndi ndâ kù ꞌbilì ku, ta zì ku, wálá. ");
INSERT INTO ndz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yo go banga muuꞌdú, tacó ndâ ꞌduù kû ŋò yo go ndâ tó ꞌduù mbe kû co tí jáá kpokèjì, káa yo a cèe ndâ vò ꞌduù, tí ndâ kpo-kpò mbe nambeè-ṛo. ");
INSERT INTO ndz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Yo tí ndâ mbe nìbà i, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, yo a ndâ mbe nambeè-ṛo! Yo tí ndâ mbe kû te banga mítí ndâ bàndò bà duu ndâ mbe ꞌdòkò có mì Mbíṛì! Yo tí ndâ mbe kû te banga mítí ndâ muuꞌdú ndâ tó ꞌduù mì Mbíṛì! Yo bà ŋò mítí yo, ");
INSERT INTO ndz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","tacó yo kû ꞌdè ꞌvéṛè énó máa, ‹Ze táánò má ꞌvala gbí o mì ndâ ká gù ze, ze bà gbètèkè mbelè ndâ mbe ꞌdòkò có mì Mbíṛì mítí ꞌbì ze go i mì ndú wálá.› ");
INSERT INTO ndz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Má énò, yo kû yù nò a gbí tí yo á gí sè ta kpéétí yo, máa, yo a ndâ ꞌviì mì ndâ ꞌduù tí nó táánò mbe ziki ndâ mbe ꞌdòkò có mì Mbíṛì nô! ");
INSERT INTO ndz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nògí, yo cee sè nèté tí nó táánò náa ndâ bu yo ꞌbìtà nó gî. ");
INSERT INTO ndz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yo a ndâ kpoo! Yo a ndâ ꞌviì mì ndâ gùlù kpoo! Yo bà ndo ꞌdo gbí bà waa có mítí yo mì Mbíṛì co tí kpokèjì ngàyi? ");
INSERT INTO ndz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","«Má énò, ye kû giì tuu ndâ ꞌbí ngú mbe ꞌdòkò có mì Mbíṛì, ta ndâ ꞌbí ngú mbe ꞌdi gbí-o, ta ndâ ꞌbí ngú mbe nìbà i ji yo. Yo bà giì ziki ndâ ꞌbí ꞌduù gbí òkò tí ndú gî. Yo bà giì gbì ndâ ꞌbí  ta ndi tí ndâ bàndò bà kili yo. Yo bà mòkò ndú cee gbí ndâ gbata ꞌdáá gî, bìndi  yo bà giì le ndâ ꞌbí  lé-le. ");
INSERT INTO ndz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Ye bà tuu ndâ ngú ꞌduù tí nò ji yo tacó wàa có tàkò ndâ mbelè ndâ tó ꞌduù mì Mbíṛì ꞌdáá gî, mbe ꞌbìtà bà yee to á ꞌdo tí bà ꞌbìtà bà suu to tí nó, mbe ꞌbìtà ꞌdo tí mbelè Àbélè tí yê sínò ta có mì wó ta náꞌvindí wó wálá, yee tí Zàkàríyà tí ꞌviì mì Bàràkíyà, náa ndâ gù yo zi yí mí ṛègbà bàndò bà te i-cí-ci á tàꞌi ꞌbá-Mbíṛì nó, ꞌví dù tí ꞌbì yo tí ndâ ꞌduù tí nó gbí o tí nó, nô!» ");
INSERT INTO ndz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jézù bà-i-nò giì ꞌdeke tí wó tacó tí ndâ ꞌduù Jèrùzàlémè máa, «Ákoo Jèrùzàlémè, Jèrùzàlémè! Wò ziki ndâ mbe ꞌdòkò có mì Mbíṛì, tí ndâ ꞌduù ŋìnó náa Mbíṛì tuu ndú ji wò nó gî. Ye jè ta bà kili ndâ ꞌviì mì lo go bà kili ndâ ꞌviì mì na ngùù gí tà mbî wó ta bà  me mbè, káa à kpò ye gî. ");
INSERT INTO ndz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ye bà si énò! ꞌBá mì lo bà ꞌbu gî, ");
INSERT INTO ndz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","tacó ye ci wò gî. Wò bà ŋò ye ta ṛo lo kákáꞌi wálá, yee tí o tí nó náa wò bà ꞌdè ta nje lo máa, ‹À ùlù mbe gì ta ṛè mì Mbe tí ndoo!› gî.» ");
INSERT INTO ndz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jézù mâ giì co gí sè ꞌdo gbí ndùgù ꞌbá-Mbíṛì gî, ndâ mbe tala có mì wó giì ùlù banga tí ndâ ꞌbá tí nó a bàndò ꞌbá-Mbíṛì nó ji yí si yí kû bàkà có bà njè nó. ");
INSERT INTO ndz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo ŋò ndâ díí tí nò ꞌdáá gî, gî? Àá bà giì kiꞌviki ndâ banga ꞌbá tí nò ꞌdáá náa yo kû ŋò nò lúꞌbú-lúꞌbú gî! ꞌBí gbèe díí bà giì dù pí ka wó bà-i-nò wálá.» ");
INSERT INTO ndz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ndâ Jézù mâ giì yee ta ndâ mbe tala có mì wó pí Gú Mbâ gî, yí giì ki tí wó to, bìndi  ndâ mbe tala có mì wó giì ꞌvee yí tà bèngìì máa, «Àá bà kiꞌviki ndâ ꞌbá tí nò gí to ta o ngàyi? Káa ze bà ŋò ni mítí yè? Ze delè ꞌví ŋò ndâ ndòngbú o, ta o bà gì ꞌViì-mì-ꞌDakò ni mítí yè?» ");
INSERT INTO ndz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Káa Jézù bà-i-nò giì ꞌvìsì có ji ndú máa, «Yo kpolo tí yo, máa ꞌbí ꞌduù ꞌví ŋonoko yo lá. ");
INSERT INTO ndz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tacó ndâ ꞌduù me mbè ta o tí nò bà gì ta ṛè ye, ndú bà bàkà tí ndú tí ndâ Bìndi-Mbíṛì ta wotí. Ndâ ŋa ndâ ꞌduù tí nò bà gì tí ndâ mbe ŋònòkò muu ndâ ꞌduù me mbè. ");
INSERT INTO ndz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yo delè ta o tí nò bà ꞌdi có gítí ndâ kpo-kpò gó, ta ndâ fííní-fiini có gítí ndâ kpo-kpò gó. Káa njembí yo ꞌví mù lá, tacó ndâ i tí nò ꞌdáá gî bà me tí gî, káa ndòngbú o kálásê. ");
INSERT INTO ndz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tacó ta o tí nò ndâ ꞌduù ꞌdo muu to kèꞌbí  bà ya gí bà tè ꞌbá mì ndâ ꞌbí ka ndú ta gó. Ndâ kpo-kpò gba bà tè ndâ ka ndú ta gó. Làngàwìṛí bà tè to. To bà giì tanga tí tí ndâ bàndò me mbè. ");
INSERT INTO ndz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ndâ i tí nò ꞌdáá gî bà dù káa bà ꞌbìtà gó-káyì sínò. ");
INSERT INTO ndz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Ta o tí nò, ndâ ꞌduù muu to tí nó ꞌdáá gî bà sogo yo á muu ye. Ndú bà giì kaa yo ya tí  gí gbí ngbàngà, bìndi  ndâ gba bà giì waa có mítí yo ta ꞌvéṛè. Ndú bà kaa yo ji ndâ ꞌduù máa ndú mèèkèꞌi tí yo, wàa ndú ꞌví ziki yo gî. ");
INSERT INTO ndz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ndâ ꞌduù me mbè ꞌdo gbí òkò tí ndâ ꞌduù mì ye bà bè ye gî. Ndú delè bà kpì ngbàngà tí ndâ ꞌbí ka ndú ŋìnó mbe kû tee njembí ndú mítí ye nô. Ndâ ꞌduù bà giì sogo tí ndú gbí òkò tí ndú. ");
INSERT INTO ndz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta o tí nò delè, ndâ sú mbe ꞌdòkò có mì Mbíṛì me mbè bà oloko kû ŋònòkò muu ndâ ꞌduù ꞌdo tí cèe kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndâ ꞌduù bà zè tí ndú gbí òkò tí ndú ta o tí nò nìkì dúú-dúú wálá, tacó yúcó bà giì dù wálá. ");
INSERT INTO ndz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Káa Mbíṛì bà ꞌvala ndâ ꞌduù ŋìnó mbe sè kò ndú á mí to tí kpoò yee tí ndòngbú ndâ vò o tí nò nó gî. ");
INSERT INTO ndz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","«À delè bà ma a Banga-Ngú-Có gítí bà dù Mbíṛì tí gba ji ndâ ꞌduù muu to tí nó má ꞌdáá kózò gî, bìndi  ndòngbú o bà giì gì . ");
INSERT INTO ndz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Má énò, yo má giì ŋò ŋa vò i tí nó ta go bà ŋò yí ṛè ṛo ndâ ꞌduù tí ndú wálá, náa Dànìyélè tí mbe ꞌdòkò có mì Mbíṛì dígísèé ꞌdè cò gítí wó nó, co kû ṛò tíyò á ṛègbà ꞌbá-Mbíṛì gî (ꞌduù tí nó mbe kû ꞌdeke i tí nó, nó ꞌví koṛo muu wó), ");
INSERT INTO ndz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","bìndi , ndâ ꞌduù gbí to Jùdéyà ꞌví kaa ta ngèlè ya gí bà ngùù tí ndú pí ndâ gú. ");
INSERT INTO ndz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ꞌDuù ta o tí nò má kû tèwo wó á tàzo ꞌbá, yí ꞌví ndii ká ta gbí muu wó ya gí bà pà kpokèjì ꞌválá. Yí ꞌví koṛo có me gítí bà ya gí bà zeke bà ndâ i mì wó tàꞌi nò lá. ");
INSERT INTO ndz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ꞌDuù delè ta o tí nò má gbí njí, yí ꞌví ndii ká ta kpokèjì kà ya gí bà pà bàndò ꞌválá. Yí ꞌví koṛo có gítí bà ì ngèlè ya gí bà kaa ndâ bòngo mì wó ꞌdo ꞌbá lá. ");
INSERT INTO ndz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Káa àá bà volo ji ndâ ꞌduù ŋìnó ta ndâ víí ꞌviì ká mì ndú nó, ta ndâ nawu ndâ dó ꞌviì, ta ndâ mbe nakáyì gbí ndâ sili tí nò ngé! ");
INSERT INTO ndz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Má énò, yo ꞌdeke tí yo ji Mbíṛì máa vò o tí nò ꞌví dù me ta bìtìì bèmbílì lá. À delè ꞌví dù me ta ṛi bà wotí gbí tàkìì mì yo tí ndâ Jùdéyà lá. ");
INSERT INTO ndz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tacó ŋa ndâ vò i tí nò bà giì bàkà tí ta o tí nò nò, jé sàà bàkà tí ꞌdo tí o bà ꞌbìtà bà suu to tí nó mì Mbíṛì yee tí wúnó lá. Ndú delè kákáꞌi bà bàkà tí wálá. ");
INSERT INTO ndz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mbíṛì táánò má ja tí o tí nò lá, sè ꞌduù gbaànjé gí bà dù wálá. Káa yí ja tí o tí nò gî, tacó bà ꞌvala ndâ ꞌduù mì wó náa yí ṛuka ndú nô. ");
INSERT INTO ndz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«ꞌBí ꞌduù ta o tí nò má ꞌdè có ji yo, máa, ‹Yo zekeꞌo gi, Bìndi-Mbíṛì nô! Yí a i zô!› Yo ꞌví ùnje gítí có mì wó nò lá. ");
INSERT INTO ndz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tacó ta o tí nò ndâ mbe bàkà tí ndú tí ndâ bìndi-Mbíṛì ta ndâ mbe bàkà tí ndú tí ndâ mbe ꞌdòkò có mì Mbíṛì me mbè bà oloko kû bàkà ndâ seṛè tacó bà eendi ndâ ꞌduù ꞌdáá gî, kpêtí káa ndâ ꞌduù ŋìnó náa Mbíṛì ṛuka ndú gî nô, náa ndú má ꞌde kpokèjì gítí bà me énò gî nò. ");
INSERT INTO ndz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Má énò, yo kpolo ṛo yo, tacó ye ꞌva nò a gbí tù yo gítí bà gì o tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Má énò, ndâ vò ꞌduù tí nò má eendi yo ta o tí nò máa, ‹Yo ŋò ꞌViì-mì-ꞌDakò ngéé gbí kángáá nga ngoò zô!› yo ꞌví ya gí kà lá. ");
INSERT INTO ndz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ndú delè má tù ꞌbì ndú ji yo máa, ‹ꞌViì-mì-ꞌDakò kû ngùù tí wó ngéé mítí bàndò tí zô!› yo ꞌví tè gí tàkò có mì ndú nò lá. Tacó bà gì ꞌViì-mì-ꞌDakò bà dù go ngbàngbàṛì mbe ba i gbaànjé bìndi  yí giì ṛengà cee to ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ndâ gàlàmbá má yaà kere-kèrèè, gbí  énó máa, ku i kuu gbí to tí nò. Káa à me ꞌduù ká kû tùbà ku nò ji ndú lá. Má énò, à delè me ꞌduù ká bà tùbà o bà gì ꞌViì-mì-ꞌDakò ji yo lá. ");
INSERT INTO ndz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ngé bìndi ndâ vò i tí nò, ṛo ṛi bà giì ꞌdi gî, ngba pì bà giì dù wálá, ndâ yii bà giì ꞌduku ꞌdo tàṛì gí to, tàṛì bà giì ngaka tí. ");
INSERT INTO ndz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nògí, ꞌViì-mì-ꞌDakò bà giì co go seṛè á tàṛì, bìndi  ndâ ꞌduù muu to tí nó ꞌdáá gî bà giì zèè muu ndú ta bà ŋò ꞌViì-mì-ꞌDakò kû da nó ta wotí tí  co gbí kùlù mù ngbèzèè kû gì gí muu to tí nô. ");
INSERT INTO ndz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Gbí mòngò bà giì me tí ta wotí tí , bìndi  yí bà giì tuu ndâ basìlì ya gí bà tèꞌé tí ndâ ꞌduù mì wó náa yí ṛuka ndú nó cee muu to tí nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Mbiìgá má ꞌbìtà bà tù dó kpâ gî, yo ŋò ni gî máa bèmbílì dooko gî. ");
INSERT INTO ndz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Má énò, yo má ŋò ndâ i tí nò náa ye ꞌdè có ji yo gítí ndú nò kû bàkà tí, yo ꞌví koṛo muu yo máa, o bà gì ꞌViì-mì-ꞌDakò dooko jéꞌdéé gî. ");
INSERT INTO ndz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yo te mí gbí muu yo máa, ndâ i tí nò ꞌdáá náa ye ꞌdè có gítí ndú ji yo nò bà bàkà tí kùṛo o bà mìì ndâ ꞌduù tí nó gbí o tí nó nô. ");
INSERT INTO ndz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ndâ tàṛì ta to tí nó bà cee gî, káa, ndâ có mì ye bà dù cóó ká tí bàndò mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Káa à má gítí ndâ o ta ṛi tí nò, ꞌbí ꞌduù gbaànjé mbe ŋò ni wálá. À kpêtí káa ndâ basìlì gbíṛì, ndú ŋò ni lá. ꞌViì delè ŋò ni ká lá. À káa Buù ta kpéétí wó ká ŋò ni ");
INSERT INTO ndz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","«Yo kpolo tí yo, tacó ŋa ndâ i tí nó táánò mbe bàkà ndâ ꞌduù gbí o mì Nówà nó bà giì ꞌde ndâ ꞌduù ta o bà gì ꞌViì-mì-ꞌDakò. ");
INSERT INTO ndz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tacó àá táánò ta kùṛo bà ò ngo gbí o mì Nówà, ndâ ꞌduù kû zò i, ndâ ꞌduù kû njù i, ndâ ꞌdakò ta ndâ niì kû kò tí ndú yee ká ngé tí o bà o Nówà gí gbí gbâ. ");
INSERT INTO ndz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ndú koṛo ꞌbí làmbu có njíꞌdí énó máa, vò i kèjì nò, ngé gî lá, yee ká tí o tí nó náa ngo giì ò có tàkò ndú léé gî. À wúnò bà dù go énò ta o bà gì ꞌViì-mì-ꞌDakò. ");
INSERT INTO ndz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ta o tí nò ndâ ꞌdakò má sósòꞌô kû bàkà nèté gbí njí, àá bà je ꞌbí ꞌduù gbaànjé gî, si ꞌbí ka wó. ");
INSERT INTO ndz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","À delè má ꞌde ndâ niì sósòꞌô kû no ꞌvuù, àá bà je ꞌbí ꞌduù gbaànjé, si ka wó ta kpéétí wó mí ṛo ꞌvuù. ");
INSERT INTO ndz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Káa à má énò, yo ꞌví kpolo tí yo, tacó yo bà ŋò o tí nó náa Mbe tí yo bà gì gbí  nó ni wálá. ");
INSERT INTO ndz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Káa yo ꞌví te mí gbí muu yo máa, mbe ꞌbá kùtàá má ŋò o bà gì mbe ngbà ta bèbìlì ni gî, yí bà dù tí zòꞌo, tacó wàa, mbe ngbà ꞌví ngbà ndâ i mì wó lá. ");
INSERT INTO ndz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Má énò, yo delè ꞌví ꞌviindi tí yo, tacó ꞌViì-mì-ꞌDakò bà gbaaka yo wúnò gbááká-gbaaka ta o bà gì yí. ");
INSERT INTO ndz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Má énò, yo koṛo muu yo gi. Gba kû si ndâ i-ꞌbá mì wó náa yí kpêtí má ꞌbá wálá a i mí ꞌbì ŋa bòò ngàyi? Yí kû si ndâ i-ꞌbá mì wó náa yí kpêtí kû ya ká gí muu njà nó a i mí ꞌbì ŋa bòò ŋìnó ta muu kuu tí wó, delè mbe kû bàkà nèté ta njembí wó gbaànjé nô. ");
INSERT INTO ndz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Gba má dele ndi wó ꞌdo muu nó gì gí bà ꞌde ndâ ꞌduù ꞌbá mì wó ta líkíꞌo tí ndú, yí bà peteke tàkòcò tó bòò mì wó nò ta ŋa  wálá, ");
INSERT INTO ndz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ta bà bàkà yí tí mbe kpolo tí ndâ i-ꞌbá mì wó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Káa wò ŋìndi lo tí vò bòò mbe tee mbí lo mítí nèté mì lo lá bà giì koṛo a có máa, ‹Gba kpónó a ye!› ");
INSERT INTO ndz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Bìndi  wò bà giì ꞌbì a tà bà mèèkèꞌi tí ndâ ꞌbí ka lo bòò ŋìnó náa yo kû bàkà nèté ta ndú bà gbèe to nô. Wò delè bà giì zèè kpolo ma a ngê bà zò i ta bà njù pe ta ndâ wú-pe. ");
INSERT INTO ndz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Vò bòò tí nò bà gu a ndiì ta bà gì gba. ");
INSERT INTO ndz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bìndi  yí bà giì ꞌde tí wó kû wa gbí ta bà ꞌvìì tì wó gbí séꞌi á mì ndú ta ndâ mbe nambeè-ṛo.» ");
INSERT INTO ndz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ta o tí nò Jézù giì lòkòꞌbò có ji ndâ mbe tala có mì wó, máa, «Ndâ ŋa ndâ ꞌduù tí nó náa, Gba-gbíṛì kû zogo ndú nó go ndâ ꞌbí ꞌvinî muuꞌbì mbe kaa ꞌdo ꞌbá mì ndú ya tacó bà ŋò ꞌbí ꞌdakò náa à kû ko niì mì wó gí ꞌbá. ");
INSERT INTO ndz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ndâ ꞌbí ꞌduù vô ꞌdo gbí òkò tí ndâ ꞌvinî tí nò giì dù a ndâ mbe koṛo có. Káa muu tí sè ndâ ꞌbí ka ndú ŋìnó vô nó wálá. ");
INSERT INTO ndz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ndâ ꞌvinî ŋìnó mbe ni bà koṛo có lá nò giì ṛuka i tacó bà tù ta wu tacó bà ŋò ta gbíṛo mbe kû kò niì nó ká ṛuka. ");
INSERT INTO ndz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Káa ndâ ꞌbí ka ndú ŋìnó vô ta muu kuu tí ndú nó giì kaa ndâ ꞌbí i bà tù wu gítí bà-i-mì-i. ");
INSERT INTO ndz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ndú mâ giì yee tí ꞌbá tí nó náa à kû ko niì gítí  nó, ndú giì ꞌde ndâ ꞌduù kû ù bà gì mbe kû kò niì. Ndâ ꞌduù dù kpòò, káa yí gì lá. Bìndi  ndú giì mìì ꞌdáá ta ṛì gî. ");
INSERT INTO ndz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","O mâ giì gbooko gî, ndú bà giì gundiì ꞌdo tí ṛì ta kòcò ꞌbí ꞌduù kû gbà ndú, máa, ‹Mbe kò ngú niì yee gî! Yo ya gí kùṛo wó!› ");
INSERT INTO ndz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«Ndâ ꞌvinî tí nò mâ giì ziya, ndú giì ꞌde ndâ i bà tù wu mì ndú doo cee gî. Bìndi  ndâ ꞌvinî ŋìnó vô ta muu tí ndú nó giì ꞌbìtà bà òlò wu mítí ndâ ꞌbí i bà tù wu ŋìnó náa ndú kùtàá kaa gítí có bà-i-mì-i nô. ");
INSERT INTO ndz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ndâ ꞌbí ka ndú ŋìnó tí ndâ mbe ŋónókó mbe gì ta ndâ ꞌbí i bà tù wu lá nó mâ giì yù ndâ ꞌbí i bà tù wu ꞌdo tí ndú, máa, ‹Yo ṛuka ndâ ꞌbí i bà tù wu ji ze náa ndâ ŋìndi ze doo cee gî nò,› ");
INSERT INTO ndz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ndú bà-i-nò giì ꞌvìsì có ji ndú máa, ‹Yo ya gí bà pà ꞌdo kèꞌbî, tacó ndâ ŋìnó mì ze nó bà tè ta ndoo wálá!› ");
INSERT INTO ndz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Ndâ mbe ŋónókó tí nò mâ giì ya wê-wê gí bà pà ndâ i bà tù wu, ndú mâ giì dele ndi ndú á ꞌdo kà, ndú giì ꞌde ndâ ꞌduù ŋìnó kùtàá mbe ꞌviindi tí ndú sàà gî nó kaa ya gí tàꞌi ta ndâ mbe kû kò niì gî. ");
INSERT INTO ndz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ndú mâ giì gbà njekèjì ta bà tèꞌé máa, ‹Njaanga njekèjì ji ze, Buù! Njaanga njekèjì ji ze, Buù!› ");
INSERT INTO ndz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ꞌDakò tí nò náa à kû ko niì mì wó nò giì ꞌvìsì có ji ndú máa, ‹Ye kû ꞌdè có ji yo ta yúcó máa, «Ye ŋò yo ni lá.» › ");
INSERT INTO ndz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Ye cè cè tiṛì tí nò ji yo tacó wàa yo ꞌví kpolo ta tí yo, tacó o bà gì ꞌViì-mì-ꞌDakò gí bà zogo ndâ ꞌduù muu to tí nó ꞌdáá gî wúnò bà dù go énò. Yo bà gu káa ndiì tí .» ");
INSERT INTO ndz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jézù giì lòkòꞌbò có ji ndâ mbe tala có mì wó máa, «Ta o tí nò wúnò náa ꞌViì-mì-ꞌDakò bà gì gí bà zogo ndâ ꞌduù muu to tí nó ꞌdáá gî nó, yí bà bàkà i go i mì ꞌbí ꞌdakò mbe kû ya gí muu nó. Bìndi  yí giì njèè njì ŋa ji ndâ bòò mì wó ꞌvii ta wotí mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yí giì wele njì ŋa ji ꞌduù ŋìnó ta wotí nèté tí wó ngé ma nó ta ꞌvisî vô. Yí giì wele ji ŋìnó ta wotí nèté tí wó gàà-gàà nó ta ꞌvisî sósòꞌô, bìndi  yí giì wele ꞌvisî gbaànjé ji ꞌduù ŋìnó ta wotí mì wó mbe me njíꞌdí nô. Bìndi  yí giì ya ta nó mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","«Bòò tí nó náa mbe tí ndú wele njì ŋa ji yí ta ꞌvisî vô nó giì da i, bìndi  yí giì yili ta ndâ bagà vô. ");
INSERT INTO ndz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ŋìnó náa mbe tí ndú wele njì ŋa ji yí ta ꞌvisî sósòꞌô nó giì da i, bìndi  yí giì yili ta ndâ bagà sósòꞌô. ");
INSERT INTO ndz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Káa ꞌduù ŋìnó náa mbe tí ndú wele njì ŋa ji yí ta ꞌvisî gbaànjé nó, giì cu gboko, bìndi  yí giì yili ta gbèe ꞌvisî ŋa tí nò le mí ṛo wu. ");
INSERT INTO ndz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«ꞌDakò tí nò mâ giì dele ndi wó ꞌdo muu nó bìndi gbolò o, yí giì ꞌvee ndâ bòò mì wó gítí ŋa i ŋìnó náa ndú bàkà ta njì ŋa mì wó náa yí njèè ji ndú á kùṛo o bà njè nó mì wó ꞌdo ꞌbá nô. ");
INSERT INTO ndz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bìndi  bòò mì wó náa yí wele njì ŋa ta ꞌvisî vô ji yí nó, giì tùbà ndâ bagà tí nó náa yí yili ndú vô nó ji mbe tí wó, máa, ‹Ŋìnó a ndâ i gbí nèté tí nó táánò náa wò si ji ye nô, mbe tí ye.› ");
INSERT INTO ndz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","«Bìndi  ꞌdakò tí nò giì ꞌvìsì có ji bòò mì wó nò, máa, ‹Wò bàkà nìkì ngé! Wò a tó bòò mbe zèè nèté mì lo ta njembí lo gbaànjé. Wó kpolo tí làmbu njì ŋa tí nó táánò náa ye wele ji wò nó ta njembí lo gbaànjé. Má énò, ye bà je ꞌbí i mbe me gbolò ndii ŋìnò gî ji wò, wàa wò ꞌví kpolo tí . Gì gí bà dù gbí líkíꞌo á ꞌbá mì mbe tí lo.› ");
INSERT INTO ndz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Bòò ŋìnó náa yí táánò wele ꞌvisî ŋa ji yí sósòꞌô nó giì tùbà ndâ bagà tí nó náa yí yili ndú sósòꞌô nó ji mbe tí wó, máa, ‹À sósòꞌô nó a ndâ bagà náa ye yili ꞌdo gbí ndâ ꞌvisî tí nó sósòꞌô náa wò táánò wele ji ye nô, mbe tí ye.› ");
INSERT INTO ndz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","«Mbe tí wó bà-i-nò giì ꞌvìsì có ji yí ta líkíꞌo, máa, ‹Wò bàkà nèté nìkì ma! Wò a tó bòò ta njembí lo gítí nèté mì lo ká gbaànjé. Wò ni bà kpolo tí làmbu i ta njembí lo gbaànjé gî. Má énò, ye bà je wò tí mbe kpolo tí ꞌbí i mbe me gbolò ndii ŋìnò gî. Gì gí bà dù gbí líkíꞌo á ꞌbá mì mbe tí lo.› ");
INSERT INTO ndz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Bìndi  bòò ŋìnó náa yí táánò wele ꞌvisî ŋa gbaànjé ji yí nó giì le gboko gbèe ꞌvisî ŋa mì wó náa yí kpolo tí  nó gì tí  ji yí, máa, ‹À nô, Buù! Ye ꞌdi a tàwo lo, máa wò a cèe vò ꞌduù, ta yê ṛo ꞌduù tí lo gbaànjé wálá. Nèté mì lo káa bà njèè njì ŋa ji ndâ ꞌduù wàa ndú ꞌví kû da ta i ji wò. À delè káa ndâ ꞌduù ká kû taa kánjí gbí i tacó bà te gì tí  gí gbí gálá mì lo. ");
INSERT INTO ndz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tacó énò, gúku bà gàà tí njì ŋa mì lo giì kpo ye gî. Ŋìnó a yí  náa ye kpónó le gì tí  ji wò nô.› ");
INSERT INTO ndz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Káa ꞌdakò tí nò giì ꞌvìsì có ji bòò mì wó nò ta kpo tàkòcò máa, ‹Wò a vò bòò, tí mbe kpó! Wò táánò má ŋò ni gî máa, à káa ndâ ꞌduù ká kû ji i ji ye, à delè káa ndâ ꞌduù ká kû kili i ꞌdo gbí njí gí ꞌbá ji ye, ");
INSERT INTO ndz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","wò táánò lì ꞌbì lo gí tà njì ŋa mì ye tacó yè? Wò táánò má je ji ꞌbí ꞌduù wàa yí ꞌví ji ji ye, ye wálá kpónó ꞌde ꞌbí i gbí  gî?› ");
INSERT INTO ndz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yí bà-i-nò giì te gboko tí nò ꞌdo tí vò bòò tí nó, bìndi  yí giì je ji mbe yili bagà vô ꞌdo gbí ꞌvisî njì ŋa vô nô. ");
INSERT INTO ndz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tacó i má kuu mì ꞌduù, à kû je ꞌbí  ji yí á mí pí , tacó wàa yí ꞌví dù tí gbolò mbe i. Káa i má mì ꞌduù wálá, àá bà je làmbu ŋìnó náa à kuu mì wó nó ꞌdo tí wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Káa à má gítí bòò tí nó ta i gbí wó wálá nó, à ꞌví ꞌva yí gí gbí ꞌdíꞌdiꞌo tí bàndò bà ŋò gàzâ.» ");
INSERT INTO ndz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jézù giì ꞌdè ꞌbí có kákáꞌi ji ndâ mbe tala có mì wó, máa, «Ta o tí nó wúnò náa ndâ basìlì bà ko ꞌViì-mì-ꞌDakò tí gba ꞌdo gbíṛì gì tí  gí pí jàlàmbà mì wó nó, ");
INSERT INTO ndz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ndâ ꞌduù muu to tí nó ꞌdáá gî bà kili mí kùṛo wó, bìndi  yí bà giì njèè gbí òkò tí ndú go bà pì gbí cû mì niì. ");
INSERT INTO ndz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yí bà giì mò ndâ ꞌduù ŋìnó tí ndâ tó ꞌduù go cèe njì cû nó gí gbí kùꞌbì mì wó, bìndi  ndâ ꞌduù ŋìnó ta gbí ndú wálá go póṛó cû nó gí gbí gàlì mì wó. ");
INSERT INTO ndz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Bìndi  yí tí ꞌViì-mì-ꞌDakò tí Gbolò gba bà giì ꞌdè có ji ndâ ꞌduù ŋìnó gbí kùꞌbì mì wó nó máa, ‹Bu ye cù ꞌdê ngo cù wó mítí yo gî! Yo gì gí bà zèè ꞌbá tí nó náa à ꞌviindi  ù ta ndi yo ꞌdo tí o bà ꞌbìtà bà suu to tí nó, nô. ");
INSERT INTO ndz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tacó ye táánò ta go tí ye, bìndi  yo giì je i-zó-zò ji ye gî; ye táánò ta go ngo tí ye, bìndi  yo giì cu ngo ji ye gî; ye táánò ꞌdó-ꞌdo, bìndi  yo giì te wiṛi mítí ye gî; ");
INSERT INTO ndz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ye táánò ta só, bìndi  yo giì je bòngo ji ye gî; ye táánò ta séꞌi tí ye, bìndi  yo giì pò ye gî; ye táánò gbí zàà, bìndi  yo giì ya gí bà ŋò ye gî.› ");
INSERT INTO ndz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Bìndi  ndâ tó ꞌduù bà giì ꞌvee yí máa, ‹Ze táánò je i-zó-zò ji wò si wò ta go tí lo ta o ngàyi, Mbe tí ze? Ze táánò je ngo ji wò si wò ta go ngo tí lo ta o ngàyi? ");
INSERT INTO ndz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ze táánò ŋò wò tí mbe ꞌdó-ꞌdo bìndi  ze giì te wiṛi mítí lo ta o ngàyi? ");
INSERT INTO ndz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ze ya gí bà ŋò wò si wò ta séꞌi tí lo ta o ngàyi? Ze ya gí bà ŋò wò si wò gbí zàà ta o ngàyi?› ");
INSERT INTO ndz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Bìndi  Gbolò gba bà giì ꞌvìsì có ji ndú máa, ‹Ta ndâ o tí nó ꞌdáá táánò náa yo kû bàkà ndâ i tí nò, kpêtí ká ji ꞌbí zéꞌvéṛè ꞌduù gbaànjé ta gbí wó ngé gî wálá á gbí òkò tí ndâ náꞌvindí ye nó, yo kû bàkà nò a i ji ye.› ");
INSERT INTO ndz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Bìndi  yí bà giì ꞌdè có ji ndâ ꞌduù ŋìnó gbí gàlì mì wó nó máa, ‹Yo co ꞌdo tí ye gî, tacó Mbíṛì ì njà mítí yo gî! Yo ya gí gbí wu tí nó jé mbe mee lá náa Mbíṛì táánò òlò ù ta ndi ndâ Gba-vò-i ta ndâ basìlì mì wó nô. ");
INSERT INTO ndz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tacó ye táánò ta go tí ye, káa yo jé je i-zó-zò ji ye lá; ye táánò ta go ngo tí ye, káa yo je ngo ji ye lá; ");
INSERT INTO ndz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ye táánò ꞌdó-ꞌdo, káa yo te wiṛi mítí ye lá; ye táánò ta só, káa yo je bòngo ji ye lá; ta o tí nó táánò náa ye ta séꞌi tí ye nó, yo ya gí bà ŋò ye lá; yo delè ya gí bà ŋò ye gbí zàà lá.› ");
INSERT INTO ndz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Bìndi  ndú bà giì ꞌvee yí máa, ‹Ze ŋò wò ta go tí lo ta o ngàyi káa ze je i-zó-zò ji wò lá, Mbe tí ze? Ze biya bà konì wò si wò táánò ta go ngo tí lo, si wò ꞌdó-ꞌdo, si wò ta só, si wò ta séꞌi tí lo, si wò gbí zàà, ta o ngàyi?› ");
INSERT INTO ndz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Bìndi  yí bà giì ꞌvìsì có ji ndú máa, ‹Ye kû ꞌdè có ji yo ta njembí ye gbaànjé énó máa, yo má bàkà ndâ i tí nò ji ꞌbí táángbà ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ náꞌvindí ye tí nó á kuu nó, nó gî, gbí  énó máa, yo bàkà nò a i ji ye.› ");
INSERT INTO ndz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«À ngbé nò a bà ꞌvaka ndâ vò ꞌduù gí tà wu ŋìnó mbe mee lá ká kpòò ya tí  nô. Bìndi  ndâ tó ꞌduù bà ꞌde ꞌválá ŋìnó mbe cee lá nô.» ");
INSERT INTO ndz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jézù mâ giì cee ta bà nìbà ndâ i ji ndâ mbe tala có mì wó gî, yí giì ꞌdè có ji ndú máa, ");
INSERT INTO ndz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Yo ŋò ni gî máa, sè sili kpónó ká sósòꞌô gítí gbolò o bà waa mbelè mì ndoo tí ndâ Jùdéyà tacó bà mèlè ndi tàkìì bà njè nó mì ndâ ká gù ndoo ꞌdo Másìrì. À delè nò a sè sili gítí bà je ꞌViì-mì-ꞌDakò ji ndâ tende ꞌduù tacó bà gbì yí mítí njèèkpè mû.» ");
INSERT INTO ndz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Káa ta gbèe o tí nò náa Jézù kû ꞌdè ta có gítí bà giì gbì yí mítí njèèkpè mû ji ndâ mbe tala có mì wó nò, ndâ kpo ꞌduù mì ndâ Jùdéyà kili mí ꞌbá mì Kàyífà tí Kùṛo ndâ bu-Mbíṛì, ");
INSERT INTO ndz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","kû toko có gítí bà zèè Jézù á tàbèngìì, wàa à ꞌví zi yí gî. ");
INSERT INTO ndz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ndú ta o tí nò giì eṛe gba có mì ndú gbaànjé énó máa, ndâ yì ꞌví zèè yí me ta ṛi mì gbolò o lá, tacó ndâ ꞌduù bà tanga i. ");
INSERT INTO ndz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jézù ta o tí nò kuu ꞌbá mì ꞌbí ꞌdakò ta ṛè wó a Sìmónè ta ṛè ꞌviya mì wó a «Mbe cì» gbí gbata Bètánìyà. ");
INSERT INTO ndz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mâ giì zekeꞌo, ꞌbí niì giì gì ta banga pó bàà náa yí sì ta i me gbolò, gbí banga káꞌi-bàà náa à bàkà ꞌdo tí ꞌbí ŋa duù ta có  kpóló-kpolo, bìndi  yí giì yee bàà tí nò ꞌdáá gî mítí muu Jézù si yí kû zò i. ");
INSERT INTO ndz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ndâ mbe tala có mì Jézù mâ giì ŋò ŋa gbolò pó bàà tí nò náa niì tí nò yee ꞌdáá mítí muu Jézù nò, ndú giì ꞌbìtà bà ꞌdè có ta kpo-tàkòcò, máa, «Ŋìnò a ŋa bà volo i yè ká nò? ");
INSERT INTO ndz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Àá kùtàá bà sì pó bàà tí nò ta i me gbolò, wàa à ꞌví ko ta ndâ mbe yê!» ");
INSERT INTO ndz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jézù mâ giì ꞌdi có mì ndâ mbe tala có mì wó nò, yí giì ꞌvìsì có ji ndú, máa, «Niì tí nò bàkà ji yo a cèe tó i, káa yo kû pèè mbí wó tacó yè? ");
INSERT INTO ndz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ndâ mbe yê ta o ꞌdáá gî bà dù kuu ta yo. Káa ye bà dù ta yo me ta o ꞌdáá gî lá. ");
INSERT INTO ndz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Niì tí nò yee bàà tí nò mítí ye tacó bà ꞌviindi ye kû ù ta bà giì duu ye. ");
INSERT INTO ndz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ye kû ꞌdè có ji yo ta yúcó máa, tàwo i tí nó náa niì tí nó bàkà nó bà cee wálá. Tacó bàndò tí nó náa à má ma Banga-Ngú-Có mítí  gî nó, à delè bà dìtà ŋa i tí nó náa yí bàkà nó gî.» ");
INSERT INTO ndz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bìndi  ꞌbí mbe tala có mì Jézù gbaànjé, ta ṛè wó a Júdà Ìsìkàrìyótè, bà-i-nò giì ya gí mì ndâ Kùṛo ndâ bu-Mbíṛì, ");
INSERT INTO ndz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","bìndi  yí giì ꞌvee ndú, máa, «Ye má pà kpokèjì gítí bà zèè Jézù ji yo, yo bà je ji ye a yè?» Ndâ Kùṛo ndâ bu-Mbíṛì bà-i-nò giì ꞌvìsì có ji yí ta bà ꞌdeke njì fádà ziꞌduù-gbaànjé-nje muuꞌbì ji yí. ");
INSERT INTO ndz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Júdà mâ giì kaa gùrúsù ꞌdo mì ndâ Kùṛo ndâ bu-Mbíṛì gî, yí ngé giì ꞌbìtà bà pà tó o ta tó kpokèjì gítí bà zèè Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ta kpédélé ṛi mì gbolò o bà bàkà tàkìì bà ci ꞌDê-kô náa à bàkà ꞌdo tí ꞌdê njú kô, ndâ mbe tala có mì Jézù giì ꞌvee yí, máa, «Có mì lo máa, ndoo ꞌví zò i-cí-ci tacó bà ꞌdè nìkì maa ji Mbíṛì tacó bà mèlè ndi tàkìì bà njè nó mì ndâ ká gù ndoo ꞌdo Másìrì mí ngò?» ");
INSERT INTO ndz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Yo ya gí mì ꞌdaànó gbí gbata Jèrùzàlémè, bìndi  yo ꞌví ꞌdè có ji yí máa, ‹Mbe nìbà i ji ze máa, o mì yì dooko gî. Má énò, ndâ yì ta ndâ mbe tala có mì yì bà gì gí bà zò i-cí-ci mí ꞌbá mì lo.› » ");
INSERT INTO ndz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ndâ mbe tala có mì Jézù bà-i-nò giì ya gí gbí gbata, bìndi  ndú giì bàkà i-cí-ci tacó bà ꞌdè nìkì maa ji Mbíṛì gítí o bà njè nó mì ndâ ká gù ndâ Jùdéyà ꞌdo Másìrì. ");
INSERT INTO ndz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Káa ta ꞌdêꞌo, si ndâ Jézù ta ndâ mbe tala có mì wó muuꞌbì-nje só kû zò i-cí-ci, ");
INSERT INTO ndz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jézù giì ꞌdè có ji ndú, máa, «Ye kû ꞌdè có ji yo máa, ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí yo wúnó bà ba ngbù ye ji ndâ kpo ꞌduù mì ndâ Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Có tí nò náa Jézù ꞌdè nò giì zèè tí ndâ mbe tala có mì wó ngé ndii gî. Bìndi  ndú ta bà muu ndú nò ꞌdáá gî, giì ꞌbìtà bà ꞌvee yí gbaànjé-gbaànjé, máa, «Àá bà dù a ye, Mbe tí ye?» «Àá bà dù a ye, Mbe tí ye?» ");
INSERT INTO ndz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Káa yí giì ꞌvìsì có ji ndú, máa, «ꞌBí ꞌduù náa ze toko ꞌbì ze mí gbí gbèe káꞌi i-zó-zò ta yí gî bà giì ba ngbù ye. ");
INSERT INTO ndz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ꞌViì-mì-ꞌDakò bà ya gí nje ku mì wó go có tí nó náa à cu mí gbí wáràgà mì Mbíṛì nó gî. Káa tende i bà giì ꞌde a ꞌduù tí nò mbe ba ngbù ꞌViì-mì-ꞌDakò nô! Àá táánò nìkì káa bà jò ꞌduù tí nò lá.» ");
INSERT INTO ndz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Júdà tí mbe ba ngbù Jézù mâ giì ꞌdi có mì wó náa yí ꞌdè gítí mbe kû giì ba ngbù wó nò, yí giì ꞌvee yí, máa, «Wò kû nì me ye lá, Mbe nìbà i?» Káa Jézù giì ꞌvìsì có ji yí, máa, «A wò ká kû ꞌdè ta nje lo máa, à me wò lá.» ");
INSERT INTO ndz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Si ndâ Jézù ta ndâ mbe tala có mì wó kû zò i-cí-ci, yí giì je kù kô, bìndi  yí giì ꞌdè nìkì maa ji Mbíṛì, bìndi  yí giì kiꞌviki gbí kù kô tí nò, bìndi  yí giì kaa ji ndâ mbe tala có mì wó, bìndi  yí giì ꞌdè có ji ndú, máa, «Yo kaa , wàa yo ꞌví zò . Ŋìnó a dìì ye.» ");
INSERT INTO ndz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bìndi  yí giì te ꞌvisî nèbítì, bìndi  yí giì ꞌdè nìkì maa ji Mbíṛì, bìndi  yí giì je ji ndú, máa, «Yo ꞌdáá gî njù ");
INSERT INTO ndz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ŋìnó a mbelè ye tí nó náa Mbíṛì bà giì njù ta ngú mùká ta ndâ ꞌduù nô. Mbelè ye tí nó bà giì yee to tacó tí ndâ ꞌduù me mbè. Tacó wàa, Mbíṛì ꞌví je ta à-cee-gî gítí ndâ vò i mì ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yo te mí gbí muu yo máa, ye kákáꞌi bà njù nèbítì tí nó ta yo wálá, yee tí o bà giì njù  mì ndoo ta ndoo ta o bà zogo to tí nó mì Bu ye.» ");
INSERT INTO ndz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì cè cè ta bà be ṛè Mbíṛì bìndi bà zò i-cí-ci gî, ndú giì njè nó tacó bà ya gítí Gú Mbâ. ");
INSERT INTO ndz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Káa si ndú kpokèjì Jézù giì ꞌdè có ji ndú, máa, «Yo wúnó ta bèbìlì tí nó bà oloko ꞌdo tí ye ꞌdáá gî. Tacó à cu mí gbí wáràgà mì Mbíṛì énó máa, ‹Ye bà giì zi mbe gbà bee, bìndi  ndâ rómbo bà giì ꞌvaaka gî.› ");
INSERT INTO ndz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Káa ye bà ya gí kùṛo gí bà ù ndi yo mí Gàlìléyà á bìndi bà ꞌvala ndi ye ꞌdo gbí muuꞌdú ye.» ");
INSERT INTO ndz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Káa Pìyétòrò giì ꞌvìsì có ji Jézù, máa, «Kpêtí sè ndâ ꞌbí ka ye ꞌdáá gî má bà oloko ꞌdo tí lo, ye ta bà miṛi ye jé gí bà o ꞌdo tí lo wálá.» ");
INSERT INTO ndz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Káa Jézù giì ꞌvìsì có ji Pìyétòrò, máa, «Ye kû ꞌdè có ji wò ta yúcó máa, kùṛo bà kò kò mì ngùù ta bà  taꞌô ta nje yé wúnó, wò bà ꞌboo ye ta bà  taꞌô delè.» ");
INSERT INTO ndz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pìyétòrò á bìndi ŋìnò giì ꞌvìsì có ji Jézù, máa, «Ye jé gítí bà ꞌboo wò wálá. À kpêtí má káa ku, à nìkì káa bà cì ndà só ndúkú gî.» Sè ndâ ꞌbí ka Pìyétòrò ꞌdáá gî giì ꞌdè káa gbèe ŋa có mì Pìyétòrò nò ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Káa si ndâ Jézù ta ndâ mbe tala có mì wó kû ꞌdo Gú Mbâ, Jézù giì ne ta ndú gítí ꞌbí wúngbó jìlì mbâ náa à kû nì mítí  a Jètìsèmánè, náa à ṛò njíꞌdí gí to tàgbà gú. Bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Yo ki tí yo to bà-i-nô, wàa ye ꞌví yèè gí zó gí bà ꞌdeke tí ye ji Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yí bà-i-nò giì ꞌdaka ta yí káa ndâ Pìyétòrò ta ndâ ꞌviì mì Zèbìdéyò sósòꞌô. Bìndi  ndú giì co ta ndú gí ndiì ꞌdo gbí òkò tí sè ndâ ꞌbí mbe tala có mì wó. Ndú mâ giì co gí ndiì gî, njembí Jézù giì ꞌbìtà bà mù ta wotí tí . Bìndi  líkíꞌo giì dù káa cee ꞌdo tí wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yí bà-i-nò giì ꞌdè có ji ndâ mbe tala có mì wó taꞌô náa ndú gì ta ndú nó énó máa, «Séꞌi yè gbí njungu ye dê gí mì ku. À má énò, yo dù nô wàa yo ꞌví kpolo tí yo.» ");
INSERT INTO ndz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bìndi  yí giì yèè ndi wó ꞌdo tí ndú gàà gí ndiì, bìndi  yí giì ꞌbu gbíṛo wó mí to, bìndi  yí giì ꞌdeke tí wó ji Mbíṛì énó máa, «Àá Bu ye, kpokèjì gítí bà te ꞌvisî séꞌi tí nó ꞌdo nje ye gî má kuu mì lo, te gî. Káa wò ꞌví te ká ꞌdo gbí ꞌdóó có mì lo gbí njembí lo, me ꞌdo gbí có mì ye lá.» ");
INSERT INTO ndz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jézù mâ giì dele ndi wó ꞌdo bàndò bà ꞌdeke tí wó ji Mbíṛì gí mì ndâ mbe tala có mì wó, yí giì ꞌde ndú taꞌô ꞌdáá mìì ta ṛì gî. Bìndi  yí giì gbà Pìyétòrò gí yaà, yí giì ꞌvee yí, máa, «Bà dù tí zòꞌo ta ye njíꞌdí wàa yo ꞌví ŋò ta ŋa i ŋìnó kèjì nó kpò yo gî? ");
INSERT INTO ndz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yo dù tí zòꞌo, wàa yo ꞌví ꞌdeke tí yo ji Mbíṛì énó máa, ꞌbí i má tala yo, yí ꞌví ꞌde yo tí ndâ ꞌdakò. Ye ŋò ni gî máa, go bà bàkà go có mì Mbíṛì dú kuu gbí njembí yo, káa wotí tí yo gí tàkò  wálá.» ");
INSERT INTO ndz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bìndi bà ꞌdè có ji ndâ Pìyétòrò máa ndú dù tí zòꞌo, wàa ndú ꞌví ꞌdeke tí ndú ji Mbíṛì nò, Jézù giì dele ndi wó kákáꞌi ya gí bà ꞌdeke tí wó ji Mbíṛì énó máa, «À má gbí njembí lo énó máa, ꞌvisî séꞌi tí nó ꞌví tè ká ndúkú ta ye, ye bà njù go có mì lo nó gî, Bu ye.» ");
INSERT INTO ndz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yí mâ giì dele ndi wó ya gí mì ndâ Pìyétòrò kákáꞌi, yí giì ꞌde ndú ꞌdáá taꞌô tí ṛì, tacó bà dù tí zòꞌo kpò ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yí gbí ŋìnò giì dele káa ndi wó jéé gî, si ndú kû tè ṛì, ya gí bà ꞌdeke tí wó ji Mbíṛì ká go ŋa ndâ bà ꞌdeke tí wó ŋìnó kpédéléꞌi kùṛo nô. ");
INSERT INTO ndz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yí mâ giì dele ndi wó, yí giì ꞌde ndâ Pìyétòrò zii ká zii ta ṛì. Bìndi  yí giì gbà ndú, ndú mâ giì ziya gî, yí giì do mítí ndú máa, «Yo kû tè ndi yo a ṛì wàà? Yo tè ṛì wàa yo ꞌví tèwo yo. Káa yo ŋò nô, o bà cu gòmbò tí ꞌViì-mì-ꞌDakò ji ndâ vò ꞌduù kpónó dooko gî. ");
INSERT INTO ndz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yo ŋò mbe cu gòmbò tí ye kèjì zô! Yo a gí yaà wàa ndoo ꞌví ù bà gì yí.» ");
INSERT INTO ndz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Káa si Jézù kû ꞌdè có ji ndâ Pìyétòrò, ndú mâ giì zekeꞌo, ndú giì ŋò Júdà tí ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ mbe tala có mì wó tí Jézù muuꞌbì-nje só nó ta ndâ mbè ꞌduù, náa ndâ kpo ꞌduù mì ndâ Jùdéyà ká tuu ndú tacó bà gì gí giì zèè Jézù yee tí ndú ṛóó-ṛo-ṛò gî, ndâ ꞌbí ꞌduù gbí òkò tí ndú ta kpo sìzò, ndâ ꞌbí  ta ndâ ndòngbòlò mû. ");
INSERT INTO ndz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Káa ta kùṛo bà yee ndâ ꞌduù tí nò, Júdà tí mbe ba ngbù Jézù kpo-gbí-tà-tù ndú sàà gî, máa, «ꞌDuù ŋìnó náa yo bà ŋò ye ꞌvee yí ta bà òlò gbí tù wó nó, a ní Jézù tí nò.» ");
INSERT INTO ndz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tacó énò, ndú mâ giì yee tí Jézù gî, Júdà giì ꞌvee yí ta bà òlò gbí tù wó, máa, «Kútí lo ta ꞌdêꞌo nó ée, Mbe nìbà i?» ");
INSERT INTO ndz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Káa Jézù giì ꞌvìsì có ji yí, máa, «Bàkà nèté mì lo náa wò gì tacó bà bàkà nó gálà, nambe ye!» Ndâ ꞌduù tí nó mbe gì ta Júdà nó mâ giì ꞌdi có mì Jézù nò, ndú giì njè gítí wó, bìndi  ndú giì zèè yí gî. ");
INSERT INTO ndz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Káa ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ mbe tala có mì Jézù taꞌô mbe co ta yí gí ndiì nó mâ giì ŋò énò, yí giì ja sìzò mì wó ꞌdo gbí foko, bìndi  yí giì da ta tù bòò mì Kùṛo ndâ bu-Mbíṛì waa gî. ");
INSERT INTO ndz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Káa Jézù giì ꞌdè có ji mbe tala có mì wó nò, máa, «Dele ta sìzò mì lo nò gí gbí foko mì wó. Tacó ndâ mbe kû te sìzò ꞌdáá gî bà cì káa ku sìzò. ");
INSERT INTO ndz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wò kû koṛo có máa, ye kpónó má ꞌdè có ji Bu ye, máa, yí tuu ndâ basìlì yè to tí nó gî tacó bà kpolo tí ye, yí bà bàkà wálá? ");
INSERT INTO ndz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Káa ye má bàkà énò, wàa có tí nó náa à cu mí gbí wáràgà mì Mbíṛì nó ꞌví dù tí ꞌvéṛè wàà?» ");
INSERT INTO ndz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bìndi  Jézù giì ꞌvee ndâ mbè ꞌduù tí nó náa Júdà kaa ndú gì tí  tacó bà zèè yí nó, máa, «Ye a mbe tè kùṛo vò i wàa yo ꞌví kaa tí  gì gí bà zèè ye ta ndâ kpo sìzò ta ndâ ndòngbòlò mû a ꞌbì yo? Ye ta ṛi ꞌdáá gî kû nìbà i ji ndâ ꞌduù gbí ndùgù ꞌbá-Mbíṛì, káa yo jé zèè ye lá. ");
INSERT INTO ndz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Káa i tí nó kpónó bàkà tí tacó wàa ndâ có mì ndâ mbe ꞌdòkò có mì Mbíṛì náa ndú cu mí gbí wáràgà mì Mbíṛì nó ꞌví dù tí  tí yúcó.» Bìndi  ndâ mbe tala có mì Jézù giì njè ꞌdáá ꞌdo tí wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ndâ ꞌduù tí nò mbe zèè Jézù nò giì ya ta yí gí ꞌbá mì Kàyífà tí Kùṛo ndâ bu-Mbíṛì. Tacó ndâ kpo-kpò mbe nìbà i, ta ndâ kpo-ꞌduù-ꞌbá mì ndâ Jùdéyà kili ta o tí nò ꞌdáá gî mí kà. ");
INSERT INTO ndz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Káa ta o tí nó si ndú kû ya ta Jézù gí ꞌbá mì Kàyífà nó, Pìyétòrò giì dù ꞌdo tí ndú jàngáá gí ndiì kû ko tàkò Jézù gbí ngbà, tacó wàa yí ꞌví ya gí bà ŋò ndòngbú ŋa i ŋìnó náa ndâ ꞌduù tí nò bà bàkà ta yí nô. Ndú mâ giì yee gbí ngbàngà á ꞌbá mì Kàyífà gî, Pìyétòrò giì ya gí bà ki tí wó to mì ndú ta ndâ mbe ù gbí ngbàngà. ");
INSERT INTO ndz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bìndi  ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà giì pà gbí to ꞌvéṛè ngé cee gî, tacó wàa ndâ yì ꞌví ꞌde ta kpokèjì bà waa có ku mítí Jézù, ");
INSERT INTO ndz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","káa à giì kpò ndú ngbàà gî. Sè ndâ ꞌbí cèe ꞌduù giì waaka bà ŋa ꞌvéṛè ŋìndi ndú, káa à delè dí bà  ká lá. Ndâ ꞌbí ꞌdakò sósòꞌô bà-i-nò giì oloko gí kùṛo ndâ ꞌduù, bìndi  ndú giì ꞌdè có, máa, ");
INSERT INTO ndz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Ze táánò ꞌde ꞌdakò tí nó kuu nó kû ꞌdè có ji ndâ ꞌduù máa, yì bà kiꞌviki gbolò ꞌbá-Mbíṛì tí nó á gbí gbata Jèrùzàlémè nó gí to, wàa yì ꞌví bì ndí  gí yaà gbí sili taꞌô.» ");
INSERT INTO ndz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kàyífà tí Kùṛo ndâ bu-Mbíṛì mâ giì ꞌdi có mì ndâ ꞌdakò tí nò, yí giì a gí yaà ꞌdo pí jàlàmbà mì wó, bìndi  yí giì ꞌvee Jézù, máa, «Có mì lo gí tàkò có tí nò náa ndâ ꞌdakò tí nò ꞌdè gítí lo nò wálá?» ");
INSERT INTO ndz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Káa Jézù giì njaa nje wó gí tàkò ꞌvé mì Kàyífà nò gbaànjé lá. Bìndi  Kàyífà giì ꞌvee yí ta ꞌbí ꞌvé, máa, «Ye kû be ji wò a tí Mbíṛì tí nó tí wu Mbíṛì nô, ꞌdè ji ze gi, wò a Bìndi-Mbíṛì tí nó tí ꞌViì-mì-Mbíṛì?» ");
INSERT INTO ndz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Káa Jézù giì ꞌvìsì có ji Kàyífà, máa, «A wò ká ꞌdè ta nje lo. Káa yo dele kpónó-kpónó bà giì ŋò ꞌViì-mì-ꞌDakò kû ki tí wó gbí kùꞌbì mì Mbíṛì tí mbe wotí, bìndi  yí bà giì gì ꞌdo gbíṛì co gbí ndâ kùlù mù gí muu to tí nô.» ");
INSERT INTO ndz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kàyífà mâ giì ꞌdi có mì Jézù nò, yí giì yaka gbí bòngo ꞌdo tí wó ta sé có gî, máa, Jézù ꞌdè zu có gítí Mbíṛì gî. Bìndi  yí giì ꞌvee ndâ kpo ꞌduù gbí ngbàngà mì ndâ Jùdéyà, máa, «Yo kpónó ꞌdi nò a bà ꞌdè zu có mì wó gítí Mbíṛì ta tù yo gî. Má énò, ndoo kpòò kû ù a ndi ndâ ꞌdi, máa ndú ká ꞌví giì ꞌdè ndi ndâ có gbí nje wó ji ndoo? ");
INSERT INTO ndz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Có gbí muu yo kpónó máa yè?» Káa ndú giì ꞌvìsì có ji Kàyífà, máa, «À ꞌvii ta yí káa ku.» ");
INSERT INTO ndz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bìndi  ndú giì njè gítí Jézù ta ba cù cù mí gbíṛo wó, ta bà dòmò yí, ta bà gbì yí, ");
INSERT INTO ndz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta ba lè yí, máa, «Nì ṛè ndâ mbe kû gbì wò ji ze gi, Bìndi-Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ta o tí nó náa ndâ ꞌduù tí nò kû mèèkè ta i tí Jézù mí kùṛo Kàyífà nò, Pìyétòrò kû ki tí wó to á gbí ngbàngà sè. Mâ giì zekeꞌo, ꞌbí niì mbe kû bàkà nèté gbí ngbàngà giì gì gí mì Pìyétòrò, bìndi  yí giì ꞌdè có ji yí, máa, «Wò delè táánò kû dù ta Jézù tí nó tí ꞌduù Gàlìléyà nô.» ");
INSERT INTO ndz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Káa Pìyétòrò giì tò kponje si mí kùṛo ndâ ꞌduù ꞌdáá gî, máa, «Ye ꞌdi gbí ŋa có mì lo náa wò kû ꞌdè ji ye nò lá.» ");
INSERT INTO ndz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pìyétòrò mâ giì co gí njekèjì ndùgù, ꞌbí ꞌvinî mbe kû bàkà nèté ꞌbá mì Kàyífà mâ giì ŋò yí, yí giì ꞌdè có ji ndâ ꞌduù ŋìnó mbe kû ṛò tíyò á ṛègbà tí wó nó, máa, «Yí táánò kû dù a i mì Jézù tí nó mbe ꞌdo Názàrètì nô.» ");
INSERT INTO ndz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Káa Pìyétòrò kákáꞌi giì tò kponje gî, ta bà see tí wó, máa, «Ye ŋò ꞌduù tí nò ni lá.» ");
INSERT INTO ndz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ndú mâ giì dù ndì-ndì-ndì énó, ndâ ꞌbí ꞌduù mbe kû ṛò tíyò ta ndâ Pìyétòrò giì gì gí mì Pìyétòrò, bìndi  ndú giì ꞌdè có ji yí, máa, «Wò nó kuu nó a ꞌduù ꞌdo gbí òkò tí ndâ ꞌduù tí nó mbe kû tala có mì Jézù nô, ta kponje gítí  wálá. A cè ŋa bà ꞌde có mì lo ká yù wò gí sè.» ");
INSERT INTO ndz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Káa Pìyétòrò giì see tí wó ta bà gò ku, máa, «Ye ŋò ꞌdakò tí nò ni lá,» ká jé kpóó ꞌvii ta bà kò kò mì ngùù. ");
INSERT INTO ndz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bìndi  mbí Pìyétòrò giì ꞌva tí có tí nó náa Jézù ꞌdè ji yí, máa, «Wò bà ꞌboo ye ta bà  taꞌô á kùṛo bà kò kò mì ngùù» nô. Bìndi  yí giì co ꞌdo gbí òkò tí ndâ ꞌduù gí ndiì, bìndi  yí giì wa gbí ta wotí tí  ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yé mâ giì too gî, ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-ꞌduù-ꞌbá mì ndâ Jùdéyà ꞌdáá gî giì toko có mì ndú máa, à ꞌví waa có ku mítí Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ndú bà-i-nò giì eṛe ꞌbì wó gî, bìndi  ndú giì ya ta yí gí kùṛo Pìlátò tí gbolò ꞌduù mì ndâ Ròmánò. ");
INSERT INTO ndz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Júdà tí mbe ba ngbù Jézù mâ giì ŋò énó máa ndâ kpo ꞌduù mì ndâ Jùdéyà kû giì ya ta Jézù a i gí nje ku, nikalaká giì zèè yí mbi gî. Bìndi  yí giì kaa ndâ njì fádà tí nó ziꞌduù-gbaànjé-nje muuꞌbì náa à kaa ji yí tacó bà ba ngbù Jézù nó ya tí  ji ndâ Kùṛo ndâ bu-Mbíṛì ta ndâ kpo-ꞌduù-ꞌbá mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Bìndi  yí giì ꞌdè có ji ndú gí tàkò  énó máa, «Ye bàkà vò i gî. Ye ba ngbù ꞌduù ŋìnó ta vò i mì wó wálá nó gî.» Káa ndú giì ꞌvìsì có ji yí énó máa, «Sè ŋìnò a ŋìndi lo. ꞌBí có mbe mù njembí ze bà-i-nò wálá.» ");
INSERT INTO ndz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Júdà bà-i-nò giì ya ta ndâ njì fádà tí nò, bìndi  yí giì vaka ndú ꞌdo ꞌbì wó mí tàꞌi tí nó náa à kû kili i-Mbíṛì mítí  nô ta sé có. Bìndi  yí giì lu ya gí bà le tí wó gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Júdà mâ giì lu gî, ndâ Kùṛo ndâ bu-Mbíṛì giì ya gí bà ṛuka ndâ njì fádà tí nó náa yí vaka mí tàꞌi bà kili i-Mbíṛì nó ꞌdo to gî. Ndú ꞌde ndeṛè bà bàkà énò mì ndú énó máa, «À gbí tàkìì mì ndoo tí ndâ Jùdéyà toko ndâ i ŋìnó náa à ꞌde ꞌdo gbí mbelè ꞌduù nó mítí gbèe bàndò ta ndâ i ŋìnó náa à kû gò ji Mbíṛì nó lá.» ");
INSERT INTO ndz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ndú bà-i-nò giì toko có mì ndú, bìndi  ndú giì kaa ndâ njì fádà tí nò, ndú giì sì ta to ꞌdo mì ꞌbí mbe suu káṛà tí bàndò bà duu ku ndâ ꞌduù ŋìnó mbe ꞌdó-ꞌdo nô. ");
INSERT INTO ndz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ŋìnò a ndeṛè bà kpì ṛè to tí nò tí «To gbí mbelè» á yee gbí ṛi tí nó wúnó nó ká nò. ");
INSERT INTO ndz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Có tí nò bàkà tí go có mì Jèrèmíyà tí mbe ꞌdòkò có mì Mbíṛì náa yí ꞌdè sàà gî énó máa, «Ndú kaa gùrúsù tí ndâ njì fádà ziꞌduù-gbaànjé-nje muuꞌbì náa ndâ ꞌbí ꞌduù gbí òkò tí ndú tí ndâ Ìzìrìyélì ká ꞌdeke tí gùrúsù bà sì ꞌduù, ");
INSERT INTO ndz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bìndi  ndú giì kaa gí tàkò to mì mbe suu káṛà, go có tí nó náa Mbíṛì táánò ꞌdè ji ye nô.» ");
INSERT INTO ndz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ndâ kpo ꞌduù mì ndâ Jùdéyà mâ giì yee ta Jézù kùṛo Pìlátò gî, Pìlátò giì ꞌvee Jézù máa, «Wò a gbolò gba mì ndâ Jùdéyà?» Káa Jézù giì ꞌvìsì có ji Pìlátò, máa, «A wò ká ꞌdè énò.» ");
INSERT INTO ndz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ndâ kpo ꞌduù mì ndâ Jùdéyà giì waaka ndâ có gítí wó ji Pìlátò, káa Jézù giì biya bà ꞌvìsì có gí tàkò ndâ có mì ndú nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bìndi  Pìlátò giì ꞌvee yí, máa, «Wò ꞌdi ndâ có mì ndú ꞌdáá náa ndú ꞌvanda ta ṛè lo nò gî. ꞌBí có mì lo tacó bà ꞌvìsì gí tàkò ndú wálá?» ");
INSERT INTO ndz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Káa nje Pìlátò giì ꞌdèè gî, tacó Jézù giì biya bà ꞌvìsì có gí tàkò ndâ có tí nò ꞌdáá gî, gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ꞌBí ŋa i mì Pìlátò ta gbolò o bà waa mbelè mì ndâ Jùdéyà ta ndoò ꞌdáá gî, a bà njaanga ꞌbí ꞌduù mì ndâ Jùdéyà gbaànjé mbe nìkì tí ndú ꞌdo gbí zàà ji ndú, tacó bà peteke tàkòcò ndú. ");
INSERT INTO ndz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Káa ta o bà ya ta Jézù gí kùṛo Pìlátò nò, ꞌbí ŋa vò ꞌdakò ta ṛè wó a Bàrábà kuu gbí zàà. ");
INSERT INTO ndz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ndâ ꞌduù mâ giì kili gî, Pìlátò giì ꞌvee ndú máa, «Có mì yo máa ye njaanga ji yo a ꞌdi? Bàrábà wèè, Jézù tí nó náa à kû nì Bìndi-Mbíṛì mítí wó nó?» ");
INSERT INTO ndz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pìlátò ꞌvee ŋa ꞌvé tí nò tacó yí ŋò ni ngbáṛángàꞌi gî máa, à káa kiì cuki ká a tàmuu ndâ kpo ꞌduù mì ndâ Jùdéyà gítí bà biya Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Káa si Pìlátò kuu gbí ngbàngà, nawù wó giì tuu ꞌduù ji yí énó máa, «Gàà ꞌduù tí nò lá, tacó ye kùbòó mbu muu wó gbí ṛiì ngé ndii gî.» ");
INSERT INTO ndz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Káa ndâ kpo ꞌduù mì ndâ Jùdéyà giì volo muu ndâ ꞌduù énó máa, ndú ꞌdè có ji Pìlátò máa yí njaanga Bàrábà ji ndâ yí, waa yí ꞌví zi Jézù gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Káa Pìlátò giì ꞌvee ndâ Jùdéyà kákáꞌi máa, «À má go có mì yo, máa ye ꞌví njaanga a ꞌdi ji yo ꞌdo gbí òkò tí ndâ ꞌdakò tí nó só nó?» Káa ndú giì ꞌvìsì có ji yí máa, «Bàrábà.» ");
INSERT INTO ndz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bìndi  Pìlátò giì ꞌvee ndú, máa, «Káa ye ꞌví bàkà ta Jézù tí nó náa à kû nì Bìndi-Mbíṛì mítí wó nó a yè?» Káa ndú ꞌdáá gî giì ꞌvìsì có ji yí, máa, «Gbì yí mítí njèèkpè mû.» ");
INSERT INTO ndz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Káa Pìlátò giì ꞌvee ndú máa, «Tacó yè? Yí bàkà a ŋa vò i yè?» Káa ndú ꞌdáá gî giì tò kû ta kòcò ndú gí yaà ndii kpédélé ŋìnó gî, máa, «Gbì yí mítí njèèkpè mû.» ");
INSERT INTO ndz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pìlátò mâ giì ŋò énò máa, yì kû yeeke a tí yì sínò ta bà tì muu Jézù, káa ndâ ꞌduù kû giì ꞌbì a tà bà bàkà wo, yí giì cu ngo, bìndi  yí giì caka ta ꞌbì wó mí kùṛo ndâ mbè ꞌduù tí nò ꞌdáá gî, máa, «Ye caka mbelè tó ꞌdakò tí nò ꞌdo tí ꞌbì ye gî. Sè ŋìnò a ŋìndi yo!» ");
INSERT INTO ndz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Káa ndâ ꞌduù tí nò ꞌdáá gî giì ꞌvìsì có ji Pìlátò, máa, «Si mbelè wó ꞌví dù tí ꞌbì ze ta ndâ ꞌviì bìndi  ze!» ");
INSERT INTO ndz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pìlátò bà-i-nò giì njaa Bàrábà ꞌdo gbí zàà gí sè ji ndâ ꞌduù. Bìndi  yí giì je Jézù ji ndâ àsìkérì, máa ndú gbì yí má kózò gî, wàa ndú ꞌví ya gí bà gbì yí mítí njèèkpè mû. ");
INSERT INTO ndz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ndâ àsìkérì mì Pìlátò bà-i-nò giì ya ta Jézù gítí gbolò bàndò mì ndú ꞌbá mì Pìlátò. Ndú mâ giì kili ꞌdáá gî, ndú giì tì jèlè yí ꞌdee gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bìndi  ndú giì jaka ndâ ꞌdóó bòngo mì wó ꞌdo tí wó gî, ndú giì yuu bí-bi bòngo gba mì ndú tí ndâ àsìkérì ji yí. ");
INSERT INTO ndz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ndú delè giì paṛaka kpeṛè go kéꞌbí nó, ndú giì te mítí muu wó tí tàgíyà-gba, ndú giì je njì ngba mí ꞌbì wó ŋìnó gbí kùꞌbì tí kóṛó-gba mì wó. Bìndi  ndú giì ꞌbìtà bà ꞌviya yí, ta bà kucuku muungbó ndú mí kùṛo wó, kû ꞌvee yí, máa, «Kútí lo ée? Gbolò gba mì ndâ Jùdéyà!» ");
INSERT INTO ndz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bìndi  ndú giì mèèkèꞌi tí wó ta bà cù cù mì gbíṛo wó, delè ta bà ja njì ngba tí nó náa ndú je mì ꞌbì wó tí kóṛó-gba nó ꞌdo ꞌbì wó kû gbì ta yí tí muu wó. ");
INSERT INTO ndz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ndú mâ giì ꞌviya yí tè ta ndú gî, ndú giì ja bí-bi bòngo gba mì ndú náa ndú yuu ji yí nó ꞌdo tí wó gî, bìndi  ndú giì yuu ndi ndâ ꞌdóó bòngo mì wó ji yí. Bìndi  ndú giì ja yí ꞌdo gbí ndùgù gí sè tacó bà ya ta yí gí sè ꞌdo gbí gbata, wàa ndâ yì ꞌví gbì yí mítí njèèkpè mû. ");
INSERT INTO ndz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Káa si ndâ àsìkérì kû giì ya ta Jézù gí bàndò bà gbì yí mítí njèèkpè mû, ndú giì ꞌde ꞌbí ꞌdakò ta ṛè wó a Sìmónè mbe gì ꞌdo gbí gbata Sìrínì kpokèjì, bìndi  ndú giì zèè yí ta wotí gítí bà te njèèkpè mû mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ndú mâ giì yee tí ꞌbí bàndò náa à kû nì mítí  a Gòlìgátà (gbí  máa «bàndò Kù-ꞌbilì-muu-ku»), ");
INSERT INTO ndz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ndú giì je nèbítì náa ndú ŋònòkò ta ju i ji Jézù. Yí mâ giì tala , yí giì bè gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ndâ àsìkérì mâ giì gbì Jézù mítí njèèkpè mû gî, ndú giì njèè gbí ndâ bòngo bìndi wó ta bà ki-mbílì. ");
INSERT INTO ndz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bìndi  ndú giì ki tí ndú to kû ù ṛègbà tí wó. ");
INSERT INTO ndz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ndú giì cu ndeṛè ku wó, bìndi  ndú giì gbì mítí njèèkpè mû á còmuu wó, máa, «Ŋìnó a Jézù tí Gbolò gba mì ndâ Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ndú ta gbèe o tí nò giì gbì ndâ ꞌbí mbe ngbà sósòꞌô mítí ndâ njèèkpè mû, ꞌbí  gbí kùꞌbì, bìndi  ꞌbí  gbí gàlì mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ndâ mbe kû co tí kpokèjì mâ giì ŋò Jézù tí njèèkpè mû, ndú giì mìyà muu ndú ta bà lè yí, ");
INSERT INTO ndz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","máa, «Wò táánò máa wò bà kiꞌviki ꞌbá-Mbíṛì gî, wàa wò ꞌví bì ndí  gbí sili taꞌô. ꞌVala tí lo! Co gí to ꞌdo tí njèèkpè mû, náa wò dú má káa ꞌViì-mì-Mbíṛì nò.» ");
INSERT INTO ndz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ mbe ꞌdi gbí-o, ta ndâ kpo-ꞌduù-ꞌbá mì ndâ Jùdéyà delè giì lè Jézù, máa, ");
INSERT INTO ndz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Yí táánò kû ꞌvala ndâ ꞌbí ꞌduù, káa bà ꞌvala ꞌdóó miṛi wó kpónó kpò yí gî. Ndoo kpónó dù ká jé wàa ndoo ꞌví ŋò bà co Gbolò gba mì ndâ Jùdéyà ꞌdo tí njèèkpè mû gí to, tacó wàa ndoo ꞌví ù ta nje máa yí a Bìndi-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yí kû tee njembí wó mítí Mbíṛì. Má énò, ndoo ŋò bà ꞌvala yí mì Mbíṛì, tacó yí táánò máa, yì a ꞌviì mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ndâ mbe ngbà tí nó náa à gbì ndú mítí ndâ njèèkpè mû ta ndâ Jézù nó giì si ndâ vò i ŋìndi ndú mítí ndú, bìndi  ndú giì loko kû lè Jézù delè. ");
INSERT INTO ndz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Káa si Jézù kuu tí njèèkpè mû, ṛo ṛi giì ꞌdi cèe to ꞌdáá gî ꞌdo tí ṛi gbúrú yee tí ṛi ta-ꞌde-kìyà. ");
INSERT INTO ndz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ṛi mâ giì gì gí ta-ꞌde-kìyà gî, Jézù giì ja kû mí to gbí có Ìbìráyò máa, «Éélì, Éélì, lámà sàbàkìtánì?» (Gbí  máa, «Àá Mbíṛì mì ye, àá Mbíṛì mì ye, wò biya ye tacó yè?») ");
INSERT INTO ndz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ mbe kû ṛò kû zeke Jézù tí njèèkpè mû nó mâ giì ꞌdi kú tí nò, à giì dù gbí tù ndú go ŋìnó máa Jézù kû tè a é tí Èlíjà tí nó táánò tí mbe ꞌdòkò có mì Mbíṛì nô. Bìndi  ndú giì ꞌdè có máa, «ꞌDakò tí nó kû tèꞌé tí Èlíjà.» ");
INSERT INTO ndz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ꞌBí ꞌdakò giì co ta ngèlè ꞌdo gbí òkò tí ndâ ꞌduù tí nò ya gí bà je ꞌbí i fòkò-fòkò énó, yí giì ya gí bà yuu mí gbí zùù-zùù kpongo nèbítì, yí giì sè mí nje njì ngba, bìndi  yí giì ya gí bà te mí nje Jézù, yí giì ꞌdè có ji yí máa, yí no-no . ");
INSERT INTO ndz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Káa ndâ ꞌbí ꞌduù giì ꞌdè có máa, «Ndoo ù bà ŋò bà gì Èlíjà gí bà ꞌvala yí.» ");
INSERT INTO ndz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jézù bà-i-nò giì tò ndòngbú kû ta kòcò wó ngé gí yaà, bìndi  njembí wó giì ki gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mâ giì zekeꞌo, kpâ-bòngo tí nó náa à eṛe mí yaà tacó bà njèè gbí tàꞌi ꞌbá-Mbíṛì nó giì yaka tí ꞌdo yaà dí to, gbí ndâ díí giì baṛaka tí ta bà ngaka tí mì to. ");
INSERT INTO ndz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ndâ muuꞌdú giì baṛaka ŋe-ŋè-ŋe-ŋè. Bìndi  Mbíṛì giì ꞌvala ndâ ꞌbí tó ꞌduù mì wó ŋìnó táánò mbe cì gî nó ꞌdo gbí muuꞌdú ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bìndi  ndú giì ya bìndi bà ꞌvala ndi Jézù ꞌdo gbí muuꞌdú wó gí Jèrùzàlémè. Ndâ ꞌduù me mbè ŋò ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kùṛo ndâ àsìkérì, ta ndâ àsìkérì mì wó náa ndú kû ù ṛègbà tí Jézù ta ndú nó mâ giì ŋò bà ngaka tí mì to, ta i tí nó mbe bàkà tí nó, gúku giì zèè ndú ꞌdáá mbi gî. Bìndi  ndú giì ꞌdè có máa, «ꞌDakò tí nó táánò dú ká ꞌViì mí Mbíṛì!» ");
INSERT INTO ndz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mbè ndâ niì tí nó mbe ko tàkò Jézù ꞌdo Gàlìléyà tacó bà konì yí nó giì ṛò janga-jàngá gí ndiì ézó kû zeke ŋa ndâ ŋa i tí nó náa à me kû ta Jézù nó, ");
INSERT INTO ndz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ta ndâ Màríyà Màdèlénà, ta Màríyà nawu ndâ Jákòmò ta Jùzépè, ta nawu ndâ ꞌviì mì Zèbìdéyò. ");
INSERT INTO ndz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ꞌDêꞌo mâ giì bàkà tí gî, ꞌbí ꞌdakò mbe gì ꞌdo gbí gbata Àrìmàtíyà tí mbe kpo-kpò i, delè tí mbe gì tí mbe tala có mì Jézù gî, ta ṛè wó a Jùzépè, ");
INSERT INTO ndz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","giì ya gí bà ꞌdeke tí wó ji Pìlátò, máa yí bàkà nambeè mì wó, wàa yí ꞌví si yì ꞌví ya gí bà duu ku Jézù. Pìlátò mâ giì ùnje ji yí gî, Pìlátò giì tuu ꞌduù ji kùṛo ndâ àsìkérì mì wó, máa yí si Jùzépè ꞌví te ku Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jùzépè bà-i-nò giì ya gí bà te ku Jézù, yí giì so ta ngbáṛángà cé-ce bòngo, ");
INSERT INTO ndz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","bìndi  yí giì te yí ya tí  gí bà duu mí gbí kánjí ngú gùù náa yí duu mí gbí díí gítí ꞌdóó miṛi wó tí Jùzépè. Yí mâ giì nè njekèjì ꞌbá muuꞌdú ta du díí gî, yí giì njè nó ꞌdo bà-i-nò gî. ");
INSERT INTO ndz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Káa ndâ Màríyà Màdèlénà, ta Màríyà nawu ndâ Jákòmò ta Jùzépè ta o tí nò ki tí ndú ézó kû zeke ꞌbá muuꞌdú. ");
INSERT INTO ndz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ndâ kpo ꞌduù mì ndâ Jùdéyà giì kili mí kùṛo Pìlátò ta yé bìndi bà duu Jézù, ");
INSERT INTO ndz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bìndi  ndú giì ꞌdè có ji yí máa, «Buù, mbi ze ꞌva tí ꞌbí có náa mbe ꞌvéṛè tí nó táánò ꞌdè si yí káa wuù énó máa, yì bà ꞌvala ndi yì ꞌdo gbí muuꞌdú yì bìndi  sili taꞌô. ");
INSERT INTO ndz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Má énò, à nìkì go énó máa, wò kaa ndâ àsìkérì ya gí bà ù ṛègbà muuꞌdú wó yee gbí ndâ sili tí nò. Tacó wò má me énò lá, ndâ mbe tala có mì wó bà giì ya gí bà ngbà ku wó ꞌdo gbí gùù gî, bìndi  ndú bà giì ꞌdè có ji ndâ ꞌduù máa, yí ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî. Káa wotí tí ndòngbú ꞌvéṛè tí nò bà ndii kpédélé ŋìnó gî.» ");
INSERT INTO ndz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Káa Pìlátò giì ꞌvìsì có ji ndú máa, «Yo ya gí bà kaa ndâ àsìkérì wàa ndú ꞌví ù ṛègbà muuꞌdú tí kpoò.» ");
INSERT INTO ndz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ndâ kpo ꞌduù mì ndâ Jùdéyà bà-i-nò giì ya gí bà bàkà ndâ i mítí njekèjì ꞌbá muuꞌdú tacó wàa ꞌduù má njaanga , à ꞌví ŋò ni gî, bìndi  ndú giì kaa ndâ àsìkérì mí gbí nèté bà ù ṛègbà muuꞌdú. ");
INSERT INTO ndz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Si yé kû giì bàkà có bà ngbaṛanga to ta dúꞌo mì kpédélé ṛi nèté á bìndi ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà, ndâ Màríyà Màdèlénà, ta Màríyà nawu ndâ Jákòmò ta Jùzépè giì gboꞌo tacó bà ya gí bà gala muuꞌdú Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Káa à káa póó bà yee ndú kà, to giì ꞌbìtà bà ngaka tí tí vò ŋa ŋìnô. Tacó basìlì mì Mbíṛì gì ꞌdo gbíṛì, yí giì mèṛèkè gbolò díí tí nó náa à nè ta njekèjì ꞌbá muuꞌdú nó gî, bìndi  yí giì ki tí wó pí . ");
INSERT INTO ndz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ndâ niì tí nò mâ giì zekeꞌo, ndú giì ŋo gbíṛo basìlì tí nò kû tòngbaà go bà ì mù nó, ta ndâ bòngo tí wó ce go tuṛê. ");
INSERT INTO ndz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ndâ àsìkérì tí nó náa ndâ kpo ꞌduù mì ndâ Jùdéyà kaa ndú máa ndú ù ṛègbà muuꞌdú nó mâ giì ŋò yí, lilí ndú giì oloko ꞌdo tí ndú gî, bìndi  ndú giì dù kû gu ta gúku goòlá a ꞌboṛò ká nì ndú too yé gî nô. ");
INSERT INTO ndz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Káa basìlì tí nò giì ꞌdè có ji ndâ Màríyà, máa, «Yo cì gúku lá, tacó ye ŋò ni gî máa, yo kû pà a bà tí Jézù tí nó náa à gbì yí mítí njèèkpè mû nô. ");
INSERT INTO ndz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yí bà-i-nó wálá. Yí ꞌvala ndi wó ꞌdo gbí muuꞌdú wó go có mì wó táánò náa yí ꞌdè nó gî. Yo gì gí tàkò ye, wàa yo má ŋò bàndò tí nó táánò náa à sii ku wó mítí  nó ta ṛo yo gî, ");
INSERT INTO ndz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","yo ꞌví goonó ya gí bà ꞌdè có ji ndâ mbe tala có mì wó máa, yí ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî. Káa yí kû ya gí bà ù ndi ndú mí Gàlìléyà. Ndú bà ya gí bà ŋò yí ta ṛo ndú a i kà, go có tí nó náa ye kû ꞌdè ji yo kpónó nô.» ");
INSERT INTO ndz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ndâ niì tí nò giì co ꞌdo tà ꞌbá muuꞌdú kà gí sè ta ngèlè ta gúku ŋònòkò ta líkíꞌo tacó bà ya gí bà ꞌvanda ndi ndâ có tí nò ji ndâ mbe tala có mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Káa Jézù giì tùbà tí wó ji ndú si ndú á kpokèjì, bìndi  yí giì ꞌvee ndú máa, «Kû tí yo ée?» Ndâ niì tí nò bà-i-nò giì ìṛì ta muungbó ndú ta líkíꞌo ya gí bà zèè kò Jézù. ");
INSERT INTO ndz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bìndi  Jézù giì ꞌdè có ji ndú máa, «Yo cì gúku lá, yo ya gí bà ꞌdè có ji ndâ náꞌvindí ye máa, ndú ya gí Gàlìléyà, wàa ndú ꞌví ꞌde ye kà.» ");
INSERT INTO ndz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ndâ Màríyà giì yee mì ndâ mbe tala có mì Jézù si ndâ ꞌbí àsìkérì tí nó náa à kaa ndú máa ndú ù ṛègbà muuꞌdú Jézù nó waa kùṛo ndú ta ngèlè ya gí bà ꞌvanda ndi ndâ i ŋìnó mbe bàkà tí nó ji ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà sàà gî. ");
INSERT INTO ndz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bìndi  ndâ Kùṛo ndâ bu-Mbíṛì bà-i-nò giì kili ndâ kpo-ꞌduù-ꞌbá, ndú giì toko có ta ndú gbaànjé, bìndi  ndú giì too bàà mítí nje ndâ àsìkérì tí nò. ");
INSERT INTO ndz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bìndi  ndú giì ꞌdè có ji ndú máa, «Yo ya gí bà ma có ji ndâ ꞌduù énó máa, ‹Ndâ mbe tala có mì wó ká ngbà ku wó si ze muu ṛì.› ");
INSERT INTO ndz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Káa ŋa có tí nò má yee tí Pìlátò, ze bà ŋò kpokèjì bà mee wu ꞌdo tí  gî.» ");
INSERT INTO ndz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ndâ àsìkérì giì lì ꞌbì ndú mí tà i tí nó náa ndâ kpo ꞌduù mì ndâ Jùdéyà je ji ndú nó gî, bìndi  ndú giì ꞌbìtà bà ma ꞌvéṛè ji ndâ ꞌduù máa, a ndâ mbe tala có mì Jézù ká ngbà ku wó ꞌdo gbí gùù si ndâ yì tí ṛì. Có tí nò máa, a ndâ mbe tala có mì Jézù ká ngbà ku wó nò nanaka mí gbí muu ndâ Jùdéyà tí yúcó yee gbí ṛi tí nó wúnó nô. ");
INSERT INTO ndz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ndâ mbe tala có mì Jézù mâ giì ꞌdi ndâ có tí nó náa ndâ Màríyà ꞌvanda ji ndú nó gî, ndú giì kaa ꞌdo Jèrùzàlémè ya gítí gú tí nó náa Jézù ci ndú máa ndú ya gí bà ꞌde yì tí  á Gàlìléyà nô. ");
INSERT INTO ndz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ndú mâ giì ꞌde Jézù gî, ndú giì ìṛì ta muungbó ndú ya gí kùṛo wó. Káa ndâ ꞌbí ꞌduù gbí òkò tí ndú ùnje ta njembí ndú máa ŋìnò a Jézù nò dúú-dúú lá. ");
INSERT INTO ndz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Káa Jézù giì yèè dê gí mì ndú, bìndi  yí giì ꞌdè có ji ndú máa, «Mbíṛì le bèṛè ji ye tacó bà dù tí Gba-gbíṛì, delè tacó bà dù tí gba muu to tí nó á gî. ");
INSERT INTO ndz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Má énò, yo ya gí bà bàkà ndâ ŋa ndâ ꞌduù muu to tí nó ꞌdáá gî tí ndâ mbe tala có mì ye. Yo caka tí ndú ta ṛè mì Buù, ta ṛè mì ꞌViì, ta ṛè mì Bèṛi-mì-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yo ꞌví nìbà kpokèjì gítí bà ꞌdi ndâ có tí nó náa ye ꞌdè ji yo nó ꞌdáá gî ji ndú. Ye delè bà dù toko ta yo ta o ꞌdáá gî yee tí ndòngbú o.»");
INSERT INTO ndz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ŋìnó a Banga-Ngú-Có gítí Jézù tí Bìndi-Mbíṛì tí ꞌviì mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","À ꞌbìtà go có tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì cu mí gbí wáràgà mì wó sàà kùṛo bà gì Jézù énó máa, Mbíṛì máa, «Ye kèjì gí bà tuu tú mì ye gí kùṛo lo. Yí kèjì gí bà ꞌviindi kpokèjì mì lo. ");
INSERT INTO ndz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tú mì ye nò bà dù gbí kángáá nga ngoò kû kò-kò ji ndâ ꞌduù énó máa, ‹Yo ꞌviindi kpokèjì mì Mbe tí yo. Yo bàkà kpokèjì mì wó jáá,› nô.» ");
INSERT INTO ndz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jòvánì tí mbe caka tí ndâ ꞌduù giì co gí gbí kángáá nga ngoò, kû kò-kò ta có gítí bà caka tí ji ndâ ꞌduù, tacó wàa, ndú ꞌví ꞌvìsì muu ndú ꞌdo tí ndâ vò i mì ndú, wàa Mbíṛì ꞌví je à-cee-gî ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ndâ ꞌduù ꞌdo gbí to Jùdéyà ꞌdáá gî, delè ta ndâ ꞌduù ꞌdo gbí gbata Jèrùzàlémè giì kaa ya gí mì wó á tàbèꞌdè Jòròdánìyà tacó bà caka tí ndú. Káa ta o tí nó náa yí kû caka tí ndú nó, ndú kû yù gbí ndâ vò i mì ndú gí sè. ");
INSERT INTO ndz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jòvánì táánò kû yuu a bòngo náa à gò ꞌdo tí se tí jémèlè. Yí giì eṛe mí ṛèꞌdè wó a wúꞌdè kû. I-zó-zò mì wó káa ndâ kòṛòngbò ta lí. ");
INSERT INTO ndz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jòvánì ma có ji ndâ ꞌduù énò máa, «ꞌBí ꞌduù mbe me gbolò ndii ye gî á kèjì gí tàkò ye, náa à kpêtí káa ndòngbú bòò mì wó mbe kû njaanga tàmà á ꞌdo tí kò wó, ye bà ni bà ꞌvii tí ye ta yí wálá. ");
INSERT INTO ndz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ye kû caka tí yo ta ngo, káa yí kèjì gí bà caka tí yo ta Bèṛi-mì-Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gbí ndâ o tí nò si Jòvánì kû caka tí ndâ ꞌduù tàbèꞌdè Jòròdánìyà nò, Jézù giì njè nó ꞌdo gbí gbata Názàrètì á Gàlìléyà, ya gí bà caka tí wó mì Jòvánì. Jòvánì giì caka tí Jézù mí tà ngo gbí pù Jòròdánìyà. ");
INSERT INTO ndz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Káa Jézù mâ giì co gí sè ꞌdo tà ngo bìndi bà caka tí wó, yí ngé giì ŋò njekèjì gbíṛì njaanga tí gî. Yí delè giì ŋò Bèṛi-mì-Mbíṛì kû gì gí muu wó go kùlè nô. ");
INSERT INTO ndz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bìndi  yí giì ꞌdi kòcò ꞌduù kû ꞌde có ꞌdo gbíṛì énó máa, «Wò a ꞌviì mì ye náa ye ze wò nìkì ta njembí ye gbaànjé. Tàkòcò ye peteke gítí lo ngé ndii gî.» ");
INSERT INTO ndz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ngé ꞌdo bàndò tí nò, Bèṛi-mì-Mbíṛì giì wu tàmuu Jézù ya tí  gí gbí kángáá nga ngoò. ");
INSERT INTO ndz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yí giì dù gbí kángáá nga ngoò ta sili ziꞌduù-só. Bìndi  Vò-ꞌduù-tí-nò giì gì kû tala yí. Yí bàkà ndâ sili tí nò ziꞌduù-só nó ta kpéétí wó gbí òkò tí ndâ kàzà. À káa ndâ basìlì mì Mbíṛì ta o tí nò ká ṛègbà tí wó. ");
INSERT INTO ndz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","À mâ giì zèè Jòvánì mí gbí zàà gî, Jézù giì ya gí Gàlìléyà. Yí giì ma Banga-Ngú-Có mbe gì ꞌdo mì Mbíṛì ji ndâ ꞌduù kà énó máa, ");
INSERT INTO ndz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Nògí! Kùṛo o bà zèè ꞌbá mì Mbíṛì kpónó dooko gî. Yo ꞌvìsì muu yo ꞌdo tí ndâ vò kpokèjì, yo ꞌví ùnje gítí Banga-Ngú-Có.» ");
INSERT INTO ndz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ta ꞌbí o gbaànjé si Jézù kû nò nó á seè kàpá Gàlìléyà, yí giì ŋò ndâ Sìmónè ta náꞌvindí wó Àndèréyà kû ꞌva mbu, tacó ndú a ndâ mbe gò ngo. ");
INSERT INTO ndz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Káa Jézù giì ꞌdè có ji ndú énó máa, «Yo gì gí bà ṛu ndi ye, wàa ye ꞌví bàkà yo tí ndâ mbe gò ndâ ꞌduù ji Mbíṛì á go bà gò ngo mì yo nò.» ");
INSERT INTO ndz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ndâ Sìmónè ta Àndèréyà mâ giì ꞌdi có tí nò náa Jézù ꞌdè ji ndú nò, ndú ngé giì kaa ndâ mbu mì ndú mí to, bìndi  ndú giì ya gí tàkò Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jézù mâ giì yèè gí kùṛo ꞌdo tí bàndò bà ꞌde ndâ Sìmónè ta Àndèréyà nò gàà énó, yí giì ŋò ndâ ꞌbí ꞌdakò sósòꞌô, ndâ Jákòmò ta náꞌvindí wó Jòvánì tí ndâ ꞌviì mì Zèbìdéyò, á gbí gbâ, delè kû eṛe gbí ndâ mbu mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Káa yí ngé giì tèꞌé tí ndú. Bìndi  ndú giì njè nó ya gí tàkò wó, jee bu ndú ta ndâ mbe nèté mì wó mí gbí gbâ. ");
INSERT INTO ndz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bìndi  ndâ Jézù ta ndâ mbe tala có mì wó giì njè nó ya gí gbí gbata Kàpàrànáwùmù. Ta ꞌbí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gbaànjé, yí giì ya gí bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì, bìndi  yí giì ꞌbìtà bà nìbà i ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nje ndâ ꞌduù ꞌdáá gî giì ꞌdèè gítí ŋa bà nìbà i mì wó gî, tacó yí kû nìbà i ji ndú go i mì gba, me go ŋìndi ndâ mbe ꞌdi gbí-o mì ndâ Jùdéyà lá. ");
INSERT INTO ndz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Káa à káa póó bà giì gì ꞌbí ꞌdakò ta i-gbí-muu wó gí bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì ta o tí nò, ");
INSERT INTO ndz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yí giì ꞌbìtà bà tò kû énó máa, «À tí lo a go bà bàkà ŋa yè ta ze, Jézù tí mbe gì ꞌdo Názàrètì? Wò gì tacó bà ꞌbu ŋa ze? Ye ŋò wó ni gî, wò a tó ꞌduù mì Mbíṛì mbe kû toko có ta yí.» ");
INSERT INTO ndz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Káa Jézù giì do mítí i tí nò, máa, «Dù ngbìì! Co ꞌdo gbí muu ꞌdakò tí nò gî!» ");
INSERT INTO ndz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bìndi  vò i tí nò gbí muu ꞌdakò tí nò giì te yí gí yaà, ꞌva mí to, yí giì dù kû gu mí to kà tí vò ŋa ŋìnô. Bìndi  yí giì co ꞌdo gbí muu wó ta bà tò kû ta kòcò wó ngéé gí yaà. ");
INSERT INTO ndz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bà ꞌdè có giì kpo nje ndâ ꞌduù ꞌdáá gî, gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú, máa, «Ŋìnó a ŋa yè ká nó? À ngú ŋa bà nìbà i, ta wotí ká tàkò ? Yí má ꞌdè có kpêtí ká ji ndâ i-gbí-muu ndâ ꞌduù, ndú kû ꞌdi có mì wó.» ");
INSERT INTO ndz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ꞌDo bà-i-nò ṛè Jézù ngé giì ꞌbìtà bà wu cee gbí to Gàlìléyà ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bìndi bà mòkò i tí nò ꞌdo gbí muu ꞌdakò tí nò, ndâ Jézù ngé giì njè nó ꞌdo bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì kû ya ta ndâ Jákòmò ta Jòvánì gí ꞌbá mì ndâ Sìmónè ta Àndèréyà. ");
INSERT INTO ndz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ndú mâ giì yee ꞌbá kà, ndú giì ꞌdè na gê Sìmónè tísì ta côꞌo gbí dìì wó. Ndâ ꞌduù ngé giì ꞌdè có séꞌi tí nò ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bìndi  Jézù giì ṛì gí tàkò niì tí nò tàꞌi, yí giì zèè yí tí ꞌbì wó, yí mâ giì ja yí gí yaà, gbí dìì wó ngé giì ꞌdèè sé gî. Bìndi  yí giì ya gí bà bàkà i-zó-zò ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ta ꞌdêꞌo tí nò, si ṛi kû ya nèè gí to, si o bà wotí gbí tàkìì mì ndâ Jùdéyà cee gî, ndâ ꞌduù giì tuṛu ndâ mbe nòꞌo ꞌdáá gî, ta ndâ ꞌduù ŋìnó ta ndâ i-gbí-muu ndú nó gì tí  ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ndâ ꞌduù me mbè giì tì mí njekèjì tí wó. ");
INSERT INTO ndz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bìndi  yí giì ꞌvala ndâ ꞌduù me mbè ꞌdo gbí ndâ tende ŋa ndâ nòꞌo. Yí delè giì mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù me mbè; káa bà ꞌdè có kpò ndâ i tí nò gî, tacó ndú ŋò Jézù ni gî, káa yí biya gî máa ndú ꞌví ꞌdè có lá. ");
INSERT INTO ndz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Káa Jézù giì njè nó ꞌdo ꞌbá ta njeyé, ya gí bà ꞌdeke tí wó ji Mbíṛì ta kpéétí wó gbí kángáá nga ngoò. ");
INSERT INTO ndz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bìndi  ndâ Sìmónè ta ndâ ꞌbí ka wó giì njè nó ya gí bà pà bà tí wó. ");
INSERT INTO ndz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ndú mâ giì ꞌde yí gî, ndú giì ꞌdè có ji yí máa, «Ndâ ꞌduù ꞌdáá gî kû ꞌvee bà tí lo.» ");
INSERT INTO ndz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Káa Jézù giì ꞌdè có ji ndú, máa, «Ndoo ya gí gbí ndâ ꞌbí gbata, wàa ye ꞌví ma có mì Mbíṛì ji ndâ ꞌduù kà delè, tacó ŋìnó a ndeṛè bà gì ye gí muu to tí nô.» ");
INSERT INTO ndz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bìndi  yí giì ya cee gbí ndâ to Gàlìléyà ꞌdáá gî, kû ma có mì Mbíṛì ji ndâ ꞌduù ta ndi tí ndâ bàndò bà ùlù Mbíṛì, delè ta bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bìndi  ꞌbí ꞌdakò tí mbe cì giì ꞌdeke tí wó ta bà kucuku muungbó wó mí kùṛo Jézù, máa, «À má nìkì tí lo gî, wò bà ngbaṛanga dìì ye gî.» ");
INSERT INTO ndz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jézù mâ giì ŋò yê ṛo ꞌdakò tí nò, yí giì yaꞌva ꞌbì wó ya gí bà gbala ta yí ta bà ꞌdè có, máa, «À nìkì tí ye gî; dù ngbáṛángàꞌi.» ");
INSERT INTO ndz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bìndi  ndâ kà cì tí nò ngé giì yuku ꞌdo tí ꞌdakò nò gî kútí wó giì ngbaṛanga gî. ");
INSERT INTO ndz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bìndi bà cee cì ꞌdo tí ꞌdakò tí nò, Jézù ngé giì ꞌdè có ji yí, ");
INSERT INTO ndz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","máa, «Kpolo tí lo máa wò ꞌví ꞌdè ji gbèe ꞌduù lá. Ya gí bà tùbà tí lo ji bu-Mbíṛì, wàa wò ꞌví ci i tacó bà ngbaṛanga kútí lo go có mì Mòze, tacó bà tùbà  ji ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Káa ꞌdakò tí nò giì njè nó ꞌdo bà-i-nò ta bà ma ngú có tí nò go ŋìnó à nìkì tí wó dúú kû ya tí . Tacó énò, Jézù giì ṛì gí gbí gbata ká gbí kóó, má wálá, ndâ ꞌduù bà bàkà wo. ");
INSERT INTO ndz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jézù mâ giì dele ndi wó gí Kàpàrànáwùmù bìndi làmbu sili gî, ndâ ꞌduù giì ꞌbìtà bà fiini có, máa, «Yí kuu ꞌbá! Yí kuu ꞌbá!» ");
INSERT INTO ndz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bìndi  ndâ ꞌduù giì kaa gì gí mì wó go mbílì gbí cìkaà; ndâ ꞌduù giì yè to ꞌdo tàꞌi di sè, à giì kpò tí tí njekèjì bà ṛì gí tàꞌi tàkò Jézù. Yí ta o tí nò kû nìbà có mì Mbíṛì ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mâ giì zekeꞌo, ndâ ꞌbí ꞌduù giì gì ta ꞌbí ꞌdakò mbe gbeleꞌve gî, náa a ndâ ꞌduù nàꞌô ká kû làngà yí gì tí  ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Káa kpokèjì bà yee ta yí tàꞌi ji Jézù giì kpò ndú gî, tacó ndâ ꞌduù tì yè njekèjì gî. Bìndi  ndú giì ꞌdò ta ꞌdakò tí nò gí muu ꞌbá, bìndi  ndú giì di muu ꞌbá gbúú-gbuu ꞌvii ta bàndò tí nó náa Jézù kû ki tí wó to tí  nô, bìndi  ndú giì yuu ꞌdakò tí nò mbe gbeleꞌve gî nò ta kpâ-sili mì wó gí to ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jézù mâ giì ŋò énó máa, ndú ùnje gítí yì ta njembí ndú dú gî, yí giì ꞌdè có ji ꞌdakò tí nò mbe gbeleꞌve gî nò, máa, «ꞌViì mì ye, à si có gítí ndâ vò i mì lo mí to gî.» ");
INSERT INTO ndz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Káa ta o tí nò ndâ ꞌbí kpo-kpò mbe nìbà có mì Mbíṛì mì ndâ Jùdéyà kû ki tí ndú gbí òkò tí ndâ ꞌduù tí nó mbe kaa ya gí mì Jézù nô. Ndú mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, ndú giì ꞌbìtà bà koṛo có gbí njembí ndú máa, ");
INSERT INTO ndz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«ꞌDakò tí nò ꞌdè ŋa có tí nò tacó yè? Ŋìnò a bà ꞌdè zu có gítí Mbíṛì! Mbe si có gítí ndâ vò i mì ndâ ꞌduù mí to a ꞌdi? À me káa Mbíṛì cuki lá?» ");
INSERT INTO ndz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Káa Jézù mâ giì ŋò ŋa kóṛó-koṛo có mì ndú nò, yí ngé giì ꞌvìsì có ji ndú énó máa, «Yo kû koṛo ŋa ndâ có tí nò á gbí njembí yo tacó yè? ");
INSERT INTO ndz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","À kpónó peteke a ngàyi gbí òkò tí ndâ bà ꞌdè có ji ꞌdakò tí nó énó máa, à si có gítí ndâ vò i mì wó mí to gî, ta bà ꞌdè có ji yí énó máa, yí te kpâ-sili mì wó wàa yí ꞌví nò nó? ");
INSERT INTO ndz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","À má énò, ye kpónó bà tùbà  ji yo énó máa, à tí ꞌViì-mì-ꞌDakò a wotí tacó bà je à-cee-gî gítí ndâ vò i mì ndâ ꞌduù muu to tí nô.» Bìndi  Jézù giì ꞌdè có ji ꞌdakò tí nò mbe gbeleꞌve gî nò, máa, ");
INSERT INTO ndz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«A gí yaà. Te kpâ-sili mì lo wàa wò ꞌví njè nó ya gí ꞌbá a go có tí nó náa ye kpónó kû ꞌdè ji wò nô.» ");
INSERT INTO ndz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ꞌDakò tí nò ngé giì a gí yaà, yí giì paṛa kpâ-sili mì wó, bìndi  yí giì co gí sè gbí njì ṛo ndâ ꞌduù ꞌdáá gî. Nje ndâ ꞌduù ꞌdáá gî giì ꞌdèè ta bà ŋò ꞌdakò tí nò kû nò nó gî. Bìndi  ndú giì ùlù Mbíṛì, máa, «Ze jé ŋò ꞌbí ŋa i go i tí nò sàà kùṛo lá.» ");
INSERT INTO ndz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ta o tí nò Jézù giì dele ndi wó kákáꞌi ya gí seè kàpá Gàlìléyà bìndi o bà tèꞌé tí ndâ kpédélé mbe tala có mì wó. Mâ giì zekeꞌo, ndâ ꞌduù me mbè giì kaa kákáꞌi ya gí mì wó tàbèꞌdè kà. Yí giì nìbà i ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jézù mâ giì njè nó ꞌdo bà-i-nò, yí giì ŋò Lévì, tí ꞌviì mì Àlìféyò, kû ki tí wó to á seè ꞌbá bà gò i-mírì. Káa Jézù giì ꞌdè có ji yí, máa, «Gì gí tàkò ye.» Káa Lévì bà-i-nò giì a gí yaà ya gí tàkò Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ta ꞌbí o gbaànjé si ndâ Jézù ta ndâ mbe tala có mì wó kû zò i á ꞌbá mì Lévì, ndâ ꞌbí mbe go i-mírì, ta ndâ ꞌbí ŋa Jùdéyà ŋìnó mbe kpolo tí tàkìì mì ndú lá nó ꞌdo gbí òkò tí ndâ mbè ꞌduù tí nò mbe tì ta o tí nò mbe kû ko tàkò wó nó giì ya gí bà zò i ta ndú. ");
INSERT INTO ndz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ndâ ꞌbí kpo-kpò mbe nìbà i gbí tàkìì mì ndâ Jùdéyà ŋìnó mbe kû kpolo tí tàkìì mì ndú nó giì ꞌvee ndâ mbe tala có mì Jézù, máa, «Yí kû zò i ta ndâ mbe gò i-mírì, delè ta ndâ mbe gìlìnì tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Káa Jézù mâ giì ꞌdi có tí nò, yí giì ꞌdè có ji ndú máa, «Ndâ ꞌduù ŋìnó ta séꞌi tí ndú wálá nó pà mbe yeè lá. A ndâ mbe séꞌi ká kû pà ndâ mbe yeè. Ye gì me tacó tí ndâ tó ꞌduù lá. Ye gì a i tacó tí ndâ mbe bàkà vò i.» ");
INSERT INTO ndz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ta o tí nò ndâ mbe tala có mì Jòvánì tí mbe caka tí ndâ ꞌduù, ta ndâ Fàrìzéyò, tí ŋa ndâ Jùdéyà ŋìnó mbe kû kpolo tí tàkìì mì ndú nó, kû kònò go tacó bà yù nambeè ꞌdo mì Mbíṛì. Bìndi  ndâ ꞌduù giì ꞌvee Jézù, máa, «Ndâ mbe tala có mì lo kònò go á go ŋìnó mì ndâ mbe tala có mì Jòvánì ta ndâ mbe tala có mì ndâ Fàrìzéyò lá tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Káa Jézù giì ꞌvee ndú, máa, «Ndâ wiṛi bàndò bà ko niì kû kònò go ta o tí nó náa mbe kò niì má kuu ta ndú? Ta o tí nó náa mbe kò niì má kuu ta ndú, ndú kònò go lá. ");
INSERT INTO ndz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ṛi bà je mbe kò niì ꞌdo gbí òkò tí ndú bà co ká co! Ŋìnò bà giì dù a ṛi tí nó tí ṛi bà kònò go mì ndú nó ká nò.» ");
INSERT INTO ndz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bìndi  Jézù giì ya gí kùṛo ta bà dìtà có ji ndú gbí lòkóꞌbò, máa, «ꞌBí ꞌduù jé mbe bàkà rúgà mítí ká bòngo mì wó ta ngú kpâ-bòngo náa à kálásê yuu mí tà ngo lá nò wálá; yí má bàkà go énò, ngú rúgà tí nò bà yaka ꞌdo tí ká bòngo gî, bìndi  kà bà giì dù gbí bòngo tí nò ndii ŋìnó sàà kùṛo nó gî. ");
INSERT INTO ndz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ꞌBí ꞌduù delè jé mbe yee ngú nèbítì mí gbí ká kúúkpá nèbítì wálá, yí má bàkà énò, ngú nèbítì má nì , yí bà ba ká kúúkpá gî, bìndi  nèbítì bà yee to gî, kúúkpá delè bà yaka gî. À má énò, ngú nèbítì a i tacó ngú kúúkpá.» ");
INSERT INTO ndz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ta ꞌbí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gbaànjé, si ndâ Jézù ta ndâ mbe tala có mì wó kû nò nó co gbí njí, ndâ mbe tala có mì wó giì ꞌbìtà bà kpaṛaka muu cû kû zò . ");
INSERT INTO ndz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ndâ Fàrìzéyò mâ giì ŋò i tí nò náa ndâ mbe tala có mì Jézù kû bàkà nò, ndú giì ꞌvee yí, máa, «Ŋìnó a ŋa yè ká nò? Ndú kû bàkà i ŋìnó náa a me yí  lá nó ta ṛi bà wotí tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo jé ꞌdeke có gítí i tí nó náa Dàvídè si yí ta go tí wó bàkà nó lá? Ndú ta ndâ ꞌduù tí nò ta o tí nó mbe kû ko tàkò wó nô? ");
INSERT INTO ndz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ta o tí nó náa yí giì ṛi gí tàꞌi mì Mbíṛì, si Àbìyátàrà a Kùṛo ndâ bu-Mbíṛì, bìndi  yí giì zò kù kô tí nó náa à ci ji Mbíṛì gî nô. ");
INSERT INTO ndz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","«Mbíṛì kpédéléꞌi suu a ndâ ꞌduù má kózò gî, yí giì bàkà ṛi bà wotí. Mbíṛì bàkà ṛi bà wotí me tacó bà ba muu ndâ ꞌduù lá. ");
INSERT INTO ndz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","À má énò, ye kû ꞌdè có ji yo ta yúcó, máa, à mì ꞌViì-mì-ꞌDakò a wotí tacó bà ꞌdè có ji ndâ ꞌduù, máa, ndú bàkà a ndâ i ŋìnó, ndâ i ŋìnó, ta ṛi bà wotí.» ");
INSERT INTO ndz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ta ꞌbí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gbaànjé, Jézù giì gì gí bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì. Káa ta o tí nò, ꞌbí ꞌdakò ta ꞌbì wó mbe gbeleꞌve gî kuu tàꞌi kà gbí òkò tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bìndi  ndâ ꞌduù giì ꞌbìtà bà zekeꞌo tacó bà ŋò máa Jézù má ꞌvala ꞌdakò tí nò ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gî, wàa ndâ yì ꞌví ya gí bà kpì ngbàngà tí wó. ");
INSERT INTO ndz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jézù mâ giì ŋò énò, yí giì ꞌdè có ji ꞌdakò tí nò, máa, «Co gì gí bà ṛò tíyò á kùṛo ndâ ꞌduù tí nô.» ꞌDakò tí nò mâ giì bàkà go có tí nó náa Jézù ꞌdè ji yí nó gî, ");
INSERT INTO ndz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jézù giì ꞌvee ndâ ꞌduù tí nò, máa, «Yúcó mì ndoo a ngàyi? Bà bàkà tó i, wèè, bà bàkà vò i, ta ṛi bà wotí gbí tàkìì mì ndoo tí ndâ Jùdéyà? Bà ꞌvala ku, wàlà bà zi ku?» Káa gbèe ꞌduù mbe ꞌvìsì có ji yí giì dù lá. ");
INSERT INTO ndz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tacó énò, Jézù giì zekeꞌo tí ndú ta kpo-tàkòcò wó, tacó ndú a ndâ mbe ngbútù. Tàkòcò wó delè giì kpolo gítí ndú ngé, tacó muu ndú kpolo go duù. Bìndi  yí giì ꞌdè có ji ꞌdakò tí nò máa, «Yaꞌva gbí ꞌbì lo.» Bìndi  ꞌdakò tí nò mâ giì bàkà go có tí nò náa Jézù ꞌdè ji yí nò gî, ꞌbì wó giì nìkì gî. ");
INSERT INTO ndz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Káa ndâ mbe kû kpolo tí tàkìì mì ndâ Jùdéyà (Fàrìzéyò) mâ giì ŋò i tí nó náa Jézù bàkà nò, ndú giì co gí sè tacó bà ya gí bà toko có ta ndâ ꞌduù ŋìnó mbe tè gí tàkò có mì Èródè tí gbolò ꞌduù kùṛo ndâ Jùdéyà nó, tacó bà pà kpokèjì gítí bà zi Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Bìndi  Jézù giì njè nó ta ndâ mbe tala có mì wó ya gí yì kàpá Gàlìléyà. Ndâ ꞌduù me mbè giì ṛu ndi ndú ꞌdo gbí ndâ gbata gbí ndâ to Gàlìléyà ta Jùdéyà, ");
INSERT INTO ndz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ta gbolò gbata Jèrùzàlémè, ta Ìdùméyà, delè ꞌdo tìto Jòròdánìyà, delè ꞌdo gbí ndâ to Tírò ta Sìdónì. Ndâ ꞌduù mâ giì ꞌdi tàwo ndâ i-seṛè tí nó náa Jézù kû bàkà nó, ndú giì tì ya gí mì wó. Ndâ ꞌduù tì go ngana. ");
INSERT INTO ndz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jézù mâ giì ŋò ŋa bà tì ndâ ꞌduù tí nò, yí giì ꞌdè có ji ndâ mbe tala có mì wó énó máa, ndú gì ta gbâ ji yì, tacó yí ta o tí nò kû ci gúku máa ndâ ꞌduù bà kpoko yì. ");
INSERT INTO ndz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tacó ndâ ꞌduù ꞌdi tà wò bà ꞌvala ndâ mbe séꞌi mì wó me mbè, tacó énó, ndâ ꞌduù ŋìnó ta séꞌi tí ndú nó ꞌdáá gî kû jòò tí ndú tacó vòó bà gbala yí wàa ndâ yì ꞌví ꞌde ta ꞌválá. ");
INSERT INTO ndz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Delè ndâ ꞌduù ŋìnó ta ndâ i-gbí-muu ndú nó má ŋò yí, ndú kû ꞌvaka tí ndú to, ta bà tò kû, máa, «Wò a ꞌViì-mì-Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Káa yí giì ꞌdè có ji ndú kpolo ma, máa ndú ꞌví tùbà tí yì gí sè ji ndâ ꞌduù lá. ");
INSERT INTO ndz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ta o tí nò Jézù giì njè nó ya gí gbí òkò ndâ ꞌbí gú. Bìndi  yí giì tèꞌé tí ndâ ꞌduù ŋìnó mbe nìkì tí wó nô. Ndú mâ giì gì gí mì wó gî, ");
INSERT INTO ndz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","yí giì ṛuka ndâ ꞌduù ꞌdo gbí òkò tí ndú muuꞌbì-nje só, tacó wàa ndú ꞌví dù toko ta yì, wàa yì ꞌví kû tuu ndú ya gí bà ma có mì Mbíṛì ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yí giì je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù, ta wotí bà ꞌvala ndâ ꞌduù ꞌdo gbí nòꞌo ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ndâ ꞌduù tí nò muuꞌbì-nje só náa Jézù ṛuka ndú tacó bà dù ta yí nò a ndâ Sìmónè, náa yí kpì ngú ṛè mítí wó máa, Pìyétòrò, ");
INSERT INTO ndz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ta ndâ Jákòmò ta náꞌvindí wó Jòvánì tí ndâ ꞌviì mì Zèbìdéyò, náa yí kpì ngú ṛe mítí ndú máa Bènèrègísì, gbí  énó máa, ndâ ꞌviì-ngbàngbàṛì, ta Àndèréyà, ");
INSERT INTO ndz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ta Fìlípò, ta Bàràtòlòméyò, ta Màtéyò, ta Tòmázò, ta Jákòmò tí ꞌviì mì Àlìféyò, ta Tàdéyò, ta Sìmónè tí nó ta ꞌbí ṛè wó a Tó-ꞌviì-ꞌbá, ");
INSERT INTO ndz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ta Júdà Ìsìkàrìyótè tí mbe giì kpì ngbàngà tí wó. ");
INSERT INTO ndz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jézù mâ giì dele ndi wó gí ꞌbá ꞌdo pí gú bìndi bà ṛuka ndâ mbe tala có mì wó gî, ndâ ꞌduù me mbè giì kaa ya gí mì wó kákáꞌi tí ŋa ŋìnó náa à giì kpòtí tí ndú ta ndâ mbe tala có mì wó tí bà zò i. ");
INSERT INTO ndz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ndâ nambe wó má giì ꞌdi énò, ndú giì ya gí kà tacó ba kpolo tí wó, tacó ndú koṛo có énó máa, a gbí muu wó a ndâ i. ");
INSERT INTO ndz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Káa ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà mbe gì ꞌdo Jèrùzàlémè ta o tí nò kû ꞌdè ŋìndi ndú énó máa, «À gbí muu wó a gba mì ndâ mâ tí nó ta ṛe wó a Bèlìzèbúlù nô.» Ndú delè ta o tí nò kû ꞌdè có énó máa, «A gba mì ndâ mâ tí nò ká kû je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ji yí.» ");
INSERT INTO ndz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jézù mâ giì ꞌdi ŋa ndâ có tí nò, yí giì tèꞌé tí ndâ mbe kû ꞌde ŋa ndâ có tí nò gí mì wó. Bìndi  yí giì ꞌvee ndú gbí lòkóꞌbò énó máa, «Mâ bà mòkò ka wó mâ ꞌdo gbí muu ꞌduù ée? ");
INSERT INTO ndz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Có mì ndâ ꞌduù mì gbèe gba jé má toko lá, gba tí nò bà zogo ꞌbá wálá. ");
INSERT INTO ndz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","À delè có mì ndâ ꞌduù á ṛùkàtiì mì ndú má toko lá, ndú bà sì ꞌbá tí nò wálá. ");
INSERT INTO ndz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Káa Gba-wàtà má kû sogo tí wó, gbí  go énó máa, Gba-wàtà njèè gbí tí gî. À má énò, ŋìnò a bà ngbù yí ká nò. Tacó wotí bà ṛò tíyò mì wó kákáꞌi wálá. ");
INSERT INTO ndz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Káa ꞌbí ꞌduù jé bà ni bà ṛi gí tàꞌi mì ꞌbí ꞌduù ta wotí kuu tí wó, bìndi  yí giì kaa ndâ i mì wó a ta có ꞌdakò nò wálá, sè  káa ŋìnó yí kpédéléꞌi má eṛe mbe ꞌbá gî, bìndi  yí bà giì kaa ndâ i mì wó ta wotí si yí gbí wú. ");
INSERT INTO ndz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Ye kû ꞌde có ji yo ta yúcó énó máa, Mbíṛì bà je à-cee-gî gítí ŋa ndâ vò i mì ndâ ꞌduù ꞌdáá gî, gî. À kpêtí káa ndâ mbe ꞌdè zu có á gítí wó tí Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Káa ꞌduù má go mâ mítí Bèṛi-mì-Mbíṛì, ꞌduù tí nò bà ꞌde à-cee-gî ꞌdo mì Mbíṛì wálá, tacó ꞌduù tí nò bàkà a ŋa vò i tí nó náa àá bà cee wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jézù ꞌdè có tí nò tacó ndâ ꞌduù ta o tí nò kû ꞌdè có énó máa, a gbí muu wó a ndâ mâ. ");
INSERT INTO ndz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Káa ta o tí nò ndâ nawu Jézù ta ndâ náꞌvindí wó giì ṛò tíyò á sè. Bìndi  ndú giì tuu tú gí bà tèꞌé tí wó. ");
INSERT INTO ndz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Káa ndâ ꞌduù me mbè ki tí ndú jèlè yí ꞌdee gî. Bìndi  ndú giì ꞌdòkò ndi có tí nò ji yí, máa, «Ndâ nawu lo ta ndâ náꞌvindí lo kû ꞌvee bà tí lo á sè.» ");
INSERT INTO ndz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Káa Jézù giì ꞌvee ndú énó máa, «Nawu ye a ꞌdi? Ndâ náꞌvindí ye a ndâ ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yí bà-i-nò giì zekeꞌo tí ndâ ꞌduù tí nò mbe ki tí ndú jèlè yí ꞌdee gî nô. Bìndi  yí giì ꞌdè có ji ndú, máa, «Nawu ye, ta ndâ náꞌvindí ye cuki me káa ndâ ꞌduù tí nò mbe kû tèꞌé tí ye nò lá. ");
INSERT INTO ndz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ꞌDuù mbe bàkà go có mì Mbíṛì gî, ꞌduù tí nò a nawu ye, yí a náꞌvindí ye, yí delè a námì ye.» ");
INSERT INTO ndz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ta o tí nò Jézù kákáꞌi giì ꞌbìtà bà nìbà i ji ndâ ꞌduù a yì kàpá Gàlìléyà. Káa yí mâ giì ŋò máa, ndâ ꞌduù tì me mbè ngé ndii gî, yí giì njè nó ya gí bà ki tí wó gbí gbâ a ṛo ngo si ndâ ꞌduù mí tì ngo. ");
INSERT INTO ndz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yí giì dù gbí gbâ á ṛo ngo kà kû nìbà i ji ndâ ꞌduù gbí lòkóꞌbò énó máa, ");
INSERT INTO ndz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Yo sè tù yo nìkì maa, wàa yo ꞌví koṛo gbí có tí nô. «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò giì ya gí bà va ŋa gbí njí mì wó. ");
INSERT INTO ndz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Káa ndâ ꞌbí njì ŋa giì ꞌvaka tí to á seè kpokèjì, káa ndâ nuù giì da ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ndâ ꞌbí  giì ꞌvaka tí á gbí díí ta zì to tí  me njíꞌdí, à káa póó bà kù ndú, ");
INSERT INTO ndz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","go wu ṛi giì ziki ndâ dó kú ndú ꞌdáá gî, tacó tà teè ndú ya gí tà to me ꞌdú lá. ");
INSERT INTO ndz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ndâ ꞌbí  giì ꞌvaka tí á gbí òkò ndâ bè kpeṛè. Ndâ bè kpeṛè tí nò giì tù yiiga muu ndú gî, ndú giì jò lá. ");
INSERT INTO ndz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Káa ndâ ꞌbí  giì ꞌvaka tí a i gbí banga zì to. Ndú mâ giì kù , ndú giì uu gí yaà, bìndi  ndú giì jò ta banga muu ndú, gbe-gbè, gbe-gbè énô.» ");
INSERT INTO ndz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bìndi  yí giì yee nje lòkóꞌbò mì wó ta bà kpo-gbí-tà-tù ndâ ꞌduù tí nò énó máa, «À má énò, tù bà ꞌdi có má kuu tí muu ꞌduù, yí ꞌví ꞌdi có.» ");
INSERT INTO ndz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jézù má giì co gí ndiì ta kpéétí wó gî, ndâ mbe tala có mì wó muuꞌbì-nje só, toko ta ndâ ꞌbí ꞌduù mì wó mbe kû dù ta yí nó giì ya gí bà ꞌvee yí gítí gbí lòkóꞌbò tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Káa yí giì ꞌvìsì có ji ndú énó máa, «À je muu ji yo tacó bà ꞌdi gbí ngìì bà dù yí tí Mbíṛì tí gba gî. Káa sè ndâ ꞌbí ꞌduù bà ꞌdi ndâ có ꞌdáá gî ká gbí lòkóꞌbò. Go có tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì ꞌdè dígísèé énó máa, ");
INSERT INTO ndz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‹Ndú ꞌví zekeꞌo, káa ndú ꞌví ŋò i lá. Ndú delè ꞌví ꞌdi kòcò, káa ndú ꞌví ꞌdi gbí có tí nò lá. Tacó ndú má ŋò i, delè ndú má ꞌdi gbí có, ndú bà giì ꞌvìsì tí ndú gí mì ye tí Mbíṛì, bìndi  ye bà je à-cee-gî gítí ndâ vò i mì ndú.› » ");
INSERT INTO ndz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bìndi  Jézù giì ꞌvee ndâ mbe tala có mì wó máa, «Yo ꞌdi gbí lòkóꞌbò tí nò lá? Káa à má énò, yo bà giì ꞌdi gbí ndâ ꞌbí lòkóꞌbò ée? ");
INSERT INTO ndz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Gbí lòkóꞌbò tí nò énó máa: njì ŋa tí nò náa mbe va ŋa tí nò kû va nò a njì có mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ndâ njì ŋa ŋìnó mbe ꞌvaka tí ta tí kpokèjì nó a ndâ có mì Mbíṛì náa à ma ndú ji ndâ ꞌduù, káa à káa póó bà ꞌdi có tí nò mì ndú, Vò-ꞌduù-tí-nò giì volo muu ndú ꞌdo tí bà ꞌdi gî. ");
INSERT INTO ndz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","«Ndâ njì ŋa ŋìnó mbe ꞌvaka tí gbí to á káṛà-káṛà ṛo díí nó a ndâ có ŋìnó náa à káa póó bà ꞌdi ndú mì ndâ ꞌduù, ndú giì ùnje gítí ndú gî; ");
INSERT INTO ndz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ndâ njì có tí nò giì dù gbí njembí ndú ta làmbu o, káa à má bà giì gbùṛùngà ndú ta bà mèèkèꞌi tí ndú á muu ndâ có tí nò, ndú ngé giì jee có tí nó mí to gî, tacó ndâ có tí nò gbì teè mí gbí njembí ndú lá. ");
INSERT INTO ndz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","«Ndâ njì ŋa ŋìnó mbe ꞌvaka tí gbí òkò ndâ bè kpeṛè nò a ndâ njì có ŋìnó náa ndâ ꞌduù ꞌdi ndú, ");
INSERT INTO ndz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","káa bà kpolo tí ndâ i muu to tí nó, ta líkí ndâ kpo-kpò i, ta bà dù ta go ndâ i, giì soloko ndú ꞌdo tí bà ꞌde i gbí có tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","«Káa ndâ njì ŋa ŋìnó mbe ꞌvaka tí á gbí banga zì to nó uu go ndâ njì có mì Mbíṛì mbe ꞌvaka tí gbí njembí ndâ ꞌduù ŋìnó mbe kpolo tí ndú mí gbí njembí ndú. Ndú gî bàkà go ndâ có tí nò, bìndi  tàkòcò Mbíṛì giì peteke gítí ndú go bà peteke tàkòcò mbe ji njí gítí ndâ banga kú i gbí njí mì wó.» ");
INSERT INTO ndz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bìndi  Jézù giì ꞌvee ndú, máa, «A ꞌdi jé ká òlò wu mí tàꞌi mì wó ta ꞌdíꞌdiꞌo, káa yí giì ꞌbu i mí ṛo ngba wu tí nò, wàlà yí giì ngùù ngba wu tí nò mí tà kìtìkpaṛa? ");
INSERT INTO ndz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","À kû ngùù i ká tacó bà giì tùbà ndí  gí sè kákáꞌi. À delè kû ꞌdè có á tà bèngìì ká tacó bà giì kò-kò tí . ");
INSERT INTO ndz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","À má énò, yo sè tù yo, náa tù má dú kuu tí muu yo nò, wàa yo ꞌví ꞌdi có tí nô.» ");
INSERT INTO ndz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jézù kákáꞌi giì ꞌdè có ji ndú, máa, «Yo kpolo tí có tí nó náa yo kû ꞌdi nô. Ŋa i tí nó náa wò tí ꞌduù má bàkà mítí ndâ ꞌbí ka lo nó, Mbíṛì bà giì bàkà mítí lo káa gbèe ŋa i tí nò. Yí delè bà bàkà ta wotí tí  co tí ŋìnó náa wo bàkà nó gî. ");
INSERT INTO ndz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tacó ꞌduù ŋìnó ta ndâ i kuu mì wó nó, àá bà je ndâ ꞌbí  ji yí mí pí ndú. Káa ꞌduù ŋìnó ta i mì wó wálá nó, à kpêtí káa sè làmbu i ŋìnó náa yí kû lì ta njembí wó nó, àá bà aaka ꞌdo ꞌbì wó gî.» ");
INSERT INTO ndz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jézù giì lòkòꞌbò ꞌbí có kákáꞌi máa, «Bà zèè ꞌbá mì Mbíṛì ká go ꞌduù mbe ya gí bà va ŋa. ");
INSERT INTO ndz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bìndi  yí giì ya kû bàkà ndâ ꞌbí nèté mì wó. Káa ndâ síí kú i giì yee gí sè, bìndi  ndú giì uu gí yaà. Mbe va ŋa tí nò ŋò ni lá máa ndâ kú i kû bàkà tí ée wè. ");
INSERT INTO ndz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","À káa to ta kpéétí wó ká kû bàkà ndâ kú i tí nò kû uu gí yaà, bìndi  ndú giì jò , bìndi  ndú giì ṛì njì. ");
INSERT INTO ndz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bìndi  à káa o tí nó náa ndâ i ꞌdo gbí njí má giì yù gî nó, mbe va ŋa bà giì ngaṛa tí wó gítí bà kili ndú.» ");
INSERT INTO ndz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Bìndi  Jézù giì ꞌdè ꞌbí lòkóꞌbò kákáꞌi énò, máa, «Ndoo kpónó bà ꞌvii bà zèè ꞌbá mì Mbíṛì mítí ŋa yè? Ndoo bà ꞌdè a ŋa lòkóꞌbò yè dú mbe ꞌvii tí ? ");
INSERT INTO ndz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","À go ndâ njì ŋa ŋìnó mbe me vící ngé ndii gî nô, nékéléé go njì ndí. ");
INSERT INTO ndz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Káa ndú má giì kù ꞌdo tà to, ndú giì uu gí yaà tí bèꞌi gbèè ta bè wó ndii ndâ ꞌbí bèꞌi ꞌdáá gî, náa ndâ nuù me mbè kû tè wo ndú mì gbí .» ");
INSERT INTO ndz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jézù ꞌdè có ji ndâ ꞌduù ꞌdáá ká gbí ndâ lòkóꞌbò go ndâ ŋìnò, ꞌvii ta wotí bà ꞌdi gbí ndâ có tí nò mì ndú. ");
INSERT INTO ndz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Káa ta o tí nó náa ndú má ta kpéétí ndú ta ndâ mbe tala có mì wó, yí giì ꞌdè gbí ndâ lòkóꞌbò tí nò ꞌdáá gî ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Káa ta ꞌdêꞌo mì gbèe ṛi bà nìbà i mì Jézù ji ndâ ꞌduù gbí ndâ lòkóꞌbò nò, Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Ndoo di ngo gí tìto kàpá.» ");
INSERT INTO ndz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Káa ndú mâ giì nje nó gî, ndâ ꞌbí ꞌduù giì ṛu ndi ndú gbí ndâ gbâ ŋìndi ndú. ");
INSERT INTO ndz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Káa si ndú kálásê kuu muu nó á ṛo ngo, pípìṛi giì ꞌbìtà bà pì ta wotí tí  ngé ndii gî. Ngo kû giì ꞌbìtà bà gbàngà gí gbí gbâ. Gbâ kû giì bàkà có bà yé-yè ta ngo. ");
INSERT INTO ndz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Káa Jézù jéé kuu tísì, tì tàmuu wó gí yaà gî, á tàngbó gbâ, kû tèṛì. Bìndi  ndâ mbe tala có mì wó giì gbà yí ꞌdo muu ṛi. Yí mâ giì ziya gî, ndú giì ꞌvee yí, máa, «A nìkì tí lo énó máa, ndoo mìì gî wàà, mbe tí ze?» ");
INSERT INTO ndz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Káa Jézù giì do mítí pípìṛi, yí delè giì ꞌdè có ji ngo tí nò mbe kû gbàngà tí nò máa yí si bà gbàngà mí to. Bìndi  pípìṛi giì ṛò tíyò gî. O giì ṛe déé. ");
INSERT INTO ndz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bìndi  Jézù giì ꞌvee ndâ mbe tala có mì wó máa, «Yo kû cì a gúku yè? Yo kálásê ùnje lá?» ");
INSERT INTO ndz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Káa gúku giì zèè ndú ꞌdáá gî mbi gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú, máa, «A ŋa ꞌdi ká nó, náa ndâ pípìṛi ta ngo kû ꞌdi có mì wó nó?» ");
INSERT INTO ndz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ndâ Jézù ta ndâ mbe tala có mì wó giì di ngo á bìndi bà gbùṛùngà ndú mì gbolò pípìṛi tí nò, gí tìto kàpá á gí ꞌbá mì ŋa ndâ ꞌbí ꞌduù ta ṛè ŋa ndú a ndâ Jèràsínì. ");
INSERT INTO ndz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Káa à káa póó bà giì co Jézù gí to ꞌdo gbí gbâ, ꞌbí ꞌdakò ta ndâ i-gbí-muu wó giì gì ꞌdo gbí òkò ndâ muuꞌdú gí mì wó. ");
INSERT INTO ndz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ꞌDakò tí nò kû ꞌvala tà ndâ ꞌbá muuꞌdú. Káa ꞌbí ꞌduù mbe ꞌde wotí bà kpolo tí wó wálá, tacó à kpêtí má eṛe yí ká ta gìnjírì, à zèè tí wó lá. ");
INSERT INTO ndz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","À ta o ꞌdáá gî kû da ꞌbò mítí kò wó, à delè kû eṛe ꞌbì wó ta gìnjírì. Káa yí kû kiꞌviki gbí ꞌbò tí nò ꞌdo tí kò wó gî, yí delè kû kaṛaka gbí gìnjírì ꞌdo tí ꞌbì wó gî, káa gbèe ꞌduù mbe co gbí ŋò wó wálá. ");
INSERT INTO ndz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yí dù kû tò kû too yé, ta ṛi, too yé, ta ṛi, ta ndi gbí òkò ndâ ꞌbá muuꞌdú, delè ta ndi pí ndâ gú, ta bà ndo-ndooko tí wó ta ndi tí ndâ díí. ");
INSERT INTO ndz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mbe mâ tí nò mâ giì ŋò Jézù ꞌdo me ꞌdú, yí giì ì ngèlè ya gí mì wó, yí giì kucuku muungbó wó mí kùṛo wó, ");
INSERT INTO ndz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","kû tò ta kû ta kòcò wó ngéé gí yaà, máa, «Àá mì lo ta ye a yè, Jézù, ꞌViì-mì-Mbíṛì a ngéé gbíṛì? Ye kû be ji wò a tí Mbíṛì máa, wò ꞌví bàkà séꞌi mítí ye lá!» ");
INSERT INTO ndz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(ꞌDakò tí nò ꞌdè có tí nò tacó Jézù do ta i tí nò gbí muu wó nò máa, «Co ꞌdo gbí muu wó gî, ndi lo, zu i!») ");
INSERT INTO ndz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bìndi  Jézù giì ꞌvee i tí nò máa, «Ṛè lo a ꞌdi?» Káa i tí nò giì ꞌvìsì có ji yí, máa, «Ṛè ye a Tùmèṛè, tacó muu ze me mbè.» ");
INSERT INTO ndz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bìndi  yí giì dù kû ꞌdeke tí wó ji Jézù, máa «Si bà ni ze ꞌdo bà-i-nó mí to.» ");
INSERT INTO ndz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Káa ta o tí nò ndâ kàdùrúkù me mbè kû zò i tàgbà gú á gbí to tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bìndi  ndâ i tí nò gbí muu ꞌdakò tí nò giì ꞌdeke tí ndú ji Jézù, máa, «Mòkò ze ya tí  gí mì ndâ kàdùrúkù tí zô, wò ꞌví si ze ꞌví ya gí gbí muu ndú.» ");
INSERT INTO ndz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tacó énò, Jézù giì si ndâ i tí nò mbe kò ꞌdakò tí nò ꞌví bàkà go ŋìnó náa à nìkì tí ndú. Bìndi  ndâ i tí nò giì nje ta ngèlè ꞌdo gbí muu ꞌdakò tí nò ya gí gbí muu ndâ kàdùrúkù. Muu ndâ kàdùrúkù tí nò ta o tí nò ꞌdáá gî dê gítí álìfì só. Bìndi  ndâ kàdùrúkù tí nò giì nje ta ngèlè ya gí bà oloko gí tà ngo ꞌdo tì njà gángá ngo, ndú giì mìì tà ngo gî. ");
INSERT INTO ndz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bìndi  ndâ mbe gbà ndâ kàdùrúkù tí nò giì njè ta ngèlè ya gí bà ma có ŋa i tí nò mbe bàkà tí nò á ji ndâ ꞌduù gbí gbata, ta ndâ ꞌduù ŋìnó mbe kû sì ꞌbá á ta ndi seè gbata tí nò. Ndâ ꞌduù mâ giì ꞌdi có tí nò, ndú giì kaa ya gí bà ŋò ŋa i tí nò mbe bàkà tí dú nò. ");
INSERT INTO ndz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Káa ndú mâ giì kaa ya gí mì Jézù, ndú giì ꞌde ꞌdakò tí nó táánò náa ndâ i kò yí gî nó kû ki tí wó to ta bòngo tí wó tí cèe ꞌduù ta i-gbí-muu wó wálá. Bìndi  gúku giì zèè ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ndâ ꞌduù mbe ŋò ŋa i tí nó mbe bàkà tí mítí ꞌdakò tí nò táánò náa ndâ i kò yí gî nó, ta ndâ ŋa ŋìnó mbe bàkà tí mítí ndâ kàdùrúkù nó giì njè ya gí bà ꞌdè ndí  ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bìndi  ndâ ꞌduù giì ꞌdeke tí ndú ji Jézù máa, yí njè nó á ꞌdo gbí òkò tí ndâ yì gî. ");
INSERT INTO ndz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Káa si Jézù kû giì ya gí bà ꞌdò gí gbí gbâ tacó bà njè nó, ꞌdakò tí nò náa yí mòkò ndâ i ꞌdo gbí muu wó nò giì ꞌdeke tí wó ji yí, máa, yí si ndâ yì ꞌví ya ta yí. ");
INSERT INTO ndz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Káa Jézù giì biya gî. Bìndi  yí giì ꞌdè có ji ꞌdakò tí nò máa, «A nìkì máa wò ya gí ꞌbá, wàa wò ꞌví dìtà ndâ ŋa nambeè tí nó náa Mbíṛì bàkà ji wò nó á ji ndâ nambe lo.» ");
INSERT INTO ndz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bìndi  ꞌdakò tí nò giì njè nó ya gí ꞌbá co gbí ꞌbí wúngbó to ta ṛè  a «Ndâ-gbata-muuꞌbì» ta bà dìtà ndâ ŋa i tí nò náa Jézù bàkà ji yí nò á ji ndâ ꞌduù. Káa nje ndâ ꞌduù mbe ꞌdi có tí nò ꞌdáá gî giì ꞌdèè gítí  gî. ");
INSERT INTO ndz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jézù mâ giì dele ndi wó ꞌdo ꞌbá mì ndâ Jèràsínì ta gbâ gí tìto kèꞌbî gî, ndâ ꞌduù me mbè giì kili kákáꞌi ya gí mì wó á yì kàpá. ");
INSERT INTO ndz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bìndi  ꞌbí ꞌdakò tí gba kùṛo ndâ mbe kû bàkà nèté bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì ta ṛè wó a Jáyìrù giì gì gí mì Jézù, bìndi  yí giì kucuku muungbó wó mí to kùṛo wó, yí giì zèè kò wó, ");
INSERT INTO ndz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ta bà ꞌdeke tí wó ji yí ta wotí tí , máa, «Làmbu nájú ye gbí kpâ-kpeṛè. Gì gí bà tee ꞌbì lo mítí wó wàa yí ꞌví ꞌde ta ꞌválá.» ");
INSERT INTO ndz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bìndi  ndâ Jézù giì njè nó ta Jáyìrù. Káa ta o bà njè nó mì ndú, ndâ ꞌduù me mbè toko mítí ndâ mbe tala có mì Jézù muuꞌbì-nje só giì kaa kû ya gí tàkò wó. ");
INSERT INTO ndz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bìndi  ꞌbí niì ta mbelè kû yee tí wó ta ndoò muuꞌbì-nje só, ");
INSERT INTO ndz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","náa wo wó co ji bà nò gí mì ndâ mbe bàkà yeè gî; bà si ndâ yeè delè mìì ndâ i ꞌdo tí wó ꞌdáá gî, káa mbelè tí nò jé ṛò tíyò ꞌdo tí wó njíꞌdí énò lá. À dú nò a bà giì zingi séꞌi tí nò mítí wó. ");
INSERT INTO ndz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Niì tí nò mâ giì ꞌdi có tí Jézù, yí giì gì céké-céké co gbí òkò tí ndâ mbè ꞌduù tí nò, ya gí bà gbala bòngo tí Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yí bàkà go énò, tacó yí kû koṛo có máa, «Ye kpêtí má gbala káa ndâ bòngo tí wó, ye bà ꞌde ꞌválá gî kû.» ");
INSERT INTO ndz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","À káa póó bà tee ꞌbì niì tí nò mítí Jézù, mbelè ngé giì ṛò bà yee ꞌdo tí wó gî. ꞌDo bàndò tí nò, niì tí nò giì ŋò gbí dìì wó da gî. ");
INSERT INTO ndz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Káa Jézù mâ giì ŋò ni gî máa, wotí bà ꞌvala ꞌduù co ꞌdo gbí dìì yì gî, yí giì ꞌvìsì tí wó gítí ndâ mbè ꞌduù tí nò, bìndi  yí giì ꞌvee ndú, máa, «A ꞌdi ká tee ꞌbì wó mítí ndâ bòngo mì ye?» ");
INSERT INTO ndz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Káa ndâ mbe tala có mì wó giì ꞌvìsì có ji yí, máa, «Wò ŋò ndâ mbè ꞌduù tí nò mbe kû kpoko wò ꞌdee wò gbóó nó gî, káa wò giì dù ndi lo kû giì ꞌvee ꞌvé máa, ‹A ꞌdi ká tee ꞌbì mítí ye› wè?» ");
INSERT INTO ndz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Káa Jézù giì zekeꞌo jèlè yí gî tacó bà ŋò ꞌduù tí nò mbe tee ꞌbì wó mítí wó nò. ");
INSERT INTO ndz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Bìndi  niì tí nò giì gì gí kùṛo wó kû gu ta gúku, tacó yí ŋò i tí nò mbe bàkà tí mítí wó nò ni gî. Yí giì ꞌva tí wó mítí kò Jézù, bìndi  yí giì ꞌdè yúcó mì wó ꞌdáá gî ji yí. ");
INSERT INTO ndz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Káa Jézù giì ꞌvìsì có ji yí, máa, «Wò ꞌde ꞌválá tacó wò ùnje gítí ye gî, nájú ye. Ya ta ꞌdê njembí lo, dele ta ꞌdê gbí dìì lo.» ");
INSERT INTO ndz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Káa si Jézù kálásê kû ꞌdè có ji niì tí nò, ndâ ꞌduù náa à tuu ndú giì gì ta ngèlè ꞌdo ꞌbá mì Jáyìrù gí bà ꞌdè có ji yí, máa, «Bà i tí nò volo ꞌbá kà gî; wò kû si mbe nìbà i ꞌví nò sé nó mítí wó sínò tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Káa Jézù giì bàkà tí wó tí mbe ꞌdi ndâ có tí nò náa ndâ tú tí nò ꞌdè ji Jáyìrù nò lá. Bìndi  yí ngé giì ꞌdè có ji Jáyìrù máa, «Cì gúku lá. Tee káa njembí lo mítí Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ꞌDo tí bàndò tí nò, Jézù kákáꞌi giì si gbèe ꞌduù ꞌví ṛu ndi wó á bìndi ndâ Pìyétòrò, ta ndâ Jákòmò, ta náꞌvindí wó Jòvánì nò lá. ");
INSERT INTO ndz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ndú mâ giì di ꞌbá mì Jáyìrù, Jézù giì ŋò ndâ ꞌduù kû mèṛèkè tí ndú ta tó, ta bà wa gbí, ta bà tò kû ta kòcò ndú ngéé gí yaà. ");
INSERT INTO ndz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Káa Jézù giì ṛì gí tàꞌi, bìndi  yí giì ꞌvee ndâ ꞌduù tí nò, máa, «Yo kû pìì wo ta bà wa gbí tacó yè? ꞌViì tí nò cee lá, yí kû tè a ṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Káa ndâ ꞌduù tí nò giì ŋo Jézù ŋó-ŋo. Bìndi  Jézù giì njè ndâ ꞌduù ꞌdo tàꞌi á tàkò ku ꞌvinî tí nò ꞌdáá gî gí sè. Bìndi  yí giì si ta yí káa ndâ bu ꞌvinî tí nò ta nawu wó, ta ndâ Pìyétòrò, ta Jákòmò, ta Jòvánì. Bìndi  ndú giì ya ta ndú gí ṛègbà tí ku ꞌvinî tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jézù bà-i-nò giì zèè ꞌbì ꞌvinî tí nò, bìndi  yí giì ꞌdè có ji yí, máa, «Tàlítà kúmì.» (Gbí  máa, «Làmbu ꞌvinî, a gí yaà.») ");
INSERT INTO ndz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bìndi  ꞌvinî tí nò ngé giì a gí yaà kû nò nó. ꞌVinî tí nò ta o tí nò a ꞌduù ta ndoò tí wó muuꞌbì-nje só. Bìndi  nje ndâ ꞌduù ꞌdáá gî giì ꞌdèè gî. ");
INSERT INTO ndz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Káa Jézù giì ꞌdè cò ji nawu ꞌvinî tí nò máa, yí je i-zó-zò ji yí. Yí delè giì ꞌdè có ji ndú ta wotí tí  máa, ndú ꞌví ꞌdè có i tí nò náa yì bàkà ji ꞌvinî tí nò nò gí sè ji ꞌbí ꞌduù gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ta o tí nò Jézù giì njè nó ꞌdo ꞌbá mì Jáyìrù ya gí ꞌbá mì ndú á Názàrètì. Ndâ mbe tala có mì wó giì ko tàkò wó ya gí kà. ");
INSERT INTO ndz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Káa ta ꞌbí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gbaànjé, yí giì ꞌbìtà bà nìbà i ji ndâ ꞌduù á bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì. Káa nje ndâ ꞌduù me mbè mbe ꞌdi ndâ có mì wó giì ꞌdèè gítí ŋa bà nìbà i mì wó Bìndi  ndú giì ꞌbìtà bà kitiki có gbí òkò tí ndú, máa, «ꞌDakò tí nò ꞌde ŋa ndâ có mì wó nò ꞌdo ngò? Ŋìnó a ŋa muu yè náa Mbíṛì je ji yí go énò? Yí me ta bà bàkà ndâ seṛè tí nò ꞌdáá gî ée? ");
INSERT INTO ndz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ŋìnó me ꞌdakò tí nó mbe kû bàkà nèté bà no mû, tí ꞌviì mì Màríyà nó lá? À me yí tí náꞌvindí ndâ Jákòmò, ta Jùzépè, ta Júdà, ta Sìmónè nó lá? Ndâ námì wó me kuu ta ndoo á to nó lá?» Bìndi  ndú giì biya bà se tù ndú tí ndâ có mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Káa Jézù giì ꞌvìsì có ji ndú máa, «À káa ndâ ka ꞌbá, ta ndâ nambe mbe ꞌdòkò có mì Mbíṛì, ta ndâ ꞌduù gbí yâ-wó cuki ká te duù mítí wó lá.» ");
INSERT INTO ndz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tacó énò, yí giì bàkà ndâ seṛè ji ndú me mbè lá. Yí giì ꞌvala ndâ mbe séꞌi ká gbaànjé-gbaànjé ta bà tee ꞌbì wó mítí ndú. ");
INSERT INTO ndz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bà ꞌdè có gítí ndâ ꞌduù Názàrètì giì kpo nje wó gî, tacó ndú ùnje gítí ndâ có mì wó lá. Bìndi  yí giì ya gí ꞌbá mì ndâ ꞌbí tende ꞌduù kû nìbà i ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jézù giì tèꞌé tí ndâ mbe tala có mì wó muuꞌbì-nje só. Bìndi  yí giì ꞌbìtà bà tuu ndú á gí ndiì, só, só, só. Káa kùṛo bà njè nó mì ndú, yí giì je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Bìndi  yí giì kpo-gbí-tà-tù ndú énó máa, «Yo ꞌví zèè ꞌbí i mí ꞌbì yo á bìndi ndâ mû-kóṛó mì yo lá. Yo ꞌví te vòó i-zó-zò tacó bà zò á muu nó lá. Yo ꞌví le kúúkpá lá. Yo ꞌví je gùrúsù ta yo muu nó lá. ");
INSERT INTO ndz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yo ꞌví kaa ndâ ꞌbí tàmà ta ndâ bòngo tacó bà ꞌvìsì ta ndâ ŋìnó tí dìì yo nó muu nó lá. ");
INSERT INTO ndz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yo má yee tí to, yo ꞌví ṛàngà bàndò bà dù yo lá, yo ꞌví dù ká tí gbèe ꞌbá yee tí o bà njè nó mì yo á ꞌdo tí to tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yo má di tí bàndò, káa ndâ ꞌduù bà-i-nò má kaa kpâ-sili ji yo á gí tàꞌi lá, ndú delè má biya bà sè tù ndú á gítí ndâ có tí nó náa yo kû ꞌdè ji ndú nó gî, ta o tí nó náa yo má kû njè nó ꞌdo tí to tí nò, yo ꞌví gbà njú to to tí nò ꞌdo tí kò yo gî, tacó bà tùbà ndâ vò i mì ndâ ꞌduù tí nò á ji ndú.» ");
INSERT INTO ndz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jézù mâ giì kpo-gbí-tà-tù ndâ mbe tala có mì wó cee gî, ndú giì ꞌvaaka gí ndiì kû ma có ji ndâ ꞌduù énó máa, ndú ꞌvìsì muu ndú ꞌdo tí ndâ vò i mì ndú, ");
INSERT INTO ndz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ta bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù me mbè. Delè ta bà ꞌvala ndâ ꞌduù me mbè ꞌdo gbí ndâ nòꞌo ta bà too bàà mítí ndú. ");
INSERT INTO ndz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Èródè tí gbolò ꞌduù kùṛo ndâ Jùdéyà mâ giì ꞌdi có tí Jézù, tacó ṛè Jézù ta o tí nò giì wu to ngé ndii gî. Ndâ ꞌbí ꞌduù ta o tí nò kû ꞌdè có énó máa, a Jòvánì tí nó táánò tí mbe kû caka tí ndâ ꞌduù nó ká ꞌvala ndi wó ꞌdo gbí muuꞌdú wó, káa yí kû bàkà ndâ seṛè tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Káa ndâ ꞌbí ꞌduù ŋìndi ndú kû ꞌdè có máa, yí a mbe ꞌdòkò có mì Mbíṛì, á go ndâ ꞌbí mbe ꞌdòkò có mì Mbíṛì sàà gbí o mì ndâ ká gù ndâ yì. ");
INSERT INTO ndz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Káa Èródè mâ giì ꞌdi ta wo ndâ i-seṛè tí nó náa Jézù kû bàkà nó, yí giì ꞌdè có máa, «Jòvánì tí nó náa ye táánò da miṛi wó gî nó ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî.» ");
INSERT INTO ndz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Èródè ꞌdè có tí nò, tacó àá táánò a yí ká tuu ndâ àsìkérì mì wó ya gí bà zèè Jòvánì mì gbí zàà tacó tí Èródìyà, tí niì mì náꞌvindí wó Fìlípò, náa yí tí Èródè ja yí ꞌdo tí wó giì kò gî. ");
INSERT INTO ndz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Káa yí giì zèè Jòvánì mí gbí zàà tacó Jòvánì giì ꞌdè có ji yí énó máa, àá mì wó me yúcó tacó bà kò niì mì náꞌvindí wó ꞌdo tí wó lá. ");
INSERT INTO ndz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tacó énò, Èródìyà giì mbè Jòvánì gí mì ku, tacó ŋa có tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Káa yí ta o tí nò ꞌdè kpokèjì bà zi yí lá, tacó Èródè te duù mítí Jòvánì ngé ma. Tacó ndâ có mì wó delè ꞌdáá gî toko ká ta có mì Mbíṛì. Tacó énò, Èródè giì kpolo tí Jòvánì, tacó wàa, ꞌbí vò i ꞌví ꞌde yí lá. Líkí bà ꞌdi ndâ có mì wó ta o ꞌdáá gî delè tí wó ngé. ");
INSERT INTO ndz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Èródìyà giì ꞌdè banga kpokèjì bà zi Jòvánì ta ꞌbí o náa Èródè giì bàkà kàrámà o bà jò yí ji ndâ kpo-kpò ꞌduù gbí ngbàngà mì wó, ta ndâ kpóló-kpolo ꞌduù Gàlìléyà. ");
INSERT INTO ndz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ta o kàrámà tí nò, nájú Èródìyà giì peteke tàkòcò ndâ Èródè ta ndâ wiṛi mì wó ta bà dù ṛu ji ndú. Tacó énò, Èródè giì ꞌdè cò ji ꞌvinî tí nò énó máa, yí nì ṛè ŋa i tí nó ta go  tí wó nó ji yì, wàa yì ꞌví je ji yí. ");
INSERT INTO ndz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Èródè giì see tí wó ji ꞌvinî tí nò énó máa, «Nì ṛè i ŋìnó ta go  tí lo nó ji ye wàa ye ꞌví je ji wò. Wo kpêtí má nì káa kacì to mì ye, ye bà je ji wò gî.» ");
INSERT INTO ndz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Káa làmbu ꞌvinî tí nò giì ŋò ŋa i ŋìnó náa yí ꞌví ꞌdè có  ꞌdo tí Èródè nó lá. Tacó énò, yí giì co ta ngèlè ya gí bà ꞌvee nawu wó gítí ŋa i tí nó náa yì ꞌví ꞌdè có  nô. Káa nawu wó giì kpo-gbí-tà-tù wó máa, «Ya gí bà ꞌdè có ji gbolò gba énó máa, ‹Je muu Jòvánì ji ye.› » ");
INSERT INTO ndz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bìndi  ꞌvinî tì nò giì dele ndì wó ta ngèlè gálà ya gí mì gbolò gba, bìndi  yí giì ꞌdè có ji yí máa, «À tí ye a go muu Jòvánì, ká kpónó mí to nô, á mí gbí kùṛùngbú tí nô.» ");
INSERT INTO ndz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sé bà ꞌdi ŋa có tí nò giì bàkà Èródè ngé ndii gî, káa kpokèjì bà ꞌvìsì ꞌbí ŋa tende có giì kpo yí gî, tacó a yí tí gbolò gba ká ꞌdè có ta nje wó ji ꞌvinî tí nò á mí kùṛo ndâ kpo-kpò wiṛi mì wó énó máa, yí nì ṛè i tí nó ta go  tí wó nó ji yì. ");
INSERT INTO ndz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tacó énò, yí ngé giì tuu àsìkérì énó máa, yí ya gí bà ꞌdè có ji ndâ mbe kpolo tí ndâ ꞌduù gbí zàà énó máa, ndú da muu Jòvánì gì tí  ji ꞌvinî tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Àsìkérì tí nò mâ giì gì ta muu Jòvánì á gbí kùṛùngbú gî, ꞌvinî tí nò giì te ya tí  ji nawu wó. ");
INSERT INTO ndz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ndâ mbe tala có mì Jòvánì mâ giì ꞌdi có tí nò, ndú giì te ku wó, ndú giì duu gî. ");
INSERT INTO ndz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ndâ tú mì Jézù giì dele ndi ndú bìndi bà tuu ndú mì wó gì gí bà dìtà ndâ i ŋìnó náa ndú bàkà nó, ta ndâ i ŋìnó náa ndú nìbà ji ndâ ꞌduù nó ji yí. ");
INSERT INTO ndz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Káa Jézù giì ꞌdè có ji ndú máa, «Ndoo yèè gí ndiì gítí ꞌbí bàndò ta ndâ ꞌduù tí wálá, wàa yo ꞌví tèwo yo njíꞌdí.» Yí ꞌdè có tí nò tacó ndâ ꞌduù ta o tí nò kû gì gí mì ndú me mbè ngé ndii gî, káa kpokèjì bà tèwo ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bìndi  ndú giì ya ta gbâ gí ndiì ta kpéétí ndú gítí ꞌbí bàndò ta ndâ ꞌduù tí  wálá. ");
INSERT INTO ndz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Káa keèlá, ta o tí nò náa ndú kû ya gítí bàndò tí nò nò, ndâ ꞌduù me mbè ŋò ndú ni gî. Tacó énò, ndâ ꞌduù me mbè giì kaa ta ngèlè ꞌdo gbí ndâ gbata ya gí bà cu kùṛo ndú. ");
INSERT INTO ndz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ndú giì oloko gí to ꞌdo gbí gbâ ká jé mítí ndâ ꞌduù bìnjìì to. Yê ṛo ndâ ꞌduù tí nò giì bàkà Jézù ngé ndii gî, tacó ndú go ndâ rómbo ta mbe gbà ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ndâ mbe tala có mì Jézù mâ giì ŋò énó máa, o kû giì béé-bèè, ndú giì ꞌdè có ji yí máa, «Ndoo kpónó tí bàndò ŋìnó ta ndâ ꞌduù ta ꞌbá tí  wálá, káa o kû ndíí-ndii. ");
INSERT INTO ndz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Njè ndâ ꞌduù tí nò gî, tacó wàa, ndú ꞌví ya ta sè ṛi nó gí bà pà i-zó-zò ꞌdo mì ndâ ꞌduù ta ndi tí ndâ ꞌbá ta to nò.» ");
INSERT INTO ndz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Káa Jézù giì ꞌvìsì có ji ndâ mbe tala có mì wó, máa, «Yo je i-zó-zò ji ndú.» Káa ndú giì ꞌvee yí máa, «Nògí, wò kpónó kû koṛo có máa, àá mì ze a yè tacó bà sì ta i-zó-zò tè ta ŋa mbè ꞌduù tí nò?» ");
INSERT INTO ndz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Káa Jézù giì ꞌvee ndú, máa, «Àá mì yo a ndâ kù kô ée? Yo ya gí bà ŋò gi.» Ndú mâ giì ya gí bà ŋò ndâ kù kô mì ndú, ndú giì dele ndi ndú gì gí mì Jézù, bìndi  ndú giì ꞌdè có ji yí máa, «Àá mì ze a ndâ kù kô vô, ta ndâ njì sè sósòꞌô.» ");
INSERT INTO ndz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bìndi  Jézù giì ꞌdè có ji ndú, máa, ndú ꞌdè có ji ndâ ꞌduù tí nò ꞌdáá gî máa, ndú ki tí ndú to, ta bà muu ndú, bà muu ndú, á gbí dó mbílì. ");
INSERT INTO ndz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ndâ ꞌduù mâ giì ki tí ndú to ta bà muu ndú, bà muu ndú, go có tí nò náa Jézù ꞌdè nò gî, bà muu ndâ ꞌbí ꞌduù ziꞌduù-vô, bà muu ndâ ꞌbí ꞌduù ziꞌduù-só-nje muuꞌbì, ");
INSERT INTO ndz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jézù giì kaa ndâ kù kô tí nò vô nò, ta ndâ njì sè tí nò sósòꞌô nò mí ꞌbì wó. Bìndi  yí giì zekeꞌo gí gbíṛì, yí giì ùlù Mbíṛì, bìndi  yí giì ꞌdè nìkì maa mítí ndâ kù kô, bìndi  yí giì kiꞌviki gbí ndú, yí giì kaa mí kùṛo ndâ mbe tala có mì wó, bìndi  yí giì ꞌdè có ji ndú máa, ndú njèè ji ndâ ꞌduù, wàa ndú delè giì njèè gbí ndâ njì sè tí nò sósòꞌô nò á ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ndâ ꞌduù ꞌdáá gî giì zò i yè yì ndú go ŋìnó náa à nìkì tí ndú. ");
INSERT INTO ndz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bìndi  à giì kili ndâ sè i-zó-zò mbe kpò ndâ ꞌduù gî yeke ndâ kèè muuꞌbì-nje só. ");
INSERT INTO ndz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Muu ndâ ꞌduù tí nò náa Jézù je i-zó-zò ji ndú nò ꞌdáá gî a ndâ ꞌdakò álìfì vô, náa à ꞌdeke muu ndâ niì ta ndâ ꞌviì mí gbí  lá. ");
INSERT INTO ndz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ndâ ꞌduù mâ giì zò i cee gî, Jézù ngé giì je nó ji ndâ mbe tala có mì wó, máa ndú o gbâ, wàa ndú ꞌví di kàpá gí kùṛo á gí gbí gbata Bètìsàyídà. Yí giì dù kuu ndiì ta kpéétí wó kû njè ndâ ꞌduù tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yí mâ giì nì «Yo ꞌví ya ndì» á ji ndâ mbe tala có mì wó ta ndâ ꞌduù ꞌdáá gî gî, yí giì ya gí pí gú gí bà ùlù Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Káa ta ꞌdêꞌo, si ndâ mbe tala có mì wó kuu muu nó ta gbâ á ṛo ngo, káa yí kuu tì ngo kálásê, ");
INSERT INTO ndz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","yí giì ŋò máa, wo ndú co ta bà aa ngo gî, tacó pípìṛi ta o tí nò kû pì ꞌdo kùṛo ndú. Bìndi  ta nje yé Jézù giì njè nó ta kò wó có ṛo ngo kû ya gí mì ndú. Yí giì bàkà tí wó go ꞌduù ŋìnó mbe kû ndii ta seè tí ndú ká ndii nô. ");
INSERT INTO ndz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Káa ndú mâ giì ŋò yí, ndú giì koṛo có ŋìndi ndú máa, a vuuvuu ká co mítí ndâ yì. Bìndi  ndú giì tò kû ta kòcò ndú ngéé gí yaà, ");
INSERT INTO ndz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tacó ta o tí nò gúku bàkà ndú ꞌdáá gî ta bà ŋò yí ngé ndii gî. Káa yí ngé giì ꞌdè có ji ndú, máa, «Yo zèè njembí yo. A ye. Yo cì gúku lá.» ");
INSERT INTO ndz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bìndi  yí mâ giì o gí tàkò ndú gbí gbâ gî, pípìṛi giì ṛò tíyò gî. ");
INSERT INTO ndz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nje ndú giì ꞌdèè gî gítí bà ṛò tíyò mì pípìṛi tí nò, tacó ndú ꞌdi gbí có gítí seṛè bà ko ndâ ꞌduù álìfì vô mì wó ta kù kô nó lá, káa muu ndú giì eṛe tí gî. ");
INSERT INTO ndz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ndâ Jézù ta ndâ mbe tala có má giì di kàpá gí Jènèsàrétì gî, ndú giì eṛe gbâ mì ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Káa à káa póó bà giì oloko ndú ꞌdo gbí gbâ gí to, ndâ ꞌduù ngé giì ŋò Jézù ni gî. ");
INSERT INTO ndz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bìndi  ndú giì njè ta ngèlè cee tí ndâ ꞌbá tí nó dê-dê nó ꞌdáá gî, kû tuṛu ndâ mbe nòꞌo ya tí  ji yí gítí bàndò tí nò náa ndú ꞌdi có tí wó tí  nô. ");
INSERT INTO ndz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yí má yee tí bàndò ngé gî, ndâ ꞌduù kû gbaa ndâ mbe séꞌi mí kùṛo wó, ta bà ꞌdeke tí ndú ji yí, máa yí si ndú ꞌví tee ká ꞌbì ndú mítí vòó bòngo tí wó, tacó wàa ndú ꞌví ꞌde ta ꞌvala. Káa ndâ ꞌduù ŋìnó mbe tee ꞌbì ndú mítí bòngo tí wó nó ꞌdáá gî giì ꞌde ꞌválá gî. ");
INSERT INTO ndz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ta o tí nò ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà ta ndâ ꞌbí kpo-kpò mbe nìbà i mì ndú mbe gì ꞌdo Jèrùzàlémè giì kili mí ṛègbà tí Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ndú giì ŋò ndâ ꞌbí mbe tala có mì wó kû zò i si ndú caka ꞌbì ndú go có mì Mòze lá. ");
INSERT INTO ndz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Káa ndú tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà ta sè ndâ ꞌbí Jùdéyà ta o ꞌdáá gî kû ṛu ndi tàkìì mì ndâ ká gù ndú. ");
INSERT INTO ndz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ndú má gì ꞌdo bàndò ꞌvélè, ndú kpédéléꞌi ngbaṛanga a tí ndú má kózò gî, bìndi  ndú bà giì zò i. Delè ndâ ꞌbí i gbí tàkìì mì ndú náa ndú jé ò bà mbí ndú lá, a bà caka ndâ ꞌvisî, ta ndâ káṛà, ta ndâ káꞌi bà bàkà i-zó-zò. ");
INSERT INTO ndz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà ta ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà mâ giì ŋò ŋa i-gìlìnì tí nò náa ndâ mbe tala có mì Jézù kû bàkà nò, ndú giì ꞌvee yí, máa, «Tacó yè káa ndâ mbe tala có mì lo te duù mítí tàkìì mì ndoo tí ndâ Jùdéyà lá? Ndú caka ꞌbì ndú kùṛo bà zò i go có mì Mòze lá, tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Káa yí giì ꞌvìsì có ji ndú, máa, «Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì ꞌdè gítí yo ndâ ꞌduù tí nó tí ndâ mbe nambeè-ṛo nó dú káa yúcó, á go ŋìnó náa a cu mì gbí wáràgà mì Mbíṛì, máa, ‹Ndâ ꞌduù tí nò te duù mítí ye ká ta nje ndú, káa njembí ndú me ꞌdú ꞌdo tí ye. ");
INSERT INTO ndz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ndú kucuku muungbó ndú mí kùṛo ye ká sínò, káa ndú kû nìbà a có mì ndâ ꞌduù, káa ndú bàkà tí ndú tí ndâ mbe nìbà có mì Mbíṛì.› ");
INSERT INTO ndz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yo zèè kpolo kácá-kácá a có mì ndâ ꞌduù, jee có mì Mbíṛì mí to.» ");
INSERT INTO ndz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Bìndi  Jézù giì ꞌdè có ji ndú, máa, «Yo dú káa ndâ mbe tiṛì. Yo mò có mì Mbíṛì gí nje seè gî, bìndi  yo giì si kpolo ma a ꞌdóó tàkìì mì yo. ");
INSERT INTO ndz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mòze ꞌdè có énó máa, ‹Te duù mítí ndâ bu lo ta nawu lo.› Yí delè giì ꞌdè ꞌbí có énó máa, ‹À ꞌvii ta ꞌduù ŋìnó mbe be ndâ bu wó ta nawu wó nó káa ku.› ");
INSERT INTO ndz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Káa ŋa bà nìbà i mì yo ká tende. Yo kû nìbà i énó máa, ꞌduù má ꞌdè có ji ndâ bu wó ta nawu wó énó máa, yì ci i tí nó náa yì máa yì bà konì ta ndú nó ji Mbíṛì gî, gbí  énó máa, ");
INSERT INTO ndz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","yí kákáꞌi je i tí nò náa yí nì ṛè Mbíṛì á mí muu  gî nò á ji ndâ bu wó ta nawu wó gbí tàkìì mì yo lá. ");
INSERT INTO ndz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gbí ŋa ndâ kpokèjì tí nò, yo giì si tí có kpolo ma a ndâ i gbí tàkìì mì yo náa yo kû nìbà  ji ndâ ꞌviì mì yo, ta ndâ ꞌbí ŋa ndâ i mì yo go ŋìnò, á bìndi có mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ta o tí nò Jézù giì tèꞌé tí ndâ ꞌduù gí mì wó kákáꞌi. Bìndi  yí giì ꞌdè có ji ndú, máa, «Yo sè tù yo, wàa yo ꞌví ꞌdi ta có tí nô. ");
INSERT INTO ndz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ꞌBí ŋa i náa ꞌduù zò gí gbí yì wó mbe giì bàkà yí tí zu ꞌduù nò wálá. À káa ndâ i ŋìnó mbe co gí sè ꞌdo gbí yì ꞌduù nó ká bàkà yí tí zu ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tù bà ꞌdi có má kuu tí muu ꞌduù, yí ꞌví ꞌdi có tí nò.» ");
INSERT INTO ndz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Káa ndâ Jézù mâ giì ya gí ꞌbá ta ndâ mbe tala có mì wó ta kpéétí ndú gî, ndú giì ꞌvee yí gítí gbí lòkóꞌbò tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Káa yí giì ꞌvìsì có ji ndú énó máa, «Yo delè ngbá ꞌdi gbí lòkóꞌbò tí nò lá? Yo ŋò ni lá máa, i ŋìnó mbe ya gí gbí yì ꞌduù nó bàkà yí tí zu ꞌduù lá nò lá? ");
INSERT INTO ndz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yo ŋò ni lá máa, i-zó-zò tí nó náa ꞌduù kû zò nó ya me gí gbí njembí wó lá, a kû ya a i gí gbí yì wó, bìndi  à giì ndii ya gí tà mbílì?» Jézù ꞌdè có tí nò tacó bà tùbà  ji ndâ ꞌduù énó máa, ndâ i-zó-zò ꞌdáá gî káa ndâ ngbáṛángà i. ");
INSERT INTO ndz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Bìndi  Jézù giì ya gí kùṛo ta bà ꞌdè có ji ndú énó máa, «Ndâ i ŋìnó mbe co ꞌdo gbí yì ꞌduù nó ká bàkà yí tí zu ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Go ndâ vo-vò kóṛó-koṛo có, ta bà koṛo có gítí bà-nò-vò-ndô, ta bà koṛo có gítí bà ngbà i, ta bà koṛo có gítí bà zi ku, ");
INSERT INTO ndz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ta bà koṛo có gítí bà bàkà bangbaya, ta bà zingbà ta ndâ nawù ꞌdakò, ta bà dù ta gbolò njembí, ta bà koṛo có gítí bà bàkà gìlìnì, ta bà koṛo có gítí bà eendi ꞌduù, ta bà koṛo có gítí bà bàkà ndâ i ta vò kèjì, ta bà koṛo có gítí bà tò kiì, ta bà koṛo có gítí bà nì ṛè, ta bà si tí ꞌduù tí gbolò i, ta bà bàkà tí ꞌduù tí gbàꞌdá ji Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A ŋa ndâ vò i tí nò ꞌdáá gî mbe có ꞌdo gbí yì ꞌduù nó ká bàkà yí tí zu ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bìndi  Jézù giì njè nó ya gí gbí to Tírò. Káa yí giì ngùù tí wó mí tàꞌi, tacó wàa, gbèe ꞌduù ꞌví ŋò yì lá, káa bà ngùù tí wó giì kpò yí gî. ");
INSERT INTO ndz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Káa ta o tí nò, ꞌbí niì tí jú ndâ tende ŋa ndâ ꞌbí ꞌduù ta ṛè ŋa ndú a ndâ Sìròfònésìyà, ta i-gbí-muu làmbu nájú wó, mâ giì ꞌdi có tí Jézù, yí ngé giì ya gí mì wó, yí giì ꞌva tí wó mí kùṛo wó, yí giì ꞌdeke tí wó ji yí máa, yí mòkò i tí nò ꞌdo gbí muu nájú yì gî. ");
INSERT INTO ndz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Káa Jézù giì ꞌvìsì có ji niì tí nò máa, «Je i-zó-zò á ji ndâ ꞌviì kùṛo má kózò gi, tacó bà ꞌva i-zó-zò mì ndâ ꞌviì ji ndâ bô me yúcó lá.» ");
INSERT INTO ndz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Káa niì tí nò giì ꞌvìsì có ji Jézù, máa, «Có mì lo a yúcó, mbe tí ye, káa à kpêtí ká énò, ndâ bô delè kû zò ndâ njúnjú i-zó-zò ŋìnó mbe ꞌvaka tí to ꞌdo mì ndâ ꞌviì nô.» ");
INSERT INTO ndz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bìndi  Jézù giì ꞌdè có ji niì tí nò, máa, «Njè nó, wàa wò ꞌví ya gí ꞌbá ta peteke tàkòcò lo. Nájú lo ꞌde ꞌválá gî, tacó ŋa có tí nò náa wò ꞌdè nò.» ");
INSERT INTO ndz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Káa niì tí nò mâ giì dele ndi wó ya gí ꞌbá, yí giì ꞌde nájú wó tí cèe ꞌduù kuu tísì. ");
INSERT INTO ndz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jézù giì dele ndi wó ꞌdo Tírò có Sìdónì co tí kpokèjì tí nó mbe mò gí yì kàpá Gàlìléyà, mbe kû ndii co gbí ꞌbí wúngbó to náa à kû nì mítí  a Ndâ-gbata-muuꞌbì nô. ");
INSERT INTO ndz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bìndi  ndâ ꞌduù giì gì ta ꞌbí ꞌdakò náa tù wó yoo gî, dele mbe ꞌdè có lá, ji Jézù. Ndú giì ꞌdeke tí ndú ji yí máa, yí tee ꞌbì wó mítí ꞌdakò tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Káa Jézù giì je ꞌdakò tí nò gí ndiì ta kpéétí wó á ꞌdo gbí òkò ndâ mbè ꞌduù tí nô. Yí giì yuu ndâ sìlì ꞌbì wó mí gbí ndâ tù ꞌdakò tí nò mbe yoo gî nò, bìndi  yí giì cù cù mítí ꞌbì wó, bìndi  yí giì tee mítí mè ꞌdakò tí nò mbe ꞌdè có lá nò delè. ");
INSERT INTO ndz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bìndi  yí giì zekeꞌo gí gbíṛì, yí giì wo gù woò, bìndi  yí giì ꞌdè có ji mbe sú tù tí nò máa, «Éfàtà,» (gbí  máa, «Njaanga tí»). ");
INSERT INTO ndz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bìndi  ndâ tù ꞌdakò tí nò ta mè wó ngé giì njaanga tí gî. Yí giì ꞌbìtà bà ꞌdè có ta kòcò wó ngbáṛángàꞌi. ");
INSERT INTO ndz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Káa Jézù giì ꞌdè có ji ndâ mbè ꞌduù tí nó máa, ndú ꞌví ꞌdè có ndâ i tí nò náa yì bàkà nò gí sè ji gbèe ꞌduù lá. Káa yí má kû ꞌdè có ji ndú máa ndú ꞌví ꞌdè gí sè lá, à giì dù nò a bà giì gì líkíꞌo bà kò-kò tí  gítí ndâ ꞌduù tí nò ngéé gí yaà. ");
INSERT INTO ndz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nje ndâ mbe ꞌdi tàwo ndâ i tí nò náa Jézù bàkà nò ꞌdáá gî giì ꞌdèè gî. Ndú giì ꞌdè có máa, «Yí bàkà ꞌdáá káa ndâ tó i. Yí bàkà ndâ mbe sú tù kû ꞌdi có. Yí delè giì bàkà ndâ ꞌduù ŋìnó ta mè ndú mbe eṛe tí gî nó kû ꞌdè có.» ");
INSERT INTO ndz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ta o tí nò ndâ ꞌduù giì kili me mbè ya gí mì Jézù kákáꞌi. Káa i tacó bà zò  mì ndú giì dù wálá. Tacó énò, Jézù giì tèꞌé tí ndâ mbe tala có mì wó, yí giì ꞌdè có ji ndú, máa, ");
INSERT INTO ndz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Yê ṛo ndâ ꞌduù tí nò tí ye ngé, tacó ndú kpónó bàkà ta ye a sili taꞌô, káa kpónó gbèe i tacó bà zò  mì ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Káa ye má njè ndú ta go tí ndú, ndú bà ŋonoko ta go mí kpokèjì gî, tacó kpokèjì ꞌbá mì ndâ ꞌbí ꞌduù gbí òkò tí ndú me ꞌdú ngé.» ");
INSERT INTO ndz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Káa ndâ mbe tala có mì Jézù giì ꞌvìsì có ji yí máa, «ꞌDuù bà ꞌde i-zó-zò bà je ji ŋa ndâ mbè ꞌduù tí nó á ꞌdo ngòó gbí ꞌdú to tí nó?» ");
INSERT INTO ndz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Káa yí giì ꞌvìsì có ji ndú, máa, «Àá mì yo á ndâ kù kô ée?» Ndú giì ꞌdè có ji yí, máa, «Vô-nje só.» ");
INSERT INTO ndz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bìndi  yí giì ꞌdè có ji ndâ mbè ꞌduù tí nò, máa, «Yo ki tí yo to.» Ndâ ꞌduù tí nò mâ giì bàkà go có tí nò náa yí ꞌdè ji ndú nò gî, yí giì kaa ndâ kù kô tí nò mí ꞌbì wó, yí giì ꞌdè nìkì maa ji Mbíṛì. Bìndi  yí giì kiꞌviki gbí ndú, yí giì kaa ji ndâ mbe tala có mì wó. Bìndi  yí giì ꞌdè có ji ndú máa, «Yo njèè ji ndâ ꞌduù tí nò.» ");
INSERT INTO ndz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ta o tí nò ndâ ꞌbí víí sè kuu mì ndâ mbe tala có mì Jézù. Mâ giì zekeꞌo, Jézù giì kaa ndâ víí sè tí nò, yí giì ùlù Mbíṛì tacó tí ndú, bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó, máa, «Yo njèè ndâ sè tí nò ji ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ndâ ꞌduù ꞌdáá mâ giì zò i yè yì ndú gî, à giì kili sè i-zó-zò bìndi ndú yeke ndâ kèè vô-nje só. ");
INSERT INTO ndz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Muu ndâ ꞌduù mbe zò i ta o tí nò ꞌdáá gî go álìfì nàꞌô. ");
INSERT INTO ndz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bìndi bà zò i mì ndâ ꞌduù tí nò, Jézù giì njè ndú máa, «Yo ya gí ꞌbá mì yo.» Ndâ ꞌduù tí nò mâ giì njè gî, ndâ Jézù ta ndâ mbe tala có mì wó ngé giì di ngo ta gbâ gí tìto, gí gbí ꞌbí to ta ṛè  a Dàlìmànútà. ");
INSERT INTO ndz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ta o tí nò ndâ ꞌbí mbe kû kpolo tí tàkìì mì ndâ Jùdéyà, náa a kû nì mítí ndú a ndâ Fàrìzéyò, giì ꞌvee Jézù tacó bà tala yí énó máa, «A Mbíṛì ká je wotí bà nìbà i ji wò? À dú má káa yúcó, bàkà ꞌbí i ji ze, wàa ze ꞌví ŋò ni mítí i tí nò máa, a Mbíṛì ká je wotí tí nò ji wò.» ");
INSERT INTO ndz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Káa Jézù giì ṛengà gbí yì wó, bìndi  yí giì ꞌvìsì có ji ndú, máa, «Ndâ ꞌduù tí nó gbí o tí nó nó kû ꞌvee có mbó tacó yè? À nìkì ma, káa à má énò, ye jé gí bà bàkà seṛè ji yo wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bìndi  yí giì di ngo ta gbâ gí tìto kákáꞌi, jee ndú mí to. ");
INSERT INTO ndz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ta o tí nò ndâ mbe tala có mì Jézù giì ò bà mbí bà te i-zó-zò ta ndú gî. À ta o tí nò mì ndú káa gbèe kù kô gbí gbâ. ");
INSERT INTO ndz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Káa Jézù giì ꞌbìtà bà kpo-gbí-tà-tù ndú, máa, «Yo kpolo tí yo ꞌdo tí ṛúꞌbù mì ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, ta ṛúꞌbù mì Èródè tí gbolò gba.» ");
INSERT INTO ndz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Káa ndú giì ꞌbìtà bà fiini có á gbí òkò tí ndú ta kpéétí ndú, máa, «Yí kû ꞌdè có tí nò tacó kù kô mì ndoo wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Káa Jézù giì ꞌdi gbí có tí nò náa ndú kû fiini nò gî. Bìndi  yí giì ꞌvee ndú, máa, «Yo kû fiini có máa, kù kô mì yo wálá, tacó yè? Yo ŋò ni kálásê? Yo ꞌdi gbí có kálásê? Muu tí yo wálá? ");
INSERT INTO ndz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","À tí muu yo nò me ndâ ṛo bà ŋò i lá? À tí muu yo nò me ndâ tù bà ꞌdi có lá? Bà mbí yo ó-ò? ");
INSERT INTO ndz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ta o tí nó táánò náa ye kiꞌviki gbí ndâ kù kô vô tacó tí ndâ ꞌduù álìfì vô nó, sè i-zó-zò náa à ṛuka yeke a ndâ kèè ée?» Káa ndú giì ꞌvìsì có ji yí, máa, «À ṛuka yeke a ndâ kèè muuꞌbì-nje só.» ");
INSERT INTO ndz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jézù kákáꞌi giì ꞌvee ndú, máa, «Káa ta o tí nò náa ye kiꞌviki gbí ndâ kù kô vô-nje só tacó tí ndâ ꞌduù álìfì nàꞌô nó, yo ṛuka sè i-zó-zò yeke a ndâ kèè ée?» Ndú giì ꞌvìsì có ji yí, máa, «Yeke ndâ kèè vô-nje só.» ");
INSERT INTO ndz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bìndi  Jézù giì ꞌvee ndú, máa, «Káa yo ꞌdi gbí i kálásê?» ");
INSERT INTO ndz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì gì gí Bètìsàyídà, ndâ ꞌbí ꞌduù giì gì ta ꞌbí ꞌdakò náa ṛo wó yoo gî ji yí. Ndú giì ꞌdeke tí ndú ji yí, máa, yí tee ꞌbì wó mítí mbe sú ṛo tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Káa Jézù giì zèè ꞌbí mbe sú ṛo tí nò, yí giì ja yí ya tí  gí ndiì ꞌdo gbí òkò ndâ ꞌbá gí nje jìlì. Bìndi  Jézù giì cù cù mítí ṛo mbe sú ṛo tí nò. Yí giì tee ꞌbì wó mítí wó. Bìndi  yí giì ꞌvee yí, máa, «Wo kpónó kû ŋò i?» ");
INSERT INTO ndz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Káa ꞌdakò tí nò giì te ṛo wó gí yaà, bìndi  yí giì ꞌvìsì có ji Jézù, máa, «Ye kû ŋò ndâ ꞌduù, káa ndú gbíṛo ye go ndâ mû kû nò nó nô.» ");
INSERT INTO ndz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jézù mâ giì tee ꞌbì wó kákáꞌi mítí ṛo ꞌdakò tí nò, ndâ ṛo ꞌdakò tí nò giì njaanga tí mbóꞌvóó gî. Yí giì ꞌbìtà bà ŋò ndâ i ꞌdáá gî ngbáṛángàꞌi. ");
INSERT INTO ndz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bìndi  Jézù giì je nó ji yí, máa, «Ya jáá gí ꞌbá mì lo; wò ꞌví loko co gbí gbata lá.» ");
INSERT INTO ndz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Si ndâ Jézù ta ndâ mbe tala có mì wó muu nó kû nò ta gbí ndâ to ta seè gbata Cèzàríyà mì Fìlípò, Jézù giì ꞌvee ndú, máa, «Ndâ ꞌduù kû ꞌdè có máa ye a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Káa ndâ mbe tala có mì wó giì ꞌvìsì có ji yí máa, «Ndâ ꞌbí ꞌduù kû ꞌdè có máa, wò a Jòvánì tí mbe caka tí ndâ ꞌduù; ndâ ꞌbí ꞌduù kû ꞌdè có máa, wò a Èlíjà tí mbe ꞌdòkò có mì Mbíṛì táánò sàà; káa ndâ ꞌbí ꞌduù kû ꞌdè có máa, wò a ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ ká mbe ꞌdòkò có mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Káa Jézù kákáꞌi giì ꞌvee ndú máa, «Káa yo, ŋìndi yo kû ꞌdè énó máa ye a ꞌdi?» Bìndi  Pìyétòrò tí Sìmónè giì ꞌvìsì có ji yí, máa, «Wò a Bìndi-Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Káa Jézù giì kpo-gbí-tà-tù ndú máa, ndú ꞌví ꞌdè gí sè ji ꞌbí ꞌduù gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bìndi  Jézù giì ꞌbìtà bà nìbà i ji ndâ mbe tala có mì wó énó máa, «ꞌViì-mì-ꞌDakò kèjì gí bà kònò a ndú tí ndâ séꞌi; àá bà giì kpì ngbàngà tí wó ji ndâ kpo-ꞌduù-ꞌbá, ta ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò mbe nìbà tàkìì mì ndâ Jùdéyà; àá kèjì gí bà zi yí gî, káa ta sili taꞌô bìndi ku mì wó, yí bà ꞌvala ndi wó á ꞌdo gbí muuꞌdú wó gî.» ");
INSERT INTO ndz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Bìndi bà ꞌdè có tí nò mí Jézù ngbáṛángàꞌi go énò ji ndú, Pìyétòrò giì ja Jézù gí nje seè. Bìndi  yí giì biya ŋa có mì wó náa yí ꞌdè ji ndú nò gî. ");
INSERT INTO ndz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Káa Jézù mâ giì ꞌvìsì tí wó gí ndiì, yí mâ giì ŋò sè ndâ ꞌbí mbe tala có mì wó, yí giì do mítí Pìyétòrò, máa, «Co ta ŋa có mì lo nò ꞌdo kùṛo ye gî, ndí lo Vò-ꞌduù-tí-nò. Wò kû koṛo me bà koṛo có mì Mbíṛì lá. Wò kû koṛo a cè bà koṛo có mì ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bìndi  Jézù giì tèꞌé tí ndâ ꞌduù me mbè ta ndâ mbe tala có mì wó á gí mì wó. Yí giì ꞌdè có ji ndú, máa, «Go bà ṛu ndi ye má tí ꞌduù, à nìkì énó máa, yí ò bà mbí miṛi wó gî, wàa yí ꞌví ꞌviindi tí wó á gítí ndâ bà kònò séꞌi ta ku. Bìndi  yí ꞌví gì gí bà ṛu ndi ye. ");
INSERT INTO ndz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tacó ꞌduù ŋìnó mbe kû kpolo tí miṛi wó nó bà cì gî. Káa ꞌduù ŋìnó mbe giṛi miṛi wó tacó tí ye, delè tacó tí Banga-Ngú-Có nó ká bà ꞌde ꞌválá.» ");
INSERT INTO ndz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bìndi  Jézù giì ꞌvee ndú, máa, «Yo koṛo có máa, ꞌduù bà ꞌde gbí  a yè, náa yí kpêtí má ꞌde ndâ i tí nó a muu to tí nó ꞌdáá gî, bìndi  yí ꞌví giṛi miṛi wó gî? ");
INSERT INTO ndz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ꞌDuù bà ꞌvìsì miṛi wó a ta yè a muu to tí nó? ");
INSERT INTO ndz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Káa à má ṛo ꞌduù a nô gítí ye, à delè má ṛo ꞌduù a nô có mì ye á kpónó kùṛo ndâ ꞌduù tí nó ta Mbíṛì mì ndú wálá, tí ndâ vóló-volo ꞌduù nó, nô ꞌduù tí nò delè wúnò bà dù á ṛo ꞌViì-mì-ꞌDakò ta o bà gì yí gbí ngba Bu wó ta ndâ tó basìlì.» ");
INSERT INTO ndz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jézù giì yee nje có mì wó ta bà kò-kò ji ndâ ꞌduù énó máa, «Ye kû ꞌdè có ji yo ta yúcó máa, ndâ ꞌbí ꞌduù kuu gbí òkò tí yo á mbe kû ṛò tíyò nó bà cì wálá di ká tí o tí nó náa ndú má ŋò bà zèè ꞌbá mì Mbíṛì gî.» ");
INSERT INTO ndz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jézù giì sì sili vô-nje gbaànjé á bìndi bà ꞌdè có mì wó ji ndâ ꞌduù tí nò, bìndi  yí giì kaa ndâ Pìyétòrò, ta Jákòmò, ta Jòvánì. Ndú giì ya ta ndú gí muu gú ta kpéétí ndú. Ndâ Pìyétòrò, ta Jákòmò, ta Jòvánì mâ giì zekeꞌo, ndú giì ŋò Jézù ꞌvìsì cè tí wó gî. ");
INSERT INTO ndz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ndú giì ŋò ndâ bòngo tí wó kû tòngbaà ólé-ólé ta ŋa  wálá. ");
INSERT INTO ndz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bìndi  ndú giì ŋò ndâ Èlíjà ta Mòze co kû ꞌdè nje ta Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Káa Pìyétòrò giì ꞌdè có ji Jézù máa, «Mbe tí ze, à nìkì go énó máa, ndoo sì ꞌbá á bà-i-nô. Si ze ꞌví tò ndâ ndùúṛù taꞌô: ꞌbí  gbaànjé ji wò, ꞌbí  gbaànjé ji Mòze, ꞌbí  gbaànjé ꞌví dù ji Èlíjà.» ");
INSERT INTO ndz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pìyétòrò ꞌdè có tí nò tacó yí ŋò ꞌdóó có náa yí bà ꞌdè gbí nje wó nó lá, tacó gúku zèè ndú ꞌdáá mbi gî. ");
INSERT INTO ndz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ndú mâ giì zekeꞌo, ndú giì ŋò kùlù mù te yiiga muu ndú gî. Bìndi  ndú giì ꞌdi kòcò ꞌduù kû ꞌdè có gbí kùlù mù tí nò énó máa, «Ŋìnó a kpóló-kpolo ꞌviì mì ye. Yo sè tù yo tí wó.» ");
INSERT INTO ndz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Káa ndâ Pìyétòrò ta ndâ ká wó mâ giì zekeꞌo gálà á gí seè tí ndú, ndú giì ŋò gbèe ꞌduù lá, à káa ndú ta ndâ Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Káa ta o tí nó si ndú kû dele gí tàgbà gú nó, Jézù giì kpo-gbí-tà-tù ndâ Pìyétòrò, ta Jákòmò, ta Jòvánì, máa, ndú ꞌví ꞌvanda ndi ndâ i tí nò mbe bàkà tí á mítí ndâ yì pí gú nó ji ꞌbí ꞌduù gbaànjé lá; ndâ có tí nò ꞌví dù ká gbí njembí ndú di tí o tí nó náa ꞌViì-mì-ꞌDakò ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî. ");
INSERT INTO ndz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tacó énó, ndâ Pìyétòrò giì kpolo tí ndâ có tí nò mí gbí njembí ndú. Káa ta ndâ o tí nó si ndú ta kpéétí ndú nó, ndú kû giì ꞌvee ꞌvé gbí òkò tí ndú, máa, «Gbí có tí nò máa, ꞌViì-mì-ꞌDakò bà giì ꞌvala ndi wó ꞌdo gbí muuꞌdú wó nò máa yè?» ");
INSERT INTO ndz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bìndi  ndú giì ꞌvee Jézù, máa, «Káa ndâ kpo-kpò mbe nìbà i kû ꞌdè có máa, a Èlíjà ká bà gì kpédéléꞌi tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Káa Jézù giì ꞌvìsì có ji ndú, máa, «À dú káa yúcó máa, Èlíjà ká bà gì kpédéléꞌi gí kùṛo tacó bà ꞌviindi ndâ i. Káa à wálá cu mí gbí wáràgà mì Mbíṛì énó máa, ꞌViì-mì-ꞌDakò bà kònò séꞌi ta wotí tí ; ndâ ꞌduù delè bà mèèkèꞌi tí wó gî? ");
INSERT INTO ndz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Káa ye kû ꞌdè có ji yo máa, à kpêtí ká énò, Èlíjà gì gî. Káa ndâ ꞌduù bàkà ta yí á go có mì ndú gbí njembí ndú, à go có tí nó náa a cu sàà mí gbí wáràgà mì Mbíṛì nó gî.» ");
INSERT INTO ndz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Káa ndâ Jézù, ta ndâ Pìyétòrò, ta Jákòmò, ta Jòvánì mâ giì dele ndi ndú gì gí mì sè ndâ ꞌbí mbe tala có mì wó, ndú giì ꞌde ndâ ꞌduù me mbè, ta ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà tì ꞌdee ndú gî. Ndú kû tò kponje ta ndú. ");
INSERT INTO ndz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Káa ndú mâ giì ꞌva ṛo ndú mítí Jézù, nje ndú ꞌdáá gî ngé giì ꞌdèè gî. Bìndi  ndú giì njè ta ngèlè gí bà ꞌvee yí. ");
INSERT INTO ndz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Káa Jézù giì ꞌvee ndâ mbe tala có mì wó, máa, «Yo kû tò a kponje yè ta ndâ ꞌduù tí nò?» ");
INSERT INTO ndz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Káa ꞌbí ꞌdakò gbaànjé ꞌdo gbí òkò tí ndâ mbè ꞌduù tí nò giì ꞌvìsì có ji yí, máa, «Mbe tí ze, ye gì ta ꞌviì mì ye ta kpùṛù i-gbí-muu wó ji wò. ");
INSERT INTO ndz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ta o tí nó náa i tí nò má a gî, yí kû ꞌva yí mí to ta pù gbí nje wó, ta bà zò gbí nje wó. Bìndi  dìì wó ꞌdáá gî kû giì kpolo go kù jìì. Ye ꞌdeke tí ye ji ndâ mbe tala có mì lo, máa, ndú mòkò i tí nò ꞌdo gbí muu wó, káa à giì kpò ndú gî.» ");
INSERT INTO ndz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Ye bà dù ta yo ndâ ꞌduù tí nó bàngû nó mbe ùnje gítí Mbíṛì lá nó ta o ée? Ye ꞌví bàkà ta yo a ŋa yè, wàa yo ꞌví ù ta nje gítí Mbíṛì ta njembí yo? Gì ta ꞌviì tí nò je.» ");
INSERT INTO ndz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bìndi  ndú giì gì ta ꞌviì tí nò ji Jézù. Káa i tí nò gbí muu ꞌviì tí nò mâ giì ŋò Jézù, yí ngé giì ngaka ꞌviì tí nò ta wotí tí . Bìndi  ꞌviì tí nò giì ꞌva tí wó to, kû giì mèṛèkè tí wó ta pù gbí nje wó. ");
INSERT INTO ndz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Bìndi  Jézù giì ꞌvee bu ꞌviì tí nò, máa, «I tí nò kò ꞌviì tí nò ta o ée?» ");
INSERT INTO ndz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Káa ꞌdakò tí nò giì ꞌvìsì có ji yí, máa, «ꞌDo gbí dó wó. Káa i tí nò cóó-cóó kû jèlè ká ta có bà zi yí, ta bà ꞌva yí mí tà wu, delè ta bà ꞌva yí mí tà ngo. Ŋò yê ṛo ze, wàa wò ꞌví konì ze, náa wotí má kuu tí lo nò.» ");
INSERT INTO ndz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Bìndi  Jézù giì ꞌvìsì có ji ꞌdakò tí nò, máa, «Náa wotí má kuu tí lo nò-oo! ꞌDuù má ùnje gítí Mbíṛì ta njembí wó gî, ꞌbí i mbe kpò yí bà dù wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bìndi  bu ꞌviì tí nò giì ꞌdè có ji Jézù ta njembí wó gbaànjé, máa, «Ye ùnje gî, káa à tè lá. À má énò, konì ye tacó wàa ye ꞌví ùnje ta njembí ye ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Káa Jézù mâ giì ŋò ndâ ꞌduù me mbè kû kaa ta ngèlè gì gí mì wó, yí giì do mítí i tí nò mbe kò ꞌviì tí nò nó, énó máa, «Co ꞌdo gbí muu ꞌviì tí nò gî, go có tí nó náa ye kû ꞌdè ji wò nô, ndi lo mbe sú tù mbe ni bà ꞌdè có lá. Wò delè kákáꞌi ꞌví dele ndi lo gí gbí muu wó lá.» ");
INSERT INTO ndz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ta bà ꞌdi có tí nò náa Jézù ꞌdè nò, i tí nò giì co ꞌdo gbí muu ꞌviì tí nò ta bà tò kû, delè ta bà ngaka ꞌviì tí nò ta wotí tí  ngé ndii gî. Yí giì ꞌva ꞌviì tí nò mí tísì go ku ꞌduù nô. Bìndi  ndâ ꞌduù me mbè giì ꞌbìtà bà ꞌdè có máa, «ꞌViì tí nò cee gî! ꞌViì tí nò cee gî!» ");
INSERT INTO ndz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Káa Jézù giì zèè ꞌbì ꞌviì tí nò, yí giì ja yí gí yaà, bìndi  ꞌviì tí nò giì ṛò tíyò ta kpéétí wó. ");
INSERT INTO ndz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jézù mâ giì nje nó ꞌdo bà-i-nò ya gí tàꞌi ta kpéétí wó gî, ndâ mbe tala có mì wó giì ya gí bà ꞌvee yí á tàbèngìì máa, «Káa bà mòkò i tí nò ꞌdo gbí muu ꞌviì tí nò kpò ze tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Káa Jézù giì ꞌvìsì có ji ndú, máa, «À kû mòkò ŋa ŋìnò ꞌdo gbí muu ꞌduù cuki ká ta bà ꞌdeke tí ji Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bìndi  ndâ Jézù giì njè nó ta ndâ mbe tala có mì wó kû ya gí Gàlìléyà. À gbí muu wó ta o tí nò a có máa, ndâ ꞌduù ꞌví ŋò bà tí ndâ yì lá. ");
INSERT INTO ndz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tacó ta o tí nò yí kû nìbà i ji ndâ mbe tala có mì wó énó máa, «Àá kèjì gí bà kpì ngbàngà tí ꞌViì-mì-ꞌDakò á ji ndâ ꞌdakò. Ndâ ꞌdakò tí nò bà zi yí gî, káa yí bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó bìndi sili taꞌô gî.» ");
INSERT INTO ndz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Káa ndâ mbe tala có mì wó ta o tí nò ꞌdi gbí có tí nò náa yí ꞌdè nò ni lá. Káa gúku bà ꞌvee yí gítí gbí  giì kpò ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ta o tí nò, ndâ Jézù ta ndâ mbe tala có mì wó mâ giì yee gbí gbata Kàpàrànáwùmù gî, káa si ndú kuu tàꞌi ta kpéétí ndú, Jézù giì ꞌvee ndú máa, «Yo kùtàá kû tò kponje gítí yè si kpokèjì?» ");
INSERT INTO ndz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Káa ndú giì njaa nje ndú gí tàkò ꞌvé mì wó nò lá, tacó ta o tí nó si ndú kpokèjì nó, ndú kû tò kponje máa, gbolò ꞌduù mbe co tí ndâ ka wó ꞌdáá gî gbí òkò tí ndâ yì a ꞌdi wè. ");
INSERT INTO ndz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Káa Jézù giì ki tí wó to, bìndi  yí giì tèꞌé tí ndâ mbe tala có mì wó muuꞌbì-nje só ꞌdáá gî gí mì wó, bìndi  yí giì ꞌdè có ji ndú, máa, «Duù ŋìnó ta go bà dù tí kpédélé ꞌduù á kùṛo ndâ ka wó tí wó gbí òkò tí yo nó ꞌví dù tí ndòngbú ꞌduù, yí delè ꞌví dù tí bòò mì ndâ ka wó ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bìndi  yí giì je làmbu ꞌviì gì tí  gí kùṛo ndú, yí giì liꞌvi ꞌviì tí nò mí njembí wó, bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó, máa, ");
INSERT INTO ndz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«ꞌDuù má te duù mítí làmbu ꞌviì go ꞌviì tí nò ta ṛè ye, gbí  énó máa, ꞌduù tí nò te duù nò a i mítí ye. Káa ꞌduù má te duù mítí ye, gbí  énó máa, ꞌduù tí nò te duù nò a i mítí mbe tuu ye.» ");
INSERT INTO ndz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Káa Jòvánì giì ꞌdè có ji Jézù, máa, «Mbe nìbà i ji ze, ze ŋò ꞌbí ꞌdakò náa yí me ta ndoo lá, kû mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ta ṛè mì lo. Káa ze giì ṛò yí ꞌdo tí ŋa nèté tí nò gî, tacó yí me ta ndoo lá.» ");
INSERT INTO ndz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Yo ṛò yí lá. Tacó mbe bàkà seṛè ta ṛè ye bà ꞌde njembí bà co gálà gí bà ꞌdè vò có gítí ye a bìndi ye wálá, ");
INSERT INTO ndz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","tacó ꞌduù ŋìnó mbe sogo ndoo lá nó a ꞌduù mì ndoo.» ");
INSERT INTO ndz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Bìndi  Jézù giì ꞌdè có ji ndâ mbe tala có mì wó, máa, «Ye kû ꞌdè có ji yo ta yúcó máa, ꞌduù kpêtí má cu káa vòó ngo mì lú gbí ꞌvisî ji yo tacó yo a ndâ ꞌduù mì ye, Mbíṛì bà ko mboo tàkò ngo mì wó nò ji yí kpêkù. ");
INSERT INTO ndz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Káa ꞌbí ꞌduù gbaànjé má dù tí mbe eendi ndâ víí ꞌviì mbe ùnje gítí ye ta njembí ndú, à nìkì go énó máa, à eṛe gbolò díí mítí miṛi wó, wàa à ꞌví ꞌva yí tí  gí tà ngo. ");
INSERT INTO ndz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","«Káa à máa ꞌbì lo ká si wò ꞌví bàkà vò i, da ꞌbì lo tí nò gí ꞌdè. À nìkì go énó máa, wò ya gí mì Mbíṛì ta gbèe ꞌbì lo co tí bà ya ta ndâ ꞌbì lo sósòꞌô gí gbí ꞌbá séꞌi, á gí gbí wu ŋìnó náa yí jé gí bà mee wálá. ");
INSERT INTO ndz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Káa à má kò lo ka si wò ꞌví bàkà vò i, da kò lo tí nò gí ꞌdè. À nìkì go énó máa, wò ya gí mì Mbíṛì ta gbèe kò lo co tí bà ya ta ndâ kò lo sósòꞌô gí gbí ꞌbá wu. ");
INSERT INTO ndz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Káa à má a ṛo lo ká si wò ꞌví bàkà vò i, aaka ṛo lo tí nò ꞌdo gbí kù kélè gî. À nìkì go énó máa, wò ya gí mì Mbíṛì ta gbèe ṛo lo co tí bà ꞌva wò ta ndâ ṛo lo sósòꞌô á gí gbí ꞌbá séꞌi, ");
INSERT INTO ndz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","náa gó wu kà jé ꞌdèè lá, delè wu tí nò jé mee lá. ");
INSERT INTO ndz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wu tí nò bà bàkà ndâ ꞌduù ꞌdáá gî tí kó zi. ");
INSERT INTO ndz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Zi a tó i. Káa gó zi má ꞌdèè gî, wò bà bàkà tí  a yè tacó wàa yí ꞌví me ta gó kákáꞌi? «Yo kpolo tí yo ꞌdo tí ndâ vò i, yo ꞌví dù ta ꞌdê njembí gbí òkò tí yo.» ");
INSERT INTO ndz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ta o tí nò, Jézù giì njè nó ꞌdo Kàpàrànáwùmù ya gí gbí ꞌbí to Jùdéyà á tì to Jòròdánìyà. Ndâ ꞌduù me mbè giì kaa ya gí mì wó kákáꞌi. Bìndi  yí giì ꞌbìtà bà nìbà i ji ndú go ŋìnó náa yí ta o ꞌdáá gî kû bàkà nô. ");
INSERT INTO ndz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Káa ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà mbe gì tacó bà tala yí giì ꞌvee yí, máa, «À me yúcó tacó tí ꞌduù bà njè niì mì wó lá?» ");
INSERT INTO ndz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Mòze ꞌdè có ji yo máa yè?» ");
INSERT INTO ndz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bìndi  ndú giì ꞌvìsì có ji yí, máa, «Mòze ꞌdè có ji ze máa, ꞌduù ꞌví cu wáràgà bà njè tí ji niì mì wó, bìndi  yí ꞌví njè yí gî.» ");
INSERT INTO ndz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Mòze ꞌdè có tí nò ji yo tacó yo a ndâ mbe ngbútù, mbe ꞌdi có mì Mbíṛì lá. ");
INSERT INTO ndz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Káa ꞌdo tí o bà ꞌbìtà bà suu to tí nó mì Mbíṛì, yí bàkà ndâ dì  ta na . ");
INSERT INTO ndz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ŋìnò a ndeṛè có tí nò náa ꞌdakò ꞌví si tí  ta ndâ bu wó ta nawu wó mí to, wàa ndú ꞌví dù ta nawù wó nó ká nò. ");
INSERT INTO ndz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Tacó Mbíṛì ŋò ndú go gbèe ꞌduù, me ndâ ꞌduù sósòꞌô kákáꞌi lá. ");
INSERT INTO ndz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","À má énò, ꞌduù ꞌví njè niì mì wó lá, tacó a Mbíṛì ka toko ndâ ꞌdakò ta niì gbí bà kò tí.» ");
INSERT INTO ndz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì ya gí ꞌbá gî, ndú giì ꞌvee yí gítí gbí có tí nò kákáꞌi. ");
INSERT INTO ndz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bìndi  Jézù giì ꞌvìsì có ji ndú máa, «ꞌDakò mbe njè niì mì wó, bìndi  yí giì kò ꞌbí niì, bàkà a gìlìnì gítí kpédélé niì mì wó. ");
INSERT INTO ndz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Delè niì mbe njè ꞌdakò mì wó, bìndi  yí giì kò ꞌbí ꞌdakò, bàkà a gìlìnì gítí kpédélé ꞌdakò mì wó.» ");
INSERT INTO ndz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bìndi  ndâ ꞌduù giì gì ta ndâ víí ꞌviì mì ndú ji Jézù, tacó wàa yí ꞌví cù ꞌdê ngo cù wó mítí ndú. Káa ndâ mbe tala có mì Jézù giì do mítí ndú. ");
INSERT INTO ndz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jézù mâ giì ŋò ndâ mbe tala có mì wó kû do mítí ndâ ꞌduù tí nò, tàkòcò wó giì kpolo gítí ndú ngé ndii gî, bìndi  yí giì ꞌdè có ji ndú, máa, «Yo si ndâ víí ꞌviì tí nò ꞌví gì gí mì ye, yo tii ndú lá, tacó ndâ ꞌduù tí nó náa Mbíṛì kû zogo ndú nó a ndâ ꞌduù go ŋa ndú nô. ");
INSERT INTO ndz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ye kû ꞌdè ji yo a cee kpóló-kpolo có, máa, ꞌduù má ùnje gítí bà dù tí bòò kùṛo Mbíṛì go i mì ndâ víí ꞌviì go ndâ ŋìnó lá, ꞌduù tí nò gí bà ꞌdò kò wó mí ꞌbá mì Mbíṛì gbaànjé wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yí bà-i-nò giì ꞌbìtà bà liꞌvi ndâ ꞌviì tí nò, kû cù ꞌdê ngo cù wó mítí ndú. ");
INSERT INTO ndz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Si Jézù kû giì njè nó ꞌdo bà-i-nò, ꞌbí ꞌdakò giì ì ngèlè ya gí bà kucuku muungbó wó mí to kùṛo wó. Bìndi  yí giì ꞌvee yí máa, «Tó mbe nìbà i, ye ꞌví bà bàkà a ŋa yè tacó wàa ye ꞌví ꞌde ta ꞌválá ŋìnó mbe cee lá nó?» ");
INSERT INTO ndz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Káa Jézù giì ꞌvìsì có ji yí máa, «Wò nì tó ꞌduù mítí ye tacó yè? Tó ꞌduù muu to tí nó á bìndi Mbíṛì wálá. ");
INSERT INTO ndz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wò ŋò ndâ có tí nó náa Mbíṛì je ji Mòze nó ni gî, ‹Zi ꞌduù lá. Bàkà bangbaya lá. Zingbà i lá. ꞌDè ꞌvéṛè lá. Te duù mítí ndâ bu lo ta nawu lo.› » ");
INSERT INTO ndz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Káa bìndi bà ꞌdi ndâ có tí nò, ꞌdakò tí nò giì ꞌvìsì có ji Jézù, máa, «Mbe tí ye, ye kpolo tí ndâ có tí nò ꞌdáá gî ꞌdo gbí ꞌviì.» ");
INSERT INTO ndz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Káa Jézù giì zeke ꞌdakò tí nò ngbóó ta líkíꞌo; bìndi  yí giì ꞌvìsì có ji yí máa, «ꞌBí i gbaànjé gboo ꞌdo mì lo gî. Ya gí bà sì ndâ i mì lo ꞌdáá gî gí ꞌdè, bìndi  wò ꞌví njèè mboo tàkò ndú ji ndâ mbe yê, bìndi  Mbíṛì bà ko mboo ndâ i mì lo nò ji wò ꞌdo gbíṛì, wàa wò ꞌví gì gí bà ṛu ndi ye.» ");
INSERT INTO ndz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Káa ta bà ꞌdi có tí nò, gbíṛo ꞌdakò tí nò ngé giì zuu gî. Bìndi  yí giì co gí sè ꞌdo bà-i-nò ta líkíꞌo tí wó wálá, tacó ndâ i mì wó ògbù ngé ndii gî, káa bà bè gbí ndú nìkì tí wó lá. ");
INSERT INTO ndz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bìndi  Jézù giì zekeꞌo jèlè yí, bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Bà ya ndâ mbe kpo-kpò i gí ꞌbá mì Mbíṛì ká kpolo gî le!» ");
INSERT INTO ndz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ta bà ꞌdi có tí nò, muu ndâ mbe tala có mì wó giì eṛe tí gî. Káa yí giì aanga muu wó ká mítí gbèe ŋa có tí nò, máa, «Àá ndâ ꞌviì mì ye, bà ya gí ꞌbá mì Mbíṛì ká kpolo gî le! ");
INSERT INTO ndz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","À peteke a bà ndii kècè co gbí gùù ngbàndú co tí bà ya ꞌduù ŋìnó ta ndâ kpo-kpò i ká mì wó nó gí ꞌbá mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nje ndâ mbe tala có mì Jézù ꞌdáá gî giì ꞌdèè gítí ŋa có tí nò gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú, máa, «À má énò, a ꞌdi ká bà ꞌde ꞌválá?» ");
INSERT INTO ndz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Káa Jézù giì zekeꞌo tí ndú, bìndi  yí giì ꞌdè có ji ndú máa, «À ji ndâ ꞌduù a pàṛà ngùù kpò diigba, káa i mbe kpò Mbíṛì wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bìndi  Pìyétòrò giì ꞌbìtà bà ꞌdè có ji Jézù, máa, «Káa ze? Ŋò káa ze jee ndâ i ꞌdáá gî mí to bìndi  ze giì gì kû ṛu ndi lo gi.» ");
INSERT INTO ndz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Káa Jézù giì ꞌvìsì có ji yí máa, «Ye kû ꞌdè có ji yo ta yúcó máa, ꞌbí ꞌduù gbaànjé mbe jee ꞌbá mì wó, ta ndâ náꞌvindí wó, ta ndâ námì wó, ta ndâ bu wó ta nawu wó, ta ndâ ꞌviì mì wó, ta ndâ to mì wó, mí to tacó tí ye, delè tacó tí Banga-Ngú-Có mì Mbíṛì, ");
INSERT INTO ndz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","náa Mbíṛì bà je ndâ ꞌbá, ta ndâ náꞌvindí, ta ndâ námì, ta nawuù, ta ndâ ꞌviì, ta ndâ to á ji ꞌduù tí nò ta bà  me mbè gí bìndi ndâ ŋìnó náa yí jee mí to nó wálá nò wálá, à delè bà mèèkèꞌi tí wó kpónó gî, káa yí bà ꞌde ꞌválá ŋìnó mbe cee lá nó bìndi ku mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","«Káa ndâ ꞌduù me mbè ꞌdo gbí òkò tí ndâ ꞌduù ŋìnó kpónó tí ndâ kùṛo ndâ ka ndú nó kèjì gí bà dù tí ndâ ndòngbú ꞌduù. Bìndi  ndâ ndòngbú ꞌduù bà dù tí ndâ ꞌduù kùṛo.» ");
INSERT INTO ndz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ta o tí nò, ndâ Jézù ta ndâ mbe tala có mì wó á kpokèjì kû ya gí Jèrùzàlémè, káa Jézù ŋìndi wó ta o tí nò kû nò a i ngéé kùṛo ndú. Bìndi  nje ndâ mbe tala có mì wó giì dù kaà ꞌdèè gî. Gúku delè giì zèè ndâ ꞌduù ŋìnó mbe kû ṛu ndi ndú nó ꞌdáá gî gî. Káa Jézù giì kaa ndâ mbe tala có mì wó muuꞌbì-nje só á gí nje seè ta kpéétí ndú, bìndi  yí giì ꞌbìtà bà ꞌdè có ji ndú gítí i tí nó náa àá kèjì gí bà bàkà ta yí nó, ");
INSERT INTO ndz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","énó máa, «Ndoo kpónó kû ya gí Jèrùzàlémè. Káa kùṛo bà kpì ngbàngà tí ꞌViì-mì-ꞌDakò ji ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà dooko gî. Ndú bà giì waa có ku mítí wó. Bìndi  ndú bà giì je yí ji ndâ ꞌbí tende ŋa ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ndâ tende ŋa ꞌduù tí nò bà giì ŋo ndi wó, ndú bà giì cù cù mítí wó, ndú bà giì gbì yí, ndú bà giì zi yí gî. Káa ta sili taꞌô bìndi ku mì wó, yí bà giì ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî.» ");
INSERT INTO ndz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ta o tí nò, ndâ Jákòmò ta náꞌvindí wó Jòvánì, tí ndâ ꞌviì mì Zèbìdéyò, giì gì gí mì Jézù. Bìndi  ndú giì ꞌdè có ji yí, máa, «Mbe nìbà i ji ze, go  kuu tí ze énó máa, wò bàkà nambeè ji ze.» ");
INSERT INTO ndz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Káa Jézù giì ꞌvìsì có ji ndú, máa, «À gbí njembí yo énó máa, ye ꞌví bàkà a ŋa yè ji yo?» ");
INSERT INTO ndz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bìndi  ndú giì ꞌvìsì có ji yí, máa, «Si ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ze ꞌví ki tí wó gbí kùꞌbì mì lo, wàa ꞌbí ꞌduù ꞌví ki tí gbí gàlì mì lo á gbí ngbàngà mì lo.» ");
INSERT INTO ndz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Yo ŋò i tí nó náa yo kû yù nó ni lá. Yo bà ni bà njù ꞌvisî tí nò náa ye kèjì gí bà njù nò gî? Yo bà ni bà ṛi ŋa bà ṛiṛí ngo tí nò náa ye kèjì gí bà ṛi nò gî?» ");
INSERT INTO ndz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Káa ndú giì ꞌvìsì có ji yí máa, «Ze bà ni bà bàkà ndâ i tí nò ꞌdáá gî gî.» Bìndi  Jézù giì ꞌvìsì có ji ndú, máa, «ꞌVisî tí nò náa ye kèjì gí bà njù nò, yo bà njù gî. Ngo tí nò náa ye kèjì gí bà ṛiṛí  nò, yo bà ṛi gî. ");
INSERT INTO ndz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Káa ndâ bàndò bà ki tí gbí kùꞌbì mì ye, ta bàndò bà ki tí gbí gàlì mì ye, me ndâ i mì ye tacó bà je ji yo lá. Ndâ bàndò tí nò a ndâ i mì ndâ mbe  náa à ꞌviindi ndú tacó tí ndú sàà gî.» ");
INSERT INTO ndz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Sè ndâ ꞌbí mbe tala có mì Jézù mâ giì ꞌdi ndi ŋa có tí nò náa ndâ Jákòmò ta náꞌvindí wó Jòvánì ꞌdè nò, tàkòcò ndú giì kpolo gítí ndú ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Káa Jézù giì kili ndú ꞌdáá gî, bìndi  yí giì ꞌdè có ji ndú, máa, «Yo ŋò ni gî, máa, ndâ ꞌduù tí nó náa à kû ꞌdè có máa ndú a kùṛo ndâ ŋa ndâ ꞌduù tí nó náa ndú me ndâ Jùdéyà lá nó, kû zogo ndú ta wotí. Delè ndâ kpo-kpò ꞌduù mì ndú si bà wo woò ji ndú lá. ");
INSERT INTO ndz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Káa a bà du gbí òkò tí yo me go énò lá. ꞌDuù ŋìnó ta go bà dù tí gbolò ꞌduù gbí òkò tí yo tí wó nó, bà dù tí mbe bàkà nèté ndâ ka wó. ");
INSERT INTO ndz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Káa ꞌduù ŋìnó tí kùṛo yo nó bà dù tí bòò mì ndâ ka wó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tacó à kpêtí káa ꞌViì-mì-ꞌDakò, yí gì me tacó wàa ndâ ꞌduù ꞌví bàkà nèté wó lá. Yí gì a i tacó bà bàkà nèté ndâ ꞌduù, delè tacó bà sì muu ndâ ꞌduù ta miṛi wó.» ");
INSERT INTO ndz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ta o tí nò, ndâ Jézù ta ndâ mbe tala có mì wó giì gì gí gbí gbata Jérìkò. Káa ta o bà njè nó mì ndú ꞌdo kà, ndâ ꞌduù me mbè giì kaa kû ko ndú. Káa ta o tí nò, ꞌbí ꞌdakò tí mbe sú ṛo á mbe kû yù i, ta ṛè wó a Bàràtìméyò, tí ꞌviì mì Tìméyò, kû ki tí wó to á seè kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bàràtìméyò mâ giì ꞌdi có énó máa, à nò a Jézù mbe ꞌdo Názàrètì ká kû ndii ta nó nò, yí giì ꞌbìtà bà tò kû ta kòcò wó ngéé gí yaà, máa, «Jézù, ꞌviì mì Dàvídè, ŋò yê ṛo ye!» ");
INSERT INTO ndz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bìndi  ndâ ꞌduù me mbè giì ꞌbìtà bà do ta yí énó máa, yí si bà tò kû mí to. Káa ta bà ꞌdi có tí nò, à dú nò a o bà giì zì bà tò kû mì Bàràtìméyò, máa, «Jézù, ꞌviì mì Dàvídè, ŋò yê ṛo ye!» ");
INSERT INTO ndz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Káa Jézù giì ṛò tíyò, bìndi  yí giì ꞌdè có ji ndâ ꞌduù máa, «Yo tèꞌé tí wó.» Bìndi  ndú giì ꞌdè có ji Bàràtìméyò, máa, «Zèè njembí lo, a gí yaà, yí kû tèꞌé tí lo.» ");
INSERT INTO ndz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ta bà ꞌdi có tí nò, Bàràtìméyò giì ꞌva bòngo mì wó náa yí kû gala nó mí to, bìndi  yí giì a gí yaà ya gí mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Bìndi  Jézù giì ꞌvee yí máa, «Có mì lo gbí njembí lo máa ye ꞌví bàkà a ŋa yè á ji wò?» Káa yí giì ꞌvìsì có ji Jézù, máa, «Mbe nìbà i, si ndâ ṛo ye ꞌví njaanga tí.» ");
INSERT INTO ndz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Káa Jézù giì ꞌdè có ji yí, máa, «Njè nó, tacó bà ùnje mì lo ta njembí lo ꞌvala wò gî.» Ngé ꞌdo bà-i-nò ndâ ṛo Bàràtìméyò giì njaanga tí gî, bìndi  yí giì ṛu ndi Jézù tí kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì dooko gí gbí gbata Jèrùzàlémè gî, si ndú kû ŋò muu ndâ gbata Bètìfájì ta Bètánìyà, á dê ta ꞌbí gú náa à kû nì mítí  a Gú Mbâ, Jézù giì tuu ndâ ꞌbí mbe tala có mì wó sósòꞌô, ");
INSERT INTO ndz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","máa, «Yo ya gítí ndâ ꞌbá tí zô náa yo kû ŋò ndú zô. Yo bà yee kà ká jé mítí ngbú ꞌviì-kècè náa ꞌduù jé o mì pí tí wó lá, náa à eṛe yí gî. Yo ꞌví njaanga yí gì tí  ji ye. ");
INSERT INTO ndz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Káa ꞌbí ꞌduù má ꞌvee yo, máa, yo kû bàkà nò a yè wè, yo ꞌví ꞌvìsì có ji yí énó máa, ‹A mbe tí ze ká ꞌdè có ji ze máa ze ya ta yí ji yì. Nèté mì yì kuu ta yí, à má cee gî, yì bà tuu ndi wó gì tí  gî.› » ");
INSERT INTO ndz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ndâ mbe tala có mì Jézù náa yí tuu ndú nò giì ya gí bà ꞌde ngbù ꞌviì-kècè náa à eṛe yí mí njekèjì sè tí kpokèjì. Káa si ndú kû giì njaanga yí, ");
INSERT INTO ndz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ndâ ꞌbí ꞌduù mbe kû ṛò tíyò kà giì ꞌvee ndú máa, «Yo kû njaanga ngbú ꞌviì kècè tí nò tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Káa ndú giì ꞌvìsì có ji ndâ ꞌduù tí nò ká go có tí nó náa Jézù ꞌdè ji ndú nô. Bìndi  ndâ ꞌduù tí nò giì si ndú ꞌví njè nó ta ngbú ꞌviì-kècè tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ndú mâ giì yee ta yí ji Jézù, ndú giì ki ndâ bòngo mì ndú mí pí tí wó tacó wàa Jézù ꞌví o mí pí . ");
INSERT INTO ndz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ndâ ꞌduù me mbè giì gò ndâ bòngo mì ndú mí to tí kpokèjì. Ndâ ꞌbí ꞌduù ŋìndi ndú giì kiꞌviki ndâ kpâ, ndú giì gò mítí kpokèjì tacó bà tè duù mítí bà ṛì Jézù gí gbí gbata. ");
INSERT INTO ndz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bìndi  ndâ ꞌduù ŋìnó mbe tè kùṛo Jézù nó, ta ndâ ꞌduù ŋìnó mbe kû ko tàkò wó nó, giì ꞌbìtà bà tò kû ta líkíꞌo énó máa, «ꞌVala ze ꞌdo gbí ndâ vò o! (Òsánà!) À ùlù yí tí mbe gì ta ṛè mì Mbe tí ndoo! ");
INSERT INTO ndz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","O tí nó náa ꞌbí ꞌviì bìndi bu ndoo Dàvídè bà gì gí bà zogo ꞌbá tí nó nó bà dù a banga o! Àá Mbíṛì, gì ꞌdo gbíṛì gí bà ꞌvala ze á ꞌdo gbí ndâ vo-vò o.» ");
INSERT INTO ndz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jézù mâ giì ṛì gí gbí gbata Jèrùzàlémè gî, yí giì ndii ngé ya gí gbí ndùgù ꞌbá-Mbíṛì mì ndâ Jùdéyà. Káa yí mâ giì zekeꞌo jèlè to tí ndâ i ꞌdáá gî, ndú giì ya ta ndâ mbe tala có mì wó muuꞌbì-nje só gí gbí gbata Bètánìyà si o ndii gî. ");
INSERT INTO ndz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta ꞌbí yé, si ndâ Jézù ta ndâ mbe tala có mì wó kû delè ndi ndú ꞌdo Bètánìyà ya gí Jèrùzàlémè, go giì bàkà yí tí kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yí mâ giì ŋò ꞌbí mû-mbiìgá ꞌdo me ꞌdú ta kpâ tí  pìṛìṛìì énó, yí giì ne ya gí tà mû tí nò, máa ndâ-ꞌbî-lá yì bà ꞌde ndo mbiìgá. Káa yí mâ giì di kà, yí giì ꞌde gbèe i lá. ");
INSERT INTO ndz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bìndi  yí giì je nje mítí mû-mbiìgá tí nò énó máa, «ꞌBí ꞌduù kákáꞌi ꞌví zò ndo lo lá.» Ndâ mbe tala có mì wó giì ꞌdi có tí nò náa yí ꞌdè nò gî. ");
INSERT INTO ndz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì yee Jèrùzàlémè gî, yí giì ndii ya gí gbí ndùgù ꞌbá-Mbíṛì mì ndâ Jùdéyà. Bìndi  yí giì ꞌbìtà bà ni ndâ mbe kû mà ndâ i, ta ndâ mbe kû sì ndâ i ꞌdo kà gí sè. Yí delè giì ꞌbuku ndâ káꞌi mì ndâ mbe kû ꞌvìsì gùrúsù, ta ndâ mbata mì ndâ mbe kû mà ndâ kùlè, ꞌdáá gî mí to. ");
INSERT INTO ndz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yí giì ṛò ndâ ꞌduù tí nó mbe kû tuṛu ndâ i waaka ta gbí ndùgù kà nò ꞌdáá gî gî. ");
INSERT INTO ndz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bìndi  yí giì ꞌbìtà bà nìbà i ji ndâ ꞌduù, máa, «À wálá cu mí gbí wáràgà mì Mbíṛì énó máa, Mbíṛì máa, ‹ꞌBá mì ye a bàndò bà ꞌdeke tí ndâ ꞌduù ꞌdáá gî ji ye tí Mbíṛì›? Káa yo giì ꞌvìsì tí bàndò bà kili ndâ kpo-kpò mbe ngbà!» ");
INSERT INTO ndz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Có tí nò mâ giì ꞌva tí gbí tù ndâ Kùṛo ndâ bu-Mbíṛì ta ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà, ndú giì ꞌbìtà bà pà kpokèjì tacó bà zi Jézù. Káa gúku bà gàà ꞌbì ndú tí wó giì kpò ndú gî. Tacó ndâ ꞌduù me mbè tè a i gí tàkò bà nìbà i mì wó. ");
INSERT INTO ndz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ta ꞌdêꞌo mì gbèe ṛi tí nò, Jézù giì njè nó ꞌdo Jèrùzàlémè gî. ");
INSERT INTO ndz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ta dúꞌo mì ꞌbí yé, si ndâ Jézù ta ndâ mbe tala có mì wó kû giì ndii ta nó, ndú giì ŋò mû-mbiìgá tí nò náa Jézù je nje mítí  nó cì gî. ");
INSERT INTO ndz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bìndi  mbí Pìyétòrò ngé giì ꞌva tí có tí nó náa Jézù ꞌdè nó gî. Yí giì ꞌdè có ji Jézù máa, «Mbe nìbà i! Zekeꞌo zó gi! Mû-mbiìgá tí nò náa wò je nje mítí  nó cì gî.» ");
INSERT INTO ndz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Yo tee njembí yo mítí Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ye kû ꞌdè có ji yo ta yúcó énó máa, ꞌduù má ꞌdè có ji ꞌbí gbolò gú máa, gú tí nò a ꞌdo bàndò mì wó ya gí bà ꞌva tí wó tà ngo, ꞌduù tí nò má me kpììkì-kpììkì lá, yí má ùnje gî máa, có tí nò náa yì ꞌdè nò bà bàkà tí gî, àá bà bàkà ji yí gî. ");
INSERT INTO ndz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","À má énò, wò má yù i ꞌdo mì Mbíṛì ta bà ꞌdeke tí lo ji yí, ùnje máa Mbíṛì bà je i tí nò ji wò gî, bìndi  wò bà ꞌde i tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Káa ta o tí nò náa wò má kû ṛò tíyò kû ꞌdeke tí lo ji Mbíṛì, ꞌbí vò i má kuu gbí njembí lo gítí ꞌbí ꞌduù, wò ꞌví je à-cee-gî ji ꞌduù tí nò, tacó Bu lo tí Mbíṛì á gbíṛì ꞌví je ta à-cee-gî gítí ndâ vò i mì lo. ");
INSERT INTO ndz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Káa wò má si có gítí ndâ vò i mì ndâ ꞌbí ka lo mí to lá, Bu lo á gbíṛì delè bà si có gítí ndâ vò i mì lo mí to wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ndâ Jézù ta ndâ mbe tala có mì wó giì gì ndi ndú kákáꞌi gí Jèrùzàlémè. Káa si yí kû giì nò nó ta gbí ndùgù ꞌbá-Mbíṛì, ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà, ta ndâ kpo-ꞌduù-ꞌbá mì ndú giì gì gí mì wó, ");
INSERT INTO ndz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bìndi  ndú giì ꞌvee yí, máa, «Wò kû bàkà ndâ kpo-kpò seṛè tí nò ta wotí mì ŋa yè? A ꞌdi ká je wotí bà bàkà ndú á ji wò?» ");
INSERT INTO ndz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Káa Jézù giì ꞌvìsì có ji ndú, máa, «Ye kpónó bà ꞌvee yo ta ꞌvé gbaànjé cuki. Yo má ꞌvìsì có á ji ye gí tàkò ꞌvé mì ye nò gî, ye ꞌví giì nì ṛè ꞌduù tí nò náa ye kû bàkà ndâ i tí nò ta wotí mì wó nò ji yo. ");
INSERT INTO ndz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ꞌVé mì ye ji yo énó máa: a ꞌdi táánò ká je wotí bà caka tí ndâ ꞌduù ji Jòvánì? A Mbíṛì wèè, a ndâ ꞌduù ká je wotí tí nò ji yí? Yo nì ṛè ꞌduù tí nò ji ye má kózò gi.» ");
INSERT INTO ndz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Káa ndú giì ꞌbìtà bà ꞌviiki gbí có tí nò gbí òkò tí ndú, máa, «Ndoo má ꞌdè có énó máa, Jòvánì ꞌde wotí tí nò ꞌdo mì Mbíṛì, yí bá giì ꞌvee ndoo énó máa, káa tacó yè káa ndoo ùnje gítí ndâ i tí nó náa yì kû bàkà nó lá?» ");
INSERT INTO ndz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Káa delè gúku bà giì ꞌvìsì có ji yí énó máa, Jòvánì ꞌde wotí tí nò ꞌdo mì ndâ ꞌduù giì kpò ndú gî, tacó ndâ ꞌduù ꞌdáá gî ùnje gî máa, Jòvánì táánò a mbe ꞌdòkò có mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tacó énò ndú giì ꞌvìsì có ji Jézù, máa, «Ze ŋò bà  lá.» Bìndi  Jézù giì ꞌvìsì có ji ndú, máa, «À má énò, ye delè bà nì ṛè mbe je wotí bà bàkà ndâ i tí nò ji ye nò ji yo wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ta o tí nò, Jézù giì ꞌbìtà bà ꞌde có ji ndâ ꞌduù gbí lòkóꞌbò énó máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò giì ṛo njí mû-nèbítì mì wó, yí giì bàkà ndùgù gí tàkò , yí giì duu gùù bà pee nèbítì mí gbí , yí giì duu cèléngé mí gbí . Bìndi  yí giì kaa ndâ ꞌbí ꞌduù mí gbí , máa, ndú bàkà nèté gítí nèbítì mì yì, wàa ndâ yí ꞌví njèè gbí i ꞌdo gbí njí go ŋìnó náa à tí  nó ta ndú. Ndú mâ giì ꞌvii có ta ndú cee gî, yí giì njè nó ya gí gbí tende muu to. ");
INSERT INTO ndz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«O bà kili ndâ i ꞌdo gbí njí mâ giì gì gî, mbe njí tí nò giì tuu ꞌbí bòò mì wó gbaànjé ji ndâ ꞌduù tí nó mbe kû bàkà nèté gbí njí mì wó nó tacó ndâ bà i ŋìndi wó. ");
INSERT INTO ndz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Káa ndâ mbe nèté tí nò giì zèè bòò tí nò, ndú giì gbì yí, bìndi  ndú giì mòkò yí ꞌdo gbí njí gí sè ta kùnga ꞌbì wó. ");
INSERT INTO ndz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mbe njí tí nò giì tuu ꞌbí bòò mì wó kákáꞌi. Káa ndâ mbe nèté tí nò giì gbì muu wó di gî. Ndú delè giì bàkà ndâ i-nô mítí wó me gbolò. ");
INSERT INTO ndz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mbe njí tí nò mâ giì tuu bà taꞌô bòò mì wó, ndâ mbe nèté tí nò giì zi yí gî. Sè ndâ ꞌbí tú mì mbe njí tí nò náa yí giì tuu ndú bìndi ŋìnò, ndâ mbe nèté tí nò giì gbì ndâ ꞌbí  gbí-gbì, ndú giì ziki ndâ ꞌbí  zíkí-ziki. ");
INSERT INTO ndz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sè ꞌduù mì wó giì dù ká gbaànjé, náa yí giì tuu ji ndú tí ndòngbú ꞌduù, a gbèe ꞌviì mì wó náa yí zè yí nìkì ta njembí wó gbaànjé, ta bà koṛo có énó máa, ndú bà te duù mítí ꞌviì mì yì nò gî. ");
INSERT INTO ndz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Káa ndâ ꞌduù tí nò mâ giì ŋò ꞌviì mì ꞌdakò tí nò kèjì, ndú giì toko có gbí òkò tí ndú, máa, ‹Ŋìzó a mbe mbelè tí nó ká kèjì zô. Ndoo zi yí gî, tacó wàa mbelè tí nó ꞌví dù tí ŋìndi ndoo.› ");
INSERT INTO ndz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ndú bà-i-nò giì kili mítí ꞌviì tí nò, ndú giì zi yí gî. Bìndi  ndú giì ja ku wó gí sè ꞌdo gbí njí. ");
INSERT INTO ndz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Mbe njí tí nò kpónó bà bàkà a ŋa yè? Yí bà ziki ndâ mbe nèté tí nò gî, bìndi  yí giì kaa ndâ ꞌbí ngú mbe nèté mí gbí njí tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yo ꞌdeke có tí nò gbí wáràgà mì Mbíṛì nó lá? Có tí nó máa, ‹Díí tí nó náa ndâ mbe bì ꞌbá bè gî nó ká gì tí kpédélé díí bà sè tà ꞌbá; ");
INSERT INTO ndz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ŋìnó a i ŋìnó náa a Mbe tí ndoo ká bàkà , káa nje ndoo ꞌdèè gítí bà zeke gî.› Yo jé ꞌdeke có tí nò lá?» ");
INSERT INTO ndz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò mbe nìbà i, ta ndâ kpo-ꞌduù-ꞌbá mì ndâ Jùdéyà mâ giì ꞌdi lòkóꞌbò tí nó, ndú giì ŋò ni gî máa, Jézù kû lòkòꞌbò có tí nò a i gítí ndâ yì. Káa gúku bà zèè yí giì kpò ndú gî, tacó ndâ ꞌduù ta o tí nò me mbè. Tacó énò, ndú giì njè nó si yí mí to. ");
INSERT INTO ndz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò mbe nìbà i, ta ndâ kpo-ꞌduù-ꞌbá mì ndâ Jùdéyà giì tuu ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ mbe kû kpolo tí tàkìì mì ndú ta ndâ ꞌbí mbe kû tè gí tàkò có mì Èródè tacó bà zèè ngo nje Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ndâ ꞌduù tí nò giì ꞌvee Jézù, máa, «Mbe nìbà i, ze ŋò ni gî máa, wò a mbe ꞌdè yúcó, wò cì gúku tí ꞌbí ꞌduù gbaànjé lá, wò delè ꞌvee bà  énó máa, ŋìnó a gbolò ꞌduù, káa ŋìnó a lúkúfà ꞌduù nò, jé lá. Wò kû nìbà có mì Mbíṛì ji ndâ ꞌduù ꞌdáá gî ká ta njembí lo gbaànjé. Wò koṛo có máa, a yúcó tacó tí ndoo tí ndâ Jùdéyà bà gò i ji ngáángbá gba mì ndâ Ròmánò? Ze gò i ji yí, wèè, ze gò lá?» ");
INSERT INTO ndz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Káa Jézù giì ŋò ni gî máa, ndâ ꞌduù tí nò gì gí tí yì ta ngìŋò. Tacó énò, yí giì ꞌvìsì có ji ndú máa, «Yo kû ꞌdè ngo muu có ji ye tacó yè? Yo tala bà tù ŋa gùrúsù tí nò á mì yo nò ji ye, wàa ye ꞌví ŋò gi.» ");
INSERT INTO ndz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ndú mâ giì tù ꞌbí ŋa gùrúsù mì ndú nò gbaànjé, náa ndú kû ni mítí  a dìnárì, ji Jézù gî, Jézù giì ꞌvee ndú, máa, «À ka mí gbí gùrúsù mì yo nó a cè kózò tí ꞌdi nó?» Káa ndú giì ꞌvìsì có ji yí máa, «À ka a cè kózò tí ngáángbá gba mì ndâ Ròmánò.» Yí giì ꞌvee ndú kákáꞌi máa, «Káa à cu mí gbí  nó a ṛè ꞌdi?» Káa ndú giì ꞌvìsì có ji yí, máa, «À cu a ṛè ngáángbá gba mì ndâ Ròmánò.» ");
INSERT INTO ndz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bìndi  Jézù giì ꞌvìsì có ji ndú máa, «Yo dele ndi ndâ i mì ngáángbá gba mì ndâ Ròmánò ji ngáángbá gba mì ndâ Ròmánò, wàa yo ꞌví dele ta ndâ i mì Mbíṛì á ji Mbíṛì.» Bìndi  nje ndú ꞌdáá gî giì ꞌdèè gítí có mì Jézù nò gî. ");
INSERT INTO ndz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bìndi  ndâ ꞌbí ŋa ndâ Jùdéyà mbe ùnje gítí bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú lá, ta ṛè ŋa ndú a ndâ Sàdùkáyò, giì ꞌvee Jézù máa, ");
INSERT INTO ndz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Mbe nìbà i, Mòze cu ji ze mí gbí wáràgà mì wó máa, ꞌduù má kò niì, káa ku giì je yí si ndú jò ta niì tí nò lá, náꞌvindí ꞌduù tí nò ꞌví zèè ꞌbì nawù ku bìndi wó, tacó bà jò ṛè náꞌvindí wó. ");
INSERT INTO ndz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Káa ta ꞌbí o gbaànjé, ꞌbí ꞌviì-ꞌdakò náa nawu ndú jò ndú ta bà muu ndú vô-nje só giì kò niì, bìndi  ku giì je yí si ndú jò ta niì tí nò kálásê. ");
INSERT INTO ndz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ꞌBí náꞌvindí ku tí nò giì zèè ꞌbì nawù ku á bìndi wó. Ndú delè giì jò ta niì tí nó lá, bìndi  yí giì cee gî. Bà taꞌô ꞌduù giì zèè ꞌbì niì tí nò, káa ndú delè giì jò ta yí lá. ");
INSERT INTO ndz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ꞌDuù ŋìnò má zèè ꞌbì niì tí nò á bìndi ku náꞌvindí wó, yí cì ká sínò; ꞌduù ŋìnò má zèè ꞌbì wó, yí cì ká sínò, kpòò yee tí o tí nó náa ndâ ꞌviì-ꞌdakò tí mò vô-nje só gbí yì mì nawu ndú ꞌdáá gî giì tè ṛì á cìkii gbèe niì tí nó gbaànjé-gbaànjé ꞌdáá gî, ku delè giì ṛuka ndú gbaànjé-gbaànjé ꞌdáá gî, káa gbèe ꞌduù á ꞌdo gbí òkò tí ndú mbe jò ta yí wálá. Bìndi  niì giì cì tí ndòngbú ꞌduù gí tàkò ndú. ");
INSERT INTO ndz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","À má ta o bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú wúnò, ndú má giì ꞌvala ndi ndú gî, niì tí nò bà giì du tí niì mì ꞌdi á ꞌdo gbí òkò tí ndú? Tacó ndú ꞌdáá gî kò yí gî.» ");
INSERT INTO ndz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Káa Jézù giì ꞌvìsì có ji ndú máa, «À nò me ndeṛè bà giṛiꞌo mì yo ká nò lá? Náa yo ꞌdi tí  ta gbí ndâ có tí nó náa à cu mì Mbíṛì nó lá nò? Yo delè giì ŋò tí  ta wotí mì Mbíṛì ni lá nò! ");
INSERT INTO ndz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tacó bìndi bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú, ndâ ꞌdakò ta ndâ niì kákáꞌi bà kò tí ndú wálá, tacó ndú bà giì du go ndâ basìlì mbe kû nò tú mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","«Káa à má gítí có bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú, yo ꞌdeke có gítí bèꞌi tí nó mbe kû doo nó gbí wáràgà mì Mòze lá? Mbíṛì ta o tí nò giì ꞌdè có ji Mòze máa, ‹Ye a Mbíṛì mì Àbìráámò, ye a Mbíṛì mì Ìzákò, ye a Mbíṛì mì Jàkóbè.› ");
INSERT INTO ndz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Káa ndâ Àbìráámò, ta Ìzákò, ta Jàkóbè cì sàà si à dooko gítí bà jò Mòze kálásê. Káa Mbíṛì giì ꞌdè có tí nò ji Mòze tacó bá tùbà  énó máa, ndú kû ꞌvala kálásê. À má énò, Mbíṛì me Mbíṛì mì ndâ ku lá. Yí a Mbíṛì mì ndâ ꞌválá. Káa có mì yo máa, ꞌválá bìndi ku wálá nò, co ngé to gî.» ");
INSERT INTO ndz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Bìndi  ꞌbí gbolò mbe nìbà i mì ndâ Jùdéyà mbe kû sè tù wó ta o tí nò gítí bà tò kponje mì ndâ Jézù ta ndâ ka wó, má giì ꞌdi ndâ bà ꞌvìsì có mì Jézù ji ndú ꞌdáá gî ká dú, yí giì ꞌvee Jézù máa, «Kpóló-kpolo có gbí òkò tí ndâ có mì Mbíṛì ꞌdáá gî a có ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Káa Jézù giì ꞌvìsì có ji yí, máa, «Ŋìnó a có mì Mbíṛì mbe kpolo co tí ndâ ꞌbí có mì wó ꞌdáá gî: ‹Yo sè tù yo, ákoo ndâ Ìzìrìyélì. Mbe tí ndoo tí Mbíṛì ká gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yo zè Mbe tí yo tí Mbíṛì mì yo nìkì ta njembí yo gbaànjé, ta lilí yo gbaànjé, ta bà koṛo có mì yo gbaànjé, ta wotí mì yo ꞌdáá gî.› ");
INSERT INTO ndz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","«ꞌBí kpóló-kpolo có mì Mbíṛì a ŋìnó, máa, ‹Wò ꞌví zè ndâ ꞌbí ka lo nìkì ká go ŋìnó náa wò kû zè ta ꞌdóó tí lo nìkì maa nô.› ꞌBí có mì Mbíṛì kákáꞌi mbe me gbolò ndii ndâ có tí nò sósòꞌô nò gî wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mbe nìbà i tí nò giì ꞌvìsì có ji Jézù máa, «Wò ꞌdè a yúcó, Mbe nìbà i. Có mì lo náa wò ꞌdè énó máa, Mbíṛì ká gbaànjé, ꞌbí Mbíṛì bìndi wó kákáꞌi wálá, à káa yí nò, a cèe yúcó. ");
INSERT INTO ndz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bà zè yí nìkì ta njembí ꞌduù gbaànjé, (ta kóṛó-koṛo có mì ꞌduù gbaànjé,) ta wotí mì ꞌduù ꞌdáá gî, ta bà zè ꞌbí ka tí nìkì á go bà zè ꞌdóó tí ꞌduù nìkì , a ndâ kpóló-kpolo có mbe ndii ndâ bà doo ngûwu ndâ nò ta ndâ bà waa mbelè ji Mbíṛì gî.» ");
INSERT INTO ndz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jézù mâ giì ŋò énó máa, bà ꞌvìsì có mì ꞌdakò tí nò a bà ꞌvìsì có mì mbe ꞌdi gbí-o, yí giì ꞌdè có ji yí máa, «Wò me ꞌdú ꞌdo tí ꞌbá tí nó náa Mbíṛì kû zogo nó lá.» ꞌDo bìndi ŋìnò, ꞌbí ꞌduù kákáꞌi mbe giì yeeke tí wó ta bà ꞌvee gbí nje Jézù wálá. ");
INSERT INTO ndz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ta o tí nò si Jézù kû nìbà i ji ndâ ꞌduù á gbí ndùgù ꞌbá-Mbíṛì, yí giì ꞌvee ndú máa, «Ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà kû ꞌdè có máa, Bìndi-Mbíṛì a ꞌviì mì Dàvídè ta kpokèjì ngàyi? ");
INSERT INTO ndz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","À sé a Dàvídè táánò ta nje wó ká kò-kò ta wotí mì Bèṛi-mì-Mbíṛì, máa, ‹Mbíṛì ꞌdè có ji Mbe tí ye máa, «Kí tí lo gbí kùꞌbì mì ye di tí o tí nó náa ye bà giì bàkà ndâ kuꞌdì mì lo tí ndâ i-tà-tàmà mì lo,» nó.› ");
INSERT INTO ndz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Káa Dàvídè ta nje wó má kû nì mítí Bìndi-Mbíṛì a ‹Mbe tí ye,› Bìndi-Mbíṛì bà giì dù tí ꞌviì mì Dàvídè ta ŋa kpokèjì ngàyi?» Káa ndâ ꞌduù me mbè giì sè tù tí có tí nò ta pétékè tàkòcò ndú, wàa yí ꞌví ꞌdè ta gbí có tí nò ngbáṛángàꞌi ji ndâ yì. ");
INSERT INTO ndz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Si Jézù kû nìbà i ji ndâ ꞌduù, yí giì kpo-gbí-tà-tù ndú máa, «Yo kpolo tí yo ꞌdo tí ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà mbe kû dù ta go bà yuu ndâ banga bòngo, ta go bà si ndâ ꞌduù ꞌví te duù mítí bà ꞌvee ndú á go bà ꞌvee ndâ gba ta ndi tí ndâ bàndò ꞌvélè. ");
INSERT INTO ndz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ndú má ya gítí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì tacó bà ùlù Mbíṛì, ta ndâ kpo-kpò bàndò bà kili ndâ ꞌduù gí bà zò i, à tí ndú delè káa go bà ki tí ndú pí ndâ kpédélé mbata tí nó náa à paka mí kùṛo ndâ ꞌduù nô. ");
INSERT INTO ndz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ndú zò ndâ i mì ndâ nawù ku mìì gî. Ndú kû bàkà tí ndú tí ndâ tó ꞌduù ta ꞌvéṛè bà dù kû ùlù Mbíṛì too yé, ta ṛi, too yé, ta ṛi, káa Mbíṛì bà waa có mítí ndú ta wotí ká tí .» ");
INSERT INTO ndz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Káa si Jézù kû ki tí wó á seè bàndò bà gò i mì ndâ ꞌduù ji Mbíṛì á gbí ndùgù ꞌbá-Mbíṛì, yí giì ŋò ndâ ꞌduù me mbè kû gò i. ");
INSERT INTO ndz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mâ giì zekeꞌo, ꞌbí nawù ku tí mbe yê gì gí bà gò ndâ njì gùrúsù sósòꞌô, náa à má toko ndú, ndú bà gì tí gírísì gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jézù mâ giì ŋò i tí nò náa nawù ku tí nò bàkà nò, yí giì tèꞌé tí ndâ mbe tala có mì wó. Bìndi  yí giì ꞌdè có ji ndú, máa, «Ye kû ꞌdè có ji yo ta yúcó máa, nawù ku tí nò tí mbe yê nò, gò i me gbolò ndii ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tacó ndâ mbe kpo-kpò i gò káa nje mèlè ndâ i tí nó náa à kuu mì ndú nô. Káa nawù ku tí nò, tí mbe yê ta ꞌbí i mì wó wálá nò, gò ꞌdáá nò a làmbu ŋìnó náa yí kû lì mítí  nô.» ");
INSERT INTO ndz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Si Jézù kû co ꞌdo gbí ndùgù ꞌbá-Mbíṛì gí sè, ꞌbí mbe tala có mì wó gbaànjé giì zeke ꞌbá-Mbíṛì, bìndi  yí giì ꞌdè có ji yí máa, «Zekeꞌo zó gi, Mbe nìbà i! A ŋa ndâ kpo-kpò díí yè náa a bì ta ndâ ꞌbá tí zó ká zó!» ");
INSERT INTO ndz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Káa Jézù giì ꞌvìsì có ji yí máa, «Wò wálá ŋò ndâ kpo-kpò ꞌbá tí zó gî? Gbèe díí bà giì dù pí ka wó wálá. À bà giì kiꞌviki ndú lúꞌbú-lúꞌbú gí to.» ");
INSERT INTO ndz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jézù giì ya gí pí Gú Mbâ, bìndi  yí giì ki tí wó tù gbíṛo wó mò gítí ꞌbá-Mbíṛì. Bìndi  ndâ Pìyétòrò, ta Jákòmò, ta Jòvánì, ta Àndèréyà, giì ꞌvee yí si ndú ta kpéétí ndú máa, ");
INSERT INTO ndz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Nì o bà bàkà tí mì i tí nò ji ze. Ze bà ŋò o bà bàkà tí mì ndâ i tí nò ni mítí yè?» ");
INSERT INTO ndz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bìndi  Jézù giì ꞌbìtà bà ꞌdè có ji ndú, máa, «Yo kpolo tí yo, tacó wàa ꞌbí ꞌduù ꞌví eendi yo lá. ");
INSERT INTO ndz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tacó ndâ ꞌduù me mbè bà giì waaka có ta ṛè ye; ꞌduù ŋìnò bà dù káa o gí yaà máa, ‹Ye a yí›. Ndú bà giì eendi ndâ ꞌduù me mbè. ");
INSERT INTO ndz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","«Káa yo má ꞌdi có ndâ kpo-kpò gó, ta ndâ bà fiini có gítí ndâ kpo-kpò gó, yo ꞌví cì gúku lá, tacó ndâ gó tí nò ꞌdáá gî bà gò tí gî, káa ndòngbú o kálásê. ");
INSERT INTO ndz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tacó ta o tí nò ndâ ꞌduù ꞌdo muu to kèꞌbî bà kaa ya gí bà tè ndâ ꞌbí ka ndú ta gó. Ndâ kpo-kpò gba bà giì tè ndâ ꞌbí ka ndú ta gó. To bà giì tanga tí, tí ndâ bàndò me mbè. Ndâ ꞌduù bà giì zò go. Káa ndâ i tí nò ꞌdáá gî káa bà ꞌbìtà gó-káyì sínò. ");
INSERT INTO ndz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Káa yo ꞌví kpolo tí yo, tacó ndâ ꞌduù bà giì ya ta yo gí gbí ngbàngà mì ndâ Jùdéyà. Àá bà giì gbì yo ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì; yo bà giì ṛò tíyò á kùṛo ndâ kpo-kpò tùù, ta ndâ kpo-kpò gba á muu ye. Yo bà giì ꞌvanda ndi ndâ có tí nó táánò náa yo ꞌdi ꞌdo gbí nje ye nô. Yo delè bà giì ꞌdè có gítí ndâ i ŋìnó náa yo táánò ŋò ye kû bàkà ndú nô. ");
INSERT INTO ndz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Káa yo kpédéléꞌi bà ma a Banga-Ngú-Có mì ye á ji ndâ ꞌduù á muu to tí nó ꞌdáá gî má kózò gi. ");
INSERT INTO ndz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","«Ta o tí nò, à má kû zèè yo ya tí  gí gbí ngbàngà, yo ꞌví si bà yeeke tí yo ta bà koṛo có máa, yo bà ꞌdè mí kà a có yè wè nò mí to; yo ꞌví ꞌdè káa ŋa có ŋìnó mbe gì gí gbí muu yo nô. Tacó ta o tí nò à me yo ká kû ꞌdè có lá, a Bèṛi-mì-Mbíṛì ká bà ꞌdè có. ");
INSERT INTO ndz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Ta o tí nò, ndâ ꞌduù bà sì tàmuu ndâ náꞌvindí ndú ji ku, bu ꞌviì bà sì tàmuu ꞌví mì wó ji ku, ndâ ꞌviì bà giì sogo ndâ mbe jò ndú, ndú delè bà giì sì ndú ji ku; ");
INSERT INTO ndz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","delè ndâ ꞌduù bà giì sogo yo tacó tí ye. Káa ꞌduù ŋìnó mbe zèè njembí wó yee tí ndòngbú ndâ i tí nò ká bà ꞌde ꞌvala ŋìnó mbe cee lá nô. ");
INSERT INTO ndz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Káa ta o tí nò, yo má ŋò ndâ vò ꞌduù kû gbètèkè ꞌbá-Mbíṛì nó, (mbe kû ꞌdeke i tí nó ꞌví ꞌdi gbí  énó máa), ndâ ꞌduù Jùdéyà ꞌví ì ngèlè ya gí pí ndâ nja-njà gú. ");
INSERT INTO ndz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","16","Ndâ i tí nò má gbo yo mítí ꞌbí bàndò, yo ꞌví dele ndi yo ya gí ꞌbá tacó bà kaa ndâ i mì yo lá. ");
INSERT INTO ndz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Káa a ŋa vò pá yè ká tí ndâ mbe nakáyì, ta ndâ niì ŋìnó náa ndâ ꞌviì mì ndú nje kí gbí ndâ o tí nò nó ká énó! ");
INSERT INTO ndz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yo ꞌdeke tí yo ji Mbíṛì máa, i tí nò ꞌví bàkà tí me ta bèmbílì lá. ");
INSERT INTO ndz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tacó gbí ndâ sili tí nò, ndâ ꞌduù bà giì mbu ŋa ꞌbí bà mbu ndò ta ŋa  jé mbe bàkà tí lá ꞌdo tí o bà ꞌbìtà bà suu to tí nó mì Mbíṛì di tí kpónó, delè ta ŋa  kákáꞌi bà bàkà tí wálá. ");
INSERT INTO ndz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ꞌDóó Mbe tí ndoo tí Mbíṛì táánò má ja tí ndâ sili tí nò gí to lá, gbèe ꞌduù bà dù wálá. Káa yí ja tí ndâ sili tí nò a i tacó tí ndâ ꞌduù tí nó náa yí ṛuka ndú gî nô. ");
INSERT INTO ndz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«À má énò, ꞌbí ꞌduù má giì ꞌdè có ji yo, máa, ‹Yo zekeꞌo gi, Bìndi-Mbíṛì kuu nô!› wàlà máa, ‹Yo zekeꞌo, yí zô!› yo ꞌví ùnje gítí  lá. ");
INSERT INTO ndz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta o tí nò ndâ sú bìndi-Mbíṛì, ta ndâ sú mbe ꞌdòkò có mì Mbíṛì bà oloko kû bàkà ndâ i, ta ndâ seṛè, tacó bà giṛi kpokèjì mì ndâ ꞌduù tí nó náa Mbíṛì ṛuka ndú gî nó, náa ndú má ꞌde kpokèjì gítí ndú gî nò. ");
INSERT INTO ndz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","«A má énò, yo kpolo tí yo, tacó ye kpo-gbí-tà-tù yo gítí ndâ i tí nó bà giì bàkà tí nó ꞌdáá gî, gî. ");
INSERT INTO ndz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Káa gbí ndâ sili bìndi ndâ vo-vò o tí nò, ṛo ṛi bà giì ꞌdi gî, pì bà giì tòngbaà wálá, ");
INSERT INTO ndz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ndâ yii bà giì ꞌduku gí to ꞌdo gbíṛì, ndâ i gbíṛì ꞌdáá gî bà giì ngaka tí ndú. ");
INSERT INTO ndz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Bìndi  ndâ ꞌduù bà giì ŋò ꞌViì-mì-ꞌDakò kû gì co gbí ndâ kùlù mù ta dì gbí tí wó, kû tòngbaà ngbézé-ngbeze-ngbèzè. ");
INSERT INTO ndz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bìndi  yí bà giì tuu ndâ basìlì mì Mbíṛì cee muu to tí nó ꞌdáá gî, gí bà kili ndâ ꞌduù ŋìnó náa Mbíṛì ṛuka ndú gî nó ꞌdo gbí ndâ gulú-gulù to yee tí gulú-gulù ṛì. ");
INSERT INTO ndz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Yo kpolo ṛo yo mítí mû-mbiìgá, ta o tí nó náa yí má kû tù ngú dó kpâ, yo ŋò ngé ni gî máa, bèmbílì dooko jéꞌdéé gî. ");
INSERT INTO ndz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Go énô delè, ta o tí nó náa yo má ŋò ndâ i tí nó náa ye ꞌdè có gítí ndú nó kû bàkà tí, yo ꞌví koṛo muu yo énó máa, o bà gì ꞌViì-mì-ꞌDakò dooko gî. ");
INSERT INTO ndz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ye kû ꞌdè có ji yo ta yúcó, máa, ndâ i tí nò ꞌdáá gî bà bàkà tí kùṛo bà mìì ndâ ꞌduù tí nó kpónó mbe kû ꞌvala muu to tí nó nó gî. ");
INSERT INTO ndz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ndâ gbíṛì ta to tí nó bà mìì gî, káa ndâ có mì ye bà mìì wálá. ");
INSERT INTO ndz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Káa à má gítí ndâ ꞌdóó ṛi tí nò, ta ꞌdóó o tí nò, gbèe ꞌduù mbe ŋò ni wálá, kpêtí káa ndâ basìlì mbe kû nò tú mì Mbíṛì á gbíṛì, kpêtí káa ꞌViì-mì-Mbíṛì, gbèe ꞌduù jé mbe ŋò ni wálá. À káa Bu ye cuki ká ŋò ni . ");
INSERT INTO ndz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","À má énò, yo dù tí zòꞌo. Yo ꞌví kpolo tí yo, tacó yo jé gí bà ŋò máa, o tí nò bà gì ta o ngàyi wè, nò wálá. ");
INSERT INTO ndz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","O tí nò bà gì go ꞌduù mbe ya gí muu njà nó. Yí njè nó ꞌdo ꞌbá si ndâ i mì wó á ji ndâ bòò mì wó, máa ndú ꞌví kpolo tí ndú, bòò ŋìnò ká ta bà nèté mì wó, ꞌbí  ká ta ŋìndi wó. Bìndi  yí giì ꞌdè có ji mbe kpolo tí njekèjì máa, yí dù tí zòꞌo. ");
INSERT INTO ndz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","À má énò, yo dù tí zòꞌo, tacó yo ŋò o tí nó náa mbe ꞌbá bà gì tí  nó ni lá. Yí bà gì si ndâ ꞌduù á njewu? Yí bà gì ta kpo-gbíꞌo? Yí bà gì ta bà kò-kò mì ngùù? Yí bà gì si yé kû wèlè tà ṛì? ");
INSERT INTO ndz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yí má yee kpàtàràkà gî, yí ꞌví ꞌde yo á tí zòꞌo. ");
INSERT INTO ndz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Có tí nò náa ye ꞌdè ji yo nò, ye ꞌdè ji ndâ ꞌduù ꞌdáá gî: ‹Yo dù tí zòꞌo!› » ");
INSERT INTO ndz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ta o tí nò sè sili ká só gítí o bà bàkà tàkìì o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì, ta tàkìì bà ci ꞌDê-kô. Ndâ Kùṛo ndâ bu-Mbíṛì ta ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà kû giì pà kpokèjì bà zèè Jézù á tàbèngìì tacó bà zi yí. ");
INSERT INTO ndz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ndú jè ta bà zèè yí gbí ngbà tacó ndú kû cì gúku máa, ndâ yì má zèè yí gbí ngbàà ṛi á ta gbolò o tí nó, ndâ ꞌduù bà bàkà wo. ");
INSERT INTO ndz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ta o tí nò si Jézù kû zò i gbí gbata Bètánìyà á ꞌbá mì ꞌbí ꞌdakò ta ṛè wó a Sìmónè, náa à kû nì mítí wó a «mbe cì,» ꞌbí niì giì gì ta banga pó bàà náa à ŋònòkò ta ꞌbí ŋa banga pó i ta ṛè  a nàràdì gbí dúlàngà. Bìndi  niì tí nò giì ki miṛi dúlàngà bàà tí nò gî, yí giì yee bàà tí nò ꞌdáá gî mítí muu Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Káa ndâ ꞌbí ꞌduù ŋìnó mbe ŋò i tí nò náa niì tí nò bàkà nò giì ꞌbìtà bà ꞌdè ngùṛù-ngùṛù có goꞌi ta kpo tàkòcò gítí niì tí nò, máa, «À kpónó volo gbí bàà tí nò tacó yè? ");
INSERT INTO ndz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Àá kùtàá bà sì pó bàà tí nò á ta gbolò gùrúsù ndii dìnárì 300 gî, wàa à ꞌví ko ta ndâ mbe yê.» ");
INSERT INTO ndz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jézù mâ giì ꞌdi có tí nò náa ndâ ꞌduù tí nò kû fiini nò, yí giì tè ṛo wó gítí ndú. Bìndi  yí giì ꞌdè có ji ndú máa, «Yo si niì tí nò mí to. Yo kû pèè mbí wó tacó yè? Yí bàkà ji ye a banga i. ");
INSERT INTO ndz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ndâ mbe yê ta o ꞌdáá gî kuu gbí òkò tí yo. Go bà bàkà nambeè ji ndú má kuu tí yo, yo bà bàkà ta o mì yo mbe nìkì tí yo gî. Káa à má gítí ye, yo bà ꞌde ye ta o ꞌdáá gî wálá. ");
INSERT INTO ndz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yí bàkà nò a bà wotí ŋìndi wó. Yí toṛo nò a bàà bà duu ye mítí ye. ");
INSERT INTO ndz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ye kû ꞌdè có ji yo ta yúcó máa, bàndò náa à má ma Banga-Ngú-Có mítí  muu to tí nó gî, à delè bà koṛo có tí niì tí nó ta bà dìtà i tí nó náa yí bàkà nó gî.» ");
INSERT INTO ndz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Bìndi  Júdà Ìsìkàrìyótè, tí ꞌduù ꞌdo gbí òkò tí ndâ mbe tala có mì Jézù muuꞌbì-nje só, giì njè nó ya gí mì ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, tacó bà ba ngbù Jézù ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ta bà ꞌdi có tí nò, tàkòcò ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà giì peteke gítí Júdà ngé ndii gî. Bìndi  ndú giì ci yí máa, ndâ yì bà ko mboo nèté mì wó nò ji yí ta gùrúsù. Bìndi  Júdà giì delè ndi wó ya gí bà pà tó kpokèjì bà zèè Jézù ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Káa ta o bà ꞌbìtà ndâ sili mì gbolò o bà bàkà tàkìì mì ṛi bà ci ꞌDê-kô, si à waa mbelè ꞌviì-rómbo gítí o bà bàkà tàkìì mì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì gî, ndâ mbe tala có mì Jézù giì ꞌvee yí gítí bàndò ŋìnó náa mbe nìkì tí wó, tacó wàa, ndâ yì ꞌví ya gí bà ꞌviindi  ji ndâ yì ta ndú tacó bà zò i-cí-ci mítí . ");
INSERT INTO ndz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Káa Jézù giì ꞌvìsì có ji ndú ta bà tuu ndâ ꞌduù sósòꞌô ꞌdo gbí òkò tí ndú, máa, «Yo ya gí gbí gbata; yo má yee kà, yo bà ꞌde ꞌbí ꞌdakò kû te ngo gbí káṛà; yo ꞌví ṛu ndi wó. ");
INSERT INTO ndz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ꞌBá tí nó náa yí bà ṛì gítí  nó, yo ꞌví ya gí bà ꞌvee mbe ꞌbá tí nò, máa, ‹A mbe nìbà i ká tuu ze máa, ze gì gí bà ꞌvee wò máa, ꞌbá wiṛi tacó tí  ngòó, tacó wàa, ndâ yì ꞌví gì gí bà zò i-cí-ci mí tà  á ta ndâ mbe tala có mì yì wè?› ");
INSERT INTO ndz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bìndi  yí bà tùbà gbolò soṛo náa à ꞌviindi bàndò mí kà sàà gî ji yo. Nò gí, yo ꞌví bàkà i-zó-zò mí kà á ji ndoo.» ");
INSERT INTO ndz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ndâ mbe tala có mì Jézù mâ giì njè nó ya gí gbí gbata, ndú giì ꞌde ndâ i kà jé ká go có tí nó náa yí ꞌdè ji ndú nô. Bìndi  ndú giì ꞌviindi ndâ i-cí-ci kû ù ta ndi wó. ");
INSERT INTO ndz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ꞌDêꞌo mâ giì gì gî, ndâ Jézù ta ndâ mbe tala có mì wó muuꞌbì-nje só giì ya gí gbí gbata tí ꞌbá tí nó náa à ꞌviindi tàꞌi mítí  kû ù ta ndi ndú nô. ");
INSERT INTO ndz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Káa si ndú kû zò i, Jézù giì ꞌdè có ji ndú máa, «Ye kû ꞌdè có ji yo ta yúcó, máa, ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí yo bà giì ba ngbù ye gî. ꞌBí ꞌduù ꞌdo gbí òkò tí yo mbe kû zò i ta ye kpónó gbí káꞌi.» ");
INSERT INTO ndz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ta bà ꞌdi có tí nò ndâ mbe tala có mì Jézù ꞌdáá gî giì dù zuku-zùkùù. Bìndi  ndú giì ꞌbìtà bà ꞌvee yí gbaànjé-gbaànjé, máa, «À ꞌví dù a ye? À ꞌví dù a ye?» ");
INSERT INTO ndz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Káa Jézù giì ꞌvìsì có ji ndú, máa, «A ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí yo a muuꞌbì-nje só nô. ꞌBí ꞌduù mbe kû too yâ ta ye ꞌdo gbí gbèe káꞌi. ");
INSERT INTO ndz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ìyoo. À dú káa yúcó, ꞌViì-mì-ꞌDakò bà giì ya gí nje ku mì wó á go có tí nó náa à cu mí gbí wáràgà mí Mbíṛì sàà énó máa, yí bà giì cì gî nò gî. Káa ꞌduù tí nó mbe ba ngbù ꞌViì-mì-ꞌDakò nó ká bà giì mbu . À ngbá nìkì táánò káa bà jò yí lá.» ");
INSERT INTO ndz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Káa si ndâ Jézù ta ndâ mbe tala có mì wó kálásê kû zò i, yí giì je kù kô, bìndi  yí giì ùlù Mbíṛì, yí giì kiꞌviki gbí kù kô tí nò, bìndi  yí giì kaa ji ndâ mbe tala có mì wó, bìndi  yí giì ꞌdè có ji ndú máa, «Yo je , ŋìnó a dìì ye.» ");
INSERT INTO ndz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bìndi  yí giì zèè ꞌvisî nèbítì, yí mâ giì ùlù Mbíṛì gî, yí giì je ji ndâ mbe tala có mì wó, ndú ꞌdáá mâ giì njù gî, yí giì ꞌdè có ji ndú máa, ");
INSERT INTO ndz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","«Ŋìnó a mbelè ye, tí mbelè bà njù mùká mì Mbíṛì, àá bà yee to tacó tí ndâ ꞌduù me mbè. ");
INSERT INTO ndz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ye kû ꞌdè có ji yo ta yúcó, máa, ye kákáꞌi bà njù i ta yo wálá yee tí ṛi ngú bà njù  mì ndoo ta ndoo á gbí ꞌbá tí nó náa Mbíṛì kû zogo nô.» ");
INSERT INTO ndz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì cè cè á bìndi i-zó-zò gî, ndú giì njè nó kû ya gí pí Gú Mbâ. ");
INSERT INTO ndz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Káa si ndú a muu nó á kpokèjì, Jézù giì ꞌdè có ji ndú, máa, «Yo bà giì ꞌvaaka ꞌdo tí ye, á go có tí nó náa à cu mí gbí wáràgà mì Mbíṛì énó máa, ‹Ye bà giì gbì mbe gbà rómbo, bìndi  ndâ rómbo bà giì ꞌvaaka gî,› nô. ");
INSERT INTO ndz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Káa kpêtí ká énò, ye bà giì ya gí kùṛo gí bà ùndi yo mí Gàlìléyà á bìndi bà ꞌvala ndi ye á ꞌdo gbí muuꞌdú ye.» ");
INSERT INTO ndz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Káa Pìyétòrò giì ꞌvìsì có ji yí, máa, «Kpêtí sè ndâ ꞌbí ꞌduù ꞌdáá má oloko ꞌdo tí lo gî, ye jé gí bà o ꞌdo tí lo wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Káa Jézù giì ꞌvìsì có ji Pìyétòrò, máa, «Ye kû ꞌdè có ji wò ta yúcó, máa, wúnó ta bèbìlì tí nó, á kùṛo bà kò-kò mì ngùù ta bà  só, wò bà ꞌboo ye ta bà  taꞌô.» ");
INSERT INTO ndz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Káa Pìyétòrò giì ꞌvìsì có ji Jézù ta njembí wó gbaànjé, máa, «À kpêtí má káa ku, à nìkì énô máa ku tí nò ꞌví zi káa ꞌdóó ye gî, á co tí bà o ꞌdo tí lo mì ye.» Bìndi  sè ndâ ꞌbí mbe tala có mì Jézù ꞌdáá gî giì ꞌdè ji yí káa gbèe ŋa có mì Pìyétòrò nò. ");
INSERT INTO ndz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bìndi  ndâ Jézù ta ndâ mbe tala có mì wó mâ giì yee gbí ꞌbí làmbu wúngbó jìlì náa à kû ni mítí  a Jètìsèmánè, Jézù giì ꞌdè có ji ndâ mbe tala có mì wó, máa, «Yo dù nô, wàa ye ꞌví ya gí bà ꞌdeke tí ye ji Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bìndi  yí giì ṛuka ta yí ꞌdo gbí òkò tí ndú káa ndâ Pìyétòrò, ta Jákòmò, ta Jòvánì. Ndú mâ giì yèè ta ndú gí ndiì ꞌdo tí sè ndâ ꞌbí ka ndú gî, gbí dìì wó giì dù kû me máákà, delè tàmuu wó giì ꞌbìtà bà ji gî. ");
INSERT INTO ndz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó tí nò taꞌô nò náa yí ṛuka ndú nò, máa, «Séꞌi yè gbí njembí ye dê gí mì ku. Yo dù bà-i-nò, wàa yo ꞌví kpolo tí yo.» ");
INSERT INTO ndz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bìndi  yí mâ giì yèè ndi wó ꞌdo tí ndú á gí ndiì gî, yí giì ꞌbu gbíṛo mí to, bìndi  yí giì ꞌbìtà bà ꞌdeke tí wó ji Mbíṛì, máa, ꞌbí kpokèjì má kuu, yì ꞌví ndo co tí  ꞌdo kùṛo o tí nó kû gì nó gî. ");
INSERT INTO ndz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Máa, «Àbá, àá Bu ye, kpokèjì gítí ndâ i ꞌdáá gî kuu mì lo. Si ye mí nje gbolò vò có tí nó náa à bà giì waa mítí ye nó lá. Káa wò ꞌví me énò ꞌdo ká gbí ꞌdóó có mí lo gbí muu lo, me ꞌdo gbí có mì ye lá.» ");
INSERT INTO ndz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bìndi  yí mâ giì dele ndi wó gí mì ndâ mbe tala có mì wó tí nó taꞌô nó, yí giì ꞌde ndú tèṛì gî. Bìndi  yí giì ꞌdè có ji Pìyétòrò, máa, «Sìmónè, wò kû tè a ṛì wàà? Yo ni bà dù tí zòꞌo njíꞌdíí lá? ");
INSERT INTO ndz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yo kùtàá bà dù tí zòꞌo, wàa yo ꞌví ꞌdeke tí yo ji Mbíṛì, tacó ndâ vò i ꞌví tala yo lá. À dú káa yúcó, go bà bàkà tó i dú kuu gbí njembí yo, káa wotí tí yo gí tàkò  wálá.» ");
INSERT INTO ndz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bìndi  yí giì dele ndi wó kákáꞌi ya gí bà ꞌdeke tí wó ji Mbíṛì ká go kpédélé ŋìnô. ");
INSERT INTO ndz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yí mâ giì dele ndi wó kákáꞌi gí mì ndâ mbe tala có mì wó, yí giì ꞌde ndú mìì ta ṛì gî. Bà ꞌdè có mì ndú ji yí giì kpò ndú gî, tacó ndú ta o tí nò káa cee ku ndú ku ta ṛì. ");
INSERT INTO ndz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gbí bà taꞌô bà gì yí, yí giì ꞌdè có ji ndú, máa, «Yo tèṛì kpónó, yo ꞌví tè wo yo. Bà  cee gî. À kpónó nó a o bà dò ꞌbì tí ꞌViì-mì-ꞌDakò mí ꞌbì ndâ mbe bèè ṛo Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kùṛo o bà gì mbe ba ngbù ye dooko gî. Yo a gí yaà wàa ndoo ꞌví njè nó.» ");
INSERT INTO ndz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Káa si Jézù kálásê kû ꞌdè có, yí má giì zekeꞌo, yí ngé giì ŋò Júdà tí nó tí ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ mbe tala có mì wó nó, yee ta ndâ ꞌduù me mbè, náa ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ mbe nìbà tàkìì mì ndâ Jùdéyà, ta ndâ kpo-ꞌduù-ꞌbá mì ndâ Jùdéyà ká tuu ndú yee gî. Ndâ ꞌduù tí nò tuṛu mí ꞌbì ndú a ndâ mû, ta ndâ nja-njà sìzò. ");
INSERT INTO ndz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Káa kùṛo bà gì ndú, Júdà tí mbe ba ngbù Jézù kpo-gbí-tà-tù ndú sàà gî, énó máa, «ꞌDuù tí nó náa ye bà ꞌvee yí ta bà òlò gbí tù wó nó a ꞌdakò tí nò. Yo zèè yí, yo ꞌví kpolo tí wó tí kpòò wàa yo ꞌví ya ta yí.» ");
INSERT INTO ndz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Júdà giì gì ká ndírí ya gí mì Jézù. Bìndi  yí giì tèꞌé tí wó, máa, «Mbe nìbà i ji ze!» Bìndi  yí giì ꞌvee yí ta bà òlò gbí tù wó. ");
INSERT INTO ndz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ꞌDo bà-i-nò, ndâ ꞌduù tí nò giì zèè Jézù kácá-kácá. ");
INSERT INTO ndz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Káa ꞌbí ꞌduù mbe kû ṛò tíyò ṛègbà tí Jézù giì ja njà sìzò mì wó, yí giì da tù ꞌbí bòò mì Kùṛo ndâ bu-Mbíṛì waa jàngá gî. ");
INSERT INTO ndz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bìndi  Jézù giì ꞌvee ndâ mbè ꞌduù tí nò, máa, «Ye a mbe ngbà náa yo giì kaa ta ndâ mû, ta ndâ nja-njà sìzò mì ꞌbì yo tacó bà gì gí bà zèè ta ye? ");
INSERT INTO ndz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gbí ndâ o tí nó ꞌdáá gî ꞌdo táánò náa ye kuu ta yo gbí ndùgù ꞌbá-Mbíṛì kû nìbà i ji yo nó, yo jé zèè ye lá. À má énò, yo zèè ye, tacó wàa có tí nó náa à cu mí gbí wáràgà mì Mbíṛì nó ꞌví dù tí  tí yúcó.» ");
INSERT INTO ndz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ta o tí nò ndâ mbe tala có mì Jézù ꞌdáá gî giì njè ꞌdo tí wó ta ngèlè gî, ");
INSERT INTO ndz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","si káa ꞌbí ꞌviì-ꞌdakò mbe gala káa gbèe kpâ-bòngo mítí wó kû ṛu ta ndi Jézù gbí òkò tí ndâ mbè ꞌduù tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ndâ ꞌduù tí nò mâ giì bàkà có bà zèè ꞌviì-ꞌdakò tí nò, yí giì o ta ngèlè ta só, jee kpâ-bòngo tí nò mí ꞌbì ndú. ");
INSERT INTO ndz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ndâ ꞌduù tí nò giì zèè Jézù, bìndi  ndú giì ya ta yí gí ꞌbá mì Kùṛo ndâ bu-Mbíṛì. Ta o tí nò ndâ bu-Mbíṛì, ta ndâ kpo-ꞌduù-ꞌbá, ta ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà kili ꞌdáá gî mí kà. ");
INSERT INTO ndz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Káa ta o tí nò náa ndâ ꞌduù tí nò kû ya ta Jézù nò, Pìyétòrò dù ngéé ndiì kû ko tàkò wó. Yí giì ko tàkò wó yee ngé gbí ndùgù mì Kùṛo ndâ bu-Mbíṛì. Bìndi  yí giì ki tí wó to gbí òkò tí ndâ mbe kpolo tí ꞌbá mì Kùṛo ndâ bu-Mbíṛì, kû u wu gbí ngbàngà. ");
INSERT INTO ndz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ta o tí nò Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò mbe waa có gbí gbolò ngbàngà mì ndâ Jùdéyà kû pà kpokèjì tacó bà waa có ku mítí Jézù, káa ndú ꞌdè gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ndâ ꞌduù me mbè giì dù kû waaka ndâ ꞌvéṛè mítí wó, káa ndâ wááká-waaka có mì ndú nò jé toko lá. ");
INSERT INTO ndz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bìndi  ndâ ꞌbí ꞌdakò giì a gí yaà ta ꞌbí ŋa ꞌvìṛi có mì ndú énó máa, ");
INSERT INTO ndz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Ze táánò ꞌdi kòcò ꞌdakò tí nò kû ꞌdè có máa, ‹Ye bà kiꞌviki ꞌbá-Mbíṛì tí nò náa ndâ ꞌduù bì ta ꞌbì ndú nò gí to, káa gbí sili taꞌô ye bà bì ꞌbí  náa à bì me ta ꞌbì lá.› » ");
INSERT INTO ndz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Káa ta ndâ ŋa ŋìnó ꞌdáá gî, ndâ có mì ndú jé toko lá. ");
INSERT INTO ndz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bìndi  Kùṛo ndâ bu-Mbíṛì giì a gí yaà á kùṛo ndâ mbe waa có ꞌdáá gî, bìndi  yí giì ꞌvee Jézù, máa, «Có mì lo gí tàkò ndâ có tí nò wálá? Ndâ ꞌduù tí nò ꞌdè gítí lo nò a ŋa có yè?» ");
INSERT INTO ndz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Káa Jézù giì ꞌvìsì có gí tàkò ndâ ꞌvé mì Kùṛo ndâ bu-Mbíṛì nò lá. Bìndi  Kùṛo ndâ bu-Mbíṛì kákáꞌi giì ꞌvee ndi Jézù, máa, «Wò a Bìndi-Mbíṛì tí ꞌViì-mì-Mbíṛì?» ");
INSERT INTO ndz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Káa Jézù giì ꞌvìsì có ji yí, máa, «Ye a yí; wò delè bà giì ŋò ꞌViì-mì-ꞌDakò kû ki tí wó gbí kùꞌbì mì Mbe wotí, bìndi  yí bà giì gì ꞌdo gbíṛì co gbí ndâ kùlù mù.» ");
INSERT INTO ndz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ta bà ꞌdi có tí nò, Kùṛo ndâ bu-Mbíṛì giì yaka gbí bòngo tí wó ta sé có gî. Bìndi  yí giì ꞌdè có ji ndâ ꞌduù, máa, «Ndoo kpòò kû pà a ndâ mbe ꞌdè yúcó ngàyi? ");
INSERT INTO ndz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yo ꞌdi bà ꞌdè zu có mì wó gítí Mbíṛì gî. Ndòngbú có mì yo máa yè?» Káa ndâ ꞌduù tí nò ꞌdáá gî giì waa có mítí Jézù, máa, à ꞌvii ta yí káa ku. ");
INSERT INTO ndz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bìndi  ndâ ꞌbí ꞌduù gbí òkò tí ndâ ꞌduù tí nò giì ꞌbìtà bà cù cù mítí Jézù. Ndú giì eṛe i mítí ṛo wó, ndú giì ꞌbìtà bà dòmò yí ta ꞌbì ndú si yí gbí sú ṛo, kû ꞌviya ta yí máa, «Nì ṛè ndâ mbe kû bàkà ndâ i tí nò mítí lo nò!» Ndâ mbe kpolo tí ndâ ꞌduù gbí zàà giì dù kû gbì yí. ");
INSERT INTO ndz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Káa si Pìyétòrò kálásê kuu ṛègbà wu gbí ngbàngà mì Kùṛo ndâ bu-Mbíṛì, ꞌbí niì mbe kû bàkà nèté ꞌbá mì Kùṛo ndâ bu-Mbíṛì giì co gí gbí ngbàngà ṛègbà wu. ");
INSERT INTO ndz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Yí mâ giì zekeꞌo, yí giì ŋò Pìyétòrò kû u wu. Yí giì ꞌviiki yí, bìndi  yí giì ꞌdè có ji yì, máa, «Wò delè táánò kû dù toko ta Jézù tí nò tí ꞌduù Názàrètì nô.» ");
INSERT INTO ndz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Káa Pìyétòrò giì tò kponje có tí nò náa niì tí nò ꞌdè nò gî. Bìndi  yí giì ꞌvìsì có ji niì tí nò, máa, «Ye ŋò ꞌduù tí nò ni lá. Ye delè ngbá ꞌdi gbí ŋa có mì lo nò lá.» Bìndi  yí giì co gí njekèjì ndùgù. ");
INSERT INTO ndz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Káa niì tí nò kákáꞌi mâ giì ŋò Pìyétòrò kû ṛò tíyò njekèjì ndùgù, yí giì ꞌbìtà bà ꞌdè có ji ndâ ꞌduù tí nó mbe kû ṛò tíyò bà-i-nò nó, máa, «ꞌDakò tí nò a ꞌduù ꞌdo gbí òkò tí ndâ ꞌduù tí nó mbe kû dù toko ta Jézù nô.» ");
INSERT INTO ndz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Káa Pìyétòrò kákáꞌi giì tò kponje gî. Káa ndú mâ giì dù gàà énó, ndâ ꞌduù tí nó mbe kû ṛo tíyò á ṛègbà tí Pìyétòrò nó giì ꞌdè có ji yí, máa, «Ta yúcó wò a ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ ꞌduù mì Jézù, tacó wò a ꞌduù Gàlìléyà.» ");
INSERT INTO ndz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Káa Pìyétòrò giì ꞌbìtà bà see tí wó ta bà gò ku, máa, «Ye ŋò ꞌdakò tí nò náa yo kû ꞌdè có gítí wó nò ni lá.» ");
INSERT INTO ndz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Káa ngùù ngé giì kò ꞌbí kò. Bìndi  mbí Pìyétòrò giì ꞌva tí có tí nó náa Jézù ꞌdè ji yí, máa, «Kùṛo bà kò-kò mì ngùù ta bà  só, wò bà ꞌboo ye ta bà  taꞌô nô.» Bìndi  yí giì ꞌbìtà bà wa gbí. ");
INSERT INTO ndz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ta fírí dúꞌo, ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-ꞌduù-ꞌbá, ta ndâ kpo-kpò mbe nìbà i, ta ndâ kpo-kpò ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà ngé giì kili ta bà muu ndú gálà-gálà gî. Ndú giì toko có mì ndú gbaànjé, ndú giì eṛe Jézù gî, bìndi  ndú giì ya ta yí gí kùṛo Pìlátò, ta ŋa wó a Ròmánò tí gbolò ꞌduù mbe kû zogo ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ndú mâ giì yee ta yí kà, Pìlátò giì ꞌvee Jézù, máa, «Wò a gbolò gba mì ndâ Jùdéyà?» Káa Jézù giì ꞌvìsì có ji yí, máa, «A wò ká ꞌdè énò.» ");
INSERT INTO ndz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ndâ bu-Mbíṛì mì ndâ Jùdéyà ta o tí nò kpì ngbàngà tí Jézù ji Pìlátò tacó ndâ i me mbè. ");
INSERT INTO ndz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bìndi  Pìlátò giì ꞌvee yí kákáꞌi, máa, «Wò ꞌdi ŋa mbè ndâ ngbàngà tí nó náa ndú kpì ta ṛè lo nó gî. Có mì lo tacó bà njaanga miṛi lo wálá?» ");
INSERT INTO ndz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Káa nje Pìlátò giì ꞌdèè gî, tacó Jézù kákáꞌi giì ꞌvìsì có gbaànjé gí tàkò ndâ có tí nò ꞌdáá gî lá. ");
INSERT INTO ndz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ta ndoò ꞌdáá gî, ta o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì, ꞌbí ŋa i mì Pìlátò a bà peteke tàkòcò ndâ bòò mì wó ta bà njaanga ꞌbí ꞌduù gbaànjé mbe nìkì tí ndú ꞌdo gbí zàà ji ndú. ");
INSERT INTO ndz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Káa ta o bà zèè Jézù nò, ꞌbí ꞌdakò ta ṛè wó a Bàrábà, náa a zèè ndú ta ndâ ꞌbí vo-vò ꞌduù tacó bà zi ku a gbí wo, kuu gbí zàà. ");
INSERT INTO ndz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ndâ ꞌduù mâ giì kili me mbè mí gbí ngbàngà mì Pìlátò ta o tí nò gî, ndú giì kaa ya gí bà yù nambeè ꞌdo mì wó, máa yí njaanga ꞌbí ꞌduù gbaànjé ꞌdo gbí zàà ji ndâ yì á go ŋìnó náa yí kû bàkà ta ndoò ꞌdáá gî nô. ");
INSERT INTO ndz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Káa Pìlátò giì ꞌvee ndú, máa, «Có mì yo kpónó máa ye ꞌví njaanga ji yo á ꞌdi a ꞌdo gbí zàà? Ye njaanga gbolò gba mì ndâ Jùdéyà ji yo?» ");
INSERT INTO ndz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pìlátò ꞌvee ŋa ꞌvé tí nò tacó yí ŋò ni gî máa, a káa kiì ká te ndâ Kùṛo ndâ bu-Mbíṛì gítí Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ndú ta o tí nò volo muu ndâ ꞌduù ꞌdáá gî énó máa, ndú ꞌví ꞌdè có ji Pìlátò, máa, yí ꞌví njaanga a Bàrábà ꞌdo gbí zàà ji ndâ yì. Máa, yí ꞌví njaanga Jézù lá. ");
INSERT INTO ndz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bìndi  Pìlátò giì ꞌvee ndâ ꞌduù tí nò kákáꞌi, máa, «Káa ꞌdakò tí nó náa yo kû ꞌdè có máa, yí a gbolò gba mì ndâ Jùdéyà nó, ye ꞌví bàkà ta yí a yè?» ");
INSERT INTO ndz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Káa ndú ꞌdáá gî giì pìì kû ta kòcò ndú ngéé gí yaà, máa, «Gbì yí mítí njèèkpè mû!» ");
INSERT INTO ndz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bìndi  Pìlátò giì ꞌvee ndi ndú, máa, «Tacó yè? Yí bàkà a ŋa vò i yè?» Káa ndú kákáꞌi giì pìì kû ta kòcò ndú gí yaà ndii ŋìnó sàà kùṛo nó gî, máa, «Gbì yí mítí njèèkpè mû!» ");
INSERT INTO ndz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tacó énò, Pìlátò giì njaanga Bàrábà gí sè ꞌdo gbí zàà tacó bà peteke tàkòcò ndâ ꞌduù. Bìndi  yí giì je Jézù ji ndâ àsìkérì máa, ndú ya ta yí, wàa ndú ꞌví gbì yí ta kùrùbájì má kózò gî, wàa ndú ꞌví giì ya gí bà gbì yí mítí njèèkpè mû. ");
INSERT INTO ndz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ndâ àsìkérì giì ya ta Jézù gí gbí ngbàngà gbí ndùgù mì Pìlátò, náa à kû nì mítí  a Pìrìtórìyùmù. Sè ndâ ꞌbí ka ndú mâ giì kili ꞌdáá gî, ");
INSERT INTO ndz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ndú giì jaka ndâ bòngo mì wó ꞌdo tí wó gî. Bìndi  ndú giì yuu bí-bi bòngo tí bòngo gba mítí wó. Ndú delè giì te tàgíyà-gba náa ndú tu ꞌdo tí kpeṛè mítí muu wó. ");
INSERT INTO ndz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bìndi  ndú giì ꞌbìtà bà ꞌviya yí ta bà ꞌvee yí, máa, «Kútí lo ée? Gbolò kùṛo ndâ Jùdéyà!» ");
INSERT INTO ndz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ndú giì ꞌbìtà bà gbì yí ta njì ngba ta tí muu wó, ta bà cù cù mítí wó; ndú giì dù kû ꞌviya yí ta bà kucuku muungbó ndú mí kùṛo wó, kû ŋo ta yí, máa ndâ yì kû ùlù yí. ");
INSERT INTO ndz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ndú mâ ŋonoko ndi wó tè ta ndú gî, ndú giì ja bòngo gba tí nò náa ndú yuu ji yí nó ꞌdo tí wó gî, bìndi  ndú giì yuu ndi ndâ ꞌdóó bòngo mì wó mítí wó. ");
INSERT INTO ndz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bìndi  ndâ àsìkérì giì ja yí ꞌdo gbí gbata gí sè tacó bà ya gí bà gbì yí mítí njèèkpè mû. Káa si ndú kpokèjì, ndú giì ꞌde ꞌbí ꞌdakò ta ṛè wó a Sìmónè, tí ꞌduù Sìrínì, tí bu ndâ Àlèsándòrò ta Rúfò, kû gì ꞌdo ꞌbá gí gbí gbata Jèrùzàlémè. Bìndi  ndú giì zèè yí gítí bà te njèèkpè mû mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bìndi  ndú giì ya ta Jézù gítí ꞌbí bàndò náa à kû nì mítí  a Gòlìgátà, gbí  énó máa, bàndò kùsu muu ndâ ku. ");
INSERT INTO ndz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ndâ àsìkérì mâ giì yee ta Jézù tí bàndò bà zi yí gî, ndú giì je nèbítì náa à ŋònòkò ta ꞌbí ŋa yeè bà zi dìì ꞌduù náa à kû nì mítí  a «mírì» ji yí. Káa yí giì biya bà njù gî. ");
INSERT INTO ndz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bìndi  ndú giì gbì yí mítí njèèkpè mû. Ndú mâ giì gbì yí mítí njèèkpè mû gî, ndú giì njèè gbí ndâ bòngo mì wó gbí òkò tí ndú ta bà ki-mbílì. ");
INSERT INTO ndz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","À gbì Jézù mítí njèèkpè mû ta ṛi dúꞌo. ");
INSERT INTO ndz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bìndi  à giì cu ndeṛè ku wó gbì mítí njèèkpè mû á còmuu wó énó máa, yí a gbolò gba mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ta gbèe o tí nò delè, à giì gbì ndâ ꞌbí mbe ngbà sósòꞌô mítí ndâ njèèkpè mû, ꞌbí  mò gí gbí kùꞌbì, bìndi  ꞌbí  mò gí gbí gàlì mì Jézù, ");
INSERT INTO ndz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","go có tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì cu sàà gî, máa, «À kaa yí mò gí mì ndâ vò ꞌduù» nô. ");
INSERT INTO ndz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ndâ mbe kû ndii ta nó co tí kpokèjì giì zeke yí ta bà mìyà muu ndú, delè ta bà ŋo yí, máa, «Ìyo le! Wò tí mbe ꞌdè có táánò máa, wò bà kiꞌviki ꞌbá-Mbíṛì gí to, wàa wò ꞌví bì ndí  bìndi sili taꞌô! ");
INSERT INTO ndz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ꞌVala tí lo gi! Co gí to ꞌdo tí njèèkpè mû!» ");
INSERT INTO ndz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò mbe nìbà i mì ndâ Jùdéyà giì dù kû ŋo yí, máa, «Yí ŋò ni káa bà ꞌvala ndâ ꞌbí ka wó, káa bà ꞌvala tí wó kpò yí gî. ");
INSERT INTO ndz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Si Bìndi-Mbíṛì, tí gbolò gba mì ndâ Ìzìrìyélì, ꞌví co gí to ꞌdo tí njèèkpè mû kpónó, tacó wàa ndoo má ŋò gî, ndoo ꞌví ù ta nje gítí wó.» Ndâ mbe ngbà tí nó náa à gbì ndú mítí njèèkpè mû nò delè giì ꞌdè ndâ zu có gítí wó. ");
INSERT INTO ndz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ta ṛi gbúrú, ꞌdíꞌdiꞌo giì yiiga muu to yùkúú gî yee tí o bà mò tí mì ṛi. ");
INSERT INTO ndz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bìndi  Jézù giì tò kû ta kòcò wó ngéé gí yaà, máa, «Èlóyì, Èlóyì, lámà sàbàkìtánì.» Gbí  énó máa, «Àá Mbíṛì mì ye! Àá Mbíṛì mè! Wò ꞌvìsì kapí lo á gítí ye tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ndâ ꞌbí ꞌduù mbe kû ṛò tíyò á bàndò tí nò má giì ꞌdi có tí nò, ndú giì ꞌdè có, máa, «Yo ꞌdi gi! Yí kû tèꞌé tí Èlíjà tí nó táánò tí mbe ꞌdòkò có mì Mbíṛì nô.» ");
INSERT INTO ndz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bìndi  ꞌbí ꞌduù giì je ꞌbí i mbe kû njù ngo go kàfòlò-ngo nó, yí giì ì ngèlè ya gí bà yuu mí gbí pe nèbítì mbe me zùù-zùù gî, yí giì sè mí nje njì ngba, bìndi  yí giì te mí nje Jézù, ta bà ꞌdè có máa, «Ndoo dùú, wàa ndoo ꞌví ŋò bà gì gí bà ja yí mì Èlíjà ꞌdo tí njèèkpè mû gí to gi.» ");
INSERT INTO ndz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Káa Jézù giì tò ꞌbí kû kákáꞌi ta kòcò wó ngéé gí yaà, bìndi  njembí wó giì ki gî. ");
INSERT INTO ndz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ta o bà cee Jézù, gbí kpâ-bòngo tí nó mbe njèè gbí tàꞌi ꞌbá-Mbíṛì nó, giì yaka gbí tí wó ꞌdo yaà dí to. ");
INSERT INTO ndz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kùṛo ndâ àsìkérì tí nó mbe ṛò tíyò kû zeke Jézù nó mâ giì ŋò cè bà ki njembí Jézù nò, yí giì ꞌdè có máa, «ꞌDakò tí nò táánò dú ta yúcó a ꞌViì-mì-Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ta o tí nò ndâ Màríyà Màdèlénà, ta Màríyà nawu ndâ làmbu Jákòmò ta Jùzépè, ta Sàlómè, tí ndâ niì tí nó táánò ");
INSERT INTO ndz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","mbe kû ṛu ndi Jézù, delè mbe kû konì yí si yí á Gàlìléyà nó, giì ṛò tíyò me ꞌdú gbí òkò tí ndâ ꞌbí niì tí nó mbe ko tàkò wó ꞌdo Gàlìléyà gítí  gí Jèrùzàlémè nó, kû zeke ndâ i tí nó náa à kû bàkà mítí wó nô. ");
INSERT INTO ndz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ta ꞌdêꞌo si ndâ Jùdéyà kû ꞌviindi tí ndú gítí ṛi bà wotí gbí tàkìì mì ndú, ");
INSERT INTO ndz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ꞌbí ꞌdakò ta ṛè wó a Jùzépè mbe gì ꞌdo gbí gbata Àrìmàtíyà, tí ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà náa ndâ ꞌduù ꞌdáá gî kû te duù mítí wó, tí ꞌduù mbe kû koṛo có gítí o bà zèè ꞌbá mì Mbíṛì, giì zèè njembí wó, bìndi  yí giì ya gí bà ꞌvee Pìlátò máa, yí si yì ꞌví duu ku Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Káa nje Pìlátò giì ꞌdèè gítí có bà cì Jézù gálà énò gî; tacó énò, yí giì tèꞌé tí kùṛo ndâ àsìkérì, bìndi  yí giì ꞌvee yí, máa Jézù cì gî wè? ");
INSERT INTO ndz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kùṛo ndâ àsìkérì tí nò mâ giì ꞌdè có ji yí máa, Jézù cì gî, gî, Pìlátò giì ùnje ji Jùzépè máa, yí ya gí bà te ku Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nò gí, Jùzépè giì sì ó kpâ-bòngo, yí mâ giì te ku Jézù ꞌdo tí njèèkpè mû gí to gî, yí giì so gî, bìndi  yí giì te yí ya tí  gí gbí gùù náa à ba mí gbí díí, bìndi  yí giì mèṛèkè ꞌbí gbolò díí mí nje gùù tí nò. ");
INSERT INTO ndz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Káa ta o tí nò ndâ Màríyà Màdèlénà ta Màríyà nawu Jùzépè ŋò bàndò bà duu Jézù nò gî. ");
INSERT INTO ndz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ṛi bà wotí mâ giì ta gî, ndâ Màríyà Màdèlénà ta Màríyà nawu Jákòmò, ta Sàlómè giì sì pó bàà tacó bà ya gí bà too mítí ku Jézù. ");
INSERT INTO ndz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta fírí dúꞌo mì sili gbaànjé bìndi ṛi bà wotí, ndú giì njè nó ya gí bà ŋò muuꞌdú si ṛi co jéé gî. ");
INSERT INTO ndz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Káa si ndú kpokèjì, ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú, máa, «À ꞌdi wúnó ká bà mèṛèkè díí tí nò ꞌdo njekèjì ꞌbá muuꞌdú ji ndoo?» ");
INSERT INTO ndz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ndú ꞌvee ꞌvé tí nò, tacó díí tí nò me gbolò ngé ndii gî. Káa ndú mâ giì zekeꞌo, ndú giì ŋò njekèjì ꞌbá muuꞌdú ngàà. ");
INSERT INTO ndz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ndú mâ giì ṛì gí tàꞌi kà, ndú giì ꞌde ꞌbí ꞌviì-ꞌdakò kû ki tí wó to mò gí gbí kùꞌbì mì ndú ta njà cé-ce bòngo tí wó. Gúku giì bàkà ndú ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Káa ꞌviì-ꞌdakò tí nò giì ꞌdè có ji ndú, máa, «Yo si bà cì gúku mí to. Yo wálá kû pà a bà tí Jézù tí nó mbe gì ꞌdo Názàrètì náa à gbì yí mítí njèèkpè mû nó? Yí ꞌvala ndi wó ꞌdo gbí ku gî. Yí bà-i-nó wálá. Yo gì gí bà ŋò bàndò tí nò náa à táánò sii ku wó mítí  nô. ");
INSERT INTO ndz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nò gí. Yo dele ndi yo ya gí bà ꞌdè có ji ndâ mbe tala có mì wó, ta ndâ Pìyétòrò, máa, yí kû ya gí kùṛo bà ùndi ndú mí Gàlìléyà. Ndú bà ꞌde yí a i kà, á go cí tí nó táánò náa yí ci ta ndú nô.» ");
INSERT INTO ndz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ndâ niì tí nò giì njè ta ngèlè ꞌdo tà ꞌbá muuꞌdú ta bà gu ta gúku. Bà ꞌdè có ji ndâ ꞌduù tí kpokèjì giì kpò ndú ta o tí nò gî, tacó gúku eṛe nje ndú gî. ");
INSERT INTO ndz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jézù ꞌvala ndi wó ꞌdo gbí muuꞌdú wó ta fírí dúꞌo ta yé bìndi ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà. Bìndi  kpédélé ꞌduù náa yí giì tùbà tí wó ji yí a Màríyà Màdèlénà, tí niì tí nó náa yí táánò mòkò ndâ i vô-nje só á ꞌdo gbí muu wó nô. ");
INSERT INTO ndz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Màríyà Màdèlénà giì ya gí bà ꞌdè ndí  ji ndâ mbe tala có mì wó si ndú kû wa ku wó. ");
INSERT INTO ndz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Káa gbèe ꞌduù mbe ùnje gítí có mì wó nò giì dù lá. ");
INSERT INTO ndz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bìndi bà tùbà tí wó ji Màríyà Màdèlénà nò, Jézù giì tùbà tí wó ji ndâ ꞌbí mbe tala có mì wó sósòꞌô gbí ꞌbí ŋa kpokèjì tende, si ndú a kpokèjì kû ya gí ꞌbá mì ndú ꞌdo gbí gbata Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ndú giì dele ndi ndú ya gí bà ꞌdè ndí  ji ndâ ꞌbí ka ndú. Káa ndâ ka ndú giì ùnje gítí có mì ndú nò delè lá. ");
INSERT INTO ndz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bà taꞌô ŋìnó Jézù giì tùbà tí wó ji ndâ tú mì wó muuꞌbì-nje gbaànjé si ndú kû zò i. Yí giì ꞌdè kòlòwò gítí ndú, tacó ndú ùnje gítí Mbíṛì ta njembí ndú lá, delè tacó njembí ndú kpolo go duù tacó bà ùnje gítí ndâ có mì ndâ ka ndú mbe ŋò yí á bìndi bà ꞌvala ndi wó á ꞌdo gbí muuꞌdú wó. ");
INSERT INTO ndz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bìndi  yí giì tuu ndú, máa, «Yo ya cee muu to tí nó ꞌdáá gî, wàa yo ꞌví ma Banga-Ngú-Có mì Mbíṛì á ji ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ꞌDuù ŋìnó mbe ùnje ta njembí wó, bìndi  à ꞌví caka tí wó gî, bà ꞌde ꞌvala ꞌdo mì Mbíṛì gî. Káa Mbíṛì bà waa có mítí ꞌduù ŋìnó mbe biya bà ùnje gî nô. ");
INSERT INTO ndz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mbíṛì bà giì je wotí bà bàkà ndâ seṛè ji ndâ mbe ùnje gítí ndâ cò mì ye: ndú bà giì mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ta ṛè ye; ndú delè bà giì ꞌdè ndâ tende ŋa nje có, náa ndú jé ꞌdè sàà kùṛo lá; ");
INSERT INTO ndz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ndú delè bà giì zèè ndâ kpoo ta ꞌbì ndú; ndú kpêtí má giì njù jâ, ndú bà cì tí  wálá; ndú bà ꞌvala ndâ mbe séꞌi ta bà tee ꞌbì ndú mítí ndú.» ");
INSERT INTO ndz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mbe tí ndoo Jézù mâ giì nìbà ndâ i ji ndâ mbe tala có mì wó cee gî, Mbíṛì giì te yí ya tí  gí bà ki tí gbí kùꞌbì mì wó á gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bìndi  ndâ mbe tala có mì wó giì ꞌvaaka ꞌdo Jùdéyà cee muu to tí nó ꞌdáá gî kû ma có mì Mbíṛì ji ndâ ꞌduù. Yí tí Jézù delè giì je wotí bà bàkà ndâ seṛè ji ndú, tacó bà tùbà  ji ndâ ꞌduù énó máa, ndâ có tí nó náa ndú kû ma nó dú káa ndâ có mì Mbíṛì.");
INSERT INTO ndz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ye ŋò ndâ ꞌbí ka ye me mbè cu có gítí ndâ i tí nó táánò mbe bàkà tí gbí òkò tí ndoo nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ndú cu ndírí jé káa ndi kòcò ndâ ꞌduù tí nó táánò mbe kû nìbà i ji ndoo, tí ndâ mbe ŋò ṛèngbó ndâ i tí nò mbe bàkà tí nò táánò ta ṛo ndú gî nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ye ta ꞌdóó miṛi ye delè ꞌviiki gbí ndâ có tí nò lézé-lézé ꞌdo tí bà ꞌbìtà ndú gî. À má énò, ndòngbú kóṛó-koṛo có mì ye kpónó énó máa, ye cu ndú ꞌdo tí ṛèngbó ndú ji wò néméé énô, Tèyófìlò. ");
INSERT INTO ndz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ye bà bàkà énò, tacó wàa wò tí kpo ꞌduù mì ze ꞌví ꞌdi ta gbí ndâ có tí nó náa wò táánò ꞌdi gítí ndâ i tí nò ngbáṛángàꞌi énô. ");
INSERT INTO ndz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ye kû ꞌbìtà có ꞌdo tí Zàkàríyà tí ꞌbí bu-Mbíṛì mì ndâ Jùdéyà dígísèé gbí o mì Èródè, tí gbolò gba mì ndâ Jùdéyà ꞌdáá gî. Zàkàríyà tí nò dígísèé a bu-Mbíṛì ꞌdo gbí òkò tí ndâ bu-Mbíṛì ŋìnó ta ṛèngbó ndú ꞌdo tí bu-Mbíṛì tí nó ta ṛè wó a Àbíjà nô. Zàkàríyà delè giì kò Èlìzàbétà tí jú kòtí Àrónì, tí bu-Mbíṛì gbí o mì Mòze. ");
INSERT INTO ndz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ndâ Zàkàríyà ta Èlìzàbétà ta o tí nò só káa ndâ ꞌduù ŋìnó mbe kû co ká jáá tí kpokèjì mì Mbíṛì, mbe kû ꞌdi có mì Mbíṛì, delè mbe kû bàkà go ndâ có tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Káa ꞌviì mì ndú wálá, tacó Èlìzàbétà a kázá. Delè tacó ndú só me kpo ꞌduù ndii o bà bà jò ꞌviì gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","À ta o tí nò a o bà bàkà i-Mbíṛì mì ndâ bu-Mbíṛì tí nó tí ndâ bòò Àbíjà nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ndú mâ giì pà-có ta bà ki-mbílì go i gbí tàkìì mì ndú, tacó bà ŋò bu-Mbíṛì ŋìnó gbí òkò tí ndú náa yí ꞌví dù tí mbe gbo ngûwu dì mí bàndò mì Mbíṛì ta o tí nò nó, à giì ṛò mítí Zàkàríyà. ");
INSERT INTO ndz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","O bà doo dì mâ giì gì gî, Zàkàríyà giì ya gí tàꞌi ꞌbá-Mbíṛì tí bàndò tí nó ta ku-sòṛò-Mbíṛì kû dù tí  nô. Káa ndâ ꞌduù me mbè giì kili kû ꞌdeke tí ndú ji Mbíṛì sè. ");
INSERT INTO ndz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zàkàríyà mâ giì zekeꞌo si yí tàꞌi á bàndò gbo ngûwu dì ta kpéétí wó, yí giì ŋò basìlì mì Mbíṛì kû ṛò tíyò mò gí gbí kùꞌbì tí bàndò tí nó náa káꞌi bà gbo dì kû dù tí  nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zàkàríyà bà-i-nò giì dù káa naꞌva ta gúku bà ŋò basìlì tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Káa basìlì tí nò giì ꞌdè có ji Zàkàríyà máa, «Zàkàríyà, cì gúku lá! Tacó ye gì a i tacó bà ꞌdè có ji wò énó máa, Mbíṛì ŋò yê ṛo bà ꞌdeke tí lo tacó bà jò ꞌviì gî. Nawù lo Èlìzàbétà kèjì gí bà jò ꞌviì tí ꞌviì-ꞌdakò, wàa wò ꞌví gbì ṛè wó tí Jòvánì. ");
INSERT INTO ndz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tàkòcò lo bà peteke ta líkíꞌo bà jò ꞌviì tí nò ta ŋa  wálá. Líkíꞌo delè bà bàkà ndâ ꞌduù me mbè ta o bà jò ꞌviì tí nò ngé ma. ");
INSERT INTO ndz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tacó ꞌviì tí nò bà dù tí gbolò ꞌduù á kùṛo Mbíṛì. Yí bà tee ꞌbí ŋa i ta ṛè  a pe mítí nje wó wálá. Bèṛi-mì-Mbíṛì bà ꞌbìtà bà dù gbí njembí wó ꞌdo ká gbí yì nawu wó. ");
INSERT INTO ndz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yí bà gì tí mbe ꞌvìsì muu ndâ Ìzìrìyélì ŋìnó mbe giṛiꞌo gî nó gítí kpokèjì mì Mbe tí ndú tí Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yí bà je a njembí ta wotí bìndi Èlíjà tí nó dígísèé tí mbe ꞌdòkò có mì Mbíṛì nó, kû ꞌvii ta ndi gbí òkò tí ndâ ꞌviì ta ndâ bu ndú; yí bà dù tí mbe ꞌvìsì muu ndâ mbe kpò có á gítí bà koṛo có go i mì ndâ mbe kû co tí jáá kpokèjì mì Mbíṛì; yí delè bà dù tí mbe ꞌviindi muu ndâ ꞌduù mì Mbe tí ndoo kû ù ta ndi bà gì yí.» ");
INSERT INTO ndz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Káa Zàkàríyà giì ꞌvee basìlì tí nò máa, «Ye bà ŋò ni ta yè, máa có tí nò náa wò ꞌdè nò a yúcó?» ");
INSERT INTO ndz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Káa basìlì tí nò giì ꞌvìsì có ji Zàkàríyà máa, «Ṛè ye a Gàbìrìyélè, tí mbe kû ṛò tíyò á kùṛo Mbíṛì. A Mbíṛì ká tuu ye, máa, ye gì gí bà ꞌdè banga ngú có tí nò ji wò. ");
INSERT INTO ndz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","À má énò, wò ꞌdo tí kpónó bà dù tí ngbiṛí, wò delè bà ꞌdè có wálá yee tí o bà bàkà tí mì i tí nò náa ye ꞌdè có gítí  ji wò nò. Tacó wò biya bà ꞌdi có mì ye gî.» ");
INSERT INTO ndz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nje ndâ ꞌduù tí nó mbe kû ꞌdeke tí ndú sè nó giì ꞌdèè gítí bà dù Zàkàríyà á bàndò bà gbo ngûwu dì ta kôndi wó énò gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Káa yí mâ giì co ꞌdo kà gí sè, yí mâ giì bàkà bà ꞌdè có ji ndâ ꞌduù, à giì kpò yí gî. Yí bà-i-nò giì dù kû bàkà káa i go i mì mbe sú tù nó, ta bà mìyà ꞌbì wó ji ndâ ꞌduù. Ndâ ꞌduù giì ŋò ngé ni gî máa, ꞌbí tende i ꞌde yí tàꞌi bàndò bà gbo ngûwu dì kà gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","O bà bàkà nèté mì Zàkàríyà á tàꞌi ꞌbá-Mbíṛì mâ giì cee gî, yí giì dele ndi wó gí ꞌbá mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Zàkàríyà giì bàkà mí ꞌbá káa làmbu o mâ giì zekeꞌo, nawù wó Èlìzàbétà giì tè nakáyì gî. Bìndi  yí giì nè tí wó mí gbí gùùtàꞌi ta nakáyì ta pì vô ");
INSERT INTO ndz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","kû ùlù Mbíṛì máa, «Mbíṛì bàkà nambeè ji ye ngé ndii gî! Yí ꞌvala ye ꞌdo gbí bà ŋonoko ye mì ndâ ꞌduù gî.» ");
INSERT INTO ndz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ta ꞌbí o gbaànjé, si pì tí Èlìzàbétà ta nakáyì vô-nje gbaànjé, Mbíṛì giì tuu ndi gbèe basìlì mì wó tí Gàbìrìyélè náa yí tuu yí ji Zàkàríyà nó gí gbí gbata Názàrètì á gbí to Gàlìléyà, ");
INSERT INTO ndz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","á ji ꞌbí ngbutu ꞌvinî ta ṛè wó a Màríyà, náa à ꞌvee có tí wó ji ꞌbí ꞌdakò ta ṛè wó a Jùzépè tí ꞌviì kòtí Dàvídè tí gbolò gba gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gàbìrìyélè mâ giì yee ꞌbá mì ndâ Màríyà gî, yí giì ṛì gí tàkò Màríyà tàꞌi. Bìndi  yí giì ꞌvee yí máa, «Kútí lo ée, tó ꞌduù mì Mbíṛì? Mbíṛì kuu ta wò!» ");
INSERT INTO ndz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Káa nje Màríyà giì ꞌdèè gítí bà ꞌvìsì ꞌvé gí tàkò ŋa ꞌvé mì Gàbìrìyélè nò gî. Bìndi  yí giì dù kû ꞌviiki gbí ŋa ꞌvé tí nò gbí muu wó ta kpéétí wó. ");
INSERT INTO ndz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gàbìrìyélè mâ giì ŋò énò, yí giì ꞌdè có ji Màríyà máa, «Cì gúku lá, Màríyà, tacó Mbíṛì bàkà nambeè ji wò me gbolò ngé ma. ");
INSERT INTO ndz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wò kèjì gí bà tè nakáyì. Wò bà jò ꞌviì tí nò tí ꞌviì-ꞌdakò. Bìndi  wò bà gbì ṛè wó tí Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ꞌViì tí nò bà dù tí gbolò ꞌduù. Ṛè wó bà dù a ꞌViì-mì-ꞌDuù-tí-nó-gbíṛì nô. Mbe tí ndoo tí Mbíṛì bà si ꞌviì tí nò ꞌví dù tí gbolò gba á bìndi gù wó Dàvídè yee tí ndòngbú o. ");
INSERT INTO ndz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yí bà zogo ꞌbá bìndi gù wó Jàkóbè ká kpòò ya tí . Yí delè bà dù tí gba ká kpòò ya tí .» ");
INSERT INTO ndz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Káa Màríyà giì ꞌvee basìlì tí nò máa, «Ye bà toṛo tí ye a i mítí tiì wàa ye ꞌví jò ta ꞌviì tí nò?» ");
INSERT INTO ndz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Káa basìlì tí nò giì ꞌvìsì có ji Màríyà máa, «Bèṛi-mì-Mbíṛì bà gì gí muu lo, delè wotí mì Mbíṛì tí nó á mbe dù ngéé yaà gbíṛì nó bà gèè bè mí muu lo. Tacó énò, ṛè ꞌviì tí nò náa Mbíṛì kaa yí mò gí mì wó gî nò a ꞌViì-mì-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ŋò nô, à kpêtí káa kpo niì tí nó tí nambe lo ta ṛè wó a Èlìzàbétà, náa ndâ ꞌduù táánò kû ŋonoko yí, máa yí a kázá nó, kpónó ta ꞌviì ŋìndi pì vô-nje gbaànjé gbí yì wó. ");
INSERT INTO ndz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tacó ꞌbí i mbe kpò Mbíṛì wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Káa Màríyà bà-i-nò giì ꞌvìsì có ji basìlì tí nò máa, «Ye a bòò mì Mbíṛì; à má énò, si à ꞌví bàkà tí mítí ye go có tí nò náa wò ꞌdè nò.» ꞌDo bà-i-nò, basìlì giì taꞌva ꞌdo ṛo Màríyà gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Màríyà bàkà bìndi bà njè nó mì basìlì tí nò káa làmbu o, bìndi  yí giì co ngòꞌve wiṛi ya gí ꞌbá mì Èlìzàbétà gbí ꞌbí gbata pí gú gbí to Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Màríyà mâ giì yee kòtí Zàkàríyà, yí mâ giì nì «Ye yee gî,» ji nambe wó Èlìzàbétà, ");
INSERT INTO ndz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Èlìzàbétà giì gundiì ta bà ꞌdi kòcò Màríyà nò tí ŋa ŋìnó náa ꞌviì gbí yì wó giì o ꞌdo gbí kudu gî. Bìndi  Bèṛi-mì-Mbíṛì giì je wotí bà ꞌdè-kòcò ji yí. ");
INSERT INTO ndz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bìndi  yí giì ꞌvìsì có ji Màríyà bà-i-nò gbí nga nje wó máa, «Mbíṛì bàkà nambeè ji wò gbí òkò tí ndâ niì ꞌdáá gî ngé ndii gî, Màríyà. Yí delè bàkà nambeè ji ꞌviì tí nò á kpónó ta tà-ngo-yì wó tí lo nò ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ŋa gbolò có tí nó ꞌde ye énó tacó yè, náa à giì co gbí  a nawu Mbe tí ye ká giì co wiṛi gì gí ꞌbá mì ye nó? ");
INSERT INTO ndz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tacó à káa póó bà ꞌdi kòcò lo mì ye, ꞌviì gbí yì ye giì o ta líkíꞌo ꞌdo gbí kudu mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A gbolò tó pá ká tàkò niì tí nó mbe ùnje énó máa, Mbíṛì ꞌví bàkà ta yì go có tí nó náa à gbí muu wó tí Mbíṛì,» nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Màríyà bà-i-nò giì ꞌvìsì có gí tàkò có mì Èlìzàbétà nò ta bà cè cè kû be ta ṛè Mbíṛì máa, «Ye kû ùlù Mbe tí ye ta njembí ye gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ye kû dùlù tí ye ta ṛè Mbíṛì tí mbe ꞌvala ye, ");
INSERT INTO ndz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","tacó mbí wó kuu tí ye tí bòò mì wó! À dú káa yúcó máa, ṛè ye ꞌdo tí kpónó kû ya gí kùṛo bà giì dù á mì ndâ ꞌduù a mbe tó pá, ");
INSERT INTO ndz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tacó ꞌduù tí nó ngéé gbíṛì tí Mbe wotí nó bàkà ndâ kpo-kpò i ta ṛè ye gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yí a mbe kû ŋò yê ṛo ndâ mbe kû te duù mítí wó ta o ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yí kû tùbà wotí mì wó ji ndâ mbe kû si tí ndú tí i ta kpéétí ndú ta bà njè gbí ndâ mbù ꞌvéṛè mì ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yí kû tùbà wotí mì wó ji ndâ kpo-kpò gba tí nó mbe kû mba tí ndú ji yí nó, ta bà tòò ndú ꞌdo pí ndâ jàlàmbà mì ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yí giì tùbà wotí mì wó ji ndâ ꞌduù ŋìnó ta go tí ndú nó, ta bà je i-zó-zò ji ndú yè yì ndú gî. Bìndi  yí giì njè gbí ndâ mbe kpo-kpò i ꞌdo kùṛo wó ta go tí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yí bàkà nambeè ji ndâ Ìzìrìyélì tí ndâ bòò mì wó go có tí nó náa yí táánò ci ta ndâ ká gù ndoo ngbé énó máa, yì kèjì gí bà bàkà nambeè ji ndâ Àbìráámò ta ndâ ꞌviì bìndi wó,» nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Màríyà bàkà go pì taꞌô mí kòtí Èlìzàbétà, bìndi  yí giì dele ndi wó gí ꞌbá. ");
INSERT INTO ndz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pì mì Èlìzàbétà mâ giì tè gî, yí giì jò ꞌviì mì wó tí ꞌviì-ꞌdakò. ");
INSERT INTO ndz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ndâ ka ꞌbá mì Èlìzàbétà ta ndâ nambe wó mâ giì ꞌdi có ŋa gbolò nambeè tí nó náa Mbíṛì bàkà ji yí nó, ndú giì kaa ya gí bà ŋò yí ta líkíꞌo. ");
INSERT INTO ndz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta sili vô-nje taꞌô bìndi bà jò Jòvánì, ndâ ꞌduù giì kili ya gí ꞌbá mì Zàkàríyà, tacó à má waa ꞌviì gî, à ꞌví gbì ṛè mí muu wó, go i gbí tàkìì mì ndú. À gbí muu ndâ ꞌduù ta o tí nò a có bà gbì ṛè bu wó tí Zàkàríyà mí muu ꞌviì. ");
INSERT INTO ndz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Káa Èlìzàbétà tí nawu ꞌviì giì biya gî, máa, ndú gbì mí muu wó a Jòvánì. ");
INSERT INTO ndz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ndâ ꞌduù tí nò bà-i-nò giì ꞌvee Èlìzàbétà máa, «Jòvánì a ṛè ꞌdi ꞌbá mì yo?» ");
INSERT INTO ndz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tacó énò, ndú bà-i-nò giì njè gítí bà ꞌvee Zàkàríyà ta bà mìyà ꞌbì ndú ji yí, máa ndâ yì ꞌví gbì mí muu ꞌviì a ṛè ꞌdi wè? ");
INSERT INTO ndz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Káa Zàkàríyà giì mìyà ꞌbì wó ji ndú máa, ndú je i ji yì wàa yì ꞌví cu ta ṛè ꞌviì ji ndú. Ndú mâ giì je i ji yí gî, Zàkàríyà giì cu ṛè ꞌviì tí nò mítí  énó máa, «Ṛè wó a Jòvánì.» Ndâ ꞌduù mâ giì ꞌdeke ṛè ꞌviì tí nò náa Zàkàríyà cu ji ndú nò, nje ndú ꞌdáá gî giì ꞌdèè gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Káa à káa póó bà cee ta bà cu ṛè ꞌviì tí nò mì Zàkàríyà, wú tà mè wó giì njaanga tí gî. Yí bà-i-nò giì ꞌbìtà bà ꞌdè có ta bà ùlù Mbíṛì ta líkíꞌo. ");
INSERT INTO ndz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nje ndâ ka ꞌbá mì Zàkàríyà ꞌdáá gî giì ꞌdèè gítí ŋa i tí nò gî. Ngú có tí nò giì ꞌvèè cee gbí òkò ndâ gú gbí Jùdéyà ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ꞌDuù ŋìnó mbe ꞌdi có tí nò gî ngé kû koṛo káa có máa, «Ŋa ꞌviì tí nò bà kpolo tí ŋa ꞌduù yè wè?» Tacó à dú káa yúcó máa, Mbíṛì je wotí ji yí gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wu mâ giì gì gí gbí mè Zàkàríyà gî, Bèṛi-mì-Mbíṛì giì je wotí bà ꞌdè-kòcò ji yí. Bìndi  yí giì ꞌbìtà bà cè cè ta bà be ṛè Mbíṛì gbí  máa, ");
INSERT INTO ndz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«À ùlù Mbe tí ndoo, tí Mbíṛì mì ndâ Ìzìrìyélì! Tacó yí gì gí bà gala ndâ ꞌduù mì wó gî. Yí gì gí bà njaanga miṛi ndú ꞌdo gbí vò i gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yí je ngáángbá ꞌduù tí mbe ꞌvala ndoo ji ndoo ꞌdo gbí mòòkò bìndi bòò mì wó Dàvídè tí gbolò gba mì ndâ Ìzìrìyélì gî. ");
INSERT INTO ndz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yí bàkà énò go cí tí nó náa yí dígísèé ci ta ndâ mbe ꞌdòkò có mì wó náa yí ṛuka ndú ꞌdo gbí òkò tí ndâ ꞌduù ji ndâ ká gù ndoo nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yí dígísèé ci ndâ mbe ꞌdòkò có mì wó ji ndâ ká gù ndoo máa, yì kèjì gí bà ꞌvala ndoo ꞌdo mì ndâ kuꞌdì tí ndoo, ta ndâ ꞌduù ŋìnó mbe kû sogo ndoo nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yí kpónó kû tù nó a bà nambeè mì wó ji ndâ ká gù ndoo. Yí kû koṛo nò a có gítí cí tí nó náa yí ci ta ndú dígísèé nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yí dígísèé be tí wó á ji bu ndoo tí Àbìráámò, máa; ");
INSERT INTO ndz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yì bà ꞌvala ndoo ꞌdo ꞌbì ndâ kuꞌdì tí ndoo, yì delè bà je wotí ji ndoo tacó bà bàkà nèté ji yì ta gúku tí ndoo wálá, ");
INSERT INTO ndz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tí ndâ cèe ꞌduù, delè tí ndâ ꞌduù ŋìnó jáá kùṛo yì, ta o ꞌdáá gî muu to tí nô. ");
INSERT INTO ndz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Káa wò tí putú káṛà tí nó mì ye nó, wò bà dù tí mbe ꞌdòkò có mì ꞌDuù tí nó mbe kû dù ngéé gbíṛì nô, tacó wò bà dù tí mbe ꞌviindi kpokèjì ù ta ndi bà gì Mbe tí ndoo. ");
INSERT INTO ndz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wò bà dù tí mbe je muu gítí ꞌválá ji ndâ ꞌduù ta bà je à-cee-gî ji ndú gítí ndâ vò i mì ndú, ");
INSERT INTO ndz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ta ṛè mì Mbíṛì mì ndoo tí mbe nambeè, tí mbe kû ŋò yê ṛo ndâ ꞌduù, náa yí kû si ta ṛi kû có tàṛì ");
INSERT INTO ndz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tacó bà tù ngbaꞌo ji ndoo tí ndâ mbe kû ꞌvala gbí ꞌdíꞌdiꞌo náa ku gò jî mí ṛo ndoo gî nó tacó wàa ndoo ꞌví tò kò ndoo tí kèjì ꞌválá ŋìnó tí ꞌdê ꞌválá nó lá.» ");
INSERT INTO ndz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ꞌViì tí nò mâ giì kpolo tè tí ꞌduù gî, yí giì co ꞌdo ꞌbá ya gí bà ꞌvala gbí kángáá nga ngoò ta kpéétí wó, yee tí o bà tùbà tí wó ji ndâ Ìzìrìyélì ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","À ta o tí nò a ngáángbá gba mì ndâ Ròmánò ta ṛè wó a Àgúsìtò, tí mbe kû zogo ndâ Jùdéyà, ká ꞌdè có máa, à ꞌdeke muu ndâ ꞌduù gbí ndâ to tí nó náa yì kû zogo nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kpédélé ŋa bà ꞌdeke muu ndâ ꞌduù énò bàkà tí ta o tí nò si Kùrínò a gbolò ꞌduù gbí to Sírìyà. ");
INSERT INTO ndz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndâ ꞌduù ꞌdáá gî giì kaa ya gí bà ṛèngbó ndú tacó bà cu ṛè ndú mí gbí yâ-ndú go có mì Àgúsìtò tí ngáángbá gba. ");
INSERT INTO ndz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tacó énò, Jùzépè giì njè nó ꞌdo gbí gbata Názàrètì á gbí to Gàlìléyà, ya gí gbí to Jùdéyà, gí bà cu ṛè wó mí gbí ꞌdóó gbata mì ndú Bétèlèmè, tí bàndò bà jò Dàvídè tí gbolò gba mì ndâ Ìzìrìyélì, tacó yí a ꞌviì kòtí Dàvídè. ");
INSERT INTO ndz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ndú gbí ta nó tí nò ta Màríyà, tí ꞌvinî tí nó náa yí ꞌvee có tí wó tacó bà kò yí gî nô. Káa ta o tí nò Màríyà ta cèe kpokù nakáyì tí wó. ");
INSERT INTO ndz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ndú mâ giì yee gbí gbata Bétèlèmè gî, gó-káyì giì tanga mítí Màríyà. ");
INSERT INTO ndz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yí bà-i-nò giì jò ꞌviì-kíṛi mì wó tí ꞌviì-ꞌdakò, yí giì paṛaka yí ta ndâ bòngo, bìndi  yí giì sii yí mí gbí káꞌi bà je i-zó-zò ji ndâ nò, tacó ndú ꞌde ndâ ꞌbá wiṛi yeke ꞌdáá ta ndâ ꞌduù gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ta bèbìlì tí nò, ndâ ꞌbí mbe gbà bee mbe kû tè ṛì a ṛègbà tí ndâ bee mì ndú á seè gbata Bétèlèmè, ");
INSERT INTO ndz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","mâ giì zekeꞌo, ndú giì ŋò basìlì mì Mbíṛì, bìndi  ngbaꞌo mì Mbíṛì, giì ngbaanga to ṛègbà tí ndú ꞌdáá gî. Gúku bà-i-nò giì zèè ndú mbi ta ŋa  wálá. ");
INSERT INTO ndz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Káa basìlì tí nò giì ꞌdè có ji ndú máa, «Yo cì gúku lá, tacó ye gì ji yo a i ta banga ngú có mbe te líkíꞌo mítí ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","À wúnó jò mbe ꞌvala yo á mí kòtí Dàvídè, gbí gbata Bétèlèmè gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yo má ya gí kà, yo bà ŋò yí ni mítí bà paṛaka yí ta ndâ bòngo, bìndi  à giì sii yí mí gbí káꞌi bà je i-zó-zò ji ndâ nò.» ");
INSERT INTO ndz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ká go bà kì ṛo bà-i-nò, ndâ mbe gbà bee tí nò mâ giì zekeꞌo, ndú giì ŋò ndâ ꞌbí basìlì me mbè kaa gì yè to gî, kû cè cè ta bà be ṛè Mbíṛì gbí  ta líkíꞌo bà jò ꞌviì tí nò, máa, ");
INSERT INTO ndz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«À ùlù Mbíṛì ngéé gbíṛì, wàa ndâ ꞌduù ŋìnó náa tàkòcò Mbíṛì kû peteke gítí ndú á muu to tí nó nó ꞌví dù nìkì maa.» ");
INSERT INTO ndz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ndâ basìlì mâ giì kaa ndi ndú ya gí tàṛì gî, ndâ mbe gbà bee tí nò giì ꞌvii có gbí òkò tí ndú máa, «Ndoo ya gí Bétèlèmè, gí bà ŋò i tí nó mbe bàkà tí náa Mbe tí ndoo ꞌdè có ji ndoo gítí  nô.» ");
INSERT INTO ndz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ndú bà-i-nò mâ giì goonó ya gí Bétèlèmè go có tí nò náa ndú ꞌdè nò, ndú giì ꞌde ndâ Jùzépè ta Màríyà kuu ṛègbà tí dó ꞌviì náa ndú sii mí gbí káꞌi bà je i-zó-zò ji ndâ nò. ");
INSERT INTO ndz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ndâ mbe gbà bee tí nò mâ giì ŋò dó ꞌviì tí nò, ndú giì ꞌvanda ndi ndâ có tí nó náa basìlì ꞌdè ji ndú gítí wó nó ꞌdáá gî ji ndâ bu wó ta nawu wó. ");
INSERT INTO ndz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nje ndâ mbe ꞌdi ndi ndâ có tí nò náa ndâ mbe gbà bee tí nò ꞌvanda nò ꞌdáá gî giì ꞌdèè gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Káa Màríyà giì kpolo tí ndâ có tí nò ká mí gbí njembí wó, bìndi  yí giì dù kû ꞌviiki gbí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ndâ mbe gbà bee tí nò mâ giì ŋò dó ꞌviì tí nò tè ta ndú gî, ndú giì dele ndi ndú gí bàndò mì ndú ta bà cè cè kû be ta ṛè Mbíṛì, tacó ndú ꞌde ndâ i ꞌdáá gî jé ká go ndi kòcò ndâ basìlì tí nó mbe ꞌdè có ji ndú nô. ");
INSERT INTO ndz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta sili vô-nje taꞌô bìndi bà jò Jézù, ndâ bu wó giì ya ta yí gí gbí gàzâ. Ndú mâ giì waa yí gî, ndú giì gbì ṛè wó tí Jézù, tí ṛè tí nó náa basìlì gbì mí muu wó á kùṛo bà tè nakáyì wó nô. ");
INSERT INTO ndz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","O bà te banga mì ndâ ꞌviì ta nawu wó mâ giì tè go có mì Mòze gî, ndâ bu wó ta nawu wó giì ya ta yí gí Jèrùzàlémè, tacó bà kaa yí ji Mbíṛì, ");
INSERT INTO ndz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","go có tí nó náa à cu mí gbí wáràgà gítí tàkìì mì ndâ Jùdéyà énó máa, «À ꞌví kaa ndâ ꞌviì-ꞌdakò ŋìnó tí ndâ ꞌviì-kíṛi nó ji Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Delè tacó bà waa mbelè ndâ kúlùkúdu sósòꞌô, má wálá, ndâ kùlè sósòꞌô go có tí nó gbí wáràgà mì Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ta o tí nò, ꞌbí ꞌdakò ta ṛè wó a Sìmìyónè, mbe sì miṛi wó ji Mbíṛì gî, náa Bèṛi-mì-Mbíṛì kuu tàkò wó, kuu ta ꞌbá Jèrùzàlémè, kû ùndi o bà ꞌvala ndâ Ìzìrìyélì. ");
INSERT INTO ndz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bèṛi-mì-Mbíṛì ci yí sàà gî, máa, yí má ŋò Bìndi-Mbíṛì ta ṛo wó lá, yí bà cì wálá. ");
INSERT INTO ndz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bèṛi-mì-Mbíṛì giì a tàmuu Sìmìyónè ya tí  gí gbí ndùgù ꞌbá-Mbíṛì á kùṛo o bà ya ta Jézù mì ndâ bu wó ta nawu wó tacó bà kaa yí ji Mbíṛì nò. Ndú mâ giì bàkà bà tàkìì mítí Jézù gî, ");
INSERT INTO ndz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sìmìyónè giì liꞌvi Jézù mì njembí wó, bìndi  yí giì ꞌdeke tí wó ta bà ùlù Mbíṛì máa, ");
INSERT INTO ndz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Nògí, si bòò mì lo ꞌví ya gí bàndò mì wó nìkì maa, Mbe tí ye. Si yí ꞌví ya nìkì maa go cí tí nó náa wò táánò ci ta yí nô. ");
INSERT INTO ndz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tacó ye kpónó ŋò mbe ꞌvala ndâ ꞌduù ta ṛo ye gî, ");
INSERT INTO ndz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ꞌduù tí nó náa wò bàkà yí tí mbe ꞌvala ndâ ꞌduù á muu to tí nó ꞌdáá gî nô, ");
INSERT INTO ndz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ꞌduù tí nó náa wò je yí tí ngbaꞌo mbe tùbà kpokèjì mì lo á ji ndâ ꞌduù ŋìnó náa ndú me ndâ Jùdéyà lá nô, ꞌduù tí nó náa wò je yí delè tí mbe tùbà wotí mì lo ji ndâ Ìzìrìyélì nô.» ");
INSERT INTO ndz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ndâ bu Jézù ta nawu wó giì si nje ndú ká tí nga gítí ŋa có tí nò náa Sìmìyónè kû ꞌdè gítí ꞌviì mì ndú nò. ");
INSERT INTO ndz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sìmìyónè mâ giì ꞌdeke tí wó ji Mbíṛì cee gî, yí giì cù ꞌdê ngo cù wó mítí ndâ Jézù ta ndâ bu wó ta nawu wó. Bìndi  yí giì ꞌdè có ji Màríyà tí nawu Jézù máa, «Mbíṛì cu ꞌbì wó á mítí ꞌviì tí nó tí mbe mìì ndâ Ìzìrìyélì me mbè. Yí delè giì cu ꞌbí wó mítí wó tí mbe ꞌvala ndâ Ìzìrìyélì me mbè. Mbíṛì cu mí gbí mbelè wó máa, ndâ ꞌduù bà bè yí gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yí bà dù tí mbe yù gbí ndâ có kóó mì ndâ ꞌduù gí sè. Sé có bà giì kaṛa ṛé lo jàngá gî.» ");
INSERT INTO ndz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ta o tí nò, ꞌbí túngúꞌdù kpo niì tí mbe ꞌdòkò có mì Mbíṛì ta ṛè wó a Ánà, tí nájú ꞌbí ꞌdakò ta ṛè wó a Fànùwélè, ta ŋa wó a Àsérè, kuu gbí ndùgù ꞌbá-Mbíṛì. Ndâ Ánà sì ꞌbá ta ꞌdakò mì wó bìndi bà kò tí ndú ká ta ndoò vô-nje só, bìndi  ku giì zi ꞌdakò tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ndoò tí Ánà gbí nawù ku ta o bà ya ta Jézù gí bà kaa yí ji Mbíṛì nò ziꞌduù-nàꞌô-nje nàꞌô. Yí jé co ꞌdo gbí ndùgù ꞌbá-Mbíṛì gí bà ꞌbí to lá, kû bàkà i-Mbíṛì ta bà kònò go. ");
INSERT INTO ndz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yí giì gì gí bàndò bà bàkà i-Mbíṛì ta gbèe o tí nò gí bà ꞌdè nìkì maa ji Mbíṛì, bìndi  yí giì ya gí mì ndâ bu Jézù ta nawu wó ta o bà ya ta yí mì ndú gí bà bàkà bà tàkìì nò. Yí giì ꞌdè nìkì ma ji Mbíṛì, bìndi  yí giì ꞌdè có gítí dó Jézù ji ndâ ꞌduù tí nó ꞌdáá gî mbe kû ùndi bà njaanga miṛi ndâ ꞌduù Jèrùzàlémè mì Mbíṛì ꞌdo gbí vò i nô. ");
INSERT INTO ndz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ndâ bu Jézù ta nawu wó mâ giì bàkà bà tàkìì gítí wó go có mì Mbíṛì cee gî, ndú giì dele ndi ndú ꞌdo Jèrùzàlémè ya a i gí gbí gbata mì ndú Názàrètì á gbí to Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jézù giì kpolo mí Názàrètì tí yú ꞌdakò ta muu ká tí wó, delè ta Mbíṛì kuu tàkò wó. ");
INSERT INTO ndz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ndâ bu Jézù ta nawu wó giì dù kû ya gí Jèrùzàlémè ta ndoò ꞌdáá gî ta o gbolò o bà mèlè ndi tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ndú giì ya gbí ndoò ŋìnò si ndoò tí Jézù muuꞌbì-nje só. ");
INSERT INTO ndz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Káa si ndú kû giì dele gí ꞌbá si bà gbolò o tí nò cee gî, Jézù giì gboo mí Jèrùzàlémè gî, káa ndâ bu wó ta nawu wó ŋò bà  lá. ");
INSERT INTO ndz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","À gbí muu ndú ŋìndi ndú máa ndâ-ꞌbî-lá, ndú kû nò ta ndâ ꞌbí nambeè gbí òkò tí ndâ ꞌduù tí nó kpokèjì mòsùù nô. Ndú giì ŋò ni énó máa yí gbí òkò tí ndâ ꞌduù wálá ngé a i si ndú sì sili gbaànjé kpokèjì gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ndú bà-i-nò giì delè ndi ndú ya gí bà pà bà tí wó cee gbí gbata Jèrùzàlémè léé gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Káa ndú giì ꞌde yí ngé a i bìndi sili taꞌô á gbí ndùgù ꞌbá-Mbíṛì, gbí òkò tí ndâ kpo-kpò mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà, kû ꞌdi ndâ có mì ndú. Yí delè kû ꞌvee ndú gítí ndâ ꞌbí có. ");
INSERT INTO ndz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bà ꞌdè có gítí ŋa bà ꞌdi gbí-o mì wó, ta ndâ ŋa có tí nó náa yí kû ꞌvìsì ji ndâ kpo-kpò ꞌduù tí nò nó, giì kpò nje ndâ mbe ꞌdi ndâ có tí nò náa yí kû ꞌdè nò gî ");
INSERT INTO ndz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ndâ bu Jézù ta nawu wó mâ giì ŋò yí, nje ndú giì ꞌdèè gî. Bìndi  nawu wó giì ꞌvee yí máa, «Wò bàkà mítí ze énó a ŋa yè, ꞌviì? Ŋò káa bà kaṛa ṛé ze ta bà pà bà tí lo gi!» ");
INSERT INTO ndz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo kû pà bà tí ye tacó yè? Yo ŋò ni lá máa, ye kû bàkà a nèté mì bu ye?» ");
INSERT INTO ndz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Káa bà ꞌvìsì có gí tàkò ꞌvé mì Jézù nò giì kpò ndâ bu wó ta nawu wó gî. ");
INSERT INTO ndz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jézù bà-i-nò giì njè nó ta ndâ bu wó ta nawu wó á bìndi bà ꞌde yí mì ndú nò ya gí Názàrètì. Yí giì kpolo mí kà tí tó ꞌviì mbe kû ꞌdi có mì ndâ bu wo ta nawu wó. Káa nawu wó giì kpolo tí ndâ có tí nò ꞌdáá gî mí gbí njembí wó. ");
INSERT INTO ndz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jézù giì uu gí yaà tí mbe wotí, ta muu ká tí wó, náa ndâ ꞌduù giì zè yí nìkì maa, Mbíṛì delè giì zè yí nìkì maa. ");
INSERT INTO ndz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ndoò tí Tìbérìyò tí ngáángbá ꞌdakò pí jàlàmbà á Rómà ta o tí nò muuꞌbì-nje vô. Pónísìyò Pìlátò ta o tí nò a gbolò ꞌduù á Jùdéyà, ṛòbú Èródè ká giì zèè Gàlìléyà, Fìlípò tí ꞌbí ꞌviì bìndi Èródè giì zèè ndâ to Ìtùríyà ta Tàràkònítìsì. ꞌBí ꞌdakò ta ṛè wó a Lìsánìyà giì zèè to tí nó tí Àbìlénè nô. ");
INSERT INTO ndz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà gbí gbèe o tí nò a ndâ Ánà ta Kàyífà. Mâ giì zekeꞌo, Mbíṛì giì je wotí bà ꞌdè-kòcò ji Jòvánì tí ꞌviì mì Zàkàríyà si yí gbí kángáá nga ngoò. ");
INSERT INTO ndz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jòvánì bà-i-nò giì dù kû nò nó cee gbí ndâ to á ta ndi yì ngo tí nó tí Jòròdánìyà nó ꞌdáá gî, kû ma có gítí bà caka tí ndâ ꞌduù, tacó wàa Mbíṛì ꞌví je ta à-cee-gî ji ndú gítí ndâ vò i mì ndú. ");
INSERT INTO ndz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A go có tí nó gbí wáràgà mì Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì énó máa, «Kòcò ꞌduù kû kò-kò gbí kángáá nga ngoò, máa, ‹Yo ꞌviindi kpokèjì mì Mbe tí ndoo, yo bàkà ndâ kpokèjì mì wó jáá. ");
INSERT INTO ndz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yo nè ndâ dùgùù to ꞌdáá gî, yo da tí ndâ nja-njà gú tí nó ta ndi tí kpokèjì mì Mbe tí ndoo nó ꞌvii ta kúṛo to. Yo bàkà ndâ bà lókó-loko to ŋìnó tí kpokèjì mì wó nó jáá. Yo ꞌviindi ndâ bà cúkpúú-cùkpùù to á ta ndi tí kpokèjì mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yo má bàkà énò gî, Mbíṛì bà ꞌvala ndâ ꞌduù ꞌdáá gî,› nô.» ");
INSERT INTO ndz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jòvánì giì ꞌdè có ji ndâ mbè ꞌduù tí nó mbe kaa ya gí mì wó tacó waa yí ꞌví caka tí ndú nó, máa, «Yo ndâ ꞌviì-kpoo! A ꞌdi ká ꞌdè có ji yo máa yo fa ngèlè ꞌdo tí kpo-tàkòcò mì Mbíṛì gì gí mì ye? ");
INSERT INTO ndz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yo bàkà ndâ i ŋìnó náa à tí  nô, tacó wàa à ꞌví ŋò tí  ni énó máa, yo ꞌvìsì muu yo á ꞌdo tí ndâ vò i mì yo gî. Yo si bà dù kû koṛo có énó máa, ‹ze a ndâ ꞌviì-gù Àbìráámò› mí to. Ye kû ꞌdè có ji yo máa, wotí bà kaa ndâ díí tí nó wàa yí ꞌví bàkà ndú tí ndâ ꞌviì-gù ji Àbìráámò kuu tí Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mbíṛì kpónó tè zí kàngó mì wó léngé-lenge gî. Yí kèjì gí bà daaka ndâ mû ŋìnó mbe ṛì cèe ndo mû lá nó ꞌdo ngé tà teè ndú gí to tacó bà doo ta wu.» ");
INSERT INTO ndz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Káa ndâ ꞌduù tí nò giì ꞌvee Jòvánì máa, «Ze kpónó ꞌví bàkà a ŋa yè?» ");
INSERT INTO ndz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Káa Jòvánì giì ꞌvìsì có ji ndú máa, «Ndâ bòngo mì ꞌduù má sósòꞌô, si yí ꞌví je ꞌbí  gbaànjé ji ꞌbí ka wó ŋìnó ta bòngo mì wó wálá nô. Wàa i-zó-zò delè má kuu mì ꞌduù, yí ꞌví je ꞌbí  ji ꞌbí ka wó ŋìnó ta go tí wó nô.» ");
INSERT INTO ndz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ndâ ꞌbí mbe kili i-mírì mbe gì gí mì Jòvánì tacó wàa yí ꞌví caka tí ndú bà-i-nò giì ꞌvee yí máa, «Káa ze ꞌví bàkà a ŋa yè, Mbe nìbà i?» ");
INSERT INTO ndz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Káa Jòvánì giì ꞌvìsì có ji ndú máa, «Yo te ꞌbí i mí muu ŋìnó náa mírì ꞌdè ji yo máa yo ꞌví go ꞌdo mì ndâ ꞌduù nó lá.» ");
INSERT INTO ndz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ndâ ꞌbí àsìkérì gbí òkò tí ndâ ꞌduù tí nò giì ꞌvee Jòvánì, máa, «Káa ze, ze ꞌví njaanga miṛi ze ta ŋa kèjì ngàyi?» Káa Jòvánì giì ꞌvìsì có ji ndú máa, «Yo kùmùkù ndâ i mì ndâ ꞌduù ta wotí lá. Yo delè ꞌví waaka có mítí ndâ ꞌduù gbí ngbàngà lá. Yo zò i ꞌdo ká gbí wuꞌo mì yo.» ");
INSERT INTO ndz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jòvánì mâ giì ŋò énó máa, ndâ ꞌduù kû giì ꞌbìtà a bà koṛo gítí yì a gbolò có énó máa yì a Bìndi-Mbíṛì, ");
INSERT INTO ndz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","yí giì ꞌdè có ji ndú ꞌdáá gî máa, «Ye kû caka tí yo ta ngo, káa ꞌbí ꞌduù ta wotí tí wó mbe ndii ye gî á kèjì, náa à kpêtí káa vòó bà dù tí mbe kû njaanga tàmà ꞌdo tí kò wó, ye bà ꞌvii tí  wálá. Yí kèjì gí bà caka tí yo ta Bèṛi-mì-Mbíṛì, delè ta wu. ");
INSERT INTO ndz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yí kpónó zèè pìdíí mì wó mí ꞌbì wó, tacó bà pì gbí cû mì wó gî. Yí bà yili cèe njì cû gî, bìndi  yí bà doo póṛó cû ta wu ŋìnó jé mbe mee lá nô.» ");
INSERT INTO ndz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jòvánì bà-i-nò giì dù kû ma Banga-Ngú-Có, ta bà je wotí ji ndâ ꞌduù ta ꞌbí ŋa có mbe si ndâ ꞌduù ꞌví ꞌvìsì muu ndú gbí ndâ ꞌbí ŋa kèjì me mbè. ");
INSERT INTO ndz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Káa Jòvánì giì ꞌdè có gítí Èródè tí nó tí gbolò ꞌduù nó, tacó bà volo muu Èródìyà tí niì mì náꞌvindí wó, ꞌdo tí wó, delè tacó ndâ ꞌbí vò i me mbè náa yí bàkà ndú. ");
INSERT INTO ndz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Èródè mâ giì ꞌdi ndâ có tí nò náa Jòvánì kû ꞌdè gítí wó nò, yí giì tò muu ndâ vò i mì wó nò ta bà te Jòvánì mí gbí zàà. ");
INSERT INTO ndz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jòvánì mâ giì caka tí ndâ ꞌduù ꞌdáá gî cee gî, yí giì caka tí Jézù delè. Káa si Jézù kû giì ꞌdeke tí wó ji Mbíṛì á bìndi bà caka tí wó mì Jòvánì nò, njekèjì tàṛì giì njaanga tí gî. ");
INSERT INTO ndz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Bìndi  Bèṛi-mì-Mbíṛì giì gì ꞌdo yaà ta cè tí wó go cè tí kùlè nô gí muu Jézù. Kòcò ꞌduù bà-i-nò giì dù kû ꞌdè có ꞌdo gbíṛì máa, «Wò a kpóló-kpolo ꞌviì mì ye. Tàkòcò ye peteke gítí lo ma.» ");
INSERT INTO ndz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jézù ꞌbìtà nèté bà nìbà i ji ndâ ꞌduù ta ndoò tí wó go ziꞌduù-gbaànjé-nje muuꞌbì. Ndâ ꞌduù gbí ndâ o tí nò ŋò Jézù ni ká tí ꞌviì mì Jùzépè tí ꞌviì mì Élì, Élì tí ꞌviì mì Màtátì, ");
INSERT INTO ndz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Màtátì tí ꞌviì mì Lévì, Lévì tí ꞌviì mì Mèlékì, Mèlékì tí ꞌviì mì Jànáyì, Jànáyì tí ꞌviì mì Jùzépè, ");
INSERT INTO ndz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jùzépè tí ꞌviì mì Màtàtíyà, Màtàtíyà tí ꞌviì mì Ámòsì, Ámòsì tí ꞌviì mì Nàwúmì, Nàwúmì tí ꞌviì mì Ésìlì, Ésìlì tí ꞌviì mì Nàgáyì, ");
INSERT INTO ndz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nàgáyì tí ꞌviì mì Máátà, Máátà tí ꞌviì mì Màtàtíyà, Màtàtíyà tí ꞌviì mì Sèmèyínì, Sèmèyínì tí ꞌviì mì Jòsékì, Jòsékì tí ꞌviì mì Jódà, ");
INSERT INTO ndz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jódà tí ꞌviì mì Jòwánànì, Jòwánànì tí ꞌviì mì Résà, Résà tí ꞌviì mì Zèrùbàbélè, Zèrùbàbélè tí ꞌviì mì Sèlìtìyélì, Sèlìtìyélì tí ꞌviì mì Nérì, ");
INSERT INTO ndz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérì tí ꞌviì mì Mèlékì, Mèlékì tí ꞌviì mì Ádì, Ádì tí ꞌviì mì Kàsámù, Kàsámù tí ꞌviì mì Èlìmàdámù, Èlìmàdámù tí ꞌviì mì Érè, Érè tí ꞌviì mì Jósùwà, ");
INSERT INTO ndz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jósùwà tí ꞌviì mì Èlìyézèrè, Èlìyézèrè tí ꞌviì mì Jòrímù, Jòrímù tí ꞌviì mì Màtátì, Màtátì tí ꞌviì mì Lévì, Lévì tí ꞌviì mì Sìmìyónè, ");
INSERT INTO ndz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sìmìyónè tí ꞌviì mì Júdàà Júdàà tí ꞌviì mì Jùzépè, Jùzépè tí ꞌviì mì Jònámù, Jònámù tí ꞌviì mì Èlìyàkímì, ");
INSERT INTO ndz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Èlìyàkímì tí ꞌviì mì Mèléyà, Mèléyà tí ꞌviì mì Ménà, Ménà tí ꞌviì Màtásà, Màtásà tí ꞌviì mì Nàsánì, Nàsánì tí ꞌviì mì Dàvídè, ");
INSERT INTO ndz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dàvídè tí ꞌviì mì Jésì, Jésì tí ꞌviì mì Òbédì, Òbédì tí ꞌviì mì Bòwázì, Bòwázì tí ꞌviì mì Sàlìmónì, Sàlìmónì tí ꞌviì mì Nàsónì, ");
INSERT INTO ndz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nàsónì tí ꞌviì mì Àmìnàdábì, Àmìnàdábì tí ꞌviì mì Ádímìnì, Ádímìnì tí ꞌviì mì Àrínì, Àrínì tí ꞌviì mì Èzìrónì, Èzìrónì tí ꞌviì mì Pèrézì, Pèrézì tí ꞌviì mì Júdàà, ");
INSERT INTO ndz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Júdàà tí ꞌviì mì Jàkóbè, Jàkóbè tí ꞌviì mì Ìzákò, Ìzákò tí ꞌviì mì Àbìráámò, Àbìráámò tí ꞌviì mì Téràà, Téràà tí ꞌviì mì Nàwórì, ");
INSERT INTO ndz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nàwórì tí ꞌviì mì Sèrúgì, Sèrúgì tí ꞌviì mì Réwù, Réwù tí ꞌviì mì Pèlégì, Pèlégì tí ꞌviì mì Èbérè, Èbérè tí ꞌviì mì Sélà, ");
INSERT INTO ndz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sélà tí ꞌviì mì Kàyìnánì, Kàyìnánì tí ꞌviì mì Àrìfàkìsádà, Àrìfàkìsádà tí ꞌviì mì Sémì, Sémì tí ꞌviì mì Nówà, Nówà tí ꞌviì mì Làmékì, ");
INSERT INTO ndz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Làmékì tí ꞌviì mì Mèsùsélàà, Mèsùsélàà tí ꞌviì mì Énòkì, Énòkì tí ꞌviì mì Jàrédì, Jàrédì tí ꞌviì mì Mààlàléélì, Mààlàléélì tí ꞌviì mì Kàyìnánì, ");
INSERT INTO ndz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kàyìnánì tí ꞌviì mì Énòsì, Énòsì tí ꞌviì mì Sésì, Sésì tí ꞌviì mì Ádàmà, Ádàmà tí ꞌviì mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jézù giì dele ndì wó ꞌdo tàbèꞌdè Jòròdánìyà á bìndi bà caka tí wó mì Jòvánì, tí ꞌduù ŋìnó náa Bèṛi-mì-Mbíṛì gèè bè mí muu wó gî. Bìndi  Bèṛi-mì-Mbíṛì giì a tàmuu wó ");
INSERT INTO ndz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ya tí  gí bà bàkà sili ziꞌduù-só mí gbí kángáá nga ngoò náa Gba-wàtà kû tala yí ta vò i. Gbí ndâ sili tí nò ziꞌduù-só náa yí bàkà mí gbí kángáá nga ngoò nò, i-zó-zò di gbí yì wó gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Gba-wàtà mâ giì ŋò máa, bà  mì Jézù cee ta go gbí ndòngbú ndâ sili tí nò náa yí bàkà ziꞌduù-só nò gî, yí giì ꞌdè có ji yí máa, «Wò má dú káa ꞌViì-mì-Mbíṛì, ꞌvìsì díí tí nó tí i-zó-zò.» ");
INSERT INTO ndz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Káa Jézù giì ꞌvìsì có ji Gba-wàtà énó máa, «À cu mí gbí wáràgà mì Mbíṛì énò máa, ‹ꞌDuù kû ꞌvala me ka ta i-zó-zò cuki lá.› » ");
INSERT INTO ndz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Gba-wàtà bà-i-nò giì te Jézù ꞌdo to ngéé gí yaà, bìndi  yí giì tùbà ndâ kpo-kpò gbata muu to tí nó ꞌdáá gî ji yí á go bà kì ṛo. ");
INSERT INTO ndz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bìndi  yí giì ꞌdè có ji yí máa, «Ye bà bàkà wò tí mbe ndâ kpo-kpò gbata tí nò náa wò kû ŋò ngba ndú nò ꞌdáá gî, tacó Mbíṛì je ndú ji ye tí ndâ i mì ye gî. À ká go có mì ye bà je ndú ji ꞌduù ŋìnó mbe nìkì tí ye. ");
INSERT INTO ndz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ye bà je ndú ꞌdáá ji wò gî náa wò má kucuku muungbó lo mí kùṛo ye wàa wò ꞌví ùlù ye gî nò.» ");
INSERT INTO ndz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Káa Jézù giì ꞌvìsì có ji Gba-wàtà máa, «À cu mí gbí wáràgà mì Mbíṛì máa, ‹Wò ꞌví ùlù káa Mbe tí lo tí Mbíṛì mì lo. Wò dele ꞌví bàkà nèté ká ji yí cuki.› » ");
INSERT INTO ndz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Gba-wàtà giì te Jézù ꞌdo gbí kángáá nga ngoò bìndi ŋìnó, ya tí  gí Jèrùzàlémè, yí giì te yí ngé déꞌvéléé mì pí ꞌbá-Mbíṛì. Bìndi  yí giì ꞌdè có ji yí máa, «Wò má dú káa ꞌViì-mì-Mbíṛì, o gí to. ");
INSERT INTO ndz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tacó à cu mí gbí wáràgà mì Mbíṛì énò máa, ‹Mbíṛì bà kaa ndâ basìlì mì wó wàa ndú ꞌví kpolo tí lo.› À giì cu ꞌbí  énò máa, ");
INSERT INTO ndz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‹Ndâ basìlì tí nò mì Mbíṛì nò bà lì ꞌbì ndú mí tà tí lo, tacó wàa díí ꞌví kpò kò lo lá.› » ");
INSERT INTO ndz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Káa Jézù giì ꞌvìsì có ji Gba-wàtà máa, «À cú mí wáràgà mì Mbíṛì énò máa, ‹Wò ꞌví tala Mbe tí lo tí Mbíṛì lá.› » ");
INSERT INTO ndz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Gba-wàtà mâ giì cee ta bà tala Jézù gî, yí giì njè nó ꞌdo tí wó ya kû ù ꞌbí tó o tacó bà tala yí kákáꞌi. ");
INSERT INTO ndz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jézù giì dele ndí wó gí Gàlìléyà ta wotí mì Bèṛi-mì-Mbíṛì. Bìndi  ṛè wó giì wu cee gbí to Gàlìléyà ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ndâ ꞌduù ꞌdáá gî kû giì ùlù bà nìbà i mì wó ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jézù giì ya gí gbí gbata Názàrètì, tí bàndò bà kpolo yí. Bìndi  yí giì ya gí bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà go ŋa i mì wó náa yí cóó-cóó kû bàkà nô. Yí mâ giì ya gí bà ṛò tíyò tacó bà ꞌdeke i, ");
INSERT INTO ndz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","àá giì te ji yí a wáràgà mì Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì. Yí bà-i-nò giì njaanga wáràgà tí bàndò tí nó náa à cu mí gbí  énó máa, ");
INSERT INTO ndz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Bèṛi-mì-Mbíṛì kuu ta ye, tacó yí cu ꞌbì wó mítí ye máa ye ma Banga-Ngú-Có ji ndâ yê. Yí tuu ye gí bà ma có bà njaanga wú á ꞌdo tí miṛi ndâ ꞌduù gbí zàà ji ndú. Yí tuu ye gí bà njaanga ṛo ndâ mbe sú ṛo. Yí tuu ye gí bá ꞌvala ndâ ꞌduù tí nó náa à kû mèèkèꞌi tí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yí tuu ye gí bà ma có ndoò bà bàkà nambeè mì Mbíṛì ji ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jézù mâ giì ꞌdeke i cee gî, yí giì paṛaka ndi wáràgà tí nò gí bàndò mì wó, bìndi  yí giì dele ndí  ji ꞌduù tí nó tí mbe kpolo tí ndâ i á bàndò bà ùlù Mbíṛì nô. Bìndi  yí giì ki tí wó to. Ndâ ꞌduù bàndò bà ùlù Mbíṛì ꞌdáá gî giì yee ṛo ndú ṛóꞌdó-ṛoꞌdoo mítí wó. ");
INSERT INTO ndz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bìndi  yí giì ꞌbìtà bà ꞌdè có ji ndú máa, «Ndâ i tí nò náa ye ꞌdeke có gítí ndú ji yo ꞌdo gbí wáràgà mì Mbíṛì nò wúnó bàkà tí go ndâ có tí nò náa ye ꞌdeke nò gî.» ");
INSERT INTO ndz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ndâ ꞌduù ꞌdáá gî giì ùlù yí, káa nje ndú ꞌdáá gî giì ꞌdèè ta bà ꞌdi ndâ ŋa banga có tí nò mbe co ꞌdo nje wó nò gî. Ndú bà-i-nò giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú máa, «À nó me ꞌviì mí Jùzépè ká nó lá?» ");
INSERT INTO ndz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jézù mâ giì ꞌdi có tí nò, yí giì ꞌvìsì có ji ndâ ꞌduù tí nò máa, «Ye ŋò ni gî máa à gbí muu yo a có bà ꞌdè lòkòꞌbò tí nó máa, ‹ꞌVala tí lo mbe yeè› nó ji ye. À delè tí yo a go bà ꞌdè có ji ye máa, ‹Bàkà ndâ i tí nó táánò náa ze ꞌdi tàwo lo ta bà bàkà ndú gbí gbata Kàpàrànáwùmù nó mí ꞌbá mì yo.› ");
INSERT INTO ndz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Káa ye kû ꞌdè có ji yo ta yúcó máa, à jé ùnje gítí có mì mbe ꞌdòkò có mì Mbíṛì lá ká gbí ꞌdóó to mì ndú. ");
INSERT INTO ndz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«Káa ye kû ꞌdè có ji yo ta yúcó máa, ndâ nawù ku táánò ꞌbá mì ndâ Ìzìrìyélì gbí o mì Èlíjà tí nó tí mbe ꞌdòkò có mì Mbíṛì nó me mbè. Káa ta o tí nó náa njekèjì tàṛì giì nè gí tàkò mù gî ta ndoò taꞌô ta pì vô-nje gbaànjé pí  gî nó, làngàwìṛí giì tè ꞌbá mì ndâ Ìzìrìyélì ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ta ndâ ŋa ŋìnò ꞌdáá gî, Mbíṛì giì tuu Èlíjà ya tí  a i gí bà konì ꞌbí nawù ku gbí ndâ to Zàrèfátì á gbí to Sìdónì, si ndâ nawù ku ꞌbá Ìzìrìyélì mí to. ");
INSERT INTO ndz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ndâ mbe cì delè táánò me mbè kuu ꞌbá Ìzìrìyélì gbí o mì Èlísà tí mbe ꞌdòkò có mì Mbíṛì. Káa Èlísà ꞌvala gbèe ꞌduù á ꞌdo gbí òkò tí ndú lá, yí giì ꞌvala káa ꞌbí mbe cì gbaànjé ta ṛè wó a Nààmánì tí tende ꞌduù mbe gì ꞌdo Sírìyà.» ");
INSERT INTO ndz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ndâ ꞌduù bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì mâ giì ꞌdi có tí nò náa Jézù ꞌdè ji ndú nò, tàkòcò ndú giì kpolo ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ndú giì njè gítí wó, bìndi  ndú giì ja yí gí sè ꞌdo bàndò bà ùlù Mbíṛì, ndú giì ꞌdò ta yí gí pí gú tí nó náa à bì gbata mì ndú ta yendi  nô. À gbí muu ndú ta o tí nò a có bà ꞌva yí gí tàgbà gú ꞌdo yaà kà. ");
INSERT INTO ndz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Káa yí giì ba to, co gbí òkò tí ndâ mbè ꞌduù tí nò, kû ya ta nó mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jézù giì njè nó ꞌdo Názàrètì ya gí gbí gbata Kàpàrànáwùmù á gbí to Gàlìléyà. Bìndi  yí giì nìbà i ji ndâ ꞌduù kà ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nje ndâ ꞌduù giì ꞌdèè gítí wó gî, tacó yí ꞌdè có go i mì gba. ");
INSERT INTO ndz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Káa ta o tí nò ꞌbí ꞌdakò ta i-gbí-muu wò kuu gbí òkò tí ndâ ꞌduù tí nò mbe kili mí bàndò bà ùlù Mbíṛì nò. Mâ giì zekeꞌo, i tí nò giì tanga mítí ꞌdakò tí nò, bìndi  yí giì tò kû ta kòcò wó gí yaà máa, ");
INSERT INTO ndz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Si ze mí to! Àá mì lo ta ze a yè, ndí lo Jézù tí nó mbe gì ꞌdo Názàrètì nó? Wò gì tacó bà bù ŋa ze? Ye ŋò wò ni tí ꞌduù tí nó náa à kaa wò ji Mbíṛì gî nó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Káa Jézù giì do mítí i tí nò máa, «ꞌDù ngbìì! Co ꞌdo gbí muu wó gî!» I tí nó bà-i-nò gî ꞌva ꞌdakò tí nò mí to mí kùṛo ndâ ꞌduù, bìndi  yí giì co ꞌdo gbí muu wó ta bà bàkà vò i ta yí lá. ");
INSERT INTO ndz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nje ndâ mbe ŋò ŋa i tí nò ꞌdáá gî giì ꞌdèè gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú máa, «Ŋìnò a ŋa có yè ká nò? Yí kû ꞌdè có ji ndâ vò i-gbí-muu ndâ ꞌduù ta wotí go i mì gba káa ndú kû ꞌdi có mì wó!» ");
INSERT INTO ndz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ꞌDo bà-i-nò, tàwo Jézù giì wu cee gbí wúngbó to tí nò léé gî. ");
INSERT INTO ndz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jézù giì co ꞌdo bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì ya gí ꞌbá mì Sìmónè tí ꞌbí mbe tala có mì wó gbaànjé. Yí mâ giì yee kà, yí giì ꞌde na gê Sìmónè tí sì ta côꞌo gbí dìì wò ngé ndii gî. Ndâ ꞌduù mâ giì ꞌdè có  ji Jézù, ");
INSERT INTO ndz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jézù giì njè nó ya gí bà ṛò tíyò seè tí niì tí nò, bìndi  yí giì ꞌdè có ji côꞌo tí nò máa yí dò ꞌdo gbí dìì niì tí nò gî. Niì tí nò ngé giì a cónjóṛónjó gí yaà kû bàkà i-zó-zò ji ndú. ");
INSERT INTO ndz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ṛi mâ giì ta gî, ndâ ꞌduù ŋìnó ta ndâ nambe ndú ta ndâ tende ŋa nòꞌo tí ndú nó giì tuṛu ndú ꞌdáá gî ya tí  ji Jézù. Yí giì tee ꞌbì wó mítí ndú, bìndi  ndú ꞌdáá gî giì ꞌvala gî. ");
INSERT INTO ndz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ndâ i delè giì co ꞌdo gbí muu ndâ ꞌduù ŋìnó ta i gbí ndú nó me mbè, kû tò kû máa, «Wò á ꞌViì-mì-Mbíṛì!» Káa Jézù giì do mítí ndâ i tí nò máa ndú dù ngbìì, tacó ndú ŋò yì ni tí Bìndi-Mbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Yé má bà giì bàkà bà ngbaanga to, Jézù giì co ꞌdo gbí òkò tí ndâ ꞌduù gí ndiì ta kpéétí wó. Ndâ ꞌduù giì pà bà tí wó, ndú mâ giì ꞌde yí gî, ndú giì bàkà có bà tii yí, máa yí njè nó ꞌdo tí ndâ yì lá. ");
INSERT INTO ndz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Káa yí giì biya gî. Bìndi  yí giì ꞌde có ji ndú máa, «Kózò tí ye bà ya gí bà ma Banga-Ngú-Có gítí ngú ŋa kèjì bà bàkà nambeè mì Mbíṛì ta ndâ ꞌduù ji ndâ ꞌduù gbí ndâ ꞌbí gbata delè. Tacó ŋìnò a nèté tí nó náa Mbíṛì tuu ye gí bà bàkà nó ká nò.» ");
INSERT INTO ndz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bìndi  yí giì dù kû nò ta bà ma Banga-Ngú-Có ji ndâ ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bá ùlù Mbíṛì cee gbí ndâ to ꞌbá mì ndâ Jùdéyà ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ta ꞌbí o gbaànjé si Jézù kû ṛò tíyò a tì kàpá Jènèsàrétì, ndâ ꞌduù me mbè kû giì tòò tí ndú tacó bà ya gí bà ꞌdi có mì Mbíṛì ꞌdo mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jézù mâ giì zekeꞌo, yí giì ŋò ndâ gbâ sósòꞌô náa ndâ mbe gò ngo ṛò ndú mí gbí káṛà-káṛà ngo, bìndi  ndú giì oloko ꞌdo gbí ndú gí tà ngo, kû caka ndâ mbu mì ndú. ");
INSERT INTO ndz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jézù bà-i-nò giì o mí gbí ꞌbí gbâ gbaànjé, tí ŋìndi Sìmónè, bìndi  yí giì ꞌdè có ji Sìmónè máa yí yèè yì ta gbâ gàà gí ṛo ngo. Sìmónè mâ giì bàkà énò gî, Jézù giì ki tí wó á gbí gbâ ṛo ngo kû nìbà i ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jézù mâ giì nìbà i ji ndâ ꞌduù cee gî, yí giì ꞌdè có ji Sìmónè máa yí yèè ta gbâ gí bà wúlú ngo wàa yí ꞌví ꞌva mbu, wàa yí bà zèè sè gî. ");
INSERT INTO ndz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Káa Sìmónè giì ꞌvìsì có ji yí máa, «Ze ꞌva mbu ꞌdo tí kùbòó too ta yé tí nó gî, káa ze zèè gbèe i lá, kpo ꞌduù mì ye. Káa wò má ꞌdè énò, ye bà bàkà go có mì lo nò gî.» ");
INSERT INTO ndz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ndâ Sìmónè mâ giì ꞌva mbu go có tí nò náa Jézù ꞌdè ji yí nò, ndú giì woo sè tí ŋa ŋìnó náa sè bà yaka mbu mì ndú giì dù ká njíꞌdí. ");
INSERT INTO ndz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ndú bà-i-nò giì mìyà ꞌbì ndú ji ndâ ꞌbí ka ndú mbe gò ngo máa ndú gì ta gbâ mì ndú ji ndâ yì. Ndâ ka ndú nò mâ giì ya ta ꞌbí gbâ ji ndú gî, ndú giì woo sè yeke ndâ gbâ tí nò sósòꞌô nò ta sè tí ŋa ŋìnò náa sè bà ta ngo mì ndú giì dù ká njíꞌdí. ");
INSERT INTO ndz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sìmónè mâ giì ŋò ŋa i tí nò mbe bàkà tí nò, yí giì kucuku muungbó wó mí kùṛo Jézù, bìndi  yí giì ꞌdeke tí wó ji yí máa, «Ya ꞌdo tí ye gî, Mbe tí ye! Tacó vò i mì ye me gbolò ngé ndii gî.» ");
INSERT INTO ndz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sìmónè ꞌdè có tí nò ji Jézù tacó nje ndú ta ndâ ꞌbí ka wó mbe gò ngo ꞌdáá gî ta o tí nò ꞌdèè gítí ŋa seṛè sè tí nò náa ndú zèè nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ndâ Jákòmò ta náꞌvindí wó Jòvánì, tí ndâ ꞌviì mì ꞌbí ꞌdakò ta ṛè wó a Zèbìdéyò, tí ndâ ka Sìmónè mbe gò ngo delè sósòꞌô, giì si nje ndú ká tí nga. Káa Jézù giì ꞌdè có ji Sìmónè máa, «Cì gúku lá, tacó wò bà giì zèè ꞌdo tí kpónó kû ya gí kùṛo go ndâ sè tí nò a ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ndú bà-i-nò giì ya ta ndâ gbâ mì ndú gí tì ngo, ndú giì jee ndâ i mì ndú ꞌdáá gî ꞌbùṛùkù mí to, bìndi  ndú giì ya kû nò á tàkò Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ta ꞌbí o gbaànjé si Jézù kuu gbí ꞌbí gbata, yí giì ŋò ꞌbí ꞌdakò náa cì waaka yí volo gî. Mbe cì tí nò mâ giì ŋò Jézù, yí giì ꞌbu gbíṛo wó mí to mí kùṛo wó. Bìndi  yí giì ꞌdeke tí wó ji yí máa, «Go bà ngbaṛanga kútí ye má kuu tí lo, wò bà bàkà gî, kpo ꞌduù!» ");
INSERT INTO ndz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jézù mâ giì ꞌdi có tí nò náa mbe cì tí nò ꞌdè nò, yí giì tee ꞌbì wó mítí mbe cì tí nò, ta bà ꞌdè có ji yí máa, «Ye bà bàkà gî! Si kútí lo ꞌví dù ngbáṛángàꞌi.» A káa póó bà ꞌdè có tí nò mì Jézù, kútí mbe cì tí nò giì gì ngbáṛángàꞌi gî. ");
INSERT INTO ndz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kútí ꞌdakò tí nò mâ giì ṛo bìndi cì gî, Jézù giì ꞌdè có ji yí máa, «Si ꞌbí ꞌduù gbaànjé ꞌví ŋò wó lá. Ya gí bà tùbà tí lo ji bu-Mbíṛì, yí má ꞌdè có énó máa, cì cee ꞌdo tí lo gî má kózò gî, wò ꞌví ya gí bà waa mbelè go có mì Mòze, tacó bà tùbà  ji ndâ ꞌduù máa, wò gì tí cèe ꞌduù gî.» ");
INSERT INTO ndz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Káa ṛè Jézù giì wu to ya me ꞌdú ndii ŋìnó sàà kùṛo nó gî. Tacó énò, ndâ ꞌduù me mbè giì kaa ya gí mì wó. Ndâ ꞌbí ꞌduù ya tacó bà ꞌdi ndâ có mì wó, bìndi  ndâ ꞌbí  tacó wàa yí ꞌví ꞌvala ndâ yì ꞌdo gbí nòꞌo. ");
INSERT INTO ndz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Káa yí má dù gî yí kû co ꞌdo gbí òkò tí ndâ ꞌduù ya gítí bàndò ŋìnó ta ndâ ꞌduù tí  wálá nó ta kpéétí wó tacó bà ꞌdeke tí wó ji Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ta ꞌbí o gbaànjé si Jézù kû nìbà có mì Mbíṛì ji ndâ ꞌduù, ndâ ꞌbí mbe kpolo tí tàkìì, ta ndâ ꞌbí mbe nìbà i mì ndâ Jùdéyà, mbe gì ꞌdo Jèrùzàlémè, delè ꞌdo ta gbí ndâ gbata gbí ndâ to Gàlìléyà ta Jùdéyà ꞌdáá gî, ta o tí nò kuu gbí òkò tí ndâ ꞌduù tí nò náa yí kû nìbà i ji ndú nò. Yí delè kû ꞌvala ndâ mbe nòꞌo ta wotí mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mâ giì zekeꞌo, ndâ ꞌbí ꞌdakò giì làngà ꞌbí ꞌdakò mbe gbeleꞌve gî gì tí  ji Jézù. Ndú giì jè ta bà ṛì ta yí gí tàꞌi tàkò Jézù, ");
INSERT INTO ndz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","káa à giì kpò ndú ngbàà gî, tacó ndâ ꞌduù nènèkè mí njekèjì go ndâ njìlí tí nje gà. Tacó énò, ndú giì ꞌdò ta yí gí muu ꞌbá, ndú giì di muu ꞌbá gbúú-gbuu ꞌvii ta bàndò bà ki tí Jézù, bìndi  ndú gí yuu yí ta mbà tí nó náa ndú te ta yí nó gí to ji yí gbí òkò tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jézù mâ giì ŋò ŋa bà tee njembí ndâ ꞌdakò tí nò á mítí wó, yí giì ꞌdè có ji ꞌdakò tí nó mbe gbeleꞌve gî nó máa, «À si có gítí ndâ vò i mì lo mí to gî, kómbe ye.» ");
INSERT INTO ndz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ndâ mbe kpolo tí tàkìì, ta ndâ mbe nìbà i mì ndâ Jùdéyà, mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, ndú giì ꞌbìtà bà koṛo có gbí njembí ndú máa, «ꞌDakò tí nó mbe kû ꞌdè zu có gí bà tí Mbíṛì nó a ꞌdi? Wotí bà je à-cee-gî gítí ndâ vò i mì ndâ ꞌduù á bìndi Mbíṛì a i tí ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Káa Jézù giì ꞌdi gbí ŋa bà koṛo có mì ndú nò gî. Tacó énò, yí giì ꞌvee ndú máa, «Yo kû koṛo ŋa có tí nò á tacó yè? ");
INSERT INTO ndz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","À kpolo a bà ꞌdè có máa, ‹À si có gítí ndâ vò i mì lo mí to gî,› wèè, à kpolo a bà ꞌdè có máa, ‹A gí yaà, wàa wò ꞌví te kpâ-sili mì lo, wàa wò ꞌví nò nó?› ");
INSERT INTO ndz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","À má énò, ye kpónó bà tùbà  ji yo énó máa, à tí ꞌViì-mì-ꞌDakò a wotí tacó bà je à-cee-gî gítí ndâ vò i.» Yí bà-i-nò giì ꞌdè có ji ꞌdakò tí nó mbe gbeleꞌve gî nó, máa, «A gí yaà, wò ꞌví te kpâ-sili mì lo, wàa wò ꞌví njè nó ya gí ꞌbá go có tí nó gbí nje ye nô.» ");
INSERT INTO ndz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ꞌDakò tí nò ngé giì a gí yaà cónjóṛónjóó mí kùṛo ndâ ꞌduù, yí giì te mbà tí nó náa à làngà ta yí gì tí  ji Jézù nó, bìndi  yí giì ꞌbì nó kû ya gí ꞌbá ta bà ùlù Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nje ndâ ꞌduù ꞌdáá gî giì ꞌdèè gî, bìndi  ndú giì ꞌbìtà bà ùlù Mbíṛì ta gúku, máa, «Ze wúnó ŋò i-seṛè gî!» ");
INSERT INTO ndz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jézù mâ giì njè nó ꞌdo bàndò bà ꞌvala ꞌdakò tí nò mbe gbeleꞌve gî nò, yí giì ŋò ꞌbí ꞌdakò, tí mbe kili i-mírì, ta ṛe wó a Lévì, kû ki tí wó to á tàgbà ꞌbá bà kili i-mírì. Jézù bà-i-nò giì tèꞌé tí Lévì, máa, «Gì gí bà dù tí ꞌduù mì ye.» ");
INSERT INTO ndz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lévì bà-i-nò giì jee ndâ i ꞌdáá gî mí to, bìndi  yí giì ya gí bà dù tí ꞌduù mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bìndi  Lévì giì te wiṛi mítí Jézù. Ndú ta o tí nò giì kili ta ndâ ꞌbí ka wó mbe kili i-mírì, ta ndâ ꞌbí ꞌduù me mbè, kû zò i-wiṛi tí nò náa yí bàkà ji Jézù nò. ");
INSERT INTO ndz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà, ta ndâ ꞌbí kpo-kpò mbe ꞌdi gbí-o mì ndú mâ giì ŋò ndú, ndú giì ꞌdè kòlòwò ji ndâ mbe tala có mì Jézù, máa, «Yo kû zò i ta ndâ mbe kili i-mírì, giì je ndâ mbe bàkà vò i, tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Káa Jézù mâ giì ꞌdi có tí nò, yí giì ꞌvìsì có ji ndú máa, «A ndâ ꞌduù ŋìnó ta séꞌi tí ndú nó ká kû pà mbe yeè. Nèté mì ndâ ꞌduù ŋìnó ta séꞌi tí ndú wálá nó ta mbe yeè wálá. ");
INSERT INTO ndz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ye gì me tacó bà tèꞌé tí ndâ tó ꞌduù lá. Ye gì a i tacó tí ndâ mbe bàkà vò i, tacó wàa ndú ꞌví ꞌvìsì muu ndú ꞌdo tí ndâ vò i mì ndú gî.» ");
INSERT INTO ndz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ndâ ꞌbí ꞌduù bà-i-nò giì ꞌdè có ji Jézù, máa, «Ndâ mbe tala có mì Jòvánì tí mbe caka tí ndâ ꞌduù ta ndâ mbe tala có mì ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà ta o ꞌdáá gî kû kònò go, ta bà ꞌdeke tí ndú ji Mbíṛì, káa ndâ mbe tala có mì lo kû zò i, ndú delè kû njù ngo.» ");
INSERT INTO ndz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Káa Jézù giì ꞌvee ndú, máa, «Yo kû koṛo có máa ndâ wiṛi bàndò bà ko niì kû kònò go ta o tí nó náa nambe ndú tí nó mbe kû kò niì nó kuu ta ndú? ");
INSERT INTO ndz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Káa ṛi bà je nambe ndú mbe kû kò niì nó ꞌdo tí ndú ká kèjì; wélégí, ŋìnò bà giì dù a ṛi bà ꞌbìtà bà kònò go mì ndú.» ");
INSERT INTO ndz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jézù giì lòkòꞌbò ꞌbí có ji ndâ ꞌduù tí nò kákáꞌi máa, «ꞌBí ꞌduù jé mbe yaka gbí ngú bòngo mì wó tacó bà cu ta ṛo kà gbí ká zì bòngo wálá. Yí má bàkà énò, yí bà yaka gbí ngú bòngo mì wó gî, káa ndâ ngú bòngo ta ká ŋìnó bà te banga ꞌvii wálá. ");
INSERT INTO ndz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ꞌBí ꞌduù delè jé mbe fuu pe ngú cû mí gbí ká káṛà ŋìnò náa gbí  wuuku gî nó wálá. Tacó yí má bàkà énò, pe ngú cû bà ba ta káṛà gî. Bìndi  yí bà bè gbí ndâ pe ta káṛà só gî. ");
INSERT INTO ndz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","À kû fuu pe ngú cû ta o ꞌdáá gî ká mí gbí kpo káṛà. ");
INSERT INTO ndz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ꞌBí ꞌduù ta go bà njù lí pe tí wó gí tàkò gó pe nò wálá, tacó a gó pe ká nìkì có tí lí pe.» ");
INSERT INTO ndz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ta ꞌbí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gbaànjé, si Jézù ta ndâ mbe tala có mì wó kû ndii ta nó ta ndi gbí ndâ njí, ndâ mbe tala có mì wó giì dù kû nò ta bà kpaṛaka muu cû kû toṛo gí nje ndú tí ꞌveè. ");
INSERT INTO ndz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ŋò ndú tí , ndú giì ꞌvee ndú máa, «Yo kû bàkà i ŋìnó náa à me yí  lá nó ta ṛi bà wotí gbí tàkìì mì ndoo tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Káa Jézù giì ꞌvìsì có ji ndú á muu ndâ mbe tala có mì wó máa, «Yo jé ꞌdi có tí nó gbí wáràgà mì Mbíṛì gítí ŋa i tí nó náa Dàvídè tí gbolò gba bàkà dígísèé si ndú ta ndâ ꞌduù mì wó ta go tí ndú nó lá? ");
INSERT INTO ndz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Có tí nó máa, yí giì ṛì gí tàꞌi ꞌbá-Mbíṛì, yí giì te i-zó-zò tí nó náa à ci ji Mbíṛì nó, yí mâ giì zò gî, yí gì te sè  ji ndâ ꞌduù mì wó, ndú delè giì zò gî. Káa à má gbí tàkìì mì ndoo tí ndâ Jùdéyà, ndâ cèe ꞌduù zò i-zó-zò tí nó náa à ci ji Mbíṛì nó lá. À káa ndâ bu-Mbíṛì ká kû zò .» ");
INSERT INTO ndz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Káa Jézù giì yee nje có mì wó ji ndú máa, «ꞌViì-mì-ꞌDakò a mbe tí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta ꞌbí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà á bìndi ŋìnò, Jézù giì ya gí bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì. Bìndi  yí giì ṛì gí tàꞌi kû nìbà i ji ndâ ꞌduù si ꞌbí ꞌdakò ta ꞌbí wó ŋìnó gbí kùꞌbì nó pizoo gî kû gbí òkò tí ndâ ꞌduù kà. ");
INSERT INTO ndz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà, ta ndâ mbe nìbà tàkìì mì ndú giì dù jé kû zeke Jézù, máa yí má ꞌvala ꞌdakò tí nò ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gî, wàa ndâ yì ꞌví ꞌde ndeṛè bà kpì ngbàngà tí wó. ");
INSERT INTO ndz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Káa Jézù giì ꞌdi gbí ŋa bà koṛo có mì ndú nò gî. Tacó énò, yí giì ꞌdè có ji ꞌdakò tí nó ta ꞌbì wó pizoo gî nó máa, «A gí yaà! Co ya gí bà ṛò tíyò á kùṛo ndâ ꞌduù.» ꞌDakò tí nò mâ giì co gí kùṛo ndâ ꞌduù go có mì Jézù nò gî, ");
INSERT INTO ndz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jézù giì ꞌvee ndú máa, «Tàkìì mì ndoo ùnje ji ndoo a i gítí bà bàkà i ngàyi ꞌdo gbí òkò tí ndâ bà bàkà tó i ta bà bàkà vò i ta ṛi bà wotí? Káa à má ꞌdo gbí òkò tí ndâ bà ꞌvala ku ta ba zi ku, à nìkì a ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yí bà-i-nò giì zekeꞌo jèlè to, bìndi  yí giì ꞌdè có ji ꞌdakò tí nò ta ꞌbì wó pizoo gî nò máa, «Yaꞌva gbí ꞌbì lo.» ꞌDakò tí nò mâ giì yaꞌva gbí ꞌbì wò, ꞌbì wó giì gì nìkì maa gî. ");
INSERT INTO ndz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sè bà ba ndâ kpo ꞌduù mì ndâ Jùdéyà giì dù ká njíꞌdí ta sé bà ŋò ŋa i tí nò, bìndi  ndú giì toko có tacó bà pà kèjì gítí ŋa i ŋìnó náa ndâ yì ꞌví bàkà ta Jézù nô. ");
INSERT INTO ndz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ta ꞌbí ṛi gbaànjé gbí òkò ndâ sili tí no, Jézù giì co ya gí pí gú tacó bà ꞌdeke tí wó ji Mbíṛì. Yí giì dù pí gú kà kû ꞌdeke tí wó ji Mbíṛì ta bèbìlì tí nò too yé gî. ");
INSERT INTO ndz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yé mâ giì too gî, yí giì kili ndâ mbe tala có mì wó, bìndi  yí giì ṛuka ndâ ꞌduù muuꞌbì-nje só ꞌdo gbí òkò tí ndú, bìndi  yí giì kpì ṛè mí muu ndú máa ndú a ndâ tú mì yì. ");
INSERT INTO ndz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ŋìnó a ṛè ndâ ꞌduù tí nó náa Jézù ṛuka ndú tí ndâ tú mì wó nó ká nô: ndâ Sìmónè tí nó náa yí kpì Pìyétòrò mítí wó nó, ta náꞌvindí wó Àndèréyà, giì je Jákòmò, giì je Jòvánì, giì je Fìlípò, giì je Bàràtòlòméyò, ");
INSERT INTO ndz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","giì je Màtéyò, giì je Tòmázò, giì je Jákòmò tí nó tí ꞌviì mì Àlìféyò, giì je Sìmónè tí nó ta ꞌbí ṛè wó a Tó-ꞌviì-ꞌbá nó, ");
INSERT INTO ndz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","giì je Júdà tí nó tí ꞌviì mì Jákòmò nó, giì je Júdà Ìsìkàrìyótè tí nó mbe giì cu gòmbò tí wó nô. ");
INSERT INTO ndz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jézù mâ giì yaaka ta ndâ ꞌduù tí nó muuꞌbì-nje só náa yí bàkà ndú tí ndâ tú mì wó nó ꞌdo pí gú gí tàbù to gî, ndú giì ꞌde ndâ mbe tala có mì wó, ta ndâ ꞌduù me mbè mbe kaa kû ya gí tàkò ndú kili kû ùndi ndú pí ꞌbí kpákáꞌvà to. Ndâ ꞌduù ta o tí nò gì ꞌdo gbí ndâ to Jùdéyà ꞌdáá gî. Ndâ mbe giì ꞌdo Jèrùzàlémè, ta ndâ mbe gì ꞌdo yì ngo gbí ndâ to Tírò ta Sìdónì. ");
INSERT INTO ndz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ndâ ꞌbí ꞌduù gbí òkò tí ndú kaa ya tacó bà ꞌdi ndâ có mì Jézù, káa ndâ ꞌduù ŋìnó ta nòꞌo tí ndú nó, kaa ya tacó wàa yí ꞌví ꞌvala ndâ yì. Ndâ ꞌduù ŋìnó ta ndâ i-gbí-muu ndú nó ya tacó wàa yí ꞌví mòkò ndâ i tí nó ꞌdo gbí muu ndâ yì gî. ");
INSERT INTO ndz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndâ mbè ꞌduù tí nò ꞌdáá gî kû kììkì to tacó bà tee ꞌbì ndú mítí wó, tacó wotí bà ꞌvala ndâ ꞌduù tí nó mbe kû co ꞌdo gbí dìì wó nó kû ꞌvala ndú. ");
INSERT INTO ndz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jézù gì zekeꞌo tí ndâ mbe tala có mì wó ngbóó, bìndi  yí giì ꞌdè có ji ndú máa, «Yo tí ndâ mbe yê, a ndâ mbe tó pá, tacó ꞌbá mì Mbíṛì tí gba a i mì yo. ");
INSERT INTO ndz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","«Yo tí ndâ mbe kû kònò go, a ndâ mbe tó pá; tacó yì yo bà yè gî. «Yo tí ndâ mbe kû wa gbí, a ndâ mbe tó pá; tacó yo kèjì gí bà ŋo ꞌdì. ");
INSERT INTO ndz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«À tí yo a tó pá ta o tí nó náa ndâ ꞌduù má kû sogo yo, ndú má kû mò yo ꞌdo tí ndú gí ndiì, ta bà ꞌdè ndâ có ŋónókó gítí yo, ta bà volo ṛè yo, á muu ꞌViì-mì-ꞌDakò. ");
INSERT INTO ndz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yo ꞌví dù ṛu ta líkíꞌo ta o tí nó náa ndú má kû bàkà ndâ i tí nò mítí yo nò, tacó gbolò mboo tàkò ndâ i tí nò kû ù ndi yo gbíṛì, tacó ndâ ká gù ndú dígísèé kû mèèkèꞌi tí ndâ mbe ꞌdòkò có mì Mbíṛì ká énò. ");
INSERT INTO ndz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Káa yo tí ndâ mbe kû tee njembí yo kpónó ká mítí ndâ kpo-kpò i mì yo á muu to tí nó bà ŋò mítí yo, tacó yo ꞌde bà tó i ŋìndi yo cee gî. ");
INSERT INTO ndz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","«Yo tí ndâ mbe kû da nó gbí i-zó-zò kpónó bà ŋò mítí yo, tacó yo kèjì gí bà zò go. «Yo tí ndâ mbe kû ŋo ꞌdì ta yéŋì kpónó bà ŋò mítí yo, tacó yo bà giì tùgàzù ta ngo-ṛo tà ṛo yo. ");
INSERT INTO ndz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«Yo tí ndâ ꞌduù tí nó náa ndâ ꞌduù ꞌdáá gî kû là tà ṛo yo kpónó nó bà ŋò mítí yo, tacó ŋìnó a gbèe ŋa i tí nó dígísèé náa ndâ ká gù yo kû me ta ndâ sú mbe ꞌdòkò có mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Káa ye kû ꞌdè có ji yo tí ndâ mbe kû ꞌdi có mì ye kpónó nó máa, yo ꞌví zè ndâ kuꞌdì tí yo nìkì maa, yo ꞌví bàkà tó i ji ndâ mbe kû sogo yo. ");
INSERT INTO ndz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yo ꞌví kùyà ꞌdê ngo cù mítí ndâ mbe kû see yo. Wàa yo delè ꞌví ꞌdeke tí yo ji Mbíṛì tacó tí ndâ mbe kû mèèkèꞌi tí yo. ");
INSERT INTO ndz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","«ꞌBí ꞌduù má gbì gbí tù lo gbaànjé, wò ꞌví ꞌvìsì kèꞌbí  ji yí wàa yí ꞌví gbì gí tàkò ŋìnò náa yí gbì nò kpêkù. ꞌDuù má ja wòòkò bòngo mì lo ꞌdo tí lo gî, wò ꞌví ja ndò ŋìnò gbímbí lo nó ji yí gí tàkò . ");
INSERT INTO ndz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ꞌDuù má yù i ꞌdo tí lo, wò ꞌví zì ꞌdo tí wó lá. ꞌDuù má aaka i ꞌdo ꞌbì lo, wò ꞌví je ndi i tí nò ꞌdo mì wó kákáꞌi lá. ");
INSERT INTO ndz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wò ꞌví bàkà ta ndâ ꞌduù káa ŋa i tí nó ta go  tí lo máa ndú ꞌví bàkà ta wò nô. ");
INSERT INTO ndz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Yo má zè tí tó jé káa ndâ ꞌduù tí nó mbe zè yo tí tó nó, yo bà ꞌde gbí  a yè? Tacó à kpêtí káa ndâ ꞌduù tí nó mbe ŋò dúú kpokèjì bà bàkà nambeè ta Mbíṛì ni lá nó, ndú kû bàkà nambeè ji ndâ mbe bàkà nambeè á ji ndú. ");
INSERT INTO ndz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yo má bàkà tó i ká ji ndâ mbe bàkà tó i ji yo, ndeṛè bà bàkà tó i mì Mbíṛì ji yo ꞌví dù a yè? À kpêtí káa ndâ mbe ŋò dúú kpokèjì bà bàkà nambeè ta Mbíṛì ni lá nó, ndú kû bàkà tó i gbí òkò tí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yo má wùù i ká ta ndâ ꞌduù tí nó náa yo kû koṛo có máa ndú bà dele ndí  ji yo gî nó, Mbíṛì ꞌví bàkà nambeè ji yo gbí kà có yè? Ŋìnò me gbèe ŋa i tí nó náa ndâ ꞌduù tí nó mbe ŋò dúú kpokèjì bà bàkà nambeè ta Mbíṛì ni lá nó kû bàkà nó lá? ");
INSERT INTO ndz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yo zè ndâ kuꞌdì tí yo nìkì maa, yo ꞌví bàkà tó i ji ndú. Yo ꞌví bàkà tó i ji ꞌduù ta bà koṛo có máa, a má taàbé yí ꞌví tù ꞌbì wó ji yo nò lá. Yo má bàkà go ndâ có mì ye nò gî, Mbíṛì bà bàkà tó i ji yo me gbolò, yo delè bà dù tí ndâ ꞌdóó ꞌviì mì Mbíṛì á ngéé gbíṛì, tacó yí kû bàkà nambeè ji ndâ ꞌduù ŋìnó mbe ŋò nambeè ni lá nó, ta ndâ vò ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yo ŋò yê ṛo ndâ ꞌduù, tacó Bu yo tí Mbíṛì a mbe ŋò yê ṛo ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Yo ꞌviiki ndâ ꞌduù lá, tacó wàa Mbíṛì ꞌví ꞌviiki ta yo lá. Yo o gítí bà waa có mítí ndâ ꞌduù lá, tacó wàa Mbíṛì ꞌví waa ta có mítí yo lá. Yo si có gítí ndâ mbe bàkà vò i ji yo mí to, tacó wàa Mbíṛì ꞌví je ta à-cee-gî gítí ndâ vò i ŋìndi yo. ");
INSERT INTO ndz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yo je i ji ndâ ꞌduù, yo má je i ji ndâ ꞌduù, Mbíṛì bà bàkà a cénjênjè mí tì káꞌi bà je ta i ji yo, yí giì sene , ngo ṛo  máa yee to gî, yí bà giì je ji yo. Tacó Mbíṛì bà ꞌvii i ji wò ká ta gbèe káꞌi tí nó náa wò ꞌvii ta i ji ꞌbí ka lo, nô.» ");
INSERT INTO ndz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jézù giì ꞌvee ndú gbí lòkóꞌbò máa, «Mbe sú ṛo má ja ꞌbí ka wó mbe sú ṛo, ndú bà ꞌva tí ndú ta yí gbí gùù wálá? ");
INSERT INTO ndz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mbe tala i ŋò i ndii mbe kû nìbà i ji yí lá. Káa mbe nìbà i ji ꞌduù má yù yí ngbóó gî, ꞌbè gbí ŋa i mì ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Njì ngoò má kuu ta ṛo lo, wò bà me ta bà ŋò léé njú to a tà ṛo ꞌbí nambe lo ée? ");
INSERT INTO ndz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wò bà ꞌdè nje lo tacó bà ꞌdè có ji nambe lo máa yí yèè dê gí mì lo wàa wò ꞌví òlò njú to ꞌdo tà ṛo wó, ꞌdo kòtí ꞌdi, ta njì ngoò á tà ṛo lo, ndi lo bô mbe là ngo mè tí ka wó si ŋìndi wó mítí wó? À má énò, pà ꞌbí ꞌduù, wàa yí má òlò njì ngoò ꞌdo tà ṛo lo gî, wò ꞌví giì òlò njú to ꞌdo tà ṛo ꞌbí ka lo. ");
INSERT INTO ndz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Mû mbe jìꞌvì lá jé ṛi vò ndo mû lá. Mû mbe jìꞌvì gî delè jé ṛì tó ndo mû lá. ");
INSERT INTO ndz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tacó à kû ŋò ŋa mû ni ká mítí ndo wó. À jé ṛuka ndo bàà ꞌdo tà mû kpeṛè lá. À delè jé ṛuka ndo mbiìgá ꞌdo tà mû gaꞌdí lá. ");
INSERT INTO ndz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tó ꞌduù kû bàkà káa ndâ tó i tí nó mbe yè yì wó géjé-géjé gî. Vò ꞌduù delè kû bàkà káa ndâ vò có tí nó mbe yè yì wó díí gî. Tacó nje ꞌduù kû ꞌdè có ká gítí ŋa i ŋìnó á gbí yì ꞌduù tí nò nô. ");
INSERT INTO ndz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Yo kû ꞌdè có máa ye a Mbe tí yo tacó yè, káa yo ꞌdi có mì ye lá? ");
INSERT INTO ndz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ye kpónó bà tùbà tí ŋa ꞌduù ŋìnó mbe gì gí mì ye, yí giì ꞌdi ndâ có mì ye, bìndi  yí giì bàkà go ndâ có tí nó náa ye ꞌdè ji yí nó, nô. ");
INSERT INTO ndz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ŋa ꞌduù tí nò go mbe gèè ꞌbá ŋìnó mbe duu gùù ndâ kpalà ꞌbá mì wó ngé miṛi ꞌbì wó gî. Ngo giì ò có tàkò ꞌbá tí nò, káa ꞌbá tí nò giì ṛò ká ngìkì tíyò, tacó à gèè me tí i-ꞌdì lá. ");
INSERT INTO ndz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Káa ꞌduù ŋìnò mbe ꞌdi ndâ có mì ye, káa yí bàkà go ndú lá, go ꞌduù mbe duu ta ndâ kpalà ꞌbá mì wó cokoꞌdo-cókóꞌdó. Ngo mâ giì ò có tàkò ꞌbá tí nò, à giì ꞌva tí to, si gbèe kpalà mí yaà lá.» ");
INSERT INTO ndz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jézù mâ giì cee ta bà ꞌdè ndâ có tí nó nje wó nó ji ndâ ꞌduù ꞌdáá gî, yí giì njè nó ya gí gbí gbata Kàpàrànáwùmù. ");
INSERT INTO ndz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mâ giì zekeꞌo, ꞌbí ꞌdakò tí ꞌduù Rómà, tí kùṛo ndâ àsìkérì ziꞌduù-vô, náa kpóló-kpolo bòò mì wó ta nòꞌo tí wó náa yí kû ù káa ndi sè o mì wó, ");
INSERT INTO ndz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","mâ giì ꞌdi có tí Jézù, yí giì tuu ndâ ꞌbí kpo ꞌduù mì ndâ Jùdéyà, máa ndú ya gí bà tèꞌé tí Jézù máa yí gì gí bà ꞌvala bòò mì yì. ");
INSERT INTO ndz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ndâ kpo ꞌduù tí nò giì ya gí mì Jézù, ndú mâ giì ꞌdè có tí nó náa kùṛo ndâ àsìkérì tí nò tuu ta ndú nó ji yí gî, ndú giì ꞌdeke tí ndú ji yí ta wotí tí  máa, «ꞌDakò tí nó ꞌvii tí ŋa ꞌduù ŋìnó náa wò ꞌví konì yí nó ngé ma. ");
INSERT INTO ndz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tacó yí bàkà nambeè ji ndâ ꞌduù mì ndoo ngé. À delè a yí ká bì bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì tí nó kpónó á tíyò nó ji ndoo.» ");
INSERT INTO ndz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jézù mâ giì ꞌdi có mì ndâ kpo ꞌduù tí nò, ndú giì njè nó ta ndú kû ya gí ꞌbá mì kùṛo ndâ àsìkérì tí nò. Ndú mâ giì dooko gí ꞌbá mì kùṛo ndâ àsìkérì tí nò gî, ndú giì ꞌdè ndâ ꞌbí kómbe kùṛo ndâ àsìkérì tí nò náa yí tuu ndú máa, ndú ya gí bà ꞌdè có ji kpo ꞌduù tí nò tí Jézù nò máa, «Mbe tí ye, yeeke tí lo ta bà gì gí ꞌbá mì ye lá, tacó ye ꞌvii tí ꞌduù ŋìnó náa wò ꞌví ṛì gí tàꞌi mì ye nó lá, ");
INSERT INTO ndz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","tacó énò, ye gbì gbí njembí ye tacó bà ya gí mì lo lá. ꞌDè káa có ta nje lo wàa bòò mì ye bà ꞌvala gî. ");
INSERT INTO ndz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tacó ye delè a ꞌduù ta ndâ kpo-kpò ꞌduù kuu kùṛo ye, ye delè a gbolò ꞌduù kùṛo ndâ àsìkérì, náa ye má tèꞌé tí àsìkérì, yí kû gì gí tà é mì ye. Ye delè má je nó ji àsìkérì, yí kû ya ta nó tí nò. Ye má ꞌdè có ji bòò mì ye máa yí bàkà i ŋìnó, yí kû bàkà .» ");
INSERT INTO ndz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jézù mâ giì ꞌdi có tí nò náa ꞌdakò tí nò tuu ta ndâ ꞌduù ji yí nò, nje wó giì ꞌdèè gî. Bìndi  yí giì ꞌvìsì tí wó gítí ndâ ꞌduù tí nó méé-me-mè mbe kû ṛu ndi wó nó, yí giì ꞌdè có ji ndú máa, «À kpêtí ká ꞌdo gbí òkò tí ndâ Ìzìrìyélì, ye jé ꞌdé ꞌbí ꞌduù gbaànjé mbe tee njembí wó mítí Mbíṛì á go i mì ꞌdakò tí nò lá!» ");
INSERT INTO ndz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ndâ ꞌdakò tí nò náa kùṛo ndâ àsìkérì tí nò tuu ndú ji Jézù nó mâ giì delè ndi ndú gí ꞌbá, ndú giì ꞌde bòò mì wó a gí yaà ꞌdo gbí nòꞌo gî. ");
INSERT INTO ndz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jézù bàkà me gbolò o bìndi bà ꞌvala bòò mì kùṛo ndâ àsìkérì tí nò lá, bìndi  ndú giì njè nó ta ndâ mbe tala có mì wó ꞌdo Kàpàrànáwùmù kû ya gí gbí gbata Nàyínì. Ndâ ꞌduù me mbè giì ki ꞌdo gbí gbata Kàpàrànáwùmù kû ko ndú. ");
INSERT INTO ndz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ndú mâ giì dooko gì njekèjì ndùgù bà ṛì gí gbí gbata Nàyínì gî, ndú giì ꞌde ndâ ꞌduù kû te ku ꞌbí ꞌdakò ꞌdo gbí gbata gí sè tacó bà ya gí bà duu yí. ꞌDakò tí nò mbe cì nò a gbèe ꞌviì mì nawu wó, káa nawu wó delè a nawù ku. Ndâ ꞌduù giì ki ꞌdo gbí gbata kí-ki kû ko tàkò ku ta ndâ niì tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mbe tí ndoo mâ giì ŋò nawu ꞌdakò tí nò mbe cì nò, yê ṛo wó giì bàkà yí ngé ndii gî. Yí bà-i-nò giì ꞌdè có ji niì tí nò màa, «Wa gbí lá.» ");
INSERT INTO ndz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bìndi  yí bà-i-nò giì ba to co gbí òkò tí ndâ ꞌduù ya gí mì ndâ ꞌduù tí nó mbe kû te ku nó, bìndi  yí giì tee ꞌbì wò mítí mbà tí nó náa ndâ ꞌduù kû te ta ku nô. Ndâ ꞌduù tí nó mbe kû te ku nó mâ giì ṛò tíyò gî, Jézù giì ꞌdè có ji ꞌdakò tí nò mbe cì gî nò, máa, «Ye kû ꞌdè có ji wò máa, wò a gí yaà, ndí lo ꞌviì-ꞌdakò.» ");
INSERT INTO ndz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ꞌDakò tí nò giì a kû ki tí wó to, bìndi  yí giì ꞌbìtà bà ꞌdè có, bìndi  Jézù giì je yí ji nawu wó. ");
INSERT INTO ndz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Gúku bà-i-nò giì bàkà ndâ ꞌduù ꞌdáá gî ngé ndii gî. Bìndi  ndú giì ꞌbìtà bà ùlù Mbíṛì máa, «Gbolò mbe ꞌdòkò có mì Mbíṛì co mí gbí òkò tí ze gî! Mbíṛì co wiṛi gì mì ndâ ꞌduù mì wó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tàwo có tí nò giì ya cee ꞌbá Jùdéyà, ta sè ndâ ꞌbí to ŋìnó dê-dê nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ndâ mbe tala có mì Jòvánì tí mbe caka tí ndâ ꞌduù mâ giì ya gí bà dìtà ndâ i tí nó ꞌdáá náa Jézù bàkà nó ji Jòvánì, Jòvánì giì ṛuka ndâ ꞌduù sósòꞌô ꞌdo gbí òkò tí ndú, ");
INSERT INTO ndz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","bìndi  yí giì tuu ndú, máa ndú ya gí bà ꞌvee Mbe tí ndoo máa, «Wò a ꞌduù tí nó náa Jòvánì ꞌdè có táánò máa yí kèjì nó wèè, ze ùndi ꞌduù tí nò?» ");
INSERT INTO ndz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ndâ ꞌduù mì Jòvánì náa yí tuu ndú nó mâ giì yee mí Jézù, ndú giì ꞌdè có ji yí máa, «À tuu ze a Jòvánì tí mbe caka tí ndâ ꞌduù, máa, ze gì gí bà ꞌvee wò, máa, ‹Wò a ꞌduù tí nó náa à máa wò kèjì nó, wèè, ꞌduù tí nò ká kpòò kèjì?› » ");
INSERT INTO ndz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ndâ mbe tala có mì Jòvánì náa yí tuu ndú nò giì yee mì Jézù ta o tí nò si yí kuu gbí nèté bà ꞌvala ndâ ꞌduù ꞌdo gbí ndâ nòꞌo mì ndú, ta bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù, ta bà njaanga ṛo ndâ mbe sú ṛo. ");
INSERT INTO ndz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ndú mâ giì ꞌvanda ndi có tí nó náa mbe nìbà i ji ndú tuu ta ndú nó, ji Jézù, Jézù giì ꞌvìsì có ji ndú máa, «Yo dele ndi yo ya gí bà dìtà ndâ i ŋìnó náa yo ŋò ta ṛo yo nó, ta ndâ có ŋìnó náa yo ꞌdi ta tù yo nó ji Jòvánì: ndâ ꞌduù tí nó táánò tí ndâ mbe sú ṛo nó kpónó kû zekeꞌo, ndâ ꞌduù tí nó ta kò ndú mbe gbeleꞌve gî nó kû nò nó kútí ndâ mbe cì kpónó ṛo gî, ndâ mbe sú tù kû ꞌdi có, ndâ ꞌduù ŋìnó mbe cì gî nó kû a gí yaà, à kû ma Banga-Ngú-Có mì Mbíṛì ji ndâ mbe yê. ");
INSERT INTO ndz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Káa yo ꞌví ꞌdè có ji yí máa, ꞌduù ŋìnó mbe me kpììkì-kpììkì gítí bà ùnje gítí ye lá nó a gbolò mbe tó pá.» ");
INSERT INTO ndz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ndâ ꞌduù mì Jòvánì náa yí tuu ndú nó mâ giì njè nó gî, Jézù giì ꞌbìtà bà ꞌvee ndâ mbè ꞌduù tí nó mbe tì mí mì wó nó gítí Jòvánì, máa, «Yo táánò kû kaa ꞌdo gbí ndâ gbata ya gí gbí kángáá nga ngoò gí bà ŋò a yè? Gí bà ŋò njì ngba náa pípìṛi kû pì yí mò énó, mò ézô? ");
INSERT INTO ndz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yo kaa ya gí bà ŋò a yè? Gí bà ŋò ꞌbí ꞌdakò mbe zaa ta ndâ banga bòngo? Ndâ mbe kû zaa ta ndâ banga bòngo kû dù a i ꞌbá mì ndâ kpo-kpò gba! ");
INSERT INTO ndz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Káa ꞌdóó i tí nó náa yo kaa ya gí bà ŋò nó a ŋa yè? Gí bà ŋò mbe ꞌdòkò có mì Mbíṛì? Ŋìnò a ndeṛè bà ya yo ká nò. Káa ꞌduù tí nò me gbolò ndii mbe ꞌdòkò có mì Mbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ꞌDakò tí nò a ꞌduù tí nó náa a cu có gítí wó mì gbí wáràgà mì Mbíṛì máa, Mbíṛì máa, ‹Nògí! Ye kèjì gí bà tuu tú mì ye gí kùṛo lo, gí bà ꞌviindi kpokèjì tacó tí lo,› nô. ");
INSERT INTO ndz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ye kû ꞌdè có ji yo máa, ꞌbí ꞌduù náa a niì ká jò yí mbe me gbolò ndii Jòvánì muu to tí nó wálá. Káa kpêtí ká énò, cèe táángbà ꞌduù sínò gbí òkò tí ndâ bòò-gba mì Mbíṛì me gbolò ndii yí gî.» ");
INSERT INTO ndz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ndâ cèe ꞌduù ꞌdáá gî, ta ndâ mbe kili i-mírì mâ giì ꞌdi ndâ có tí nò náa Jézù ꞌdè gítí Jòvánì nó, ndú giì ùnje gítí có mì Mbíṛì gî, bìndi  Jòvánì giì caka tí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Káa à káa ndâ mbe kpolo tí tàkìì, ta ndâ kpo-kpò mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà ká giì kpò có tí nó náa Mbíṛì ꞌdè ji ndú nó ta bà biya bá caka tí ndú mì Jòvánì gî. ");
INSERT INTO ndz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Káa Jézù giì ꞌvee ndâ mbè ꞌduù tí nò máa, «À má énò, ye kpónó ꞌví ꞌvii ndâ ꞌduù tí nó gbí o tí nó nó mítí yè? Ndú bà dù go ŋa yè? ");
INSERT INTO ndz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ndú go ndâ ꞌviì mbe kili ta bà muu ndú tende-tende mí gbí dùpì kû ŋo ꞌdì. Bìndi  ndâ ꞌbí ꞌduù giì dù á bàndò mì ndú giì yuu nje ndú ji ndâ ꞌbí ka ndú máa, ‹Ze cè cè bà ko niì ji yo, káa yo dù ṛu lá! Ze giì cè cè ku ji yo, káa yo wa gbí lá!› ");
INSERT INTO ndz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tacó Jòvánì tí mbe caka tí ndâ ꞌduù táánò gì gí to nô, yí táánò me mbe zò i lá, yí delè me mbe njù pe lá. Káa nje yo táánò giì dù gítí wó máa, a i ká gbí muu wó! ");
INSERT INTO ndz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Káa ꞌViì-mì-ꞌDakò giì gì kû zò i, ta bà njù pe, káa yo giì ꞌvìsì nje yo máa, ‹Ŋò káa ŋa ꞌdakò tí nó gi! Yí a mbe gàmàtà, tí vò mbe njù pe, tí kómbe ndâ mbe kili i-mírì ta ndâ i-tà-zùkùmèè!› ");
INSERT INTO ndz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kpêtí ká énò, à káa ndâ mbe ùnje gítí  énó máa, Mbíṛì a mbe ꞌdi gbí-o, ká bà ꞌdè yúcó.» ");
INSERT INTO ndz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ta o tí nò, ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà giì tèꞌé tí Jézù gítí i-zó-zò á ꞌbá mì wó. Káa si ndú kû zò i, ");
INSERT INTO ndz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ꞌbí niì náa ṛè wó volo ta ba bàkà vò i gî mâ giì ꞌdi có tí Jézù, yí giì ṛì gí tàkò ndú tàꞌi ta pó bàà gbí káꞌi-bàà náa à kiṛi ꞌdo tí díí, si ndú kû zò i. ");
INSERT INTO ndz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yí giì ṛò tíyò á seè kò Jézù náa yí paṛaka gí ndiì nó, kû wa gbí ta bà ꞌdù ngo-ṛo wó mítí ndâ kò Jézù. Bìndi  yí giì kucuku muungbó wó mí to, yí giì toṛo ngo-ṛo wó nò ꞌdo tí ndâ kò Jézù ta se muu wó. Bìndi  yí giì no tí ndâ kpázà kò Jézù ta nje wó, yí giì yee pó bàà mítí . ");
INSERT INTO ndz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ꞌDakò tí nò tí mbe kpolo tí tàkìì mì ndâ Jùdéyà náa Jézù kû zò i á ꞌbá mì wó nó mâ giì ŋò ŋa i tí nò náa vò niì tí nò kû bàkà ta Jézù nò, yí giì ꞌbìtà bà koṛo có máa, «ꞌDakò tí nó kùtàá má dú káa mbe ꞌdòkò có mì Mbíṛì, yí bà ŋò ŋa vò niì tí nó mbe kû gbala yí nó ni gî.» ");
INSERT INTO ndz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Káa Jézù giì ꞌdè có a i ji mbe kpolo tí tàkìì mì ndâ Jùdéyà tí nò, ta ṛè wó a Sìmónè, náa ndú kû zò i ꞌbá mì wó nò máa, «ꞌBí có kuu mì ye tacó bà ꞌdè ji wò, Sìmónè.» Káa Sìmónè giì ꞌvìsì có ji Jézù máa, «ꞌDè có mì lo, Mbe nìbà i.» ");
INSERT INTO ndz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jézù bà-i-nò giì lòkòꞌbò có ji Sìmónè máa, «ꞌBí ꞌdakò dígísèé tí mbe da i giì ꞌvii cû ji ndâ ꞌbí ꞌdakò sósòꞌô, máa ndú má bàkà gî, wàa ndú ꞌví dele ndí  ji yì. Yí ꞌvii ji ꞌbí ꞌduù a jú-kèè ziꞌduù-gbaànjé. Yí giì ꞌvii ji ꞌbí  a jú-kèè vô. ");
INSERT INTO ndz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Káa bà dele ndi cû tí nò ji mbe  giì kpó ndâ ꞌdakò tí nò sósòꞌô nó gî. Mbe cû tí nò mâ giì ŋò énò, yí giì ꞌdè có ji ndú, máa yì si có gítí ndú mí to gî. Wò koṛo có máa, a tàkòcò ꞌdi gbí òkò tí ndâ ꞌdakò tí nò sósòꞌô nò káa bà peteke gítí mbe cû tí nò ndii ka wó gî?» ");
INSERT INTO ndz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Káa Sìmónè giì ꞌvìsì có ji Jézù máa, «Ye koṛo có máa, tàkòcò ꞌdakò tí nó ta jú-kèè cû muu wó ziꞌduù-gbaànjé nô.» Jézù bà-i-nò giì ꞌvìsì có ji Sìmónè máa, «Có mì lo dú.» ");
INSERT INTO ndz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jézù bà-i-nò giì ꞌvìsì tí wó gítí niì tí nò mbe yee pó bàà mítí kò wó si ndú kû zò i nò. Bìndi  yí giì ꞌvee Sìmónè máa, «Wò ŋò niì tí nó gî, Sìmónè? Ye a wiṛi ꞌbá mì lo, káa wò je ngo ji ye tacó bà caka kò ye go i gbí tàkìì mì ndoo tí ndâ Jùdéyà lá. Káa niì tí nó ká giì ꞌdù ngo-ṛo wó mítí ndâ kpázà kò ye, bìndi  yí giì toṛo ta se muu wó. ");
INSERT INTO ndz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wò te wiṛi mítí ye ta bà òlò gbí tù ye go i gbí tàkìì mì ndoo tí ndâ Jùdéyà lá, káa ꞌdo tí o bà ṛì ye gí tàꞌi bà-i-nó, niì tí nó ká kpécè kuu gbí nèté bà no tí ndâ kpázà kò ye ta nje wó. ");
INSERT INTO ndz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ye gì gí ꞌbá mì lo, káa wò toṛo bàà mítí muu ye go i gbí tàkìì mì ndoo tí ndâ Jùdéyà lá, káa a niì tí nó ká giì toṛo pó bàà mítí ndâ kpázà kò ye. ");
INSERT INTO ndz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","À má énò, ŋìnò a ndeṛè có tí nò náa ye ꞌdè ta có ji wò énó máa, Mbíṛì je à-cee-gî ji yí gítí ndâ vò i mì wó mbe me mbè nó gî nó ká nò, tacó yí tee njembí wó mítí Mbíṛì ngé ma. Wò má zò ꞌbò gí mì ka lo, ka lo ꞌví zò ꞌbò gí mì lo. Má énò, niì tí nò zè Mbíṛì nìkì ta njembí wó gbaànjé tacó Mbíṛì je à-cee-gî ji yí á gítí ndâ vò i mì wó mbe ògbù ngé ndii gî nó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jézù mâ giì ꞌdè có ji Sìmónè cee gî, yí giì ꞌdè có ji niì tí nò máa, «À je à-cee-gî gítí ndâ vò i mì lo gî.» ");
INSERT INTO ndz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ndâ ꞌbí ꞌduù tí nó mbe kû zò i ta ndú nó mâ giì ꞌdi có tí nò, ndú giì ꞌbìtà bà ꞌvee ꞌve gbí òkò tí ndú máa, «À tà nó a ꞌdi ká nó, náa yí kû je à-cee-gî gítí ndâ vò i mì ndâ ꞌduù nó?» ");
INSERT INTO ndz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Káa Jézù giì ꞌdè có ji niì tí nó máa, «Bà tee njembí lo mítí Mbíṛì ꞌvala wò gî. Ya nìkì maa.» ");
INSERT INTO ndz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jézù giì ꞌbìtà bà nò ta bà ma Banga-Ngú-Có gítí bà dù Mbíṛì tí gba ji ndâ ꞌduù cee to ꞌdáá gî. À ta o tí nò kû ko tàkò wó gbí ndâ nó tí nò a ndâ ꞌduù tí nó muuꞌbì-nje só náa yí bàkà ndú tí ndâ tú mì wó nó, ");
INSERT INTO ndz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","giì je ndâ ꞌbí niì náa yí mòkò ndâ i ꞌdo gbí muu ndú, ta ndâ ꞌbí  náa yí ꞌvala ndú ꞌdo gbí ndâ ꞌbí ŋa tende nòꞌo, go Màríyà Màdèlénà náa yí mòkò ndâ i vô-nje só ꞌdo gbí muu wó, ");
INSERT INTO ndz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","giì je Jòwánà tí niì mì ꞌbí ꞌdakò ta ṛè wó a Cúzà tí mbe kû kpolo tí ndâ i-ꞌbá mì Èródè ꞌdáá gî, giì je Sùzánà, ta ndâ ꞌbí niì me mbè náa à nì ṛè ndú lá. Ndâ niì tí nò ká kû ko nje ndâ Jézù ta ndâ mbe tala có mì wó ta ndâ ꞌdóó i-zó-zò mì ndú. ");
INSERT INTO ndz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ta o tí nò, ndâ ꞌduù giì ki ꞌdo gbí ndâ gbata ꞌdáá kpùkú ya gí mì Jézù. Jézù mâ giì ŋò ndâ mbè ꞌduù tí nò mbe kaa gì gí mì wó nò, yí giì lòkòꞌbò có ji ndú, máa, ");
INSERT INTO ndz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò giì ya gí bà va ŋa gbí njí mì wó. Káa ta o tí nó si yí kû va ŋa nó, ndâ ꞌbí njì ŋa giì ꞌvaka tí ta ndi tí kpokèjì. Ndâ mbe co ta nó giì ꞌdò gbí ndú baṛaka gî. Bìndi  ndâ nuù giì ṛuka sè ndâ ŋìnó mbe ꞌvala ꞌdo gbí bà ꞌdò gbí ndú mì ndâ ꞌduù gî nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndâ ꞌbí njì ŋa giì ꞌvaka tí ta ndi pí ndâ díí mbe do cukpu-cùkpù ta gbí njí. Síí ndú mâ giì yee gí sè, ndú giì mìì gî, tacó to ṛo díí tacó bà bàkà gùlúsùꞌo ji teè ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ndâ ꞌbí njì ŋa giì ꞌvaka tí tà ndâ bè kpeṛè. Ndú giì kù gî, káa ndâ bè kpeṛè tí nò giì gèè bè ꞌbuuku ta muu ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ndâ ꞌbí njì ŋa giì ꞌvaka tí bà banga zì to. Ndú mâ giì kù gî, ndú giì jò ta muu ndú gbe-gbè, gbe-gbè énò.» Jézù mâ giì lòkòꞌbò có tí nò cee gî, yí giì ꞌdè có ji ndâ ꞌduù máa, «ꞌDuù ta tù bà ꞌdi có kuu tí muu wó, yí ꞌví ꞌdi có!» ");
INSERT INTO ndz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ndâ mbe tala có mì Jézù giì ꞌvee yí gítí gbí lòkóꞌbò tí nò náa yí ꞌdè gítí mbe va ŋa nò. ");
INSERT INTO ndz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Káa Jézù giì ꞌvìsì có ji ndú máa, «Mbíṛì je muu tacó bà ꞌdi gbí ngìì gítí bà dù yí tí gba ji yo gî, káa sè ndâ ꞌbí ꞌduù bà ꞌdi ká gbí lòkóꞌbò, tacó wàa, Ndú kpêtí má zeke i, ndú ꞌví ŋò i tí nò náa ndú kû zeke nò ni lá; ndú kpêtí má ꞌdi kòcò, ndú ꞌví ꞌdi gbí có tí nò náa ndú ꞌdi nò lá.» ");
INSERT INTO ndz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Ŋìnó a gbí lòkóꞌbò tí nó gítí mbe va ŋa nó ká nô: Njì ŋa tí nò a có mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ndâ ŋìnó mbe ꞌvaka tí tí kpokèjì nó a ndâ ꞌduù ŋìnó mbe ꞌdi ndâ có mì Mbíṛì, káa Gba-vò-i giì volo muu ndú ꞌdo tí bà ùnje gítí ndâ có tí nò gî, tacó wàa Mbíṛì ꞌví ꞌvala ndú lá. ");
INSERT INTO ndz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ndâ njì ŋa ŋìnò mbe ꞌvaka tí ta pí ndâ díí nó a ndâ ꞌduù ŋìnó mbe ꞌdi có mì Mbíṛì ta líkíꞌo tí ndú, káa có tí nò dù gbí njembí ndú lá. Ndú ùnje gítí có tí nò ká ta làmbu o, ꞌbí i mâ giì tala ndú, ndú giì solo sili ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ndâ njì ŋa ŋìnó mbe ꞌvaka tí gbí ndâ bè kpeṛè nó a ndâ ꞌduù ŋìnó mbe ꞌdi có mì Mbíṛì, káa ŋó ṛo ndâ kpo-kpò i, ta líkí ndâ i muu to tí nó, ta kpùṛù-kpùṛù njembí gítí ndâ i muu to tí nó, giì si o ji ndú gítí bà ꞌde i ꞌdo gbí ndâ có mì Mbíṛì náa ndú ꞌdi nò lá. ");
INSERT INTO ndz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ndâ njì ŋa ŋìnó mbe ꞌvaka tí gbí banga zì to nó a ndâ ꞌduù ŋìnó mbe ꞌdi có mì Mbíṛì, bìndi  ndú giì kpolo tí có tí nò ta tó njembí kácá-kácá ta tiṛì gbí  wálá, ndú te kpomuu gítí  yee tí o tí nó náa ndú giì bàkà go có tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«ꞌBí ꞌduù jé mbe tù wu ta kùpò ya tí  gí tàꞌi mì wó ta bèbìlì, bìndi  yí giì ꞌbu i mí ṛo ngba wu tí nò wálá. Mbe bàkà ŋa i tí nó jé wálá. À kû òlò wu ta o ꞌdáá gî ká mítí bàndò ŋìnó náa ꞌduù bà ŋò tàꞌi ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ndâ i ŋìnó náa a ngùù ndú nó dù gbí kùṛú tí ká lá. Ndâ có gbí ngàngbùùtù delè ꞌdáá gî bà ꞌvanda ká ꞌvanda gí sè. ");
INSERT INTO ndz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","À má énò, yo ꞌví sè tù yo tí kpoò. Tacó ꞌduù ŋìnó ta i kuu mì wó nó, àá bà je i ji yí me gbolò ndii ŋìnò náa à kuu mì wó nò gî. Káa i ꞌduù má wálá, à kpêtí káa làmbu ŋìnó náa yí kû koṛo có máa a kuu mì yì nó, àá bà je ꞌdo tí wó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ndâ nawu Jézù ta ndâ ꞌdóó-ꞌdòò nambe wó giì gì gí mì wó, káa ndú giì ꞌde kpokèjì bà ŋò yí lá, tacó ndâ ꞌduù tì yè to gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ndâ mbe ŋò ndú giì ꞌdè có tí ndú ji Jézù máa, «Ndâ nawu lo ta ndâ náꞌvindí lo gì kuu sè á kàzô tacó bà ŋò wò.» ");
INSERT INTO ndz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Káa Jézù giì ꞌvìsì có ji ndâ ꞌduù tí nò máa, «Ndâ nawu ye ta ndâ náꞌvindí ye a ndâ mbe ꞌdi có mì Mbíṛì bìndi  ndú giì bàkà go có tí nò.» ");
INSERT INTO ndz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ta ꞌbí o gbaànjé, Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Ndoo di kàpá gí tìto.» Ndú bà-i-nò giì kaa ya gí gbí gbâ, bìndi  ndú giì ꞌbì nó gí tìto go có mì wó nò. ");
INSERT INTO ndz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Káa si ndú gbí gbâ á ṛo ngo, ṛì giì ja Jézù gî. Ndâ mbe tala có mì Jézù mâ giì zekeꞌo, ndú ŋò gbolò pípìṛi gbo ndú mí ṛo ngo gî. Ngo kû giì gbàngà gí gbí gbâ. ");
INSERT INTO ndz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ndú bà-i-nò giì ꞌbìtà bà gbà Jézù, ta bà tò kû máa, «Vò i ꞌde ndoo gî! Ndoo dooko ta bà mìì ndoo mì ngo gî, Mbe nìbà i!» Jézù mâ giì ziya gî, yí giì do mítí ndâ gbolò pípìṛi tí nó mbe kû pì wírí-wìrì, wírí-wìrì nó, ta ngo tí nó mbe kû gbàngà yéngé-yèngè, yéngé-yèngè nó, máa, ndú dù ngbìì. Ndâ i tí nò bà-i-nò giì dù ngbìì gî, o giì ṛe déé. ");
INSERT INTO ndz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bà ndâ i tí nò mâ giì cee gî, Jézù giì ꞌvee ndâ mbe tala có mì wó máa, «Yo tee njembí yo mítí ye lá tacó yè?» Ndú giì si nje ndú nga-ngàà ta gúku, bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú máa, «À tà nó a ꞌdi, náa à kpêtí káa ndâ ngo ta pípìṛi, káa ndú kû ꞌdi có mì wó nó?» ");
INSERT INTO ndz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ndâ Jézù giì di kàpá bìndi bà gbùṛùngà ndú mì pípìṛi nò gítí ꞌbí wúngbó to á ꞌbá mì ndâ ꞌbí ŋa ꞌduù náa à kù nì mítí ndú a ndâ Jèràsínì. ");
INSERT INTO ndz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Káa, à káa póó bà tee kò Jézù mì tìto, ndú giì ꞌde tí ndú ta ꞌbí ꞌdakò ta ꞌbá mì ndú gbí gbata, ta ndâ i gbí muu wó. Ndâ i tí nò gbí muu ꞌdakò tí nò si yí kû nò ta só, ndú delè giì si yí kû ꞌvala ká ta ndi tà ndâ ꞌbá muuꞌdú ta cèe kôndi o. ");
INSERT INTO ndz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ꞌDakò tí nò mâ giì ŋò Jézù, yí giì ꞌva tí wó mí kùṛo Jézù, kû tò kû ta kòcò wó ngéé gí yaà, máa, «Àá mì lo ta ye a yè, ndí lo Jézù, tí ꞌViì-mì-Mbíṛì a ngéé gbíṛì? Ye kû ꞌdeke a tí ye ji wò máa, wò waa có mítí ye lá.» ");
INSERT INTO ndz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ꞌDakò tí nò pìì ŋa wo tí nò tacó a Jézù ká mòkò i tí nò gbí muu wó nò máa, yí có ꞌdo gbí muu wó gî. I tí nò ꞌva ꞌdakò tí nò mí to ta bà  me mbè. Ta o tí nó náa à má tanga mítí wó gî nó, à kû da ꞌbò mítí kò wó, à delè kû eṛe ꞌbì wó ta kpùṛùꞌvù njì wú, káa yí kû kaṛaka njì wú ꞌdo tí ꞌbì wó gî. Yí delè kû kiꞌviki gbì ꞌbò ꞌdo tí kò wó gî. I tí nó má tanga gî, yí kû te yí ya tí  gí gbí kángáá nga ngoò ta kpéétí wó. ");
INSERT INTO ndz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jézù mâ giì ꞌvee ꞌdakò tí nò gítí ṛè wó, ꞌdakò tí nò giì ꞌvìsì có ji yí máa, «Ṛè ye a ‹Tùmèṛè›.» ꞌDakò tí nò ꞌvìsì ŋa có tí nò ji Jézù tacó a ndâ i me mbè ká kò yí. ");
INSERT INTO ndz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ndâ i tí nò gbí muu ꞌdakò tí nò bà-i-nò giì ꞌdeke tí ndú ji Jézù máa, yí ꞌvaka ndâ yì mí gbí gùù wu lá. ");
INSERT INTO ndz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ndâ kàdùrúkù ta o tí nò mèè kû zò i á ta tàgbà gú gbí to tí nò; tacó énò, ndâ i tí nò gbí muu ꞌdakò tí nó giì yù nambeè ꞌdò mì Jézù máa, yí si ndâ yì ꞌví kaa ya gí gbí muu ndâ kàdùrúkù tí nò. Jézù mâ giì ùnje ji ndú gî, ");
INSERT INTO ndz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ndâ i tí nò giì kaa ꞌdo gbí muu ꞌdakò tí nò ya gí gbí muu ndâ kàdùrúkù tí nò gî, ndâ kàdùrúkù tí nò giì kaa ta ngèlè ta ndâ i tí nò gbí muu ndú ya gí bà oloko gí tà ngo ꞌdo tì njà gángá ngo, bìndi  ndú giì mìì ta ngo gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ndâ mbe gbà ndâ kàdùrúkù tí nò nò mâ giì ŋò ŋa i tí nò mbe bàkà tí mítí ndâ kàdùrúkù nò, ndú giì njè ta ngèlè ya gí bà ꞌdè ji ndâ ꞌduù gbí gbata, ta ndâ ꞌduù ta ndi gbí njí. ");
INSERT INTO ndz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ndâ ꞌduù giì ki ya gí bà ŋò ŋa i-seṛè tí nò náa ndâ mbe gbà ndâ kàdùrúkù ꞌdè có gítí  ji ndú nô. Ndú mâ giì yee kà, ndú giì ꞌde ꞌdakò tí nò náa Jézù mòkò ndâ i ꞌdo gbí muu wó nò kû ki tí wó á kùṛo Jézù, tí cèe ꞌduù ta bòngo tí wó. Bìndi  nje ndâ ꞌduù giì ꞌdèè gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ndâ mbe ŋò ndâ i tí nó mbe bàkà tí mítí ꞌdakò tí nò ta ndâ i gbí muu wó nó ta ṛo ndú mâ giì ya gí bà dìtà ndâ i tí nò ji ndâ ꞌduù, ");
INSERT INTO ndz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ndâ ꞌduù gbí gbata mì ndâ Jèràsínì ta ndâ ꞌduù ŋìnó ta ꞌbá mì ndú ta seè gbata nó giì ꞌdeke tí ndú ji Jézù ta gúku máa, yí njè nó ꞌdo gbí to mì ndâ yì gî. Tacó énò, ndâ Jézù ta ndâ mbe tala có mì wó giì kaa ya gí gbí gbâ, bìndi  ndú giì dele ndi ndú gí tìto. ");
INSERT INTO ndz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Káa ta o tí nó si ndâ Jézù kû bàkà nó nó, ꞌdakò tí nò náa yí mòkò ndâ i ꞌdo gbí muu wó nó giì ya gí mì Jézù, bìndi  yí giì ꞌdeke tí wó ji yí máa, yí si ndâ yì ꞌví ya ta ndú. Kaa Jézù giì ꞌdè có ji yí máa, ");
INSERT INTO ndz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ya gí ꞌbá, wàa wò ꞌví ma có ŋa i tí nó náa Mbíṛì bàkà ji wò nó ji ndâ ꞌduù.» ꞌDakò tí nò bà-i-nò giì ya gí ꞌbá, bìndi  yí giì ma có ŋa i tí nó náa Jézù bàkà ji yí nó cee gbí gbata ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jézù mâ giì dele ndi wó gí Gàlìléyà, ndâ ꞌduù giì te wiṛi mítí wó ngé ndii gî, tacó ṛo ndâ ꞌduù ta o tí nò ká kpokèjì tí wó. ");
INSERT INTO ndz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mâ giì zekeꞌo, ꞌbí gbolò ꞌduù tí kùṛo ndâ mbe kû kili mí bàndò bà ùlù Mbíṛì mì ndâ Jùdéyà, ta ṛè wó a Jáyìrù, giì ya gí bà zèè kò Jézù ta bà ꞌdeke tí wó ji yí máa, ndâ yì ya ta yí gí ꞌbá, ");
INSERT INTO ndz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","wàa yí ꞌví ꞌvala gbèe nájú yì tí ꞌvinî ta ndoò tí wó go muuꞌbì-nje só, ta séꞌi tí wó, mbe kû ù káa ndi sè o mì wó. Káa si ndâ Jáyìrù kû ya gí ꞌbá mì wó ta Jézù, ndâ ꞌduù me mbè giì tì ndú ꞌdee gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta o tí nò, ꞌbí niì ta mbelè kû yee tí wó ta ndoò muuꞌbì-nje só káa yí ꞌde mbe ꞌvala yí lá, kuu gbí òkò tí ndâ mbè ꞌduù tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Niì tí nò mâ giì ŋò Jézù, yí giì paṛa ta kpokèjì kapí Jézù co gbí òkò tí ndâ ꞌduù ya gí bà zèè nje bòngo tí Jézù. Bìndi  mbelè tí nò mbe kû yee tí wó nó ngé giì ṛò tíyò gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Káa Jézù giì ꞌvee ndâ ꞌduù máa, «A ꞌdi ká gbala ye?» Káa ndâ ꞌduù ꞌdáá gî giì o gî. Bìndi  Pìyétòrò giì ꞌdè có ji Jézù máa, «Mbe nìbà i, a ndâ ꞌduù tí nó mbe tì ꞌdee wò kìgìṛìgìì gî nó ká kû kpoko wò.» ");
INSERT INTO ndz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Káa Jézù giì ꞌvìsì có gí tàkò cò mì Pìyétòrò nò máa, «ꞌDuù gbala ye gî. Ye ŋò ni ꞌdo tí bà co wotí ꞌdo gbí dìì ye.» ");
INSERT INTO ndz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Niì tí nò mâ giì ŋò ni gî máa, kèjì bà ndo yí ꞌdo ꞌbì Jézù wálá, yí giì co ta gúku kpùṛù-kpùṛù-kpùṛù, ya gí bà kucuku muungbó wó mí kùṛo Jézù. Bìndi  yí giì yù gbí ndeṛè bà zèè nje bòngo tí Jézù mì wó, ta bà ꞌvala yí ngé á bìndi bà zèè nje bòngo tí Jézù mì wó, mí kùṛo ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Káa Jézù giì ꞌvìsì có ji yí máa, «Bà tee njembí lo mítí ye ꞌvala wò gî, nájú ye. Ya nìkì maa.» ");
INSERT INTO ndz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Káa si Jézù kû ꞌdè có ji niì tí nò, ꞌbí ꞌdakò náa à tuu yí ꞌdo ꞌbá mì Jáyìrù giì ꞌdè có ji Jáyìrù máa, «Si bà yeeke ndi mbe nìbà i kpòò mì to. Tacó bà i tí nò kà volo gî nò.» ");
INSERT INTO ndz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jézù mâ giì ꞌdi có tí nò náa ꞌdakò tí nò kû ꞌdè ji Jáyìrù nò, Jézù giì ꞌdè có ji Jáyìrù máa, «Cì gúku lá. Tee káa njembí lo mítí ye, wàa yí bà a gí yaà gî.» ");
INSERT INTO ndz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ndâ Jézù mâ giì yee ꞌbá mì Jáyìrù, Jézù giì biya gî máa ꞌbí ꞌduù ꞌví ṛì ta yì gí tàkò ku tàꞌi lá. Ndú giì ṛì gí tàꞌi tàkò ku ká ta ndâ Jáyìrù tí bu ku, ta nawu ku, giì je ndâ Pìyétòrò, ta Jòvánì, ta Jákòmò ꞌdo gbí òkò tí ndâ mbe tala có mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ndú giì ṛì ta ndú gí tàꞌi tàkò ku si ndâ ꞌduù kû mèṛèkè tí ndú ta bà wa ku sè. Káa Jézù giì ꞌdè có ji ndâ ꞌduù máa, «Yo si bà wa gbí mí to. Yí cì lá, yí kû tè a ṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ndâ ꞌduù mâ giì ꞌdi có tí nò, ndú giì ŋo Jézù ŋó-ŋo, tacó ndú ŋò ni gî máa, ꞌvinî tí nò cì gî. ");
INSERT INTO ndz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Káa Jézù giì zèè ꞌbì ꞌvinî tí nò, bìndi  yí giì ꞌdè có ji yí máa, «A gí yaà, ndí lo ꞌviì.» ");
INSERT INTO ndz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mâ giì zekeꞌo, ꞌvinî tí nò giì ꞌbìtà bà wo woò, bìndi  yí giì a ngé cónjóṛónjó gí yaà. Jézù bà-i-nò giì ꞌdè có máa, à je i-zó-zò ji yí. ");
INSERT INTO ndz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nje ndâ bu ꞌvinî tí nò ta nawu wó giì ꞌdèè gítí ŋa i tí nò gî, káa Jézù giì ꞌdè có ji ndú máa, ndú ꞌví ꞌdè có i tí nò mbe bàkà tí nò ji ꞌbí ꞌduù gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ta o tí nò Jézù giì kili ndâ tú mì wó muuꞌbì-nje só náa yí ṛuka ndú ꞌdo gbí òkò tí ndâ mbe tala có mì wó nó, yí giì je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù, ta wotí bà ꞌvala ndâ ꞌduù ꞌdo gbí ndâ nòꞌo ji ndú. ");
INSERT INTO ndz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bìndi  yí giì tuu ndú, máa, ndú ya gí bà ma Banga-Ngú-Có gítí bà dù Mbíṛì tí gba, ta bà ꞌvala ndâ ꞌduù ꞌdo gbí ndâ nòꞌo. ");
INSERT INTO ndz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yí giì ꞌdè có ji ndú máa, «Yo ꞌví je ꞌbí i tacó bà kpolo ta tí yo muu nó lá. Yo ꞌví zèè mû kóṛó lá, yo ꞌví le kúúkpá lá. Yo ꞌví te i-zó-zò lá, yo ꞌví je gùrúsù lá. Yo delè ꞌví je vòó ꞌbí bòngo lá. ");
INSERT INTO ndz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yo má yee tí to, yo ꞌví ṛàngà ndò lá, yo ꞌví dù ká tí gbèe ꞌbá yee tí o bà njè nó mì yo ꞌdo tí to tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yo má yee tí to, káa ndâ ꞌduù gbí to tí nò má te wiṛi mítí yo lá, ta o tí nó náa yo má kû njè nó ꞌdo tí to tí nò nó, yo ꞌví gbì njú to, to tí nò ꞌdo tí kò yo gî, tacó bà tùbà  ji ndâ mbe to tí nò máa, a ndú ká pà vò i mì ndú gítí miṛi ndú.» ");
INSERT INTO ndz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jézù mâ giì ꞌdè ndâ có tí nó náa à tí  nó ji ndâ mbe tala có mì wó cee gî, ndú giì njè nó ya cee to ꞌdáá gî kû ma Banga-Ngú-Có ji ndâ ꞌduù, ta bà ꞌvala ndâ mbe nòꞌo ta ndi tí ndâ bàndò ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Èródè tí gbolò ꞌduù mbe kû zogo Gàlìléyà mâ giì ꞌdi tàwo ndâ i tí nó náa Jézù kû bàkà nó, muu wó giì ŋònòkò tí gî. Tacó ndâ ꞌbí ꞌduù ta o tí nò kû ꞌdè có máa, a Jòvánì tí mbe caka tí ndâ ꞌduù ká ꞌvala ndi wó ꞌdo gbí muuꞌdú wó. ");
INSERT INTO ndz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ndâ ꞌbí ꞌduù máa, a Èlíjà tí nó tí ká mbe ꞌdòkò có mì Mbíṛì nó ká gì ndi wó. Káa ndâ ꞌbí ꞌduù ŋìndi ndú máa, a ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ ká mbe ꞌdòkò có mì Mbíṛì ká ꞌvala ndi wó. ");
INSERT INTO ndz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Èródè mâ giì ꞌdi ndâ có tí nó njúkú-njúkú nò, yí giì ꞌvee tí wó ta go bà ŋò Jézù, máa, «Ye da miṛi Jòvánì tí mbe caka tí ndâ ꞌduù gî. Wàa ꞌduù tí nò ta ṛè wó kû wu énò nò ꞌví dù a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ndâ tú mì Jézù giì dele ndi ndú gì gí bà dìtà ndâ i tí nó náa ndú bàkà si ndú muu nó nò ꞌdáá gî ji yí. Bìndi  Jézù giì kaa ndú, ndú giì ya ta ndú ta kpéétí ndú gítí ꞌbí to ta ꞌbá tí  wálá seè gbata Bètìsàyídà. ");
INSERT INTO ndz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Káa ndâ ꞌduù me mbè giì ŋò bà ya ndú gî. Bìndi  ndú giì kaa ya gí tàkò ndú. Ndâ ꞌduù tí nò mâ giì yee tàkò ndú ká gî, Jézù giì te wiṛi mítí ndú ta bà ma Banga-Ngú-Có gítí bà dù Mbíṛì tí gba ji ndú, delè ta bà ꞌvala ndâ mbe nòꞌo gbí òkò tí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ndâ mbe tala có mì Jézù muuꞌbì-nje só mâ giì ŋò ṛi kû tá-ta, ndú giì ṛuka bà muu ndú, bìndi  ndú giì ya gí mì wó, bìndi  ndú giì ꞌdè có ji yí máa, «Njè ndâ ꞌduù tí nò gî, wàa ndú ꞌví ya gí bà pà ndâ bàndò ṛì, ta i-zó-zò, á ta ndi ꞌbá mì ndâ ꞌduù. Tacó ndoo kpónó tí bàndò ŋìnó ta ꞌbá tí  wálá nò.» ");
INSERT INTO ndz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Káa Jézù giì ꞌvìsì có ji ndú máa, «Káa ꞌdóó yo má je ní i-zó-zò tí nò ji ndú, káa yè ká tí ?» Káa ndâ mbe tala có mì Jézù giì ꞌvìsì có ji yí máa, «Àá mì ze káa ndâ kù kô vô, ta ndâ sè sósòꞌô. Gbí có mì lo nò máa, ze ya gí bà sì i-zó-zò ji ŋa ndâ mbè ꞌduù tí nó?» ");
INSERT INTO ndz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ndâ mbe tala có mì Jézù giì ꞌvee yí énò tacó muu ndâ ꞌduù ta o tí nò ꞌdáá gî bà dù go álìfì vô. Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo ꞌdè có ji ndâ ꞌduù tí nò máa, ndú ki tí ndú to ta bà muu ndú, bà muu ndú, go ndâ ꞌduù ziꞌduù-só tí gbèe bàndò.» ");
INSERT INTO ndz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ndâ mbe tala có mì Jézù mâ giì ki ndâ ꞌduù mí to, á go có tí nò náa yí ꞌdè ji ndú nò gî, ");
INSERT INTO ndz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jézù giì kaa ndâ kù kô tí nó mì ndú vô nó, ta ndâ sè tí nó sósòꞌô nó, mí ꞌbì wó, yí giì zekeꞌo gí tàṛì, yí giì ùlù Mbíṛì tacó tí ndú, bìndi  yí giì kiꞌviki gbí ndú, bìndi  yí giì kaa ji ndâ mbe tala có mì wó, máa, ndú njèè ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ndâ ꞌduù giì zò i yè yì ndú ꞌdáá gî, bìndi  ndâ mbe tala có mì Jézù giì ṛuka sè i-zó-zò mbe kpò ndú gî yeke ndâ kèè muuꞌbì-nje só. ");
INSERT INTO ndz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ta ꞌbí o gbaànjé, si Jézù kû ꞌdeke tí wó ji Mbíṛì, si mì ndú ta ndâ mbe tala có mì wó muuꞌbì-nje só nó, yí giì ꞌvee ndú máa, «Yo kû ꞌdi ꞌdo mì ndâ ꞌduù énó máa ye a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Káa ndú giì ꞌvìsì có ji yí máa, «Ndâ ꞌbí ꞌduù kû ꞌdè có énò máa, wò a Jòvánì tí mbe caka tí ndâ ꞌduù. Ndâ ꞌbí ꞌduù kû ꞌdè có máa wò a Èlíjà tí nó táánò tí mbe ꞌdòkò có mì Mbíṛì nô. Káa ndâ ꞌbí ꞌduù ŋìndi ndú máa, wò a ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ká mbe ꞌdòkò có mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Káa Jézù giì ꞌvee ndú máa, «Káa yo? Yo ŋìndi yo kû ꞌdè có máa ye a ꞌdi?» Káa Pìyétòrò giì ꞌvìsì có ji yí máa, «Wò a Bìndi-Mbíṛì!» ");
INSERT INTO ndz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Káa Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, ndú ꞌví ꞌdè ndi có tí nò náa Pìyétòrò ꞌdè nò ji ꞌbí ꞌduù gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yí giì ꞌdè có ji ndú máa, «ꞌViì-mì-ꞌDakò kèjì gí bà kònò a ndú tí ndâ séꞌi. Ndâ kpo-ꞌduù-ꞌbá, ta ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà bà zi yí gî. Káa ta sili taꞌô bìndi ku mì wó, yí bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jézù giì ꞌdè ꞌbí có ji ndâ mbe tala có mì wó ꞌdáá gî máa, «Go bà dù tí mbe ṛu ndi ye má tí ꞌduù, ꞌduù tí nò ꞌví ò-bà-mbí miṛi wó gî, yí ꞌví ùnje gítí bà kònò séꞌi ta ṛi ꞌdáá gî á muu ye, wàa yí ꞌví gì gí bà ṛu ndi ye. ");
INSERT INTO ndz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tacó ꞌduù ŋìnó ta go bà kpolo tí ꞌdóó miṛi wó tí wó nó ká bà giṛi miṛi wó. Káa ꞌduù ŋìnó mbe giṛi miṛi wó tacó tí ye nó ká bà ꞌde ꞌválá. ");
INSERT INTO ndz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ꞌDuù bà ꞌde gbí ndâ i muu to tí nó a yè, náa yí kpêtí má ꞌde ndú ꞌdáá gî, bìndi  yí giì giṛi miṛi wó gî? ");
INSERT INTO ndz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ye ꞌdè có tí nò ji yo, tacó ꞌduù má kû kì nô tí bà tùbà tí wó tí ꞌduù mì ye muu to tí nó, yí delè má kû kì nô tí ndâ có mì ye muu to tí nó kpónó, ꞌViì-mì-ꞌDakò delè bà kì nô tí ꞌduù tí nò ta o tí nó náa ꞌViì-mì-ꞌDakò bà giì tòngbaà go i mì ndâ Bu wó ta ndâ tó basìlì. ");
INSERT INTO ndz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","«Káa ye kû ꞌdè có ji yo ta yúcó máa, ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí yo, á mbe kû ṛò tíyò kùṛo ye kpónó nó, bà ŋò o bà dù Mbíṛì tí gba muu to tí nó má kózò gî, bìndi  ndú bà giì cì .» ");
INSERT INTO ndz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jézù giì bàkà káa i go sili vô-nje taꞌô á bìndi bà ꞌdè nje mì ndú ta ndâ mbe tala có mì wó, bìndi  yí giì kaa ndâ Pìyétòrò, ta Jòvánì, ta Jákòmò, ndú giì ya ta ndú gí pí ꞌbí njà gú. ");
INSERT INTO ndz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Káa si yí kû giì ꞌdeke tí wó ji Mbíṛì, cè kózò tí gbíṛo wó giì ꞌvìsì tí gî. Ndâ bòngo tí wó giì dù kû tòngbaà ŋàlì-ŋàlì, ꞌbùꞌúú. ");
INSERT INTO ndz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ndâ mbe tala có mì Jézù mbe ko yí ya tí  gí pí gú nó mâ giì zekeꞌo, ndú giì ŋò ndâ Jézù kû ꞌdè nje ta ndâ ꞌbí ꞌdakò sósòꞌô. Ndâ ꞌdakò tí nò a ndâ Mòze ta Èlíjà ");
INSERT INTO ndz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ká co gí gbí ngbaꞌo kû ꞌdè nje ta ndâ Jézù gítí o bà giì ci yí mí Jèrùzàlémè go có tí nó náa Mbíṛì ꞌdè sàà gî. ");
INSERT INTO ndz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ndâ Pìyétòrò ta ndâ ka wó ta o tí nò a ku ta ṛì, káa ndú giì te kpo muu kû zeke ngba ndâ ꞌdakò tí nó sósòꞌô mbe kû ṛò tíyò á mì ndú ta ndâ Jézù nò. ");
INSERT INTO ndz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Káa si ndâ ꞌdakò tí nò kû giì njè nó ꞌdo mì Jézù, Pìyétòrò giì ꞌdè có ji Jézù mâ, «Bà dù ndoo bà-i-nó a cèe tó có, Mbe nìbà i. Si ze ꞌví tò ndâ ndùúṛù taꞌô mí bà-i-nô, gbaànjé á ji wò, gbaànjé ji Mòze, wàa gbaànjé ji Èlíjà.» Pìyétòrò ꞌdè có tí nò tacó yí ŋò ꞌdóó có bà ꞌdé-ꞌdè mì wó lá. ");
INSERT INTO ndz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Káa si Pìyétòrò kû ꞌdè có tí nò, ndú mâ giì zekeꞌo, yùkúú, kùlù mù yiiga muu ndú gî. Kùlù mù tí nò giì te a gúku mítí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ndú bà-i-nò giì dù kû ꞌdi kòcò ꞌduù kû ꞌdè có gbí kùlù mù tí nò máa, «Ŋìnó a ꞌViì mì ye, tí bà njembí ye; yo ꞌdi có mì wó!» ");
INSERT INTO ndz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ndú mâ giì zekeꞌo bìndi bà kaṛa kòcò ꞌduù tí nò, ndú giì ŋò káa Jézù ta kpéétí wó. Ndâ mbe tala có mì Jézù giì nè nje ndú gí tàkò i tí nò mbe bàkà tí nò go bà nè nje ndâ ꞌduù gí tàkò i mbe bàkà tí gbí gàzâ. ");
INSERT INTO ndz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Si ndâ Jézù ta ndâ mbe tala có mì wó taꞌô mbe ko yí ya tí  gí pí gú nó kû giì dele ndi ndú gí tàgbà gú ta ꞌbí yé, ndú giì ꞌdè tí ndú ta ndâ ꞌduù me mbè mbe kû kaa ya gí kùṛo ndú. ");
INSERT INTO ndz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ꞌBí ꞌdakò ꞌdo gbí òkò tí ndâ ꞌduù tí nò mbe tì bìnjìì nò giì dù ká to nò giì ja kû mí to máa, «Ye kû ꞌdeke a tí ye ji wò máa, wò ŋò yê ṛo ꞌviì mì ye. Ŋò yê ṛo gbèe ꞌviì mì ye, Mbe nìbà i! ");
INSERT INTO ndz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","I tí nò gbí muu wó nò má a gî, yí kû ja kû mí to, bìndi  yí giì ꞌva yí kàngàṛàngà mí to, pù kû giì gì ꞌdo gbí nje wó tùkù-tùkù gí to; i tí nò kû ꞌva yí ta o ꞌdáá gî, bà dò ꞌbì ꞌdo tí wó á mì i tí nò delè me kpoò. ");
INSERT INTO ndz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ye ꞌdeke tí ye ji ndâ ꞌbí mbe tala có mì lo máa, ndú mòkò i tí nò ꞌdo gbí muu wó gî, káa à giì kpò ndú gî.» ");
INSERT INTO ndz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Káa Jézù giì ꞌvìsì có gí tàkò có mì ꞌdakò tí nò máa, «Ákoo ndí yo ndâ mbe ngbútù mbe tee njembí mítí Mbíṛì lá. Yo bà lè mí tà ṛo ye a ngaṛànga? Ndoo bà dù ta ndoo ye tí o ngàyi? Gì ta ꞌviì tí nò mì lo nò gí bà-i-nô.» ");
INSERT INTO ndz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Si ꞌdakò tí nò kû giì ya ta ꞌviì mì wó ta i-gbí-muu wó nò ji Jézù, i tí nò giì tanga mítí ꞌviì tí nò, yí giì ꞌva yí mí to, bìndi  yí giì aanga yí jègèꞌdèè gî. Káa Jézù giì do mítí i tí nò, bìndi  yí giì mòkò yí ꞌdo gbí muu ꞌviì tí nò gî. Bìndi  yí giì je yí ji bu wó. ");
INSERT INTO ndz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ndâ ꞌduù mâ giì ŋò i tí nò náa Jézù bàkà nò, nje ndú ꞌdáá gî giì ꞌdèè gítí ŋa wotí mì Mbíṛì nò gî. Káa si muu ndâ ꞌduù ká jé kû eṛe tí gítí ndâ i tí nó ꞌdáá gî náa Jézù ta o tí nò kû bàkà nó, yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, ");
INSERT INTO ndz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Yo si có tí nó náa ye kû ꞌdè nó ꞌví ya gí gbí tù yo, tacó àá kèjì gí bà cu gòmbò tí ꞌViì-mì-ꞌDakò ji ndâ ꞌdakò.» ");
INSERT INTO ndz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Káa bà ꞌdi gbí có tí nò giì kpò ndâ mbe tala có mì Jézù gî, tacó à ngùù gbí  ꞌdo tí ndú gî. Káa gúku bà ꞌvee yí gítí gbí  delè giì zèè nje ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kponje giì tanga gbí òkò tí ndâ mbe tala có mì Jézù máa, gbolò ꞌduù mbe ndii ndâ ꞌbí ka wó gbí òkò tí ndâ yì ꞌdáá gî a ꞌdi wè? ");
INSERT INTO ndz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Káa Jézù giì ꞌdi gbí ŋa bà koṛo có mì ndú nò gî. Tacó énò, yí giì je ꞌbí làmbu ꞌviì ki mí ṛègbà tí wó, ");
INSERT INTO ndz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","bìndi  yí giì ꞌdè có ji ndú máa, «ꞌDuù mbe te wiṛi á mítí ꞌviì tí nó ta ṛè ye, yí te wiṛi tí nò a i mítí ye, káa ꞌduù mbe te wiṛi mítí ye, yí te wiṛi tí nò a i mítí mbe tuu ye, tacó ꞌduù ŋìnó tí táángbà ꞌduù gbí òkò tí yo ꞌdáá gî nó, a gbolò ꞌduù gbí òkò tí yo ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jòvánì giì ꞌdè có ji Jézù máa, «Ze ŋò ꞌbí ꞌdakò kû mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ta ṛè mì lo, káa ze giì ṛò yí á ꞌdo tí  gî, Mbe tí ze, tacó yí me ꞌduù mì ndoo lá.» ");
INSERT INTO ndz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Káa Jézù giì ꞌvìsì có ji Jòvánì máa, «Yo ṛò yí ꞌdo tí  lá; tacó ꞌduù ŋìnó ta vò có mì wó ta wò wálá nó, a ꞌduù mì lo.» ");
INSERT INTO ndz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kùṛo o bà ya Jézù gí gbíṛì mâ giì dooko gî, yí giì bàkà nó kû ya gí Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Káa yí giì tuu ndâ tú mì wó ya gítí ꞌbí to Sàmárìyà, gí bà ꞌviindi i ù ta ndi wó. ");
INSERT INTO ndz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Káa ndâ ꞌduù gbí to tí nò giì biya bà bàkà wiṛi ù ta ndi wó gî, tacó yí zèè ta o tí nò a kpokèjì Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ndâ tú mì wó, ndâ Jákòmò ta Jòvánì, mâ giì ŋò énò, ndú giì ꞌvee yí máa, «Ze tèꞌé tí wu ꞌdo gbíṛì gí bà mìì ndú gî, Mbe tí ze?» ");
INSERT INTO ndz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Káa Jézù giì ꞌvìsì tí wó, yí giì do mítí ndâ Jákòmò ta Jòvánì. ");
INSERT INTO ndz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bìndi  ndú giì njè nó ꞌdo gbí to tí nò ya gítí ꞌbí to. ");
INSERT INTO ndz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Káa si ndú muu nó, ꞌbí ꞌdakò giì ꞌdè có ji Jézù máa, «Àá bà ja ye a ꞌdo tàkò lo káa go ngo.» ");
INSERT INTO ndz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò máa, «Ndâ gùù mì ndâ ngàmbé kuu tí . Ndâ ꞌbá mì ndâ nuù kuu tí . Káa bàndò bà te muu ꞌViì-mì-ꞌDakò mítí  wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yí giì ꞌdè có ji ꞌbí ꞌdakò máa, «Ṛu ndi ye.» Káa ꞌdakò tí nò giì ꞌvìsì có ji yí máa, «Si ye ꞌví ya gí bà duu ku bu ye má kózò gi, Mbe tí ye.» ");
INSERT INTO ndz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò máa, «Si ndâ ku ꞌví duu ndâ ꞌdóó ku mì ndú, wàa wò ꞌví ya gí bà ma có bà dù Mbíṛì tí gba.» ");
INSERT INTO ndz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ꞌBí ꞌdakò bà-i-nò giì ꞌdè có ji Jézù máa, «Ye bà ṛu ndi lo, kpo ꞌduù. Káa si ye má ya gí bà ꞌvee ndâ ꞌduù ꞌbá mì ye má kózò gi.» ");
INSERT INTO ndz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò máa, «Mbe zèè bá kâ á tà njí gî, káa yí kû zekeꞌo á gí ndiì bà ꞌvii tí mbe dù tí bòò gba mì Mbíṛì wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ta o tí nò, Mbe tí ndoo Jézù giì ṛuka ndâ ꞌbí mbe tala có mì wó ziꞌduù-taꞌô-nje muuꞌbì nje-muuꞌbì só, bìndi  yí giì tuu ndú gí kùṛo, só-só-só gí gbí ndâ gbata, ta ndâ to tí nó náa yí kû koṛo có bà co wiṛi ya gí gbí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Káa ta kùṛo o bà njè nó mì ndú, yí giì ꞌdè có ji ndú máa, «Ndâ i gbí njí ògbù ngé, káa muu ndâ mbe kili ndú me njíꞌdí. À má énò, yo ꞌdeke tí yo ji Mbíṛì tí mbe njí tí nò, tacó wàa yí ꞌví tuu ndâ ꞌbí ꞌduù gí bà kili ndâ i ꞌdo gbí njí mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yo njè nó! Ye kpónó kû tuu yo á go ndâ rómbo á gí gbí òkò tí ndâ gbôwó. ");
INSERT INTO ndz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Káa yo ꞌví kaa gùrúsù ta yo tacó bà sì ta i muu nó lá. Yo ꞌví le kúúkpá bà yù i lá. Yo ꞌví kaa ndâ ꞌbí tàmà lá. Yo ꞌví nò ta bà ꞌvee ndâ ꞌduù ta ndi tí kpokèjì lá. ");
INSERT INTO ndz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yo má yee tí ꞌbá, kpédélé có náa yo ꞌví ꞌdè ji ndâ mbe ꞌbá tí nò ꞌví dù a, ‹Mbíṛì ꞌví si yo ꞌví dù nìkì maa!› ");
INSERT INTO ndz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ꞌDuù ŋìnó ta ꞌdê njembí wó nó má kuu ꞌbá tí nò, Mbíṛì bà bàkà nambeè ji yí go có tí nò gbí njembí yo nò gî. Káa ꞌduù ta ꞌdê njembí wó má ꞌbá tí nò wálá, Mbíṛì bà bàkà nambeè tí nò ta gó  tí yo nò ji ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yo má yee tí to, yo ꞌví ṛàngà ꞌbá lá. Ndâ mbe ꞌbá má je ndâ i-zó-zò ta ngo ji yo, yo ꞌví biya lá, tacó mbe nèté kû ka wuꞌo me sínò lá. ");
INSERT INTO ndz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yo má yee tí to, káa ndâ ꞌduù má te wiṛi mítí yo, yo ꞌví zò i-wiṛi tí nó náa ndú bàkà ji yo nò. ");
INSERT INTO ndz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yo ꞌví ꞌvala ndâ mbe nòꞌo tí bàndò tí nó náa ndâ ꞌduù te wiṛi mítí yo á tí  nô. Yo ꞌví ꞌdè có ji ndâ ꞌduù tí bàndò tí nò máa, ‹Kùṛo bà dù Mbíṛì tí gba mì yo dooko gî.› ");
INSERT INTO ndz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Káa yo má yee tí to, káa ndâ ꞌduù tí to tí nò má te wiṛi mítí yo lá, yo ꞌví co gítí kpokèjì, wàa yo ꞌví gbì njú to, to tí nò ꞌdo tí kò yo gî, bìndi  yo ꞌví ꞌdè có ji ndâ mbe to tí nò máa, ");
INSERT INTO ndz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹À kpêtí káa njú to ꞌbá mì yo, ze gbì ꞌdo tí kò ze mí to ji yo gî. Káa yo koṛo muu yo máa, kùṛo bà gì Mbíṛì gí bà dù tí gba mì ndâ ꞌduù ꞌdáá gî dooko gî.› ");
INSERT INTO ndz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ye kû ꞌdè có ji yo ta kponje tí  wálá, máa, Mbíṛì bà waa có mítí ndâ ꞌduù tí nò ta wotí tí  ndii ŋìndi ndâ ꞌduù gbí gbata Sòdómà gî. ");
INSERT INTO ndz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Yo tí ndâ ꞌduù gbí gbata Kòràzínì, ta ndâ ꞌduù gbí gbata Bètìsàyídà, bà ŋò mítí yo! Tacó ye táánò má bàkà ndâ seṛè tí nó náa ye bàkà ji yo nó a i ji ndâ ꞌduù gbí ndâ gbata Tírò ta gbata Sìdónì, o go énó ndú kpónó yù zì sùwálì, bìndi  ndú giì toṛo mbúlùwu mítí ndú tacó bà tùbà  máa, ndâ yì ꞌvìsì muu ndâ yì ꞌdo tí ndâ vò i mì ndâ yì gî, sàà gî! ");
INSERT INTO ndz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Káa a ndâ ꞌduù gbí ndâ gbata Tírò ta Sìdónì ká bà ꞌde bà wo woò á có tí yo ta o bà waa có mì Mbíṛì mítí ndâ ꞌduù ta ndòngbú o. ");
INSERT INTO ndz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Káa yo tí ndâ ꞌduù gbí gbata Kàpàrànáwùmù! Yo bà oko tí yo go énò yee tàṛì? Mbíṛì bà ꞌvaka yo ꞌdo kà gí tà-ꞌbá-gì-lá.» ");
INSERT INTO ndz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bìndi  Jézù giì ꞌdè có ji ndâ mbe tala có mì wó, máa, «À má énò, ꞌduù má ꞌdi có mì yo, yí ꞌdi nò a có mì ye. ꞌDuù má biya yo, yí biya nò a ye. Káa ꞌduù má biya ye, yí biya nò a ꞌduù tí nó mbe tuu ye.» ");
INSERT INTO ndz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ndâ mbe tala có mì Jézù ziꞌduù-taꞌô-nje muuꞌbì nje-muuꞌbì só náa yí tuu ndú nó giì dele ndi ndú gì gí bà dìtà ndâ i tí nó náa ndú bàkà ta ndi to nó ji yí ta líkíꞌo tí ndú, máa, «Ze má ꞌdè có kpêtí ká ji ndâ i-gbí-muu ndâ ꞌduù ta ṛe lo, ndú kû ꞌdi có mì ze, Mbe nìbà i!» ");
INSERT INTO ndz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye giì ŋò Gba-vò-i kû ꞌva tí wó to ꞌdo tàṛì mélé-mèlè go bà ì mù nô. ");
INSERT INTO ndz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yo ŋò nô! Ye je wotí bà ꞌdò ndâ kpoo, ta ndâ sene, ta kò yo á ji yo gî. Ye delè giì je wotí bà co gbí ŋò kuꞌdì tí Gba-vò-i á ji yo gî. ꞌBí i delè gí bà bàkà yo wálá. ");
INSERT INTO ndz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kpêtí ká énò, yo ꞌví dù ta líkíꞌo tí yo tacó náa ndâ i-gbí-muu ndâ ꞌduù kû cì gúku tí yo nò lá. Yo dù ta líkíꞌo tí yo tacó Mbíṛì cu ṛe yo mí gbíṛì gî.» ");
INSERT INTO ndz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ta o tí nò, Bèṛi-mì-Mbíṛì giì zèè ꞌbì tí Jézù mbi ta líkíꞌo gî. Bìndi  yí giì ꞌbìtà bà ùlù Mbíṛì máa, «Ye ùlù wò tí Bu ye, tí Mbe tí ndâ tàṛì ta to. Tacó wò ngùù gbí ndâ i tí nò á ꞌdo tí ndâ mbe ꞌdi gbí-o, ta ndâ mbe yú ṛo gî. Wò giì ꞌdè gbí ndú a i ji ndâ víí ꞌviì sínò. À énò Bu ye, tacó wò táánò bàkà nò a bà njembí lo. ");
INSERT INTO ndz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bu ye kaa ndâ i ꞌdáá gî á mí ꞌbí ye tí ꞌViì mì wó gî. Káa mbe ŋò ye tí ꞌViì mì wó, ni wálá, à káa yí tí Bu ye; mbe ŋò yí tí Bu ye delè ni wálá, à káa ye tí ꞌViì mì wó, giì je ndâ ꞌduù tí nó ta go bà ꞌdè ji ndú tí ꞌViì mì wó no.» ");
INSERT INTO ndz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jézù giì ꞌvìsì tí wó gítí ndâ mbe tala có mì wó, bìndi  yí giì ꞌdè có ji ndú ta kpéétí ndú máa, «Ndâ ꞌduù tí nó mbe ŋò i tí nó náa yo kû ŋò nó a ndâ mbe tó pá. ");
INSERT INTO ndz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ye kû ꞌdè có ji yo máa, ndâ mbe ꞌdòkò có mì Mbíṛì me mbè, ta ndâ kpo-kpò gba dígísèé, dù ta go bà ŋò i tí nó náa yo kpónó kû ŋò nó kpòò, káa ndú ŋò gbaànjé lá; ndú dù ta go bà ꞌdi có tí nó náa yo kû ꞌdi nó kpòò, káa ndú delè ꞌdi lá.» ");
INSERT INTO ndz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ta ꞌbí o gbaànjé, ꞌbí mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà giì ꞌvee Jézù, ta tiṛì máa, «Ye ꞌví bàkà a ŋa yè, tacó wàa ye ꞌví ꞌde ta ꞌválá ŋìnó mbe cee lá nó?» ");
INSERT INTO ndz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Káa Jézù giì ꞌvee ꞌdakò tí nò delè máa, «À cu mí gbí wáràgà mì Mbíṛì máa yè? Wò ꞌdeke máa yè?» ");
INSERT INTO ndz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Káa ꞌdakò tí nò giì ꞌvìsì có ji Jézù máa, «À cu mí gbí wáràgà mì Mbíṛì énó máa, ‹Wò ꞌví zè Mbe tí lo, tí Mbíṛì mì lo, nìkì ta njembí lo gbaànjé; wò ꞌví zè ꞌbí ŋa i gbí bà ꞌvala wò nìkì ndii Mbíṛì mì lo lá, wò ꞌví kili wotí mì lo ꞌdáá gî, ta ndâ kóṛó-koṛo có mì lo ꞌdáá gî, ká gítí bà zè yí nìkì maa. Wò delè ꞌví zè ꞌbí ka lo nìkì maa, á go bà zè tí lo nìkì maa mì lo.› » ");
INSERT INTO ndz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jézù giì ꞌvìsì có ji ꞌdakò tí nò máa, «Có mì lo náa wò ꞌdè nò ꞌdú. Bàkà go énò, wàa Mbíṛì bà je ꞌválá ŋìnó mbe cee lá nó ji wò gî.» ");
INSERT INTO ndz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Káa ꞌdakò tí nó giì bàkà bà ꞌdi gbí tàkìì mì ndâ Jùdéyà mì wó ji Jézù ta bà ꞌvee yí máa, «Ka ye a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Káa Jézù giì ꞌvìsì có ji yí gbí lòkóꞌbò máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò tí Jùdéyà giì njè nó ꞌdo Jèrùzàlémè kû ya gí gbí gbata Jérìkò. Yí mâ giì yee kpokèjì, ndú giì ꞌde tí ndú ta ndâ mbe kùmùkù i mì ndâ ꞌduù. Ndâ vò ꞌduù tí nò giì kaa ndâ i mì wó ꞌdáá gî, ndú giì gbì yí dê gí mì ku, bìndi  ndú giì si yí tí mê wó mítí kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ꞌBí bu-Mbíṛì mì ndâ Jùdéyà mbe kû ndii ta nó giì ꞌde ꞌdakò tí nò gbáṛákàà tísì á tí ṛo kpokèjì. Yí giì zeke yí ká zeke gí tísì kà, bìndi  yí giì waa to có seè tí wó, yí giì ndii ta nó mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bìndi bà ndii bu-Mbíṛì mì ndâ Jùdéyà nò, ꞌbí ꞌdakò tí ꞌduù mbe kû bàkà nèté á gbí ndùgù ꞌbá-Mbíṛì mbe gì co tí gbèe kpokèjì tí nò giì ꞌde ꞌdakò tí nò ká kuu gbáṛákàà tísì á bàndò mì wó nò. Káa yí delè giì zeke káa yí gí to kà ta ṛo wó, bìndi  yí giì waa to có ṛègbà tí wó, yí giì ndii gî. ");
INSERT INTO ndz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","«Káa ꞌbí ꞌdakò, tí ꞌduù Sàmárìyà mbe kû ndii ta nó, giì ꞌde yê tí nò náa à gbì yí nò. Yí mâ giì zeke yí gí tísì kà, yê ṛo wó giì bàkà yí ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bìndi  yí giì yèè dê gítí wó, yí giì bàkà nèté gítí ndâ kà tí nò ta ndi tí wó nò, ta bà doo ṛo ndú ta gó nèbítì, bìndi  yí giì yee bàà mí ṛo ndú, bìndi  yí giì eṛe ndú ꞌdáá gî. Yí giì te yí mí pí nò tí nó náa yí kû o nô. Bìndi  yí giì ya ta yí gí ꞌbá mì ꞌbí ꞌdakò. ");
INSERT INTO ndz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ndú giì tè ṛì, yé mâ giì too gî, yí giì je làmbu i ji mbe ꞌbá, bìndi  yí giì ꞌdè có ji yí máa, ‹Pò yí, ye bà dele có bà-i-nô tacó bà sì có ndâ i mì lo náa wò volo gbí ndú mítí wó nô.› ");
INSERT INTO ndz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«À má énò, tó kaà kpónó a ꞌdi á ꞌdo gbí òkò tí ndâ ꞌdakò tí nó taꞌô nò?» ");
INSERT INTO ndz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mbe ꞌdi gbí tàkìì mì ndâ Jùdéyà tí nò giì ꞌvìsì có ji Jézù máa, «Tó kaà a ꞌduù tí nó tí mbe ŋò yê ṛo wó nô.» Jézù bà-i-nò giì ꞌvìsì có ji yí máa, «À má énò, ya gí ꞌbá, wàa wò ꞌví bàkà go i mì ꞌduù Sàmárìyà tí nò.» ");
INSERT INTO ndz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì wùùkù to yee gbí to ꞌbá mì ndâ ꞌbí niì ta ṛè wó a Márátà, Márátà giì tèꞌé tí Jézù gí ꞌbá mì ndú ta náꞌvindí wó Màríyà. ");
INSERT INTO ndz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jézù mâ giì ya gí ꞌbá kà, Màríyà giì njè nó ya gí bà ki tí wó kùṛo Mbe tí ndoo kû ꞌdi ndâ có tí nó náa yí kû ꞌdè nó, ");
INSERT INTO ndz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","jee Márátà mì nje nèté kecì ta kpéétí wó. Márátà mâ giì ŋò ŋa nèté tí nó mbe jee tí mí to á kùṛo wó nó, njembí wó giì volo gî. Yí bà-i-nò giì njè nó ya gí mì Mbe tí ndoo, bìndi  yí giì ꞌvee yí máa, «Có bà si ye mì náꞌvindí ye ta kpéétí ye mí nje nèté nò á ṛo lo wálá gî, Mbe nìbà i? ꞌDè có ji yí máa, yí gì gí bà konì ye!» ");
INSERT INTO ndz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Káa Mbe tí ndoo giì ꞌvìsì có ji Márátà máa, «Márátà! Márátà! Njembí lo kû mù gítí ndâ i me mbè. ");
INSERT INTO ndz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Káa ndâ kpóló-kpolo i gbí òkò tí ndâ i tí nò me mbè lá; à má ta bà ꞌdè ta yúcó, à káa i gbaànjé cuki. Màríyà cu ꞌbì wó nò a i mítí ŋìnó mbe nìkì ndii ndâ ꞌbí  gî nô. Á má énò, àá bà je ꞌdo tí wó wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ta ꞌbí o gbaànjé, Jézù giì ya gítí ꞌbí bàndò kû ꞌdeke tí wó ji Mbíṛì. Yí mâ giì ꞌdeke tí wó cee gî, ꞌbí mbe tala có mì wó giì ꞌdè có ji yí, máa, «Tùbà cèe kèjì bà ꞌdeke tí ji Mbíṛì ji ze go ŋìndi Jòvánì tí mbe caka tí ndâ ꞌduù náa yí me ji ndâ mbe tala có mì wó nó gi, Mbe nìbà i.» ");
INSERT INTO ndz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Káa Jézù giì ꞌvìsì có ji ndâ mbe tala có mì wó máa, «Yo ꞌdeke tí yo ji Mbíṛì énò máa, ‹Buù, à ùlù ṛè lo. Gì gí bà dù tí gba. ");
INSERT INTO ndz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Je i-zó-zò ji ze ta ṛi ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Si có gítí ndâ vò i mì ze mí to, tacó ze kû si có gítí ndâ vò i mì ndâ ka ze mí to. Si ze mí gbí ndâ i ŋìnó mbe kû eendi ze gítí vò i lá.› » ");
INSERT INTO ndz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Káa Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, «ꞌBí ꞌduù ꞌdo gbí òkò tí yo nò má ya gí mì kómbe wó ta kpo-gbíꞌo, bìndi  yí giì gbà njekèjì muu wó máa, yí je làmbu i-zó-zò ji yì, ");
INSERT INTO ndz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","wàa yì ꞌví ya tí  ji ꞌbí kómbe yì mbe gì ꞌdo muu njà nó giì gbaaka yì si o gbooko gî nò, ");
INSERT INTO ndz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","káa kómbe wó nò giì ꞌvìsì có ji yí máa, ‹Si bà pèè mbí ye mí to, tacó ze kpò gbí njekèjì gî. Kpokèjì bà je ꞌbí ŋa i mì ye kpónó ji wò wálá, tacó ze ta ndâ ꞌviì mì ye kû tè ṛì.› A ŋa yè ká bà bàkà tí? ");
INSERT INTO ndz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ye kû ꞌdè có ji yo máa, ꞌdakò tí nò, kpêtí má je i-zó-zò ji mbe gbà njekèjì muu wó nò gítí có kómbeè tí nó á gbí òkò tí ndú ta yí nó lá, yí bà je ji yí tacó bà dò nô ꞌdo ṛo wó gî. ");
INSERT INTO ndz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Káa ye kû ꞌdè có ji yo énò máa, yo yù i, wàa àá bà je i tí nò ji yo gî. Yo pà i wàa yo bà ꞌde i tí nò gî. Yo ku njekèjì wàa àá bà njaanga ji yo gî. ");
INSERT INTO ndz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tacó àá bà je i ji ꞌduù ŋìnó mbe yù i nó gî, ꞌduù ŋìnó mbe pà i nó, bà ꞌde i tí nò gî, à delè bà njaanga njekèjì ji ꞌduù ŋìnó mbe gbà njekèjì nó gî ");
INSERT INTO ndz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«À bu ꞌviì ngàyi gbí òkò tí yo ká bà je yâ-kpoo ta zì kpoo tí  ji ꞌviì mì wó, náa ꞌviì má yù yâ-sè ꞌdo tí wó? ");
INSERT INTO ndz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","À bu ꞌviì ngàyi ká bà je sene ji ꞌviì mì wó, náa ꞌviì má yù pàṛà ngùù ꞌdo tí wó? ");
INSERT INTO ndz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Káa ndâ vò ꞌduù go yo nò má ni bà je tó i ji ndâ ꞌviì mì yo gî, Bu yo tí nó á gbíṛì nó ꞌví tuu Bèṛi-mì-Mbíṛì ji ndâ mbe ꞌdeke tí ndú ji yí lá?» ");
INSERT INTO ndz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ta o tí nò, Jézù kû mòkò ꞌbí i mbe eṛe nje ꞌbí ꞌdakò ꞌdo tí bà ꞌdè có gî ꞌdo gbí muu wó. I tí nò mâ giì co ꞌdo gbí muu ꞌdakò tí nò gî, ꞌdakò tí nò giì ꞌbìtà bà ꞌdè có. Nje ndâ ꞌduù giì ꞌdèè gítí bà ꞌdi kòcò ꞌdakò tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Káa ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndú bà-i-nò kû giì ꞌdè có máa, «A Bèlìzèbúlù, tí Gba-vò-i, ká kû je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ji yí.» ");
INSERT INTO ndz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ndâ ꞌbí ꞌduù ŋìndi ndú giì ꞌdè có ji yí ta tiṛì máa, yí bàkà seṛè ji ndâ yì, wàa ndâ yì ꞌví ŋò tí  ni énó máa, a Mbíṛì ká kû je wotí bà mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ji yí. ");
INSERT INTO ndz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Káa Jézù giì ꞌvìsì có ji ndú gí tàkò ŋa bà koṛo có mì ndú nò, máa, «Có mì ndâ ꞌduù mì gba má toko lá, ꞌbá mì gba tí nò bà ꞌbu gî. Có mì ndâ ꞌduù á ṛùkàtiì mì ndú delè má toko lá, ꞌbá tí nò bà sì tí wálá. ");
INSERT INTO ndz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Káa Gba-vò-i má njèè gbí ꞌbá mì wó gî, ꞌbá mì wó nò bà ṛò tíyò ta ŋa kpokèjì ngàyi, náa yo má ꞌdè có énò máa, ye kû mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ta wotí mì Gba-vò-i nò? ");
INSERT INTO ndz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ye má kû mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ta wotí mì Gba-vò-i, ndâ ꞌviì mì yo kû mòkò ndú ta wotí mì ꞌdi? À má énò, ndoo si ndâ ꞌviì mì yo ꞌví waa ngbàngà ji ndoo. ");
INSERT INTO ndz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Káa ye má kû mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù ta wotí mì Mbíṛì, gbí  énó máa, Mbíṛì gì tí gba mì yo gî. ");
INSERT INTO ndz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Cèe wu ꞌdakò ta ndâ zíꞌi ꞌbì wó má kû ù ṛègbà ndâ i mì wó, muu ndâ i mì wó nò bà ba wálá, ");
INSERT INTO ndz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","yee ká tí o tí nò náa ꞌbí ngbílí mbe da gbí ka wó ngbílí má kiꞌviki gbí bá ganda mì wó gî, yí bà giì kaa ndâ i mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Có mì ꞌduù má toko ta ye lá, yí a mbe jòò gbí có ta ye. ꞌDuù má kili i ta ye lá, kû jaaka gbí i. ");
INSERT INTO ndz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«À má mòkò i ꞌdo gbí muu ꞌduù, i tí nò kû ya gí bà wùùkù to ta ndi gbí ndâ kángáá nga ngoò, kû pà bà bàndò bà tèwo wó. Káa bà ꞌde bàndò bà dù yí tí  má kpò yí gî, yí bà ꞌdè có máa, ‹Bà ì ngèlè gí ndiì kpò a ngo. À má énó, ye bà dele ndi ye ya gítí ká ꞌbá mì ye.› ");
INSERT INTO ndz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yí má dele ndi wó ya gí bà ꞌde à ꞌviindi tàꞌi tí nó náa yí co ꞌdo tí  nó gî, ");
INSERT INTO ndz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","yí bà dele ndi wó ya gí bà gì ta ndâ ꞌbí ka wó tí ndâ fùúfû mbe ndii yí gî, vô-nje só, gí gbí muu ꞌduù tí nò, yee tí o tí nó náa ndú volo ꞌduù tí nò gî.» ");
INSERT INTO ndz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Si Jézù kû ꞌdè ndâ có tí nò, ꞌbí niì giì ꞌdè có ta kòcò wó ngéé gí yaà ꞌdo gbí òkò tí ndâ mbè ꞌduù tí nò mbe kili nò, máa, «À ùlù niì tí nó tí mbe jò wò, náa wò kpolo ta ngo kí wó nô!» ");
INSERT INTO ndz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Káa Jézù giì ꞌvìsì có ji niì tí nò máa, «À nìkì a bà ùlù ndâ mbe ꞌdi có mì Mbíṛì bìndi  ndú giì bàkà go có tí nò, á cotí bà ùlù nawu ye.» ");
INSERT INTO ndz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jézù mâ giì ŋò ndâ ꞌduù kû giì tì me mbè jèlè yí gî, yí giì ꞌdè có ji ndú máa, «Ndâ vò ꞌduù tí nó á gbí o tí nó nó kpónó kû tì nò, máa ye ꞌví bàkà seṛè á ji ndâ yì. Káa àá bà tè ta ndú káa seṛè tí nó dígísèé mbe bàkà tí mítí Jónà tí ꞌbí mbe ꞌdòkò có mì Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ꞌViì-mì-ꞌDakò bà tùbà  ji ndâ ꞌduù tí nó gbí o tí nó nó máa a Mbíṛì ká tuu yì, jé ká go bà tuu Jónà á ji ndâ ꞌduù gbí gbata Nínèvà dígísèé máa a Mbíṛì ká tuu yì. ");
INSERT INTO ndz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","«Niì tí nó táánò tí gbolò gba mì ndâ ꞌduù tí nó ta ꞌbá mì ndú mbe mò gí gbíꞌdè nó, bà kpì ngbàngà tí ndâ ꞌduù tí nó gbí o tí nó nó ta o bà co Ṛi bà waa có wúnò. Tacó yí te nó ngé ꞌdo tàgbaṛìꞌo gì gí bà ꞌdi ndâ có mì gbolò gba tí nó tí Sólómònì, tí mbe ꞌdi gbí-o nó dígísèé gî. Káa yo zekeꞌo gi, ꞌbí i mbe me gbolò ndii Sólómònì gî kpónó kuu nô. ");
INSERT INTO ndz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ndâ ꞌduù gbí gbata Nínèvà bà kpì ngbàngà tí ndâ ꞌduù tí nó mbe kû ꞌvala kpónó nó, ta o bà co Ṛi bà waa có wúnò. Tacó Jónà dígísèé kò-kò ta ndâ vò i mì ndú ji ndú, bìndi  ndú giì ꞌvìsì muu ndú á ꞌdo tí ndâ vò kpokèjì mì ndú gî. Káa ꞌbí i mbe me gbolò ndii Jónà gî kpónó kuu nô. ");
INSERT INTO ndz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«ꞌBí ꞌduù jé mbe òlò wu mí nje kùpò, bìndi  yí giì ꞌbu i mí ṛo ngba wu tí nò gî nò, wálá. Ndâ ꞌduù ta o ꞌdáá gî kû te ngba wu ká mítí bàndò ŋìnó náa ndú bà ŋò ta to ṛègbà tí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ṛo ꞌduù a kùpò mì wó. I má tí ndâ ṛo lo wálá, ndú go áángá-aanga kùpò mbe ṛa wu ká ṛá-ṛa. Gbí  énó máa, sè dìì lo ꞌdáá gî gbí ngbaꞌo. Káa ndâ ṛo lo má ta ósú tí ndú, go kùpò ŋìnó ta gùlúsùꞌo tí , náa à jè ta bà tù wu mí nje  jé-jè nó, gbí  énó máa, sè dìì lo ꞌdáá gî gbí ꞌdíꞌdiꞌo ");
INSERT INTO ndz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","À má énò, yo kpolo tí yo máa wu ꞌví mee ꞌdo nje kùpò mì yo, si yo mí gbí ꞌdíꞌdiꞌo lá. ");
INSERT INTO ndz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ndâ bà to tí lo ꞌdáá gî má kû tòngbaà, dìì lo ꞌdáá gî bà ngbaṛanga to go bà ngbaṛanga to mì wu á nje kùpò.» ");
INSERT INTO ndz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jézù mâ giì cee ta có mì wó gî, ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà giì tèꞌé tí wó gítí i-zó-zò á ꞌbá mì wó. Káa Jézù giì ꞌbì ngé káa tà bà zò i á kùṛo bà caka ꞌbì wó. ");
INSERT INTO ndz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nje mbe kpolo tí tàkìì mì ndâ Jùdéyà tí nò giì ꞌdèè ta bà ŋò Jézù kû zò i kùṛo bà caka ꞌbì wó go i gbí tàkìì mì ndú tí ndâ Jùdéyà gî. ");
INSERT INTO ndz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jézù mâ giì ŋò énò, yí giì ꞌdè có ji ꞌdakò tí nò máa, «Yo tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà kpónó kû caka kapí ndâ késî ngo, ta kapí ndâ kùṛùngbú, káa có gítí bà gbùṛùngà ndâ ꞌduù, ta bà bàkà vò i, yè gbí njembí yo gî. ");
INSERT INTO ndz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ndí yo ndâ ŋónókó! Àá táánò me káa gbèe Mbíṛì tí nó mbe bàkà kapí ndâ káꞌi tí nò nó ká bàkà gbí ndú lá? ");
INSERT INTO ndz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","À nìkì énó máa, yo konì ndâ mbe yê ta ndâ ꞌbí i tí nó gbí ndâ káꞌi mì yo nô. Tacó wàa ndâ i ꞌdáá gî ꞌví dù ngbáṛángàꞌi tacó tí yo. ");
INSERT INTO ndz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Káa yo tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà bà ŋò mítí yo! Yo kû njèè gbí ndâ víí kpátùyâ náa yo kili ꞌdo gbí njí mì yo muuꞌbì, bìndi  yo giì ṛuka ꞌdo tí ndú gbaànjé-gbaànjé ji Mbíṛì, bìndi  yo giì mò ndâ bà waa có ta yúcó, ta bà zè Mbíṛì nìkì maa, gí nje seè. Yo kùtàá bà gò ndâ i tí nò me ta bà mò ndâ ꞌbí có mì Mbíṛì gí nje seè lá. ");
INSERT INTO ndz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Yo tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà bà ŋò mítí yo! Tacó a tí yo a go bà ki tí yo dengece-dèngècè ta ndi pí ndâ banga mbata á tí ndâ bàndò bà kili ndâ ꞌduù gí bà ùlù Mbíṛì. Go bà te duù mítí bà ꞌvee yo mì ndâ ꞌduù á ta ndi tí ndâ bàndò bà mà ꞌvélè delè tí yo ngé. ");
INSERT INTO ndz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yo bà ŋò mítí yo! Tacó yo go ndâ muuꞌdú náa ndâ ꞌduù ŋò lá, bìndi  ndú giì nò nó co pí ndú.» ");
INSERT INTO ndz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Káa ꞌbí mbe nìbà tàkìì mì ndâ Jùdéyà gbaànjé giì ꞌvìsì có ji Jézù máa, «Nje zèè mû mì lo nò ṛo ze delè gî, Mbe nìbà i.» ");
INSERT INTO ndz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Káa Jézù giì ꞌvìsì có ji yí máa, «Yo tí ndâ mbe nìbà i bà ŋò mítí yo! Tacó gbímbí ndâ ꞌduù wálá ji yo ta bà ꞌdeeke du káꞌi mí muu ndú. Káa yo jé gítí bà konì ndú ta bà te ndâ du káꞌi tí nò njíꞌdí wálá. ");
INSERT INTO ndz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Yo bà ŋò mítí yo! Tacó a yo ká bì ndâ muuꞌdú ndâ mbe ꞌdòkò có mì Mbíṛì tí nó náa ndâ ká gù yo ziki ndú nô. ");
INSERT INTO ndz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yo ꞌdè ta nje yo gî, yo delè giì ùnje gítí ndâ i tí nò náa ndú bàkà nò gî, máa, a ndâ ká gù yo ká ziki ndâ mbe ꞌdòkò có mì Mbíṛì, káa yo giì bì ŋìndi yo a ndâ muuꞌdú bìndi ndú. ");
INSERT INTO ndz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tacó énò, Mbíṛì tí Mbe ꞌdi gbí-o giì ꞌdè có énó máa, ‹Ye bà tuu ndâ ꞌbí mbe ꞌdòkò có, ta ndâ ꞌbí tú mì ye, ji ndú, ndú bà waaka tàkòcò ndâ ꞌbí , ndú delè bà mèèkèꞌi tí ndâ ꞌbí .› ");
INSERT INTO ndz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tacó énò, mbelè ndâ mbe ꞌdòkò có mì Mbíṛì tí nó mbe ꞌbìtà bà mìì to ꞌdo tí bà ꞌbìtà bà suu to tí nó nó ꞌví dù tí ꞌbì yo tí ndâ ꞌduù tí nó mbe kû ꞌvala kpónó nô. ");
INSERT INTO ndz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Yo bà ꞌdè ndeṛè bà mìì ndâ tó ꞌduù tí nó mbe ꞌbìtà bà mìì ꞌdo tí Àbélè, yee tí Zàkàríyà tí nó náa yo zi yí mí gbí òkò ndâ bàndò bà te i-cí-ci ta ꞌbá-Mbíṛì nô. Ye kû ꞌdè có ji yo énó máa, kózò tí ndâ ꞌduù tí nó mbe kû ꞌvala kpónó nó bà ꞌdè ndeṛè ku ndâ ꞌduù tí nò ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Yo tí ndâ mbe nìbà tàkìì mì ndâ Jùdéyà bà ŋò mítí yo! Tacó yo jèjèèkè tí yo mí njekèjì mì Mbíṛì ji ndâ ꞌduù go ndâ kî á ṛo mbu. Ndú bà ya gí gbí mbu wálá, káa ndú delè gítí bà si ndâ ꞌbí sè ꞌví ya gí gbí mbu ká wálá!» ");
INSERT INTO ndz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Káa si Jézù kû giì njè nó ꞌdo ꞌbá mì mbe kpolo tí tàkìì mì ndâ Jùdéyà tí nò mbe tèꞌé tí wó gítí i-zó-zò nò, ndâ có tí nò náa yí ꞌdè nò giì zèè tí ndâ mbe nìbà tàkìì, tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, ngé ndii gî. Bìndi  ndú giì ꞌbìtà bà pà nje wó tacó wàa yí ꞌví ꞌdè ndâ ꞌbí có ŋìnó náa à gbí njembí wó nó gí sè, ");
INSERT INTO ndz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tacó bà pà kpokèjì tacó bà zèè yí ꞌdo tí ngo nje wó. ");
INSERT INTO ndz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ta o tí nò ndâ ꞌduù giì tì me mbè mí mì Jézù, tí ŋa ŋìnó náa kpokèjì bà yuu kò gbí òkò tí ndú wálá. Jézù mâ giì ŋò énò, yí giì ꞌbìtà bà kpo-gbí-tà-tù ndâ mbe tala có mì wó kpédéléꞌi máa, «Yo kpolo tí yo ꞌdo tí ṛúꞌbù mì mbe kpolo tí tàkìì mì ndâ Jùdéyà. Ye kû nì a nambeè-ṛo tí nò náa ndú kû bàkà ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","À wúnò bà te i ꞌdo nje ndâ i tí nó náa à kpónó ꞌbuku i mí nje ndú nó ꞌdáá gî. À delè bà ꞌdi ndâ có tí nó kpónó tí ndâ có kóó nó gbaànjé-gbaànjé gî. ");
INSERT INTO ndz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","À má énò, à wúnò bà ꞌdi ndâ có tí nó náa yo kpónó kû ꞌdè gbí ꞌdíꞌdiꞌo nó ꞌdáá gî gbí ngbàà ṛi. Àá bà kò-kò ta ndâ có tí nó náa yo nè tí yo mí tàꞌi kû ꞌdè gbí kóó nó ꞌdo pí cèléngé. ");
INSERT INTO ndz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Káa ye kû ꞌdè có ji yo tí ndâ kómbe ye máa, yo ꞌví cì gúku tí ndâ mbe zi dìì yo cuki nò lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ye bà tùbà tí ŋa ꞌduù tí nó náa yo ꞌví cì gúku tí wó nó ji yo. Yo cì gúku a i tí ꞌduù ŋìnó ta wotí bà ꞌva lilí yo mí gbí vò bàndò á bìndi bà zi yo mì wó nô. Yo ùnje gítí có mì ye nò, yo cì gúku tí wó! ");
INSERT INTO ndz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«À kû sì ndâ naṛù vô gí ꞌdè, me ká ta mìlímì sósòꞌô cuki lá? Káa bà mbí Mbíṛì ò ꞌdo tí ꞌbí  gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Káa à kpêtí káa ndâ njì se muu tí muu yo, Mbíṛì ꞌdeke ndú gbaànjé-gbaànjé ꞌdáá gî, gî. À má énò, yo cì gúku lá, tacó i gbí yo me gbolò ndii i gbí ndâ naṛù me mbè gî! ");
INSERT INTO ndz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Ye kû ꞌdè có ji yo ta yúcó máa, ꞌduù má ùnje gítí ye mí kùṛo ndâ ꞌduù, ꞌViì-mì-ꞌDakò wúnò bà ùnje gítí ꞌduù tí nò mí kùṛo ndâ basìlì mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Káa ꞌduù má biya ye mí kùṛo ndâ ꞌduù, ꞌViì-mì-ꞌDakò wúnò delè bà biya ꞌduù tí nó mí kùṛo ndâ basìlì mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Káa ye kpónó kû ci nó a yo máa, Mbíṛì bà je à-cee-gî ji mbe ꞌdè vò có gítí ꞌViì-mì-ꞌDakò gî. Káa Mbíṛì bà je à-cee-gî ji mbe ꞌdè vò có gítí Bèṛi-mì-Mbíṛì wálá. ");
INSERT INTO ndz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Ndâ ꞌduù má kû ya ta yo gí gbí ngbàngà kùṛo ndâ ꞌduù a tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì, ta kùṛo ndâ mbe kû zogo ndâ Jùdéyà, ta kùṛo ndâ gba, njembí yo ꞌví mù énó máa, yo ꞌví ꞌdè mí kùṛo kà a ŋa có yè wè, nò lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tacó a Bèṛi-mì-Mbíṛì ká bà wu có tí nó náa yo ꞌví ꞌdè nó ji yo.» ");
INSERT INTO ndz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ꞌBí ꞌdakò gbí òkò tí ndâ mbè ꞌduù tí nò giì ꞌdè có ji Jézù máa, «Mbe nìbà i! ꞌDè có ji náꞌvindí ye máa, yí njèè gbí ndâ i bìndi bu ze á ji ze ta yí.» ");
INSERT INTO ndz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò máa, «A ꞌdi ká bàkà ye tí gba mbe njèè gbí ndâ i mì yo ta náꞌvindí lo á ji yo, ꞌdakò?» ");
INSERT INTO ndz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bìndi  yí giì ꞌdè có ji ndâ ꞌduù tí nó mbe tì bìnjìì nó, máa, «Yo njaanga ṛo yo, wàa yo ꞌví kpolo tí yo, máa, yo ꞌví dù tí ndâ mbe gbolò njembí lá, tacó à me ndâ kpo-kpò i tí nó mbe yè to mì ꞌduù nó ká kû si yí ꞌví ꞌvala cèe bà ꞌvala ndò lá.» ");
INSERT INTO ndz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bìndi  yí giì lòkòꞌbò có ji ndú máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò ta ndâ i mì wó me gbolò giì da cû tí i-seṛè. ");
INSERT INTO ndz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yí giì ꞌbìtà bà koṛo có ta kpéétí wó máa, ‹Ye kpónó ꞌví bàkà a ŋa yè? Ye ꞌví ꞌde bàndò gítí ŋa seṛè cû tí nó kòtí ꞌdi? ");
INSERT INTO ndz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","À nìkì énò máa, ye kiꞌviki ndâ cokoꞌdo-cókóꞌdó gálá tí nó kpónó ta ndâ i mì ye gbí ndú nó gí to, wàa ye ꞌví bì ndâ ꞌbí  wooko-wòòkò i mbe te ndâ ꞌbí i mì ye ta ndâ cû tí nó ꞌdáá gî.› ");
INSERT INTO ndz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bìndi  yí giì dù kû koṛo có ta kpéétí wó máa, ‹Ye a mbe tó pá! Ndâ tó i ŋìnó ta go ndú tí ye nó ꞌdáá gî kuu mì ye gítí mbè ndoò. ꞌVálá tacó tí ye me có lá; ye bà dùlù tí ye ta bà zò i, ta bà njù pe.› ");
INSERT INTO ndz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Káa Mbíṛì giì ꞌdè có ji ꞌdakò tí nò máa, ‹Bèbìlì tí nó wúnó nó a bèbìlì bà cì wò, ndí lo ŋónókó! À má énó, a ꞌdi ká bà zèè ndâ i tí nó náa wò kili ndú yè to gî nó, á bìndi lo?› » ");
INSERT INTO ndz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jézù giì yee nje lòkóꞌbò mì wó máa, «Ŋìnò a ŋa i tí nó mbe kû ꞌde ndâ mbe kû kili ndâ kpo-kpò i gítí miṛi ndú, káa Mbíṛì ŋò ndâ kpo-kpò i tí nò ṛo wó tí i lá nó, ká nò.» ");
INSERT INTO ndz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, «À má énò, njembí yo ꞌví si bà mù énó máa, ‹Ze bà zò a yè wàa ze ꞌví ꞌvala tí ?› mí to. Yo delè ꞌví me kpùṛù-kpùṛù énó máa, ‹Ze ꞌví yuu a yè á mí kapí kû ze?› lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ꞌVálá a kpóló-kpolo i ndii i-zó-zò gî, bìndi  dìì ꞌduù a kpóló-kpolo i ndii ndâ bòngo gî. ");
INSERT INTO ndz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Káa yo zeke káa ndâ gàànà gi. Ndú ṛò njí lá, ndâ gálá bà kili i delè mì ndú wálá. Káa ta ndâ ŋa ŋìnò ꞌdáá gî, Mbíṛì kû ko ndú! Káa yo a ndâ kpóló-kpolo i co tí ndâ nuù gî. ");
INSERT INTO ndz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Káa ta ndâ kpùṛù-kpùṛù-zò-wúṛàngú mì yo nò, a ꞌbí ꞌdi gbí òkò tí yo ká bà uu go sáṛo cû ndii bà uu yí náa Mbíṛì cu ji yí nó gî? ");
INSERT INTO ndz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wotí bà bàkà ŋa làmbu ŋìnò lê má tí yo wálá, njembí yo kû mù gítí sè ndâ ꞌbí i tacó yè? ");
INSERT INTO ndz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Yo zeke káa ndâ ꞌvì ndâ làngá gi. ꞌBì tí ndú tacó bà te ŋa banga tí nò mítí ndú ta kpéétí ndú wálá, káa ye kû ꞌdè có ji yo ta yúcó máa, à kpêtí káa Sólómònì tí gbolò gba dígísèé náa àá mì wó a ndâ kpo-kpò i, yí jé yuu ꞌbí ŋa bòngo ta banga tí  mbe ndii ndâ ꞌvì ndâ làngá gî, nò lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Káa Mbíṛì má te ŋa banga tí nò mítí ndâ mbílì gbí jìlì, náa ndú wúnó kuu, káa à taàbé kû doo ndú ta wu, wotí bà je bòngo ji yo bà kpò yí gî? Yo me ndâ ꞌduù mbe kû tee njembí yo mítí Mbíṛì kácá-kácá lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","À má énò, yo tee njembí yo gáꞌdáá mítí có bà zò i, ta bà njù pe, lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tacó a ndâ ꞌduù tí nò mbe ŋò cèe kpokèjì bà bàkà i ji Mbíṛì ni lá muu to tí nó nó ká kû si njembí ndú ká gítí bà koṛo có gítí ndâ i tí nò, káa Bu yo ŋò ŋa i tí nó mbe ꞌvii ta yo nó ni gî. ");
INSERT INTO ndz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yo si njembí yo gítí bà koṛo có á gítí có bà dù Mbíṛì tí gba, wàa a yí tí Mbíṛì ká bà je ndâ i tí nò ji yo. ");
INSERT INTO ndz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Yo cì gúku lá, ndâ rómbo mì ye, muu yo me mbè lá, káa tàkòcò Bu yo tí gba peteke gítí bà je ꞌbá mì wó ji yo gî. ");
INSERT INTO ndz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yo sì ndâ i mì yo ꞌdáá gí ꞌdè, wàa yo ꞌví kaa i gbí ndú ꞌví konì ta ndâ mbe yê. Yo cu ŋa kúúkpá ŋìnó jé mbe yaka lá nó, wàa yo ꞌví kpolo tí ndâ i mì yo mí gbí ndú á mí gbíṛì, tí bàndò tí nó náa muu ndú bà ba tí  wálá nô. Tacó ndâ mbe ngbà bà di kà wálá, ndâ sû delè kà wálá. ");
INSERT INTO ndz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tacó njembí ꞌduù ta o ꞌdáá gî kû dù ká kácáá tí bàndò tí nó ta ndâ i mì wó tí  nô. ");
INSERT INTO ndz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Yo ṛò tíyò kpècè, wàa yo ꞌví dù léngé-lenge kû ù ta ndi ŋa i ŋìnó bà gì nô. Yo si wu ꞌví mee ꞌdo nje kùpò mì yo lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yo ꞌviindi tí yo, go bà ꞌviindi tí ndâ bòò mbe kû ù bà gì mbe tí ndú ꞌdo bàndò bà ko niì, tacó wàa à káa póó bà ꞌdi wo tí wó kítíkí, ndâ yì ꞌví njaanga njekèjì ji yí. ");
INSERT INTO ndz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ndâ bòò tí nó mbe dù tí zòꞌo yee tí o bà gì mbe tí ndú nó bà dù a ndâ mbe tó pá. Ye kû ꞌdè có ji yo ta yúcó máa, mbe tí ndâ bòò tí nò bà ki ndú mí to, bìndi  yí giì kaa i-zó-zò ta ꞌbì wó mí kùṛo ndú. ");
INSERT INTO ndz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ndâ bòò tí nò, náa mbe tí ndú má gì ta kpo-gbíꞌo, bìndi  yí giì ꞌde ndú tí zòꞌo nò bà dù a ndâ mbe tó pá. ");
INSERT INTO ndz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yo koṛo muu yo máa, mbe ꞌbá má ŋò o bà gì mbe ngbà gî, yí bà si mbe ngbà tí nò ꞌví ṛì gí tàꞌi mì wó ngé gî wálá. ");
INSERT INTO ndz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","À má énò, yo ꞌviindi tí yo, tacó yo bà ŋò o bà gì ꞌViì-mì-ꞌDakò ni wálá, yí ba gbaaka yo gbááká-gbaaka.» ");
INSERT INTO ndz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pìyétòrò bà-i-nò giì ꞌvee Jézù máa, «Wò kû lòkòꞌbò có tí nò a i ji ze tí ndâ mbe tala có mì lo cuki wèè, wò kû nì a ndâ ꞌduù ꞌdáá gî, Mbe nìbà i?» ");
INSERT INTO ndz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Káa Mbe tí ndoo giì ꞌvee Pìyétòrò, máa, «Tó bòò mbe kû bàkà nèté ta njembí wó gbaànjé, tí mbe ꞌdi gbí-o náa mbe tí wó si yí tí mbe kpolo tí ndâ i-ꞌbá mì wó ꞌdáá gî, wàa yí ꞌví kû njèè i-zó-zò ji ndâ ꞌbí ka wó ta o bà zò i si yí muu nó, a ꞌdi? ");
INSERT INTO ndz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bòò tí nò bà dù a mbe tó pá náa mbe tí wó má gì ꞌdo muu nó gí ꞌbá káa yí giì ꞌde yí kû bàkà nèté mì wó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ye kû ꞌdè có ji yo ta yúcó máa, mbe ꞌbá bà bàkà bòò tí nò tí mbe kpolo tí ndâ i-ꞌbá mì wó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Káa bòò tí nò má a ꞌbí ŋa ꞌduù mbe koṛo có máa, mbe ꞌbá kèjì gálà wálá, bìndi  yí giì ꞌbìtà a bà zò i, ta bà njù pe ꞌbàà, kû mèèkè ta i tí ndâ ꞌbí ka wó bòò ŋìnó náa mbe tí ndú si yí máa, yí kpolo tí ndú nó, ");
INSERT INTO ndz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ta ṛi tí nó náa mbe tí ndú bà dele gì gí bà gbaaka yí si yí kû bàkà ŋa i tí nò nó, yí bà waa có mítí wó, bìndi  yí giì mò yí gí mì ndâ bòò tí nó tí ndâ mbe ngbútù mbe ꞌdi có lá nô. ");
INSERT INTO ndz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Káa bòò ŋìnó mbe ŋò có tí nó gbí muu mbe tí wó nó ni gî, káa yí giì ꞌviindi tí wó kùṛo bà gì mbe tí wó gí ꞌbá lá, yí delè giì bàkà go có tí nò lá nó, bà ŋò mítí kû wó. ");
INSERT INTO ndz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Káa bòò ŋìnó mbe ŋò có tí nó gbí muu mbe tí wó nó lá, káa yí giì bàkà i ŋìnó mbe ꞌvii tí i náa à ꞌví gbì yí gítí  gbí-gbì nó, bà ꞌde làmbu bà gbì tí gî. À má je i ji ꞌduù túkàꞌi, à delè kû koṛo có máa, yí bà ko mboo i tí nò túkàꞌi. ");
INSERT INTO ndz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Ye gì tacó bà doo to tí nó ta wu, ye kùtàá má doo gî, njembí ye ꞌdèè gî! ");
INSERT INTO ndz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ye kèjì gí bà kònò séꞌi. ꞌDóó ye má kònò bà séꞌi tí nò cee ꞌdo muu ye lá, njembí ye gí bà ꞌdèè wálá. ");
INSERT INTO ndz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","«Yo kû koṛo có máa, ye gì a i tacó bà ꞌviindi gbí òkò tí ndâ ꞌduù á muu to tí nó? Ŋìnò me ndeṛè bà gì ye gí muu to tí nó ká nò lá. Ye gì a i tacó bà volo gbí òkò tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ꞌDo tí kpónó kû ya gí kùṛo, muu ndâ ꞌduù má ṛùkàtiì vô, ndú bà njèè gbí òkò tí ndú gî. Có mì ndâ ꞌbí ꞌduù taꞌô bà ya ta có mì ndâ ꞌbí ꞌduù ŋìnó sósòꞌô nó wálá. Có mì ndâ ꞌduù ŋìnó sósòꞌô nó delè bà ya gí gbí có mì ndâ ka ndú taꞌô nó wálá. ");
INSERT INTO ndz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ndâ bu ndâ ꞌviì-ꞌdakò bà loko mítí ndâ ꞌviì mì ndú ta vò i; ndâ ꞌviì-ꞌdakò delè bà loko ká mítí ndâ bu ndú. Ndâ nawu ndâ ꞌvinî bà volo mítí ndâ nájú ndú; ndâ ꞌvinî delè bà volo mítí ndâ nawu ndú ta vò i. Ndâ nawu ndâ ꞌviì-ꞌdakò bà volo mítí ndâ nawù ndâ ꞌviì mì ndú; ndâ nawù ndâ ꞌviì delè bà volo mítí ndâ gù ndú, nawu ndâ ꞌdakò mì ndú.» ");
INSERT INTO ndz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jézù giì ꞌdè có ji ndâ ꞌduù tí nò mbe tì bìnjìì nò, máa, «Yo tí ndâ Jùdéyà má ŋò mù kû te mò gí tàbú, yo kû ꞌdè có máa, mù tí nó bà bè bà nì wálá, káa à kû bàkà tí go ngo nje yo nò. ");
INSERT INTO ndz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yo má ŋò pípìṛi kû pì ꞌdo gbíꞌdè, yo kû ꞌdè có máa, gó ṛi bà dù ta ṛi tí nò ngé ndii gî. Káa có mì yo nò delè có to lá. ");
INSERT INTO ndz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yo ŋò ŋa i tí nó á kèjì nó ni ꞌdo tí bà zeke cè kózò tí tàṛì, ta cè kózò tí to gî, káa yo ŋò ŋa i tí nó mbe kû bàkà tí kpónó nó ni lá, tacó yè, ndí yo ndâ mbe tiṛì? ");
INSERT INTO ndz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Yo koṛo muu yo wàa yo ꞌví bàkà i ŋìnó jáá nó lá tacó yè? ");
INSERT INTO ndz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Có má gbí òkò tí yo ta ꞌduù, káa wò ŋò ni tí vò i gî, bàkà wotí gítí bà mee wu ꞌdo tí có tí nò gbí òkò tí yo ta yí nò kùṛo bà ya ta wò mì wó gí gbí ngbàngà. Tacó yí má yee ta wò á kùṛo ndâ gba gî, ndú bà je wò ji ndâ mbe kpolo tí zàà, máa, ndú nè wò mí tàꞌi. ");
INSERT INTO ndz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ye kû ꞌdè có ji yo ta yúcó máa, wò bà dù gbí zàà yee tí o tí nó náa wò sì có tí nò cee ꞌdo muu lo gî.» ");
INSERT INTO ndz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ta o tí nò, ndâ ꞌbí ꞌduù giì ꞌdè có ji Jézù gítí bà ziki ndâ ꞌbí ꞌdakò tí ndâ Jùdéyà mbe ꞌdo Gàlìléyà mì Pìlátò si ndú kû waa mbelè ji Mbíṛì á Jèrùzàlémè, bìndi  mbelè ndâ ꞌduù tí nò náa Pìlátò ziki ndú nò giì ŋònòkò tí ta mbelè ndâ nò náa ndú ci ji Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Káa Jézù giì ꞌvee ndâ ꞌduù tí nò máa, «Yo koṛo có máa, Pìlátò ziki ndâ ꞌdakò tí nò tacó vò i mì ndú me gbolò ndii ndâ vò i mì ndâ sè ndâ ꞌduù Gàlìléyà ꞌdáá gî, gî? ");
INSERT INTO ndz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","À me énò lá. Káa ye kû ꞌdè có ji yo máa, yo má ꞌvìsì muu yo ꞌdo tí ndâ vò i mì yo lá, yo ꞌdáá gî bà mìì gî. ");
INSERT INTO ndz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Káa ndâ ꞌdakò tí nó muuꞌbì-nje vô nje-vô taꞌô náa njà su-sú ꞌbá mìì ndú Sìlòwámù gbí gbata Jèrùzàlémè nó, yo koṛo có máa, ndâ ꞌbí ꞌduù ta vò i mì ndú mbe me gbolò kùṛo Mbíṛì ndii ndú á gbí gbata Jèrùzàlémè wálá? ");
INSERT INTO ndz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","À me énò lá! Káa yo má ꞌvìsì muu yo ꞌdo tí ndâ vò i mì yo lá, yo bà mìì go bà mìì ndú nò ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jézù giì lòkòꞌbò có ji ndú máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò ta mû-mbiìgá gbí njí mì wó giì ya gí bà pà yú mbiìgá gbí mû tí nò, káa yí giì ꞌdè gbèe ṛi mbiìgá gbí mû lá. ");
INSERT INTO ndz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yí bà-i-nò giì ꞌdè có ji mbe kû bàkà nèté gbí njí mì wó ta kpo-tàkòcò, máa, ‹Ŋò káa ŋa i tí nò gi. Ŋìnó kpónó a bà taꞌô ndoò tí bà nò ye gí bà pà yú mbiìgá ꞌdo gbí mû tí nò, káa ye jé ꞌde gbèe i lá. À má énò, da mû tí nò gí to. Gbí ndeṛè bà gèè bè mì wó tii ta to gbí njí sínò wálá.› ");
INSERT INTO ndz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Káa mbe kû bàkà nèté gbí njí mì ꞌdakò tí nò giì ꞌvìsì có ji yí máa, ‹Si njíꞌdí kózò gi, kpo ꞌduù. Ye bà kili zì to mí ṛèngbó wó, wàa, ndà ꞌví zeke ta ndoò gbaànjé má kózò gi. ");
INSERT INTO ndz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yí má ṛì gbí ndoò tí nó kèjì nó gî, à nìkì ma. Káa yí má ṛì lá, à ꞌví da yí gí to go có mì lo nò.› » ");
INSERT INTO ndz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jézù ta o tí nò kû nìbà i ji ndâ ꞌduù á tí ꞌbí bàndò bà kili ndâ ꞌduù gí bà ùlù Mbíṛì, ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta o tí nò, ꞌbí niì ta i-gbí-muu wò kuu gbí òkò tí ndâ ꞌduù tí nò mbe kili mí bàndò bà ùlù Mbíṛì nò. I tí nò ŋonoko niì tí nò ta ndoò muuꞌbì-nje vô nje-vô taꞌô. Yí giì bàkà ósú mítí niì tí nò, tí ŋa ŋìnó náa niì tí nò kû giì nò nó ká ꞌbùṛà-ꞌbùṛà énô. ");
INSERT INTO ndz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jézù mâ giì ŋò niì tí nò, yí giì tèꞌé tí wó, bìndi  yí giì ꞌdè có ji yí máa, «Nòꞌo mì lo cee gî, niì!» ");
INSERT INTO ndz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jézù giì tee ꞌbí wó mítí niì tí nò, bìndi  ndòpí niì tí nò giì yaꞌva tí jáá gî. Bìndi  niì tí nò giì ꞌbìtà bà ùlù Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ꞌBí gbolò ꞌduù tí kùṛo ndâ mbe kû kili mí bàndò bà ùlù Mbíṛì mâ giì ŋò bà ꞌvala niì tí nò mì Jézù ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà, yí giì ꞌdè có ji ndâ ꞌduù ta kpo-tàkòcò máa, «À kuu tí  mì ndoo a ndâ sili vô-nje gbaànjé, tí ndâ sili bà bàkà nèté. Nòꞌo má tí ꞌduù, yí ꞌví gì gí bà pà yeè á gbí òkò ndâ sili tí nò, me ta ṛi bà wotí gbí tàkìì lá!» ");
INSERT INTO ndz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Káa Mbe tí ndoo giì ꞌvìsì có ji ꞌdakò tí nò máa, «Ndí yo ndâ mbe tiṛì! A ꞌdi gbí òkò tí yo nò jé ká njaanga wú tí ndâ i-kó-ko mì wó, bìndi  yí giì gbà ndú ya tí  gí bà njù ngo ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà lá? ");
INSERT INTO ndz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","À má énò, ye ꞌví njaanga miṛi niì tí nó tí nájú Àbìráámò nó ꞌdo ꞌbì vò i tí nó mbe kò yí ta ndoò muuꞌbì-nje vô nje-vô taꞌô nó lá wàà?» ");
INSERT INTO ndz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Có tí nò náa Jézù ꞌvìsì ji ꞌdakò tí nò nò giì te a nô mí ṛo ndâ mbe kû sogo yí tí Jézù. Káa líkíꞌo ndâ kpo-kpò i tí nò náa yí bàkà nò ká giì dù tí sè ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ta o tí nò, Jézù giì ꞌvee ndâ ꞌduù máa, «Bà dù Mbíṛì tí gba mì ndâ ꞌduù go ŋa yè? Ye ꞌví ꞌvii mítí ŋa yè ji yo? ");
INSERT INTO ndz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","À go njì ndí náa ꞌduù ṛò mí gbí njí mì wó. Njì ndí tí nò giì kù tí gbolò mû náa ndâ nuù kû gèè ꞌbá mì gbí bè wó.» ");
INSERT INTO ndz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jézù giì ꞌvee ndâ ꞌduù kákáꞌi máa, «Ye kpónó ꞌví ꞌvii ngú ŋa kèjì bà bàkà nambeè mì Mbíṛì ta ndâ ꞌduù ji yo mítí ŋa yè? ");
INSERT INTO ndz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","À go njú ṛúꞌbù, náa niì kû soo mítí kpàtà pe njíꞌdí-njíꞌdí kpòò yee tí o bà nì kpàtà pe tí nò.» ");
INSERT INTO ndz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jézù giì njè nó kû ya gí Jèrùzàlémè ta bà nò ta bà gala ndâ ꞌduù ta ndi gbí ndâ gbata, ta ndâ to tí kpokèjì ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Káa ꞌbí ꞌduù giì ꞌvee yí máa, «Muu ndâ mbe ꞌde ꞌválá bà me mbè wálá, kpo ꞌduù?» Káa Jézù giì ꞌvìsì có gí tàkò ꞌvé mì ꞌduù tí nò ji ndâ ꞌduù, máa, ");
INSERT INTO ndz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Yo kili ndòngbú wotí mì yo, wàa, yo ꞌví ṛì gí tàꞌi co a i tí ṛúú njekèjì. Ye kû ꞌdè có ji yo máa, ndâ ꞌduù me mbè bà jòò tí ndú tacó bà ṛì gí tàꞌi, káa ndú gí bà ṛì wálá. ");
INSERT INTO ndz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mbe ꞌbá má giì a gí yaà, bìndi  yí giì kisi njekèjì gî, yo bà dù á sè kû gbà njekèjì ta bà tèꞌé tí wó, máa, ‹Njaanga njekèjì ji ze, kpo ꞌduù!› «Káa yí bà ꞌvìsì có ji yo máa, ‹Ye ŋò bàndò tí nó náa yo gì ꞌdo tí  nó ni lá!› ");
INSERT INTO ndz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","«Káa yo bà-i-nò bà dù a i sè kû ꞌvìsì có ji yí máa, ‹Ndoo táánò zò i ta ndoo gbí gbèe káꞌi gî. Ndoo delè njù ngo ta ndoo gbí gbèe káṛà ngo gî. Wò delè táánò nò ta bà nìbà i ji ndâ ꞌduù gbí gbata mì ze gî, kpo ꞌduù!› ");
INSERT INTO ndz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«Káa yí bà ꞌvìsì có ji yo kákáꞌi, máa, ‹Ye ŋò bàndò tí nó náa yo gì ꞌdo tí  nó ni lá. Yo ya ꞌdáá ꞌdo tí ye gí kàzô, ndí yo ndâ vò ꞌduù!› ");
INSERT INTO ndz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Bìndi  yo bà dù a i sè kû wa gbí ta bà ꞌvìì tì yo ta séꞌi, kû zeke ta ndâ Àbìráámò, ta Ìzákò, ta Jàkóbè, ta ndâ ꞌbí mbe ꞌdòkò có mì Mbíṛì ꞌdáá gî gí tàꞌi mì Mbíṛì, káa à ꞌvaka yo gí sè gî! ");
INSERT INTO ndz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta o tí nò, ndâ ꞌduù bà gì ꞌdo cee muu to ꞌdáá gî gí bà zò i ta líkíꞌo tí ndú ꞌbá mì Mbíṛì! ");
INSERT INTO ndz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ta o tí nò, ndâ ꞌduù ŋìnó náa ndâ ꞌduù muu to tí nó kpónó si ndú tí i lá nó, bà dù tí ndâ ꞌduù ŋìnó náa à kû te duù mítí ndú me gbolò; bìndi  ndâ ꞌduù ŋìnó náa ndâ ꞌduù muu to tí nó kpónó kû te duù á mítí ndú nó, bà dù tí ndâ ꞌduù ŋìnó ta i gbí ndú kpokoo wálá nô.» ");
INSERT INTO ndz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mâ giì zekeꞌo, ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà giì gì gí mì Jézù, bìndi  ndú giì ꞌdè có ji yí, máa, «Njè nó ꞌdo bà-i-nó gî, tacó Èródè tí gbolò gba kû po tiṛì có bà zi wò.» ");
INSERT INTO ndz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo dele ndi yo ya gí bà ꞌdè có ji ngàmbé tí nò, máa, ye kû mòkò ndâ i ꞌdo gbí muu ndâ ꞌduù, ye delè kû ꞌvala ndâ mbe nòꞌo, gbí ṛi tí nó wúnó, ta taàbé, ye bà cee ta nèté mì ye a i takàcó. ");
INSERT INTO ndz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kpêtí ká énò, ye bà dù a i muu nó wúnó, ta taàbé, ta takàcó, tacó bà zi mbe ꞌdòkò có mì Mbíṛì mí sè ꞌdo gbí gbata Jèrùzàlémè me dú lá. ");
INSERT INTO ndz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Ákoo ndâ ꞌduù Jèrùzàlémè! Ndâ ꞌduù Jèrùzàlémè! Yo kû ziki ndâ mbe ꞌdòkò có mì Mbíṛì! Yo kû ꞌvaka ndâ ꞌduù tí nó náa Mbíṛì tuu ndú ji yo nó ta díí! Ye jè ta bà kili yo mí njembí ye go bà kili ndâ ꞌviì mì na ngùù mí tà mbíṛì wó nó ta bà  me mbè, káa yo kpò ye gî! ");
INSERT INTO ndz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ꞌBá mì yo bà jìꞌvì mòòkò. Ye kû ci nó a yo máa, yo bà ŋò ye kákáꞌi wálá, yee tí o tí nó náa yo ꞌdè có ta nje yo máa, ‹Mbíṛì ꞌví si ꞌduù tí nó mbe gí ta ṛè wó tí Mbíṛì,› nó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ta ꞌbí ṛi bà wotí gbaànjé, Jézù giì ya gí bà zò i á ꞌbá mì ꞌbí gbolò mbe kpolo tí tàkìì mì ndâ Jùdéyà. Yí mâ giì yee kà, ndâ ꞌduù ꞌdáá gî giì dù kû je mbí ndú kpolo ma ká gítí wó. ");
INSERT INTO ndz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mâ giì zekeꞌo, ꞌbí ꞌdakò ta ndâ ꞌbì wó ta kò wó oko ꞌdáá gî giì ja tí wó gì gí mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jézù mâ giì ŋò yê ṛo ꞌdakò tí nò, yí giì ꞌvee ndâ mbe ꞌdi gbí tàkìì, ta ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, máa, «Bà ꞌvala ꞌduù ta ṛi bà wotí gbí tàkìì mì ndoo tí ndâ Jùdéyà dú? À má me dú lá, yo ꞌdè ji ye.» ");
INSERT INTO ndz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Káa ndú giì biya bà ꞌvìsì có ji Jézù gî. Tacó énò, Jézù giì zèè ꞌbì ꞌdakò tí nò, bìndi  yí giì ꞌvala yí gî, bìndi  yí giì ꞌdè có ji yí máa, yí ya gî. ");
INSERT INTO ndz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jézù mâ giì je nó ji ꞌdakò tí nò gî, yí giì ꞌvee ndâ mbe ꞌdi gbí tàkìì, ta ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, máa, «ꞌViì mì ꞌbí ꞌduù ꞌdo gbí òkò tí yo nò, delè ꞌbí i-kó-ko mì wó, má ꞌva tí gbí guu ta ṛi bà wotí gbí tàkìì mì ndoo tí ndâ Jùdéyà, yí bà ja yí gí sè wálá?» ");
INSERT INTO ndz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bà ꞌvìsì có ji Jézù kákáꞌi giì kpò ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jézù mâ giì ŋò ŋa bà jòò tí ndâ ꞌbí ka wó wiṛi tacó bà ki tí ndú tí ndâ bàndò mì ndâ kpo-kpò ꞌduù gí bà zò i, yí giì lòkòꞌbò có ji ndú máa, ");
INSERT INTO ndz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«ꞌDuù má tèꞌé tí lo gí bà zò i á bàndò bà kò niì, si bà có ká ngé ya gí bà ki tí lo tí bàndò mì ndâ kpo-kpò ꞌduù ta muu lo mí to. Tacó ndâ-ꞌbî-lá mbe ꞌbá tèꞌé tí ndâ ꞌbí kpo-kpò ꞌduù mbe ndii wó gî, gî. ");
INSERT INTO ndz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bìndi  mbe ꞌbá bà gì gí bà ꞌdè có ji wò máa, ‹Si bàndò tí nó ji kpo ꞌduù tí nô.› Bà a wò ꞌdo bà-i-nò kû ya gítí bàndò mì ndâ lúkúfà ꞌduù bà me a duù ta nô. ");
INSERT INTO ndz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","À má énò, à má tèꞌé tí lo gí bà i, ya gí bà ki tí lo tí bàndò mì ndâ lúkúfà ꞌduù. Mbe ꞌbá má ŋò máa, bàndò tí nò ꞌvii ta wò lá, a yí ká bà gì gí bà ꞌdè có ji wò máa, ‹A gí yaà, wàa wò ꞌví ya gí bàndò mì ndâ ka lo kpo ꞌduù kà zô, kómbe ye.› Tù lo ndì bà giì uu ta o bà a wò gí yaà kû ya gítí bàndò mì ndâ kpo ꞌduù, tacó a te duù mítí lo mí kùṛo ndâ ꞌduù tí nó ꞌdáá náa yo kû ki tí yo to ta ndú nó gî. ");
INSERT INTO ndz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tacó ꞌduù má kû si tí wó tí i ta kpéétí wó, ndâ ꞌduù bà si yí tí i wálá. Káa ꞌduù mbe si tí wó tí i lá, ndâ ꞌduù bà te duù mì tí wó.» ");
INSERT INTO ndz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bìndi  yí giì ꞌdè có ji mbe ꞌbá tí nó náa ndú kû zò i á ꞌbá mì wó nó, máa, «I-zó-zò má ꞌbá mì lo, kili me káa ndâ kómbe lo, ta ndâ náꞌvindí lo, ta ndâ nambe lo, ta ndâ ka ꞌbá mì lo ŋìnó náa àá mì ndú a i nó, tacó wàa ndú taàbé ꞌví tè ta é tí lo gítí ŋìndi ndú nò lá. ");
INSERT INTO ndz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bàkà i-zó-zò, wàa wò ꞌví kili ndâ mbe yê, ta ndâ ꞌduù ŋìnó mbe kû ìṛì ta to, ta ndâ mbe ku kò, ta ndâ mbe sú ṛo, gítí . ");
INSERT INTO ndz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bìndi  Mbíṛì bà bàkà nambeè ji wò, tacó wotí bà ko mboo i-zó-zò mì lo nò ji wò tí ndâ ꞌduù tí nò wálá. Mbíṛì bà ko mboo i-zó-zò mì lo nò ji wò ta o bà ꞌvala ndi ndâ mbe bàkà go có mì wó ꞌdo gbí muuꞌdú ndú.» ");
INSERT INTO ndz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ꞌBí ꞌdakò ꞌdo gbí òkò tí ndâ ꞌduù tí nò mbe kû zò i ta ndâ Jézù nó mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, yí giì ꞌvìsì có ji Jézù máa, «Ndâ mbe zò i ꞌbá mì Mbíṛì wúnò bà dù a ndâ mbe tó pá.» ");
INSERT INTO ndz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò giì ci o ji ndâ ꞌduù me mbè máa, ndú ya gí bà zò i ꞌbá mì yì. ");
INSERT INTO ndz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","O bà zò i tí nò náa yí ci nò mâ giì me tí gî, yí giì bàkà i-zó-zò me gbolò, bìndi  yí giì tuu bòò mì wó, máa, yí ya gí bà ꞌdè có ji ndâ ꞌduù tí nò náa yí ma có i-zó-zò ji ndú nò, máa, à bàkà i-zó-zò cee gî. ");
INSERT INTO ndz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Bòò mì wó mâ giì ya gí bà ꞌdè có tí nò ji ndâ ꞌduù, ndâ ꞌduù ꞌdáá gî giì ŋònòkò tí ndú ꞌdo tí bà ya gí bà zò i gî. Kpédélé ꞌduù tí nó náa bòò tí nò ꞌde yí nó loko gbí ꞌbá wó, máa, ‹Nó kpónó kuu kò ye. Ye kû ya gí bà gala ꞌbí ŋa ngú njí náa ye sì á kàzô. Ya gí bà ꞌdè có ji mbe tí lo, máa, ye biya bà gì gí tà é mì wó me bíyá-biya lá.› ");
INSERT INTO ndz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","«Bà só ꞌduù tí nó náa yí ꞌde yí nó giì ꞌdè tiṛì ji yí máa, ‹Kpokèjì bà ya ye ngé gî wálá, tacó ye kpónó kû ya gí bà ŋò nèté mì ndâ ꞌbí ngú mòꞌdú náa ye sì tacó bà ji njí kàzô. Delè ndi lo ya gí bà ꞌdè có ji mbe tí lo, máa, gùù tè káṛà di lá.› ");
INSERT INTO ndz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","«Bà taꞌô ꞌduù giì ci yí ta tiṛì, máa, ‹Ŋìnò kpónó a bà ko niì mì ye gì tí  gí ꞌbá ká nô. À da ꞌbò mítí kò ye gî.› ");
INSERT INTO ndz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Bòò tí nò giì dele ya gí ꞌbá, bìndi  yí giì ꞌvanda ndi kòcò ndâ ꞌduù tí nò ꞌdáá gî ji mbe tí wó. Mbe tí wó bà-i-nò giì ꞌvìsì có ji yí ta kpo-tàkòcò, máa, ‹Goonó ya ta ndi tí ndâ kpokèjì gbí gbata, wò má ꞌde ndâ mbe yê, ta ndâ mbe sú ṛo, ta ndâ mbe ku kò, ta ndâ ꞌduù ŋìnó mbe kiꞌviki mì to gî nó, wò ꞌví gì ta ndú.› ");
INSERT INTO ndz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Bòò tí nò giì ma ndâ ŋa ndâ ꞌduù tí nò náa mbe tí wó ꞌdeke ji yí nò, káa ndú yè tàꞌi bà zò i lá. Tacó énò, yí giì ꞌdè có ji mbe tí wó máa, ‹Ye ma ndâ ꞌduù go có mì lo nò gî, káa ndú giì yè tàꞌi bà zò i lá, bu ye.› ");
INSERT INTO ndz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Káa mbe tí wó giì ꞌvìsì có ji yí máa, ‹Ya ta ndi tí ndâ kpokèjì á sè ꞌdo gbí gbata, wàa wò ꞌví ma ndâ ꞌduù yee tí o tí nó náa tàꞌi bà zò i yè ta ndâ ꞌduù gî.› ");
INSERT INTO ndz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bòò tí nò mâ giì kili ndâ ꞌduù yè tàꞌi bà zò i go kòcò mbe tí wó nò gî, mbe ꞌbá giì ꞌdè có ji ndâ ꞌduù tí nò, máa, ‹Ye kû ꞌdè có ji yo máa, ndâ ꞌduù tí nó náa ye tèꞌé tí ndú káa ndú biya bà gì gí nó, bà tala i-zó-zò mì ye nó wálá.› » ");
INSERT INTO ndz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndâ ꞌduù me mbè giì kaa kû ko tàkò Jézù. Yí bà-i-nò giì ꞌvìsì tí wó gí ndiì, bìndi  yí giì ꞌdè có ji ndú, máa, ");
INSERT INTO ndz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ꞌDuù má gì gí mì ye, káa njembí wó ká kácáá tí ndâ bu wó, ta nawu wó, ta niì mì wó, ta ndâ ꞌviì mì wó, ta ndâ náꞌvindí wó, ta ndâ námì wó, ta miṛi wó, ꞌduù tí nò bà dù tí mbe tala có mì ye wálá. ");
INSERT INTO ndz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ꞌDuù má te ꞌdóó njèèkpè mû mì wó, wàa yí ꞌví gì tí  gí tàkò ye lá, ꞌduù tí nò bà dù tí mbe tala có mì ye wálá. ");
INSERT INTO ndz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Tacó ꞌbí ꞌduù ꞌdo gbí òkò tí yo kpónó má kû bàkà có bà gèè ꞌbá, kpédélé có gbí muu wó bà dù me bà koṛo có gítí bàndò bà ꞌde ndâ i-nèté gítí bà cee ta ꞌbá tí nò lá? ");
INSERT INTO ndz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","À má énò lá, yí má duu káa ndâ kpalà mí tà to gî, káa bà cee sè nèté gítí ꞌbá giì kpò yí gî, ndâ ꞌduù bà ŋo yí, ");
INSERT INTO ndz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","máa, bà gèè ꞌbá kpò yí gî. ");
INSERT INTO ndz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«À delè a gba ngàyi jé ká kû ya gí bà tè ꞌbí ka wó gba ta gó, náa yí má ŋò ni gî máa, wotí gó mì ka wó nò ndii yí gî? ");
INSERT INTO ndz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yí má ŋò ni énò gî, yí bà tuu tú ꞌdo ká tí ꞌdú, máa, ndâ yì ꞌdè có tí nò gbí òkò tí ndâ yì ta yí nò ꞌdé-ꞌdè. ");
INSERT INTO ndz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","À má énò, ꞌbí ꞌduù gbí òkò tí yo mbe biya ndâ i mì wó ꞌdáá gî lá, bà dù tí mbe tala có mì ye wálá. ");
INSERT INTO ndz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Gó zi má kû gbí mbí zi, yí a tó i. Káa bà gó ngo zi tí nò má cì cee gî, kèjì bà dele ta gó zi gí gbí tè zi tí nò kákáꞌi wálá. ");
INSERT INTO ndz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tè zi me i mbe zii to tacó ba ṛò i lá. Ndâ ꞌduù kû te tè zi yee ká tí vò i gí ꞌdè. À má énò, ꞌduù ŋìnó ta tù bà ꞌdi có tí muu wó nó ꞌví ꞌdi có.» ");
INSERT INTO ndz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ta o tí nò, ndâ mbe kû kili i-mírì me mbè, ta ndâ ꞌbí vo-vò Jùdéyà giì kaa ya kû ꞌdi ndâ có mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ndâ mbe kpolo tí tàkìì, ta ndâ mbe nìbà tàkìì mì ndâ Jùdéyà mâ giì ŋò énò, ndú giì ꞌbìtà bà ꞌdè víí có ta kòlòwò, máa, «ꞌDakò tí nò kû ŋònòkò tí wó ta ndâ ꞌduù ŋìnó náa à mò ndú ꞌdo gbí tàkìì mì ndâ Jùdéyà gî nô. Ndú delè kû zò i ta ndú gbí gbèe káꞌi!» ");
INSERT INTO ndz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jézù mâ giì ꞌdi có mì ndú nò, yí giì lòkòꞌbò có ji ndú, máa, ");
INSERT INTO ndz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ꞌBí ꞌduù ꞌdo gbí òkò tí yo nò kpónó má kû gbà ndâ rómbo mì wó ziꞌduù-vô, káa ꞌbí  gbaànjé giì giṛi gî, yí bà jee sè mbè ndâ ŋìnó kû zò i nó mí to, bìndi  yí ꞌví ya gí bà pà bà tí gbèe ŋìnó mbe giṛi gî nó, yee tí o tí nó náa yí ꞌde yí gî nó wálá? ");
INSERT INTO ndz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yí má ꞌde yí gî, yí bà te yí mí pààpì wó ta líkíꞌo kû ya tí  gí ꞌbá. ");
INSERT INTO ndz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ta o bà ye ta yí ꞌbá, yí bà kili ndâ kómbe wó, máa, ‹Yo gì , wàa ndoo ꞌví zò i ta líkíꞌo, tacó ꞌbí rómbo mì ye kùtàá giṛi gî, káa ye giì ꞌdè yí gî!› ");
INSERT INTO ndz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ye kû ꞌdè có ji yo máa, ŋìnò a gbèe ŋa i tí nó mbe kû bàkà tí á gbíṛì nó ká nò. Gbèe mbe bàkà vò i muu to tí nó má ꞌvìsì muu wó ꞌdo tí ndâ vò i mì wó gítí kpokèjì mì Mbíṛì, líkíꞌo wó tí Mbíṛì á gbíṛì ndii líkíꞌo ndâ mbè ꞌduù tí nó cúú-cu-cù mbe kû co tí kpokèjì mì wó nó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jézù giì ꞌvee ndâ ꞌduù máa, «Ndâ njì gírísì muuꞌbì kpónó má mì niì, bìndi  ꞌbí  gbaànjé giì ꞌva tí to á ꞌdo tí wó ta bèbìlì, niì tí nó bà tù ngba wu, bìndi  yí giì pà ta tàꞌi léé gítí gbèe gírísì mì wó nò wálá? Káa à má me tí tí i bà kaa tàꞌi tí nò, niì tí nò bà je kùꞌò gítí gbí òkò ndâ káꞌi pétékèꞌi, yee tí o bà ꞌde gbèe gírísì tí nò wálá? ");
INSERT INTO ndz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yí má ꞌde gî, yí bà kili ndâ kómbe wó ta ndâ ka ꞌbá mì wó, bìndi  ndú bà da ꞌdì ta líkíꞌo. ");
INSERT INTO ndz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ye kû ꞌdè có ji yo máa, líkíꞌo kû bàkà ndâ basìlì mì Mbíṛì ta o tí nó náa ꞌbí mbe bàkà vò i gbaànjé má ꞌvìsì muu wó gítí kpokèjì mì Mbíṛì go énò.» ");
INSERT INTO ndz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jézù giì lòkòꞌbò ꞌbí có, máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò giì jò ndâ ꞌviì-ꞌdakò sósòꞌô. ");
INSERT INTO ndz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ndú mâ giì kpolo tè tí ndâ ꞌdakò gî, ŋìnó tí ꞌviì nó giì ꞌdè có ji bu ndú ta ꞌbí ṛi gbaànjé, máa, ‹Je bà ndâ i mì ye á ꞌbá nó ji ye, bu ye.› Bu ndú bà-i-nò mâ giì njèè gbí ndâ i-ꞌbá ji ndú go i gbí tàkìì mì ndú gî, ");
INSERT INTO ndz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ꞌviì-ꞌdakò tí nò giì bàkà káa làmbu sili bìndi bà njèè gbí ndâ i mì ndú, bìndi  yí giì kaa bà ndâ i mì wó ꞌdáá gî, yí giì ya ꞌdo ꞌbá mì bu wó gí gbí ꞌdú to. Bìndi  yí giì volo gbí ndâ i tí nó vúṛù-vúṛù go i mì mbúṛù nô. ");
INSERT INTO ndz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","«Ngo mâ giì tè á bìndi ndâ i mì wó nò gî, go giì tè to tí nò náa yí ꞌdòkò ta ꞌbá ya gítí  nò tí ŋìndi ku. Káa gbèe i mì wó wálá. ");
INSERT INTO ndz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tacó énò, yí giì kpò tí wó mítí ꞌbí ꞌdakò tí ꞌduù gbí to tí nò. ꞌDakò tí nò giì bàkà yí tí mbe kû je i-zó-zò ji ndâ kàdùrúkù mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yí gbí ndâ o tí nò má ꞌde i-zó-zò mì ndâ kàdùrúkù, yí bà zò gî, káa a mbe je ji yí ká wálá. ");
INSERT INTO ndz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yí mâ giì koṛo có kpòò, muu wó giì gì gítí wó gî. Bìndi  yí giì ꞌdè có máa, ‹Ye kû cì ta go, káa yì ndâ mbe kû bàkà nèté ꞌbá mì bu ye kpónó gítí i-zó-zò wálá. ");
INSERT INTO ndz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","À má énò, ye bà dele ndi ye ya gí mì bu ye, wàa, ye ꞌví ꞌdè có ji yí máa, «Ye bàkà vò i gítí Mbíṛì gî, ye delè bàkà vò i gítí lo gî, bu ye! ");
INSERT INTO ndz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ye ꞌvii tí mbe dù tí ꞌviì mì lo kákáꞌi lá. Si ye ꞌví dù tí ꞌbí mbe bàkà nèté mì lo gbaànjé.» › ");
INSERT INTO ndz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","«ꞌViì-ꞌdakò tí nò bà-i-nò giì njè nó ya gí ꞌbá mì bu wó. Bu wó mâ giì ŋò yí ꞌdo me ꞌdú kèjì, yê ṛo wó giì bàkà yí gî. Yí bà-i-nò giì a ya gí bà kunduu yí, ta bà òlò gbí tù wó. ");
INSERT INTO ndz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Káa ꞌviì-ꞌdakò tí nò giì ꞌdè có ji bu wó, máa, ‹Ye bàkà vò i gítí Mbíṛì gî, ye delè giì bàkà vò i gítí lo gî, bu ye. Ye ꞌvii tí mbe dù tí ꞌviì mì lo lá.› ");
INSERT INTO ndz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«Káa bu wó bà-i-nò giì tèꞌé tí ndâ bòò mì wó, máa, ‹Yo gì ta banga bòngo ŋìnó ta ŋa  wálá nó, ta banga i-tí-sìlì-ꞌbì, ta tàmà.› Ndâ bòò tí nò mâ giì gì ta ndâ i tí nò gî, ꞌdakò tí nò giì zaa ꞌviì mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bìndi  yí giì ꞌdè có ji ndâ bòò mì wó, máa, ‹Yo ya gí bà gì ta ꞌbí ꞌviì-mòꞌdú ŋìnó ta banga dìì wó nó, wàa yo ꞌví bàkà ta i-zó-zò, wàa ndoo ꞌví zò i ta líkíꞌo. ");
INSERT INTO ndz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tacó ꞌviì mì ye nó táánò cì gî, káa yí kpónó ꞌvala ndi wó gî. Yí táánò giṛi gî, káa à kpónó ꞌde yí gî.› Ndâ bòò mì ꞌdakò tí nò mâ giì bàkà go có mì wó nó gî, ndú giì ꞌbìtà bà zò i ta líkíꞌo tí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Ta o tí nò náa ndú kû bàkà ta ndâ i tí nò nò, kpo ꞌviì-ꞌdakò mì ꞌdakò tí nò a i gbí njí. Yí mâ giì dooko gí ꞌbá yí giì ꞌdi kòcò ndâ ꞌduù kû cè cè, ta bà dù ṛu. ");
INSERT INTO ndz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yí bà-i-nò giì tèꞌé tí ꞌbí bòò mì bu wó gbaànjé, bìndi  yí giì ꞌvee yí, máa, ‹A yè ká bàkà tí ta bìndi ye ꞌbá tí nó?› ");
INSERT INTO ndz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","«Káa ꞌdakò tí nò giì ꞌvìsì có ji yí, máa, ‹A náꞌvindí lo ká dele ndi wó ꞌdo gbí to tí nó táánò náa yí ya gítí  nô. Káa bu lo giì zi ꞌviì-mòꞌdú tí nó táánò náa ndoo ko yí ta banga dìì wó nó tacó bà te ta wiṛi mítí wó, tacó yí dele ꞌdo kà ta vò i tí wó wálá.› ");
INSERT INTO ndz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Tàkòcò ꞌviì-ꞌdakò tí nò bà-i-nò giì kpolo ndii muu bà ya yí gí tàꞌi gî. Bu wó mâ giì ŋò énò, yí giì có gí sè, bìndi  yí giì ꞌdeke tí wó ji yí máa, yí ya gí tàꞌi. ");
INSERT INTO ndz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Káa ꞌviì-ꞌdakò tí nò giì ꞌvìsì có ji bu wó, máa, ‹Ŋò káa ŋa mbè ndoò tí nó náa ye kû bàkà nèté ji wò go bòò mì lo nó gi! Ye jé ta ꞌbí gbèe ṛi ndii muu ndâ có mì lo lá. Wò jé je ji ye a yè? À kpêtí káa vòó ṛókpô ꞌviì-bee sínò wò jé je ji ye, tacó wàa ze ꞌví ꞌdè ta líkí nje ta ndâ kómbe ye lá! ");
INSERT INTO ndz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Káa wò kpónó giì zì a ngbú ꞌviì-mòꞌdú ta i ká gbí wó ji ꞌviì mì lo mbe kaa ndâ i mì lo ya gí bà volo gbí ndú ji ndâ vo-vò niì ꞌdáá gî, bìndi  yí giì dele ndi wó.› ");
INSERT INTO ndz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Káa bu wó giì ꞌvìsì có ji yí, máa, ‹Ndà kû dù ta ndà ꞌbá ta o ꞌdáá gî. Ndâ i mì ye ꞌdáá gî a ndâ i mì lo, ꞌviì mì ye. ");
INSERT INTO ndz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ye te wiṛi mítí náꞌvindí lo ta pétékè tàkòcò ye ká dú, tacó yí táánò cì gî, káa yí kpónó ꞌvala ndi wó gî; yí táánò giṛi gî, káa à kpónó ꞌde yí gî.› » ");
INSERT INTO ndz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ta o tí nò, Jézù giì ꞌdè có ji ndâ mbe tala có mì wó, máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò ta ndâ i mì wó me gbolò giì ꞌdi có máa, bòò tí nó náa yí te yí tí mbe kpolo tí ndâ i mì wó nó kû volo gbí ndâ i mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ꞌDakò tí nò bà-i-nò giì tèꞌé tí bòò mì wó nò, bìndi  yí giì ꞌvee yí, máa, ‹Ndâ có tí nó náa ndâ ꞌduù kû ꞌdè ji ye ta ṛè lo nó a yúcó? Tùbà sè ndâ i gbí gálá ji ye, tacó ye kákáꞌi gí bà si wò ꞌví dù gbí gálá mì ye wálá!› ");
INSERT INTO ndz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Bòò tí nò mâ giì ꞌdi có tí nò, yí giì koṛo có gbí njembí wó, máa, ‹Mbe tí ye kèjì gí bà mòkò ye ꞌdo gbí nèté gî! Ye ꞌví me ta tí ye ée? Wotí bà ji njí tí ye wálá. Káa àá ṛo ye a nô bà yù i. ");
INSERT INTO ndz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","À má énò, ye kpónó bà bàkà ꞌbí ŋa i ꞌdakò mì ye, tacó wàa yí kpêtí má mò ye ꞌdo gbí nèté gî, ye ꞌví kû zò ta nje ye ꞌdo mì ndâ ꞌduù tí nò.› ");
INSERT INTO ndz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Yí bà-i-nò giì tèꞌé tí ndâ ꞌduù ŋìnó ta i mì mbe tí wó muu ndú nô. Bìndi  yí giì ꞌvee kpédélé ꞌduù ꞌdo gbí òkò tí ndú máa, ‹Àá mì mbe tí ye muu lo a ée?› ");
INSERT INTO ndz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«Káa ꞌdakò tí nò giì ꞌvìsì có ji yí, máa, ‹Àá mì wó muu ye a ndâ còngò bàà mbâ ziꞌduù-vô.› «Káa bòò tí nò giì ꞌvìsì có ji ꞌdakò tí nò máa, ‹Jaka tí ndâ mbílì tí nò náa wò táánò kiꞌviki tacó bà ꞌvii có gítí bà sì bàà tí nò nó ꞌdo gbí wú gálà gî, wò ꞌví si sè ndú mí gbí wú ká ziꞌduù-só-nje muuꞌbì cuki.› ");
INSERT INTO ndz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Bòò tí nò giì ꞌvee ꞌbí ꞌduù kákáꞌi, máa, ‹Káa wò ŋìndi lo, àá muu lo a ée?› «Káa ꞌdakò tí nò giì ꞌvìsì có ji yí máa, ‹Àá muu ye a ndâ gboko cû 1,000.› «Káa bòò tí nò giì ꞌvìsì có ji ꞌdakò tí nò máa, ‹Si mí gbí wú káa ndâ mbílì 800.› ");
INSERT INTO ndz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Mbe tí vò bòò tí nò giì ùlù yí gítí ŋa i yú ṛo tí nò náa yí bàkà nò, tacó ꞌduù ta ṛo wó mbe yú énò gbí òkò tí ndâ ꞌviì gbí ngbaꞌo wálá. ");
INSERT INTO ndz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Tacó énò, ye kû ꞌdè có ji yo máa, yo bàkà nambeè ji ndâ ꞌduù ta ndâ i muu to tí nó, tacó wàa, bà ndâ i tí nò má da gî, Mbíṛì ꞌví te ta wiṛi mítí yo á ꞌbá tí nó mbe dù tí ká nô. ");
INSERT INTO ndz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ꞌDuù má ni bà kpolo tí làmbu i ta njembí wó gbaànjé gî, yí bà ni bà kpolo tí ndâ kpo-kpò i ta njembí wó gbaànjé delè gî. Káa bà kpolo tí làmbu i ta njembí ꞌduù gbaànjé má kpò yí gî, bà kpolo tí ndâ kpo-kpò i ta njembí wó gbaànjé delè bà kpò yí gî. ");
INSERT INTO ndz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Káa bà kpolo tí ndâ i muu to tí nó ta njembí lo gbaànjé má kpò wò gî, a ꞌdi ká bà je ndâ i mì Mbíṛì ji wò, máa, wò ꞌví kpolo tí ndú? ");
INSERT INTO ndz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bà kpolo tí ndâ i mì ndâ ꞌbí ka lo ta njembí lo gbaànjé má kpò wò gî, a ꞌdi ká bà je i ji wò tí ꞌdóó ŋìndi lo? ");
INSERT INTO ndz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Gbèe bòò bà bàkà nèté ji ndâ ꞌduù sósòꞌô ta njembí wó gbaànjé wálá. Yí má zè ꞌbí  nìkì maa, yí bà zè ꞌbí ka wó nìkì wálá. Yí má kû te duù mítí ꞌbí , yí bà sì ꞌbí ka wó tí i wálá. Wò má kû bàkà nèté ji Mbíṛì ta njembí lo gbaànjé, wò bà ꞌde ꞌbí njembí tacó bà tee mítí ndâ i muu to tí nó wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà, tí ndâ mbe go ndâ i muu to tí nó, mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, ndú giì ŋo Jézù ŋó-ŋo. ");
INSERT INTO ndz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Káa Jézù giì ꞌvìsì có ji ndú máa, «A yo ká kû bàkà tí yo tí ndâ ꞌduù jáá á kùṛo ndâ ꞌduù. Káa Mbíṛì ŋò ndâ có gbí njembí yo ni gî. Tacó ndâ i tí nó náa ndâ ꞌduù kû si tí ndâ kpóló-kpolo i nó me ndâ i kùṛo Mbíṛì lá. ");
INSERT INTO ndz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Ndâ có mì Mòze, ta ndâ có tí nó náa ndâ mbe ꞌdòkò có mì Mbíṛì cu mí gbí ndâ wáràgà mì ndú nó, bàkà nèté yee ká tí o mì Jòvánì tí mbe caka tí ndâ ꞌduù. Bìndi  bà ma Banga-Ngú-Có gítí bà dù Mbíṛì tí gba giì ꞌbìtà tí. ꞌDo tí o bà ꞌbìtà bà ma Banga-Ngú-Có tí nò, ndâ ꞌduù me mbè kû giì bàkà wotí tacó bà dù tí ŋa ndâ ꞌduù tí nó tí ndâ bòò-gba mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Káa à peteke a bà ꞌbu ndâ tàṛì ta to tí nó á cotí bà giṛi ꞌbí làmbu njì có téꞌdéé énó ꞌdo tí có mì Mòze. ");
INSERT INTO ndz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«ꞌDuù má njè niì mì wó gî, bìndi  yí giì kò ꞌbí ngú niì, yí kû zi a ngbà ta ngú niì tí nò. ꞌDuù delè má kò niì tí nó náa ꞌdakò mì wó njè yí gî nó, yí kû zi a ngbà ta yí.» ");
INSERT INTO ndz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jézù bà-i-nò giì lòkòꞌbò có ji ndú, máa, «ꞌBí ꞌdakò táánò tí mbe da i kû yuu káa ndâ kpo-kpò bòngo, yí delè kû zò káa tó i ꞌbàà ta ṛi ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","À giì te ꞌbí ꞌdakò tí mbe yê ta ṛè wó a Lázàrò, ta ndâ kà ta ndi tí kútí wó náa ndâ bô kû là ṛo ndú, mí njekèjì ndùgù mì ꞌdakò tí nò tí mbe da i nò, kû ù ndâ njúnjú i-zó-zò ŋìnó mbe kû ꞌvaka tí to bìndi wó ta o ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Lázàrò mâ giì cì gî, ndâ basìlì mì Mbíṛì giì te yí ya tí  gí ṛègbà tí Àbìráámò gbíṛì. ꞌDakò tí nò tí mbe da i nò mâ giì cì gî, a giì duu yí gî. ");
INSERT INTO ndz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Káa yí giì dù á tà to gbí séꞌi á ꞌbá mì ndâ ku, bìndi  yí giì ŋò Àbìráámò me dú, bìndi  Lázàrò kû kì tí wó to á ṛègbà tí wó. ");
INSERT INTO ndz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bìndi  yí giì tò kû ta bà ꞌdeke tí wó ji Àbìráámò, máa, ‹Ŋò yê ṛo ye, bu ye Àbìráámò. Si Lázàrò ꞌví yuu sìlì ꞌbì wó gbaànjé mí gbí ngo, wàa yí ꞌví si ngo tí nò á tí sìlì ꞌbì wó nò ꞌví cì gí gbí nje ye, tacó bà ꞌdèè mè ye tacó ye gbí gbolò séꞌi.› ");
INSERT INTO ndz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Káa Àbìráámò giì ꞌvìsì có ji ꞌdakò tí nò, máa, ‹Koṛo muu lo, máa, wò táánò kû ꞌvala gbí dà, ꞌviì mì ye, káa gbèe tó i mbe waa to có kòtí Lázàrò wálá. Káa à kpónó kû tekeꞌde yí bà-i-nó, káa wò kû kònò séꞌi. ");
INSERT INTO ndz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Káa à me ká énò cuki lá, cèe gbolò pù ngo njèè gbí òkò tí ndoo gî. Kpokèjì bà ya ndâ ꞌduù ꞌdo mì ze kàá gí mì yo kà wálá. Kpokèjì bà gì ndâ ꞌduù ꞌdo mì yo kà gí mì ze delè wálá.› ");
INSERT INTO ndz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Káa mbe da i tí nò giì ꞌvìsì có ji Àbìráámò, máa, ‹À má énò, bàkà nambeè mì lo, wò ꞌví tuu Lázàrò gì gí ꞌbá mì bu ye, ");
INSERT INTO ndz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","wàa yí ꞌví ꞌdè có tí kpoò ji ndâ náꞌvindí ye vô mbe cì lá, máa, ndú ꞌví gì gí gbí bàndò mbugo tí nò náa ye kpónó kuu gbí  nó lá.› ");
INSERT INTO ndz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Káa Àbìráámò giì ꞌvìsì có ji ꞌdakò tí nò, máa, ‹Ndâ Mòze ta ndâ mbe ꞌdòkò có mì Mbíṛì kuu mì ndâ náꞌvindí lo kà; si ndú ꞌví ꞌdi ndâ có mì ndú.› ");
INSERT INTO ndz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Káa ꞌdakò tí nó giì ꞌvìsì có ji Àbìráámò, máa, ‹À me énò lá, bu ye Àbìráámò. À má a vuuvuu ká co mítí ndú, ndú bà ꞌvìsì muu ndú ꞌdo tí ndâ vò kpokèjì mì ndú gî.› ");
INSERT INTO ndz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Káa Àbìráámò giì ꞌvìsì có ji ꞌdakò tí nò, máa, ‹Ndú má biya bà ꞌdi ndâ có mì ndâ Mòze, ta ndâ mbe ꞌdòkò có mì Mbíṛì gî, à kpêtí káa ku ká ꞌvala ndi wó ꞌdo gbí muuꞌdú wó ká ya gí bà ꞌdè có ji ndú, ndâ có mì wó nò bà dù gbí tù ndú ká go cèe mòngò gbí tù bô.› » ");
INSERT INTO ndz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Ndâ i mbe eendi ndâ ꞌduù gítí bà bàkà vò i ta o ꞌdáá gî bà dù kuu, káa ꞌduù tí nó mbe kû gì ta ndú nó bà ŋò mítí wó! ");
INSERT INTO ndz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","À nìkì a bà eṛe du díí mítí miṛi ŋa ꞌduù tí nò, wàa à ꞌví te ta yí ꞌva mí tà kàpá cotí bà volo muu ꞌbí ꞌviì gbaànjé ꞌdo gbí òkò tí ndâ víí ꞌviì tí nó mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Káa yo ꞌví kpolo tí yo, máa, ꞌBí náꞌvindí yo gbaànjé má bàkà i lè gî, yo ꞌví ꞌdè gbí vò i mì wó ji yí. Vò i mì wó nò má volo tí wó gî, yo ꞌví si có gítí vò i mì wó nó mí to. ");
INSERT INTO ndz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yí má co ta yo tí kpokèjì ŋìnó mbe lè gî ta bà  vô-nje só gbí gbèe ṛi, káa bìndi bà bàkà ndâ vò i mì wó nò yí kû gì gí bà ꞌdeke tí wó ji yo máa yì kákáꞌi bà bàkà ndi ŋa i tí nò wálá, yo ꞌví si có gítí wó mí tò.» ");
INSERT INTO ndz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ndâ mbe tala có mì Jézù giì ꞌdeke tí ndú ji yí máa, «Je wotí bà tee njembí ze mítí Mbíṛì tí kpoò ndii ŋìnó náa ze kû me kpónó nó gî ji ze, Mbe tí ze.» ");
INSERT INTO ndz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo kùtàá má kû tee njembí yo mítí Mbíṛì kpêtí ká njíꞌdíí énó, yo má ꞌdè cò ji ꞌbí gbolò mû-ꞌbelè máa, yí a ta teè wó vùkù ꞌdo tà to, wàa yí ꞌví ya gí bà ṛò ndi tí wó mí tà kàpá, yí bà ꞌdi có mì yo nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Bòò mì ꞌbí ꞌduù gbí òkò tí yo nò kpónó má gì ꞌdo gbí njí, má wálá ꞌdo bà gbà ndâ rómbo, yí bà ꞌdè ji bòò tí nò máa, ‹Ndii ngé ya gí bà zò i gî›? ");
INSERT INTO ndz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Có náa yí bà ꞌdè ji bòò tí nò bà dù me énó máa, ‹Caka tí lo gî wàa wò ꞌví bàkà i-zó-zò ji ye, ye má zò i cee gî, wò ꞌví giì ya gí bà zò ŋìndi lo› lá? ");
INSERT INTO ndz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yí ꞌdè nìkì maa ji bòò mì wó tacó bà bàkà nèté tí nó náa yí je ji yí nó gî? ");
INSERT INTO ndz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yo delè ká énò. Yo má bàkà ndâ nèté tí nó náa à je ji yo nó cee gî, yo ꞌví ꞌdè có máa, ‹Ze káa ndâ bòò sínò, ze kû bàkà káa ndâ nèté ŋìnó náa à je ji ze nó cuki.› » ");
INSERT INTO ndz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jézù giì njè nó kû ya gí Jèrùzàlémè co tí wúngbó to tí nó gbí òkò tí ndâ Sàmárìyà ta Jùdéyà nô. ");
INSERT INTO ndz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yí mâ giì yee ꞌbá mì ndâ ꞌbí ꞌduù, á gí ndiì ꞌdo gbí gbata, ndú giì ꞌde tí ndú ta ndâ ꞌbí mbe cì muuꞌbì. Káa ndâ mbe cì tí nò giì ṛò tíyò ꞌdo tí Jézù janga-jàngá gí ndiì. ");
INSERT INTO ndz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bìndi  ndú giì ꞌdeke tí ndú ji yí ta kòcò ndú ngárá gí yaà máa, «Jézù, Mbe tí ze, ŋò yê ṛo ze!» ");
INSERT INTO ndz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jézù mâ giì zeke ndú, yí giì ꞌdè có ji ndú máa, «Yo ya gí bà tùbà tí yo ji ndâ bu-Mbíṛì.» Káa si ndú kpokèjì ta nó kû ya gí mì ndâ bu-Mbíṛì, ndú mâ giì ŋò cì cee ꞌdo tí ndú ꞌdáá gî gî. ");
INSERT INTO ndz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","ꞌBí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ꞌduù tí nó muuꞌbì náa cì cee ꞌdo tí ndú nó, tí ꞌduù Sàmárìyà, mâ giì ŋò bà cee cì ꞌdo tí wó, yí giì dele ndi wó jee bà ya gí mì ndâ bu-Mbíṛì mí to, ta bà ùlù Mbíṛì ta kòcò wó ngéé gí yaà. Yí mâ giì yee mì Jézù, yí giì ìṛì ta muungbó wó ya gí bà zèè kò Jézù, ta bà ꞌdè nìkì maa ji yí. ");
INSERT INTO ndz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Káa Jézù giì ꞌvee ꞌvé máa, «Muu ndâ ꞌduù tí nó náa cì cee ꞌdo tí ndú nó kùtàá me muuꞌbì lá? Káa sè ndâ ꞌduù ŋìnó vô-nje nàꞌô nó ngò? ");
INSERT INTO ndz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Káa à dele gì gí bà ùlù Mbíṛì káa gbèe ꞌdakò tí nó mbe ꞌdó-ꞌdo tí ꞌduù Sàmárìyà nó tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bìndi  yí giì ꞌdè cò ji ꞌdakò tí nò máa, «A gí yaà, wàa wò ꞌví ya ta nó mì lo, tacó bà tee njembí lo mítí Mbíṛì ꞌvala wò gî.» ");
INSERT INTO ndz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà giì ꞌvee Jézù gítí o bà gì Mbíṛì gí bà zogo to tí nô. Káa Jézù giì ꞌvìsì có ji ndú máa, «ꞌBí i mbe tùbà bà gì o tí nó náa Mbíṛì bà gì tí  gí bà zogo to tí nó nò wálá. ");
INSERT INTO ndz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ꞌBí ꞌduù ta wotí bà ꞌdè có ji yo tí wó máa, ‹Yo ŋò nô! Mbíṛì kpónó kû zogo to tí nô,› nò bà dù wálá; ꞌbí ꞌduù delè ta wotí tí wó tacó bà ꞌdè có ji yo máa, ‹Yo ŋò zô! Mbíṛì kpónó kû zogo to tí zô,› bà dù wálá. Tacó Mbíṛì kpónó kû zogo to gbí òkò tí yo.» ");
INSERT INTO ndz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jézù mâ giì ꞌvìsì có gí tàkò ꞌvé mì ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà nó gî, yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Yo wúnò bà ꞌdeke tí ꞌbí ṛi gbaànjé ꞌdo gbí òkò ndâ mbè sili tí nó mì ꞌViì-mì-ꞌDakò, káa yo bà ꞌde wálá. ");
INSERT INTO ndz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta o tí nò ndâ ꞌduù bà dù kû ŋònòkò muu yo máa, ‹Yo zekeꞌo zô!› ‹Yo zekeꞌo nô!› Káa yo ꞌví tè gí tàkò ndâ có mì ndú nò gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tacó o bà gì ꞌViì-mì-ꞌDakò bà dù go mù mbe ì gbaànjé, bìndi  ngba wó giì cee tàṛì ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Káa yí bà kònò a séꞌi ta wotí tí  kpédéléꞌi má kózò gi. Ndâ ꞌduù tí nó mbe kû ꞌvala kpónó nó bà biya yí ꞌdáá gî má kózò gi. ");
INSERT INTO ndz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«O bà gì ꞌViì-mì-ꞌDakò wúnò bà dù ká jé go o mì Nówà dígísèé. ");
INSERT INTO ndz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Gbí o mì Nówà nò, ndâ ꞌduù ꞌdáá gî kû zò i, ndâ ꞌduù kû njù pe, ndâ ꞌdakò ta ndâ niì kû kò tí ndú, yee ká ngé tí ṛi bà o Nówà gí gbí gbâ, bìndi  ngo giì mìì ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","O bà gì ꞌViì-mì-ꞌDakò nò delè bà dù teke-tèkè go o mì Lótì dígísèé. Ndâ ꞌduù ta o tí nò kû zò i, ndâ ꞌduù kû njù pe, ndâ ꞌduù kû mà ꞌvélè ta bà sì i, ndâ ꞌduù kû ṛò njí, ndâ ꞌduù kû gèè ꞌbá. ");
INSERT INTO ndz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Káa ta ṛi bà njè nó mì Lótì ꞌdo gbí gbata Sòdómà, Mbíṛì giì si wu, ta ndâ i mbe kû lu wu, kû nì gí to ꞌdo tàṛì giì mìì ndâ ꞌduù gbí gbata Sòdómà ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ŋìnò a ŋa i tí nó wúnò bà bàkà tí ta o bà co ꞌViì-mì-ꞌDakò gí ṛo ṛi nô. ");
INSERT INTO ndz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Ta o tí nò, wò tí ꞌduù má pí ꞌbá, wò ꞌví co gí to tacó bà ya gí bà kaa ndâ káꞌi mì lo ꞌdo tàꞌi lá. ꞌDuù ta o tí nó má gbí njí, yí ꞌví dele ndi wó gí ꞌbá lá. ");
INSERT INTO ndz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yo koṛo muu yo gítí nawù Lótì! ");
INSERT INTO ndz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ꞌDuù mbe kû jè ta bà koṛo có máa ꞌválá mì yì a i ꞌbí yì, bà giṛi miṛi wó gî; káa ꞌduù mbe sì miṛi wó ji ku gî ká bà ꞌvala miṛi wó. ");
INSERT INTO ndz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ye kû ꞌdè có ji yo máa, ta bèbìlì tí nò, ndâ ꞌduù má sósòꞌô gbí gbèe kpâ-sili, àá bà je ꞌbí ꞌduù gbaànjé gî, si ka wó mí to. ");
INSERT INTO ndz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ndâ niì má sósòꞌô kû no ꞌvuù toko gbaànjé, àá bà je ꞌbí  gbaànjé gî, si ka wó mí ṛo ꞌvuù. ");
INSERT INTO ndz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ndâ ꞌdakò má sósòꞌô gbí njí, àá bà je ꞌbí ꞌduù gbaànjé gî, si ka wó mí gbí njí.» ");
INSERT INTO ndz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Káa ndâ mbe tala có mì Jézù bà-i-nò giì ꞌvee yí máa, «Àá bà ṛuka ndâ ꞌduù ya tí  gí kòtí ꞌdi, Mbe tí ze?» Káa yí giì ꞌvìsì có ji ndú máa, «Ndâ gàlàmbá má yaà kere-kèrèè, gbí có tí nò énó máa, ku i kuu gbí to tí nò.» ");
INSERT INTO ndz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jézù giì lòkòꞌbò ꞌbí có ji ndâ mbe tala có mì wó tacó wàa ndú ꞌví me ta kpììkì-kpììkì gítí bà ꞌdeke tí ndú ji Mbíṛì lá, ");
INSERT INTO ndz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","énó máa, «Ta ꞌbí o gbaànjé dígísèé, ꞌbí gba mbe cì gúku tí Mbíṛì lá, delè mbe si ndâ ꞌduù tí i lá kû ꞌvala gbí ꞌbí gbata. ");
INSERT INTO ndz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Bìndi  ꞌbí nawù ku ta o ꞌdáá gî kû ya ta ngbàngà mì wó gí kùṛo gba tí nò, máa, ‹ꞌDè yúcó je gítí có tí nó gbí òkò tí ze ta ꞌduù tí nó mbe zi ye gî nó gi!› ");
INSERT INTO ndz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Niì tí nò nò gí gbí ngbàngà kùṛo gba tí nò ta cèe kôndi o, káa gba tí nò biya bà waa có mì wó gî. Gbí ndòngbú ŋìnó gba tí nò giì koṛo có máa, ‹Ye ŋò ni gî máa, gúku Mbíṛì tí ye wálá, delè nèté mì ye ta ꞌduù wálá, ");
INSERT INTO ndz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","káa kpácà gbí yì niì tí nó ngé ndii gî. À má énò, ye bà waa có mì wó ji yí. À má énò lá, yí bà gì kû pèè mbí ye ta o ꞌdáá gî.› » ");
INSERT INTO ndz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mbe tí ndoo giì ꞌvee ndâ mbe tala có mì wó máa, «Yo ꞌdi có tí nò náa gba tí nò jé mbe waa yúcó lá nò ꞌdè nò gî? ");
INSERT INTO ndz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","À má énò, Mbíṛì bà waa yúcó ji ndâ ꞌduù mì wó náa yí ṛuka ndú, mbe kû ꞌdeke tí ndú ji yí ta síí gbí  wálá nó wálá? Gbí dìì wó bà me a jàmànàkà gítí bà konì ndú? ");
INSERT INTO ndz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ye kû ꞌdè có ji yo máa, yí bà waa yúcó ji ndú ta zítí tí wó. Kpêtí ká énò, ꞌViì-mì-ꞌDakò má gì wúnò, yí bà ꞌde ndâ ꞌduù mbe kû tee njembí mítí Mbíṛì muu to tí nó gî?» ");
INSERT INTO ndz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jézù giì lòkòꞌbò có gítí ndâ ꞌduù ŋìnó mbe kû tùbà tí ndú, máa, ndâ yì a ndâ mbe bàkà tó i, ta bà dù kû ꞌdè có ŋónókó gítí sè ndâ ꞌbí ꞌduù nó, ");
INSERT INTO ndz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","máa, «Ta ꞌbí o gbaànjé ndâ ꞌbí ꞌdakò sósòꞌô giì ya gí bà ꞌdeke tí ndú ji Mbíṛì. ꞌBí ꞌduù gbí òkò tí ndú gbaànjé a mbe kpolo tí tàkìì mì ndâ Jùdéyà, bìndi  ka wó tí nó náa ndú ta yí nó a Jùdéyà tí mbe kû kili i-mírì mì ndâ Ròmánò. ");
INSERT INTO ndz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ndú mâ giì yee ꞌbá-Mbíṛì gî, ꞌduù tí nó tí mbe kpolo tí tàkìì mì ndâ Jùdéyà nó giì ṛò tíyò, bìndi  yí giì ꞌdeke tí wó ta kpéétí wó ji Mbíṛì, máa, ‹Ye ꞌdè nìkì maa ji wò tí Mbíṛì, tacó ye me go ndâ ꞌbí ŋa ꞌduù tí nó tí ndâ mbe gbolò njembí nó lá, ye me go ndâ ꞌbí ŋa ꞌduù tí nó tí ndâ mbe kû ꞌboo yúcó mì ꞌduù nó lá, ye delè me go ndâ ꞌbí ŋa ꞌduù tí nó tí ndâ mbe kû zingbà ta ndâ niì mì ndâ ꞌduù nó lá. Co tí ndâ ŋa ŋìnò ꞌdáá gî, ye me go ꞌdakò tí nó tí mbe kû kili i-mírì mì ndâ Ròmánò á seè tí ye nó lá. ");
INSERT INTO ndz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ye kû kònò go ta sili só gbí òkò ndâ ꞌbí ṛi bà wotí ta ka wó ṛi bà wotí. I má dí ꞌbì ye, ye kû mò bà ŋìndi lo tí Mbíṛì ji wò go i gbí tàkìì mì ze tí ndâ Jùdéyà.› ");
INSERT INTO ndz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Káa ꞌdakò tí nó tí mbe kili i-mírì mì ndâ Ròmánò nó giì ṛò tíyò gàà gí ndiì ꞌdo tí mbe kpolo tí tàkìì mì ndâ Jùdéyà. Bà te muu wó gí yaà giì kpò yí gî. Bìndi  yí giì kunduu ꞌbì wó mí njembí kû ꞌdeke ta tí wó ji Mbíṛì máa, ‹Àá Mbíṛì, ŋò yê ṛo ye, tacó ye a mbe bàkà vò i.› ");
INSERT INTO ndz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","«Ye kû ꞌdè có ji yo máa, ꞌdakò tí nò tí mbe kili i-mírì nó dele ndi wó gí ꞌbá bìndi bà ꞌdeke tí wó ji Mbíṛì tí ꞌduù ŋìnó náa à gbí òkò tí ndú ta Mbíṛì a nambeè. Káa ka nó mì wó ꞌde tó i ꞌdo mì Mbíṛì lá. Tacó ꞌduù ta o ꞌdáá gî má kû luguu tí wó ta ꞌvéṛè, mbe si yí tí i wálá. Káa ꞌduù má si tí wó tí i lá, à ta o ꞌdáá gî kû te duù mítí wó.» ");
INSERT INTO ndz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ta o tí nò, ndâ ꞌbí ꞌduù giì kaa ndâ víí ꞌviì mì ndú, máa ndâ yì ya ta ndú ji Jézù, tacó wàa yí ꞌví tee ꞌbì wó mítí ndú. Káa ndâ mbe tala có mì wó giì mòkò ndâ ꞌduù tí nò ta ndâ ꞌviì mì ndú nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Káa Jézù giì tèꞌé tí ndâ ꞌduù tí nò ta ndâ ꞌviì mì ndú, bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Yo si ndâ víí ꞌviì tí nò ꞌví gì gí mì ye. Yo tii ndú lá, tacó à kû dù tí ndâ bòò-gba mì Mbíṛì a ndâ ꞌduù go ŋa ndú nò. ");
INSERT INTO ndz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ye kû ꞌdè có ji yo ta yúcó máa, ꞌduù mbe ùnje gítí bà dù tí bòò-gba mì Mbíṛì go i mì làmbu ꞌviì lá, bà dù á ꞌbá mì Mbíṛì wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ta o tí nò, ꞌbí ꞌdakò tí gbolò ꞌduù giì ꞌvee Jézù máa, «Tó Mbe nìbà i, ye ꞌví bàkà a ŋa yè, tacó wàa, ye ꞌví ꞌde ta ŋa ꞌválá ŋìnó mbe cee lá nó?» ");
INSERT INTO ndz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Káa Jézù giì ꞌvìsì có ji gbolò ꞌduù tí nò máa, «Wò nì tó ꞌduù mítí ye tacó yè? Tó ꞌduù wálá; tó ꞌduù káa Mbíṛì cuki. ");
INSERT INTO ndz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wò ꞌdi ndâ có tí nó máa, ‹Wò ꞌví zingbà ta niì mì ꞌdakò lá. Wò ꞌví zi ꞌduù lá. Wò ꞌví zingbà i lá. Wò ꞌví ꞌdè ꞌvéṛè gítí ꞌduù lá. Wò ꞌví tègàṛà ndâ bu lo ta nawu lo› nó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Káa gbolò ꞌduù tí nò giì ꞌvìsì có ji Jézù máa, «Ye ꞌbìtà bà kpolo tí ndâ có tí nò ꞌdo gbí ꞌviì yee tí kpónó.» ");
INSERT INTO ndz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jézù mâ giì ꞌdi có tí nò náa ꞌdakò tí nò ꞌdè nò, yí giì ꞌvìsì có ji yí máa, «Sè ꞌbí i mbe gboo ꞌdo mì lo gî kuu tí . Ya gí ꞌbá, wàa, wò ꞌví sì ndâ i mì lo ꞌdáá gî gí ꞌdè, wàa wò ꞌví njèè ndâ i tí nó náa wò ꞌde gbí ndú nó ji ndâ mbe yê má gî, gbolò i ꞌví dù tacó tí lo gbíṛì; wàa wò ꞌví gì gí bà dù tí ꞌduù mì ye.» ");
INSERT INTO ndz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ꞌDakò tí nò mâ giì ꞌdi có tí nò, njembí wó giì volo gî, tacó ndâ i mì wó ògbù ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jézù mâ giì ŋò bà volo njembí ꞌdakò tí nò, yí bà-i-nò giì zeke ꞌdakò tí nò, bìndi  yí giì ꞌdè có ji yí máa, «Bà dù ndâ mbe kpo-kpò i tí ndâ bòò-gba mì Mbíṛì ká kpolo gî le! ");
INSERT INTO ndz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","À peteke a bà ṛì ꞌbí gbolò nò go yége nó co gbí gùù ngbàndú á cotí bà dù ꞌduù ŋìnó ta ndâ i mì wó ògbù ngé nó tí bòò-gba mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ndâ mbe ꞌdi có tí nò náa Jézù ꞌdè nò bà-i-nò giì ꞌvee yí máa, «À má énò, a ꞌdi ká bà ꞌde ꞌválá?» ");
INSERT INTO ndz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ndâ i ŋìnó ta wotí bà bàkà ndú tí ndâ ꞌduù ngé gî wálá nó, wotí bà bàkà ndú kuu tí Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Káa Pìyétòrò giì ꞌvìsì có gí tàkò có mì Jézù nò máa, «Ŋò káa ze jee ndâ ꞌbá mì ze mí to gî, kû ṛu ndi lo gi!» ");
INSERT INTO ndz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Káa Jézù giì ꞌvìsì có ji ndâ Pìyétòrò máa, «Ye kû ꞌdè có ji yo ta yúcó, máa, ꞌbí ꞌduù má jee ꞌbá mì wó, ta niì mì wó, ta ndâ náꞌvindí wó, ta ndâ bu wó, ta nawu wó, ta ndâ ꞌviì mì wó, mí to tacó bà dù tí bòò-gba mì Mbíṛì, ");
INSERT INTO ndz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","àá bà ko mboo ndâ i tí nó ta bà  me mbè ji yí kpónó si yí kû ꞌvala muu to tí nó, delè wúnò ta o ꞌválá ŋìnó mbe cee lá nô.» ");
INSERT INTO ndz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jézù giì kaa ndâ mbe tala có mì wó muuꞌbì-nje só nó ꞌdo gbí òkò tí ndâ ꞌduù gí ndiì, bìndi  yí giì ꞌdè có ji ndú máa, «Ndoo kpónó kû ya gí Jèrùzàlémè, bìndi  ndâ i bà bàkà tí gbaànjé-gbaànjé go ndâ có tí nó náa ndâ mbe ꞌdòkò có mì Mbíṛì cu mí gbí ndâ wáràgà mì ndú gítí ꞌViì-mì-ꞌDakò nô. ");
INSERT INTO ndz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Àá bà je yí ji ndâ tende ŋa ꞌduù. Ndâ tende ŋa ndâ ꞌduù tí nò bà ŋonoko yí, ndú bà bàkà ndâ i-nô ta bà cù cù mítí wó. ");
INSERT INTO ndz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ndú bà gbì yí, bìndi  ndú bà zi yí gî. Káa bìndi sili taꞌô, yí bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Káa bà ꞌdi gbí ndâ có tí nò náa Jézù ꞌdè nò giì kpò ndâ mbe tala có mì wó gî, tacó ndú ŋò ꞌdóó i tí nò náa yí kû ꞌdè có ji ndú gítí  nò ni lá. ");
INSERT INTO ndz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jézù mâ giì dooko gítí gbata Jérìkò gî, yí giì ꞌde ꞌbí ꞌdakò tí mbe sú ṛo kû ki tí wó to á seè kpokèjì kû yù i ꞌdo tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mbe sú ṛo tí nò mâ giì ꞌdi kòcò ndâ ꞌduù me mbè kû ndii ta nó tí kpokèjì, yí giì ꞌvee ndeṛè ndâ mbè ꞌduù tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Káa ndâ ꞌduù giì ꞌvìsì có ji yí máa, «A Jézù tí nó mbe ꞌdo Názàrètì nó ká kû ndii ta nó.» ");
INSERT INTO ndz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mbe sú ṛo tí nò mâ giì ꞌdi ṛè Jézù, yí giì tèꞌé tí Jézù ta kòcò wó ngéé gí yaà, máa, «Jézù, ꞌViì mì Dàvídè, ŋò yê ṛo ye!» ");
INSERT INTO ndz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Káa ndâ ꞌduù tí nó mbe kû tè kùṛo Jézù nó giì do ta yí, máa, yí dù ngbìì. Káa mbe sú ṛo tí nò giì biya bà ꞌdi có mì ndâ ꞌduù tí nò gî. Yí giì tèꞌé tí Jézù ta kòcò wó gí yaà ndii kpédélé ŋìnó gî, máa, «ꞌViì mì Dàvídè, ŋò yê ṛo ye!» ");
INSERT INTO ndz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jézù mâ giì ꞌdi bà tèꞌé tí wó mì mbe sú ṛo tí nò, yí giì ṛò tíyò, bìndi  yí giì ꞌdè có ji ndâ ꞌduù máa, ndú ja yí gì tí  ji yì. À mâ giì ja yí ya tí  ji Jézù go có tí nò náa yí ꞌdè nò gî, Jézù giì ꞌvee yí máa, ");
INSERT INTO ndz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Wò tèꞌé tí ye máa ye ꞌví bàkà a ŋa yè ji wò?» Káa mbe sú ṛo tí nò giì ꞌvìsì có ji Jézù máa, «Njaanga ndâ ṛo ye gî, kpo ꞌduù!» ");
INSERT INTO ndz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jézù bà-i-nò giì ꞌvìsì có ji mbe sú ṛo tí nò máa, «Zekeꞌo! Bà tee njembí lo mítí Mbíṛì ꞌvala wò gî.» ");
INSERT INTO ndz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","À káa póó bà ꞌdè có tí nò mì Jézù, ndâ ṛo mbe sú ṛo tí nò sósòꞌô ngé giì njaanga tí gî. Bìndi  yí giì ṛu ndi Jézù ta bà ùlù Mbíṛì. Ndâ mbe ŋò bà njaanga ndâ ṛo wó nò delè giì ùlù Mbíṛì tacó ŋa i tí nò mbe bàkà tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jézù mâ giì ṛì gí gbí gbata Jérìkò gî, ");
INSERT INTO ndz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ꞌbí ꞌdakò tí kùṛo ndâ mbe kili i-mírì mì ndâ Ròmánò, tí ꞌduù ta ndâ i mì wó me gbolò, ta ṛè wó a Zèkáwù, ");
INSERT INTO ndz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","giì bàkà wotí tacó bà ŋò Jézù ta ṛo wó, káa à giì kpò yí gî, tacó yí me ndò, káa ndâ ꞌduù me mbè ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tacó énò, yí giì ì ngèlè ya gí kùṛo, yí giì ꞌdò gí gbí mû tí kpokèjì tí nó náa Jézù kû ndii co tí  nó, tacó bà cu ṛo wó mítí Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jézù mâ giì gì gbúú-gbuu ꞌvii ta bàndò tí nó náa Zèkáwù ꞌdò gí gbí mû tí  nó, yí giì zekeꞌo gí yaà, bìndi  yí giì ꞌdè có ji Zèkáwù máa, «Zèkáwù, co gí to! Ngoꞌve tí lo, tacó ye wúnó a wiṛi ꞌbá mì lo.» ");
INSERT INTO ndz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zèkáwù bà-i-nò giì co gí to ꞌdo gbí mû ꞌvíṛì-ꞌvíṛì, bìndi  yí giì te wiṛi mítí Jézù ta líkíꞌo tí wó. ");
INSERT INTO ndz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ndâ mbe ŋò Jézù tí wiṛi ꞌbá mì Zèkáwù ꞌdáá gî giì ꞌdè kòlòwò máa, «Yí a wiṛi mì mbe bàkà vò i.» ");
INSERT INTO ndz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Káa Zèkáwù giì ṛò tíyò, bìndi  yí giì ꞌdè có ŋìnó gbí muu wó nó ji Mbe tí ndoo máa, «Ŋò nô, Mbe tí ye, ye kèjì gí bà njèè gbí ndâ i mì ye sósòꞌô ꞌvii ká ꞌvii. Ye ꞌví je ꞌbí  gbaànjé ji ndâ mbe yê. Sè ŋìnó, ye táánò má zò ꞌve i mì ꞌbí ꞌduù gî, ye bà sì có i mì ꞌduù tí nò ji yí ꞌdo tí  ta ba  nàꞌô.» ");
INSERT INTO ndz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Káa Jézù giì ꞌvìsì có ji Zèkáwù máa, «Ndâ ꞌduù ꞌbá tí nó wúnó ꞌvala gî, tacó ꞌdakò tí nó delè a ꞌviì mì Àbìráámò. ");
INSERT INTO ndz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Káa ꞌViì-mì-ꞌDakò gì a i tacó bà pà bà tí ndâ ꞌduù ŋìnó mbe giṛi gî nó wàa yì ꞌví ꞌvala ndú.» ");
INSERT INTO ndz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jézù giì lòkòꞌbò có ji ndâ ꞌduù tí nó mbe kû sè tù ndú tí nje tí nó náa ndú ꞌdè ta Zèkáwù nó, si ndú dooko gí Jèrùzàlémè gî, káa ndâ ꞌduù giì koṛo có máa, o bà tùbà tí Mbíṛì tí gba muu to tí nó me jéꞌdéé gî. ");
INSERT INTO ndz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tacó énò, Jézù giì lòkòꞌbò có ji ndú máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò, tí ꞌviì mì gbolò ꞌduù, giì bàkà nó tacó bà ya gí gbí ꞌbí to, tacó wàa à ꞌví bàkà yì tí gba kà, má kózò gî, yì ꞌví giì dele ndi yì gí ꞌbá. ");
INSERT INTO ndz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Káa o kùṛo bà nje nó mì wó ꞌdo ꞌbá, yí giì tèꞌé tí ndâ bòò mì wó muuꞌbì, bìndi  yí giì njèè gboko ŋa gbaànjé-gbaànjé ji ndú. Bìndi  yí giì ꞌdè có ji ndú máa, ‹Yo ko njì ŋa tí nó yee tí o bà dele ye.› ");
INSERT INTO ndz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Yí mâ giì ya gî, ndâ ꞌduù mì wó giì ŋò ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndú, bìndi  ndú giì tuu ndú ya tí  gí tàkò wó, máa, ndú ya gí bà ꞌdè có ji ndâ kpo ꞌduù tí nò mbe kû le bèṛè ji yí nó, máa, ‹Go bà dù ꞌdakò tí nó tí gba mì ze tí ze wálá.› Ndâ ꞌduù mì wó bàkà énò tacó go bà dù yí tí gba mì ndú tí ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«ꞌDakò tí nò mâ giì dele gí ꞌbá bìndi bà le bèṛè ji yí, yí giì tèꞌé tí ndâ bòò mì wó náa yí njèè njì ŋa ji ndú nó tacó bà ŋò máa, ndú bàkà a ŋa yè tí  wè. ");
INSERT INTO ndz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yí mâ giì ꞌvee ndú, kpédélé ꞌduù giì ꞌdè có ji yí máa, ‹Ye ꞌde gbí gboko ŋa tí nó náa wò táánò je ji ye nó a ndâ gboko muuꞌbì, gba mì ye.› ");
INSERT INTO ndz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Gba tí nò bà-i-nò giì ùlù bòò mì wó nò máa, ‹Wò bàkà nèté nìkì ma, tó bòò mì ye! Wò tùbà tí lo tí ꞌduù mbe kû bàkà nèté ta njembí lo gbaànjé mítí làmbu gboko ŋa gî. À má énò, ye bà bàkà wò tí gba mbe zèè ndâ gbata muuꞌbì.› ");
INSERT INTO ndz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«ꞌBí bòò mì wó giì gì gí mì wó, bìndi  yí giì ꞌdè có ji yí máa, ‹Ye yili ꞌdo gbí gboko ŋa tí nó náa wò táánò je ji ye nó ù ta ndi lo a ndâ gboko vô, kpo ꞌduù.› ");
INSERT INTO ndz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Káa gba tí nò giì ꞌvìsì có ji bòò mì wó nò máa, ‹Ye bà bàkà wò tí gba mbe zèè ndâ gbata vô.› ");
INSERT INTO ndz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Bà taꞌô bòò mì gba tí nò giì gì gí mì wó, bìndi  yí giì ꞌdè có ji yí máa, ‹Gboko ŋa mì lo tí nó táánò náa wò je ji ye nó kuu nô, kpo ꞌduù. Ye kpolo tí  tacó à ꞌví pìì lá ù ta ndi lo mí ṛo wu. ");
INSERT INTO ndz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gúku lo kpò ye ꞌdo tí bà gàà tí  gî. Tacó wò a vò ꞌduù náa i kpêtí má me i mì lo lá, wò je gî. Wò delè a ꞌbí ŋa ꞌduù náa wò kpêtí má ṛò njí lá, wò kû kili i ꞌdo gbí njí nô.› ");
INSERT INTO ndz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Káa gba tí nò giì ꞌvìsì có ji bòò mì wó nò máa, ‹Ndí lo vò bòò! Ye bà waa có mítí lo á ꞌdo gbí po ngo nje lo! Wò ŋò ye ni tí vò ꞌduù mbe kû je i ŋìnó náa à me i mì ye lá, ye delè kû kili i ŋìnó náa ye ṛò lá nó ꞌdo gbí njí. ");
INSERT INTO ndz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wò táánò má te gboko ŋa mì ye nò ji ꞌbí mbe ji njí, ye kpónó dele nó giì ꞌde gboko tí nò jò ꞌbí ka wó gboko wálá gî?› ");
INSERT INTO ndz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Gba tí nò bà-i-nò giì ꞌdè có ji ndâ ꞌduù tí nó jara-jàrà tíyò nó máa, ‹Yo te gboko ŋa tí nò ꞌdo tí wó ji ꞌduù tí nò ta ndâ gboko ŋa mì wó muuꞌbì nô.› ");
INSERT INTO ndz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Káa ndâ ꞌduù tí nò giì ꞌvìsì có ji gba tí nò máa, ‹Ndâ ꞌbí gboko muuꞌbì sàà kuu mì wó, kpo ꞌduù!› ");
INSERT INTO ndz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«Káa gba tí nò giì ꞌvìsì có ji ndú máa, ‹Ye kû ꞌdè có ji yo máa, i má kuu mì ꞌduù, à ta o ꞌdáá gî kû je i ji yí, káa ꞌdóó i ꞌduù má wálá, à kpêtí mì wó káa yè wè, à kû je ꞌdo tí wó gî. ");
INSERT INTO ndz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Káa à má gítí ndâ ꞌduù ŋìnó mbe kû sogo ye, ta go bà dù tí ndâ bòò-gba mì ye tí ndú wálá nó, yo gì ta ndú kpónó, wàa à ꞌví waaka ndú mí kùṛo ye bà-i-nô.› » ");
INSERT INTO ndz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jézù mâ giì ꞌdè có ji ndâ ꞌduù tí nò cee gî, yí giì njè nó kû ya gí Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yí mâ giì dooko ta ndâ gbata Bètìfájì ta Bètánìyà dê ta ꞌbí gú náa à kû nì mítí  a Gú Mbâ gî, yí giì tuu ndâ ꞌbí mbe tala có mì wó sósòꞌô gí kùṛo, ");
INSERT INTO ndz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","máa, «Yo ya gítí to tí zó náa yo zeke zô. Yo má yee kà, yo bà ꞌde ngbú ꞌviì-kècè náa ꞌduù jé o yí lá á kuu gbí wú kà. Yo njaanga yí ꞌdo gbí wú gì tí . ");
INSERT INTO ndz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Káa ꞌduù má ꞌvee yo máa, yo kû njaanga yí tacó yè wè, yo ꞌví ꞌvìsì có ji ꞌduù tí nò énó máa, ‹A Mbe tí ze ká tuu ze.› » ");
INSERT INTO ndz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ndâ tú mì Jézù giì ya ꞌde ngbú ꞌviì-kècè go có tí nó náa Jézù ꞌdè ji ndú nô. ");
INSERT INTO ndz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Káa si ndú kû giì njaanga ngbú ꞌviì-kècè tí nò, mbe tí wó giì ꞌvee ndú máa, «Yo kû njaanga ngbú ꞌviì-kècè tí nó tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Káa ndú giì ꞌvìsì có ji yí máa, «A Mbe tí ze ká tuu ze, máa, ze ya tí  ji yì.» ");
INSERT INTO ndz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ndâ tú mì Jézù mâ giì yee ta ngbú ꞌviì-kècè tí nó náa yí tuu ndú, máa ndú ya gí bà ja gì tí  ji yì nó gî, ndú giì ki ndâ bòngo mí ndú mí pí tí wó, bìndi  ndú giì ki Jézù mí pí ndâ bòngo tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jézù mâ giì ꞌbì nó gî, ndâ ꞌduù giì gò ndâ bòngo mì ndú mí to á tí kpokèjì kùṛo wó. ");
INSERT INTO ndz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Káa si yí kû giì yaaka gí tàgbà Gú Mbâ, ndâ mbe tala có mì wó ꞌdáá gî giì ꞌbìtà bà tò kû, ta bà cè cè, ta bà be ṛè Mbíṛì gbí  ta kòcò ndú ngéé gí yaà ta líkíꞌo ndâ seṛè tí nó náa ndú ŋò Jézù bàkà nó, máa, ");
INSERT INTO ndz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«Mbíṛì ꞌví si gbolò gba tí nó mbe gì ta ṛè wó tí Mbíṛì nô. Mbíṛì ꞌví dù tí gba tí gbíṛì. À ùlù Mbíṛì ngéé gbíṛì!» ");
INSERT INTO ndz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà gbí òkò tí ndâ mbè ꞌduù tí nò mâ giì ꞌdi ndâ có tí nò náa ndâ ꞌduù kû tò ta kû nó, ndú giì ꞌdè có ji Jézù máa, «Mbe nìbà i, ꞌdè có ji ndâ mbe tala có mì lo máa, ndú dù ngbìì.» ");
INSERT INTO ndz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kû ꞌde có ji yo máa, ndú kpêtí má dù ngbìì gî, ndâ díí bà dù ngbìì wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jézù mâ giì dooko ta Jèrùzàlémè gî, yí mâ giì ŋò muu gbata, yí giì ꞌdù ngo-ṛo wó gítí . ");
INSERT INTO ndz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Bìndi  yí giì ꞌdeke tí wó máa, «Ṛo lo kùtàá má go ṛo ṛi wàa wò ꞌví ŋò ta ndâ i ŋìnó mbe njaanga miṛi lo ꞌdo gbí vò i! Káa, wotí bà ŋò ndú kpónó tí lo wálá! ");
INSERT INTO ndz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","O bà gbo wò mì ndâ kuꞌdì tí lo kèjì. Kpokèjì bà ndo wò ꞌdo ꞌbì ndú ta o tí nò bà dù wálá, tacó ndú bà da kándà mí ndú jèlè wò gbóó gî. ");
INSERT INTO ndz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ndú bà toṛo nje yo ta ndâ ꞌviì mì lo ta to. Ndú delè bà kiꞌviki ndâ ꞌbá mì lo lúꞌbú-lúꞌbú gí to. Ndú bà bàkà énò tacó Mbíṛì táánò gì gí mì lo gî káa wò ŋò yí ni lá!» ");
INSERT INTO ndz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jézù mâ giì ṛì gí gbí gbata Jèrùzàlémè gî, yí giì ya gí gbí ndùgù ꞌbá-Mbíṛì, bìndi  yí giì ꞌbìtà bà mòkò ndâ mbe kû mà ꞌvélè gbí ndùgù ꞌbá-Mbíṛì gí sè, ");
INSERT INTO ndz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ta bà ꞌdè có ji ndú máa, «À cu mí gbí wáràgà mì Mbíṛì énó máa, Mbíṛì máa, ‹ꞌBá mì ye bà dù tí ꞌbá bà ꞌdeke tí.› Káa yo kpónó giì ꞌvìsì tí bàndò mì ndâ mbe ngbà!» ");
INSERT INTO ndz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jézù giì dù kû nìbà i ji ndâ ꞌduù á gbí ndùgù ꞌbá-Mbíṛì ta ṛi ꞌdáá gî. Káa ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, ta ndâ mbe nìbà i mì ndú, giì toko có ta ndâ ꞌbí kpo-kpò ꞌduù mì ndú tacó bà zi yí. ");
INSERT INTO ndz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Káa bà zi yí giì kpò ndú gî, tacó ndâ ꞌduù ꞌdáá gî ta o tí nò kû ꞌdi có mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ta ꞌbí o gbaànjé si Jézù kû nìbà i, ta bà ma Banga-Ngú-Có mì Mbíṛì ji ndâ ꞌduù gbí ndùgù ꞌbá-Mbíṛì, ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, ta ndâ mbe nìbà i mì ndú, ta ndâ kpo-ꞌduù-ꞌbá mì ndú, giì gì gí mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bìndi  ndú giì ꞌvee yí máa, «A ꞌdi ká je wotí bà bàkà ndâ i tí nó náa wò kû bàkà nó ji wò? Nì ṛè wó ji ze gi.» ");
INSERT INTO ndz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye delè bà ꞌvee yo ta ꞌvé gbaànjé, yo ꞌdè ji ye gi: ");
INSERT INTO ndz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","àá táánò a Mbíṛì ká je wotí bà caka tí ndâ ꞌduù ji Jòvánì, wèè, a ꞌduù ká je ji yí?» ");
INSERT INTO ndz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ndú mâ giì ꞌviiki gbí ꞌvé mì Jézù nò gbí òkò tí ndú, ndú giì ꞌdè có máa, «Ndoo má ꞌdè có énó máa, a Mbíṛì táánò ká je wotí tí nó ji Jòvánì, yí bà tè ndi tí wó gí bà ꞌvee ndoo kákáꞌi máa, ‹Yo ùnje gítí wó lá tacó yè?› ");
INSERT INTO ndz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Káa ndoo delè kpónó má ꞌvìsì có ji yí máa, a ꞌduù táánò ká je wotí tí nò ji yí, ndâ ꞌduù ꞌdáá gî bà ꞌvaka ndoo ta díí, tacó ndú ꞌdáá gî ùnje ta yúcó gî, máa, Jòvánì táánò a mbe ꞌdòkò có mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tacó énò, ndú giì ꞌvìsì có ji Jézù máa, ndâ yì ŋò mbe je wotí bà caka tí ndâ ꞌduù ji Jòvánì ni lá. ");
INSERT INTO ndz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Káa Jézù giì ꞌvìsì có ji ndú máa, «À má énò, ye delè bà nì ṛè mbe je wotí bà bàkà ndâ i tí nò ji yo wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jézù bà-i-nò giì lòkòꞌbò có ji ndâ ꞌduù máa, «Ta ꞌbí o gbaànjé, ꞌbí ꞌdakò giì ṛo njí nèbítì mì wó, bìndi  ndú giì ꞌvii có ta ndâ ꞌbí mbe bàkà nèté máa, ndú zekeꞌo tí , bìndi  yí giì ya muu nó ta cèe gbolò o. ");
INSERT INTO ndz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","O bà kili i ꞌdo gbí njí mâ giì me tí gî, yí giì tuu ꞌbí bòò mì wó gbaànjé ji ndâ ꞌduù tí nó náa yí si ndú mí gbí njí mì wó nó tacó bà i ŋìndi wó. Bòò tí nò mâ giì yee ta có tí nó tí ndâ ꞌdakò tí nò, ndú giì gbì yí mòkò ya gí mì mbe tí wó ta kùnga ꞌbì wó. ");
INSERT INTO ndz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","«Mbe njí tí nò kákáꞌi giì tuu ꞌbí bòò mì wó ji ndú. Káa ndâ mbe nèté tí nò giì dele ndi ndú giì gbì bòò tí nò, ndú giì bàkà ndâ i-nô mítí wó, bìndi  ndú giì tuu ndi wó ji mbe njí go bô gbí ndi kìyà. ");
INSERT INTO ndz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mbe njí mâ giì tuu bà taꞌô bòò mì wó ji ndú, ndâ ꞌdakò tí nò giì gbì kà mítí bòò tí nò, ndú giì ni yí ta kùnga ꞌbì wó ꞌdo gbí njí gí sè. ");
INSERT INTO ndz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mbe njí tí nò giì ꞌvee tí wó gbí ŋìnó máa, ‹Ye kpónó ꞌví bàkà a ŋa yè? À má énò, ye bà tuu ꞌviì mì ye, tí wú-gbí-ṛé ye ji ndú. Ndâ-ꞌbî-lá, ndú bà te duù mítí wó.› Yí bà-i-nò giì tuu ꞌviì mì wó nò ji ndú. ");
INSERT INTO ndz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Ndâ ꞌdakò tí nò mâ giì ŋò ꞌviì mì mbe njí kèjì gí mì ndú, ndú giì toko có mì ndú máa, ‹Ŋìzó a mbe mbèlè tí nó ká kèjì zô. Ndoo zi yí gî, wàa à ꞌví dù tí ŋìndi ndoo.› ");
INSERT INTO ndz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tacó énò, ꞌviì tí nò mâ giì ye mì ndú, ndú giì ja yí ꞌdo gbí njí gí sè, bìndi  ndú giì zi yí gî.» Jézù giì ꞌvee ndâ ꞌduù máa, «Yo koṛo có máa, mbe njí tí nò kpónó bà bàkà ta ndâ mbe nèté tí nò a yè? ");
INSERT INTO ndz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yí bà ziki ndú ꞌdáá gî, bìndi  yí giì pà ndâ ꞌbí ngú mbe nèté.» Ndâ ꞌduù mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, ndú giì ꞌvìsì có ji yí máa, «Mbíṛì ꞌví gì ta ŋa ŋìnò lá!» ");
INSERT INTO ndz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jézù bà-i-nò giì zeke ndâ ꞌduù tí nò ngbóó, bìndi  yí giì ꞌvee ndú máa, «Gbí có tí nó náa à cu mí gbí wáràgà mì Mbíṛì énó máa, ‹A ꞌdóó díí tí nó náa ndâ mbe bì ꞌbá táánò bè gî nó ká gì tí yú díí bà sè tà ꞌbá,› nó máa yè? ");
INSERT INTO ndz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ꞌDuù má ꞌva tí wó pí díí tí nò, ꞌduù tí nò bà kiꞌviki njúkú-njúkú. Káa díí tí nò má ꞌva tí pí tí ꞌduù, yí bà ꞌbaꞌdaka gbí ꞌduù tí nò gî.» ");
INSERT INTO ndz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ndâ mbe nìbà i, ta ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà mâ giì ꞌdi có tí nò, ndú giì jè ta bà pà kpokèjì tacó bà zèè Jézù ká mì to nò, tacó ndú ŋò ni gî máa yí kû lòkòꞌbò có tí nò a i gítí ndâ yì. Káa gúku ndâ ꞌduù giì kpò ndú á ꞌdo tí bà zèè yí gî. ");
INSERT INTO ndz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mbí ndâ kpo-kpò ꞌduù mì ndâ Jùdéyà giì dù ká kácáá tí Jézù. Tacó énò, ndú giì tuu ndâ ꞌbí ꞌduù mì ndú mbe bàkà tí ndú tí ndâ tó ꞌduù tacó bà ya gí bà zèè mè Jézù, wàa ndâ yí ꞌví kpì ta ngbàngà tí wó ji ngáángbá gba mì ndâ Ròmánò. ");
INSERT INTO ndz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ndâ mbe ngìŋò mì ndâ kpo-kpò ꞌduù mì ndâ Jùdéyà bà-i-nò giì ꞌvee Jézù ta tiṛì máa, «Mbe nìbà i, ze ŋò ni gî máa, wò a mbe ꞌdè yúcó, wò delè kû nìbà i ji ndâ ꞌduù ká jáá. Wò njèè gbí òkò tí ndâ ꞌduù, máa, ŋìnó énó, káa ŋìzó énó, nò lá. Wò kû nì káa bà kpokèjì yúcó mì Mbíṛì ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bà gò i ji ngáángbá gba mì ndâ Ròmánò dú gbí tàkìì mì ndoo tí ndâ Jùdéyà? ꞌDè ŋa ŋìnó náa à gbí muu lo nó ji ze gi.» ");
INSERT INTO ndz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Káa Jézù giì ŋò ni gî máa, ndú kû lè ji yì a wú. ");
INSERT INTO ndz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tacó énò, yí giì ꞌvìsì có ji ndú máa, «Yo tù ŋa gùrúsù mì yo ji ye gi.» Ndâ ꞌduù tí nò mâ giì tù ŋa gùrúsù tí nó tí dìnárì nó ji Jézù gî, yí giì ꞌvee ndú máa, «Ŋìnó a muu ꞌdi náa à ka mí gbí  nó?» Káa ndú giì ꞌvìsì có ji yí máa, «A muu ngáángbá gba mì ndâ Ròmánò.» Bìndi  yí giì ꞌvee ndú máa, «Káa à cu mí gbí  nó a ṛè ꞌdi?» Káa ndú giì ꞌvìsì có ji yí máa, «A ṛè ngáángbá gba mì ndâ Ròmánò.» ");
INSERT INTO ndz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jézù bà-i-nò giì ꞌdè có ji ndú máa, «À má énò, yo je ndâ i mì ngáángbá gba mì ndâ Ròmánò ji ngáángbá gba mì ndâ Ròmánò. Wàa yo ꞌví je ndâ i mì Mbíṛì ji Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bà zèè ngo nje Jézù mí kùṛo ndâ ꞌduù giì kpò ndâ ꞌdakò tí nò gî. Tacó énò, ndú giì dù ṛekpe-ṛèkpèè ta có bà ꞌdé-ꞌdè mì ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ndâ ꞌbí ŋa Jùdéyà mbe ùnje gítí bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú lá nó giì gì gí mì Jézù. Bìndi  ndú giì ꞌvee yí máa, ");
INSERT INTO ndz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Mbe nìbà i, Mòze cu mí gbí wáràgà ji ze énó máa, ꞌduù má kò niì, káa ndú jò ta niì tí nò lá, bìndi  yí giì cì gî, náꞌvindí wó ꞌví zèè ꞌbì nawù ku tí nò, tacó bà jò ndâ ꞌviì mí gbí mòòkò bìndi wó. ");
INSERT INTO ndz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Káa ta ꞌbí o gbaànjé, kpo ꞌduù mì ndâ ꞌbí ꞌviì-ꞌdakò náa nawu ndú jò ndú vô-nje só giì kò niì, káa ku giì je yí si ndú jò ta niì tí nò lá. ");
INSERT INTO ndz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ꞌViì tàkò wó giì zèè ꞌbì nawù ku tí nò. Ndú delè giì jò ta niì tí nò lá, bìndi  yí giì cì gî. ");
INSERT INTO ndz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ndâ ꞌviì-ꞌdakò tí nò gbí yì nawu ndú ꞌdáá gî tè ṛì cìkii niì tí nò gbaànjé-gbaànjé gî, káa à ꞌvaka gí tàkò ndú ꞌdáá káa dìkììwu. ");
INSERT INTO ndz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ku giì je niì tí nò si ndú ṛì gùù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","À má énò, niì tí nò wúnò ta o bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú bà dù a nawù ꞌdi gbí òkò tí ndú, sé náa ndú ꞌdáá vô-nje só kò yí gî nó?» ");
INSERT INTO ndz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ndâ ꞌdakò ta ndâ niì kû kò tí ndú muu to tí nô. ");
INSERT INTO ndz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Káa ndâ ꞌduù ŋìnó mbe ꞌvii tí ndâ mbe ꞌvala ndi ndú bìndi ku gî nó bà kò tí ndú bìndi bà ꞌvala ndi ndú ꞌdo gbí muuꞌdú wálá. ");
INSERT INTO ndz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndú bà cì wálá, tacó ndú bà dù go ndâ basìlì mì Mbíṛì. Ndú delè bà dù tí ndâ ꞌviì mì Mbíṛì, tacó ndú ꞌvala ndi ndú ꞌdo gbí muuꞌdú ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Káa, à má gítí có bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú, Mòze ꞌdè có gítí ŋìnò gbí tà-ká-tà gítí bèꞌi tí nó mbe kû doo nó gî. Yí nì mítí Mbe tí ndoo a Mbíṛì mì Àbìráámò, Mbíṛì mì Ìzákò, tí Mbíṛì mì Jàkóbè. ");
INSERT INTO ndz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mbíṛì a Mbíṛì mì ndâ wu ꞌduù. Yí me Mbíṛì mì ndâ ku lá, tacó ndâ ꞌduù ꞌdáá gî kùṛo Mbíṛì a ndâ wu ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ndâ ꞌbí mbe nìbà tàkìì mì ndâ Jùdéyà máa giì ꞌdi có tí nò náa Jézù ꞌdè nò, ndú giì ùlù yí, máa, «Có mì lo nò ká ngbáṛángàꞌi, Mbe nìbà i.» ");
INSERT INTO ndz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gúku bà ꞌvee yí gítí ndâ ꞌbí i giì kpò ndâ ꞌduù gî. ");
INSERT INTO ndz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jézù giì ꞌvee ndâ ꞌduù máa, «Ndâ ꞌduù kû ꞌdè có énó máa, Bìndi-Mbíṛì a ꞌviì mì Dàvídè ta ŋa kpokèjì ngàyi? ");
INSERT INTO ndz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tacó ꞌdóó kòcò Dàvídè náa à cu mì gbí wáràgà mì ndâ Muu Cè énó máa, Mbíṛì ꞌdè có ji Mbe tí ye máa, ‹Ki tí lo gbí kùꞌbì mì ye, ");
INSERT INTO ndz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","wàa ye ꞌví bàkà ndâ kuꞌdì tí lo tí ndâ i-tà-tàmà mì lo.› ");
INSERT INTO ndz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dàvídè má kû nì mítí Bìndi-Mbíṛì a ‹Mbe tí ye›, à má énò, Bìndi-Mbíṛì bà dù tí ꞌviì mì Dàvídè ée?» ");
INSERT INTO ndz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jézù giì ꞌdè có ji ndâ mbe tala có mì wó si mí kùṛo ndâ ꞌduù ꞌdáá gî, máa, ");
INSERT INTO ndz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Yo kpolo tí yo ꞌdo tí ndâ mbe nìbà i mì ndâ Jùdéyà. À tí ndú a go bà yuu ndâ nja-njà bòngo kû jèlè ta to, ta go bà cu ndò mì ndâ ꞌduù gí bà ꞌvee ndú ta ndi tí ndâ bàndò ꞌvélè, ta go bà ki tí ndú pí ndâ mbata kùṛo ndâ ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì, delè ta go bà ki tí ndú tí ndâ bàndò mì ndâ kpo-kpò ꞌduù á tí ndâ bàndò bà zò i. ");
INSERT INTO ndz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ndú zò ndâ nawù ku kaṛaka gî, ta bà bàkà tí ndú tí ndâ mbe ꞌdeke tí ndú ji Mbíṛì ta bà ꞌvanda njà có. Mbíṛì bà waa có mítí ndú ta wotí tí  ndii ndâ ꞌduù ꞌdáá gî!» ");
INSERT INTO ndz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jézù mâ giì zekeꞌo, yí giì ŋò ndâ mbe kpo-kpò i kû gò i á bàndò bà kili i gítí ꞌbá-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yí bà-i-nò giì ŋò ꞌbí nawù ku tí mbe yê kû gò ndâ njì gùrúsù tí fádà sósòꞌô. ");
INSERT INTO ndz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Ye kû ꞌdè có ji yo ta yúcó máa, nawù ku tí nò tí mbe yê nò gò i me gbolò ndii ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tacó ndâ mbe kpo-kpò gùrúsù gò a ndâ ꞌbí ŋa njemèlè gùrúsù ŋìnó náa ndú mò ꞌdo tí ndâ kpo-kpò gùrúsù mì ndú gí ndiì, ta nèté mì ndú tí  wálá nô. Káa niì tí nó tí mbe yê nó gò a làmbu i tí nó ꞌdáá náa yí kû lì mítí  nô.» ");
INSERT INTO ndz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ta o tí nò, ndâ ꞌbí mbe tala có mì Jézù giì ùlù banga tí ndâ díí tí nó náa à bì ta ꞌbá-Mbíṛì nó, ta ndâ i-banga tí nó náa ndâ ꞌduù gò ji Mbíṛì nô. Káa Jézù giì ꞌdè có ji ndú máa, ");
INSERT INTO ndz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ṛi bà kiꞌviki ndâ i tí nò lúꞌbú-lúꞌbú gí to ká gbaànjé. Àá kèjì gí bà voloko gbí ndâ i tí nò léé gî.» ");
INSERT INTO ndz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Káa ndâ mbe tala có mì Jézù giì ꞌvee yí máa, «Ṛi tí nò bà co ta o ngàyi, Mbe nìbà i? Káa ze bà ŋò o bà co ṛi tí nò ni mítí yè?» ");
INSERT INTO ndz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo kpolo tí yo máa, ꞌbí ꞌduù ꞌví ŋonoko yo lá. Tacó ndâ ꞌduù me mbè bà kaa gì gí bà eendi yo ta ṛè ye. ꞌDuù ŋìnó bà o ká ta ŋìndi wó, máa, ‹Ye a yí tí Bìndi-Mbíṛì! O tí nò dooko jéꞌdéé gî!› Káa yo ꞌví tè gí tàkò ndâ có mì ndú nó lá. ");
INSERT INTO ndz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yo má ꞌdi có ndâ kpo-kpò gó, ta ndâ gbínje gbí òkò tí ndâ gba ta ndâ bòò mì ndú, njembí yo ꞌví mù lá. Tacó ndâ i tí nò bà bàkà tí gî, káa ndòngbú o dooko lá. ");
INSERT INTO ndz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ndâ ŋa ndâ ꞌbí ꞌduù bà tè ndâ ꞌbí tende ŋa ꞌduù ta gó, ndâ gba delè bà tè ndâ ꞌbí ka ndú gba ta gó. ");
INSERT INTO ndz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","To bà tanga tí, tí ndâ bàndò me mbè, làngàwìṛí ta ndâ i mbe pèè mbí ndâ ꞌduù bà ṛukuꞌbu ta ndâ ꞌduù cee to ꞌdáá gî. Ndâ seṛè, ta ndâ i mbe te gúku mítí ndâ ꞌduù, bà bàkà tí tàṛì. ");
INSERT INTO ndz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Káa kùṛo o bà bàkà tí mì ndâ vò i tí nò náa ye ꞌdeke ndú ji yo nò, ndâ ꞌduù bà zèè yo ta kpo ꞌbì, ta bà mèèkèꞌi tí yo. Ndú bà kaa yo ya tí  gí gbí ngbàngà kùṛo ndâ kpo-kpò ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì. Bìndi  ndú bà nè yo mí gbí zàà. Ndú bà kaa yo ya tí  gí kùṛo ndâ kpo-kpò gba, ta ndâ kpo-kpò ꞌduù. Ndâ ꞌduù bà bàkà ndâ ŋa ndâ vò i tí nò ꞌdáá náa ye ꞌdeke ndú nò mítí yo á muu ye. ");
INSERT INTO ndz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Káa ŋìnò bà dù a tó o bà ma Banga-Ngú-Có mì yo ji ndâ ꞌduù ká nò. ");
INSERT INTO ndz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","À má énò, yo ꞌví te mí gbí muu yo ká sàà énó máa, njembí yo ꞌví mù máa, yo ꞌví njaanga miṛi yo ta ŋa có yè wè, nò lá. ");
INSERT INTO ndz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tacó a ye ká bà wu ndâ có tí nó náa yo ꞌví ꞌdè nó mí gbí nje yo. Ye delè ká bà je ꞌbí ŋa muu ji yo náa wotí gítí bà ṛò tíyò nje có ta yo bà dù tí ndâ kuꞌdì tí yo wálá. Ndú delè bà ꞌde wotí gítí bà tò kponje ndâ có mì yo wálá. ");
INSERT INTO ndz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ndâ bu yo, ta ndâ nawu yo, ta ndâ náꞌvindí yo, ta ndâ nambe yo, ta ndâ kómbe yo, ta o tí nò bà kpì ngbàngà tí yo, bìndi  ndâ gba bà waa có ku mítí ndâ ꞌbí ꞌduù gbí òkò tí yo. ");
INSERT INTO ndz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ndâ ꞌduù ꞌdáá gî bà sogo yo muu ye. ");
INSERT INTO ndz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Káa yo bà co ꞌdo gbí ndâ i tí nò go késî á ṛo ngo. ");
INSERT INTO ndz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","À má énò, yo ꞌdò kò yo mí to gbàá, tacó ŋìnò a kpokèjì ꞌválá mì yo ká nò. ");
INSERT INTO ndz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Yo má ŋò ndâ àsìkérì se ꞌdee Jèrùzàlémè gî, yo ꞌví te mí gbí muu yo énò máa, kùṛo bà ꞌbu Jèrùzàlémè dooko gî. ");
INSERT INTO ndz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ta o tí nò, ndâ ꞌduù gbí to Jùdéyà ꞌví fa ngèlè ya gí pí ndâ nja-njà gú. Ndâ ꞌduù gbí gbata ꞌví njè ꞌdo gbí gbata gí sè. Wàa ndâ ꞌduù ŋìnó ta ndiì ꞌdo gbí gbata nó ꞌví kaa ya gí gbí gbata lá. ");
INSERT INTO ndz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tacó ndâ sili tí nò bà dù a ndâ sili bà waa có mítí ndâ ꞌduù, tacó wàa ndâ có tí nó gbí wáràgà mì Mbíṛì nó ꞌví dù tí  tí ndâ yúcó. ");
INSERT INTO ndz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Káa àá bà volo a i ji ndâ mbe nakáyì, ta ndâ niì ŋìnó náa ndâ ꞌviì mì ndú kû no kí nó, gbí ndâ sili tí nò! Tacó ndâ sili tí nò bà dù a ndâ sili bà bàkà ndâ i yê ṛo, ta ndâ i kpo-tàkòcò mì Mbíṛì mítí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Àá bà ziki ndâ ꞌbí ꞌduù gbí ndâ sili tí nò ta sìzò. Bìndi  àá bà kaa ndâ ꞌbí ꞌduù tí ndâ zà-za gó ya cee ꞌbá mì ndâ ꞌduù ŋìnó náa ndú me ndâ Jùdéyà lá nó ꞌdáá gî. Ndâ tende ŋa ꞌduù tí nò bà bàkà a ndi ndú mítí Jèrùzàlémè, yee tí o tí nó náa ndú bàkà bà ꞌbì ndú cee gî. ");
INSERT INTO ndz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Ndâ i-seṛè bà bàkà tí á ṛo ndâ ṛi, ta pì, ta ndâ yii. Ndâ ꞌduù muu to tí nó bà kònò séꞌi. Ndú bà dù ṛekpe-ṛèkpèè ta gúku wo bà ṛengà mì bà gbàngà ngo gbí pù. ");
INSERT INTO ndz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ndâ ꞌduù bà neꞌvenge ta gúku si ndú kû ù ndi ŋa i tí nó kèjì gí bà ꞌbu to tí nó yùkúú nô. Tacó tàṛì bà tanga tí. ");
INSERT INTO ndz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bìndi  ndâ ꞌduù bà giì ŋò ꞌViì-mì-ꞌDakò kû giì ꞌdo tàṛì ngbèzèè, ta bà da nó ta wotí co gbí kùlù mù. ");
INSERT INTO ndz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yo má ŋò ndâ i tí nò kû ꞌbìtà bà bàkà tí, yo ꞌví kpolo ṛo yo, tacó kùṛo o bà ꞌvala yo dooko gî.» ");
INSERT INTO ndz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jézù giì lòkòꞌbò có ji ndâ ꞌduù máa, ");
INSERT INTO ndz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","«Yo má ŋò ndâ mû-mbiìgá kû ꞌbìtà bà tù dó kpâ, yo ŋò ni gî máa, bèmbílì dooko gî. ");
INSERT INTO ndz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","À má énò, yo má ŋò ndâ i tí nó náa ye ꞌdè có gítí ndú ji yo nó kû bàkà tí, yo ꞌví koṛo muu yo máa, kùṛo o bà gì Mbíṛì gí bà dù tí gba gí muu to tí nó dooko gî. ");
INSERT INTO ndz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Ye kû ꞌdè có ji yo ta yúcó máa, ndâ i tí nò bà bàkà tí ꞌdáá kùṛo o bà mìì ndâ ꞌduù tí nó mbe kû ꞌvala kpónó nô. ");
INSERT INTO ndz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ndâ tàṛì, ta to tí nó, bà cee gî. Káa ndâ có mì ye bà cee wálá. ");
INSERT INTO ndz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Yo kpolo tí yo, máa, yo ꞌví tee njembí yo kpolo ma a i mítí bà zò i, ta bà njù pe, ta bà dù ta líkíꞌo muu to tí nó, wàa yo ꞌví ò-bà-mbí o tí nò gî nò, lá, tacó o tí nò bà gbaaka yo gbááká-gbaaka. ");
INSERT INTO ndz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","O tí nò bà gundi ndâ mbe kû ꞌvala muu to tí nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","À má énò, yo dù tí zòꞌo, wàa, yo ꞌví ꞌdeke tí yo ji Mbíṛì ta o ꞌdáá gî, tacó wàa, yí ꞌví je wotí bà ꞌvala ꞌdo gbí ndâ i tí nò kèjì gí bà bàkà tí nò ji yo, tacó wàa, yo ꞌví ṛò tíyò kùṛo ꞌViì-mì-ꞌDakò ta gúku tí yo wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jézù giì dù kû nìbà i ji ndâ ꞌduù á gbí ndùgù ꞌbá-Mbíṛì ta ṛi ꞌdáá gî. Káa à má ta bèbìlì yí kû ya gí bà tèṛì pí Gú Mbâ. ");
INSERT INTO ndz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Káa ndâ ꞌduù kû kaa ya gí bà ꞌdi có mì wó ta fírí dúꞌo á gbí ndùgù ꞌbá-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sè sili gítí o bà ci ꞌDê-kô, náa à delè kû ni mítí  a o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì ta o tí nò me jéꞌdéé gî. ");
INSERT INTO ndz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tacó énò, ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, ta ndâ kpo-kpò mbe ꞌdi gbí tàkìì mì ndú giì kili muu ndú tacó bà pà kpokèjì tacó bà zi Jézù, káa ndú kû cì gúku tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Káa ta o tí nò, Gba-vò-i ya gí gbí muu Júdà Ìsìkàrìyótè, tí ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ tú mì Jézù muuꞌbì-nje só nó gî. ");
INSERT INTO ndz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tacó énò, yí giì ya gí mì ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, bìndi  ndú giì toko có ta ndâ ꞌduù tí nó tí ndâ kùṛo ndâ mbe kpolo tí ꞌbá-Mbíṛì nó, tacó wàa, yì ꞌví pà kpokèjì gítí bà zèè Jézù ji ndú. ");
INSERT INTO ndz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ndâ Kùṛo ndâ bu-Mbíṛì bà-i-nò mâ giì ùnje gítí có bà ko mboo nèté mì Júdà ji yí ta pétékè tàkòcò ndú gî, ");
INSERT INTO ndz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Júdà giì njè nó ya gí bà pà tó kpokèjì bà zèè Jézù ji ndú. ");
INSERT INTO ndz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ṛi bà ci ꞌDê-kô, tí ṛi bà waa mbelè ꞌviì rómbo tí tàkìì gítí o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì mâ giì co gî, ");
INSERT INTO ndz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jézù giì tuu ndâ Pìyétòrò ta Jòvánì máa, «Yo ya gí bà bàkà i-zó-zò gítí o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì ji ndoo.» ");
INSERT INTO ndz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Káa Pìyétòrò giì ꞌvee yí máa, «Có mì lo máa, ze ꞌví bàkà mí kòtí ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo sè tù yo! Ta o tí nó náa yo kû ṛì gí gbí gbata nó, yo bà ꞌde ꞌbí ꞌdakò kû te káṛà ngo. Yo ꞌví ṛu ndi wó. Yo má yee ta ndú ꞌbá gî, ");
INSERT INTO ndz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yo ꞌví ꞌdè có ji mbe ꞌbá tí nò énó máa, ‹Mbe nìbà i ji ze ká tuu ze ji wò. Kòcò wó énó máa, wò tùbà tàꞌi tí nó náa ndâ yì ꞌví gì gí bà zò i-cí-ci mì o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì mítí  ta ndâ mbe tala có mì yì nó ji ze.› ");
INSERT INTO ndz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bìndi  yí bà tùbà gbolò soṛo náa à ꞌviindi ndâ i mí tàꞌi kà ꞌdáá gî ji yo, wàa yo ꞌví bàkà i-zó-zò mí kà ji ndoo.» ");
INSERT INTO ndz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ndâ Pìyétòrò bà-i-nò mâ giì ya gí gbí gbata, ndú giì ꞌde ndâ i ꞌdáá gî jé ká go có tí nò náa Jézù ꞌdè ji ndú nò. Bìndi  ndú giì ꞌviindi ndâ i gítí o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì mì kà. ");
INSERT INTO ndz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","O bà zò i-cí-ci mâ giì me tí gî, Jézù giì zèè bàndò mì wó ṛègbà i-zó-zò, bìndi  ndâ mbe tala có mì wó giì se mí ṛègbà tí wó. ");
INSERT INTO ndz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Bìndi  yí giì ꞌdè có ji ndú máa, «Go bà zò ndòngbú i-cí-ci mì o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì tí nó ta yo á kùṛo bà kònò séꞌi mì ye bà zi ye gî. ");
INSERT INTO ndz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ye ꞌdè có tí nò ji yo tacó i-cí-ci mì o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì náa ndoo kèjì gí bà zò ta ndoo bìndi ŋìnó bà dù ngé káa yú ŋìnó gbí ngbàngà mì Mbíṛì nô.» ");
INSERT INTO ndz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bìndi bà ꞌdè có tí nò, Jézù giì zèè ꞌvisî mí ꞌbì wó, bìndi  yí giì ꞌdè nìkì maa ji Mbíṛì, bìndi  yí giì te ji ndâ mbe tala có mì wó, ta bà ꞌdè có ji ndú gí tàkò  énó máa, «Yo zèè ꞌvisî tí nó, wàa yo ꞌví njù cee nje yo ꞌdáá gî, ");
INSERT INTO ndz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","tacó ndoo bà njù pe ta ndoo bìndi ŋìnó ká ngé gbí ngbàngà mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bìndi  yí giì je kù kô, yí giì ꞌdè nìkì ma ji Mbíṛì, bìndi  yí giì kiꞌviki gbí , yí giì kaa ji ndâ mbe tala có mì wó, ta bà ꞌdè có ji ndú gí tàkò  énó máa, «Ŋìnó a dìì ye tí nó náa àá kèjì gí bà je tacó bà sì muu yo nó ká nô; yo zò  tacó wàa mbí yo ꞌví dù tí  tí ye.» ");
INSERT INTO ndz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ndú mâ giì zò i cee gî, Jézù kákáꞌi giì zèè ꞌvisî, bìndi  yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Ŋìnó a ꞌvisî mbelè ye tí nó náa Mbíṛì kèjì gí bà njù ta ngú mùká ta ndâ ꞌduù nó ká nô. Mbelè ye tí nó kèjì gí bà yee to tacó tí yo. ");
INSERT INTO ndz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Káa yo ŋò ze kpónó kû toko ꞌbì ze mí gbí gbèe káꞌi i-zó-zò ta ꞌduù tí nó kèjì gí bà cu gòmbò tí ye nô. ");
INSERT INTO ndz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kpêtí ká énò, kózò tí ꞌViì-mì-ꞌDakò bà ya gí nje ku mì wó go có tí nó náa à cu mí gbí mbelè wó nó gî. Káa ꞌduù tí nó mbe cu gòmbò tí wó nó bà no ngbó.» ");
INSERT INTO ndz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ndâ mbe tala có mì Jézù bà-i-nò giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú máa, «A ꞌdi ꞌdo gbí òkò tí ndoo ká bà bàkà ŋa i tí nò?» ");
INSERT INTO ndz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ta o tí nò, kponje giì tanga gbí òkò tí ndâ mbe tala có mì Jézù, máa, à ꞌví si a ꞌdi tí gbolò ꞌduù mbe ndii ndâ ka wó ꞌdáá gî gbí òkò tí ndâ yì wè? ");
INSERT INTO ndz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Káa Jézù giì ꞌdè có ji ndú máa, «Ndâ kpo-kpò gba mì ndâ ŋa ndâ ꞌduù ŋìnó náa ndú me ndâ Jùdéyà lá nó kû toṛo nje ndâ bòò mì ndú ta to. Káa ndâ kùṛo ndâ ꞌduù mì ndú kû nì mítí ndú ta kpéétí ndú máa, ndâ yì a ndâ kómbe ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Káa yo bà dù tende. Tacó ꞌduù ŋìnó gbí òkò tí yo tí gbolò ꞌduù kùṛo yo ꞌdáá gî nó ꞌví dù go sè ꞌviì gbí òkò tí yo, wàa ꞌduù ŋìnó tí kùṛo yo nó ꞌví dù go bòò mì yo. ");
INSERT INTO ndz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gbolò ꞌduù gbí òkò tí ndâ ꞌduù ŋìnó mbe kû zò i ta ꞌduù ŋìnó mbe kû bàkà nèté wó si yí kû zò i nó a ꞌdi? ꞌDuù tí nó mbe kû zò i nó a gbolò ꞌduù; a kponje ká nje yo gítí có mì ye nò? Káa ta ndâ ŋìnò ꞌdáá gî, ye kpónó gbí òkò tí yo go ꞌduù ŋìnó mbe kû bàkà nèté yo! ");
INSERT INTO ndz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Káa yo a ndâ ꞌduù ŋìnó mbe dù ta ye gbí ndâ vò o ꞌdáá gî ta njembí yo gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","À má énò, ye bà le bèṛè tí nó náa Bu ye táánò le ji ye nó a ji yo. ");
INSERT INTO ndz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ndoo bà zò i, ndoo delè bà njù pe ta ndoo gbí ngbàngà mì ye. Yo delè bà ki tí yo pí ndâ jàlàmbà tí ndâ gba mì ndâ Ìzìrìyélì gbí ŋa ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«Káa wò tí Sìmónè! Sìmónè! ꞌDi có tí nó náa ye kû ꞌdè ji wò nô. Gba-vò-i kpónó ꞌde kpokèjì gítí bà bàkà ta yo ꞌdáá gî go có tí nó náa à gbí njembí wó nó gî. Yí kèjì gí bà taa gbí yo go bà taa gbí cû mì niì gbí wàkpèè. ");
INSERT INTO ndz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Káa ye ꞌdeke tí ye ji Mbíṛì tacó tí lo máa, yí ꞌví si njembí lo ꞌví dù ká kácáá tí wó nò gî, Sìmónè. Wò má kpònje Gba-vò-i gî, wò ꞌví ꞌvìsì tí lo kákáꞌi gí mì ye, wàa wò ꞌví dù tí mbe je wotí ji ndâ náꞌvindí lo.» ");
INSERT INTO ndz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Káa Pìyétòrò giì ꞌvìsì có ji Jézù máa, «Ye ùnje gítí bà ya ndà sósòꞌô gí gbí zàà kpónó gî, Mbe nìbà i. Ye delè kpónó ùnje gítí bà ṛò ndà sósòꞌô nje ku gî!» ");
INSERT INTO ndz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jézù mâ giì ꞌdi có tí nò, yí giì ꞌvìsì có ji Pìyétòrò máa, «Wò wúnó ta bèbìlì tí nó, kùṛo bà kò-kò mì ngùù bà ꞌdè có ta nje lo ꞌvìlì taꞌô máa, wò ŋò ye ni lá, Pìyétòrò.» ");
INSERT INTO ndz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jézù giì ꞌvee ndâ mbe tala có mì wó, máa, «Ta o tí nó táánò náa ye tuu ta yo gí ndiì ta gùrúsù mì yo wálá, ta kúúkpá mì yo wálá, delè ta tàmà tí kò yo wálá nó, ꞌbí i gboo ꞌdo mì yo gî?» Káa ndú giì ꞌvìsì có ji Jézù máa, «I gboo ꞌdo mì ze lá.» ");
INSERT INTO ndz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jézù bà-i-nò giì ꞌvìsì có ji ndú máa, «À má énò, gùrúsù kpónó má kuu mì ꞌduù, yí je ta yí, wàa kúúkpá má kuu mì ꞌduù, yí le kpónó, sìzò má mì ꞌduù wálá, yí ꞌví mà bòngo tí nó kpónó muu yì wó nó gî, wàa yí ꞌví kaa i tí nó náa yí ꞌde gbí bòngo tí nò nó, yí ꞌví sì ta sìzò. ");
INSERT INTO ndz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ye ꞌdè có tí nò ji yo tacó wàa có tí nó náa à cu ta ṛè ye mí gbí wáràgà mì Mbíṛì énó máa, ‹Àá táánò ꞌdeke yí mò gí mì ndâ vò ꞌduù nó,› ꞌví dù tí yúcó. Tacó àá táánò cu có tí nò a i gítí ye, káa à kpónó-kpónó kèjì gí bà dù tí  tí yúcó.» ");
INSERT INTO ndz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ndâ mbe tala có mì Jézù mâ giì ꞌdi có tí nò náa yí ꞌdè ji ndú nò, ndú giì ꞌvìsì có ji yí, máa, «Ŋò ndâ ꞌbí sìzò sósòꞌô kuu nô, Mbe nìbà i!» Káa Jézù giì ꞌvìsì có ji ndú máa, «À tè gî.» ");
INSERT INTO ndz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jézù bà-i-nò giì njè nó ya gí pí Gú Mbâ go ŋa i mì wó náa yí kû bàkà ta o ꞌdáá gî nô. Bìndi  ndâ mbe tala có mì wó giì kaa ya gí tàkò wó. ");
INSERT INTO ndz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ndú mâ giì yee tí ꞌbí bàndò pí gú kà, yí giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Yo ꞌdeke tí yo ji Mbíṛì, tacó wàa vò i ꞌví tala yo lá.» ");
INSERT INTO ndz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jézù giì yèè ndi wó ꞌdo tí ndâ mbe tala có mì wó bìndi bà ꞌdè có tí nò jàngáá gí ndiì. Bìndi  yí giì kucuku muungbó wó mí to, bìndi  yí giì ꞌdeke tí wó ji Mbíṛì máa, ");
INSERT INTO ndz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«À má nìkì tí lo gî, je ꞌvisî tí nó ꞌdo nje ye gî, Bu ye. Káa wò ꞌví je a i ꞌdo gbí ꞌdóó có mì lo, me ꞌdo gbí có mì ye lá.» ");
INSERT INTO ndz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jézù mâ giì zekeꞌo á bìndi bà ꞌdeke tí wó nò, yí giì ŋò basìlì gì ꞌdo tàṛì gí bà je wotí ji yí. ");
INSERT INTO ndz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jézù giì ꞌdeke tí wó ji Mbíṛì ta séꞌi gbí njembí wó ndii ŋìnó kùṛo nó gî. Bìndi  wuꞌo giì dù kû cì ꞌdo tí wó gí to go bà cì mbelè tí kà nô. ");
INSERT INTO ndz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jézù mâ giì cee ta bà ꞌdeke tí wó ji Mbíṛì gî, yí mâ giì ya gí mì ndâ mbe tala có mì wó, yí giì ꞌde ndú mìì ta ṛì ta sé có gbí njembí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yí bà-i-nò giì gba ndú máa, «Yo kû tè ṛì tacó yè? Yo a gí yaà, wàa yo ꞌví ꞌdeke tí yo ji Mbíṛì, tacó wàa, yo ꞌví ꞌva tí yo gbí vò i lá.» ");
INSERT INTO ndz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Káa si Jézù kû ꞌdè có ji ndâ mbe tala có mì wó, ndú mâ giì zekeꞌo, ndú giì ŋò ndâ ꞌduù náa Júdà tí ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ mbe tala có mì wó muuꞌbì-nje só nó ká kû tè kùṛo ndú kèjì gítí ndú. Ndú mâ giì yee gî, Júdà giì ya ndírí gí mì Jézù, bìndi  yí giì ꞌvee yí ta bà òlò gbí tù wó. ");
INSERT INTO ndz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Káa Jézù giì ꞌvee Júdà máa, «Wò kû ba ngbù ꞌViì-mì-ꞌDakò ta bà òlò gbí tù wó wàà?» ");
INSERT INTO ndz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ndâ ꞌduù mì Jézù mâ giì ŋò énò, ndú giì ꞌdè có ji yí máa, «Ze kpónó bà bàkà nèté ta ndú ta ndâ sìzò, Mbe tí ze?» ");
INSERT INTO ndz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Káa si ndú ꞌdi ta ŋa có ŋìnó náa Jézù bà ꞌvìsì ji ndú nó lá, ꞌbí mbe tala có mì Jézù giì da tù bòò mì Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà ŋìnó gbí kùꞌbì nó ta sìzò waa jàngá gî. ");
INSERT INTO ndz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jézù mâ giì ŋò énò, yí giì do ta ndâ mbe tala có mì wó, máa, «Ŋa i tí nò kákáꞌi ꞌví bàkà tí lá!» Bìndi  yí giì je ndi tù ꞌdakò tí nò kpò mì bìndi . ");
INSERT INTO ndz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bìndi  Jézù bà-i-nò giì ꞌvee ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, ta ndâ kùṛo ndâ mbe kû kpolo tí ꞌbá-Mbíṛì, ta ndâ kpo ꞌduù mì ndâ Jùdéyà tí nó mbe kaa gì tacó bà zèè yí nó, máa, «Ye a mbe volo ꞌbá náa yo giì kaa tí  ta ndâ nja-njà sìzò, ta ndâ ndongbolo-ndòngbòlò mû mí ꞌbì yo tacó bà gì gí bà zèè ta ye nò? ");
INSERT INTO ndz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ye táánò kuu ta yo ta ṛi ꞌdáá gî gbí ndùgù ꞌbá-Mbíṛì, káa yo jé ta ꞌbí gbèe ṛi tee ꞌbì yo mítí ye lá. Káa à wúnó a ṛi bà bàkà bà ꞌbì yo. Ṛo ṛi wúnó ꞌdi ta vò i gî.» ");
INSERT INTO ndz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ndâ ꞌduù tí nò bà-i-nò giì zèè Jézù, bìndi  ndú giì ya ta yí gí ꞌbá mì Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà. Káa si ndú kû ya ta yí nò, Pìyétòrò giì dù jàngá ndiì kû ko tàkò ndú. ");
INSERT INTO ndz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pìyétòrò mâ giì yee ꞌbá mì Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà gî, yí giì ki tí wó to ṛègbà wu gbí òkò tí ndâ ꞌduù tí nó mbe kû u wu gbúú-gbuu gbí ṛùkàtiì nô. ");
INSERT INTO ndz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ꞌBí ꞌvinî mbe kû bàkà nèté ꞌbá mì Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà mâ giì ŋò Pìyétòrò gbí ngba wu, yí giì zeke yí ngbóó, bìndi  yí giì ꞌdè có ji ndâ ꞌduù tí nò ṛègbà wu nò máa, «ꞌDakò tí nò kuu nó táánò kû dù ta yí delè.» ");
INSERT INTO ndz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Káa Pìyétòrò giì to kponje gî, máa, «Ye ŋò yí ni lá, ndí lo niì.» ");
INSERT INTO ndz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ndú mâ giì dù gàà énó, ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ ꞌduù tí nò á ṛègbà wu nò giì zeke Pìyétòrò, bìndi  yí giì ꞌdè có ji yí máa, «Wò delè a ꞌbí ꞌduù ꞌdo gbí òkò tí ndú!» Káa Pìyétòrò giì ꞌvìsì có ji ꞌduù tí nò máa, «Ye me ꞌduù ꞌdo gbí òkò tí ndú lá, kómbe ye.» ");
INSERT INTO ndz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ndú mâ giì dù ndì-ndì-ndì énò, ꞌbí ꞌdakò giì nanaka muu wó mítí Pìyétòrò, máa, «ꞌDakò tí nó kuu nó kû dù toko ta yí, ta kponje gítí  wálá. Tacó yí a ꞌduù Gàlìléyà.» ");
INSERT INTO ndz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Káa Pìyétòrò giì ꞌvìsì có ji ꞌdakò tí nò máa, «Ye ꞌdi gbí ŋa có tí nò náa wò kû ꞌdè nò lá, kómbe ye!» Káa si sè có tí nò ká gbí nje Pìyétòrò, ngùù giì kò-kò. ");
INSERT INTO ndz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mbe tí ndoo máa giì ꞌdi gbí kò mì ngùù, yí giì da ṛo wó gítí Pìyétòrò. Mbí Pìyétòrò giì ꞌva tí có tí nó náa Mbe tí ndoo ꞌdè ji yí énó máa, «Wò wúnó bà ꞌboo ye ꞌvìlì taꞌô a kùṛo bà kò-kò mì ngùù,» nô. ");
INSERT INTO ndz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bìndi  Pìyétòrò giì co ꞌdo gbí òkò tí ndâ ꞌduù gbí ndùgù gí sè, yí giì wa gbí ta wotí tí  ta sé có tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ta o tí nò, ndâ ꞌduù tí nó náa à kaa ndú máa ndú ù ṛègbà tí Jézù nó giì dù kû ꞌviya yí, ta bà gbì yí. ");
INSERT INTO ndz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ndú giì eṛe ṛo wó ta bòngo gî. Bìndi  ndú giì dù kû ꞌviya yí si yí gbí sú ṛo énó máa, «Wò dú má káa mbe ꞌdòkò có mì Mbíṛì, nì ṛè ndâ ꞌduù tí nò mbe kû gbì wò nò ji ze gi!» ");
INSERT INTO ndz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ndú giì kili ꞌdáá gî kû go yí. ");
INSERT INTO ndz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yé mâ giì too gî, ndâ kpo-ꞌduù-ꞌbá, ta ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ mbe nìbà tàkìì mì ndâ Jùdéyà giì kili gî, bìndi  à giì ya ta Jézù gí gbí ngbàngà kùṛo ndú. ");
INSERT INTO ndz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ndú bà-i-nò giì ꞌviiki gbí nje wó máa, «Wò má a ꞌduù tí nó tí Bìndi-Mbíṛì nó, ꞌdè ji ze.» Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kpónó má ꞌdè có ji yo máa, ye a Bìndi-Mbíṛì, yo bà ùnje gítí có mì ye nò wálá. ");
INSERT INTO ndz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ye delè kpónó má ꞌvee yo, yo bà ꞌvìsì có ji ye wálá. ");
INSERT INTO ndz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Káa ꞌdo tí kpónó kû ya gí kùṛo, ꞌViì-mì-ꞌDakò bà ki tí wó gbí kùꞌbì mì Mbíṛì tí Mbe tí ndâ i ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ndâ kpo-kpò ꞌduù gbí ngbàngà mì ndâ Jùdéyà ꞌdáá gî bà-i-nò giì ꞌvee Jézù máa, «À má énò, wò a ꞌViì-mì-Mbíṛì, énó gi?» Káa Jézù giì ꞌvìsì có ji ndú máa, «A yo ká ꞌdè có énó máa, ye a ꞌViì-mì-Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ndâ kpo-kpò ꞌduù tí nò mâ giì ꞌdi có tí nò náa Jézù ꞌvìsì ji ndú nò, ndú giì ꞌbìtà bà ꞌvee tí ndú gbí òkò tí ndú máa, «Ndoo kpòò kû ù a ndi ꞌdi, máa, yí ꞌví gì gí bà ꞌdè có gítí wó ji ndoo, sé náa ndoo ꞌdi nò a yí  ꞌdo gbí ꞌdóó nje wó gî nó?» ");
INSERT INTO ndz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ndâ gba gbí gbolò ngbàngà mì ndâ Jùdéyà mâ giì ꞌviiki gbí có mí Jézù cee gî, ndú giì ꞌdaka yí, bìndi  ndú ꞌdáá gî giì kaa ta ndú ya gí kùṛo Pìlátò tí gbolò ꞌduù mì ndâ Ròmánò. ");
INSERT INTO ndz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ndú mâ giì yee ta Jézù kùṛo Pìlátò gî, ndú giì kpì ngbàngà tí wó ji Pìlátò énó máa, «Ze ꞌde ꞌdakò tí nó kuu nó tí vò mbe kû ŋònòkò muu ndâ ꞌduù, tacó wàa, ꞌbá mì ze ꞌví ꞌbu gî. Yí kû volo muu ndâ ꞌduù mì ze, tacó wàa, ndú ꞌví gò i ji ngáángbá gba mì ndâ Ròmánò lá. Yí kû bàkà tí wó máa, yì lá a Bìndi-Mbíṛì tí gbolò gba mì ndâ Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pìlátò mâ giì ꞌdi ndâ có tí nò, yí giì ꞌvee Jézù máa, «Wò a gbolò gba mì ndâ Jùdéyà?» Káa Jézù giì ꞌvìsì có ji Pìlátò máa, «A wò ká ꞌdè énò.» ");
INSERT INTO ndz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pìlátò bà-i-nò giì ꞌdè có ji ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, ta ndâ mbè ꞌduù tí nó mbe kaa gì tacó bà ꞌdi ngbàngà mì Jézù nó énó máa, «Ye ŋò ndeṛè bà waa có mì ye mítí ꞌdakò tí nó lá.» ");
INSERT INTO ndz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Káa ndâ gba mì ndâ Jùdéyà giì nanaka cèe muu ndú tacó wàa có ꞌví zèè Jézù, ta bà ꞌdè có ji Pìlátò énó máa, «Yí kû te mâ mí gbí muu ndâ ꞌduù ta bà nìbà i ji ndú cee gbí ndâ to Jùdéyà ꞌdáá gî, yí ꞌbìtà bà nìbà i tí  mì wó ꞌdo gbí ndâ to Gàlìléyà, káa yí kpónó kû yèè tí  gí Jèrùzàlémè bà-i-nô.» ");
INSERT INTO ndz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pìlátò bà-i-nò giì ꞌvee ndú énó máa, «ꞌDakò tí nó a ꞌduù ꞌdo gbí to ngàyi? ꞌDo gbí to Gàlìléyà?» ");
INSERT INTO ndz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pìlátò mâ giì ꞌdi énó máa, Jézù gì ꞌdo gbí to Gàlìléyà, yí giì tuu Jézù ya tí  gí kùṛo Èródè tí gbolò gba mì ndâ ꞌduù Gàlìléyà, tacó Èródè ta o tí nò kuu gbí gbata Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tàkòcò Èródè giì peteke gítí bà gì ta Jézù á gí kùṛo wó nò ngé ndii gî, tacó yí ꞌdo sàà kû ꞌdi káa ṛè Jézù ta cèe gbolò o, káa yí jé ŋò Jézù tí nò ta ṛo wó tí Èródè ta gbèe ṛì lá. Tàkòcò wó delè giì peteke, tacó yí ta o tí nò kû koṛo có énó máa, ndâ-ꞌbî-lá Jézù bà bàkà ndâ ꞌbí seṛè ji yì, wàa yí ꞌví ŋò ndú. ");
INSERT INTO ndz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tacó énò, yí giì ꞌvee gbí nje Jézù líkí-líkí énô. Káa Jézù giì biya bà njaa nje wó gí tàkò Èródè gbaànjé gî. ");
INSERT INTO ndz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mâ giì zekeꞌo, ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ mbe nìbà tàkìì mì ndâ Jùdéyà giì oloko gí yaà kû kpì ngbàngà tí Jézù ta wotí tí  ji Èródè. ");
INSERT INTO ndz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Èródè mâ giì ꞌdi ndâ có tí nò, ndú giì gbo ta ndâ àsìkérì mì wó kû mèèkèꞌi tí Jézù, ta bà ꞌviya yí. Bìndi  ndú giì yuu banga njà bòngo wùrù-wùrù ji yí, bìndi  ndú giì tuu ta yí kákáꞌi ya tí  ji Pìlátò. ");
INSERT INTO ndz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Gbí òkò tí ndâ Èródè ta Pìlátò sàà nìkì lá, káa ndú giì zèè kómbeè ta gbèe ṛi tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","À má giì dele ta Jézù ꞌdo ꞌbá mì Èródè gí gbí ngbàngà kùṛo Pìlátò kákáꞌi gî, Pìlátò giì kili ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò ꞌduù mì ndâ Jùdéyà, ta ndâ Jùdéyà ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bìndi  yí giì ꞌvee ndú énó máa, «Yo gì ta ꞌdakò tí nó gí kùṛo ye tacó máa, yí a mbe ŋònòkò muu ndâ ꞌduù. Káa ye ꞌde ꞌbí có gbaànjé mbe zèè yí ꞌdo gbí òkò ndâ có mì yo nò lá. ");
INSERT INTO ndz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Èródè delè giì tuu ndi wó gì tí  ji ndoo, tacó yí ꞌde vò i mì wó lá. Káa có ta ꞌvéṛè tí  wálá a ŋìnó máa, ꞌdakò tí nó bàkà vò i tacó wàa à ꞌví waa tí  ta có ku mítí wó nò gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","À má énò, ye bà waa có mítí wó énó máa à gbì yí gî, wàa ye ꞌví dò ꞌbì tí wó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ꞌBí ŋa i náa Pìlátò kû bàkà ta ndoò ꞌdáá gî ta o gbolò o bà bàkà tàkìì bà mèlè ndi o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì a bà njaanga ꞌduù gbaànjé ꞌdo gbí zàà ji ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Káa ndâ ꞌduù gbí ngbàngà ꞌdáá gî giì a ta kû dòmùù énó máa, «Zi yí gî! Njaanga Bàrábà ji ze!» ");
INSERT INTO ndz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(À zèè ꞌdakò tí nò tí Bàrábà nò mí gbí zàà, tacó ꞌbí ŋa wo mbe bàkà tí gbí gbata ta o tí nò, delè tacó bà zi ku.) ");
INSERT INTO ndz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","À gbí muu Pìlátò ta o tí nò kpolo ma a có bà dò ꞌbì tí Jézù; tacó énò, yí giì ꞌdè có ji ndâ ꞌduù kákáꞌi. ");
INSERT INTO ndz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Káa ndâ ꞌduù giì ꞌvìsì có ji Pìlátò ta kû énó máa, «Gbì yí mítí njèèkpè mû! Gbì yí mítí njèèkpè mû!» ");
INSERT INTO ndz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bà taꞌô ŋìnó, Pìlátò giì ꞌvee ndâ ꞌduù énó máa, «Tacó yè? Yí volo a yè? Yo ꞌdè ji ye, tacó ye ŋò vò i mì wó wàa ye ꞌví waa ta có ku mítí wó nò lá. À má énò, ye bà waa có mítí wó énó máa, à gbì yí, wàa ye ꞌví dò ꞌbì ye ꞌdo tí wó gî.» ");
INSERT INTO ndz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ndâ ꞌduù mâ giì ꞌdi có tí nò náa Pìlátò ꞌdè ji ndú nò, ndú giì mìì ta kû goòlá a ꞌbí ŋa gbolò có ku ká gì ji ndú ꞌdo bà ꞌbí to, ta bà ꞌdè có ta ꞌbê ji Pìlátò énó máa, yí gbì Jézù mítí njèèkpè mû. Wo mì ndâ ꞌduù mâ giì co muu Pìlátò gî, ");
INSERT INTO ndz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","yí giì waa có ku mítí Jézù go có mì ndú nò. ");
INSERT INTO ndz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bìndi  yí giì njaanga ꞌdakò tí nó tí Bàrábà, náa à zèè yí tacó bà pìì wo ta bà zi ku nó, ꞌdo gbí zàà gí sè go có mì ndâ ꞌduù tí nò. Yí bà-i-nò giì je Jézù ji ndú énó máa, ndú bàkà ta yí go có mì ndú náa à gbí njembí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Káa si ndâ ꞌduù tí nò kû giì co ta Jézù ꞌdo gbí gbata gí sè tacó bà ya ta yí gítí bàndò bà zi yí, ndú giì ꞌde ꞌbí ꞌdakò ta ṛè wó a Sìmónè, ta ꞌbá mì wó gbí gbata Sìrínì, á kpokèjì kû gì gí gbí gbata Jèrùzàlémè. Ndú bà-i-nò giì zèè yí ta wotí gítí bà te njèèkpè mû tàkò Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ndâ niì gbí òkò tí ndâ mbè ꞌduù tí nó mbe kaa mòsùù kû ko tàkò Jézù nó ta o tí nò kû tò kû ta bà wa gbí. ");
INSERT INTO ndz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jézù giì ꞌvìsì tí wó, bìndi  yí giì ꞌdè có ji ndâ niì tí nò mbe kû wa gbí nò énó máa, «Ndâ jú Jèrùzàlémè, yo wa ye lá. Yo wa tí yo, wàa yo ꞌví wa ndâ ꞌviì mì yo. ");
INSERT INTO ndz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tacó ndâ ꞌbí o wúnò ká kèjì náa ndâ ꞌduù bà ꞌvìsì nje ndú énó máa, ‹Ndâ niì tí nó tí ndâ kázá, náa ndú jé tè nakáyì lá, náa ꞌviì delè jé no kí ndú lá nó, a ndâ mbe tó pá!› ");
INSERT INTO ndz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndâ ꞌduù gbí ndâ o tí nò bà ꞌdeke tí ndú ji ndâ kpo-kpò gú énó máa, ‹Yo ꞌvaka tí yo mí muu ze!› Ndú delè bà ꞌdeke tí ndú ji ndâ gú, máa, ‹Yo ꞌbuku tí yo mí muu ze!› ");
INSERT INTO ndz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tacó cè bà bàkà i mì ndâ ꞌduù ta mû si mû tí nò gbí ꞌve wó má ká énó, mû tí nò má aanga gî, ndú bà bàkà tí  a ŋa ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","À ta o tí nò kaa ndâ ꞌbí vò ꞌduù sósòꞌô ꞌdo gbí gbata tacó bà ya ta ndú gí bà ziki ndú gbí gbèe nó bà ya ta Jézù tacó bà zi yí nò. ");
INSERT INTO ndz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ndâ àsìkérì mâ giì yee ta ndâ Jézù ta ndâ vò ꞌduù tí nò tí ꞌbí bàndò náa à kû nì mítí  a Kù-ꞌbilì-muu-ku gî, ndú giì gbì Jézù mítí njèèkpè mû, bìndi  ndú giì gbì ꞌbí ꞌduù gbaànjé á ꞌdo gbí òkò tí ndâ vò ꞌduù tí nò sósòꞌô nò mítí njèèkpè mû mò gí gbí kùꞌbì mì wó, bìndi  ndú giì gbì ꞌbí  mítí ꞌbí njèèkpè mû mò gí gbí gàlì mì wó. ");
INSERT INTO ndz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Káa Jézù giì ꞌdeke tí wó ji Mbíṛì si yí tí njèèkpè mû tacó tí ndâ ꞌduù tí nó mbe mèèkèꞌi tí wó nó énó máa, «Je à-cee-gî ji ndú, Bu ye! Tacó ndú ŋò i tí nó náa ndú kû bàkà nó ni lá.» Ndâ ꞌduù tí nò mbe gbì Jézù mítí njèèkpè mû nò giì ki-mbílì tacó bà njèè gbí ndâ bòngo bìndi wó. ");
INSERT INTO ndz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","À mâ giì gbì Jézù mítí njèèkpè mû gî, ndâ ꞌduù giì dù jé kû ù ndi bà ŋò ŋa i tí nó á kèjì gí bà bàkà tí nô. Káa ndâ kpo-kpò ꞌduù giì dù kû ŋo yí ŋó-ŋo énó máa, «Yí táánò kû ꞌvala ndâ ꞌbí ka wó, si yí ꞌví ꞌvala tí wó, náa yí má a Bìndi-Mbíṛì, tí ꞌduù tí nó náa Mbíṛì ká cu ꞌbì mítí wó nò.» ");
INSERT INTO ndz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ndâ àsìkérì delè giì dù kû ŋo yí si ndú kû je ꞌbí ŋa ngo i jàngà-jàngà énó ji yí. ");
INSERT INTO ndz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ndú delè giì dù kû ꞌviya yí énó máa, «Wò dú má káa gbolò gba mì ndâ Jùdéyà, ꞌvala tí lo.» ");
INSERT INTO ndz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ndú ꞌdè có tí nó tacó à cu mítí njèèkpè mû á còmuu Jézù énó máa, «Ŋìnó a gbolò gba mì ndâ Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ꞌBí ꞌduù gbaànjé á ꞌdo gbí òkò tí ndâ vò ꞌduù tí nó sósòꞌô náa à gbì ndú mítí njèèkpè mû nó giì lè Jézù énó máa, «Wò me Bìndi-Mbíṛì lá? ꞌVala tí lo, wàa wò ꞌví ꞌvala ze delè.» ");
INSERT INTO ndz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Káa ka vò ꞌduù tí nò giì do ta yí énó máa, «Wò cì gúku tí Mbíṛì lá tacó yè? À kpónó waa có mítí yo ta yí me ꞌvii ká ꞌvii lá? ");
INSERT INTO ndz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","À waa có mítí ndà ká dú. Ndà kû cì nó muu vò i mì ndà. Káa ꞌdakò tí nó kû cì a ꞌve ku.» ");
INSERT INTO ndz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ꞌDakò tí nò mâ giì do mítí ka wó mbe ngbà cee gî, yí giì ꞌdeke tí wó ji Jézù énó máa, «Wò má yee ꞌbá gba mì lo gî, wò ꞌví koṛo có tí ye, Jézù.» ");
INSERT INTO ndz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Káa Jézù giì ꞌvìsì có ji yí máa, «Ye kû ci nó a wò ta kponje gítí  wálá énó máa, ndà wúnó bà dù ta ndà gbí dà.» ");
INSERT INTO ndz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ṛi mâ giì dooko gítí bà gì gbúrú gî, ṛo ṛi giì ꞌdi gî. ꞌDíꞌdiꞌo giì yiiga muu to ꞌdáá yùkúú gî, yee tí bà mò tí mì ṛi. ");
INSERT INTO ndz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ta o tí nò si ṛo ṛi ꞌdi tí  gî nò, gbí kpâ-bòngo tí nó náa à njèè ta gbí tàꞌi ꞌbá-Mbíṛì nó giì yaka gbí tí ꞌdo yaà dí to. ");
INSERT INTO ndz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Bìndi  Jézù giì tò kû ta kòcò wó ngé gí yaà énó máa, «Ye si tí ye ji wò gî, Bu ye!» Bìndi bà ꞌdè có tí nò, njembí Jézù giì ki gî. ");
INSERT INTO ndz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ꞌBí kùṛo ndâ àsìkérì mâ giì zeke ŋa i tí nò mbe kû bàkà tí nò, yí giì ùlù Mbíṛì, bìndi  yí giì ꞌdè có énó máa, «ꞌDakò tí nó táánò dú káa yê sínò ta vò i mì wó ta ndâ ꞌduù kùṛo Mbíṛì wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ndâ mbè ꞌduù tí nó mbe tì bìnjìì kû zeke ŋa i tí nò nó giì njè kû ya gí ꞌbá mì ndú ꞌdáá ta ꞌbì ndú tí njembí ndú kû nì nikalaká. ");
INSERT INTO ndz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ndâ kómbe Jézù ta ndâ niì tí nó mbe ko tàkò wó ꞌdo Gàlìléyà nó giì ṛò tíyò janga-jàngáá gí ndiì kû zeke ndâ ŋa i tí nò náa a kû me ta yí nò. ");
INSERT INTO ndz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jézù mâ giì cì gî, ꞌbí ꞌdakò ta ṛè wó a Jùzépè, mbe gì ꞌdo gbí gbata Àrìmàtíyà tí ꞌbí gbata mì ndâ Jùdéyà, tí tó kpo ꞌduù, ta ndâ có mì wó ká jáá gbí gbolò ngbàngà mì ndâ Jùdéyà, ");
INSERT INTO ndz_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","mbe yuu nje wó mí gbí ndâ có tí nó náa ndâ ka wó kû toko gítí Jézù nò lá, delè ꞌbì wó yuu tí mí gbí ndâ i tí nò náa ndú kû bàkà nò lá, tí ꞌduù mbe kû ùndi bà ŋò o bà gì Mbíṛì gí bà dù tí gba muu to tí nó, ");
INSERT INTO ndz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","giì ya gí bà ꞌdeke tí wó ji Pìlátò, tacó wàa yí ꞌví si yì ꞌví te ku Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pìlátò mâ giì ùnje ji yí gî, Jùzépè giì dele ndi wó ya gí bà ja ku Jézù ꞌdo tí njèèkpè mû gí to. Yí mâ giì yili yí ta bòngo gî, yí giì te yí ya tí  gí gbí ꞌbí ngú gbolò gùù náa yí duu mí gbí díí, náa à jé duu ku mí gbí  kùṛo lá. ");
INSERT INTO ndz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","I tí nò bàkà tí si ndâ ꞌduù kû ꞌviindi tí ndú gítí ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Káa si à kû te ku Jézù ya tí  gí gbí gùù, ndâ niì tí nó náa ndú gì ta ndú ꞌdo Gàlìléyà nó kû ko tàkò ndâ mbe te ku, tacó bà ŋò bàndò bà duu yí. ");
INSERT INTO ndz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ndú mâ giì ŋò bàndò tí nò gî, ndú giì kaa ya gí bà ꞌviindi ndâ yeè ta bà bàkà ndâ pó bàà; bìndi  ndú giì tè wo ndú ta ṛi bà wotí go i gbí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Si yé kû giì me ngbòò á bìndi ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà, ndâ niì tí nó mbe ŋò bà bàndò bà duu Jézù gî nó giì gboꞌo ta ndâ yeè, ta ndâ pó bàà tí nó náa ndú bàkà ta ꞌdêꞌo kùṛo ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà nó, ya gí muuꞌdú Jézù. ");
INSERT INTO ndz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ndú mâ giì yee kà, ndú giì ꞌde à mèṛèkè gbolò díí tí nó náa à nè ta njekèjì ꞌbá muuꞌdú nó ꞌdo njekèjì gî. ");
INSERT INTO ndz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ndú mâ giì ṛì gí tàꞌi kà, ndú giì ꞌde ku Mbe tí ndoo Jézù gbí gùù lá. ");
INSERT INTO ndz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ndú giì ṛò tíyò tà ꞌbá muuꞌdú kà ta có náa ndú bà ꞌdè gbí nje ndú wálá. À giì zi ndi ndú ta gúku ngé gî a ŋìnó náa ndú giì gu káa ndiì ta ndâ ꞌbí ꞌdakò sósòꞌô mbe yuu ndâ bòngo mbe kû tòngbaà go bà ì mù nó, kû ṛò tíyò á ṛègbà tí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gúku bà ŋò ndâ ꞌdakò tí nò giì zèè ndâ niì tí nò tí ŋa ŋìnó náa ndú giì mò muu ndú kû zekeꞌo ká gí to. Káa ndâ ꞌdakò tí nò giì ꞌvee ndú máa, «Yo kû pà bà tí wu ꞌduù gbí òkò tí ndâ ku tacó yè? ");
INSERT INTO ndz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ꞌDakò tí nò náa yo kû pà bà tí wó nò bà-i-nó wálá. Yí a gí yaà gî. Yo koṛo muu yo gítí có tí nó náa yí táánò ꞌdè ji yo si yí Gàlìléyà ");
INSERT INTO ndz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","énó máa, ‹À wúnò bà je ꞌViì-mì-ꞌDakò mí ꞌbì ndâ ꞌduù tí nó mbe bàkà vò i ndii muu ndú gî nô. Ndâ ꞌduù tí nò bà zi yí ta bà gbì yí mítí njèèkpè mû, káa bìndi sili taꞌô, yí bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî,› nô.» ");
INSERT INTO ndz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ndâ niì tí nò mâ giì ꞌdi có tí nò náa ndâ ꞌdakò tí nò ꞌdè ji ndú nò, mbí ndú giì ꞌva tí ndâ có mì Jézù nò gî. ");
INSERT INTO ndz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ndâ niì tí nò mbe ya gí bà gala muuꞌdú Jézù nò giì dele ndi ndú ꞌdo muuꞌdú ya gí bà ꞌvanda ndi i tí nó mbe ꞌde ndú nó ji sè ndâ tú mì Jézù muuꞌbì-nje gbaànjé nó, ta ndâ sè ndâ ꞌbí mbe tala có mì Jézù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ndâ niì tí nò mbe ꞌvanda ndi ndâ có tí nò ji ndâ tú mì Jézù a ndâ Màríyà Màdèlénà, ta ꞌbí niì ta ṛè wó a Jòwánà, giì je Màríyà tí nó tí nawu Jákòmò nô. Ndâ ꞌbí ka ndú niì náa ndú gboꞌo ya gí bà gala muuꞌdú Jézù ta ndú nó delè giì ꞌvanda káa gbèe kòcò ndú nò. ");
INSERT INTO ndz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Káa ndâ có mì ndú ꞌdáá gî giì dù gbí tù ndâ tú mì Jézù ꞌdáá gî ká go cèe mòngò gbí tù bô. ");
INSERT INTO ndz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","A Pìyétòrò ká giì co ta ngèlè ya gí muuꞌdú tacó bà ꞌdi gbí ꞌvéṛè mì ndâ niì tí nò. Yí mâ giì yee kà, yí giì mò tí wó gí to, bìndi  yí giì zekeꞌo gí tà ꞌbá muuꞌdú, yí giì ŋò káa bòngo tí nó náa à duu ta Jézù nó gbí gùù ta ꞌduù gbí  wálá. Yí bà-i-nò giì dele ndi wó ya gí ꞌbá ta có bà ꞌdé-ꞌdè nje wó wálá. ");
INSERT INTO ndz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta gbèe ṛi bà ꞌde kùnga gùù bìndi Jézù nò, ndâ ꞌbí mbe tala có mì Jézù sósòꞌô giì njè nó ꞌdo Jèrùzàlémè kû ya gí Èmáwùsù, tí ꞌbí to mbe mò gí bà co ṛi á dê ta Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Káa si ndú kuu muu nó, ndú kû giì ꞌdè nje gítí ndâ i tí nó mbe bàkà tí Jèrùzàlémè nô. ");
INSERT INTO ndz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Káa si ndú kû ꞌdè nje, ta bà ꞌviiki gbí ndâ i tí nò, Jézù giì co kû gbo kpokèjì ta ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Káa ꞌbí i giì dù káa yoo ṛo ndú ꞌdo tí bà ŋò yí mì ndú ni gî. ");
INSERT INTO ndz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ŋìnò káa bà giì dù Jézù bà-i-nò giì ꞌvee ndú énó máa, «Yo kû nò ta bà ꞌviiki a gbí có gítí ŋa yè?» Ndâ ꞌdakò tí nò mâ giì ꞌdi ŋa ꞌvé tí nò náa Jézù ꞌvee ta ndú nò, ndú giì ṛò tíyò ngbi-ngbìì, ta zúú-zuu gbí ṛo ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Bìndi  ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ꞌdakò tí nò ta ṛè wó a Kìlìyópà giì ꞌvìsì có ji Jézù énó máa, «Ye koṛo có énó máa, gbèe ꞌduù á Jèrùzàlémè mbe ꞌdi có gítí ndâ i tí nó mbe kû bàkà tí gbí ndâ sili tí nó lá bà dù káa wò.» ");
INSERT INTO ndz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jézù bà-i-nò giì ꞌvee Kìlìyópà máa, «A ndâ yè ká bàkà tí?» Káa ndâ Kìlìyópà giì ꞌvìsì có ji yí máa, «Ndâ i tí nó ꞌdáá mbe bàkà tí mítí Jézù tí nó mbe gì ꞌdo Názàrètì nô. Yí táánò tùbà tí wó tí gbolò mbe ꞌdòkò có mì Mbíṛì ta bà ꞌdè có, delè ta bà bàkà ndâ i go i mì ꞌdakò mí kùṛo Mbíṛì, delè mí kùṛo ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wò ꞌdì có bà kpì ngbàngà tí wó mì ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-kpò ꞌduù mì ndoo énó máa, à waa có ku mítí wó, bìndi  a giì zi yí ta bà gbì yí mítí njèèkpè mû gî, nó lá? ");
INSERT INTO ndz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ze táánò kû koṛo có lì ká mítí ꞌdakò tí nò énó máa, a yí ká bà njaanga wú ꞌdo tí miṛi ndâ Ìzìrìyélì. Káa có kpónó cuki me káa ŋìnò lá. Ngú có mbe kpò nje ze gî kpónó a ŋìnó máa, à wúnó a sili taꞌô á bìndi bà bàkà tí mì i tí nò, ");
INSERT INTO ndz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","káa ndâ ꞌbí niì gbí òkò tí ze kùtàá mâ giì gboꞌo ya gí bà gala muuꞌdú wó ta dúꞌo nó, ");
INSERT INTO ndz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ndú giì dele ndi ndú gì gí bà ꞌdè có ji ze énó máa, ndâ yì ꞌde ku wó gbí gùù lá. Káa à lá ndíi a ndâ basìlì mì Mbíṛì ká giì co mítí ndâ yì, bìndi  ndú giì ꞌdè có ji ndâ yì énó máa, yí a wuù! ");
INSERT INTO ndz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ndâ ꞌbí kómbe ze giì kaa ya gí bà ŋò muuꞌdú, tacó bà ꞌdi gbí ꞌvéṛè mì ndâ niì tí nò, káa ndú giì da a kùnga to á go có mì ndâ niì tí nò.» ");
INSERT INTO ndz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Káa Jézù giì ꞌvìsì có ji ndâ Kìlìyópà énó máa, «Ákoo ndâ ŋónókó! Yo me duù gítí bà ùnje gítí ndâ có tí nó ꞌdáá náa ndâ mbe ꞌdòkò có mì Mbíṛì ꞌdè nó tacó yè? ");
INSERT INTO ndz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kòcò ndâ mbe ꞌdòkò có mì Mbíṛì ji yo me énó máa, kózò tí Bìndi-Mbíṛì bà kònò a séꞌi má kózò gî, yí bà giì ki tí wó pí jàlàmbà lá?» ");
INSERT INTO ndz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jézù bà-i-nò giì ꞌbìtà bà ꞌdè gbí ndâ có tí nó ꞌdáá náa à cu gítí wó tí Jézù mí gbí wáràgà mì Mbíṛì nó ꞌdo tí ndâ có mì Mòze, giì co tí ndâ có mì ndâ mbe ꞌdòkò có mì Mbíṛì ꞌdáá gî ji ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ndâ Jézù mâ giì dooko ta ꞌbá mì ndâ Kìlìyópà gî, Jézù giì bàkà tí wó go ꞌduù ŋìnó mbe kû ndii ya gí kùṛo nô. ");
INSERT INTO ndz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Káa ndâ Kìlìyópà giì ꞌdè có ji yí máa, «Ndoo ne gí ꞌbá mì ze, tacó o dooko gítí bà bèè gî.» Jézù mâ giì ùnje gî, ndú giì ne ta ndâ Kìlìyópà gí ꞌbá mì ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Káa si ndú kû giì ꞌbìtà bà zò i, Jézù giì zèè kù kô mí ꞌbì wó, yí mâ giì ꞌdeke tí wó ji Mbíṛì gî, yí giì kiꞌviki gbí kù kô tí nò, bìndi  yí giì kaa ji ndâ Kìlìyópà. ");
INSERT INTO ndz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ṛo ndâ Kìlìyópà giì da gítí bà ŋò Jézù ni si ndú ta ndú ṛègbà i-zó-zò nò gî. Káa yí giì dù ká to nò giṛi ꞌdo ṛo ndú gî. ");
INSERT INTO ndz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ndâ Kìlìyópà bà-i-nò giì ꞌbìtà bà ꞌvee tí ndú gbí òkò tí ndú si Jézù giṛi ꞌdo ṛo ndú gî nó énó máa, «Njembí ndà wálá kùtàá kû mù si yí kû ꞌdè gbí ndâ có gbí wáràgà mì Mbíṛì ji ndà á si ndoo ta ndú kpokèjì nó?» ");
INSERT INTO ndz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ndâ Kìlìyópà ngé bà-i-nò giì zèè kpokèjì kû dele gí mì sè ndâ tú mì Jézù muuꞌbì-nje gbaànjé nó, ta sè ndâ ꞌbí kómbe ndú Jèrùzàlémè. Ndú mâ giì yee kà, ndú giì ꞌde ndú kili ꞌdáá mí bà gbèe to. ");
INSERT INTO ndz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bìndi  ndâ ꞌduù tí nò giì ꞌdè có ji ndâ Kìlìyópà, máa, «A yúcó máa Mbe tí ndoo ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî! Yí delè giì tùbà tí wó ji Sìmónè gî.» ");
INSERT INTO ndz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bìndi  ndâ Kìlìyópà giì dìtà ndâ i tí nó mbe bàkà tí mì ndú si ndú kpokèjì kû ya gí ꞌbá mì ndú Èmáwùsù nó, ta bà ŋò Jézù ni mì ndú si ndú kû zò i nó ji ndâ ka ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Káa si ndâ Kìlìyópà kû ꞌvanda có ji ndâ ka ndú mbe tala có mì Jézù, ndú mâ giì zekeꞌo, ŋìnó a ꞌdi ká nó? Jézù jéé kû ṛò tíyò gbí òkò tí ndú! Bìndi  Jézù giì ꞌdè có ji ndú máa, «Yo dù nìkì maa!» ");
INSERT INTO ndz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lilí ndâ mbe tala có mì Jézù bà-i-nò giì oloko ꞌdo tí ndú ta gúku gî. Ndú giì koṛo có máa a vuuvuu ká co mítí ndâ yì. ");
INSERT INTO ndz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Káa Jézù giì ꞌvee ndú máa, «Yo kû cì gúku tacó yè? Yo kû koṛo có sàkàmàà tacó yè? ");
INSERT INTO ndz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yo zeke ndâ kpázà ꞌbì ye, ta ndâ kpázà kò ye, tacó wàa yo ꞌví ŋò tí  ni énó máa, ŋìnó a ye ká nô. Yo tee ꞌbì yo mítí ye, tacó wàa yo ꞌví ŋò tí  ni énó máa, ŋìnó a ye, tacó dìì tí vuuvuu wálá, delè ꞌbilì vuuvuu á go ŋìnó náa yo kû ŋò tí ye nó wálá.» ");
INSERT INTO ndz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jézù ꞌdè ndâ có tí nò ji ndâ mbe tala có mì wó nò ta bà tù ndâ kpázà ꞌbì wó, ta ndâ kpázà kò wó ji ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Líkíꞌo bà ŋò ni énó máa, ŋìnò a Jézù, giì bàkà ndú tí ŋa ŋìnó náa bà ùnje énó máa, ŋìnò a Jézù, giì kpò ndú gî. Ndú giì ṛò tíyò juku-jùkùù, ta có ŋìnó náa ndú bà ꞌdè gbí nje ndú nó wálá. Jézù bà-i-nò giì ꞌvee ndú máa, «ꞌBí i-zó-zò mì yo bà-i-nó wálá?» ");
INSERT INTO ndz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ndú bà-i-nò giì je yú sè ji yí, ");
INSERT INTO ndz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","bìndi  yí giì zò mí kùṛo ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jézù giì ꞌdè ndòngbú có ji ndâ tu mì wó énó máa, «Ŋìnó a gbí ndâ có mì ye náa ye táánò ꞌdè ji yo si mì ndoo ta ndoo énó máa, kózò tí ndâ có tí nó ꞌdáá náa ndâ Mòze, ta ndâ mbe ꞌdòkò có mì Mbíṛì, ta ndâ Muu-cè, cu mí gbí ndâ wáràgà mì ndú, bà bàkà tí nó ká nô.» ");
INSERT INTO ndz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yí bà-i-nò giì njaanga muu ndú gítí bà ꞌdi gbí ndâ có gbí wáràgà mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Bìndi  yí giì ꞌdè có ji ndú máa, «Nògí, a có tí nó náa à cu mí gbí wáràgà mì Mbíṛì énó máa, kózò tí Bìndi-Mbíṛì bà kònò séꞌi, káa bìndi sili taꞌô yí bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî, ");
INSERT INTO ndz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tacó wàa à ꞌví ma ndâ có gítí bà ꞌvìsì muu ndâ ꞌduù ꞌdo tí ndâ vo-vò kpokèjì kèjì mì ndú, ta có gítí bà je à-cee-gî mì Mbíṛì gítí ndâ vò i mì ndâ ꞌduù, ji ndâ ꞌduù muu to tí nó ꞌdáá ta ṛè wó. Nèté bà ma ndâ có tí nò ꞌví ꞌbìtà tí ꞌdo Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yo bà dù tí ndâ mbe ma ndâ có tí nò. ");
INSERT INTO ndz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ye bà tuu i tí nó náa Bu ye táánò ci yo gítí  nó ji yo. Káa yo ꞌví dù gbí gbata Jèrùzàlémè yee tí o tí nó náa à má je wotí ji yo ꞌdo gbíṛì má kózò gî.» ");
INSERT INTO ndz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jézù giì kaa ndâ tú mì wó ꞌdo Jèrùzàlémè, ndú giì ya ta ndú ngé gí sè ꞌdo gbí gbata Bètánìyà. Yí mâ giì yee ta ndú tí bàndò tí nò gbí muu wó nò gî, yí giì kaa ꞌbì wó gí yaà ji Mbíṛì, bìndi  yí giì cù ꞌdê ngo cù wó mítí ndú. ");
INSERT INTO ndz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yí mâ giì cù ꞌdê ngo cù wó mítí ndú gî, gbí òkò tí ndú giì njèè ta ndú ta bà te yí ya tí  gí gbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ndâ tú mì wó giì ùlù yí, bìndi  ndú giì dele ndi ndú gí Jèrùzàlémè ta líkíꞌo tí ndú ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ndú giì dù kû ya gí gbí ndùgù ꞌbá-Mbíṛì tacó bà ùlù Mbíṛì ta o ꞌdáá gî.");
INSERT INTO ndz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Có táánò sàà kuu tí  á kùṛo o bà suu to tí nô; có táánò kû dù a i mì ndú ta Mbíṛì. Có ꞌdo sàà táánò káa Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ndâ Có táánò ta Mbíṛì ta o bà ꞌbìtà bà suu ndâ i. ");
INSERT INTO ndz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Wotí bà suu ndâ i táánò ꞌdáá gî a i ꞌbì Có; ꞌbí i gbaànjé táánò mbe bàkà tí muu to tí nó á kapí ṛo Có nò wálá. ");
INSERT INTO ndz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Có táánò a ṛèngbó ꞌválá; ꞌválá tí nò mì Có nò táánò a ngbaꞌo ji ndâ ꞌduù ꞌdáá gî, ");
INSERT INTO ndz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","tí ngbaꞌo ŋìnó mbe tùngbaà gbí ꞌdíꞌdiꞌo, tí ngbaꞌo ŋìnó náa ꞌdíꞌdiꞌo kpò yí lá. ");
INSERT INTO ndz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mbíṛì táánò giì tuu ꞌbí ꞌdakò ta ṛè wó a Jòvánì, ");
INSERT INTO ndz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","tí mbe ꞌdè yúcó ji ndâ ꞌduù. Mbíṛì táánò tuu yí gí bà ꞌdè yúcó gítí Ngbaꞌo, tacó wàa, ndâ ꞌduù ꞌdáá gî ꞌví ù ta nje gítí Ngbaꞌo á ꞌdo gbí có mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jòvánì táánò me Ngbaꞌo lá; yí táánò a ꞌduù sínò, tí mbe ꞌdè yúcó gítí Ngbaꞌo. ");
INSERT INTO ndz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Có táánò, tí cèe Ngbaꞌo mbe njaanga muu ndâ ꞌduù ꞌdáá gî nó kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yí táánò kuu muu to tí nô, to tí nó náa Mbíṛì táánò je wotí ji yí bìndi  yí giì suu nô, káa ndâ ꞌduù muu to tí nó táánò ꞌdáá gî ŋò yí ni lá. ");
INSERT INTO ndz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yí táánò gì gí ꞌdóó ꞌbá mì ndú, káa ndâ ꞌdóó-ꞌdòò nambe wó si yí tí i lá. ");
INSERT INTO ndz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kpêtí ká énò, yí giì je wotí bà gì tí ndâ ꞌviì mì Mbíṛì ji ndâ mbe si yí tí i, mbe tee njembí ndú mítí wó nó gî. ");
INSERT INTO ndz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ṛèngbó bà dù ndú tí ndâ ꞌviì mì Mbíṛì nò me ꞌdo muu to tí nó lá, à ꞌdo me gbí bà toko bà sili mì ndâ ꞌdakò ta niì lá, à delè giì dù me ꞌdo gbí go bà jò ṛè ndâ ꞌduù lá, à káa Mbíṛì ká bàkà ndú tí ndâ ꞌviì mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Có táánò gì tí ꞌduù go ndoo, bìndi  yí giì ꞌvala gbí òkò tí ndoo muu to tí nó, tí gbolò mbe nambeè, delè tí gbolò mbe ꞌdè yúcó. Ze táánò ŋò ŋa bà tòngbaà mì wó, tí ngba gbèe ꞌViì-mì-Mbíṛì ta ꞌbí ŋa ꞌviì go yí mì Bu wó wálá gî. ");
INSERT INTO ndz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jòvánì táánò gì kû kò-kò ta ṛè Có ji ndâ ꞌduù, máa, «Ŋìnó a ꞌduù tí nó náa ye táánò kû ꞌdè có ta ṛè wó ji yo máa, ‹ꞌDuù tí nó kèjì gí tàkò ye nó a gbolò ꞌduù ndii ye gî, tacó yí táánò kû ꞌvala kùṛo o bà jò ye.› » ");
INSERT INTO ndz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yí kû bàkà nambeè ji ndoo ꞌdáá gî, tacó nambeè gbí yì wó me gbolò ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mbíṛì táánò tuu a Mòze ta ndâ có mì wó ji ndâ ꞌduù, bìndi  yí giì tuu a Có tí Jézù, tí Bìndi wó tí Mbíṛì gí bà bàkà nambeè ji ndâ ꞌduù, delè gí bà ꞌdè yúcó ji ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ꞌBí ꞌduù jé mbe ŋò Mbíṛì ta ṛo wó ta gbèe ṛi muu to tí nó wálá, à káa gbèe ꞌViì-mì-Mbíṛì ta ŋa wó wálá, tí wú-gbí-ṛé Bu wó, ká tùbà tí Mbíṛì ji ndoo. ");
INSERT INTO ndz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ta ꞌbí o gbaànjé, ndâ kpo ꞌduù mì ndâ Jùdéyà giì tuu ndâ ꞌbí bu-Mbíṛì mì ndâ Jùdéyà ta ndâ ꞌbí mbe kû konì ndâ bu-Mbíṛì ta nèté, ꞌdo Jèrùzàlémè, máa, ndú ya gí bà ꞌvee Jòvánì máa, yí a ꞌdi wè? Wàa ndú ꞌví gì ta ndi kòcò wó ji ndâ yì. ");
INSERT INTO ndz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ndâ bu-Mbíṛì tí nò mâ giì ya gí bà ꞌvee Jòvánì go có tí nó náa ndâ kpo ꞌduù mì ndú tuu ta ndú nò, Jòvánì giì ꞌdè ꞌvéṛè ji ndú lá, yí giì ꞌdè có ji ndú ngbáṛángàꞌi énó máa, «Ye me Bìndi-Mbíṛì lá.» ");
INSERT INTO ndz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Káa ndâ bu-Mbíṛì tí nò giì ꞌvee yí kákáꞌi máa, «Má énò, wò a Èlíjà tí nó táánò tí mbe ꞌdòkò có mì Mbíṛì nó wàà?» Káa Jòvánì giì ꞌvìsì có ji ndú máa, «Ye me Èlíjà tí nò delè lá.» Bà taꞌô ŋìnó, ndâ bu-Mbíṛì tí nò giì ꞌvee Jòvánì máa, «Wò ꞌví dù a gbolò mbe ꞌdòkò có mì Mbíṛì tí nó náa Mòze dígísèé ci ndâ ká gù ndoo máa Mbíṛì bà tuu yí ji ndú nó wàà?» Káa Jòvánì giì ꞌvìsì có ji ndú máa, «Ngé lá! Ye me yí lá.» ");
INSERT INTO ndz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ndâ bu-Mbíṛì tí nò giì ꞌvee Jòvánì máa, «À má énò, wò a ꞌdi? Tacó ze má dele ta ndi ze ya gí ꞌbá, wàa ze ꞌví ꞌdè ta ndi kòcò lo ji ndâ ꞌduù tí nó mbe tuu ze nô, ze dele ndi ze ya gí bà ꞌdè có ji ndú énó máa, wò a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Káa Jòvánì giì ꞌvìsì có ji ndú máa, «Ye a ꞌduù tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì dígísèé ꞌdè kòcò ta wotí mì Mbíṛì gítí wó máa, ‹Kòcò ꞌduù kû kò-kò gbí kángáá nga ngoò, máa, yo bàkà kpokèjì mì Mbe tí yo jáá nô.› » ");
INSERT INTO ndz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","À ta o tí nò tuu ndâ bu-Mbíṛì tí nò ya tí  ji Jòvánì a ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tacó énò, ndú giì ꞌvee Jòvánì máa, «Wò me Bìndi-Mbíṛì lá, wò me Èlíjà lá, wò delè me mbe ꞌdòkò có mì Mbíṛì tí nó mì Mòze náa yí ꞌdè có gítí wó nó ká lá. À má énò, wò kû caka tí ndâ ꞌduù tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Káa Jòvánì giì ꞌvìsì có ji ndú máa, «Ye kû caka tí ndâ ꞌduù ta ngo, káa, ꞌbí ꞌduù kpónó kû ṛò tíyò kuu gbí òkò tí yo nò káa yo ŋò yí ni lá, ");
INSERT INTO ndz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ká bà giì gì gí tàkò ye. Yí a ꞌduù mbe me gbolò ndii ye tí ŋa ŋìnó náa à kpêtí káa bà dù tí vòó mbe kû njaanga tàmà ꞌdo tí kò wó sínò, ye bà ꞌde wotí tí ye gítí  wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ndâ kpo ꞌduù mì ndâ Jùdéyà tuu ndâ bu-Mbíṛì mì ndú nò ji Jòvánì si yí gbí gbata Bètánìyà a tìto Jòròdánìyà kû caka tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jòvánì mâ giì zekeꞌo ta ꞌbí yé á bìndi bà ꞌdè nje mì ndú ta ndâ bu-Mbíṛì mì ndâ Jùdéyà nò, yí giì ŋò Jézù kèjì gí mì wó. Bìndi  yí giì tùbà tí Jézù ji ndâ ꞌduù máa, «Yo ŋò ꞌViì-rómbo-mì-Mbíṛì, tí mbe toṛo ndâ vò i ꞌdo muu to tí nó, zô! ");
INSERT INTO ndz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ŋìzó a yí tí ꞌduù tí nó náa ye kû ꞌdè có gítí wó máa, ‹ꞌBí ꞌduù, tí gbolò ꞌduù mbe ndii ye gî, á kèjì tàkò ye› nó ká zô. Yí me gbolò ndii ye gî, tacó yí sàà kû ꞌvala kùṛo o bà jò ye. ");
INSERT INTO ndz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ye táánò sàà ŋò yí ni tí ꞌduù tí nó náa Mbíṛì tuu yí nó lá, káa à giì tuu ye, máa, ye dù tí mbe caka tí ndâ ꞌduù, tacó wàa, ye ꞌví tù ta bà tí wó ji ndâ Ìzìrìyélì. ");
INSERT INTO ndz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","«Ye táánò ŋò Bèṛi-mì-Mbíṛì kû gì ꞌdo gbíṛì go kùlè nô, kû gì gí bà o mí muu wó. ");
INSERT INTO ndz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ye táánò ta o tí nò ŋò yí ni lá. Káa a ꞌduù tí nó mbe tuu ye, máa, ye caka tí ndâ ꞌduù ta ngo nó, ká giì tùbà tí wó ji ye máa, ‹ꞌDuù tí nó náa wò bà ŋò Bèṛi-mì-Mbíṛì kû gì ꞌdo gbíṛì ndírí gí muu wó nó, a ꞌduù tí nò ká bà gì gí bà caka tí ndâ ꞌduù ta Bèṛi-mì-Mbíṛì nó ká nò.› ");
INSERT INTO ndz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Káa ye giì ŋò Bèṛi-mì-Mbíṛì gì ꞌdo gbíṛì gí muu ꞌdakò tí zó gî. À má énò, ye kpónó kû yù nó a gbí wó ji yo máa, yí a ꞌViì-mì-Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta ꞌbí yé, si ndâ Jòvánì kû ṛò tíyò ta ndâ ꞌbí mbe tala có mì wó sósòꞌô ta ꞌdêꞌo, ");
INSERT INTO ndz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jòvánì giì ŋò Jézù kû ndii ta nó. Yí giì zeke Jézù ngbóó, bìndi  yí giì tùbà tí wó ji ndâ mbe tala có mì wó tí nó náa ndú kû ṛò tíyò ta ndú nó, máa, «Yo ŋò ꞌViì-rómbo-mì-Mbíṛì ta nó zô.» ");
INSERT INTO ndz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ndâ mbe tala có mì Jòvánì nò mâ giì ꞌdi có tí nò náa yí ꞌdè ji ndú nò, ndú só giì njè nó ya gí bà ṛu ndi Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jézù mâ giì ꞌvìsì tí wó, yí mâ giì ŋò ndú, yí giì ꞌvee ndú máa, «Yo kû pà a yè?» Káa ndú giì ꞌvìsì có ji Jézù máa, «Rábì» (gbí  máa, Mbe nìbà i), «Wò kû dù ngò?» ");
INSERT INTO ndz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo gì gí bà ŋò .» Ndú bà-i-nò giì ya ta sè ṛi-ꞌdêꞌo tí nó gí bà ŋò bàndò mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ꞌBí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ mbe tala có mì Jòvánì mbe ya gí bà ŋò bàndò bà dù Jézù nò a Àndèréyà, tí náꞌvindí Sìmónè Pìyétòrò. ");
INSERT INTO ndz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Àndèréyà mâ giì ŋò bàndò bà dù Jézù gî, yí giì dele ndi wó ya gí bà pà bà tí náꞌvindí wó Sìmónè, yí mâ giì ꞌde yí gî, yí giì ꞌdè có ji yí máa, «Ze ꞌde Bìndi-Mbíṛì gî!» ");
INSERT INTO ndz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bìndi  yí giì ꞌdaka Sìmónè ya tí  ji Jézù. Jézù mâ giì ŋò Sìmónè, Jézù giì zeke Sìmónè ngbóó, bìndi  yí giì ꞌdè có ji yí máa, «Wò a Sìmónè tí ꞌviì mì Jòvánì, káa ngú ṛè lo kpónó bà dù a Kéfà,» (gbí  máa, Pìyétòrò, gbí  máa, Duù). ");
INSERT INTO ndz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ta yé bìndi bà ꞌde tí ndâ Jézù ta Sìmónè Pìyétòrò, Jézù giì ꞌde ꞌbí ꞌdakò ta ṛè wó a Fìlípò, si Jézù bàkà có gítí bà njè nó ꞌdo tàbèꞌdè Jòròdánìyà tacó bà ya gí Gàlìléyà cee gî. Jézù giì tèꞌé tí Fìlípò máa, yí gì gí bà ṛu ndi yì. ");
INSERT INTO ndz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fìlípò delè káa ꞌduù Bètìsàyídà go ndâ Àndèréyà ta Pìyétòrò. ");
INSERT INTO ndz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fìlípò mâ giì ꞌde ꞌbí ꞌdakò ta ṛè wó a Nàtànìyélè, yí giì ꞌdè có ji Nàtànìyélè máa, «Ze ꞌde ꞌduù tí nó náa Mòze táánò cu có gítí wó mí gbí wáràgà mì wó nó gî, ꞌduù tí nó náa ndâ mbe ꞌdòkò có mì Mbíṛì táánò cu có gítí wó mí gbí wáràgà mì ndú nô. Ṛè wó a Jézù, tí ꞌviì mì Jùzépè mbe gì ꞌdo Názàrètì.» ");
INSERT INTO ndz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Káa Nàtànìyélè giì ꞌvee Fìlípò máa, «A ŋa tó i yè jé ká gì ꞌdo Názàrètì?» Káa Fìlípò giì ꞌvìsì có ji Nàtànìyélè máa, «Gì gí bà ŋò yí ta ṛo lo.» ");
INSERT INTO ndz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ndâ Fìlípò ta Nàtànìyélè bà-i-nò giì njè nó kû ya gí mì Jézù. Jézù mâ giì ŋò Nàtànìyélè kèjì gí mì wó, yí giì ꞌdè có ji yí máa, «À gbúú-gbuu zó a Ìzìrìyélì gbí dù Ìzìrìyélì ta tiṛì gbí yì wó wálá ká kèjì zô.» ");
INSERT INTO ndz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nàtànìyélè mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, yí giì ꞌvee Jézù máa, «Wò ŋò ye ni ta yè?» Káa Jézù giì ꞌvìsì có ji yí máa, «Ye kùtàá ŋò wò kû ki tí lo to tà mû-mbiìgá á kùṛo o bà ya Fìlípò gí bà tèꞌé tí lo.» ");
INSERT INTO ndz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nàtànìyélè bà-i-nò giì ꞌvìsì có ji Jézù máa, «Mbe nìbà i, wò a ꞌViì-mì-Mbíṛì! Wò a gbolò gba mì ndâ Ìzìrìyélì!» ");
INSERT INTO ndz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Káa Jézù giì ꞌvìsì có ji Nàtànìyélè máa, «Wò ùnje énò máa, ye a ꞌViì-mì-Mbíṛì, tí gbolò gba mì ndâ Ìzìrìyélì, ká tacó náa ye ꞌdè có ji wò máa, ye kùtàá ŋò wò kû ki tí lo to á tà mû-mbiìgá gî nò. Káa wò bà giì ŋò ndâ ꞌbí i mbe me kpo-kpò ndii ŋìnò gî. ");
INSERT INTO ndz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ye kû ꞌdè có ji wò ta yúcó máa, wò kèjì gí bà ŋò njekèjì gbíṛì njaanga tí gî, bìndi  ndâ basìlì mì Mbíṛì kû wùùkù to ya gí yaà, gì gí to, ya gí yaà, gì gí to, muu ꞌViì-mì-ꞌDakò.» ");
INSERT INTO ndz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","À bàkà bìndi bà tèꞌé tí ndâ Fìlípò ta Nàtànìyélè mì Jézù káa sili taꞌô, bìndi  ꞌbí ꞌdakò gbí gbata Kánà, gbí to Gàlìléyà, giì ko niì mì wó gí ꞌbá. Màríyà tí nawu Jézù ta o tí nò kuu bàndò bà ko niì tí nò. ");
INSERT INTO ndz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","À delè giì tèꞌé tí ndâ Jézù ta ndâ mbe tala có mì wó gí bà ko niì tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pe nèbítì mâ giì cee ꞌdo mì ndâ mbe kò niì gî, nawu Jézù giì ꞌdè có ji yí máa, «Pe mì ndú wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Káa Jézù giì ꞌvìsì có ji nawu wó máa, «Káa wò ꞌdè ji ye máa ye ꞌví bàkà tí  a yè, ndi lo niì? O mì ye gì kálásê.» ");
INSERT INTO ndz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nawu Jézù bà-i-nò giì ꞌdè có ji ndâ ꞌduù tí nó mbe kû bàkà nèté bàndò bà ko niì nó máa, «Yí má ꞌdè có ji yo, yo ꞌví ndii muu có mì wó nò lá.» ");
INSERT INTO ndz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ta o tí nò ndâ ꞌbí kpo-kpò káꞌi-ngo vô-nje gbaànjé ꞌdo tí díí, náa gbèe  kû te go jú-káṛà-ngo vô ta nje  tí , kuu mì ndâ ꞌduù tí nò á bàndò bà ko niì nò. Nèté mì ŋa ndâ kpo-kpò káꞌi-ngo tí nò gbí tàkìì mì ndâ Jùdéyà a bà cu ngo mí gbí ndú tacó bà caka bèjò. ");
INSERT INTO ndz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jézù bà-i-nò giì ꞌdè có ji ndâ ꞌduù tí nó mbe kû bàkà nèté bàndò bà ko niì nó máa, «Yo cu ngo yeke ndâ kpo-kpò káꞌi tí nò gî.» Ndâ ꞌduù tí nò mâ giì bàkà go có tí nò náa Jézù ꞌdè ji ndú nò gî, ");
INSERT INTO ndz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jézù giì ꞌdè có ji ndú máa, «Yo cu ꞌbí ngo tí nò náa yo yee mí gbí ndâ káṛà nò ji ꞌduù tí nó mbe kû njèè i-zó-zò nô.» ");
INSERT INTO ndz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ndâ ꞌdakò tí nò giì cu ngo tí nò náa ndú yee mí gbí káṛà nò ya tí  ji ꞌduù tí nó mbe kû njèè i-zó-zò nó go có mì Jézù nò. Yí mâ giì tee mítí nje wó, ŋìnó a pe ká nô! Káa yí ŋò ꞌdóó kpokèjì tí nó náa pe tí nò gì ꞌdo tí  nó lá. À káa ndâ ꞌduù tí nó mbe yòò ngo mí gbí ndâ kpo-kpò káṛà-ngo tí nó ká ꞌdi gbí có tí nò. Mbe njèè i-zó-zò bà-i-nò giì tèꞌé tí ꞌdakò tí nó náa à kû ko niì mì wó gí ꞌbá nô. ");
INSERT INTO ndz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Bìndi  yí giì ꞌdè có ji yí máa, «Ndâ ꞌduù ta o i ꞌdáá gî kû njèè kùṛo a pe ŋìnó mbe me gó ngé waa gî nô. Yì ndâ wiṛi má ye gî, ndú giì njèè pe ŋìnó mbe me gó dúú-dúú lá nó ꞌdo ndiì. Káa wò giì kpolo tí pe ŋìnó mbe me gó ngé waa gî nó yee tí kpónó.» ");
INSERT INTO ndz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jézù bàkà kpédélé seṛè mì wó nò mí gbí gbata Kánà á Gàlìléyà, tacó wàa ndâ ꞌduù ꞌví ŋò ta wotí mì yì. Ndâ mbe tala có mì wó giì ùnje gítí wó dú ta yúcó gî. ");
INSERT INTO ndz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ndâ Jézù ta nawu wó, ta ndâ náꞌvindí wó, giì njè nó ꞌdo bàndò bà ko niì ya gí bà bàkà làmbu sili mí gbí gbata Kàpàrànáwùmù. ");
INSERT INTO ndz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jézù mâ giì ŋò kùṛo o bà bàkà tàkìì mì o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì dooko gî, ndú giì njè nó ta ndâ mbe tala có mì wó ꞌdo gbí gbata Kàpàrànáwùmù, tacó bà ya gí bà bàkà gbolò o tí nò mí Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ndú mâ giì yee kà, ndú giì ꞌde ndâ ꞌduù ꞌvìsì gbí ndùgù ꞌbá-Mbíṛì tí ꞌdóó i mì ndú gî. Ndú ꞌde ndâ mbe kû mà ndâ mòꞌdú, ta ndâ rómbo, ta ndâ kùlè, ta ndâ mbe kû ꞌvìsì gùrúsù, ꞌvíṛímó-ꞌviṛimo gbí nèté. ");
INSERT INTO ndz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jézù mâ giì ŋò énò, yí giì je njì wú, bìndi  yí giì gbì ta ndâ ꞌduù tí nò, ta ndâ nò mì ndú, mòkò ꞌdo gbí ndùgù ꞌbá-Mbíṛì á gí sè. Yí giì ꞌbuku ndâ tàràbézà mì ndâ mbe kû ꞌvìsì gùrúsù mí to, ta bà vaka ndâ gùrúsù mì ndú vóró-voro, vóró-voro, ta to. ");
INSERT INTO ndz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Bìndi  yí giì do mítí ndâ mbe kû mà ndâ kùlè máa, «Yo kaa ndâ kùlè mì yo nò ꞌdo bà-i-nó gî! Yo kákáꞌi ꞌví bàkà ṛùkàtiì mì Bu ye tí bàndò bà mà ꞌvélè mì yo lá!» ");
INSERT INTO ndz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ndâ mbe tala có mì Jézù mâ giì ŋò ŋa i tí nò náa yí bàkà ta ndâ mbe mà ꞌvélè gbí ndùgù ꞌbá-Mbíṛì nò, mbí ndú bà giì ꞌva tí có tí nó á gbí wáràgà mì Mbíṛì máa, «Ye bà cì ká muu ꞌbá mì lo!» nô. ");
INSERT INTO ndz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Káa ndâ kpo ꞌduù mì ndâ Jùdéyà ŋìndi ndú giì yuu tí ndú mí gbí có tí nò ta bà ꞌvee gbí nje Jézù máa, «Ze ꞌví ŋò ni mítí ŋa yè máa, àá mì lo a yúcó tacó bà bàkà ŋa i tí nò kpónó náa wò bàkà nò?» ");
INSERT INTO ndz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo kiꞌviki ꞌbá-Mbíṛì tí nó gí to, wàa ye bà bì ndí  mí tíyò á gbí sili taꞌô.» ");
INSERT INTO ndz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Káa ndâ kpo ꞌduù mì ndâ Jùdéyà giì ꞌvee yí máa, «Àá táánò bì ꞌbá-Mbíṛì tí nò mí tíyò gbí ndoò ziꞌduù-só-nje vô nje-vô gbaànjé, káa wò kèjì gí bà bì ndí  gbí sili taꞌô?» ");
INSERT INTO ndz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ndâ kpo ꞌduù mì ndâ Jùdéyà ta o tí nò ŋìndi ndú kû koṛo có a i gítí cèe ꞌbá-Mbíṛì tí nó, keèlá, Jézù kû ni a ꞌbá-Mbíṛì tí nó tí dìì wó nô. ");
INSERT INTO ndz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mbí ndâ mbe tala có mì Jézù giì ꞌva tí có tí nò náa yí ꞌdè gítí bà bì ndi ꞌbá-Mbíṛì á gbí sili taꞌô nò a i bìndi bà ꞌvala ndi Jézù ꞌdo gbí muuꞌdú wó. Bìndi  à ngbíí nò a o bà giì ùnje mì ndú á gítí ndâ có tí nó á gbí wáràgà mì Mbíṛì, ta có tí nò náa Jézù ꞌdè nò. ");
INSERT INTO ndz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ndâ ꞌduù me mbè, mbe ŋò ndâ seṛè tí nó náa Jézù bàkà gbí ndâ sili bà dù yí á Jèrùzàlémè ta o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì nó, giì ùnje gítí Jézù gî. ");
INSERT INTO ndz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Káa Jézù tee njembí wó gítí có mì ꞌbí ꞌduù gbí òkò tí ndú gbaànjé lá, tacó yí ŋò ndú ꞌdáá gî ni gî. ");
INSERT INTO ndz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tacó énò, gbí ndeṛè bà ꞌvee ꞌbí ꞌduù mì wó máa yí ꞌdè gbí ndú ji yì nò wálá, tacó yí ꞌdi gbí ndâ ꞌduù muu to tí nó ngé cee gî. ");
INSERT INTO ndz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ta ꞌbí o gbaànjé ꞌbí ꞌdakò tí mbe kpolo tí tàkìì mì ndâ Jùdéyà, delè tí kpo ꞌduù gbí ngbàngà mì ndú, ta ṛè wó a Nìkòdémò, ");
INSERT INTO ndz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","giì ya gí mì Jézù ta bèbìlì gbí kóó, bìndi  yí giì ꞌdè có ji yí máa, «Mbe nìbà i, ze ŋò wò tí mbe nìbà i mbe gì ꞌdo mì Mbíṛì ni gî. Tacó ꞌbí ꞌduù bà ꞌde wotí bà bàkà ndâ ŋa ndâ kpo-kpò i tí nó náa wò kû bàkà nó wálá, sè  káa ŋìnó à má káa Mbíṛì ká tàkò ꞌduù tí nò.» ");
INSERT INTO ndz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Káa Jézù giì ꞌvìsì có ji Nìkòdémò máa, «Ye kû ꞌdè có ji wò ta yúcó máa, à má kpò gbí ndi bà jò ꞌduù lá, ꞌduù tí nò bà dù tí bòò-gba mì Mbíṛì wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Káa Nìkòdémò giì ꞌvee Jézù máa, «Àá bà kpò gbí ndi bà jò kpo ꞌduù kákáꞌi ée? Yí bà ꞌde kpokèjì bà dele ndi wó ya gí gbí yì nawu wó wàa à ꞌví jò ndi wó tí dó ꞌviì ꞌdo kòtí ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Káa Jézù giì ꞌvìsì có ji Nìkòdémò máa, «Ye kû ꞌdè có ji wò ta yúcó máa, à káa ŋa ꞌduù ŋìnó náa à caka tí wó gî, tí ŋa ꞌduù ŋìnó mbe ꞌdi có mì Bèṛi-mì-Mbíṛì gî nó, ká bà dù tí Bòò-gba mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","A ndâ bu ꞌduù ta nawu ꞌduù ká jò ꞌduù, káa, a Bèṛi-mì-Mbíṛì ká je wotí bà dù tí ꞌduù mì Mbíṛì ji ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Njembí lo ꞌví mù gítí có tí nó náa ye ꞌdè ji wò énó nó máa, à ꞌví jò ndi lo tí ngú  nó lá. ");
INSERT INTO ndz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tacó ndâ ꞌduù ŋìnó náa Bèṛi-mì-Mbíṛì je wotí bà ꞌvala go có mì Mbíṛì ji ndú gî nó, go pípìṛi náa wò kû ꞌdi káa wo bà pì yí, káa wò bà ni bà cu ꞌbì lo gbúú-gbuu mítí ꞌbí to, máa, ‹Nô! Pípìṛi kû pì ꞌdo nô!› nò wálá. Wó delè bà ni bà cu ꞌbì lo gbúú-gbuu mítí ꞌbí to, máa, ‹Pípìṛi kû pì gítí  nó!› nò wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Káa Nìkòdémò giì ꞌvee Jézù máa, «Gbí có mì lo nò máa yè?» ");
INSERT INTO ndz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Káa Jézù giì ꞌvìsì có ji yí máa, «Wò tí gbolò mbe nìbà i mì ndâ Ìzìrìyélì delè ŋò ndâ i tí nò ni lá? ");
INSERT INTO ndz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ye kû ꞌdè có ji wò ta yúcó máa, ze kû ꞌdè có ká gítí ndâ i ŋìnó náa ze ŋò ndú ni gî nô. Ze delè kû ꞌdè có ká gítí ndâ i ŋìnó náa ze ŋò ndú ta ṛo ze gî nô. Kpêtí ká énó, ndâ ꞌduù mì yo biya bà ꞌdi ndâ có tí nó náa ze ꞌdè ji yo gítí ndâ i ŋìnó náa ze ŋò ta ṛo ze nó gî. ");
INSERT INTO ndz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yo má biya bà ꞌdi có tí nó náa ye ꞌdè ji yo gítí ndâ i muu to tí nó nó gî, yo bà ùnje gítí có ŋìnó náa ye bà ꞌdè ji yo gítí ndâ i ŋìnó gbíṛì nó ta ŋa kpokèjì ngàyi? ");
INSERT INTO ndz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ꞌBí ꞌduù muu to tí nó gbaànjé jé mbe ꞌdò kò wó mí gbíṛì wálá; à káa ꞌViì-mì-ꞌDakò, tí mbe gì ꞌdo gbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mbíṛì bà te ꞌViì-mì-ꞌDakò gí yaà mí kùṛo ndâ ꞌduù go bà te cè tí kpoo tí nó náa à du ꞌdo tí liì nó mì Mòze gí yaà mí kùṛo ndâ ꞌduù gbí kángáá nga ngoò, ");
INSERT INTO ndz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tacó wàa ndâ mbe ùnje gítí wó ꞌdáá gî ꞌví ꞌde ta ꞌválá ŋìnó mbe cee lá nô. ");
INSERT INTO ndz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tacó Mbíṛì zè ndâ ꞌduù muu to tí nó nìkì ngé ma. Tacó énò, yí giì je gbèe ꞌViì mì wó ji ndú. Mbíṛì je gbèe ꞌViì mì wó ji ndâ ꞌduù, tacó wàa, ndâ ꞌduù ŋìnó mbe ùnje gítí wó nó ꞌví giṛiꞌo lá. Ndú delè ꞌví ꞌde ta ꞌválá ŋìnó mbe cee lá nô. ");
INSERT INTO ndz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mbíṛì tuu ꞌViì mì wó gí muu to tí nó me tacó bà waa có mítí ndâ ꞌduù lá. Yí tuu yí a i tacó bà ꞌvala ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mbíṛì bà waa có mítí ndâ ꞌduù ŋìnó mbe ùnje gítí ꞌViì-mì-ꞌDakò gî nó wálá. Káa ꞌduù ŋìnó mbe biya bà ùnje gítí gbèe ꞌViì-mì-Mbíṛì ta ꞌbí ꞌviì go yí mì Bu wó wálá nó gî nó ꞌva tí to sàà gî. ");
INSERT INTO ndz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mbíṛì bà waa có mítí ndâ mbe ngbútù ta ndeṛè  énó máa, ngbaꞌo gì gí muu to tí nó gî, káa à giì nìkì tí ndâ ꞌduù a bà kpoko tí ndú ta ndi gbí ꞌdíꞌdiꞌo. Ndú biya bà dù gbí ngbaꞌo gî, tacó ndú ta o ꞌdáá gî kû bàkà káa ndâ vò i. ");
INSERT INTO ndz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","À dú káa yúcó máa, ndâ mbe bàkà vò i ꞌdáá gî kû sogo ngbaꞌo, tacó à tí ndú a gúku, máa, ndâ ꞌduù bà ŋò ŋa ndâ vò i tí nó náa ndâ yì kû bàkà nô. ");
INSERT INTO ndz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Káa a ndâ mbe ꞌvala ta yúcó ká kû co gí gbí ngbaꞌo, tacó wàa, ndâ ꞌduù ꞌví ŋò ta ndâ i tí nó náa ndâ yì bàkà ta ṛè mì Mbíṛì nó ngbáṛángàꞌi.» ");
INSERT INTO ndz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ta o tí nò ndâ Jézù ta ndâ mbe tala có mì wó giì ꞌbìtà bà nò ta ndi gbí ndâ to á sè ꞌdo gbí ndâ gbata gbí to Jùdéyà. Ndú dù gbí ndâ nó tí nò ta làmbu kôndi o, kû caka tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jòvánì tí mbe caka tí ndâ ꞌduù ŋìndi wó ta gbèe o tí nò kû dù tí ꞌbí bàndò ta ngo gèjèè kuu tí , náa à kû nì mítí  a Àyìnónì, á dê ta gbata Sàlímì, kû caka tí ndâ ꞌduù delè, ");
INSERT INTO ndz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","á kùṛo bà zèè yí tí Jòvánì tí mbe caka tí ndâ ꞌduù mí gbí zàà. ");
INSERT INTO ndz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ta ꞌbí o gbaànjé, ndâ ꞌbí mbe tala có mì Jòvánì tí mbe caka tí ndâ ꞌduù giì tò kponje ta ꞌbí Jùdéyà gítí có bà bàkà i tí ngbáṛángà i. ");
INSERT INTO ndz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bìndi  ndâ mbe tala có mì Jòvánì tí mbe caka tí ndâ ꞌduù giì ya gí mì wó, bìndi  ndú giì ꞌdè có ji yí máa, «Mbe nìbà i, ze ꞌdi có énó máa, ꞌdakò tí nó táánò náa yo ta yí ngéé tìto Jòròdánìyà nó, ꞌdakò tí nó náa wò táánò tùbà tí wó ji ndâ ꞌduù máa, yí a ꞌViì-rómbo-mì-Mbíṛì nó, kpónó kû caka tí ndâ ꞌduù, káa ndâ ꞌduù ꞌdáá gî kû kaa ya gí mì wó.» ");
INSERT INTO ndz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Káa Jòvánì tí mbe caka tí ndâ ꞌduù giì ꞌvìsì có ji ndâ mbe tala có mì wó máa, «À má me Mbíṛì ká wu i ji ꞌduù lá, yí gí bà dù tí mbe i tí nò wálá. ");
INSERT INTO ndz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yo ꞌdi có tí nó náa ye táánò ꞌdè ji yo énó máa, ‹Ye me Bìndi-Mbíṛì lá, ye a ꞌduù tí nó náa à tuu yí túú-tuu gí kùṛo wó› nó ta tù yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ngú niì ta o ꞌdáá gî ká ta ṛè ngú ꞌdakò mì wó mbe kû kò yí nô. Kpêtí ká énò, tàkòcò kómbe ꞌdakò tí nó mbe kû kò ngú niì nó ta o ꞌdáá gî ká pétékèꞌi gítí bà ꞌdi kòcò ndâ kómbe wó kû ꞌdè nje ta ngú niì mì wó ta líkíꞌo tí ndú. Ŋa líkíꞌo tí nò kpónó kuu tí ye. Tàkòcò ye kpónó peteke ngé tè gî. ");
INSERT INTO ndz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wotí mì wó má kû ya gí yaà, wotí mì ye kû dele gí to. ");
INSERT INTO ndz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ꞌDuù tí nó mbe gì ꞌdo yaà nó me gbolò ndii ndâ ꞌduù ꞌdáá gî. Káa ꞌduù ŋìnó náa à jò yí mí muu to tí nó nó a ꞌduù mì to tí nô. Yí delè kû ꞌdè có ká gítí ndâ i muu tó tí nô. ");
INSERT INTO ndz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Bìndi  ꞌduù tí nó mbe gì ꞌdo gbíṛì nó kû ꞌdè có ká gítí ndâ i ŋìnó náa yí ŋò ndú gbíṛì nô. Yí delè kû ꞌdè káa ndâ có ŋìnó náa yí ꞌdi ꞌdo gbíṛì nô. Ndâ ꞌduù kpêtí má ùnje gítí có mì wó lá, ");
INSERT INTO ndz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ꞌduù ŋìnó mbe ùnje gítí có mì wó gî nó ùnje gî máa, ndâ có mì Mbíṛì a yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tacó ꞌduù tí nó náa Mbíṛì tuu yí nó kû ꞌdè a ndâ có mì Mbíṛì. Tacó Mbíṛì je Bèṛi mì wó tí Mbíṛì ji ꞌduù tí nò náa yí tuu yí nò túkàꞌi. ");
INSERT INTO ndz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bu ꞌViì zè ꞌViì nìkì ma. Yí giì kaa ndâ i ꞌdáá mí ꞌbì ꞌViì gî. ");
INSERT INTO ndz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ꞌDuù mbe ꞌdi có mì ꞌViì gî bà ꞌde ꞌválá ŋìnó mbe cee lá nô. Káa, ꞌduù ŋìnó mbe biya bà ꞌdi có mì ꞌViì gî nó jé gí bà ꞌde ꞌválá ŋìnó mbe cee lá nó wálá, tacó yí kû ꞌvala gbí kpo-tàkòcò mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jézù giì ꞌdi gî máa, ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà ŋò ni gî máa, muu ndâ mbe tala có mì yì me mbè ndii muu ndâ mbe tala có mì Jòvánì tí mbe caka tí ndâ ꞌduù gî, káa yì delè kpòò kû caka tí ndâ ngú ꞌbí , ");
INSERT INTO ndz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","à má ta bà ꞌdè ta yúcó, Jézù táánò caka tí ndâ ꞌduù lá, a ndâ mbe tala có mì wó ka kû caka tí ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yí njè nó ta ndâ mbe tala có mì wó ꞌdo Jùdéyà tacó bà ya gí Gàlìléyà, ");
INSERT INTO ndz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","có tí kpokèjì tí nó mbe có gbí to Sàmárìyà nô. ");
INSERT INTO ndz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ndú mâ giì yee gbí njí tí nó náa Jàkóbè dígísèé je tí mbèlè ji ꞌviì mì wó Jùzépè, á dê ta gbata Sìkárà gbí to Sàmárìyà nó, ");
INSERT INTO ndz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jézù giì ki tí wó to ta sé nó á muu ꞌbí gùù ngo, náa à kû nì mítí  a Gùù ngo mì Jàkóbè, á gbí njí tí nò, si ṛi dê gítí bà gì gbúrú. ");
INSERT INTO ndz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jézù mâ giì zekeꞌo, yí giì ŋò ꞌbí niì tí jú Sàmárìyà mbe gì tacó bà ja ngo, si ndâ mbe tala có mì Jézù kaa ꞌdáá ya gí bà sì i-zó-zò gbí gbata gî. Bìndi  Jézù giì yù ngo ꞌdo tí niì tí nò, máa, «Cu ꞌbí ngo mì lo nò je, wàa ye ꞌví njù gi.» ");
INSERT INTO ndz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Káa niì tí nò giì ꞌvee Jézù máa, «Ŋìnò a wò tí Jùdéyà ká kû yù ngo ꞌdo tí ye tí jú Sàmárìyà?» Niì tí nò ꞌvee ŋa ꞌvé tí nò mítí Jézù tacó ndâ Jùdéyà gbí ndâ o tí nò si ndâ ꞌduù Sàmárìyà tí i ngé gî lá. ");
INSERT INTO ndz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Káa Jézù giì ꞌvìsì có ji niì tí nò máa, «Wò kùtàá má ŋò i-nambeè tí nó náa Mbíṛì kû je ji ndâ ꞌduù tí nó ní-ni, wò delè kùtàá má ŋò ꞌduù tí nó mbe kû yù ngo njú-njù ꞌdo tí lo nó ní-ni, a wò kùtàá ká bà yù ngo ꞌdo tí wó, bìndi  yí kùtàá bà je ngo tí nó mbe kû ꞌvala ndâ ꞌduù nó ji wò gî.» ");
INSERT INTO ndz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Niì tí nò bà-i-nò giì ꞌvìsì có ji Jézù máa, «I bà ja ngo mì lo wálá, kpo ꞌduù, káa tà guu ngo tí nó me ꞌdú ngé. Wò bà ꞌde ngo tí nó mbe kû ꞌvala ndâ ꞌduù náa wò bà je ji ye nò ꞌdo kòtí ꞌdi? ");
INSERT INTO ndz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Gbí ŋa có mì lo nò máa, wò a gbolò ꞌduù ndii gu ze tí nó tí Jàkóbè nó gî? Jàkóbè tí nó táánò tí mbe duu gùù ngo tí nó náa ndú ta ndâ ꞌviì mì wó, ta ndâ i-kó-ko mì ndú, njù kpòò, bìndi  ndú giì jee ji ze nô?» ");
INSERT INTO ndz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Káa Jézù giì ꞌvìsì có ji niì tí nò máa, «ꞌDuù má njù ngo ꞌdo gbí gùù ngo tí nó, go ngo bà bàkà yí kákáꞌi gî. ");
INSERT INTO ndz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Káa go ngo bà bàkà ꞌduù mbe njù ngo gbí ꞌbì ye kákáꞌi wálá. Ngo tí nò bà dù gbí yì wó go ngo mbe kû ꞌva gbí pù co gbí ndoò. Ngo tí nò bà ꞌvala yí dúú bà ya tí .» ");
INSERT INTO ndz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Niì tí nò mâ giì ꞌdi có tí nò náa Jézù ꞌdè ji yí nò, yí giì ꞌvìsì có ji Jézù máa, «Cu ꞌbí ŋa ngo tí nò náa wò kû ꞌdè có gítí  nò ji ye, tacó wàa go ngo ꞌví bàkà ye kákáꞌi lá. Delè tacó wàa, ye ꞌví gì gí bà ja gùù ngo tí nó kákáꞌi lá, bu ye.» ");
INSERT INTO ndz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Káa Jézù giì ꞌvìsì có ji niì tí nò máa, «Ya gí bà tèꞌé tí ꞌdakò mì lo, wàa yo ꞌví gì ta yí gí bà-i-nô.» ");
INSERT INTO ndz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Káa niì tí nò giì ꞌvìsì có ji Jézù máa, «ꞌDakò mì ye wálá.» Jézù bà-i-nò giì ꞌvìsì có ji yí máa, «Wò ꞌdè a yúcó máa, ꞌdakò mì lo wálá. ");
INSERT INTO ndz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tacó wò táánò kò ndâ ꞌdakò vô, káa ꞌdakò tí nó kpónó náa yo kuu ꞌbá ta yí nó me ꞌdóó ꞌdakò mì lo lá. Có mì lo me ꞌvéṛè lá.» ");
INSERT INTO ndz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Niì tí nò mâ giì ꞌdi có tí nò náa Jézù ꞌdè ji yí nò, yí giì ꞌvìsì có ji yí máa, «Ye kpónó ŋò ni gî máa, wò a mbe ꞌdòkò có mì Mbíṛì, bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Káa ndâ ká gù ze tí ndâ Sàmárìyà dígísèé kû bàkà i-Mbíṛì mí pí gú tí nó mì ze nô. Káa yo tí ndâ Jùdéyà máa, gbèe bàndò bà bàkà i-Mbíṛì ꞌví dù ká gbí gbata Jèrùzàlémè cuki. Yúcó bàndò kpónó ꞌví dù a ŋìndi ndâ ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jézù bà-i-nò giì ꞌvìsì có ji niì tí nò máa, «Ùnje gítí có tí nó náa ye kû ꞌdè ji wò nô, niì. ꞌBí o wúnò ká kèjì náa yo bà bàkà i ji Bu ye mí pí gú mì yo nó wálá; yo delè bà bàkà i mí Jèrùzàlémè wálá. ");
INSERT INTO ndz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yo tí ndâ ꞌduù Sàmárìyà ŋò Mbíṛì tí nó náa yo kû bàkà i ji yí nó ni lá. Káa ze tí ndâ Jùdéyà ŋò Mbíṛì tí nó náa ze kû bàkà i ji yí nó ni gî. Tacó ꞌduù tí nó tí mbe ꞌvala ndâ ꞌduù nó gì a i ꞌdo mì ze tí ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Káa o tí nò ká kèjì, à má ta bà ꞌdè ta yúcó, o tí nò gì sàà gî, náa ndâ cèe mbe bàkà i-Mbíṛì bà giì bàkà i ji Bu ye ta njembí ndú, ndú delè bà bàkà i ji yí ta yúcó. Tacó ŋìnò a ŋa ndâ ꞌduù tí nó náa Mbíṛì tí Bu ye kû dù ta go ndú máa ndú ꞌví dù tí ndâ mbe bàkà i ji yì nô. ");
INSERT INTO ndz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mbíṛì a Bèṛi; à má énò, ndâ mbe bàkà i-Mbíṛì ꞌví bàkà ta wotí mì Bèṛi mì wó tí Mbíṛì, ndú delè ꞌví bàkà ta yúcó.» ");
INSERT INTO ndz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Káa niì tí nò giì ꞌvìsì có ji Jézù máa, «Ye ŋò ni gî máa, Màsíyà (gbí  máa, Bìndi-Mbíṛì) kpónó kèjì, yí má gì gî, yí bà ꞌdè gbí ndâ có ꞌdáá gî ji ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Káa Jézù bà-i-nò giì ꞌvìsì có ji niì tí nò máa, «Ye tí mbe kû ꞌdè có ta wò nó a ꞌduù tí nò, tí Bìndi-Mbíṛì nò.» ");
INSERT INTO ndz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ꞌDo bà-i-nò ndâ mbe tala có mì Jézù giì dele ndi ndú ꞌdo bà sì i-zó-zò gî. Ndú mâ giì ꞌde ndâ Jézù kû ꞌdè nje ta niì tí nò, nje ndú ꞌdáá gî giì ꞌdèè gî. Káa gbèe ꞌbí ꞌduù gbí òkò tí ndú mbe ꞌvee Jézù máa, «Yo kû ꞌdè a cèe nje yè ta jú Sàmárìyà tí nò?» nò wálá. ");
INSERT INTO ndz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Niì tí nò mâ giì ŋò ndâ mbe tala có mì Jézù gì gî, yí giì goonó mbálá-mbala ya gí gbí gbata, si káṛà ngo mì wó mí muu gùù ngo, bìndi  yí giì ma ndâ ꞌduù máa, ");
INSERT INTO ndz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Yo gì gí bà ŋò ŋa ꞌbí ꞌdakò tí nó gi! Yí yù gbí ndâ i tí nó náa ye bàkà gbí bà ꞌvala ye nó ꞌdáá gî gí sè gî. À ꞌví dù nò a ꞌdakò tí nó tí Bìndi-Mbíṛì nó?» ");
INSERT INTO ndz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Káa ndâ ꞌduù gbí gbata mâ giì ꞌdi ndâ có tí nò náa niì tí nò ꞌvanda ji ndú nó, ndú giì kaa ya gí mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Káa si niì tí nò kû ya gí bà kili ndâ ꞌduù gbí gbata tacó bà ya gí mì Jézù nò, ndâ mbe tala có mì Jézù kû yòòngò yí gítí i-zó-zò, máa, «Zò ꞌbí làmbu i, wàa wò ꞌví njù ta ngo, mbe nìbà i.» ");
INSERT INTO ndz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Káa Jézù giì ꞌvìsì có ji ndú máa, «I-zó-zò mì ye kuu bà ṛo ye, káa yo ŋò ni lá.» ");
INSERT INTO ndz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ndâ mbe tala có mì Jézù giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú máa, «À ꞌví dù a ꞌbí ꞌduù ká ꞌví gì ta i-zó-zò ji yí?» ");
INSERT INTO ndz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Káa Jézù giì ꞌvìsì có ji ndú máa, «I-zó-zò mì ye a bà bàkà go có mì ꞌduù tí nó mbe tuu ye nô. I-zó-zò mì ye a bà cee nèté mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","À tà káa yo ká kû ꞌdè có énó máa, ndâ ꞌduù kû kili i ꞌdo gbí njí á bìndi pì nàꞌô bìndi bà yee njì ŋa mí gbí gùù le? Yo zekeꞌo gbí njí lèè énó gi. Ndâ i gbí njí yù sàà gî. Ndú kû ù káa ndi o bà kili ndú. ");
INSERT INTO ndz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","À kpónó kû ko mboo nèté mì mbe kû kili i ꞌdo gbí njí ji yí. Yí kû kili i tacó ꞌvala ŋìnó mbe cee lá nô. Tàkòcò ndâ mbe kili i ꞌdo gbí njí ta mbe njí só bà peteke ká peteke. ");
INSERT INTO ndz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tacó có tí nó máa, ‹À ṛò njí a ꞌbí ꞌduù, káa à giì kili i ꞌdo gbí njí a ꞌbí ꞌduù nó› a yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ye bà tuu yo máa, yo ya gí bà kili i ꞌdo gbí njí. Àá táánò me yo ká ṛò njí tí nò lá. A ndâ ꞌbí ꞌduù tende ká mbu gítí . Káa a yo ká bà giì là bàà gbí wuꞌo mì ndú.» ");
INSERT INTO ndz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mbè ndâ ꞌduù Sàmárìyà tí nó mbe kaa gì gí mì Jézù ꞌdo gbí gbata tí nó náa niì tí nò kû ꞌvala gbí  nò giì ùnje gítí Jézù ta njembí ndú ꞌdo gbí có tí nó náa niì tí nò ꞌdè ji ndú ta ṛè Jézù máa, «Yí ꞌdè gbí ndâ i tí nó ꞌdáá náa ye bàkà gbí bà ꞌvala ye nó ji ye gî,» nô. ");
INSERT INTO ndz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tacó énò, ndú mâ giì yee mì Jézù, ndú giì ꞌdeke tí ndú ji yí, máa, yí dù á mì ndâ yì ta ndú gàà má kózò gî, wàa yí ꞌví giì ndii . Bìndi  Jézù giì ùnje gítí bà bàkà sili sósòꞌô mí mì ndú. ");
INSERT INTO ndz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ndâ mbe ꞌdi ndâ có mì wó gbí ndâ sili tí nò sósòꞌô náa yí bàkà mí mì ndú nò me mbè giì ùnje gítí wó ta njembí ndú. ");
INSERT INTO ndz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ndâ ꞌduù tí nò mbe ùnje gítí Jézù nò giì ꞌdè có ji nájú ndú tí nó mbe ya gí bà ma có tí Jézù ji ndú nó máa, «Ze kpónó ùnje gítí wó ta njembí ze dú, me ká gí tàkò có mì lo náa wò ꞌdè ji ze nó cuki lá. Ze ùnje gítí wó tacó ze ꞌdi ndâ có ꞌdo gbí nje wó ta tù ze gî. Ze delè giì ŋò ni gî máa, yí dú a mbe ꞌvala ndâ ꞌduù muu to tí nó ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jézù mâ giì sì ndâ sili tí nó sósòꞌô nó gî, yí giì ꞌbì ndi nó kû ya gí Gàlìléyà. ");
INSERT INTO ndz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yí ꞌdè ta nje wó sàà gî máa, «À te duù mítí mbe ꞌdòkò có mì Mbíṛì lá ká ꞌdóó ꞌbá mì ndú.» ");
INSERT INTO ndz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Káa, ndú mâ giì yee ta ndâ mbe tala có mì wó á ꞌdóó ꞌbá mì ndú Gàlìléyà, ndú giì ꞌde ndâ i tende. Ndâ ꞌduù kà giì te wiṛi mítí wó ta banga tí . Tacó ndú ŋò ŋa ndâ i tí nó náa yí bàkà á Jèrùzàlémè si ndú kà ta o gbolò o nó gî. ");
INSERT INTO ndz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Gbí ndâ sili tí nò náa Jézù kuu tí  gbí to Gàlìléyà nò, yí giì co wiṛi ya gí gbí gbata Kánà, tí gbata tí nò náa yí ꞌvìsì ngo tí pe gbí  ta o bà kò niì nô. ꞌBí gbolò ꞌduù ta ꞌviì mì wó ta nòꞌo tí wó gbí gbata Kàpàrànáwùmù, á tí nó gbèe ṛi ꞌdo Kánà, ");
INSERT INTO ndz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","mâ giì ꞌdi có énó máa, Jézù kuu gbí gbata Kánà, yí giì njè nó ya gí mì Jézù, bìndi  yí giì ꞌdeke tí wó ji yí máa, yí ya gí bà ꞌvala ꞌviì mì yì ꞌdo gbí ku, tacó sè  mì ꞌviì tí nò káa njembí wó. ");
INSERT INTO ndz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò máa, «ꞌBí ꞌduù jé mbe ùnje gítí ye gbí òkò tí yo wálá; yo kû gì gí mì ye ká tacó wàa ye ꞌví bàkà ndâ kpo-kpò seṛè ji yo.» ");
INSERT INTO ndz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Káa gbolò ꞌduù tí nò giì ꞌdeke tí wó ji Jézù máa, «Ngoꞌve tí lo a kùṛo bà ki njembí ꞌviì mì ye, kpo ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jézù bà-i-nò giì ꞌvìsì có ji yí máa, «Ya gí ꞌbá; ꞌviì mì lo bà ꞌvala gî.» ");
INSERT INTO ndz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Gbolò ꞌduù tí nò bà-i-nò giì ùnje gítí có mì Jézù gî. Bìndi  yí giì njè nó kû ya gí ꞌbá. Mâ giì zekeꞌo, yí giì ꞌde ndâ ꞌbí bòò mì wó kpokèjì kû ya gì tàkò wó ta banga ngú có ji yí máa, ꞌviì mì wó ꞌvala gî. ");
INSERT INTO ndz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Gbolò ꞌduù tí nò mâ giì ꞌvee ndâ bòò mì wó nò máa, «Gbí dìì ꞌviì tí nò ꞌbìtà bà nìkì ta o ngàyi?» Káa ndú giì ꞌvìsì có ji yí máa, «Mboṛo tí nò ꞌbìtà bà cee ꞌdo tí wó yáánó si ṛi mò tí ká njíꞌdí énô.» ");
INSERT INTO ndz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Gbolò ꞌduù tí nò giì ŋò ngé ni gî máa, ndâ ꞌduù tí nò nì ji yì nò gbúú-gbuu a o tí nó náa Jézù ꞌdè ta có ji yí máa, «ꞌViì mì lo bà ꞌvala gî,» nô. Tacó énò, ndú ta ndâ ꞌduù ꞌbá mì wó ꞌdáá gî giì ꞌbìtà bà ùnje gítí Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ŋìnò a bà só bà bàkà seṛè mì Jézù mí Gàlìléyà. Yí delè bàkà seṛè tí nò ká bìndi bà gì yí ꞌdo Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jézù giì njè nó ꞌdo Gàlìléyà ya gí bà ꞌbí gbolò o gbí tàkìì mì ndâ Jùdéyà á Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","À kuu tí  a ꞌbí dùgùù to ta ngo kuu gèjèè gbí , á seè ꞌbí njekèjì ndùgù bà ṛì gí gbí gbata Jèrùzàlémè náa à kû nì mítí  a Njekèjì-mì-ndâ-rómbo. Ṛè dùgùù to tí nò gbí có mì ndâ Jùdéyà a Bètìzátà. ");
INSERT INTO ndz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","À tò ndâ ndùúṛù vô mí ṛègbà dùgùù to tí nò tacó tí ndâ ꞌduù ŋìnó náa ku kiꞌviki ndú mí to gî nô, go ndâ mbe sú ṛò, ta ndâ mbe ku kò, ta ndâ ꞌduù ŋìnó mbe gbegeꞌve mí to gî nô. Ndâ mbe òꞌbù ta ndâ mbe ósú giì kili kpìṛìꞌvìì ta tà ndâ ndùúṛù tí nò kû ù bà gbàngà ngo tí nò, ");
INSERT INTO ndz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tacó ꞌbí ŋa o kuu tí  náa basìlì mì Mbíṛì má dù gî, yí kû gì gí tà ngo tí nò kû gbàngà ngo. Káa kpédélé mbe nòꞌo ŋìnó mbe ya gí tà ngo tí nò á bìndi bà gbàngà ngo mì basìlì tí nó kû co gí sè ꞌdo tà ngo kà tí cèe ꞌduù ta séꞌi tí wó kákáꞌi wálá. ");
INSERT INTO ndz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jézù mâ giì ya gí ṛègbà ngo tí nò, yí giì ŋò ꞌbí ꞌdakò ta nòꞌo tí wó kuu tísì. ꞌDakò tí nò dù tísì ta ndoò dê gítí ziꞌduù-só. ");
INSERT INTO ndz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jézù mâ giì zeke ꞌdakò tí nò, yí giì ŋò ká ngé ni gî máa, ꞌdakò tí nò dù gbí ŋa yê tí nò ta kôndi o. Jézù bà-i-nò giì ꞌvee yí máa, «À tí lo a go bà dù gbí dìì lo nìkì maa kákáꞌi?» ");
INSERT INTO ndz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Káa ꞌdakò tí nò giì ꞌvìsì có ji Jézù máa, «ꞌDuù mbe te ye ya tí  gí tà ngo gálà si ngo kû gbàngà tí wálá, Bu ye. Káa ye má ja tí ye kpòò, ye má bà yee kà, ndâ mbe nambeè te ꞌduù mì ndú ya tí  gí tà ngo sàà kùṛo ye gî.» ");
INSERT INTO ndz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jézù bà-i-nò giì ꞌvìsì có ji yí máa, «A gí yaà, wò ꞌví te kpâ-sili mì lo, wàa wò ꞌví nò nó!» ");
INSERT INTO ndz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mâ giì zekeꞌo, gbí dìì ꞌdakò tí nò giì da mbóꞌvóó gî. Yí giì paṛa kpâ-sili mì wó, bìndi  yí giì ꞌbìtà bà nò nó go có tí nò náa Jézù ꞌdè ji yí nò. Jézù ꞌvala ꞌdakò tí nò ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tacó énò, ndâ kpo ꞌduù mì ndâ Jùdéyà giì ꞌdè có ji ꞌdakò tí nò náa Jézù ꞌvala yí nò máa, «À wúnó a ṛi bà wotí gbí tàkìì mì ndoo tí ndâ Jùdéyà. À má énò, wò kpónó kû gbètèkè nò a tàkìì mì ndoo ta nèté bà te kpâ-sili mì lo nò.» ");
INSERT INTO ndz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Káa ꞌdakò tí nò giì ꞌvìsì có ji ndâ kpo ꞌduù mì ndâ Jùdéyà tí nò máa, «À ꞌdakò tí nó mbe ꞌvala ye ꞌdo gbí nòꞌo nó ká ꞌdè có ji ye máa, ye te kpâ-sili mì ye, wàa ye ꞌví njè nó.» ");
INSERT INTO ndz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ndâ kpo ꞌduù mì ndâ Jùdéyà bà-i-nò giì ꞌvee yí máa, «À ꞌdakò ꞌdi ká ꞌdè có ji wò máa, wò te kpâ-sili mì lo, wàa wò ꞌví njè nó?» ");
INSERT INTO ndz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ꞌDakò tí nò bà-i-nò giì bàkà bà tùbà tí Jézù ji ndâ kpo ꞌduù mì ndâ Jùdéyà tí nó mbe ꞌvee yí nò. Káa à giì kpò yí gî, tacó yí ŋò Jézù ni lá, káa Jézù ŋònòkò tí wó mí gbí òkò tí ndâ mbè ꞌduù tí nó mbe yè to gî nó gî. ");
INSERT INTO ndz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mâ giì zekeꞌo gàà énò, Jézù giì ꞌde ꞌdakò tí nò gbí ndùgù ꞌbá-Mbíṛì. Jézù mâ giì ŋò ꞌdakò tí nò, yí giì ꞌdè có ji yí máa, «Ŋò ká gi, gbí dìì lo kpónó gì nìkì maa kákáꞌi gî. À má énò, wò ꞌví bàkà vò i kákáꞌi lá, má wálá, ꞌbí gbolò i mbe ndii nòꞌo tí nò táánò mbe bàkà wò nò bà ꞌde wò.» ");
INSERT INTO ndz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ꞌDakò tí nò bà-i-nò giì dele ndi wó ya gí bà ꞌdè có ji ndâ kpo ꞌduù mì ndâ Jùdéyà tí nó mbe ꞌvee yí gítí ṛè mbe je yí gí gítí nèté bà paṛaka kpâ-sili ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà nó, máa, «Ṛè ꞌdakò tí nò mbe ꞌvala ye nò a Jézù.» ");
INSERT INTO ndz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ndâ kpo ꞌduù mì ndâ Jùdéyà mâ giì ꞌdi có énó máa, a Jézù ká ꞌdè có ji ꞌdakò tí nò máa, yí te kpâ-sili ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà nò, ndú giì ꞌbìtà bà bàkà gbínje ta yí, tacó yí bàkà ndâ i tí nò ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jézù mâ giì ꞌdi có tí nò náa ndâ kpo ꞌduù mì ndâ Jùdéyà ꞌdè gítí wó máa, yí kû gbètèkè tàkìì mì ndâ Jùdéyà nò, yí giì ꞌvìsì có ji ndú máa, «Bu ye kpónó go có tí nó náa ye kû ꞌdè ji yo nó kû bàkà nèté, à má énò, ye delè kû bàkà nèté go i mì wó nò.» ");
INSERT INTO ndz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Có tí nò náa Jézù ꞌvìsì gí tàkò có mì ndâ kpo ꞌduù mì ndâ Jùdéyà nò giì mìlìsé tí ndú go sé kà wu. Bìndi  ndòngbú có mì ndú náa ndú giì koṛo gítí wó a ŋìnó máa, ndâ yì má zi yí lá, ndâ yì kákáꞌi bà zi ꞌbí ꞌduù wálá. Ndú koṛo ŋa có tí nò me ká tacó náa Jézù gbètèkè ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà gî nò lá; tàkòcò ndú kpolo ngé ma a i gítí có bà ꞌvii tí Jézù ta Mbíṛì énó máa, Mbíṛì a ꞌdóó Bu yì. ");
INSERT INTO ndz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Káa Jézù giì ꞌvìsì có ji ndú gí tàkò bà waaka có mì ndú nò máa, «Ye kû ꞌdè có ji yo ta yúcó máa, ꞌViì kû bàkà i me ta muu wó lá; yí kû bàkà káa i ŋìnó náa yí ŋò Bu wó kû bàkà nó cuki. ");
INSERT INTO ndz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tacó Bu ꞌViì zè ꞌViì mì wó nìkì ma, tacó énò, yí giì tùbà ndâ i ŋìnó ꞌdáá gî náa yí kû bàkà nó ji ꞌViì mì wó. Bu ꞌViì bà giì tùbà bà bàkà ndâ ꞌbí nèté mbe ndii ndâ ŋìnò gî ji ꞌViì mì wó. Yí bà giì tùbà bà bàkà ndâ i ŋìnó náa bà ꞌdè có gítí ndú bà kpo nje yo gî nó ji ꞌViì mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bu ꞌViì a mbe kû je woò ji ndâ ku; à má énò, ꞌViì delè kû je woò ji ndâ ꞌduù ŋìnó mbe nìkì tí wó nó go i mì Bu wó. ");
INSERT INTO ndz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bu ꞌViì me mbe waa có mítí ꞌduù lá, tacó yí je wotí bà waa có mítí ndâ ꞌduù ꞌdáá gî ji ꞌViì mì wó gî, ");
INSERT INTO ndz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tacó wàa, ndâ ꞌduù ꞌví te ta duù mítí ꞌViì mì wó, á go ŋìnó náa ndú kû te ta duù mítí wó tí Bu ꞌViì nô. ꞌDuù mbe biya bà te duù mítí ꞌViì gî, yí biya nò a bà te duù mítí Bu ꞌViì tí mbe tuu ꞌViì gî. ");
INSERT INTO ndz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ye kû ꞌdè có ji yo ta yúcó máa, ꞌduù mbe ꞌdi có mì ye, wàa yí ꞌví ùnje gítí mbe tuu ye, bà ꞌvala ká dúú bà ya tí . Gbí ndeṛè bà ꞌviiki gbí nje wó bìndi ku mì wó bà dù wálá. Yí bà ya ká ngé ndírí gí gbí ꞌválá ŋìnó mbe cee lá nó bìndi ku mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ye kû ꞌdè có ji yo ta yúcó máa, o tí nò ká kèjì, à má ta bà ꞌdè ta yúcó, à kpónó nó a o tí nò, náa ndâ ku bà giì ꞌdi kòcò ꞌViì mì Mbíṛì, bìndi  ndâ mbe ꞌdi kòcò wó ꞌdáá gî bà ꞌvala gî. ");
INSERT INTO ndz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tacó Bu ꞌViì, tí ṛèngbó ꞌválá, bàkà ꞌViì mì wó tí ṛèngbó ꞌválá gî. ");
INSERT INTO ndz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yí delè giì je wotí bà waa có ji yí ndii ndâ ꞌbí mbe waa có muu to tí nó ꞌdáá gî, sé náa yí a ꞌViì-mì-ꞌDakò nò. ");
INSERT INTO ndz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nje yo ꞌví ꞌdèè gítí có tí nò lá, tacó o tí nò ká kèjì náa ndâ ku gbí gùù bà giì ꞌdi gbí kòcò wó, ");
INSERT INTO ndz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bìndi  ndâ ku ŋìnó mbe bàkà tó i táánò si ndú kû ꞌvala muu to tí nó nó bà giì ꞌvala ndi ndú ꞌdo gbí muuꞌdú ndú, gí gbí ꞌválá ŋìnó mbe cee lá nô; bìndi  ndâ ku ŋìnó táánò mbe bàkà tó i si ndú kû ꞌvala muu to tí nó lá nó bà ꞌvala dó gbí muuꞌdú ndú gí bà ŋò vò i mì ndú. ");
INSERT INTO ndz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ye bàkà i ta muu ye lá. Ye kû waa có ká go ŋìnó náa à ꞌdè ji ye gî. Ye delè kû waa có ká jáá, tacó à gbí muu ye me có bà bàkà go ꞌdóó có mì ye lá. À gbí muu ye a có bà bàkà go có mì ꞌduù tí nó mbe tuu ye nô. ");
INSERT INTO ndz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ye táánò má kû koṛo có a i gítí miṛi ye, máa, ye énó, wàa ye énó, wàa ye énó, mbe ùnje gítí ndâ có mì ye máa, ye kû ꞌdè a yúcó nò, bà dù wálá. ");
INSERT INTO ndz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Káa ye ŋò ni gî máa, ꞌbí ꞌduù tí mbe ꞌdè yúcó mbe kû ꞌdè có muu ye kuu tí . ");
INSERT INTO ndz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yo táánò tuu ndâ ꞌduù mì yo ji Jòvánì tí mbe caka tí ndâ ꞌduù, bìndi  yí giì ꞌdè yúcó muu ye ji ndú gì tí  ji yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ye ꞌdè có tí nò ji yo tacó bà ꞌvala yo. Ye ꞌdè ji yo me tacó máa, ye kû tee njembí ye kpolo ma a i mítí ꞌbí ꞌduù muu to tí nó máa yí ꞌví ꞌdè có muu ye nò lá. ");
INSERT INTO ndz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jòvánì tí mbe caka tí ndâ ꞌduù táánò a wu mbe kû zìì á nje kùpò. Tàkòcò yo delè táánò peteke ta líkíꞌo bà dù gbí ngba wó tè gî. ");
INSERT INTO ndz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Káa ꞌdóó có mì ye náa ye bà ꞌdè gítí miṛi ye mbe ndii yúcó mì Jòvánì tí mbe caka tí ndâ ꞌduù náa yí ꞌdè gítí ye nò kuu tí . Có mì ye nò a ndâ nèté tí nó náa Bu ye tuu ta ye, máa, ye bàkà nô. À delè a ndâ nèté tí nò ká kû tùbà  énó máa, a Bu ye ká tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ꞌBí mbe ꞌdè có muu ye á bìndi ndâ nèté mì ye a Bu ye tí nó mbe tuu ye nô. Yo jé ꞌdi kòcò wó ta tù yo lá. Yo delè jé ŋò yí ta ṛo yo lá. ");
INSERT INTO ndz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Có mì wó delè dù gbí njembí yo lá, tacó yo ùnje gítí ꞌduù tí nó náa a yí ká tuu yí nó lá. ");
INSERT INTO ndz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yo kû jè ta bà ꞌdi gbí ndâ có gbí wáràgà mì Mbíṛì, tacó yo koṛo có máa, à gbí wáràgà mì Mbíṛì a ndâ có mbe kû je ꞌválá ŋìnó mbe cee lá nó ji yo. Káa à gbí wáràgà tí nò mì Mbíṛì nò a ndâ có gítí ye. ");
INSERT INTO ndz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Káa, ta ndâ ŋa ŋìnò ꞌdáá gî, yo biya bà gì gí mì ye, tacó bà ꞌde ꞌválá ŋìnó mbe cee lá nó gî. ");
INSERT INTO ndz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ye kû ꞌdè có tí nò ji yo me tacó máa, ye kû pà a bà ùlù ye mì ndâ ꞌduù nò lá. ");
INSERT INTO ndz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Káa ye ŋò yo ni ngbáṛángàꞌi gî. Ye ŋò ni gî máa, yo zè Mbíṛì nìkì gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A Bu ye ká tuu ye ji yo, káa yo giì bè ye gî. Káa ꞌbí ꞌduù kpónó má gì ta ꞌdóó nó wiṛi mì wó gí mì yo, yo bà te wiṛi mítí wó gî. ");
INSERT INTO ndz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gbèe ꞌbí có gítí bà pà kpokèjì gítí bà ùlù yo mì Mbíṛì gbí muu yo gbaànjé wálá. À kpolo mì yo cuki káa có gítí bà ùlù tí yo gbí òkò tí yo. À má énò, a ŋa yè muu to tí nó ká bà si yo ꞌví ùnje ta njembí yo gbaànjé gítí ye? ");
INSERT INTO ndz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yo kpónó kû koṛo có máa, a ye ká bà kpì ngbàngà tí yo ji Bu ye, káa, à me énò lá. A Mòze, tí ꞌduù tí nó náa yo kû tee njembí yo kpolo ma á mítí wó nó, ká bà kpì ngbàngà tí yo. ");
INSERT INTO ndz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yo táánò má ùnje gítí Mòze ta njembí yo dú, yo kùtàá bà ùnje gítí ye ta njembí yo gbaànjé gî, tacó Mòze táánò kû cu có gítí ye mì gbí wáràgà mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Káa yo má biya bà ùnje gítí ndâ có tí nó náa Mòze táánò cu mì gbí wáràgà nó gî, a ŋa yè ká bà si yo ꞌví ùnje gítí ndâ có tí nó náa ye kû ꞌdè ji yo nó?» ");
INSERT INTO ndz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ta ꞌbí o gbaànjé bìndi bà dele ndâ Jézù ta ndâ mbe tala có mì wó ꞌdo Jùdéyà gí Gàlìléyà, ndú giì di ngo gí tìto kàpá Gàlìléyà, náa à kû nì mítí  a kàpá Tìbérìyà delè. ");
INSERT INTO ndz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ndâ ꞌduù me mbè bà-i-nò giì kaa ya gí tàkò ndú, tacó ndú ŋo ŋa ndâ seṛè bà ꞌvala ndâ mbe nòꞌo tí nó náa Jézù bàkà ta ndi to nó gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jézù bà-i-nò giì kaa ndâ mbe tala có mì wó, bìndi  ndú giì ya gí bà ki tí ndú to á pí gú. ");
INSERT INTO ndz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ndú ya ta nó tí nò si o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì dooko gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jézù mâ giì ꞌva ṛo wó ꞌdo pí gú kà gí tàgbà gú, yí giì ŋò ndâ ꞌduù mósú-mosu-mòsù á kèjì gí tàkò ndú ta ndâ mbe tala có mì wó pí gú kà. Jézù bà-i-nò giì ꞌvee ꞌbí mbe tala có mì wó ta ṛè wó a Fìlípò máa, «Ndoo wúnó bà sì i-zó-zò ꞌdo kòtí ꞌdi tacó bà je ji ndâ ŋa ndâ ꞌduù tí zó kèjì zó?» ");
INSERT INTO ndz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jézù ꞌvee ꞌvé tí nò ká tacó bà ꞌdi có ꞌdo gbí yì Fìlípò, tacó yí tí Jézù ŋò i bà bàkà ji ndâ ꞌduù tí nò ni sàà gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Káa Fìlípò giì ꞌvìsì có ji Jézù máa, «Ndoo kpêtí má ꞌdè có máa, ndoo pà ji ndú káa làmbu i tacó bà njù ta ngo, gbí  go énó máa, ndoo bà sì i-zó-zò ta i me gbolò, ndâ-ꞌbî-lá go njì fádà 200.» ");
INSERT INTO ndz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ꞌBí mbe tala có mì Jézù ta ṛè wó a Àndèréyà, tí náꞌvindí Sìmónè Pìyétòrò, giì ꞌvìsì có ji Jézù gí tàkò có tí nò náa ndú kû ꞌdè ta Fìlípò nò, máa, ");
INSERT INTO ndz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Ye kùtàá ŋò ndâ ꞌbí cèe kù kô tí nó mì ndoo nó vô, ta ndâ njì sè sósòꞌô, á mì ꞌbí ꞌviì-ꞌdakò, káa, ye ŋò ni gî máa, à nò me i gítí ŋa mbè tí nò á kèjì nò lá.» ");
INSERT INTO ndz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ndâ ꞌduù tí nò mâ giì yee pí gú tàkò ndâ Jézù gî, Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Yo si ndâ ꞌduù tí nò ꞌví ki tí ndú to.» Mbílì ta o tí nò màꞌbàà kuu ta to tí bàndò tí nò. Tacó énò, ndâ ꞌduù giì ki tí ndú to ta ndi gbí mbílì tí nò. Muu ndâ ꞌdakò ta o tí nò ꞌdáá gî álìfì vô. ");
INSERT INTO ndz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ndâ ꞌduù tí nò mâ giì ki tí ndú to gî, Jézù giì kaa ndâ kù kô tí nó vô náa Àndèréyà ꞌdè có gítí ndú ji yí mì ꞌbí ꞌviì nó, yí giì ꞌdè nìkì maa ji Mbíṛì, má kózò gî, yí giì kaa ji ndâ ꞌduù. Yí giì dele ndi wó giì kaa ndâ njì sè tí nó sósòꞌô mì gbèe ꞌviì tí nò nó, yí kákáꞌi giì ꞌdè nìkì maa ji Mbíṛì, bìndi  yí giì kaa ndú gí tàkò ndâ kù kô tí nó vô nó ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ndâ ꞌduù mâ giì zò i yè yì ndú ꞌdáá gî gî, Jézù giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Yo kili ndâ sè i-zó-zò ŋìnó ta to bìndi ndú nó ꞌdáá gî. Yo si ꞌbí làmbu i ꞌví volo mí to lá.» ");
INSERT INTO ndz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ndâ mbe tala có mì Jézù bà-i-nò giì kili sè i-zó-zò bìndi ndâ ꞌduù tí nò yeke ndâ kèè muuꞌbì-nje só. ");
INSERT INTO ndz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ndâ ꞌduù mâ giì ŋò ŋa seṛè tí nó náa Jézù bàkà nó, ndú giì ꞌdè có máa, «Ŋìnó dú káa mbe ꞌdòkò có mì Mbíṛì tí nó náa Mòze táánò ꞌdè có ji ndâ ꞌduù gítí wó máa, yí bà gì gí muu to tí nó nó ká nô.» ");
INSERT INTO ndz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jézù mâ giì ꞌdi có tí nò, yí giì ŋò ni gî máa, a gbí muu ndâ ꞌduù tí nò a có bà zèè yì, wàa ndú ꞌví bàkà yì tí gba mì ndú ta wotí. Tacó énò, yí giì ndo ta kpéétí wó ꞌdo gbí òkò tí ndú ya gí gbí òkò ndâ gú. ");
INSERT INTO ndz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ꞌDêꞌo mâ giì bàkà tí gî, ndâ mbe tala có mì Jézù giì kaa ꞌdo pí gú ya gítí kàpá, ");
INSERT INTO ndz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tacó bà di ngo ya gí gbí gbata Kàpàrànáwùmù, si Jézù ta kpéétí wó mí gbí òkò ndâ gú, si o kû me pìtì-pìtì énô. ");
INSERT INTO ndz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Káa si ndú ta gbâ ṛo ngo, ngo giì ꞌbìtà bà gbàngà tí gbí pù ta pípìṛi ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ndâ mbe tala có mì Jézù mâ giì ya ta gbâ ta kpéétí ndú kpòṛó gí gbí u ngo gî, ndú giì ŋò ꞌduù kû nò nó có ṛo ngo kèjì gí tàkò ndú. Káa ndú ŋò ni énó máa ꞌduù tí nò a Jézù nò lá. Yí mâ giì dooko ta ndú gî, gúku giì zèè ndú tí vò ŋa ŋìnô. ");
INSERT INTO ndz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Káa Jézù giì ꞌdè có ji ndú máa, «Yo cì gúku lá; a ye!» ");
INSERT INTO ndz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","À giì dù gbí muu ndâ mbe tala có mì Jézù bìndi bà tùbà tí wó ji ndú nò a có bà te yí mí gbí gbâ, wàa ndâ yì ꞌví ya ta ndú gí tìto, káa ndú mâ giì kì ṛo ndú, ndú giì ꞌde tí ndú ta ndâ Jézù ngé tì ngo tí bàndò tí nó náa ndú kû koṛo có bà ya gítí  nô. ");
INSERT INTO ndz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ndâ mbè ꞌduù tí nó mbe tè ṛì gbí kùdù kô nó mâ giì ya gí tàbèꞌdè kàpá ta dúꞌo ta yé bìndi bà je i-zó-zò ji ndú mì Jézù, ndú giì ꞌde gbèe gbâ ṛo ngo lá, káa ndú ŋò Jézù o gí gbí gbâ ta o bà di ngo mì ndâ mbe tala có mì wó lá. ");
INSERT INTO ndz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ndâ ꞌbí gbâ mbe gì ꞌdo gbí gbata Tìbérìyà mâ giì ṛò tíyò dê ꞌvii ta bàndò tí nò náa ndâ ꞌduù zò i tí  nò, ");
INSERT INTO ndz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ndâ mbè ꞌduù tí nò mbe kû pà bà tí Jézù nò giì oloko mí gbí ndú, tacó ndú ꞌde Jézù lá. Ndú delè ꞌde vòó ndâ mbe tala có mì wó lá. Ndú bà-i-nò giì di ngo gí gbí gbata Kàpàrànáwùmù, tacó bà pà bà tí Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ndú mâ giì ꞌde yí gî, ndú giì ꞌvee yí máa, «Wò di ngo gí tìto kàá ta o ngàyi, mbe nìbà i?» ");
INSERT INTO ndz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kû ꞌdè có ji yo ta yúcó máa, yo kû pà bà tí ye me tacó máa, yo ŋò ndâ seṛè tí nó náa ye bàkà ndú nó gî, nò lá. Yo kû pà bà tí ye, tacó yo zò i yè yì yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yo si bà yeeke tí yo ká tacó ŋa i-zó-zò ŋìnó mbe dù gbí yì yo tí ká lá nó cuki mí to. Yo bàkà nèté a i tacó ŋa i-zó-zò ŋìnó mbe je ꞌválá ŋìnó mbe cee lá nó ji yo nô. Ŋìnò a ŋa i-zó-zò náa ꞌViì-mì-ꞌDakò kû je ji yo, tacó Bu ye tí Mbíṛì bàkà ꞌdóó ndi ꞌbì wó mítí ꞌViì-mì-ꞌDakò gî.» ");
INSERT INTO ndz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Káa ndâ ꞌduù tí nò giì ꞌvee Jézù máa, «Ze ꞌví bàkà a ŋa yè, tacó wàa ze ꞌví bàkà ta ndâ i ŋìnó mbe nìkì tí Mbíṛì nó?» ");
INSERT INTO ndz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jézù bà-i-nò giì ꞌvìsì có ji ndú máa, «Nèté ŋìnó ta go  tí Mbíṛì máa yo ꞌví bàkà nó a bà ùnje ta njembí yo gbaànjé gítí ꞌduù tí nó náa yí tí Mbíṛì tuu yí nô.» ");
INSERT INTO ndz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Káa ndâ ꞌduù tí nò giì ꞌvee Jézù máa, «Ze ꞌví ŋò ni ta yè máa, a Mbíṛì ká tuu wò? Wò bà bàkà ji ze a ŋa yè, wàa ze ꞌví ŋò ta wò ni tí tú mì Mbíṛì? ");
INSERT INTO ndz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ze ꞌvee wò énò tacó Mòze dígísèé je mánà tí i-zó-zò ji ndâ ká gù ze si ndú gbí kángáá nga ngoò, go có tí nó náa à cu mí gbí wáràgà mì Mbíṛì énó máa, ‹Yí táánò je i-zó-zò ji ndú ꞌdo gbíṛì› nô.» ");
INSERT INTO ndz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kû ꞌdè có ji yo ta yúcó máa, à dígísèé me Mòze ká je i-zó-zò ꞌdo gbíṛì ji ndâ ká gù yo lá. À Bu ye táánò ká je i-zó-zò ji ndú á ꞌdo gbíṛì. À kpónó delè káa Bu ye ká kû je i-zó-zò ji yo ꞌdo gbíṛì, tí cèe i-zó-zò, ");
INSERT INTO ndz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","tacó i-zó-zò mì Mbíṛì a ŋìnó mbe kû gì ꞌdo gbíṛì. I-zó-zò mì Mbíṛì a ŋìnó mbe kû ꞌvala ndâ ꞌduù muu to tí nô.» ");
INSERT INTO ndz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ndâ ꞌduù tí nò bà-i-nò giì ꞌdeke tí ndú ji Jézù máa, «Je ŋa i-zó-zò tí nò ta o ꞌdáá gî ji ze.» ");
INSERT INTO ndz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye a i-zó-zò ŋìnó mbe kû je ꞌválá ji ndâ ꞌduù nô. ꞌDuù má gì gí mì ye gî, go bà bàkà yí kákáꞌi wálá. ꞌDuù má ùnje ta njembí wó gbaànjé gítí ye gî, go ngo bà bàkà yí kákáꞌi wálá. ");
INSERT INTO ndz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ye ꞌdè có ji yo sàà gî máa, yo ŋò ye gî, káa ta ndâ ŋìnò ꞌdáá gî, yo ùnje gítí ye lá. ");
INSERT INTO ndz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ndâ ꞌduù ŋìnò ꞌdáá náa Bu ye je ndú ji ye nó bà gì gí mì ye. Káa ꞌduù má gì gí mì ye gî, ye bà bè yí wálá. ");
INSERT INTO ndz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tacó ye gì ꞌdo gbíṛì me tacó bà bàkà go ꞌdóó có mì ye gbí muu ye lá. Ye gì a i tacó bà bàkà go có mì mbe tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Káa có mì mbe tuu ye énó máa, ye ꞌví si ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ꞌduù tí nó náa yì kaa ndú ji ye nó ꞌví giṛi lá. Có mì wó máa, ye ꞌví ꞌvala ndi ndâ ꞌduù tí nó náa yì kaa ndú ji ye nó ꞌdo gbí muuꞌdú ndú ꞌdáá gî ta ndòngbú o. ");
INSERT INTO ndz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Có mì Bu ye énó máa, ꞌduù mbe ŋò ꞌViì mì yì ni gî, bìndi  yí giì ùnje ta njembí wó gbaànjé gítí wó gî nó, bà ꞌde ꞌválá ŋìnó mbe cee lá nô; à má énò, ye bà ꞌvala ndi ndú ꞌdo gbí muuꞌdú ndú ta ndòngbú o.» ");
INSERT INTO ndz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ndâ Jùdéyà mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, ndú giì ꞌbìtà bà fiini có gbí òkò tí ndú gítí Jézù, tacó có tí nó náa yí ꞌdè énó máa, yì a i-zó-zò mbe gí ꞌdo gbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Máa, «À kû gbúú-gbuu nó a Jézù tí nó tí ꞌviì mì Jùzépè nó ká kuu kùṛo ndoo nô. Ndoo ŋò ndâ bu wó ta nawu wó ni ngbáṛángàꞌi gî. Káa yí giì dù ndíi ŋìnó kû ꞌdè có máa, yì gì ꞌdo gbíṛì nó, ta ŋa kpokèjì ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo si bà fiini có gbí òkò tí yo mí to. ");
INSERT INTO ndz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tacó ꞌbí ꞌduù gbaànjé bà gì gí mì ye ta muu wó wálá, sè  káa ŋìnó máa, a Bu ye tí nó tí mbe tuu ye nó ká gbà tàmuu wó gì tí  ji ye. Káa ye bà ꞌvala yí ꞌdo gbí muuꞌdú wó ta ndòngbú o gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tacó à cu mí gbí wáràgà mì ndâ mbe ꞌdòkò có mì Mbíṛì énó máa, ‹Mbíṛì bà nìbà i ji ndâ ꞌduù ꞌdáá gî.› Káa bà gì gí mì ye a bà sè tù tí bà nìbà i mì Bu ye, ta bà mèlè bà bàkà go có tí nò náa wò ꞌdi nò. ");
INSERT INTO ndz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gbí có tí nò me énó máa, ndâ ꞌduù ꞌdáá gî ŋò Bu ye ta ṛo ndú gî nò lá. À káa ꞌduù tí nó gbaànjé mbe gì ꞌdo mì Mbíṛì nó ká ŋò Bu ye ta ṛo wó. ");
INSERT INTO ndz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ye kû ꞌdè có ji yo ta yúcó máa, ꞌduù ŋìnó mbe ùnje gítí ye gî nó bà ꞌvala ká dúú bà ya tí . ");
INSERT INTO ndz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ye a i-zó-zò mbe ꞌvala ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ndâ ká gù yo dígísèé zò mánà gbí kángáá nga ngoò, káa ndú giì mìì ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Káa ye a i-zó-zò ŋìnó mbe gì ꞌdo gbíṛì, tacó wàa, ꞌduù má zò ye gî, yí ꞌví cì lá nô. ");
INSERT INTO ndz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ye a i-zó-zò ŋìnó mbe gì ꞌdo gbíṛì, mbe kû ꞌvala ndâ ꞌduù nô. ꞌDuù ŋìnó mbe zò i-zó-zò tí nò gî bà ꞌvala ká dúú bà ya tí . Káa i-zó-zò tí nò náa ye bà je ji ndâ ꞌduù nò a dìì ye, tacó bà ꞌvala ndâ ꞌduù á muu to tí nô.» ");
INSERT INTO ndz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ndâ Jùdéyà bà-i-nò giì ꞌbìtà bà ꞌviiki gbí có tí nò náa Jézù ꞌdè nò ta wotí tí  ta kpéétí ndú máa, «ꞌDakò tí nò bà waa dìì wó ji ndoo wàa ndoo ꞌví zò ta ŋa kpokèjì ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kû ꞌdè có ji yo ta yúcó máa, yo má zò dìì ꞌViì-mì-ꞌDakò lá, yo delè má njù mbelè wò lá, yo bà ꞌde ꞌvala ŋìnó mbe cee lá nó wálá. ");
INSERT INTO ndz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ꞌDuù mbe zò dìì ye gî, bìndi  yí giì njù mbelè ye gî, bà ꞌvala ká dúú bá ya tí . Ye delè bà ꞌvala yí ꞌdo gbí muuꞌdú wó ta ndòngbú o. ");
INSERT INTO ndz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tacó dìì ye a cèe i-zó-zò, bìndi  mbelè ye a cèe ngo. ");
INSERT INTO ndz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ꞌDuù mbe zò dìì ye gî, bìndi  yí giì njù mbelè ye gî, ꞌduù tí nò á ꞌdóó dìì ye, ye delè a ꞌdóó dìì wó. ");
INSERT INTO ndz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ꞌDuù tí nò bà ꞌde ꞌválá ꞌdo mì ye, go ŋìnó náa ye kû ꞌde ta ꞌválá ꞌdo mì Bu ye tí ṛèngbó ꞌválá, tí mbe tuu ye nô. ");
INSERT INTO ndz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Dìì ye a i-zó-zò mbe gì ꞌdo gbíṛì. ꞌDuù mbe zò i-zó-zò tí nò bà ꞌvala ká dúú bà ya tí . Dìì ye a tende ŋa i-zó-zò, a me ŋa i-zó-zò tí nó náa ndâ ká gù yo zò dígísèé, káa ndú giì mìì gî nó, lá.» ");
INSERT INTO ndz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jézù ꞌdè ndâ có mì wó nò ji ndâ ꞌduù á mí bàndò bà kili ndú gí bà ùlù Mbíṛì gbí gbata Kàpàrànáwùmù. ");
INSERT INTO ndz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jézù mâ giì nìbà i ji ndâ ꞌduù cee gî, ndâ ꞌduù me mbè ꞌdo gbí òkò tí ndâ mbe tala có mì wó giì ꞌdè có gbí òkò tí ndú máa, «Wotí tí bà nìbà i mì wó ngé ndii gî. A ꞌdi ká bà ꞌdi gbí ndâ ŋa ndâ kpo-kpò có mì wó nò?» ");
INSERT INTO ndz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jézù mâ giì ŋò ni gî máa, ndâ mbe tala có mì yì kû ꞌdè kòlòwò gítí ndâ có tí nó náa yí ꞌdè ji ndâ ꞌduù nó, yí giì ꞌvee ndú máa, «Tàkòcò yo kû kpóló-kpolo gítí ndâ có tí nò náa ye ꞌdè nò? ");
INSERT INTO ndz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Káa yo kùtàá má ŋò énò a bà ya ꞌViì-mì-ꞌDakò á gí gbíṛì, yo bà me ta tí yo ée? ");
INSERT INTO ndz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A Bèṛi-mì-Mbíṛì ká kû je ꞌválá ji ꞌduù. ꞌDuù ꞌvala ꞌduù lá. Ndâ có tí nò náa ye ꞌdè nò a Bèṛi-mì-Mbíṛì tí mbe je ꞌválá ji yo. Ndâ có tí nò delè a ꞌválá. ");
INSERT INTO ndz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Káa ndâ ꞌbí ꞌduù gbí òkò tí yo ùnje gítí ndâ có mì ye nò lá.» Jézù ꞌdè có tí nò tacó yí ŋò ndâ mbe ùnje gítí có mì wó lá, ta dê ꞌduù mì wó nó kpokèjì gí bà dù tí mbe ba ngbù wó nó ni sàà gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tacó énò, Jézù bà-i-nò giì ꞌdè có ji ndâ ꞌduù máa, «Ŋìnò a ndeṛè có tí nò náa ye kùtàá ꞌdè ta có ji yo máa, ꞌduù bà ꞌde wotí gítí bà gì gí mì ye ta kpéétí wó wálá, sè  káa ŋìnó a Bu ye ká ùnje ji yí nò ká nò.» ");
INSERT INTO ndz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ndâ mbe tala có mì Jézù me mbè giì jee bà ṛu ndi wó mí to á bìndi có tí nò náa yí ꞌdè nò gî. ");
INSERT INTO ndz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jézù mâ giì ŋò bà biya bà ṛu ndi wó mì ndâ ꞌbí mbe tala có mì wó, yí bà-i-nò giì ꞌvee ndâ ŋìnó muuꞌbì-nje só náa yí ṛuka ndú nó, máa, «Káa yo ŋìndi yo, go bà ya ta ndâ ka yo tí yo wálá?» ");
INSERT INTO ndz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Káa Sìmónè Pìyétòrò giì ꞌvìsì có ji yí máa, «Ze ꞌví ya gí mì ꞌdi, Mbe tí ze? A wò ká kû ꞌdè ndâ có ŋìnó mbe kû ꞌvala ndâ ꞌduù nô. ");
INSERT INTO ndz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ze ùnje gî, ze delè giì ŋò ni ngbáṛángàꞌi gî, máa, wò a ꞌduù ŋìnó náa Mbíṛì kaa wò mò gí mì wó gî.» ");
INSERT INTO ndz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Káa Jézù giì ꞌvìsì có ji ndâ Sìmónè Pìyétòrò máa, «À wálá a ye táánò ká cu ꞌbì ye mítí yo ta bà muu yo muuꞌbì-nje só nó? Káa ꞌbí ꞌduù gbaànjé á ꞌdo gbí òkò tí yo jìꞌvì kàzà mítí ye gî.» ");
INSERT INTO ndz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jézù ta o tí nò kû gbì tì kpô a i gítí Júdà, tí ꞌviì mì Sìmónè Ìsìkàrìyótè, tí ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ mbe tala có mì wó muuꞌbì-nje só náa yí ṛuka ndú nô. Tacó a Júdà ká bà giì ba ngbù wó tí Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jézù giì dù kû nò nó ká ta ndi gbí ndâ to Gàlìléyà. Go bà ya gí gbí to Jùdéyà giì dù tí wó lá, tacó ndâ kpo ꞌduù mì ndâ Jùdéyà kà kû pà kpokèjì gítí wó tacó bà zi yí. ");
INSERT INTO ndz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kùṛo o bà bàkà tàkìì bà tò ndùúṛù gbí tàkìì mì ndâ Jùdéyà mâ giì dooko gî, ");
INSERT INTO ndz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ndâ náꞌvindí Jézù á Gàlìléyà giì ꞌdè có ji yí máa, «Ya gí Jùdéyà, tacó wàa ndâ mbe tala có mì lo ꞌví ŋò ta ngba lo ta ndâ nèté mì lo náa wò kû bàkà nó á kà. ");
INSERT INTO ndz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tacó ꞌduù ŋìnó ta go bà dù tí gbolò ꞌduù á kùṛo ndâ ꞌduù tí wó nó bàkà i gbí kóó lá. Káa wò lê má kû bàkà ndâ i tí nò, bàkà ndú mí kùṛo ndâ ꞌduù ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ndâ náꞌvindí Jézù ꞌdè ŋa có tí nò ji yí tacó à kpêtí káa ndú, ndú ùnje gítí ndâ i tí nò náa Jézù kû bàkà nò lá. ");
INSERT INTO ndz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Káa Jézù giì ꞌvìsì có ji ndú máa, «O bà ya ye gí Jùdéyà gì kálásê. Káa à má gítí yo, o ꞌdáá gî káa o bà ya yo gí Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ndâ ꞌduù muu to tí nó sogo yo lá. Káa ndú kû sogo ye. Ndú kû sogo ye tacó ye ta o ꞌdáá gî kû ꞌdè có ji ndú máa, ndâ kpokèjì mì ndú a ndâ vò kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","À má énò, yo ya gí bà tì o bà tò ndùúṛù gbí tàkìì mì ndoo. Ye bà ya gí bà o tí nò wálá, tacó o bà ya ye gì kálásê.» ");
INSERT INTO ndz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ndâ náꞌvindí Jézù giì kaa ya gí Jùdéyà si yí mí Gàlìléyà á bìndi có tí nò. ");
INSERT INTO ndz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ndâ náꞌvindí Jézù mâ giì kaa ya gí bà tì o bà tò ndùúṛù gbí tàkìì mì ndâ Jùdéyà gî, Jézù giì njè nó ya gí tàkò ndú ta ꞌdóó o mì wó náa à gbí muu wó ta kpéétí wó. Yí mâ giì yee kà, yí giì dù ká gbí kóó. ");
INSERT INTO ndz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Káa ṛo ndâ kpo ꞌduù mì ndâ Jùdéyà ta gbolò o tí nò ꞌdáá gî ká gí kpokèjì tí wó. Ndú mâ giì ŋò yí lá, ndú giì dù kû ꞌvee ꞌvé gbí òkò tí ndú máa, «Yí ngò? Yí kòtí ꞌdi? ꞌDakò tí nò ngò?» ");
INSERT INTO ndz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Káa ndâ sè mbè ꞌduù ŋìndi ndú kû giì ꞌdè a ngûcó ta ṛè wó. Ndâ ꞌbí ꞌduù gbí òkò tí ndú máa, «Yí a tó ꞌduù!» Ndâ ꞌbí ꞌduù máa, «Yí a vò mbe ŋònòkò muu ndâ ꞌduù!» ");
INSERT INTO ndz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Gbèe ꞌduù mbe ꞌdè có ta ṛè wó gí yaà wálá, tacó ndâ ꞌduù ꞌdáá gî ta o tí nò kû cì gúku tí ndâ kpo ꞌduù mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ndâ ꞌduù mâ giì yee gbí jígíꞌdí-jìgìꞌdì sili mì o bà bàkà tàkìì bà tò ndùúṛù gî, Jézù giì ṛì gí gbí ndùgù ꞌbá-Mbíṛì, bìndi  yí giì ꞌbìtà bà nìbà i ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ndâ kpo ꞌduù mì ndâ Jùdéyà mâ giì ŋò yí kû nìbà i, nje ndú giì ꞌdèè gî. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú máa, «ꞌDakò tí nò ꞌde ŋa muu tí nò ꞌdo kòtí ꞌdi, káa yí jé ta ꞌbí gbèe ṛi ki tí wó kùṛo ꞌbí mbe nìbà tàkìì mì ndâ Jùdéyà lá.» ");
INSERT INTO ndz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Káa Jézù mâ giì ŋò ŋa bà koṛo có mì ndú nò, yí giì ꞌvìsì có ji ndú máa, «Ye kû nìbà me ꞌdóó có mì ye gbí muu ye lá. Ye kû nì a bà có mì mbe tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Go bà bàkà go có mì Mbíṛì má kuu tí ꞌduù, yí bà ŋò ni gî máa, ye kû nì a bà có mì Mbíṛì. Káa ye má kû nì a bà ꞌdóó có mì ye, ꞌduù tí nò delè bà ŋò ni gî. ");
INSERT INTO ndz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tacó ꞌduù má kû nìbà a ꞌdóó có mì wó, à gbí muu wó a có máa, ndâ ꞌduù ꞌví te duù mítí yì. Káa ꞌduù ŋìnó mbe kû bàkà nèté tacó wàa ndâ ꞌduù ꞌví te ta duù mítí mbe tuu yì nó a ꞌduù jáá, yí delè me mbe ꞌviya lá. ");
INSERT INTO ndz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mòze dígísèé ꞌdè có ji yo lá? Káa ꞌbí ꞌduù gbaànjé gbí òkò tí yo mbe kû kpolo tí có mì Mòze kpónó kuu tí ? À má énò, yo kû paa ta bà zi ye tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Káa ndâ ꞌduù tí nò giì ꞌvìsì có ji Jézù máa, «À tí lo a mâ! A ꞌdi ká kû jè ta bà zi wò?» ");
INSERT INTO ndz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye bàkà káa i gbaànjé, káa nje yo ꞌdáá gî kpónó ꞌdèè gítí  gî. ");
INSERT INTO ndz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mòze dígísèé ꞌdè có ji yo máa, yo ya ta ndâ ꞌviì-ꞌdakò gí gbí gàzâ ta sili vô-nje taꞌô bìndi bà jò ndú. (Gbí có tí nò me énó máa, a Mòze dígísèé ká ꞌbìtà bà ya gí gbí gàzâ ji ndâ Jùdéyà nò lá; gàzâ a cèe ká i mbe ꞌbìtà tí gbí o mì ndâ ká gù yo, tí ndâ mbe ꞌbìtà bà jò ŋa yo tí ndâ Jùdéyà mí muu to tí nô.) Yo kpónó kû waa ndâ ꞌviì mì yo ta ṛi bà wotí gbí tàkìì mì yo tí ndâ Jùdéyà náa sili tí nò vô-nje taꞌô náa Mòze ꞌdeke ji yo nò má tè ꞌvii ta ṛi bà wotí gbí tàkìì mì yo nò. Káa vò i tí  wálá, ");
INSERT INTO ndz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","tacó ŋìnó a sili tí nó náa Mòze ꞌdeke ji yo, tí sili bà waa ndâ ꞌviì gbí tàkìì mì yo nó ká nò. À má énò, tàkòcò yo kpónó kû kpolo gítí có bà ꞌvala kùùkpò ꞌduù mì ye ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà tacó yè? ");
INSERT INTO ndz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yo si bà zeke káa ꞌduù wàa yo ꞌví waa có mítí wó nò mí to. Yo waa có ta yúcó.» ");
INSERT INTO ndz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ndâ ꞌbí ꞌduù Jèrùzàlémè bà-i-nò giì ꞌbìtà bà ꞌvee ꞌvé máa, «À nó me ꞌdakò tí nó náa ndâ kpó ꞌduù mì ndâ Jùdéyà kû pà bà tí wó tacó bà zi yí nó ká nó lá? ");
INSERT INTO ndz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yo ŋò yí kuu nô, kû ꞌdè có kùṛo ndâ ꞌduù ꞌdáá gî ta gúku tí wó wálá! À ꞌví dù a yúcó máa, ndâ kpo ꞌduù ùnje gî máa, yí a Bìndi-Mbíṛì? ");
INSERT INTO ndz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ndú má ꞌdè énò, káa ndoo ꞌdáá gî ŋò to tí nó náa yí gì ꞌdo tí  nó ni gî nó! Káa ꞌbí ꞌduù wúnò bà ŋò to tí nó náa Bìndi-Mbíṛì bà gì ꞌdo tí  nó ni wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jézù mâ giì ꞌdi ndâ có tí nò náa ndâ ꞌduù tí nò kû ꞌdè gítí wó si yí kû nìbà i ji ndâ ꞌduù gbí ndùgù ꞌbá-Mbíṛì nò, yí giì ꞌvìsì có ji ndú ta kòcò wó ngéé gí yaà, máa, «A yúcó máa, yo ŋò ye ni gî. À delè a yúcó máa, yo ŋò bàndò bà jò ye ni gî. À kpêtí ká énò, ye gì me ꞌdo gbí ꞌdóó có mì ye lá. A ꞌduù ká tuu ye. ꞌDóó ꞌduù tí nò mbe tuu ye nò kuu tí , káa yo ŋò yí ni lá. ");
INSERT INTO ndz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Káa ye ŋò yí ni gî, tacó a ye ká gì ꞌdo mì wó. À delè a yí ká tuu ye.» ");
INSERT INTO ndz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","À gbí muu ndâ kpo ꞌduù mì ndâ Jùdéyà ta o tí nò a có bà zèè Jézù, káa gbèe ꞌduù gbí òkò tí ndú mbe gàà ꞌbì tí wó wálá, tacó o mì wó tè lá. ");
INSERT INTO ndz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ndâ ꞌduù ŋìnó mbe ùnje gítí Jézù gî nó ta o tí nò me mbè kuu gbí òkò tí ndâ mbè ꞌduù tí nò. Ndú bà-i-nò giì ꞌvee ꞌvé gbí òkò tí ndú máa, «Bìndi-Mbíṛì má gì wúnò, yí bà bàkà a ndâ ꞌbí ŋa kpo-kpò seṛè mbe ndii ndâ ŋìnó kpónó náa ꞌdakò tí nó kû bàkà nó gî?» ");
INSERT INTO ndz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ꞌdi ŋa ꞌvé tí nò náa ndâ mbe ùnje gítí Jézù kû ꞌvee gbí ngûcó nò kû giì ꞌvèè cee nje ndâ ꞌduù me a mbè, ndú giì toko có ta Kùṛo ndâ bu-Mbíṛì mì ndú, bìndi  ndú giì tuu ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ àsìkérì mbe kû kpolo tí ꞌbá-Mbíṛì gí bà zèè Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Káa Jézù giì ꞌdè có ji ndú máa, «Ye bà dù ta yo ká ta làmbu o, bìndi  ye bà giì dele ndi ye ya gí mì ꞌduù tí nó mbe tuu ye nô. ");
INSERT INTO ndz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yo bà giì pà bà tí ye, káa yo bà ꞌde ye wálá. Tacó wotí bà yee tí bàndò tí nó náa ye kû ya gítí  nó tí yo wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ndâ kpo ꞌduù mì ndâ Jùdéyà mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú máa, «Yí tà kû ya gí kòtí ꞌdi, wàa bà ꞌde ta yí ꞌví kpò tí  ta ndoo? Yí kû ya a i gí tàkò ndâ ꞌbí Jùdéyà ŋìnó mbe ꞌvaaka ta ndi ꞌbá mì ndâ Ìgìrígì nó, tacó bà nìbà i ji ndú? ");
INSERT INTO ndz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Gbí ŋa có mì wó náa yí ꞌdè énó máa, ‹Yo bà giì pà bà tí ye, káa yo bà ꞌde ye wálá, tacó wotí bà yee tí bàndò tí nó náa ye kû giì ya gítí  nó tí yo wálá› nó máa yè?» ");
INSERT INTO ndz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ta ndòngbú sili, tí kpóló-kpolo ṛi mì o bà tò ndùúṛù gbí tàkìì mì ndâ Jùdéyà, Jézù giì ṛò tíyò á kùṛo ndâ ꞌduù ꞌdáá gî, bìndi  yí giì kò-kò ji ndú, máa, «ꞌDuù ŋìnó ta go ngo tí wó nó, si yí ꞌví gì gí mì ye, wàa yí ꞌví njù ngo. ");
INSERT INTO ndz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ꞌDuù má ùnje gítí ye gî, ngo mbe ꞌvala ꞌduù bà ꞌva ꞌdo gbí njembí wó dúú bà ya tí , a go có tí nó náa a kuu gbí wáràgà mì Mbíṛì nô.» ");
INSERT INTO ndz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jézù lòkòꞌbò có tí nò a i gítí Bèṛi-mì-Mbíṛì tí nó bà giì gì gí muu ndâ mbe ùnje gítí có mì wó nô. Bèṛi-mì-Mbíṛì ta o tí nò gì gí muu ndú kálásê, tacó Mbíṛì ta o tí nò te Jézù ya tí  gí pí jàlàmbà á gbíṛì kálásê. ");
INSERT INTO ndz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ mbe ꞌdi ndâ có mì Jézù náa yí ꞌdè gbí ndâ sili tí nò náa yí bàkà mí Jèrùzàlémè nò giì ꞌdè có máa, «ꞌDakò tí nó dú káa mbe ꞌdòkò có mì Mbíṛì tí nó mì Mòze nô!» ");
INSERT INTO ndz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ndâ ꞌbí ꞌduù giì ꞌdè có máa, «Yí a Bìndi-Mbíṛì.» Bìndi  ndâ ꞌbí ꞌduù ŋìndi ndú giì ꞌvee a ꞌvé máa, «Bìndi-Mbíṛì bà gì ꞌdo Gàlìléyà ta ŋa kpokèjì ngàyi? ");
INSERT INTO ndz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","À wálá cu mí gbí wáràgà mì Mbíṛì énó máa, Bìndi-Mbíṛì bà dù a ꞌviì-gù mì Dàvídè tí nó tí gbolò gba mì ndoo tí ndâ Jùdéyà dígísèé nó? À delè giì cu mí gbí wáràgà mì Mbíṛì énó máa, àá bà jò yí a i mí gbí mòòkò bìndi Dàvídè á Bétèlèmè?» ");
INSERT INTO ndz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Có mì ndâ ꞌduù ta o tí nò giì me a fúú-fu-fù gítí Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ndâ ꞌbí ꞌduù giì dù ká to nò máa, à zèè yí gî. Káa gbèe mbe gàà ꞌbì tí wó giì dù lá. ");
INSERT INTO ndz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bà zèè Jézù giì dù káa kpò ndâ ꞌduù tí nó náa ndâ kpo ꞌduù mì ndâ Jùdéyà tuu ndú gí bà zèè yí nó gî. Ndú bà-i-nò giì dele ndi ndú ya gí mì ndâ mbe tuu ndú, si yí mí to. Ndâ kpo ꞌduù tí nò mbe tuu ndú nò mâ giì ꞌvee ndú máa, «Yo gì ta yí lá tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ndâ àsìkérì tí nò giì ꞌvìsì có ji ndâ kpo ꞌduù tí nò máa, «ꞌBí ꞌduù jé mbe ꞌdè có di tàkò ꞌdakò tí nò wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ndâ kpo ꞌduù mì ndâ Jùdéyà bà-i-nò giì ꞌvee ndâ tú mì ndú nò ta sé có máa, «Yí ŋònòkò muu yo delè gî? ");
INSERT INTO ndz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yo nì ṛè ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ze tí ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà ta ndâ kpo ꞌduù jé mbe ùnje gítí ndâ có mì wó ji ze, wàa ze ꞌví ꞌdi ta tù ze gi! ");
INSERT INTO ndz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ndâ mbè ꞌduù tí nò ꞌdi gbí ꞌbí i gbaànjé ꞌdo tí tàkìì mì ndoo tí ndâ Jùdéyà lá. Káa sè ŋìnò a ŋìndi ndú ta Mbíṛì!» ");
INSERT INTO ndz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Káa, ꞌbí ꞌdakò gbí òkò tí ndâ kpo ꞌduù mì ndâ Jùdéyà ta ṛè wó a Nìkòdémò, tí ꞌduù mbe ya gí bà ꞌdè nje ta Jézù á tàbèngìì sàà kùṛo gî, giì ꞌdè có ji sè ndâ ka wó kpo ꞌduù máa, ");
INSERT INTO ndz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«À gbí tàkìì mì ndoo tí ndâ Jùdéyà waa có mítí ꞌduù si có mì wó mí gbí yì wó lá. À mâ énò, ndoo kùtàá bà ꞌdi a kòcò wó má kózò gi.» ");
INSERT INTO ndz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ndâ ka Nìkòdémò tí ndâ kpo ꞌduù mâ giì ꞌdi có tí nò náa yí ꞌdè nó, ndú giì ꞌvee yí máa, «Wò delè gì ꞌdo Gàlìléyà? Má énò, ya gí bà pà gbí wáràgà gítí tàkìì mì ndoo tí ndâ Jùdéyà, bìndi  wò bà ꞌde énó máa, ꞌbí mbe ꞌdòkò có mì Mbíṛì jé mbe gì ꞌdo Gàlìléyà nò wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ndâ ꞌduù bà-i-nò giì ꞌvaaka ꞌdo bàndò tí nò ya gí ꞌbá mì ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jézù giì taꞌva ŋìndi wó ya a i gí pí Gú Mbâ. ");
INSERT INTO ndz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bìndi  yí giì gboꞌo ta ꞌbí yé ꞌdo kà ya gí gbí ndùgù ꞌbá-Mbíṛì. Ndâ ꞌduù mâ giì kili me mbè gî, yí giì ki tí wó to, bìndi  yí giì nìbà i ji ndú. ");
INSERT INTO ndz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mâ giì zekeꞌo, ndâ ꞌbí mbe ꞌdi gbí-o, ta ndâ ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà, giì yee ta niì mì ꞌbí ꞌdakò náa à zèè yí ta ꞌdakò-ngbà gî. Ndú giì ṛò niì tí nò mí kùṛo ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bìndi  ndú giì ꞌvee Jézù máa, «Mbe nìbà i, à zèè niì tí nó kpátá-kpàtà ta ꞌdakò. ");
INSERT INTO ndz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Káa Mòze ꞌdè có ji ndoo gbí tàkìì mì ndoo énó máa, ndoo ꞌví zi niì mbe bàkà ŋa i tí nò kpónó náa niì tí nò bàkà nó ta bà ꞌvaka yí ta díí. Nògí, có mì lo ŋìndi lo máa yè?» ");
INSERT INTO ndz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ndâ ꞌduù tí nò ꞌvee ŋa ꞌvé tí nò ká tacó bà pà nje Jézù, máa nje wó má yaaka kpéṛéꞌvè gî, wàa ndâ yì ꞌví ꞌde ta kpokèjì gítí wó. Káa Jézù giì biya bà ꞌvìsì có ji ndú gí tàkò ꞌvé tiṛì mì ndú nò gî. Yí giì mò káa muu wó gí to, bìndi  yí giì ꞌbìtà bà ka i mítí to ta sìlì ꞌbì wó. ");
INSERT INTO ndz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Káa ndâ ꞌduù tí nò giì aanga muu ndú ká mítí gbèe ꞌvé mì ndú nò. Go bà ꞌvìsì có ji ndú mâ giì gì gítí Jézù gî, yí giì te muu wó gí yaà, bìndi  yí giì ꞌvìsì có ji ndú máa, «ꞌBí ꞌduù gbí òkò tí yo jé mbe bàkà vò i lá má kuu tí , si yí ꞌví co gí kùṛo, wàa yí ꞌví ꞌva kpédélé díí mítí niì tí nò.» ");
INSERT INTO ndz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jézù ꞌdè káa có tí nò ji ndú gî, yí kákáꞌi giì mò muu wó gí to, kû cu i mítí to. ");
INSERT INTO ndz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ndâ ꞌduù tí nò mbe gì ta niì tí nò gí kùṛo Jézù nò mâ giì ꞌdi có tí nò náa Jézù ꞌdè ji ndú nò, ndú giì ꞌbìtà bà ꞌvaaka ꞌdo bà-i-nò gbaànjé-gbaànjé, kpòò yee tí o tí nó náa á káa niì tí nó náa ndú gì ta yí gí gbí ngbàngà kùṛo Jézù nó ká giì dù ta kpéétí wó kùṛo Jézù. A ndâ kpo ꞌduù ká co gí sè ꞌdáá kùṛo má kózò gî, bìndi  ndâ ꞌviì giì co gí tàkò ndú. ");
INSERT INTO ndz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jézù mâ giì te muu wó gí yaà, yí giì ŋò káa niì tí nò kû ṛò tíyò ta kpéétí wó. Bìndi  yí giì ꞌvee niì tí nò máa, «Ndâ mbe kpì ngbàngà tí lo káa ya gí kòtí ꞌdi, niì? ꞌBí ꞌduù gbí òkò tí ndú mbe waa có mítí lo wálá?» ");
INSERT INTO ndz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Káa niì tí nò giì ꞌvìsì có ji Jézù máa, «Gbèe ꞌduù gbí òkò tí ndú mbe waa có mítí ye wálá, kpo ꞌduù.» Káa Jézù giì ꞌvìsì có ji niì tí nò máa, «À nìkì ma. À má énò, ye delè bà waa có mítí lo wálá. Nògí, ya gî, wàa wò ꞌví bàkà vò i kákáꞌi lá.» ");
INSERT INTO ndz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ta o tí nò Jézù giì ꞌdè ꞌbí có ji ndâ ꞌduù kákáꞌi máa, «Ye a ngbaꞌo mì ndâ ꞌduù. ꞌDuù mbe kû ṛu ndi ye bà nò gbí ꞌdíꞌdiꞌo ngé gî wálá. Yí bà dù gbí ngbaꞌo ŋìnó mbe ꞌvala yí nô.» ");
INSERT INTO ndz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ꞌdi có tí nò náa Jézù ꞌdè nò, ndú giì ꞌvìsì có ji yí máa, «À káa wò ká kû wu gbí tí lo ta kpéétí lo. À má énò, có mì lo nò bà dù me yúcó lá!» ");
INSERT INTO ndz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo ꞌdè a yúcó máa, ye kû wu gbí tí ye ta kpéétí ye, káa kpêtí ká énò, ye kû ꞌdè a yúcó, tacó ye ŋò bàndò tí nó náa ye gì ꞌdo tí  nó ni gî. Ye delè giì ŋò bàndò tí nó náa ye kû ya gítí  nó ni gî. Káa yo ŋò bàndò tí nó náa ye gì ꞌdo tí  nó ni lá. Yo delè ŋò bàndò tí nó náa ye kû ya gítí  nó ni lá. ");
INSERT INTO ndz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yo kû waa có me ta yúcó lá. Káa ye me mbe waa có mítí ꞌduù gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Káa, ye má waa có mítí ꞌduù, ye bà waa có ta yúcó. Tacó ye kû waa có me ta kpéétí ye lá. Ze kû waa có a i ta Bu ye tí nó tí mbe tuu ye nô. ");
INSERT INTO ndz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","À cu mí gbí wáràgà gítí tàkìì mì ndoo tí ndâ Jùdéyà énó máa, ‹Ndâ ꞌduù só má ùnje gítí gbèe có gî, gbí  énó máa, có tí nò a yúcó.› ");
INSERT INTO ndz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ye kû ꞌdè có gítí miṛi ye, káa Bu ye tí nó tí mbe tuu ye nó kuu tàkò ye.» ");
INSERT INTO ndz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Káa ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà giì ꞌvee Jézù máa, «Bu lo tí nò kòtí ꞌdi?» Jézù bà-i-nò giì ꞌvìsì có ji ndú máa, «Yo ŋò ye ni lá. À má énò, yo delè bà ŋò Bu ye ni wálá. Yo kùtàá má ŋò ye ni gî, yo bà ŋò Bu ye delè ni gî.» ");
INSERT INTO ndz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jézù ꞌdè ndâ có tí nò ji ndâ ꞌduù mí bàndò bà kili i-Mbíṛì. Káa gbèe ꞌduù mbe zèè yí ta o tí nò wálá, tacó o mì wó tè kálásê. ");
INSERT INTO ndz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jézù giì ꞌdè ꞌbí có ji ndâ ꞌduù tí nò máa, «Ye bà giì ya gî. Yo bà giì pà bà tí ye si bà  volo ji yo gî, káa yo bà ꞌde ye wálá, tacó wotí bà ya gítí bàndò tí nò náa ye kû giì ya gítí  nò tí yo wálá. À má énò, yo bà cì mí gbí ndâ vò i mì yo.» ");
INSERT INTO ndz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ndâ kpo ꞌduù mì ndâ Jùdéyà giì ꞌbìtà bà koṛo gbí có tí nó náa Jézù ꞌdè énó máa, ndú bà ꞌde wotí bà ya gítí bàndò tí nó náa yì kû ya gítí  wálá nò, máa, «Yí bà zi tí wó zí-zi? À ꞌví dù nò a gbí có tí nò náa yí kû ꞌdè énó máa, ndoo bà ꞌde wotí bà ya gítí bàndò tí nó náa yì kû giì ya gítí  nó wálá nò ká nò?» ");
INSERT INTO ndz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Káa Jézù giì ꞌvìsì có ji ndú máa, «ꞌBè gbí òkò tí ndoo ta ndoo a ŋìnô: ꞌbá mì yo a i muu to tí nô, káa ꞌbá mì ye a i gbíṛì. Ṛèngbó yo a i muu to tí nô, káa ṛèngbó ye me i muu to tí nô lá. ");
INSERT INTO ndz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yo bà cì mí gbí ndâ vò i mì yo. Yo má ùnje énó máa, Ye a Ye tí nó tí Ye nó, lá, yo bà cì mí gbí ndâ vò i mì yo.» ");
INSERT INTO ndz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Káa ndâ kpo ꞌduù mì ndâ Jùdéyà giì ꞌvee Jézù máa, «Wò a Wò tí ꞌdi?» Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye ꞌdè ji yo sàà kùṛo gî. ");
INSERT INTO ndz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndâ có gbí muu ye tacó bà ꞌdè ji yo go mbílì gbí cìkaà. Ndâ i ŋìnó náa ye biya ꞌdo mì yo gî nó delè me ndâ i bà ꞌdeke cee lá. Káa ꞌduù tí nó tí mbe tuu ye nó a ꞌduù ŋìnó tí mbe ꞌdè yúcó; tacó énò, ye kû ꞌdè ji yo muu to tí nó káa ndâ có ŋìnó náa ye ꞌdi ꞌdo mì wó nô.» ");
INSERT INTO ndz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bà ꞌdi gbí  énó máa Jézù kû ꞌdè có ji ndâ yì a i gítí Mbíṛì nò giì kpò ndâ ꞌduù tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tacó énò, Jézù giì ꞌdè có ji ndú máa, «Yo kpónó ŋò ye ni lá. Yo má te ꞌViì-mì-ꞌDakò gí yaà kózò gî, yo bà giì ŋò ni énó máa, Ye a Yí. À delè nò bà giì dù a o bà ŋò  mì yo ni énó máa, ye kû bàkà i me ta muu ye lá; ye kû nì káa bà có ŋìnó náa ye ꞌdi ꞌdo mì Bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Delè ꞌduù tí nó mbe tuu ye nó kuu ta ye; yí si ye ta kpéétí ye lá, tacó ye ta o ꞌdáá gî kû bàkà káa i ŋìnó mbe kû peteke tàkòcò wó nô.» ");
INSERT INTO ndz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ndâ ꞌduù me mbè ꞌdo gbí òkò tí ndâ mbe ꞌdi có mì Jézù nò giì ùnje gítí ndâ có mì wó gî. ");
INSERT INTO ndz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jézù bà-i-nò giì ꞌdè có ji ndâ Jùdéyà ŋìnó mbe ùnje gítí có mì wó gî nó máa, «Yo kpolo tí ndâ có mì ye kácá-kácá, tacó wàa yo ꞌví dù tí  tí ndâ cèe mbe tala có mì ye dúú bà ya tí . ");
INSERT INTO ndz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yo bà dù tí ndâ mbe ŋò yúcó ni gî. Bìndi  yúcó bà giì njaanga wú ꞌdo tí miṛi yo gî.» ");
INSERT INTO ndz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Káa ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ Jùdéyà tí nò giì waa gbí có mì Jézù nò ta bà ꞌvee yí máa, «Ze a ndâ ꞌviì-gù Àbìráámò. Ze jé dù tí ndâ bòò mì ndâ ꞌbí ꞌduù sàà kùṛo lá. À má énò, gbí có mì lo náa wò ꞌdè énó máa, ‹Àá bà njaanga wú ꞌdo tí miṛi yo› nò máa yè?» ");
INSERT INTO ndz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kû ꞌdè ji yo a cèe yúcó máa, ꞌduù mbe bàkà vò i gî, gbí  énó máa, vò i ga wú mítí miṛi wó gî. ");
INSERT INTO ndz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Káa bòò dù tí ꞌbá ngbé lá. A ꞌviì-ꞌbá ká kû dù tí ꞌbá ngbé. ");
INSERT INTO ndz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Káa ꞌviì mì mbe ꞌbá má njaanga wú mì vò i ꞌdo tí miṛi lo gî, wò bà dù tí bòò mí vò i kákáꞌi wálá. ");
INSERT INTO ndz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ye ŋò ni gî máa, yo a ndâ ꞌviì-gù mì Àbìráámò, káa ta ndâ ŋa ŋìnò ꞌdáá gî, go bà zi ye kuu tí yo, tacó ndâ có tí nó ꞌdáá náa ye kû ꞌdè nó ya gí gbí muu yo gbaànjé lá. ");
INSERT INTO ndz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","À má gítí bà miṛi ye, ye kû ꞌdè có ká gítí ndâ i ŋìnó náa ye ŋò ꞌdo mì Bu ye nô. Káa yo, yo kû bàkà káa ndâ i ŋìnó náa yo ŋò ꞌdo mì bu yo nó delè.» ");
INSERT INTO ndz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ndâ ꞌduù tí nò bà-i-nò giì ꞌvìsì có ji Jézù máa, «Bu ze a Àbìráámò.» Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo kû bàkà tí yo máa, yo a ndâ ꞌviì mì Àbìráámò, káa, yo kùtàá dú má káa ndâ ꞌviì mì Àbìráámò go có tí nò gbí nje yo nò, yo bà mèlè ndi Àbìráámò gî. ");
INSERT INTO ndz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","41","Káa, yo kpónó kû pà kpokèjì tacó bà zi ye tí mbe kû ꞌdè yúcó tí nó náa ye ꞌdi ꞌdo mì Mbíṛì nó ji yo. Yo je nò a ŋa i bìndi ꞌbí ŋa bu yo, tacó Àbìráámò dígísèé me mbe me ŋa ndâ vò i tí nò kpónó náa yo kû me nò lá.» Ndâ ꞌduù tí nò giì ꞌvìsì có ji Jézù máa, «Ze me ndâ ꞌviì-ngbà lá. Bu ze ká gbaànjé, tí Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Káa Jézù giì ꞌvìsì có ji ndú máa, «Mbíṛì kùtàá má dú káa bu yo, yo bà zè ye nìkì gî, tacó ye gì ꞌdo mì Mbíṛì. Ye gì dú ꞌdo mì Mbíṛì. Ŋìnó a ye ká nô. Ye gì me ta muu ye lá. À tuu ye túú-tuu. A Mbíṛì ká tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yo ꞌdi gbí có tí nó náa ye ꞌdè nó lá tacó yè? Yo ꞌdi gbí có tí nò lá, tacó kòcò ye gbí tù yo go mòngò gbí tù bô. ");
INSERT INTO ndz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Bu yo a Gba-vò-i. Tacó énò, à nìkì tí yo a bà bàkà i ŋìnó ta gó  tí bu yo nô. Nèté mì wó a bà zi ku ꞌdo sàà. Nèté mì wó jé táánò ta yúcó wálá. Tacó yúcó mì wó jé wálá. Yí má kû ꞌdè ꞌvéṛè, yí kû bàkà nò a i gbí kû wó, tacó yí a mbe ꞌvéṛè, tí bu ꞌvéṛè. ");
INSERT INTO ndz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Káa à má gítí ye, ye a mbe ꞌdè yúcó. Ŋìnò a ndeṛè có tí nò náa yo ù ta nje gítí ye lá nò ká nò. ");
INSERT INTO ndz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","A ꞌdi ꞌdo gbí òkò tí yo ká bà tù ꞌbì wó gí yaà, máa, yì jé zèè ye ta vò i gî? Káa ye má kû ꞌdè a yúcó, yo ùnje gítí ye lá tacó yè? ");
INSERT INTO ndz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ꞌDuù má a ꞌviì mì Mbíṛì, yí kû ꞌdi káa có mì Mbíṛì, káa yo má biya bà ꞌdi có mì Mbíṛì gî, à ká dú, tacó yo me ndâ ꞌviì mì Mbíṛì lá.» ");
INSERT INTO ndz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ndâ Jùdéyà bà-i-nò giì ꞌdè có ji Jézù máa, «Cè bà i mì lo go cè bà i mì ndâ ꞌduù Sàmárìyà nô! A mâ ká gbí muu lo. A kponje ká nje lo gítí có tí nò náa ze ꞌdè nò?» ");
INSERT INTO ndz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye me mbe mâ lá, ye kû tègàṛà a Bu ye. Káa à tí yo a go bà volo ṛè ye. ");
INSERT INTO ndz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ye kû pà me bà wu gbí ye lá. Có gítí bà wu gbí ye nò a nèté mì ꞌbí ꞌduù tí cèe mbe waa có. ");
INSERT INTO ndz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ye kû ꞌdè có ji yo ta yúcó máa, ꞌduù mbe kpolo tí ndâ có mì ye bà cì wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ndâ Jùdéyà gbí ŋìnò giì ꞌvìsì có ji Jézù máa, «Ze kpónó ŋò ni ngbáṛángàꞌi gî máa, a gbí muu lo a i. Àbìráámò cì gî. Ku delè zi ndâ mbe ꞌdòkò có mì Mbíṛì léé gî. Káa àá giì dù nó a wò ká giì ꞌdè có máa, ꞌduù mbe ꞌdi có mì lo bà ꞌdi pó ku wálá. ");
INSERT INTO ndz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wò me gbolò ndii bu ze tí Àbìráámò mbe cì gî nó gî? Ndâ mbe ꞌdòkò có mì Mbíṛì delè ꞌdáá gî zò to gî. Wò kû bàkà tí lo tí ꞌdi kpónó?» ");
INSERT INTO ndz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kùtàá má kû wu a gbí tí ye ta kpéétí ye, gbí bà wu gbí tí ye bà dù wálá. Káa a Bu ye tí nó náa yo kû ꞌdè có máa, yí a Mbíṛì mì yo nó, ká kû wu gbí ye. ");
INSERT INTO ndz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yo ŋò yí ni lá, káa ye ŋò yí ni gî. Ye má ꞌdè có máa, ye ŋò yí ni lá, ye bà dù tí mbe ꞌvéṛè a go yo mbe kû ꞌdè có máa, yo ŋò yí ni gî, káa yo ŋò yí ni lá. Ye ŋò yí ni gî. Ye delè kû kpolo tí có mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bu yo Àbìráámò dígísèé kû dù ta líkíꞌo tí wó máa, yì bà ŋò o bà gì ye. Yí giì ŋò ye gî, bìndi  tàkòcò wó giì peteke gî.» ");
INSERT INTO ndz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Káa ndâ ꞌduù tí nò giì ꞌvìsì có ji Jézù máa, «Ndoò tí lo yee gbí ziꞌduù-só-nje muuꞌbì lá. Wò delè jé ŋò Àbìráámò lá.» ");
INSERT INTO ndz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kû ꞌdè ji yo a cèe yúcó máa, kùṛo o bà jò Àbìráámò táánò, ye kuu tí .» ");
INSERT INTO ndz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ndâ ꞌduù tí nò mâ giì ꞌdi ŋa có tí nò náa Jézù ꞌdè ji ndú nò, ndú giì tuṛu díí tacó bà ꞌvaka ta yí. Káa Jézù giì ŋònòkò tí wó ꞌdo tí ndú mí gbí òkò tí ndâ ꞌduù, yee tí o tí nó náa yí giì ndo ꞌdo gbí ndùgù ꞌbá-Mbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Si Jézù kû giì ndii ta nó, yí giì ŋò ꞌbí ꞌdakò náa à jò yí ta sú ṛo ꞌdo gbí yì. ");
INSERT INTO ndz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ndâ mbe tala có mì Jézù bà-i-nò giì ꞌvee yí máa, «Ndeṛè bà jò ꞌdakò tí nò ta sú ṛo kpónó ꞌví dù ꞌdo tí ꞌdi, Mbe nìbà i? À ꞌví dù ꞌdo gbí ꞌdóó vò i mì wó wèè, ꞌdo gbí vò i mì ndâ bu wó ta nawu wó?» ");
INSERT INTO ndz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Káa Jézù giì ꞌvìsì có ji ndâ mbe tala có mì wó máa, «À me ꞌdo gbí có mì wó lá. À delè giì dù me ꞌdo gbí có mì ndâ mbe jò yí lá. À jò yí énò tacó wàa ndâ ꞌduù ꞌví ŋò ta Mbíṛì ni tí mbe wotí. ");
INSERT INTO ndz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ndoo bà bàkà ndâ nèté mì ꞌduù tí nó mbe tuu ye nò ká kpónó si o bèè lá nô, tacó ꞌdíꞌdiꞌo kèjì, káa ꞌduù mbe bàkà nèté gbaànjé gbí ꞌdíꞌdiꞌo wálá. ");
INSERT INTO ndz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ye a ngbaꞌo mì ndâ ꞌduù ta o tí nó náa ye kpónó kuu muu to tí nó nô.» ");
INSERT INTO ndz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bìndi bà ꞌdè có tí nò mì Jézù ji ndâ mbe tala có mì wó, Jézù giì cù ngo cù mítí to, bìndi  yí giì meṛeke ta tú, bìndi  yí giì toṛo mítí ndâ ṛo mbe sú ṛo tí nò sósòꞌô gî. ");
INSERT INTO ndz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bìndi  yí giì ꞌdè có ji mbe sú ṛo tí nò máa, «Ya gí bà caka gbí ṛo lo ta ngo gbí Dùúgú Sìlòwámù.» (Gbí ṛè tí nò tí Sìlòwámù nò máa, à tuu yí túú-tuu.) Mbe sú ṛo tí nò mâ giì bàkà go có tí nò náa Jézù ꞌdè ji yí nò, yí giì dele ꞌdo bàndò bà caka gbí ṛo wó tí cèe ꞌduù ta ndâ ṛo wó sósòꞌô kû zekeꞌo ngbáṛángàꞌi. ");
INSERT INTO ndz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ndâ ꞌduù ŋìnó ta ndâ ꞌbá mì ndú dê-dê ta ndú nó, ta ndâ ꞌbí ꞌduù ŋìnó mbe ŋò yí sàà kû yù i gbí sú ṛo gî nó mâ giì ŋò yí, ndú giì ꞌbìtà bà ꞌvee ꞌvé, máa, «À nó go ꞌdakò tí nó táánò tí mbe sú ṛo mbe kû yù i á to kàzô nó le! Káa a yè ká giì njaanga ṛo wó ŋìnó?» ");
INSERT INTO ndz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ndú bà-i-nò giì ꞌdeeke kponje á gbí òkò tí ndú á ta kpéétí ndú gî. Ndâ ꞌbí ꞌduù máa, «A yí!» Ndâ ꞌbí ka ndú máa, «À me yí lá! A ꞌbí ꞌduù mbe je cè kózò tí wó.» Káa ꞌdakò tí nò giì ꞌvìsì có ji ndú máa, «Ŋìnó a ye tí ꞌdakò tí nò.» ");
INSERT INTO ndz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ndâ ꞌduù tí nò bà-i-nò giì ꞌvee yí máa, «A yè ká njaanga ṛo lo?» ");
INSERT INTO ndz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Káa ꞌdakò tí nò giì ꞌvìsì có ji ndú máa, «A ꞌbí ꞌdakò ta ṛè wó a Jézù ká ŋònòkò tú, bìndi  yí giì toṛo mítí ndâ ṛo ye sósòꞌô gî. Bìndi  yí giì ꞌdè có ji ye máa, ye ya gí bà caka gbí ṛo ye ta ngo tí Dùúgú Sìlòwámù. Ye mâ giì bàkà go có mì wó nò, ndâ ṛo ye giì njaanga tí gî.» ");
INSERT INTO ndz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ndâ ꞌduù tí nò giì ꞌvee ꞌdakò tí nó náa Jézù njaanga ṛo wó nó máa, «ꞌDakò tí nò mbe njaanga ṛo lo nò kpónó ngò?» Káa ꞌdakò tí nò giì ꞌvìsì có ji ndú máa, «Ye ŋò bà tí wó lá.» ");
INSERT INTO ndz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ndâ ꞌduù giì je ꞌdakò tí nó náa Jézù njaanga ṛo wó nó ya tí  gí kùṛo ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ṛi tí nò náa Jézù meṛeke ta tú, bìndi  yí giì njaanga ta ṛo ꞌdakò tí nò nò a ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tacó énò, ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà giì ꞌvee ndi gbí nje ꞌdakò tí nò kákáꞌi a gítí ŋa kpokèjì bà njaanga ṛo wó mì Jézù. Káa ꞌdakò tí nò giì ꞌvìsì có ji ndú máa, «Yí toṛo káa tú mítí ndâ ṛo ye sósòꞌô gî. Ye mâ giì caka tú tí nò, ndâ ṛo ye giì njaanga tí gî.» ");
INSERT INTO ndz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Có tí nò náa ꞌdakò tí nò ꞌdè ji ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà nò giì ŋònòkò muu ndú gî. Tacó énò, ndâ ꞌbí ꞌduù gbí òkò tí ndú giì ꞌvìsì có ji yí máa, «ꞌDakò tí nò mbe bàkà ŋa i tí nò bà dù me ꞌduù ŋìnó mbe gì ꞌdo mì Mbíṛì nó lá, tacó yí kû gbètèkè ṛi bà wotí gbí tàkìì mì ndoo tí ndâ Jùdéyà.» Káa ndâ ꞌbí ꞌduù gbí òkò tí ndú giì loko kû ꞌvee ndâ ꞌbí ka ndú ŋìnó mbe ꞌdè có énó máa ꞌduù tí nò a mbe bàkà vò i nó, máa, «Mbe bàkà vò i bà bàkà ndâ kpo-kpò seṛè go ŋa ŋìnó kpónó nó ta ŋa kpokèjì ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tacó énò, ndú giì tè ndi tí ndú giì ꞌvee yí kákáꞌi máa, «Yí ꞌvala wò ꞌdo gbí sú ṛo gî. À má énò, ꞌdóó có mì lo gítí wó máa yè?» Káa ꞌdakò tí nò giì ꞌvìsì có ji ndú máa, «Ye koṛo có máa, ꞌdakò tí nò a mbe ꞌdòkò có mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ndâ Jùdéyà bà-i-nò giì me a kpììkì-kpììkì gítí bà ùnje máa, ꞌdakò tí nò náa Jézù njaanga ndâ ṛo wó nò táánò dú káa yúcó mbe sú ṛo. Tacó énò, ndú giì tuu tú gí tàkò ndâ bu wó ta nawu wó. ");
INSERT INTO ndz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ndâ bu ꞌdakò tí nò ta nawu wó mâ giì gì gî, ndâ kpo ꞌduù mì ndâ Jùdéyà giì ꞌvee ndú máa, «À dú nó káa ꞌviì mì yo ká nó? Yo máa, àá táánò jò yí ta sú ṛo ꞌdo gbí yì, káa yí kpónó kû zekeꞌo ée?» ");
INSERT INTO ndz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Káa ndâ bu ꞌdakò tí nò giì ꞌvìsì có ji ndâ kpo ꞌduù mì ndâ Jùdéyà máa, «Ze ŋò ni gî, máa, yí a ꞌviì mì ze. Ze delè giì ŋò ni gî, máa, yí táánò tè ta sú ṛo ꞌdo gbí yì nawu wó. ");
INSERT INTO ndz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Káa ze ŋò ŋa i tí nó mbe njaanga ṛo wó nó ni lá. Ze delè ŋò ꞌduù tí nó mbe je yeè ji yí nó ni ká lá. Nje wó kuu tí wó. Yí me dó ꞌviì lá. À má énò, yo tèꞌé tí wó, wàa yo ꞌví ꞌvee yí, wàa yí ꞌví tùbà dúú kpokèjì ŋa i tí nó mbe ꞌde yí nó ji yo.» ");
INSERT INTO ndz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ndâ bu ꞌdakò tí nò náa Jézù njaanga ṛo wó nò ꞌdè ŋa có tí nò ji ndâ kpo ꞌduù mì ndâ Jùdéyà tacó à tí ndú a gúku. Tacó ndú ŋò ni gî máa, ndâ kpo ꞌduù mì ndâ Jùdéyà eṛe nje có mì ndú sàà gî máa, ꞌduù má ùnje énó máa, Jézù a Bìndi-Mbíṛì gî, ꞌduù tí nò ꞌví ꞌdò kò wó mí bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì kákáꞌi lá. ");
INSERT INTO ndz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ŋìnò a gbí ndeṛè có tí nò náa ndâ bu ꞌdakò tí nò giì tooko ta có tí nò ꞌdo muu ndú gí muu wó máa, «Yí me dó ꞌviì lá. Yo ꞌvee yí,» nò ká nò. ");
INSERT INTO ndz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ndâ kpo ꞌduù mì ndâ Jùdéyà mâ giì ꞌdi kòcò ndâ bu ꞌdakò tí nó náa Jézù ꞌvala yí ꞌdo gbí sú ṛo nó cee gî, ndú giì tuu tú gí tàkò ꞌdakò tí nò kákáꞌi. Yí mâ giì gì gî, ndú giì ꞌdè có ji yí máa, «ꞌDè yúcó mì lo kùṛo Mbíṛì. Tacó à má gítí ze, ze ŋò ni gî máa, ꞌdakò tí nò náa wò ꞌdè có máa, a yí ká njaanga ṛo lo nò, a mbe bèè ṛo Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Káa ꞌdakò tí nò giì ꞌvìsì có ji ndú máa, «Yí má a mbe bèè ṛo Mbíṛì, ye ŋò bà ŋìnò lá. I ŋìnó náa ye ŋò ni gî cuki nó káa ŋìnó máa, ye táánò a mbe sú ṛo, káa ye kpónó kû zekeꞌo.» ");
INSERT INTO ndz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ndâ kpo ꞌduù mì ndâ Jùdéyà giì ꞌvee yí máa, «Yí táánò bàkà mítí ndâ ṛo lo nò a ŋa yeè yè, náa ndú giì njaanga ta tí nò?» ");
INSERT INTO ndz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Káa ꞌdakò tí nò giì ꞌvìsì có ji ndâ kpo ꞌduù mì ndâ Jùdéyà máa, «Ye ꞌdè có tí nò ji yo á kùtàá sàà gî, káa yo sè tù yo lá. Nògí, yo kpónó kû ꞌvee ndi gbí nje ye máa, ye ꞌví ꞌdè ji yo a ŋa có yè kákáꞌi? À tí yo a go bà dù tí ndâ mbe tala có mì wó delè?» ");
INSERT INTO ndz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ndâ kpo ꞌduù mì ndâ Jùdéyà bà-i-nò giì ꞌbìtà bà no nje ndú gítí ꞌdakò tí nò ta ŋa có tí nò náa yí ꞌdè ji ndú nò. Bìndi  ndú giì ꞌvìsì có ji yí máa, «Go bà dù tí ꞌduù mì wó má tí lo, mbe tii wò wálá. Káa à má gítí ze, ze a ndâ ꞌduù mì Mòze. ");
INSERT INTO ndz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ze ŋò ni gî máa, Mbíṛì dígísèé ꞌdè có a i ji Mòze. Káa à má gítí ꞌdakò tí nò á mì lo nò, ze ŋò bàndò tí nó náa yí gì ꞌdo tí  nó ni lá.» ");
INSERT INTO ndz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Káa ꞌdakò tí nò giì ꞌvìsì có ji ndâ kpo ꞌduù mì ndâ Jùdéyà máa, «A có seṛè! Yí njaanga ṛo ye gî, káa yo ŋò bàndò tí nó náa yí gì ꞌdo tí  nó ni lá! ");
INSERT INTO ndz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ndoo ŋò ni gî máa, Mbíṛì sè tù wó gítí ndâ có mì ndâ mbe bàkà vò i lá, yí kû sè tù wó a i gítí ndâ có mì ndâ ꞌduù ŋìnó mbe kû bàkà i ji yí, tí ndâ mbe bàkà go có mì wó tí Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ꞌDo tí bà ꞌbìtà bà suu to tí nó, ꞌbí ꞌduù mbe ꞌdi có jé énó máa, ꞌbí ꞌduù njaanga ṛo ꞌbí ꞌduù ŋìnó náa à jò yí ta sú ṛo ꞌdo gbí yì gî nò wálá. ");
INSERT INTO ndz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Káa ꞌdakò tí nó mbe njaanga ṛo ye nò má gì me ꞌdo mì Mbíṛì lá, yí kùtàá bà ꞌde wotí bà bàkà i gbaànjé wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ndâ kpo ꞌduù mì ndâ Jùdéyà mâ giì ꞌdi có tí nò náa ꞌdakò tí nò ꞌdè ji ndú nò, ndú giì mòkò yí ꞌdo kùṛo ndú, ta bà ŋonoko yí máa, «À jò wò cûmúú mí gbí vò i, káa wò kû giì bàkà tí lo tí mbe nìbà có mì Mbíṛì ji ze?» ");
INSERT INTO ndz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jézù mâ giì ꞌde ꞌdakò tí nò náa yí njaanga ṛo wó nò bìndi bà ꞌdi có bà mòkò yí mì ndâ kpo ꞌduù mì ndâ Jùdéyà ꞌdo kùṛo ndú, Jézù giì ꞌvee yí máa, «Wò ùnje gítí ꞌViì-mì-ꞌDakò ta njembí lo gbaànjé gî?» ");
INSERT INTO ndz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Káa ꞌdakò tí nò giì ꞌvee Jézù máa, «ꞌDuù tí nò ta ṛè wó a ꞌViì-mì-ꞌDakò nò a ꞌdi? Tùbà tí wó ji ye kùṛo, má kózò gi, ye ꞌví ù ta nje gítí wó, kpo ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jézù bà-i-nò giì ꞌvìsì có ji ꞌdakò tí nò máa, «Wò kû zeke ꞌduù tí nò ta ṛè wó a ꞌViì-mì-ꞌDakò nò ta ṛo lo. À delè kpónó a yí ká kû ꞌdè có ji wò nô.» ");
INSERT INTO ndz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ꞌDakò tí nò mâ giì ꞌdi có tí nò náa Jézù ꞌdè ji yí nò, yí giì ìṛì ta muungbó wó ya gí bà kaa to á kùṛo Jézù ta ꞌbì wó, bìndi  yí giì ꞌdè có ji Jézù máa, «Ye ùnje gî, Mbe tí ye.» ");
INSERT INTO ndz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Káa Jézù giì ꞌvìsì có ji ꞌdakò tí nò, náa yí njaanga ṛo wó nò, máa, «Ye gì gí muu to tí nó tacó wàa ndâ mbe sú ṛo ꞌví zekeꞌo, wàa ṛo ndâ mbe ṛo ꞌví yoo gî.» ");
INSERT INTO ndz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà ŋìnó mbe dù ꞌdê á ṛègbà tí Jézù ta o tí nò mâ giì ꞌdi có tí nò náa yí ꞌdè nò, ndú giì ꞌvee yí máa, «Ze delè ngbá káa ndâ mbe sú ṛo?» ");
INSERT INTO ndz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Káa Jézù giì ꞌvìsì có ji ndú máa, «Yo kùtàá má a ndâ mbe sú ṛo, vò i mì yo bà dù wálá. Káa yo kû bàkà tí yo tí ndâ mbe ṛo, à má énò, yo ṛò tíyò nje ndâ vò i mì yo.» ");
INSERT INTO ndz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jézù giì lòkòꞌbò có ji ndâ ꞌduù máa, «Mbe ꞌvìì ndùgù tacó bà ṛì gí tàꞌi mì ndâ i-kó-ko a mbe ngbà tí mbe kùmùkù i mì ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Káa, mbe ṛì gí tàꞌi co tí njekèjì ndùgù a cèe mbe kpolo tí ndâ i-kó-ko. ");
INSERT INTO ndz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mbe kpolo tí njekèjì ndùgù mì ndâ i-kó-ko kû njaanga njekèjì ji yí. Ndâ i-kó-ko delè ꞌdi kòcò wó ni gî. Yí kû tèꞌé tí ndâ ꞌdóó i-kó-ko mì wó ꞌdo gbí òkò tí ndâ ŋìndi ndâ ꞌbí ꞌduù ta ṛè ndú, tacó bà gbà ndú gí sè. ");
INSERT INTO ndz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yí má njaanga ndâ i-kó-ko ꞌdo gbí ndùgù gî, yí kû tè kùṛo ndú, bìndi  ndú kû ṛu ndi wó, tacó ndú ꞌdi kòcò wó ni gî. ");
INSERT INTO ndz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Káa ndâ i-kó-ko bà ꞌvaaka ꞌdo tí vò ꞌduù ŋìnó náa ndú ŋò yí ni lá nó gî. Ndú jé gítí bà ṛu ndi wó wálá, tacó ndú ŋò yí ni lá, ndú delè ꞌdi kòcò wó ni ká lá.» ");
INSERT INTO ndz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jézù lòkòꞌbò có tí nò ji ndâ ꞌduù, káa, ꞌbí ꞌduù gbaànjé mbe ꞌdi gbí  wálá. ");
INSERT INTO ndz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tacó énò, Jézù giì ꞌdè có ji ndú ngbáṛángàꞌi énó máa, «Ye kû ꞌdè có ji yo ta yúcó máa, ye a njekèjì ndùgù mì ndâ i-kó-ko. ");
INSERT INTO ndz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ndâ ꞌbí ꞌduù ŋìnó ꞌdáá gî táánò mbe gì gí mì yo kùṛo bà gì ye nó a ndâ mbe ngbà, tí ndâ mbe kùmùkù i mì ndâ ꞌduù; tacó énò, ndâ i-kó-ko sè tù tí ndú lá. ");
INSERT INTO ndz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Káa, ye a njekèjì ndùgù. I-kó-ko má ṛì gí tàꞌi có a i mì ye, i-kó-ko tí nò ꞌvala gî. Yí bà ṛì gí tàꞌi ta gbí dìì wó ngbáṛángàꞌi, yí bà co gí sè ta dìì wó ngbáṛángàꞌi, yí delè bà ꞌde i-zó-zò gî. ");
INSERT INTO ndz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mbe ngbà gì ŋìndi wó cuki ká gítí nèté bà ngbà i, ta bà ziki ndâ i-kó-ko, ta bà mèèkèꞌi tí ndú. Káa ye gì a i tacó wàa ndú ꞌví ꞌde ta ꞌválá, wàa ndú ꞌví ꞌvala pètèkèè go dó kpâ ta bèmbílì. ");
INSERT INTO ndz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ye a tó mbe kpolo tí ndâ i-kó-ko. Tó mbe kpolo tí ndâ i-kó-ko a ŋa mbe kpolo tí ndâ i-kó-ko ŋìnó mbe kû cì á muu ndâ i-kó-ko mì wó nô. ");
INSERT INTO ndz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ꞌDuù ŋìnó mbe kû kpolo tí ndâ i-kó-ko mì ꞌbí ka wó ká tacó bà pà yê tí wó cuki nó ká kû ì ngèlè jee ndâ i-kó-ko ji kàzà. Yí má ŋò sílì tí kàzà ngé gî, yí kû ì ngèlè si tàmuu ndâ i-kó-ko ji kàzà kû zèè ndú, delè kû njè gbí ndú jááká-jaaka ta gbí jìlì. ");
INSERT INTO ndz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yí kû ì ngèlè jee ndâ i-kó-ko ji kàzà tacó yí kû gbà ndú ká tacó bà pà yê tí wó cuki, nèté mì wó ta ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Káa ye a tó mbe kpolo tí ndâ i-kó-ko. Ye ŋò ndâ i-kó-ko mì ye ni gî, ndâ i-kó-ko mì ye delè ŋò ye ni gî. ");
INSERT INTO ndz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ze ŋò tí ze ni ta ndâ i-kó-ko mì ye, ká go bà ŋò tí ze ni ta Bu ye. Ye delè gbì gbí njembí ye gítí ku muu ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ndâ ꞌbí i-kó-ko mì ye kuu tí , náa ndú kpónó kû dù me ta ndâ ŋìnó ta ꞌbá muu ndú nó lá. Káa kózò tí ye bà gì ta ndú gítí ndâ ꞌbí ka ndú, ndú delè ꞌví ꞌdi kòcò ye, wàa ndú ꞌví dù ꞌdáá bà gbèe to, tacó wàa ye tí mbe kpolo tí ndú ꞌví dù káa gbèe ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bu ye kû dù ta go ye tí wó, tacó ye ùnje gítí bà cì ye, wàa ye ꞌví ꞌvala ndi ye kákáꞌi nò gî. ");
INSERT INTO ndz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","À me ꞌduù ká kû zi ye lá. À káa ye ká ùnje gítí bà cì ye ꞌdo gbí ꞌdóó có mì ye gbí muu ye. Bu ye je wotí bà cì ye go có mì ye gbí muu ye nò ji ye gî. Yí delè giì je wotí bà ꞌvala ndi ye á ꞌdo gbí ku ji ye gî.» ");
INSERT INTO ndz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Có tí nò náa Jézù ꞌdè nò giì bàkà a ꞌbè mí gbí òkò tí ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ndâ ꞌduù me mbè gbí òkò tí ndú giì ꞌdè có ji ndâ ꞌbí ka ndú máa, «Gbí ndeṛè bà sè tù ndâ ꞌduù tí ndâ có mì wó wálá. A i ká gbí muu wó! Yì a mbe mâ!» ");
INSERT INTO ndz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Káa, ndâ ꞌbí ꞌduù ŋìndi ndú giì ꞌvìsì có gí tàkò có mì ndâ ka ndú nò máa, «Ndâ có mì wó me go ndâ có mì ꞌduù ŋìnó ta i ká gbí muu wó nó lá. ꞌDuù ŋìnó ta i ká gbí muu wó nó bà njaanga ṛo mbe sú ṛo ta ŋa kpokèjì ngàyi?» ");
INSERT INTO ndz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","À ta o tí nò Jèrùzàlémè a o bà kùyà dèṛè mítí ꞌbá-Mbíṛì. O tí nò gì gbí pì mì côꞌo, ");
INSERT INTO ndz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","tacó énò, Jézù giì dù kû wùùkù to á tà ꞌbí i náa à bì yàꞌbàà énó mí gbí ndùgù ꞌbá-Mbíṛì, náa ndâ ꞌduù kû nì mítí  a Tàzo-mì-Sólómònì tí gbolò gbà mì ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ndâ Jùdéyà mâ giì ŋò yí, ndú giì tì yí jèlè ꞌdee gî. Bìndi  ndú giì ꞌvee yí máa, «Wò bà si ze kû koṛo có sàkàmàà énò yee tí ŋa o ngàyi? Wò má a Bìndi-Mbíṛì, ꞌdè ji ze ngbáṛángàꞌi!» ");
INSERT INTO ndz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye ꞌdè có tí nò ji yo sàà gî, káa a yo ká biya bà ꞌdi gî. Ndâ seṛè tí nó náa ye kû bàkà ta wotí mì Bu ye nó kû tùbà  ji yo máa, ndâ có mì ye a ndâ yúcó; ");
INSERT INTO ndz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","káa, yo biya bà ùnje gítí ye gî, tacó yo me ndâ i-kó-ko mì ye lá. ");
INSERT INTO ndz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ndâ i-kó-ko mì ye ꞌdi kòcò ye ni gî. Tacó énò, ndú kû ṛu ndi ye. Ze ŋò tí ze ta ndú ni gî. ");
INSERT INTO ndz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Gbèe i-kó-ko mì ye bà giṛi wálá, tacó ye je yeè-ꞌválá ŋìnó mbe cee lá nó ji ndú gî. Mbe kaa ndú ꞌdo tí ye ta wotí wálá, ");
INSERT INTO ndz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","tacó ꞌbí ꞌduù ta wotí tí wó mbe ꞌvii ta Bu ye tí nó tí mbe kaa ndú ji ye nó wálá. À má énò, ꞌbí ꞌduù mbe ṛa ndú tí ṛíngbá ꞌdo ꞌbì Bu ye wálá. ");
INSERT INTO ndz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ze ta Bu ye a ndâ gbèe ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ndâ Jùdéyà mâ giì ꞌdi có tí nò náa Jézù ꞌdè énó máa, «Ze ta Bu ye a ndâ gbèe ꞌduù» nò, ndú giì tuṛu díí tacó bà ꞌvaka ta yí. ");
INSERT INTO ndz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Káa Jézù giì ꞌvee ndú máa, «Ye tùbà ndâ tó i mbe gì ꞌdo mì Bu ye ji yo me mbè. À má énò, yo kpónó kaa díí tacó bà ꞌvaka ta ye nò a i tacó ngàyi á ꞌdo gbí òkò tí ndú?» ");
INSERT INTO ndz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Káa ndâ Jùdéyà giì ꞌvìsì có ji yí máa, «Ze kû tuṛu díí tacó bà ꞌvaka ta wò me tacó bà bàkà ndâ tó i mì lo a go có tí nò gbí nje lo nò lá. Ze bà ꞌvaka wò a i tacó bà ꞌdè zu có gítí Mbíṛì. Wò a ꞌduù, ta ndâ sìlì ꞌbì lo vô ká go ndâ ŋìndi ze, káa wò kû bàkà tí lo tí Mbíṛì ta wotí!» ");
INSERT INTO ndz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Káa Jézù giì ꞌvìsì có ji ndú máa, «ꞌBí có kuu gbí wáràgà mì Mbíṛì énó máa, Mbíṛì máa, ‹Yo a ndâ mbíṛì.› ");
INSERT INTO ndz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Káa ꞌvéṛè jé gbí wáràgà mì Mbíṛì wálá. Nògí, Mbíṛì nì ‹mbíṛì› mítí ndâ ꞌduù tí nó náa yí tí Mbíṛì ꞌdè có mì wó ji ndú nó gî. ");
INSERT INTO ndz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Káa, à má gítí bà miṛi ye, a Bu ye ká cu ꞌbì wó mítí ye tí ꞌdóó ŋìnó mì wó, bìndi  yí giì tuu ye gí muu to tí nô. À má énò, bà ꞌdè có mì ye énó máa, ye a ꞌViì-mì-Mbíṛì, giì ꞌvìsì tí gbí tù yo tí bà go Mbíṛì ta ŋa kpokèjì ngàyi? ");
INSERT INTO ndz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ye má kû bàkà me ndâ nèté mì Bu ye lá, gbí ndeṛè bà ùnje mì yo gítí ye wálá. ");
INSERT INTO ndz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ye kû bàkà a ndâ nèté mì Bu ye, káa go bà ùnje gítí ye kpêtí má sàà tí yo wálá, yo kùtàá bà ù vòó nje gítí ndâ nèté tí nò náa ye kû bàkà ndú nò, bìndi  yo bà ŋò ni gî máa, ze ta Bu ye a ndâ gbèe ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","À gbí muu ndâ Jùdéyà ta o tí nò a có bà zèè Jézù, káa yí giì fa ꞌdo tí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jézù giì dele ndi wó kákáꞌi ya gí tìto Jòròdánìyà, á gítí wúngbó to tí nó náa Jòvánì táánò sàà dù tí  kû caka tí ndâ ꞌduù nô. ");
INSERT INTO ndz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndâ ꞌduù me mbè giì kaa ya gí mì wó kà. Ndâ mbe kaa ya gí mì wó nò giì ùlù yí máa, «Jòvánì táánò jé bàkà ndâ seṛè lá, káa ndâ có mì wó táánò náa yí ꞌdè gítí ꞌdakò tí nó ꞌdáá káa yúcó.» ");
INSERT INTO ndz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tacó énò, ndâ ꞌduù ꞌdo gbí òkò tí ndú me mbè giì ùnje gítí Jézù ta njembí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ta o tí nò si Jézù kuu tìto Jòròdánìyà nò, nòꞌo giì bàkà ꞌbí ꞌdakò tí tó kómbe Jézù ta ṛè wó a Lázàrò, tí námì ndâ Márátà ta Màríyà, ta ꞌbá mì ndú gbí gbata Bètánìyà. ( ");
INSERT INTO ndz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ŋìnò a Màríyà tí nó táánò mbe giì yee pó bàà mítí kò Mbe tí ndoo, bìndi  yí giì gbètèkè cee tí  ta se muu wó nô.) ");
INSERT INTO ndz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ndâ námì Lázàrò bà-i-nò giì tuu ꞌduù ta có nòꞌo tí wó ya tí  ji Jézù máa, «Kpóló-kpolo tó ꞌduù mì lo kàá ta nòꞌo tí wó, Mbe tí ze.» ");
INSERT INTO ndz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jézù mâ giì ꞌdi có tí nò, yí giì ꞌvìsì có máa, «Nòꞌo tí nò bà zi yí wálá. Nòꞌo tí nò tí wó nò bà dù tí i mbe si ndâ ꞌduù ꞌví ùlù Mbíṛì. Nòꞌo tí nò delè ká bà si ndâ ꞌduù ꞌví wu gbí ꞌViì-mì-ꞌDakò.» ");
INSERT INTO ndz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ndâ Márátà ta Màríyà giì je námì ndú Lázàrò a ndâ tó ꞌduù mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Káa ta ndâ ŋa ŋìnó ꞌdáá gî, Jézù giì bàkà a sili só á bìndi bà ꞌdi có nòꞌo tí Lázàrò mì wó má kózò gî, ");
INSERT INTO ndz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","yí bà giì ꞌdè có ji ndâ mbe tala có mì wó máa, «Ndoo dele ndi ndoo ya gí Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Káa ndâ mbe tala có mì Jézù giì ꞌvee yí máa, «Mbe nìbà i, ndâ ꞌduù Jùdéyà bàkà có bà ꞌvaka wò ta díí á dê kuu yáánó nô, káa wò kákáꞌi kpónó máa, wò kû dele ndi lo wúnó ya gí ꞌbá Jùdéyà?» ");
INSERT INTO ndz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ṛi kû co ta dúꞌo, bìndi  yí giì ta ta ꞌdêꞌo. À me énò lá? ꞌDuù má nò nó si ṛi kuu yaà yí tò kò wó lá, tacó ngbaꞌo kuu tí . ");
INSERT INTO ndz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","A mbe kû nò nó ta bèbìlì ká kû tò kò wó, tacó ngbaꞌo tacó bà ŋò ta to mì wó wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jézù mâ giì lòkòꞌbò có tí nò ji ndâ mbe tala có mì wó gî, yí giì ꞌdè có ji ndú máa, «Kómbe ndoo tí nó tí Lázàrò nó kû tèṛì. À má énò, ye kû ya gí bà gbà yí ꞌdo tí ṛì gí yaà.» ");
INSERT INTO ndz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Káa ndâ mbe tala có mì Jézù giì ꞌvìsì có ji yí máa, «Yí má tèṛì gî, gbí dìì wó bà da gî, Mbe tí ze.» ");
INSERT INTO ndz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Gbí lòkóꞌbò tí nò náa Jézù ꞌdè énó máa, «Lázàrò kû tèṛì» nò énó máa, «Lázàrò cì gî.» Káa ndâ mbe tala có mì Jézù ŋìndi ndú ꞌdi gbí  ni lá. ");
INSERT INTO ndz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tacó énò, Jézù giì ꞌdè gbí  ji ndú ngbáṛángàꞌi énó máa, «Lázàrò cì gî. ");
INSERT INTO ndz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Káa tàkòcò ye peteke tacó tí yo ma, tacó ye táánò me kà ta o bà cì yí nò lá. À má énò, yo kpónó bà giì ùnje gítí ye ta njembí yo gî. Nògí, ndoo ya gí bà ku wó.» ");
INSERT INTO ndz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Káa Tòmázò tí nó náa à kû nì mítí wó a Njemî nó, giì ꞌdè có ji sè ndâ ꞌbí ka wó mbe tala có mì Jézù máa, «Ndoo ya gí Jùdéyà ta ndâ mbe nìbà i ji ndoo, wàa à má a ku, ndoo ꞌví cì ta ndú ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jézù yee Bètánìyà si Lázàrò bàkà sili nàꞌô mí tà to gî. ");
INSERT INTO ndz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","(ꞌBá mì ndâ Lázàrò, Bètánìyà, ká dê ta Jèrùzàlémè.) ");
INSERT INTO ndz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jézù giì yee kà si ndâ Jùdéyà tí nó mbe kaa ꞌdo Jèrùzàlémè ya gí bà wa ku ta ndâ Márátà ta Màríyà nó ká gbí-gbi kuu bà ku. ");
INSERT INTO ndz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Márátà mâ giì ꞌdi có énó máa, Jézù kèjì, yí giì njè nó ya gí bà ù kùṛo Jézù mí kpokèjì, si Màríyà mí ꞌbá. ");
INSERT INTO ndz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ndú mâ giì ꞌde tí ndú gî, Márátà giì ꞌdeke tí wó ji Jézù máa, «Wò táánò má kuu to nó, námì ye bà cì wálá, Mbe tí ye. ");
INSERT INTO ndz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Káa ye ŋò ni gî máa, wò kpêtí kpónó má yù káa ŋa yè wè ꞌdo mì Mbíṛì, yí bà je ji wò gî.» ");
INSERT INTO ndz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Káa Jézù giì ꞌvìsì có ji Márátà máa, «Námì lo bà a ndi wó gí yaà gî.» ");
INSERT INTO ndz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Káa Márátà bà-i-nò giì ꞌvìsì có ji Jézù máa, «Ye ꞌdi gbí có mì lo nò gî. Ye ŋò ni gî máa, yí bà a gí yaà ta o bà ꞌvala ndi ndâ ku á ꞌdo gbí muuꞌdú ndú ta ndòngbú o wúnò gî.» ");
INSERT INTO ndz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Káa Jézù giì ꞌvìsì có ji Márátà máa, «Ye a mbe ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú. Ye delè a ꞌválá. ꞌDuù má ùnje gítí ye ta njembí wó gî, yí kpêtí má cì ká cì, yí bà ꞌvala ndi wó gî. ");
INSERT INTO ndz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Káa wu ꞌduù ŋìnó kpónó mbe kû ùnje gítí ye nó jé gí bà cì wálá. Wò ùnje gítí có tí nò gî?» ");
INSERT INTO ndz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Márátà bà-i-nò giì ꞌvìsì có ji Jézù máa, «Ye ùnje gî, Mbe tí ye. Ye ùnje gî máa, wò a Bìndi-Mbíṛì, tí ꞌViì-mì-Mbíṛì, tí ꞌduù tí nó náa Mbíṛì tuu yí gí muu to tí nó nô.» ");
INSERT INTO ndz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ndâ Márátà mâ giì ꞌdè nje ta Jézù cee gî, Márátà giì dele ndi wó ya gí ꞌbá, bìndi  yí giì tèꞌé tí náꞌvindí wó Màríyà ꞌdo gbí òkò tí ndâ ꞌduù gí ndiì, bìndi  yí giì ꞌdè có ji yí ta ngûcó, máa, «Mbe nìbà i gì gî. Káa go bà ŋò wò kuu tí wó.» ");
INSERT INTO ndz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Màríyà mâ giì ꞌdi có tí nò, yí giì goonó ya gí mì Jézù ");
INSERT INTO ndz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","á kpokèjì, tí gbèe bàndò tí nó náa ndâ Jézù ꞌde tí ndú ta Márátà tí  nô, si yí yee ꞌbá lá. ");
INSERT INTO ndz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndâ Jùdéyà tí nó mbe gì gí bà ku nó mâ giì ŋò bà goonó mì Màríyà kû ya gí ta é mì Jézù tí kpokèjì, ndú giì kaa ya gí tàkò wó, tacó ndú koṛo có máa, yí kû ya a i gí bà wa gbí á muuꞌdú. ");
INSERT INTO ndz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Màríyà mâ giì cu ṛo wó mítí Jézù, yí giì ꞌva tí wó mí kùṛo Jézù, bìndi  yí giì zèè kò Jézù kû wa ta gbí, ta bà ꞌdeke tí wó máa, «Wò táánò má kuu bà-i-nó, námì ye bà cì wálá, Mbe tí ye!» ");
INSERT INTO ndz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jézù mâ giì ŋò ndâ Màríyà ta ndâ ꞌduù tí nó mbe kaa gì gí tàkò wó nó kû wa gbí, ṛé wó giì doo ŋùyìì ta sé có. Bìndi  yí giì wo gù woò, má kózò gî, ");
INSERT INTO ndz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","yí giì ꞌvee ndâ ꞌduù tí nò máa, «Yo bàkà bàndò mì wó mí ngò?» Káa ndâ ꞌduù tí nò giì ꞌvìsì có ji yí máa, «Gì gí bà ŋò , Mbe tí ze.» ");
INSERT INTO ndz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ngo-ṛo Jézù bà-i-nò giì ꞌdù ta bà ŋò yê ṛo ndâ ꞌduù tí nò mbe kili mí bà ku nò. ");
INSERT INTO ndz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ndâ ꞌbí Jùdéyà mâ giì ŋò bà ꞌdù ngo-ṛo Jézù nò, ndú giì ꞌbìtà bà ꞌdè có gbí òkò tí ndú máa, «Yí zè ꞌdakò tí nò nìkì ngé ndii gî!» ");
INSERT INTO ndz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Káa ndâ ꞌbí ꞌduù giì dù kû ꞌvee a ꞌvé máa, «ꞌDakò tí nó táánò njaanga ṛo mbe sú ṛo gî. Yí táánò má bà-i-nó, bà ꞌvala Lázàrò bà kpò yí gî?» ");
INSERT INTO ndz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","39","Jézù mâ giì yee ta ndâ ꞌduù tí muuꞌdú gî, Jézù giì wo ndi gù woò kákáꞌi. Bìndi  yí giì ꞌdè có ji ndâ ꞌduù tí nò máa, ndú te gbolò díí tí nó náa à nè ta nje gùù nó gî. Káa Márátà giì ꞌvìsì có ji Jézù máa, «ꞌDuù tí nò kpónó volo gî, Mbe tí ye. Tacó à wúnó tí wó tà to a sili nàꞌô.» ");
INSERT INTO ndz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Káa Jézù giì ꞌvee Márátà máa, «Ye kùtàá ꞌdè có ji wò énó máa, wò má ùnje gítí ye gî, wò bà ŋò wotí mì Mbíṛì gî nò lá?» ");
INSERT INTO ndz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ndâ ꞌduù tí nò mâ giì yèè díí ꞌdo nje gùù gî, Jézù giì zekeꞌo gí gbíṛì. Bìndi  yí giì ꞌdeke tí wó ta bà ꞌdè nìkì maa ji Mbíṛì máa, «Ye ꞌdè nìkì maa ji wò tacó bà ŋò bà ꞌdeke tí ye ji wò, Bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ye ŋò ni gî máa, wò ta o ꞌdáá gî kû ꞌdi có mì ye. Káa ye kpónó kû ꞌdè có ji wò gbí ŋìnó ká tacó tí ndâ ꞌduù tí nó mbe tì ye ꞌdee gî nô, tacó wàa ndú ꞌví ù ta nje énó máa, a wò táánò ká tuu ye.» ");
INSERT INTO ndz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jézù mâ giì ꞌdeke tí wó ji Mbíṛì cee gî, yí giì tèꞌé tí Lázàrò ta kòcò wó ngárá gí yaà máa, «Lázàrò! Co gí sè!» ");
INSERT INTO ndz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lázàrò bà-i-nò giì co gí sè ta kábà bà so yí náa à te ta yí mí gbí gùù nô. Bìndi  Jézù giì ꞌdè có ji ndâ ꞌduù máa, «Yo njaanga ndâ i tí nò á ꞌdo tí wó gî, wàa yo ꞌví si yí ꞌví ya .» ");
INSERT INTO ndz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndâ ꞌduù me mbè ꞌdo gbí òkò tí ndâ Jùdéyà tí nó mbe gì gí bà tì ku muu ndâ námì Lázàrò ta o tí nò mbe ŋò i tí nò náa Jézù bàkà nò gî, giì ùnje gítí Jézù ta njembí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Káa ndâ ꞌbí ꞌduù gbí òkò tí ndú giì ya gí bà ꞌdè ndi ŋa i tí nò náa ndú ŋò nò ji ndâ mbe kpolo tí tàkìì mì ndú tí ndâ Jùdéyà á gbí gbata Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ndâ mbe kpolo tí tàkìì, ta ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà mâ giì ꞌdi ŋa có tí nò, ndú giì kili ndâ kpo ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà ꞌdáá gî. Bìndi  ndú giì ꞌdè có ji ndú máa, «Ndoo kû tèṛì, káa ꞌdakò tí nò kaa ndâ ꞌduù mìì ꞌdo tí ndoo gî ta bà bàkà ndâ kpo-kpò nèté. ");
INSERT INTO ndz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ndoo má ꞌdè có énó máa, ndoo si yí ká mí nje ŋa nèté tí nò mì wó nò, ndâ ꞌduù ꞌdáá gî bà giì ùnje ká gítí wó. Káa ŋa có tí nò má di gbí tù ndâ kpo-kpò ꞌduù mì ndâ ꞌduù Rómà, ndú bà giì njè gbí ngbàngà tí nó mì ndoo nó gî. Ndú delè bà giì volo ꞌbá mì ndoo gî. Tacó ndú bà koṛo có máa a ndoo ká le bèṛè ji ꞌdóó ꞌduù mì ndoo ta muu ndoo.» ");
INSERT INTO ndz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Káa ꞌbí ꞌdakò gbí òkò tí ndú, tí Kùṛo ndâ bu Mbíṛì ta ndoò tí nò, ta ṛè wó a Kàyífà, giì ꞌvìsì có ji ndú máa, «Ye ŋò goòlá yo ŋò ꞌdóó ŋa i tí nó náa yo ꞌví bàkà nó ni lá nô. ");
INSERT INTO ndz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yo ŋò ni lá máa, à nìkì à bà cì gbèe ꞌduù muu sè mbè ndâ ꞌduù á co tí bà ꞌbu ꞌbá?» ");
INSERT INTO ndz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kàyífà ꞌdè có tí nò me ꞌdo gbí muu wó lá. A Mbíṛì ká wu ji yí, tacó yí a Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, máa, yí ꞌdè có ji ndú énó máa, Jézù kèjì gí bà cì á muu ꞌbá mì ndú tí ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Káa yí delè bà cì me ká muu ꞌbá mì ndâ Jùdéyà cuki lá. Yí bà cì tacó bà kili ndâ ꞌviì mì Mbíṛì mbe ꞌvaaka gî nó, wàa ndú ꞌví co tí gbèe kpokèjì. ");
INSERT INTO ndz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ꞌDo gbí ṛi tí nò, ndâ kpo ꞌduù mì ndâ Jùdéyà giì toṛo ꞌbì ndú mítí to máa, ndâ yì má zi Jézù lá, ndâ yì kákáꞌi bà zi ꞌbí ꞌduù muu to tí nó wálá. ");
INSERT INTO ndz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tacó énò, Jézù kákáꞌi giì nò ta ndi gbí òkò tí ndâ Jùdéyà gbí ngbàà ṛi lá, ndú giì ya ta ndâ mbe tala có mì wó gí gbí gbata Éfìràmù á nje kángáá nga ngoò. ");
INSERT INTO ndz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","O bà bàkà tàkìì bà ꞌva mbí o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì mâ giì dooko gî, mbè ndâ Jùdéyà tí nò mbe kaa ꞌdo ndiì ya gí gbí gbata Jèrùzàlémè tacó bà pà làyì gítí ndâ vò i mì ndú kùṛo bà zò i-cí-ci ta o tí nò nó ");
INSERT INTO ndz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","mâ giì ŋò Jézù gbí òkò tí ndâ ꞌduù tí nó gbí ndùgù ꞌbá-Mbíṛì nó lá, ndú giì ꞌbìtà bà ꞌvee ndâ ꞌbí ka ndú máa, «Yo kû koṛo có máa yè? Yí tóó kèjì gí bà líkíꞌo tí nó wálá?» ");
INSERT INTO ndz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ndâ Jùdéyà dù kû ꞌvee ŋa ꞌvé tí nò tacó ndâ kpo ꞌduù, ta ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ mbe kpolo tí tàkìì mì ndú tí ndâ Jùdéyà, ꞌdè có ji ndú sàà gî máa, mbe ŋò bà tí Jézù gî ꞌví ꞌdè gí sè, tacó wàa ndâ yì ꞌví zèè yí. ");
INSERT INTO ndz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jézù giì dele ndi wó ꞌdo gbí to Éfìràmù ya gí ꞌbá mì ndâ Lázàrò tí nó náa yí tí Jézù ꞌvala yí ꞌdo gbí muuꞌdú wó nó gbí gbata Bètánìyà, si sè sili gítí o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì ká vô-nje gbaànjé cuki. ");
INSERT INTO ndz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yí mâ giì yee kà, ndâ ꞌduù kà giì te wiṛi mítí wó. A Márátà tí námì Lázàrò ta ꞌdêꞌo tí nò ká kû njèè i-zó-zò ji ndâ Lázàrò ta ndâ wiṛi tí nó mbe kili kû zò i ta ndâ Jézù nô. ");
INSERT INTO ndz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Káa si ndâ ꞌduù kuu bàndò bà zò i, Màríyà tí ꞌbí námì Lázàrò, giì te ꞌbí ŋa banga pó bàà náa à ŋònòkò ta cèe dì, náa yí sì ta mboo me gbolò, á gbí káꞌi nìkì maa énô. Yì giì gbì ꞌbèꞌdè-ꞌbèꞌdè énó mítí kò Jézù. Bìndi  yí giì toṛo gbí ndí  ta tí kò Jézù ta se muu wó. Banga pó bàà tí nò giì yè tàꞌi ngbúú-ngbu-ngbù gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Káa Júdà Ìsìkàrìyótè, tí ꞌbí mbe tala có mì Jézù gbaànjé, tí ꞌduù tí nó mbe giì ba ngbù Jézù nó, giì ꞌvee ꞌvé ta kpo tàkòcò máa, ");
INSERT INTO ndz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Àá kùtàá má sì banga pó bàà tí nò gí ꞌdè ta gbolò i, wàa à ꞌví ko ta ndâ mbe yê, káa yè?» ");
INSERT INTO ndz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Júdà ꞌdè có tí nò me tacó máa, có tí ndâ mbe yê kpolo mì wó ma nò lá. Yí ꞌdè énò, tacó yí a mbe kû kpolo tí ndâ i ŋìnó náa à kuu tí  nó tacó tí ndú tí ndâ mbe tala có mì Jézù ꞌdáá gî nô. Káa à gbí muu wó énó máa, má wálá wàa Màríyà ta o tí nò ꞌví sì pó bàà tí nò gí ꞌdè ta gbolò i, wàa yí ꞌví kaa gì tí  a i ji yì tí mbe kpolo tí gálá, tacó wàa, yì ꞌví po ta tí  á gítí miṛi yì, tacó yí a mbe ngbà. ");
INSERT INTO ndz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Káa Jézù giì ꞌvìsì có ji Júdà máa, «Pà nje niì tí nò lá. Yí kpolo nò a tí bàà tí nò mítí kútí ye, tacó wàa à ꞌví giì duu ta ye. ");
INSERT INTO ndz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ndâ mbe yê bà dù ta o ꞌdáá gî kuu gbí òkò tí yo, káa yo bà ꞌde ye ta o ꞌdáá gî wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ndâ Jùdéyà me mbè mâ giì ꞌdi có énó máa, Jézù kuu gbí gbata Bètánìyà, ndú giì kaa ya gí bà ŋò yí. À gbí muu ndú ta o tí nò me káa có bà ya gí bà ŋò Jézù cuki lá. Ndú ya kpolo ma a i tacó bà ŋò Lázàrò, tí ꞌdakò tí nó náa Jézù ꞌvala yí ꞌdo gbí muuꞌdú wó nô. ");
INSERT INTO ndz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tacó énò, ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà giì toko có mì ndú énó máa, à ꞌví zi Lázàrò delè gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tacó ndeṛè bà ùnje mì ndâ Jùdéyà gítí Jézù si ndâ yì mí to ꞌdáá ꞌdo ká gbí có bà ꞌvala yí. ");
INSERT INTO ndz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jézù giì ꞌbì nó ta ꞌbí yé bìndi bà te wiṛi mítí wó mì ndâ ꞌduù Bètánìyà kû ya gí Jèrùzàlémè. Ndâ mbè ndâ Jùdéyà tí nó mbe tì mí bà o bà waa mbelè a Jèrùzàlémè nó mâ giì ꞌdi có énó máa, Jézù tí kpokèjì kèjì ꞌdo Bètánìyà gí Jèrùzàlémè, ");
INSERT INTO ndz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ndú giì saaka ndâ kpâ-lígì, bìndi  ndú giì zèè ta ndi ꞌbì ndú kû ya tí  gí bà ù ta kùṛo Jézù. Jézù mâ giì yee gî, ndú giì ꞌbìtà bà tò kû ta líkíꞌo máa, «Òsánà!» (Gbí  énó máa, «ꞌvala ze!») «Mbíṛì ꞌví si gbolò gba mì ndoo tí ndâ Jùdéyà, tí mbe gì ta ṛè wó tí Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jézù ta o tí nò kû o a ngbú ꞌviì-kècè, a go có tí nó náa a cu mí gbí wáràgà mì Mbíṛì énó máa, ");
INSERT INTO ndz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ndâ mbe sì ꞌbá pí gú Zìyónì á Jèrùzàlémè, yo cì gúku lá! Yo ŋò gbolò gba mì yo kpokèjì pí ngbú ꞌviì-kècè zô,» nô! ");
INSERT INTO ndz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ndâ mbe tala có mì Jézù ꞌdi gbí ndâ i tí nò ta o tí nò gbaànjé lá, káa à mâ giì te Jézù mí pí jàlàmbà mì Mbíṛì lê gî, mbí ndú bà giì ꞌva tí  énó máa, à cu có gítí ndâ i tí nò á mí gbí wáràgà mì Mbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Ndâ ꞌduù me mbè kaa ta o tí nò ya gí bà ù kùṛo Jézù, tacó ndâ ꞌduù tí nó náa Jézù táánò tèꞌé tí Lázàrò ꞌdo gbí muuꞌdú wó bìndi  yí giì ꞌvala yí si mítí ndú nó, ká dìtà ndâ có ŋìnó náa ndú ꞌdi ta tù ndú nó, ta ndâ i ŋìnó náa ndú ŋò ta ṛo ndú nó, ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà mâ giì ŋò énò, ndú giì ꞌbìtà bà ꞌdè có gbí òkò tí ndú máa, «Yo wálá ŋò ndi yo nò gî? Ndoo bà je bà i tí wó kákáꞌi wálá! Yo ŋò ndâ ꞌduù kpónó tè ꞌdáá gí tàkò có mì wó gî!» ");
INSERT INTO ndz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ndâ ꞌbí Ìgìrígì mbe gì gí Jèrùzàlémè tacó bà bàkà i-Mbíṛì ta o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì nò, ");
INSERT INTO ndz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","giì ya gí mì Fìlípò tí ꞌbí mbe tala có mì Jézù, ta ꞌbá mì ndú gbí gbata Bètìsàyídà á gbí to Gàlìléyà. Bìndi  ndú giì ꞌdè có ji yí máa, «Go bà ꞌdè có ta Jézù kuu tí ze, kpo ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fìlípò bà-i-nò giì ꞌdòkò ndi có mì ndâ Ìgìrígì tí nò ji Àndèréyà, tí ꞌbí ka wó mbe tala có mì Jézù. Bìndi  ndú giì ya ta yí gí bà ꞌdè có ji Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Káa Jézù giì ꞌvìsì có ji ndú máa, «O bà te ꞌViì-mì-ꞌDakò gí pí jàlàmbà kpónó gì gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ye kû ꞌdè có ji yo ta yúcó máa, à má ꞌva njì cû mí tà to wàa yí ꞌví kù ndi wó lá, njì cû tí nò bà dù ká tí gbèe njì cû dúú bà ya tí . Káa gbèe njì cû tí nò má ku gî, àá bà waa ꞌdo bà-i-nò a muu cû ta njì cû tí  jùṛùꞌbùù. ");
INSERT INTO ndz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ꞌDuù ŋìnó ta líkí bà ꞌvala muu to nó tí wó nó kû giṛi a miṛi wó. Káa ꞌduù ŋìnó mbe kû kì nje mbíṛì wó gítí bà ꞌvala muu to tí nó tacó tí ye nó ká kû kpolo tí miṛi wó gítí ꞌválá ŋìnó mbe cee lá nô. ");
INSERT INTO ndz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Go bà dù tí bòò mì ye má kuu tí ꞌduù, yí ꞌví gì gí bà ṛu ndi ye. Tacó wàa ze ꞌví dù ta bòò mì ye tí gbèe bàndò. ꞌDuù má dù tí bòò mì ye, Bu ye bà tègàṛà ꞌduù tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Káa ye kpónó ŋò ꞌdóó có tí nó náa ye ꞌví ꞌde ji yo nó lá, tacó njembí ye kû mú-mù. Ye ꞌví ꞌdeke a tí ye ji Bu ye máa, yí ꞌvala ye ꞌdo kùṛo vò o tí nó kèjì nô? Káa dú ndeṛè bà gì ye gí muu to tí nó táánò a i tacó bà dù á nje vò o tí nò nó! ");
INSERT INTO ndz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Àá Bu ye, tùbà wotí mì lo ji ndâ ꞌduù! Tùbà tí lo tí cèe ꞌduù ji ndú!» Jézù mâ giì ꞌdè có tí nò yee to gî, ndâ ꞌduù giì ꞌdi kòcò ꞌduù kû ꞌdè có ꞌdo gbíṛì máa, «Ye táánò tùbà wotí mì ye ji ndú gî, káa ye kèjì gí bà tùbà  ji ndú kákáꞌi.» ");
INSERT INTO ndz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ mbè kû ṛò tíyò ta ṛègbà tí Jézù nó giì ꞌdè gítí kòcò ꞌduù tí nò náa ndú ꞌdi kû ꞌdè có ꞌdo gbíṛì nó máa, «A ngbàngbàṛì ká kû baṛaka i!» Káa ndâ ꞌbí ꞌduù ŋìndi ndú giì ꞌdè có máa, «A basìlì mì Mbíṛì ká kû ꞌdè có ji Jézù.» ");
INSERT INTO ndz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Káa Jézù giì ꞌvìsì có ji ndâ ꞌduù tí nò máa, «Kòcò ꞌduù tí nò kû ꞌdè có me tacó tí ye lá. Yí kû ꞌdè có a i tacó tí yo. ");
INSERT INTO ndz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","O bà ŋò ꞌbè gbí òkò tí ndâ yúcó ta ꞌvéṛè mí ndâ ꞌduù yee kpónó gî. À kpónó nó a o bà tòò Gba-to-tí-nó ꞌdo pí jàlàmbà gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Káa ye, à má gbì ye mítí njèèkpè mû gî, ndâ ꞌduù muu to tí nó bà kili ꞌdáá gî gì gí mì ye.» ");
INSERT INTO ndz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jézù ꞌdè có tí nò tacó bà tùbà ŋa ku tí nó á kèjì gí bà zi yí nó ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Káa ndâ ꞌduù giì ꞌvee yí máa, «À nìbà  ji ze tí ndâ Jùdéyà ꞌdo gbí wáràgà mì Mòze énó máa, Bìndi-Mbíṛì bà dù ká dúú bà ya tí . Káa wò kû ꞌdè ji ze ŋìnó ndíi a ŋa có ngàyi? Máa, àá bà giì gbì ꞌViì-mì-ꞌDakò mítí njèèkpè mû nó! ꞌViì-mì-ꞌDakò tí nò mì lo nò a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Káa Jézù giì ꞌvìsì có ji ndú máa, «Sè bà dù Ngbaꞌo ta yo kpónó ká njíꞌdí. Nògí, yo nò nó si Ngbaꞌo kuu tí  nô, tacó ꞌdíꞌdiꞌo kpokèjì gí bà gbo yo, káa mbe kû nò nó gbí ꞌdíꞌdiꞌo ŋò to tí nó náa yí ya gítí  nó ni lá. ");
INSERT INTO ndz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yo ùnje ta njembí yo gítí Ngbaꞌo kpónó si Ngbaꞌo ká kuu tí  nô, tacó wàa, yo ꞌví dù tí  tí ndâ ꞌviì mì Ngbaꞌo.» Jézù mâ giì yee nje có mì wó gî, yí giì fa ya gí bà ngùù tí wó ꞌdo tí ndâ ꞌduù gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ndâ Jùdéyà ŋò ŋa ndâ tende seṛè tí nó náa Jézù bàkà cúú-cu-cù gbí ndâ o tí nò nó ta ṛo ndú ngbáṛángàꞌi gî, káa, ta ndâ ŋa ŋìnò ꞌdáá gî, ndú giì biya bà ùnje gítí Jézù gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Go có tí nó náa Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì ꞌdè sàà énó, máa, «A ꞌdi ká ꞌdi ndâ có mì lo náa ze kû ꞌdòkò nó, Mbe tí ye? A ꞌdi ká ùnje gítí ndâ seṛè tí nó náa wò tí Mbíṛì, tí Mbe tí ye kû bàkà mí kùṛo ndâ ꞌduù nó?» nô. ");
INSERT INTO ndz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bà ùnje gítí ndâ có mì Mbíṛì ta ndâ nèté mì Mbíṛì gbí ndâ o tí nò dú kpò ndâ ꞌduù gî, a go ꞌbí có tí nó náa Ìzáyà ꞌdè kákáꞌi énó máa, ");
INSERT INTO ndz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Mbíṛì yoo ṛo ndâ ꞌduù gî. Yí delè giì biya bà je muu ji ndú gî. Yí bàkà énò tacó yí ŋò ni gî máa, yì kpêtí má kpoko ndâ ṛo bà ŋò i mítí muu ndú, yì delè kpêtí má je muu bà koṛo có ji ndú, ndú bà ꞌvìsì tí ndú gí mì yì wàa yì ꞌví ꞌvala ndú nò wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mbíṛì ꞌdè có tí nò ji Ìzáyà gítí ngbútù mì ndâ ꞌduù, tacó Mbíṛì wu bà ŋò ngba Jézù ji yí tí Ìzáyà gî, káa yí kû ꞌdè có gítí . ");
INSERT INTO ndz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kpêtí ká énò, ndâ ꞌduù me mbè ꞌdo gbí òkò tí ndâ kpo ꞌduù mì ndâ Jùdéyà giì ùnje gítí Jézù gî. Káa, ndú tùbà tí ndú gí sè lá, ta gúku máa, ndâ mbe kpolo tí tàkìì mì ndâ Jùdéyà bà mò ndâ yì ꞌdo gbí òkò tí ndâ ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ndú bàkà énò, tacó go bà ùlù ndú mì ndâ ꞌduù tí ndú ndii go bà ùlù ndú mì Mbíṛì tí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jézù giì kò-kò ta ndâ có mì wó ji ndâ ꞌduù ꞌdáá gî ngbáṛángàꞌi énó máa, «ꞌDuù má ùnje gítí ye gî, yí kû ùnje tí nò me ká gítí ye cuki lá. Yí kû ùnje a i gítí mbe tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ꞌDuù mbe ŋò ye ta ṛo wó gî, yí delè ŋò nò a mbe tuu ye ta ṛo wó gî. ");
INSERT INTO ndz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ye, tí Ngbaꞌo, gì gí muu to tí nó, tacó wàa ꞌduù mbe ùnje gítí ye gî ꞌví dù gbí ꞌdíꞌdiꞌo kákáꞌi lá. ");
INSERT INTO ndz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ꞌDuù má ꞌdi ndâ có mì ye, káa yí má kpolo tí ndú ta njembí wó gbaànjé lá, à me ye wúnò ká bà waa có mítí wó lá, tacó ye gì me tacó bà waa có mítí ndâ ꞌduù lá; ye gì a i tacó bà ꞌvala ndú. ");
INSERT INTO ndz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Gba mbe waa có mítí ꞌduù ŋìnó mbe biya ye ta ndâ có mì ye ꞌdáá gî nó ta ndòngbú o wúnò kuu tí . Gba tí nò a ndâ có tí nó náa ye ma nô. ");
INSERT INTO ndz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Àá bà dù énò, tacó ye kû ꞌdè có me ta muu ye lá. Ye kû ꞌdè a kòcò Bu ye, tí mbe tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ye delè ŋò ni gî máa, ndâ có mì Bu ye a ndâ có mbe je ꞌválá ŋìnó mbe cee lá nó ji ndâ ꞌduù. À má énò, ye kû ꞌdè káa ndi ndâ có tí nó náa a Bu ye ká ꞌdè ji ye nô.» ");
INSERT INTO ndz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jézù ta o tí nó ŋò ni gî, máa, o bà ya yì gí mì Bu yì ꞌdo muu to tí nó gì gî, tacó sè  ta o tí nò káa làmbu o gítí o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì. Yí jé waa ꞌdo tí bà zè ndâ ꞌdóó ꞌduù mì wó nìkì maa sàà kùṛo lá. Káa gbí ndòngbú o tí nò, yí giì tùbà  ji ndú énó máa, yì zè ndú nìkì ta njembí yì gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ndâ Jézù ta ndâ mbe tala có mì wó ta ꞌdêꞌo tí nò kû zò i, si vò i ŋònòkò muu Júdà Ìsìkàrìyótè tí ꞌviì mì Sìmónè sàà gî máa yí ba ngbù Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Káa Jézù ŋò ni gî, máa, Bu yì je wotí bà bàkà ndâ i ꞌdáá gî ji yì gî. Yí delè giì ŋò ni gî, máa, yì táánò gì ꞌdo mì Mbíṛì, káa yì kû giì dele ndi yì ya gí mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tacó énò, yí bà-i-nò giì a gí yaà ꞌdo tí i-zó-zò, bìndi  yí giì ja wòòkò bòngo tí nó náa à tí wó nó gî, yí giì paṛa bòngo bà toṛo ngo ꞌdo tí i mí ṛèꞌdè wó. ");
INSERT INTO ndz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bìndi  yí giì yee ngo mí gbí ꞌbí kpàlàkà káꞌi. Bìndi  yí giì ꞌbìtà bà caka kò ndâ mbe tala có mì wó. Yí má caka kò ꞌduù ŋìnò gî, yí toṛo ngo ꞌdo tí  ta bòngo bà toṛo ngo tí nó náa yí paṛa mí ṛèꞌdè wó nó má kózò gî, yí bà giì ꞌdòkò gítí kò ꞌbí ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jézù mâ giì caka kò ndâ mbe tala có mì wó kpòò, yí mâ giì yee tí Pìyétòrò, Pìyétòrò giì ꞌvee yí máa, «Wò kèjì gí bà caka kò ye delè, Mbe tí ye?» ");
INSERT INTO ndz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Káa Jézù giì ꞌvìsì có ji Pìyétòrò máa, «Wò kpónó bà ŋò i tí nó náa ye kû bàkà nó ni wálá. Wò bà ŋò ni a i bìndi .» ");
INSERT INTO ndz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Káa Pìyétòrò giì ꞌvìsì có ji Jézù máa, «Jéé lá! Wò jé gítí bà caka kò ye wálá.» Káa Jézù giì ꞌvìsì có ji Pìyétòrò máa, «Ye má caka kò lo lá, gbí  énó máa, ꞌbí i mbe toko ndà kákáꞌi wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pìyétòrò mâ giì ꞌdi có tí nò náa Jézù ꞌvìsì ji yí nò, yí giì ꞌdeke tí wó ji Jézù máa, «À má énò, caka me káa ndâ kò ye cuki lá, Mbe tí ye. Caka ndâ ꞌbì ye ta muu ye delè gî.» ");
INSERT INTO ndz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Káa Jézù giì ꞌvìsì có ji Pìyétòrò máa, «ꞌDuù má caka tí wó gî, gbí ndeṛè bà caka ndâ bà to tí nó náa wò kû ꞌdeke nò wálá, tacó kútí wó ꞌdáá gî ká ngbáṛángàꞌi. Bètí ká tí ndâ kò wó cuki. Kútí yo ꞌdáá gî ká ngbáṛángàꞌi. Yo ꞌdáá gî. À bè gbí  káa ꞌduù gbaànjé.» ");
INSERT INTO ndz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jézù ŋò ꞌduù tí nó bà giì ba ngbù wó nó ni gî. Ŋìnò a gbí ndeṛè có tí nò náa yí ꞌdè ta có ji Pìyétòrò énó máa, «À bè gbí  káa ꞌduù gbaànjé» nò. ");
INSERT INTO ndz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jézù mâ giì caka kò ndâ mbe tala có mì wó cee gî, yí giì yuu ndi wòòkò bòngo mì wó náa yí ja gí to nó mítí wó kákáꞌi. Bìndi  yí giì dele ndi wó gítí i-zó-zò, bìndi  yí giì ꞌvee ndâ mbe tala có mì wó máa, «Yo ꞌdi gbí i tí nò náa ye bàkà ji yo nò gî? ");
INSERT INTO ndz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ndâ ṛè mì yo náa yo gbì mí muu ye a ndâ ṛè sósòꞌô. ꞌBí  a ‹Mbe nìbà i,› bìndi  ꞌbí  a ‹Mbe tí ze.› Ndâ ṛè mì yo sósòꞌô nò gî, lè lá. À dú nò a ye. ");
INSERT INTO ndz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Káa ye tí Mbe nìbà i ji yo, delè tí Mbe tí yo, má caka kò yo gî, gbí  go énó máa, yo delè ꞌví caka kò yo gbí òkò tí yo. ");
INSERT INTO ndz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ye bàkà énò tacó wàa yo ꞌví mèlè ndí . ");
INSERT INTO ndz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ye kû ꞌdè có ji yo ta yúcó, máa: ꞌbí bòò jé mbe me gbolò ndii mbe tí wó gî nò wálá, delè ꞌbí ꞌviì-tú jé mbe me gbolò ndii mbe tuu yí gî nò wálá. ");
INSERT INTO ndz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","À má énò, yo má ꞌdi gbí ndâ có mì ye nò gî, bìndi  yo ꞌví mèlè bà bàkà ndâ i tí nò náa ye ꞌdeke ndú ji yo nò, tàkòcò yo bà peteke ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Ye kû ꞌdè có mì ye nò me ji yo ꞌdáá gî lá. Ye ŋò ndâ ꞌduù ŋìnó náa ye ṛuka ndú nó ni gî. Káa kózò tí có tí nó náa à cu mí gbí wáràgà mì Mbíṛì énó máa, ‹ꞌDuù tí nó náa ze zò i gbí káꞌi ta yí nó bà ꞌvìsì muu wó gítí ye› nó ꞌví dù tí  tí yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ye kû ci nò a yo, tacó wàa i tí nò má giì bàkà tí, yo ꞌví ŋò tí  ni go énó máa, ye a yí tí Bìndi-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ye kû ꞌdè có ji yo ta yúcó, máa: ꞌDuù má te wiṛi mítí ꞌduù ŋìnó náa a ye ká tuu yí nó, ꞌduù tí nò te wiṛi a i mítí ye. Káa ꞌduù má te wiṛi mítí ye, yí te nò a wiṛi mítí mbe tuu ye.» ");
INSERT INTO ndz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mâ giì zekeꞌo, njembí Jézù giì ꞌbìtà bà dòmò tí bìndi có tí nò náa yí ꞌdè ji ndâ mbe tala có mì wó nò tí vò ŋa ŋìnô. Bìndi  yí giì ꞌdè có ji ndú máa, «Ye kû ꞌdè ji yo a cèe yúcó máa, ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí yo bà giì ba ngbù ye.» ");
INSERT INTO ndz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ndâ mbe tala có mì Jézù mâ giì ꞌdi có tí nò, nje ndú ꞌdáá gî giì ꞌdèè gî. Ndú bà-i-nò giì ꞌbìtà bà zeke gbí njìṛo ndú gbí òkò tí ndú tacó bà ŋò ꞌduù tí nó gbí òkò tí ndú náa Jézù ꞌdè có tí nò gítí wó nô. ");
INSERT INTO ndz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ta o tí nò, ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ mbe tala có mì Jézù náa Jézù zè yí nìkì kpolo ma kû ki tí wó a dê ṛègbà tí Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mâ giì zekeꞌo, Pìyétòrò giì kì ṛo wó ji ka ndú tí nò, máa, yí ꞌvee ṛè ꞌduù tí nò náa Mbe tí ndâ yì kû gbì tì kpô gítí wó nò. ");
INSERT INTO ndz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ka ndâ Pìyétòrò nò bà-i-nò giì tì tí wó mí gbí njembí Jézù, bìndi  yí giì ꞌvee yí máa, «Wò kû nì a ꞌdi, Mbe tí ze?» ");
INSERT INTO ndz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Káa Jézù giì ꞌvìsì có gí tàkò ꞌvé mì mbe tala có mì wó nò, máa, «A ꞌduù tí nó náa ye kpónó bà too yâ ta kô, bìndi  ye ꞌví je ji yí nô.» Jézù ngé bà-i-nò giì kùtù kô, bìndi  yí giì too ta yâ, bìndi  yí giì je ji Júdà tí ꞌviì mì Sìmónè Ìsìkàrìyótè. ");
INSERT INTO ndz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","À káa póó bà je kô tí nò mì Júdà ꞌdo ꞌbì Jézù, Gba-vò-i giì gèè bè wó mí muu Júdà gî. Bìndi  Jézù giì ꞌdè có ji Júdà máa, «Ngoꞌve tí lo! Bàkà i tí nò ta go bà bàkà  tí lo nò gálá.» ");
INSERT INTO ndz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Káa ta o tí nó, ꞌbí ꞌduù gbaànjé gbí òkò tí ndâ mbe tala có mì Jézù mbe ꞌdi gbí ndeṛè có tí nò náa yí ꞌdè ji Júdà nò wálá. ");
INSERT INTO ndz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ndâ ꞌbí ꞌduù gbí òkò tí ndú giì ꞌbìtà bà koṛo có máa, Jézù kû ꞌdè a có ji Júdà máa, yí ya gí bà sì ndâ i ji ndâ yì gítí gbolò o, káa à má me énó lá, yí kû tuu a yí, máa, yí ya gí bà sì ndâ i tacó tí ndâ mbe yê. Ndú koṛo ŋa có tí nò tacó Júdà a mbe kpolo tí ndâ i mì ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Júdà zèè káa kô tí nò náa Jézù too ta yâ ji yí nò ꞌdo ꞌbì Jézù gî, bìndi  yí ngé giì co gí sè ta bèbìlì tí nò. ");
INSERT INTO ndz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Júdà mâ giì njè nó gî, Jézù giì ꞌdè có ji sè ndâ mbe tala có mì wó máa, «Ŋìnó kpónó a o bà giì ùlù ꞌViì-mì-ꞌDakò ká nô; ŋìnó kpónó delè a o bà ùlù Mbíṛì mì ꞌViì-mì-ꞌDakò ká nô. ");
INSERT INTO ndz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ꞌViì-mì-ꞌDakò má giì ùlù Mbíṛì gî, Mbíṛì delè bà giì ùlù ꞌViì-mì-ꞌDakò ta njembí wó gbaànjé; Mbíṛì kpónó-kpónó kèjì gí bà ùlù ꞌViì-mì-ꞌDakò. ");
INSERT INTO ndz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sè o bà dù ye ta yo me njíꞌdí gî, ndâ ꞌviì mì ye. Yo bà giì pà bà tí ye, káa wotí bà ya gítí bàndò tí nó náa ye kû ya gítí  nó bà dù tí yo ta kpéétí yo wálá, ká go có tí nó táánò sàà náa ye ꞌdè ji ndâ Jùdéyà nô. ");
INSERT INTO ndz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ye kû ꞌdè ngú có ji yo, máa, yo zè tí yo gbí òkò tí yo nìkì maa, tacó ye zè yo nìkì ma. Má énò, yo zè tí yo gbí òkò tí yo nìkì maa, á go bà zè yo mì ye nìkì maa nò. ");
INSERT INTO ndz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ndâ ꞌduù bà ŋò yo ni tí ndâ mbe tala có mì ye á ꞌdo tí bà zè tí yo gbí òkò tí yo nìkì maa.» ");
INSERT INTO ndz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mâ giì zekeꞌo, Sìmónè Pìyétòrò bà-i-nò giì ꞌvee Jézù máa, «Wò kû ya gí kòtí ꞌdi, Mbe tí ye?» Káa Jézù giì ꞌvìsì có ji Pìyétòrò máa, «Wotí bà ṛu ndi ye gítí bàndò tí nò náa ye kû ya gítí  nò kpónó tí lo wálá. Wò bà ṛu ndi ye a i bìndi .» ");
INSERT INTO ndz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Káa Pìyétòrò kákáꞌi giì ꞌvee Jézù máa, «Wotí bà ṛu ndi lo tí ye kpónó wálá tacó yè? Ye bà sì miṛi ye ji ku á tacó tí lo.» ");
INSERT INTO ndz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jézù bà-i-nò giì ꞌvee Pìyétòrò máa, «Wò bà sì miṛi lo ji ku á muu ye? Ye kû ꞌdè ji wò a cèe yúcó mì ye máa, wò wúnó bà ꞌboo bà ŋò ye ni mì lo ta bà  taꞌô á kùṛo kpédélé kò ngùù.» ");
INSERT INTO ndz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jézù giì tò làmbu ꞌdê ngo mí njembí ndâ mbe tala có mì wó á bìndi bà kaṛa ṛé ndú mì wó ta ṛè bà ya yí ꞌdo tí ndú gî nó, ta bà yìì ndú máa, «Njembí yo ꞌví mù gítí có bà ya ye nò lá. Yo tee njembí yo mítí ze ta Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tacó yê bàndò bà dù ndâ ꞌduù tí  á ꞌbá mì Bu ye wálá. Yê bàndò kùtàá má kuu ꞌbá mì Bu ye, ye bà ci yo énó máa, ye kû ya gí bà ꞌviindi bàndò ù ta ndi yo nò, wálá. ");
INSERT INTO ndz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ye má cee ta nèté bà ꞌviindi bàndò ù ta ndi yo gî, ye bà dele ndi ye gì tacó bà kaa yo ya tí  gítí . Tacó wàa, ndoo ꞌví dù ta ndoo á tí gbèe bàndò. ");
INSERT INTO ndz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yo ŋò kpokèjì bà ya gítí to tí nò náa ye kû ya gítí  nò ni gî.» ");
INSERT INTO ndz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Káa Tòmázò, tí ꞌbí mbe tala có mì Jézù gbaànjé, giì ꞌvee yí máa, «Ze ŋò ni lá nó káa bàndò tí nò náa wò kû ya gítí  nò nó, ze bà giì ŋò jé káa kpokèjì bà ya gítí , Mbe tí ze?» ");
INSERT INTO ndz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Káa Jézù giì ꞌvìsì có ji yí máa, «Ye a mbe tùbà kpokèjì mì Mbíṛì ji ndâ ꞌduù; ye a mbe ꞌdè yúcó ji ndâ ꞌduù; ye a ṛèngbó ꞌválá ŋìnó mbe cee lá nô. ꞌDuù má waa to co tí ꞌbí tende kpokèjì, yí bà di mì Bu ye wálá. ");
INSERT INTO ndz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yo kùtàá má ŋò ye ni gî, yo delè bà ŋò Bu ye ni gî. Káa yo bà ŋò yí ni ꞌdo tí kpónó gî. Yo delè ŋò yí ta ṛo yo gî.» ");
INSERT INTO ndz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fìlípò bà-i-nò giì ꞌvìsì có ji Jézù máa, «Tùbà tí Bu lo ji ze, wàa có mì ze ꞌví cee gî.» ");
INSERT INTO ndz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Káa Jézù giì ꞌvee Fìlípò máa, «Cèe kôndi bà dù ndà ta ndà nó, wò jé nô ŋò ye ni lá, Fìlípò? ꞌDuù má ŋò ye ni gî, ꞌduù tí nò ŋò nò a Bu ye ni gî. Káa wò giì ꞌdeke tí lo ŋìnó ji ye máa, ye tùbà tí Bu ye ji wò, tacó yè? ");
INSERT INTO ndz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wò ùnje lá, máa, ze ta Bu ye a ndâ gbèe ꞌduù? Ndâ có tí nó náa ye kû ꞌdè ji yo nó me ndâ ꞌdóó có mì ye gbí muu ye lá. A Bu ye tí nó tí mbe tuu ye nó ká kû ꞌdè có. A yí tí Bu ye tí nó náa ze ta yí nje bá gbaànjé nó ká kû bàkà ndâ nèté mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yo ùnje gítí có tí nó náa ye ꞌdè ji yo máa, ꞌbè gbí òkò tí ze ta Bu ye wálá nô. Káa ndâ có mì ye má kû cà gbí tù yo cá-cà, yo ꞌví ùnje ta vòó ṛè mì ndâ seṛè tí nó náa ye kû bàkà nô. ");
INSERT INTO ndz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ꞌDuù mbe tee njembí wó mítí ye ta o ꞌdáá gî gî, bà bàkà ndâ kpo-kpò seṛè go ndâ ŋìnó náa ye kû bàkà nó gî, yí delè bà bàkà a ndâ kpo-kpò i mbe ndii ndâ ŋìnó náa ye kû bàkà nó gî, tacó ye kû ya gí mì Bu ye; ");
INSERT INTO ndz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","tacó énò, yo má yù ꞌbí ŋa i ta ṛe ye ꞌdo mì Bu ye, ye bà je i tí nò ji yo gî. Tacó wàa, ndâ ꞌduù ꞌví ùlù ta Bu ye ꞌdo gbí có mì ye tí ꞌViì mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yo má yù i ta ṛè ye, ye bà je i tí nò ji yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yo má zè ye nìkì maa, yo bà kpolo tí ndâ có mì ye gî. ");
INSERT INTO ndz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ye bà ꞌdeke tí ye ji Bu ye, wàa yí ꞌví tuu ꞌbí ꞌduù ji yo tí mbe kpo-gbí-tà-tù yo, náa yí bà dù ta yo dúú bà ya tí  gî. ");
INSERT INTO ndz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ꞌDuù tí nò náa Bu ye bà tuu yí ji yo tí mbe konì yo nò a Bèṛi-mì-Mbíṛì, tí mbe ꞌdè yúcó. Ndâ ꞌduù muu to tí nó bà ùnje gítí wó wálá, tacó ndú jé gí bà ŋò yí ni wálá, ndú delè je gí bà ŋò yí ta ṛo ndú wálá. Káa yo bà ŋò yí ni gî, tacó yí kèjì gí bà dù ta yo gbí njembí yo. ");
INSERT INTO ndz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ye bà si yo ꞌví jìꞌvì njò wálá. Ye bà dele ndi ye gì gí mì yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sè  ká njíꞌdí, bìndi  ndâ ꞌduù bà giì ŋò ye wálá. Káa yo bà ŋò ye gî, tacó ku me ndòngbú i ji ye lá. À má énò, ku delè bà dù me ndòngbú i ji yo lá. ");
INSERT INTO ndz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yo ta ṛi tí nò bà ŋò ni gî máa, ze ta Bu ye a ndâ gbèe ꞌduù. Káa ndoo ta ndoo delè a ndâ gbèe ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ꞌDuù mbe ꞌdi ndâ có mì ye, bìndi  yí giì kpolo tí ndú gî, a mbe zè ye nìkì maa. Káa ꞌduù mbe zè ye nìkì maa, Bu ye bà zè yí nìkì maa. Ye delè bà zè yí nìkì maa. Ye delè bà ꞌdè gbí tí ye ji yí.» ");
INSERT INTO ndz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mâ giì zekeꞌo, ꞌbí mbe tala có mì Jézù ta ṛè wó a Júdà, me Júdà ŋìnó tí Júdà Ìsìkàrìyótè nò lá, giì ꞌvee Jézù máa, «Wò bà tùbà tí lo ji ze ta bà muu ze nó, si sè ndâ ꞌbí ꞌduù mí to, ta ŋa kpokèjì ngàyi, Mbe tí ze?» ");
INSERT INTO ndz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Káa Jézù giì ꞌvìsì có ji Júdà tí nò máa, «ꞌDuù má zè ye nìkì maa, yí bà kpolo tí ndâ có mì ye gî. Káa ꞌduù má kpolo tí ndâ có mì ye gî, Bu ye bà zè yí nìkì maa. Ze ta Bu ye bà gì gí bà sì ꞌbá ngbé mí mì ze ta ndú. ");
INSERT INTO ndz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ndâ mbe zè ye nìkì lá, kpolo tí ndâ có mì ye lá. Káa ndâ có tí nò náa ye kû ꞌdè nò me ndâ có mì ye lá. Ndú a ndâ có mì Bu ye, tí mbe tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ye kû ꞌdè ndâ có tí nò ji yo kpónó si ndoo a kuu ta ndoo nô. ");
INSERT INTO ndz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Káa a Bèṛi tí nó náa Bu ye ba giì tuu yí ji yo, tí mbe kpo-gbí-tà-tù yo ta ṛè ye nó ká bà gì gí bà nìbà ndâ i ꞌdáá gî ji yo. A yí delè ká bà gì gí bà ꞌva mbí yo gítí ndâ có ŋìnó náa ye ꞌdè ji yo ꞌdáá gî nô. ");
INSERT INTO ndz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yo dù ta ꞌdê njembí yo. Ye bà je ŋa ꞌdê njembí tí nó mì ye nó ji yo. Ye kû je ji yo me go bà je i ji yo mì ndâ ꞌduù lá. À má énò, yo ꞌví si njembí yo ꞌví mù lá. ");
INSERT INTO ndz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yo ꞌdi ꞌdo gbí nje ye ta tù yo énó máa, ye kû giì ya gî, wàa ye ꞌví giì dele ndi ye nò gî. À má énò, yo kùtàá má a ndâ ꞌduù mbe zè ye nìkì maa, líkíꞌo bà ꞌdi énó máa, ye kû ya gí mì Bu ye nò, bà bàkà yo ngé. Tacó Bu ye a gbolò ꞌduù ndii ye gî. ");
INSERT INTO ndz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ye kû ci nó a yo kùṛo bà bàkà tí mì i tí nò. Tacó wàa à má giì bàkà tí, yo ꞌví ù ta nje gítí . ");
INSERT INTO ndz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","O mì ye tacó bà dù kû ꞌdè có kpòò ji yo wálá, tacó Gba-to-tí-nó kèjì. À kpêtí ká énò, wotí mì wó gítí ye wálá. ");
INSERT INTO ndz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Káa ye kû bàkà go có tí nó náa Bu ye ꞌdè ji ye nô. Tacó wàa ndâ ꞌduù ꞌví ŋò tí  ni énó máa, ye zè Bu ye nìkì maa. Tacó ye delè kû bàkà ndírí ká go có tí nó náa yí ꞌdè ji ye nô. «Nògí, yo a gí yaà wàa ndoo ꞌví nje nó ꞌdo bà-i-nó gî! ");
INSERT INTO ndz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Ye a cèe bè nèbítì, káa Bu ye a cèe mbe ṛò njí nèbítì. ");
INSERT INTO ndz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yí kû saaka ndâ nèꞌbì ye ŋìnó mbe ṛì lá nó ꞌdáá gî gí ꞌdè, bìndi  yí giì waaka gàna tí ndâ bèꞌi á ꞌdo tí ndâ ŋìnó mbe ṛi gî nó gî, si ndú ngbáṛángàꞌi, tacó wàa ndú ꞌví ṛì túkàꞌi. ");
INSERT INTO ndz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yo kpónó a ndâ ngbáṛángà ꞌduù; ndâ có mì ye náa ye ꞌdè ji yo nó bàkà yo tí ndâ ngbáṛángà ꞌduù sàà gî. ");
INSERT INTO ndz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yo zèè ye tí kpoò, wàa ye delè ꞌví zèè ta yo tí kpoò. Yo ŋò ni gî máa, nèꞌbì mû ŋìnó mbe yaka ꞌdo tí kpo ṛèngbó mû gî nó jé ṛì mí to kà ta kpéétí wó lá, sè  káa ŋìnó yí má ká kuu tí kpo ṛèngbó mû. Yo delè ká énò, yo má ta kpéétí yo, gbí có mì yo bà dù wálá, sè  káa ŋìnó yo má zèè ye tí kpoò. ");
INSERT INTO ndz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ye a ꞌdóó kpo ṛèngbó bè nèbítì, káa yo a ndâ nèꞌbì bè nèbítì tí nò. À má énò, ꞌbí ꞌduù gbí òkò tí yo má zèè ye tí kpoò, wàa ye ꞌví zèè yí tí kpoò, a ꞌduù tí nò ká bà bàkà tó i túkàꞌi, tacó yo má mò tí yo ꞌdo tí ye gî, yo gí bà bàkà i gbaànjé wálá. ");
INSERT INTO ndz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ꞌDuù ŋìnó mbe zèè ye tí kpoò lá nó, go nèꞌbì mû ŋìnó náa à da ꞌdo tí kpo ṛèngbó mû gí ꞌdè gî nô. Ndâ ŋa ndâ nèꞌbì mû tí nò náa à kû saaka ndú ꞌdo tí kpo ṛèngbó mû gî nò má aanga gî, à kû kili ndú, bìndi  à giì doo ndú ta wu. ");
INSERT INTO ndz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yo má zèè ye tí kpoò, wàa ndâ có mì ye ꞌví dù gbí njembí yo, yo má yù i ŋìnó ta go  tí yo nó ꞌdo mì Mbíṛì, Mbíṛì bà je ji yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ndâ ꞌduù kû ùlù ṛè Bu ye ta o tí nó náa yo má kû bàkà tó i, tacó bà tùbà tí yo máa, yo a ndâ mbe tala có mì ye nô. ");
INSERT INTO ndz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ye kû zè yo nìkì ká go bà zè ye nìkì mì Bu ye. À má énò, yo ꞌví ne ꞌdo tí ye lá. ");
INSERT INTO ndz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yo má ꞌdi ndâ có mì ye gî, ye bà zè yo nìkì maa, á go ŋìnó náa ye kû ꞌdi có mì Bu ye, káa yí kû zè ye nìkì maa nô. ");
INSERT INTO ndz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ye ꞌdè ndâ có tí nò ji yo, tacó wàa ŋa líkíꞌo tí nó á tí ye nó ꞌví dù tí yo, delè tacó wàa ŋa líkíꞌo tí nò ꞌví dù tí yo ta ŋa  wálá. ");
INSERT INTO ndz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Có mì ye ji yo énó máa, yo ꞌví zè tí yo gbí òkò tí yo nìkì maa, á go ŋìnó náa ye kû zè ta yo nìkì maa nô. ");
INSERT INTO ndz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ꞌDuù má ùnje gítí bà cì á muu ndâ kómbe wó, gbí  énó máa, yí zè ndâ kómbe wó tí nò nìkì ta ŋa  wálá. ");
INSERT INTO ndz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yo má bàkà go ndâ có mì ye nò gî, yo bà dù tí ndâ kómbe ye. ");
INSERT INTO ndz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ye kákáꞌi bà nì bòò mítí yo wálá, tacó ꞌduù ꞌdè ndâ có kóó mì wó ji bòò mì wó lá. Ṛè yo a ndâ kómbe ye, tacó ye ꞌdè gbí ndâ có ŋìnó náa ye ꞌdi ꞌdo mì Bu ye nó ꞌdáá gî ji yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","À me yo táánò ká gì gí mì ye ta muu yo lá. A ye táánò ká ṛuka yo máa, yo dù tí ndâ kómbe ye, bìndi  ye giì bàkà yo tí ndâ ꞌduù mbe bàkà ndâ i ŋìnó ta i ká gbí ndú, tí ŋa ndâ i ŋìnó mbe dù tí ká nó, tacó wàa, Bu ye ꞌví je ta ndâ i ŋìnó náa yo yù ꞌdo tí wó ta ṛè ye nó ꞌdáá gî ji yo. ");
INSERT INTO ndz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ye ꞌdè ndâ có tí nò ji yo tacó wàa, yo ꞌví zè ta tí yo gbí òkò tí yo nìkì maa. ");
INSERT INTO ndz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Ndâ ꞌduù má kû sogo yo, yo ꞌví te mí gbí muu yo énó máa, a ngú i nò lá. Ndú táánò sogo ye kùṛo bà sogo yo mì ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yo kùtàá má a ndâ ꞌduù mì ndâ ꞌduù muu to tí nó, ndú kùtàá bà zè yo nìkì maa, tacó yo a ndâ ꞌdóó ndâ ŋìnó mì ndú. Káa yo me ndâ ꞌduù mì ndâ ꞌduù muu to tí nó lá, tacó ye ṛuka yo tí ndâ ꞌduù mì ye gî. Tacó énò, ndâ ꞌduù kû sogo yo. ");
INSERT INTO ndz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nògí, yo je mbí yo mítí ndâ có tí nó táánò náa ye ꞌdè ji yo énó máa, bòò me gbolò ndii mbe tí wó lá nô. Ndú táánò má mèèkèꞌi tí ye gî, ndú delè bà mèèkèꞌi tí yo gî. Ndú táánò má ꞌdi có mì ye gî, ndú delè bà ꞌdi có mì yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Káa ndú bà mèèkèꞌi tí yo á muu ye, tacó ndú ŋò mbe tuu ye ni lá. ");
INSERT INTO ndz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ye táánò má gì lá, ye táánò delè má ꞌdè có ji ndú lá, Mbíṛì bà tù ꞌbì wó gí tà ṛo ndú máa, ndú a mbe bàkà vò i nò, wálá. Káa kpokèjì bà kììꞌbà mì ndú kpónó nè gî, tacó ye gì gî, tacó ye delè ꞌdè có ji ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ꞌDuù má kû sogo ye, yí kû sogo nò a Bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ye táánò má bàkà ŋa ndâ kpo-kpò seṛè tí nó náa ꞌbí ꞌduù jé bàkà sàà kùṛo lá nó mí gbí òkò tí ndú lá, Mbíṛì bà ꞌdè có gítí ndú wálá. Káa ndú ŋò ndâ i tí nó táánò náa ye bàkà nó gî, káa ndú kpòò kû sogo ye, ndú delè kû sogo Bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Si ndú ꞌví bàkà énò, tacó wàa có tí nó náa à cu mí gbí wáràgà mì ndâ muu-cè máa, ‹Ndú táánò sogo ye ta ndeṛè tí  wálá,› nó ꞌví dù tí  tí yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ta o tí nó náa mbe kpo-gbí-tà-tù yo tí nó náa ye bà tuu yí ꞌdo mì Bu ye, tí Bèṛi mbe kû co tí kpokèjì mì yúcó, náa ṛèngbó wó ꞌdo tí Bu ye nó, bà gì nó, yí bà dù tí mbe ma có tí ye. ");
INSERT INTO ndz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yo delè bà dù tí ndâ mbe ma có tí ye, tacó yo dù ta ye ꞌdo tí bà ꞌbìtà nèté mì ye yee tí kpónó. ");
INSERT INTO ndz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Ye ꞌdè ndâ có tí nò ꞌdáá gî ji yo tacó wàa, njembí yo wúnò ꞌví mù tí  gítí ndâ i yê ṛo tí nò náa ndâ ꞌduù kèjì gí bà bàkà mítí yo nò lá. ");
INSERT INTO ndz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ndâ ꞌduù bà giì mòkò yo ꞌdo gbí òkò tí ndâ ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì gî. Káa yo ꞌví te mí gbí muu yo me káa ŋìnò cuki lá. Yo te mí gbí muu yo delè énó máa, ꞌbí o wúnò ká kèjì náa ndâ mbe kû ziki yo ta o tí nò bà koṛo có énó máa, ndâ yì kû bàkà a nèté mì ndâ yì kùṛo Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ndú bà bàkà ŋa i tí nò, tacó ndú jé ŋò ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ze ta Bu ye ni lá. ");
INSERT INTO ndz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","À má énò, ye kpónó kû kpo nó a gbí-tà-tù yo, tacó wàa, o bà mèèkèꞌi tí yo nò má gì wúnò, mbí yo ꞌví ꞌva tí  énó máa, ye táánò ci yo gítí  sàà kùṛo gî. «Ye táánò ꞌdè ndâ có tí nò ji yo sàà lá, tacó ndoo kû dù ta ndoo bà gbèe to. ");
INSERT INTO ndz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Káa ye kpónó kû giì ya gí mì ꞌduù tí nó táánò mbe tuu ye nô. Ta ndâ ŋa ŋìnò ꞌdáá gî, ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí yo mbe ꞌvee ye kpónó énó máa, ‹Wò kû ya gí kòtí ꞌdi wè?› nò wálá. ");
INSERT INTO ndz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Káa njembí yo kpónó wálá ta sé có tí nò náa ye ꞌdè ji yo nò. ");
INSERT INTO ndz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Káa ye bà ngùù yúcó ꞌdo tí yo wálá: ye kû ya nó tí nò kpolo ma a i tacó tí yo, tacó ye má ya lá, mbe kpo-gbí-tà-tù yo tí nò bà gì wálá. Káa ye má ya gî, ye bà tuu yí gì tí  ji yo. ");
INSERT INTO ndz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yí má gì gî, a yí ká bà ꞌdè có ŋìnó mbe ya gí gbí muu ndâ ꞌduù gítí ndâ vò i, ta ꞌduù ŋìnó mbe ya jáá nó, ta bà waa có mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yí kèjì gí bà ꞌdè có ŋìnó mbe ya gí gbí muu ndâ ꞌduù gítí vò i, máa, bà biya bà ùnje gítí ye mì ndú a vò i. ");
INSERT INTO ndz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yí kèjì gí bà ꞌdè có ŋìnó mbe ya gí gbí muu ndâ ꞌduù gítí ꞌduù ŋìnó mbe ya jáá nó delè a i mítí bà ya ye gí mì Bu ye, bìndi  yo bà ŋò ndi ye wálá. ");
INSERT INTO ndz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yí kèjì gí bà ꞌdè có ŋìnó mbe ya gí gbí muu ndâ ꞌduù gítí bà waa có mì Mbíṛì, tacó Mbíṛì waa có mítí Gba-to-tí-nó. ");
INSERT INTO ndz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ndâ có gbí muu ye tacó bà ꞌdè ji yo tanga tí lá, káa wotí tí yo bà dù gítí bà ꞌdi gbí ndú kpónó wálá. ");
INSERT INTO ndz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","À má énò, Bèṛi-mì-Mbíṛì, tí mbe kû co tí kpokèjì mì yúcó má gì gî, a yí ká bà tè kùṛo yo co tí kpokèjì mì yúcó. Tacó yí bà gì gí bà ꞌdè me ꞌdóó có mì wó gbí muu wó lá. Yí bà gì gí bà ꞌdè ji yo káa ndâ có ŋìnó náa yí ꞌdi nô. Yí bà gì gí bà ma có ndâ i ŋìnó kèjì nô. ");
INSERT INTO ndz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yí kèjì gí bà wu gbí ye ji yo, tacó yí bà gì gí bà ꞌdè ji yo ꞌdáá káa ndâ có ŋìnó náa yí ꞌdi ꞌdo mì ye nô. ");
INSERT INTO ndz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ndâ có gbí muu Bu ye ꞌdáá gî káa ndâ có tí nò gbí muu ye nô. Ŋìnò a gbí ndeṛè có tí nò náa ye ꞌdè tí  ta có ji yo énó máa, yí bà gì gí bà ꞌdè ji yo ꞌdáá káa ndâ có mì ye nó ká nò. ");
INSERT INTO ndz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Tacó yo gàà énó kèjì gí bà ŋò ye wálá, yo má giì dù á bìndi bà ya ye ꞌdo tí yo nò ndì-ndì-ndì énó, yo bà giì ŋò ndi ye kákáꞌi.» ");
INSERT INTO ndz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ndâ ꞌbí mbe tala có mì Jézù mâ giì ꞌdi có tí nò náa yí ꞌdè ji ndú nò, ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú máa, «Gbí ŋa có mì wó náa yí ꞌdè énó máa, ndoo gàà énó kèjì gí bà ŋò yì wálá, má njíꞌdí kózò gî, ndoo bà giì ŋò ndi yì nò, máa yè? Gbí có tí nò mì wó, máa, yì kû ya gí mì Bu yì nò, máa yè? ");
INSERT INTO ndz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","O tí nò mì wó ‹gàà› nò a o yè? Ndoo ꞌdi gbí o tí nò mì wó ‹gàà› nò lá.» ");
INSERT INTO ndz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Káa Jézù giì ŋò ni gî máa, à tí ndú a go bà ꞌvee yì, tacó énò, yí giì cu kùṛo bà ꞌvee yí mì ndú ta bà ꞌvee ndú máa, «Yo kû ꞌvee ꞌvé gbí òkò tí yo nò a i gítí gbí có tí nó náa ye ꞌdè énó máa, ‹Yo gàà énó bà giì ŋò ye wálá, yo mâ giì dù ndì-ndì-ndì énó gî, yo bà giì ŋò ndi ye kákáꞌi nó?› ");
INSERT INTO ndz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ye kû ꞌdè có ji yo ta yúcó máa, yo bà giì wa ku ta ngo-ṛo yo, káa ndâ ꞌbí ꞌduù ta líkíꞌo tí ndú. Nje yo bà giì zuu , káa bà zuu nje yo nò bá ꞌvìsì tí tí líkíꞌo. ");
INSERT INTO ndz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Niì kû tu nje wó ta o bà mi ꞌviì, tacó yí gbí séꞌi, káa ꞌviì mâ giì tè gî, bà mbí niì tí nò giì ò tí sé gó-káyì gî ta líkíꞌo máa, yì jò ꞌduù mí muu to gî. ");
INSERT INTO ndz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nògí, yo kpónó kû zuu nje yo á go bà zuu nje mbe gó-káyì. Káa tàkòcò yo bà giì peteke gî, tacó ndoo bà ꞌde tí ndoo ta ndoo kákáꞌi gî. ꞌBí ꞌduù mbe volo gbí líkíꞌo tí nò náa ye bà je ji yo nò, bà dù wálá. ");
INSERT INTO ndz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","O tí nò má gì gî, yo bà ꞌvee ye gítí ꞌbí i gbaànjé wálá. Ye kû ꞌdè có ji yo ta yúcó máa, Bu ye ta o tí nò bà je ŋa i ŋìnó náa yo bà yù ꞌdo tí wó ta ṛè ye nó ji yo gî. ");
INSERT INTO ndz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yo yee tí kpónó jé yù i ꞌdo mì Bu ye ta ṛè ye lá. Má énò, yo ꞌbìtà bà yù i ta ṛè ye á ꞌdo tí kpónó, wàa yí bà je ji yo gî. Tacó wàa yo ꞌví dù ta líkíꞌo tí yo ta ꞌbí i mbe gboo ꞌdo mì yo wálá. ");
INSERT INTO ndz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ye yee tí kpónó kû ꞌdè có tí nò ji yo ká ta ndâ kpùṛù có. Káa o tí nò náa ye kákáꞌi bà ꞌdè ndâ kpùṛù có ji yo wálá nò, ká kèjì. Ye ta o tí nò bà ꞌdè có gítí Bu ye ngbáṛángàꞌi énó ji yo. ");
INSERT INTO ndz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta o tí nò, yo bà giì yù ndâ i ꞌdo mì Bu ye ta ṛè ye. À kákáꞌi me ye ká bà ꞌdeke tí ye ji Bu ye tacó tí yo lá, ");
INSERT INTO ndz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tacó Bu ye zè yo nìkì ta ṛè ye ma. Bu ye zè yo nìkì maa nò, tacó yo zè ye nìkì maa. Yo delè giì ùnje gî máa, ye táánò gì ꞌdo mì wó tí Bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ye táánò gì gí muu to tí nó ꞌdo mì Bu ye. Káa ye kpónó kû dele ndi ye ya gí mì Bu ye.» ");
INSERT INTO ndz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ndâ mbe tala có mì Jézù bà-i-nò giì ꞌvìsì có ji yí máa, «Ìyo le! Wò kpónó kû ꞌdè gbí có ji ze ngbáṛángàꞌi. Wò kû ꞌdè me kpùṛù có lá. ");
INSERT INTO ndz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ze kpónó ŋò ni ngbáṛángàꞌi gî, máa, wò ŋò ndâ i ꞌdáá gî ni gî. À má énò, gbí ndeṛè bà ꞌvee wò mì ꞌbí ꞌduù gbí òkò tí ze máa, wò gì ꞌdo kòtí ꞌdi wè nò wálá. Tacó ze kpónó ùnje ta njembí ze gî, máa, wò gì ꞌdo mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Káa Jézù giì ꞌvee ndú máa, «Yo ùnje ta njembí yo gítí ye gî? ");
INSERT INTO ndz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yo ꞌdi có tí nó náa ye kû ꞌdè ji yo nô: O bà nje gbí yo vóró-voro gî ká kèjì. O bà ꞌvaaka yo ꞌdo tí ye gbaànjé-gbaànjé ya gítí ndâ ꞌdóó bàndò mì yo si ye ta kpéétí ye, gì sàà gî. Káa à kpêtí ká énò, ye bà dù me ta kpéétí ye lá. Ze bà dù ta Bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ye ꞌdè ndâ có tí nò ji yo tacó wàa, yo ꞌví dù nìkì maa ta ṛè ye. Ndâ vò i bà ꞌde yo muu to tí nó me gbolò, káa yo ꞌví zèè njembí yo, tacó ye kpò muu ndâ vò i muu to tí nó gî.» ");
INSERT INTO ndz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jézù mâ giì cee ta bà ꞌdè ndâ có tí nò ji ndâ mbe tala có mì wó gî, yí giì zekeꞌo gí gbíṛì, bìndi  yí giì ꞌdeke tí wó ji Mbíṛì, máa, «O tí nò gì gî, Bu ye. À má énò, tùbà tí ꞌViì mì lo tí mbe wotí ji ndâ ꞌduù, tacó wàa, ꞌViì mì lo ꞌví tù ta bà tí lo tí mbe wotí ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wò kaa ndâ ꞌduù muu to tí nó ꞌdáá gî mí ꞌbì wó gî. À má énò, si yí ꞌví je ꞌválá ŋìnó mbe cee lá nó ji ndâ ꞌduù tí nò náa wò kaa ndú mí ꞌbì wó nò. ");
INSERT INTO ndz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Káa ṛè i mbe je ꞌválá tí nò mbe cee lá nò a bà ŋò wò ni tí gbèe Mbíṛì dú, giì je bà ŋò Jézù tí Bìndi lo tí Mbíṛì náa wò tuu yí nó ni . ");
INSERT INTO ndz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ye tùbà wotí mì lo ji ndâ ꞌduù muu to tí nó ta bà bàkà nèté tí nó náa wò táánò je ji ye nó, cee gî. ");
INSERT INTO ndz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nògí, te duù Mítí ye kpónó, Bu ye. Te duù mítí ye ta bà si ye ꞌví ki tí ye dèngècè ṛègbà tí lo á go ŋìnó táánò mì ndà á kùṛo o bà suu to tí nó nô. ");
INSERT INTO ndz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ye tùbà tí lo á ji ndâ ꞌduù tí nó náa wò ṛuka ndú ji ye á ꞌdo gbí òkò tí ndâ ꞌduù á muu to tí nó nó gî. Ndú táánò a ndâ ꞌduù mì lo, bìndi  wò giì kaa ndú ji ye, káa ndú giì ꞌdi có mì lo gî. ");
INSERT INTO ndz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ndú kpónó ŋò ni gî máa, ndâ có tí nó ꞌdáá náa wò ꞌdè ji ye nó a ndâ có mì lo. ");
INSERT INTO ndz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tacó ye ꞌdè ndi ndâ có tí nó náa wò táánò ꞌdè ji ye nó ji ndú gî. Ndú delè giì ùnje gî, máa, à dú nò a ndâ có mbe co ꞌdo gbí nje lo. Ndú delè giì ùnje gî, máa, ye táánò gì dú ꞌdo ká mì lo. Ndú delè kákáꞌi giì ùnje gî, máa, à dú káa wò táánò ká tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ye kpónó kû ꞌdeke tí ye ji wò nó a i tacó tí ndú. Ye kû ꞌdeke tí ye ji wò me tacó tí ndâ ꞌduù muu to tí nó ꞌdáá gî lá. Ye kû ꞌdeke tí ye ji wò a i tacó tí ndâ ꞌduù tí nó náa wò táánò kaa ndú ji ye nô. Tacó ndú a ndâ ꞌduù mì lo. ");
INSERT INTO ndz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ndâ ꞌduù mì ye ꞌdáá gî a ndâ ꞌduù mì lo. Ndâ ꞌduù mì lo ꞌdáá gî delè a ndâ ꞌduù mì ye. Ye kû tùbà tí ye ji ndú a i ta ṛè lo. ");
INSERT INTO ndz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tacó a ndú ká bà dù á muu to tí nô. Ye kpónó kèjì gí mì lo. Ye kpòò me ꞌduù ta ṛè muu to tí nó lá. À má énò, kpolo tí ndâ ꞌduù mì lo náa wò ṛuka ndú ji ye nó, ta ṛè mì lo, tacó wàa, có mì ndú gbí òkò tí ndú ꞌví dù ká gbaànjé, á go có mì ndà gbí òkò tí ndà, tó Bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ye táánò kpolo tí ndú si ze ta ndú bà gbèe to nó a i ta ṛè lo, tí ꞌdóó ṛè lo tí nó náa wò táánò gbì mí muu ye nô. Ye táánò kpolo tí ndú ꞌdáá gî tí kpoò. ꞌDuù tí nó gbaànjé gbí òkò tí ndú mbe giṛiꞌo ꞌdo tí kèjì mì lo nó giṛiꞌo ꞌdo ká gbí ꞌdóó vò muu mì wó, á go có tí nó gbí wáràgà mì lo tí Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ye kpónó kèjì gí mì lo, à má énò, ye kû ꞌdè ndâ có tí nò ji ndâ ꞌduù tí nó náa wò táánò ṛuka ndú ji ye muu to tí nó nó, tacó wàa ŋa líkíꞌo tí nó tí ye nó ꞌví dù tí ndú delè. ");
INSERT INTO ndz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ye ꞌdòkò có mì lo táánò náa wò ꞌdè ji ye nó ji ndú gî. Tacó énò, ndâ ꞌduù muu to tí nó kpónó kû sogo ndú, tacó ze ta ndú me ndâ ꞌduù mì ndâ ꞌduù muu to tí nó lá. ");
INSERT INTO ndz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ye kû ꞌdeke tí ye ji wò me énó máa, wò ꞌví kaa ndú ꞌdo muu to tí nó gî nò lá. Gbí ndeṛè bà ꞌdeke tí ye ji wò énó máa, wò ꞌví kpolo tí ndú ꞌdo tí Vò-ꞌduù-tí-nò tí mbe kû eendi ndâ ꞌduù gítí vò i nô. ");
INSERT INTO ndz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tacó ze kpónó ta ndú kákáꞌi me ndâ ꞌduù mì ndâ ꞌduù muu to tí nó lá. ");
INSERT INTO ndz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kaa ndú mò gítí kpokèjì mì yúcó, tacó có mì lo a yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ye kû tuu ndú ta ndi muu to, á go bà tuu ye mì lo á gí muu to tí nô. ");
INSERT INTO ndz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ye kaa tí ye ji wò á tacó tí ndú, tacó wàa ndú delè ꞌví kaa ta tí ndú ji wò ta bà co tí kpokèjì mì yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Káa ye kû ꞌdeke tí ye me ká tacó tí ndú cuki lá. Ye kû ꞌdeke tí ye delè tacó tí ndâ ꞌduù ŋìnó bà giì kaa tí ndú ji ye ꞌdo gbí có mì ndú nô. ");
INSERT INTO ndz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ye kû ꞌdeke tí ye, máa, có mì ndú ꞌví dù ka gbaànjé á go có mì ndà, Bu ye; có gbí njembí lo ká go có gbí njembí ye, bìndi  có gbí njembí ye ká go có gbí njembí lo. Si có mì ndú ꞌví dù ká gbaànjé, tacó wàa, ndâ ꞌduù muu to tí nó ꞌví ŋò tí  ni énó máa, a wò táánò ká tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ye le bèṛè tí nó náa wò le ji ye nó ji ndú gî, Ye le ji ndú tacó wàa, njembí ndú ꞌví dù ká gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ye le ji ndú tacó wàa, njembí ndoo ꞌví dù ká gbaànjé ta ndú. Tacó wàa, ndâ ꞌduù ꞌví ŋò tí  ni énó máa, a wò táánò ká tuu ye; ndâ ꞌduù delè ꞌví ŋò tí  ni énó máa, wò zè ndú nìkì ká go bà zè ye nìkì mì lo. ");
INSERT INTO ndz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Có gbí njembí ye énó máa, wò ꞌví je bàndò ji ndâ ꞌduù tí nó náa wò ṛuka ndú ji ye nó á mí ṛègbà tí ye, tacó wàa, ndú ꞌví ŋò ta bà te duù tí ye mì lo, tacó wò ꞌbìtà bà zè ye nìkì maa si ndà suu to tí nó kálásê, Bu ye. ");
INSERT INTO ndz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Wò a ꞌduù jáá, Bu ye! Sè ndâ ꞌduù muu to tí nó ŋò wò ni lá, káa ye ŋò wò ni gî. Ndâ ꞌduù tí nó náa wò kaa ndú ji ye nó delè ŋò ni gî máa, a wò táánò ká tuu ye. ");
INSERT INTO ndz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ye tùbà tí lo ngbáṛángàꞌi énó ji ndú gî, Bu ye! Ye delè kpónó kpòò kû tùbà tí lo ngbáṛángàꞌi énó ji ndú, tacó wàa, ndú ꞌví zè tí ndú gbí òkò tí ndú nìkì maa, á go bà zè ye mì lo nìkì maa; delè tacó wàa có tí ye ꞌví dù gbí njembí ndú.» ");
INSERT INTO ndz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jézù mâ giì ꞌdeke tí wó ji Mbíṛì cee gî, yí giì kaa sè ndâ mbe tala có mì wó ya tí  gí gbí ꞌbí wúngbó jìlì mbâ náa à ṛò mí tìto ꞌbí pù njáá náa à kû nì tí  a Njáá Kìdòrónì, á bìndi bà njè nó mì Júdà. ");
INSERT INTO ndz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Káa Júdà tí mbe ba ngbù Jézù ŋò bàndò tí nò sàà gî, tacó a bàndò náa ndú ya gítí  ta ndâ Jézù ꞌvílí-ꞌvìlì. ");
INSERT INTO ndz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Tacó énò, yí giì ja ndâ àsìkérì, ta ndâ mbe kpolo tí ꞌbá-Mbíṛì tí nó náa ndâ kpo ꞌduù mì ndâ Jùdéyà kaa ndú ji yí, máa, yí ya ta ndú gí bà zèè Jézù nó, ta ndâ zíꞌi, ta wu nje kùpò ꞌbì ndú, ká ndírí gítí bàndò tí nò. ");
INSERT INTO ndz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jézù mâ giì ŋò ndú kèjì, yí gì co ꞌdo mì ndâ mbe tala có mì wó ya gí kùṛo ndú, tacó yí ŋò ŋa i tí nó náa ndú kèjì gí bà bàkà ta yí nó ni gî. Ndú mâ giì yee tí Jézù gî, Jézù giì ꞌvee ndú máa, «Yo kû pà a bà tí ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Káa ndú giì ꞌvìsì có ji yí máa, «Ze kû pà a bà tí Jézù tí nó mbe gì ꞌdo Názàrètì nô.» Káa Jézù giì ꞌvìsì có ji ndú, si Júdà tí mbe ba ngbù wó kû ṛò tíyò gbí òkò tí ndú, máa, «Ye a yí.» ");
INSERT INTO ndz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Káa ta o tí nó náa Jézù ꞌvìsì ta có ji ndâ ꞌduù tí nò máa, «Ye a yí» nó, ndú giì yèè ndi ndú ꞌdo tí Jézù gí ndiì, bìndi  ndú giì ꞌvaka tí to. ");
INSERT INTO ndz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Káa Jézù giì ꞌvee ndú kákáꞌi máa, «Yo kû pà a bà tí ꞌdi?» Ndú kákáꞌi giì ꞌvìsì có ji Jézù máa, «Ze kû pà a bà tí Jézù tí nó mbe gì ꞌdo Názàrètì nô.» ");
INSERT INTO ndz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Káa Jézù giì ꞌvìsì có ji ndú máa, «Ye kùtàá ꞌdè ji yo gî, máa, ye a yí. Yo má kû pà a ye, yo zèè ye, wàa yo ꞌví si sè ndâ ꞌbí ꞌduù tí nó ꞌví ya .» ");
INSERT INTO ndz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jézù ꞌdè có ji ndâ ꞌduù tí nò mbe gì tacó bà zèè yí nò, máa, ndú si ndâ mbe tala có mì yì ꞌví ya , tacó wàa có tí nó náa yì ꞌdè sàà ji Mbíṛì énó máa, «Ye bà si ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ꞌduù tí nó náa wò kaa ji ye nó ꞌví giṛi lá, Bu ye,» nó ꞌví dù tí  tí yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pìyétòrò mâ giì ŋò ndâ ꞌduù tí nò kû nò ta Jézù nìkì lá, yí bà-i-nò giì ja sìzò mì wó ꞌdo gbí foko, bìndi  yí giì da ta tù ꞌbí ꞌdakò gbí òkò tí ndú ta ṛè wó a Màlíkù, tí bòò mì Kùṛo ndâ bu-Mbíṛì, waa gî. ");
INSERT INTO ndz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Káa Jézù giì do mítí Pìyétòrò máa, «Dele ndi sìzò mì lo nò gí gbí foko! Wò koṛo có énó máa, ye ꞌví kònò séꞌi go có mì Bu ye lá?» ");
INSERT INTO ndz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ndâ ꞌduù tí nó náa ndâ kpo ꞌduù mì ndâ Jùdéyà tuu ndú ta ndâ Júdà gí tàkò Jézù nó giì zèè yí. Ndú mâ giì eṛe yí gî, ");
INSERT INTO ndz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ndú giì ja yí kpédéléꞌi ya tí  a i gí kùṛo Ánà tí ká Kùṛo ndâ bu-Mbíṛì náa ngáángbá gba mì ndâ Ròmánò mò yí ꞌdo gbí nèté gî, ");
INSERT INTO ndz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","bìndi  yí tí ngáángbá gba mì ndâ Ròmánò giì te gê Ánà, tí Kàyífà tí nó tí mbe kpo-gbí-tà-tù ndâ kpo ꞌduù mì ndâ Jùdéyà énó máa, «À nìkì a bà cì ꞌduù gbaànjé á tacó tí mbè ndâ ꞌduù» nó, mí bìndi Ánà. ");
INSERT INTO ndz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ndâ Sìmónè Pìyétòrò, ta ꞌbí ka wó mbe tala có mì Jézù, giì ṛu ndi Jézù yee ꞌbá mì Ánà. Ndú mâ giì yee kà, ka Pìyétòrò nò giì ṛì ká ngé gí gbí ndùgù, tacó ndú ŋò tí ndú ta Ánà ni ngbáṛángàꞌi sàà kùṛo gî. ");
INSERT INTO ndz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bìndi  yí giì ꞌdè có ji niì tí nó mbe kû kpolo tí njekèjì ndùgù nó, máa, yí si Pìyétòrò ꞌví ṛì gí gbí ndùgù, tacó Pìyétòrò gboo ŋìndi wó ká mí sè. ");
INSERT INTO ndz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ta o tí nó si Pìyétòrò kû giì ṛì gí gbí ndùgù nó, niì tí nò giì ꞌvee yí máa, «Wò me ꞌbí mbe tala có mì ꞌdakò tí nó lá?» Káa Pìyétòrò giì ꞌvìsì có ji niì tí nò máa, «Jéé lá! Ye me mbe tala có mì wó lá.» ");
INSERT INTO ndz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ta o tí nò, ndâ mbe bàkà nèté ꞌbá mì Kùṛo ndâ bu-Mbíṛì kû u wu á njewu gbí ndùgù. Tacó énò, Pìyétòrò mâ giì ṛì gí gbí ndùgù gî, yí giì ya kû ṛò tíyò á ṛègbà wu á mì ndú ta ndú, tacó o tí nò a o côꞌo. ");
INSERT INTO ndz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ndâ mbe zèè Jézù mâ giì yee ta yí kùṛo Ánà, Ánà giì ꞌvee gbí nje Jézù gítí ndâ mbe tala có mì wó, ta ndâ bà nìbà i mì wó. ");
INSERT INTO ndz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Káa Jézù giì ꞌvìsì có ji yí máa, «Ye táánò ta o ꞌdáá gî kû ꞌdè có ngbáṛángàꞌi mí kùṛo ndâ ꞌduù ꞌdáá gî. Ye delè táánò kû nìbà i ji ndâ ꞌduù á gbí ndùgù ꞌbá-Mbíṛì, delè ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì. À sósòꞌô nò a ndâ bàndò bà kili ndâ Jùdéyà ꞌdáá gî. Ye jé ꞌdè có mí tà bèngìì lá. ");
INSERT INTO ndz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","À má énò, ꞌvee gbí nje ye lá. ꞌVee ndâ ꞌduù ŋìnó táánò mbe ꞌdi ndâ có mì ye gî nó, wàa ndú ꞌví ꞌvanda ndi ndâ có tí nò ji wò.» ");
INSERT INTO ndz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ꞌBí kùṛo ndâ àsìkérì tí nó mbe kû kpolo tí ꞌbá-Mbíṛì nó mâ giì ꞌdi có tí nò náa Jézù ꞌvìsì ji Ánà nò, yí giì ja ꞌbì wó mí gbí tù Jézù ta kpo tàkòcò. Bìndi  yí giì ꞌvee Jézù máa, «Ŋìnò a cè ŋa bà ꞌvìsì có mì lo ji Kùṛo ndâ bu-Mbíṛì ká nò?» ");
INSERT INTO ndz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Káa Jézù giì ꞌvìsì có ji kùṛo ndâ àsìkérì tí nò mbe gbì gbí tù wó nò máa, «Có tí nò náa ye ꞌdè nò má lè gî, ꞌdè có ji ndâ ꞌduù máa, ye ꞌdè a ꞌvéṛè. Káa ye má ꞌdè a yúcó, gbí ndeṛè bà gbì ye mì lo a yè?» ");
INSERT INTO ndz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ánà mâ giì cee ta bà ꞌvee gbí nje Jézù gî, yí giì tuu yí gbí wú ya tí  ji Kàyífà. ");
INSERT INTO ndz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Káa si ndâ àsìkérì kû giì ya ta Jézù ꞌdo kùṛo Ánà gí kùṛo Kàyífà, ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ ꞌduù tí nó mbe kû u wu ta ndâ Pìyétòrò nó giì ꞌvee yí máa, «Wò me ꞌbí mbe tala có mì ꞌduù tí nó gbaànjé lá?» Káa Pìyétòrò giì tò kponje gî, máa, «Ye me mbe tala có mì wó lá.» ");
INSERT INTO ndz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Bìndi ŋìnò, ꞌbí bòò mì kùṛo mì ndâ bu-Mbíṛì, tí nambe ꞌdakò tí nó náa Pìyétòrò da tù wò waa ta sìzò nó, giì ꞌvee Pìyétòrò máa, «Ye kùtàá ŋò me yo ta yí gbí jìlì mbâ lá?» ");
INSERT INTO ndz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Káa Pìyétòrò giì tò kponje gbí ŋìnò ká jé ꞌvii ta bà kò-kò mì ngùù. ");
INSERT INTO ndz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kàyífà mâ giì ꞌviiki gbí có mì Jézù cee gî, yí giì je yí ta fírí dúꞌo ji ndâ àsìkérì, máa, ndú ya ta yí ji Pìlátò, tí gbolò ꞌduù mì ndâ Ròmánò ta wotí bà waa có ku mítí ndâ ꞌduù tí wó. Ndâ kpo ꞌduù mì ndâ Jùdéyà tí nó mbe ko tàkò Jézù ya tí  gí ꞌbá mì Pìlátò nó mâ giì yee kà, ndú giì ṛò ká sè. Tacó tàkìì mì ndâ Pìlátò tende, káa ndâ Jùdéyà ta o tí nò kû gee tí ndú bà ya gí tí ndâ bàndò sàkàmàà á kùṛo bà zò i-cí-ci ta o gbolò o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pìlátò mâ giì ŋò énò, yí giì co ꞌdo tàꞌi gí mì ndú sè. Bìndi  yí giì ꞌvee ndú máa, «Yo kpì ngbàngà tí ꞌdakò tí nó, máa, yí bàkà a yè?» ");
INSERT INTO ndz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Káa ndú giì ꞌvìsì có ji Pìlátò máa, «Vò i mì wó má wálá, ze kùtàá bà gì ta yí gí kùṛo lo bà-i-nó wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Káa Pìlátò giì ꞌvìsì có ji ndú máa, «À má énò, yo ya gí bà ꞌdè ngbàngà mì wó nò gbí ꞌdóó ŋa kpokèjì bà ꞌdè có gbí tàkìì mì yo.» Ndâ kpo ꞌduù mì ndâ Jùdéyà bà-i-nò giì ꞌvìsì có ji Pìlátò máa, «Ngáángbá gba mì ndâ Ròmánò je wotí bà waa có ku mítí ꞌduù ji ze gbí tàkìì mì ze lá.» ");
INSERT INTO ndz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Kponje tí nò bàkà tí gbí òkò tí ndâ Pìlátò ta ndâ kpo ꞌduù mì ndâ Jùdéyà tacó wàa có tí nó náa Jézù ꞌdè énó máa, àá bà zi yí ta bà gbì yí mítí njèèkpè mû nó, ꞌví dù tí  tí yúcó.) ");
INSERT INTO ndz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pìlátò mâ giì ꞌdi bà có mì ndâ kpo ꞌduù mì ndâ Jùdéyà cee gî, yí giì bala Jézù ya tí  gí tàꞌi mì wó. Bìndi  yí giì ꞌvee yí máa, «Wò a gbolò gba mì ndâ Jùdéyà?» ");
INSERT INTO ndz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Káa Jézù giì ꞌvìsì có ji Pìlátò, máa, «Wò kû ꞌvee nò a ꞌdóó ꞌvé mì lo wèè, wò kû ꞌvee a ꞌvé bìndi ꞌbí ꞌduù?» ");
INSERT INTO ndz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pìlátò giì ꞌvee Jézù kákáꞌi máa, «Wò ŋò ye a Jùdéyà? A ndâ ꞌdóó nambe lo tí ndâ Jùdéyà, ta ndâ bu-Mbíṛì mì yo, ká kpì ngbàngà tí lo ji ye. Wò tà bàkà ta ndú a ŋa yè?» ");
INSERT INTO ndz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Káa Jézù giì ꞌvìsì có ji Pìlátò máa, «Ye kùtàá máa gba mì ndâ ꞌduù á muu to tí nó, ndâ bòò mì ye bà gò ndâ kpo ꞌduù mì ndâ Jùdéyà ꞌdo tí bà zèè ye gì tí  ji wò gî. Káa ye me gba mì ndâ ꞌduù á muu to tí nó lá.» ");
INSERT INTO ndz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pìlátò giì ꞌvee Jézù máa, «À má énò, wò a gbolò gba, énò gi?» Káa Jézù giì ꞌvìsì có ji Pìlátò máa, «A wò ká ꞌdè ta nje lo énó máa, ye a gbolò gba. Káa kpêtí ká énò, ye kì me kí-kì lá. Ŋìnó táánò a ndeṛè bà jò ye. Ŋìnó táánò delè a ndeṛè bà gì ye gí muu to tí nó ká nò. Ye gì gí muu to tí nó tacó bà ꞌdè yúcó ji ndâ ꞌduù. Ndâ ꞌduù ŋìnò mbe ùnje gítí yúcó gî nó ꞌdáá gî kû ꞌdi có mì ye.» ");
INSERT INTO ndz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pìlátò giì ꞌvee Jézù tí i-ꞌviya máa, «Yúcó mì lo a yè?» Bìndi  yí giì co ndi wó kákáꞌi ꞌdo tàꞌi gí sè mì ndâ kpo ꞌduù mì ndâ Jùdéyà. Bìndi  yí giì ꞌdè có ji ndú máa, «Ye ŋò ndeṛè bà waa có mì ye mítí ꞌdakò tí nó lá. ");
INSERT INTO ndz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Káa ŋa i mì yo mbe tè mítí yo gî a ŋìnó máa, ye ta o gbolò o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì cóó-cóó kû njaanga ꞌbí ꞌduù ŋìnó mbe nìkì tí yo nó ꞌdo gbí zàà ji yo. À má énò, có mì yo kpónó máa, ye njaanga gbolò gba mì yo tí ndâ Jùdéyà ji yo?» ");
INSERT INTO ndz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ndâ Jùdéyà mâ giì ꞌdi có tí nò náa Pìlátò ꞌdè ji ndú nò, ndú ꞌdáá gî giì ꞌvìsì có ji yí ta kòcò ndú ngéé gí yaà máa, «Njaanga ji ze me ꞌdakò tí nó lá! À tí ze a go bà njaanga Bàrábà ji ze!» Bàrábà tí nò táánò a vò mbe kùmùkù i mì ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pìlátò mâ giì dele ndi wó gí tàꞌi á bìndi ba ꞌdè có mì ndú ta ndâ kpo ꞌduù mì ndâ Jùdéyà gî, yí giì je Jézù ji ndâ àsìkérì mì wó, máa, ndú ya ta yí, wàa ndú ꞌví gbì yí. ");
INSERT INTO ndz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ndâ àsìkérì mâ giì yèè ta Jézù ꞌdo kùṛo Pìlátò gí ndiì gî, ndú giì paṛa kpeṛè go kéꞌbí nô, bìndi  ndú giì te zékéṛé-zèkèṛè mítí muu wó, máa, ŋìnò a tàgíyà-gba mì wó, bìndi  ndú giì yuu bí-bi bòngo mì ndâ gba mítí wó. ");
INSERT INTO ndz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bìndi  ndú giì ꞌbìtà bà gbì yí, ta bà ꞌviya yí máa, «Mbíṛì ꞌví si wò, gba mì ndâ Jùdéyà!» ");
INSERT INTO ndz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pìlátò bà-i-nò giì co ndi wó gí mì ndâ kpo ꞌduù mì ndâ Jùdéyà, si ndâ àsìkérì mì wó kû mèèkèꞌi tí Jézù, bìndi  yí giì ꞌdè có ji ndú máa, «Yo ŋò nô, ye kpónó kû ya gí bà gì ta ꞌduù mì yo nò ji yo, tacó ye ŋò ndeṛè bà waa có mì ye mítí wó lá.» ");
INSERT INTO ndz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ndâ kpo ꞌduù mì ndâ Jùdéyà mâ giì zekeꞌo, ndú giì ŋò ndâ àsìkérì mì Pìlátò yee ta Jézù, ta bí-bi bòngo gba tí wó wúrú-wuru-wùrù, ta tàgíyà-gba náa à paṛaka ꞌdo tí kpeṛè tí muu wó, yee tí ndú gî. Bìndi  Pìlátò giì ꞌdè có ji ndú máa, «ꞌDuù mì yo nô.» ");
INSERT INTO ndz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ndâ kpo ꞌduù mì ndâ Jùdéyà mâ giì ŋò Jézù, ndú giì ꞌbìtà bà pìì kû máa, «Gbì yí mítí njèèkpè mû! Gbì yí mítí njèèkpè mû!» Káa Pìlátò giì ꞌvìsì có ji ndú máa, «Yo ya gí bà gbì yí mítí njèèkpè mû, tacó ye ŋò ꞌdóó ndeṛè bà gbì yí mítí njèèkpè mû ŋìndi ye lá.» ");
INSERT INTO ndz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ndâ kpo ꞌduù mì ndâ Jùdéyà bà-i-nò giì ꞌvìsì có ji Pìlátò máa, «ꞌDakò tí nò kû ꞌdè có máa, yí a ꞌViì-mì-Mbíṛì, káa à má gbí tàkìì mì ze tí ndâ Jùdéyà, yeè gítí ꞌduù mbe kû ꞌdè ŋa có tí nò káa ku.» ");
INSERT INTO ndz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pìlátò mâ giì ꞌdi có tí nò náa ndâ kpo ꞌduù mì ndâ Jùdéyà ꞌdè ji yí nò, gúku giì bàkà yì ndii ŋìnó sàà kùṛo nó gî. ");
INSERT INTO ndz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yí mâ giì dele ꞌdo bà-i-nò ya gí tàꞌi mì wó, yí giì ꞌvee Jézù máa, «Wò gì ꞌdo kòtí ꞌdi?» Káa Jézù giì ràní Pìlátò gî. ");
INSERT INTO ndz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Káa Pìlátò giì ꞌvee Jézù kákáꞌi máa, «Wò wálá biya bà njaa nje lo gí tàkò ye gî? Koṛo muu lo máa, wotí bà njaanga miṛi lo ꞌdo gbí vò i, ta wotí bà gbì wò mítí njèèkpè mû, ꞌdáá a i kpátù ꞌbì ye.» ");
INSERT INTO ndz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Káa Jézù giì ꞌvìsì có ji Pìlátò máa, «Àá táánò má me Mbíṛì ká je wotí tí nò ji wò lá, wò kùtàá bà ꞌde wotí gítí bà zèè ye wálá. Ŋìnò a ndeṛè có tí nò náa, vò i mì mbe gì ta ye ji wò me tí  ta gbolò ndii vò i mì lo gî nò ká nò.» ");
INSERT INTO ndz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pìlátò giì bàkà cèe wotí mì wó tacó bà njaanga Jézù á bìndi có tí nò náa Jézù ꞌdè ji yí nò. Káa ndâ Jùdéyà giì kpò tí ta bà pìì wo ꞌváṛà-ꞌváṛà gî. Ndú giì ꞌdè có ji Pìlátò máa, «Wò má dò ꞌbì lo tí ꞌdakò tí nò gî, wò kákáꞌi me kómbe ngáángbá gba mì ndâ Ròmánò lá, tacó ꞌduù mbe kû bàkà tí wó tí gbolò gba kû jòò a gbí gba ta ngáángbá gba mì ndâ Ròmánò.» ");
INSERT INTO ndz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pìlátò mâ giì ꞌdi ŋa có tí nò náa ndâ Jùdéyà ꞌdè ji yí nò, yí giì njè nó ya gí bà ki tí wó pí jàlàmbà mì wó náa à te mí pí tìndàà díí gbí ngbàngà mì wó, náa ndâ ꞌduù kû nì mítí  a Díí-bà-waa-có, káa ndâ Jùdéyà kû nì mítí  gbí nje có mì ndú a «Gàbátà.» Bìndi  yí giì ꞌdè có ji ndâ àsìkérì máa, ndú gì ta Jézù gí kùṛo yì. Ndâ àsìkérì mâ giì bàkà go có mì wó nò gî, ");
INSERT INTO ndz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pìlátò giì tùbà tí Jézù ji ndâ Jùdéyà máa, «Gbolò gba mì yo kuu nô!» I tí nò bàkà tí ta ṛi dê gítí bà gì gbúrú, si ndâ ꞌduù kû ꞌviindi tí ndú tacó sè sili gítí gbolò o bà bàkà tàkìì bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì ká gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bà tùbà tí Jézù mì Pìlátò ji ndâ Jùdéyà máa, yí a gbolò gba mì ndú nò, giì te mí gbí muu ndú a ꞌbí ŋa i go mâ. Tacó énò, ndú giì tò kû ta kòcò ndú ngéé gí yaà ji Pìlátò máa, «Cee o mì ꞌduù tí nò gî! Gbì yí mítí njèèkpè mû!» Pìlátò bà-i-nò giì ꞌvee ndú máa, «Có mì yo énó máa, ye gbì gbolò gba mì yo mítí njèèkpè mû, wàà?» Káa ndâ Kùṛo ndâ bu-Mbíṛì giì ꞌvìsì có ji Pìlátò máa, «ꞌBí gbolò gba mì ze á bìndi ngáángbá gba mì ndâ Ròmánò wálá!» ");
INSERT INTO ndz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pìlátò mâ giì ꞌdi có tí nò, yí giì je Jézù ji ndú, máa ndú ya gí bà gbì yí mítí njèèkpè mû. ");
INSERT INTO ndz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ndâ àsìkérì bà-i-nò giì te njèèkpè mû tí nó náa ndú kû ya gì bà gbì Jézù mítí  nó ji yí. Bìndi  ndú giì co ta yí ꞌdo gbí gbata gí sè, gítí ꞌbí bàndò náa à kû nì mítí  a Kù-ꞌbilì-muu-ku. Káa à gbí có mì ndâ Jùdéyà kû nì mítí  a «Gòlìgátà.» ");
INSERT INTO ndz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bìndi  ndú giì gbì yí mítí njèèkpè mû. Ndú ta gbèe o tí nò giì gbì ndâ ꞌbí mbe ngbà sósòꞌô mítí ndâ njèèkpè mû delè. Ndú giì sè njèèkpè mû mì ꞌbí mbe ngbà gbaànjé mí gbí kùꞌbì, bìndi  ꞌbí  gbí gàlì mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pìlátò giì cu có, bìndi  à giì kpò mítí njèèkpè mû mì Jézù énó máa, «Ŋìnó a Jézù tí nó tí ꞌduù Názàrètì, tí gbolò gba mì ndâ Jùdéyà nó ká nô.» ");
INSERT INTO ndz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ndâ Jùdéyà me mbè giì ꞌdeke i tí nò náa Pìlátò cu nò, tacó bàndò tí nó náa à gbì Jézù mítí njèèkpè mû mítí  nó me ꞌdú ꞌdo tí gbata lá, delè tacó Pìlátò cu có tí nò gbí ndâ nje có taꞌô: có Jùdéyà, ta có Làtínì, giì je có Ìgìrígì. ");
INSERT INTO ndz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Káa ndâ Kùṛo ndâ bu-Mbíṛì giì ꞌdè có ji Pìlátò máa, «Wò kùtàá bà cu me énó máa, yí a gbolò gba mì ndâ Jùdéyà nò, lá. Cu énó máa, ‹ꞌDakò tí nó ꞌdè có táánò máa, yì a gbolò gba mì ndâ Jùdéyà.› » ");
INSERT INTO ndz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Káa Pìlátò giì ꞌvìsì có ji ndú máa, «I ŋìnó náa ye cu gî nô, ye cu gî.» ");
INSERT INTO ndz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ndâ àsìkérì mâ giì cee ta nèté bà gbì Jézù mítí njèèkpè mû gî, ndú giì njèè gbí ndâ bòngo bìndi wó nàꞌô ꞌvii ta muu ndú. Káa kpokèjì bà njèè gbí ꞌbí bòngo bìndi wó gbaànjé mbe gboo mí to, náa à gò ta banga tí  kpákáꞌdàꞌi énó, giì kpò ndú gî. ");
INSERT INTO ndz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tacó énò, ndú giì ꞌvii có gbí òkò tí ndú máa, à nìkì máa ndâ yì ki a mbílì tacó bà ŋò ꞌduù ŋìnó náa àá bà ꞌva tí tí wó nô, cotí bà yaka gbí . Có tí nò bàkà tí jé ká go có tí nó náa à cu mí gbí wáràgà mì Mbíṛì máa, «Ndú njèè gbí ndâ bòngo mì ye gbí òkò tí ndú. Ndú ki-mbílì tacó ndâ bòngo mì ye» nô. ");
INSERT INTO ndz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","À kû ṛò tíyò ṛègbà njèèkpè mû mì Jézù ta o tí nò a ndâ Màríyà tí nawu wó tí Jézù, ta náꞌvindí nawu wó tí Jézù, ta ꞌbí Màríyà tí niì mì ꞌbí ꞌdakò ta ṛè wó a Kòlópà, ta ꞌbí niì delè ta ṛè wó káa Màríyà náa à kû nì mítí wó a Màríyà Màdèlénà tacó ꞌbá mì ndú gbí gbata Màdálà, ");
INSERT INTO ndz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ta ꞌbí mbe tala có mì Jézù náa Jézù zè yí nìkì ngé ndii gî. Jézù mâ giì ŋò ndâ nawu wó, ta mbe tala có mì wó náa yí zè yí nìkì kpolo ma nó, yí giì je nje mítí nawu wó máa, «Ŋìnó a ꞌviì mì lo, niì.» ");
INSERT INTO ndz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bìndi  yí giì je nje mítí mbe tala có mì wó náa yí zè yí nìkì kpolo ma nó máa, «Ŋìnó a nawu lo ká nô.» Mbe tala có mì Jézù nò giì ꞌbìtà bà kpolo tí Màríyà ká go bà kpolo tí ꞌdóó nawu wó ngé ꞌdo ká bà-i-nò. ");
INSERT INTO ndz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jézù mâ giì ŋò ni énó máa, yì cee ta nèté tí nó náa Mbíṛì tuu yì máa, yì gì gí bà bàkà nó gî, yí giì yù ngo máa, «À tí ye a go ngo,» go có tí nó náa à cu mì gbí wáràgà mì Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ta o tí nò náa Jézù yù ta ngo nò, zùù-zùù ngo nèbítì ta káṛà díí kuu bà-i-nò. Mâ giì zekeꞌo, ꞌbí ꞌduù giì yuu ꞌbí kàfòlò i mbe kû njù ngo go kàfò nó mí gbí zùù-zùù ngo nèbítì tí nò, yí giì sè mí nje ꞌbí kùngbó i, bìndi  yí giì ya  tee mí nje Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jézù mâ giì no-no zùù-zùù ngo nèbítì tí nò gbí i tí nò gî, yí giì ꞌdè có máa, «À cee gî.» Bìndi  yí giì mò muu wó gí to, bìndi  njembí wó giì ki gî. ");
INSERT INTO ndz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sè bà ta ṛi gítí bà ꞌbìtà o bà wotí gbí tàkìì mì ndâ Jùdéyà ta o tí nò ká njíꞌdí; káa gbèe o bà wotí gbí tàkìì mì ndâ Jùdéyà tí nò a gbolò o ndii sè ndâ ꞌbí ŋìnó sàà nó ꞌdáá gî. Tacó énó, ndâ kpo ꞌduù mì ndú giì ya gí mì Pìlátò, bìndi  ndú giì ꞌvee yí máa, yí si à ꞌví cee o mì ndâ ꞌduù tí nò tí ndâ njèèkpè mû nò ta bà gbì gbí ndâ sáá kò ndú kiꞌviki gî, tacó wàa ndâ nambe ndú ꞌví jaka ku ndú ꞌdo yaà gí to. Tacó bà si ku ndú mí yaà ta ŋa gbolò o tí nò á kèjì nò nìkì lá. ");
INSERT INTO ndz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pìlátò mâ giì ùnje ji ndú gî, ndâ àsìkérì giì ya gí bà gbì kiꞌviki kùṛo a gbí kò ndâ ꞌdakò tí nó sósòꞌô náa a gbì ndú mítí ndâ njèèkpè mû seè tí Jézù nô. ");
INSERT INTO ndz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ndú mâ giì ya gítí Jézù, ndú giì ꞌde yí cì sàà gî. Tacó énò, ndú giì gbì gbí ndâ sáá kò wó kiꞌviki lá. ");
INSERT INTO ndz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","À káa ꞌbí àsìkérì ká giì cu Jézù ta ꞌdoò kpíṛí gí tà kí wó nò. Bìndi  mbelè ŋònòkò ta ngo giì cì ꞌdo gbí kà tí nò, tacó yí cì sàà gî. ");
INSERT INTO ndz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mbe ŋò ndâ i tí nò ta ṛo wó dìtà có tí nó ji ndoo, tacó wàa, ndoo delè ꞌví ù ta nje gítí i tí nó náa yì ŋò ta ṛo yì gî nô. Có mì wó náa yí ꞌdè nò a yúcó. Yí delè ŋò ta kpéétí wó ni gî, máa, yì ꞌdè a yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ndú ki gbèe ꞌbilì Jézù lá, go có tí nó náa à cu mí gbí wáràgà mì Mbíṛì énó máa, «Gbèe ꞌbilì wó ki lá,» nô. ");
INSERT INTO ndz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ꞌBí có delè kuu gbí wáràgà mì Mbíṛì gítí có bà cu Jézù ta ꞌdoò nò énó máa, «Ndâ Jùdéyà wúnò bà ni ‹Ze táánò má ni sàà,› tacó tí ꞌduù tí nó náa ndú cu yí ta ꞌdoò nô.» ");
INSERT INTO ndz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jézù mâ giì cì gî, ꞌbí ꞌdakò mbe kû tala có mì Jézù gbí kóó ta gúku ndâ Jùdéyà, ta ṛè wó a Jùzépè, mbe gì ꞌdo gbí gbata Àrìmàtíyà, giì ya gí bà ꞌvee Pìlátò máa, yí si yì ꞌví duu ku Jézù. Pìlátò mâ giì ùnje gî, ndâ Jùzépè giì ya gí bà te ku Jézù ");
INSERT INTO ndz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ta Nìkòdémò, tí ꞌbí mbe kpolo tí tàkìì mì ndâ Jùdéyà mbe ya gí bà ꞌdè nje ta Jézù ta ꞌbí bèbìlì gbaànjé sàà gî. Nìkòdémò te ta yí ta o tí nò a bàà me gbolò náa à ŋònòkò ta yeè tacó bà toṛo mítí ku Jézù, tacó wàa yí ꞌví volo lá. ");
INSERT INTO ndz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ndâ Jùzépè ta Nìkòdémò mâ giì te ku Jézù gî, ndú giì toṛo bàà tí nó náa à ŋònòkò ta yeè nó mítí wó. Ndú mâ giì so yí ta bòngo go i gbí tàkìì mì ndâ Jùdéyà gî, ");
INSERT INTO ndz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ndú giì te yí ya gí bà sii mí gbí ngú gùù náa à duu mí gbí ꞌbí wúngbó gbo jìlì mû, ");
INSERT INTO ndz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","náa à ṛò á dê ta bàndò tí nò náa à gbì yí mítí njèèkpè mû tí  nò, si ndâ Jùdéyà kû ꞌviindi tí ndú gítí o bà wotí gbí tàkìì mì ndú. ");
INSERT INTO ndz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ta yé bìndi ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà, Màríyà Màdèlénà giì gboꞌo si yé kû daꞌo, tacó bà ya gí bà ŋò muuꞌdú Jézù. Yí mâ giì yee kà, yí giì ꞌde à mèṛèkè díí ꞌdo njekèjì ꞌbá muuꞌdú gî. ");
INSERT INTO ndz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yí bà-i-nò giì dele ndi wó ta ngèlè ya gí bà ꞌdè có ji ndâ Sìmónè Pìyétòrò, ta mbe tala có mì Jézù tí nó náa Jézù zè yí nìkì kpolo ma nó, máa, «Ndú te Mbe tí ndoo ꞌdo gbí gùù gî! Káa ze ŋò bàndò tí nó náa ndú ꞌdòkò yí ya tí  gítí  nó lá.» ");
INSERT INTO ndz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ndâ Pìyétòrò ta ꞌbí ka wó mbe tala có mì Jézù nò mâ giì ꞌdi có tí nò náa Màríyà Màdèlénà ꞌdè ji ndú nò, ndú giì njè ta ngèlè tacó bà ya gí bà ŋò muuꞌdú Jézù. ");
INSERT INTO ndz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ndú ꞌbì ngèlè gbaànjé, káa ka Pìyétòrò giì kpò yí ta ngèlè gî. Yí mâ giì yee kùṛo kà, ");
INSERT INTO ndz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","yí giì mò tí wó gí to. Yí mâ giì zekeꞌo gí tà ꞌbá muuꞌdú ꞌdo sè, yí giì ŋò káa ndâ bòngo tí nó náa à so ta ku Jézù nó kuu to tàꞌi. ");
INSERT INTO ndz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sìmónè Pìyétòrò mâ giì gì ꞌdo ndiì, yí giì ṛì ká ngé gí tà ꞌbá muuꞌdú, bìndi  yí giì ŋò kpâ-bòngo tí nó náa à so ta ku Jézù nó kuu to. ");
INSERT INTO ndz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Bìndi  à giì paṛaka kpâ-bòngo tí nó náa à eṛe ta muu wó nó te tende. ");
INSERT INTO ndz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ka Pìyétòrò náa ndú gì ta yí nó mâ giì ṛì gí tàkò wó tà ꞌbá muuꞌdú, yí mâ giì zekeꞌo, yí giì ŋò ku Jézù lá. À ngbíí nò a o bà giì ùnje mì wó máa, Jézù ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî, ká nò. ");
INSERT INTO ndz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tacó ndú jé sàà kùṛo ùnje gítí có tí nó náa à cu mí gbí wáràgà mì Mbíṛì énó máa, Jézù bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó nó, lá. ");
INSERT INTO ndz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bìndi  ndú giì dele ya gí ꞌbá mì ndú. ");
INSERT INTO ndz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Káa si ndâ mbe tala có mì Jézù kû giì njè nó, Màríyà Màdèlénà giì ṛò tíyò dê ṛègbà ꞌbá muuꞌdú kû wa gbí. Yí mâ giì mò tí wó gí to kû zekeꞌo gí tàꞌi, ");
INSERT INTO ndz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yí giì ŋò ndâ basìlì mì Mbíṛì sósòꞌô ta cé-ce bòngo tí ndú, kû ki tí ndú to á bàndò tí nó náa à te ku Jézù ꞌdo tí  gî nô. ꞌBí basìlì dù mò gí bà muu wó, bìndi  ꞌbí  giì dù mò gí tàngbó wó. ");
INSERT INTO ndz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bìndi  ndâ basìlì tí nò giì ꞌvee yí máa, «Wò kû wa a yè, niì?» Káa Màríyà Màdèlénà giì ꞌvìsì có ji ndú máa, «Ye kû wa a Mbe tí ye, tacó ndâ ꞌbí ꞌduù ja ku wó ꞌdo gbí gùù gî. Káa ye ŋò bàndò tí nó náa ndú te yí mítí  nó lá.» ");
INSERT INTO ndz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Màríyà Màdèlénà mâ giì ꞌvìsì tí wó á bìndi bà ꞌdè có tí nò, yí giì ŋò Jézù, káa yí giì ŋò Jézù giṛi gî. ");
INSERT INTO ndz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Bìndi  Jézù giì ꞌvee yí máa, «Wò kû wa a yè, niì? Wò kû pà a bà tí ꞌdi?» Káa Màríyà Màdèlénà giì ꞌvìsì có ji Jézù máa, «À má a wò ká te yí, tùbà to tí nò náa wò te yí mítí  nò je, tacó wàa ye ꞌví ya gí bà te yí ꞌdo kà gî, bu ye.» Màríyà Màdèlénà ꞌdè có tí nò tacó yí ta o tí nò kû koṛo có énó máa, Jézù a mbe njí tí nò náa a duu ku Jézù mí gbí  nò. ");
INSERT INTO ndz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Káa Jézù giì tèꞌé tí Màríyà Màdèlénà máa, «Màríyà!» Màríyà Màdèlénà mâ giì ꞌdi bà tèꞌé tí wó mì Jézù nò, yí giì ꞌvìsì tí wó gí mì Jézù, bìndi  yí giì ùnje ji yí gbí có Jùdéyà máa, «Ràbónì!» Gbí  énò máa, Mbe nìbà i. ");
INSERT INTO ndz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Bìndi  Jézù giì ꞌvìsì có ji Màríyà Màdèlénà máa, «Gàà tí ye lá, tacó ye dele ndi ye ya gí mì Bu ye á gbíṛì kálásê. Ya a i gí bà ꞌdè có ji ndâ náꞌvindí ye máa, ye kû ya gí gbíṛì gí mì Bu ye tí nó tí Bu ndú nô. Wò ꞌví ꞌdè ji ndú delè énó máa, ye kû ya gí gbíṛì, gí mì Mbíṛì tí nó mì ye, á tí Mbíṛì mì ndú nô.» ");
INSERT INTO ndz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Màríyà Màdèlénà bà-i-nò giì ya gí mì ndâ mbe tala có mì Jézù, bìndi  yí giì ꞌdè có ji ndú máa, «Ye ŋò Mbe tí ndoo!» Bìndi  yí giì ꞌvanda ndi ndâ có tí nó náa Jézù tuu ta yí nó ji ndú. ");
INSERT INTO ndz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ta bèbìlì mì kpédélé ṛi nèté bìndi ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà tí nò, ndâ mbe tala có mì Jézù giì kili ta bà muu ndú, bìndi  ndú giì nè tí ndú mí tàꞌi ta gúku ndâ kpo ꞌduù mì ndâ Jùdéyà. Mâ giì zekeꞌo, ndú bà-i-nò giì ꞌdi kòcò ꞌduù kû ꞌdè có ji ndú máa, «Yo dù ta ꞌdê njembí yo!» ");
INSERT INTO ndz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ndú mâ giì zekeꞌo, ŋìnó a Jézù ká kû ṛò tíyò gbí òkò tí ndú nô. Bìndi  yí giì tùbà ndâ kà tí nó kpátù ꞌbì wó, ta ŋìnó tà kí wó nó ji ndú. Ndâ mbe tala có mì Jézù mâ giì ŋò yí, tàkòcò ndú giì peteke gítí bà ŋò Mbe tí ndú ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jézù bà-i-nò giì ꞌdè có ji ndú kákáꞌi máa, «Yo dù nìkì maa. Ye bà tuu yo go ŋìnó náa Bu ye tuu ta ye nô.» ");
INSERT INTO ndz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yí mâ giì ꞌdè có tí nò ji ndú gî, yí giì òlò woò ta nje wó mítí ndú. Bìndi  yí giì ꞌdè có ji ndú máa, «Yo si Bèṛi-mì-Mbíṛì ꞌví dù ta yo. ");
INSERT INTO ndz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yo má je à-cee-gî gítí ndâ vò i mì ꞌduù, gbí  énó máa, Mbíṛì je à-cee-gî gítí ndâ vò i mì ꞌduù tí nò gî. Káa yo má biya bà je à-cee-gî gítí ndâ vò i mì ꞌduù gî, gbí  énó máa, Mbíṛì biya bà je à-cee-gî gítí ndâ vò i mì ꞌduù tí nò gî.» ");
INSERT INTO ndz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ta bèbìlì tí nò náa Jézù tù ta bà tí wó ji ndâ mbe tala có mì wó nò, ꞌbí ꞌduù gbaànjé á ꞌdo gbí òkò tí ndâ mbe tala có mì wó, ta ṛè wó a Tòmázò, náa ndâ ꞌduù kû nì mítí wó a Njemî nó, wálá. ");
INSERT INTO ndz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yí mâ giì gì si Jézù ya gî, ndâ ka wó giì ꞌdè có ji yí máa, «Mbe tí ndoo kùtàá tùbà tí wó ji ze bìndi lo á tàꞌi bà-i-nô!» Káa Tòmázò giì tò kponje có mì ndâ ka wó nò gî. Bìndi  yí giì ꞌvìsì có ji ndú máa, «Ye má ŋò ndâ kà bà gbì yí mítí njèèkpè mû, ta kà ꞌdoò tí nó tà kí wó nó, bìndi  ye ꞌví tee ꞌbì ye mí gbí ndú lá, ye jé gítí bà ùnje gítí có mì yo nò gbaànjé wálá.» ");
INSERT INTO ndz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ta sili vô-nje só bìndi ŋìnò, Jézù giì tùbà tí wó kákáꞌi ji ndâ mbe tala có mì wó si ndú kuu tà gbèe tàꞌi tí nó náa yí kpédéléꞌi tùbà tí wó ji ndú tí  nó, si Tòmázò gbí ŋìnò kuu tí . Ndâ mbe tala có mì Jézù ꞌdi káa kòcò ꞌduù kû ꞌvee ndú máa, «Yo dù ta ꞌdê njembí yo!» Ndú mâ giì zekeꞌo, ndú giì ŋò Jézù kû ṛò tíyò gbí òkò tí ndú. Káa ndâ njekèjì ꞌdáá gî nè tí ndú ká ngbí-ngbíí á bàndò mì ndú. ");
INSERT INTO ndz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jézù bà-i-nò giì tèꞌé tí Tòmázò, Tòmázò mâ giì gì gí mì wó gî, yí giì tùbà ndâ kà bà gbì yí mítí njèèkpè mû tí nó á tí ndâ kpátù ꞌbì wó nó ji yí, máa, «Zeke ndâ kà tí nó á tí ndâ kpátù ꞌbì ye nô, wàa wò ꞌví cu sìlì ꞌbì lo mí gbí ndú.» Yí kákáꞌi giì tùbà kà ꞌdoò tí nó náa à cu ta yí gbí njèꞌvè wó nó ji yí, máa, «Tee ꞌbì lo mí gbí .» Bìndi  yí giì ꞌdè có ji Tòmázò máa, «Me kpììkì-kpììkì lá, ùnje! À me ye ká nó lá?» ");
INSERT INTO ndz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Káa Tòmázò giì ꞌvìsì có ji yí máa, «Wò a Mbe tí ye! Wò a Mbíṛì mì ye!» ");
INSERT INTO ndz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Káa Jézù bà-i-nò giì ꞌvìsì có ji Tòmázò máa, «Wò wálá ùnje tacó náa wò ŋò ye ta ṛo lo gî nò? Káa ndâ ꞌduù ŋìnó mbe ŋò ye lá, káa ndú ùnje gítí ye gî nó nìkì cotí ndâ mbe ŋò ye ta ṛo ndú gî.» ");
INSERT INTO ndz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jézù bàkà ndâ ꞌbí seṛè me mbè ji ndâ mbe tala có mì wó náa à cu có gítí ndú mí gbí wáràgà tí nó lá. ");
INSERT INTO ndz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Káa ndâ ŋìnó náa à cu có gítí ndâ nó a i tacó wàa ndâ ꞌduù ꞌví ù ta nje énó máa, Jézù a Bìndi-Mbíṛì, tí ꞌViì-mì-Mbíṛì. Delè tacó wàa Mbíṛì ꞌví ꞌvala ta ndâ ꞌduù ŋìnó mbe ùnje gítí wó nó ta ṛè wó tí Jézù tí Bìndi  Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jézù giì tùbà tí wó ji ndâ ꞌbí mbe tala có mì wó vô-nje só á bìndi bà tùbà ndâ ꞌbèè kà bà gbì yí mítí njèèkpè mû ji Tòmázò nó á bìndi làmbu sili, si ndú kû gò ngo tí kàpá Tìbérìyà. ");
INSERT INTO ndz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ndâ mbe tala có mì Jézù vô-nje só náa yí tùbà tí wó ji ndú tàbèꞌdè nò a ndâ Sìmónè Pìyétòrò, ta Tòmázò tí nó ta ꞌbí ṛè wó a Njemî nô, ta Nàtànìyélè tí nó mbe gì ꞌdo gbí gbata Kánà á Gàlìléyà nô, giì je ndâ Jákòmò, ta náꞌvindí wó Jòvánì, tí ndâ ꞌviì mì Zèbìdéyò, giì toko mítí ndâ ꞌbí mbe tala có mì wó sósòꞌô. ");
INSERT INTO ndz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","A Sìmónè Pìyétòrò ta bèbìlì tí nò ká ꞌdè có ji ndâ ka wó máa, yì kû ya gí bà gò ngo. Káa ndâ ka Pìyétòrò nò giì ꞌvìsì có ji yí máa, ndâ yì bà ya ta ndú. Ndú giì ya gí bà gò ngo ta bèbìlì tí nò kpòò, káa ndú zèè gbèe sè lá. ");
INSERT INTO ndz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yé má bà giì ꞌbìtà bà da o mbòò, ndú giì dù gbí gbâ mì ndú kû ŋò ꞌduù kû ṛò tíyò a tì gángá ngo. Káa ndú ŋò ꞌduù tí nò ni lá. ");
INSERT INTO ndz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Káa ꞌduù tí nò giì yuu nje wó ji ndú gí ṛo ngo kà máa, «Jìlì ngo bàkà ta yo kà ée wèè, ndâ kómbe ye?» Káa ndú bà-i-nò giì ꞌvìsì có ji ꞌduù tí nò máa, «Tó i mì ze kàá gbaànjé wálá yòò!» ");
INSERT INTO ndz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Káa ꞌduù tí nò giì ꞌvìsì có ji ndú máa, «Yo má ja mbu mì yo nò mí tà ngo mò gí gbí kùꞌbì mì yo gí kùṛo gbâ, yo bà zèè sè gî.» Ndâ mbe tala có mì Jézù mâ giì ja mbu go có tí nò náa ꞌduù tí nò ꞌdè ji ndú nò, bà ja mbu ꞌdo tà ngo gí gbí gbâ giì kpò ndú gî ta du sè. ");
INSERT INTO ndz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mbe tala có mì Jézù náa yí zè yí nìkì kpolo ma nó mâ giì ŋò ŋa i tí nò, yí ngé giì ŋò ni gî máa, ꞌduù tí nò mbe kû ṛò tíyò á tì gángá ngo nò a Jézù. Bìndi  yí giì ꞌdè có ji Pìyétòrò máa, «À kû ṛò tíyò ngéé zó a Mbe tí ndoo!» Pìyétòrò mâ giì ꞌdi énó máa ŋìnò a Mbe tí ndâ yì ká kû ṛò tíyò á tì gángá ngo nò, yí giì kaa ndâ kù bòngo mì wó, yí giì paṛaka mí pí ndò bòngo tí nó tí wó náa yí kû ꞌva ta mbu nô. Bìndi  yí giì o ꞌdo gbí gbâ gí tà ngo, bìndi  yí giì ya gí mí Jézù, si ndâ ka wó mí gbí gbâ. ");
INSERT INTO ndz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ndâ ka Pìyétòrò giì meṛeke ndâ sè ta mbu, ndú giì yèè ta gbâ ta ndâ sè gbí mbu júꞌbú-juꞌbu-jùꞌbù gí tì ngo, tacó ndú ta o tí nò ya ta gbâ ꞌdo tì ngo me ꞌdú lá. ");
INSERT INTO ndz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ndâ mbe tala có mì Jézù mâ giì oloko ꞌdo gbí gbâ gí tì gú, ndú giì ŋò ꞌbí sè náa à kû ꞌbee ta njììkì wu, ta ndâ kpakuta á tà wu. ");
INSERT INTO ndz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Mâ giì zekeꞌo, Jézù giì ꞌdè có ji ndú máa, «Yo gì ta ndâ ꞌbí sè tí nó náa yo zèè kpónó-kpónó nò.» ");
INSERT INTO ndz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sìmónè Pìyétòrò mâ giì ꞌdi có mì Jézù nò, yí giì ya gí gbí gbâ, bìndi  yí giì woo ndâ kpo-kpò sè ta mbu júꞌbú-juꞌbu-jùꞌbù gí tì gú, ta gbèe kà gbí mbu wálá. ");
INSERT INTO ndz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Bìndi  Jézù giì tèꞌé tí ndâ mbe tala có mì wó máa, «Yo gì gítí i-zó-zò.» Ndâ mbe tala có mì Jézù bà-i-nò giì ŋò ni gî máa, à kû ꞌdè có ta ndâ yì nò a Mbe tí ndâ yì, tacó énò, nje ndú ꞌdáá gî giì ꞌdèè ꞌdo tí bà ꞌvee yí énó máa, «Wò a ꞌdi wè?» nò gî. ");
INSERT INTO ndz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jézù bà-i-nò giì ya gí bà aaka kpakuta ꞌdo tà wu, bìndi  yí giì je ji ndú. Bìndi  yí giì dele ndi wó ya gí bà gì ta sè ji ndú ꞌdo gbí njììkì wu gítí kpakuta tí nò. ");
INSERT INTO ndz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ŋìnò a bà taꞌô bà tùbà tí Jézù ji ndâ mbe tala có mì wó á bìndi bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó. ");
INSERT INTO ndz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ndâ Jézù ta ndâ mbe tala có mì wó mâ giì zò i cee gî, Jézù giì ꞌvee Sìmónè Pìyétòrò máa, «Sìmónè, ꞌviì mì Jòvánì, wò zè ye nìkì kpò ndâ ꞌbí ka lo nó gî?» Káa Pìyétòrò giì ꞌvìsì có ji yí máa, «Ìyoo, Mbe tí ye, wò ŋò ni gî máa, ye zè wò nìkì ma.» Bìndi  Jézù giì ꞌvìsì có ji Pìyétòrò máa, «À má énò, kpolo tí ndâ ꞌviì-rómbo mì ye.» ");
INSERT INTO ndz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jézù kákáꞌi giì tèꞌé tí Pìyétòrò, Pìyétòrò mâ giì ùnje ji yí gî, Jézù kákáꞌi giì ꞌvee yí máa, «Sìmónè, ꞌviì mì Jòvánì, wò zè ye nìkì ma?» Káa Pìyétòrò giì ꞌvìsì có ji yí ká go kpédélé ŋìnô, máa, «Ìyoo, Mbe tí ye, wò ŋò ni gî máa ye zè wò nìkì ma.» Bìndi  Jézù giì ꞌdè có ji Pìyétòrò máa, «Kpolo tí ndâ rómbo mì ye.» ");
INSERT INTO ndz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bà taꞌô ŋìnó Jézù kákáꞌi giì ꞌvee Pìyétòrò máa, «Sìmónè, ꞌviì mì Jòvánì, wò zè ye nìkì ma?» Bà taꞌô ŋìnó, ŋa gbèe ꞌvé tí nò giì zèè tí Pìyétòrò gî. Bìndi  yí giì ꞌvìsì có ji Jézù máa, «Wò ŋò ndâ i ꞌdáá ni gî, Mbe tí ye. Wò ŋò ni gî máa, ye zè wò nìkì ma.» Bìndi  Jézù giì ꞌdè ji Pìyétòrò káa gbèe có tí nó náa yí ꞌbìtà bà ꞌdè ji yí máa, «Kpolo tí ndâ rómbo mì ye, nô. ");
INSERT INTO ndz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ye kû ꞌdè có ji wò ta yúcó máa, wò táánò gbí ꞌviì-ꞌdakò lo má zaa gî, wò kû ya gí bà nò ndô go có mì lo náa à gbí muu lo. Káa si ká kuu gi. Ta o tí nó náa wò bà giì me kpo ꞌdakò nó, wò bà giì yaꞌva gbí ꞌbì lo ji ꞌbí ꞌduù, bìndi  yí bà giì eṛe wò gî, bìndi  yí giì ja wò ya tí  gítí bàndò ŋìnó náa a gbí muu lo wálá nô.» ");
INSERT INTO ndz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jézù ꞌdè có tí nò tacó bà tùbà  ji Pìyétòrò máa, yí bà cì a ŋa ku ŋìnó mbe si ṛè Mbíṛì ꞌví wu nô. ");
INSERT INTO ndz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bìndi  Jézù giì tèꞌé tí Pìyétòrò máa, «Gì gí bà ṛu ndi ye.» Pìyétòrò mâ giì ꞌvìsì tí wó, yí giì ŋò mbe tala có mì Jézù tí nó náa Jézù zè yí nìkì kpolo ma, mbe ki tí wó dê ṛègbà tí Jézù ta o bà zò i mì ndú ta ꞌdêꞌo kùṛo bà zi Jézù, mbe ꞌvee Jézù énó máa, «A ꞌdi ká kèjì gí bà ba ngbù lo, Mbe tí ye?» nó, kèjì gí tàkò ndú. ");
INSERT INTO ndz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bìndi  Pìyétòrò giì ꞌvee Jézù máa, «Káa a yè ká tí ꞌdakò tí nó, Mbe tí ye?» ");
INSERT INTO ndz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Káa Jézù giì ꞌvìsì có ji Pìyétòrò máa, «Gì gí bà ṛu ndi ye. Ye kpêtí má ꞌdè có ji yí máa, yí dù yee tí o bà gì ye, nèté mì lo gbí  a yè?» ");
INSERT INTO ndz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Có tí nò náa Jézù ꞌdè ji Pìyétòrò énó máa, «Ye kpêtí má ꞌdè énò máa, yí dù nò yee tí o bà gì ye, ŋìndi lo gbí  a yè wè?» nò giì ꞌvèè cee gbí tù ndâ mbe tala có mì Jézù ꞌdáá gî énó máa, à ꞌdè énò a Jézù máa, mbe tala có mì yì nò bà cì wálá. Káa Jézù ta o tí nò ꞌdè có ji Pìyétòrò me énó máa tú mì yì bà cì wálá nò lá; yí ꞌdè a i énó máa, yì kpêtí má ꞌdè có ji tú mì yì nò énó màa, yí dù yee tí o bà dele ndi yì, nèté mì wó tí Pìyétòrò gbí  a yè wè? ");
INSERT INTO ndz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A yí tí mbe tala có mì Jézù tí nó náa ndâ ꞌbí ka wó fùùmà có tí nò ta ṛè wó máa, à ꞌdè có énò a Jézù, máa, yí bà cì wálá yee tí o bà gì yì tí Jézù nó, ká dìtà có tí nô. À delè a yí ká cu mí gbí wáràgà tí nô. Ndoo delè ŋò ni gî máa, ndâ có mì wó ꞌdáá káa yúcó. ");
INSERT INTO ndz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ndâ ꞌbí i me mbè náa Jézù bàkà ndú kuu tí , náa à cu mí gbí wáràgà lá. Tacó àá táánò má ꞌdè có énó máa, à cu ndú ꞌdáá gî mí gbí wáràgà, bàndò gítí ndâ wáràgà tí nò bà dù me njíꞌdí muu to tí nô.");
INSERT INTO ndz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ákoo, Tèyófìlò, ye táánò gbí kpédélé wáràgà mì ye cu có gítí ndâ, ye i tí nó ꞌdáá gî náa Jézù táánò bàkà ndú nó, ta ndâ i tí nó náa yí nìbà ndú nó ꞌdáá gî, ji wò gî. Ye ꞌbìtà bà ꞌdeke ndâ i tí nó náa yí táánò bàkà ndú nò, ta ndâ i tí nó náa yí nìbà ndú nó gbaànjé-gbaànjé ꞌdo ká ngé ṛèngbó ndú, ");
INSERT INTO ndz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","yee tí o bà te yí ya tí  gí gbíṛì á bìndi bà ꞌdè có mì wó ji ndâ tú mì wó náa yí táánò tuu Bèṛi-mì-Mbíṛì gí bà ṛuka ndú ji yí nô. ");
INSERT INTO ndz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gbí ndâ sili tí nò ziꞌduù-só mbe ꞌbìtà ꞌdo tí o bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó, yee tí o bà ya yí gí gbíṛì nò, yí dù kû tùbà tí wó ji ndâ tú mì wó gbí ndâ ŋa kpokèjì me mbè ta kponje gítí ndú wálá, máa, yì kuu tí  tí wu yì kálásê. Yí delè gbí ndâ o bà tùbà tí wó ji ndú nò kû ꞌdè có ji ndú gítí bà dù Mbíṛì tí gba. ");
INSERT INTO ndz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ta ꞌbí o gbaànjé, si Jézù kû zò i ta ndâ tú mì wó, yí giì kpo-gbí-tà-tù ndú énó máa, «Yo ꞌví njè nó ꞌdo Jèrùzàlémè lá, yo dù ká Jèrùzàlémè, wàa yo ꞌví ùndi cí tí nó náa Bu ye táánò ci ta yo, náa ye táánò ꞌdè có ji yo gítí  nô. ");
INSERT INTO ndz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tacó Jòvánì tí mbe caka tí ndâ ꞌduù táánò kû caka tí ndâ ꞌduù a i ta ngo, káa àá kèjì gí bà caka tí yo ta Bèṛi-mì-Mbíṛì á bìndi làmbu sili.» ");
INSERT INTO ndz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ta ꞌbí o gbaànjé, ndâ Jézù mâ giì kili ta bà muu ndú ta ndâ tú mì wó kákáꞌi gî, ndâ tú mì wó giì ꞌvee yí, máa, «O tí nò gì gî, Mbe tí ze? Àá bà dù nò a o bà le ndi bèṛè mì ndâ kòtí Ìzìrìyélì ji ndú ká nò?» ");
INSERT INTO ndz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Káa Jézù giì ꞌvìsì có ji ndú énó máa, «Bà ŋò o bà gì o tí nò, ta bà ꞌdeke sè sili gítí bà co ṛi tí nò náa a Bu ye táánò ká ꞌdeke ta ꞌdóó wotí mì wó nò me nèté mì yo lá. ");
INSERT INTO ndz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Káa ta o tí nò, Bèṛi-mì-Mbíṛì má gì gî, a yí ká bà je wotí ji yo tacó bà ꞌdè có gítí ndâ i ŋìnó náa yo táánò ŋò ye kû bàkà nó, ta wotí bà ꞌvanda ndi ndâ có ŋìnó náa yo táánò ꞌdi ꞌdo gbí nje ye nó, ji ndâ ꞌduù gbí gbata Jèrùzàlémè, ta ndâ ꞌduù gbí to Sàmárìyà, ta ndâ ꞌduù muu to tí nó ꞌdáá gî.» ");
INSERT INTO ndz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ndâ tú mì Jézù mâ giì zekeꞌo bìndi bà ꞌdè có tí nò mì wó ji ndú, ndú giì ŋò Jézù kû ya zùù gí gbíṛì. Ndú mâ giì zekeꞌo, ndú giì ŋò kùlù mù yiiga bà tí wó ꞌdo tí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Káa si ndú gbí-gbi kû yee ṛo ndú gí tàkò Jézù gbíṛì, ndâ ꞌbí ꞌdakò sósòꞌô mbe yuu cé-ce bòngo giì ṛò tíyò dê ṛègbà tí ndú, ");
INSERT INTO ndz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bìndi  ndâ ꞌdakò tí nò giì ꞌvee ndú, máa, «Yo ṛò tíyò bà-i-nó kû zeke a o yè gí gbíṛì, ndi yo ndâ ꞌduù Gàlìléyà? Gbèe Jézù tí nò náa à kpónó te yí ꞌdo tí yo ya tí  gí gbíṛì nò, bà dele ndi wó gì ká gbí ŋa gbèe kpokèjì tí nò náa yo ŋò yí kû ya tí  gí yaà nò.» ");
INSERT INTO ndz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jézù mâ giì ya gí gbíṛì gî, ndâ tú mì wó giì dele ndi ndú ꞌdo pí Gú Mbâ ya gí Jèrùzàlémè, tí òkò to náa ꞌduù má nò ta ṛi bà wotí gbí tàkìì mì ndâ Jùdéyà káa có gítí wó wálá. ");
INSERT INTO ndz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ndú mâ giì yee Jèrùzàlémè, ndú giì kaa ya gí gbí soṛo, tí ꞌbá tí nó náa ndú ta o tí nò kû dù tí  nô. À kuu tí  ta o tí nò a Pìyétòrò, giì je Jòvánì, giì je Jákòmò, giì je Àndèréyà, giì je Fìlípò, giì je Tòmázò, giì je Bàràtòlòméyò, giì je Màtéyò, giì je Jákòmò tí ꞌviì mì Àlìféyò, giì je Sìmónè tí tó ꞌviì-ꞌbá, giì je Júdà tí nó tí ꞌviì mì Jákòmò nô. ");
INSERT INTO ndz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ndú kili bà muu ndú ta ndâ niì me mbè, giì je Màríyà tí nawu Jézù, ta ndâ náꞌvindí Jézù, kû ꞌdeke tí ndú ji Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ta o tí nò, Pìyétòrò giì ṛò tíyò kùṛo ndâ mbe ùnje gítí có mì Jézù mbe kili ta bà muu ndú go ndâ ꞌduù dê gítí ziꞌduù-vô ta ziꞌduù-gbaànjé pí  (120). ");
INSERT INTO ndz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Bìndi  yí giì ꞌdè có ji ndú, máa, «Ndâ náꞌvindí ye, kózò tí có tí nó náa à cu mí gbí wáràgà mì Mbíṛì nó bà bàkà tí, có tí nó náa Dàvídè tí gbolò gba mì ndâ Jùdéyà ꞌdè sàà táánò ta wotí mì Bèṛi-mì-Mbíṛì gítí i tí nó mbe giì bàkà tí mítí Júdà tí nó táánò tí mbe tè kùṛo ndâ ꞌduù ya tí  gí bà zèè Jézù nô. ");
INSERT INTO ndz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Júdà tí nò táánò a ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndoo, náa ndoo táánò kû bàkà nèté tí nó náa ndoo kpónó kû bàkà nó ta ndú. ");
INSERT INTO ndz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Káa go ŋìnó náa yo ŋò ni gî nó, yí táánò giì sì njí ta mboo náa yí táánò ꞌdè ꞌdo gbí zu nèté tí nò mì wó nò. Yí táánò giì ꞌva njì wó yee wélé-wele mí to mí gbí u njí tí nò, ");
INSERT INTO ndz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","náa ndâ ꞌduù Jèrùzàlémè ꞌdáá gî táánò ꞌdi có tí nò gî. Bìndi  ṛè njí tí nò giì dù a Njí-mbelè, káa à má gbí có mì ndâ Jùdéyà, à kû nì mítí  a ‹Àkèlèdámà.› ");
INSERT INTO ndz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","À kpónó cu mí gbí wáràgà mì ndâ Muu-cè énó máa, ‹ꞌBá bìndi wó ꞌví ꞌbu kpú. À ꞌví o gbí mòòkò bìndi wó káa kùlè.› À giì cu ꞌbí  kákáꞌi énó máa, ‹ꞌBí ꞌduù ꞌví zèè nèté bìndi wó.› ");
INSERT INTO ndz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«À má énò, kózò tí ndoo kpónó bà ŋò ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ꞌduù tí nò táánò mbe kû dù ta ndoo gbí ndâ o tí nó ꞌdáá gî náa Mbe tí ndoo Jézù táánò kû mèṛèkè to ta ndoo nó, ");
INSERT INTO ndz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tí ꞌduù ŋìnó mbe ꞌbìtà bà dù ta ndoo ꞌdo tí o tí nó táánò náa Jòvánì kû caka tí ndâ ꞌduù nó, yee tí o tí nó náa à giì te ta Mbe tí ndoo ya tí  gí gbíṛì gî nô. Tacó wàa, ndoo ꞌví dù ta ndú tí ndâ mbe ꞌdè yúcó gítí bà ꞌvala ndi Mbe tí ndoo ꞌdo gbí muuꞌdú wó.» ");
INSERT INTO ndz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pìyétòrò mâ giì ꞌdè có tí nò cee gî, ndú giì cu ꞌbì ndú mítí ndâ ꞌdakò sósòꞌô, ndâ Jùzépè náa à kû nì mítí wó a Bàràsábà ta kpo ṛè wó a Júsìtò, ta ꞌbí ꞌdakò ta ṛè wó a Màtíyà, máa, à ŋò ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndú, wàa yí ꞌví zèè nèté bìndi Júdà. ");
INSERT INTO ndz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bìndi  ndú bà-i-nò giì ꞌdeke tí ndú ji Mbíṛì énó máa, «Ákoo, Mbe tí ze! Wò ŋò có gbí njembí ndâ ꞌduù ꞌdáá gî gbaànjé-gbaànjé ni gî. À má énò, tùbà tí ꞌduù ŋìnó náa wò cu ꞌbì lo mítí wó ꞌdo gbí òkò tí ndâ ꞌdakò tí nó sósòꞌô nó ji ze, ");
INSERT INTO ndz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tacó wàa, yí ꞌví zèè nèté bà nò tú tí nó náa Júdà jee mí to, yí giì ya gítí ꞌdóó bàndò mì wó gî nô.» ");
INSERT INTO ndz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ndú mâ giì ki-mbílì, à giì ṛò a i mítí Màtíyà. Bìndi  ndú giì ꞌdeke yí toko ta sè ndâ tú mì Jézù muuꞌbì-nje gbaànjé, bàkà muuꞌbì-nje só. ");
INSERT INTO ndz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ta sili ziꞌduù-só-nje muuꞌbì bìndi o bà Ndii-ta-muu-ndâ-Ìzìrìyélì-mì-Mbíṛì, ndâ mbe ùnje gítí có mì Jézù giì kili mí tà gbèe tàꞌi. ");
INSERT INTO ndz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ndú bà-i-nò giì gu káa ndiì ta wo i go wo gbolò pípìṛi nô kû gì ꞌdo tàṛì. Wo i tí nò giì yè tàꞌi tí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bìndi  ndú giì ŋò ꞌbí i go meme wu nó njèè cee muu ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bèṛi-mì-Mbíṛì bà-i-nò giì je wotí ji ndú ꞌdáá gî me gbolò, bìndi  ndú giì ꞌbìtà bà ꞌdè có gbí ndâ ꞌbí ŋa tende nje có ta wotí mì Bèṛi-mì-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ta o tí nò, ndâ Jùdéyà ŋìnó mbe zèè có gítí tàkìì mì ndú kácá-kácá nó kili ꞌdo muu to tí nó ꞌdáá gî mí Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ndú mâ giì ꞌdi ŋa wo i tí nò, ndú giì kili ꞌdáá gî mí bà gbèe to ta ndâ mbe ùnje gítí có mì Jézù. Káa nje ndú ꞌdáá gî giì ꞌdèè gî, tacó ndú gbaànjé-gbaànjé ꞌdáá gî giì dù kû ꞌdi kòcò ndâ tú mì Jézù kû ꞌdè có gbí ndâ nje có mì ndú. ");
INSERT INTO ndz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bà ꞌdè có giì dù káa kpò ndú ꞌdáá gî gî. Ndú giì si káa nje ndú nga-ngàà kû zeke ta ndâ tú mì Jézù. Bìndi  ndú giì ꞌbìtà bà ꞌvee ꞌvé gbí òkò tí ndú, máa, «À kû ꞌdè có tí nó kuu nó me ndâ ꞌduù tí nó mbe gì ꞌdo gbí to Gàlìléyà nó lá? ");
INSERT INTO ndz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Káa à giì bàkà ée, káa ndoo kû ꞌdi gbí ndâ có tí nó náa ndú kû ꞌdè nó gbí ndâ ꞌdóó nje có mì ndoo gbaànjé-gbaànjé ꞌdáá gî? ");
INSERT INTO ndz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ndâ ꞌbí ꞌduù gbí òkò tí ndoo gì ꞌdo Pàrásìyà, ndâ ꞌbí ꞌduù gì ꞌdo Mídì, ndâ ꞌbí ꞌduù gì ꞌdo Èlámì, ndâ ꞌbí ꞌduù gì ꞌdo Mèsòpòtámìyà, ndâ ꞌbí ꞌduù gì ká ꞌdo gbí ndâ to Jùdéyà to nô, ndâ ꞌbí ꞌduù gí ꞌdo Kàpàdósìyà, ndâ ꞌbí ꞌduù gì ꞌdo Póndùsù, ndâ ꞌbí ꞌduù gì ꞌdo Ásìyà, ");
INSERT INTO ndz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ndâ ꞌbí ꞌduù gì ꞌdo Fìríjìyà, ndâ ꞌbí ꞌduù gì ꞌdo Pàfílìyà, ndâ ꞌbí ꞌduù gì ꞌdo Másìrì, ta ndâ to Líbìyà á dê-dê ta Sìrínì, ndâ ꞌbí ꞌduù a ndâ wiṛi tí ndâ Jùdéyà ta ndâ ꞌbí tende ŋa ꞌduù mbe kaa tí ndú gí gbí tàkìì mì ndâ Jùdéyà gî mbe gì ꞌdo Rómà, ");
INSERT INTO ndz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ndâ ꞌbí ꞌduù gì ꞌdo Kèrétì, ndâ ꞌbí ꞌduù gì ꞌdo Àrábìyà. Káa ndoo ꞌdáá gî kû ꞌdi gbí ndâ có tí nó náa ndú kû ꞌdè gítí ndâ kpo-kpò i tí nó náa Mbíṛì bàkà nó gbí ndâ ꞌdóó nje có mì ndoo.» ");
INSERT INTO ndz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nje ndú ꞌdáá gî giì ꞌdèè gî. Bà ꞌdè có gítí i tí nò mbe bàkà tí nò giì dù káa kpò ndú maa gî. Bìndi  ndú giì dù kû ꞌvee gbí ŋa i tí nò gbí òkò tí ndú. ");
INSERT INTO ndz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Káa, ndâ ꞌbí ꞌduù gbí òkò tí ndú giì dù kû lòkóꞌbò có gítí  énó máa, «Ṛúꞌbù ngú cû ndii muu ndâ ka yo gî.» ");
INSERT INTO ndz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Káa Pìyétòrò bà-i-nò giì a gí yaà, bìndi  sè ndâ ꞌbí ka wó tú mì Jézù muuꞌbì-nje gbaànjé ꞌdáá gî giì a gí tàkò wó. Bìndi  Pìyétòrò giì ꞌdè có ji ndâ ꞌduù tí nò bìnjìì nò ta kòcò wó ngéé gí yaà, máa, «Yo tí ndâ ꞌduù Jùdéyà, ta yo tí ndâ ꞌduù tí nó ꞌdáá gî mbe kû ꞌvala gbí gbata Jèrùzàlémè nó, yo si bà giṛiꞌo gítí i tí nó mbe bàkà tí nó mí to. Yo sè tù yo, wàa yo ꞌví ꞌdi gbí có tí nó náa ye kèjì gí bà ꞌdè ji yo nó nìkì maa. ");
INSERT INTO ndz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","À tí ndâ ꞌdakò tí nó me pe go có tí nò náa yo kû koṛo nò lá. Tacó ṛi kpónó káa ṛi dúꞌo. ");
INSERT INTO ndz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ŋìnò a i tí nó náa Jówèlì, tí mbe ꞌdòkò có mì Mbíṛì dígísèé, ꞌdè có gítí  énó máa, Mbíṛì máa, ");
INSERT INTO ndz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Ye bà si Bèṛi mì ye ꞌví gì gí gbí njembí ndâ ꞌduù ꞌdáá gî gbí ndâ ndòngbú sili tí ò kèjì nô. Ndâ ꞌviì mì yo ta ndâ nájú yo bà giì ꞌdè-kòcò, ndâ ꞌviì-ꞌdakò mì yo bà giì ŋò ndâ i go ndâ i gbí ṛiì, ndâ kpo ꞌduù mì yo bà giì ṛi ndâ ṛiì. ");
INSERT INTO ndz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ye bà si Bèṛi mì ye ꞌví gì gí gbí njembí mí muu ndâ bòò mì ye ta ndâ jú i-gbí-kecì mì ye, gbí ndâ sili tí nò, bìndi  ndú bà giì ꞌdè-kòcò. ");
INSERT INTO ndz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ye bà giì tùbà ndâ seṛè mì ye mí tàṛì yaà, bìndi  ye bà giì bàkà ndâ ndi ꞌbì ye mí muu to tí nô. ");
INSERT INTO ndz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ṛo ṛi bà giì ꞌdi gî, bìndi  ṛo pì bà giì ꞌvìsì tí tí mbelè, á kùṛo o bà too gbolò yé tí nò mì Mbe tí ndoo nò. ");
INSERT INTO ndz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ndâ ꞌduù ŋìnó mbe kû nì «Ákoo» ji Mbe tí ndoo nó ꞌdáá gî bà ꞌde ꞌválá gî.› ");
INSERT INTO ndz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Ndâ kòtí Ìzìrìyélì, yo sè tù yo gítí có tí nó náa ye kpónó kèjì gí bà ꞌdè nô. Jézù tí nò mbe gì ꞌdo Názàrètì nò táánò a ꞌdakò náa a Mbíṛì ká wu yí ji yo. Táánò si yí kuu gbí òkò tí yo nó, Mbíṛì je a yí tí mbe bàkà ndâ kpo-kpò i, ta ndâ seṛè, ta ndâ i ŋìnó mbe tùbà wotí mì wó tí Mbíṛì, á go ŋìnó náa yo ꞌdáá gî ŋò ni gî nô. ");
INSERT INTO ndz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mbíṛì táánò je ꞌdakò tí nò mí ꞌbì yo ꞌdo ká gbí ꞌdóó có mì wó gbí njembí wó tí Mbíṛì náa yí ŋò ni sàà kùṛo gî. Yo táánò giì kpì ngbàngà tí wó ji ndâ ꞌduù ŋìnó ta ŋa ndú me ndâ Jùdéyà lá nô, bìndi  ndú giì gbì yí mítí njèèkpè mû ta ꞌve ndeṛè. ");
INSERT INTO ndz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yo táánò zi yí gî, káa Mbíṛì giì te yí gí yaà ꞌdo gbí ku gî. Mbíṛì ꞌvala ndi wó ꞌdo gbí muuꞌdú wó, tacó wotí mì ku gítí bà zèè yí mí gbí zàà mì wó tí ku ngé gî wálá. ");
INSERT INTO ndz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tacó Dàvídè tí gbolò gba mì yo tí ndâ Jùdéyà táánò ꞌdè có gítí wó énó máa, ‹Ye kû ŋò Mbe tí ye kùṛo ye ta o ꞌdáá gî. Yí kû dù gbí kùꞌbì mì ye, tacó wàa njembí ye ꞌví mù lá. ");
INSERT INTO ndz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tacó énò, tàkòcò ye ta o ꞌdáá gî ká pétékèꞌi. Ye delè kû ꞌdè káa líkí nje. Ye delè kpónó kû tè káa wo ye kû ù ta ndi wúnò. ");
INSERT INTO ndz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tacó wò bà jee lilí ye mí ꞌbá mì ndâ ku wálá, wò delè bà si dìì ye, tí bòò mì lo, náa wò kaa yí mò gí mì lo gî nó, ꞌví jìꞌvì to wálá. ");
INSERT INTO ndz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wò tùbà ndâ kpokèjì mì ꞌválá ji ye gî, wò bà si tàkòcò ye ꞌví peteke ta bà dù ye mì ndà.› ");
INSERT INTO ndz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Ndâ náꞌvindí ye, ye kpónó kû ꞌdè có ji yo ngbáṛángàꞌi énó máa, Dàvídè tí ṛèngbó ndâ mbe jò ndoo cì gî. À giì duu yí ta muuꞌdú wó yee gbí ṛi tí nó wúnó nó kuu gbí òkò tí ndoo. ");
INSERT INTO ndz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yí táánò a mbe ꞌdòkò có mì Mbíṛì, tacó énò, yí táánò ŋò ni gî máa, Mbíṛì táánò see tí wó ji yì énó, máa, yì tí Mbíṛì bà ki ꞌbí ꞌviì-gù yì tí Dàvídè mí pí jàlàmbà bìndi yì. ");
INSERT INTO ndz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","«I tí nò náa Dàvídè táánò ŋò , bìndi  yí giì ꞌdè có gítí  si à bàkà tí kálásê nò, a bà ꞌvala ndi Bìndi-Mbíṛì ꞌdo gbí muuꞌdú wó. Bìndi-Mbíṛì a ꞌduù tí nó náa Mbíṛì jee yí mí ꞌbá mì ndâ ku lá, dìì wó delè táánò volo lá. ");
INSERT INTO ndz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mbíṛì táánò te ꞌdakò tí nò tí Jézù nò gí yaà ꞌdo gbí ku gî, náa ze ꞌdáá gî mbe kû ṛò tíyò kùṛo yo nó ŋò yí ta ṛo ze á bìndi bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó nò gî. Ze delè kû ꞌdè yúcó gítí  ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","À kpónó te yí ngéé gí yaà gbíṛì gí gbí kùꞌbì mì Mbíṛì, bìndi  Bu wó giì je Bèṛi-mì-Mbíṛì ji yí, á go cí tí nó táánò náa yí ci ta yí nó gî. À má énò, ndâ i tí nó náa yo kû ŋò kpónó nó, ta có tí nó náa yo kû ꞌdi kpónó nó, a ndâ i-nambeè náa Bèṛi-mì-Mbíṛì ká bàkà ji ndoo. ");
INSERT INTO ndz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tacó Dàvídè táánò jé ya gí yaà gbíṛì lá, káa ŋìnó a ndâ có náa a yí táánò ká ꞌdè énó máa, ‹Mbíṛì ꞌdè có ji Mbe tí ye énó máa, Ki tí lo mò gí gbí kùꞌbì mì ye, ");
INSERT INTO ndz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","yee tí o tí nó náa ye bà bàkà ndâ kuꞌdì mì lo tí ndâ i-tà-tàmà mì lo.› ");
INSERT INTO ndz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Tacó énò, yo tí ndâ kòtí Ìzìrìyélì ꞌdáá gî ꞌví ŋò ni ngbáṛángàꞌi énó máa, Mbíṛì bàkà Jézù tí nó náa yo táánò gbì yí mítí njèèkpè mû nó tí Mbe tí ndoo, delè tí Bìndi wó tí Mbíṛì gî.» ");
INSERT INTO ndz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ndâ ꞌduù mâ giì ꞌdi có tí nò náa Pìyétòrò ꞌdè nò, ndú giì ꞌvee ndâ Pìyétòrò ta ndâ ka wó tú mì Jézù, máa, «Ze ꞌví bàkà a ŋa yè, ndâ náꞌvindí ze?» ");
INSERT INTO ndz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Káa Pìyétòrò giì ꞌvìsì có ji ndú máa, «Yo ꞌvìsì kózò tí muu yo ꞌdo tí ndâ vò i mì yo, wàa à ꞌví caka tí yo gbaànjé-gbaànjé ꞌdáá gî ta ṛè mì Jézù tí Bìndi-Mbíṛì. Tacó wàa Mbíṛì ꞌví je ta à-cee-gî ji yo gítí ndâ vò i mì yo, wàa Mbíṛì ꞌví je ta i-nambeè mì wó tí nó tí Bèṛi mì wó tí Mbíṛì nó ji yo. ");
INSERT INTO ndz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tacó cí tí nó náa Mbíṛì táánò ci nó a i ji yo, ta ndâ ꞌviì mì yo, ta ndâ ꞌduù ŋìnó ꞌdáá gî mbe me ꞌdú nó, giì je ndâ ꞌduù ŋìnó ꞌdáá gî náa Mbe tí ndoo tí Mbíṛì bà giì tèꞌé tí ndú gí mì wó nô.» ");
INSERT INTO ndz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pìyétòrò giì dù kû kili nje ndâ ꞌduù tí nò gítí kpokèjì mì Mbíṛì go bà kili nje gbi nó ta cèe kôndi , ta bà yìì ndú énó máa, «Yo ꞌvala miṛi yo ꞌdo tí ndâ vóló-volo ꞌduù tí nó náa yo kpónó kû ꞌvala ta ndú nô!» ");
INSERT INTO ndz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ndâ có mì Pìyétòrò náa yí ꞌdè ji ndâ ꞌduù tí nò nó giì ya gí gbí muu ndú gî. Bìndi  à giì caka tí ndâ mbe ùnje gítí ndâ có mì wó nò gî. Muu ndâ ngú ꞌduù mbe ùnje gítí có mì Jézù ta ṛi tí nò ꞌdáá gî go ndâ ꞌduù álìfì taꞌô. ");
INSERT INTO ndz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ndâ kpédélé mbe ùnje gítí có mì Bìndi-Mbíṛì ꞌdáá gî giì tee njembí ndú kpolo ngé ma mítí bà nìbà i mì ndâ tú mì Jézù, ta bà dù tí ndâ náꞌvindí gbaànjé, ta bà zò i-cí-ci toko gbaànjé, ta bà ꞌdeke tí ndú ji Mbíṛì toko gbaànjé. ");
INSERT INTO ndz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ndâ seṛè, ta ndâ ndi ꞌbì ndâ tú mì Jézù náa ndú kû bàkà gbí ndâ o tí nò giì te gúku mítí ndâ ꞌduù gbaànjé-gbaànjé ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ndâ mbe tee njembí ndú mítí có mì Jézù ꞌdáá gî giì ꞌvala toko gbaànjé ta gbèe njembí ndú ta ṛè ꞌduù muu ndâ i mì ndú ꞌdáá gî wálá. ");
INSERT INTO ndz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ndú ꞌdáá gî giì sì ndâ i ŋìnó náa à sàà kuu mì ndú kùṛo bà ùnje mì ndú gítí có mì Bìndi-Mbíṛì nó ꞌdáá gî gí ꞌdè, bìndi  ndú giì njèè gbí mboo tàkò ndâ i tí nò gbí ꞌbí ŋa kèjì náa à ꞌboo ꞌduù lá. ");
INSERT INTO ndz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ndú giì dù kû kili ta bà muu ndú ta ṛi ꞌdáá gî mí gbí ndùgù ꞌbá-Mbíṛì. Ndú delè giì dù kû nò ta bà zò i-cí-ci toko gbaànjé ta ndi tí ndâ ꞌbá mì ndú ta pétékè tàkòcò ndú, ta ꞌbí ŋa tende ŋa có gbí njembí ꞌbí ꞌduù gítí ꞌbí ka wó wálá. ");
INSERT INTO ndz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ndú giì dù kû ùlù Mbíṛì, bìndi  ndâ ꞌduù ꞌdáá gî kû zeke ndú ta pétékè tàkòcò. Bìndi  Mbíṛì kû kaa ndâ ꞌduù ŋìnò náa yí ꞌvala ndú gî nó ta ṛi ꞌdáá gî toko mítí ndú. ");
INSERT INTO ndz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ta ꞌbí o gbaànjé si ndâ Pìyétòrò ta Jòvánì kû ya gí gbí ndùgù ꞌbá-Mbíṛì ta ṛi-ꞌdêꞌo, si ṛi gì tí ṛi bà ꞌdeke tí ndâ ꞌduù ji Mbíṛì gî, ");
INSERT INTO ndz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ndú giì ŋò ndâ ꞌduù kû làngà ꞌbí ꞌdakò ndii ta tí ndú. ꞌDakò tí nò náa ndâ ꞌduù tí nò kû làngà yí nò a ꞌduù ŋìnó náa à jò yí tí mbe ósú, náa ndâ kò wó gbeleꞌve ꞌdo ká gbí yì nawu wó. Káa ndâ ꞌduù kû làngà yí ya tí  gítí ꞌbí njekèjì ndùgù ꞌbá-Mbíṛì gbaànjé náa à kû nì mítí  a Banga-Njekèjì-Ndùgù, tacó wàa, yí ꞌví kû yù i ꞌdo tí ndâ mbe kû ṛì gí gbí ndùgù ta ṛi ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ꞌDakò tí nò mâ giì ŋò ndâ Pìyétòrò ta Jòvánì kû ṛì gí gbí ndùgù ꞌbá-Mbíṛì, yí giì yù i ꞌdo tí ndú. ");
INSERT INTO ndz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Káa, ndâ Pìyétòrò ta Jòvánì giì zeke yí ngbóó, bìndi  ndú giì ꞌdè có ji yí máa, «Zeke ze!» ");
INSERT INTO ndz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yí mâ giì ꞌdi có tí nò náa Pìyétòrò ꞌdè ji yí nò, yí giì ꞌvìsì tí wó ta bà zekeꞌo goꞌi gítí ndú, máa, ndú kèjì gí bà je i ji yì. ");
INSERT INTO ndz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Káa Pìyétòrò giì ꞌdè có ji yí máa, «Ndâ njì gùrúsù fádà ta dâꞌbì mì ye tacó bà je ji wò wálá. Káa ye bà je ji wò a i ŋìnó náa à kuu mì ye nô. Ye kû ꞌdè có ji wò ta ṛè mì Jézù tí Bìndi-Mbíṛì, mbe gì ꞌdo Názàrètì énó máa, wò a gí yaà, wàa wò ꞌví nò nó!» ");
INSERT INTO ndz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pìyétòrò bà-i-nò giì yuu ꞌbì wó ya tí  gí bà zèè ta ꞌbì ꞌdakò tí nò, bìndi  yí giì konì ta yí gí bà ṛò tíyò. Káa à káa póó bà ja ꞌdakò tí nò mì Pìyétòrò gí yaà, wu giì gì gí gbí ndâ kpátù kò wó ta ngìì-ngíí kò wó gî. ");
INSERT INTO ndz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yí giì o gí yaà, bìndi  ndú giì ꞌbìtà bà nò nó ta ndâ Pìyétòrò ꞌdo njekèjì ndùgù kû ya gí ṛùkàtiì ꞌbá-Mbíṛì. Yí giì nò, ta bà o gí yaà, ta bà ùlù Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ndâ ꞌduù tí nó mbe tì bìnjìì mí gbí ndùgù ꞌbá-Mbíṛì nó mâ giì ŋò yí kû nò nó ta bà ùlù Mbíṛì, ");
INSERT INTO ndz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ndú giì ŋò yí ni tí ꞌdakò tí nó mbe kû ki tí wó tí Banga-Njekèjì-Ndùgù ꞌbá-Mbíṛì kû yù i ꞌdo tí ndâ ꞌduù nó gî. Bìndi  nje ndú giì ꞌdèè gítí bà ꞌdè có gítí ŋa i tí nò mbe bàkà tí mítí ꞌdakò tí nò nó gî. ");
INSERT INTO ndz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ndâ ꞌduù mâ giì ŋò bà nanaka ꞌdakò tí nò mí ṛègbà tí ndâ Pìyétòrò ta Jòvánì, nje ndú giì ꞌdèè gî, bìndi  ndú giì ki ta ngèlè kpùkú ya gí mì ndú tí bàndò tí nó náa à kû nì mítí  a Tàzo-mì-Sólómònì nô. ");
INSERT INTO ndz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pìyétòrò mâ giì ŋò bà kaa ndâ ꞌduù tí nò gì gítí ndú, yí giì ꞌdè có ji ndú máa, «Yo kû si nje yo tí nga gítí i tí nó mbe bàkà tí nó tacó yè, ndâ Ìzìrìyélì? Yo kû dongbo ṛo yo gítí ze tacó yè? Yo koṛo có máa, ꞌdakò tí nò kû nò nó ꞌdo gbí ꞌdóó wotí mì ze? Yí kû nò nó ꞌdo gbí ꞌdóó bà nìkì ze? ");
INSERT INTO ndz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A Mbíṛì mì Àbìráámò, tí Mbíṛì mì Ìzákò, tí Mbíṛì mì Jàkóbè, tí Mbíṛì mì ndâ ká gù yo, ká bàkà i tí nô, tacó bà te duù mítí Bòò mì wó Jézù, tí gbèe Jézù tí nó náa yo táánò kpì ngbàngà tí wó, máa, à ꞌví zi yí gî nô, Jézù tí nó náa yo táánò bè yí mí kùṛo Pìlátò nô, Jézù tí nó náa Pìlátò táánò ꞌdè có ji yo máa, yì bà njaanga yí ꞌdo gbí zàà gî, káa yo giì biya có mì Pìlátò gî. ");
INSERT INTO ndz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yo giì biya ꞌduù tí nó ta ndi vò i tí wó wálá, tí ꞌduù ŋìnó jáá nó gî. Yo giì yòòngò Pìlátò máa, yí njaanga a mbe zi ku ꞌdo gbí zàà, ");
INSERT INTO ndz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","bìndi  yo giì zi mbe je ꞌválá ji ndâ ꞌduù gî. Káa Mbíṛì giì ꞌvala yí ꞌdo gbí ku gî. Ze a ndâ mbe ꞌdè yúcó gítí bà ꞌvala ndi wó ꞌdo gbí muuꞌdú wó nò. ");
INSERT INTO ndz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Káa à kpónó káa gbèe Jézù tí nó náa yo táánò bè yí ji ku nó ká ꞌvala ꞌdakò tí nó á kuu kùṛo yo, náa yo ŋò yí ni ngbáṛángàꞌi gî nó, á ꞌdo gbí có bà tee njembí ze á mítí wó tí Jézù. A bà tee njembí ze á mítí Jézù nò ká je wotí ji ꞌdakò tí nó náa yo kpónó kû ŋò yí nô. ");
INSERT INTO ndz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Káa ye kpónó ŋò ni gî, ndâ náꞌvindí ye, máa, yo ta ndâ gba mì yo táánò ŋò i tí nó náa yo kû bàkà nò ni lá. ");
INSERT INTO ndz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Káa ŋìnò táánò a ꞌbí ŋa i náa a Mbíṛì ká bàkà énò, tacó wàa ndâ có tí nó náa yì tí Mbíṛì táánò tuu ta ndâ mbe ꞌdòkò có mì yì énó máa, Bìndi-Mbíṛì bà kònò séꞌi nó, ꞌví dù tí  tí yúcó. ");
INSERT INTO ndz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","À má énò, yo ꞌvìsì muu yo ꞌdo tí ndâ vò kpokèjì mì yo gî. Yo ꞌvìsì tí yo gí mì Mbíṛì, tacó wàa yí ꞌví toṛo ndâ vò i mì yo gî. Delè tacó wàa, ndoo ꞌví ꞌde ta làmbu gùlúsù pípìṛi ꞌdo mì Mbe tí ndoo tacó bà ꞌdèè njembí ndoo, ");
INSERT INTO ndz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","wàa yí ꞌví tuu ta Jézù tí nò tí Bìndi wó tí Mbíṛì náa yí cu ꞌbì wó mítí wó tacó tí yo sàà gî nó ji yo. ");
INSERT INTO ndz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yí tí Jézù bà dù ká gbíṛì yee tí o bà gì ndâ i muu to tí nó ꞌdáá gî tí ndâ ngú i, go có tí nó náa Mbíṛì dígísèé tuu ta ndâ tó mbe ꞌdòkò có mì wó gì gí kò ta kò gbí o mì ndâ ká gù yo nô. ");
INSERT INTO ndz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tacó kòcò Mòze náa yí ꞌdè dígísèé énó máa, ‹Mbe tí ndoo tí Mbíṛì bà bàkà ꞌbí ꞌduù tí mbe ꞌdòkò có mì wó go ye nó ji yo. ꞌDuù tí nò bà dù a ꞌduù ꞌdo gbí òkò tí ndâ ꞌdóó náꞌvindí yo. Yo ꞌví ꞌdi ndâ có ŋìnó náa yí kèjì gí bà ꞌdè ji yo nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Àá bà mò ꞌduù ŋìnó mbe ꞌdi có mì mbe ꞌdòkò có mì Mbíṛì tí nò lá nó ꞌdo gbí òkò tí ndâ ꞌduù mì Mbíṛì gî.› ");
INSERT INTO ndz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«À má ta bà ꞌdè có ta yúcó, Sàmùwélè tí mbe ꞌdòkò có mì Mbíṛì, giì je ndâ ꞌbí mbe ꞌdòkò có mì Mbíṛì ꞌdáá gî mbe gì gí tàkò wó nó dígísèé ꞌdáá gî, kû ꞌdè có tù ta ꞌbì ndú ká gítí o bà co ndâ ṛi tí nô. ");
INSERT INTO ndz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yo a ndâ mbe zèè mbèlè bìndi ndâ mbe ꞌdòkò có mì Mbíṛì. Yo a ndâ ꞌviì gbí mbelè tí nó náa Mbíṛì dígísèé njù ta gù ndoo tí Àbìráámò ta o tí nó náa yí ꞌdè ta có ji Àbìráámò énó máa, ‹Ye tí Mbíṛì bà cù ꞌdê ngo cù ye mítí ndâ ꞌduù muu to tí nó ꞌdáá gî ta ṛè mì ndâ ꞌviì-gù mì lo,› nô. ");
INSERT INTO ndz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mbíṛì táánò cu ꞌbì wó mítí Bòò mì wó, bìndi  yí giì tuu yí kpédéléꞌi gí bà cù ꞌdê ngo cù wó mítí yo, ta bà ꞌvìsì muu yo gbaànjé-gbaànjé ꞌdáá gî ꞌdo tí ndâ vò i mì yo.» ");
INSERT INTO ndz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Káa si ndâ Pìyétòrò ta Jòvánì gbí-gbi kû ꞌdè có ji ndâ ꞌduù, ndú mâ giì zekeꞌo, ndú giì ŋò ndâ ꞌbí bu-Mbíṛì mì ndâ Jùdéyà, ta kùṛo ndâ mbe kû kpolo tí ꞌbá-Mbíṛì, giì je ndâ Sàdùkáyò, tí ndâ ꞌbí ŋa ꞌduù gbí òkò tí ndâ Jùdéyà mbe ùnje gítí bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú lá, gbo ndú gbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Có tí nó mbe kpolo tàkòcò ndâ kpo-kpò ꞌduù tí nò náa ndú giì ya tí  gítí ndâ Pìyétòrò ta Jòvánì nò a có bà nìbà i mì ndâ Pìyétòrò ta Jòvánì ji ndâ ꞌduù gítí bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú, náa ndú kû kò ta kò ji ndâ ꞌduù énó máa, Jézù ꞌvala ndi wó ꞌdo gbí muuꞌdú wó gî nô. ");
INSERT INTO ndz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ndú bà-i-nò giì kaa ndâ Pìyétòrò ta Jòvánì ya tí  gí gbí zàà, wàa à ꞌví giì ꞌviiki gbí có mì ndú ta ꞌbí yé, tacó ṛi ta o tí nò ta gî. ");
INSERT INTO ndz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Káa ndâ ꞌduù me mbè ꞌdo gbí òkò tí ndâ ꞌduù tí nó mbe ꞌdi ndâ có tí nó náa ndâ Pìyétòrò ta Jòvánì ꞌdè ta ꞌdêꞌo tí nò nò giì ùnje gítí có mì Jézù gî. Muu ndâ mbe ùnje gítí có mì Jézù ꞌdáá gî toko mítí ndâ ká ŋìnó ta o tí nò giì dù dê gítí ndâ ꞌdakò álìfì vô. ");
INSERT INTO ndz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yé mâ giì too gî, ndâ kpo-kpò ꞌduù, ta ndâ kpo-ꞌduù-ꞌbá, ta ndâ mbe nìbà tàkìì mì ndâ Jùdéyà, giì kili mí Jèrùzàlémè, ");
INSERT INTO ndz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ta ndâ Ánà (tí ꞌbí ká Kùṛo ndâ bu-Mbíṛì mì ndú náa ngáángbá gba mì ndô Ròmánò mò yí ꞌdo gbí nèté gî), giì je Kàyífà, giì je ndâ Jòvánì ta Àlèsándòrò, ta ndâ ꞌbí ꞌduù náa ṛèngbó bà jò ndú ꞌdo a i tí ndâ Kùṛo ndâ bu-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ndú giì tuu tú gí tàkò ndâ Pìyétòrò ta Jòvánì ꞌdo gbí zàà. À mâ giì kaa ndú gì tí  gí kùṛo ndú gî, ndú giì kaa ndú mí gbí uù, bìndi  ndú giì ꞌbìtà bà ꞌvee gbí nje ndú máa, «Yo bàkà i tí nò ta ŋa kpokèjì ngàyi? Yo bàkà i tí nò ta ŋa wotí mì yè? Ṛè ꞌduù tí nò mbe je wotí tí nò ji yo nò a ꞌdi?» ");
INSERT INTO ndz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Káa Bèṛi-mì-Mbíṛì giì je wotí ji Pìyétòrò me gbolò, bìndi  yí giì ꞌvìsì có ji ndú máa, «Yo tí ndâ gba mì ndâ ꞌduù, giì je yo tí ndâ kpo ꞌduù, ");
INSERT INTO ndz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yo wúnó má kû ꞌvee gbí nje ze a i gítí có nambeè tí nó náa ze bàkà ji ꞌdakò tí nó táánò mbe kû ìṛì ta to nó, yo má kû ꞌvee a kpokèjì bà ꞌvala yí mì ze, ");
INSERT INTO ndz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tàkòcò ye peteke gítí bà ꞌvìsì có ji yo tí ndâ gba, ta ndâ kpo ꞌduù, ta yo tí ndâ kòtí Ìzìrìyélì ꞌdáá gî, ngé ma, máa, ze ꞌvala ꞌdakò tí nó ta ṛè mì Jézù tí nó tí Bìndi-Mbíṛì mbe gì ꞌdo Názàrètì nô, Jézù tí nó náa yo táánò gbì yí mítí njèèkpè mû, káa Mbíṛì giì ꞌvala yí ꞌdo gbí ku gî nô. ꞌDakò tí nó wúnó kû ṛò tíyò kùṛo yo ta séꞌi cee mbéé ꞌdo tí wó gî nó a i ta ṛè mì wó tí Jézù, ");
INSERT INTO ndz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","tí díí tí nó náa à cu có gítí  mí gbí wáràgà mì Mbíṛì, máa, ‹Díí tí nó náa yo tí ndâ mbe bì ꞌbá bè gî nó, ká gì tí yú díí bà sè tà ꞌbá.› ");
INSERT INTO ndz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tacó à nì ṛè ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ꞌduù muu to tí nó ji ndâ ꞌduù máa, yí a mbe ꞌvala ndoo, á bìndi ṛè wó nò lá.» ");
INSERT INTO ndz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nje ndâ gba ta ndâ kpo ꞌduù giì ꞌdèè gítí ndâ Pìyétòrò ta Jòvánì gî. Ndú mâ giì ꞌviiki ṛèngbó ndú gbí òkò tí ndú, ndú giì ŋò ndú ni ká tí ndâ ꞌduù sínò jé mbe ki tí ndú njewu ta ndâ kpo-kpò mbe nìbà tàkìì mì ndâ Jùdéyà lá ni gî. Ndú delè giì ŋò ni gî máa, ndú táánò kû dù a i ta Jézù. ");
INSERT INTO ndz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Káa ndú mâ giì ŋò ꞌdakò tí nó náa ndú ꞌvala yí nó kû ṛò tíyò ṛègbà tí ndú, bà ꞌdè có giì dù káa kpò ndú gî. ");
INSERT INTO ndz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tacó énò, ndú giì ꞌdè có ji ndú máa, «Yo yèè ꞌdo gbí ngbàngà gí ndiì tacó wàa ndâ gba ꞌví waa ta có.» ");
INSERT INTO ndz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ndâ Pìyétòrò ta Jòvánì mâ giì yèè ꞌdo gbí ngbàngà gí ndiì gî, ndâ gba giì ꞌbìtà bà ꞌviiki gbí có mì ndú, máa, «Ndoo kpónó ꞌví bàkà a ŋa yè ta ndâ ꞌdakò tí nò? Tacó ndâ ꞌduù Jèrùzàlémè ꞌdáá gî ŋò ŋa tende seṛè tí nó náa ndú bàkà nó gî. Káa ŋìnò a i ŋìnó mbe je kponje ꞌdo nje ndoo gî nó ká nò. ");
INSERT INTO ndz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","I ŋìnó náa ndoo kpónó bà ni bà bàkà gî nó káa bà ṛò bà ꞌvèè có seṛè tí nó gí kùṛo, ta bà ci ndú máa, ndú kákáꞌi ꞌví nì ṛè Jézù tí nò ji ꞌbí ꞌduù lá.» ");
INSERT INTO ndz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ndâ gba mâ giì ꞌviiki gbí có mì ndâ Pìyétòrò ta Jòvánì cee gî, ndú giì tèꞌé tí ndú, bìndi  ndú giì ci ndú, máa, «Ndòngbú tí yo bà nìbà i ji ndâ ꞌduù ta ṛè Jézù ꞌví dù káa yí  nò.» ");
INSERT INTO ndz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Káa ndâ Pìyétòrò ta Jòvánì giì ꞌvìsì có ji ndú, máa, «Yo koṛo muu yo, yúcó kùṛo Mbíṛì má a bà ꞌdi có mì yo mì ze á co tí bà ꞌdi có mì wó tí Mbíṛì, wàa ze ꞌví ꞌdi ndòngbú có ŋìnó náa yo bà ꞌdè ji ze nô. ");
INSERT INTO ndz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tacó ze bà ṛò tíyò ꞌdo tí bà ma có i tí nó náa ze ŋò ta ṛo ze gî nó wálá. Ze delè gítí bà nè nje ze a ꞌdo tí bà ma có tí nó náa ze ꞌdi ta tù ze gî nò wálá.» ");
INSERT INTO ndz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Káa ndâ gba giì ci ndâ Pìyétòrò ta Jòvánì kákáꞌi, máa, «Ndòngbú tí yo.» Ndú ꞌde kpokèjì bà waa có mítí ndâ Pìyétòrò ta Jòvánì ta o tí nò lá, tacó ndâ ꞌduù ꞌdáá gî ta o tí nò kû ùlù Mbíṛì tacó i tí nó mbe bàkà tí nô. ");
INSERT INTO ndz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ꞌDakò tí nó náa ndâ Pìyétòrò ta Jòvánì bàkà seṛè tí nò mítí wó nò a ꞌduù ta ndoò tí wó ndii ziꞌduù-só gî. ");
INSERT INTO ndz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","À mâ giì njaanga ndâ Pìyétòrò ta Jòvánì ꞌdo gbí zàà gî, ndú giì ya gí ꞌbá, bìndi  ndú giì ꞌvanda ndi ndâ có tí nó náa ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ kpo-ꞌduù-ꞌbá, ꞌdè ji ndú nó ji ndâ ꞌbí ka ndú mbe ùnje gítí có mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ndâ ka ndâ Pìyétòrò ta Jòvánì mâ giì ꞌdi ndi ndâ có tí nò, ndú giì ꞌdeke tí ndú ta njembí ndú gbaànjé ji Mbíṛì énó máa, «Àá Mbe tí ze, tí mbe suu tàṛì, ta to tí nó, ta ndâ kpo-kpò ngo. A wò ká suu ndâ i gbíṛì, ta ndâ i muu to tí nó, ta ndâ i tà ndâ kpo-kpò ngo ꞌdáá gî! ");
INSERT INTO ndz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","A wò dígísèé ká tuu Bèṛi mì lo tí Mbíṛì gí bà wu có mí gbí nje gù ze tí Dàvídè, tí bòò mì lo, bìndi  yí giì ꞌdè có énó máa, ‹Ndâ ꞌduù tí nó náa ndú me ndâ Jùdéyà lá nó kû luguu tí ndú ta gbínje tacó yè? Ndâ ꞌduù kû koṛo có gítí ndâ i ŋìnó ta gbí ndú wálá nó tacó yè? ");
INSERT INTO ndz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ndâ kpo-kpò gba muu to tí nó kû ja gó, bìndi  ndâ kpo-kpò ꞌduù kùṛo ndâ ꞌduù kû toko có gítí Mbe tí ndoo. Ndú delè kû toko có gítí ꞌDuù mì Mbíṛì á tí Bìndi-Mbíṛì nô.› ");
INSERT INTO ndz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Có tí nò náa Dàvídè ꞌdè nò dú giì bàkà tí gî. Tacó ndâ Èródè ta Pónísìyò Pìlátò táánò giì toko có ta ndâ ꞌduù ŋìnó náa ndú me ndâ Jùdéyà lá nó, ta ndâ Ìzìrìyélì mí gbí gbata tí nó, gítí Jézù tí Bòò mì lo náa wò kaa yí mò gí mì lo gî, náa wò je yí tí Bìndi lo tí Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ndú dígísèé toko có tí nò ká tacó bà bàkà ndâ i tí nó ꞌdáá gî náa wò ta wotí mì lo tí Mbíṛì koṛo có gítí ndú cee sàà gî, máa, ndú kèjì gí bà bàkà tí nô. ");
INSERT INTO ndz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nògí, koṛo muu lo gítí ndâ cí tí nó náa ndú ci ta ze nô, Mbe tí ze. Konì ndâ bòò mì lo, tacó wàa, ndú ꞌví ma có mì lo ta yú njembí ndú. ");
INSERT INTO ndz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yaꞌva ꞌbì lo, wàa wò ꞌví ꞌvala ndâ mbe nòꞌo. Wàa, wò delè ꞌví bàkà ndâ seṛè, ta ndâ i ŋìnó mbe ꞌdèè nje ndâ ꞌduù gî nó, ta ṛè mì Jézù tí Bòò mì lo náa wò kaa yí mò gí mì lo gî nô.» ");
INSERT INTO ndz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ndâ mbe ùnje gítí có mì Jézù mâ giì ꞌdeke tí ndú ji Mbíṛì cee gî, to giì tanga tí tí bàndò tí nó náa ndú kili mítí  nô. Bèṛi-mì-Mbíṛì bà-i-nò giì je wotí ji ndú me gbolò, bìndi  ndú giì ꞌbìtà bà ma có mì Mbíṛì ta gúku tí ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ndâ kpédélé mbe ùnje gítí có mì Jézù ꞌdáá gî ta o tí nò giì eṛe gba có mì ndú ká gbaànjé, ta vò njembí gbí òkò tí ndú wálá. ꞌBí ꞌduù delè mbe nì, «I mì ye,» gítí ꞌdóó i mì wó ta o tí nò gbí òkò tí ndú wálá. Ndâ i ŋìnó náa ndú kili nó ꞌdáá gî tacó tí ndâ ꞌduù ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ta o tí nò, ndâ tú mì Jézù giì dù kû ma có bà ꞌvala ndi Mbe tí ndoo tí Jézù ꞌdo gbí muuꞌdú wó ta wotí ká tí . Mbíṛì delè giì cù ꞌdê ngo cù wó me gbolò mítí ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ꞌBí ꞌduù gbí òkò tí ndú mbe wa i ta o tí nò wálá, tacó ndâ ꞌduù ŋìnó gbí òkò tí ndú ta to njí kuu mì ndú, ta ndâ ꞌduù ŋìnó ta ꞌbá kuu mì ndú nó, giì sì ndâ i tí nò gí ꞌdè, ");
INSERT INTO ndz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bìndi  ndú giì kaa mboo tàkò ndâ i tí nò ji ndâ tú mì Jézù. Ndâ tú mì Jézù giì njèè ji ndâ ꞌduù ŋìnó tí ndâ mbe yê gbí òkò tí ndú náa à ꞌví je ji ndú nô. ");
INSERT INTO ndz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Ta o tí nò, ꞌbí ꞌdakò tí ꞌviì kòtí Lévì náa a jò yí mí Kípùrù, ta ṛè wó a Jùzépè, náa ndâ tú mì Jézù kû ni mítí wó a Bàrànábà (gbí ṛè tí nò máa, «Mbe je wotí gítí i»), giì sì njí mì wó gí ꞌdè, bìndi  yí giì kaa i gbí  ji ndâ tú mì Jézù tacó bà njèè ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ta ꞌbí o gbaànjé, ndâ ꞌbí ꞌdakò ta ṛè wó a Ànàníyà, ta nawù wó ta ṛè wó a Sàfírà, giì toko có mì ndú, bìndi  ndú giì sì to njí mì ndú gí ꞌdè. ");
INSERT INTO ndz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Bìndi  Ànàníyà giì je káa tí mboo tàkò njí mì ndú náa ndú sì gí ꞌdè nó ya tí  ji ndâ tú mì Jézù, káa nawù wó ꞌdi gbí i tí nò náa yí bàkà nò ngbáṛángàꞌi gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ànàníyà mâ giì di ta i tí nò tí ndâ tú mì Jézù, Pìyétòrò giì ꞌvee yí máa, «Ànàníyà, Gba-wàtà jèjèèkè tí wó mí gbí njembí lo tí ŋa ŋìnó náa wò giì ngùù tí mboo tàkò njí mì lo gî, bìndi  wò giì ꞌdè ꞌvéṛè ji Bèṛi-mì-Mbíṛì tacó yè? ");
INSERT INTO ndz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Táánò kùṛo bà sì njí tí nò mì lo gí ꞌdè, à me ꞌdóó njí mì lo lá? Káa, wò tà kpêtí mâ giì sì gí ꞌdè gî, mboo tàkò  me i mì lo tacó wàa wò ꞌví bàkà tí  go có mì lo gbí njembí lo lá? A yè ká a tàmuu lo gítí bà bàkà ŋa i tí nò? Wò ꞌdè ꞌvéṛè tí nò me ji ndâ ꞌduù lá, wò ꞌdè a i ji Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ànàníyà mâ giì ꞌdi có tí nò náa Pìyétòrò ꞌdè ji yí nò, yí giì ꞌva tí wó to tí yú ku. Bìndi  gúku giì zèè ndâ ꞌduù tí nó mbe ꞌdi có i tí nò mbe bàkà tí nò nó ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ndâ ꞌviì-ꞌdakò bà-i-nò giì oloko gí yaà, bìndi  ndú giì yili yí gî. Ndú giì te yí gí sè, bìndi  ndú giì duu yí gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ndâ ꞌduù mâ giì dù á bìndi bà te ku Ànàníyà gí sè nò ndì-ndì-ndì énó, ndú giì ŋò Sàfírà ṛi gí tàkò ndú tàꞌi gî. Káa yí ŋò i tí nó mbe bàkà tí á kùṛo wó kà nó ni lá. ");
INSERT INTO ndz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Káa Pìyétòrò giì ꞌvee yí máa, «Ŋìnó wálá a kábà mboo tàkò njí mì yo náa yo sì gí ꞌdè nó ká nó, Sàfírà? ꞌDè yúcó mì lo je wàa ye ꞌví ꞌdi gi!» Káa Sàfírà giì ꞌvìsì có ji Pìyétòrò máa, «Ìyoo, à ꞌdáá gî nò a yí .» ");
INSERT INTO ndz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Káa Pìyétòrò giì ꞌvìsì có ji Sàfírà máa, «Yo ta kù lo toko có gítí bà tala Bèṛi-mì-Mbíṛì gî! A yè ká a tàmuu yo gítí bà bàkà ŋa i tí nò? Wò ꞌdi wo tí ndâ ꞌduù tí nò kèjì nò gî? Ndú kpónó kû gì nò ꞌdo bà duu ku kù lo. Ndú kpónó bà te wò gí sè delè!» ");
INSERT INTO ndz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","À káa póó bà cee có tí nò gbí nje Pìyétòrò, Sàfírà ngé giì ꞌva tí wó gbàràsà to kùṛo wó tí yú ku. Ndâ ꞌviì-ꞌdakò tí nó mbe gì ꞌdo bà duu ku Ànàníyà nó mâ giì ṛì gí tàꞌi, ndú giì ꞌde Sàfírà cì delè gî. Ndú bà-i-nò giì te yí gí sè, bìndi  ndú giì duu yí mí ṛègbà tí ꞌdakò mì wó. ");
INSERT INTO ndz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","I tí nò giì te gúku mítí ndâ mbe ùnje gítí có mì Jézù, ta ndâ ꞌduù ŋìnó mbe ꞌdi tà wo  nó ꞌdáá gî ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ndâ mbe ùnje gítí có mì Jézù má giì ya gí bà ꞌdeke tí ndú ji Mbíṛì gbí ndâ o tí nò, ndú kû giì kili ká ta bà muu ndú mítí ꞌbí bàndò gbí ndùgù ꞌbá-Mbíṛì náa à kû nì mítí  a Tàzo-mì-Sólómònì. Ndâ tú mì Jézù giì dù kû bàkà ndâ seṛè, ta ndâ kpo-kpò i mbe kû tùbà wotí mì Mbíṛì ji ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tacó énò, gúku giì kpò ndâ ꞌduù ŋìnó náa ndú me ndâ mbe ùnje gítí có mì Jézù lá nó ꞌdo tí bà yuu tí ndú gí gbí òkò tí ndú gî. Kpêtí ká énò, ndâ ꞌduù giì wu gbí ndú ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Káa, muu ndâ ꞌdakò ta ndâ niì mbe ùnje gítí có mì Jézù giì àdì me gbolò. ");
INSERT INTO ndz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ndâ ꞌduù Jèrùzàlémè mâ giì ŋò ndâ seṛè tí nó náa ndâ tú mì Jézù kû bàkà nó, ndú giì tuṛu ndâ mbe nòꞌo mì ndú, ndú giì sii ndú kpìṛìꞌvìì ta seè kpokèjì, tacó wàa, Pìyétòrò má kû ndii ta nó, wàa vòó tàzo wó ꞌví có muu ndú. ");
INSERT INTO ndz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ndâ ꞌduù delè giì tuṛu ndâ mbe nòꞌo mì ndú, ta ndâ ꞌduù ŋìnó ta ndâ i-gbí-muu ndú nó me mbè ꞌdo gbí ndâ gbata ŋìnó dê-dê ta seè Jèrùzàlémè nó, gì tí  ji ndâ tú mì Jézù, bìndi  ndú giì ꞌvala ndú ꞌdáá gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ju kiì giì te ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ ꞌduù mì wó tí ndâ Jùdéyà ŋìnó mbe ùnje gítí bà ꞌvala ndi ndâ ku ꞌdo gbí muuꞌdú ndú lá nó, gí tàkò ndâ tú mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ndú bà-i-nò giì zèè ndú, bìndi  ndú giì kaa ndú mí gbí gbolò zàà. ");
INSERT INTO ndz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Káa o mâ giì bèè gî, basìlì mì Mbíṛì giì njaanga njekèjì zàà tàkò ndú, bìndi  yí giì kaa ndú gí sè. ");
INSERT INTO ndz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Yí giì ꞌdè có ji ndú máa, «Yo njè nó ya gí gbí ndùgù ꞌbá-Mbíṛì, wàa yo ꞌví ma có gítí ngú ŋa ꞌválá tí nó ji ndâ ꞌduù.» ");
INSERT INTO ndz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ndâ tú mì Jézù giì njè nó ya gí gbí ndùgù ꞌbá-Mbíṛì, bìndi  ndú giì ꞌbìtà bà ma có ji ndâ ꞌduù si yé kû bàkà bà ngbaṛanga to. Yé mâ giì too gî, ndâ Kùṛo ndâ bu-Mbíṛì, ta ndâ ꞌduù mì wó, ta ndâ kpo ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà, giì kili muu ndú ta ndâ kpo-kpò ꞌduù mì ndâ Ìzìrìyélì ꞌdáá gî. Ndú bà-i-nò giì tuu tú ya tí  gí gbí zàà, máa, à kaa ndâ tú mì Jézù kà nó gì tí  gí gbí ngbàngà kùṛo ndâ yì. ");
INSERT INTO ndz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ndâ kùṛo ndâ mbe kpolo tí ndâ ꞌduù gbí zàà tí nò náa a tuu ndú nò mâ giì yee gbí zàà kà, ndú giì ꞌde ndâ tú mì Jézù tàꞌi lá. Bìndi  ndú giì dele ndi ndú ya gí bà ꞌdè có ji ndâ kpo-kpò ꞌduù tí nó mbe tuu ndú nó, máa, ");
INSERT INTO ndz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Ze ꞌde njekèjì nè tí ṛítí-ṛítí gî, ta ndâ mbe ù njekèjì zàà kuu gbí nèté mì ndú, káa, ze mâ giì njaanga njekèjì, ze giì ꞌde gbèe ꞌduù tàꞌi kà lá.» ");
INSERT INTO ndz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ndâ Kùṛo ndâ bu-Mbíṛì, ta kùṛo ndâ mbe kpolo tí ꞌbá-Mbíṛì, mâ giì ꞌdi có tí nò, muu ndú giì eṛe tí gítí ŋa i tí nò mbe bàkà tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Káa ndú mâ giì zekeꞌo, ndú giì ŋò ꞌbí ꞌdakò yee tí ndú ta ngú có énó máa, «Ye ŋò ndâ ꞌdakò tí nó náa yo zèè ndú mí gbí zàà nó kû nìbà i ji ndâ ꞌduù gbí ndùgù ꞌbá-Mbíṛì kàzô.» ");
INSERT INTO ndz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Gbolò ꞌduù kùṛo ndâ mbe kû kpolo tí ꞌbá-Mbíṛì mâ giì ꞌdi có tí nò, yí giì ṛuka ndâ ꞌbí ꞌduù mì wó, bìndi  ndú giì ya ta ndú gí bà kaa ndâ tú mì Jézù gbí pétékè có gì tí  gí kùṛo ndâ kpo ꞌduù gbí ngbàngà. À tí ndâ mbe kpolo tí ꞌbá-Mbíṛì ta o tí nò a gúku énó máa, ndâ yì má gbùṛùngà ndâ tú mì Jézù, ndâ ꞌduù bà ꞌvaka ndâ yì ta díí. ");
INSERT INTO ndz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ndâ mbe kû kpolo tí ꞌbá-Mbíṛì mâ giì yee ta ndâ tú mì Jézù kùṛo ndâ kpo ꞌduù mì ndâ Jùdéyà gî, Kùṛo ndâ bu-Mbíṛì giì do mítí ndú, ");
INSERT INTO ndz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","máa, «Ze táánò ci yo kpolo ma, máa, ndòngbú tí yo ta bà nìbà i ji ndâ ꞌduù ta ṛè ꞌdakò tí nò ꞌví dù ká yí  nò. Káa, sè tù ꞌduù kpónó Jèrùzàlémè nó mbe ꞌdi bà nìbà i mì yo lá nò wálá. Ze delè giì ŋò goòlá yo eṛe muu yo mítí có bà kaa ndeṛè có ku ꞌdakò tí nò mí muu ze gî nô! À má énò, yo ꞌdè ndeṛè ŋa nèté mì yo nò ji ze.» ");
INSERT INTO ndz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Káa ndâ Pìyétòrò ta ndâ ꞌbí ka wó tú mì Jézù giì ꞌvìsì có ji ndâ kpo ꞌduù gbí ngbàngà, máa, «Ze bà ꞌdi kpédélé kùṛo a có mì Mbíṛì má kózò gî, ze ꞌví giì ꞌdi có mì ndâ ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Àá táánò a Mbíṛì mì ndâ ká gù ze ká ꞌvala ndi Jézù ꞌdo gbí muuꞌdú wó, káa a yo táánò ká zi yí ta bà gbì yí mítí njèèkpè mû. ");
INSERT INTO ndz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Káa Mbíṛì kpónó giì te yí mí gbí kùꞌbì mì wó tí Mbíṛì, máa, yí dù tí kùṛo ndâ ꞌduù, wàa yí delè ꞌví dù tí mbe ꞌvala ndâ ꞌduù, tí mbe ꞌvìsì muu ndú ꞌdo tí ndâ vò kpokèjì mì ndú gítí kpokèjì mì yì tí Mbíṛì, tí ꞌduù tí nó náa Mbíṛì bà je à-cee-gî gítí ndâ vò i mì ndâ Ìzìrìyélì ꞌdáá gî a i ta ṛè wó nô. ");
INSERT INTO ndz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ze a ndâ mbe ꞌdè yúcó gítí ndâ i tí nò, ze ta ndâ Bèṛi-mì-Mbíṛì, tí i-nambeè tí nó náa Mbíṛì kû je ji ndâ ꞌduù ŋìnó mbe ꞌdi có mì wó tí Mbíṛì nô.» ");
INSERT INTO ndz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Có tí nò náa ndâ tú mì Jézù ꞌvìsì nò giì dù goòlá ndú cu a wu mítí ndâ kpo ꞌduù gbí ngbàngà mì ndâ Jùdéyà. Tacó énò, ndú giì bàkà a có bà ziki ndâ tú mì Jézù gítí có tí nò. ");
INSERT INTO ndz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ꞌBí kpo ꞌduù ꞌdo gbí òkò tí ndâ ka wó gbí gbolò ngbàngà mì ndâ Jùdéyà, tí mbe kpolo tí tàkìì mì ndâ Jùdéyà, ta ṛè wó a Gàmàlìyélì, tí gbolò mbe kû nìbà tàkìì mì ndâ Jùdéyà ji ndâ ꞌduù, náa ndâ Jùdéyà ꞌdáá gî kû te duù mítí wó, mâ giì ŋò ndâ có mì ndâ ꞌbí ka wó kpo ꞌduù gbí ngbàngà zò muu wó dúú-dúú lá, yí giì a gí yaà, bìndi  yí giì ꞌdè có ji ndú énó máa, à kaa ndâ tú mì Jézù ꞌdo gbí ngbàngà gí ndiì gàà kózò gi. ");
INSERT INTO ndz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","À mâ giì bàkà go có mì wó nò gî, yí giì ꞌdè có ji ndâ ka wó kpo ꞌduù gbí ngbàngà, máa, «Ndâ ꞌdakò! Yo kpolo tí yo tí kpoò gítí ŋa i tí nó náa yo kû koṛo có gítí bà bàkà ta ndâ ꞌduù tí nó nô. ");
INSERT INTO ndz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ye kû ꞌdè có tí nó ji yo, tacó ye ki ꞌbì ye gítí ndâ mbe bàkà ŋa i tí nò náa ndâ ꞌdakò tí nò kpónó kû bàkà nò kí-ki; ꞌbí ꞌdakò dígísèé ta ṛè wó a Tèwùdásì, luguu tí wó máa, yì ma. Bìndi  ndâ ꞌduù go ziꞌduù-vô ta bà  nàꞌô (400) ká giì tè gí tàkò i-mâ mì wó nò. À mâ giì zi Tèwùdásì gî, ndâ ꞌduù mì wó nò giì ꞌvaaka gbaànjé-gbaànjé ꞌdáá gî. À giì dù maa nò a bà zi nje ndú ká nò. ");
INSERT INTO ndz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bìndi Tèwùdásì nò, ꞌbí ꞌdakò ta ṛè wó a Júdà, tí ꞌduù Gàlìléyà, dígísèé gbí o bà ꞌdeke muu ndâ ꞌduù nó giì jèjèèkè cèe tí wó, máa, ndâ ꞌduù ꞌví ŋò a yì, si Mbíṛì mí to. Ndâ ꞌduù giì ki gí tàkò wó kí-ki. À mâ giì zi yí delè gî, ndâ ꞌduù mì wó giì taꞌva léé gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","«À má énò, có mì ye gbí njembí ye ji yo kpónó máa, yo si ndâ ꞌdakò tí nò mí bàndò mì ndú. Yo si ndú ꞌví ya . Tacó ṛèngbó i tí nò náa ndú kpónó kû bàkà nò má ꞌbì ꞌdo mì ꞌduù, nje  bà zi ta kpéétí wó. ");
INSERT INTO ndz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Káa, à má dú káa yúcó máa, nèté tí nò náa ndú kû bàkà nò a nèté mì Mbíṛì, yo bà kpò ndú wálá. Yo delè bà ꞌde tí yo kû jòò gbí có a i ta Mbíṛì.» Có tí nò náa Gàmàlìyélì ꞌdè nò giì ya gí gbí muu ndâ ꞌbí ka wó kpo ꞌduù gbí ngbàngà gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ndú bà-i-nò giì tèꞌé tí ndâ tú mì Jézù gí kùṛo ndú. Ndú mâ giì gbì ndú gî, ndú giì ci ndú, máa, «Ndòngbú tí yo ta bà ma có ji ndâ ꞌduù ta ṛè Jézù ꞌví dù ká yí  nò.» Bìndi  ndú giì dò ꞌbì ꞌdo tí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ndâ tú mì Jézù giì njè nó ꞌdo kùṛo ndâ kpo ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà ta pétékè tàkòcò ndú, tacó Mbíṛì ŋò ndú ꞌvii tí ndâ ꞌduù mbe kònò séꞌi ta ṛè Jézù gî. ");
INSERT INTO ndz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ꞌDo gbí ṛi tí nò, ndâ tú mì Jézù giì dù kû ma Banga-Ngú-Có ji ndâ ꞌduù ta ṛi ꞌdáá gî gbí ndùgù ꞌbá-Mbíṛì, delè ta ndi ꞌbá mì ndâ ꞌduù, máa, Jézù a Bìndi-Mbíṛì, ta ꞌbí ꞌduù mbe tù ꞌbì wó gí tà ṛo ndú gbaànjé wálá. ");
INSERT INTO ndz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Muu ndâ mbe tala có mì Jézù mâ giì ꞌbìtà bà àdì gî, gbínje giì ꞌbìtà bà bàkà tí gbí òkò tí ndâ Jùdéyà ŋìnó náa a jò ndú me mí ꞌbá Jùdéyà lá, mbe kû ꞌdè káa có Ìgìrígì nó, ta ndâ jígíꞌdí-jìgìꞌdì Jùdéyà á ꞌdo muu có bà njèè i-zó-zò. Ndâ Jùdéyà ŋìnó náa a jò ndú mí ndiì nó giì ꞌbìtà bà ꞌdè kòlòwò, máa, ndâ jígíꞌdí-jìgìꞌdì Jùdéyà ta ṛi ꞌdáá gî njèè i-zó-zò ji ndâ nawù ku mì ndâ yì yè ṛo ndâ yì lá. ");
INSERT INTO ndz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ndâ tú mì Jézù muuꞌbì-nje só mâ giì ꞌdi có tí nò, ndú giì kili ndâ mbe tala có mì Jézù ꞌdáá gî, bìndi  ndú giì ꞌdè có ji ndú máa, «Bà jee bà ma có mì Mbíṛì mì ze mí to, wàa ze ꞌví zèè tí kpoò a nèté bà njèè i-zó-zò me dú tacó tí ze lá. ");
INSERT INTO ndz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","À má énò, à nìkì énó máa, yo tí ndâ náꞌvindí ze ŋò ndâ ꞌbí ꞌdakò vô-nje só ꞌdo gbí òkò tí ndâ ꞌduù ŋìnó ta tó ṛè ndú nó, ndú delè ꞌví dù tí ndâ ꞌduù ŋìnó náa Bèṛi-mì-Mbíṛì je wotí ji ndú me gbolò, delè tí ndâ ꞌduù ŋìnó mbe ꞌdi gbí-o nó, tacó wàa, ze ꞌví bàkà ndú tí ndâ mbe njèè i-zó-zò. ");
INSERT INTO ndz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wàa, o mì ze ꞌví dù ꞌdáá gî ká gítí bà ꞌdeke tí ze ji Mbíṛì, ta nèté bà ma có mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tàkòcò ndâ mbe tala có mì Jézù ꞌdáá gî giì peteke gítí có tí nò náa ndâ tú mì Jézù koṛo nò ngé ndii gî. Tacó énò, ndú giì cu ꞌbì ndú mítí Ìsìtéfànò tí ꞌbí ꞌdakò mbe tee njembí wó ꞌdáá gî mítí Mbíṛì, tí ꞌdakò náa Bèṛi-mì-Mbíṛì je wotí ji yí me gbolò, giì je Fìlípò, giì je Pòròkórù, giì je Nìkànórà, giì je Tímònì, giì je Pàràménà, giì je Nìkòláwù tí ꞌbí ꞌdakò náa ŋa wó me Jùdéyà lá mbe gì ꞌdo gbí gbata Àndìyókì, mbe kaa tí wó gí gbí tàkìì mì ndâ Jùdéyà kùṛo bà gì yí tí mbe tala có mì Jézù gî. ");
INSERT INTO ndz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ndú giì kaa ndú ta bà muu ndú vô-nje só nò ji ndâ tú mì Jézù. Ndâ tú mì Jézù mâ giì ꞌdeke tí ndú ji Mbíṛì tacó tí ndú gî, ndú giì bàkà ndú tí ndâ mbe njèè i-zó-zò ji ndâ ꞌduù bìndi ndú. ");
INSERT INTO ndz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Có mì Mbíṛì giì dù kû ṛèjì bìndi bà ꞌviindi có gítí bà njèè i-zó-zò nò tí ŋa ŋìnó náa muu ndâ mbe tala có mì Jézù giì ògbù gbí gbata Jèrùzàlémè ngé ndii gî. Ndâ ꞌduù me mbè ꞌdo gbí òkò tí ndâ bu-Mbíṛì mì ndâ Jùdéyà delè giì ꞌbìtà bà ṛu ndi kpokèjì mì Bìndi-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mbíṛì giì bàkà nambeè ji Ìsìtéfànò tí ꞌbí ꞌduù gbaànjé ꞌdo gbí òkò tí ndâ ꞌduù tí nó vô-nje só náa à ṛuka ndú tí ndâ mbe njèè i-zó-zò nó ngé ma, ta bà je wotí bà bàkà ndâ kpo-kpò seṛè mí gbí òkò tí ndâ ꞌduù ji yí. ");
INSERT INTO ndz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ndâ ꞌbí ꞌduù ꞌdo gbí òkò tí ndâ Jùdéyà mâ giì ŋò ndâ i tí nò náa Ìsìtéfànò kû bàkà nò, ndú giì ꞌbìtà bà jòò gbí có ta yí. Ndâ ꞌbí Jùdéyà tí nò mbe kaa ya gí bà jòò gbí có ta Ìsìtéfànò nò gì ꞌdo bàndò bà kili ndâ Jùdéyà ŋìnó náa à kû nì mítí  a «Bàndò bà kili ndâ i-zógó-zogo ŋìnó náa a njaanga wú ꞌdo tí miṛi ndú gî» nô, ndâ ꞌbí  gì ꞌdo gbí gbata Sìrínì, ndâ ꞌbí  gì ꞌdo gbí gbata Àlèsàndèríyà á gbí to Másìrì, ndâ ꞌbí  gì ꞌdo gbí to Sìlísìyà, ndâ ꞌbí  gì ꞌdo gbí to Ásìyà. ");
INSERT INTO ndz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Káa bà ꞌvii tí ndú ta Ìsìtéfànò giì kpò ndú gî, tacó yí ꞌdi gbí-o ndii ndú me ꞌdú, delè tacó a Bèṛi-mì-Mbíṛì ká kû wu có mí gbí nje wó. ");
INSERT INTO ndz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ndú mâ giì ŋò énò, ndú giì sì ndâ ꞌbí ꞌduù tàbèngìì máa, ndú waaka có ta ṛè Ìsìtéfànò énó maa, «Ze ꞌdi kòcò ꞌdakò tí nó tí Ìsìtéfànò nó kû ꞌdè zu có gítí ndâ Mòze ta Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ŋa có tí nò, máa, Ìsìtéfànò kû ꞌdè zu có gítí ndâ Mòze ta Mbíṛì nò, mâ giì ꞌva tí gbí tù ndâ Jùdéyà, ta ndâ kpo-ꞌduù-ꞌbá mì ndú, ta ndâ mbe kpolo tí tàkìì mì ndú, ndú giì zèè Ìsìtéfànò ya tí  gí gbí gbolò ngbàngà mì ndú tí ndâ Jùdéyà. ");
INSERT INTO ndz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ndú mâ giì yee ta yí kùṛo ndâ kpo ꞌduù mì ndú gbí ngbàngà gî, ndú giì waaka ndâ ꞌvéṛè gítí wó ji ndú, máa, «ꞌDakò tí nó kuu nó ta o ꞌdáá gî kû ꞌdè vò có gítí ꞌbá-Mbíṛì mì ndoo ji ndâ ꞌduù, yí delè kû ꞌdè vò có gítí tàkìì mì ndoo. ");
INSERT INTO ndz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ze zèè yí kû ꞌdè có ji ndâ ꞌduù énó máa, ꞌdakò tí nó tí Jézù mbe gì ꞌdo Názàrètì nó kèjì gí bà kiꞌviki ꞌbá-Mbíṛì mì ndoo nó gí to. ꞌBí kòcò wó mbe giì ꞌva tí gbí tù ze delè a ŋìnó máa, ní gbèe Jézù tí nò a mì yì nò delè kèjì gí bà ꞌvìsì tàkìì tí nó náa Mòze dígísèé je ji ndâ ká gù ndoo, náa ndú giì ꞌdòkò kpòò yee tí  tí ndoo nó gî.» ");
INSERT INTO ndz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ndâ kpo ꞌduù gbí ngbàngà mì ndâ Jùdéyà ꞌdáá gî giì zeke gbí ṛo Ìsìtéfànò ngbóó gítí có tí nò náa ndú ꞌdi ta ṛè wó nò. Káa, ta o tí nò náa ndú kû zeke ta o gbí ṛo wó nò, ndú giì ŋò gbí ṛo wó kû tòngbaà go gbí ṛo basìlì mì Mbíṛì nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ndâ kpo ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà mâ giì ꞌdi kòcò ndâ mbe kpì ngbàngà tí Ìsìtéfànò cee gî, Kùṛo ndâ bu-Mbíṛì, tí gbolò ꞌduù kùṛo ndâ kpo ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà ꞌdáá gî, giì ꞌvee Ìsìtéfànò, máa, «Ndâ có tí nò náa ndâ ꞌduù tí nò ꞌdè gítí lo nò a yúcó?» ");
INSERT INTO ndz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Káa Ìsìtéfànò giì ꞌvìsì có ji yí máa, «Ákoo ndâ náꞌvindí ye! Ákoo ndâ bu ye! Yo sè tù yo, wàa yo ꞌví ꞌdi có mì ye náa ye kpónó kèjì gí bà ꞌdè ji yo nô. Mbíṛì tí nó mbe kû tòngbaà ngbèzèè nó dígísèé tùbà tí wó ji bu ndoo tí Àbìráámò si yí ta ꞌbá gbí to Mèsòpòtámìyà á kùṛo bà ꞌdòkò ꞌbá mì wó gí gbí gbata Àránì. ");
INSERT INTO ndz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Bìndi  yí giì ꞌdè có ji yí énó máa, ‹Njè nó ꞌdo ꞌbá mì yo gî. Co ꞌdo gbí òkò tí ndâ nambe lo, wàa wò ꞌví ya gítí to tí nó náa ye bà tùbà  ji wò nô.› ");
INSERT INTO ndz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Àbìráámò bà-i-nò giì ꞌdòkò ꞌbá ꞌdo gbí òkò tí ndâ nambe wó gbí to mì ndâ ꞌduù Kàlìdíyà go có mì Mbíṛì nò, ya gí gbí gbata Àránì. Bu Àbìráámò mâ giì cì gî, Mbíṛì giì ꞌdè có ji yí máa, yí ꞌdòkò ta ꞌbá gì gí bàndò tí nó náa yì tí Mbíṛì táánò ci yí gítí , náa yo wúnó kû ꞌvala tí  nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Káa Mbíṛì ta o tí nò waa ꞌbí làmbu to kpêtí ká ꞌváṛá énó ji Àbìráámò tí ꞌdóó ŋìndi wó gítí miṛi wó lá. Mbíṛì giì ci Àbìráámò a i énó máa, ‹Ye tí Mbíṛì bà je to tí nó ji yo ta ndâ ꞌviì bìndi lo.› «Gbèe ꞌviì go mè gbí u tì nó ta o tí nò, náa Mbíṛì ci tí  ta Àbìráámò nò, mì Àbìráámò wálá. ");
INSERT INTO ndz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Káa ꞌdóó kòcò Mbíṛì ji Àbìráámò ta o tí nò énó máa, ‹Ndâ ꞌviì-gù lo bà dù tí ndâ mbe ꞌdó-ꞌdo á ꞌbá mì ndâ tende ŋa ndâ ꞌduù. Ndâ tende ŋa ndâ ꞌduù tí nò bà giì bàkà bòò mítí ndú, ndú bà toṛo nje ndú ta to ta ndoò ziꞌduù-vô ta bà  nàꞌô (400). ");
INSERT INTO ndz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Káa, a ye tí Mbíṛì ká bà waa có mítí ndâ ꞌduù tí nò á muu ndú. Bìndi  ndâ ꞌduù mì ye bà gì ꞌdo ꞌbá mì ndâ kuꞌdì gí bà bàkà i ji ye tí Mbíṛì á mí bà-i-nô.› ");
INSERT INTO ndz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mbíṛì giì ꞌdè có ji Àbìráámò máa yí ya gí gbí gàzâ tacó bà tùbà  máa ndâ yì tí Mbíṛì toko nambeè ta yí gî. Tacó énò, Àbìráámò mâ giì jò Ìzákò, yí giì waa yí ta sili vô-nje taꞌô bìndi bà jò yí. Ìzákò mâ giì jò Jàkóbè, yí delè giì bàkà ká énò. Jàkóbè delè giì bàkà ká énò mítí ndâ ꞌviì mì wó muuꞌbì-nje só tí ndâ ṛèngbó mbe jò ndâ ŋa ndâ Ìzìrìyélì muuꞌbì-nje só nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Káa ndâ ꞌbí ꞌviì mì Jàkóbè giì sì náꞌvindí ndú Jùzépè gí ꞌdè tí bòò ji ndâ ꞌduù ya tí  gí Másìrì ta kiì gî. Káa Mbíṛì ta o tí nò kuu tàkò Jùzépè. ");
INSERT INTO ndz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Yí giì ŋò yê ṛo wó, yí giì je muu ji yí tí ŋa ŋìnó náa go có mì wó giì dù tí Fàràyónè (gbí  máa, gbolò gba mì ndâ ꞌduù Másìrì) ngé ma. Tacó énò, yí giì te Jùzépè tí kùṛo ndâ kpo-kpò ꞌduù mì wó Másìrì ꞌdáá gî, delè tí mbe kpolo tí ndâ ꞌduù, ta ndâ ꞌdóó i-ꞌbá mì wó tí gbolò gba. ");
INSERT INTO ndz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Ta o tí nò náa Jùzépè kuu tí  Másìrì nò, làngàwìṛí giì tè to. Ndâ ꞌduù Másìrì ta ndâ ꞌduù Kánànì giì zeꞌveṛe ta go zéꞌvéṛè-zéꞌvéṛè. Ta o tí nò, làmbu ꞌbí i tacó bà ṛo mítí tì ndâ ká gù ndoo ngé énó gî wálá. ");
INSERT INTO ndz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jàkóbè mâ giì ꞌdi có cû gí Másìrì, yí giì tuu ndâ ká gù ndoo gí kà. ");
INSERT INTO ndz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Gbí kpédélé nó mì ndú nò, Jùzépè tùbà tí wó ji ndú lá. Yí giì tùbà tí wó ji ndâ náꞌvindí wó a i gbí bà só bà ya ndú gí Másìrì, bìndi  yí giì tù ta bà tí ndú ji gbolò gba mì ndâ ꞌduù Másìrì. ");
INSERT INTO ndz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jùzépè bà-i-nò giì tuu tú gí tàkò bu wó Jàkóbè, ta ndâ sè náꞌvindí wó, ta ndâ ꞌviì mì ndú ꞌdáá gî. Muu ndâ kòtí Jàkóbè ta o tí nò ꞌdáá gî a ndâ ꞌduù ziꞌduù-taꞌô-nje muuꞌbì nje-muuꞌbì vô (75). ");
INSERT INTO ndz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ndâ Jàkóbè ta ndâ ká gù ndoo giì mìì ꞌdáá ká mí Másìrì, ");
INSERT INTO ndz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","káa a duu ndú mí kà lá. À tuṛu ku ndú ya tí  gí bà duu a i mí ꞌbá bìndi ndú gbí gbata Sèkímì mítí ꞌbí bàndò bà duu ku náa Àbìráámò sì ꞌdo mì ndâ ꞌviì mì Àmórà tí bu Sèkímì. ");
INSERT INTO ndz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«O bà bàkà go cí tí nó náa Mbíṛì ci ta Àbìráámò kácá-kácá nó mâ giì dooko gî, ndâ ꞌduù mì ndoo giì jò àdì mí Másìrì ndii ŋìnó sàà kùṛo nó gî. ");
INSERT INTO ndz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ta o tí nò, ꞌbí ngú gbolò gba mbe ŋò Jùzépè ni lá giì le bèṛè mì ndâ ꞌduù Másìrì. ");
INSERT INTO ndz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ngú gba tí nò giì peṛe ndâ ká gù ndoo péṛé-peṛe. Yí mèèkèꞌi tí ndâ ká gù ndoo ta bà ꞌvaka ndâ dó ꞌviì mì ndú ꞌdo ꞌbì ndâ nawu ndú gí ꞌdè, tacó wàa ŋa ndú ꞌví mìì gî. ");
INSERT INTO ndz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ŋìnò a gbèe vò o tí nó náa à jò Mòze gbí  nô. À me ŋa banga tí lo tí dó ꞌviì á gbí ṛo Mbíṛì lá! Ndâ nawu Mòze giì ngùù yí mí tàꞌi ta pì taꞌô. ");
INSERT INTO ndz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bà ngùù yí mâ giì kpò ndâ nawu wó gî, ndú giì te yí gí sè ꞌdo tàꞌi. Nájú gbolò gba mì ndâ ꞌduù Másìrì bà-i-nò giì ꞌde yí. ꞌVinî tí nò giì te yí, bìndi  yí giì ko yí kpolo tí ꞌdóó ꞌviì mì wó. ");
INSERT INTO ndz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","À giì kpolo yí ta bà nìbà bà ꞌdi gbí-o mì ndâ ꞌduù Másìrì ꞌdáá gî ji yí, bìndi  yí giì gì tí gbolò muu-có, delè tí gbolò mbe bàkà ndâ i. ");
INSERT INTO ndz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Mòze mâ giì gì tí ꞌdakò ta ndoò tí wó ziꞌduù-só gî, yí giì koṛo có bà co wiṛi ya gí mì ndâ nambe wó tí ndâ Ìzìrìyélì. ");
INSERT INTO ndz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yí mâ giì ya gí mì ndâ nambe wó, yí giì ŋò ꞌbí ꞌduù Másìrì kû mèèkèꞌi tí ꞌbí Ìzìrìyélì. Yí giì yuu tí wó gí gbí có tí nò, bìndi  yí giì zi ꞌduù Másìrì tí nò muu nambe wó Ìzìrìyélì tí nò gî. ");
INSERT INTO ndz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mòze ta o tí nò si énó máa, ndâ nambe yì ŋò ni gî máa, a Mbíṛì ká tuu yì gí bà njaanga wú ꞌdo tí miṛi ndú. Keèlá, ŋa có tí nò gbí muu ndú wálá. ");
INSERT INTO ndz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«Ta ꞌbí yé bìndi ŋìnó, Mòze giì ꞌde ndâ ꞌbí nambe wó tí ndâ Ìzìrìyélì kû bàkà gbínje gbí òkò tí ndú. Yí giì jè ta bà ꞌviindi gbí òkò tí ndú ta bà ꞌdeke tí wó ji ndú, máa, ‹Ákoo, ndâ náꞌvindí ye! Yo kû mèèkè tí yo gbí òkò tí yo ta kpéétí yo énò á gítí có yè, ndâ nambe ye?› ");
INSERT INTO ndz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«Káa ꞌduù tí nó mbe kû mèèkèꞌi tí ka wó nó giì mò Mòze ꞌdo gbí òkò tí ndú gî. Bìndi  yí giì ꞌvee yí máa, ‹A ꞌdi ká bàkà wò tí gba mbe waa có mì ze? ");
INSERT INTO ndz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","À tí lo nò a go bà zi ye á go ŋìnó náa wò zi ta ꞌduù Másìrì tí nó yáánó nó?› ");
INSERT INTO ndz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Có tí nò náa ꞌdakò tí nò ꞌdè nò giì te gúku mítí Mòze, bìndi  yí giì fa ta ꞌbá ꞌdo Másìrì ya gí gbí to Mádìyàmì, bìndi  yí giì jò ndâ ꞌviì sósòꞌô mí kà. ");
INSERT INTO ndz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Ta ꞌbí o gbaànjé, basìlì mì Mbíṛì giì tùbà tí wó ji Mòze gbí ngba wu mbe ku doo ꞌbí bèꞌi á gbí kángáá nga ngoò á dê ta Gú Sínàyì si ndoò tí Mòze ziꞌduù-só bìndi bà fa yí ꞌdo Másìrì. ");
INSERT INTO ndz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nje Mòze giì ꞌdèè ta bà ŋò ŋa i tí nò gî. Yí mâ giì yèè dê, tacó wàa yì ꞌví ꞌviiki i tí nò nìkì maa, yí giì ꞌdi kòcò Mbíṛì kû ꞌdè có ji yí máa, ");
INSERT INTO ndz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ye a Mbíṛì mì ndâ ká gù lo: Ye a Mbíṛì mì Àbìráámò, ye a Mbíṛì mì Ìzákò, ye a Mbíṛì mì Jàkóbè.› Bà zekeꞌo giì kpò Mòze gî, yí giì dù kû gu kpùṛù-kpùṛù ta gúku. ");
INSERT INTO ndz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Káa, Mbe tí ndoo giì ꞌdè có ji yí máa, ‹Jaka ndâ tàmà ꞌdo tí kò lo gî, tacó à kaa bàndò tí nò náa wò kû ṛò tíyò tí  nò ji ye tí Mbíṛì gî. ");
INSERT INTO ndz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ye tí Mbíṛì ŋò bà mèèkèꞌi tí ndâ ꞌduù mì ye á Másìrì gî. Ye ꞌdi mélè muu ndú gî. Tacó énò, ye gì nó gí bà ꞌvala ndú. À má énò, gì kpónó, wàa ye ꞌví tuu wò ji ndú Másìrì kà.› ");
INSERT INTO ndz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Mbíṛì táánò tuu ji ndâ Ìzìrìyélì nò káa gbèe Mòze tí nó náa ndú tí ndâ Ìzìrìyélì táánò ꞌvèè-gbí-nje wó énó máa, ‹A ꞌdi ká bàkà wò tí gba mbe waa có mì ze?› nó, gí bà dù tí kùṛo ndú tí mbe ꞌvala ndú, ta bà tuu basìlì mì wó tí Mbíṛì ji yí gbí bèꞌi. ");
INSERT INTO ndz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","«Mòze giì bàkà ndâ seṛè ta ndâ kpo-kpò i mí Másìrì, delè mí tàbèꞌdè gbolò ngo tí nó náa à kû nì mítí  a Bí-bi Kàpá nô. Ŋìnò a gbèe Mòze tí nó dígísèé mbe tè kùṛo ndâ Ìzìrìyélì gbí kángáá nga ngoò ta ndoò ziꞌduù-só nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","À delè dígísèé káa gbèe Mòze tí nò ká ꞌdè có ji ndâ Ìzìrìyélì énó máa, ‹Mbíṛì bà bàkà ꞌbí mbe ꞌdòkò có mì wó á go ye nó ji yo á ꞌdo gbí òkò tí ndâ ꞌdóó náꞌvindí yo,› nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ŋìnò a gbèe Mòze tí nó dígísèé mbe dù tí mbe ꞌdòkò có gbí òkò tí ndâ ká gù ndoo ta ndâ basìlì tí nó mì Mbíṛì mbe ꞌdòkò có ji yí pí Gú Sínàyì nô. À giì dù káa gbèe yí tí Mòze tí nó náa Mbíṛì dígísèé ꞌdè ndâ có mì wó tí Mbíṛì, tí ndâ có mbe kû ꞌvala ndâ ꞌduù nó, ji yí, bìndi  yí giì ꞌdè ndí  ji ndâ ká gù ndoo, náa ndâ ká gù ndoo giì ꞌdòkò ndí  kpòò yee tí  tí ndoo nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ŋìnò a gbèe Mòze tí nó dígísèé náa ndâ ká gù ndoo biya bà ꞌdi có mì wó si ndú gbí kángáá nga ngoò gî, ndú mâ giì mò yí ꞌdo kùṛo ndú gí nje seè gî, à giì dù gbí muu ndú ta o tí nò kpolo ma a có gítí bà dele ndi ndú gí Másìrì nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ŋìnò a gbèe Mòze tí nó náa ndâ ká gù ndoo dígísèé mâ giì biya yí si ndú gbí kángáá nga ngoò gî, ndú giì ꞌdè có ji Àrónì tí náꞌvindí wó, máa, ‹Bàkà ndâ ꞌbí mbíṛì ji ze, wàa ndú ꞌví tè kùṛo ji ze, tacó ze ꞌdi gbí có mì Mòze tí nó tí mbe kaa ze ꞌdo Másìrì gì tí  gí nó nó lá› nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","«Ŋìnò a o tí nó dígísèé náa ndâ ká gù ndoo giì suu ta ꞌviì-mòꞌdú, bìndi  ndú giì dù kû ci mbelè ji i tí nó náa à káa ndú ká suu ta ꞌbì ndú nó ta cèe pétékè tàkòcò ndú nô. ");
INSERT INTO ndz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tacó énò, Mbíṛì giì ꞌvìsì kapí wó gítí ndú gî, yí giì si ndú tí ndâ mbe bàkà i ji ndâ bààcì mì ndú tí ndâ yii, á go có tí nó náa à cu mí gbí wáràgà mì ndâ mbe ꞌdòkò có mì Mbíṛì máa, Mbíṛì máa, ‹Yo táánò waaka ndâ nò tacó wàa yo ꞌví ci ji ye gbí ndâ ndoò tí nó náa yo táánò too ziꞌduù-só mí gbí kángáá nga ngoò nó gî, ndâ Ìzìrìyélì? ");
INSERT INTO ndz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yo táánò kaa kû nò tí  a ndâ i tacó bà tò ta ndùúṛù ji sú mbíṛì mì yo ta ṛè wó a Mòlókì nó, giì je yii tí nó tí Rèfánì nô. Yo te a ndâ sú mbíṛì mì yo náa yo ká suu ndú ta ꞌbì yo, yo giì nò ta bà bàkà i ji ndú. À má énò, ye bà kaa yo ya tí  gí gbí ꞌdú to mbe ndii ŋìnó gî ngéé kapí Bàbìlónìyà.› ");
INSERT INTO ndz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Ndâ ká gù ndoo dígísèé gbí kángáá nga ngoò giì tò ndùúṛù náa a Mbíṛì ká ꞌvii wú bà ka bà  ji ndú, bìndi  ndú giì te díí tí nó náa Mbíṛì cu ndâ có mì wó muuꞌbì mítí  ji Mòze nó mí tà . ");
INSERT INTO ndz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ndâ ká gù ndoo giì ꞌdòkò wú bà ka bà ndùúṛù tí nò náa Mbíṛì je ji ndú nò kpòò yee tí Jósùwà, tí mbe giì ya tí  gí gbí to tí nó náa ndú táánò mòkò ndâ mbe  ta wotí mì Mbíṛì ꞌdo gbí  gî, bìndi  ndú giì zogo nô. Ndùúṛù tí nò giì dù tí to tí nó yee gbí o mì Dàvídè tí gbolò gba mì ndoo, ");
INSERT INTO ndz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","náa tàkòcò Mbíṛì táánò peteke gítí wó, káa yí giì ꞌdeke tí wó ji Mbíṛì, máa, yí si yì ꞌví gèè ꞌbá-Mbíṛì ji Mbíṛì mì Jàkóbè. ");
INSERT INTO ndz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Káa à giì gèè ꞌbá-Mbíṛì a Sólómònì tí ꞌviì bìndi Dàvídè. ");
INSERT INTO ndz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kpêtí ká énò, Mbíṛì ꞌvala tàꞌi tí nó náa a ꞌduù ká bì ta ꞌbì wó nó lá. Jé ká go có tí nó náa ꞌbí mbe ꞌdòkò có mì Mbíṛì ꞌdè énó máa, Mbíṛì máa, ");
INSERT INTO ndz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Ṛì a jàlàmbà mì ye, bìndi  to tí nó a bàndò bà kaa kò ye. Yo bà bì ji ye a ŋa ꞌbá yè? Yo bà bàkà ji ye a ŋa bàndò yè, wàa ye ꞌví dù tí ? ");
INSERT INTO ndz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Àá táánò me ye ká bàkà ndâ i tí nó ꞌdáá gî nó lá?› ");
INSERT INTO ndz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Ndí yo ndâ mbe ngbútù! Ndâ tù-ká-kpò-có! Njembí yo go njembí ndâ ꞌduù ŋìnó mbe ŋò Mbíṛì ni lá nô. Yo ta o ꞌdáá gî kû kpò có mì Bèṛi-mì-Mbíṛì go i mì ndâ ká gù yo. ");
INSERT INTO ndz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yo ni ṛè ꞌbí mbe ꞌdòkò có mì Mbíṛì gbaànjé náa ndâ ká gù yo dígísèé mèèkèꞌi tí wó lá ji ye gi! A ndú dígísèé ká ziki ndâ mbe ma có gítí bà gì ꞌDuù tí nó ta nèté mì wó jáá nô. Káa à kpónó a yo ká giì dù tí ndâ mbe cu gòmbò tí wó, delè tí ndâ mbe zi yí. ");
INSERT INTO ndz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","À giì dù ndí  a yo tí ndâ ꞌduù tí nó náa Mbíṛì tuu ndâ basìlì mì wó ta ndâ có mì wó ji yo nó ká giì dù tí ndâ mbe kpolo tí ndâ có tí nò lá.» ");
INSERT INTO ndz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Có tí nò náa Ìsìtéfànò ꞌdè nò giì doo ndâ kpo ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà go wu, bìndi  ndú giì ṛo ꞌbì ndú ta sé có. ");
INSERT INTO ndz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Káa Bèṛi-mì-Mbíṛì giì je wotí ji Ìsìtéfànò me gbolò, yí mâ giì zekeꞌo lèè gí gbíṛì, yí giì ŋò Mbíṛì ngbèzèè, ta Jézù kû ṛò tíyò mò gí gbí kùꞌbì mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Bìndi  yí giì ꞌdè có ji ndâ kpo ꞌduù, máa, «Ye kpónó kû ŋò njekèjì gbíṛì njaanga tí ngàà gî, bìndi  ꞌViì-mì-ꞌDakò kû ṛò tíyò mò gí gbí kùꞌbì mì Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ndâ kpo ꞌduù gbí gbolò ngbàngà mì ndâ Jùdéyà giì kpò ꞌbì ndú mítí tù ndú kû pìì ta kû ꞌdo tí bà ꞌdi có tí nò mì Ìsìtéfànò nò gî. Ndú giì oloko ta ngèlè ya gítí wó, ");
INSERT INTO ndz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ndú gì ja yí ꞌdo gbí gbata gí sè, bìndi  ndú giì ꞌvaka yí ta díí. Ndâ mbe bàkà tí ndú tí ndâ mbe ꞌdè yúcó gítí Ìsìtéfànò gbí ngbàngà giì jaka ndâ bòngo mì ndú ꞌdo tí ndú gî, bìndi  ndú giì kaa ji ꞌbí ꞌviì-ꞌdakò ta ṛè wó a Sàwúlè tacó bà kpolo tí . Bìndi  ndú giì kaa ya gítí bà ꞌvaka Ìsìtéfànò ta díí, ta sè ndâ ꞌbí ꞌduù. ");
INSERT INTO ndz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Káa ta o tí nò náa ndú kû ꞌvaka Ìsìtéfànò ta díí nò, Ìsìtéfànò giì ꞌdeke tí wó, máa, «Mbe tí ye Jézù, si lilí ye ꞌví ya gí mì lo!» ");
INSERT INTO ndz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yí bà-i-nò giì kucuku muungbó wó mí to, bìndi  yí giì ꞌdeke tí wó ta kòcò wó ngéé gí yaà, máa, «Kaa có vò i tí nó mítí ndú lá, Mbe tí ye!» Ìsìtéfànò ꞌdeke káa tí wó nò gî nó, yí giì cee gî. ");
INSERT INTO ndz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ꞌViì-ꞌdakò tí nó tí Sàwúlè mbe kpolo tí ndâ bòngo mì ndâ mbe zi Ìsìtéfànò nó giì eṛe wúꞌdè có bà zi Ìsìtéfànò nò ngiṛiꞌví gî. Bìndi  bà mèèkèꞌi tí ndâ mbe kû kili ta ṛè mì Jézù gbí gbata Jèrùzàlémè giì ꞌbìtà bà zì ta gbèe ṛi bà zi Ìsìtéfànò nò tí vò ŋa ŋìnó náa sè ndâ ꞌbí mbe ùnje gítí có mì Jézù ꞌdáá gî giì ꞌvaaka ta gúku gbaànjé-gbaànjé ta ndi gbí ndâ gbata gbí ndâ to Jùdéyà, ta ndâ to Sàmárìyà ꞌdáá gî, si káa ndâ tú mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","À káa ndâ ꞌbí tó ꞌduù mbe kû zè Mbíṛì ta tó njembí ká giì duu ku Ìsìtéfànò, bìndi  ndú giì wa yí. ");
INSERT INTO ndz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Káa Sàwúlè giì bàkà a cèe ndi wó tacó bà mìì káa ꞌdóó ndâ mbe kû kili ta ṛè mì Jézù tóꞌdó gî. Yí giì nò cee njekèjì mì ndú gbaànjé-gbaànjé ꞌdáá gî, kû zèè ndâ ꞌdakò ta ndâ niì, náa yí má ꞌde ndú gî nò, ya tí  gí gbí zàà. ");
INSERT INTO ndz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ndâ ꞌduù tí nó mì Jézù mbe ꞌvaaka ta ndi muu to ta gúku bà mèèkèꞌi tí ndú nó giì ꞌvèè ta bà ma Banga-Ngú-Có ji ndâ ꞌduù gbí ndâ to tí nò náa ndú fa ngèlè vò i ya ta ndi tí  nò. ");
INSERT INTO ndz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ꞌBí ꞌduù ꞌdo gbí òkò tí ndú gbaànjé ta ṛè wó a Fìlípò, mbe fa ngèlè vò i tí nò mbe ꞌde ndú nò, ya a i gí gbí ꞌbí gbata gbí to Sàmárìyà, giì dù kû ma có tí Bìndi-Mbíṛì ji ndâ ꞌduù kà. ");
INSERT INTO ndz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ndâ mbè ꞌduù tí nò náa Fìlípò kò-kò ta ṛè Bìndi-Mbíṛì ji ndú nò giì ùnje gítí ndâ có mì Fìlípò ta njembí ndú gbaànjé, tacó ndú ꞌdi tàwo ndâ ꞌbí seṛè ŋìnó náa yí bàkà nó gî, ndú delè giì ŋò ndâ kpo-kpò i ŋìnó náa yí bàkà nó ta ṛo ndú: ");
INSERT INTO ndz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ndâ seṛè bà co ndâ i ta bà tò kû ta kòcò ndú ngéé gí yaà ꞌdo gbí muu ndâ ꞌduù me mbè, delè ta bà ꞌvala ndâ ꞌduù ŋìnó mbe gbeleꞌve gî nó, ta ndâ mbe kû nò gbélè-gbélè nó me mbè. ");
INSERT INTO ndz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tacó énò, tàkòcò ndâ ꞌduù gbí gbata tí nò giì peteke ngé ndii gî. ");
INSERT INTO ndz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ta o tí nò, ꞌbí ꞌdakò ta ṛè wó a Sìmónè, tí mbe kû bàkà ndâ i-yeè, náa bà ꞌdè có gítí ndú kpò nje ndâ ꞌduù gî, kuu ta ꞌbá gbí gbata tí nó náa Fìlípò kû dù gbí  nò. Sìmónè tí nò bàkà tí wó ji ndâ ꞌduù máa, yì ma. ");
INSERT INTO ndz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tacó énò, ndâ ꞌduù gbí gbata tí nò ꞌdáá gî, ndâ ꞌduù ŋìnó ta ṛè ndú a ṛè nó, giì je sè ndâ yê, ꞌdáá gî ta o tí nò kû ꞌdi có mì wó. Ndú giì gbì ṛè mítí wó máa, «Yí a wotí tí nó mì Mbíṛì náa à kû nì mítí  a ‹Ma›,» nô. ");
INSERT INTO ndz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ndâ ꞌduù tí nò kû ꞌdi có mì Sìmónè tacó yí kû bàkà ndâ i-yeè náa bà ꞌdè có gítí ndú kpò nje ndú gî mí kùṛo ndú ta kôndi o. ");
INSERT INTO ndz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ndâ ꞌdakò ta ndâ niì me mbè mâ giì ùnje gítí ndâ có tí nó náa Fìlípò kû kò ta kò ji ndú gítí bà dù Mbíṛì tí Gba, ta bà kò-kò ta ṛè Jézù tí Bìndi-Mbíṛì nó gî, Fìlípò giì caka tí ndú gî. ");
INSERT INTO ndz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sìmónè delè mâ giì ùnje gî, Fìlípò giì caka tí wó gî. Bìndi bà caka tí Sìmónè nò, yí giì dù ká kpírí-kpírí ta Fìlípò kû zeke ndâ seṛè, giì je ndâ kpo-kpò i tí nó náa Fìlípò kû bàkà nô, ta ꞌbí ŋa có náa yí bà ꞌdè gbí nje wó wálá, tacó bà ꞌdi gbí ŋa ndâ i tí nò náa Fìlípò kû bàkà ndú nò kpò nje wó gî. ");
INSERT INTO ndz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ndâ tú mì Jézù gbí gbata Jèrùzàlémè mâ giì ꞌdi có énó máa, ndâ ꞌduù Sàmárìyà ùnje gítí có mì Jézù gî, ndú giì tuu ndâ Pìyétòrò ta Jòvánì ya tí  ji ndú. ");
INSERT INTO ndz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ndâ Pìyétòrò ta Jòvánì mâ giì yee Sàmárìyà gî, ndú giì ꞌdeke tí ndú ji Mbíṛì, tacó wàa, yí ꞌví tuu Bèṛi mì wó gí muu ndâ ꞌduù tí nò mbe ùnje gítí có mì Jézù gî nò. ");
INSERT INTO ndz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tacó yee tí o bà gì ndâ Pìyétòrò ta Jòvánì nò, à caka káa tí ndâ ꞌduù Sàmárìyà ta ṛè mì Mbe tí ndoo tí Jézù gî, káa Bèṛi-mì-Mbíṛì gì gí muu ndú kálásê. ");
INSERT INTO ndz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tacó énò, ndâ Pìyétòrò ta Jòvánì bà-i-nò giì kaa ꞌbì ndú mí muu ndâ ꞌduù tí nò, bìndi  Bèṛi-mì-Mbíṛì giì gì gí muu ndú. ");
INSERT INTO ndz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Sìmónè mâ giì ŋò bà gì Bèṛi-mì-Mbíṛì gí muu ndâ ꞌduù ta o bà kaa ꞌbì ndâ tú mì Jézù mí muu ndú nò, yí giì je gùrúsù ji ndú, ");
INSERT INTO ndz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","bìndi  yí giì ꞌdè có ji ndú máa, «Yo je ꞌbí ŋa wotí tí nò mì yo nò ji ye delè, tacó wàa, ye má tee ta ꞌbì ye mí muu ꞌduù, wàa Bèṛi-mì-Mbíṛì ꞌví gì gí muu wó.» ");
INSERT INTO ndz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Káa Pìyétòrò giì ꞌvìsì có ji Sìmónè máa, «Yo ꞌví mìì ta gùrúsù mì lo nó kpú, tacó bà koṛo có máa, gùrúsù a i bà sì i ŋìnó náa Mbíṛì ká kû je ji ndâ ꞌduù tí i-nambeè nô. ");
INSERT INTO ndz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bà i mì lo gbí i tí nó wálá, ꞌbí i ta ṛè lo delè gbí  wálá, tacó Mbíṛì ŋò njembí lo me dúú lá. ");
INSERT INTO ndz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","À má énò, ꞌvìsì muu lo ꞌdo tí ŋa vò bà koṛo có mì lo nò gî, wàa wò ꞌví ꞌdeke tí lo ji Mbíṛì, tacó wàa, yí ꞌví je ta à-cee-gî ji wò gítí ŋa bà koṛo có tí nò náa wò kû koṛo nò. ");
INSERT INTO ndz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tacó ye ŋò ni gî, máa, a ju kiì ká kû zi wò. Vò i delè da ꞌbò mítí kò lo gî.» ");
INSERT INTO ndz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Káa Sìmónè giì ꞌvìsì có ji Pìyétòrò máa, «ꞌDeke tí lo ji Mbíṛì tacó tí ye, tacó wàa, ꞌbí i gbaànjé ꞌdo gbí òkò tí ndâ i tí nò náa wò nì ṛè ndú nò ꞌví me ye lá.» ");
INSERT INTO ndz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ndâ Pìyétòrò ta Jòvánì mâ giì ꞌdè có, ta bà kò-kò ta có mì Mbe tí ndoo, ji ndâ ꞌduù gbí gbata tí nò Sàmárìyà náa ndú ya gítí  nò cee gî, ndú giì dele ndi ndú gí Jèrùzàlémè ta bà nò ta bà ma Banga-Ngú-Có ji ndâ ꞌduù ta ndi tí ndâ ꞌbá tí kpokèjì gbí to Sàmárìyà. ");
INSERT INTO ndz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ta o tí nò, basìlì mì Mbíṛì giì ꞌdè có ji Fìlípò máa, «ꞌViindi tí lo, wàa wò ꞌví zèè zì kpokèjì tí nó mbe mò gí gbíꞌdè, mbe ꞌdo Jèrùzàlémè kû gì gí gbí gbata Gázà nô.» ");
INSERT INTO ndz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Fìlípò bà-i-nò giì ꞌbì nó go có tí nò náa basìlì mì Mbíṛì ꞌdè ji yí nò. Yí mâ giì zekeꞌo si yí kpokèjì, yí giì ŋò a ꞌbí ꞌdakò náa a ba yí gî, tí gbolò ꞌduù mbe kû kpolo tí ndâ i-ꞌbá mì Kàndékè (gbí  máa gba-niì), mì ndâ ꞌduù Èsìyópìyà. ");
INSERT INTO ndz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Gbolò ꞌduù tí nò ta o tí nò kû dele ndi wó gí ꞌbá ꞌdo bà bàkà i-Mbíṛì Jèrùzàlémè. Yí ta o tí nò ki tí wó gbí àràbíyà-kècè mì wó kû ꞌdeke i ꞌdo gbí wáràgà mì Ìzáyà tí mbe ꞌdòkò có mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Bèṛi-mì-Mbíṛì bà-i-nò giì ꞌdè có ji Fìlípò máa, «Yèè ndi lo dê gítí àràbíyà tí zô.» ");
INSERT INTO ndz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fìlípò mâ giì yèè dê gítí àràbíyà tí nò go có mì Bèṛi-mì-Mbíṛì nò, yí giì ꞌde ꞌdakò tí nò kû ꞌdeke i ꞌdo gbí wáràgà mì Ìzáyà. Bìndi  Fìlípò giì ꞌvee yí máa, «Wò kpónó ꞌdi gbí có tí nò náa wò kû ꞌdeke nò gî?» ");
INSERT INTO ndz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Káa yí giì ꞌvìsì cò ji Fìlípò máa, «Ye bà ꞌdi gbí  ta kpéétí ye ta ŋa kpokèjì ngàyi, sè  káa ŋìnó náa ꞌbí ꞌduù má konì ye?» Yí bà-i-nò giì tèꞌé tí Fìlípò gí mì ndú ta yí yaà. ");
INSERT INTO ndz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Có tí nò náa gbolò ꞌduù tí nò kû ꞌdeke ꞌdo gbí wáràgà mì Mbíṛì nò énó máa, «Yí táánò go rómbo náa à kû ja yí ya tí  gí nje sìzò. Yí táánò dù ká ngbìì, go ꞌviì-rómbo ta nje wó tí wó wálá kùṛo mbe kû ꞌdii se tí wó. Yí táánò njaanga nje wo lá. ");
INSERT INTO ndz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Àá táánò ŋonoko yí, ta gbèe ꞌduù mbe tì muu wó wálá. Mbe ꞌdè tà-ká-tà gítí ndâ ká gù wó wúnò bà dù wálá, tacó à kaa yí ta ꞌbú si sè o mì wó me ꞌdú gí kùṛo.» ");
INSERT INTO ndz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Gbolò ꞌdakò tí nò mâ giì ꞌdeke i tí nò cee gî, yí giì ꞌvìsì tí wó gítí Fìlípò, bìndi  yí giì ꞌvee yí máa, «Mbe ꞌdòkò có mì Mbíṛì táánò kû ꞌdè có tí nò gítí ꞌdóó kùùkpò dìì wó wèè, gítí ꞌbí ꞌduù kèꞌbî? ꞌDè ji ye gi.» ");
INSERT INTO ndz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Káa Fìlípò bà-i-nò giì ꞌbìtà bà ꞌvìsì có ji yí ta bà ꞌdè gbí có tí nò náa yí ꞌdeke ꞌdo gbí wáràgà mì Mbíṛì nò má kózò gî, yí bà giì ꞌdè gbí Banga-Ngú-Có mì Jézù ji yí. ");
INSERT INTO ndz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ndú mâ giì yèè gí kùṛo, ndú giì ꞌde ngo kpokèjì, bìndi  gbolò ꞌdakò tí nò giì ꞌvee Fìlípò máa, «Ŋò ngo kuu zô, à má énò, ꞌdóó ṛè i tí nó mbe tii bà caka tí ye nó kpónó ꞌví dù a ŋa yè?» ");
INSERT INTO ndz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Káa Fìlípò giì ꞌvìsì có ji yí máa, «Wò má ùnje ta njembí lo gbaànjé gî, àá bà caka tí lo gî.» Gbolò ꞌdakò tí nò bà-i-nò giì ꞌvìsì có ji Fìlípò máa, «Ye ùnje gî! Ye ùnje gî máa, Jézù tí Bìndi-Mbíṛì a ꞌViì-mì-Mbíṛì.» ");
INSERT INTO ndz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Gbolò ꞌdakò tí nò giì ṛò àràbíyà mì wó mí tíyò bìndi bà ꞌdè có tí nò, bìndi  ndú giì ya ta Fìlípò gí tà ngo, bìndi  Fìlípò giì caka tí wó gî. ");
INSERT INTO ndz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ndú mâ giì co gí sè ꞌdo tà ngo gî, Bèṛi-mì-Mbíṛì giì te Fìlípò ꞌdo tí gbolò ꞌdakò tí nò gî. Yí giì ŋò Fìlípò kákáꞌi lá, káa yí giì nò sè nó mì wó ta pétékè tàkòcò wó. ");
INSERT INTO ndz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fìlípò giì ꞌde tí wó ŋìndi wó a i ngé gbí gbata Àzátù, bìndi  yí giì cee sè nó mì wó ta bà ma Banga-Ngú-Có ta ndi gbí ndâ gbata ta ndi tí kpokèjì léé gî di ngé gbí gbata Cèzàríyà. ");
INSERT INTO ndz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sàwúlè giì dù á tàkòcò ndâ mbe tala có mì Mbe tí ndoo go ꞌbilì sè. Tacó énò, yí giì ya gí mì Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà, ");
INSERT INTO ndz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","tacó wàa, yí ꞌví cu wáràgà tacó bà je wotí ji yì, wàa yì ꞌví ya tí  ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì á gbí gbata Dàmásìkù, wàa yì má ꞌde ndâ ꞌdakò ta ndâ niì mbe kû ṛu ndi «Kpokèjì tí nò» mì Jézù nò kà, yì ꞌví zèè ndú, wàa yì ꞌví kaa ndú gì tí  gí Jèrùzàlémè. ");
INSERT INTO ndz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Káa, si Sàwúlè kû ya gí Dàmásìkù, si yí dooko dê ta gbata Dàmásìkù gî, yí giì gu káa ndiì ta ngbaꞌo ꞌdo gbíṛì mbe ngbaṛanga to jèlè yí gî. ");
INSERT INTO ndz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yí giì ꞌva tí wó to, bìndi  yí giì dù á to kà kû ꞌdi kòcò ꞌduù kû tèꞌé tí wó, máa, «Sàwúlè! Sàwúlè!» Bìndi  ꞌduù tí nò giì ꞌvee yí máa, «Wò kû mèèkèꞌi tí ye tacó yè?» ");
INSERT INTO ndz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Káa Sàwúlè giì ꞌvee ꞌduù tí nò máa, «Wò a ꞌdi, Mbe tí ye?» Káa ꞌduù tí nò giì ꞌvìsì có ji Sàwúlè máa, «Ye a Jézù tí nó náa wò kû mèèkèꞌi tí wó nô. ");
INSERT INTO ndz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","A gí yaà kpónó, wàa wò ꞌví ya gí gbí gbata Dàmásìkù, wàa à ꞌví tùbà i tí nó náa wò ꞌví bàkà nó ji wò kà.» ");
INSERT INTO ndz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndâ ꞌduù tí nó muu nó ta ndâ Sàwúlè nó giì ṛò tíyò ngbi-ngbìì, tacó ndú kû ꞌdi káa kòcò ꞌduù kû ꞌdè có ji Sàwúlè, káa ndú ŋò ꞌduù tí nò lá. ");
INSERT INTO ndz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sàwúlè giì a gí yaà ꞌdo to bìndi i tí nò ta ṛo wó ngba-ngbàà, káa yí ŋò gbèe i lá. Bìndi  ndâ ka wó tí nó náa ndú ta ndú nó ká giì ja yí gbí sú ṛo ya tí  gí gbí gbata Dàmásìkù. ");
INSERT INTO ndz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yí giì dù gbí sú ṛo ta sili taꞌô. Gbí ndâ sili tí nò taꞌô nò, i-zó-zò di gbí nje wó lá, yí delè tò ngo mítí nje wó lá. ");
INSERT INTO ndz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ta o tí nò, ꞌbí ꞌdakò tí mbe tala có mì Jézù, ta ṛè wó a Ànàníyà, kuu gbí gbata Dàmásìkù. I tí nò mâ giì bàkà tí mítí Sàwúlè gî, Mbíṛì giì gì gí muu Ànàníyà go i gbí ṛiì nô. Yí giì tèꞌé tí wó ta ṛè wó máa, «Ànàníyà!» Ànàníyà giì ùnje ji Mbíṛì máa, «Ye kuu nô, Mbe tí ye.» ");
INSERT INTO ndz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bìndi  Mbe tí ndoo giì ꞌdè có ji Ànàníyà máa, «A gí yaà, wàa wò ꞌví ya gí ꞌbá mì ꞌdakò tí nó tí Júdà nó, tí kpokèjì tí nó náa à kû nì ‹Jáá-kpokèjì› mítí  nô. Wàa, wò ꞌví ꞌvee bà tí ꞌbí ꞌdakò mbe gí ꞌdo gbí gbata Tárásùsù, ta ṛè wó a Sàwúlè. Yí kpónó kuu kà kû ꞌdeke tí wó ji ye tí Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ye tùbà tí lo tí Ànàníyà ji yí gbí ṛiì gî, máa, ꞌbí ꞌdakò ta ṛè wó a Ànàníyà kèjì gí bà tee ꞌbì wó mítí wó, tacó wàa, ndâ ṛo wó ꞌví njaanga tí gî.» ");
INSERT INTO ndz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ànàníyà mâ giì ꞌdi có tí nò, yí giì ꞌvìsì có gí tàkò  máa, «Ye ꞌdi tàwo ŋa ndâ vò i tí nó náa ꞌdakò tí nò kû bàkà ta ndâ ꞌduù mì lo Jèrùzàlémè nó ꞌdo mì ndâ ꞌduù me mbè, Mbe tí ye. ");
INSERT INTO ndz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yí delè kpónó te ꞌdo Jèrùzàlémè nò a nó bà gì gí bà woo ndâ ꞌduù tí nó ꞌdáá mbe kû si wò tí Mbe tí ndú gbí gbata Dàmásìkù nô. Yí gì nò ta wotí ꞌdo mì Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Káa Mbe tí ndoo giì ꞌvìsì có ji Ànàníyà máa, «À ꞌdáá ká gbaànjé. Njè nó, tacó ye kpónó cu ꞌbì ye mítí wó, tacó wàa, yí ꞌví dù tí ꞌduù mì ye mbe ma ṛè ye ji ndâ ŋa ndâ ꞌduù ŋìnó náa ndú me ndâ Jùdéyà lá nó, ta ndâ kpo-kpò gba, ta ndâ Ìzìrìyélì delè. ");
INSERT INTO ndz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ꞌDóó ye ta miṛi ye ká bà tùbà  ji yí máa, yí bà mbu muu ye tí vò ŋa bà mbu ndò.» ");
INSERT INTO ndz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ànàníyà giì njè nó bìndi có tí nò ya gí ꞌbá mì Júdà. Bìndi  yí giì ṛì gí tàꞌi. Yí mâ giì ꞌde Sàwúlè gî, yí giì ꞌdè có ji yí máa, «Náꞌvindí ye Sàwúlè! A Mbe tí ndoo tí Jézù tí nó mbe tùbà tí wó ji wò á kpokèjì si wò kû gì nó ká tuu ye ji wò. Yí tuu ye ji wò énó máa, wò ꞌví zekeꞌo, delè máa, Bèṛi-mì-Mbíṛì ꞌví je wotí ji wò me gbolò.» ");
INSERT INTO ndz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","À káa póó bà cee có tí nò gbí nje Ànàníyà, ndâ ꞌbí i go kù kélè i nó giì oloko gí to ꞌdo tà ndâ ṛo Sàwúlè sósòꞌô gî. Yí bà-i-nò giì ꞌbìtà bà ŋò ndâ i kákáꞌi. Tacó énò, yí bà-i-nò giì a gí yaà, bìndi  à giì caka tí wó gî. ");
INSERT INTO ndz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Yí mâ giì zò i bìndi bà caka tí wó nò gî, wotí giì gì gítí wó kákáꞌi gî. ");
INSERT INTO ndz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sàwúlè giì ꞌbìtà bà ma có tí Jézù ji ndâ ꞌduù ta ndi tí ndâ bàndò bà kili ndâ Jùdéyà gí bà ùlù Mbíṛì, máa, Jézù a ꞌViì-mì-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Káa ndâ mbe ùnje gítí có mì Jézù giì ꞌbìtà bà fiini có gbí òkò tí ndú, máa, «À ngbáṛángàꞌi kuu nó me gbíṛo ꞌdakò tí nó mbe kû tè ꞌbèlè ndâ mbe kû te duù mítí ṛè tí nò Jèrùzàlémè nó ká nó lá? Yí kpónó te nó a nó bà gì gí bà woo ndú, wàa yì ꞌví ya ta ndú gí Jèrùzàlémè ta wáràgà ꞌdo mì ndâ Kùṛo ndâ bu-Mbíṛì mì ndâ Jùdéyà.» ");
INSERT INTO ndz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ngé gî lá! Kòcò Sàwúlè kû giì co gbí ndâ có mì ndú nò ta bà ma có mì Jézù go bà co ngûwu gbí mù. Yí giì ŋònòkò muu ndâ Jùdéyà tí nó mbe kû ꞌvala Dàmásìkù nó ta bà tùbà  ji ndú énó máa, Jézù a Bìndi-Mbíṛì nò gî. ");
INSERT INTO ndz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ndâ Jùdéyà mâ giì ŋò sili bà giì me a túkà tí ŋa nèté tí nò mì Sàwúlè nò, ndú giì kili ta bà muu ndú, bìndi  ndú giì pà kpokèjì tacó bà zi yí. ");
INSERT INTO ndz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tacó énò, ndú giì dù kácáá kû ṛi njekèjì ndùgù gbata tacó bà ŋò bà co yí gí sè, wàa bà có tí nò ꞌví cee gî. Keèlá Sàwúlè ꞌdi có ndâ i tí nò náa ndú kû bàkà nò sàà gî. ");
INSERT INTO ndz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ndâ mbe tala có mì Sàwúlè mâ giì ŋò énò, ndú giì te yí mí gbí kèè, bìndi  ndú giì yuu ta yí gí sè co tí nga ndùgù. ");
INSERT INTO ndz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sàwúlè mâ giì delè ndi wó bìndi ndâ i tí nò mbe ꞌdè yí Dàmásìkù nò ya gí Jèrùzàlémè, yí giì tala bà dù á mì ndú ta ndâ mbe tala có mì Jézù. Káa, ndâ mbe tala có mì Jézù giì dù ta yí ká ta seè tí ndú, tacó có tí nò máa, yí gì tí ka ndú mbe tala có mì Jézù gî nò, zò muu ndú dúú-dúú lá. ");
INSERT INTO ndz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","A ꞌbí ꞌdakò tí mbe tala có mì Jézù, ta ṛè wó a Bàrànábà ká giì gbì gbí njembí wó gítí bà tùbà tí Sàwúlè ji ndâ tú mì Jézù. A Bàrànábà tí nò ká giì ꞌdè gbí bà tùbà tí Mbe tí ndoo ji Sàwúlè si yí tí kpokèjì kû ya gí Dàmásìkù ngbáṛángàꞌi ji ndâ tú mì Jézù. À delè káa yí ká giì dìtà bà kò kò mì Sàwúlè ta ṛè Jézù gbí gbata Dàmásìkù ta gúku tí wó tí Sàwúlè wálá ji ndâ tú mì Jézù. ");
INSERT INTO ndz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ndâ Sàwúlè bà-i-nò giì dù kû nò ta ndâ tú mì Jézù ta ndi gbí gbata Jèrùzàlémè, kû ma ṛè Mbe tí ndoo ta gúku tí wó ngé gî wálá ꞌdo gbí ndò muu bà tùbà tí wó mì Bàrànábà ji ndú nò. ");
INSERT INTO ndz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sàwúlè mâ giì ꞌdè có ta ndâ ꞌbí ŋa ndâ Jùdéyà ŋìnó ta nje có mì ndú a có Ìgìrígì nó, à giì dù gbí òkò tí ndú ta ndú a kponje. Tacó énò, ndâ ꞌduù tí nò giì eṛe muu ndú gî máa, kózò tí ndâ yì bà zi káa Sàwúlè. ");
INSERT INTO ndz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Có tí nò mâ giì ꞌva tí gbí tù ndâ mbe ùnje gítí có mì Jézù, ndú giì ya ta Sàwúlè gí gbí gbata Cèzàríyà, bìndi  ndú giì tuu yí ya tí  gí Tárásùsù. ");
INSERT INTO ndz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ꞌBí i mbe giì ba muu ndâ mbe kû kili ta ṛè mì Jézù gbí ndâ to Jùdéyà, ta Gàlìléyà, ta Sàmárìyà, ꞌdáá gî ta o tí nò wálá. Ndú kû giì co tí kpokèjì mì Mbíṛì. Ndú delè giì dù kû àdì ta wotí mì Bèṛi-mì-Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pìyétòrò giì dù kû nò nó jèlè to ta bà gala ndâ ꞌduù mì Mbíṛì ta ndi gbí ndâ gbata ꞌdáá gî. Ta ꞌbí o gbaànjé, yí mâ giì ya gí bà gala ndâ ꞌduù gbí gbata Lídà, ");
INSERT INTO ndz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","yí giì ꞌde ꞌbí ꞌdakò mbe gbeleꞌve gî, ta ṛè wó a Ànéyà. Ànéyà tí nò gbeleꞌve mí to a i ta ndoò vô-nje taꞌô. ");
INSERT INTO ndz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pìyétòrò bà-i-nò giì ꞌdè có ji Ànéyà máa, «Jézù tí Bìndi-Mbíṛì ꞌvala wò gî. A gí yaà, wàa wò ꞌví paṛaka kpâ-sili mì lo.» Ànéyà bà-i-nò ngé giì a gí yaà go có mì Pìyétòrò nò gî. ");
INSERT INTO ndz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ndâ ꞌduù gbí ndâ gbata Lídà ta Sàrónì mâ giì ŋò Ànéyà kû nò nó, ndú ꞌdáá gî giì ꞌvìsì tí ndú gí mì Mbe tí ndoo gî. ");
INSERT INTO ndz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ta o tí nò, ꞌbí niì tí mbe tala có mì Jézù gbí gbata Jópà, ta ṛè wó a Tàbítà gbí có Jùdéyà, à ta có Ìgìrígì a Dórókàsì, (gbí  máa «lámbà»), náa nèté mì wó ta o ꞌdáá gî a bà bàkà tó i, ta bà konì ndâ mbe yê, ");
INSERT INTO ndz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","giì sì nòꞌo. Yí mâ giì cì gî, à giì caka ku wó gî, bìndi  à giì te yí mí gbí soṛo. ");
INSERT INTO ndz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ndâ mbe tala có mì Jézù gbí gbata Jópà mâ giì ꞌdi có énó máa, Pìyétòrò kuu gbí gbata Lídà, ndú giì tuu ndâ ꞌbí ꞌdakò sósòꞌô ꞌdo gbí òkò tí ndú gí tàkò wó, máa, «Bàkà nambeè mì lo, wàa wò ꞌví goonó gálà gì gítí ze.» Ndú bàkà énò tacó bà ꞌdo Jópà ya gí Lídà ká dê. ");
INSERT INTO ndz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ndâ tú tí nò mâ giì ꞌvanda ndi có tí nó náa à tuu ta ndú nó ji Pìyétòrò gî, ndú giì njè nó ta ndú gbaànjé ya gí Jópà. Ndú mâ giì yee kà, ndú giì ꞌdò ta Pìyétòrò gí tàꞌi tí nó náa à kû wa ku Dórókàsì mítí  nô. Ndâ nawù ku tí nó mbe kû wa ku nó mâ giì ŋò Pìyétòrò, ndú giì tì yí ꞌdee gî, kû wa gbí ta bà tù ndâ bòngo tí nó náa Dórókàsì cu ji ndú si yí tí wu wó nô. ");
INSERT INTO ndz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pìyétòrò bà-i-nò giì ꞌdè có ji ndâ ꞌduù ꞌdáá gî máa, ndú co ꞌdo tàkò ku gí sè. Ndâ ꞌduù tí nò mâ giì njè gí sè gî, Pìyétòrò giì kucuku muungbó wó mí to. Yí mâ giì ꞌdeke tí wó ji Mbíṛì gî, yí giì ꞌvìsì tí wó gítí ku, bìndi  yí giì tèꞌé tí wó, máa, «Tàbítà, a gí yaà.» Tàbítà bà-i-nò giì njaanga ṛo wó. Yí mâ giì ŋò Pìyétòrò, yí giì a ki tí wó yaà. ");
INSERT INTO ndz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pìyétòrò bà-i-nò giì tù ꞌbì wó ji yí. Yí mâ giì zèè gî, Pìyétòrò giì ja yí gí yaà, bìndi  yí giì tèꞌé tí ndâ mbe ùnje gítí có mì Jézù ta ndâ nawù ku ꞌdo sè, bìndi  yí giì je yí ji ndú tí wu wó. ");
INSERT INTO ndz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tàwo i tí nò giì ya cee gbí gbata Jópà ꞌdáá gî. Bìndi  ndâ ꞌduù me mbè giì ùnje gítí có mì Mbe tí ndoo. ");
INSERT INTO ndz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pìyétòrò giì dù gbí gbata Jópà bìndi có tí nò ta mbè sili á ꞌbá mì ꞌbí ꞌdakò tí mbe fuu kû, ta ṛè wó a Sìmónè. ");
INSERT INTO ndz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ta o tí nò, ꞌbí ꞌdakò tí gbolò ꞌduù kùṛo ndâ ꞌbí ŋa àsìkérì mì ndâ Ròmánò náa à kû nì mítí ndú a ndâ àsìkérì-Tùlìyánì, ");
INSERT INTO ndz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","tí ꞌdakò mbe kû co ká jáá tí kpokèjì mì Mbíṛì, mbe kû ꞌdeke tí wó ji Mbíṛì ta o ꞌdáá gî, náa ndú ta ndâ ꞌviì mì wó ꞌdáá gî a ndâ mbe ꞌdi có mì Mbíṛì, tí ꞌdakò ta ŋó ṛo i tí wó wálá, mbe kû konì ndâ mbe yê mì ndâ Jùdéyà ta o ꞌdáá gî, ta ṛè wó a Kòrònélìyò, kuu ta ꞌbá gbí gbata Cèzàríyà. ");
INSERT INTO ndz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ta ꞌbí ṛi-ꞌdêꞌo gbaànjé, ꞌbí i giì bàkà Kòrònélìyò goòlá yí kû ṛi a ṛiì nô, yí giì ŋò basìlì mì Mbíṛì kû ṛì gí tàkò wó tàꞌi ta bà tèꞌé tí wó ta ṛè wó máa, «Kòrònélìyò!» ");
INSERT INTO ndz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kòrònélìyò bà-i-nò giì si ṛo wó ngba-ngbàà ta gúku kû zeke ta basìlì tí nò. Bìndi  yí giì ꞌvee basìlì tí nò máa, «A yè, Mbe tí ye?» Káa basìlì tí nò giì ꞌvìsì có ji Kòrònélìyò máa, «Mbíṛì ŋò bà ꞌdeke tí lo gî, yí delè giì ŋò ndâ nambeè tí nó náa wò kû bàkà ji ndâ mbe yê nó gî. ");
INSERT INTO ndz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","À má énò, tuu ꞌbí ꞌduù gí gbí gbata Jópà gí bà tèꞌé tí ꞌbí ꞌdakò ta ṛé wó a Sìmónè, náa à kû nì mítí wó a Pìyétòrò nó, máa, yí gì gí mì lo. ");
INSERT INTO ndz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yí kû dù á Jópà kà a i ꞌbá mì ꞌbí ꞌdakò tí mbe fuu kû, ta ṛè wó delè káa Sìmónè, ta ꞌbá mì wó dê seè kàpá.» ");
INSERT INTO ndz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Basìlì tí nò mbe ꞌdè có ji Kòrònélìyò nò mâ giì ya gî, Kòrònélìyò giì tèꞌé tí ndâ ꞌduù sósòꞌô ꞌdo gbí òkò tí ndâ bòò mbe kû bàkà nèté ꞌbá mì wó, giì je àsìkérì gbaànjé ꞌdo gbí òkò tí ndâ àsìkérì ŋìnó mbe kû kpolo tí wó nô. Ndâ ꞌduù tí nò náa Kòrònélìyò ṛuka ndú nò ꞌdáá káa ndâ ꞌduù ŋìnó mbe kû co ká jáá tí kpokèjì mì Mbíṛì. ");
INSERT INTO ndz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Yí giì ꞌvanda ndi có tí nó mbe ꞌde yí nó ꞌdáá gî ji ndú, bìndi  yí giì tuu ndú, máa, ndú ya gí bà tèꞌé tí Pìyétòrò ji yì ꞌdo Jópà. ");
INSERT INTO ndz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ta ꞌbí yé bìndi bà tuu ndâ ꞌduù mì Kòrònélìyò nò, si ndú dooko ta gbata Jópà gî, Pìyétòrò giì ya gí pí ꞌbá gí bà ꞌdeke tí wó ji Mbíṛì ta ṛi dê gítí bà gì gbúrú. ");
INSERT INTO ndz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Káa go giì zèè yí kùṛo o bà zò i, bìndi  yí giì dù kû koṛo có gítí bà gì o bà zò i. ꞌBí i bà-i-nò giì bàkà yí goòlá yí kû ṛi a ṛiì nô. ");
INSERT INTO ndz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yí mâ giì zekeꞌo, yí giì ŋò njekèjì gbíṛì njaanga tí ngàà gî, káa ꞌbí i go gbolò kpâ-bòngo náa à dò gbí  dó-dò kû gì gí to yàꞌbàà énò, ");
INSERT INTO ndz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ta ndâ ŋa ndâ nò, ta ndâ nuù, ta ndâ kùnene ŋa i mbe kû ja gbí yì ndú có to, ta ndâ ŋa ndâ i mbe kû ṛì gùù, muu to tí nó ꞌdáá gî gbí . ");
INSERT INTO ndz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Bìndi  yí giì ꞌdi kòcò ꞌduù kû ꞌdè có ji yí ꞌdo gbíṛì máa, «Pìyétòrò! Ziki ndâ i tí nò kpónó, wàa wò ꞌví zò ndú.» ");
INSERT INTO ndz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Káa Pìyétòrò giì ꞌvìsì có ji ꞌduù tí nò mbe kû ꞌdè có ji yí ꞌdo gbíṛì nò, máa, «Ngé gî lá, Mbe tí ye. Ye jé ta gbèe ṛi zò i ŋìnó náa a me yí  lá, tí zu i gbí tàkìì mì ndâ Jùdéyà nó lá.» ");
INSERT INTO ndz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Káa ꞌduù tí nò giì ꞌdè có ji Pìyétòrò kákáꞌi máa, «Yúcó mì lo tacó bá nì ‹bètí› ta ‹zuù› mítí i ŋìnó náa a Mbíṛì ká bàkà tí ngbáṛángà i nó wálá.» ");
INSERT INTO ndz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ꞌDuù tí nò giì yòòngò Pìyétòrò gítí bà zò ndâ i tí nò ta bà  taꞌô, káa Pìyétòrò giì biya gî. Pìyétòrò mâ giì zekeꞌo, ꞌvóndóꞌdóó! À ja káꞌi tí nò ya tí  gí gbíṛì kákáꞌi gî. ");
INSERT INTO ndz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Káa si Pìyétòrò ká jé kû ꞌviiki gbí ŋa i tí nò náa yí ŋò go i gbí ṛiì nò, yí giì ŋò ndâ ꞌdakò tí nó náa Kòrònélìyò tuu ndú ji yí nó yee kpàtàràkà njekèjì ndùgù gî. Ndú nò ta bà ꞌvee bà ꞌbá mì Sìmónè tí mbe fuu kû kpòò, káa ndú giì ꞌde gî. ");
INSERT INTO ndz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ndú bà-i-nò giì ꞌvee ꞌvé ꞌdo njekèjì ndùgù sè máa, «ꞌBí ꞌdakò ta ṛè wó a Sìmónè Pìyétòrò kuu bà-i-nó?» ");
INSERT INTO ndz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pìyétòrò ŋò bà yee ndâ ꞌdakò tí nò lá, tacó mbí wó ta o tí nò me dê lá, yí ta o tí nò kû koṛo có ká wìì énó gítí ndâ ŋa i tí nó náa yí ŋò go ndâ i gbí ṛiì nô. A Bèṛi-mì-Mbíṛì ká giì ꞌdè có ji yí máa, «Ŋò ndâ ꞌbí ꞌdakò taꞌô mbe kû ꞌvee bà tí lo kuu zô. ");
INSERT INTO ndz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nògí, co gí mì ndú to kà. Wàa wò ꞌví me kpììkì-kpììkì gítí bà ya ta ndú gí ta é tí nò lá, tacó a ye ká tuu ndú.» ");
INSERT INTO ndz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pìyétòrò bà-i-nò giì co gí to mì ndâ ꞌdakò tí nò. Bìndi  yí giì ꞌdè có ji ndú máa, «Ŋìnó a ye tí ꞌduù tí nó náa yo kû ꞌvee bà tí wó nô. Yo gì gí bà ŋa yè?» ");
INSERT INTO ndz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ndâ ꞌdakò tí nò bà-i-nò giì ꞌvìsì có ji yí máa, «A Kòrònélìyò, tí ꞌdakò tí nó tí gbolò ꞌduù kùṛo ndâ àsìkérì mì ndâ ꞌduù Rómà nó ká tuu ze. Yí a ꞌduù jáá, tí ꞌduù ŋìnó mbe kû ꞌdi có mì Mbíṛì, náa ndâ Jùdéyà ꞌdáá gî kû te duù mítí wó. A basìlì mì Mbíṛì ká ꞌdè có ji yí máa, yí tuu tú gí tàkò lo, wàa wò ꞌví ya gí ꞌbá mì wó, tacó wàa, yí ꞌví ꞌdi có ŋìnó náa wò bà ꞌdè ji yí nô.» ");
INSERT INTO ndz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pìyétòrò mâ giì ꞌdi có tí nò, yí giì kaa ndâ ꞌdakò tí nò gí tàꞌi, bìndi  yí giì je bàndò ṛì ji ndú ta bèbìlì tí nò. Yé mâ giì too gî, ndâ Pìyétòrò ta ndâ ꞌdakò tí nò, giì je ndâ ꞌbí mbe ko ndú ꞌdo gbí òkò tí ndâ náꞌvindí ndú mbe ùnje gítí có mì Jézù gbí gbata Jópà, giì ꞌbì nó kû ya gí tà é mì Kòrònélìyò. ");
INSERT INTO ndz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ndú giì yee gbí gbata Cèzàríyà ta ꞌbí yé, ꞌde Kòrònélìyò kili ndâ nambe wó, ta ndâ kpóló-kpolo kómbe wó ꞌdáá gî, kû ù