﻿USE sofia;
DROP TABLE IF EXISTS sofia.ndv_vpl;
CREATE TABLE ndv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ndv_vpl WRITE;
INSERT INTO ndv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Dalaana, Koope sakke sun a feey. ");
INSERT INTO ndv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Feey fa húmú holoŋ, gëeꞌ, gëfëŋ, dëlëeƴ a muluɓ⁠ ⁠: ow yéeh ɗee man ɗi ra⁠ ⁠; ñúusë húunté ƴaaha ɓéeɓ⁠ ⁠; ngilaaw mi Koope laɗte sun fi mulaa, na pay na ac. ");
INSERT INTO ndv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tígí daaha, Koope won tih⁠ ⁠: «⁠ ⁠Niiña hena⁠ ⁠!⁠ ⁠» Niiña hente. ");
INSERT INTO ndv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Koope otte biti niiña yii wunte, ɗi ɓísëlsëꞌté niiña a ñúusë. ");
INSERT INTO ndv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Koope dëekëꞌté niiña «⁠ ⁠naꞌ⁠ ⁠», dëekëꞌté ñúusë «⁠ ⁠elek⁠ ⁠». Fíníin lahte, ɓaaba acce⁠ ⁠: baa daa bisa ɗéɓ ɗë. ");
INSERT INTO ndv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Koope wonil tih⁠ ⁠: «⁠ ⁠Hanndal gaan lahan ndín, ɓísëlsëꞌ mulaa ana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Koope sakke hanndal ka, ɓísëlsëꞌté mulaa paaꞌ feey a ƴee paaꞌ sun ra. Baa lahaꞌte ɗah. ");
INSERT INTO ndv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Koope dëekëꞌté hanndal ka «⁠ ⁠sun-Koo⁠ ⁠». Fíníin lahte, ɓaaba acce⁠ ⁠: baa daa bisi ana fa. ");
INSERT INTO ndv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Koope wonil tih⁠ ⁠: «⁠ ⁠Mulaa paaꞌ feey ra négírëen ílíƴ yínë ndín, feey fa hen dandaŋ.⁠ ⁠» Ƴaa lahaꞌte ɗah. ");
INSERT INTO ndv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Koope dëekëꞌté tígí dandaŋa «⁠ ⁠feey⁠ ⁠», dëekëꞌté mulaa négírëꞌ rë «⁠ ⁠kísí⁠ ⁠»⁠ ⁠; te ɗi otte biti baa yii wunte. ");
INSERT INTO ndv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Koope wonil tih⁠ ⁠: «⁠ ⁠Feey fa henan hilil⁠ ⁠: lah gaaw fi na ɗúhíɗ tisoh ki a heetti kilikki na lím, bina-bina ɓéeɓ a tisoh ki.⁠ ⁠» Ƴaa lahaꞌte ɗah. ");
INSERT INTO ndv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Feey fa hente hilil. Heetti gaawa ya, bina-bina ɓéeɓ a tisoh ki⁠ ⁠; heetti kilikka na lím rë, bina-bina ɓéeɓ a tisoh ki. Koope otte biti baa yii wunte. ");
INSERT INTO ndv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Fíníin lahte, ɓaaba acce⁠ ⁠: baa daa bisi éeyë fë. ");
INSERT INTO ndv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Koope wonil tih⁠ ⁠: «⁠ ⁠Sun lahan i yin niiñlaa ndín, ɓísëlsëꞌ naꞌa a elga⁠ ⁠; na wa teeɓaꞌ bissi feetta, bissi kayya a kíillë⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","wa homun sun ndín, hawaane feey fa⁠ ⁠!⁠ ⁠» Baa lahaꞌte ɗah. ");
INSERT INTO ndv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Koope sakaꞌ iñi niiññi gaanni ana ya ɗah⁠ ⁠: bee lukki gaan ra, naꞌa, lahaꞌ bisa biti Koo yíil⁠ ⁠; bee lukki ƴin ra, céyín fë, lahaꞌ elga. Ɗi ɓaatte sakke hulla ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Koope tíkké wë sun, niiñlii feey fa, ");
INSERT INTO ndv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","wa lahaꞌ naꞌa a elga, ɓísëlsëꞌ niiña a ñúusë. Koope otte biti baa yii wunte. ");
INSERT INTO ndv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Fíníin lahte, ɓaaba acce⁠ ⁠: baa daa bisi iniil fa. ");
INSERT INTO ndv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Koope wonil tih⁠ ⁠: «⁠ ⁠Mulaa líifën a iñi na pes níi woƴe, te ƴakka púdé hanndal ki sun a feey.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Koope sakke heetti raɓɓi gaanna kísí fë, yii na woƴ filiɓ muluɓ ɓéeɓ, a ƴakka sun ɓéeɓ. Koope otte biti baa yii wunte. ");
INSERT INTO ndv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Koope barkelte wa won tih⁠ ⁠: «⁠ ⁠Kéñí, ɗon ɓaatoh, ɗon líifíɗ mulaa kísí fë te ƴakka ɓaatoh feey fa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Fíníin lahte, ɓaaba acce⁠ ⁠: baa daa bisi iip fa. ");
INSERT INTO ndv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Koope wonil tih⁠ ⁠: «⁠ ⁠Feey fa lahan heetti raɓɓa ɓéeɓ⁠ ⁠: ƴee faamma, ƴee luufa a raɓɓi ƴutuuɗɗa ɓéeɓ.⁠ ⁠» Ƴaa lahaꞌte ɗah. ");
INSERT INTO ndv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Koope sakaꞌ heetti raɓɓa ɓéeɓ ɗaaha⁠ ⁠: ƴee luufa, ƴee faamma a raɓɓi ƴutuuɗɗa ɓéeɓ. Te Koope otte biti yii baa wunte. ");
INSERT INTO ndv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Koope wonil tih⁠ ⁠: «⁠ ⁠Yen sak ow, ɗi man ti di madu yen nen⁠ ⁠! Ɗi ílífën jénnë kísí fë, ƴakka sun, raɓɓa faamma a raɓɓi ƴutuuɗɗa a feey fa ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Koope sakke ow ti di man ɗi fi Koope nen. Di man ɗi fi Koope, ɗi sakaꞌ ow ɗaaha. Ɗi sak ow ƴaal a ow ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Koope na an waa barkel, won wa tih⁠ ⁠: «⁠ ⁠Kéñí, ɗon ɓaatoh, ɗon líifíɗ feey fa⁠ ⁠; ílífí jénnë kísí fë, ƴakka sun, a raɓɓa na tílú feey fa ra ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Koope ɓaatte won tih⁠ ⁠: «⁠ ⁠Ëlí⁠ ⁠! Gaaw fi na ɗúhíɗ tisoh ki feey fa ɓéeɓ, a kilki na lím koy ki na ɗúhíɗ tisoh ki ɓéeɓ, mi onte ron wa ɓéeɓ pesaa. ");
INSERT INTO ndv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Te raɓɓa feey fa, ƴakka sun a yii na pes feey fa ɓéeɓ, mi onte wa gaaw fi hilila pesaa ɓal.⁠ ⁠» Baa lahaꞌte ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Koope otte biti iña paŋ ri ra ɓéeɓ wunte níi wun. Fíníin lahte, ɓaaba acce⁠ ⁠: baa daa bisi pëenë fë. ");
INSERT INTO ndv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Sagi sun a feey, a yii hom na ɓéeɓ lúsëꞌté ɗah. ");
INSERT INTO ndv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Lúsɗëꞌ Koo légéyí rë, bisi paana fa, ɗi hílsëhté. Bisi paana fa, Koope hílsëꞌ légéyée ké rí sakaꞌ ri ɓéeɓ rë në. ");
INSERT INTO ndv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Koope barkelte bisi paana fa, habaꞌte ri bisi, di biti ɗi hílsëꞌ légéyée ké rí sakaꞌ ri ɓéeɓ rë në. ");
INSERT INTO ndv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Baa daa naaɓii sagi sun a feey. Húmú sakaꞌ Koo-Yahwee sun a feey bín fë rë, ");
INSERT INTO ndv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ɗeef tal kilik yínë sah húmúy luufa, te gaawa paalay na, di biti Koo-Yahwee húmú dalay toɓ, te ow húmú lahay níi líné feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ndaa lahte culi mulii ɗofohte, na hilsiɗ feey fa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tígí daaha, Koo-Yahwee ɓeɓ na feey fa, yugusaꞌte ow, fúlílté nuŋŋi ñíinë, ɓekke ri coonaa, ɗi hente ɓëyí në pes. ");
INSERT INTO ndv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Koo-Yahwee saampe meey Eden di púlëen naꞌ, yíppé në kilik, tíkké në ɓëeꞌ ɗi yugus ri ra. ");
INSERT INTO ndv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Koo-Yahwee paaliɗte sun fi feey fa heetti kilikki wunte yeel, te koyya neɓpe ñam. Ɗi yíppé leelii meeya, kilka na onaꞌ pes, a bee na teeɓaꞌ yin wun a yin ɓos ra. ");
INSERT INTO ndv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Eden lahte laahi gaani hútëꞌ hútëe, daa ri na hilsiɗ meeya. Daaha, laaha salte iniil. ");
INSERT INTO ndv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sali yínëe hínú Pison. Daa ri wër gini Hawilaa ɓéeɓ, bee feey fa lahaꞌ úrís rë. ");
INSERT INTO ndv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gini baa lahaꞌ úrís kah-kah, lahte kilikki na yugusuu yin heeñlaa ɓal a laꞌa kofeel ot, na wonuu ëníksë rë. ");
INSERT INTO ndv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sali ana fa wër gini Kús rë, hínú Gihon. ");
INSERT INTO ndv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sali éeyë fë hínú Tíigër⁠ ⁠; daa ri bee na hút, paaꞌ Asuur púlëen naꞌ ra. Sali iniil fa hínú Efarat. ");
INSERT INTO ndv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Koo-Yahwee húmú tík ɓëeꞌ meeya Eden, nda ri mín ríi lín ndín, yugus ri. ");
INSERT INTO ndv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ɗi antee won ɓëeꞌ unni ƴeh⁠ ⁠: «⁠ ⁠Fu mín nëe ñam koyyi kilikka meeya ɓéeɓ di neɓaꞌ ro, ");
INSERT INTO ndv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","níi tasse koy kilka na teeɓaꞌ yin wun a yin ɓos ra⁠ ⁠; yiin ñaman fu na ra, lah yúhé biti fay húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Koo-Yahwee won nufi tih⁠ ⁠: «⁠ ⁠Ɗaay wuneh ow na, kon may sak ɓëyí madaꞌ a ri ndín, habraꞌ ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Koo-Yahwee ɓeɓ feey, yugusaꞌte raɓɓa feey fa a ƴakka sun, antee waa kúɗ fíi ɓëeꞌ, nda ɓëeꞌ saamiɗ wa tii ndín, bina-bina ɓéeɓ ɓeɓ tiya nay rii yere ɓëeꞌ rë. ");
INSERT INTO ndv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kon ɓëeꞌ saamiɗte raɓɓa faamma, ƴee luufa a ƴakka sun ɓéeɓ tii⁠ ⁠; ndaa ri olay ɓëyí madaꞌ a ri ndín, habraꞌ ri. ");
INSERT INTO ndv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tígí daaha, Koo-Yahwee ɓekke ɓëeꞌ neeꞌi misikke⁠ ⁠; filiɓ neeꞌa, Koope níssé laf yínë araal ɓëeꞌ, wëegísíɗté tígë nísëꞌ rí lafa ra ɗee húmú man ri ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Koo-Yahwee antee ɓeɓ lafi baaha yugusaꞌte ɓeleɓ, kompe ri ɓëeꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Olaꞌ ɓëeꞌ ɓelaa, ɗi won tih⁠ ⁠: «⁠ ⁠Waali yíníi beh, bee ƴuhi faan soꞌ kan a ñif mi soꞌ⁠ ⁠! Ɗi ay wonuu ow ɓeleɓ, ndah biti ɗi ɓeyuu ɓëeꞌ në.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yii baa daa tah ow ƴaal ay ɓísëh a boffi a yaafi, pokoh ɓeleɓi na, wa hen yínë. ");
INSERT INTO ndv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ɓëeꞌ a ɓeleɓi húmú faan holoŋ, ndaa sopantaꞌ húmú lahay hanndal ki wa. ");
INSERT INTO ndv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bín fë, ɗeef goŋ daa húmú lukki lah nuf di raɓɓa luufa sak Koo-Yahwee ra ɓéeɓ⁠ ⁠; ɗi acce won ɓelaa tih⁠ ⁠: «⁠ ⁠Koope wonte ron kah-kah biti ɗon ɓanuy naa ñam koy kilikka meeya ɓéeɓ ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ɓelaa tahte won goŋ fa tih⁠ ⁠: «⁠ ⁠Fun mínú nëe ñam koyyi kilikka meeya ɓéeɓ, ");
INSERT INTO ndv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ndaa koyyi tal kilka hom leelii meeya ra, Koope won fun na tih⁠ ⁠: “Ngënë ñëmí në te ngënë léɓí në sah, toñeh húl ay ron naa ɗeefe.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tígí daaha, goŋ fa tahte won ɓelaa tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ, ɗaa neh, ɗon ii húl⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Koope yúh yúhë biti kut ɗon ñam na raa, ɗon ay yeele ndín, ɗon madaꞌ a ri di yúhsëꞌ yin wun a yin ɓos.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Tígí daaha, ɓelaa otte biti koy kilka neɓpe yeel, te waɗtee ɗok, te ɓekaꞌ ow biti fu ñam na raa, afu ay kúnsëh, fu yúh ɓéeɓ nen. Ɓelaa sakke na koy kilka, ñampe. Bi ɓani ƴaala daa húmú, ɗi yeɗte ri na, ƴaala ñampe ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ñamuu wa na, affi wa yíppée kúnsëh, wa olute biti wa homu faan holoŋ. Tígí daaha, wa ɓeyute i saaf fíigë, tapalsuute ndíimú, haamuute. ");
INSERT INTO ndv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Gílíyëꞌ Koo sos-naꞌin, wa keluu yodadi Yahwee na tílëesëh meeya, wa múkëyúté, ɗapuute filiɓ kilikka. ");
INSERT INTO ndv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ndaa Koo-Yahwee dëekíɗté ɓëyí ƴaala, meelte ri won tih⁠ ⁠: «⁠ ⁠Fu di ɗeh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ɓëeꞌ tahte won tih⁠ ⁠: «⁠ ⁠Mi keloh yodadu meeya, te biti mi hom faan holoŋ, mantee neeh, mi ɗapohte.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Koope won ɗi tih⁠ ⁠: «⁠ ⁠Fu yúhëꞌ biti fu hom faan holoŋ ɗíh⁠ ⁠? Fu ñampe na koy kilka kaddaꞌ mi ro ra woo⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ɓëeꞌ tahte won tih⁠ ⁠: «⁠ ⁠Ɓelaa kom fu soꞌ ra daa on soꞌ na koy kilka, mi ñampe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Koo-Yahwee won ɓelaa tih⁠ ⁠: «⁠ ⁠Haalaꞌ yi níi fu na paŋ yii bah⁠ ⁠?⁠ ⁠» Ɓelaa tahte won tih⁠ ⁠: «⁠ ⁠Goŋ fa daa nofaꞌ soꞌ níi mi ñampe na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tígí daaha, Koo-Yahwee won goŋ fa tih⁠ ⁠: «⁠ ⁠Fu alkohte filiɓ raɓɓa luufa a ƴee faamma ɓéeɓ af yee paŋ fu baa ra. Fu ƴahti tíl rëe, fay fasee fasoo, te pesu ɓéeɓ fay ŋaare feey. ");
INSERT INTO ndv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","May yah hanndal ki ɗoni ɓelaa, a hanndal ki talu a tali. Tali ay poo afu, te fay rii ɗoɓ púgúlúɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Koope antee yíssëh ɓelaa na won ɗi tih⁠ ⁠: «⁠ ⁠May paŋ níi fu mok lool biti fu hen loo, te fu ƴahti lah koy raa, ay misik níi misik. Fay fahee leɓohi ƴaalu, te ri nay roo ílífé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ɗi míllëꞌ ɓëyí ƴaala na, won ɗi tih⁠ ⁠: «⁠ ⁠Fu ñeete woni ɓeleɓu níi fu ñampe na koy kilka kaddaꞌ mi ro ra neh a⁠ ⁠? Dalaꞌte woteh, feey fa lecce af yee paŋ fu ra. Yee tas fíi rë, fay mok balaa fu ɗúhíɗ në yii nay fuu ñame. ");
INSERT INTO ndv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Feey fa ay roo paaliɗ tal yëlúp a ñobitaan, te fay pesee iña na línú meeyya ra. ");
INSERT INTO ndv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Fay pesee opaꞌu níi bín nimilaa fu feey fa yugusuu fu ra, ndée fu yugusuu a feey, te fay wëegís fu henaat feey.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ɓëeꞌ hínú Aadama. Ɗi yeɗte ɓeleɓi tii Aawa (daa ri⁠ ⁠: pes), biti daa ri ciffi ɓëyí në pes ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Koo-Yahwee yugusiɗte Aadama a ɓeleɓi búuɓ hun, ɓekke wa, ");
INSERT INTO ndv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","antee won nufi tih⁠ ⁠: «⁠ ⁠Ole⁠ ⁠! Ow madaꞌte a yen leegi, di yúhsëꞌ yin wun a yin ɓos. Kon ɗi ɓanay yeril yaꞌi níi ri sake na koy kilka na onaꞌ pes ra⁠ ⁠; ɗi ɓanay naa ñam, toñeh ɗi ay pese faraah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tígí daaha, Koo-Yahwee antee ɗúhíɗ ɓëeꞌ a ɓeleɓi meeya Eden, wa saañ líné feey fa húmú yugusuu wa ra. ");
INSERT INTO ndv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Filoon fi bee líkëꞌ rí wë meeya ra, Koo-Yahwee ɓeɓpe i sérúbím, tíkké wë ílí meeya Eden, di púlëen naꞌ. Wa habu jépíllí na ñah kíi, na fililoh hatinna ɓéeɓ. Daa wa na wohu waala saañ kilka na onaꞌ pes ra. ");
INSERT INTO ndv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Hompe níi, Aadama ñéerëꞌté a ɓeleɓi Aawa, ɓelaa pokke loo, lahte Kayeŋ. Aawa won tígí daaha tih⁠ ⁠: «⁠ ⁠Koo-Yahwee onte soꞌ níi mi lahte koy ƴaal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Aawa lahilte koy ƴaal kay, Abeel, ñéedí Kayeŋ. Abeel hente níirëh, Kayeŋ hente línëh. ");
INSERT INTO ndv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Lahte bis, Kayeŋ ɓeɓpe na iña lín rí rë, kompe wa Yahwee sarah. ");
INSERT INTO ndv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ɗi fi Abeel ɓeɓ na harra ɗéɓúu límú yubi ra, kompe Yahwee ƴee lukuu wun faan ra sarah. Yee paŋ Abeel ra neɓaꞌte Yahwee, ");
INSERT INTO ndv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ndaa ri yeelay Kayeŋ a iña kúɗ ɗí sarah ra sah. Yii baa tahte Kayeŋ neeɓpe níi ɗoffe ɓúkí. ");
INSERT INTO ndv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yahwee won ɗi tih⁠ ⁠: «⁠ ⁠Fu neeɓ yih⁠ ⁠? Fu ɗof ɓúk yi ɗeeha⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Fu paŋ yin wun raa, fay ɓéyíɗ afu. Henay bah, bakaada aa lakohte ílí faamu ra aa ti gúmú nen, nufa aa ɗoo na, ndaa page níi fu ílíf rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hompe níi, Kayeŋ wonte Abeel i un. Homuu wa meeyyin ra, Kayeŋ yejohte Abeel ñéedí në, bëempé rí. ");
INSERT INTO ndv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Filoon fi baaha, Yahwee won Kayeŋ tih⁠ ⁠: «⁠ ⁠Koy-yaafu Abeel di ɗeh⁠ ⁠?⁠ ⁠» Ɗi tahte won tih⁠ ⁠: «⁠ ⁠Mi yúhëꞌ⁠ ⁠? Daa mi níidí woo⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Koope tahte won ɗi tih⁠ ⁠: «⁠ ⁠Fu pagaꞌ yii baa ɗíh⁠ ⁠? Foŋi ñif mi koy-yaafu kolaꞌ feey níi lahte soo na, na dëekëꞌ yíllíɗ. ");
INSERT INTO ndv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Dalaꞌte woteh, fu alkohte, te fu líkúté feey fa keenaꞌ ñif mi koy-yaafee ke ro bëem fú rë. ");
INSERT INTO ndv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wuti fu lín rí níi lín rëe, fii naa ɗúhríl yin. Fu ac wëndëŋ, fu mbale feey fa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayeŋ won Yahwee tih⁠ ⁠: «⁠ ⁠Daana tík fú sëꞌ rë ɓítté sun fi soꞌ níi ɓít. ");
INSERT INTO ndv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ole⁠ ⁠! Fu líkké sëꞌ feey fa looɓ ra níi may roo wuloh ndín, mi mbale feey fa níi ɓëyí funi teyaꞌ raa bëem sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ndaa Yahwee won ɗi tih⁠ ⁠: «⁠ ⁠Ngana néekíñëꞌ⁠ ⁠! Ow bëem ɗë rëe, fay yíllírú waal paana.⁠ ⁠» Kolaꞌte bah, Yahwee tíinndëꞌté Kayeŋ a yii fí yúhté biti ɓëyí ɓani teyaꞌ ɓéeɓ, nufa taseh hawi húl. ");
INSERT INTO ndv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kayeŋ kolohte dah, saañce hompe gini Not, paaꞌ Eden púlëen naꞌ ra, wulohte Yahwee. ");
INSERT INTO ndv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayeŋ ñéerëꞌté a ɓeleɓi, ɓelaa pokke loo, lahte Henok. Kayeŋ antee yíp gin-taah, yeɗte gina tii koohi, Henok. ");
INSERT INTO ndv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok daa boffi Irat, Irat límpé Mehuyayel, Mehuyayel límpé Metusayel, Metusayel límpé Lemek. ");
INSERT INTO ndv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek kooɗte ɓeleɓ ana⁠ ⁠: ɓelii gaana hínú Aada, ƴutuuda hínú Silla. ");
INSERT INTO ndv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aada límpé Yabal. Yabal daa ciffi ɓëewë dékú taanta te kúrúu i yup ra. ");
INSERT INTO ndv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ñéedí ƴaal hínú Yubal⁠ ⁠; daa ri ciffi ɓëewë na típú koraa, na fiisu kiis ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ɗi fi Silla ɓal, límpé Tubal-Kayeŋ⁠ ⁠; daa ri ɓëeꞌ në húmú tíɓ përëm a tiiŋ ra. Koy-yaafi Tubal-Kayeŋ ɓeleɓ hínú Naama. ");
INSERT INTO ndv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemek won ɓeleɓɓi tih⁠ ⁠: «⁠ ⁠Aada a Silla, síkíríi sëꞌ⁠ ⁠; ɗon fi ɓeleɓɓi soꞌ kélíi woni soꞌ mi Lemek⁠ ⁠: af gaañoh tahte mi bëempé ow ƴaal, mi bëempé kúkëy ƴaal af ŋaasoh. ");
INSERT INTO ndv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kayeŋ yíllírúu waal paana raa, Lemek ay yíllírúu waal sabay paana a waal paana (77).⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Aadama ñéeríilté a ɓeleɓi, wa lahute koy ƴaal kay, ɓelaa yeɗte ri tii Set antee won tih⁠ ⁠: «⁠ ⁠Koope onte soꞌ koy ƴaal kay tígí Abeel fa Kayeŋ bëem ɗí rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ɗi fi Set lahte koy ƴaal ɓal, yeɗte ri tii Enos. Kolaꞌ baaha, ɓëewë daluu jaamiyoh Koope na, na ñeeꞌuu ri tiyi, na dëekúu rí Yahwee. ");
INSERT INTO ndv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Sakaꞌ Koope ow ra, ɗi yugusaꞌ ri ti di man ɗi fi Koope nen. Ɗi sak ow ƴaal a ow ɓeleɓ, barkelte wa, yeɗte wa tii ow yiin saku wa ra. Ƴee daa tii yi ɓëy faam Aadama. ");
INSERT INTO ndv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Lahaꞌ Aadama kíil tíméer a kíil sabay éeyë (130) rë, ɗi lahte koy ki ƴaali mannaꞌte a ri, ti di man ɗi nen⁠ ⁠; ɗi yeɗte ri tii Set. ");
INSERT INTO ndv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Filoon fi límí Set, Aadama pesse kíil tíméer peeye (800)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Pesi Aadama ɓéeɓ hente kíil tíméer payniil a kíil sabay éeyë (930), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Lahaꞌ Set kíil tíméer a kíil iip (105) ra, ɗi límpé Enos. ");
INSERT INTO ndv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Filoon fi límí Enos, Set pesse kíil tíméer peeye a kíil paana (807)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Pesi Set ɓéeɓ hente kíil tíméer payniil a kíil sabboo a kíil ana (912), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Lahaꞌ Enos kíil sabay payniil (90) ra, ɗi límpé Kenan. ");
INSERT INTO ndv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Filoon fi límí Kenan, Enos pesse kíil tíméer peeye a kíil sabboo a kíil iip (815)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Pesi Enos ɓéeɓ hente kíil tíméer payniil a kíil iip (905), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Lahaꞌ Kenan kíil sabay paana ra (70), ɗi límpé Mahaleyel. ");
INSERT INTO ndv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Filoon fi límí Mahaleyel, Kenan pesse kíil tíméer peeye a kíil sabay iniil (840)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Pesi Kenan ɓéeɓ hente kíil tíméer payniil a kíil sabboo (910), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Lahaꞌ Mahaleyel kíil sabay pëenë a kíil iip (65) ra, ɗi límpé Yeret. ");
INSERT INTO ndv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Filoon fi límí Yeret, Mahaleyel pesse kíil tíméer peeye a kíil sabay éeyë (830)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Pesi Mahaleyel ɓéeɓ hente kíil tíméer peeye a kíil sabay payniil a kíil iip (895), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Lahaꞌ Yeret kíil tíméer a kíil sabay pëenë a kíil ana (162) ra, ɗi límpé Henok. ");
INSERT INTO ndv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Filoon fi límí Henok, Yeret pesse kíil tíméer peeye (800)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Pesi Yeret ɓéeɓ hente kíil tíméer payniil a kíil sabay pëenë a kíil ana (962), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Lahaꞌ Henok kíil sabay pëenë a kíil iip (65) ra, ɗi límpé Matusalem. ");
INSERT INTO ndv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Filoon fi límí Matusalem, Henok ñéerëꞌté a Koope kíil tíméer éeyë (300)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Pesi Henok ɓéeɓ hente kíil tíméer éeyë a kíil sabay pëenë a kíil iip (365). ");
INSERT INTO ndv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henok ñéerëꞌ a Koope níi, ɗi olliluy, bi ɓeɓ ri Koo kúɗté rí hëbísí. ");
INSERT INTO ndv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Lahaꞌ Matusalem kíil tíméer a kíil sabay peeye a kíil paana (187) ra, ɗi límpé Lemek. ");
INSERT INTO ndv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Filoon fi límí Lemek, Matusalem pesse kíil tíméer paana a kíil sabay peeye a kíil ana (782)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Pesi Matusalem ɓéeɓ hente kíil tíméer payniil a kíil sabay pëenë a kíil payniil (969), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lahaꞌ Lemek kíil tíméer a kíil sabay peeye a kíil ana (182) ra, ɗi lahte koy ƴaal, ");
INSERT INTO ndv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","yeɗte ri tii Nowe, na anti won tih⁠ ⁠: «⁠ ⁠Kúkëyí bee ay yen hílíp légéyí yen a coono fa tíkëh sun fi yen af feey fa lec Koo-Yahwee bee ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Filoon fi límí Nowe, Lemek pesse kíil tíméer iip a kíil sabay payniil a kíil iip (595)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Pesi Lemek ɓéeɓ hente kíil tíméer paana a kíil sabay paana a kíil paana (777), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Lahaꞌ Nowe kíil tíméer iip (500) ra, ɗi lahte koy ƴaal éeyë⁠ ⁠: Sem, Haam a Yafet. ");
INSERT INTO ndv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Daluu ɓëewë ɓaatoh feey fa níi wa lahute i koy ɓeleɓ ra, ");
INSERT INTO ndv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ɓëy sun olute biti tuŋki cafaƴƴa ɗamute níi ɗam, wa yeeluutee naa ɓeɓ ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tígí daaha, Koo-Yahwee won nufi tih⁠ ⁠: «⁠ ⁠Bakaaɗɗi ow tahte níi mii yeris coonaa fa yeɗ mi ri ra, tas ɗii na faraah⁠ ⁠; ndée ɗi boꞌ faan kut, te yee tas fíi rë, pesi ii luklil kíil tíméer a kíil sabay ana (120).⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Bín fë, ɗeef i ow gaan, jímbëŋ sun, húmú feey fa, te wa húmú lísú në, na ɓeyu ɓëy sun tuŋki cafaƴƴa feey fa ɓeleɓ níi wa lahute i koy ra. Daa wa ƴaal jammbaarree kíilë lahute tii níi rë. ");
INSERT INTO ndv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Olaꞌ Yahwee biti pagaɗɗi ɓossa ɓëewë në ɓaatohte feey fa, te faraah nuffi wa yejaꞌ wa yin ɓos kut ra, ");
INSERT INTO ndv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","keeña ɗúmpé níi rí réeccíyëhté yee sakaꞌ ri ow ra. ");
INSERT INTO ndv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ɗi antee won nufi tih⁠ ⁠: «⁠ ⁠May hap ɓëewë sak mi feey fa ra ɓéeɓ húl níi wa ɗúm ces⁠ ⁠; may waa hap, mi hap raɓɓi gaanna a ƴutuuɗɗa, mi hap ƴakka. Mi réeccíyëhté yee sakaꞌ mi wa ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ndaa keeñ Yahwee sosse Nowe na. ");
INSERT INTO ndv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Bee daa naaɓii Nowe. Ɗi húmú lahaꞌ koy ƴaal éeyë⁠ ⁠: Sem, Haam a Yafet. Di filiɓ ɓëewë wa húmú boku pes bín fë rë, Nowe kut daa húmú júɓ në, lante pagaɗ te ñéerëꞌté a Koope. ");
INSERT INTO ndv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ndaa Koope otte biti pagaɗɗi ɓëewí kayya yahte feey fa⁠ ⁠: ɓëewë feey fa húmú caakute capaꞌ a hawantaꞌ filiɓ fi wa. ");
INSERT INTO ndv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kon olsaꞌ Koope feey fa ra, ɗi otte biti ëldúnë yahte, af biti tílëdí ɓëewë ñeyay waal. ");
INSERT INTO ndv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Koope won Nowe tígí daaha tih⁠ ⁠: «⁠ ⁠Mi caŋke biti may ɗúmlëꞌ a ɓëewë ɓéeɓ. Pagaɗɗi wa tahte níi feey fa líiffé capaꞌ a hawantaꞌ⁠ ⁠; may waa hap ɓéeɓ húl, mi muuyil feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Yugusire ɗoni ɓëy faamu gaal gaan⁠ ⁠; lah yugusee ri a kilki maante, fu saam i las filiɓ, fu leef filiɓ fi gaala a fëel fë ɓéeɓ godoroŋ. ");
INSERT INTO ndv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Lah téyírée rí ɗeh⁠ ⁠: utaa ka lah hena jaak tíméer a jaak sabay iip (150), hagaa ka hen jaak sabay ana a jaak iip (25), cagaa ka hen jaak sabboo a jaak iip (15). ");
INSERT INTO ndv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Lah saamɗe ri taal. Hanndal ki taala a ɓúk gaala, lah hena genwal jaak. Lah saamɗe ri íl fu pëeꞌíɗ ɗí hatin, fu lecsaꞌ ri faam éeyë⁠ ⁠: yínë paaꞌ feey, bee ñee na ra tíkëh sun fi, bee míllëꞌ rë paaꞌ sun. ");
INSERT INTO ndv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«⁠ ⁠Soꞌ mi bee nék, may yeñ mbënë mí gaante, hap yii na pes ɓéeɓ húl. Yii hom sun fi feey fa ɓéeɓ, ay húl. ");
INSERT INTO ndv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ndaa mi pokke hanndal ki yen biti fay múc. Lah haale gaala, ɗoni ɓeleɓu a koyyu a ɓeleɓɓi wa. ");
INSERT INTO ndv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Lah ɓekaalee ɓal heedi yii na pes ɓéeɓ ana-ana, ƴaal a ɓeleɓ, ɗoni wa bok ɗon múc. ");
INSERT INTO ndv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ƴaal yínë a ɓeleɓ yínë di heetti raɓɓa ɓéeɓ⁠ ⁠: ƴakka, raɓɓi gaanna a ƴutuuɗɗa ɓéeɓ ay ac ñéerëꞌ a ro, nda wa mín múc. ");
INSERT INTO ndv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Te ɗo fi beh, saame di yii na ñamu ɓéeɓ fu gaɗ, hen pesii ɗoni wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowe pagaꞌte iñƴaa ɗah. Ɗi pagaꞌ wa ɗee túuƴëꞌ rí Koope ra. ");
INSERT INTO ndv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Koo-Yahwee antee won Nowe tih⁠ ⁠: «⁠ ⁠Haale gaala ɗoni ɓëy faamu, ndée mi otte biti filiɓ ɓëewë ɗoni wa na pesu wote ra ɓéeɓ, ɗoni afu kut daa júɓú në. ");
INSERT INTO ndv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Heetti raɓɓa wun hawiɗ ra ɓéeɓ, lah kúrëelée në ƴaal paana a ɓeleɓ paana. Ndaa heetti raɓɓa wúníh hawiɗ ra, lah kúrëelée bina-bina waa na ɓéeɓ ana kut, ƴaal a ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Yii leŋke heetti ƴakka ɓal, lah kúrëelée në ƴaal paana a ɓeleɓ paana, nda tisoh ki wa mín tas faraah feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ndée yiin nimila bisi bee ra, may yíin muluɓ feey fa naꞌ a elek, ii lécíɗ níi hen waal sabay iniil⁠ ⁠; yii mi sakke ri te na pes feey fa ɓéeɓ, may rii hap húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nowe paŋke iña túuƴ rí Yahwee ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowe húmú lahaꞌ kíil tíméer pëenë (600) na cép mbënë më feey fa ra. ");
INSERT INTO ndv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nowe a ɓeleɓi, koyyi a ɓeleɓɓi wa haalute gaala, nda wa mín múc mbënë më. ");
INSERT INTO ndv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Raɓɓa wunu hawiɗ a ƴee wúníh rë, ƴakka a raɓɓi ƴutuuɗɗa na pesu feey fa ra ɓéeɓ ");
INSERT INTO ndv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ayuute Nowe na ana-ana, ƴaal a ɓeleɓ, wa haalute gaala ti ɗee húmú túuƴëꞌ rí Koope ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Nimilaꞌ bisa ra, mulii mbënë më tiilte, dalte húuní feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Kíilí tíméer pëenë (600) fí pesi Nowe, bisi sabboo a paana fa di céyín fí ana fa, bisi baaha, culli mulaa keeñ feey ɓéeɓ ɗofohte, íllí mulaa sun kúnsëhté gëyéet. ");
INSERT INTO ndv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mulaa na yíidëh feey fa⁠ ⁠; naꞌ a elek, toba ii lécíɗ níi hen waal sabay iniil (40). ");
INSERT INTO ndv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Yiin fa, Nowe a ɓeleɓi a koyyi⁠ ⁠: Sem, Haam a Yafet, a ɓeleɓɓi wa haalute gaala, ");
INSERT INTO ndv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","wani heetti raɓɓa luufa a ƴee faamma ɓéeɓ, raɓɓi ƴutuuɗɗa, ƴakka a yii na pún ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Heedi yii na pes ɓéeɓ ayaꞌ Nowe na ana-ana filiɓ gaala. ");
INSERT INTO ndv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ti ɗee húmú túuƴëꞌ rí Koope Nowe ra, heetti iña haaluu gaala ana-ana, ƴaal a ɓeleɓ. Haalaꞌ Nowe ra, Yahwee kúnté ílí gaala. ");
INSERT INTO ndv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mulii mbënë më yíidëhté yii hente waal sabay iniil (40) feey fa. Lawaꞌ mulaa ra, gaala ɓéyrëhté feey fa, teeƴce sun. ");
INSERT INTO ndv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ɓaataꞌ mulaa lap ra, wa caak caako feey fa níi gaala na jëewëh sun na saañ. ");
INSERT INTO ndv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Caakaꞌ mulaa níi caak naaŋalte feey fa ra, daŋŋa lukki ut fëgërëh fí Koo ra ɓéeɓ honohte. ");
INSERT INTO ndv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mulaa lap lawo níi míllëꞌtée hel affi daŋŋa yii lukke kap paana sun. ");
INSERT INTO ndv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ɗaaha, yii na pes feey fa ɓéeɓ húlté⁠ ⁠: ƴakka, raɓɓa faamma a ƴee luufa, raɓɓi ƴutuuɗɗa na tílú feey fa ra a ɓëewë ɓéeɓ ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Yii kúɗté ñíin te na pes feey fa ɓéeɓ húlté. ");
INSERT INTO ndv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ɗaaha, Koo-Yahwee paɗte yii na pes feey fa ɓéeɓ, dalaꞌte ɓëewë në, níi raɓɓi gaanna a ƴutuuɗɗa a ƴakka. Wa ɗúmúté feey fa. Nowe kut daa tas a ɓëy faami, a iña ñéerúu a wa filiɓ gaala ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Laahi mulaa hompe waal tíméer a waal sabay iip (150) sun fi feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ndaa Koope halay Nowe a raɓɓa faamma a ƴee luufa ñéerúu a ri filiɓ gaala ra. Tígí daaha ɗi yeñce mbëeyë, mulaa feey fa na ëylëh. ");
INSERT INTO ndv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Culli mulaa keeñ feey a íllí mulaa sun kúnëhté. Koo seekke, ");
INSERT INTO ndv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","mulaa na ëylëh ƴin-ƴin. Waal tíméer a waal sabay iip (150) filoon fi dalaani mbënë më, ɗeef mulaa ëylëhté feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Lahaꞌ céyín fi paana fa waal sabboo a waal paana ra, gaala teerte daŋŋi Ararat. ");
INSERT INTO ndv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mulaa na ëylëh na cép níi céyín fí sabboo fa. Bisa ɗéɓ céyín fí baaha ra, lahte affi daŋŋi ɗúhté mulaa. ");
INSERT INTO ndv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tíkëhté waal sabay iniil (40), Nowe kúníssé falanteera húmú saamiɗ ɗi gaala ra, ");
INSERT INTO ndv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","antee yeris ŋaak púnté. Ŋaak fa na pay na ac níi bín nëy síiñée mulaa feey fa ra. ");
INSERT INTO ndv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hompe níi, Nowe yerisse bëdú púnté, fahaꞌ yúh nda mulaa céppé. ");
INSERT INTO ndv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ndaa bëdú fë olay tígí nay rii yabe, af biti mulaa líssí húun feey fa ɓéeɓ. Ɗi yeeltee nimil gaala, Nowe yeɗte yaꞌi hampe ri, ɓekke ri filiɓ gaala. ");
INSERT INTO ndv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nowe sehte waal paana kay, antee yeɗɗaat bëdú fë púnté. ");
INSERT INTO ndv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Sosaɗ naꞌin, bëdú fë nimilte Nowe na, ŋaɓpe liim-liim saaf kilka na wonuu ëlíif rë. Tígí daaha, Nowe yúhté biti mulaa ëylëhté feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ɗi sehaatte waal paana kay, yeɗɗilte bëdú fë púnté, ndaa bëdú fë nimlaatay ɗii na. ");
INSERT INTO ndv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Yiin lah Nowe kíil tíméer pëenë a kíil yínë (601) rë, yiin fa, mulaa feey fa síiñ në. Nowe pëeníssé taali gaala, yérëntëhté, otte biti mulaa síiñcé feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Lahaꞌ céyín fí ana fa waal sabay ana a waal paana ra, feey fa ɓéeɓ súhté koroŋ. ");
INSERT INTO ndv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tígí daaha, Koope won Nowe tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«⁠ ⁠Ɗúhé gaala, ɗoni ɓeleɓu a koyyu a ɓeleɓɓi wa. ");
INSERT INTO ndv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ɗúhré ɓal yii na pes te ɗoni wa homu ra ɓéeɓ⁠ ⁠: heetti ƴakka, raɓɓi gaanna a ƴutuuɗɗa ɓéeɓ⁠ ⁠; wa keñun, wa ɓaatoh níi wa haslaꞌ feey fa ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nowe ɗúhté gaala ɓani ɓeleɓi a koyyi a ɓeleɓɓi wa, ");
INSERT INTO ndv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","heetti yii na pes ɓéeɓ na anti ɗúh ɓal gaala⁠ ⁠: heetti ƴakka, raɓɓi gaanna a ƴutuuɗɗa na tílú feey fa ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nowe antee tíkëlsëꞌ i laꞌ, yípíɗté Koope ílíƴ hawraa. Di heetti raɓɓa a ƴakka wun hawiɗ ra ɓéeɓ, ɗi ɓeɓpe na bina-bina ɓéeɓ yínë, happe wa, tamiɗte wa Koo-Yahwee sun fi laꞌ ya níi wa sooyte. ");
INSERT INTO ndv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ngedi iña tamu ra neɓaꞌte Yahwee. Ɗi antee won nufi tih⁠ ⁠: «⁠ ⁠Yee tas fíi rë, pagaɗɗi ow ii tah mi alaklil feey fa. Kaah biti nuf ow mëssí yejaꞌ yíkíi ɓos, kúkëy kí níi ɓaha ki. Ndaa dalaꞌte woteh, mii hawil yii na pes ti ɗee pagaꞌ mi ri ɗee ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Hém feey fa ee na⁠ ⁠: soh a lec, sos a op, líƴ a yoh, naꞌ a elek, ay lah faraah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Koope barkelte Nowe a koyyi, won wa tih⁠ ⁠: «⁠ ⁠Kéñí, ɗon ɓaatoh níi ɗon líifíɗ feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Raɓɓa feey fa ɓéeɓ ay ron neeh níi tígí teem neeh⁠ ⁠: raɓɓi gaanna, ƴutuuɗɗa, ƴakka sun a jénnë kísí fë ɓéeɓ⁠ ⁠; wa ɓéeɓ, mí tíkké wë yaꞌ yon. ");
INSERT INTO ndv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Di húmú onaꞌ mi ron gaaw fi hilila pesaa, mi onte ron woteh yii na tíl te na pes sun fi feey fa ɓéeɓ, hen pesii ron. ");
INSERT INTO ndv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ndaa di filiɓ fi baaha ɓéeɓ, ngënë ñëmí boꞌ fi líssí lah ñif, ndée pes ee ñif. ");
INSERT INTO ndv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Yúhí biti ɓal may pegoh ñif ma na tah ɗon pes ra⁠ ⁠; hawaa raɓ ow húl ɓéeɓ, may rii pegoh ñif ma kéeníɗ ɗí rë, te ow bëem moroomi, may rii pegoh ñíin ɓëeꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ɓëyí kéeníɗ ñíin ow, ay hawu húl, ndée mi sak ow ti di man mi nen. ");
INSERT INTO ndv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Te ɗon fi ƴah, kéñí ɗon ɓaatoh caak níi ɗon líifíɗ feey fa ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Koope ɓaatte won Nowe a koyyi tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«⁠ ⁠Soꞌ mi beh, mee pok yin hanndal ki ɗon a soꞌ, a séttën, a ɓëewë nay aye filoon fi wa ra, ");
INSERT INTO ndv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","a yii na pes hëbíssën ɓéeɓ⁠ ⁠: ƴakka, raɓɓi faamma a ƴi luufa, ƴee ɗúhú gaala ra a ƴee nay pese feey fa fayu ra ɓéeɓ ee. ");
INSERT INTO ndv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Yee pok mi ra daa ri bitih⁠ ⁠: dee níi kiri fi kirih, mulii mbënë më ii boolliil ñíinnë feey fa, hap wa ɓéeɓ húl, te muluɓ mbënë ii yahlil feey fa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Koope ɓaatte won tih⁠ ⁠: «⁠ ⁠Bee daa tíinndëꞌí yee pok mi hanndal ki ɗon a soꞌ, a iña na pesu a ɗon ra ɓéeɓ, dee níi kiri fi kirih. ");
INSERT INTO ndv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mi tíkké kuɗ ki soꞌ sun, daa ri tíinndëꞌë nay nérsée yee pok mi a ëldúnë rë. ");
INSERT INTO ndv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Wahtii négírëe mí nérrë sun te kuɗ ki soꞌ ɗúh rëe, ");
INSERT INTO ndv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","faraah may nérsëh yee pok mi hanndal ki yen ra, a yii na pes ɓéeɓ⁠ ⁠; te mbënë gaan ii lahlil níi hawe yii na pes ɓéeɓ húl. ");
INSERT INTO ndv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mi ot kuɗ ka ɗúh rëe, may nérsëh yee pok mi te mínéh ɗúm hom hanndal ki funi yii na pes ɓéeɓ rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Koope antee ñeyaat unna, won Nowe tih⁠ ⁠: «⁠ ⁠Kuɗ ki Koo daa tíinndëꞌí yee pok mi hanndal ki funi yii na pes feey fa ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Sem, Haam a Yafet daa koyyee ke Nowe húmú ɗúhú gaala ra. Haam daa boffi Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ɓëewë feey fa ɓéeɓ ɗúhúu koyyi éeyëyée ké Nowe ƴaa na. ");
INSERT INTO ndv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowe daa línëhë ɗéɓpí yíp reseñ, kilka koyya na yugusuu béeñ rë. ");
INSERT INTO ndv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Lahte bis Nowe hante na béeñë, faana núgúté níi nísëhté faan holoŋ filiɓ taantii. ");
INSERT INTO ndv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Haam, boffi Kanaan, olaꞌ ri faani holoŋa homaꞌ boffi ra, ɗúhté ëssín, ɓílíɗté rí koy-yaayyi. ");
INSERT INTO ndv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem a Yafet koluute, ɓeyute úuf, bee hampe ɓúgí beh, bee hampe ɓúgí yínëe, wa tíkúté rí yúkkí wë, na tílúu paaꞌ filoon níi haalute taantaa, húunúté boffi wa. Wa oluy boffi wa faan holoŋ, bi ƴíirúy wë hatna paaꞌ ɗii na ra. ");
INSERT INTO ndv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Gíníkëꞌ Nowe manii ra, ɗi kelohte yee paŋ koy kee ke ri lukki paaꞌ kúkëy rë. ");
INSERT INTO ndv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ɗi won daaha tih⁠ ⁠: «⁠ ⁠Ɗémíin Kanaan alkoh⁠ ⁠! Na ri hena ñaami súrgë yí koy-baappi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nowe ɓaatte, won tih⁠ ⁠: «⁠ ⁠Koo-Yahwee daa mit sím⁠ ⁠! Ahaŋkay, Koope fa na jaamiyoh Sem ra daa mit sím⁠ ⁠! Ɗémíin Kanaan ƴaha ñaami Sem. ");
INSERT INTO ndv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ɗémíin Koo keñil Yafet, on ɗi feey gaan, ɗi dék a Sem, te Kanaan ƴaha ñaami Yafet ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Filoon fi mbënë më, Nowe pesse kíil tíméer éeyë a kíil sabay iip (350). ");
INSERT INTO ndv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Pesi Nowe ɓéeɓ hente kíil tíméer payniil a kíil sabay iip (950), ɗi na anti húl. ");
INSERT INTO ndv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Filoon fi mbënë më, koyyi Nowe⁠ ⁠: Sem, Haam a Yafet, lahute i koy. Ƴee daa tii yi koyyi ƴaalla tala. ");
INSERT INTO ndv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Koyyi Yafet daa wa ƴeh⁠ ⁠: Gomeer, Magok, Madaay, Yawan, Tubal, Mesek a Tiras. ");
INSERT INTO ndv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ƴee daa koyyi Gomeer⁠ ⁠: Askenas, Rifat a Togarma. ");
INSERT INTO ndv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ƴee daa koyyi Yawan⁠ ⁠: Elisa, Tarsis, Kittim a Rodanim. ");
INSERT INTO ndv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ɓëewë hasluu ginna hom ɓúk kísí fë rë ɓéeɓ coosaanuu koyyi Yawan. Ƴaa daa koyyi Yafet a séttí. Ow fi ow waa na ɓéeɓ lahte wonadi, te ɗi dék feey fi a ɓëy tali. ");
INSERT INTO ndv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ƴee daa koyyi Haam⁠ ⁠: Kús, Misrayim, Púut a Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ƴee daa koyyi Kús⁠ ⁠: Sebaa, Hawilaa, Sapta, Rayma a Sapteka. Ƴee daa koyyi Rayma⁠ ⁠: Saba a Dedan. ");
INSERT INTO ndv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Nemrot ɓal non koyyi Kús. Daa ri ɗéɓpí hen jammbaar feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nemrot daa húmú mín ɓoorsoh níi fíi Koo. Yii baa daa komaꞌ yee na wonuu⁠ ⁠: «⁠ ⁠Mínté ɓoorsoh níi fíi Koo, ti Nemrot nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ginna ɗéɓpí hen gin gaan nguur ki ra daa wa ƴeh⁠ ⁠: Babel, Erek, Akkat a Kalne⁠ ⁠: wa ɓéeɓ gin-taah di Sineyar. ");
INSERT INTO ndv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nemrot kolaꞌ gini bah saañce Asiri, yíppé gini Níníif, Rehobot-Ir, Kalah ");
INSERT INTO ndv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","(gin-taah gaan), a Resen fa hom hanndal ki Kalah fi bah, a Níníif rë. ");
INSERT INTO ndv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrayim daa ciffi Lúɗɗë, Anamma, Lehaɓɓa, Naftu ya, ");
INSERT INTO ndv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ɓëy Patoros, Kaslu ya (ɓëy Fílístí coosaanuu waa na), a ɓëy Kaftoor. ");
INSERT INTO ndv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan daa boffi Sidon koy ki saawi, a Het⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","daa ri ciffi ɓëy Yébús, Amoorra, Girgassa, ");
INSERT INTO ndv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Híwwë, ɓëy Arka, ɓëy Sín, ");
INSERT INTO ndv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ɓëy Arwat, ɓëy Sumra, a ɓëy Hamat. Talli ɓëy Kanaan hasluute filoon fe, ");
INSERT INTO ndv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","te feey fi wa dalaꞌ Sidon, laɗte waal Geraar níi Gaasaa, a waal Sodom, Gomoor, Atma, a Seboyim níi Lesaa. ");
INSERT INTO ndv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ƴaa daa koyyi Haam. Tal fi tal ɓéeɓ a wonadi, di gini a feey fi. ");
INSERT INTO ndv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem ɓahii Yafet, lahte i koy ɓal. Daa ri ciffi Ebeer a ɓëewë coosaanuu ɗii na ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ƴee daa koyyi Sem⁠ ⁠: Elam, Asuur, Arpaksat, Lút a Aram. ");
INSERT INTO ndv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ƴee daa koyyi Aram⁠ ⁠: Úus, Húul, Geteer a Maas. ");
INSERT INTO ndv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksat daa boffi Selaa⁠ ⁠; Selaa daa boffi Ebeer. ");
INSERT INTO ndv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeer lahte koy ana⁠ ⁠: saawa hínú Pelek (daa ri⁠ ⁠: haslaꞌ), af biti na pesaꞌ ri ra, ɓëewë feey fa hasluu na⁠ ⁠; ñéedí hínú Yoktan. ");
INSERT INTO ndv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan daa boffi Almodat, Selef, Hasarmawet, Yerah, ");
INSERT INTO ndv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO ndv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimayel, Saba, ");
INSERT INTO ndv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawilaa a Yobap⁠ ⁠; ƴaa ɓéeɓ koyyi Yoktan. ");
INSERT INTO ndv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Wa húmú dékú hanndal ki Mesa a daŋi Sefaar fa paaꞌ púlëen naꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ƴaa daa koyyi Sem. Tal fi tal ɓéeɓ a wonadi, di gini a feey fi. ");
INSERT INTO ndv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ƴaa daa talla coosaanuu koyyi Nowe na ra, gin fi gin ɓéeɓ a coosaani. Ginna haslaꞌ feey fa filoon fi mbënë më rë ɓéeɓ, ɗúhúu waa na. ");
INSERT INTO ndv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bee filoon, ɓëewë feey fa ɓéeɓ húmú lahuu wonaɗ yínë, te unna yínë. ");
INSERT INTO ndv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Wa koluute tígë húmú wë rë, na tílú níi lahute deyi feey fi yéeddëꞌté di Sineyar waal púlëen naꞌ, wa yípúté faammi wa daaha. ");
INSERT INTO ndv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Hompe níi, wa wonantuu filiɓ fi wa tih⁠ ⁠: «⁠ ⁠Këlíi yen yuliɗ légéyë këewé⁠ ⁠! Yen mahun i mëel, yen hút wë⁠ ⁠!⁠ ⁠» Wa taɓahuu a mëellí ƴaaha, ɓeyute godoroŋ, cookiyuute wa. ");
INSERT INTO ndv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Wa na anti wonantuu tih⁠ ⁠: «⁠ ⁠Yen yuliɗ légéyë, yen yíp gin-taah, lah taahi gaani uta uto níi afa haal nérrín. Hen ɗaaha raa, yen ay lah tii, te yen ii haslaꞌ feey fa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Hompe níi, Koo-Yahwee céppé olsohi gina a taahi uda na taɓahu ɓëewë rë. ");
INSERT INTO ndv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Nimilaꞌ ri sun ra, ɗi won nufi tih⁠ ⁠: «⁠ ⁠Bee homu wa bee ra, wa ɓéeɓ henute yínë, te wa wonuu wonada yínë. Wa daluun ɗee raa, daa ri biti yii peen wa fíi ɓéeɓ, wa mín ríi cëgíɗ. ");
INSERT INTO ndv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kon yen cépëet ndín yen ɓekalsaꞌ wonadi wa níi wa kélëntíih.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ɗaaha, Yahwee tasaaraꞌte goomali ɓëewë daaha, wa hasluute feey fa ɓéeɓ, wa míllúuy lúsíɗ taɓahi gina. ");
INSERT INTO ndv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Yii baa daa komaꞌ tii Babel fa na wonuu tígí daaha ra (Babel daa ɓekalsaꞌ). Daaha, Yahwee ɓekalsaꞌ wonadi ɓëewë në, haslaꞌte ɓëewë feey fa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ƴee daa tii yi ɓëy faam Sem⁠ ⁠: lahaꞌ Sem kíil tíméer (100) rë, ɗi límpé Arpaksat filoon fi bee gétëꞌ mbënë më kíil ana ra. ");
INSERT INTO ndv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Filoon fi límí Arpaksat, Sem pesse kíil tíméer iip⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksat húmú lahaꞌ kíil sabay éeyë a kíil iip (35) na lím rí Selaa ra. ");
INSERT INTO ndv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Filoon fi límí Selaa, Arpaksat pesse kíil tíméer iniil a kíil éeyë (403)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Lahaꞌ Selaa kíil sabay éeyë (30) rë, ɗi límpé Ebeer. ");
INSERT INTO ndv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Filoon fi límí Ebeer, Selaa pesse kíil tíméer iniil a kíil éeyë (403)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Lahaꞌ Ebeer kíil sabay éeyë a kíil iniil (34) ra, ɗi límpé Pelek. ");
INSERT INTO ndv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Filoon fi límí Pelek, Ebeer pesse kíil tíméer iniil a kíil sabay éeyë (430)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Lahaꞌ Pelek kíil sabay éeyë (30) rë, ɗi límpé Réwú. ");
INSERT INTO ndv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Filoon fi límí Réwú, Pelek pesse kíil tíméer ana a kíil payniil (209)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Lahaꞌ Réwú kíil sabay éeyë a kíil ana (32) ra, ɗi límpé Sérúk. ");
INSERT INTO ndv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Filoon fi límí Sérúk, Réwú pesse kíil tíméer ana a kíil paana (207)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Lahaꞌ Sérúk kíil sabay éeyë (30) rë, ɗi límpé Nahoor. ");
INSERT INTO ndv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Filoon fi límí Nahoor, Sérúk pesse kíil tíméer ana (200)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Lahaꞌ Nahoor kíil sabay ana a kíil payniil (29) ra, ɗi límpé Terah. ");
INSERT INTO ndv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Filoon fi límí Terah, Nahoor pesse kíil tíméer a kíil sabboo a kíil payniil (119)⁠ ⁠; ɗi lahte na i koy kay. ");
INSERT INTO ndv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Lahaꞌ Terah kíil sabay paana (70) ra, ɗi límpé Abraam, Nahoor a Haran. ");
INSERT INTO ndv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ƴee daa tii yi ɓëy faam Terah⁠ ⁠: Terah daa boffi Abraam, Nahoor a Haran. Haran límpé Lot. ");
INSERT INTO ndv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran daa ɗéɓ boffi húl. Ɗi húlëꞌ Úur di Kalde, gina límúu rí rë. ");
INSERT INTO ndv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abraam kooɗte Saaray⁠ ⁠; Nahoor kooɗte Milka koy Haran. Haran daa boffi Yiskaa ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Koo húmú teeɓay Saaray koy. ");
INSERT INTO ndv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah fahaꞌ saañ Kanaan koon, kúrëelëhté koohi Abraam a sédí. Sédí baaha, ɗi Lot koy Haran. Ɗi kúrëelëhté Saaray ɓal, ɓeleɓ Abraam. Ɓani wa koluute Úur di Kalde, ndaa lahuu wa gina na wonuu Haran ra, wa yípúté faam wa na. ");
INSERT INTO ndv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah húlëꞌ Haran daaha, ɗeef ɗi lahte kíil tíméer ana a kíil iip (205). ");
INSERT INTO ndv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Lahte bis, Koo-Yahwee won Abraam tih⁠ ⁠: «⁠ ⁠Kolee ginon, fu hel mboko yu a ɓëy faamon ndín, fu saañ gina nay mi roo kúré rë. ");
INSERT INTO ndv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","May paŋ níi talu gaan, te may roo barkel. Fay lah tii te barkuu ay kaɗ ɓëewí kayya. ");
INSERT INTO ndv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","May barkel ɓëyí ɗagiɗ ro yin wun, ndaa ɓëyí cuñ ro, may rii alak. May ñeyee ɗoo na mi barkel talla feey fa ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abraam kolaꞌ ɗaaha Haran, saañce ti ɗee túuƴëꞌ rí Yahwee ra nen. Lot ñéerëꞌté a ri. Na koloh Abraam daaha ra, ɗeef ɗi húmú lahaꞌ kíil sabay paana a kíil iip (75). ");
INSERT INTO ndv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abraam kúrëelëhté ɓeleɓi Saaray a Lot koy ñéedí. Wa kúrëelúuté alal ma lahuu wa ra ɓéeɓ a ñaamma lomuu wa Haran ra, ɓeyute waali Kanaan. Lahuu Abraam a ɓëy faami Kanaan ra, ");
INSERT INTO ndv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","wa húusúté gina níi wa lahute tal kilki gaani Moore na yúulúu rë, di Sihem. Bín fë, ɗeef ɓëy Kanaan dékú deyi baaha. ");
INSERT INTO ndv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahwee feeñiyohte Abraam won ɗi tih⁠ ⁠: «⁠ ⁠Fu otte feey fi bee a⁠ ⁠? May yere ri ɓëyí non talu⁠ ⁠!⁠ ⁠» Abraam yípíɗté Yahwee fa feeñiyoh ri ra ílíƴ hawraa daaha. ");
INSERT INTO ndv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ɗi kolaꞌ dah, saañce deyi daŋŋa paaꞌ Betel púlëen naꞌ ra, yíppé taanta yi hanndal ki Betel a Aay. Betel paaꞌaꞌ ri haalaan naꞌ, Aay paaꞌaꞌ ri púlëen naꞌ. Ɗi yíppé ílíƴ hawraa kay daaha. Na yúulëh rí Koope na ra, ɗi ñeyaꞌ ri tiyi, dëekëꞌté rí Yahwee. ");
INSERT INTO ndv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Filoon fi baaha, Abraam ɗoffe taanta yi, ɓeɓpe waali Negep, na laay na saañ, na laay na saañ. ");
INSERT INTO ndv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Hompe níi yaaɓ haalte gina. Misigi yaaba tahte níi Abraam saañce maangaan Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tílúu wë níi wa leɓuute gina ra, Abraam won ɓeleɓi Saaray tih⁠ ⁠: «⁠ ⁠Ole, mi yúhté biti fu ɓelii ɗampe. ");
INSERT INTO ndv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ɓëy Ésíp ot ɗo raa, wa ay won nuffi wa biti fu ɓeleɓ soꞌ, wa ay soo hap húl, yeris ɗo fu pes. ");
INSERT INTO ndv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hém neɓaꞌ ro, lah wone wa biti fu ñéedí sëꞌ, nda wa mín sëe ham hami wunte af ɗo, wa yeris soꞌ mi pes.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ɗaaha, lahaꞌ Abraam Ésíp rë, ɓëy Ésíp olute biti ɓelaa ɗampe níi ɗam. ");
INSERT INTO ndv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","I dak di dakki buuri Ésíp olute ɓelaa, laasute ɗami fíi buur. Ɓelaa ɓeyute, komute buur faam. ");
INSERT INTO ndv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Af Saaray tahte buur hampe Abraam hami wunte, onte ri i har, i peꞌ a i fana, yeɗte ri i súrgë ƴaal a ɓeleɓ, onte ri i mbaam ƴaal a ɓeleɓ a i géléem. ");
INSERT INTO ndv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ndaa Koo-Yahwee ɓekke buur a ɓëy faami jérrí misikke, af Saaray ɓeleɓ Abraam. ");
INSERT INTO ndv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Buur antee dëekrëh Abraam won ɗi tih⁠ ⁠: «⁠ ⁠Fu pagaꞌ soꞌ pagadi baa ɗíh⁠ ⁠? Yi tah fu wonay soꞌ biti yaa ɓeleɓu⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Fu wonaꞌ biti ɗi ñéedú ɗíh, níi ma na ɓeɓ ɗi ɓeleɓ⁠ ⁠? Leegi ɓeleɓu abah⁠ ⁠; ɓeye ri te fu saañ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Tígí daaha, buur túuƴcé súrgë yí ɓeni Abraam níi ɗúhëení gina, ɓani ɓeleɓi a alal ma lahaꞌ ri ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abraam kolaꞌ ɗaaha Ésíp, nimilte Negep, ɓani ɓeleɓi a alal ma lahaꞌ ri ra ɓéeɓ. Lot ñéerëꞌté a ri. ");
INSERT INTO ndv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abraam húmú caakke yin⁠ ⁠: ɗi húmú lahte i yup gaan, caakke tiiŋ hélíis a úrís. ");
INSERT INTO ndv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ɗi kolohte Negep, na laay na saañ, na laay na saañ níi ri lahte Betel, tígë húmú yíp rí taanta yi hanndal ki Betel a Aay ra. ");
INSERT INTO ndv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tígë húmú yípëꞌ rí ílíƴ hawraa daaha ra, Abraam yúulëhté Koope na, ñeyaꞌte tiyi, dëekëꞌté rí Yahwee. ");
INSERT INTO ndv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot fa húmú ñéerëꞌ a ri ra, húmú lahte i yup har ɓal a peꞌ a fana. Ɗi húmú lahiɗte afi taanta yi dékún ɓani ɓëy faami a súrgë yí ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Caagi ɓëewë a yuppa tahte níi wa ɗëmlíh deya homu wa ra, ");
INSERT INTO ndv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ɓaatte biti ɓëy Kanaan a Péríssë húmú dékú deyi baaha ɓal. Lahte bis, níirëh yí Abraam a ƴi Lot pooꞌuute. ");
INSERT INTO ndv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tígí daaha, Abraam won Lot tih⁠ ⁠: «⁠ ⁠Powaꞌ ɗameh hanndal ki yen mbée hanndal ki níirëh yí yen, ndée daa mi ɓap mi yeɗte boffu. ");
INSERT INTO ndv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Gina ɓéeɓ ee fíyú ee hëréet. Yen ay ɗaree ɗaroo⁠ ⁠: fu saya yaꞌ ñamaa raa, mi saañ yaꞌ sugu, te fu saya yaꞌ sugu raa, mi saañ yaꞌ ñamaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot ɓéyíɗté afi, otte biti deyi húur mí Yurdeŋ ɓéeɓ húmú hilisse níi hilis. Na muuyilay Koo-Yahwee Sodom a Gomoor doom ra, ɗeef húur mí Yurdeŋ daa níi Sowaar húmú man a meeya húmú saamiɗ Koope Aadama a Aawa ra, hilisse ti ɗee hilsaꞌ feey fa ɓúk laahi Níl rë nen. ");
INSERT INTO ndv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot tanisse deyi húur mí Yurdeŋ waal púlëen naꞌ, laayte dín fë, wa ɗaruute ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abraam tasse Kanaan, Lot saañce, dékké hëbís gin-taah yi Yurdeŋ, yíppé taanta yi níi waal Sodom. ");
INSERT INTO ndv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ɓëy Sodom húmú tooñuu Yahwee tooññi misikke, af pagaɗɗi ɓossi wa. ");
INSERT INTO ndv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sayaꞌ Lot ra, Yahwee won Abraam tih⁠ ⁠: «⁠ ⁠Dalee olsoh kottu, fu ɓéyíɗ afu, fu yeel hatinna ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Deya ot fu baa ra ɓéeɓ, mi onte ri ɗoni ɓëy talu níi kiri fi kirih. ");
INSERT INTO ndv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","May keñil talu, séttú caak níi ow ii waa mín kín, ti ɗee mínéh ow kín peppi feey fa ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kolee fu tílëesëh deyi baa ɓéeɓ, ndée mi on ɗo ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abraam saañce yíppé taanta yi filiɓ kilikki gaanni Mamre di hëbís gini Heboron. Ɗi yípíɗté Yahwee ílíƴ hawraa daaha. ");
INSERT INTO ndv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Bín fë, Amrafel buuri Sineyar, Ariyok buuri Elasaar, Kedoor-Lawomeer buuri Elam a Tideyal buuri Gëyím, ");
INSERT INTO ndv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","yejuute haaꞌ a Beraa buuri Sodom, Birsaa buuri Gomoor, Sineyap buuri Atma, Semebeer buuri Seboyim a buuri Belaa (Belaa daa Sowaar). ");
INSERT INTO ndv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Buurri iippi ƴaa lígínúuté húur mí Sídím, bee kísí fí miraa ma naaf ri woteh ra. ");
INSERT INTO ndv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Húmú hente kíil sabboo a kíil ana Kedoor-Lawomeer daa ílíf wë⁠ ⁠; ndaa kíilë tíkëh në rë, wa kaaꞌuute. ");
INSERT INTO ndv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kíilë tíkíil në rë, Kedoor-Lawomeer a buurra ñéerúu a ri ra koluute haaꞌi buurri iippi kayya. Lahuu wa waala ra, wa hawute Refa ya di Asetarot-Karnayim, hawute Sússë di Ham, a Émmë di deyi Kiriyatayim. ");
INSERT INTO ndv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ndaa wa hawuu Horra daŋŋa gin wa di Séyíir, yejute wa níi luufi El Paran. ");
INSERT INTO ndv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Wa anutee nimilaꞌ waal En-Misepat fa na wonuu Kades ra. Wa ɗakaƴuute deyi Amalekka ɓéeɓ, hawute Amoorra dékú Hasason-Tamaar ra ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hawuu buurri iniilla ɓëewí ƴaa ɓéeɓ rë, wa caguute haaꞌ a buurri iippa lígínúu ɓëewí wë húur mí Sídím rë. Tígí daaha, buuri Sodom, bi Gomoor, bi Atma, bi Seboyim a bi Belaa fa na wonuu Sowaar ra, ɗúhrúté ɓëewí wë, yejuute haaꞌ di húur mí Sídím ");
INSERT INTO ndv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","a Kedoor-Lawomeer buuri Elam, Tideyal fi Gëyím, Amrafel fi Sineyar, a Ariyok fi Elasaar⁠ ⁠: hente buur iippi haaꞌuu a buur iniil. Kedoor-Lawomeer a ɓëewí míllúutée ɓaŋ haaꞌa. ");
INSERT INTO ndv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ɗeef húur mí Sídím húmú caakke yéemmí lahaꞌ godoroŋ filiɓ⁠ ⁠: buuri Sodom a bi Gomoor homu hegoh, keenute filiɓ yéemmë⁠ ⁠; ɓëewë múcú rë heguute, ɗapuute filiɓ daŋŋin. ");
INSERT INTO ndv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ɓëewë ɓagu ra ɓeyute alal ma Sodom a Gomoor, a pesaa ya ɓéeɓ, anutee saañ. ");
INSERT INTO ndv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Bi húmú dék Lot koy ñéedí Abraam Sodom, wa kúrëelúuté rí ɓal a alal ma lahaꞌ ri ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Lahte ɓëyí hegaꞌ haaꞌin, acce teeɓi Abraam Ébrëe yee lah ra. Abraam húmú yípëꞌ faami talli kilikki gaanni Mamre fi Amoora. Mamre húmú mboko mi Esekol a Aneer⁠ ⁠; ɓëewí ƴaa a Abraam húmú pokantuute biti haaꞌ lah raa, wa ay habrantaꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Kelaꞌ Abraam biti mboko mi habute haaꞌin ra, ɗi ɗúhíɗté ow tíméer éeyë a ow sabboo a ow peeye (318) di ɓëewë faami⁠ ⁠; wa koluute daɓaadi ɓëewë kúrú Lot ra níi wa lahute Dan. ");
INSERT INTO ndv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abraam ɗarsaꞌte ɓëewí i goomal-goomal, antee yejoh haaꞌa elgin. Ɗi happe buurri iniilla antee ñee talli wa, líkké wë níi Hoba fa hom énfí Damaas ra. ");
INSERT INTO ndv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Na nimil ri ra, Abraam kúrëelëhté alal ma ɓeyu ɓëewí ƴaa haaꞌa ra, ɗi kúrëelëhté Lot mboko mi a alal mi, ɓeleɓɓa a ɓëewë habuu haaꞌa ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Na nimil Abraam faam bee ɓagaꞌ ri Kedoor-Lawomeer a buurra húmú habruu ri ra, buuri Sodom acce téebílëhí húur mí Sawe fa na wonuu húur mí buurra ra. ");
INSERT INTO ndv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek buuri Salem, seeƴohi Koope fa sunaa-sun, kúɗté mbúurú a béeñ, ");
INSERT INTO ndv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","na ɗagiɗ Abraam won tih⁠ ⁠: «⁠ ⁠Koope fa sunaa-sun, ɗo fa sak sun a feey ra, barkele Abraam⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ma na sím rë Koope fa sunaa-sun tah níi Abraam ɓaŋke haaꞌoh yi ra⁠ ⁠!⁠ ⁠» Tígí daaha, iña ɓeyaꞌ Abraam haaꞌa ra ɓéeɓ woruun sabboo raa, wodi yínëe ɗi yeɗte ri Melkisedek. ");
INSERT INTO ndv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Wocuu Abraam a Melkisedek ra, buuri Sodom won Abraam tih⁠ ⁠: «⁠ ⁠Yeɗ soꞌ ɓëewë ndín, fu ham alal ma.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abraam won ɗi tih⁠ ⁠: «⁠ ⁠Mee ɓéyíɗ yaꞌ soꞌ ra ee, di tii Yahwee, Koope fa sunaa-sun, ɗi fa sak sun a feey ra. ");
INSERT INTO ndv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Mi añohte biti mii ɓeɓ yii daa fu lahaꞌ ri, níi lukaꞌ bee lukki ƴin ra, toñeh fay wone biti daa fu tah mi caak yin. ");
INSERT INTO ndv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mii ham yin soo na, henay ƴee liiluu ñam ɓëewí sëꞌ rë, a wodi ɓëewë habruu soꞌ ra⁠ ⁠: Aneer, Esekol a Mamre. Wa lahute waal na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Filoon fi baaha, di filiɓ yodaɗ, Koo-Yahwee won Abraam tih⁠ ⁠: «⁠ ⁠Ngana néekíñëꞌ yin Abraam⁠ ⁠! Daa mi níirëhú te waafu ay gaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Abraam tahte won tih⁠ ⁠: «⁠ ⁠A may pagee waaf yi kan Yahwee-Yíkëe te fu otte biti mi lahay koy⁠ ⁠? Íníh ee fu teeɓay soꞌ koy níi lamohi soꞌ ac Eliyeseer fi ɓëy Damaas, ow di súrgë yí sëꞌ ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tígí daaha Yahwee won Abraam tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ⁠ ⁠! Súrgúu nay roo lame neh, koy ka nay fuu límé rë daa nay hene lamohu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yahwee antee ɗúhíɗ Abraam ëssín, won ɗi tih⁠ ⁠: «⁠ ⁠Yeele sun fu olsoh hulla, hém fu mín wëe kín⁠ ⁠!⁠ ⁠» Ɗi ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗee teyu wa ra, séttú ay caakee ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abraam gémpé Yahwee, te ngémí baa daa tah Yahwee habaꞌte ri ɓëyí júɓpé. ");
INSERT INTO ndv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kéy fín fë, Yahwee won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi Yahwee fa këlíɗ ɗë Úur di Kalde ra, oni ro gina hom fu bee ra, fu lahaꞌ ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ndaa Abraam won ɗi tih⁠ ⁠: «⁠ ⁠May yúhée biti may rii lahaꞌ ɗíh, Yahwee-Yíkëe⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yahwee won ɗi tih⁠ ⁠: «⁠ ⁠Saame téngë fana, peꞌ ɓeleɓ a kuuy har, ƴi lahuu kíil éeyë, bëdú mbetle a hëtë, fu kom soꞌ wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abraam saamiɗte ri raɓɓi ƴaaha ɓéeɓ, happe wa⁠ ⁠; henay ƴakka, ɗi lecce raɓɓa tas ra ɓéeɓ leelaa, antee yef hatin fi hatin ɓéeɓ fíi moroomi, hanndalaꞌte wa. ");
INSERT INTO ndv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","I suul yeɗɗuute sun fi boꞌ fa, ndaa Abraam líkké wë. ");
INSERT INTO ndv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Na haal naꞌ ra, pëní fí misikke haalte Abraam. Ɗee a ɗeh, gina ñúussé túɗ afi, ɗi tíitté níi tíit. ");
INSERT INTO ndv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yahwee won ɗi tih⁠ ⁠: «⁠ ⁠Yúhé biti séttú ay dék gini henay bi wa⁠ ⁠; wa ay naa habu ñaam, wa moklu lool níi hen kíil tíméer iniil (400)⁠ ⁠; daa mi won ɗo ri ee. ");
INSERT INTO ndv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ndaa tíl níi mi keen sun fi gina nay waa ñaamlee ra raa, wa ay naa koloh, sayaꞌ a alal caak. ");
INSERT INTO ndv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Te ɗo fi beh, fay ɗeefree caaccu a jaamma, ɗeefa fu ɓaha níi fu paangaaw. ");
INSERT INTO ndv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Jamanu iniil fíi, séttú ay nimlaat deh⁠ ⁠; ndée ɓosi Amoorra lahay tígë nay mi waa líkée rë doom.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Haalaꞌ naꞌa níi Koo ñúussé túɗ rë, ɗee a ɗee rek anndii na ɗúuk a kocom ki na ñah ñeyute hanndal ki hatinni raɓɓa. ");
INSERT INTO ndv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Yahwee pokaꞌ yee pok ri a Abraam ra ɗaaha yiin fa, won ɗi tih⁠ ⁠: «⁠ ⁠Mi onte séttú gini beh, dalaꞌte laahi Ésíp níi lahte laahi gaana na wonuu Efarat ra⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","daa ri feey fi Kenna, Kéníssë, Katmonna, ");
INSERT INTO ndv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hetta, Péríssë, Refa ya, ");
INSERT INTO ndv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoorra, Girgassa, ɓëy Kanaan a ɓëy Yébús.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Abraam a Saaray homute Kanaan kíil sabboo yi ɓelaa lahray ri koy. Ndaa Saaray húmú lahte ñaami coosaanaꞌ Ésíp hínú Agaar. Saaray antee won ƴaali tih⁠ ⁠: «⁠ ⁠Fu otte biti Koo-Yahwee teeɓay soꞌ koy. Kon ɓeye ñaami soꞌ ɓeleɓ. Ɗi lah koy raa, mi hen yaafa book⁠ ⁠!⁠ ⁠» Abraam tahte yee won Saaray ra. Ɗaaha, Saaray ɓeɓpe ñaami, yeɗte ri Abraam ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abraam ñéerëꞌté a Agaar, ɗi pokke loo. Yúhëꞌ Agaar biti pokke loo ra, ɗi wonlilay yin Saaray na. ");
INSERT INTO ndv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tígí daaha, Saaray won Abraam tih⁠ ⁠: «⁠ ⁠Mi solute, te mi kelaay ro fu wonte yin doom. Daa mi yeɗ ɗo ñaami soꞌ ɓeleɓ fu ɓoppe ri⁠ ⁠; ndaa yúhëꞌ rí biti ɗi pokke loo níinén, ɗi tíklílëy sëꞌ ow. Gété⁠ ⁠! Yahwee ot yen na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abraam won Saaray tih⁠ ⁠: «⁠ ⁠Daa fu lahaꞌ ñaamu. Page ri yee neɓaꞌ ro ra.⁠ ⁠» Kolaꞌte baaha, Saaray mokil Agaar moklo níi Agaar hegohte saañce luufin. ");
INSERT INTO ndv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malaakii Yahwee ɗeef ri luufa, hëbís culi mulaa hom waali Súur rë, ");
INSERT INTO ndv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","meelte ri won tih⁠ ⁠: «⁠ ⁠Agaar ñaami Saaray, fu kolaꞌ di a fu saañ dih⁠ ⁠?⁠ ⁠» Ɗi tahte won tih⁠ ⁠: «⁠ ⁠Mi hegoh hegoo faam Saaray yíkíi sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malaakii Yahwee won ɗi tih⁠ ⁠: «⁠ ⁠Nimile faam yíkúu te lah ñeye woni. ");
INSERT INTO ndv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","May roo keñil níi ow ii mín kín ɓëy talu. ");
INSERT INTO ndv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Fu pokke loo te fay lahee koy ƴaal⁠ ⁠; lah dëekée rí Ismayel (daa ri⁠ ⁠: Koo keloh na), ndée homaꞌ fu súfúñ fú rë, Yahwee kelohte ro. ");
INSERT INTO ndv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Koohu ay made mbaam luuf nen wooñnjaꞌ. Ɗi ay tíkëꞌ af a ɓëewë ɓéeɓ, te ɓëewë ɓéeɓ ay rii haaꞌ. Di ay pesee a afi, ɗúh mboko yi na ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agaar won nufi tih⁠ ⁠: «⁠ ⁠Kaah biti mi ot Koope tígí deh, ɗi na ot soꞌ a⁠ ⁠?⁠ ⁠» Ɗi antee dëekëꞌ Yahwee fa won ɗii na ra El Roy (daa ri⁠ ⁠: Koope fa na ot soo na ra). ");
INSERT INTO ndv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Yii baa daa tah yéemë hom hanndal ki Kades a Beret ra na wonuu yéemí Lahaay Roy (daa ri⁠ ⁠: yéemë Koope fa na pes ɗa olaꞌ soꞌ na ra). ");
INSERT INTO ndv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Filoon fe, Agaar lahte koy ƴaal, Abraam boffa dëekëꞌté koy ka Ismayel. ");
INSERT INTO ndv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abraam húmú lahaꞌ kíil sabay peeye a kíil pëenë (86) na lahu ɓani Agaar koy ki baa ra. ");
INSERT INTO ndv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Lahaꞌ Abraam kíil sabay payniil a kíil payniil (99) ra, Koo-Yahwee feeñiyohte ri, won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi Koope fa mín ɓéeɓ rë. Ñéerée a soꞌ te fu lan pagaɗ. ");
INSERT INTO ndv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","May pok yin hanndal ki yen, te may ɓaat talu ɗi gaan níi gaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abraam yeɗɗohte, daappe púkí feey. Koope ɓaatte won ɗi tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«⁠ ⁠Yee nay mii poke hanndal ki yen ra daa ri beh⁠ ⁠: fay hen caac goomal i tal. ");
INSERT INTO ndv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Fii dëeklúu tii Abraam (daa ri⁠ ⁠: boffi gaana), fay hínú Abraham (daa ri⁠ ⁠: baap goomal), ndah biti may paŋ níi fu hen caac goomal i tal, ");
INSERT INTO ndv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","te may roo keñil, talu gaan níi gaan ɗi hen i gin caak, te ɗi ay ɗúhíɗ sah i buur. ");
INSERT INTO ndv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","May ham yee pok mi hanndal ki yen ra faraah, te filoon fu may ri ham hanndal ki funi ɓëy talu ɓal, jamanii ac ɓéeɓ níi kiri fi kirih. Af yee pok mi hanndal ki yen baa ra, may hen Koope fu, te filoon fu, may hen Koope fi ɓëy talu ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","May on ɗoni ɓëy talu gini Kanaan fa maangaanaꞌ fu bee ra. Ɗon nay rii lahee faraah, te daa may hene Koope fi ɓëy talu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Koope ɓaatte won Abraham tih⁠ ⁠: «⁠ ⁠Ɗo fi bee nék, lah habe yee pok mi hanndal ki yen ra, ɗoni ɓëy talu jamanii na ac fíi ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Yee pok mi hanndal ki funi ɓëy talu ra daa ri beh, te lah pëgí rí⁠ ⁠: ɓëyí hente ow ƴaal ɗon na ɓéeɓ waɗtee lecu. ");
INSERT INTO ndv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Lecoha nay ron lecee ra nay tíinndée yee pok mi hanndal ki yen ra. ");
INSERT INTO ndv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Jamanii ac fíi ɓéeɓ, koy ki hente ƴaal ɗon na ɓéeɓ waɗtee lecu yiin nay nimile bisa límú rí rë. Ñaamma límúu faamu ra a ƴee lom fu ra ɓéeɓ, wa nëníh talu ndaa wa warutee lecu ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ɗaaha, ñaama límúu faamu ra a bee lom fu ra ɓéeɓ, warutee lecu. Hen ɗaaha raa, lecoha nay ron lecee ra hen tíinndëꞌí yee pok mi hanndal ki yen ra níi kiri fi kirih. ");
INSERT INTO ndv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ndaa ƴaali lecuy ay ɗúhrú filiɓ fon, af biti ɗi habay yee pok mi hanndal ki yen ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Koope ɓaatilte won Abraham tih⁠ ⁠: «⁠ ⁠Dalaꞌte woteh, yii leŋke ɓeleɓu na, ngana dëekíl rí Saaray (daa ri⁠ ⁠: koy buur soo na), lah dëekée rí Saara (daa ri⁠ ⁠: koy buur). ");
INSERT INTO ndv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","May rii barkel níi ɗi límíɗ rë koy ƴaal, te ɗi fi Saara ay hen caac i tal⁠ ⁠; tali ay ɗúhíɗ i buur gin.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tígí daaha, Abraham ƴekaatte sígímíɗté rí níi púgë lahte feey, ɗi ƴente, na won nufi tih⁠ ⁠: «⁠ ⁠May mínée lah koy ɗíh, bee lahaꞌ mi kíil tíméer (100) bee ra⁠ ⁠? A Saara fa lahte kíil sabay payniil (90) ra míníl lah koy a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ɗi won Koope tígí daaha tih⁠ ⁠: «⁠ ⁠Ismayel pesa ndín, fu hel nuf ɗii na. Mi ɗagay yin kay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ndaa Koope won ɗi tih⁠ ⁠: «⁠ ⁠Ɗaa neh⁠ ⁠! Mi won ɗo ndek tee⁠ ⁠: ɓeleɓu Saara ay roo límíɗ koy ƴaal te lah dëekée rí Isaak (daa ri⁠ ⁠: ɗi ƴente). Yee pok mi hanndal ki yen ra, may rii ham hanndal ki funi Isaak, te filoon fi may rii ham hanndal ki funi ɓëy tali níi kiri fi kirih. ");
INSERT INTO ndv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ɓaatte biti mi kelohte ɗaŋee ke ro leŋ Ismayel na ra⁠ ⁠: may rii barkel ɓal, mi keñil ri, mi ɓaat tali gaan níi gaan. Ɗi ay lím koy sabboo a koy ana yi ay hen kélfë, mi paŋ níi ɗi hen ɓaha tal gaan. ");
INSERT INTO ndv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ndaa yee pok mi hanndal ki yen ra, may rii ham hanndal ki funi Isaak fa nay roo límɗé Saara wahtii bee kíirkí rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Wonaꞌ Koo Abraham na níi wocce ra, ɗi kolohte ɗii na daaha, nimilte sun. ");
INSERT INTO ndv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Yiin fin fa, Abraham lecce koohi Ismayel, ñaamma límúu faami ra a ƴee lom ri ra ɓéeɓ. Ɗaaha, ɗi lecce ɓëewí ƴaalla homu faami ra ɓéeɓ, ti ɗee nahaꞌ ri ri Koope ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham húmú lahaꞌ kíil sabay payniil a kíil payniil (99) na lecu ri ra⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","koohi Ismayel húmú lahaꞌ kíil sabboo a kíil éeyë. ");
INSERT INTO ndv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Abraham a koohi Ismayel a ɓëewí ƴaalla faami ɓéeɓ, ñaamma límúu faami a ƴee lomu ra ɓéeɓ, daa léctú bisa yínë. ");
INSERT INTO ndv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lahte bis, Koo-Yahwee feeñiyohte Abraham leelu naꞌ di kilikki gaanni Mamre, ɗeef Abraham tookke ílí taantii. ");
INSERT INTO ndv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ɓéyrëꞌ rí afi, ɗi otte ow éeyë fíyí. Ɗi yíppée koloh téebílëhté wë, sígímíɗté wë níi feey. ");
INSERT INTO ndv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ɗi won ow yínë waa na tih⁠ ⁠: «⁠ ⁠Ɓahaa, baal soꞌ rek ɗon ɗal faam⁠ ⁠; ngënë rëemmbíi múk⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ëní sëꞌ mi wolaꞌ muluɓ ɗon hos kotton ndín, ɗon hílsëh tal kilki beh. ");
INSERT INTO ndv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","May ron saamiɗ yii túmún ron loo yon, nda ron lah doole tílëe biti ɗon ɓeyaat waalon. Ñeyi ron faam soꞌ mínéh henaꞌ holoŋ ɗaaha.⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Eera⁠ ⁠! Page yee won fu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham yíppée haal taantii won Saara tih⁠ ⁠: «⁠ ⁠Yípée nat anndaar mún mí nooyte éeyë, fu íƴíɗ wë ndín, fu hút kuun.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraham yíppée múkë yubin, saampe yuuhi wunte faan, yeɗte ri ow di súrgë yí⁠ ⁠; súrgëe happe ri, yíppée yam teƴi. ");
INSERT INTO ndv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Wocaꞌ paŋa ra, Abraham ɓeɓpe miis mi woyte a miis jaw a boꞌ fa teƴɗoh ɗi ra, kompe haneelli. Wa na ñamu, ɗi hompe hëbís wë sëegú fí kilka na tooppitoh wa. ");
INSERT INTO ndv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Wocuu wa ñama ra, wa meelute Abraham wonu ri tih⁠ ⁠: «⁠ ⁠Ɓeleɓu Saara dih⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗi ee filiɓ taantaa ee.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ow yínë di haneella won ɗi tih⁠ ⁠: «⁠ ⁠May nimil faamu wahtii bee kíirkí, te ay ɗeef ɓeleɓu Saara lah koy ƴaal.⁠ ⁠» Saara húmú filoon Abraham ílí taanta, na síkírëh. ");
INSERT INTO ndv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ɗeef Abraham a Saara ɓahayute níi ɓaha, te Saara gétté lah koy, ");
INSERT INTO ndv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","tahte níi Saara ƴente keeñi na won nufi tih⁠ ⁠: «⁠ ⁠Bee ɓitifaꞌ mi bee ra, may lahil yii nebi baa a⁠ ⁠? Yíkíi faam soꞌ ɓahate ɓal ee⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tígí daaha, Yahwee won Abraham tih⁠ ⁠: «⁠ ⁠Haalaꞌ yi níi Saara na ƴen, na won nufi biti bee ɓitifaꞌ ri bee ra, nda ri míníl lah koy raa⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Lahte yii wooñ Yahwee woo⁠ ⁠? May nimil faamu wahtii bee kíirkí, te ay ɗeef Saara lah koy ƴaal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tíitëꞌ Saara ra, ɗi na taasaꞌ won tih⁠ ⁠: «⁠ ⁠Mi ƴenay⁠ ⁠!⁠ ⁠» Yahwee tahte won tih⁠ ⁠: «⁠ ⁠Fu ƴente kay⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ɓëewë anutee koloh, ɓeyute waala na séentúu Sodom. Abraham ñéerëꞌté a wa, na ɓen wa. ");
INSERT INTO ndv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Tígí daaha, Yahwee won nufi tih⁠ ⁠: «⁠ ⁠Mi fahaay ɗap Abraham yee nay mii page ra. ");
INSERT INTO ndv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ɗi ay hen ɓaha tali gaante te lahte doole. May ñeyee ɗii na, mi barkel heetta feey fa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mi tanisse ri nda ri mín nah koyyi a séttí paŋ iña túuƴëꞌ mí rë, wa lah pagaɗɗi wunte te ñeete waal. Hen ɗaaha raa, may rii pagiɗ yee gap mi ri ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yahwee won Abraham tígí daaha tih⁠ ⁠: «⁠ ⁠Iña yabu ɓëy Sodom a ɓëy Gomoor ra ɓosse, wa gaanute bakaaɗ. ");
INSERT INTO ndv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Caa mi cép kénsëhí iña yabu wa ra, nda lahaꞌ ɗaaha raa. Yii hom na raa may yúh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Filoon fi baaha, haneelli ana ya koluute daaha, ɓeyute waali Sodom, ndaa Koo-Yahwee tasse Abraham na. ");
INSERT INTO ndv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham leɓohte ri won tih⁠ ⁠: «⁠ ⁠Fay boollee ɓëewë júɓú rë a ƴee ɓosu ra ɓéeɓ fu múkíl wëe Yíkëe⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mín hena ɗaa níi lahte ɓëewí sabay iippi (50) júɓúté filiɓ Sodom⁠ ⁠; níi fay múkíl gina a⁠ ⁠? Fii rii baal af ɓëewí sabay iippa (50) júɓú në rë ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ɗaa neh, fii paŋ yii bah⁠ ⁠! Fii habaꞌ ɓëewë júɓú rë a ƴee ɓosu ra ɓéeɓ yínë, fu boollaꞌ fu hap wa ɓéeɓ húl. Ɗo fa na aattiyaꞌ feey fa ɓéeɓ rë, fay ñéyíɗ iña waal maan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yahwee tahte won tih⁠ ⁠: «⁠ ⁠Mi ɗeef ɓëewí sabay iippi (50) júɓúté Sodom raa, af wa ay tah may baal ɓëy gina ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham ɓeyaatte una won tih⁠ ⁠: «⁠ ⁠Añcaŋ bi kaañ mi won a ro ɓéeɓ Yíkëe, mi boꞌ faan kut. ");
INSERT INTO ndv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mín hena ɗaa di filiɓ ɓëewí sabay iippa (50), lah na iippi júɓúy. Af ɓëewí iippi ƴaaha ay tah fu múkíl gina a⁠ ⁠?⁠ ⁠» Koope tahte won tih⁠ ⁠: «⁠ ⁠Mi ɗeef na ow sabay iniil a ow iippi (45) júɓúté rëe, mii rii múkíl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham ɓeyilte una won tih⁠ ⁠: «⁠ ⁠Mín hena ɗah, lah ow sabay iniilli (40) júɓúté në.⁠ ⁠» Koope won ɗi tih⁠ ⁠: «⁠ ⁠Lah ɓëewí sabay iniilli (40) júɓúté në rëe, mii múkíl gina.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham won tígí daaha tih⁠ ⁠: «⁠ ⁠Ngana neeɓaꞌ soꞌ kan Yíkëe biti mi ɓaatti won. Mín hena ɗaa lah ow sabay éeyë (30) yí júɓúté në.⁠ ⁠» Koo tahte won tih⁠ ⁠: «⁠ ⁠Mi ɗeef na ɓëewí sabay éeyë (30) yí júɓúté rëe, mii paŋ yin.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham won ɗi tih⁠ ⁠: «⁠ ⁠Yíkëe baal soꞌ yee kaañ mi roo wonaat ra, ndée wa mín henun ow sabay ana (20) kut.⁠ ⁠» Koo tahte won tih⁠ ⁠: «⁠ ⁠Af ɓëewí sabay ana yi ƴaa ay tah mii múkíl gina.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham ɓaatilte won tih⁠ ⁠: «⁠ ⁠Mi na ɗaŋ ro Yíkëe, keeñu ɓanay naa haay. May míllée won beh⁠ ⁠: mín hena ɗah, lah ɓëewí sabboo yi júɓúté në.⁠ ⁠» Koo won ɗi tih⁠ ⁠: «⁠ ⁠Af ɓëewí sabboo yi ƴaa ay tah mii múkíl gina.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ɗúmëꞌ gonli wa ra, Yahwee takohte saañce, Abraham nimilte faam. ");
INSERT INTO ndv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Malaaka yi ana ya këllúu helute Koo-YahweeAbraham na ra, lahuu wa Sodom fíníin fín, ɗeef Lot húmú took këemí ɓaha ya gina. Olaꞌ ri wa, ɗi kolohte téebílëhí wë, ɗi ƴekke sígímíɗté wë níi feey. ");
INSERT INTO ndv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɓaha yi ƴeh, hém neɓaꞌ ron, ɗëlí faam ɗon hos kotti ron, ɗon neeꞌ na. Koo yíil rëe, ɗon ɓeyaat waalon.⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Miteh ri, fun ay mín neeꞌ këemí gina.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ndaa Lot cagohte wa níi wa míllúutée tah saañ faami. Ɗi pagiɗte wa ñam, nahaꞌte yugus kuun, wa ñamute. ");
INSERT INTO ndv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Wa liiluyti fanoh doom, ƴaalla gina ɓéeɓ⁠ ⁠: ɓaha a kúkëy, ow tasay na, ayute gírmbëlúté faam fa. ");
INSERT INTO ndv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wa dëekúté Lot, wonu ri tih⁠ ⁠: «⁠ ⁠Ɓëewë ayu faamu fíníin fé rë dih⁠ ⁠? Ɗúhré wë deh, fun fanoh a wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot ɗúhté waa na ëssë, kúnté ílí faam fa, ");
INSERT INTO ndv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","antee waa won tih⁠ ⁠: «⁠ ⁠Ɗaa neh, këewé⁠ ⁠! Ngënë pëgí yii man ɗah, daa mi na ɗaŋ ron ri. ");
INSERT INTO ndv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Cëgí mi won ɗon⁠ ⁠: mi lahte koy ɓeleɓ ana ƴi yíih ƴaal doom, cëe mi kom ron wa ɗon paŋ wa yii neɓaꞌ ron. Ndaa ngënë léɓí ɓëewí ƴee na, wa haneelli soꞌ, te yii kat wa dee soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ndaa wa wonu ri tih⁠ ⁠: «⁠ ⁠Kolee tígë ɗoo na⁠ ⁠! Fu haneel gini bee kut, fu antee habaꞌ biti wonu daa nay lahe a⁠ ⁠? Añcaŋ fay waa luk maloh ɓos⁠ ⁠!⁠ ⁠» Wa yejute Lot hatin a doole, yuluute ɗofi ílí faam fa. ");
INSERT INTO ndv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tígí daaha, malaaka yi ana ya kúnsúté ílë, habute Lot, nimlirute ri filiɓ faam fa, kúnúté ílë. ");
INSERT INTO ndv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Wa yejute yii happe íllí ɓëewë homu ëssë rë, ɓaha neh, kúkëy neh, níi wa yíihlíh tígí paaꞌ ílí faam fa. ");
INSERT INTO ndv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Malaaka yi ana ya wonu Lot tih⁠ ⁠: «⁠ ⁠Fu lahay i mboko kay dee woo⁠ ⁠? Koy ƴaal, koy ɓeleɓ, mbée goro, ɓëy tappe ɗoo na ɓéeɓ, ɗúhré rí gina. ");
INSERT INTO ndv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ndée iñi ɓossa yabu ɓëy gini bee ra lahte níi Koo-Yahwee na, tahte níi ɗi yeñce fun múklí gina, te fun ewu kotta.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tígí daaha, Lot payte goro yi na, fiilli koyyi ana yi, won wa tih⁠ ⁠: «⁠ ⁠Yípíi koloh dee ɗon saañ, ndée Yahwee caŋke múklí gina.⁠ ⁠» Ndaa wa habuu biti ri hom bëenndëꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Lahaꞌ miir-miira ra, malaaka ya caguute Lot, wonu ri tih⁠ ⁠: «⁠ ⁠Yípée koloh fu kúrëelëh ɓeleɓu a koyyi ana yu ɓeleɓ, toñeh Koope ƴahti keen sun fi gina raa, ñíinnën teem na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Bi na ñaamsaꞌ nuf Lot, malaaka yi ana ya habute yaꞌ yi ɓani ɓeleɓi a koyyi ana yi ɓeleɓ, ɗúhrúté wë gina, te yin katay wa, af biti Yahwee húmú fahaꞌte sëmlëꞌí wë. ");
INSERT INTO ndv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ɗúhrúu wë gina, ow di malaaka ya won Lot tih⁠ ⁠: «⁠ ⁠Hegee fu sëmlëꞌ afu⁠ ⁠; ngana heeltoh te ngana cagaaloh deyi bee ɓéeɓ. Tílé fu ɗapee daŋin hém fu fahaꞌ pes.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot tahte won ɗi tih⁠ ⁠: «⁠ ⁠Ɗaa neh, ɓahaa. ");
INSERT INTO ndv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mi yúhté biti fu pagiɗte soꞌ yin wun te fu naaꞌte keeñ soo na níi naaꞌ níi mi pesse. Ndaa mi mínéh koloh dee níi daŋin, te loola haweh soꞌ húl. ");
INSERT INTO ndv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Fu otte gin-taahi ƴutuudi bín ɗee leɓaꞌ ri raa⁠ ⁠? May mín múkë níi mi lah na. Ƴinaꞌ ri níi, yeɗɗe mi ɗapee na, nda mi pes.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malaakaa won ɗi tih⁠ ⁠: «⁠ ⁠Kon mi onilte ro níi mii leɓ gina wonaꞌ fu baa ra. ");
INSERT INTO ndv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Yípíi múkë ɗon ɗapee dín fë, ndée mi mínéh paŋ yin te ɗon lëhíh në.⁠ ⁠» Yii baa daa tah gini baa wonuu Sowaar (daa ri⁠ ⁠: yin ƴutuuɗ). ");
INSERT INTO ndv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Púlí naꞌ ɗeef Lot na haal Sowaar. ");
INSERT INTO ndv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tígí daaha, Yahwee lasse bacal laꞌ yi njaaroh kíi, ƴi ɗúhëꞌ sun-Koo, na toɓ sun fi Sodom a Gomoor. ");
INSERT INTO ndv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ɗi muuyilte ginni ana yi ƴaa a ɓëewë filiɓ, deyi baa a yii paal na ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ndaa bi húmú heeltoh ɓeleɓ Lot, ɗi yíssëhté deeƴ miraa. ");
INSERT INTO ndv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ɓaabin cúɓ, Abraham saañce tígë húmú cagu ɓani Yahwee ra. ");
INSERT INTO ndv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ɓéyrëꞌ rí afi ɗi yeelte waal Sodom a Gomoor a deyi baa ɓéeɓ rë, ɗi ot ɗúukëe súul síis ti ɗúukëe paloɓ nen ɗofohte feey fa. ");
INSERT INTO ndv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Na tam Koope ginna húmú dék Lot deyi baa ra, ɗi húmú halay Abraham, tahte níi ɗi sëmlëꞌté Lot loola muuylaꞌ ri ginni ƴaaha ra. ");
INSERT INTO ndv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Filoon fe, Lot néekíñëꞌté hom Sowaar, tahte níi ɓani koyyi ana yi ɓeleɓ koluute daaha, laayute daŋin, dékúté filiɓ kil. ");
INSERT INTO ndv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lahte bis, koy ki gaana won ñéedë tih⁠ ⁠: «⁠ ⁠Baap hompe ɓaha a deyi bee lahay ƴaali nay yen koore, ti ɗee henaꞌ ri ɓaah ɓëewë në ɓéeɓ rë. ");
INSERT INTO ndv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aye yen hëníɗ baap béeñ níi ri mani, yen fanoh a ri nda ri mín lah tal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Elgi baaha, wa hënndúté boffa béeñ níi ri manite, koy ki gaana fanohte a ri. Ndaa fanohi a kolohi ɓéeɓ, boffa yégëy yin na. ");
INSERT INTO ndv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kéy fín fë, koy ki gaana won ñéedë tih⁠ ⁠: «⁠ ⁠Ole⁠ ⁠! Mi fanohte a baap níimmbë. Teem elgee raa, yen hënndíl rí béeñ níi ri mani, fu pay fu fanoh a ɗi. Hen ɗaaha raa, tali baap ii múk.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Lahaꞌ elga ra, wa hënndëetúté boffa béeñ níi ri maniyilte, ñéedë fanohte a ri. Ndaa fanohi a kolohi ɓéeɓ, boffa yégëy yin na. ");
INSERT INTO ndv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Koyyi ana yi Lot koluu daaha pokute loo. ");
INSERT INTO ndv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mitaꞌ loo koy ki ɓahaa ra, ɗi lahte koy ƴaal, dëekëꞌté rí Mohap (daa ri⁠ ⁠: ɗúhëꞌ boffa na). Mohaɓɓa coosaanuu ɓëyí baa na. ");
INSERT INTO ndv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ñéedë ɓal lahaꞌ koy ƴaal, dëekëꞌté rí Ben-Ami (daa ri⁠ ⁠: koy mboko mi soꞌ). Amonna coosaanuu ɓëyí baa na. ");
INSERT INTO ndv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Hompe níi, Abraham kolohte saañce deyi Negep, ɗi yíppé taanta yi hanndal ki Kades a Súur. Ɗi kolaꞌ daaha, saañce hompe Geraar. ");
INSERT INTO ndv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham húmú wone ow yii leŋke ɓeleɓi Saara na raa, hom wonaꞌ ti yaa ñéedí, tahte níi Abimelek buuri Geraar, ɓeɓpe Saara ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ndaa elgin, Koope feeñiyohte Abimelek di filiɓ yodaɗ, won ɗi tih⁠ ⁠: «⁠ ⁠Ɓeya ɓeɓ fu Saara ɓeleɓ ra tahte níi ñíinú aa yaꞌu, ndée ɗi ɓeleɓ kooru.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek fa liilayti lah ɓelaa na koon ra, won Koope tih⁠ ⁠: «⁠ ⁠Yíkëe, níi fay hap funi ɓëewí sëꞌ húl, te fun paguy yin a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ɗi fi Abraham daa won soꞌ biti ɓelaa ñéedí, te ɓelaa wonte biti ɓal Abraham ɓahii. Mi pagaay ri ɓos nuf, ndée mi yéeh yin na koon.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Filiɓ yodada, Koope tahte won ɗi tih⁠ ⁠: «⁠ ⁠Soꞌ ɓal, mi yúhté biti fu pagaay ri ɓos nuf, daa tah mi paŋ níi fu lahay ɓelaa na toñeh fay bakaare. ");
INSERT INTO ndv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kon nimilire ɓelaa ƴaali, ndée ƴaala yonente te ri ay roo ɗagiɗ níi fu pes. Ndaa fu nimliray ri raa, lah yúhé biti ɗoni ɓëewú ɓéeɓ ay húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yíilëꞌ Koo ɓaabin cúɓ, Abimelek dëekké súrgë yí ɓéeɓ, ɓílíɗté wë yee lah ra⁠ ⁠; wa tíitúté níi tíit. ");
INSERT INTO ndv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek antee dëek Abraham, won ɗi tih⁠ ⁠: «⁠ ⁠Fu pagaꞌ fun yii baa ɗi ɓal⁠ ⁠? Mi paŋ ro yi níi fu na ɓek funi ɓëy gin soꞌ bakaadi man ɗaa gaan⁠ ⁠? Fu paŋke soꞌ yii na pëgíh⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Yi daa ɓek ro paŋi yii bah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham tahte won tih⁠ ⁠: «⁠ ⁠Mi habaꞌ biti koon ɓëy gini bee neehuy Koope, te af ɓeleɓ soꞌ ay tah koon wa hap soꞌ húl. ");
INSERT INTO ndv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Mi ɓeɓpe ri ɓeleɓ, ndaa ɗi ñéedí sëꞌ kaah, ndée funi boku baap, ndaa funi bokuy yaay. ");
INSERT INTO ndv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Te këllëꞌ sëꞌ Koope faam baasoꞌ, kúɗté sëꞌ mi na maangaan luufa ra, mi húmú ɗaŋke ɓeleɓ soꞌ teeɓ soꞌ naaꞌ-keeñ biti tígí pay fun ɓéeɓ, lah ri wona ti mi ɓahii.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abraham na woc wona, Abimelek yíppée ɓeɓ i har, peꞌ, fana, i ñaam ƴaal a ɓeleɓ, yeɗte Abraham yoobbol, nimiliɗte ri ɓeleɓi Saara. ");
INSERT INTO ndv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek won Abraham daaha tih⁠ ⁠: «⁠ ⁠Gina abee hëréet⁠ ⁠; fu mín yíp faamu tígí neɓaꞌ ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ɗi yíssëhté Saara na, won ɗi tih⁠ ⁠: «⁠ ⁠Ole, mee yeɗ ɓahuu hélíis caak ra ee. Daa wa nay teeɓe ɓëewë ɗoni wa dékú rë ɓéeɓ biti fu lante yii beh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ɓeya húmú ɓeɓ Abimelek Saara ɓeleɓ Abraham ra, tahte níi Koo-Yahwee leewte loo yi ɓeleɓɓa faam Abimelek ɓéeɓ. Ndaa ɗagaꞌ Abraham Koope ra, Koo baalte Abimelek, ɓeleɓi a súrgë yí ɓeleɓ níi wa mínëetúté lah koy. ");
INSERT INTO ndv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Nuf Koo-Yahwee payte yee húmú won ɗi Saara ra, ɗi pagiɗte ri yee húmú gap ri ri ra. ");
INSERT INTO ndv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saara pokke loo. Lahaꞌ wahtaa húmú wonaꞌ ri Koope ra, ɗi límíɗté Abraham koy ƴaal ɗeef Abraham ɓahate. ");
INSERT INTO ndv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham yeɗte koy ki ƴaala límíɗ rí Saara ra tii Isaak (daa ri⁠ ⁠: ɗi ƴente). ");
INSERT INTO ndv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Lahaꞌ Isaak waal peeye ra, Abraham lecce ri ti ɗee húmú nahaꞌ ri Koope ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Límí Isaak ɗeef Abraham lahaꞌ kíil tíméer (100). ");
INSERT INTO ndv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saara won tígí daaha tih⁠ ⁠: «⁠ ⁠Koope onte soꞌ ƴenaa. Ɓëyí keloh yii bee ɓéeɓ ay soo ƴenɗaꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ɗi ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɓëyí won Abraham biti ay tíl níi Saara ɓëpíɗ koy koon⁠ ⁠! Añcaŋ bi ɓaha ri níi, mi límíɗté rí koy ƴaal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mëysëꞌ kúkëyë rë, Saara wëcíɗté rí ɓap. Yiin nísú rí ɓíiɓ rë, Abraham cëgíɗté gimaak gaan. ");
INSERT INTO ndv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lahte bis, Saara otte Ismayel koy ki ƴaala límíɗ Agaar fi ɓëy Ésíp Abraham ra na hégílëꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ɗi won Abraham tih⁠ ⁠: «⁠ ⁠Líké ñaami bee a koohi. Koy ka ii bok lam a koy soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Bi hen Ismayel koy Abraham ɓal, woni baa misikke ri níi tígí teem misik. ");
INSERT INTO ndv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ndaa Koope won ɗi tih⁠ ⁠: «⁠ ⁠Yin ɓanay roo misik di yii leŋke ñaamu a koohi na. Lah tahe yii won ɗo Saara ɓéeɓ, ndée tala gap mi ro ra ay ɗúhée Isaak na. ");
INSERT INTO ndv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ndaa bi hen koy ñaamu koohu, may paŋ níi ɗi hen ɓaha tal gaan ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kéy ɓaaɓ fin cúɓ, Abraham ɓeɓpe mbúurú a gúm muluɓ, yeɗte Agaar gecohte⁠ ⁠; ɗi yeɗte ri kúkëyë ɓal, antee wa ɗúhíɗ faam fa. Agaar saañce na mbal luufi Beer-Sebaa. ");
INSERT INTO ndv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ɗúmëꞌ mulaa gúmë rë, Agaar ɓeɓpe kúkëyë helte ri sëegú tal kilik, ");
INSERT INTO ndv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","antee saañ níi hanndal ki wa mitte yii teemmaꞌ yees kas, ɗi tookke, ndah ɗi won nufi tih⁠ ⁠: «⁠ ⁠Mi fahaay ot koy soꞌ húlé fíi sëꞌ⁠ ⁠!⁠ ⁠» Ɗi antee hom daaha, ɓéyíɗté uni na foŋ. ");
INSERT INTO ndv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kúkëyë na looy ɓal, Koope kelohte una. Malaakii Koope hom sun, dëekké Agaar won ɗi tih⁠ ⁠: «⁠ ⁠Fu lahaꞌ yi Agaar⁠ ⁠? Ngana néekíñëꞌ⁠ ⁠! Koo kelohte un kúkëyë tígë helaꞌ fu ri ra. ");
INSERT INTO ndv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kolee fu ɓeɓ ri te fu ham yaꞌa híin, ndée may paŋ níi ɗi hen ɓaha tal gaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Koo kúníssé af Agaar, ɗi yíppée séen yéem⁠ ⁠; ɗi payte nehte gúmí níi líiffé, yeɗte kúkëyë hante. ");
INSERT INTO ndv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Bi ñéerëꞌ Koo a kúkëyë, ɗi koraꞌ luufa na ooɗ níi hente ɓëy mínté ɓoorsoh a kas. ");
INSERT INTO ndv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ɗi húmú dék luufi Paran, te yaafa ɗagiɗte ri ɓeleɓ ɓëy Ésíp në. ");
INSERT INTO ndv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lahte bis, Abimelek a Pikol daga kúɗ wohoh yi ra, payute Abraham na, wonu ri tih⁠ ⁠: «⁠ ⁠Fun yúhúté biti yii cëgíɗ fu ɓéeɓ Koo ñéerëꞌ në. ");
INSERT INTO ndv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kon añee ri dee woteh di tii Koope, biti fii nofaꞌ funi koyyi soꞌ a ɓëy tali soꞌ. Di húmú naaꞌaꞌ mi keeñ ɗoo na, lah habee funi ɓëy gina hom fu bee ra ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham won ɗi tih⁠ ⁠: «⁠ ⁠Mi añohte biti may rii pagee ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Añcaŋ Abraham wonte af Abimelek di yii leŋke yéemë húmú naafu súrgë yí Abimelek ra. ");
INSERT INTO ndv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek won ɗi tih⁠ ⁠: «⁠ ⁠Mi yéeh ɓëeꞌ waɗti paga yii baa ra. Te ɗo fi bee sah fu wënɗëy sëꞌ yin na, níi mi an ɗii keloh ɗeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Filoon fi gonli wa, Abraham ɓeɓpe i har, i peꞌ a i fana yeɗte wa Abimelek, wa ɓéeɓ ana añuute, pokantuute kooƴ. ");
INSERT INTO ndv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham antee ɓeɓ téngë har paana, ɓíssé wë. ");
INSERT INTO ndv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek meelte ri won tih⁠ ⁠: «⁠ ⁠Harri paana ya ɓís fú ƴee ra ay paguu yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham won ɗi tih⁠ ⁠: «⁠ ⁠Tahe harri paana yi ƴeh, yii baa nay teeɓee biti daa mi hacroh yéemë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tii Beer-Sebaa fa na wonuu tígí daaha ra haalaꞌ yii bah⁠ ⁠; biti wa ɓéeɓ ana añuute daaha. ");
INSERT INTO ndv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ɗaaha wa pokantuute ri kooƴ Beer-Sebaa. Abimelek a Pikol daga kúɗ wohoh yi ra anutee nimil gini Fílístí. ");
INSERT INTO ndv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham yíppé tal kilka na wonuu tamaris ra Beer-Sebaa daaha, ɗaŋke Koope fa mínéh ɗúm rë në, ñeyaꞌte ri tiyi, dëekëꞌté rí Yahwee. ");
INSERT INTO ndv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham hompe gini Fílístí yii maañce. ");
INSERT INTO ndv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Gétëꞌ iñƴaa ɓéeɓ rë, lahte bis, Koo hom olsohi Abraham, won ɗi tih⁠ ⁠: «⁠ ⁠Abraham⁠ ⁠!⁠ ⁠» Abraham tiilte won tih⁠ ⁠: «⁠ ⁠Yëew⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Koo tahte won tih⁠ ⁠: «⁠ ⁠Kolee fu ɓeɓ koy ka lahaꞌ fu yínë kut ra, Isaak fa fahaꞌ fu keeñu ra, fu saañ Moriya. Fu lah na raa, fu hawiɗ soꞌ ri sarahi ay tamu tamo níi sooy sun fi daŋa nay mi roo teeɓe ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kéy ɓaaɓ fin cúɓ, Abraham kolohte, ɓesse kilikka na saañ sarahin ra, séffé wë mbaam fi, ɓeɓpe waala yuliɗ tígë húmú túuƴ rí Koope ra⁠ ⁠; ɗi kúrëelëhté koohi Isaak a súrgë ana di súrgë yí. ");
INSERT INTO ndv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tílúu wë níi waali éeyë fë rë, Abraham ɓéyíɗté afi, séenté tígë në suu wa ra. ");
INSERT INTO ndv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ɗi won súrgë yí tígí daaha tih⁠ ⁠: «⁠ ⁠Hëmí ɗoni mbaam fa deh, funi koy soꞌ pay jaamiyoh Koope na ndín, fun nimil ɗon na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham ente koohi Isaak kilikka na saañ sarahin ra⁠ ⁠; ɗi fi bah, ɗi ɓeɓpe kíi kë a gaada, wa ñéerúuté na suu. ");
INSERT INTO ndv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Homuu wa waala ra, Isaak won boffi tih⁠ ⁠: «⁠ ⁠A baap⁠ ⁠!⁠ ⁠» Abraham tahte won tih⁠ ⁠: «⁠ ⁠Ɗi yi koy soꞌ⁠ ⁠?⁠ ⁠» Isaak won ɗi tih⁠ ⁠: «⁠ ⁠Yen kúrúté kíi a kilik, ndaa yee nay hawu ra dih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham tahte won tih⁠ ⁠: «⁠ ⁠Koo ot na, ɗi nay onee yee nay hawu ra.⁠ ⁠» Wa ñéerúuté na suu. ");
INSERT INTO ndv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Lahuu wa tígë húmú wonaꞌ wa Koope ra, Abraham tíkëlsëꞌté i laꞌ daaha, yíppé ílíƴ hawraa, lígínëꞌté kilikka sun, antee pokalsaꞌ koohi Isaak, tíkké rí sun fi kilikki hawraa. ");
INSERT INTO ndv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham yeɗte yaꞌi, ɓeɓpe gaada, saañ ooli koohi koon, ");
INSERT INTO ndv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ndaa malaakii Koo-Yahwee hom sun gokke ri won tih⁠ ⁠: «⁠ ⁠Bëyít⁠ ⁠! Abraham⁠ ⁠!⁠ ⁠» Ɗi tahte won tih⁠ ⁠: «⁠ ⁠Yëew⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malaakaa won ɗi tih⁠ ⁠: «⁠ ⁠Yaꞌu ɓanay lah sun fi kúkëyë, ngana paŋ ri yin misik⁠ ⁠! Hém daa fu kaaꞌray ri koy ki yínëe lahaꞌ fu kut raa, mi yúhté wote biti fu neehte Koo.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ɓéyrëꞌ Abraham afi, ɗi ot kuuy har, wicca loŋke dúuf. Ɗi payte kalite har fa, happe ri, tamiɗte ri Yahwee tígí koohi sun fi hawraa níi sooyte. ");
INSERT INTO ndv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham yeɗte tígí daaha tii⁠ ⁠: «⁠ ⁠Yahwee ay onaꞌ⁠ ⁠». Te níi a woteh, tígí daaha wonuu⁠ ⁠: «⁠ ⁠Sun fi daŋi Yahwee, Koo nay onee.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malaakii Yahwee hom sun, dëekëetté Abraham ");
INSERT INTO ndv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","won ɗi tih⁠ ⁠: «⁠ ⁠Yahwee daa wonaꞌ ro ɗeh⁠ ⁠: “Hém daa fu kaaꞌray soꞌ koy ka lím fu yínë kut raa, soꞌ mi Koope mee rii añoh ra ee di tii soꞌ, ");
INSERT INTO ndv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","may roo barkel níi tígí teem barkel, mi keñil talu níi keñil, séttú caak níi ti hulla sun nen mbée ti peppi feey fa ɓúk kísí fë nen. Te séttú ay ílíf ɓëewë nay waa haaꞌee ra. ");
INSERT INTO ndv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ñeya ñee fu woni soꞌ ra, ay tah níi may ñeyee séttú në mi barkel ɓëy feey fa ɓéeɓ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham a koohi koluute, nimilute súrgë yí në⁠ ⁠; wa ɓéeɓ ñéerúuté ɓeyute waali faam, wëegísúté Beer-Sebaa homute na. ");
INSERT INTO ndv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Gétëꞌ iñƴaa ra, Abraham kelohte biti Milka ɓal límíɗté Nahoor koy-boffi Abraham, i koy ƴaal. ");
INSERT INTO ndv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Saawa hínú Úus, Búus daa ñéedí, ñeete Kemuwel boffi Aram, ");
INSERT INTO ndv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","tíkké Keset, Haso, Pildas, Yitlaf, a Betuwel. ");
INSERT INTO ndv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel daa boffi Rebekaa. Ƴaa daa koyyi ƴaalli peeye ya límíɗ Milka Nahoor koy-boffi Abraham ra. ");
INSERT INTO ndv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahoor húmú lahte ɓeleɓ kay bi hínú Rewma. Ɗi lahte i koy ɓal ƴi hínú⁠ ⁠: Tebah, Gaham, Tahas a Maaka. ");
INSERT INTO ndv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saara pesse kíil tíméer a kíil sabay ana a kíil paana (127). ");
INSERT INTO ndv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ɗi húlëꞌ Kiriyat-Arba (daa ri Heboron fee woteh) di gini Kanaan. Abraham kolohte luuyri ɓeleɓi, looyte ri. ");
INSERT INTO ndv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ɗi antee koloh tígë hom ɓúudé fí ɓelaa ra, saañce goneel a séttí Het. ");
INSERT INTO ndv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Lahaꞌ ri ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Mee gina, ndaa mi doha-ndéem kut filiɓ fon. Mi ɗaŋ ron biti ɗon saamiɗ soꞌ tígí nay mii ɗapee ɓúudé fí ɓeleɓ soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Séttí Het wonu ri tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«⁠ ⁠Síkírëh fun hém neɓaꞌ ro⁠ ⁠! Fun habuu ro kélfíi Koo barkelte ri filiɓ fi fun. Ɗapee ɓúudé fí ɓeleɓu tígí luk roo etaꞌ di hacaa yi fun. Ow di fun na ii roo kaaꞌiɗ fu ɗap ɓúudé fí ɓeleɓu hacaa yi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham kolohte, sígímíɗté ɓëy gina, séttée ké Het dékú në rë, ");
INSERT INTO ndv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","antee waa won tih⁠ ⁠: «⁠ ⁠Ɗon tah kaah biti mi hacaꞌ ɓeleɓ soꞌ dee raa, hëbríi sëꞌ Eforon koy Sohar na, ");
INSERT INTO ndv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nda ri yeɗɗaꞌ soꞌ kila hom af meeya lahaꞌ ri Makpelaa ra. Na ri yeraꞌ soꞌ ri a ɗee mín ɗíi calaꞌ ra ɓéeɓ di fíiyën, nda mi mín ríi lahaꞌ hacaa faraah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Bi húmú ɗi fi Eforon ɓaha yi Hetta na daaha, ɗi ɓeɓpe una, loffe Abraham fíi ɓëy këemë ɓéeɓ ");
INSERT INTO ndv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","won ɗi tih⁠ ⁠: «⁠ ⁠Síkírëh sëꞌ ɓahaa, hém neɓaꞌ ro⁠ ⁠! Meeya a kila hom na ra ii yaayu, mi onte ro wa⁠ ⁠; mi onte ro wa fíi ɓëy gina ɓéeɓ, fu mín nëe hacaꞌ ɓeleɓu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham ɓaatte sígímíɗté ɓëy gina, ");
INSERT INTO ndv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","antee won Eforon fíi ɓëewë këemë ɓéeɓ tih⁠ ⁠: «⁠ ⁠Síkírée mi won ro, hém neɓaꞌ ro⁠ ⁠! Tahe mi yeɗ ro cadum fi meeya, mi hacaꞌ na ɓeleɓ soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eforon tahte won ɗi tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«⁠ ⁠Ɓahaa, síkírëh sëꞌ mi won ɗo⁠ ⁠: feey fi calaꞌ sekel tíméer iniil (400) taaɓeh yin hanndal ki yen. Paye fu hac ɓeleɓu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham a Eforon kéldúuté, Abraham kínté cadum fa wonantuu wa ra fíi ɓëewë níi hente sekel tíméer iniil (400) di hélsë na yiikuu ɓëy gina ra. ");
INSERT INTO ndv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ɗaaha, meeyee ke Eforon Makpelaa, bee fíi Mamre, kila a kilikka filiɓ meeya ɓéeɓ, ");
INSERT INTO ndv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abraham lahaꞌte wa. Hetta húmú këemë rë ɓéeɓ ɗeefuute. ");
INSERT INTO ndv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Filoon fi baaha, Abraham payte hacce ɓeleɓi Saara filiɓ kila hom meeya Makpelaa, jaanndaꞌ Mamre ra (daa ri Heboron fee woteh) di gini Kanaan, looyte luuyi. ");
INSERT INTO ndv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Abraham lahaꞌ meeya a kila filiɓ ɗaaha yaꞌ yi Hetta. Ɗi saam meeya hacaa. ");
INSERT INTO ndv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham húmú ɓahate níi paangaawte. Yii húmú cëgíɗ rí ɓéeɓ, Koo-Yahwee barkel ri. ");
INSERT INTO ndv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Lahte bis, ɗi dëekrëhté súrgëe lukki maañ ɗii na ra, bee kúɗ yii leŋke iña faam fa ɓéeɓ rë, won ɗi tih⁠ ⁠: «⁠ ⁠Aye mi wol ro saamɗi koy soꞌ Isaak ɓeleɓ. Ndaa mi fahaay biti fu saamɗaa ri ɓeleɓ di ɓëy Kanaan fa hom mi bee ra. Kon ɓeke yaꞌu fëgërëh fí ɓaŋ soꞌ hém neɓaꞌ ro, fu añoh ri Yahwee na, Koope fa sak sun a feey ra biti fii ri saamɗaꞌ ɓeleɓ di ɓëy Kanaan na. ");
INSERT INTO ndv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Fay rii saamɗee ɓeleɓ mboko yi soꞌ na di gina coosaanaꞌ mi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Súrgëe tahte won ɗi tih⁠ ⁠: «⁠ ⁠Mín lah ɓelaa kaaꞌ ñéerëꞌ a soꞌ gini beh⁠ ⁠; ƴaha ɗaaha raa, may ɓeye koohu mi kúɗ ɗí gina kolaꞌ fu ra mbée yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ndaa Abraham won ɗi tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ⁠ ⁠! Ii na dal⁠ ⁠! Ngana kúɗ koy soꞌ dín fë. ");
INSERT INTO ndv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahwee Koope fa sun, daa këlíɗ sëꞌ faam baasoꞌ a gina coosaanaꞌ mi ra. Ɗi feeñiyohte soꞌ te añohte biti ɗi ay one séttí sëꞌ gini beh. Daa ri nay këllíré malaakii fíyú, paŋ níi fu tílíɗ koy soꞌ ɓelii dín fë, fu kom ɗi ri. ");
INSERT INTO ndv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ɓelaa kaaꞌ ñéerëꞌ a ɗo raa, ɗeef fu paŋke yee waɗ ra, yin tíkëey sun fu⁠ ⁠; ndaa di mín ríi man ɓéeɓ, ngana kúɗ koy soꞌ dín fë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Súrgëe ɓekke yaꞌi fëgërëh fí ɓaŋ Abraham kélfíi, añohte paŋi yee nahu ri ra. ");
INSERT INTO ndv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Filoon fi baaha, súrgëe ɓeɓpe géléem sabboo di yubi kélfíi, kúrëelëhté iña lukki wun alal mi Abraham ra, ɓeɓpe waali Mesopotami gina dék Nahoor ra. ");
INSERT INTO ndv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Tílëꞌ rí níi ɗi lahte yéemë hom balaa fu haal gina ra, ɗi ɓëefíɗté géléemmë⁠ ⁠; teyaꞌ a wahtaa na ayu ɓeleɓɓa neh sosaɗ naꞌin ra. ");
INSERT INTO ndv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ɗi na anti ɗaŋ won tih⁠ ⁠: «⁠ ⁠Yahwee, Koope fa na jaamiyoh kélfíi sëꞌ Abraham ra, teeɓe kélfíi sëꞌ biti fu naaꞌte keeñ ɗii na, fu habraꞌ soꞌ níi mi maloh waali soꞌ woteh. ");
INSERT INTO ndv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Mee ɓúk yéemë ee, te ɓeleɓɓa gina ee ayu neh ra. ");
INSERT INTO ndv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Cafaƴ ka nay mi ɗage muluɓ han ra, tah oni soꞌ muluɓ a hënndí géléemmí sëꞌ ɓal raa, may yúh biti daa ri bee tansiɗ fu súrgúu Isaak ra. Ɗaaha raa, may yúh biti fu teeɓpe kélfíi sëꞌ Abraham biti fu naaꞌte keeñ ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Na liil súrgëe woc ɗaŋa ra, ɗi otte Rebekaa koy Betuwel na ac a peni. Betuwel koy Milka a Nahoor. Nahoor ñéedí Abraham. ");
INSERT INTO ndv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Cafaƴ ka ɗampe ɓeleɓ te ri yéeh ƴaal. Ɗi lahte yéemë nehte peni, enohte na saañ. ");
INSERT INTO ndv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Súrgíi Abraham yíppée ríi leɓoh, won ɗi tih⁠ ⁠: «⁠ ⁠On soꞌ muluɓ mi han, hém neɓaꞌ ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Cafaƴ ka yíppée kélsëh, yeɗte súrgëe, won ɗi tih⁠ ⁠: «⁠ ⁠Habe fu han ɓahaa⁠ ⁠!⁠ ⁠» Ɗi ɓeɓpe hante. ");
INSERT INTO ndv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","20","Wocaꞌ ri hana ra, cafaƴ ka ɓaatte won tih⁠ ⁠: «⁠ ⁠Caa mi neh mi hëndíɗ géléemmú ɓal.⁠ ⁠» Ɗi yíppée yíin mulaa pena mbalkaa, wëegíssé yéemín na neh na nehaat níi géléemmë ɓéeɓ maniyute. ");
INSERT INTO ndv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Súrgëe hente tiɗ na olsoh ri, na won nufi nda Yahwee cëgíɗté yee tah ri koloh ra. ");
INSERT INTO ndv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Hanuu géléemmë níi wocute ra, súrgëe yeɗte cafaƴ ka yoobboli mitte⁠ ⁠: supi úrís, bi teemmaꞌ hatin sekel yínë, a kéñík úrís ana ƴi bina-bina ɓéeɓ mitte sekel sabboo. ");
INSERT INTO ndv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ɗi antee ri meel won tih⁠ ⁠: «⁠ ⁠Fu koy wa kúkëy cafaƴ⁠ ⁠? Faamon lahte tígí funi ɓëewë ñéyrúu rë mínú nëe neeꞌ elgee woteh a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Cafaƴ ka won ɗi tih⁠ ⁠: «⁠ ⁠Mi koy Betuwel, mi sédí Milka a Nahoor. ");
INSERT INTO ndv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Faam fun lahte tígí ɗon ay naa mín neeꞌ, a tígí ɗam géléemmë, te fun caakute booɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Súrgëe sígímpé níi feey, gérémpé Yahwee ");
INSERT INTO ndv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","na won tih⁠ ⁠: «⁠ ⁠Ma na sím ɗë Yahwee, Koope fa na jaamiyoh kélfíi sëꞌ Abraham ra. Fu teeɓpe ri biti fu naaꞌte keeñ ɗii na kaah te fu yeɗɗay ri⁠ ⁠: fu ɓente soꞌ waali soꞌ níi mi haalte faam mboko yi kélfíi sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tígí daaha, cafaƴ ka yíppée múkë yaafi na faam, ɓílíɗté yee lah ra. ");
INSERT INTO ndv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebekaa húmú lahte ɓaha ƴaal bi hínú Laban. Olaꞌ Laban supaa a kéñíkkë ñéedí në, te ɗeef ri kelohte ɓíllí Rebekaa yee won ɗi ɓëeꞌ rë, ɗi yíppée saañ ɗeefiɗte ɓëeꞌ a géléemmí hëbís yéemë. ");
INSERT INTO ndv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban won ɓëeꞌ tih⁠ ⁠: «⁠ ⁠Lahe faam, ɗo fa Yahwee barkel ro ra. Haalaꞌ yi níi fu na hom fëel te mi yugusse tígí nay ron home faam a tígí nay home géléemmë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Súrgíi Abraham yeeltee ac faam Laban. Géléemmë kélsúté, túmɗúté booɓ. Súrgëe a ɓëewí onute muluɓ hosaa kot. ");
INSERT INTO ndv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Súrgëe komute ñam ndaa ɗi won tih⁠ ⁠: «⁠ ⁠Mi mínéh ñam te mi woneh yee kúɗ sëꞌ dee ra.⁠ ⁠» Laban won ɗi tih⁠ ⁠: «⁠ ⁠Kon yípée won⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ɗi dalte gonla won tih⁠ ⁠: «⁠ ⁠Soꞌ mi súrgíi Abraham. ");
INSERT INTO ndv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahwee líifíɗté kélfíi sëꞌ a barke, tahte níi ri caakke alal⁠ ⁠: ɗi onte ri i yup har, peꞌ a fana, tiiŋ hélíis a úrís, súrgë ƴaal a súrgë ɓeleɓ, i géléem a i mbaam. ");
INSERT INTO ndv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ɓitifaꞌ Saara ɓeleɓi níi, límíɗté kélfíi sëꞌ koy ki ƴaali alal ma ɓéeɓ tíkú yaꞌi. ");
INSERT INTO ndv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kélfíi sëꞌ nahte soꞌ añoh biti mi ɓanti saamɗaꞌ koohi ɓeleɓ di ɓëy Kanaan fa hom ri ra, ");
INSERT INTO ndv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ndaa lah mi saamɗaa ri ɓeleɓ mboko yi na di gina coosaanaꞌ ri ra. ");
INSERT INTO ndv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mi won ɗi tígí daaha tih⁠ ⁠: “Ɓelaa kaaꞌ ñéerëꞌ a soꞌ raa nék⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ɗi tahte won tih⁠ ⁠: “Yahwee fa mi mëssí ñee woni ra ay këllíɗ malaakii fíyú, ɗi cëgíɗ yee tah fu koloh ra, paŋ níi fu kom koy soꞌ Isaak ɓeleɓ mboko yi soꞌ na, di faam baasoꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Fu pay faam baasoꞌ, wuti fu malaay raa sah, ɗeef fu paŋke wargalu, yin tíkëey sun fu.” ");
INSERT INTO ndv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Lahaꞌ mi hëbís yéemë woteh ra, mi ɗaŋke maa won tih⁠ ⁠: “Yahwee, Koope fa na jaamiyoh kélfíi sëꞌ Abraham ra, habraꞌ soꞌ níi mi maloh waali soꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mee ɓúk yéemë ee, te cafaƴ ka nay aye neh níi mi ɗaŋ ri muluɓ han ra, ");
INSERT INTO ndv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","hena biti ɗi onte soꞌ muluɓ nah soꞌ han, te mi woc raa ɗi ay hëndíɗ géléemmí sëꞌ ɓal raa, tígí daaha, may yúh biti daa ri bee tansiɗ fu koy kélfíi sëꞌ rë.” ");
INSERT INTO ndv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Mi liilayti woc ɗaŋa sah, mi otte Rebekaa na ac a peni. Ɗi lahte yéemë, nehte peni. Mi won ɗi tih⁠ ⁠: “On soꞌ muluɓ mi han, hém neɓaꞌ ro.” ");
INSERT INTO ndv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ɗi yíppée kélsëh won soꞌ tih⁠ ⁠: “Hane, te fu woc raa mi hëndíɗ géléemmú ɓal.” Mi hante, ɗi hëndíɗté géléemmí sëꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Meelaꞌ mi ri biti ɗi koy wa ra, ɗi won soꞌ tih⁠ ⁠: “Mi koy Betuwel, mi sédí Milka a Nahoor.” Tígí daaha, mantee ri ɓek supaa ñíiní, a kéñíkkë yaꞌ yi. ");
INSERT INTO ndv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mi sígímíɗté Yahwee, mi símpé rí, ɗi fi Koope fa na jaamiyoh kélfíi sëꞌ Abraham ra, ñéyrë ñéyíɗ ɗí kotti soꞌ waala toŋ níi faam sédí koy-boffi kélfíi sëꞌ rë, nda mi mín ríi kom koohi ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kon mi fahaꞌ biti koon, ɗon won soꞌ nda ron ay teeɓ kélfíi sëꞌ naaꞌ-keeñ te ɗon yégúté rí. Henay baaha raa, ɗon won soꞌ mi laɓee ílíƴ kay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban a Betuwel tahute wonu tih⁠ ⁠: «⁠ ⁠Ƴaa ɓéeɓ pagaɗɗi Yahwee. Fun lahuy yii nay fun naa wone. ");
INSERT INTO ndv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekaa abah⁠ ⁠! Kúré, fu kom ri koy kélfúu ɓeleɓ, ti ɗee fahaꞌ ri Yahwee ra nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Kelaꞌ súrgíi Abraham unni ƴaa ra, ɗi sígímíɗté Yahwee níi feey gérémpé rí. ");
INSERT INTO ndv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ɗi antee ɗúhíɗ iñi yugusuu hélíis a úrís, a i búuɓ, yeɗte wa Rebekaa⁠ ⁠; ɗi yeɗte koy-yaafa ƴaal ɓal a yaafa wargal a yoobboli mitte sëk. ");
INSERT INTO ndv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Filoon fi baaha, súrgíi Abraham a ɓëewí anutee ñam, hanute, suute fanoh. Koluu wa kéy ɓaaɓ fin ra, súrgíi Abraham won ɓëy faam fa tih⁠ ⁠: «⁠ ⁠Pëkísí sëꞌ mi nimil faam kélfíi sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ɓahii Rebekaa a yaafa wonu ri tih⁠ ⁠: «⁠ ⁠One kúkëyë hom fun na níi fíi, wuti hena waal sabboo raa sah, kolaꞌ baaha raa, ɗoni mínú saañ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ndaa súrgëe won wa tih⁠ ⁠: «⁠ ⁠Ngënë hëbí sëꞌ⁠ ⁠! Hém Yahwee cëgíɗté yee tah mi koloh ra raa, yéɗɗí sëꞌ mi saañ, mi nimil faam kélfíi sëꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Yen dëek kúkëyí ɓelaa paaƴ, yen meel ri yee hom ɗii na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Wa yípútée dëek Rebekaa meelute ri wonu tih⁠ ⁠: «⁠ ⁠Fu caŋke ñéerëꞌ a ɓëyí bee woteh, ɗon saañ a⁠ ⁠?⁠ ⁠» Ɗi tiilte wa won tih⁠ ⁠: «⁠ ⁠Tasaꞌ ɗii na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tígí daaha, wa yeɗɗute Rebekaa, ñéerëꞌté a ɓelaa koɗ ɗi ra, a súrgíi Abraham a ɓëewí. Wa na ɗagiru Rebekaa ");
INSERT INTO ndv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","wonu tih⁠ ⁠: «⁠ ⁠Koy-yaay, ɗémíin fu keñ, koyyu caak níi caak. Ɗémíin séttú ílíf ɓëewë nay waa haaꞌee ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebekaa a súrgë yí ɓeleɓ koluute, yaaguute géléemmë, ñéerúuté a súrgíi Abraham na suu. ");
INSERT INTO ndv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ƴaaha ɓéeɓ, ɗeef Isaak liiltee pay yéemë na wonuu Lahaay Roy ra níi ri nimilte faam. Ɗi húmú dék Negep. ");
INSERT INTO ndv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Sos-naꞌa ín, ɗi húmú pay tílëesëh luufa, ɓéyrëꞌ rí afi, ɗi séenté i géléem na ayu. ");
INSERT INTO ndv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ɓéyrëꞌ Rebekaa afi ɓal séenté Isaak, ɗi yíppée cép géléem fë. ");
INSERT INTO ndv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ɗi meelte súrgíi Abraham won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëyí bee filiɓ luufa na ac téebílëhí yen bee ra wah⁠ ⁠?⁠ ⁠» Súrgëe won ɗi tih⁠ ⁠: «⁠ ⁠Ɗi kélfíi sëꞌ Isaak.⁠ ⁠» Rebekaa yíppée cépíɗ músëerí tígí daaha, jímbëerëhté. ");
INSERT INTO ndv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Teeꞌuu wa ra, súrgëe ɓílíɗté Isaak ílíƴƴë ñee ri ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Lahuu wa faam ra, Isaak kúɗté Rebekaa las Saara yaafi, ɓeɓpe ri ɓeleɓ. Bi fahaꞌ Isaak Rebekaa níi, ɗi yeeltee rii mújëꞌ yaafi. ");
INSERT INTO ndv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Filoon fi Saara, Abraham kooɗte ɓeleɓ kay, bi hínú Keturaa. ");
INSERT INTO ndv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ɓelaa límíɗté rí Simran, Yoksan, Medan, Majaan, Yisbak a Suwaa. ");
INSERT INTO ndv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan daa boffi Saba a Dedan. Asurra, Létússë a Léwúmmë coosaanuu Dedan na. ");
INSERT INTO ndv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Majaan daa boffi Efaa, Efeer, Hanok, Abida a Eldaa. Ƴaa daa ɓëy tali Keturaa. ");
INSERT INTO ndv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Húlëꞌ Abraham ra, ɗi heliɗte Isaak alal mi ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Húmú homaꞌ ri ëldúnë rë, yúhëꞌ rí biti yee tallaꞌ ri pesi ra gaanlay, ɗi onte koyya lahuu ɓeleɓɓi kayya ra na alal ma, yeñce wa gini ín waal púlëen naꞌ, wa wuluute Isaak. ");
INSERT INTO ndv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham ɓahate níi paangaawte, na anti ɗeefiɗ caacci ɓúudé. Na húl ɗí rë, ɗeef ɗi pesse kíil tíméer a kíil sabay paana a kíil iip (175). ");
INSERT INTO ndv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Koyyi, Isaak a Ismayel hacuu ri kila Makpelaa, bee jaanndaꞌ Mamre, hom meey Eforon koon ra. Eforon koy Heda hínú Sohar ra. ");
INSERT INTO ndv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abraham húmú lomaꞌ meeya Hetta na. Ɓani ɓeleɓi Saara daa boku hacaa. ");
INSERT INTO ndv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Filoon fi húlí Abraham, Koo barkelte koohi Isaak. Ɗi dékké hëbís yéemë na wonuu Lahaay Roy ra. ");
INSERT INTO ndv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ƴee daa ɓëy faam Ismayel fi Abraham a Agaar fi ɓëy Ésíp, ñaami Saara. ");
INSERT INTO ndv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Tii yi koyyi Ismayel dalaꞌte saawa níi pëlíin fë në daa wa ƴeh⁠ ⁠: Nebayot, Kedaar, Atbeyel, Mipsaam, ");
INSERT INTO ndv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO ndv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadat, Tema, Yetur, Nafis a Ketma. ");
INSERT INTO ndv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ƴaa daa tii yi koyyi sabboo a ana yi Ismayel. Bina-bina ɓéeɓ kélfë tal, te gina ílíf ɗí rë teyu ɗii na. ");
INSERT INTO ndv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Na ɗeefiɗ Ismayel caacci ɓúudé rë, ɗeef ɗi lahte kíil tíméer a kíil sabay éeyë a kíil paana (137). ");
INSERT INTO ndv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ɓëy faam Ismayel dékú dalaꞌte Hawilaa, larute níi Súur, hëbís Ésíp, di waal Asuur. Ɗaaha, wa wuluute mboko yi kayya ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Bee daa naaɓii faam Isaak koy Abraham. ");
INSERT INTO ndv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Lahaꞌ ri kíil sabay iniil (40) ra, ɗi húmú kooɗ Rebekaa koy-yaafi Laban. Rebekaa koy Betuwel Arameyeŋi dék Mesopotami. ");
INSERT INTO ndv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ɓeleɓ Isaak húmú mínéh lah koy⁠ ⁠; Isaak ɗagiɗte ri, Koo-Yahwee tahte ɗaŋa, ɓelaa pokaꞌte ri loo síis. ");
INSERT INTO ndv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Hompe níi koyya na yejantuu filiɓ lowa, ɗi tahte won tih⁠ ⁠: «⁠ ⁠Bee ke soꞌ bee yi kan⁠ ⁠?⁠ ⁠» Kolaꞌ ri afi ra, ");
INSERT INTO ndv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yahwee won ɗi tih⁠ ⁠: «⁠ ⁠Gin ana daa faanu⁠ ⁠; talli ana yi bokuuy ay ɗúhëꞌ ɗoo na⁠ ⁠; ɓëyí yínëe nay luke doole, te ɓahaa nay hene súrgíi ñéedë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tílëꞌ níi lowa lahte ra, Rebekaa kúɗ síis ti ɗee húmú wonuu ri ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Bee ɗéɓpí ac ra luum ti feey fi tagu nen, faana ɓéeɓ paalte fënúf⁠ ⁠; ɗi dëekúuté Esawuu. ");
INSERT INTO ndv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Na ac ñéedë rë, habaaloh púgúlúɓ Esawuu. Ɗi dëekúuté Yakop. Límí tuŋka, ɗeef Isaak lahaꞌ kíil sabay pëenë (60). ");
INSERT INTO ndv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ooru tuŋka ra, Esawuu hente dana gaan te hoñci homaꞌ luufa⁠ ⁠; Yakop bi sos ri, na ɗúhéh faam. ");
INSERT INTO ndv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaak, bi neɓaꞌ ri boꞌ luuf níi, lukki fahaꞌ Esawuu⁠ ⁠; ndaa Rebekaa lukki fahaꞌ Yakop. ");
INSERT INTO ndv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lahte bis, Esawuu ɗúhëꞌ luufin mokke níi mok, ɗeef Yakop na paŋ ñam, ");
INSERT INTO ndv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ɗi won ɗi tih⁠ ⁠: «⁠ ⁠Top mi mínlíléh⁠ ⁠! Yíp sëe nëe on ñami luumi ƴee mi hon, mee húl rë a yaaɓ.⁠ ⁠» Yee sëeddúu rí tii Edom ra haalaꞌ yii bah⁠ ⁠: Daa ri luuma. ");
INSERT INTO ndv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Tígí daaha, Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Yeɗ soꞌ tígí saaw ku paaƴ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawuu tahte won tih⁠ ⁠: «⁠ ⁠Moh⁠ ⁠! Bee na húlëꞌ mí a yaaɓ bee ra, tígí saaw ki soꞌ ay soo ɓaate yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakop tíkílté won tih⁠ ⁠: «⁠ ⁠Añee ri⁠ ⁠!⁠ ⁠» Esawuu añohte, yeɗɗaꞌte Yakop tígí saaw ki. ");
INSERT INTO ndv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tígí daaha, Yakop túmíɗté rí ndak, yeɗte ri mbúurú. Esawuu ñampe, hante, kolohte saañce waali. Ɗi habaay tígí saaw ki yin kah-kah. ");
INSERT INTO ndv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Bín fë, yaaɓ húmú laɓpe gina, yaabi bokaay a bee húmú ɗeefaꞌ Abraham ra. Isaak kolohte saañce Abimelek buuri Fílístí në Geraar. ");
INSERT INTO ndv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ɗeef Koo-Yahwee feeñiyohte Isaak, wonte ri tih⁠ ⁠: «⁠ ⁠Ngana pay Ésíp, lah home gina nay mi roo teeɓe ra. ");
INSERT INTO ndv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Lah tooke gina, mii roo hel te may roo barkel. May yeɗ ɗoni séttú feey fi baa ɓéeɓ, ti di húmú gapaꞌ mi ri boffu Abraham, mi añohte ra. ");
INSERT INTO ndv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","May keñil talu, séttú caak níi ti hulla sun nen, mi yeɗ wa feey fi baa ɓéeɓ, te ginna feey fa ɓéeɓ ay barkeluu tii wa, ");
INSERT INTO ndv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ndah biti Abraham kelohte woni soꞌ, ñeete waala teeɓ mi ri ra, paŋke yee nah mi ri ra, ñeete kootaa pok mi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaak tasaꞌte ɗaaha Geraar. ");
INSERT INTO ndv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Meeluu ri ɓëy gina yii leŋ ɓeleɓi na, ɗi won wa ti yaa ñéedí⁠ ⁠; ɗi neeh biti won ɓeleɓi raa, ay hawu húl, bi ɗam Rebekaa níi ɗam. ");
INSERT INTO ndv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Bi maañis Isaak gina, lahte bis, Abimelek buuri Fílístí ɗúhíɗ afi falanteeri lasi, séenté Isaak na hégílëꞌ a ɓeleɓi Rebekaa, na mëesíɗ ɗí. ");
INSERT INTO ndv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelek dëekrëhté Isaak, won ɗi tih⁠ ⁠: «⁠ ⁠Ɗi míntí hena ɓeleɓu⁠ ⁠! Fu wonaꞌ biti ɗi ñéedú ɗíh⁠ ⁠?⁠ ⁠» Isaak tahte won ɗi tih⁠ ⁠: «⁠ ⁠Mi neeh biti mi hawu húl af ɗi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek tahaatte, won tih⁠ ⁠: «⁠ ⁠Fu pagaꞌ fun pagadi baa ɗíh⁠ ⁠? Tasse ƴutuuɗ koon, ow di ɓëy gina fanoh a ɓeleɓu, fu ɓek fun ɓéeɓ lool.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kolaꞌ baaha, Abimelek wolaꞌte un filiɓ gina ɓéeɓ won tih⁠ ⁠: «⁠ ⁠Ɓëyí leɓ ɓëyí bee mbée ɓeleɓi na, ay hawu húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Línëꞌ Isaak kíilí baaha, bi barkel ri Yahwee, gadi gaante níi gaan. ");
INSERT INTO ndv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Alal mi na tíl na ɓaatoh, na ɓaatoh níi ɗi caakke yin. ");
INSERT INTO ndv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ɗi húmú lahte i yup har, peꞌ, fana a i súrgë caak, tahte níi ɓëy Fílístí eeñnjuute ri, ");
INSERT INTO ndv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","púuɓúté yéemmë húmú hacu súrgë yí Abraham boffi, na pesaꞌ ri ra. ");
INSERT INTO ndv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek antee won Isaak tih⁠ ⁠: «⁠ ⁠Fu lukke fun doole leegi, kolee dee fu saañ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaak kolaꞌ ɗaaha gina, saañce yíppé húur mí Geraar, hompe na. ");
INSERT INTO ndv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ɗi sukutrohte yéemmë húmú hacu na pesaꞌ Abraham boffi ra. Daa wa yéemmë húmú púuɓú ɓëy Fílístí, húlëꞌ boffi ra. Ɗi yeraatte wa tii ya húmú sakiɗ wa boffi ra. ");
INSERT INTO ndv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Bisa ín, súrgë yí Isaak hacu yéem húur më, daɓute cul muluɓ. ");
INSERT INTO ndv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Níirëh yë Geraar yejuute íñëꞌ a ƴi Isaak, wonu ti mulaa ƴi wa. Bi lah yéemë hécëꞌ, Isaak dëekëꞌté rí «⁠ ⁠Maanndaꞌ⁠ ⁠». ");
INSERT INTO ndv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kolaꞌ baaha, súrgë yí Isaak hacaatute yéem kay. Yéemí baaha lahilte íñëꞌ⁠ ⁠; Isaak dëekëꞌté rí «⁠ ⁠Kaaꞌa⁠ ⁠». ");
INSERT INTO ndv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ɗi antee koloh daa saañce, hacilte yéemí éeyë fí lahay won yínée. Ɗi dëekëꞌté rí Rehobot (daa ri⁠ ⁠: deya). Ɗi won tígí daaha tih⁠ ⁠: «⁠ ⁠Koo-Yahwee onte yen deyi gaani yen ay naa mín saamaꞌ alal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaak kolohte daa saañce Beer-Sebaa. ");
INSERT INTO ndv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yiin lah ri ra, Yahwee feeñiyohte ri elgin won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi Koope fi boffu Abraham. Ngana néekíñëꞌ yin, ndée mii roo yeris, te may roo barkel. Af súrgíi sëꞌ Abraham, tahte may keñil talu níi séttú caak.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaak yíppé ílíƴ hawraa daaha. Na ɗaŋ ri Koo ra, ɗi ñeyaꞌ ri tiyi, dëekëꞌté rí Yahwee, yíppé taanta yi, súrgë yí dalaatute hac yéem kay. ");
INSERT INTO ndv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek kolohte Geraar, ñéerëꞌté a Ahusat kooji, a Pikol kélfíi wohoh ya, ɗeefiɗte Isaak. ");
INSERT INTO ndv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaak won wa tih⁠ ⁠: «⁠ ⁠Ɗon ayu yi soo na te ɗon fahuuy soꞌ níi ɗon líkúté sëꞌ ginon⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wa tahute wonu ri tih⁠ ⁠: «⁠ ⁠Fun olu olo biti Yahwee ñéerëꞌté a ro, fun ayu biti koon yen pokantaꞌ kooƴ, yen añoh ri hanndal ki yen. ");
INSERT INTO ndv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Añee biti fii fun paŋ yin misik ndée fun pagiru ro yin wun kut, te fu sayaꞌ a jaamma, ɗo fa Yahwee barkel ro woteh ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaak pagiɗte wa ñami neɓpe, yeɗte wa han. ");
INSERT INTO ndv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Yíilëꞌ Koo ɓaabin cúɓ kéy fín fë, wa pokantuute kooƴ, añuute, Isaak pëkíssé wë, wa takuute a jaamma. ");
INSERT INTO ndv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Yiin fa, súrgë yí Isaak ayute woni biti yéemë na hacu wa ra gúlté. ");
INSERT INTO ndv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaak dëekëꞌté yéemë Sibaa (daa ri⁠ ⁠: añoh). Tii Beer-Sebaa fa na wonuu gini baa ra haalaꞌ yii baa níi a woteh. ");
INSERT INTO ndv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Lahaꞌ Esawuu kíil sabay iniil (40) ra, ɗi kooɗte ɓeleɓ ana yi nonu tali Het⁠ ⁠: Yúdít koy Béerí, a Basmat koy Elon. ");
INSERT INTO ndv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ɓeleɓɓi ana yi hetta kooɗ Esawuu ra yahute pesi Isaak a Rebekaa. ");
INSERT INTO ndv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Bi ɓaha Isaak, íllë ñúussé níi ɗi na ollileh. Lahte bis, ɗi dëekké Esawuu koy ki saawi won ɗi tih⁠ ⁠: «⁠ ⁠Koy soꞌ dih⁠ ⁠? Esawuu⁠ ⁠!⁠ ⁠» Esawuu tahte won tih⁠ ⁠: «⁠ ⁠Mi abee baap⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaak ɓaatte won tih⁠ ⁠: «⁠ ⁠Fu otte biti mi maante. Yee tallaꞌ mi pesi soꞌ ra gaanay⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kon ɓeye kas ku, fu haal aba ndín fu saamiɗ soꞌ ndawal. ");
INSERT INTO ndv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Fu ac raa, fu pagiɗ soꞌ na ñami neɓaꞌte soꞌ, fu kom soꞌ mi ñam níi keeñ soꞌ sos ndín, mi ɗagiɗ ro balaa mi húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Na won Isaak koohi na ra, ɗeef Rebekaa na síkírëh. Sayaꞌ Esawuu ɓoorsoh abin saamɗi boffi ndawal ra, ");
INSERT INTO ndv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekaa won koohi Yakop tih⁠ ⁠: «⁠ ⁠Mi kelohte boffu na won Esawuu biti ");
INSERT INTO ndv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ɗi saamiɗ ɗi ndawal, ɗi pagiɗ ɗi ñami neɓpe. Ɗi ñam níi woc raa, ɗi ɗagiɗ ɗi Koo-Yahwee, balaa ri húl. ");
INSERT INTO ndv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kon síkírëh sëꞌ koy soꞌ, te fu paŋ yee nay mi roo nahe ra⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Paye yubin fu kaliɗ soꞌ sékét teem-teem ana yi wunute faan, mi pagiɗ boffu na ñami neɓpe ti ɗee fahaꞌ ri ra nen, ");
INSERT INTO ndv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","fu kom ri ɗi ñam ndín, ɗagiɗ ro balaa ri húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ndaa Yakop tahte won yaafi tih⁠ ⁠: «⁠ ⁠Fu yúhté biti faan Esawuu paalte jëfëñ a bi soꞌ muluc. ");
INSERT INTO ndv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Baasoꞌ lalam faan soꞌ raa, ay yúh biti mi nofaꞌ ri nofoo⁠ ⁠; tígí daaha, may malee cuñ ndée ɗaŋ neh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ndaa yaafa tíkké won tih⁠ ⁠: «⁠ ⁠Cuña keena af soꞌ ɓal⁠ ⁠! Page yee nah mi ro ra kut, te fu kom soꞌ sékéttë deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakop payte, kompe wa yaafi. Yaafa paŋke ñama neɓaꞌ boffa ra. ");
INSERT INTO ndv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekaa antee tanis búuɓɓée lukki wun di búuɓɓí Esawuu ɓahaa, ƴee húmú yef ɗi fi yaafa ra, yeɗte wa Yakop ñéedë, ɓekohte. ");
INSERT INTO ndv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ɗi ɓeɓpe hunni sékéttë, ŋaawte yaꞌ yi Yakop a tígë lahay fen lúumë rë, ");
INSERT INTO ndv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","antee rii yeɗ ñami neba a mbúurëe paŋ ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakop lahte boffi na won tih⁠ ⁠: «⁠ ⁠Baap⁠ ⁠!⁠ ⁠» Isaak tahte won tih⁠ ⁠: «⁠ ⁠Yaa yi koy soꞌ⁠ ⁠? Daa fu wa na yínë paaƴ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi Esawuu koy ki saawu. Mi paŋke yee nah fu soꞌ ra. Yípée koloh fu ñam na ndawala hawiɗ mi ro ra, woc raa fu ɗagiɗ soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaak won ɗi tih⁠ ⁠: «⁠ ⁠Fu ñee di níi fu yíppée lah ndawal haat koy soꞌ⁠ ⁠?⁠ ⁠» Yakop tahte won tih⁠ ⁠: «⁠ ⁠Bee oni funi Koope fu Yahwee.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaak won ɗi tih⁠ ⁠: «⁠ ⁠Leɓoh soꞌ dee noo koy soꞌ mi lalam faanu níi lan soꞌ biti fu koy soꞌ Esawuu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakop leɓohte boffi, Isaak lalampe faana, won tih⁠ ⁠: «⁠ ⁠Una madaꞌ un Yakop, ndaa yaꞌ ya ƴi Esawuu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Bi hen yaꞌ ya jëfëñ a fënúf ti ƴi Esawuu koy-yaafi nen, ɗi yúhsëey rí. Ndaa na ɗagiɗ ri Yakop ra, ");
INSERT INTO ndv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","meelaatte ri paaƴ won ɗi tih⁠ ⁠: «⁠ ⁠Fu won kaah biti fu koy soꞌ Esawuu a⁠ ⁠?⁠ ⁠» Yakop tahte, won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi kay baap⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tígí daaha, Isaak won ɗi tih⁠ ⁠: «⁠ ⁠Kon tíkíɗ sëꞌ loona mi ñam na boꞌ fu ndín, mi ɗagiɗ ɗo.⁠ ⁠» Yakop tíkíɗté boffi loona, boffa ñampe. Ɗi yeɗte ri béeñ ɓal, boffa hante. ");
INSERT INTO ndv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Isaak antee won Yakop tih⁠ ⁠: «⁠ ⁠Leɓoh soꞌ koy soꞌ, fu yabaaloh soo na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakop leɓohte boffi, yabaalohte ɗii na. Haalaꞌ ri ngedi búubí, Isaak ɗagiɗte Yakop a unni ƴeh⁠ ⁠: «⁠ ⁠Ëlí kan⁠ ⁠! Kiili fi koy soꞌ man ngedi meeyi Yahwee barkelte ri nen. ");
INSERT INTO ndv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ɗémíin Koo on ɗo na maala ɗúhëꞌ sun ra, feey fi looɓpe, pep caak te béeñí neɓpe yooɓ ro⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ɗémíin fu homa af i gin, níi i tal ƴek fíyú⁠ ⁠! Daa fay paaꞌee mboko yu ɓéeɓ sun, te wa ɓéeɓ ay roo sígímíɗ⁠ ⁠! Ɓëyí ɗagiɗ ro yin wun, Koo líhë rí yeren⁠ ⁠! Ɓëyí lah nuf ɓos ɗoo na nék, húlëe af ti úul nen⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Wocaꞌ Isaak ɗaŋa, Yakop saañce. Ɗi na gét, Esawuu ɗúhëꞌ ɓoorsoha na lah. ");
INSERT INTO ndv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ɗi nampee paŋ ñami neɓpe ɓal, kompe boffi won ɗi tih⁠ ⁠: «⁠ ⁠Baap⁠ ⁠! Yípée koloh fu ñam na boꞌ fa ɗúhëꞌ mí ɓoorsoha ra, woc raa fu ɗagiɗ soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaak meelte ri won tih⁠ ⁠: «⁠ ⁠Daa fu wah⁠ ⁠?⁠ ⁠» Ɗi tahte won tih⁠ ⁠: «⁠ ⁠Daa mi Esawuu koy ki saawu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kelaꞌ ri uni bah, Isaak éempé níi faana ɓéeɓ na saak. Ɗi won tih⁠ ⁠: «⁠ ⁠Kon daa pay ɓoorsoh, kompe soꞌ boꞌ níi mi ñampe na balaa fu ac⁠ ⁠? Mi liiltee rii ɗagiɗ te ɗaŋa hampe⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kelaꞌ Esawuu unnee ke boffi ƴah, keeña líiffé, ɗi yefohte lëelí misikke, na won boffa tih⁠ ⁠: «⁠ ⁠Baap⁠ ⁠! Ole yee homaꞌ mi ra rek fu ɗagiɗ soꞌ ɓal⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ndaa Isaak won ɗi tih⁠ ⁠: «⁠ ⁠Aꞌ, koy-yaafu nofaꞌte soꞌ kat níi ɓeɓpe ɗaŋu⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawuu won daaha tih⁠ ⁠: «⁠ ⁠Daa ri ey ti hínú Yakop kaah, ndée ri nofaꞌte soꞌ waal ana. Ɗi ɗéɓpí ɓeɓ tígí saaw ki soꞌ, acce woteh ɓeyilte ɗaŋi soꞌ⁠ ⁠! Fu tallaay kay fu ɗagiɗ soꞌ kan aa baap⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaak won ɗi tih⁠ ⁠: «⁠ ⁠Síkírëh sëꞌ koy soꞌ, mi mínlíléh yin na⁠ ⁠: mi tíkké rí sun fu, te mboko yi ɓéeɓ ay ñee uni. Daa ri lahaꞌ pebi caaga a béeñí neba.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawuu yípëhté af boffi won ɗi tih⁠ ⁠: «⁠ ⁠Níi fu lahaꞌ ɗaŋ yínë kut a⁠ ⁠? Ɗagiɗ soꞌ ɓal baap⁠ ⁠!⁠ ⁠» Esawuu yípëetté afi na looy. ");
INSERT INTO ndv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tígí daaha, Isaak boffi won ɗi tih⁠ ⁠: «⁠ ⁠Mi yúhté biti fay wuloh feey fi looɓpe, a tígí na cépëꞌ maal. ");
INSERT INTO ndv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Fay pesee haaꞌ a loh te ñéedú nay roo paaꞌee sun. Ndaa ay tíl níi fii rii míníl múñ, yii won ɗo ri, fay rii nís, fu múc yaꞌi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ɓeya ɓeɓ Yakop ɗaŋa ra tahte Esawuu ngaaɗte ri níi na wonaaloh biti yee tas pesi boffi wa ra gaanlay, te ɗi húlé rek, ɗi bëemé Yakop. ");
INSERT INTO ndv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kelaꞌ Rebekaa yee won koy ki ɓahaa Esawuu ra, ɗi dëekrëhté Yakop ñéedë won ɗi tih⁠ ⁠: «⁠ ⁠Bee homaꞌ ɓahuu Esawuu bee ra, ɗi ee fahaꞌ yíllëh sun fu ra, na gapaꞌ hawu húl. ");
INSERT INTO ndv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kon síkírëh sëꞌ koy soꞌ, mi won ɗo⁠ ⁠: Yípée hegoh fu saañ Haran, faam Laban koy-yaasoꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Lah home dín fë níi keeñ koy-yaafu yëellëh. ");
INSERT INTO ndv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tíl níi neeɓi ɗúm ɗi hal yee paŋ fu ri raa, may wolaꞌ kalu. Mi fahaay biti mi ñak ɗon ɓéeɓ ana waala yínë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Filoon fi baaha, Rebekaa payte won Isaak tih⁠ ⁠: «⁠ ⁠Hetti ana ya kooɗ Esawuu ra tahute pesa ɗahte soꞌ níi ɗah. Yakop koora het ti ƴee ke Esawuu ƴee raa, mi húlë húlë daa génël sëꞌ pes yee tas fíi rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tígí daaha, Isaak dëekké Yakop ɗagiɗte ri waali neɓpe, antee rii won unni ƴeh⁠ ⁠: «⁠ ⁠Yakop⁠ ⁠! Mi fahaay biti fu koora ɓelii Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kolee fu saañ Mesopotami faam ciffu ƴaal, Betuwel fa lím yaafu ra⁠ ⁠; lah saamee ɓeleɓ daaha di koyyi taanu Laban koy-yaafi yaafu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Na ɗagiɗ ri boffa ra, won tih⁠ ⁠: «⁠ ⁠Ɗémíin Koope fa mín ɓéeɓ rë barkel ro, keñil talu níi fu hen ɓaha goomal i tal⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ɗémíin ɗi barkel ɗoni koyyu a séttú, ti ɗee barkelaꞌ ri Abraham ra nen, nda fu lahaꞌ gina maangaanaꞌ fu bee ra, ginee on Koo Abraham ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaak yejaꞌ Yakop ɗaaha Mesopotami, Yakop sayaꞌte ri faam Laban koy Betuwel Arameyeŋa. Laban koy-yaafi Rebekaa. Rebekaa daa yaafi Yakop a Esawuu. ");
INSERT INTO ndv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esawuu kelohte biti Isaak ɗagiɗte Yakop, antee rii yeñ saam ɓeleɓ faam Laban di Mesopotami. Te na ɗagiɗ ɗi ri ra, kaddaꞌte ri kooɗ koy ki Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakop kelohte woni boffi a yaafi, kolohte saañce Mesopotami. ");
INSERT INTO ndv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Yii baa teeɓpe Esawuu biti boffi wonay yin ɓelii Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tígí daaha, ɗi saañce faam Ismayel koy Abraham, kooɗte koohi Mahalat ñéedí Nebayot, ɓaatte ana yee ɗéɓ ɗë. ");
INSERT INTO ndv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yejaꞌ Isaak Yakop saam ɓeleɓ faam Laban ra, Yakop kolohte Beer-Sebaa, ɓeɓpe waali Haran. ");
INSERT INTO ndv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tígë haalaꞌ ri naꞌ waala ra, ɗi neeꞌ na. Na fanoh ri ra, ɗi saampe laꞌ giginaꞌte ri afi. ");
INSERT INTO ndv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ɗi heeƴce elgin⁠ ⁠: filiɓ heeja, ɗi otte iskalii yípú feey, afa haalte níi nérrín. Malaaka yi Koope ñeyu na, na lawu na cépú. ");
INSERT INTO ndv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Koo-Yahwee caŋke hëbís Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi Yahwee, Koope fi ciffu Abraham a boffu Isaak. May roo on feey fa fanoh fu ra, ɗoni koyyu a séttú. ");
INSERT INTO ndv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ɗon ay caak níi ti pep feey nen. Feey fi talu ay ɓaatoh, ɗi laɗ waal púlëen a waal haalaan naꞌ, waal feey-feey a waal ƴuuŋ⁠ ⁠; te talla feey fa ɓéeɓ ay barkeluu tiyu a tii séttú. ");
INSERT INTO ndv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mee roo won ra ee⁠ ⁠! Yúhé biti mii roo hel, te tígí mín fúu pay ɓéeɓ, may roo níiɗ níi mi wëegísíɗ ɗë gini beh. Mii roo hélíɗ, te iña gap mi ro ra ɓéeɓ may waa paŋ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yúunëꞌ Yakop ra won nufi tih⁠ ⁠: «⁠ ⁠Koo-Yahwee ee tígí dee kaah, te mi yéeh baaha koon⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakop néekíñëꞌté, ɓaatte won tih⁠ ⁠: «⁠ ⁠Tígí dee tíitɗëꞌté ee⁠ ⁠! Dee míntí hena Faam Koo te ílí haalaa daa reeni saañce sun.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakop kolohte ɓaabin cúɓ, ɓeɓpe laꞌa giginaꞌ ri afi ra, yíppé rí tíinndëe, túmpé dúuléen sun. ");
INSERT INTO ndv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ɗi yeɗte tígë tii Betel (daa ri⁠ ⁠: Faam Koo), ndaa tígí daaha húmú wonuu Lúus merees. ");
INSERT INTO ndv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakop antee añoh won tih⁠ ⁠: «⁠ ⁠Hena biti Koope ii soo yeris, te ay soo níiɗ waali soꞌ raa, hena biti ɗi ay soo yeɗ yii ñama mi a yii ɓekaa mi raa, ");
INSERT INTO ndv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","hena biti ɗi ay soo wëegísíɗ faam baasoꞌ a jaamma raa, tígí daaha, Yahwee ay hen Koope fi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Laꞌa yíp mí tíinndëe rë nay hene Faam Koo, te alal ma nay ri soo one ra woruun sabboo raa, may rii yeɗ wodi yínëe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakop ɓeyaatte waali, yuliɗte ginna púlëen naꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ɗi tíl tílë níi lahte bis, ɗi otte yéem luufa. Bi hen yéemë hënndëe, yup éeyë yí lahaꞌ har a peꞌ ɓoofute tal yéemë. Ɓúk yéemë kúnúu a laꞌ gaan. ");
INSERT INTO ndv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Yuppa ɓéeɓ teeꞌaꞌ raa, níirëh yë píníŋ laꞌa hom ɓúk yéemë rë ndín, wa hëníɗ. Woc raa, wa wëegísíɗ laꞌa ɓúk yéemë. ");
INSERT INTO ndv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakop lahte na wodoh, meelte níirëh yë won wa tih⁠ ⁠: «⁠ ⁠Cëlíirí yaawe⁠ ⁠! Ɗon ɓëy dih⁠ ⁠?⁠ ⁠» Wa tahute wonu ri tih⁠ ⁠: «⁠ ⁠Fun ɓëy Haran.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ɗi meelaatte wa won tih⁠ ⁠: «⁠ ⁠Ɗon yúhú sédée ké Nahoor hínú Laban raa⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun yúhú rí kay⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakop ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Ɗon heluu ri lahte sos-faan a⁠ ⁠?⁠ ⁠» Wa tahute wonu tih⁠ ⁠: «⁠ ⁠Ɗi yíilté ces⁠ ⁠! Kúkëyí ɓelaa na ac bín rë sah kúɗ yuba ra koohi Rasel.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakop tíkílté won tih⁠ ⁠: «⁠ ⁠Yúhí biti naꞌa lís sun⁠ ⁠! Yup lahayti hëellú doom⁠ ⁠; ɗon sehu yi hënndí wë a kúrí wë mburukliin⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Níirëh yë wonu ri tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ⁠ ⁠! Fun na héníh ɗah⁠ ⁠! Fun sehuu sehoo níi yuppa ɓéeɓ teeꞌaꞌ, fun anti píníŋ laꞌa kúnúu ɓúk yéemë rë ndín, fun hëndíɗ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Lahi Rasel a yubi boffi, ɗeef Yakop líssí goneel a níirëh yë. Ɗi fi Rasel níirëh ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Olaꞌ Yakop koy taani a yuba, ɗi lahte yéemë, píníŋké laꞌa kúnúu ɓúgë rë, hëníɗté yubi taani. ");
INSERT INTO ndv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kolaꞌ Yakop dah, yabaalohte sun fi Rasel, muun mi na yookoh. ");
INSERT INTO ndv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Boffu taan soꞌ yaa-ow⁠ ⁠! Mi koy Rebekaa.⁠ ⁠» Rasel yíppée múkë woni boffi baaha. ");
INSERT INTO ndv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kelaꞌ Laban ban fi ayi Yakop jarbaadi, ɗi yíppée koloh téebílëhté rí, yabaalohte sun fi antee rii kúɗ faami. Ɗaaha, Yakop ɓílíɗté rí iña kat ri ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban won ɗi tih⁠ ⁠: «⁠ ⁠Moo fu non faam fa kaah, ñif mi yen yínë⁠ ⁠!⁠ ⁠» Yakop hompe céyín múlgús faam fa. ");
INSERT INTO ndv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lahte bis, Laban won ɗi tih⁠ ⁠: «⁠ ⁠Ƴaal soꞌ, biti fu jarbaadi soꞌ ɓanay tah fu légéyéré sëꞌ pëtíh. Won soꞌ yee nay fuu waafu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ɗeef Laban lahte koy ɓeleɓ ana. Ɓahaa hínú Leyaa, ñéedë hínú Rasel. ");
INSERT INTO ndv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Íllí Leyaa ɗamay, ndaa Rasel húmú ɗampe ɓeleɓ te neɓpe yeel. ");
INSERT INTO ndv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Bi ɗeef Yakop liiltee fahaꞌ Rasel, ɗi won Laban tih⁠ ⁠: «⁠ ⁠Fu tah oni soꞌ koohu Rasel ɓeleɓ raa, may roo légéyíɗ kíil paana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban tahte won tih⁠ ⁠: «⁠ ⁠Mi on ɗo ri daa nay géné biti mi ona ri ow kay dih⁠ ⁠! Home faam soꞌ deh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Fahaꞌi ɓeyi Rasel ɓeleɓ tahte níi kíillí paana ya légéyíɗ Yakop Laban ra man i waal ɗii na nen, bi fahaꞌ ri Rasel níi fahaꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ɗi antee won Laban tih⁠ ⁠: «⁠ ⁠Aappii yen lahte maan ɓahaa⁠ ⁠? Mi fahaꞌ biti koon fu yeɗ soꞌ ɓeleɓ soꞌ, mi kooɗ ɗi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban kolaꞌ daa yíppé ndaje, gappe ɓëy hatni baa ɓéeɓ kílëegë. ");
INSERT INTO ndv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ndaa yúhëꞌ rí biti Koo ñúkúffé rë, ɗi ɓeɓ Leyaa kompe Yakop neeꞌte ɗii na. ");
INSERT INTO ndv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban ɓeɓpe Silpaa súrgíi, yeraalohte ri koohi Leyaa. ");
INSERT INTO ndv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Yíilëꞌ Koo kéy fín, Yakop ot Leyaa⁠ ⁠! Tígí daaha, ɗi payte won Laban tih⁠ ⁠: «⁠ ⁠Fu pagaꞌ soꞌ yii baa ɗíh⁠ ⁠? Af Rasel daa húmú tah mi légéyíɗ ɗo neh a⁠ ⁠? Haalaꞌ yi níi fa na nofaꞌ soꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban won ɗi tih⁠ ⁠: «⁠ ⁠Fun ɓaahuuy biti kúkëy ɓeleɓ ɗéɓ ɓahii kooru daa tah ɗee ƴaal soꞌ⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Lúsɗé waalli paana yi kílëegë a ɓahaa. Woc raa, fun ay roo on ñéedë ɓal, biti fu tah légéyíɗí sëꞌ kíil paana kay fíi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakop tahte yee won ɗi Laban ra. Lúsɗëꞌ rí waalli paana yi kílëegë a Leyaa ra, Laban yeɗte ri Rasel. ");
INSERT INTO ndv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban ɓeyaalohte Bilhaa súrgíi, yeɗte ri koohi Rasel. ");
INSERT INTO ndv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakop namiltee neeꞌ a Rasel fa ɗi lukki fahaꞌ ri ra. Ɗi yabilte légéyíɗí Laban, yuliɗte ri kíil paana kay. ");
INSERT INTO ndv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Olaꞌ Koo-Yahwee biti Yakop lukki fahaꞌ Rasel ra, ɗi keñilte Leyaa, ndaa teeɓay Rasel koy. ");
INSERT INTO ndv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leyaa pokke loo, lahte koy ƴaal, dëekëꞌté rí Ruben (daa ri⁠ ⁠: ëlí⁠ ⁠! Bee koy ƴaal). Ɗi won tígí daaha tih⁠ ⁠: «⁠ ⁠Yahwee otte súfúñ fí sëꞌ⁠ ⁠; nda ƴaali soꞌ mín sëe fahaꞌ waay⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leyaa pokaatte loo, lahaatte koy ƴaal kay. Ɗi won tih⁠ ⁠: «⁠ ⁠Biti mi fahuuy, Yahwee keloh na, daa kúɗ koy ki ƴaali ana fi beh.⁠ ⁠» Ɗi dëekëꞌté rí Simewoŋ (daa ri⁠ ⁠: kelohte). ");
INSERT INTO ndv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ɗi pokilte loo kay lahilte koy ƴaal. Ɗi won tih⁠ ⁠: «⁠ ⁠Waali beh, ƴaali soꞌ ay pokoh soo na koma kom mi ri koy ƴaal éeyë rë.⁠ ⁠» Koy ka dëekúuté Léwí (daa ri⁠ ⁠: ay pokoh). ");
INSERT INTO ndv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ɗi poklaatte loo, lahlaatte koy ƴaal. Ɗi won tih⁠ ⁠: «⁠ ⁠Waali yíníi beh, may kañe Yahwee⁠ ⁠!⁠ ⁠» Ɗi dëekëꞌté rí Yudaa (daa ri⁠ ⁠: ay kañ). Ɗi antee caŋ, lécíɗté lah koy. ");
INSERT INTO ndv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Olaꞌ Rasel biti ɗi lahay koy ra, ɗi maɗte Leyaa ɓahii di koyyi, antee won ƴaali tih⁠ ⁠: «⁠ ⁠Yen lahuy koy may húl ɓal⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakop yíppée haayloh won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi Koo woo, ɗi fa teeɓay ro koy ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rasel tahte won tih⁠ ⁠: «⁠ ⁠Kon ɓeye Bilhaa súrgíi sëꞌ ɓeleɓ, ɗoni ñéerëꞌ. Ɗi lah koy raa, mi hen yaafa book⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ɗaaha, ɗi onte ri Bilhaa súrgíi ɓeleɓ, Yakop a súrgëe ñéerúuté. ");
INSERT INTO ndv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhaa pokke loo, ɓani Yakop lahute koy ƴaal. ");
INSERT INTO ndv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rasel won tih⁠ ⁠: «⁠ ⁠Koo tahte ɗaŋi soꞌ. Ɗi aattiyaꞌte soꞌ kan, onte soꞌ koy ƴaal.⁠ ⁠» Ɗi dëekëꞌté rí Dan (daa ri⁠ ⁠: aattiyaꞌte). ");
INSERT INTO ndv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhaa súrgíi Rasel pokaatte loo, ɓani Yakop lahute koy ƴaal kay, hente ana. ");
INSERT INTO ndv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasel won tih⁠ ⁠: «⁠ ⁠Mi haaꞌte ɓahii soꞌ haaꞌi misikke, te mi ɓaŋke ri⁠ ⁠!⁠ ⁠» Ɗi dëekëꞌté koy ki baa Neftali (daa ri⁠ ⁠: haaꞌte). ");
INSERT INTO ndv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ɗi fi Leyaa olaꞌ ri biti ɗi caŋke lécíɗté lah koy ra, ɗi ɓeɓpe Silpaa súrgíi, onte ri Yakop ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silpaa a Yakop lahute koy ƴaal. ");
INSERT INTO ndv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leyaa won tígí daaha tih⁠ ⁠: «⁠ ⁠Bee múuɗ kan⁠ ⁠!⁠ ⁠» Ɗi dëekëꞌté rí Gaat (daa ri⁠ ⁠: múuɗ). ");
INSERT INTO ndv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpaa a Yakop lahute koy ƴaal kay, hente ana. ");
INSERT INTO ndv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leyaa wonaat daaha tih⁠ ⁠: «⁠ ⁠Keeñ soꞌ sosse siiɓ, te ɓeleɓɓa ay soo mín dëekëꞌ sos-keeñ fe.⁠ ⁠» Ɗi dëekëꞌté rí Aseer (daa ri⁠ ⁠: sos-keeñ). ");
INSERT INTO ndv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Lahaꞌ wahtu lec bele ra, bisa ín Ruben ɗúhëꞌ meey, saamaalohte i koy maadda tílëe-ngoro, kompe wa Leyaa yaafi. Rasel won Leyaa tígí daaha tih⁠ ⁠: «⁠ ⁠On soꞌ na maaddaa kúɗ koohu ra, hém neɓaꞌ ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leyaa won ɗi tih⁠ ⁠: «⁠ ⁠Naafa naaf fu ƴaali soꞌ ra doyay ro doyo níi fu na fahaꞌ ɓeyli maaddii koy soꞌ a⁠ ⁠?⁠ ⁠» Rasel tahte won tih⁠ ⁠: «⁠ ⁠Hém ɗaaha raa on soꞌ na, lah raa Yakop neeꞌ ɗoo na elge book⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Fíníin fín, Yakop kolaꞌ meey na ac, Leyaa téebílëhté rí, won ɗi tih⁠ ⁠: «⁠ ⁠Fay neeꞌe soo na elge⁠ ⁠: mi lofraꞌ ri a maaddii koy soꞌ.⁠ ⁠» Yakop neeꞌte Leyaa na ɗaaha elgi baaha. ");
INSERT INTO ndv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Koope ñéerëꞌté a yee fahaꞌ Leyaa ra, ɗi pokke loo, ɓani Yakop lahute koy ƴaal, hente koy ƴaal iip. ");
INSERT INTO ndv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leyaa won tih⁠ ⁠: «⁠ ⁠Koope yínílté sëꞌ ona on mi ƴaali soꞌ súrgíi sëꞌ ɓeleɓ ra.⁠ ⁠» Ɗi dëekëꞌté rí Isakaar (daa ri⁠ ⁠: yínílté). ");
INSERT INTO ndv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leyaa pokaatte loo, ɓani Yakop lahute koy ƴaal kay, hente koy ƴaal pëenë. ");
INSERT INTO ndv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leyaa won daaha tih⁠ ⁠: «⁠ ⁠Waafi funi Koope mitte sëk kan⁠ ⁠! Waali yíníi beh, ƴaali soꞌ ay soo ɓéyíɗ, koma kom mi ri koy ƴaal pëenë rë.⁠ ⁠» Ɗi dëekëꞌté rí Sabuloŋ (daa ri⁠ ⁠: ɓéyíɗté). ");
INSERT INTO ndv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hompe níi, Leyaa lahte koy ɓeleɓ, dëekëꞌté rí Dinaa. ");
INSERT INTO ndv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tígí daaha, nuf Koo payte Rasel na, ñéerëꞌté a yee fahaꞌ ri ra, lowa tahte. ");
INSERT INTO ndv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rasel pokke loo, lahte koy ƴaal, won tih⁠ ⁠: «⁠ ⁠Ëy Koope paƴce gacii soꞌ kan⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ɗi dëekëꞌté koohi Suseef (daa ri⁠ ⁠: ɗi ɓaatte), na ɗaŋ won tih⁠ ⁠: «⁠ ⁠Ɗémíin Koo-Yahwee ɓaat soꞌ koy ƴaal kay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Filoon fi bee límúu Suseef ra, Yakop won Laban tih⁠ ⁠: «⁠ ⁠Pëkís sëꞌ mi nimil gin fun, mi saañ faam. ");
INSERT INTO ndv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Yeɗ soꞌ ɓeleɓɓa tah mi légéyíɗ ɗë rë, mi kúrëelëh ɓani koyyi soꞌ, mi saañ⁠ ⁠; ndée fu otte yee pagiɗ mi ro ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban won ɗi tih⁠ ⁠: «⁠ ⁠Síkírëh sëꞌ, hém neɓaꞌ ro⁠ ⁠: ɗíkísëꞌ mí rë, mi otte biti af ɗo daa tah Koo-Yahwee barkel soꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kon home dee book fu won soꞌ yee mín fuu yínlú rë, mi yeɗ ɗo ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Fu otte yee légéyíɗ mi ro ra a ɗee tahaꞌ mi yuppu ɓaatoh ra maan⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Na ac mi dee ra, ɗeef iñu loolay níi, ndaa fu otte biti alal mu ɓaattee ñimin woteh, af biti Yahwee barkelte ro togaꞌ mi kot soꞌ faamu níinén. May légéyéré faam soꞌ kirih nam⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban ɓaatte won tih⁠ ⁠: «⁠ ⁠Won soꞌ yee nay mi roo yínlé rë fu tas book⁠ ⁠!⁠ ⁠» Yakop won tih⁠ ⁠: «⁠ ⁠Mi yeekay ro yíníl. Fu tah yee nay mi roo wone raa, may roo níiríɗ yuppu, mi wohiɗ ro wa ti merees nen. ");
INSERT INTO ndv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Fu fahaꞌ raa mi ñee yuppu ɓéeɓ woteh mi kénsëh⁠ ⁠: harri yínë-yínë yë naaꞌuy peyeɓ ra, a peꞌ yi yínë-yínë yë súulúy kúk rë, lah raa mi ɓís wë, mani wa ɓéeɓ hen yínlí sëꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Fu ac kénsëhí yínlí sëꞌ fayu yúhí nda mi júɓpé rëe, fu ot na har naaꞌ peyeɓ mbée peꞌ súul kúk rëe, lah habee biti wa lohu loho.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban won ɗi tih⁠ ⁠: «⁠ ⁠Mi tahte yee won fu soꞌ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ndaa yiin fin fa, Laban ɓíssé peꞌ yi geñe-geñe ya a ƴee faanni wa tap naaꞌ ra, a harra naaꞌuy peyeɓ ra ɓéeɓ, tíkké wë yaꞌ yi koyyi. ");
INSERT INTO ndv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Laban a koyyi anutee tíl waal éeyë níi wa wuluute Yakop. Ɗi fi Yakop yeeltee teem níirí caan fi yuppi Laban. ");
INSERT INTO ndv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakop payte saampe i yaꞌ kilik hilsiɗ⁠ ⁠: wa yaꞌ pëepílí, amaan a palataan, haasse wa kúur-kúur naaꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Bi júrë lawantuu biti wa ac han, Yakop ɓekke yaꞌ yi kilikka haas ɗi ra filiɓ mbalka ya na hanuu júrë rë. ");
INSERT INTO ndv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Júrë hom lawantuu hëbís yaꞌ yi kilikka haasu ra, tahte níi faanni ndeŋŋa límú wë rë ɓéeɓ, ƴee henute geñe-geñe, ƴee faanni wa tappe naaꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yii leŋke harra na, Yakop ɓísëꞌté wë a peꞌ ya. Ɗi yíssíɗté wë júrë faanna hen geñe-geñe ra, a ƴee súul yubi Laban ra. Ɗi lahaꞌ yup ɗah, ɓísëꞌté wë a ƴi Laban. ");
INSERT INTO ndv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ɓaatte biti koluun júrë lukuu wun faan ra lawantaꞌ ɓéeɓ, Yakop ɓeɓ yaꞌ yi kilikka haasu ra, tík wë fíi wë filiɓ mbalka ya, wa lawee ndín yeele na. ");
INSERT INTO ndv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ndaa hena júrë ɓos faan ra raa, Yakop na ɓekeh kilikka. Ɗaaha, júrë lukki ɓos faan ra hente ƴi Laban, ƴee lukuu wun faan ra hente ƴi Yakop. ");
INSERT INTO ndv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yakop pagaꞌ ri ɗaaha níi ɗi caakke alal⁠ ⁠: ɗi caakke har a peꞌ, lahte i súrgë ƴaal a ɓeleɓ, i géléem a i mbaam. ");
INSERT INTO ndv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Hompe níi, Yakop kelohte capitohi koyyi Laban biti ɗi ɓeɓpe alal mi boffi wa ɓéeɓ⁠ ⁠; ndah iña lahaꞌ ɗi ra ɓéeɓ ɗúhëꞌ alal mi boffi wa. ");
INSERT INTO ndv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakop otte biti ɓal íllë na yeelaꞌ ri Laban leegi ra madlay ti merees nen. ");
INSERT INTO ndv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tígí daaha, Koo-Yahwee won Yakop tih⁠ ⁠: «⁠ ⁠Nimile ɓëy faamon na gin baappu, mi ot ɗoo na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakop hom yuppi na meeyyin, wolaꞌte Rasel a Leyaa. ");
INSERT INTO ndv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Lahuu wa ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Mi otte biti íllë na yeelaꞌ soꞌ boffon leegi ra madlay ti merees nen⁠ ⁠; ndaa Koope fa na jaamiyoh baasoꞌ ra ñéerëꞌté a soꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ɗon yúhrúté affon biti doolii soꞌ ɓéeɓ ɗúmëꞌ légéyírí boffon⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","añcaŋ ɗi nofaꞌte soꞌ, loffe yínlí sëꞌ waal caak, ndaa Koope olsaay ri na mokil soꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Waali wonaa boffon biti júrí faana lahaꞌ geñe-geñe ɓéeɓ nay hene yínlí sëꞌ rëe, ndeŋi límú ɓéeɓ faana henaꞌ geñe-geñe. Ɗi ac wonil biti bi faana tap súul mbée naaꞌ ɓéeɓ nay hene yínlí sëꞌ rëe, ndeŋi límú ɓéeɓ faana tap súul mbée naaꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Koope daa ɓeyaꞌ júrí boffon ɗaaha onte soꞌ wa kat⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ndée na húmú lawantuu júrë bín fë rë, di filiɓ heeƴ, mi otte biti faanni sékéttë a kuuyya na húmú lawu ra henaꞌ geñe-geñe, tap naaꞌ mbée súul, mbée hena tipi-tipi. ");
INSERT INTO ndv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Filiɓ heeja, malaakii Koope dëekké sëꞌ won tih⁠ ⁠: “Yakop⁠ ⁠!” Mi won ɗi tih⁠ ⁠: “Yëew⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ɗi won soꞌ tih⁠ ⁠: “Ɓéyré afu fu olsoh⁠ ⁠: sékéttë a kuuyya na lawu ra ɓéeɓ, ƴee faanni wa geñe-geñe, ƴee tappe naaꞌ mbée súul, ƴee tipi-tipi. Bi ot mi iña paŋ ro Laban ra ɓéeɓ, daa tah mi henaꞌ ri ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Daa mi Koope fa feeñiyoh ro Betel ra, tígë húmú yípëꞌ fu laꞌi tíinndëe, fu túmpé dúuléen sun, fu añohte fu yeɗte soꞌ na unu ra. Kolee gini bee leegi, fu nimil ɓëy faamon na gin ron.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rasel a Leyaa wonu Yakop tih⁠ ⁠: «⁠ ⁠Fun lahluy lam faam boffi fun. ");
INSERT INTO ndv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ɗi habaay fun haneel, níi ri yaayte fun antee ñam júrë túmú fun ra woo⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kon alal ma naaf Koope ɗii na ra ɓéeɓ, ƴi funi koyyi fun⁠ ⁠! Fu mín paŋ yee nah ro Koope ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakop kolaꞌ daaha, yëegíɗté koyyi a ɓeleɓɓi sun fi géléemmë. ");
INSERT INTO ndv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ɗi kúrëelëhté yuppi a iña lahaꞌ ri Mesopotami ra ɓéeɓ, ɓeɓpe waali Kanaan, na saañ faam Isaak boffi. ");
INSERT INTO ndv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Bi ɗeef Laban húmú saañce ëylí fënúffí harri, Rasel ñeyaꞌte ri filoon, lohte iña na haanaꞌ boffa ra. ");
INSERT INTO ndv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakop nofaꞌte Laban Arameyeŋa, lohohte saañce takaay ri. ");
INSERT INTO ndv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ɗi hegohte a iña lahaꞌ ri ra ɓéeɓ, yíppée húus laahi Efarat, yulohte waal daŋŋi Galaat. ");
INSERT INTO ndv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Waali éeyë fë tíkëh në rë, Laban kelohte biti Yakop hegohte. ");
INSERT INTO ndv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban ɓeɓpe i ow faami, wa suute daɓaadi Yakop⁠ ⁠; wa tílúté waal paana, wa na anuu rii daɓ daŋŋi Galaat. ");
INSERT INTO ndv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ndaa Koope feeñiyohte Laban elgin di filiɓ heeƴ, won ɗi tih⁠ ⁠: «⁠ ⁠Laban⁠ ⁠! Mi henaꞌ ro⁠ ⁠: lah yúhé ɗee nay fuu wonee a Yakop ra déꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Daɓaꞌ Laban Yakop ra, ɗeef ɗi yíppé taanta yi daŋŋi Galaat daaha. Laban a ɓëewí yípúté ƴi wa ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban dëekké Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Fu yúh yee paŋ fu ra saa ɗo⁠ ⁠? Haalaꞌ yi níi fu na nofaꞌ soꞌ, fu na kúrëelëh koyyi soꞌ ti ɓëewí habuu haaꞌ nen⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Haalaꞌ yi níi fu na nofaꞌ soꞌ, faa lohoh saañu⁠ ⁠? Fu takoh soꞌ koon, may roo ɓedaaloh a njooɓ, ñéerëꞌ a aa-síkë a koraa. ");
INSERT INTO ndv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Fu onay soꞌ sah mi langaamoh sun fi koyyi soꞌ a séttí sëꞌ, mi pëkís wë balaa wa saañ⁠ ⁠! Yee paŋ fu ra pagaɗ ow neh kat⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mi mín roo paŋ yin ɓos koon, ndaa Koope fa na jaamiyoh boffu ra won soꞌ níimmbë ti di filiɓ heeƴ, lah mi yúhë ɗee nay mi roo wonee ra. ");
INSERT INTO ndv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mi yúhté biti saañu ɓéeɓ, fu sesoh lahi faamon. Ndaa haalaꞌ yi níi faa loh haanaa yi soꞌ nék⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakop won Laban tih⁠ ⁠: «⁠ ⁠Mi neeh biti koon kat fu naaf koyyu ɓeleɓ daa tah mi lohoh saañi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yii leŋke haanaa yu na, fu ot wa ow na di ɓëewí sëꞌ në rëe, ɓëyí baa hawun húl. Saame filiɓ iña lahaꞌ mi ra ɓéeɓ fíi ɓëewí yen. Fu ot na yii daa fu lahaꞌ ri raa, fu ɓeɓ ri.⁠ ⁠» Di filiɓ ƴaaha ɓéeɓ nék, Yakop húmú yéeh biti koon Rasel daa loh haanaa ya. ");
INSERT INTO ndv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban yampe saama, haalte taantii Yakop ɗúhté, haalte bi Leyaa ɗúhté dah, haalte bi súrgë yí ana ya ɓeleɓ, ndaa ri olay yin. Ɗi míllëꞌ haal bi Rasel, ");
INSERT INTO ndv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ɗeef Rasel daa húmú ɓeɓ haanaa ya, ɗappe wa fëgërëh tek géléem, tookke sun. Laban saampe taantaa ɓéeɓ, ndaa ri olay yin. ");
INSERT INTO ndv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasel won boffi daaha tih⁠ ⁠: «⁠ ⁠Baap⁠ ⁠! Ngana habaꞌ soꞌ ri déꞌ⁠ ⁠! Biti mi ot hos daa tah mi kolaay haalaꞌ fu ra.⁠ ⁠» Laban ɓaattee saam, ndaa ri olay haanaa ya. ");
INSERT INTO ndv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tígí daaha, Yakop yíppée haayloh, yíssëhté sun fi Laban na ɗaañnjoh afa won tih⁠ ⁠: «⁠ ⁠Teeɓ soꞌ yii ɓosa paŋ mi ra leegi⁠ ⁠! Mi tooñaꞌ ro yi níi fu na daɓaat soꞌ ɗeeha⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Lahay tígí fu ɓekay ri yaꞌu di iña lahaꞌ mi ra ɓéeɓ⁠ ⁠; fu otte na yii ɗúhëꞌ faamu a⁠ ⁠? Teeɓe ri ɓëewú a ƴi soꞌ deh, wa aattiyaꞌ yen. ");
INSERT INTO ndv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Mi hompe kíil sabay ana (20) faamu, mi na légéyíɗ ɗë, te har mbée peꞌ mësëy ɓúlúk yaꞌ soꞌ, te mi ñëmrëy kuuy yubu. ");
INSERT INTO ndv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mi këmɗëy rë ɓúudé peꞌ mbée har fi tílé daa hap ri. Lahan ri faraah, mi yíníl rë rí. Júrí lohu naꞌ mbée elek ɓéeɓ, fu pegohte soꞌ ri. ");
INSERT INTO ndv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Koo yíil rëe, naꞌ ayee soo hap⁠ ⁠! Elga lah raa, sos kaaꞌ soꞌ mi neeꞌ pëní⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Mi homaꞌte ri ɗaaha kíil sabay ana (20) faamu⁠ ⁠: mi légéyíɗté rë kíil sabboo a kíil iniil koodi koyyi ana yu ɓeleɓ, kíillí pëenë yë tíkëh në rë, mi lahaꞌ júr në. Fu loffe iña wonantuu yen ra waal caak⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Henay Koope fa na jaamiyuu baasoꞌ Isaak a cissoꞌ Abraham te na saakil faan ɗi fi Isaak ra koon moos, tin fay soo yeris mi sayaꞌ yaꞌ holoŋ. Ndaa Koope otte súfúñ fí sëꞌ a mogi soꞌ, daa tah ɗi sëmlëꞌ sëꞌ níimmbë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban tahte won Yakop tih⁠ ⁠: «⁠ ⁠Tuŋki ɓeleɓɓi ƴee koyyi soꞌ. Koyyi wa ƴi soꞌ. Yuppa a iña na ot fu ƴee ra ɓéeɓ daa mi lahaꞌ wa. Ndaa dalaꞌte woteh, koyyi soꞌ ɓeleɓ a koyya límú wë rë, mi mínlíléh wëe pagiɗ yin. ");
INSERT INTO ndv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kon aye leegi yen gapantaꞌ yen ana, te yen añoh ri, yen saam seedii nay yen nérsé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tígí daaha, Yakop ɓeɓpe laꞌ, yíppé rí tíinndëe. ");
INSERT INTO ndv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ɗi antee nah ɓëewí píi laꞌ. Ɓëewë píyúté laꞌ fa, juukute wa ílíƴ yínë, wa ɓéeɓ ñamuu hëbís juugi laꞌ fa. ");
INSERT INTO ndv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban yeɗte tígí daaha tii Yegar Sahaduta (daa ri⁠ ⁠: juugi laꞌ fi seedaa)⁠ ⁠; ndaa Yakop yeɗ ri tii Galet. ");
INSERT INTO ndv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban won tih⁠ ⁠: «⁠ ⁠Dalaꞌte woteh, juugi laꞌ fi ƴee daa seedii yee gapantuu yen hanndal ki yen ra.⁠ ⁠» Yii baa daa tah tígí daa na wonuu Galet (daa ri⁠ ⁠: juugi laꞌ fi seedaa di ébrë). ");
INSERT INTO ndv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Tígë në wonuu Mispaa ɓal (daa ri⁠ ⁠: ílíƴ wohaa), af biti Laban ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗémíin Koo-Yahwee yeela yen na biti yen ëlëntíih⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Fu mokil koyyi soꞌ ɓeleɓ mbée fu kooɗ ɓeleɓ kay, lah yúhé biti Koope nay yen aattiyee ndaa ow kay neh⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Olsee juugi laꞌ fi bee a laꞌa yíp mí hanndal ki yen ra. ");
INSERT INTO ndv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Juugi laꞌ fa a laꞌa yípú bee ra daa nay hene seedaa hanndal ki yen⁠ ⁠: mi waray rii ƴégítëh mi yuloh ɗoo na a nuf ɓos⁠ ⁠; ɗo ɓal fu waray rii ƴégítëh fu yuloh soo na a nuf ɓos. ");
INSERT INTO ndv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ɗémíin Koope fa na húmú jaamiyoh Abraham ra, ɗi fa na húmú jaamiyoh Nahoor ra aattiyaꞌ yen⁠ ⁠!⁠ ⁠» Tígí daaha, Yakop añohte di tii Koope fa na húmú saakil faan Isaak boffi ra. ");
INSERT INTO ndv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ɗi antee hawiɗ Koope sun fi daŋa daaha, dëekké ɓëewë húmú në rë ñam. Ñamuu wa níi wocute ra, wa neeꞌu sun fi daŋa daaha. ");
INSERT INTO ndv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kéy ɓaaɓ fin cúɓ Laban kolohte, langaamohte koyyi ɓeleɓ a séttí, ɗagiɗte wa, antee saañ nimilte gin wa. ");
INSERT INTO ndv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakop ɓeyaatte waali na saañ. Lahte malaaka yi Koope ƴi ayute téebílëhí. ");
INSERT INTO ndv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Olaꞌ wa Yakop ra, ɗi tahte won tih⁠ ⁠: «⁠ ⁠Bee dali Koope kan⁠ ⁠!⁠ ⁠» Ɗi dëekëꞌté tígë Mahanayim (daa ri⁠ ⁠: dalli ana ya). ");
INSERT INTO ndv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakop antee yeñ i ndiik Esawuu koy-yaafi na, di deyi Edom fin gini Séyíir. ");
INSERT INTO ndv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Lah wëní Esawuu biti soꞌ mi Yakop súrgíi, mi húmú saañ ɓaaɓ faam Laban, te mi húmú në níi a ɗeh. ");
INSERT INTO ndv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Wëní rí biti mi lahte i fana a i mbaam, i har a i peꞌ, i súrgë ƴaal a ɓeleɓ. Lah wëní rí biti ɓal mi wolaꞌ ɗi fi kélfíi sëꞌ në ɗi teeɓu iñƴaaha, nda ɗi mín sëe tahaꞌ a yaꞌ ana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ndiikka payute, ayute wonu Yakop tih⁠ ⁠: «⁠ ⁠Fun léhínúté koy-yaafu Esawuu. Ɗi ee ac téebílëhú rë, ñéerëꞌté a ow tíméer iniil (400).⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kelaꞌ Yakop woni baa ra, ɗi tíit tíitë níi faana ɓéeɓ na saak. Ɗi ɗaralsaꞌte ɓëewí goomal ana, hente harra, peꞌ ya, fañnja a géléemmë ɗaaha ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakop won nufi daaha tih⁠ ⁠: «⁠ ⁠Esawuu yejoh haaꞌ goomal yínë rëe, yínëe ay mín hegoh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yakop antee yefoh ɗaŋ won tih⁠ ⁠: «⁠ ⁠Ɗo fi Koope fa na jaamiyuu cissoꞌ Abraham a baasoꞌ Isaak ra, ɗo fi Koo-Yahwee fa túuƴ sëꞌ nimil faam di gin fun, te fu won ti fay soo pagiɗ yin wun ra, ");
INSERT INTO ndv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","mi caleh naaꞌi-keeña teeɓ fu soꞌ ra ɓéeɓ a yeɗɗaya yeɗɗay fu soꞌ, soꞌ mi súrgúu rë. Mi húmú lahaꞌ duudi soꞌ kut yaꞌ soꞌ na húus mí laahi Yurdeŋ ra, ndaa mi nimilaꞌ a goomal ana woteh. ");
INSERT INTO ndv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Sëmlëꞌ sëꞌ yaꞌ ɓahii soꞌ Esawuu, ndah mi kaañay ri⁠ ⁠; te mi neehte biti ɗi ac boollaꞌ funi ɓeleɓɓa a tuŋka ɓéeɓ bëem fun. ");
INSERT INTO ndv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nérsée biti daa fu húmú won soꞌ tih⁠ ⁠: May roo pagiɗ yii wunte níi wun, mi paŋ níi talu gaan, séttú caak níi caak ti peppi feey fa tíñ kísí nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ɗagaꞌ Yakop níi wocce ra, ɗi neeꞌ tígí daaha yiin fa. Ladaꞌ Koo ra, ɗi tansiɗte Esawuu ɓahii yoobbol, di júrë lahaꞌ ri ra⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","hente peꞌ ɓeleɓ tíméer ana (200) a sékét sabay ana (20), har ɓeleɓ tíméer ana (200) a kuuy sabay ana (20), ");
INSERT INTO ndv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","géléem sabay éeyë (30) yí homu ɓëpíɗ a koyyi wa, fana ɓeleɓ sabay iniil (40) a naal sabboo, mbaam ɓeleɓ sabay ana (20) a mbaam ƴaal sabboo. ");
INSERT INTO ndv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ɗi tíkké yuppa, bina-bina ɓéeɓ yaꞌ súrgë yí kayaꞌ-kayaꞌ, antee waa won tih⁠ ⁠: «⁠ ⁠Ɗon ay soo këllée këllëe, ɗon hanndalaꞌ yuppa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ɗi won súrgëe nay këllée rë tih⁠ ⁠: «⁠ ⁠Fu teeꞌaꞌ a ɓahii soꞌ Esawuu níi ri meel ro kélfúu, mbée tígë në saañ fu ra, mbée ɓëeꞌ lahaꞌ yuba këllíɗ fú rëe, ");
INSERT INTO ndv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","lah wone ri tih⁠ ⁠: “Ɓahaa, súrgúu Yakop daa kélfíi sëꞌ⁠ ⁠; daa ri kéyrëꞌ rë yubi bee yoobbol, te ri ee ac filoon ra.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Yakop wonte unni ƴaa súrgëe ñee na ra, wonte waa bee tíkëh në rë ɓal, a ƴee yuppa tíkú yaꞌ yi wa ra ɓéeɓ, antee ɓaat won wa tih⁠ ⁠: «⁠ ⁠Ɗoni Esawuu teeꞌaꞌ raa, lah wëníi rí ɗaaha, ");
INSERT INTO ndv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","te ɗon ɓaat ɗii won biti Yakop súrgíi ee ac filoon ra.⁠ ⁠» Yakop habaꞌ nufi biti ɗi këllíɗ yoobbola raa, keeñ Esawuu mín yëellëh. Hen ɗaaha raa, Esawuu mín ríi téebílëꞌ wun. ");
INSERT INTO ndv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ɗaaha, yuppa yeraꞌ ri yoobbol ra këllúuté rí, ndaa ɗi fi bah, ɗi neeꞌ dala daaha elgi baaha. ");
INSERT INTO ndv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","24","Filiɓ elga, Yakop kolohte ɓeɓpe ɓeleɓɓi ana yi a súrgë yí wë, Bilhaa a Silpaa, a koyyi sabboo a yínë yí, húusíɗté wë laahi Yabbok a iña lahaꞌ ri ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Gétúu wë rë, Yakop a afi kut tasute daaha. Ow haalohte ri bërëꞌ daaha, wa neeꞌute bërëꞌ níi miir-miirin. ");
INSERT INTO ndv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yúhëꞌ ɓëeꞌ biti ɗi mínéh faas Yakop ra, ɗi laɓ ri laɓo poogal, muguƴce legeƴa, ");
INSERT INTO ndv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","antee ri won tih⁠ ⁠: «⁠ ⁠Yeris soꞌ mi saañ, Koo ee saañ lade ra⁠ ⁠!⁠ ⁠» Ndaa Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Mii roo yeris fu saañ te fu barkeleh soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ɓëeꞌ meelte ri won tih⁠ ⁠: «⁠ ⁠Fu hínú ɗíh paaƴ⁠ ⁠?⁠ ⁠» Ɗi tahte won tih⁠ ⁠: «⁠ ⁠Mi hínú Yakop.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ɓëeꞌ ɓaatte won tih⁠ ⁠: «⁠ ⁠Fii dëeklúu Yakop⁠ ⁠; dalaꞌte woteh, fay dëekúu Israyel (daa ri⁠ ⁠: bërëꞌ a Koo), af biti fu tíkëꞌté Koope a ɓëewë af, te daa fu ɓaŋ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakop meelte ri won tih⁠ ⁠: «⁠ ⁠Teeɓ soꞌ tiyu hém neɓaꞌ ro.⁠ ⁠» Ɓëeꞌ won ɗi tih⁠ ⁠: «⁠ ⁠Fay pagee tii soꞌ yih⁠ ⁠?⁠ ⁠» Tígí daaha, ɓëeꞌ barkelte ri. ");
INSERT INTO ndv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakop antee won tih⁠ ⁠: «⁠ ⁠Mi tíkké Koo íl ngëeƴ te yin katay soꞌ⁠ ⁠!⁠ ⁠» Yii baa daa tah Yakop yeɗ tígí daa tii Penuwel (daa ri⁠ ⁠: kanam Koo). ");
INSERT INTO ndv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Lani Koo ɗeef Yakop húussé tígë lukki teeƴ laaha ra di Penuwel, ɗi na yíiɓ af muguƴohi legeƴa. ");
INSERT INTO ndv_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Yii baa daa tah níi a woteh, ɓëy Israyel na ñëmíh boꞌ poogal, ndah biti Yakop húmú laɓu poogal. ");
INSERT INTO ndv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Ɓéyrëꞌ Yakop afi, ɗi séenté Esawuu na ac, ñéerëꞌté a ow tíméer iniil (400). Tígí daaha, ɗi woralsaꞌte tuŋka yaayyi wa na⁠ ⁠: ɗi këllíɗté Bilhaa a Silpaa a koyyi wa, Leyaa a ƴii tíkúuté në, Rasel a Suseef míllúuté. ");
INSERT INTO ndv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ɗi fi Yakop daa këllëh, sígímpé níi feey, na tíl na sígím níi hente waal paana, na teeꞌuu ɓani koy-yaafi ra. ");
INSERT INTO ndv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esawuu téebílëhté rí a múkë, langaamohte lúumë ngufkalte ri, wa ɓéeɓ ana na looyu. ");
INSERT INTO ndv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Olaꞌ Esawuu ɓeleɓɓa a tuŋka ra, ɗi won tih⁠ ⁠: «⁠ ⁠Ɓëewë ɗoni wa ñéerúu ƴee ra i wa koy-yaasoꞌ⁠ ⁠?⁠ ⁠» Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Ƴee koyya on soꞌ Koo ra, ɓahaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Bilhaa a Silpaa a koyyi wa leɓuute, ƴekute, sígímúté níi feey. ");
INSERT INTO ndv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leyaa a koyyi tíkúuté në, sígímúté, Suseef a Rasel ayute, henute ɗaaha ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawuu meelte ri won tih⁠ ⁠: «⁠ ⁠Fu húmú fahaꞌ paŋ yi a yuba teeꞌaꞌ mi ra koy-yaasoꞌ⁠ ⁠?⁠ ⁠» Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Baa yoobbola kom mi ro ra ɓahaa, nda fu mín sëe teeɓ naaꞌ-keeñ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esawuu tahte won tih⁠ ⁠: «⁠ ⁠Alal ma lahaꞌ mi ra doyte soꞌ sëk koy-yaasoꞌ, habe ƴuu ɗoo na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakop won tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ⁠ ⁠! Daa mi ɗaŋ ɗo ri. Tahe yoobbola, hena biti fu habray soꞌ yin keeñu. Teyaꞌi yen, man biti funi Koope daa teeꞌuu nen, ndah fu teeɓpe soꞌ naaꞌ-keeñ. ");
INSERT INTO ndv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kon mi ɗaŋ ro biti fu tah yoobbola kéyrëꞌ mí rë rë, ndée Koope yeɗɗay soꞌ, tahte níi mi caakke yin.⁠ ⁠» Yakop cagohte Esawuu níi ɗi míllëꞌtée tah. ");
INSERT INTO ndv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hompe níi Esawuu won ɗi tih⁠ ⁠: «⁠ ⁠Kolee leegi yen ñéerëꞌ, yen saañ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ndaa Yakop won ɗi tih⁠ ⁠: «⁠ ⁠Ay sayu sah, ndaa ɓahaa, fu yúhté biti tuŋka maanuy. Te mi kúɗté i har, peꞌ a fana ɓeleɓɓi homu ɓëpíɗ⁠ ⁠; yen tíl tílí gaawte waal yínë kut, wa ɓéeɓ ay húl. ");
INSERT INTO ndv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kon këllëh sëꞌ ɓahaa⁠ ⁠! Soꞌ mi beh, lah raa funi tuŋka a yuba tíl ndaŋ, níi bín ɗeefraa mi ro Séyíir rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawuu won ɗi tih⁠ ⁠: «⁠ ⁠Caa mi heliɗ ɗo i ow di ɓëewí sëꞌ book⁠ ⁠!⁠ ⁠» Yakop tahte won tih⁠ ⁠: «⁠ ⁠Miteh ri ɓahaa⁠ ⁠! Na fu sehaa soꞌ keeñi naaꞌte kut doyte soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Yiin fa Esawuu ɓeyaatte waali Séyíir. ");
INSERT INTO ndv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ndaa Yakop ɓeɓ waali Sukot. Lahaꞌ ri ra, ɗi yíppé faami, mbaariɗte yuppi. Mbaarri ƴaa daa tah tígí daa na wonuu Sukot (daa ri⁠ ⁠: mbaarra). ");
INSERT INTO ndv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakop lahte Sihem di gini Kanaan a sos-faan. Waala kolaꞌ ri Mesopotami ra ɗúmëꞌ daaha. Lahaꞌ ɗi ra, ɗi yíp taanta yi hëbís gina. ");
INSERT INTO ndv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ɗi antee lom feey fa yípëꞌ rí taanta yi ra séttí Hamoor na, bee yíp gini Sihem ra. Ɗi lomaꞌ feey fa hanjar tíméer (100). ");
INSERT INTO ndv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ɗi yíppé ílíƴ hawraa daaha, yeɗte ri tii El Elohee Israyel (daa ri⁠ ⁠: El daa Koope fi Israyel). ");
INSERT INTO ndv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lahte bis, Dinaa koy ki ɓelaa lahuu Yakop a Leyaa ra kolohte wodohi tuŋki cafaƴƴa gina. ");
INSERT INTO ndv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hamoor, Híwë ílíf deyi baa ra, lahte koy ki ƴaali hínú Sihem. Olaꞌ Sihem Dinaa ra, ɗi kúɗté rí faam, fanohte a ri, kompe ri gace. ");
INSERT INTO ndv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ndaa ri pokohte Dinaa na níi pokoh, fahaꞌte ri keeñi níi, míllëꞌtée ríi gémlëh. ");
INSERT INTO ndv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ɗi payte, won boffi tih⁠ ⁠: «⁠ ⁠Paye fu ɗagiɗ soꞌ kúkëyí cafaƴ ki bee ɓeleɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ɗeef Yakop húmú kelohte biti Dinaa koohi komute gace. Ndaa bi húmú koyyi ƴaalli luufa a yuppi, ɗi pagay yin, na seh ayi wa. ");
INSERT INTO ndv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamoor boffi Sihem, fahaꞌ goneel a Yakop, kolohte ɗeefri faam. ");
INSERT INTO ndv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ɗúhúu koyyi Yakop luufin ayute ra, wa keluute yee lah ra. Keeññi wa haayte yaa níi haay, wa habuute ri solaꞌ, biti Sihem paŋke yii keeñ mínéh rí tah di Israyel, débë dép rí Dinaa na ra. Yii baa pagaɗ ow neh⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ndaa lahaꞌ Hamoor ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Koy soꞌ Sihem fahaꞌ koohon ɓeleɓ, mi ɗaŋ biti koon ɗon on ɗi ri ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ñéeríi a fun, yen ham yin yínë⁠ ⁠: ëní koyyi fun tuŋki cafaƴƴon, wa ɓeɓ wa ɓeleɓ⁠ ⁠; fun on koyyi ron tuŋki cafaƴƴi fun ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ɗon ay mín dék fun na deh, ɗon yíp në faammon, ɗon tíl kotton, ɗon lah na feey.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ɗi fi Sihem acce won boffi cafaƴ ka a koy-baappa tih⁠ ⁠: «⁠ ⁠Ɗon tahiɗ soꞌ yii nebi baa raa, yii meel ron soꞌ ɓéeɓ may ron rii yeɗ⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","di míntí teem júrë a yii tíkëh në ɓéeɓ. May yeraꞌ yii meelaꞌ ron ɓéeɓ⁠ ⁠; na ron on soꞌ cafaƴ ka ɓeleɓ kut.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Koma kom Sihem koy-boffi wa Dinaa gace ra, tahte níi koyyi Yakop nofuute Sihem a Hamoor na lofu wa ra, ");
INSERT INTO ndv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","wonu wa tih⁠ ⁠: «⁠ ⁠Fun míníh on koy-boffi fun ɓëyí lecuy⁠ ⁠; tin hena gace gaan fun na. ");
INSERT INTO ndv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Fun ay ron tahree biti kut, ƴaalla ginon ɓéeɓ lecoh ti fun nen. ");
INSERT INTO ndv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Tígí daaha, fun ay ron on koyyi fun ɓeleɓ, fun ɓeɓ ƴi ron ɓeleɓ, yen bok yen dék, gina hen yínë. ");
INSERT INTO ndv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ndaa ron tahuy lecoh raa, fun ay ɓeɓ koy-boffi fun, fun saañ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamoor a Sihem koohi tahute yee wonu wa ra. ");
INSERT INTO ndv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Fahaꞌa fahaꞌ Sihem cafaƴ ka ra, tahte níi ɗi cagaalaay paŋi yee nahuu ra. Bi húmú lah ri un faam boffi, ");
INSERT INTO ndv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ɓani boffa ɗeefrute ɓëewë këemë, wonu wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«⁠ ⁠Ɓëewí ƴee lahuu nufi wunte yen na. Wa dékún gin yen deh, te wa tíl në kotti wa⁠ ⁠; gina abee hëréet⁠ ⁠! Yen ay mín ɓeɓ koyyi wa ɓeleɓ, wa kooɗ ƴi yen. ");
INSERT INTO ndv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Wa ay tah dék a yen, gina hen yínë, biti kut ƴaalla gin yen ɓéeɓ tah lecoh ti wa nen. ");
INSERT INTO ndv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Yen tah woni wa raa, wa ay ac dék yen na deh⁠ ⁠; tígí daaha, yuppi wa a alal mi wa ɓéeɓ ay míllëꞌ hen ƴi yen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ɓëewë húmú këemë rë ɓéeɓ, tahuu woni Hamoor a koohi Sihem ɗaaha, ƴaalla gina ɓéeɓ yípútée lecoh. ");
INSERT INTO ndv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Waali éeyë fë, ɗeef misigi leja líssí ham ɓëewë, koy ƴaal ana di koyyi Yakop, Simewoŋ a Léwí koy-yaayyi Dinaa ɓeyute jépíllí wë, haalute gina te ow fookay nufa tíɓú wë rë, hawute ƴaalla ɓéeɓ húl, ");
INSERT INTO ndv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","níi lukaꞌ Hamoor a koohi Sihem. Na ɗúhú wë faam Sihem ra, wa ɓeyaaluute Dinaa, kúrëelúuté rí. ");
INSERT INTO ndv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Gacaa komu koy-boffi wa ɓeleɓ ra, tahte níi koyyi ƴaalli kayyi Yakop yabute sun fi ɓúudé yë na ɓeyu iña faanni wa, wa haalute gina na saamu⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","wa pëkísúté harra a peꞌ ya, fañnja a mbaamma, kúrúté wë. Wa heluy yin di yii hompe gina a meeyya. ");
INSERT INTO ndv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wa haalute faamma gina ɓéeɓ, kúrëelúuté tuŋka a ɓeleɓɓa. Alal ma gina ɓéeɓ, wa kúrúté wë. ");
INSERT INTO ndv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tígí daaha, Yakop won Simewoŋ a Léwí tih⁠ ⁠: «⁠ ⁠Ɗon komute soꞌ kofeel⁠ ⁠; ɗon tahute níi ɓëy Kanaan a Péríssë dékú gini bee ra ay soo olaꞌ íl ɓos. Wa lúuk sëꞌ rëe te ɓëewí sëꞌ caakuy, wa ay soo ɓaŋ, hap funi ɓëy faam soꞌ ɓéeɓ húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Simewoŋ a Léwí wonu boffi wa tih⁠ ⁠: «⁠ ⁠Fun míníh yeris ow habee koy-yaafi fun ɓeleɓ tílëh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hompe níi Koo won Yakop tih⁠ ⁠: «⁠ ⁠Kolee fu saañ Betel fu yíp taanta yu dín fë. Lah yípíɗ sëꞌ ílíƴ hawraa tígë húmú feeñiyaꞌ mi ro ra, na hegoh fu koy-yaafu Esawuu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tígí daaha, Yakop won ɓëy faami a ɓëewí kayya homu yaꞌi ra tih⁠ ⁠: «⁠ ⁠Bétí iñi haanaa ya filiɓ fi ron, ɗon ɓukutoh níi ron lan, ɗon lofoh búuɓ, ");
INSERT INTO ndv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ɗon koloh yen saañ Betel. May naa yípíɗ Koope ílíƴ hawraa⁠ ⁠; Koope fa sëmlëꞌ sëꞌ loocaꞌ mi ra, te níiɗ sëꞌ waali soꞌ ɓéeɓ rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Wa yerute Yakop iñi haanaa ya lahuu wa ra ɓéeɓ níi lukaꞌ loŋ-loŋŋa húmú nuffi wa ra⁠ ⁠; Yakop hacce wa ɓéeɓ tal kilki gaana hom hëbís Sihem ra. ");
INSERT INTO ndv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Koluu Yakop a ɓëewí daaha ra, Koope tíitíɗté ɓëewë dékú ginna leɓuu wa ra, tahte níi ow daɓaatay wa. ");
INSERT INTO ndv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakop a ɓëewí ɓéeɓ na suu níi lahute Lúus di Kanaan. Lúus daa Betel fee woteh. ");
INSERT INTO ndv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakop tíkëlsëꞌté i laꞌ daaha, yíppé ílíƴ hawraa, dëekëꞌté rí El Betel (daa ri⁠ ⁠: Koope fi Betel), biti Koope húmú feeñiyaꞌ ri daaha na hegoh ri koy-yaafi ra. ");
INSERT INTO ndv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deboraa, ɓelaa koɗ Rebekaa ra húlëꞌ daaha, hacute tal kilki gaana hom hëbís Betel ra. Dalaꞌte bín fë, tal kilki baa wonuu «⁠ ⁠kilki pasooɓ fa⁠ ⁠». ");
INSERT INTO ndv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kolaꞌ Yakop Mesopotami acce Betel ra, Koope feeñiyaatte ri daaha, barkelte ri ");
INSERT INTO ndv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","won ɗi tih⁠ ⁠: «⁠ ⁠Fu hínú Yakop ndaa fii dëeklúu ɗaaha. Dalaꞌte woteh fay hínú Israyel.⁠ ⁠» Koo yeraꞌ ri tii Israyel ɗaaha, ");
INSERT INTO ndv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ɓaatte won tih⁠ ⁠: «⁠ ⁠Daa mi Koope fa mín ɓéeɓ rë. May paŋ níi fu keñ, fu lah i sét caak. Tal gaan a goomal i tal ay coosaanaꞌ ɗoo na. Talu ay ɗúhíɗ i buur. ");
INSERT INTO ndv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Gina húmú gap mi Abraham a Isaak ra, mi onte ro ri woteh, te filoon fu, may rii one ɓëy talu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Koope antee koloh Yakop na daaha, tígë wonaꞌ ri ɗii na ra, nimilte sun. ");
INSERT INTO ndv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakop yíppé laꞌ tígí daaha, túmpé në dúuléen a béeñ, na seeƴoh ri ra. ");
INSERT INTO ndv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ɗi antee yeɗ tígë wonaꞌ Koope ɗii na ra tii Betel (daa ri⁠ ⁠: Faam Koo). ");
INSERT INTO ndv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakop a ɓëy faami koluute Betel na suu. Tílúu wë níi wa leɓuute Efarataa ra, Rasel lahte koy. Na ɓësíl rí rë, lowa kofeelte níi kofeel. ");
INSERT INTO ndv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Bi kofeel ɓëslë níi, ɓelaa na múcël rë won ɗi tih⁠ ⁠: «⁠ ⁠Híinndée déꞌ⁠ ⁠! Híinndée noo koy-yaay, koy ƴaal daa ayil⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ndaa bi hom Rasel kotti kúl kë, na lús rí rë, ɗi yeɗte koy ka tii Ben-Oni (daa ri⁠ ⁠: koy ki coono fi soꞌ)⁠ ⁠; ndaa boffa yeɗ ri tii Beŋsame (daa ri⁠ ⁠: koy ki yaꞌi ñamaa fa). ");
INSERT INTO ndv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Húlëꞌ Rasel ra, ɗi hacuu ɓúk waali Efarataa daaha, na wonuu Betleꞌem woteh ra. ");
INSERT INTO ndv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakop yíppé laꞌ tíinndëe sun fi luuyi Rasel⁠ ⁠; níi a woteh, tíinndëe wonuu laꞌi luuyi Rasel. ");
INSERT INTO ndv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yakop saañce yíppé taanta yi énfí Migdal-Eder. ");
INSERT INTO ndv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Homaꞌ Yakop deyi baaha ra, Ruben payte fanohte a Bilhaa, ow di ɓeleɓɓi boffi. Wona lahte boffa na. Yakop húmú lahaꞌ koy ƴaal sabboo a koy ƴaal ana. ");
INSERT INTO ndv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Koyyi Leyaa daa wa ƴeh⁠ ⁠: Ruben saawa, Simewoŋ, Léwí, Yudaa, Isakaar a Sabuloŋ. ");
INSERT INTO ndv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ƴee daa koyyi Rasel⁠ ⁠: Suseef a Beŋsame. ");
INSERT INTO ndv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ƴee daa koyyi Bilhaa súrgíi Rasel⁠ ⁠: Dan a Neftali. ");
INSERT INTO ndv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ƴee daa koyyi Silpaa súrgíi Leyaa⁠ ⁠: Gaat a Aseer. Ƴaa daa koyyi ƴaalla lahaꞌ Yakop Mesopotami ra. ");
INSERT INTO ndv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakop nimilte Isaak boffi na di Mamre, hëbís Kiriyat-Arba fa na wonuu Heboron woteh ra. Abraham dékíɗté në na ac Isaak daaha ra. ");
INSERT INTO ndv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaak lahaꞌ kíil tíméer a kíil sabay peeye (180) ");
INSERT INTO ndv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","na húl rí rë. Ɗi ɓahate níi paangaawte na ɗeefiɗ ri caacci ɓúudé rë⁠ ⁠; koyyi, Esawuu a Yakop hacute ri. ");
INSERT INTO ndv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ƴee daa tii yi ɓëy faam Esawuu fa na wonuu Edom ra. ");
INSERT INTO ndv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawuu kooɗ ɓeleɓ éeyë yí dékú Kanaan⁠ ⁠: Aada fi Elon Heda⁠ ⁠; Oholibama koy Ana fi Sibewoŋ Híwë⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","a Basmat koy-yaafi Nebayot fi Ismayel. ");
INSERT INTO ndv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esawuu a Aada lahute Elifas⁠ ⁠; ɓani Basmat lahute Rewel⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ɓani Oholibama lahute Yéwús, Yelam a Korah. Koyyi ƴaalla lahaꞌ Esawuu Kanaan ra, daa wa ƴah. ");
INSERT INTO ndv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esawuu kolaꞌ dah, ɓeɓpe ɓeleɓɓi, koyyi ƴaal a koyyi ɓeleɓ a ɓëewë homu yaꞌi ra ɓéeɓ, ɗi kúrëelëhté yuppa a alal ma lahaꞌ ri Kanaan ra ɓéeɓ, saañce gin kay, wulohte Yakop koy-yaafi. ");
INSERT INTO ndv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Bi caaku wa alal níi caak, wa mínlíh dék ílíƴ yínë, gaani yuppi wa tahte deya homu wa ra doyeh wa. ");
INSERT INTO ndv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ɗaaha, Esawuu fa na wonuu Edom ra saañce yíppé faami daŋi Séyíir. ");
INSERT INTO ndv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ƴee daa tii yi ɓëy faam Esawuu, ciffi ɓëy Edomma húmú dékú daŋi Séyíir rë. ");
INSERT INTO ndv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Tii yi koyyi ƴaalla daa wa ƴeh⁠ ⁠: Elifas, koy Aada ɓeleɓ Esawuu, a Rewel koy Basmat ɓeleɓ Esawuu. ");
INSERT INTO ndv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ƴee daa koyyi ƴaalli Elifas⁠ ⁠: Teman, Omar, Sefo, Gaatam, Kenaas. ");
INSERT INTO ndv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifas a Timna ɓelii ƴutuudi lahute Amalek. Séttí Aada ɓeleɓ Esawuu, daa wa ƴah. ");
INSERT INTO ndv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ƴee daa koyyi ƴaalli Rewel⁠ ⁠: Nahat, Serah, Sammah a Misa. Séttí Basmat ɓeleɓ Esawuu, daa wa ƴah. ");
INSERT INTO ndv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ƴee daa koyyi ƴaalli Esawuu a Oholibama koy Ana fi Sibewoŋ⁠ ⁠: Yéwús, Yelam a Korah. ");
INSERT INTO ndv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ƴee daa kélfë yí talla faam Esawuu⁠ ⁠: koyyi ƴaalli Elifas, saawi Esawuu⁠ ⁠: Teman, Omar, Sefo, Kenaas, ");
INSERT INTO ndv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gaatam a Amalek. Koyyi Elifas fi Aada, ƴee henu kélfë tal Edom ra, daa wa ƴah. ");
INSERT INTO ndv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Koyyi ƴaalli Rewel fi Esawuu⁠ ⁠: Nahat, Serah, Sammah a Misa. Koyyi Rewel fi Basmat, ƴee henu kélfë tal Edom ra, daa wa ƴah. ");
INSERT INTO ndv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ƴee daa koyyi ƴaalli Esawuu a Oholibama fi Ana⁠ ⁠: Yéwús, Yelam a Korah. Koyyi Oholibama, ƴee henu kélfë tal ra, daa wa ƴah. ");
INSERT INTO ndv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ƴaa daa koyyi ƴaalli Esawuu, ƴee henu kélfë tal Edom ra. ");
INSERT INTO ndv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ƴee daa ɓëewí ƴaalla tali Séyíir Hora, ƴee ɗéɓúu dék Edom ra⁠ ⁠: Lotan, Sobal, Sibewoŋ, Ana, ");
INSERT INTO ndv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Etseer a Disan. Koyyi Séyíir Hora, ƴee henu kélfë tal Edom ra, daa wa ƴah. ");
INSERT INTO ndv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Koyyi ƴaalli Lotan daa Hori a Hemam. Koy-yaafi Lotan ɓeleɓ hínú Timna. ");
INSERT INTO ndv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ƴee daa koyyi ƴaalli Sobal⁠ ⁠: Alwan, Manahat, Ebal, Sefo a Onam. ");
INSERT INTO ndv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ƴee daa koyyi ƴaalli Sibewoŋ⁠ ⁠: Ayaa a Ana fa húmú ot cul muluɓ núgúyíɗ luufin na níiɗ rí mbaammi Sibewoŋ boffi ra. ");
INSERT INTO ndv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ƴee daa koyyi Ana⁠ ⁠: koohi ƴaal hínú Dison, koohi ɓeleɓ hínú Oholibama. ");
INSERT INTO ndv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ƴee daa koyyi ƴaalli Dison⁠ ⁠: Hemdan, Esban, Yitaran a Keran. ");
INSERT INTO ndv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ƴee daa koyyi ƴaalli Etseer⁠ ⁠: Bilhan, Saawan a Akan. ");
INSERT INTO ndv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ƴee daa koyyi ƴaalli Disan⁠ ⁠: Úus a Aran. ");
INSERT INTO ndv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ƴee daa kélfë yí talli Horra⁠ ⁠: Lotan, Sobal, Sibewoŋ, Ana, ");
INSERT INTO ndv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Etseer a Disan. Ƴaa daa kélfë yí talli Horra di Séyíir. ");
INSERT INTO ndv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Buurra ílífú gini Edom balaa ɓëy Israyel lah buur ra, daa wa ƴeh⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Belaa koy Bewoor héníɗté buuri Edom. Ɗi húmú dék Dinabaa. ");
INSERT INTO ndv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Húlëꞌ rí rë, Yobap koy Serah fi ɓëy Botsiraa daa took nguur ka. ");
INSERT INTO ndv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Húlëꞌ Yobap ra, Husam fi ɓëy Teman daa took nguur ka. ");
INSERT INTO ndv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Húlëꞌ Husam ra, Hadat koy Bedat daa took nguur ka. Ɗi húmú dék Awit. Daa ri ɓaŋ haaꞌi ɓani ɓëy Majaan di deyi Mohap. ");
INSERT INTO ndv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Húlëꞌ Hadat ra, Samla fi ɓëy Marsekaa daa took nguur ka. ");
INSERT INTO ndv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Húlëꞌ Samla ra, Sawul fi ɓëy Rehobot fa hom ɓúk laaha ra daa took nguur ka. ");
INSERT INTO ndv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Húlëꞌ Sawul ra, Baal-Hanan koy Akboor daa took nguur ka. ");
INSERT INTO ndv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Húlëꞌ Baal-Hanan koy Akboor ra, Hadar daa took nguur ka. Ɗi húmú dék Pawuu. Metabeel daa ɓeleɓi. Materet daa yaafi Metabeel, Mesahap daa yaafi Materet. ");
INSERT INTO ndv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Ƴee daa kélfë yí talla coosaanuu Esawuu na ra⁠ ⁠: Timna, Alwaa, Yetet, Oholibama, Elaa, Pinon, Kenaas, Teman, Mipsaar, Makdiyel, Iram. Ƴaa daa kélfë yí talla Edom. Ow fi ow waa na ɓéeɓ daa lahaꞌ deya dék ɗí rë. Ɓëy Edom coosaanuu Esawuu na. ");
INSERT INTO ndv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ɗi fi Yakop dékké Kanaan, tígë húmú boffi henaꞌ ri doha-ndéem gini baa ra. ");
INSERT INTO ndv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Bee daa naaɓii faam Yakop. Suseef koraꞌ leelii koy-baappi, koyyi Bilhaa a Silpaa ɓeleɓɓi boffi níi bee lahaꞌ ri kíil sabboo a kíil paana ra, wa na ñéerúu níiɗ peꞌ a har. Lahte bis, ɗi ɓílíɗté boffi iñi ɓossa na wonu sun fi wa ra. ");
INSERT INTO ndv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakop húmú lukki fahaꞌ Suseef di koyyi, biti ɗi lah ri ɓaha ki. Ɗi húmú saamiɗte ri búuɓ lémí. ");
INSERT INTO ndv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Koy-baappi oluu wa biti boffi wa lukki fahaꞌ ri filiɓ fi wa ɓéeɓ rë, ngaarute ri níi hanndal ki wa neɓlay. ");
INSERT INTO ndv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Bisa ín, Suseef heeƴce, ɓílíɗté koy-baappi, wa ɓaatuute rii ngaaɗ. ");
INSERT INTO ndv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Na ɓílíɗ ɗí rë, ɗi won wa tih⁠ ⁠: «⁠ ⁠Síkíríi, mi ɓílíɗ ɗon heeji soꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ëlsíi⁠ ⁠: yen húmú meey, yen na poku jaak. Jaagi soꞌ yíppée koloh caŋke, ƴi ron ayute ƴekute fíyí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Koy-baappi wonu ri tih⁠ ⁠: «⁠ ⁠Fu buur aa fu dak⁠ ⁠? Daa fu wah⁠ ⁠?⁠ ⁠» Wa ɓaatuute rii ngaaɗ di heeji a wonaɗɗi. ");
INSERT INTO ndv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ɗi heeƴilte, ɓílíɗté rí koy-baappi won tih⁠ ⁠: «⁠ ⁠Mi heeƴilte, mi otte naꞌa, céyín fë, a hul sabboo a hul yínë ƴekute fíi sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ɗi ɓílíɗ heeja boffi a koy-baappi⁠ ⁠; ndaa boffa na won afa tih⁠ ⁠: «⁠ ⁠Heejee ke ro baa mën ɗí heeƴ⁠ ⁠? Fu homay woni biti funi yaafu a koy-baappu ay ƴek fíyú níi fun sígímíɗ ɗë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Koy-baappi eeñnjuute ri, ndaa boffa helte nuf heeja. ");
INSERT INTO ndv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Lahte bis, ɗeef koy-baappi Suseef suute níidí yubi boffi wa luufi Sihem. ");
INSERT INTO ndv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Yakop won Suseef tih⁠ ⁠: «⁠ ⁠Koy-baappu íníh níirëeyín Sihem woo⁠ ⁠? Aye mi wol ro waa na⁠ ⁠: paye fu kénsëh níi fu yúh ɗee homuu wa a yuba ra, fu nimil raa, fu teeɓ soꞌ.⁠ ⁠» Suseef tahte won tih⁠ ⁠: «⁠ ⁠Kotta ƴeh.⁠ ⁠» Yakop wolaꞌte ri ɗeh húur mí gini Heboron daaha, Suseef yulaꞌte ri nuŋi Sihem. ");
INSERT INTO ndv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Lahaꞌ ri ra, ow ɗeeffe ri na yídëelëh luufa, meelte ri won tih⁠ ⁠: «⁠ ⁠Fu saam yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ɗi won ɗi tih⁠ ⁠: «⁠ ⁠Mi saam koy-baappi soꞌ. Fii soo teeɓ tígë në níirúu wë dee ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ɓëeꞌ won ɗi tih⁠ ⁠: «⁠ ⁠Wa koluute deh, te mi kelohte wa na ɓeytuu waal Dotan.⁠ ⁠» Suseef téebíɗté wë níi ɗeeffe wa Dotan. ");
INSERT INTO ndv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ɗi teem hanndal, koy-baappa séenúté rí, wa na peenu bëemí. ");
INSERT INTO ndv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Ëlí⁠ ⁠! Heeƴohi gaana ee ac ɗa. ");
INSERT INTO ndv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ëyí kan⁠ ⁠! Yen yíp ríi hap húl, yen bet ɗi filiɓ yéem⁠ ⁠; lah raa, yen ɓíllún biti gúmú daa ñam ri, níi yen yúh tígë teem heeƴƴi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ndaa kelaꞌ Ruben yii bah, na sëmlëꞌ rí nuf won tih⁠ ⁠: «⁠ ⁠Yen ɓanuy rii hap. ");
INSERT INTO ndv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ñif ɓanay keen⁠ ⁠! Bétí rí filiɓ fi yéemë luufi beh, te yaꞌ ɓanay tíkëh faana.⁠ ⁠» Ƴaaha ɓéeɓ Ruben ɓonaꞌ sëmlëꞌí koon, nimiliɗ ɗi boffi na. ");
INSERT INTO ndv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Lahaꞌ Suseef koy-baappi na ra, wa yípútée nís búubí lémëe ɓekoh ri ra, ");
INSERT INTO ndv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","wa habute ri, betute ri tal yéemë⁠ ⁠; ɗeef yéemë síiñcé, lahay muluɓ. ");
INSERT INTO ndv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Filoon fi baaha, wa anutee took, na ñamu. Ɓéyrúu wë affi wa ra, wa séenúté ɗuuli Ismayella ɗúhúu Galaat ɗa na ayu a i géléemmí séfú i yin heeñlaa a paƴaa, na suu yaayi wa Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yudaa won koy-baappi tígí daaha tih⁠ ⁠: «⁠ ⁠Hawi ñéedí yen a ɗabi húlí ay yen ɓaate yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ëyí yen yaay ri yiikoh yi Ismayella, te yaꞌ yi yen ɓanay tíkëh faana, ɗi ñéedí yen te ñif ma faani daa na tíl faanni yen.⁠ ⁠» Koy-baappi ñéerúuté a ri yii baaha. ");
INSERT INTO ndv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Lahuu Ismayella waa na ra, wa nísúté Suseef yéemë, yaayute wa ri a sekel sabay ana (20)⁠ ⁠; ɓëewí ƴaa kúrëelúuté rí Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nimilaꞌ Ruben yéemë rë, ɗi otte biti Suseef ínlíh në. Ɗi ɗaɗte búubí, ");
INSERT INTO ndv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","wëegíssé ñéyíɗɗí në won wa tih⁠ ⁠: «⁠ ⁠Kúkëyë ínlíh në⁠ ⁠! May teye di kan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tígí daaha, wa oolute sékét, ɓeyute búubí Suseef, ooƴute ñif ma. ");
INSERT INTO ndv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Wa kéyrúuté boffi wa búubí lémëe, ñéerëꞌté a unni ƴeh⁠ ⁠: «⁠ ⁠Ole yee píyú fun ra⁠ ⁠; kénsée nda fay yúhsëꞌ búubí koohu raa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakop yúhsëꞌté rí, foŋke won tih⁠ ⁠: «⁠ ⁠Búubí koy soꞌ⁠ ⁠! Gúmú ñampe ri⁠ ⁠; Suseef palsuu palsoo.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakop ɗaɗte búubí, haamohte saaku, jëtɗëhté koohi yii maañce. ");
INSERT INTO ndv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Koyyi, ƴaalla a ɓeleɓɓa ɓéeɓ, caguute, na mësɗú rí⁠ ⁠; ndaa ri kaaꞌaꞌte keloh, na won tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ, may jëtɗée koy soꞌ níi mi ɗeefiɗ ɗi ɓúudé.⁠ ⁠» Te ri looyte Suseef looyi misikke. ");
INSERT INTO ndv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Lahuu Ismayella Ésíp rë, wa ɓeyute Suseef, yaayute ri Potifaar, dak di dakki gaanni buuri Ésíp, bee kúɗ wohoh ya ra. ");
INSERT INTO ndv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Jamanii baaha, Yudaa kolohte ɓëy faam wa na, saañce faam Hira fi ɓëy Adulam. ");
INSERT INTO ndv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Daaha, Yudaa yúhëntëꞌté a kúkëy cafaƴ, ɓeɓpe ri ɓeleɓ, wa ñéerúuté. Boffi ɓelaa hínú Suwaa, ɗi ɓëy Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ɓelaa pokke loo, lahte koy ƴaal, Yudaa yeɗte ri tii Er. ");
INSERT INTO ndv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ɗi pokaatte loo, lahte koy ƴaal kay, ɗi yeɗte ri tii Onaan. ");
INSERT INTO ndv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ɓelaa lahilte koy ƴaal kay, yeɗte ri tii Selaa⁠ ⁠; límí koy ki baa ɗeef Yudaa húmú Kesip. ");
INSERT INTO ndv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yudaa saamiɗte Er ɓeleɓ⁠ ⁠; ɓelaa hínú Tamaar. ");
INSERT INTO ndv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Bi pagaɗɗi Er neɓaay Koo-Yahwee, Yahwee happe ri húl. ");
INSERT INTO ndv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yudaa won Onaan tígí daaha tih⁠ ⁠: «⁠ ⁠Fu yúh yee waɗ ro di húlídë ɓahuu na ra maan⁠ ⁠? Ɓeye ɓelaa, fu saamiɗ koy-yaafu tal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ndaa, bi yúh Onaan biti koy ka nay límú rë ii hen bii, ñéerëe rí a ɓelaa ɓéeɓ, ɗi hom keenaꞌ feey, kaaꞌ saamɗi koy-yaafi tal. ");
INSERT INTO ndv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Pagadee ke ri baa neɓaay Yahwee, Yahwee happe ri húl ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tígí daaha, Yudaa won Tamaar tih⁠ ⁠: «⁠ ⁠Paye fu jëtɗée faam boffu níi bín mitaa koy soꞌ Selaa ƴaal ra.⁠ ⁠» Ɗi won nufi tih⁠ ⁠: «⁠ ⁠Bee waray húl ti koy-yaayyi nen.⁠ ⁠» Tamaar yeeltee nimil faam boffi, hompe na. ");
INSERT INTO ndv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tíkëhté yii maañce, koy Suwaa ɓeleɓ Yudaa húlté. Ɗúmëꞌ luuya ra, Yudaa saañce Timna yérí ɓëewë na ëylú fënúffí harri ra, ñéerëꞌté a Hira, koojee ke ri dék Adulam ra. ");
INSERT INTO ndv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kelaꞌ Tamaar biti pacooli ín saañ Timna kénsëhí ɓëewë na ëylú fënúffí harri ra, ");
INSERT INTO ndv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ɗi yíppée nís búuɓɓí jëtíɗɗí, ɓeɓpe músëer jímbëerëhté, kaaꞌ biti yúhsúu, payte tookke haalaani Enayim, di waali Timna. Ɗeef nuf Tamaar payte biti Selaa mitte ƴaal te ri onuy ri ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Olaꞌ Yudaa ɓelaa jímbëerëhté, ɗi habaꞌ ri ɓeleɓ tílëh. ");
INSERT INTO ndv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Bi yúhsëey rí ɓeleɓ koohi, ɗi ɗalte ɗii na ɓúk waala, won ɗi tih⁠ ⁠: «⁠ ⁠Aye fu fanoh a soꞌ hém neɓaꞌ ro.⁠ ⁠» Ndaa ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Fay soo yere yih, biti fu fanoh a soꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yudaa won ɗi tih⁠ ⁠: «⁠ ⁠May ɓeɓ sékét teem-teem yubi soꞌ, mi kéyrëꞌ rë rí.⁠ ⁠» Ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Mi tahte, ndaa fay soo yeɗ yii haba mi níi balaa baaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yudaa meelte ri won tih⁠ ⁠: «⁠ ⁠May roo yere yih, fu ham ɗoo na⁠ ⁠?⁠ ⁠» Ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Yeɗ soꞌ búurë lúumú, a duuda yaꞌu.⁠ ⁠» Ɗi yeɗte wa ɓelaa, fanohte a ri, ɓelaa ɓeyaꞌte na loo. ");
INSERT INTO ndv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamaar kolohte nimilte faam, níssé músëerë jímbëerëꞌ rí rë, ɓekaatte búuɓɓí jëtíɗɗí. ");
INSERT INTO ndv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yudaa nahte koojee ke ri dék Adulam ra komi ɓelaa sékédë, wonte ri biti lah raa ɗi kalaaloh iña húmú yeɗ ɗi ɓelaa ra⁠ ⁠; ndaa kooja olay ɓelaa. ");
INSERT INTO ndv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ɗi meelte ɓëewí ƴaalla dékú daaha ra, nda wa oluy ɓelaa na húmú cagaaloh ɓúk waali Enayim ra. Wa wonute ri biti lëhírëy ɓelii na cagaaloh tígí daaha. ");
INSERT INTO ndv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kooja nimilte Yudaa na, won ɗi tih⁠ ⁠: «⁠ ⁠Mi olay ri, te ɓëewë dékú në rë sah wonu ti lëhírëy ɓelii na cagaaloh tígí daaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yudaa won ɗi daaha tih⁠ ⁠: «⁠ ⁠Ɗi haba iña yeɗ mi ri ra ɗii na, toñeh yen yaproh affi yen. Di mín rí man ɓéeɓ, mi kéyrëꞌté ɓelaa sékédë, te payaꞌ fu ra, fu olay ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tíkëh yii waɗtee mit céyín éeyë, ow acce won Yudaa tih⁠ ⁠: «⁠ ⁠Tamaar ɓeleɓ koohu paam tílë níi loo ɗeeffe ri na.⁠ ⁠» Tígí daaha, Yudaa nahaꞌte hawi, won tih⁠ ⁠: «⁠ ⁠Ɗi ɗúhrún gina, tamu yéelíɗ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ndaa na ɗúhrú ɓelaa ra, ɗi wolaꞌte pacooli na won tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ lahaꞌ iñƴee ra daa on soꞌ loo. Olsee noo, nda fay yúh ɓëeꞌ lahaꞌ búurë a duudi bee ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yudaa yúhsëꞌté wë, won tih⁠ ⁠: «⁠ ⁠Ɗi luk soo júɓ⁠ ⁠; biti mi onay ri koy soꞌ Selaa ɓeɓ ri ɓeleɓ, daa komaꞌ yee paŋ ri bee ra.⁠ ⁠» Kolaꞌte baaha, Yudaa fanlaay a ɓelaa. ");
INSERT INTO ndv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tílëꞌ níi lowa lahte ra, ɓelaa kúɗ síis. ");
INSERT INTO ndv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Na ɓësíl rí rë, lahte bi ɗúhíɗté yaꞌi⁠ ⁠; ɓelaa na múcël rë hampe yaꞌa pokke na lékít luum won tih⁠ ⁠: «⁠ ⁠Bee daa ɗéɓpí ac.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ndaa ɗi hëelíɗté yaꞌi níi koy-yaafa daa ɗéɓpí límú. Ɓelaa na múcël rë yíppée won tih⁠ ⁠: «⁠ ⁠Waala ɗaɗ fu ra mën ɗí waal⁠ ⁠?⁠ ⁠» Yudaa yeɗte ri tii Peres (daa ri⁠ ⁠: ɗaɗte waal). ");
INSERT INTO ndv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Koy-yaafa poku lékkí luuma yaꞌ ra antee límú. Yudaa yeɗte ri tii Serah (daa ri⁠ ⁠: púlí naꞌ). ");
INSERT INTO ndv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Kúrúu Suseef níi lahte Ésíp rë, Potifaar, ow di ɓëy Ésíp, non dakki gaanni buur, bee kúɗ wohoh ya ra lompe ri Ismayella na. ");
INSERT INTO ndv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Bi ñéerëꞌ Koo-Yahwee a Suseef, yii paŋ ri ɓéeɓ ñee waal, ɗi yeeltee dék faam Potifaar yíkíi. ");
INSERT INTO ndv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Olaꞌ Potifaar biti yii cëgíɗ Suseef ɓéeɓ Yahwee ñéerëꞌ në, keeña sosse ɗii na, ");
INSERT INTO ndv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ɗi ɓéyíɗté rí, léɓíɗté rí hëbísí, yeɗte ri una faam fa. ");
INSERT INTO ndv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kolaꞌ baaha, kúrí Suseef faam fa tahte níi Yahwee barkelte faam Potifaar⁠ ⁠; iña faam fa a ƴee meeyya ɓéeɓ Yahwee barkelte wa. ");
INSERT INTO ndv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifaar tíkké iña lahaꞌ ri ra ɓéeɓ yaꞌ Suseef. Ɗi yeel lahlay pagaɗ, henay yii leŋ ñami. Suseef húmú mitte ow te ri neɓpe yeel. ");
INSERT INTO ndv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Lahte bis, ɓeleɓ Potifaar yíppé íl sun fi Suseef, won ɗi tih⁠ ⁠: «⁠ ⁠Aye fu fanoh a soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ndaa Suseef kaaꞌaꞌte won ɗi tih⁠ ⁠: «⁠ ⁠Yíkíi sëꞌ tíkké iña faam fa ɓéeɓ yaꞌ soꞌ, te ri na meellileh soꞌ yin. ");
INSERT INTO ndv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ow lukleh soꞌ un faam fi beh, te ƴaalu kaddaay soꞌ yin henay ɗo fi ɓeleɓi. May rii pagee yii ɓosi baa ɗí níi mi bakaare fíi Koope⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Yíilëe Koo faraah, ɓelaa wëegís wona, ndaa Suseef kaaꞌaꞌte fanoh a ri ɓiiƴ te na leɓeeh ri. ");
INSERT INTO ndv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Bisa ín, ɗeef súrgë yínë sah húmúy filiɓ faam fa, Suseef haalte na légéy ti merees nen. ");
INSERT INTO ndv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ɓelaa ɗeef ri daaha, habaꞌte ri búubí, won ɗi tih⁠ ⁠: «⁠ ⁠Aye fu fanoh a soꞌ.⁠ ⁠» Ndaa Suseef búutté saañce ëssín, hellaꞌte ri búubë. ");
INSERT INTO ndv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Olaꞌ ɓelaa biti Suseef hegohte helte búubí yaꞌ yi ra, ");
INSERT INTO ndv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ɗi foŋke, dëekké súrgë yë won wa tih⁠ ⁠: «⁠ ⁠Ëlsíi bee kan⁠ ⁠! Ndeke yen komu Ébrëyí ac hégílëꞌí yen. Ɗi yuloh soo na, na maanndaꞌ débí sëꞌ, mi antee liik. ");
INSERT INTO ndv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kelaꞌ ri foŋi soꞌ sun maa dëekëꞌ hílíp, ɗi helte búubí hëbís sëꞌ, hegohte ɗúhté ëssín.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ɓelaa antee yef búubí Suseef hëbísí níi bee nimilaꞌ ƴaali faam fa ra. ");
INSERT INTO ndv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ɗi wëegíssé unna, na ɓílíɗ won tih⁠ ⁠: «⁠ ⁠Ñaami Ébrëe kom fu fun ra yuloh hégílëꞌí sëꞌ koon, ");
INSERT INTO ndv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ndaa fogaꞌ mi sun maa dëekëꞌ hílíp, ɗi helte búubí hëbís sëꞌ, hegohte ɗúhté ëssín.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kelaꞌ yíkíi Suseef unnee ɓílíɗ ɗí ɓeleɓi ra, ɗi neeɓpe níi tallaꞌ las. ");
INSERT INTO ndv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ɗi habrohte Suseef, ɓekrohte ri kasaa na téƴɗëꞌ buur ɓëewí rë. Suseef yeelti míllëꞌ kasu. ");
INSERT INTO ndv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ndaa Koo-Yahwee yeɗɗay Suseef te teeɓpe ri naaꞌ-keeñ, tahte níi keeñ daga kúɗ kasaa ra sosse ɗii na. ");
INSERT INTO ndv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ɗi ɓéyíɗté Suseef, tíkké ɓëewë filiɓ kasaa ɓéeɓ yaꞌi⁠ ⁠; yii nay pagu ɓéeɓ, Suseef daa na lec. ");
INSERT INTO ndv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Daga kúɗ kasaa ra na yeelti paglileh yin di légéyë tík ɗí yaꞌ Suseef ra, ndah biti Yahwee ñéerëꞌté a ri, te yii cëgíɗ rí ɓéeɓ ñeyaꞌ waal. ");
INSERT INTO ndv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hompe níi dak ana di dakki buur, bee kúɗ hanna a bee kúɗ paŋa ra tooñute buur ");
INSERT INTO ndv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","níi ɗi neeɓaꞌte wa, ");
INSERT INTO ndv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","antee wa ɓekroh kasaa téƴúu Suseef ra. ");
INSERT INTO ndv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Daga kúɗ wohoh ya ra tíkké wë yaꞌ Suseef, ɗi na tooppitoh wa. Wa homute kasaa níi ");
INSERT INTO ndv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","elga ín, daga kúɗ hanna a bee kúɗ paŋa ra heeƴute. Heeƴƴa, bina-bina ɓéeɓ a yee won ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yíilëꞌ Koo níi Suseef ɗeefiɗte wa ra, ɗi otte biti keeññi wa man neɓay nen, ");
INSERT INTO ndv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon lahuu yi ɓal⁠ ⁠? Ɗon sídúu yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun heeƴu heeƴo, fun anutee lahuy ɓëyí nay fun teeɓe yee won heeƴƴa ra.⁠ ⁠» Suseef won wa tih⁠ ⁠: «⁠ ⁠Koo mín teeɓaꞌ yii won heeƴ ɓéeɓ. Ɓíllí sëꞌ wë noo mi keloh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Tígí daaha, daga kúɗ hanni buur ra ɓílíɗté rí heeji won tih⁠ ⁠: «⁠ ⁠Mi ot tal béeñí lahaꞌ yaꞌ éeyë filiɓ heeji soꞌ. Ɗi jibisse, capusse, goññi reseñña yíppée non. ");
INSERT INTO ndv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mi hampe gulii buur yaꞌ soꞌ, mi heɓpe reseñña, mi pooƴce wa filiɓ gulaa, mantee ri yeɗ yíkíi sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Suseef won ɗi tih⁠ ⁠: «⁠ ⁠Heeja fahaꞌ woni yii beh⁠ ⁠: yaꞌ yi éeyë yí béeñë daa waal éeyë. ");
INSERT INTO ndv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Waal éeyë fíi, buur ay ɓéyíɗ afu, wëegísíɗ ɗë légéyú. Fay rii ɓek gulii yaꞌi ti merees nen. ");
INSERT INTO ndv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Fu wëegís faam buur níi fu took raa, lah hele nuf soo na biti neɓaꞌ ro, fu pagiɗ soꞌ yii wuni beh⁠ ⁠: lah gonle a buur yii leŋke soo na níi mi ɗúh kasii beh. ");
INSERT INTO ndv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ndée, mi këllúu gin fun a doole, mi kúrúté deh. Te dee ɓal, mi pagay yii cal kasu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Olaꞌ daga kúɗ paŋa ra biti Suseef won yii neɓpe keloh heeja ra, ɗi won ɗi tih⁠ ⁠: «⁠ ⁠Soꞌ ɓal mi heeƴce, mi enohte waꞌ kuun éeyë. ");
INSERT INTO ndv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Waꞌa paaꞌ sun ra túm kuunna fahaꞌ buur ra kep. Ƴakka ayute na ƴoku filiɓ waꞌa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Suseef tahte won tih⁠ ⁠: «⁠ ⁠Heeja won yii beh⁠ ⁠: waꞌ yi éeyë yë daa waal éeyë. ");
INSERT INTO ndv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Waal éeyë fíi, buur ay ɓéyíɗ afu níi sun, keɗ ro sun kilik, te suulla ay ac ñam ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Waali éeyë fë, teeꞌaꞌ wëegísí bisa took buur nguur ka ra, buur cëgíɗté gimaak, dëekké dakki ɓéeɓ. Ɗi ɗúhíɗté daga kúɗ hanna a bee kúɗ paŋa ra kasaa, cëgíɗté wë leelii ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ɗi wëegísíɗté bee kúɗ hanna ra légéyí, daga ɓekaatte ri gulaa yaꞌ ti merees nen. ");
INSERT INTO ndv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ndaa daga kúɗ paŋa ra hawute, kerute sun kilik. Iña heeƴƴa ɓéeɓ hente ti ɗee wonaꞌ wa Suseef ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ndaa nuf daga kúɗ hanna ra paylay Suseef na, ɗi halte ri. ");
INSERT INTO ndv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tíkëh kíil ana, buur heeƴce. Filiɓ heeja, ɗi caŋ ɓúk laahi Níl, ");
INSERT INTO ndv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ɗi otte fana paana yi wunute te líifúté ɗúhúté laaha, na njemetu jeñ fa. ");
INSERT INTO ndv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Filoon fi wa, ŋak fana paana kay ƴi ɓosute níi ɓos ɗúhúté laaha, ɗeefrute ƴee ɗéɓ ɗë ɓúk laaha. ");
INSERT INTO ndv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Tígí daaha, ŋakki fañnja ɓosute níi rë yípútée ñam fañnji paana yi wunnee ɗéɓ ɗë ɓéeɓ. Buur yúunëhté. ");
INSERT INTO ndv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ɗi neeꞌaatte, heeƴilte⁠ ⁠: ɗi otte yaaŋnga paana yi líifúté te wunute ɗúhúté baaŋa yínë. ");
INSERT INTO ndv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Yaaŋnga paana kay ƴi sayŋaanute, mbëeyë më tampe wa ɗúhúté filoon fi ƴee ɗéɓ ɗë. ");
INSERT INTO ndv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Yaaŋnga ya sayŋaan ra yípútée hon paana yi wunnee ɗéɓ ɗë doɗok. Tígí daaha buur yúunëhté antee yúh biti heeƴ heeƴo. ");
INSERT INTO ndv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Yíilëꞌ Koo ra, af buur kúnëhté, ɗi dëekrëhté ɗíkísëh yë a ɓëewë lahu un Ésíp rë ɓéeɓ, ɓílíɗté wë heeƴƴi. Ndaa ow ëe ow waa na mínéh ríi teeɓ yee won heeƴƴa ra. ");
INSERT INTO ndv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tígí daaha, daga kúɗ hanna ra tahte won buur tih⁠ ⁠: «⁠ ⁠Woteh, mi nérsëhté tooñee ke soꞌ merees. ");
INSERT INTO ndv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Fu húmú neeɓaꞌte funi daga kúɗ paŋa ra níi fu ɓekrohte fun kasii daga kúɗ wohoh ya ra. ");
INSERT INTO ndv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Elga ín, fun heeƴute⁠ ⁠; heeƴƴa, bina-bina ɓéeɓ a yee won ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Filiɓ kasaa bín fë, ɗeef lahte fiil Ébrë húmú fun na. Ɗi ñaami daga kúɗ wohoh ya ra. Ɓíllúu fun ɗi heeƴƴa ra, ɗi teeɓaꞌte bina-bina ɓéeɓ yee won ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Te iña ɓéeɓ hente ti ɗee wonaꞌ ri fun wa ra nen. Mi wëegísírúté légéyí sëꞌ, ɓëyí yínëe hawute, kerute.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Buur nahaꞌte kalii Suseef, ɗi yíppée ɗúhrú kasaa, nenute, lofute búuɓ, acce caŋke fíi buur. ");
INSERT INTO ndv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Buur won ɗi tih⁠ ⁠: «⁠ ⁠Mi heeƴ heeƴo, te lahay ɓëyí mín sëe teeɓ yee won heeƴƴa ra. Te mi kelohte biti heeji ɓíllú fú ɓéeɓ, fu mín teeɓaꞌ yee won ɗi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Suseef tahte won tih⁠ ⁠: «⁠ ⁠Soꞌ neh⁠ ⁠! Koope daa mín rëe teeɓ kéy fú.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Buur tahte won Suseef tih⁠ ⁠: «⁠ ⁠Filiɓ heeji soꞌ mi húmú caŋ ɓúk laahi Níl. ");
INSERT INTO ndv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Mi otte fana paana yi wunute te líifúté ɗúhúté laaha, na njemetu filiɓ jeñ fa. ");
INSERT INTO ndv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Filoon fi wa ŋak fana paana kay ƴi súhúté níi súh, súfúñúté níi, ɗúhúté laaha. Wa ɓosu ɓoso níi mí ëllëy mani wa filiɓ Ésíp ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ŋakki fañnji ɓossa yípútée ñam fañnji paana yi wunnee ɗéɓ ɗë. ");
INSERT INTO ndv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Fañnji ɓossa honute wunna doɗok, ndaa ow mínéh yúh biti wa haalute loo yi wa, ndah biti wa lísúu ɓos ti merees nen. Tígí daaha, mi yúunëhté. ");
INSERT INTO ndv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Mi heeƴilte, mi otte yaaŋnga paana yi líifúté te wunute ɗúhúté baaŋa yínë. ");
INSERT INTO ndv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Yaaŋnga paana kay ƴi sayŋaanute, mbëeyë më tampe wa ɗúhúté filoon fi wa. ");
INSERT INTO ndv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Yaaŋnga ya sayŋaan ra yípútée hon paana yi wunna. Ƴaa ɓéeɓ, mi ɓílíɗté wë ɗíkísëh yë, ndaa ow ëe ow mínéh sëe teeɓ yee won wa ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Suseef won buur tih⁠ ⁠: «⁠ ⁠Heeƴƴi ana ya won yaa yínë. Koo teeɓ ɗo yee nay rii page ra. ");
INSERT INTO ndv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Fañnji wunni paana ya daa kíil paana, a yaaŋnga yi wunni paana ya, kíil paana ɓal⁠ ⁠; kon heeja yínë. ");
INSERT INTO ndv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ŋakki fañnji paana yi kayya ɓosute níi ɓos ra, a yaaŋnga yi paana ya sayŋaan níi mbëeyë më tampe wa ra, kíil paana ɓal, ndaa i kíil yaaɓ. ");
INSERT INTO ndv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Buur⁠ ⁠! Daa ri yee na wonaꞌ mi ro koon bitih, Koope hom teeɓu yee nay rii page ra. ");
INSERT INTO ndv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kíillí paana yee fíi ƴee ac kíillí laaɓpe níi laaɓ filiɓ Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Kíil paana yi ac yaabi misikke nay naa tíkée, tah níi ɓëewë hal kíillí laaɓɓa gét ɗë. Yaaba ay múkíl gina. ");
INSERT INTO ndv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Yaaba ay misik níi tígí teem misik, te ɓëewë ii yúhíl biti sah laaɓ lëhíɗté. ");
INSERT INTO ndv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Fu ot heeja ayaꞌ waal ana, yúhé biti Koope caŋke paŋi, te ii maañ fíi. ");
INSERT INTO ndv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«⁠ ⁠Buur, kon fu tallaꞌ biti fu yíppí saam ɓëyí ñaañce te ɓonte, fu tík gina yaꞌi. ");
INSERT INTO ndv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Lah fale ɓal filiɓ gina ɓëewí nay yeeke túm. Misahi caŋ filiɓ Ésíp ɓéeɓ, hena ŋaal iip raa, yínëe nísú, hen túmë níi bín ɗúmëe kíillí laaɓɓi paana ya ra. ");
INSERT INTO ndv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kíillí laaɓɓa na ac ƴee ra, ɓëewí ƴaa ay négírée ŋaalla, gaɗ wa filiɓ gin-taah ya, fu yeele na, hen pesaa. ");
INSERT INTO ndv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Hen ɗaaha raa, gina ay lah cëtëelëe daa níi bín ɗúmëe kíillí paana yi yaaba ra. Tígí daaha, ɓëy gina ii húl a yaaɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Woni Suseef neɓaꞌte buur a dakki. ");
INSERT INTO ndv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Buur won dakki tih⁠ ⁠: «⁠ ⁠Koo soɗte ɓëyí bee nufi níi ɗí líiffé. Mbaa yen ay olil mani⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Buur yeeltee won Suseef tih⁠ ⁠: «⁠ ⁠Koope teeɓ ro iñƴaaha ɓéeɓ rëe, ɗeef lahay ɓëyí teemmaꞌ roo ñaañ a ɓon. ");
INSERT INTO ndv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kon daa fu nay këllée gina, te ɓëewí sëꞌ ɓéeɓ ay ñeye unu. Ñaani buur ka kut nay ɓíssée biti daa mi paaꞌ ro sun.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ɗi wonilte ri tih⁠ ⁠: «⁠ ⁠Wote fee Koo beh, mi tíkké rë af gini Ésíp ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Buur antee nís supii, ɓekke ri kun Suseef⁠ ⁠; ɗi ɓekke ri búuɓ naaꞌ peyeɓ bi píisë kofeelte, líkké rí suumi úrís lúum. ");
INSERT INTO ndv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ɗi yëegíɗté Suseef wëtíirí ana fi, i ow këllúuté na wonu⁠ ⁠: «⁠ ⁠Ëní rí waal⁠ ⁠!⁠ ⁠» Buur tíkëꞌté rí ɗah af gini Ésíp ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Buur tíkílté won Suseef tih⁠ ⁠: «⁠ ⁠Daa mi buur⁠ ⁠! Ndaa, ow kaañay paŋ yin dee te ñeyeh roo na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Suseef húmú lahaꞌ kíil sabay éeyë (30) na komu ri buur ra. Kolaꞌ baaha, buur dëekëꞌ rí Safnat Paneyah, onte ri Asnat koy Potiferaa ɓeleɓ. Potiferaa seeƴoh di gini On. Suseef helaꞌ buur daaha, kolohte na wër kénsëhí Ésíp ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Filiɓ kíillí laaɓɓi paana ya, léffë gaante. ");
INSERT INTO ndv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Suseef négírëꞌté ŋaalla kíillí paana ya ɓéeɓ Ésíp, gaɗte wa filiɓ ginna⁠ ⁠; gin fi gin ɓéeɓ, ŋaalla kolaꞌ meeyya leɓoh ri ra garuu na. ");
INSERT INTO ndv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ɗaaha, Suseef gaɗte pesaa caak ti pep feey nen. Ɗee teem ŋaalla caak ra, tahte níi nuf taslay kíní wë. Caagi wa ƴúukké af. ");
INSERT INTO ndv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Na lah yaaba ra, ɓeleɓ Suseef, Asnat fi Potiferaa, lahte koy ƴaal ana. ");
INSERT INTO ndv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Suseef dëekëꞌ saawi Manase, ɗi won daaha tih⁠ ⁠: «⁠ ⁠Koope onte soꞌ níi mi halte mogi soꞌ ɓéeɓ a wulohi soꞌ faam baasoꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ɗi dëekëꞌ ñéedë Efarayim, ɗi won daaha tih⁠ ⁠: «⁠ ⁠Koope onte soꞌ i koy gina loocaꞌ mi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ɗúmëꞌ kíillí laaɓɓi paana ya Ésíp rë, ");
INSERT INTO ndv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","kíillí paana yi yaaba yíppée dal, ti di húmú wonaꞌ ri Suseef ra nen. Yaaba laɓpe ginna ɓéeɓ, ndaa ɗee teem gini Ésíp rë ɓéeɓ yeffe pesaa. ");
INSERT INTO ndv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Laɓaꞌ yaaba ɓëy Ésíp rë, gina ɓéeɓ na foŋ af buur, ɗi won wa tih⁠ ⁠: «⁠ ⁠Gétí Suseef na, yii won ɗi ron, lah pëgí rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Bi ɓaatti misik yaaba gina, Suseef kúnsírëhté gaɗɗi pesaa ya, na yaay ɓëy Ésíp pep. ");
INSERT INTO ndv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ɓëy ginni kayya ɓéeɓ ayuu lom pep Suseef na ɓal, bi ɗah yaaba ɓëewë në ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kelaꞌ Yakop biti pep lahte Ésíp rë, ɗi won koyyi tih⁠ ⁠: «⁠ ⁠Ɗon gooru yi ɗee ti ɓëewí lahuy pagaɗ nen⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mi kelohte biti pep lahte Ésíp. Pëyí ɗon lome na tokaa ñíin, toñeh yaaɓ hap yen⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ɗaaha, ow sabboo di koy-baappi Suseef yípútée koloh suute lom pep Ésíp, ");
INSERT INTO ndv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ndaa Yakop yeɗɗay Beŋsame koy-yaafi Suseef ñéerëꞌ a wa⁠ ⁠: ɗi sídëꞌ biti yin ay rii kate. ");
INSERT INTO ndv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Bi laɓ yaaba Kanaan ɓéeɓ, koyyi Yakop a i ow kay daa teeꞌuu lom pep Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Bín fë, ɗeef Suseef daa tíkú af gina, te ɗeef daa ri na yaay ɓëewë ɓéeɓ pep. Lahuu koy-baappi fíyí, wa ƴekute, sígímírúté rí níi púkkí wë daapohte feey. ");
INSERT INTO ndv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Olaꞌ Suseef koy-baappi, ɗi yúhsëꞌté wë, ndaa ri teekiraay wa, te wa yúhsúuy rí. Ɗi na an waa wonaꞌ a unni diŋke⁠ ⁠: «⁠ ⁠Ɗon ɗúhúu dih⁠ ⁠?⁠ ⁠» Wa tahute wonu tih⁠ ⁠: «⁠ ⁠Fun ɗúhúu Kanaan, fun ayu lom pesaa dee koon.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tígí daaha, Suseef nérsëhté iña na húmú heeƴ ɗi sun fi wa ra, ɗi tahaatte won wa tih⁠ ⁠: «⁠ ⁠Ɗon i wolu-wolu yi ayu kénsëhí ɗee man gin fun ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wa kaaꞌuute wonu tih⁠ ⁠: «⁠ ⁠Di wonuu fun ɗo ri Yíkëe, fun ayu lom pesaa deh. ");
INSERT INTO ndv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Fun daa boku boffa yínë, te nuffi fun lante, fun ayuy kénsëhí gin ron.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Suseef tahte won tih⁠ ⁠: «⁠ ⁠Lahay íl⁠ ⁠! Kénsëhí gin fun daa tah ɗon koloh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun húmú ow sabboo a ow ana yi daa boku boffa yínë di gini Kanaan. Bee luk fun paaꞌ kúkëy rë tasse hëbís boffi, te lahte bi ínlíh në.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Suseef wonaatte wa tih⁠ ⁠: «⁠ ⁠Yee won mi ron ra daa lah⁠ ⁠: ɗon ayu kénsëhí gin fun. ");
INSERT INTO ndv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Kon may olsoh nda ron wonu kaah. Mee añoh ra ee di tii buur, ñéedí ron aay dee raa, ɗon ii ɗúh gini beh. ");
INSERT INTO ndv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Wëlí ow yínë di ron na pay kale ri, ɓëewë tasu ra ɓeku kasaa níi mi olsoh nda ron wonu kaah. Henay kaah raa, mi añohte di tii buur, ɗeef ron ayu kénsëhí gina.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Suseef antee waa wookiroh ɓéeɓ, ɓekrohte wa kasaa, wa homute na waal éeyë. ");
INSERT INTO ndv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Waali éeyë fë, Suseef won wa tih⁠ ⁠: «⁠ ⁠Mi yúhté biti Koope lahte, ɗon fahaꞌ tosi ñíinní ron raa, pëgí yee nay mi ron wone ra. ");
INSERT INTO ndv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ɗon henun ɓëewí nuffi wa lante raa, hélí ow yínë ron na tasiɗ ɗon kasaa deh, ɓëewí kayya nimil komi ɓëewín faam homu yaaɓ ra pesaa, ");
INSERT INTO ndv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","te lah këmí sëꞌ ñéedí ron. Tígí daaha, may yúh nda ron wonu kaah raa, te ron ii húl.⁠ ⁠» Wa tahute yee won wa Suseef ra, ");
INSERT INTO ndv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ndaa wa na wonantuu hanndal ki wa⁠ ⁠: «⁠ ⁠Yee húmú pagu yen ñéedí yen ra daa tah naꞌ tam affi yen. Keeña ɗúmpé bín fë, ɗi ɗaŋke, yen síkírúuy rí. Yii baa daa keen sun fi yen woteh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben tahte won wa tih⁠ ⁠: «⁠ ⁠Mi wonay ron bín fë ngënë pëgí kúkëyë yii misikke, ɗon kaaꞌuute síkírëhí sëꞌ woo⁠ ⁠? Neɓ raa, yen mam na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nuffi koy-baappa paay biti Suseef keloh iña na wonantuu wa ra, af biti lahte ɓëyí në ɓíssëꞌ wë gonli wa. ");
INSERT INTO ndv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Suseef yíppée waa hel daaha, ɗapohte, looyte, antee wëegís na won a wa. Ɗi tanisse Simewoŋ, pokalsaꞌrohte ri fíi wë. ");
INSERT INTO ndv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Suseef nahte súrgë yí ngúukrí saaku yi koy-baappi pep níi líif, ɗee teyu wa ra ɓéeɓ, hélsí wë wëegísírú wë filiɓ saaku yi wa, an waa yeɗ ñami wa waala. Ɗee wonaꞌ ri ra paguu ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Wa eɓute saaku ya mbaammi wa, tíkúuté waala. ");
INSERT INTO ndv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Lahuu wa tígë nay waa neeꞌee elga ra, ow yínë waa na pëkís saakii ay yere mbaam fi ñamaɗ koon, ɗeef hélsí ɓúk-ɓúgë. ");
INSERT INTO ndv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ɗi won koy-baappi tih⁠ ⁠: «⁠ ⁠Hélsí sëꞌ wëegísírúté sëꞌ aƴee filiɓ saakii soꞌ ee⁠ ⁠!⁠ ⁠» Tígí daaha, wa tíitú tíitë níi faanni wa na saak, wa na wonantuu hanndal ki wa⁠ ⁠: «⁠ ⁠Bee ke yeni Koope bee yi kan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Lahuu wa faam boffi wa Yakop di Kanaan ra, wa ɓíllúté rí iña kat wa ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Wa wonu tih⁠ ⁠: «⁠ ⁠Yíkíi gina wonaꞌ fun a unni diŋke, antee habaꞌ biti fun wolu kénsëhí gin wa. ");
INSERT INTO ndv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Fun wonu ri tih⁠ ⁠: “Fun tílú kot wun te nuffi fun lante⁠ ⁠; fun ayuy kénsëhí gin ron. ");
INSERT INTO ndv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Fun húmú ow sabboo a ana yi daa boku baap, lahte bi ínlíh në te bee luk fun paaꞌ kúkëy rë tasse boffi na Kanaan.” ");
INSERT INTO ndv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ndaa yíkíi gina tahte won fun tih⁠ ⁠: “May anee yúh nuffi ron ɗeh⁠ ⁠: héllí sëꞌ ow yínë ɗon na, ɓëewí kayya kome ɓëewín faam homu yaaɓ ra pesaa. ");
INSERT INTO ndv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Te lah këmí sëꞌ ñéedí ron. Ɗon kom soꞌ ri raa, may yúh biti nuffon lante, ɗon ayuy kénsëhí gin fun. Tígí daaha, may ron wëegísíɗ koy-boffi ron te ron ay mín tíl kotti ron filiɓ gina ɗee neɓaꞌ ri ron ra.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Na yíidú wë saaku yi wa ra, bina-bina ɓéeɓ lahte jogi hélsí húmú filiɓ. Oluu wa hélsë, ɓani boffi wa tíitúté. ");
INSERT INTO ndv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tígí daaha, boffi wa Yakop won wa tih⁠ ⁠: «⁠ ⁠Ɗon fahuu ɗúmëlí koyyi soꞌ maan⁠ ⁠: Suseef sooƴce, Simewoŋ sooƴce, ɗon anutee fahlaꞌ ɓeyi Beŋsame yaꞌ soꞌ, ƴaa ɓéeɓ keen af soꞌ a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ndaa Ruben won boffi tih⁠ ⁠: «⁠ ⁠Tíké rí yaꞌ soꞌ, may roo rii nimiliɗ. Mi pagay ri raa, fu ɓek ñíinní koyyi ƴaalli ana yi soꞌ feey.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakop kaaꞌaꞌte fatañ tahte won tih⁠ ⁠: «⁠ ⁠Koy soꞌ ii ñéerëꞌ a ron⁠ ⁠; koy-yaafi húlté te mi tallaꞌ ri njunduŋ. Yin kat ri waali ron raa, bee ɓahayaꞌ mi bee ra, ɗon ay tah súfúñ hap soꞌ húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Yaaba ɓaattee misik Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tílëꞌ níi ɓëy faam Yakop ɗúmëlúté peba ɗúhúu wë Ésíp rë, Yakop won koyyi tih⁠ ⁠: «⁠ ⁠Wëegísí ɗon lome pesaa Ésíp.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yudaa tahte won tih⁠ ⁠: «⁠ ⁠Yíkíi gina caŋke lok biti fun ñéerúuy a ñéedí fun raa, fun ii caŋ fíyí. ");
INSERT INTO ndv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Fu tah yeɗɗi Beŋsame ñéerëꞌ a fun raa, fun pay lomɗe ro pesaa. ");
INSERT INTO ndv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ndaa fu yeɗɗay ri raa, miteh fun payaa⁠ ⁠; ndée ɓëeꞌ húmú wonte fun biti fun ñéerúuy a ñéedí fun raa, fun ii caŋ fíyí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakop tahaatte won tih⁠ ⁠: «⁠ ⁠Yii wonɗoh ron biti ɗon lahute ñéyíɗ kay⁠ ⁠? Yee pagu ron ra neɓaay soꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ndaa wa tiilute wonu tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ daa cagoh fun rík a meelaꞌ, na saam yii lante sun fi fun a ɓëy faam fun⁠ ⁠: nda boffi fun líssí pes, nda fun lahute ñéyíɗ rëe. Fun tiilu ri iña meel ri fun ƴaaha ra ee⁠ ⁠; fun ay yúhée biti ɗi ay fun kalliree ñéedí fun ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yudaa tahte won boffi, Yakop tih⁠ ⁠: «⁠ ⁠Yeɗɗaꞌ soꞌ Beŋsame funi ñéerëꞌ. Fun ay koloh fun saañ, nda yen mín tos ñíinní yen⁠ ⁠; hen ɗaaha raa, ɗo a fun a ɓëy faam fa ɓéeɓ, yaaɓ ii yen hap pëtíh. ");
INSERT INTO ndv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Daa mi níidí kúkëyë, te lah meel soꞌ ri. Mi wëegísírëy rë rí rëe, lah yeelaꞌ soꞌ tooñi baa pesi soꞌ ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Yen teel koloh koon, tii koon fun lahute pay a wëegís waal ana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Boffa yeeltee waa won tih⁠ ⁠: «⁠ ⁠Hém ɗaaha raa, héní ɗeh⁠ ⁠: ɓékëelíi iña lukki neɓ gin yen ra filiɓ saaku yi ron⁠ ⁠: yin heeñlaa a paƴaa, kúum a gëyúmmí neɓpe, ɗon komaaloh wa yíkíi gini Ésíp fi baa yoobbol. ");
INSERT INTO ndv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kúrí ganjarmi hélsí nay ron lomee dín fë rë ana, te lah raa, ɗon wëegísíɗ ƴee ɗeefu ron ɓúk saaku ya ra⁠ ⁠; mín ƴaha héllëꞌ. ");
INSERT INTO ndv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Këlíi ɗon ñéerëꞌ a ñéedí ron, ɗon wëegís ɓëyí baa na. ");
INSERT INTO ndv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ɗémíin Koope fa mín ɓéeɓ rë paŋ níi ɓëyí baa ot súfúñ fí ron ndín, yérém ron, ɗi yeris Beŋsame a Simewoŋ wëegís a ron. Bee homaꞌ mi bee ra, koyyi soꞌ waɗti ɗúmún ɗúmë rëe, wa ɗúmún.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Yaawa ɓeyute yoobbola, kúrëelúuté ganjarmi hélsë ana, ñéerúuté a Beŋsame tíkúuté waali Ésíp. Wa lahute cagute fíi Suseef. ");
INSERT INTO ndv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Olaꞌ Suseef biti Beŋsame ee waa na ra, ɗi won súrgëe kúɗ yii leŋke faam fa ra tih⁠ ⁠: «⁠ ⁠Kúré ɓëewí ƴee faam soꞌ, hawree ndawal fu paŋ⁠ ⁠; funi wa nay añe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ɓëeꞌ kolohte paŋi iña nah ri Suseef ra, na kúɗ yaawa faam yíkíi. ");
INSERT INTO ndv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Oluu wa biti wa ee kúrú faam Suseef ra, wa néekíñúuté níi wa na úm-úmú wonu tih⁠ ⁠: «⁠ ⁠Mbaa hélsë húmú ɓúk saaku yi yen ayuu yen waalee ɗéɓ ɗë daa kúɗɗëh yen dee neh⁠ ⁠? Yen ay maloh ɓos deh⁠ ⁠: wa ay keen sun fi yen, naaf mbaamma, ham yen ñaam.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Lahuu wa ílí faam Suseef ra, wa leɓuute ɓëeꞌ wonute ri tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«⁠ ⁠Ɓahaa, baal fun noo⁠ ⁠! Fun ɗéɓútée ac lom pesaa deh. ");
INSERT INTO ndv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Na nimilu fun faam níi fun lahute tígë neeꞌu fun waala ra, ɓëyí kúnís ɓúk saakii fun na ɓéeɓ, otte biti hélsí húmú filiɓ, te wa teem cadum fi saaku ya. Fun yíih ɓëeꞌ ɓekaat wa filiɓ ra, daa tah fun wëegísíɗ wë ee. Te fun kúrëelúuté hélíis kay lomaa pesaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ɓëeꞌ tahte won wa tih⁠ ⁠: «⁠ ⁠Ngënë néekíñíi, tëekíi wun deh. Koope fi ɗoni boffi ron daa yeraꞌ ron wa ɗaaha alal saaku yi ron. Hélsí ron lahte soo na kaah.⁠ ⁠» Ɗi antee ɗúhíɗ Simewoŋ, kompe wa ri, ");
INSERT INTO ndv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ɓekke yaawa faam Suseef, kompe wa muluɓ hosaa kot, antee túmíɗ mbaammi wa booɓ. ");
INSERT INTO ndv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bi keluu wa biti wa ay añee daaha, wa yugusuute yoobbola komaaluu wa Suseef ra, na sehu ayi biti naꞌ tam. ");
INSERT INTO ndv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Lahaꞌ Suseef faam fa ra, wa yerute ri yoobbola kúrëelúu wë rë, wa ƴekute, sígímúté níi feey. ");
INSERT INTO ndv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ɗi meelte wa nda wa lahute sos-faan raa, antee waa won tih⁠ ⁠: «⁠ ⁠Boffee ke ron na húmú wonuu ron soꞌ ɓahate baaha ra hente ɗíh⁠ ⁠? Ɗi líssí pes a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wa tiilute wonu tih⁠ ⁠: «⁠ ⁠Súrgúu líssí pes, ɗi lahte sos-faan.⁠ ⁠» Wa ƴekute, sígímëetúté. ");
INSERT INTO ndv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ɓéyrëꞌ Suseef afi otte ñéedí, Beŋsame fa ɓani boku yaafa yínë rë, ɗi meelte wa won tih⁠ ⁠: «⁠ ⁠Bee daa ñéedée ké ron baa na húmú wonuu ron soꞌ ra a⁠ ⁠?⁠ ⁠» Ɗi ɓaatte won tih⁠ ⁠: «⁠ ⁠Koo líhë rë yeren kúkëy ƴaal⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Keeñ Suseef líiffé ola ot ri koy-yaafi ra, tahte níi íllë ɓéeɓ kaante muun⁠ ⁠; ɗi yíppée ɗúh, saañce filiɓ lasi na looy. ");
INSERT INTO ndv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Looyaꞌ ri níi ɗi wocce lëeysíɗté keeñ ra, ɗi súlmëhté, wëegíssé won tih⁠ ⁠: «⁠ ⁠Nërëlsíi aña.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ɗi noru a afi, koy-baappi norute kay. Ɓëy Ésíppë húmú në rë noru kay, ndée ɓëewí ƴaa a Ébrë yë në bëkíh loon, yii baaha kadduute⁠ ⁠: ɗi yii ɓosse waa na. ");
INSERT INTO ndv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Koy-baappa paaꞌuu fíi Suseef. Saawa daa hom ɓúgí beh, ñéedë tíkëhté në, hente ɗaaha níi pëlíin fë daa míllëꞌ hatni yínëe. Wa éemúté na yeelantuu. ");
INSERT INTO ndv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Suseef nahaꞌte túmɗí loonni wa, ndaa ƴee túmɗú Beŋsame ra lukke ƴi koy-baappi iip. Suseef a koy-baappi hanute béeñ níi keeññi wa sosse. ");
INSERT INTO ndv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Suseef antee nah súrgëe kúɗ yii leŋke faam fa ra won ɗi tih⁠ ⁠: «⁠ ⁠Soɗɗe ɓëewí ƴee saaku yi wa yii mín wëe eɓ ɓéeɓ di pesaa, te fu wëegísíɗ hélsí wë ɓúk-ɓúkkë. ");
INSERT INTO ndv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Lah ɓekaalee gulee ke soꞌ yugusuu hélíis rë ɓúk saakii bee lukki paaꞌ kúkëy rë, ñéerëꞌ a cadum fi pebi.⁠ ⁠» Ɓëeꞌ paŋke yee nah ri Suseef ra. ");
INSERT INTO ndv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Yíilëꞌ Koo kéy fín, wa pëkísúuté, sayute a mbaammi wa. ");
INSERT INTO ndv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Wa ɗúhúté gina, ndaa liiluy rii wuloh, na won Suseef ɓëeꞌ bitih⁠ ⁠: «⁠ ⁠Kolee fu daɓaat ɓëewée koon⁠ ⁠; fu lah waa na raa, wone wa biti iñi wunna pagiru wa ra ɓéeɓ, wa símúu wë ɗaaha a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Yi tah wa loh gulaa na hanaꞌ a na ɗíkísëꞌ ɓahaa ra⁠ ⁠? Wa pagute yii ɓosse⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ɓëeꞌ daɓpe wa, wonte wa unni ƴaaha. ");
INSERT INTO ndv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ndaa wa tahute wonu ri tih⁠ ⁠: «⁠ ⁠Fu wonaꞌ yii baa ɗíh ɓahaa⁠ ⁠? Fun kaañuy paŋ yii man ɗah⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Fu olay biti koluu fun Kanaan ra, fun kúrëelúuté hélsë olu fun ɓúkkí saaku ya ra, fun wëegísírúté rë wë ë⁠ ⁠? Ay haalee yi níi fun ay lohe hélíis mbée úrís faam yíkúu⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ɓëeꞌ yaa nay oluu ɗii na ra hawun húl. Te fun fa tasu ra sah hen ñaammu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ɓëeꞌ won tih⁠ ⁠: «⁠ ⁠Mi tahte yee wonu ron ra. Ndaa ɓëeꞌ yaa nay ɗeefu ɗii na ra kep daa nay hene ñaami soꞌ, ɓëewí kayya ladu ra yeɗɗu saañ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Wa yípútée cépíɗ saaku yi wa, ow fi ow waa na ɓéeɓ kúníssé bii. ");
INSERT INTO ndv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ɓëeꞌ ñeete saaku ya ɓéeɓ na saam, dalaꞌte bi saawa níi míllëꞌ bi bee lukki paaꞌ kúkëy rë. Gulaa ɗeefu saakii Beŋsame. ");
INSERT INTO ndv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Wa tíkúté yaꞌ yi wa affi wa⁠ ⁠; eɓaatute mbaammi wa, wëegísúté ginin. ");
INSERT INTO ndv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Lahuu Yudaa a koy-baappi faam Suseef ra, ɗeef ɗi na seh wa, wa hawuute feey líhúuté fíyí. ");
INSERT INTO ndv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Suseef won wa tih⁠ ⁠: «⁠ ⁠Ɗon paguu pagadi baa ɗíh⁠ ⁠? Ɗon yíih biti ɓëewë madu a fun ra mínú ɗíkís yin fi yin ɓéeɓ ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yudaa tahte won tih⁠ ⁠: «⁠ ⁠Fun lahuy yii wonun fun ɓah, fun lahuy yii layuun fun níi fun lan. Koope daa yíiñ fun. Funi ɓëeꞌ gulaa ɗeefu ɗii na ra ɓéeɓ daa nay lígínée hen ñaammu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ndaa Suseef won wa tih⁠ ⁠: «⁠ ⁠Mi kaañay paŋ yii bah. Ɓëeꞌ gulii soꞌ ɗeefu ɗii na ra daa nay hene ñaami soꞌ. Ɗon fi ƴah, wëegísí boffi ron na a jaamma.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yudaa antee leɓoh Suseef, won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa baal soꞌ unna nay mi roo wone ƴee ra⁠ ⁠; fu ɓanay naa haayloh⁠ ⁠; ndée mi yúhté biti ɗoni buur yínë⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ɗéɓúu fun ac dee ra, fu meelte fun nda fun lahute baap, nda fun talluute koy-baap kay. ");
INSERT INTO ndv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Fun wonute ro biti fun lahute boffi ɓahate a koy-boffi daa paaꞌ fun kúkëy. Lahi boffi fun koy ki bah, ɗeef ɗi ɓahate, te ɗi fahaꞌte ri níi fahaꞌ. Ɓahii húlté, ɗi tallaꞌ ri kut yaafi na. ");
INSERT INTO ndv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Fu antee fun won tih⁠ ⁠: “Këmí sëꞌ rí, mi ot ri a íllí sëꞌ.” ");
INSERT INTO ndv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Fun wonu ro tih⁠ ⁠: “Kúkëyë mínéh wuloh boffi, wa takaꞌ raa, boffa ay jomloh.” ");
INSERT INTO ndv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ndaa fu won fun tih⁠ ⁠: “Ɗon ñéerúuy a ñéedí ron raa, ɗon ii cagil fíi sëꞌ.” ");
INSERT INTO ndv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Wëegísúu fun súrgúu boffi fun na ra, fun ɓíllúté rí yee won fu fun ra. ");
INSERT INTO ndv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Daa tah wonaꞌ boffi fun bitih⁠ ⁠: “Wëegísí ɗon ɓaatee pesaa” ra, ");
INSERT INTO ndv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","fun wonu ri tih⁠ ⁠: “Fun mínlíh pay Ésíp, hém fun ñéerúuy a ñéedí fun. Ɗi ñéyrëꞌ a fun raa fun ay mín pay, henay baaha raa, fun ii mín caŋ fíi ɓëeꞌ.” ");
INSERT INTO ndv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Súrgúu boffi fun won fun tih⁠ ⁠: “Ɗon yúhúté biti funi ɓeleɓ soꞌ Rasel lahuu koy ana⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ɓëyí yínëe kolohte yaꞌ soꞌ, mi habaꞌ biti yin daa palsaꞌ ri. Ndée mi ollilay ri níi a woteh. ");
INSERT INTO ndv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ɗon ɓeyil bee yaꞌ soꞌ bee níi yin kat ri raa, bee ɓahayaꞌ mi bee ra, ɗon ay tah súfúñ hap soꞌ húl.” ");
INSERT INTO ndv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Mi wëegís faam níi baasoꞌ kan kúkëyë rëe, ñíinë mín nëe teem, ndah pokoha pokoh ri ɗii na ra. Te bi ɓaha ri súfúñ hap ri húl, ɗeef fun. ");
INSERT INTO ndv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ɓaatte biti daa mi cagoh ɓahaa, mi na ɗaŋ níi ɗi yeɗɗaꞌte soꞌ ri⁠ ⁠; daa mi níidí. Mi gappe ri biti mi nimliray ri koohi raa, daa mi lahiɗ ɗi bakaadi baa pesi soꞌ ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kon mi ɗaŋ ro biti fu yeris kúkëyë nimil a koy-baappi, fu ham soꞌ ñaam tígí. ");
INSERT INTO ndv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","May nimilee ɗí faam baasoꞌ te mi ñéerëey a ri⁠ ⁠? Ɗamaay mi ole súfúñ fë nay homee baasoꞌ ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Kelaꞌ Suseef unna won Yudaa ra, ɗi mínlíléh ham afi, yíppée won súrgë yí ɗúh ëssín. Ɗaaha, ow ëe ow di ɓëewë leɓuu ri ra ɗeefaay na teekiroh ri koy-baappi ra. ");
INSERT INTO ndv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ɗi antee yefoh lëel níi ɓëewë ëssín keluute na, te wona lahte níi faam buur. ");
INSERT INTO ndv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Tígí daaha, Suseef won koy-baappi tih⁠ ⁠: «⁠ ⁠Daa mi Suseef⁠ ⁠! Baap líssí pes a⁠ ⁠?⁠ ⁠» Bi kúnëh affi wa Suseef na, wa míníh ríi lof. ");
INSERT INTO ndv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Suseef wonaatte wa tih⁠ ⁠: «⁠ ⁠Éccíi fíi sëꞌ deh.⁠ ⁠» Wa leɓuute ri. Ɗi tíkílté won tih⁠ ⁠: «⁠ ⁠Daa mi Suseef, koy-boffee yaayu ron kúrúté Ésíp rë. ");
INSERT INTO ndv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ndaa, ngënë ƴíiríi affi ron yaaya yaayu ron soꞌ ra níi lukus. Tosi ñíinní ɓëewë daa tah Koope këllíɗ sëꞌ deh. ");
INSERT INTO ndv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ndée, yaaba lahaꞌ kíil ana kut gina, te tasse kíil iip fíi, lín ii lah níi púlé lec. ");
INSERT INTO ndv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Koope fahaꞌ tosi ñíinnën yaaba, ɗon pes níi tali ron tas feey fi beh, daa tah ɗi këllíɗ sëꞌ deh, sëmlëꞌí ron sëmlëꞌí lahay man. ");
INSERT INTO ndv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kon Koope daa wol soꞌ deh, ndée ɗon neh. Te ɗi ɓéyíɗté sëꞌ níi mi man baap buur na nen⁠ ⁠: ɗi yerisse faami yaꞌ soꞌ, tíkké sëꞌ af Ésíp ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Yípíi wëegís baap na faam, ɗon won ɗi tih⁠ ⁠: “Koohu Suseef daa wonaꞌ ro ɗeh⁠ ⁠: Koope ɓéyíɗté sëꞌ níi mi hente yíkíi Ésíp ɓéeɓ⁠ ⁠; kolee fu ɗeefiɗ soꞌ balaa maañ. ");
INSERT INTO ndv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Fay yípée faamu deyi Gosen ndín, fu leɓoh soꞌ⁠ ⁠; ɗoni koyyu a séttú, yuppi peꞌ ya, harra a fañnja, a iña lahaꞌ fu ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ɗon hom Kanaan, ɗon ay looc dín fë, ndée yaaba tasse kíil iip fíi, te Gosen deh, may kúɗ ɗoni ɓëy faamu a yuppa ɓéeɓ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Suseef ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon oluy a íllí ron te koy-yaasoꞌ Beŋsame otte a íllí ɓal, biti daa mi na won ɗon na keluu a nuffi ron woo⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kon gétí ɗon teeɓ baasoꞌ biti mi lahte tii Ésíp, ɗon ɓílíɗ rí iña olu ron ra ɓéeɓ⁠ ⁠; te yípíi sëꞌ ríi kom deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ɗi antee yeɗɗoh sun fi Beŋsame, wa yabaalantuute, wa ɓéeɓ ana na looyu. ");
INSERT INTO ndv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kolaꞌ ri Beŋsame na, ɗi ñeete koy-baappi na ɓéeɓ, yabaalohte sun fi wa na looy. Tígí daaha, koy-baappi na anuu mín won a ri. ");
INSERT INTO ndv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Woni ayi koy-baappi Suseef hente lëyëŋ níi faam buur. Kelaꞌ ri buur, yaa neɓaꞌte ɓani dakki. ");
INSERT INTO ndv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ɗi won Suseef tih⁠ ⁠: «⁠ ⁠Wone koy-baappu eɓ mbaammi wa, wa wëegís Kanaan ");
INSERT INTO ndv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","kale boffi wa a ɓëy faammi wa kúɗ wë deh. May waa yeɗ feey fa lukki looɓ Ésíp rë, wa yíp faammi wa na⁠ ⁠; te wa ay pesee iña lukki neɓ gina ra. ");
INSERT INTO ndv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Te wone wa bitih, wa ƴahti saañ raa, lah wa ɓeyun i sareet deh, wa kale ɓeleɓɓi wa, koyyi wa a boffi ron ɓal, wa nimil deh. ");
INSERT INTO ndv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wa ɓanuy tësíɗ nuffi wa yii waɗ waa hel filoon, ndée wa ay ɗeef iñi luk iñƴaaha wun deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Koyyi Yakop paguu iña nahu wa ra ɗaaha. Suseef yeɗte wa i sareet, ti ɗee wonaꞌ ri buur ra nen, saamiɗte wa yii nay waa ñame waala. ");
INSERT INTO ndv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ɗi ñeete waa na yeɗte wa ɓéeɓ búuɓ has ndaa lahaꞌ ri Beŋsame na, ɗi yeɗte ri na iip a hélíis caak. ");
INSERT INTO ndv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Suseef kéyrëꞌté boffi ɓal mbaam sabboo yi eɓu iña lukki wun Ésíp rë, a mbaam ɓeleɓ sabboo yi eɓu pep, mbúurú a pesii waala biti ri ƴahti ac. ");
INSERT INTO ndv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Na pëkís ɗi koy-baappi ra, wonte wa biti wa ɓanuy súfëꞌ waala. ");
INSERT INTO ndv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wa koluute Ésíp daaha, ɗeefrute boffi wa Yakop Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wonuu wa boffi wa biti Suseef líssí pes, te daa ri tíkú af gini Ésíp ɓéeɓ rë, bi lekaay ri woni wa, ɗi hégíƴëey, na yeel wa. ");
INSERT INTO ndv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ndaa ɓíllúu wë rí iña won wa Suseef ɓéeɓ rë, teeɓute ri sareetta kéyrëꞌ Suseef kalii ra, tígí daaha, kúnsëꞌ afa, Yakop na an naa mín keloh. ");
INSERT INTO ndv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ɗi yeeltee won tih⁠ ⁠: «⁠ ⁠Téyí dah⁠ ⁠! Hém koy soꞌ Suseef daa líssí pes raa, caa mi koloh mi ole ri balaa mi húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakop tíkëhté waala a iña lahaꞌ ri ra ɓéeɓ. Lahaꞌ ri Beer-Sebaa ra, ɗi hawiɗte Koope fa na húmú jaamiyoh Isaak boffi ra. ");
INSERT INTO ndv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Elgin, di filiɓ yodaɗ, Koo dëekké rí won ɗi tih⁠ ⁠: «⁠ ⁠Yakop⁠ ⁠! Yakop⁠ ⁠!⁠ ⁠» Ɗi tahte won tih⁠ ⁠: «⁠ ⁠Yëew⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Koope ɓaatte won tih⁠ ⁠: «⁠ ⁠Daa mi Koo, Koope fi boffu. Ngana néekíñëꞌ yin saañu Ésíp, ndée may paŋ níi talu ɓaatoh dín fë caak níi caak. ");
INSERT INTO ndv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Soꞌ mi beh, daa mi nay roo ɓede Ésíp, te mi yeɗte ro un soꞌ, daa mi nay roo wëegísíré ɓal. Yiin nay fuu ñame gaawa súhíɗ rë, fay lúsée yaꞌ Suseef.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakop kolaꞌ ɗaaha Beer-Sebaa⁠ ⁠; koyya yëegírúté boffi wa, ɓeleɓɓi wa a koyyi wa sareetta kéyrëꞌ wë buur kalii wa ra. ");
INSERT INTO ndv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Wa kúrëelúuté yuppi wa ɓal, a alal ma lahuu wa Kanaan ra ɓéeɓ. Yakop ñéerëꞌ a ɓëy faami ɓéeɓ Ésíp⁠ ⁠: ɓani koyyi, séttí a sétëettí, ƴaal a ɓeleɓ. Yakop a ɓëy faami ɓéeɓ kélsúuté ɗaaha Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","15","Tii yi ɓëy faam Yakop, ƴee ñéerúu a ri Ésíp rë, daa wa ƴeh⁠ ⁠: Koyyi Yakop a Leyaa, séttí a sétëettí⁠ ⁠: Ruben saawa a koyyi⁠ ⁠: Hanok, Palu, Hesron a Karmi. Simewoŋ a koyyi⁠ ⁠: Yemuwel, Yamin, Ohat, Yakin, Sohar a Sawul koy ɓelaa dék Kanaan ra. Léwí a koyyi⁠ ⁠: Gerson, Kehat a Merari. Yudaa a koyyi⁠ ⁠: Selaa, Peres a Serah (Er a Onaan húlúu Kanaan). Peres a koyyi ana yi⁠ ⁠: Hesron a Hamul. Isakaar a koyyi⁠ ⁠: Tola, Puwah, Yasup, a Simron. Sabuloŋ a koyyi⁠ ⁠: Seret, Elon a Yahleyel. Ƴaa daa tala límíɗ Leyaa Yakop homuu wa Padan ra⁠ ⁠; wa henute ow sabay éeyë a ow éeyë (33), ɓaatte Dinaa koy wa ɓeleɓ ñéerëꞌté a wa ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Koyya, séttë a sétëettë lahuu Yakop a Silpaa ra daa wa ƴeh⁠ ⁠: Gaat a koyyi⁠ ⁠: Sifiyon, Haggi, Súní, Esbon, Eri, Arodi a Areyeli. Aseer a koyyi⁠ ⁠: Yimna, Yiswa, Yiswi, Beriyaa a Seerah koy-yaafi wa ɓeleɓ. Beriyaa a koyyi⁠ ⁠: Hebeer a Malkiyel. Ƴaa daa tala límíɗ Silpaa Yakop ra⁠ ⁠; wa henute ow sabboo a ow pëenë (16). Silpaa húmú súrgíi Leyaa. Laban daa húmú ɓeɓ Silpaa yeɗte ri koohi Leyaa. ");
INSERT INTO ndv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","22","Koyya a séttë lahuu Yakop a Rasel ra daa wa ƴeh⁠ ⁠: Suseef a Beŋsame. Suseef a Asnat koy Potiferaa, seeƴoh di On lahute koy ana Ésíp⁠ ⁠: Manase a Efarayim. Beŋsame a koyyi⁠ ⁠: Belaa, Bekeer, Asbel, Geraa, Naamaan, Éhí, Roos, Múpím, Húpím a Arde. Ƴaa daa tala límíɗ Rasel Yakop ra⁠ ⁠; wa henute ow sabboo a ow iniil (14). ");
INSERT INTO ndv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Koyya a séttë lahuu Yakop a Bilhaa ra daa wa ƴeh⁠ ⁠: Dan a koohi Húsím. Neftali a koyyi⁠ ⁠: Yahseyel, Gúní, Yeseer a Silem. Ƴaa daa tala límíɗ Bilhaa Yakop ra⁠ ⁠; wa henute ow paana. Bilhaa húmú súrgíi Rasel. Laban daa húmú ɓeɓ Bilhaa yeɗte ri koohi Rasel. ");
INSERT INTO ndv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ɓëy faam Yakop, ƴee nonu tala ñéerúu a ri Ésíp rë henute ow sabay pëenë a ow pëenë (66), bokaay a ɓeleɓɓi koyyi. ");
INSERT INTO ndv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ɓaat koyyi ana ya lahaꞌ Suseef Ésíp rë rëe, ɓëy faam Yakop ɓéeɓ henute ow sabay paana (70). ");
INSERT INTO ndv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakop këllíɗté Yudaa, wolte ri Suseef na woni biti ɗi ac ɓani teeꞌaꞌ Gosen. Lahuu Yakop a ɓëy faami Gosen ra, ");
INSERT INTO ndv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Suseef pokke wëtíirí, ɗeefiɗte boffi dín fë. Lahaꞌ ri fíyí rë, ɗi ñuŋaarohte lúumë, looyte na yii maañce. ");
INSERT INTO ndv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakop antee won Suseef tih⁠ ⁠: «⁠ ⁠Hém daa fu líssí pes níi mí tíkké rë íl rëe, mi mín húl leegi a sos-keeñ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tígí daaha, Suseef won koy-baappi a ɓëy faam boffi tih⁠ ⁠: «⁠ ⁠Cëgí mi pay woni buur biti koy-baappi soꞌ a ɓëy faam baasoꞌ, ƴee húmú Kanaan ra ayute. ");
INSERT INTO ndv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","May rii won biti ɓal ɗon i níirëh har, peꞌ a fana⁠ ⁠; te ɗoni yuppi ron a iña lahuu ron ra ɓéeɓ daa ayu. ");
INSERT INTO ndv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Buur dëek rën níi meel ron yee na pagu ron raa, ");
INSERT INTO ndv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","lah wëní rí biti ɗon ɓaahuu níiɗ. Ɗaaha raa, ɗon ay mín yípëꞌ faamon deyi Gosen deh, ndée ɓëy Ésíp wonuy yin níirëh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Suseef kolaꞌ dah, antee saañ buur na won ɗi tih⁠ ⁠: «⁠ ⁠Baasoꞌ a koy-baappi soꞌ ayute Kanaan fa, kúrëelúuté harri wa, peꞌ ya, fañnja a iña lahuu wa ra ɓéeɓ⁠ ⁠; wa ínú deyi Gosen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ɗeef ɗi liiltee tanis ow iip di koy-baappi koon, yeeltee waa teeɓ buur. ");
INSERT INTO ndv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Buur meelte wa, won tih⁠ ⁠: «⁠ ⁠Ɗon paguu yih⁠ ⁠?⁠ ⁠» Wa tahute wonu tih⁠ ⁠: «⁠ ⁠Buur, fun i níirëh kíilë níi a woteh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Wa ɓaatute wonu tih⁠ ⁠: «⁠ ⁠Misigi yaaba Kanaan tahte níi yuppi fun lahluy ñamaɗ dín fë. Fun anutee ac haneel gini beh, na ɗagu ro buur, fu yeris fun hom deyi Gosen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Buur won Suseef tih⁠ ⁠: «⁠ ⁠Boffu a koy-baappu ayu roo na. ");
INSERT INTO ndv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Gina aa yaꞌu⁠ ⁠! Yere wa feey fa luk naa looɓ ra, wa yíp faammi wa na. Wa mín hom Gosen kay⁠ ⁠! Te filiɓ fi wa, fu yúh në ɓëewí sawoorute raa, fu mín tík yuppi soꞌ yaꞌ yi wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Suseef kalite boffi ɓal, teeɓpe ri buur. Boffa wodohte buur níi wodoh. ");
INSERT INTO ndv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Buur meelte ri won tih⁠ ⁠: «⁠ ⁠Fu pes kíil ɗí ɗee ɓah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakop tahte won ɗi tih⁠ ⁠: «⁠ ⁠Kíillë maangaan mi ra hente kíil tíméer a kíil sabay éeyë (130). Pesi soꞌ utay te misikke biti mi yeelaꞌ ri kíillë pesu baasoꞌ a cissoꞌ ra, te wa i maangaan ti soꞌ nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakop ɗagiɗte buur, antee ɗúh saañce. ");
INSERT INTO ndv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Suseef kolaꞌ daaha leciɗte boffi a koy-baappi feey fa lukki looɓ Ésíp rë, di Ramses (tii yíníi Gosen) ti ɗee nahaꞌ ri buur ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Suseef saamiɗte boffi, koy-baappi a ɓëewë homu yaꞌ yi wa ra, a ɗee teyu wa ra ɓéeɓ pesaa. ");
INSERT INTO ndv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bi lahlilay pesaa, yaaba ɓaattee misik gina. Di man ɗi Ésíp faanni ɓëewë ɓéeɓ na síiñ, lahaꞌ ɗaaha Kanaan. ");
INSERT INTO ndv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Suseef wookke hélsë Ésíp a Kanaan ɓéeɓ na yaay ri ɓëewë pep ra, kúɗté wë faam buur. ");
INSERT INTO ndv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ɗúmëꞌ hélsë ces yaꞌ yi ɓëy Ésíp a Kanaan ra, ɓëy Ésíp ɓéeɓ ayute caguute Suseef wonu ri tih⁠ ⁠: «⁠ ⁠Biti fun lahliluy hélíis daa nay tahe yaaɓ hap fun húl fíyú ë⁠ ⁠? Yeɗ fun yii nay fun ñame.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Suseef tahte won wa tih⁠ ⁠: «⁠ ⁠Hena biti ɗon lahliluy hélíis rëe, yérí sëꞌ yuppi ron, mi lof ron wa pesaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Wa kalute yuppi wa ɓéeɓ⁠ ⁠: pënís neh, peꞌ a har neh, fana neh, mbaam neh, komute wa Suseef, lofruute wa a pesaa⁠ ⁠; te wa ñamu na níi kíilë ɗúmpé. ");
INSERT INTO ndv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kíilë tíkëh në rë, ɓëewë nimilute Suseef na, wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun míníh rëe ɗap kaaf ka, ndée fu yúhté biti fun lahliluy hélíis te daa fu lahaꞌ yuppa woteh. Fun talluu faanni fun a feeyyi fun. ");
INSERT INTO ndv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Hanaa fii hom dah, fu yeele fun níi fun húl fíyú ndín, feey fi fun tas hen yambalaŋ⁠ ⁠? Lome funi feeyya, fu yeɗ fun wa pesaa⁠ ⁠; lah raa, funi wa lígínëꞌ ɓéeɓ buur lahaꞌ fun. Yeraaloh fun tisoh, nda fun pes, te meeyyi fun heneh mbooy.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Bi misik yaaba níi, ɓëy Ésíp ɓeyute meeyyi wa yaayute Suseef. Buur yeeltee lahaꞌ feey fi Ésíp ɓéeɓ ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Te di teem Ésíp ɓéeɓ Suseef hampe ɓëewë ɓéeɓ ñaam. ");
INSERT INTO ndv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ndaa feeyyi seeƴoh ya doŋ daa lomuy, bi habraꞌ wa buur. Bi wa ñamuu yaꞌ buur, sohlaay wa yaaye feeyyi wa. ");
INSERT INTO ndv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Suseef won ɓëewë tih⁠ ⁠: «⁠ ⁠Mi lomay ɗoni feeyyi ron níi ron ewu yaꞌ buur woo⁠ ⁠? May ron yeɗ tisoh, ɗon soh meeyya. ");
INSERT INTO ndv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ndaa lah lecaa ya fayu raa, peba woralsuu iip, wodi yínëe saañ buur na, hen túmë⁠ ⁠; iniilla tas ɗa, ƴi ron⁠ ⁠; lah yéfí në tisoh, yii tas hen pesii ɗoni koyyi ron a ɓëewë homu yaꞌ yi ron ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ɓëewë tahute wonu tih⁠ ⁠: «⁠ ⁠Ɓahaa, fu tosse ñíinní fun⁠ ⁠! Hém daa fu naaꞌaꞌ keeñ fun na ɗaaha raa, fun tahute hen ñaammi buur.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Suseef pokaꞌte kootii baa ɗaaha Ésíp⁠ ⁠; te níi a woteh, lahaa lec faraah, túmí baa nísú yeru buur. Kootaa habay meeyyi seeƴoh ya. ");
INSERT INTO ndv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Yípúu ɓëy faam Yakop deyi Gosen di Ésíp rë, wa lahute na feey, te wa keñute níi keñ⁠ ⁠; tala ɓaattee gaan. ");
INSERT INTO ndv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakop pesse kíil sabboo a kíil paana Ésíp, ɓaat ƴee lahaꞌ ri merees ra raa, pesi ɓéeɓ hente kíil tíméer a kíil sabay iniil a kíil paana (147). ");
INSERT INTO ndv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Leɓaꞌ bisi ra, Yakop dëekké koohi Suseef won ɗi tih⁠ ⁠: «⁠ ⁠Hena biti fu fahaꞌte soꞌ raa, teeɓ soꞌ naaꞌ-keeñ, fu teeɓ soꞌ biti fu pokohte soo na⁠ ⁠: ɓeke yaꞌu fëgërëh fí ɓaŋ soꞌ te fu añoh biti fii soo hacaꞌ Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Yiin nay mii hílsée rë, lah kúré ɓúudé fí sëꞌ, fu hacaꞌ ri hëbís caacci soꞌ.⁠ ⁠» Suseef tahte won tih⁠ ⁠: «⁠ ⁠May rii pagee ɗee nahaꞌ fu soꞌ ri ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ndaa Yakop ɓaatte won ɗi tih⁠ ⁠: «⁠ ⁠Añee ri.⁠ ⁠» Suseef añohte. Tígí daaha, Yakop ƴekke sígímpé af huni. ");
INSERT INTO ndv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bee gétëꞌ iñƴaa ra, hompe níi Suseef wonute biti boffi jérté. Ɗi kolohte yérí boffi, ñéerëꞌté a koyyi ana yi, Manase a Efarayim. ");
INSERT INTO ndv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Wonuu Yakop biti koohi Suseef acce yérí rë, ɗi hínndëhté níi kolohte, tookke ɓúk tigal ka. ");
INSERT INTO ndv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakop won Suseef tih⁠ ⁠: «⁠ ⁠Koope fa mín ɓéeɓ rë feeñiyohte soꞌ di gini Lúus fi Kanaan, barkelte soꞌ, ");
INSERT INTO ndv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","antee won tih⁠ ⁠: “May roo keñil níi talu ɓaatoh⁠ ⁠; fay hen goomali négírëꞌ tal caak, te may on ɓëy talu gina, wa lahaꞌ ri faraah.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakop ɓaatte won tih⁠ ⁠: «⁠ ⁠Koyyi ana ya lahaꞌ fu Ésíp deh, ɗeef mi aay ɗoo na doom ra, Efarayim a Manase, may waa habee koyyi soꞌ ti Ruben a Simewoŋ nen. ");
INSERT INTO ndv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ndaa ƴee filoon fi wa ɓéeɓ ƴuu. Wa ay mín liilaꞌ lami wa feey fi ɓaha yi wa. ");
INSERT INTO ndv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Húlë húl yaafu na nimil mi waali Padan fa ra, hente yii misikke soꞌ, daa tah mi paŋ yii bah. Yaafu Rasel húlëꞌ waala di Kanaan, ƴutuuɗ na lahu fun Efarataa ra. Mi hacaꞌ ri waali Efarataa fa na wonuu Betleꞌem ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Píyëꞌ íllí Yakop koyyi Suseef, ɗi lécíɗté gonla, meelaꞌte won tih⁠ ⁠: «⁠ ⁠Ƴee i wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Suseef tahte won tih⁠ ⁠: «⁠ ⁠Ƴee koyya on soꞌ Koope dee ra.⁠ ⁠» Yakop ɓaatte won tih⁠ ⁠: «⁠ ⁠Léɓíré wë soo na dee noo mi ɗagiɗ wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Bi ɓaha Yakop, íllë ñúussé níi ɗi mínlíléh yúhsëꞌ. Suseef léɓíɗté tuŋka fíi ciffi wa, Yakop yabaalohte sun fi wa, ngufkalte wa. ");
INSERT INTO ndv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yakop antee won Suseef tih⁠ ⁠: «⁠ ⁠Nuf soꞌ taslay biti koon may roo tíkíl íl, ndaa pagaɗɗi Koope tahte níi mi otte sah koyya lím fú rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tígí daaha, Suseef ɗúhíɗté tuŋka kotti boffi, ɗi ƴekke, sígímpé níi feey. ");
INSERT INTO ndv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Suseef antee ɓeyaat tuŋka ɓéeɓ ana, tíkëꞌté wë ɗeh⁠ ⁠: Efarayim paaꞌte Yakop yaꞌ sugu⁠ ⁠; Manase paaꞌte Yakop yaꞌ ñamaa⁠ ⁠; Suseef léɓíɗté wë fíi boffi. ");
INSERT INTO ndv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ndaa Yakop ganilte yaꞌ yi⁠ ⁠: yeɗte yaꞌi ñamaa fi, tíkké rí af ñéedë, Efarayim fa paaꞌ ri yaꞌ sugu ra⁠ ⁠; yeɗte yaꞌi sugu fi, tíkké rí af Manase fa paaꞌ ri yaꞌ ñamaa ra, bi hen ri saawa níi. ");
INSERT INTO ndv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ɗi na anti ɗagiɗ Suseef won tih⁠ ⁠: «⁠ ⁠Mee ɗaŋ ra di tii Koope fa húmú këllírú cissoꞌ Abraham a baasoꞌ Isaak ra, Koope fa níiɗ sëꞌ límúu mí níi a woteh ra. ");
INSERT INTO ndv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mee ɗaŋ ra di tii Malaakaa sëmlëꞌ sëꞌ pesi soꞌ ɓéeɓ rë, ɗi barkel tuŋki ƴeh, wa paŋ níi símíi funi caacci wa Abraham a Isaak tas faraah, wa keñ níi koyyi wa haslaꞌ feey fa⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tígë tík Yakop yaꞌi ñamaa fi af Efarayim ra na fahaꞌ ri barkeli wa ra, húmú neɓaay Suseef. Ɗi hampe yaꞌ boffi fahaꞌ nísí af Efarayim koon, lëeyíɗ rí bi Manase. ");
INSERT INTO ndv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ɗi won boffi tih⁠ ⁠: «⁠ ⁠Bëyít⁠ ⁠! Ngana henaꞌ ɗaa baap⁠ ⁠! Tíké yaꞌi ñamaa fu af Manase, daa ri ɓahaa⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ndaa Boffa kaaꞌaꞌte won tih⁠ ⁠: «⁠ ⁠Mi yúhté baaha koy soꞌ, mi yúh yee paŋ mi ra. Manase ɓal ac ow gaan, te ri ay lah tali gaante⁠ ⁠; ndaa ñéedí ay rii luk gaan te filooni, tali ay hen ginni tam ɗúmléh wë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Na ɗagiɗ ɗi wa yiin fa ra, ɗi won tih⁠ ⁠: «⁠ ⁠Ay tíl níi ɓëy Israyel ƴahti ɗagiɗ ow raa, wa ay wonee ɗeh⁠ ⁠: “Ɗémíin yee pagiɗ Koo Efarayim a Manase ra cép ɗoo na⁠ ⁠!”⁠ ⁠» Ɗaaha, Yakop këllíɗ tii Efarayim, míllëꞌté bi Manase. ");
INSERT INTO ndv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yakop antee won Suseef tih⁠ ⁠: «⁠ ⁠Mi hompe kotti kúl kë, ndaa Koope ot ɗon na te ay ron wëegísíɗ feey fi caaccon. ");
INSERT INTO ndv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Te ɗo fi beh, mi woɗte ro níi fu lungiɗte koy-baappu⁠ ⁠: Sihem fa ɓeyaꞌ mi yaꞌ yi Amoorra ra ac buu⁠ ⁠; mi ɓeyaꞌ ri kas ki soꞌ a jépílí sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Filoon fi baaha, Yakop dëekké koyyi, tëekíɗté wë won wa tih⁠ ⁠: «⁠ ⁠Ëyí ɓéeɓ, mi won ɗon iña nay lahe ɗon na fayu ra. ");
INSERT INTO ndv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Tëekí fíi sëꞌ dee koyyi soꞌ. Síkíríi sëꞌ, soꞌ mi Israyel boffon. ");
INSERT INTO ndv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ɗo fi Ruben, daa fu koy ki saawi soꞌ. Na lah mi ro ra, ɗeef mi lahte doole te ñif mi soꞌ na múkë. Daa fu luk koy-baappu doole a jom. ");
INSERT INTO ndv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Fu madaꞌ a húlbí basaꞌ basoo⁠ ⁠! Fanoha fanoh fu a ow di ɓeleɓɓi soꞌ sun fi tigal ki soꞌ ra nék sëpíɗté sëꞌ lool, daa tah fii këllíil koy-baappu. ");
INSERT INTO ndv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simewoŋ a Léwí if a ɓëlgís⁠ ⁠: ñéerëꞌí wë poyaꞌ gin. ");
INSERT INTO ndv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mi fahaay bok a wa nuf múk⁠ ⁠! Ɗamaay mi ɗeefee teeꞌaꞌ yi wa, ndah wa bëemúté i ow haayluu wa ra, te ɓosi nufa waa na ɓekke wa lec síl kot i naal fana. ");
INSERT INTO ndv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Haaylohi misiga waa na ow mínéh yin na ra, tahan wa alkoh⁠ ⁠! May woralsaꞌ koyyi wa a séttí wë filiɓ Israyel, mi haslaꞌ wa ɓéeɓ gin Yakop. ");
INSERT INTO ndv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ɗo fi Yudaa, koy-yaayyu ay roo kañ, te koy-baappu ay roo sígímíɗ, ndah biti ɓëewë na haaꞌuu ro ra ay ƴek fíyú. ");
INSERT INTO ndv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yudaa koy soꞌ, fu man fiili gaynde fi baa malohte ɓoorsohi níi na nimil faami ra nen⁠ ⁠! Múumé fanoh hílsée rëe, daa kaañ rii këlíɗ⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nguur ka ii koloh yaꞌ Yudaa, te duudi nguur ka ay home tali níi bín ayaa yíkíi rë⁠ ⁠: daa ri ɓëeꞌ ɓëewë ɓéeɓ ay ñee uni ra. ");
INSERT INTO ndv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ɗi ay pokee mbaam fi tal béeñ, pok koy ka yaꞌ béeñë lukki wun ra. Ɗi ay hosee búuɓɓí a béeñ, hosaꞌ sabidoori a ñif reseñ. ");
INSERT INTO ndv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Béeñ ay takil íllí, miis naaꞌil síssí. ");
INSERT INTO ndv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sabuloŋ ay déké ɓúk kísí fë, tígí ay lah teeraa gaal, te feey fi ay laɗ níi waal Sidon. ");
INSERT INTO ndv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakaar madaꞌ a mbaam fi lahte doole. Fanaꞌ ri hanndal ki líikkí gélíkkë, ");
INSERT INTO ndv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ɗi otte biti tígë neɓpe hílsëe te gina wunte. Ɗi yeraꞌte bíiŋí séfëe, tahte légéy ñaam. ");
INSERT INTO ndv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan ay aattiyaꞌ ɓëewí ti talli kayya Israyel nen. ");
INSERT INTO ndv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan madaꞌ a goŋ fa ɓúk waala, ɗi man ti hiliñ fa laroh kúyíɗ kë rë nen⁠ ⁠; ɗoɓaa ri pënís fë kot rek, jégëe júlkíñëh keen. ");
INSERT INTO ndv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ëey Koo-Yahwee sëmlëꞌ sëꞌ⁠ ⁠! Daa fu yaakaari soꞌ⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","I haaꞌoh yejuute Gaat na, ndaa ri míllëꞌtée wëe lík, ñeete talli wa. ");
INSERT INTO ndv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Gin Aseer ay loof níi loof⁠ ⁠! Feey fi ay ɗúhíɗ ñami neɓaꞌ buur. ");
INSERT INTO ndv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftali madaꞌ a fandaay fa fús baa ra⁠ ⁠; na lím koyyi wunna ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Suseef kilki na lím hom ɓúk warla ra. Yaꞌ yi kilka ƴúukké tiŋ ka⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","I yeesoh kas tooñute ri, yejuute ri haaꞌ, yeesute ri kas. ");
INSERT INTO ndv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ndaa ɗi hampe hélí kas ki híin, bi lah ri doole te ri tarte⁠ ⁠; ɗi hampe hélí kas ki híin, bi habraꞌ ri Koope fi Gaana na jaamiyoh Yakop ra, Koope fa na níiɗ rë, bee na woh Israyel ra. ");
INSERT INTO ndv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Koope fi boffu sëmlëe rë, ɗi fa mín ɓéeɓ rë barkela ro. Ɗémíin ɗi barkel ro a mulii caagi ɗúhëꞌ sun, a ƴi ɗúhëꞌ keeñ feey. Ɗémíin ɗi barkel ro níi fu keñ te yuppa caak. ");
INSERT INTO ndv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Iñi wunna pagiɗ Koope boffu ra luk ƴee mëssí ɗúhëꞌ daŋŋa ra, wa luk alal mi dúŋŋée kíil níi rë. Ɗo fi Suseef, ɗo fa paaꞌ koy-baappu ɓéeɓ sun ra, ɗémíin iñi wunni ƴaaha cép sun fu, ti ɗee pagiraꞌ ri soꞌ ra nen. ");
INSERT INTO ndv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beŋsame madaꞌ a baade fi sohoorte⁠ ⁠! Ɓaaba, ɗi ñam yee hap ri ra⁠ ⁠; fíníin fín, ɗi woralsaꞌ yii lah ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ƴaa daa ɓëewë yípú talli sabboo a ana yi Israyel ra. Boffa wonaꞌ wa ɗah. Ow fi ow waa na ɓéeɓ, ɗi wonte ri unna míllëꞌ rí ríi won ɗa. ");
INSERT INTO ndv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Filoon fi unni ƴah, Yakop nahte koyyi won wa tih⁠ ⁠: «⁠ ⁠Soꞌ nék, mi ee ɗeefiɗ caacci soꞌ ɓúudé rë ee, lah féhéyí níi ɗon hacaꞌ soꞌ hëbís wë filiɓ kila hom meey Eforon fi ɓëy tali Het ɗa⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","daa ri kila Makpelaa bee jaanndaꞌ gini Mamre di Kanaan ra. Abraham saam kila hacaa, daa tah ɗi lom ɓani meeya Eforon fi ɓëy tali Het na. ");
INSERT INTO ndv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Daa ri tígë hacuu Abraham a Saara ɓeleɓi ra⁠ ⁠; tígë hacuu Isaak a ɓeleɓi Rebekaa ra⁠ ⁠; mi hacaꞌ Leyaa tígí daaha ɓal. ");
INSERT INTO ndv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Meeya a kila hom na ra lomuu Hetta na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Wonaꞌ Yakop koyyi na níi wocce ra nék, ɗi yeɗɗohte tigal ka lússé, ɗeefiɗte caacci. ");
INSERT INTO ndv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tígí daaha, Suseef líhëhté sun fi boffi kíp, yabaalohte rii na, looyte ri níi tallilaay muun. ");
INSERT INTO ndv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Ɗi antee nah ɓoyoh ya homu faami ra yugus ɓúudé fë. Wa lahute waal sabay iniil (40) yugusi ɓúudé fí Yakop, ti ɗee ɓaahuu wa ri nen. Hente waal sabay paana (70), ɓëy Ésíp na looyu luuyi Yakop. ");
INSERT INTO ndv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Gétëꞌ ƴaa ɓéeɓ rë, Suseef won dakki buur tih⁠ ⁠: «⁠ ⁠Hém neɓaꞌ ron, mi fahaꞌ biti koon ɗon woniɗ soꞌ buur tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","leɓaꞌ bisi ra, baasoꞌ húmú wonte soꞌ biti ɗi hacce nuŋi Kanaan níi wocce, te ri nahte soꞌ níi mi añohte biti ɗi húl rëe may rii hacee na. Mi ɗaŋ biti koon buur on soꞌ ndín, mi pay haji baasoꞌ⁠ ⁠; luuya ɗúm rëe mi nimil.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Léhínúu buur woli Suseef ra, buur won dakka tih⁠ ⁠: «⁠ ⁠Wëní Suseef tih, di húmú ɗagaꞌ ri ri boffi níi ri añohte, lah ri paya hacaꞌ ri na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Na saañ Suseef haji boffi ra, ñéerëꞌ a dakki buur ɓéeɓ, a ɓëewë lahu tii faam buur ra, a ɓëewí gaanni Ésíp ɓéeɓ⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Suseef a ɓëy faami ɓéeɓ ñéerúu ɓal, a koy-baappi a ɓëy faam boffi ɓéeɓ. Henay tuŋka a yuppa, wa heluy yin kay Gosen. ");
INSERT INTO ndv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","I wëtíir sah a soldaarri yaaguu pënís daa ɓedu Suseef. Ɗuuli ɓëewë teem ɗí gaan⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tílúu wë níi wa lahute Baacaa ya Peek fa ra, di énfí laahi Yurdeŋ, wa looyute na looyi misikke. Suseef looyte luuyi boffi waal paana daaha. ");
INSERT INTO ndv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ɓëy Kanaanna dékú daaha ra, oluu wa ɓëy luuya Baacaa ya Peek fa, wonu tih⁠ ⁠: «⁠ ⁠Bee waɗti hena luuy ɓëyí gaante Ésíp.⁠ ⁠» Tahte níi wa wonuu énfí Yurdeŋ daaha Abeel-Misrayim, daa ri⁠ ⁠: luuyi Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ɗee nahaꞌ ri Yakop ra, koyyi paguu ri ɗaaha⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","wa kúrúté ɓúudé fí Kanaan, hacute ri kila Makpelaa. Abraham húmú lomaꞌ kila a meeya jaanndaꞌ Mamre ra yaꞌ Eforon Heda. Ɗi húmú lom kila hacaa. ");
INSERT INTO ndv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Wocaꞌ hacada ra, Suseef, koy-baappi a ɓëewë ɓedu wa luuyi boffi wa ra ɓéeɓ nimilute Ésíp. ");
INSERT INTO ndv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Lahuu wa faam ra, koy-baappi Suseef na wonantuu filiɓ fi wa⁠ ⁠: «⁠ ⁠Mbaa bee húlëꞌ baap bee ra Suseef ii yíssëh sun fi yen, yíllëh yii misiga húmú pagu yen ri ra⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tígí daaha, wa woluute Suseef na wonu ri tih⁠ ⁠: «⁠ ⁠Na húlëy baap doom ra, won lah fun wonun ro tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","fu ƴíiɗ ɗii na, fu baal fun yii ɓosi misiga húmú pagu ro fun ra. Kon fun na ɗagu ro, fu baal fun yii ɓosi bah, ndée fun habu Koope fa na húmú jaamiyoh baap ra.⁠ ⁠» Léhínúu rí, Suseef yíppé afi na looy. ");
INSERT INTO ndv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Koy-baappi daa míllúu payiɗ affi wa, hawuute feey, líhúuté fíyí wonu ri tih⁠ ⁠: «⁠ ⁠Fun aƴeh⁠ ⁠! Habaꞌ fun ñaammu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ndaa Suseef won wa tih⁠ ⁠: «⁠ ⁠Ngënë néekíñíi yin soo na⁠ ⁠! Mi Koope neh⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ɗon húmú koluu paŋi soꞌ yin ɓos koon, ndaa Koo yídíssé rí yin wun. Di oluu ron ri, daa ri ñeyaꞌ ri daaha, nda ri mín tos ñíin caak. ");
INSERT INTO ndv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kon ngënë néekíñíi⁠ ⁠: may kúɗ ɗoni koyyi ron.⁠ ⁠» Unna won wa Suseef ra yëellíɗté keeññi wa. ");
INSERT INTO ndv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Suseef a ɓëy faam boffi homute Ésíp yii maañce. Suseef pesse kíil tíméer a kíil sabboo (110). ");
INSERT INTO ndv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ɗi otte níi séttí Efarayim⁠ ⁠; ɓaatte biti límúu koyyi Makiir fi Manase ra, wa tíkúté ɓaŋŋi. ");
INSERT INTO ndv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Leɓaꞌ bisi ra, Suseef won ɓëy faam boffi tih⁠ ⁠: «⁠ ⁠May húlé, ndaa hëbíi biti Koope ay ron habraꞌ níi ɗúhíɗ rën deh, kúɗ ɗën gina gap ri Abraham, Isaak a Yakop, añohte ra. ");
INSERT INTO ndv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Gëpí sëꞌ te ɗon añoh biti bín fë rëe, ɗon ii hel ƴuh yi soꞌ deh⁠ ⁠; lah kúrëelíi wë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Na húl Suseef Ésíp rë, ɗeef ɗi lahte kíil tíméer a kíil sabboo (110). Ɓúudé fë yugusute níi mínéh yah, ɓekute kees, ɗapute kolom.");
INSERT INTO ndv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Bee daa coosaani Yéesú-Kiristaa sédí buura hínú Dawit ra, sédí Abraham. ");
INSERT INTO ndv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham daa boffi Isaak, Isaak límpé Yakop, Yakop límpé Yudaa a koy-baappi. ");
INSERT INTO ndv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudaa daa boffi Peres a Seraah, Tamaar daa yaafi wa⁠ ⁠; Peres daa lím Hesron, Hesron límpé Ram. ");
INSERT INTO ndv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram daa boffi Aminadap, Aminadap límpé Nahson, Nahson límpé Salma. ");
INSERT INTO ndv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salma daa boffi Búus fí Rahap, Búus daa boffi Obet fi Rút, Obet límpé Yéssée, ");
INSERT INTO ndv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yéssée límpé buura hínú Dawit ra. Dawit daa lím Salomoo fi ɓeleɓ Úrí koon. ");
INSERT INTO ndv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoo daa boffi Robowam, Robowam límpé Abiyaa, Abiyaa límpé Asaa. ");
INSERT INTO ndv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaa daa boffi Yosafat, Yosafat límpé Yoram, Yoram límpé Osiyas. ");
INSERT INTO ndv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyas daa boffi Yotam, Yotam límpé Ahaas, Ahaas límpé Esekiyas. ");
INSERT INTO ndv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyas daa boffi Manase, Manase límpé Amon, Amon límpé Yosiyas. ");
INSERT INTO ndv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jamanaa habuu yëwúɗɗë kúrúté Babilon ra, Yosiyas límpé Yekoñas a koy-baappi. ");
INSERT INTO ndv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Filoon fi kúrí wë Babilon, Yekoñas límpé Salasiyel, Salasiyel límpé Sorobabel. ");
INSERT INTO ndv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabel daa boffi Abiyut, Abiyut límpé Eliyakim, Eliyakim límpé Asoor. ");
INSERT INTO ndv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoor daa boffi Sadok, Sadok límpé Ahim, Ahim límpé Élíyút. ");
INSERT INTO ndv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Élíyút daa boffi Eleyasaar, Eleyasaar límpé Matan, Matan límpé Yakop. ");
INSERT INTO ndv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakop daa boffi Suseef, ƴaali Maryaama fa lím Yéesú fë na wonuu Kiristaa ra. ");
INSERT INTO ndv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hente jamanu sabboo a jamanu iniil dalaꞌte Abraham na níi Dawit na, jamanu sabboo a jamanu iniil Dawit na níi bee habuu yëwúɗɗë kúrúté Babilon ra, jamanu sabboo a jamanu iniil kúrí yëwúɗɗë Babilon níi límí Buura Koo fal ri ra. ");
INSERT INTO ndv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yéesú-Kiristaa ayaꞌ ëldúnë ɗeh⁠ ⁠: Maryaama yaafi Yéesú húmú onu Suseef ɓeleɓ⁠ ⁠; na liiluu waa dék níi wa ñéerëꞌ rë nék, pagaɗɗi Ruuh-Peseŋ tahte Maryaama pokke loo. ");
INSERT INTO ndv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Suseef fa na fahaꞌ koodi ra húmú ɓëyí júɓpé te ɗi fahaay yíiñí, daa tah ɗi caŋ kotti yeɗɗi koon di filiɓ sútúrë. ");
INSERT INTO ndv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ɗi hom níɓí yii baaha, malaaka di malaaka yi Koo-Yíkëe feeñiyohte ri filiɓ heeƴ, won ri tih⁠ ⁠: «⁠ ⁠Suseef sédí Dawit, ngana sídëꞌ ɓeyi Maryaama ɓeleɓ, pagaɗɗi Ruuh-Peseŋ daa tah ɗi pok loo. ");
INSERT INTO ndv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɗi ay lahee koy ƴaal fu dëekëꞌ rí Yéesú⁠ ⁠: daa ri nay sëmlée ɓëewí di bakaaɗɗi wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iñƴaa ɓéeɓ daa yee húmú won Koo-Yíkëe ñeyaꞌte ri yonentaa, na won ri bitih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«⁠ ⁠Ay lah kúkëyí cafaƴ ki yéeh ƴaal ay pok loo, ɗi ay lah koy ki ƴaali ay hínú Emanuwel.⁠ ⁠» Tii baa daa ri⁠ ⁠: Koope ee yen na. ");
INSERT INTO ndv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yúunëꞌ Suseef ra, ɗi paŋke yee nah ri malaakii Koo-Yíkëe rë, ɓeɓpe Maryaama ɓeleɓ. ");
INSERT INTO ndv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ndaa ri ñéerëey a ri níi bee lahaꞌ Maryaama koy ƴaal ra, Suseef yeɗte ri tii Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yéesú límúu Betleꞌem di Yúdée ɗeef buura hínú Erot ra daa af nguur ka. Jamanii baaha, i saltige koluu waal púlëen naꞌ, ayute Yerusalem ");
INSERT INTO ndv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","na meeluu wonu tih⁠ ⁠: «⁠ ⁠Buuri yëwúɗɗë anuu límú rë hom dih⁠ ⁠? Fun olu hul púlté, te huli baa daa teeɓ fun biti ɗi límúté, fun anutee ac jaamiyohi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kelaꞌ Erot woni baa ra, ɗi tíitté níi tíit, ɓëy Yerusalem ɓéeɓ namutee tíit ɓal. ");
INSERT INTO ndv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ɗi dëekké yëeddëh yí kootii Mëyíis a kélfë yí seeƴoh yi Faam fi gaani Koope ɓéeɓ, meelte wa tígë húmú wonuu biti Buura Koo fal ri ra ay límúu në rë. ");
INSERT INTO ndv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Ɗi waɗti límúun Betleꞌem di Yúdée, ndée yonentaa bíníté yii bee Téerëe bitih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ɗon fi ɓëy Betleꞌem fa gini Yudaa, ngënë hëbíi biti ginon lahay solo di ginna këldúu feey fi Yudaa ra. Kélfëe nay níiré ɓëy gin soꞌ Israyel ra ay ɗúhée në.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Filoon fi baaha, Erot ñeete feey ndaŋ, dëekké saltige ya meelte wa, wa won ɗi yii lante di wahtaa púl hula waa na ra, ");
INSERT INTO ndv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","antee waa yeñ Betleꞌem won wa tih⁠ ⁠: «⁠ ⁠Pëyí ɗon meelaꞌ níi lan yii leŋke kúkëyë në. Ɗon ot ɗi raa, lah ëyí ɗon teeɓ soꞌ, nda soꞌ mi bee ɓal mi pay jaamiyohi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wonaꞌ Erot iñƴaa níi wocce ra, wa ɓeyute waala na suu. Wa homu waala, hula húmú olu wa ra púlëetté fíi wë. Lahaꞌ hula yeeddaꞌ ki tígë hom kúkëyë rë, ɗi caŋke daaha. ");
INSERT INTO ndv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Oluu saltige ya yii baaha ra, keeññi wa sosse níi sos. ");
INSERT INTO ndv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lahuu wa faam fa níi wa haalute ra, wa olute kúkëyë a Maryaama yaafi. Wa yípútée ƴek, na jaamiyuu ri. Wa anutee kúnís nafa yi wa, yerute ri yoobbol úrís, cuuraay a leefii heeñce níi heeñ na wonuu míir rë. ");
INSERT INTO ndv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Filoon fi baaha di filiɓ heeƴ, Koope wonte wa biti wa ɓanuy nimilaꞌ Erot na⁠ ⁠; tígí daaha wa ɓeyute waal kay, nimilute gin wa. ");
INSERT INTO ndv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sayuu saltige ya ra, malaakii Koo-Yíkëe feeñiyohte Suseef di filiɓ heeƴ, won ɗi tih⁠ ⁠: «⁠ ⁠Kolee fu ɓeɓ kúkëyë a yaafi fu hegoh fu saañ Ésíp, fu hom dín fë níi fu keloh un soꞌ, ndah Erot ay saamroh kúkëyë hawrohi húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ɗaaha, ɗi kolohte leelu elek, ɓeɓpe kúkëyë a yaafi, hegohte saañce Ésíp, ");
INSERT INTO ndv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","hompe dín fë níi Erot húlté. Yee húmú won Koo-Yíkëe ñeyaꞌte ri yonentaa ra lahaꞌte ɗaaha. Ɗi húmú won tih⁠ ⁠: «⁠ ⁠Mi wonte koy soꞌ koloh Ésíp.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bín fë, húmú yúhëꞌ Erot biti saltige ya nofuu ri nofoo ra, keeña haayte níi haay. Ɗi nahaꞌte hawrohi tuŋki ƴaalla límú kolaꞌte jamanaa wonu ri saltige ya biti hula púlté waa na ra, tuŋki ƴaalla lahuu kíil ana níi feey di filiɓ Betleꞌem a ginna hëbísí rë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yii baa lahaꞌte ɗah, ti ɗee húmú wonaꞌ yonente Yérémí rë bitih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«⁠ ⁠Foŋ keluute filiɓ Rama, foŋŋi misikke ñéerëꞌ a hawoh. Rasel daa na looy koyyi, kaaꞌaꞌte ɓëyí në mësíɗ rí, bi ɗúmú koyya.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Húlëꞌ Erot ra, malaakii Koo-Yíkëe feeñiyohte Suseef filiɓ heeƴ di Ésíp, ");
INSERT INTO ndv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","won ɗi tih⁠ ⁠: «⁠ ⁠Kolee fu ɓeɓ kúkëyë a yaafi fu nimil Israyel⁠ ⁠; ɓëewë na húmú fahuu hawi kúkëyë húl rë ɓéeɓ húlúté.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ɗi kolohte ɓeɓpe kúkëyë a yaafi saañce Israyel. ");
INSERT INTO ndv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kelaꞌ ri biti Arkelawus koy Erot daa took ñaani nguur ka di Yúdée rë, ɗi kaañay lah dín fë. Di filiɓ heeƴ Koope nahte ri saañ Galile. ");
INSERT INTO ndv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Lahaꞌ ri ra, ɗi yíppé faami gina na wonuu Nasaret ra hompe na. Yee húmú wonu yonente ya ra lahaꞌte ɗaaha. Wa húmú wonu tih⁠ ⁠: «⁠ ⁠Ɗi ay dëekúu ɓëy Nasaret.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kíil caak filoon fe, lahte ɓëyí hínú Saŋ Batis teekirohte luufi Yúdée na waare ");
INSERT INTO ndv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","na won tih⁠ ⁠: «⁠ ⁠Lëfí pesaɗ⁠ ⁠! Nguur ki sun-Koo leɓohte.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Saŋ daa ɓëeꞌ na húmú wonaꞌ yonente Isayii ra, na won ɗi bitih⁠ ⁠: «⁠ ⁠Lahte un ɓëyí ɗofohte luufa na won tih⁠ ⁠: “Ɗëɗɗí Yíkëe waal, ɗon yugusiɗ ɗi waalla nay rii ñeye ra níi júɓ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Saŋ húmú ɓekaꞌ búubí yugusuu a fënúf géléem, ɗi pokoh geñu hun kinohi⁠ ⁠; ɗi húmú pesaꞌ paƴ a kúum. ");
INSERT INTO ndv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɓëewë na húmú ayu ɗii na ra, ƴee koluu Yerusalem, ƴee ginni kayya Yúdée ɓéeɓ, ƴee ginna ɓúk laahi Yurdeŋ ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wa húmú ayuu Saŋ na, wa wone bakaaɗɗi wa, ɗi bëtsé wë filiɓ laahi Yurdeŋ. ");
INSERT INTO ndv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fariseŋ a saduseŋ caak ayute bëtsëh Saŋ na ɓal. Olaꞌ ri wa, ɗi won wa tih⁠ ⁠: «⁠ ⁠Tisoh yi hiliññi ƴeh⁠ ⁠! Daa won ɗon biti ɗon mínú hegoh daanee ke Koope na ac ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hena biti kaah ɗon lofute pesaɗ raa, lah téeɓíi rí pagaɗɗon. ");
INSERT INTO ndv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ngënë hëbí affon biti ɗon séttí Abraham rek doyte. Mee ron won ra ee biti Koope mín yídís laꞌ yi ƴeh, wa hen séttí Abraham⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","«⁠ ⁠Wëettíyíi affon⁠ ⁠! Yíinë caŋke lecaꞌi kilikka tal-tal ka⁠ ⁠; kilki límëy koy ki lahte njiriñ ɓéeɓ ay lecu, betu kíi. ");
INSERT INTO ndv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Soꞌ mi beh, mi bëtsëꞌ ron a muluɓ, teeɓaꞌi biti ɗon lofute pesaɗ. Ndaa lahte ɓëyí ee ac filoon soꞌ ra, ɗi luk soo gaan fap⁠ ⁠: mi haaƴayti liil kotti. Ɗi fi bah, daa ri nay ron bëtsée a Ruuh-Peseŋ a kíi. ");
INSERT INTO ndv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɗi hampe ifi yaꞌi⁠ ⁠: ɗi ay faaɗ too ka, soɗ peba misahi, tam fikiɗ fa filiɓ kíi kí ƴíméeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bín fë, Yéesú kolaꞌ Galile acce bëtsëhSaŋ Batis na laahi Yurdeŋ. ");
INSERT INTO ndv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Saŋ na fahaꞌ kaaꞌ won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi waɗti bëtsëe ɗoo na neh, fu na ac soo na a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Tahe yen henaꞌ ri ɗaaha naꞌ-naꞌ. Yen waɗ ɗii henuun ɗaaha, paŋi yii fahaꞌ Koo ɓéeɓ.⁠ ⁠» Tígí daaha, Saŋ tahte bëtsí. ");
INSERT INTO ndv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bëtsë beh, Yéesú na ɗúh mulaa, sun-Koo kúnsëhté sun fi, ɗi otte Ruuh-Peseŋ na cép man bëdú nen, acce yampe sun fi. ");
INSERT INTO ndv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wahtii baaha, un kolaꞌte sun na won tih⁠ ⁠: «⁠ ⁠Bee daa Koy soꞌ⁠ ⁠! Mi fahaꞌte ri níi fahaꞌ⁠ ⁠! Keeñ soꞌ sosse ɗii na níi sos⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Filoon fi baaha, Ruuh-Peseŋ yeñce Yéesú luufa, nda Seytaane saam fíirí. ");
INSERT INTO ndv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ɗi hompe dín fë, túmëy yin loyi níi hente waal sabay iniil (40), ñamay naꞌ ñamay elek⁠ ⁠; yaabi misikke míllëꞌté ríi ham. ");
INSERT INTO ndv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tígí daaha, Seytaane acce won ɗi tih⁠ ⁠: «⁠ ⁠Hena biti fu Koy Koope kaah raa, túuƴé laꞌ yí ƴee yíssëh ñam.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yéesú won ri tih⁠ ⁠: «⁠ ⁠Bíníyúté Téerëe bitih⁠ ⁠: “Ow pesaꞌ ñam neh kut. Yii na won Koope ɓéeɓ ow mín ɗíi pesaꞌ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tígí daaha, Seytaane kúɗté rí Yerusalem gini selaa, cëgíɗté rí jibi Faam fi gaani Koope, ");
INSERT INTO ndv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","antee rii won tih⁠ ⁠: «⁠ ⁠Hena biti fu Koy Koope kaah raa, yeɗɗee feey. Bíníyúy Téerëe biti Koope ay nah malaaka yi níirú, wa meeɓ ro teŋel, toñeh fay kabinee laꞌ woo⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Bíníyúté Téerëe biti ɓal⁠ ⁠: “Koo-Yíkëe daa Koope fu, ngana saam olsohi.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seytaane ɓeyilte Yéesú kúɗté rí daŋi utte níi ut, teeɓpe ri ginna ëldúnë ɓéeɓ a ɗee wunaꞌ wa ra, ");
INSERT INTO ndv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","antee rii won tih⁠ ⁠: «⁠ ⁠Fu ƴek fíi sëꞌ fu jaamiyoh soꞌ raa, mi yeɗ ɗo wa ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yéesú won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Gété dín Seytaane⁠ ⁠! Bíníyúté Téerëe bitih⁠ ⁠: “Fay ƴekre Koo-Yíkëe daa Koope fu ra te fay jaamiyee ri kut.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Seytaane kolaꞌ daaha saañce. Malaaka ya yípútée ac na tooppituu Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hompe níi Yéesú kelohte biti Saŋ ɓekute kasu. Ɗi kolaꞌ daaha saañce Galile. ");
INSERT INTO ndv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Lahaꞌ ri ra, ɗi homay Nasaret, ɗi saañ Kafarnawum gina hom ɓúk laahi Galile ra di deyi Sabuloŋ a Neftali. ");
INSERT INTO ndv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yii baa lahaꞌte ɗah ti ɗee húmú wonaꞌ yonente Isayii ra nen bitih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«⁠ ⁠Deyi Sabuloŋ a Neftali homu ɓúk laaha ra, deya hom hatni yíníi Yurdeŋ ra, Galile fa dékú ɓëewë yëwúɗ neh ra⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ɓëewë húmú pesuu ñúusë rë olute niiñi hente saw. Ɓëewë húmú pesuu tígí ñúusë hom kúl kë rë, lahte niiñi púlté waa na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kolaꞌte baaha, Yéesú dalte waarii ɓëewë na won tih⁠ ⁠: «⁠ ⁠Lëfí pesaɗ⁠ ⁠! Nguur ki sun-Koo leɓohte.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lahte bis, Yéesú hom tílëesëh ɓúk laahi Galile, ɗi otte ow ana⁠ ⁠: Simoŋ fa na wonuu Peer ra a Anndere koy-yaafi na bacu mbaali wa laaha. Wa húmú i seeɓoh. ");
INSERT INTO ndv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ɗi dëekké wë won wa tih⁠ ⁠: «⁠ ⁠Ñéyí tal soꞌ mi yëedíɗ ɗon, ɗon hen seeɓoh ow.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wa yípútée hel mbaalli wa, ñeyute tala. ");
INSERT INTO ndv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tílëꞌ Yéesú níi lahte fíi rë, ɗi otte koy-yaay ana kay⁠ ⁠: Saak a Saŋ koyyi Sebede, ɓani boffi wa homute filiɓ gaali wa, na yugusu mbaalli wa. Ɗi dëekké wë, ");
INSERT INTO ndv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","wa yípútée hel gaala daaha a boffi wa, ñeyute tala. ");
INSERT INTO ndv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yéesú ñeete Galile ɓéeɓ, na yëeddëꞌ filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra, na waare Uni Nebi Nguur ki sun-Koo, na paƴ heet jér a heet misik ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tiyi hente lëyëŋ filiɓ Sírí ɓéeɓ. Ɗi komute jéríɗɗë ɓéeɓ, ƴi maduy jér⁠ ⁠: ƴee lahuu yébítëh, ƴee lahuu jérí kéenɗëꞌ wë kéenɗëe, ƴee i lëfëñíɗ. Ɗi paƴce wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ow caak ñeyuu tal Yéesú⁠ ⁠: ƴee koluu Galile, ƴee gina na wonuu Gin-taah-sabboo ra, ƴee Yerusalem a ginni kayya Yúdée ɓéeɓ, ƴee ginna énfí laahi Yurdeŋ. ");
INSERT INTO ndv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Olaꞌ Yéesú dúukëlí ɓëewë rë, ɗi lappe sun daŋ tookke, taalibe yi gíiwúté rí, ");
INSERT INTO ndv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ɗi yampe na yëedíɗ wë won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«⁠ ⁠Lahute sos-keeñ ɓëewë yúhrú affi wa biti wa sohluute Koope ra⁠ ⁠: daa wa lahuu Nguur ki sun-Koo. ");
INSERT INTO ndv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lahute sos-keeñ ɓëewë na looyu ra⁠ ⁠: Koope ay waa mësíɗ. ");
INSERT INTO ndv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lahute sos-keeñ ɓëewë sosu ra⁠ ⁠: Koope ay waa yeɗ ëldúnë. ");
INSERT INTO ndv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Lahute sos-keeñ ɓëewë fahuu paŋ yii júɓpé kep ra⁠ ⁠: Koope ay waa on yii fahaꞌ wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Lahute sos-keeñ ɓëewë naaꞌu keeñ ra⁠ ⁠: Koope ay naaꞌ-keeñ waa na. ");
INSERT INTO ndv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Lahute sos-keeñ ɓëewë ladu keeñ ra⁠ ⁠: wa ay ot Koope. ");
INSERT INTO ndv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Lahute sos-keeñ ɓëewë saamuu jaamma ra⁠ ⁠: Koope ay waa habaꞌ koyyi. ");
INSERT INTO ndv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Lahute sos-keeñ ɓëewë yéŋké biti paŋ yii júɓpé daa na tah wa moklu ra⁠ ⁠: daa wa lahuu Nguur ki sun-Koo. ");
INSERT INTO ndv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«⁠ ⁠Ɗon lahute sos-keeñ, ɗon fa af soꞌ ay tah ɓëewë sol ron, mokil ron, tílé wone yin ɓos ɓéeɓ sun fon ra. ");
INSERT INTO ndv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dëmíi, keeññon sos níi sos, waafi mitte ín ɗon seh sun-Koo ra. Yúhí biti yonente yee merees húmú mokluu ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon daa miraa mi ëldúnë. Miraa mi ƴaa lahlilay cafka raa, wa ay nimiliruu cafkii wa ɗíh⁠ ⁠? Wa lahlilay njiriñ, wa ay yúfú baaŋŋin kotta togisaꞌ wa. ");
INSERT INTO ndv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«⁠ ⁠Ɗon daa niiñi ëldúnë. Gini yípú sun daŋ mínéh ɗapoh. ");
INSERT INTO ndv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lampa këɗɗúy biti ɗi ay líhú if sun. Ɗaaha neh⁠ ⁠! Ɗi ay líkú líkë niiñlii ɓëy faam fa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ɗon waɗti madun ɗaaha nen fíi ɓëewë. Hen ɗaaha wa ot pagaɗɗi wunnon raa, wa ay kañ Boffee ke ron sunaa-sun.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ngënë hëbíi biti mi ac nísí yee won Kootaa ra a iña bíníyú yonente ya ra. Ëe-ëeꞌ⁠ ⁠! Mi aay baaha, mi ac cëgírí wë níi mit. ");
INSERT INTO ndv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mee ron won kaaf ka ra ee bitih⁠ ⁠: hém sun a feey ee na, koy una lukki ƴin Kootaa ra ii naa koloh, yin ƴutuuɗ sah ii naa okotoh níi bín paamaa iña ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Daa tah ɓëyí ñeyay wuti ƴaha túuƴëꞌë lukki ƴin ɗa, an naa kúrëelëh ow kay raa, ɓëyí baa nay lukee ƴin Nguur ki sun-Koo. Ɓëyí ñee iña túuƴúu rë rëe nék, anti ɓek ow kay paŋi wa raa, ɓëyí baa ac ow gaan Nguur ki sun-Koo. ");
INSERT INTO ndv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mee ron won ɗa ee bitih⁠ ⁠: hena biti ɗon lúkíh yëeddëh yí kootii Mëyíis a fariseŋŋa júɓ rëe, yúhí biti ɗon ii hëelíɗ Nguur ki sun-Koo.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon keluuy yee húmú yëeddú caacci yen ra keloo a⁠ ⁠? Wa húmú wonute bitih⁠ ⁠: “Ngënë mësíi bëem ow, te ɓëyí bëem ow ɓéeɓ ay aattiyuu.” ");
INSERT INTO ndv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Soꞌ nék, mi won ɗon tee ɓal⁠ ⁠: ɓëyí neeɓaꞌ koy-yaafi sah ay aattiyuu. Ɓëyí sol koy-yaafi ay tëekrú këem. Ɓëyí tíkëy koy-yaafi ow ay ɓeku safara tam. ");
INSERT INTO ndv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«⁠ ⁠Kon fu waaƴ hawiɗ raa, fu home dal nufu anti pay biti fu paŋke koy-yaafu yii neɓaay ri raa, ");
INSERT INTO ndv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hele yee nay fu hawe ra daaha, fu pay paaƴ ɗoni júɓëꞌ, fanti nimil fu hawiɗ Koope. ");
INSERT INTO ndv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«⁠ ⁠Ow yam ɗo yin níi ɗoni saye faam buur raa, ɗon lah waala, lah yípée saam biti ɗoni júɓëꞌ, toñeh ɗoni lah dín fë ɗi ey ro, buur tík rë yaꞌ yi alkaati ya, fu téƴú. ");
INSERT INTO ndv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mee ron won kaaf ka ra ee⁠ ⁠: fii ɗúh kasaa níi bín yínlëe fu kabut ka ɓéeɓ rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon keluute biti ɓal húmú wonu tih⁠ ⁠: “Ngënë mësíi njaaliyoh.” ");
INSERT INTO ndv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Soꞌ nék, mi won ɗon tee ɓal⁠ ⁠: ɓëyí olsoh ɓeleɓ níi nufa tas ɗii na kep, ɗi njaaliyohte nufi. ");
INSERT INTO ndv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kon hena biti ílú ay roo ɓeke bakaaɗ raa, lukute ri fu bet baaŋŋin. Fu ñak cér yínë daa gén biti faanu ɓéeɓ betu safara. ");
INSERT INTO ndv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te hena biti yaꞌu ay roo ɓeke bakaaɗ raa, lece ri fu bet baaŋŋin. Fu ñak cér yínë daa gén biti faanu ɓéeɓ betu safara.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Wonute biti ɓal⁠ ⁠: “Ɓëyí yes ɓeleɓi raa, saamɗa ri kéedí nay teeɓee yii baaha.” ");
INSERT INTO ndv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Soꞌ nék, mee ron won ra ee⁠ ⁠: ɓëyí yes ɓeleɓi ɓéeɓ te ɗeefa ɓelaa habuuy a ƴaal, ɗeef ɗi ɓek ri njaaliyoh. Te ɓëyí kooɗ ɓelii yesute ɓéeɓ, njaaliyohte ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon keluute biti ɓal caacci yen húmú yëeddúté biti ow waray hon uni, te ɓëyí añoh fíi Koo-Yíkëe ɓéeɓ waɗtee paŋ yii baaha. ");
INSERT INTO ndv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Soꞌ nék, mi won ɗon tee ɓal⁠ ⁠: ngënë ëñíi yínë sah⁠ ⁠! Ngënë ëñíi níi ɗon cap sun-Koo, daa ri ñaani Koope. ");
INSERT INTO ndv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ngënë ëñíi níi ɗon cap feey fa, Koope tíkëꞌ kotti na. Ngënë ëñíi níi ɗon cap Yerusalem, daa ri gin Koope buuri gaana. ");
INSERT INTO ndv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ngënë ëñíi sun fon sah, ɗon fa míníh pohoɓil mbée ɗon súulíɗ koy fen yínë sah affon ra. ");
INSERT INTO ndv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ƴaha biti ɗon ay wone “íi” rëe, wëní “íi” kut ɗon teem daaha. Ƴaha biti ɗon ay wone “ëe-ëeꞌ” rëe, wëní “ëe-ëeꞌ” kut ɗon teem daaha⁠ ⁠; yii ɓaat ow sun kolaꞌ ri Seytaane na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon keluute biti ɓal húmú wonu tih⁠ ⁠: “Ɓëyí gúl íl ow, ílí ay gúlú⁠ ⁠; ɓëyí kon sís ow, sísí ay kodu.” ");
INSERT INTO ndv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Soꞌ nék, mi won ɗon tee ɓal⁠ ⁠: ow paŋ ro yin ɓos raa, ngana yíllëh. Ow mbeƴ ro kakaabi bee raa, lah yere ri kakaabi yínëe. ");
INSERT INTO ndv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ow fahaꞌ tëekrú këem yeegi búubú rëe, lah ɓaate ri búubë lukki wun ɗa. ");
INSERT INTO ndv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ow en ɗo yin tíllëh rë tígí hécëhté rëe, lah ñéyrée a ri níi tuꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɓëyí ɗaŋ ro one ri. Ɓëyí wot ɗo yin, ngana súugëh rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon keluute biti ɓal húmú wonute bitih⁠ ⁠: “Lah fëhíi moroommon, ɓëyí kaaꞌ ron, ɗon kaaꞌ ri.” ");
INSERT INTO ndv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Soꞌ nék, mi won ɗon tee ɓal⁠ ⁠: lah fëhíi kaaꞌoh yon, ɗon ɗagiɗ ɓëewë na moklu ron ra. ");
INSERT INTO ndv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ɗon ay teeɓee biti ɗon koyyi Boffee ke ron sunaa-sun ɗaaha, ɗi fa ɗúhrëꞌ naꞌa sun fi ɓëewë wunu a ƴee ɓosu ɓéeɓ rë. Ɗi toɓɗaꞌ ɓëewë júɓú a ƴee júɓúy rë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hena biti ɗon fahuun ɓëewí fahuute ron kut raa, ɗon séentúu në waafi mën ɗíh⁠ ⁠? Yeekoh yi túmë sah na pagu baaha. ");
INSERT INTO ndv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ɗon woduun koy-yaayyon kut raa, ɗeef ɗon pagu yii gaani bih⁠ ⁠? Ɓëewë nëníh ɓëewí Koope ra sah na pagu baaha. ");
INSERT INTO ndv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kon di man Boffee ke ron sun júɓ níi júɓ, lah mëdí ɗaaha nen júɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yéesú ɓaatte wonil tih⁠ ⁠: «⁠ ⁠Mëytíi⁠ ⁠! Ɗon ƴahti paŋ iña nahaꞌ Koope raa, ngënë téeɓíi affon. Henay bah, ɗon ii liil waafi Boffee ke ron sunaa-sun. ");
INSERT INTO ndv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kon ɗon ƴahti on ñëkíɗ rëe, ngënë téeɓíi rí níi ɓëewë ɓéeɓ yúh baaha. Ɓëewë fahuu teeɓaꞌi affi wa ra daa na henu ɗaaha filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra a këemmë. Ƴaaha ɓéeɓ, wa fahuu biti ɓëewë yeelaꞌ wa ow gaan. Mee ron won kaaf ka ra ee biti wa liilute waafi wa níi wocce. ");
INSERT INTO ndv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ɗon nék, ɗon home on ñëkíɗ rëe, yaꞌi sugu fon ɓanan yúh yee paŋ yaꞌi ñamaa fon ra. ");
INSERT INTO ndv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Onaꞌ neɓpi hena sútúrë ɗaaha. Hen ɗaa raa, Boffee ke ron yin úmpéyéh rí rë ay ron yíníl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon ƴahti ɗaŋ raa, ngënë mëdíi a ɓëewë fahuu teeɓaꞌi affi wa ra. Wa ƴahti ɗaŋ raa, wa hom caguu cagoo ílíƴƴë na ɗaguu yëwúɗɗë Koope ra mbée këemmë. Wa hom fahuu biti ɓëewë ɓéeɓ ot wa. Mee ron won kaaf ka ra ee biti wa liilute waafi wa níi wocce. ");
INSERT INTO ndv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ɗon nék, ɗon ƴahti ɗaŋ raa, lah hëelí las, ɗon won ílë affon, ɗon ɗapoh, ɗon anti ɗaŋ Boffee ke ron ee tígí ɗapohte sah ra. Hen ɗaaha raa, ɗi fa yin úmpéyéh rí rë ay roo yíníl. ");
INSERT INTO ndv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«⁠ ⁠Ɗon ƴahti ɗaŋ raa, ngënë cëekí won ti ɓëewë nëníh ɓëewí Koope ra nen. Wa habuu biti woni caaga nay tahe Koope tah ɗaŋi wa. ");
INSERT INTO ndv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ngënë mëdíi a wa, Boffon yúh iña sohluu ron ra balaa ɗon ɗaŋ ri. ");
INSERT INTO ndv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«⁠ ⁠Kon lah ɗëgíi ɗeh⁠ ⁠: Koo, Boffi fun fa sun, ɓëewë yúhún biti tiyu selate. ");
INSERT INTO ndv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nguur ku lahan ɓëewë në. Ɓëewë feey fa ñeyun yee fahaꞌ fu ra, ti di lahaꞌ ri sun nen. ");
INSERT INTO ndv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","On fun njélí woteh. ");
INSERT INTO ndv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Baal fun tooññi fun, ti di na baaluu fun ɓëewë tooñu fun ɗa nen. ");
INSERT INTO ndv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ngana yeris nuf ɓos haal fun. Sëmlëꞌ fun yaꞌ Seytaane. Ɗémíin⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«⁠ ⁠Ahaŋkay, ɗon baal ɓëewí kayya tooññi wa raa, Boffee ke ron sun ay ron baal ɓal⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ɗon baaluy wa raa nék, Boffon ɓal ii ron baal tooññon⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«⁠ ⁠Ɗon oor raa, ngënë ñúusɗí kanammon ti ɓëewë fahuu teeɓaꞌi affi wa ra nen. Wa oor raa, wa ay paŋ kanammi wa yin níi ɓëewë ɓéeɓ yúh biti wa oorute. Mee ron won kaaf ka ra ee biti wa liilute waafi wa níi wocce. ");
INSERT INTO ndv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ɗon nék, ɗon oor raa, lah mëdí ti di madu ron merees nen ");
INSERT INTO ndv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","níi ow ɓanti yúh biti ɗon oorute, hém henay Boffee ke ron hom tígí ɗapohte sah ra. Hen ɗaaha raa, ɗi fa yin úmpéyéh rí rë ay ron yíníl. ");
INSERT INTO ndv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«⁠ ⁠Ngënë gërí alal feey fi beh, tígí maasoh fa a homaaga yahaꞌ yahoo ra, tígí lohoh ya powuu faamma powoo ra. ");
INSERT INTO ndv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gëríi alal sun-Koo kay, tígí lahay maasoh, lahay homaak, lahay lohohi ay poye faam. ");
INSERT INTO ndv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yúhí biti tígí hom alal mon, nuffon homaꞌ na ɓal. ");
INSERT INTO ndv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«⁠ ⁠Íl daa lampa faan⁠ ⁠: kon íllú wah raa, fu homaꞌ leelii niiña⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ndaa íllú neɓay raa, fu homaꞌ leelii ñúusë. Kon hena biti niiña ɗoo na ñúus rëe, fay home ñúusí mën ɗí kan⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«⁠ ⁠Lahay súrgíi mín légéyíɗ kélfë ana⁠ ⁠: ɗi ay kaaꞌ ow yínë waa na, pokoh ɓëyí yínëe në⁠ ⁠; ɗi ay ñee won ow yínë waa na, kaaꞌ síkírëhí ɓëyí yínëe. Ti ɗaaha nen, ɗon míníh boollaꞌ foŋko Koope a foŋko hélíis. ");
INSERT INTO ndv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«⁠ ⁠Yii baa daa tah mi won ɗon tee⁠ ⁠: ngënë sídíi yii ñamun ron, mbée yii ɓekuun ron. Pes lukeh ñam lah solo, te faan lukeh yéré lah solo ɓal a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ëlsíi ƴakka⁠ ⁠: wa na sëhíh níi púlé lec, wa na túmíh misah. Íníh ee Boffee ke ron sun ee waa ñëmíɗ ɗë ë⁠ ⁠? Ɗon lúkíh wëe lah solo a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wa ɗon na, sídëꞌë në sídëꞌ rí rë, mín fehe níi ɓaat yin ƴutuuɗ pesi⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","A yii leŋke búubí nay ron ɓekee, ɗon sídúu yí në⁠ ⁠? Ëlsíi ɗee man capussi gaaw fa luufa ra⁠ ⁠: wa na légéyíh te wa na mëkíh ɗíis búuɓ. ");
INSERT INTO ndv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Añcaŋ mee ron won ra ee⁠ ⁠: ɗi fi buura hínú Salomoo ra sah, húmú lahaꞌ ri alal níi, ɗi lahay búuɓɓí madaꞌ a capussi gaaw fi ƴaa wun⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ngémën tasaꞌte ee⁠ ⁠! Koope posil gaaw fa luufa woteh níi wa man ɗaaha wun, te teem kéy wa ay luuhu tamu raa, ɗi ay lukee ɓek ɗon fi ƴaa búuɓ neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kon ngënë sídíi yii ñamun ɗon, mbée yii hanun ɗon, mbée yii ɓekuun ɗon⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ɓëewë nëníh ɓëewí Koope ra daa na moklu affi wa saami iñƴaaha ɓéeɓ. Boffee ke ron sun yúhté biti ɗon sohluute wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kon Nguur ki Koope a yee fahaꞌ ri ra daa mit saam⁠ ⁠; bee tas ɗa ín yaꞌ Koo⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ngënë sídíi yii nay lahe kéy⁠ ⁠: kéy daa lahaꞌ afi. Bisi ac ɓéeɓ a coono fi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yéesú ɓaatte wonil tih⁠ ⁠: «⁠ ⁠Ngënë héefí ow toñeh Koope ay ron heefe. ");
INSERT INTO ndv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ɗon ay heefuu ti ɗee na heefuu ron ow ra. Ɗee na natɗuu ron ɓëewë rë, Koope ay ron natɗee ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Fu olsoh yi losa íl koy-yaafu te fu kénsëey dúuñë ílú⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ɗo fa olay sah dúuñë ílú rë, fu mínëꞌ won koy-yaafu biti fay rii nísíɗ losa ílí ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wonu teem ɓúkú⁠ ⁠! Nísé dúuñë ílú níi íllú lan paaƴ, fanti mín nís losa íl koy-yaafu. ");
INSERT INTO ndv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«⁠ ⁠Ngënë ëní ɓuh yii selate, toñeh ɗi ay wëlbítée sun fon ɗoɓisaꞌ ron. Ngënë bétí feme yon kot mbaam-túgël, toñeh ɗi ay waa togisee. ");
INSERT INTO ndv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«⁠ ⁠Ɗëgí ɗon ay onu, sëemí ɗon ay ot, lëɓí ílë ɗon ay kúnsírú. ");
INSERT INTO ndv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ahaŋkay⁠ ⁠! Ɓëyí ɗaŋ ay onu, ɓëyí saam ay ot, te ɓëyí laɓ íl ay kúnsírú. ");
INSERT INTO ndv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wa di ɗon na nay yere koohi laꞌ biti ri ɗaga ri ñam, ");
INSERT INTO ndv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","mbée koy ka ɗaga ri jén rëe ɗi yeɗ ri goŋ⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɓosuu ron níi, ɗon mínú pagiɗ koyyon yin wun. Kon ɗon mínú yii baaha raa, ɗeef lukaꞌ Boffee ke ron sunaa-sun neh⁠ ⁠: ɓëyí ɗaŋ ri, ɗi ay rii on yin wun. ");
INSERT INTO ndv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«⁠ ⁠Iña fahuu ron biti ɓëewë pagiɗ ron wa ra ɓéeɓ, lah pëgíríi wë ɓëewí kayya ɗaaha⁠ ⁠: yee yëeddëꞌ Kootaa a yonente ya ra ɓéeɓ daa ri bah. ");
INSERT INTO ndv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«⁠ ⁠Lah hëelíi ílí ƴutuuda. Ílí gaana, waali haŋa hom yullaꞌ ow saŋku te ow caak ñeyuu na. ");
INSERT INTO ndv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ílí ƴutuuda a waali hada nék yullu pesa na ɗúméh rë, te ow caak oluy wa. ");
INSERT INTO ndv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«⁠ ⁠Lah mëytíi yonente yi paɗɗah ya⁠ ⁠! Wa ayuu ɗon na sos ndaa wa madu gúmú nen ɓos nuf. ");
INSERT INTO ndv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ɗon ay waa yúhsée pagaɗɗi wa. Daa ëlíɗ ñoltok límpé koy sún, mbée tal hak lím koy ɓaꞌ⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ti ɗaaha nen, tal kilki lahte njiriñ na líméh koy ki lahay njiriñ⁠ ⁠: ɗi ay mínée lím bi lahte njiriñ kay⁠ ⁠! Te tal kilki lahay njiriñ na líméh koy ki lahte njiriñ⁠ ⁠: ɗi ay mínée lím bi lahay njiriñ kay⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tal kilki na líméh koy ki lahte njiriñ ɓéeɓ ay lecu betu kíi. ");
INSERT INTO ndv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mi won ɗon tee ɓal⁠ ⁠: ɗon ay yúhsée yonente yi paɗɗah ya pagaɗɗi wa. ");
INSERT INTO ndv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«⁠ ⁠Ɗon dékée dëekëꞌí sëꞌ Yíkëe, ɓekeh ron Nguur ki sun-Koo. Ɓëyí fahaꞌ naa haal raa, fay page yee fahaꞌ Boffee ke soꞌ sunaa-sun ɗa. ");
INSERT INTO ndv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ɓëewë ƴahti aattiyuu fayu raa, i ow caak ay hom daa wone soꞌ tih⁠ ⁠: “Yíkëe, fun húmú ƴahti léhín unni kolaꞌ Koope na raa, fun këllírúu tiyu neh a⁠ ⁠? Fun húmú ƴahti lík yébítëh rëe ɓal, fun këllírúu tiyu neh a⁠ ⁠? Fun húmú këllírúu tiyu neh ɓal, biti fun ƴahti paŋ i kimtaan a⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tígí daaha may waa wone tih⁠ ⁠: “Yen neh⁠ ⁠! Mi mësëy rën yúh⁠ ⁠! Wúlíi sëꞌ, ɗon fa na ñéyíh woni Koope ra⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«⁠ ⁠Ɓëyí síkírëh unna won mi ƴaa ra te pagaa wa ɗaaha raa, ɓëyí baa madaꞌ a ɓëeꞌ hof baa yíp faami ngaŋa ra. ");
INSERT INTO ndv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Koo lasse bacal, húlúɓɓë hútté níi mulaa basse, ñéerëꞌté a ngilaaw gaan, wa baɓuute faam fa, ndaa faam fa keenay af biti ri yípú ngaŋ. ");
INSERT INTO ndv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ndaa ɓëyí síkírëh unni soꞌ te pageeh wa ɗaaha raa, ɗi madaꞌ a ɓëeꞌ hofay baa yíp faami koloñ ra. ");
INSERT INTO ndv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lasaꞌ bacala ra, húlúɓɓë hútté níi mulaa basse, ñéerëꞌté a ngilaaw gaan wa baɓuute faam fa, faam fa bëppé yahsaꞌte ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wocaꞌ Yéesú wona ra, ɓëewë ɓéeɓ éemúté ɗee na waariyaꞌ ri ra, ");
INSERT INTO ndv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ndah di na yëeddëꞌ rí maday a di na paguu ri yëeddëh yí wë na yëeddúu kootii Mëyíis rë, bi na yëeddëꞌ rí a sañ-sañ. ");
INSERT INTO ndv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yéesú na cép daŋa, ow caak ñeyute tala. ");
INSERT INTO ndv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lahte guuñndi yíppée ac ƴekke fíyí won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, mi yúhté biti fu mín sëe paƴ mi haalaat ɓëewë në. Fii soo rii pagiɗ a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yéesú yeɗte yaꞌi tíkké sun fi, won ɗi tih⁠ ⁠: «⁠ ⁠Mi tahte ɗaŋu. Yípée wah⁠ ⁠!⁠ ⁠» Guuña yíppée lan faan ɓëeꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yéesú ɓaatte won ɗi tih⁠ ⁠: «⁠ ⁠Síkírée⁠ ⁠! Ngana won ow yii beh. Paye seeƴoha na ɗi olsoh ro, fu yeraꞌ saraha nahaꞌ Mëyíis rë, teeɓi ɓëewë biti fu lante.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yéesú hom haal Kafarnawum, lahte kélfíi soldaari téebílëhté rí, na ɗaŋ ɗi won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«⁠ ⁠Ɓahaa, mi lahaꞌ súrgíi ín faam, mi helaꞌ ri tigal, ɗi jér jérë níi mínéh tíl. Mi ɗaŋ ɗo biti fu paƴ ɗi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yen saañ mi paƴ ɗi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kélfíi soldaara won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓahaa, mi caleh fu haale faam soꞌ. Wone un yínë kut, súrgíi sëꞌ ay wah. ");
INSERT INTO ndv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Fu ot mi won ɗo ri, biti soꞌ mi bee mi lahte kélfë yí daa paaꞌuu soꞌ sun, te mi kélfë i soldaar ɓal. Mi won ow yínë waa na gété rëe, ɗi saañ. Mi won ow kay aye raa, ɗi ac. Te mi won súrgíi sëꞌ page yii bee raa ɓal, ɗi paŋ yaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kelaꞌ Yéesú unni ƴaa ra, ɗi éem éemë níi ɗi yíssëhté ɓëewë ñeyu tali ra na, won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: tali Israyel ɓéeɓ, mi olay na ow yínë sah bi gémëꞌté ɗeh. ");
INSERT INTO ndv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mee ron won ɗa ee⁠ ⁠: ow caak ay kolaꞌ tígí hom ow feey fa ɓéeɓ, ac ɓani Abraham, Isaak a Yakop bok ñami ndaje ma cëgíɗ Koope Nguur ki ra. ");
INSERT INTO ndv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ndaa ɓëewë daa warun naa non koon ɗa, ay líkú saañ ñúusë ëssín. Wa ay looyee daaha, wa ŋafoh níi tíññí wë lec.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yéesú antee won kélfíi soldaara tih⁠ ⁠: «⁠ ⁠Tílé fu saañ faam, yee gém fú rë ay lahee ɗaaha.⁠ ⁠» Wahtaa na wonu wa ra, súrgíi soldaara wahte. ");
INSERT INTO ndv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yéesú pay faam Peer filoon fe, ɗi ɗeef jér fëníɗté pacool Peer ɓeleɓ, faana tampe níi tam. ");
INSERT INTO ndv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ɗi leɓpe yaꞌ ɓelaa, tami faana yíppée rii yeris, ɓelaa kolohte na tooppitoh ri. ");
INSERT INTO ndv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Fíníin fín, Yéesú komute ɓëewí caakki lahuu yébítëh. Ɗi won wono kut, yébítëh yë yeɗɗute wa. Ɓëewë jérú rë ɓéeɓ ɗi paƴce wa. ");
INSERT INTO ndv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yee húmú won yonente Isayii ra lahaꞌte ɗaaha. Ɗi húmú won tih⁠ ⁠: «⁠ ⁠Ɗi enohte misigi yen, kélíssé yen jér.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Olaꞌ Yéesú biti ɓëewë caakute hëbísí rë, ɗi nahte taalibe yi ɓani wa saañ ɓúk laaha hatni yíinëe. ");
INSERT INTO ndv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ow di yëeddëh yí kootii Mëyíis leɓohte ri tígí daaha, won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, tígí mín fúu saañ ɓéeɓ, may ñee talu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Tílé yë lahute faam, ƴakka lahute túf, ndaa soꞌ mi Koy-ɓëeꞌ, mi lahay dék.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ow kay di taalibe yi won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, on soꞌ paaƴ mi pay mi hace baasoꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Légéyú hac ɓúudé neh⁠ ⁠; kolee fu ñee tal soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yéesú haalte gaal na saañ, taalibe yi ñéerúuté a ri. ");
INSERT INTO ndv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hom homo níi ngilaaw gaan kolohte filiɓ laaha, mboowaanna na soɗ gaala muluɓ. Wahtii baaha ɗeef ɗi fi Yéesú na neeꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Taalibe ya leɓuute Yéesú, na fogu yúunúté rí wonu tih⁠ ⁠: «⁠ ⁠Ɓahaa, yípée koloh⁠ ⁠! Yen ee suu húlé rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon tíitú yih⁠ ⁠? Ngémën tasaꞌte ee⁠ ⁠!⁠ ⁠» Tígí daaha ɗi kolohte, digiɗte uni, túuƴcé ngilaaw ma a mboowaanna héddëh. Deyi baa ɓéeɓ hente tiɗ. ");
INSERT INTO ndv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ɓëewë éemúté na wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí bee mën ɗí ow níi ngilaaw ma a mulii laaha sah na ñeyu woni⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Húusëꞌ Yéesú laaha ra, ɗi teeraꞌ gina na wonuu Gadara ra. Ow ana yi lahuu yébítëh ɗúhúté hacaa ya na téebílúu rí. Wa sohooru sohooro níi tahte ow húmú kaañay ñee waali baaha. ");
INSERT INTO ndv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wa na ɗaañnjuu wonu Yéesú tih⁠ ⁠: «⁠ ⁠Koy Koope, fu fahaꞌ paŋi fun yih⁠ ⁠? Fu ac torohali fun te wahtaa lahay doom a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ɗeef lahte yubi mbaam-túgëllí caakute na píisúu ñam hatni baaha. ");
INSERT INTO ndv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yébítëh yë na ɗagu Yéesú wonu ri tih⁠ ⁠: «⁠ ⁠Fu lík fun ɗaa, lah yeñ fun mbaammi ƴín në.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Gétí⁠ ⁠!⁠ ⁠» Tígí daaha, yébítëh yë yeɗɗute ɓëewë, haalute mbaamma na. Yuba yíppée yeɗɗoh yëellëen kí daŋa, mbaamma ɓéeɓ soruute laaha, húlúté. ");
INSERT INTO ndv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Níirëh yí mbaamma heguute suute filiɓ ginin, na ɓíllú iña lah ra ɓéeɓ níi bi ɓëewë húmú lahuu yébítëh rë. ");
INSERT INTO ndv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tígí daaha, ɓëy gina ɓéeɓ koluute saami Yéesú. Oluu wa ri ra, wa ɗagute ri ɗúh gin wa saañ. ");
INSERT INTO ndv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yéesú kolaꞌ daaha haalte gaal, húusëetté laaha nimilte gin wa. ");
INSERT INTO ndv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Homaꞌ ri daaha ra, i ow komute ri lëfëñíɗ sun dil. Olaꞌ ri ɗee gémúu wë rí rë, ɗi won lëfëñídë tih⁠ ⁠: «⁠ ⁠Habe híin ƴaal kowa, fu baalute bakaaɗɗu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lahte i ow di yëeddëh yí kootii Mëyíis, ƴi húmú daaha, na wonu nuffi wa tih⁠ ⁠: «⁠ ⁠Ɓëyí bee solte Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bi yúh Yéesú yee hom nuffi wa ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Yi tah ɗon na lahu níɓ ɓos⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yi daa lukki yooɓ biti mi won ɓëyí beh⁠ ⁠: fu baalute bakaaɗɗu, mbée kolee fu tíl⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Woteh ɗon ay yúh biti soꞌ mi Koy-ɓëeꞌ mi lahte sañ-sañi baalaa mi bakaaɗ feey fi beh⁠ ⁠!⁠ ⁠» Ɗi won lëfëñídë tígí daaha tih⁠ ⁠: «⁠ ⁠Kolee fu pon dilu, fu saañ faam.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lëfëñídë kolohte, saañce faam. ");
INSERT INTO ndv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oluu ɓëewë yii baa ra, wa tíitú tíitë níi na kañu Koope, ona on ɗi ɓëewë sañ-sañi man ɗaa gaan ra. ");
INSERT INTO ndv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kolaꞌ Yéesú daaha na saañ ra, ɗi otte yeekoh túm húmú took tígë në légéyëꞌ rí rë⁠ ⁠; ɗi hínú Maccëe. Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Kolee fu ñee tal soꞌ.⁠ ⁠» Maccëe yíppée koloh wa ñéerúuté. ");
INSERT INTO ndv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Filoon fi baaha, Yéesú hom ñam faam Maccëe, i yeekoh túm a i bakaaroh kay ƴi caakute ayute, wani Yéesú a taalibe yi bokute na ñamu. ");
INSERT INTO ndv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Oluu fariseŋŋa yii baaha ra, wa wonu taalibe yi Yéesú tih⁠ ⁠: «⁠ ⁠Yi tah yëeddëhën na bok ñam a yeekoh yi túmë a bakaaroh ya⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kelaꞌ Yéesú yee wonu wa baa ra, ɗi won tih⁠ ⁠: «⁠ ⁠Jéríɗɗë daa sohluu paƴoh ndaa ɓëewë wahu ra neh. ");
INSERT INTO ndv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tílí ron saame yee fahaꞌ won unnee Koope ƴee ra⁠ ⁠: “Ɓëewë naaꞌ-keeñ ɓëewí kayya na, daa génël sëꞌ biti wa hawre soꞌ sarah kep.” Kon bakaaroh ya daa tahu mi koloh, ndaa ɓëewë júɓú rë neh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tígí daaha taalibe yi Saŋ ayute Yéesú në wonu ri tih⁠ ⁠: «⁠ ⁠Funi fariseŋŋa na ooru, kon yi tah taalibe yu na ëeríh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Bee kílëek lahte ra, ɗon habuu biti kooƴƴa warutee súfúñ te ɗeefa ɓëeꞌ kooɗ ɗa lís leelii wa a⁠ ⁠? Ɗon halaatuy ri maan⁠ ⁠? Funi taalibe yi soꞌ nék madu a ɓëeꞌ kooɗ baa ra hom a kooƴƴi ra nen. Bis ay lah, mi këllú leelii wa, tígí daaha wa ay oor. ");
INSERT INTO ndv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«⁠ ⁠Ow na daafeeh búuɓ kíilíɗ a nuf píis has. Henun ɗaaha raa, nuf píisí hasa hécëh sun fi búubí kíildë rëe, ɗara ay lukee gaan na. ");
INSERT INTO ndv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te ow na soreh béeñí hasi anti dal poosaꞌ ɓal filiɓ mbúus hun kíilíɗ. Henun ɗaaha raa, béeñë ay poo mbúusë, wa yúfëh, mbúusë yah. Béeñ has kay, hom soruu mbúus has. Henun ɗaaha raa, yin ii kat mbúusë te hana ii yúfëh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yéesú hom wona, lahte kélfíi yëwúdí acce yeɗɗohte kotti, won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, koy ki ɓelii soꞌ húlté koon, ndaa aye fu tík yaꞌu faana, ɗi ay koloh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yéesú kolohte, ɓani taalibe yi ñeyute tal ɓëeꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ɗeef lahte ɓelii húmú në, hente kíil sabboo a kíil ana yi ɗi yúfëꞌ ñif. Ɗi húmú won nufi tih⁠ ⁠: «⁠ ⁠Na mi leɓa búubí rek, may wah⁠ ⁠!⁠ ⁠» Ɗi acce ñeyaꞌte Yéesú filoon leɓpe nuf búubë. ");
INSERT INTO ndv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yíssëꞌ Yéesú otte ri ra, ɗi won ɗi tih⁠ ⁠: «⁠ ⁠Habe híin yaa ow⁠ ⁠! Ngémú tahte fu wahte.⁠ ⁠» Wahtaa na wonaꞌ Yéesú ɗii na ra ɗi wahte. ");
INSERT INTO ndv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lahaꞌ Yéesú faam kélfíi yëwúdë, ɗi otte ɓëewë ƴee na fikilu, ƴee na hawuu. ");
INSERT INTO ndv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Këlíi tígë⁠ ⁠! Kúkëyë húlëy, ɗi neeꞌ neeꞌo rek.⁠ ⁠» Ɓëewë yabute na ƴenu ri. ");
INSERT INTO ndv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ɗúhrúu ɓëewë ëssín rë, ɗi haalte lasa hampe yaꞌ kúkëyë, kúkëyë yíppée koloh. ");
INSERT INTO ndv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yaa hente lëyëŋ deyi baa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kolaꞌ Yéesú daa na saañ ɗa, búumíɗ ana ñeyute tala na fogu wonu tih⁠ ⁠: «⁠ ⁠Sédí Dawit, yérém fun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lahaꞌ ri faam níi búumíɗɗë leɓuute ri ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon gémúté biti mi mín paŋ yee nahu soꞌ ron ra a⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Ahaŋkay ɓahaa, fun gémúté rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tígí daaha, ɗi leɓpe íllí wë, won wa tih⁠ ⁠: «⁠ ⁠Yee gémú ron ɗa hente.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Íllí wë yíppée wërsëh, wa na olu. Yéesú digiɗte uni ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Síkíríi sëꞌ⁠ ⁠! Ow ɓanay yúh baaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kaaꞌeeh ɗúhúu wë rë, wa ñeyute deyi baa ɓéeɓ ɓíllúté yee paŋ Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sayuu ɓëewí ana yi ƴaa ra, Yéesú komute ɓëyí lahaꞌ yébítëh fí kaddaꞌ ri won. ");
INSERT INTO ndv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ɗi líkké yébítëh fë, ɓëeꞌ dalaatte won. Ɓëewë ɓéeɓ éemúté, na wonu tih⁠ ⁠: «⁠ ⁠Moo ow ëllëy mani bee Israyel kan⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ndaa wa fi fariseŋŋa wonu ɗi ñéerëꞌ a Seytaane buuri yébítëh yë, daa tah ɗi mín wëe lík. ");
INSERT INTO ndv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yéesú ñeete ginna ɓéeɓ, na yëeddëꞌ filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra, na waare Uni NebiNguur ki sun-Koo, na paƴ heet jér a heet misik ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Olaꞌ Yéesú dúukëlí ɓëewë na ayu ɗii na ra, keeña ɗúmpé waa na ces, ndah wa mokute te súfúñúté ti harri lahuy níirëh nen. ");
INSERT INTO ndv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tígí daaha, ɗi won taalibe yi tih⁠ ⁠: «⁠ ⁠Meeya laaɓpe te lecoh ya mítíh yin⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kon ɗëgí yíkíi meeya ɓaat i lecoh, wa ac leja.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yéesú dëekké taalibe yi sabboo a ana yi, onte wa sañ-sañ líkëe yébítëh, paƴaa heet jér a heet misik ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tii yi apootarri sabboo a ana yi ƴah, daa wa ƴeh⁠ ⁠: bee ɗéɓ ɗë, Simoŋ fa na wonuu Peer ra a Anndere koy-yaafi⁠ ⁠; Saak a Saŋ koyyi Sebede⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fílíp a Bartalemi⁠ ⁠; Toomaa a Maccëe yeekohi túmë koon, Saak fi Alfe a Taddee⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoŋ fi jammbaara a Yudaas Iskariyot fa míllëꞌtée yaay Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yéesú wol wa fi sabboo a ana yi ƴah, líkínté wë won wa tih⁠ ⁠: «⁠ ⁠Ngënë pëyí tígí lahay yëwúɗ. Ngënë pëyí ginni ɓëy Samari ɓal. ");
INSERT INTO ndv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yúlíi ɓëy Israyella na kay, wa fa madu harri múuƴú múuƴë nen ɗa. ");
INSERT INTO ndv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tígí ñee ron ɓéeɓ lah wëeríyí biti Nguur ki sun-Koo leɓohte, ");
INSERT INTO ndv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ɗon paƴ jéríɗɗë a guuñiɗɗa, ɗon këlíɗ ɓëewë húlú rë, ɗon lík yébítëh yë. Ɗon meeluy waaf, kon ngënë méelíi waaf. ");
INSERT INTO ndv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","«⁠ ⁠Ɗon ƴahti saañ raa, ngënë kúrí pep hélíis yínë sah faannon. ");
INSERT INTO ndv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ngënë kúrëelíi nafa, búuɓ lofaa, ñafaɗ a duuɗ⁠ ⁠: ɓëewë ɗon na habruu wa ƴaa ra nay ron tooppitee. Ɓëyí légéy waɗtee yínlú opaꞌi. ");
INSERT INTO ndv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ɗon lah gin raa, lah sëemí ɓëyí tah hami ron haneel faami. Lah hëmí në níi bín koluun ron gini baaha ra. ");
INSERT INTO ndv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ɗon haal faam raa, lah ɗëgírí ɓëy faam fa jaamma. ");
INSERT INTO ndv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wa cal ri raa, jaammaa ɗagu ron ra ay ham. Wa caluy ri raa nék, jaammaa nimil ɗon na. ");
INSERT INTO ndv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te ɗon haal faam mbée gin, ɓëewë kaaꞌ hamon haneel, kaaꞌ síkírëhën rëe, lah ɗúhí daaha, ɗon paaŋ pënë mí kotton, teeɓi wa biti wa homuy kaah. ");
INSERT INTO ndv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mee ron won kaaf ka ra ee⁠ ⁠: yiin nay aattiyee Koope ɓëewë rë, daani ɓëy gini baaha ay luk bi ɓëy Sodom a bi ɓëy Gomoor misik. ");
INSERT INTO ndv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«⁠ ⁠Síkíríi⁠ ⁠! Mee ron wol ra ee ti ndeŋŋi suu filiɓ i gúmú nen. Kon lah hëfí te ɗon sos ɓal. ");
INSERT INTO ndv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lah hélí nuf ɓëewë në⁠ ⁠: af soꞌ ay tah wa ay ron tëekíɗ këem filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra, wa laɓ ɗon laraw. ");
INSERT INTO ndv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ɗon ay cëgírú fíi i gëernëer a fíi i buur, ɗon seede yee yúhú ron soo na ra fíi wë a fíi ɓëewí kayyi yëwúɗ neh caak. ");
INSERT INTO ndv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Tíl níi ɗon kúrú këem rëe, ngënë sídíi⁠ ⁠: yee nay ron layee wahtii baaha teme ra, ii kolaꞌ ɗon na, ay kolee Ruuh-Peseŋ fa kolaꞌ Boffon na ra. ");
INSERT INTO ndv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«⁠ ⁠Bín fë, ow ay yaay koy-yaafi hawroh ri húl, baap a koohi ɗaaha ɓal, tuŋka ay koloh sun fi baappi wa a yaayyi wa, hawroh wa húl. ");
INSERT INTO ndv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Af soꞌ ay tah ɓëewë ɓéeɓ kaaꞌ ron, ndaa ɓëyí ham híin níi ɗúmëenë rëe, ay múc. ");
INSERT INTO ndv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ɗon lah gin ɗon moklu raa, hégíi ɗon saañ gin kay. Mee ron won kaaf ka ra ee⁠ ⁠: ɗon ii ɗúmël ginna Israyel ɓéeɓ, te soꞌ mi Koy-ɓëeꞌ mi nimileh. ");
INSERT INTO ndv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yoodoh lukeh yëeddëhí mín, te súrgë mínéh luk kélfíi gaan. ");
INSERT INTO ndv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yoodoh teemmaꞌ yëeddëhí mín ɗëe, baahte. Te súrgë teemmaꞌ kélfíi gaan ɗaa ɓal, baahte. Wa mín won soꞌ mi bee biti daa mi Belsebul buuri yébítëh yë rëe, wa lah ɗon fi ɓëy faam soꞌ na raa, wa ay ron wone yi⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Di mín ríi man ɓéeɓ ngënë néehí ow. Yii laku ɓéeɓ ay olu, yii ɗapu ɓéeɓ ay yúhú. ");
INSERT INTO ndv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yii won mi ron las, lah ɗúhrí rí ëssín, yii mëddëꞌ mí ron, lah wëní rí këem. ");
INSERT INTO ndv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ngënë néehí ɓëewë na hawu ow húl rë, wa míníh yin coonaa fi ɓëeꞌ. Néehí Koope fa mín saŋku ow a coonaa fi ɓéeɓ safara ra kay. ");
INSERT INTO ndv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ndiit ana na yëeyíih fíttíŋ woo⁠ ⁠? Añcaŋ bi keen na ɓéeɓ ɗeef neɓaꞌ Boffon Koope neɓoo. ");
INSERT INTO ndv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ɗon nék, fen fi affon sah kídúté⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kon ngënë sídíi yin, ɗon génú líir ndiit fap⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«⁠ ⁠Ɓëyí won fíi ɓëewë biti ri non ɓëewí sëꞌ, soꞌ ɓal may won fíi Baasoꞌ fa sunaa-sun biti ɓëyí baa non ɓëewí sëꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ɓëyí won fíi ɓëewë biti ɗi yéeh sëꞌ nék, soꞌ ɓal may won fíi Baasoꞌ fa sunaa-sun biti mi yéeh ɓëyí bah. ");
INSERT INTO ndv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«⁠ ⁠Ngënë hëbíi biti mi ac kúɗ jaamma feey fa. Ëe-ëeꞌ⁠ ⁠! Mi aay kúɗ jaamma, mi kúɗ haaꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi ac ɗaralsaꞌi koy ƴaal a boffi, koy ɓeleɓ a yaafi, ɓeleɓ a pacooli. ");
INSERT INTO ndv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɓëy faammon nay hene kaaꞌoh yon. ");
INSERT INTO ndv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«⁠ ⁠Ɓëyí lukki fahaꞌ boffi, yaafi mbée koohi níi wa génël rí sëꞌ, hen taalibeyi soꞌ jomute ɓëyí bah. ");
INSERT INTO ndv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɓëyí enaay kurwahi ñee tal soꞌ, hen taalibeyi soꞌ jomute ɓëyí bah. ");
INSERT INTO ndv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɓëyí núp húl, ay ñak ñíiní. Ɓëyí tah ñagi ñíiní af soꞌ nék, ay lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«⁠ ⁠Ɓëyí ham ɗon a yaꞌ ana, ɗeef ɗi ham soꞌ⁠ ⁠; te ɓëyí ham soꞌ, ɗeef ɗi ham ɓëeꞌ wol soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɓëyí ham yonente a yaꞌ ana te habaa ri hena hen ɗi yonente ra, ɓëyí baa ay lahee waafi waɗ yonente. Ɓëyí ham ɓëyí júɓpé te habaa ri hena hen ɗi ɓëyí júɓpé rë, ɓëyí baa ay lahee waafi waɗ ɓëyí júɓpé. ");
INSERT INTO ndv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ɓëyí on ow di tuŋki ƴee muluɓ, wuti ƴaha muluɓ ƴutuuɗ raa sah, te onaa ri hena hen ɗi taalibeyi soꞌ ra, mee ron won kaaf ka ra ee biti ɓëyí baa ay liil waafi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Líkínëꞌ Yéesú taalibe yi sabboo a ana yi níi wocce ra, ɗi kolohte daaha, saañce ginna deyi baaha na yëeddëꞌ, na waare Uni Neba. ");
INSERT INTO ndv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Filiɓ fi baaha ɓéeɓ, Saŋ Batis hom kasu, kelohte iña na paŋ Kiristaa ra. Tígí daaha, ɗi wolte i ow di taalibe yi, ");
INSERT INTO ndv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","meeli Yéesú nda daa ri Sëmlëhë në séentúu rë mbée ɓëewë waɗti sehun ow kay. ");
INSERT INTO ndv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Nímílí Saŋ na, ɗon ɓílíɗ rí iña na keluu ron, ɗon olute wa ra. ");
INSERT INTO ndv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Wëní rí biti búumíɗɗë yeelute, lëfëñíɗɗë koluute, guuñiɗɗa wahute, likiɗɗa ee keluu ra, ɓëewë húlú rë këllúté ɓúudé, ñëkíɗɗë keluute Uni Neba. ");
INSERT INTO ndv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ɓëyí af iñi soꞌ taheh ɗi yeris ngémí, ɓëyí baa lahte sos-keeñ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bi na suu ɓëewë húmú wolu ɗii na ra, Yéesú yampe na goneel a dúukëlí ɓëewë yii leŋke Saŋ Batis na, meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗon húmú payu olsoh yi luufa⁠ ⁠? Tal bëhëerí ngilaaw ma na jaay ri neh maan⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kon ɗon húmú payu olsoh yih⁠ ⁠? Ɓëyí ɓekoh búuɓɓí wunte neh maan⁠ ⁠? Yíkëe yí búuɓɓí wunna oluu faam buur. ");
INSERT INTO ndv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mantee, ɗon húmú payu olsoh yi luufa⁠ ⁠? Yonente neh a⁠ ⁠? Mee ron won ra biti ɗi yonente kaah⁠ ⁠; ɗi luk sah yonente gaan⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Daa ri ɓëeꞌ në wonaꞌ Koope Téerëe rë bitih⁠ ⁠: “Olsee⁠ ⁠! May wol ow këllëh ɗaɗɗi ro waal.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: lahay ɓëyí límúté feey fi beh, te luk Saŋ Batis gaan. Añcaŋ ɓëeꞌ lukki ƴin Nguur ki sun-Koo ra luk rii gaan. ");
INSERT INTO ndv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Teekiraꞌ Saŋ Batis níi a ɗeh, Nguur ki sun-Koo hente gúƴës, te ɓëewë lahu doole ra ee maannduu ɓeyi ra. ");
INSERT INTO ndv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yonente ya ɓéeɓ a Kootaa húmú wonute yii leŋke Nguur ki baa níi lahte Saŋ Batis na. ");
INSERT INTO ndv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ɗon gém woni soꞌ raa, hëbíi biti Saŋ daa yonente Éelí fë na húmú wonuu biti ay nimil ra. ");
INSERT INTO ndv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ɓëyí lah nuf kelaa, kelaan na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«⁠ ⁠May mínée mëldëꞌ ɓëy jamanii bee a yih⁠ ⁠? Wa maduu a tuŋki tooku këem, ƴee na wonu affi ƴee tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Fun poosute, ɗon becuy⁠ ⁠! Fun fogute, ɗon hílípúy fun⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","«⁠ ⁠Húmú ayaꞌ Saŋ kaaꞌaꞌte ñam a han ra, wa wonu ɗi lahaꞌ yébítëh. ");
INSERT INTO ndv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ayaꞌ soꞌ mi Koy-ɓëeꞌ mi na ñam, mi na han ra, wa wonu tih⁠ ⁠: “Ëlí⁠ ⁠! Ɓëyí bee ñam a han kut daa afa, te ɗi kooƴaꞌ yeekoh yi túmë a i bakaaroh kay.” Añcaŋ iña lah ra teeɓaꞌte biti waalli Koope júɓpé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yéesú na anti won affi ɓëewë dékú ginna húmú luk rii pagaꞌ kimtaan ra, biti wa lofuy pesaɗ, won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«⁠ ⁠Mas ɗon fi ɓëy Korasin⁠ ⁠! Ɗon torohute, ɗon fi ɓëy Betsaydaa⁠ ⁠! Kimtaanna pagu ginon ɗa, paguun Tíir a Sidon koon, tin ɓëy ginni ƴaaha maañutee lamboh saaku, wa leefoh yet, teeɓaꞌi biti wa lofute pesaɗ. ");
INSERT INTO ndv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Daa tah mi won ɗon tee⁠ ⁠: yiin nay aattiyee Koope ɓëewë rë, daanon nay luke bi ɓëy Tíir a bi ɓëy Sidon misik. ");
INSERT INTO ndv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A ɗon fi ɓëy Kafarnawum, mbaa ɗon habuu biti ɗon ay ɓéyrú níi sun-Koo neh⁠ ⁠? Ëe-ëeꞌ⁠ ⁠! Añcaŋ ɗon ay cépírú níi safara. Kimtaanna pagu ginon ɗa, paguun Sodom koon, tin ɗi lís níi a woteh. ");
INSERT INTO ndv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mi won ɗon tee⁠ ⁠: yiin nay aattiyee Koope ɓëewë rë, daanon nay luke bi ɓëy Sodom misik.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Filoon fi baaha, Yéesú won tih⁠ ⁠: «⁠ ⁠Baap, Yíkíi sun a feey⁠ ⁠! Mee roo sím rë, di yee teeɓaꞌ fu ɓëewë ɓëy ëldúnë heefu wa ra iña ɗap fu ɓaha ya a ɓëewë jaŋiyu ra. ");
INSERT INTO ndv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Baap, yii baa daa neɓaꞌ ro, daa tah ri lahaꞌ ɗaaha⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ɗi ɓaatte won ɓëewë tih⁠ ⁠: «⁠ ⁠Baasoꞌ tíkké iña ɓéeɓ yaꞌ soꞌ. Ow yéeh soꞌ mi Koy ka hém henay Baasoꞌ⁠ ⁠; te ow yéeh Baasoꞌ hém henay soꞌ mi Koy ka a ɓëewë mi fahaꞌ wa rii teeɓ ra. ");
INSERT INTO ndv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«⁠ ⁠Ɗon fa ennon ɓít rën níi ɓít rë, ëyí soo na mi kélís ron, ɗon hílsëh. ");
INSERT INTO ndv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ñéyí woni soꞌ mi nook ron, ɗon ñee kotti soꞌ⁠ ⁠: mi sosse te mi cépíɗté af soꞌ. Hen ɗaaha raa affon took. ");
INSERT INTO ndv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ahaŋkay⁠ ⁠! Ñeyi tal soꞌ yooɓpe te yee nah mi ron ra kofeelay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Bisa na hílsúu yëwúɗɗë rë ín, Yéesú a taalibe yi ñeyu waali húus filiɓ i meey bele. Yaaɓuu taalibe ya ra, wa yabute na kodu yaaŋnga yi belaa, na ɓuluñu na húñú. ");
INSERT INTO ndv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Oluu fariseŋŋa yii baa ra, wa wonu Yéesú tih⁠ ⁠: «⁠ ⁠Ole⁠ ⁠! Taalibe yu ee pagu yii Kootaa kaddaꞌte ri bisa na hílsúu rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon yúhú yee húmú paŋ Dawit bee yaaɓuu ɓani ɓëewí rë maan⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ɗi húmú haal Faam Koope, ɓeɓpe mbúurëe yefu fíi Koope ra, ɓani ɓëewí ñamute. Añcaŋ ɗi a ɓëewí ɓéeɓ, ow di waa na waray naa ñam. Seeƴoh ya kut daa waruu naa ñam. ");
INSERT INTO ndv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mbée ɗon yúhú yee bíníyú téeríi Kootaa ra maan⁠ ⁠? Bisi hílsëe lah raa, seeƴoh ya na légéyú Faam fi gaani Koope ra na powu kootii bisa te na heneh yin ɓos waa na. ");
INSERT INTO ndv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mee ron won ra ee biti ɓëyí luk Faam fi gaana daa deh. ");
INSERT INTO ndv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mantee ɓal, Koope won tih⁠ ⁠: “Ɓëewë naaꞌ-keeñ ɓëewí kayya na daa génël sëꞌ biti wa hawre soꞌ sarah kep.” Ɗon yúh yee fahaꞌ won unni ƴaa ra koon, tin ɗon ii daan ɓëewí paguy yin ɓos. ");
INSERT INTO ndv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yúhí biti soꞌ mi Koy-ɓëeꞌ daa mi lah sañ-sañ sun fi bisa na hílsúu rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yéesú kolaꞌ daaha saañce, haalte tígë na ɗaguu yëwúɗɗë Koope ra. ");
INSERT INTO ndv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ɓëyí yaꞌa ɓeedohte húmú në. Fariseŋŋa na saamu yii yabun wa Yéesú, meelute ri wonu tih⁠ ⁠: «⁠ ⁠Kootaa onte ow paƴ jéríɗ bisa na hílsúu rë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ow di ɗon na lahaa har fa yínë kut koon, har fa anti keen yéem yiin bisa na hílsúu rë, ɗi ii yíppí pay nís ɗí ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Añcaŋ ow luk har lah maanaa fap. Kon pagiɗ ow yin wun bisa na hílsúu rë kadduuy⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tígí daaha, Yéesú won ɓëeꞌ yaꞌa ɓeedoh ra tih⁠ ⁠: «⁠ ⁠Yere yaꞌu⁠ ⁠!⁠ ⁠» Ɓëeꞌ yeɗte yaꞌi, yaꞌa yíppée wah koloŋ maddaꞌte a yaꞌi yínëe. ");
INSERT INTO ndv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tígí daaha, fariseŋŋa ɗúhúté tígë na ɗaguu yëwúɗɗë Koope ra, na peenu ɗee nay waa page níi wa hap Yéesú húl rë. ");
INSERT INTO ndv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yúhëꞌ Yéesú biti fariseŋŋa peenu hawi húl rë, ɗi kolohte tígí daaha saañce. Ow caak ñeyute tala, ɗi paƴce ɓëewë jérú në rë ɓéeɓ, ");
INSERT INTO ndv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ɗi antee waa kaddaꞌ lok biti wa won daa ri wa. ");
INSERT INTO ndv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yee húmú won Koope ñeyaꞌte ri yonente Isayii ra lahaꞌte ɗaaha. Ɗi húmú won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«⁠ ⁠Bee daa súrgíi sëꞌ, bee fal mi ra⁠ ⁠; mi fahaꞌte ri níi fahaꞌ, te keeñ soꞌ sosse ɗii na níi sos. May cépíɗ Ruuhi soꞌ sun fi, ɗi waare heetta ɓéeɓ waala gén ɗë. ");
INSERT INTO ndv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɗi ii íñëꞌ, ɗi ii ɓéyíɗ uni, una ii lek ow këem. ");
INSERT INTO ndv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ɗi ii korsaꞌ tal bëhëerí sígímpé, ɗi ii ƴím lampii giimpe. Ɗi ay hene ɗaaha níi ɓëewë ɓéeɓ tah waala gén ɗë. ");
INSERT INTO ndv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Heetta ɓéeɓ ay tík yaakaari wa sun fi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Filoon fe, Yéesú komute ɓëyí lahaꞌ yébítëh fí kaddaꞌ ri ot a won. Yéesú paƴce ri, ɓëeꞌ dalaatte ot a won. ");
INSERT INTO ndv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɓëewë ɓéeɓ éemú éemë níi tahte wa na wonu tih⁠ ⁠: «⁠ ⁠Ɓëyée waɗti hena sédí Dawit maan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Keluu fariseŋŋa yii baa ra, wa wonu ɗi ñéerëꞌ a Belsebul buuri yébítëh yë daa tah ɗi mín wëe lík. ");
INSERT INTO ndv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Bi yúh Yéesú yee nuffi wa, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɓëewí daa boku nguur haaꞌee filiɓ fi wa raa, nguur ki baa ii míllëꞌ keen a⁠ ⁠? Ɓëewí daa boku gin mbée faam haaꞌee filiɓ fi wa raa, gini baa mbée faam fi baa ay míllée poo. ");
INSERT INTO ndv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kon hena biti Seytaane líkë Seytaane líkë ti ɗaa nen koon, ɗeef ɗi haaꞌ afi⁠ ⁠! Nguur ki ay mínée caŋ ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hena biti Belsebul daa yeɗ soꞌ sañ-saña na líkëꞌ mi yébítëh rëe, kon daa yeɗ ɓëewën sañ-saña na líkúu wë yébítëh rë⁠ ⁠? Wa fi ƴaa teeɓute ron biti ɗon homuy kaah⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yee lah ra biti kay, mi ñéerëꞌ a Ruuhi Koope, daa tah mi mín lík yébítëh. Baa daa teeɓaꞌ biti Nguur ki Koope lahte níi ɗon na. ");
INSERT INTO ndv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«⁠ ⁠Ow mínéh haal faam ɓëyí mitte ow, poo faam fa, te ɗéɓéeh rii pokalsaꞌ. Ɗi pokalsaꞌ ri níi woc raa kay, ɗi mín ɓeɓ alal mi. ");
INSERT INTO ndv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ɓëyí ñéerëey a soꞌ, kaaꞌaꞌte soꞌ⁠ ⁠; te ɓëyí habraay soꞌ négírëꞌí yubi soꞌ, ɓëyí baa haslaꞌ hasloo. ");
INSERT INTO ndv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Daa tah mi na won ɗon bitih⁠ ⁠: bakaadi paŋ ow ɓéeɓ mín ɗíi baalu níi lukaꞌ solaꞌ ya yuloh Koope na ra. Ɓëyí sol Ruuh-Peseŋ nék, ɗi ii baalu. ");
INSERT INTO ndv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɓëyí won yin ɓos sun fi soꞌ mi Koy-ɓëeꞌ ɓéeɓ, ɗi mín baalu. Ƴaha sun fi Ruuh-Peseŋ raa nék, ɓëyí baa ii mëssí baalu. ");
INSERT INTO ndv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«⁠ ⁠Tal kilki lahte njiriñ límëꞌ koy ki lahte njiriñ, tal kilki lahay njiriñ límëꞌ koy ki lahay njiriñ. Tal kilik yúhsúu koy ka. ");
INSERT INTO ndv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tisoh yi hiliññi ƴeh, ɗon mínúu won yii wunte ɗíh te ɗon wúníh⁠ ⁠? Yii won ow ɓéeɓ ɗúhëꞌ rí keeñi. ");
INSERT INTO ndv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɓëyí naaꞌte keeñ hom wonaꞌ yii wunte ndah keeñi naaꞌa lahaꞌ ri ra⁠ ⁠; ɓëyí ɓosse keeñ nék hom wonaꞌ yii ɓosse ndah ɓosi keeña homaꞌ ri ra. ");
INSERT INTO ndv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mee ron won ɗa ee bitih⁠ ⁠: yiin nay aattiyee Koo ɓëewë rë, ɓëyí won woni lahay njiriñ ɓéeɓ, ɓani Koope ay naa teyaꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yii won ow, Koope ay rii aattiyee biti ri ow wun mbée ri ow ɓos na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Filoon fe, i ow di yëeddëh yí kootii Mëyíis a i fariseŋ ayute wonu Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun fahuu olu fu paŋ kimtaani nay teeɓee biti Koope daa wol ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ɓëy jamanii beh, ɗon ɓosute te ɗon yégúy Koope⁠ ⁠; ɗon meeluu kimtaani kolaꞌ ɗii na a⁠ ⁠? Añcaŋ ɗon ii teeɓu kimtaan hém henay yee húmú kat yonente Sonaas ra. ");
INSERT INTO ndv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Di húmú lahaꞌ Sonaas waal éeyë loo jéní gaana, soꞌ mi Koy-ɓëeꞌ, ɓúudé fí sëꞌ ay hacu, lah waal éeyë feey. ");
INSERT INTO ndv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yiin nay aattiyee Koope ɓëewë rë, ɓëy Níníif ay koloh caŋ fíi ɗon fi ɓëy jamanii beh, teeɓ ɗon biti ɗon homuy kaah. Keluu ɓëy Níníif waarii Sonaas ra, wa lofute pesaɗ neh a⁠ ⁠? Añcaŋ ɓëyí luk Sonaas gaan daa deh. ");
INSERT INTO ndv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yiin nay aattiyee Koope ɓëewë rë, buuri ɓelaa húmú ílíf deyi Sabaa ra ɓal ay koloh caŋ fíi ɗon fi ɓëy jamanii beh, teeɓ ɗon biti ɗon homuy kaah. Ɗi húmú kolaꞌ ginna lukuu wuloh ra acce síkírëhí wonnee ke Salomoo neɓ keloh níi rë neh a⁠ ⁠? Añcaŋ ɓëyí luk Salomoo gaan daa deh. ");
INSERT INTO ndv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«⁠ ⁠Yébítëh ɗúh ow na raa, sayaꞌ mbale luufin saame tígí hílsëe rí. Ɗi olay raa, ");
INSERT INTO ndv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","wonaꞌ nufi tih⁠ ⁠: “May nimil tígë húmú kolaꞌ mi ra.” Ɗi nimil ɗeef ɓëeꞌ man ti faam fi parute, yugusute níi wunte, hente holoŋ raa, ");
INSERT INTO ndv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tígí daaha, ɗi ay pay saam yébítëh paana kay, ƴi luku rii sohoor, wa ac dék ɓëeꞌ në. Hen ɗaaha raa, ɗee nay míllée ɓëeꞌ rë ay luk ɗee man ɗi ɗéɓëenë rë ɓos. Yii man ɗaaha nay kate ɓëy jamanii bee ɓosute níi ɓos ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yéesú hompe na goneel a ɓëewë, koy-yaayyi a yaafi ayute, cagute ëssë na meeluu ri.  ");
INSERT INTO ndv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ow acce won Yéesú tih⁠ ⁠: «⁠ ⁠Yaafu a koy-yaayyu ínú ëssín, na meeluu ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yéesú tahte won ɗi tih⁠ ⁠: «⁠ ⁠Wa daa yaasoꞌ a i wa daa koy-yaayyi soꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ɗi yeɗte yaꞌi na teeɓaꞌ taalibe yi, won tih⁠ ⁠: «⁠ ⁠Yaasoꞌ a koy-yaayyi soꞌ daa wa ƴeh. ");
INSERT INTO ndv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yúhí biti ɓëyí në paŋ yee fahaꞌ Baasoꞌ fa sunaa-sun ɗa ɓéeɓ, ɓëyí baa daa koy-yaasoꞌ mbée yaasoꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yiin fin fa, Yéesú kolohte faam, saañce tookke ɓúk laahi Galile. ");
INSERT INTO ndv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɓëewí caakute níi caak ayute wërúté rí, tahte níi ɗi míllëꞌ haal gaal filiɓ laaha, tookke na, ɓëewë homute ɓúk laaha. ");
INSERT INTO ndv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ɗi ñeyaꞌte léeh, na teeɓ wa yin caak won wa tih⁠ ⁠: «⁠ ⁠Lahte ɓëyí húmú koloh sohi meeyi. ");
INSERT INTO ndv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ɗi hom hasli tisoh ka, lahte peppi keente ɓúk waala, ƴakka ayute tanute wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Lahte ƴi keen feey fi lahaꞌ laꞌ. Bi caakay feey fa, wa yíppée paal⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ndaa kolaꞌ naꞌa sun ɗa, bi nooray níillë, wa yíppée tam. ");
INSERT INTO ndv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Lahte ƴi keen tígí paalaꞌ ñobitaan. Kolaꞌ ñobitaan fa hampe wa ra, wa tampe. ");
INSERT INTO ndv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lahte ƴi keen feey fi looɓpe. Wa paalte, talla kolohte, ɗúhíɗté íl, laaɓpe níi laaɓ. Tal fi tal ɓéeɓ yeraꞌte yee waɗ rii yeraa ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yéesú ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Ɓëyí lah nuf kelaa, kelaan na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tígí daaha taalibe ya leɓuute Yéesú, wonu ri tih⁠ ⁠: «⁠ ⁠Yi tah fu ƴahti won a ɓëewë rëe, fu ñeyaꞌ wa léeh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon, kúmpë yí Nguur ki sun-Koo teeɓu ron, ndaa teeɓuy ɓëewí kayya. ");
INSERT INTO ndv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yúhí biti ɓëyí ham yee yeru ri ra a yaꞌ ana, ay ɓaatu níi keeña sos. Ɓëyí pagay yii baaha raa nék, yii ƴutuuda lahaꞌ ri ra sah ay naafu. ");
INSERT INTO ndv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yee tah níi mi ƴahti won a wa raa, mi ñeyaꞌ wa léeh rë daa ri beh⁠ ⁠: biti wa yeele raa wa na ëlíh, te wa kelee raa wa na yíih yee na wonu ra. ");
INSERT INTO ndv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yee húmú won Koope ñeyaꞌte ri yonente Isayii ra lahaꞌte ɗaaha waa na. Ɗi húmú won tih⁠ ⁠: “Ɗon ay keloh a nuffon, ɗon ii yúh. Ɗon ay tík íllën ngëeƴ, ɗon ii ot. ");
INSERT INTO ndv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ɓëewí ƴee súhúté keeñ, wa dapute nuffi wa, toñeh wa ay naa kelee. Wa ñíipúté, toñeh wa ay naa ole, keeññi wa ay kúnsée ndín, wa lof pesaɗ, mi paƴ wa yee homuu wa ra.” ");
INSERT INTO ndv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«⁠ ⁠Ɗon nék, ɗon lahute sos-keeñ⁠ ⁠: íllën ee ot ɗa, nuffon ee keloh ra. ");
INSERT INTO ndv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mee ron won kaaf ka ra ee⁠ ⁠: caakke yonente a ɓëewí júɓúté húmú fahuute ot yee olu ron ra, wa oluy ri⁠ ⁠; te wa húmú fahuute keloh yee keluu ron ra, wa keluuy ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«⁠ ⁠Kon síkíríi yee fahaꞌ won léehí línëhë rë. ");
INSERT INTO ndv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ɓúk waala keen tisoh ka ra, daa wa ɓëewë yéŋké biti keluu wa Unni Nguur ki sun-Koo ra, wa habuy wa affi wa. Seytaane acce tígí daaha, pahte wa waa na. ");
INSERT INTO ndv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Feey fa lahaꞌ laꞌ tisoh ka keen na ra, daa ɓëewë yéŋké biti keluu wa Unna ra, wa yípútée wëe tah a sos-keeñ⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ndaa Unna yípëy níil keeññi wa. Wa topuun waa ham guuttii baaha⁠ ⁠: kofeel yípée wëe daɓ mbée wa moklu af hama habu wa Unna ra rek, wa koluun daaha yeris ngémë. ");
INSERT INTO ndv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Feey fa na paal ñobitaan tisoh ka keen na ra, daa ɓëewë yéŋké biti keluute Unna ra. Tíl tílë níi nék, sohle yi ëldúnë a alal ma na nofaꞌ ow ra lúfílté Unna waa na, tahte níi wa lahray wa njiriñ. ");
INSERT INTO ndv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Feey fi looba keen tisoh ka ra, daa ɓëewë yéŋké biti keluu wa Unna ra, yúhúté yee won wa ra⁠ ⁠: ow fi ow waa na ɓéeɓ njiriñce yee waɗ ɗii njiriñ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yéesú ñeyaatte wa léeh kay won tih⁠ ⁠: «⁠ ⁠Nguur ki sun-Koo madaꞌ a biti bee ow sohte tisoh ki wunte meeyi ra nen. ");
INSERT INTO ndv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ɓëyí kaaꞌaꞌte ri kolohte leelu elek ɗeef ɓëewë ɓéeɓ na neeꞌu, payte sohte gaawa naal filiɓ too ka, saañce. ");
INSERT INTO ndv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kolaꞌ too ka níi ɓíríssé rë, gaaw fa kolohte ɓal ñéerëꞌté a wa. ");
INSERT INTO ndv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Súrgë yí yíkíi meeya ayute wonu ri tih⁠ ⁠: “Ɓahaa, fu soh tisoh ki wunte meeyu neh a⁠ ⁠? Gaaw fa filiɓ kolaꞌ di kon⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ɗi won wa tih⁠ ⁠: “Ɓëyí kaaꞌaꞌte soꞌ daa paŋ pagari bah.” Wa wonu ri tígí daaha tih⁠ ⁠: “Fu fahaay biti fun pay fun ɗof wa woo⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɗi won wa tih⁠ ⁠: “Miteh ri, toñeh ɗon home ɗofi wa raa, ɗon ɗofaaloh too ka. ");
INSERT INTO ndv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yéɗɗí wë ɗaaha níi lecaa ya fayu. Bín fë rëe, may won lecoh ya ɗof wa paaƴ, luuh wa tam wa, wa anti lec too ka gariɗ soꞌ wa.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yéesú ñeyaatte wa léeh kay won wa tih⁠ ⁠: «⁠ ⁠Nguur ki sun-Koo madaꞌ a pebi ƴutuudi baa ɓeɓ ow sohte ri meeyi ra nen. ");
INSERT INTO ndv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pebi baa daa lukki ƴin tisoh ya ɓéeɓ⁠ ⁠; kaaꞌeeh paalaꞌ ri ra, ɗi hente tal kilik níi lukke gañcaha meeya ɓéeɓ, ƴakka ayute túfúté yaꞌ ya.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yéesú ñeyaatte wa léeh kay won wa tih⁠ ⁠: «⁠ ⁠Nguur ki sun-Koo madaꞌ a lëwíirë ɓeɓ ow ɓeleɓ, boollaꞌte wa a mún caak, íƴíɗté wë níi wa ɓéeɓ fuuɗte ra nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yéesú teeɓaꞌ ɓëewë iñƴaaha ɓéeɓ a léeh. Ɗi na húmú woneh a ɓëewë te ñeyeeh léeh. ");
INSERT INTO ndv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yee húmú won yonentaa ra lahaꞌte ɗaaha. Ɗi húmú won tih⁠ ⁠: «⁠ ⁠May waa ñeeꞌee léeh, may waa won iña ɗapu dalaꞌte dalaani ëldúnë rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yéesú kolohte ɓëewë në tígí daaha, nimilte faam. Taalibe yi leɓuute, meelute ri wonu tih⁠ ⁠: «⁠ ⁠Teeɓ fun iti fi léehí gaaw fi naala meeya.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ soh too-tihin ka ra, daa ri soꞌ mi Koy-ɓëeꞌ⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","meeya daa ëldúnë⁠ ⁠; too-tihin ka daa ɓëewë nonu Nguur ki sun-Koo ra⁠ ⁠; gaaw fa daa ɓëewë ñeyu tal Seytaane ra⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","kaaꞌohi yíkíi meeya, bee soh gaaw fi naala ra, daa Seytaane⁠ ⁠; wahtu lec too daa túkkíi ëldúnë⁠ ⁠; lecoh ya daa wa malaaka ya. ");
INSERT INTO ndv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Di nay ɗofuu gaaw fa luuhu tamu, ay made ɗaaha nen túkkíi ëldúnë. ");
INSERT INTO ndv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yiin fin fa, soꞌ mi Koy-ɓëeꞌ, may wol malaaka yi soꞌ, wa négírëꞌ ɓëewë na ɓeku ɓëewí kayya bakaaɗ ɗa a ƴee na ñéyíh woni Koope ra ɓéeɓ, wa lík wë Nguur ki soꞌ, ");
INSERT INTO ndv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","an waa yeñ filiɓ njaar mi kíi kë, wa looye daaha, ŋafee níi tíññí wë lec. ");
INSERT INTO ndv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tígí daaha, ɓëewë júɓú rë ay niiñ ti naꞌ nen filiɓ Nguur ki boffi wa. Ɓëyí lah nuf kelaa, kelaan na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yéesú ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Nguur ki sun-Koo madaꞌ a alal mi ɗapu filiɓ meey nen. Lahte ɓëyí otte wa ɗapaatte wa, saañce a sos-keeñ yaayte iña lahaꞌ ri ra ɓéeɓ, nimilte lompe meeya. ");
INSERT INTO ndv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«⁠ ⁠Nguur ki sun-Koo man biti ɓal bee yiikoh koloh saam feme kah-kah ra nen. ");
INSERT INTO ndv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ɗi tíl níi teyaꞌ a femii kofeelte ot ɗaa, ɗi pay yaay iña lahaꞌ ri ra ɓéeɓ, ɗi ac lom femaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yéesú ɓaatilte won tih⁠ ⁠: «⁠ ⁠Nguur ki sun-Koo madaꞌ a biti bee seeɓoh bac mbaal kísí, hampe heet jén ɓéeɓ rë nen. ");
INSERT INTO ndv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mbaala líif rëe, wa héc ɗí, ɗúhíɗ rí ɓúk kísí fë, wa took tanis jénnë. Ƴee wun ɗa, wa túm wë dama yi wa, wa bet ƴee lahruy wa njiriñ ra. ");
INSERT INTO ndv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Túkkíi ëldúnë fayu ay made ɗaaha nen. Malaaka ya ay ac, ɓísëlsëꞌ ɓëewí ɓossa a ɓëewë júɓú rë, ");
INSERT INTO ndv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","wa bet ɓëewí ɓossa filiɓ njaar mi kíi kë, wa looye daaha, ŋafoh níi tíññí wë lec.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yéesú meelte taalibe yi won wa tih⁠ ⁠: «⁠ ⁠Ɗon yúhú yee fahaꞌ won iñƴaa ra ɓéeɓ ë⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Íi, fun yúhú yee fahaꞌ waa won ɗa kay⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ow di yëeddëh yí kootii Mëyíis, bi yëeddúté ɓal iña leŋ sun fi Nguur ki sun-Koo ra madaꞌ ɗeh⁠ ⁠: ɗi madaꞌ a yíkíi faam fi baa fí yúhté biti ƴaati nís di iñi kah-kah ya faami raa, ɓeyaꞌ yin has deh, ɓeɓ yin kíilíɗ deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wonaꞌ Yéesú léeh yí ƴaa níi wocce ra, ɗi kolohte daaha saañce. ");
INSERT INTO ndv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Lahaꞌ ri gin wa ra, ɗi haalte tígë na ɗaguu ɓëewë Koope ra, na yëedíɗ wë. Di na yëeddëꞌ rí éemíl wë éemílë níi, tahte wa na wonu tih⁠ ⁠: «⁠ ⁠Ɗi kolaꞌ ham-hama na yëeddëꞌ rí iñƴee ra a doolaa na pagaꞌ ri kimtaanni ƴee ra dih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bee koy daaƴoha saa⁠ ⁠? Maryaama daa yaafi neh a⁠ ⁠? Ɗi koy-yaafi Saak, Suseef, Simoŋ a Yúɗ neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Koy-yaayyi ɓeleɓ íníh ee ɓéeɓ filiɓ fi yen a⁠ ⁠? Kon ɗi kolaꞌ iñƴee ɓéeɓ dih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kénsúu wë iñƴaa ra, wa gémúy rí. Ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Yonente heefuu gina dék ɗí rë a ɓëy faam wa na kut.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Bi gémúy wë rí, Yéesú pagay kimtaan caak daaha. ");
INSERT INTO ndv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bín fë, bi hen tii Yéesú lëyëŋ gina, Erot gëernëerí Galile kelohte ban fi. ");
INSERT INTO ndv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ɗi won súrgë yí tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ në keloh mi baa ra míntí hena Saŋ Batis⁠ ⁠! Ɗi waɗti këllú këllë ɓúudé daa tah ɗi mín paŋ kimtaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bee daa yee húmú kat Saŋ Batis ra⁠ ⁠: Erot daa húmú habroh Saŋ, pokrohte ri, ɓekrohte ri kasu af Erojat, ɓeleɓ Fílíp koy-boffi ɗi fi Erot. ");
INSERT INTO ndv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yee tah ra, biti Saŋ húmú won ɗi bín fë tih⁠ ⁠: «⁠ ⁠Waal neh fu naafe ɓeleɓ koy-boffu⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yii baa tahte Erot húmú fahaꞌ hawrohi húl, ndaa biti ɓëewë húmú habuu Saŋ yonente, tahte ri kaañay. ");
INSERT INTO ndv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nimilaꞌ bisa límú Erot kíilí baaha ra, ɗi cëgíɗté ndaje. Koy Erojat ɓeleɓ haalte na bec fíi haneella. Beja neɓaꞌte Erot ");
INSERT INTO ndv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","níi ri añohte biti yii meel ri kúkëyí ɓelaa ɓéeɓ, ɗi ay ri rii yeɗ. ");
INSERT INTO ndv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yaafa ɓekke ri nuf níi ɗi won Erot tih⁠ ⁠: «⁠ ⁠Tíké af Saŋ Batis sun waꞌ, fu yeɗ soꞌ ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Keeñ buur ɗúmpé ces, ndaa bi añoh ri fíi haneella, tahte ri wolaꞌte lecrohi af Saŋ kasiin, komu kúkëyë. ");
INSERT INTO ndv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Afa lecute tíkúté waꞌ, komute kúkëyí cafaƴ ka, kúkëyë kompe ri yaafi. ");
INSERT INTO ndv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Filoon fi baaha, taalibe yi Saŋ ayute, ɓeyute ɓúudé fë hacute ri. Koluu wa hacada ra, wa suute Yéesú në, ɓíllúté rí yee lah ra. ");
INSERT INTO ndv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kelaꞌ Yéesú yee kat Saŋ ra, ɗi ɓeɓ gaal, na saañ saami tígí ɗaayte, wuloh ɓëewë. Namuu keloh dúukëlí ɓëewë biti Yéesú saañce ra, wa koluute ginni wa, ɓeyute kotti wa, ñeyute ɓúk laaha na téebírú rí. ");
INSERT INTO ndv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cépëꞌ Yéesú gaala ra, ɗi otte ɓëewí caakute níi caak. Tígí daaha, keeña ɗúmpé waa na ces, ɗi yampe na paƴ jéríɗɗë. ");
INSERT INTO ndv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɗi hampe paƴi jéríɗɗë níi naꞌa na yëellëh. Tígí daaha, taalibe ya leɓuute ri wonu ri tih⁠ ⁠: «⁠ ⁠Wone ɓëewí ƴee saañ ginna leɓoh dee ra, wa saame yii túmún wë ɓúkkí wë, tígë homu yen dee ra lahay yin, te naꞌ ee saañ haale ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Miteh ri⁠ ⁠! Ɗon fi ƴah, yérí wë yii nay waa ñame.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun lahuu mbúurú iip a jén ana dee kut.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Këmí sëꞌ wë deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ɗi antee nah ɓëewë took feey sun fi gaaw fa. Ɗi ɓeɓpe mbúurú yí iippa a jénní ana ya, ɓéyíɗté afi yeelte sun, símpé Koope, antee lecsaꞌ mbúurëe, yeɗte wa taalibe ya, wa woruute wa ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓëewë ɓéeɓ ñamute níi laalute. Négírúu wooñnjiida ra, wa líiffé dama sabboo a dama ana. ");
INSERT INTO ndv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ɓëewë ñamu na ra warutee mit ow ƴaal júnní iip (5.000), bokaay ɓeleɓɓa a tuŋka. ");
INSERT INTO ndv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Filoon fi baaha, Yéesú yíppée nah taalibe yi haal gaala, wa këllëh rí ɓúgí yíníi laaha naꞌ-naꞌ, ɗi fi baa ɗi pëkís ɓëewë paaƴ. ");
INSERT INTO ndv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pëkísëꞌ rí ɓëewë rë, ɗi hécëhté saañce ɗaŋ Koope sun fi daŋin. Elgi Koo ɗeef ɓani afi kut daa tasu hatni baaha. ");
INSERT INTO ndv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wahtaa homaꞌ ri daaha ra ɓéeɓ, ɗeef gaala haalu taalibe ya ra ín jaanndohte ngilaaw ma leelii laaha ra, mboowaanna na mokil wa. ");
INSERT INTO ndv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lahaꞌ hagada ra, Yéesú tíl tílë sun fi mulaa, na saañ ri ɗeefri wa ra. ");
INSERT INTO ndv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Oluu wa ri na tíl sun fi mulaa, wa habuu biti koon yaa jíné⁠ ⁠; wa tíitúté na fogu. ");
INSERT INTO ndv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ɗi yíppée wëe won tih⁠ ⁠: «⁠ ⁠Hëbí affon⁠ ⁠! Ngënë tíití⁠ ⁠! Yaa soꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peer won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Hena biti ɗi ɗo fi Yíkëe rëe, won soꞌ mi ñee sun fi mulaa mi ɗeefiɗ ɗo.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Aye⁠ ⁠!⁠ ⁠» Peer yíppée cép gaala, na tíl sun fi mulaa, yuliɗte ɗii na. ");
INSERT INTO ndv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ndaa olaꞌ ri biti ngilaaw ma lahte doole, ɗi tíitté na dal honoh, foŋke won tih⁠ ⁠: «⁠ ⁠Yíkëe, sëmlëꞌ sëꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yéesú yíppée yeɗ yaꞌi hampe ri, antee rii won tih⁠ ⁠: «⁠ ⁠Fu néekíñëꞌ yih⁠ ⁠? Ngémën tasaꞌte ee⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wa ɓéeɓ ana anutee haal gaala, ngilaaw ma seemmite. ");
INSERT INTO ndv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tígí daaha, wa fa húmú filiɓ gaala ra ɓéeɓ ƴekute fíi Yéesú wonu tih⁠ ⁠: «⁠ ⁠Fu Koy Koope kaah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Húusúu wë laaha ra, wa teeruu Senesaret. ");
INSERT INTO ndv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yúhsúu ɓëewë dékú daaha Yéesú rë, wa wonute ri ɓëewë hatni baaha ɓéeɓ. Ɗi komute jéríɗɗë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓëewë na ɗagu ri biti jéríɗɗë leɓ wuti ƴaha nuf búubí kut. Te ɓëewë leɓu na ra ɓéeɓ wahute. ");
INSERT INTO ndv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jamanii baaha, i fariseŋ a i yëeddëh yí kootii Mëyíis koluu Yerusalem ayute wonu Yéesú tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«⁠ ⁠Yi tah taalibe yu në pëgíh yee ɓaahuu caacca ra⁠ ⁠? Yi tah balaa wa ñam raa, wa na ɓëeñnjíih ɓooñnjohi ñeete waal⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠A ɗon, yi tah ɗon na tíkú túuƴëꞌ yí Koope dín, fahaꞌi hami ɓaah yon⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ɗon yúhúté biti neh Koope won tih⁠ ⁠: “Lah tëeppítíi baappon a yaayyon”, te “ɓëyí won ɓos sun fi boffi mbée sun fi yaafi waɗti hawun húl” ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ndaa ɗon, ɗon yëeddúu biti yee waɗ ow ɓeɓ koon, tooppitaꞌ wa boffi mbée yaafi ra, ɗi won biti kut ɗi yeɗte wa Koope sarah raa, ");
INSERT INTO ndv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ɓëyí baaha lahriray boffi mbée yaafi yin. Ɗaaha, ɗon nísúté iña túuƴëꞌ Koope ra, ɗon tíkúté ɓaah yon. ");
INSERT INTO ndv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wonnon teem ɓúkkën⁠ ⁠! Yonente Isayii húmú wonaꞌ ron, te ri won kaah na bíní rí unee Koope bee ra⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Kaña na kañu soꞌ ɓëewí ƴee ra teem ɓúkkí wë. Yee hom keeññi wa ra haaƴaay a yee nahaꞌ mi ra. ");
INSERT INTO ndv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jaamiyoha na jaamiyuu wa soꞌ ra lahay njiriñ⁠ ⁠; iña na yëeddúu wë rë, ow doŋ daa sak wa.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yéesú antee dëek ɓëewë ɓéeɓ won wa tih⁠ ⁠: «⁠ ⁠Síkíríi, te ɗon ɓek iñƴee affon⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Iña na ñam ow ra neh daa na tah ɗi sobe⁠ ⁠; yee na ɗúh ɓúgë rë kay, daa na tah ɗi sobe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Taalibe yi leɓuute ri filoon fe wonu ri tih⁠ ⁠: «⁠ ⁠Fu yúhté biti iña won fu ra neɓaay fariseŋŋa a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Tal kilki Baasoꞌ fa sun yípëy rí, ay ɗofu. ");
INSERT INTO ndv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yéɗɗí wë⁠ ⁠: wa búumíɗɗí nooku i búumíɗ kay. Te búumíɗ nook búumíɗ rëe, wa ɓéeɓ ana ay keen ngas.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peer tahte won Yéesú tih⁠ ⁠: «⁠ ⁠Teeɓ fun yee na fahaꞌ fuu won sun fi yee na tah ow sobe ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ɗi won tih⁠ ⁠: «⁠ ⁠Ɗon fi ƴee nam, affon lahay daaha níi a ɗee ɓal a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ɗon yíih biti iña na ñam ow ra ɓéeɓ haalaꞌ ɓúgë, saañ lowa, ɗúh faana a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yii fús ɓúk ow nék, ɓëeꞌ ɗúhëꞌ rí nufi, te daa na tah ɗi sobe. ");
INSERT INTO ndv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nuf ow daa na komaꞌ iñi ɓossi ƴee ɓéeɓ⁠ ⁠: bëem ow, njaaliyoh a yii tappe njaaliyoh ɓéeɓ, loh, feliɗ ow a yah tii. ");
INSERT INTO ndv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iñƴaa daa na tah ow sobe, ndaa biti ow ñam te ri ɓooñnjeeh ɓooñnjohi ñeete waal, taheh ɗi sobe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yéesú kolohte daaha, saañce deyi Tíir a Sidon. ");
INSERT INTO ndv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lahaꞌ ri ra, lahte ɓelii dék daaha, ɗi ɓëy Kanaan. Ɓelaa yíppée ac na téebílëh rí a foŋ won tih⁠ ⁠: «⁠ ⁠Yíkëe, sédí Dawit dímlëꞌ sëꞌ kan⁠ ⁠! Koy soꞌ ɓeleɓ lahaꞌ yébítëh fi daa na mokil ri mokli misikke.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ndaa Yéesú tahay ɓúkí ɗii na. Taalibe ya leɓuute ri wonu ri tih⁠ ⁠: «⁠ ⁠Pëkísé ɓelii bee saañ⁠ ⁠; ɗi na lek fun a foŋ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yéesú tahte won tih⁠ ⁠: «⁠ ⁠Koope wol soꞌ ɓëy Israyel na kut, wa fa madu harri múuƴú múuƴë nen ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ɓelaa acce ƴekke fíyí won tih⁠ ⁠: «⁠ ⁠Yíkëe, dímlëꞌ sëꞌ kan⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɓosse biti ñami tuŋka yúfɗëe ɓuh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɓelaa loffe ri won tih⁠ ⁠: «⁠ ⁠Baa kaah ɓahaa, ndaa kaaꞌeeh ɓuh ñam ruuƴsiitta keenaꞌ yaꞌ yíkíi rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tígí daaha, Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu gaante ngém yaa ow⁠ ⁠! Yee fahaꞌ fu ra lahte.⁠ ⁠» Wahtaa wonaꞌ ri unni ƴaa ra, kúkëyí ɓelaa wahte. ");
INSERT INTO ndv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yéesú kolohte deyi Tíir a Sidon daaha, nimilte ɓúk laahi Galile. Lahaꞌ ri ra, ɗi lappe sun daŋ tookke na. ");
INSERT INTO ndv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɓëewí caakute ɗeefrute ri, ñéerúuté a ɓëewí ɓeeduu ɓeedoo, i búumíɗ, i lëfëñíɗ, i likiɗ a i ow kay caak ƴi jérú jérë. Wa komute Yéesú, ɗi paƴce wa. ");
INSERT INTO ndv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɓëewë éemúté oluu wa likiɗɗa na wonu ra, lëfëñíɗɗë koluute na tílú, cérrí ɓëewë ɓeeduu ra mante ti merees nen, búumíɗɗë na yeelu, wa ɓéeɓ na kañu ndami Koope fi ɓëy Israyel. ");
INSERT INTO ndv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Filoon fi baaha, Yéesú dëekké taalibe yi, won wa tih⁠ ⁠: «⁠ ⁠Mi yérémpé ɓëewí ƴeh⁠ ⁠! Hente waal éeyë woteh wa ewu soo na, te wa lahluy yii ñamun wa. Mi mínéh wëe yeris wa sayaꞌ loo holoŋ, toñeh wa ay kohe waala biti wa ƴahti nimil ginni wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Taalibe yi wonu ri tih⁠ ⁠: «⁠ ⁠Yii mín ñëmíɗ ɓëewí ƴee ɓéeɓ níi loo yi wa maƴ, yen ay waa ɗúhée dih luufi përéedí beh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yéesú meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗon lahuu mbúurú ɗíh⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun lahuu mbúurú paana a i jén ƴin-ƴin.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tígí daaha, ɗi wonte ɓëewë ɓéeɓ took feey. ");
INSERT INTO ndv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ɗi ɓeɓpe mbúurú yí paana ya a koy jénnë, símpé Koope, lecsaꞌte wa yeɗte taalibe yi, nahte wa woraꞌ wa ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓëewë ɓéeɓ ñamute níi laalute. Négírúu wooñnjiida ra, wa líiffé dama paana. ");
INSERT INTO ndv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɓëewë ñamu na ra henute ow ƴaal júnní iniil (4.000), bokaay ɓeleɓɓa a tuŋka. ");
INSERT INTO ndv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pëkísëꞌ Yéesú ɓëewë níi wa suute ra, ɗi haalte gaal, saañce deyi Magadan. ");
INSERT INTO ndv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Filoon fe, i fariseŋ a i saduseŋ fahuu olsohi Yéesú ayute ɗii na, nahute ri paŋ kimtaani nay teeɓee biti Koope daa wol ri. ");
INSERT INTO ndv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Naꞌ home haal ɗon ot sun-Koo luum raa, ɗon na yúhú biti Koo ay maal kéy fín fë. ");
INSERT INTO ndv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mbée bee hagaɗ lahte ɗon ot nérrë leɓoh feey raa, ɗon na yúhú biti ɗi ay toɓ. Ɗaaha, ɗon mínú yúhsëꞌ iña na teeɓaꞌ yii nay lahe sun-Koo ra, ɗon antee míníh yúhsëꞌ iña na teeɓaꞌ Koo woteh ƴee ra a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɗon fi ɓëy jamanii beh, ɗon ɓosute te ɗon yégúy Koope⁠ ⁠; ɗon meeluu kimtaani kolaꞌ ɗii na a⁠ ⁠? Añcaŋ ɗon ii teeɓu kimtaan hém henay yee húmú kat Sonaas ra.⁠ ⁠» Tígí daaha, ɗi kolohte waa na saañce. ");
INSERT INTO ndv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Filoon fi baaha, Yéesú a taalibe yi haalute gaal na suu ɓúgí yíníi laaha. Na suu wa ra, taalibe ya halute kúrëelëh mbúurú. ");
INSERT INTO ndv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Wëettíyíi affon⁠ ⁠! Lah mëytíi lëwíirí fariseŋŋa a saduseŋŋa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Taalibe ya na capituu wonu tih⁠ ⁠: «⁠ ⁠Biti yen lahuy mbúurú daa tah ɗi won yii bah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Bi yúh Yéesú yee na wonu wa ra, ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠Ɗon capituu yi biti ɗon lahuy mbúurú⁠ ⁠? Ngémën tasaꞌte ee⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kon ɗon yíih sëꞌ yúhë doom a⁠ ⁠? Ɗon nérsúuy mbúurú yí iippa woruu ɓëewí júnní iippa (5.000) ra a⁠ ⁠? Négírúu ron wooñnjiida ra, wa húmú líif dama ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɗon nérsúuy mbúurú yí paana ya woruu ɓëewí júnní iniilla (4.000) ra ɓal a⁠ ⁠? Wooñnjiida húmú négírúu ron ra húmú líif dama ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na won mi ron moytohi lëwíirí fariseŋŋa a saduseŋŋa ra, henaꞌ ɗi níi ɗon míníh yúh biti mi wonay ron woni mbúurú⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tígí daaha, wa na anuu yúh biti ɗi wonay wa woni lëwíirë na túmú mbúurú rë. Ɗi won wa biti kay, wa moytoh iña na yëeddúu fariseŋŋa a saduseŋŋa ra. ");
INSERT INTO ndv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Filoon fi baaha, Yéesú a taalibe yi koluute na suu deyi Sesare Fílíp. Ɗi meelte wa won tih⁠ ⁠: «⁠ ⁠Ɓëewë wonuu biti soꞌ mi Koy-ɓëeꞌ daa mi wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Lahte ɓëewí wonu biti daa fu Saŋ Batis, lahte ƴi wonu fu yonente Éelí, lahte ƴi wonu fu yonente Yérémí, i ow kay ɓal wonu ti fu ow di yonente ya.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ɗi meelilte wa won tih⁠ ⁠: «⁠ ⁠A ɗon, ɗon wonu biti daa mi wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoŋ Peer tahte won tih⁠ ⁠: «⁠ ⁠Daa fu Buura Koo fal ri ra, Koy Koope, Koy Koope fa na pes ɗa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yéesú won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Ɗo fi Simoŋ koy Sonaas, fu lahte sos-keeñ. Yee won fu ra ɗúhëey ɗoo na, Baasoꞌ fa sunaa-sun daa teeɓ ro baaha. ");
INSERT INTO ndv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Soꞌ nék, mi won ɗo tee⁠ ⁠: Daa fu Peer (daa ri⁠ ⁠: laꞌ), te may yíppée jaŋii soꞌ sun fi laꞌi baaha⁠ ⁠; te kúl kë ii rii mín ham. ");
INSERT INTO ndv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","May tíké céebí yí Nguur ki sun-Koo yaꞌu⁠ ⁠: yii kaaꞌ fu feey fi beh, ɗeef ɗi kaaꞌuu ɗaaha sun-Koo⁠ ⁠; te yii tah fu feey fi beh, ɗeef ɗi tahuu ɗaaha sun-Koo.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yéesú antee kaddaꞌ taalibe yi wa won ow kay biti daa ri Buura Koo fal ri ra. ");
INSERT INTO ndv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dalaꞌte bisi baaha, Yéesú yampe na teeɓ taalibe yi won wa tih⁠ ⁠: «⁠ ⁠Mi waɗtee saañ Yerusalem, mi mok dín fë níi mok yaꞌ yi ɓaha ya gina, kélfë yí seeƴoh ya a yaꞌ yi yëeddëh yí kootii Mëyíis⁠ ⁠; wa ay soo hawroh húl, te waali éeyë fë filoon fi húlí sëꞌ, may këllú ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tígí daaha, Peer dëekké rí, wa éccúuté, na won afa won tih⁠ ⁠: «⁠ ⁠Fu wonaꞌ yii baa ɗi Yíkëe⁠ ⁠? Koo ii yeris yii baa kat ɗo⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yéesú yíssëhté won ɗi tih⁠ ⁠: «⁠ ⁠Wuloh soꞌ Seytaane⁠ ⁠! Fu yahaꞌ waal. Ɗoni Koope bokuuy ɗee oluu ron yii bee ra⁠ ⁠; fu ot olaɗ ow.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yéesú antee yíssëh taalibe yi na, won wa tih⁠ ⁠: «⁠ ⁠Ɓëyí fahaꞌ ñéerëꞌ a soꞌ, ɗi helan iñi afi, enoh kurwahi, anti ñee tal soꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ɓëyí núp húl, ay ñak ñíiní⁠ ⁠; ndaa ɓëyí tah ñagi ñíiní af soꞌ, ay lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kaah neh biti alal mi ëldúnë caleh ow yaay ñíiní ë⁠ ⁠? Ñíiní yaayute ay tosuu ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","«⁠ ⁠Soꞌ mi Koy-ɓëeꞌ mi ƴahti nimil raa, may ñéyrée a malaaka yi soꞌ filiɓ ndami Baasoꞌ. Bín fë rëe, ow fi ow ɓéeɓ mi yíníl rí yii paŋ ri. ");
INSERT INTO ndv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mee ron won kaaf ka ra ee⁠ ⁠: lahte ɓëewí ewu ɗon na deh, balaa wa húl, wa ay ot soꞌ mi Koy-ɓëeꞌ, mi aye ayaɗ buur.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Waal pëenë filoon fe, Yéesú dëekké Peer, Saak a Saŋ, hécëhté a wa, kúɗté wë sun fi daŋi utte. ");
INSERT INTO ndv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Lahuu wa ra, Yéesú lofisohte fíi wë⁠ ⁠: kanama man naꞌ nen, búuɓɓí naaꞌ naaꞌo níi na tak. ");
INSERT INTO ndv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɗee a ɗeh, wa olute Mëyíis a yonente Éelí feeñiyuute na gonlu a ri. ");
INSERT INTO ndv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peer tahte won Yéesú tih⁠ ⁠: «⁠ ⁠Yíkëe, neɓpe biti yen homun tígí deh. Fu tah raa, mi yíp dút éeyë⁠ ⁠: fu lah yínë, Mëyíis yínë, Éelí yínë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peer hom wona, lahte nérí niiñce saw acce húunté wë⁠ ⁠; un ɗofohte filiɓ nérë won tih⁠ ⁠: «⁠ ⁠Bee daa Koy soꞌ. Mi fahaꞌte ri níi fahaꞌ, keeñ soꞌ sosse ɗii na níi sos. Síkíríi rí⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Keluu taalibe ya uni bah, wa tíitú tíitë níi lasuute feey, líhúuté. ");
INSERT INTO ndv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yéesú leɓohte wa, leɓpe faanni wa, won wa tih⁠ ⁠: «⁠ ⁠Këlíi, ngënë tíití⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tígí daaha, ɓéyrúu wë affi wa, wa olliluy ow, henay Yéesú a afi kut. ");
INSERT INTO ndv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wa koluu daaha na cépú daŋa. Wa homu cébë, Yéesú kaddaꞌte wa ɓíllí yee olu wa ra níi bín këllúun ɗi fi Koy-ɓëeꞌ ɓúudé rë. ");
INSERT INTO ndv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Taalibe ya meelute ri tígí daaha wonu ri tih⁠ ⁠: «⁠ ⁠Yi tah yëeddëh yí kootii Mëyíis na wonu biti Éelí waɗtee nimil paaƴ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠Ahaŋkay⁠ ⁠! Éelí waɗtee nimil paaƴ yugusaꞌ iña ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Te soꞌ mi beh, mee ron won ra ee biti Éelí nimilte, ndaa wa yúhsúuy rí, wa pagute ri yii neɓaꞌ wa. Te yee pagu wa ri ra, wa ay rii pagee soꞌ mi Koy-ɓëeꞌ ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tígí daaha, taalibe ya na anuu yúh biti ɗi wonaꞌ wa Saŋ Batis. ");
INSERT INTO ndv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tílúu wë níi wa lahute ɓëewë në rë, lahte ɓëyí leɓohte Yéesú, yeɗɗohte ƴekke fíyí ");
INSERT INTO ndv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na ɗaŋ ri won tih⁠ ⁠: «⁠ ⁠Yíkëe, yérmé koy soꞌ⁠ ⁠: ɗi lahaꞌ yébítëh fí daa na ham ri, te ri mokke níi mok. Ɗi hoñ ɗii kéenɗëꞌ kíi mbée muluɓ. ");
INSERT INTO ndv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi kompe ri taalibe yu paƴi, ndaa wa míníh yin na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tígí daaha, Yéesú tahte won ɓëewë tih⁠ ⁠: «⁠ ⁠Ɗon fi ɓëy jamanii beh, ɗon fi ɓossi ƴee gémúy Koope ƴee ra, may home ɗon na mi mújdé ron níi kirih⁠ ⁠? Këmí sëꞌ kúkëyë deh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yéesú komute kúkëyë, ɗi digiɗte uni túuƴcé yébítëh fë ɗúh⁠ ⁠; yébítëh fë yíppée yeris kúkëyë, kúkëyë wahte. ");
INSERT INTO ndv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Filoon fi baaha, taalibe ya hécúuté a Yéesú, meelute ri wonu tih⁠ ⁠: «⁠ ⁠Yi tah lígí yébítëh fë wooñ fun⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Néewë néewú ron ngém rë daa komaꞌ ri⁠ ⁠! Mee ron won kaaf ka ra ee⁠ ⁠: ɗon lah ngém wuti ƴaha ƴutuuɗ koon sah, ɗon nah daŋi bee koloh laay dín, ɗi ay ñee wonon. Daa mi won ɗon ɗi ee⁠ ⁠: yin ii ron wooñ⁠ ⁠!⁠ ⁠»  ");
INSERT INTO ndv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lahte bis, Yéesú a taalibe yi ɓéeɓ homu ílíƴ yínë Galile, ɗi won wa tih⁠ ⁠: «⁠ ⁠Soꞌ mi Koy-ɓëeꞌ, may yaayu ɓëewë, ");
INSERT INTO ndv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","wa hap soꞌ húl, te waali éeyë fë filoon fi húlí sëꞌ, may këllú ɓúudé.⁠ ⁠» Keluu taalibe ya unni ƴah, keeññi wa ɗúmpé. ");
INSERT INTO ndv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tílúu wë níi wa lahute Kafarnawum ra, ɓëewë na yeeku túmí Faam fi gaani Koope ra ayute Peer na, meelute ri wonu tih⁠ ⁠: «⁠ ⁠Yëeddëhën na yeraꞌ túmí Faam fi gaana a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peer won wa tih⁠ ⁠: «⁠ ⁠Ɗi na yeraꞌ kay⁠ ⁠!⁠ ⁠» Lahaꞌ Peer faam ra, Yéesú jëltëhté rí won tih⁠ ⁠: «⁠ ⁠Simoŋ, caa mi meel ro yin yínë⁠ ⁠: i wa daa na yeru buurra feey fa túm⁠ ⁠? Ɓëy ginni wa mbée ɓëy ginni kayya daa wa ílífú wë rë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peer won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëewí ginni kayya daa na yeruu.⁠ ⁠» Yéesú tahte won tih⁠ ⁠: «⁠ ⁠Kon ɓëewí wë nëníh në⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ɗee mín rii man ra ɓéeɓ, yen ɓanuy haayil keeññi wa. Kon paye laahin fu yees caasu⁠ ⁠; jénë nay roo ɗéɓée jah ra, habe ri fu kúnís ɓúgë⁠ ⁠: fay naa ɗeef hanjar hélíis. Lah nísé rí, fu yeɗ ɗi yeekoh yi túmë, hen túmí yen ana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Taalibe ya leɓuute Yéesú wahtii baaha, meelute ri wonu tih⁠ ⁠: «⁠ ⁠Daa lukki gaan filiɓ Nguur ki sun-Koo⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tígí daaha, Yéesú dëekké kúkëy ƴutuuɗ, kúɗté rí leelii wa, ");
INSERT INTO ndv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","antee waa won tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ɗon lofuy pesaɗ ɗon man ti di madu tuŋka nen, ɗon ii hëelíɗ Nguur ki sun-Koo. ");
INSERT INTO ndv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kon ɓëyí cépíɗ afi níi teemmaꞌ kúkëyí bee ƴin, ɓëyí baa daa lukki gaan Nguur ki sun-Koo. ");
INSERT INTO ndv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te ɓëyí af soꞌ tah ɗi ham kúkëy ti bee nen a yaꞌ ana, ɗeef ɗi ham soꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«⁠ ⁠Ndaa mas ɓëyí ɓek wuti ƴaha ow yínë bakaaɗ di taalibeyi soꞌ, wa fi tuŋki ƴee gémú soo na ra⁠ ⁠! Biti ri poku laꞌ gaan lúum betu leelii kísí fë, ɗi lap, daa gén ɗii na. ");
INSERT INTO ndv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mas ëldúnë di iña filiɓ na ɓek ow bakaaɗ ra⁠ ⁠! Ƴaaha mínéh ñak naam, ndaa mas ɓëeꞌ nay waa komee ra⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kon hena biti yaꞌu mbée kotu daa ɓeka ro bakaaɗ, lece ri fu bet ɗi baaŋŋin. Fu haalaꞌ pesa na ɗúméh rë a yaꞌ yínë mbée kot yínë, daa gén biti fu betu filiɓ kíi kë ii mëssí ƴím rë a yaꞌ ana a kot ana. ");
INSERT INTO ndv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te hena biti ílú ay roo ɓeke bakaaɗ, lukute ri fu bet ɗi baaŋŋin. Fu haalaꞌ pesa na ɗúméh rë a íl yínë kut daa gén biti fu betu njaar mi kíi kí safara a íl ana. ");
INSERT INTO ndv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«⁠ ⁠Mëytíi heef ow yínë sah di tuŋki ƴeh, wa fi taalibe yi soꞌ⁠ ⁠! Mee ron won ra ee⁠ ⁠: malaaka yi wa ínú hëbís Baasoꞌ fa sunaa-sun, homute na.  ");
INSERT INTO ndv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«⁠ ⁠Cëe mi meel ron⁠ ⁠: ow lah har tíméer (100) an naa múuƴlëꞌ yínë rëe, ɗi ay page yih⁠ ⁠? Ɗi ii hel harri sabay payniil a payniilla (99) daŋŋa homu wa ra, ɗi saañ saame bee múuƴ ɗë ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mee ron won kaaf ka ra ee⁠ ⁠: ɗi saam ɗi níi ri ot ɗi raa, keeña ay sos níi sos. Sosi keeña lahaꞌ ri har fi yíníi baa múuƴ níi olute ra, daa lukki gaan sosi keeña lahaꞌ ri harri sabay payniil a payniilli (99) kayya múuƴúy rë. ");
INSERT INTO ndv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Boffee ke ron sunaa-sun man ɗaaha nen⁠ ⁠: ɗi fahaay biti ow yínë sah di tuŋki ƴee múuƴ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Koy-yaafu tooñ ɗo raa, paye fu ɗaay a ri, fu won ɗi baaha. Ɗi síkírëh rë rëe, ɗeef hanndal ki ɗoni wëegíssé. ");
INSERT INTO ndv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ɗi kaaꞌ síkírëhú rëe, lah paye fu saam ow yínë mbée ow ana ɗoni wa ñéerëꞌ, fu nimil ɗii na ti di bíníyú rí Téerëe bitih⁠ ⁠: “Balaa yin lecu ɓéeɓ, lahan seede ana mbée éeyë.” ");
INSERT INTO ndv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ɗi kaaꞌ síkírëhí wë rëe, paye fu won ɗi jaŋiin. Ɗi kaaꞌ síkírëhí ɓëy jaŋaa raa, lah habee ri ti ɓëyí noneh ɓëewí Koope nen, mbée yeekoh túm. ");
INSERT INTO ndv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mee ron won kaaf ka ra ee⁠ ⁠: yii ɗon kaaꞌ ri feey fi beh, ɗeef ɗi kaaꞌuu ɗaaha sun-Koo⁠ ⁠; te yii ɗon tah ri feey fi beh, ɗeef ɗi tahuu ɗaaha sun-Koo. ");
INSERT INTO ndv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«⁠ ⁠Cëe mi ɓaat ɗon biti ow ana ɗon na goneel yin feey fi beh, a di míntí man yaa ɓéeɓ, wa déŋéen rí Baasoꞌ fa sunaa-sun raa, ɗi ay waa rii tahiɗ. ");
INSERT INTO ndv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yúhí biti tígí af soꞌ daa tahan ɓëewë teyaꞌ, wuti wa ƴahun ow ana, maa leelii wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tígí daaha, Peer leɓohte Yéesú, meelte ri won tih⁠ ⁠: «⁠ ⁠Yíkëe, koy-yaasoꞌ dékëe tooñi soꞌ raa, may home daa mi baale ri níi kirih⁠ ⁠? Níi hen waal paana a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ, mi wonay ro waal paana doŋ, fu waɗtee rii baalaꞌ waal sabay paana (70) níi hen waal paana⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«⁠ ⁠Ti ɗaaha nen, Nguur ki sun-Koo mín mëllúu a biti buur koloh léjëntëꞌ kabut ka lahru ri súrgë yí rë. ");
INSERT INTO ndv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ɗi na dal, ɗi komute ɓëyí lahiɗte ri hélsí caakke lool sah. ");
INSERT INTO ndv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bi mínéh súrgëe yíníl kabut ki, buura nahaꞌte biti ri yaayu ɓani ɓeleɓi a koyyi wa hen ñaam, alal mi ɓéeɓ yaayu ɓal, hélsë yínlúu kabut ka. ");
INSERT INTO ndv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tígí daaha, súrgëe yeɗɗohte hawohte kotti buura, ƴekke na ɗaŋ ɗi won tih⁠ ⁠: “On soꞌ rek Buur fu ham yaꞌ ya fu yeris kotta, may ro waa yíníl ɓéeɓ.” ");
INSERT INTO ndv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Buura yíppée ríi yérém baalte ri kabut ki ɓéeɓ, yerisse ri saañce faam. ");
INSERT INTO ndv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«⁠ ⁠Súrgëe ɗúh ɗúhë rek, teeꞌaꞌte a ow di ɓëewë wani boku légéy rë, bi lahiɗte ri kabut ki miteh yin. Ɗi yíppée poñe ɓëeꞌ níi wooƴce ri, na ɗaañnjoh won tih⁠ ⁠: “Yíníl sëꞌ hélsí sëꞌ⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ɓëeꞌ yeɗɗohte hawohte kotta, na ɗaŋ ɗi won tih⁠ ⁠: “On soꞌ rek kooja fu ham yaꞌ ya fu yeris kotta, may ro waa yíníl.” ");
INSERT INTO ndv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bee lahru ra nék, kaaꞌaꞌte síkírëh, ɗi antee naa tík téƴɗëhté ɓëeꞌ kasu níi bín yínlëe rí ɓëeꞌ kabut ka ɓéeɓ rë. ");
INSERT INTO ndv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lahte ɓëewí ɓani wa daa boku légéy maasuute ɓéeɓ⁠ ⁠; keeññi wa ɗúmpé ces, wa payute ɓíllúté buura yaa. ");
INSERT INTO ndv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tígí daaha, buura wolaꞌte súrgëe paŋ pagada ra won ɗi tih⁠ ⁠: “Daa fu ɓos níi tígí teem ɓos⁠ ⁠! Iña lahiɗ fu soꞌ ra ɓéeɓ, mi baalay ro wa ndah biti fu ɗaŋke soꞌ a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yi kaaꞌ ro fu yérém moroomu ɗo ɓal ti di yérmëꞌ mi ro nen⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kolaꞌ buura daa a neeɓaa yi, ɗi tíkké rí yaꞌ yi wohoh ya kasaa, ɗi moklu. Ɗi ay home daaha níi bín yínlëe rí kabut ki ɓéeɓ rë. ");
INSERT INTO ndv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ti ɗaaha nen, Baasoꞌ fa sun ay henee ow fi ow ɗon na ɓéeɓ ɗaaha biti ɓëeꞌ baaleh koy-yaafi keeñi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wocaꞌ Yéesú wona ra, ɗi kolohte Galile, saañce deyi Yúdée di hatni yíníi laahi Yurdeŋ. ");
INSERT INTO ndv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","I ow caak ñeyute tala⁠ ⁠; ɗi paƴce jéríɗ caak daaha. ");
INSERT INTO ndv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lahte fariseŋŋi ayute na saamu olsohi, meelute ri nda ow waɗtee mín yes ɓeleɓi biti wa mínlíih, a yii mín tah wa powaꞌ ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon yúhú yee bíníyú Téerëe rë maan⁠ ⁠? Dalaana, Koo fa sak ɓéeɓ rë “sak ow ƴaal a ow ɓeleɓ”, ");
INSERT INTO ndv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ɗi won tih⁠ ⁠: “Yii baa daa tah ow ƴaal ay ɓísëh a boffi a yaafi, pokoh ɓeleɓi na, wa hen yínë.” ");
INSERT INTO ndv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ɗaaha, wa henluy ana, wa tasu yínë. Kon iñi Koo daa boollaꞌ wa, ow ɓanan waa ɗaralsaꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseŋŋa tahute wonu tih⁠ ⁠: «⁠ ⁠Ƴaha ɗaaha raa, yi tah Mëyíis won biti ow mín yes ɓeleɓi biti ri saam kéedí mín teeɓaꞌ biti ɗi yesse kooda⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Súhí ron keeñ daa tah Mëyíis on ɗon yii bah, ndaa húmú lahay dalaana. ");
INSERT INTO ndv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Te mee ron won ra ee⁠ ⁠: ɓëyí yes ɓeleɓi te ɗeefa ɓelaa habuuy a ƴaal, kooɗ ɓeleɓ kay, njaaliyohte.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Taalibe ya wonu ri tih⁠ ⁠: «⁠ ⁠Hanndal ki ƴaal a ɓeleɓ ƴaha ɗaa raa, ɓanti kooɗ daa gén⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɓëewë ɓéeɓ neh daa mínú tah yii baaha, hém henay ɓëewë Koope on wa ri ra. ");
INSERT INTO ndv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kaah biti lahte ɓëewí míníh kooɗ, ndah tasaꞌi wa ƴaal te wa límúu ɗaa límëe⁠ ⁠; lahte ƴi yéŋké biti pagaɗ ow daa tah wa tasaꞌ ƴaal⁠ ⁠; lahte ƴi ii kooɗ ɓal ndah légéyírí Nguur ki sun-Koo. Ɓëyí mín tah yii baaha taha ri⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Filoon fi baaha, lahte ɓëewí homu komi Yéesú i kúkëy, fahuu biti ɗi tík yaꞌ yi sun fi wa ɗagiɗ wa, ndaa taalibe ya na wonu affi wa. ");
INSERT INTO ndv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Yéɗɗí tuŋka ac soo na, ngënë këddíi wë⁠ ⁠! Yúhí biti Nguur ki sun-Koo saamɗu mani wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ɗi antee tík yaꞌ yi sun fi tuŋka barkelte wa, ɓeyaatte waali na saañ. ");
INSERT INTO ndv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yéesú hom saaña, lahte kúkëyí wahambaanii leɓohte ri, won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, mi waɗti paga yii wuni bi níi mi lah pesa na ɗúméh rë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu meel soꞌ yi sun fi yii wunte⁠ ⁠? Koope kut daa na paŋ wun. Fu fahaꞌ haal pesa na ɗúméh rë rëe, lah page iña túuƴëꞌ Koope ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kúkëyí wahambaanaa meelte ri won tih⁠ ⁠: «⁠ ⁠Túuƴëꞌ yí ƴih⁠ ⁠?⁠ ⁠» Tígí daaha, Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ngënë mësíi bëem ow⁠ ⁠; ngënë mësíi njaaliyoh⁠ ⁠; ngënë mësíi loh⁠ ⁠; ngënë mësíi feliɗ ow⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","lah tëeppítíi baappon a yaayyon⁠ ⁠; te di fahuu ron affon, lah fëhíi moroommon ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɗi won Yéesú tih⁠ ⁠: «⁠ ⁠Yii waɗ soꞌ iñƴaa ɓéeɓ mi paŋke wa, kon mi talliil yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu fahaꞌ biti fu júɓ níi júɓ rëe, paye fu yaay iña lahaꞌ fu ra ɓéeɓ, fu woraꞌ cadum fa ñëkíɗɗë. Hen ɗaaha raa, fay lah alal sun-Koo. Fu woc raa, fu ac fu ñee tal soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kelaꞌ kúkëyí wahambaanaa unni ƴah, bi caak ri alal níi caak, yaa misikke ri keeñi níi misik. Ɗi kolohte na saañ. ");
INSERT INTO ndv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yéesú won taalibe yi tígí daaha tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: haal Nguur ki sun-Koo kofeelte yíkëe alal na⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ahaŋkay⁠ ⁠! Mi won tee ɓal⁠ ⁠: géléem haal gúl kúuc, daa lukki yooɓ biti yíkëe alal haal Nguur ki Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Keluu taalibe ya unni ƴah, affi wa kúnëhté, wa meelute Yéesú wonu tih⁠ ⁠: «⁠ ⁠Kon daa míntí múc⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ɗi yeelte wa, won tih⁠ ⁠: «⁠ ⁠Ow mínéh múcël afi, Koope kut daa mín ríi múcël. Lahay yii wooñ Koope⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peer won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓahaa ole⁠ ⁠! Fun helute iña ɓéeɓ, fun ñeyute talu. Yi na seh fun na nék⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: filiɓ pesi hasa na ac fíi rë, soꞌ mi Koy-ɓëeꞌ may took ñaani Nguur ki soꞌ. Yiin fin fa, ɗon fa ñeyu tal soꞌ ra, ɗon ɓal ɗon ay took ñaan Nguur sabboo a ñaan Nguur ana, ɗon ílíf talli sabboo a ana yi Israyel. ");
INSERT INTO ndv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɓëyí af soꞌ tah ɗi hel faami, koy-yaayyi, boffi, yaafi, koyyi mbée feeyyi, ɗi ay lah ƴi luk ƴaa caak fap, te ɗi ay lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ow caak di ɓëewë këllúu woteh ra ay míllëꞌ fayu, te ow caak di ɓëewë míllúu woteh ra ay këllëh fayu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«⁠ ⁠Nguur ki sun-Koo mín mëllúu a biti yíkëe meey koloh ɓaaɓ cúɓ, saañ saami súrgë yí ay rii légéyíré meeyi. ");
INSERT INTO ndv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Olaꞌ ri ra, ɓani wa júɓúuté biti ɗi ay yínlé ow fi ow waa na ɓéeɓ dëñé yínë, ɗi antee waa yeñ meeya. ");
INSERT INTO ndv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ɗi ɗúhëetté siñaakada, ɗi otte i ow kay na cagaaluu këemí gina, ");
INSERT INTO ndv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ɗi won wa tih⁠ ⁠: “Ɗon ɓal tílí ɗon légéyé meey soꞌ, mi yíníl ron.” ");
INSERT INTO ndv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɓëewí ƴaa suute. Ɗi ɗúhëetté lahaꞌ naꞌ leelu af ra a wahtu éeyë filoon fi baaha ɓal, te faraah ɗi ot ow raa, ɗi wonaꞌ wa yaa yínë. ");
INSERT INTO ndv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Míllëení ɗúh ɗeef naꞌa na dal yëellëh rë, ɗi ɗeefaatte i ow kay këemë, ɗi won wa tih⁠ ⁠: “Yi tah ɗon na homu deh bis múlgús ɗon légéyúy⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓëewë wonu ri tih⁠ ⁠: “Ow daa ɓeyay fun légéy.” Ɗi won wa tih⁠ ⁠: “Kon tílí ɗon légéyé meey soꞌ ɓal⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«⁠ ⁠Sosaꞌ naꞌa ra, yíkíi meeya won daga na tooppitoh alal mi ra tih⁠ ⁠: “Dëeké súrgë yë, fu yíníl wë. Lah ɗéɓée ɓëewë míllúu ɓeyu ra, fu míllëꞌ ƴee ɗéɓúu rë.” ");
INSERT INTO ndv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tígí daaha, súrgë yë míllúu ɓeyu bee na yëellëꞌ naꞌ ra, daa ɗéɓúu ac, ɓëeꞌ yínílté ow fi ow waa na ɓéeɓ dëñé yínë. ");
INSERT INTO ndv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Namaꞌ lah wahtii ɓëewë ɗéɓúu ɓeyu ra, wa sehu yínlí luk ƴah, ndaa ow fi ow waa na ɓéeɓ yeru dëñé yínë ti ɓëewí ƴín nen. ");
INSERT INTO ndv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Liiluu wa yínlí wë rë, yaa neɓaay wa, wa payute na wonu yíkíi meeya baaha ");
INSERT INTO ndv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","wonu tih⁠ ⁠: “Ɓëewí ƴee daa míllúu ac, légéyú wahtu yínë kut, fu téydëꞌté wë a fun yíníl, fun fa enduu légéyí misiga ndiŋ-ndiŋi naꞌa ra a⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yíkíi meeya loffe won ow yínë waa na tih⁠ ⁠: “Kooja, mi tooñay ro⁠ ⁠! Yen húmú júɓúu biti may roo yínlé dëñé yínë bisa neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kon habe yee waɗ ɗoo na ra fu saañ faam⁠ ⁠! Neɓaꞌ soꞌ mi yeɗ ɓëyée míllëꞌ rë teemi ƴuu raa, waal ow íníh në⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mi waray ɓek hélsí sëꞌ tígí neɓaꞌ soꞌ waro a⁠ ⁠? Am fu eeñnjaꞌ soꞌ naaꞌi keeñ soꞌ⁠ ⁠?”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yéesú lúsɗëꞌ anili dah won tih⁠ ⁠: «⁠ ⁠Ti ɗaaha nen, ɓëewë míllúu rë nay këllée fayu, ɓëewë këllúu rë míllëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Filoon fi baaha, wa ɓeyute waala na suu Yerusalem. Wa homu waala wa na suu, Yéesú hécëhté a taalibe yi sabboo a ana ya, won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«⁠ ⁠Síkíríi⁠ ⁠! Yen ee suu Yerusalem ra ee, gina nay tíkúu soꞌ mi Koy-ɓëeꞌ yaꞌ yi kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis rë. Wa ay soo aattiyaꞌ húl, ");
INSERT INTO ndv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","tík sëꞌ yaꞌ yi ɓëewë yëwúɗ neh ra. Wa fi ƴaa ay soo ñaawal, laɓisaꞌ soꞌ laraw, an soo daaƴ sun kurwah. Te waali éeyë fë filoon fi húlí sëꞌ, may këllú ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tígí daaha, ɓeleɓ Sebede a koyyi leɓuute Yéesú, ɓelaa ƴekke fíyí, fahaꞌ ɗaŋi yin. ");
INSERT INTO ndv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yéesú meelte ri won tih⁠ ⁠: «⁠ ⁠Fu fahaꞌ yi yaa ow⁠ ⁠?⁠ ⁠» Ɗi won ɗi tih⁠ ⁠: «⁠ ⁠Gap soꞌ biti fu took Nguur ku fayu raa, fu tëekíɗ koyyi ana yee ke soꞌ ƴee hëbísú⁠ ⁠: ɓëyí yínëe hom yaꞌi ñamaa fu, yínëe hom yaꞌi sugu fu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tígí daaha, Yéesú won tih⁠ ⁠: «⁠ ⁠Ɗon yíih yee ɗagu ron ra. Mbaa ron kaañute han gulii kofeel ka nay mii hane ra⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun kaañute ri kay⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ɗi tahaatte won wa tih⁠ ⁠: «⁠ ⁠Kaah biti ɗon ay han gulaa nay mii hane ra. Ndaa yi leŋke toogi yaꞌi ñamaa fi soꞌ mbée yaꞌi sugu fi soꞌ, daa mi na onaꞌ ri neh⁠ ⁠; ɓëewë Baasoꞌ waaƴiɗ wa tíkkí ƴaa ra daa lahuu wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Keluu taalibe yi kayya yii baa ra, wa neeɓuute koy-yaayyi ana ya. ");
INSERT INTO ndv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tígí daaha, Yéesú dëekké wë ɓéeɓ, won wa tih⁠ ⁠: «⁠ ⁠Ɗon yúhúté biti yíkëe yí ginna a ɓëewí gaanna hom ñaamluu ɓëewí kayya ñaamloo, noote wa⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yii baa waray lahaꞌ ɗaaha hanndal kon. Ow di ɗon na fahaꞌ hen ow gaan raa kay, ɗi henan súrgíi ɓëewí kayya. ");
INSERT INTO ndv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Te ɓëyí fahaꞌ hen kélfë ɗon na, ɗi henan ñaami ɓëewí kayya. ");
INSERT INTO ndv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ti ɗaaha nen, soꞌ mi Koy-ɓëeꞌ mi aay biti ɓëewë nay hene súrgë yí sëꞌ. Mi ac biti kay, daa mi nay hene súrgíi ɓëewë níi mi yeraꞌ ñíin sëꞌ tosaa pes ow caak.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lahuu Yéesú a taalibe yi Yéríkëe níi wa na ɗúhú gina ra, i ow caak ñeyute tala. ");
INSERT INTO ndv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lahte búumíɗɗí ana yi tookute ɓúk waala. Keluu wa biti Yéesú daa na ñee daaha ra, wa na fogu wonu tih⁠ ⁠: «⁠ ⁠Yíkëe, sédí Dawit, yérém fun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɓëewë na wonu affi wa, fahuu biti wa héddëh, kaaꞌeeh wa lukuu foŋ na na wonu tih⁠ ⁠: «⁠ ⁠Yíkëe, sédí Dawit, yérém fun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tígí daaha, Yéesú caŋke, dëekké wë won wa tih⁠ ⁠: «⁠ ⁠Ɗon fahuu biti mi pagira ron yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wa wonu tih⁠ ⁠: «⁠ ⁠Yíkëe, page níi íllí fun wërsëh, fun mín ot⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yéesú yérémpé wë, leɓpe íllí wë. Íllí wë yíppée wërsëh, wa na olu, wa ñeyute tali. ");
INSERT INTO ndv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tílúu Yéesú a taalibe yi níi wa leɓuute Yerusalem, yeeddaꞌ ki daŋi Ëlíiffë di hëbís Betfase ra, Yéesú wolte ow ana waa na ");
INSERT INTO ndv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","won wa tih⁠ ⁠: «⁠ ⁠Pëyí gina fíi bín, ɗon haale na rek, ɗon ay naa ɗeef mbaam ɓeleɓ poku, koy ka hom hëbísí. Lah pëkísí wë, ɗon kom soꞌ wa. ");
INSERT INTO ndv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ow tah ɗon na raa, lah wëní rí biti Yíkëe daa sohlaꞌ wa. Hen ɗaaha raa, ɗi ay ron yíppí yeris, ɗon kúɗ wë deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yee húmú won yonentaa ra lahaꞌte ɗah. Ɗi húmú won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«⁠ ⁠Wëní ɓëy Siyoŋ tee⁠ ⁠: Ëlí⁠ ⁠! Buuron ee ac ɗon na ra, sosse níi sos, yaagoh sun mbaam, sun cúmbúr, koy mbaam-séf.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Taalibe ya sayuu ɗaaha, pagute yee nah wa Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wa kalute mbaam fi ɓelaa a cúmbúrë, larute sabidoorri wa sun, Yéesú yaagohte. ");
INSERT INTO ndv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dúukëlí ɓëewë húmú në rë, ƴee ɓeyu sabidoorri wa larute waala, ƴee saamu i yaꞌ kilik hilsiɗ larute waala ɓal. ");
INSERT INTO ndv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ɓëewë ɓéeɓ, dalaꞌte ƴee paaꞌuu Yéesú fíi a ƴee paaꞌuu ri filoon ra, ɓéyrúté unni wa sun na njooɓu ri wonu tih⁠ ⁠: «⁠ ⁠Oosaanaa⁠ ⁠! Sédí Dawit laha ndam⁠ ⁠! Koo-Yíkëe barkela ɓëeꞌ ɗi wol ri ra⁠ ⁠! Oosaanaa⁠ ⁠! Koo laha ndam di sunaa-sun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yéesú na haal Yerusalem, gina ɓéeɓ na hégíƴëh. Ɓëewë na meeluu na wonu tih⁠ ⁠: «⁠ ⁠Ɓëyée waɗti hena wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wa meelee raa, ɓëewë ɓani Yéesú ñéerúu rë tahe wone tih⁠ ⁠: «⁠ ⁠Yaa Yéesú, yonentaa dék Nasaret di Galile ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Lahaꞌ Yéesú gina níi ri haalte baylii Faam fi gaani Koope ra, ɗi yampe na lík yaayoh ya a lomoh ya homu na ra ɓéeɓ, júlkëñcé taabulli ɓëewë në lofrantuu hélíis rë a ñaanni yaayoh yi bëdú yë, ");
INSERT INTO ndv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ɗi antee won tih⁠ ⁠: «⁠ ⁠Koo wonay Téerëe bitih⁠ ⁠: “Faam soꞌ ay wonuu faam fa na ɗaguu ra” a⁠ ⁠? Ndaa ɗon yíssúté rí “faam lohoh”⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Filoon fi baaha, i búumíɗ a i lëfëñíɗ leɓuute Yéesú baylaa daaha ɓal, ɗi paƴce wa. ");
INSERT INTO ndv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Oluu kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis iñi éemílëꞌ yë an ɗii kolaꞌ paŋ, wa olute tuŋka na fogu Faam fi gaana na wonu⁠ ⁠: «⁠ ⁠Oosaanaa⁠ ⁠! Sédí Dawit laha ndam⁠ ⁠!⁠ ⁠» ra, keeññi wa haayte, ");
INSERT INTO ndv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","wa wonu ri tih⁠ ⁠: «⁠ ⁠Fu keloh yee na wonu tuŋka ra a⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mi keloh na kay⁠ ⁠! A ɗon, ɗon kéllúy unnee ke Téerëe ƴee neh a⁠ ⁠? Téerëe won tih⁠ ⁠: “Fu paŋke níi wobiitta a baakerra na kañu ro.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ɗi antee waa hel daaha, saañce Betani, neeꞌte dín fë. ");
INSERT INTO ndv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yíilëꞌ Koo kéy ɓaaɓ fin Yéesú na nimil Yerusalem ra, yaaɓ hampe ri. ");
INSERT INTO ndv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ɗi séenté tal een ɓúk waala, ɗi ɗalte⁠ ⁠; ndaa lahaꞌ ri na ra, gét nëe saaf, ɗi olay na koy. Tígí daaha, ɗi won tih⁠ ⁠: «⁠ ⁠Fii límíl koy yee tas fíi rë⁠ ⁠!⁠ ⁠» Una na lús, tal eena súhté níi lahte keeña. ");
INSERT INTO ndv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Oluu taalibe ya yii baaha, wa tíitú tíitë níi na wonu tih⁠ ⁠: «⁠ ⁠Tal eeni bee mínëꞌ súh súhí gaawi bee ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yéesú tahte won tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ɗon gém te ɗon lëhíh nuf ana koon, mi teyay ron biti ɗon ay mín yee paŋ mi tal eeni baa ra doŋ, ndaa ɗon nah daŋi bee ɗofoh dee saañ yípée kísí, ɗi ay rii paŋ. ");
INSERT INTO ndv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ɗon gém ɗëe, yúhí biti yii ɗon ɗaŋ ri Koope ɓéeɓ ɗon ay rii liil.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Filoon fi baaha, Yéesú haalte Faam fi gaani Koope, na yëeddëꞌ. Kélfë yí seeƴoh ya a ɓaha ya gina ɗeefute ri daaha, wonu ri tih⁠ ⁠: «⁠ ⁠Fu pagaꞌ iña na paŋ fu ra sañ-sañi bih⁠ ⁠? Daa nah ro paŋi wa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yéesú loffe wa won tih⁠ ⁠: «⁠ ⁠Soꞌ ɓal may ron meel yin yínë. Ɗon tiil soꞌ na raa, may ron teeɓ ɓëeꞌ yeɗ soꞌ sañ-saña na pagaꞌ mi wa ra. ");
INSERT INTO ndv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wëní sëꞌ⁠ ⁠: bëtsë në húmú bëtís Saŋ ɓëewë rë, Koope daa húmú nah ri mbée ɓëewë⁠ ⁠?⁠ ⁠» Tígí daaha, wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Yen won biti Koope daa nah ri raa, ɗi ay yen meel yee tah níi yen gémúy iña won Saŋ ra. ");
INSERT INTO ndv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te yen won biti ɓëewë daa nahu ri raa, yen helun nuf ɓëewë në, ndée wa ɓéeɓ habuu biti Saŋ húmú yonente.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wa wonu Yéesú tígí daaha tih⁠ ⁠: «⁠ ⁠Fun yíih yin na⁠ ⁠!⁠ ⁠» Ɗi nampee waa won tih⁠ ⁠: «⁠ ⁠Kon soꞌ ɓal, mii ron won ɓëeꞌ yeɗ soꞌ sañ-saña na pagaꞌ mi wa ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon yúhú yi anili beh⁠ ⁠? Lahte ɓëyí húmú lahaꞌ koy ana. Lahte bis, ɗi payte otte ɓëyí yínëe won ɗi tih⁠ ⁠: “Fii pay fu yér meey woteh aa kooja⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Koy ka won ɗi tih⁠ ⁠: “Mi eɓaay pay meey woteh baap⁠ ⁠!” Ndaa hompe níi ɗi réeccíyëhté yee won ɗi boffa ra, ɗi kolohte saañce meey. ");
INSERT INTO ndv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Filoon fi baaha, boffa payte otte ɓëyí ana fa túuƴcé rí waali meeya. Ɓëyí yíníi bee won ɗi tih⁠ ⁠: “Kotta ƴee baap⁠ ⁠!” Ndaa ɗi míllëey pay. ");
INSERT INTO ndv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Cëe mi meel ron⁠ ⁠: Ɓëyí bih, di wa fi ana yi ƴaaha daa paŋ yee fahaꞌ boffa ra⁠ ⁠?⁠ ⁠» Ɓëewë wonu tih⁠ ⁠: «⁠ ⁠Bee ɗéɓ ɗë⁠ ⁠!⁠ ⁠» Yéesú tíkké won tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: Yeekoh yi túmë a ɓeleɓɓa na tílú rë ay ron hel, wa haal Nguur ki Koope. ");
INSERT INTO ndv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ahaŋkay, Saŋ acce teeɓpe ron di na pesuu pesi júɓpé, te ɗon gémúy woni⁠ ⁠; ndaa yeekoh yi túmë a ɓeleɓɓa na tílú rë gémúté rí. Te filoon fi bee oluu ron ƴaa ra ɓéeɓ, dara hégíƴëy ron níi tah ɗon lofisoh, ɗon gém woni.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yéesú wonil wa tih⁠ ⁠: «⁠ ⁠Síkíríi anili yíníi beh⁠ ⁠: Lahaꞌ ɓëyí húmú yíp meey reseñ, líikké rí, yugusse tígë nay pooƴuu reseña ra, saampe dút, ɗi antee rii yeraꞌ ndalu, saañce ɓaaɓ. ");
INSERT INTO ndv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nonaꞌ reseña ra, ɗi wolte súrgë yí línëh yë në, nda wa yeɗ ɗi wodi. ");
INSERT INTO ndv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ndaa lahuu wa ra, línëh yë habute wa, laɓute ɓëyí yínëe laɓɓi misikke, hawute yínëe húl, bee tíkëh në rë wa tawsuute ri laꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Filoon fi baaha, yíkíi meeya wolaatte i súrgë kay ƴi luku ƴee ɗéɓ ɗë caak. Lahuu wa ra, línëh yë pagute wa yee pagu wa ɓëewë ɗéɓú rë. ");
INSERT INTO ndv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ɗi míllëꞌ wol koy ki ƴaali, won nufi tih⁠ ⁠: “Man biti wa ay yeɗ koy soꞌ cér⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ndaa séenúu línëh yë koy ka, wa wonu hanndal ki wa tih⁠ ⁠: “Lamoha abee kan⁠ ⁠! Ëyí yen hap ɗi húl, yen ɓeɓ meeya.” ");
INSERT INTO ndv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lahaꞌ ri ra, wa yípútée ríi ham, ɗúhrúté rí meeya, hawute ri húl. ");
INSERT INTO ndv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mi meel ron leegi⁠ ⁠: yíkíi meeya ac raa, ɗi ay page línëh yí ƴaa yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Ɗi ac ɗaa, ɗi ay bëem línëh yë sohooru ƴaa ra ɓéeɓ, ɗi anti yeɗ meeya línëh kayyi ay rii yeɗ wodi biti reseña non fayu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon yúhú yee bíníyú Téerëe bee ra maan⁠ ⁠? “Laꞌa habuu taɓahoh ya biti lahay njiriñ ra daa míllëꞌ ham lasa. Koo-Yíkëe daa pagaꞌ ri ɗaaha te ri neɓpe yeel lool.” ");
INSERT INTO ndv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Daa tah mi won ɗon biti Nguur ki Koope ay paketu yaꞌ yon, yeru ɓëewí légéyí wë ay púl kaah.  ");
INSERT INTO ndv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yii leŋke laꞌi baa nék, ɓëyí baɓoh na ɓéeɓ ay korsaꞌ, te laꞌa keen sun ow raa ay rii ɗakaƴaꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Keluu kélfë yí seeƴoh ya a fariseŋŋa unni ƴah, wa yúhúté biti Yéesú wonaꞌ wa. ");
INSERT INTO ndv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wa na saamu ɗee nay wa rii habee ra, ndaa bi ɓëewë ɓéeɓ habuu Yéesú yonente, wa kaañuy. ");
INSERT INTO ndv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yéesú ñeyaatte wa léeh won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«⁠ ⁠Nguur ki sun-Koo man biti lah buuri húmbëlíɗ koohi kílëek rë nen. ");
INSERT INTO ndv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ɗi wolte súrgë yí pay dëegí ɓëewë gapu kílëegë rë, wa kaaꞌuute ac. ");
INSERT INTO ndv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ɗi wolaatte i súrgë kay woni wa bitih⁠ ⁠: “Mi waaƴce kílëegë. Mi happe fañnji soꞌ a júrë lukki dúuf rë. Iña ɓéeɓ wocce, wa talluu ac⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ndaa ɓëewë dëekú rë tíkúy gaba nuffi wa⁠ ⁠: ƴee suute meey, ƴee sohle yi wa, ");
INSERT INTO ndv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ɓëewí kayya habute súrgë yë, moklute wa níi bëemúté wë. ");
INSERT INTO ndv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kelaꞌ buura yaa, keeña haayte, ɗi yeñce soldaarri ɗakaƴaꞌi ɓëewí sëhëeríɗɗí ƴaa bëemúu ow ƴaa ra, wa tam gin wa. ");
INSERT INTO ndv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tígí daaha, ɗi won súrgë yí tih⁠ ⁠: “Ñami ndaje ma nonte, ndaa ɓëewë gapu ra cëlíh rí. ");
INSERT INTO ndv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kon tílí séllíkkí waalla, ɓëyí ɗon ot ɗi ɓéeɓ dëekí rí ndaje ma.” ");
INSERT INTO ndv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tígí daaha, súrgë yë koluute, tawute affi wa waalla, dëekúté ɓëewë ɓani wa teeꞌuu ra, ƴee ɓosu a ƴee wunu ra ɓéeɓ teeꞌuute ndaje ma níi faam fa líiffé. ");
INSERT INTO ndv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«⁠ ⁠Tígí daaha, buura acce kénsëhí ɓëewë. Lahaꞌ ri ra, ɗi otte ɓëyí ɓekaay yéré yë waɗ ɗii ɓekoh ra. ");
INSERT INTO ndv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ɗi won ɓëeꞌ tih⁠ ⁠: “Kooja, fu haalaꞌ dee ɗíh a yéré yë faanu⁠ ⁠?” Ɓëeꞌ lahay yii wona ri. ");
INSERT INTO ndv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tígí daaha, buura won súrgë yí tih⁠ ⁠: “Hëbí rí ɗon pokalsaꞌ kotta a yaꞌ ya, ɗon bet ɗi ñúusë ëssín, ɗi foge dín fë ŋafee níi tíñë lec.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ow caak dëekúté naam, ndaa ƴee tansu ra caakuy.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fariseŋŋa koluu daaha, hécúuté na peenuu ɗee nay wa rii fíirée rë, di iña na won ri ra. ");
INSERT INTO ndv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tígí daaha, wa yejute i ow di taalibe yi wa ɗii na, ñéerúuté a i ow di ɓëewí Erot. Ɓëewí ƴaa wonu Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun yúhúté biti fu wonaꞌ kaah⁠ ⁠: fu yëeddëꞌ yee nahaꞌ Koope ra kah-kah. Fu na yeeleeh ow jëmmíi, fu na yeɗɗeh ow kúrëelëh rë. ");
INSERT INTO ndv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kon won fun nda kootii yen onaꞌte biti Sesaar yeru túm mbée onaay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bi yúh Yéesú nuffi ɓossa waa na, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ƴee wonni ron teem ɓúkkën ƴee ra, ɗon ay fíiré sëꞌ ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Téeɓí sëꞌ hélsí hanjara na yeruu túm ɗë dee noo mi ot⁠ ⁠!⁠ ⁠» Wa komute ri hanjara. ");
INSERT INTO ndv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Netli wah a tii wah daa na⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Ƴi Sesaar.⁠ ⁠» Ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Kon yérí Sesaar yee lahaꞌ ri ra, ɗon yeɗ Koope yee lahaꞌ ri ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Keluu wa uni bah, wa éemúté níi éem, helute ri daaha suute. ");
INSERT INTO ndv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yiin fi baaha, i saduseŋ, wa fa wonu biti koloh ɓúudé lahay ra ayute Yéesú në, wonu ri tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«⁠ ⁠Ɓahaa, Mëyíis húmú túuƴëꞌté bitih, ɓëyí húl hel ɓeleɓ te ɗeef ɓani ɓelaa liiluyti lah koy, ñéedë waɗtee lam ɓelaa, saamiɗ ɓahii tal. ");
INSERT INTO ndv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Te kíilë, húmú lahte koy-yaay paana⁠ ⁠: bee ɓaha waa na ra kooɗte, ɓani ɓelaa liiluyti lah koy, ɗi húlté, hellaꞌte ri ñéedë. ");
INSERT INTO ndv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bee ñee na ra kooɗte ɓelaa, ñeete kotta húlté. Ɓëyí éeyë fë tíkëhté në ti ɗaaha nen ɓal, húlté. Na hen ɗaaha níi wa fi paana ya ɓéeɓ ñeyute kooda, húlúté te ow lahay na koy. ");
INSERT INTO ndv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Filoon fe, ɗi fi ɓelaa tahte ɓal húlté. ");
INSERT INTO ndv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kon leegi, yiin nay kolee ɓëewë ɓúudé rë, daa nay lahee ɓelaa waa na te wa ɓéeɓ koorute ri⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon yíih yee won Téerëe rë a ɗee lahaꞌ Koope doole ra daa tah ɗon héllëꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yiin nay kolee ɓëewë ɓúudé rë, ƴaal a ɓeleɓ ii koorantaꞌ⁠ ⁠: pesi wa kay ay madee a pesi malaaka ya sun-Koo nen. ");
INSERT INTO ndv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Te yii leŋke kolohi ɓëewë húlú rë ɓúudé, ɗon yíih yee won ɗon Koope ra a⁠ ⁠? Ɗi won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Daa mi Koope fi Abraham, Koope fi Isaak, Koope fi Yakop.” Kon Koope, ɗi Koope fi ɓëewë húlú rë neh, ɗi Koope fi ɓëewë na pesu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɓëewë húmú keluu iñƴaaha ra ɓéeɓ éemúté ɗee na yëeddëꞌ rí rë. ");
INSERT INTO ndv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Keluu fariseŋŋa biti Yéesú téƴcé ɓúkkí saduseŋŋa ra, wa olantuute filiɓ fi wa. ");
INSERT INTO ndv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ow yínë waa na, non yëeddëh yí kootii Mëyíis, fahaꞌ olsohi Yéesú, meelte ri won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«⁠ ⁠Ɓahaa, túuƴëꞌí bi daa lukki lah solo filiɓ Kootaa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠“Lah fëhíi Koo-Yíkëe Koope fon di keeññon ɓéeɓ, di peson ɓéeɓ a nuffon ɓéeɓ.” ");
INSERT INTO ndv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Baa daa túuƴëꞌë lukki lah solo ra. ");
INSERT INTO ndv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Te lahte na kay bi lahte solo ti baa nen, won tih⁠ ⁠: “Di fahuu ron affon, lah fëhíi moroommon ɗaaha.” ");
INSERT INTO ndv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Túuƴëꞌ yí ana yi ƴah, daa wa níillí Kootaa a iña yëeddúu yonente ya ra ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bi lísú fariseŋŋa tígë, Yéesú nampee waa meel won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«⁠ ⁠Ɗon yúhú yi Buura Koo fal ri ra na⁠ ⁠? Ɗon habuu biti ɗi sédí wah⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Ɗi sédí Dawit.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Kon yi tah húmú haalaꞌ Ruuhi Koope Dawit ra, ɗi dëekëꞌ Buura Koo fal ri ra Yíkëe⁠ ⁠? Ɗi húmú won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Koo-Yíkëe won Yíkíi sëꞌ tih, tooke hëbís sëꞌ, yaꞌi ñamaa fi soꞌ deh, níi bín nëy míi kéenɗée kaaꞌoh yu kottu feey ra.” ");
INSERT INTO ndv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ɗi fi Dawit dëekëꞌ rí Yíkëe rëe, kon Buura Koo fal ri ra mínëꞌ hen sédí ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ow yínë sah di waa na mínéh ríi lof di yee meel wa ri ra. Kolaꞌte bah, ow kaañlay rii meelil yin kay. ");
INSERT INTO ndv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Filoon fi baaha, Yéesú yíssëhté ɓëewë a taalibe yi na, won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«⁠ ⁠Yëeddëh yí kootii Mëyíis a fariseŋŋa daa nahu yëeddëꞌí kootii Mëyíis. ");
INSERT INTO ndv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kon lah ñéyí yii wa won ɗi ron, ɗon paŋ iña na yëeddú wë ɗon ɗa⁠ ⁠; ndaa ngënë mëllíi wë pagaɗɗi wa, ndah wa na pëgíh iña na yëeddúu wë rë. ");
INSERT INTO ndv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wa hom pokuu sayyi gaante, wa en wa ɓëewë, te wa na hëbríih wë dalaa sah. ");
INSERT INTO ndv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yii paŋ wa ɓéeɓ, wa fahuu biti ɓëewë ot wa. Ngérté yí unni Koo ya na poku wa yaꞌ yi wa a púkkí wë rë daa na lukki gaan, te mbacci búuɓɓí wë daa na lukki ut. ");
INSERT INTO ndv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Daa wa na fahuu ɗéɓpí ñam biti ndaje lah, te wa tookuu ñaanna këllëh di ílíƴƴë na ɗaguu Koope ra. ");
INSERT INTO ndv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wa fahuu biti wa woduun wodaɗ kélfë biti wa hom këemmë. ");
INSERT INTO ndv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ɗon nék, ngënë tëhí biti ow wodaꞌ ron wodaɗ kélfë, ɗon ɓéeɓ i koy-yaay te ɗon lahuu kélfë yínë kut. ");
INSERT INTO ndv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ngënë dëekíi ow “Baap” hanndal kon, ɗon lahuu Baap yínë kut⁠ ⁠: ɗi bín sun. ");
INSERT INTO ndv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ngënë tíkí affon njíit, ɗon lahuu njíit yínë kut⁠ ⁠: ɗi Buura Koo fal ri ra. ");
INSERT INTO ndv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ɓëeꞌ lukki gaan ɗon na ra daa nay hene súrgëen ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yúhí biti ɓëyí ɓéyíɗ afi ɓéeɓ ay cépírú, te ɓëyí cépíɗ afi ɓéeɓ ay ɓéyrú. ");
INSERT INTO ndv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«⁠ ⁠Mas ɗon fi yëeddëh yí Kootaa a ɗon fi fariseŋŋa, ɗon fa wonnon teem ɓúkkën ɗë⁠ ⁠! Ɗon kaaꞌuute ɓëewí kayya haal Nguur ki sun-Koo. Ɗon fi ƴah, ɗon kaaꞌuute haal, ɗon anutee kaaꞌ wa fa fahuu ra haal.  ");
INSERT INTO ndv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«⁠ ⁠Mas ɗon fi yëeddëh yí Kootaa a ɗon fi fariseŋŋa, ɗon fa wonnon teem ɓúkkën ɗë⁠ ⁠! Lahay tígí ɗon ɓekuy na kotton saam wuti ƴaha ow yínë kut, ɗon ɓek ɗi yoonon⁠ ⁠; te ɗon ot ɗi níi ɗi haal ɗon na raa, ɗon yah ri níi ri luk ron ɓos, coono fi safara waɗ ɗi ana. ");
INSERT INTO ndv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«⁠ ⁠Mas ɗon fi njíittí ƴee búumíɗ ƴee ra⁠ ⁠! Ɗon wonu ti ow añoh ñeyaꞌ ri Faam fi gaani Koope raa, ɗi mín ɓanti paŋ yee añoh ri ra, ɓëeꞌ ñeyaa añohi úrísë Faam fi gaana raa nék, ɗi waɗtee paŋ yaa. ");
INSERT INTO ndv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tisoh yi yulkiɗɗi ƴeh⁠ ⁠! Búumíɗɗí ƴeh⁠ ⁠! Hanndal ki úrís a Faam fi gaana bi daa lukki lah solo⁠ ⁠? Ɗi Faam fi gaana fa tah úrísë sela ra neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ɗon wonute biti ɓal ow añoh ñeyaꞌ ri tígë na hawruu ra raa, ɗi mín ɓanti paŋ yee añoh ri ra, ɗi ñeyaꞌ añohi yee hawu sun fi tígë rë rëe nék, ɗi waɗtee paŋ yaa. ");
INSERT INTO ndv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Búumíɗɗí ƴeh⁠ ⁠! Hanndal ki tígë na hawruu ra a yee hawu ra bi lukki lah solo⁠ ⁠? Ɗi tígë na hawruu tah yee hawu ra sela ra neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yee lah ra biti kay, ɓëyí añoh ñeyaꞌ ri tígë na hawruu ra, añohi kúrëelëhté tígë a iña sun fi hawraa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te ɓëyí añoh ñeyaꞌ ri Faam fi gaana na, añohi kúrëelëhté Faam fa a Koope fa dék në rë. ");
INSERT INTO ndv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ɓëyí añoh ñeyaꞌ ri sun-Koo, añohi kúrëelëhté ñaani Nguur ki Koo a ɗi fi Koope fa took na ra. ");
INSERT INTO ndv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«⁠ ⁠Mas ɗon fi yëeddëh yí Kootaa a ɗon fi fariseŋŋa, ɗon fa wonnon teem ɓúkkën ɗë⁠ ⁠! Yii lín ɗon ɓéeɓ, ɗon woɗ na Koope níi lukaꞌ ƴee lukki ñak solo ra, ɗon sarganaꞌ iña lukki lah solo Kootaa⁠ ⁠: ti júɓ, naaꞌ-keeñ a pesaꞌ unni Koo ra nen. Añcaŋ ƴaa daa iña waɗti pagun koon ra, ƴee tas ɗa ɓanti halu. ");
INSERT INTO ndv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ɗon fi njíittí ƴee búumíɗ ƴee ra, ɗon ay hédís hanon kaaꞌ hon cëef kë lukki ƴin ɗa, ɗon anti hon yii teempe ti géléem nen. ");
INSERT INTO ndv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«⁠ ⁠Mas ɗon fi yëeddëh yí Kootaa a ɗon fi fariseŋŋa, ɗon fa wonnon teem ɓúkkën ɗë⁠ ⁠! Ëlí ɗee madu ron ra⁠ ⁠: ɗon hom hosuu fëel fí guluŋŋa a loonna ɗon hel filiɓ. Ɗon hosuu faannon ɗon hel keeññon⁠ ⁠: ɗon caakute nuf lohaa te ɗon ɓosute nuf. ");
INSERT INTO ndv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɗon fi fariseŋŋa búumú ƴee ra, ɗéɓíi hos filiɓ fi guluŋŋon a loonnon níi lan paaƴ, fëel fí wë ay lan filoon fe. ");
INSERT INTO ndv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«⁠ ⁠Mas ɗon fi yëeddëh yí Kootaa a ɗon fi fariseŋŋa, ɗon fa wonnon teem ɓúkkën ɗë⁠ ⁠! Ɗon madu a luuyyi bulaasuu naaꞌ, neɓpe yeel ëssë níi neɓ, ɗeefa ɓúudé yí yahte daa filiɓ. ");
INSERT INTO ndv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ti ɗaaha nen, ɗon madu ɓëewí júɓúté nen íllí ɓëewë, ndaa iña na wonu ron ra teem ɓúkkën te ɗon na ñéyíh woni Koope. ");
INSERT INTO ndv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«⁠ ⁠Mas ɗon fi yëeddëh yí Kootaa a ɗon fi fariseŋŋa, ɗon fa wonnon teem ɓúkkën ɗë⁠ ⁠! Ɗon taɓahuu luuyyi yonente ya níi wun, ɗon yugus ƴi ɓëewë júɓú rë níi et, ");
INSERT INTO ndv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ɗon anti won tih⁠ ⁠: “Fun ɗeefaꞌ jamanii caacca koon, fun ii ñéerëꞌ a wa bëemí yonente ya.” ");
INSERT INTO ndv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yee wonu ron baa ra, daa teeɓaꞌ biti ɗon daa séttí ɓëewë bëemú yonente ya ra. ");
INSERT INTO ndv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kon lúsɗí yee dalu caaccon ɗa⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Goŋŋi ƴeh⁠ ⁠! Tisoh yi hiliññi ƴeh⁠ ⁠! Ɗon ay mínée múc safara ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ëlí⁠ ⁠! May wol i yonente, i ɓaha a i yëeddëh yí Kootaa⁠ ⁠: ɗon ay bëem ƴee ɗon daaƴ wa kurwah, ɗon laɓisaꞌ ƴee laraw filiɓ ílíƴƴë na ɗaguu ron Koope ra, ɗon ñee talli wa ɗon daɓaate wa ginoo gin. ");
INSERT INTO ndv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Daa tah yee bëemúu ɓëewë júɓú rë ay keen sun fon, dalaꞌte bëemí Abeel fa júɓ ɗë níi bëemí Sakari fi Baraki, bee bëemú ron baylii Faam fi gaani Koope, hanndal ki tígí selaa a tígë na hawruu ra. ");
INSERT INTO ndv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mee ron won kaaf ka ra ee⁠ ⁠: iñƴaa ɓéeɓ ay keene sun fi ɓëy jamanii beh. ");
INSERT INTO ndv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«⁠ ⁠Ɗon fi ɓëy Yerusalem daal, ɗon fa na bëemú yonente ya ra, ɗon fa na tawu ɓëewë Koope wol wa ɗon na laꞌ níi wa húl rë, hente waal ɗíh ma na fahaꞌ négírëꞌí ron hëbís sëꞌ ti di na négírëꞌ paan ƴiilli paɓɓi nen⁠ ⁠? Ndaa ɗon fahuuy⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kon Koope yeɗɗaꞌte ron ginon. ");
INSERT INTO ndv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mee ron won ra ee⁠ ⁠: dalaꞌte woteh, ɗon ii soo olil níi bín wonuun ron bitih⁠ ⁠: “Koo-Yíkëe barkela ɓëeꞌ ɗi wol ri ra⁠ ⁠!”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yéesú kolaꞌ dah, ɗúhté Faam fi gaani Koope na saañ. Tígí daaha, taalibe yi leɓuute na wonu ri yii leŋke ɗee taɓahuu Faam fa ra kaar. ");
INSERT INTO ndv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ɗi won wa tígí daa tih⁠ ⁠: «⁠ ⁠Síkíríi sëꞌ⁠ ⁠! Mee ron won kaaf ka ra ee⁠ ⁠: di man ɗi ɗee ɓéeɓ, bis ay lah ɗi ay bëp ɓéeɓ níi laꞌ ii tíkëh sun laꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tílúu wë níi wa lahute daŋi Ëlíiffë rë, Yéesú tookke a afi, taalibe yi leɓuute ri, meelute ri wonu tih⁠ ⁠: «⁠ ⁠Won fun wahtaa nay lahe yii baa ra, a yee nay teeɓee nimilu a túkkíi ëldúnë rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mëytíi⁠ ⁠! Ow ɓanay ron nofaꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ow caak ay ayaꞌ tii soꞌ, won biti daa wa Buura Koo fal ri ra, te wa ay nofaꞌ ow caak. ");
INSERT INTO ndv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɗon ay keloh yodaɗ haaꞌ yi leɓohte a ban fi haaꞌ yi lahaꞌ ginni wulohte. Síkíríi sëꞌ⁠ ⁠! Lah ngënë tíití, iñƴaa waɗti laha laho, ndaa ɗeefa túkkíi ëldúnë laheh doom. ");
INSERT INTO ndv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gin ay yejoh gin haaꞌ, nguur haaꞌ a nguur⁠ ⁠; yaaɓ ay haal i ílíƴ feey fa, lah ílíƴƴí feey fa ay naa hégíƴëh. ");
INSERT INTO ndv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ƴaa ɓéeɓ ay madee a misiga na kat ɓeleɓ biti lowa ham ra nen. ");
INSERT INTO ndv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«⁠ ⁠Tígí daaha, ɗon ay yaayu, ɗon moklu te ɗon ay hawu húl. Af soꞌ ay tah heetta feey fa ɓéeɓ kaaꞌ ron. ");
INSERT INTO ndv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bín fë, ow caak ay yeris ngémí wë, wa yaayantaꞌ, wa kaaꞌantaꞌ filiɓ fi wa. ");
INSERT INTO ndv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yonente paɗɗah caak ɓal ay koloh nofaꞌ ow caak. ");
INSERT INTO ndv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kaaꞌaꞌi ɓëewë ñee woni Koope ay ɓaatee ɓaatoo níi fahantaꞌ ëylëh ow caak na. ");
INSERT INTO ndv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ndaa ɓëyí ham híin níi ɗúmëenë rëe, ay múc. ");
INSERT INTO ndv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Te Uni Nebi Nguur ki sun-Koo ay waariyu ëldúnë ɓéeɓ níi heetta feey fa ɓéeɓ mit na, ëldúnë anti túkkí. ");
INSERT INTO ndv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","«⁠ ⁠Kon tíl níi ɗon ot yii ɓosa na sobeyil ra hom filiɓ tígí selaa, bee na húmú wonaꞌ yonente Dañeel ra raa, tígí daaha, ɓëewë nay home Yúdée rë heguun daŋŋin (ɓëyí jaŋi yii bee yúhën⁠ ⁠!) ");
INSERT INTO ndv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɓëyí ɗúh këem, ɓanan haal kali yin faam⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","te ɓëyí liilti saañ meey, ɓanan nimil kali búuɓ faam. ");
INSERT INTO ndv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mas ɓeleɓɓa nay poke loo bín fë a ƴee nay ɓëpíré rë⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ɗëgí Koope hegohi ron ɓanti teeꞌaꞌ a líƴ, mbée bisa na hílsúu rë. ");
INSERT INTO ndv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mee ron won kaaf ka ra ee biti jamanii baaha ay misik misigi lëhírëy sakaꞌ Koo ëldúnë níi a ɗeh, te mani ii lëhíɗ faw. ");
INSERT INTO ndv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te Koo cagay ëylí bissi ƴaaha koon, tin ow ii múc bín fë⁠ ⁠; ndaa ɓëewë ɗi tanis wa ra daa tah ɗi ëyíl wë. ");
INSERT INTO ndv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«⁠ ⁠Ɓëyí won ɗon tígí daaha biti “Buura Koo fal ri ra abeh”, mbée “ɗi abín” ɓéeɓ, ngënë gémí rí. ");
INSERT INTO ndv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","I kiristaa a i yonente paɗɗah ay ac paŋ i kimtaan a iñi éemílëꞌté, fahaꞌi biti koon wa nofaꞌ sah ɓëewë Koo tanis wa ra. ");
INSERT INTO ndv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mi wonte ron ri abah⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ɓëyí won ɗon biti Buura Koo fal ri ra ín luufin, ngënë pëyí⁠ ⁠! Ɓëyí won ɗon biti ɗi hom tígí ɗapohte, ngënë gémí⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Di na hélƴëꞌ Koo hawaan feey fa ɓéeɓ, ayi soꞌ mi Koy-ɓëeꞌ ay made ɗaaha nen. ");
INSERT INTO ndv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tígí etaꞌ médë, suulla teeꞌuu na. ");
INSERT INTO ndv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«⁠ ⁠Jamanii misigi baa gété rek, naꞌa a céyín fë ƴímé, hulla hélkísëh keen, doole ya sun ɓéeɓ bëlkísëh. ");
INSERT INTO ndv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«⁠ ⁠Tígí daaha, ay lah yii ay feeñ sun-Koo teeɓaꞌi biti wahtii ayi soꞌ lahte, te ɓëewë feey fa ɓéeɓ ay líh yaꞌ yi wa affi wa, wa ole soꞌ mi Koy-ɓëeꞌ mi aye filiɓ nérrë, mi ñéerëꞌ a doole a ndam gaan. ");
INSERT INTO ndv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Un kúlúɓ ay tiil, mi wol malaaka yi soꞌ wër feey fa ɓéeɓ, négírëꞌí ɓëewë tansu ra, dalaani feey fa níi lúsëenín.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Hëbí yee tíinndúu tal karaɗ ra affon⁠ ⁠: ɗon ot tal karaɗ capuse rek, ɗon yúh biti lee ri lah koy. ");
INSERT INTO ndv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ti ɗaaha nen, ɗon ot iñƴaaha ɓéeɓ lahe raa, lah yúhí biti nimili soꞌ mi Koy-ɓëeꞌ leɓohte níi leɓoh. ");
INSERT INTO ndv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mee ron won kaaf ka ra ee biti ɓëy jamanii bee ii múk te iñƴaaha ɓéeɓ laheh. ");
INSERT INTO ndv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Sun a feey ay múk, ndaa unni soꞌ ii mëssí múk. ");
INSERT INTO ndv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«⁠ ⁠Yii leŋke bisa a wahtaa nay mii nimile ra, ow yéeh yin na⁠ ⁠: malaaka ya sun neh, soꞌ mi Koy ka sah, mi yéeh yin na⁠ ⁠; Boffa kut daa yúh. ");
INSERT INTO ndv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Jamanii nimili soꞌ mi Koy-ɓëeꞌ ay madee a yee húmú lah jamanii Nowe ra nen⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","balaa mulii mbënë më cép bín fë, ɓëewë húmú feey fa na ñamu na hanu, ƴee na koorantuu níi yiin haal Nowe gaala ra. ");
INSERT INTO ndv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wa séentúuy rí níi yiin ac mbënë më kúɗté wë ɓéeɓ rë. Jamanii nimili soꞌ mi Koy-ɓëeꞌ ay made ɗaaha nen⁠ ⁠; daa mi won ron ri. ");
INSERT INTO ndv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yiin fin fa, ow ana ay hom meey⁠ ⁠: ow yínë waa na ay kúrú, ɓëyí yínëe helu. ");
INSERT INTO ndv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ɓeleɓ ana ɓal ay hom hoɗ⁠ ⁠: ow yínë waa na ay kúrú, ɓëyí yínëe helu. ");
INSERT INTO ndv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«⁠ ⁠Kon këlíi affon⁠ ⁠! Ɗon yíih bisa nay nimile Yíkíi ron ra. ");
INSERT INTO ndv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ɗon yúhúté biti yíkëe faam yúh wahtaa nay aye lohoha faami ra koon, tin ɗi ii neeꞌ pëní kaaꞌ ri poo faam fa. ");
INSERT INTO ndv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kon këlíi affon ɗon ɓal, ndée soꞌ mi Koy-ɓëeꞌ, may nimile wahtii nuffon paay na. ");
INSERT INTO ndv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«⁠ ⁠Mëdíi a súrgíi ñeyaꞌ woni kélfíi te ñaañce, bi kélfíi tík súrgë yí kayya ɓéeɓ yaꞌi yeri wa ñam, biti wahtaa lah ra. ");
INSERT INTO ndv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Lahte sos-keeñ, súrgíi baa yéŋké biti yiin nay nimile kélfíi faam fa ra, ɗeefa ri page yee nahu ri ra. ");
INSERT INTO ndv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mee ron won kaaf ka ra ee, kélfíi ay tík iña lahaꞌ ri ra ɓéeɓ yaꞌi. ");
INSERT INTO ndv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ndaa ri hena súrgíi wuneh koon, ɗi won tih⁠ ⁠: “Kélfíi sëꞌ aay doom” ");
INSERT INTO ndv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","níi tah ɗi yam sun fi súrgë yí kayya hawsee wa, ɗi ñame ñami neɓpe, ñéerée a mëníyíɗɗë hane raa, ");
INSERT INTO ndv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kélfíi ay nimil wahtii ɗi yéeh rí te ɗeefa ri seheh ri. ");
INSERT INTO ndv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tígí daaha, kélfíi ay rii bëkdëꞌ ɓëewë wonni wa teem ɓúkkí wë rë, mokil ri mokli misikke. Tígí daaha ɗi ay looy, ŋafoh níi tíñë lec.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Nguur ki sun-Koo ay made biti kúkëy cafaƴ sabboo këríɗ lampa yi wa, sayu téebílëh yíkëe kílëek nen. ");
INSERT INTO ndv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lahte iippi ñaañuy, iippa tas ɗa ñaañute. ");
INSERT INTO ndv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Iippa ñaañuy ra, ɓeyuu wa lampa yi wa ra, nuffi wa paay kúrëelëh pitirol daaƴ, ");
INSERT INTO ndv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ndaa iippi kayya ɓeyuu wa lampa yi wa ra, kúrëelúuté i bútéel pitirol. ");
INSERT INTO ndv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wa homu sehi yíkíi kílëegë níi wa ɓéeɓ pëníyúté, míllúutée neeꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hom homo níi un ɗofohte leelii elga won tih⁠ ⁠: “Yíkíi kílëegë acce⁠ ⁠! Tílí ɗon téebílée rí⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wa fi sabboo ya ɓéeɓ koluute, na waaƴu lampa yi wa. ");
INSERT INTO ndv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tígí daaha, ƴee ñaañuy ra wonu iippi kayya tih⁠ ⁠: “Ëní fun na pitiroli ron, lampa yi fun ee saañ ƴímé rë⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ƴee ñaañu ra wonu wa tih⁠ ⁠: “Baa mínéh hen⁠ ⁠! Ƴee lahuu fun ra mínéh yen kúɗ ɓéeɓ. Pëyí ɗon lome⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wa koluu daaha sayute lom. Wahtaa sayuu wa ra, yíkíi kílëegë lahaꞌ na. Iippa wocu ra ñéerúuté a yíkíi kílëegë haalute faam fa, ílë wodute. ");
INSERT INTO ndv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hompe níi, ƴee payu lom pitirol ra namutee ac, wa ɓéyrúté unni wa na wonu tih⁠ ⁠: “Ɓahaa, kúnsíɗ fun⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ɗi won wa tih⁠ ⁠: “Wëerté sëꞌ biti mi yéeh rën⁠ ⁠!”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Daa tah mi won ɗon tee⁠ ⁠: tëekí ɗon yeele, ndée ɗon yíih bisa a wahtaa nay mi nimile ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Nguur ki sun-Koo mín mëllúu a biti ow koloh saañ ɓaaɓ, dëek súrgë yí, déŋéen wë alal mi nen. ");
INSERT INTO ndv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɗi yeɗte ow yínë waa na hanjar úrís iip, ɓëyí ana fa ɗi yeɗte ri hanjar ana, ɗi yeɗte ɓëyí éeyë fë hanjar yínë bi yúh rí ow fi ow waa na ɓéeɓ. Ɗi antee koloh saañce. ");
INSERT INTO ndv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ɓëeꞌ yeru hanjarri iippa ra yíppée yam légéyë, úrísë na ɓaatoh níi wa límpé hanjar iip kay. ");
INSERT INTO ndv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bee yeru hanjar ana ra hente ɗaaha ɓal níi hanjara límpé ana kay. ");
INSERT INTO ndv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bee yeru hanjar yínë rë nék nampee pay hacce nuŋ, ɓekke hanjari kélfíi filiɓ, púuɓpé. ");
INSERT INTO ndv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«⁠ ⁠Hompe níi filoon fe, kélfíi súrgë yë acce dëekké wë, wa léhín ɗí légéyí wë. ");
INSERT INTO ndv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ɓëeꞌ húmú yeru hanjar úrís iip ra, kúrëelëhté hanjar iippi kayya lah ri sun fi ƴín ɗë, won tih⁠ ⁠: “Ɓahaa, fu húmú yeɗ soꞌ hanjar úrís iip neh a⁠ ⁠? Mi légéyté níi mi lahte iip sun aƴeh⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kélfëe won ɗi tih⁠ ⁠: “Eera⁠ ⁠! Fu súrgíi wunte⁠ ⁠! Ow mín ɗëe lekoh. Hém daa fu ñee woni soꞌ fu paŋke yii ƴutuudi baa raa, may roo déŋéen yii luk baa maanaa. Aye yen bok ndama.” ");
INSERT INTO ndv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bee húmú yeru hanjar úrís ana ra acce ɓal won tih⁠ ⁠: “Ɓahaa, fu húmú déŋéen sëꞌ hanjar úrís ana neh a⁠ ⁠? Mi légéyté níi mi lahte ana kay sun aƴeh⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kélfëe won ɗi tih⁠ ⁠: “Eera⁠ ⁠! Fu súrgíi wunte⁠ ⁠! Ow mín ɗëe lekoh. Hém daa fu ñee woni soꞌ fu paŋke yii ƴutuudi baa raa, may roo déŋéen yii luk baa lah maanaa. Aye yen bok ndama⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Míllëenë, bee húmú yeru hanjar úrís yínë rë nampee ac won tih⁠ ⁠: “Ɓahaa, mi yúhté biti fu ɓëyí súhté keeñ⁠ ⁠: fu lecaꞌ yii fu sohay ri, fu ɓeenaꞌ tígí fu ɓekay na tisoh, ");
INSERT INTO ndv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","daa tah mi kaañay ro, mi hacce nuŋ mi ɓekke hélsú feey. Ɓeye hélsú aƴeh⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kélfëe won ɗi tígí daaha tih⁠ ⁠: “Fu súrgíi ɓosse⁠ ⁠! Fu ɗëpësíɗ⁠ ⁠! Fu won neh mi lecaꞌ yii mi sohay ri, mi ɓeenaꞌ tígí mi ɓekay na tisoh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kon haalaꞌ yi níi fu wëtɗëey hélsí sëꞌ⁠ ⁠? Tin bee nimilaꞌ mi bee ra mi laheh na yii tíkëh sun a⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ɗi yíssëhté súrgë yí kayya na, won wa tih⁠ ⁠: “Nëefí bee ɗii na, ɗon yeɗ ɗi ɓëeꞌ lahaꞌ sabboo ra.” ");
INSERT INTO ndv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ahaŋkay⁠ ⁠! Ɓëyí ham yee yeru ri ra a yaꞌ ana, ay ɓaatu níi keeña sos. Ɓëyí pagay yii baaha raa nék, yii ƴutuuda lahaꞌ ri ra sah ay naafu. ");
INSERT INTO ndv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ɗi fi bee lahay njiriñ bee ra, bétí rí ñúusë ëssín, ɗi looye dín fë ŋafee níi tíñë lec.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Yiin nay mii nimile soꞌ mi Koy-ɓëeꞌ mi ayee a ndami soꞌ, mi ñéerëꞌ a malaaka ya ɓéeɓ rë, may tooke ñaani Nguur ki gaani soꞌ na. ");
INSERT INTO ndv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tígí daaha, heetti ɓëewë feey fa ɓéeɓ ay teyaꞌ fíi sëꞌ, mi ɓísëꞌ wë goomal ana ti di na ɓísëꞌ níirëh harri a peꞌ yi. ");
INSERT INTO ndv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ti ɗaaha nen, may tík ɓëewë júɓú rë yaꞌi ñamaa fi soꞌ, mi tík ƴee júɓúy rë yaꞌi sugu fi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bín fë rëe, soꞌ mi buura may wone ɓëewë paaꞌuu soꞌ yaꞌ ñamaa ra tih⁠ ⁠: “Ëyí ɗon fa Baasoꞌ barkel ron ra. Hëelí Nguur ka waaƴiɗ ɗi ron dalaani ëldúnë rë, ");
INSERT INTO ndv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ndah húmú yaaɓaꞌ mi níi yaaɓ ra, ɗon onute soꞌ ñam⁠ ⁠; mi húmú sifirohte, ɗon onute soꞌ muluɓ⁠ ⁠; mi húmú doha-ndéem, ɗon tahuute soꞌ a yaꞌ ana⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mi húmú lahay búuɓ, ɗon ɓekute soꞌ⁠ ⁠; mi húmú jéríɗ, ɗon caguute soꞌ⁠ ⁠; mi húmú téƴúté kasu, ɗon yérúté sëꞌ.” ");
INSERT INTO ndv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tígí daaha ɓëewë júɓú rë ay soo meel won soꞌ tih⁠ ⁠: “Yíkëe, fun olu ro fu yaaɓpe kiri, fun yerute ro ñam⁠ ⁠? Fu sifiroh kirih, fun onute ro muluɓ⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Fu hen doha-ndéem kirih, fun tahuute ro a yaꞌ ana, mbée fu lahay búuɓ, fun ɓekute ro⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Fu jér kirih, fu téƴúté kirih, fun yérúté rë⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Soꞌ mi buura may waa lofe tígí daaha tih⁠ ⁠: “Mee ron won kaaf ka ra ee⁠ ⁠: wahtii húmú pagiruun ron ri ow di koy-yaayyi soꞌ ɓéeɓ, wuti ƴaha bee lukki hen yeru raa sah, ɗeef ɗon pagiru soꞌ mi bee ri.” ");
INSERT INTO ndv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«⁠ ⁠Mi kolaꞌ daa raa, mi yíssëh ɓëewë paaꞌuu soꞌ yaꞌ sugu ra, mi won wa tih⁠ ⁠: “Wúlíi sëꞌ ɗon fa Koo alak ron ra, ɗon haale filiɓ kíi kë ii mëssí ƴím rë waaƴɗu Seytaane a dakki ra, ");
INSERT INTO ndv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ndah húmú yaaɓaꞌ mi níi yaaɓ ra, ɗon onuy soꞌ ñiip ñam sah⁠ ⁠; mi húmú sifirohte, ɗon onuy soꞌ siit muluɓ sah⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mi húmú doha-ndéem, ɗon yeeluy soꞌ sah⁠ ⁠; mi húmú lahay búuɓ, ɗon ɓekuy soꞌ⁠ ⁠; mi húmú jérté, mi téƴúté kasu, ɗon yérúy sëꞌ.” ");
INSERT INTO ndv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tígí daaha, wa ay soo nampi meel won soꞌ tih⁠ ⁠: “Yíkëe, fun olu ro fu yaaɓpe, fu sifirohte kirih⁠ ⁠? Fun olu ro fu hente doha-ndéem kirih, fu lahay búuɓ kirih, fu jérté mbée fu téƴúté kasu kirih, fun hílípúy rë⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","May waa lofe tígí daaha tih⁠ ⁠: “Mee ron won kaaf ka ra ee⁠ ⁠: wahtii húmú kaaꞌruun ron pagiɗ ow di koy-yaayyi soꞌ iñƴaa ɓéeɓ, wuti ƴaha bee lukki hen yeru raa sah, ɗeef ɗon kaaꞌru soꞌ mi bee ri.” ");
INSERT INTO ndv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«⁠ ⁠Te ɓëewí ƴaa suu pesee daana na ɗúméh rë. Ndaa ɓëewë júɓú rë suu haale pesa na ɗúméh rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wocaꞌ Yéesú woni ɓëewë iñƴaa ɓéeɓ rë, ɗi won taalibe yi tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«⁠ ⁠Ɗon yúhúté biti tas waal ana feedi Paaga lah maan⁠ ⁠? Daa ri wahtaa nay yaayuu soꞌ mi Koy-ɓëeꞌ, mi daaƴu sun kurwah ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wahtii baaha, kélfë yí seeƴoh ya a ɓaha ya gina teeꞌuute faam Kayif, seeƴohi gaana⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","wa ɓéeɓ habute biti wa ay ɓon níi wa ham Yéesú hap ɗi húl. ");
INSERT INTO ndv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Di filiɓ ƴaaha ɓéeɓ, wa wonantuute biti ɓanay hen filiɓ feeda, toñeh ɓëy gina ay kolee sun fi wa. ");
INSERT INTO ndv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yéesú kolaꞌ dah saañce Betani, haalte faam Simoŋ fa mëssée guuñ ɗa, ");
INSERT INTO ndv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","tookke na ñam. Lahte ɓelii leɓohte ri, hampe bútlí yotuu laꞌa na wonuu albataar ra, bi líiffé a laakkoloñi kofeelte, yíinté rí wë af. ");
INSERT INTO ndv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Oluu taalibe ya yii bah, yaa neɓaay wa, wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Yahi bee lahaꞌ njiriñ mi bih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Laakkoloñi ƴee yaayeeh hélíis caak koon cadum fa yeru ñëkíɗɗë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bi yúh Yéesú yee na wonu wa ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon moklu ɓelii bee yi ɗeeha⁠ ⁠? Yee pagiɗ soꞌ ri bee ra, yii wunte⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ñëkíɗ ii koloh filiɓ fon⁠ ⁠; ndaa soꞌ mi bee mii hom filiɓ fon dee faraah. ");
INSERT INTO ndv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ɗon ot ɓelii bee túm sëꞌ laakkoloñ, ɗi waaƴiɗ hacadi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mee ron won kaaf ka ra ee⁠ ⁠: tígí waariyuun Uni Neba ëldúnë ɓéeɓ, yee paŋ ɓelii bee ra ay naa ɓíllú, nuffi ɓëewë pay ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Filoon fi baaha, Yudaas Iskariyot, ow di taalibe yi sabboo a ana ya payte kélfë yí seeƴoh ya na, ");
INSERT INTO ndv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","meelte wa yee nay wa rii yere biti ɗi yaay wa Yéesú rë. Wa yerute ri hanjar hélíis sabay éeyë (30). ");
INSERT INTO ndv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kolaꞌte baaha, Yudaas na anti saam wahtaa nay rii ɗamaalee Yéesú níi ri yaay ri wa ra. ");
INSERT INTO ndv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bisa ɗéɓ bissi feedi mbúurú njeñe ya ra, taalibe ya ayute meelute Yéesú wonu ri tih⁠ ⁠: «⁠ ⁠Fu fahaꞌ biti fun waaƴɗun ɗo reeri Paaga tígí dih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Pëyí faam díw filiɓ ginin, ɗon won ɗi tih⁠ ⁠: “Yëeddëhë daa nah fun won ɗo biti wahtii lahte. Ɗi ay ñamee reeri Paaga faamu, ɓani taalibe yi.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Taalibe ya koluu daaha suute, pagute yee nah wa Yéesú rë, wa waaƴute reeri Paaga. ");
INSERT INTO ndv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Fíníin fín, Yéesú a taalibe yi sabboo a ana ya goorute na reeru. ");
INSERT INTO ndv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wa homu reera, ɗi won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ow di ɗon na ay soo yaay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Keeññi taalibe ya ɗúmpé, wa na meelu Yéesú yínë-yínë wonu ri tih⁠ ⁠: «⁠ ⁠Mbaa ri soꞌ neh Yíkëe⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ nay soo yaaye ra ee ɓek yaꞌi loon a soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kaah biti soꞌ mi Koy-ɓëeꞌ mi waɗtee húl ti di bíníyúu rí sun fi soꞌ Téerëe nen⁠ ⁠; ndaa mas ɓëeꞌ nay soo yaaye ra⁠ ⁠! Biti ri límíh koon daa gén ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ɗi fi Yudaas fa nay rii yaaye ra nampee won tih⁠ ⁠: «⁠ ⁠Mbaa ri soꞌ neh Ɓahaa⁠ ⁠?⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu wonte ri, ɗi ɗo fi bah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wa homu ñama, Yéesú ɓeɓpe mbúurú, símpé Koope, lecsaꞌte ri, yeɗte taalibe yi won wa tih⁠ ⁠: «⁠ ⁠Ɓéyí ɗon ñam, mbúuríi bee faan soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Filoon fi baaha, ɗi ɓeɓpe kaas béeñ, símpé Koope, yeɗte wa won tih⁠ ⁠: «⁠ ⁠Ɓéyí ɗon han ɗon ɓéeɓ, ");
INSERT INTO ndv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","béeñí ƴee ñif mi soꞌ, ñif ma pokalsaꞌ Koope a ɓëewë rë. Wa ay keen ndah ow caak. Ɗaaha, wa baalu bakaaɗɗi wa. ");
INSERT INTO ndv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mee ron won kaaf ka ra ee⁠ ⁠: dalaꞌte woteh, mii hanil béeñ níi yiin nay mii hane béeñ has a ɗon Nguur ki Baasoꞌ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Filoon fi baaha, Yéesú a taalibe yi haalute ƴeekaa yi kañaa ya. Wocuu wa ra, wa koluute na suu daŋi Ëlíiffë. ");
INSERT INTO ndv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yéesú won taalibe yi tígí daaha tih⁠ ⁠: «⁠ ⁠Elgee woteh beh, ɗon ɓéeɓ ɗon ay sélít ndah yee nay soo kate ra ti di bíníyúu rí Téerëe bitih⁠ ⁠: “May hap níirëhë húl, te harra yuba ay haslaꞌ.” ");
INSERT INTO ndv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Di wonaꞌ ri Téerëe daaha kaah. Te filoon fi hawi soꞌ húl, may këllú ɓúudé, mi këllëh rën Galile.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peer won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Wuti ɓëewí kayya ɓéeɓ sélít af yee nay roo kate raa, mii naa mëssí non.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yéesú tahte won tih⁠ ⁠: «⁠ ⁠Mee roo won kaaf ka ra ee Peer⁠ ⁠: elgee woteh beh, fiisiin ki paan, fay taasaꞌ biti fu yúh sëꞌ níi hen waal éeyë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peer tíkké won tih⁠ ⁠: «⁠ ⁠Calalte soꞌ biti mi hawu húl a ɗo, ndaa mii mëssí taasaꞌ biti mi yúh rë.⁠ ⁠» Wa fi taalibe yi kayya ɓéeɓ ɓal ñeyute una, na wonu yaa yínë. ");
INSERT INTO ndv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tílúu Yéesú a taalibe yi níi wa lahute tígë në wonuu Setsemani ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Hëmí deh, mi pay ɗaŋ Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na saañ ɗi ra, ɗi kúrëelëhté Peer a koyyi Sebede, Saak a Saŋ. Súfúñ daɓpe ri, keeña ɗúmpé ces. ");
INSERT INTO ndv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Keeñ soꞌ ɗúm ɗúmë níi mí mínléh⁠ ⁠; hëmí soo na deh, te ɗon yeele⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ɗi antee hécëh ƴutuuɗ, yeɗɗohte, líhëhté feey, na ɗaŋ won tih⁠ ⁠: «⁠ ⁠Baap, mín hen koon fu éccíɗ gulii coono fi bee wuloh soꞌ⁠ ⁠! Ndaa di mín ɗíi man ɓéeɓ, yee nay lahe ra ɓanan hen yee fahaꞌ mi ra, ndaa bee fahaꞌ fu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kolaꞌ ri dah, ɗi nimilte taalibe yi éeyë yë në, ɗeeffe wa na neeꞌu. Ɗi won Peer tih⁠ ⁠: «⁠ ⁠Ɗon míníh yeel wuti ƴaha wahtu yínë kut a soꞌ a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yéelí ɗon ɗaŋ, toñeh ɗon ay keene fíirí Seytaane. Ow na fahaꞌ paŋ yin wun ndaa ri mitay⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ɗi hécíilté, yampe na ɗaŋ won tih⁠ ⁠: «⁠ ⁠Baap, hena biti yin mínéh kaaꞌ mi han gulii coono fi bee raa, yee fahaꞌ fu ra lahan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ɗi nimilaatte taalibe yi na, ɗeefaatte wa na neeꞌu, bi luk wa pëní fë doole. ");
INSERT INTO ndv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tígí daaha, ɗi yerisse wa daaha hécíilté na ɗaŋ, ñeyaatte unna ɗéɓ ɗë. ");
INSERT INTO ndv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nimilaataꞌ ri taalibe ya na waali yíníi bee ra, ɗi ɗeefaat wa na neeꞌlu, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon daa na neeꞌlu ɗee ɗon na hílsúu ë⁠ ⁠? Síkíríi⁠ ⁠! Wahtaa nay yaayuu soꞌ mi Koy-ɓëeꞌ, mi tíkú yaꞌ yi bakaaroh ya ra lahte. ");
INSERT INTO ndv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Këlíi yen saañ⁠ ⁠! Ëlsíi, ɓëeꞌ yaay soꞌ ra ee ac ɗa ee.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yéesú hom wona, Yudaas, ow di taalibe yi sabboo a ana ya na ac, ñéerëꞌté a dúukël ow, ƴi kúrú jépíl a duuɗ. Kélfë yí seeƴoh ya a ɓaha ya gina daa wolu wa. ");
INSERT INTO ndv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ɗeef Yudaas fa nay rii yaaye ra, teeɓpe wa yee nay rii page ra níi wa yúhsëꞌ rí rë. Ɗi húmú won wa tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ nay mii fëené rë, ɗi baaha⁠ ⁠; lah hëbí rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Lahaꞌ ri ra, ɗi júɓ sun fi Yéesú ciɗ won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, yerne⁠ ⁠!⁠ ⁠» Ɗi fëenté rí. ");
INSERT INTO ndv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Kooja, yee ac fu ra page ri⁠ ⁠!⁠ ⁠» Ɓëewë leɓuu Yéesú tígí daaha, yejuute sun fi, habute ri. ");
INSERT INTO ndv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ow di taalibe yi Yéesú fúulté jépílí wahtii baaha, paaŋke ri súrgíi seeƴohi gaana, lecce nufa. ");
INSERT INTO ndv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Nimilire jépílú mbari⁠ ⁠! Yúhé biti ɓëyí na haaꞌ a jépíl ɓéeɓ ay húlée jépíl. ");
INSERT INTO ndv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nufu onay ro biti mi mín dëek Baasoꞌ, ɗi wolaꞌ soꞌ dúukël malaaka sabboo a dúukël ana ɗee leegi wa ac sëmlëꞌí sëꞌ ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ndaa mi paŋ ɗi raa, yee bíníyú Téerëe rë ay lahee ɗíh, te bíníyúté biti iñƴaa waɗti lahaa ɗaaha⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yéesú antee won dúukëlí ɓëewë tih⁠ ⁠: «⁠ ⁠Ɗon ayuu yi ɗeeha a jépíl a i duuɗ hami soꞌ man mi banndi nen⁠ ⁠? Mi húmú homaꞌ filiɓ fon faraah mi yëeddée Faam fi gaani Koope te ɗon habuy soꞌ⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ndaa iñƴee ɓéeɓ waɗti lahaa ɗeeha, nda yee húmú bíníyú yonente ya ra lah.⁠ ⁠» Tígí daaha, taalibe yi ɓéeɓ heguute, helute ri. ");
INSERT INTO ndv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɓëewë habu Yéesú rë kúrúté rí faam Kayif, seeƴohi gaana, tígë teeꞌuu yëeddëh yí kootii Mëyíis a ɓaha ya gina ra. ");
INSERT INTO ndv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peer hompe filoon wulohte, ñeete tal Yéesú níi rí lahte faam seeƴohi gaana, ɗi haalte baylaa tookke a wohoh ya, na olsoh ɗee nay míllée yaa ra. ");
INSERT INTO ndv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kélfë yí seeƴoh ya a ɓëy këemí gaani yëwúɗɗë ɓéeɓ saamute yii míntí yabun Yéesú níi tah ɗi hawu húl. ");
INSERT INTO ndv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ɗee teyu ɓëewë yabu ri ra, caakuu wa níi caak, tahay wa ot yii mín tah ɗi hawu húl. Míllëenë, ow ana ayute ");
INSERT INTO ndv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí bee daa won biti ɗi mín poo Faam fi gaani Koope, ɗi taɓahaat ɗi filiɓ waal éeyë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Seeƴohi gaana kolohte tígí daaha, meelte Yéesú won tih⁠ ⁠: «⁠ ⁠Fu lahay yii lofa fu di yee yabu ro ɓëewí ƴee ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yéesú hente tiɗ héddëhté. Seeƴohi gaana tahaatte won ɗi tih⁠ ⁠: «⁠ ⁠Añee ri, fu won di tii Koope fa na pes ɗa, hém daa fu Buura Koo fal ri ra, Koy Koope raa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu wonte ri. Cëe mí ɓaat ɗon sun⁠ ⁠: kolaꞌte woteh, ɗon ay ot soꞌ mi Koy-ɓëeꞌ, mi took hëbís Koope fa mín ɓéeɓ rë, mi hom yaꞌi ñamaa fi, te ɗon ay ot mi aye filiɓ nérrë sun.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kelaꞌ seeƴohi gaana unni ƴah, ɗi ɗaɗte búubí won tih⁠ ⁠: «⁠ ⁠Ɗi solte Koope unna won ɗi ƴaa ra⁠ ⁠! Yen ay paglee seede yih⁠ ⁠? Ɗon kellirute affon sola⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɗon wonu yi na⁠ ⁠?⁠ ⁠» Wa wonu tih⁠ ⁠: «⁠ ⁠Ɗi waɗti húlë húlë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wa na anuu rii tuulsaꞌ kanam, na maagu ri kít. Lahte ƴi na fúurú rí mbeƴ, ");
INSERT INTO ndv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","wonu ri tih⁠ ⁠: «⁠ ⁠Hém daa fu Buura Koo fal ri ra raa, teeɓ fun biti fu yonente, fu won ɓëeꞌ laɓ ɗo ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wahtii baaha, ɗeef Peer húmú ëssë, baylaa filiɓ faam fa. Ow di ɓeleɓɓa na légéyú faam seeƴohi gaana ra leɓohte ri won tih⁠ ⁠: «⁠ ⁠Ɗo fi bee ɓal, ɗoni Yéesú fée ké ɓëy Galile bee daa na húmú ñéerúu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ndaa Peer taasaꞌte won fíi ɓëewë ɓéeɓ tih⁠ ⁠: «⁠ ⁠Mi yéeh yee fahaꞌ fu won ɗa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bi na yuloh ri waal ílín, ow kay di ɓeleɓɓa na légéyú faam fa ra otte ri, won ɓëewë húmú daaha ra tih⁠ ⁠: «⁠ ⁠Bee ee yínë bi non ɓëewë në húmú ñéerúu a Yéesú fi ɓëy Nasaret ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peer kaaꞌaatte añohte tíkké sun won tih⁠ ⁠: «⁠ ⁠Mi yéeh ɓëyí bah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tíkëh ƴutuuɗ, ɓëewë húmú hatni baa ra leɓuute Peer, wonu ri tih⁠ ⁠: «⁠ ⁠Lahte íl ɓal⁠ ⁠! Ɗo fu non ɓëewí Yéesú, miteh taasaꞌ⁠ ⁠! Ɓëyí keloh ro fu wone raa kep yúh baaha⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peer hampe yee ham ɗi ra rek, añohte won tih⁠ ⁠: «⁠ ⁠Mi fel raa, yii kat soꞌ ɗi baaha⁠ ⁠! Mi yéeh ɓëyí bah⁠ ⁠!⁠ ⁠» Una na lús, paan na fiisoh. ");
INSERT INTO ndv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tígí daaha, ɗi nérsëhté yee húmú won ɗi Yéesú rë biti fiisiin ki paan, ɗi ay taasaꞌ biti ɗi yúh rí níi hen waal éeyë. Ɗi antee ɗúh ëssín, na looy looyi misikke. ");
INSERT INTO ndv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yíilëꞌ Koo ɓaabin cúɓ, kélfë yí seeƴoh ya ɓéeɓ a ɓaha yi yëwúɗɗë tookute, fahuu hawrohi Yéesú húl. ");
INSERT INTO ndv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wa pokruute ri, komute ri gëernëer Pilaat. ");
INSERT INTO ndv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudaas fa yaay Yéesú rë, olaꞌ ri biti Yéesú aattiyuute húl rë, ɗi réeccíyëhté⁠ ⁠: ɗi payte nimiliri kélfë yí seeƴoh ya a ɓaha ya gina hanjarri sabay éeyë (30), ");
INSERT INTO ndv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","won wa tih⁠ ⁠: «⁠ ⁠Mi bakaaɗte di yee yaayaꞌ mi jaambura pagay yin bee na suu hawu húl rë⁠ ⁠!⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Waal fi fun yi na⁠ ⁠? Baa saf ɗo⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tígí daaha, Yudaas bette hélsë filiɓ Faam fi gaani Koope daaha, saañce pokke níh lúumí, naadohte. ");
INSERT INTO ndv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kélfë yí seeƴoh ya píyúté hélsë, anutee won tih⁠ ⁠: «⁠ ⁠Yen waruy boollaꞌ hélsí ƴeh a alal mi Faam fi gaana⁠ ⁠; wa hélíis ñif.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tígí daaha, wa dëekúuté took, habute biti hélsë lomuu meey yugusohi yaaɗɗa ndín, hen hacaa yi doha-ndéemmë. ");
INSERT INTO ndv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Daa tah níi a woteh, feey fi baa wonuu «⁠ ⁠Meeyi ñif ma⁠ ⁠». ");
INSERT INTO ndv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yee húmú won yonente Yérémí rë lahaꞌte ɗah. Ɗi húmú won tih⁠ ⁠: «⁠ ⁠Wa ɓeyute hanjarri sabay éeyë yë (30), daa wa cadum fa wonantuu ri koyyi Israyel ra, ");
INSERT INTO ndv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","wa lomuute wa meey yugusohi yaaɗɗa, ti di nahaꞌ soꞌ ri Koo-Yíkëe nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Cagaꞌ Yéesú fíi gëernëer Pilaat ra, gëernëerë meelte ri won tih⁠ ⁠: «⁠ ⁠Daa fu buuri yëwúɗɗë ë⁠ ⁠?⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu wonte ri, daa mi⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kélfë yí seeƴoh ya a ɓaha ya gina ayute na yabu ri yin caak filoon fe, ndaa ɗi tahay ɓúkí waa na. ");
INSERT INTO ndv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilaat won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Fu kelaay iña na wonu wa sun fu ɓéeɓ rë keloo a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ndaa Yéesú haagay ɓúkí waa na yínë sah na lof di iña yabu ri ra. Yaa kúnté af gëernëer pak. ");
INSERT INTO ndv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lahaa Paak ɓéeɓ, gëernëer ɗúhíɗ ow kasaa, bee fahuu ɓëy gina biti daa ri yeɗɗun ra. ");
INSERT INTO ndv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ɗeef lahte ɓëyí síiwté húmú kasaa, hínú Barabaas. ");
INSERT INTO ndv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilaat meelte dúukëlí ɓëewë teeꞌuu daaha ra won tih⁠ ⁠: «⁠ ⁠Hanndal ki Barabaas a Yéesú fë në wonuu Kiristaa ra, ɗon fahuu biti mi ɗúhrírë ron wah waa na⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ɗi fi Pilaat yúhté biti nagajek ɓëewë iñaanuu Yéesú iñaanoo daa tah wa kom ri ri. ");
INSERT INTO ndv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Te payaꞌ ri níi tookke këem buur ra, ɓelaa liiltee wolaꞌ ɗii na woni biti ɗi ɓanti haal iñi ɓëyí júɓí bah, ndah ɗi heeƴce heeji téƴcé afa lool sun fi ɓëeꞌ elgin. ");
INSERT INTO ndv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Di filiɓ ƴaaha ɓéeɓ, kélfë yí seeƴoh ya a ɓaha ya gina ɓekute dúukëlí ɓëewë nuf, nda wa won Pilaat biti Barabaas daa yeɗɗun, Yéesú hawu húl. ");
INSERT INTO ndv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilaat meelaatte dúukëlí ɓëewë won tih⁠ ⁠: «⁠ ⁠Ɗon fahuu biti mi yeɗɗan wah wa fi ana ya⁠ ⁠?⁠ ⁠» Wa ɓéyrúté unni wa sun wonu tih⁠ ⁠: «⁠ ⁠Fun fahuu Barabaas⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaat cagohte wa won tih⁠ ⁠: «⁠ ⁠Mantee ɓal, kon Yéesú fë na wonuu Kiristaa ra, may rii hene ɗíh⁠ ⁠?⁠ ⁠» Wa ɓéeɓ wonu tih⁠ ⁠: «⁠ ⁠Daaƴe ri kurwah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilaat tahilte won tih⁠ ⁠: «⁠ ⁠A ri paŋ yii ɓosi bih⁠ ⁠?⁠ ⁠» Ndaa wa ɓaatuutee ɗaañnjoh na wonu tih⁠ ⁠: «⁠ ⁠Daaƴe ri kurwah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Olaꞌ Pilaat biti ɗi mínéh yin waa na, te wa ɓaatuu haayloh ɓaatoo ra, ɗi ɗaŋke muluɓ, na ɓooñnjoh fíi wë, won tih⁠ ⁠: «⁠ ⁠Mi lante yee nay yúfé ñif mi ɓëyí júɓí beh. Baa waal fon⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wa ɓéeɓ tahute wonu tih⁠ ⁠: «⁠ ⁠Ñif mi keenan sun fi fun a sun fi koyyi fun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tígí daaha, Pilaat ɗúhríɗté wë Barabaas kasaa. Ɗi fi Yéesú nék, ɗi laɓirohte ri laraw, antee wa rii yeɗɗaꞌ wa daaƴe ri kurwah. ");
INSERT INTO ndv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Filoon fi baaha, soldaarra ɓeyute Yéesú kúrúté rí faam gëernëer, wani kayya filiɓ ɓéeɓ gíiwúté rí. ");
INSERT INTO ndv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wa nísúté yéré yë faana, lofute ri paltu luum, ");
INSERT INTO ndv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ɓeyute ñap yugusute baane, ɓekute afa, anutee rii ɓek kankaniit bëhëer yaꞌi ñamaa fi, na ƴeku fíyí na këekkílíyúu rí wonu tih⁠ ⁠: «⁠ ⁠Coleere buuri yëwúɗɗë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wa na tuulsuu ri, ɓeyute kankaniidi bëhëerë yaꞌi, na laɓisuu ri af. ");
INSERT INTO ndv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Këekkëlíyúu wë rí níi wocce ra, wa nísúté paltaa faana, ɓekaatute ri búuɓɓí, na suu kúrí daaji kurwah. ");
INSERT INTO ndv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ɗúhrúu soldaarra Yéesú gina, wa teeꞌuute a ɓëyí dék Siren hínú Simoŋ, wa enute ri kurwahi Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lahuu wa tígë në wonuu Golgotaa ra (daa ri⁠ ⁠: këeŋ-af), ");
INSERT INTO ndv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","wa yerute Yéesú béeñí boolluu a yii haayte hek, ndaa ɗíkísëꞌ rí wë rë, ɗi kaaꞌaꞌte han. ");
INSERT INTO ndv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Daaha, wa daaƴute ri kurwaha. Filoon fi baaha, wa púlúfúté búuɓɓí, woruute wa hanndal ki wa, ");
INSERT INTO ndv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","anutee took na wohu ri. ");
INSERT INTO ndv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wa tíkúté unna won yee tah ɗi tíkú húl rë yeeddaꞌ ki afa sun. Unna won yii beh⁠ ⁠: «⁠ ⁠Ɓëyí bee daa Yéesú, buuri yëwúɗɗë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Lahte banndi ana yi daaƴaaluute kurwah ɓal hëbís Yéesú⁠ ⁠: ɓëyí yínëe paaꞌte ri yaꞌ ñamaa, yínëe paaꞌte ri yaꞌ sugu. ");
INSERT INTO ndv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɓëewë na ñeyu hatni baa ra, na solu Yéesú, hégíƴé affi wa, ");
INSERT INTO ndv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","wone tih⁠ ⁠: «⁠ ⁠Ɗo fa won biti fay poo Faam fi gaani Koope, fu taɓahaat ɗi filiɓ waal éeyë rë, namee sëmlëꞌ afu⁠ ⁠! Hena biti fu Koy Koope raa, nuule kurwaha⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kélfë yí seeƴoh ya, yëeddëh yí kootii Mëyíis a ɓaha ya gina na ñaawlu ri ɓal wonu tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«⁠ ⁠Ɗi sëmlëꞌté i ow kay, ɗi antee mínéh sëmlëꞌ afi⁠ ⁠! Ɗi henaꞌ buuri Israyel ɗíh⁠ ⁠? Ɗi nuulan kurwaha book fun gém ɗii na⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Won neh ɗi tík yaakaari Koope na, a biti daa ri Koohi a⁠ ⁠? Hena biti Koope fahaꞌte ri raa, sëmlëe rí leegi⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wa fi banndi ya daaƴu kurwah homute hëbísí rë ɓal na ñaawlu ri ti ɗaaha nen. ");
INSERT INTO ndv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lahaꞌ naꞌ leelu af ra, gina ɓéeɓ ñúussé túɗ níi mitte wahtu éeyë. ");
INSERT INTO ndv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wahtii éeyë fë, Yéesú ɗaasse foŋ won tih⁠ ⁠: «⁠ ⁠Eloyi, Eloyi, lama sabaktani⁠ ⁠?⁠ ⁠» Daa ri⁠ ⁠: Koope, Koope, fu súugëh sëꞌ yi taan⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lahte i ow di ɓëewë húmú daaha ra, keluu wa unni ƴah, wa wonu tih⁠ ⁠: «⁠ ⁠Ɗi ee dëek Éelí rë kan⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ow di waa na yíppée múkë, ɓeɓpe líil sooppe ri bineegar, pokke ri af baaŋ bëhëer, yuliɗte ri ɓúk Yéesú na fahaꞌ hënndí. ");
INSERT INTO ndv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ɓëewí kayya na wonu tih⁠ ⁠: «⁠ ⁠Yéɗɗí yen olsoh nda Éelí ay ac sëmlëꞌí rëe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tígí daaha, Yéesú ɗaasaatte foŋ, yeɗɗohte lússé. ");
INSERT INTO ndv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tígí daaha, rídíi ɓídí Faam fi gaani Koope ɗap tígí selaa níi sela ra, ɗaɗte dalaꞌte sun níi feey, ɓísëlsëꞌté ana. Wahtii baaha, feey fa na hégíƴëh, laꞌ yi gaanna na ɗarsaꞌ, ");
INSERT INTO ndv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","lahte luuyyi kúnsëhté, i ow caak di ɓëewí Koope këllúté ɓúudé, ");
INSERT INTO ndv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ɗúhúté nuŋŋi wa. (Wa fa ɗúhú nuŋŋi wa ƴaaha ra, filoon fi bee këllúu Yéesú ɓúudé rë, wa haalute Yerusalem gini selaa níi ow caak olute wa sah.) ");
INSERT INTO ndv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kélfíi soldaara a ɓëewée ké rí në húmú wohu Yéesú rë, oluu wa hégíƴëhí feey fa a iña lah ɓéeɓ rë, tíitúté níi tíit, wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí bee Koy Koope kaah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lahte i ɓeleɓ caak húmú cëehúuté na olsuu⁠ ⁠; daa wa ɓeleɓɓa na húmú ñéerúu a Yéesú na tooppituu ri homaꞌ ri Galile níi a ɗee ra. ");
INSERT INTO ndv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mari fi ɓëy Makdalaa húmú waa na, a Mari yaafi Saak a Suseef, a yaafi koyyi Sebede. ");
INSERT INTO ndv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sosaꞌ naꞌ ra, lahte ɓëyí caakke yin dék Arimate acce, ɗi hínú Suseef. Ɗi non taalibe yi Yéesú ɓal. ");
INSERT INTO ndv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɗi payte meelte Pilaat ɓúudé fi Yéesú. Pilaat tahte, nahaꞌte biti ɗi yeru ri. ");
INSERT INTO ndv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Suseef ɓeɓpe ɓúudé fë, payte líiwté rí a perkal has, ");
INSERT INTO ndv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ɗappe ri kolom ki anuu yotu loo laꞌ, bi ɗi saamiɗ ɗi afi koon. Ɗi píníŋké laꞌ gaan kúnté nuŋa antee saañ. ");
INSERT INTO ndv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Di filiɓ ƴaaha ɓéeɓ, Mari fi ɓëy Makdalaa a Mari fi yínëe homute tasute daaha, tookute jaannduute luuya. ");
INSERT INTO ndv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kéy fín fë, yiin bisa na hílsúu rë, kélfë yí seeƴoh ya a fariseŋŋa ñéerúuté, payute Pilaat na ");
INSERT INTO ndv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","wonu ri tih⁠ ⁠: «⁠ ⁠Gëernëer, fun nérsúuté biti na pesaꞌ felohi baa ra, ɗi húmú wonte biti waal éeyë filoon fi húlí, ɗi ay këllú ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kon wohree luuya níi waali éeyë fë⁠ ⁠; page níi taalibe yi ɓanti loh ɓúudé fë, anti wone ɓëewë filoon fe biti ɗi këlluté ɓúudé. Baa lah raa nay lukee ɓos fellee merees.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaat won wa tih⁠ ⁠: «⁠ ⁠Wohoh ya íníh në woo⁠ ⁠? Ɓéyí wë wa woh luuya di fahuu ron ri⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wa koluute suute luuyin, ñofute ílë pak leewute ri, tíkúté wohoh ya daaha. ");
INSERT INTO ndv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɗúmëꞌ bisa na hílsúu yëwúɗɗë rë, dímëesë ɓaabin cúɓ, Mari fi ɓëy Makdalaa a Mari fi yínëe suute kénsëhí luuyi Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ɗee a ɗeh, feey fa na hégíƴëh hégíƴëhí misikke⁠ ⁠: malaaka di malaaka yi Koo-Yíkëe kolaꞌte sun céppé, acce píníŋké laꞌa kúnúu luuya ra hatin, tookke sun. ");
INSERT INTO ndv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Malaakaa niiñ niiño níi na tiriñ⁠ ⁠; búubí naaꞌ naaꞌo níi na tak. ");
INSERT INTO ndv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wohoh ya tíitú tíitë níi na saaku, keenute ti húlíɗ nen. ");
INSERT INTO ndv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tígí daaha malaakaa won ɓeleɓɓa tih⁠ ⁠: «⁠ ⁠Ngënë tíití⁠ ⁠! Mi yúhté biti ɗon saamu Yéesú fë húmú daaƴu kurwaha ra. ");
INSERT INTO ndv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɗi íníh deh, ɗi këllúté ɓúudé ti ɗee húmú wonaꞌ ri ra nen. Ëyí ɗon olsoh tígë húmú fënɗú rí rë. ");
INSERT INTO ndv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yípíi pay ɗon won taalibe yi biti ɗi këllúté ɓúudé, te ri këllëhté rën Galile. Ɗon ay rii olee dín fë. Unni soꞌ ƴaa koon.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ɓeleɓɓa yípútée koloh luuya a tíitëe yí wë, ndaa keeññi wa sosse níi sos, wa múkëyúté komi taalibe ya wona. ");
INSERT INTO ndv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ɗee a ɗeh, Yéesú na ac téebílëhí wë, won wa tih⁠ ⁠: «⁠ ⁠Cëlíi paŋ⁠ ⁠!⁠ ⁠» Ɓeleɓɓa leɓuute ri, yabaaluute kotta, na jaamiyuu ri. ");
INSERT INTO ndv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Ngënë tíití⁠ ⁠! Pëyí ɗon won koy-yaayyi soꞌ saañ Galile⁠ ⁠: wa ay soo olee dín fë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Homuu ɓeleɓɓa waala wa na suu ra, lahte soldaarri nonu ƴee na húmú wohu luuya ra, na nimilu ginin léhíní kélfë yí seeƴoh ya iña lah ƴaa ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wa fi kélfë yí seeƴoh ya namutee dëek ɓaha ya gina, wa gonlute níi pokute, anutee yeɗ soldaarra juur hélíis, ");
INSERT INTO ndv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wonu wa tih⁠ ⁠: «⁠ ⁠Lah wëní ɓëewë biti taalibe yi Yéesú daa ayu elek lohute ɓúudé fí ɗeef ɗon na neeꞌu. ");
INSERT INTO ndv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Woni baa tíl níi síit nuf gëernëer rëe, fun ay yúh ɗee nay fun ɗii nofantee níi ɗon ɗúh në rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldaarra ɓeyute hélsë, pagute yee nahu wa ra. Woni wa líiwëlsëꞌté filiɓ fi yëwúɗɗë, te lísúu wonu níi a ɗeh. ");
INSERT INTO ndv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Léhínúu wë ɓeleɓɓa ra, taalibe yi sabboo a yínë yë koluute suute Galile, lawute daŋa húmú tíisëꞌ wë Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Séenúu wë rí, wa yabute na jaamiyuu ri. Filiɓ fi baaha ɓéeɓ, lahte ƴi lahute nuf ana ɗii na. ");
INSERT INTO ndv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tígí daaha, Yéesú leɓohte wa, won wa tih⁠ ⁠: «⁠ ⁠Mi onute sañ-sañi pagaa mi yin ɓéeɓ sun a feey⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","kon pëyí ɗon haal ginna ëldúnë ɓéeɓ, ɗon saamiɗ soꞌ i taalibe, ɗon bëtís wë di tii Boffa, tii Koy ka a tii Ruuh-Peseŋ, ");
INSERT INTO ndv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","te ɗon yëedíɗ wë, wa ñee iña won mi ɗon ra ɓéeɓ. Yúhí biti mee leeloon faraah níi kiri fi kirih.⁠ ⁠»");
INSERT INTO ndv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uni Neba leŋ Yéesú-KiristaaKoy Koope na ra dalaꞌ ɗeh. ");
INSERT INTO ndv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Di bíníyúu rí téeríi yonente Isayii sun fi, Koope won ɗi tih⁠ ⁠: «⁠ ⁠Olsee⁠ ⁠! May wol ow këllëh ɗaɗɗi ro waal. ");
INSERT INTO ndv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lahte un ɓëyí ɗofohte luufa, na won tih⁠ ⁠: “Ɗëɗɗí Yíkëe waal, ɗon yugusiɗ ɗi waalla nay rii ñeye ra níi júɓ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Saŋ homaꞌ luufa ɗaaha, na won ɓëewë biti wa warutee lof pesaɗ, wa bëtsú, Koope baal wa bakaaɗɗi wa. ");
INSERT INTO ndv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɓëy Yerusalem a ginni kayyi deyi Yúdée ɓéeɓ húmú ayuu Saŋ na, wa wone bakaaɗɗi wa, ɗi bëtsé wë filiɓ laahi Yurdeŋ. ");
INSERT INTO ndv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Saŋ húmú ɓekaꞌ búubí yugusuu a fënúf géléem, ɗi pokoh geñu hun kinohi⁠ ⁠; ɗi húmú pesaꞌ paƴ a kúum. ");
INSERT INTO ndv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ɗi húmú wonaꞌ ɓëewë tih⁠ ⁠: «⁠ ⁠Filoon fi soꞌ, ɓëyí luk soo gaan ee ac ɗa, te mi haaƴayti liil kotti. ");
INSERT INTO ndv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi bëtsëꞌ ron a muluɓ, ndaa ɗi ay ron bëtsée a Ruuh-Peseŋ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bín fë, Yéesú kolaꞌ Nasaret di Galile acce, Saŋbëtíssé rí laahi Yurdeŋ. ");
INSERT INTO ndv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tígë në ɗúhëꞌ rí mulaa ra, ɗi otte sun-Koo yíppée kúnsëh, Ruuh-Peseŋ na cép sun fi man bëdú nen. ");
INSERT INTO ndv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lahte uni kolaꞌte sun-Koo tígí daaha, won tih⁠ ⁠: «⁠ ⁠Daa fu Koy soꞌ⁠ ⁠! Mi fahaꞌte ro níi fahaꞌ⁠ ⁠! Keeñ soꞌ sosse ɗoo na níi sos⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ruuh-Peseŋ yíppée yeñ Yéesú, kúɗté rí luufa. ");
INSERT INTO ndv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ɗi hompe dín fë waal sabay iniil (40), Seytaane na saam fíirí. Yéesú a raɓɓa luufa daa húmú dékú, malaaka ya na tooppituu ri. ");
INSERT INTO ndv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hompe níi, Saŋ ɓekute kasu. Filoon fi baaha Yéesú saañce Galile, na waare Uni Neba kolaꞌ Koope na ra ");
INSERT INTO ndv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","na won tih⁠ ⁠: «⁠ ⁠Wahtaa lahte, Nguur ki Koope leɓohte⁠ ⁠; lëfí pesaɗ te ɗon gém Uni Neba.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Lahte bis, Yéesú ñee ɓúk laahi Galile, otte Simoŋ a Anndere koy-yaafi, na bacu mbaali wa laaha. Wa húmú i seeɓoh. ");
INSERT INTO ndv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ɗi dëekké wë won wa tih⁠ ⁠: «⁠ ⁠Ñéyí tal soꞌ mi yëedíɗ ɗon, ɗon hen seeɓoh ow.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wa yípútée hel mbaalli wa, ñeyute tala. ");
INSERT INTO ndv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lahaꞌ Yéesú fíi rë, ɗi otte Saak a Saŋ koyyi Sebede⁠ ⁠: wa húmú filiɓ gaali wa, na yugusu mbaalli wa. ");
INSERT INTO ndv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yéesú yíppée wëe dëek⁠ ⁠; wa helute boffi wa filiɓ gaala a ɓëewë në légéyú ɗii na ra, ñeyute tal Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yéesú a ɓëewí koluute suute Kafarnawum. Lahaꞌ bisa na hílsúu rë, Yéesú haalte tígë na ɗaguu yëwúɗɗë Koope ra, na teeɓaꞌ yee won Téerëe rë. ");
INSERT INTO ndv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ɓëewë në síkírúu rí rë éemúté ɗee na yëeddëꞌ rí wë rë, ndah di na yëeddëꞌ rí maday a di na paguu ri yëeddëh yí kootii Mëyíis, bi na yëeddëꞌ rí a sañ-sañ. ");
INSERT INTO ndv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wahtii baaha, ɗeef ɓëyí lahaꞌ yébítëh haalte tígë na ɗaguu yëwúɗɗë Koope ra, na foŋ won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«⁠ ⁠Yéesú fí ɓëy Nasaret, fu fahaꞌ paŋi fun yih⁠ ⁠? Fu ac múklí fun a⁠ ⁠? Mi yúh rë⁠ ⁠! Daa fu Ɓëyí selaa ɗúhëꞌ Koope na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tígí daaha, Yéesú digiɗte uni won afa tih⁠ ⁠: «⁠ ⁠Héddée te fu yeris ɓëyí beh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tígí daaha, yébítëh fë kéeníɗté ɓëeꞌ kéenɗí misikke, na anti foŋ saleet sun na yeris ɗi ɓëeꞌ rë. ");
INSERT INTO ndv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɓëewë ɓéeɓ ɓaatuutee éem, wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Bee yi kan⁠ ⁠? Bee yëeddëꞌí hasi ñéerëꞌ a sañ-sañ kan⁠ ⁠! Yébítëh yë sah ñeyuu woni biti ɗi túuƴ wë yin⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tii Yéesú yíppée hen lëyëŋ filiɓ Galile ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ɗúhúu wë tígë na ɗaguu yëwúɗɗë Koope ra, Yéesú ñéerëꞌté a Saak a Saŋ, wa suute faam i Simoŋ a Anndere. ");
INSERT INTO ndv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lahi wa, ɗeef jér fëníɗté pacool Simoŋ ɓeleɓ, faana tampe níi tam. Yéesú yíppée wonu baaha. ");
INSERT INTO ndv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ɗi leɓohte jérdë, hampe yaꞌa këlíɗté rí. Tami faana yíppée ríi yeris, ɗi yampe na tooppitoh wa. ");
INSERT INTO ndv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Fíníin fín, haalaꞌ naꞌa ra, jéríɗɗë a ɓëewë yébítëh na ham wa ra ɓéeɓ komute Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɓëy gina ɓéeɓ teeꞌuute ílí faam fa. ");
INSERT INTO ndv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yéesú paƴce jéríɗ caak ƴi maduy jér. Ɗi líkké yébítëh caak ɓal, te wa yúhú daa ri wa. Ɗi kaddaꞌte wa won yin sun fi, ndée ɗi fahaay biti daa wa teeɓuun ɗi. ");
INSERT INTO ndv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hagadin ɗeef Koo líssí ñúus, Yéesú kolohte, ɗúhté gina, saampe tígí ɗaayte, na ɗaŋ. ");
INSERT INTO ndv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Koluu Simoŋ a ɓëewë ɓani wa ñéerúu rë ɓal, wa suute saami. ");
INSERT INTO ndv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Oluu wa ri ra, wa wonu ri tih⁠ ⁠: «⁠ ⁠Ɓëewë ɓéeɓ ee roo saamu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Yen saañ ílíƴ kay yen haal ginna leɓoh dee ra, mi waare dín fë ɓal, ndée yii baa daa tah mi koloh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɗaaha, ɗi haalte ílíƴƴë na ɗaguu yëwúɗɗë Koope ra di Galile ɓéeɓ, na waare, na lík yébítëh yë. ");
INSERT INTO ndv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bisa ín, lahte guuñndi leɓohte Yéesú, ƴekke fíyí, na ɗaŋ ri won tih⁠ ⁠: «⁠ ⁠Mi yúhté biti fu mín sëe paƴ mi haalaat ɓëewë në. Fii soo rii pagiɗ a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yéesú yérémpé rí, yeɗte yaꞌi tíkké sun fi, won ɗi tih⁠ ⁠: «⁠ ⁠Mi tahte ɗaŋu. Yípée wah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Guuña yíppée lan faan ɓëeꞌ, ɗi wahte. ");
INSERT INTO ndv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yéesú yíppée rí túuƴ saañ, na won afa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«⁠ ⁠Síkírée⁠ ⁠! Ngana won ow yii beh. Paye seeƴoha na, ɗi olsoh ro, te fu yeraꞌ saraha nahaꞌ Mëyíis rë fu púusëh, teeɓi ɓëewë ɓéeɓ biti fu lante.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ndaa sayaꞌ ɓëeꞌ rë, tígí ñee ri ɓéeɓ ɗi ɓílíɗ yee lah ra níi yaa hente lëyëŋ. Yii baa tahte níi Yéesú mínléh haalaꞌ gin fíi ɓëewë. Ɗi yeelti homaꞌ dey-dey ka di ílíƴƴí ɗaayte, ndaa kaaꞌeeh ɓëewë ɗúhée hatinna ɓéeɓ aye ɗii na. ");
INSERT INTO ndv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","I waal filoon fe, Yéesú nimilte Kafarnawum. Keluu ɓëewë biti ɗi ee faam ra, ");
INSERT INTO ndv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","faam fa yíppée líif ow níi kot ɗamleh na níi lukaꞌ ílë. Yéesú na teeɓ wa Unni Koope. ");
INSERT INTO ndv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wahtii baaha, lahte ɓëewí komute ri lëfëñídí ow iniil daa kúrú rí. ");
INSERT INTO ndv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ndaa caagi ɓëewë tahte níi wa míníh liil ɗii na a lëfëñídë. Ɗaaha, wa lawute sun fi lasa, pëensúté yeeddaꞌ ki tígë húmú Yéesú rë, ñéyrúté lëfëñídë fënɗú dila ra tígë pëensú wë baaha ra, yëellírúté rí níi rí lahte feey. ");
INSERT INTO ndv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Olaꞌ Yéesú ɗee gémúu wë rí rë, ɗi won lëfëñídë tih⁠ ⁠: «⁠ ⁠Ƴaal kowa, fu baalute bakaaɗɗu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lahte yëeddëh yí kootii Mëyíis, ƴi húmú filiɓ fi ɓëewë, na wonu nuffi wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«⁠ ⁠Ɓëyí bee wonaꞌ wonadi bee ɗíh⁠ ⁠? Ɗi solte Koope⁠ ⁠! Daa mín baalaꞌ bakaaɗ henay Koope⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yéesú yíppée yúh yee hom nuffi wa ra, won wa tih⁠ ⁠: «⁠ ⁠Ɗon níɓúu yii baa ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yi daa lukki yooɓ biti mi won ɓëyí beh⁠ ⁠: fu baalute bakaaɗɗu, mbée kolee fu ɓeɓ dilu fu tíl⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Woteh ɗon ay yúh biti soꞌ mi Koy-ɓëeꞌ, mi lahte sañ-sañi baalaa mi bakaaɗ feey fi beh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ɗi won lëfëñídë tígí daaha tih⁠ ⁠: «⁠ ⁠Kolee fu pon dilu, fu saañ faam. Daa mi túuƴ ɗë rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lëfëñídë yíppée koloh fíi ɓëewë ɓéeɓ, ponte dili, saañce. Wa ɓéeɓ éemúté níi éem, na kañu Koope wonu tih⁠ ⁠: «⁠ ⁠Ow ëllëy yii man ɗeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Filoon fi baaha, Yéesú ɗúhëetté, saañce ɓúk laahi Galile. Ow caak na ayu ɗii na, ɗi yëeddé wë. ");
INSERT INTO ndv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ɗi hom waali, otte yeekoh túm tookke tígë në légéyëꞌ rí rë⁠ ⁠; ɗi hínú Léwí, ɗi koy Alfe. Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Kolee fu ñee tal soꞌ.⁠ ⁠» Léwí yíppée koloh wa ñéerúuté. ");
INSERT INTO ndv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na húmú reeru Yéesú a taalibe yi faam Léwí rë, wani i yeekoh túm a i bakaaroh kay, ƴi caakute daa húmú në, ndée mani ɓëewí ƴaa caak na húmú ñeyu tali. ");
INSERT INTO ndv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Oluu fariseŋŋa na yëeddúu rë biti Yéesú a ɓëewí ƴaa daa boku ñam ra, wa wonu taalibe yi tih⁠ ⁠: «⁠ ⁠Yi tah Yéesú na bok ñam a yeekoh yi túmë a bakaaroh ya⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kelaꞌ Yéesú yee wonu wa baa ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Jéríɗɗë daa sohluu paƴoh ndaa ɓëewë wahu ra neh. Bakaaroh ya daa tahu mi koloh ndaa ɓëewë júɓú rë neh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lahte bis, taalibe yi Saŋ a fariseŋŋa húmú oorute⁠ ⁠; i ow waa na ayute Yéesú në, meelute ri, wonu tih⁠ ⁠: «⁠ ⁠Taalibe yi Saŋ a ƴi fariseŋŋa na ooru, kon yi tah ƴuu na ëeríh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Bee kílëek lahte ra, ɗon habuu biti kooƴƴa warutee oor te ɗeefa ɓëeꞌ kooɗ ɗa lís leelii wa a⁠ ⁠? Ɗon halaatuy ri maan⁠ ⁠? Hena biti ɓëeꞌ kooɗ ɗa lís waa na raa, wa míníh oor. Funi taalibe yi soꞌ nék madu a ɓëeꞌ kooɗ baa ra hom a kooƴƴi ra nen. ");
INSERT INTO ndv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bis ay lah mi këllú leelii wa, yiin fi baaha nék, wa ay oor. ");
INSERT INTO ndv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«⁠ ⁠Ow na daafeeh búuɓ kíilíɗ a nuf píis has. Henun ɗaaha raa, nuf píisí hasa hécëh sun fi búubí kíildë rëe, ɗara ay lukee gaan na. ");
INSERT INTO ndv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Te ow na soreh béeñí hasi anti dal poosaꞌ filiɓ mbúus hun kíilíɗ. Henun ɗaaha raa, béeñë ay poo mbúusë, wa yúfëh, mbúusë yah. Béeñ has kay, soruu mbúus has.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bisa na hílsúu yëwúɗɗë rë ín, Yéesú a taalibe yi ñeyu waali húus filiɓ i meey bele. Taalibe ya homu waala, yabute na kodu yaaŋnga yi belaa, na ɓuluñu na húñú. ");
INSERT INTO ndv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseŋŋa meelute Yéesú tígí daaha wonu ri tih⁠ ⁠: «⁠ ⁠Ole⁠ ⁠! Haalaꞌ yi níi taalibe yu na pagu yii Kootaa kaddaꞌte ri bisa na hílsúu rë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon yúhú yee húmú paŋ Dawit, bee yaaɓuu ɓani ɓëewí rë, anutee lahuy yii ñamun wa ra maan⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jamanaa henaꞌ Abiyataar seeƴohi gaani yëwúɗɗë rë, Dawit húmú haal Faam Koope, ñampe na mbúurëe yefu fíi Koope ra, ƴee seeƴoh ya kut daa waruu naa ñam ra, yeɗte na ɓëewí, wa ñamute ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yéesú ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Bisa na hílsúu rë daa saamɗu ow, ow neh daa saamɗu bisa na hílsúu rë. ");
INSERT INTO ndv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Daa tah soꞌ mi Koy-ɓëeꞌ, daa mi lah sañ-sañ sun fi bisa na hílsúu rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lahte bis, Yéesú haalilte tígë na ɗaguu yëwúɗɗë Koope ra. Ɓëyí yaꞌa ɓeedohte húmú në. ");
INSERT INTO ndv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseŋŋa na olsuu Yéesú nda ri ay paƴ ɓëeꞌ bisa na hílsúu yëwúɗɗë rë, nda wa lah yii yabun wa ri. ");
INSERT INTO ndv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tígí daaha, ɗi won ɓëeꞌ tih⁠ ⁠: «⁠ ⁠Kolee fu caŋ fíi ɓëewë ɓéeɓ deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ɗi antee won ɓëewë tih⁠ ⁠: «⁠ ⁠Kootaa nahaꞌ yi bisa na hílsúu rë⁠ ⁠? Paŋ yin wun mbée paŋ yin ɓos⁠ ⁠? Sëmlëꞌ ow mbée yeris ɓëeꞌ húl⁠ ⁠?⁠ ⁠» Wa ɓéeɓ henute tiɗ. ");
INSERT INTO ndv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ɗi yeelaꞌte ɓëewë haay keeñ⁠ ⁠; ɗee súhúu wë keeñ ra misikke ri níi misik. Tígí daaha, ɗi won ɓëeꞌ yaꞌa ɓeedoh ra tih⁠ ⁠: «⁠ ⁠Yere yaꞌu⁠ ⁠!⁠ ⁠» Ɓëeꞌ yeɗte yaꞌi, yaꞌa yíppée wah koloŋ. ");
INSERT INTO ndv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseŋŋa ɗúhúté tígë na ɗaguu yëwúɗɗë Koope ra, na yípúu peen a i ow di ɓëewí Erot ɗee nay waa page níi wa hap Yéesú húl rë. ");
INSERT INTO ndv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yéesú a taalibe yi koluu daaha suute ɓúk laahi Galile. Ɓëewí caakute níi caak na ayu ɗii na. Wa ɗúhúu Galile, Yerusalem a ginni kayya Yúdée ɓéeɓ, Ídúmée, ginna hom filoon laahi Yurdeŋ ra, a ɓëy deyi Tíir a Sidon. Ɓëewí ƴaa ɓéeɓ ayuu ɗii na biti wa keluute iña na paŋ ri ra. ");
INSERT INTO ndv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tígí daaha, ɗi nahte taalibe yi saamiɗ ɗi gaal ƴutuuɗ, kaaꞌaꞌi biti ɓëewë baɓ ri. ");
INSERT INTO ndv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Biti ɗi paƴce ow caak, tahte ɓëewë jérú rë ɓéeɓ hom yejuu sun fi, fahee leɓi. ");
INSERT INTO ndv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te ɓëewë yébítëh na ham wa ra ot Yéesú rëe, wa keenu keeno fíyí, foge sun wone tih⁠ ⁠: «⁠ ⁠Daa fu Koy Koope⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ndaa Yéesú kaddaꞌte wa lok wa won daa ri wa. ");
INSERT INTO ndv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Filoon fi baaha, Yéesú lappe sun daŋ, dëekké ɓëewë neɓaꞌ ri ra, wa ayute ɗii na. ");
INSERT INTO ndv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ɗi tansaꞌ ɓëewí sabboo a ana ya ɗaaha, falte wa apootar, nda wa hom hëbísí, ɗi wole wa waarii ɓëewë, ");
INSERT INTO ndv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ñéerëꞌ a sañ-sañi nay wa líkée yébítëh yë. ");
INSERT INTO ndv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ƴee daa tii yi apootarri sabboo a ana ya⁠ ⁠: Simoŋ, bee Yéesú yeɗ ɗi tii Peer ra, ");
INSERT INTO ndv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Saak a Saŋ koyyi Sebede, ƴee Yéesú yeɗ wa tii Bowanerses ra (daa ri⁠ ⁠: ɓëewí madduu pilliŋ nen)⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ɓaatte Anndere, Fílíp, Bartalemi, Maccëe, Toomaa, Saak fi Alfe, Taddee, Simoŋ fi jammbaara ");
INSERT INTO ndv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","a Yudaas Iskariyot fa míllëꞌtée yaay Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nimiluu wa faam ra, ow caak teeꞌluute daaha, tahte níi Yéesú a taalibe yi taluy sah ñamaa. ");
INSERT INTO ndv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Keluu mboko yi yii baa ra, wa habuu biti afa ínlíh në tahte níi wa koluute kalii. ");
INSERT INTO ndv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yëeddëh yí kootii Mëyíis, ƴi ɗúhúu Yerusalem, na wonu ɗi ñéerëꞌ a Belsebul buuri yébítëh yë, daa tah ɗi mín wëe lík. ");
INSERT INTO ndv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yéesú dëekké wë, na léeh wë won tih⁠ ⁠: «⁠ ⁠Seytaane mínëꞌ lík afi ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɓëewí daa boku nguur haaꞌee filiɓ fi wa raa, nguur ki baa ay mínée maañ ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te ɓëewí daa boku faam haaꞌee filiɓ fi wa raa, faam fi baa ay míllée poo. ");
INSERT INTO ndv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kon hena biti Seytaane haaꞌ afi ti ɗaa nen koon, nguur ki ay ɗarsaꞌ keen, ɗi ɗúmlëꞌ. ");
INSERT INTO ndv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«⁠ ⁠Ow mínéh haal faam ɓëyí mitte ow, poo faam fa, te ɗéɓéeh rii pokalsaꞌ. Ɗi pokalsaꞌ ri níi woc raa kay, ɗi mín ɓeɓ alal mi. ");
INSERT INTO ndv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«⁠ ⁠Mee ron won kaah ra ee⁠ ⁠: bakaadi paŋ ow ɓéeɓ mín ɗíi baalu níi lukaꞌ solaꞌ ya yuloh Koope na ra. ");
INSERT INTO ndv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ɓëyí sol Ruuh-Peseŋ raa nék, ɗi ii mëssí baalu⁠ ⁠; ɗeef ɗi lahte bakaadi mínéh lan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Woni ɓosa wonu ɓëewë sun fi Yéesú biti ɗi lahaꞌ yébítëh rë daa tah ɗi won wa unni ƴah. ");
INSERT INTO ndv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lahuu yaafa a koy-yaayyi Yéesú faam fa ra, wa cagu ëssë nahuute dëegí. ");
INSERT INTO ndv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɓëewë húmú tooku tooko, wërúté rí. Ow won ɗi tih⁠ ⁠: «⁠ ⁠Yaafu a koy-yaayyu ínú ëssín, na meeluu ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yéesú tahte won tih⁠ ⁠: «⁠ ⁠Wa daa yaasoꞌ a i wa daa koy-yaayyi soꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɗi na anti yeel ɓëewë húmú hëbísí rë, won tih⁠ ⁠: «⁠ ⁠Yaasoꞌ a koy-yaayyi soꞌ daa wa ƴeh. ");
INSERT INTO ndv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yúhí biti ɓëyí në paŋ yee fahaꞌ Koope ra ɓéeɓ, ɓëyí baa daa koy-yaasoꞌ mbée yaasoꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yéesú sayilte ɓúk laahi Galile, na yëeddëꞌ. Ɓëewí caakute níi caak ayute wërúté rí, tahte níi ɗi míllëꞌ haal gaal filiɓ laaha, tookke na, ɓëewë homute ɓúk laaha. ");
INSERT INTO ndv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ɗi ñeyaꞌte léeh na teeɓ wa yin caak won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«⁠ ⁠Síkíríi⁠ ⁠! Lahte ɓëyí húmú koloh sohi meeyi. ");
INSERT INTO ndv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ɗi hom hasli tisoh ka, lahte peppi keente ɓúk waala, ƴakka ayute tanute wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Lahte ƴi keen feey fi lahaꞌ laꞌ. Bi caakay feey fa, wa yíppée paal⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ndaa kolaꞌ naꞌa sun ɗa, bi nooray níillë, wa yíppée tam. ");
INSERT INTO ndv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lahte ƴi keen tígí paalaꞌ ñobitaan. Kolaꞌ ñobitaan fa hampe wa ra, wa tampe ɗúhrëy yin. ");
INSERT INTO ndv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lahte ƴi keen feey fi looɓpe. Wa paalte, talla kolohte, ɗúhíɗté íl, laaɓpe níi laaɓ. Tal fi tal ɓéeɓ yeraꞌte yee waɗ rii yeraa ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yéesú ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Ɓëyí lah nuf kelaa, kelaan na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɗaayuu wa a Yéesú rë, ɓëewë na ñéerúu a ri merees ra a taalibe yi sabboo a ana ya meelute ri yii leŋke léeh yí. ");
INSERT INTO ndv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon, kúmpíi Nguur ki Koope teeɓu ɗon, ndaa yii won mi ɓëewí kayya ɓéeɓ teyaꞌ léeh, ");
INSERT INTO ndv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nda wa yeele raa wa ëlíh në, te wa kelee raa wa yíih yee na wonu ra, toñeh keeññi wa ay kúnsée ndín, wa lof pesaɗ, wa baalu bakaaɗɗi wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yéesú ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Ɗon yíih yee fahaꞌ won léehí baa raa, ɗon ay mínée yúh yee won léeh yí kayya ra ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","«⁠ ⁠Síkíríi⁠ ⁠! Tisoh ka sohu ra Unni Koope. ");
INSERT INTO ndv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ɓúk waala keen tisoh ka ra, daa ɓëewë yéŋké biti keluu wa Unna ra, Seytaane yíppée ac, pahte wa keeññi wa ra. ");
INSERT INTO ndv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Feey fa lahaꞌ laꞌ tisoh ka keen na ra, daa ɓëewë yéŋké biti keluu wa Unna ra, wa yípútée wëe tah a sos-keeñ⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ndaa Unna yípëy níil keeññi wa. Wa topuun waa ham guuttii baaha⁠ ⁠: kofeel yípée wëe daɓ mbée wa moklu af hama habu wa Unna ra rek, wa koluun daaha yeris ngémë. ");
INSERT INTO ndv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Feey fa na paal ñobitaan tisoh ka keen na ra, daa ɓëewë yéŋké biti keluute Unna ra. ");
INSERT INTO ndv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tíl tílë níi nék, sohle yi ëldúnë, alal ma na nofaꞌ ow ra a neɓ pes lúfílté Unna waa na, tahte níi wa lahray wa njiriñ. ");
INSERT INTO ndv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Feey fi looba keen tisoh ka ra, daa ɓëewë yéŋké biti keluu wa Unna ra, wa tahuute wa yaꞌ ana⁠ ⁠: ow fi ow waa na ɓéeɓ njiriñce yee waɗ ɗii njiriñ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yéesú wonil wa tih⁠ ⁠: «⁠ ⁠Ow na ɓeɓ lampa líh if sun fi, mbée ɓek ri fëgërëh tigal woo⁠ ⁠? Lampa líkúu tígí neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yúhí biti yii ɗapu ɓéeɓ ay yúhú, yii laku ɓéeɓ ay olu. ");
INSERT INTO ndv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɓëyí lah nuf kelaa, kelaan na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yéesú wonil wa tih⁠ ⁠: «⁠ ⁠Lah héní wun iña na keluu ɗon ɗa⁠ ⁠! Ɗee na natɗuu ɗon ɓëewë rë, Koope ay ron natɗee ɗaaha níi tíkíɗ ɗon. ");
INSERT INTO ndv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yúhí biti ɓëyí ham yee yeru ri ra a yaꞌ ana, ay ɓaatu. Ɓëyí pagay yii baaha raa nék, yii ƴutuuda lahaꞌ ri ra sah ay naafu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yéesú wonil tih⁠ ⁠: «⁠ ⁠Nguur ki Koope madaꞌ a bee ow ɓekke tisoh ki feey ra nen. ");
INSERT INTO ndv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ɗi kolaꞌ daaha, elga lah ɗi fanoh, Koo yíil ɗi koloh, te tisoh ka ay paal, wa ooɗ, te ɗi yéeh sah ɗee na lahaꞌ iñƴaaha ra. ");
INSERT INTO ndv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Feey fa daa na tah lec lah⁠ ⁠: gañcah daa na ɗéɓpí koloh, tíkëh yaaŋngaa, peba anti ɗúh. ");
INSERT INTO ndv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wa non raa ɗeef lec lahte⁠ ⁠; ɓëeꞌ ɓeɓ sarcii lec wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yéesú wonil tih⁠ ⁠: «⁠ ⁠Yen ay mëllée Nguur ki Koope a yih⁠ ⁠? Léehí bi daa mín teeɓaꞌ ɗee man ɗi ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nguur ki Koope madaꞌ a pebi ƴutuudi baa sohu raa, lukaꞌ ri ƴin peppi tisoh ya ɓéeɓ níi, ");
INSERT INTO ndv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ɗi liilti paal raa, tala ooɗ níi luk talli gañcaha meeya ɓéeɓ, yaꞌ ya gaan níi ƴakka mín nëe túf, sëegúlëh në.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yéesú yëeddëꞌ ɓëewë Unni Koope a léeh yí man ɗah. Ɗi wonte wa na caak níi tígí teem yee mínú wëe yúh rë. ");
INSERT INTO ndv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɗi na húmú woneh a ɓëewë te ñeyeeh léeh⁠ ⁠; ndaa ɓani taalibe yi ɗaay raa, ɗi teeɓ wa yee fahaꞌ won léeh yë rë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sos-naꞌin fa, Yéesú won taalibe yi tih⁠ ⁠: «⁠ ⁠Yen saañ ɓúk laaha hatni bín.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Taalibe ya heluu ɓëewë daaha, wa yejute gaala húmú Yéesú rë filiɓ laaha wa ñéerúuté. I gaal kay ɓedute wa. ");
INSERT INTO ndv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hom homo níi ngilaaw gaan yíppée yeñ, mboowaanna na soɗ gaala muluɓ. ");
INSERT INTO ndv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ɗi fi Yéesú húmú tal gaala, giginte afi na neeꞌ. Taalibe yi na fogu yúunúté rí wonu ri tih⁠ ⁠: «⁠ ⁠Yen ee suu húlé rë Ɓahaa⁠ ⁠! Fu oleh na olo ɗee déy⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kolaꞌ Yéesú rë, ɗi digiɗte uni, túuƴcé ngilaaw ma a mulii laaha héddëh won wa tih⁠ ⁠: «⁠ ⁠Héddíi, ɗon hen tiɗ.⁠ ⁠» Ngilaaw ma yíppée woc, mulii laaha hente tiɗ. ");
INSERT INTO ndv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ɗi antee won taalibe ya tih⁠ ⁠: «⁠ ⁠Ɗon tíitú yí ɗeeha⁠ ⁠? Ɗon gémúy Koope gémë doom a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wa tíitú tíitë níi wa na meelantuu hanndal ki wa wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí bee mën ɗí ow ɓal níi ngilaaw ma a mulii laaha sah na ñeyu woni⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Húusúu wë laaha ra, Yéesú a taalibe yi teeruu gina na wonuu Gerasaa ra. ");
INSERT INTO ndv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ɗúhëꞌ rí gaala ra, ɓëyí lahaꞌ yébítëh yíppée ɗúh hacaa ya, acce téebílëhí. ");
INSERT INTO ndv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ɓëeꞌ húmú dék hacaa ya, te ow húmú mínéh ríi pok níi rí fúséh⁠ ⁠; wuti ri pokuun a tiiŋ raa sah ɗi fús. ");
INSERT INTO ndv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ƴee eena, na lah kotta a yaꞌ ya pokalsuu a tiiŋ, ndaa faraah ɗi korsaꞌ wa, te ow lahay doolii mín ɗii ham. ");
INSERT INTO ndv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Naꞌ a elek ɓéeɓ ɗi homaꞌ hacaa ya mbée saañ daŋŋin, liike, gaañsee afi laꞌ ya. ");
INSERT INTO ndv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Séenëꞌ ɓëeꞌ Yéesú rë, ɗi daaƴce múkë, acce ƴekke fíyí, ");
INSERT INTO ndv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ɗaañnjohte won tih⁠ ⁠: «⁠ ⁠Ɗo fi Yéesú Koy Koope fa sunaa-sun, fu fahaꞌ paŋi soꞌ yih⁠ ⁠? Daa mi na ɗaŋ ɗo ri, di tii Koope, ngana torohal fun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Biti ɗeef Yéesú ɗéɓpée won yébítëh fë yeris ɓëeꞌ, daa tah ɗi won yii bah. ");
INSERT INTO ndv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yéesú antee rii meel won ɗi tih⁠ ⁠: «⁠ ⁠Daa fu hínú ɗíh⁠ ⁠?⁠ ⁠» Ɓëeꞌ won ɗi tih⁠ ⁠: «⁠ ⁠Mi hínú Dúukël, ndée fun caakute.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɗi na anti ɗaŋ Yéesú ɗaŋi misikke biti ri ɓan waa ɗúhíɗ gina. ");
INSERT INTO ndv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ɗeef lahte yubi mbaam-túgëllí caakute na píisúu ñam araal daŋa. ");
INSERT INTO ndv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yébítëh yë na ɗagu Yéesú wonu ri tih⁠ ⁠: «⁠ ⁠Yeñ fun mbaammi ƴín në, fun haal waa na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ɗi onte wa yee ɗagu wa ra, wa ɗúhúté ɓëeꞌ në, suute haalute mbaamma na. Yuba yíppée yeɗɗoh yëellëen kí daŋa, mbaamma ɓéeɓ soruute laaha, húlúté. Wa húmú warutee hen mbaam júnní ana (2.000). ");
INSERT INTO ndv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Níirëh yí mbaamma heguute suute gin-taahin a ginna luufa, na ɓíllú yee lah ra. Tígí daaha, ɓëewë namutee ac kénsëhí yee na wonuu ra. ");
INSERT INTO ndv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lahuu wa hëbís Yéesú rë, wa ɗeefu ɓëeꞌ dúukël yébítëh húmú ham ri ra, ɓekohte búuɓ, tookke, ñéerëꞌté a sago fi. Wa yípútée tíit. ");
INSERT INTO ndv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɓëewë maasuu yee kat ɓëeꞌ a mbaamma ra, ɓíllúu wë yee lah ra, ");
INSERT INTO ndv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ɓëy gina ɗagute Yéesú ɗúh gin wa saañ. ");
INSERT INTO ndv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ɗi hom haali gaala, ɓëeꞌ dúukël yébítëh húmú ham ri ra na ɗaŋ ri nda wa mínú ñéerëꞌ. ");
INSERT INTO ndv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yéesú tahray ri, ndaa won ɗi tih⁠ ⁠: «⁠ ⁠Nimile mboko yu na faam, fu ɓílíɗ wë ɗee naaꞌaꞌ Yíkëe keeñ ɗoo na níi pagiɗte ro yii bee ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ɗaaha, ɓëeꞌ saañce deya na wonuu Gin-taah-sabboo ra, na ɓílíɗ iña pagiɗ ɗi Yéesú rë ɓéeɓ. Ɓëewë në síkírúu rí rë ɓéeɓ éemúté. ");
INSERT INTO ndv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yéesú nimilte ɓúgí yíníi laaha a gaala. Ɗi hom daaha, i ow caak ayute wërúté rí. ");
INSERT INTO ndv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tígí daaha, ow di njíittí tígë na ɗaguu yëwúɗɗë Koope ra hínú Yayrus, ayaꞌ daaha otte Yéesú, yeɗɗohte kotti, ");
INSERT INTO ndv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","cagohte ri na ɗaŋ won tih⁠ ⁠: «⁠ ⁠Ɓahaa, koy ki ɓelii soꞌ ee maanndaꞌ húl rë⁠ ⁠; aye fu tík yaꞌu faana nda ri koloh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ɓani Yéesú ñéerúuté na suu. Ow caak ñeyute talli wa, na yejantuu na baɓuu Yéesú në. ");
INSERT INTO ndv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ɗeef lahte ɓelii húmú në, hente kíil sabboo a kíil ana yi ɗi yúfëꞌ ñif. ");
INSERT INTO ndv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɗi mokke yaꞌ paƴoh caak. Ɗi túmpé në iña lahaꞌ ri ra ɓéeɓ ndaa ri píyëy yoofaa⁠ ⁠; jérë luk naa ɓaatoh ɓaatoo sah. ");
INSERT INTO ndv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Bi keloh ri ban fi Yéesú, ɗi won nufi tih⁠ ⁠: «⁠ ⁠Na mi leɓa búubí rek, may wah⁠ ⁠!⁠ ⁠» Ɗi acce húussé leelii ɓëewë, ñeyaꞌte ri filoon, leɓpe búubí. ");
INSERT INTO ndv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ɗi na leɓ búubë, ñif ma yíppée lécíɗ, ɗi yéŋké faani biti ɗi wahte. ");
INSERT INTO ndv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yéesú yíppée yéŋ biti lahte doolii kolohte ɗii na. Ɗi yíssëhté ɓëewë në, won tih⁠ ⁠: «⁠ ⁠Daa leɓ búubí sëꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Taalibe yi wonu ri tih⁠ ⁠: «⁠ ⁠Fu otte biti ɓëewë ɓéeɓ ee yejantuu ra na baɓuu ɗoo na, fu na meelaꞌ ɓëeꞌ leɓ ɗoo na ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ndaa Yéesú bette íllí filiɓ fi ɓëewë, na saam ɓëeꞌ paŋ yaa ra. ");
INSERT INTO ndv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yúhëꞌ ɓelaa biti daa ri na saamu ra, ɗi tíitté níi na saak⁠ ⁠; tígí daaha, ɗi acce yeɗɗohte kotta, wonte ri kaaf ka ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yaa ow, ngémú tahte fu wahte. Fu mín saañ a jaamma, fu wahte.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yéesú hom wona, lahte ɓëewí ɗúhúu faam Yayrus ayute, wonu kélfíi wë tih⁠ ⁠: «⁠ ⁠Sohlaay fu mokle Yëeddëhë⁠ ⁠; koohu húlté⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ndaa Yéesú síkírëey woni wa, tahte won Yayrus tih⁠ ⁠: «⁠ ⁠Ngana néekíñëꞌ, fu laakiraꞌ gém kut.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na saañ Yéesú rë, ɗi tahay biti ow kay ɓen ɗi, henay Peer, Saak a Saŋ koy-yaafi Saak. ");
INSERT INTO ndv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lahuu wa faam fin ra, wa ɗeefu na pasooɓ fi misikke⁠ ⁠: ɓëewë na fogu, na hawuu. ");
INSERT INTO ndv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Haaluu wa ra, Yéesú won ɓëewë tih⁠ ⁠: «⁠ ⁠Pasooɓ fi misigi bee haalaꞌ yih⁠ ⁠? Kúkëyë húlëy, ɗi neeꞌ neeꞌo rek.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓëewë yabute na ƴenu ri. Tígí daaha, ɗi nahaꞌte ɗúhrí ɓëewë ɓéeɓ, hampe boffi kúkëyë ɗii na, yaafa a taalibe ya ɓedu ri ra, wa haalute lasa húmú kúkëyë rë. ");
INSERT INTO ndv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yéesú hampe yaꞌ kúkëyë, won tih⁠ ⁠: «⁠ ⁠Talitaa kúm⁠ ⁠!⁠ ⁠» Daa ri⁠ ⁠: «⁠ ⁠Kolee kúkëy ɓeleɓ⁠ ⁠! Daa mi nah ro ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kúkëyë yíppée koloh na tíl. Ɓëewë ɓéeɓ éemúté níi éem. Ɗi húmú lahaꞌ kíil sabboo a kíil ana. ");
INSERT INTO ndv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yéesú cagohte ɓëewë, kaddaꞌte waa won yee lah ra, antee waa nah oni kúkëyë ñam. ");
INSERT INTO ndv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yéesú kolohte daaha, saañce gin wa, ñéerëꞌté a taalibe yi. ");
INSERT INTO ndv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lahaꞌ bisa na hílsúu rë, ɗi haalte tígë na ɗaguu yëwúɗɗë Koope ra na yëeddëꞌ. Goomali ɓëewë na húmú síkírúu rí rë éemúté níi na wonu tih⁠ ⁠: «⁠ ⁠Ɗi kolaꞌ iña na won ɗi ra dih⁠ ⁠? Daa on ɗi ham-hama a doolaa pagaꞌ ri kimtaanni ƴee ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bee daaƴoha saa ɓal⁠ ⁠! Hanaa yaa koy Maryaama neh⁠ ⁠? Bee koy-yaafi Saak, Soses, Yúɗ a Simoŋ saa⁠ ⁠? Koy-yaayyi ɓeleɓ íníh ee na pesu leelii yen a⁠ ⁠?⁠ ⁠» Kénsúu wë iñƴaa ra, wa gémúy rí. ");
INSERT INTO ndv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ndaa Yéesú won wa tih⁠ ⁠: «⁠ ⁠Yonente heefuu gina dék ɗí rë, mboko yi na, a ɓëy faam wa na kut.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yéesú húmú mínéh paŋ kimtaan daaha, henay jéríɗɗí yínë-yínë yë tík ɗí yaꞌ paƴce wa ra. ");
INSERT INTO ndv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Gémë gémúy rí ɓëewë rë beettite ri. Yéesú kolaꞌ dah, saañce ñeete ginna hatni baaha ɓéeɓ, na yëeddëꞌ. ");
INSERT INTO ndv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Lahte bis, ɗi dëekké taalibe yi sabboo a ana ya, na wolaꞌ wa ana-ana. Ɗi onte wa sañ-sañ líkëe yébítëh, ");
INSERT INTO ndv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","antee waa won tih⁠ ⁠: «⁠ ⁠Henay duuɗ yaꞌ yon, ngënë kúrëelíi yin waalon⁠ ⁠: yii ñamun neh, nafa neh, hélíis faannon neh. ");
INSERT INTO ndv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɓékíi ñafaɗɗon, te ngënë kúrëelíi búuɓ lofaa. ");
INSERT INTO ndv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ɗon lah ílíƴ rëe, lah hëmí faam fa nay ron hanluu ra níi bín koluun ron gini baaha ra. ");
INSERT INTO ndv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te ɗon pay ílíƴ ɓëewë kaaꞌ hamon haneel, kaaꞌ síkírëhën rëe, lah këlíi daaha, ɗon paaŋ pënë mí kotton, teeɓi wa biti wa homuy kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Taalibe ya koluu daaha suute, na wonu ɓëewë biti wa warutee lof pesaɗ. ");
INSERT INTO ndv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wa líkúté yébítëh caak ɓal, paƴute jéríɗ caak, na leefu wa díw. ");
INSERT INTO ndv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bi hen tii Yéesú lëyëŋ gina, buura hínú Erot ra kelohte ban fi. Lahte ɓëewí wonu biti Saŋ Batis daa waɗti këllú ɓúudé daa tah ɗi mín paŋ kimtaan. ");
INSERT INTO ndv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ƴee wonu yonente Éelí daa ayaat. Lahte ƴi wonu ti ɓal, ɗi yonente ti ƴee merees nen. ");
INSERT INTO ndv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kelaꞌ Erot wonaa ya ra, ɗi won nufi tih⁠ ⁠: «⁠ ⁠Kon Saŋ fa mi húmú lecɗoh lúumë rë daa këllú ɓúudé⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bee daa yee húmú kat Saŋ Batis ra⁠ ⁠: Erot daa húmú ɓekroh Saŋ kasu af Erojat. Yii baa húmú lahaꞌ ɗeh⁠ ⁠: Erot húmú naaf Erojat ɓeleɓ Fílíp koy-boffi. ");
INSERT INTO ndv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Saŋ won Erot bín fë tih⁠ ⁠: «⁠ ⁠Waal neh fu naafe ɓeleɓ koy-boffu⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yii baa tahte Erojat húmú neeɓaꞌte Saŋ níi fahaꞌte hawrohi húl, ndaa ri húmú mínéh yin na, ");
INSERT INTO ndv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ndah Erot húmú yeɗte Saŋ cér. Bi yúh rí biti ɗi júɓpé te ri ɓëyí Koope, ɗi kaaꞌaꞌte ow paŋ ri yin ɓos. Saŋ húmú wone ɗii na koon raa, wonna jam ri, ndaa kaaꞌeeh ɗi fahaꞌte síkírëhí. ");
INSERT INTO ndv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nimilaꞌ bisa límú Erot kíilí baaha ra, ɗi cëgíɗté ndaje gaan, dëekké dakki, kélfë yí soldaarra a ɓëewí gaanna Galile. Ɗi fi Erojat nék húmú séhíɗ mani bisi baaha koon sah faf. ");
INSERT INTO ndv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Koy ki ɓelaa haalte na bec, beja neɓaꞌte Erot a haneelli. Ɗi won kúkëyí cafaƴ ka tígí daaha tih⁠ ⁠: «⁠ ⁠Meel soꞌ yii neɓaꞌ ro, mi yeɗ ɗo ri⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ɗi tíkké në añohte, won tih⁠ ⁠: «⁠ ⁠Yii meel fu soꞌ ɓéeɓ may roo rii yeɗ⁠ ⁠; wuti ƴaha hatni yíníi gin soꞌ raa sah mi yeɗ ɗo ri⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kúkëyí cafaƴ ka ɗúhté, won yaafa tih⁠ ⁠: «⁠ ⁠Yaay, may meelee yih⁠ ⁠?⁠ ⁠» Yaafa won ɗi tih⁠ ⁠: «⁠ ⁠Meelee af Saŋ Batis.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kúkëyí cafaƴ ka yíppée nimil buura na kotta-kotta, won ɗi tih⁠ ⁠: «⁠ ⁠Mi fahaꞌ biti fu tík af Saŋ Batis sun waꞌ, fu yeɗ soꞌ ri ɗee leegi ɗeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Keeñ buur ɗúmpé ces, ndaa bi añoh ri fíi haneella tahte ɗi mínéh rii kaaꞌiɗ. ");
INSERT INTO ndv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ɗi yíppée túuƴ wohoh kom ɗi af Saŋ Batis. Wohoha payte kasiin, lecce af Saŋ Batis ");
INSERT INTO ndv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tíkké rí waꞌ, kompe ri kúkëyí cafaƴ ka, kúkëyë yeɗte ri yaafi. ");
INSERT INTO ndv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Keluu taalibe yi Saŋ yaa ra, wa ayute, ɓeyute ɓúudé fë, ɗapute ri kolom. ");
INSERT INTO ndv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ayuu apootarra waala ɗúhúu wë rë níi wa goorute hëbís Yéesú rë, wa ɓíllúté rí iña pagu wa ra a ƴee yëeddúu wë rë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bi caaku ayoh ya a sayoh ya níi caak, wa lahuy jodi túmúun wë yin ɓúkkí wë. Yéesú won wa tígí ɗaaha tih⁠ ⁠: «⁠ ⁠Ëyí yen saañ tígí ɗaayte, ɗon hílsëh ƴutuuɗ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wa yeeluutee haal gaal, na suu hécëh tígí ɗaayte, wulohi ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ow caak olute Yéesú a taalibe yi na suu, nuffi wa payte tígë na suu wa ra. Tígí daaha, ginna ɓéeɓ na ɗúh ow, wa múkëyúté, këllúuté wë në. ");
INSERT INTO ndv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cépëꞌ Yéesú gaala ra, ɗi otte ɓëewí caakute níi caak. Tígí daaha, keeña ɗúmpé waa na ces, ndah wa madu harri lahuy níirëh nen. Ɗaaha, ɗi hompe a wa yii maañce, yëedíɗté wë yin caak. ");
INSERT INTO ndv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Bi na yëellëh naꞌa, taalibe ya leɓuute ri, wonu ri tih⁠ ⁠: «⁠ ⁠Wone ɓëewí ƴee saañ ginna leɓoh dee ra, wa saame yii túmún wë ɓúkkí wë, tígë homu yen dee ra lahay yin, te naꞌ ee saañ haale ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ƴah, yérí wë yii nay waa ñame.⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fu won ɗíh⁠ ⁠? Hélsí mín ñëmíɗ ɓëewí ƴee ɓéeɓ ay ɗúhúu dih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠Ɗon lahuu mbúurú ɗíh⁠ ⁠? Pëyí ɗon kénsëh⁠ ⁠!⁠ ⁠» Payuu wa ra, wa ayute, wonu ri tih⁠ ⁠: «⁠ ⁠Mbúurú iip a jén ana daa deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tígí daaha, Yéesú nahte taalibe ya won ɓëewë tookaꞌ goomal-goomal sun fi gaaw fi hilsida. ");
INSERT INTO ndv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɓëewë tookuute goomal, ƴee lahte ow tíméer (100), ƴee ow sabay iip (50). ");
INSERT INTO ndv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ɗi ɓeɓpe mbúurú yí iippa a jénní ana ya, ɓéyíɗté afi yeelte sun, símpé Koope, antee lecsaꞌ mbúurëe, yeɗte wa taalibe ya, nahte wa woraꞌ wa ɓëewë. Ɗi hente jénní ana ya ɗaaha ɓal níi ɓëewë ɓéeɓ mitute na. ");
INSERT INTO ndv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓëewë ɓéeɓ ñamute níi laalute. ");
INSERT INTO ndv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Négírúu wooñnjiidi mbúurëe a jénë rë, wa líiffé dama sabboo a dama ana. ");
INSERT INTO ndv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ow ƴaal júnní iip (5.000) húmú nonu ɓëewë ñamu na ra. ");
INSERT INTO ndv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Filoon fi baaha, Yéesú yíppée nah taalibe yi haal gaala, wa këllëh rí ɓúgí yíníi laaha naꞌ-naꞌ hatna Betsaydaa, ɗi fi baa ɗi pëkís ɓëewë paaƴ. ");
INSERT INTO ndv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pëkísëꞌ rí wë rë, ɗi saañce ɗaŋ Koope sun fi daŋin. ");
INSERT INTO ndv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Elgi Koo ɗeef gaala lahte leelii laaha. Yéesú a afi daa húmú tasu ëssë. ");
INSERT INTO ndv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɗi otte biti joowa misikke taalibe yi na, ndah wa jaannduu ngilaaw ma. Lahaꞌ hagada ra, ɗi tíl tílë sun fi mulaa, na saañ ri ɗeefri wa ra. ");
INSERT INTO ndv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Oluu wa Yéesú na tíl sun fi mulaa ra, wa habuu biti koon yaa jíné⁠ ⁠; wa yabute na fogu. ");
INSERT INTO ndv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wa ɓéeɓ olute ri, te wa tíitúté níi tíit. Yéesú yíppée wëe won tih⁠ ⁠: «⁠ ⁠Hëbí affon⁠ ⁠! Ngënë tíití⁠ ⁠! Yaa soꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ɗi na haal gaala, ngilaaw ma seemmite. Taalibe ya éemúté níi éem, ");
INSERT INTO ndv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ndah nagajek bi túl affi wa, wa húmú yíih yee fahaꞌ won kimtaana paŋ Yéesú níi mbúurëe caakke caagi baaha ra. ");
INSERT INTO ndv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Húusúu wë laaha ra, wa teeruu Senesaret. ");
INSERT INTO ndv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wa na cépú gaala, ɓëewë në yúhsúu Yéesú, ");
INSERT INTO ndv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","yípútée múkë deyi baa ɓéeɓ teeɓaꞌi ayi. Tígí keluun ɓëewë ayi ɓéeɓ, wa tík jéríɗɗë sun fi dilla, kúɗ wa ɗii na. ");
INSERT INTO ndv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tígí pay ri ɓéeɓ, gin-taah neh, ginna a faamma luufa neh, ɓëewë kúrúu jéríɗɗë këemmë, wa ɗage ri leɓ wuti ƴaha nuf búubí kut. Te ɓëewë leɓu na ra ɓéeɓ wahute. ");
INSERT INTO ndv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lahte bis, i fariseŋ a i yëeddëh yí kootii Mëyíis koluu Yerusalem ayute Yéesú në. ");
INSERT INTO ndv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Lahuu wa ra, wa olute biti i ow di taalibe yi Yéesú na ñamu te wa laduy, daa ri biti wa ɓooñnjuuy ti di ɓaahuu caacci wa nen. ");
INSERT INTO ndv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wa fi fariseŋŋa a yëwúɗɗë ɓéeɓ habu ɓaahi caacci wa níi wa ɗamuuy roo ñamiɗ te wa ɓëeñnjíih ɓooñnjohi ñeete waal. ");
INSERT INTO ndv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te wa kolaꞌ leꞌ fin raa, wa ii roo ñamiɗ te wa ɓúkútíih. Caakke ɓaah yi kayyi wa habute wa⁠ ⁠: yii man ti ɗee na hosuu kaas, yaaɗ, a kuluŋ ra nen. ");
INSERT INTO ndv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fariseŋŋa a yëeddëh yí Kootaa meelute Yéesú wonu ri tih⁠ ⁠: «⁠ ⁠Yi tah taalibe yu në pëgíh yee ɓaahuu caacca ra⁠ ⁠? Yi tah wa na ñamu te wa ɓooñnjuuy ɓooñnjohi ñeete waal⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ƴee wonnon teem ɓúkkën ƴee ra, yonente Isayii húmú wonaꞌ ron, te ri won kaah na bíní rí unee Koope bee ra⁠ ⁠: “Kaña na kañu soꞌ ɓëewí ƴee ra teem ɓúkkí wë. Yee hom keeññi wa ra haaƴaay a yee nahaꞌ mi ra. ");
INSERT INTO ndv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jaamiyoha na jaamiyuu wa soꞌ ra lahay njiriñ⁠ ⁠; iña na yëeddúu wë rë, ow doŋ daa sak wa.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon heluu túuƴëꞌ yí Koope dín, ɗon habute ɓaah yee ke ron ɓaah ow ra. Ɗon habuu biti ɗon homu kaah ɗaa a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ɗon yúhúté biti neh Mëyíis won tih⁠ ⁠: “Lah tëeppítíi baappon a yaayyon”, te “ɓëyí won ɓos sun fi boffi mbée sun fi yaafi waɗti hawun húl” ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ndaa ɗon, ɗon yëeddúu biti ɓëyí won boffi mbée yaafi biti kut, yee waɗ mi ron yeɗ koon ra hente korban, daa ri sarahi ay yeru Koope raa, ɓëyí baaha lahriray boffi mbée yaafi yin. ");
INSERT INTO ndv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tígí daaha, ɗon onute ri yii ay tah ɗi ii pagril boffi a yaafi yin yee tas fíi rë. ");
INSERT INTO ndv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɗaaha, ɗon nísúté iña túuƴëꞌ Koope ra, ɗon tíkúté ɓaah ya na yëeddúu ɗon ra. Te ɗon lahute mani ɓaah yi ƴaaha caak.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yéesú antee dëekëet ɓëewë, won wa tih⁠ ⁠: «⁠ ⁠Ɗon ɓéeɓ síkíríi sëꞌ, te ɗon ɓek iñƴee affon⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Iña na ñam ow ra ɓéeɓ, lahay bi na tah ri sobe⁠ ⁠; yee na kolaꞌ keeñ ow ra kay, daa na tah ɗi sobe.  ");
INSERT INTO ndv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ɓëyí lah nuf kelaa, kelaan na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kolaꞌ Yéesú ɓëewë në daaha níi lahte faam ra, taalibe yi meelute ri yee fahaꞌ rii won unni ƴaa ra. ");
INSERT INTO ndv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ƴee nam, affon lahay daaha ɓal a⁠ ⁠? Ɗon yíih biti yii ɗúhëꞌ fëel haal faan ow mínéh ríi sobeyil a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ɗon warutee yúh biti yii ñam ow na haaleh nuf ɓëeꞌ, ndaa haalaꞌ lowa ɗúh faana⁠ ⁠!⁠ ⁠» Yéesú won daaha bitih⁠ ⁠: ñam ɓéeɓ dagante. ");
INSERT INTO ndv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ɗi ɓaatte won tih⁠ ⁠: «⁠ ⁠Yee na ɗúhëꞌ nuf ow ra daa na tah ɗi sobe. ");
INSERT INTO ndv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Nuf ow daa na komaꞌ iñi ɓossi ƴee ɓéeɓ⁠ ⁠: njaaliyoh a yii tappe njaaliyoh ɓéeɓ, loh, bëem ow, fahaꞌ, ɓos nuf, nofaꞌ ow, búgúlëm, ɓos-íl, yah tii, gaan-gaanloh, ñak faale yin. ");
INSERT INTO ndv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iñi ɓossi ƴaa ɓéeɓ ɗúhëꞌ nuf ow te daa na tah ow sobe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yéesú kolohte daaha, saañce deyi Tíir. Lahaꞌ ri ra, ɗi haalte faam, hompe na. Ɗi húmú fahaay ow yúh biti ɗi aa daaha, ndaa ri mínéh múuƴ. ");
INSERT INTO ndv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lahte ɓelii yébítëh na ham koy ki ɓelii, kelohte ban fi Yéesú, yíppée ac ɗii na, yeɗɗohte kotta. ");
INSERT INTO ndv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ɓëyí ɓelaa yëwúɗ neh⁠ ⁠; ɗi ɓëyí Fénésí di Sírí. Ɗi ɗaŋke Yéesú lígí yébítëh fë ham koohi ra. ");
INSERT INTO ndv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yeɗɗe tuŋka ñam paaƴ níi loo yi wa maƴ⁠ ⁠; ɓosse biti ñami tuŋka yúfɗëe ɓuh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɓelaa loffe ri won tih⁠ ⁠: «⁠ ⁠Baa kaah ɓahaa, ndaa kaaꞌeeh ɓuh ñam ruuƴsiitta keenaꞌ yaꞌ yi tuŋka ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yéesú won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Una won fu baa ra tahte fu mín nimil faam⁠ ⁠: yébítëh fë yerisse koohu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nimilaꞌ ɓelaa faam ra, ɗi ɗeef koohi larohte tigal ka, yébítëh fë yerisse ri. ");
INSERT INTO ndv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yéesú kolaꞌ Tíir daaha, ñeete Sidon, húussé deya na wonuu Gin-taah-sabboo ra, nimilte laahi Galile. ");
INSERT INTO ndv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lahaꞌ ri ra, lahte ɓëewí komute ri ɓëyí likke, ɗagute ri nda ri tík ɗí yaꞌ. ");
INSERT INTO ndv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yéesú ɗúhíɗté rí filiɓ fi ɓëewë, ɓani éccúuté, ɓekke kunni nuffa, leeffe ri muluuc pereema⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ɗi antee ɓéyíɗ afi yeelte sun, lëeysíɗté keeñ, won ɓëeꞌ tih⁠ ⁠: «⁠ ⁠Efataa⁠ ⁠!⁠ ⁠», daa ri⁠ ⁠: «⁠ ⁠Kúnsée⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nuffi ɓëeꞌ yíppée kúnsëh, pereema pëkísëhté, ɗi na won woni lante. ");
INSERT INTO ndv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yéesú kaddaꞌte ɓëewë ɓílíɗ yii leŋ na⁠ ⁠; ndaa yii luk waa rii kaddaꞌ ɓéeɓ, wa lukuu ɓílíɗ në. ");
INSERT INTO ndv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓëewë húmú éemú éemë níi na wonu tih⁠ ⁠: «⁠ ⁠Yii paŋ ɗi ɓéeɓ wun níi wun⁠ ⁠! Ɗi na paƴ likiɗ níi rí kelee, paƴ ɓëyí mínéh won níi pereema lan⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Waalli ƴaaha, ow caak teeꞌlute Yéesú në, te wa lahuy yii ñamun wa. Yéesú dëekké taalibe yi tígí daaha, won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«⁠ ⁠Mi yérémpé ɓëewí ƴeh⁠ ⁠! Hente waal éeyë woteh wa ewu soo na, te wa lahluy yii ñamun wa. ");
INSERT INTO ndv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mi yeris wa wa sayaꞌ faam a loo holoŋ raa, wa ay koh waala. Filiɓ fi wa, lahte ɓëewí koluu ílíƴ wul.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Taalibe yi wonu ri tih⁠ ⁠: «⁠ ⁠Yii mín ñëmíɗ ɓëewí ƴee níi loo yi wa maƴ ay ɗúhúu dih luufi përéedí beh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yéesú meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗon lahuu mbúurú ɗíh⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun lahuu mbúurú paana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tígí daaha, ɗi wonte ɓëewë ɓéeɓ took feey. Ɗi ɓeɓpe mbúurú yí paana ya, símpé Koope, lecsaꞌte wa yeɗte taalibe yi, nahte wa woraꞌ wa ɓëewë. Taalibe ya ɓeyute mbúurëe, woruute wa ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wa húmú lahute i jén ƴin-ƴin ɓal. Yéesú ɓeɓpe wa, símpé Koope, antee nah taalibe yi woraꞌi wa ɓëewë ɓal. ");
INSERT INTO ndv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓëewë ɓéeɓ ñamute níi laalute. Négírúu wooñnjiida ra, wa líiffé dama paana. ");
INSERT INTO ndv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yéesú antee waa pëkís, wa suute. Ɓëewë húmú warutee mit ow júnní iniil (4.000). ");
INSERT INTO ndv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yéesú a taalibe yi yípútée haal gaala, wa suute deyi Dalmanutaa. ");
INSERT INTO ndv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lahte bis, i fariseŋ saamu olsohi Yéesú, ayute na gonlu a ri. Wa nahute ri paŋ kimtaani nay teeɓee biti Koope daa wol ri. ");
INSERT INTO ndv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yéesú lëeysíɗté keeñ, won tih⁠ ⁠: «⁠ ⁠Yi tah ɗon fi ɓëy jamanii beh, ɗon na meeluu kimtaani kolaꞌ Koope na⁠ ⁠? Mee ron won kaaf ka ra ee⁠ ⁠: ɗon ii teeɓu kimtaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yéesú antee waa hel daaha, haalaatte gaala, ɓani taalibe yi na suu ɓúgí yíníi laaha. ");
INSERT INTO ndv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na suu wa ra, taalibe ya halute kúrëelëh mbúurú. Wa húmú lahuu mbúurú yínë kut waa na filiɓ gaala. ");
INSERT INTO ndv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yéesú na líkín wë won tih⁠ ⁠: «⁠ ⁠Wëettíyíi affon⁠ ⁠! Lah mëytíi lëwíirí fariseŋŋa a lëwíirí Erot.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Taalibe ya na capituu wonu tih⁠ ⁠: «⁠ ⁠Biti yen lahuy mbúurú daa tah ɗi won yii bah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Bi yúh Yéesú yee na wonu wa ra, ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠Ɗon capituu yi biti ɗon lahuy mbúurú⁠ ⁠? Kon ɗon yíih sëꞌ yúhë doom te ɗon kélíih në ë⁠ ⁠? Affon túlëꞌté rí ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ɗon na ëlíh te ɗon lahute íl ë⁠ ⁠? Ɗon na kélíih te ɗon lahute nuf a⁠ ⁠? Ɗon nérsúuy ");
INSERT INTO ndv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","bee húmú lecsaꞌ mi mbúurú yí iippa woruu ɓëewí júnní iippa (5.000) ra a⁠ ⁠? Négírúu wooñnjiida ra, wa líif dama ɗíh⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Wa húmú líif dama sabboo a dama ana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ɗi ɓaatte won wa tih⁠ ⁠: «⁠ ⁠A bee húmú lecsaꞌ mi mbúurú yí paana ya yeru ɓëewí júnní iniilla (4.000) ra, négírúu wooñnjiida ra, wa húmú líif dama ɗíh⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Wa húmú líif dama paana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Ɗon kélíih në keloo doom a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yéesú a taalibe yi lahute Betsaydaa. Ɗi komute búumíɗ daaha, ɗagute biti ɗi tík yaꞌi sun fi. ");
INSERT INTO ndv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ɗi hampe yaꞌ búumndë, nookke ri, ɗúhíɗté rí gina, antee rii leef muluuc íl, tíkké yaꞌ yi sun fi, meelte ri won tih⁠ ⁠: «⁠ ⁠Fu ot yin na woo⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Búumndë yeelte, won tih⁠ ⁠: «⁠ ⁠Mi otte i ow na tílú, ndaa wa madduu ti tal kilik nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yéesú tíkëetté yaꞌ yi íllë. Yeelaꞌ búumndë ngëeƴ ɗë, ɗi wahte, íllë lante ces. ");
INSERT INTO ndv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tígí daaha, Yéesú nahte ri saañ faam na won ri tih⁠ ⁠: «⁠ ⁠Ngana ñeyaꞌ filiɓ gina⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Filoon fi baaha, Yéesú a taalibe yi koluute na suu ginna hëbís Sesare Fílíp. Homuu wa waala ra, ɗi meelte wa won tih⁠ ⁠: «⁠ ⁠Ɓëewë wonuu biti daa mi wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Lahte ɓëewí wonu biti daa fu Saŋ Batis, lahte ƴi wonu fu yonente Éelí, i ow kay ɓal wonu ti fu ow di yonente ya.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ɗi meelilte wa won tih⁠ ⁠: «⁠ ⁠A ɗon, ɗon wonu biti daa mi wah⁠ ⁠?⁠ ⁠» Peer tahte won tih⁠ ⁠: «⁠ ⁠Daa fu Buura Koo fal ri ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tígí daaha, Yéesú kaddaꞌte wa won ow yii leŋ na. ");
INSERT INTO ndv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yéesú dalaꞌ teeɓi taalibe yi tígí daaha, won wa tih⁠ ⁠: «⁠ ⁠Soꞌ mi Koy-ɓëeꞌ, mi waɗtee mok níi mok⁠ ⁠: ɓaha ya, kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis ii soo fahaꞌ tík íl⁠ ⁠; may hawu húl, te waali éeyë fë filoon fi húlí sëꞌ, may koloh ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ɗi wonte wa unni lante yii baaha. Tígí daaha, Peer dëekké rí, wa éccúuté, na won afa. ");
INSERT INTO ndv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ndaa Yéesú yíssëhté, yeelte taalibe yi, na anti won af Peer won tih⁠ ⁠: «⁠ ⁠Wuloh soꞌ Seytaane⁠ ⁠! Ɗoni Koope bokuuy ɗee oluu ɗon yii bee ra⁠ ⁠; fu ot olaɗ ow.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yéesú antee dëek ɓëewë a taalibe yi, won wa tih⁠ ⁠: «⁠ ⁠Ɓëyí fahaꞌ ñéerëꞌ a soꞌ, ɗi helan iñi afi, enoh kurwahi, anti ñee tal soꞌ. ");
INSERT INTO ndv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ɓëyí núp húl ay ñak ñíiní⁠ ⁠; ndaa ɓëyí tah ñagi ñíiní af soꞌ a Uni Neba, ay lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kaah neh biti alal mi ëldúnë caleh ow yaay ñíiní ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ñíiní yaayute ay tosuu ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɓëyí iñi soꞌ a wonni soꞌ tah ri sopoh fíi ɓëy jamanii bee yégúy Koope te dékúu bakaaɗ ƴee ra, soꞌ mi Koy-ɓëeꞌ may rii súugëh yiin nay mii aye filiɓ ndami Baasoꞌ, mi ñéerëꞌ a malaaka yi sela ya ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yéesú ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: lahte ɓëewí ewu ɗon na deh, balaa wa húl, wa ay ot Nguur ki Koope aye a doole.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Waal pëenë filoon fe, Yéesú dëekké Peer, Saak a Saŋ, hécëhté a wa, kúɗté wë sun fi daŋi utte. Lahuu wa ra, Yéesú lofisohte fíi wë⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","búuɓɓí naaꞌ naaꞌo níi na tak. Lahay ɓëyí ee feey fa mín hos búuɓ níi naaꞌaꞌ ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɗee a ɗeh, wa olute yonente Éelí a Mëyíis feeñiyuute na gonlu a ri. ");
INSERT INTO ndv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peer tahte won Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, neɓpe biti yen homun tígí deh, fun yíp dút éeyë⁠ ⁠: fu lah yínë, Mëyíis yínë, Éelí yínë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peer húmú yéeh iña na won ɗi ra ndah tíidë homuu ɓani taalibe yi ana ya ra. ");
INSERT INTO ndv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tígí daaha, lahte nérí acce, húunté wë⁠ ⁠; un ɗofohte filiɓ nérë won tih⁠ ⁠: «⁠ ⁠Bee daa Koy soꞌ. Mi fahaꞌte ri níi fahaꞌ. Síkíríi rí⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Taalibe ya yípútée olsoh hatni baa ɓéeɓ, ndaa wa olliluy ow, henay Yéesú a afi kut daa tasu waa na. ");
INSERT INTO ndv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wa koluu daaha na cépú daŋa. Wa homu cébë, Yéesú kaddaꞌte wa ɓíllí yee olu wa ra níi bín kolaa ɗi fi Koy-ɓëeꞌ ɓúudé rë. ");
INSERT INTO ndv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wa habute yee won wa Yéesú rë, ndaa wa na meelantuu hanndal ki wa biti yi daa koloh ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tígí daaha, wa meelute Yéesú wonu ri tih⁠ ⁠: «⁠ ⁠Yi tah yëeddëh yí kootii Mëyíis na wonu biti Éelí waɗtee nimil paaƴ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠Ahaŋkay⁠ ⁠! Éelí waɗtee nimil paaƴ yugusaꞌ iña ɓéeɓ. Ndaa wona won Téerëe biti ɓal Koy-ɓëeꞌ ay mok níi mok, te ɓëewë ii rii fahaꞌ tík íl rë, ɗon oluu ri ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Soꞌ mi beh, mee ron won ra ee biti Éelí nimilte, ɓëewë pagute ri yii neɓaꞌ wa ti ɗee bíníyúu rí Téerëe rë nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tílúu wë níi wa leɓuute taalibe yi kayya ra, wa olute biti lahte dúukëlí ɓëewí wërúté wë, te i ow di yëeddëh yí kootii Mëyíis na gonlu a wa. ");
INSERT INTO ndv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Oluu ɓëewë Yéesú rë, wa ɓéeɓ éemúté, wa yípútée ríi téebílëh na suu wodohi. ");
INSERT INTO ndv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yéesú meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗoni wa gonlu sun yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ow di ɓëewë tahte won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, mi kom ɗo koy ki ƴaali soꞌ koon⁠ ⁠; ɗi lahaꞌ yébítëh fí kaddaꞌte ri won. ");
INSERT INTO ndv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tígí habaa ri yébítëh fë ɓéeɓ, hom kéenɗëꞌ rí feey, ɓúgë púumé, ɗi ɗoɓe síssí, faana hen jiɗɗil. Mi ɗaŋke taalibe yu lígí yébítëh fë, ndaa wa míníh yin na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yéesú tahte won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ɓëy jamanii bee gémúy Koope ƴee ra, may home ɗon na mi mújdé rën níi kirih⁠ ⁠? Këmí sëꞌ kúkëyë deh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ɗi komute ri. Olaꞌ ri Yéesú, yébítëh fë hégíƴcé faan kúkëyë ɓéeɓ, kéeníɗté rí feey, ɗi na píníŋëh, ɓúgë në púum. ");
INSERT INTO ndv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yéesú meelte boffa won ɗi tih⁠ ⁠: «⁠ ⁠Yii bee dal ri ham kirih⁠ ⁠?⁠ ⁠» Boffa won ɗi tih⁠ ⁠: «⁠ ⁠Yaa dal ri ham ɗeef ɗi ƴutuuɗ níi a ɗeh. ");
INSERT INTO ndv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ƴee ee na yébítëh fë ham ɗi raa sah, hom yejaꞌ ri filiɓ kíi mbée filiɓ muluɓ fahee hawi húl. Fu mín yin na raa, yérém fun, fu habraꞌ fun na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu won nda mi mín yin na raa a⁠ ⁠? Lahay yii wooñ ɓëyí gémpé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Boffi kúkëyë yíppée tah won tih⁠ ⁠: «⁠ ⁠Mi gémpé, ndaa habraꞌ soꞌ filiɓ ngémí ƴutuuda lahaꞌ mi ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Olaꞌ Yéesú biti ɓëewë ee ɓaatuu ac ɗa, ɗi digiɗte uni won yébítëh fë tih⁠ ⁠: «⁠ ⁠Yébítëh fí bee na likil ow kaddaꞌ ri won ra, daa mi na túuƴ ɗë yeɗɗi kúkëyí beh, te ngana habil ri⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yébítëh fë yíppée ɗaas foŋ, hégíƴcé faan kúkëyë hégíƴí misikke antee rii yeris. Kúkëyë hente limaac ti húlíɗ nen, tahte níi lahte ow caak di ɓëewë maasuu ra habuu biti ɗi húlté. ");
INSERT INTO ndv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ndaa Yéesú hampe yaꞌa këlíɗté rí, kúkëyë caŋke. ");
INSERT INTO ndv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lahaꞌ Yéesú faam níi ɓani taalibe yi ɗaayute ra, wa meelute ri wonu tih⁠ ⁠: «⁠ ⁠Yi tah lígí yébítëh fë wooñ fun⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Yébítëh yë madu ɗee ra, ɗaŋ Koope na doŋ daa mín wëe lík.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Koluu wa daaha ra, wa na húusú Galile, te Yéesú húmú fahaay biti ow yúh baaha⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ɗi fahaꞌ biti ɗi teya yëeddí taalibe yi. Ɗi won wa tih⁠ ⁠: «⁠ ⁠Soꞌ mi Koy-ɓëeꞌ, may yaayu ɓëewë, wa hap soꞌ húl, te waali éeyë fë filoon fi húlí sëꞌ, may koloh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ndaa taalibe ya húmú yíih yee fahaꞌ ri waa won ɗa, te wa kaañuy rii meel. ");
INSERT INTO ndv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lahuu wa Kafarnawum wa haalute faam ra, Yéesú meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗon húmú gonluu yi waala⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ndaa wa lofuy ri, af biti homuu wa waala ra, wa taasantuu ɓëeꞌ lukki gaan waa na ra. ");
INSERT INTO ndv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tígí daaha, ɗi tookke, dëekké wa fi sabboo a ana ya, won wa tih⁠ ⁠: «⁠ ⁠Ɓëyí fahaꞌ këllëh, ɗi tahan míllëꞌ, hen súrgíi ɓëewë ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɗi antee ɓeɓ kúkëy ƴutuuɗ, kúɗté rí leelii wa, meeɓpe ri tíkké rí ɓaŋi antee waa won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«⁠ ⁠Ɓëyí af soꞌ tah ɗi ham kúkëy ti bee nen a yaꞌ ana, ɗeef ɗi ham soꞌ⁠ ⁠; te ɓëyí ham soꞌ, ɗeef ɗi habay soꞌ doŋ, ndaa hampe ɓëeꞌ wol soꞌ ra ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Saŋ won Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun olute ɓëyí líkëꞌ yébítëh tiyu. Biti ri noneh yen na tahte fun kadduute ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yéesú won tih⁠ ⁠: «⁠ ⁠Ngënë këddíi rí⁠ ⁠! Ow mínéh pagaꞌ kimtaan tii soꞌ níi woc, ɗi anti wone yin ɓos sun fi soꞌ filoon fe. ");
INSERT INTO ndv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yúhí biti ɓëyí kaaꞌaay yen, ñéerëꞌ a yen. ");
INSERT INTO ndv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Te ɓëyí on ɗon muluɓ han wuti ƴaha ƴutuuɗ ɗaa sah, af biti ɗon nonu ɓëewí sëꞌ mi Kiristaa na raa, mee ron won kaaf ka ra ee biti ɓëyí baa ay liil waafi. ");
INSERT INTO ndv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ndaa mas ɓëyí ɓek ow di taalibe yi soꞌ bakaaɗ, wa fi tuŋki ƴee gémú soo na ƴee ra⁠ ⁠! Biti ri poku laꞌ gaan lúum betu kísí, daa gén ɗii na. ");
INSERT INTO ndv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kon hena biti yaꞌu ay roo ɓeke bakaaɗ, lece ri, fu haalaꞌ pesa na ɗúméh rë a yaꞌ yínë kut, daa gén biti fu haalaꞌ safara a yaꞌ ana, filiɓ kíi kë ii mëssí ƴím rë.  ");
INSERT INTO ndv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Hena biti kotu ay roo ɓeke bakaaɗ, lece ri, fu haalaꞌ pesa na ɗúméh rë a kot yínë kut, daa gén biti fu betu safara a kot ana.  ");
INSERT INTO ndv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te hena biti ílú ay roo ɓeke bakaaɗ, lukute ri, fu haalaꞌ Nguur ki Koope a íl yínë kut, daa gén biti fu betu safara a íl ana, ");
INSERT INTO ndv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tígí cégínnë na ñamu faan ra na húlíh, te kíi kë ii ƴím faw. ");
INSERT INTO ndv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yúhí biti ɓëyí ot fu ɓéeɓ ay ɗaanuu kíi. ");
INSERT INTO ndv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Miraa yii wunte, ndaa wa lahlilay cafka raa, wa ay nimiliruu cafkii wa ɗíh⁠ ⁠? Lah lëhí cafka ti miraa nen, te ɗon lah jaamma hanndal kon.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Filoon fi baaha, Yéesú kolohte daaha saañce deyi Yúdée a hatni yíníi laahi Yurdeŋ. Lahaꞌ ri ra, i ow caak aylute ɗii na, ɗi yampe na yëedíɗ wë ti di na pagaꞌ ri merees nen. ");
INSERT INTO ndv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lahte fariseŋŋi ayute na saamu olsohi, meelute ri nda ow waɗtee mín yes ɓeleɓi raa. ");
INSERT INTO ndv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mëyíis won ɗon yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Mëyíis won biti ow mín yes ɓeleɓi biti ri saam kéedí mín teeɓaꞌ biti ɗi yesse kooda.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yéesú won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Súhí ɗon keeñ daa tah Mëyíis bíníyíɗ ɗon yii bah. ");
INSERT INTO ndv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ndaa, bíníyúté Téerëe biti dalaani ëldúnë, Koope “sak ow ƴaal a ow ɓeleɓ⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","yii baa daa tah ow ƴaal ay ɓísëh a boffi a yaafi, pokoh ɓeleɓi na, ");
INSERT INTO ndv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","wa hen yínë.” Ɗaaha, wa henluy ana, wa tasu yínë. ");
INSERT INTO ndv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kon iñi Koo daa boollaꞌ wa, ow ɓanan waa ɗaralsaꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lahuu wa faam ra, taalibe ya meelute Yéesú yii leŋke yii baaha. ");
INSERT INTO ndv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ƴaali yes ɓeleɓi, kooɗ ɓeleɓ kay, njaaliyohte. ");
INSERT INTO ndv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te ɓelii yes ƴaali, kooroh a ƴaal kay, njaaliyohte ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Filoon fi baaha, lahte ɓëewí homu komi Yéesú i kúkëy, fahuu biti ɗi tík yaꞌ yi sun fi wa barkel wa, ndaa taalibe ya na wonu affi wa. ");
INSERT INTO ndv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Olaꞌ Yéesú yii baaha, keeña haayte, ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Yéɗɗí tuŋka ac soo na, ngënë këddíi wë⁠ ⁠! Yúhí biti Nguur ki Koope saamɗu mani wa. ");
INSERT INTO ndv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí habaay Koope buur ti ɗee habaꞌ kúkëy Koope ra nen, ii hëelíɗ Nguur ki.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yéesú antee ɓeɓ tuŋka, tíkké yaꞌ yi sun fi wa barkelte wa. ");
INSERT INTO ndv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yéesú hom saaña, lahte ɓëyí acce a múkë, ƴekke fíyí, meelte ri won tih⁠ ⁠: «⁠ ⁠Yëeddëhí baahi beh, mi waɗti paga yi níi mi lah pesa na ɗúméh rë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu dëekëꞌ sëꞌ baah a⁠ ⁠? Yi daa baah⁠ ⁠? Henay Koope, lahay ɓëyí baahte. ");
INSERT INTO ndv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fu yúh iña túuƴëꞌ Koope ra maan⁠ ⁠? “Ngënë mësíi bëem ow⁠ ⁠; ngënë mësíi njaaliyoh⁠ ⁠; ngënë mësíi loh⁠ ⁠; ngënë mësíi feliɗ ow⁠ ⁠; ngënë mësíi nofaꞌ ow ɗon ɓeɓ iñi⁠ ⁠; lah tëeppítíi baappon a yaayyon.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɓëeꞌ won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, yii waɗ soꞌ iñƴaa ɓéeɓ mi ñee na kúkëy kí sëꞌ níi a ɗeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yéesú yeelaꞌte ri íllí wunte, antee ri won tih⁠ ⁠: «⁠ ⁠Fu tallaꞌ yin yínë⁠ ⁠: paye fu yaay iña lahaꞌ fu ra ɓéeɓ, fu woraꞌ cadum fa ñëkíɗɗë. Hen ɗaaha raa, fay lah alal sun-Koo. Fu woc raa, fu ac fu ñee tal soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ndaa kelaꞌ ɓëeꞌ unni ƴah, kanama ñúussé, ɗi kolohte na saañ. Bi caak ri alal níi caak, yaa misikke ri keeñi níi misik. ");
INSERT INTO ndv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yéesú yeelte taalibe yi, won wa tih⁠ ⁠: «⁠ ⁠Haal Nguur ki Koope kofeelte yíkëe yí alalla na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Unni ƴaa kúnté affi taalibe ya. Yéesú ɓeyaatte una won wa tih⁠ ⁠: «⁠ ⁠Haal Nguur ki Koope kofeelte këewé⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Géléem haal gúl kúuc, daa lukki yooɓ biti yíkëe alal haal Nguur ki Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Affi taalibe ya ɓaattee kúnëh, wa na meelantuu hanndal ki wa wonu tih⁠ ⁠: «⁠ ⁠Kon daa míntí múc⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yéesú yeelte wa, won tih⁠ ⁠: «⁠ ⁠Ow mínéh múcël afi, Koope kut daa mín ríi múcël, ndée lahay yii wooñ Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peer won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓahaa ole⁠ ⁠! Fun helute iña ɓéeɓ, fun ñeyute talu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí af soꞌ a Uni Neba tah ɗi hel faami, koy-yaayyi, yaafi, boffi, koyyi mbée feeyyi, ");
INSERT INTO ndv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ɗi ay lah bina-bina waa na ɓéeɓ tíméer (100) di pesee ke yen feey fi beh⁠ ⁠: faam, koy-yaay, yaay, baap, koy a feey, boollaꞌ biti ɗi ay moklu⁠ ⁠; te fayu, ɗi ay lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ow caak di ɓëewë këllúu woteh ra ay míllëꞌ fayu, te ow caak di ɓëewë míllúu woteh ra ay këllëh fayu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Filoon fi baaha, Yéesú këllëhté wë, wa na suu Yerusalem. Keeññi taalibe ya tookay, te ɓëewë ñéerúu a wa ra néekíñúuté. Yéesú dëekílté taalibe yi sabboo a ana ya, na teeɓ wa yee na saañ rii kate ra. ");
INSERT INTO ndv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Síkíríi⁠ ⁠! Yen ee suu Yerusalem ra ee, gina nay tíkúu soꞌ mi Koy-ɓëeꞌ yaꞌ yi kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis rë. Wa ay soo aattiyaꞌ húl, tík sëꞌ yaꞌ yi ɓëewë yëwúɗ neh ra. ");
INSERT INTO ndv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wa fi ƴaa ay soo ñaawal, tuulsaꞌ soꞌ, laɓisaꞌ soꞌ laraw, an soo hap húl. Te waali éeyë fë filoon fi húlí sëꞌ, may koloh ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Saak a Saŋ koyyi Sebede leɓuute Yéesú, wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun fahuu biti koon fu pagiɗ fun yee nay fun roo ɗage ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon fahuu biti mi pagira ron yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun ɗagu biti koon fu hom ndamu fayu raa, fu on fun fun took hëbísú⁠ ⁠: ɓëyí yínëe hom yaꞌi ñamaa fu, yínëe hom yaꞌi sugu fu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tígí daaha, Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon yíih yee ɗagu ɗon ra. Mbaa ɗon kaañute han gulii kofeel ka nay mii hane ra⁠ ⁠? Ɗon kaañute húus coono fa nay mii bëtsúu bëtsí henay bëtís a muluɓ ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun kaañute ri kay⁠ ⁠!⁠ ⁠» Ɗi tahaatte won wa tih⁠ ⁠: «⁠ ⁠Kaah biti ɗon ay han gulaa nay mii hane ra, ɗon ay húus coono fa nay mii bëtsúu rë. ");
INSERT INTO ndv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ndaa yii leŋke toogi yaꞌi ñamaa fi soꞌ mbée yaꞌi sugu fi soꞌ, daa mi na onaꞌ ri neh⁠ ⁠; ɓëewë Koope waaƴiɗ wa tíkkí ƴaa ra daa lahuu wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yúhúu taalibe yi sabboo ya tasu ra yii baaha ra, wa neeɓuute Saak a Saŋ. ");
INSERT INTO ndv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yéesú dëekké wë ɓéeɓ tígí daaha, won wa tih⁠ ⁠: «⁠ ⁠Ɗon yúhúté biti yíkëe yí ginna a ɓëewí gaanna hom ñaamluu ɓëewí kayya ñaamloo, noote wa⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ndaa yii baaha waray lahaꞌ ɗaaha hanndal kon. Ow di ɗon na fahaꞌ hen ow gaan raa kay, ɗi henan súrgíi ɓëewí kayya. ");
INSERT INTO ndv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te ɓëyí fahaꞌ hen kélfë ɗon na, ɗi henan ñaami ɓëewí kayya ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Soꞌ mi Koy-ɓëeꞌ sah, mi aay biti ɓëewë nay hene súrgë yí sëꞌ. Mi ac biti kay, daa mi nay hene súrgíi ɓëewë níi mi yeraꞌ ñíin sëꞌ tosaa pes ow caak.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lahuu Yéesú a taalibe yi Yéríkëe níi wa na ɗúhú gina ra, i ow caak ñeyute talli wa. Lahte búumndí hínú Bar-Tímé, húmú took ɓúk waala na saraatoh. Ɗi koy Tímé. ");
INSERT INTO ndv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kelaꞌ ri biti yaa Yéesú fí ɓëy Nasaret ra, ɗi foŋke won tih⁠ ⁠: «⁠ ⁠Yéesú, sédí Dawit, yérém sëꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ow caak na wonu afa, fahuu biti ɗi héddëh⁠ ⁠; ndaa ri lukki foŋ na na won tih⁠ ⁠: «⁠ ⁠Sédí Dawit, yérém sëꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tígí daaha, Yéesú caŋke, won tih⁠ ⁠: «⁠ ⁠Wëní rí ac.⁠ ⁠» Wa dëekúté rí wonu ri tih⁠ ⁠: «⁠ ⁠Namee héddëh fu koloh⁠ ⁠! Ɗi ee roo dëek rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Búumndë bette sabidoori, hente bërít kolohte, ɗeefiɗte ri. ");
INSERT INTO ndv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yéesú meelte ri won tih⁠ ⁠: «⁠ ⁠Fu fahaꞌ biti mi pagira ro yih⁠ ⁠?⁠ ⁠» Búumndë won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, page níi íllí sëꞌ wërsëh, mi mín ot⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu mín saañ, ngémú tahte fu wahte.⁠ ⁠» Íllë yíppée wërsëh, ɗi na ot. Ɗi ñeete tal Yéesú wa na suu. ");
INSERT INTO ndv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tílúu Yéesú a taalibe ya níi wa leɓuute Yerusalem, yeeddaꞌ ki Betfase a Betani, hëbís daŋi Ëlíiffë rë, Yéesú wolte ow ana waa na ");
INSERT INTO ndv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","won wa tih⁠ ⁠: «⁠ ⁠Pëyí gina fíi bín, ɗon haale na rek, ɗon ay naa ɗeef cúmbúr mbaam poku, bi ow yëegírëy rí. Lah pëkísí rí, ɗon kom soꞌ ri. ");
INSERT INTO ndv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ow meel ron yee tah ɗon na pëkísú rí rëe, lah wëní rí biti Yíkëe daa sohlaꞌ ri, te ɗi woc na raa, ɗi ay rii yíppí nimiliɗ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Taalibe ya koluu daaha suute. Lahuu wa ra, wa ɗeefute cúmbúr pokute íl faam di ɓúk waala⁠ ⁠; wa pëkísúté rí. ");
INSERT INTO ndv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","I ow di ɓëewë húmú daaha ra wonu wa tih⁠ ⁠: «⁠ ⁠Ɗon pagu yi ɓal⁠ ⁠? Yi tah ɗon na pëkísú cúmbúrë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Taalibe ya wonute wa yee nah wa Yéesú rë⁠ ⁠; ɗaaha, ɓëewë yeɗɗute wa suute. ");
INSERT INTO ndv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wa komute Yéesú cúmbúrë, larute sabidoorri wa sun, Yéesú yaagohte. ");
INSERT INTO ndv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","I ow caak anutee ɓeɓ sabidoorri wa larute waala, ƴee haalu luufa saamute i yaꞌ kilik hilsiɗ, larute waala ɓal. ");
INSERT INTO ndv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɓëewë ɓéeɓ, dalaꞌte ƴee paaꞌuu Yéesú fí a ƴee paaꞌuu ri filoon ra ɓéyrúté unni wa sun na njooɓu ri wonu tih⁠ ⁠: «⁠ ⁠Oosaanaa⁠ ⁠! Koo laha ndam⁠ ⁠! Koo-Yíkëe barkela ɓëeꞌ ɗi wol ri ra⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Koo barkela Nguur ka na ac ɗa⁠ ⁠! Koo barkela Nguur ki ciffi yen Dawit⁠ ⁠! Oosaanaa⁠ ⁠! Koo laha ndam di sunaa-sun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yéesú lahte Yerusalem, haalte Faam fi gaani Koope, kénsëhté filiɓ ɓéeɓ. Bi elkuu wa, ɓani taalibe yi sabboo a ana ya koluute suute Betani. ");
INSERT INTO ndv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na ɗúhú wë Betani kéy fín rë, yaaɓ hampe Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɗi séenté tal eeni kíffé, ɗi ɗalte kénsëhí nda ri lahte koy raa⁠ ⁠; ndaa lahaꞌ ri na ra, gét nëe saaf, ɗi olay na koy, ɗeef wahtu ɓeen een lahay doom. ");
INSERT INTO ndv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yéesú won eena tígí daaha tih⁠ ⁠: «⁠ ⁠Ow ɗamaayti ñamil koyyu faw⁠ ⁠!⁠ ⁠» Taalibe ya keluute yee won ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lahuu wa Yerusalem Yéesú haalte baylii Faam fi gaani Koope ra, ɗi yampe na lík yaayoh ya a lomoh ya homu na ra, júlkëñcé taabulli ɓëewë në lofrantuu hélíis rë a ñaanni yaayoh yi bëdú yë. ");
INSERT INTO ndv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɗi kaddaꞌte ow kúɗ yii tappe iñƴaaha daaha, di Faam fi gaani Koope. ");
INSERT INTO ndv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ɗi na yëedíɗ wë won tih⁠ ⁠: «⁠ ⁠Koo wonay Téerëe bitih⁠ ⁠: “Faam soꞌ ay wonuu faam fa na ɗaguu soꞌ heetta ɓéeɓ rë” ë⁠ ⁠? Ndaa ɗon yíssúté rí “faam lohoh”⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Keluu kélfë yí seeƴoh yi Faam fi gaani Koope a yëeddëh yí kootii Mëyíis iñƴaaha ra, wa na saamu ɗee nay wa rii hawee húl rë⁠ ⁠; ndaa wa kaañuy ri af biti dúukëlí ɓëewë éemúté iña na yëeddëꞌ rí rë. ");
INSERT INTO ndv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Fíníin fín, Yéesú a taalibe yi ɗúhúté gina. ");
INSERT INTO ndv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na suu wa kéy ɓaaɓ fin cúɓ rë, wa olute biti tal eena súhté níi lahte keeña. ");
INSERT INTO ndv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peer nérsëhté yee húmú lah ra, ɗi won Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa ole kan⁠ ⁠! Tal eena cuñ fu ra súhté kok.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Gémí Koope. ");
INSERT INTO ndv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí nah daŋi bee ɗofoh dee saañ yípée kísí, te ɗi laheh nuf ana na, ɗi gém biti yee won ɗi ra ay lah raa, ɗi ay ri rii pagiɗ. ");
INSERT INTO ndv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Daa tah mi won ɗon tee⁠ ⁠: yii ɗaŋ ɗon Koope ɓéeɓ, lah gémí biti ɗon liilute ri níi wocce⁠ ⁠; yii baaha ay lahee ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te ɗon koloh ɗaŋ Koope ɗeefa ɗon habrute ow yin keeññon raa, lah bëelí rí, nda Boffee ke ron sunaa-sun mín ron baal tooññon ɓal.  ");
INSERT INTO ndv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Lahaatu wa Yerusalem ra, Yéesú haalte filiɓ Faam fi gaani Koope na tílëesëh. Kélfë yí seeƴoh ya, yëeddëh yí kootii Mëyíis a ɓaha ya ɗeefrute ri, ");
INSERT INTO ndv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wonu ri tih⁠ ⁠: «⁠ ⁠Fu pagaꞌ iña na paŋ fu ra sañ-sañi bih⁠ ⁠? Daa nah ro paŋi wa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yéesú won wa tih⁠ ⁠: «⁠ ⁠May ron meele yin yínë kut. Ɗon tiil soꞌ na raa, may ron teeɓ ɓëeꞌ yeɗ soꞌ sañ-saña na pagaꞌ mi wa ra. ");
INSERT INTO ndv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bëtsë në húmú bëtís Saŋ ɓëewë rë, Koope daa húmú nah ri mbée ɓëewë⁠ ⁠? Tíilí sëꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tígí daaha, wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Yen won biti Koope daa nah ri raa, ɗi ay yen meel yee tah níi yen gémúy iña won Saŋ ra. ");
INSERT INTO ndv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te yen won biti ɓëewë daa nahu ri raa, yen ay oluu ɗíh⁠ ⁠?⁠ ⁠» (Wa kaañuy, ndée ɓëewë ɓéeɓ habuu Saŋ yonente kaah). ");
INSERT INTO ndv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wa wonu Yéesú tígí daaha tih⁠ ⁠: «⁠ ⁠Fun yíih yin na⁠ ⁠!⁠ ⁠» Ɗi nampee waa won tih⁠ ⁠: «⁠ ⁠Kon soꞌ ɓal, mii ron won ɓëeꞌ yeɗ soꞌ sañ-saña na pagaꞌ mi wa ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Filoon fe, Yéesú na goneel a wa ñeyaꞌte wa anil won wa tih⁠ ⁠: «⁠ ⁠Lahaꞌ ɓëyí húmú yíp meey reseñ, líikké rí, yugusse tígë nay pooƴuu reseña ra, saampe dút, ɗi antee rii yeraꞌ ndalu, saañce ɓaaɓ. ");
INSERT INTO ndv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nonaꞌ reseña ra, ɗi wolte súrgë línëh yë në, nda wa yeɗ ɗi wodi. ");
INSERT INTO ndv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ndaa lahaꞌ ri ra, línëh yë habute ri, laɓute ri laɓɓi misikke, anutee rii yeris ɗi nimilaꞌte yaꞌ holoŋ. ");
INSERT INTO ndv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yíkíi meeya wolaatte súrgë kay línëh yë në. Lahaꞌ ri ra, wa laɓute ri af, solute ri solli misikke. ");
INSERT INTO ndv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ɗi wolaatte súrgë kay. Lahaꞌ ɗi fi baa ra ɓal, línëh yë hawute ri húl. Ɗi wolte súrgë caak filoon fe. Lahluu wa fi ƴaa ra, línëh yë laɓute ƴee laɓɓi misikke, hawute ƴee húl. ");
INSERT INTO ndv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Koy ki ƴaala ɗi fahaꞌte ri níi fahaꞌ ra daa tas ɗii na. Ɗi wolte ɗi fi baa línëh yë në ɓal, na won nufi tih⁠ ⁠: “Man biti wa ay yeɗ koy soꞌ cér⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ndaa lahaꞌ koy ka ra, línëh yë wonu hanndal ki wa tih⁠ ⁠: “Lamoha abee kan⁠ ⁠! Ëyí yen hap ɗi húl, meeya hen bi yen.” ");
INSERT INTO ndv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wa yípútée ríi ham, hawute ri húl, betute ɓúudé fë énfí meeya.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tígí daaha, Yéesú won ɓëewë tih⁠ ⁠: «⁠ ⁠Yíkíi meeya ay míllée paŋ yih⁠ ⁠? Ɗi ay aye ayo, hap línëh yë ɓéeɓ húl, anti saam i línëh kay, yeɗ wa meeya. ");
INSERT INTO ndv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ɗon mësútée teeꞌaꞌ a unni ƴee Téerëe maan⁠ ⁠? “Laꞌa habuu taɓahoh ya biti lahay njiriñ ra daa míllëꞌ ham lasa. ");
INSERT INTO ndv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Koo-Yíkëe daa pagaꞌ ri ɗaaha te ri neɓpe yeel lool.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yúhúu kélfë yí yëwúɗɗë biti Yéesú yuliɗ anili baa sun fi wa ra, wa na saamu ɗee nay wa rii habee ra, ndaa bi kaañuy wa dúukëlí ɓëewë, wa heluu ri daaha, suute. ");
INSERT INTO ndv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","I fariseŋ a i ow di ɓëewí Erot woluute Yéesú në, nda wa mín ríi fíir di iña na won ri ra. ");
INSERT INTO ndv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wa ayute, wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun yúhúté biti fu wonaꞌ kaah, te fu neehay ow⁠ ⁠; fu na yeeleeh ow jëmmíi. Fu yëeddëꞌ yee nahaꞌ Koope ra kah-kah. Kon won fun nda kootii yen onaꞌte biti Sesaar yeru túm mbée onaay. Fun warutee yeraꞌ aa, fun waruy yeraꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bi yúh Yéesú biti wonni wa teem ɓúkkí wë, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon ay fíiré sëꞌ ë⁠ ⁠? Këmí sëꞌ hélíis hanjar dee mi ot.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wa komute ri hanjara, ɗi antee waa meel won tih⁠ ⁠: «⁠ ⁠Netli wah a tii wah daa na⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Ƴi Sesaar.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Kon yérí Sesaar yee lahaꞌ ri ra, ɗon yeɗ Koope yee lahaꞌ ri ra⁠ ⁠!⁠ ⁠» Wa éemúté wona níi éem. ");
INSERT INTO ndv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","I saduseŋ, wa fa wonu biti koloh ɓúudé lahay ra ayute Yéesú në ɓal, wonu ri tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«⁠ ⁠Ɓahaa, Mëyíis húmú túuƴcé yen bitih, ɓëyí húl hel ɓeleɓ te ɗeef ɓani ɓelaa liiluyti lah koy, ñéedë waɗtee lam ɓelaa, saamiɗ ɓahii tal. ");
INSERT INTO ndv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Te kíilë, húmú lahte koy-yaay paana⁠ ⁠: bee ɓaha waa na ra kooɗte, ɓani ɓelaa liiluyti lah koy, ɗi húlté. ");
INSERT INTO ndv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bee ñee na ra kooɗte ɓelaa, wa lahuy koy, baa húlté. Ɓëyí éeyë fë ñeyilte kotta, húlté. ");
INSERT INTO ndv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na hen ɗaaha níi wa fi paana ya ɓéeɓ, ñeyute kooda, húlúté te ow lahay na koy. Filoon fe, ɗi fi ɓelaa tahte ɓal húlté. ");
INSERT INTO ndv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kon leegi, yiin nay kolee ɓëewë ɓúudé rë, daa nay lahee ɓelaa waa na te wa ɓéeɓ koorute ri⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Biti ɗon yíih yee won Téerëe rë, a ɗee lahaꞌ Koope doole ra, daa tah ɗon héllëꞌ neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yiin nay kolee ɓëewë ɓúudé rë, ƴaal a ɓeleɓ ii koorantaꞌ⁠ ⁠; pesi wa kay, ay madee a pesi malaaka ya sun-Koo nen. ");
INSERT INTO ndv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Te yii leŋke kolohi ɓëewë húlú rë ɓúudé, ɗon yíih yee bíní Mëyíis filiɓ téerëe rë ë⁠ ⁠? Koope wonte filiɓ dúufë na njaaroh ra biti daa ri Koope fi Abraham, Koope fi Isaak, Koope fi Yakop.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Kon Koope, ɗi Koope fi ɓëewë húlú rë neh, ɗi Koope fi ɓëewë na pesu ra. Ɗon héllúuté héllëꞌí misikke.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ow di yëeddëh yí kootii Mëyíis kelohte gonli wa, te ɗi otte biti Yéesú wonte unni lante na lof ɗi saduseŋŋa ra. Ɗi yíppée ríi leɓoh won ri tih⁠ ⁠: «⁠ ⁠Túuƴëꞌí bi daa lukki lah solo di túuƴëꞌ yë në ɓéeɓ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Túuƴëꞌë lukki lah solo ra daa ri beh⁠ ⁠: “Síkíríi ɗon fi Israyel⁠ ⁠! Koope daa Yíkíi yen, te ɗi kut daa Yíkëe⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","kon lah fëhíi Koo-Yíkëe di keeññon ɓéeɓ, di peson ɓéeɓ, di nuffon ɓéeɓ a dooloon ɓéeɓ.” ");
INSERT INTO ndv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Túuƴëꞌë ñee na ra daa ri beh⁠ ⁠: “Di fahuu ron affon, lah fëhíi moroommon ɗaaha.” Lahay túuƴëꞌ kay bi luk ƴaa lah solo.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ɓëeꞌ won Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, baa kaah⁠ ⁠! Yee won fu ra lahte. Yíkëe yínë kut, te henay ri lahay Koo kay. ");
INSERT INTO ndv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ow ɓéeɓ waɗtee rii fahaꞌ keeñi ɓéeɓ, di nufi ɓéeɓ, a doolii ɓéeɓ⁠ ⁠; te ri waɗtee fahaꞌ moroomi ti ɗee fahaꞌ ri afi ra nen. Ƴaa daa gén hawiɗɗa na tamru ɓëewë Koope ra ɓéeɓ níi sooy ra, a sarah ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Olaꞌ Yéesú biti ɓëeꞌ ñaañce ɗee wonaꞌ ri ra, ɗi won ri tih⁠ ⁠: «⁠ ⁠Fu wulaay Nguur ki Koope.⁠ ⁠» Kolaꞌte bah, ow kaañlay rii meelil yin kay. ");
INSERT INTO ndv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yéesú hompe filiɓ Faam fi gaani Koope na yëeddëꞌ, meelte ɓëewë won wa tih⁠ ⁠: «⁠ ⁠Yëeddëh yí kootii Mëyíis mínúu won biti Buura Koo fal ri ra sédí Dawit ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Te ɗi fi Dawit, húmú haalaꞌ ri Ruuh-Peseŋ ra, ɗi won tih⁠ ⁠: “Koo-Yíkëe won Yíkíi sëꞌ tih⁠ ⁠: tooke hëbís sëꞌ, yaꞌi ñamaa fi soꞌ deh, níi bín nëy míi kéenɗée kaaꞌoh yu kottu feey ra.” ");
INSERT INTO ndv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«⁠ ⁠Ɗi fi Dawit dëekëꞌ rí Yíkëe rëe, kon Buura Koo fal ri ra mínëꞌ hen sédí ɗíh⁠ ⁠?⁠ ⁠» Woni neɓaꞌte dúukëlí ɓëewë në síkírúu rí rë. ");
INSERT INTO ndv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Filiɓ yëeddëꞌí Yéesú, ɗi won ɓëewë tih⁠ ⁠: «⁠ ⁠Lah mëytíi yëeddëh yí Kootaa, wa fa tílëesúu a búuɓ gaan ra, te wa fahuu biti wa woduun a yaꞌ ana këemmë rë. ");
INSERT INTO ndv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wa tookuu ñaanna këllëh di ílíƴƴë na ɗaguu yëwúɗɗë Koope ra, te daa wa na ɗéɓúu ñam biti ndaje lah. ");
INSERT INTO ndv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Daa wa lukuu maañ ɗaŋ ndah teeɓaꞌi affi wa, te añcaŋ daa wa na ɓeyu alalli ɓeleɓɓa ƴaalli wa húlú rë. Daani wa nay lukee misik.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yéesú antee took, jaanndohte ifi saraha Faam fi gaani Koope, na olsoh ɗee na ɓekuu ɓëewë hélíis filiɓ ra. Caakke yíkëe alalli ɓekute na hélíis wun-wun. ");
INSERT INTO ndv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɓelii ƴaala húlté, ñakke níi ñak acce, ɓekke hanjar ƴutuuɗ ana, ƴi taaɓeh yin. ");
INSERT INTO ndv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yéesú dëekké taalibe yi tígí daaha, won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee bitih⁠ ⁠: saraha yeraꞌ ñëkídí bee lahay ƴaal bee ra, luk ƴi ɓëewí kayya ɓéeɓ lah solo. ");
INSERT INTO ndv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ɓëewí kayya ɓéeɓ yeruu ƴee lukus alal mi wa ra, ndaa di filiɓ ñagi, ɓelaa yeraꞌ iña lahaꞌ ri ra ɓéeɓ, ƴee waɗ rii pesaa koon ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ɗúhëꞌ Yéesú Faam fi gaani Koope ra, ow di taalibe yi olsohte taah ya baylaa, won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, olsee ɗee gaanaꞌ laꞌ ya a ɗee wunaꞌ taah ya ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu otte ɗee gaanaꞌ taah yi ƴee ra ɓéeɓ ë⁠ ⁠? Bis ay lah, wa ɓéeɓ ay bëp níi laꞌ ii tíkëh sun laꞌ. Daa mi won ɗo ri⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tílúu wë níi wa lahute daŋi Ëlíiffë rë, Yéesú tookke, yíssëhté Faam fi gaani Koope. Peer, Saak, Saŋ a Anndere ɗeefrute ri daaha, meelute ri wonu tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«⁠ ⁠Won fun wahtaa nay lahe yii baa ra, a yee nay teeɓee biti yii baa ee saañ lahe ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tígí daaha, Yéesú yampe na won wa tih⁠ ⁠: «⁠ ⁠Mëytíi⁠ ⁠! Ow ɓanay ron nofaꞌ. ");
INSERT INTO ndv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ow caak ay ayaꞌ tii soꞌ, won biti daa wa Buura Koo fal ri ra, te wa ay nofaꞌ ow caak. ");
INSERT INTO ndv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ɗon keloh yodaɗ haaꞌ yi leɓohte, a ban fi haaꞌ yi wulohte raa, ngënë tíití, iñƴaa waɗti laha laho, ndaa ɗeefa túkkíi ëldúnë laheh doom. ");
INSERT INTO ndv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gin ay yejoh gin haaꞌ, nguur haaꞌ a nguur⁠ ⁠; ay lah ílíƴƴí feey fa ay naa hégíƴëh, yaaɓ haal i ílíƴ feey fa. Ƴaa ɓéeɓ ay madee a misiga na kat ɓeleɓ biti lowa ham ra nen. ");
INSERT INTO ndv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«⁠ ⁠Ɗon fi ƴaa nék, lah héní wun affon, ndée af soꞌ ay tah ɗon tëekrú këem filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra, ɗon laɓu laraw. Ɗon ay cëgírú fíi i gëernëer a fíi i buur ɗon seede yee yúhú ɗon soo na ra fíi wë. ");
INSERT INTO ndv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Uni Neba waɗtee waariyu heetta ɓéeɓ paaƴ balaa túkkíi ëldúnë. ");
INSERT INTO ndv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Te ɗon habu níi ɗon kúrú këem rëe, ngënë sídíi⁠ ⁠: yee nay ron layee wahtii baaha teme ra ii kolaꞌ ɗon a, ay kolee Ruuh-Peseŋ na. ");
INSERT INTO ndv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bín fë, ow ay yaay koy-yaafi hawroh ri húl, baap a koohi ɗaaha ɓal, tuŋka ay koloh sun fi baappi wa a yaayyi wa, hawroh wa húl. ");
INSERT INTO ndv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Af soꞌ ay tah ɓëewë ɓéeɓ kaaꞌ ɗon, ndaa ɓëyí ham híin níi ɗúmëenë rëe, ay múc. ");
INSERT INTO ndv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«⁠ ⁠Tíl níi ɗon ot yii ɓosa na sobeyil ra hom tígí ɗi waray naa hom raa, tígí daaha, ɓëewë nay home Yúdée rë heguun daŋŋin (ɓëyí jaŋi yii bee yúhën⁠ ⁠!) ");
INSERT INTO ndv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɓëyí ɗúh këem, ɓanan haal kali yin faam⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","te ɓëyí liilti saañ meey, ɓanan nimil kali búuɓ faam. ");
INSERT INTO ndv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mas ɓeleɓɓa nay poke loo bín fë rë a ƴee nay ɓëpíré rë⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ɗëgí Koope iñƴaaha ɓanti teeꞌaꞌ a líƴ. ");
INSERT INTO ndv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mee ron won kaaf ka ra ee biti jamanii baaha ay misik misigi lëhírëy sakaꞌ Koo ëldúnë níi a ɗeh, te mani ii lëhíɗ faw. ");
INSERT INTO ndv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te Koo-Yíkëe cagay ëylí bissi ƴaaha koon, tin ow ii múc bín fë⁠ ⁠; ndaa ɓëewë ɗi tanis wa ra, daa tah ɗi ëyíl wë. ");
INSERT INTO ndv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ɓëyí won ɗon tígí daaha biti “Buura Koo fal ri ra abeh”, mbée “ɗi abín” ɓéeɓ, ngënë gémí rí. ");
INSERT INTO ndv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","I kiristaa a i yonente paɗɗah ay ac paŋ i kimtaan a iñi éemílëꞌté, fahaꞌi biti koon wa nofaꞌ sah ɓëewë Koo tanis wa ra. ");
INSERT INTO ndv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mi wonte ɗon iña ɓéeɓ abah⁠ ⁠! Kon lah hélí nuf na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Filoon fi loola bín fë rëe, naꞌa a céyín fë ay ƴím, ");
INSERT INTO ndv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","hulla ɓal hélkísëh keen, doole ya sun ɓéeɓ bëlkísëh. ");
INSERT INTO ndv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«⁠ ⁠Tígí daaha, ɓëewë ay ot soꞌ mi Koy-ɓëeꞌ mi aye filiɓ nérrë, mi ñéerëꞌ a doolii gaante a ndam. ");
INSERT INTO ndv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","May wol malaaka yi soꞌ wër feey fa ɓéeɓ négírëꞌí ɓëewë tansu ra, dalaani feey fa níi lúsëenín.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Hëbí yee tíinndúu tal karaɗ ra affon⁠ ⁠: ɗon ot tal karaɗ capuse rek, ɗon yúh biti lee ri lah koy. ");
INSERT INTO ndv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ti ɗaaha nen, ɗon ot iñƴaaha lahe raa, lah yúhí biti nimili soꞌ mi Koy-ɓëeꞌ leɓohte níi leɓoh. ");
INSERT INTO ndv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mee ron won kaaf ka ra ee biti ɓëy jamanii bee ii múk te iñƴaaha ɓéeɓ laheh. ");
INSERT INTO ndv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Sun a feey ay múk, ndaa unni soꞌ ii mëssí múk. ");
INSERT INTO ndv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«⁠ ⁠Yii leŋke bisa a wahtaa nay mii nimile ra, ow yéeh yin na⁠ ⁠: malaaka ya sun neh, soꞌ mi Koy ka sah mi yéeh yin na⁠ ⁠; Boffa kut daa yúh. ");
INSERT INTO ndv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Këlíi affon ɗon hel nuf na, ndée ɗon yíih wahtaa⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ɗi mín mëllúu a biti ow koloh saañ ɓaaɓ⁠ ⁠: ɗi ƴahti saañ raa, ɗi hel faam fa yaꞌ yi súrgë yí, ɓëyí në ɓéeɓ a yee nay rii page ra, anti nah wohoha caŋ afi. ");
INSERT INTO ndv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kon këlíi affon⁠ ⁠! Ɗon yíih wahtaa nay nimile yíkíi faam fa ra⁠ ⁠: mín aya fíníin, mbée leelu elek, mbée hagaɗ, mbée ɓaaɓ. ");
INSERT INTO ndv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mëytíi ayi beetti ron, te ɗeefa ɗon neeꞌe. ");
INSERT INTO ndv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yee won mi ron bee ra, mi woniɗ ɗi ɓëewë ɓéeɓ⁠ ⁠: Cëgí affon⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Waal ana balaa Paagi yëwúɗɗë a feedi mbúurú njeñe ya, kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis na saamu nufa nay waa tíkée Yéesú yaꞌ ndaŋ feey, wa hap ri húl rë. ");
INSERT INTO ndv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wa wonantuute biti ɓanay hen filiɓ feeda, toñeh ɓëy gina ay kolee sun fi wa. ");
INSERT INTO ndv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yéesú húmú Betani faam Simoŋ fa mëssée guuñ ɗa, tookke na ñam. Lahte ɓelii haalte kúɗté bútlí yotuu laꞌa na wonuu albataar ra, líiffé a laakkoloñ naarde kah-kah. Ɓelaa konte un bútlë, yíinté laakkoloña af Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lahte ɓëewí húmú në yaa neɓaay wa, na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Yahi laakkoloñi ƴee lahaꞌ njiriñ mi bih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wa yaayeeh hélíis caak koon cadum fa yeru ñëkíɗɗë ë⁠ ⁠?⁠ ⁠» Wa yabute na wonu af ɓelaa woni misikke. ");
INSERT INTO ndv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ndaa Yéesú won wa tih⁠ ⁠: «⁠ ⁠Bëelí jaambura afi⁠ ⁠! Ɗon moklu ri yi ɗeeha⁠ ⁠? Yee pagiɗ soꞌ ri bee ra, yii wunte⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ñëkíɗ ii koloh filiɓ fon, ɗon mínú wëe pagiɗ wahtii neɓaꞌ ron⁠ ⁠; ndaa soꞌ mi bee mii hom filiɓ fon dee faraah. ");
INSERT INTO ndv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɓelaa paŋ yee mín ɗí rë⁠ ⁠; ɗi túm sëꞌ laakkoloñ waaƴɗi hacadi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mee ron won kaaf ka ra ee⁠ ⁠: tígí waariyuun Uni Neba ëldúnë ɓéeɓ, yee paŋ ɓelii bee ra ay naa ɓíllú, nuffi ɓëewë pay ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Filoon fi baaha, Yudaas Iskariyot, ow di taalibe yi sabboo a ana ya caŋke yaayi Yéesú. Ɗi payte kélfë yí seeƴoh ya na, wonte wa baaha. ");
INSERT INTO ndv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Keluu wa woni ra, keeññi wa sosse níi sos, wa gapute ri hélíis. Yudaas na anti saam wahtaa nay rii ɗamaalee Yéesú níi ɗi yaay ri wa ra. ");
INSERT INTO ndv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bisa ɗéɓ bissi feedi mbúurú njeñe ya te daa bisa na hawuu har fi Paaga ra, taalibe ya meelute Yéesú wonu tih⁠ ⁠: «⁠ ⁠Fu fahaꞌ biti fun waaƴɗun ɗo reeri Paaga tígí dih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ɗi wolte ow ana di taalibe yi won wa tih⁠ ⁠: «⁠ ⁠Pëyí filiɓ ginin, ɗon ay teeꞌaꞌ a ow ƴaal kúɗ pen muluɓ. Lah ñéyí tala ");
INSERT INTO ndv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","níi tígë nay rii haale ra. Ɗon lah na raa, wëní yíkíi faam fa tih⁠ ⁠: “Yëeddëhë daa nah fun meel ro lasa nay ñamee ɓani taalibe yi reeri Paaga ra.” ");
INSERT INTO ndv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hen ɗaaha raa, ɗi ay ron teeɓ lasi gaani paaꞌ sun, bi yugusute níi wocce⁠ ⁠: yii nay yen sohlee ɓéeɓ ín në. Ɗon ay waaƴee reeri Paaga daaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Taalibe ya koluu daaha suute ginin⁠ ⁠; wa ɗeefute iña ɓéeɓ ti ɗee húmú wonaꞌ wa Yéesú rë nen. Ɗaaha, wa waaƴute reeri Paaga. ");
INSERT INTO ndv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Fíníin fín, Yéesú a taalibe yi sabboo a ana ya ayute faam fa. ");
INSERT INTO ndv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Homuu wa reera ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ow di ɗon na, bi na reer a soꞌ ee, ay soo yaay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wona ɗúmëlté keeññi taalibe yi, wa na meelu Yéesú yínë-yínë wonu ri tih⁠ ⁠: «⁠ ⁠Mbaa ri soꞌ neh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗi ow di ɗon fi sabboo a ana ya, bi na soop mbúuríi a soꞌ filiɓ loona yínë. ");
INSERT INTO ndv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kaah biti soꞌ mi Koy-ɓëeꞌ mi waɗtee húl ti di bíníyúu rí sun fi soꞌ Téerëe nen⁠ ⁠; ndaa mas ɓëeꞌ nay soo yaaye ra⁠ ⁠! Biti ri límíh koon daa gén ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wa homu ñama, Yéesú ɓeɓpe mbúurú, símpé Koope, lecsaꞌte ri, yeɗte taalibe yi, won wa tih⁠ ⁠: «⁠ ⁠Ɓéyí, mbúuríi bee faan soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Filoon fi baaha, ɗi ɓeɓpe kaas béeñ, símpé Koope, yeɗte taalibe yi, wa ɓéeɓ hanute na. ");
INSERT INTO ndv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ɗi antee waa won tih⁠ ⁠: «⁠ ⁠Ƴee ñif mi soꞌ, ñif ma pokalsaꞌ Koope a ɓëewë rë. Wa ay keen ndah ow caak. ");
INSERT INTO ndv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mee ron won kaaf ka ra ee⁠ ⁠: mii hanil béeñ níi yiin nay mii hane béeñ has Nguur ki Koope ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Filoon fi baaha wa haalute ƴeekaa yi kañaa ya. Wocuu wa ra, wa koluute na suu daŋi Ëlíiffë. ");
INSERT INTO ndv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yéesú won taalibe yi tígí daaha tih⁠ ⁠: «⁠ ⁠Ɗon ɓéeɓ, ɗon ay sélít ti di bíníyúu rí Téerëe bitih⁠ ⁠: “May hap níirëhë húl, te harra ɓéeɓ ay haslaꞌ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ɗi ɓaatte won tih⁠ ⁠: «⁠ ⁠Di wonaꞌ ri Téerëe daaha kaah. Te filoon fi hawi soꞌ húl, may këllú ɓúudé, mi këllëh rën Galile.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peer won ɗi tih⁠ ⁠: «⁠ ⁠Wuti ɓëewí kayya ɓéeɓ sélít rëe, mii naa non.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Mee roo won kaaf ka ra ee⁠ ⁠: elgee woteh beh, fiisiin ki paan waal ana, fay taasaꞌ biti fu yúh sëꞌ níi hen waal éeyë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peer ɓaattee ham híin won tih⁠ ⁠: «⁠ ⁠Calalte soꞌ biti mi hawu húl a ɗo, ndaa mii mëssí taasaꞌ biti mi yúh rë.⁠ ⁠» Wa fi taalibe yi kayya ɓéeɓ ɓal ñeyute una na wonu yaa yínë. ");
INSERT INTO ndv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tílúu Yéesú a taalibe yi níi wa lahute tígë në wonuu Setsemani ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Hëmí deh, mi pay ɗaŋ Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na saañ ɗi ra, ɗi kúrëelëhté Peer, Saak a Saŋ. Ɗi dalte néekíñëꞌ, keeña ɗúmpé ces. ");
INSERT INTO ndv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Keeñ soꞌ ɗúm ɗúmë níi mí mínléh⁠ ⁠; hëmí deh, te ɗon yeele⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ɗi antee hécëh ƴutuuɗ, yeɗɗohte líhëhté feey, na ɗaŋ biti mín hen raa, yii misiga nay rii kate wahtii baaha ra wuloh ri, ");
INSERT INTO ndv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","na won tih⁠ ⁠: «⁠ ⁠Baap, ɗo fa mín ɓéeɓ rë, éccíré gulii coono fi bee wuloh soꞌ⁠ ⁠! Ndaa di mín ɗíi man ɓéeɓ, yee nay lahe ra ɓanan hen yee fahaꞌ mi ra, ndaa bee fahaꞌ fu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kolaꞌ ri dah, ɗi nimilte taalibe yi éeyë yë në, ɗeeffe wa na neeꞌu. Ɗi won Peer tih⁠ ⁠: «⁠ ⁠Simoŋ, fu neeꞌ neeꞌoo⁠ ⁠? Fu mínéh yeel wuti ƴaha wahtu yínë kut a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yéelí ɗon ɗaŋ, toñeh ɗon ay keene fíirí Seytaane. Ow na fahaꞌ paŋ yin wun, ndaa ri mitay⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ɗi hécíilté na ɗaŋ, ñeyaatte unna ɗéɓ ɗë. ");
INSERT INTO ndv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wocaꞌ ri ra, ɗi nimilaatte taalibe yi na, ɗeefaatte wa na neeꞌu, bi luk wa pëní fë doole. Wa lahuy yii wonun wa ri. ");
INSERT INTO ndv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nimilaꞌ ri waali éeyë fë rë, ɗi ɗeefaat wa na neeꞌlu, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon daa na neeꞌlu ɗee ɗon na hílsúu ë⁠ ⁠? Ɗúmpé⁠ ⁠! Wahtaa lahte. Ëlí⁠ ⁠! Soꞌ mi Koy-ɓëeꞌ may yaayu mi tíkú yaꞌ yi bakaaroh ya. ");
INSERT INTO ndv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Këlíi yen saañ⁠ ⁠! Ëlsíi, ɓëeꞌ yaay soꞌ ra ee ac ɗa ee.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yéesú hom wona, Yudaas ow di taalibe yi sabboo a ana ya yíppée ac, ñéerëꞌté a dúukël ow, ƴi kúrú jépíl a duuɗ. Kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis a ɓaha ya gina daa wolu wa. ");
INSERT INTO ndv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ɗeef Yudaas fa nay rii yaaye ra, teeɓpe wa yee nay rii page ra níi wa yúhsëꞌ rí rë. Ɗi húmú won wa tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ nay mii fëené rë, ɗi baaha⁠ ⁠; lah hëbí rí te ɗon hof biti ɗon ƴah rii kúɗ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Lahaꞌ ri ra, ɗi júɓ sun fi Yéesú ciɗ won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa⁠ ⁠!⁠ ⁠» Ɗi fëenté rí. ");
INSERT INTO ndv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɓëewë yípútée yejoh sun fi Yéesú, habute ri. ");
INSERT INTO ndv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ow di ɓëewë húmú në rë fúulté jépílí, paaŋke rí súrgíi seeƴohi gaana, lecce nufa. ");
INSERT INTO ndv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yéesú won ɓëewë tih⁠ ⁠: «⁠ ⁠Ɗon ayuu yi ɗeeha a jépíl a i duuɗ hami soꞌ man mi banndi nen⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mi húmú homaꞌ filiɓ fon faraah mi yëeddée filiɓ Faam fi gaani Koope te ɗon habuy soꞌ⁠ ⁠! Ndaa yii bee waɗti lahaa ɗeeha, nda yee bíníyú Téerëe rë lah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tígí daaha, taalibe yi ɓéeɓ heguute, helute ri. ");
INSERT INTO ndv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Lahte kúkëyí wahambaanii húmú ñeete tal Yéesú ɓal. Ɗi húmú lamboh úuf. Ndaa ɓëewë na yuluu hami, ");
INSERT INTO ndv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ɗi helte úufë yaꞌ yi wa, hegohte a faan holoŋ. ");
INSERT INTO ndv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓëewë kúrúté Yéesú faam seeƴohi gaana, tígë teeꞌuu kélfë yí seeƴoh ya, a ɓaha yi yëwúɗɗë a yëeddëh yí kootii Mëyíis rë. ");
INSERT INTO ndv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peer hompe filoon wulohte, ñeete tal Yéesú. Ɗi haalte baylii faam seeƴohi gaana, tookke a wohoh ya na yoonndoh. ");
INSERT INTO ndv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kélfë yí seeƴoh ya a ɓëy këemí gaani yëwúɗɗë ɓéeɓ saamute yii yabun wa Yéesú níi mín tah ɗi hawu húl, ndaa wa oluy. ");
INSERT INTO ndv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ow caak yabute ri iñi lahay, te wonna ñéerëey. ");
INSERT INTO ndv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lahte ɓëewí míllúutée koloh, yabute ri yii lahay wonu tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«⁠ ⁠Fun keluute ɗi wonte biti ɗi ay poo Faam fi gaani Koope bee yaꞌ ow taɓah ri ra, te filiɓ waal éeyë ɗi ay taɓahaat kay, bi yaꞌ ow ii naa leɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ndaa yii leŋke yii baa sah, wonni wa ñéerëey. ");
INSERT INTO ndv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tígí daaha, seeƴohi gaana kolohte caŋke leelii ɓëewë meelte Yéesú won ri tih⁠ ⁠: «⁠ ⁠Fu lahay yii lofa fu di yee yabu ro ɓëewí ƴee ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ndaa Yéesú hente tiɗ héddëhté. Seeƴohi gaana meelilte ri, won tih⁠ ⁠: «⁠ ⁠Daa fu Buura Koo fal ri ra, Koy Koope fa na kañu ɓëewë rë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yéesú won tih⁠ ⁠: «⁠ ⁠Daa mi⁠ ⁠! Te ɗon ay ot soꞌ mi Koy-ɓëeꞌ, mi took hëbís Koope fa mín ɓéeɓ rë, mi hom yaꞌi ñamaa fi, te ɗon ay ot mi aye filiɓ nérrë sun.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Seeƴohi gaana ɗaɗte búubí tígí daaha, won tih⁠ ⁠: «⁠ ⁠Yen ay pagilee seede yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ɗon keluute ɗee solaꞌ ri Koope ra. Ɗon wonu yi na⁠ ⁠?⁠ ⁠» Ɓëewë ɓéeɓ wonu tih⁠ ⁠: «⁠ ⁠Ɗi waɗti húlë húlë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lahte ɓëewí na tuulu sun fi, pokute íllë, na maagu ri kít anutee rii won tih⁠ ⁠: «⁠ ⁠Fu yonente saa ɓal⁠ ⁠? Wone ɓëeꞌ laɓ ɗo ra⁠ ⁠!⁠ ⁠» Wohoh ya ɓal na namuu rii fúuɗ mbeƴ. ");
INSERT INTO ndv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wahtii baaha ɗeef Peer húmú baylaa feey. Ow di ɓeleɓɓa na légéyú faam seeƴohi gaana ra ñeete daaha, ");
INSERT INTO ndv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","otte ri na yoonndoh, ɗi ƴíiɗté rí níi antee rii won tih⁠ ⁠: «⁠ ⁠Ɗo fi bee ɓal, ɗoni Yéesú fee ke ɓëy Nasaret bee daa na húmú ñéerúu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ɗi taasaꞌte won tih⁠ ⁠: «⁠ ⁠Mi keleeh wonu, mi yéeh yee na fahaꞌ fu won ra.⁠ ⁠» Ɗi antee koloh baylaa daaha, saañce ílí këemín. Tígí daaha, paan fiisohte. ");
INSERT INTO ndv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɓelaa olilte ri daaha, ñeyaatte una wonte fíi ɓëewë húmú në rë tih⁠ ⁠: «⁠ ⁠Ɓëyí bee non wa fi ƴaaha na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peer taasiilte. Tíkëh ƴutuuɗ, ɓëewë húmú hatni baaha ra wonu ri tih⁠ ⁠: «⁠ ⁠Lahte íl ɓal⁠ ⁠! Fu non wa fi ƴaaha na⁠ ⁠! Miteh taasaꞌ, ndah ɗo ɓal, fu ɓëy Galile.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peer hampe yee ham ɗi ra rek, añohte won tih⁠ ⁠: «⁠ ⁠Mi fel raa, yii kat soꞌ ɗi baaha⁠ ⁠! Mi yéeh ɓëeꞌ na wonuu ɗon soꞌ ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Una na lús, paan na fiisoh waali ana fa, ɗi yíppée nérsëh yee húmú won ri Yéesú rë biti fiisiin ki paan waal ana, ɗi ay taasaꞌ biti ɗi yúh rí níi hen waal éeyë. Ɗi yíppé afi tígí daaha na looy. ");
INSERT INTO ndv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yíilëꞌ Koo ɓaabin cúɓ, kélfë yí seeƴoh ya tookute a ɓaha yi yëwúɗɗë ɓéeɓ a yëeddëh yí kootii Mëyíis, ɓëy këemí gaani yëwúɗɗë ɓéeɓ daal tookute. Wa pokiruute Yéesú komute ri Pilaat. ");
INSERT INTO ndv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaat meelte Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Daa fu buuri yëwúɗɗë ë⁠ ⁠?⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu wonte ri, daa mi⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kélfë yí seeƴoh ya na yabu Yéesú yin caak daaha. ");
INSERT INTO ndv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaat meelilte ri won tih⁠ ⁠: «⁠ ⁠Fu mínéh lof a⁠ ⁠? Fu keleeh iña na yabu ro ɓëewí ƴee ra ɓéeɓ ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ndaa Yéesú wonlilay yin⁠ ⁠; yii baaha kúnté af Pilaat. ");
INSERT INTO ndv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lahaa Paak ɓéeɓ, Pilaat ɗúhíɗ ow kasaa, bee fahuu ɓëy gina biti daa ri yeɗɗun ra. ");
INSERT INTO ndv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ɗeef lahte ɓëyí hínú Barabaas téƴúté kasaa a ɓëewí ɓani wa húmú haaꞌuute nguur ka níi ow húlté. ");
INSERT INTO ndv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tígí daaha, dúukël ow ɗeefiɗte Pilaat faam, meelte ri yee ɓaahaꞌ ri pagidi wa ra. ");
INSERT INTO ndv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilaat won wa tih⁠ ⁠: «⁠ ⁠Ɗon fahuute biti mi yessiɗ ɗon buuri yëwúɗɗë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ɗi fi Pilaat yúhté biti nagajek kélfë yí seeƴoh ya iñaanuu Yéesú iñaanoo daa tah wa kom ɗi ri. ");
INSERT INTO ndv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tígí daaha, kélfë yí seeƴoh ya sorute dúukëlí ɓëewë nuf, nda wa mín won Pilaat biti ɗi yeɗɗan Barabaas. ");
INSERT INTO ndv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaat wonil ɓëewë tih⁠ ⁠: «⁠ ⁠Mantee ɓal, kon ɗon fahuu biti mi hena ɓëeꞌ në wonuu ron buuri yëwúɗɗë rë ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wa ɓéyrúté unni wa sun na wonu tih⁠ ⁠: «⁠ ⁠Daaƴe ri kurwah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaat won wa tih⁠ ⁠: «⁠ ⁠A ri paŋ yii ɓosi bih⁠ ⁠?⁠ ⁠» Ndaa wa ɓaatuutee ɗaañnjoh na wonu tih⁠ ⁠: «⁠ ⁠Daaƴe ri kurwah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bi fahaꞌ Pilaat yii neɓaꞌ ɓëewë, ɗi ɗúhríɗté wë Barabaas kasaa, laɓirohte Yéesú laraw, antee wa rii yeɗɗaꞌ wa daaƴe ri kurwah. ");
INSERT INTO ndv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldaarra ɓeyute Yéesú, kúrúté rí baylaa filiɓ faam gëernëer, dëekúté soldaarri kayya filiɓ ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wa tíkúté paltu luum sun fi, ɓeyute ñap yugusute baane, ɓekute afa, ");
INSERT INTO ndv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","na anuu rii wodoh wonu tih⁠ ⁠: «⁠ ⁠Coleere buuri yëwúɗɗë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tígí daaha, wa na laɓisuu ri kankaniit bëhëer af, na tuulsuu ri, na anuu ƴek fíyí, na sígímírú rí. ");
INSERT INTO ndv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Këekkëlíyúu wë rí níi wocce ra, wa nísúté paltii luuma faana, ɓekaatute ri búuɓɓí, anutee rí ɗúhíɗ ëssín na suu daaji kurwah. ");
INSERT INTO ndv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lahte ɓëyí hínú Simoŋ, ɗi ɓëy Siren, daa ri boffi Iliksaan a Rufus. Ɗi húmú kolaꞌ meey koon, ɓani soldaarra teeꞌuute, wa enute ri kurwahi Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wa kúrúté Yéesú tígë në wonuu Golgotaa ra (daa ri⁠ ⁠: këeŋ-af). ");
INSERT INTO ndv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wa yerute ri béeñí boolluu a míir, ndaa ri hanay. ");
INSERT INTO ndv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wa koluu daaha, daaƴute ri kurwaha. Filoon fi baaha, wa púlúfúté búuɓɓí, woruute wa hanndal ki wa. ");
INSERT INTO ndv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wahtaa daaƴu wa ri kurwaha ra teeꞌaꞌ siñaakada. ");
INSERT INTO ndv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lahte bíníi tíkú af kurwaha, teeɓaꞌi yee tah Yéesú tíkú húl rë. Unna won yii beh⁠ ⁠: «⁠ ⁠Ɓëyí bee daa buuri yëwúɗɗë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wa daaƴaaluute banndi ana ɓal kurwah hëbís Yéesú⁠ ⁠: ɓëyí yínëe paaꞌte ri yaꞌ ñamaa, yínëe paaꞌte ri yaꞌ sugu.  ");
INSERT INTO ndv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yee bíníyú Téerëe rë lahaꞌte ɗaaha, bitih⁠ ⁠: «⁠ ⁠Ɗi kídëelúuté ɓëewí ɓossa na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɓëewë në ñeyu hatni baaha ra, na hégíƴú affi wa na solu ri wonu tih⁠ ⁠: «⁠ ⁠Ɗo fa won biti fay poo Faam fi gaani Koope, fu taɓahaat ɗi filiɓ waal éeyë rë, ");
INSERT INTO ndv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","namee sëmlëꞌ afu, fu nuul kurwaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis ɓal na ñaawlu ri hanndal ki wa wonu tih⁠ ⁠: «⁠ ⁠Ɗi sëmlëꞌté i ow kay, ɗi antee mínéh sëmlëꞌ afi⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Buura Koo fal ri ra fa, buuri Israyel ra, nuulan kurwaha noo. Ɗi nuul níi fun tík ɗí íl rëe, fun ay gém ɗii na.⁠ ⁠» Ɓëewë daaƴu kurwah hëbísí rë, ñaawlute ri ɓal. ");
INSERT INTO ndv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lahaꞌ naꞌ leelu af ra, gina ɓéeɓ ñúussé túɗ níi mitte wahtu éeyë. ");
INSERT INTO ndv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wahtii éeyë fë, Yéesú ɗaasse foŋ won tih⁠ ⁠: «⁠ ⁠Eloyi, Eloyi, lama sabaktani⁠ ⁠?⁠ ⁠» Daa ri⁠ ⁠: «⁠ ⁠Koope, Koope, fu súugëh sëꞌ yi taan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lahte i ow di ɓëewë húmú daaha ra, keluu wa unni ƴah, wa wonu tih⁠ ⁠: «⁠ ⁠Kélíi woni, ɗi ee dëek Éelí rë kan⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ow di waa na múkëté ɓeɓpe líil sooppe ri bineegar, pokke ri af baaŋ bëhëer, yuliɗte ri ɓúk Yéesú na fahaꞌ hënndí, na won tih⁠ ⁠: «⁠ ⁠Yéɗɗí yen olsoh, nda Éelí ay ac nuuliɗ ɗi raa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tígí daaha, Yéesú ɗaasse foŋ, yeɗɗohte lússé. ");
INSERT INTO ndv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wahtii baaha, rídíi ɓídí Faam fi gaani Koope ɗap tígí selaa níi sela ra ɗaɗte dalaꞌte sun níi feey, ɓísëlsëꞌté ana. ");
INSERT INTO ndv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kélfíi soldaara húmú caŋ fíi Yéesú rë, olaꞌ ri ɗee húlëꞌ rí rë, won tih⁠ ⁠: «⁠ ⁠Ɓëyí bee Koy Koope kaah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lahte ɓeleɓɓi húmú cëehúuté, na olsuu. Mari fi ɓëy Makdalaa húmú waa na, Salome, Mari yaafi Saak Ƴutuuɗ a Soses. ");
INSERT INTO ndv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wa na húmú ñéerúu a Yéesú homaꞌ ri Galile ra, na tooppituu ri. Ɓeleɓ caak kay húmú në ɓal, ƴi húmú ñéerúu a Yéesú na ac ri Yerusalem ra. ");
INSERT INTO ndv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yiin húl Yéesú rë teyaꞌ a bisi waaja, daa ri bisa këllëh bisa na hílsúu yëwúɗɗë rë, te naꞌ sosse haat. ");
INSERT INTO ndv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Daa tah Suseef fi ɓëy Arimate fa húmú lahte tii kélfë yí yëwúɗɗë në rë, te na húmú sehaaloh ayi Nguur ki Koope ra ɓal, kolaꞌ daaha pokke fídí, payte Pilaat na, meelte ri ɓúudé fí Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ndaa kelaꞌ Pilaat húlí Yéesú rë, yaa gaawaꞌte ri. Ɗi dëekrëhté kélfíi soldaarra, meelte ri nda Yéesú maañcee húl rëe. ");
INSERT INTO ndv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wonaꞌ ri kélfíi soldaarra biti ɗi húlté kaah ra, Pilaat wonte Suseef biti ɗi mín ɓeɓ ɓúudé fë. ");
INSERT INTO ndv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tígí daaha, Suseef payte lompe perkal, nuuliɗte ɓúudé fë kurwaha, líiwëꞌté rí perkala, ɗappe ri kolom ki yotu loo laꞌ, antee píníŋ laꞌ gaan, kúnëꞌté nuŋa. ");
INSERT INTO ndv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari fi ɓëy Makdalaa a Mari yaafi Soses homute na olsuu tígë hacuu ɓúudé fí Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gétëꞌ bisa na hílsúu yëwúɗɗë rë, Mari fi ɓëy Makdalaa a Salome a Mari yaafi Saak lomute i yin heeñlaa, yugusii ɓúudé fí Yéesú. ");
INSERT INTO ndv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Púlí naꞌ ɓaabi dímëesë cúɓ, wa koluute na suu tígë hacuu Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Homuu wa waala ra, wa na meelantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Daa nay yen píníŋíré laꞌa ɓúk luuya⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ndaa ɓéyrúu wë affi wa ra, wa olute biti laꞌa húmú ɓúk luuya ra, di gaanaꞌ ri ɓéeɓ píníŋúté hatin. ");
INSERT INTO ndv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wa haalute luuya, olute wahambaanii ɓekoh sabidoor naaꞌ tookke yaꞌ ñamaa⁠ ⁠; wa yípútée tíit. ");
INSERT INTO ndv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ndaa ɓëeꞌ won wa tih⁠ ⁠: «⁠ ⁠Ngënë tíití⁠ ⁠! Mi yúhté biti ɗon saamu Yéesú fí ɓëy Nasaret fa húmú daaƴu kurwaha ra. Ɗi íníh deh, ɗi këllúté ɓúudé. Ëlsíi tígë húmú fënɗú rí rë. ");
INSERT INTO ndv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yípíi pay ɗon won Peer a taalibe yi kayya biti ɗi këllëhté rën Galile, ɗon ay rii olee dín fë ti di húmú wonaꞌ ri ron nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɓeleɓɓa ɗúhúté luuya na suu a múkë, wa tíitú tíitë níi na saaku. Tíidë tíitú wë rë tahte wa wonuy ow yin waala.  ");
INSERT INTO ndv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kolaꞌ Yéesú ɓúudé ɓaabi dímëesë rë, ɗi ɗéɓpí feeñiyoh Mari fi ɓëy Makdalaa fa ɗi húmú líkíɗ ɗí yébítëh paana ra. ");
INSERT INTO ndv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari payte ɓílíɗté ɓëewë në húmú ñéerúu a Yéesú rë yee lah ra, ɗeef keeññi wa líssí líif, wa na looyu. ");
INSERT INTO ndv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wonaꞌ wa Mari biti Yéesú ee pes ɗa te ri otte ri ra, wa gémúy rí. ");
INSERT INTO ndv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Filoon fi baaha, Yéesú feeñiyohte taalibe ana yi homu waal. Wa yúhsúuy rí wahtii baaha bi lofisoh ri. ");
INSERT INTO ndv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tílëꞌ níi wa yúhsúuté rí rë, wa nimilute, ɓíllúté taalibe yi kayya baaha, ndaa wa gémúy wë ɓal. ");
INSERT INTO ndv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yéesú míllëꞌtée feeñiyoh taalibe yi sabboo a yínë yë ɗeef wa homu ñam⁠ ⁠; ɗi na won affi wa di yee lahuy wa ngém rë, a súhí wë keeñ af biti wa gémúy woni ɓëewë olu ri filoon fi bee këllúu rí ɓúudé rë. ");
INSERT INTO ndv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ɗi antee waa won tih⁠ ⁠: «⁠ ⁠Pëyí ɗon waare ɓëy ëldúnë ɓéeɓ Uni Neba. ");
INSERT INTO ndv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɓëyí gém Uni Neba te ɗi bëtsú, ɗi ay múc⁠ ⁠; ɓëyí gémëy nék, ay daanu. ");
INSERT INTO ndv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ɓëewë gémú rë ay tíinndúu ɗeh⁠ ⁠: di tii soꞌ wa ay lík i yébítëh, wa won wonaɗ has, ");
INSERT INTO ndv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","wuti wa ham goŋ yaꞌ yi wa mbée wa han sot raa sah, yin ii waa kat. Te wa tíkëꞌ jéríɗ yaꞌ tii soꞌ, jérdë ay wah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wonaꞌ Yéesú-Yíkëe a wa níi wocce ra, Koo ɓéyíɗté rí kúɗté rí hëbísí sun, ɗi hompe yaꞌi ñamaa fi. ");
INSERT INTO ndv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Taalibe ya sayuu daaha na waariyu Uni Neba ëldúnë ɓéeɓ. Ɗi fi Yíkëe habraꞌte wa légéyí wë níi yii won wa ɓéeɓ ñéerëꞌ kimtaan.");
INSERT INTO ndv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ɓah Tewofil, ow caak bíníyúté di oluu wa ri, di yii leŋke iña lah filiɓ fi fun dee bín fë rë, ");
INSERT INTO ndv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ti di ɓíllúu wë ɓëewë maasuu iñƴaaha dalaani wa ra, te daa wa ɓëewë na waariyu Unni Koope ra. ");
INSERT INTO ndv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Soꞌ ɓal, mi nampee meelsaꞌ yii lante sun fi iñƴaaha ɓéeɓ, mi na téebíɗ, dalaꞌte dalaani wa, mantee ot biti ette mi bíníyíɗ ɗë wë. ");
INSERT INTO ndv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hen ɗaaha raa, fay yúh biti iña teeɓu fu ra ɓéeɓ kaah. ");
INSERT INTO ndv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jamanaa henaꞌ Erot buuri Yúdée rë, húmú lahte seeƴohi hínú Sakari, ɗi non goomali seeƴoh yi Abiyaa koon. Ɓeleɓi hínú Ilsabet, ɗi sédí Aaron seeƴohi gaana. ");
INSERT INTO ndv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wa ɓéeɓ ana húmú júɓúté íllí Koope, wa na hélíh yin túuƴëꞌ yë, wa na pagu iña nahaꞌ Koo-Yíkëe rë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wa húmú lahuy koy, af biti Ilsabet húmú mínéh pok loo, te wa ɓéeɓ ana ɓahayute. ");
INSERT INTO ndv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lahte bis, Sakari hompe waaji seeƴoha yuliɗ Koope na ra, ndah goomali daa eyuu paŋi. ");
INSERT INTO ndv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Di ɓaahuu wa ri, seeƴoh ya húmú tansuu ow, këɗrí Koope cuuraay tígë lukki sela filiɓ Faam fi gaani Koo-Yíkëe rë. Bee yínée tansa keen sun fi. ");
INSERT INTO ndv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wahtaa na karaꞌ cuuraaya ra, ɓëewë ɓéeɓ húmú ëssë na ɗagu. ");
INSERT INTO ndv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakari hom filiɓ níi ri otte malaakii Koo-Yíkëe hatna paaꞌ tígë na tamuu cuuraay ra yaꞌ ñamaa. ");
INSERT INTO ndv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ɗi tíitté, afa kúnëhté. ");
INSERT INTO ndv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ndaa malaakaa won ri tih⁠ ⁠: «⁠ ⁠Ngana tíit Sakari⁠ ⁠! Koope tahte ɗaŋu⁠ ⁠: ɓeleɓu Ilsabet ay roo límíɗ koy ƴaal, lah dëekée rí Saŋ. ");
INSERT INTO ndv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Keeñu ay naa sos níi sos te límí ay neɓaꞌ ow caak. ");
INSERT INTO ndv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ɗi ac ow gaan íllí Koo-Yíkëe. Ɗi ii han béeñ mbée hani mín maniyil ɓéeɓ. Balaa ri límú, ɗi ay líif a Ruuh-Peseŋ. ");
INSERT INTO ndv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɗi ay nimiliɗ ow caak di ɓëy Israyel Koope na, Yíkíi wë. ");
INSERT INTO ndv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ɗi ay këllëh Yíkëe, ñéerëꞌ a doolii Ruuhi Koope húmú yonente Éelí në rë, yugusaꞌ hanndal ki baappa a koyya, nimiliɗ ɓëewë súugúu Koope ra, wa ñéerëꞌ a ɓëewë júɓú rë. Ɗi ay saam dúukëlí ɓëewí ay homɗe Koo-Yíkëe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakari meelte malaakaa won ri tih⁠ ⁠: «⁠ ⁠May yúhée biti yii baa ay lah ɗíh⁠ ⁠? Soꞌ mi ɓahate te ɓeleɓ soꞌ ɓitiffe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaakaa tahte won ri tih⁠ ⁠: «⁠ ⁠Daa mi Gaburyel, mi homaꞌ hëbís Koo. Daa ri wol soꞌ ɗoo na, komu uni nebi bah. ");
INSERT INTO ndv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yee won mi ro baa ra ay lahee ɗaaha biti wahtaa lah. Ndaa gémë gémëy fu soꞌ ra tahte fii míníl won níi yiin nay lahe iñƴaaha ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ƴaaha ɓéeɓ ɓëewë húmú ëssë na sehu, wa éemúté maaña maañ Sakari filiɓ tígí selaa ra. ");
INSERT INTO ndv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ɗúhëꞌ rí rë, ɗi mínéh won waa na, ɗi wonaꞌ a wa wonaɗ likiɗ. Tígí daaha, ɓëewë anutee yúh biti ri ot yin tígë. ");
INSERT INTO ndv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ɗúmlëꞌ Sakari waalla eyuu ri Faam Koope ra, ɗi nimilte faam. ");
INSERT INTO ndv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gétëꞌ iñƴaa ɓéeɓ rë, hompe níi Ilsabet ɓeleɓi pokke loo, hompe yii mitte céyín iip faam ɗúhëy. Ɗi won nufi tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«⁠ ⁠Ëlí yee pagiɗ soꞌ Koo-Yíkëe rë kan⁠ ⁠! Nufa payte soo na, ɗi níssé gacaa húmú homaꞌ mi leelii ɓëewë rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Céyín pëenë filoon fi heni Ilsabet loo, Koope wolte malaaka Gaburyel kúkëy cafaƴ na, hínú Maryaama⁠ ⁠; ɗi dék Nasaret di Galile. Ɗi húmú onute ƴaal⁠ ⁠; ƴaala Suseef sédí Dawit. ");
INSERT INTO ndv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Lahaꞌ malaakaa faam Maryaama ra, ɗi won ri tih⁠ ⁠: «⁠ ⁠Coleere Maryaama, ɗo fa Koo-Yíkëe on ɗo mal ra. Ɗi ee ɗoo na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Woni malaakaa kúnté af Maryaama⁠ ⁠; ɗi na níɓ yee waɗti fahaa won wodohi baa ra. ");
INSERT INTO ndv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaakaa won ri tígí daaha tih⁠ ⁠: «⁠ ⁠Ngana tíit Maryaama, Koope daa on ɗo mal. ");
INSERT INTO ndv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Síkírée⁠ ⁠! Fay pok loo te fay lahee koy ƴaal, lah dëekée rí Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɗi ac ow gaan te ri ay dëekúu Koy Koope fa sunaa-sun. Koo-Yíkëe ay rii yeɗ ñaani nguur ki Dawit ciffi. ");
INSERT INTO ndv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ɗi ay hen buuri ɓëy Israyel faraah, Nguur ki ii mëssí ɗúm.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryaama won malaakaa tih⁠ ⁠: «⁠ ⁠Yii baa ay mínée lah ɗíh te mi yéeh ƴaal⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaakaa won ri tih⁠ ⁠: «⁠ ⁠Ruuh-Peseŋ ay cép sun fu, Koope fa sunaa-sun ay teeɓaꞌ doolii ɗoo na. Daa tah kúkëyí selaa nay fuu lahee ra ay dëekúu Koy Koope. ");
INSERT INTO ndv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ɓitifaꞌ mboko mu Ilsabet níi, ɗi pokke loo⁠ ⁠; ɗi fa húmú wonu biti mínéh lah koy ra, ɗi hom céyín fí pëenë fí woteh. ");
INSERT INTO ndv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Lahay yii wooñ Koo.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryaama won tígí daaha tih⁠ ⁠: «⁠ ⁠Mi súrgíi Koo-Yíkëe⁠ ⁠; yee won fu ra lahaan ɗaaha.⁠ ⁠» Tígí daaha, malaakaa takohte, saañce. ");
INSERT INTO ndv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tíkëh i waal, Maryaama kolohte yíppée saañ gini hom daŋŋi deyi Yúdée. ");
INSERT INTO ndv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Lahaꞌ ri ra, ɗi haalte faam Sakari, wodohte Ilsabet. ");
INSERT INTO ndv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ilsabet na keloh wodohi Maryaama, koy ka lowa hégíƴëhté, Ruuh-Peseŋ yíppée rii haal. ");
INSERT INTO ndv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tígí daaha, ɗi ɓéyíɗté uni sun won tih⁠ ⁠: «⁠ ⁠Koope lukki barkel ro ɓeleɓɓa feey fa ɓéeɓ te koy ka lowu barkelte ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Daa mi wa níi, yaafi Yíkíi sëꞌ na ac yérí sëꞌ⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ole⁠ ⁠! Mi na keloh wodohu rek, keeñ koy ka loo soꞌ sosse níi sos, tahte ri na hégíƴëh. ");
INSERT INTO ndv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Fu lahte sos-keeñ, gémë gém fu biti iña wonu fu te kolaꞌ Koo-Yíkëe në rë ay lah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryaama won tígí daaha tih⁠ ⁠: «⁠ ⁠Mee kañ ɗee gaanaꞌ Koo-Yíkëe rë, ");
INSERT INTO ndv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ɗi fa na sëmlëꞌ sëꞌ rë tahte keeñ soꞌ sosse níi sos, ");
INSERT INTO ndv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","di yee helaꞌ ri nuf soo na ra, soꞌ mi súrgë ɗii na kut ra. Daa tah dalaꞌte woteh níi kiri fi kirih, ɓëewë ay soo dëekée sos-keeñ fe. ");
INSERT INTO ndv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Koope fa mín ɓéeɓ rë pagiɗte soꞌ yii gaante⁠ ⁠; tiyi selate. ");
INSERT INTO ndv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dee níi kiri fi kirih, ɗi ay teeɓ ɓëewë neehu ri ra naaꞌ-keeñ. ");
INSERT INTO ndv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɗi teeɓaꞌte doolii, paŋke i yin gaan⁠ ⁠; ɗi tasaaraꞌte ɓëewë në gaan-gaanluu ra. ");
INSERT INTO ndv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɗi cépíɗté buurra ñaanni nguur ki wa, ɓéyíɗté ɓëewë lahuy doole ra. ");
INSERT INTO ndv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɗi onte ɓëewë yaaɓu ra njél, líkké ɓëewë caaku yin ra wa suute a yaꞌ holoŋ. ");
INSERT INTO ndv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɗi sëmlëꞌté ɓëy Israyel súrgë yí, teeɓpe wa naaꞌ-keeñ, ");
INSERT INTO ndv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ti di húmú gapaꞌ ri caacci yen nen, Abraham a séttí níi kiri fi kirih.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryaama hompe Ilsabet na yii mitte céyín éeyë antee nimil faam. ");
INSERT INTO ndv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lahaꞌ loo Ilsabet ra, ɗi lahte koy ƴaal. ");
INSERT INTO ndv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Keluu ɓëewë dékú a ri ra a mboko yi biti Koo-Yíkëe teeɓpe ri naaꞌ-keeñ níi rë, ɓani wa ɓéeɓ bokute lahute na sos-keeñ. ");
INSERT INTO ndv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nimilaꞌ bisa límú kúkëyë rë, ɓëewë ayute leji. Wa fahuu yeri tii Sakari koon, boffa⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ndaa yaafa tahte won tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ, ɗi hínú Saŋ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Lahay ɓëyí hínú ɗaaha mboko yu na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wa anutee won a boffa wonaɗ likiɗ, meelute ri tiya nay yeru koohi ra. ");
INSERT INTO ndv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tígí daaha, Sakari meelaꞌte arduwaas, bíníté në unni ƴeh⁠ ⁠: «⁠ ⁠Ɗi ay hínú Saŋ.⁠ ⁠» Ɓëewë ɓéeɓ éemúté në. ");
INSERT INTO ndv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pereem Sakari yíppée pëkísëh, ɗi dalaatte won, ɗi yampe na sím Koope. ");
INSERT INTO ndv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ɓëewë ɓani wa dékú rë ɓéeɓ tíitúté. Wona hente lëyëŋ deyi daŋŋi Yúdée ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɓëewë keluu iñƴaa ra ɓéeɓ na níɓú yii leŋ na, wa na meelu affi wa yee nay míllée kúkëyë rë, ndée lante biti Koo-Yíkëe ñéerëꞌté a ri. ");
INSERT INTO ndv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ruuh-Peseŋ haalte Sakari boffi kúkëyë, ɗi na léhín unni kolaꞌ Koope na won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«⁠ ⁠Ɓëewë ɓéeɓ símún Yíkëe, Koope fi ɓëy Israyel, di yee yeelaꞌ ri ɓëewí, sëmlëꞌté wë rë. ");
INSERT INTO ndv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɗi kompe yen ɓëyí gaani nay yen sëmlée, bi ɗúhëꞌ tali Dawit súrgíi. ");
INSERT INTO ndv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Daa ri yee maañ rii gapaꞌ, ñeyaꞌte ri yonente yi sela yi ra. ");
INSERT INTO ndv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ɗi húmú wonte yen biti ri ay yen sëmlëꞌ yaꞌ yi haaꞌoh yi yen a kaaꞌoh yi yen. ");
INSERT INTO ndv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɗi teeɓpe caacci yen naaꞌ-keeñ, hampe yee húmú pok ri hanndal ki wa ra. ");
INSERT INTO ndv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Koope añohte ciffi yen Abraham biti ");
INSERT INTO ndv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ɗi ay yen sëmlëꞌ yaꞌ yi kaaꞌoh yi yen, nda yen néekíñíih jaamiyohi⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nda pesi yen ɓéeɓ, yen hen ɓëewí selayute te júɓúté íllí. ");
INSERT INTO ndv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te ɗo fi koy soꞌ, fay dëekúu yonentii Koope fa sunaa-sun, ndée fay këllëh Yíkëe, fu ɗariɗ ri waali, ");
INSERT INTO ndv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","fu teeɓe ɓëewí biti ri ay waa sëmlëꞌ, baal wa bakaaɗɗi wa. ");
INSERT INTO ndv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Koope fi yen baahte te ri naaꞌte keeñ, daa tah ɗi ay yen hawaan a niiñi ɗúhëꞌ sun ti naꞌa na púl rë nen, ");
INSERT INTO ndv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","niiñli yen fa homu ñúus te tasuu seh kúl kë rë, ɗi tík yen waali jaammaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Saŋ na ooɗ, afa na ɓaatti kúnsëh. Ɗi húmú pesaꞌ luufa níi yiin teekiroh ri ɓëy Israyel ra. ");
INSERT INTO ndv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jamanii baaha, buura hínú Ëgís rë túuƴëꞌté kíní ɓëewë dékú ginna Rom ílíf wë rë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lahi kínë ɗéɓ baa ra, ɗeef Kiriñus daa kélfíi gini Sírí, ");
INSERT INTO ndv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","te ow fi ow ɓéeɓ sayaꞌ bíníyëh gina coosaanaꞌ ri ra. ");
INSERT INTO ndv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ɗi fi Suseef ɓal nampee koloh Nasaret di Galile, saañce Betleꞌem di Yúdée, gina coosaanaꞌ Dawit ra, ndée ri non tali Dawit. ");
INSERT INTO ndv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Na saañ Suseef bíníyëh rë, ɓani Maryaama ñéerúu. Ɗeef Maryaama húmú pokke loo. ");
INSERT INTO ndv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Homi wa Betleꞌem daaha, lowa hampe⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ɗi saawohte koy ƴaal. Ɗi lëmëssé baakera ndíimú, fëníɗté rí mbalka ñamaa júr, bi ɗeef wa húmú ɗëmíh lasa na hanluu ayoh ya ra. ");
INSERT INTO ndv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Húmú lahte níirëh yí na neeꞌu wohi yuppi wa luufi baaha. ");
INSERT INTO ndv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malaaka yínë di malaaka yi Koo-Yíkëe púlëhté waa na, niiñi ndami Yíkëe hawaante wa. Tígí daaha, wa tíitúté níi tíit. ");
INSERT INTO ndv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Malaakaa won wa tih⁠ ⁠: «⁠ ⁠Ngënë tíití⁠ ⁠! Mi ac wonon yii neɓpe keloh, yii ay sosil keeññi ɓëewë ɓéeɓ níi sosil. ");
INSERT INTO ndv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Elgee woteh beh, di gin Dawit, lahte Sëmlëhí límɗúté rën, daa ri Kiristaa, daa ri Yíkëe. ");
INSERT INTO ndv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te ɗon ay rii yúhsée ɗeh⁠ ⁠: ɗon ay ot baakeri lëmësú ndíimú, fënɗú mbalka ñamaa júr.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Malaakaa na woc wona, malaaka caak yípútée ríi ɗeefiɗ, wa na njooɓru Koope wonu tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«⁠ ⁠Koo laha ndam di sunaa-sun, te ɓëewë ri fahaꞌ wa ra ɓéeɓ lah jaamma feey fa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nimiluu malaaka ya sun-Koo ra, níirëh yë na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Yen yíppí koloh yen saañ Betleꞌem, yen ole yee lah ra, yee teeɓ yen Koo-Yíkëe rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wa yípútée koloh suute na saamu. Lahuu wa ra, wa olute Maryaama a Suseef, wa ɗeefute baakera fënɗúté mbalka ñamaa júr. ");
INSERT INTO ndv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Oluu wa kúkëyë rë, wa ɓíllúté yee won wa malaakaa sun fi ra. ");
INSERT INTO ndv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɓëewë keluu ɓíllí níirëh yë rë ɓéeɓ éemúté woni wa níi éem. ");
INSERT INTO ndv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ɗi fi Maryaama hampe iñƴaa ɓéeɓ afi, na níɓ në. ");
INSERT INTO ndv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Níirëh yë anutee koloh na nimilu yuppi wa, na kañu Koope, na njooɓru ri di iña keluu wa te olute wa ra. Iña ɓéeɓ lahte ti ɗee húmú wonaꞌ wa malaakaa ra nen. ");
INSERT INTO ndv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nimilaꞌ bisa límú kúkëyë rë, wahtaa nay rii lecu ra lahte⁠ ⁠; ɗi yerute tii Yéesú ti di húmú nahaꞌ ri malaakaa ɗeef yaafa pokay loo doom ra. ");
INSERT INTO ndv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hompe níi wahtaa waɗ waa púusúun rë lahte ti ɗee túuƴëꞌ rí kootii Mëyíis rë nen. Tígí daaha, Suseef a Maryaama koluute kúrúté Yéesú Yerusalem, jébëlúté rí Koo-Yíkëe, ");
INSERT INTO ndv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ndée bíníyúté di kootii Koo-Yíkëe bitih⁠ ⁠: «⁠ ⁠Koy ki saawi ƴaali límú ɓéeɓ ay jébëlú Koo-Yíkëe.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wa yeruute hawra na nahaꞌ kootii Koo-Yíkëe rë ɓal⁠ ⁠: hëtë ana mbée bëdú teem-teem ana. ");
INSERT INTO ndv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Húmú lahte ɓëyí dék Yerusalem, ɗi hínú Simewoŋ. Ɗi júɓpé, gémpé Koope níi gém, te lahte yaakaar ayi ɓëeꞌ nay sëmlée ɓëy Israyel ra. Ruuh-Peseŋ húmú haalte ri, ");
INSERT INTO ndv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","te teeɓpe ri biti ɗi ay ot Buura Koo-Yíkëe fal ri ra, balaa ri húl. ");
INSERT INTO ndv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ɗaaha, Ruuh-Peseŋ yeñce ri Faam fi gaani Koope. Kúrúu Suseef a Maryaama koy wa Yéesú paŋi yee nahaꞌ kootii Mëyíis rë, ");
INSERT INTO ndv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simewoŋ ɓeɓpe kúkëyë ɓoppe ri, símpé Koope na won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«⁠ ⁠Koo-Yíkëe, yee gap fu soꞌ ra lahte woteh. Fu mín sëe yeris soꞌ mi súrgúu mi húl, mi saañ a jaamma, ");
INSERT INTO ndv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ndée mi tíkké íllí sëꞌ ngëeƴ sun fi Sëmlëhë wol fu ra, ");
INSERT INTO ndv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","te ɓëy ëldúnë ɓéeɓ ay rii ot. ");
INSERT INTO ndv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Daa ri niiña nay tahe heetta feey fa ɓéeɓ yúh rë rë⁠ ⁠; ɗi ay on ɓëewú, ɓëy tali Israyel ndam.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Boffa a yaafa éemúté yee won Simewoŋ sun fi kúkëyë rë. ");
INSERT INTO ndv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simewoŋ ɗagiɗte wa antee won Maryaama yaafi Yéesú tih⁠ ⁠: «⁠ ⁠Koope daa wol kúkëyí beh, kéenɗí a ɓéyrí ow caak Israyel. Ɗi ay hen tíinndëe te ɓëewë ay rii kaaꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ɗi ay tah ow caak teeɓaꞌ yee hom nuffi wa ra⁠ ⁠; te ɗo fi yaafa, fay lah yii ay roo misik keeñu níi misik.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Húmú lahte yonentii ɓitiffe níi ɓitif hínú Aane⁠ ⁠; ɗi koy Penuwel fa tali Aseer. Ɓani ƴaala húmú kooɗ ri henaꞌ ri cafaƴ ra pesute kíil paana, ƴaala antee húl. ");
INSERT INTO ndv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kolaꞌte baaha, ɗi pesse níi ri lahte kíil sabay peeye a kíil iniil (84) te ri lahaatay ƴaal kay. Ɗi homaꞌ Faam fi gaani Koope naꞌ a elek oore, ɗage. ");
INSERT INTO ndv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ɗi lahaꞌ daaha ɗeeffe wa na, ɗi yampe na sím Koope, na won ɓëewë në sehaaluu biti Koope ay sëmlëꞌ Yerusalem ra ɓéeɓ yii leŋke kúkëyë në. ");
INSERT INTO ndv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wocuu boffi Yéesú a yaafa paŋi yee nahaꞌ kootii Koo-Yíkëe rë, wa nimilute gin wa Nasaret di Galile. ");
INSERT INTO ndv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yéesú na ooɗ, afa na ɓaatti kúnsëh na won wonaɗ ɓaha. Ɗi húmú neɓpe nuf te Koope yeɗɗay ri. ");
INSERT INTO ndv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Húmú lahaa kíil ɓéeɓ, boffi Yéesú a yaafa pay feedi PaagaYerusalem. ");
INSERT INTO ndv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lahaꞌ Yéesú kíil sabboo a kíil ana ra, wa ñéerúuté a ri suute feedin, di ɓaahuu wa ri. ");
INSERT INTO ndv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ɗúmëꞌ feeda ra, ɓëewë në nimilu, ndaa Yéesú tasse Yerusalem te boffa a yaafa yíih yin na. ");
INSERT INTO ndv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wa habuu biti koon ɓani kooƴƴa ñéerúu rë daa homu, níi wa tílúté bis múlgús. Kanuu wa ri ra, wa na anuu rii saam mboko ya a kooƴƴa na. ");
INSERT INTO ndv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Oluy wa ri ra, wa nimilute Yerusalem na saamu ri. ");
INSERT INTO ndv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Waali éeyë fë, wa ɗeefu ri filiɓ Faam fi gaani Koope tookke yëeddëh yë në, na síkírëh wë, na meel wa. ");
INSERT INTO ndv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɓëewë në síkírúu rí rë ɓéeɓ, éemúté ɗee ñaañaꞌ ri ra a ɗee na lofaꞌ ri won ra. ");
INSERT INTO ndv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Boffa a yaafa éemúté níi éem oluu wa ri ra. Yaafa won ri daaha tih⁠ ⁠: «⁠ ⁠Ɗo fu pagaꞌ fun yii bee ɗíh⁠ ⁠? Funi boffu moku moko saamu níi mok.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon saamuu soꞌ yih⁠ ⁠? Ɗon yíih biti mi waɗti homa faam Baasoꞌ a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ndaa wa yíih yee fahaꞌ ri waa won baa ra. ");
INSERT INTO ndv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yéesú kolohte ɓani wa nimilute Nasaret. Ɗi tassi ñeyaꞌ woni wa. Yaafa hampe iña lah ƴaa ra ɓéeɓ afi. ");
INSERT INTO ndv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yéesú na ooɗ, nufa na ɓaatti neɓ⁠ ⁠; ɗi ɓaattee neɓaꞌ Koope a ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kíilí sabboo a iip fa homaꞌ buura hínú Tibeer nguur ka ra, ɗeef Poos Pilaat daa húmú gëernëerí Yúdée, Erot kúɗté Galile, Fílíp ɓahii kúɗté Ítúré a Tarakonit, Lisañas kúɗté Abilen⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Haan a Kayif daa húmú seeƴoh yi gaanna. Kíilí baaha, Saŋ fi Sakari hom luufa, liilte Una kolaꞌ Koope na ra, bee nay rii waareye ra. ");
INSERT INTO ndv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ɗaaha, ɗi wërté deyi Yurdeŋ ɓéeɓ, na won ɓëewë biti wa warutee lof pesaɗ, wa bëtsú, Koope baal wa bakaaɗɗi wa ");
INSERT INTO ndv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ti ɗee húmú bíníyúu rí téeríi yonente Isayii ra bitih⁠ ⁠: «⁠ ⁠Lahte un ɓëyí ɗofohte luufa na won tih⁠ ⁠: “Ɗëɗɗí Yíkëe waal, ɗon yugusiɗ ɗi waalla nay rii ñeye ra níi júɓ. ");
INSERT INTO ndv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Húlúɓɓë ɓéeɓ púuɓún, daŋŋa a dúŋŋë ɓéeɓ ɗeelu⁠ ⁠; waalla lúgúƴëh rë yugusuu, waalla lah ngas ra leeñu. ");
INSERT INTO ndv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hen ɗaaha raa, ɓëewë ɓéeɓ ay ot biti Koope ay sëmlëꞌ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ow caak ayute bëtsëh Saŋ na, ɗi won wa tih⁠ ⁠: «⁠ ⁠Tisoh yi hiliññi ƴeh⁠ ⁠! Daa won ɗon biti ɗon mínú hegoh daanee ke Koope na ac ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hena biti kaah ɗon lofute pesaɗ raa, lah téeɓíi rí pagaɗɗon. Ngënë hëbí affon biti ɗon séttí Abraham rek doyte. Mee ron won ra ee biti Koope mín yídís laꞌ yi ƴeh wa hen séttí Abraham⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wëettíyíi affon⁠ ⁠! Yíinë caŋke lecaꞌi kilikka tal-tal ka⁠ ⁠; kilki límëy koy ki lahte njiriñ ɓéeɓ ay lecu, betu kíi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɓëy mboolo ma na meelu Saŋ wonu ri tih⁠ ⁠: «⁠ ⁠Koope fahaꞌ biti fun pagun yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠Ɓëyí lah búuɓ ana, ona ɓëyí lahay búubí yínëe⁠ ⁠; te ɓëyí lah yii ñama ri, woraꞌ a ɓëyí lahay ñam.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","I yeekoh túm ayute bëtsëh ɓal, meelute ri wonu tih⁠ ⁠: «⁠ ⁠A fun nék ɓahaa, fun waɗti pagun yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠Ngënë méelíi yii luk ƴee nahu ron meelaꞌ túm rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","I soldaar ayute ɓal, meelute Saŋ wonu ri tih⁠ ⁠: «⁠ ⁠A fun⁠ ⁠! Fun waɗti henun ɗíh⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ngënë nëefí hélíis ow, te ngënë félí ow ron ɓeɓ hélsí. Lah téyí iña na yínlú ron ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ɓëewë lahute yaakaar níi wa ɓéeɓ na wonu nuffi wa nda Saŋ daa Buura Koo fal ri ra neh. ");
INSERT INTO ndv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Saŋ won wa ɓéeɓ tih⁠ ⁠: «⁠ ⁠Soꞌ mi beh, mi bëtsëꞌ ron a muluɓ, ndaa lahte ɓëyí ee ac ra, ɗi luk soo gaan fap, mi haaƴayti liil kotti. Ɗi ay ron bëtsée a Ruuh-Peseŋ a kíi. ");
INSERT INTO ndv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɗi hampe ifi yaꞌi⁠ ⁠: ɗi ay faaɗ too ka, soɗ peba misahi, tam fikiɗ fa filiɓ kíi kí ƴíméeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Saŋ ñeyaꞌ yëeddëꞌ yí ƴaaha a i won kay caak waareye ɓëewë Uni Neba. ");
INSERT INTO ndv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ɗi wonte af gëernëer Erot ɓal, naafa naaf ri Erojat ɓeleɓ ɓahii ra a iñi ɓossi caakki kayya paŋ ri ra. ");
INSERT INTO ndv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erot pagilte bi luk ƴaa ɓos, ɗi ɓekrohte Saŋ kasu. ");
INSERT INTO ndv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Saŋ húmú bëtíssé ɓëewë húmú daaha ra ɓéeɓ, ɗi bëtsëelëhté Yéesú në ɓal. Na húmú ɗaŋ Yéesú bee na bëtsú rí rë, sun-Koo kúnsëhté, ");
INSERT INTO ndv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ruuh-Peseŋ céppé sun fi man bëdú nen, antee lah uni ɗúhëꞌté sun won tih⁠ ⁠: «⁠ ⁠Daa fu Koy soꞌ⁠ ⁠! Mi fahaꞌte ro níi fahaꞌ⁠ ⁠! Keeñ soꞌ sosse ɗoo na níi sos⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na dal Yéesú légéyí rë, ɗeef ri waɗti lahaa kíil sabay éeyë (30). Ɓëewë húmú habuu biti ɗi koy Suseef fi Héelí. ");
INSERT INTO ndv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Héelí koy Matat fi Léwí⁠ ⁠; Léwí koy Melki fi Yanay⁠ ⁠; Yanay koy Suseef ");
INSERT INTO ndv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","fi Matacaas⁠ ⁠; Matacaas koy Amos fi Nahum⁠ ⁠; Nahum koy Esli fi Nagaay⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaay koy Maat fi Matacaas⁠ ⁠; Matacaas koy Séméyín fi Yoseh⁠ ⁠; Yoseh koy Yoda ");
INSERT INTO ndv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","fi Yowanan⁠ ⁠; Yowanan koy Resaa fi Sorobabel⁠ ⁠; Sorobabel koy Salasiyel fi Nérí⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérí koy Melki fi Adi⁠ ⁠; Adi koy Kosam fi Elmadam⁠ ⁠; Elmadam koy Er ");
INSERT INTO ndv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","fi Yéesú⁠ ⁠; Yéesú koy Eliyeseer fi Yorim⁠ ⁠; Yorim koy Matat fi Léwí⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Léwí koy Simewoŋ fi Yudaa⁠ ⁠; Yudaa koy Suseef fi Yonam⁠ ⁠; Yonam koy Eliyakim ");
INSERT INTO ndv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","fi Meleyaa⁠ ⁠; Meleyaa koy Menna fi Matataa⁠ ⁠; Matataa koy Natan fi Dawit⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawit koy Yéssée fi Obet⁠ ⁠; Obet koy Búus fi Sala⁠ ⁠; Sala koy Nahson ");
INSERT INTO ndv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","fi Aminadap⁠ ⁠; Aminadap koy Atmin fi Arni⁠ ⁠; Arni koy Hesron fi Peres⁠ ⁠; Peres koy Yudaa ");
INSERT INTO ndv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","fi Yakop⁠ ⁠; Yakop koy Isaak fi Abraham⁠ ⁠; Abraham koy Terah fi Nahoor⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoor koy Sérúk fi Réwú⁠ ⁠; Réwú koy Pelek fi Ebeer⁠ ⁠; Ebeer koy Selaa ");
INSERT INTO ndv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","fi Kenan⁠ ⁠; Kenan koy Arpaksat fi Sem⁠ ⁠; Sem koy Nowe fi Lemek⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek koy Matusalem fi Henok⁠ ⁠; Henok koy Yeret fi Mahaleyel⁠ ⁠; Mahaleyel koy Kenan ");
INSERT INTO ndv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","fi Enos⁠ ⁠; Enos koy Set fi Aadama⁠ ⁠; Aadama koy Koope. ");
INSERT INTO ndv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yéesú líiffé a Ruuh-Peseŋ, kolohte laahi Yurdeŋ, Ruuha kúɗté rí na ɓen ri luufa. ");
INSERT INTO ndv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ɗi hompe dín fë waal sabay iniil (40) Seytaane na saam fíirí. Waalli ƴaaha ɓéeɓ, ɗi túmëy yin loyi níi yaabi misikke míllëꞌté ríi ham. ");
INSERT INTO ndv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seytaanaa won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Hena biti fu Koy Koope kaah raa, túuƴé laꞌi bee yíssëh ñam.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Bíníyúté Téerëe bitih⁠ ⁠: “Ow pesaꞌ ñam neh kut.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seytaanaa kúɗté rí sun fi daŋi utte, yíppée ríi teeɓ ginna feey fa ɓéeɓ, ");
INSERT INTO ndv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","antee rii won tih⁠ ⁠: «⁠ ⁠May roo yeɗ nguur ka a alal ma ginni ƴee ɓéeɓ⁠ ⁠; wa ɓéeɓ ee yaꞌ soꞌ, te mi mín wëe on ɓëyí neɓaꞌ soꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kon fu jaamiyoh soꞌ raa, fu lahaꞌ wa ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Bíníyúté Téerëe bitih⁠ ⁠: “Fay ƴekre Koo-Yíkëe daa Koope fu ra te fay jaamiyee ri kut.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Filoon fi baaha, Seytaane kúɗté rí Yerusalem, cëgíɗté rí jibi Faam fi gaani Koope, antee rii won tih⁠ ⁠: «⁠ ⁠Hena biti fu Koy Koope kaah raa, yeɗɗee feey. ");
INSERT INTO ndv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bíníyúy Téerëe biti Koope ay nah malaaka yi níidú woo⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bíníyúté biti ɓal⁠ ⁠: “Wa ay roo meeɓ teŋel, toñeh fay kabinee laꞌ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Bíníyúté Téerëe bitih⁠ ⁠: “Koo-Yíkëe daa Koope fu, ngana saam olsohi.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Filoon fi bee ñeyaꞌ ri pagaɗɗa ra ɓéeɓ na saam fíirí Yéesú rë, Seytaane saañce na séhíɗ waal kay. ");
INSERT INTO ndv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yéesú kolaꞌ daaha, ñéerëꞌté a doolii Ruuh-Peseŋ nimilte Galile. Tiyi hente lëyëŋ deyi baa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ɗi húmú yëeddëꞌ filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra, ɓëewë ɓéeɓ kañe ri. ");
INSERT INTO ndv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lahte bis, Yéesú kolohte saañce Nasaret fa koraꞌ ri ra. Lahaꞌ bisa na hílsúu yëwúɗɗë rë, ɗi payte haalte tígë na ɗaguu Koope ra ti di na húmú pagaꞌ ri merees nen⁠ ⁠; ɗi kolohte jaŋii Unni Koope. ");
INSERT INTO ndv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ɗi yerute téerëe bíní yonente Isayii ra. Kúnsëꞌ rí téerëe rë, ɗi otte tígë bíníyú unna na húmú saam ri ƴee ra⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«⁠ ⁠Ruuhi Koo-Yíkëe ee soo na, ɗi falte soꞌ waarii ñëkíɗɗë Uni Neba, ɗi wolte soꞌ woni ɓëewë téƴú kasu ra biti wa ay yeɗɗu, woni búumíɗɗë biti wa ay ot a sëmlëꞌí ɓëewë moklu ra. ");
INSERT INTO ndv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ɗi wolte soꞌ woni ɓëewë biti kíilë nay waa teeɓe Koo-Yíkëe naaꞌ-keeñ ra ee ac ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jaŋiyaꞌ ri unna níi wocce ra, Yéesú kúnté téerëe, nimiliɗte ri ɓëeꞌ në tooppitoh yii leŋke tígë na ɗaguu Koope ra, tookke ay yëeddée. Ɓëewë húmú daaha ra ɓéeɓ na yeelu ri. ");
INSERT INTO ndv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Woteh fee Koo beh, Unnee téerëe keluu ron ƴaa ra, lahte kah-kah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Keeññi ɓëewë ɓéeɓ sosse Yéesú në te wa éemúté unni neɓɓa won ri ra, na wonu tih⁠ ⁠: «⁠ ⁠Añcaŋ yaa koy Suseef kep ee⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mi yúhté biti ɗon ay soo won léehí beh⁠ ⁠: “Ɗo fi naahee, paƴe afu⁠ ⁠!” Ɗon ay soo won biti ɓal⁠ ⁠: “Fun keluute iña paŋ fu Kafarnawum ra ɓéeɓ⁠ ⁠; page mani wa filiɓ ginu noo, fun ot⁠ ⁠!”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ɗi ɓaatte won tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: yonente na síkíríih gina dék rí rë. ");
INSERT INTO ndv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Cëe mi won ron⁠ ⁠: lante biti ɓeleɓɓi ƴaalli wa húlúté húmú caakute Israyel na pesaꞌ yonente Éelí rë. Bín fë, Koo húmú toɓay níi hente kíil éeyë a caan, tahte yaabi misikke laɓpe gina ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Añcaŋ, Koope húmú wolay Éelí ow yínë sah ɓeleɓɓi ƴaa na⁠ ⁠; ɗi wol ri bi dék Sareptaa di deyi Sidon, te ri yëwúɗ neh. ");
INSERT INTO ndv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Guuñiɗ caak ɓal húmú Israyel na pesaꞌ yonente Élísée rë⁠ ⁠; añcaŋ, ow yínë sah waa na guuña laday faana⁠ ⁠; faan Naamaan fa dék Sírí rë kut daa lan guuña, te ri yëwúɗ neh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Keluu ɓëewë húmú tígë na ɗaguu Koope ra unni ƴah, keeññi wa ɓéeɓ haayte níi haay. ");
INSERT INTO ndv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wa koluute, ɗúhrúté Yéesú gina, kúrúté rí af daŋa yípúu gin wa ra, na fahuu yeñi feey. ");
INSERT INTO ndv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ndaa ri húussé leelii wa saañce. ");
INSERT INTO ndv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yéesú lahte Kafarnawum di Galile. Bisa na hílsúu yëwúɗɗë rë, ɗi na yëedíɗ ɓëewë yee won Téerëe rë. ");
INSERT INTO ndv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wa éemúté ɗee na yëeddëꞌ rí rë, bi na yëeddëꞌ rí a sañ-sañ. ");
INSERT INTO ndv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ɗeef ɓëyí lahaꞌ yébítëh húmú waa na, di tígë na ɗaguu yëwúɗɗë Koope ra, ɗi foŋke sun won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«⁠ ⁠Yéesú fí ɓëy Nasaret, fu fahaꞌ paŋi fun yih⁠ ⁠? Fu ac múklí fun a⁠ ⁠? Mi yúh rë⁠ ⁠! Daa fu Ɓëyí selaa ɗúhëꞌ Koope na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tígí daaha, Yéesú digiɗte uni won afa tih⁠ ⁠: «⁠ ⁠Héddée te fu yeris ɓëyí beh⁠ ⁠!⁠ ⁠» Yébítëh fë kéeníɗté ɓëeꞌ feey fíi ɓëewë ɓéeɓ, yerisse ri te yin misikay ri. ");
INSERT INTO ndv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɓëewë ɓéeɓ éemúté, wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Bee wonaɗ mën ɗí kan⁠ ⁠? Ɓëyí bee túuƴëꞌ yébítëh yë a sañ-sañ a doole⁠ ⁠: ɗi túuƴ wë yeris ow raa, wa yeris ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tii Yéesú yíppée hen lëyëŋ deyi baa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yéesú ɗúhté tígë na ɗaguu yëwúɗɗë Koope ra, saañce faam Simoŋ. Lahaꞌ ri ra, ɗeef jér fëníɗté pacool Simoŋ ɓeleɓ, faana tampe níi ti paloɓ nen. Yéesú ɗagute paƴi. ");
INSERT INTO ndv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tígí daaha, ɗi sígímpé sun fi jérdë, digiɗte uni túuƴcé tami faana yeris ɗi. Tami faana yerisse ɓelaa, ɗi yíppée koloh na tooppitoh wa. ");
INSERT INTO ndv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Haalaꞌ naꞌ ra, ɓëewë lahu jéríɗ rë ɓéeɓ, a di míntí man jérë, komute wa Yéesú. Ɗi tíkké wë ɓéeɓ yaꞌ paƴce wa. ");
INSERT INTO ndv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","I yébítëh yeɗɗute jéríɗ caak ɓal, na fogu wone tih⁠ ⁠: «⁠ ⁠Daa fu Koy Koope⁠ ⁠!⁠ ⁠» Ndaa Yéesú digiɗte uni sun fi wa, kaddaꞌte waa won, ndah wa fi ƴaa yúhúté biti daa ri Buura Koo fal ri ra, te ɗi fahaay biti daa wa wonun yii baaha. ");
INSERT INTO ndv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ladaꞌ Koo ra, Yéesú ɗúhté gina, saañce tígí ɗaayte. Ow caak koluute saami. Oluu wa ri ra, wa na fahuu hami, kaaꞌ ri saañ hel wa. ");
INSERT INTO ndv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ndaa ri won wa tih⁠ ⁠: «⁠ ⁠Mi waɗtee pay ginni kayya ɓal, mi waare wa Uni Nebi Nguur ki Koope, ndée yii baaha daa tah Koope wol soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ɗaaha, ɗi kolohte na waare ílíƴƴë na ɗaguu yëwúɗɗë Koope Yúdée rë. ");
INSERT INTO ndv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lahte bis, Yéesú húmú ɓúk laahi Senesaret, ow caak ayute na yejantuu hëbísí, na fahuu síkírëhí Unni Koope. ");
INSERT INTO ndv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ɗi otte gaal ana ɓúk laaha, ɗeef seeɓoh ya cépúté na hosu mbaalli wa. ");
INSERT INTO ndv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tígí daaha, ɗi haalte gaali yínëe, bi Simoŋ daa lahaꞌ ri, nahte ri yeñi gaala filiɓ mulaa, ɗi hécëh ƴutuuɗ ɓúk laaha. Ɗi tookke filiɓ na yëedíɗ ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wocaꞌ ri wona ra, ɗi won Simoŋ tih⁠ ⁠: «⁠ ⁠Kúré gaala tígí nooɗte, ɗon anti bac mbaallon, ɗon seeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoŋ won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, yee mínú fun ra fun pagute rí elga ɓéeɓ, fun habuy yin. Ndaa hém daa fu nah soꞌ paŋi raa, fun ay bac mbaalla.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wa yeeluutee bac mbaalla. Jénnë habu wa ra caak caako níi mbaalla dalte pas. ");
INSERT INTO ndv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tígí daaha, wa heegute ɓëewë húmú gaali yínëe rë yaꞌ, wa ac habraꞌi wa. Ayuu wa ra, wa líifrúté gaalli ana ya jén níi gaalla tallaꞌ honoh. ");
INSERT INTO ndv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Olaꞌ Simoŋ Peer yii bah, ɗi yeɗɗohte ƴekke fíi Yéesú, won ɗi tih⁠ ⁠: «⁠ ⁠Ɗamaay mi leɓee ro Yíkëe, ndée mi bakaaroh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoŋ a ɓëewë ɓani húmú rë ɓéeɓ tíitúté, bi caak jénnë habu wa ra níi caak. ");
INSERT INTO ndv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saak a Saŋ koyyi Sebede, ƴee wani Simoŋ boku légéy rë tíitúté ɓal. Ndaa Yéesú won Simoŋ tih⁠ ⁠: «⁠ ⁠Ngana tíit⁠ ⁠! Dalaꞌte woteh, fay soo tasee saamiɗ ow.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tígí daaha, wa teerute, helute iña lahuu wa ra ɓéeɓ ñeyute tal Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Lahte bis, Yéesú húmú gin-taah deyi baaha, ɓëyí faana yahte a guuñ púlëhté ɗii na. Olaꞌ ɓëeꞌ Yéesú, ɗi yeɗɗohte kotti líhëhté feey, na ɗaŋ ri won tih⁠ ⁠: «⁠ ⁠Ɓahaa, mi yúhté biti fu mín sëe paƴ mi haalaat ɓëewë në. Fii soo rii pagiɗ a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yéesú yeɗte yaꞌi tíkké sun fi, won ɗi tih⁠ ⁠: «⁠ ⁠Mi tahte ɗaŋu. Yípée wah⁠ ⁠!⁠ ⁠» Guuña yíppée lan faan ɓëeꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yéesú kaddaꞌte ri ɓílíɗ won ɗi tih⁠ ⁠: «⁠ ⁠Ngana won ow yii beh. Paye seeƴoha na ɗi olsoh ro, te fu yeraꞌ saraha nahaꞌ Mëyíis rë fu púusëh, teeɓi ɓëewë ɓéeɓ biti fu lante.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Filiɓ fi baaha ɓéeɓ, tii Yéesú ɓaattee hen lëyëŋ⁠ ⁠; ow caak na ayu síkírëhí, jéríɗɗë filiɓ fi wa nahee paƴ. ");
INSERT INTO ndv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ndaa hom níi rëe Yéesú saañ tígí ɗaayte, ɗi hom dín fë ɗage Koope. ");
INSERT INTO ndv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lahte bis, Yéesú hom yëeddëꞌ, i fariseŋ a i yëeddëh yí kootii Mëyíis maasuute⁠ ⁠; wa ɗúhúu ginna luufa di Galile a Yúdée, lahte ƴi ɗúhúu Yerusalem ɓal. Doolii Koo-Yíkëe húmú Yéesú në, tahte ri na paƴ jéríɗɗë. ");
INSERT INTO ndv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lahte ɓëewí kúrú lëfëñíɗ sun dil ayute, na fahuu haal faam fa, komi ri Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ndaa wa yíih tígë nay wa rii ñéyré rë af caagi ɓëewë. Wa míllúu ríi lëwíɗ sun fi lasa, saamute buut anutee yëellíɗ lëfëñídë hom sun fi dila ra fíi Yéesú leelii ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Olaꞌ Yéesú ɗee gémúu wë rí rë, ɗi won lëfëñídë tih⁠ ⁠: «⁠ ⁠Ƴaal kowa, fu baalute bakaaɗɗu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yëeddëh yí kootii Mëyíis a fariseŋŋa na wonu nuffi wa tih⁠ ⁠: «⁠ ⁠Ɓëyée na sol Koope bee ra wa⁠ ⁠? Daa mín baalaꞌ bakaaɗ henay Koope⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bi yúh Yéesú yee nuffi wa, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon níɓúu yii baa ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yi daa lukki yooɓ biti mi won ɓëyí beh⁠ ⁠: fu baalute bakaaɗɗu, mbée kolee fu tíl⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Woteh ɗon ay yúh biti soꞌ mi Koy-ɓëeꞌ, mi lahte sañ-sañi baalaa mi bakaaɗ feey fi beh.⁠ ⁠» Ɗi won lëfëñídë tígí daaha tih⁠ ⁠: «⁠ ⁠Kolee fu pon dilu, fu saañ faam. Daa mi túuƴ ɗë rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lëfëñídë yíppée koloh fíi ɓëewë ɓéeɓ, ponte dila húmú fënɗú rí rë, na saañ faam, na kañ Koope. ");
INSERT INTO ndv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɓëewë ɓéeɓ éemúté níi éem, na kañu Koope ñéerëꞌté a tíit na wonu tih⁠ ⁠: «⁠ ⁠Bee woteh bee lëhírëy.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Filoon fi baaha, Yéesú ɗúhté, otte yeekoh túm tookke tígë në légéyëꞌ rí rë⁠ ⁠; ɗi hínú Léwí. Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Kolee fu ñee tal soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Léwí yíppée koloh, yerisse ɓéeɓ, wa ñéerúuté. ");
INSERT INTO ndv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Léwí antee cëgíɗ ndaje faami, teeriyohi Yéesú. Wani i yeekoh túm caak a i ow kay daa boku ñama. ");
INSERT INTO ndv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseŋŋa a yëeddëh yí kootii Mëyíis, ƴee nonu waa na ra, bi neɓaay wa yaa, wa wonu taalibe yi Yéesú tih⁠ ⁠: «⁠ ⁠Yi tah ɗon na boku ñam a yeekoh yi túmë a bakaaroh ya⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Jéríɗɗë daa sohluu paƴoh ndaa ɓëewë wahu ra neh. ");
INSERT INTO ndv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bakaaroh ya daa tahu mi koloh nda wa lof pesaɗ, ndaa ɓëewë júɓú rë neh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","I fariseŋ wonu Yéesú tih⁠ ⁠: «⁠ ⁠Taalibe yi Saŋ na caakuu oor, ɗage⁠ ⁠; ƴi fariseŋŋa henuu ɗaaha ɓal, ndaa taalibe yu dékúu ñam a han.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Bee kílëek lahte ra, ɗon habuu biti ɗon mínú oorloh kooƴƴa, te ɗeefa ɓëeꞌ kooɗ ɗa lísë leelii wa a⁠ ⁠? Ɗon halaatuy ri maan⁠ ⁠? Funi taalibe yi soꞌ nék madu a ɓëeꞌ kooɗ baa ra hom a kooƴƴi ra nen. ");
INSERT INTO ndv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bis ay lah, mi këllú leelii wa. Tígí daaha, wa ay oor.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yéesú wonte wa léehí bee ɓal⁠ ⁠: «⁠ ⁠Ow na leceh nuf búuɓ has daafaꞌ ri búuɓ kíilíɗ. Henun ɗaaha raa, búubí hasa ay lah ɗaɗ, te nuf píisí hasa ii ñéerëꞌ a búubí kíildë. ");
INSERT INTO ndv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Te ow na soreh béeñí hasi anti dal poosaꞌ filiɓ mbúus hun kíilíɗ. Henun ɗaaha raa, béeñë ay poo mbúusë, wa yúfëh, mbúusë yah. ");
INSERT INTO ndv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Béeñ has kay, soruu mbúus has. ");
INSERT INTO ndv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɓëyí meeɗte hani poosaꞌte na faheeh han has⁠ ⁠; ɗi habaꞌ biti hana poosaꞌ ra daa lukki neɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bisa na hílsúu yëwúɗɗë rë ín, Yéesú a taalibe yi ñeyu waali húus filiɓ i meey bele. Taalibe ya homu waala, yabute na kodu yaaŋnga yi belaa, na ɓuluñu na húñú. ");
INSERT INTO ndv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lahte fariseŋŋi wonu wa tih⁠ ⁠: «⁠ ⁠Haalaꞌ yi níi ɗon na pagu yii Kootaa kaddaꞌte ri bisa na hílsúu rë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon yúhú yee húmú paŋ Dawit bee yaaɓuu ɓani ɓëewí rë maan⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ɗi húmú haal Faam Koope, ñampe na mbúurëe yefu fíi Koope ra, ƴee seeƴoh ya kut daa waruu naa ñam ra, yeɗte na ɓëewí, wa ñamute ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yéesú ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Soꞌ mi Koy-ɓëeꞌ, daa mi lah sañ-sañ sun fi bisa na hílsúu rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lahte bis hílsëe kay, Yéesú haalte tígë na ɗaguu yëwúɗɗë Koope ra, yampe na yëeddëꞌ. Ɓëyí yaꞌi ñamaa fa ɓeedohte húmú në. ");
INSERT INTO ndv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yëeddëh yí kootii Mëyíis a fariseŋŋa na olsuu Yéesú nda ri ay paƴ ow bisa na hílsúu rë, nda wa lah yii yabun wa ri. ");
INSERT INTO ndv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ndaa bi yúh rí yee nuffi wa, tígí daaha ɗi won ɓëeꞌ tih⁠ ⁠: «⁠ ⁠Kolee fu caŋ fíi ɓëewë ɓéeɓ deh.⁠ ⁠» Ɓëeꞌ kolohte caŋke daaha. ");
INSERT INTO ndv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yéesú antee waa won tih⁠ ⁠: «⁠ ⁠Cëe mi meel ron⁠ ⁠: Kootaa nahaꞌ yi bisa na hílsúu rë⁠ ⁠? Paŋ yin wun mbée paŋ yin ɓos⁠ ⁠? Sëmlëꞌ ow mbée yeris ɓëeꞌ húl⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ɗi yeelte ɓëewë ɓéeɓ níi, antee won ɓëeꞌ yaꞌa ɓeedoh ra tih⁠ ⁠: «⁠ ⁠Yere yaꞌu⁠ ⁠!⁠ ⁠» Ɓëeꞌ yeɗte yaꞌi, yaꞌa yíppée wah koloŋ. ");
INSERT INTO ndv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ndaa keeññi ɓëewë ñéerúuy a Yéesú rë haayte níi wa na peenu yee nay wa rii mínée paŋ ra. ");
INSERT INTO ndv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lahte bis, Yéesú lappe sun daŋ ɗaŋi Koope, ɗi ɗaŋke elga ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ladaꞌ Koo ra, ɗi dëekké taalibe yi, tanisse na ow sabboo a ow ana, falte wa apootar. ");
INSERT INTO ndv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tii yi wa daa wa ƴeh⁠ ⁠: Simoŋ fa Yéesú yeɗ ri tii Peer ra a Anndere koy-yaafi, Saak a Saŋ, Fílíp, Bartalemi, ");
INSERT INTO ndv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maccëe, Toomaa, Saak fi Alfe, Simoŋ fi jammbaara, ");
INSERT INTO ndv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudaas fi Saak a Yudaas Iskariyot fa míllëꞌtée yaay Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yéesú kolohte ɓani apootarri na cépú daŋa. Lahaꞌ ri tígí yéeddëꞌté di araal daŋa ra, ɗi caŋke daaha ɗeef taalibe caak húmú në. I ow caak kay húmú në ɓal⁠ ⁠: ƴee ɗúhúu Yerusalem a ginni kayya Yúdée ɓéeɓ, ƴee i gin-taah ɓúk kísí fë⁠ ⁠: Tíir a Sidon. ");
INSERT INTO ndv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wa húmú ayu síkírëhí Yéesú a paƴohi jérrí wë. Ƴee yébítëh na ham wa ra wahute ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɓëewë ɓéeɓ na saamu leɓi faan Yéesú af biti lahte yii na ɗúhëꞌ ɗii na paƴe wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yéesú yeelte taalibe yi tígí daaha, won wa tih⁠ ⁠: «⁠ ⁠Ɗon lahute sos-keeñ ɗon fi ñëkíɗɗë⁠ ⁠: daa ron lahuu Nguur ki Koope. ");
INSERT INTO ndv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ɗon lahute sos-keeñ ɗon fa yaaɓu ra⁠ ⁠: ɗon ay lah njélí doyte. Ɗon lahute sos-keeñ ɗon fa na looyu ra⁠ ⁠: ɗon ay lah neɓ. ");
INSERT INTO ndv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ɗon lahute sos-keeñ biti ɓëewë kaaꞌ ron, tík ɗon dín, sol ron te wa habaꞌ biti ɗon ow ɓos af soꞌ mi Koy-ɓëeꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dëmíi ɗon bec ndah sos-keeñ biti iñƴaaha lah⁠ ⁠: waafi mitte ín ɗon seh sun-Koo ra. Yúhí biti caacci wa húmú mokluu yonente ya ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ndaa mas ɗon fi yíkëe yí alalla⁠ ⁠: ɗon pesute nebi ron níi wocce⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mas ɗon fa lahu njélí doyte ra⁠ ⁠: ɗon ay yaaɓ. Mas ɗon fa neɓluu ra⁠ ⁠: ɗon ay lah dígëem ɗon looy. ");
INSERT INTO ndv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mas biti ɓëewë ɓéeɓ wone wun sun fon. Caacci wa húmú henuu yonente yi paɗɗah ya ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon fa síkírúu sëꞌ ƴee ra, mi won ɗon tee⁠ ⁠: lah fëhíi kaaꞌoh yon ɗon pagiɗ haaꞌoh yon yin wun⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","yéeníyíi ɓëewë në cuju ron ra yin wun, ɗon ɗagiɗ ɓëewë na moklu ron ra. ");
INSERT INTO ndv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ow laɓ ro mbeƴ, lah yere ri kakaabi yínëe. Ow naaf sabidooru, ngana kaddaꞌ ri ɓeyi búubí jíitlëe ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɓëyí ɗaŋ ro one ri. Ɓëyí ɓeɓ yii daa fu lahaꞌ ri, ngana meel ɗi ri. ");
INSERT INTO ndv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Iña fahuu ron biti ɓëewë pagiɗ ɗon wa ra, lah pëgíríi wë ɓëewí kayya ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«⁠ ⁠Ɗon fahuun ɓëewí fahuute ron kut raa, ɗon séentúu në waafi mën ɗíh⁠ ⁠? Bakaaroh ya sah fahuute ɓëewë daa fahuu wa ra. ");
INSERT INTO ndv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ɗon pagrun yin wun ɓëewë në pagiru ron yin wun kut raa, ɗon séentúu në waafi mën ɗíh⁠ ⁠? Bakaaroh ya sah henuu ri ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te ɗon wëtɗún ɓëewë habuu ron biti kut wa ay ron yíníl rëe, ɗon séentúu në waafi mën ɗíh⁠ ⁠? Bakaaroh ɓal na wëtíɗ bakaaroh, séentée biti ri ay yínlú teemi yee wëtɗëꞌ rí rë. ");
INSERT INTO ndv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ɗaa neh⁠ ⁠! Lah fëhíi kaaꞌoh yon, ɗon pagiɗ wa yin wun te ngënë séentíi yíníl biti ron wëtɗëꞌ. Hen ɗaaha raa, waafon ay gaan. Ɗon ay teeɓee biti ɗon koyyi Koope fa sunaa-sun ɗaaha, ndée keeña naaꞌte ɓëewë në gérmíh a ƴee ɓosu ra na. ");
INSERT INTO ndv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Di naaꞌaꞌ Boffon keeñ níi naaꞌ, lah mëdí ɗaaha nen naaꞌ-keeñ. ");
INSERT INTO ndv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ɗon heefuy ow raa, Koope ii ron heef ɓal⁠ ⁠; ɗon habruy ow yin raa, Koope ii ron habiɗ yin ɓal⁠ ⁠; lah bëelíi, Koope ay ron baal. ");
INSERT INTO ndv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ëní ɓëewí kayya, Koope ay ron on⁠ ⁠: boonnon ay túmú níi líif, ɗegu níi yúfée. Ɗee na natɗuu ɗon ɓëewë rë, Koope ay ron natɗee ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yéesú ñeyaatte wa léeh won wa tih⁠ ⁠: «⁠ ⁠Búumíɗ mínéh nook búumíɗ neh a⁠ ⁠? Lahaa ɗaaha raa, wa ɓéeɓ ana ay keen ngas. ");
INSERT INTO ndv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yoodoh lukeh yëeddëhí mín⁠ ⁠; ndaa yoodohi yoon níi ɗúmël ɓéeɓ ay mín ti yëeddëhí nen. ");
INSERT INTO ndv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«⁠ ⁠Fu olsoh yi losa íl koy-yaafu te fu kénsëey dúuñë ílú⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɗo fa olay sah dúuñë ílú rë, fu mínëꞌ won koy-yaafu biti fay rii nísíɗ losa ílí ɗíh⁠ ⁠? Wonu teem ɓúkú⁠ ⁠! Nísé dúuñë ílú níi íllú lan paaƴ, fanti mín nís losa íl koy-yaafu. ");
INSERT INTO ndv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«⁠ ⁠Tal kilki lahte njiriñ na líméh koy kilki lahay njiriñ, te tal kilki lahay njiriñ na líméh koy ki lahte njiriñ. ");
INSERT INTO ndv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tal kilik yúhsúu koy ka⁠ ⁠: ñoltok na líméh koy sún te tal hak na líméh koy ɓaꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɓëyí naaꞌte keeñ hom wonaꞌ yii wunte ndah keeñi naaꞌa lahaꞌ ri ra⁠ ⁠; ɓëyí ɓosse keeñ nék hom wonaꞌ yii ɓosse ndah ɓosi keeña homaꞌ ri ra. Yii won ow ɓéeɓ ɗúhëꞌ rí keeñi kaah. ");
INSERT INTO ndv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«⁠ ⁠Yi tah ɗon dékée dëekëꞌí sëꞌ Yíkëe te ɗon na pëgíh iña na won mi ron ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cëe mi teeɓ ron ɗee na man ɓëyí na ac soo na ɓéeɓ, na síkírëh unna na won mi ra te pagaꞌ wa ɗaaha⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ɗi madaꞌ a ɓëyí saañ taɓahe faam, hacce feey fa níi daɓpe ngaŋa, yíppé taɓaha sun. Ayaꞌ mbënë më rë, mulaa na hút na laɓoh faam fa, ndaa mínéh ríi bëp bi híin taɓaha. ");
INSERT INTO ndv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ndaa ɓëyí síkírëh sëꞌ te anti ñeyay woni soꞌ, ɗi madaꞌ a ɓëeꞌ taɓah faami te hacay dalaa ra. Ayaꞌ mulaa laɓohte faam fa ra, ɗi yíppée bëp, poysaꞌte ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wocaꞌ Yéesú woni ɓëewë iña ri fahaꞌ waa won ra ɓéeɓ, ɗi kolohte saañce Kafarnawum. ");
INSERT INTO ndv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Daaha, lahte kélfë soldaari lahte súrgíi ri foŋkote ri níi foŋko. Súrgëe antee jér níi na ŋaatoh. ");
INSERT INTO ndv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kelaꞌ kélfëe ban fi Yéesú rë, ɗi wolte i ɓaha yëwúɗ ɗii na, woni biti ɗi ac sëmlëꞌ súrgíi kúl kë. ");
INSERT INTO ndv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lahuu wa Yéesú në rë, wa caguute ri na ɗagu wonu tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ wol fun ɗoo na ra cal habraꞌ, ");
INSERT INTO ndv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ndée ɗi fahaꞌte yen fi yëwúɗɗë, te daa ri taɓahroh tígë na ɗaguu ɓëy gina Koope ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yéesú kolohte ñéerëꞌté a wa. Leɓuu wa faam fa ra, kélfíi soldaara wolte i kooƴ ɗii na, lah wa woniɗ ri unni ƴeh⁠ ⁠: «⁠ ⁠Ɓahaa, ngana mokil afu, mi caleh fu haale faam soꞌ⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","daa tah mi habaꞌ biti mi ƴinte caŋi fíyú. Wone un yínë kut, súrgíi sëꞌ ay wah. ");
INSERT INTO ndv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Fu ot mi won ɗo ri, biti soꞌ mi bee mi lahte kélfë yí daa paaꞌuu soꞌ sun, te mi kélfë i soldaar ɓal. Mi won ow yínë waa na gété rëe, ɗi saañ. Mi won ow kay aye raa, ɗi ac. Te mi won súrgíi sëꞌ page yii bee raa ɓal, ɗi paŋ yaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kelaꞌ Yéesú unni kélfíi soldaara ra, ɗi éempé woni. Ɗi yíssëhté dúukëlí ɓëewë ñeyu tali ra na, won wa tih⁠ ⁠: «⁠ ⁠Mee ron won ra ee⁠ ⁠: mi ëllëy ɓëyí gémëꞌté ɗeh⁠ ⁠! Tali Israyel sah, mi ëllëy mani na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nimiluu kooƴƴa wolu ra faam kélfëe rë, wa ɗeefu súrgëe wahte. ");
INSERT INTO ndv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Filoon fi baaha, Yéesú kolohte na saañ gin-taaha na wonuu Nayin ra, taalibe yi a i ow caak ñéerúuté a ri. ");
INSERT INTO ndv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Leɓaꞌ ri haalaani gina ra, lahte ɓúudé fí na kúrú hacaa yin. Húldë húmú koy yínë yaafi na⁠ ⁠; ɗi fi yaafa ƴaala húlté. I ow caak di ɓëy gina na ɓedu yaafa. ");
INSERT INTO ndv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Olaꞌ ɗi fi Yíkëe ɓelaa ra, keeña ɗúmpé ɗii na, ɗi won ɗi tih⁠ ⁠: «⁠ ⁠Yeɗɗe looya.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ɗi antee leɓoh, tíkké yaꞌ yi jaada, ɓëewë kúrú ɓúudé fë rë cagute. Ɗi won ɓúudé fë tih⁠ ⁠: «⁠ ⁠Kolee ƴaal kowa⁠ ⁠! Daa mi túuƴ ɗë rí⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Húldë yíppée koloh, tookke na won. Yéesú won yaafa tih⁠ ⁠: «⁠ ⁠Koohu abeh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɓëewë ɓéeɓ tíitúté níi tíit, wa na kañu Koope wonu tih⁠ ⁠: «⁠ ⁠Yonente gaan acce yen na⁠ ⁠; Koope acce sëmlëꞌí ɓëewí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ɓëy Yúdée a ɓëy deyi baa ɓéeɓ keluute yee paŋ Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Taalibe yi Saŋ ɓíllúté kélfíi wë iña na paŋ Yéesú rë ɓéeɓ. Tígí daaha, Saŋ dëekké ow ana waa na, ");
INSERT INTO ndv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","wolte wa ɗi fi Yíkëe në, meeli nda daa ri Sëmlëhë në séentúu rë mbée ɓëewë waɗti sehun ow kay. ");
INSERT INTO ndv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lahuu taalibe yi Saŋ Yéesú në rë, wa wonu ri tih⁠ ⁠: «⁠ ⁠Saŋ Batis daa wol fun meelu nda daa fu Sëmlëhë në séentúu rë mbée ɓëewë waɗti sehun ow kay⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Guuttaa baaha, Yéesú paƴce na ow caak⁠ ⁠: i jéríɗ, i misikiɗ, ɓëewí lahuu yébítëh, a i búumíɗ. ");
INSERT INTO ndv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɗi antee won taalibe yi Saŋ tih⁠ ⁠: «⁠ ⁠Nímílí Saŋ na ɗon ɓílíɗ rí iña olu ron a ƴee keluu ron ra. Wëní rí biti búumíɗɗë yeelute, lëfëñíɗɗë koluute, guuñiɗɗa wahute, likiɗɗa ee keluu ra, ɓëewë húlú rë këllúté ɓúudé, ñëkíɗɗë keluute Uni Neba. ");
INSERT INTO ndv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ɓëyí af iñi soꞌ taheh ɗi yeris ngémí, ɓëyí baa lahte sos-keeñ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bi na suu ɓëewë húmú wolu ɗii na ra, Yéesú yampe na goneel a dúukëlí ɓëewë yii leŋke Saŋ Batis na, meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗon húmú payu olsoh yi luufa⁠ ⁠? Tal bëhëerí ngilaaw ma na jaay ri neh maan⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kon ɗon húmú payu olsoh yih⁠ ⁠? Ɓëyí ɓekoh búuɓɓí wunte neh maan⁠ ⁠? Yíkëe yí búuɓɓí wunna na pesu pesi neɓpe ra oluu faam buur. ");
INSERT INTO ndv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mantee, ɗon húmú payu olsoh yi luufa⁠ ⁠? Yonente neh a⁠ ⁠? Mee ron won ra biti ɗi yonente kaah⁠ ⁠; ɗi luk sah yonente gaan⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Daa ri ɓëeꞌ në wonaꞌ Koope Téerëe rë bitih⁠ ⁠: “Olsee⁠ ⁠! May wol ow këllëh ɗaɗɗi ro waal.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Mee ron won ra ee⁠ ⁠: lahay ɓëyí límúté feey fi beh te luk Saŋ Batis gaan. Añcaŋ ɓëeꞌ lukki ƴin Nguur ki Koope ra luk ɗii gaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɓëewë ɓéeɓ níi lukaꞌ yeekoh yi túmë húmú síkírúu Saŋ níi rí bëtíssé wë rë tahute biti Koope júɓpé. ");
INSERT INTO ndv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ndaa fariseŋŋa a yëeddëh yí kootii Mëyíis tahuy yee fahaꞌ Koope ra, wa húmú kaaꞌuute biti Saŋ bëtís wë. ");
INSERT INTO ndv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yéesú ɓaatilte won tih⁠ ⁠: «⁠ ⁠May mínée mëldëꞌ ɓëy jamanii bee a yih⁠ ⁠? Wa maduu a yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wa maduu a tuŋki tooku këem, ƴee na wonu affi ƴee tih⁠ ⁠: “Fun poosute, ɗon becuy⁠ ⁠! Fun fogute, ɗon hílípúy fun⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Húmú ayaꞌ Saŋ Batis kaaꞌaꞌte ñam a han ra, ɗon wonu ɗi lahaꞌ yébítëh. ");
INSERT INTO ndv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ayaꞌ soꞌ mi Koy-ɓëeꞌ, mi na ñam maa han ra, ɗon wonu tih⁠ ⁠: “Ëlí⁠ ⁠! Ɓëyí bee ñam a han kut daa afa, te ɗi kooƴaꞌ yeekoh yi túmë a i bakaaroh kay.” ");
INSERT INTO ndv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Añcaŋ ɓëewë ñeyu Unni Koope ra ɓéeɓ olute biti waalli júɓpé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Húmú lahte fariseŋi hínú Simoŋ dëekké Yéesú ñam faami. Yéesú saañce faam fin, lahte wa na ñamu. ");
INSERT INTO ndv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gini baaha, húmú lahte ɓelii ɓosse pesaɗ. Kelaꞌ ri biti Yéesú ín ñam faam fariseŋa ra, ɗi kúɗté bútlí yotuu laꞌa na wonuu albataar ra, bi líiffé a laakkoloñi neɓpe, ");
INSERT INTO ndv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","hompe kotti Yéesú na looy, muun mi na hilsiɗ kotta. Ɗi antee ɓeɓ fen fi moosse wa, fëenté wë, túmpé wë laakkoloña. ");
INSERT INTO ndv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Olaꞌ fariseŋa dëek Yéesú faami ra yii bah, ɗi won nufi tih⁠ ⁠: «⁠ ⁠Ɓëyí bee hena yonente koon, tin ri ay yúh ɓelaa leɓ ɗii na bee ra a pesadi ɓosa homaꞌ ɗi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yéesú won fariseŋa tígí daaha tih⁠ ⁠: «⁠ ⁠Simoŋ, mi lahte yii nay mi roo wone.⁠ ⁠» Simoŋ won ɗi tih⁠ ⁠: «⁠ ⁠Wone mi keloh ɓahaa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Lahte ɓëewí ana yi húmú lahrute ɓëyí në wëtɗëꞌ kabut. Ɓëyí yínëe lahiɗte ri kabut caak, ƴi yínëe luk ƴaaha sabboo. ");
INSERT INTO ndv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bi ow yínë waa na sah mínéh ríi yíníl kabut ka, ɗi baalte wa ɓéeɓ ana. Tígí daaha, fu habaꞌ biti ɓëyí bi di wa fi ƴaaha nay lukee fahaꞌ ɓëeꞌ wëtɗëꞌ rë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoŋ won ri tih⁠ ⁠: «⁠ ⁠Mi habaꞌ ri ɓëeꞌ kabut ki lukki caak ra.⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu won kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ɗi antee yíssëh ɓelaa na, won Simoŋ tih⁠ ⁠: «⁠ ⁠Ole yee paŋ ɓelii bee ra⁠ ⁠! Haalaꞌ mi faamu, fu onay soꞌ muluɓ hosaa kot⁠ ⁠; ndaa ɓelaa hosse kotti soꞌ a muun mi, moosse wa a fen fi. ");
INSERT INTO ndv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fu fëenëy sëꞌ na wodoh fu soꞌ ra⁠ ⁠; ndaa haalaꞌ mi dee níinén, ɓelaa yeɗɗay fëení kotti soꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fu túmëy díw af soꞌ sah⁠ ⁠; ndaa ɓelaa baaɓpe laakkoloñ kotti soꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Daa tah mi won ɗon tih⁠ ⁠: ɗee fahaꞌ soꞌ ri níi fahaꞌ ra daa teeɓaꞌ biti ri baalute bakaaɗɗi caakki⁠ ⁠; ndaa ɓëeꞌ baalu bakaaɗ ƴutuuɗ ɗa, fahaꞌi na gaaneh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yéesú antee won ɓelaa tih⁠ ⁠: «⁠ ⁠Fu baalute bakaaɗɗu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɓëewë ɓani wa húmú loona ra wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Ɓëyée daa wa níi na kaañ baalaꞌ bakaaɗ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ndaa Yéesú won ɓelaa tih⁠ ⁠: «⁠ ⁠Ngémú sëmlëꞌté rë⁠ ⁠; kolee fu saañ a jaamma.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Filoon fi baaha, Yéesú saañce na wër filiɓ ginna ɓéeɓ, na waare Uni Nebi Nguur ki Koope. Ɓani taalibe yi sabboo a ana ya daa húmú ñéerúu ");
INSERT INTO ndv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","a ɓeleɓɓi ɗi húmú líkíɗté wë yébítëh, ƴee ri paƴce jérrí wë. Tii yi wa daa wa ƴeh⁠ ⁠: Mari fi ɓëy Makdalaa bee líkɗú yébítëh paana ra, ");
INSERT INTO ndv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Saan ɓeleɓ Kusaa fa iña faam Erot tíkú yaꞌa ra, Susaan a i ɓeleɓ caak kay. Ɓeleɓɓi ƴaa ɓéeɓ ɓeyu alalli wa, na habruu Yéesú a taalibe yi. ");
INSERT INTO ndv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ɓëewë húmú ɗúhúu gin-taah ya ɓéeɓ na ayu Yéesú në. Ɓëewë na ɓaatuu caak, ɗi yampe na won wa léehí beh⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«⁠ ⁠Lahte ɓëyí húmú koloh sohi meeyi. Ɗi hom hasli tisoh ka, lahte peppi keente ɓúk waala, kotta ñeete sun, ƴakka ayute, tanute wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Lahte ƴi keen feey fi lahaꞌ laꞌ. Paalaꞌ wa ra, bi síit feey fa, wa yíppée tam. ");
INSERT INTO ndv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Lahte ƴi keen tígí paalaꞌ ñobitaan, wa pëeltúté, ñobitaan fa hampe wa, wa tampe. ");
INSERT INTO ndv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Lahte ƴi keen feey fi looɓpe. Wa paalte, talla kolohte, ɗúhíɗté íl, laaɓpe níi laaɓ.⁠ ⁠» Yéesú ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Ɓëyí lah nuf kelaa, kelaan na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Filoon fi baaha, taalibe yi meelute ri yee fahaꞌ won léehë rë. ");
INSERT INTO ndv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon, kúmpë yí Nguur ki Koope teeɓu ɗon, ndaa yii won mi ɓëewí kayya ɓéeɓ teyaꞌ léeh, nda wa yeele raa, wa ëlíh në, te wa kelee raa, wa yíih yee na wonu ra. ");
INSERT INTO ndv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«⁠ ⁠Léehí baa fahaꞌ woni yii beh⁠ ⁠: tisoh ka daa Unni Koope. ");
INSERT INTO ndv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ɓúk waala keen tisoh ka ra daa wa ɓëewë yéŋké biti keluu wa Unni Koope ra, Seytaane yíppée ac pahte wa keeññi wa, toñeh wa ay gémé Koope, wa múc. ");
INSERT INTO ndv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Feey fa lahaꞌ laꞌ ra daa ɓëewë yéŋké biti keluu wa Unna ra, wa yípútée wëe tah a sos-keeñ⁠ ⁠; ndaa Unna yípëy níil keeññi wa. Wa topuun waa ham guuttii baaha⁠ ⁠: misike waa na rek, wa koluun daaha yeris ngémë. ");
INSERT INTO ndv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Feey fa na paal ñobitaan ra daa ɓëewë yéŋké biti keluu wa Unna ra, tíl tílë níi sohle yi ëldúnë, alal a neɓ pes hampe wa tahte níi kaah púlëy waa na. ");
INSERT INTO ndv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Feey fi looba daa ɓëewë yéŋké biti keluu wa Unna ra, wa tahuute wa yaꞌ ana, habuute wa a keeñi naaꞌte, wa pokuute na níi wa ɗúhrúté njiriñ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ow na këɗɗéh lampa líh if sun, mbée ɓek ri fëgërëh tigal. Ɗaaha neh⁠ ⁠! Lampa líkúu líkëe, ɓëyí haal, ot kotti na. ");
INSERT INTO ndv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yii ɗapu ɓéeɓ ay yúhú, yii laku ɓéeɓ ay olu. ");
INSERT INTO ndv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yúhí ɗee na síkírúu ron Unni Koope ra⁠ ⁠! Ɓëyí ham yee yeru ri ra a yaꞌ ana ay ɓaatu. Ɓëyí pagay yii baaha raa nék, yii ƴutuuda habaꞌ ri biti ɗi lahte ri ra sah ay naafu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Koy-yaayyi Yéesú a yaafi wa ayu ɗii na koon, ndaa caagi ɓëewë tahte wa míníh lah ɗii na. ");
INSERT INTO ndv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tígí daaha, lahte ɓëyí won ɗi tih⁠ ⁠: «⁠ ⁠Yaafu a koy-yaayyu ínú ëssín, na meeluu ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ndaa Yéesú won ɓëewë ɓéeɓ tih⁠ ⁠: «⁠ ⁠Yaasoꞌ a koy-yaayyi soꞌ daa ɓëewë në síkírúu Unni Koope, te ñeye na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lahte bis, Yéesú a taalibe yi haalute gaal, ɗi won wa tih⁠ ⁠: «⁠ ⁠Yen saañ ɓúk laaha hatni bín.⁠ ⁠» Wa koluute na suu. ");
INSERT INTO ndv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wa homu húusí laaha, Yéesú fanohte na neeꞌ. Hom homo níi ngilaaw gaan yíppée laɓ laaha⁠ ⁠; mulaa na maanndaꞌ líifrí gaala, lool daɓpe wa. ");
INSERT INTO ndv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Taalibe ya lahute Yéesú në tígí daaha, na fogu yúunúté rí wonu ri tih⁠ ⁠: «⁠ ⁠Yen ee suu húlé rë Ɓahaa⁠ ⁠!⁠ ⁠» Yéesú kolohte, digiɗte uni túuƴcé ngilaaw ma a mboowaanna héddëh. Deyi baa ɓéeɓ hente tiɗ. ");
INSERT INTO ndv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ɗi won taalibe ya tígí daaha tih⁠ ⁠: «⁠ ⁠Ngémën tasaꞌte ee⁠ ⁠!⁠ ⁠» Wa tíitú tíitë níi ñéerëꞌté a éem, wa na meelantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Ɓëyí bee mën ɗí ow ɓal níi ɗi túuƴ ngilaaw ma a mulii laaha héddëh rëe sah, wa ñee woni⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Húusúu wë laaha ra, Yéesú a taalibe yi teeruu deyi Gerasaa, ɓúgí yíníi laaha jaanndaꞌ Galile ra. ");
INSERT INTO ndv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kot Yéesú na lah feey, ow ƴaal di ɓëy gina, bi yébítëh caak na ham ri, téebílëhté rí. Hente yii maañce, ɗi na ɓekeeh búuɓ, na homeh faam. Ɗi dék hacaayin. ");
INSERT INTO ndv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Olaꞌ ɓëeꞌ Yéesú rë, ɗi yeɗɗohte kotta ɗaañnjohte won tih⁠ ⁠: «⁠ ⁠Ɗo fi Yéesú Koy Koope fa sunaa-sun, fu fahaꞌ paŋi soꞌ yih⁠ ⁠? Daa mi na ɗaŋ ɗo ri, ngana torohal soꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Biti Yéesú ee lík yébítëh fë ɗii na ra daa tah ri won yii bah. Yébítëh fë habaꞌte ɓëeꞌ waal caak. Yaꞌ ya a kotta pokalsuu tiiŋ kaaꞌ ri fús koon raa, faraah ri korsaꞌ wa, yébítëh fë yeñ ri luufin. ");
INSERT INTO ndv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yéesú meelte ri won ɗi tih⁠ ⁠: «⁠ ⁠Daa fu hínú ɗíh⁠ ⁠?⁠ ⁠» Ɗi tahte won tih⁠ ⁠: «⁠ ⁠Mi hínú Dúukël.⁠ ⁠» Biti yébítëh caak daa húmú ɗii na daa tah ri won yii bah. ");
INSERT INTO ndv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yébítëh yë na anuu ɗaŋ Yéesú biti ri ɓan waa bet ngaara mi nuŋa. ");
INSERT INTO ndv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ɗeef lahte yubi mbaam-túgëllí caakute na píisúu ñam araal daŋa hatni baaha. Yébítëh yë na ɗagu Yéesú nda wa mínú haal mbaammi ƴaaha na raa. Yéesú onte wa ri. ");
INSERT INTO ndv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yébítëh yë yípútée yeris ɓëeꞌ, haalute mbaamma na. Yuba yíppée yeɗɗoh yëellëen kí daŋa, mbaamma ɓéeɓ soruute laaha, húlúté. ");
INSERT INTO ndv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Oluu níirëh yí mbaamma yee lah ra, wa heguute suute gin-taahin a ginna luufa, na ɓíllú yee lah ra. ");
INSERT INTO ndv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɓëewë koluute olsohi yee na wonuu ra. Lahuu wa hëbís Yéesú rë, wa ɗeefu ɓëeꞌ yébítëh yë húmú habu ri ra ɓekohte búuɓ, tookke hëbís Yéesú ñéerëꞌté a sago fi. Wa yípútée tíit. ");
INSERT INTO ndv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɓëewë maasuu ra ɓíllúté wë ɗee paƴuu ɓëeꞌ yébítëh yë húmú habu ri ra. ");
INSERT INTO ndv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tíidí misiga tahte ɓëy Gerasaa ɓéeɓ ɗagute Yéesú ɗúh gin wa saañ. Ɗi yeeltee haalaat gaala tígí daaha na fahaꞌ saañ. ");
INSERT INTO ndv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ɓëeꞌ yébítëh yë yeris ri ra ɗaŋke Yéesú nda wa mínú ñéerëꞌ rëe. Yéesú tahray ri, ndaa won ri tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«⁠ ⁠Nimile faam, fu ɓílíɗ iña pagiɗ ro Koope ra ɓéeɓ.⁠ ⁠» Tígí daaha, ɓëeꞌ ñeete filiɓ gina na ɓílíɗ iña pagiɗ ɗi Yéesú rë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nimilaꞌ Yéesú rë, dúukëlí ɓëewë téebílëhté rí. Wa ɓéeɓ húmú sehu ri. ");
INSERT INTO ndv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lahte ɓëyí hínú Yayrus, njíidí tígë na ɗaguu yëwúɗɗë Koope ra, acce wahtii baaha, yeɗɗohte kotti Yéesú, na ɗaŋ ri ac faami, ");
INSERT INTO ndv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ndah ri helaꞌ koy ki ɓelii na ŋaatoh. Ɗi lahaꞌ koy ki yíníi baa kut, bi waɗti lahaa kíil sabboo a kíil ana. Yéesú hom saaña, dúukëlí ɓëewë darute ri. ");
INSERT INTO ndv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ɗeef lahte ɓelii húmú në, hente kíil sabboo a kíil ana yi ri yúfëꞌ ñif. Ɗi túmpé iña lahaꞌ ri ra ɓéeɓ faammi paƴoh ya, ndaa ri píyëy yoofaa. ");
INSERT INTO ndv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɗi ñeyaꞌte Yéesú filoon, leɓpe nuf búubí, yíppée wah kotta-kotta. ");
INSERT INTO ndv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yéesú meelaꞌte won tih⁠ ⁠: «⁠ ⁠Daa leɓ soo na⁠ ⁠?⁠ ⁠» Taasuu ɓëewë ɓéeɓ rë, Peer won ri tih⁠ ⁠: «⁠ ⁠Ɓahaa⁠ ⁠! Fu olay biti ɓëewë ɓéeɓ ee yejantuu ra, na baɓuu ɗoo na hatinna ɓéeɓ ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ndaa Yéesú won tih⁠ ⁠: «⁠ ⁠Ow leɓpe soo na⁠ ⁠: mi yéŋké biti lahte yii kolohte faan soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Olaꞌ ɓelaa biti yee paŋ ri ra yúhúté rë, ɗi acce, yeɗɗohte kotti Yéesú faana ɓéeɓ na saak. Ɗi ɓílíɗté fíi ɓëewë ɓéeɓ yee tah ri leɓ Yéesú në rë a ɗee wahaꞌ ri kotta-kotta ra. ");
INSERT INTO ndv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yaa ow, ngémú tahte fu wahte. Fu mín saañ a jaamma.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yéesú hom wona, lahte ɓëyí kolaꞌ faam Yayrus acce, won kélfíi tih⁠ ⁠: «⁠ ⁠Sohlaay fu mokle Yëeddëhë⁠ ⁠; koohu húlté⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kelaꞌ Yéesú wona ra, ɗi won Yayrus tih⁠ ⁠: «⁠ ⁠Ngana néekíñëꞌ. Fu laakiraꞌ gém kut, koohu ay koloh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lahaꞌ Yéesú faam fa ra, ɗi tahay biti ow kay haal a ri, henay Peer, Saŋ, Saak, boffi kúkëyë a yaafa. ");
INSERT INTO ndv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Húlí kúkëyë tahte ɓëewë ɓéeɓ na fogu na hawuu. Yéesú won tígí daaha tih⁠ ⁠: «⁠ ⁠Ngënë fëgí⁠ ⁠: kúkëyë húlëy, ɗi neeꞌ neeꞌo rek.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɓëewë yabute na ƴenu ri, ndah wa yúhúté biti kúkëyë húlté kaah. ");
INSERT INTO ndv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ndaa Yéesú hampe yaꞌ kúkëyë, ɓéyíɗté uni won ɗi tih⁠ ⁠: «⁠ ⁠Kolee, kúkëy ɓeleɓ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kúkëyë yíppée koloh. Yéesú nahte wa yeri ñam. ");
INSERT INTO ndv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Boffi kúkëyë a yaafa éemúté níi éem, ndaa Yéesú kaddaꞌte wa ɓílíɗ yee lah ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Lahte bis, Yéesú dëekké taalibe yi sabboo a ana ya, onte wa ham-ham a sañ-sañ líkëe yébítëh ɓéeɓ a paƴaa jéríɗ. ");
INSERT INTO ndv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɗi antee waa wol waarii Nguur ki Koope a paƴi jéríɗɗë. ");
INSERT INTO ndv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ngënë kúrëelíi yin waalon⁠ ⁠: duuɗ neh, nafa neh, yii ñamun neh, hélíis neh, te ow ɓanan kúrëelëh búuɓ lofaa. ");
INSERT INTO ndv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tígí habuun ron haneel ɓéeɓ, lah hëmí faam fa níi bín koluun ron gini baaha ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te ɗon pay ílíƴ ɓëewë kaaꞌ hamon haneel raa, lah ɗúhí daaha, ɗon paaŋ pënë mí kotton, teeɓi wa biti wa homuy kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ɗaaha, taalibe ya koluute suute, haalute ginna luufa ɓéeɓ na waariyu Uni Neba, na paƴu jéríɗɗë. ");
INSERT INTO ndv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kelaꞌ Erot gëernëerí Galile iña na pagu Yéesú a taalibe yi ra, afa kúnëhté, ndah lahte ɓëewí wonu ti Saŋ Batis daa waɗti këllú ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","I ow kay wonu ti yonente Éelí daa feeñiyoh. Lahte ƴi wonu ti ow kay di yonente ya ɗéɓ rë daa këllú ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ndaa Erot won nufi tih⁠ ⁠: «⁠ ⁠Mi lecɗohte lúum Saŋ Batis. Kon ɓëeꞌ na paŋ iñi éemílëꞌ yí ƴaa ɓéeɓ rë, waɗti henan wa⁠ ⁠?⁠ ⁠» Erot na anti fahaꞌ oli Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Koluu apootarra waala húmú wol wa Yéesú rë, wa ɓíllúté rí iña pagu wa ra ɓéeɓ. Wa ɓéeɓ ñéerúuté, hécúuté waal gin-taaha na wonuu Betsaydaa ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Keluu dúukëlí ɓëewë biti Yéesú saañce ra, wa koluute téebídí. Lahuu wa ɗii na ra, ɗi teeriyohte wa, wonte wa yii leŋke Nguur ki Koope, paƴce jéríɗɗë. ");
INSERT INTO ndv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bi na yëellëh naꞌa, taalibe yi sabboo a ana ya leɓuute ri, wonu ri tih⁠ ⁠: «⁠ ⁠Wone ɓëewí ƴee saañ ginna leɓoh dee ra, wa saame yii túmún wë ɓúkkí wë a tígí homun wa, tígë homu yen dee ra lahay yin.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ndaa ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ƴah, yérí wë yii nay waa ñame.⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun lahuu mbúurú iip a jén ana kut. Fu wonay biti fun nay lomre ɓëewí ƴee ɓéeɓ ñam maan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ɓëewí ƴaalla húmú në rë warutee mit ow júnní iip (5.000). Yéesú won taalibe yi tih⁠ ⁠: «⁠ ⁠Wëní wë tookaꞌ goomal-goomal, bina-bina ɓéeɓ waɗtee hen ow sabay iip (50).⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Taalibe ya pagute yee nahu wa ra, tëekrúuté ɓëewë ɓéeɓ ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yéesú ɓeɓpe mbúurú yí iippa a jénní ana ya, ɓéyíɗté afi yeelte sun, símpé Koope, antee waa lecsaꞌ, yeɗte wa taalibe ya, nahte wa woralsaꞌ wa ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓëewë ɓéeɓ ñamute níi laalute. Négírúu wooñnjiida ra, wa líiffé dama sabboo a dama ana. ");
INSERT INTO ndv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lahte bis, Yéesú hécëhté na ɗaŋ Koope⁠ ⁠; taalibe ya homute hëbísí. Ɗi meelte wa won tih⁠ ⁠: «⁠ ⁠Ɓëewë wonuu biti daa mi wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Lahte ɓëewí wonu biti fu Saŋ Batis, lahte ƴi wonu yonente Éelí, i ow kay ɓal wonu ti fu ow kay di yonente yee merees bi koloh ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yéesú meelte wa won tih⁠ ⁠: «⁠ ⁠A ɗon, ɗon wonu biti daa mi wah⁠ ⁠?⁠ ⁠» Peer tahte won tih⁠ ⁠: «⁠ ⁠Daa fu Buura Koo fal ri ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tígí daaha, Yéesú kaddaꞌte wa won tih⁠ ⁠: «⁠ ⁠Ngënë wëní ow kay yin na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ɗi antee ɓaat won tih⁠ ⁠: «⁠ ⁠Soꞌ mi Koy-ɓëeꞌ, mi waɗtee mok níi mok⁠ ⁠: ɓaha ya, kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis ii soo fahaꞌ tík íl⁠ ⁠; may hawu húl, te waali éeyë fë filoon fi húlí sëꞌ, may këllú ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yéesú antee won ɓëewë ɓéeɓ tih⁠ ⁠: «⁠ ⁠Ɓëyí fahaꞌ ñéerëꞌ a soꞌ, ɗi helan iñi afi, faraah ri enee kurwahi, anti ñee tal soꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ɓëyí núp húl ay ñak ñíiní⁠ ⁠; ndaa ɓëyí tah ñagi ñíiní af soꞌ, ay lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kaah neh biti alal mi ëldúnë caleh ow yaay ñíiní, saŋku afi a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ɓëyí iñi soꞌ a wonni soꞌ tah ri sopoh fíi ɓëewë, soꞌ mi Koy-ɓëeꞌ may rii súugëh yiin nay mii aye filiɓ ndami soꞌ, daa ndami Baasoꞌ a malaaka yi sela ya ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mee ron won kaaf ka ra ee⁠ ⁠: lahte ɓëewí ewu ɗon na deh, balaa wa húl, wa ay ot Nguur ki Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yii waɗtee hen waal peeye filoon fi bee wonaꞌ ri iñƴaa ra, Yéesú dëekké Peer, Saŋ a Saak, wa lawute sun daŋ, ɗi na ɗaŋ Koope. ");
INSERT INTO ndv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ɗi hom ɗaŋa, kanama lofisohte, búubí naꞌ naaꞌo níi na hap íl. ");
INSERT INTO ndv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ɗee a ɗeh, ow ana feeñiyuute na gonlu a ri⁠ ⁠: wa húmú Mëyíis a yonente Éelí. ");
INSERT INTO ndv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Wa fi ƴaa ɓal, búuɓɓí wë naaꞌ naaꞌo níi na hap íl. Wa gonlu sun fi húlë waɗti húl Yéesú Yerusalem ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peer a kooƴƴi húmú neeꞌute neeꞌi misikke. Yúunúu wë rë, wa olute ndami Yéesú a ɓëewí ana ya homu a ri ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tígë në takuu ɓëewë a Yéesú rë, Peer won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, neɓpe biti yen homun tígí deh, fun yíp dút éeyë⁠ ⁠: fu lah yínë, Mëyíis yínë, Éelí yínë.⁠ ⁠» Peer húmú yéeh iña na won ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ɗi hom wona, lahte nérí acce húunté wë. Taalibe ya tíitúté húunë húun wë nérë rë. ");
INSERT INTO ndv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lahte uni ɗofohte filiɓ nérë won tih⁠ ⁠: «⁠ ⁠Bee daa Koy soꞌ. Daa ri bee fal mi ra. Síkíríi rí⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wonaꞌ una níi wocce ra, taalibe ya olute biti Yéesú a afi kut daa tasu tígë. Wa habute yii baa waa na, te bín fë, wa ɓíllúy ow yee olu wa ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kéy fín fë, cépúu Yéesú a taalibe yi daŋa ra, lahte dúukëlí ɓëewí ayute téebílëhí. ");
INSERT INTO ndv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ow di ɓëewë ɓéyíɗté uni won tih⁠ ⁠: «⁠ ⁠Ɓahaa, mi ɗaŋ ro biti fu olsiɗ soꞌ koy soꞌ. Mi lahaꞌ ri koy kut. ");
INSERT INTO ndv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yébítëh daa na ham ri. Te ri ham ri raa yíp ríi ɓekaꞌ liik, hégíƴ faana hégíƴí misikke, púumíl ɓúgë⁠ ⁠; balaa yébítëh fë yeris ri raa, hom rii moklaꞌ mokloo níi⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi ɗaŋke taalibe yu lígí yébítëh fë, ndaa wa míníh yin na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yéesú tahte won ɓëewë tígí daaha tih⁠ ⁠: «⁠ ⁠Ɗon fi ɓëy jamanii beh, ɗon fi ɓossi ƴee gémúy Koope ƴee ra, may home ɗon na mi mújdé rën níi kirih⁠ ⁠?⁠ ⁠» Ɗi antee won ɓëeꞌ tih⁠ ⁠: «⁠ ⁠Kom soꞌ koohu deh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kúkëyë na ac Yéesú në, yébítëh fë kéeníɗté rí feey, hégíƴcé faana hégíƴí misikke. Ndaa Yéesú digiɗte uni túuƴcé yébítëh fë ɗúh líkké rí, yeɗte kúkëyë boffi. ");
INSERT INTO ndv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɓëewë ɓéeɓ éemúté níi éem di ɗee gaanaꞌ Koope doole ra. Bi homu ɓëewë ɓéeɓ éemí wë di iña paŋ Yéesú rë, ɗi won taalibe yi tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«⁠ ⁠Hëbí yee nay mi ron wone bee ra affon⁠ ⁠: soꞌ mi Koy-ɓëeꞌ, may yaayu ɓëewë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ndaa taalibe ya húmú yíih yee fahaꞌ ri waa won ɗa. Koo onay wa nufi yúhúun wë wona bín fë, te wa kaañuy meel Yéesú yin na. ");
INSERT INTO ndv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Filoon fe, taalibe ya na taasantuu ɓëeꞌ lukki gaan waa na ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bi yúh Yéesú yee nuffi wa, ɗi ɓeɓ kúkëy ƴutuuɗ cëgíɗté hëbísí, ");
INSERT INTO ndv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","antee waa won tih⁠ ⁠: «⁠ ⁠Ɓëyí af soꞌ tah ɗi ham kúkëy ti bee nen a yaꞌ ana, ɗeef ɗi ham soꞌ⁠ ⁠; te ɓëyí ham soꞌ, ɗeef ɗi ham ɓëeꞌ wol soꞌ ra. Ɓëeꞌ habaꞌ afi biti daa ri lukki ƴin ɗon na ra, daa ri lukki gaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Saŋ won tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun olute ɓëyí líkëꞌ yébítëh tiyu. Biti ri noneh yen na tahte fun kadduute ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yéesú won tih⁠ ⁠: «⁠ ⁠Ngënë këddíi rí⁠ ⁠! Yúhí biti ɓëyí kaaꞌaay ron, ñéerëꞌ a ron.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Leɓaꞌ wahtaa waɗ rii ɓéyrëe Koope sun ra, Yéesú caŋke lok biti ay saañ Yerusalem. ");
INSERT INTO ndv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ɗi wolte i ow këllëh rí. Wa suute, haalute gin di Samari, saamɗi tígë nay rii home ra. ");
INSERT INTO ndv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ndaa biti ri hom saañ Yerusalem tahte ɓëy gina kaaꞌuute. ");
INSERT INTO ndv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Keluu Saak a Saŋ yii baa ra, wa wonu Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, fu fahaay biti fun kéeníɗ pilliŋa sun fi wa, múkíl wë woo⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ɗi yíssëhté waa na, wonte affi wa. ");
INSERT INTO ndv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wa anutee koloh na suu gin kay. ");
INSERT INTO ndv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Homuu wa waala ra, lahte ɓëyí won Yéesú tih⁠ ⁠: «⁠ ⁠Tígí mín fúu saañ ɓéeɓ, may ñee talu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Tílé yë lahute faam, ƴakka lahute túf, ndaa soꞌ mi Koy-ɓëeꞌ, mi lahay dék.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yéesú won ow kay tih⁠ ⁠: «⁠ ⁠Aye fu ñee tal soꞌ.⁠ ⁠» Ndaa ɓëeꞌ won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, on soꞌ paaƴ mi pay mi hace baasoꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Légéyú hac ɓúudé neh⁠ ⁠; kolee fu waareye Nguur ki Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ow kay wonil Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, may ñéerëꞌ a ro, ndaa on soꞌ paaƴ, mi pay takohi ɓëyí faam soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëyí tílëꞌ tílëe heeltee, mínéh non Nguur ki Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Filoon fi baaha, Yéesú-Yíkëe tanisse i ow kay. Wa ow sabay paana a ow ana (72), fahaꞌ woli wa ana-ana, wa këllëh rí gin-taah ya a ílíƴƴë waɗ rii ñeya ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Meeya laaɓpe te lecoh ya mítíh yin⁠ ⁠; kon ɗëgí yíkíi meeya ɓaat i lecoh, wa ac leja. ");
INSERT INTO ndv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Këlíi mi wol ron ti ndeŋŋi suu filiɓ i gúmú nen. ");
INSERT INTO ndv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ngënë kúrëelíi hélíis, mbée nafa, mbée ñafaɗ lofaa⁠ ⁠; ngënë cëgëelíi wodoh ow waala. ");
INSERT INTO ndv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ɗon haal faam, ɗéɓíi ɗagiɗ ɓëy faam fa jaamma. ");
INSERT INTO ndv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɓëyí sosse hom na raa, jaammaa ɗagu ɗon ra ay cép sun fi. Ɓëyí sosse homay na raa nék, jaammaa nimil ɗon na. ");
INSERT INTO ndv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Lah hëmí faam fi baaha, ɗon ñam te ron han yii yeru ron na. Ɓëyí légéy waɗtee yínlú opaꞌi. Ngënë jëeɓëntíi faamma. ");
INSERT INTO ndv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ɗon haal gin, ɗon habu na haneel raa, yii yeru ron lah ñëmí. ");
INSERT INTO ndv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lah pëƴí jéríɗɗë gini baaha, te ron won ɓëewë dékú në rë ɓéeɓ biti Nguur ki Koope leɓohte wa. ");
INSERT INTO ndv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ndaa ron haal gin, ɗon habuy na haneel raa, lah ɗúhí këemë, ɗon won ɓëewë tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pëndë mée ginon ñaak kotti fun ra, fun ee waa paagu ra, teeɓi ron biti ɗon homuy kaah. Añcaŋ, yúhí biti Nguur ki Koope leɓohte ron na.” ");
INSERT INTO ndv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mi won ɗon tee⁠ ⁠: yiin nay aattiyee Koope ɓëewë rë, daani ɓëy gini baaha ay luk bi ɓëy Sodom misik.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Mas ɗon fi ɓëy Korasin⁠ ⁠! Ɗon torohute, ɗon fi ɓëy Betsaydaa⁠ ⁠! Kimtaanna pagu gin ɗon ɗa, paguun Tíir a Sidon koon, tin ɓëy ginni ƴaaha maañutee lamboh saaku, wa leefoh yet, teeɓaꞌi biti wa lofute pesaɗ. ");
INSERT INTO ndv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Daa tah yiin nay aattiyee Koope ɓëewë rë, daanon nay luke bi ɓëy Tíir a bi ɓëy Sidon misik. ");
INSERT INTO ndv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A ɗon fi ɓëy Kafarnawum, mbaa ɗon habuu biti ɗon ay ɓéyrú níi sun-Koo neh⁠ ⁠? Ëe-ëeꞌ⁠ ⁠! Añcaŋ, ɗon ay cépírú níi safara.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yéesú ɓaatte won taalibe yi tih⁠ ⁠: «⁠ ⁠Ɓëyí síkírëh rën, ɗeef ɗi síkírëh sëꞌ⁠ ⁠; ɓëyí kaaꞌ síkírëhí rën, ɗeef ɗi kaaꞌ síkírëhí sëꞌ⁠ ⁠; te ɓëyí kaaꞌ síkírëhí sëꞌ, ɗeef ɗi kaaꞌ síkírëhí ɓëeꞌ wol soꞌ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ayuu taalibe yi sabay paana a ana (72) ya waala koluu wa ra, keeññi wa sosse níi sos. Wa wonu Yéesú tih⁠ ⁠: «⁠ ⁠Yíkëe, fun ñeyaꞌ tiyu fun túuƴ yébítëh yë paŋ yin raa sah, wa ñee na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mi otte Seytaane hélkísëꞌté sun, keente ti héléƴ nen. ");
INSERT INTO ndv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Síkíríi⁠ ⁠: mi onte ron sañ-sañi tílúun ɗon sun goŋ a sun dagal a ɗakaƴaꞌi Seytaane a ɗee gaanaꞌ ri doole ra ɓéeɓ, te yin ii ron míníl dara. ");
INSERT INTO ndv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ndaa biti yébítëh yë ñeyute wonon ɓanan hen damaa ɗon na⁠ ⁠; dëmíi biti kay, tii yon ín sun-Koo.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wahtii baaha, Ruuh-Peseŋ sosilte keeñ Yéesú níi sosil. Yéesú yíppée won tih⁠ ⁠: «⁠ ⁠Baap, Yíkíi sun a feey⁠ ⁠! Mee roo sím rë, di yee teeɓaꞌ fu ɓëewë ɓëy ëldúnë heefu wa ra iña ɗap fu ɓaha ya a ɓëewë jaŋiyu ra. Baap, yii baa daa neɓaꞌ ro, daa tah ri lahaꞌ ɗaaha⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yéesú ɓaatte won ɓëewë tih⁠ ⁠: «⁠ ⁠Baasoꞌ tíkké iña ɓéeɓ yaꞌ soꞌ. Ow yéeh soꞌ mi Koy ka hém henay Baasoꞌ⁠ ⁠; te ow yéeh Baasoꞌ hém henay soꞌ mi Koy ka a ɓëewë mi fahaꞌ wa rii teeɓ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ɗi antee yíssëh taalibe yi na, won wa fi ƴaaha tih⁠ ⁠: «⁠ ⁠Lahute sos-keeñ ɓëewë olu yee olu ron ra. ");
INSERT INTO ndv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mee ron won ɗa ee⁠ ⁠: caakke yonente a buurri húmú fahuute ot yee olu ron ra, wa oluy ri⁠ ⁠; te wa húmú fahuute keloh yee keluu ɗon ɗa, wa keluuy ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tígí daaha, ow di yëeddëh yí kootii Mëyíis kolohte na saam olsohi Yéesú, meelte ri won tih⁠ ⁠: «⁠ ⁠Ɓahaa, mi waɗti paga yi níi mi lah pesa na ɗúméh rë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Kootaa won yi na⁠ ⁠? Fu yoon yi na⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ɓëeꞌ tahte won tih⁠ ⁠: «⁠ ⁠Kootaa won tih⁠ ⁠: “Lah fëhíi Koo-Yíkëe di keeññon ɓéeɓ, di peson ɓéeɓ, di dooloon ɓéeɓ a nuffon ɓéeɓ. Di fahuu ron affon, lah fëhíi moroommon ɗaaha.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yéesú won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Yee won fu ra kaah. Fu paŋ yii baa raa, fay lah pesa na ɗúméh rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ndaa ɓëeꞌ na saam layaa, meelte Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠A wa daa moroomi soꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Lahte ɓëyí húmú kolaꞌ Yerusalem na saañ Yéríkëe. Ɗi hom waali, i banndi gecsuute ri, naafute búuɓɓí, laɓute ri laɓɓi misikke, anutee saañ, helute ri hanndal ki húl a pes. ");
INSERT INTO ndv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɗeef lahte seeƴohi ñee waali baaha. Olaꞌ ri ɓëeꞌ rë, ɗi ñeete ɓúk waala hatni yínëe saañce. ");
INSERT INTO ndv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ow di ɓëewë na habruu seeƴoh ya ra ñeete daaha ɓal, otte ɓëeꞌ, ñeete ɓúk waala hatni yínëe ɓal saañce. ");
INSERT INTO ndv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ow di ɓëy Samari saañ ɓaaɓ ñeete waali baaha ɓal. Lahaꞌ ɗi fi baa daaha otte ɓëeꞌ rë, keeña ɗúmpé ces. ");
INSERT INTO ndv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɗi leɓohte ɓëeꞌ, ɓeɓpe béeñ a díw paƴce gaañña, ŋaawte wa, antee rii tík sun fi mbaam fi, kúɗté rí tígí ɗi mín nëe paƴu, tooppitohte ri. ");
INSERT INTO ndv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kéy fín fë, ɗi yeɗte yíkíi faam fa hélíis caak, antee rii won tih⁠ ⁠: “Tooppitee ɓëyí beh⁠ ⁠; mi ñeyaat dee raa, yii tíkëh sun fi hélsë yeɗ mi ro ƴee ra ɓéeɓ, may roo waa yíníl.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yéesú meelte ri won tih⁠ ⁠: «⁠ ⁠Di ɓëewí éeyë yí ƴah, fu habaꞌ biti ɓëyí bi waa na daa pagiɗ ɓëeꞌ hawu ra, ti di waɗti pagraa ow moroomi nen⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yëeddëhí Kootaa won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ teeɓ ri naaꞌ-keeñ, paƴce ri ra.⁠ ⁠» Yéesú won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Tílé fu hen ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yéesú hom waali a taalibe yi, ɗi lahte gin, ow ɓeleɓ di ɓëy gina hampe ri haneel faami. Ɓëyí ɓelaa hínú Martaa. ");
INSERT INTO ndv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ɗi lahte koy-yaafi hínú Mari. Koy-yaafa acce, tookke hëbís ɗi fi Yíkëe, na síkírëh iña na won ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martaa nék, légéyí caaga faam fa hampe ri. Hompe níi ri lahte Yéesú në, won ɗi tih⁠ ⁠: «⁠ ⁠Yíkëe, fu olay biti koy-yaasoꞌ helte légéyí faam fa ɓéeɓ yaꞌ soꞌ a⁠ ⁠? Wone ri habraꞌ soꞌ book.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ɗi fi Yíkëe won ɗi tih⁠ ⁠: «⁠ ⁠Ɗo fi Martaa, iña mokil ɗo ra caakke, ");
INSERT INTO ndv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ndaa yínë kut daa lah na solo. Mari tanis bee gén ɗë, te ow mínéh ríi kaaꞌ síkírëhí sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lahte bis, Yéesú húmú ílíƴ na ɗaŋ Koope. Wocaꞌ ri ra, ow di taalibe yi won ɗi tih⁠ ⁠: «⁠ ⁠Yíkëe, yëedíɗ fun di na ɗaguu Koope, ti ɗee húmú yëeddëꞌ Saŋ taalibe yi ra nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon ƴahti ɗaŋ Koope raa, lah wëní tih⁠ ⁠: Baap, ɓëewë yúhún biti tiyu selate. Nguur ku lahan ɓëewë në. ");
INSERT INTO ndv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bisi yíilëe Koo ɓéeɓ, lah on fun njél. ");
INSERT INTO ndv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Baal fun bakaaɗɗi fun⁠ ⁠; ndée ɓëyí tooñ fun ɓéeɓ, fun baal ri ɓal. Ngana yeris nuf ɓos haal fun. Ɗémíin⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yéesú wonaat wa tih⁠ ⁠: «⁠ ⁠Ow di ɗon na pay faam kooƴi leelu elek koon, won ɗi bitih⁠ ⁠: “Wëtíɗ sëꞌ bookaa kiiɗ éeyë daa noo, ƴaal kowa⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mi lahaꞌ haneel faam soꞌ, te mi lahay yii yera mi ri.” ");
INSERT INTO ndv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Te kooji baa won ɗi biti raa⁠ ⁠: “Ngana ñogol soꞌ⁠ ⁠! Mi wonte ílí las soꞌ níi wocce, te funi koyyi soꞌ fanuute. Mi mínéh koloh yeru yin⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Daa mi won ɗon ɗi ee biti ɗi ay koloh yeri ñam. Ɗi ii kolaꞌ yeri ñam biti ɗi kooji déꞌ⁠ ⁠; ɗi ay rii yeɗ iña sohlaꞌ ɗi ra ɓéeɓ, ndah ɓëeꞌ na meelaꞌ ra ɓekay na sopoh, ñaakke meelaꞌa rek. ");
INSERT INTO ndv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«⁠ ⁠Mi won ɗon tee ɓal⁠ ⁠: ɗëgí ɗon ay onu, sëemí ɗon ay ot, lëɓí ílë ɗon ay kúnsírú. ");
INSERT INTO ndv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ahaŋkay⁠ ⁠! Ɓëyí ɗaŋ ay onu, ɓëyí saam ay ot, te ɓëyí laɓ íl ay kúnsírú. ");
INSERT INTO ndv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Boffi koy ki bi ɗon na, nay yere koohi goŋ biti ri ɗaga ri jén, ");
INSERT INTO ndv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","mbée yera ri dagal biti ri ɗaga ri wah⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɓosuu ɗon níi, ɗon mínú pagiɗ koyyon yin wun. Kon ɗon mínú yii baaha raa, ɗeef lukaꞌ Boffa sunaa-sun neh⁠ ⁠: ɓëyí ɗaŋ ɗi Ruuh-Peseŋ, ɗi ay ri rii on.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lahte bis, Yéesú hom paƴi ɓëyí lahaꞌ yébítëh fí kaddaꞌ ri won. Yeɗɗaꞌ yébítëh fë ɓëeꞌ rë, ɓëeꞌ dalaatte won. Ɓëewë húmú daaha ra ɓéeɓ éemúté. ");
INSERT INTO ndv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ndaa i ow waa na wonu ɗi ñéerëꞌ a Belsebul buuri yébítëh yë, daa tah ɗi mín wëe lík. ");
INSERT INTO ndv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","I ow kay na saamu olsohi, nahute ri paŋ kimtaani nay teeɓee biti Koope daa wol ri. ");
INSERT INTO ndv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ndaa bi yúh Yéesú yee nuffi wa, ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓëewí daa boku nguur haaꞌee filiɓ fi wa raa, nguur ki baa ii míllëꞌ keen a⁠ ⁠? Ɓëewí daa boku faam haaꞌee filiɓ fi wa raa, faam fi baa ay míllée poo. ");
INSERT INTO ndv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kon hena biti Seytaane haaꞌ afi koon, nguur ki ay mínée caŋ ɗíh⁠ ⁠? Ɗon wonu neh Belsebul daa yeɗ soꞌ sañ-sañi líkëe mí yébítëh ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hena biti Belsebul daa yeɗ soꞌ sañ-saña na líkëꞌ mi yébítëh rëe, kon daa yeɗ ɓëewën sañ-saña na líkúu wë yébítëh rë⁠ ⁠? Wa fi ƴaa teeɓute ron biti ɗon homuy kaah⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yee lah ra biti kay, mi ñéerëꞌ a Koope daa tah mi mín lík yébítëh. Baa daa teeɓaꞌ biti Nguur ki Koope lahte níi ɗon na. ");
INSERT INTO ndv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«⁠ ⁠Ɓëyí mitte ow ham ngodi, caŋ wohi faami raa, ow ii leɓ alal mi. ");
INSERT INTO ndv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ndaa ɓëyí luk ɗi doole ac, yejoh ri haaꞌ ɓaŋ ɗi raa, ɗi ay naaf ngoda húmú yaakaar ri ra, anti woraꞌ iña ɓeɓ ri ɗii na ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«⁠ ⁠Ɓëyí ñéerëey a soꞌ, kaaꞌaꞌte soꞌ⁠ ⁠; te ɓëyí habraay soꞌ négírëꞌí yubi soꞌ, ɓëyí baa haslaꞌ hasloo. ");
INSERT INTO ndv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«⁠ ⁠Yébítëh ɗúh ow na raa, sayaꞌ mbale luufin saame tígí hílsëe rí. Ɗi olay raa, wonaꞌ nufi tih⁠ ⁠: “May nimil tígë húmú kolaꞌ mi ra.” ");
INSERT INTO ndv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ɗi nimil ɗeef ɓëeꞌ man ti faam fi parute, yugusute níi wunte raa, ");
INSERT INTO ndv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","tígí daaha, ɗi ay pay saam yébítëh paana kay, ƴi luku rii sohoor, wa ac dék ɓëeꞌ në. Hen ɗaaha raa, ɗee nay míllée ɓëeꞌ rë ay luk ɗee man ɗi ɗéɓëenë rë ɓos.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yéesú hom wona, un ɓeleɓ ɗofohte filiɓ fi ɓëewë won ɗi tih⁠ ⁠: «⁠ ⁠Ɓelaa kúɗ ɗë ëldúnë ɓëpíɗté rë rë lahte sos-keeñ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ndaa Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëewë në síkírúu Unni Koope te na ñeyu na ra kay, daa lahu sos-keeñ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bi na ɓaatuu ɓëewë caak hëbís Yéesú, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ɓëy jamanii bee ɗon ɓosute⁠ ⁠; ɗon meeluu kimtaani kolaꞌ Koope na a⁠ ⁠? Añcaŋ ɗon ii teeɓu kimtaan hém henay yee húmú kat yonente Sonaas ra. ");
INSERT INTO ndv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Di húmú ñeyaꞌ Koope Sonaas na teeɓpe ɓëy Níníif doolii, ɗi ay ñeyee soꞌ mi Koy-ɓëeꞌ në ɗaaha ɓal, teeɓ ɓëy jamanii bee doolii. ");
INSERT INTO ndv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yiin nay aattiyee Koope ɓëewë rë, buuri ɓelaa húmú ílíf deyi Sabaa ra ay koloh, caŋ fíi ɗon fi ɓëy jamanii beh, teeɓ ɗon biti ɗon homuy kaah. Ɗi húmú kolaꞌ ginna lukuu wuloh ra neh, acce síkírëhí wonnee ke Salomoo neɓ keloh níi rë ë⁠ ⁠? Añcaŋ, ɓëyí luk Salomoo gaan daa deh. ");
INSERT INTO ndv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yiin nay aattiyee Koope ɓëewë rë, ɓëy Níníif ɓal ay koloh caŋ fíi ɗon fi ɓëy jamanii beh, teeɓ ɗon biti ɗon homuy kaah. Keluu ɓëy Níníif waarii Sonaas ra, wa lofute pesaɗ neh a⁠ ⁠? Añcaŋ, ɓëyí luk Sonaas gaan daa deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ow na këɗɗéh lampa ɗap ri, mbée líh if sun fi. Ɗaaha neh⁠ ⁠! Lampa líkúu líkëe, ɓëyí haal, ot kotti na. ");
INSERT INTO ndv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Íllú daa lampii faanu⁠ ⁠: íllú wah raa, fu homaꞌ leelii niiña⁠ ⁠; ndaa íllú neɓay raa, fu homaꞌ ñúusë. ");
INSERT INTO ndv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kon lah olsee afu nda niiña ɗoo na ñúus neh. ");
INSERT INTO ndv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hena biti fu homa niiñ níi cér yínë sah homay ñúus rëe, fay home niiñ ti ɗee na hawaanaꞌ ro lampii niiñce ra nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wocaꞌ Yéesú wona ra, lahte fariseŋi dëekké rí ñam faami. Lahaꞌ ri faam fa ra, ɗi haalte wa na ñamu. ");
INSERT INTO ndv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseŋa éempé, olaꞌ ri biti Yéesú ɓooñnjaay ɓooñnjohi ñeete waal na dal ri ñam ra. ");
INSERT INTO ndv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ɗi fi Yíkëe won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Ëlí ɗon fi fariseŋŋa di madu ɗon⁠ ⁠: ɗon hom hosuu fëel fí guluŋŋa a loonna ɗon hel filiɓ. Ɗon hosuu faannon ɗon hel keeññon⁠ ⁠: ɗon caakute nuf lohaa te ɗon ɓosute nuf. ");
INSERT INTO ndv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ɗon daa lúhú nuf⁠ ⁠! Ɓëeꞌ sak fëel rë, daa sak filiɓ ɓal neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ëní ñëkíɗɗë kay iña lahuu ɗon ra. Hen ɗaaha raa, ɗon ay lan ces. ");
INSERT INTO ndv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mas ɗon fi fariseŋŋa⁠ ⁠! Yii lín ɗon ɓéeɓ, ɗon woɗ na Koope níi lukaꞌ ƴee lukki ñak solo ra, ndaa ɗon sarganuute paŋ yii júɓpé a fahaꞌi Koope. Añcaŋ, ƴaa daa iña waɗti pagun koon ɗa, ƴee tas ɗa ɓanti halu. ");
INSERT INTO ndv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mas ɗon fi fariseŋŋa⁠ ⁠! Ɗon fahuu took ñaanna këllëh di ílíƴƴë na ɗaguu Koope ra, te ɗon fahuu biti ɗon woduun a yaꞌ ana këemmë. ");
INSERT INTO ndv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mas ɗon fa madu a luuyyi tíinndúuy, ɓëewë ñeyuu sun, te wa yíih biti wa ñeyuu sun luuy ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ow di yëeddëh yí kootii Mëyíis won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, fu wonaa ɗaaha raa, ɗeef fee fun sol ra ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Íi⁠ ⁠! Mas ɗon fi yëeddëh yí Kootaa⁠ ⁠! Ɗon tíkúu ɓëewë eni ɓítté te ɗon na hëbíríih wë dalaa sah. ");
INSERT INTO ndv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mas ɗon fa taɓahuu luuyyi yonente ya caaccon húmú bëemú wë rë taɓah yi wunte ra. ");
INSERT INTO ndv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ɗaaha, ɗon teeɓuute biti ɗon ñéerúuté a yee húmú pagu caaccon ra⁠ ⁠: wa bëemúté yonente ya, ɗon ayute ɗon na taɓahu luuyyi wa. ");
INSERT INTO ndv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yii baa daa tah Koope fa yúh ɓéeɓ ɗë won tih⁠ ⁠: “May wol i yonente a i apootar waa na, ay lah ƴi wa bëem wë, ƴee wa mokil wa níi mokil.” ");
INSERT INTO ndv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Daa tah ñif mi yonente ya bëemú dalaꞌte sagi ëldúnë níi a woteh ra, ay keen sun fi ɓëy jamanii beh⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","dalaꞌte bëemí Abeel níi bi Sakari fa bëemú baylii Faam fi gaani Koope, hanndal ki tígë na hawruu ra a tígí selaa. Mee ron won ɗa ee⁠ ⁠: kaah biti ɓëy jamanii bee ay yíníl ñíinnë kéenɗú ƴaa ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mas ɗon fi yëeddëh yí Kootaa⁠ ⁠! Ɗon wodute ílë në yúhúu yee won Koope ra⁠ ⁠; ɗon fi ƴah, ɗon kaaꞌuute haal, ɗon anutee kaaꞌ ɓëewë fahuu ra haal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kolaꞌ Yéesú tígí daaha ra, yëeddëh yí kootii Mëyíis a fariseŋŋa haayluute sun fi, na anuu rii meel yin fi yin ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Wa na olsuu ri, nda ri ay won yii ñeyay waal raa. ");
INSERT INTO ndv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wahtaa na wonaꞌ Yéesú fariseŋŋa na a yëeddëh yí kootii Mëyíis rë, i ow júnní-júnní na ɓaatuu ac⁠ ⁠; caagi wa tahte wa na togantuu hanndal ki wa. Yéesú ɗéɓëꞌ taalibe yi na won wa tih⁠ ⁠: «⁠ ⁠Lah mëytíi lëwíirí fariseŋŋa, daa ri wonnee ke wa teem ɓúkkí wë rë. ");
INSERT INTO ndv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yii laku ɓéeɓ ay olu, yii ɗapu ɓéeɓ ay yúhú. ");
INSERT INTO ndv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yii ɗon won ɗi filiɓ ñúus ɓéeɓ ay keluu naꞌ këtëŋ, te yii ɗon mëddëꞌ rí filiɓ las ɓéeɓ ay ɗaañnjuu këem. ");
INSERT INTO ndv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«⁠ ⁠Mi won ɗon na, ɗon fi kooƴƴi soꞌ⁠ ⁠: ngënë néehí ɓëewë na hawu ow húl rë, wa míníh yii luk baaha. ");
INSERT INTO ndv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cëe mi teeɓ ɗon ɓëeꞌ warun ɗon neeh ra⁠ ⁠: néehí Koope, ndah ri hap húl rëe mín ɓek safara. Mi won ɗon tee ɓal, ɗon waɗti neehun ɗi. ");
INSERT INTO ndv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«⁠ ⁠Ndiit iip na yëeyíih fíttíŋ ana woo⁠ ⁠? Añcaŋ, yínë sah na múuƴéh në Koope. ");
INSERT INTO ndv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ɓaatte biti fen fi affon sah kídúté⁠ ⁠! Kon ngënë sídíi yin, ɗon génú líir ndiit fap⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«⁠ ⁠Mi won ɗon tee⁠ ⁠: ɓëyí won fíi ɓëewë biti ɗi non ɓëewí soꞌ mi Koy-ɓëeꞌ, may won fíi malaaka yi Koope biti ɓëyí baa non ɓëewí sëꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ɓëyí won fíi ɓëewë biti ɗi yéeh sëꞌ nék, may won fíi malaaka yi Koope biti mi yéeh ɓëyí baaha ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɓëyí won yin ɓos sun fi soꞌ mi Koy-ɓëeꞌ ɓéeɓ, ɗi mín baalu. Ƴaha sun fi Ruuh-Peseŋ raa nék, ɓëyí baa ii baalu. ");
INSERT INTO ndv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","«⁠ ⁠Ɗon tëekrú këem filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra mbée fíi njíittí gina a ɓëewë homru nguur ka ra, ngënë sídíi⁠ ⁠: yee nay ron layee wahtii baaha teme ra ii kolaꞌ ɗon na, ay kolee Ruuh-Peseŋ na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tígí daaha, ow di ɓëewë won Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, wone ɓahii soꞌ woɗ soꞌ na alal ma heliɗ fun boffi fun ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Kooja, daa fal soꞌ aattiyaꞌi iñon mbée woraꞌi alal mon⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɗi antee ɓaat won ɓëewë ɓéeɓ tih⁠ ⁠: «⁠ ⁠Lah héní wun, ngënë fëhíi alal níi lukus, ndée caagi ow alal taheh ri lahaꞌ ñíiní.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tígí daaha, Yéesú ñeyaꞌte wa léeh won wa tih⁠ ⁠: «⁠ ⁠Lahte yíkíi alal mi húmú lahaꞌ meeyyi laaɓpe níi laaɓ. ");
INSERT INTO ndv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɗi won nufi tih⁠ ⁠: “May hene ɗí ɗeh, bee lahay mi tígí túmë mí pebi soꞌ bee ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mi ot na⁠ ⁠! May hene ɗeh⁠ ⁠: may ɓaate misah yi soꞌ, mi túm pebi soꞌ a iña lahaꞌ mi ra ɓéeɓ filiɓ. ");
INSERT INTO ndv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mi anti won af soꞌ tih⁠ ⁠: mi lahte alal mi ay soo mín kúɗ kíil caak⁠ ⁠; mi tallaꞌ hílsëh, mi ñame, mi hane níi keeñ soꞌ sos siiɓ.” ");
INSERT INTO ndv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ndaa Koo won ɗi tih⁠ ⁠: “Lúh nuf fe⁠ ⁠! Fay húl elgee woteh beh. Daa nay lahee iña yefiɗ fu afu ra ɓéeɓ leegi⁠ ⁠?”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɓëyí homaꞌ négírëꞌ alal mi saañ afi na kut, saamay Koope, hom míllëꞌ ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yéesú antee won taalibe yi tih⁠ ⁠: «⁠ ⁠Yii baa daa tah mi won ɗon tee⁠ ⁠: ngënë sídíi yii ñamun ɗon, mbée yii ɓekuun ɗon. ");
INSERT INTO ndv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pes luk ñam lah solo, te faan luk yéré lah solo ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","«⁠ ⁠Ëlsíi ŋaakka⁠ ⁠: wa na sëhíh níi púlé lec, wa lahuy misah, lahuy túmëe, ndaa Koope ee waa ñëmíɗ rë⁠ ⁠! Ɗon nék, ɗon lúkíh ƴakka lah solo a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wa ɗon na, sídëꞌë në sídëꞌ rí rë, mín fehe níi ɓaat yin ƴutuuɗ pesi⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hém ɗon daa míníh yii ƴutuudi baa raa, ɗon sídúu yi yin kay⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«⁠ ⁠Ëlsíi ɗee man capussi gaaw fa luufa ra⁠ ⁠: wa na légéyíh te wa na mëkíh ɗíis búuɓ. Añcaŋ, mee ron won ra ee⁠ ⁠: ɗi fi buura hínú Salomoo ra sah, húmú lahaꞌ ri alal níi, ɗi lahay búuɓɓí madaꞌ a capussi gaaw fi ƴaa wun⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ngémën tasaꞌte ee⁠ ⁠! Koope posil gaaw fa luufa woteh níi wa man ɗaaha wun, te teem kéy wa ay luuhu tamu raa, ɗi ay lukee ɓek ɗon fi ƴaa búuɓ neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kon ngënë mëklí affon saami yii ñamun ɗon mbée yii hanun ɗon⁠ ⁠; ngënë sídíi. ");
INSERT INTO ndv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ɓëewë nëníh ɓëewí Koope feey fi bee ra daa na moklu affi wa saami iñƴaaha ɓéeɓ. Ndaa ɗon fi ƴah, Boffon yúhté biti ɗon sohluute wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nguur ki Koope daa mit saam⁠ ⁠; bee tas ɗa ín yaꞌ Koo⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ɗon fa yubi ƴutuudi beh, ngënë néekíñíi, ndée Boffon daa fahaꞌ biti ɗon haal Nguur ki. ");
INSERT INTO ndv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yëeyí alal mon ɗon sarah ñëkíɗɗë cadum fa. Sëemí tígí wëerté, négíríi alal mi mínéh ɗúm sun-Koo, tígí lohoh liileh na te lahay maasoh. ");
INSERT INTO ndv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yúhí biti tígí hom alal mon, nuffon homaꞌ na ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«⁠ ⁠Pëkíi, ɗon këríɗ lampa yon. ");
INSERT INTO ndv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mëdíi a súrgë yí sehu kélfíi saañ kílëek, nda ri ac laɓ ílë rëe, wa yíp ríi kúnsíɗ. ");
INSERT INTO ndv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Lahute sos-keeñ, súrgë yí ƴaa yéŋké biti ayaꞌ kélfíi wë rë, ɗeef wa na sehu ra. Mee ron won kaaf ka ra ee bitih⁠ ⁠: ɗi fi kélfëe ay pokoh, tëekíɗ súrgë yë, yeɗ wa ñam. ");
INSERT INTO ndv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wuti kélfëe elkaꞌ níi elkaꞌ raa sah, te ɗeef wa sehe ri, wa ay lah sos-keeñ. ");
INSERT INTO ndv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«⁠ ⁠Ɗon yúhúté biti yíkëe faam yúh wahtaa nay aye lohoha faami ra koon, tin ɗi ii rii yeris poo faam fa. ");
INSERT INTO ndv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kon këlíi affon ɗon ɓal, ndée soꞌ mi Koy-ɓëeꞌ, may nimile wahtii nuffon paay na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peer won Yéesú tígí daaha tih⁠ ⁠: «⁠ ⁠Yíkëe, fu woniɗ fun kut léehí bah, mbée fu ɓekke ɓëewë ɓéeɓ në⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ɗi fi Yíkëe won ɗi tih⁠ ⁠: «⁠ ⁠Mëdíi a súrgíi ñeyaꞌ woni kélfíi te ñaañce, bi kélfíi tík súrgë yí kayya faam fa yaꞌi, yeri wa ñam biti wahtaa lah ra. ");
INSERT INTO ndv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Lahte sos-keeñ, súrgíi baa yéŋké biti yiin nay nimile kélfíi faam fa ra, ɗeefa ri page yee nahu ri ra. ");
INSERT INTO ndv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mee ron won kaaf ka ra ee, kélfíi ay tík iña lahaꞌ ri ra ɓéeɓ yaꞌi. ");
INSERT INTO ndv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ndaa hena biti koon súrgíi baaha won nufi tih⁠ ⁠: “Kélfíi sëꞌ aay doom”, níi tah ɗi yam sun fi súrgë yí kayya hawsee wa, ɗi ñame ñami neɓpe, hane maniye, ");
INSERT INTO ndv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kélfíi ay nimil wahtii ɗi yéeh rí te ɗeefa ri seheh ri. Tígí daaha, kélfíi ay rii bëkdëꞌ ɓëewë gémúy Koope ra, mokil ri mokli misikke. ");
INSERT INTO ndv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Súrgíi yúh yee fahaꞌ kélfíi rë, antee cagay afi te pagay yii baaha, ay laɓu laɓɓi misikke. ");
INSERT INTO ndv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ndaa súrgíi yéeh yee fahaꞌ kélfíi rë, anti paŋ yii cal hap, ii laɓu laɓ caak. Ɓëyí onu yin caak ay meelu caak⁠ ⁠; ɓëyí déŋéenú yin caak ay meelu ƴi luk ƴi ɓëyí déŋéenú ƴutuuɗ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Mi ac yíin kíi feey fa, a ɗee fahaꞌ mi biti ɗi yíppí kaɗ haat ɗa⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mi waɗtee ñee coono, keeñ soꞌ antee tookay níi lëhín kí. ");
INSERT INTO ndv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ɗon habuu biti mi ac kúɗ jaamma feey fa a⁠ ⁠? Ëe-ëeꞌ, mi won ɗon tee⁠ ⁠: mi ac ɗaralsaꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dalaꞌte woteh, faam fi lahaꞌ ow iip ay ɗaralsaꞌ⁠ ⁠: ɓëewí éeyë yë múuƴëꞌ a ɓëewí ana ya, ɓëewí ana ya múuƴëꞌ a ɓëewí éeyë yë. ");
INSERT INTO ndv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baap ay múuƴëꞌ a koy ki ƴaali, koy ka múuƴëꞌ a boffi. Yaay ay múuƴëꞌ a koy ki ɓelii, koy ka múuƴëꞌ a yaafi. Pacool ay múuƴëꞌ a ɓeleɓ koohi, ɓeleɓ koy ka múuƴëꞌ a pacooli.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yéesú ɓaatte won ɓëewë tih⁠ ⁠: «⁠ ⁠Ɗon ot Koo húuh rëe, ɗon yíppí yúh biti ɗi ay toɓ⁠ ⁠; te yii baa daa na lah. ");
INSERT INTO ndv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te ngilaaw ma kúlëe rën waal tagu raa, ɗon yúh biti ɗi ay mbëeyë⁠ ⁠; te yi baa daa na lah. ");
INSERT INTO ndv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wonnon teem ɓúkkën⁠ ⁠! Ɗon fa mínú tíinndëꞌ iña na teeɓaꞌ yii nay lahe feey fa a sun ra, haalaꞌ yi níi ɗon míníh tíinndëꞌ iña na teeɓaꞌ Koo woteh ƴee ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«⁠ ⁠Yi tah ɗon míníh yúh yee waɗti pagun ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ow yam ɗo yin níi ɗoni saye faam buur raa, ɗon lah waala, lah saame biti ɗoni júɓëꞌ, toñeh ɗoni lah dín fë ɗi ey ro, buur tík rë yaꞌ yi alkaati ya, fu téƴú. ");
INSERT INTO ndv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Daa mi won ɗon ɗi ee⁠ ⁠: fii ɗúh kasaa níi bín yínlëe fu kabut ka ɓéeɓ rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wahtii baaha, i ow ayute woni Yéesú biti Pilaat hawrohte i ow di ɓëy Galile húl, ɗeef wa na hawru Koope sarah. ");
INSERT INTO ndv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon habuu biti bëemëdë bëemú ɓëy Galile yi ƴaa ra teeɓaꞌ biti wa luku ɓëewí kayya Galile ɓos aa yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mi won ɗon ti ëe-ëeꞌ⁠ ⁠! Te ɗon lofuy pesaɗ, ɗon ɓéeɓ ay saŋku ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A ɓëewí sabboo a peeye yi ƴaa ɗakaƴaꞌ taahi uda Silowe na bëp ɗí rë, ɗon habuu biti daa wa luku ɓëewí kayya Yerusalem ɓos aa yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mi won ɗon ti ëe-ëeꞌ⁠ ⁠! Te ɗon lofuy pesaɗ, ɗon ɓéeɓ ay saŋku ɓal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yéesú antee waa ñeyaꞌ léeh won wa tih⁠ ⁠: «⁠ ⁠Lahte ɓëyí húmú lahaꞌ tal een meeyi. Ɗi acce na saam koy een ndaa ri olay. ");
INSERT INTO ndv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tígí daaha, ɗi won súrgëe në lín meeya ra tih⁠ ⁠: “Ole⁠ ⁠! Kíil éeyë aƴee ɓéeɓ, mi ac saam koy een tal eeni beh, te mi na oleh. Ɗi ay homee naafi feey fa te ri lahay njiriñ a⁠ ⁠? Hawe ri⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«⁠ ⁠Ndaa súrgëe won ɗi tih⁠ ⁠: “Ɓahaa, yeɗɗe ri kíilí beh, may júkët tala mi toh ri. ");
INSERT INTO ndv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Henu ɗaaha raa, heeƴce ɗi lím kíirkí⁠ ⁠; ɗi límëy rëe fu hawroh ri.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bisa na hílsúu yëwúɗɗë rë ín, Yéesú hompe na yëeddëꞌ filiɓ tígë na ɗaguu yëwúɗɗë Koope ra. ");
INSERT INTO ndv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ow ɓeleɓ misikiɗ húmú në⁠ ⁠: ɗi lahaꞌ yébítëh fí daa gogil ri⁠ ⁠; hente kíil sabboo a kíil peeye (18), ɗi na mínéh caŋ níi júɓ dalaa sah. ");
INSERT INTO ndv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Olaꞌ Yéesú ɓelaa, ɗi dëekké rí, won ɗi tih⁠ ⁠: «⁠ ⁠Yaa ow⁠ ⁠! Misigu wocce⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ɗi tíkké yaꞌ yi sun fi ɓelaa, ɓelaa yíppée júɓ, yampe na kañ Koope. ");
INSERT INTO ndv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ndaa paƴa paƴ Yéesú ɓelaa bisa na hílsúu rë neɓaay njíidí tígë na ɗaguu Koope ra. Tígí daaha, ɗi won ɓëewë tih⁠ ⁠: «⁠ ⁠Lahte waalli pëenë yí ɓëewë waɗti légéyún në⁠ ⁠; lah ëyí paƴoh na, ndaa bisa na hílsúu rë neh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ɗi fi Yíkëe loffe ri unni ƴeh won ɗi tih⁠ ⁠: «⁠ ⁠Wonnon teem ɓúkkën⁠ ⁠! Bisa na hílsúu rë, ow fi ow ɗon na ɓéeɓ na pay yugiin, pëkís fanfi mbée mbaam fi, pay hënndí neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A ɓelii bee sédí Abraham bee ra, Seytaane antee rii pokalsaꞌ yii hente kíil sabboo a kíil peeye (18) bee ra, ɗi waruyti sëmlúu pokki bisa na hílsúu rë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yee won Yéesú baa ra sëpíɗté kaaꞌoh yi ɓéeɓ⁠ ⁠; ndaa keeññi ɓëewí kayya ɓéeɓ sosse di iñi wunna na paŋ ri ra. ");
INSERT INTO ndv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Nguur ki Koope madaꞌ a yih⁠ ⁠? May rii mëllée a yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ɗi madaꞌ a pebi ƴutuudi baa ɓeɓ ow, sohte ri meeyi ra nen⁠ ⁠: ɗi paalte, ooɗte níi hente tal kilik⁠ ⁠; ƴakka ayute túfúté yaꞌ ya.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yéesú wonil tih⁠ ⁠: «⁠ ⁠May mëllée Nguur ki Koope a yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ɗi madaꞌ a lëwíirë ɓeɓ ow ɓeleɓ, boollaꞌte wa a mún caak, íƴíɗté wë níi wa ɓéeɓ fuuɗte ra nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yéesú hom waali Yerusalem fa, ñeete ginna na yëeddëꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lahte ɓëyí meelte ri won tih⁠ ⁠: «⁠ ⁠Ɓahaa, ɓëewë nay múcé rë ac ƴutuuɗ a⁠ ⁠?⁠ ⁠» Yéesú won ɓëewë maasuu ra tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«⁠ ⁠Pëgí ɓéeɓ níi ɗon haalaꞌ ílí ƴutuuda⁠ ⁠; daa mi won ɗon ɗi ee⁠ ⁠: ow caak ay étíɗ haal te wa ii rii mín. ");
INSERT INTO ndv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yiin kolaa yíkíi faam fa níi won ílë ɗeefa ɗon hëelíh rë, ɗon ay home ëssë, ɗon laɓe ílë, ɗon wone tih⁠ ⁠: “Ɓahaa, kúnsíɗ fun⁠ ⁠!” Ɗi ay ron lofe tih⁠ ⁠: “Mi yéeh rën⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ɗon ay rii wone tígí daaha tih⁠ ⁠: “Yen bokuy ñam a han, te fu yëeddëꞌté këemmë gin fun a⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ɗi ay ɓaat won ɗon tih⁠ ⁠: “Mi yéeh rën⁠ ⁠! Wúlíi sëꞌ, ɗon fa paguu yin ɓos ra ɓéeɓ⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ɗon ot Abraham, Isaak, Yakop a yonente ya ɓéeɓ filiɓ Nguur ki Koope, ɗon anti líkú ɗon saañ ëssín rëe, ɗon ay looyee daaha, ɗon ŋafoh níi tíññën lec. ");
INSERT INTO ndv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bín fë, ay lah ɓëewí kolaꞌ tígí hom ow feey fa ɓéeɓ, ac ñami ndaje ma cëgíɗ Koope Nguur ki ra. ");
INSERT INTO ndv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Di ɓëewë míllúu woteh ƴee ra, lahte na ƴi ay këllëh yiin fa, te di ƴee këllúu woteh ƴee ra, lahte na ƴi ay míllëꞌ yiin fa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","I fariseŋ leɓuute Yéesú wahtii baaha, wonu ri tih⁠ ⁠: «⁠ ⁠Kolee dee fu saañ ílíƴ kay⁠ ⁠! Erot ee saam hawrohu húl rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Pëyí ɗon woniɗ soꞌ tisoh ki gúmfí baa biti woteh a kéy mí lík yébítëh mi na paƴ jéríɗ, nah mi ɗúmël légéyí sëꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Woteh, kéy a nah ɓéeɓ mi waɗti homa waali Yerusalem fi soꞌ, ndée yonente waruy hawuu húl ílíƴ kay henay dín fë. ");
INSERT INTO ndv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«⁠ ⁠Ɗon fi ɓëy Yerusalem daal, ɗon fa na bëemú yonente ya ra, ɗon fa na tawu ɓëewë Koope wol wa ɗon na laꞌ níi wa húl rë, hente waal ɗíh ma na fahaꞌ négírëꞌí rën hëbís sëꞌ ti di na négírëꞌ paan ƴiilli paɓɓi nen⁠ ⁠? Ndaa ɗon fahuuy⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kon Koope yeɗɗaꞌte ron ginon⁠ ⁠! Mee ron won ra ee⁠ ⁠: ɗon ii soo olil níi wahtaa nay ron wonee bitih⁠ ⁠: “Koo-Yíkëe barkela ɓëeꞌ ɗi wol ri ra⁠ ⁠!”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bisa na hílsúu yëwúɗɗë rë ín, Yéesú dëekúté ñam faam ow di kélfë yí fariseŋŋa. Ɓëewë húmú në rë yípúté íllí wë sun fi na olsuu ri. ");
INSERT INTO ndv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɓëyí lahaꞌ jér hufil húmú në. ");
INSERT INTO ndv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yéesú won yëeddëh yí kootii Mëyíis a fariseŋŋa tih⁠ ⁠: «⁠ ⁠Kootii yen onaꞌte ow paƴ jéríɗ bisa na hílsúu rë ëe onaay⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ndaa wa kaaꞌuute lofi. Tígí daaha, ɗi tíkké jérdë yaꞌ paƴce ri, wonte ri saañ faam. ");
INSERT INTO ndv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ɗi antee won ɓëewë tih⁠ ⁠: «⁠ ⁠Ow di ɗon na lah koy mbée fanfi keen filiɓ yéem koon, wuti hena bisa na hílsúu rëe, ɗi ii rii yíppí nís ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wa lahuy yii wonun wa di yee meel ri wa baa ra. ");
INSERT INTO ndv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yéesú otte biti haneella tansuu tíkkë këllëh rë, ɗi na líkín wë won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«⁠ ⁠Ow gap ro ndaje raa, ngana pay fu tooke tíkkë këllëh rë. Mín lah ɓëyí luk roo gaan dëekúté, ");
INSERT INTO ndv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","yíkíi ndaje ma anti ac won ro tih⁠ ⁠: “Kolee fu on ɓëyí bee took.” Fay sopoh tígí daaha fu koloh, fu saañ tooke níi tíkkë míllëꞌ rë. ");
INSERT INTO ndv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ngana hen ɗah⁠ ⁠! Fu gapu ndaje raa, lah tooke tíkkë míllëꞌ rë⁠ ⁠; ɗaaha, yíkíi ndaje ma ac raa mín rëe won tih⁠ ⁠: “Leɓee dee kooja, fu took tíkkë këllëh rë.” Hen ɗaaha raa, ɓëewë ɗoni wa tooku ra ɓéeɓ ay roo habaꞌ ow gaan. ");
INSERT INTO ndv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yúhí biti ɓëyí ɓéyíɗ afi ɓéeɓ ay cépírú, te ɓëyí cépíɗ afi ɓéeɓ ay ɓéyrú.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yéesú antee won yíkíi ndaje ma tih⁠ ⁠: «⁠ ⁠Fu ƴahti gapaꞌ ndaje raa, ngana gap kooƴƴu, mbée koy-yaayyu, mbée mboko yu, mbée yíkëe yí alalla ɗoni wa dékú rë⁠ ⁠; ndée wa fi ƴaaha mínú rëe dëek ñam ɓal, te bín fë rëe, ɗeef wa yínlú rë yee pagiɗ fu wa ra. ");
INSERT INTO ndv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Fu ƴahti gapaꞌ ndaje raa, lah dëeké manti ñëkíɗɗë nen, ɓëewë cérrí wë mitay ra, lëfëñíɗɗë mbée búumíɗɗë. ");
INSERT INTO ndv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Fu paŋ yii baa raa, keeñu ay naa sos⁠ ⁠; wa míníh rëe yíníl, Koope nay roo yínlé yiin nay rii këllé ɓëewë júɓú rë ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ow di haneella kelaꞌ ri unni ƴaa ra, won Yéesú tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ nay maasee ñam Nguur ki Koope ra, keeña ay sos.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yéesú ñeyaꞌte ri léehí beh won ɗi tih⁠ ⁠: «⁠ ⁠Lahte ɓëyí cëgíɗté ndaje, gappe ow caak ñama. ");
INSERT INTO ndv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tígë në waaƴaꞌ ñama woc ra, ɗi wolte súrgíi woni ɓëewë gapu ra biti ñama nonte. ");
INSERT INTO ndv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ndaa ɓëyí rí pay ɗii na ɓéeɓ, ɓëeꞌ won ɗi biti ɗi ii mín ac. Ɓëeꞌ ɗéɓ ɗë won ɗi tih⁠ ⁠: “Lah wone ri baal soꞌ⁠ ⁠! Mi liiltee lom meey te mi waɗtee pay kénsëhí.” ");
INSERT INTO ndv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ow kay won ɗi tih⁠ ⁠: “Lah wone ri baal soꞌ⁠ ⁠! Mi lom fana loꞌ sabboo te mi saañ étɗí wë lín ɗee koon.” ");
INSERT INTO ndv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ow kay wonil tih⁠ ⁠: “Lah wone ri manti ɗúhëꞌ kooɗ daa tah mii mín ac.” ");
INSERT INTO ndv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«⁠ ⁠Súrgëe nimilte kélfëe në, léhínté rí iña wonu ri ra. Keeñ kélfëe haayte, ɗi won súrgëe tih⁠ ⁠: “Yípée pay këemmë a waalla gina, fu kúɗ ñëkíɗɗë deh, ɓëewë cérrí wë mitay ra, búumíɗɗë a lëfëñíɗɗë.” ");
INSERT INTO ndv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«⁠ ⁠Hompe níi súrgëe acce, won tih⁠ ⁠: “Ɓahaa, mi paŋke yee nah fu soꞌ ra ndaa tíkkë líssí tas.” ");
INSERT INTO ndv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kélfëe won súrgíi tígí daaha tih⁠ ⁠: “Tawee waalla luufa, fu cagoh ɓëewë ɗoni wa nay teeꞌee ra, wa ac haal nda faam soꞌ líif. ");
INSERT INTO ndv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mee ron won ra ee⁠ ⁠: yaꞌ ow yínë sah di ɓëewë ɗéɓúu gapu ra ii haal looni soꞌ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lahte bis, Yéesú na saañ, ow caak ñéerúuté a ri. Ɗi yíssëhté waa na, won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«⁠ ⁠Ɓëyí ac soo na te ri lukki pokoh boffi na, yaafi, ɓeleɓi, koyyi, koy-yaayyi, mbée ɗi fi afi na raa sah, ɗi mínéh hen taalibeyi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ɓëyí enaay kurwahi ñee tal soꞌ, mínéh hen taalibeyi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«⁠ ⁠Ow fahaꞌ taɓah taahi utte raa, ɗi ii took paaƴ olsoh iña waɗ naa haal ra, ɗi yúh nda ɗi ay lah hélsí ay mín lúsíɗ taaha a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Henay bah, ɗi dal taɓah anti mínéh lúsíɗ rëe, ɓëewë nay ole yii baaha ra ɓéeɓ ay rii ñaawal ");
INSERT INTO ndv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wone tih⁠ ⁠: “Ëlí ɓëyée dal taɓah bee te mínéh lúsíɗ rë⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«⁠ ⁠Te buur koloh haaꞌ a buur kay raa, ɗi waray took paaƴ olsoh nda ɓëewí júnní sabboo (10.000) ya lahaꞌ ri ra, ɗi ay naa mín haaꞌ a buura na yejoh ɗii na a ɓëewí lecsuu ƴii ana ra a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Hena biti ɗi mínéh rí rëe, ɗi ay wol i ow buuri yínëe në balaa ri koloh, wa ɗaŋ ri nda wa mín júɓëꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ti ɗaaha nen, ow yínë di ɗon na mínéh hen taalibeyi soꞌ, hém ri takaay a iña lahaꞌ ri ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«⁠ ⁠Ɗon yúhúté biti miraa yin wun, ndaa wa lahlilay cafka raa, wa ay nimiliruu cafkii wa ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɗi lahay njiriñ tígí daaha, ɗi wuneh sah tohaa⁠ ⁠; ɗi ay yúfú sénín. Ɓëyí lah nuf kelaa, kelaan na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yeekoh yi túmë a i bakaaroh kay leɓuute síkírëhí Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yaa neɓaay fariseŋŋa a yëeddëh yí kootii Mëyíis, tahte wa na wonaaluu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Ɓëyí bee tahaꞌ bakaaroh ya a yaꞌ ana na bok a wa ñam bee raa⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tígí daaha, Yéesú ñeyaꞌte wa léehí beh won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«⁠ ⁠Ow di ɗon na lah har tíméer (100), an naa múuƴlëꞌ yínë rëe, ɗi ii hel harri sabay payniil a payniilla (99) níirëe yë, ɗi saañ saame bee múuƴ ɗë níi ɗi ot ɗi a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te ɗi ot ɗi raa, keeña ay sos níi sos, ɗi ɓeɓ har fa tëgúm rí, ");
INSERT INTO ndv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ɗi saañ faam, anti dëek kooƴƴi a ɓëewë ɓani wa dékú rë, won wa tih⁠ ⁠: “Yen bokun yen lah sos-keeñ, ndée mi otte har fee ke soꞌ húmú múuƴ ɗë⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mee ron won ɗa ee⁠ ⁠: ti ɗaaha nen, bakaaroh yínë kut lof pesaɗ raa, Koope lahaꞌ sos-keeñ ɗaaha. Sosi keeña lahaꞌ ri ɓëeꞌ lof pesaɗ baa ra, daa lukki gaan sosi keeña lahaꞌ ri ɓëewí sabay payniil a payniilla (99) júɓú te sohluuy lof pesaɗ ɗa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«⁠ ⁠Mbée lah ɓelii lahaa hanjar úrís sabboo, an naa múuƴɗëꞌ úrís yínë rëe, ɗi ii këríɗ lampa, saak faam fa saame níi ot ri a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te ri ot ɗi raa, ɗi ay dëek kooƴƴi a ɓëewë ɓani wa dékú rë, won wa tih⁠ ⁠: “Mi otte hanjari úrísë múuƴɗëꞌ mí rë⁠ ⁠; ëyí yen bok yen lah sos-keeñ⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mee ron won ɗa ee biti ti ɗaaha nen⁠ ⁠: malaaka yi Koope ay lah sos-keeñ biti bakaaroh yínë kut lof pesaɗ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yéesú ɓaatte ñeyaꞌte wa anili bee na léeh wë won tih⁠ ⁠: «⁠ ⁠Lahte ɓëyí húmú lahaꞌ koy ƴaal ana. ");
INSERT INTO ndv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Lahte bis, bee paaꞌ kúkëy rë won boffi tih⁠ ⁠: “Baap, mi fahaꞌ biti koon fu yeɗ soꞌ wodi soꞌ di alal ma lahuu yen ra.” Tígí daaha, boffa woraꞌte wa alal ma. ");
INSERT INTO ndv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«⁠ ⁠Tíkëh i waal, koy ka paaꞌ kúkëy rë yaayte ƴee lahaꞌ ri ra, ɓeɓpe hélsë saañce gini wulte, hompe dín fë na paŋ yii neɓaꞌ ri níi ri yahte alal mi ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yaayaꞌ ri hélsë ɓéeɓ rë, yaabi misikke haalte gina, ɗi lahlay yii ñama ri. ");
INSERT INTO ndv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɗi yeeltee saañ, haalte légéy ow di ɓëy gina na⁠ ⁠; ɓëeꞌ yeñce ri meeyyin níirí mbaam-túgëllí. ");
INSERT INTO ndv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yaaɓaꞌ ri níi yaaɓ ɗa, nufa tasse ñam di ñami mbaamma, ndaa ow na oneh ri na. ");
INSERT INTO ndv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«⁠ ⁠Tígí daaha, afa kúnsëhté, ɗi yíppée won nufi tih⁠ ⁠: “Ɓëewë në légéyírú baasoꞌ ra caakute ñam níi míníh yin na, mi anti home dee mi húlé a yaaɓ a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","May kolee koloo mi nimil faam baasoꞌ, mi won ɗi tih⁠ ⁠: Baap, mi bakaaɗte fíi Koope te mi tooñce ro ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mi caleh fu habee soꞌ koohu⁠ ⁠; ɓeɓ soꞌ mi légéyíɗ ɗë ti ɓëewí kayya nen.” ");
INSERT INTO ndv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","«⁠ ⁠Ɗi yíppée koloh na nimil boffi na. Ɗi teem hanndal boffa séenté rí, keeña ɗúmpé ɗii na ces⁠ ⁠; ɗi múkëté téebílëhí, yabaalohte faana, wodohte ri níi wodoh. ");
INSERT INTO ndv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Koy ka won ɗi tígí daaha tih⁠ ⁠: “Baap, mi bakaaɗte fíi Koope te mi tooñce ro ɓal, mi caleh fu habee soꞌ koohu.” ");
INSERT INTO ndv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ndaa boffa yíppée lec woni, yíssëhté súrgë yí në won wa tih⁠ ⁠: “Yípíi kali búubë lukki wun ɗa, ɗon ɓek ri koy soꞌ⁠ ⁠; ɓékí rí supi kuna, ɗon ɓek ri ñafaɗ. ");
INSERT INTO ndv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Këlí fanfa lukki wun faan ɗa, ɗon hap ri, yen cëgíɗ ndaje. ");
INSERT INTO ndv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Koy kee ke soꞌ húmú habaꞌ mi biti húlté rë nimilte yéelíɗ⁠ ⁠; ɗi húmú sooƴce te mi otte ri⁠ ⁠!” Ndaje ma yíppée dal. ");
INSERT INTO ndv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«⁠ ⁠Wahtii baaha, ɗeef koy ki saawi ɓëeꞌ húmú meey. Na nimil ri níi rí leɓohte faam fa ra, ɗi kelohte típpë a becca. ");
INSERT INTO ndv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɗi dëekké ow yínë súrgë yë në, meelte ri yee lah ra. ");
INSERT INTO ndv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Súrgëe won ɗi tih⁠ ⁠: “Ñéedú daa nimil, boffu antee hawroh fanfa lukki wun faan ɗa, af biti ri otte koohi te yin katay ri.” ");
INSERT INTO ndv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Koy ki saawa yíppée neeɓ, kaaꞌaꞌte haal faam fa. Boffa ɗúhté ɗii na, ɗaŋke ri haal filiɓ. ");
INSERT INTO ndv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ndaa ri won boffa tih⁠ ⁠: “Síkírëh sëꞌ baap⁠ ⁠! Hente kíil caak mi na hap faan soꞌ légéyírú, te yii túuƴ fú sëꞌ ɓéeɓ mi paŋ ri. Añcaŋ, fu ënɗëy sëꞌ wuti ƴaha ndeŋ sah mi hap ri, funi kooƴƴi soꞌ cëgíɗ ndaje. ");
INSERT INTO ndv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ndaa ayaꞌ koohu ra, ɗi fa yah alal mu a ɓeleɓɓa na tílú rë, fu hawiɗte ri fanfa lukki wun faan ɗa.” ");
INSERT INTO ndv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Boffa won ɗi tih⁠ ⁠: “Koy soꞌ, fu mëssí hom soo na, te iña lahaꞌ mi ra ɓéeɓ daa fu lahaꞌ wa ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ndaa yen warutee cëgíɗ ndaje nam, yen lah sos-keeñ⁠ ⁠! Ñéedée ke ro bee húmú habaꞌ mi biti húlté rë nimilte yéelíɗ⁠ ⁠; ɗi húmú sooƴce mi otte ri.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yéesú ñeyaatte taalibe yi anil na léeh wë won tih⁠ ⁠: «⁠ ⁠Ɓëyí caakke yin húmú lahaꞌ dagi daa na tooppitoh alal mi⁠ ⁠; ɗi antee keloh biti daga yahaꞌ alal mi yahoo. ");
INSERT INTO ndv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ɓëeꞌ dëekké daga, won ɗi tih⁠ ⁠: “Yee keloh mi ɗoo na ra neɓaay soꞌ⁠ ⁠! Teeɓ soꞌ ɗee légéyëꞌ fú rë⁠ ⁠; woc raa fu yeris légéyë.” ");
INSERT INTO ndv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Daga won nufi tih⁠ ⁠: “Bee nay mii líkúu légéy bee ra, may hene ɗíh⁠ ⁠? Mi lahay doole línëe te mi sopohte saraatoh. ");
INSERT INTO ndv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mi otte yee nay mii page ra, hen ɗaaha mi líkú légéyí sëꞌ rëe, lah ɓëewí mín sëe yef faam wa.” ");
INSERT INTO ndv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tígí daaha, ɗi dëekké ɓëewë lahru kélfíi kabut ra ɓéeɓ yínë-yínë. Ɗi won bee ɗéɓ ɗë tih⁠ ⁠: “Fu lahiɗ kélfíi sëꞌ yih⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ɓëeꞌ won ɗi tih⁠ ⁠: “Mi lahiɗ ɗi bërgú dúuléen tíméer (100).” Daga won ɗi tih⁠ ⁠: “Kéedí kabut ku abeh⁠ ⁠; yípée took fu bíní bërgú sabay iip (50).” ");
INSERT INTO ndv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ɗi antee dëek ow kay, won ɗi tih⁠ ⁠: “Fu lahiɗ kélfíi sëꞌ yih⁠ ⁠?” Ɓëeꞌ won ɗi tih⁠ ⁠: “Mi lahiɗ ɗi saaku pep tíméer (100).” Daga won ɗi tih⁠ ⁠: “Kéedí kabut ku abeh⁠ ⁠; bíníyé saaku sabay peeye (80).” ");
INSERT INTO ndv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kélfëe laasse ɗee lahaꞌ daga júɓëy rë nuf. Kaah biti ɓëewë fahuu ëldúnë rë luku ɓëewë homu niiña ra lah nuf pagaa yin hanndal ki wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Mantee ron won tee⁠ ⁠: sëemí kooƴ a alal ma lahuu ron feey fi bee ra, nda tíl níi ɗon lahluy wa raa, Koope tah ɗon faami níi kiri fi kirih. ");
INSERT INTO ndv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ɓëyí júɓ di yin ƴutuuɗ, ay júɓ di yin gaan ɓal⁠ ⁠; ɓëyí júɓëy di yin ƴutuuɗ, ii júɓ di yin gaan. ");
INSERT INTO ndv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kon hena biti ɗon júɓúy di na kúrúu ron alal ma feey fi bee raa, ɗon habuu biti ɗon ay déŋéenú alal ma lukki lah solo ra a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te hena biti ɗon júɓúy di yii leŋke alal ow kay raa, ɗon yaakaaru biti ɗon ay liil alal ma waɗ ɗon lahuun faraah ra a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Lahay súrgíi mín légéyíɗ kélfë ana⁠ ⁠: ɗi ay kaaꞌ ow yínë waa na, pokoh ɓëyí yínëe në⁠ ⁠; ɗi ay ñee won ow yínë waa na, kaaꞌ síkírëhí ɓëyí yínëe. Ti ɗaaha nen, ɗon míníh boollaꞌ foŋko Koope a foŋko hélíis.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseŋŋa tíkú hélíis kep affi wa ra, keluu wa unnee ke Yéesú ƴaa ra, wa ɓéeɓ na këekkëlíyú rí. ");
INSERT INTO ndv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon fahuu biti ɓëewí kayya habaꞌ ron ɓëewí júɓúté, ndaa Koope yúh yee keeññon. Yee na habuu ɓëewë biti daa lukki lah solo ra, ɗi yii ɓosse níi ɓos Koope na. ");
INSERT INTO ndv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Balaa Saŋ Batis, Koope húmú ñeyaꞌ Kootaa a téeré yí yonente ya yëeddée. Ayaꞌ Saŋ níinén Uni Nebi Nguur ki Koope daa na waariyu te ɓëyí fahaꞌ naa haal ɓéeɓ fay naa cagoh. ");
INSERT INTO ndv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Biti sun a feey muuy daa lukki yooɓ biti koy una lukki ƴin di Kootaa ra múuƴ. ");
INSERT INTO ndv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ƴaali yes ɓeleɓi, kooɗ ɓeleɓ kay, njaaliyohte. Te ɓëyí kooɗ ɓelii yesute, njaaliyohte ɓal. ");
INSERT INTO ndv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«⁠ ⁠Húmú lahaꞌ ɓëyí caakke alal, ɗi ɓekaꞌ búuɓɓí wunte te kofeelte, faraah ɗi ñamaꞌ neɓ. ");
INSERT INTO ndv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bín fë, húmú lahte ñëkídí hínú Lasaar, faana ɓéeɓ líiffé puul, fënɗúté helute ílí faam ɓëeꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nufa tasse wooñnjiidi ñami ɓëeꞌ, ndaa ri liileh na. Ɓaatte biti ɓuh ya na ayu ɗeewe puulla faana. ");
INSERT INTO ndv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«⁠ ⁠Hompe níi ñëkídë húlté, malaaka ya kúrúté rí hëbís Abraham. Yíkíi alal ma húlté ɓal, hacute, ");
INSERT INTO ndv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","saañce safara, na mok dín fë. Ɓéyrëꞌ rí afi ra, ɗi séenté Abraham, Lasaar tookke hëbísí. ");
INSERT INTO ndv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɗi won Abraham tígí daaha tih⁠ ⁠: “Caac Abraham yérém sëꞌ, fu wol Lasaar soop kuni muluɓ kom soꞌ, mi hilsiɗ gol-gol soꞌ, ndée mi mokke filiɓ kíi kí ƴee níi mok.” ");
INSERT INTO ndv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ndaa Abraham won ɗi tih⁠ ⁠: “Koy soꞌ, nérsée biti fu liilte neɓu na húmú pesaꞌ fu ra, te Lasaar húmú pesaꞌ coono. Ɗi liilte nebi leegi, fu hompe coono. ");
INSERT INTO ndv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɓaatte biti nuŋ gaan ee hanndal ki yen, tahte ow mínéh koloh fun na ac ɗon na, te ow mínéh koloh ɗon na ac fun na.” ");
INSERT INTO ndv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yíkíi alal ma won Abraham tih⁠ ⁠: “Kon mi na ɗaŋ ɗo Caac, fu wol Lasaar faam fun⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mi lahte na ñéyíɗ iip, lah raa ɗi líkín wë, toñeh wa ay soo ɗeefre coono fi beh.” ");
INSERT INTO ndv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham won ɗi tih⁠ ⁠: “Wa lahute kootii Mëyíis a téeré yí yonente ya waa na níi wocce, wa ñeyun iña wonu na ra.” ");
INSERT INTO ndv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yíkíi alal ma won ɗi tih⁠ ⁠: “Ëe-ëeꞌ caac Abraham, ƴaa doyay⁠ ⁠; ndaa ow koloh ɓúudé pay waa na raa, tígí daaha wa ay lof pesaɗ.” ");
INSERT INTO ndv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham won ɗi tih⁠ ⁠: “Wa kaaꞌ keloh woni Mëyíis a yonente ya raa, wuti ow koloh ɓúudé ɗeefiɗ wa raa, wa ii rii síkírëh.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yéesú won taalibe yi tih⁠ ⁠: «⁠ ⁠Faraah ay lah iñi ay ɓeke ow bakaaɗ. Ndaa mas ɓëeꞌ nay waa komee ra⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɗi poku laꞌ gaan lúum betu kísí, daa nay géné ɗii na, balaa ri ɓek wuti ƴaha ow yínë di tuŋki ƴee bakaaɗ, wa fi taalibe yi soꞌ⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kon cëgí affon⁠ ⁠! «⁠ ⁠Koy-yaafu tooñ ɗo, tëekɗé rí fu won ɗii na. Ɗi réeccíyëh rí níi ri won ɗo baaha raa, lah baale ri. ");
INSERT INTO ndv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wuti ɗi tooñaꞌ ro waal paana bisa raa sah, te faraah ɗi ac wonu biti ɗi réeccíyëhté rëe, lah baale ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apootarra wonu Yéesú-Yíkëe tih⁠ ⁠: «⁠ ⁠Ɓaate ngémí fun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon lah ngém wuti ƴaha ƴutuuɗ koon sah, ɗon nah tal kilki bee saañ yípée kísí, ɗi ay ñee wonon.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yéesú wonil tih⁠ ⁠: «⁠ ⁠Ow di ɗon na lah súrgíi línëꞌ línëe mbée níirëꞌ níirëe koon, ɗi ot ɗi ac meey fa raa, ɗi ay rii yíppí dëek ñam a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ëe-ëeꞌ⁠ ⁠! Ɗi ay rii wone ti kay⁠ ⁠: “Lofee búuɓ, fu pagiɗ soꞌ ñam, fu tíkíɗ sëꞌ loona mi ñam. Mi woc ɗaa, fu anti mín ñam.” ");
INSERT INTO ndv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kon ɗi lahay yii nay rii gérmée súrgíi⁠ ⁠; súrgëe paŋ yee waɗ ɗii na ra⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ti ɗaaha nen, ɗon paŋ iña nahu ron ra ɓéeɓ rëe, lah hëbíi biti ɗon i súrgë kut, ɗon pagu yee waɗ ɗon na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yéesú hom waali Yerusalem, ñeete hanndal ki Samari a Galile. ");
INSERT INTO ndv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tílëꞌ rí níi leɓohte gin ra, guuñiɗ sabboo téebílúuté rí, cagute hanndal, ");
INSERT INTO ndv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","anutee ɗaañnjoh na wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa yérém fun, hém neɓaꞌ ro⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Olaꞌ wa Yéesú rë, ɗi won wa tih⁠ ⁠: «⁠ ⁠Pëyí seeƴoh ya na, wa olsoh ron.⁠ ⁠» Wa homu saaña, wa wahute. ");
INSERT INTO ndv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ow yínë waa na olaꞌ ri biti wahte ra, ñeyaatte kotti na nimil, ɓéyíɗté uni sun na kañ Koope. ");
INSERT INTO ndv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Lahaꞌ ri Yéesú në rë, ɗi yeɗɗohte kotta, yíppé púkí feey na sím rí. Ɗi fi baa ɓëy Samari. ");
INSERT INTO ndv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yéesú won tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓëewí sabboo ya ɓéeɓ daa wahu neh a⁠ ⁠? A ɓëewí payniilla dih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ow níɓëy nimil kañi Koope sah henay ɓëyée yëwúɗ neh bee ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yéesú antee rii won tih⁠ ⁠: «⁠ ⁠Kolee fu saañ⁠ ⁠! Ngémú tahte fu wahte.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Lahte bis, i fariseŋ meelute Yéesú wahtaa nay aye Nguur ki Koope ra. Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ayi Nguur ki Koope yii nay olu a íl neh. ");
INSERT INTO ndv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ow mínéh won bitih⁠ ⁠: “Ëlí, ɗi abeh⁠ ⁠!” mbée “Ɗi abin⁠ ⁠!” Yúhí biti ɗi ee leeloon ee.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ɗi antee won taalibe yi tih⁠ ⁠: «⁠ ⁠Ay lah jamanu, ɗon ay fahaꞌ hom a soꞌ mi Koy-ɓëeꞌ, wuti hena bis yínë kut, te ɗon ii rii lah. ");
INSERT INTO ndv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ɗon ay wonu biti Koy-ɓëeꞌ abeh, mbée ri abin⁠ ⁠; ndaa ngënë tíkí në nuffon, ngënë pëyí në. ");
INSERT INTO ndv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Di na hélƴëꞌ Koo hawaan feey fa ɓéeɓ, ayi soꞌ mi Koy-ɓëeꞌ ay made ɗaaha nen. ");
INSERT INTO ndv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ndaa balaa baaha, ɓëy jamanii bee ii soo fahaꞌ tík íl te mi waɗtee mok níi mok. ");
INSERT INTO ndv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«⁠ ⁠Jamanii nimili soꞌ mi Koy-ɓëeꞌ ay madee a yee húmú lah jamanii Nowe ra nen. ");
INSERT INTO ndv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jamanii Nowe, ɓëewë húmú feey fa na ñamu na hanu, ƴee na koorantuu, níi yiin haal Nowe gaala ra. Mbënë më ayaꞌ tígí daaha kúɗté wë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«⁠ ⁠Ɗi ay madee a jamanii Lot nen ɓal⁠ ⁠: ɓëewë homute na ñamu na hanu, ƴee na lomu, ƴee na yaayu, ƴee na sohu, ƴee na taɓahu⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ndaa yiin koloh Lot Sodom ra, Koo toɓ kíi a laꞌ yi na kaɗ, níi muuyilte wa ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jamanii nimili soꞌ mi Koy-ɓëeꞌ ay made ɗaaha nen⁠ ⁠; daa mi won ɗon ɗi. ");
INSERT INTO ndv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«⁠ ⁠Yiin fa, ɓëyí ɗúh këem, ɓanan haal kali yin faam⁠ ⁠; ɓëyí liilti saañ meey, ɓanan nimil faam. ");
INSERT INTO ndv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nérsíi yee húmú kat ɓeleɓ Lot ɗa. ");
INSERT INTO ndv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɓëyí núp húl ay ñak ñíiní⁠ ⁠; ndaa ɓëyí tah ñagi ñíiní ay lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mee ron won ɗa ee bitih⁠ ⁠: elgi baaha, ow ana ay bok tigal ka yínë⁠ ⁠: ow yínë waa na ay kúrú, ɓëyí yínëe helu. ");
INSERT INTO ndv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ɓeleɓ ana ɓal ay hom hoɗ⁠ ⁠: ow yínë waa na ay kúrú, ɓëyí yínëe helu.  ");
INSERT INTO ndv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ƴaal ana ay hom meey⁠ ⁠: ow yínë waa na ay kúrú, ɓëyí yínëe helu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Taalibe ya meelute Yéesú wonu tih⁠ ⁠: «⁠ ⁠Yíkëe, yii baa ay lahee tígí dih⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Tígí etaꞌ médë, suulla teeꞌuu na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Filoon fe, Yéesú na teeɓ taalibe yi biti ow waɗti ɗaga Koope ɗago faraah ɓanti jëbël. Ɗi ñeyaꞌte wa anili beh na léeh wë won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«⁠ ⁠Lahte aattiyohi húmú gina kíilë⁠ ⁠; ɗi neehay Koope te ɗi yeray ow cér. ");
INSERT INTO ndv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lahte ɓelii húmú gina ɓal ƴaala húlté, hom payaꞌ payoo faraah ɗeefre aattiyoha, wone ri tih⁠ ⁠: “Aattiyaꞌ funi kaaꞌohi soꞌ.” ");
INSERT INTO ndv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Hente yii maañce, aattiyoha kaaꞌaꞌte síkírëhí ɓelaa. Hompe níi lahte bis, ɗi won nufi tih⁠ ⁠: “Kaah biti mi neehay Koo te mi yeray ow cér⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ndaa may paŋ yee waɗ ɓelii bee na ñogol soꞌ faraah bee ra. Henay baa ɗi ay dékée ac, te ɗi ay soo míllëꞌ mokil níi mi tallee húl.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ɗi fi Yíkëe antee ɓaat won tih⁠ ⁠: «⁠ ⁠Kélíi yee won aattiyohi ɓosi baa ra⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ɗon habuuy tígí daaha biti ɗi fi Koope ii yeɗ ɓëewë ri tanis wa ra kaah, wa fa na fogu ɗii na naꞌ a elek ra a⁠ ⁠? Ɗi ay waa yeris daa wa sehe a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mee ron won ra ee bitih⁠ ⁠: ɗi ay waa yíppí yeɗ kaah. Ndaa soꞌ mi Koy-ɓëeꞌ mi ac raa, mbaa may ɗeef ngém feey fa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yéesú antee ñeyaꞌ anili beh na léeh ɓëewë habuu affi wa biti júɓúté íllí Koope te wonuy yin ɓëewí kayya ra, won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«⁠ ⁠Húmú lahte ɓëewí ana yi haalu ɗaŋ Faam fi gaani Koope⁠ ⁠: ɓëyí yínëe fariseŋ, yínëe yeekoh túm. ");
INSERT INTO ndv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseŋa hom a afi na ɗaŋ Koope won tih⁠ ⁠: “Koope, mi na sím rë di yee maday mi a ɓëewí kayya ra⁠ ⁠: ƴee na lohu, ƴee na njaaliyuu a ɓëewí ɓossi kayya. Mi na sím rë di yee maday mi a yeekohi túmí bee ra. ");
INSERT INTO ndv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bis níi nimil ki bis, mi na oor na waal ana, te yii lah mi ɓéeɓ, woruun sabboo raa, mi yeɗ ɗo wodi yínëe.” ");
INSERT INTO ndv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ɗi fi yeekohi túmë hompe filoon, kaañay sah ɓéyíɗ afi, yampe na laɓ araali won tih⁠ ⁠: “Koope yérém sëꞌ, soꞌ mi bakaarohi beh.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Mee ron won ɗa ee bitih⁠ ⁠: nimilaꞌ yeekohi túmë faam ra, Koope habaꞌte ɗi fi baa ɓëyí júɓpé, ndaa habaay ri fariseŋa. Yúhí biti ɓëyí ɓéyíɗ afi ɓéeɓ ay cépírú, te ɓëyí cépíɗ afi ɓéeɓ ay ɓéyrú.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Filoon fi baaha, lahte ɓëewí homu komi Yéesú i kúkëy, fahuu biti ɗi tík yaꞌ yi sun fi wa, barkel wa. Oluu taalibe ya yii baa ra, wa na wonu affi wa. ");
INSERT INTO ndv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ndaa Yéesú dëekrëhté tuŋka, won tih⁠ ⁠: «⁠ ⁠Yéɗɗí tuŋka ac soo na, ngënë këddíi wë⁠ ⁠! Yúhí biti Nguur ki Koope saamɗu mani wa. ");
INSERT INTO ndv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí habaay Koope buur ti ɗee habaꞌ kúkëy Koope ra nen, ii hëelíɗ Nguur ki.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ow di kélfë yí yëwúɗɗë meelte Yéesú won tih⁠ ⁠: «⁠ ⁠Yëeddëhí baahi beh, mi waɗti paga yi níi mi lah pesa na ɗúméh rë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu dëekëꞌ sëꞌ baah a⁠ ⁠? Yi daa baah⁠ ⁠? Henay Koope, lahay ɓëyí baahte. ");
INSERT INTO ndv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yen nimil yee meelaꞌ fu koon ra⁠ ⁠; fu yúh iña túuƴëꞌ Koope ra maan⁠ ⁠? “Ngënë mësíi njaaliyoh⁠ ⁠; ngënë mësíi bëem ow⁠ ⁠; ngënë mësíi loh⁠ ⁠; ngënë mësíi feliɗ ow⁠ ⁠; lah tëeppítíi baappon a yaayyon.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɓëeꞌ won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, yii waɗ soꞌ iñƴaa ɓéeɓ mi ñee na kúkëy kí sëꞌ níi a ɗeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kelaꞌ Yéesú unni ƴaa ra, ɗi won ɓëeꞌ tih⁠ ⁠: «⁠ ⁠Fu tallaꞌ yin yínë⁠ ⁠: paye fu yaay iña lahaꞌ fu ra ɓéeɓ, fu woraꞌ cadum fa ñëkíɗɗë. Hen ɗaaha raa, fay lah alal sun-Koo. Fu woc raa, fu ac fu ñee tal soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kelaꞌ ɓëeꞌ unni ƴah, bi caak ri alal níi caak, yaa misikke ri keeñi níi misik. ");
INSERT INTO ndv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Olaꞌ Yéesú biti yaa misikke ɓëeꞌ rë, ɗi won tih⁠ ⁠: «⁠ ⁠Haal Nguur ki Koope kofeelte yíkëe yí alalla na⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Géléem haal gúl kúuc daa lukki yooɓ biti yíkëe alal haal Nguur ki Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɓëewë në húmú síkírúu rí rë wonu tih⁠ ⁠: «⁠ ⁠Kon daa míntí múc⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yéesú won tih⁠ ⁠: «⁠ ⁠Yii wooñ ow wooñeh Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peer won tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓahaa ole⁠ ⁠! Fun helute iña húmú lahuu fun ra ɓéeɓ, fun ñeyute talu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí af Nguur ki Koope tah ri hel faami, ɓeleɓi, koy-yaayyi, boffi, yaafi mbée koyyi, ");
INSERT INTO ndv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ɗi ay lah ƴi luk ƴaa caak fap di jamanee woteh beh, te fayu ɗi ay lah pesa na ɗúméh rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Filoon fi baaha, Yéesú hécëhté ƴutuuɗ a taalibe yi sabboo a ana ya, won wa tih⁠ ⁠: «⁠ ⁠Síkíríi⁠ ⁠! Yen ee suu Yerusalem ra ee, te iña bíníyú yonente ya sun fi soꞌ mi Koy-ɓëeꞌ rë ɓéeɓ ay lah. ");
INSERT INTO ndv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","May tíkú yaꞌ yi ɓëewë yëwúɗ neh ra, te wa fi ƴaa ay soo ñaawal, solsaꞌ soꞌ, tuulsaꞌ soꞌ, ");
INSERT INTO ndv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","laɓisaꞌ soꞌ laraw, an soo hap húl. Te waali éeyë fë filoon fi húlí sëꞌ, may koloh ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ndaa taalibe ya húmú yíih yee fahaꞌ ri waa won ra⁠ ⁠; wona kúnté affi wa. ");
INSERT INTO ndv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na leɓoh Yéesú Yéríkëe rë, ɗeef lahte búumndí húmú took ɓúk waala na saraatoh. ");
INSERT INTO ndv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kelaꞌ ri dúukëlí ɓëewë në gétú rë, ɗi meelaꞌte yee lah ra. ");
INSERT INTO ndv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɓëewë wonute ri biti Yéesú fi ɓëy Nasaret daa na ñee daaha. ");
INSERT INTO ndv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ɗi foŋke tígí daaha won tih⁠ ⁠: «⁠ ⁠Yéesú, sédí Dawit, yérém sëꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɓëewë këllúu rë na wonu afa, fahuu biti ɗí héddëh, ndaa ri lukki foŋ na, na won tih⁠ ⁠: «⁠ ⁠Sédí Dawit, yérém sëꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tígí daaha, Yéesú caŋke, kallirohte ri. Ayaꞌ ri ra, Yéesú meelte ri won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«⁠ ⁠Fu fahaꞌ biti mi pagira ro yih⁠ ⁠?⁠ ⁠» Ɗi won tih⁠ ⁠: «⁠ ⁠Yíkëe, page níi íllí sëꞌ wërsëh, mi mín ot⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yeele, ngémú tahte fu wahte.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Íllë yíppée wërsëh, ɗi na ot. Ɗi ñeete tal Yéesú na kañ Koope. Oluu ɓëewë yee lah ra, wa ɓéeɓ na kañu Koope. ");
INSERT INTO ndv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yéesú haalte Yéríkëe na húus gina. ");
INSERT INTO ndv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Daaha, húmú lahte ɓëyí hínú Sase⁠ ⁠; daa ri kélfíi yeekoh yi túmë, ɗi húmú yíkëe alal. ");
INSERT INTO ndv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɗi húmú fahaꞌ oli Yéesú, ndaa bi lúh rí, ɗi mínéh ríi ot af caagi ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɗi yíppée múkë, këllëhté, lappe tal kilik, fahaꞌi oli Yéesú fë ay ñeye daaha ra. ");
INSERT INTO ndv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lahaꞌ Yéesú tígí daaha ra, ɗi ɓéyíɗté afi won Sase tih⁠ ⁠: «⁠ ⁠Yípée cép Sase⁠ ⁠; mi waɗti hanlire ro woteh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sase yíppée cép, kúɗté rí faami, hampe ri haneel a sos-keeñ. ");
INSERT INTO ndv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ɓëewë maasuu ra ɓéeɓ, yaa neɓaay wa, tahte wa na wonu tih⁠ ⁠: «⁠ ⁠Ɓëyée ay hanlire bakaaroh a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sase kolohte, won Yéesú tih⁠ ⁠: «⁠ ⁠Síkírée noo Yíkëe, may on ñëkíɗɗë hatni yíníi alal mi soꞌ ɓéeɓ, te ɓëyí mi liiltee rii nofaꞌ mi ɓeɓpe hélsí ɓéeɓ, may rii nimiliɗ teemi wa iniil.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëy faam fi bee múcúté woteh. Íi, ɓëyí bee ɓal non séttí Abraham. ");
INSERT INTO ndv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yúhí biti soꞌ mi Koy-ɓëeꞌ, mi ac saami ɓëeꞌ múuƴ ɗë, mi sëmlëꞌ rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ɓëewë homute na síkírúu rí. Bi leɓuu wa Yerusalem, te ɓëewë habuu biti Nguur ki Koope leŋ cép, ɗi ñeyaꞌte wa anili beh na léeh wë ");
INSERT INTO ndv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","won tih⁠ ⁠: «⁠ ⁠Húmú lahte ɓëyí non tal kélfë, ɗi hom koloh saañi gini wulte nda ri lah dín fë falu buuri gin wa raa, ɗi nimil. ");
INSERT INTO ndv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Balaa ri saañ, ɗi dëekrëhté ow sabboo di súrgë yí, yeɗte ow di waa na ɓéeɓ hanjar úrís yínë, antee waa won tih⁠ ⁠: “Ɓéyí hélsí ƴeh, ɗon légéyëꞌ wë níi bín nimilaa mi ra.” ");
INSERT INTO ndv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«⁠ ⁠Ɓëyí bah, ɓëy gin wa húmú fahuuy ri, daa tah sayaꞌ ri ra, wa yejute i ow filooni nda ɓëewí ƴaa lah raa, won biti wa fahuuy ɓëyí baa buur. ");
INSERT INTO ndv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kaaꞌeeh ɓëeꞌ falute buur, nimilte gin wa. Ayaꞌ ri ra, ɗi dëekrëhté súrgë yë ɗi húmú déŋéen wë úrísë rë, yúhí iña tíkëh sun ra. ");
INSERT INTO ndv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ɓëeꞌ ɗéɓpí ac ɗa won tih⁠ ⁠: “Ɓahaa, mi lahte hanjar úrís sabboo sun fi bee déŋéen fú sëꞌ rë.” ");
INSERT INTO ndv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Buura won ɗi tih⁠ ⁠: “Eera⁠ ⁠! Fu súrgíi wunte⁠ ⁠! Hém daa fu ñee woni soꞌ, fu paŋke yii ƴutuudi baa raa, mi yeɗte ro fu kúɗ gin sabboo.” ");
INSERT INTO ndv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Súrgíi ana fa acce, won tih⁠ ⁠: “Ɓahaa, mi lahte hanjar úrís iip sun fi bee déŋéen fú sëꞌ rë.” ");
INSERT INTO ndv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Buura won ɗi fi baaha tih⁠ ⁠: “Ɗo ɓal, mi yeɗte ro fu kúɗ gin iip.” ");
INSERT INTO ndv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Súrgë kay acce won tih⁠ ⁠: “Ɓahaa, úrsë déŋéen fú sëꞌ rë abeh⁠ ⁠; mi húmú jok ri líil, mi ɗappe ri. ");
INSERT INTO ndv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Súhë súh fú keeñ ra daa tah mi kaañay ro. Fu ɓeyaꞌ yii fu yefay ri, te fu lecaꞌ yii fu sohay ri.” ");
INSERT INTO ndv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Buura won ɗi tih⁠ ⁠: “Fu súrgíi ɓosse⁠ ⁠! May roo aattiyee unna won fu ra. Fu won neh mi ɓëyí súhté keeñ, mi ɓeyaꞌ yii mi yefay ri, te mi lecaꞌ yii mi sohay ri a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kon haalaꞌ yi níi fu wëtɗëey hélsí sëꞌ⁠ ⁠? Tin bee nimilaꞌ mi bee ra mi laheh na yii tíkëh sun a⁠ ⁠?” ");
INSERT INTO ndv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«⁠ ⁠Ɗi antee won súrgë yë húmú daaha ra tih⁠ ⁠: “Nëefí bee ɗii na, ɗon yeɗ ɗi ɓëeꞌ lahaꞌ sabboo ra.” ");
INSERT INTO ndv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wa wonu ri tih⁠ ⁠: “Ɓahaa, ɓëyí baa liiltee lah úrís sabboo níi wocce⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ɗi won wa tih⁠ ⁠: “Mee ron won ɗa ee bitih⁠ ⁠: ɓëyí ham yee yeru ri ra a yaꞌ ana ay ɓaatu. Ɓëyí pagay yii baaha nék, yii ƴutuuda lahaꞌ ri ra sah ay naafu. ");
INSERT INTO ndv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Di yii leŋke kaaꞌoh yee ke soꞌ fahuuy biti mi hen buuri wa ra, këlí wë deh, ɗon hap wa húl fíi sëꞌ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wonaꞌ Yéesú níi wocce ra, ɗi këllëhté ɓëewë, wa ñéerúuté, ɗi na saañ Yerusalem. ");
INSERT INTO ndv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tílëꞌ rí níi leɓohte Betfase a Betani, hëbís daŋi Ëlíiffë rë, ɗi wolte ow ana di taalibe yi ");
INSERT INTO ndv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","won wa tih⁠ ⁠: «⁠ ⁠Pëyí gina fíi bín. Ɗon haale na raa, ɗon ay naa ɗeef cúmbúr mbaam poku, bi ow yëegírëy rí. Lah pëkísí rí, ɗon kom soꞌ ri deh. ");
INSERT INTO ndv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ow meel ɗon yee tah ɗon na pëkísú rí rëe, lah wëní rí biti Yíkëe daa sohlaꞌ ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Taalibe ya koluu daaha suute. Lahuu wa ra, wa ɗeefu iña ti ɗee wonaꞌ wa Yéesú rë nen. ");
INSERT INTO ndv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wa homu pëkísí cúmbúrë, yíkëe yë wonu wa tih⁠ ⁠: «⁠ ⁠Yi tah ɗon na pëkísú cúmbúrë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wa wonu tih⁠ ⁠: «⁠ ⁠Yíkëe daa sohlaꞌ ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wa anutee kom Yéesú cúmbúrë, larute sabidoorri wa sun, habruute Yéesú yaagohte. ");
INSERT INTO ndv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ɗi na saañ, ɓëewë ɓeyute sabidoorri wa larute waala. ");
INSERT INTO ndv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Leɓaꞌ ri Yerusalem, na cép daŋi Ëlíiffë rë, keeññi mboolo mi taalibe ya ɓéeɓ sosse níi sos, wa ɓéyrúté unni wa sun na njooɓu Koope di kimtaanna olu wa ra ɓéeɓ ");
INSERT INTO ndv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","na wonu tih⁠ ⁠: «⁠ ⁠Koo-Yíkëe barkela buura ɗi wol ri ra⁠ ⁠! Jaamma laha sun, Koo laha ndam di sunaa-sun⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Lahte fariseŋŋi húmú ɓëewë në, na wonu Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, wone taalibe yu héddëh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mee ron won ɗa biti wa héddëh rëe, laꞌ ya ay waa tah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ɓaataꞌ Yéesú leɓoh Yerusalem níi rí otte ri ra, ɗi na looy af yee nay kate gina a ɓëewë filiɓ ra, ");
INSERT INTO ndv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","na won tih⁠ ⁠: «⁠ ⁠Ɗon fi ɓëy Yerusalem, ɗon yúh yee nay ron one jaamma bisee woteh bee ra koon⁠ ⁠! Ndaa mas, ɗon míníh ríi ot. ");
INSERT INTO ndv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ay lah jamanii yéŋké biti kaaꞌoh yon ay ron geel, hac jul míirë, ƴégítëh rí, an ɗon yejoh haaꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wa ay hap ɓëewë ɓéeɓ húl, ɗakaƴaꞌ gina níi laꞌ ii tíkëh sun laꞌ. Ƴaa ɓéeɓ biti ɗon yúhsúuy wahtaa ac Koope sëmlëꞌën rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lahaꞌ Yéesú gina níi ɗi haalte baylii Faam fi gaani Koope ra, ɗi yampe na lík yaayoh ya homu na ra, ");
INSERT INTO ndv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","na won wa tih⁠ ⁠: «⁠ ⁠Koo wonay Téerëe bitih⁠ ⁠: “Faam soꞌ ac faam ɗagaa” a⁠ ⁠? Ndaa ɗon yíssúté rí “faam lohoh”⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yéesú homaꞌ Faam fi gaana faraah yëeddée. Kélfë yí seeƴoh ya, yëeddëh yí kootii Mëyíis a ɓaha ya gina na saamu hawi húl, ");
INSERT INTO ndv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ndaa wa húmú yíih ɗee nay wa rii pagee ra, af biti ɓëy gina ɓéeɓ húmú síkírúu rí nuffi wa. ");
INSERT INTO ndv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lahte bis, ɗeef Yéesú na yëeddëꞌ filiɓ Faam fi gaani Koope, na waare Uni Neba, kélfë yí seeƴoh ya, yëeddëh yí kootii Mëyíis a ɓaha ya ɗeefute ri daaha, ");
INSERT INTO ndv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wonu ri tih⁠ ⁠: «⁠ ⁠Won fun sañ-saña na pagaꞌ fu iña na paŋ fu ra. Daa nah ro paŋi wa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Soꞌ ɓal may ron meel yin yínë. Wëní sëꞌ⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","bëtsë në húmú bëtís Saŋ ɓëewë rë, Koope daa húmú nah ri mbée ɓëewë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tígí daaha, wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Yen won biti Koope daa nah ri raa, ɗi ay yen meel yee tah níi yen gémúy iña won Saŋ ɗa. ");
INSERT INTO ndv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te yen won biti ɓëewë daa nahu ri raa, ɓëewë ay yen tap laꞌ níi yen húl, ndée wa ɓéeɓ gémúté biti Saŋ yonente.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wa wonu Yéesú tígí daaha tih⁠ ⁠: «⁠ ⁠Fun yíih ɓëeꞌ nah ri bëtís rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ɗi nampee waa won tih⁠ ⁠: «⁠ ⁠Kon soꞌ ɓal, mii ron won ɓëeꞌ yeɗ soꞌ sañ-saña na pagaꞌ mi wa ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Filoon fi baaha, Yéesú ñeyaꞌte ɓëewë anil na léeh wë won tih⁠ ⁠: «⁠ ⁠Lahaꞌ ɓëyí húmú yíp meey reseñ, yeraꞌte ri ndalu, antee saañ ɓaaɓi ɗi ay naa maañ. ");
INSERT INTO ndv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nonaꞌ reseña ra, ɗi wolte súrgë línëh yë në, nda wa yeɗ ɗi wodi. Ndaa lahaꞌ ri ra, línëh yë habute ri, laɓute ri laɓɓi misikke, anutee rii yeris ɗi nimilaꞌte yaꞌ holoŋ. ");
INSERT INTO ndv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yíkíi meeya wolaatte súrgë kay. Lahaꞌ ri ra, wa laɓute ri laɓɓi misikke, solute ri solli misikke, anutee rii yeris nimilaꞌte yaꞌ holoŋ. ");
INSERT INTO ndv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɗi wolaatte súrgë kay. Lahaꞌ ɗi fi baa ra ɓal, wa gaañute ri gaaññi misikke anutee rii ɗúhíɗ meeya. ");
INSERT INTO ndv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«⁠ ⁠Yíkíi meeya won tígí daaha tih⁠ ⁠: “May page yih⁠ ⁠? Mi ot na⁠ ⁠! May wole koy kee ke soꞌ fahaꞌ mi níi fahaꞌ ra⁠ ⁠; mín hen wa yeɗ ɗi cér.” ");
INSERT INTO ndv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ndaa séenúu línëh yë koy ka, wa wonu hanndal ki wa tih⁠ ⁠: “Lamoha abee kan⁠ ⁠! Ëyí yen hap ɗi húl, meeya hen bi yen.” ");
INSERT INTO ndv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lahaꞌ ri ra, wa yípútée ríi ham, ɗúhrúté rí meeya, hawute ri húl.⁠ ⁠» Tígí daaha, Yéesú won ɓëewë tih⁠ ⁠: «⁠ ⁠Yíkíi meeya ay page línëh yí ƴaa yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ɗi ay aye ayo, hap wa ɓéeɓ húl, anti saam i línëh kay, yeɗ wa meeya.⁠ ⁠» Keluu ɓëewë unni ƴaa ra, wa wonu tih⁠ ⁠: «⁠ ⁠Yii baa ɗamaayti lah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yéesú yeelte wa níi antee won tih⁠ ⁠: «⁠ ⁠Bíníyúté Téerëe bitih⁠ ⁠: “Laꞌa habuu taɓahoh ya biti lahay njiriñ ra daa míllëꞌ ham lasa.” «⁠ ⁠Unee ke Téerëe baa fahaꞌ won yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɓëyí baɓoh laꞌi baa ɓéeɓ ay korsaꞌ, te laꞌa keen sun ow ay rii ɗakaƴaꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yúhúu yëeddëh yí kootii Mëyíis a kélfë yí seeƴoh ya biti Yéesú yuliɗ anili baa sun fi wa ra, wa na saamu ɗee nay wa rii habee wahtii baaha ra, ndaa wa kaañuy ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tígí daaha, wa koluute olsohi Yéesú, yejute i ow tala. Ɓëewë në ɓënɓënɗúu, ayuute ti ɓëewí júɓúté nen, na fahuu fíirí Yéesú di won. Wa húmú saamu yii ay mín tah gëernëer keen sun fi Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun yúhúté biti fu wonaꞌ kaah⁠ ⁠: fu yëeddëꞌ yee nahaꞌ Koope ra kah-kah. Fu na yeeleeh ow jëmmíi. ");
INSERT INTO ndv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kon won fun nda kootii yen onaꞌte biti Sesaar yeru túm mbée onaay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ndaa bi yúh Yéesú yee nuffi wa, ɗi won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«⁠ ⁠Téeɓí sëꞌ hélíis hanjar noo.⁠ ⁠» Yeruu ri hanjara, ɗi meelte wa won tih⁠ ⁠: «⁠ ⁠Netli wa a tii wa daa na⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Ƴi Sesaar.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yéesú won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Kon yérí Sesaar yee lahaꞌ ri ra, ɗon yeɗ Koope yee lahaꞌ ri ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wa míníh ríi ham di iña won ɗi fíi ɓëewë rë. Yee won ɗi ra kay éemíl wë éemílë níi tahte wa lahluy yii wonun wa. ");
INSERT INTO ndv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Filoon fi baaha, i saduseŋ, wa fa wonu biti koloh ɓúudé lahay ra, ayute Yéesú në, ");
INSERT INTO ndv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, Mëyíis húmú túuƴcé yen bitih, ɓëyí húl hel ɓeleɓ te ɗeef ɓani ɓelaa liiluyti lah koy, ñéedë waɗtee lam ɓelaa, saamiɗ ɓahii tal. ");
INSERT INTO ndv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Te kíilë, húmú lahte koy-yaay paana⁠ ⁠: bee ɓaha waa na ra kooɗte, ɓani ɓelaa liiluyti lah koy, ɗi húlté. ");
INSERT INTO ndv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bee ñee na ra kooɗte ɓelaa, yee kat ɓahaa ra katte ri. ");
INSERT INTO ndv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɓëyí éeyë fë ñeyilte kotta húlté. Na hen ɗaaha níi wa fi paana ya ɓéeɓ ñeyute kooda, húlúté te ow lahay na koy. ");
INSERT INTO ndv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Filoon fe, ɗi fi ɓelaa tahte ɓal húlté. ");
INSERT INTO ndv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kon leegi, yiin nay kolee ɓëewë ɓúudé rë, daa nay lahee ɓelaa waa na te wa ɓéeɓ koorute ri⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɓëewë feey fi bee na koorantuu⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ndaa ɓëewë yéŋké biti Koope otte biti wa warutee koloh ɓúudé, wa haal pesa na ac ra, bín fë rëe, wa ii koorantaꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wa ii míníl húl, wa ay madee a malaaka ya. Wa ay hene koyyi Koope, bi nay ri waa këllé ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Biti ɓëewë húlú rë ay këllú ɓúudé, Mëyíis teeɓaꞌte na yii lante filiɓ Téerëe na won ɗi Koo-Yíkëe filiɓ dúufë na njaaroh ra biti daa ri “Koope fi Abraham, Koope fi Isaak, Koope fi Yakop” ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Kon Koope, ɗi Koope fi ɓëewë húlú rë neh, ɗi Koope fi ɓëewë na pesu ra⁠ ⁠; ndée di ɗii na, wa fi éeyë yí ƴaa ɓéeɓ lísúu pes.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","I ow di yëeddëh yí kootii Mëyíis ɓeyute una tígí daaha wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, wonu ñeete waal.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ow kaañlay rii meelil yin kay. ");
INSERT INTO ndv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yéesú ɓaatte won ɓëewë tih⁠ ⁠: «⁠ ⁠Ow mínëꞌ won biti Buura Koo fal ri ra sédí Dawit ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ɗi fi Dawit won filiɓ téerëe lahaꞌ ƴeekaa yi kañaa ya ra tih⁠ ⁠: “Koo-Yíkëe won Yíkíi sëꞌ tih⁠ ⁠: Tooke hëbís sëꞌ, yaꞌi ñamaa fi soꞌ deh, ");
INSERT INTO ndv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","níi bín nëy míi yíssée kaaꞌoh yu hen tíkëe yí kottu ra.” ");
INSERT INTO ndv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ɗi fi Dawit dëekëꞌ rí Yíkëe rëe, kon Buura Koo fal ri ra mínëꞌ hen sédí ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bi na síkírúu rí ɓëewë ɓéeɓ, Yéesú won taalibe yi tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«⁠ ⁠Lah mëytíi yëeddëh yí kootii Mëyíis, wa fa tílëesúu a búuɓ gaan, te wa fahuu biti wa woduun a yaꞌ ana këemmë rë. Wa tookuu ñaanna këllëh di ílíƴƴë na ɗaguu yëwúɗɗë Koope ra, te daa wa na ɗéɓúu ñam biti ndaje lah. ");
INSERT INTO ndv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Daa wa lukuu maañ ɗaŋ ndah teeɓaꞌi affi wa, te añcaŋ, daa wa na ɓeyu alalli ɓeleɓɓa ƴaalli wa húlú rë. Daani wa nay lukee misik.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Filoon fi baaha, Yéesú ɓéyíɗté afi, otte i yíkëe alal na ɓeku hélíis ifi saraha filiɓ Faam fi gaani Koope. ");
INSERT INTO ndv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ɗi otte ɓelii ƴaala húlté ɓal, bi ñakke níi ñak, ɓekke na hanjar ƴutuuɗ ana. ");
INSERT INTO ndv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ɗi won tígí daaha tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee bitih⁠ ⁠: saraha yeraꞌ ñëkídí bee lahay ƴaal bee ra, luk ƴi ɓëewí kayya ɓéeɓ lah solo. ");
INSERT INTO ndv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ɓëewí kayya ɓéeɓ yeruu ƴee lukus alal mi wa ra, ndaa di filiɓ ñagi, ɓelaa yeraꞌ iña lahaꞌ ri ra ɓéeɓ, ƴee waɗ ɗii pesaa koon ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lahte ɓëewí na húmú wonu ɗee ɗamaꞌ Faam fi gaani Koope ra a laꞌ yi wunna taɓahuu ri ra, a iñi wunlaa ya hom na, ƴee jébëlú ɓëewë Koope ra. Yéesú won wa tígí daaha tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«⁠ ⁠Bis ay lah, iña olu ɗon ƴee ra ɓéeɓ ay bëp níi laꞌ ii tíkëh sun laꞌ kay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ɓëewë meelute ri wonu tih⁠ ⁠: «⁠ ⁠Ɓahaa, yii baaha ay lahe kirih⁠ ⁠? Yi nay teeɓee biti yii baa ee saañ lahe ra⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mëytíi⁠ ⁠! Ow ɓanay ron nofaꞌ. Ow caak ay ayaꞌ tii soꞌ won biti daa wa Kiristaa, mbée wahtaa lahte. Ndaa ngënë síkíríi wë. ");
INSERT INTO ndv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ɗon keloh ban haaꞌ gin a gin a ban tíkëntëꞌ af raa, ngënë tíití⁠ ⁠: iñƴaa waɗti laha laho paaƴ, ndaa ɗeefa túkkíi ëldúnë laheh doom.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ɗi ɓaatte won tih⁠ ⁠: «⁠ ⁠Gin ay yejoh gin haaꞌ, nguur haaꞌ a nguur⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","feey fa ay hégíƴëh hégíƴëh yí misikke, yaaɓ a jérrí na karaꞌ ay haal i ílíƴ feey fa⁠ ⁠; kimtaanni tíitɗëꞌté ɓal ay olu sun-Koo. ");
INSERT INTO ndv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ndaa balaa ƴaaha ɓéeɓ rëe, af soꞌ ay tah ɗon habu ɗon moklu. Ɗon ay kúrú, ɗon tëekɗú këem filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra, wa aattiyaꞌ ron, ɗon ɓeku kasu. Ɗon ay kúrú fíi i buur a fíi i gëernëer. ");
INSERT INTO ndv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Iñƴaa ay tah ɗon seede yee yúhú ɗon soo na ra. ");
INSERT INTO ndv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kon yúhí biti ɗon lahuy yii sídúun ɗon di yee nay ron layee ra, ");
INSERT INTO ndv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ndée bín fë rëe, daa mi nay ron teeɓe yee nay ron wone ra, a nufa nay ron rii wonee ra, níi ow yínë sah di kaaꞌoh yon ii naa mín yin te wa ii ron mín lof. ");
INSERT INTO ndv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Baappon sah a yaayyon, koy-yaayyon, mboko yon a kooƴƴon ay ron yaay⁠ ⁠; i ow ɗon na ay hawu húl. ");
INSERT INTO ndv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Af soꞌ ay tah ɓëewë ɓéeɓ kaaꞌ ɗon. ");
INSERT INTO ndv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ndaa karal fen yínë sah ii kanoh affon. ");
INSERT INTO ndv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lah hëbí híin, ɗon ay múcée ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tíl níi ɗon ot i soldaar gíiw Yerusalem raa, lah yúhí biti poyi gina leɓohte. ");
INSERT INTO ndv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","«⁠ ⁠Tígí daaha, ɓëewë nay home Yúdée rë heguun daŋŋin, ɓëewë nay home Yerusalem ra wuloh, te ɓëewë nay home luufin ra ɓanti haal gina. ");
INSERT INTO ndv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Waalli ƴaaha, Koope ay keen sun fi ɓëewë, ti ɗee bíníyúu iña filiɓ Téerëe rë ɓéeɓ nen. ");
INSERT INTO ndv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mas ɓeleɓɓa nay poke loo bín fë rë a ƴee nay ɓëpíré rë⁠ ⁠! Ndée ɓëy gina ɓéeɓ ay mok níi mok, ndah Koope ay teeɓaꞌ neeɓi. ");
INSERT INTO ndv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wa ay hawu húl a jépíl, wa habu ñaam hasluu filiɓ ginni kayya ɓéeɓ, te ɓëewë yëwúɗ neh ra ay togisaꞌ Yerusalem níi wahtii wa lah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yéesú ɓaatilte won tih⁠ ⁠: «⁠ ⁠Ay lah iñi ay tíinndúu naꞌa, céyín fë a hulla na. Húní mboowaanna kísí fë ay tah affi ɓëewë feey fa ɓéeɓ kúnëh pak⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","doole ya sun ɓéeɓ ay bëlkísëh. Ay lah ɓëewí tíit níi maanndee húl ndah níbí yee nay lahe feey fa ra. ");
INSERT INTO ndv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tígí daaha, ɓëewë ay ot soꞌ mi Koy-ɓëeꞌ mi aye filiɓ nér, mi ñéerëꞌ a doole a ndam gaan. ");
INSERT INTO ndv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ɗon ot iñƴaaha dale lah rek, lah këlíi ɗon seh, ɗon yúh biti leŋ ron múc.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Filoon fi baaha, Yéesú ñeyaatte wa léeh won tih⁠ ⁠: «⁠ ⁠Ëlsíi tal kilik⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ɗon ot ɗi capuse rek, ɗon yúh biti lee ri lah koy. ");
INSERT INTO ndv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ti ɗaaha nen, ɗon ot iñƴaaha lahe raa, lah yúhí biti Nguur ki Koope leɓohte. ");
INSERT INTO ndv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mee ron won kaaf ka ra ee biti ɓëy jamanii bee ii múk te iñƴaaha ɓéeɓ laheh. ");
INSERT INTO ndv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Sun a feey ay múk, ndaa unni soꞌ ii mëssí múk.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Cëgí affon⁠ ⁠! Keeññon ɓanay dérkís ñammi neɓɓa, hani misiga a iñi feey fi beh, toñeh bisi baa ay ron beettiye. ");
INSERT INTO ndv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Di na habaꞌ mbëp ƴak nen, yii baa ay beettiyee ɓëewë feey fa ɓéeɓ ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cëgí affon, ɗon ɗage Koope faraah, nda ɗon mín lah doolii múcúun ɗon iña nay lahe ƴaa ra ɓéeɓ, te ɗon mín caŋ fíi soꞌ mi Koy-ɓëeꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yéesú endaꞌ yëeddëꞌ filiɓ Faam fi gaani Koope⁠ ⁠; ndaa fíníin lah raa, ɗi sayaꞌ sun fi daŋi Ëlíiffë ɗi neeꞌ na. ");
INSERT INTO ndv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te Koo yíil ɓaaɓ cúɓ rëe, ɓëewë ɓéeɓ ayuu Faam fi gaani Koope síkírée rí. ");
INSERT INTO ndv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Feedi mbúurú njeñe ya na wonuu Paak ra ee saañ lahe ra. ");
INSERT INTO ndv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis na saamu nufa nay waa hawee Yéesú húl rë, ndaa wa kaañuy ɓëy gina. ");
INSERT INTO ndv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tígí daaha, Seytaane haalte Yudaas fa na wonuu Iskariyot te non taalibe yi sabboo a ana ya ra. ");
INSERT INTO ndv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ɗaaha, Yudaas yíppée pay kélfë yí seeƴoh ya na a kélfë yí wohoh yi Faam fi gaani Koope, wa peenute ɗee nay ri waa yaayee Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Keeññi wa sosse níi sos, wa gapute ri hélíis. ");
INSERT INTO ndv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudaas tahte yee wonu wa ra, na anti saam wahtaa nay rii ɗamaalee Yéesú níi ri yaay wa ri, te ow yégéh rë. ");
INSERT INTO ndv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Filiɓ feedi mbúurú njeñe ya, bisa na hawuu har fi Paaga ra lahte. ");
INSERT INTO ndv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yéesú wolte Peer a Saŋ won wa tih⁠ ⁠: «⁠ ⁠Tílí ɗon waaƴe reeri Paaga.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fu fahaꞌ biti fun waaƴuun ɗi tígí dih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Síkíríi⁠ ⁠! Ɗon haale gina raa, ɗon ay teeꞌaꞌ a ow ƴaal kúɗ pen muluɓ. Lah ñéyí tala níi faam fa nay rii haale ra. ");
INSERT INTO ndv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ɗon lah na raa, wëní yíkíi faam fa tih⁠ ⁠: “Yëeddëhë daa nah fun meel ro lasa nay ñamee ɓani taalibe yi reeri Paaga ra.” ");
INSERT INTO ndv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hen ɗaaha raa, ɗi ay ron teeɓ lasi gaani paaꞌ sun, bi yugusute níi wocce⁠ ⁠: yii nay yen sohlee ɓéeɓ ín në. Ɗon ay waaƴee reeri Paaga daaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Peer a Saŋ suute, wa ɗeefute iña ɓéeɓ ti ɗee húmú wonaꞌ wa Yéesú rë nen. Ɗaaha, wa waaƴute reeri Paaga. ");
INSERT INTO ndv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lahaꞌ wahtaa ra, Yéesú a apootarri goorute na reeru. ");
INSERT INTO ndv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ɗi won wa tih⁠ ⁠: «⁠ ⁠A ɗee fahaꞌ mi biti yen bok reeri Paagi bee ra, balaa wahtaa nay mii mokluu ra lah⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mee ron won ɗa ee bitih⁠ ⁠: mii ñamil reeri Paaga níi iti fi teeɓuu Nguur ki Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ɗi ɓeɓpe kaas béeñ tígí daaha, símpé Koope won tih⁠ ⁠: «⁠ ⁠Ɓéyí béeñí ƴeh, ɗon woraꞌ wa hanndal kon⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","te mee ron won ra ee⁠ ⁠: dalaꞌte woteh, mii hanil béeñ níi bín nay ayee Nguur ki Koope ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Filoon fi baaha, ɗi ɓeɓpe mbúurú, símpé Koope, lecsaꞌte ri, yeɗte taalibe yi won wa tih⁠ ⁠: «⁠ ⁠Mbúuríi bee faan soꞌ, af ron tah mi yeraꞌ ri. Lah pëgí yii beh, nérsëhí sëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Reeruu wa níi wocce ra, ɗi yeɗte wa kaasi béeñë ɓal, won tih⁠ ⁠: «⁠ ⁠Kaasi béeñí bee daa yii hasa pokalsaꞌ Koope a ɓëewë ñeyaꞌte ri ñif mi soꞌ ra. Wa ay keen ndah ɗon. ");
INSERT INTO ndv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yúhí biti ɓëeꞌ nay soo yaaye ra, funi daa boku loon ee. ");
INSERT INTO ndv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kaah biti soꞌ mi Koy-ɓëeꞌ mi waɗtee húl ti di fahaꞌ ri Koope ra nen⁠ ⁠; ndaa mas ɓëeꞌ nay soo yaaye ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tígí daaha, taalibe ya na meelantuu ɓëeꞌ nay page yii baa filiɓ fi wa ra. ");
INSERT INTO ndv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Filoon fi baaha, taalibe ya yefuute taasantaꞌi misikke hanndal ki wa, fahuu yúh ɓëeꞌ waɗti habuun biti daa ri lukki gaan waa na ra. ");
INSERT INTO ndv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Buurri ginna daa na nootu ɓëewí kayya, kélfë yë saame tii sun fi ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ndaa ɗon waruy henaꞌ ɗaaha. Ɓëeꞌ lukki gaan ɗon na ra kay, waɗti habaa afi ɓëeꞌ lukki ƴin ɗa⁠ ⁠; ɓëeꞌ në túuƴëꞌ rë waɗti habaa afi súrgíi ɓëewë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Daa lukki gaan hanndal ki ɓëeꞌ took na ñam ra a súrgëe tíkíɗ ɗí loona ra⁠ ⁠? Ɗi bee na ñam ra neh a⁠ ⁠? Añcaŋ, mi man súrgë ɗon na nen⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ɗon fi ƴeh, ɗon mësúy sëe hel na moklu soꞌ ɓëewë rë. ");
INSERT INTO ndv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Di yeraꞌ soꞌ Baasoꞌ Nguur ka, mi yeraꞌ ron ri ɗaaha ɓal⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","yen ay bok ñam a han Nguur ki soꞌ, te ɗon ay took ñaani Nguur ka, ɗon ílíf talli sabboo a ana yi Israyel.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Filoon fi baaha, Yéesú won Peer tih⁠ ⁠: «⁠ ⁠Simoŋ, síkírëh sëꞌ⁠ ⁠! Seytaane ɗaŋke nda ri mín rën hégíƴ ti di na níikëꞌ ɓeleɓ nen. ");
INSERT INTO ndv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ndaa mi ɗagiɗte ro nda fu ɓan soo súugëh. Te fu nimil soo na raa, lah one koy-yaayyu yaꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peer won ɗi tih⁠ ⁠: «⁠ ⁠Yíkëe, tígë nay fuu ɓekuu kasu ra, may naa ɓeku⁠ ⁠; fu hawun húl, may naa hawu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Mee roo won ɗa ee Peer⁠ ⁠: fiisiin ki paan, fay taasaꞌ biti fu yúh sëꞌ níi hen waal éeyë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yéesú antee waa won ɓéeɓ tih⁠ ⁠: «⁠ ⁠Wolaꞌ mi ron, ɗon suute, ɗon kúrúy hélíis, ɗon kúrúy nafa a ñafaɗ ra, ɗon ñakute yin a⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun ñakuy yin.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Iña lofisohte⁠ ⁠! Dalaꞌte woteh, ɓëyí lah hélíis kúrë, ɓëyí lah nafa kúrë⁠ ⁠; te ɓëyí lahay ganaay waɗtee yaay sabidoori lom yínë. ");
INSERT INTO ndv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yúhí biti Téerëe won sun fi soꞌ tih⁠ ⁠: “Ɗi kídëelúuté ɓëewí ɓossa na.” Mee ron won ɗa ee biti yii baa waɗti laha laho, te ri lahte níi wocce.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Taalibe ya wonu tih⁠ ⁠: «⁠ ⁠Yíkëe, jépíl ana aƴee ee⁠ ⁠!⁠ ⁠» Yéesú won wa tih⁠ ⁠: «⁠ ⁠Wona ɗúmpé⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yéesú antee koloh saañce daŋi Ëlíiffë ti merees nen, taalibe yi ñeyute tali. ");
INSERT INTO ndv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lahuu wa dín fë rë, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗëgí Koope toñeh ɗon ay keene fíirí Seytaane⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ɗi helte wa daaha hécëhté ƴutuuɗ, ƴekke na ɗaŋ Koope ");
INSERT INTO ndv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","won tih⁠ ⁠: «⁠ ⁠Baap, hém neɓaꞌ ro, éccíré gulii coono fi bee wuloh soꞌ⁠ ⁠! Ndaa di mín ɗíi man ɓéeɓ, yee nay lahe ra ɓanan hen yee fahaꞌ mi ra, ndaa bee fahaꞌ fu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tígí daaha, malaaka di malaaka yi Koope céppé hílíbí. ");
INSERT INTO ndv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Keeña ɗúmpé ces, ɗi na ɓaatti ɗaŋ. Ɗi opaꞌ opoo níi opaꞌa man ñif nen, na síit feey. ");
INSERT INTO ndv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wocaꞌ ri ɗaŋa ra, ɗi kolohte, nimilte taalibe yi na. Ɗi ɗeef wa súfúñú súfúñë níi wa na neeꞌu, ");
INSERT INTO ndv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon neeꞌu yih⁠ ⁠? Këlíi ɗon ɗaŋ toñeh ɗon ay keene fíirí Seytaane⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yéesú hom wona, lahte dúukëlí ɓëewí ayute, ñéerúuté a Yudaas fa non taalibe yi sabboo a ana ya ra. Yudaas leɓohte Yéesú, na fahaꞌ fëení. ");
INSERT INTO ndv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yudaas, fu ƴahti ac yaayi soꞌ mi Koy-ɓëeꞌ rëe, fay soo fëené fëenë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ɓëewë ñéerúu a Yéesú rë, oluu wa yee na saañ lahe ra, wonu ri tih⁠ ⁠: «⁠ ⁠Yíkëe, fun ɓeɓ jépíllí fun, fun yejoh wa haaꞌ a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tígí daaha, ow yínë waa na paaŋke súrgíi seeƴohi gaana jépíl, lecce nufi ñamaa fa. ");
INSERT INTO ndv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Yéɗɗí⁠ ⁠! Topaa baaha⁠ ⁠!⁠ ⁠» Ɗi leɓpe nuf ɓëeꞌ, nufa wahte. ");
INSERT INTO ndv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ɗi na anti won a kélfë yí seeƴoh ya, kélfë yí wohoh yi Faam fi gaani Koope, a ɓaha ya gina ayu hami ra tih⁠ ⁠: «⁠ ⁠Ɗon ayuu yi ɗeeha a jépíl a i duuɗ hami soꞌ man mi banndi nen⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mi húmú homaꞌ ɗon na faraah filiɓ Faam fi gaani Koope, te ɗon kaañuy soo ham. Ndaa wahtoon daa lah, elga onuu Seytaane doole sun fi soꞌ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wa habute Yéesú, kúrúté rí faam seeƴohi gaana. Peer húmú filoonaa filoon, ñeete talli wa. ");
INSERT INTO ndv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Lahte ɓëewí këɗɗúté kíi filiɓ faam fa, tookute na yoonnduu. Peer acce, tookke waa na. ");
INSERT INTO ndv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Lahte ɓelii légéyëꞌ faam fa otte Peer niiñi kíi kë, ƴíiɗté rí níi won tih⁠ ⁠: «⁠ ⁠Ɓëyí bee ɓal non ɓëewí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ndaa Peer taasaꞌte won tih⁠ ⁠: «⁠ ⁠Mi yéeh ɓëeꞌ na wonaꞌ fu ra yaa ow⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tíkëh ƴutuuɗ, ow kay otte ri, won tih⁠ ⁠: «⁠ ⁠Ɗo ɓal fu non ɓëewí.⁠ ⁠» Peer won ɗi tih⁠ ⁠: «⁠ ⁠Mi noneh na déꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hente kiis, ow kay ayilte, digiɗte uni won tih⁠ ⁠: «⁠ ⁠Lahte íl ɓal⁠ ⁠! Ɓëyí bee non ɓëewí⁠ ⁠; ndah ɗi ɓëy Galile.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ndaa Peer won ɗi tih⁠ ⁠: «⁠ ⁠Mi yéeh yee na won fu ra ɗo⁠ ⁠!⁠ ⁠» Ɗi hom wona, na mín ríi lúsíɗ ɗë paan fiisohte. ");
INSERT INTO ndv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yíkëe yíssëhté Peer na, yeelte ri. Tígí daaha, Peer nérsëhté yee húmú won ɗi Yíkëe rë biti fiisiin ki paan, ɗi ay taasaꞌ biti ɗi yúh rí níi hen waal éeyë. ");
INSERT INTO ndv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ɗi antee ɗúh ëssín na looy looyi misikke. ");
INSERT INTO ndv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Ɓëewë në húmú wohu Yéesú rë pokute íllë, na laɓisuu ri, na ñaawlu ri, meelute ri wonu tih⁠ ⁠: «⁠ ⁠Fu yonente saa ɓal⁠ ⁠? Wone ɓëeꞌ laɓ ɗo ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wa wonute ri i won ɓos kay caak. ");
INSERT INTO ndv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yíilëꞌ Koo ra, ɓaha yi yëwúɗɗë, kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis teeꞌuute, tëekrúté Yéesú këem, ");
INSERT INTO ndv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","meelute ri wonu tih⁠ ⁠: «⁠ ⁠Won fun nda daa fu Buura Koo fal ri ra raa.⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mi won ɗon biti daa mi, ɗon ii soo gém, ");
INSERT INTO ndv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","te mi meel ɗon, ɗon ii soo tiil. ");
INSERT INTO ndv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ndaa, kolaꞌte woteh, soꞌ mi Koy-ɓëeꞌ, may took hëbís Koope fa mín ɓéeɓ rë, mi hom yaꞌi ñamaa fi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wa ɓéeɓ wonu tih⁠ ⁠: «⁠ ⁠Kon fu Koy Koope a⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon wonute ri, daa mi⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wa wonu tígí daaha tih⁠ ⁠: «⁠ ⁠Yen ay pagilee seede yih⁠ ⁠? Ɗi ɗúhíɗté rí ɓúkí níi wocce⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ɓëewë ɓéeɓ koluute, kúrúté Yéesú Pilaat gëernëerë në, ");
INSERT INTO ndv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","na yabu ri iñƴee wonu tih⁠ ⁠: «⁠ ⁠Ɗi homaꞌ daaha ɓeke ɓëy gina nuf, kaddee wa yeraꞌ túm, te ri tík afi Buura Koo fal ri ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaat meelte Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Daa fu buuri yëwúɗɗë ë⁠ ⁠?⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu wonte ri, daa mi⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaat won kélfë yí seeƴoh ya a ɓëewí kayya húmú në rë ɓéeɓ tih⁠ ⁠: «⁠ ⁠Mi olay yii mín tah ow keen sun fi ɓëyí beh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ndaa ɓëewë ɓaatutee ɓéyíɗ unni wa sun na wonu tih⁠ ⁠: «⁠ ⁠Ɗi ñeyaꞌ yëeddëꞌ yí, yahe nuffi ɓëewë. Ɗi dalaꞌ Galile, ñeete Yúdée ɓéeɓ níi rí lahte dee woteh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kelaꞌ Pilaat unni ƴaa ra, ɗi meelaꞌte won tih⁠ ⁠: «⁠ ⁠Ɗi ɓëy Galile woo⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ɓëewë wonu ri tih⁠ ⁠: «⁠ ⁠Ɗi dék në kay⁠ ⁠!⁠ ⁠» Pilaat yúhté biti Erot daa ílíf Galile fi baaha, te ɗi fi Erot húmú Yerusalem waalli ƴaaha, ɗi yeeltee yeñ ɓëewë kúɗ Yéesú ɗii na. ");
INSERT INTO ndv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Olaꞌ Erot Yéesú rë, keeña sosse níi sos, ndah ri húmú kelohte ban fi, te ri maañcee fahaꞌ oli. Ɗi fahaꞌte rii ot page kimtaan. ");
INSERT INTO ndv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ɗi meelte ri yin caak, ndaa Yéesú tahay ɓúkí ɗii na. ");
INSERT INTO ndv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kélfë yí seeƴoh ya a yëeddëh yí kootii Mëyíis digirute unni wa na yabu Yéesú yin caak. ");
INSERT INTO ndv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erot a soldaarri ɓal na ñaawlu Yéesú, ɓekute ri búubí wunte na këekkëlíyú rí. Filoon fi baaha, Erot yejaatte ri Pilaat na. ");
INSERT INTO ndv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erot a Pilaat na húmú tëfrëntíih kíi, ndaa dalaꞌte yiin fin fa wa henute kooƴ. ");
INSERT INTO ndv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaat dëekrëhté kélfë yí seeƴoh ya, ɓaha ya a ɓëy gina, ");
INSERT INTO ndv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","won wa tih⁠ ⁠: «⁠ ⁠Ɗon wonu ti ɓëeꞌ komu ron soꞌ bee ra yahaꞌ nuffi ɓëy gina yahoo. Mi meelaꞌ ri fíiyën, ndaa mi olay yin di iña yabu ron ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erot ɓal ɗaaha, daa tah ɗi yeñ ri soo na. Ɓëyí bee pagay yii cal ɗi hawu húl. ");
INSERT INTO ndv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Cëe mi laɓiroh ri laraw, mi yeris ri.⁠ ⁠»  ");
INSERT INTO ndv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ndaa wa ɓéeɓ na ɗaañnjuu wonu tih⁠ ⁠: «⁠ ⁠Hawe ri húl, fu ɗúhríɗ fun Barabaas.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ɗi fi Barabaas húmú non ɓëewë na haaꞌuu njíittí gina ra, te ri húmú happe ow húl ɓal, daa tah ri téƴú kasu. ");
INSERT INTO ndv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bi fahaꞌ Pilaat yeɗɗi Yéesú, ɗi ɓeyaatte una, woni biti Yéesú pagay yin ɓos. ");
INSERT INTO ndv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ndaa ɓëewë ɓaatutee ɗaañnjoh na wonu tih⁠ ⁠: «⁠ ⁠Daaƴe ri kurwah ɓal⁠ ⁠! Daaƴe ri kurwah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaat ɓeyaatte una waali éeyë fë won wa tih⁠ ⁠: «⁠ ⁠A ri paŋ yii ɓosi bih⁠ ⁠? Mi ollay ri yii cal hawaa húl. Cëe mi laɓiroh ri laraw, mi yeris ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ndaa wa na ɓaatuu ɗaañnjoh na wonu tih⁠ ⁠: «⁠ ⁠Daaƴe ri kurwah ɓal⁠ ⁠! Daaƴe ri kurwah⁠ ⁠!⁠ ⁠» Ɗaañnjohi misiga kúrëelëhté Pilaat ");
INSERT INTO ndv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","níi ri tahte pagri wa yee fahuu wa ra. ");
INSERT INTO ndv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tígí daaha, Pilaat ɗúhíɗté Barabaas fa fahuu wa biti daa yeɗɗun ra, ɗi fa yahi nuffi ɓëewë a hap ow húl daa húmú tah ri téƴú rë, yeɗɗaꞌte wa Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na kúrú soldaarra Yéesú tígë nay rii hawuu húl rë, wa teeꞌuute a ɓëyí dék Siren, hínú Simoŋ, ɗeef ɗi kolaꞌ meey. Wa habute ri, enute ri kurwaha, ñéyrúté rí filoon Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ow caak ñeyute filoon Yéesú. Ɓeleɓ caak húmú filiɓ fi wa, na fogu ri na hawuu. ");
INSERT INTO ndv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yéesú yíssëhté waa na, won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ɓeleɓɓi ɓëy Yerusalem, ngënë lëeyí sëꞌ, lëeyí affon a koyyon⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Jamanu ay lah, ɓëewë won tih⁠ ⁠: “Lahute sos-keeñ, ɓeleɓɓa míníh pok loo ra, ƴee mësúy lah koy, ƴee mësúy kúu rë⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tígí daaha, ɓëewë ay nah daŋŋa keen sun fi wa, won dúŋŋë súuƴ wë. ");
INSERT INTO ndv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kilik hilsiɗ daa míntí henu ɗee raa, mas kilik súhíɗ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Soldaarra kúrëelúuté banndi ana ɓal, ƴi ay hawu húl a Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lahuu wa tígë në wonuu Këeŋ-af ra, wa daaƴute Yéesú kurwah. Wa daaƴaaluute banndi yi ana ya ɓal⁠ ⁠: ɓëyí yínëe paaꞌte Yéesú yaꞌ ñamaa, yínëe paaꞌte ri yaꞌ sugu. ");
INSERT INTO ndv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yéesú won tígí daaha tih⁠ ⁠: «⁠ ⁠Baap, baale wa, ndée wa yíih yee na pagu wa bee ra.⁠ ⁠» Soldaarra púlúfúté búuɓɓí Yéesú, woruute wa hanndal ki wa. ");
INSERT INTO ndv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ɓëewë cagute na olsuu. Kélfë yí yëwúɗɗë na ñaawlu Yéesú wonu tih⁠ ⁠: «⁠ ⁠Ɗi sëmlëey i ow kay woo⁠ ⁠? Ɗi sëmlëe afi ɓal hena biti daa ri Buura Koo fal ri ra kaah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldaarra na ñaawlu ri ɓal. Wa ɓeyute bineegar, leɓuute ri na fahuu hënndí, ");
INSERT INTO ndv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","wonu ri tih⁠ ⁠: «⁠ ⁠Hena biti daa fu buuri yëwúɗɗë rëe, sëmlée afu⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wa bíníyúté unni ƴee yeeddaꞌ ki afa sun⁠ ⁠: «⁠ ⁠Ɓëyí bee daa buuri yëwúɗɗë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Banndii yínëe hom sun fi kurwahi, na sol Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu won neh daa fu Buura Koo fal ri ra a⁠ ⁠? Sëmlée afu, fu sëmlëꞌ fun na ɓal⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ndaa banndii yínëe na won afa tih⁠ ⁠: «⁠ ⁠Ɗo fu kaañce Koope déꞌ⁠ ⁠! Ɗoni ɓëyí bee daa boku daan ee. ");
INSERT INTO ndv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bi yen waɗte⁠ ⁠: yen yínlú iña pagu yen ɗa kat⁠ ⁠! Ndaa ɗi fi bee pagay yin ɓos.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ɗi antee won tih⁠ ⁠: «⁠ ⁠Yéesú, lah hele nuf soo na biti fu took Nguur ku.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Mee roo won kaaf ka ra ee⁠ ⁠: woteh fee Koo beh, fay home soo na Aljana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Lahaꞌ naꞌ leelu af ra, gina ɓéeɓ ñúussé túɗ níi mitte wahtu éeyë. Rídíi ɓídí Faam fi gaani Koope ɗap tígí selaa níi sela ra, ɗaɗte dalaꞌte sun níi feey, ɓísëlsëꞌté ana. ");
INSERT INTO ndv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yéesú ɗaasse foŋ tígí daaha won tih⁠ ⁠: «⁠ ⁠Baap, mi tíkké coonaa fi soꞌ yaꞌu.⁠ ⁠» Wonaꞌ ri unni ƴaa níi wocce ra, ɗi yeɗɗohte lússé. ");
INSERT INTO ndv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Olaꞌ kélfíi soldaara yee lah ra, ɗi kañce Koope won tih⁠ ⁠: «⁠ ⁠Ɓëyí bee ɓëyí júɓpé kaah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Oluu ɓëewë maasuu ra yee lah ra, wa tíkúté yaꞌ yi wa affi wa na looyu na nimilu faam. ");
INSERT INTO ndv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kooƴƴi Yéesú ɓéeɓ cagu hanndal na olsuu yee lah ra. Ɓeleɓɓa húmú ñéerúu a Yéesú dalaꞌte Galile ra húmú filiɓ fi wa. ");
INSERT INTO ndv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Lahte ɓëyí dék Arimate di Yúdée, hínú Suseef, ɗi non ɓaha yi ɓëy këemí gaani yëwúɗɗë. Ɗi ɓëyí baahte te júɓpé, te ri na húmú sehaaloh ayi Nguur ki Koope. Húlë tíkú ɓaha ya Yéesú rë, ɗi ñéerëey në. ");
INSERT INTO ndv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɗi payte Pilaat na meelte ri ɓúudé fí Yéesú. ");
INSERT INTO ndv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tahraꞌ ri Pilaat ra, ɗi nuuliɗte ɓúudé fë kurwaha, líiwté rí perkal, kúɗté rí ɗappe ri kolom ki yotu loo laꞌ, bi yéŋké biti ɓúudé hëcɗúy në. ");
INSERT INTO ndv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wahtu ya tas balaa bisa na hílsúu yëwúɗɗë rë lah caaklilay. ");
INSERT INTO ndv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ɓeleɓɓa na húmú ñéerúu a Yéesú dalaꞌte Galile ra, ñeyute tal Suseef, wa olsuute nuŋa, olute ɗee fënɗúu ɓúudé fí Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wa nimilute faam, waaƴute i yin heeñlaa a laakkoloñ, yugusii ɓúudé fë. Lahaꞌ bisi hílsëe rë, wa hílsúuté ti di túuƴúu rí nen. ");
INSERT INTO ndv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dímëesë, ɓeleɓɓa koluute miir-miirin, kúrëelúuté iñi heeñlaa ya húmú waaƴu wa ra, suute tígë hacuu Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lahuu wa ra, wa olute biti laꞌa húmú kúnúu ɓúk luuya ra píníŋúté hatin. ");
INSERT INTO ndv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wa haalute, wa ɗeefuy na ɓúudé fí Yéesú-Yíkëe, ");
INSERT INTO ndv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","affi wa kúnëhté. Ow ana yi ɓekuu búuɓɓí na tak feeñiyuute wa tígí daaha. ");
INSERT INTO ndv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ɓeleɓɓa tíitúté, líhúté púkkí wë feey. Ɓëewë wonu wa tígí daaha tih⁠ ⁠: «⁠ ⁠Ɓëyí ee pes ɗa saamuu ɗí filiɓ ɓëewë húlú rë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yéesú íníh në, ɗi këllúté ɓúudé. Nérsíi yee húmú won ɗi ron homaꞌ ri Galile ra biti ");
INSERT INTO ndv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ɗi fi Koy-ɓëeꞌ waɗtee yaayu bakaaroh ya, ɗi daaƴu kurwah, waali éeyë fë filoon fi húlí ɗi koloh ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tígí daaha, wa nérsúuté unna húmú won Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɓeleɓɓa koluute luuya daaha suute, ɓíllúté iñƴaaha ɓéeɓ apootarri sabboo a yínë yë a ɓëewí kayya na húmú ñéerúu a Yéesú rë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɓeleɓɓi ƴaa húmú Mari fi ɓëy Makdalaa, Saan, Mari yaafi Saak a i ɓeleɓ kay. Ɓíllúu wë apootarra ra, ");
INSERT INTO ndv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","wa habuu biti ɓeleɓɓa yíih iña na wonu wa ra, tahte wa gémúy wë. ");
INSERT INTO ndv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Filiɓ fi baaha, Peer nampee múkë luuyin. Lahaꞌ ri yérëntëhté rë, ɗi ɗeef na boyya kut. Ɗi nimilte faam éempé níi éem di yee lah ra. ");
INSERT INTO ndv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yiin fi baaha, lahte taalibe ana yi na suu gina na wonuu Emayus ra, bi hécëhté a Yerusalem yii mitte tíl wahtu ana, ");
INSERT INTO ndv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","na gonlu sun fi iña lah ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wa homu gonla unni wa na ɓéyrëh sun, Yéesú daɓpe wa waala ñéerëꞌté a wa. ");
INSERT INTO ndv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wa olute ri, ndaa lahte yii úmpé wë níi wa yúhsúuy rí. ");
INSERT INTO ndv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗon gonlu yi waala⁠ ⁠?⁠ ⁠» Wa yípútée caŋ, kanammi wa súfúñcé níi súfúñ. ");
INSERT INTO ndv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ow di waa na hínú Kelewofaas won ɗi tih⁠ ⁠: «⁠ ⁠Ɗoni afu kut di Yerusalem daa yíih yee lah waalli ƴee ra maan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Baaha yi daaha⁠ ⁠?⁠ ⁠» Wa tahute wonu tih⁠ ⁠: «⁠ ⁠Fu kelaay yee kat Yéesú fí ɓëy Nasaret ra a⁠ ⁠? Ɗi húmú yonentii lahte sañ-sañ di pagaɗ a wonaɗ fíi Koope a fíi ɓëewë ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kélfë yí seeƴoh yi yen a njíittí yen kúrúté rí faam buur, ɗi aattiyuute húl, daaƴute kurwah. ");
INSERT INTO ndv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Fun lahute yaakaar biti koon daa ri nay sëmlée Israyel⁠ ⁠; ndaa seeꞌ⁠ ⁠! Di filiɓ fi baaha, iñƴaaha lahte hente waal éeyë woteh te ow olay yin. ");
INSERT INTO ndv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Añcaŋ, i ɓeleɓ di fun na éemílúté fun. Wa payu luuyin miir-miira oroh, ");
INSERT INTO ndv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wa oluy ɓúudé fí Yéesú, wa ayute ɓíllúté fun biti i malaaka feeñiyuute wa, wonute wa biti ɗi ee pes ɗa. ");
INSERT INTO ndv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Filoon fe, i ow di fun na payute, olute biti iña wonu ɓeleɓɓa ra ɓéeɓ lahte. Ɗi fi Yéesú nék, wa oluy ri⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yéesú won taalibe yi ana ya tígí daaha tih⁠ ⁠: «⁠ ⁠Lúh-nuffi ƴeh⁠ ⁠! Ɗon gémúy iña wonu yonente ya ra gémë doom a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Buura Koo fal ri ra waɗtee ñee coono fi bah, anti haal ndami.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ɗi na an waa poysiiɗ iña bíníyú sun fi ra ɓéeɓ, dalaꞌte kootii Mëyíis, ñeete téeré yë bíníyú yonente ya ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tílúu wë níi wa leɓuute gina na suu wa ra, Yéesú na ɓënɓënɗëh baret, ");
INSERT INTO ndv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ndaa wa caguute ri wonu tih⁠ ⁠: «⁠ ⁠Fu saañ dih⁠ ⁠? Tase fun na deh⁠ ⁠! Naꞌa yëellëhté te Koo ee saañ elke ra.⁠ ⁠» Tígí daaha ɗi ñéerëꞌté a wa, wa suute faam. ");
INSERT INTO ndv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wa tooku reer, Yéesú ɓeɓpe mbúurú símpé Koope, lecsaꞌte ri yeɗte wa. ");
INSERT INTO ndv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Affi wa kúnsëhté tígí daaha, wa yúhsúuté rí. Ndaa ri hente mes, wa olluy ri. ");
INSERT INTO ndv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Yii baa daa tah keeññi yen sos níi sos na won ɗi a yen waala, na poysiiɗ yen iña bíníyú Téerëe rë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wa yípútée koloh, nimilute Yerusalem. Lahuu wa ra, wa ɗeefute apootarri sabboo a yínë yë a ɓëewë në ñéerúu a wa ra teeꞌuute. ");
INSERT INTO ndv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Wa wonu taalibe yi ana ya tih⁠ ⁠: «⁠ ⁠Yíkëe këllúté ɓúudé kaah⁠ ⁠! Ɗi feeñiyohte Simoŋ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wa fi ana yi ƴaa ɓal ɓíllúté wë yee lah waala ra a ɗee yúhsúu wë rí na lecsaꞌ ri mbúurëe rë. ");
INSERT INTO ndv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Taalibe yi ana ya homu wona, Yéesú hente jalañ fíi wë ɓéeɓ, won wa tih⁠ ⁠: «⁠ ⁠Cëlíirí yaawe⁠ ⁠! Hëmíi jaamma⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ndaa wa tíitú tíitë níi affi wa kúnëhté⁠ ⁠; wa habuu biti koon yaa yébítëh. ");
INSERT INTO ndv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon tíitú yih⁠ ⁠? Haalaꞌ yi níi ɗon na lahu nuf ana⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ëlsíi yaꞌ yi soꞌ a kotti soꞌ⁠ ⁠: yaa soꞌ kay⁠ ⁠! Léɓí faan soꞌ ɗon olsoh⁠ ⁠! Yébítëh na lah boꞌ faan ti soꞌ nen a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wonaꞌ ri wa iñƴaa ra, ɗi teeɓpe wa yaꞌ yi a kotti. ");
INSERT INTO ndv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sosi keeña a éemë homuu wa ra, tahte wa míníh ríi gém doom. Tígí daaha, ɗi meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗon lahute yii ñamun dee a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wa yerute ri koy jén hútú. ");
INSERT INTO ndv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ɗi ɓeɓpe jénë ñampe ri fíi wë. ");
INSERT INTO ndv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ɗi antee waa won tih⁠ ⁠: «⁠ ⁠Húmú homaꞌ mi leeloon ra, mi wonte ron unni ƴeh⁠ ⁠: “Iña wonu sun fi soꞌ filiɓ kootii Mëyíis a téeré yí yonente ya a Téeríi kañaa ya ra ɓéeɓ waɗtee lah.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tígí daaha, Yéesú paŋke níi affi wa kúnsëhté, wa yúhúté yee won Téerëe rë. ");
INSERT INTO ndv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Bíníyúté biti soꞌ mi Buura Koo fal ri ra, mi waɗtee mok níi mok, te waali éeyë fë filoon fi húlí sëꞌ, may koloh ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Te dalaꞌte Yerusalem, heetta ëldúnë ɓéeɓ warutee waariyu di tii soꞌ, wa lof pesaɗ Koope baal wa bakaaɗɗi wa. ");
INSERT INTO ndv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɗon daa seede yi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Te soꞌ mi beh, may cépíɗ sun fon Ruuh-Peseŋ fa húmú gap ɗon Baasoꞌ ra. Ɗon nék, ngënë këlíi Yerusalem dee níi doolaa nay kolee sun ra cép ɗon na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Filoon fi baaha, Yéesú kúɗté wë waal Betani, ɓéyíɗté yaꞌ yi na barkel wa. ");
INSERT INTO ndv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɗi hom barkeli wa na takaꞌ a wa, Koo ɓéyíɗté rí kúɗté rí hëbísí sun. ");
INSERT INTO ndv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wa fi taalibe ya jaamiyuute ri anutee nimil Yerusalem, keeññi wa sosse níi sos. ");
INSERT INTO ndv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Faraah wa homuu filiɓ Faam fi gaani Koope wa símé rí.");
INSERT INTO ndv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dalaana ɗeef Una na⁠ ⁠; Una a Koope daa húmú, te ɗi fi Una Koope. ");
INSERT INTO ndv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Una a Koope daa húmú dalaana. ");
INSERT INTO ndv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Koope ñeyaꞌ ɗii na, sakke iña ɓéeɓ⁠ ⁠; lahay yii sakute te ñeyay ɗii na. ");
INSERT INTO ndv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pesa hom ɗii na, te pesi baa daa niiñi ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Niiña na ɗaɗ ñúusë, ñúusë habay ri. ");
INSERT INTO ndv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Koo húmú wolte ɓëyí hínú Saŋ. ");
INSERT INTO ndv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Saŋ acce seedii niiña, nda ɗi mín tah ɓëewë ɓéeɓ gém. ");
INSERT INTO ndv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ɗi a faanaŋ fi, ɗi niiña neh⁠ ⁠; seedii niiña daa tah ri koloh. ");
INSERT INTO ndv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Niiñi bah, daa niiñi kah-kah fa yéŋké biti ac ëldúnë niiñli ɓëewë ɓéeɓ rë. ");
INSERT INTO ndv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Una húmú ëldúnë. Koo ñeyaꞌ ɗii na sakke ëldúnë, añcaŋ, ɓëy ëldúnë yíih rí. ");
INSERT INTO ndv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɗi ac mboko yi na, ndaa mboko yi síkírúuy rí. ");
INSERT INTO ndv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Añcaŋ, kaaꞌeeh lahte ɓëewí síkírúuté rí, te gémúté rí. Te ɗi onte ɓëewí ƴaa ɓéeɓ níi wa henute koyyi Koope. ");
INSERT INTO ndv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wa henuuy koyyi Koope di pagaɗ ƴaal a ɓeleɓ. Ɗi yii ow daa fahaꞌ ri neh ɓal. Ëe-ëeꞌ⁠ ⁠! Koo daa paŋ níi wa henute koyyi. ");
INSERT INTO ndv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Una hente ow, ɗi dékké filiɓ fi yen, ñéerëꞌté a kaah koceec a malli mínéh ɗúm, yen na olu. Yen olute ndama liil ri Koo Boffi na ra, ndama yeɗ Boffa Koy ka lahaꞌ ri yínë kut ɗa. ");
INSERT INTO ndv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Saŋ fa seedeyiɗ ɗi ra, húmú ɓéyíɗté uni sun won tih⁠ ⁠: «⁠ ⁠Bee daa ɓëeꞌ na húmú wonaꞌ mi ron ra bitih⁠ ⁠: lahte ɓëyí ee ac filoon soꞌ ra, ɗi luk soo gaan fap, ndah balaa mi ac, ɗeef ɗi húmú në.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Malla kúɗ ɗí mínéh ɗúm ɗë, ɗi onte yen na ƴi caakke níi caak. ");
INSERT INTO ndv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Koope ñeyaꞌ Mëyíis në pokke Kootaa, ñéyíɗté mal a kaah Yéesú-Kiristaa na. ");
INSERT INTO ndv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ow ëllëy Koope. Koy ka yínë kut daa ëlíɗ ɗí, te ɗi fi baa Koope. Ɗi fa hom a Boffa ra daa teeɓaꞌ ɗee man ɗi fi Boffa ra. ");
INSERT INTO ndv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Saŋ seedeyaꞌ Yéesú ɗeh⁠ ⁠: kélfë yí yëwúɗɗë homu Yerusalem wolute seeƴoh ya a ɓëy tali Léwí Saŋ na nda meel ɗi ɗi fi baa daa ri wa. Meeluu wa ri ra, ɗi ɗapay dara, seedete won tih⁠ ⁠: «⁠ ⁠Soꞌ mi Buura Koo fal ri ra neh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wa meelaatute ri wonu tih⁠ ⁠: «⁠ ⁠Kon fu wah⁠ ⁠? Fu Éelí ë⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ, mi Éelí neh⁠ ⁠!⁠ ⁠» Wa wonaatu ri tih⁠ ⁠: «⁠ ⁠Daa fu yonentaa a⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗi soꞌ neh déꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wa míllúu rí won tih⁠ ⁠: «⁠ ⁠Kon daa fu wah⁠ ⁠? Won fun ɓëeꞌ hen fu ra, nda fun lah yii léhínún ɓëewë wolu fun ɗa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Saŋ lofaꞌte wa a unna húmú won yonente Isayii ra, won wa tih⁠ ⁠: «⁠ ⁠Daa mi una húmú ɗofoh luufa na won bitih⁠ ⁠: “Ɗëɗɗí Yíkëe waala níi júɓ.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","I fariseŋ húmú filiɓ ɓëewë wolu Saŋ na ra. ");
INSERT INTO ndv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Wa yabaatute na meelu ri wonu tih⁠ ⁠: «⁠ ⁠Fu won ti fu Buura Koo fal ri ra neh, fu Éelí neh te fu yonentaa waɗti ac ra neh. Kon yi tah fu na bëtís ɓëewë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Saŋ won wa tih⁠ ⁠: «⁠ ⁠Mi hom bëtsëꞌ ɓëewë a muluɓ⁠ ⁠; ndaa lahte ɓëyí ee filiɓ fi ɓëewë deh, te ɗon yíih rí. ");
INSERT INTO ndv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ɗi ee ac filoon soꞌ ra ndaa mi haaƴayti liil kotti.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yii baa lahaꞌ énfí laahi Yurdeŋ di Betani, tígë në bëtsëꞌ Saŋ ɓëewë rë. ");
INSERT INTO ndv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kéy fín fë, Saŋ ot Yéesú na ac ɗii na, ɗi yíppée won tih⁠ ⁠: «⁠ ⁠Ëlí⁠ ⁠! Ɓëyí bee daa har fa nay yeree Koope sarah, hosii bakaaɗɗi ɓëy ëldúnë rë⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Daa ri ɓëeꞌ na húmú wonaꞌ mi ron ra bitih⁠ ⁠: lahte ɓëyí ee ac filoon soꞌ ra, ɗi luk soo gaan fap, ndah balaa mi ac, ɗeef ɗi húmú në. ");
INSERT INTO ndv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Soꞌ mi bee sah, mi húmú yéeh ɓëeꞌ waɗ ɗii hen koon ɗa, ndaa yee kúɗ aya ac mi, ma na bëtsëꞌ muluɓ ra, ɗi biti koyyi Israyel yúh rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Saŋ wonaat tih⁠ ⁠: «⁠ ⁠Mi otte Ruuhi Koope kolaꞌte sun céppé sun fi man bëdú nen, hompe ɗii na. ");
INSERT INTO ndv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mi húmú yéeh ɓëeꞌ waɗ ɗii hen koon ɗa, ndaa Koope fa wol soꞌ bëtís a muluɓ ra húmú won soꞌ tih⁠ ⁠: “Fay ot Ruuha cép hom ow na⁠ ⁠; ɓëyí baa nay bëtsée a Ruuh-Peseŋ.” ");
INSERT INTO ndv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Te soꞌ mi Saŋ mi otte yii baaha, te mi seedete biti ɓëyí baa daa Koy Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kéy fín fë, Saŋ ayaatte tígë húmú wë aaꞌ fin ra, caŋke a ow ana di taalibe yi. ");
INSERT INTO ndv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Olaꞌ ri Yéesú na roommbiil, ɗi won tih⁠ ⁠: «⁠ ⁠Ëlí⁠ ⁠! Ɓëyí bee daa har fa nay yeree Koope sarah ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Keluu taalibe yi ana ya unni ƴah, wa ñeyute tal Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Heeltaꞌ Yéesú otte biti wa ñeyu tali ra, ɗi meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗon saamu yih⁠ ⁠?⁠ ⁠» Wa dëekúuté rí a tii ɓëyí në yëeddëꞌ Unni Koope, wonu ri tih⁠ ⁠: «⁠ ⁠Rabbi, fu dék dih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ëyí ɗon ot.⁠ ⁠» Tígí daaha, bi ɗeef naꞌa konte, wani Yéesú ñéerúuté, wa yúhúté tígë dék ɗí rë, wa yeelutee ɗíidëꞌ caan fi bisa a ɗi. ");
INSERT INTO ndv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anndere koy-yaafi Simoŋ Peer, non ɓëewí ana ya keluu wa unni Saŋ, wa ñeyute tal Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ɗi ɗéɓpí pay saami Simoŋ, won ɗi tih⁠ ⁠: «⁠ ⁠Fun olute Méssíifë⁠ ⁠!⁠ ⁠» (Iti fi tii baa daa ri Kiristaa mbée Buura Koo fal ri ra.) ");
INSERT INTO ndv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Anndere kúɗté Simoŋ Yéesú në. Yéesú yeelte Simoŋ níi won ɗi tih⁠ ⁠: «⁠ ⁠Daa fu Simoŋ, koy Saŋ⁠ ⁠; dalaꞌte woteh, fay dëekúu Sefaas.⁠ ⁠» (Iti fi tii baa daa ri⁠ ⁠: Peer. Iti fi tii Peer daa⁠ ⁠: laꞌ). ");
INSERT INTO ndv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kéy fín fë, Yéesú hampe waali Galile. Lahaꞌ ri ra, ɗi teeꞌaꞌte a Fílíp, won ɗi tih⁠ ⁠: «⁠ ⁠Aye fu ñee tal soꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fílíp dék Betsaydaa, ɓani Anndere a Peer daa boku gin. ");
INSERT INTO ndv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ɗi fi Fílíp nampee pay otte Natanayel, won ɗi tih⁠ ⁠: «⁠ ⁠Fun olute ɓëeꞌ në wonaꞌ Mëyíis téeríi Kootaa ra, bee na wonuu yonente ya Téerëe rë⁠ ⁠: yaa Yéesú fi Suseef, bee dék Nasaret ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayel won ɗi tih⁠ ⁠: «⁠ ⁠Yin wun mín ɗúh Nasaret nagajek a⁠ ⁠?⁠ ⁠» Fílíp won ɗi tih⁠ ⁠: «⁠ ⁠Yen saañ fu tíkíɗ afu íl⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wa ɓeyute waala na suu. Olaꞌ Yéesú Natanayel na ac ɗii na, ɗi won ɗi tih⁠ ⁠: «⁠ ⁠Bee daa koy ki Israyel tígí-tígí, bi yéeh nofaꞌ ow⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel won ɗi tih⁠ ⁠: «⁠ ⁠Fu yúhëꞌ sëꞌ dih⁠ ⁠?⁠ ⁠» Yéesú loffe ri won tih⁠ ⁠: «⁠ ⁠Homaꞌ fu tal eena ɗeef Fílíp dëekëy rë doom ra, mi otte ro.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayel ɓéyíɗté uni won tih⁠ ⁠: «⁠ ⁠Ɓahaa, kon daa fu Koy Koope⁠ ⁠! Daa fu Buuri Israyel⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Wona won mi ro biti mi otte ro tal eena ra, daa tah fu gém ë⁠ ⁠? Fay ot ƴi luk baa éemílëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɗi antee ɓaat won tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ɗon ay ot sun-Koo kúnsëh, malaaka yi Koope lawe sun cépé, aye soꞌ mi Koy-ɓëeꞌ në.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Waal ana filoon fi baaha, kílëek lahte Kanaa di Galile. Yaafi Yéesú húmú në. ");
INSERT INTO ndv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yéesú a taalibe yi ɓal dëekúté kílëegë, wa ayute. ");
INSERT INTO ndv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ɗúmëꞌ béeñë ndaje ma ra, yaafa nduŋutte Yéesú baaha won ɗi tih⁠ ⁠: «⁠ ⁠Wa lahluy béeñ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Síkírëh sëꞌ yaa ow⁠ ⁠! Fu fahaꞌ biti mi paga yi te wahtii soꞌ lahay doom⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yaafa payte won koy-pagoh ya tih⁠ ⁠: «⁠ ⁠Yii won ɗon ɗi ɓéeɓ, lah pëgí rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ɗeef lahte yaaɗ pëenë yí yugusuu laꞌ húmú në, ƴi yëwúɗɗë ƴahti ɓukutoh raa efuu na. Bina-bina waa na ɓéeɓ waɗtee mín soɗ biŋwaar iniil mbée pëenë. ");
INSERT INTO ndv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yéesú won koy-pagoh ya tih⁠ ⁠: «⁠ ⁠Néhí yaaɗɗi ƴee muluɓ.⁠ ⁠» Wa nehute yaaɗɗa níi líiffé pew. ");
INSERT INTO ndv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tígí daaha, Yéesú won wa tih⁠ ⁠: «⁠ ⁠Leegi éfí në mulaa ɗon kom koy ki gaana.⁠ ⁠» Wa pagute yii baaha. ");
INSERT INTO ndv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ɗíkísëꞌ koy ki gaana efa, ɗeef mulaa yíssëhté béeñ. Ɗi yéeh tígë koluu koy-pagoh ya béeñë rë, ndaa wa fi ƴaa yúhú. Tígí daaha, koy ki gaana dëekké yíkíi kílëegë ");
INSERT INTO ndv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","won ɗi tih⁠ ⁠: «⁠ ⁠Ndaje mi lah ɓéeɓ ɓëewë ɗéɓúu efaꞌ béeñë lukki neɓ ɗa. Tíl níi ɓëewë sampi píi faanni wa raa nék, ƴee loolay níi rë anti ɗúhrú⁠ ⁠! Ɗo nék fu henay ɗah, fu yef béeñë lukki neɓ ɗa yefo níi a ɗeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Baa daa kimtaana ɗéɓpí paŋ Yéesú rë. Ɗi pagaꞌ ri Kanaa di Galile. Ɗaaha, ɗi teeɓaꞌte ndami, tahte taalibe yi gémúté rí. ");
INSERT INTO ndv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Filoon fi baaha, ɗi saañce Kafarnawum ɓani yaafi, koy-yaayyi a taalibe yi⁠ ⁠; wa homute i waal daaha. ");
INSERT INTO ndv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Leɓaꞌ Paagiyëwúɗɗë rë, Yéesú kolohte saañce Yerusalem. ");
INSERT INTO ndv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lahaꞌ ri ɗi haalte baylii Faam fi gaani Koope ra, ɗi ɗeef júlë yë wani harra a fañnji wa filiɓ, yaayoh yi bëdú yë, a ɓëewë në lofrantuu hélíis rë. ");
INSERT INTO ndv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tígí daaha, ɗi saampe dúɗ níh yugusse njooraa, líkké wë, ɗúhíɗté wë ɓéeɓ ëssín ɓani júrí wë⁠ ⁠; ɗi júlkëñcé taabulli ɓëewë në lofrantuu hélíis rë, hasalte hélsí wë feey, ");
INSERT INTO ndv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","antee won yaayoh yi bëdú yë tih⁠ ⁠: «⁠ ⁠Këllí iñƴee ɓéeɓ deh⁠ ⁠! Ngënë tíkí faam Baasoꞌ yaayaa⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Filoon fi baaha, nuffi taalibe yi payte unna bíníyú Téerëe rë bitih⁠ ⁠: «⁠ ⁠Tígë teem soꞌ Faamu ra, daa mi yúh rí keeñ soꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tígí daaha, ɓaha yi yëwúɗɗë wonu ri tih⁠ ⁠: «⁠ ⁠Pagiɗ fun yii éemílëꞌí nay fun teeɓe biti fu lahte sañ-saña pagaꞌ fu yii bee ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yéesú tahte won wa tih⁠ ⁠: «⁠ ⁠Ɗon poysaꞌ Faam fi gaani Koope fi bee raa, may rii taɓahaat filiɓ waal éeyë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɓaha yi yëwúɗɗë wonu ri tih⁠ ⁠: «⁠ ⁠Faam fi bee taɓahute kíil sabay iniil a kíil pëenë (46) bee ra, ɗo fantee won fu mín ɗíi taɓahaat filiɓ waal éeyë ë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ndaa Faam fa na wonaꞌ Yéesú rë, ɗi yin kay neh gét nëe wonaꞌ faan ɗi fi baaha. ");
INSERT INTO ndv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tílëꞌ níi Yéesú këllúté ɓúudé rë, taalibe ya nérsúuté biti Yéesú na húmú won uni bah⁠ ⁠; yii baa tahte wa gémúté yee won Téerëe rë a una húmú won Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jamanaa homaꞌ Yéesú Yerusalem feedi Paaga ra, ow caak gémúté rí oluu wa kimtaanna paŋ ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ndaa bi yúh Yéesú ɓëewë ɓéeɓ, ɗi lekaay wa. ");
INSERT INTO ndv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ɗi húmú sohlaay biti ow ac ɗii na won biti díw man ɗeh, ndah yii homaꞌ ow ɓéeɓ ɗi yúh rí. ");
INSERT INTO ndv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Lahte ɓëyí hínú Nikodem, ɗi non fariseŋŋa te ri kélfë yëwúɗ. ");
INSERT INTO ndv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɗi acce elek ɗeefiɗte Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun yúhúté biti Koope daa wol ro yëeddí fun, ndah ow mínéh paŋ kimtaanna paŋ fu ra hém Koope ñéerëey a ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yéesú tahte won ɗi tih⁠ ⁠: «⁠ ⁠Mee roo won kaaf ka ra ee⁠ ⁠: ow mínéh yúh iña Nguur ki Koope, hém ɗi límëetúy.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem meelte ri won tih⁠ ⁠: «⁠ ⁠Ow tíl níi ɓaha raa, ɗi ay límëetúu ɗíh⁠ ⁠? Ɗi ii nimil loo yaafi límëetú kay maan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yéesú tahte won ɗi tih⁠ ⁠: «⁠ ⁠Mee roo won kaaf ka ra ee⁠ ⁠: ow mínéh haal Nguur ki Koope, hém ɗi ñeyay muluɓ a Ruuh-Peseŋ, ɗi límëetú. ");
INSERT INTO ndv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ɓëyí límú ow, pesaꞌ pes ow⁠ ⁠; ɓëyí límúu Ruuhi Koope, pesaꞌ Ruuhi Koope. ");
INSERT INTO ndv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yin ɓanay roo jaahal di yee wonaꞌ mi ro biti ɓëewë warutee límëetú rë. ");
INSERT INTO ndv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ngilaaw ma laɓaꞌ tígí neɓaꞌ ri fu kelee na neh a⁠ ⁠? Añcaŋ, fu yéeh tígë kolaꞌ ri a tígë na saañ ɗi ra⁠ ⁠! Ɗi ɗaaha kep di ɓëyí límúu Ruuhi Koope⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodem won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Baa mínëꞌ lah ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yëeddëhë teempe ti ɗo nen Israyel fu yéeh yii baa a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mee ron won kaaf ka ra ee⁠ ⁠: fun hom wonuu iña yúhú fun ɗa, fun seede iña na olu fun ɗa, ndaa ɗon fahuuy fun síkírëh. ");
INSERT INTO ndv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi won ɗon iñi ëldúnë ɗon gémúy sëꞌ rëe, ɗon ay soo gémée ɗíh biti mi wona ron iñi sun-Koo⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ow pëyrëy yúhí sun-Koo⁠ ⁠; soꞌ mi Koy-ɓëeꞌ fë kolaꞌ na ra doŋ daa yúh rí. ");
INSERT INTO ndv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«⁠ ⁠Ɗee keraꞌ Mëyíis goŋ fa yugusuu përëm sun fi duuda, ɓéyíɗté rí luufa ra, soꞌ mi Koy-ɓëeꞌ mi waɗti ɓéyrúun ɗaaha, ");
INSERT INTO ndv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nda ɓëyí gém sëꞌ ɓéeɓ lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yúhí biti Koope fahaꞌ ɓëewë fahoo níi ɗi yeraꞌte Koy ka lahaꞌ ri ra kut, nda ɓëyí gém ɗii na ɓéeɓ ɓanti saŋku, lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Koope wolay Koohi ëldúnë biti ri ac daani ɓëewë⁠ ⁠; ëe-ëeꞌ, ɗi wol ri sëmlëꞌí wë. ");
INSERT INTO ndv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kon ɓëyí gém Koy ka na ii daanu⁠ ⁠; ɓëyí gémëy rí nék daanute níi wocce, af yee gémëy ɓëeꞌ ɗi fi Koy ki yíníi Koope kut ra. ");
INSERT INTO ndv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Te yee haalaꞌ daana ra daa ri beh⁠ ⁠: niiña acce feey, ndaa ñúusë daa génël ɓëewë niiña ndah pagaɗɗi ɓossi wa. ");
INSERT INTO ndv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ɓëyí na paŋ ɓos ɓéeɓ wonay yin niiña, ɗi hegaꞌ ri hegoo, ndah ɗi kaaꞌ biti pagaɗɗi ɓossi feeñ. ");
INSERT INTO ndv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ɓëyí pagaꞌ kaah nék saamaꞌ niiña, nda ɓëyí ot pagaɗɗi ɓéeɓ yúh biti Koope daa ɓek ɗi na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Filoon fi baaha, Yéesú a taalibe yi koluute suute Yúdée. Ɗi hompe i waal daaha a wa, ɗi na bëtís ɓëewë. ");
INSERT INTO ndv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Saŋ nampee hom Enon di hëbís Salim na bëtís daaha ɓal, bi caak tígë muluɓ. Ɓëewë aye ɗii na, ɗi bëtsé wë. ");
INSERT INTO ndv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Baaha ɗeef ɗi téƴúy kasu doom. ");
INSERT INTO ndv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Lahte bis, i ow di taalibe yi Saŋ na taasuu a yëwúɗ yii leŋke di na ɓukutuu. ");
INSERT INTO ndv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wa payute Saŋ na wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, fu nérsëhté ɓëeꞌ ɗoni húmú énfí laahi Yurdeŋ fu na seedeyiɗ ɗi ra a⁠ ⁠? Ɗi dalte bëtís te ɓëewë ɓéeɓ yuluu ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Saŋ won wa tih⁠ ⁠: «⁠ ⁠Ow mínéh lah yii man ɗah, te Koo oneh ri ri. ");
INSERT INTO ndv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɗon mínú seede biti sah, mi wonte biti mi Buura Koo fal ri ra neh, a biti Koope wol soꞌ këllëhí doŋ. ");
INSERT INTO ndv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kílëek bi ƴaali⁠ ⁠; kooji ƴaala nék homaꞌ dah, kelee una, keeña sos níi sos. Daa mi kooji bah, yii baa daa tah keeñ soꞌ sos níi sos. ");
INSERT INTO ndv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ɗi waɗti laha maakaama laho saye, bi soꞌ ëylée. ");
INSERT INTO ndv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«⁠ ⁠Ɓëeꞌ kolaꞌ sun-Koo ra daa paaꞌ ɓéeɓ sun. Ɓëyí feey fi beh, míntí nona feey te wonaꞌ yii leŋ ëldúníi beh. Ɓëeꞌ kolaꞌ sun-Koo ra nék daa paaꞌ ɓéeɓ sun⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ɗi seedeyaꞌ iña ot ɗi a ƴee keloh ri ra, ndaa ow na síkíréeh rí. ");
INSERT INTO ndv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ɓëyí tah iña na won ɗi ra, déggëlté biti Koo wonaꞌ kaah. ");
INSERT INTO ndv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ɓëeꞌ Koope wol ri ra, léhínëꞌ woni Koope, ndah Koope ɓeɓ Ruuhi Peseŋi ɓéeɓ soɗte ri ri. ");
INSERT INTO ndv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Boffa daa fahaꞌ Koy ka níi tíkké iña ɓéeɓ yaꞌi. ");
INSERT INTO ndv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ɓëyí gém Koy ka lahte pesa na ɗúméh rë⁠ ⁠; ɓëyí kaaꞌ gémí rëe nék ii yúh pesi bah, te Koope ay rii dékée teeɓ haay-keeñ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Waalli ƴaaha, fariseŋŋa keluute ban fi biti yee lah Yéesú taalibe, bëtíssé wë rë, luk ƴi Saŋ Batis. (Ɗeef nagajek ɗi fi Yéesú neh daa na húmú bëtís, taalibe yi daa na húmú pagu yaa tígë.) Yúhëꞌ Yéesú biti yii baa halte nuffi fariseŋŋa ra nék, ");
INSERT INTO ndv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ɗi kolohte Yúdée, na nimil Galile. ");
INSERT INTO ndv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ɗi ƴahti saañ dín fë rëe, ɗi waɗtee ñee Samari. ");
INSERT INTO ndv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ɗaaha, ɗi tílté níi ɗi leɓohte gini hínú Sikaar non Samari, di hëbís feey fa húmú on Yakop koohi Suseef ra. ");
INSERT INTO ndv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakop húmú hacce yéem daaha. Bi mok Yéesú waali, ɗi tookke ɓúk yéemë na hílsëh, ɗeef naꞌ lahte leelu af. ");
INSERT INTO ndv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Taalibe yi suute filiɓ ginin saam yii nay waa ñame. Lahte ɓelii dék Samari acce neh wahtii baaha. Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠On soꞌ muluɓ mi han yaa ow.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Mantee ɓal, fu ɗagaꞌ soꞌ muluɓ ɗíh te fu yëwúɗ, mi ɓëy Samari⁠ ⁠?⁠ ⁠» (Ɗeef wa fi yëwúɗɗë nagajek, fahuuy bok a ɓëy Samari dara.) ");
INSERT INTO ndv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu yúh yii na onaꞌ Koo a soꞌ mi ɓëeꞌ na won a ɗo ra koon, daa fay soo ɗage muluɓ, mi on ɗo mulaa na onaꞌ pes ɗa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɓelaa tahte won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, ɗo fu lahay hoc níi wocce, te yéemë nooɗte tíkké sun⁠ ⁠! Fay ɗúhée mulaa na onaꞌ pes ɗa di kon⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ciffi fun Yakop daa heliɗ fun yéemí beh. Ɗi hante na mulaa, koyyi hanute na, yuppi hanute na, fantee habaꞌ biti fu luk ɗii gaan a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëyí han na mulii yéemí bee ɓéeɓ, fay sifiraat⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ndaa ɓëyí han na mulaa nay mi rii one ra, ii sifiriil taꞌ⁠ ⁠: mulaa nay mi rii one ra kay, ay yíssée culi julli pesi na ɗúméh ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, on soꞌ na mulii ƴah, nda mi woc sifiroh te mi aylileh neh yéemí beh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Kon paye fu kale ƴaalu fu ac.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Mi lahay ƴaal.⁠ ⁠» Yéesú won ɗi daaha tih⁠ ⁠: «⁠ ⁠Fu won kaah biti fu lahay ƴaal, ");
INSERT INTO ndv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ndah fu ñeete ƴaal iip, te ɓëeꞌ ɗoni na pesu leegi ra ƴaalu neh. Kon fu won kaah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tígí daaha, ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa mi ot na, fu yonente⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Caacci fun húmú jaamiyuu Koope sun fi daŋi beh, ndaa ɗon fi yëwúɗɗë, ɗon wonu ɗi waɗti jaamiyuun Yerusalem.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yaa ow, gémé yee na won mi ro bee ra⁠ ⁠: ay tíl níi jaamiyohi ɓëewë Baap-Koo sun fi daŋi beh, mbée Yerusalem ii caak solo. ");
INSERT INTO ndv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɗon fi ɓëy Samari, ɗon na jaamiyuu, ndaa ɗon yíih Koope⁠ ⁠; fun fi yëwúɗɗë nék, fun na jaamiyuu ri te fun yúhú rí, ndah ri ñeyaꞌ fun fi yëwúɗɗë në, múclí ëldúnë. ");
INSERT INTO ndv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wahtaa hompe lah, te ri lahte, wahtaa nay jaamiyee ɓëewë na saamu Baap-Koo kah-kah ra, wa ñeyaꞌ ri Ruuh-Peseŋ a kaaf ka ra. Baap-Koo saam mani ɓëewí ƴah. ");
INSERT INTO ndv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Koope ɗi Ruuh, te ɓëyí na jaamiyoh ri waɗti ñeyaa Ruuhi a kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Mi yúhté biti Buura Koo fal ri ra maanam Kiristaa, ac ayo. Ɗi ac ɗaa, ɗi ay fun teeɓ ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi, soꞌ fa na won ɗoo na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Taalibe yi Yéesú lahuu tígí daaha. Oluu wa Yéesú na won a ɓeleɓ ra, wa éemúté níi éem, ndaa ow di waa na kaañay meel Yéesú yee na saam ɗi ra, a yee tah ɗi na won a ɓelaa ra. ");
INSERT INTO ndv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tígí daaha, ɓelaa helte peni mulii, nimilte ginin won ɓëewë tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«⁠ ⁠Ëyí ɗon ot ɓëeꞌ abee wonte soꞌ iña paŋ mi ra ɓéeɓ. Ɗi Buura Koo fal ri ra neh delem a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɓëewë koluute, suute ɗeefri Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Filiɓ fi baaha, taalibe ya gangalu Yéesú ñam wonu tih⁠ ⁠: «⁠ ⁠Ɓahaa, túmé yin lowu book⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ndaa ɗi won wa tih⁠ ⁠: «⁠ ⁠Mi lahte ñami ɗon yíih rí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tígí daaha, wa na meelantuu hanndal ki wa wonu tih⁠ ⁠: «⁠ ⁠Ow kompe ri ñam neh a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Paŋ yee fahaꞌ ɓëeꞌ wol soꞌ ra níi mit sëk, daa ñami soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","«⁠ ⁠Ɗon wonu neh dee a lec tas céyín iniil a⁠ ⁠? Soꞌ mi won ɗon tee⁠ ⁠: ëlí meeyya⁠ ⁠! Iña nonte níi seh lec. ");
INSERT INTO ndv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ɓëeꞌ në lec ɗa ee liil yínlí rë, na négírëꞌ peba na saañ pesa na ɗúméh rë. Hen ɗaaha raa, ɓëeꞌ soh ra a bee lec ɗa bok, lah sos-keeñ. ");
INSERT INTO ndv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Léehë won kaah bitih⁠ ⁠: “Ɓëeꞌ soh ra bokaay a bee lec ɗa.” ");
INSERT INTO ndv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi yeñce ron lec meeyi ɗon mësúy nëe paŋ dara. I ow kay daa légéyú rí, ɗon daa njiriñuu ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kolaꞌte bee wonaꞌ wa ɓelaa biti Yéesú wonte ri iña paŋ ri ɓéeɓ rë, i ow caak di ɓëy Samari dékú gini baa ra gémúté Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Te ɗeefruu wa ri ra, wa ɗagute ri ɗi hom waa na daaha⁠ ⁠; tígí daaha, ɗi hompe waal ana waa na. ");
INSERT INTO ndv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iña na won ɗi ra tahte wa ɓaatuutee caak na haalu ngémë. ");
INSERT INTO ndv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wa wonu ɓelaa tih⁠ ⁠: «⁠ ⁠Iña ɓílíɗ fu fun ɗa daa tah fun gém neh doŋ, ndaa biti fun kellirute affi fun ɗi na won, te fun yúhúté biti daa ri Sëmlëhí ëldúnë kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Filoon fi waalli ana ya hom Yéesú daaha ra, ɗi kolohte saañce Galile. ");
INSERT INTO ndv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ɗi woniɗte afi bitih⁠ ⁠: «⁠ ⁠Yonente heefuu gina dék ɗí rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Lahaꞌ ri Galile ra, ɓëy gina teeriyuute ri daaha, ndah payuu wa feedi Paaga Yerusalem ra, wa olute iña paŋ ɗi filiɓ feeda ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ɗaaha, Yéesú ñeyaatte Kanaa di Galile, tígë húmú yíssëꞌ rí mulaa béeñ rë. Ɗeef ow di dakki buur dék Kafarnawum, koy ka keente jér. ");
INSERT INTO ndv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kelaꞌ ri biti Yéesú kolohte Yúdée acce Galile ra, ɗi saañce ɗeefiɗte ri, ɗaŋke ri pay Kafarnawum paƴiɗ ɗi koy kee ke ri na maanndaꞌ húl rë. ");
INSERT INTO ndv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɗon oluy kimtaan a iñi éemílëꞌté rëe daal, won ti ɗon ii gém múk ë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Daga won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, yípée ac faam balaa koy soꞌ húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Nimile faam, koohu ɓéyíɗté af, yin ii rii kat.⁠ ⁠» Ɓëeꞌ gémpé yee won ɗi Yéesú rë, kolohte na saañ faam. ");
INSERT INTO ndv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɗi hom waali faam fa, súrgë yí téebílúuté rí wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, koohu kolohte⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɗi meelte wa wahtaa koloh kúkëyë rë, wa wonute ri biti faan kúkëyë woc tama bee wotaꞌ naꞌ ƴutuuɗ leelu af aaꞌ fin ra. ");
INSERT INTO ndv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Boffi kúkëyë yíppée ot biti yaa wahtaa wonaꞌ ri Yéesú biti koohi ɓéyíɗté af ra. Kolaꞌte baaha, ɓani ɓëy faami ɓéeɓ gémúté Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Baa daa kimtaani ana fa paŋ Yéesú kolaꞌ ri Yúdée nimilte Galile ra. ");
INSERT INTO ndv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Filoon fi baaha, ndaje di ndaje yi yëwúɗɗë lahte Yerusalem, Yéesú kolohte saañce na. ");
INSERT INTO ndv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Gini baaha lahte laahi Ébrë yë wonuu ri Betsataa, hom hëbís ílë në wonuu Ílí Harra ra. Ɗi lahte mbaar iip. ");
INSERT INTO ndv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","I jéríɗ caak daa fanuu mbaarri ƴaaha⁠ ⁠: búumíɗɗë deh, ɓëewë në yíiɓú rë deh, lëfëñíɗɗë deh.  ");
INSERT INTO ndv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Filiɓ fi jéríɗɗí ƴaaha, lahte na ɓëyí hente kíil sabay éeyë a kíil peeye (38) ɗi fanohte ri jér. ");
INSERT INTO ndv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Olaꞌ Yéesú ɓëeꞌ fanohte feey te ri yúhté biti ɗi maañcee jér rë, ɗi meelte ri won tih⁠ ⁠: «⁠ ⁠Fu fahaꞌte biti fu wah a ƴaal kowa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jérdë won ɗi tih⁠ ⁠: «⁠ ⁠Ɓahaa, mulaa hégíƴëh rëe, mi na laheh ɓëyí mín sëe ɓek filiɓ laaha⁠ ⁠; mi home étíɗ saañ haal raa, ow kay ɗéɓ sëꞌ filiɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tígí daaha, Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Kolee, fu pon dilu fu tíl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ɓëeꞌ yíppée wah, kolohte ponte dili na tíl. Yiin paƴ Yéesú ɓëeꞌ rë teeꞌaꞌ a bisa na hílsúu yëwúɗɗë rë. ");
INSERT INTO ndv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oluu ɓaha yi yëwúɗɗë ɓëeꞌ a dili, wa wonu ri tih⁠ ⁠: «⁠ ⁠Fu waray meeɓ dilu bisee woteh beh, ɗi bisa na hílsúu rë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɓëeꞌ won wa tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ paƴ soꞌ ra daa won soꞌ mi ɓeɓ dili soꞌ mi tíl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wa meelute ri wonu tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ won ɗo baaha ra wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ndaa ɓëeꞌ yéeh paƴohi, ɗi mínéh ríi teeɓaꞌ, bi múuƴ Yéesú filiɓ dúukëlí ɓëewë húmú daaha ra. ");
INSERT INTO ndv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Filoon fe, Yéesú teeꞌaꞌte a ɓëeꞌ filiɓ Faam fi gaani Koope, won ɗi tih⁠ ⁠: «⁠ ⁠Fu abaa fu wahte leegi⁠ ⁠! Ngana bakaaril, toñeh yii luk baa misik ay roo kate.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kolaꞌ ɓëeꞌ dah, ɗi payte wonte ɓaha yi yëwúɗɗë biti ɓëeꞌ paƴ ɗi ra Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kolaꞌte baaha, wa henute halañ sun fi Yéesú, di yee paƴaꞌ ri ow bisa na hílsúu wë rë. ");
INSERT INTO ndv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ndaa Yéesú won wa tih⁠ ⁠: «⁠ ⁠Baasoꞌ ee légéy rë na saañ, soꞌ ɓal mee légéy rë maa saañ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wona won ɗi baa ra, tahte ɓaha yi yëwúɗɗë ɓaatuutee caŋ hawi húl, ndah teyay biti doŋ ɗi poote kootii bisa na hílsúu rë, ndaa ɗi wonaꞌ ti Koope daa boffi, daa ri biti daa wa teyu. ");
INSERT INTO ndv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yéesú tahaatte won tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: soꞌ mi Koy ka mi mínéh koloh rek mi paŋ⁠ ⁠; mi pagaꞌ yee ot mi Baasoꞌ na ra. Yii paŋ Baasoꞌ ɓéeɓ, soꞌ mi Koy ka mi pagaꞌ ri. ");
INSERT INTO ndv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ɗi fahaꞌte soꞌ, te ɗi na teeɓ soꞌ iña na paŋ ɗi ra ɓéeɓ. Ɗi ay soo teeɓ ƴi ay pagu kay, ƴi luk ƴaa gaan fap níi ɗon éem⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","di na këllëꞌ Baasoꞌ ow ɓúudé on ɗi pes, soꞌ mi Koy ka ɓëyí neɓ soꞌ mi on ɗi pes. ");
INSERT INTO ndv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baasoꞌ na aattiyeeh ow, ndaa ɗi onte soꞌ mi Koy ka sañ-sañi aattiyaa mi ɓéeɓ, ");
INSERT INTO ndv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","nda ɓëewë ɓéeɓ yeɗ soꞌ mi Koy ka cér ti di yeruu wa ri Baasoꞌ nen. Ɓëyí yeray soꞌ mi Koy ka cér, ɗeef yeray Baasoꞌ fa wol soꞌ ra cér. ");
INSERT INTO ndv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí síkírëh woni soꞌ, te ri gém ɓëeꞌ wol soꞌ ra, lahte pesa na ɗúméh rë. Ɗi ii daanu⁠ ⁠: ɗi múccé kúl kë, haalte pesa. ");
INSERT INTO ndv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kaaf ka bee ɓúk sëꞌ beh⁠ ⁠: wahtaa ee saañ lahe ra, te ri lahte níi wocce, wahtaa nay kelee ɓëewë húlú rë un soꞌ mi Koy Koope ra, te ɓëewë nay kelee woni soꞌ ra ay pes. ");
INSERT INTO ndv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Di homaꞌ pesa Baasoꞌ na, ɗi tahraꞌ soꞌ ri ɗaaha, pesa hompe soo na. ");
INSERT INTO ndv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Te ri onte soꞌ mi Koy ka sañ-sañ aattiyaa, ndah daa mi Koy-ɓëeꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yee won mi ɗon ra ɓanay ron jaahal⁠ ⁠: wahtaa ee ac ɗa, ɓëewë húlú hacu feey fi bee ra ɓéeɓ ay keloh un soꞌ, ");
INSERT INTO ndv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","te wa ay koloh ɓúudé. Ɓëewë húmú paguu yin wun ra ay koloh, haal pesa na ɗúméh rë, ƴee húmú paguu yin ɓos ra koloh, daanu. ");
INSERT INTO ndv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Soꞌ mi Koy ka mi mínéh koloh rek mi paŋ, mi na pageh yee neɓaꞌ soꞌ ra, ndaa yee neɓaꞌ ɓëeꞌ wol soꞌ ra. Mi hom aattiyaꞌ yee nah soꞌ Koope ra, te aattiyaꞌi soꞌ júɓpé. ");
INSERT INTO ndv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«⁠ ⁠Daa mi seedeyira af soꞌ iñi soꞌ koon kep, ow ii tah biti mi won kaah. ");
INSERT INTO ndv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ndaa ow kay daa na seedeyiɗ soꞌ, te mi yúhté biti iña na won ɗi sun fi soꞌ ra kaah. ");
INSERT INTO ndv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɗon wolute i ow Saŋ Batis na, te iña won ɗi sun fi soꞌ ra kaah. ");
INSERT INTO ndv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Seedii leŋ sun fi soꞌ ƴaha bi ow kut, mi sohlaay⁠ ⁠; ndaa mi won ɗon woni Saŋ, nda ɗon mín múc. ");
INSERT INTO ndv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Saŋ húmú man lampii këɗɗú hawaanaa nen, te ɗon húmú dalute ot neɓ niiñi. ");
INSERT INTO ndv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ndaa lahte seedii daa luk bi Saŋ lah solo⁠ ⁠: daa wa iña na paŋ mi ra. Ƴee nah soꞌ Baasoꞌ paŋ ra won sun fi soꞌ, wa teeɓaꞌ biti Baasoꞌ daa wol soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Te Baasoꞌ fa wol soꞌ ra, seedeyiɗ soꞌ ɓal. Yaa biti kay, ɗon kéllúy ɗi na won, te ɗon ëllúy rí. ");
INSERT INTO ndv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ɗon habuy unni ɗon na ndah ɗon gémúy soꞌ mi ɓëeꞌ ɗi wol ri ra. ");
INSERT INTO ndv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɗon ƴahti yoon Téerëe rëe, ɗon ɓekuu keeññon ɓéeɓ filiɓ, ndah ɗon séentúu pesa na ɗúméh rë në. Añcaŋ, Téerëe seedeyiɗ soꞌ, ");
INSERT INTO ndv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ɗon anutee kaaꞌ ɗeefri soꞌ, ɗon pes⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«⁠ ⁠Mi sohlaay kañi kolaꞌ ow na. ");
INSERT INTO ndv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mi yúh ɗon⁠ ⁠: mi yúhté biti ɗon fahuuy Koope. ");
INSERT INTO ndv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi ayiɗ Baasoꞌ, ɗon kaaꞌuute síkírëhí sëꞌ. Ndaa ow kay daa ayira afi raa, ɗon síkírëh rí. ");
INSERT INTO ndv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɗon fahuu biti rek ɗon kañantee affon, ɗon anutee fahuuy kañi kolaꞌ Koope fa yínë kut ɗa⁠ ⁠! Ɗon ay soo gémée ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ngënë hëbíi biti daa mi nay ron teeɓee a Baasoꞌ⁠ ⁠; Mëyíis daa nay ron teeɓee, ɗi fa ɗon tíkú yaakaaron ɗii na ra. ");
INSERT INTO ndv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nagajek, ɗon gém Mëyíis kaah koon, ɗon warutee soo gém, ndah ɗi bíníté yii leŋ soo na. ");
INSERT INTO ndv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ndaa hém ɗon gémúy iña bíní rí rëe, ɗon ay gémée wonni soꞌ ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Filoon fi baaha, Yéesú húussé laahi Galile fa na wonuu ɓal laahi Tiberiyat ra, saañce ɓúgí yínëe. ");
INSERT INTO ndv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bi olu ɓëewë kimtaanna na paŋ ɗi, ɗi na wahil jéríɗɗë rë, dúukël ow ñeete tala. ");
INSERT INTO ndv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Lahaꞌ ri ra, ɗi lappe daŋ, tookke a taalibe yi. ");
INSERT INTO ndv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Baaha, ɗeef feedi yëwúɗɗë na wonuu Paak ra leɓohte. ");
INSERT INTO ndv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ɓéyrëꞌ Yéesú afi, ɗi otte ɓëewí caakute níi caak na ayu ɗii na. Tígí daaha, ɗi meelte Fílíp won tih⁠ ⁠: «⁠ ⁠Yen ay lomee mbúuríi mín ñëmíɗ ɓëewí ƴee dih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ɗi hom olsohi Fílíp, daa tah ɗi wonaꞌ ri ɗah⁠ ⁠; ɗeef ɗi yúhté yee nay ri page ra níi wocce. ");
INSERT INTO ndv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fílíp won ɗi tih⁠ ⁠: «⁠ ⁠Wuti yen lah hélsí tam ɗúmléh wë koon, ii mín lom mbúurú níi wa ɓéeɓ lah wuti ƴaha ñiip.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tígí daaha, ow kay di taalibe yi, Anndere koy-yaafi Simoŋ Peer won ɗi tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«⁠ ⁠Lahte kúkëyí kúɗté mbúurú loorso iip a jén ana deh, ndaa wa ay taaɓe ɓëewí caakki ƴee yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Wëní wë took.⁠ ⁠» Ɗeef tígë húmú caakke gaawa. Wonuu wa baaha ra, wa tookute. Ɓëewí ƴaalla húmú në rë warutee mit ow júnní iip (5.000). ");
INSERT INTO ndv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yéesú ɓeɓpe mbúurëe, símpé Koope, woraꞌte wa ɓëewë. Ɗi ɓeɓpe jénë hente ɗaaha ɓal, woraꞌte wa ɓëewë níi ow fi ow waa na ɓéeɓ lahte ƴi doyte ri. ");
INSERT INTO ndv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ñamuu wa ɓéeɓ níi wa laalute ra, Yéesú won taalibe yi tih⁠ ⁠: «⁠ ⁠Négíríi wooñnjiida, yin ɓan naa yah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Négírúu wooñnjiidi mbúurú yí iippa ñamu ɓëewë rë, wa líiffé dama sabboo a dama ana. ");
INSERT INTO ndv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ola olu ɓëewë kimtaana paŋ Yéesú rë, tahte wa wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí bee daa yonentaa húmú wonu biti waɗtee ac ëldúnë rë kaah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bi yúh Yéesú biti ɓëewë yuluu hami daaha tík ɗí buuri wa, ɗi hécíilté lappe daŋa, ɓani afi njunduŋ. ");
INSERT INTO ndv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sos naꞌin, taalibe yi Yéesú cépúté ɓúk laaha. ");
INSERT INTO ndv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Wa haalute gaal na húusú laaha yullute waal Kafarnawum. Koo elekke affi wa, ɗeef Yéesú ɗeefray wa doom. ");
INSERT INTO ndv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bi gaan ngilaaw ma, mulii laaha yampe na hégíƴëh. ");
INSERT INTO ndv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sayuu taalibe ya níi wa homute yii mitte kilomet iip mbée pëenë filiɓ laaha ra, wa séenúté ow na tíl sun fi mulaa, ɗeef Yéesú daa na ac waa na gaala⁠ ⁠; wa yípútée tíit. ");
INSERT INTO ndv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ndaa Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ngënë tíití⁠ ⁠! Yaa soꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tígí daaha, taalibe ya homu woni ɗi haal gaala, wa yípútée teer tígë na suu wa koon ɗa. ");
INSERT INTO ndv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yíilëꞌ Koo kéy fín fë, dúukëlí ɓëewë húmú tasu ɓúk laaha ra húmú olute biti gaal yínë kut daa húmú daaha aaꞌ fin⁠ ⁠; te wa yúhúté biti na suu taalibe ya ra, Yéesú ñéerëey a wa filiɓ gaala⁠ ⁠; wani affi wa kut daa suu. ");
INSERT INTO ndv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tígí daaha, lahte gaalli koluu Tiberiyat ayute teerute hëbís tígë húmú ñamuu wa mbúurëe, bee símëꞌ Yíkëe Koope ra. ");
INSERT INTO ndv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bi olu wa biti ɗi fi Yéesú a taalibe yi húmúy në, wa haalute gaalli ƴaaha, na suu Kafarnawum saami. ");
INSERT INTO ndv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɗeefuu wa ri ɓúgí yíníi laaha ra, wa meelute ri wonu tih⁠ ⁠: «⁠ ⁠Fu ac dee kiri ɓahaa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: wëerté sëꞌ biti mbúurëe ñamu ɗon níi looyon maƴce ra daa tah ɗon na saamu soꞌ, ndaa biti ɗon yúhú iti fi kimtaanni soꞌ neh. ");
INSERT INTO ndv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ngënë mëkí ñami ay míllée yah. Lah mëkí bee na onaꞌ pesa na ɗúméh rë kay, bee nay mii onee soꞌ mi Koy-ɓëeꞌ rë. Baap-Koo yeɗte soꞌ sañ-sañi baaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wa meelute ri wonu tih⁠ ⁠: «⁠ ⁠Koope fahaꞌ biti fun paŋ légéyí bih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Légéyë seh Koope ɗon na ra biti ɗon gém soꞌ mi ɓëeꞌ ɗi wol ri ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fay fun teeɓe kimtaani bi níi tah fun gém ɗë⁠ ⁠? Fay page yii bih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Caacci yen ñamute maan luufa ti di bíníyúu rí Téerëe bitih⁠ ⁠: “Ɗi onte wa yii ñamun wa, yii kolaꞌ sun-Koo.”⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: Mëyíis neh daa onaꞌ ñama kolaꞌ sun-Koo ra, Baasoꞌ daa na on ɗon ñami kah-kah fa kolaꞌ sun-Koo ra. ");
INSERT INTO ndv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ñama na onaꞌ Koope ra, daa ri bee kolaꞌ sun te na on ɓëewë pesa na ɗúméh rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tígí daaha, wa wonu Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa on fun ñami ƴaa faraah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Daa mi ñama na onaꞌ pesa ra. Ɓëyí ɗeefiɗ soꞌ wocce yaaɓ, ɓëyí gém sëꞌ wocce sifiroh. ");
INSERT INTO ndv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mi wonte ron ri⁠ ⁠: ɗon olute soꞌ ngëeƴ, ndaa ɗon kaaꞌuute gémí sëꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɓëyí Baasoꞌ on soꞌ ri ɓéeɓ ay soo ɗeefiɗ, te ɓëyí ɗeefiɗ soꞌ mii rii lík, ");
INSERT INTO ndv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ndah mi cépëy feey fa paŋi yee fahaꞌ mi ra, ndaa paŋi yee fahaꞌ ɓëeꞌ wol soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yee fahaꞌ ɓëeꞌ wol soꞌ ra nék daa ri beh⁠ ⁠: mi ɓanti ñak ow yínë di ƴee déŋéen ɗí soꞌ ra, ndaa mi waɗ waa këllë këllë ɓúudé yiin nay túkkíyé ëldúnë rë. ");
INSERT INTO ndv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yee fahaꞌ Baasoꞌ ra daa ri bitih⁠ ⁠: ɓëyí yeel soꞌ mi Koy ka ɓéeɓ te ri gém sëꞌ, ɗi liil pesa na ɗúméh rë, mi këlíɗ ɗí ɓúudé yiin nay túkkíyé ëldúnë rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Wona won Yéesú biti daa ri ñama kolaꞌ sun ɗa, tahte yëwúɗɗë në úlúm-úlúmú hanndal ki wa ");
INSERT INTO ndv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","wonu tih⁠ ⁠: «⁠ ⁠Yaa Yéesú koy Suseef neh hanaa⁠ ⁠? Yen yúhú boffi a yaafi⁠ ⁠! Ɗi wonaꞌ biti ɗi kolaꞌ sun ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Yéfí yee na wonu ron hanndal kon ɗa. ");
INSERT INTO ndv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ow mínéh sëe ɗeefiɗ hém Boffa wol soꞌ ra yejeh ri soo na⁠ ⁠; te soꞌ, may këlíɗ ɓëyí baaha ɓúudé yiin nay túkkíyé ëldúnë rë. ");
INSERT INTO ndv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yonente ya bíníyúté yii beh⁠ ⁠: “Wa ɓéeɓ, Koope ay waa teeɓ.” Ɓëyí síkírëh Boffa ɓéeɓ te keloh woni, ɗeefiɗte soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Baa homay won biti ow ëlíɗté Boffa. Soꞌ fa kolaꞌ Koope na ra kut daa mi ot ɗi. ");
INSERT INTO ndv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí gém sëꞌ liilte pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Daa mi ñama na onaꞌ pes ɗa. ");
INSERT INTO ndv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Caaccee ke ron ñamu maana luufa ra húlúy ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ndaa ɗee man ñama kolaꞌ sun ƴee ra, ɓëyí ñam na ɓéeɓ ii húl. ");
INSERT INTO ndv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Daa mi ñama kolaꞌ sun, na onaꞌ pes ra. Ɓëyí ñam na ñami ƴeh, fay pes faw. Ñama nay mii onee ra daa faan soꞌ⁠ ⁠; may rii onaꞌ nda ɓëewë pes.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Unna won Yéesú ƴaa ra tahte yëwúɗɗë ɓéyrúté unni wa sun, na capuu hanndal ki wa wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí bee mínëꞌ yen yeɗ faani ɗí níi yen ñam⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ɗon ñamuy na faan soꞌ mi Koy-ɓëeꞌ te ɗon hanuy na ñif mi soꞌ, ɗon ii naa liil pesa. ");
INSERT INTO ndv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɓëyí ñam na faan soꞌ te ri han na ñif mi soꞌ, liilte pesa na ɗúméh rë te may rii këlíɗ ɓúudé yiin nay túkkíyé ëldúnë rë. ");
INSERT INTO ndv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Faan soꞌ ñamaɗ kah-kah, ñif mi soꞌ han kah-kah. ");
INSERT INTO ndv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ɓëyí ñam na faan soꞌ te han na ñif mi soꞌ, ɗi pokohte soo na te mi pokohte ɗii na. ");
INSERT INTO ndv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baasoꞌ fa wol soꞌ ra ee pes ɗa, te daa ri tah mi na pes⁠ ⁠; ti ɗaaha nen, ɓëyí ñam na faan soꞌ, daa may tahe ɗi pes. ");
INSERT INTO ndv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ñama kolaꞌ sun-Koo ra daa reeni. Ɓani ƴee húmú ñamu caaccee ke ron húlú rë maduy. Ɓëyí ñam na ñami ƴah, fay pes faw.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Na yëeddëꞌ Yéesú unni ƴaa ra, ɗeef ɗi húmú filiɓ tígë na ɗaguu yëwúɗɗë Koope ra, di Kafarnawum. ");
INSERT INTO ndv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Síkírúu wë Yéesú níi wocce ra, i ow caak di taalibe yi wonu tih⁠ ⁠: «⁠ ⁠Unna won ɗi ra neɓeh keloh⁠ ⁠! Wa ay tahuu ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bi yúhíɗ Yéesú afi biti taalibe ya úlúm-úlúmú wona won ɗi unni ƴaa ra, ɗi won wa tih⁠ ⁠: «⁠ ⁠Baa daa ñogol ɗon a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ɗon ot soꞌ mi Koy-ɓëeꞌ mi saye sun nimil tígë kolaꞌ mi raa, ɗon ay page yih⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruuhi Koope daa na onaꞌ pes. Ow tikkiyay yin. Unna won mi ɗon ra kolaꞌ Ruuhi Koope na, te daa wa na tah ow pes. ");
INSERT INTO ndv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ndaa i ow ɗon na gémúy sëꞌ.⁠ ⁠» Ƴaaha ɓéeɓ, ɗeef Yéesú maañcee yúh ɓëewë gémúy rí rë, a ɓëeꞌ nay rii yaaye ra. ");
INSERT INTO ndv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ɗi ɓaatte won tih⁠ ⁠: «⁠ ⁠Yii baa daa tah mi won ɗon biti ow mínéh sëe ɗeefiɗ, hém Baasoꞌ tahreh ri ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kolaꞌte baaha, ow caak di taalibe yi heguute, wocute ñéerëꞌ a ri. ");
INSERT INTO ndv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tígí daaha, Yéesú won taalibe yi sabboo a ana ya tih⁠ ⁠: «⁠ ⁠A ɗon, ɗon nampi fahuuy saañ neh a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoŋ Peer loffe ri won tih⁠ ⁠: «⁠ ⁠Yíkëe, fun ay ñee tal wah⁠ ⁠? Daa fu na won unna na kúɗ ow pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Fun gémúté, te fun yúhúté biti daa fu Ɓëyí selaa ɗúhëꞌ Koope na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Daa mi tanis ɗon fi sabboo a ana ya neh a⁠ ⁠? Añcaŋ, ow yínë ɗon na seytaane gaan⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ɗeef ɗi wonaꞌ Yudaas koy Simoŋ Iskariyot. Ɗi fi Yudaas, nonaꞌ ri taalibe yi sabboo a ana ya níi, daa ri nay rii yaaye. ");
INSERT INTO ndv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Filoon fi baaha, Yéesú hompe filiɓ Galile na wër⁠ ⁠; ɗi fahaay pay Yúdée ndah ɓaha yi yëwúɗɗë fahuu hawi húl. ");
INSERT INTO ndv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Filiɓ fi baaha ɓéeɓ, bi na leɓoh ndaje ma na homuu yëwúɗɗë dúttë rë, ");
INSERT INTO ndv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","koy-yaayyi wonu ri tih⁠ ⁠: «⁠ ⁠Kolee dee fu saañ ndaje mín Yúdée, nda taalibe ya ɓéeɓ ot iñi éemílëꞌ yë na paŋ fu ra. ");
INSERT INTO ndv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɓëyí fahaꞌ biti yúhú na ɗapeeh paŋi iñi. Fu mín paŋ iñƴee raa kay, feheye níi ɓëy ëldúnë ɓéeɓ yúh rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nagajek, wa fi koy-yaayyi gémúy rí. ");
INSERT INTO ndv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Wahtii soꞌ lahay doom⁠ ⁠; ndaa ɗon, wahtu ya ɓéeɓ wun ɗon na. ");
INSERT INTO ndv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɓëewë míníh rën kaaꞌ, ndaa wa kaaꞌuute soꞌ di yee teeɓaꞌ mi wa biti pagaɗɗi wa ɓosse ra. ");
INSERT INTO ndv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ɗon fi ƴaa tílí ɗon saañ feedin. Soꞌ mi saay, ndah wahtii soꞌ lahay doom.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Filoon fi unnee ke ri ƴah, ɗi tasse Galile daaha. ");
INSERT INTO ndv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sayuu koy-yaayyi yi ndaje min ra, ɗi fi Yéesú nampee naa saañ ndaŋ feey, ow yéeh baaha. ");
INSERT INTO ndv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ɓaha yi yëwúɗɗë homute filiɓ ndaje ma na saamu ri, na meeluu tígë waɗ ɗii homa ra. ");
INSERT INTO ndv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Úlúm-úlúmí ban fi Yéesú misikke filiɓ fi ɓëewë. Ƴee na wonu biti ɗi ɓëyí wunte, ƴee kaaꞌuute na wonu biti ɗi yahaꞌ nuffi ɓëewë yahoo. ");
INSERT INTO ndv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Di filiɓ ƴaaha ɓéeɓ, ow kaañay ɓéyíɗ uni sun, ndah wa helute nuf ɓaha yí yëwúɗɗë në. ");
INSERT INTO ndv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tílëꞌ feeda níi lahte leelaa ra, Yéesú saañce haalte Faam fi gaani Koope na yëeddëꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yëwúɗɗë éemúté ɗee na yëeddëꞌ rí rë, wonu tih⁠ ⁠: «⁠ ⁠Ɗi yúhëꞌ iñi caakki ƴee dih, te ri yooday⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yéesú loffe wa won tih⁠ ⁠: «⁠ ⁠Iña na yëeddëꞌ mí rë ɗúhëey soo na, ɗúhëꞌ Koope fa wol soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɓëyí caŋke paŋi yee neɓaꞌ Koope ra ay yúh nda iña na won mi ra kolaꞌ Koope na, nda mi won woni soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɓëyí wonaꞌ woni, saamɗaꞌ afi ndam. Ndaa soꞌ fa saamaꞌ ndami ɓëeꞌ wol soꞌ ra, mi yéeh fel, mi wonaꞌ kaah. ");
INSERT INTO ndv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mëyíis yeray ron Kootaa a⁠ ⁠? Añcaŋ, ow yínë ɗon na pagay yee won ɗi ra⁠ ⁠! Ɗon fahuu hawi soꞌ húl yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɓëewë wonu ri tih⁠ ⁠: «⁠ ⁠Yébítëh ham ɗo neh a⁠ ⁠? Daa fahaꞌ hawu húl⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mi paŋ kimtaan yínë kut ɗon ɓéeɓ éemúté⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ëlsíi affon⁠ ⁠! Mëyíis nahte ron leji tuŋka. Te yii baa dalaay ɗii na, kolaꞌ níi caacci na. Biti Mëyíis daa nah ron ri, ɗon na pagu ri wuti ƴaha bisa na hílsúu rë, te ñogoleh ron. ");
INSERT INTO ndv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kon ɗon ham kootii Mëyíis, ɗon mín lec kúkëy bisa na hílsúu rëe, ɗon ngaaruu soꞌ yi paƴa paƴ mi ow múlgús bisi baaha ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ngënë ëlí rek ɗon yíppí aattiyaꞌ, lah ëettíyíi kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Filoon fi baaha, i ow di ɓëy Yerusalem wonu tih⁠ ⁠: «⁠ ⁠Bee daa ɓëeꞌ na fahuu hap húl rë saa⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ëlsíi di na wonaꞌ ri sun te ow hégíƴëey. Kélfë yë habuuy kah-kah biti daa ri Buura Koo fal ri ra a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wonuy biti Buura Koo fal ri ra ƴahti ac ɗaa ow ii yúh tígë nay rii kolee ra a⁠ ⁠? Ɓëyí bee nék yen yúhú tígë kolaꞌ ri ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Filiɓ yëeddëꞌí di Faam fi gaana, Yéesú ɓéyíɗté uni sun won tih⁠ ⁠: «⁠ ⁠Ɗon wonu ti ɗon yúhú sëꞌ a tígë kolaꞌ mi ra⁠ ⁠! Yúhí biti nék neɓaay soꞌ neɓoo rek mi acce, ɓëeꞌ mit wëelíyëh rë daa wol soꞌ, te ɗon yíih rí. ");
INSERT INTO ndv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Soꞌ nék mí yúh rí ndah mi kolaꞌ hëbísí, te daa ri wol soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tígí daaha, lahte ɓëewí na fahuu hami, ndaa bi lahay wahtii, ow tíkëy rí yaꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Di filiɓ ƴaaha ɓéeɓ, lahte ɓëewí caakki gémúté rí, wonu tih⁠ ⁠: «⁠ ⁠Buura Koo fal ri ra ac ɗaa ay paŋ kimtaanni luk ƴee paŋ ɓëyí bee ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yee na úlúm-úlúmú ɓëewë sun fi Yéesú rë síitëꞌ rí nuffi fariseŋŋa, ɓani kélfë yí seeƴoh ya yejute i ow di wohoh yi Faam fi gaani Koope hami. ");
INSERT INTO ndv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Lahuu wa ra, Yéesú won ɓëewë tih⁠ ⁠: «⁠ ⁠Mi tallaꞌte hom filiɓ fon níi fíi ƴutuuɗ, mi anti saañ ɗeefri ɓëeꞌ wol soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ay tíl níi ɗon ay soo saam ndaa ɗon ii soo ot, ndah ɗon míníh lah tígë në saañ mi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yëwúɗɗë na wonantuu filiɓ fi wa tih⁠ ⁠: «⁠ ⁠Ɗi ay saye di níi yen míníh nëe lah⁠ ⁠? Ɗi saañ ɗeefri yëwúɗɗë tasaaruu ginni ɓëewí kayya ra neh, ɗi yeel hom dín fë yëeddé ɓëewí kayya ginni ƴaaha a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yee wonaꞌ ri biti ay tíl níi yen ay rii saam ndaa yen ii rii ot, ndah yen míníh lah tígë në saañ ɗi ra, ɗi fahaꞌ won yi na⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bisa míllëꞌ feeda ra daa ri bisa lukki lah solo ra. Yiin fin fa, Yéesú caŋke fíi ɓëewë, ɓéyíɗté uni won tih⁠ ⁠: «⁠ ⁠Ɓëyí sifiroh, aya soo na mi on ɗi han. ");
INSERT INTO ndv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ɓëyí gém soo na, di bíníyúu rí Téerëe, culli mulii na onaꞌ pes ay julli keeñi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ɗi hom woni tígí daaha biti ɓëewë nay rii gémé rë ay liil Ruuhi Koope. Jamanu yi ƴaaha, ɗeef Koope cépírëy Ruuha sun fi ɓëewë gémú rë, ndah ɗeef ɗi teeɓaay ndami Yéesú doom. ");
INSERT INTO ndv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","I ow filiɓ fi ɓëewë keluu wa unni ƴah, wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí bee daa Yonentaa kaah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Lahte ƴi wonu tih⁠ ⁠: «⁠ ⁠Daa ri Buura Koo fal ri ra⁠ ⁠!⁠ ⁠» Ndaa lahte ƴi tahute wonu tih⁠ ⁠: «⁠ ⁠Buura Koo fal ri ra mín ɗúhëꞌ Galile a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bíníyúy Téerëe biti Buura Koo fal ri ra ay coosaanee tali Dawit te ri ay ɗúhée Betleꞌem, gina húmú dék Dawit ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Af Yéesú tahte wonni ɓëewë kéldëey. ");
INSERT INTO ndv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","I ow waa na fahuu hami, ndaa ow tíkëy rí yaꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nimiluu wohoh yi Faam fi gaani Koope húmú wolu ra, kélfë yí seeƴoh ya a fariseŋŋa meelute wa yee tah wa kúrëelúuy Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wohoh ya wonu wa tih⁠ ⁠: «⁠ ⁠Iña won ɓëyí baa ra, ow mësëy wëe won⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseŋŋa wonu wa tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ kúrëelëhté ɗon ɓal a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ɗon olute kélfë mbée fariseŋ yínë gémpé rí ë⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ɓëewë gémú rí rë yíih yin kootii Mëyíis⁠ ⁠! Wa ay alkoh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodem fa non wa fi fariseŋŋa, te húmú pëyíɗté ɗeefri Yéesú rë won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«⁠ ⁠Kootii yen onay yen biti yen daan ow te ɗeefa yen síkíríih rí níi yen yúh yee paŋ ɗi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Kon fu dék Galile ɗo ɓal⁠ ⁠! Kúnsé Téerëe fu saam nda yonente yínë kut waɗtee ɗúhëꞌ Galile raa⁠ ⁠!⁠ ⁠»  ");
INSERT INTO ndv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Filoon fi baaha, wa hasluute suute faam. ");
INSERT INTO ndv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yéesú kolaꞌ daaha, saañce daŋi Ëlíiffë. ");
INSERT INTO ndv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kéy ɓaaɓ fin cúɓ, ɗi nimilte Faam fi gaani Koope, ɓëewë ɓéeɓ ɗeefrute ri. Ɗi tookke na yëedíɗ wë. ");
INSERT INTO ndv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hom homo níi, i ow di yëeddëh yí kootii Mëyíis a i fariseŋ kúrúté ɓelii habuu a ƴaal. Wa tíkúté rí fíi ɓëewë ɓéeɓ, ");
INSERT INTO ndv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","wonu Yéesú tih⁠ ⁠: «⁠ ⁠Ɓahaa, ɓelii bee habuu a ƴaal. ");
INSERT INTO ndv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Te di filiɓ Kootaa, Mëyíis túuƴcé yen tap mani ɓelii bee laꞌ níi rí húl. Ɗo nék, fu won yi na⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(Woni baa ɓéeɓ, wa homu fíirí Yéesú, nda wa mín lah yii yabun wa ri.) Ndaa Yéesú sígímpé, ɓeɓpe kuni yampe na fíis feey. ");
INSERT INTO ndv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bi caguu wa Yéesú na sehu biti ɗi lof wa, ɗi ɓéyíɗté afi won wa tih⁠ ⁠: «⁠ ⁠Ow di ɗon na, bi mësëy bakaaɗ, ɗéɓëe ríi tap.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ɗi antee sígímëet, yampe na fíisëet feey. ");
INSERT INTO ndv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Keluu wa unni ƴah, dalaꞌte ƴee lukuu ɓaha ra, wa sayuu yínë-yínë níi Yéesú a ɓelaa kep daa tasu, ɓelaa caŋke hompe tígë hom ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ɗi ɓéyrëetté afi, won ɓelaa tih⁠ ⁠: «⁠ ⁠Ɓëewë kúrú rë dee ra di yaa ow⁠ ⁠? Kon lahay ɓëyí daana ro waa na a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɓelaa won ɗi tih⁠ ⁠: «⁠ ⁠Lahay, ɓahaa.⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Soꞌ ɓal, mi daanay ro. Fu mín saañ, ndaa kolaꞌte woteh ngana bakaaril.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yéesú wonaat ɓëewë filiɓ Faam fi gaani Koope tih⁠ ⁠: «⁠ ⁠Daa mi niiñi ëldúnë⁠ ⁠; ɓëyí ñee tal soꞌ wocce tíl ñúus, ɗi ay tílé niiña na onaꞌ pesa na ɗúméh rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tígí daaha, fariseŋŋa wonu ri tih⁠ ⁠: «⁠ ⁠Gaaɗ na peleh kukuumi⁠ ⁠! Ow mínéh tah biti fu won kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Wuti mi seedeyiɗ af soꞌ raa, mi won kaah. Mi yúh tígë kolaꞌ mi ra a tígë na saañ mi ra⁠ ⁠; ndaa ɗon, ɗon yíih tígë kolaꞌ mi ra níi púlé tígë na saañ mi ra. ");
INSERT INTO ndv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɗee na aattiyuu ɗon ɗa, homaꞌ olaɗ ow⁠ ⁠; soꞌ mi na aattiyeeh ow. ");
INSERT INTO ndv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ndaa tíl níi mi aattiyaꞌ raa, lah tëhí biti ri kaah ndah funi af soꞌ na neh⁠ ⁠; funi Baasoꞌ fa wol soꞌ ra daa na ñéerúu në. ");
INSERT INTO ndv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kootii ron wonay biti tígí seedeyuun ow ana, ɗeef kaah woo⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kon mi seedeyiɗ af soꞌ, te Baasoꞌ fa wol soꞌ ra seedeyiɗ soꞌ ɓal⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tígí daaha, wa wonu ri tih⁠ ⁠: «⁠ ⁠A boffu dih ɗo⁠ ⁠?⁠ ⁠» Ɗi tahte won wa tih⁠ ⁠: «⁠ ⁠Ɗon yíih sëꞌ, ɗon yíih Baasoꞌ. Ɗon yúh sëꞌ koon, ɗon ay yúh Baasoꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Na won Yéesú unni ƴaa ra, ɗeef ɗi na yëeddëꞌ filiɓ Faam fi gaani Koope, hëbís tígë na ɓekuu sarah ya ra, ndaa ow étɗëy hami, ndah ɗeef wahtii lahay doom. ");
INSERT INTO ndv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yéesú wonil wa tih⁠ ⁠: «⁠ ⁠Mee saañ ɗa ee⁠ ⁠; ɗon ay soo saam ndaa ɗon ay húlée filiɓ bakaaɗɗon. Ɗon míníh lah tígë në saañ mi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tígí daaha, yëwúɗɗë wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Mbaa ri fahaꞌ naadoh daa tah ɗi won biti yen míníh lah tígë na saañ ɗi ra neh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon dékú feey, ëldúníi beh, ndaa soꞌ mi dékéh në, mi dék sun. ");
INSERT INTO ndv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yii baa daa tah mi won ɗon biti ɗon ay húlée filiɓ bakaaɗɗon. Mee ron won ra ee ɗon gémúy biti daa mi raa, ɗon ay húlée filiɓ bakaaɗɗon.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wa meelute ri wonu tih⁠ ⁠: «⁠ ⁠Daa fu wa kon⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mi maañcee ron ri dal won bín fë níi a ɗeh⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mi caakke yii mín míi won sun fon, a yii mín mí ron aattiyaꞌ, ndaa mi léhín ɓëy ëldúnë iña won soꞌ ɓëeꞌ wol soꞌ ra, te ɗi fi ɓëyí baa wonaꞌ kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bi yíih wë biti Yéesú wonaꞌ wa Boffa sun, ");
INSERT INTO ndv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ɗi ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Tíl níi ɗon ɓéyíɗ soꞌ mi Koy-ɓëeꞌ rëe, ɗon ay yúh biti daa mi, te ɗon ay yúh biti ma na koleeh rek mi paŋ yin, ndaa mi léhínëꞌ iña yëedíɗ sëꞌ Baasoꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Te ɗi fi ɓëeꞌ wol soꞌ ra funi ñéerúu, ɗi yeɗɗay soꞌ a af soꞌ, ndah mi dékëꞌ paŋ yee neɓaꞌ ri ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Filiɓ woni iñƴah, i ow caak gémúté rí. ");
INSERT INTO ndv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tígí daaha, Yéesú won yëwúɗɗë gémú rí rë tih⁠ ⁠: «⁠ ⁠Ɗon pokoh unna won mi ron ra raa, ɗeef ɗon taalibe yi soꞌ kaah. ");
INSERT INTO ndv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Hen ɗaaha raa, ɗon ay yúh kaah te kaaf ka ay ron pëkís, ɗon lahaꞌ affon.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun séttí Abraham, fun mësúy hen ñaam⁠ ⁠! Fu wonaꞌ fun biti fun ay lahaꞌ affi fun ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí paŋ bakaaɗ ɓéeɓ, ɗeef ɗi ñaam bakaaɗ. ");
INSERT INTO ndv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te ñaam noneh faam, ndaa koy non faam faraah. ");
INSERT INTO ndv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kon soꞌ mi Koy ka daa mi pëkísë ron raa, ɗon ac ɓëewí lahuute affon kaah. ");
INSERT INTO ndv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi yúhté biti ɗon séttí Abraham ndaa ɗon fahuu hawi soꞌ húl, ndah iña won mi ron ra haaleh affon. ");
INSERT INTO ndv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Soꞌ mi wonaꞌ iña ot mi Baasoꞌ na ra. Ɗon nék, ɗon paguu iña keluu ron boffon na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wa wonu Yéesú tih⁠ ⁠: «⁠ ⁠Abraham daa boffi fun.⁠ ⁠» Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon henun koyyi Abraham kaah koon, tin ɗon ñeyun kotti. ");
INSERT INTO ndv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ndaa ɗon paguy bah, ɗon na anuu fahaꞌ hawi soꞌ húl ndah mi wonaꞌ ron kaaf ka keloh mi Koope na ra. Iña na pagu ron ra, Abraham mësëy wëe paŋ. ");
INSERT INTO ndv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɗon paguu di na pagaꞌ boffon kep.⁠ ⁠» Wa wonu Yéesú tih⁠ ⁠: «⁠ ⁠Fun koyyi píyúu waal neh⁠ ⁠! Fun lahuu baap yínë, te ri Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Koope daa ƴaha Boffon kaah koon, tin ɗon fahaꞌ soꞌ, ndée mi kolaꞌ ɗii na, te daa ri tah mi ac. Neɓaay soꞌ neɓoo rek mi acce, daa ri wol soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yi tah ɗon kélíih woni soꞌ⁠ ⁠? Mi ot na⁠ ⁠: woni soꞌ haaleh affon daa tah. ");
INSERT INTO ndv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Seytaane daa boffon tígí-tígí⁠ ⁠! Paŋ yii neɓaꞌ ɗi fi boffon, neɓaꞌte ron. Dalaana níi a ɗeh, ɗi mëssí saŋku ow saŋkuyo. Ɗi mësëy ñéerëꞌ a kaah, ndah kaah íníh ɗii na. Ɗi home fel raa, ɗi na hélléeh yínë sah. Ɗi pesaꞌ fel, te fel coosaanaꞌ ɗii na. ");
INSERT INTO ndv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ndaa soꞌ mi beh, mi wonaꞌ kaah daa tah ɗon gémúy iña na won mi ɗon ra. ");
INSERT INTO ndv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wa di ɗon na daa mín caŋ won yii nay teeɓee biti mi bakaaɗte⁠ ⁠? Kon mi won kaah raa, yi kaaꞌ ɗon gém iña na won mi ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ɓëyí non ɓëewí Koope, kelaꞌ iña na won ɗi Koope ra. Ndaa ɗon nëníh ɓëewí daa tah ɗon kélíih iña na won ɗi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yëwúɗɗë wonu Yéesú tih⁠ ⁠: «⁠ ⁠Fun wonuy kaah biti nagajek fu heedi ɓëy Samari, te yébítëh daa ham ɗo a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ɗi nampee waa won tih⁠ ⁠: «⁠ ⁠Yébítëh habay soꞌ⁠ ⁠! Soꞌ kay mi yeɗ Baasoꞌ cér⁠ ⁠; ɗon daa yeruy soꞌ cér⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Soꞌ mi saamɗay af soꞌ ndam. Lahte ɓëyí daa na saamiɗ soꞌ ri te daa ri na aattiyaꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí ñee woni soꞌ, ii mëssí húl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Wëerté leegi biti yébítëh daa ham ɗo⁠ ⁠! Fu habaꞌ biti ɗee fu luk ciffi fun Abraham gaan a⁠ ⁠? Abraham húlté, yonente ya húlúté, fantee won biti ɓëyí ñee wonu ii mëssí húl ë⁠ ⁠? Fu tík afu yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mi dëmndëe af soꞌ raa, ay lahee njiriñ mi bih⁠ ⁠? Baasoꞌ kay daa na on soꞌ ndam. Ɗon wonu ti ɗi Koope fon, ");
INSERT INTO ndv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ɗon anutee rii yíih. Soꞌ mi bee mi yúh rí. Mi won biti mi yéeh rí rëe, mi ac feloh ti ɗon nen. Ndaa mi yúh rí, te mi ñeyaꞌ woni. ");
INSERT INTO ndv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Keeñ ciffon Abraham sosse níi sos séentëꞌ rí biti mi ac ayo ra⁠ ⁠; ɗi otte te keeña sosse.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fu olaꞌ Abraham ɗíh, te fu lahay kíil sabay iip (50) doom⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: balaa Abraham límú, daa mi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tígí daaha, wa na píyú i laꞌ ay yeese ri, Yéesú múuƴcé filiɓ ɓëewë, ɗúhté Faam fi gaani Koope. ");
INSERT INTO ndv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Filoon fi baaha, Yéesú hom waal otte ɓëyí límú búumíɗ. ");
INSERT INTO ndv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Taalibe yi meelute ri wonu tih⁠ ⁠: «⁠ ⁠Ɓahaa, bakaaɗɗi ɓëyí bee daa tah ɗi límú búumíɗ mbée bakaaɗɗi boffi a yaafi⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ñeyaay ɗii na, ñeyaay boffi a yaafi na. Ɗon ot ɗi búum, Koope daa fahaꞌ ñeyaꞌ ɗii na, teeɓaꞌ doolii. ");
INSERT INTO ndv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Naꞌa ɓéeɓ, yen warun paŋ légéyí ɓëeꞌ wol soꞌ ra⁠ ⁠; te leŋ Koo elek, ow ii naa mín légéy. ");
INSERT INTO ndv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Homi soꞌ ëldúnë ɓéeɓ, daa may niiñle ɓëewë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kolaꞌ ri woni unni ƴah, Yéesú tuulte feey, túpëlsëꞌté muluuc ma a feey fa, ɗi antee waa leef íllí búumndë, ");
INSERT INTO ndv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","won ɗi tih⁠ ⁠: «⁠ ⁠Paye fu súlmée laahi Silowe.⁠ ⁠» (Iti fi tii Silowe daa wolu wolo.) Búumndë payte dín fë súlmëhté, nimilte yeelte. ");
INSERT INTO ndv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Oluu ri ɓëewë wani dékú rë a ƴee na olu ri merees ɗi na saraatoh ra, wa na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Bee ɓëeꞌ húmú took na saraatoh ra saa⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Lahte ɓëewí wonu tih⁠ ⁠: «⁠ ⁠Yaa ɗi⁠ ⁠!⁠ ⁠» Lahte ƴi wonu tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ, yaa ɗi neh, wa madu mado rek⁠ ⁠!⁠ ⁠» Ɓëeꞌ won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Yaa soꞌ kay⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tígí daaha, ɓëewë meelute ri wonu tih⁠ ⁠: «⁠ ⁠Yi daa wëdís íllú⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ hínú Yéesú rë daa hilsiɗ feey, leeffe íllí sëꞌ antee soo nah mi pay súlmëh laahi Silowe. Mi payte dín fë, mi súlmëhté íllí sëꞌ wërsëhté.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓëewë meelute ri wonu tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ hom dih⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Mi yéeh tígë hom ɗi ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Wa koluu daaha, ɓeyute ɓëeꞌ, kúrúté rí fariseŋŋa na. ");
INSERT INTO ndv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ɗeef Yéesú hilsiɗ feey fa wëdíssé íllí ɓëeꞌ yiin bisa na hílsúu yëwúɗɗë rë. ");
INSERT INTO ndv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Wa fi fariseŋŋa ɓal namutee meel ɓëeꞌ ɗee wërsëꞌ íllí rë. Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗi leef soꞌ feey hilsiɗ íl, mi súlmëhté, mi yíppée yeel.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tígí daaha, lahte fariseŋŋi wonu tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ paŋ yii baa ra mínéh hen ɓëyí Koope daa wol ri, ndah ɗi ñeyay yee won kootii bisa na hílsúu rë.⁠ ⁠» Ndaa lahte ɓëewí wonu tih⁠ ⁠: «⁠ ⁠Bakaaroh mínëꞌ paŋ kimtaanni man ɗee ɗíh⁠ ⁠?⁠ ⁠» Ɗaaha, wonni wa kéldëey. ");
INSERT INTO ndv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Fariseŋŋa meelaatute ɓëeꞌ wonu ri tih⁠ ⁠: «⁠ ⁠A ɗo, fu won yi ɓëeꞌ wëdís íllú rë⁠ ⁠?⁠ ⁠» Ɓëeꞌ won wa tih⁠ ⁠: «⁠ ⁠Ɗi yonente⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Di filiɓ ƴaaha ɓéeɓ, kélfë yí yëwúɗɗë kaaꞌuute gém biti ɓëeꞌ na ot bee ra húmú búumíɗ. Yii baa tahte wa woluute boffi a yaafi, ");
INSERT INTO ndv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","meelute wa wonu tih⁠ ⁠: «⁠ ⁠Won ti ɓëyí bee koohon kaah te ri límú búumíɗ ë⁠ ⁠? Yi tah ɗi na ot leegi kon⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Boffa a yaafa wonu wa tih⁠ ⁠: «⁠ ⁠Yee yúhú fun ɗa biti ɗi koy fun sah-sah, te ri límú búumíɗ kaah. ");
INSERT INTO ndv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yee tah níi ɗi na ot leegi ra nék, fun yíih rí, a fun yíih ɓëeꞌ paƴ ɗi ra ɓal. Méelí rí ɗi teeɓ ron⁠ ⁠! Ɗi kúkëy woo⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Biti wa kaañuy kélfë yí yëwúɗɗë daa tah wa lofaꞌ ɗah, ndah ɗeef wa fi kélfë yí yëwúɗɗë pokute biti ɓëyí won ow biti Yéesú daa Buura Koo fal ri ra, ay líkú tígë na ɗaguu yëwúɗɗë Koope ra. ");
INSERT INTO ndv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yii baa daa tah wa won biti wa meel ri, ɗi kúkëy neh. ");
INSERT INTO ndv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Fariseŋŋa dëekëetúté ɓëeꞌ húmú búum ɗë, wonu ri tih⁠ ⁠: «⁠ ⁠Fun yúhúté biti ɓëeꞌ na wonaꞌ fu ra bakaaroh⁠ ⁠! Wone kaah di tii Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɗi ƴaha bakaaroh mbée bakaaroh neh ɓéeɓ, mi yéeh yin na. Yee yúh mí rë biti mi húmú búumíɗ, mi yeelte leegi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tígí daaha, wa meelute ri wonu tih⁠ ⁠: «⁠ ⁠Ɗi paŋ ɗo yih⁠ ⁠? Ɗi hen ɗíh níi paƴce íllú⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ɓëeꞌ won wa tih⁠ ⁠: «⁠ ⁠Mi húmú wonte ron baaha, ɗon kaaꞌuute síkírëh. Ɗon fahuu biti mi wonaat ɗon baaha yih⁠ ⁠? Ɗon fahuu hen taalibe yi man bitih⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tígí daaha, wa solsuute ri anutee rii won tih⁠ ⁠: «⁠ ⁠Ɗo kay, daa fu taalibii ɓëyí bah⁠ ⁠! Ndaa fun, fun taalibe yi Mëyíis. ");
INSERT INTO ndv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Fun yúhúté biti Koope wonte a Mëyíis, ndaa ɗi fi bah, fun lukki yíih tígë kolaꞌ ri ra sah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ɓëeꞌ tahte won wa tih⁠ ⁠: «⁠ ⁠Ɗon yíih tígë kolaꞌ ɓëeꞌ rë, te ri paƴce íllí sëꞌ⁠ ⁠! Baa daa yee téƴ af ra⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yen yúhúté biti Koope na taheh ɗaŋ bakaaroh, ndaa ɓëyí neeh ri, ñee woni te paŋ yee fahaꞌ ri raa, ɗi tah ɗaŋi. ");
INSERT INTO ndv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Biti ow paƴce íllí ɓëyí límú búumíɗ níi na yeel, kéllúy⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kon ɓëeꞌ paŋ yii baa ra Koo daa wol ri⁠ ⁠; henay baa koon ɗi mínéh paŋ kimtaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Fariseŋŋa wonu ri tígí daaha tih⁠ ⁠: «⁠ ⁠Límúu fú níi a ɗeh, fu mëssí hen bakaaroh, antee won daa fay fun yëeddé ë⁠ ⁠?⁠ ⁠» Wa koluu daaha, líkúté rí tígë na ɗaguu ra, ɗúhrúté rí ëssín. ");
INSERT INTO ndv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kelaꞌ Yéesú biti fariseŋŋa líkúté ɓëeꞌ tígë na ɗaguu ra, ɗi ɗeefiɗte ri, won ɗi tih⁠ ⁠: «⁠ ⁠Fu gémpé Koy-ɓëeꞌ ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ɓëeꞌ won ɗi tih⁠ ⁠: «⁠ ⁠Teeɓ soꞌ ri ɓahaa, nda mi gém ɗí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu otte ri, daa ri na won ɗoo na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tígí daaha, ɗi ƴekke fíi Yéesú na jaamiyoh ri, won tih⁠ ⁠: «⁠ ⁠Yíkëe, mi gémpé rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yéesú antee won tígí daaha tih⁠ ⁠: «⁠ ⁠Mi ac aattiyaꞌ feey fi beh, nda búumíɗɗë yeel, te ɓëewë na yeelu ra yíssëh búumíɗ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lahte fariseŋŋi húmú daaha, keluu wa unni ƴah, wa meelute Yéesú wonu ri tih⁠ ⁠: «⁠ ⁠Fun i búumíɗ fun ɓal a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon ƴahun búumíɗ koon, tin ɗon ii lah bakaaɗ⁠ ⁠; ndaa ɗon wonu ti ɗon olu na, yii baa daa tah bakaaɗɗon dék ɗon na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yéesú tíkké won wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí ñeyaay ílí gélgí harra, anti ɗara buut ñeyaa na, ɓëyí baa lohoh, ɗi banndi. ");
INSERT INTO ndv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ndaa ɓëyí haalaa gélgë ílë, ɗeef daa ri níirëhí harra. ");
INSERT INTO ndv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ɗi fi bah, wohohi yuba ay rii kúnsíɗ, te harra lahaꞌ ri ra ay yúhsëꞌ una. Ɗi ay ñee tii yi wa dëek wë, ɗúhíɗ wë ëssín. ");
INSERT INTO ndv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ɗi ɗúhíɗ wë ɓéeɓ níi woc raa, ɗi këllëh, harra ñee tali, bi yúhsúu wë uni. ");
INSERT INTO ndv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wa ii ñee tal ɓëyí wa yíih rí nék⁠ ⁠; wa ay rii hegee hegoo kay, ndah wa yíihsíih una⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yéesú ñeyaꞌte wa léehí bah, ndaa wa yíih yee fahaꞌ ri waa won ɗa. ");
INSERT INTO ndv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tígí daaha, Yéesú wonaat wa tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: daa mi ílí gélgí harra. ");
INSERT INTO ndv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɓëewë húmú këllúu sëꞌ dee ra ɓéeɓ, húmú i lohoh a i banndi, yii baa tahte níi harra síkírúuy wë. ");
INSERT INTO ndv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Daa mi ílë. Ɓëyí ñeyaꞌ soo na haal, ay múc⁠ ⁠; ɗi ay mín haal, ɗi ɗúhé, ɗi lah yii pesaa ri faraah. ");
INSERT INTO ndv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Lohoh ayaꞌ loh, bëem a saŋku kut. Soꞌ nék, mi ac biti ɓëewë pes, wa pes pesi neɓpe. ");
INSERT INTO ndv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Daa mi níirëhí kah-kah fa. Níirëh kah-kah hom garaꞌ ñíiní garoo harri na. ");
INSERT INTO ndv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Súrgë nék, ɗi lahaay harra⁠ ⁠; ɗi níirëh kah-kah neh. Ɗi ole gúmú aye rek, ɗi hegoh, gúm fë yejoh sun fi harra, haslaꞌ yuba. ");
INSERT INTO ndv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Súrgíi baa ay mínée hen ɗaaha, ndah ɗi séentëh hélíis légéyí kut, harra tahay ɗi koloh. ");
INSERT INTO ndv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Daa mi níirëhí kah-kah fa. Di yúhëꞌ sëꞌ Baasoꞌ mi yúhté rí, soꞌ mi yúhëꞌ harri soꞌ ɗaaha wa yúhúté sëꞌ. Te af wa ay tah mi yeraꞌ ñíin sëꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mi lahte harri kayyi íníh gélgí beh, te mi waɗtee waa níiɗ ɓal⁠ ⁠; wa ay yúhsëꞌ un soꞌ, wani ƴee boollaꞌ ɓéeɓ hen yup yínë, níirëhë hen yínë. ");
INSERT INTO ndv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","May yeraꞌ ñíin sëꞌ, mi liilaat ɗi. Yii baa daa tah Baasoꞌ fahaꞌ soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ow mínéh ɓek ñíin sëꞌ feey, daa mi mín ɗíi yeraꞌ. Daa mi mín ɗíi yeraꞌ, daa mi mín ɗíi liilaat. Baasoꞌ túuƴ sëꞌ yii baaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Unna won Yéesú ƴaa ra tahte yëwúɗɗë kéldúuy won. ");
INSERT INTO ndv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ow caak waa na wonu tih⁠ ⁠: «⁠ ⁠Nagajek ɗon síkírúu wa⁠ ⁠? Bee yébítëh daa ham ɗi bee ra a⁠ ⁠? Bee yulkiɗ bee ra a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ndaa lahte ɓëewí na wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí yébítëh daa ham ɗi na woneeh ɗeh⁠ ⁠! Yébítëh mín wëdís íl búumíɗ ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Feedi yëwúɗɗë, bee na nérsúu jébëlë jébëlú Koope Faam fi gaana ra lahte. Feedi baa húmú Yerusalem jamanii sosa. Jamanii baaha filiɓ feeda, ");
INSERT INTO ndv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yéesú na tílëesëh tígë në wonuu Mbaar mi Salomoo di filiɓ Faam fi gaana ra. ");
INSERT INTO ndv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tígí daaha, yëwúɗɗë ayute gíiwúté rí, wonu ri tih⁠ ⁠: «⁠ ⁠Fay home dee fu kúné affi fun níi kirih⁠ ⁠? Daa fu ƴaha Buura Koo fal ri ra raa, won fun baaha⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Yee meelu soꞌ ɗon ɗa, mi húmú wonte ɗon ɗi, ndaa ɗon gémúy sëꞌ. Añcaŋ, iña na paŋ mi di tii Baasoꞌ ra seedeyiɗte soꞌ, ");
INSERT INTO ndv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ndaa ɗon gémúy sëꞌ, af biti ɗon nëníh harri soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Harri soꞌ yúhsúu un soꞌ⁠ ⁠; soꞌ mi yúh wë, te wa ñeyuu tal soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","May waa on pesa na ɗúméh rë. Mii waa mëssí ñak, te ow mínéh wëe naaf yaꞌ soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baasoꞌ daa déŋéen sëꞌ wë, te daa ri lukki gaan ɓéeɓ. Ow mínéh naaf yin yaꞌ Baasoꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Funi Baasoꞌ daa lígínúu yínë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wonaꞌ Yéesú uni bah, yëwúɗɗë yabaatute na píyú laꞌ ay rii bëemé, ");
INSERT INTO ndv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Mi paŋke iñi wunni caakki Baasoꞌ daa nah soꞌ wa. Yii bih di iñƴah daa tah ɗon na fahuu bëemí sëꞌ a laꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wa lofute ri wonu tih⁠ ⁠: «⁠ ⁠Fun fahuuy hawu húl biti fu paŋ yin wun, ndaa biti fu solte Koope. Fu ow kut, fu na anti tík afu Koope a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Bíníyúté filiɓ téeríi kootii ron biti Koope won tih⁠ ⁠: “Ɗon i koope.” ");
INSERT INTO ndv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yee won Téerëe rë ow mínéh ríi nís maan⁠ ⁠? Ɓëewë Koope yuliɗ woni waa na ra, ɗi wonaꞌ wa biti wa i koope neh a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","A soꞌ fa Baasoꞌ fal soꞌ, wol soꞌ ëldúnë rë, ɗon wonuu biti mi solaꞌ Koope soloo ɗíh di yee wonaꞌ mi biti mi Koy Koope ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Hena biti mi pagay yee nah soꞌ Baasoꞌ raa, ngënë gémí sëꞌ⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ndaa mi paŋ wa raa, wuti ɗon gémúy iña na won mi raa sah, gémí iña na paŋ mi ra book, nda ɗon ham affon biti Baasoꞌ ee soo na, te mi ee ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wonaꞌ Yéesú unni ƴah, wa yabaatute na fahuu hami, ndaa ɗi fússé wë. ");
INSERT INTO ndv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yéesú kolaꞌ dah sayilte hatni yíníi laahi Yurdeŋ, tígë në húmú bëtsëꞌSaŋ Batis ɓëewë rë, ɗi hompe daaha. ");
INSERT INTO ndv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","I ow caak ɗeefute ri daaha. Ɓëewë na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Kimtaan yínë sah Saŋ pagay ri, ndaa iña won ɗi sun fi ɓëyí bee ra ɓéeɓ kaah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","I ow caak gémúté Yéesú daaha. ");
INSERT INTO ndv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Húmú lahaꞌ ɓëyí keente jér hínú Lasaar. Ɗi húmú dék Betani, ɓani koy-yaayyi ɓeleɓ Mari a Martaa. Mari daa ɓelaa nay túmé laakkoloña kotti Yíkëe, an waa moos a fen fi ra. ");
INSERT INTO ndv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Koy-yaayyi ɓeleɓɓi ana ya wolute ow woni Yíkëe biti kooji jéríɗ. ");
INSERT INTO ndv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kelaꞌ ɗi fi Yéesú baaha, tígí daaha ɗi won tih⁠ ⁠: «⁠ ⁠Jérí Lasaar jér húlëe neh⁠ ⁠; Koo ay ñeye na teeɓaꞌ gaanaa ki ndami⁠ ⁠; hen ɗaaha raa, ndami soꞌ mi Koy Koope yúhú.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yéesú húmú kooji Martaa, Mari a Lasaar. ");
INSERT INTO ndv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Di filiɓ ƴaaha ɓéeɓ, kelaꞌ ri biti Lasaar jéríɗ ɗë, ɗi hompe tígë hom ɗi daaha ra níi hente waal ana, ");
INSERT INTO ndv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ɗi antee won taalibe yi biti ɓani wa ñéerëꞌ nimil Yúdée. ");
INSERT INTO ndv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Taalibe yi wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, maañay-maañay rek fu na fahuu bëem a laꞌ dín fë, fan naa fahaꞌ nimil a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Naꞌ homaꞌ wahtu sabboo a wahtu ana neh a⁠ ⁠? Ɓëyí tíl naꞌ ii kabinoh ndah ɗi ot kotti na niiñi feey fi beh. ");
INSERT INTO ndv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ɓëyí tíl ñúus nék ay kabinoh ndah niiña íníh ɗii na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Filoon fi bee wonaꞌ ri unni ƴaa ra, ɗi ɓaatte won wa tih⁠ ⁠: «⁠ ⁠Kooji yen Lasaar neeꞌte, ndaa may pay mi yúun ɗí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Taalibe yi wonu ri tih⁠ ⁠: «⁠ ⁠Yíkëe, ɗi neeꞌ neeꞌo saa⁠ ⁠? Kon ɗi ay wah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Taalibe ya habuu biti rek Yéesú won wa woni neeꞌ pëní, ɗeef ɗi won wa biti Lasaar húl húlë. ");
INSERT INTO ndv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tígí daaha, Yéesú míllëꞌ wëe won tih⁠ ⁠: «⁠ ⁠Lasaar húlté. ");
INSERT INTO ndv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ɗon tahute keeñ soꞌ sosse di yee ɗeefay soꞌ ri dín fë rë. Di lahaꞌ ri ɗaaha daa nay tahe ɗon gém. Këlíi yen lah ɗii na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tígí daaha, Toomaa fa na dëekúu Síisë rë won taalibe yi kayya tih⁠ ⁠: «⁠ ⁠Yen ɓal yen saañ húlé a kélfíi yen⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tílúu Yéesú a taalibe yi níi wa tíimúté gina ra, ɗi kelohte biti Lasaar húlté níi neeꞌte waal iniil feey. ");
INSERT INTO ndv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani wulaay a Yerusalem⁠ ⁠; hanndal ki wa waɗti hena kilomet éeyë. ");
INSERT INTO ndv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","I yëwúɗ caak ayute yérí Martaa a Mari na mësɗú wë húlí koy-yaafi wa. ");
INSERT INTO ndv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kelaꞌ Martaa biti Yéesú ee ac ɗa, ɗi saañce téebílëhí⁠ ⁠; ndaa Mari tasse faam. ");
INSERT INTO ndv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Teeꞌaꞌ Martaa a Yéesú rë, ɗi won ɗi tih⁠ ⁠: «⁠ ⁠Fu homa dee koon Yíkëe koy-yaasoꞌ húléh. ");
INSERT INTO ndv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ndaa mi yúhté biti níi a ɗeh, yii fu ɗaŋ ɗi Koope ɓéeɓ, ɗi ay roo rii on.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Koy-yaafu ay koloh ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaa won ɗi tih⁠ ⁠: «⁠ ⁠Mi yúhté biti ɗi ay koloh yiin nay kolee ɓëewë ɓúudé rë biti ëldúnë túkkí.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi na këlíɗ ɓëewë ɓúudé, daa mi na on wa pes. Ɓëyí gém soo na wuti ɗi húl rëe sah, ɗi ay pes⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","te ɓëyí në pes, gémpé sëꞌ, ii mëssí húl. Fu gémpé baaha a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martaa won tih⁠ ⁠: «⁠ ⁠Íi Yíkëe⁠ ⁠! Mi gémpé biti daa fu Buura Koo fal ri ra, Koy Koope fa húmú wonu biti daa nay aye ëldúnë rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Filoon fi wonni ƴah, Martaa saañce dëegí Mari koy-yaafi, mëddëꞌté rí won ɗi tih⁠ ⁠: «⁠ ⁠Yëeddëhë acce, te ri won fu ac fu tiil ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kelaꞌ Mari woni bah, ɗi yíppée koloh saañce téebílëhí Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Wahtii baa ɗeef Yéesú haalay gina doom, ɗi húmú lís tígë teeꞌuu ɓani Martaa ra. ");
INSERT INTO ndv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yëwúɗɗë húmú faam fa na mësɗú Mari ra, oluu wa Mari yíppée koloh na ɗúh faam fa, wa ñeyute tala. Wa habuu biti ɗi saañ looy luuyin. ");
INSERT INTO ndv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Lahaꞌ Mari tígë hom Yéesú níi ri otte ri ra, ɗi yeɗɗohte kotta feey, won ɗi tih⁠ ⁠: «⁠ ⁠Fu homa dee koon Yíkëe koy-yaasoꞌ húléh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Olaꞌ Yéesú Mari na foŋ, ɓëewë ñéerúu a ri ra na fogu ɓal ra, keeña ɗúmpé ces, afa kúnëhté, ");
INSERT INTO ndv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ɗi meelte wa won tih⁠ ⁠: «⁠ ⁠Ɗon ɗapuu ri dih⁠ ⁠?⁠ ⁠» Ɓëewë wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, aye fu ot.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yéesú yampe na looy. ");
INSERT INTO ndv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tígí daaha, yëwúɗɗë na wonu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Ëlí di húmú fahaꞌ ri ri kan⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ndaa lahte ƴi na wonu waa na tih⁠ ⁠: «⁠ ⁠Ɗi fa paƴ íllí búumndë rë, ɗi mínéh kaaꞌ Lasaar húl koon a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Keeñ Yéesú ɗúmëetté ces, ɗi lahte luuyin. Luuya, kili kúnúu a laꞌ gaan. ");
INSERT INTO ndv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ɗi won ɓëewë tih⁠ ⁠: «⁠ ⁠Píníŋí laꞌa⁠ ⁠!⁠ ⁠» Martaa koy-yaafi húlëhë won ɗi tih⁠ ⁠: «⁠ ⁠Ɓúudé fë waɗtee yah Yíkëe, hente waal iniil woteh, ɗi ee deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Mi wonay ro ri wono a⁠ ⁠? Fu gém soo na raa, fay ot ndami Koope.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tígí daaha, laꞌa píníŋúté, Yéesú ɓéyíɗté afi, yeelte sun-Koo won tih⁠ ⁠: «⁠ ⁠Baap, mi na sím ɗë di yee tahaꞌ fu ɗaŋi soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mi yúhté biti wahtii ɗagaa mi ro ɓéeɓ fu tahiɗ soꞌ, ndaa fu ot mi won ɗi sun, ɓëewí ƴee gíiwú sëꞌ ƴee ra daa tah, nda wa gém biti daa fu wol soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wocaꞌ ri woni baa ra, ɗi ɓéyíɗté uni sun won tih⁠ ⁠: «⁠ ⁠Lasaar, ɗúhé deh⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasaar fa húmú húl rë ɗúhté, kotta, yaꞌ ya a afa ɓéeɓ líiwúté boy. Yéesú won tígí daaha tih⁠ ⁠: «⁠ ⁠Nísí boyya faana ɗon yeris ɗi tíl.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ow caak di yëwúɗɗë húmú faam Mari te olute iña na paŋ Yéesú rë, gémúté ɗii na. ");
INSERT INTO ndv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ndaa i ow waa na payute olute fariseŋŋa, ɓíllúté wë iña paŋ ri ra. ");
INSERT INTO ndv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tígí daaha, kélfë yí seeƴoh ya a fariseŋŋa dëekúté ɓëy këemí gaani yëwúɗɗë ɓéeɓ, wonu tih⁠ ⁠: «⁠ ⁠Yen ay hene ɗíh ɓal⁠ ⁠? Ɓëyí bee ee paŋ kimtaanni caakke ra déꞌ⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yen took yen olsee ri page iñƴeh, ɓëewë ɓéeɓ ay gém ɗii na, te ɓëy Rom ay koloh ɗakaƴaꞌ Faam fi gaani Koope a heedi yen⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Lahte ɓëyí hínú Kayif waa na, kíilí baaha ɗeef daa ri húmú seeƴohi gaana, won wa tih⁠ ⁠: «⁠ ⁠Yin íníh affon⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ɗon yíih biti ow yínë kut ñak ñíiní ndah ɓëewë, daa gén biti heedi yëwúɗɗë ɓéeɓ saŋku a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yee won ɗi baa ra kolaay ɗii na nék. Kíilí baaha, bi daa ri húmú seeƴohi gaana, Koope daa wonɗoh ri ɗaaha teeɓaꞌi biti Yéesú ay húlíɗ heedi yëwúɗɗë. ");
INSERT INTO ndv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Te ri ii teem húlídí yëwúɗɗë doŋ, ɗi ay húllé koyyi Koope ɓéeɓ, ɗi négírëꞌ ƴee hasluu ra, wa hen yínë. ");
INSERT INTO ndv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kolaꞌte yiin fin fa, kélfë yí yëwúɗɗë habute biti wa ay hap Yéesú húl. ");
INSERT INTO ndv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yii baa tahte ɗi wocce haal filiɓ fi yëwúɗɗë. Ɗi kolohte saañce waal luufa di gina na wonuu Efarayim ra, ɗi hompe daaha a taalibe yi. ");
INSERT INTO ndv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Leɓaꞌ Paagi yëwúɗɗë rë, ow caak di ɓëy gina koluute na suu ɓukutoh a sehi feeda Yerusalem. ");
INSERT INTO ndv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wa homu filiɓ Faam fi gaana na saamu Yéesú, na meelantuu filiɓ fi wa wonu tih⁠ ⁠: «⁠ ⁠Ɗi ayoh feeda aa ɗi ayoh neh⁠ ⁠? Ɗon wonu yi na⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kélfë yí seeƴoh ya a fariseŋŋa nahuute wonu tih⁠ ⁠: «⁠ ⁠Ɓëyí yúh tígë hom ɗi ra, teeɓaa ri, ɗi habu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Waal pëenë balaa feedi Paaga, Yéesú kolohte saañce Betani, tígë dék Lasaar fa ɗi húmú këlíɗ ɗí ɓúudé rë. ");
INSERT INTO ndv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lahaꞌ ri daaha ra, ɗi pagirute ñam. Martaa daa na húmú norsaꞌ ñama. Lasaar húmú non ɓëewë boku a Yéesú loon ra. ");
INSERT INTO ndv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari nampee ɓeɓ bútéel laakkoloñ, ƴi yugusuu naarde kah-kah te kofeelte, bi mitte genwal líitër, yíinté wë kotti Yéesú, na an waa moos a fen fi. Faam fa ɓéeɓ líiwëlsëꞌté a ngedi laakkoloña. ");
INSERT INTO ndv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yudaas Iskariyot, ow di taalibe yi Yéesú, bee míllëꞌ ríi yaay ra, won tígí daaha tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«⁠ ⁠Laakkoloñi ƴee yaayeeh hélíis caak koon cadum fa yeru ñëkíɗɗë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yee won ɗi baa ra, ɗi wonɗay ri ñëkíɗɗë déꞌ⁠ ⁠! Biti ri lohoh te daa ri yef keesi wa, ɗi núhëꞌ në tílé sohle yi daa tah. ");
INSERT INTO ndv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yéesú won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Baale jaambura afi⁠ ⁠! Ɗi waaƴ hacadi soꞌ daa tah ɗi yef wa níi a ɗeh. ");
INSERT INTO ndv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ñëkíɗ ii koloh filiɓ fon⁠ ⁠; ndaa soꞌ mi bee mii hom filiɓ fon dee faraah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","I ow caak di yëwúɗɗë keluu wa biti Yéesú ín Betani ra, wa suute dín fë. Af ɗi neh doŋ daa kúɗ wë në, ndaa olaalohi Lasaar fa ɗi këlíɗ ɗí ɓúudé rë. ");
INSERT INTO ndv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tígí daaha, kélfë yí seeƴoh ya habute biti Lasaar ay hawu húl ɓal, ");
INSERT INTO ndv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ndah af ɗi tahte yëwúɗ caak helute wa, gémúté Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kéy fín fë, ɓëewí caakka húmú ayu feedi Paaga ra keluute biti Yéesú ee ac Yerusalem ra. ");
INSERT INTO ndv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wa saamute soor-soor, ɗúhúté gina na téebílúu rí, ɓéyrúté unni wa sun na njooɓu ri wonu tih⁠ ⁠: «⁠ ⁠Oosaanaa⁠ ⁠! Koo-Yíkëe barkela ɓëeꞌ ɗi wol ri ra⁠ ⁠! Koo barkela buuri Israyel⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ɗeef Yéesú húmú saampe cúmbúr mbaam. Ɗi yaagohte sun ti di bíníyúu rí Téerëe bitih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«⁠ ⁠Ngënë néekíñíi, ɗon fi ɓëy Siyoŋ⁠ ⁠! Ëlí⁠ ⁠! Buuron ee ac ɗa, yaagoh cúmbúr.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Filiɓ fi iñƴaaha ɓéeɓ, taalibe ya húmú yíih iti fi wa⁠ ⁠; ndaa tílëꞌ níi Koope teeɓaꞌte ndami Yéesú rë, nuffi wa onte wa biti yee húmú bíníyú Téerëe rë won sun fi, te ri lahaꞌ ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ɓëewë húmú a Yéesú na won ɗi Lasaar ɗúh nuŋa këlíɗté rí ɓúudé rë, ɓíllúté yee olu wa ra. ");
INSERT INTO ndv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ɗaaha, ow caak keluute biti Yéesú paŋke kimtaani bah, wa ayute téebílëhí. ");
INSERT INTO ndv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tígí daaha, fariseŋŋa na wonantuu filiɓ fi wa tih⁠ ⁠: «⁠ ⁠Yen míníh yin na⁠ ⁠! Ɓëewë ɓéeɓ ñeyuu tala⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ɓëewë ayu feeda Yerusalem jaamiyohi Koope ra, lahte Gerekki húmú filiɓ fi wa. ");
INSERT INTO ndv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wa leɓuute Fílíp fi ɓëy Betsaydaa fa hom Galile ra, wonu ri tih⁠ ⁠: «⁠ ⁠Ɓahaa, fun fahuu oli Yéesú koon.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fílíp payte wonte Anndere baaha, wa ɓéeɓ ana ñéerúuté léhíní Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Wonuu wa ri baa ra, Yéesú won wa tih⁠ ⁠: «⁠ ⁠Wahtaa nay teeɓee Koope ndami soꞌ mi Koy-ɓëeꞌ rë lahte. ");
INSERT INTO ndv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mee ron won kaaf ka ra ee⁠ ⁠: pep bele teem pep bele kep biti ñíinë haaleh feey. Ndaa ñíinë haal feey raa ay ɗúhíɗ pep caak. ");
INSERT INTO ndv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ti ɗaaha nen, ɓëyí pokoh ñíiní ay rii ñak⁠ ⁠; ndaa ɓëyí kaaꞌ pokohi ñíiní ëldúnë fi beh ay lah pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɓëyí hen súrgíi sëꞌ ñeya tal soꞌ⁠ ⁠; te tígí hom mi, ɗi ay home na ɓal. Ɓëyí hen súrgíi sëꞌ, Baasoꞌ ay rii ɓéyíɗ. ");
INSERT INTO ndv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«⁠ ⁠Tígë homaꞌ mi bee ra, af soꞌ kúnëhté níi mi yéeh yii wona mi⁠ ⁠! Mbaa may wone Baasoꞌ biti sëmlëꞌ sëꞌ wahtii coono fa na saañ mii pese bee ra neh⁠ ⁠? Ndaa coono fi baa daa tah mi ac feey nék⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kon Baap, teeɓee ndamu⁠ ⁠!⁠ ⁠» Tígí daaha, un ɗofohte sun won tih⁠ ⁠: «⁠ ⁠Mi teeɓpe ɓëewë ndami soꞌ níi wocce, te may waa rii teeɓaat.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ɓëewë húmú daaha keluu una ra wonu tih⁠ ⁠: «⁠ ⁠Yaa híníŋ⁠ ⁠!⁠ ⁠» Lahte ƴi wonu tih⁠ ⁠: «⁠ ⁠Malaaka daa won ɗii na⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ndaa Yéesú won wa tih⁠ ⁠: «⁠ ⁠Uni baa wonɗuy soꞌ, wonɗu ɗon⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wahtaa waɗti aattiyuun ëldúnë rë lahte⁠ ⁠; kélfëe hom afa ra ay líkú leegi. ");
INSERT INTO ndv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te soꞌ, mi ɓéyrú mi paaꞌ feey fa sun raa, may héc ɓëewë ɓéeɓ soo na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wonee ke Yéesú bah, ɗi teeɓaꞌ ɗee nay rii húlée rë. ");
INSERT INTO ndv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ɓëewë wonu ri tih⁠ ⁠: «⁠ ⁠Yee yoodu fun téeríi kootii yen ra biti Buura Koo fal ri ra ay pese peso faraah. Kon fu wonaꞌ biti Koy-ɓëeꞌ ay keru sun ɗíh⁠ ⁠? Koy-ɓëeꞌ fë wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Niiña ee filiɓ fon ndaa ri tallaay yin caak. Kon tílí niiña bee homaꞌ ri ɗon na bee ra, toñeh ñúusë beetti ron, ndah ɓëyí tíl ñúus yéeh tígë na saañ ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gémí niiña bee homaꞌ ri filiɓ fon ɗa, nda ɗon hen ɓëy niiña.⁠ ⁠» Wonaꞌ Yéesú iñƴaa níi wocce ra, ɗi hécëhté, ɗapohte wa. ");
INSERT INTO ndv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kimtaanna paŋ Yéesú fíi ɓëewë rë ɓéeɓ, taheh wa gém ɗí. ");
INSERT INTO ndv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yee húmú won yonente Isayii ra lahaꞌte ɗah. Ɗi húmú won tih⁠ ⁠: «⁠ ⁠Yíkëe, daa gém yee wonu yen ra⁠ ⁠? Yíkëe, fu teeɓ ɓídí yaꞌu wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Isayii wonte yee tah ɓëewë míníh gém rë, won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«⁠ ⁠Koope búumílté wë, súhílté keeññi wa, toñeh wa ay ole, keeññi wa ay kúnsée ndín wa lof pesaɗ, mi paƴ wa yee homuu wa ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayii húmú wonaꞌ Yéesú bín fë, ɗeef ɗi séenté ndami. ");
INSERT INTO ndv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Filiɓ fi ƴaaha ɓéeɓ, kaaꞌeeh ow caak di kélfë yí yëwúɗɗë gémúté Yéesú. Ndaa bi helu wa nuf fariseŋŋa na, wa kaañuy rii teeɓaꞌ toñeh wa ay líkú tígë na ɗaguu yëwúɗɗë Koope ra, ");
INSERT INTO ndv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ndah biti ow daa kaña wa, daa génël wë biti Koope daa kaña wa. ");
INSERT INTO ndv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yéesú ɓéyíɗté uni won tih⁠ ⁠: «⁠ ⁠Ɓëyí gém soo na, gémëy soo na doŋ, ɗi gémpé ɓëeꞌ wol soꞌ ra ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɓëyí ot soꞌ, ɗeef otte ɓëeꞌ wol soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Soꞌ mi ac ëldúnë hawaanri ɓëewë, nda ɓëyí gém soo na dékéeh ñúusë. ");
INSERT INTO ndv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ɓëyí keloh woni soꞌ te ri ñeyeh na, daa may ri daane neh, ndah mi ac sëmlëꞌí ɓëy ëldúnë ndaa daani wa neh. ");
INSERT INTO ndv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ɓëyí fahaay soo ot te kaaꞌaꞌte keloh woni soꞌ, iña won mi ra nay rii aattiyee yiin nay túkkíyé ëldúnë rë. ");
INSERT INTO ndv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nagajek, mi kolaay koloo rek mi na won, Baasoꞌ fa wol soꞌ ra daa túuƴ sëꞌ won iña yëeddëꞌ mí rë. ");
INSERT INTO ndv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Te mi yúhté biti yee túuƴëꞌ rí rë daa na onaꞌ pesa na ɗúméh rë. Ti ɗaaha nen, iña na won mi ra, mi wonaꞌ wa ti di nahaꞌ soꞌ wa Baasoꞌ nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bisa míllëꞌ balaa Paagi yëwúɗɗë rë lahte. Yéesú yúhté biti wahtaa waɗ ɗii koloh ëldúnë, ɗi ɗeefiɗ Boffi ra lahte. Ɗi mëssí fahaꞌ ɓëewée ké rí nay rii hele feey fa ra fahoo. Te ri teeɓpe wa ɗee fahaꞌ ri wa níi tígí teem fahaꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yéesú a taalibe yi homu reer, ɗeef Seytaanaa ɓekke Yudaas koy Simoŋ Iskariyot nufa nay rii yaayee Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yéesú yúhté biti Boffi tíkké iña ɓéeɓ yaꞌi, ɗi yúhté biti ɓal ɗi kolaꞌ ɗii na te ri ay nimile ɗii na. ");
INSERT INTO ndv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ɗaaha, ɗi kolohte loona, níssé búubí, ɓeɓpe ndíimú moosaa pokke kinohi, ");
INSERT INTO ndv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","antee ɓeɓ if, túmpé muluɓ, ñeete taalibe yi na, na hos kotti wa⁠ ⁠; bi ri hosiɗ ɗi kotti ɓéeɓ, ɗi moosiɗ ɗi wa a ndíimëe pok ɗi kinohi ra. ");
INSERT INTO ndv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Lahaꞌ ri Simoŋ Peer na ra, Peer won ɗi tih⁠ ⁠: «⁠ ⁠Ɗo fi Yíkëe, fu hosiɗ soꞌ kotti soꞌ a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu yéeh iti fi yee na paŋ mi ra doom, fay rii yúhé fayu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peer won ɗi tih⁠ ⁠: «⁠ ⁠Ɗamaay fu hosɗe soꞌ kotti soꞌ⁠ ⁠!⁠ ⁠» Yéesú tahte won ɗi tih⁠ ⁠: «⁠ ⁠Mi hosɗay ro kottu raa, ɗeef hanndal ki yen ɗúmpé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Peer won ɗi tih⁠ ⁠: «⁠ ⁠Kon Yíkëe, ngana teem kotti soꞌ kut, lahe níi yaꞌ yi soꞌ a af soꞌ ɓal⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëyí kolaꞌ ɓoohoh, faana ɓéeɓ lante, sohlaay ɗi ɓoohlee. Ɗon fi ƴee ɗon ladute, ndaa ɗon ɓéeɓ daa ladu neh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ɗeef Yéesú yúhté ɓëeꞌ nay rii yaaye ra, daa tah ɗi won biti wa ɓéeɓ daa ladu neh. ");
INSERT INTO ndv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hosaꞌ Yéesú kotti taalibe yi níi wocce ra, ɗi ɓekaatte búubí, tookaatte loona, antee waa won tih⁠ ⁠: «⁠ ⁠Ɗon yúhú iti fi yee pagiɗ mi ron ra a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ɗon dëekúu sëꞌ yëeddëh a Yíkëe, te ɗon wonu kaah, mi ɗi. ");
INSERT INTO ndv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Hém soꞌ mi Yíkëen, soꞌ mi yëeddëhën, daa mi hos kotton raa, kon ɗon warutee hosantaꞌ kot hanndal kon ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ɗon ot mi pagiɗ ɗon yii bah, ɗeef mi fahaꞌ biti ɗon pagee ri ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mee ron won kaaf ka ra ee⁠ ⁠: súrgë lukeh kélfíi gaan, ɓëeꞌ wolu ra lukeh ɓëeꞌ wol ri ra gaan. ");
INSERT INTO ndv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bee yúhúu ron iñƴaa leegi ra, ɗon ñee na raa, keeññon ay sos. ");
INSERT INTO ndv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mi wonaay ɗon ɓéeɓ nék⁠ ⁠! Mi yúh ɓëewë tanis mi ra. Ndaa yee bíníyú Téerëe rë waɗti laha laho. Téerëe won tih⁠ ⁠: “Ɓëeꞌ funi woruu mbúuríi sëꞌ rë, daa míllëꞌ hen kaaꞌohi soꞌ.” ");
INSERT INTO ndv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mi wonte ron baaha abah balaa wahtaa lah. Hen ɗaa wahtaa lah raa, ɗon ay gém biti daa mi. ");
INSERT INTO ndv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí tah ɓëyí daa mi wol ri a yaꞌ ana, ɗeef ɗi tah soꞌ⁠ ⁠; te ɓëyí tah soꞌ, ɗeef ɗi tah ɓëeꞌ wol soꞌ ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wocaꞌ Yéesú woni baa ra, afa kúnëhté pak, ɗi won tih⁠ ⁠: «⁠ ⁠Mee ron won kaaf ka ra ee⁠ ⁠: ow di ɗon na ay soo yaay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Taalibe ya yíih ɓëeꞌ na wonaꞌ Yéesú rë, wa na yeelantuu affi wa. ");
INSERT INTO ndv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ow di taalibe ya, kooji Yéesú, húmú hëbísí. ");
INSERT INTO ndv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tígí daaha, Simoŋ Peer paŋke yodaɗ, nahte ri meel Yéesú ɓëeꞌ na wonaꞌ ri ra. ");
INSERT INTO ndv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Taalibee sígímpé nuf Yéesú, meelte ri won tih⁠ ⁠: «⁠ ⁠Fu wonaꞌ wa Yíkëe⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yéesú loffe won tih⁠ ⁠: «⁠ ⁠Mee saañ soop mbúurú loona ra ee⁠ ⁠: ɓëeꞌ nay mi rii yere ra, ɗi ɓëyí baaha.⁠ ⁠» Tígí daaha, Yéesú ɓeɓpe mbúurú, sooppe ri loona, yeɗte ri Yudaas fi Simoŋ Iskariyot. ");
INSERT INTO ndv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudaas na tah mbúurëe, Seytaane na haal ri. Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Yee nay fuu page ra, page ri gaaw⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ow yínë sah di wa fi taalibe ya húmú loona ra, yéeh yee fahaꞌ rii won ɗa. ");
INSERT INTO ndv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bi Yudaas daa yef keesi wa, i ow waa na habuu biti Yéesú nah ri pay saam iña nay waa sohlee feeda ra, mbée nah ri komi ñëkíɗɗë sarah. ");
INSERT INTO ndv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tahaꞌ Yudaas mbúurëe rë, ɗi yíppée ɗúh ëssín. Wahtii baaha ɗeef Koo elekke. ");
INSERT INTO ndv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ɗúhëꞌ Yudaas ëssín ɗë, Yéesú won tih⁠ ⁠: «⁠ ⁠Leegi Koope teeɓaꞌ ndami soꞌ mi Koy-ɓëeꞌ, mi teeɓaꞌ ndami ɗi fi Koope. ");
INSERT INTO ndv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te mi teeɓaꞌ ndami Koope raa, Koope ɓal ay teeɓaꞌ ndami soꞌ, te ri yuloh paŋi, maañlay. ");
INSERT INTO ndv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yee tallaꞌ mi hom filiɓ fon ɗa gaanlay yaawe⁠ ⁠! Ɗon ay soo saam, ndaa cëe mí won ɗon yee won mi yëwúɗɗë rë⁠ ⁠: ɗon míníh lah tígë në saañ mi ra. ");
INSERT INTO ndv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mee ron yeɗ túuƴëꞌ has ɗa ee⁠ ⁠: lah fëhëntíi hanndal kon. Di fahaꞌ mi ron, lah fëhëntíi ɗaaha hanndal kon. ");
INSERT INTO ndv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ɗon fahantaꞌ hanndal kon raa, tígí daaha ɓëewë ɓéeɓ ay yúh biti ɗon taalibe yi soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Filoon fi baaha, Simoŋ Peer meelte Yéesú won tih⁠ ⁠: «⁠ ⁠Fu saañ di Yíkëe⁠ ⁠?⁠ ⁠» Ɗi loffe Peer won tih⁠ ⁠: «⁠ ⁠Tígë homu yen bee ra kep fu mínéh ñee tal soꞌ níi fu lah tígë na saañ mi ra, sehe níi fayu, fay naa lah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peer won ɗi tih⁠ ⁠: «⁠ ⁠Yíkëe, yi tah mi mínéh ñee talu leegi⁠ ⁠? Mi tahte ñagi ñíin sëꞌ ndah ɗo⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu won kaah biti fu tahte ñagi ñíinú ndah soꞌ a⁠ ⁠? Mee roo won kaaf ka ra ee⁠ ⁠: añcaŋ, fiisiin ki paan, fay taasaꞌ biti fu yúh sëꞌ níi hen waal éeyë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yéesú antee won taalibe yi ɓéeɓ tih⁠ ⁠: «⁠ ⁠Affon ɓanay kúnëh⁠ ⁠! Gémí Koope, te ɗon gém sëꞌ ɓal⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Faam Baasoꞌ haŋke⁠ ⁠; may pay mi waaƴiɗ ɗon tígí nay ron home. Henay baa koon mi woneh ron ɗi⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mi pay mi waaƴiɗ ɗon ɗi níi woc ɗaa, may nimil mi kali ron. Hen ɗaaha raa, tígë nay mii home ra, ɗon ay home na ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ɗon yúhú waala yuliɗ tígë na saañ mi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomaa won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Yíkëe, fun yíih tígë na saañ fu ra, fun ay yúhée waala yuliɗ na ra ɗíh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Daa mi waala, daa mi kaaf ka, daa mi na onaꞌ pesa. Ow mínéh pay Boffa na te ñeyeh soo na. ");
INSERT INTO ndv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ɗon yúhú sëꞌ rëe kay, ɗon ay yúh Baasoꞌ ɓal⁠ ⁠! Te dalaꞌte woteh, ɗon yúhúté rí te ɗon olute ri⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fílíp won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Yíkëe, teeɓ fun Boffa kut, fun sohluuy yin kay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fílíp, maaña maañ mi filiɓ fon ɗa ɓéeɓ fu yéeh sëꞌ doom a⁠ ⁠? Ɓëyí ot soꞌ, ɗeef otte Boffa⁠ ⁠! Kon fu wonaꞌ biti mi teeɓ ɗon Boffa ɗíh⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fu gémëy biti mee Baasoꞌ na, te ri ee soo na a⁠ ⁠? Unna won mi ɗon ra ɓéeɓ, kolaay soo na, ɗi fi Boffa hom soo na ra kay daa na paŋ légéyí. ");
INSERT INTO ndv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gémí sëꞌ di yee wonaꞌ mi biti mee Baasoꞌ na, te ri ee soo na ra. Ɗon gémúy unna won mi ɗon ƴaa raa, iña na paŋ mi ra waɗtee tah ɗon gém book⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mee ron won kaaf ka ra ee⁠ ⁠: ɓëyí gém sëꞌ, ɗi fi ɓëyí baa ɓal ay paŋ iña na paŋ mi ra. Ɗi ay paŋ ƴi luk waa gaan sah, ndah mi saañ Boffa na, ");
INSERT INTO ndv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","te yii ɗon ɗaŋ ɗi ɓéeɓ, ɗon ñeyaꞌ ri tii soꞌ, may ron rii pagiɗ, nda soꞌ mi Koy ka mi teeɓaꞌ ndami Boffa. ");
INSERT INTO ndv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yii ɗon ɗaŋ ɗi, ɗon ñeyaꞌ ri tii soꞌ, may rii paŋ. ");
INSERT INTO ndv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«⁠ ⁠Ɗon fahaꞌ soꞌ raa, ɗon ay ñee iña na túuƴ mí ɗon ɗa. ");
INSERT INTO ndv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ɗaaha raa, may ɗaŋ Baasoꞌ kom ɗon Dímlëh kay, bi ay home ɗon na faraah. ");
INSERT INTO ndv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Daa ri Ruuha na teeɓ ɓëewë kaaf ka ra. Ɓëewë feey fi bee míníh ríi habaꞌ Dímlëh, ndah wa oluy ri, wa yíih rí. Ɗon nék, ɗon yúhú rí⁠ ⁠; ɗi ee filiɓ fon te ri ay home ow fi ow ɗon na faraah. ");
INSERT INTO ndv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mii ron yeɗɗaꞌ baayu, may ayaat ɗon na. ");
INSERT INTO ndv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tasse ƴutuuɗ fíi ɓëewë feey fi bee ii soo olil, ndaa ɗon ay ot biti mee pes ɗa, te ɗon ɓal ɗon ay pes. ");
INSERT INTO ndv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bín fë rëe, ɗon ay yúh biti mee Baasoꞌ na, ɗon ewu soo na, te mi ee ɗon na. ");
INSERT INTO ndv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ɓëyí ham iña na túuƴëꞌ mí rë afi te ri ñee na, ɗeef ɓëyí baa fahaꞌte soꞌ. Ɓëyí fahaꞌ soꞌ, Baasoꞌ ay rii fahaꞌ⁠ ⁠; soꞌ ɓal may rii fahaꞌ te may rii teekiroh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Taalibee na wonuu Yudaas, bokaay a Yudaas Iskariyot ra, won Yéesú tih⁠ ⁠: «⁠ ⁠Yíkëe, yi tah fay teekiree fun, fii teekiroh ɓëewí kayya⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ɓëyí fahaꞌ soꞌ, ay ñee iña na won mi ra⁠ ⁠; Baasoꞌ ay fahaꞌ ɓëyí baaha, te funi Baasoꞌ ay haal ɗii na, fun dék ɗii na. ");
INSERT INTO ndv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ɓëyí fahaay soꞌ, na ñeyeh iña na won mi ra. Te iña na keluu ɗon maa won wa ra, kolaay soo na, wa kolaꞌ Baasoꞌ fa wol soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«⁠ ⁠Mi won ɗon iñƴah bee homaꞌ mi leeloon bee ra. ");
INSERT INTO ndv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lahte Dímlëhí ee ac filoon fi soꞌ ra, daa ri Ruuh-Peseŋ fa nay wolee Baasoꞌ di tii soꞌ ra. Ɗi nay ron yëeddé ɓéeɓ, ɗi nédís ɗon iña won mi ron ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mi saañ sayo, ndaa may ron heliɗ jaamma, jaammaa lahaꞌ mi ra. Mii ron rii hellaꞌ ti di na paguu ri ɓëy ëldúnë nen. Affon ɓanay kúnëh, te ngënë tíití. ");
INSERT INTO ndv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ɗon keluute woni soꞌ ron biti mi saañ sayo ndaa may ayaat ɗon na ra maan⁠ ⁠? Ɗon fahaꞌ soꞌ koon, saaña na saañ mi Baasoꞌ na ra, keeññon ay naa sose soso. Mi saañ Baasoꞌ na, Baasoꞌ fa luk soo gaan ɗa. ");
INSERT INTO ndv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi wonte ron baa leegi balaa iñƴaa lah, nda bín fë rëe, ɗon gém. ");
INSERT INTO ndv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mii wonil caak a ɗon, ndah kélfíi feey fi bee ee ac ɗa. Ɗi mínéh yin soo na, daa may rii yeɗɗee yee nay lahe ra. ");
INSERT INTO ndv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ƴaaha ɓéeɓ, nda ɓëewë yúh biti mi fahaꞌte Baasoꞌ te mi pagaꞌ yee na nah ri soꞌ ra. Këlíi yen saañ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yéesú wonil tih⁠ ⁠: «⁠ ⁠Daa mi tal béeñí kah-kah fa, te Baasoꞌ daa na tooppitoh tal béeñë. ");
INSERT INTO ndv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yaꞌi tokoh soꞌ mi tal béeñë ɓéeɓ te límëy, Baasoꞌ ay rii lec. Ndaa bi na lím, ɗi ay rii yugus níi lan, ɗi ɓaatti lím. ");
INSERT INTO ndv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ɗon fi ƴee nék, ɗon yugusute níi ɗon ladute. Unna won mi ron ra daa yugus ɗon níi ɗon madute ɗaa lan. ");
INSERT INTO ndv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kon pëkíi soo na ti di pokaꞌ mi ɗon na nen. Yaꞌ béeñí tokaay tala, ɓani afi kep dín mínéh lím⁠ ⁠; ti ɗaaha nen, ɗon a affon kut ɗon míníh ɗúhíɗ njiriñ hém ɗon pokuuy soo na. ");
INSERT INTO ndv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«⁠ ⁠Daa mi tal béeñë, ɗon daa yaꞌ ya. Ɓëyí pokoh soo na, te mi pokoh ɗii na ay ɗúhíɗ njiriñ mi gaante. Ɗon míníh paŋ yin ɗeefa ɗon pëkíih soo na. ");
INSERT INTO ndv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɓëyí pokaay soo na ay betu ti yaꞌ béeñí lecu leco, betute súhté nen⁠ ⁠; yaꞌ yi béeñí man ɗah ay luuhu luuho, betu kíi wa tam. ");
INSERT INTO ndv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ɗon pokoh soo na, te ɗon ham unni soꞌ ɗon na raa, ɗëgí yii neɓaꞌ ron, ɗon ay rii liil. ");
INSERT INTO ndv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ndami Baasoꞌ yúhúu biti ɗon ɗúhíɗ njiriñ caak, ɗon teeɓaꞌ biti ɗon taalibe yi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Di fahaꞌ soꞌ Baasoꞌ, mi fahaꞌ ron ɗaaha. Pésíi filiɓ fahaꞌa fahaꞌ mi ron ra. ");
INSERT INTO ndv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Di ñeyaꞌ mi túuƴëꞌ yí Baasoꞌ, mi na pes filiɓ fahaꞌa fahaꞌ ɗi soꞌ ra, ɗon ñee túuƴëꞌ yí sëꞌ rëe, ɗon ay pesee ɗaaha filiɓ fahaꞌa fahaꞌ mi ron ra. ");
INSERT INTO ndv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«⁠ ⁠Ɗon ot mi won ɗon yii bah, mi fahaꞌ biti sosi keeñ soꞌ hom ɗon na, te sosi keeñon mit sëk. ");
INSERT INTO ndv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Túuƴëꞌí sëꞌ daa ri beh⁠ ⁠: Di fahaꞌ mi ron, lah fëhëntíi ɗaaha hanndal kon. ");
INSERT INTO ndv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lahay ɓëyí fahaꞌte ow níi luk ɓëyí tah yeraꞌi ñíiní af kooƴƴi. ");
INSERT INTO ndv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ɗon paŋ yii won mi ɗon raa, ɗeef ɗon kooƴƴi soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mii ron dëekíil súrgë, ndah súrgë na yéeh yii paŋ kélfíi. Mi dëekëꞌ rën kooƴ, ndah mi teeɓpe ron iña kolaꞌ mi Baasoꞌ na ra ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ɗon neh daa tansu soꞌ⁠ ⁠; daa mi tanis ron. Daa mi fal ron, mi wolte ron, ɗon ɗúhíɗ njiriñ, njiriñ mi na ɗúméh. Hen ɗaaha raa, yii ɗon ɗaŋ ɗi ɓéeɓ, ɗon ñeyaꞌ ri tii soꞌ, Baasoꞌ ay ron rii on. ");
INSERT INTO ndv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Filiɓ iñƴaa ɓéeɓ, mi fahaꞌ woni ron biti lah fëhëntíi hanndal kon. ");
INSERT INTO ndv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«⁠ ⁠Ɗon ot ɓëewë feey fi bee kaaꞌ ron, yúhí biti wa ɗéɓúu kaaꞌ soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ɗon nonun ɓëy feey fi bee koon, tin wa ay ron fahaꞌ ndah ɗon nonu waa na. Ndaa mi tanisse ron mi ɗúhíɗté rën waa na, tahte ɗon nënlíh waa na. Yii baa daa tah wa kaaꞌ ron. ");
INSERT INTO ndv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nérsíi yee húmú won mi ron biti súrgë lukeh kélfíi gaan ɗa. Ɓëewë moklute soꞌ raa, kon wa ay ron mokil⁠ ⁠; ƴee ñeyu woni soꞌ ra ay ñee wonnon ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yii wa paŋ ɗi ɗon ɓéeɓ daa mi tah, ndah wa yíih ɓëeꞌ wol soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Hena biti mi ayay te mi wonay a wa koon, tin wa ii habuu bakaaroh. Ndaa tígë homuu wa bee ra kep, wa lahluy layaa. ");
INSERT INTO ndv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɓëyí kaaꞌ soꞌ, ɗeef kaaꞌaꞌte Baasoꞌ ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Hena biti mi pagay kimtaanni ow kay mësëy wëe paŋ fíi wë koon, tin wa ii habuu bakaaroh. Leegi wa olute kimtaanni soꞌ, wa anutee kaaꞌ funi Baasoꞌ ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yee bíníyú téeríi kootii wa ra lahaꞌte ɗah. Bíníyúté bitih⁠ ⁠: “Yee kaaꞌuu wa soꞌ ra lahay dalaa⁠ ⁠!” ");
INSERT INTO ndv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Dímlëhí ron ac ayo⁠ ⁠: daa ri Ruuha na teeɓaꞌ kaaf ka ra. Ruuha kolaꞌ Boffa na. May ñeeꞌee Baasoꞌ na mi wolaꞌ ron ri, te ri ay soo seedeyiɗ. ");
INSERT INTO ndv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Te ɗon ɓal, ɗon ay soo seedeyiɗ ndah yen daa húmú dalaana níi a ɗeh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yéesú ɓaatte won tih⁠ ⁠: «⁠ ⁠Ɗon ot mi won ɗon yii bah, nda ɗon ɓanti sélít. ");
INSERT INTO ndv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yúhí biti ɗon ay líkú ílíƴƴë na ɗaguu yëwúɗɗë Koope ra⁠ ⁠; te ay tíl níi sah, ɓëyí ƴahti ron bëem ay rii habee biti jaamiyoh Koope. ");
INSERT INTO ndv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Biti wa yíih Boffa te wa yíih soꞌ ɓal daa nay tahe wa paŋ yii baaha. ");
INSERT INTO ndv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi won ɗon yii baaha biti lah na bín fë rëe, ɗon nérsëh yee húmú won mi ron ra. Biti mi mëssí hom leeloon daa tah mi wonay ron yin na daluu yen ñéerëꞌ bín fë níi a ɗeh. ");
INSERT INTO ndv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«⁠ ⁠Leegi mee saañ ɓëeꞌ wol soꞌ na ra, te ow di ɗon na meelay soꞌ tígë në saañ mi ra. ");
INSERT INTO ndv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yee won mi ɗon baa ra tahte keeññon ɗúmpé ces. ");
INSERT INTO ndv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Añcaŋ, mi won ɗon kaah⁠ ⁠: biti mi saañ daa gén ɗon na. Nagajek, mi saay raa, Dímlëhë waɗti ac ɗon na ra ii ayil⁠ ⁠! Ndaa mi saañ ɗaa, may ron ɗii wolaꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te ri ac ɗaa, ɗi ay teeɓ ɓëy ëldúnë biti wa homuy kaah di yii leŋke ɗee na oluu wa bakaaɗ ɗa, ɗee na oluu wa júɓ ɗë, a ɗee na oluu wa aattiyaꞌ ra⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","wa homuy kaah di yii leŋke bakaaɗ, ndah wa gémúy sëꞌ⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","di yii leŋke júɓ, ndah mee saañ Baasoꞌ na ra, te ɗon ii soo ollil⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","di yii leŋke aattiyaꞌ, ndah kélfíi feey fi bee daanute níi wocce. ");
INSERT INTO ndv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«⁠ ⁠Mi tallaꞌte iñi caakki wona mi ron, ndaa tígë homuu yen bee ra kep wa ɗameh affon. ");
INSERT INTO ndv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ruuha na teeɓaꞌ kaaf ki Koope ra ac ɗaa, ɗi ay ɗon ñéyíɗ kaaf ka ɓéeɓ. Iña nay rii wone ra ii kolaꞌ ɗii na, ɗi ay wone iña keloh ri ra, ɗi teeɓ ɗon yii nay lahe. ");
INSERT INTO ndv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Daa ri nay teeɓee ndami soꞌ, ndah ɗi ay ɓeyee iña soo na, teeɓ ɗon wa. ");
INSERT INTO ndv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yii Baasoꞌ daa lahaꞌ ri ɓéeɓ, daa mi lahaꞌ. Daa tah mi won ɗon biti Ruuha ay ɓeyee iña soo na, teeɓ ɗon wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yéesú wonil taalibe yi tih⁠ ⁠: «⁠ ⁠Tasse i waal fíi ɗon ii soo ot, tíkëh i waal ɗon an soo olaat.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","I ow di taalibe yi na wonantuu hanndal ki wa tih⁠ ⁠: «⁠ ⁠Ɗi fahaꞌ won yi biti tasse i waal yen ii rii ot, tíkëh i waal raa yen an ɗii olaat⁠ ⁠? Ɗi fahaꞌ won yi biti ɓal ɗi saañ Boffa na⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wa na wonaaluu wonu tih⁠ ⁠: «⁠ ⁠I waal fi bah, ɗi fahaꞌ won yi na⁠ ⁠? Ow yéeh yee na fahaꞌ rii won ra kat⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yéesú otte biti wa fahuu meeli, ɗi won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Yee wonaꞌ mi ron biti tasse i waal ɗon ii soo ot, tíkëh i waal raa ɗon an soo olaat ra, ɗon meelantuu baaha a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mee ron won kaaf ka ra ee⁠ ⁠: ɗon ay foŋ ɗon hawoh, ɗeefa ɓëy ëldúnë homun sos-keeñ⁠ ⁠; ɗon ay súfúñ lool, ndaa súfúñ fë ay yíssëh sos-keeñ. ");
INSERT INTO ndv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Loo ɓeleɓ ham raa na misik ɗii na, ndah ɗeef lowa daa lah⁠ ⁠; ɗi múc ɗëe nék, ɗi hal misiga keeña sos níi sos, ndah ɗi kúɗté koy ëldúnë. ");
INSERT INTO ndv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ɗon ɓal, tígë homuu ɗon bee ra, ɗon homuu misik a súfúñ⁠ ⁠; ndaa may ron olaat, keeññon ay sos te ow ii mín kaaꞌ keeññon sos. ");
INSERT INTO ndv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bín fë rëe, ɗon ii soo meellil yin. Mee ron won kaaf ka ra ee⁠ ⁠: yii ɗon ɗaŋ ɗi ɓéeɓ, ɗon ñeyaꞌ ri tii soꞌ, Baasoꞌ ay ron rii on. ");
INSERT INTO ndv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Níi a ɗeh, ɗon ñeyuy tii soꞌ ɗon ɗagute yin. Mantee ɗëgí, ɗon ay liil⁠ ⁠; ɗaaha, keeññon ay sos dotooƴ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yéesú antee tík won tih⁠ ⁠: «⁠ ⁠Iña won mi ron ƴaa ra ɓéeɓ, mi ñeyaꞌ wa léeh. Wahtu ín ac fíi rë nék mii ron wonliil ɗaaha, may ron wonee iñi Baasoꞌ ɓëñéet. ");
INSERT INTO ndv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bín fë rëe, ɗon ay ñeeꞌee tii soꞌ ɗon ɗaŋ Boffa. Mi wonay ron biti may ron ɗagire ɗii na, ɗon daa nay ɗagire affon. ");
INSERT INTO ndv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ɗi fi Boffa fahaꞌte ron ndah ɗon fahuute soꞌ, te ɗon gémúté biti daa ri wol soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi kolaꞌ Boffa na mi acce ëldúnë. Leegi may koloh ëldúnë, mi nimil Boffa na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Taalibe yi wonu ri tígí daaha tih⁠ ⁠: «⁠ ⁠Ɗi ɗeh⁠ ⁠! Fu wonte wonni lante te fu ñeyaay léeh. ");
INSERT INTO ndv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Biti fu yúh ɓéeɓ te sohlaay ow meelle ro yin, haalte affi fun leegi, daa tah fun gém biti fu kolaꞌ Koope na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ɗon wonu kaah biti ɗon gémúté leegi a⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aꞌ⁠ ⁠! Wahtaa ee saañ lahe ra kat, te ri lahte níi wocce, wahtaa nay ron hasluu ra, ow fi ow ɗon na ɓéeɓ nimil faam wa, ɗon hel soꞌ njunduŋ⁠ ⁠! Añcaŋ, mi homay a af soꞌ njunuŋ kat, ndah Baasoꞌ ee hëbís sëꞌ⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ɗon ot mi won ɗon iñƴah, nda ɗon pokoh soo na, ɗon lah jaamma. Ɗon ay mok ëldúnë nék⁠ ⁠! Ndaa lah hëbí híin, mi ɓaŋke nguur ki ëldúnë⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wonaꞌ Yéesú iñƴaa níi wocce ra, ɗi ɓéyíɗté afi sun won tih⁠ ⁠: «⁠ ⁠Baap, wahtaa lahte⁠ ⁠: teeɓee ndami soꞌ mi Koohu, nda mi mín teeɓaꞌ ndamu ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Fu onte soꞌ sañ-sañ sun fi ɓëewë ɓéeɓ, nda mi mín on ɓëewë déŋéen fú sëꞌ rë ɓéeɓ pesa na ɗúméh rë. ");
INSERT INTO ndv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pesa na ɗúméh rë nék, tokaꞌ níil yúhí ɗo fi Koope fi kah-kah fa yínë kut ɗa, a yúhí soꞌ mi Yéesú-Kiristaa fa wol fu ra. ");
INSERT INTO ndv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi paŋke légéyë nah fu soꞌ ra, mi teeɓaꞌte ndamu feey fa. ");
INSERT INTO ndv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Baap, kon leegi on soꞌ ndam hëbísú, ndama húmú lahaꞌ mi ɗoo na, na lahay ëldúnë doom ra. ");
INSERT INTO ndv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«⁠ ⁠Ɓëewë ɓeɓ fu ëldúnë fu déŋéenté sëꞌ wë rë, mi teeɓpe wa daa fu wah. Daa fu lahaꞌ wa, fu déŋéenté sëꞌ wë, wa ñeyute wonu. ");
INSERT INTO ndv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Leegi, wa yúhúté biti iña on fu soꞌ ra ɓéeɓ kolaꞌ ɗoo na. ");
INSERT INTO ndv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mi wonte wa unna won fu soꞌ ra, te wa tahute wa. Wa yúhúté biti mi kolaꞌ ɗoo na kah-kah, wa gémúté biti daa fu wol soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Af wa daa tah mi na ɗaŋ ɗo. Mi ɗagiray ɓëewë feey fi beh, mi ɗagiɗ ɓëewë déŋéen fú sëꞌ rë, ndah wa ƴuu. ");
INSERT INTO ndv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yii lah mi ɓéeɓ daa fu lahaꞌ, te yii lah fu ɓéeɓ daa mi lahaꞌ⁠ ⁠; te ndami soꞌ feeñce waa na. ");
INSERT INTO ndv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tasse ƴutuuɗ mii homil ëldúnë⁠ ⁠; mi yuloh ɗoo na, ndaa wa fi ƴeh, wa lísú ëldúnë. Baap, ɗo fa sela ra, níirée wë tii gaanu, bee on fu soꞌ ra, nda di lígínúu yen ana yen henute yínë, wa hen yínë ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Homaꞌ mi a wa ra, mi húmú níirëꞌ wë a tii gaanu, bee on fu soꞌ ra. Mi níiɗté wë, te ow múuƴëy waa na, henay ɓëeꞌ waɗti múuƴ ɗë, nda yee won Téerëe rë lah. ");
INSERT INTO ndv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«⁠ ⁠Bi leegi mi yuloh ɗoo na, mi won wa iñƴah bee lís mí ëldúnë bee ra, nda sosi keeña lahaꞌ mi ra hom waa na, keeññi wa sos dotooƴ. ");
INSERT INTO ndv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi léhínté wë yee won fu soꞌ ra, ɓëy ëldúnë anutee waa kaaꞌ, ndah wa nëníh ɓëy ëldúnë ti soꞌ nen. ");
INSERT INTO ndv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi ɗaŋ ɗo biti fu sëmlëꞌ wë yaꞌ Seytaane, ndaa biti fu këlíɗ wë ëldúnë neh. ");
INSERT INTO ndv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wa nëníh ëldúnë ti soꞌ nen. ");
INSERT INTO ndv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ɓukutee wa kaaf ka, wa hen ƴuu⁠ ⁠; wonu daa kaaf ka. ");
INSERT INTO ndv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mi wolte wa ëldúnë ti di wolaꞌ fu soꞌ ëldúnë nen. ");
INSERT INTO ndv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Af wa tahte mi jébëlté rë af soꞌ mi hente buu, nda wa ɓukutoh kaaf ka raa, wa hen ƴuu ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«⁠ ⁠Mi ɗagiɗ wa neh doŋ, ndaa a ɓëewë nay soo gémé filoon fe ndah iña nay wone wa fi ƴee sun fi soꞌ ra. ");
INSERT INTO ndv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Baap, mi ɗaŋ ɗo biti wa ɓéeɓ hen yínë. Di homaꞌ fu soo na mi hompe ɗoo na, wa ɓal homuun yen na ɗaaha. Hen ɗaaha raa, ɓëy ëldúnë ay gém biti daa fu wol soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ndama on fu soꞌ ra mi onte wa ri, nda wa hen yínë ti di henuu yen yínë nen, ");
INSERT INTO ndv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","mi hom waa na, fu hom soo na, wa ɓéeɓ bok hen yínë. Hen ɗaaha raa, ɓëy ëldúnë ay gém biti daa fu wol soꞌ, te fu fahaꞌte wa ti di fahaꞌ fu soꞌ nen. ");
INSERT INTO ndv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baap, tígë na saañ mi ra, mi fahaꞌte biti ɓëewë déŋéen fú sëꞌ rë hom na ɓal, nda wa ot ndama on fu soꞌ ra, ndah fu maañcee soo fahaꞌ balaa ëldúnë saku. ");
INSERT INTO ndv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Te Baap, ɗo fa júɓ ɗë, ɓëy ëldúnë yíih rë, ndaa mi yúh rë, te ɓëewée ke soꞌ ƴee yúhúté biti daa fu wol soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi teeɓpe wa níi wa yúhúté daa fu wah, te may waa rii ɓaatti teeɓ, nda fahaꞌa fahaꞌ fu soꞌ ra hom waa na, te soꞌ ɓal mi hom waa na.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wonaꞌ Yéesú iñƴaa níi wocce ra, ɗi kolohte dah ɓani taalibe yi húusúté húlbí Sedoroŋ, haalute meey daaha. ");
INSERT INTO ndv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ɗi fi Yudaas fa nay rii yaaye ra yúh hatni baaha, ndah Yéesú a taalibe yi na húmú nëfíh daaha. ");
INSERT INTO ndv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ɗi kúɗté goomal soldaar a i wohoh di Faam fi gaani Koope ƴi yéŋké biti kélfë yí seeƴoh ya a fariseŋŋa daa yeru ri wa. Wa ayute, kúrëelúuté i lampa, kocom hawaanaa a ganaay. ");
INSERT INTO ndv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Bi yúh Yéesú iña nay rii kate ra ɓéeɓ, ɗi leɓohte wa won wa tih⁠ ⁠: «⁠ ⁠Ɗon saamu wah⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wa tahute wonu ri tih⁠ ⁠: «⁠ ⁠Fun saamu Yéesú fí ɓëy Nasaret.⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Daa mi⁠ ⁠!⁠ ⁠» Ƴaaha ɓéeɓ, ɗeef Yudaas fa na saañ ɗii yaaye ra húmú filiɓ fi wa. ");
INSERT INTO ndv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yéesú na won wa bitih «⁠ ⁠daa mi⁠ ⁠» rek, wa sajalute, lasuute feey. ");
INSERT INTO ndv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yéesú meelaatte wa won tih⁠ ⁠: «⁠ ⁠Ɗon saamu wah⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun saamu Yéesú fí ɓëy Nasaret.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ɗi wonaat wa tih⁠ ⁠: «⁠ ⁠Mi wonte ron ri koon, daa mi⁠ ⁠! Ɗon saamun soꞌ kut ɗaa, yéɗɗí ɓëewí ƴee saañ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yee húmú won Yéesú rë lahaꞌte ɗah. Ɗi húmú won tih⁠ ⁠: «⁠ ⁠Baap, mi ñakay ow yínë sah di ɓëewë déŋéen fú sëꞌ rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ɗeef Simoŋ Peer kúɗté jépíl. Ɗi yíppée ríi fúul, paaŋke ri súrgíi seeƴohi gaana, lecce nufi ñamaa fa. Súrgëe nufa lecu ra hínú Malkus. ");
INSERT INTO ndv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yéesú won Peer tígí daaha tih⁠ ⁠: «⁠ ⁠Nimilire jépílú mbari⁠ ⁠! Gulii coono fa yeɗ soꞌ Baasoꞌ ra mi waray rii han waro a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Soldaarra a kélfíi wë, a wohoh yi Faam fi gaani Koope habute Yéesú tígí daaha, pokalsuute ri a níh. ");
INSERT INTO ndv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wa ɗéɓúu ríi kúɗ faam Haan. Haan daa pacool Kayif fa húmú seeƴohi gaana kíilí baaha ra. ");
INSERT INTO ndv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ɗi fi Kayif daa húmú won yëwúɗɗë biti ow yínë kut ñak ñíiní ndah ɓëewë daa gén. ");
INSERT INTO ndv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na kúrú wë Yéesú faam seeƴohi gaana ra, Simoŋ Peer a ow kay di taalibe ya ñeyute tala. Bi yúh seeƴohi gaana taalibii bah, tahte ɗi fi taalibee a Yéesú daa hëeltú filiɓ faam fa. ");
INSERT INTO ndv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ndaa Peer húmú ëssín, hëbís ílë. Tígí daaha, taalibee koon ɗúhté, wonte a ɓelaa na woh ílë rë, ɓekke Peer filiɓ. ");
INSERT INTO ndv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ɓelaa won Peer tih⁠ ⁠: «⁠ ⁠Ɗo fi bee ɓal, fu noneh taalibe yi ɓëyí bee nagajek a⁠ ⁠?⁠ ⁠» Peer won ɗi tih⁠ ⁠: «⁠ ⁠Mi noneh na déꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bi húmú sos Koo, súrgë yë a wohoh ya këɗɗúté kíi na yoonnduu⁠ ⁠; Peer hompe a wa na yoonndoh ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Seeƴohi gaana yampe na meel Yéesú yii leŋke taalibe yi na a yee na yëeddëꞌ rí rë. ");
INSERT INTO ndv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Iña won mi ra, mi wonaꞌ wa sun ɓëewë ɓéeɓ na keluu. Soꞌ mi mëssí yëeddëꞌ filiɓ ílíƴƴë na ɗaguu yëwúɗɗë Koope ra a filiɓ Faam fi gaani Koope, te yëwúɗɗë ɓéeɓ teeꞌuu na⁠ ⁠; mi wonay yin las⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ngana meel soꞌ⁠ ⁠! Iña won mi ra, meele wa ɓëewë síkírúu sëꞌ rë. Wa yúhú iña won mi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wonaꞌ Yéesú woni bah, lahte wohohi húmú në, fúuɗté rí mbeƴ, won tih⁠ ⁠: «⁠ ⁠Fay lofee seeƴohi gaana ɗaaha a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Woni soꞌ ñeyay waal raa, teeɓ soꞌ tígë héllëꞌ mí rë, ndaa hena biti mi wona kaah raa, ɗeef fu laɓaꞌ soꞌ yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tígí daaha, Haan yeñce Yéesú faam Kayif seeƴohi gaana, ɗeef Yéesú lís pokki. ");
INSERT INTO ndv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Filiɓ fi ƴaaha ɓéeɓ, Simoŋ Peer hompe na yoonndoh rek. Lahte ɓëyí won ɗi tih⁠ ⁠: «⁠ ⁠Ɗo fi bee ɓal, fu noneh taalibe yi nagajek a⁠ ⁠?⁠ ⁠» Peer taasaꞌte won ɗi tih⁠ ⁠: «⁠ ⁠Mi noneh na déꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Filoon fi baaha, ow di súrgë yí seeƴohi gaana, mboko mi ɓëeꞌ Peer lec nufa ra, won ɗi tih⁠ ⁠: «⁠ ⁠Mi ot ɗo fi bee a ɗi filiɓ meeya neh nagajek a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Taasaꞌ Peer waali yínée, paan yíppée fiisoh. ");
INSERT INTO ndv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yéesú ɓeyute faam Kayif daaha, kúrúté faam gëernëer ɓaabin cúɓ. Ndaa lahuu wa ra, wa haaluy filiɓ, wa kaaꞌuu biti wa ay sobeye nda wa mín ñam ñami feedi Paaga. ");
INSERT INTO ndv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tígí daaha, Pilaat ɗeefiɗte wa won wa tih⁠ ⁠: «⁠ ⁠Ɗon wonu ti ɓëyí bee paŋ yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wa lofute ri wonu tih⁠ ⁠: «⁠ ⁠Ɗi henay ow ɓos koon fun këmí rë rí⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilaat won wa tih⁠ ⁠: «⁠ ⁠Ɗon fi ƴaa ɓéyí rí, ɗon ñee yee won kootii ron ra ɗon aattiyaꞌ ri⁠ ⁠!⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun lahuy sañ-sañi tíkúun fun húl sun ow, fun hap ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yee húmú won Yéesú rë lahaꞌte ɗah sun fi ɗee nay rii húlée rë. ");
INSERT INTO ndv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tígí daaha, Pilaat nimilte filiɓ faam fa, dëekrëhté Yéesú meelte ri won tih⁠ ⁠: «⁠ ⁠Daa fu buuri yëwúɗɗë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Woni baa kolaꞌ ɗoo na mbée ow daa won ɗo baaha sun fi soꞌ⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaat tahte won tih⁠ ⁠: «⁠ ⁠Maa mi yëwúɗ ë⁠ ⁠? Ɓëy heedon a kélfë yí seeƴoh yon daa komu soꞌ ro⁠ ⁠! Kon fu paŋ yih⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yéesú loffe ri won tih⁠ ⁠: «⁠ ⁠Nguur ki soꞌ nguur ki feey fi bee neh. Nguur ki soꞌ ƴaha nguur ki feey fi bee koon, tin súrgë yí sëꞌ ay soo haaꞌiɗ níi mi yëeyíh yëwúɗɗë⁠ ⁠; ëe-ëeꞌ, nguur ki soꞌ nguur ki feey fi bee neh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilaat won ɗi tih⁠ ⁠: «⁠ ⁠Kon fu buur a⁠ ⁠?⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu wonte ri, daa mi⁠ ⁠! Seedii kaaf ka daa tah mi límú, seedii kaaf ka daa tah mi ac feey fi beh. Te ɓëyí hom kaaf ka ɓéeɓ, helte nuf iña na won mi ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaat won ɗi tih⁠ ⁠: «⁠ ⁠Úh⁠ ⁠! Yi daa kaah⁠ ⁠?⁠ ⁠» Kolaꞌ ri woni bah, Pilaat ɗúhëetté ëssín ɗeefiɗte yëwúɗɗë, won wa tih⁠ ⁠: «⁠ ⁠Soꞌ mi olay yii mín tíkú sun fi ɓëyí beh, ");
INSERT INTO ndv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","te ɗon ɓaahuu biti lahaa Paak ɓéeɓ, mi ɗúhríɗ ɗon ow yínë kasu. Ɗon fahuuy biti mi yessiɗ ɗon buuri yëwúɗɗë ë⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tígí daaha, wa ɓéyrúté unni wa sun wonu tih⁠ ⁠: «⁠ ⁠Ëe-ëeꞌ⁠ ⁠! Ɗi neh⁠ ⁠! Ɗúhríɗ fun Barabaas.⁠ ⁠» Ɗeef ɗi fi Barabaas fa banndi. ");
INSERT INTO ndv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Filoon fi baaha, Pilaat nahaꞌte fúuɗɗëhí Yéesú laraw. ");
INSERT INTO ndv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldaarra ɓeyute ñap yugusute baane, ɓekute ri af Yéesú, tíkúté paltu luum sun fi, ");
INSERT INTO ndv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","leɓuute ri wonu ri tih⁠ ⁠: «⁠ ⁠Coleere buuri yëwúɗɗë⁠ ⁠!⁠ ⁠» Wa na anuu rii fúuɗsëꞌ mbeƴ. ");
INSERT INTO ndv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaat ɗúhëetté yëwúɗɗë në, won wa tih⁠ ⁠: «⁠ ⁠Cëe mi ac mi komɗoh ron ri ëssë, nda ɗon yúh biti mi olay yii mín tíkú sun fi ɓëyí beh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tígí daaha, Yéesú ɗúhté, ɓani baanii yëlbí a paltii luumi. Pilaat won ɓëewë tih⁠ ⁠: «⁠ ⁠Ɓëeꞌ abah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kélfë yí seeƴoh ya a wohoh ya oluu wa Yéesú, wa ɓéyrúté unni wa sun na wonu tih⁠ ⁠: «⁠ ⁠Daaƴe ri kurwah ɓal⁠ ⁠! Daaƴe ri kurwah⁠ ⁠!⁠ ⁠» Pilaat won wa tih⁠ ⁠: «⁠ ⁠Ɓéyí rí ɗon daaƴiɗ ɗi affon. Soꞌ mi olay yii mín tíkú sun fi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yëwúɗɗë wonu Pilaat tih⁠ ⁠: «⁠ ⁠Kootii fun kaddaꞌte ow sol Koope, te ri wonte biti ɗi Koy Koope. Kon ɗi waɗti hawun húl⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kelaꞌ Pilaat woni bah, ɗi ɓaattee tíit. ");
INSERT INTO ndv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ɗi haalaatte faam, meelte Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu ɗúhëꞌ dih⁠ ⁠?⁠ ⁠» Yéesú hente tiɗ, lofay ri. ");
INSERT INTO ndv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tígí daaha, Pilaat won ɗi tih⁠ ⁠: «⁠ ⁠Fii soo tiil a⁠ ⁠? Fu yéeh biti mi mín ɗëe yeris te mi mín ɗëe daaƴɗoh kurwah a⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu mínéh yin yínë sah sun fi soꞌ, henay yee yeɗ ɗo Koope fa sun ɗa. Yii baa daa tah bakaadi ɓëeꞌ yeñ soꞌ ɗoo na ra luk buu gaan.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilaat kolaꞌ daaha na saam ɗee nay rii yeɗɗee Yéesú rë. Ndaa yëwúɗɗë ɓéyrúté unni wa wonu tih⁠ ⁠: «⁠ ⁠Fu yeris ɓëyí bee ɗeef fu ñéerëey a Sesaar. Ɓëyí tík afi buur, ɗeef haaꞌ Sesaar.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kelaꞌ Pilaat unni ƴah, ɗi ɗúhíɗté Yéesú fëel, antee took ñaana na aattiyuu, hom ëssë dérúu a laꞌ, na wonuu yëwúɗɗë Gabataa ra. ");
INSERT INTO ndv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yiin fi baaha, teeꞌaꞌ a bisa míllëꞌ waaji Paagi yëwúɗɗë, bee lahaꞌ naꞌ leelu af ra. Pilaat won wa tígí daaha tih⁠ ⁠: «⁠ ⁠Buuron abah⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ndaa wa ɓéyrúté unni wa na wonu tih⁠ ⁠: «⁠ ⁠Ɗi húlë ɓal⁠ ⁠! Ɗi húlë⁠ ⁠! Daaƴe ri kurwah⁠ ⁠!⁠ ⁠» Pilaat won wa tih⁠ ⁠: «⁠ ⁠May daaƴe buuron kurwah nam a⁠ ⁠?⁠ ⁠» Kélfë yí seeƴoh ya wonu ri tih⁠ ⁠: «⁠ ⁠Henay Sesaar, fun lahuy buur kay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tígí daaha, Pilaat yeɗɗaꞌte wa Yéesú, wa daaƴe ri kurwah. Soldaarra yípútée ham Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ɗi fi Yéesú daa enoh kurwahi, wa ɗúhúté gina, yullute tígë në wonuu «⁠ ⁠Këeŋ-af⁠ ⁠» ra. Tígí daaha wonuu «⁠ ⁠Golgotaa⁠ ⁠» di ébrë. ");
INSERT INTO ndv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Lahuu wa ra, soldaarra daaƴute Yéesú kurwaha. Wa daaƴaaluute ow ana kay kurwah⁠ ⁠: ɓëyí yínëe paaꞌte Yéesú yaꞌ ñamaa, yínëe paaꞌte ri yaꞌ sugu, Yéesú hompe leelaa. ");
INSERT INTO ndv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaat nahaꞌte bíníi a tíkrëhí unni ƴee sun fi kurwaha. Unna won yii beh⁠ ⁠: «⁠ ⁠Yéesú fí ɓëy Nasaret, buuri yëwúɗɗë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bi wulay tígë daaƴuu Yéesú rë gina, te unna bíníyú ébrë, lateñ a gerek, ow caak olute, yúhúté yee bíníyú rë. ");
INSERT INTO ndv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yee bíníyú baa ra neɓaay kélfë yí seeƴoh ya, wa payute wonu Pilaat tih⁠ ⁠: «⁠ ⁠Fu waray bíní “buuri yëwúɗɗë” koon. Fu waɗti bíníyë biti “ɓëyí bee won ti daa ri buuri yëwúɗɗë”.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaat won wa tih⁠ ⁠: «⁠ ⁠Yee bíní mí rë, mi bíníté rí níi wocce.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Daaƴuu soldaarra Yéesú níi wocce ra, wa ɓeyute yéré yí woruute wa cér iniil hanndal ki wa. Wa anutee ɓeɓ búubée ké rí teru sun níi feey te lahay ɗíis ɗë, ");
INSERT INTO ndv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","wonu tih⁠ ⁠: «⁠ ⁠Génë biti yen ɗarun ri ɗaro raa, yen púlúf rí yen ot ɓëeꞌ nay rii lahee ra.⁠ ⁠» Yee húmú bíníyú Téerëe rë lahaꞌte ɗah. Téerëe húmú won tih⁠ ⁠: «⁠ ⁠Wa woruute yéré yí sëꞌ, púlúfúté búubí sëꞌ.⁠ ⁠» Ɗee bíníyúu rí ɗaa ra, soldaarra paguu ri ɗaaha kep. ");
INSERT INTO ndv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yaafi Yéesú húmú caŋ hëbís kurwaha ɓani koy-yaafa ɓeleɓ, a Mari ɓeleɓ Kolopas, a Mari fi ɓëy Makdalaa. ");
INSERT INTO ndv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yéesú otte yaafi, otte taalibee daa kooji ra hompe hëbísí, ɗi won tih⁠ ⁠: «⁠ ⁠Yaa ow, koohu abah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ɗi won taalibee tih⁠ ⁠: «⁠ ⁠Yaafu abah.⁠ ⁠» Kolaꞌte baaha, taalibee ɓeɓpe yaafi Yéesú yeffe ri faami. ");
INSERT INTO ndv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nda yee won Téerëe rë lah, filoon fi baaha, bi yúh Yéesú biti iña ɓéeɓ púlgísëꞌté leegi, ɗi won tih⁠ ⁠: «⁠ ⁠Mi sifirohte.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ɗeef lahte yaadi líiffé bineegar húmú hatinni ƴaaha. Soldaarra yípútée ɓeɓ líil soopute ri bineegar, pokute ri yaꞌ isop, yullute ri ɓúk Yéesú na fahuu hënndí. ");
INSERT INTO ndv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ɗíkísëꞌ Yéesú bineegara, ɗi won tih⁠ ⁠: «⁠ ⁠Iña ɓéeɓ púlgísëꞌté.⁠ ⁠» Ɗi sígímpé, yeɗɗohte lússé. ");
INSERT INTO ndv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wahtu yi ƴaaha, ɗeef bisa na hílsúu yëwúɗɗë rë ee saañ dale ra. Kélfë yí yëwúɗɗë fahuuy biti ɓúudé hom sun kurwah bis hílsëe, ɓaatte biti bisi hílsíi bee bis gaan. Tígí daaha, wa payute Pilaat na, wonute ri biti ɗi nahaꞌ korsaꞌi kotti ɓëewë daaƴu ra, ɓúudé yë këllú tígë. ");
INSERT INTO ndv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nahuu soldaarra baaha ra, wa ñeyute ɓëewë daaƴu a Yéesú rë, korsuute kotti bee ɗéɓ ɗë, ñeyute ana fa na, korsuute kotta. ");
INSERT INTO ndv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ɗi fi Yéesú nék, lahuu soldaarra ɗii na olute biti ɗi húlté níi wocce ra, tígí daaha, wa korsuuy kotta. ");
INSERT INTO ndv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ndaa ow di soldaarra tappe ri juun hatin araal, ñif a muluɓ yíppée nëe ɗúh. ");
INSERT INTO ndv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɓëeꞌ ɓílíɗ iñƴee ra tíkké íllí në ngëeƴ, te iña won ɗi ra lahaꞌ ɗaaha. Ɗi a faanaŋ fi yúhté biti iña lahaꞌ ɗaaha. Ɗon ot ɗi won iñƴeh, nda ɗon gém ɗon ɓal. ");
INSERT INTO ndv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iñƴaa ɓéeɓ lahaꞌte ɗah, nda yee bíníyú Téerëe rë lah. Bíníyúté Téerëe bitih⁠ ⁠: «⁠ ⁠Ƴuh yínë sah ii kon faana.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bíníyúté biti ɓal⁠ ⁠: «⁠ ⁠Wa ay ƴíiɗ ɓëeꞌ wa jabu ri ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Filoon fi baaha, lahte ɓëyí hínú Suseef dék Arimate, payte Pilaat na, meelte ri ɓúudé fí Yéesú. Ɗi non taalibe yi Yéesú ndaa bi húmú neeh ri kélfë yí yëwúɗɗë, ɗi húmú teekiraay baaha. Pilaat tahiɗte ri, Suseef payte ɓeɓpe ɓúudé fë. ");
INSERT INTO ndv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tígí daaha, Nikodem ɓal acce habraꞌte ri. (Nikodem fi baa húmú mëssée pay yérí Yéesú elek.) Wa kúrúté laakkoloñi yugusuu míirí boolluu a barbosaa, ƴi waɗtee mit kílë sabay éeyë. ");
INSERT INTO ndv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wa ɓeyute ɓúudé fí Yéesú, na líiwú rí boy, na túmú rí yin heeñlaa ti di ɓaahuu ri yëwúɗɗë nen biti wa ƴahti hac ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tígë daaƴuu Yéesú kurwah ra lahte meey, bi kolom ki ow mësúy nëe hacu húmú në. ");
INSERT INTO ndv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bi na saañ dale bisa na hílsúu yëwúɗɗë rë te kolom ka wulay daaha, wa ɗapute ɓúudé fí Yéesú në. ");
INSERT INTO ndv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Hagadi dímëesë, Mari fi ɓëy Makdalaa kolohte saañce tígë hacuu Yéesú rë. Lahaꞌ ri ra, ɗi ɗeef laꞌa húmú ɓúk luuya ra éccírúté. ");
INSERT INTO ndv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ɗi yíppée múkë Simoŋ Peer na a taalibii yínëe Yéesú kooƴaꞌ ri ra, won wa tih⁠ ⁠: «⁠ ⁠Ɓúudé fí Yíkëe ɓeyute nuŋa, te fun yíih tígë kúrú rí rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tígí daaha, Peer a taalibii yínëe koluute na suu luuyin. ");
INSERT INTO ndv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wa húmú múkëyú múkëyë na suu wa ra. Bi luk taalibii yínëe Peer gaaw, ɗi ɗéɓpé rí luuya. ");
INSERT INTO ndv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Lahaꞌ ri ra, ɗi yérëntëhté otte boyya filiɓ, ndaa ri haalay. ");
INSERT INTO ndv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoŋ Peer lahaꞌ daaha, haalte na yeel boyya. ");
INSERT INTO ndv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Boya húmú af Yéesú rë homay a boyyi kayya⁠ ⁠; ɗi túlúñú túlúñë, hompe kay. ");
INSERT INTO ndv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Taalibii yínëe ɗéɓpí lah ra haalaꞌ daaha otte boyya, gémpé biti Yéesú kolohte. ");
INSERT INTO ndv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yúhí biti níi a baaha, ɗeef taalibe ya yíih yee fahaꞌ won Téerëe rë doom, biti Yéesú waɗtee koloh ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Taalibe yi ana ya koluu daaha, suute faam. ");
INSERT INTO ndv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ɗi fi Mari, nimilaꞌ ri ra, hom fëel fí luuya na looy. Ɗi hom looya yérëntëhté filiɓ, ");
INSERT INTO ndv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","otte malaaka ana yi ɓekuu búuɓ naaꞌ, tookute tígë húmú fënɗú ɓúudé fí Yéesú rë, bee hompe hatna húmú afa ra, yínëe hompe hatna húmú paaꞌ kotta ra. ");
INSERT INTO ndv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fu looy yi yaa ow⁠ ⁠?⁠ ⁠» Ɗi won wa tih⁠ ⁠: «⁠ ⁠Ɓúudé fí Yíkíi sëꞌ ɓeyute, te mi yéeh tígë kúrú rí rë.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɗi hom woni yii baa na heeltoh, ɗi otte ow caŋke hëbísí ndaa ri yéeh ɓëeꞌ, ɗeef yaa Yéesú. ");
INSERT INTO ndv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Fu looy yi yaa ow⁠ ⁠? Fu saam wah⁠ ⁠?⁠ ⁠» Bi habaꞌ Mari biti yaa wohohi meeya, ɗi won ɓëeꞌ tih⁠ ⁠: «⁠ ⁠Ɓahaa, daa fu kúrë rí rëe, won soꞌ tígë ɗap fu ri ra, mi kale ri.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yéesú won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Mari⁠ ⁠!⁠ ⁠» Ɗi yíssëhté Yéesú në, won tih⁠ ⁠: «⁠ ⁠Rabbuni⁠ ⁠!⁠ ⁠» (daa ri yëeddëh di ébrë). ");
INSERT INTO ndv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Ngana ham soꞌ deh, ndah mi lahay Baasoꞌ na doom. Tílé fu won koy-yaayyi soꞌ biti mi hom kotti saañi Baasoꞌ na daa Boffon ɗa, Koope fi soꞌ na daa Koope fon ɗa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari fi ɓëy Makdalaa yíppée saañ, wonte taalibe ya biti ɗi otte Yíkëe, léhínté wë yee won ɗi ra. ");
INSERT INTO ndv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sosaɗ naꞌi dímëesí baaha, bi ɗeef taalibe ya kaañuy kélfë yí yëwúɗɗë, wa téƴúuté faam. Yéesú acce hente bereeh leelii wa, won wa tih⁠ ⁠: «⁠ ⁠Cëlíirí yaawe⁠ ⁠! Hëmíi jaamma⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wonaꞌ ri wa iñƴaa ra, ɗi teeɓpe wa yaꞌ yi a hatni yíníi araali. Keeññi taalibe ya sos soso níi ola olu wa Yíkëe rë. ");
INSERT INTO ndv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yéesú wonaat wa tih⁠ ⁠: «⁠ ⁠Cëlíirí yaawe⁠ ⁠! Hëmíi jaamma⁠ ⁠! Di wolaꞌ soꞌ Baasoꞌ, soꞌ mi wolaꞌ ron ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kolaꞌ ri woni baa ra, ɗi ëffé sun fi wa, won wa tih⁠ ⁠: «⁠ ⁠Tëhí Ruuh-Peseŋ⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɓëyí ɗon baal ri bakaaɗɗi, ɗeef Koope baalte ri. Ɓëyí ɗon habiɗ ɗi bakaaɗɗi, ɗeef Koope habiɗte ri wa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toomaa fa na dëekúu Síisë rë non taalibe yi sabboo a ana ya, ɗeefaay na ac Yéesú rë. ");
INSERT INTO ndv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ayaꞌ ri taalibe yi kayya wonute ri biti wa olute Yíkëe rë, ɗi won wa tih⁠ ⁠: «⁠ ⁠Hém soꞌ mi olay daaƴiitti pontu ya yaꞌ ya, hém soꞌ mi ɓekay kun soꞌ ílíƴƴë daaƴuu ri faana ra, te mi ɓekay yaꞌ soꞌ lafi araali, mii mëssí gém biti ɗi kolohte ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nimilaꞌ bisi baa ɗeef taalibe yi Yéesú téƴëetúté faam fa, Toomaa hompe a wa ra, Yéesú acce hente bereeh waa na won tih⁠ ⁠: «⁠ ⁠Cëlíirí yaawe⁠ ⁠! Hëmíi jaamma⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ɗi antee won Toomaa tih⁠ ⁠: «⁠ ⁠Ɓeke kunu nuŋŋi yaꞌ yi soꞌ fu olsoh⁠ ⁠; ɓeke yaꞌu araal soꞌ. Yeɗɗe lah nuf ana, fu gém⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaa won ɗi tih⁠ ⁠: «⁠ ⁠Daa fu Yíkíi sëꞌ, daa fu Koope fi soꞌ⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Biti fu otte soꞌ daa tah fu gém ë⁠ ⁠? Ɓëyí gém sëꞌ te olay soꞌ, lahte sos-keeñ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yéesú paŋke kimtaan kay caak fíi taalibe yi, ƴi yéŋké biti ɓíllúy téeríi beh. ");
INSERT INTO ndv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ƴee filiɓ téeríi bee nék, ɓíllú biti ɗon gém biti Yéesú daa Buura Koo fal ri ra, Koy Koope. Te ɗon gém ɗii na raa, ɗon ay pes ndah ɗi. ");
INSERT INTO ndv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Filoon fi baaha, Yéesú feeñiyaatte taalibe yi ɓúk laahi Tiberiyat. Ɗi feeñiyaꞌ wa ɗeh⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoŋ Peer a Toomaa fa na dëekúu Síisë rë daa húmú, a Natanayel fi ɓëy Kanaa di Galile, a koyyi Sebede, a taalibe yi Yéesú ana kay. ");
INSERT INTO ndv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoŋ Peer won wa tih⁠ ⁠: «⁠ ⁠Mee saañ seeɓ ɗa.⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Caa fun ñéerëꞌ a ro fun ɓal.⁠ ⁠» Tígí daaha, wa ñéerúuté haalute gaala. Ndaa elgi baaha ɓéeɓ wa habuy yin. ");
INSERT INTO ndv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yíilëꞌ Koo ra, Yéesú acce caŋke ɓúk laaha, ndaa taalibe ya yíihsíih rí. ");
INSERT INTO ndv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ɗi won taalibe ya tih⁠ ⁠: «⁠ ⁠Ɗon habute jén saa yaawe⁠ ⁠?⁠ ⁠» Wa wonu ri tih⁠ ⁠: «⁠ ⁠Fun habuy yin.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Yéesí mbaala hatna paaꞌ yaꞌ ñamaa di gaala ra, ɗon ay ham.⁠ ⁠» Tígí daaha, wa yeesute mbaala. Mbaala hampe jén, líif líifë níi wa míníh ríi ɗúhíɗ mulaa. ");
INSERT INTO ndv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ow di taalibe ya, kooji Yéesú, won Peer tih⁠ ⁠: «⁠ ⁠Yaa Yíkëe⁠ ⁠!⁠ ⁠» Kelaꞌ Simoŋ Peer uni bah, ɗi yíppée ɓekoh búubée ké rí húmú nís ɗí na seeɓ ɗi ra, yíppée haal mulaa. ");
INSERT INTO ndv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Taalibe yi kayya ayuu a gaala, na fasu mbaala líif jén ɗë. Wa húmú wuluuy ɓúk laaha, yee talluu wa ra waɗti hena jaak tíméer (100). ");
INSERT INTO ndv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lahuu wa cépúté gaala ra, wa olute jén tíkúté sun kíi, mbúurú hompe hatni beh. ");
INSERT INTO ndv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tígí daaha, Yéesú won wa tih⁠ ⁠: «⁠ ⁠Jénë ɗúhúu ron ham ɗa, kúrí i koy na deh.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoŋ Peer haalaatte gaala, fasse mbaala líif jén ɗë, ɗúhíɗté rí ëssë. Jénë ɓéeɓ hente koy tíméer a koy sabay iip a koy éeyë (153), te ɗee teem wa ra ɓéeɓ tahay mbaala ɗaɗ. ");
INSERT INTO ndv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Filoon fi baaha, Yéesú won wa tih⁠ ⁠: «⁠ ⁠Ëyí ɗon ñam⁠ ⁠!⁠ ⁠» Ow yínë sah di taalibe ya kaañay rii meel daa ri wah, ndaa wa yúhúté biti yaa Yíkëe. ");
INSERT INTO ndv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yéesú leɓohte, ɓeɓpe mbúurëe woraꞌte wa, ɗi ɓeɓpe jénë ɓal hente ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Baa daa waali éeyë fë feeñiyoh Yéesú taalibe yi, këllúu rí ɓúudé rë. ");
INSERT INTO ndv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ñamuu wa níi wocute ra, Yéesú meelte Simoŋ Peer won ɗi tih⁠ ⁠: «⁠ ⁠Simoŋ fi Saŋ, di fahaꞌ fu soꞌ luk di fahuu soꞌ ɓëewí ƴee a⁠ ⁠?⁠ ⁠» Peer won ɗi tih⁠ ⁠: «⁠ ⁠Yíkëe, fu yúhté biti mi fahaꞌte ro.⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Lah tooppitee harri soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yéesú meelaatte ri won tih⁠ ⁠: «⁠ ⁠Simoŋ fi Saŋ, fu fahaꞌte soꞌ a⁠ ⁠?⁠ ⁠» Peer won ɗi tih⁠ ⁠: «⁠ ⁠Yíkëe, fu yúhté biti mi fahaꞌte ro kay⁠ ⁠!⁠ ⁠» Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Lah níiré harri soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ɗi wonil ri waali éeyë fë tih⁠ ⁠: «⁠ ⁠Simoŋ fi Saŋ, fu fahaꞌte soꞌ a⁠ ⁠?⁠ ⁠» Yee meelaꞌ ri Yéesú waali éeyë fë biti nda ri fahaꞌte ri ra, ɗúmëlté keeña. Ɗi loffe Yéesú won tih⁠ ⁠: «⁠ ⁠Yíkëe, fu yúh ɓéeɓ⁠ ⁠! Kon fu yúhté biti mi fahaꞌte ro⁠ ⁠!⁠ ⁠» Yéesú wonil ri tih⁠ ⁠: «⁠ ⁠Lah tooppitee harri soꞌ. ");
INSERT INTO ndv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mee roo won kaaf ka ra ee⁠ ⁠: henaꞌ fu kúkëy rë, daa fu na húmú pokit afu geñuu, fu pay tígí neɓaꞌ ro⁠ ⁠; ndaa tíl níi fu ɓaha raa, fay ɓéyíɗ yaꞌ yu, ow kay pokiɗ ɗo geñuu, kúɗ ɗë tígí fu fahaay naa pay.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Unna won Yéesú ƴaa ra, ɗi hom teeɓaꞌi ɗee nay húlée Peer ra. Peer ay teeɓee ndami Koope ɗaaha.) Yéesú antee tík won ɗi tih⁠ ⁠: «⁠ ⁠Ñeye tal soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Filoon fi baaha, Peer heeltohte, otte taalibee Yéesú kooƴaꞌ ri ra na ac filoon wa. Daa ri taalibee húmú sígím nuf Yéesú homuu wa ñama, meelte ɗi fi Yíkëe ɓëeꞌ nay rii yaaye ra. ");
INSERT INTO ndv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Olaꞌ Peer taalibee ra, ɗi meelte ɗi fi Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠A ɗi fi bee nék Yíkëe⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yéesú won ɗi tih⁠ ⁠: «⁠ ⁠Mi fahaꞌ biti ɗi pes níi mi nimil raa, waal fu ƴaha yi na⁠ ⁠? Fu lahaꞌ biti fu ñee tal soꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yaa bah, wona líiwëlsëꞌté filiɓ fi ɓëewë gémú Yéesú në rë biti taalibii baa ii ñee húl. Añcaŋ, Yéesú wonay biti ri ii húl, ɗi won wono ndék tee⁠ ⁠: «⁠ ⁠Mi fahaꞌ biti ɗi pes níi mi nimil raa, waal fu ƴaha yi na⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ɗi fi taalibee sah-sah daa ɓílíɗ iñƴaa bíníté wë, te fun yúhúté biti iña won ɗi ra kaah. ");
INSERT INTO ndv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yéesú paŋke i yin kay caak ƴi fu yéŋké biti ñeyun yínë-yínë bíníyú koon, mi lahte yaakaari biti téeré yë ii ɗam feey fi beh.");
INSERT INTO ndv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ɓah Tewofil, iña bíní mí téerée ké sëꞌ ɗéɓ ɗë won sun fi iña paŋ Yéesú a iña yëeddëꞌ rí rë ɓéeɓ dalaꞌte dalaana níi ");
INSERT INTO ndv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","yiin ɓéyrú rí saañce sun ɗa. Balaa ri saañ sun, ɗi ñeyaꞌte doolii Ruuh-Peseŋ nahte ɓëewë ɗi húmú tanis wa henute apootarri ra yee nay waa page ra. ");
INSERT INTO ndv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Filoon fi húlí, ɗi feeñiyohte wa fi ƴah, ñeyaꞌte wa pagaɗ caak teeɓpe wa biti ɗi ee pes ɗa kaah. Hente bis sabay iniil (40), hom níi rëe ɗi feeñiyoh wa wa ot ɗi, ɗi wone wa yii leŋke Nguur ki Koope. ");
INSERT INTO ndv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bisa ín, ɗi hompe na ñam a wa, ɗi won wa tih⁠ ⁠: «⁠ ⁠Ngënë wúlíi Yerusalem, séhí yee gap ɗon Baasoꞌ ra, daa ri yee húmú wonaꞌ mi ron bitih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Saŋbëtsëꞌ a muluɓ, ndaa ɗon, tasse ƴutuuɗ ɗon ay bëtsúu a Ruuh-Peseŋ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Filoon fi baaha, wa fi apootarra homu a Yéesú rë meelute ri wonu tih⁠ ⁠: «⁠ ⁠Wahtaa nay fuu cëgírëeté nguur ki Israyel ra lahte aa Yíkëe⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ɗi won wa tih⁠ ⁠: «⁠ ⁠Waal fon íníh jamanu a wahtu yi Baasoꞌ, daa ri lah sañ-sañ sun fi yii nay rii page ra kut. ");
INSERT INTO ndv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yúhí biti Ruuh-Peseŋ ay cép sun fon, on ɗon doole, ɗon hen seede yi soꞌ Yerusalem, Yúdée a Samari ɓéeɓ, a tígí teem feey fa ɓéeɓ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kolaꞌ Yéesú unni ƴah, ɗi kolohte feey íllí wë na saañ sun-Koo. Lahte nérí yíppée ac ɗappe rí íllí wë. ");
INSERT INTO ndv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ɗi na saañ, wa homute daa na yeelu sun-Koo, ow ana yi ɓekuu búuɓ naaꞌ yípútée caŋ fíi wë, ");
INSERT INTO ndv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","wonu wa tih⁠ ⁠: «⁠ ⁠Ɓëy Galile yi ƴeh, ɗon homu yi dee ɗon na ƴíirú sun-Koo⁠ ⁠? Yéesú fë koloh fíiyën ɓéyrúté sun-Koo ra, di oluu ron ri ɗi na saañ, ɗi ay nimilee ɗaaha.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Apootarra koluute daŋa daaha, bee na wonuu daŋi Ëlíiffë rë, suute Yerusalem. Daŋa wulaay a gina níi, hanndal ka waɗti hena kilomet yínë. ");
INSERT INTO ndv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lahuu wa Yerusalem ra, wa lawute sun faam, haalute lasa na hoñuu waa teeꞌaꞌ ra. Wa húmú Peer, Saŋ, Saak, Anndere, Fílíp, Toomaa, Bartalemi, Maccëe, Saak fi Alfe, Simoŋ fi jammbaara a Yudaas fi Saak. ");
INSERT INTO ndv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wani Maryaama yaafi Yéesú a i ɓeleɓ kay, a koy-yaayyi Yéesú ƴaal teeꞌuu daaha, faraah wa ɗage. ");
INSERT INTO ndv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lahte bis waalli ƴaaha, Peer kolohte caŋke leelii koy-yaayya filiɓ ngémë, ɗeef wa warutee mit ow tíméer a ow sabay ana (120), won wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«⁠ ⁠Koy-yaayyi ƴeh, Ruuh-Peseŋ húmú wonte yin yii leŋke Yudaas fa kúɗ ɓëewë habu Yéesú rë. Ɗi húmú ñeyaꞌ Dawit na, wonte ri Téerëe⁠ ⁠; te yii baa waɗti laha laho te lahaꞌ ɗaaha. ");
INSERT INTO ndv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudaas húmú non fun na, te ri húmú yerute légéyí ti di yeruu ow fi ow fun na bii nen.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Hélsë yínlúu rí yii ɓosa paŋ ɗi ra, lomuu feey. Ɗi keenaꞌ feey fi baaha. Na keen ɗi ra, ɗi keenaꞌ líhëh lowa lasse, liilla ɓéeɓ bútëhté. ");
INSERT INTO ndv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yaa hente lëyëŋ filiɓ Yerusalem ɓéeɓ. Kolaꞌte baaha, ɓëy Yerusalem wonuu tígí daaha Hakeldama, daa ri⁠ ⁠: Feey fi ñif ma.) ");
INSERT INTO ndv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peer tíkké won tih⁠ ⁠: «⁠ ⁠Di yii leŋke ɗi fi baaha, nagajek bíníyúté filiɓ téeríi Kañaa ya bitih⁠ ⁠: “Faam fa hena holoŋ, ow ɓan naa dék.” Bíníyúté biti ɓal⁠ ⁠: “Ow kay taha légéyí.” ");
INSERT INTO ndv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Lahte ɓëewí ewu yen na deh, funi wa daa mësúu ñéerëꞌ a Yéesú-Yíkëe, ");
INSERT INTO ndv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","dalaꞌte bín oluu yen Saŋ Batis na bëtís rí rë níi a bee këllúu rí leelii yen ra. Kon di mín ɗíi man ɓéeɓ, waɗtee lah ɓëyí haal fun na di wa fi ƴaaha, seedeyiɗ Yéesú biti ri kolohte ɓúudé.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tígí daaha, tii ow ana capute⁠ ⁠: ɓëyí yínëe Suseef fa na dëekúu Barsabaas mbée Yústús rë, yínëe Macaas. ");
INSERT INTO ndv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Taalibe ya ɓéeɓ yefuute ɗaŋi Koope wonu tih⁠ ⁠: «⁠ ⁠Yíkëe, ɗo fa yúh yii hom keeñ ow ɓéeɓ rë, teeɓ fun ɓëeꞌ tanis fu di wa fi ana yi ƴeh, ");
INSERT INTO ndv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","hen apootar tah tígí Yudaas fa hegoh légéyí saañce tígë waɗ ɗii na ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Filoon fi baaha, wa púlúfúté wa fi ana ya, púlúfë keente sun fi Macaas. Ɗi yeeltee ɓaatoh apootarri sabboo a yínë yë në. ");
INSERT INTO ndv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lahaꞌ Pantakot ra, ɓëewë gémú Yéesú rë ɓéeɓ teeꞌluute tígë në teeꞌuu wa merees ra. ");
INSERT INTO ndv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Hom homo níi, wa keluute yodadi kolaꞌ sun man yodaɗ ngilaaw gaan nen, líiffé faam fa tooku wa ra del. ");
INSERT INTO ndv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Wahtii baaha, wa olute i yin ti pereem nen, madaꞌ kíi, haslaꞌte, bina-bina ɓéeɓ céppé ow fi ow waa na. ");
INSERT INTO ndv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wa ɓéeɓ yípútée líif a Ruuh-Peseŋ, ow fi ow waa na ɓéeɓ a yee ɓeyaꞌ ri Ruuha ra, na won wonaɗ kay. ");
INSERT INTO ndv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bín fë, ɗeef lahte yëwúɗɗí gémúté Koope níi gém, koluu ginna ëldúnë ɓéeɓ ayute dékúté Yerusalem. ");
INSERT INTO ndv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Keluu wa yodada ra, wa ayute caakute níi caak, teeꞌuute, éemúté níi éem ndah ow fi ow waa na ɓéeɓ na keluu ɓëewë gémú Yéesú rë na wonu wonaɗɗa ɓapu wa ra. ");
INSERT INTO ndv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wa éemú éemë níi na wonu tih⁠ ⁠: «⁠ ⁠Ɓëewë në wonu ƴee ra, wa ɓéeɓ ɓëy Galile saa ɓal⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kon henaꞌ ɗí níi ow fi ow yen na ɓéeɓ na keloh iña na wonu wa ra di wonada ɓap ɗi ra⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Te filiɓ fi yen, ƴee koluu ginni Parta ya, ƴee koluu Médí, Elam, Mesopotami, Yúdée, Kapados, Ponto a Aasi⁠ ⁠; ");
INSERT INTO ndv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ƴee koluu Fírísí a Pamfili, ƴee Ésíp, ƴee koluu deya na wonuu Siren ra di Líbí⁠ ⁠; lahte ƴi koluu Rom, ");
INSERT INTO ndv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Keret a Arabi⁠ ⁠; lahte ƴi yëwúɗ tígí-tígí, bokaay a ƴee ɗeefru yëwúɗɗë yooni wa ra. Te añcaŋ, yen ee waa keluu wonaɗɗi yen ɗa, wa na waariyu iñi gaanna paŋ Koo ra⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wa ɓéeɓ éemúté, affi wa kúnëhté wa na wonantuu filiɓ fi wa tih⁠ ⁠: «⁠ ⁠Bee yi kan⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ndaa lahte ɓëewí na ñaawlu wa fi ɓëewë gémú rë wonu tih⁠ ⁠: «⁠ ⁠Ɓëewí ƴee mani tallaꞌ waa hap ƴee raa⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tígí daaha, Peer kolohte ɓani apootarri kayyi sabboo a yínë yë, ɗi ɓéyíɗté uni sun won tih⁠ ⁠: «⁠ ⁠Ɗon fi yëwúɗɗë a ɗon fa dékú Yerusalem ra ɓéeɓ, kúnsí nuffon ɗon síkírëh sëꞌ ndín ɗon yúh yee lah ra. ");
INSERT INTO ndv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Di habuu ɗon ɗi affon lahaay ɗaaha, ɓëewí ƴee maniyuy. Yen homu siñaakaɗ kep ee⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yee lah baa ra, yonente Suwel húmú wonte ri. Ɗi húmú won tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Koope won tih⁠ ⁠: Waalla nay míllée rë, may haslaꞌ Ruuhi soꞌ sun fi ɓëewë ɓéeɓ, tuŋki ron yíssëh yonente léhín woni soꞌ. I yin ay feeñiyoh tuŋkon, ɓaha ya ay olee heeƴ. ");
INSERT INTO ndv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ahaŋkay⁠ ⁠! Bín fë rëe, may haslaꞌ Ruuhi soꞌ sun fi súrgë yí sëꞌ, ƴaal a ɓeleɓ wa yíssëh yonente léhín woni soꞌ. ");
INSERT INTO ndv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","May teeɓaꞌ i kimtaan sun-Koo dín, a iñi éemílëꞌté feey fi beh ti ñif, kíi a i nér ɗúukëe nen. ");
INSERT INTO ndv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Naꞌa ay míif ñúus túɗ, céyín fë luum níi ti ñif nen, balaa bisa nay aye Yíkëe rë lah, bisi gaana ñéerëꞌ a ndam ra. ");
INSERT INTO ndv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Te ɓëyí fí dëek Yíkëe ɓéeɓ ay múc.” ");
INSERT INTO ndv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«⁠ ⁠Ɗon fi ɓëy Israyel, síkíríi yee nay mi ron wone ra⁠ ⁠: Ɗon yúhúté biti Yéesú fí ɓëy Nasaret, ɗi ɓëyí Koope ñéerëꞌté a ri, yii hente kimtaan ɓéeɓ a iñi éemílëꞌté, Koope daa ñeyaꞌ ɗii na ɗi na an waa paŋ fíiyën. ");
INSERT INTO ndv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɗi fi baa yaayute ti di fahaꞌ ri Koope fa maañci tíɓ baaha ra nen. Te ɗon daa hawu ri, ɗon fa tahu ɓëewë në ñéyíh woni Koope ra daaƴ ɗi kurwah ra. ");
INSERT INTO ndv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ndaa Koope këlíɗté rí ɓúudé, múcëlté rí coono fi kúl kë. Baa daa teeɓaꞌ biti kúl kë mínéh ríi ham. ");
INSERT INTO ndv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nagajek Dawit húmú wonte yii bee sun fi⁠ ⁠: “Mi olaꞌ Yíkëe fíi sëꞌ faraah, te hém ɗi ee hëbís sëꞌ rek, mi lahay yii sídëe mí. ");
INSERT INTO ndv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yii baa daa tah keeñ soꞌ sos, te unni neɓpe na ɗúh ɓúk sëꞌ. May fanee a yaakaar⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ɗo fi Yíkëe, fii soo hel filiɓ kúl kë, fii yeris soꞌ mi ɓëwú, ɓúudé fí sëꞌ yah. ");
INSERT INTO ndv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fu teeɓpe soꞌ waalla yuliɗ pesa ra, fay home hëbís sëꞌ, fu sosil keeñ soꞌ.”» ");
INSERT INTO ndv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peer ɓaatte won tih⁠ ⁠: «⁠ ⁠Koy-yaayyi ƴeh, cëe mi won ɗon níi lan⁠ ⁠: ciffi yen Dawit húlté, hacute, te luuyi ee gin yen ee níi a ɗeh. ");
INSERT INTO ndv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na húmú won ɗi woni baa ra, ɗeef ɗi húmú yonente, te Koope gappe ri, añohte ri biti ow di séttí ay rii lam ñaani nguur ka. ");
INSERT INTO ndv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Bín fë, ɗi otte biti Buura Koo fal ri ra ay koloh ɓúudé, daa tah ɗi won biti ɗi heluy filiɓ kúl kë, ɓúudé fí ii yah. ");
INSERT INTO ndv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Te fun ɓéeɓ fun mínú seede biti Koope këlíɗté Yéesú fë na wonuu ra ɓúudé. ");
INSERT INTO ndv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Filoon fi baaha, ɗi ɓéyrúté tíkúté hëbís Koope, hompe yaꞌi ñamaa fi. Ɗi fi Koo Boffa yeɗte ri Ruuh-Peseŋ fa gapaꞌ ri ra, ɗi nampee rii haslaꞌ ɓëewë në. Daa ri yee na olu ɗon te na keluu ɗon ɗee ra. ");
INSERT INTO ndv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawit laway sun-Koo déꞌ, ndaa ɗi wonte bitih⁠ ⁠: “Koo-Yíkëe won Yíkíi sëꞌ tih⁠ ⁠: Tooke hëbís sëꞌ, yaꞌi ñamaa fi soꞌ deh, ");
INSERT INTO ndv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","níi bín nëy míi yíssée kaaꞌoh yu hen tíkëe yí kottu ra.” ");
INSERT INTO ndv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«⁠ ⁠Kon ɗon fi ɓëy tali Israyel ɓéeɓ yúhí te ɗon ham affon biti Yéesú fë daaƴu ron kurwah ra, Koope fal ɗi fi baaha Yíkëe a Buur.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Unni ƴaa haalte ɓëewë në húmú síkírúu rë, wa meelute Peer a apootarri kayya wonu wa tih⁠ ⁠: «⁠ ⁠Fun waɗti pagun yi nék koy-yaayyi ƴeh⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peer won wa tih⁠ ⁠: «⁠ ⁠Lëfí pesaɗ, te ow fi ow ɗon na ɓéeɓ bëtsú di tii Yéesú-Kiristaa ɗon baalu bakaaɗɗon. Hen ɗaaha raa, Koope ay ron on Ruuh-Peseŋ. ");
INSERT INTO ndv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Te Ruuha gapaꞌ Koope baa ra, ɗon daa lahuu ri ɗoni koyyon a séttën, a ɓëewë dékú wul ra ɓéeɓ ɓal, ƴee Koo-Yíkëe nay waa dëeké fayu ra.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peer wonte wa i yin kay caak na ɓaat waa héc, na ɓeddaꞌ wa won tih⁠ ⁠: «⁠ ⁠Pëgí níi ɗon fús di ɓëy jamanii beh, wa fi ɓëewí ɓossa.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iña won Peer ƴaa ra, ow caak waa na tahute wa, wa bëtsúté. Yiin fi baaha, yii mitte ow júnní éeyë (3.000) ɓaatuute ɓëewë gémú rë. ");
INSERT INTO ndv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kolaꞌte baaha, ɓëewë gémú rë caguute lok na síkírúu iña na yëeddúu apootarra ra, wa bokute henute yínë, wa bokute woruute mbúurëe, wa na ɗagu yínë. ");
INSERT INTO ndv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ow fi ow waa na ɓéeɓ yéŋké neeh faani, ndah Koope ñeyaꞌ apootarra na teeɓpe ɓëewë kimtaan a iñi éemílëꞌté caak. ");
INSERT INTO ndv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɓëewë gémú rë ɓéeɓ henute yínë, yii wa lah ri ɓéeɓ wa bok. ");
INSERT INTO ndv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wa yaay iña lahuu wa raa, wa woraꞌ hélsë filiɓ fi wa, ow fi ow ɓéeɓ yeru yii mín paƴ ɗee teem sohlii ra. ");
INSERT INTO ndv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yíilëe Koo ɓéeɓ, faraah wa teeꞌee filiɓ Faam fi gaani Koope. Wa lah faammi wa raa, wa bok woraꞌ ñammi wa, wa ñame a sos-keeñ lëhíh nuf kay na, ");
INSERT INTO ndv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","wa njooɓe Koope. Wa neɓuute ɓëewë ɓéeɓ. Te yíilëe Koo faraah, Yíkëe ɓaat filiɓ fi wa ɓëewë múcël rí rë. ");
INSERT INTO ndv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lahte bis, Peer a Saŋ na suu Faam fi gaani Koope maasaꞌi ɗaŋa na lah wahtu éeyë filoon fi lahi naꞌ leelu af ra. ");
INSERT INTO ndv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ɗeef lahte ɓëyí límú lëfëñíɗ húmú tookke ílë na wonuu Ílí wuna hom Faam fi gaana ra. Faraah ɗi kúrúu daaha tëekɗú në, saraatee ɓëewë na haalu na ra. ");
INSERT INTO ndv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Olaꞌ ri Peer a Saŋ na haalu ra, ɗi ɗaŋke wa hélíis. ");
INSERT INTO ndv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peer a Saŋ henute ri íl jak, Peer won ɗi tih⁠ ⁠: «⁠ ⁠Ƴíiré fun na noo⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ɓëeꞌ yíppé íllí sun fi wa, na yeel wa, ndah ɗi séentëhté yin waa na. ");
INSERT INTO ndv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peer won ɗi tígí daaha tih⁠ ⁠: «⁠ ⁠Mi lahay dérém⁠ ⁠! May roo yere yee lahaꞌ mi ra⁠ ⁠: Kolee fu tíl di tii Yéesú-Kiristaa fí ɓëy Nasaret⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peer antee ham yaꞌi ñamaa fi ɓëeꞌ, na këlíɗ rí. Kotti ɓëeꞌ a púgúlúɓɓë yíppée híin. ");
INSERT INTO ndv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ɓëeꞌ foolte caŋke coltoŋ, yampe na tíl. Ɓani apootarri ana ya ñéerúuté, haalute filiɓ Faam fi gaana, ɗi na tíl, na fool, na njooɓ Koope. ");
INSERT INTO ndv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ɓëewë ɓéeɓ olute ri ɗi na tíl, na njooɓ Koope. ");
INSERT INTO ndv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Yúhúu ɓëewë biti yaa ɓëeꞌ na took saraatoh ílë na wonuu Ílí wuna di Faam fi gaana daaha ra, wa ɓéeɓ tíitúté, éemúté waha wah ɓëeꞌ rë. ");
INSERT INTO ndv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bi yeɗɗay ɓëeꞌ Peer a Saŋ, ɓëewë ɓéeɓ na múkëyú waa na di tígë na wonuu Mbaar mi Salomoo daaha ra, ndah wa lísúu éem. ");
INSERT INTO ndv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Olaꞌ Peer yii bah, ɗi won ɓëewë tih⁠ ⁠: «⁠ ⁠Ɗon fi ɓëy Israyel, yee wahaꞌ ɓëyí bee ra éemíl ɗon yih⁠ ⁠? Ɗon yeeluu fun yi ɗee man fun lahuu ham-ham mbée biti fun ɓëewí júɓúté daa tah ɓëyí bee tíl nen⁠ ⁠? ");
INSERT INTO ndv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Koope fi Abraham, Koope fi Isaak, Koope fi Yakop, Koope fi caacci yen daa teeɓaꞌ ndami súrgíi, ndami Yéesú. Ɗon fi ɗon, ɗon daa yaayu ri, ɗon kaaꞌuute yúhí fíi Pilaat, te añcaŋ, ɗi fi baa húmú caŋke yeɗɗi koon. ");
INSERT INTO ndv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ɗon kaaꞌuute oli Yéesú, ɗi fa sela te júɓ ɗë, ɗon wonu ti yeris ɓëyí hawaꞌ ow húl daa génëꞌ ɗon. ");
INSERT INTO ndv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ɗon hawruute ɓëeꞌ na onaꞌ pesa ra ɗaaha, ndaa Koope këlíɗté rí ɓúudé te fun ɓéeɓ i seede. ");
INSERT INTO ndv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Leegi ɗon oluy ɓëeꞌ wah bee ra te ɗon yúhú rí woo⁠ ⁠? Doolii tii Yéesú a gémë gémú fun ɗii na ra daa tah ɗi wah koloŋ ɗon ɓéeɓ na olu.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Peer ɓaatte won tih⁠ ⁠: «⁠ ⁠Koy-yaayyi ƴeh, filiɓ fi baaha ɓéeɓ, mi yúhté biti ɗoni kélfë yí rën yíih yúhë daa tah ɗon ñeyaꞌ Yéesú ɗah. ");
INSERT INTO ndv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ndaa Koope daa ñeyaꞌ ɗaaha, paŋke yee húmú won ɗi ñeyaꞌte ri yonente ya ɓéeɓ rë. Ɗi húmú wonte biti Buura Koo fal ri ra ay ñee mok. ");
INSERT INTO ndv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kon lëfí pesaɗ, ɗon yíssëh Koope na nda ri baal ron bakaaɗɗon. ");
INSERT INTO ndv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tígí daaha, Koo-Yíkëe ay ron on jamanu hílsëe te ri ay ron wolaꞌ Buura ɗi fal ri ra, bee maañ ɗon ɗii saamiɗ ra, daa ri Yéesú. ");
INSERT INTO ndv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yéesú-Kiristaa waɗti homa sun naꞌ-naꞌ níi bín nay cagaate iña ɓéeɓ rë, ti di húmú maañaꞌ ri won Koope ñeyaꞌte ri yonente yi sela yi ra nen. ");
INSERT INTO ndv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nagajek, Mëyíis húmú won tih⁠ ⁠: “Koo-Yíkëe ay ron wolaꞌ yonente ti soꞌ nen, bi ay ɗúhée heedon. Yii won ɗi ron ɓéeɓ, lah síkíríi rí. ");
INSERT INTO ndv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Te ɓëyí fí síkírëey yonentii baa ɓéeɓ, ii nonlil ɓëewí Koope, ɗi hawu húl.” ");
INSERT INTO ndv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Te yonente ya ɓéeɓ, dalaꞌte Samiyel tíkëhté ƴee ayu filooni ra ɓéeɓ, wonute yii leŋke bissi ƴeh. ");
INSERT INTO ndv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yee gapaꞌ Koope ñeyaꞌte ri yonente ya ra bi ron ɓal, te ɗon lahute woɗ filiɓ yee pok Koope hanndal ki ɓani caaccon, na won ɗi Abraham bitih⁠ ⁠: “May ñeyee ow yínë talu, mi barkel ɓëewë feey fa ɓéeɓ.” ");
INSERT INTO ndv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɗaaha, af ɗon daa ɗéɓpí tah Koope cépíɗ súrgíi. Ɗi wolte ri barkeli ron, ow fi ow ɗon na ɓéeɓ súugëh pagaɗɗi ɓossi.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bi homu Peer a Saŋ na wonu a ɓëewë di Faam fi gaani Koope, seeƴoh ya, kélfíi wohoh yi Faam fi gaana a saduseŋŋa ayute. ");
INSERT INTO ndv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ɗeefuu wa Peer a Saŋ na waariyu ɓëewë biti di këllúu Yéesú ɓúudé, ɓëewë gémú ɗii na ra ay këllúu ɓúudé ɗaaha ra, keeññi wa haayte. ");
INSERT INTO ndv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tígí daaha, wa habute wa, téƴúté wë. Bi dal Koo ñúkúf, wa yefute wa daaha níi kéy fín fë. ");
INSERT INTO ndv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Filiɓ fi baaha ɓéeɓ, ow caak di ɓëewë na húmú síkírúu iña wonu apootarra ra gémúté. Ɓëewë gémú rë warutee mit ow júnní iip (5.000). ");
INSERT INTO ndv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kéy fín fë, kélfë yí yëwúɗɗë, ɓaha ya gina a yëeddëh yí kootii Mëyíis teeꞌuute Yerusalem. ");
INSERT INTO ndv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Filiɓ fi wa, Haan seeƴohi gaana húmú në, Kayif, Saŋ, Iliksaan a ɓëy faam seeƴohi gaana ɓéeɓ. ");
INSERT INTO ndv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wa kalluute Peer a Saŋ kúrúté fíi wë, wa meelute wa wonu tih⁠ ⁠: «⁠ ⁠Daa yeɗ ɗon sañ-saña paƴuu ɗon lëfëñídí bee ra⁠ ⁠? Daa nah ron ri⁠ ⁠?⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peer yíppée líif a Ruuh-Peseŋ, won wa tih⁠ ⁠: «⁠ ⁠Kélfë yí ƴeh⁠ ⁠! Ɓaha yi ƴeh⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Hém paƴa paƴu fun lëfëñíɗ ɗë daa tah fun tëekɗú këem woteh raa, ");
INSERT INTO ndv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ɗon fi ƴeh, a ɓëy tali Israyel ɓéeɓ, yúhí biti yee tah ɓëyí bee wah níi caŋ fíiyën rë, ow kay neh daa tah ɗi koloh⁠ ⁠: Yéesú-Kiristaa fi ɓëy Nasaret doŋ, bee ɗon húmú daaƴu ri kurwah, Koope këlíɗté rí ɓúudé rë daa tah. ");
INSERT INTO ndv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yéesú daa ɓëeꞌ në wonaꞌ Téerëe bitih⁠ ⁠: “Laꞌa habuu taɓahoh ya biti lahay njiriñ ra daa míllëꞌ ham lasa.” ");
INSERT INTO ndv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Daa ri mín yen sëmlëꞌ kut⁠ ⁠: henay ri, lahay ɓëyí ee feey fi bee mín yen sëmlëꞌ.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Oluu ɓëy këemí gaana ɗee na wonuu Peer a Saŋ te wa ɓëewí jaŋiyuy, yíih yin ra, wa éemúté níi éem. Wa yúhúté biti ɓal wani Yéesú daa na húmú ñéerúu. ");
INSERT INTO ndv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wa olute ɓëeꞌ paƴu ra caŋke hëbís Peer a Saŋ ɓal, tígí daaha, wa lahluy yii wonun wa. ");
INSERT INTO ndv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wa nahuute ɗúhrí wë ëssín, wa na anuu wonantaꞌ filiɓ fi wa tih⁠ ⁠: ");
INSERT INTO ndv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«⁠ ⁠Yen ay hene ɓëewí ƴee ɗíh⁠ ⁠? Biti wa pagute kimtaan wëerté ɓëy Yerusalem ɓéeɓ te yen míníh ríi kaaꞌ. ");
INSERT INTO ndv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ndaa yen warutee paŋ níi yaa ɓanti líiwëlsëꞌ gina⁠ ⁠: yen hëɓël wë, wa ɓanti won ow yii leŋke Yéesú fí bah.⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tígí daaha, wa dëekrúuté Peer a Saŋ, kadduute wa ɓiiƴ wonu wa tih⁠ ⁠: «⁠ ⁠Níi ɗon won ow mbée ɗon waare yii leŋke tii Yéesú rek⁠ ⁠!⁠ ⁠» ");
INSERT INTO ndv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peer a Saŋ wonu wa tih⁠ ⁠: «⁠ ⁠Ëlsíi yee lukki ñee waal ra, ɗon won nda fun waɗti síkírúun ɗon mbée Koope⁠ ⁠! ");
INSERT INTO ndv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Fun déꞌ, fun yúhúté biti fun míníh héddëh yee olu fun a yee keluu fun ra.⁠ ⁠» ");
INSERT