﻿USE sofia;
DROP TABLE IF EXISTS sofia.ndj_vpl;
CREATE TABLE ndj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ndj_vpl WRITE;
INSERT INTO ndj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kilistu afumili mulukolu lwa Dawudi na Dawudi afumili mulukolu lwa Ibulahimu. Alu ndi lulalanda lwa lukolu lwaki. ");
INSERT INTO ndj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibulahimu kamulela Isaka na Isaka kamulela Yakobi na Yakobi kamulela Yuda na vakulumundu. ");
INSERT INTO ndj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda amlelili Pelesi na Zela, mawau aveli Tamali. Pelesi kamulela Hesilomi, na Hesilomi kamulela Lami na ");
INSERT INTO ndj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lami kamulela Aminadabu na Aminadabu kamulela Nashoni na Nashoni kamulela Salumoni na ");
INSERT INTO ndj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salumoni kamulela Boasi, mamundu Boasi aveli Lahabu. Boasi na Lutu vaveli valeli va Obedi. Na Obedi kamulela Yesi. ");
INSERT INTO ndj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi kamulela Mutwa Dawudi. Na Dawudi kamulela Solumoni, mawaki Solumoni mwanja mtasi aveli mdala wa Uliya. ");
INSERT INTO ndj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solumoni kamulela Lehoboamu na Lehoboamu kamulela Abiya na Abiya kamulela Asa, ");
INSERT INTO ndj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","na Asa kamulela Yehoshafati na Yehoshafati kamulela Yolamu na Yolamu kamulela Usia. ");
INSERT INTO ndj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Na Usia kamulela Yofamu, na Yofamu amlelili Ahasi, na Ahasi kamulela Hezekia. ");
INSERT INTO ndj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Na Hezekia kamulela Manasi, na Manasi kamulela Amosi, na Amosi kamulela Yosia. ");
INSERT INTO ndj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Na Yosia kamulela Yekomia na vahaja vaki fyosi afi fyaveli chipindi Vayawudi pavatoliwili vavanda kuyenda Babiloni. ");
INSERT INTO ndj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Vayawudi pavatoliwili kala kuuvanda kuluhamila aku Babiloni, Yekonia kamulela Shealitieli, Shealitieli kamulela Zelubabeli. ");
INSERT INTO ndj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Na Zelubabeli kamulela Abyudi, na Abyudi kamulela Eliyakimu, na Eliyakimu kamulela Azoli. ");
INSERT INTO ndj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli kamulela Sadoki na Sadoki kamulela Akimu na Akimu kamulela Eliyudi. ");
INSERT INTO ndj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudi kamulela Eliyazali na Eliyazali na mweni kamulela Matani na Matani kamlela Yakobi. ");
INSERT INTO ndj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobi kamulela Yosefu bambu waki Maliya na Maliya kamulela Yesu yivamkema Kilistu. ");
INSERT INTO ndj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Topi kwavelili na fileli lilongu na mchechi kukandila Ibulahimu mbaka Dawudi, Fileli lilongu mchechi tangila Dawudi mbaka kuluhamila kula Babiloni, kwaveli na fileli lilongu na mchechi kukandila kutoliwa kuyenda kula Babiloni mbaka chipindi cha Kilistu Mgombola. ");
INSERT INTO ndj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Topi ndi wawonikili Yesu Kilistu. Maliya mamudu Yesu aveli nondi ya Yosefu. Ngajila tanila kumufika amanyikili kala kucha aveli na suliya yapatili kwa uwesu wa Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosefu nondi yaki Maliya aveli goleki, alemili kumupa soni nondi waki pawelu. Kwanongwa ayi ayiholili amuleki kwa chifisu. ");
INSERT INTO ndj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Paghaveyi akwihola chilongu achi, topi, makungu wa Bambu kamwisila mung'onju, kamuwombela, “Yosefu wa lukolu lwa Dawudi kotoo kutila kumheta Maliya kwanongwa kana suliya kwa uwesu wa Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Dayihongeshi mwana mlumi na yuwi dawumupi litawa Yesu, kwanongwa mweni ndi davalowoli vandu vaki kufuma mu sambi shawu.” ");
INSERT INTO ndj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Topi afi fyosi fiva ili chivi chila chilongu cha detili Bambu kwa lishu lya mbuyi wa Chapanga kucha, ");
INSERT INTO ndj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Muyenji dayimi yinda na daamuleli mwana mlumi na davamkemi litawa lyaki Imanueli” Mana yaki, “Chapanga kava pamu na yufwi.” ");
INSERT INTO ndj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Topi, Yosefu payimukili, kamuheta Maliya kucha makungu wa Bambu Chapanga wamuwombilili. ");
INSERT INTO ndj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yosefu kawonja ha na Maliya mbaka pawonikili mwana. Topi Yosefu kamupa litawa lya Yesu mwana yula yawonikili. ");
INSERT INTO ndj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu awonikili mumbwani ya Betelehemu, mumkowa wa Yudeya, chipindi cha Helodi paghavaya mutwa. tepu, vandu yivasikawula ndondwa vafikili Yelusalemu kufuma kundamba. ");
INSERT INTO ndj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Vadasha, “kava koti mwana yawonikili daghavi mutwa wa Vayawudi? Tuyiwona ndondwa yaki payibwitukili kundamba, tuyisa kumutundamila.” ");
INSERT INTO ndj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mutwa Helodi papikanishili afi, ang'ong'utekili nendu, mweni pamu na vandu vosi va Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Topi, kavakema vatambika vakomi vosi pamu na vawula va Malawu kavadasha, “Kilistu Mgombola dawonikeli koti?” ");
INSERT INTO ndj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Veni vamuyangula, “Dawonikeli kumbwani Betelehemu, mkoa wa Yudeya. topi ndi wayandikili mbuyi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yuwi Betelehemu mlima wa Yuda, kuva mkomi gati ya mbwani sha Yuda, nongwa kwa yuwi dabwituki chilongosi, davalongoshi vandu vangu, Vayisilaeli.’ ” ");
INSERT INTO ndj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Topi Helodi avakemili vasimanyili ndondwa kwa chifisu ili vamumanyishi chipindi choti nakaka ndondwa payibwitukili. ");
INSERT INTO ndj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pambeli kavalayila Betelehemu padeta, “Muyendi mukakombikeshi kwa chiganu nongwa ya mwana ayu. Pamumuwona mwisi kung'ombela na nenga nyendi ngamutundamili.” ");
INSERT INTO ndj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pavapikanishili kala filongu fya Mutwa vayendilela na mwanja na yila ndondwa yivayiwonili kundamba yivalongulela, payiyenda mbaka yiwoloka pambindi ya pavelili mwana. ");
INSERT INTO ndj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pavawonili ndondwa vasekelela munu. ");
INSERT INTO ndj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Topi vayingila munyumba, vamuwona yula mwana pamu na Maliya, vawa vamtundamila, pambeli vawopola mbembu shawu vamupa fupu: chumang'andu na ubani na mafuta vatalamili yivavakema manimani. ");
INSERT INTO ndj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chapanga avakayikili vala yivayisili kumlola mwana Yesu vakotoo kumuwuyila Helodi, topi vawuya kaya kupitila deha yingi. ");
INSERT INTO ndj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pavawukili kala vala vahenja, Topi makungu wa Bambu Chapanga amfumbukilili Yosefu mung'onju, kamuwombela, “Tandamuki! Umtoli mwana pamu na mamundu, mutuvili Misili mukayikali aku mbaka pandivawombela, kwanongwa Helodi akwilata amuwulayi mwana ayu.” ");
INSERT INTO ndj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Topi Yosefu atandamukili, kamtola mwana pamu na mamundu pamihi yiyila yila, vawuka vayenda Misili. ");
INSERT INTO ndj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kayikala aku mbaka Helodi pasovili. Topi, chilongu chadetili Bambu kwa deha ya vambuyi wa Chapanga fiva, “Ndamkemili mwana wangu kufuma Misili.” ");
INSERT INTO ndj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helodi pamanyili kucha vala vasimanyili ndondwa vaveli vamujanga, akalalili munu. Alayishili vana valulumi vosi mumbwani ya Betelehemu na vala yivaveli mumbali mbali yaki yivaveli na myaka mivili na pasi ya mwaka mivili vawulaghiwi. Agolili nahau ngimu wakashili chipindi cha vala vasimanyili ndondwa pavadashili milandu ya mwana. ");
INSERT INTO ndj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nahawu ndi wuyivelili chilongu chila chadetili mbuyi wa Chapanga Yelimiya, ");
INSERT INTO ndj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lishu lipikanika aku Lama, chivembu na kudedeka nendu. Raheli akuvalilila vana vaki. Wala akudayila ha kushisha moyu, kwanongwa vosi vayaghamila.” ");
INSERT INTO ndj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helodi asovili kala, topi makungu wa Bambu amubwitukilili Yosefu mulilotu kula Misili. ");
INSERT INTO ndj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kamuwombela “Tandamuki! Mtoli mwana na mamundu muyendi Mlima wa Isilaeli, nongwa vala yivadayileyi kumuwulagha mwana ayu vasova kala.” ");
INSERT INTO ndj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Katandamuka kamtola mwana pamu na mamundu vawuya kumlima wa Isilaeli. ");
INSERT INTO ndj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lakini papikanishili kucha Alikelau aveli mutwa wa Yudeya badili ya Helodi tatimundu, aveli akutila kuyenda aku. Mweni pavamukayikili mumilotu ayendili mwambu wa Galilaya. ");
INSERT INTO ndj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kayenda ayikalili mumbwani ya Nazaleti nahau ndi wufivelili filongu fyawombili kwa deha ya Vambuyi “Davamkemi mundu wa Nasaleti.” ");
INSERT INTO ndj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Majuva vala Yohani Mbatisha abwitukili: palandula kuchivala aku Yudeya: ");
INSERT INTO ndj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mweni kawomba, “Mupomeli sambi nongwa wutwa wa kumbindi kwa Chapanga samba wisa.” ");
INSERT INTO ndj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohani ayu ndi yula Isaya yaveli mbuyi wa Chapanga yamudetili: “Mundu yumu akukema kucheja: ‘Mutandi njila ya Bambu, Muhololi deha yaki.’ ” ");
INSERT INTO ndj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohani mbatisha afwalili yingwa sivasonili kwa mingoma ya ngamia. Na lufunga lwa ngwembi muchiwunu chaki. Filivi fyaki fyaveli vangumbingumbi na njuki. ");
INSERT INTO ndj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Topi, vandu kufuma Yelusalemu na kufuma mbembi shosi sha mlima wa Yudeya pamu na mbembi shosi sha mumbali mbali ya lweni Yoludani, vamuyendela. ");
INSERT INTO ndj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Vayipetili sambi shawu na mweni kavabatisha mulweni Yoludani. ");
INSERT INTO ndj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lakini pavawonili Mafwalisayu na Masadukayu vakumwisila ili vabatishiwi. Kavawombela, “Yumwi vanjoka! Ghani yavapwepwilili mwilyepi na asabu yiyisayi?” ");
INSERT INTO ndj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mulangushi kwa fivelekwa kucha mupomela. ");
INSERT INTO ndj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mukotoo kuyihola kucha damuyilyepi asabu nongwa tati wenu ndi Ibulahimu! Nguvawombela Chapanga akuwesha kuyigola migonguveli ayi yivi vana va Ibulahimu. ");
INSERT INTO ndj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Topi, livawu liva kala kudumula mikigha ya libiki, ndamboyi kila libiki lingajila kulela fivelekwa finofu likudumuliwa na kudangiwa mumotu. ");
INSERT INTO ndj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nenga nguvabatisha kwa machi kulangusha kucha mupomela. Lakini yula dayisi kumbeli ya nenga yaveli na liwovi pitu nenga. Nenga ngujakwa ha hata kupapa filatu fyaki. Mweni davabatishi kwa Mfuki Mng'alili na kwa motu. ");
INSERT INTO ndj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mweni akukamula luselu mumawoku vaki dafyaghili nendu luvagha lwaki na dakungi mbeyu shaki musanja na myeyu akwinyanya mumotu wungajila kujimika ");
INSERT INTO ndj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chipindi achi Yesu ayisili kufuma Galilaya kayenda mulweni Yoludani abatishiwi na Yohani mbatisha. ");
INSERT INTO ndj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lakini Yohani mbatisha ayeshili kumkanila padeta, “Nenga ngudayila kubatishiwa na yuwi, kandi na yuwi ukwisa kwa nenga?” ");
INSERT INTO ndj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lakini Yesu kamuyangula, “Yuwi ujumili hela kwanongwa tugoli fyosi fyadayila Chapanga.” Topi Yohani ajumilili. ");
INSERT INTO ndj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu pabatishiwi kala, bahala pala kajabuka mumachi topi kumbindi kwa Chapanga kufuwuka kamuwona Mfuki wa Chapanga pasunuka kucha njiva na kumtula pambindi yaki. ");
INSERT INTO ndj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lishu kufuma kumbindi kwa Chapanga lideta, “Ayu ndi mwana wangu yindimtamili mayiliwa na mweni.” ");
INSERT INTO ndj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pambeli Mfuki Mng'alili amulongushili Yesu mbaka kucheja ili ayeshiwi na Lijangavandu. ");
INSERT INTO ndj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kayikaja kulya majuva milongu mchechi pamusi na pamihi, pambeli kawona njala. ");
INSERT INTO ndj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Topi, Mwafu kamwisila, kamuwombela “Leki yuwi kuva Mwana wa Chapanga nakaka, deti migonguveli ayi yivi filivi.” ");
INSERT INTO ndj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu kamuyangula, “Yiyandikiwa mumayandiku Vang'alili. Mundu akwikala kwa kulya filivi weka hela ha, ila kwa chilongu chochosi chadeta Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pambeli Lijangavandu kamtola mbaka Yelusalemu, mbwani ying'alili, kamvika pambindi ya mnala wa nyumba ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kamuwombela, “Leki nakaka yuwi kuva mwana wa Chapanga, widangi pasi, kwanongwa yiyandikiwa mumayandiku Vang'alili ‘Chapanga davalayishi makungu vaki vakuyangi mumawoku vawu, ukotoo kuponikela mumigonguveli’”. ");
INSERT INTO ndj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kavawombela, “Yiyandikiwa mumayandiku Vang'alili, ukotoo kumuyesha Chapanga, Bambu waku.” ");
INSERT INTO ndj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pambeli Lijangavandu kamtola mbaka pambindi ya chidunda chitali, kamlangusha wutwa shosi na ukomi waki. ");
INSERT INTO ndj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Lijangavandu kamuwombela, “Fyosi afi ngukupa pawundundamila.” ");
INSERT INTO ndj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Topi Yesu kamuwombela, “Kopoki apa Lijangavandu! Yiyandikiwa mumayandiku Vang'alili mtundamili Chapanga Bambu waku na kumkimbanikila mweni hela.” ");
INSERT INTO ndj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Topi, Lijangavandu kawuka kamuleka Yesu na makungu vayisa, kumukimbanikila Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu apikanilili kucha Yohani mbatisha vamutatila muchijaka, ayendili Galilaya. ");
INSERT INTO ndj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Awukili Nasaleti, kayenda kwikala mumbwani ya Kapelinaumu, muluwongu ya lihiva lya Galilaya mumbaka ya wilaya ya Sebuloni na Nafutali. ");
INSERT INTO ndj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ayi yagolikili ili chila chilongu chadetili mbuyi wa Chapanga Isaya chivi, ");
INSERT INTO ndj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mlima wa Sebuloni na mlima wa Nafutali yavelili mudeha ya kuyenda kulihiva lya Galilaya mwambu ya lweni Yoludani na mumlima wuvayikala vangajila kuva Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Vandu vayikalili kuchisi, vawonili lwengi lukomi. Na vala vayikalili mulisisi lya njifwa, lwengi luvang'alikila!” ");
INSERT INTO ndj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kukandila chipindi achi Yesu akandili kulandula, padeta, “Mupomeli, kwanongwa wutwa wa kumbindi kwa Chapanga wuva pabehi!” ");
INSERT INTO ndj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","“Yesu patyangeyi muluwongu lwa lihiva lya Galilaya, avawonili vandu vavili yivavelili ulongu. Vavelili Simoni yivamkema Petili pamu na Andeleya, vaveli mulihiva vakufuva vasomba kwa lwafu. Veni vaveli vafuva. ");
INSERT INTO ndj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu kavawombela, mungovikeli, nenga danivagoli muvi vafuva va vandu.” ");
INSERT INTO ndj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bahala pala, vasileka njafu shawu, vamukovikela Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Payendili pawulongolu, kavawona vandu vengi vavili yivavelili ulongu, vavelili Yakobi na Yohani vana va Sebidayu, veni vavelili muwatu pamu na tati wawu pavasambula njafu shawu. Yesu kavakema. ");
INSERT INTO ndj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tepu vawulekili watu pamu na tati wawu, vamukovekela Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu aveli akuyendayenda mumlima wosi wa Galilaya. Pawula munyumba sha kudadavila na kulandula Chilongu cha nyanyi cha wutwa wa kumbindi kwa Chapanga na kulowola matami kafwauti kafwauti. ");
INSERT INTO ndj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Milandu yaki yakwilili mumlima wosi wa Siliya, vamuyeghela vandu vosi yivavelili na matami, vala yivavelili vakutamika na kuteshiwa, yivavelili na matami va finyamkela na chisilika na vapombalili vamuyeghilili na mweni kavalowola vosi. ");
INSERT INTO ndj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mipinga mikomi ya vandu yamukovikelili kufuma Galilaya na Dekapoli, mbwani yikemiwili Mbwani Lilongu na kufuma Yelusalemu na kufuma Yudeya na kufuma mbembu yingi ya Yoludani. ");
INSERT INTO ndj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu paliwonili lipinga lya vandu, akwenili kuchidunda, kayikala. Vanachuli vaki vamushengitela. ");
INSERT INTO ndj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pambeli kakanda kuvawula, ");
INSERT INTO ndj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Vanemiliwa vala yivayimanya kucha veni vakuwesha ha kwikala ngajila Chapanga! Nongwa wutwa wa kumbindi ndi wawu. ");
INSERT INTO ndj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Vanemiliwa vala yivavelili na lung'ong'u, Nongwa Chapanga davavafwamushi. ");
INSERT INTO ndj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Vanemiliwa vala vashishamoyu, nongwa ava ndi davahali mlima wa shonu. ");
INSERT INTO ndj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Vanemiliwa vala yivavelili na njala na yivayikaja kulya kwanongwa ya ugoleki, Chapanga davayikutishi. ");
INSERT INTO ndj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vanemiliwa yivaveli na lusungu, Chapanga davawoneli lusungu. ");
INSERT INTO ndj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Vanemiliwa vala yivamtama Chapanga kwa ndima yawu yosi, nongwa davamuwoni Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Vanemiliwa vala yivavika kusika, kwanongwa davakemiwi vana va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Vanemiliwa vala vagobuleka kwanongwa ya ugoleki, kwanongwa wutwa wa kumbindi ndi wa veni. ");
INSERT INTO ndj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Munemiliwa yumwi vandu pavavajowola na pavavasulumu na pavavapayishila findu fyosi fya wafu kwanongwa ya nenga. ");
INSERT INTO ndj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Musekileli na kunemelela kwanongwa fupu yenu ngomi kumbindi kwa Chapanga, nongwa pavavasulumili vambuyi ngimu yimusulumiwa ponopawu yumwi.” ");
INSERT INTO ndj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu kadeta, “Yumwi muva munyu wa mlima lakini munyu pawuyaghamisha chinosi chaki dayinoghishiwi na liki? Yikujakwa chindu kandi ha, ila yikuyasiwa hela na vandu vayivatangi. ");
INSERT INTO ndj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Yumwi muva lwengi lwa mlima awu! Mbwani yivajengili pachidunda yikufisika ha. ");
INSERT INTO ndj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kwahela mundu yanamika luliku na kulugubika kwa chiyungu, ila ukuluvika kumbindi ya pachindangawala ili yivang'alikili vosi yivaveli munyumba. ");
INSERT INTO ndj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wuwowu luliku lwenu lulikili vandu, ili vafiwoni figoli fyenu finofu, vamujumi Tati wenu yaveli kumbindi. ");
INSERT INTO ndj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mukotoo kwihola kucha nyisa kuwusha Malawu va Chapanga vamupili Musa na mayandiku va vambuyi, ila nyisa kugola fivi. ");
INSERT INTO ndj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nakaka nguvawombela, kumbindi na mlima dawufipeli, lakini kwahela hata liyandiku limu wala lilawu daliwushiwi, mbaka fyosi fivi. ");
INSERT INTO ndj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yoyonda davifyi hata lilawu limu lidokwa pitu vosi na kuvawula vamonga vavifyi, ayu daghavi mdokwa nendu muwutwa wa kumbindi kwa Chapanga. Lakini yula daavakamuli na kuvawula vengi, ayu daghavi mkomi muwutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nguvawombela, ugoleki wenu pawuyongisheka ng'odu pitu wula wa Mafwalisayu na vawula va Malawu, damuyingili ha muwutwa wa kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mupikanila kala kucha vandu va pakwandi vawombiliwili, ‘Ukotoo kuwulaya! Yula dawulayi dahighiwi.’ ");
INSERT INTO ndj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lakini nenga nguvawombela, yoyosi yamukalalila mlongu mundu, ahighiwi. Yamubedala mlongu mundu dayeghiwi kuchitemela. Yamukema mlongu mundu ‘Mpufi’ kava munjifwa ya kuyingila mulifumbika. ");
INSERT INTO ndj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Topi, pawuyegha fupu yaku pafyalu na pawukumbuka kuva na shoshu na mlongu waku, ");
INSERT INTO ndj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yileki fupu yaku pawulongolu pafyalu, yendi mukajovi tanila na mlongu waku, pambeli wuyi utawuli fupu yaku. ");
INSERT INTO ndj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mjovi na muhighi waku kalopu pamuva mkali mudeha pamuyenda kuchitemela. Leki pawugola naha ng'odu muhighi waku dakuyeghi kwa muhigha na muhigha dakuyeghi kwa vadima na yuwi davakuwopi muchijaka. ");
INSERT INTO ndj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nakaka ngukuwombela, dawufumi ng'odu mula mbaka uhombi ligwala lya mwishu.” ");
INSERT INTO ndj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mupikanisha kucha vandu vavawombilili, ‘Mukotoo kugola uwoni!’ ");
INSERT INTO ndj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lakini nenga nguvawombela, yamulola mdadala kwa dobukelu, kawonja nayu kala mundima yaki. ");
INSERT INTO ndj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Topi, lisu lyaku lya mlilu palikugola ugoli uvifyi, wulikolopoli kaliyasili kutali. Ngiba yuwi uyaghamishi chimu mumvili waku, pitu kuyasa mvili waku wonda mulifumbika. ");
INSERT INTO ndj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kucha liwoku lyaku lya mlilu palikuvifya, ulidumuli uliyasi kutali. Ngiba yuwi uyaghamishi chindu chimu cha mvili waku pitu mvili waku wosi ugwijuki mulifumbika.” ");
INSERT INTO ndj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Yiwombiwa kala, ‘mundu yamuleka mwehi waki, yamugayilili talaka.’ ");
INSERT INTO ndj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lakini nenga nguvawombela, yamugayila mwehi mundu talaka ila kwanongwa yoyosi yingajila uwoni akuvifya kumugola ayu mdala agoli uwoni. Pambeli mlumi yamuheta mdala yula alekiwili na mweni akugola uwoni.” ");
INSERT INTO ndj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kandi mupikanila kucha vandu va pakwandi vawombiwili, ‘Ukotoo kuleka malapu vaku, lakini ugoli malapu vaku kwa Bambu.’ ");
INSERT INTO ndj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lakini nenga nguvawombela, mukotoo kwilapa, kwa kumbindi kwa Chapanga, kwanongwa chila ndi chigoda cha wutwa wa kumbindi kwa Chapanga, ");
INSERT INTO ndj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kandi mukotoo kwilapa pamlima kwanongwa ndi chigoda chaki cha kuvikila mawulu na mukotoo kwilapa hata kwa Yelusalemu kwanongwa ndi mbwani ya wutwa mkomi. ");
INSERT INTO ndj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kandi kotoo kwilapa kwa mutwi waku kwanongwa ukuwesha ha kulugola lufwili lumu luvi lukeli awu lutitu. ");
INSERT INTO ndj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pawudeta, ‘yina’ yivi yina na ‘Ng'odu’ yivi ng'odu topi chochosi dachiyongisheki chikufuma kwa yula mwafu.” ");
INSERT INTO ndj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mupikanisha kucha yideteka, ‘Lisu kwa lisu, linu kwa linu.’ ");
INSERT INTO ndj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lakini nenga nguvawombela, ukotoo kumugolela Lugotu mundu mwafu. Mundu pakuvangula likanja lya mlilu mughalambulili na likanja lya mkiyi. ");
INSERT INTO ndj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mundu pakuyegha kuchitemela kucha kakutolela gwanda yaku, mleki atoli na lihabiti lyaku. ");
INSERT INTO ndj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu pakung'ang'anika kupapa msiwu waki mwanja wumu, yuwi yendi kavili. ");
INSERT INTO ndj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mundu pakakuluva umupi, kotoo kumupa chisowu mundu yadayila kukopa chindu. ");
INSERT INTO ndj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mpikana kucha vadeta, ‘Mtami mjofi waku na kumunyekwa chimudwama waku.’ ");
INSERT INTO ndj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lakini nenga nguvawombela muvatami vachimdwama venu na kuvadadavila kwa Chapanga vala yivavasulumu yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ili muvi vana va Tati wenu yaveli kumbindi. Kwanongwa mweni akuvavalila lijuva vandu vawafu na vanofu na kuvatonyela ndonya vandu goleki na va wafu. ");
INSERT INTO ndj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Damupati fupu liki kwa kuvatama vala yivavatama yumwi hela? Kwahela! Kwanongwa hata vala vasumula vakugola wuwowu! ");
INSERT INTO ndj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kucha pamuvajambusha vaghanja venu hela, mukugola chindu ng'odu? Hata vandu vangajila kumumanya Chapanga vakugola wuwu. ");
INSERT INTO ndj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Topi mugoleki vasangi kucha Tati wenu yaveli kumbindi waveli msangi.” ");
INSERT INTO ndj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwivavali mukotoo kugola figoli fyenu fya ugoleki pawulongulu ya vandu ili mumanyiki. Pamugola naha Tati wenu yaveli kumbindi davapi ng'odu fupu. ");
INSERT INTO ndj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Topi pawumtanga mgaju, kotoo kulandusha kwa vandu. Kotoo kugola kucha mfyangu wagola munyumba sha kudadavila na mudeha ili vandu vavajumi. Nakaka nguvawombela, ava vapata kala fupu shawu. ");
INSERT INTO ndj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lakini yumwi pamuvatanga vagaju, hata wa chimbundi chimu akotoo kumanya, lakini pawumtanga, hata mundu yuummanyili akotoo kumanya chiwugolili. ");
INSERT INTO ndj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tawuli utangi waku kwa chifisu na tati waku yalola findu fifisikili fiwugola, dakufupi. ");
INSERT INTO ndj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pamudadava mukotoo kugola kucha vafyangu. Veni vakudayila kuwoloka na kudadava munyumba sha kudadavila na mumaleka ili vandu vavaloli, nakaka muvawombeli ava vapata kala fupu shawu shosi. ");
INSERT INTO ndj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lakini yuwi pawudadava, wingili munyumba yaku, tati mlyangu, pambeli muluvi Tati waku yangajila kuwoneka. Na mweni yalola fifisikili daakufupi. ");
INSERT INTO ndj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pamudadava, mukotoo kudeta fitangalili fingajila nongwa kucha vandu vangajila kumumanya Chapanga. Veni vakwihola kucha vamulungu vawu daavapikanishi kwanongwa ya filongu fyawu fitangalili. ");
INSERT INTO ndj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mukotoo kuva kucha veni. Tati wenu kamanya fimudayila hata yumwi mukalihela kumuluva. ");
INSERT INTO ndj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Topi, tudadavi nga nahawu. ‘Tati wetu yuuveli kumbindi, litawa lyaku lijumiwi. ");
INSERT INTO ndj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Wutwa waku wisi, liwudayila ligoleki apa pamlima ngimu wuligoleka kula kumbindi. ");
INSERT INTO ndj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utugayili filivi fya nalelu. ");
INSERT INTO ndj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tupomeli fituvifyili, ngimu yufwi wutuvapomela vala vatuvifyili. ");
INSERT INTO ndj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kotoo kututaya munyeshiwu, lakini wutuwilyepeshi na yula mwafu. Kwanongwa wutwa ndi waku na liwovi na ukomi mbaka jola. Yina.’ ");
INSERT INTO ndj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kwanongwa pamuvapomela vandu fyavavifyili na yumwi wuwowu Tati wenu wa kumbindi davapomeli. ");
INSERT INTO ndj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lakini pamuvapomela ng'odu vandu fyavavifyili na yumwi Tati wenu davapomeli ng'odu fimuvifyili. ");
INSERT INTO ndj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pamuyikaja kulya, mukotoo kuva na lung'ongu kucha vafyangu, veni vakukikinala kuwushu ili vandu vavawoni kucha veni vakwikaja kulya, nguvawombela nakaka, ava vapata kala fupu yawu. ");
INSERT INTO ndj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lakini yuwi pawuyikaja kulya navi wushu waku na shaghi mafuta mutwi waku, ");
INSERT INTO ndj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ili mundu yoyosi akotoo kumanya kucha yuwi ukwikaja kulya. Ili umanyiki hela na Tati waku yangajila kuwoneka na yalola fifisikili na mweni dakugayili fupu. ");
INSERT INTO ndj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mukotoo kulunda mali apa pamlima pavelili sondu na kutu fikuyananga na vefi vakwingila na kuhija. ");
INSERT INTO ndj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mulundi mali kumbindi kwa Chapanga kungajila sondu na kutu ya kuyananga, wala vefi kuyingila na kuhija. ");
INSERT INTO ndj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwa nongwa pala pawulundili mali shaku na moyu waku dawuvi bahala. ");
INSERT INTO ndj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Lisu kucha lwengi lwa mvili waku. Leki lisu lyaku linofu na mvili waku wosi dawuvi mulwengi. ");
INSERT INTO ndj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lakini lisu lyaku palivifya, muvili waku wosi dawuvi mulwisa. Topi, payiva lwengi luveli mugati yaku luva mulwisa, topi ndi lwisa totolu! ");
INSERT INTO ndj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kwahela mundu yawesha kuvakimbanikila vabambu vavili. Mana damuleki yumu na kumutama yula monga, awu damukovikeli yumu na kumubedala yula yumu. Muweshi ng'odu kumukimbanikila Chapanga na mbiya kwa chipindi chimu. ");
INSERT INTO ndj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ndi nongwa nguvawombela, mukotoo kuva na chipwembwi kucha damulyi liki na damlandi liki ili mwikali awu kucha damufwali yingwa liki, unofu ndi utalama pitu filivi. Na mvili utalama pitu filivi na yingwa? ");
INSERT INTO ndj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Muvaloli vambongu, vakukweta ng'odu, wala vakubena ng'odu na vavahela lusanja. Hata naha, Tati wenu wa kumbindi akuvakutisha. Topi, yumwi mtalama pitu ava. ");
INSERT INTO ndj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wuli? Ghani gati ya yumwi kwanongwa ya chipwembwi chikomi, akuwesha kuyongesha mweni majuva va kuyikala? ");
INSERT INTO ndj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nongwa liki mukuyihola kuyilata yingwa? Muloli uluva ndambu yiwukula na pawunemuna. Wukugola ha chichuku wala kugola. ");
INSERT INTO ndj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lakini nguvawombela, hata Solumoni mweni na ulundamali waki wosi kafwala kamu ha fivayilili kucha uluva wumu. ");
INSERT INTO ndj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Leki payiva Chapanga akulifwalisha lidasi livelili nalelu na chilawu likuyasiwa mumotu, ponopa akuvagolela yumwi vandu finofu nendu? Yumwi vandu yimuvelili na ujumilwa mdokwa! ");
INSERT INTO ndj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Topi, mukotoo kuyihosha kucha ‘datulyi liki? Datulandi liki? Na datufwali liki? ");
INSERT INTO ndj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nongwa fyosi afi ndi fikudayiliwa na vandu vangajila kumumanya Chapanga. Lakini yumwi Tati wenu wa kumbindi kamanya kucha mukudayila findu fyosi afi. ");
INSERT INTO ndj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Topi, muyiholi tanila wutwa wa kumbindi kwa Chapanga na fila fyadayila Chapanga na mweni davagayili fimonga fyosi. ");
INSERT INTO ndj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Topi, mukotoo kuva na chipwembwi kwa chilawu, chilawu kuuveli msayisayi waki. Misayisayi ya lijuva limu, vakukwila kwa lijuva ali. ");
INSERT INTO ndj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mukotoo kuvahigha vengi na yumwi damuhighiwi na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chapanga davahighi yumwi nga wuwula wula wumuvahigha vayenu na chigelu chichila chila chimuvalingilili vayenu na Chapanga daavalingili yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nongwa liki ukuchiwona chibandi chiveli mulisu lya mlongu waku, lakini yikukupota kulola libalu livelili mulisu lyaku. ");
INSERT INTO ndj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ukuwesha wuliwuli kumuwombela mlongu waku kucha, ‘Leki nguwushi chibandi chiveli mulisu lyaku,’ kunu umweni kuna libalu mulisu lyaku? ");
INSERT INTO ndj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yuwi mfyangu! Wushi tanila libalu livelili mulisu lyaku pambeli leki uchiwoni chibandi chivelili mulisu lya mlongu waku. ");
INSERT INTO ndj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mukotoo kuvapa vagalu findu fing'alili vakuwesha kughalambuka na kuvakapula mwaveni, wala mukotoo kuvayasila vangubi findu fitawukili vakuwesha kufivatanga. ");
INSERT INTO ndj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Muluvi damugayiliwi, musaki damupati, mkuti mlyangu damufuwuliwi. ");
INSERT INTO ndj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwa nongwa yaluva akugayiliwa na yasaka dapati na yakuta mlyangu dafuwuliwi. ");
INSERT INTO ndj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wuli, kwaveli mundu yoyosi mwanamundu pamuluva filivi, damupi ligonguveli? ");
INSERT INTO ndj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Awu pakaluva somba, damupi njoka? ");
INSERT INTO ndj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Topi yumwi muva vandu va wafu mumanya kuvagayila vana venu findu finofu nakaka Tati wenu wa kumbindi, davagoleli yumwi nendu, davapi findu fya nyanyi vala vandu vosi yivamuluva! ");
INSERT INTO ndj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Fyosi fimudayila vandu vavagoleli yumwi, muvagoleli wuwowu veni, ayi ndi nongwa ya Malawu va Chapanga vamupili Musa na ng'ulilu ya vambuyi. ");
INSERT INTO ndj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mwingili kwa kupitila mlyangu wunyepili. Kwa nongwa deha yiyenda kulifumbika lingajila kujima ngomi na mlyangu wa kuyingililila amu umanuka na yivayenda deha ayi vatangala. ");
INSERT INTO ndj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lakini deha yiyenda kuunofu yiva dokwa na mlyangu wa kwingilila unyepa, vandu vadokwa hela davayiwoni deha ayi. ");
INSERT INTO ndj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mwikali mesu na vambuyi va udesi. Ava vakwisa kwa yumwi vakuva kucha vafungami kwa kuvalola, lakini mugati fingekembi fikalipili. ");
INSERT INTO ndj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Damuvamanyi kwa fila fivagola. Wuli, vandu vakunokola mindopi mumibiki ya misomi, awu ukuwesha kusola mikuyu mumitalula? Ng'odu! ");
INSERT INTO ndj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Topi libiki linofu likuveleka fivelekwa finofu na libiki lya wafu likuveleka fivelekwa fya wafu. ");
INSERT INTO ndj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Libiki linofu likuwesha ng'odu kuveleka fivelekwa fya wafu, wala libiki lya wafu likuveleka fivelekwa finofu ha. ");
INSERT INTO ndj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Libiki lingajila kuveleka fivelekwa finofu dandilidumuli na kuliyasila mumotu. ");
INSERT INTO ndj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ponopa damuvamanyi vambuyi va udesi kwa fila fivagola. ");
INSERT INTO ndj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mundu yoyosi yangema nenga ‘Bambu, Bambu,’ Dayingili muwutwa wa kumbindi kwa Chapanga ha, yuyula weka yagola fila fyadayilili Tati wangu yaveli kumbindi. ");
INSERT INTO ndj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lijuva lya kuhigha vatangalili davang'ombeli, Bambu, Bambu! Twalandulili filongu fyaku kwa litawa lyaku na kwa litawa lyaku twavawushili finyamkela na kugola mihilu yitangalili. ");
INSERT INTO ndj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Topi, dandivawombeli: ‘Yumwi ndivamanya ng'odu muwuki, muwuki pawulongolu yangu, yumwi yimushovilelili kugola fya wafu.’ ");
INSERT INTO ndj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ponopa mundu yoyosi yapikanisha filongu fyangu na kufikola, akwifwana na mundu yaveli na luhunja. Yajengili nyumba yaki pambindi ya ligonguveli. ");
INSERT INTO ndj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ndonya yitonya na nyeni siyitika liyegha lipugha na kuwumbila kunyumba ayi. Lakini yiwa ha kwanongwa vajengili pambindi ya ligonguveli. ");
INSERT INTO ndj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Lakini yoyosi yapikanisha filongu fyangu ngajila kufikola, akwifwana na mundu mpufi yajengili nyumba yaki mumuhanga. ");
INSERT INTO ndj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ndonya payitonyili na nyeni pasiyitikili na likumba palipughili na kulifikila nyumba ayi, yeni yiwa, kandi yiwa chakachaka!” ");
INSERT INTO ndj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu pamalilili kudeta filongu fila, lipinga lya vandu lijingwa na ng'ulilu yaki. ");
INSERT INTO ndj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kava kucha vawula vawu va Malawu ha, ila awulili kwa ukomi. ");
INSERT INTO ndj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu pasunukili kuchidunda, fipinga fya vandu fyamkovikelili. ");
INSERT INTO ndj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ayisili mundu yumu yaveli na ukalava. Kamugondamila padeta, “Bambu, pawudayila ukuwesha kung'ofuwa!” ");
INSERT INTO ndj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu katola liwoku lyaki kamugufya pambeli kudeta, “Ngudayila! yuwi ung'ofuwi.” Tepu mundu yula kalowoka utami waki wa mwiku. ");
INSERT INTO ndj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pambeli Yesu kamuwombela, “Pikani, kotoo kumuwombela mundu, yendi kayilangushi kwa mtambika na kutawula litambiku lilayishilwi na Malawu va Chapanga vamupili Musa kutovilela kucha nakaka kunana.” ");
INSERT INTO ndj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu payingileyi mumbwani ya Kapelinaumu mundu yumu mkomi wa machonda amuyendilili, kamuluva, ");
INSERT INTO ndj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Padeta, “Bambu ndumindumi wangu kawonja kaya mtami wa kupombala na akutamika nendu.” ");
INSERT INTO ndj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kawomba, “Ngwisa kumulowola.” ");
INSERT INTO ndj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mundu yula mkomi wa machonda kamuwombela, “Bambu, yuwi ukujakwa ha kuyingila munyumba yangu. Lakini deti chilongu hela na ndumindumi wangu danani. ");
INSERT INTO ndj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwa nongwa hata nenga mundu yimeli pasi ya ukomi wa vandu vamonga, ndiva nawu vamachonda vaveli pasi ya nenga. Pandimuwombela yumu, ‘Yendi!’ Na mweni akuyenda: na mumonga, ‘wisi!’ Na mweni akwisa na ndumindumi wangu, ‘Goli chindu achi!’ Mweni akugola.” ");
INSERT INTO ndj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu papikanishili afi, kayikanganika, kavawombela vandu vamkovikeli nakaka nguvawombela ngalihela kumuwona mundu yoyosi Muyisilaeli yaveli na ujumilwa kucha awu. ");
INSERT INTO ndj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Topi, nguvawombela kucha vandu vatangalili vakwisa kufuma kundamba na kuuhehi na veni vakwikala palihungu pamu na Ibulahimu, Isaka na Yakobi muwutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lakini vala yivadayiliwa kuva muwutwa awu davadangiwi panji, mulwisa, aku davalili na kugelujula minu. ");
INSERT INTO ndj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pambeli Yesu kamuwombela yula machonda wa Loma, “Yendi kaya na yivi kucha wujumilili.” Ndumindumi waki ananili mwanja wuwula. ");
INSERT INTO ndj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu afikili kaya ya Petili, kamuwona mkohanu mundu Petili kawonja pawulili kana msusa mkomi. ");
INSERT INTO ndj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Topi Yesu kamugufya liwoku mawu yula na msusa wumuleka, pambeli kayimuka kamukimbanikila. ");
INSERT INTO ndj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Payiveyi palumii, vamuyeghilili vandu vatangalili yivakamuliwili na finyamkela. Na mweni kwa kudeta chilongu hela, kafivinga fila finyamkela fyosi, avalowulili kandi vandu vosi vaveli vatami. ");
INSERT INTO ndj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Agolili naha ili fila fyadetili mbuyi Isaya fivi nakaka, “Mweni bahala kawutola usosuvafu wetu kavawusha matami vetu.” ");
INSERT INTO ndj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu paliwonili lipinga lya vandu limshengetela, avalayishili vanachuli vaki vayendi kumwambu ya lihiva. ");
INSERT INTO ndj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Muwula yumu wa Malawu, kamuyendela Yesu kamuwombela, “Muwula, nenga dandikukovikeli kosi kuuyenda.” ");
INSERT INTO ndj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kamuyangula, “Fingekembi vana mbaku na vambongu vana fiyumba, lakini mwana wa mundu kavahela mahali pa kwikala na kupumulila.” ");
INSERT INTO ndj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pambeli mundu wingi pagati ya vanachuli vaki kamuwombela, “Bambu uneki tanila ngamusiki Tati wangu.” ");
INSERT INTO ndj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lakini Yesu kamuwombela, “Ungovikeli! Wuvaleki yivasovili vavasiki yivasovili vayawu.” ");
INSERT INTO ndj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu kayipaka muwatu pamu na vanachuli vaki vayenda. ");
INSERT INTO ndj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tepu liwumbula likomi likanda mulihiva, mbaka majinga vakanda kudibasha watu. Mwanja wula Yesu aveli mung'onju. ");
INSERT INTO ndj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Vanachuli vamuyendela, vamuyimushi kunu pavadeta “Tulowoli Bambu tukusova!” ");
INSERT INTO ndj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu kavawombela, “Yumwi vandu yimuveli na ujumilwa mdokwa mbona mukutila?” Topi katandamuka, kalilakalila liwumbula na liyegha kuva nyanyi. ");
INSERT INTO ndj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Vandu vayikanganika, vadeta, “Mundu ayu wa wuliwuli? Hata liyegha na liwumbula likumpikana!” ");
INSERT INTO ndj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu pafikili mumlima wa Vagadala kumwambu ya lihiva, aku atang'anikili na vandu vavili yivafumeyi kusembi sha mbaku. Vandu ava vavelili na finyamkela na vaveli vakukapusha nendu kwahela mundu yayeshili kupita njila yila. ");
INSERT INTO ndj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tepu veni vakanda kuwuta, “Ukudayila liki kwa yufwi, yuwi mwana na Chapanga? Kwisa kutugobola chipindi cheni chikali kwisa?” ");
INSERT INTO ndj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pabehi na pala pavelili lipinga likomi lya vangubi vakulya. ");
INSERT INTO ndj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Topi, vala finyamkela vamuluva Yesu, “Mani pawutuwusha, tujumishi tuyingili mulipinga lya vangubi.” ");
INSERT INTO ndj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu kavawombela, “Topi muyendi.” Topi, vavafuma vandu vala na kuvayingila vangubi. Lipinga lyosi lya vangubi liwulumbuka mbilu vaseleka muchiseleka chikali na kudubukila mulihiva vangubi vosi vafwa machi. ");
INSERT INTO ndj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na vala vadima vangubi vatuvili vayenda kumbwani. Aku valandula milandu yosi yigolikili na vandu vala vaveli na finyamkela. ");
INSERT INTO ndj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Topi vandu vosi va mlima wula vafumili, vamuyendela Yesu, pavamuwonili, vamuluva awuki mumlima wau. ");
INSERT INTO ndj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kayipaka muwatu, kajabuka lihiva kuwuya kwayikaleyi. ");
INSERT INTO ndj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aku vandu vamuyeghilili mundu yumu yapombalili muvili, vamuwonjesha muulili. Yesu pawonili ujumilwa wawu, kamuwombela mundu yula yapombalili, “Mwana wangu wuyikangashi! Kupomiliwa sambi shaku.” ");
INSERT INTO ndj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Vawuli vamu va Malawu vakandili kuyiwombela veni, “Mundu ayu akumduka Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu asimanyili kala hoshu shawu, kadeta, “Kwa nongwa liki mukwihosha fya wafu mundima shenu? ");
INSERT INTO ndj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lyoti lipusukili nendu, kudeta, ‘kupomiliwa sambi shaku’, awu kudeta, ‘Woloki yendi yendi?’ ");
INSERT INTO ndj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ponopa ngudayila mumanyi kucha Mwana wa Mundu kana uwesu wa kupomela vandu sambi mumlima awu.” Topi kamuwombela yula mundu yapombalili. “Tandamuki, toli ulili waku yendi kaya yaku!” ");
INSERT INTO ndj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mundu yula yapombalili katandamuka, kayenda kaya yaki. ");
INSERT INTO ndj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Vandu vosi mulipinga lila pavawonili afi, vajinga na kutila, vamujuma Chapanga yavapili vandu uwesu nga awu. ");
INSERT INTO ndj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu kawuka pala, paghaveyi akuyenda, amuwonili mundu yumu yakemiwa Mateyi, ayikalili pachichuku chaki cha kusumula mbiya. Topi Yesu kamuwombela, “Ungovikeli.” Mateyi katandamuka, kamukovekela. ");
INSERT INTO ndj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu paghaveyi pakaya pa Mateyi paghalya filivi, vala vandu vasumula mbiya vatangalili na vandu vaveli na sambi vayisili vayikala pamu na vanachuli vaki. ");
INSERT INTO ndj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafwalisayu vamu pavavawonili, vavadashili vanachuli vaki, “Mbona muwula wenu akulya pamu na vala vasumula mbiya na vaveli na sambi?” ");
INSERT INTO ndj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu kavapikana, kavayangula, “Vandu vaveli vanofu vakumdayila mwilwana ha, yivamdayila mwilwana vala vavelili vatami. ");
INSERT INTO ndj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Topi, mukayiwuli nongwa ya mayandiku yivawombili Chapanga, ‘Ngudaya lusungu hela, litambiku lya vang'ongolu ha.’ Nenga nyisa ha kuvakema yivayihola vanofu, ila yivaveli na sambi.” ");
INSERT INTO ndj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pambeli vanachuli va Yohani mbatisha vayendili kwa Yesu, vamudasha, “Yufwi tukuyikaja myanja yitangalili kulya na Mafwalisayu vakwikaja kulya myanja yitangalili, mbona vanachuli vaku vakwikaja kulya ng'odu?” ");
INSERT INTO ndj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kavayangula, “Valalikiwili kulihungu lya kuheta vakudayiliwa kulila kwa kuyidedeka chipindi Bambu wa lihungu kava pamu na veni? Mani ng'odu! Chipindi dachifiki yaheta pawushiwa pagati yawu, chipindi achi ndi davayikaji kulya. ");
INSERT INTO ndj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Vandu vakuvika chilepa cha yingwa ya shonu muyingwa ngulungulu ha. Nongwa chilepa achi dachinyopoli yingwa ngulungulu na pala pasakalili dapayongisheki. ");
INSERT INTO ndj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kwahela vandu yivavika difwayi ya shonu mumihaku ya dahili. Leki pavagola naha mihaku dayibaluki na difwayi dawuyitiki na mijamanda dayiyanangiki, ila vandu vakuvika difwayi wa shonu mumijamanda ya shonu na yosi mivili yikwikala unofu.” ");
INSERT INTO ndj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu paghaveyi akudeta afi, mkomi yumu Myawudi afikili, kamugondamila kunu padeta, “Kamwali wangu kasova ponopawu. Lakini deku tuyendi ukamuvikili liwoku lyaku na mweni danani.” ");
INSERT INTO ndj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu kawuka pamu na vanachuli vaki, vamukovikela. ");
INSERT INTO ndj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mawu yumu mtami wa liholuveya kwa chipindi cha myaka lilongu na mivili, kamukovekela Yesu kumbeli, kagufya luviniku lwa yingwa yaki. ");
INSERT INTO ndj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Agolili nawula kwanongwa ayihoshili mundima yaki, “Pagufya hela yingwa yaki danani.” ");
INSERT INTO ndj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Topi, Yesu kaghalambuka kamuwona kamuwombela, “Kamwali, wuyikangashi ujumilwa waku wukulowola.” Mawu yula kanana mwanja wuwula wula. ");
INSERT INTO ndj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pambeli Yesu kayingila munyumba ya yula mkomi. Pavamuwonili vakuva lindenda lipinga lya vandu likanda kulila, ");
INSERT INTO ndj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kadeta, “Muwukepa! Muhinja ayu kasova ng'odu, kawonja hela!” Veni vamuseka. ");
INSERT INTO ndj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Topi lipinga lya vandu pavaliwushili, Yesu kayingila mugati, kamukola liwoku muhija yula na mweni kawoloka. ");
INSERT INTO ndj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Milandu yila yikwila ngengelekwa yosi yila. ");
INSERT INTO ndj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu kawuka pala, paghaveyi akuyenda, vangalimesu vavili vamkovekelili kunu pavavika umatu, “Mwana wa Dawudi, utuwoneli lusungu!” ");
INSERT INTO ndj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu pafikili kaya, vangalimesu vala vavili vamuyendela, mweni kavadasha, “Mukujumila kucha nguwesha kuvagolela chilongu achi?” Veni vamuyangula, “Yina Bambu!” ");
INSERT INTO ndj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pavayangulili naha, Yesu kavagufya mesu vawu, kadeta, “Na yivi ngimu wumujumilili!” ");
INSERT INTO ndj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na mesu vawu vafuwuka valola. Yesu kavakayika kwa kuvalakalila, “Mukotoo kumuwombela mundu yoyosi chilongu achi.” ");
INSERT INTO ndj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lakini veni vawuka, vakwisha filongu fya Yesu mumlima wula wosi. ");
INSERT INTO ndj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Vandu pavawukeyi, vamonga vamuyeghilili Yesu mundu yumu ngadeta kwanongwa aveli na chinyamkela. ");
INSERT INTO ndj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tepu, mundu yula pawushiwili chinyamkela, yula yaghaveyi ngadeta, kakanda kudeta. Vandu vajinga na kudeta, chindu nga achi chikalihela kuwoneka Muisilaeli. ");
INSERT INTO ndj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lakini Mafwalisayu vakudeta, “Akuvavinga finyamkela kwa liwovi lya mkomi wa finyamkela.” ");
INSERT INTO ndj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ayendili mumbwani na fijiji, pawula munyumba shawu sha Chapanga kunu palandula milandu minofu ya Wutwa wa kumbindi kwa Chapanga na kulowola matami vosi na usosuvafu wa ndambu shosi. ");
INSERT INTO ndj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Topi, pavawonili vandu lipinga kwa lipinga, avawonilili lusungu kwanongwa vaveli takitaki na chivakolili chipwembwi kucha cha vafungami vangajila mdimi. ");
INSERT INTO ndj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pala kavawombela vanachuli vaki, “Fibeni fitangala, lakini vabeni vadokwa. ");
INSERT INTO ndj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Topi, mumuluvi Bambu wa fibeni ayeghi vabeni vatangalili vabeni fibeni fyaki.” ");
INSERT INTO ndj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu avakemili pamu vanachuli vaki lilongu na vavili, kavapa uwesu wa kuvavinga fuki sha wafu na kulowola yivavelili na mususa na matami vosi. ");
INSERT INTO ndj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Matawa va ava Vandundami lilongu na vavili ndi ava, Simoni yivamkema Petili na mlongu mundu Andeleya. Yakobi mwana wa Sebidayu na mlongu mundu Yohani. ");
INSERT INTO ndj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipu na Batulumeyu na Tomasi na Mateyi yaveli msumula mbiya, Yakobi mwana waki Alufayu na Tadeyu, ");
INSERT INTO ndj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni yayitashila mlima na Yudasi Sikaliyoti yamshengetili Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu avalayishili ava lilongu na vavili na kuvapa Malawu ava, “Mukotoo kuyenda kwa vangutungu, na mukotoo kuyingila mumbwani sha Vasamaliya. ");
INSERT INTO ndj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ila muyendi kwa vafungami va Isilaeli yivayaghamilili. ");
INSERT INTO ndj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pamuyenda muvalandulili naha, ‘Wutwa wa kumbindi kwa Chapanga wuva pabehi!’ ");
INSERT INTO ndj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muvalowoli vatami na mushukushi yivasovili na muvang'alishi yivaveli na utami wa mwiku na muwushi finyamkela. Mupata hela na yumwi muvapi hela. ");
INSERT INTO ndj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Mukotoo kutola fyumang'andu munjavi shenu, wala mbiya, awu migwala ya shaba. ");
INSERT INTO ndj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mukotoo kutola muhaku wa kupapila, wala likoti limonga, wala filatu, wala lukweku, nongwa mugola chichuku akudayiliwa ijala yaki. ");
INSERT INTO ndj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pamuyingila mumbwani awu chijiji chochosi mumusaki mundu wa kumutyangila na mwikali amu mbaka lijuva damuwuki pala. ");
INSERT INTO ndj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamuyingila munyumba muvachi, kusika yivi na yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Leki venikaya pavavayanga, kusika kwenu dakuvi pamu na veni. Lakini pavavayanga ng'odu, topi sika yenu dayivawuyili mwaveni. ");
INSERT INTO ndj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kucha mundu yoyosi palema kuvalibushila awu kuvapikanisha, topi pamufuma munyumba yila awu mbwani yila, mupundi lifu mumawulu yenu yivi chilangushilu cha napilu yenu. ");
INSERT INTO ndj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nakaka nguvawombela, lijuva lya highilu vandu va mbwani ayi davapati asabu ngomi pitu yila yivapatili vandu va Sodoma na Gomola.” ");
INSERT INTO ndj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mpikanishi! Ponopa nenga nguvalayisha yumwi kucha vafungami gati ya fingekembi. Muvi na luhunja kucha njoka na vashishamoyu moyu kucha vanjiva. ");
INSERT INTO ndj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Muyivavali, nongwa davavayeghi yumwi kuchitemela na kuvalatula ndomondu munyumba shawu sha kudadavila. ");
INSERT INTO ndj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Davavayeghi pawulongolu ya vatavala na vatwa kwanongwa ya nenga, ili mundovileli kwa veni na kwa vandu vamonga vangajila kuva Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Topi, yumwi pavavayegha mubalasa, mukotoo kuyihola kucha damudeti liki na damudeti wuliwuli, tepu damugayiliwi fya kudeta. ");
INSERT INTO ndj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mana damudeti yumwi ha, ila Mfuki wa Tati wenu ndi yadeta kupitila yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mlongu damushengeti mlongu mundu awulayiwi na Tati damshengeti mwana mundu na vana davavalimbi valeli vawu na kuvagola vawulayiwi. ");
INSERT INTO ndj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Vandu vosi davavanyekwi yumwi kwanongwa ya litawa lyangu. Lakini yayiwunishila mbaka mbelu, ndi dalowuliwi. ");
INSERT INTO ndj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Vandu pavavagobola mumbwani yimu, mutuvilili mbwani yingi. Nakaka nguvawombela, damumalili ha ndyangilu yenu mumbwani shosi sha Isilaeli ngajila mwana wa mundu kufika tanila. ");
INSERT INTO ndj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanachuli ampiti ha muwula waki, wala ndumindumi ampiti Bambu mundu ha. ");
INSERT INTO ndj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yikwila mwanachuli kuva kucha muwula waki na ndumindumi kuva kucha Bambu mundu. Leki mkomi wa nyumba vamukema Besibuli, vana va muna nyumba davakemiwi matawa va wafu nendu!” ");
INSERT INTO ndj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Topi, mukotoo kuvatila vandu ava. Chindu chochosi chigubikiwili dachigubutuliwili na chindu chifisiwili dachilangushiwi. ");
INSERT INTO ndj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chindivawombela yumwi mulwisa, muchideti pangesha na chilongu muchipikanishili mumbwepu, muchilandushi pachisuwulu. ");
INSERT INTO ndj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mukotoo kuvatila vala yivawulagha muvili, lakini vakuwesha ha kuwulagha ndima. Ngiba munu kumtila Chapanga nongwa mweni akuwesha kuwulagha mvili pamu na ndima mumotu wa lifumbika. ");
INSERT INTO ndj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Vamkongujoli vavili vakuhemishiwa kwa ligwala lidokwa limu. Lakini hata yumu akuponeka ha pasi ngajila Tati wenu kumanya. ");
INSERT INTO ndj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lakini kwa mwambu wenu, hata fwili sha mitwi yenu sivalangiwa shosi. ");
INSERT INTO ndj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ponopa mukotoo kutila, yumwi muna nongwa pitu mkongujoli vatangalili.” ");
INSERT INTO ndj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mundu yajumila pawelu kucha mweni wa nenga na nenga dandimjumili pawulongolu ya Tati wangu yaveli kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lakini yoyosi yanema pawulongolu ya vandu na nenga dandimlemi paulongolu ya Tati wangu yaveli kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mukotoo kwihola kucha nyisa kuyegha kusika pamlima awu, nyisa kuyegha kusika ha ila upanga. ");
INSERT INTO ndj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mana nyisa kuyegha shoshu kwa mundu na Tati mundu, kwa kamwali na mawaki na mkohanu na mkohanumundu. ");
INSERT INTO ndj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na chimdwama wa mundu, ndi mundu wa kayaki. ");
INSERT INTO ndj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yamutama Tati awu mamundu pitu nenga, akudayiliwa ha. Na yamtama kamwali awu mwana waki akujumiliwa ha kuva ndundami. ");
INSERT INTO ndj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mundu yangajila kutola lupingika lyaki na kungovikela, akudayiliwa ha kuva ndumindumi. ");
INSERT INTO ndj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yakamulila unofu waki, dayaghamishi, lakini yayaghamisha unofu waki kwanongwa ya nenga dawupati. ");
INSERT INTO ndj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yavapokela yumwi, akumbokela nenga na yambokela nenga akumpokela yula yanayishili. ");
INSERT INTO ndj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yamupokela mbuyi wa Chapanga kwanongwa ndi mbuyi, dapokeli fupu ya mbuyi. Yamulibushila mundu msangi kwanongwa ndi mundu msangi, dapokeli fupu ya mundu goleki. ");
INSERT INTO ndj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nakaka nguvawombela, yoyosi damupi mundu mudokwa gati ya vanachuli ava lwindi lwa machi vasisimili kwanongwa kava mundu wa nenga nakaka dayimpoti ha kupokela fupu yaki.” ");
INSERT INTO ndj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu pamalilili kuvawombela naha vala vanachuli vaki lilongu na vavili, awukili pala, kayenda kuwula na kulandula mumbwani sha behi na kula. ");
INSERT INTO ndj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohani mbatisha paghaveyi muchijaka apikanishili milandu yagolili Kilistu, topi, Yohani kavalayisha vanachuli vaki vayendi kwa Kilistu. ");
INSERT INTO ndj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Vamudashi, “Yuwi kuva yula Yohani adetili dawisi, awu tumulembileli wingi?” ");
INSERT INTO ndj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kavayangula, “Muyendi mukamuwombeli Yohani mbatisha filongu fimupikana na kufiwona, ");
INSERT INTO ndj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Vangalimesu vakulola na vandevindevi vakuyendayenda. Vaveli na utami wa mwiku vakung'ala na majogu vakupikana. Vasovili vakushukushiwa na vagaju vakulanduliwa Chilongu cha Nyanyi. ");
INSERT INTO ndj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ngiba mundu yula yaveli na cheleli yangajila njelangu na nenga.” ");
INSERT INTO ndj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Topi vala valayiliwili na Yohani mbatisha pavawukeyi, Yesu akandili kuliwombela lipinga lya vandu nongwa ya Yohani mbatisha: “Pamuyendili kuchivala kumulola Yohani mukadayileyi kulola chindu liki? Mukadayileyi kulola liteti palitikanyishwa na liyegha? Ng'odu! ");
INSERT INTO ndj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ponopa mukayendili kulola mundu wa wuliwuli? Wuli mukayiholili mwayendili kumulola mundu yafwalili yingwa sha nyanyi? Ng'odu! Vandu vakufwala yingwa sivayilili vakwikala munyumba sha vatwa! ");
INSERT INTO ndj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lakini, mukayendili kulola liki? Mbuyi? Yina nakaka mundu pitu mbuyi wa chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ayu ndi yivamuhimula mumayandiku vang'alili. ‘Loli, nenga ngumlayisha makungu wangu akulonguleli, mweni dakutandili deha yaku:’ ");
INSERT INTO ndj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nakaka nguvawombela gati ya vandu vosi yivaikalili, kwa hela yawonikili kuva mkomi pitu Yohani mbatisha. Hata naha, yula yaveli mdokwa muwutwa wa kumbindi kwa Chapanga, ndi mkomi pitu Yohani. ");
INSERT INTO ndj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tangila chipindi cha Yohani mbatisha mbaka nalelu, wutwa wa kumbindi kwa Chapanga wukulevangiwa nendu na vandu vakali vakuyesha kuwutola kwa liwovi. ");
INSERT INTO ndj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngulilu shosi sha vambuyi va Chapanga na Malawu va Chapanga vamupili Musa vahimulilagha milandu ya Wutwa mbaka chipindi cha Yohani mbatisha. ");
INSERT INTO ndj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Leki pamuwesha kujumila, topi Yohani ndi Eliya amuhimulileyi kwisa. ");
INSERT INTO ndj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Muna majeji vakupikanila apikani! ");
INSERT INTO ndj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Topi, dachiyifwani na chindu liki chileli achi? Kucha fijana vaveli vayikala paluvagha, pavayiwombela lipinga limu kwa lipinga limonga. ");
INSERT INTO ndj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tuvakuvila ngoma lakini mufina ha! Tusomola misambu ya lung'ong'u, lakini mulila ha!’ ");
INSERT INTO ndj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwa nongwa Yohani mbatisha ayisili, ayikajili kulya na wala kulanda difwayi ha, lakini veni vawomba kana chinyamkela. ");
INSERT INTO ndj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa mundu ayisili, akulya na kulanda na veni vadeta, ‘Mumloli ayu, mbafu na njayila, ghanja wawu vandu vasumula mbiya na vaveli na sambi!’ Hata naha luhunja lwa Chapanga lukuwoneka ilinganila kwa findu figolikili.” ");
INSERT INTO ndj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Vandu va mumbwani sila Yesu shagolili mihilu yitangalili vapomela ha, topi Yesu awukili mumbwani sila. ");
INSERT INTO ndj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Pishu yuwi Kolosayi! Pishu yuwi Betisayida! Nongwa, mihilu yigolikili kwa yumwi yingagolikili kula Tilu na Sidoni, vandu vaki vangafwalili kala milobota dahili na kuyibunga lifu pavapomela sambi. ");
INSERT INTO ndj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hata naha, nguvawombela nakaka, lijuva lya highilu yumwi damupati asabu ngomi pitu yila ya Tilu na mlima wa Sidoni. ");
INSERT INTO ndj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na yuwi Kapelinaumu! Wuli ukwihola dawuyikweshi mbaka kumbindi kwa Chapanga? Dawutengelimuliwi mbaka kumambi! Mana leki mihilu yigolikili kwa yuwi yingagolikili kula Sodoma, mlima wula wungavelili mbaka nalelu. ");
INSERT INTO ndj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lakini nguvawombela nakaka, lijuva lya highilu yuwi dawupati asabu ngomi pitu yila ya Sodoma.” ");
INSERT INTO ndj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chipindechi Yesu adetili, ngukulumba yuwi Tati, Bambu wa kumbindi na mlimawu, nongwa kuvafisa yivavelili na luhunja na yivasomili findu afi, kuvagubutulila yivangajila kusoma. ");
INSERT INTO ndj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yina, Tati nahawu ndi yikunowilili. ");
INSERT INTO ndj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tati wangu kanyimba findu fyosi. Kwahela yamumanyili Mwana ila Tati, wala kwahela yamumanyili Tati ila Mwana na mundu yoyosi yula Mwana padayila kumgubutulila. ");
INSERT INTO ndj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mwisi kwa nenga yumwi mwavosi yimutofili kwa kwitwika misiwu misitu na nenga dandivagoli mupumulili. ");
INSERT INTO ndj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mwiwopi lingongola yangu na mwiwuli kwa nenga, nongwa nenga ndi msangi na mshisha moyu na yumwi damusikimali mundima shenu. ");
INSERT INTO ndj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nongwa lingongola lindivapa nenga liva nyililili na msiwu wangu mpusu.” ");
INSERT INTO ndj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chipindi achi Yesu, akatyangeyi mufitava fya mupunga lijuva lya kupumulila, topi vanachuli vaki vawona njala, vakanda kuketula sasa sha mpunga kunu pavadodola ngokwa shaki. ");
INSERT INTO ndj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafwalisayu pavawonili nawula, vamuwombela Yesu, “Loli, vanachuli vaku vakugola chindu chikaniwili mumalawu kugola lijuva lya kupumulila!” ");
INSERT INTO ndj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kavayangula, “Musoma duhu fyagolili Dawudi pamu na vayaki pavaveghi na njala? ");
INSERT INTO ndj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mweni ayingilili munyumba ya Chapanga kalya mibumunda yivikiwili litambiku lya Chapanga, mweni hata vamonga vala vajumishiwa ha kulya mibumunda yila ila vatambika weka yawu. ");
INSERT INTO ndj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Awu musoma duhu muchitabu cha Malawu cha Musa kila lijuva lya kupumulila vatambika vakuvifya Malawu munyumba ya Chapanga, lakini kwahela yaihola kucha vana nongwa? ");
INSERT INTO ndj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Topi, nguvawombela kucha, apa kuna yaveli mkomi pitu nyumba ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kucha tungamanyili mana ya filongu afi ‘Ngudayila lusungu litambiku ha.’ Mungavahighili ha vandu vangajila nongwa. ");
INSERT INTO ndj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mana Mwana wa mundu ndi bambu wa lijuva lya kupumulila.” ");
INSERT INTO ndj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu awukili pala kayenda munyumba ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kwaveli mundu yumu munaliwoku lipombalili. Topi, vandu vamudasha Yesu, “Finofu kumulowola mundu lijuva lya kupumulila?” Vamudashili nahawu ili vapati pa kumuhighila. ");
INSERT INTO ndj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lakini Yesu kavawombela, “Tudeti mundu kana meni waki kadubukila mumyowu, akotoo kumujabula kwanongwa lijuva lya kupumulila? ");
INSERT INTO ndj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lakini mundu katauka pitu meni! Topi, tukujumishwa kugola chindu cha nyanyi lijuva lya kupumulila.” ");
INSERT INTO ndj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pambeli kamuwombela yula mundu, “Hololi liwoku lyaku.” Kaliholosha na lyeni liva linofu kucha lila liwoku lingi. ");
INSERT INTO ndj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Topi, Mafwalisayu vafuma panji vawombana, ndambu davamuwulayi Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lakini Yesu pamanyili chindu chila, kawuka pala paghaveyi. Vandu vatangalili vamukovikelili, kavalowola vatami vosi, ");
INSERT INTO ndj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na avalayishili vakotoo kuvawombela vandu filongu fyaki, ");
INSERT INTO ndj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Agolili wula ili fila fyadetili Chapanga kupitila mbuyi wa Chapanga Isaya fivi, ");
INSERT INTO ndj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Loli ayu ndumindumi wangu yindimushawulili, yindimutamili na yanovilili mumoyu. Dandimuviki Mfuki wangu, na mweni dalanduli highilu yangu kwa vandu va milima yosi. ");
INSERT INTO ndj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Daghavi na malimbu ng'odu wala kuvika umatu, wala lishu lyaki dalipikaniki mudeha ng'odu. ");
INSERT INTO ndj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lutete lufujukili daluketuliwi ha, wala utambi ututuma lyosi daujimishiwi ha, mbaka haki yitavali. ");
INSERT INTO ndj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mweni vandu va milima yosi davamshuvilili.” ");
INSERT INTO ndj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pambeli vamuyeghela Yesu mundu yumu ngalimesu na yaveli ngadeta kwanongwa aveli na chinyamukela. Yesu kamulowola, kawesha kudeta na kulola. ");
INSERT INTO ndj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lipinga lya vandu lijinga na kudeta, “Pamongapa ayu ndi Mwana wa Dawudi?” ");
INSERT INTO ndj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lakini Mafwalisayu pavapikanishili afi, vadeta, “Mundu ayu akuvinga finyamkela kwa litawa lya Besibuli mkomi wa finyamkela.” ");
INSERT INTO ndj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu amanyili hoshu shawu, kavawombela, “Wutwa wowosi wuyitapulili lipinga lipinga pawulimbana, wuyikali ha. Na mbwani awu nyumba yoyosi yiitapula fipinga fipinga na kulimbana dayiwi. ");
INSERT INTO ndj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Payiva Lijangavandu akumuvinga Lijangavandu monga, akwilimba mweni. Topi, wutwa waki dauwoloki wuliwuli? ");
INSERT INTO ndj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yumwi mukudeta kucha nguvavinga finyamkela kwa uwesu wa Besibuli, vala vanachuli va yumwi vakuwusha finyamkela kwa uwesu wa ghani? Findu fivagola vanachuli venu fikulangusha nakaka kucha yumwi muyaghamila. ");
INSERT INTO ndj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lakini payiva nguvavinga finyamkela kwa liwovi lya Mfuki wa Chapanga, topi, mumanyi wutwa wa kumbindi kwa Chapanga wufika kala kwa yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kwahela mundu yawesha kwingila munyumba ya mundu muna liwovi na kutola findu, ngajila kumuwopa mundu ayu muna liwovi. Pamuwopili kala ndi daweshi kumupoka findu. ");
INSERT INTO ndj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yoyosi yangajila kuva mwambu wangu akunimba na yoyosi yangajila kukunganya pamu na nenga akuchachasha. ");
INSERT INTO ndj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nongwa ayi, nguvawombela, vandu davapomiliwi sambi shosi sivagolili na kumduka kwawu kosi, lakini davapomiliwi ha sambi ya kumuduka Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kandi yadeta chilongu cha kumulimba Mwana wa mundu dapomeliwi, lakini yula yadeta chilongu cha kumulimba Mfuki Mng'alili, dapomiliwi ng'odu, wala mumlima awu wala kumulima wuyisa.” ");
INSERT INTO ndj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Muligoli libiki kuva linofu na fivelekwa fyaki dafivi finofu, Muligoli kuva lya wafu na fivelekwa fyaki dafivi fya wafu. Libiki likumanyika kwa fivelekwa fyaki. ");
INSERT INTO ndj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yumwi vanjoka! Mukuwesha wuliwuli kudeta chilongu chinofu kunu yumwi muva va wafu? Nongwa mundu akudeta kufuma fimemili mundima yaki. ");
INSERT INTO ndj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu mnofu akufumisha chindu chinofu kufuma mundima yaki nofu na mundu wa wafu akufumisha findu fya wafu mundima yaki wafu. ");
INSERT INTO ndj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Topi, nguvawombela, lijuva lya kuhighiwa vandu davayanguli kwanongwa ya filongu fingajila kujakwa fila fivadetili. ");
INSERT INTO ndj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nongwa kwa chilongu chaku dawuvi goleki na kwa filongu fyaku dawuhighiwi.” ");
INSERT INTO ndj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pambeli vawula vamonga va Malawu na Mafwalisayu vamuwombela Yesu, “Muwula, tukudayila utulangushi mihilu yaku.” ");
INSERT INTO ndj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mweni kavayangula, “Chileli cha wafu chingajila kujumila! Mukudayila mihilu lakini damupati ng'odu chilangushilu ila chila chilangushilu cha mbuyi wa Chapanga Yona. ");
INSERT INTO ndj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ndambu Yona yaikalili majuva matatu mumtima ya somba mkomi, yiva nga wayikalili Mwana wa Mundu muuganga majuva matatu. ");
INSERT INTO ndj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Vandu va Ninawi vabwituka chipindi cha kuhigha, davachihighi chileli achi. Nongwa vandu va Linawi vapomilili pavampikanishili Yona palandulili! Nguvawombela nakaka, apa pana chindu chikomi pitu Yona ");
INSERT INTO ndj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lijuva lya kuhigha, Muhumbu wa Sheba dachihighi chileli achi. Nongwa mweni yafumili mwanja mutali kayenda kupikanila chilongu cha luhunja cha Solumoni na kumbi apa kuna chikomi pitu Solumoni, ");
INSERT INTO ndj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Chinyamkela mwafu, pavingiwa kwa mundu, akuyelejayeleja kucheja pasaka pahali pa kupumulila apati ha. ");
INSERT INTO ndj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Na apa akwidetela, dang'uyi kayangu kufumili? Lakini pawuya payiwona kwahela, yifyaghiliwa na kunoweshwa. ");
INSERT INTO ndj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Akuyenda kuvatola finyamkela vamonga saba vawafu pitu mweni na vosi vakwisa kumuyingila mundu yula na ngalilu ya mundu yula yikuva ya wafu pitu dahili. topi ndi dayivi kwa vandu ava va wafu.” ");
INSERT INTO ndj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu paghaveyi akalihela kudeta na lipinga lya vandu chipindi mawaki na valongumundu pavafikili na vawolukili panji, vakadayileyi vaywangi na Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Topi, mundu yumu kamuwombela Yesu, “Mawaku na valongu vaku vava panji vakudayila kuywanga na yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lakini Yesu kamuyangula mundu yula, “Mawangu ghani? Na valongu vangu vaghani?” ");
INSERT INTO ndj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pambeli kaholola liwoku lyaki pavavasonyela vanachuli vaki, padeta, “Ava ndi vamawu vangu na valongu vangu! ");
INSERT INTO ndj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nongwa yoyosi yagola fyadayila Tati wa nenga yaveli kumbindi ayu ndi muhaja wangu na mkulu wangu na mawu wangu.” ");
INSERT INTO ndj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lijuva lilila, Yesu afumili mula munyumba kayenda akayikali muluwongu ya lihiva na kuwula. ");
INSERT INTO ndj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lipinga likomi lya vandu vamushengitelili mbaka Yesu kayipaka muwatu, kayikala. Vandu vosi vawolukili mung'emula ya lihiva. ");
INSERT INTO ndj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu kavawombela filongu fitangalili kwa chilangushilu. “Mupikanishi! Mundu yumu ayendili kukweta mbeyu. ");
INSERT INTO ndj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Paghaveyi akukweta mbeyu, simonga shaponikili mudeha na vambongu vayisa valya. ");
INSERT INTO ndj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Simonga shaponikili muuganga wuveli na migonguveli gonguveli pangajila uganga wutangalili. Simela kalopu, kwanongwa pavelihela uganga utangalili. ");
INSERT INTO ndj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Palivalili lijuva mikigha yiyuma kwanongwa uganga waveli mudokwa. ");
INSERT INTO ndj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Simonga shaponikilili mumisomi, misomi yikula na kuyikekeneka mihali. ");
INSERT INTO ndj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Simonga shaponikilili muuganga wa nyanyi, simela na shavelikili nendu, simonga siveleka mya yimu na simonga siveleka milongu sita na simonga siveleka milongu mitatu.” ");
INSERT INTO ndj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Muna majeji vakupikanila apikani!” ");
INSERT INTO ndj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Vanachuli vaki vamuyendela, vamudasha, “Nongwa liki ukudeta na vandu kwa chilangushilu?” ");
INSERT INTO ndj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kayangula, “Yumwi msangiliwa kusimanya mbwepu sha wutwa wa kumbindi kwa Chapanga, lakini veni vasangiliwa ha. ");
INSERT INTO ndj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nongwa yaveli na chindu akugayiliwa na kuyongeshiwa, Lakini yula yangajila chindu, hata chila chidokwa chavelili nachu na cheni chikupokiwa. ");
INSERT INTO ndj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nongwa ngudeta nawu kwa chilangushilu, kwanongwa vakulembesha lakini vakulola ha, vakupikanisha lakini vakupikana ha, wala vakumanya ha. ");
INSERT INTO ndj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwaveni fiva fila fyadetili Mbuyi Isaya, ‘Kupikana damupikani, lakini mumanyi ha. Kusepa damusepi lakini damuloli ha. ");
INSERT INTO ndj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nongwa luhala lwa vandu ava lupufika, vadiva majeji vawu, Vagunga kwa mesu vawu, pamonga vangalolili kwa mesu vawu, na vangapikanishili kwa majeji vawu, na vangamanyili kwa luhala lwawu, na veni vangaghalambukili, pavadeta Bambu, na nenga ningavalowulili.’ ” ");
INSERT INTO ndj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu kadeta kandi, “Ngiba yumwi! Nongwa mesu venu vakulola na majeji venu vakupikana. ");
INSERT INTO ndj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nakaka nguvawombela, Vambuyi va Chapanga na vandu goleki vatangalili vadayilili nendu kufiwona fila fimufiwona yumwi na vafiwona ha na kufipikana fila fimufipikana yumwi na vafipikana ha. ");
INSERT INTO ndj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Topi yumwi muyiwuli kwa chilangushilu cha mkweta. ");
INSERT INTO ndj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yoyosi yapikana chilongu cha wutwa wa kumbindi kwa Chapanga ngajila kumanya, akuva kucha sila mbeyu siponikili mudeha, Yula mwafu akwisa na kusitola sila sikwetiwili mumoyu waki. ");
INSERT INTO ndj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyu yila yikwetilwi mumigonguveli ndi chilangushilu cha mundu yapikanisha chilongu achi na kuchipokela kwa cheleli. ");
INSERT INTO ndj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lakini akuchikamula ha na mikigha yaki, yikuyendilela kukula nendu ha. Pambeli pawubwituka kugobuleka kwanongwa ya chilongu achi, akulepisiwa kalopu. ");
INSERT INTO ndj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yila mbeyu yiponikili pamibiki ya misomi, ndi chilangushilu cha mundu yapikanila chilongu, lakini chipwembwi cha mlimawu na kufwamuka kwa mali likuchikekeneka chilongu achi na mweni akulela ha fivelekwa. ");
INSERT INTO ndj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yila mbeyu yikwetiwili muuganga mnofu ndi chilangushilu cha mundu yapikanila chilongu cha Chapanga na kuchimanya na mweni akulela fivelekwa, Yumu mya, wingi milongu sita na wingi kandi milongu mitatu.” ");
INSERT INTO ndj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kavawombela vandu chilangushilu chingi, “Wutwa wa kumbindi kwa Chapanga wuyifwana nga naha, mundu yakwetili mbeyu nofu muchitava chaki. ");
INSERT INTO ndj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pamihi yimu vandu pavaveli mung'onju chimudwama yumu ayisili katulila mityendya mumpunga, pambeli awukili. ");
INSERT INTO ndj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Topi, muhali pawukulili na kukanda kuyalula na mityendya wuwula yiwoneka. ");
INSERT INTO ndj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vandumindumi va yula muna chitava vamuyendela, vamuwombela, Bambu, yuwi wakwetili mbeyu nofu muchitava chaku, ponopa mityendya yifuma koti? ");
INSERT INTO ndj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mweni kavayangula, ‘Chimudwama ndi yagolili nahawu,’ Topi, vandumindumi vaki vamudasha, wuli, ukudayila tuyendi tukatupuli mityendya? ");
INSERT INTO ndj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yula munachitava kavayangula, ng'odu, mukotoo kugola nahawu, pamongapa pamutupula mityendya mukuwesha kutupula pamu na mupunga. ");
INSERT INTO ndj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muyileki yikuli pamu mbaka chipindi cha kubena, chipindi achi dandivawombeli vala yivabena. Mukungashi tanila mityendya mukawopi milundumilundu ya kunyanya motu, lakini mupunga mukunganyi mukauviki mulusanja lwangu.” ");
INSERT INTO ndj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kavawombela vandu chilangushilu chingi, “Wutwa wa kumbindi kwa Chapanga wuyifwana ngimu mbeyu dokwa nendu yatolili mundu yumu, kayikomulela muchitava chaki. ");
INSERT INTO ndj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yeni dokwa pitu mbeyu shonda, lakini payimela likuva libiki likomi pitu mibiki yosi, hata vambongu vakwisa na kujenga miyumba yawu mumitafyi yaki.” ");
INSERT INTO ndj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kavawombela chilangushilu chingi, “Wutwa wa kumbindi kwa Chapanga wukwifwana na simika yatolili mawu yumu, kayihasha na ukova fitandavala fivili na litingaja, ukova wosi kawupundila mumula.” ");
INSERT INTO ndj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu avawombilili mipinga ya vandu fyosi afi kwa chilangushilu, kavawombela chindu chimu ngajila chilangushilu. ");
INSERT INTO ndj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Agolili naha ili chilongu chivadetili vambuyi va Chapanga chivi. “Dadeti nawu kwa filangushilu, Dandivafisulili fifisikili kufumila ulumbi wa mlimawu.” ");
INSERT INTO ndj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pambeli Yesu kavayitawula vala vandu, kayingila munyumba. Vanachuli vaki vamuyendela, vamuwombela, “Tuwombeli unofu chila chilangushilu cha mityendya mufitava.” ");
INSERT INTO ndj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kavawombela, “Yakweta sila mbeyu nofu ndi Mwana wa Mundu, ");
INSERT INTO ndj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","chila chitava ndi mlimawu. Sila mbeyu nofu ndi vandu vala yivavelili muwutwa waki. Lakini yila mityendya ndi vala vandu va yula Mwafu. ");
INSERT INTO ndj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na chimundwama yapandili yila mityendya ndi Lijangavandu. Fivelekwa ndi mwishu wa mlima na vabeni ndi vamakungu. ");
INSERT INTO ndj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngimu wula mityendya yikukungiwa na kunyanywa motu, ndi dayivi chipindi cha lijuva lya mwishu mlimawu, ");
INSERT INTO ndj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa mundu davalayili makungu vaki vavawushi kufuma muwutwa waki vala vosi yivavagola vandu vagoli sambi na vosi yivagolili findu fya wafu, ");
INSERT INTO ndj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kuvayasila mutanuli lya motu na aku davalili na kugelujula minu. ");
INSERT INTO ndj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pambeli vala goleki davang'ali kucha lijuva muwutwa wa Tati wawu. Muna majeji apikani! ");
INSERT INTO ndj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Wutwa wa kumbindi kwa Chapanga wukwifwana ngimu naha, mundu yumu ayiwonili sanja yiifisili muchitava. Asekilili munu mbaka kayenda kuhemesha fyosi fyaveli nafyu, kachihemela chitava chila. ");
INSERT INTO ndj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kandi, wutwa wa kumbindi kwa Chapanga wuyifwana ngimu naha, mchulusi yumu yasaka lulu nofu, ");
INSERT INTO ndj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","na payipatili lulu yimu ya mbiya ngomi, kayenda kawula fyosi fyaveli nafyu kahemela lulu yila. ");
INSERT INTO ndj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kandi, wutwa wa kumbindi kwa Chapanga wuyifwana ngimu naha, lwafu luwutegha mulweni na kuwomesha vasomba va kila ndambu. ");
INSERT INTO ndj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Palumemili, vandu valukweghilili kumuhanga, vayikala, vavashawula vasomba vanofu na kuvavika mufitandavala fyawu na vasomba vangajila kuvadayila vavayasa. ");
INSERT INTO ndj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","topi ndi dayivi mwishu wa mlima, Makungu wa Chapanga davabwitukili, davalekanishi vandu vawafu na vandu goleki, ");
INSERT INTO ndj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kuvayasa ava vawafu mutanuli lya motu. Aku davalili na kugelujula minu.” ");
INSERT INTO ndj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu kavadasha, “Mupikana findu fyosi afi?” Vamuyangula, “Yina.” ");
INSERT INTO ndj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mweni kavawombela, “Topi, kila muwula va Malawu yaveli mwanachuli wa wutwa wa kumbindi kwa Chapanga akwifwana na muna nyumba yatola mulusanja lwaki findu fya shonu na fikulukulu.” ");
INSERT INTO ndj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu pamalilili kudeta filangushilu afi, awukili, ");
INSERT INTO ndj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kawuya kuchijiji chaki. Aku avelili akuvawula vandu munyumba ya Chapanga vala vampikanishili vajinga, vayidashili, “Ayu kapata koti luhunja nga alu? Na kapata koti liwovi lya kugola mihilu nga ayi? ");
INSERT INTO ndj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ayu mwana wa selimala yula nda? Mamundu Maliya na valongu vaki Yakobi na Yosefu na Simoni na Yuda ng'odu? ");
INSERT INTO ndj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na vaghanja vaki vosi vakwikala bahapa pamu na yufwi nda? Kapata koti fyosi afi?” ");
INSERT INTO ndj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Topi, vava na njelangu vamjumila ha. Lakini Yesu kavawombela, “Mbuyi akupata ndundamilu pawuhenja, ila akupota kutundamiliwa pakayaki na kwa valongu vaki!” ");
INSERT INTO ndj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwanongwa aku vajumilili ng'odu agolili mihilu yitangalili ha. ");
INSERT INTO ndj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chipindi chila Helodi mtavala wa Galilaya, apikanishili milandu ya Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Topi, kavawombela Vandumindumi vaki, “Nakaka ayu ndi Yohani mbatisha, kashukuka kufuma kumambi, Kwa nongwa akuwesha kugola mihilu.” ");
INSERT INTO ndj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helodi ndi alayishili kukamuliwa kwa Yohani mbatisha na kuwopiwa muchijaka kwanongwa ya Helodiya, mdala wa Filipu mkulumundu. ");
INSERT INTO ndj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohani mbatisha kwa chipindi aveli kamuwombela Helodi, “Nyanyi ha yuwi kumuheta Helodiya!” ");
INSERT INTO ndj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helodi akadayileyi kumuwulagha Yohani lakini vatilili vandu kwanongwa Yohani aveli mbuyi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mulihungu lya ngumbungumbu ya kuwoneka kwa Helodi, kamwali wa Helodiya afinili pawulongolu ya vahenja. Helodi apekesukili, ");
INSERT INTO ndj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hata kayilapila kwa kamwali waki, “Ngwilapa kucha dangugayili chindu chochosi chiwuluva!” ");
INSERT INTO ndj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mweni kunu pajongishewa na mamundu, kaluva, “Unyimbi bahapa muluselu mutwi wa Yohani mbatisha.” ");
INSERT INTO ndj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mutwa ang'ong'utekili, lakini kwanongwa amujangili pawulongolu ya vahenja, kavalayisha vamupi chindu chaluvili. ");
INSERT INTO ndj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Topi, Helodi kalayila vayeghi mutwi wa Yohani mbatisha kufuma muchijaka. ");
INSERT INTO ndj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mutwi waki uyeghiwa muluselu, vamupa yula kamwali na mweni kamuyeghela mamundu. ");
INSERT INTO ndj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Vanachuli va Yohani vayisa vachitola chikongu chaki, vachisika. Pambeli vayenda kumuwombela Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu papikanishili milandu ayi, awukili mahali pala kwa watu kayenda mahali pachifisu. Lakini vandu vapatili milandu ayi, vamukovikelili kwa mawulu kufuma kumbwani. ");
INSERT INTO ndj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Topi, pafikili kuluwongu kaliwona lipinga likomi lya vandu, kavawonela lusungu, kavalowola vatami vawu, ");
INSERT INTO ndj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Payifikili lumihi, vanachuli vaki vamuyendela vamuwombela, “Apa paweka na ngesha yikupela. Topi, wuvaleki vandu ava ili vayendi kufijiji vakayihemileli filivi.” ");
INSERT INTO ndj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu kavawombela, “Mukotoo kuvaleka vayendi, yumwi muvapi filivi valiyi!” ");
INSERT INTO ndj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lakini veni vamuwombela, “Tuva na mibumunda muhanu na vasomba vavili hela.” ");
INSERT INTO ndj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu kavawombela, “Munyegheli apa.” ");
INSERT INTO ndj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kavawombela vandu vayikali pasi mumidasi. Pambeli Yesu kayitola yila mibumunda muhanu na vala vasomba vavili, kayinula mesu kalola kumbindi kwa Chapanga kafinemela, pambeli kayimetula yila mibumunda, kavapa vanachuli vaki na veni vavapa vandu. ");
INSERT INTO ndj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vandu vosi valya, vayikuta. Pambeli vanachuli vakungasha fisighalili, vamemesha vitandavala lilongu na fivili. ");
INSERT INTO ndj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tolitoli ya valulumi yivalili vaveli alufu muhanu ngajila kuvalanga vamawu na vana. ");
INSERT INTO ndj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tepu, Yesu kavawombela vanachuli vaki vayipaki muwatu, valongoli kumwambu ya lihiva chipindi mweni akwitawula vandu. ");
INSERT INTO ndj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pavayitawulili kala vandu kakwela kuchidunda weka yaki kudadava. Payiveyi palumihi, mweni aveli aku weka yaki, ");
INSERT INTO ndj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na chipindi achi wula watu wuvayipakilili vala vanachuli vaki waveli kutali mulihiva, lakini vagobulikili kwanongwa lingukumbi lyaveli likuwutova watu. ");
INSERT INTO ndj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pamihi paliveyi samba kuchia, Yesu avayendilili vanachuli payendayenda mumbindi ya machi. ");
INSERT INTO ndj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Vanachuli vaki pavamuwonili payendayenda mumbindi ya machi vayipwelishili. Vadetili, “Chishuka!” Vawuta kwa lyogha. ");
INSERT INTO ndj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tepu, Yesu avawombilili, “Msiki, ndiva nenga, mukotoo kutila!” ");
INSERT INTO ndj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petili kamuwombela, “Bambu, leki yuwi nakaka, ung'ombeli nyendinyendi mumbindi ya machi nyisi kwa yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu kayangula, “Topi wisi.” Topi, Petili kajabuka kufuma mula muwatu, kayendayenda mumbindi ya machi, kamuyendela Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lakini pawonili lingukumbi lila, atilili, kakanda kumilwa, kalila kwa lishu, “Bambu, unowoli!” ");
INSERT INTO ndj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Topi, Yesu kawolosha liwoku lyaki, kamukamula na kumuwombela, “Yuwi muna ujumilwa mdokwa! Kwa nongwa liki wayipwelishili?” ");
INSERT INTO ndj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pambeli vosi vayipaka muwatu na lingukumbi lisika. ");
INSERT INTO ndj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Vanachuli vaki vavelili muwatu vafiwonili, vamtundamilili, “Nakaka ayu mwana wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Vajabukili lihiva vafika mlima wa Genesaleti. ");
INSERT INTO ndj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Vandu va aku pavamanyili Yesu akwisa, topi vavakungulili vatami mumlima wosi vavayegha kwa Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Vamuluva avajumishi vagufyi luviniku lwa yingwa yaki hela. Na vosi yivamugufyili vanana. ");
INSERT INTO ndj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pambeli Mafwalisayu vamu na vawula va Malawu vafumili Yelusalemu, vamuyendela Yesu, vamudasha, ");
INSERT INTO ndj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kwanongwa liki vanachuli vakukombikesha ng'odu fila tufipokilili kwa vavaha vetu? Vakunava kukandila mawoku ngimu ya chishovi chetu ha pavadayila kulya!” ");
INSERT INTO ndj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kavayangula “Ngimu yumwi mukukombikesha ng'odu Malawu va Chapanga ila mukudayila ng'ulilu yenu? ");
INSERT INTO ndj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mweni Chapanga awombili, wuvatundamili Tati waku na mawu waku, ‘Na yamujowola tati mundu awu mamundu dawulayiwi.’ ");
INSERT INTO ndj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lakini yumwi mukuwula kucha mundu paghava na chindu chila chingaweshili kumtanga tati mundu awu mamundu, lakini yidetiwa, ‘chindu achi chitawuliwa kwa Chapanga,’ ");
INSERT INTO ndj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","yumwi mukumtundamila kandi ha tati mundu, ndi nahawu mukusalawu Malawu va Chapanga kwa kukovikela ng'ulilu yenu mwaveni. ");
INSERT INTO ndj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yumwi vafyangu! Isaya atungili maha milandu ya yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Chapanga akudeta, vandu ava vakujuma nenga kwa mulomu hela, lakini mundima shawu vava kutali na nenga, lakini ngunda shawu siva kutali na nenga. ");
INSERT INTO ndj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kundundamila kwawu kuna mana ng'odu, nongwa vakuwula malayishu va vandu hela!” ");
INSERT INTO ndj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu alikemili lipinga lya vandu limwisili, kavawombela, “Mupikanishi na mumanyi! ");
INSERT INTO ndj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chindu chimutaya mundu wafu chila chimwingila mugati ha, ila chila chimufuma. Achi ndi chimutaya mundu wafu.” ");
INSERT INTO ndj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pambeli vanachuli vamuyendela, vamuwombela, “Yuwi kumanya chivaluma Mafwalisayu mundima shawu pavapikanishili filongu fiwuwombili?” ");
INSERT INTO ndj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lakini mweni kavayangula, “Muhali wungajila kukwetiwa na Tati wa wangu yaveli kumbindi dawutupuliwi,” ");
INSERT INTO ndj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Mukotoo kuvayipwelesha veni! Vangalimesu mesu, fiwongosi va vangalimesu na ngalimesu pamulongosha ngalimesu monga, vosi vavili vakudubukila mumyowu.” ");
INSERT INTO ndj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petili kadeta, “Tuwombeli mana ya chilangushilu achi.” ");
INSERT INTO ndj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kavawombela, “Yumwi muvahela luhunja pitu vengi? ");
INSERT INTO ndj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mumanya ng'odu? Kila chiyingila mugati chikuyenda mumunda na pambeli chikufumishwa pawuyenda kudasi. ");
INSERT INTO ndj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lakini findu fifuma mumlomu fikufuma mundima na afi ndi fikumutaya mundu wafu. ");
INSERT INTO ndj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nongwa kundima kukufuma hoshu sha wafu simugola awulayi na agoli uwoni na upeji na wifi na utovileli wa ufyangu na kuvajowola vengi. ");
INSERT INTO ndj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Afi ndi fimutaya mundu wafu. Lakini kulya ngajila kunava mawoku kukumtaya mundu wafu ha.” ");
INSERT INTO ndj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu awukili pala kayenda kwikala kumukova wuveli pabehi ya Tilu na Sidoni. ");
INSERT INTO ndj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Topi, mawu yumu Mkanani wa mlima wula amwisilili, palila kwa lishu, “Bambu, mwana wa Dawudi ung'oneli lusungu, kamwali wangu akufwashiwa na chinyamkela.” ");
INSERT INTO ndj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lakini Yesu kamuyangula chindu ha. Topi, vanachuli vaki vamuyendela, vamuwombela, “Mumuwombeli ayendi kwanongwa akutukovikela kunu akutuvikila chowu.” ");
INSERT INTO ndj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kamuyangula, “Nayishiwa kwa vafungami va nyumba ya Isilaeli yivayaghamilili.” ");
INSERT INTO ndj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Topi, yula mawu kayisa kamugondamila, kadeta, “Bambu, wundangi.” ");
INSERT INTO ndj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu kamuyangula, “Finofu ha kutola filivi fya vana na kuvayasila vagalu.” ");
INSERT INTO ndj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mawu ayu kayangula, “Nakaka, Bambu, lakini hata galu akulya fyaponishili Bambu mundu kufuma pamesa.” ");
INSERT INTO ndj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu kayangula, “Mawu, ujumilwa waku mkomi, topi, yigoleki ngimu wudayila.” Yula kamwali waki kanana chipindi chichila chila. ");
INSERT INTO ndj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu awukili pala kayenda kuluwongu ya lihiva Galilaya, kakwela kuchidunda, kayikala. ");
INSERT INTO ndj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Vandu vatangalili vamwisila, vavayegha vandevindevi na vangalimesu na fikwavakwava na vangadeta na vamonga vatangalili yivaveli vatami, vavavika pamawulu va Yesu na mweni kavalowola. ");
INSERT INTO ndj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lipinga lila lya vandu vajingili nendu pavawonili ngadeta akudeta na vapombalili vanana na vandevindevi vakuyendayenda na vangalimesu mesu vakulola, vandu vamujuma Chapanga wa Isilaeli. ");
INSERT INTO ndj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Topi Yesu avakemili vanachuli vaki, kadeta, “Nguvawonela lusungu vandu ava kwanongwa vayikala na nenga kwa majuva matatu, ponopa vavahela filivi. Ngudayila ha kwivatawula na kuvaleka na njala vakuwesha kushunga mudeha.” ");
INSERT INTO ndj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Vanachuli vaki vamdashili, “Tuva pachivala, datupati koti filivi fya kukwila lipinga lyosi ali?” ");
INSERT INTO ndj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu kavadasha, “Muvanayu mibumunda miningi?” Vamuyangula, “Saba na fisomba fidokwa.” ");
INSERT INTO ndj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Topi, Yesu kaliwombela lipinga lya vandu liyikali pasi. ");
INSERT INTO ndj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pambeli kayitola yila mibumunda saba na fila fisomba, kamulumba Chapanga, kafidumula, kavapa vanachuli vaki na veni vavavaghashila vandu. ");
INSERT INTO ndj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Vosi valya, vayikuta, pambeli vakungasha fisighalili, vamemesha fitandavala saba. ");
INSERT INTO ndj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ava valili vaveli valulumi elufu mchechi ngajila kuvalanga vadadala na vana. ");
INSERT INTO ndj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pambeli Yesu kavayitawula vandu, kayipaka watu kayenda mkowa wa Magadani. ");
INSERT INTO ndj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafwalisayu na Masadukayu vamuyendilili Yesu, ili kumuyesha, vamuluva avalangushi mihilu kufuma kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lakini Yesu kavayangula, “Payifika lumihi yumwi mukudeta, ‘Dakuchiyi finofu kwanongwa lulanga luva lukeli!’ ");
INSERT INTO ndj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na putiputi pamuwona mafundi pii mukudeta nalelu dakuvi na ndonya, nongwa lulanga lukeli na mafundi vakwila! Topi, yumwi mwimanya munu kulola chipindi kwa kulola lulanga, lakini kumanya chilangushilu cha chipindi achi mumanya ha. ");
INSERT INTO ndj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Chileli achi cha wafu chingajila kumujumila Chapanga! Chikudayila chilangushilu, lakini chikupata chilangushilu chochosi ha, ili chilangushilu chila cha Yona.” Topi, kavaleka, mweni kawuka. ");
INSERT INTO ndj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Vanachuli vaki pavajabukili kala mwambu monga wa lihiva, kumbi vayivasuwa kutola mibumunda. ");
INSERT INTO ndj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu kavawombela, “Mwikali mesu na muyivavali na simika ya Mafwalisayu na Masadukayu!” ");
INSERT INTO ndj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lakini veni vaveli vakwiwombela, “Akudeta naha kwanongwa tutola ng'odu mibumunda.” ");
INSERT INTO ndj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu kafimanya fivayihola, kavawombela, “Yumwi vandu yimuveli na ujumilwa mdokwa! Mbona mukuwombana kwilata mibumunda yimwilekili? ");
INSERT INTO ndj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mkalihela kumanya? Mukukumbuka duhu, pandiyiketulili yila mibumunda muhanu na kwanongwa ya vala vandu alufu muhanu? Mwamemishili fitandavala finingi fya mibumunda yisighalili? ");
INSERT INTO ndj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Awu yila mibumunda saba yivagayiliwi vala vandu alufu mchechi, mwakungili fitandavala finingi fya mibumunda yisighalili? ");
INSERT INTO ndj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Wuli mbona yumwi mukumanya ng'odu kucha ngadeteyi kwilata mibumunda ng'odu? Mwivavali na simika ya Mafwalisayu na Masadukayu!” ");
INSERT INTO ndj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Apa vanachuli vamanya kucha avawombilili vayivavali na simika ya mibumunda ha, ila na ngulilu sha Mafwalisayu na Masadukayu. ");
INSERT INTO ndj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu pafikili mwambu wa Kayisalia Filipu, avadashili vanachuli vaki, “Vandu vakudeta kucha Mwana wa Mundu ndi ghani?” ");
INSERT INTO ndj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vamuyangula, “Vamonga vakudeta yuwi Yohani mbatisha, vamonga vakudeta yuwi Eliya na vamonga vakudeta yuwi Yelimiya awu yumu wa vambuyi.” ");
INSERT INTO ndj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu kavadasha, “Na yumwi mukudeta nenga ghani?” ");
INSERT INTO ndj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petili kayangula, “Yuwi kuva Kilistu Mukombola Mwana wa Chapanga yaveli munofu.” ");
INSERT INTO ndj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kadeta, ngiba yuwi Simoni mwana wa Yona, kwanongwa kwahela mundu yoyosi yakugubutulili chilongu achi ila Tati wangu yaveli kumbindi, ");
INSERT INTO ndj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na nenga ngukuwombela: Yuwi ndi Petili na paligonguveli ali dajengi lipinga lya vandu limjumilili Kilistu lyangu, wala liwovi lya kusova dalilemwi. ");
INSERT INTO ndj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dandikupi chifuwulilu cha Wutwa wa kumbindi kwa Chapanga, Chindu dawuchitatili mumlima awu dachitatiwi wuwowu kwa Chapanga na chila dawuchifuwulili mumlima awu, dachifuwuliwi wuwowu kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pambeli kavakayika vanachuli vaki vakotoo kumuwombela mundu yoyonda kucha mweni ndi Kilistu Mukombola. ");
INSERT INTO ndj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kukandila chipindi chila Yesu akandili kuvawombela vanachuli vaki ngajila chifisu, “Danyendi Yelusalemu na aku vavaha na vatambika na vakomi na vawula va Malawu davagoboli nendu. Davang'ulayi lakini lijuva lya tatu dashukushiwi.” ");
INSERT INTO ndj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petili papikanishili nawula kamukwegha Yesu pambali, kakanda kumulakalila, Kotoo kudeta nahawu Bambu! Chilongu achi dachikupati ng'odu! ");
INSERT INTO ndj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lakini Yesu kaghalambuka, kamuwombela Petili, “Wuki pawulongolu yangu Lijangavandu! Yuwi ukungingama nenga. Fiwuyihola fya Chapanga ha, fya mundu!” ");
INSERT INTO ndj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pambeli Yesu kavawombela vanachuli vaki, “Mundu yoyonda padayila kuva ndundami wangu, ayilemi mweni, atoli lupingika lwaki, angovikeli. ");
INSERT INTO ndj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nongwa mundu yadayila kuulowola unofu vaki mweni, dawuyaghamishi, ");
INSERT INTO ndj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lakini mundu yawuyaghamisha unofu vaki kwanongwa ya nenga dawupati. Ngiba liki mundu paupata unaiza wosi wa mlima awu kunu kauyaghamisha unofu vaki? Awu mundu datoli chindu liki chivi badili ya unofu vaki? ");
INSERT INTO ndj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nongwa mwana wa mundu dayisi muukomi wa Tati waki pamu na makungu waki na apa ndi davahombi kila mundu ngimu wagolili. ");
INSERT INTO ndj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nakaka nguvawombela, kuvaveli vamonga bahapa davasovi ha mbaka vamuwoni tanila Mwana wa Mundu payisa muwutwa waki.” ");
INSERT INTO ndj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pavapitili majuva sita, Yesu kavatola Petili na Yakobi na Yohani mlongu mundu, kayenda nawu weka yawu kumbindi kuchidunda chitali. ");
INSERT INTO ndj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aku Yesu aghalambukili wushu pawulongolu yawu, wushu waki wung'ala kucha lijuva na yingwa shaki siva ngeli kucha lulanga. ");
INSERT INTO ndj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pambeli vandundami ava vatatu vavawona Musa na Eliya vabwituka, vakuywanga na Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Topi, Petili kamuwombela Yesu, “Bambu, nyanyi yufwi twikali bahapa! Pawudayila apa dajengi fibudi fitatu, chimu chaku na chimu cha Musa na chimu cha Eliya.” ");
INSERT INTO ndj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Paghaveyi akali akudeta afi, lifundi ling'alili livagubika na lishu lipikanika kufuma mulifundi lila, “Ayu ndi Mwana wangu yindimtamili, mayiliwa na mweni. Mumpikanishi.” ");
INSERT INTO ndj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Vanachuli vaki pavapikanishili naha vawa wifuma, vatila nendu, ");
INSERT INTO ndj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu kavayisila na kavagufya, kadeta, “Muwoloki, mukotoo kutila!” ");
INSERT INTO ndj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pavalolili kumbindi vamuwona mundu ha, ila Yesu weka hela. ");
INSERT INTO ndj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Topi, pavaveghi vakusunuka chidunda, Yesu kavakayika, “Mkotoo kumuwombela mundu findu yimufiwonili mbaka Mwana wa mundu pashukushiwa kufuma munjifwa.” ");
INSERT INTO ndj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pambeli vanachuli vamudasha, “Mbona vawula va Malawu vakudeta mbaka Eliya ayisi tanila?” ");
INSERT INTO ndj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kavayangula, “Nakaka, Eliya dayisi kutanda findu fyosi, ");
INSERT INTO ndj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lakini nguvawombela, Eliya kayisa kala lakini veni vamumanyili ha, ila vamugolilili kucha wuvadayilili. Wuwowu Mwana wa Mundu dateshiwi mumawoku vawu.” ");
INSERT INTO ndj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Topi vala vanachuli vamanya kucha aveli akuvawombela Yohani mbatisha. ");
INSERT INTO ndj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pavalifikilili kandi lila lipinga lya vandu, mundu yumu amuyendilili Yesu, kamutundamila, ");
INSERT INTO ndj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Kadeta, Bambu muwoneli lusungu mwana wangu kana chisilika, akugobuleka munu, myanja yitangalili akuwila mumotu na mumachi. ");
INSERT INTO ndj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngamuyeghili kwa vanachuli vaku lakini vaweshili ha kumulowola.” ");
INSERT INTO ndj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kayangula, “Yumwi chileli chingajila ujumilwa, chiyaghamili! Dandiyikali na yumwi mbaka ndili? Dandivawunishili yumwi mbaka ndili? Mumuyeghi apa mwana ayu.” ");
INSERT INTO ndj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Topi, Yesu kamulakalila yula chinyamkela na mweni kamufuma yula mwana, mwanja wuwula wula kanana. ");
INSERT INTO ndj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pambeli vanachuli vamuyendela Yesu kwa chifisu, vamudasha, “Kwanongwa liki yufwi tulemwa kumuwusha yula chinyamkela?” ");
INSERT INTO ndj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kavayangula, “Nongwa ya ujumilwa wenu mdokwa. Nguvawombela nakaka, pamuva na ujumilwa hela, wuvi mdokwa hata kucha mbeyu ya likuyu, mukuwesha kuchiwombela chidunda achi, Wuki apa yendi pala, cheni dachiyendi. Kwahela chindu chingajila yumwi kuwesha.” ");
INSERT INTO ndj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lakini mayandiku vamonga vayandika, “Finyamkela fya ndambu ayi fikuwuka kwa njila ayi ha, ila kwa kudadava na kwikaja kulya.” ");
INSERT INTO ndj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pavaveghi pamu aku Galilaya, Yesu avawombilili, “Mwana wa mundu datawuliwi mumawoku va vandu. ");
INSERT INTO ndj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Davamuwulayi, lakini lijuva lya tatu kukandila pasovili, dashukushiwi.” Vanachuli vang'ong'oteka munu. ");
INSERT INTO ndj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pavafikili Kapelinaumu vandu yivakunganya kodi ya Nyumba ya kudadavila vamuyendilili Petili, vamudasha, muwula wenu akuhombaya kodi ya Nyumba ya kudadavila? ");
INSERT INTO ndj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petili kayangula, “Yina, akuhomba.” Topi, Petili payingilili munyumba, hata akali hela kudeta chilongu chochosi, Yesu kamudasha, Simoni, “Yuwi ukuwona wuliwuli? Vatwa va mlimawu vakukunga ushulu awu kodi kufuma kwa vaghani! Kufuma kwa vanamlima awu kwa vahenja?” ");
INSERT INTO ndj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petili kayangula, “Kufuma kwa vahenja, Yesu kavawombela mani naha vanamlima yikuvayilata ha.” ");
INSERT INTO ndj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lakini tukotoo kuvavifya, yendi kulihiva kalopoli, Toli somba yatalili kuwomela, umutumbuli, mugati ukusiwona mbiya sha saka. Toli ukahombi kwanongwa ya nenga na yuwi. ");
INSERT INTO ndj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chipindi chila vanachuli vamuyendilili Yesu, vamudasha, “Ghani yaveli mkomi nendu muwutwa wakumbindi kwa Chapanga?” ");
INSERT INTO ndj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu kamukema mwana yumu, kamuwolosha pagati yawu, ");
INSERT INTO ndj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Pambeli kadeta, “Nguvawombela nakaka pamupota kughalambuka kuva kucha vana, damwingili ng'odu muwutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yoyosi yangajila kwikwisha kucha mwana ayu, ayu ndi yaveli mkomi muwutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mundu yamulibushila mwana yumu kucha ayu kwa litawa lyangu, akumbokela nenga.” ");
INSERT INTO ndj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Lakini mundu damuvifyi yumu wa ava vadokwa yivajumilili nenga, yingaveli ngiba awopiwi mungulu ligonguveli lya kushaghila na kudibashiwa mumachi. ");
INSERT INTO ndj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ngiba mlima kwanongwa ya ngingamu sivagufya vatangalili. Ngingamu asi dasifumbuki lakini ngiba mundu yula dafigoli figoleki. ");
INSERT INTO ndj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kucha liwoku awu liwuli lyaku palikuvifya wulidumuli na wuliyasi kutali nayuwi. Ngiba kwa yuwi kwingila muunofu wa jola ngajila liwoku awu liwulu, pitu kudangiwa mulifumbika pawuva na mawoku mavili na mawulu vaku mavili. ");
INSERT INTO ndj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Lisu lyaku palikuvifya, likolopoli na kulidangila kutali na yuwi. Ngiba kwingila muunofu pawuva nandoju, pitu kudangiwa mumotu wa lifumbika pawuva na mesu vosi mavili. ");
INSERT INTO ndj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mwivavali! Mukotoo kumubedala hata yumu wa ava wadokwa. Nguvawombela, Makungu vawu aku kwa Chapanga majuva vosi vava pawulongolu pa Tati wangu yaveli kumbindi. ");
INSERT INTO ndj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mana Mwana wa Mundu ayisili kuchilowola chiyaghamilili. ");
INSERT INTO ndj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mukuwona wuliwuli? Mundu paghava na vafungami mya, pamuyaghamisha yumu, akugola wuliwuli? Akuvaleka vala milongu tisa na tisa kuchidunda, akuyenda kumusaka yula yayaghamilili. ");
INSERT INTO ndj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pamuwona, nguvawombela nakaka, akumunemilela yula pitu hata vala milongu tisa na tisa vangajila kuyaghamila. ");
INSERT INTO ndj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wuwowu, Tati wenu yaveli kumbindi, akudayila ng'odu hata yumu wa ava vadokwa vayaghamili. ");
INSERT INTO ndj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mlongu waku pakuvifya, muyendi mukajovi pamuva weka yenu Pakupikana dawuvi kumupata mulongu waku. ");
INSERT INTO ndj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pakupikana ng'odu, umtoli mundu yumu awu vavili pamu na yuwi ili hoshu sha vatovilela vavili awu vatatu chilongu chosi chihighiwi. ");
INSERT INTO ndj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pavapikana ng'odu ava, uliwombeli lipinga lya vandu limjumilili Kilistu, kucha palipikana ng'odu lipinga lya vandu limjumilili Chapanga, Topi, yavavika yumwi kucha vandu vangajila kumumanya Chapanga na vasumula mbiya.” ");
INSERT INTO ndj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nguvawombela nakaka, chila damuchitati mumlima wuwula wula dachitatiwi kumbindi kwa Chapanga na chimuchifuwula pamulima wuwula wula dachifuwuliwi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kandi nguvawombela vavili pavajumila apa pamlimawu kwilata chindu chochosi cha kuluva, Tati wangu wa kumbindi davagoleli chindu achi. ");
INSERT INTO ndj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwa nongwa poposi pala pavayikungasha vavili awu vatatu kwa litawa lyangu, nenga ndiva pamu na veni.” ");
INSERT INTO ndj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pambeli Petili kamuyendela Yesu kamudasha, “Bambu mlongu wangu pamifya ndimupomeli kaningi? Myanja saba?” ");
INSERT INTO ndj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kamuyangula, “Ngudeta myanja saba hela ha, ila milongu saba myanja milongu saba. ");
INSERT INTO ndj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ndi nongwa wutwa wa kumbindi kwa Chapanga wukwifwana na mutwa yumu yadayileyi tolitoli ya Vandumindumi vaki. ");
INSERT INTO ndj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pakandili kukawula, vamuyeghela mundu yumu yaveli na nongwa ya mbiya milongu alufu. ");
INSERT INTO ndj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mundoyu aveli kavahela cha kuhomba, Ponopa Bambu mundu kalayisha vamuhemeshi mweni na mdalamundu na vana na fyosi fyaveli nafyu, akahombi nongwa. ");
INSERT INTO ndj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Topi, ayu ndumindumi katundama pawulongolu yaki, kadeta, ‘Umeti danguhombi nongwa yaku yosi.’ ");
INSERT INTO ndj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yula Bambu kamuwonela lusungu, kampomela nongwa yila, kamuleka ayendi.” ");
INSERT INTO ndj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lakini ndumindumi yula awukili, kamuwona yumu wa ndumindumi mumonga yaveli na nongwa yaki ya mbiya mya. Kamukamula kamukama pangulu kunu padeta, ‘Hombi mbiya shangu!’ ");
INSERT INTO ndj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yula ndumindumi monga katundama, kamuluva, ‘Umeti danguhombi.’ ");
INSERT INTO ndj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lakini mweni kalema, ila kamuwopa muchijaka mbaka pahomba yila nongwa. ");
INSERT INTO ndj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Topi, vandumindumi vamonga pavawonili chilongu achi vang'ong'oteka munu, vayenda kumuwombela Bambu wawu chilongu chila chibwitukili. ");
INSERT INTO ndj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Topi, yula Bambu kamukema yula ndumindumi kamuwombela, yuwi ndumindumi mwafu munu! Yuwi wanuvili na nenga ngupomela nongwa yaku yosi. ");
INSERT INTO ndj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na yuwi wungamuwonilili lusungu kucha nenga wungugolilili kwa ndumindumi muyaku? ");
INSERT INTO ndj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Topi Bambu yula akalalili munu, kamufumisha yula ndumindumi alatuliwi mbaka pahomba nongwa yosi.” ");
INSERT INTO ndj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu kamalilila kwa kudeta, “Na Tati wangu yaveli kumbindi davagoleli nahawu kucha mundu pamupomela ng'odu mlongu mundu kwa moyu waki wosi.” ");
INSERT INTO ndj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu akamalili kudeta filongu fila, kawuka Galilaya, kayenda Yudeya kumwambu ya lweni Yoludani. ");
INSERT INTO ndj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Vandu vatangalili vamukovikela, mweni kavalowola. ");
INSERT INTO ndj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafwalisayu vamu vamwisilili, vamudasha kwa kumushengeta, “Wuli, malawu vetu vakujumisha mlumi kumleka mdala mundu kwanongwa yoyosi?” ");
INSERT INTO ndj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kavayangula, “Wuli, musoma duhu Mumayandiku Vang'alili, kucha pakwandi Chapanga amulumbili mundu mlumi na mdala, ");
INSERT INTO ndj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chapanga adetili, ‘Kwa nongwa ayi mlulumi damuleki Tati waki na mawaki davayibavi na mdala mundu na veni davavi yumu?’ ");
INSERT INTO ndj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ponopa, veni vavili kandi ha ila mundu yumu. Topi chavikili pamu Chapanga, mundu akotoo kuchilekanisha.” ");
INSERT INTO ndj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lakini Mafwalisayu vamudasha, “Nongwa liki Musa atulayishili kumleka mdala mbaka yiyandikiwi talaka ndi alekiwi?” ");
INSERT INTO ndj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kavayangula, “Musa avajumishili kuvaleka vadala venu nongwa ndima shenu sidindala. Lakini yavelili nahawu ha Chapanga palumbeyi mlima. ");
INSERT INTO ndj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Topi, nguvawombela, mundu yamleka mdala mundu na kumuheta wingi akali akagola uwoni, ila paamleka kwanongwa ya uwoni wa mdala yula.” ");
INSERT INTO ndj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Vanachuli vaki vamuwombela, “Kucha milandu ya mlumi na mdala yiva naha, ngiba kuleka kuheta.” ");
INSERT INTO ndj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kavawombela, “Vosi ha yivawesha kupokela chilongu achi, ila vala hela yavatangili Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nongwa kuna nongwa simu simugola mundu aleki kuheta, vamonga kwanongwa vawoneka nahawu na vamonga kwanongwa vagoliwa nahawu na vandu na vamonga vawona ngiba vakotoo kuheta kwanongwa ya wutwa wa kumbindi kwa Chapanga. Yawesha kupokela ng'ulilu ayi apokeli.” ");
INSERT INTO ndj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pambeli vandu vamuyeghela Yesu vana vadokwa avavikili mawoku na kuvadadavila kwa Chapanga. Lakini vanachuli vavalakalila. ");
INSERT INTO ndj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu kadeta, “Muvaleki vana ava vayisi kwa nenga, mukotoo kuvakana nongwa Wutwa wa kumbindi kwa Chapanga ndi wa vandu yivaveli kucha vana ava.” ");
INSERT INTO ndj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Topi, kavavikila mawoku, pambeli kawuka. ");
INSERT INTO ndj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu yumu ayisili kwa Yesu, kamudasha, “Muwula, goli chindu liki chinofu ili ndiwupati unofu wa jola?” ");
INSERT INTO ndj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kamuwombela, “Mbona ukudasha milandu ya nyanyi? Kuna yumu hela yaveli msangi. Pawudayila kwingila muunofu wa jola, koli Malawu va Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yula mundu kamudasha, malawu voti? Yesu kadeta, “Kotoo kuwulagha, kotoo kugola uwoni, kotoo kuhija na kotoo kutovilela ufyangu, ");
INSERT INTO ndj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","vapikanishi tati waku na mawu waku na umutami mjofi mwawu ngimu witama umweni.” ");
INSERT INTO ndj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yula chijana kamuwombela, “Fyosi afi ndifikola: chamunu goli liki?” ");
INSERT INTO ndj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu kamuwombela, “Leki ukudayila kuva nyanyi, yendi kawuli mali shaku, mbiya dawusipati uvapi vagaju na yuwi dawuvi na lusanja kwa Chapanga pambeli wisi ungovikeli.” ");
INSERT INTO ndj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yula chijana papikanishili afi, kawuka kunu pang'ong'oteka, nongwa aveli mlundamali. ");
INSERT INTO ndj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Topi Yesu kavawombela vanachuli vaki, “Nakaka nguvawombela, yidindala munu kwa mulundamali kwingila Muwutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kandi nguvawombela, yipusuka nendu kwa ndembu kwingila muchilanga cha sasiya, pitu mulundamali kwingila muwutwa wa kumbindi kwa Chapanga,” ");
INSERT INTO ndj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Vala vanachuli pavapikanishili nawula vajinga munu, vamudasha, “Leki yiva nahawu, ghani dalowoki?” ");
INSERT INTO ndj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu kavalola, kadeta, “kwa mundu fidindala, lakini kwa Chapanga findu fyosi fipusuka.” ");
INSERT INTO ndj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pambeli Petili kadeta, “Yufwi tufileka fyosi tukukovikela, datupati liki?” ");
INSERT INTO ndj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kavawombela, “Nguvawombela nakaka mwana wa mundu payikala muchigoda cha wutwa wa muukomi, yumwi lilongu na vavili yimungovikela damwikali mufigoda pamuvahigha makabila lilongu na vavili va Isilaeli. ");
INSERT INTO ndj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na mundu yayilekili nyumba, mlongu awu muhaja, tati awu mawu, vana awu fitava kwanongwa ya nenga, dapokeli myanja mya na nendu, dapati na unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lakini yivaveli vakwaa davavi kumbeli na yivavelili kumbeli davavi vakwaa. ");
INSERT INTO ndj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Wutwa wa kumbindi kwa Chapanga wifwana nga mundu yumu munachitava cha misabibu, yavelili kafuma pamalavila puti kuvavika vagolafichuku va muchitava chaki. ");
INSERT INTO ndj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Awombanili nawu kuvahomba mbiya ijala ya lijuva limu, pambeli kavayegha muchitava chaki cha misabibu. ");
INSERT INTO ndj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kawuka kandi saa tatu pamalavila, kavawona vandu vamonga vawoloka kusoku, vavahela chichuku cha kugola. ");
INSERT INTO ndj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kavawombela, ‘muyendi kuchitava changu cha misabibu mukagoli chichuku, nenga dandivahombi ijala yenu.’ ");
INSERT INTO ndj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Topi, vayenda. Yula munachitava kawuka kandi saa sita pamusi na saa tisa kagola nga wuwula wula. ");
INSERT INTO ndj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hata payifikili saa lilongu na limu palumihi, kawuka kandi, kavawona vandu vamonga vawoloka pala pasoku. Topi, kavadasha, ‘Mbona muwoloka apa pamusi posi ngajila kugola chichuku?’ ");
INSERT INTO ndj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Vamuyangula, ‘Kwa nongwa kwahela mundu yatukemili tukagoli chichuku, mweni kavawombela na yumwi muyendi mukagoli chichuku cha muchitava changu cha misabibu.’ ");
INSERT INTO ndj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Lijuva palihongili yula munachitava kamuwombela mkola mbiya waki, vakemi vagola chichuku uvahombi ijala yawu, ‘Ukandi na vala vafikili kumbeli, pambeli umalishili na vala vakwaa.’ ");
INSERT INTO ndj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Topi, vayisa vala yivayisili saa lilongu na limu vapokela kila mundu ijala ya lijuva limu. ");
INSERT INTO ndj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Vala va kwaa kufika pavafikili, vakacheyi davapokeli sitangalili, lakini veni vapata ngimu wuwula wula kila mundu ijala ya lijuva limu. ");
INSERT INTO ndj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Vasipokela mbiya shawu, vakanda kumung'ong'utekela yula bambu. ");
INSERT INTO ndj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Vadeta, ‘Ava vafikili kumbeli vagola chichuku cha kwa lisaa limu hela. Mbona kutugolela tulinganili na veni kunu yufwi twiwunishila tugola chichuku chikomi na lijuva likali lituyakila?’ ");
INSERT INTO ndj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Topi yula bambu kamuyangula yula muyawu yumu, ‘pikanishi ghanja, ngubanja chindu ng'odu! Twawombanili ng'odu na nenga, kucha ndivahombi ijala ya lijuva limu? ");
INSERT INTO ndj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Toli ijala yaku, yendi, ngudayila kumupa ayu wa kumbeli mulinganili na yuwi. ");
INSERT INTO ndj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ndivahela haki ya kugola mali shangu ngimu wudayila ndimweni? Wuli, ukuwona weyi kwanongwa nenga ndiva msangi?’ ” ");
INSERT INTO ndj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu kamalilila kwa kudeta, “Ndi dayivi nahawu, yivavelili kumbeli ponopa davavi vakwaa na vakwaa davavi va kumbeli pambeli.” ");
INSERT INTO ndj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu paghaveyi akuyenda kumbindi Yelusalemu, avatolili vala vanachuli lilongu na vavili pachifisu na paghaveyi mudeha kavawombela, ");
INSERT INTO ndj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mpikanishi! Tukuyenda Yelusalemu na aku Mwana wa Mundu davamuhadishi kwa mtambika mkomi na vawula va Malawu, veni davamuhighi awulayiwi kwa kumuvangilila mulupingika. ");
INSERT INTO ndj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Davamuhadishi kwa vandu vangajila kumumanya Chapanga ili vamudanili, dalatuliwi ndomondu na kuvangiliwa mulupingika, lakini lijuva lya tatu kukandila pasovili, dashukushiwi.” ");
INSERT INTO ndj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mdala wa Sebidayu amwisilili Yesu pamu na vana vaki, katundama pawulongolu yaki kumuluva chindu. ");
INSERT INTO ndj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu kamudasha, “Chiwudayila liki?” Mawu yula kamuwombela, “Ngukuluva undangi muwutwa waku, ava vana vangu vavili vayikali yumu mwambu waku wa mlilu na wingi mwambu waku wa mkiyi.” ");
INSERT INTO ndj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu kamuyangula, “Mumanya ha kucha mukuluva chindu liki. Mukuwesha kulandila lwindi lwa ndeshiwu danandili nenga?” Vamuyangula, “Tukuwesha.” ");
INSERT INTO ndj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu kavawombela, “Nakaka damulandili lwindi lunandila nenga, lakini kwikala kumulilu awu kumukiyi chichuku cha ya nenga ha, chindu achi davapati vala yivashawuliwili kala na Tati wangu.” ");
INSERT INTO ndj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Vala vanachuli vamonga lilongu pavapikanishili afi, vavalakalila vala valongu vavili. ");
INSERT INTO ndj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu kavakema, kavawombela, “Mumanya kucha vatavala va vandu vangajila kuva Vayawudi vakutavala vandu vawu kwa mawovi na vakomi vala vakuvatavala vandu vawu. ");
INSERT INTO ndj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakini kwa yumwi yikotoo kuva nahawu, ila yadayila kuva mkomi gati ya yumwi ghavi ndumindumi wa vosi, ");
INSERT INTO ndj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na yadayila kuva wa kwaa gati ya yumwi ghavi ndumindumi wa yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ndambu yiyeyi, Mwana wa Mundu kayisa kukimbanikiwa ha, ila kukimbanika na kutawula unofu waki kuva badili ya vandu vatangalili.” ");
INSERT INTO ndj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu paghaveyi akuwuka mbwani ya Yeliku, lipinga lya vandu lyamukovikelili. ");
INSERT INTO ndj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Topi kwavelili na vangalimesu vavili vayikalili mumbalimbali ya deha, pavapikanishili kucha Yesu akupita pala, valandushili lishu, “Bambu, mwana wa Dawudi, wutuwoneli lusungu!” ");
INSERT INTO ndj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lila lipinga lya vandu livalakalila na kuvawombela vanyamali. Lakini veni valandusha nendu lishu, “Bambu mwana wa Dawudi, wutuwoneli lusungu!” ");
INSERT INTO ndj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu kawoloka, kavakema na kuvadasha, “Mukudayila ndivagoleli liki?” ");
INSERT INTO ndj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Vamuyangula, “Bambu, tukuluva tuloli.” ");
INSERT INTO ndj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Topi, Yesu kavawonela lusungu, kavagufya mesu vawu na tepu vawesha kulola, pambeli vamukovikela. ");
INSERT INTO ndj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na vanachuli vaki pavaveghi samba vafika Yelusalemu, vafikili tanila Betifage mufidunda fya miseyituni. Pala Yesu avalayishili vanachuli vaki vavili, ");
INSERT INTO ndj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kavawombela, “Muyendi mbaka chijiji chiveli pawulongolu yenu damumuwoni chihongu vamuwopa pamu na ngwada waki. Muvawoposoli munyegheli. ");
INSERT INTO ndj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Leki mundu pavadasha nongwa liki mukumuwopusola, mumuwombeli Bambu akumudayila na tepu mweni davawuyishili.” ");
INSERT INTO ndj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chilongu achi chagolili ili fila fidetiwili na mbuyi fivi. ");
INSERT INTO ndj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Muyiwombeli mbwani ya Sayuni, Loli, Mutwa waku akwisila! Kava mshishamoyu na kayipakila chihongu, ngwada wa chihongu, mwana wa chihongu.” ");
INSERT INTO ndj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Vala vanachuli vayenda vagola ngimu Yesu wavalayililili. ");
INSERT INTO ndj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Vamuyegha yula chihongu pamu na mwana waki, vayala yingwa shawu kumuwongu ya vachihongwi na Yesu kayipaka kumuwongu yaki. ");
INSERT INTO ndj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lipinga lya vandu vayala yingwa shawu mudeha na vandu vamonga vatemula miputila ya mibiki vayala mumbali mbali ya deha kumulibushila. ");
INSERT INTO ndj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mipinga ya vandu valongulili na vala vamukovikela valandusha lishu, “Ajumiwi Mwana wa Dawudi! Anemiliwi ayu yayisa kwa litawa lya Bambu! Ajumiwi Chapanga kumbindi!” ");
INSERT INTO ndj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu paghaveyi akwingila Yelusalemu, mbwani yosi yimema njova. Vandu vakadasheyi, “Ayu ghani?” ");
INSERT INTO ndj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Vandu mulipinga lila vadeta, “Ayu ndi Yesu, mbuyi wa Chapanga kafuma Nasaleti mkowa wa Galilaya.” ");
INSERT INTO ndj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Topi, Yesu kayingila munyumba ya Chapanga, kavavingila panji vandu yivavelili vakuchuusa na kuhemela findu mugati ya nyumba ya Chapanga, kasibidula mesa sha vala yivaveyi vakufunja mbiya na figoda fya vala yivavelili vakuwula vanjiva. ");
INSERT INTO ndj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kavawombela, “Yiyandikiwa Mumayandiku Mang'alili, Chapanga kadeta, ‘Nyumba ya nenga yikukemiwa nyumba ya kudadavila.’ Lakini yumwi mupagola kuva mbaku ya vefi na vapoki.” ");
INSERT INTO ndj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vangalimesu na vakwavakwava vamonga vamuyendilili aku kunyumba Ngomi ya Chapanga, Yesu kavalowola. ");
INSERT INTO ndj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Topi, vatambika vakomi na vawula va Malawu vakalala pavayiwonili miwujawuja yagolili Yesu na vana pavaveghi vakulandula mashu vawu nyumba ya Chapanga pavadeta, “Lujumu kwa mwana wa Dawudi.” ");
INSERT INTO ndj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Topi, vamuwombela, “Kupikana ng'odu chivadeta?” Yesu kavayangula, “Yina ngupikana! Wuli musoma duhu mayandiku ava? ‘Kwa milomu ya vana vadokwa na fyali, ukwipatila jumu yeni.’ ” ");
INSERT INTO ndj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Topi, kavaleka kafuma panji ya mbwani na kuyenda Betaniya, aku kawonja. ");
INSERT INTO ndj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pamavavila puti Yesu paghaveyi akuwuya kumbwani, katopa njala, ");
INSERT INTO ndj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","kaliwona libiki limu mumbalimbali ya deha kaliyendela lakini kaliwona livahela chindu ila mihamba weka. Topi, kaliwombela, “Kotoo kulela fivelekwa kandi jola!” Bahala pala libiki lila linyala. ");
INSERT INTO ndj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Vanachuli pavawonili nawula vajinga, vadeta, “Nongwa liki libiki ali linyala kalopu?” ");
INSERT INTO ndj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kavayangula, “Nakaka nguvawombela, leki pamuva na ujumilwa ngajila hoshu, mukuwesha kugola nahawu. Wekahela ha, ila hata pamuchiwombela chidunda achi ‘Tupuki kayilyasili mubahali,’ dachigoleki nahawu. ");
INSERT INTO ndj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pamuva na ujumilwa, chochosi damuluvi kwa kudadava damupati.” ");
INSERT INTO ndj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu kayingila munyumba ya Chapanga, akawuleyi. Pawuleyi mtambika mkomi na vavaha va vandu vamonga vamudasha, “Ukugola findu afi kwa uwesu wa ghani? Ghani yakupili uwesu awu?” ");
INSERT INTO ndj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kavayangula, “Na nenga nguvadasha chindu chimu, Pamunyangula na nenga dandivawombeli ngugola findu afi kwa uwesu wa ghani. ");
INSERT INTO ndj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mung'ombeli uwesu wa Yohani mbatisha wafumili kwa ghani? Wafumili kwa Chapanga awu kwa vandu?” Lakini vawombana veni kwa veni naha, “Patudeta wafumili kumbindi daatudashi, ‘Mbona mwamjumilili ng'odu?’ ");
INSERT INTO ndj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na patudeta, ‘Wafumili kwa vandu,’ tukutila lipinga lya vandu nongwa vosi vakujumila kucha Yohani mbatisha aveli mbuyi wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Topi, vamuyangula, “Tumanya ha.” Na Yesu kavawombela, “Na nenga dandivawombeli ha ngugola findu afi kwa uwesu wa ghani. ");
INSERT INTO ndj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Yumwi mwikwihola wuliwuli chilongu achi, Mundu yumu yaveli na vana vavili. Kamuwombela yula wa kwaa, ‘Mwana wangu nalelu yendi kagoli chichuku cha muchitava cha misabibu.’ ");
INSERT INTO ndj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yula msongolu kamuwombela ‘Nema!’ Lakini pambeli kaghalambula natilu, kayenda kugola chichuku. ");
INSERT INTO ndj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yula tati kamuwombela mwana waki wingi wuwowu, mweni kamuyangula ‘Yina tati nguyenda!’ Lakini kayenda kuchichuku ha. ");
INSERT INTO ndj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ponopa ghani gati ya ava vavili yagolili fyadayila tati waki?” Vamuyangula, “Yula mwana soli.” Topi, Yesu kavawombela, “Nakaka nguvawombela, yumwi mukali hela kwingila Muwutwa wa kumbindi kwa Chapanga, vasumula mbiya na vawoni davatali kwingila. ");
INSERT INTO ndj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwa nongwa Yohani mbatisha ayisili kwa yumwi kuvalangusha ya ugoleki ya kwikala, yumwi mumujumila ha. Lakini vasumula mbiya na vawoni vamujumila. Hata pamufiwonili afi fyosi yumwi mupomela na kujumila ha.” ");
INSERT INTO ndj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu kadeta, “Mpikanishi chilangushilu chingi. Mundu yumu muna nyumba alimili chitava cha misabibu, kachishengiteshela luviwu, pambeli kakumba lyowu lya kukamila misabibu, kajenga lidimililu. Pambeli kalihadika kwa valimi, mweni kawuka kayenda mwanja mtali mlima wingi. ");
INSERT INTO ndj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pachifikili chipindi cha kubena, avalayishili Vandumindumi vaki kwa vala valimi, ili vakatoli fimu fya fila fivabenili valimi. ");
INSERT INTO ndj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Vala valimi vavakamula vala vandumindumi vamu vamutovanga na wingi vamuwulagha na yula wa tatu vamutovanga na miganga. ");
INSERT INTO ndj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mundu yula kavalayisha Vandumindumi vengi vatangalili kupita vala va mwanja mtasi. Vala valimi vavagola nga wuwula. ");
INSERT INTO ndj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pambeli kamulayisha mwana waki kunu payihola kucha, ‘Davamtili mwana wangu.’ ");
INSERT INTO ndj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lakini vala valimi pavamuwonili mwana waki vawombana veni kwa veni, ‘Ayu ndi muhala mbala. Tumuwulayi ili tutoli mbala yaki!’ ");
INSERT INTO ndj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Topi vamukamula, vamukweghela panji ya chitava chila cha misabibu, vamuwulagha!” ");
INSERT INTO ndj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu kavadasha, “Ponopa yula muna chitava cha misabibu payisa davagoli liki vala valimi?” ");
INSERT INTO ndj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Veni vamuyangula, “Davawulaghi vala vandu vawafu na chitava chila davapi valimi vengi na pambeli vala valimi davamupi fimu fya fila fyavabena.” ");
INSERT INTO ndj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu kavadasha, “Musoma duhu chindu achi mumayandiku vang'alili? Ligonguveli lya kujengela livalemili vajengi, ponopa liva ligonguveli likomi lya chikandilu. Bambu ndi yagolili chilongu achi, na chiva cha chiloja munu kwa yufwi!” ");
INSERT INTO ndj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu kayendelela kudeta, “Ponopa nguvawombela, wutwa wa kumbindi kwa Chapanga dawuwushiwi kwa yumwi na kuvapa vangajila kumumanya Chapanga na yivagola fyadayila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yaponikela pa ligonguveli ali dabenekibeneki na yula dalimponikeli dabajangiki.” ");
INSERT INTO ndj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Vatambika vakomi na Mafwalisayu pavapikanishili afi filangushilu fyaki vamanyili kucha aveli akuvadeta veni. ");
INSERT INTO ndj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ponopa vakasakeyi deha ya kumvakula vamuwopi, lakini vatilili vandu kwanongwa veni vamumanyili mweni mbuyi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu adetili nawu kandi kwa chilangushilu, ");
INSERT INTO ndj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Wutwa wa kumbindi kwa Chapanga wifwana na Mutwa yamtandili mwana waki mlumi lihungu lya kuheta. ");
INSERT INTO ndj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Topi, kavakema Vandumindumi vaki kavalayisha, mukavalaliki vandu vayisi muhalusi, lakini yivalalikiwili valema kwisa. ");
INSERT INTO ndj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kavalayisha kandi Vandumindumi vamonga, kadeta, mukavawombeli vala vandivalalikili. ‘Lihungu lyangu liva kala, senga wangu yanunili kasinjiwa kala, kila chindu chiva kala, mwisi kulihungu!’ ");
INSERT INTO ndj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakini veni vatinuka ha, vayenda, yumu kuchitava chaki na wingi kayenda kufichuku fyaki, ");
INSERT INTO ndj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na vamonga vavakamula vala Vandumindumi vavajowola na kuvawulagha. ");
INSERT INTO ndj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yula mutwa kakalala, kavalayila vamachonda vaki vakavamalili vala vavawulayili vayawu na kubohola mbwani yawu. ");
INSERT INTO ndj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pambeli kavawombela Vandumindumi vaki, ‘Lihungu liva kala, lakini valalikiwa vangajila kulatiwa. ");
INSERT INTO ndj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Topi, muyendi kunjila mukavawombeli vandu vovosi vala, mukavayeghi vayisi kulihungu.’ ");
INSERT INTO ndj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Vala Vandumindumi vawuka, vayenda kunjila, vavayegha vandu vosi, vawafu na vanofu. Mbaka nyumba ya vahenja yamemili, ");
INSERT INTO ndj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mutwa payingilili kavalola vahenja, kamuwona mundu yumu yafwalili ng'odu yingwa ya lihungu. ");
INSERT INTO ndj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mutwa kamudasha, ‘Ghanja kwingila wuliwuli apa ngajila yingwa ya lihungu?’ Lakini mweni kayikala jii. ");
INSERT INTO ndj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Topi, mutwa kavawombela vandumindumi vaki, ‘Mumuwopi mawulu na mawoku mukamuyasi panji muchisi, aku dalili na kugelujula minu,’” ");
INSERT INTO ndj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu kamalilila kwa kudeta, “Valalikiwili vatangala, ila vadokwa yivashawuliwili.” ");
INSERT INTO ndj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mafwalisayu vayenda, vawombana ndambu ya kumuwomesha Yesu kwa filongu fyaki. ");
INSERT INTO ndj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pambeli, vavalayisha Vandundami wawu pamu na Vandundami va lipinga lya Helodi vamudasha, “Muwula, tukumanya kucha yuwi kuva mundu wa nakaka na ukuwula nakaka deha ya Chapanga kwa ugoleki, ukumtila mundu yoyosi ha, kwanongwa ukomi wa mundu kwa yuwi chindu ha. ");
INSERT INTO ndj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ponopa wutuwombeli chiwihola, yiva nyanyi awu ng'odu kuhomba kodi kwa Mutwa wa Loma?” ");
INSERT INTO ndj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lakini Yesu amanyili kala milandu yawu ya wafu, kavawombela, “Yumwi muvafyangu mbona mukunyesha? ");
INSERT INTO ndj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Munangushi mbiya ya kuhombela kodi.” Vamulangusha ligwala lya mbiya. ");
INSERT INTO ndj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Topi, Yesu kavadasha, “Wushu na lihundu ali lya ghani?” ");
INSERT INTO ndj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Vamuyangula, “Mutwa wa Loma.” Yesu kavawombela, “Nyanyi, fya Mutwa wa Loma mumupi Mutwa wa Loma na fya Chapanga mumupi Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pavapikanishili naha vayikanganika, vamuleka, veni vayenda. ");
INSERT INTO ndj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lijuva lila, Masadukayu vamu vadeta, yivasovili vakushukuka ng'odu. Vamu vamwisila Yesu vamuwombela, ");
INSERT INTO ndj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Muwula, Musa adetili mdala pasova mbendi, yula ngalimlyangu ahaliwi na mlongumundu, ili amuleleli vana mlongumundu. ");
INSERT INTO ndj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Topi, pavelili na valongu saba. Soli ahetili pambeli kasova mbendi, kahaliwa kandi na mlongu wingi. ");
INSERT INTO ndj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yiva wuwowu hata kwa mlongu wingi wa tatu, mbaka mlongu wa saba. ");
INSERT INTO ndj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pavasovili valongu vosi na yula ngalimlyangu asovili wuwowu. ");
INSERT INTO ndj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ponopa lijuva pavashukuka vala yivasovili daghavi mdala wa ghani? Kwa vala valumi saba yivasovili? Kwa nongwa vosi saba vamutolili.” ");
INSERT INTO ndj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu kavayangula, “Yumwi muvifya kwanongwa mumanya ha Mayandiku Vang'alili wala liwovi lya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nongwa yivasovili pavashukuka davaheti ha wala kuhetiwa, davavi kucha Makungu wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakini kwilata kushukuka yivasovili, wuli, musoma ng'odu fila fyavawombilili Chapanga? ");
INSERT INTO ndj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Chapanga kadeta, ‘Nenga ndiva Chapanga wa Ibulahimu na Chapanga wa Isaka na Chapanga wa Yakobi!’ Topi mweni Chapanga wa yivasovili ha ila ndi Chapanga wa yivaveli vanofu.” ");
INSERT INTO ndj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lila lipinga lya vandu pavapikanishili naha liyikang'anika ng'ulilu yaki. ");
INSERT INTO ndj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafwalisayu pavapikanishili kucha Masadukayu vavahela chilongu chingi cha kumdasha Yesu, vayikungulili pamu. ");
INSERT INTO ndj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Muyawu yumu aveli mundu wa Malawu, ayeshili kumdasha Yesu kwa kumuyesha. ");
INSERT INTO ndj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Amudashili, “Muwula, amuli liki yiveli ngomi munu pitu shosi mumalawu?” ");
INSERT INTO ndj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kavayangula, “Mtami Bambu Chapanga waku kwa ndima yaku yosi na kwa fuki yaku na kwa luhala lwaku losi: ");
INSERT INTO ndj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ali ndi lilawu likomi na lyakwaa. ");
INSERT INTO ndj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ya pili yikwifwana na ayi, ‘Mtami mjofi waku kucha witama umweni.’ ");
INSERT INTO ndj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malawu vosi va Musa na mayandiku va vambuyi va Chapanga vakwiyidumbila Malawu mavili ava.” ");
INSERT INTO ndj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafwalisayu pavayikungili pamu, Yesu avadashili, ");
INSERT INTO ndj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yumwi mukuwona wuliwuli chilongu achi chimwilata Kilistu Mkombola? Wuli, kava mwana wa lukolu liki?” Vamuyangula, “Wa lukolu lwa Dawudi.” ");
INSERT INTO ndj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kavawombela, “Topi, yikuva wuliwuli kucha kwa liwovi lya Mfuki Mng'alili Dawudi akumkema mweni Bambu? Kwa nongwa adetili. ");
INSERT INTO ndj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bambu amuwombilili Bambu wangu, Wuyikali mwabu wanenga wa mlilu: mbaka ndivaviki mangandawu vaku pasi ya mawulu vaku.’ ");
INSERT INTO ndj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Topi, leki Dawudi akumkema Mkombola Bambu, yikuva wuliwuli Mkombola ghavi mwana wa Dawudi?” ");
INSERT INTO ndj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kwa hela mundu yoyosi yaweshili kumuyangula chilongu. Na kukandila lijuva lililalila kwa hela yagelili kumudasha chindu. ");
INSERT INTO ndj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pambeli Yesu kaliwombela lipinga lya vandu pamu na vanachuli vaki, ");
INSERT INTO ndj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kadeta, “Vawula va Malawu na Mafwalisayu vana uwesu wa kudeta kwanongwa Malawu va Chapanga vamupili Musa. ");
INSERT INTO ndj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ponopa mukamuli na kugola chochosi chadayila kavawombela. Lakini mukotoo kutapula fila fyavagolili, kwanongwa vakugola ha fila fivalandula. ");
INSERT INTO ndj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Vakuwopa misiwu misitu na kuvatwika vandu mumakombi, lakini veni vakulema hata kuyesha kupapa padiki. ");
INSERT INTO ndj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Veni vakugola findu ili vandu vavajumi. Vakufwala viniku sivelili na mayandiku va Malawu pawushu na mumawoku yawu. Na vakufwala mihabiti yawu yivelili na miviniku mikomi. ");
INSERT INTO ndj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Vakudayila fwasi nofu mulihungu na kwikala mufigoda fya hishima munyumba sha kudadavila. ");
INSERT INTO ndj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Vakudayila kujambushiwa kwa ndundamilu musoku na vakudayila kukemiwa na vandu, ‘muwula’ ");
INSERT INTO ndj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakini yumwi mukotoo kukemiwa ‘muwula,’ kwanongwa muwula wenu yumu hela na mwavosi yumwi muva munyumba yimu. ");
INSERT INTO ndj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wala mukotoo kumukema mundu yoyosi ‘Tati’ pa mlima awu kwanongwa Tati wenu yumu hela, yaveli kumbindi. ");
INSERT INTO ndj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wuwula wula mukotoo kukemiwa ‘fiwongosi,’ kwanongwa chiwongosi wenu yumu hela, Kilistu Mkombola. ");
INSERT INTO ndj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yaveli mkomi kwa yumwi ndi ghavi ndumindumi wa yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yaitutumula dapohomushiwi na yaipohumosha datutumuliwi na Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Pishu, yumwi vawula va Malawu na Mafwalisayu, vafyangu! Mukuvatatila vandu mlyangu wa wutwa wa kumbindi kwa Chapanga. Na mwaveni mukwingila ha mugati, wala mukuvayingisha ha vandu yivadayila kwingila vayingili. ");
INSERT INTO ndj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Pishu, yumwi vawula va Malawu na Mafwalisayu, yumwi mukuvapughapugha vangalimlyangu na kutola findu fyawu na kudadava ngumbilu ndali ili kuyilangusha kwa vandu. Kwa nongwa ayi asabu yenu dayivi ngomi nendu. ");
INSERT INTO ndj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Pishu, yumwi vawula va Malawu na Mafwalisayu, yumwi vafyangu! Mukutyanga kujabuka bahali na milima yitangalili ili muweshi kumughalambula mundu ajumili kucha wumujumila yumwi. Pamupata mukuwesha kumgola mwana ayendi mumotu wa lifumbika nendu pitu yumwi. ");
INSERT INTO ndj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Pishu yumwi fiwongosi ngalimesu! Yumwi mukudeta, ‘Kucha, mundu payilapa kwa nyumba ya Chapanga, malapu ava chindu ha, Lakini payilapa kwanongwa chumang'andu ya nyumba ya Chapanga, malapu ava vakumkamula.’ ");
INSERT INTO ndj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yumwi ngalimesu vapufi! Choti chitawukili nendu, Chumang'andu awu nyumba ya Chapanga yiigola ayi chumang'andu kuva ying'alili? ");
INSERT INTO ndj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kandi mukuvawula, ‘Kucha, mundu payilapa pa fyalu pa kutambikila chindu ha, lakini payilapa kwa fupu yivikiwili pambindi ya fyalu pa kutambikila, malapu vala vakumukamula,’ ");
INSERT INTO ndj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yumwi ngalimesu! Choti chiveli na mana munu, Yila fupu awu pala fyalu, paligoliwa litambiku livi ling'alili? ");
INSERT INTO ndj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mundu yayilapa kwa mahali pa kutambikila litambiku, kayilapa kwa mahali pa fyalu na kwa chochosi chivikiwili pambindi yaki. ");
INSERT INTO ndj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na yailapa kwa nyumba ya Chapanga, kayilapa kwa yila Nyumba ya kudadavila na wuwula wula kwa Chapanga yula yayikala mugati. ");
INSERT INTO ndj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na yailapa kwa kumbindi kwa Chapanga, kayilapa kwa chigoda cha wutwa wa kumbindi kwa Chapanga na kwa Chapanga yula yayikalilili chigoda achi. ");
INSERT INTO ndj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Pishu yumwi vawula va Malawu na Mafwalisayu, vafyangu! Vakumugayila Chapanga chindu chimu kwa kila findu lilongu, hata kwa mihamba yiveli na nyambulilu nofu, myaya na mingwema, kunu mukufileka findu fiveli fitalama fya Malawu kucha kugola fyadayila Chapanga, haki na lusungu na ujumilwa findu afi fitawuka mukudayiliwa kufigola ngajila kuyivasuwa fila fimonga. ");
INSERT INTO ndj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Fiwongosi ngalimesu! Mukujabula chindu chidokwa kucha vangosi mufindu fya kulandila, lakini mukumila findu fikomi kucha ndembu! ");
INSERT INTO ndj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Pishu yumwi vawula va Malawu na Mafwalisayu, vafyangu! Mukung'ofuwa lwindi na bakuli kwa panji, lakini mugati mukukuleka mumema findu mufipatili kwa njila ya kuvapoka na ubafu. ");
INSERT INTO ndj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mafwalisayu ngalimesu! Hofuwi lwindi mugati tanila na panji dakuvi nyanyi wuwowu. ");
INSERT INTO ndj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Pishu yumwi vawula va Malawu na Mafwalisayu, vafyangu! Muva kucha sembi. Sivashaghishili kwa panji sikuwoneka kuva nyanyi, lakini mgati mumema mipava ya chikongu na ndambu ya wafu. ");
INSERT INTO ndj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wuwowu yumwi mukuwoneka kwa vandu kwa panji muva vasangi, lakini kwa mugati mumema ufyangu na wafu. ");
INSERT INTO ndj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Pishu yumwi vawula va Malawu na Mafwalisayu, vafyangu! Mukujenga sembi sha vambuyi na kumelimetesha sembi sha vandu goleki. ");
INSERT INTO ndj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mukudeta kucha yufwi tungaveli chipindi cha vavaha vetu tungaveli pamu ha kuvawulagha vambuyi! ");
INSERT INTO ndj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ponopa mukutovilela mwaveni baha kucha muva vana va vandu vavawulayi vambuyi. ");
INSERT INTO ndj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Topi, ponopa mugolikeshi chichuku yila yivakandili vavaha venu! ");
INSERT INTO ndj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yumwi njoka yaveli na usungu! Mukuwesha wuliwuli kwilyepa kuhighilu ya motu wa lifumbika? ");
INSERT INTO ndj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ndi nongwa nenga nguvayeghela mbuyi, vandu yivaveli na luhunja na vawula va Malawu, damuvawulayi na kumvangilila mulupingika vamonga vamu na vamonga damuvalatuli na fiboku munyumba ya kudadavila yenu na kuvasaka mbwani shosi. ");
INSERT INTO ndj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Topi, mbatiwa yosi dayivapati kwanongwa ya mwasi wosi wa vandu goleki wumwayikili muuganga, yina kukandila kumwayika kwa mwasi wa Abeli yaveli ngajila nongwa mbaka yila ya Sakaliya mwana wa Balakiya, yimumuwulayili munyumba ya Chapanga muchumba gati ya pang'alili na pafyalu. ");
INSERT INTO ndj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nguvawombela nakaka, chileli achi dachipati asabu kwanongwa ya njifwa asi. ");
INSERT INTO ndj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalemu! Deku Yelusalemu! Ukuvawulaya Vambuyi na kuvatovanga miganga vala valayishiwili kwa yuwi. Kaningi nyesha kuvakunga vana vaku kwa nenga kucha wula nguku pakunga vana vaki mwifungu ya mbapatilu shaki, lakini mulema. ");
INSERT INTO ndj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Topi loli, nyumba yaku Chapanga dayilekiwi domoo! ");
INSERT INTO ndj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngukuwombela, dawung'oni kandi ha mbaka pawudeta: ‘Anemiliwi ayu yayisayu kwa litawa lya Bambu.’ ” ");
INSERT INTO ndj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu kafuma Munyumba ya Chapanga na paghaveyi akuyenda, vanachuli vaki vamuyendilili, vamulangusha ndambu yivamelimetishili kwa migonguveli ya nyanyi. ");
INSERT INTO ndj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu kavawombela, “Yina, mukuwesha kusilola asi shosi! Nakaka nguvawombela, kwahela hata ligonguveli limu dalisighali kumbindi ya ligonguveli limonga, kila chindu dachibowuliwi.” ");
INSERT INTO ndj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu paghaveyi kayikala pachidunda cha Miseyituni, vanachuli vamuyendilili pachisikafu, vamudasha, “Tuwombeli, findu afi dafivi ndili? Dachilangushiwi chilangushilu liki kwisa kwa yuwi na mwishu wa chipindi?” ");
INSERT INTO ndj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kavayangula, “Muyivavali, mukotoo kujangiwa na mundu. ");
INSERT INTO ndj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwanongwa davabwituki vandu vatangalili vakwisa, pavadeta kucha, ‘mweni ndi Kilistu Mkombola!’ Na veni davavayushi vandu vatangalili. ");
INSERT INTO ndj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Damupikanishi lupwepu lwa ngondu pabehi na kutali, lakini mukotoo kutila, kwanongwa afi dafibwituki, lakini mwishu weni wakali. ");
INSERT INTO ndj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vandu va mlima wumu dawulevi na mlima wingi, wutwa wumu dawulevi na wutwa wingi. Kosi dakuvi na njala na liyighayigha mlima wonda. ");
INSERT INTO ndj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Fyosi afi ndalishu hela kucha matami chipindi chakulela mwana. ");
INSERT INTO ndj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Pambeli davavatawuli ili mugobuliwi na kuwulayiwa. Vandu va milima yosi dayivanyekwi kwanongwa ya nenga. ");
INSERT INTO ndj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Vatangalili davayileki ujumilwa wawu, davayivifyi na kuyinyekwa veni kwa veni. ");
INSERT INTO ndj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Davabwituki vambuyi va udesi vatangalili davavayaghamishi vandu vatangalili, ");
INSERT INTO ndj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","kwanongwa ya kuyongisheka filongu fya wafu, vandu davayitami nendu ha. ");
INSERT INTO ndj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lakini mundu yayiwunishila mbaka kumbelu ayu ndi dalowuliwi. ");
INSERT INTO ndj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ila mwishu wukali hela kufika, achi chilongu cha nyanyi cha wutwa wa kumbindi kwa Chapanga dachilanduliwi mlima wosi kucha utovileli kwa vandu kufuma makabila vosi vangajila kumumanya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Topi, pamuwona chindu cha wafu chikuwesha kuvifya Nyumba Ngomi ya Chapanga, manyi yula yadetiwili na Mbuyi wa Chapanga Daniyeli pawolushiwa mahali pang'alili. Mundu yasoma amanyi mana yaki. ");
INSERT INTO ndj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Topi, yivaveli Yudeya vatuvilili kufidunda.” ");
INSERT INTO ndj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na yaveli palipaghali akotoo kusunuka kutola chindu munyumba yaki. ");
INSERT INTO ndj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yaveli kufitava akotoo kuwuya kumbeli kutola yingwa yaki. ");
INSERT INTO ndj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pishu, kwa vadadala yivaveli na ndumbu na yivayongesha majuva va mbelu! ");
INSERT INTO ndj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mudadavi ili nduvilu yenu yikotoo kuva lijuva lya lupepu awu lijuva lya kupumulila! ");
INSERT INTO ndj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mana chipindi achi dachivi na siki ngomi yingajila kuwoneka kukandila kulumbiwa kwa mlimawu mbaka nalelu, wala dayibwituki kandi ha. ");
INSERT INTO ndj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Leki majuva ava yangayangishiwili ng'odu, kwahela mundu yoyosi angalowuliwili, lakini majuva ava davayangishiwi na Chapanga kwanongwa ya vala yivashawuliwili. ");
INSERT INTO ndj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Topi, kwa majuva vesava mundu pavawombela: ‘Kilistu Mkombola kava apa’ awu ‘kava pala,’ Mkotoo kujumila. ");
INSERT INTO ndj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwa nongwa davabwituki va Kilistu va ufyangu na Vambuyi va udesi na davagoli chilangushilu chikomi na mihilu ya kuwesha kuvayaghamisha, yikuweshikana hata kwa vala vashawuliwili na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mpikanishi, yumwi ndavakayikili kala. ");
INSERT INTO ndj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Topi, pavavawombela, ‘Muloli, kava kucheja, mukotoo kuyenda aku’ awu pavavawombela, ‘Kayififa munyumba, mukotoo kujumila.’ ");
INSERT INTO ndj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwa nongwa kucha lumuli palung'alika kufuma kundamba mbaka kuuhehi, ndi dayivi kwisa kwa mwana wa mundu. ");
INSERT INTO ndj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Pala pawuvelili mtugulu, vandapu vakwikungasha baha.” ");
INSERT INTO ndj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kalopu payiveyi siki majuva vala, dakuvi na chisi wuluwulu na limbalamwesi daliloleki ha, ndondwa dasiponeki kufuma kumbindi kululanga na liwovi lya kumbindi dalitikanyishwi. ");
INSERT INTO ndj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pambeli, chilangushilu cha mwana wa Mundu dachiwoneki kululanga na makabila vosi va mlimawu davawuti, davamuwoni Mwana wa Mundu payisa kumbindi ya mafundi va kululanga na liwovi na ukomi utangalili. ");
INSERT INTO ndj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mweni davalayishi Makungu vaki yivaveli na limbalapi lya kulamika munu davakungashi vashawuliwili kufuma mbembu shosi mchechi sha mlimawu, kufuma mwishu awu wa lulanga mbaka mwishu wingi. ");
INSERT INTO ndj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kwa likuyu muyiwuli chilangushilu awu: Tepu mitafyi yaki payikanda kuva miteki na kuyalula mukumanya kucha ndonya ya pabehi. ");
INSERT INTO ndj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wuwowu yumwi pamuwona findu afi fyosi pafigoleka, mumanyi kucha Mwana wa Mundu samba ayisi. ");
INSERT INTO ndj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nguvawombela nakaka, chileli achi chipiti ng'odu ngajila filongu fyosi afi kugoleka. ");
INSERT INTO ndj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lulanga na mlima dafipiti, lakini filongu fyangu dafipiti ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Liyilata lijuva awu saa, kwahela mundu yamanyili kucha dayivi ndili, wala Makungu va kumbindi kwa Chapanga, wala Mwana, ila Tati weka yaki ndi yamanyili. ");
INSERT INTO ndj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kucha payiveyi chipindi cha Nuhu, nga wuwula wula dayivi kwisa kwa Mwana wa Mundu. ");
INSERT INTO ndj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nongwa chipindechi, lilava likomi lya njifwa likali hela, vandu vaveli vakulya na kulanda, pavaheta na kuhetiwa, mbaka Nuhu payingilili muwula watu mkomi wuvawukema Safina. ");
INSERT INTO ndj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Vamanyili ha kucha kuna liki mbaka chila lilawa likomi lya njifwa palibwitukili, likuvawona vosi. Ayi dayivi hata chipindi Mwana wa mundu payisa. ");
INSERT INTO ndj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chipindechi vandu vavili davavi kufitava: Yumu datoliwi na monga dalekiwi. ");
INSERT INTO ndj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vadadala vavili davavi vakulibula majani, yumu datoliwi na monga dalekiwi. ");
INSERT INTO ndj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Topi, mugungi mesu, kwanongwa mulimanya ha lijuva Bambu wenu dayisi. ");
INSERT INTO ndj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lakini muyiholi chilongu achi! Kucha muna nyumba angamanyili lijuva lyafika mwifi, angagungili mesu, angayilekili ha nyumba yaki vabowoli. ");
INSERT INTO ndj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ponopa yumwi muvi ndemindemi, kwanongwa Mwana wa Mundu dayisi chipindi mungajila kuchimanya”. ");
INSERT INTO ndj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu kayendelela kudeta, “Topi, ndi ndumindumi goleki na yaveli na luhunja, Bambu mundu daamuviki pambindi ya vandu vaki na kumuwombela avapi filivi fyawu kwa chipindi cheni? ");
INSERT INTO ndj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ngiba yula ndumindumi Bambu mundu payisa damuwoni pagola chichuku cha yila. ");
INSERT INTO ndj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nguvawombela nakaka, damuviki ndumindumi ayu awolukeli mali vaki vosi. ");
INSERT INTO ndj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Leki kucha Vandumindumi yangajila goleki payidetela mundima, ‘Bambu wangu kakelwa kuwuya, ");
INSERT INTO ndj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","pambeli akukanda kuvatova vandumindumi vamonga na kukanda kulya na kulanda pamu na vanjayila.’ ");
INSERT INTO ndj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Topi, Bambu mundu payisa lijuva na chipindi chingajila kumanyika. ");
INSERT INTO ndj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Damupi asabu ngomi na kumuvika lipinga limu na vafyangu. Aku dalili na kugelujula minu.” ");
INSERT INTO ndj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Chipindechi Wutwa wa kumbindi kwa Chapanga dawuyifwani na vakavali lilongu yivatolili taa shawu, vayenda kumuyanga Bambu lihungu lya kuheta. ");
INSERT INTO ndj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Muhanu wa vala vaveli vapufi na muhanu yivaveli vana luhunja. ");
INSERT INTO ndj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Vala vapufi vatolili taa shawu, lakini vatolili ha mafuta va kutaya mula. ");
INSERT INTO ndj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lakini vala yivaveli na luhunja vatolili mafuta musupa pamu na taa shawu. ");
INSERT INTO ndj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kumbi Bambu lihungu lya kuheta kakelwa kwisa, vala vakavali vosi vasisila, pambeli vawonja. ");
INSERT INTO ndj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Payifikili pamihi mandandu, kwavelili na chowu ‘Topi, topi! Bambu wa lihungu akwisa, muyendi mukamuyangi!’ ");
INSERT INTO ndj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pambeli vala vakavali vosi vatandamuka, vasitandali taa shawu. ");
INSERT INTO ndj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vala vapufi vavawombela vala yivaveli na luhunja, ‘Mututayili mafuta venu padokwa, taa shetu sikujimika.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini vala yivaveli na luhunja vavawombela, ‘Ava davatukwili ha yufwi na yumwi! Ngiba muyendi kuduka mukayihemileli!’ ");
INSERT INTO ndj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Topi, vala vakavali vapufi pavayendili kuhemela mafuta, kumbeli kunu Muheta kafika na vala vakavali vaveli kala vayingila pamu na mweni munyumba ya muheta, pavayingilili kala mlyangu wutatiwa. ");
INSERT INTO ndj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Pambeli vala vakavali vapufi vayisa, vakema, ‘Bambu, Bambu, wutufuwulili! ");
INSERT INTO ndj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lakini mweni kavayangula, nguvawombela nakaka, yumwi ndivamanya ha.’ ” ");
INSERT INTO ndj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pambeli Yesu kadeta, “Topi, mugungi mesu, kwanongwa mumanya ha lijuva wala saa. ");
INSERT INTO ndj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Chipindechi wutwa wa kumbindi dawuvi kucha mundu yumu yadayileyi kuyenda mwanja. Avakemili vandumindumi vaki, kavahadisha mali shaki. ");
INSERT INTO ndj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Amupili kila mundu kulinganila na chifwani chaki, yumu amupili mbiya kucha ijala ya mwesi wumu, wingi mbiya kucha ijala ya majuma mavili na wingi kamupa mbiya kucha sha ijala ya lijuma limu, pambeli kayenda mwanja. ");
INSERT INTO ndj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tepu yula yagayiliwili mbiya sha ijala ya mwesi wumu kagolela uchulusi kayegha singi nga sisila, ");
INSERT INTO ndj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","wuwula wula na yula yagayiliwili mbiya sha ijala ya majuma mavili kagolela uchulusi kayegha singi nga sisila. ");
INSERT INTO ndj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini yula yagayiliwili mbiya sha juma limu, kayenda kakumba lyowu kasikulila pasi mbiya sila sha bambu waki. ");
INSERT INTO ndj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Yula bambu payikalili aku lyoo! Pawuyili kakanda kukawula tolitoli ya mbiya sivelili na sivapatili. ");
INSERT INTO ndj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yula ndumindumi yagayiliwili mbiya sha mwesi wumu kayisa na mbiya singi nga sisila sila, kamuwombela, ‘Bambu, wanyimbili mbiya sha ijala ya mwesi wumu, apa siyongisheka singi nga sisila sila.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bambu mundu kamuwombela, ‘Nyanyi, kuva ndumindumi msangi na mwaminifu, kuva mwaminifu kwa findu fidokwa ponopa dandikugoli mwaminifu kwa findu fikomi, wisi sekileli pamu na bambu waku!’ ");
INSERT INTO ndj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ndumindumi yagayiliwili mbiya sha ijala ya majuma mavili na mweni kayisa, kadeta, ‘Bambu, wanyimbili mbiya sha ijala ya majuma mavili, ponopa loli kuna mbiya simonga nga sisilasila simbatili.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bambu mundu kamuwombela, ‘Nyanyi ndumindumi msangi na mwaminifu, kuva mwaminifu wa chindu chidokwa, dandikupi findu fingi fikomi. Wisi sekileli pamu na bambu waku.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pambeli kayisa yula ndumindumi yagayiliwili mbiya sha ijala ya juma limu, kadeta, ‘Bambu nenga manya kucha yuwi kuva mundu yudindalili, yuwi ukubena pala pawungajila kukweta na kukunganya pala pawungajila kuvaghasha. ");
INSERT INTO ndj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ndatilili, ndayifisili mbiya yaku muuganga. Topi toli mbiya yaku.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Bambu mundu kamuwombela, ‘Yuwi kuva ndumindumi mwafu na mgata! Wamanyili kucha nenga ngubena mahali pangajila kukweta na kukunganya pala pangajila kuvaghasha. ");
INSERT INTO ndj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ngiba, ningavikili mbiya shangu kwa vatawula fiyongishekeli yikopesha ningatolili na fwayida yaki! ");
INSERT INTO ndj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Topi, mumupoki mbiya asi mukamupi yula mundu muna mbiya sha ijala ya mwesi wumu. ");
INSERT INTO ndj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nongwa yaveli na chindu dagayiliwi na kuyongishiwa. Lakini yula ngajila chindu, dawupokiwi hata chila chidokwa chavelinachu. ");
INSERT INTO ndj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na ayu ndumindumi yangajila fwayida, mumuyasi panji muchisi! Aku dalili na kugelujula minu.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Chipindi Mwana wa Mundu yavelili ndi Mutwa payisa muukomi waki pamu na makungu vaki vang'alili, topi dayikali pachigoda chaki cha wutwa chi vaveli na ukomi waki, ");
INSERT INTO ndj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","vandu va milima yosi dayiyikunguli pawulongolu yaki na mweni davabawuli vandu kucha mdima yavatapula vafungami na vameni. ");
INSERT INTO ndj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Davavaviki vandu yivagola fyadayila Chapanga wa mlilu na kuvabava vala yivagola ng'odu fyadayila Chapanga mwambu waki wamkiyi. ");
INSERT INTO ndj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pambeli Mutwa davawombeli vala yivaveli mwambu waki wa mlilu, ‘Mwisi yumwi yimunemiliwili na Tati wenu, mupokeli wutwa wuvavatalishili kukandila kulumba kwa mlima. ");
INSERT INTO ndj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nongwa ndavelili na njala yumwi mwanyimbili na ndavelili nyumilwa yumwi mwanyimbili machi vakulanda na ndavelili muhenja yumwi mwanibushilili, ");
INSERT INTO ndj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","na ndaveli ngelengi, mufwalisha na ndavelili mtami yumwi mwayisili kunola na ndavelili muchijaka yumwi mwayisili kundyangila!’ ");
INSERT INTO ndj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Topi, vandu vala yivagolili fya dayila Chapanga davamuyanguli Mutwa, ‘Bambu, ndili twakuwonili kuna njala yufwi twakupili filivi, awu kuyumilwa yufwi twakupili machi va kulanda? ");
INSERT INTO ndj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndili waveli muhenja yufwi twakulibushilili na ndili twakuwonili kuva ngelengi yufwi tukufwalisha? ");
INSERT INTO ndj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na ndili twakuwonili kuva mtami awu kuva muchijaka yufwi twisa kukulola?’ ");
INSERT INTO ndj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mutwa davayanguli, ‘Nakaka nguvawombela, kila chindu chimuvagolili vamu wa ava vana vangu vadokwa, mwagolili nenga.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pambeli Mutwa davawombeli vala yivaveli mwambu waki wa mkiyi, ‘Muwuki pawulongolu ya nenga yumwi mulapiliwili! Muyendi mulifumbika lya jola litandiwiwili na Lijangavandu pamu na vandumindumi vaki. ");
INSERT INTO ndj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nongwa ndaveli nyumilwa yumwi munyimba ha machi va kulanda. ");
INSERT INTO ndj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ndaveli muhenja yumwi munibushila ha, ndaveli mtami na kuwopiwa muchijaka yumwi mwisa ha kunola.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Na veni davayanguli, ‘Bambu, ndili twakuwonili kuva na njala awu kuyumilwa, kuva muhenja awu kuva ngelengi awu kuva mtami na kuwopiwa muchijaka yufwi tukukimbanikila ng'odu?’ ");
INSERT INTO ndj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na mweni davayanguli, ‘Nguvawombela nakaka, kila chindu chimulemili kuvagolela vandu vangajila kujakwa kucha ava, mwalemili kugolela nenga.’ ");
INSERT INTO ndj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Topi, ava davayendi mumotu wa jola wa lifumbika, lakini vala yivagola fyadayila Chapanga davayendi muunofu wa jola.” ");
INSERT INTO ndj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu pamalili kudeta fila fyosi, kavawombela vanachuli vaki, ");
INSERT INTO ndj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mumanya kucha pavapita majuva mavili dakuvi na Lihungu lya pasaka na Mwana wa mundu davakuliwi ili avangiliwi mulupingika” ");
INSERT INTO ndj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chipindechi vatambika vakomi na vavaha na vandu vatangalili vayikunga pamu munyumba ya mtambika mkomi yakemiwa Kayafa. ");
INSERT INTO ndj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Vawombana ndambu ya kumukamula Yesu kwa chifisu ili vamuwulayi. ");
INSERT INTO ndj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Kumbi vawombana veni chilongu achi chikotoo kugoleka chipindi cha pasaka, ili yikotoo kubwituka ndilingu pa vandu.” ");
INSERT INTO ndj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu paghaveyi Betaniya, kayaki Simoni, munautami wa mwiku, ");
INSERT INTO ndj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mawu yumu yavelili na supa ya alabasta yiveli na mafuta va kunungilila vatalamili, amwisilili pala pamesa paghalyeyi filivi, kamuyitilila vala mafuta va kunungilila kumutwi. ");
INSERT INTO ndj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Vanachuli vaki pavawonili afi vakalala, vadeta, “Asala ayi ya liki? ");
INSERT INTO ndj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mafuta ava va kunungilila vangaweshili kuwuliwa kwa mbiya ngomi na vagaju vagayiliwi mbiya asi.” ");
INSERT INTO ndj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu amanyili hoshu shawu, kavawombela, “Mbona mukumuyasha mawu ayu? Mweni kagolela chilongu cha nyanyi. ");
INSERT INTO ndj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vagaju muva pamu majuva vosi, lakini nenga dandivi pamu na yumwi majuva wosi ha. ");
INSERT INTO ndj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ayu mawu kanyitilila mafuta va kunungilila akandalisheyi kwa kusikiwa. ");
INSERT INTO ndj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nguvawombela nakaka, poposi pa mlima awu chilongu achi dachilanduliwi, Chilongu cha Nyanyechi cha golili mawu ayu dachitambuliwi kwa ngumbungumbu ya mweni.” ");
INSERT INTO ndj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pambeli Yudasi Sikaliyoti, yumu wa vala lilongu na vavili, kayenda kwa mtambika mkomi, ");
INSERT INTO ndj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kavawombela, “Damunyimbi chindu liki kucha pandimuhadika Yesu kwa yumwi?” Vamuvalangila migwala milongu mitatu ya mbiya, ");
INSERT INTO ndj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","kukandila chipindi achi Yuda akasakeyi fwasi nofu ya kumshengeta Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lijuva lya kwaa kabula ya Lihungu lya mibumunda yingajila simika, vanachuli vamuyendilili Yesu vamudasha, “Ukudayila tukakutandili koti filivi fya Pasaka?” ");
INSERT INTO ndj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mweni kavayangula, “Muyendi kumbwani kwa mlulumi tunga, mukamuwombeli, Muwula kadeta, ‘Chipindi cha nenga chifika, kwa yuwi kulya pasaka pamu na vanachuli vangu.’ ” ");
INSERT INTO ndj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Vanachuli vagola kucha Yesu vavalayilili, vatanda filivi fya Lihungu. ");
INSERT INTO ndj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Payifikili palumihi Yesu ayikalili pamesa pamu na vanachuli vaki lilongu na vavili. ");
INSERT INTO ndj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","“Nguvawombela nakaka, mundu yumu gati ya yumwi dashyengeti.” ");
INSERT INTO ndj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Vanachuli vang'ong'oteka munu, vakanda kumudasha yumu yumu, “Bambu! Ghani, nenga?” ");
INSERT INTO ndj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kayangula, “Yalikishila ndongi muchimbundi pamu na nenga ndi dashyengeti. ");
INSERT INTO ndj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yina Mwana wa Mundu akuyenda kucha Mayandiku vang'alili wuvadeta, ila, pishu mundu yula damshengeti Mwana wa Mundu! Ingaveli ngiba mundu ayu angawonikili ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pambeli Yudasi yadayileyi amshengeti Yesu, kamdasha, “muwula! Ndiva nenga duu?” Yesu kamuyangula, “Yina, ukudeta yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pavaveghi vakulya, Yesu katola libumunda, kamlumba Chapanga, kalimetula, kavapa vanachuli vaki kunu padeta, “Mtoli mulyi, awu ndi mvili wa nenga.” ");
INSERT INTO ndj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pambeli katola lwindi, kalumba, kavapa kunu padeta, “Mulandi mwavosi. ");
INSERT INTO ndj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kwa nongwa awu ndi mwasi wangu wuumanyisha lilaghanu, mwasi wuumwayika kwanongwa ya vandu vosi ili kuvawushila sambi. ");
INSERT INTO ndj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nguvawombela, danandi kandi ha difwayi ya misabibu mbaka lijuva lingi pananda kandi pamu na yumwi muwutwa wa Tati wangu” ");
INSERT INTO ndj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pasomulili kala msambu, kawuka kayenda muchidunda cha Miseyituni. ");
INSERT INTO ndj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pambeli Yesu kavawombela, “Pamihi panu, yumwi mwavosi damutuvi na kuneka weka yangu, nongwa Mayandiku Vang'alili vakudeta, Chapanga kadeta, ‘dandimtovi mdimi, na vafungami davapwililiki.’ ");
INSERT INTO ndj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kumbi nenga pashukukili kala dandivalonguleli aku Galilaya.” ");
INSERT INTO ndj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petili kamuwombela Yesu, “Hata kucha vosi davavi na lyogha na yuwi na kukuleka, nenga dandikuleki ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kamuwombela, “Nakaka ngukuwombela, pamihi panu njowolu akali hela kuvika, dawunemi myanja mitatu.” ");
INSERT INTO ndj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petili kamuyangula, “Hata leki mani lasima nzovi pamu na yuwi nenga dandikuleki ng'odu.” Na vala vanachuli vamonga vosi vayangula nga wuwula wula. ");
INSERT INTO ndj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pambeli Yesu kayenda pamu na veni kuchitava cha mibiki cha Getisemani, kavawombela, vanachuli vaki, “Mwikali apa, leki nenga nyendi pala pawulongolu ngadadavi.” ");
INSERT INTO ndj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kavatola Petili, Yakobi na Yohani vana va Sebidayu vakanda kuva na ng'ong'u na kugudaguda. ");
INSERT INTO ndj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Topi, kavawombela, “Ndina lung'ong'u lukomi mundima mbaka samba sova. Mwikali apa mugungi pamu na nenga.” ");
INSERT INTO ndj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Topi, kayenda paulongolu padokwa, kawa wuyifuma, kadadava “Tati wangu, kucha payiweshikana, lwindi alu lunewuki ila yikotoo kuva kucha wudayila nenga, ila kucha wudayila yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kavawuyila vala vanachuli kavawona vawonja. Kamuwombela, “Petili nakaka muwesha ha kugunga pamu na nenga hata kwa lisaa limu? ");
INSERT INTO ndj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mugungi na kudadava ili mukotoo kwingila mumayeshu. Mfuki wukudayila lakini mvili wuva msosuvafu.” ");
INSERT INTO ndj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kayenda kandi mwanja wa pili kadadava, “Tati wangu, kucha yikuweshikana ng'odu lwindi alu lumbiti ngajila nenga kulanda, topi, fiwudayila yuwi figoleki.” ");
INSERT INTO ndj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kavawuyila kandi kavawona vawonja, kwanongwa mesu vawu vaveli wuniwuni. ");
INSERT INTO ndj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Topi, kavaleka, kayenda kandi kudadava mwanja wa tatu kwa lisu lililalila. ");
INSERT INTO ndj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pambeli kavawuyila vanachuli vaki, kavawombela, “Mkalihela mukawonja na kupumulila? Mloli! Chipindi cheni chifika, Mwana wa Mundu davamuhadishi mumawoku ya vandu vavelili na sambi ");
INSERT INTO ndj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Muyimuki, tuyendi. Mloli! Akwisa yula danshengeti.” ");
INSERT INTO ndj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Topi, Yesu paghaveyi akali hela akuwombana nawu, kabwituka Yudasi yumu wa vala lilongu na vavili, akwisa pamu na vandu vamonga yivaveli na mipanga na fimbongu. Yivavelili valayishiwa na vatambika vakomi na vavaha va vandu. ");
INSERT INTO ndj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ayu yadayileyi kumushengeta Yesu, aveli kavapa kala chilangushilu padeta kucha, “Mundu yula yindimjambusha kwa kumunoneli ndi mweni, mumuvakuli!” ");
INSERT INTO ndj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Topi Yuda kamselilela Yesu, kamujambusha “Hasi muwula,” Pambeli kamunonela. ");
INSERT INTO ndj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kamuwombela, “Ghanja, goli chiwudayileyi kugola.” Topi vala vandu vayisa kumuvakula Yesu na kumuwopa ");
INSERT INTO ndj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yumu wa vala vanachuli va Yesu kakwemula lipanga lyaki, kamudumula ndumindumi wa mtambika mkomi lijeji. ");
INSERT INTO ndj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu kamuwombela, “Wuyishi lipanga lyaku muhala, kwanongwa mundu yoyonda yayiminya kwa lipanga dasovi kwa lipanga. ");
INSERT INTO ndj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wuli, mumanya ng'odu kucha ningaweshili kumuluva Tati wangu na mweni tepu hela anganyeghilili mipinga ya Makungu nendu ya lilongu na mivili? ");
INSERT INTO ndj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lakini davavi wuliwuli mayandiku vang'alili yivadeta kucha ndi yidayiliwa kuva?” ");
INSERT INTO ndj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chipindi chichilachila Yesu kaliwombela lila lipinga liyisili kumukamula na kumvika pasi yawu. “Wuli, mwisa kungamula kwa mipanga na fimbongu kucha wula nenga ndiva mpoki wa findu fya vandu? Majuva vosi ndaveli Munyumba ya Chapanga pang'ula, mbona mwangamulili ng'odu! ");
INSERT INTO ndj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lakini fyosi afi fikugoleka ili mayandiku va vambuyi va chapanga vagoleki.” Pambeli vanachuli vosi vatuva vamuleka. ");
INSERT INTO ndj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Topi, vandu vala vamuyegha Yesu kayaki Kayafa, mtambika mkomi, kuvayikunganyili vawula va Malawu na vavaha, ");
INSERT INTO ndj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petili amkovikelili Yesu mbaka paluvagha lwa mtambika mkomi, kayingila mbaka mgati pamu na vadimi ili aweshi kulola findu dafigoleki. ");
INSERT INTO ndj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Topi, mtambika mkomi na balasa lyosi vasaka utovileli wa udesi ili vamuwulayi Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lakini vapata utovileli wowosi ha, ngimu wuvayisili vatovilela vatangalili va ufyangu. Pambeli vayisa vatovilela vavili, ");
INSERT INTO ndj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","vadeta, “Mundu ayu adetili: ‘Nguwesha kubowola nyumba ya Chapanga na kuyijenga kandi kwa majuva matatu.’ ” ");
INSERT INTO ndj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mtambika mkomi kawoloka, kamudasha Yesu, “Wuli mbona ukuyangula chindu ng'odu? Vandu ava vakutovilela liki kwa yuwi?” ");
INSERT INTO ndj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini Yesu kanyamala jii. Mtambika mkomi kamuwombela, “Wuyilapi kwa litawa lya Chapanga yaveli mnofu, tuwombeli kucha yuwi kuva nakaka Kilistu Mkombola Mwana wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kavawombela “Ukudeta yuwi! Lakini nguvawombela, kukandila ponopa damumuwoni Mwana wa Mundu kayikala mwambu wa mlilu wa yula Bambu muna liwovi, payisa mumbindi ya mafundi va kumbindi ya Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Topi, mtambika mkomi kasavanga yingwa yaki kadeta, “Kaduka! Tukudayila kandi utovileli? Ponopa mpikana paduka mweni. ");
INSERT INTO ndj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yumwi mukuwona wuliwuli?” Veni vayangula, “Akudayiliwa asovi!” ");
INSERT INTO ndj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pambeli vamutemela mita kuwushu na kumuvangula. ");
INSERT INTO ndj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Vamonga pavamvanguleyi vadeta, “Yuwi Kilistu Mkombola, tungi ghani kakutova!” ");
INSERT INTO ndj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petili aveli kayikala panji kuwuwa, topi, ndumindumi yumu mdadala kamuyendela Petili, kadeta, “Yuwi vaveli pamu na Yesu wa Galilaya.” ");
INSERT INTO ndj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petili kakana pawulongolu ya vosi, kadeta, “Manya ha kucha ukudeta liki.” ");
INSERT INTO ndj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pafumeyi pamulyangu, ndumindumi wingi mdadala kamuwona, kavawombela yivavelili pala, “Mundu ayu aveli pamu na Yesu wa Nasaleti.” ");
INSERT INTO ndj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petili kakana kandi kunu payilapa, “Mundu ayu ndimumanya ha.” ");
INSERT INTO ndj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tepu, vandu vamu yivawolukili pala vamuyendela Petili, vamuwombela, “Nakaka yuwi Mgalilaya, kumanyikila detelu yaku!” ");
INSERT INTO ndj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Topi Petili kakanda kuyilapanga padeta, “Chapanga ang'oni, ndimumanya ng'odu mundu ayu!” Tepu njowolu kavika. ");
INSERT INTO ndj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petili kakumbuka filongu fyamuwombilili Yesu, “Njowolu akalihela kuvika, dawunemi myanja mitatu.” Topi, kafuma panji, kalila munu. ");
INSERT INTO ndj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kukalangali vatambika vakomi na vavaha va vandu yivagolili chitemela kwanongwa ya Yesu ili vamuwulayi. ");
INSERT INTO ndj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Vamuwopa luwoyi, vamutola, vamuyegha kwa Pilatu, mkomi wa Valumi. ");
INSERT INTO ndj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Topi, Yudasi, ndi yamushengitili, pawonili kucha Yesu kahighiwa kala, kapomela, kavawuyishila vatambika na vavaha yila migwala milongu mitatu ya mbiya. ");
INSERT INTO ndj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kamuwombela, “Mifya kwa kumutawula Mundu yangajila nongwa awulayiwi.” Lakini veni vadeta yufwi fya liki afi? “Kamani umweni.” ");
INSERT INTO ndj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mweni kasiyasilila mbiya sila munyumba ya Chapanga kafuma panji, kayenda, kayichapika luwoyi. ");
INSERT INTO ndj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Vatambika vakomi vasitola mbiya sila, vadeta, “Nyanyi ha kusivika nyumba ya Chapanga kwanongwa asi siva mbiya sha mwasi.” ");
INSERT INTO ndj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Topi, vawombana, vakahemileli chitava cha muwumbi yivi mahali pa kusikila vandu vatangalili. ");
INSERT INTO ndj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndi nongwa mbaka nalelu chitava chila chikukemiwa “Chitava cha mwasi.” ");
INSERT INTO ndj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Topi, filongu fya mbuyi wa Chapanga Yelimiya fiva. “Vatolili fipandi milongu mya tatu fya mbiya. Fiyifwanili na yula mundu wa Isilaeli vamuchulusili. ");
INSERT INTO ndj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Na sila vahemilili wuwowu chitava chamuwumbi kucha bambu palayishili.” ");
INSERT INTO ndj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu awolushiwili pawulongolu ya mkomi wa mkowa. Topi, mkomi wa mkowa kamudasha, “Yuwi kuva Mutwa wa Vayawudi?” Yesu kamuyangula, “Ukudeta yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kumbi vatambika vakomi na vavaha pavaveghi vakumuhigha kayangula chindu ha. ");
INSERT INTO ndj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Topi, Pilatu kamudasha, “Wuli ukupikana duu fyosi afi fivakuhigha yuwi?” ");
INSERT INTO ndj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Topi, Yesu kayangula hata chindu chimu ha, hata mkomi wa mkowa ajingili munu. ");
INSERT INTO ndj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yavelili chishovi kila lihungu lya Pasaka mkomi wa mkowa kuvafuwulilila vayawudi mundu yumu yawopiliwili muchijaka. ");
INSERT INTO ndj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chipindi cha pasaka, kwavelili na mundu yumu yawopiliwili muchijaka litawa lyaki Balaba. ");
INSERT INTO ndj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Topi, vandu pavayikungili pamu, Pilatu kavadasha, “Mukudayila ndivafuwulili yoti, gati ya ava vavili, Balaba awu Yesu yivamkema Kilistu?” ");
INSERT INTO ndj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Adetili naha kwanongwa amanyili vamuyeghili Yesu pala kwanongwa ya weyi. ");
INSERT INTO ndj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatu payikalili pachigoda cha highilu, mwehi mundu amuyeghilili lulayilayi, “Kotoo kwitaya munongwa ya mundu ayu msangi, kwanongwa nalelu gobuleka munu mumilotu kwanongwa ya mweni.” ");
INSERT INTO ndj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lakini vatambika vakomi na vala vavaha yivavajangajanga vandu kucha afuwuliwi Balaba na Yesu awulayiwi. ");
INSERT INTO ndj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatu kavadasha, “Yoti kwa ava vavili mukudayila ndimulekisheli?” Veni vamuyangula, “Balaba!” ");
INSERT INTO ndj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatu kavadasha, “Ponopa, ndimugoli liki Yesu yivamkema Kilistu?” Vosi vayangula, “Avangiliwi mulupingika!” ");
INSERT INTO ndj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatu kavadasha kandi, “Kagola chindu liki?” Veni vayendilela kulandusha lishu, “Avangiliwi mulupingika!” ");
INSERT INTO ndj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Topi, Pilatu pamanyili kucha dalemwi kugola chindu chochosi ila ndilingu shakandili hela, atolili machi, kanava mawoku pawulongolu ya lila lipinga lya vandu. Kadeta, “Nenga mumeli ha munjifwa ya mundu ayu, mani mwaveni!” ");
INSERT INTO ndj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Vandu vosi vadeta, “Mwasi waki wutuwoni yufwi pamu na vana vetu!” ");
INSERT INTO ndj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Topi, Pilatu kavagayila Balaba kufuma muchijaka na vavawombela vandu vamulatuli Yesu fiboku na avangiliwi mulupingika. ");
INSERT INTO ndj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pambeli machonda va Pilatu vamuyingisha Yesu munyumba ngomi ya mkomi wa mkowa, vayikungula chipuga chosi, vamshengitela. ");
INSERT INTO ndj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Vamuwopusola yingwa shaki, vamufwalisha lihabiti lya langi ngeli. ");
INSERT INTO ndj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pambeli vapota likokoma lya misomi vamufwalisha kumutwi, vamuvikila lidengi mukuwoku lyaki lya mlilu. Vatundama pawulongolu yaki, vamudanila pavadeta, “Hasi Mutwa wa Vayawudi!” ");
INSERT INTO ndj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Vamutemela mita, valitola lila lidengi vamutovela nalyu kumutwi. ");
INSERT INTO ndj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pavamdanilili kala, vamuwopola lila lihabiti, vamufwalisha yingwa shaki, pambeli vamuyegha kumuvangilila mulupingika. ");
INSERT INTO ndj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pavaveghi vakuyenda, vamuwona mundu yumu litawa lyaki Simoni mwenikaya wa Kileni, vamung'ang'anika kuwupapa lupingika lwa Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pavafikili mahali pakukemiwa Goligota, manayaki, mahali pa lipava lya mutwi, ");
INSERT INTO ndj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","vamupa mhashu wa difwayi na chindu chijejemu. Lakini Yesu payeshili kalema kulanda. ");
INSERT INTO ndj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Vamuvangilila mulupingika, pambeli vavaghana yingwa shaki kwa kugola do. ");
INSERT INTO ndj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pambeli vayikala pasi vakumlembilela. ");
INSERT INTO ndj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kumbindi ya mutwi waki vavika tangashu ili vandu vamanyi nongwa yivamuhighililili mulupingika, “Ayu ndi Yesu mutwa wa Vayawudi.” ");
INSERT INTO ndj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Vapoki vavili vavangiliwili mulupingika wuwowu pamu na Yesu, yumu mwambu wa mlilu na wingi mwambu wa mkiyi. ");
INSERT INTO ndj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Vandu yivapiteyi pala vamujowulili kunu pava tikanya mitwi yawu kunu pavadeta, ");
INSERT INTO ndj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yuwi wayijumili ng'odu kuyibowola nyumba ya Chapanga na kuyijenga kwa majuva matatu? Ponopa wuyilowoli umweni! Kucha yuwi kuva Mwana wa Chapanga, topi, wuyiwushi mulupingika!” ");
INSERT INTO ndj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ngimu wuwowu vatambika vakomi pamu na vawula va Malawu na vavaha vamudanilili pavadeta, ");
INSERT INTO ndj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Wavalowulili vamonga, lakini kulemwa kuyilowola umweni! Kucha mweni mutwa wa Isilaeli! Topi, ponopa asunuki mulupingika na yufwi datumjumili. ");
INSERT INTO ndj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Amwidumbili Chapanga na kudeta, kucha mweni mwana wa Chapanga, topi Chapanga amulowoli kucha akumudayila.” ");
INSERT INTO ndj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ngimu wuwowu na vala vavangiliwili pamu na Yesu vamujowulili. ");
INSERT INTO ndj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kukandila saa sita pamusi mbaka saa tisa chisi chagubikili mlima wosi. ");
INSERT INTO ndj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Payifikili saa tisa naha Yesu kalila kwa lishu likomi, “Eli, Eli lama sabakitani?” Mana yaki, “Chapanga wangu, Chapanga wangu, mbona kuneka?” ");
INSERT INTO ndj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lakini vala vawolukili pala pavapikanishili naha vacha, “Akumkema Eliya” ");
INSERT INTO ndj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yumu wa vala katuva katola lindelindeli kajabika musiki, kayivika muludengi kamupa afyombi. ");
INSERT INTO ndj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Vamonga vadeta, “Leki tuloli kucha Eliya dayisi kumulowola.” ");
INSERT INTO ndj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Topi Yesu kalila kandi kwa lishu likomi, kasova. ");
INSERT INTO ndj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Topi, lupayi lwa mugati lukikisha nyumba ya Chapanga na chumba gati ya nyumba ya Chapanga lidemuka filepa fivili, kufumila kumbindi mbaka pasi, mlima utikanyika, migonguveli yibaluka, ");
INSERT INTO ndj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","sembi sifuwuka na vandu vang'alili vafwili vashukushiwa. ");
INSERT INTO ndj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Na veni pavashukukili kala vafuma musembi, vayingila Yelusalemu mbwani ying'alili, vawoneka na vandu vatangalili. ");
INSERT INTO ndj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Topi, mkomi wa vala machonda na machonda vaki yivamulembileleyi Yesu pavawonili chiyighayigha cha mlima na fila findu fibwitukili vatila munu, vadeta, “Nakaka Mundu ayu Mwana wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pala vavelili wuwowu vadadala vatangalili vakulola kwa kutali. Ava ndi vadala vamukovikelili Yesu kufuma Galilaya pavamkimbanikila. ");
INSERT INTO ndj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pagati yawu aveli wuwowu Maliya Magadalena na Maliya mawawu Yakobi na Yosefu pamu na mawawu vana va Sebidayu. ");
INSERT INTO ndj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Payiveyi palumihi, kayisa mundu yumu mlundamali mwenikaya wa Alimataya, litawa lyaki Yosefu, mweni wuwowu aveli mwana chuli wa Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kamuyendela Pilatu, kaluva agayiliwi chikongu cha Yesu. Topi, Pilatu kalamula agayiliwi. ");
INSERT INTO ndj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosefu katola chila chikongu, kachishengiteshela ligubiku lya nyanyi ");
INSERT INTO ndj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kachivika mgati ya sembi yaki ya shonu yisonguliwili muligangachuma, pambeli kalibilibisha ligangachuma likomi paulongolu ya sembi, mweni kawuka. ");
INSERT INTO ndj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya Magadalena na yula Maliya wingi vayikalili pasi wushu valola kula kusembi. ");
INSERT INTO ndj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chilawu yaki ndi lijuva lya mwanja wamumbeli yila ya kuyitalisha, vatambika vakomi na Mafwalisayu, vamuyendilili Pilatu, ");
INSERT INTO ndj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","vadeta, “Bambu, tukumbuka kucha yula mdesi adetili paghaveyi akali hela kusova, ‘Kucha pavapita majuva matatu dashukuki.’ ");
INSERT INTO ndj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwa nongwa ayi wuvawombeli vamachonda vadima sembi ya mundu ayu mbaka majuva matatu, ili vanachuli vaki vakotoo kumuhija na kuvawombela vandu kucha kashukuka. Ufyangu wa mwishu dawuvi wa wafu munu pitu wula wa mwanja mtasi.” ");
INSERT INTO ndj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu kavawombela, “Topi muvanawu vamachonda, muyendi mukalidimi kucha wumuwesha yumwi.” ");
INSERT INTO ndj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Topi, vayenda, vayidimi sembi, vamatikila na kushayisha lila ligangachuma na kuvaleka vamachonda vadimi. ");
INSERT INTO ndj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Palipelili lijuva lya kupumulila na kukaveli samba kulangala ya lijuva lila lya Jumapili, Maliya Magadalena na yula Maliya wingi vayendili kuyilola yila sembi. ");
INSERT INTO ndj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tepu liwoneka liyighayigha likomi mumlima Makungu wa Bambu kasunuka kufuma kumbindi kwa Chapanga kalibilibisha lila ligangachuma, kalikalila. ");
INSERT INTO ndj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ang'alili kucha lumuli na yingwa shaki shaveli mbuleteee. ");
INSERT INTO ndj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Vamachonda vala yivadimagha sembi vabagamili, livayingila lyogha likomi, vashulula. ");
INSERT INTO ndj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lakini yula Makungu kavawombela vala vadadala, “Yumwi mukotoo kutila! Manya kucha mukumsaka Yesu yavangiliwili mulupingika. ");
INSERT INTO ndj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kwahela mundu apa nongwa kashukuka kucha wadetili. Mwisi mukaloli pala pavachiwonjishili chikongu. ");
INSERT INTO ndj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Topi, muyendi kalopu mukavawombeli vanachuli vaki kucha kashukuka kufuma muvasovili na ponopa akuvalongulela kula Galilaya, aku damumuwoni. Muvi na ngumbungumbu na afi finiwawombilili.” ");
INSERT INTO ndj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Topi vala vadadala vawuka kalopu pala pasembi, vatuva vayenda kuvawombela vanachuli vaki. ");
INSERT INTO ndj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tepu, Yesu katang'ana nawu, kadeta, “Hawije!” Vadadala vala vamuyendela, vatundama pawulongolu yaki, vakola mawulu nakumujuma. ");
INSERT INTO ndj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pambeli Yesu kavawombela, “Mkotoo kutila! Muyendi mukavawombeli valongu vangu vayendi Galilaya davang'oni aku.” ");
INSERT INTO ndj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Vala vadadala pavaveghi vakuyenda vadima vamu va sembi yila vayendili kumbwani kuvalandulila vatambika vakomi filongu fyosi fibwitukili. ");
INSERT INTO ndj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Topi, vatangana na vavaha pavawombilili kala, vavapa mbiya sitangalili vala vamachonda ");
INSERT INTO ndj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","vadeta, “Yumwi mukadeti naha, vanachuli vaki vahija chikongu chaki yufwi tukaveli tuwonja. ");
INSERT INTO ndj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na kucha mkomi wa mkowa pamanya chilongu achi, yufwi datuwombani na mweni na yumwi damupati msayisayi ha!” ");
INSERT INTO ndj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Vala vadima vasitola sila mbiya, vagola kucha pavawuliwili. Chilongu achi chikwila kwa Vayawudi mbaka nalelu. ");
INSERT INTO ndj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Vala vanachuli lilongu na yumu vayendili Galilaya kuchidunda chila chavalaghili Yesu. ");
INSERT INTO ndj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pavamuwonili vajuma, hata leki vamonga vavelili na hoshu, ");
INSERT INTO ndj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu kaselela pabehi, kavawombela, “Gayiliwa ukomi wosi wa kumbindi kwa Chapanga na mumlima awu. ");
INSERT INTO ndj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Topi, muyendi, mukavagoli vandu va milima na makabila vosi vavi vanachuli vangu, pamuvabatisha kwa litawa lya Tati na lya Mwana na lya Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Muvawuli kukamula Malawu vosi yindivagayilili. Na nenga ndiva pamu na yuwi majuva vosi, mbaka mwishu wa mlima.”");
INSERT INTO ndj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Achi ndi Chilongu cha Nyanyi cha Yesu Kilistu, Mwana wa Chapanga. Mayandiku vamu va dahili vavahela Mwana wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chakandili kucha wayandikili Isaya yaveli mbuyi wa Chapanga: “Chapanga adetili, ‘Dandimlayishi makungu wangu akuwombeli, dayakutandili deha yaku.’ ");
INSERT INTO ndj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mundu yumu akukema kucheja, ‘Mugoli deha ya Bambu, muhololi deha yaki!’ ” ");
INSERT INTO ndj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Topi Yohani mbatisha afumbukili kucheja, alandulili kucha vandu vapomeli sambi na kuvabatisha, kavawombela vandu, “Ili Chapanga avapomeli sambi shawu.” ");
INSERT INTO ndj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vandu vatangalili kufuma mlima wa Yudeya na mbwani ya Yelusalemu vayenda kumpikanisha Yohani. Vasipomela sambi shawu, mweni kavabatisha mulweni Yoludani. ");
INSERT INTO ndj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohani mbatisha afwalili yingwa yavagolilili kwa mingoma ya ngamiya na lufunga lwa ngwembi muchiwunu chaki na alili ngumbingumbi na njuki ya mudasi. ");
INSERT INTO ndj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kavawombela vandu, “Akwisa mundu yaveli na liwovi kupita nenga. Nenga ngujakwa ha hata kugondama kuwopola ng'oyi sha mikobasi yaki. ");
INSERT INTO ndj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nenga nguvabatisha kwa machi, ila mweni daavabatishi kwa Mfuki Mng'alili.” ");
INSERT INTO ndj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Majuva vala, Yesu afumili Nasaleti, kumlima wa Galilaya, kabatishiwa na Yohani mbatisha mulweni Yoludani. ");
INSERT INTO ndj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tepu pabwitukili mumachi, kawona kumbindi kwa Chapanga kufuwuka na Mfuki Mng'alili kamsunukila kucha njiva. ");
INSERT INTO ndj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na lishu lipikanika kufuma kumbindi, lideta “Yuwi mwana wangu yingutamili, mayiliwa na yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tepu Mfuki Mng'alili kamugola ayendi kucheja, ");
INSERT INTO ndj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","aku ayikalili kwa majuva milongu mchechi payeshiwa na Lijangavandu. Vang'ongolu va mudasi vaveli pala, lakini vamakungu vayisa vamkimbanikila. ");
INSERT INTO ndj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohani mbatisha pavamtatilili kala muchijaka, Yesu ayendili mlima wa Galilaya kuvalandulila vandu Chilongu cha Nyanyi cha Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Padeta, “Chipindi chifika, Wutwa wa kumbindi kwa Chapanga wuva pabehi! Mupomeli na muchijumili Chilongu cha Nyanyi!” ");
INSERT INTO ndj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu patyangeyi muluwongu ya lihiva lya Galilaya, kavawona Simoni pamu na Andeleya mlongu mundu, pavafuva vasomba kwa lwafu. ");
INSERT INTO ndj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu kavawombela, “Mungovikeli na nenga dandivagoli kuva vafuva vandu.” ");
INSERT INTO ndj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tepu vasileka njafu shawu, vamkovekela. ");
INSERT INTO ndj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Paayendili pawulongolu padokwa, kavawona Yakobi na Yohani vana va Sebidayu, vayikala muwatu pavasambula njafu shawu. ");
INSERT INTO ndj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bahala pala, Yesu kavakema. Veni vamleka tati wawu Sebidayu na vala vagolafichuku va mula muwatu, vamkovekela Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na vanachuli vaki vayendili mumbwani ya Kapelinaumu. Palifikili Lijuva lya Kupumulila, Yesu kayingila Munyumba ya kudadavila kakanda kuwula. ");
INSERT INTO ndj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vandu vala vapikanishili ng'ulilu yaki vayikang'anika nendu, nongwa kavawula ha kucha vawula vawu va Malawu va Chapanga vamupili Musa, ila yaveli na uwesu. ");
INSERT INTO ndj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bahala pala mundu yavelili na mfuki mwafu kayingila Munyumba ya kudadavila, kawuta kwa lishu likomi, ");
INSERT INTO ndj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ukudayila kutugola liki, Yesu wa Nasaleti? Kwisa kutuyaghamisha? Ngumanya, Yuwi Mng'alili wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu kamulakalila chinyamkela, “Matu! Kopoki kwa mundu ayu!” ");
INSERT INTO ndj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chinyamkela kamtaya chipwembu mundu yula, kawuta kwa lishu likomi, kakopoka kwa mundu yula. ");
INSERT INTO ndj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vandu vosi vayikanganika nendu, vakandili kwidasha, “Achi chindu liki? Ayi ng'ulilu ya shonu na uwesu? Mundu ayu akuwesha kuvalakalila finyamkela na veni vakumpikana!” ");
INSERT INTO ndj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Filongu fya Yesu filopokesha kukwila kosi kumlima wa Galilaya. ");
INSERT INTO ndj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tepu pavafumili Munyumba ya kudadavila, Yesu pamu na Yakobi na Yohani vanachuli vaki vayenda kaya ya Simoni na Andeleya. ");
INSERT INTO ndj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nafyala wa Simoni avelili kawonja pawulili akutamika. Yesu pafikili, bahala pala vamuwombela chilongu cha mawu ayu. ");
INSERT INTO ndj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Topi Yesu kaselela kwa mawu yula mtami, kamkola liwoku kunu pamtandamusha. Utami umfuma mawu yula na mweni kakanda kuvakimbanikila. ");
INSERT INTO ndj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lumihi palufikili na lijuva palidibili, vandu vamuyeghela Yesu vatami vosi na vandu yivavelili na finyamkela. ");
INSERT INTO ndj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vandu vosi va mbwani vayikungula paluvagha, ");
INSERT INTO ndj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kavalowola vandu vatangalili yivavelili vakutamika matami va kila ndambu, kandi kafumisha finyamkela vatangalili. Kavagayila ng'odu finyamkela fwasi ya kuywanga, kwanongwa vamumanyili mweni ghani. ");
INSERT INTO ndj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chilawu yaki linyavagogolu, Yesu kayimuka, kawuka kaya kayenda pangajila vandu. Aku Yesu kamdadavila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na vayaki vayenda kumsaka. ");
INSERT INTO ndj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pavamuwonili vamuwombela, “Kila mundu akakusakeyi yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu kavayangula, “Tuyendi fijiji fimonga fiveli pabehi, ngavalandulili vandu wuwula. Topi nyisa niyilata chichuku achi.” ");
INSERT INTO ndj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naha katyanga mumlima wosi wa Galilaya, palandula Munyumba sha kudadavila na kuwusha finyamkela. ");
INSERT INTO ndj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mundu yavelili na ukalava amuyendilili Yesu kamtundamila na kamluva, kadeta, “Pawudayila, ukuwesha kung'ofuwa!” ");
INSERT INTO ndj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu amuwonilili lusungu, kaholosha liwoku lyaki, kamkamula. Pambeli kamuwombela, “Ngudayila ngutangi ung'ali!” ");
INSERT INTO ndj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bahala pala ukalava umfuma mundu yula, kang'ala. ");
INSERT INTO ndj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pambeli Yesu kamuwombela ayendi, kamkayika, ");
INSERT INTO ndj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","kamuwombela, “Pikanishi, ukotoo kumuwombela mundu yoyosi chilongu achi ila yendi ukayilangushi kwa mtambika. Pambeli uyeghi litambiku kwa Chapanga kucha alayilili mbuyi wa Chapanga Musa, vandu valoli utovileli kwa veni.” ");
INSERT INTO ndj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lakini mundu yula kawuka kakanda kukwisha chilongu chila kosi, mbaka Yesu kalemwa kuyingila kumbwani kunu pawoneka. Ila kayikala panji, pangajila vandu. Lakini hata aku, vandu vamyendela kufuma mbembu shosi. ");
INSERT INTO ndj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pavapitili majuva vamu, Yesu kawuya Kapelinaumu na vandu vapikanila kava pakaya. ");
INSERT INTO ndj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Vandu vatangalili vayikungasha hata fwasi yiva kwahela, vamema paluvagha losi. Yesu avelili akuvalandulila chilongu. ");
INSERT INTO ndj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Vandu vamu, mchechi vamuyeghili mundu yumu yapombalili, vamuyeghela Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwanongwa vandu vaveli vatangala, valemwili kumuyegha mundu yula pala paveli Yesu. Topi vatobulili kulituvili, mwaveli Yesu. Pavatobulili kala lilanga, vamsunusha mundu yula yaveli kawonja muwulili. ");
INSERT INTO ndj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu pamuwonili ndambu ya ujumilwa wawu, kamuwombela mundu yula yapombalili, “Mwana wangu, ngupomela sambi shaku.” ");
INSERT INTO ndj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Vawuli vamonga va Malawu yivaveli vayikala pala vakaiholeyi ndima shawu. ");
INSERT INTO ndj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Akwidumba liki pawombeyi nawula? Akumjowola Chapanga! Kwa hela mundu yapomela sambi, ila Chapanga weka yaki.” ");
INSERT INTO ndj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bahala pala Yesu amanyili kala Chivayihola, avawombilili, “Wuli mbona mukwihola ndambu ayi mundima shenu?. ");
INSERT INTO ndj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Choti chiveli chipusuka, kumuwombela mundu ayu yapombalili, ‘Kupomiliwa sambi shaku’, Awu kumuwombela, ‘Utoli ulili waku, witwiki yendi’?. ");
INSERT INTO ndj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ponopa ngudayila mumanyi, Mwana wa Mundu kana uwesu wa kuvapomela vandu sambi shawu pamulima.” Pala pamuwombilili mundu yula yapombalili, ");
INSERT INTO ndj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngukuwombela tandamuki, toli ulili waku na yendi kaya yaku!” ");
INSERT INTO ndj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pala vandu vosi vaveli vakumlola, mundu yula kawoloka, katola ulili waki, kayenda. Vandu vosi vayikanganika, vamjuma Chapanga pavadeta, “Tukali hela kuchiwona chindu kucha achi!” ");
INSERT INTO ndj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu kayenda kandi muluwongu lwa lihiva. Lipinga lya vandu limkovekela, mweni kakanda kuvawula. ");
INSERT INTO ndj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Papiteyi kamuwona Lawi mwana wa Alufayu kayikala muofisi ya vasumula mbiya ushulu. Yesu kamuwombela, “Ungovikeli.” Lawi katandamuka kamkovekela. ");
INSERT INTO ndj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pambeli Yesu aveli kayikala munyumba ya lawi akulya filivi. Vasumula mbiya vatangalili na vala yivavakema yivaveli na sambi vamkovikela, vayikala pamu na Yesu pamesa na vandundami vaki vakulya. ");
INSERT INTO ndj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Vawuli vamonga va Malawu va Chapanga yivamupili Musa vaveli mulipinga vakulikema Vafwalisayu vamuwona Yesu paghalya pamu na vandu yivavakema yivaveli na sambi na vasumula mbiya. Vavadasha vanachuli vaki, “Wuli akulya pamu na vasumula mbiya sha ushulu na yivaveli na sambi?” ");
INSERT INTO ndj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu kavapikanisha kavawombela, “Vandu yivaveli na njimba nofu vakudayila ha mwilwana, yivadayila mwilwana vala yivaveli vatami. Nenga nyisa kuvakema vandu yivayihola veni goleki ha, ila yivaveli na sambi.” ");
INSERT INTO ndj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Chipindi chimu vanachuli va Yohani mbatisha na vanachuli va Vafwalisayu vaveli vakwikaja kulya. Vandu vamonga vayisa kumdasha Yesu. “Wuli vanachuli va Yohani na va Vafwalisayu vakwikaja kulya lakini vanachuli vaku vakwikaja ha kulya?” ");
INSERT INTO ndj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kavayangula, “Wuli vavalalikili kulihungu lya kuheta mkuvadayila vayikaji kulya chipindi vava pamu na Bambu wa lihungu lya kuheta vaweshi ng'odu kuyikaja kulya. ");
INSERT INTO ndj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lakini chipindi dachiyisi Bambu wa lihungu lya kuheta davamuwushi pala pavayikaleyi pamu, chipindi achi davayikaji kulya. ");
INSERT INTO ndj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Vandu vakudumula ha chipapi cha shonu na kusonela muyingwa ngulungulu. Mani pavagola naha, achi chipapi dachinyopoli yingwa ngulungulu, yeni dayidemuki nendu. ");
INSERT INTO ndj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Vandu vakutayaya ha difwayi ya shonu mumihaku ya ngwembi yadahili. Pavagola naha, difwayi daubaluli ayi mihaku ya ngwembi, difwayi na mihaku dayidanganyiki. Difwayi ya shonu vakutaya mumihaku ya ngwembi ya shonu.” ");
INSERT INTO ndj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lijuva lya Kupumulila, Yesu aveli papita mufitava fya mupunga. Paghaveyi akupita, vanachuli vaki vakanda kudumula misasa ya fivelekwa. ");
INSERT INTO ndj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Vafwalisayu vamuwombela, “Loli! Wuli vakugola chindu chikaniwili Lijuva lya Kupumulila?” ");
INSERT INTO ndj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu kavayangula, “Mukali hela kusoma fyagolili Dawudi pamu na vamonga chipindi pavaveghi na njala? ");
INSERT INTO ndj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mumajuva va mtambika mkomi Abyatali, Dawudi ayingilili munyumba ya Chapanga na kulya mibumunda yivikiliwi kwa Chapanga. Chindu achi chigoleka chipindi cha Abyatali aveli mtambika mkomi wa Chapanga. Nayiva vatambika weka yau yivaveli vajumiliwa kulya mibumunda yila. Lakini Dawudi kalya na kavagayila na vayaki.” ");
INSERT INTO ndj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pambeli Yesu kavawombela, “Lijuva lya Kupumulila livikiwa kuvatanga vandu. ila vandu kwanongwa ya Lijuva lya Kupumulila ha! ");
INSERT INTO ndj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nenga mwana wa Mundu ndiva Bambu hata kwa Lijuva lya Kupumulila.” ");
INSERT INTO ndj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pambeli Yesu kayenda kandi Munyumba ya kudadavila. Amu kwavelili na mundu yavelili na liwoku lipombalili. ");
INSERT INTO ndj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Vandu vamu vavelili mula vaveli vakumsakila nongwa ya kumhigha. Ponopa vamlolela kucha angamlowulili Lijuva lya kupumulila. ");
INSERT INTO ndj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu kamuwombela mundu ayu yapombalili liwoku, “Wisi apa.” ");
INSERT INTO ndj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pambeli kavadasha, “Wuli malawu vetu vakutujumisha kugola liki mulijuva lya kupumulila? Kugola findu fya nyanyi awu fya wafu, kumlowola mundu akotoo kusova awu kumuwulagha?” Lakini veni vayangulili chindu ha. ");
INSERT INTO ndj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Apa kavalola vosi kwa maya, kunu kavawonela lusungu ndambu ndima shawu sikamalili, Pambeli kamuwombela mundu yula, “Holoshi liwoku lyaku!” Mweni kaholosha liwoku lyaki, bahala pala liwoku lyaki liva kandi linofu. ");
INSERT INTO ndj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tepu Vafwalisayu vafumili panji ya Nyumba ya kudadavila, vakawombaneyi pamu na lipinga lidokwa lya vandu va Helodi, vakasakeyi ndambu ya kumuwulagha Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu kawuka pala pamu na vanachuli vaki, ayendili muluwongu ya lihiva lya Galilaya, lipinga lya vandu lyamkovikelili. Vandu vala vafumili milima ya Yelusalemu na Yudeya, ");
INSERT INTO ndj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","pamu na Yelusalemu na Idume na kumwambu ya lweni Yoludani, mbwani ya Tilu na Sidoni. Vandu ava vatangalili vamyendela Yesu, kwanongwa vapikanishili findu fitangalili fyagolili. ");
INSERT INTO ndj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lipinga lya vandu lyaveli likomi mbaka Yesu avawombilili vanachuli vaki vamvikili watu wumu, ili lipinga lya vandu likotoo kumfwasha. ");
INSERT INTO ndj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aveli kavalowola vandu vatangalili na vosi vaveli vatami vakalevanileyi vamugufyi Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Vandu vavelili na finyamkela pavamuwonili, vawili pawulongolu yaki, pavawuta, “Yuwi kuva Mwana wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lakini Yesu, kavakanila vakotoo kuvawombela vandu mweni ghani. ");
INSERT INTO ndj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu kakwela kuchidunda kavakema vala avadayilili mweni, topi vamyendela, ");
INSERT INTO ndj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","mweni kavashawula vandu lilongu na vavili avakemili vandundami. Kavawombela, “Ndivashawula yumwi kuva na nenga, dandivalayishi kuyenda kuvalandulila vandu, ");
INSERT INTO ndj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","damuvi na uwesu wa kuwusha finyamkela.” ");
INSERT INTO ndj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ava lilongu na vavili yavashawulili vaveli Simoni, Yesu amkemili Petili, ");
INSERT INTO ndj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobi na Yohani vana va Sebidayu Yesu avakemili Bowaneligi, mana yaki “Vandu va kuwumba”, ");
INSERT INTO ndj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andeleya na Filipu na Batulumeyu na Mateyi na Tomasi na Yakobi mwana va Alufayu na Tadeyu na Simoni yayitashila mlima. ");
INSERT INTO ndj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yudasi Sikaliyoti, yula yamushengitili Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pambeli Yesu kayenda kaya. Vandu vatangalili vatangana kandi mbaka Yesu na vanachuli vaki vawesha ha kulya filivi. ");
INSERT INTO ndj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Valongu vaki pavapikanishili naha, vayenda kumtola, kwanongwa vandu vakacheyi, “Yesu kajumba lisini.” ");
INSERT INTO ndj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vawula va Malawu vafumili Yelusalemu vadeta, “Ayu aveli na Besibuli! Ndi mkomi wa finyamkela yamgayila uwesu wa kuvafumisha finyamkela.” ");
INSERT INTO ndj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu kavakema na kuvawombela kwa filangushilu, “Yikuweshikana wuliwuli Lijangavandu amfumishi Lijangavandu mumonga? ");
INSERT INTO ndj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kucha wutwa pawitapula weni kuva fipinga na kwitova, wutwa awu dawuwi. ");
INSERT INTO ndj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na leki kaya payitapula fipinga fipinga, kaya asi dasiwi. ");
INSERT INTO ndj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kucha naha, wutwa wa Lijangavandu weni pawitapula, dawuwi na kufika mwishu. ");
INSERT INTO ndj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kwahela mundu yawesha kwingila munyumba ya mundu muna liwovi na kufitola findu fya mundu ayu, ngajila kuwopiwa tanila mundu ayu. ");
INSERT INTO ndj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nguvawombela nakaka, vandu davawushiwi sambi shawu shosi na majowolu vawu vosi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Lakini mundu yoyosi yamjowola Mfuki Mng'alili, ayu dapomiliwi ha, kwanongwa kagola sambi ya jola.” ");
INSERT INTO ndj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu adetili nahawu kwanongwa vandu vadetili, “Yesu kana finyamkela.” ");
INSERT INTO ndj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pambeli mau na valongumundu Yesu vayisa. Vawoloka panji, vamlayisha mundu ayingili munyumba akamkemi. ");
INSERT INTO ndj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lipinga likomi lya vandu lyaveli limshengetela pavampikanisha Yesu. Veni vamuwombela, “Mau waku na valongu vaku vava panji vakukusaka yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu kavayangula, “Mau wangu na valongu vangu vaghani?” ");
INSERT INTO ndj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pambeli kavalola vandu vamshengitilili na kadeta, “Mloli! Ava ndi mau wangu na valongu vangu! ");
INSERT INTO ndj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mundu yoyosi yagola ndambu yadayila Chapanga, ayu ndi mau wangu, mlongu wangu na mhaja wangu.” ");
INSERT INTO ndj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu kakanda kandi kuwula muluwongu ya lihiva lya Galilaya. Lipinga likomi lya vandu limshengitilili lyaveli likomi, mbaka kayipaka muwatu na kuyikala amu na vandu vosi vaikala muluwongu lwa lihiva. ");
INSERT INTO ndj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kavawula filongu fitangalili kwa filangushilu avawombilili, ");
INSERT INTO ndj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mpikanishi! Mundu yakweta ayendili kukweta mbeyu. ");
INSERT INTO ndj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Paghaveyi akukweta mbeyu, simonga shaponikili mudeha, vambongu vayisa valya. ");
INSERT INTO ndj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Simonga shaponikili muuganga wuveli na migonguveli gonguveli. Mbeyu asi simela kalopu nongwa miganga midokwa. ");
INSERT INTO ndj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lakini palifumili lijuva, liyumisha muhali kwanongwa mikigha yaki iyenda ha pasi. ");
INSERT INTO ndj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Simonga shaponikili mumisomi, misomi yikula, yikekeneka muhali, kwanongwa ayi silela ha. ");
INSERT INTO ndj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lakini simonga shaponikili muwuganga wa nyanyi. Simela, sikula na kulela fivelekwa, simonga shiyongesheka selu ndatu, simonga selu sita na simonga selu mya!” ");
INSERT INTO ndj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pamalilili Yesu kavawombela, “Mundu yeveli na majeji va kupikanishila, apikani!” ");
INSERT INTO ndj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu paghaveyi weka hela, vandu vamu vaveli vakumpikanisha pamu na vanachuli vaki lilongu na vavili vamdasha avahimulili filangushilu afi. ");
INSERT INTO ndj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu kavawombela, “Yumwi mgayiliwa mbwepu sha Wutwa wa kumbindi kwa Chapanga, lakini vamonga, vakuwombiwa kila chindu kwa chilangushilu, ");
INSERT INTO ndj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ili, ‘Pavalola valoli, lakini vakotoo kuwona, pavapikana vapikani, lakini vakotoo kumanya, Kwa nongwa kucha pavamanya, vakuwesha kumuwuyila Chapanga, na mweni akuwesha kuvapomela sambi shawu.’ ” ");
INSERT INTO ndj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pambeli Yesu kavadasha, “Mumanya ng'odu mana ya chilangushilu achi? Ponopa damumanyi wuliwuli filangushilu fimonga? ");
INSERT INTO ndj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mbeyu yikwetiwili ndi chilongu cha Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vandu vamonga yavafumbukili kucha mbeyu siponikilili mudeha. Pavapikanisha chilongu cha Chapanga, bahala pala Lijangavandu akwisa akuchitola chilongu mundima shawu. ");
INSERT INTO ndj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Vandu vamonga vafumbukili kucha mbeyu siponikilili muuganga wuveli na migonguveli gonguveli. Pavapikana chilongu bahala pala vakuchiyanga kunu pavachinemelela. ");
INSERT INTO ndj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lakini chilongu achi chikuyingila ha mugati topi vayendelela padokwa. Msayisayi na sida pasiyisa kwanongwa ya chilongu, bahala pala vakuleka kujumila. ");
INSERT INTO ndj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Vandu vamonga vakwifwana na mbeyu siponikilili pa mibiki ya misomi. Ava ndi vandu vapikana chilongu, ");
INSERT INTO ndj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ila chipwembwi cha ngalilu ayi, kudayila unayiza na kudayila findu fya ndambu shosi, fikuvayingila na kuchikekeneka chilongu na vandu ava vakulela ha vivelekwa. ");
INSERT INTO ndj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lakini vandu vamonga vakwifwana na mbeyu siponikilili muwuganga wa nyanyi. Ava vakuchipikana chilongu, vakuchijumila na kulela fivelekwa, vamonga myanja mitatu, vamonga myanja sita na vamonga myanja mya.” ");
INSERT INTO ndj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu kayendelela kuvawombela, “Kuna mundu yagubika luliku kwa chiyungu? Awu akuluvika pachindangawala? ");
INSERT INTO ndj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kila chindu chifisiwili dachivi lipala na chochosi chigubikiwili dachigubutuliwi. ");
INSERT INTO ndj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mundu muna majeji va kupikanishila, apikani!” ");
INSERT INTO ndj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu kavawombela kandi, “Mloli unofu fila fimpikana! Chigelu chichila chimuvapimila vayenu, Chapanga na mweni davapimili chigelu chichila yumwi, kandi na kuvayongishela. ");
INSERT INTO ndj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mundu yaveli na chindu dayongishewi na mundu yangajila chindu, hata chidokwa chaveli nachu, dapokiwi.” ");
INSERT INTO ndj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kayendilela kudeta, “Wutwa wa kumbindi kwa Chapanga ukwifwana ndambu ayi. Mundu mumonga akukweta mbeyu kufitava. ");
INSERT INTO ndj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pamihi akuwonja ng'onju, pamusi kava mesu, chipindi achi mbeyu sila sikumela na kukula. Mweni kamanya ng'odu ndambu pasimela na kukula. ");
INSERT INTO ndj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Uganga weni ukuwugola muhali ukuli na kulela, likutala kutomola mihamba, kandi ndulu, pambeli ukuyela. ");
INSERT INTO ndj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mbeyu, fivelekwa pafikomala, bahala pala mundu ayu akukanda kubena, kwanongwa chipindi cha mbena chifika.” ");
INSERT INTO ndj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu kadasha kandi, “Wutwa wa kumbindi kwa Chapanga ukuyifwana na chindu liki? Tutoli chilangushilu liki kuwuhimulila? ");
INSERT INTO ndj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ukuyifwana na mbeyu dokwa, mbeyu dokwa nendu pitu shosi sikwetiwa mufitava. ");
INSERT INTO ndj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lakini pasikwetiwa, sikukula na kuva libiki likomi pitu mibiki yosi ya mufitava. Kandi likuva na mitafyi mikomi mbaka vambongu vakuwesha kugola fiyumba fyawu mumitafyi ayi.” ");
INSERT INTO ndj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu kavalandulila vandu chilongu chaki kwa filangushilu fingi fitangalili fya ndambu ayi. Kaywanga nawu ndambu pavaweshili kufimanya. ");
INSERT INTO ndj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kaywanga nawu chindu chochosi ha ngajila kutola chilangushilu Lakini paghaveyi na vanachuli vaki weka yawu, avawombilili mana ya kila chilangushilu. ");
INSERT INTO ndj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lumihi lijuva lilila lila, Yesu kavawombela vanachuli vaki, “Tujabuki, tuyendi kumwambu ya lihiva.” ");
INSERT INTO ndj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Topi valileka lipinga lya vandu. Vanachuli vayingila muwatu mwayipakili Yesu na vawuka pamu. Kwaveli na matu vamonga. ");
INSERT INTO ndj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bahala pala, liyisa liwumbula na majinga vakanda kutova watu mbaka machi vakanda kumema muwatu wula. ");
INSERT INTO ndj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu aveli kumbeli muwatu kasaghamila musahamu. Vanachuli vamuyimusha, vamuwombela, “Muwula, ukulola ng'odu ndambu yitumilwa?” ");
INSERT INTO ndj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kayimuka, kalilakalila liwumbula lila na kavawombela majinga, “Nyamali jii!” Liwumbula linyamala na kulindivala jii. ");
INSERT INTO ndj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pambeli Yesu kavawombela, “Mukutila liki? Mukali muvahela ujumilwa?” ");
INSERT INTO ndj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na veni vatila nendu na vayidasha veni, “Ayu mundu wa ndambu liki? Hata liwumbula na majinga fyosi fikumjumila!” ");
INSERT INTO ndj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na vanachuli vaki vajabuka kumwambu ya lihiva lya Galilaya, mumlima wa Vagelasi. ");
INSERT INTO ndj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tepu Yesu pajabukili muwatu, katang'ana na mundu yafumbukili kumbaku siveli kusembi muna finyamkela. ");
INSERT INTO ndj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mundu ayu aveli akwikala kumbaku siveli kusembi na kwahela mundu yaweshili kumuwopa kandi hata kwa lingongola, ");
INSERT INTO ndj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","myanja yitangalili aveli pawopiwa mawoku na mawulu, lakini aveli padumula lingongola na akuketula ng'oyi shawopiwili. Na kwahela mundu yavelili na liwovi lya kumkamula. ");
INSERT INTO ndj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Majuva vosi aveli payenda-yenda kusembi na kufidunda, pawuta na kuyikesa-kesa kwa migonguveli. ");
INSERT INTO ndj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pamuwonili Yesu kutali, kamtuvilila na kumtundamila. ");
INSERT INTO ndj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kawuta kwa lishu likomi na kudeta, “Yesu, Mwana wa Chapanga yaveli kumbindi nendu! Ukudayila liki kwa nenga? Wilapi kwa litawa lya Chapanga, ngukudadava ukotoo kugobola!” ");
INSERT INTO ndj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Adetili naha kwanongwa Yesu adetili, “Yuwi chinyamkela, umfumi mundu ayu!” ");
INSERT INTO ndj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pambeli Yesu kamdasha, “Litawa lyaku ghani?” Mweni kamyangula, “Litawa lyangu ‘Lipinga’ kwanongwa tutangala!” ");
INSERT INTO ndj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pambeli kayendelela kumluva Yesu akotoo kuvavinga finyamkela panji ya mumlima wula. ");
INSERT INTO ndj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kwaveli na lipinga likomi lya vangubi pabehi na chidunda vavelili vakulya. ");
INSERT INTO ndj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Topi finyamkela vala vamluva Yesu pavadeta, “Tuyeghi kwa vangubi na utulekisheli tuvayingili.” ");
INSERT INTO ndj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu kavalekishela na finyamkela vala vamfuma mundu yula na kuyingila kwa vangubi. Lipinga lyosi lya vangubi elufu mbili vatuvilila mulihiva vamilwa machi vasova. ");
INSERT INTO ndj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vandu vavelili vakudima vangubi vala vatuva na kuvawombela vandu chilongu chila mumbwani na kufitava. Vandu vayenda kulola chila chigolikili, ");
INSERT INTO ndj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","pavafikili kwa Yesu, vamuwona mundu yula yavelili na lipinga lya finyamkela kayikala, kafwala yingwa shaki na luhala lwaki lumuwuyila, vosi vatila. ");
INSERT INTO ndj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vala vachiwonili chindu achi, vavawombela vandu vamonga chindu chimbwitukilili mundu yula yavelili na finyamkela na chilongu cha vangubi vala. ");
INSERT INTO ndj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Topi, vandu vamluva Yesu awuki mumlima wawu. ");
INSERT INTO ndj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu paghaveyi akwipaka muwatu, mundu yula yavelili na finyamkela kamluva vawuki pamu. ");
INSERT INTO ndj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lakini Yesu kamukanila. Kamuwombela, “Yendi kaya kwa valongu vaku kavawombeli filongu fyosi Bambu fyakugolilili na ndambu yakuwonilili lusungu.” ");
INSERT INTO ndj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Topi, mundu yula kuyenda kulandula milandu yosi ya Yesu yamgolilili aku Dekapoli. Na vandu vosi vapikanilili vajinga. ");
INSERT INTO ndj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu kayipaka kandi muwatu kajabuka kumwambu ya lihiva. Lipinga likomi lya vandu lyamshengitelili muluwongu ya lihiva. ");
INSERT INTO ndj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mundu yumu yavelili mkomi wa nyumba ya kudadavila, litawa lyaki Yailu ayendili, pamuwonili Yesu, kamtundamila, ");
INSERT INTO ndj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kamluva Yesu padeta, “Muhinja wangu akutamika dabadaba. Dekudeku wisi, umvikili mawoku vaku, ili anani.” ");
INSERT INTO ndj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Topi, Yesu awukili pamu na Yailu. Vandu vamkovikela na kumkekeneka-kekeneka kwanongwa vatangalili ngenju. ");
INSERT INTO ndj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Paveli mdadala yumu yavelili na utami wa liholuveya myaka lilongu na mivili. ");
INSERT INTO ndj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mdadala ayu aifwashili nendu kwa vayilwana na amalili findu fyaki fitangalili, lakini kanana ha, ila kayendelela kutamika nendu chipindi chosi. ");
INSERT INTO ndj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Papikanishili chilongu cha Yesu kwa vandu, kayisa na kayikekeneka kekeneka kupita mulipinga lya vandu. Kamyendela Yesu kwa kumbeli na kuyigufya yingwa yafwalili Yesu, ");
INSERT INTO ndj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","mweni ayidetilili, “Pagufya yingwa yaki hela, danani.” ");
INSERT INTO ndj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kagufya yingwa ya Yesu, bahala pala liholuveya limuwoloka na mweni kayiwona mumvili waki kucha utami unana. ");
INSERT INTO ndj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bahala pala Yesu kamanya liwovi limyangila. Topi, kalighalambukila lipinga lya vandu kadasha, “Ghani yagufyili yingwa yangu?” ");
INSERT INTO ndj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Vanachuli vaki vamyangula, “Ukuwona ndambu vandu yavakukekeneka kekeneka na yuwi ukudasha, ‘Ghani ayu yakugufyili?’” ");
INSERT INTO ndj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lakini Yesu kayendelela kulola amuwoni mundu yagolili chindu achi. ");
INSERT INTO ndj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mdadala yula kachimanya chindu chimbwitukilili, ndambu ayi kamyendela pabagama kwa lyogha. Kamuwila pamawulu vaki, pambeli kamuwombela fyosi nakaka. ");
INSERT INTO ndj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu kamuwombela, “Kamwali wangu, ujumilwa waku wukulowola. Yendi kwa kusika na wuvi mnofu.” ");
INSERT INTO ndj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu paghaveyi akudeta ndambu ayi, vayisa vandu kufuma kaya ya Yailu, yula mkomi wa nyumba ya kudadavila. Vamuwombela Yailu, “Muhinja waku kasova kala. Wuli ukumyasha muwula?” ");
INSERT INTO ndj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lakini Yesu papikanishili chavadetili, kabedala, kamuwombela yula mkomi wa nyumba ya kudadavila, “Kotoo kutila, ujumili hela.” ");
INSERT INTO ndj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu kadayila ng'odu mundu yoyosi ayilongoshi na mweni, ila Petili, Yakobi na Yohani, mlongu waki Yakobi. ");
INSERT INTO ndj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pavafikili kaya kwa Yailu mkomi wa nyumba ya kudadavila, Yesu kawona ndilingu na papikanishili vandu vakulila na kudadava. ");
INSERT INTO ndj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu kayingila munyumba, kavawombela “Wuli mkugola ndilingu na kulila? Mwana kasova ng'odu, kawonja hela!” ");
INSERT INTO ndj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lakini veni vamseka, topi, kavafumisha vosi panji. Kavatola tati na mau wa mwana yula, pamu na vanachuli vaki vatatu vavelili nawu, vayingila muchumbagati chivamuwonjishili mwana yula. ");
INSERT INTO ndj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu katola liwoku, kamuwombela, “Talita koumu!” Mana yaki, “Muhinja, ngukuwombela tandamuki!” ");
INSERT INTO ndj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bahala pala muhinja yula kayimuka na kakanda kuyendayenda. Muhinja yula aveli na myaka lilongu limu na mivili. Pafibwitukili afi, vandu vajinga nendu. ");
INSERT INTO ndj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lakini Yesu kavakana nendu vakotoo kumuwombela mundu yoyosi chilongu achi chigolikili. Pambeli Yesu kavawombela “Mumgayili muhinja ayu filivi.” ");
INSERT INTO ndj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kawuka pala, kayenda mumbwani yaki, vandundami vaki vamkovikela. ");
INSERT INTO ndj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Palifikili lijuva lya kupumulila, kakanda kuwula munyumba ya kudadavila. Vandu vatangalili vampikanishili vajinga, vadasha, “Kafipata koti fyosi afi? Luhunja liki alu kagayiliwa? Wuliwuli akuwesha kugola mihilu ayi? ");
INSERT INTO ndj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ayu msongola findu ng'odu? Mwana wa Maliya na valongu vaki vakina Yakobi, Yose, Yuda na Simoni? Na vahaja vaki vakwikala bahapa ng'odu?” Topi, vamlema. ");
INSERT INTO ndj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kavawombela, “Mbuyi akupikanishwa mahali posi, ila akupikanishwa ha mumbwani yaki na kwa valongu vaki na kaya yaki.” ");
INSERT INTO ndj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu kawesha ha kugola mihilu yoyosi pala, kavavikila vatami vadokwa hela mawoku, kavalowola. ");
INSERT INTO ndj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kajinga nendu kwanongwa vandu vavahela ujumilwa. Pambeli Yesu kafityangila fijiji fya pabehi, pavawula vandu. ");
INSERT INTO ndj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kavakema vala vanachuli lilongu na vavili, kakanda kuvalayisha vavili vavili. Kavagayila uwesu wa kuvawusha finyamkela. ");
INSERT INTO ndj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pambeli kavawombela, “Mkotoo kutola chindu chochosi mumwanja, ila lukweku weka hela. Mkotoo kutola filivi, wala muhaku, wala mbiya muchiwunu. ");
INSERT INTO ndj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mfwali filatu, lakini mukotoo kutola yingwa yimonga. ");
INSERT INTO ndj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nyumba yoyosi yivavalibushila, mwikali mula mbaka pamuwuka mbwani ayi. ");
INSERT INTO ndj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na mahali poposi vandu pavalema kuvalibushila ama kuvapikanisha, muwuki mupundi lifu mumawulu venu. Ayi dayivi utovileli kwa veni.” ");
INSERT INTO ndj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Topi vayenda na kuvalandulila vandu vapomeli. ");
INSERT INTO ndj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Vavafumisha finyamkela vatangalili na kuvashaya mafuta vatami vatangalili na kuvalowola. ");
INSERT INTO ndj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mutwa Helodi papikanishili filongu afi fyosi, kwanongwa litawa lya Yesu lipikanika mahali posi. Vandu vamonga vadetili, “Yohani mbatisha kashukuka! Ndi nongwa yaveli na liwovi lya kugola mihilu ayi.” ");
INSERT INTO ndj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lakini vamonga vadetili, “Ayu Eliya.” Vamonga vadetili, “Ayu mbuyi, kucha vala vambuyi va dahili.” ");
INSERT INTO ndj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helodi papikanishili filongu afi, kadeta, “Yohani mbatisha yindimdumulili mutwi kashukuka!” ");
INSERT INTO ndj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kwa nongwa dahili Helodi mweni alayishili kucha Yohani mbatisha akamuliwi na awopiwi muchijaka. Agolili naha kwanongwa amuhetili Helodiya, mdala wa Filipu na Filipu avelili mfwata mundu Helodi ");
INSERT INTO ndj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohani mbatisha amuwombilili Helodi, “Malawu vakulema yuwi kumtola mwehi wa mlongu waku!” ");
INSERT INTO ndj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Naha Helodiya kamkalalila nendu Yohani mbatisha, kadayila kumuwulagha, lakini kawesha ha nongwa ya Helodi. ");
INSERT INTO ndj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helodi amtilili Yohani mbatisha kwanongwa amanyili aveli mundu mnofu yang'alili, topi aveli akumlolela. Adayilaya kumpikanisha Yohani mbatisha, mani hela pamupikanishili kala, ajingili nendu. ");
INSERT INTO ndj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lijuva limu Helodiya apatili fwasi mulihungu lya kuwoneka kwa Helodi. Helodi avagolilili lihungu vatavala, vakulu va machonda na filongosi wa mlima wa Galilaya. ");
INSERT INTO ndj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Muhinja wa Helodiya payingilili kufina, afinili finofu, Helodi na vahenja vaki vasekilili. Topi mutwa kamuwombela muhinja yula, “Luvi chindu chochosi chiwudayila, nenga dangugayili.” ");
INSERT INTO ndj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kandi kayilapa, “Dangugayili chochosi chiwudayila, hata nusu ya wutwa wangu!” ");
INSERT INTO ndj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bahala pala muhinja yula kayenda kumudasha mau waki, “Nuvi liki?” Na mweni kamyangula, “Luvi mutwi wa Yohani mbatisha.” ");
INSERT INTO ndj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bahala pala mhinja yula katuva kwa mutwa kumluva, “Ngudayila ugayili ponopa mutwi wa Yohani mbatisha muluselu!” ");
INSERT INTO ndj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mutwa kang'onguteka nendu, lakini kawesha ha kulema, kwanongwa ayilapili paulongolu ya vahenja vaki. ");
INSERT INTO ndj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bahala pala mutwa kamulayisha machonda akayeghi mutwi wa Yohani mbatisha. Machonda kayenda muchijaka kamdumula Yohani mutwi waki. ");
INSERT INTO ndj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pambeli kauyegha mutwi wula muluselu kamgayila muhinja, mweni kamgayila mau waki. ");
INSERT INTO ndj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Vanachuli va Yohani mbatisha pavapikanishili afi, vayenda kuutola mvili waki na kuusika. ");
INSERT INTO ndj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Vandundami vawuyili vatangana kwa Yesu, vamuwombela fyosi fila fyavagolili na kuwula. ");
INSERT INTO ndj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu kavawombela, “Tuyendi weka yetu mahali pangajila vandu, mkapumulili padokwa.” Adetili ndambu ayi kwanongwa kwavelili na vandu vatangalili vavelili vakwisa na kuwuka, mbaka vapata ha fwasi ya kulya filivi. ");
INSERT INTO ndj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Topi vawuka weka yawu muwatu, vayenda mahali pangajila mundu. ");
INSERT INTO ndj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lakini vandu vavawonili pavaveghi vakuwuka, vavamanyili. Topi, vatuva kwa mawulu kufuma mbwani shosi na vatalili kufika. ");
INSERT INTO ndj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu pafumili muwatu, aliwonili lipinga likomi lya vandu. Kavawonela lusungu kwanongwa vaveli kucha vameni vangajila mdima. Topi kakanda kuvawula findu fitangalili. ");
INSERT INTO ndj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lumihi palufikili, vanachuli va Yesu vamyendela na kumuwombela, “Mahali apa pangajila vandu na lijuva lihonga. ");
INSERT INTO ndj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Uvaleki vandu vayendi kufitava na mufijiji fya pabehi vakayihemeleli filivi.” ");
INSERT INTO ndj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lakini Yesu kavayangula, “Yumwi muvapi filivi valyi.” Vamdasha, “Ponopa tuyendi tukahemeli mibumunda ya mbiya sha ijala ya myesi minani.” ");
INSERT INTO ndj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kavadasha, “Muva na mibumunda miningi? Muyendi mkaloli.” Pavalolili kala, vamuwombela, “Tuva na mibumunda muhanu na vasomba vavili hela.” ");
INSERT INTO ndj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pambeli Yesu kavawombela vanachuli vaki vavawombeli vandu vosi vayitapuli mufipinga-fipinga, vayikali pasi mulugobi. ");
INSERT INTO ndj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Topi, vandu vayikala mufipinga fya vandu miya yimu fya vandu milongu muhanu. ");
INSERT INTO ndj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pambeli Yesu kaitola mibumunda yila muhanu na vasomba vavili. Kalola kumbindi, kamlumba Chapanga na kuyimetula yila mibumunda. Pambeli kavapa vanachuli vaki vavapi vandu. Wuwula wula kavapa vandu vosi vala vasomba vavili. ");
INSERT INTO ndj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Vandu vosi valya vayikuta. ");
INSERT INTO ndj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vanachuli va Yesu vasola mibumunda na vasomba vasighalili vamemesha fitandavala lilongu limu na fivili. ");
INSERT INTO ndj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Vandu vosi valili valulumi vaveli alufu muhanu. ");
INSERT INTO ndj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bahala pala Yesu kavawombela vanachuli vaki vayingili muwatu, vamlonguleli kuyenda Betisayida. Mweni aveli akuvatawula vandu. ");
INSERT INTO ndj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pamalili kuvayitawula vandu, kayenda kuchidunda kumdadava Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lumihi palufikili, watu waveli pagati ya lihiva, mweni aveli weka hela kumwambu ya lihiva. ");
INSERT INTO ndj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kavawona vanachuli vaki vakukimbanika kuguba watu kwa ngafi, kwanongwa liyegha lyaveli likuvalimba. Payiveyi samba kulangala, Yesu kavayendela payendayenda kumbindi ya machi. Akadayileyi kuvapita, ");
INSERT INTO ndj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kumbi veni pavamuwonili akuyendayenda kumbindi ya machi, vadeta aveli chishuka. Vawuta, ");
INSERT INTO ndj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kwanongwa vosi pavamuwonili vatilili nendu. Bahala pala Yesu kavawombela, “Ndiva nenga! Mkotoo kutila, mugangamali.” ");
INSERT INTO ndj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pambeli kayingila muwatu pamu nawu na uyegha unyamala. Vanachuli vaki vajinga nendu, ");
INSERT INTO ndj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kwanongwa vaveli vakali hela kumanya mana ya kuvagayila mibumunda yila valyi, ndima shawu shaveli sidindala. ");
INSERT INTO ndj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Vajabuka lihiva, vayisa mumlima wa Genesaleti, pala vapayika watu wawu. ");
INSERT INTO ndj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pavajabukili muwatu, bahala pala vandu vamumanya Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Topi, vatuva mumlima wosi na vavatola vatami muluhagha na kuvayegha mahali poposi pavapikanishili Yesu paghaveyi. ");
INSERT INTO ndj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mahali poposi Yesu payendili, kufijiji, mumbwani, awu kufitava, vandu vavavika vatami pawelu. Vamluva avaleki vagufyi lupembu lwa yingwa yaki na vosi vagufyili vanana. ");
INSERT INTO ndj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Vafwalisayu vamu na vawula va Malawu vafumili Yelusalemu vamushengitelili Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Vavawona vanachuli vamu va Yesu vakulya filivi kwa mawoku mawafu, nyanyi vanava ha kucha chishovi chawu. ");
INSERT INTO ndj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kwa nongwa Vafwalisayu na Vayawudi vosi vakulya ha filivi mbaka vanavi mawoku vawu kucha wuvakamulili chishovi cha vavaha vawu. ");
INSERT INTO ndj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pavafuma kusoku vakulya ha chindu chochosi mbaka vachiwofuwi. Wuwula wula vakamulili fishovi fimonga, kucha kuwofuwa fikombi, fiyungu, fihela na fyombu fya chumang'andu. ");
INSERT INTO ndj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Topi, Vafwalisayu vala na vawula va Malawu vamdasha Yesu, “Kwa nongwa liki vanachuli vaku vakukamula ha fishovi fya vavaha, ila veni vakulya kwa mawoku ‘Va wafu?’” ");
INSERT INTO ndj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kavayangula, “Isaya atungili unofu, yumwi vafyangu, kucha fyayandikili: ‘Vandu ava vakujuma kwa milomu yawu, lakini ndima shawu siva kutali na nenga. ");
INSERT INTO ndj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Vakundundamila hela, pavawula fishovi fya vandu, kucha malayishu va Chapanga!’ ");
INSERT INTO ndj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Yumwi mukuvaleka Malawu va Chapanga na kukamula fishovi fya vandu.” ");
INSERT INTO ndj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu ayendililili kudeta, “Mukuyihola mugola finofu, lakini muvalema Malawu va Chapanga ili mkamuli fishovi fyenu. ");
INSERT INTO ndj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kwa nongwa Musa adetili, ‘Vapikani tati waku na mawaku, mundu yoyosi yamjowola tati mundu awu mamundu dawulayiwi.’ ");
INSERT INTO ndj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lakini yumwi mukudeta, kucha mundu yaveli na chindu cha kumtanga tati mundu awu mamundu, lakini kadeta chindu achi ‘Kolibani’ mana yaki, fupu kwa Chapanga, ");
INSERT INTO ndj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","topi mukudeta, mundu ayu akulemiwa kumtanga tati mundu awu mamundu. ");
INSERT INTO ndj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Topi, mkuchibedala chilongu cha Chapanga kwanongwa ya fishovi fyenu fyimukamulili. Kandi mukugola findu fitangalili fya ndambu ayi.” ");
INSERT INTO ndj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu kalikema kandi lipinga lila lya vandu. Kavawombela, “Mpikanishi vosi mumanya. ");
INSERT INTO ndj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kwahela chindu chimuyingila mundu chiwesha kumgola ghavi mwafu. Ila fila fimfuma mundu, fyeni fikumugola ghavi mwafu. ");
INSERT INTO ndj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mundu yaveli na majeji va kupikanishila, apikani” ");
INSERT INTO ndj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Palilekili lipinga lya vandu na kuyingila munyumba, vanachuli vaki vamdasha mana ya filangushilu afi. ");
INSERT INTO ndj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu kavawombela, “Hata yumwi muvahela luhala? Topi hata yumwi mumanya ng'odu kucha kwahela chindu chimuyingila mundu kufuma panji chimgola mundu ghavi ‘Mwafu’? ");
INSERT INTO ndj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kwa nongwa chikumuyingila ha mundima, ila chikuyingila munda, pambeli chikufuma panji ya mvili waki.” Kwa kudeta naha, Yesu kafigola filivi fyosi finofu. ");
INSERT INTO ndj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kayendelela kudeta, “Chindu chimfuma mundu ndi chimgola ghavi mwafu. ");
INSERT INTO ndj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwa nongwa mundima ya mundu kukufuma hoshu wafu na uwoni na wifi na kuwulagha na fimonga upeji na ");
INSERT INTO ndj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uwoni ubafu na wafu na ufyangu na lumatamata pamu na weyi na majowolu na lukilu na upufi. ");
INSERT INTO ndj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Fyosi afi fikufuma mugati ya mundu, ndi fikumugola mundu ghavi mwafu.” ");
INSERT INTO ndj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pambeli Yesu kawuka mahali pala, kayenda mumbwani ya Tilu. Aku kayingila munyumba yimu na kadayila ha mundu yoyosi amanyi. Lakini kawesha ha kuyififa. ");
INSERT INTO ndj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mdadala yumu yavelili na muhinja yaveli na chinyamkela, apikanishili filongu fya Yesu. Topi, bahala pala kamuyendela na kumuwila mumawulu vaki. ");
INSERT INTO ndj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mdadala ayu aveli mugiliki na awonikili mumbwani ya Silofoiniki. Kamluva Yesu amuwushi chinyamkela muhinja waki. ");
INSERT INTO ndj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lakini Yesu kamuwombela, “Leki tani vana vayikuti. Nyanyi ha kutola filivi fya vana na kuvagayila vagalu.” ");
INSERT INTO ndj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mdadala yula kamuyangula, “Yina Bambu, lakini hata vagalu yivavelili pasi ya mesa vakulya mipwambwa ya filivi fya vana!” ");
INSERT INTO ndj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu kamuwombela, “Kwa ndambu yiwuyangulili, yendi kaya dawuwoni chinyamkela kamfuma muhinja waku!” ");
INSERT INTO ndj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mdadala yula kayenda kaya yaki, kamuwona mwana waki kawonja paulili na chinyamkela kamfuma kala. ");
INSERT INTO ndj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pambeli Yesu kawuka mumbwani ya Tilu, kayenda mbaka Sidoni afikili lihiva lya Galilaya, kupitila Dekapoli. ");
INSERT INTO ndj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Vandu vamu vamuyeghela mundu yavelili majogu na yangajila kudeta unofu. Vamluva Yesu amvikili mawoku. ");
INSERT INTO ndj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu kamukwegha pambali na vandu. Kavika fyala fyaki mumajeji va mundu ayu. Pambeli atemili mita na kugufya lulimi lwa mundu yula. ");
INSERT INTO ndj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pambeli Yesu kalola kumbindi, kapumula nendu na kumuwombela mundu ayu, “Efwata” Mana yaki “Fuwuki!” ");
INSERT INTO ndj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bahala pala majeji va mundu yula vadiwuka, lulimi lwaki lufuwuka, kakanda kudeta unofu. ");
INSERT INTO ndj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu kavakanila kumuwombela mundu yoyosi. Lakini ndambu payendelelili kuvakanila, ndi ndambu yayendililili kukwisha filongu fyaki. ");
INSERT INTO ndj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vandu vajinga nendu. Vadeta, “Kagola fyosi finofu. Kavagola majogu vapikana na vangadeta vadeti!” ");
INSERT INTO ndj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chipindi achi, lipinga lingi likomi lya vandu vayikungula, vaveli vahela filivi. Topi Yesu avakemili vanachuli vaki, avawombilili, ");
INSERT INTO ndj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nguvawonela lusungu vandu ava nongwa tuyikala pamu kwa majuva matatu nalelu vavahela filivi. ");
INSERT INTO ndj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Panivaleka vayendi kaya na njala davashungi mudeha, nongwa vamonga vafuma kutali.” ");
INSERT INTO ndj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Vanachuli vaki vamudasha, “Kunu kudasi datupati koti mibumunda ya kuyikuta vandu vosi ava?” ");
INSERT INTO ndj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu avadashili, “Muna mibumunda miningi?” Vamyangula, “Tuva na mibumunda saba.” ");
INSERT INTO ndj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Topi kavalayila vayikali pasi, kayitola yila mibumunda saba, kamdadava Chapanga, kayimetula mibumunda, kavagayila vanachuli vaki, veni vavagayili vandu. ");
INSERT INTO ndj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vavelili kandi na fisomba fidokwa. Yesu kafinemela, wuwula kavagayila, vavagayili vandu. ");
INSERT INTO ndj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vandu valya, vayikuta. Vayola fisiyalili vamemesha fitandavala saba. ");
INSERT INTO ndj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Vandu valili vaveli vatangalili nendu ya elufu mchechi vavalangiwili. Pambeli Yesu avatawulili, ");
INSERT INTO ndj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tepu vayipakili muwatu pamu na vanachuli vaki, vayenda boma lya Dalimanuta. ");
INSERT INTO ndj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Vafwalisayu vakalimbaneyi, vakanda kumuwomesha Yesu. Vakadayileyi agoli chilangushilu kufuma kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu akawoneyi lusungu mundima, kawomba, “Mbona chileli cha ponopa chikudayila mihilu? Nakaka nguvawombela, chileli cha chipindi achi dachipati ha chilangushilu chochosi.” ");
INSERT INTO ndj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Topi kavaleka, kayipakila kandi muwatu, akandili mwanja kuyenda kumwambu. ");
INSERT INTO ndj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Vanachuli vayivasuwili kutola mibumunda, wumu hela vasiyalili nawu mula muwatu. ");
INSERT INTO ndj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu kavalayila, “Muvi mesu! Mulyepi na simika ya Vafwalisayu na simika ya Helodi.” ");
INSERT INTO ndj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Vanachuli vakanda kuwombana veni, “Kadeta naha kwanongwa twahela mibumunda.” ");
INSERT INTO ndj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu amanyili kala, avawombilili, “Mbona mkuwombana mwahela mibumunda? Wuli mkalihela kumanya? Wuli ndima shenu sikali hela kumanya? ");
INSERT INTO ndj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wuli muva na mesu mkulola ha? Muva na majeji na mukupikanila ha Muva hela ngumbungumbu? ");
INSERT INTO ndj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chipindi chila pametuleyi yila mibumunda muhanu na kuvagayila vandu nendu ya elufu muhanu? Vakunga fitandavala finingi fya filivi fisighalili?” Vamuyangula, “Fyaveli lilongu na fivili.” ");
INSERT INTO ndj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Pametuleyi yila mibumunda saba na kuvagayila vandu nendu ya elufu mchechi mkunga filivi fisiyalili finingi?” Vayangula, “Fyaveli saba.” ");
INSERT INTO ndj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Topi kavadasha, “Mkali hela kumanya?” ");
INSERT INTO ndj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu kafika Betisayida pamu na vanachuli vaki. Kuna vandu vamuyeghilili mundu ngalimesu, vamluvili amugufyi. ");
INSERT INTO ndj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu amkamulili liwoku yula ngalimesu, kamyegha panji ya kaya yila. Amutemilili mita mumesu, kamvikila mawoku, kamdasha, “Wuli ukuwesha kulola chindu?” ");
INSERT INTO ndj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ayu ngalimesu kalola, kadeta, “Nguwona vandu vakuyendayenda vakuwoneka kucha mibiki.” ");
INSERT INTO ndj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu amuvikilili kandi mawoku mumesu mweni kafulutula mesu, uwesu wa kulola umuwuyila, kila chindu kachiwona uswanu. ");
INSERT INTO ndj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu kamuwombela ayendi kaya na kumulayila, “Akotoo kuwuya muchijiji chila!” ");
INSERT INTO ndj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pambeli Yesu na vanachuli vaki vayendili kufijiji fya pabehi ya Kayisalia Filipu. Pavaveghi munjila, Yesu kavadasha vanachuli, “Vandu vakudeta nenga ghani?” ");
INSERT INTO ndj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Vamuyangula, “Vakudeta yuwi Eliya, vamonga Yohani mbatisha na vamonga yumu wa vambuyi.” ");
INSERT INTO ndj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pambeli Yesu kavadasha, “Yumwi mukucha nenga ghani?” Petili kamyangula, “Yuwi Kilistu.” ");
INSERT INTO ndj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu avakanili vakotoo kumuwombela mundu yoyosi filongu afi. ");
INSERT INTO ndj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu akandili kuwula vanachuli vaki Mwana wa Mundu dagobuliwi nendu na dalemwi na vavaha na vatambika vakomi, na vawula va Malawu. Kadeta davamuwulayi, mulijuva lya tatu kukandila pasovili dashukuki. ");
INSERT INTO ndj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu kavawombela, filongu afi ngatu hela. Petili amkweyili pambali, akandili kumlakalila. ");
INSERT INTO ndj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu kavaghalambukila vanachuli vaki, kamlakalila Petili padeta, “Wuki paulongolu yangu Lijangavandu! Ukuyihola fya mundu, fya Chapanga ha.” ");
INSERT INTO ndj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pambeli kalikema lipinga lya vandu pamu na vanachuli vaki, avawombilili, “Kucha mundu yoyosi yadayila ghavi ndumindumi wa nenga, ayilemi mweni, atoli lupingika lwaki, angovikeli. ");
INSERT INTO ndj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mundu yadayila kulowosha unofu waki mweni, davayamishi, lakini mundu dayasi unofu waki kunata nenga kwa Chilongu cha Nyanyi, dalowuliwi. ");
INSERT INTO ndj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mundu dapati liki mani mlima wosi pawuva waki na kuyamisha ndima yaki? ");
INSERT INTO ndj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mundu datoli chindu liki badili ya ndima yaki. ");
INSERT INTO ndj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mundu yoyosi muchileli achi cha sambi na chingali kumpikanisha Chapanga na yang'onela soni nenga na mawuli vangu, Mwana wa Mundu damuwoneli soni mundu ayu, chipindi padayila kuyisa kuukomi wa Tati waki pamu na makungu vang'alili.” ");
INSERT INTO ndj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu kavawombela, “Nakaka nguvawombela, kuna vamonga bahapa davasovi ng'odu mbaka vauwoni Wutwa wa kumbindi kwa Chapanga pauyisa kwa liwovi.” ");
INSERT INTO ndj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pavapitili majuva sita, Yesu kavatola Petili, Yakobi na Yohani kumbindi ya chidunda chitali weka yawu. Kula Yesu aghalambukili mvili paulongolu yawu, ");
INSERT INTO ndj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","yingwa shaki shang'alili mbuletee, shaveli ngeli nendu, kwa hela mundu yafuva yingwa yoyosi mumlima ndambu yila. ");
INSERT INTO ndj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pambeli Eliya na Musa vafumbuka, vakaywangeyi na Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petili kamuwombela Yesu, “Muwula, nyanyi yufwi tuyikali bahapa. Ngiba tujengi mibudi mitatu, limu lya yuwi limu lya Musa na limu lya Eliya.” ");
INSERT INTO ndj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petili na vayaki vatila, amanyili ha chindu cha kuwomba. ");
INSERT INTO ndj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pambeli lifumbuka lifundi livagubika na lishu lipikanika kufuma mulifundi, “Ayu mwana wangu yinimtamili, yanoviliwili nenga mumpikanishi mweni.” ");
INSERT INTO ndj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tepu vanachuli vala valola lola, hata naha vawona ng'odu mundu wingi, ila veni pamu na Yesu weka yaki. ");
INSERT INTO ndj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pavasunukeyi kuchidunda, Yesu avakanili, “Mukotoo kumuwombela mundu yoyosi findu fimufiwonili, mbaka Mwana wa Mundu pashukuka kufuma kwa vasovili.” ");
INSERT INTO ndj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Topi vajumila ndambu avalayili, lakini vakalimbaneyi veni kwa veni mana ya kushukuka kufuma kwa vasovili. ");
INSERT INTO ndj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Vamdasha Yesu, “Kwa nongwa liki vawula va Malawu vakadeteyi lasima ayisi tanila Eliya?” ");
INSERT INTO ndj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mweni kavayangula, “Yina Eliya akwisa tanila kugolikesha findu fyosi fya kukandila. Lakini nongwa liki yivayandikilili Mumayandiku vang'alili vakudeta Mwana wa Mundu dagobolewi nendu na kubedaliwa? ");
INSERT INTO ndj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lakini nguvawombela, Eliya kayisa kala, veni vamgolela vadayilili veni kucha fyavamyandikilili mumayandiku.” ");
INSERT INTO ndj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pavawuyili vala vanachuli vamonga, vawona lipinga likomi lya vandu pala. Vawula va Malawu vaveli vakuwombana nawu. ");
INSERT INTO ndj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tepu lipinga lya vandu pavamuwonili, wosi vayikanganika nendu, vamtuvilila kumjambusha. ");
INSERT INTO ndj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu kavadasha vanachuli, “Mkuhimula liki na ava?” ");
INSERT INTO ndj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Apa mundu yumu mulipinga lila lya vandu kamyangula, “Muwula, ndimuyegha mwana wangu kwa yuwi, kana chinyamkela akumgola akotoo kudeta. ");
INSERT INTO ndj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila pamyisila, akumuwisha pasi akumgola afumi mifulufulu mumlomu, akugwelujula minu na kuyuma mvili wosi, vanachuli vaku navaluvili vamuwushi chinyamkela yula valemwa.” ");
INSERT INTO ndj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu kavawombela, “Yumwi valelwa va ponopa mungajila kujumila nenga! Dandiyikali na yumwi mbaka ndili? Daniyiwunishili kwa yumwi mbaka ndili? Munyegheli msongolu ayu!” ");
INSERT INTO ndj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Vamyegha kwa Yesu. Yula chinyamkela pamuwonili Yesu, bahala pala amtayili chipwembu, kamuwisha pasi, kaghalafuka na kufuma mifulufulu mumlomu. ");
INSERT INTO ndj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu kamdasha tati mundu mwana yula, “Kava naha kufumila ndili?” Mweni kayangula, “Kufumila akali chali. ");
INSERT INTO ndj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Myanja yitangalili chinyamkela akadayileyi kumuwulagha amuwishili mumotu na mumachi. Mani ukuwesha, topi utuwoneli lusungu na ututangi!” ");
INSERT INTO ndj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu kamuwombela, “Kwa liki ukudeta kucha pauwesha? Findu fyosi fikuweshikana, mundu pajumila nenga.” ");
INSERT INTO ndj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bahala pala tati yula kalandula, “Ngukujumila, topi undangi ngujumili nendu!” ");
INSERT INTO ndj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu pawonili lipinga lya vandu likulopukesha kuyongisheka paulongolu paki, kamlakalila yula chinyamkela, “Yuwi chinyamkela yiwumgolili msongola ayu ghavi ngadeta na majogu! Ngukuwombela, ufumi kwa msongolu ayu, peli kumyingila kandi!” ");
INSERT INTO ndj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pala yula chinyamkela kawuta kwa lishu likomi, kamuwisha pasi, pambeli kamfuma. Msongolu kawoneka kucha chikongu, topi vamonga vakawombeyi, “kasova!” ");
INSERT INTO ndj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lakini Yesu kamkamula liwoku, kamuwolosha na mweni kawoloka. ");
INSERT INTO ndj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Topi Yesu payingilili munyumba, vanachuli vaki vamdasha kwa lufisu, “Kwa nongwa liki yufwi tulemwa kumfumisha chinyamkela?” ");
INSERT INTO ndj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu kavawombela, “Chinyamkela wa ndambu ayi afumi ha mbaka kumdadavila Chapanga hela.” ");
INSERT INTO ndj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na vanachuli vaki vawuka pala, vayendilela na mwanja kupitila mlima wa Galilaya. Yesu adayilili ha vandu vamanyi kakoti, ");
INSERT INTO ndj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kwanongwa avelili akuvawula vanachuli vaki. Kavawombela, “Mwana wa mundu davamhadiki kwa vandu vala davamuwulayi, hata naha pavapita majuva matatu kufuma pavamuwulayili dashukuki.” ");
INSERT INTO ndj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Vanachuli vaki vamanya ng'odu fyadetili, topi vatila kumdasha. ");
INSERT INTO ndj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Topi pavafikili Kapelinaumu. Pavaveghi munyumba Yesu avadashili vanachuli vaki, “Mkawombaneyi liki munjila?” ");
INSERT INTO ndj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Veni vanyamala, nongwa munjila vavelili vakulimbana ghani mkomi. ");
INSERT INTO ndj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu kayikala pasi, kavakema vala lilongu na vavili, kavawombela, “Mundu padayila kuva wa kwaa ghavi wa kumbeli na ndumindumi va wosi.” ");
INSERT INTO ndj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pambeli kamtola mwana mdokwa, kamwolosha pagati yawu, kamkusikila, kavawombela. ");
INSERT INTO ndj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mundu yoyosi yamupokela mwana kucha ayu kwa litawa lyangu, akumbokela nenga. Na mundu yoyosi yambokela nenga, akumbokela weka yangu ha, akumpokela na yula yanayishili.” ");
INSERT INTO ndj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohani kamwombela, “Muwula, tumuwona mundu yumu pawusha finyamkela kwa litawa lyaku, yufwi kumkanisha kwanongwa mweni muyetu ha.” ");
INSERT INTO ndj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lakini Yesu kadeta, “Mkotoo kumkanisha, nongwa kwa hela mundu yagola mihilu kwa litawa lyangu na chipindi chichila kudeta filongu fya wafu kwa nenga. ");
INSERT INTO ndj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nongwa, yangajila kulimbana na yufwi, kava na yufwi. ");
INSERT INTO ndj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mundu yoyosi davapi machi va kulanda kamamya yumwi muva vandu va Kilistu nakaka dayimpoti ha kupokela fupu shaki.” ");
INSERT INTO ndj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yoyosi yadayila kumpughanya yumu wa ava vadokwa vajumilili nenga, Yingavelili ngiba mundu ayu awopiliwi ligonguweli likomi mungulu yaki na kumdubushila mulweni. ");
INSERT INTO ndj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kucha liwoku lyaku palikuvifya, lidumuli. Ngiba uyingili muunofu wa jola na liwoku limu, pitu kuyingila kulifumbika na mawoku mavili. Aku motu waki ukujimika ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aku, vang'ongolu vakuvalya davasovi ha jola na motu ukuvanyanya ungajila kujima. Mayandiku vamonga va dahili vavahela msitali 44. ");
INSERT INTO ndj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na liwulu lyaku palikuvifya, lidumuli. Ngiba uyingili muunofu wa jola na liwulu limu, pitu kuva na mawulu vosi mavili na kudangiwa kulifumbika. ");
INSERT INTO ndj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aku vang'ongolu vakuvalya davasovi ha jola na motu ukuvanyanya ungajila kujima. ");
INSERT INTO ndj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na lisu lyaku palikugola uvifyi, likolopoli! Ngiba uyingili kuwutwa wa Chapanga na lisu limu hela, pitu kuva na mesu vosi mavili na kudangiwa mulifumbika. ");
INSERT INTO ndj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mula vang'ongolu vaki davalumi na vakusova ng'odu na motu waki wa lifumbika. ");
INSERT INTO ndj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kila mundu dasingiwi kwa motu kucha wula nyama payilungiwa munyu yikotoo kuwola. ");
INSERT INTO ndj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Munyu wa nyanyi, mani pavayaghamisha kubaka kwaki, dauwuyishiwi na liki ili ubaki? “Muvi na lighanja mugati yenu, muyikali kwa kusika yumwi kwa yumwi.” ");
INSERT INTO ndj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu afumili apa kayenda mlima wa Yudeya, mbaka kumwambu ya lweni lwa Yoludani. Lipinga lya vandu limyendela kandi, mweni kavawula kandi kucha yivelili chishovi chaki. ");
INSERT INTO ndj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Topi Vafwalisayu vamyendela, vakamyeshi vamdasha, “Wuli nyanyi Malawu va yufwi, mlumi kumleka mdala waki?” ");
INSERT INTO ndj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kavadasha, “Musa kavalayila liki?” ");
INSERT INTO ndj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Veni vayangula, “Musa katulayila mlumi pamuleka mdala waki kwa kumgayila talaka.” ");
INSERT INTO ndj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu kavawombela, “Musa avayandikilili Malawu kwanongwa ya ndima shyenu sidindalili. ");
INSERT INTO ndj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kufuma ulumbi wa mlima, Chapanga kalumba mlumi na mdala. Mayandiku vakuwomba, ");
INSERT INTO ndj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mlumi damleki tati waki na mau waki, kuyenda kuyilumba na mdala waki, ");
INSERT INTO ndj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","davavi mvili wumu.’ Ponopa vava kucha mvili wumu, vavili kandi ha. ");
INSERT INTO ndj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Topi chalumbili Chapanga, mundu alekanishi ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pavayingilili kandi munyumba, vanachuli vaki vamdashili filongu fila. ");
INSERT INTO ndj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mweni kavawombela, “Yamleka mdala mundu wa kwaa na kumheta wingi akali akagola uwoni. ");
INSERT INTO ndj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na mdala yamleka mlumi waki wa kwaa na kutoliwa na wingi akugola uwoni.” ");
INSERT INTO ndj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Vandu vamuyeghela Yesu vananguta avavikili mawoku, lakini vanachuli vaki vavalakalila. ");
INSERT INTO ndj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu pawonili nawula, akalalili kavawombela, “Muvaleki vananguta ava vayisi kwa nenga, mukotoo kavakanila, nongwa wutwa wa kumbindi kwa Chapanga wuva kwa vandu kucha vananguta ava. ");
INSERT INTO ndj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nguvawombela nakaka, mundu yoyosi yangajila kuupokela wutwa wa kumbindi kwa Chapanga kucha mwananguta, dayingili ng'o muwutwa wa kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pambeli kavapokela vananguta vala kavakusikila na kuvanemela. ");
INSERT INTO ndj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pakandili kandi mwanja waki, mundu yumu kamtuvilila, kamtundamila paulongolu paki, kamdasha “Muwula msangi, goli wuliwuli mbati unofu wa jola?” ");
INSERT INTO ndj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kayangula, “Wuli ukungema msangi? Kwahela yaveli msangi ila Chapanga weka yaki. ");
INSERT INTO ndj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kuvamanya Malawu: ‘Ukotoo kugola uwoni, ukotoo kuwulagha, ukotoo kuhija, ukotoo kutovelela udesi, ukotoo kudeta ufyangu, uvatundamili tati waku na mau waku.’ ” ");
INSERT INTO ndj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mundu yula kamyangula, “Muwula, afi fyosi gola kukandila ngali msongolu.” ");
INSERT INTO ndj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kamlola, kamtama, kamuwombela, “Chikupota chindu chimu, yendi kawuli findu fyosi fiwuveli nafyu, na mbiya dawusipati wuvagayili vagaju na yuwi dawuvi na lusanja kumbindi kwa Chapanga. Pambeli wisi ungovikeli.” ");
INSERT INTO ndj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Papikanishili afi, ang'ong'utekili, ayendili kunu kakikinala, nongwa aveli na mali sitangalili. ");
INSERT INTO ndj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu alolili mbembi shosi, avawombilili vanachuli vaki, “Ndambu dayivi yidindala kwa valundamali kuyingila muwutwa wa kumbindi kwa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Vanachuli vayikanganika filongu fyaki. Yesu kavawombela kandi, “Vana vangu, yidindala nendu kuyingila muwutwa wa kumbindi kwa Chapanga! ");
INSERT INTO ndj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yipusuka nendu kwa ng'ongolu mkomi kucha ndembu yivamkema ngamiya kwingila chilanga cha sasiya, ngatu hela mlundamali kuyingila muwutwa wa kumbindi kwa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Vanachuli vaki vayikanganika nendu vakayidasheyi, “Ghani dawesi kulowoka?” ");
INSERT INTO ndj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu kavalola kavawombela, “Kwa mundu ahotoli ngo'du, lakini kwa Chapanga findu fyosi fikuhotuliwa.” ");
INSERT INTO ndj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petili kamuwombela, “Wuli yufwi tufileka findu fyosi, tukukovikela yuwi!” ");
INSERT INTO ndj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu adetili, “Nakaka nguvawombela, kila mundu yaleka libudi na mlongu na mhaja na mau na tati na vana na fitava kwanongwa ya nenga na kwanongwa ya Chilongu cha Nyanyi, ");
INSERT INTO ndj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dapokeli fitangalili mumajuva ava. Dapokeli mibudi na valongu vahaja na vamau na vana pamu na kugoboka, mumajuva vakwisa dapokeli unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hata naha vatangalili vaveli vakomi mumlima davavi vadokwa na Vagaju vaveli mumlima davavi vakomi.” ");
INSERT INTO ndj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Topi pavaveghi munjila kuyenda kumbindi Yelusalemu na Yesu avalongulili. Vandumindumi vaki valwangili na vandu vamkovikeleyi vatilili. Yesu avatolili kandi pambali vala lilongu na vavili, kakanda kuvawombela fila dafimfiki. ");
INSERT INTO ndj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kavawombela, “Mpikanishi! Tukuyenda Yelusalemu, aku Mwana wa Mundu davamtoli kwa vatambika vakomi na vawula va Malawu. Veni davamuhighi njifwa, pambeli davamtoli kwa vandu vangajila kuva Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Veni davadanili na davandemeli mita, davandovi ndomondu na kung'ulaya. pavapita majuva matatu dashukuki.” ");
INSERT INTO ndj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobi na Yohani, vana va Sebidayu, vayendili kwa Yesu vamuwombela, “Muwula, tukudayila utugoleli chindu datukuluvi.” ");
INSERT INTO ndj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu amdashili, “Mkudayila nivagoleli liki?” ");
INSERT INTO ndj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Vamyangula, “Utujumishi tuyikali yumu mwambu waku wa kumkiyi na yumonga kumlilu muukomi waki.” ");
INSERT INTO ndj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu kavawombela, “Mumanya ng'odu mkudadava liki! Mkuwesha wuli wuli kulandila mulwindi lwa kugoboka, awu kabatishiwa kucha vabatishiwi nenga?” ");
INSERT INTO ndj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Vamyangula, “Tukuwesha.” Yesu avawombilili, “Lwindi danandili damlandili nakaka na dambatishiwi kucha ndavabatishili. ");
INSERT INTO ndj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Hata naha ghani dayikali mwambu wangu wa kumlilu awu kumkiyi, chichuku cha nenga ha kushaula ila davavi vala vavikiliwi kala.” ");
INSERT INTO ndj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Vala vanachuli vamonga lilongu pavapikanishili afi, vakandili kuvakalalila Yakobi na Yohani. ");
INSERT INTO ndj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu avakemili, avawombilili, “Mumanya kucha vala vakwiholiwa vatavala va vandu, vakutavala vandu vawu kwa liwovi na vakomi ava vavatavalili vandu vawu. ");
INSERT INTO ndj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lakini kwa yumwi yikotoo kuva naha, ila yadayila kuva mkomi wenu, ghavi ndumindumi va yumwi. ");
INSERT INTO ndj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kwa yumwi yadayila kuva wa kwaa, ghavi ndumindumi va vosi. ");
INSERT INTO ndj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nongwa Mwana wa Mundu ayisili vakotoo kumkimbanikila ila kuvakimbanikila na kuvakombola vandu vatangalili.” ");
INSERT INTO ndj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Topi vafikili Yeliku, Yesu paghaveyi akufuma pala na vanachuli vaki pamu na lipinga likomi lya vandu, ngalimesu, mwana va Timayu vakumkema Balitimayu, avelili kayikala mumbali ya deha akudadava vamutangi. ");
INSERT INTO ndj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Papikanishili Yesu wa Nasaleti akutyangila pala, kakanda kukema kwa lishu likomi, “Yesu, Mwana va Dawudi! Ung'oneli lusungu!” ");
INSERT INTO ndj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vandu vatangalili vamlakalila, Unyamali lakini mweni awutili nendu, “Mwana wa Dawudi, ung'oneli lusungu!” ");
INSERT INTO ndj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu awolukili, kadeta, “Mumkemi.” Topi vamkema yula ngalimesu, vamuwombela, “Uyikangashi! Uwoloki akukukema.” ");
INSERT INTO ndj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mweni ayasili ligololi lyaki pambali, ajumbili kamyendela Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu amdashili, “Ukudayila ngugoleli liki?” Yula ngalimesu kamuwombela, “Muwula, nguluva kulola.” ");
INSERT INTO ndj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu amuwombilili, “Yendi, kujumila kwaku kukulowola.” Bahala pala yula ngalimesu aweshili kulola, amkovikelili Yesu mumwanja. ");
INSERT INTO ndj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pavaveghi pabehi na Yelusalemu vafikili Betifage na Betaniya, pabehi na chidunda cha miseituni. Pala Yesu avalayishili vanachuli vaki vavili avalonguleli, ");
INSERT INTO ndj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","avawombilili, “Muyendi kaya yaveli kuulongolu yenu. Pamyingila kula, bahala pala damuwoni ngwada wa chihongu kakongiwa, akali kugoliwa chichuku na mundu. Mumuwoposoli mumuyeghi. ");
INSERT INTO ndj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kucha mundu pavavadasha, ‘Nongwa liki mukugola naha?’ Mumuwombeli, ‘Bambu akumdayila na tepu damuwuyishi.’ ” ");
INSERT INTO ndj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Topi vayenda, vamwonili ngwada wa chihongu mumbali ya deha kakongiwa pamlyangu. Pavamuwopusoleyi, ");
INSERT INTO ndj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vandu vamonga vavelili vawoloka pala vavadashili, “Kwa nongwa liki mkumuwoposola chihongu ayu?” ");
INSERT INTO ndj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Vanachuli vayangulili kucha Yesu avawombilili, vandu vala vavaleka vanachuli vayendi na chihongu. ");
INSERT INTO ndj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Vamuyeghela Yesu ngwada wa chihongu, vayala yingwa shawu kumuwongu ya chihongu na Yesu kakwela kumbindi yaki. ");
INSERT INTO ndj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Vandu vatangalili vayala yingwa shawu mudeha, vamonga vayala miputila ya mibiki vadumulili mufitava. ");
INSERT INTO ndj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vandu vosi valongulili na vala vavakovikelili, vadeta kwa lishu likomi, “Tumjumi! Chapanga amunemeli ayu yayisa kwa litawa lya Bambu Chapanga! ");
INSERT INTO ndj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nemeli wutwa ukwisa wa mbuyi wetu Dawudi. Ajumiwi Chapanga avelili kumbindi nendu!” ");
INSERT INTO ndj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu ayingilili Yelusalemu ayendili mbaka munyumba ya Chapanga, kalola kila chindu kwa unofu. Lijuva lyahongili kala ayendili Betaniya pamu na vala lilongu na vavili. ");
INSERT INTO ndj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chilawu yaki pavafumeyi Betaniya, Yesu aveli na njala. ");
INSERT INTO ndj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Topi kwa kutali aliwonili likuyu livelili na mahamba vatangalili. Kaliyendela aloli kucha liveleka. Pafikili kawona liveleka ng'odu lina mihamba hela, chipindi chaki cha kuveleka chavelili chakali. ");
INSERT INTO ndj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bahala pala kaliwombela likuyu, “Kufumila nalelu mbaka jola, mundu yoyosi akotoo kulya fivelekwa fyaku.” Vanachuli vaki vakapikanisheyi filongu afi. ");
INSERT INTO ndj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vafikili Yelusalemu. Yesu ayingilili munyumba ya Chapanga kakanda kuvavinga vandu vafumi panji vavelili vakuchuusa na kuhemela findu mula. Aghalambulili mesa sha vala vakafunjeyi mbiya na figoda fya vala vavelili vakuchuusa vangunda. ");
INSERT INTO ndj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Alemili kumjumisha mundu yoyosi kutola chindu muudamwa wa nyumba ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pambeli kavawula, “Yiyandikiwa mumayandiku, ‘Nyumba ya nenga dayikemiwi nyumba ya kudadava kumluva Chapanga kwa vandu va milima yosi!’ Lakini yumwi muyigola kucha mbaku ya vefi!” ");
INSERT INTO ndj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Vatambika vakomi na vawula va Malawu pavapikanishili afi, vakanda kusaka njila ya kumuwulagha Yesu. Hata naha vamtilili nongwa lipinga lya vandu vayikanganikeyi mawuli vaki. ");
INSERT INTO ndj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lijuva palihongili, Yesu na vanachuli vaki vawuka vayileka mbwani. ");
INSERT INTO ndj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pamalavila putiputi, pavapiteyi, valiwonili lila likuyu liyuma kukandila mikigha mbaka kumbindi. ");
INSERT INTO ndj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petili akumbukili, chawombili Yesu, “Muwula, loli! Lila likuyu wulilapilili, liyuma!” ");
INSERT INTO ndj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kamuwombela, “Mumjumili Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nguvawombela nakaka, mundu pachiwombela chidunda achi, ‘Tupuki kadubukili mulihiva,’ na pangajila hoshu mundima yaki, topi pajumila kucha chadetili dachifumbuki, dachigoleki kwa mweni. ");
INSERT INTO ndj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ponopa nguvawombela, pamdadava na pamumuluva Chapanga chindu chochosi mjumili mupokela kala davavapi. ");
INSERT INTO ndj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pamdayila kudadava, pomeli kila mundu chila chavavifyili ili tati wenu wa kumbindi avapomeli fimuvifyili.” ");
INSERT INTO ndj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mani pamuvapomela ng'odu vayenu, hata tati wenu yavelili kumbindi dalemi kuvapomela. ");
INSERT INTO ndj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Topi vayisa kandi Yelusalemu. Yesu payendeyendeyi munyumba ya Chapanga, vatambika vakomi na vawula va Malawu na vavaha vamyendela. ");
INSERT INTO ndj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Vamdasha, “Ukugola findu afi kwa uwesu wa ghani? Ghani yakujumishili kugola findu afi?” ");
INSERT INTO ndj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kavawombela, “Danivadashi chindu chimu, pamunyangula na nenga wuwowu danivawombeli ngugola findu afi kwa uwesu wa ghani. ");
INSERT INTO ndj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ghani yamupili Yohani mbatisha uwesu wa kubatisha? Chapanga amupili awu vandu vamupili? Munyanguli.” ");
INSERT INTO ndj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Vakandili kuyidasha, “Patudeta, ‘Mani patudeta kufuma kumbindi kwa Chapanga,’ datudashi, ‘Topi mbona mumjumila ng'odu?’ ");
INSERT INTO ndj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pambeli tukuwesha ha kudeta ‘Vamupili vandu.’” Vadetili naha kwanongwa vatila lipinga lya vandu, nongwa vosi vajumilili nakaka Yohani mbatisha aveli mbuyi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Topi vamyangula Yesu, “Yufwi tumanya ha.” Yesu avawombilili, “Na nenga nivawombeli ng'o kwa uwesu wa ghani ngugola findu afi.” ");
INSERT INTO ndj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu akandili kuywanga nawu kwa chilangushilu: “Mundu yumu alimili chitava cha misabibu. Alishengiteshili luviwu na pagati yaki kakumba lyowu lya kukamila misabibu, ajengili na lilingu. pambeli kachihadika chitava chila kwa valimi, mweni ayendili mlima wa kutali. ");
INSERT INTO ndj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chipindi cha kubena, amlayishili ndumindumi waki kwa vala valimi, akamyegheli sehemu ya fyavabenili muchitava chaki. ");
INSERT INTO ndj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Vala valimi vamkamula na vamtovanga na vamuwuyisha mawoku hela. ");
INSERT INTO ndj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kamulayisha kandi ndumindumi wingi na ayu vamtesha kumutwi na kumgola wafu. ");
INSERT INTO ndj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yula muna chitava amulayishili ndumindumi wingi kandi, valimi vala ayu vamuwulaya. Avatumili vamonga vatangalili, vamonga vatovangiwa na vamonga vavawulayili. ");
INSERT INTO ndj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Asiyalili na mundu yumu, aveli mwana waki amtamili. Pambeli amlayishili ayu kawomba, ‘Davamtili mwana wangu.’ ");
INSERT INTO ndj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lakini vala valimi vawombana, ‘Ayu daghavi muhala mbala, topi tumuwulayi, mbala yaki yivi yetu!’ ");
INSERT INTO ndj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kwa ndambu yila vamkamula na vamuwulaya na kumyasa panji ya chitava chila. ");
INSERT INTO ndj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Topi, bambu muna chitava dagoli liki? Dayisi kuvawulagha valimi ava na kuvahadisa chitava chila kwa vandu vengi. ");
INSERT INTO ndj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wuli mkali hela kusoma mayandiku yivadeta: ‘Ligonguveli livalemili vajengi liva ligonguveli likomi lya chikandilu ");
INSERT INTO ndj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bambu yagolili findu afi, fya chiloja nendu kwa yufwi?’ ” ");
INSERT INTO ndj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Vatambika vakomi na vawula va Malawu na vavaha vamanyili kucha chilangushilu achi chikwivayilata veni. Vayesha kumkamula lakini vatila lipinga lya vandu, vamuleka, veni vayenda. ");
INSERT INTO ndj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Topi Vafwalisayu na vandu vamonga va chipinga cha mutwa Helodi avalayishili vamuwomeshi Yesu kwa filongu fyaki. ");
INSERT INTO ndj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Vamyendilili, vamuwombela, “Muwula tukumanya kucha yuwi kuva mundu yuwudeta nakaka weka, ukumtila ng'odu mundu yoyosi. Wala ukomi wa mundu chindu ng'odu kwa yuwi, lakini ukuwula njila ya nakaka ya Chapanga. Wuli nyanyi kuhomba kodi kwa mutwa wa Loma, awu ng'odu? Tuhombi awu tukotoo kuhomba?” ");
INSERT INTO ndj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lakini Yesu amanyili ufyangu wau, kavawombela, “Mbona mukunyesha? Muyeghi ligwala lyeni ndililoli.” ");
INSERT INTO ndj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Vamuyeghela, vamupa aloli. Na mweni kavadasha, “Wushu na litawa ali lya ghani?” Vamyangula, “Ya mutwa wa Loma.” ");
INSERT INTO ndj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Topi Yesu kavawombela, “Fya mutwa wa Loma mumupi mutwa wa Loma na fya Chapanga mumupi Chapanga.” Vamkanganikili nendu. ");
INSERT INTO ndj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pambeli vandu vamu va chipinga cha Masadukayu, ava vandu yivawomba yivasovili vakushukuka ng'odu, wamuyendela Yesu, vamdasha. ");
INSERT INTO ndj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Muwula, Musa atugayilili Malawu kucha, ‘Mundu pasova na kuleka mdala angali mwana, mlongu mundu lasima amhali ayu ngalimlyangu, ili amleleli mwana mlongu mundu.’ ");
INSERT INTO ndj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Topi kwavelili valongu saba. Wa kwandi atolili mdala, kasova ngajila kuleka mwana. ");
INSERT INTO ndj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mlongu wa pili kamtola yula ngalimlyangu na mweni kasova ngajila kuleka mwana na mlongu wa tatu wuwula wula. ");
INSERT INTO ndj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Vosi saba vasova ngajila kuleka mwana. Pambeli yula ngalimlyangu na mweni asovili. ");
INSERT INTO ndj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lijuva palifika vandu vasovili pavashukuka, mau ayu daghavi mdala va ghani? Nongwa vosi saba vamtolili.” ");
INSERT INTO ndj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kavawombela, “Yumwi muvifya mpota liki kumanya Mayandiku vang'alili na liwovi lya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nongwa vandu pavashukuka davatoli ng'odu wala kutoliwa, davavi kucha makungu wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wuli, musoma ng'odu chitabu cha Musa, chilongu cha kushukuka kwa vasovili, pachivala pakayakeyi motu? Chapanga amuwombilili Musa ‘Nenga Chapanga wa Ibulahimu na Chapanga wa Isaka na Chapanga wa Yakobi.’ ");
INSERT INTO ndj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Topi mweni Chapanga wa vasovili ha, Chapanga wa vavelili vanofu. Yumwi muvifya nendu.” ");
INSERT INTO ndj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yumu wa muwula va Malawu afikili, kapikanisha malimbanu va Masadukayu na Yesu. Pawonili kucha Yesu kavayangula nyanyi, kafumbuka, kavadasha, “Malawu vosi va Chapanga lyoti liva likomi pitu vosi?” ");
INSERT INTO ndj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kayangula, “Lilawu likomi ndi ali, ‘Isilaeli pikanishi. Bambu Chapanga wetu, Bambu kava mweni weka yaki. ");
INSERT INTO ndj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Umtami Bambu Chapanga waku kwa ndima yaku yonda na kwa ngunda yaku yosi na kwa luhala lwaku losi na kwa liwovi lyaku lyosi.’ ");
INSERT INTO ndj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lilawu lya pili litawukili nendu ndi ali, uvatami vandu vamonga kucha pawitama umweni. Kwahela lilawu lingi likomi pitu ali.” ");
INSERT INTO ndj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yula muwula va Malawu kamuwombela “Nyanyi Muwula! Kudeta nakaka kuwomba Chapanga yumu weka hela wala kwahela wingi ila mweni. ");
INSERT INTO ndj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mundu amtami Chapanga kwa moyu wosi, kwa luhala losi na liwovi lyosi na kuvatama vandu vamonga kucha pauyitama mweni. Chindu achi chibalama nendu kwa litambiku lya kunyanya kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu pawonili kucha mundu ayu kamuyangula kwa luhunja amuwombilili, “Yuwi kuva kutali ha na Wutwa wa kumbindi kwa Chapanga.” Pambeli, kwahela mundu yayeshili kandi kumdasha chindu. ");
INSERT INTO ndj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu paghaveyi akuwula munyumba ya Chapanga, kavadasha, “Mbona vawula va Malawu vakudeta kucha Kilistu mkombola mwana wa Dawudi? ");
INSERT INTO ndj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawudi mweni paghaveyi na Mfuki Mng'alili akumlongosha awombili: ‘Bambu kamuwombela Bambu wangu: Wuyikali mwambu wangu wa mlilu, mbaka nivaviki vachimdwama vaku pasi ya mawulu vaku.’ ");
INSERT INTO ndj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Mweni Dawudi akumkema Kilistu Mkombola Bambu. Wuli wuli, Kilistu daghavi mwana wa Dawudi?” Lipinga lya vandu lyaveli likumpikana Yesu kwa seku. ");
INSERT INTO ndj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","paghaveyi akuwula, kadeta, “Muyikali mesu na vawula va Malawu veni vakudayilaya kupita vafwala mihabiti mitali na vakujambushiwa kwa hishima na vandu pavapita kusoku. ");
INSERT INTO ndj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kuyikala kufigoda fya kuulongolu munyumba ya kudadavila na kuyikala mufigoda fya nyanyi mulihungu. ");
INSERT INTO ndj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Vakuvasulumu nyumba vangalimlyangu kunu vakwilyambishila kudadava sala ndali! Lijuva lya kuhigha davapati asabu ngomi.” ");
INSERT INTO ndj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu aveli kayikala pabehi ya sanduku lya mbiya. Akaloleyi ndambu vandu vatangalili pavayiseyi kutaya mbiya mulisanduku lya mbiya lya Nyumba ya kudadavila. Valundamali vatangalili vatayili mbiya sitangalili. ");
INSERT INTO ndj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pala ayisili mau yumoyu ngalimlyangu mgaju, atayili migwala mivili midokwa ya mbiya. ");
INSERT INTO ndj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pala Yesu avakemili vanachuli vaki, kavawombela, “Nakaka nguvawombela, mau ayu yangajila chindu mgaju kataya mulisanduku lya mbiya chikomi kupita sivatayili vamonga vosi. ");
INSERT INTO ndj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nongwa vamonga vosi vataya shiyongisikili mumali shawu, lakini ayu mau, yaveli mgaju, kataya chavelili nachu chosi, atayili kila chindu chadayileyi mweni kayaki.” ");
INSERT INTO ndj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu pafumeyi munyumba ya Chapanga mwanachuli waki yumu amuwombilili, “Muwula, loli ndambu migonguveli ayi na nyumba asi sivelili sha kuyikang'anika!” ");
INSERT INTO ndj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu kamuwombela, “Wuli ukuyiwona nyumba ayi ngomi? Kwa hela hata ligonguweli limu dalisighali kumbindi ya limonga, kila chindu dachibowuliwi.” ");
INSERT INTO ndj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu pavelili kayikala kumbindi ya chidunda cha miseituni akaloleyi kunyumba Ngomi ya Chapanga Petili na Yakobi na Yohani na Andeleya vamdasha paweka, ");
INSERT INTO ndj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tuwombeli findu afi dafivi ndili? Datuwoni chilangushilu liki kucha milandu ayi yiva pabehi kuwoneka?” ");
INSERT INTO ndj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu akandili kuvawombela, “Muyikali mesu akotoo kuvapughanya mundu. ");
INSERT INTO ndj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nongwa vatangalili davayisi kwa litawa lyangu, kila mundu dayikemi mweni Kilistu! Ava davavayaghamishi vandu vatangalili. ");
INSERT INTO ndj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pampikanila ngondu na lupwepu lwa ngondu, mukotoo kulilimuka. Findu afi dafiwoneki, hata naha mlima kupela kukali hela kufika. ");
INSERT INTO ndj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vandu va mlima wumu davayiminyi na vandu va mlima wingi, wutwa wumu dauwiminyi na wutwa wingi, Kila mahali dakuwi na chiyighayigha na njala. Findu afi kucha utami wa lihingili lya kulela mwana. ");
INSERT INTO ndj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Lakini yumwi mugungi mesu. Vandu davavayeghi kuchitemela na kuvatovanga kunyumba sha kudadavila. Davavayeghi kwa vatavala na vatwa kwanongwa ya nenga, ili muvatovileli filongu fya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na Chilongu cha Nyanyi chikudayiliwa chilanduliwi kwa vandu va milima yosi. ");
INSERT INTO ndj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Veni pavavika muchijaka na kuvayegha kuchitemela, mukotoo kutila kucha damdeti liki. Saa yila payifika, mdeti chochosi dampati, nongwa yumwi ha damdeti ila Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mlongu damupi mlongu waki amuwulayi, tati damupi mwana mundu, vana nawu davakang'ali vavaha vawu na kuvawulaya. ");
INSERT INTO ndj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vandu vosi davavanyekwi yumwi nongwa ya litawa lyangu. Lakini yayiwunishila mbaka mwishu ayu dalowuliwi. ");
INSERT INTO ndj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pamuwona ‘Uvifyi wafu’ liwolokela mahala paki ng'odu,” Yasoma amanyi mana yaki. Apa vavelili Yudeya vatuvili kufidunda. ");
INSERT INTO ndj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yaveli kumbindi ya lipaghali lya nyumba akotoo kusunuka kuyingila munyumba yaki kutola chindu. ");
INSERT INTO ndj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yaveli kufitava akotoo kuwuya kumbeli kutola yingwa yaki. ");
INSERT INTO ndj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Davachiwoni vadadala vaveli na ndumbu na kuyongesha majuva va mbelu! ");
INSERT INTO ndj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dadavi kwa Chapanga findu afi fikotoo kuva chipindi cha lupepu. ");
INSERT INTO ndj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nongwa dakuvi na utatala nendu chipindi achi tukali kuchiwona tangila Chapanga agoli mlima awu mbaka nalelu, wala dayibwituki kandi ha. ");
INSERT INTO ndj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kucha Bambu angapungushili ng'odu majuva ava kwahela mundu angalowuliwili. Lakini kwa vala vaki avashawulili, Bambu kapungusha majuva ava. ");
INSERT INTO ndj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Topi mundu pavawombela, ‘Mloli, Kilistu kava apa,’ awu ‘kava pala,’ mukotoo kumjumila. ");
INSERT INTO ndj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwanongwa davawoneki vakina Kilistu wa udesi na vambuyi va udesi, davagoli filangushilu na findu fya filoja, kwa kudayila kuvayaghamisha avashawulili Chapanga kucha pavawesha. ");
INSERT INTO ndj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Topi yumwi muvi mesu. Nenga nivawombela findu fyosi fikali kuwoneka.” ");
INSERT INTO ndj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Topi majuva ava pambeli kupita utatala awu, lijuva dalitaywi chisi na mwesi dawumuliki ng'odu. ");
INSERT INTO ndj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ndondwa dasiponeki kufuma kumbindi, mawovi vaveli kumbindi davatikanyiki. ");
INSERT INTO ndj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Apa dawoneki Mwana wa Mundu payisa mumafundi kwa liwovi likomi na ukomi waki. ");
INSERT INTO ndj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pambeli davalayi makungu vaki vavakungashi avashawulili kufuma mbembu shosi mchechi sha mlima, kufumila mwambu mbaka mwambu wingi. ");
INSERT INTO ndj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kwa likuyu mwiwuli chilangushilu achi. Pamuwona mahamba vaki vakukanda kuva mateki na kutomola vengi, mumanyi chipindi cha ndonya chiva pabehi. ");
INSERT INTO ndj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yumwi wuwowu pamuwona findu afi pafigoleka, mumanyi kucha chipindi chiva pabehi nendu. ");
INSERT INTO ndj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nguvawombela nakaka, chileli achi dachipiti ha ngajila tanila findu afi fyosi kuwoneka. ");
INSERT INTO ndj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kumbindi na mlima dafipiti, lakini chilongu chanenga dachipiti ng'odu. ");
INSERT INTO ndj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Lakini lijuva na saa liki kwahela mundu amanyili, wala makungu va kumbindi, wala Mwana, ila Tati weka yaki kamanya. ");
INSERT INTO ndj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Muvi na chigoyi na muyikali mesu, nongwa chipindi achi mumanya ha pandili dachiyisi. ");
INSERT INTO ndj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dayivi kucha mundu yawuka kayaki kuyenda mwanja, kavalekela ndumindumi vaki ukomi, kila mundu na chichuku chaki, kamuwombela machonda wa kumlyangu ayikali mesu. ");
INSERT INTO ndj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Topi mgungi mesu, nongwa mumanya ng'odu mwenikaya akuwuya ndili, pamonga dayivi palumihi awu pamandandu awu putiputi awu pamalavila. ");
INSERT INTO ndj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mgungi mesu kucha payisa tepu akotoo kuvawona muvasha. ");
INSERT INTO ndj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nguvawombela yumwi, nguvawombela vosi: Mgungi mesu!” ");
INSERT INTO ndj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yavelili vasighala majuva mavili hela kufika lihungu lya Pasaka na lihungu lya mibumunda yingali simika. Vatambika vakomi na vawula va Malawu vaveli vakusaka ndambu ya kumkamula Yesu kwa chifisu, ili vamuwulayi. ");
INSERT INTO ndj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Vawombili, “Tukotoo kumkamula chipindi cha lihungu, vandu vakotoo kuyisa kugola ndilingu.” ");
INSERT INTO ndj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu paghaveyi Betaniya, kayaki Simoni dayili atamikili ukalava. Paghaveyi vakulya, mau yumoyu avelili na supa ya mafuta ya kunungilila na vatalama nendu kayisa, kadiwula supa yila na kumyitila Yesu mafuta vala kumutwi. ");
INSERT INTO ndj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Vandu vamu vaveli pala vakalalili, vadeta, “Nongwa liki akuyananga hela mafuta vala? ");
INSERT INTO ndj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Angaweshili kuhemesha kwa mbiya siwesha kumuhomba mgola chichuku kwa mwaka wumu awu mbiya ya dinali mya tatu. Na mbiya sila vangavapili vagayu!” Pambeli vamlakalila mau yula. ");
INSERT INTO ndj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lakini Yesu avawombilili, “Mumleki kwanongwa liki mukumuyasha? Kagolela chindu cha nyanyi. ");
INSERT INTO ndj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vagaju muva pamu majuva vosi. Mukuwesha kuvatanga lakini dandivi pamu na yumwi majuva vosi ng'odu. ");
INSERT INTO ndj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mau ayu kagola chaweshili. Kayitilila mafuta mumvili wangu, wuva kala kwa kusikiwa. ");
INSERT INTO ndj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nguvawombela nakaka, kumlima wosi Chilongu cha Nyanyi dachilanduliwi, chindu achi chagolili davachitambuli kwa ngumbungumbu yaki.” ");
INSERT INTO ndj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pambeli Yudasi Sikaliyoti, yumu wa vala lilongu na vavili, ayendili kwa vatambika vakomi ili kumshengeta Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Vatambika vakomi pavapikanishili afi, vasekelela, vajangili kumgayila mbiya. Topi Yuda akasakeyi fwasi nofu ya kumshengeta. ");
INSERT INTO ndj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lijuva lya kwaa lya lihungu lya mibumunda yingajila kutayiwa simika, chipindi vakuhinja mwana meni wa Pasaka, vanachuli vaki vamdashili, “Ukudayila kulila koti lihugu lya Pasaka?” ");
INSERT INTO ndj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Topi Yesu avalayishili vanachuli vaki vavili kavawombela, “Muyendi kumbwani na aku damutang'aniki na mlumi yumu kayitwika chiyungu cha machi. Mumukovikeli ");
INSERT INTO ndj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka munyumba dayingili, mkamuwombeli muna nyumba, ‘Muwula akudasha, chiva koti chumbagati changu dandilyi lihungu pamu na vanachuli vangu?’ ");
INSERT INTO ndj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mweni davalangushi chumba chikomi kudali chiveli chilembiwa kala muyingili amu.” ");
INSERT INTO ndj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Vanachuli vawuka, vayenda kumbwani, vawona kila chindu chilingana kucha Yesu avawombilili vatandi Lihungu. ");
INSERT INTO ndj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Payifikili palumihi, Yesu afikili pamu va vanachuli vaki lilongu na vavili. ");
INSERT INTO ndj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pavaveghi pamesa vakulya, Yesu kavawombela, “Nakaka nguvawombela, muyenu yumu ya ghalya pamu na nenga, dashengeti.” ");
INSERT INTO ndj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pala vanachuli vaki vakanda kuwona lusungu, vamudasha yumu yumu, “Wuli nengapa?” ");
INSERT INTO ndj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu kavawombela, “Yumu wa yumwi lilongu na vavili, yalikishila libumunda pamu na nenga muchimbundi. ");
INSERT INTO ndj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nakaka Mwana wa Mundu akuyenda kucha Mayandiku yivawomba. Lakini daachiwoni mundu yula damshengeti Mwana wa Mundu! Ingavelili ngiba mundu ayu kucha angawonikili ng'odu!” ");
INSERT INTO ndj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pavaveghi vakulya, Yesu katola libumunda, kamlumba Chapanga kalimetula na kuvagayila vanachuli vaki padeta, “Mtoli, awu mvili wa nenga.” ");
INSERT INTO ndj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kandi atolili lwindi, Kamulumba Chapanga, kavagayila, vosi valandila lwindi lula. ");
INSERT INTO ndj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Avawombilili, mwasi awu ukuyitika kwa vandu vatangalili. “Awu mwasi wa nenga kucha paveli mulilaghanu na Chapanga, ");
INSERT INTO ndj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nakaka nguvawombela, danandi kandi ng'odu difwayi mbaka lijuva lila danandi difwayi ya shonu muutwa wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kandi vasomulili lumbombu, vawuka, vayendili kuchidunda cha miseituni. ");
INSERT INTO ndj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu avawombilili vanachuli vaki, “Mwavosi damuvi na lyogha na nenga, nongwa Mayandiku Vang'alili vadeta, Chapanga damtovi mdima na vameni davamwayiki pwilili. ");
INSERT INTO ndj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lakini pashukuka, dandivalonguleli kula Galilaya.” ");
INSERT INTO ndj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petili amuwombilili, “Mani kucha vosi davakuleki, nenga danikuleki ng'odu!” ");
INSERT INTO ndj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu amuwombilili Petili, “Nakaka nguvawombela, pamihi pamu, njowolu akali hela kuvika mwanja wa pili, daunemi myanja mitatu.” ");
INSERT INTO ndj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lakini Petili kamuwombela, “Hata sovi pamu na yuwi, danikuleki ng'odu.” Vanachuli vosi vadeta wuwula. ");
INSERT INTO ndj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Topi vafikili aku kuvakema Getisemani. Yesu avawombilili vanachuli vaki, “Muyikali apa chipindi nenga padadava.” 14:32Getisemani, mana yaki: Chitava chidokwa. ");
INSERT INTO ndj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pambeli avatolili Petili na Yakobi na Yohani, akandili kuyipwelesha nendu na kushushutika. ");
INSERT INTO ndj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Avawombilili, “Nguwona lung'ongu lukomi mundima kucha dasovi. Muyikali apa na mugungi mesu.” ");
INSERT INTO ndj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ayendili paulongolu padokwa, kayiyasilila pasi wuyifuma, kadadava naha, kucha payiweshikana unewushi payifika saa yila ya kugoboka. ");
INSERT INTO ndj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kadeta, “Aba, Tati wangu, kwa yuwi findu fyosi fikuweshikana ung'ushili lwindi alu, ila yikotoo kuva kucha padayilili nenga, ila ngimu wudayilili yuwi.” ");
INSERT INTO ndj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu awuyili kwa vanachuli vaki vatatu, avawonili vawonja. Topi amuwombilili Petili, “Simoni, wuli, ukuwonja? Kulemwa kugunga mesu hata saa yimu?” ");
INSERT INTO ndj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Akavawombilili kandi, “Mgungi mesu na kudadava ili mukotoo kuyingila mumutambu wa kuyeshiwa. Mfuki yikudayila lakini mvili ukulemwa.” ");
INSERT INTO ndj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ayendili kandi kudadava akawuyilileyi filongu fifila fila. ");
INSERT INTO ndj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kawuya kandi, avawonili vawonja. Kwanongwa mesu vawu vatopiliwa na ng'onju. Valemwili cha kumyangula. ");
INSERT INTO ndj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Payisili mwanja wa tatu avawombilili, “Mukali muwonja na kupumulila? Ponopa saa yifika! Mwana wa Mundu vakumtawula kwa vandu vavipili. ");
INSERT INTO ndj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Muyimuki, tuyendi. Mloli, yula dashengeti kava pabehi.” ");
INSERT INTO ndj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu paghaveyi akali akudeta, Yudasi, muyawu wa vala lilongu na vavili, afikili na lipinga lya vandu vaveli na mimayi na fimbongu. Vandu ava vaveli valayishwa na vatambika vakomi na vawula va Malawu na vavaha. ");
INSERT INTO ndj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda avelili kavakupisha: “Yula yinumjambusha na danimunoneli ndi mweni, mumuvakuli na mumuyeghi na mumdimi nendu mumawoku va machonda.” ");
INSERT INTO ndj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda pafikili hela, kamyendela Yesu, kamuwombela, “Muwula!” kumunonela. ");
INSERT INTO ndj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Topi vala vandu vayisa kumuvakula Yesu, vamuwopa. ");
INSERT INTO ndj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yumu va vala vavelili vawoloka pamu na Yesu, akwemulili limayi lyaki, kamuhenga lijeji ndumindumi wa mtambika mkomi. ");
INSERT INTO ndj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu amuwombilili, “Wuli, muyisa na mimayi na fimbongu kungamula, kucha nenga mwifi? ");
INSERT INTO ndj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Majuva vosi naveli pamu na yumwi pang'ula munyumba ya Chapanga, mbona mwangamulili ng'odu. Lakini ponopa mayandiku mang'alili vavi.” ");
INSERT INTO ndj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Apa vanachuli, vatuvili vosi vamleka. ");
INSERT INTO ndj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwavelili na msongolu yumu avelili akumkovekela Yesu kunu kayitanda yingwa ya chikoyi. Veni vayeshili kumkamula. ");
INSERT INTO ndj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Lakini mweni kasulubuka, kayileka yila yingwa, katuva chipula. ");
INSERT INTO ndj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Topi vamyeghili Yesu kwa mtambika mkomi na vatambika vamonga na vavaha na vawula va Malawu vosi vatanganikili. ");
INSERT INTO ndj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petili amkovikelili Yesu kwa kutali, vayingilili mgati ya luviwu lwa mtambika mkomi, ayikalili pamu na vadima vakayoteyi motu. ");
INSERT INTO ndj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Vatambika vakomi na balasa lyosi lya Vayawudi vakasakeyi utovileli kwilata Yesu ili vamuhighi na kumuwulagha, lakini vapatili ng'odu. ");
INSERT INTO ndj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vandu vatangalili vamtovilelili udesi kwa Yesu, lakini utoveleli wau valinganili ha. ");
INSERT INTO ndj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vamonga vawoloka kandi kumtovelela udesi, vakawombaneyi: ");
INSERT INTO ndj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yufwi twampikanishili mundu ayu padeta, ‘Dabomoli ayi nyumba ya Chapanga yivajengili kwa mawoku, kwa majuva matatu dajengi yingi yingajila kujengiwa kwa mawoku.’ ” ");
INSERT INTO ndj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hata naha, utovileli wau walinganili ng'odu. ");
INSERT INTO ndj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Topi mtambika mkomi awolukili pagati ya vandu. Amdashili Yesu, “Wuli, ukuyangula ng'odu filongu? Vandu ava vakuhimulila liki fikuyilatili yuwi?” ");
INSERT INTO ndj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lakini Yesu anyamalili, ayangulili hata chilongu chimu ha. Mtambika mkomi amdashili kandi, “Wuli yuwi kuva Kilistu, Mwana wa Chapanga ayu yivamjuma?” ");
INSERT INTO ndj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ayangulili, “Yina, nenga mweni. Kandi damung'oni Mwana wa Mundu kayikala mwambu wa mlilu wa Bambu yaveli na liwovi na payisa mumafundi va kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pala mtambika mkomi kademula lihabiti lyaki, kawomba, “Vatovilela va liki kandi? ");
INSERT INTO ndj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mupikanisha, akumujowola Chapanga! Yumwi mukucha wuliwuli?” Vosi vamuhigha Yesu awulayiwi. ");
INSERT INTO ndj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Topi vamonga vakandili kumtemela mita, vamgubika kuwushu, vamtovanga na kumuwombela, “Tungi ghani kakutova!” Mbaka vandumindumi vamtola na kumtova mbandi. ");
INSERT INTO ndj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petili aveli akali pasi ya luviwu, ndumindumi yumu mdala wa mtambika mkomi kayisa. ");
INSERT INTO ndj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pamuwonili Petili payota motu, kamlola! kamuwombela, “Hata yuwi waveli pamu na Yesu wa Nasaleti.” ");
INSERT INTO ndj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lakini Petili akanili, kawomba, “Nimumanya ha, wala nguchimanya ng'o chimuwomba!” Pambeli Petili awukili kayenda panji ya luviwu. Pala njowolu kavika. ");
INSERT INTO ndj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yula ndumindumi pamuwonili kandi Petili, akandili kandi kuvawombela vandu vawolukili pala, “Mundu ayu muyawu.” ");
INSERT INTO ndj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petili akanili kandi. Pambeli padokwa, vandu vawolukili pala vamuwombilili Petili, “Nakaka yuwi ndi muyawu, nongwa yuwi kuva Mugalilaya.” ");
INSERT INTO ndj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lakini Petili akandili kwihongola na kuyilapa padeteyi, “Nenga nimumanya ng'odu mundu ayu yimuwomba womba filongu fyaki.” ");
INSERT INTO ndj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bahala pala njowolu kavika mwanja wa pili. Topi Petili kakumbuka ndambu Yesu amuwombilili, “Njowolu akali kuvika mwanja wa pili, daunemi myanja mitatu.” Petili alilili. ");
INSERT INTO ndj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pamalavila puti, vatambika vakomi vatanganili pamu na vavaha na vawula va Malawu na vandu va balasa lyosi, vapatanili kumuyegha Yesu kuchitemela cha Pilatu. Vamuwopa na pingu, vamyegha na kumuhadisha kwa Pilatu. ");
INSERT INTO ndj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu kamdasha Yesu, “Wuli yuwi kuva mutwa wa Vayawudi?” Yesu kamyangula, “Yina, yiva ngimu wudetili.” ");
INSERT INTO ndj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Vatambika vakomi vamuhigha Yesu kwa findu fitangalili. ");
INSERT INTO ndj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu kamdasha kandi Yesu, “Wuli ukuyangula chindu ng'odu? Pikanishi fyosi fivakutovelela yuwi!” ");
INSERT INTO ndj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lakini Yesu ayangulili chindu ha, Pilatu kayikanganika nendu. ");
INSERT INTO ndj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila lihungu lya Pasaka, Pilatu aveli na chishovi cha kumulekishela mundu yumu yaveli muchijaka, yivamdayilili vandu. ");
INSERT INTO ndj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chipindi achi, kwavelili na mundu yumu yakemiwa Balaba. Ayu aveli kawopiwa muchijaka pamu na vandu vamonga vawulayili vandu pakaveyi mundilingu. ");
INSERT INTO ndj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Vandu vatangalili vamyendela Pilatu na kumluva avagoleli kucha chishovi chaki. ");
INSERT INTO ndj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu kavadasha, “Wuli nivalekesheleli Mutwa wa Vayawudi?” ");
INSERT INTO ndj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatu awombili naha kwanongwa amanyili ngatu hela kucha vatambika vakomi vamyeghili Yesu kwa mweni kwanongwa vamuwonela weyi. ");
INSERT INTO ndj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lakini vatambika vakomi vavatumishila vandu vamluvi Pilatu avalekesheleli Balaba. ");
INSERT INTO ndj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatu avadashili kandi, “Ponopa mkudayila ndimgoli liki mundu ayu yumumkema Mutwa wa Vayawudi?” ");
INSERT INTO ndj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Vadeta kwa lishu likomi, “Mumvangilili mulupingika!” ");
INSERT INTO ndj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatu kavadasha, “Kagola chindu liki cha wafu?” Lakini veni vayendilela kudeta kwa lishu likomi, “Mumvangilili mulupingika!” ");
INSERT INTO ndj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu akadayileyi kulinowesha lila lipinga lya vandu, topi kavagayila Balaba kufuma muchijaka. Kalayishila Yesu alatuliwi fiboku, pambeli avangiliwi mulupingika. ");
INSERT INTO ndj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pambeli machonda vamuyeghili Yesu mgati ya liboma lya Pilatu mkomi wa mlima na vavakema vayawu vosi. ");
INSERT INTO ndj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Vamfwalishili yingwa ya langi ya sambalawu, vapota likokoma lya misomi na valivika kumutwi yaki. ");
INSERT INTO ndj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pambeli vakanda kumjambusha, “Hasi Mutwa wa Vayawudi!” ");
INSERT INTO ndj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Vayendelela kumtova kwa lidengi kumutwi na kumtemela mita. Pambeli vamtundamila na kumgondamila. ");
INSERT INTO ndj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pavamdanilili kala, vamuwopusolili lila lihabiti lya langi ya sambalawu, vamfwalisha yingwa shaki. Pambeli vamyegha panji ili vamvangilili mulupingika. ");
INSERT INTO ndj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pavaveghi munjila, vatanganikili na mundu yumu yakemiwa Simoni, mundu wa mlima wa Kileni, tati wawu Alekisanda na Lufu. Mundu ayu avelili akufuma kuchijiji, akuyenda kumbwani. Machonda vamung'ang'anika avagali lupingika lwa Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pambeli vamyegha Yesu mbaka mahali pakemiwa Goligota, mana yaki, “Mahali pa lipava lya mutwi.” ");
INSERT INTO ndj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Vamugayila difwayi yivahashili na mtela wuvakema manimani, lakini mweni kalema kuyilanda. ");
INSERT INTO ndj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pambeli vamvangilila mulupingika na vavaghana yingwa shaki kwa kugola do kulamula ghani apati yingwa liki. ");
INSERT INTO ndj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yavelili saa tatu pamalavila Yesu pavamvangilileyi mulupingika. ");
INSERT INTO ndj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Vayandika muchibawu fyavifyili naha: “Mutwa wa Vayawudi”. ");
INSERT INTO ndj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pambeli Yesu vamvangililili mulupingika pamu na vefi vavili, yumu mwambu waki wa mlilu na wingi mwambu waki wa kumkiyi. ");
INSERT INTO ndj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ndambu ayi, Mayandiku vava vadetili, “Avikiwili pamu na lipinga lya vandu vawafu.” ");
INSERT INTO ndj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vandu vavelili vakupita pala vatikanya mitwi yawu na kumjowola Yesu, pavadeta, “Aka! Yuwi muna uwesu wa kubowola nyumba ya Chapanga na kuyigola kwa majuva matatu! ");
INSERT INTO ndj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ponopa sunuki mulupingika na wilowoli umweni!” ");
INSERT INTO ndj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wuwula wula vatambika vakomi na vawula va Malawu vamdanila pavadeta veni kwa veni, “Avalowulili vamonga, lakini kalemwa kuyilowola mweni! ");
INSERT INTO ndj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ayu Kilistu, mutwa va Isilaeli! Topi asunuki kufuma mulupingika na yufwi datumjumili!” Na hata vandu vala vavangiliwi mumipingika pamu na mweni vamjowulili. ");
INSERT INTO ndj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kufumila saa sita pamusi, mlima wonda ugubikiwili na chisi chayikalili mbaka saa tisa. ");
INSERT INTO ndj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Payifikili saa tisa pamusi, Yesu kalila kwa lishu likomi, “Eloi, Eloi, lama Sabakitani?” Mana yaki, “Chapanga wangu, Chapanga wangu, mbona kuneka?” ");
INSERT INTO ndj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Vandu vamonga vawolukili pala pavapikanishili naha, vadeta, “Pikanishi, akumkema Eliya!” ");
INSERT INTO ndj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mundu yumu katuva, kajabika lindelindeli musiki, kalisobeka muludengi na kumupa Yesu alandi. Pambeli kadeta, “Leki tuloli kucha Eliya dayisi kumsunusha mulupingika!” ");
INSERT INTO ndj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu kawuta kwa lishu likomi, pambeli kasova. ");
INSERT INTO ndj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lupayi lwa nyumba ya Chapanga lwademukili filepa fivili kufumila kumbindi mbaka pasi. ");
INSERT INTO ndj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na mkomi va machonda yavelili kawoloka paulongolu pa lupingika pawonili ndambu Yesu pasovili, kadeta, “Nakaka mundu ayu avelili Mwana wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kwavelili na vadadala vamonga vavelili pavalola kwa kutali. Vamu vaveli Maliya Magadalena na Maliya mawu wawu akina Yakobi mdokwa na Yose na Salomi. ");
INSERT INTO ndj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesu paghaveyi Galilaya, vadadala ava vamkovikelili na kumtanga. Wuwowu vadadala vamonga vatangalili yivayisili pamu na mweni Yelusalemu vaveli bahala. ");
INSERT INTO ndj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yaveli palumihi ya Lijuva lya Kuyitalisha kwa Lijuva lya Kupumulila. ");
INSERT INTO ndj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosefu mwenikaya wa Alimataya, mundu wa balasa lya Vayawudi na yapikanishiwili nendu kafika. Mundu ayu aveli akuuvetela Wutwa wa kumbindi kwa Chapanga. Topi kamyendela Pilatu ngajila kukangajila, kamluva amupi chikongu cha Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatu kayikanganika papikanishili kucha Yesu aveli kasova kala. Topi kamkema mkomi wa machonda, kamdasha kucha Yesu kasova kala. ");
INSERT INTO ndj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pawombiwili na yula mkomi wa machonda Yesu kasova kala, amjumishili Yosefu atoli chikongu cha Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosefu kahemela ligubiku, kasunusha chikongu cha Yesu na kaushengiteshela ligubiku kauvika musembi yisonguliwili muligangachuma. Pambeli kabilibisha ligangachuma likomi pamlyangu ya sembi. ");
INSERT INTO ndj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya Magadalena na Maliya mau waki Yose vapawonili pala pavikiwili chikongu cha Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lijuva lya Kupumulila palipelili, Maliya Magadalena na Maliya mau waki Yakobi na Salomi vahemela mafuta va kunungilila ili vakaushaghi mvili wa Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Topi lijuva lya kupumulila lijuva palisosomokeyi, vayenda kusembi. ");
INSERT INTO ndj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pavaveghi mudeha, vakawombaneyi, “Ndi datubilibishili lila ligangachuma likomi pamlyangu wa sembi?” ");
INSERT INTO ndj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lakini pavalolili, valiwona ligangachuma lila likomi libilibishiwa kala. ");
INSERT INTO ndj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Topi vayingila musembi, vamuwona mundu yafwalili yingwa yiveli mbuleteee, kayikala kumlilu. Chivakola chipwembwi. ");
INSERT INTO ndj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mundu yula kavawombela, “Mkotoo kutila, manya mukumsaka Yesu wa Nasaleti yavangiliwili mulupingika. Kava baha ng'odu, kashukuka! Mloli mahali pavamvikili. ");
INSERT INTO ndj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ponopa muyendi mukavawombeli vanachuli vaki pamu na Petili kucha, ‘Yesu akuvalongulela Galilaya. Aku damumuwoni kucha pavawombilili.’ ” ");
INSERT INTO ndj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Topi, vafuma kula kusembi luvilu, kunu pavabagama na kuyikang'anika. Vamuwombela ha mundu yoyosi chindu achi kwanongwa vatilili munu. ");
INSERT INTO ndj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu pashukukili lijuva lya kupumulila pamalavila puti, amfumbukilili tanila Maliya Magadalena, yula yafumishiwili finyamkela saba na Yesu. ");
INSERT INTO ndj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mweni kayenda kuvawombela vala vavelili pamu na Yesu na chipindi achi vavelili vakali pavalila na kudadava. ");
INSERT INTO ndj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lakini pavapikanishili kucha Yesu kashukuka na Maliya Magadalena kamuwona, vajumilili ng'odu. ");
INSERT INTO ndj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pambeli Yesu avafumbukilili vanachuli vaki vavili kwa ndambu yingi. Vanachuli ava vaveli vakuyenda kufijiji. ");
INSERT INTO ndj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na veni vawuya na kuvawombela vayawu. Lakini vayawu wuwula vajumila ng'odu. ");
INSERT INTO ndj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pambeli Yesu kavafumbukila vanachuli vaki lilongu na yumu pavaveghi vakulya. Kavalakalila kwanongwa vaveli vahela ujumilwa na wuwula kwanongwa ndima shawu vawu shadindalili kuvajumila vandu vala vamuwonili pashukukili. ");
INSERT INTO ndj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kavawombela, “Muyendi kumlima wosi mukalanduli Chilongu cha Nyanyi kwa kila mundu. ");
INSERT INTO ndj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mundu yoyosi yajumila na kabatishiwa, dalowuliwi, lakini mundu yoyosi yangajila kujumila, dahighiwi. ");
INSERT INTO ndj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na filangushilu afi dafivi pamu na vala vajumila, Kwa litawa lyangu davafumishi finyamkela na davadeti kwa ng'ombelu ya shonu. ");
INSERT INTO ndj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pavakamula njoka awu pavalanda chindu chiveli na sumu, dachivagoli chindu ng'odu. Davaviki mawoku vawu kumbindi ya vatami na veni davanani.” ");
INSERT INTO ndj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bambu Yesu pamalilili kudeta na vanachuli vaki, katoliwa kumbindi kwa Chapanga na kayikala mwambu wa mlilu wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pambeli vanachuli vayenda kila mahali kulandula Chilongu cha Nyanyi. Bambu agolili pamu na veni na alangushili kucha milandu yawu yaveli nakaka kwa filangushilu fiyikolili nawu.");
INSERT INTO ndj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mkomi Teofili, Vandu vatangalili vayesha fivaweshili kuyandika findu yifibwitukili pagati ya yufwi. ");
INSERT INTO ndj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yivayandikili vatuwombilili na vafitovilela findu afi kukandila pafikandilili na vandumindumi va Chilongu cha Nyanyi. ");
INSERT INTO ndj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Topi, mkomi Teofili, kwanongwa nembesha findu afi kwa chiganu kukandila pafikandili, ng'ona nyanyi nguyandikili kwa fisingu findu afi yifibwitukili. ");
INSERT INTO ndj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ili muweshi kumanya nakaka kwilata findu fila fimuwuliwili. ");
INSERT INTO ndj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Majuva vala Helodi paghaveyi mutwa wa Uyawudi, kwaveli na mtambika yumoyu, litawa lyaki Sakaliya, wa chipinga cha vatambika cha Abiya. Mdamundu afumili mulukolu lwa Haluni, litawa lyaki Elisabeti. ");
INSERT INTO ndj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vosi vavili vaveli vanyanyi na vagolili findu fimunowishili Chapanga kwa kukamula Malawu vosi va Bambu. ");
INSERT INTO ndj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Vaveli na mwana ha, kwanongwa Elisabeti aveli muwumba. Vosi vavili vaveli vagogolu munu. ");
INSERT INTO ndj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lijuva limu, Sakaliya aveli akugola chichuku chaki cha kutambika munyumba ya Chapanga, kucha chishovi chaki chipindi cha kuyanga chichuku chaki. ");
INSERT INTO ndj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kucha pachiveli chishovi cha vatambika, do yamponikilili Sakaliya kuyenda munyumba ya Bambu kututumisha ubani, topi kayingila. ");
INSERT INTO ndj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chipindi patutumisheyi ubani, vandu vosi vaveli panji pavamdadavili Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Makungu wa Bambu kamubwitukila, kawoloka mwambu wa mlilu wa pala pa fyalu vya kututumishila ubani. ");
INSERT INTO ndj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaliya pamwonili makungu kasisima, chipwembu chimwingila. ");
INSERT INTO ndj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lakini makungu kamuwombela, “Kotoo kutila Sakaliya! Chapanga kapikanila kudadava kwaku. Mdawaku Elisabeti dakuleleli mwana mlumi na yuwi dawumukemi litawa lyaki Yohani mbatisha. ");
INSERT INTO ndj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na yuwi dawuvi na seku nendu na dausekeleli na vandu vatangalili davavi na seku kwa kuwoneka kwaki! ");
INSERT INTO ndj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kwa hoshu sha Bambu daghavi mundu mkomi. Dalandi ha difwayi wala chindu chochosi cha kulovela. Mfuki Mng'alili damumemi kufuma munda ya mamundu. ");
INSERT INTO ndj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mweni davajoveshi vandu vatangalili va Isilaeli na Bambu wawu Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Damuwombeli Bambu, kandi daghavi na mfuki na liwovi kucha Eliya mbuyi wa Chapanga. Davajoveshi pamu kandi vatati na vana, davawuyishi vandu vaveli na lukilu vavi na hoshu sha nyanyi kucha vandu vampikanisha Chapanga, davagoli vandu vayitandili kumuyanga Bambu.” ");
INSERT INTO ndj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaliya amudashili makungu, “Dandivi na chiganu liki kwa afi? Nenga gogola nahau na mdala wangu kagogola.” ");
INSERT INTO ndj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Makungu kayangula, “Nenga Gabulieli ndumindumi wa Chapanga, ndi yandumili nyisi kavawombela achi chilongu cha nyanyi. ");
INSERT INTO ndj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kujumila ng'odu filongu fyangu, ponopa dawuvi ngadeta, mbaka lijuva lila afi dafigoleki na dafibwituki kwa chipindi chaki.” ");
INSERT INTO ndj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na vandu vala vamvetileyi Sakaliya vakayikang'anikeyi, “Mbona kayikala nendu mula munyumba ya Chapanga?” ");
INSERT INTO ndj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pafumili panji kalemwa kudeta nawu vandu vala, akalangusheyi kwa mawoku hela na vandu vakacheyi Chapanga kamlangusha chindu paghaveyi munyumba ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chipindi cha kuyanga kugola chichuku cha kunyumba ya Chapanga payipelili, kawuya kayaki. ");
INSERT INTO ndj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pambeli Elisabeti mdala wa Sakaliya kapata yinda ayikalili pakaya myesi muhanu, kayidetela, ");
INSERT INTO ndj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ponopa Bambu kang'onela lusungu, kang'ushila soni shangu kwa vandu.” ");
INSERT INTO ndj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mwesi wa sita wa yinda ya Elisabeti, Chapanga kamulayisha Gabulieli makungu ayendi Nasaleti mumbwani ya Galilaya. ");
INSERT INTO ndj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Avelili na filongu fya kumuwombela mdadala muyenji litawa lyaki Maliya, nondi ya Yosefu, wa lukolu lwa Mutwa Dawudi. ");
INSERT INTO ndj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Makungu kamuyendela na kumujambusha, “Hawije! Bambu kava na yuwi, kakugayila usangi!” ");
INSERT INTO ndj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya papikanishili filongu fya makungu kasisima munu kayihola, “Filongu afi fina mana liki?” ");
INSERT INTO ndj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Makungu kamuwombela, “Kotoo kutila Maliya, Chapanga kakugayila usangi. ");
INSERT INTO ndj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Daumleli mwana mlulumi na yuwi dawumkemi litawa lyaki Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mweni daghavi mkomi na dakemiwi mwana wa Chapanga Mkomi, Bambu Chapanga damugoli ghavi Mutwa kucha Dawudi mbuyi mundu. ");
INSERT INTO ndj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Daghavi mutwa wa lukolu lwa Yakobi jola na wutwa waki daupeli ng'odu!” ");
INSERT INTO ndj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliya amdashili makungu, “Milandu ayi dayivi wuliwuli, kunu nenga ngalihela kutang'ana na mlumi?” ");
INSERT INTO ndj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Makungu kamuyangula, “Mfuki Mng'alili dakusunukili na liwovi lya Chapanga mkomi dalikugubiki kucha lisisi, ponopa mwana ang'alili dawoneki dakemiwi, mwana wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Loli, hata Elisabeti mlongu waku vandu vadetili aweshi ha kulela, ponopa kana yinda ya myesi sita na mweni mgogolu nawula. ");
INSERT INTO ndj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwa hela chindu Chapanga chalemwa.” ");
INSERT INTO ndj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliya kayangula, “Nenga ndumindumi wa Bambu, chigoleki kwa nenga nga wudetili.” Pambeli yula makungu kawuka. ");
INSERT INTO ndj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Majuva vavala vala, Maliya kawopa mwanja kalopokesha mbaka luvagha lumolu luvelili kufidunda fya Yudeya, ");
INSERT INTO ndj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","aku ayingilili munyumba ya Sakaliya na kumujambusha Elisabeti. ");
INSERT INTO ndj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeti papikanishili jambushilu ya Maliya, mwana chali ajumbili mumunda yaki. Elisabeti amemili Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabeti kadeta kwa lishu likomi, kunemeliwa kupita vadala vosi na mwana dawumleli kanemiliwa. ");
INSERT INTO ndj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nengapa ghani mbaka mawu waki Bambu wangu kayisa kundyangila kayangu? ");
INSERT INTO ndj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ngukuwombela, pambikanishili paudeta, mwana chali mumunda yangu kalilimuka kwa seku. ");
INSERT INTO ndj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nakaka kunemeliwa kwanongwa kujumila fila Bambu fyakuwombilili dafigoleki. ");
INSERT INTO ndj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliya kadeta, “Ndima yangu yikumjuma Chapanga, ");
INSERT INTO ndj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mundima yangu mukusekelela kwanongwa ya Chapanga mlowola wa nenga. ");
INSERT INTO ndj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kang'onela lusungu nenga ndumindumi waki mshisha moyu, kufumila ponopa, vandu vosi davangemi muna seku. ");
INSERT INTO ndj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kwa nongwa Chapanga muna liwovi kagolela milandu mikomi, litawa lyaki ling'alili. ");
INSERT INTO ndj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Akuvalangushila vandu lusungu kufuma lukolu mbaka lukolu, kwa vandu yivamtila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kagola milandu mikomi kwa liwoku lyaki. Kavavinga vaveli na lukilu pamu na hoshu shawu. ");
INSERT INTO ndj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kavasunusha vatwa vaveli na liwovi mufigoda fyawu kavakwelesha vayidedikili. ");
INSERT INTO ndj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Vaveli na njala kavakutisha findu finofu, valundamali kavawusha mawoku hela. ");
INSERT INTO ndj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kamtanga Isilaeli ndumindumi waki, payihola lusungu lwaki, payihola lusungu lwaki, ");
INSERT INTO ndj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ngimu wavawombilili vavaha vetu Ibulahimu na fileli fyaki jola!” ");
INSERT INTO ndj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya ayikalili na Elisabeti kwa myesi mitatu, pambeli kawuya kaya yaki. ");
INSERT INTO ndj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chipindi cha kulela Elisabeti chafikili, kamlela mwana mlumi. ");
INSERT INTO ndj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Vajofi na valongu mundu pavapikanishili kucha Chapanga kamulangusha lusungu lwaki lukomi, wosi vasekelela pamu na mweni. ");
INSERT INTO ndj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwana paghaveyi na lijuma limu, vayisa kumudumula jandu. Vakadayileyi kumkema Sakaliya, litawa lya tati mundu. ");
INSERT INTO ndj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kumbi mamundu adetili, “Ng'odu, litawa lyaki datumkemi Yohani mbatisha.” ");
INSERT INTO ndj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Vala vamuwombela, “Mbona kwahela mundu mulukolu lwenu yavelili na litawa ali?” ");
INSERT INTO ndj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Topi vamkupisha tati mundu, ili vamdashi akadayileyi mwana waki vamkemi litawa liki. ");
INSERT INTO ndj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mweni kavaluva chibawu ayandiki, kayandika naha, “Litawa lyaki Yohani mbatisha.” Vosi vayikanganika. ");
INSERT INTO ndj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bahala pala, mlomu na lulimi lwaki Sakaliya fifuwuka, kakanda kuywanga pamjuma Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lyogha livayingila vandu vosi va pabehi yaki milandu ayi yikwila kosi kula kufidunda fya Yudeya. ");
INSERT INTO ndj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vapikanishili milandu ayi, vayihola mundima shawu, pavadeta, “Mwana ayu daghavi mundu wa wuliwuli?” Kucha nakaka liwovi lya Bambu Chapanga naliva pamu na mweni. ");
INSERT INTO ndj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakaliya tati mundu Yohani kamema Mfuki Mng'alili, kadeta umbuyi awu kufuma kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Tumujumi Bambu, Chapanga wa Isilaeli loli kavayisila na kuvakombola vandu vaki. ");
INSERT INTO ndj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Katugayila wakutugombola yagangamalili, mulukolu lwa Dawudi ndumindumi waki. ");
INSERT INTO ndj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ajangili kukandila dahili kwa deha ya vambuyi vaki vang'alili. ");
INSERT INTO ndj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kucha akutugombola mumawoko va vachimdwama vetu na kufuma mumawoku va vosi yivavelili na maya na yufwi. ");
INSERT INTO ndj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Adetili davavawoneli lusungu vagogolu vetu na kulikumbuka lilaghanu lyaki ling'alili. ");
INSERT INTO ndj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","kwilapa kwayilapili kamwilapila Ibulahimu mbuyi wetu. ");
INSERT INTO ndj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kadeta, datugomboli mumawoku va vachimdwama vetu, tupati kumtundamila ngajila kuva na lyova. ");
INSERT INTO ndj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tuvi vang'alili na vandu goleki majuva vosi va kuyikala mumlima. ");
INSERT INTO ndj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Yuwi mwana wa nenga davakukemi, mbuyi wa Chapanga mkomi, dawumulonguleli Bambu Chapanga kumvendela deha yaki. ");
INSERT INTO ndj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dawuvawombeli vandu kucha davagombolewi kwa kuvawushila sambi shawu. ");
INSERT INTO ndj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chapanga wetu mshishamoyu na muna lusungu datumulikili na limbamba kufuma kumbindi kwa Chapanga, ");
INSERT INTO ndj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Davang'alikili vosi vayikala mulwisa totolu, ayongeshi mawulu vetu tuyifikili deha ya kusika.” ");
INSERT INTO ndj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana akulili, mvili na ndima. Ayikalili kuchivala mbaka lijuva payilangushili lipala kwa vandu va Isilaeli. ");
INSERT INTO ndj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Majuva vala Agustini Mutwa wa Loma alayishili vandu vosi va wutwa wa Loma vavalangiwi. ");
INSERT INTO ndj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ayi yaveli mwanja mtasi kwa vandu kuvalangiwa chipindi Koneli paghaveyi mkomi wa mlima wa Siliya. ");
INSERT INTO ndj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndamboyi vandu vonda vayendili kuyandikisha matawa vawu, kila mundu kayaki. ");
INSERT INTO ndj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefu kafuma mbwani ya Nasaleti, kumlima wa Galilaya, kayenda mbwani ya Betelehemu, kumlima wa Yudeya, pawonikilili mutwa Dawudi. Yosefu ayendili kula kwanongwa mweni aveli wa mulukolu lwa Dawudi. ");
INSERT INTO ndj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ayendili kuyandikiwa pamu na nondi waki Maliya, yavelili kana suliya. ");
INSERT INTO ndj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Maliya paghaveyi kula, lijuva lyaki lya kwiwopola lyafikili. ");
INSERT INTO ndj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kayihongesha mwana soli mlumi, kamfwalisha fisepi. Pambeli kamwonjesha muligeleli, mulibaku lya kulila vasenga, kwanongwa vapatili ha libudi lya vahenja. ");
INSERT INTO ndj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mumlima wula kwaveli na vadima vasenga vayikalili kuchivala pamihi pavadima vasenga vawu kwa lutonu. ");
INSERT INTO ndj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tepu, Makungu wa Bambu kavabwitukila, bwitu! Na ukomi wa Bambu wuvang'alikila mwambu wosi nawu vatila nendu. ");
INSERT INTO ndj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Makungu kavawombela, “Mkotoo kutila! Nguvayeghela filongu fya nyanyi na fya sekuseku kwa vandu vosi. ");
INSERT INTO ndj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nalelu muluvagha lwa Dawudi kawoneka mlowola kwanongwa yenu, ayu ndi Kilistu na Bambu. ");
INSERT INTO ndj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Achi dachivi chilangushilu, Damumuwoni mwana chali vamfwalisha fisepi, kawonjeshwa muligeleli, mulibaku lya kulila vasenga.” ");
INSERT INTO ndj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Teputepu lipinga likomi lya Makungu kufuma kumbindi kwa Chapanga vayihasha pamu na yula makungu, vamjuma Chapanga, vakadeteyi, ");
INSERT INTO ndj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ukomi kwa Chapanga yaveli kumbindi nendu, na kusika mumlima kwa vandu vala vamunowesha Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Vala makungu pavawukili kuwuya kumbindi kwa Chapanga, vadimasenga vawombana, “Tuyendi Betelehemu tukachiwoni chila chifumbukili, chila chatuwombilili Bambu.” ");
INSERT INTO ndj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Topi vayenda mbilu, vavawona Maliya na Yosefu na yula mwana chali kawonjeshwa mulibaku lya kulila vasenga. ");
INSERT INTO ndj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pavamuwonili yula mwana, vavawombela Maliya na Yosefu chila makungu chavawombilili kwanongwa ya mwana. ");
INSERT INTO ndj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Vosi yivapikanili filongu fila fivadetili vadimasenga, vayikanganikili nendu. ");
INSERT INTO ndj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maliya akumbukili filongu fyosi afi na kuyihola nendu mana yaki mumunda. ");
INSERT INTO ndj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Vala vadimasenga vawuya kuchivala, pavamukwisha na kumujuma Chapanga kwa findu fyosi fyavapikanilili na kufiwona, fyosi fyavelili kucha Makungu avawombilili. ");
INSERT INTO ndj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lyapitili lijuma limu, chipindi cha mwana kumwingisha jandu chafikili, vamkema litawa lyaki Yesu, litawa ali amupili makungu chipindi Maliya akalihela kuva na suliya. ");
INSERT INTO ndj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Majuva pavafikili va Yosefu na Maliya vadayiliwili kupugiwa ngimu Malawu va Chapanga vamupili Musa wuvadeta. Vamtola na mwana wawu vamyegha Yelusalemu, kumvika kwa Bambu Chapanga, ");
INSERT INTO ndj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","yiyandikiwa Mumalawu va Bambu, “Mwana yoyosi soli mlumi akudayiliwa atawuliwi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kandi vakayendili kula kuyegha litambiku lya vangunda vavili na myoni mivili ya vangulaku ngimu vadetili Mumalawu va Bambu. ");
INSERT INTO ndj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chipindi chila mumbwani ya Yelusalemu, avelili mundu yumu, litawa lyaki Simoni. Mundoyu aveli akumunowesha Chapanga, mweni aveli akuvetela ukombola wa Isilaeli. Mfuki Mng'alili aveli pamu na mweni. ");
INSERT INTO ndj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mfuki Mng'alili amulayilili, dasovi ng'odu mbaka ndimuwoni Kilistu, mkombola yashawuliwili na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mfuki Mng'alili kamlongosha Simoni kuyingila mungengileka ya Nyumba ya kudadavila. Maliya na Yosefu pavamyeghili mwana Yesu vamgoleli ngimu yiyandikilwi muchitabu cha Malawu va Chapanga vamupili Musa, ");
INSERT INTO ndj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni amuyangili Yesu mumawoku vaki na kumjuma Chapanga, padeta: ");
INSERT INTO ndj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ponopa Bambu yiva ngimu wudetili, uneki ndumindumi waku nzovi kwa kusika, ");
INSERT INTO ndj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","mesu vangu vawuwona ulowolu waku, ");
INSERT INTO ndj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wuwutandili paulongolu ya vandu vosi, ");
INSERT INTO ndj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Alu lwengi lwa kulangusha chiwudayila yuwi kwa vangajila kujumila na kuyegha ukomi kwa vandu vaku va Isilaeli.” ");
INSERT INTO ndj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tati na mamundu Yesu vavelili vakujingwa na filongu fyadetili Simoni fya mwana. ");
INSERT INTO ndj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoni kavanemela na kamuwombela Maliya, mamundu Yesu, “Mwana ayu kashawuliwa na Chapanga kuvawisha vandu vatangalili va Isilaeli na kuyegha ukombola wa vandu vatangalili va Isilaeli. Daghavi chilangushilu kufuma kwa Chapanga, ila vandu vatangalili davamlemi. ");
INSERT INTO ndj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na dayivi fyavayihola mundima sha vandu vatangalili dafigubutuliwi. Na wumweni, lihingili likali kucha chimayi dachisomi mundima yaku.” ");
INSERT INTO ndj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kwaveli na mbuyi yumu mdala, agogulili munu, litawa lyaki Ana biti Fanuweli, wa lukolu lwa Asheli. Mdala ayu ayikalili na bambu mundu kwa myaka saba kufumila pahetiwili. ");
INSERT INTO ndj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pambeli kayikala wungalimlyangu mbaka chipindi chila pavelili mgogolu wa myaka milongo minani na mchechi. Chipindi chosi ayikalili Munyumba ya Chapanga, payikaja kulya kunu padadava. ");
INSERT INTO ndj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Saa yiyila mdala yula kafumbuka, kamhongesha Chapanga na kuvawombela milandu ya mwana yula kwa vandu vosi vaveteleyi kukombuliwa kwa Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosefu pamu na Maliya pavamalishili kugola fyosi ngimu Malawu va Bambu wuvadeta, vawuya kayawu Nasaleti, mumlima wa Galilaya. ");
INSERT INTO ndj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana yula kakula, kayongesheka liwovi na kamema luhunja na usangi wa Chapanga yiva pamu na mweni. ");
INSERT INTO ndj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Valeli va Yesu vaveli na chishovi cha kuyenda Yelusalemu kila mwaka, chipindi cha lihungu lya Pasaka. ");
INSERT INTO ndj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu paghaveyi na myaka lilongu na mivili, vosi vayenda kulihungu lila lya Pasaka ngimu wuchivelili chishovi chawu. ");
INSERT INTO ndj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lihungu palipitili, vakanda kuwuya kayawu. Lakini msongolu Yesu asighalili Yelusalemu, ngajila kumanya valeli vaki, ");
INSERT INTO ndj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","vakacheyi kava mulipinga lya vandu, vayendayenda lijuva lyosi. Pambeli vakanda kumsaka kwa vajofi na vaghanja vawu. ");
INSERT INTO ndj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pavampotili kumuwona, vawuya Yelusalemu kumsaka. ");
INSERT INTO ndj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mulijuva lya tatu, vamuwona mungengileka ya Nyumba ya Chapanga, kayikala na vawula va Chiyawudi, pavapikanisha kunu akuvanasha minasha. ");
INSERT INTO ndj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Vosi yivamupikanishili vayikanganikili nendu luhala lwaki na nyangulilu yaki yaluhunja. ");
INSERT INTO ndj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Valeli vaki pavamuwonili, vajinga. Mau waki kamdasha, “Mwana wangu, wuli, ukutugolela liki nahawu? Nenga na tati waku tukakusakeyi kwa kuyifwasha.” ");
INSERT INTO ndj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu kavayangula, “Mukunzakila liki? Mukamanyeyi ng'odu kucha ngudayiliwa kuyikala munyumba ya Tati wangu?” ");
INSERT INTO ndj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lakini valeli vaki vamanya ha filongu fyavawombileyi. ");
INSERT INTO ndj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pambeli Yesu pamu na valeli vaki vawuya Nasaleti na mweni pavayitikila. Na mawu waki avikilili milandu yosi munda yaki. ");
INSERT INTO ndj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu kayendelela kukula mvili na luhunja na kwa kumunowesha Chapanga pamu na vandu wuwowu. ");
INSERT INTO ndj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mwaka wa lilongu na muhanu Mutwa Tibeliu patavaleyi, Ponsiu Pilatu paghavaya mtavala wa boma lya Yudeya. Helodi aveli mtavala wa Galilaya na mlongu mundu Filipu aveli akutavala mahali patavaleyi Ituleya na Talakoniti. Lusania aveli mtavala wa Abileni, ");
INSERT INTO ndj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa vaveli vagolafichuku wa vakomi va nyumba ya kudadavila, chipindi chila, filongu fya Chapanga pafimfikilili Yohani mbatisha mwana wa Sakaliya, kula kuchivala. ");
INSERT INTO ndj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Topi Yohani kayenda ngengeleka yosi ya lweni Yoludani. Kavawomba vandu vapomeli na kabatishiwa ili Chapanga avawushili sambi. ");
INSERT INTO ndj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Afi ndi fivayandikiwili muchitabu cha Isaya yaveli mbuyi wa Chapanga. “Mundu yumu akukema kucheja. ‘Mumtandili deha Bambu, na muhololi deha yaki. ");
INSERT INTO ndj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pa libosi mukulili, pa fidunda na midunda musengelemuli, njila sivelili na ngombu dasihololiwi. Deha sha wafu wafu dasigoleki nyanyi. ");
INSERT INTO ndj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Vandu vosi davamuwoni Chapanga akuvalowola vandu!’ ” ");
INSERT INTO ndj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lipinga lya vandu lyafikili kwa Yohani ili avabatishi, Yohani kavawombela, “Yumwi vana va njoka! Ghani kavapwepwela mtuvi maya va Chapanga davayisi ava? ");
INSERT INTO ndj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mlangushi kwa golelu kucha mupomela, mukotoo kukanda kuyiwombela mwaveni kucha, ‘Ibulahimu ndi tati wetu.’ Nguvawombela nakaka, Chapanga akuwesha kuyigola migonguveli ayi yivi vana va Ibulahimu. ");
INSERT INTO ndj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Livawu liva kala kudumula mikigha ya mibiki, ndamboyi kila libiki lingajila kuveleka fivelekwa fya nyanyi dalidumuliwi na kuliyasila mumotu.” ");
INSERT INTO ndj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lipinga lya vandu limdasha, “Ponopa yufwi tugoli liki?” ");
INSERT INTO ndj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kavayangula, “Yaveli na gwanda mbili yimu amupi yula yangajila gwanda, yavelili na filivi agoli ngawuwula.” ");
INSERT INTO ndj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Vala vasumula mbiya vayisa na veni vabatishiwa vamdasha, “Muwula, tugoli liki?” ");
INSERT INTO ndj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mweni kavawombela, “Mkotoo kusumula mbiya kujumba chigelu chila chivavikili.” ");
INSERT INTO ndj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Machonda wuwu vamdasha, “Na yufwi tugoli liki?” Kavayangula, “Mkotoo kutola findu fya mundu yoyosi kwa liwovi wala kumpayishila yoyosi. Mujakwi na ijala yenu.” ");
INSERT INTO ndj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Vandu vaveli vakushuvilila chindu chiutunga, vakanda kuyidasha mundima shawu chimwilatili Yohani mbatisha kucha mweni kava ndi Kilistu yashawuliwili na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Apa Yohani mbatisha kavawombela vosi, “Nenga nguvabatisha kwa machi, ila akwisa yaveli na liwovi pitu nenga, mweni nenga nguwesha ha hata kuwoposola ng'oyi sha mikobasi yaki, mweni davabatishi kwa Mfuki Mng'alili na kwa motu. ");
INSERT INTO ndj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mweni kana luselu mumawoku vaki na mweni dafyayili luvagha lwaki lwa kupetela mpunga dawuviki mulusanja myeyu danyanyi mumotu wa lifumbika.” ");
INSERT INTO ndj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa filongu kafwauti Yohani avalandulilili vandu chilongu cha nyanyi na kuvakayika vaghalambuli ngalilu shawu. ");
INSERT INTO ndj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohani amshoshili mutwa Helodi, yula yamtolili Helodiya mdala wa mlongu mundu, kwanongwa ya kumgola mdala mundu, pamu na findu fyosi fya wafu fyagolili. ");
INSERT INTO ndj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pambeli Helodi kagola chindu chawafu munu kumuwopa Yohani mbatisha muchijaka. ");
INSERT INTO ndj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Vandu vosi pavabatishiwili kala, Yesu na mweni kabatishiwa. Padadaveyi, kumbindi kwa Chapanga kufuwuka. ");
INSERT INTO ndj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na Mfuki Mng'alili kamsunukila kucha njiva. Pambeli lishu lipikanika kufuma kumbindi kwa Chapanga, “Yuwi mwana wangu yingutamili, mayiliwa na yuwi.” ");
INSERT INTO ndj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu pakandili chichuku chaki, aveli na myaka milongu mitatu, vandu vakacheyi mweni mwana wa Yosefu, mwisukulu wa Heli. ");
INSERT INTO ndj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli aveli mwana wa Matati na ayu aveli mwana wa Lawi na ayu aveli mwana wa Meliki na ayu aveli mwana wa Yanai na ayu aveli mwana wa Yosefu. ");
INSERT INTO ndj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefu aveli mwana wa Matatia na ayu aveli mwana wa Amosi na ayu aveli mwana wa Nahumu na ayu aveli mwana wa Hesili na ayu aveli mwana wa Nagai, ");
INSERT INTO ndj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","avelili mwana wa Mateyi na ayu aveli mwana wa Matatia na ayu aveli mwana wa Shefungami na ayu aveli mwana wa Yoseki na ayu aveli mwana wa Yuda, ");
INSERT INTO ndj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ayu aveli mwana wa Yohani, na ayu aveli mwana wa Lesi na ayu aveli mwana wa Zelubabeli na ayu aveli mwana wa shealitieli na ayu aveli mwana wa Neli, ");
INSERT INTO ndj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na ayu aveli mwana wa Meliki na ayu aveli mwana wa Adi na ayu aveli mwana wa Kosamu, avelili mwana wa Elimadamu na ayu aveli mwana wa Eli, ");
INSERT INTO ndj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na ayu avelili mwana wa Yoshua na ayu aveli mwana wa Eliezeli na ayu aveli mwana wa Yolimu na ayu aveli mwana wa Matati na ayu aveli Mwana wa Lawi, ");
INSERT INTO ndj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ayu avelili mwana wa Simoni na ayu aveli mwana wa Yuda na ayu aveli mwana wa Yosefu na ayu aveli mwana wa Yonamu na ayu aveli mwana wa Eliyakimu, ");
INSERT INTO ndj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ayu avelili mwana wa Melea na ayu aveli mwana wa Mena na ayu aveli Mwana wa Matata na ayu aveli mwana wa Natani na ayu aveli mwana wa Dawudi, ");
INSERT INTO ndj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ayu avelili mwana wa Yesi na ayu aveli mwana wa Obedi na ayu aveli mwana wa Boasi na ayu aveli mwana wa Solumoni na ayu aveli mwana wa Nashoni, ");
INSERT INTO ndj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ayu avelili mwana wa Aminadabu na ayu aveli mwana wa Adimini na ayu mwana wa Alini na ayu mwana wa Hesilomi na ayu aveli mwana wa Pelesi na ayu aveli mwana wa Yuda, ");
INSERT INTO ndj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ayu avelili mwana wa Yakobi na ayu aveli mwana wa Isaka na ayu aveli mwana wa Ibulahimu na ayu aveli mwana wa Tela na ayu aveli mwana wa Naholi, ");
INSERT INTO ndj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ayu avelili mwana wa Selugi na ayu aveli mwana wa Leu na ayu aveli mwana wa Pelegi na ayu aveli mwana wa Ebelina na ayu aveli mwana wa Sala, ");
INSERT INTO ndj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ayu avelili mwana wa Kainamu na ayu aveli mwana wa Alifakisadi na ayu aveli mwana wa Shemu na ayu aveli mwana wa Nuhu na ayu aveli mwana wa Lameki, ");
INSERT INTO ndj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ayu avelili mwana wa Metusela na ayu aveli mwana wa Inoki na ayu aveli mwana wa Yaledi na ayu aveli mwana wa Mahalaleli na ayu aveli Mwana wa Kainamu, ");
INSERT INTO ndj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ayu avelili mwana wa Enoshi na ayu aveli mwana wa Seti na ayu aveli mwana wa Adamu, aveli wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu kawuka lweni Yoludani amemili Mfuki Mng'alili, Mfuki Mng'alili kamlongosha kucheja. ");
INSERT INTO ndj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aku kayeshiwa na Lijangavandu kwa majuva milongu mchechi. Chipindi chila chosi, kalya chindu ha na pavapitili majuva vala njala yamtamili. ");
INSERT INTO ndj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Topi Mwafu kamuwombela, “Kucha yuwi kuva mwana wa Chapanga, uliwombeli ligonguveli ali livi libumunda.” ");
INSERT INTO ndj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu kamuyangula, “Mayandiku vakuwomba, ‘Mundu akwikala kwa kulya chilivi weka hela ha.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pambeli Lijangavandu kamtola mbaka pambindi, tepu kamulangusha wutwa shonda sha mumlima. ");
INSERT INTO ndj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lijangavandu kamuwombela, “Dandikugayili uwesu na ukomi muwutwa na findu afi fyosi, fyanyimbili na nenga nguwesha kumugayila mundu yoyosi yindimudayila. ");
INSERT INTO ndj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Afi fyosi dafivi fyaku, kucha pawundundamila nenga”. ");
INSERT INTO ndj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu kamuyangula, “Yiyandikiwa mumayandiku, ‘Umtundamili Chapanga waku na umkimbanikili mweni weka hela!’ ” ");
INSERT INTO ndj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lijangavandu kamtola Yesu mbaka Yelusalemu pambindi ya nyumba ya Chapanga na kamuwombela, “Kucha yuwi Mwana wa Chapanga, widangi pasi. ");
INSERT INTO ndj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Liyandikiwa, ‘Chapanga dalayilili makungu vaki vakuyangi.’ ");
INSERT INTO ndj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kandi, ‘Davakuyangi mumawoku vawu, ukotoo kuponikela mumigonguveli.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lakini Yesu kamuyangula, “Mayandiku vakudeta, ‘Kotoo kumuyesha Chapanga Bambu waku.’” ");
INSERT INTO ndj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Lijangavandu palimuyeshili kala kwa deha shosi pambeli limleka mbaka chipindi chijumiliwi pachifika. ");
INSERT INTO ndj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu kawuya Galilaya kufuma kucheja kamema liwovi lya Mfuki Mng'alili, milandu yaki yikwila mbembu shosi sha pabehi. ");
INSERT INTO ndj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mweni aveli akuwula munyumba sha kudadavila, pajumiwa na vandu vosi. ");
INSERT INTO ndj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Topi Yesu ayendili Nasaleti, pala pakulilili na Lijuva lya Kupumulila, ayingilili munyumba ya kudadavila kucha washovililili, awolukili kusoma filongu fya nyanyi kwa lishu likomi. ");
INSERT INTO ndj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kapokela chitabu cha mbuyi wa Chapanga Isaya, kagubutula na kapasoma pavayandikili: ");
INSERT INTO ndj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mfuki wa Bambu kava na nenga, kan'shagha mafuta. Nivayegheli vagaju filongu fya nyanyi. Kanayisha ndivalandulili vandu vakoliwili na Lijangavandu vapekesuki, na vangalimesu mesu valoli kandi, kanayisha nivagomboli vala vawopiwili vafuwuliwi, ");
INSERT INTO ndj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na kulandula chipindi chifika cha Chapanga kuvalowola vandu vaki.” ");
INSERT INTO ndj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu pasomili kala, achigubikili chila chitabu, kamgayila ndumindumi, pambeli kayikala pasi, vandu vosi yivavelili munyumba ya kudadavila vamfulutulila mesu. ");
INSERT INTO ndj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mweni kuvawombela, “Lyandiku ali nalelu liva ngimu wumupikanishili.” ");
INSERT INTO ndj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Vosi vanovelwa nendu na mweni, vakayikang'anikeyi filongu fya nyanyi fyadetili. Vadeta, “Ayu mwana wa Yosefu nda?” ");
INSERT INTO ndj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mweni kavawombela, “Nakaka damung'ombeli detelu ayi, ‘Mwilwana ayilowoli mweni.’ Na damdeti, ‘Fyosi fitupikinishili fiwugolili kula Kapelinaumu, ufigoli kandi apa paluvagha yaku.’ ");
INSERT INTO ndj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nguvawombela naha,” kayendelela kudeta, “Mbuyi akujumiliwa ng'odu pamulima waki. ");
INSERT INTO ndj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Mpikanishi! Nakaka pavavelili vangalimlyangu vatangalili mlima wa Isilaeli chipindi cha Eliya. Chipindi achi ndonya yalekili kutonya kwa myaka mitatu na myesi sita, kwavelili na njala ngomi mlima wosi. ");
INSERT INTO ndj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hata naha, Eliya kalayiliwa ng'odu kwa yoyosi yula, ila kwa mdala yaveli ngalimlyangu wa Salefati aku Sidoni. ");
INSERT INTO ndj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kandi, kumlima wa Isilaeli Chipindi cha Mbuyi wa Chapanga Elisha pavelili na vandu vatangalili vavelili na ukalava. Hata naha, kwa hela yoyosi vang'alili ila Namani mwenikaya wa mlima wa Siliya.” ");
INSERT INTO ndj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Vosi vavelili mula munyumba ya kudadavila pavapikanishili fila vakalalili munu. ");
INSERT INTO ndj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Vawoloka, vamfumisha panji ya mbwani yawu yivajengili kufidunda, vamyegha mbaka mungwaji ya chidunda achi ili vamdangili pasi. ");
INSERT INTO ndj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lakini Yesu kapita pagati yawu, kayenda. ");
INSERT INTO ndj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pambeli Yesu kayenda Kapelinaumu boma ya Galilaya, kavawula vandu Mulijuva lya Kupumulila. ");
INSERT INTO ndj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Vakayikang'anikeyi fyawuleyi nongwa akafundisheyi kwa uwesu. ");
INSERT INTO ndj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mula munyumba ya kudadavila mwavelili mundu yamkwelili chinyamkela akalalili, akawuteyi kwa lishu likomi, ");
INSERT INTO ndj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yayooo! Kuva na liki na yufwi, yuwi Yesu wa Nasaleti? Wuli kwisa kutumalila? Ngumanya yuwi kwa ghani, yuwi kuva Mng'alili wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu akumlakalila yula Chinyamkela, padeta, “Matu! Umfumi mundu ayu!” Chinyamkela yula amfumili pamuwishili mundu yula pasi, afumili ngajila kumugobola. ");
INSERT INTO ndj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vandu vosi vayikanganika vakawombaneyi veni, “Achi chindu liki chadeta? Nongwa kwa uwesu na liwovi, kavawombela finyamkela vafumi na veni vakufuma!” ");
INSERT INTO ndj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Milandu ya Yesu yipikanika mwambu wula wosi. ");
INSERT INTO ndj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu afumili mula munyumba ya kudadavila, kayenda kaya ya Simoni. Nafyala mundu Simoni, avelili na mususa, vamuluva amulowoli. ");
INSERT INTO ndj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu kayisa kawoloka pabehi yaki, kawulakalila msusa wula, weni wumleka. Mau yula bahala pala katandamuka kavakimbanikila. ");
INSERT INTO ndj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lijuva palidibeyi, vosi vakaveli na vatami vawu vavayeghili kwa mweni, akavavikilili mawoku vaki, kavalowola vosi. ");
INSERT INTO ndj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Finyamkela vakavafumili vandu vatangalili, vakawuteyi pavadeta, “Yuwi ndi mwana wa Chapanga!” Yesu kavalakalila finyamkela, wala kuvajumisha ng'odu kudeta, nongwa vamanyili aveli Kilistu. ");
INSERT INTO ndj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chilawu yaki pamalavila, Yesu awukili ayendili kuyififa. Vandu vaveli vakumsaka. Vandu vala pavafikili pavelili, vayeshili kumkanisha akotoo kuwuka. ");
INSERT INTO ndj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lakini mweni avawombilili, “Ngudayila kuvawombela Chilongu cha Nyanyi cha wutwa wa kumbindi kwa Chapanga milima yimonga wuwu, ndi Chapanga wanayishili kwanongwa ayi.” ");
INSERT INTO ndj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aveli akuvalandulila munyumba sha kudadavila shosi kula Yudeya. ");
INSERT INTO ndj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lijuva limu, Yesu aveli kawoloka muluwongu ya lihiva lya Genesaleti, vandu vatangalili vaveli vamushengitela na kuyikekeneka, vakupikanisha chilongu cha Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kavawona matu mavili mung'emula ya lihiva. Valovi veni vajabukili, vakusambula njafu shawu. ");
INSERT INTO ndj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Payingilili muwatu wumu wa Simoni, Yesu akamuluveyi Simoni awuseleshi kumachi, kutali padokwa na ng'emula ya lihiva. Kayikala pasi, akuwula lipinga lya vandu paghaveyi muwatu. ");
INSERT INTO ndj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pamalili kuwula, kamuwombela Simoni, “Soli watu awu mbaka pamachi matali, mukadangi njafu shenu muwomeshi vasomba.” ");
INSERT INTO ndj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni kamuyangula, “Bambu tuyifwasha kutegha njafu pamii posi tupata chindu ha, leki pawudeta yuwi datuyasilili njafu.” ");
INSERT INTO ndj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pambeli pavagolili kala, vawomesha vasomba vatangalili hata njafu sikakandeyi kudumuka. ");
INSERT INTO ndj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Vavakema vayawu vavelili muwatu wingi vayisi kuvatanga. Vayisa, vamemesha vasomba matu vosi mavili, hata vakacheyi vadibali. ");
INSERT INTO ndj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petili pawonili nawula, kamtundamila Yesu kadeta, wuki pawushu panenga, yuwi Chapanga, nenga muna sambi! ");
INSERT INTO ndj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni pamu na vamonga vosi vakayikang'anikeyi munu kupata vasomba vatangalili nawula. ");
INSERT INTO ndj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wuwula wula Yakobi na Yohani, vana va Sebidayu, vaveli valova vayaki Simoni. Yesu kamuwombela Simoni, “Kotoo kutila, kukandila ponopa dawuvi mufuva vandu.” ");
INSERT INTO ndj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Topi, pavapayikili matu mung'emula ya lihiva, vafilekili findu fyawu fyosi, vamkovikela Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu paveli mbwani yimu yaveli na mundu yumoyu yavelili na ukalava mvili wosi. Pamuwonili Yesu, mweni kamuwila pasi kamluva, “Bambu, pawudayila, ukuwesha kung'ofuwa.” ");
INSERT INTO ndj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu kamuwolushela liwoku lyaki na kumkamula padeta, “Ngudayila! Ung'ali!” Tepu ukalava wula uwuka. ");
INSERT INTO ndj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu kamuwombela, “Kotoo kumuwombela mundu yoyosi, ila ukayilangushi kwa mgolafichuku wa nyumba ya kudadavila, uyeghi fupu ya kupugiwa umweni, kucha walayishili Musa, ukatovileli kucha kulowoka.” ");
INSERT INTO ndj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Topi, milandu ya Yesu yikwila mwambu wosi. Lipinga lya vandu vatangalili liyikungasha kumpikanisha na kulowuliwa matami vawu. ");
INSERT INTO ndj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mweni ayendili pangajila vandu, aku akadadaveyi. ");
INSERT INTO ndj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lijuva limu, Yesu avelili pawula. Mafwalisayu na vawula va Malawu va Chapanga vamupili Musa kufuma kila luvagha Mugalilaya na Muyudeya na Muyelusalemu, vaveli vayikala. Liwovi lya Bambu lyaveli pamu na mweni lya kulowola valwalili. ");
INSERT INTO ndj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tepu vandu vayisa, vamuyegha mundu yumu yapombalili muluhagha, vayesha kumuyingisha munyumba, paulongolu pa Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lakini, kwanongwa ya lipinga lya vandu, valemwili kwingila munyumba. Topi, vakwela kumbindi ya lituvili liveli ligalamu, vakwemula midasi, vampenesha yula yapombalili pamu na ulili waki vamvikili paulongolu ya Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu pawonili ujumilwa wawu mkomi, amuwombilili mundu yula, “Ghanja, ngupomela sambi shaku.” ");
INSERT INTO ndj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Vawula va Malawu na Mafwalisayu vakandili kuyidasha, “Ghani yadeta filongu fya kumduka Chapanga? Kwa hela mundu yawesha kupomela sambi, ila Chapanga weka hela!” ");
INSERT INTO ndj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu avamanyili kala chivayihola, kavadasha, mkuyihola liki mundima shenu? ");
INSERT INTO ndj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Choti chivelili chipusuka nendu: kudeta, kupomeliwa sambi, awu kudeta, “Woloki yendi? ");
INSERT INTO ndj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Topi, ngudayila mumanyi mwana wa mundu kana uwesu wa kupomela vandu sambi kumlima.” Kamuwombela, yula mundu yapombalili, “Tandamuki, toli ulili waku yendi kaya.” ");
INSERT INTO ndj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tepu, ayisili kuwoloka paulongolu ya vosi, akatolili ulili waki kayenda kayaki kunu pamujuma Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vosi vakayikang'anikeyi! Livakamula lyogha, pavamjuma Chapanga, pavadeta. “Tuyiwona mihilu nalelu.” ");
INSERT INTO ndj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pambeli, Yesu afumili panji, amwonili mundu yasumula yivamkemaya Lawi, kayikala pa golela chichuku chaki. Yesu kamuwombela, “Ungovikeli.” ");
INSERT INTO ndj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi afilekili fyosi, kamkovekela Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi amugolilili Yesu lihungu likomi kayaki na vandu vasumula mbiya na vandu vamonga vayikalili pamu. ");
INSERT INTO ndj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafwalisayu na vawula va Malawu vakavang'ong'utekeleyi vandundami vaki pavadeta, Wuli mukulya na kulanda pamu na vandu yivasumula mbiya na yivavelili na sambi? ");
INSERT INTO ndj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kavayangula, “Vavelili na njimba nofu vakudayila ha muyilwana, vamudayilili vala vatami.” ");
INSERT INTO ndj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nyisa ng'odu kuvakema vandu goleki vapomeli, ila vavelili na sambi vapomeli. ");
INSERT INTO ndj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Vandu vamonga vamkovekela Yesu, vamuwombela, “Vandundami va Yohani mbatisha vakwikaja kulya myanja yitangalili na kudadava, hata vana chuli va Mafwalisayu vakugola wuwowu. Lakini vandundami vaku vakulya na kulanda hela.” ");
INSERT INTO ndj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu avayangulili, “Wuli, vala vandu vavalalikili kulihungu lya kuheta mukuvadayila vayikaji kulya na kunu bambu wa lihungu lya kuheta vawa pamu? Ng'odu! ");
INSERT INTO ndj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lakini dachiyisi chipindi bambu wa lihungu lya kuheta davamuwushi pala pavayikalili pamu, chipindi achi davavi vakwikaja kulya.” ");
INSERT INTO ndj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu avawombilili chilangushilu achi, “Vandu vakudumula ng'odu chipapi cha yingwa ya shonu na kuchivika muyingwa yisakalili, kucha pavagola naha, davavi vakudemula yila yingwa ya shonu na chila chipapi dachilinganili ng'odu na yila yingwa yisakalili. ");
INSERT INTO ndj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Vala vandu vakutaya ha difwayi wa shonu mumihaku yisakalili, vawona awu difwayi ya shonu daubaluli mihaku yila, difwayi dayiyitiki na mihaku dayibaluki. ");
INSERT INTO ndj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Difwayi ya shonu yikutayiwa mumihaku ya shonu. ");
INSERT INTO ndj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kwahela mundu yadayila kulanda difwayi ya shonu, vakudeta wula wa dayili munofu nendu.” ");
INSERT INTO ndj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lijuva limu lya lijuva lya kupumulila, Yesu aveli akupita mufitava fya mpunga. Vandundami vaki vakandili kubena misasa ya mpunga, vapulula mbeyu kwa mawoku, valya. ");
INSERT INTO ndj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafwalisayu vamonga vavadashili, “Mbona mkugola chindu chingajila kujumiliwa na Malawu vetu mulijuva lya Kupumulila?” ");
INSERT INTO ndj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu avayangulili, “Wuli, musoma duhu wagolili Dawudi pamu na vamonga chipindi pavaveghi na njala? ");
INSERT INTO ndj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mweni payingilili munyumba ya Chapanga, atolili mibumunda yivavikili ya kumtambikila Chapanga kalya na kuvapa vamonga. Na afi fyaveli mwiku kulya mundu wingi ila vatambika weka yawu.” ");
INSERT INTO ndj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pakumalilila Yesu kavawombela, “Mwana wa Mundu ndi Bambu wa Lijuva lya Kupumulila.” ");
INSERT INTO ndj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lijuva lingi lya lijuva lya Kupumulila, Yesu ayingilili munyumba ya kudadavila kuvawula vandu. Mula kwaveli mundu yumu liwoku lyaki lya mlilu lyapombalili. ");
INSERT INTO ndj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Vawula va Malawu na Mafwalisayu vakamuloleyi Yesu kucha dalowoli mundu Lijuva lya Kupumulila, ili vapati nongwa ya kumuhigha. ");
INSERT INTO ndj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu amanyili chivayihola, kamuwombela yula yaveli na liwoku lipombalili, “Tandamuki, woloki pawulongolu.” Yula mundu ayendili, kawoloka pawulongolu. ");
INSERT INTO ndj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pambeli Yesu kavawombela kandi, “Nguvadasha, Malawu vetu vakujumisha kugola chindu cha nyanyi awu kugola chindu chivifyili Mulijuva lya Kupumulila? Kutanga awu kuvifya? Kulowola mundu awu kumleka adanganyiki?” ");
INSERT INTO ndj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pavawolukili wosi vavelili pala, amuwombilili mundu yula, “Woloshi liwoku lyaku.” Bahala pala mweni kagola wuwula na liwoku lyaki linana. ");
INSERT INTO ndj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lakini veni vakalalili nesu, vawombana kumgolela milandu ya wafu Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lijuva limu, ayendili kuchindunda padadava kwa Chapanga na kugunga mesu pamihi posi. ");
INSERT INTO ndj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chilawu yaki avakemili vandundami vaki na vamonga kavashawula, vandu lilongu na vavili, avakemili vandundami. ");
INSERT INTO ndj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Vaveli ndi Simoni, Yesu amkemeyi Petili na Andeleya mkulumundu. Yakobi na Yohani na Filipu na Batulumeyu, ");
INSERT INTO ndj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateyi na Tomasi, Yakobi mwana wa Alufayu na Simoni mlevanila mlima wa Isilaeli. ");
INSERT INTO ndj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudasi mwana wa Yakobi na Yuda Sikaliyoti ya mshengitili Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pambeli asunukili kuchidunda pamu na vandundami vaki, Yesu awolukili payityalasi. Apa pavelili na vandundami vaki na lipinga likomi lya vandu yivafumili mbembu shosi. Vafumili Yudeya na Yelusalemu na mumbwani ya Tilu na Sidoni. ");
INSERT INTO ndj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Vosi vayisili kumpikanisha Yesu na kulowuliwa matami vawu. Kavalowola vosi vavelili vakutamika na vaveli na finyamkela. ");
INSERT INTO ndj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Vandu vosi vadayilagha kumugufya Yesu na liwovi lyaveli likumfuma na kuvalowola vonda. ");
INSERT INTO ndj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kavaghalambukila vandundami vaki, kadeta, “Vanemiliwa vala yivayimanya vakuwesha ha kwikala ngajila Chapanga, nongwa wutwa wa kumbindi kwa Chapanga ndi wa veni. ");
INSERT INTO ndj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ngiba yumwi yumpikanila njala ponopa, nongwa pambeli damwikuti. Ngiba yumwi yumlila ponopa, nongwa pambeli damseki kwa luseku! ");
INSERT INTO ndj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ngiba yumwi vandu pavavanyekwa na pavavasula na pavavajowoli na pavavadetela yumwi va wafu kwanongwa ya Mwana wa Mundu! ");
INSERT INTO ndj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Findu afi pafifumbuka, musekileli na kudinga. Nongwa nakaka fupu yenu yiva ngomi kumbindi kwa Chapanga. Nahawu ndi ndambu vagogolu vawu wuvavagolilili vambuyi va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pishu yumwi valundamali, nongwa mufwamuka kala. ");
INSERT INTO ndj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pishu yumwi yimwikuta ponopa, nongwa pambeli damuwoni njala! Pishu yumwi yumuseka kwa fisingu ponopa nongwa pambeli damulili na kwidedeka. ");
INSERT INTO ndj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Pishu yumwi yimujumiwa na vandu vosi. Nahawu ndi vagogolu vawu vavagolilili vambuyi va udesi wuwowu. ");
INSERT INTO ndj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nguvawombela yumwi yimumbikanisha, muvatami vachimdwama venu, muvagoleli finofu vala vaveli na maya na yumwi. ");
INSERT INTO ndj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mvanemeli vala yivavalawumu yumwi na muvadadavili kwa Chapanga vala yivavagolela wafu. ");
INSERT INTO ndj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mundu pakuvangula likanja limu mughalambulili na likanja lingi. Mundu pakupoka likoti lyaku mlekeli na gwanda yaku. ");
INSERT INTO ndj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yoyosi yakudadava umupi na mundu pakupoka chindu chaku kotoo kumwombela akuwuyishili. ");
INSERT INTO ndj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Muvagoleli vandu kucha wula wumudayila kugoliwa yumwi. ");
INSERT INTO ndj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kucha pamuvatama vala vavatamili yumwi weka hela, dampati chindu liki? Kwa hela! Nongwa hata vala vagola wafu vayitama veni. ");
INSERT INTO ndj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Leki pamuvagolela nyanyi vala weka vavagolela finofu dapati chindu liki? Hata vala vaveli na sambi vakugola fifi. ");
INSERT INTO ndj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kucha mukuvakopesha vala weka mukuvashuvilila davavahombi, dampati chindu liki? Hata vala vaveli na sambi vakuvayasima vaveli na sambi vayawu ili vavawuyishili wuwula. ");
INSERT INTO ndj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ila yumwi muvatami vachimdwama venu vosi na kuvagolela finofu, mukopeshi mukotoo kushuvilila kuwuyishiwa na fupu shenu dasivi ngomi na yumwi damuvi vana va Chapanga Mkomi. Nongwa mweni ndi munofu kwa vala vangajila kulumba na yivaveli vawafu. ");
INSERT INTO ndj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muvi na lusungu kucha tati wenu pavelili na lusungu. ");
INSERT INTO ndj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mkotoo kuvahigha vengi na yumwi damughiwi ng'odu, mukotoo kuvalaumu vengi na yumwi davamudeti, muvapomeli vengi na yumwi damupomiliwi na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muvapi vengi na yumwi damugayiliwi na damupokeli chigelu chikomi, chivadinilili njuu pwaa. Nongwa chigelu chichila chila chimuvalingilili vayenu na yumwi damugelukiwi ngimu chichila.” ");
INSERT INTO ndj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kavawombela Chilangushilu achi, “Ngalimesu akuwesha ng'odu kumlongosha ngalimesu monga. Pakagola nahawu vosi davadubukili mulyowu. ");
INSERT INTO ndj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kwahela mwanachuli yampita muwula waki, ila mwanachuli pamalila chuli daghavi kucha muwula waki. ");
INSERT INTO ndj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Wuli ukuchiwona chibandi chidokwa nendu chivelili mulisu lya mlongu waku na chipindi chichila ukulemwa kuliwona libalu livelili mulisu lyaku? ");
INSERT INTO ndj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Awu ukuwesha wuliwuli kumuwombela mlongu waku, mlongu leki nguwushi chibandi mulisu lyaku na kunu ukuliwona ng'odu lijika liveli mulisu lyaku umweni? Yuwi mfyangu! Wushi tanila lijika liveli mulisu lyaku, pambeli dauweshi kulola unofu na dauweshi kumuwusha chibandi chiveli mulisu lya mlongu waku. ");
INSERT INTO ndj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Libiki linofu liweshi ha kulela fivelekwa fichapukili, wuwula wula libiki lya wafu likuwesha ha kulela fivelekwa finowili. ");
INSERT INTO ndj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vandu vakulimanya libiki kwa fivelekwa fyaki. Nakaka vandu vakunokola ng'odu mindopi kumitalula, awu fimungumungu mumisompondu. ");
INSERT INTO ndj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mundu mnofu akuva na milandu minofu kufuma mumbeyu nofu yifumili mumunda yaki. Mundu mwafu akugola fyawafu Kufuma mumbeyu yawafu mumunda yaki. Mundu akuywanga milandu yimemili mumunda yaki. ");
INSERT INTO ndj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nongwa liki mukungema Bambu, Bambu, kunu mukugola ha findivawombela? ");
INSERT INTO ndj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ngudayila nivapi chilangushilu wa nyanyi, yoyosi yula dayisi kwa nenga, dapikanishi filongu fyangu na kufigola, ");
INSERT INTO ndj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ayu akwifwana na mundu yajenga nyumba yaki kumbindi, pasi msingi kavika kumbindi ya ligonguveli. Paliyisili lilava, lweni luyita lubosi lwa machi lupita panyumba yila, lakini yitikanyika ha, nongwa vajengili yidindalili. ");
INSERT INTO ndj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lakini yoyosi yapikanila filongu fyangu, kalema kugola chindu chochosi, ayu kayifwana na mundu yajengili nyumba mumiganga, kakotoka kukumbila msingi, Lilava paliyisa, lubosi lwa machi lupitila nyumba yila, yiwa pasi wuuuu! Na kubowoyoka!” ");
INSERT INTO ndj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pawombanili kala na vandu, Yesu ayendili Kapelinaumu. ");
INSERT INTO ndj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aku kwavelili na mkomi wa machonda mya wa Loma aveli na ndumindumi waki yamtamili munu. Ndumindumi ayu avelili mtami dabadaba. ");
INSERT INTO ndj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yula mkomi wa machonda papikanishili milandu ya Yesu, kavalayisha vavaha vamova Vayawudi vayendi kumluva Yesu ayisi kumlowola ndumindumi waki. ");
INSERT INTO ndj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pavafikili kwa Yesu, vamudediveka, vadeta, “Mundu ayu nakaka akudayiliwa kutangiwa na yuwi. ");
INSERT INTO ndj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mweni kawutama vandu va mlima wetu na mweni yatujengilili yila Nyumba ya kudadavila.” ");
INSERT INTO ndj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Topi Yesu kayenda pamu na veni. Pavaveyi samba vafika kaya ya yula mkomi wa machonda wa Loma avatumili vaghanja mundu vamuwombeli Yesu, “Bambu, kotoo wiyasha, kwingila munyumba yangu kwanongwa nenga ngujakwa ha. ");
INSERT INTO ndj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nongwa nguyiwona ngulemwa kuyisa kwa yuwi. Ila yuwi deti chilongu chimu hela, ndumindumi wangu danani. ");
INSERT INTO ndj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nongwa nenga wuwowu mundu yimeli pasi ya uwesu na ndiva nawu machonda pasi yangu. Pandimuwombela yumu, ‘Yendi!’ Akuyenda, pandimuwombela wingi, ‘Wisi!’ Akwisa na ndumindumi wangu, ‘Goli chindu achi!’ Mweni akugola.” ");
INSERT INTO ndj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu papikanishili afi kayikang'anika, kaliyendela lila lipinga lya vandu liveli likumkovikela na kudeta, “Nguvawombela ngalihela kumuwona mundu yoyosi amu Muyisilaeli yavelili na ujumilwa mkomi kucha ayu!” ");
INSERT INTO ndj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Vala vanjagila pavafikili kaya ya mkomi wa machonda wa loma vamuwona yula ndumindumi kanana. ");
INSERT INTO ndj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pambeli Yesu ayendili mlima wumu wukemiwa Naini na vandundami vaki na lipinga likomi lya vandu likumkovikela. ");
INSERT INTO ndj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Paghaveyi samba kafika mlima wula, vafumbukili vandu vapapa chikongu cha mundu mlumi, aveli mwana wa paweka kwa yula mawu ngalimlyangu. Vandu vatangalili va mlima wula vaveli pamu na mawu yula. ");
INSERT INTO ndj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bambu pamuwonili mawu yula kamuwonela lusungu, kamuwombela, “Kotoo kulila!” ");
INSERT INTO ndj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pambeli kayenda kuwugufya wula muwombangu na vala yivapapeyi vawoloka, kadeta, “Msongolu, ngukuwombela woloki, ngukulayila tandamuki!” ");
INSERT INTO ndj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yula msongolu yaghaveyi kasova katandamuka kakanda kuywanga, Yesu kamtola yula msongolu kamupa mamundu. ");
INSERT INTO ndj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Vandu vosi livengila lyogha, topi vamujuma Chapanga pavadeta, mbuyi mkomi wa Chapanga katubwitukila. “Chapanga kayisa kuvalowola vandu vaki.” ");
INSERT INTO ndj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Milandu ya Yesu yikwila kosi Yudeya na mlima wuveli pabehi. ");
INSERT INTO ndj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Vandundami va Yohani vamuwombela yila milandu yosi yimwilatili Yesu, pambeli mweni Yohani mbatisha, avakemili vandundami vavili kufuma mulipinga lya vandundami vaki. ");
INSERT INTO ndj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kavalayila kwa Bambu, vakamdashi, “Yuwi yula dayisi awu tumveteli wingi?” ");
INSERT INTO ndj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Vandundami vala pavafikili kwa Yesu vamuwombela, “Yohani mbatisha katulayisha twisi kwa yuwi tukudashi, ‘Yuwi ndi yula dawisi, awu tumuveteli wingi?’ ” ");
INSERT INTO ndj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chipindi chichila chila, Yesu aveli akuvalowola vandu vatangalili vatamikeyi matami va wafu na finyamkela na kuvagola vangalimesu vatangalili valoli. ");
INSERT INTO ndj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Topi Yesu kavayangula, “Muyendi mukamuwombeli Yohani mbatisha fila fimufiwonili na kufipikana, vangalimesu vakulola, ndevindevi vakuyenda yenda, yivaveli na ukalava vakung'ala, majogu vakupikanila, yivafwili vashukuka na vagayu vakulanduliwa Milandu ya Nyanyi. ");
INSERT INTO ndj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ngiba mundu yula yangajila hoshu na nenga!” ");
INSERT INTO ndj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pambeli vandumindumi va Yohani mbatisha pavawukili, Yesu akandili kuliwombela lipinga lya vandu milandu ya Yohani mbatisha, “Pamuyendili kula kuchivala, kumlola Yohani mbatisha mukayiholeyi kuchiwona liki? Wuli mukayiholeyi kumuwona Yohani kucha liteti palitikanyika na liyegha? ");
INSERT INTO ndj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mukayendili kumlola mundu wa wuliwuli? Mukacheyi mundu yafwalili yingwa nofu? Ng'odu, vandu vakufwala yingwa sha nyanyi na kwikala ngalilu nofu vava munyumba sha wutwa! ");
INSERT INTO ndj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Topi mung'ombeli mukayendili kulola liki? Wuli mwayendili kumulola mbuyi? Yina nakaka aveli mbuyi wa Chapanga, pitu mbuyi. ");
INSERT INTO ndj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ayu mweni yivamdeta Yohani wa mufitabu fing'alili, ‘Loli nenga ngumlayisha makungu wangu akulonguleli, mweni dakuseveli deha yaku.’” ");
INSERT INTO ndj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu amalilili kwa kudeta, “Nguvawombela, vandu vosi, kwahela yaveli mkomi kwa Yohani mbatisha. Hata naha, yula yaveli mdokwa pitu vosi, muwutwa wa kumbindi kwa Chapanga ndi mkomi pitu Yohani.” ");
INSERT INTO ndj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pavapikanishili afi vandu vosi na vala vasumula mbiya vajuma ugoleki wa Chapanga, Topi vajumilili kubatishiwa na Yohani mbatisha. ");
INSERT INTO ndj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lakini Mafwalisayu na vala yivamanyili unofu Malawu valemili fila fyadetili Chapanga kwa veni, topi, valemili kuvabatishiwa na Yohani. ");
INSERT INTO ndj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu kayendilela kudeta, “Vandu va chileli achi dandivalinganishi na chindu liki? Vava wuliwuli? ");
INSERT INTO ndj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Vava kucha vasongolu vayikaleyi kusoku vakwikemesha lipinga limu na limonga, ‘Tuvakuvila ng'oma, lakini mudinga ha! Tuvasomulela msambu wa makiva lakini mlila ha!’ ");
INSERT INTO ndj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kwa nongwa Yohani mbatisha ayisili, kuyikaja kulya na kuleka kulanda difwayi, yumwi mudeta chimkwela chinyamkela! ");
INSERT INTO ndj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana wa Mundu kayisa, akulya na kulanda, yumwi mukawombeyi, ‘Mumulole ayu mbafu na njayila, vaghanja vaki vasumula mbiya na vaveli na sambi.’ ");
INSERT INTO ndj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hata naha, luhunja lwa Chapanga ulinganila luwoneka kwa vosi vamjumilili.” ");
INSERT INTO ndj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfwalisayu yumu amlalikili Yesu kulya filivi kaya yaki. Ayingilili munyumba ya yula Mfwalisayu, kayikala na kulya filivi. ");
INSERT INTO ndj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kula kumbwani kwavelili na mawu yumu yaveli na sambi. Aveli kapikana Yesu kava kayaki yula Mfwalisayu, atolili supa yitalamili ya alabasta yimemili utuli. ");
INSERT INTO ndj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kayisa, kawoloka pabehi na mawulu va Yesu, kalila misosi yaki yimusululila Yesu mumawulu. Mdala ayu kapukuta mawulu va Yesu kwa fwili shaki. Pambeli kavanonela na kumshagha mafuta va kunungilila. ");
INSERT INTO ndj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yula Mfwalisayu yamlalikili Yesu pafiwonili afi, ayiholili mumunda yaki, “Kucha mundu ayu angaveli nakaka mbuyi, angamanyili mdala ayu kava wuliwuli, kucha aveli muna sambi.” ");
INSERT INTO ndj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kamwombela yula Mfwalisayu, “Simoni, ndiva na chindu cha kukuwombela.” Simoni kayangula, “Yina muwula, deti.” ");
INSERT INTO ndj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu adetili, “Vandu vavili vayendili kuyasima mbiya kwa mundu yayasimisha mbiya, yumu avelili kamuyasima mbiya sha ijala ya mwesi wumu na nusu na wingi mbiya sha ijala ya mwaka wumu na nusu. ");
INSERT INTO ndj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pavalemwili kuhomba nongwa shawu, mundu yula avapomilili vosi vavili. Yoti wa ava vavili damtami munu bambu yula?” ");
INSERT INTO ndj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni kamyangula, “Nakaka yula yapomiliwili nongwa ngomi nesu kwa yula Bambu.” Yesu kamuwombela, “Yina fiwuwombilili.” ");
INSERT INTO ndj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pambeli kamghalambukila yula mdala, kamuwombela Simoni, “Ukumuwona mdala ayu? Nenga panyingilili apa pakayaku, kanyimba ha machi va kuwofuwa mawulu vangu! Lakini mdala ayu kang'ofua mawulu vangu kwa misosi yaki na kumbukuta kwa fwili shaki. ");
INSERT INTO ndj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yivi kujambusha ngajila kunonela, lakini ayu mdala kukandila nyingili apa akanoneleyi mawulu vangu. ");
INSERT INTO ndj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yivi kunangusha ha ligoya lyaku kwa kunshaya utuli kumutwi, lakini mdala ayu kagolela naha, kan'shagha mafuta va kunungila mumawulu vangu. ");
INSERT INTO ndj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ponopa ngukuwombela mdala ayu kapomiliwa sambi shaki sitangalili ponopa utami waki wuva mkomi. Lakini ya pomiliwa padokwa na ndamilu yaki dokwa.” ");
INSERT INTO ndj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pambeli Yesu kamuwombela yula mdala, “Ngupomela sambi shaku.” ");
INSERT INTO ndj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Topi vala vavelili pamu palitambiku vakulya vakayidasheyi, “Ayu mundu liki akuwesha kupomela sambi?” ");
INSERT INTO ndj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu kamuwombela yula mdala, “Ujumilu waku wukulowola, yendi kwa kusika.” ");
INSERT INTO ndj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pambeli Yesu kapita kumbwani na mufijijini akalanduleyi filongu fya Nyanyi fya wutwa wa kumbindi kwa Chapanga. Vala lilongu na vavili vayilongushili nawu, ");
INSERT INTO ndj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wuwowu vadadala vamonga vala Yesu avelili kavawusha finyamkela na kuvalowola matami vayilongushili pamu. Ava vaveli akina Maliya yivamkema Magadalena, mweni awushiwili finyamkela vawafu saba, ");
INSERT INTO ndj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Yoana mdala wa Kusa. Kusa aveli mgolafichuku wa mkomi wa Helodi. Wuwula wula vaveli Susana na vadadala vamonga vaveli pamu na Yesu. Vadadala ava vavelili vakumukimbanikila Yesu pamu na Vandundami vaki kwa mali shawu veni. ");
INSERT INTO ndj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Chipindi chimu lipinga likomi lya vandu lyavelili liyikungula pamu. Vandu kufuma mbwani shosi vakayiseyi kwa Yesu. Mweni avawombilili chilangushilu achi. ");
INSERT INTO ndj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yakweta ayendili kukweta mbeyu shaki. Pakweteyi mbeyu simu, shaponikili mudeha, vandu pavapiteyi mudeha vasivatanga na vambongu valya. ");
INSERT INTO ndj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Simonga shaponikili muuganga wuveli na migonguveli gonguveli, pasimelili sinyala kwanongwa kwa hela machi. ");
INSERT INTO ndj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Simonga shaponikili mumisomi, misomi. Mbeyu sila pasimelili sikekenekwa na misomi. ");
INSERT INTO ndj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Simonga shaponikili muuganga wa nyanyi, simela na kuveleka myanja miya.” Pambeli Yesu kawomba, kalandusha kwa lishu, kadeta, “Yaveli na majeji apikanili!” ");
INSERT INTO ndj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Vandundami vaki Yesu vamudashili mana ya chilangushilu achi. ");
INSERT INTO ndj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mweni kayangula, “Yumwi mugayiliwa uwesu kumanya mbwepu sha wutwa wa kumbindi kwa Chapanga, lakini ava vamonga vakupikanila kwa chilangushilu, ‘Vakuwombiwa kwa chilangushilu, ili pavalola vakotoo kuwona na pavapikanisha vakotoo kupikana.’ ");
INSERT INTO ndj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Topi mana ya chilangushilu achi: mbeyu ndi chilongu cha Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sila siponikili mudeha sikulangusha vandu vala vapikanishili filongu fya Chapanga, pambeli Lijangavandu kayisa kuliwusha mundima shawu vakotoo kujumila kulowuliwa. ");
INSERT INTO ndj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sila siponikili muligonguveli sikulangusha vandu vala pavapikanisha fila filongu vakupokela kwa luseku. Kucha sila mbeyu, vandu ava vahela mikigha nongwa vakujumila chipindi chifupi hela na pavayeshiwa vakulemwa vakuguwa. ");
INSERT INTO ndj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sila mbeyu siponikili mumibiki yiveli na misomi sikulangusha vandu yivapikanilili filongu fya Chapanga, Lakini pambeli padokwa pavawuka, vakukanda kuyipwelesha, kwa mali na kufwamuka mungalilu, veni davaleli ndili filelwa na kukomala. ");
INSERT INTO ndj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sila mbeyu siponikili muuganga wa nyanyi, ndi vandu vakupikanila filongu fya Chapanga, vakulikamulila kwa ndima usangi na ujumilwa. Ava vakwigagasha mbaka valeli fivelekwa. ");
INSERT INTO ndj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Vandu vakukwata luliku na kugubikiwa na chiyungu awu kuyivika mwifungu ya chitanda, ila vakuvika pachindangawala, vandu pavayingila mgati vawoni lwengi. ");
INSERT INTO ndj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Chochosi chavafisili dachiwoneki pee na mbwepu chochosi dachimanyiki na dachiwoneki pawelu pee. ");
INSERT INTO ndj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mani naha, muyiloleyi ndambu yimupikanili, nongwa avelili na chindu dayongeshwi, lakini yula yangajila chindu, hata chila chiveli cha mweni dachitoliwi.” ");
INSERT INTO ndj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mau na valongumundu Yesu vamukovekela, lakini valemwa kumuselelela kwanongwa kwavelili na lipinga lya vandu. ");
INSERT INTO ndj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mundu yumu amuwombilili Yesu, “Mawu na vafwatavaku vava panji, vakudayila kukuwona” ");
INSERT INTO ndj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lakini Yesu kavawombela vandu vosi, “Mau na valongu vangu ndi vala yivapikanisha filongu fya Chapanga na kufikamula.” ");
INSERT INTO ndj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lijuva limu, Yesu kayipakili muwatu pamu na vandundami vaki, kavawombela, “Tujabuki kumwambu ya lihiva.” Topi vakanda mwanja, ");
INSERT INTO ndj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","pavaveghi muwatu vakuyenda, Yesu simkamulili mbota, kawonja. Tepu liwumbula lyakandili mulihiva, machi vakandili kuyingila muwatu, vaveli munjifwa. ");
INSERT INTO ndj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Vala vandundami vamyendela Yesu vamuyimusha, pavawomba, “Bambu, Bambu! Tukusova!” Yesu kayimuka, kafiwombela majinga na liwumbula finyamali, Tepu finyamala, filindivala jii. ");
INSERT INTO ndj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu kavawombela vandundami vaki “Kujumila kwa yumwi kuva koti” Lakini veni vakayikang'anikeyi na kutila, kunu vakwidasha, “Ayu mundu liki? Kavawombela majinga na liwumbula linyamali vamuyitikila?” ");
INSERT INTO ndj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Vayendelela na mwanja, vakafiki mbwani ya Vagelasi pabehi na Galilaya, kumwambu ya lihiva. ");
INSERT INTO ndj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pavajabukili muwatu, mundu yumu yaveli na finyamkela kamuyisila kufuma kumbwani. Majuva vatangalili mundu ayu afwalagha ha yingwa na ayikalili kaya ha ila kusembi. ");
INSERT INTO ndj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pamuwonili Yesu, kayiyasilila pasi paulongolu ya Yesu padeta kwa lishu likomi, “Yuwi Yesu mwana wa Chapanga mkomi, kuva na milandu liki na nenga? Ngukuluva ukotoo kugobola nenga!” ");
INSERT INTO ndj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu kamuwombela yula chinyamkela amfumi mundu yula. Chinyamkela yula aveli akumuyingila mundu yula myanja yitangalili, vandu vamuwopili kwa lingongola na kumuvika munyumba, lakini myanja yitangalili adumulili mingongola, chinyamkela atuvili kuchivala. ");
INSERT INTO ndj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Topi Yesu kamudasha, “Litawa lyaku ghani?” Mweni kayangula, “Litawa lyangu lipinga kwanongwa finyamkela vavelili vatangala.” ");
INSERT INTO ndj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Fila finyamkela fikamluveyi Yesu akotoo kuvayegha panji ya kumambi. ");
INSERT INTO ndj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pala pavelili na lipinga likomi lya vangubi pabehi na chidunda vakalyeyi. Topi finyamkela vala valuvili vayingili kwa vala vangubi. Mweni kavajumisha. ");
INSERT INTO ndj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Finyamkela vala vafuma kwa mundu yula, vavayingila vangubi, veni vaseleka mungema yiveli ndali, vadubukila mulihiva vasova machi. ");
INSERT INTO ndj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vadimangubi pavawonili milandu yosi yila, vatuva, vayenda kuvawombela vandu va kumbwani na kufitava milandu yila. ");
INSERT INTO ndj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Vandu vayisili kulola milandu yifumbukili pala. Vamuyendela Yesu, vamuwona yula mundu yamfumishili finyamkela kayikala mumawulu va Yesu, kafwala yingwa na luhala lwaki lumuwuyila, vatila. ");
INSERT INTO ndj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Vandu vala yivavawombileyi vandu, fila fivafiwonili kwa mundu yula kawushiwa wuliwuli. ");
INSERT INTO ndj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Vandu va mlima wula wa Gelasi lyavakamulili lyova likomi. Vamuluvili Yesu awuki, ayendi. Yesu kayipakila kandi muwatu, awukili. ");
INSERT INTO ndj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yula mundu yafumishilwi finyamkela akamdedekeyi vawuki pamu na mweni. Lakini Yesu kamkanisha pamuwombela, ");
INSERT INTO ndj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wuyi kaya ukavawombeli vandu vosi fyakugolilili Chapanga.” Topi mundu yula kayenda kumbwani yivayikema Lilongu, kavawombela vandu chila Yesu chamugolilili. Na vandu vosi yivapikanilili vajinga. ");
INSERT INTO ndj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu pawuyili kumwambu ya lihiva, lipinga lya vandu lyayisili kumyanga, wula vosi vaveli vakumuvetela. ");
INSERT INTO ndj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ayisili pala mundu yumu yivamkema Yailu, aveli mtambika wa munyumba ya kudadavila. Kamtundamila Yesu, kamluva ayendi kaya yaki, ");
INSERT INTO ndj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kwanongwa mwana waki aveli yumu hela, aveli muhinja wa myaka lilongu limu na mivili, aveli dabadaba. Yesu pakayendeyi, vandu vamukikili mbembi shosi. ");
INSERT INTO ndj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Topi kwavelili mdala yumu mulipinga lila aveli mtami wa liholuveya kwa myaka lilongu limu na mivili, avelili kamalila kala mbiya shaki shosi kwa valungwana, kwa hela mundu aweshili kumlowola. ");
INSERT INTO ndj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mdala ayu amkovikelili Yesu kumbeli na kugufya luviniku lwa yingwa yaki. Bahala pala kanana wula utami wa liholuveya. ");
INSERT INTO ndj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu adashili, “Ghani kangufya nenga?” Vandu vosi pavakanili, Petili kamuwombela, “Bambu, lipinga lya vandu likushengeta na kukukekeneka!” ");
INSERT INTO ndj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lakini Yesu kadeta, “Kwaveli mundu kangufya nenga, nongwa nguyiwona liwovi lyangu linyangila.” ");
INSERT INTO ndj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yula mdala kalemwa kuyifisa, kafumbuka mweni kunu pakabagama kwa lyogha, kayiyasila paulongolu ya Yesu. Kakanda kuvahimulila vandu ndambu yamgufili Yesu na ndambu apatili kulowoka bahala pala. ");
INSERT INTO ndj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu kamuwombela, “kamwali wangu kujumila kwaku kukulowola. Uyendi kwa kusika.” ");
INSERT INTO ndj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chipindi Yesu akali pakawomba, ayisili ndundami wa mtambika mkomi wa munyumba ya kudadavila, kamuwombela, “Muhinja waku kasova kala, ukotoo kumfwasha muwula kandi.” ");
INSERT INTO ndj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu papikanishili naha, kamuwombela Jailosi, “Ukotoo kutila, ujumili hela, mweni dalowoki.” ");
INSERT INTO ndj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pavafikili kaya yaki, Yesu amjumishili ng'odu mundu kuyingila pamu ila Petili, Yohani, Yakobi na valelwa va muhinja yula. ");
INSERT INTO ndj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vandu vosi vaveli vakulila na kudadava, Yesu kavawombela, “Mkotoo kulila mweni kasova ng'odu, kawonja hela.” ");
INSERT INTO ndj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Vandu vosi vakamsekeyi, veni vamanyili aveli kasova. ");
INSERT INTO ndj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lakini Yesu amkamulili liwoku, kadeta, “Mwana wangu, tandamuki!” ");
INSERT INTO ndj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ufuki waki wumuwuyila mhinja yula, katandamuka. Yesu kavalayila vamugayili filivi. ");
INSERT INTO ndj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Valeli vaki vayikanganika nesu, lakini Yesu kavawombela vakotoo kumuwombela mundu milandu yigolikili. ");
INSERT INTO ndj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu avakemili vala lilongu na vavili, avagayilili liwovi na uwesu wa kuvavinga finyamkela na kulowola matami. ");
INSERT INTO ndj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pambeli kavalayila vayendi vakalanduli chilongu cha wutwa wa kumbindi kwa Chapanga na kuvalowola vatami. ");
INSERT INTO ndj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kavawombela, “Pamuva na mwanja mukotoo kutola chindu chochosi: Mkotoo kutola Lukweku na muhaku na filivi na mbiya na lihabiti lingi. ");
INSERT INTO ndj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba yoyosi damuyingili na kuvalibushila, muyikali mbaka pamuwuka mlima wula. ");
INSERT INTO ndj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Vandu pavalema kuvalibushila, muwuki mlima wula, pamuwuka mupundi lifu mumawulu venu yivi utovileli kwa veni.” ");
INSERT INTO ndj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Topi vandundami vakandili mwanja, vapita kunu pavalandula milandu ya Chapanga na kulowola vatami kila luvagha. ");
INSERT INTO ndj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ponopa, Helodi aveli akutavala, apikanili milandu yosi yiveli yikugoleka, ashushutikili kwanongwa vamonga vakawombeyi, Yohani Mbatisha yasovili kashukuka. ");
INSERT INTO ndj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Vamonga vakawombeyi kucha Eliya kawuya na vamonga vakawombeyi naha, mundu yumu yaveli mtambika wa dayili wa Chapanga kawuya mumlima. ");
INSERT INTO ndj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lakini Helodi kayendelela kudeta, “Yohani mbatisha ndimudumula mutwi, ponopa ayu yimbikana milandu yaki ghani?” Aveli na dobukelu ya kumuwona Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Vala vandundami pavawuyili, vamuwombela Yesu fyosi fyavagolili. Yesu avatolili, kayenda pamu nawu pangajila vandu kumbwani ya Betisayida. ");
INSERT INTO ndj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lakini vala vandu pavamanyili kwayendili vamkovikelili. Yesu kavalibushila na kuvahimulila milandu ya wutwa wa kumbindi kwa Chapanga, kavalowola vala vadayileyi kulowuliwa. ");
INSERT INTO ndj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lijuva palihongili, vala lilongu na vavili vamuyendela na kumuwombela, “Wuvayitawuli vandu vayendi kaya shawu vakasaki filivi na pakuwonja. Apa patuvelili padasi.” ");
INSERT INTO ndj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lakini Yesu kavawombela, “Yumwi damuvapi filivi.” Vamyangula, “Tuvahela chindu, tuva na mibumunda muhanu na vasomba vavili hela. Yuwi ukudayila tuyendi tukavahemileli filivi lipinga lyosi ali?” ");
INSERT INTO ndj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pala paveli na vandu vatangalili, valulumi weka vaveli milongu mya muhanu. Topi Yesu kavalayila vandundami vaki, “Muvawombeli vandu vayikali fipinga fya vandu milongu muhanu milongu muhanu.” ");
INSERT INTO ndj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Vandundami vaki vagola kucha wavalayilili, vosi vayikala pasi. ");
INSERT INTO ndj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pambeli Yesu katola yila mibumunda muhanu na vala vasomba vavili, kalola kumbindi, kamlumba Chapanga, kametula, kavapa vandundami vaki, vavapi vandu valyi. ");
INSERT INTO ndj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Vandu vosi valya, vayikuta. Pavasosolili filivi fisighalili, vamemesha fitandavala lilongu na fivili. ");
INSERT INTO ndj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lijuva limu, Yesu aveli akudadava weka yaki, vandundami vaki vaveli pamu na mweni. Topi kavadasha, “Vandu vakudeta nenga ghani?” ");
INSERT INTO ndj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Veni vamuyangula, “Vamonga vakudeta yuwi kuva Yohani mbatisha, vamonga vakudeta yuwi Eliya na vamonga mbuyi wa Chapanga wa dahili kushukuka.” ");
INSERT INTO ndj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kavadasha, “Yumwi mukucha nenga ghani?” Petili kayangula, “Yuwi kuva Kilistu Mkombola, yuwushawuliwili na Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pambeli Yesu kavakana vakotoo kumuwombela mundu yoyosi milandu ayi. ");
INSERT INTO ndj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu kayendelela kudeta kucha mwana va mundu aweshi kugoboleka nendu dalemiwi na vavaha na vatambika vakomi na vawula va Malawu na kuwulayiwa, lakini pavapita majuva matatu dashukuki. ");
INSERT INTO ndj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pambeli kavawombela vandu vosi, “Mundu yoyosi padayila kungovekela nenga, ayilemi mweni kwa kulema findu fila fiudayila. Atoli lupingika lwaki majuva vosi, angovikeli. ");
INSERT INTO ndj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nongwa, mundu yadayila kuwugombola unofu waki mweni, dawuyaghamishi, lakini mundu yoyosi dayaghamishi unofu waki na kungovikela nenga dawulowoli. ");
INSERT INTO ndj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wuli kuna fwayida liki mundu dapati mali shosi sha mlima kwa kuyiyamisha awu kuyimalila mweni? ");
INSERT INTO ndj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mundu pang'onela soni nenga na ng'ulilu yangu, mwana wa mundu damuwoneli soni mundu ayu chipindi payisa muukomi waki na wa Tati na vamakungu vang'alili. ");
INSERT INTO ndj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nguvawombela nakaka, kuna vandu vamonga bahapa davasovi ha ngajila kuwuwona wutwa wa kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Palipitili lijuma limu kufumila pawombili afi, Yesu kavatola Petili na Yohani na Yakobi, kayenda nawu kuchidunda kudadava. ");
INSERT INTO ndj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Paghaveyi akudadava, bahala pala kuwushu yaki kwaghalambukili, yingwa shaki siva mbuleteee!. ");
INSERT INTO ndj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tepu, vandu vavili vawonekili pavaywanga pamu, veni vaveli Musa na Eliya, ");
INSERT INTO ndj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","vaveli vafumbuka na ukomi, vakaywangeyi pamu milandu ya kumalishila chichuku cha Chapanga waki kwa kusova kula Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petili na vamonga vaveli vakamuliwa na mbota, hata pavayimukili, vauwonili ung'alili wa Yesu, ukomi kwa vala vandu vavili vavelili pamu. ");
INSERT INTO ndj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bahala pala vandu vala pavamlekili Yesu, Petili amuwombilili Yesu, “Bambu, tujengi mibudi mitatu, limu lyaku, limu lya Musa na limonga lya Eliya.” Nakaka akamanyeyi ng'odu kucha akuwomba liki. ");
INSERT INTO ndj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petili aveli akudeta afi, lyawonikili lifundi, chimbwepa chaki chavagubikili, lifundi lila palivagubikili vala vandundami vatila nendu. ");
INSERT INTO ndj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Vapikana lishu kufuma mula mulifundi, “Ayu mwana wangu yinimushawulili, mumpikanishi.” ");
INSERT INTO ndj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pambeli lishu lila palinyamalili vamuwona Yesu kaweka hela. Vanachuli vayikalili jii kwa afi fyosi, vamuwombela mundu ha milandu yosi vayiwonili. ");
INSERT INTO ndj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chilawu yaki pavasunukeyi kufuma kuchidunda, lipinga likomi lya vandu lyatang'anikili na Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mundu yumoyu mulipinga lila kalandula kwa lishu, kadeta, “Muwula! Ngukuluva umuloli mwana wangu yumu hela! ");
INSERT INTO ndj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chinyamkela akumkamula tepu akuwuta kwa lishu, kandi akumtaya chisilika, kunu likumfuma lifulufulu mumlomu. Limuyashili nendu pambeli lyamulekili ayendi. ");
INSERT INTO ndj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ndivaluva Vandundami vaku vamuvingi lakini valemwa.” ");
INSERT INTO ndj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kayangula, “Yumwi chileli chingajila ujumilwa na chiveli na sambi! Dandiyikali na yuwi mbaka ndili? Dandiyiwunishili mbaka ndili?” Pambeli kamuwombela, “Muyeghi mwana waku apa.” ");
INSERT INTO ndj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chipindi mwana ayu payiseyi kwa Yesu, yula chinyamkela kamuwisha pasi na kamtaya chisilika. Lakini Yesu kamlakalila chinyamkela, kamulowola mwana na kumugayila tati mundu. ");
INSERT INTO ndj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Vandu vosi vayikanganikili liwovi lya paweka lya Chapanga. Vala vandu pavaveghi vakali hela vakwikanganika milandi yosi yagolili, Yesu kavawombela vandundami vaki, ");
INSERT INTO ndj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mteghi majeji, mpikanishi milandu ayi. Kucha Mwana wa Mundu datayiwi mumawoku va vandu.” ");
INSERT INTO ndj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lakini veni vamanya ng'odu filongu fila, fiyifisa kwa veni vakotoo kumanya na vakatileyi kumudasha filongu afi. ");
INSERT INTO ndj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Vandundami vaki vakalimbaneyi, “Ghani mkomi gati ya veni?” ");
INSERT INTO ndj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu avamanyili luhala lwau chavayiholeyi mundima shawu, topi kamtola mwana mdokwa kamvika pabehi yaki. ");
INSERT INTO ndj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Avawombilili, “Mundu yoyosi yamupokela mwana mdokwa kucha ayu kwa litawa lyangu, akumbokela nenga na yambokela nenga akumpokela na yula anayishili. Wula yula aveli mdokwa pagati ya yumwi vosi, ayu ndi mkomi kupita mwavosi.” ");
INSERT INTO ndj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohani kayanga pawomba, “Bambu, tumuwona mundu yumu akuwusha finyamkela kwa litawa lyaku, yufwi tumkanisha nongwa mweni wa lipinga lyetu ha!” ");
INSERT INTO ndj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lakini Yesu kamuwombela, “Mkotoo kumkanisha, yangajila kulimbana na yumwi kava mwambu wenu.” ");
INSERT INTO ndj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chipindi pachifikili Yesu kutoliwa kumbindi kwa Chapanga, mweni awonili ayendi Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Topi kavalayila vanjagila vamlonguleli, vayendi Samaliya kumtanda vafiwona findu fyosi fyadeteyi mweni. ");
INSERT INTO ndj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lakini venikaya va pala valema kumuyanga kwanongwa aveli akuyenda Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Topi vandundami vaki, akina Yohani na Yakobi, pavawonili naha, vadeta, “Bambu, ukudayila tuvalayishili motu usumuki kufuma kumbindi uvalungushi?” ");
INSERT INTO ndj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lakini Yesu kavaghalambukila kavalakalila. ");
INSERT INTO ndj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pambeli Yesu na vandundami vaki vayendili kaya singi. ");
INSERT INTO ndj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pavaveghi munjila kuyenda Yelusalemu, mundu yumu kamuwombela Yesu, “Dandikukovikeli kosi kuwuyenda.” ");
INSERT INTO ndj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kamuwombela, “Fingekembi vana mbaku na vambongu vana fiyumba lakini nenga mwana va mundu ndivahela pakwikala na pakupumulila.” ");
INSERT INTO ndj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kamuwombela mundu wingi kandi, “Ungovikeli.” Lakini mundu yula adetili, “Bambu, uneki tanila nyendi ngamsiki Tati wangu.” ");
INSERT INTO ndj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu kamuyangula, valeki vasovili vamsiki asovili muyawu, yuwi uyendi ukalanduli wutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mundu wingi kandi kamuwombela, “Bambu ngudayila kukukovikela lakini uneki tanila ngavayitawuli vandu yivaveli kayangu.” ");
INSERT INTO ndj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu kavawombela, “Yoyosi yakamula lihuka palima kunu palola kumbeli, ayu akujakwa ha kuwutwa wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pambeli Bambu avashawulili vanachuli vamonga milongu saba na vavili, kavalayisha vavili vavili, valonguleli mbwani yosi na mahali kosi padayilili kuyenda. ");
INSERT INTO ndj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kavawombela, “Filivi fitangala, lakini vakubena vadokwa. Ponopa mumuluvi muna chitava avalayishi vagola chichuku cha kuchitava cha Bambu vakabeni. ");
INSERT INTO ndj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Muyendi, nguvalayisha yumwi kucha vafungami pagati ya fingekembi. ");
INSERT INTO ndj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mkotoo kutola muhaku wa mbiya na likanda na mikobasi, mudeha mukotoo kumjambusha mundu yoyosi. ");
INSERT INTO ndj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pamuyingila munyumba yoyosi, yakwaa muvajambushi naha, ‘Kusika kuvi munyumba ayi!’ ");
INSERT INTO ndj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Leki mundu padayila kusika avalibushili, kusika kwa yumwi dakuvi na mweni, leki kwahela mundu yadayila kusika, kusika dakuvawuyili. ");
INSERT INTO ndj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Muyikali munyumba ayi pamulya na kulanda fyavavapili, nongwa mgola chichuku akudayiliwa ijala yaki. ");
INSERT INTO ndj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pamuyingila mlima wowosi na vandu pavavapokela, mulyi filivi fyavavapa. ");
INSERT INTO ndj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Muvalowoli vatami vavelili aku, muvawombeli vandu, wutwa wa kumbindi kwa Chapanga wuva pabehi. ");
INSERT INTO ndj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Leki pamuyingila mumbwani yoyosi, pavavalibushila ng'odu, mufumi, pamupita mudeha shawu mudeti naha, ");
INSERT INTO ndj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","hata lifu lya mumbwani yenu palilemilela mumawulu yenu muyipundi ayi yivi kucha ngayikilu kwa veni. ‘Muvi na ngumbungumbu kucha wutwa wa kumbindi kwa Chapanga wuva pabehi kwisa.’ ");
INSERT INTO ndj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nguvawombela nakaka, lijuva lya highilu palifika Chapanga dalangushi usangi mumbwani ya Sodoma pitu mumbwani ayi.” ");
INSERT INTO ndj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Pishu yuwi mbwani ya Kolasini! Pishu na yuwi mulima wa Betisayida! Mihilu yigolikili kwa yumwi yingagolikili kula kumulima wa Tilu na mulima wa Sidoni, vandu vaki, vangafwalili mikungi na kwibunga lifu, kuyilangusha kucha vapomela! ");
INSERT INTO ndj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lakini lijuva lya highilu palifika Chapanga dalangushi usangi mumlima wa Tilu na mumlima wa Sidoni pitu yumwi. ");
INSERT INTO ndj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na yuwi mlima wa Kapelinaumu! Wuli mkacheyi wuyikweshi mbaka kumbindi kwa Chapanga? Dawusunushwi mbaka kumambi!” ");
INSERT INTO ndj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kandi kavawombela, “Yavapikanisha yumwi, akumbikanisha nenga na yalema kuvapokela, akulema kunyanga nenga. Na yoyosi yalema kunyanga, akumlema kumyanga yula yanayishili.” ");
INSERT INTO ndj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pambeli vala milongu saba na vavili vawuya kunu pavanemilela, vadeta, “Bambu,” “hata finyamkela patuvawombilili chindu kwa litawa lyaku vatujumila!” ");
INSERT INTO ndj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu kavawombela, “Ndimuwona Lijangavandu paponeka kucha lupanda kufuma kumbindi. ");
INSERT INTO ndj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yina ndivagayila uwesu wa kuvata njoka na vanyunji na kumalila liwovi lyosi lya Lijangavandu, wala kwahela chindu dachivagoboli. ");
INSERT INTO ndj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lakini, mukotoo kusekilela finyamkela kuvajumila, ila musekileli matava venu vayandikiwa kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chipindi chichila chila, Yesu kasekelela kwa uwesu wa Mfuki Mng'alili, kadeta, “Chikomu bambu Tati, Bambu wa kumbindi na kumlima, nongwa kuvagubutulila findu vangajila kusoma na kuvafifa findu afi vaveli na luhunja na vaveli na luhala lwa kusoma. Yina Tati, yikunovela nahawu.” ");
INSERT INTO ndj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kavawombela, “Tati wangu kanyimba findu fyosi. Kwahela yamumanyili mwana ila Tati, wala amumanyili Tati ila mwana na yoyosi yula mwana damudayili kumlangusha.” ");
INSERT INTO ndj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pambeli kavawuyila vala yivamkovikileyi kavawombela, “Munemiliwa vosi yimufiwona afi! ");
INSERT INTO ndj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nguvawombela kucha, ndundami wa Chapanga na vatwa vadayilili kufiwona fila fimufiwona yumwi valemwa kufiwona na kupikanisha vakupikanisha ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pambeli mundu yavamanyili Malawu va musa kawoloka, kamdasha akadayileyi kumtegha, “muwula goli liki ili niyikali jola?” ");
INSERT INTO ndj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kamudasha, “Vayandika liki Mumalawu? Kuchimanya?” ");
INSERT INTO ndj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kamuyangula, “ ‘Umtami Bambu Chapanga waku kwa moyu waku wonda, kwa ndima yaku yosi, kwa liwovi lyaku lyosi na kwa luhala lwaku losi. Na, umtami mwawu ngimu wuyitama umweni.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kamuwombela, “Kuyangula nyanyi! Goli nahawu na dawuvi mnofu.” ");
INSERT INTO ndj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lakini mweni akadayileyi kuyilangusha kucha mundu goleki, kamdasha Yesu, “Mjofi wangu ghani?” ");
INSERT INTO ndj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu kamyangula, “Mundu yumoyu avelili akusunuka kufuma Yelusalemu akuyenda Yeliku. Pakaveyi mudeha, vamkamulili vapoki, vampokili findu na kumtova, vamleka kawonja pala dabadaba. ");
INSERT INTO ndj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Njuka mtambika yumu apitili deha yila. Pamuwonili, achamili mumbali. ");
INSERT INTO ndj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wuwula na Mlawi yumu, pafikili pala, kamuwona, kapita pambali. ");
INSERT INTO ndj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lakini Msamaliya yumoyu aveli mumwanja, pafikili pala paveli yula mundu, mweni pamuwonili kamuwonela lusungu. ");
INSERT INTO ndj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kamuselelela, kamtaya mufilonda fyaki mafuta na difwayi, kamuwopa na kampaka mu chihongu waki, kamuyegha kunyumba ya vahenja kumulwasha. ");
INSERT INTO ndj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chilawu yaki katola mbiya sha ijala ya majuva mavili, kamgayila yula mkola kaya, kamuwombela, ‘Mlwasi mundu ayu na chochosi daumgayili kandi, dahombi pang'uya.’” ");
INSERT INTO ndj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu kadasha kandi, “Gati ya ava vatatu, ndi yoti yalangushili mjofi waki yula mundu yaduliyiliwi na vapoki?” ");
INSERT INTO ndj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mundu yamanyili unofu Malawu va Chapanga vamupili Musa, ayangulili, “Yula amuwonilili lusungu.” Yesu kamuwombela, “Yendi ukagoli wuwowu.” ");
INSERT INTO ndj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pavaveyi mumwanja, vayingila kuchijiji chimu na mdala yumu yivamkemeyi Malita, kamlalika kaya yaki. ");
INSERT INTO ndj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malita avelili na mkulu mundu vakamkemeyi Maliya, ayu ayikalili pabehi na Bambu akapikanisheyi mawuli vaki. ");
INSERT INTO ndj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lakini Malita aveli akukimbanikila milandu yingi. Kamyendela Yesu, kumuwombela, “Bambu, ukuwona nahau kavifya ng'odu, mlongu wangu kuneka ngukimbanika weka yangu? Topi umuwombeli, andangi.” ");
INSERT INTO ndj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lakini Bambu kamyangula, “Malita, Malita, ukukimbanika na kuyiyasha na milandu yitangalili. ");
INSERT INTO ndj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Chindu chimu hela chitalama. Maliya kashawula chindu cha nyanyi nesu, cheni kwa hela mundu dampoki.” ");
INSERT INTO ndj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lijuva limu, Yesu aveli mahali pamopa akudadava. Pakamalishili kudadava, mwanachuli yumu kamuwombela, “Bambu, utuwuli kudadava kucha Yohani mbatisha wavawulili vandundami vaki.” ");
INSERT INTO ndj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu kayangula, “Pamudadava, mulongi: ‘Tati: Litawa lyaku ling'alili lijumiwi, wutwa waku wisi. ");
INSERT INTO ndj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tukuluva utugayili filivi fyetu lijuva kwa lijuva. ");
INSERT INTO ndj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tukuluva utupomeli sambi shetu, kucha wula yufwi wutuvapomela vosi vatuvifyili, ukotoo kututaya mumayeshu.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu kavawombela vanachuli vaki, “Leki muyenu yumu kayenda kwa ghanja waki pamihi nendu, kamuwombela, ‘Ghanja, dekudeku unyasimi mibumunda mitatu. ");
INSERT INTO ndj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ghanja wangu kapitila kayangu kava mumwanja na nenga nahela chindu cha kumgayila.’ ");
INSERT INTO ndj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na mweni angavili kamugati angamuyangulili, ‘Kotoo kunyasha! Ndata kala litatilu. Nenga na vana vangu tuwonja, nguwesha ng'odu kuyimuka ngugayili!’ ");
INSERT INTO ndj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngukuwombela, hata naha dayimuki ng'odu amgayili mibumunda kwanongwa mweni ghanja waki, lakini dayimuki na kumugayila chila chadayila kwanongwa akuyendelela kumuluva.” ");
INSERT INTO ndj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nguvawombela, “Pamuluva dampati, pamsaka damuwoni, pamukuta mulyangu damufuwuliwi. ");
INSERT INTO ndj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yoyosi yaluva dapati, yasaka dawoni na yakuta mulyangu dafuwuliwi. ");
INSERT INTO ndj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mwana pamuluva tatimundu somba, wuli damgayili njoka badili ya somba? ");
INSERT INTO ndj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na pamuluva liyi, wuli damgayili nyunji? ");
INSERT INTO ndj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nga yumwi, hata leki muvavifyi mumanya kuvagayila vana venu findu finofu, nakaka tati wenu wa kumbindi dagoli nesu, davagayili Mfuki Mng'alili kwa vala yivamluva.” ");
INSERT INTO ndj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lijuva limu Yesu aveli akumvinga chinyamkela amgolili mundu yumu kava ngadeta. Topi ayu chinyamkela kamfuma, yula ngadeta kawesha kudeta, hata lipinga lya vandu vayikanganika. ");
INSERT INTO ndj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lakini vandu vamu vadeta, “Akuvavinga finyamkela kwa liwovi lya Besibuli, mkomi wa finyamkela.” ");
INSERT INTO ndj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Vamonga vamyeshili vadayilili avalangushili mihilu valoli mweni kajumiliwa na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lakini Yesu amanyili veni chivayihola, kavawombela, “Wutwa wowosi wuvelili witapula daulemwi kuwoloka. Kaya yoyosi yiveli yiyitapula dayilemwi kuwoloka. ");
INSERT INTO ndj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Leki wutwa wa Lijangavandu, mani wukwitapula, wutwa waki dauwesi wuliwuli kuwoloka? Mukudeta liki, nguvavinga finyamkela kwa liwovi lya mkomi wa finyamkela Besibuli? ");
INSERT INTO ndj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mani nguvingavinga finyamkela kwa liwovi lya mkomi wa finyamkela Besibuli, vana venu vakuvinga kwa liwovi lya ghani? Kwa liwovi lya Besibuli? Ng'odu. Vana venu yumwi davavahighi wafu wa yumwi. ");
INSERT INTO ndj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lakini panavavinga finyamkela kwa liwovi lya Chapanga, topi umanyi wutwa wa kumbindi kwa Chapanga ufika kala kayenu. ");
INSERT INTO ndj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mundu aveli na liwovi padima nyumba yaki kwa lisomelu, findu fyaki fyosi fisiyala ngali kuhijiwa. ");
INSERT INTO ndj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lakini, payisa yaveli na liwovi likomi, pamdula na kumtova, ayu dampoki misomelu yaki yosi ayidumbileyi na kubajanga. ");
INSERT INTO ndj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yoyosi yalema kuva na nenga, akujumila ng'odu nenga na yoyosi yalema kusosola pamu na nenga, akumwaghanga. ");
INSERT INTO ndj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Chinyamkela pafuma kwa mundu, akushengeta kuchivala kusaka pa kupumulila. Pakapota akuyiwombela mweni ‘Dang'uyi kayangu kufumili’. ");
INSERT INTO ndj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pawuya, akwiwona yila nyumba vafyayila na valemba. ");
INSERT INTO ndj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Topi akuyenda kuvatola finyamkela vamonga saba pitu mweni, vosi vakuyenda kumwingila mundu yula. Ngalilu ya mundu ayu ponopa yikuvipa munu pitu dahili.” ");
INSERT INTO ndj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Paghaveyi akudeta afi, mdala yumu mulipinga lila lya vandu, kadeta kwa kulandusha, “Ngiba mdala yakulelili na kukuyongesha!” ");
INSERT INTO ndj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu kayangula, “Lakini ngiba nendu vala vakupikanisha filongu fya Chapanga na kufikamula.” ");
INSERT INTO ndj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lipinga lya vandu paliyongishekili, Yesu kavawombela, “Chileli achi ndi chileli cha wafu, chikudayila chilangushilu, lakini dachipati ng'odu chochosi cha kulangusha ila wula muhilu wa Yona. ");
INSERT INTO ndj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kucha Yona aveli chilangushilu kwa vandu va Ninawi na mwana va mundu daghavi chilangushilu kwa chileli achi. ");
INSERT INTO ndj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mhumbu wa kundambalilu dawoneki chipindi ulelwa awu ukuhighiwa na mweni dachihighi kucha chivifya. Nongwa mweni atyangili kufumila kutali, kayisa kupikanisha filongu fya luhunja fya Solumoni na kumbi apa pana mkomi pitu Solumoni. ");
INSERT INTO ndj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Vandu va Ninawi davawoneki chipindi cha kuhigha, veni davahighi ulelwa awu kucha uvifya. Nongwa va Ninawi vapomela, kwanongwa Yona avalandulili filongu fya Chapanga na kumbi apa pana mkomi pitu Yona! ");
INSERT INTO ndj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kwa hela mundu yakwata luliku na kugubika na chiyungu, ila tukuvika kumbindi ya chindangawala ili vandu vayingili mugati vapati ngesha ya kulolela. ");
INSERT INTO ndj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lisu lyaku ndi limbamba lya mvili waku, paliva linofu, mvili waku wonda dawuvi na ngesha. Lisu lyaku paliva litojoka na mvili waku weni dawuvi mulwisa. ");
INSERT INTO ndj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Topi uloleyi, ngesha yivelili mugati yaku yikotoo kuva lwisa. ");
INSERT INTO ndj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mani mvili waku wonda wuna ngesha, mvili awu daung'ali nesu kucha wula limbamba lya motu likung'alika.” ");
INSERT INTO ndj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu pakaywangeyi, Mfwalisayu yumu kamlalika kaya yaki mufilivi. Mweni kayenda, kuyikala kulya filivi. ");
INSERT INTO ndj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ayu Mfwalisayu ayikanganikili kumuwona Yesu akulya filivi ngajila kunava. ");
INSERT INTO ndj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bambu kadeta, “Yumwi Mafwalisayu Mukung'ofuwa fikombi na sahani panji hela, lakini mugati yenu mumema lukilu na wafu. ");
INSERT INTO ndj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Vapufi yumwi! Yagolili fya panji, yuyula ng'odu yagolili na fya mugati? ");
INSERT INTO ndj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Muvagayili vagaju fila findu fivelili mugati na fyosi dafiwi fya nyanyi kwa yumwi. ");
INSERT INTO ndj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Lakini pishu yumwi Mafwalisayu! Kwa nongwa mkusumula vandu zaka hata kwa midasi ya kutelekela filivi, linjambu na makolu vosi na kunu mukulola ng'odu haki na kumdayila Chapanga. Milandu ayi dayiwi mukukamulila mukotoo kuyivasuva na fila fimonga. ");
INSERT INTO ndj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Pishu kwa yumwi Mafwalisayu! Mkudayila kuyikala kuulongolu mahali pa vakomi munyumba ya kudadavila na kujambushiwa kwa ndundamilu musoku. ");
INSERT INTO ndj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pishu kwa yumwi Mafwalisayu, kwanongwa muva kucha lyowu liveli lipala lingajila kuwoneka, vandu vakudubukila ngajila kumanya.” ");
INSERT INTO ndj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mundu yumu yamanyili nesu Malawu va Chapanga vamupili Musa kamuwombela, “muwula, kwa filongu fyaku fiwudetili kutujohola yufwi.” ");
INSERT INTO ndj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu kayangula, “Pishu na yumwi vawula va Malawu! Mukuvapapisha vandu misiwu yingajila kupapika, kunu mwaveni mkulemwa kukamula hata kwa chala chimu kuvatanga. ");
INSERT INTO ndj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Pishu hata kwa yumwi, yimujenga sembi nofu sha vambuyi va Chapanga, vavala vala vawulayiwili na vavaha venu. ");
INSERT INTO ndj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yumwi mwaveni mukutovilela na kuwona fila fivagolili vavaha venu finofu, nongwa veni vavawulayili ava vambuyi va Chapanga na yumwi mukujengela sembi shawu. ");
INSERT INTO ndj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Luhunja lwa Chapanga lukudeta nahau, ‘Dandivayegheli vambuyi na ndundami, lakini davavawulayi vamonga na kuvagobola vamonga.’ ");
INSERT INTO ndj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ponopa damuchiwoni dachivafumbukili, chileli achi dachitoviwi na kuhomba mwasi wuyitikili wa vambuyi vosi kukandila mlima pawulumbiwili, ");
INSERT INTO ndj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kufumila mwasi wa Abeli wuyitikili mbaka mwasi wa Sakaliya vamuwulayili pagati ya fyalu kunyumba ya Chapanga. Yina nguvawombela ulelwa awu chamotu davachiwoni kwa fila fivagolili. ");
INSERT INTO ndj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Pishu yenu, yumwi vandu va Malawu! Mufisa funguwu sha mlyangu wa luhala, mwaveni muyingila ng'odu, kunu muvakika vala yivayesha kuyingila, vakotoo kuyingila!” ");
INSERT INTO ndj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu pakafumeyi pala, vala Mafwalisayu na vawula va Malawu vakandili kuyishosha na kuyilakalila na kumdasha minasha yitangalili. ");
INSERT INTO ndj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Vakamteghili vapati pa kumuwomesha kwa filongu fyaki. ");
INSERT INTO ndj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yesu akung'ong'oleka kwa Mafwalisayu na vawula va Malawu, chipindi vandu vamanyikili pavaveghi vayikungula hata vakayivatangeyi, Yesu avawombilili kukandila vandundami vaki, muyiloleyi na mawuli va Mafwalisayu, nongwa va uyengeleji. ");
INSERT INTO ndj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chila chigubikiliwi dachigubutuliwi, chila chiyifisili dachiwoneki pawelu. ");
INSERT INTO ndj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nahau chila mdetili mulwisa, vandu davapikinishi kulwengi na chila chimpwepweyi pa chifisu milyangu yitatiwa, dafilanduli kulipaghali lya nyumba. ");
INSERT INTO ndj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nguvawombela yumwi vaghanja vangu, mukotoo kuvatila vala yivawulagha mvili, vakotoo kugola chindu chingi kandi. ");
INSERT INTO ndj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dandivalangushi yula wa kumtila, mumtili Chapanga, yula pakuwulagha kana liwovi lya kukuyasila mumotu wa lifumbika. Yina nguvawombela, mumtili ayu. ");
INSERT INTO ndj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Yikumanyika kucha sheveli muhanu vakuhemesha kwa migwala mivili? Lakini kwa Chapanga akwivasuwa ha hata sheveli yumu. ");
INSERT INTO ndj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hata fwili sha mumitwi yetu sivalangiwa shosi. Mukotoo kutila, yumwi mtalama kupita sheveli vatangalili! ");
INSERT INTO ndj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nguvawombela nakaka, mundu yajumila pavandu ayu wa nenga, mwana wa mundu mweni damujumili kwa makungu wa Chapanga kucha mundu ayu waki. ");
INSERT INTO ndj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lakini, mundu yanema nenga pavandu, mwana wa mundu na mweni damulemi kwa makungu va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yula yadeta filongu fya kumlema Mwana wa Mundu, dapomiliwi, lakini yamjowola Mfuki Mng'alili dapomeliwi ha. ");
INSERT INTO ndj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pavayegha yumwi munyumba ya kudadavila na kwa vanauwesu na vatavala, mukotoo kuva na lyova wuliwuli damuyiseyi awu ndambu liki damdeti. ");
INSERT INTO ndj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nongwa chipindi achi Mfuki Mng'alili davawuli chila cha kudeta.” ");
INSERT INTO ndj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundu yumoyu mulipinga lila lya vandu kavawombela, “muwula, muwombeli mlongu wangu tuvaghani findu fya mbala fyatulekilili tati.” ");
INSERT INTO ndj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu kamuyangula, “Ghanja, ghani Kamika nenga nduvi vakuvalamulila awu mnjalamila wenu?” ");
INSERT INTO ndj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Topi kavawombela vosi, “Muyiloleyi na ndambu shosi sha luhujulu, nongwa unofu wa mundu akwidumbila findu fitangalili avelili nafyu ha.” ");
INSERT INTO ndj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pambeli kavawombela chilangushilu achi, “Kwavelili mlundamali yumu ayu chitava chaki amotili. ");
INSERT INTO ndj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mlundamali ayu kayihola kumoyu vaki, ‘Dagoli wuliwuli nimweni nahela pakuvika fibeniwili? ");
INSERT INTO ndj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dagoli naha, dabomoli sanja shangu na dajengi ngomi nesu. Nimweni damiki amu fibeniwili fyosi na mali shangu. ");
INSERT INTO ndj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ponopa nguwesa kuuwombela moyu wangu, ponopa ndiva nawu lusanja lwa kuvanja kwa myaka yitangalili. Dauyinomi kulya, kulanda na daukenuki.’ ");
INSERT INTO ndj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lakini Chapanga amuwombilili, ‘Kwa mpufi yuwi, lelu pamii moyu waku dautoliwi. Na findu fila fyosi fiwulundikili dafiwi fya ghani?’ ” ");
INSERT INTO ndj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu amalilili pakawombeyi, “Yina dayivi kwa mundu yayilundikila mali nweni, lakini mweni kwa Chapanga, mlundamali ha.” ");
INSERT INTO ndj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kandi Yesu avawombilili vandundami vaki. Nongwa ayi nguvawombela, mukotoo kuyipwelesha ngalilu yenu kucha damulyi liki na mukotoo kuyipwelesha mivili yenu kucha dayifwali liki. ");
INSERT INTO ndj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ngiba unofu pitu filivi na mvili utalama pitu yingwa. ");
INSERT INTO ndj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mloli kukandila dahili vangungulu, vakukweta ng'odu, vakubena ng'odu na vahela lusanja. Na Chapanga akuvagola vayikuti. Yumwi mtalama munu pitu vambongu! ");
INSERT INTO ndj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yumwi ghani kwanongwa ya kukimbanika kwaki, akuwesha kuyiyongishela padokwa saa shaki kuyikala kumlima? ");
INSERT INTO ndj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Topi mukulemwa kugola findu fidokwa kucha achi, kwa liki wuvi ukuyipwelesha milandu yingi? ");
INSERT INTO ndj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mloli toni mawua pavamelili. Yakugola ha chichuku wala kugola yingwa shawu. Lakini nguvawombela, hata Solumoni mweni na ukomi waki wosi avalilili nyanyi ha kupita lina limu. ");
INSERT INTO ndj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Topi payiva Chapanga nalelu akulifwalisha nahau lidasi lya kufitawa payiva chilawu likuyasiwa mumotu, wuli davavagoleli wuwu yumwi? Yumwi mwavandu mvelili na ujumilwa mdokwa! ");
INSERT INTO ndj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Topi mukotoo kupuva luhala, mkusaka kulya na liki damunyuwi. ");
INSERT INTO ndj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nongwa afi fyosi vakukimbanikila vala vandu vosi vangalimesu kumumanya Chapanga. Tati wenu wa kumbindi kamanya mukudayila findu afi. ");
INSERT INTO ndj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mkukimbanikila kukandila wutwa wa kumbindi kwa Chapanga na fimonga davagayili kwa kuvayongishela. ");
INSERT INTO ndj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mkotoo kutila, yumwi vandumindumi vangu! Nongwa Tati wenu wa kumbindi akudayila kuvapa wutwa. ");
INSERT INTO ndj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mchulusi mali shenu mukavagayili vagaju mbiya asi. Muyigoleli mihaku yingali kusakala na kwivikila lusanja kumbindi kwa Chapanga kula dayiyangili ng'odu. Kula vefi davaseleli ng'odu na davalyi umehi ha. ");
INSERT INTO ndj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pala pawuvelili ulundamali mali waku, ndi moyu waku dawuvi bahala. ");
INSERT INTO ndj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Muvi kala kuhidika lufunga muchiwunu na taa shenu sivi sikuyaka. ");
INSERT INTO ndj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Muvi kucha vagolafichuku vakulembelela bambu vawu awuyi kufuma kulihungu lya kuheta, ili vamfuulili mlyangu pakabisha. ");
INSERT INTO ndj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ngiba vala vagolachichuku veni bambu vawu pakawuya davawoni vayikala mesu! Yina nguvawombela ayu bambu dayiwopi lufunga muchiwunu. Davakalishi pamesa kuvakimbanikila. ");
INSERT INTO ndj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Leki pawuya pamii pamandandu awu njowolu pavika na kuvawona vayikala mesu, ngiba ava vagolafichuku! ");
INSERT INTO ndj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mumanyi, leki muna nyumba angamanyili kucha mwifi dayisi chipindi liki, angagungili mesu, wala angayilekili ng'odu nyumba yaki vayibomoli. ");
INSERT INTO ndj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yumwi damuyikali kala, nongwa mwana va mundu dayisi saa yingajila kuyimanya.” ");
INSERT INTO ndj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petili kamuwombela, “Bambu, chilangushilu achi ndi kwa yufwi hela awu kwa vandu vosi?” ");
INSERT INTO ndj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bambu ayangulili, “Ghani yaveli mgolafichuku munofu na yaveli na luhala, daghavi Bambu vaki damviki mkomi wa vagolafichuku vaki ili avapi filivi chipindi cha nyanyi? ");
INSERT INTO ndj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ngiba ndumindumi ayu, payiva Bambu vaki pakawuya damuwoni kagola nahau. ");
INSERT INTO ndj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nakaka, nguvawombela dandimupi ukomi na mali shaki shonda. ");
INSERT INTO ndj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lakini mani ndumindumi ayu payiwombela mundima, ‘Bambu vangu kahava munu kuwuya.’ Kandi akandili kuvatovanga vagolafichuku vayaki, valulumi awu vadadala na kulya, kulanda na kulovela, ");
INSERT INTO ndj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bambu vaki dawuyi lijuva lingajila kumanyika na saa angali kuyimanya, damdamuli mgolafichuku ayu muwafu na kumvika mulipinga limu na vangajila kumjumila. ");
INSERT INTO ndj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ndumindumi yaveli kamanya fyadayila bambu mundu. Lakini akwivika kala ha na kugola ng'odu fyadayilili bambu yula, datovangiwi nesu. ");
INSERT INTO ndj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lakini yula yamanya ng'odu bambu waki fyadayila, ayu dateshiwi ngajila kumanya kwaki, datovangwi padokwa. Yamuvikilili fitangalili dapati fitangalili nesu. ");
INSERT INTO ndj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nyisa kukosha motu kumlima, ingavelili nyanyi ungayakili kala! ");
INSERT INTO ndj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ndina ubatishu ngudayiliwa kuupapa na dagobuleki mbaka mwishu! ");
INSERT INTO ndj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mkucha nyisa kuyegha kusika kumlima? Ng'odu kwahela kusika ila kuvalekanisha. ");
INSERT INTO ndj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Na kufumila ponopa, kaya ya vandu muhanu davalekani, vatatu davalevi na vavili na vavili kwa vatatu, ");
INSERT INTO ndj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","tati dalevi na vana vaki valumi na mawu dalevi na vana vaki vadala, mkohanu dalevi na mdala wa mwana waki na ayu dalevi na mukamwana.” ");
INSERT INTO ndj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu kavawombela kandi lipinga lya vandu, “Pamuwona mafundi pavafuma mwambu wa kuchanya, tepu mkucha ndonya dayitonyi na nakaka yikutonya. ");
INSERT INTO ndj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pamuwona likumba lya kalihingila likupula, mkudeta dakuvi na lijuva na yikuva wuwu. ");
INSERT INTO ndj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yumwi muvafyangu! Mkumanya kutunga ndambu panji kuveli kwa kulola ndambu ya mlima na kululanga, nongwa liki, mukulemwa kumanya mana ya fipindi afi?” ");
INSERT INTO ndj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nongwa liki mukulemwa kukanda mwaveni milandu minofu ya kugola? ");
INSERT INTO ndj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nongwa kucha muhigha waku akukuyegha kuhighiwa, yingavelili ngiba kwa yuwi mujovi pamuva mkali mudeha, ili akotoo kukuyegha kwa muhigha, mweni muhighi dakuyeghi kwa machonda, mweni davakutayi muchijaka. ");
INSERT INTO ndj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yina ngukuwombela dawufumi ng'odu amu, mbaka umalili kuhomba ligwala lyaku lya mwishu.” ");
INSERT INTO ndj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chipindi achi vandu vamu vayisili vamuwombilili Yesu milandu ya vandu va Galilaya, Pilatu avelili kavawulagha chipindi pavaveghi vakugola mitambiku? ");
INSERT INTO ndj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu avawombilili, “Wuli mukuyihola vandu va Galilaya ava vaveli vavifya pitu Vagalilaya vamonga vosi, nongwa vagobuliwa nawula? ");
INSERT INTO ndj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nguvawombela ng'odu! Lakini mwaveni, pamupomela ng'odu, sambi shenu damupeli kucha veni. ");
INSERT INTO ndj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Awu vala lilongu na vanani wuvawilili mnala kula Siloamu, vasova mukuyihola veni vavelili na sambi kupita vamonga vosi vayikalili Yelusalemu? ");
INSERT INTO ndj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nguvawombela ng'odu! Lakini hata yumwi pamupomela ng'odu, damupeli kucha veni.” ");
INSERT INTO ndj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pambeli Yesu avawombilili chilangushilu achi, “Mundu yumu ayu avelili na likuyu muchitava chaki. Mundu ayu kayenda akadayileyi kunokola fivelekwa fyaki, lakini awonili lilela ha hata chivelekwa chimu. ");
INSERT INTO ndj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Topi amuwombilili mgolafichuku waki, ‘Loli! Kwa myaka mitatu yimelili ngwisa ngadayileyi kunokola fivelekwa fya likuyu ali, mbata chindu ha. Lidumuli! Nongwa liki uganga ukuyanangika hela?’ ");
INSERT INTO ndj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lakini mweni ayangulili, ‘Bambu, tulileki kandi mwaka awu, dandiwushengiteli kulima na kulivikila mboleya. ");
INSERT INTO ndj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pamonga dalileli fivelekwa mwaka wuyisa awu, nyanyi, leki naha ng'odu, topi ukuwesha kulidumula.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu avelili akuvawula munyumba ya kudadavila yimu mulijuva lya kupumulila. ");
INSERT INTO ndj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na apa pavelili na mdala yumu yavelili mtami kwa myaka lilongu limu na minani avelili na chinyamukela kamwingila. Kwa nongwa ayi, mvili vaki wavelili ugondama hata akulemwa kuwoloka chimimi. ");
INSERT INTO ndj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu pamuwonili, kamkema, kamuwombela, mawu utami waku wunana. ");
INSERT INTO ndj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Amuvikilili mawoku na tepu mvili waki uwoloka kandi, kamjuma Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lakini mkomi wa nyumba ya kudadavila akalalili kwanongwa Yesu avelili kamlowola mawu ayu lijuva lya kupumulila. Topi kavawombela vala vandu vayisili pala, “Muvanawu majuva sita va kugola fichuku. Topi mwisi majuva ava avalowoli matami venu, lakini mukotoo kuyisa Lijuva lya Kupumulila!” ");
INSERT INTO ndj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Apa Bambu kayangula, “Yumwi vafyangu! Yumwi mukuvafuwulila vasenga venu awu vachihongu venu kufuma muligeleli mukuvayegha kulanda machi, hata mulijuva lya kupumulila. ");
INSERT INTO ndj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hinapawu apa kuna biti wa uleli wa Ibulahimu, Lijangavandu amugolili ndevindevi kwa chipindi cha myaka lilongu limu na minani. Wuli yaveli nyanyi ng'odu kumfuwulila chifungu chaki lijuva lya kupumulila?” ");
INSERT INTO ndj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pamalilili kudeta afi, vala valimbaneyi nawu vawonili chindipa lakini vandu vosi vasekilili nendu kwanongwa ya milandu yosi yagolili. ");
INSERT INTO ndj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu avadashili, “Wutwa wa kumbindi kwa Chapanga wukuyifwana na liki? Daninganishi na liki? ");
INSERT INTO ndj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yiva kucha mbeyu ya likuyu lyatolili mundu yumu na kukweta muchitava chaki, yamelili na kuva libiki. Vambongu vajenga miyumba yawu mumitafyi yaki.” ");
INSERT INTO ndj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu adashili kandi, “Daninganishi wutwa wa kumbindi kwa Chapanga na liki? ");
INSERT INTO ndj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kucha mawu yumoyu yatolili chimela na kuhasha pamu na ukova madebi mavili na nusu pambeli ukova wosi uwumuka.” ");
INSERT INTO ndj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ayendilili na mwanja waki kuyenda Yelusalemu, kunu paapita mumbwani na mufijiji, palandula milandu ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu yumu ayu kamdasha, “Bambu vandu davalowuliwi ndi vadokwa hela?” Yesu kavawombela, ");
INSERT INTO ndj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mkamali kuyingilila mlyangu wunyepili, nongwa nguvawombela, vatangalili davayesi kuyingila lakini davalemwi. ");
INSERT INTO ndj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chipindi dachiyisi mukola kaya datandamuki na kutata mlyangu. Yumwi damuwoloki panji na kukanda kuluva avafuwulili mlyangu, mukudeta, ‘Bambu, tufuwulili mlyangu.’ Lakini mweni davayanguli, ‘Ndivamanya ng'odu kumufumili!’ ");
INSERT INTO ndj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mwaveni damukandi kumuwombela, ‘Yufwi ndi vala twalili na kulanda pamu na yuwi na yuwi wawulili mufijiji fyetu.’ ");
INSERT INTO ndj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lakini mweni dadeti, ‘Yumwi mfuma koti, muwuki pawushu yangu, yumwi mwavosi mwagolili sambi!’ ");
INSERT INTO ndj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Apa dapavi na kulila na kugelijula minu, chipindi damuvawoni Ibulahimu, Isaka na Yakobi na vandundami vosi muwutwa wa kumbindi kwa Chapanga, lakini yumwi vavadangila panji. ");
INSERT INTO ndj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vandu davayisi kufuma kundamba na kuchanya, kufuma kwavayighanji na kuyikala mulihungu kuwutwa wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yina vala vavelili kumbeli, davavi kuulongolu na vala vavelili kuulongolu davavi kumbeli.” ");
INSERT INTO ndj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chipindi chichila chila, Mafwalisayu na vandu vamonga vamuyendilili Yesu vamuwombela, “Wuki apa yendi mahali pengi, nongwa Helodi akudayila kukuwulaya.” ");
INSERT INTO ndj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu kavayangula, “Muyendi mukamuwombeli yula chingekembi, ‘Nalelu na chilawu nguvinga finyamkela na kulowola vatami na lijuva lya tatu damalili chichuku changu.’ ");
INSERT INTO ndj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hata naha nalelu na chilawu na pawucha, lasima nyendileli na mwanja wangu, kwanongwa nyanyi ha mbuyi kuwulayiwa panji ya Yelusalemu.” ");
INSERT INTO ndj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yelusalemu! Yuwi Yelusalemu! Ukuvawulaya vambuyi na kuvaguma miganga vala wuvalayishili kwa yuwi! Myanja miningi ngadayileyi kuvavika pamu vana vaku kucha nguku vavafisa vana vaki pasi ya mbapatilu shaki, lakini valemili. ");
INSERT INTO ndj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Topi, damlekewi nyumba yenu. Yina nakaka nguvawombela, damung'oni ha mbaka chipindi dachifiki damuwombi, Mumnemeli ayu yayisa kwa litawa lya Bambu.” ");
INSERT INTO ndj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lijuva lya kupumulila limu, Yesu ayendili kulya filivi kaya ya mkomi yumu wa Mafwalisayu, vandu vavelili pala vavelili vakumlolesha. ");
INSERT INTO ndj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mundu yavelili na utami wa kumema mawoku na mawulu ayisili kwa Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu avadashili vawula va Malawu na Mafwalisayu, “Wuli Malawu vetu vakutujumisha kumulowola mundu lijuva lya kupumulila?” ");
INSERT INTO ndj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lakini veni vayikalili jii. Yesu kamkamula yula mtami, kamulowola, amulekili ayendi. ");
INSERT INTO ndj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pambeli kamuwombela, “Ghani wa yumwi yaveli na mwana waki awu senga waki padubukila mumyowu, angamuwushili ng'odu mulijuva lya kupumulila?” ");
INSERT INTO ndj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lakini veni valemili kumyangula pavadashili nawula. ");
INSERT INTO ndj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Chilangushilu chila, Yesu avawonili vala vavalalikili pavayihaga pahali pa vakomi, kavawombela, ");
INSERT INTO ndj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kucha mundu pakulalika kulihungu lya kuheta, ukotoo kuyikala pahali pa vakomi, pamonga kamlalika wingi mkomi pitu yuwi. ");
INSERT INTO ndj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na mwenikaya wenu yumwi vavili dayisi na kuvawombela, ‘Mlekeli ayu chigoda.’ Apa dawuvi na soni kwa vandu vosi na dauyendi kuyikala kuchigoda cha kumbeli. ");
INSERT INTO ndj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mani pakulalika kulihungu, uyikali kuchigoda cha kumbeli, pakayisa mwenikaya waku akuwombeli, ‘Ghanja, wisi kunu kuwulongolu, kuchigoda cha ukomi.’ Apa dawuvi kupata kufumala kumesu ya vandu vosi uyikalili pamu nawu. ");
INSERT INTO ndj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nongwa yoyosi yayikwesha dasunushiwi na yayisunusha, dakweshiwi.” ");
INSERT INTO ndj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pambeli Yesu amuwombilili na yula amlalikili, “Mani pauvakimbanikila vandu ndilya ya pamusi awu lumihi kotoo kuvalalika vaghanja vaku awu valongu vaku awu vajofi vaku vavelili valundamali, vakotoo kuyisa veni kukulalika umweni davakuhombi chila chivagolilili. ");
INSERT INTO ndj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Badili yaki, paugola ndilya, valaliki vagaju, fikwavakwava, ndevindevi na vangalimesu. ");
INSERT INTO ndj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Na yuwi dawupati usangi, nongwa ava vahela cha kukuhomba. Nongwa Chapanga dakugayili fupa yaku Chipindi vandu goleki pavashukuka.” ");
INSERT INTO ndj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yumu waa vala vavelili vayikalili pamu na Yesu adetili, “Kucha ngiba mundu yula daghalyi filivi muwutwa wa kumbindi kwa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu kamyangula, “Mundu yumu agolili lihungu likomi, kavalalika vandu ngenju. ");
INSERT INTO ndj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chipindi cha lihungu pachifikili amtumili ndumindumi waki akavalaliki vayisi, findu fyosi fiva kala. ");
INSERT INTO ndj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lakini vosi, yumu yumu, vakandili kaluva avapomeli. Wakwaa kamuwombela mgolafichuku nenga hemela chitava, ponopa nguyenda kuchilola, ngukuluwa umbomeli. ");
INSERT INTO ndj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Monga kadeta, ‘Nenga hemela vasenga lilongu wa kulimila, ponopa ndina mwanja nguyenda kuvayesha, deku umbomeli.’ ");
INSERT INTO ndj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kandi wingi kadeta, ‘Nguyenda kuheta mdala daweshi ng'odu kwisa.’ ");
INSERT INTO ndj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mgolafichuku ayu kawuya kumuwombela Bambu waki milandu yila. Yula mwenikaya akalalili, amuwombilili ndumindumi waki, ‘Lopukeshi yendi kudeha na mufijoku joku, uvayeghi munyumba amu vagaju, fikwavakwava, vangalimesu na ndevindevi vamonga.’ ");
INSERT INTO ndj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pambeli ndumindumi ayu adetili, ‘Bambu, milandu yigoleka kucha wung'ombili, lakini yikali hela fwasi.’ ");
INSERT INTO ndj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yula Bambu kamuwombela ndumindumi, ‘Yendi kudeha na kumbepitela sha kumbwani uvang'ang'aniki vandu vayingili ili nyumba yangu yimemi. ");
INSERT INTO ndj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nguvawombela, kwa hela hata yumu wa vala avalalikili dayisi kulihungu lya nenga.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Apa lipinga lya vandu vatangalili vayikovikela pamu na Yesu. Topi kavaghalambukila vandu kavawombela, ");
INSERT INTO ndj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","mundu aweshi ha kuva mwanachuli wangu pangajila kundama nenga pitu vamtama tati waki, mawu waki, mdala waki, wavatama vana, valongu mundu valumi kwa vadala, hata kuyitama mweni, daghavi mwanachuli wa nenga ha. ");
INSERT INTO ndj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mundu yatola ng'odu lupingika lyaki na kungovekela, daghavi mwanachuli wa nenga ha. ");
INSERT INTO ndj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nongwa ghani Gati ya yumwi padayila kujenga mnala dayikali kukandila pasi agoli tolitoli, amanyi kanashu mbiya sha kumalishila? ");
INSERT INTO ndj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mani pakakanda lusiki, pambeli kalemwa kumalishila, vandu davamuseki. ");
INSERT INTO ndj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Vakawombeyi, ‘Mundu ayu akandili kujenga, lakini kamalila ha.’ ");
INSERT INTO ndj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Awu liki yavelili akudayila kuyenda kuyiminya na wutwa wingi, akudayiliwa ayikali tangila na kuyihola dawesi, kana machonda vaki lilongu alufu dalevi na yula yavelili na machonda alufu milongu mivili? ");
INSERT INTO ndj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kucha dawoni daweshi ng'odu, davalayishi vanjagila kudayila vayikali kwa kusika chipindi ayu mutwa mumonga akali hela kutali. ");
INSERT INTO ndj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wuwula wula, kwa hela hata mundu yumu pagati ya yumwi daghavi mwanachuli wa nenga, mani palekeshela ng'odu findu fyosi fyaveli nafyu. ");
INSERT INTO ndj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munyu wa nyanyi, lakini pawusuka kunova kwaki dawuyigoli liki yikoleli kandi? ");
INSERT INTO ndj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yiva chindu ha, wala kwa miganga awu kwa mbolea, vandu davayiyasili kutali. Avelili na majeji na apikanishi!” ");
INSERT INTO ndj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lijuva limu, vasumula mbiya na vavelili na sambi vatangalili vayendili kumpikanisha Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafwalisayu na vawula va Malawu vakandili kung'ong'oleka, “Mloli mundu ayu! Akuvalalika vavelili na sambi, kunu akulya nawu!” ");
INSERT INTO ndj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu kavayangula kwa kuvawombela chilangushilu: ");
INSERT INTO ndj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Muyenu yumu wa yumwi kava na vafungami mya, pawona yumu wa vala kayamila, dagoli liki? Davaleki vala milongu tisa na tisa kumidasi na kuyenda kumusaka yula yayaghamilili mbaka amuwoni? ");
INSERT INTO ndj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pamupata, damupapi mumakombi kunu pasekilela. ");
INSERT INTO ndj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pafika kaya, davakemi vaghanja mundu na kuvawombela, ‘Muyisi mulyi na kulanda pamu na nenga, kwanongwa ndimuwona fungami wangu yayaghamilili.’ ");
INSERT INTO ndj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kandi nguvawombela, dayivi cheleli buja kula kumbindi kwa Chapanga kwa mundu yumu yavelili na sambi papomela, pitu vala vandu milongu tisa na tisa yivayiwona goleki, vakudayiliwa ng'odu kupomela. ");
INSERT INTO ndj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Awu mukucha wuli? Tudeti mdala yumoyu kana migwala lilongu limu lya mbiya, payaghamisha yimu, dagoli liki? Dakwati motu na kufyayila munyumba na kuyisaka kwa unofu mbaka ayiwoni. ");
INSERT INTO ndj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Payiwona, davakemi vaghanja vaki na vajofi vaki na kuvawombela, ‘Tufini, kwanongwa ndiliwona ligwala liyaghamilili.’ ");
INSERT INTO ndj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Topi nguvawombela, dayiwi nahawu kwa makungu va Chapanga davasekileli kwanongwa mundu yumu avelili na sambi kapomela.” ");
INSERT INTO ndj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu kayendelela kudeta, “Kwavelili mundu yumu ayu yavelili na vana vavili valumi. ");
INSERT INTO ndj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yula mdokwa kamuwombela tati mundu, ‘Tati, unyimbi mbala yangu.’ Na mweni kavaghanisha mali shaki. ");
INSERT INTO ndj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Vapitili majuva vatangalili ha, kahemesha mbala yaki, ayendili na mbiya shapatili mlima wa kutali, aku ayanangili mbiya. ");
INSERT INTO ndj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pamalishili findu fyosi, yafumbukili njala ngomi mlima wula na mweni akandili kughayanika. ");
INSERT INTO ndj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aluvili chichuku kwa mundu yumu wa kukula na mweni amuyeghili kufitava yaki kuvadima vangubi. ");
INSERT INTO ndj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Adobukelili kulya mibandi ya filivi fya ngubi, kwavelili kwa hela mundu yamgayilili chindu ghalyi. ");
INSERT INTO ndj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pakandili kupata luhala, kayihola, ‘Mbona kuna vagolafichuku vatangalili kwa tati wangu, vakulya na kufileka, kunu nenga ngusova njala? ");
INSERT INTO ndj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dang'uyi kwa tati wangu na kumuwombela, Tati, mifya kwa Chapanga na kwa yuwi. ");
INSERT INTO ndj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ukotoo kungema kandi mwana waku. Ugoli kucha mgolafichuku waku yumu.’ ");
INSERT INTO ndj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Topi akandili mwanja kuwuya kwa tati mundu. “Paghaveyi akali kutali, tati mundu amuwonilili lusungu, kamtuvilila, kamukusikila na kumunonela. ");
INSERT INTO ndj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana waki kamuwombela, ‘Tati, mifya kwa Chapanga na mifya kwa yuwi. Ukotoo kungema kandi mwana waku.’ ");
INSERT INTO ndj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lakini tati waki kavawombela vandumindumi vaki, ‘Mlopukeshi! Muyeghi yingwa sha nyanyi mukamfwalishi! Mumfwalishi peti na filatu! ");
INSERT INTO ndj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mumsinjili ngwada wa senga yanunili, tulyi na tusekileli! ");
INSERT INTO ndj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwa nongwa ayu mwana wangu, yavelili kasova, kumbi munofu, yavelili kayaghamila, lakini ponopa kawoneka.’ Vakandili kulumbilila. ");
INSERT INTO ndj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Chipindi achi mkulu mundu avelili akali kufitava. Pawuyeghi, pafikili pabehi na kaya apikinishili filumbi na ng'oma. ");
INSERT INTO ndj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Amukemili mvanda yumu, kamudasha, ‘Kuna liki?’ ");
INSERT INTO ndj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ayu mgolafichuku kamuwombela, ‘Mfwata waku kawuya kaya na tati waku kamusinjila ngwada yanunili kwanongwa kamupata kandi akali munofu.’ ");
INSERT INTO ndj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ayu kijana mkomi akalalili akalemeyi kuyingila munyumba. Tati waki kafuma panji na kumudedeveka ayingili. ");
INSERT INTO ndj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lakini mweni kayangula, ‘Uloli, myaka yosi ngukugolela chichuku, ngalihela kulema Malawu vaku hata mwanja wumu. Kunyimba liki? Ukali hela kunyimba hata gwada yumu ngagoli lihungu pamu na vaghanja vangu. ");
INSERT INTO ndj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lakini mwana waku ayu yayanangili mali shaku kwa vadala vawoni, pawuyili hela kumsinjila ngwada yula yanunili.’ ");
INSERT INTO ndj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tati waki kamuyangula, ‘Mwana wangu, yuwi kuva pamu na nenga majuva vonda na chimelili nachu ndi chaku. ");
INSERT INTO ndj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tukuyilata kugoli lihungu na kusekelela, kwanongwa ayu mlongu waku yavelili kasova, ponopa munofu, yavelili kayamila, lakini ponopa kawoneka.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu avawombillili vandundami vaki, “Mlundamali yumu ayu avelili na mgolafichuku waki. Mlundamali ayu vandu vamuwombilili, mgolafichuku waku akulya wafu mali shaku. ");
INSERT INTO ndj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yula mlundamali amukemili yula mgolafichuku, kamuwombela, ‘Ayi milandu liki ya yuwi yimbikanisha? Unangushi tolitoli yiwugolilili mumali shangu, nongwa dawuvi kandi mgolafichuku wangu ha.’ ");
INSERT INTO ndj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yula mgolafichuku kayihola, ‘Bambu wangu damingimingi chichuku, dagoli liki? Kuyenda kulima ngulemwa na kuluva nguwona soni. ");
INSERT INTO ndj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ponopa, manya cha kugola! Paminga chichuku, vaghanja vangu vaweshi kunibushila kaya yawu.’ ");
INSERT INTO ndj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Topi kavakema vananongwa va bambu waki, yumu yumu. Kamuwombela yula wa kwaa, ‘Yuwi ukali hela kumuhomba ningi bambu wangu?’ ");
INSERT INTO ndj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mweni kamuyangula, ‘Ndeleku mya sha mafuta va miseyituni.’ Yula mgolafichuku kamuwombela, ‘Toli hati yaku ya kuhomba, Lopukeshi wikali, yandiki hamsini.’ ");
INSERT INTO ndj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kamdasha munanongwa wingi kandi, ‘Na yuwi ukali hela kumuhomba ningi bambu wangu?’ Mweni kamuyangula, ‘Mikanda mya ya mupunga.’ Yula mgolafichuku kamuwombela, ‘Toli hati yaku ya kuhomba, yandiki milongu minani.’ ");
INSERT INTO ndj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Topi yula bambu kamjuma yula mgolafichuku muyananga mali kwanongwa avelili na luhunja. Kwanongwa vandu va mlimawu vanaluhunja mufindu fyawu pitu vala vandu va mulwengi.” ");
INSERT INTO ndj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu kayendelela kudeta, “Nenga nguvawombela, mutoli mali sha mlima awu muyikoli lighanja na Chapanga leki pasipela damulibushilwi kungalilu ya jola. ");
INSERT INTO ndj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yoyosi yaveli mwaminifu kwa milandu midokwa, daghavi mwaminifu kwa milandu mikomi. Yoyosi yangajila kuva mwaminifu kwa milandu midokwa, daweshi ha kuva mwaminifu kwa milandu mikomi. ");
INSERT INTO ndj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kucha yumwi mujumila ng'odu, kwa mali sivipili sha mlima, ghani davavapi sila mali sha nakaka? ");
INSERT INTO ndj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na kucha yumwi, vaaminifu ng'odu kwa mali sha mundu wingi, ghani davavapi mali shenu mwaveni? ");
INSERT INTO ndj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kwa hela ndumindumi yawesha kuvakimbanikila vabambu vavili kwa mwanja wumu, kwanongwa daamunyekwi yumu na kumtama yumonga, awu damukovikeli yumu na kumubedala yula muyaki. Muwesha ng'odu kumukimbanikila Chapanga pamu na kukimbanikila mbiya kwa chipindi chimu.” ");
INSERT INTO ndj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lakini Mafwalisayu pavapikanishili afi vamubedalili Yesu, kwanongwa veni vavelili vakusitama munu mbiya. ");
INSERT INTO ndj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Topi avawombilili, yumwi mukuyigola muva vanofu kwa vandu, lakini Chapanga kasimanya ndima shenu. Nongwa chila chiwonikili kucha china ukomi kuwushu kwa vandu, Chapanga akuchiwona chindu ha. ");
INSERT INTO ndj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malawu va Chapanga vamupili Musa na mayandiku va vambuyi va Chapanga vavelili na chichuku mbaka chipindi cha Yohani mbatisha. Kufumila pala chilongu cha nyanyi cha wutwa wa kumbindi kwa Chapanga chikulanduliwa na vandu vosi vakukimbanika kuyingila. ");
INSERT INTO ndj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lakini yipusuka munu kumbindi na mlima kuyaghamila, pitu chilongu chidokwa mumayandiku va Malawu kuyaghamila. ");
INSERT INTO ndj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Yalekana na mdala waki na kumutola wingi akugola wuwoni na mundu yoyosi yamutola mdala yalekiwili, akugola uwoni. ");
INSERT INTO ndj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kwaveli na mundu yumu mlundamali mweni yavelili akufwala yingwa sitalamili na ayikalagha ngalilu ya chinaisa naisa majuva vosi. ");
INSERT INTO ndj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pamulyangu pa ayu mlundamali vamuyeghaya mgaju yumoyu litawa lyaki Lasalu, mweni aveli na filonda fitangalili vamuyeghili pamulyangu ya yula mlundamali, ");
INSERT INTO ndj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lasalu adobukelili filivi fiponikili pasi kufuma pamesa ya yula mlundamali, pambeli kwavelili vagalu vayisagha kumyanga filonda fyaki! ");
INSERT INTO ndj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Pambeli yula mgaju asovili, makungu vamtola, vamvika pabehi na Ibulahimu kumbindi kwa Chapanga. Na yula mlundamali na mweni asovili, vamusika. ");
INSERT INTO ndj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ayu mlundamali aveli kula kumambi pagobuleka, pabindulili mesu vaki, kavawona Ibulahimu na Lasalu kwa kutali. ");
INSERT INTO ndj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Topi kamkema kwa lishu likomi, ‘Mbuyi Ibulahimu, ung'oneli lusungu, umlayishi Lasalu ajufiki chala chaki mumachi, aludoholi lulimi lwangu, nongwa ngugobuleka munu na awu motu!’ ");
INSERT INTO ndj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Lakini Ibulahimu kamuyangula, ‘Wuvi na ngumbungumbu mwana wangu kucha wapokilili kala fya nyanyi, Lasalu apokilili fivipili. Lakini ponopa, mweni kafwama na yuwi ukugoboleka. ");
INSERT INTO ndj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hata naha, pagati ya yufwi na yumwi kuna ligema likomi, vala vadayila kuyisa kwa yumwi kufuma aku valemwi na vadayila kufuma kwa yumwi kuyisa kwa yufwi davalemwi.’ ");
INSERT INTO ndj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yula mlundamali adetili, ‘Topi tati Ibulahimu, ngukudediveka umuwombeli Lasalu ayendi kaya kwa tati wangu, ");
INSERT INTO ndj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nongwa ndina vafwata vangu vamuhanu, akavalandulili vakotoo kuyisa kunu kuvelili na gobuleku.’ ");
INSERT INTO ndj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Lakini Ibulahimu kamuwombela, ‘Valongu vaku vava na Mayandiku va Musa na va Mbuyi va Chapanga. Valongu vaku uvaleki vavapikanishi ava.’ ");
INSERT INTO ndj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Lakini mweni kavawombela, ‘Ng'odu Tati Ibulahimu, ila kucha mundu yasovili pashukuka na kuvayendela, davapomeli.’ ");
INSERT INTO ndj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ibulahimu adetili, ‘Mani pavavapikanisha ng'odu Mayandiku va Musa na vambuyi va Chapanga, davalilimuki ng'odu hata yumu angashukukili kufuma kumambi.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pambeli Yesu kavawombela vandundami vaki, “Findu fimugola mundu agoli sambi dafivi, lakini pishu kwa mundu yula mweni chambuja. ");
INSERT INTO ndj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ingavelili ngiba mweni kumuwopela ligonguweli likomi mungulu na kumudubushila mulihiva, pitu kumuyambusha yumu va vananguta ava vagoli vifyu. ");
INSERT INTO ndj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Muyiloleyi! “Mani mlongu waku pakuvifya, mukayiki, papomela, mjovi. ");
INSERT INTO ndj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mani pakuvifya myanja saba kwa lijuva limu na kuwuya kwa yuwi padeta, ‘Nenga mbomela,’ topi mpomeli.” ");
INSERT INTO ndj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Vandundami vamuwombilili Bambu, “Tuyongisheli ujumilwa.” ");
INSERT INTO ndj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bambu ayangulili, “Mani ujumilwa wenu ungavelili mdokwa kucha mbeyu dokwa ya likuyu, mungaweshili kuliwombela libiki ali lya likuyu, ‘Tupuki! Kameli kubahali!’ Na lyeni lingavajumilili. ");
INSERT INTO ndj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Lakini ghani wa yumwi yaveli na ndumindumi yalima awu yadima vasenga, pawuya hela kufuma kufitava, amuwombeli, ‘Lopukeshi, wisi, wikali wulyi filivi?’ ");
INSERT INTO ndj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wuli! Damuwombeli ng'odu, kucha undandili filivi, ndilyi, wuyiwopi ungimbanikili, mbaka pandulyili na kulanda, topi na mweni aweshi kulya? ");
INSERT INTO ndj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wuli damulumbi ndumindumi yula kwanongwa kagola kala chichuku chamulayishili? ");
INSERT INTO ndj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hata yumwi wuwowu, pamugolili kala fivavalayishili, mudeti, ‘Yufwi tuva vavanda vangajila fwayida, tugola hela fitudayiliwa kugola.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu paghaveyi mumwanja kuyenda Yelusalemu apitilili Samaliya na Galilaya. ");
INSERT INTO ndj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Payingileyi chijiji chimu, atanganili na vandu lilongu vavelili na ukalava, vawolokili kutali. ");
INSERT INTO ndj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Vadetili kwa kulandusha, Yesu, Bambu, tuwoneli lusungu! ");
INSERT INTO ndj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pavawonili kavawombela, muyendi mukayilangushi kwa mtambika. Topi pavayendeyi vang'alili. ");
INSERT INTO ndj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumu wa vala pawonili kanana, kawuya kunu pakamjuma Chapanga kwa lishu likomi. ");
INSERT INTO ndj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kayiyasilila pasi paulongolu pamawulu va Yesu kunu pakamuwombela Chapanga chikomu Bambu. Ayu avelili Msamaliya. ");
INSERT INTO ndj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Apa Yesu kadeta, “Wuli vandu vang'alishiwili vavelili lilongu duhu? Vala vamonga tisa vawa koti? ");
INSERT INTO ndj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Awonikili ng'odu mundu wingi kandi yawuyili kumgayila Chapanga ukomi, ila ayu mhenja weka hela?” ");
INSERT INTO ndj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pambeli kamuwombela mundu yula, “Woloki uyendi, ujumilwa waku ukulowola.” ");
INSERT INTO ndj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chipindi chimu Mafwalisayu vamudashili Yesu, “Wutwa wa kumbindi kwa Chapanga dawuyisi ng'odu?” Mweni kavayangula, “Wutwa wa kumbindi kwa Chapanga dauyisi kwa ndambu ya kulembesha ha. ");
INSERT INTO ndj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wala kwahela daweshi kudeta, ‘Wuva apa!’ Awu ‘Wuva pala!’ kwanongwa Wutwa wa kumbindi kwa Chapanga wuva gati ya yumwi.” ");
INSERT INTO ndj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pambeli kavawombela vandundami vaki, “Majuva davayisi damudobukeli kuliwona lijuva limu lya mwana wa mundu, lakini damuliwoni ng'odu. ");
INSERT INTO ndj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Vandu davawombeli, ‘Mloli, kawa pala!’ Awu, ‘Mloli, kawa apa!’ Lakini yumwi mukotoo kufuma wala kuvakovikela. ");
INSERT INTO ndj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nongwa kucha wula lumuli paluwoneka lukung'alika kumbindi upandi wumu mbaka upandi wingi, dayivi kwa mwana wa mundu lila lijuva lyaki. ");
INSERT INTO ndj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakini dagobulewi tangila nendu na kulemiwa na ulelwa awu. ");
INSERT INTO ndj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kucha yivelili chipindi cha Nuhu, dayivi wuwu pavafika majuva va mwana wa mundu. ");
INSERT INTO ndj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Vandu vayendileli kulya na kulanda, kuheta na kuhetiwa mbaka chipindi chila Nuhu payingilili musafina. Lilava likomi liyisa na kuvawulagha vosi. ");
INSERT INTO ndj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Dayiwi kucha chipindi cha Lutu. Vandu vayendilela kulya na kulanda, kuhemela na kuhemesha, kukweta mbeyu na kujenga. ");
INSERT INTO ndj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lakini majuva vala Lutu pawukili Sodoma, motu na migonguveli ya motu dayitonyi kucha ndonya kufuma kumbindi na kuvawulagha vandu vosi. ");
INSERT INTO ndj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ndambu dayivi majuva vala mwana wa mundu dalangushiwi. ");
INSERT INTO ndj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Lijuva ali, yoyosi daghavi kumbindi ya lipaghali akotoo kusunuka kuyenda kaya kutola mali yaki na kucha mweni avelili kufitava akotoo kuwuya kumbeli kayaki. ");
INSERT INTO ndj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mukumbuki yimupatili mdala wa Lutu. ");
INSERT INTO ndj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yoyosi yadayila kugombola unofu waki dayiyaghamishi mweni, na yoyosi yayaghamisha unofu waki dawugomboli. ");
INSERT INTO ndj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nguvalongela, lijuva ali vandu vavili davavi vakuwonja pamu, yumu datoliwi na yula monga dalekiwi. ");
INSERT INTO ndj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Vadadala vavili davavi vakushaya ukova pamu, yumu datoliwi na wingi dalekiwi.” ");
INSERT INTO ndj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Vandu vavili davavi kufitava, yumu datoliwi na mumonga dalekiwi. ");
INSERT INTO ndj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Vandundami vaki vamdasha, “Koti Bambu?” Yesu avayangulili, “Pawuvelili mfimba na vandapu davayikungashi.” ");
INSERT INTO ndj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Topi Yesu kavawombela vandundami vaki chilangushilu cha kuvawula kudadava kwa Chapanga ngajila kulepisiwa. ");
INSERT INTO ndj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kadeta, “Mbwani yimu yavelili na muhigha yamumanyili ng'odu Chapanga kandi kavahela luhunja kwa vandu. ");
INSERT INTO ndj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kumbwani kukula, kwavelili na mawu yumu ngalimlyangu mweni amuyendilili muhigha yula myanja yitangalili akamluveyi amtangi, pawomba, ‘Undangi mbati haki yangu kufuma kwa mdwama wangu.’ ");
INSERT INTO ndj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa chipindi chitali ayu muhigha akadayileyi ng'odu kumtanga ayu ngalimlyangu, lakini kumbeli kayiwombela, ‘Hata kucha nenga nimumanya ng'odu Chapanga na kuvabedala vandu, ");
INSERT INTO ndj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lakini kwanongwa ngalimlyangu ayu ya nyasha dandimtangi, leki payendilela kunyasha, pambeli dandofyi nesu kunyisila majuva vosi!’ ” ");
INSERT INTO ndj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Topi Bambu kayendelela kudeta, “Mpikanishi ndambu yadetili yula muhigha mwafu. ");
INSERT INTO ndj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wuli ponopa Chapanga davatangi ng'odu vala yavashawulili, yivamlilila pamusi na pamihi, dalopukeshi ng'odu kuhigha highilu ya nakaka? ");
INSERT INTO ndj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nguvawombela dalopukeshi kuhigha highilu ya nakaka. Hata naha, Mwana wa Mundu pawuya mumlima awu nakaka dawuwoni ujumilwa” ");
INSERT INTO ndj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu kavawombela kwa chilangushilu ngimu vandu vala yivavelili vakwiwona veni goleki na kuvabedala vayawu vosi. ");
INSERT INTO ndj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kadeta, vandu vavili vayendili munyumba ya Chapanga kudadava, Mfwalisayu yumu na monga msumula mbiya. ");
INSERT INTO ndj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Ayu Mfwalisayu awolukili weka yaki padadava kunda yaki, ‘Ngudeta chikomu yuwi Chapanga, nenga ndiva kucha vandu vamonga ha, vapoki awu vadesi awu vawoni. Nenga ndiyifwana ng'odu na ayu msumula mbiya. ");
INSERT INTO ndj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nguyikaja kulya myanja mivili kwa juma, saka ngutawula lilongu limu lya chimbata nenga.’ ");
INSERT INTO ndj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Lakini yula msumula mbiya kunu kawoloka kutali kalemwa hata kuyinula mesu vaki kumbindi, ila akakamulili chifuva chaki kulangusha kushisha moyu, akadeteyi, ‘Yuwi Chapanga, ung'oneli lusungu nenga yimeli na sambi!’ ");
INSERT INTO ndj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nguvawombela, ayu msumula mbiya awuyili kaya Chapanga kamupomela sambi shaki lakini yula muyaki apomeliwili ha. Nongwa yayikwesha dasunushwi na yayidedeka dakweshiwi.” ");
INSERT INTO ndj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vandu vamuyeghela Yesu vana vadokwa ili avavikili mawoku vaki. Vanachuli pavavawonili, vakavakanisheyi kwa filongu fikalipili. ");
INSERT INTO ndj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lakini Yesu avakemili padeta, “Muvaleki vana ava vayisi kwa nenga, kandi mukotoo kuvakanisha, kwanongwa Wutwa wa kumbindi kwa Chapanga wuva kwa vandu kucha ava. ");
INSERT INTO ndj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nguvawombela nakaka, mundu yoyosi yaupokela ng'odu wutwa wa kumbindi kwa Chapanga kucha mwana mdokwa, dayingili ng'odu Muwutwa awu.” ");
INSERT INTO ndj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mkomi yumu Myawudi kamudasha Yesu, “muwula msangi, goli liki mbati unofu wa jola?” ");
INSERT INTO ndj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu kamuwombela “Mbona ukungema msangi? Kwahela mundu yaveli msangi ila Chapanga weka yaki. ");
INSERT INTO ndj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Uvamanyi Malawu, ‘Kotoo kugola uwoni, kotoo kuwulagha, kotoo kuhija, kotoo kudeta udesi na uvatundamili tati waku na mawu waku.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mweni adetili, “Afi fyosi nifimanya kufumila wana wangu.” ");
INSERT INTO ndj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu papikanishili fila, kamuwombela, “Kuna chindu chimu ukalihela kugola. Uhemeshi findu fyaku fyosi fiwuvelili nafyu, pambeli wuvagayili vagaju mbiya shaki, dawuvi na lusanja lwaku kumbindi. Pambeli wisi ungovikeli.” ");
INSERT INTO ndj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lakini mundu yula papikanishili fila, kang'ong'oteka nesu kwanongwa aveli mlundamali mkomi. ");
INSERT INTO ndj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu pamuwonili akung'ong'uteka nawula, adetili, “Yidindala munu kwa mlundamali kuyingila muwutwa wa kumbindi kwa Chapanga! ");
INSERT INTO ndj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yipusuka munu kwa ndembu kuyingila muchilanga cha sasiya, pitu mlundamali kuyingila muwutwa wa kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Vala vandu pavapikanishili afi, vadeta, “Ghani dalowoki?” ");
INSERT INTO ndj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kayangula, “Fyalemwili mundu, kwa Chapanga fikugoleka.” ");
INSERT INTO ndj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petili kamudasha, “Na yufwi wuli? Tufileka findu fyetu fyosi tukukovikela!” ");
INSERT INTO ndj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu kavawombela, “Nakaka nguvawombela, mundu yoyosi yayilekili nyumba na mdala na Mlongu awu tati na mawu, awu vana kwanongwa ya wutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Dapokeli fitangalili munu chipindi achi na chipindi chiyisa achi cha unofu wa jola.” ");
INSERT INTO ndj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu avatolili vandundami lilongu na vavili, kavawombela, “Mpikanishi! Tukuyenda Yelusalemu na aku findu fyosi fyavayandikili vambuyi va Chapanga fimwiyilatili mwana wa Chapanga dafigoleki. ");
INSERT INTO ndj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nongwa dahadishiwi kwa vandu vangajila kuva Vayawudi na veni davamuseki na kumuwombela milandu ya wafu na kumtemela mita. ");
INSERT INTO ndj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Davamtovi na ndomondu na kumuwulagha, lakini lijuva lya tatu kufumila pasovili dashukuki.” ");
INSERT INTO ndj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lakini veni vakamanyili ng'odu milandu ayi hata padokwa, vakavelili. Kavafifa nongwa ya filongu fila na vamanyili ng'odu Yesu fyadeteyi. ");
INSERT INTO ndj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Chipindi Yesu paghaveyi pabehi na Yeliku, pavelili na mundu yumoyu ngalimesu kayikala munjila paluva. ");
INSERT INTO ndj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Papikanishili lipinga lya vandu palipita avadashili, “Kuna chindu liki?” ");
INSERT INTO ndj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Vamuwombilili, “Yesu wa Nasaleti akupita.” ");
INSERT INTO ndj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mweni kayangula kwa lishu likomi, “Yesu, mwana va Dawudi, ung'oneli lusungu!” ");
INSERT INTO ndj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Vala vandu valongulili vakamlakalileyi anyamali, lakini mweni ayongishili lishu likomi, “Mwana wa Dawudi, ung'oneli lusungu!” ");
INSERT INTO ndj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu awolukili, kavawombela vamuyeghi pawulongolu yaki. Yula ngalimesu pafikili pabehi, Yesu amudashili, ");
INSERT INTO ndj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ukudayila ngugoleli liki?” Mweni ayangulili, “Bambu, ngudayila kulola.” ");
INSERT INTO ndj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu kamuwombela, “Loli! Ujumilwa waku wukulowola.” ");
INSERT INTO ndj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tepu yula ngalimesu akandili kulola, akamukovekeleyi Yesu kunu pamuwombela chikomu bambu Chapanga. Vandu vosi pavawonili nawula, vamjuma Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu kayingila mlima wa Yeliku, aveli papita mumlima wula. ");
INSERT INTO ndj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pavelili mundu yumu litawa lyaki Sakayu mweni aveli mkomi wa vasumula mbiya na aveli mlundamali. ");
INSERT INTO ndj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Akadayileyi kumuwona Yesu aveli wa wuliwuli, lakini aweshili ha kumuwona Yesu, nongwa lipinga lya vandu lyaveli likomi na mweni aveli kanduli. ");
INSERT INTO ndj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Topi kalongola mbilu kakwela mulikuyu ili amuwoni Yesu nongwa dapitili deha yiyila yila ");
INSERT INTO ndj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Topi Yesu pafikili pala, kalola kumbindi ya libiki kamuwona Sakayu, kamuwombela, “Sakayu sunuki kalopu, kwanongwa nalelu dandivi kayaku.” ");
INSERT INTO ndj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakayu kasunuka kalopu, kamselilela kwa seku. ");
INSERT INTO ndj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vandu vosi pavawonili nawula, vakanda kung'ong'oleka vadeta, “Kayenda kuyikala kwa mundu yaveli na sambi.” ");
INSERT INTO ndj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lakini Sakayu kawoloka, kamuwombela, “Bambu, pikanishi,! Nenga dandivapi vagaju nusu ya mali shangu na leki mundu yoyosi nimupokili chindu kwa kumujanga, dandimuwuyishili myanja mchechi.” ");
INSERT INTO ndj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu kamuwombela, “Nalelu ulowolu wufika munyumba ayi na kwa mundu ayu. Kwa nongwa ayu wuwowu mwana wa lukolu lwa Ibulahimu. ");
INSERT INTO ndj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwa nongwa mwana wa mundu ayisili kusaka na kuvalowola yivayaghamilili.” ");
INSERT INTO ndj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Vandu pavapikanishili afi, Yesu kayendelela kuvawombela kwa filangushilu kwanongwa avelili pabehi na Yelusalemu na veni vakacheyi wutwa wa kumbindi kwa Chapanga wuva tepu kuwoneka. ");
INSERT INTO ndj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Topi kadeta, “Mundu yumu mlundamali, awukili ayendili mwanja wa mlima wa kutali, ili vakamwingishi wutwa pambeli awuyili. ");
INSERT INTO ndj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Topi padayileyi kuwuka, kavakema vala lilongu wa vala vandumindumi vaki. Kavapa kila mundu mbiya sha ijala ya myesi mitatu kavawombela, ‘Mgoleli uchulusi mbaka pang'uya.’ ");
INSERT INTO ndj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lakini vandu vaki vamunyekwili, vavalayisha vanjagila kumkovikela na kumuwombela, ‘Tukumdayila ng'odu mundu ayu ghavi mutwa wetu.’ ");
INSERT INTO ndj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pawupatili wutwa waki kawuya. Pambeli kavakema vandumindumi vaki ili amanyi fwayida ngomi yivapatili kila mundu muuchulusi waki. ");
INSERT INTO ndj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ndumindumi wa kwaa kayisa, kadeta, ‘Bambu, ndisiyongesha mala lilongu ya sila mbiya siwunyimbili.’ ");
INSERT INTO ndj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kamuwombela, ‘Nyanyi, yuwi kuva ndumindumi mnofu! Kuva mwaminifu wa chidokwa na nenga dandikugoli kuva chiwongosi wa vayaku.’ ");
INSERT INTO ndj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ndumindumi wa pili kayisa, kamuwombela, ‘Bambu, siyongishekili siva myanja muhanu ya migwala ya mbiya yiwunyimbili.’ ");
INSERT INTO ndj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na yula kamuwombela, ‘Dawuvi mkomi wa milima muhanu.’ ");
INSERT INTO ndj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ndumindumi wingi kayisa, kamuwombela, ‘Bambu toli mbiya yaku yiyila yila. Ndayifisili muchitambala. ");
INSERT INTO ndj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ndatilili kwanongwa yuwi kuva mundu mkali. Yuwi kuva mundu yiwutola chila chingajila kuvika na kunokola chila chiungajila kukweta.’ ");
INSERT INTO ndj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mweni kamuwombela, ‘Yuwi ndumindumi mwafu! Danguhighi kwa filongu fyaku! Wamanyili kucha nenga mundu mkali yidayila fingajila kuva fyangu na ngubena chingajila kukweta. ");
INSERT INTO ndj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Topi mbona kuyivika ng'odu mbiya yangu kwa yivatawula fiyongishekili ponopa ningatolagha na nyongesha shaki?’ ");
INSERT INTO ndj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Topi kavawombela vala vavelili pala, ‘Mumpoki ayi mbiya, mukamupi yula yapatili nyongesha mala lilongu.’ ");
INSERT INTO ndj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Veni vamuwombela, ‘Bambu, lakini ayu kana nyongesha ayi ya lilongu!’ ");
INSERT INTO ndj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mweni kavayangula, ‘Nguvawombela kila yangajila chindu, hata chila chaveli nachu dapokiwi. ");
INSERT INTO ndj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na ponopa, vala vadayilili ng'odu nenga ndivi mutwa wawu muvayeghi apa, ndivawulayi bahapa paulongolu yangu!’ ” ");
INSERT INTO ndj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu padetili kala afi, kavalongulela kuulongolu payenda Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Paghaveyi samba kufika Betifage na Betaniya muchidunda chivakema Miseyituni, avatumili vandu vavili vamu wa vala vandundami vaki, ");
INSERT INTO ndj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Kavawombela, “Muyendi kumlima wuveli pawulongolu yenu, pamuyingila pala damumuwoni ngwada wa chihongu kakongiwa, yangajila kugolewa chichuku na mundu yoyosi, mumuwoposoli mumuyeghi apa. ");
INSERT INTO ndj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kucha mundu pavavadasha nongwa liki mukumuwopusola mudeti naha, Bambu akumdayila.” ");
INSERT INTO ndj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Vala vandundami vayenda, vawona wuwula wula ngimu wuvalayilili. ");
INSERT INTO ndj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pavamuwopusoleyi yula chihongu, veni vavadasha, “Nongwa liki mukumuwopusola chihongu ayu?” ");
INSERT INTO ndj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Veni vavayangula, “Bambu akumdayila.” ");
INSERT INTO ndj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Topi vamyeghela Yesu yula chihongu. Vayala yingwa shawu kumuwongu wa yula chihongu, vampakila Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu payendilelili mumwanja waki vayendagha kuyala yingwa shawu mudeha. ");
INSERT INTO ndj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hata paghaveyi samba afika Yelusalemu, pamaleka va chidunda cha miseyituni, lipinga lyosi lya vandundami vaki vakandili kunemelela kwa filumbi na kumjuma Chapanga kwa lishu likomi kwanongwa fyosi fyagolili uwesu waki vawuwonili, ");
INSERT INTO ndj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Vadeta, “Ayu yayisa ayu kwa litawa lya Bambu! Ndi yanemiliwili na Chapanga atugayili kusika aku kumbindi kwa Chapanga na ukomi aku kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bahala pala Mafwalisayu vamu vavelili mulipinga lila vamuwombela, “muwula, wuvakayiki vandundami vaku vanyamali.” ");
INSERT INTO ndj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kavayangula, “Nguvawombela nakaka kucha ava pavanyamala, migonguveli dayiviki chowu.” ");
INSERT INTO ndj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pafikili pabehi, ayiwonili mbwani ya Yelusalemu, Yesu kayililila. ");
INSERT INTO ndj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Padeta, “Leki ungamanyili mulijuva ali yikudayiliwa kuvi kusika! Lakini ponopa yifisiwa uyiwoni ng'odu! ");
INSERT INTO ndj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nongwa majuva vakwisa, vachimdwama vaku davakujengeli liboma likushengiteli mbembi shosi, ");
INSERT INTO ndj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Davakuwishi pasi yuwi na vandu vaku munyumba yaku, davakulekeli ha liganga kumbindi ya liganga, kwanongwa kumanya ha chipindi cha Chapanga chikwisila.” ");
INSERT INTO ndj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Topi Yesu kayingila munyumba ya Chapanga, kakanda kuvavingila panji vachuwusi, ");
INSERT INTO ndj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kavawombela, “Yiyandikiwa mumayandiku, ‘Nyumba yangu dayivi nyumba ya kudadavila.’ Ila yumwi muyigola yiva mbaku ya vefi!” ");
INSERT INTO ndj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu aveli akuwula kila lijuva munyumba ya Chapanga, lakini vawula va Malawu na vayandika na vakomi va vandu vakasakeyi njila ya kumuwulagha, ");
INSERT INTO ndj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ila vachiwonili ha cha kugola, kwanongwa vandu vavelili vakumkovikela na kumpikana filongu fyosi fyadeta. ");
INSERT INTO ndj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lijuva limu, Yesu aveli akuwula vandu munyumba ya Chapanga na kuchilandula Chilongu cha Nyanyi. Vatambika vakomi na vawula va Malawu na vavaha vambwitukilili Yesu, ");
INSERT INTO ndj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","vamudasha, “Tuwombeli, ukugola findu afi kwa uwesu wa ghani? Ghani yakugayilili uwesu awu?” ");
INSERT INTO ndj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu kavayangula, “Na nenga dandivadashi yumwi chindu chimu. Mung'ombeli, ");
INSERT INTO ndj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ubatishu wa Yohani mbatisha wafumili kumbindi kwa Chapanga awu kwa vandu?” ");
INSERT INTO ndj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Vayidasha veni kwa veni, “Kucha patudeta, ‘Wafumili kumbindi kwa Chapanga,’ dadeti, ‘Mbona mwamjumilili ha?’ ");
INSERT INTO ndj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na patudeta, ‘Wafumili kwa vandu,’ vandu vosi davatugumi miganga kwanongwa vamjumila Yohani mbatisha kucha mbuyi wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Topi vamuyangula, “Tumanya ha kuufumili.” ");
INSERT INTO ndj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu kavawombela, “Na nenga ndivawombeli ha ngugola findu afi kwa uwesu wa ghani.” ");
INSERT INTO ndj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu kakanda kuvawombela vandu chilangushilu achi: “Mundu yumu yapandili misabibu mufitava, kavahadisha valimi, mweni kawuka kayenda kuyikala mlima wingi kwa majuva vatangalili. ");
INSERT INTO ndj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chipindi cha kubena, mundu ayu kamulayisha ndumindumi waki kwa vala valimi, akatoli fimu fya fyavabenili muchitava chila cha mizabibu. Topi vala valimi vamtovanga ndumindumi yula, pambeli vamuwuyisha mawoku hela. ");
INSERT INTO ndj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yula mundu kamulayisha kandi ndumindumi wingi, lakini na ayu vamtovanga wuwula wula na kumjowola na kumuwuyisha mawoku hela. ");
INSERT INTO ndj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kamulayisha kandi wa tatu, na ayu pavamteshili kala, vamuyasili panji ya chitava. ");
INSERT INTO ndj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Topi yula bambu wa chitava chila cha misabibu kadeta, ‘Goli wuliwuli? Dandimtumi mwana wangu yindimtamili, ayu davamtili.’ ");
INSERT INTO ndj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lakini vala valimi pavamuwonili hela mwana wa muna chitava, vawombana, ‘Ayu ndi muhala mbala. Topi tumuwulayi ili mbala yaki yivi yetu.’ ");
INSERT INTO ndj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Topi vamfumisha panji ya chitava cha misabibu, vamuwulaya.” Yesu kadasha, “Munachitava dagoli liki kwa vala valimi? ");
INSERT INTO ndj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dayisi kuvawulaya valimi vala na chila chitava cha misabibu davapi vandu vengi.” Pavapikanishili afi vadeta, “Afi fikotoo kutuwona yufwi!” ");
INSERT INTO ndj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Topi Yesu kavafulutulila mesu, kavawombela, “Topi mana yaki liki chilongu achi chiyandikiliwili. Lusiki valulemili vajengi, Luva lusiki lukomi lwa kwidumbila kupita shosi? ");
INSERT INTO ndj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mundu yoyosi yawila mulusiki lula dabeneki beneki, lakini mundu yoyosi palimuwila dalimbaji bajabaja.” ");
INSERT INTO ndj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Vawula va Malawu na vatambika vakomi vakasakeyi njila ya kumuwomesha chipindi chichila chila, vavatilili vandu, nongwa vamanyili kucha chilangushilu achi chivayilata veni. ");
INSERT INTO ndj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Topi vakamulembisheyi, vavalayisha valembesha vayigolili kucha veni vandu va haki ili vamuwomeshi filongu fyaki, pambeli vamukamuli na kumuyegha kwa vatavala na vanauwesu. ");
INSERT INTO ndj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Vala valembesha vamudasha Yesu, “Muwula, tukumanya ukudeta na kuwula milandu ya nakaka. Tukumanya yuwi kuna lushawu ng'odu. Yuwi ukuwula fya nakaka fya deha ya Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Topi vamudasha, “Tuwombeli, yikujumishiwa kuhomba kodi kwa mutwa wa Loma awu ng'odu?” ");
INSERT INTO ndj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu amanyili ufyangu wawu, kavawombela, ");
INSERT INTO ndj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Munangushi ligwala lyeni. Wuli wushu na lihundu lya ghani?” Veni vayangula, “Ya mutwa wa Loma.” ");
INSERT INTO ndj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu kavawombela, “Fya mutwa wa Loma mumupi mutwa wa Loma na fya Chapanga mumupi Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Vawesha kandi ha kumuwomesha kwa chilongu chochosi pala pa vandu na vayikala kokota vakujinga nyangulilu yaki. ");
INSERT INTO ndj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pambeli Masadukayu vamu, vala yivadeta yivasovili vakushukuka ng'odu kushukuka, vamuyendela, vamudasha, ");
INSERT INTO ndj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Muwula, Musa atuyandikilili kucha muna mdala asovili lakini amulekili mdala waki ngajila mwana, mdala yula atoliwili na mlongumundu, ili amuleleli vana mlongumundu. ");
INSERT INTO ndj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kwavelili na valongu saba. Wakwaa ahetili mdala pambeli kasova ngajila kuleka vana. ");
INSERT INTO ndj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yula mlongu mundu wa pili kamuhala mdala yula na mweni kasova ngajila kuleka mwana. ");
INSERT INTO ndj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hata mlongu wa tatu wuwula wula, mbaka vosi saba, vasova ngajila kuleka vana. ");
INSERT INTO ndj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pambeli na yula mdala kasova. ");
INSERT INTO ndj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Topi lijuva lya kushukushiwa, daghavi mdala wa ghani? Nongwa vosi saba vamuhetili.” ");
INSERT INTO ndj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu kavawombela, “Vandu va mlima awu vakuheta na kuhetiwa. ");
INSERT INTO ndj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Lakini vala vavalangiwili kucha davawupati mlima wula na kula kushukuka kufuma munjifwa, vakuheta ha wala kuhetiwa. ");
INSERT INTO ndj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Davasovi kandi ha, kwanongwa vava telatela na makungu na veni vana va Chapanga, kwanongwa veni davashukuki. ");
INSERT INTO ndj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kuna kushukuka pawusovili kala, hata Musa ayandikili afiwonili lijuva lila pamukemili Chapanga, kuva Chapanga wa Ibulahimu na Isaka na Yakobi, chipindi Chapanga kawombana nayu pala pamidasi payakeyi motu. ");
INSERT INTO ndj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Topi mweni kucha Chapanga wa vasovili ha, ila Chapanga wa vala vaveli vanofu.” ");
INSERT INTO ndj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Vala vawula vamonga va Malawu vayangula vawomba, muwula kudeta nyanyi, ");
INSERT INTO ndj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Vawuyila kandi ha kumudasha chindu. ");
INSERT INTO ndj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu kavadasha, “Yiva wuliwuli vandu vakudeta Kilistu Mkombola yashawuliwili na Chapanga ndi mwana wa Dawudi? ");
INSERT INTO ndj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawudi mweni akudeta muchitabu chaki cha Sabuli, ‘Bambu amuwombilili Bambu wangu: Wuyikali mwambu wa liwoku lyangu lya mlilu ");
INSERT INTO ndj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mbaka ndivaviki vachimdwama vaku vavi chipasa cha kuvikila mawulu vaku.’ ");
INSERT INTO ndj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Payiva Dawudi akumkema Kilistu ‘Bambu’, dayivi wuliwuli Kilistu Mkombola amukemi mwanamundu?” ");
INSERT INTO ndj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Vandu vosi pavampikanileyi, Yesu kavawombela vandundami vaki, ");
INSERT INTO ndj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Muyilyepi na vawula va Malawu veni vakudayilaya kuyendayenda kunu vafwala mihabiti mitali. Na kujambushiwa musoku na kuyikala kuulongolu munyumba sha kudadavila na kuyikala figoda fya kuulongolu mulihungu. ");
INSERT INTO ndj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Vakuvapuhanya vangalimlyangu kunu pavayilyambishila veni vandu vasangi kwa Chapanga na kugola dadavilu ndali kwa Chapanga. Ava davapati highilu ngomi. ");
INSERT INTO ndj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu kavawona valundamali pavatayeyi fupu shawu musanduku lya mbiya Munyumba ya Chapanga, ");
INSERT INTO ndj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","pambeli kamuwona ngalimlyangu yumu kadubushila mula migwala mivili midokwa. ");
INSERT INTO ndj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Topi kadeta, “Nguvawombela nakaka, mawu ayu mugaju kataya chaveli nachu chosi. ");
INSERT INTO ndj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vandu vosi vatayili fupu shawu sifumili muulundamali wawu wuyongishekili, lakini mawu ayu mgaju, kataya chosi chaveli nachu.” ");
INSERT INTO ndj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Vandundami vamonga vaveli vakaywangeyi milandu ya nyumba ya Chapanga, ndambu yivamelimetishili kwa migonguveli ya nyanyi pamu na vivatawulili vandu, kadeta, ");
INSERT INTO ndj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Afi fyosi fimufiwona, lijuva daliyisi kwahela ligonguveli hata limu dalisighali pambindi ya ligonguveli limonga, migonguveli yosi ya nyumba dayidanganyishiwi.” ");
INSERT INTO ndj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Topi vamdasha, “Muwula, findu afi dafivi ndili? Datuwoni chindu liki dachitulangushi tanila?” ");
INSERT INTO ndj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu kavayangula, “Muyivavali, mukotoo kujangiwa. Vandu vatangalili davayisi kwa litawa lyangu pavadeta, ‘Nenga ndi Kilistu Mkombola yishawuliwili na Chapanga!’ Topi ‘Chipindi chifika!’ Mkotoo kuvakovikela veni. ");
INSERT INTO ndj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mkotoo kutila pamupikana mugoha na chiyighayigha, nongwa afi lasima fibwituki tanila, lakini yila mbelu yikali hela.” ");
INSERT INTO ndj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pambeli Yesu kavawombela, vandu va mlima wumu davawuki na kwiminya na vandu va mlima wingi na wutwa dawuyiminyi na wutwa wingi. ");
INSERT INTO ndj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dakuvi na chiyighayigha chikomi mumlima na njala na utami wuvawukema tawuni mahali kosi na findu fya kukapusha na filangushilu fikomi kufuma kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lakini nguvawombela, fyosi afi ngajila tanila kubwituka, davavakamuli na kuvavifya na davavayeghi munyumba sha kudadavila na kuvawopa mufijaka, kwanongwa mukungovikela nenga. ");
INSERT INTO ndj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na ayi dayivi fwasi ya kuvalandulila Chilongu cha Nyanyi. ");
INSERT INTO ndj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Topi muvi na chiganu mundima shenu, mukotoo kuyihola kucha damudeti liki, ");
INSERT INTO ndj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwa nongwa nimweni dandivapi filongu fya kudeta na luhunja, hata vachimdwama venu davalemi ng'odu wala kulimba. ");
INSERT INTO ndj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yumwi davavashengeti vatati na vamawu venu na valongu venu na vaghanja venu na davavawulayi vamu va yumwi. ");
INSERT INTO ndj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Vandu vosi davavanyekwi yumwi kwanongwa ya kungovekela nenga. ");
INSERT INTO ndj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Topi nguvawombela kwahela hata lufwili lumu lwa kumutwi yenu daluyaghamili. ");
INSERT INTO ndj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mugangamali, damuyikomboli mwaveni. ");
INSERT INTO ndj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pamuuwona mlima wa Yelusalemu ushengitiwa na mangandawu, topi mumanyi kucha chipindi chifika cha mlima awu kubomuliwa. ");
INSERT INTO ndj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Topi yaveli Yudeya atuvilili kufidunda, vala vavelili kuchidunda chila vawuki na vala vavelili kufitava vakotoo kuwuya kumlima wula. ");
INSERT INTO ndj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nongwa majuva ava ndi majuva va highilu, ili fyosi fiyandikiwili figoleki. ");
INSERT INTO ndj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pishu vala vaveli na ndumbu na vala vayongesha majuva va mbelu. Kwa nongwa dakuvi na tabu ngomi mlima wosi na maya va Chapanga davavapati vandu ava. ");
INSERT INTO ndj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Vamonga davawulayiwi kwa lipanga na vamonga davatoliwi mateka kumilima yosi. Mlima wa Yelusalemu davavatangiwi na vandu vangajila Vayawudi, mbaka fipindi fyawu pafipita. ");
INSERT INTO ndj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Dakuvi na chilangushilu mulijuva na mwesi na ndondwa. Vandu va milima yosi davavi mutabu kwa nogwa ya kwipwelesha kuwumba kwa bahali na miwumbula. ");
INSERT INTO ndj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Vandu davalepusiwi kwa kuyipwelesha na kwanongwa ya kulembilela findu dafiwupati mlima awu. kwanongwa findu fya kumbindi kwa Chapanga dafitikanyiki. ");
INSERT INTO ndj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Topi apa ndi davamuwoni Mwana wa Mundu payisa mumafundi pamu na liwovi na ukomi utangalili. ");
INSERT INTO ndj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Topi pamuwona findu afi fikubwituka, musakapuki, mukayinuli mitwi yenu nongwa ukombola wenu wuva pabehi.” ");
INSERT INTO ndj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pambeli Yesu kavawombela chilangushilu, “Muliloli libiki lya likuyu na mibiki yimonga yosi. ");
INSERT INTO ndj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pamuwona yikukanda kutomola mahamba, mukumanya kucha chipindi cha kukanda ndonya chiva pabehi. ");
INSERT INTO ndj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na yumwi wuwowu, pamuwona findu afi fikugoleka, mumanyi wutwa wa kumbindi kwa Chapanga vava pabehi. ");
INSERT INTO ndj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nakaka nguvalongela, chileli achi cha ponopa dachipiti ha mbaka afi fyosi figoleki. ");
INSERT INTO ndj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lulanga na milima dafipiti, lakini filongu fyangu dafipiti ng'odu. ");
INSERT INTO ndj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Muyikali ndemindemi, ndima shenu sikotoo kulemilela ubafu na unjayila na kuyifwasha na milandu ya ngalilu ayi. Lijuva lila tepu dalivabwitukili. ");
INSERT INTO ndj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwa nongwa dayivayisili kucha mtambu kwa wosi yivayikala mumlima awu. ");
INSERT INTO ndj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Topi mugungi mesu majuva vosi, pamudadava ili mulowoki mufindu afi dafibwituki na kuwoloka paulongolu ya Mwana wa Mundu.” ");
INSERT INTO ndj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Topi majuva vosi vala, pamusi Yesu aveli akuwula nyumba ya Chapanga na pamihi akuyenda kuwonja kuchidunda chivakemeyi cha Miseyituni. ");
INSERT INTO ndj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vandu vosi pamalavila puti vavelili vakuyenda kunyumba ya Chapanga kumpikanisha Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lihungu lya mibumbunda yingajila simika, livalikema Pasaka, lyaveli pabehi. ");
INSERT INTO ndj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Vatambika vakomi na vawula va Malawu vakasakeyi ndambu ya kumkamula Yesu kwa chifisu ili vamuwulaghi. ");
INSERT INTO ndj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Topi Lijangavandu kamwingila Yudasi, yivamkema Sikaliyoti, yumu wa vala lilongu na vavili. ");
INSERT INTO ndj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pambeli Yuda kayenda kuwombana na vatambika vakomi na vala vamachonda va nyumba ngomi ya Chapanga ndambu ya kumutawula Yesu kwa veni. ");
INSERT INTO ndj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Veni vasekilela, vajumila vamuhombi mbiya. ");
INSERT INTO ndj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda ajumilili, akusaka fwasi nofu ya kumshengeta Yesu ili amtawuli kwa veni ngajila vandu kumanya. ");
INSERT INTO ndj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Topi lifika lijuva lya mibumunda yingajila simika. Ali lyaveli lijuva vanafungami va Lihungu vakusinjiwa. ");
INSERT INTO ndj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Topi Yesu kavalayisha Petili na Yohani kadeta, “Muyendi mukalitandi Lihungu ili tulyi.” ");
INSERT INTO ndj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Veni vamudasha, “Ukudayila tukayitandi koti?” ");
INSERT INTO ndj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu kavawombela, “Mpikanishi! Pamuyenda kumbwani, damtang'aniki na mundu yayitwikili chiyungu cha machi. Mumukovikeli mbaka munyumba dayingili. ");
INSERT INTO ndj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mumuwombeli mwenikaya wa nyumba yila, ‘Muwula akukudasha, chiva koti chumbagati cha mhenja dalilyi Lihungu pamu na vandundami vaki?’ ");
INSERT INTO ndj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mweni davalangushi chumbagati chikomi chitalishiwili kala. Muyitandi Pasaka amu.” ");
INSERT INTO ndj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Topi vayenda, vafiwona findu fyosi filinganila ngimu wavawombilili Yesu, vatanda Lihungu. ");
INSERT INTO ndj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saa payifikili, Yesu kayikala pamu na vandundami vaki vakulya filivi. ");
INSERT INTO ndj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kavawombela, “Bayulila munu kulya Lihungu ali ngengi pamu na yumwi chipindi ngali hela kugoboliwa. ");
INSERT INTO ndj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwanongwa nguvawombela, dandulyi kandi ha Pasaka pamu na yumwi mbaka lijuva lila pandulya muwutwa wa kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Topi atolili chikombi cha difwayi, kamulumba Chapanga, kadeta “Mupokeli muvaghani. ");
INSERT INTO ndj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kwanongwa nguvawombela nakaka, danandi kandi ha difwayi ya misabibu mbaka wutwa wa kumbindi wa Chapanga pawisa.” ");
INSERT INTO ndj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pambeli katola libumunda, kamulumba Chapanga, kalimetula, kavapa vandundami vaki, kadeta, “Awu mvili wa nenga, wutawuliwa kwanongwa ya yumwi. Mgoli nga nahawu kwa ngumbungumbu ya nenga. ");
INSERT INTO ndj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wuwula wula palili kala, katola lwindi kadeta, lwindi alu ndi lilaghanu lya shonu lya mwasi wangu, wuumwayika kwanongwa ya yumwi. ");
INSERT INTO ndj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Lakini mumuloli! Yula dashengeti liwoku lyaki dalitoti pamu na nenga! ");
INSERT INTO ndj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nakaka Mwana wa Mundu akuyenda kuwulayiwa kucha Chapanga ayilatili, lakini pishu mundu yula yamshengeta Mwana wa Mundu.” ");
INSERT INTO ndj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Topi vakandili kuyidasha veni kwa veni mika ghani gati ya yufwi daweshi kugola chindu achi. ");
INSERT INTO ndj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Vandundami va Yesu vaveli vakulimbana, “Ghani mkomi gati ya yufwi?” ");
INSERT INTO ndj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu kavawombela, “Vangajila kuva Vayawudi na vala yivavatavala vakuvakema vaveli na lighanja na vandu. ");
INSERT INTO ndj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ila yumwi mukotoo kugola kucha nahawu, yaveli mkomi kwa yumwi ghavi kucha mdokwa na daghavi ndumindumi wa vengi. ");
INSERT INTO ndj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kwanongwa, ghani yaveli mkomi, yula yayikalili paghalya filivi, awu yula ndumindumi? Yina mkomi yula yayikalili pamesa paghalya. Lakini nenga kwa yumwi ndiva ndumindumi. ");
INSERT INTO ndj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yumwi ndi msighalili na nenga chipindi chosi cha nenga kuyeshiwa, ");
INSERT INTO ndj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngimu wula Tati wangu panyimbili wutwa na nenga wuwowu dandivapi yumwi. ");
INSERT INTO ndj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Damulyi na kulanda pamesa ya nenga muwutwa wangu na kunu damuyikali mufigoda fya wutwa wa Chapanga kuvahigha makabila lilongu na mavili va Isilaeli. ");
INSERT INTO ndj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simoni! Pikanishi! Lijangavandu akudayila kuvalekanisha yumwi na wutwa wa kumbindi kwa Chapanga, akudayila avapeti kucha mpunga. ");
INSERT INTO ndj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lakini nenga ngukudadavila, Simoni, ujumilwa waku ukotoo kuva. Na pawung'uyila nenga, wuvadindashi valongowu.” ");
INSERT INTO ndj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Lakini Petili kayangula, “Bambu, nenga ndiva kala kuyenda pamu na yuwi hata pang'opiwa muchijaka awu kusova pamu na yuwi.” ");
INSERT INTO ndj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu kayangula, “Ngukuwombela, yuwi Petili, njowolu akuvika ha nalelu mbaka tanila yuwi unemi mala ndatu kucha nenga kumanya ha.” ");
INSERT INTO ndj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pambeli Yesu kavadasha vandundami vaki, “Chipindi pandivalayilili muyendi mwavelihela mihaku wala mikanda wala mikobasi, mwayangilili na chindu chochosi?” Vayangula, “Ng'odu!” ");
INSERT INTO ndj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu kavawombela, “Ponopa nguvawombela naha, yaveli na muhaku awutoli na yaveli na likanda wuwowu na yangajila chimayi chikomi awuli lihabiti lyaki ahemeli upanga. ");
INSERT INTO ndj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nguvawombela mayandiku yivadeta mweni dayivalangiwi pamu na vandu va wafu. Davawoneki kwa nenga nongwa fila fyavanyandikilili fivi nakaka.” ");
INSERT INTO ndj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Topi vandumindumi vadeta, “Loli Bambu!” Apa pana mipanga mivili, Bambu Mweni kacha, fikwila. ");
INSERT INTO ndj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu kayileka mbwani kawuka, kayenda mbaka chidunda cha miseyituni kucha wuchivelili chishovi chaki, ayilongushili pamu na vanachuli vaki. ");
INSERT INTO ndj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pafikili pala kavawombela, “Mudadavi mukotoo kuyingila munyeshu.” ");
INSERT INTO ndj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pambeli kawuka, kayikwegha kucha utali wa kudanga liganga naha, katundama kakanda kudadava. ");
INSERT INTO ndj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kadeta, “Tati, kucha pawudayila, ung'ushili lwindi alu, ila yikotoo kuva ngimu wudayila nenga, ila yivi ngimu wudayila yuwi.” ");
INSERT INTO ndj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Makungu kufuma kumbindi kamfumbukila kamuyongesha liwovi. ");
INSERT INTO ndj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Paghaveyi na lihingili likomi, kadadava kwa kung'ong'oleka na lifuki limsululeyi likaveyi kucha mindwesi ya mwasi. ");
INSERT INTO ndj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Padadavili kala, kavawuyila vanachuli vaki, kavawona vawonja, vavelili na lung'ong'u. ");
INSERT INTO ndj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kavawombela, “Mbona muwonja? Muyimuki mudadavi, mukotoo kuyingila mumayeshu.” ");
INSERT INTO ndj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu paghaveyi akuywanga na vandundami vaki, lipinga lya vandu pamu na Yudasi Sikaliyoti yaveli yumu wa vala vandundami vaki lilongu na vavili kavalongulela. kamselilela Yesu, kamjambusha kwa kumunonela. ");
INSERT INTO ndj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu kamuwombela, “Yudasi, ukumshengeta Mwana wa Mundu kwa kumunonela?” ");
INSERT INTO ndj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Vala vandundami vaki vavelili pabehi pavawonili nawula vadeta, “Bambu, tuvatovi kwa fimayi fikomi?” ");
INSERT INTO ndj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Muyawu yumu kamdula mvanda wa mtambika mkomi, kamudumula lijeji lya mlilu. ");
INSERT INTO ndj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lakini Yesu kadeta, “Topi yikwila!” Kamugufya pamdumulili lijeji lya yula mvanda, linana. ");
INSERT INTO ndj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pambeli Yesu kavawombela vala vakomi va vatambika na va machonda va Nyumba ya Chapanga na vandu va Malawu na vavaha vala yivamwisilili, “Wuli, mwisa na mimayi na fimbongu kucha mukumkamula manyagha? ");
INSERT INTO ndj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Majuva vosi patuveyi pamu na yumwi Munyumba ya Chapanga mwangamulili ng'odu. Lakini ponopa ndi ayi saa yenu ya liwovi lya wutwa wa chisi pawutavala.” ");
INSERT INTO ndj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Topi vamvakula, vamtola vayenda nayu mbaka munyumba ya mtambika mkomi na Petili amkovikelili kumbeli kwa kutali. ");
INSERT INTO ndj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pavakoshili kala motu pagati ya luviwu, veni vayikalili pamu na Petili ayikalili pasi pamu na veni. ");
INSERT INTO ndj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Topi mvanda yumu mdadala kamuwona Petili kayikala mulung'ali, kamfulutulila mesu kadeta, “Na ayu avelili pamu na Yesu.” ");
INSERT INTO ndj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lakini Petili kalema, kawomba, “Yuwi mdadala, nenga ndimumanya ha mundoyu.” ");
INSERT INTO ndj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pambeli padokwa, mundu wingi kamuwona “Hata yuwepa yumu wa ava.” Petili kayangula, yuwi mundu, ndimumanya ha mundoyu. ");
INSERT INTO ndj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pambeli kucha lisaa limu lipita, mundu wingi kamkamalila, “Nakaka hata ayu aveli pamu na Yesu, nongwa hata mweni wuwowu Mugalilaya!” ");
INSERT INTO ndj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lakini Petili kadeta, “Yuwi mundu, nenga ndichimanya ha chiwudeta!” Tepu, njowolu kavika. ");
INSERT INTO ndj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bambu kamughalambukila, kamulola Petili. Petili kakumbuka chila chilongu cha Bambu chadetili, “Kucha nalelu njowolu akali hela kuvika, dawunemi myanja mitatu.” ");
INSERT INTO ndj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bahala pala Petili kafuma panji, kalila munu. ");
INSERT INTO ndj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vala vandu vavelili vakumkamulila Yesu, vakanda kumdanila na kumdula. ");
INSERT INTO ndj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Vamgubika kumesu, vakanda kumtova, Pambeli vamudasha dasha pavadeta, “Tungi ghani yakutovili?” ");
INSERT INTO ndj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na vamuwombela filongu fitangalili fya kumjowola. ");
INSERT INTO ndj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kukachi, Yesu kayeyiwa pachitemela cha Vayawudi. Pachitemela vavelili vavaha na vatambika vakomi na vawula va Malawu vatanganili pamu, vamuyegha pachitemela chawu. ");
INSERT INTO ndj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Veni vadeta, “Tuwombeli, yuwi ndi Kilistu Mkombola yuwushawuliwili na Chapanga?” Kavawombela, “Hata pandivawombela, damjumili ha, ");
INSERT INTO ndj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","hata pandivadasha, damunyanguli ha. ");
INSERT INTO ndj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lakini kukandila ponopa, Mwana wa Mundu daghavi kayikala mwambu wa mlilu wa Mweni Chapanga muna liwovi.” ");
INSERT INTO ndj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Vosi vadeta, “Yuwi Mwana wa Chapanga?” Kavayangula, “Yumwi ndi yimudeta, nenga mweni.” ");
INSERT INTO ndj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Topi vadeta, “Tuva na haja liki kandi ya kusaka utovileli? Kwa nongwa tupikana filongu fyadetili kufuma mumlomu waki!” ");
INSERT INTO ndj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Vatandamuka vandu vosi, vamuyegha kwa Pilatu. ");
INSERT INTO ndj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kula vakanda kumuhigha, pavadeta, “Tumuwona ayu pavifya mlima wetu na kuvakanisha vandu vakotoo kumuhomba mbiya Mutwa wa Loma, kunu padeta kucha mweni ndi Kilistu mutwa yashawuliwili na Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu kamudasha Yesu, “Yuwi ndi Mutwa wa Vayawudi?” Yesu kamuyangula, “Yina, ukudeta yuwi.” ");
INSERT INTO ndj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatu kavawombela vatambika vakomi na lipinga lya vandu, nenga ndichiwona ha chindu chavifyili mundoyu. ");
INSERT INTO ndj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lakini veni vakamalila, vakawombeyi, “Davayashinganyi vandu, akuvajanga na kuvajongishela vandu vawulimbi mumlima Yudeya, kufumila Galilaya na ponopa kayisa kunu.” ");
INSERT INTO ndj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatu papikanishili afi, kadasha, “Mundu ayu mwenikaya wa Galilaya?” ");
INSERT INTO ndj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pamanyili kucha Yesu aveli pasi ya wutwa wa Helodi, amuyeghili kwa Helodi, nongwa chipindi achi aveli Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helodi pamuwonili Yesu asekililili munu, kwanongwa amusakeyi majuva vatangalili kwanongwa apikanishili filongu fyaki, akushuvilila kuwona mihilu yigoliwili na mweni. ");
INSERT INTO ndj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Topi kamudasha filongu fitangalili, lakini mweni kayangula chindu ha. ");
INSERT INTO ndj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Vatambika vakomi na vawula va Malawu vawoloka vamuhigha nesu. ");
INSERT INTO ndj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Topi Helodi kamugola mundu msosuvafu, vamachonda vaki, vamudanila Yesu, pambeli vamufwalisha yingwa ya wutwa, vamuyegha kwa Pilatu. ");
INSERT INTO ndj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Topi Helodi na Pilatu lijuva lilila lila vava lighanja kwanongwa majuva va kumbeli vavelili vachimdwama veni kwa veni. ");
INSERT INTO ndj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Topi Pilatu kavakema vatambika vakomi na fiwongosi pamu na vandu vamonga, ");
INSERT INTO ndj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kavawombela, “Mumuyegha mundu ayu kwa nenga muwomba akuvayaghamisha vandu na kuvajongishela na akulimba Wutwa wa Loma. Ponopa mpikanishi! Nenga namula filongu fyaki paulongolu yenu, ila ng'ona kucha kavifya chindu ha kwa filongu afi fimumuhighili. ");
INSERT INTO ndj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kandi nenga weka hela ha, hata Helodi kamuwuyisha kwa yufwi kamuwona kavahela chindu cha wafu chagolili mbaka chimgoli ahighiwi njifwa. ");
INSERT INTO ndj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ponopa, alatuliwi fiboku, pambeli ngumlekishela.” ");
INSERT INTO ndj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Majuva vosi va lihungu lya Pasaka, Pilatu aveli na chishovi cha kumulekishela mundu yumu kufuma muchijaka. ");
INSERT INTO ndj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lakini vosi vawutilili pamu, “Muwulayi ayu, wutufuwulili Balaba!” ");
INSERT INTO ndj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba aveli mundu yawopiwili muchijaka kwanongwa ya kugola ndilingu mumbwani na kuvawulagha vandu. ");
INSERT INTO ndj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatu aywangili nawu mwanja wa pili, kwanongwa akadayileyi kumlekishela Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lakini veni vadeta kwa lishu likomi, “Mvangilili mulupingika! Mvangilili mulupingika!” ");
INSERT INTO ndj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatu kavawombela mwanja wa tatu, “Kwanongwa liki? Ayu kagola chindu liki cha wafu? Nenga ndichiwona ha hata chindu chimu cha wafu chimugoli awulayiwi. Topi pandimlatula kala dandimlekisheli awuki.” ");
INSERT INTO ndj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lakini veni vadeta kwa mashu makali, “Avangiliwi mulupingika!” Mashu vawu vaweshili. ");
INSERT INTO ndj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Topi Pilatu kahigha kucha wuvadayilili veni yigoleki. ");
INSERT INTO ndj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","kavagayila Yesu yawopiwili muchijaka kwanongwa ya ndilingu na njifwa sha vandu. ");
INSERT INTO ndj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pavaveghi vakumuyegha, vatanganikili na mundu yumu yakemiwa Simoni wa mlima wa Kileni, avelili akufuma kufitava. Topi vamvakula, vampapisha lupingika badili ya Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lipinga likomi lya vandu vamkovekela, kwavelili na vadadala yivavelili vakwinyanyanda na kumlilila Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu kavaghalambukila, kavawombela, “Yumwi vadadala va Yelusalemu! Mkotoo kunilila nenga, muyilili mwaveni na vana venu. ");
INSERT INTO ndj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwanongwa, majuva vakwisa, davadeti, Ngiba Vadadala vavelili vawumba na vaveli mbendi na vangajila kuyongesha. ");
INSERT INTO ndj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chipindi achi, vandu davakandi kufiwombela fidunda, ‘Tuwili!’ na midunda mikomi, ‘Mtugubiki!’ ");
INSERT INTO ndj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Leki vandu vakuligolela libiki lidodi nahau, dayivi wuliwuli kwa libiki liyumu?” ");
INSERT INTO ndj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Vavatolili vandu vamonga vavili, vananongwa, vavawulaghi pamu na mweni. ");
INSERT INTO ndj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pavafikili mahali vapakema “Lipava lya mutwi”, pamuvangililili mulupingika Yesu pamu na vala vananongwa vavili, yumu mwambu wa mlilu na monga mwambu vaki wa mkiyi. ");
INSERT INTO ndj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu adetili, “Tati, vapomeli ava vamanya ng'odu chivagola.” Vavaghana yingwa shaki, kwa kugola do. ");
INSERT INTO ndj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Vandu vawolukili pala pavalola. Na vatavala vakamdanileyi vakawombeyi, “Kavalowola vamonga, ponopa ayilowoli mweni, kucha mweni Kilistu yashawuliwili na Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Vamachonda wuwowu vakamdanileyi, vayendili kumupa siki. ");
INSERT INTO ndj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kunu pavadeta, “Leki yuwi kuva mutwa wa Vayawudi, wuyilowoli umweni.” ");
INSERT INTO ndj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pambindi ya lupingika pavelili payandikiwa naha: “Ayu ndi Mutwa wa Vayawudi.” ");
INSERT INTO ndj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumu wa vala vandu va wafu vatumbikili kamujowola Yesu, kadeta. Nakaka yuwi kuva Kilistu! Wuyilowoli umweni na yufwi. ");
INSERT INTO ndj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lakini yula mundu mpoki wa pili, kamuyangula mumonga kadeta, “Yuwi ukumtila ng'odu Chapanga? Na yuwi kuva muhighilu yiyi duhu? ");
INSERT INTO ndj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yufwi tukuyanga ijala yetu kwa fila fitugolili, ila mundu ayu kagola chindu cha wafu ha.” ");
INSERT INTO ndj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pambeli kadeta, “Yuwi Yesu, ungumbuki nenga pawuva muwutwa waku.” ");
INSERT INTO ndj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu kamuyangula, “Nakaka ngukuwombela nalelu dawuvi pamu na nenga kumbindi paladisu.” ");
INSERT INTO ndj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Topi lwisa lwakandili kuyingila mlima wosi, kwaveli chisi mlima wosi kufuma pamusi saa sita mbaka saa tisa, ");
INSERT INTO ndj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kwanongwa lijuva lyalekili kuvala, pambeli lupayi luvatumbikili munyumba ya Chapanga lwademukili filepa fivili. ");
INSERT INTO ndj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu alilili kwa lishu likomi, kadeta, “Tati, mumawoku vaku nguwuvika Mfuki wangu.” Pamalilili kudeta afi, kasova. ");
INSERT INTO ndj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Topi mkomi wa machonda wa Valoma pawonili fimfumbukilili, kamjuma Chapanga kadeta, “Nakaka ayu aveli mundu munofu!” ");
INSERT INTO ndj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Vandu vosi vavelili vayikungula pala kulola filongu fila, pavafiwonili pafigoleka, vawuka vayenda kayawu, pavayitova tova mufifuva kwa lusungu. ");
INSERT INTO ndj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vala vosi vamumanyili Yesu vawolukili kutali pavalola na vala vadadala vayilongushili pamu kufuma Galilaya, vawolukili kwa kutali pavalola findu afi. ");
INSERT INTO ndj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kwavelili na mundu yumoyu litawa lyaki Yosefu, yavelili mundu wa chitemela cha Vayawudi na aveli mundu msangi na mundu yagola fyadayila Chapanga, mwenikaya wa kaya yimu ya Vayawudi yivayikemaya Alimataya. ");
INSERT INTO ndj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mweni ajumilili ng'odu chilongu na chindu chila chivagolili na mweni aveli mundu wa Alimataya wuwu, mbwani yimu ya Vayawudi, kandi avetileyi wutwa wa kumbindi kwa Chapanga, ");
INSERT INTO ndj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Topi mweni ayendili kwa Pilatu, kamuluva amupi Chikongu cha Yesu. ");
INSERT INTO ndj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pambeli kasunusha chikongu chila kufuma mulupingika na kawushengiteshela ligubiku lya yingwa yitalamili, kawuvika musembi yivasongulili muligangachuma livelili likalihela kusikiwa. ");
INSERT INTO ndj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lyavelili lijuva lya ljumaa lumihi chipindi lijuva lya kupumulila lyaveli likali hela kukanda. ");
INSERT INTO ndj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vala vadadala vayilongushili na Yesu kufuma Galilaya vayendili pamu na Yosefu, kulola sembi na ndambu chikongu cha Yesu pachivikiwili. ");
INSERT INTO ndj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Vawuya kaya, vatanda mafuta va kunungilila pamu na mafuta vengi yivavakema malihamu. Na lijuva lya kupumulila vapumulili ngimu Malawu yivadeta. ");
INSERT INTO ndj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Payifikili lijuva lya kupumulila, pamalavila puti puti, vala vadadala vayendili kula kusembi vatolili mafuta va kunungilila vala yivatandili. ");
INSERT INTO ndj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pavafikili vawona lila ligonguveli libilibishiwa kumbali ya sembi. ");
INSERT INTO ndj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pavayingilili mugati, vauwona ha mvili wa Bambu Yesu, ");
INSERT INTO ndj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pavaveghi vakali vakwikanganika kucha ghani yabilibishili lila ligangachuma, tepu vandu vavili vawolukili pabehi na veni, vafwala yingwa sing'alili mbuletee! ");
INSERT INTO ndj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Topi chipwembwi chavakolili na kugondama mbaka pasi, vala vandu vavawombela, “Kwanongwa liki mukumsaka mundu munofu pagati ya vandu vafwili? ");
INSERT INTO ndj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kava baha ng'odu, kashukuka. Muvi na ngumbungumbu fyavawombilili paghaveyi kula Galilaya: ");
INSERT INTO ndj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwana wa Mundu lasima akamuliwi mumawoku va vandu vaveli na sambi na kuvangiliwa mulupingika na lijuva lya tatu dashukuki.’ ” ");
INSERT INTO ndj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Topi vadadala vala vakumbukili filongu fyaki. ");
INSERT INTO ndj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Vawuka kula kusembi, vawuya vavawombela vala vandundami vaki lilongu na yumu pamu na vandu vamonga findu fyosi vafiwonili. ");
INSERT INTO ndj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vadadala yivavawombilili vandundami, vaveli Maliya Magadalena na Yoana na Maliya mawaki Yakobi na vala vadadala vamonga vavelili pamu, ");
INSERT INTO ndj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Vandundami vayiholili fila filongu fyavawombilili vadadala vala fya upufi hela, vavajumilili ha. ");
INSERT INTO ndj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lakini Petili kafuma, kayenda mbilu mbaka kula kusembi. Kagondama kushungulila mugati, kaliwona ligubiku hela. Kawuya kaya kunu payikang'anika milandu yila yayiwonili. ");
INSERT INTO ndj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lijuva lilila lila, vandundami vavili va Yesu vakayendeyi kaya yimu yivayikema Emawu, yiva utali wa mwanja wa masaa mavili kufuma Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Vavelili vakuywanga fila fyosi yififumbukili. ");
INSERT INTO ndj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pavaveghi vakuywanga na kuyidasha, Yesu mweni kavafumbukila kayendayenda pamu na veni. ");
INSERT INTO ndj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Vamuwona kwa mesu vawu lakini vamumanyili ha. ");
INSERT INTO ndj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu kavadasha, “Chimuywanga liki kunu pamuyendayenda?” Vawoloka padokwa, vanyamala jii, kuwushu yawu kwakikinalili kwa lihingili. ");
INSERT INTO ndj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Muyawu yumu yivamkema Kiliopa, kamdasha, “Wuli yuwi Yelusalemu apa muhenja, kufimanya ng'odu fifumbukili apa majuva ava va pabehi?” ");
INSERT INTO ndj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mweni kavadasha, “Milandu liki?” Vandu vala vayangula, “Yimufumbukilili Yesu wa Nasaleti, mundu ayu aveli mbuyi wa Chapanga muna uwesu wa kugola na kudeta pawulongolu pa vandu vosi. ");
INSERT INTO ndj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Vatambika vakomi na vatavala vetu vamutawula ahighiwi njifwa, pambeli avangiliwi mulupingika. ");
INSERT INTO ndj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yufwi tukashuvilileyi daghavi mkombola wa mlima wa Isilaeli. Lakini nalelu lijuva lya tatu kukandila figoleki findu fyosi afi. ");
INSERT INTO ndj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Vadadala vamonga va kayetu pamalavila puti puti vayendili kusembi, vatulilimusha pavatuwombilili, ");
INSERT INTO ndj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","vawuwona ha mvili waki, vawuya vadeta avafumbukilili makungu kavawombela kava munofu. ");
INSERT INTO ndj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Vayetu vamonga vayendili kusembi vawonili wuwula kucha vala vadadala wuvadetili, vamuwona ha Yesu.” ");
INSERT INTO ndj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu kavawombela, “Mbona muva vapufi nahawu na yimuvelili na ndima sidindalili singajila kujumila fyosi fivadetili vambuyi va Chapanga! ");
INSERT INTO ndj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wuli, yamwilatili ng'odu Kilistu mkombola yashawuliwili na Chapanga kugoboliwa ngimu nawula na kuyingila muukomi waki?” ");
INSERT INTO ndj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kakanda Kuhimulila milandu yosi yimwilatili mweni mumayandiku vang'alili kukandila Musa mbaka vambuyi va Chapanga vosi. ");
INSERT INTO ndj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Vachiselilela chila chijiji chivaveyi vakuyenda na mweni agolili kucha akudayila kuyenda kuulongolu. ");
INSERT INTO ndj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lakini veni vamdedivekili vawomba, “Wikali pamu na yufwi, nongwa lijuva liseneka na lumihi lwa pabehi.” Topi kayingila kaya yila, kayikala pamu na veni. ");
INSERT INTO ndj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pavayikalili pamu mundilya, atolili libumunda kalinemela, kalimetula, kavapa. ");
INSERT INTO ndj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tepu mesu vawu vafuwuka, vamumanya, lakini pambeli kavayaghamila. ");
INSERT INTO ndj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Vayiwombela, wuli! ndima shetu siyaka ng'odu mugati yetu paghaveyi akuwombana na yufwi mudeha na kutugubutulila Mayandiku? ");
INSERT INTO ndj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Vawuka saa yiyila yila vawuya Yelusalemu, vavawona vala vandundami lilongu na yumu vatanganika pamu na vala vamonga vavelili nawu, ");
INSERT INTO ndj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Vadeta, “Bambu nakaka kashukuka, kamfumbukila Simoni!” ");
INSERT INTO ndj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Vala vandundami vavili vavawombela milandu yosi ya findu fila fya munjila na ngimu wamanyikili kwa veni pala pametuleyi libumunda. ");
INSERT INTO ndj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pavaveghi vakudeta milandu ayi. Tepu, Yesu kawoloka gati na gati yawu, kavawombela “Kusika kuvi na yumwi.” ");
INSERT INTO ndj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Valilimuka na vatila vakacheyi vachiwona chishuka. ");
INSERT INTO ndj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lakini mweni kavawombela, nongwa liki mukuyipwelesha? ");
INSERT INTO ndj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Muloli mawoku na mawulu vangu, nimweni nenga. Munembeshi muloli kwanongwa chishuka chivahela mvili na mipava yimelinayu kucha yimuyiwona kwa nenga. ");
INSERT INTO ndj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Padetili kala fila, pambeli kavalangusha mawoku na mawulu vaki. ");
INSERT INTO ndj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Topi pavaveghi vakalihela kujumila, vaveli na luseku nendu kunu pavajinga, avawombilili. Apa muna filivi chochosi chila cha kulya? ");
INSERT INTO ndj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Vamupa chipandi cha somba chikalangiwili. ");
INSERT INTO ndj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kachitola, kalya, pavamlola. ");
INSERT INTO ndj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pambeli kavawombela, “Afi ndi filongu fyangu findivawombilaya pandiveyi pamu na yumwi, kucha, lasima figoleki fyosi fivayandikili Mumalawu va Chapanga vamupili Musa, vambuyi na sabuli.” ");
INSERT INTO ndj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yesu pavavafuwulili luhala lwawu vamanya mayandiku. ");
INSERT INTO ndj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kilistu, ngimu wuvadetili kucha dateshiwi na lijuva lya tatu dashukuki. ");
INSERT INTO ndj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na vandu va milima yosi davalanduliwi kwa litawa lyaki chilongu cha kupomela na ng'ushilu ya sambi, kukandila Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yumwi ndi vatovilela va filongu afi. ");
INSERT INTO ndj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mpikani dandivayegheli yula Tati ajangili kumlayisha, lakini muyikali mumbwanemu, mbaka mupati liwovi kufuma kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kavalongosha panji ya mbwani kuyenda Betaniya, kayinula mawoku vaki kuvanemela. ");
INSERT INTO ndj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pavanemilili kala, kavaleka, Yesu katoliwa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Vamujuma, pambeli vawuyili Yelusalemu kunu vava sekuseku nendu. ");
INSERT INTO ndj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Vayikala chipindi chosi mungengileka ya nyumba ya Chapanga kunu pavamjuma Chapanga.");
INSERT INTO ndj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kufumila pakwandi kwaveli na Chilongu. Chilongu ayu aveli na Chapanga na mweni aveli Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kufumila pakwandi, Chilongu aveli na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chapanga alumbili findu fyosi kupitila mweni na kwahela chindu chilumbiliwi pangajila mweni. ");
INSERT INTO ndj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Chilongu ayu aveli chikandilu cha unofu na awu unofu wuva lwengi kwa vandu. ");
INSERT INTO ndj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lwengi lula lukung'alika mulwisa, wala lwisa luweshi ha kululimba. ");
INSERT INTO ndj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kwaveli mundu yumu yalayishiwili na Chapanga, litawa lyaki Yohani mbatisha. ");
INSERT INTO ndj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yohani mbatisha ayisili kuvatovilela vandu milandu ya lwengi, ili vandu vosi vapikanili chilongu na kujumila. ");
INSERT INTO ndj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mweni aveli lwengi ha, ila ayisili kuvatovilela vandu milandu ya lwengi. ");
INSERT INTO ndj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Alu lwaveli lwengi lwa nakaka, lwengi lukwisa mumlima kuvang'alishila vandu vosi. ");
INSERT INTO ndj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chilongu aveli mumu mumlima na ingava Chapanga alumbili mlima kupitila mweni, lakini vandu va mlima awu vamumanyili ha. ");
INSERT INTO ndj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ayisili pakayaki mweni, lakini vandu vaki vamuyangili ha. ");
INSERT INTO ndj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lakini vandu vosi vamyangili na kumjumila mweni avapili uwesu wa kuva vana va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Vana vawonikili kwa mvili ha wala kwa utami wa mundu ha, ila kwa uwesu wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yula yakemiwili Chilongu kava mundu, mweni kayikala pagati ya yufwi. Na yufwi tuwuwona ukomi waki, ukomi wa Mwana wa paweka yafumili kwa Tati, kamema usangi na nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohani mbatisha atovilelili milandu ya mundu ayu. Kalandula, “Ayu ndi ying'ombaya milandu yaki, kucha, ‘Ayu dayisi kumbeli ya nenga ndi mkomi kupita nenga, kwanongwa mweni avelili chipindi nenga ngalihela kuwoneka.’ ” ");
INSERT INTO ndj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kufuma muusangi yimemili, twavosi yufwi tunemiliwa usangi na usangi munu. ");
INSERT INTO ndj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Chapanga atugayilili Malawu kupitila Musa, lakini usangi na nakaka fyayisili kupitila Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kwahela mundu yamuwonili Chapanga chipindi chochosi. Ila Mwana wa paweka yaveli Chapanga nakaka na yayikala pamu na Tati. Mweni ndi yagolili Chapanga amanyiki. ");
INSERT INTO ndj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Awu waveli utovileli wa Yohani mbatisha kwa vakomi va Vayawudi va Yelusalemu vavalayisha vatambika vamu pamu na Valawi vayendi kwa Yohani mbatisha vakamdashi mweni kava ghani. ");
INSERT INTO ndj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohani alemili ha, ila kavayangula lipala hela padeta, “Nenga Kilistu ha, yalayishiwili na Chapanga” ");
INSERT INTO ndj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pambeli vamdasha, “Ponopa yuwi ghani? Yuwi kuva Eliya?” Yohani kavayangula, “Nenga mweni ha.” Vamdasha kandi, “Yuwi kuva yula mbuyi yulayishiwili na Chapanga yula yitumulembilela?” Kavayangula, “Ng'odu!” ");
INSERT INTO ndj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pambeli vamudasha, “Topi yuwi kuva ghani? Mweni ukuyiwombela liki umweni? Tuwombeli ili tukavawombeli vala vatulayishili.” ");
INSERT INTO ndj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohani kavayangula padeta fila fyawombili Isaya yaveli mbuyi wa Chapanga, “Nenga lishu lya mundu likukema kucheja, ‘Muhololi deha ya Bambu!’ ” ");
INSERT INTO ndj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Vandu vala valayishiwili na Mafwalisayu ");
INSERT INTO ndj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","vamudasha Yohani, “Leki yuwi kuva Kilistu ng'odu, wala Eliya, wala yula Mbuyi, nongwa liki ukubatisha?” ");
INSERT INTO ndj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohani mbatisha kavayangula, “Nenga ngubatisha kwa machi, lakini gati ya yumwi kawoloka mweni mungajila kumumanya. ");
INSERT INTO ndj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mweni ndi yayisa kumbeli ya nenga. Nenga ngujakwa ha hata kuwopola ng'oyi sha mikobasi yaki.” ");
INSERT INTO ndj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Milandu yosi ayi yabwitukili aku Betaniya, kumwambu ya lweni Yoludani, pahala paghaveyi akubatisha Yohani mbatisha. ");
INSERT INTO ndj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chilawu yaki, Yohani kamuwona Yesu akumwisila, kadeta, “Loli! Mwana fungami wa Chapanga yawusha sambi sha mlimawu! ");
INSERT INTO ndj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ayu ndi yideteyi milandu yaki padetili, ‘Mundu yayisa kumbeli ya nenga ndi mkomi kupita nenga, kwanongwa mweni avelili chipindi nenga ngalihela kuwoneka!’ ");
INSERT INTO ndj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ndimweni baha ngamumanyili ng'odu, ila nyisa kubatisha kwa machi ili vandu va Isilaeli vamumanyi.” ");
INSERT INTO ndj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Pambeli Yohani mbatisha kadeta utovileli awu, “Ndimuwona Mfuki Mng'alili pasunuka kufuma kumbindi kwa Chapanga kucha njiva na kayikala kumbindi yaki. ");
INSERT INTO ndj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nenga ndamumanyili ha kucha mweni ghani, ila yula yandumili kubatisha kwa machi ang'ombilili, ‘Dawumuwoni Mfuki Mng'alili akusunuka kufuma kumbindi na kutula pambindi ya mundu. Mundoyu ndi mweni yabatisha kwa Mfuki Mng'alili!’ ");
INSERT INTO ndj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ng'ona chindu achi,” Yohani kadeta, “na nenga nguvatovilela nakaka, kucha ayu ndi Mwana wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chilawu yaki, Yohani mbatisha aveli bahala kandi pamu na vandundami vaki vavili. ");
INSERT INTO ndj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pamuwonili Yesu papita, kadeta, “Loli! Mwana fungami wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Vala vandundami vavili pavapikanishili filongu fila, vamukovikela Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu kaghalambuka, kavawona vala vandumindumi vakumkovikela, kavadasha, “Chimusaka liki?” Veni vamuyangula, “Labi, kwikala koo?” Labi mana yaki Muwula. ");
INSERT INTO ndj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu kavawombela, “Mwisi mupaloli.” Topi vala vandumindumi vayenda, vapawona mahali payikala Yesu. Yaveli lijuva samba lihonga. Veni vayikala pamu na mweni lijuva lila. ");
INSERT INTO ndj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andeleya, mlongu mundu Simoni Petili aveli yumu wa vala vandu vavili yivapikanishili filongu fya Yohani mbatisha na kumukovekela Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bahala pala Andeleya amuwonili tanila Simoni, mlongu mundu. Kamuwombela, “Tumuwona Mkombola yula yashawuliwili na Chapanga!” Mana yaki ndi Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pambeli Andeleya kamuyegha Simoni kwa Yesu. Yesu kamulola Simoni, kadeta, “Yuwi ndi Simoni, mwana wa Yohani, lakini ponopa davakukemi Kefa.” Kefa mana yaki Petili na Petili mana yaki “Ligonguveli.” ");
INSERT INTO ndj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chilawu yaki, Yesu akadayileyi kuyenda Galilaya. Kamuwona Filipu, kamuwombela, “Ungovikeli.” ");
INSERT INTO ndj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipu aveli mwenikaya wa Betisayida, mbwani yivaikalagha Andeleya pamu na Petili. ");
INSERT INTO ndj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipu kamuwona Natanieli, kamuwombela, “Tumuwona mundu yula Musa yayandikili filongu fyaki Muchitabu cha Malawu. Vambuyi wuwula wula vayandikili milandu yaki. Ndi Yesu wa Nasaleti, mwana wa Yosefu.” ");
INSERT INTO ndj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanieli kamdasha Filipu, “Nahawu yikuweshikana chindu chinofu chifumi Nasaleti?” Filipu kamuwombela, “Wisi loli.” ");
INSERT INTO ndj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu pamuwonili Natanieli akumyisila, kadeta, “Loli! Ayu ndi Muyisilaeli nakaka, kwahela ujangi mugati yaki hata padokwa!” ");
INSERT INTO ndj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanieli kamudasha, “Kumanya wuliwuli?” Yesu kamuyangula, “Filipu aveli akalihela kukukema, nenga ngakuwonili pawuveyi pasi ya likuyu.” ");
INSERT INTO ndj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanieli kayangula, “Muwula, yuwi Mwana wa Chapanga! Yuwi Mutwa wa Isilaeli!” ");
INSERT INTO ndj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu kamuwombela, “Ukujumila kwanongwa ngakuwombilili kucha ngakuwonili pasi ya libiki lya likuyu? Dawufiwoni findu fikomi kupita afi!” ");
INSERT INTO ndj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pambeli Yesu kayendelela kuvawombela, “Nakaka nguvawombela, damuwoni kululanga kufuwuka, Makungu va Chapanga pavakwela na kusunuka pambindi ya Mwana wa Mundu!” ");
INSERT INTO ndj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lijuva lya tatu kwavelili na lihungu lya kuyiheta mumbwani ya Kana ya mlima wa Galilaya. Mawaki Yesu avelili pala. ");
INSERT INTO ndj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Wuwula wula Yesu pamu na vandundami vaki valalikiwili mulihungu lila. ");
INSERT INTO ndj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Difwayi payipelili, mawaki Yesu kamuwombela Yesu, “Vandu vavahela difwayi.” ");
INSERT INTO ndj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu kamuyangula, “Mau, ukotoo kung'ombela cha kugola, saa ya nenga yikalihela kufika.” ");
INSERT INTO ndj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pambeli mawaki Yesu kavawombela vala vandumindumi, “Chochosi chavawombela, mugoli.” ");
INSERT INTO ndj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pala pavelili na ngwangu sita sigoliwili na migonguveli. Ngwangu asi shavikiwili na Vayawudi kwanongwa ya kutayila machi va kuying'alisha kucha chishovi chawu. Kila ngwangu yimu yayingilagha ndowu mbili awu ndatu sha machi. ");
INSERT INTO ndj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu kavawombela vala vandumindumi, “Mumemeshi machi mungwangosi.” Veni vamemesha dali. ");
INSERT INTO ndj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pambeli Yesu kavawombela, “Ponopa muteki machi ava muyeghi kwa mkomi wa lihungu.” Vandumindumi vavayegha ");
INSERT INTO ndj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","machi vala yivaghalambukili kuva difwayi kwa mkomi wa lihungu, mweni kavayesha. Mkomi yula amanyili ha koti kuyifumili difwayi yila, lakini vandumindumi yivamyeghilili machi vamanyili koti kuyifumili. Topi kamukema yula yaheta, ");
INSERT INTO ndj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kamuwombela, “Vandu vosi vakutawula tanila difwayi yiveli nofu, pambeli vakutawula yila yingajila kuva nofu. Lakini yuwi kuyilindila difwayi nofu mbaka ponopawu.” ");
INSERT INTO ndj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu kagola muhilu awu wa kwaa aku mbwani ya Kana, mumlima wa Galilaya. Pala palangushili ukomi waki na vandundami vaki vamujumilili. ");
INSERT INTO ndj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagolili kala afi, Yesu pamu na mamundu na vandundami vaki na valongumundu vayenda Kapelinaumu. Aku vayikalili majuva madokwa. ");
INSERT INTO ndj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Payiveyi samba lifika lihungu lya Pasaka ya Vayawudi, Yesu ayendili Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pafikili munyumba ya Chapanga, kavawona vandu pavagola uchulusi wa vasenga na vafungami na vangunda na vandu vamonga vagolagha uchulusi wa kukovanika mbiya pamesa shawu. ");
INSERT INTO ndj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Topi kapota luwoyi, kagola ndomondu, kavavinga vosi munyumba ya Chapanga pamu na vasenga na vafungami vawu. Pambeli kaghalambula mesa sha vala vakovanikeyi mbiya na kusimwaghanga mbiya shawu. ");
INSERT INTO ndj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pambeli kavawombela vala vosi vawuleyi vangunda, “Muwushi findu fyenu apa. Nongwa liki mukuyigola nyumba ya Tati wa nenga kuva soku?” ");
INSERT INTO ndj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Vanachuli vaki vakumbuka fila filongu fiyandikiwili Mumayandiku Vang'alili, “Chapanga Utami wangu kwanongwa ya nyumba yaku wukunyanya kucha motu.” ");
INSERT INTO ndj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pambeli vakomi va Vayawudi vamudasha Yesu, “Wuli dawugoli muhilu liki kutulangusha kucha yuwi kuva na uwesu wa kugola afi?” ");
INSERT INTO ndj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kavayangula, “Mubowoli ayi nyumba ya Chapanga na nenga dandiyijengi kwa majuva matatu!” ");
INSERT INTO ndj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Vayawudi vamudasha, “Ayi nyumba ya Chapanga yajengiwili kwa myaka milongu mchechi na sita! Yuwi ujengi kwa majuva matatu hela?” ");
INSERT INTO ndj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lakini nyumba ya Chapanga yadetili Yesu yaveli mvili waki mweni. ");
INSERT INTO ndj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesu pashukukili kufuma kwa vasovili, vandundami vaki vakumbukili chila chadetili. Vajumila Mayandiku Vang'alili na vajumila filongu fila fyadetili Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu paghaveyi Yelusalemu mulihungu lya Pasaka, vandu vatangalili vamjumilili kwanongwa vafiwonili filangushilu fyagolili. ");
INSERT INTO ndj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lakini Yesu avajumilili ha, kwanongwa avamanyili vosi finofu. ");
INSERT INTO ndj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wuwula wula mweni adayilili ha mundu amtovileli filongu fya mundu wingi, kwanongwa afimanyili fivelili mundima sha vandu. ");
INSERT INTO ndj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kwavelili mkomi yumu wa Vayawudi yakemiwa Nikodemu, yaveli yumu wa lipinga lya Mafwalisayu. ");
INSERT INTO ndj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lijuva limu palumihi kamuyendela Yesu, kamuwombela, “Muwula, tumanya kucha yuwi ndi muwula ulayishiliwi na Chapanga, kwanongwa kwahela mundu yawesha kugola chilangushilu chiwugola yuwi, kucha wula Chapanga kava pamu na mweni ha.” ");
INSERT INTO ndj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu kamuyangula, “Nakaka ngukuwombela, kwahela mundu dawuwoni Wutwa wa kumbindi kwa Chapanga ngajila kuwoneka mwanja wa pili.” ");
INSERT INTO ndj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu kamdasha, “Mundu daweshi wuliwuli kuwoneka paghava mgogolu? Akuwesha kuwuya wuliwuli mugati ya mtima wa mamundu na kuwoneka mwanja wa pili?” ");
INSERT INTO ndj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kamyangula, “Nakaka ngukuwombela, mundu pawoneka ng'odu kwa machi na kwa Mfuki wa Chapanga aweshi ha kuyingila Muwutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mundu akuwoneka mumvili kwa tati mundu na mamundu, lakini akuwoneka kuva mwana wa Chapanga kwa Mfuki wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kotoo kuyikang'anika kwanongwa ngukuwombela kucha mkudayiliwa muwoneki mwanja wa pili. ");
INSERT INTO ndj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Liyegha likupugha kulidayila. Yuwi ukupikana pawuuwumba, lakini kumanya ha kuwufuma wala kuwuyenda. Nahawu ndi yiva kwa kila mundu yawoneka kwa Mfuki.” ");
INSERT INTO ndj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Topi Nikodemu kamudasha, “Filongu afi fikuweshikana wuliwuli?” ");
INSERT INTO ndj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kamuyangula, “Yuwi kuva muwula mumlima wa Isilaeli lakini kumanya ng'odu filongu afi? ");
INSERT INTO ndj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nakaka ngukuwombela, tukudeta filongu tufimanyili na kutovilela filongu tufiwonili, lakini yumwi mukulema kujumila utovileli wetu. ");
INSERT INTO ndj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Leki yumwi mukujumila ng'odu pandivawombela filongu fya mlimawu, damujumili wuliwuli pandivawombela filongu fya kumbindi kwa Chapanga? ");
INSERT INTO ndj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kwahela mundu yayendili kumbindi ila Mwana wa Mundu weka hela, yasunukili kufuma kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kucha Musa wanyasulili njoka wa chumang'andu pambindi ya libiki kula kucheja, wuwula wula Mwana wa Mundu akudayiliwa anyasuliwi, ");
INSERT INTO ndj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ili kila mundu yamjumila apati unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwanongwa Chapanga avatamili vandu va mlimawu, hata kamutawula Mwana waki wa paweka yamutamili, ili kila mundu yamujumila akotoo kuyaghamila, ila ghavi na unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chapanga kamulayisha ha Mwana waki ayisi kuvahigha vandu va mlima awu, ila kamulayisha ayisi kuvalowola. ");
INSERT INTO ndj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mundu yoyosi yamjumila Mwana dahighiwi ha, lakini mundu yoyosi yangajila kumujumila, kahighiwa kala, kwanongwa kamjumila ha Mwana wa paweka wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Damuhighiwi ngimu nahawu: Lwengi luyisa mumlima, lakini vandu vachitama chisi pitu lwengi, kwanongwa fivagola fya wafu. ");
INSERT INTO ndj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila mundu yagola findu fya wafu akulunyekwa lwengi na akwisa ha mulwengi ili fyagola fikotoo kuwoneka lipala. ");
INSERT INTO ndj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lakini mundu yagola findu finofu akwisa kulwengi, ili fyagola fiwoneki lipala kucha fikugoleka ngimu wadayila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pambeli Yesu pamu na vandundami vaki vayenda mlima wa Yudeya. Aku ayikalili nawu pavavabatisha vandu. ");
INSERT INTO ndj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Wuwula wula Yohani mbatisha aveli akubatisha vandu aku Ayinoni pabehi na Salimu, kwanongwa kula kwavelili na machi vatangalili. Vandu vamuyendela na mweni kavabatisha. ");
INSERT INTO ndj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chipindi chila Yohani mbatisha akalihela kuwopiwa muchijaka. ");
INSERT INTO ndj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Vanachuli vamu va Yohani mbatisha vakandili kulimbana na Muyawudi yumu kwa chilongu cha chishovi cha kuying'alisha. ");
INSERT INTO ndj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Topi vamuyendela Yohani mbatisha, vamuwombela, “muwula, ukumkumbuka mundu yula yaghaveyi pamu na yuwi kula kumwambu ya lweni Yoludani, yula yiwutuwombilili milandu yaki? Ponopa akubatisha na vandu vosi vakumuyendela!” ");
INSERT INTO ndj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohani mbatisha kavayangula, “Kwahela mundu yawesha kuva na chindu ngajila kugayiliwa na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mwaveni baha muva vatovileli vangu pandivawombilili, ‘Nenga ndi Kilistu ha, lakini nayishiwa ndimulonguleli.’ ");
INSERT INTO ndj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yaveli na kamwali yahetiwa ndi bambu wa yaheta. Ghanja wa bambu yaheta akuwoloka pabehi, pavetela na kumupikanisha. Papikana lishu lya bambu yaheta akusekilela munu. Ponopa nenga ngusekilela na sekilelu yangu ponopa yiva. ");
INSERT INTO ndj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mweni akudayiliwa ghavi mkomi, nenga ngudayiliwa ndivi mdokwa.” ");
INSERT INTO ndj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mundu yafuma kumbindi kwa Chapanga ndi mkomi wa fyosi. Mundu wa mlimawu ndi wa mlima awu na mweni akudeta filongu fya mlima awu. Lakini mundu yafuma kumbindi kwa Chapanga ndi mkomi wa fyosi. ");
INSERT INTO ndj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mweni akutovilela fila fyafiwonili na kufipikana, lakini kwahela mundu yajumila lulayilayi lwaki. ");
INSERT INTO ndj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mundu yoyosi yajumila lulayilayi lwaki kamanya kucha Chapanga ndi nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yalayishiwili na Chapanga akudeta filongu fya Chapanga, kwanongwa Chapanga akumumemesha Mfuki waki utangalili. ");
INSERT INTO ndj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tati akumtama Mwana waki, kamgayila uwesu wosi mumawoku vaki. ");
INSERT INTO ndj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mundu yamjumila Mwana kana unofu wa jola, lakini yalema kumujumila Mwana, dapati ha unofu wa jola, kwanongwa maya va Chapanga davamuwuyili mweni. ");
INSERT INTO ndj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafwalisayu vapikanila kucha Yesu aveli akupata vanachuli vatangalili munu pitu Yohani mbatisha na kuvabatisha. ");
INSERT INTO ndj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Hata naha mweni Yesu kabatisha ha, ila vandundami vaki ndi vabatisheyi. ");
INSERT INTO ndj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Topi Yesu papikanishili afi, kawuka Yudeya, kawuya Galilaya. ");
INSERT INTO ndj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mumwanja wula, kapitila Samaliya. ");
INSERT INTO ndj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kafika Sikali Mbwani ya Samaliya, pabehi na chitava cha Yakobi chamupili Yosefu mwana waki. ");
INSERT INTO ndj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pala pavelili na litepu lya Yakobi. Yesu ayikalili mulunenengu ya lila litepu, kwanongwa atofyili mwanja. Yaveli pabehi ya pamusi. ");
INSERT INTO ndj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Pambeli mdadala yumu wa mlima wa Samaliya kayisa palitepu kuteka machi. Yesu kamuwombela, “Nguluva machi nandi.” ");
INSERT INTO ndj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Chipindi chila vandundami va Yesu vayendili kumbwani kuhemela filivi. ");
INSERT INTO ndj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Topi yula mdadala kamuyangula, “Yuwi kuva Muyawudi na nenga Msamaliya. Ukuwesha wuliwuli kunuva machi va kulanda?” Vayawudi vayihashagha ha na Vasamaliya. ");
INSERT INTO ndj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kamuyangula, “Leki ungamanyili Chapanga akutawula chindu liki na ayu ghani yakuluva machi va kulanda, ungamuluvili mweni na mweni angakupili machi va unofu.” ");
INSERT INTO ndj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yula mdadala kamuwombela, “Bambu, kuvahela chindu cha kutekela machi na litepu lyeni litali munu. Topi dawupati koti machi va unofu? ");
INSERT INTO ndj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mbuyi wetu Yakobi ndi yatugayilili yufwi litepu ali. Mweni bahala pamu na vana vaki na vang'ongolu vaki valandili machi vaki. Yuwi wukuyiwona kuva mkomi pitu Yakobi?” ");
INSERT INTO ndj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu kamuyangula, “Kila mundu yalanda machi ava dayumilwi kandi ha. ");
INSERT INTO ndj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Lakini mundu yoyosi dalanda machi vala dandimgayili, dayumilwi kandi ha hata padokwa. Kwanongwa machi dandimgayili, davavi mugati yaki mukusesa machi na kutuva machi va unofu wa jola.” ");
INSERT INTO ndj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mdadala yula kamuwombela, “Bambu, topi unyimbi machi veni ili ngotoo kuyumilwa kandi na ngotoo kuyisa kandi apa kuteka machi.” ");
INSERT INTO ndj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu kamuwombela, “Yendi kamkemi mlumi waku ayisi apa.” ");
INSERT INTO ndj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yula mdadala kamuyangula, “Nenga ndivahela mlumi.” Yesu kamuwombela, “Ukudeta nakaka kucha kuvahela mlumi. ");
INSERT INTO ndj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwanongwa wahetiwili na valumi muhanu na ayu yiwikala nayu ponopa mlumi waku ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Pambeli mdadala yula kamuwombela, “Bambu, nguwona kucha yuwi mbuyi. ");
INSERT INTO ndj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Vavaha vetu vamudadavili Chapanga kumbindi ya chidunda achi, lakini yumwi Vayawudi mukudeta kucha Yelusalemu ndi peni patudayiliwa kumdadavila Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu kamuwombela, “Mawu, ujumili nenga, chipindi chikwisa vandu davamdadavili ha Tati kumbindi ya chidunda achi wala aku Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yumwi Vasamaliya mumanya ha chimuchidadava. Vayawudi tukumdadava Chapanga yitumumanyili na kwa kupitila Vayawudi, Chapanga kavakombola vandu vosi va mumlima. ");
INSERT INTO ndj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lakini chipindi dachiyisi na chiva kala, ponopa yivamdadava kwa nakaka vakumudadava tati muufuki na unakaka. Nongwa tati akuvatama vandu yivamdadava ndambu yadayila mweni. ");
INSERT INTO ndj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Chapanga ndi Mfuki, vandu yivamdadava vakudayiliwa vamdadavi Mumfuki na unakaka.” ");
INSERT INTO ndj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mdadala yula kamuwombela, “Manya kucha Mkombola yivamkema Kilistu dayisi, payisa datuhimulili filongu fyosi.” ");
INSERT INTO ndj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu kamuwombela, “Nenga yideta na yuwi, ndi mweni.” ");
INSERT INTO ndj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chipindi chichila Vanachuli vaki vawuya. Vayikanganika kumuwona akuwombana na mdadala. Lakini kwahela mundu yamudashili yula mdadala kucha akudayila liki, awu kumudasha Yesu kucha nongwa liki akuwombana na mdadala yula. ");
INSERT INTO ndj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Topi mdadala yula kachileka chiyungu chaki cha machi pala, kawuya kumbwani, avawombilili vandu, ");
INSERT INTO ndj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mwisi mumuloli mundu yang'ombilili milandu yosi yigolili! Ayu Kilistu nda?” ");
INSERT INTO ndj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Topi vandu vafuma mumbwani yila, vamyendela Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Chipindi chichila vandundami vaki vamudediveka, pavadeta, “Muwula, wulyi tanila filivi!” ");
INSERT INTO ndj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lakini Yesu kavayangula, “Nenga ndina filivi mngajila kufimanya.” ");
INSERT INTO ndj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Vanachuli vaki vakanda kuyidasha, “Kuna mundu yamuyeghilili filivi?” ");
INSERT INTO ndj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu kavawombela, “Filivi fyangu ndi achi: kugola fila fyadayila Chapanga na kumalisha chichuku chanayishili ndiyigoli. ");
INSERT INTO ndj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yumwi mukudeta, ‘Yisighala myesi mchechi chipindi cha kubena chivi.’ Lakini nenga nguvawombela, mugubutuli mesu, muloli fitava! Fivelekwa fikamala, fiva kala kwa kubeniwa. ");
INSERT INTO ndj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mundu yabena fivelekwa dahombiwi na akuvika fivelekwa pamu kwanongwa ya unofu wa jola. Pambeli mundu yakweta na mundu yabena davasekileli pamu. ");
INSERT INTO ndj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwa nongwa detelu yideta, ‘Mundu yumu akukweta mbeyu na wingi akubena fivelekwa’ wuva nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nenga ndavalayishili yumwi kuchitava kubena fivelekwa fingajila yumwi kuyiyasha. Vandu vamonga vayashiwili na yumwi mupata fwayida ya chichuku chawu.” ");
INSERT INTO ndj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vasamaliya vatangalili va mbwani yila vamujumilili Yesu kwanongwa ya filongu fya yula mdadala patovilelili naha, “Ang'ombilili fyosi figolili.” ");
INSERT INTO ndj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Vasamaliya vamuyendela Yesu, vamudediveka ayikali pamu na veni na Yesu kayikala nawu kwa majuva mavili. ");
INSERT INTO ndj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Vandu vatangalili vamjumilili Yesu kwanongwa ya filongu fyaki. ");
INSERT INTO ndj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vamuwombela yula mdadala, “Ponopa tukujumila, kwanongwa filongu fiwutuwombilili weka ha, ila kwanongwa tupikana twaveni na tumanya nakaka kucha ayu ndi Mlowola wa mlima.” ");
INSERT INTO ndj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pavapitili majuma mavili, Yesu awukili pala ayendili Galilaya. ");
INSERT INTO ndj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwanongwa Yesu mweni adetili, “Mbuyi akutundamiwa ng'odu kayaki.” ");
INSERT INTO ndj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Vandu va Galilaya vayendili Yelusalemu kulihungu lya Pasaka. Veni vafiwonili fyosi Yesu fyagolili kula. Topi Yesu pafikili Galilaya, vamlibushilili. ");
INSERT INTO ndj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pambeli Yesu kayenda kandi Kana, mumlima wa Galilaya, pala paghalambulili machi kuva difwayi. Apa kwaveli na mkomi yumu yavelili na mwana mtami aku Kapelinaumu. ");
INSERT INTO ndj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Topi mkomi yula papikanishili Yesu kafuma Yudeya kafika mumlima wa Galilaya, kamyendela, kamluva amlowoli mwana waki yatamikili dabadaba. ");
INSERT INTO ndj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu kamuwombela, “Pamuwona ng'odu chilangushilu na findu fya filoja mujumili ha!” ");
INSERT INTO ndj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yula mkomi kamuwombela, “Bambu, deku tuyendi ponopa mwana wangu akali hela kusova.” ");
INSERT INTO ndj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu kamuwombela, “Yendi, mwana waku mnofu.” Mundu yula kajumila filongu fya Yesu, pambeli kayenda. ");
INSERT INTO ndj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Paghaveyi mudeha akuwuya kayaki, vatanganili na vandumindumi vaki, vamuwombela, “Mwana waku kanana!” ");
INSERT INTO ndj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mweni kavadasha chipindi liki mwana waki pananili. Veni vamuyangula, “Yikaveli saa saba pamusi.” ");
INSERT INTO ndj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pambeli tati ayu kamanya kucha yikaveli pamusi yiyila Yesu pamuwombilili, “Mwana waku akunana.” topi mweni na nyumba yaki yosi vamjumila Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Achi ndi chilangushilu cha pili Yesu chalangushili yaveli paghaveyi akuwuya Galilaya kufuma Yudeya. ");
INSERT INTO ndj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pambeli Yesu kayenda Yelusalemu kulihungu lya Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Aku Yelusalemu pabehi na mlyangu wukemiwa “Mlyangu wa Fungami” Kwaveli na litanda lya machi livalikema kwa Chibulaniya Betisata na lyeni lyaveli na fibudi fimuhanu. ");
INSERT INTO ndj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Vatami vatangalili vawonjagha mula mufibudi fila vangalimesu na vandevindevi na vapombalili. Vavetilagha machi vatimbushiwi, ");
INSERT INTO ndj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kwanongwa makungu wa Bambu asunukeyi teputepu mulitanda lila na kutimbusha machi. Mtami yava wa kwaa kuyingila mulitanda machi pavatimbushiwa, ananili utami wowosi wavelinawu. ");
INSERT INTO ndj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pala kwavelili mundu yumu mtami kwa myaka milongu mitatu na minani. ");
INSERT INTO ndj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu pamuwonili mundu ayu kawonja pala, kamanya kucha aveli mtami kwa myaka yitangalili. Kamdasha, “Ukudayila kunana?” ");
INSERT INTO ndj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yula mtami kamuyangula, “Bambu, nenga ndivahela mundu wa kunyegha mumachi pavatimbushiwa. Kila panyesha kuyingila, mundu wingi akunongulela.” ");
INSERT INTO ndj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu kamuwombela, “Tandamuki, toli litefu lyaku, yendi.” ");
INSERT INTO ndj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tepu mundu yula kanana, katola litefu lyaki, kakanda kuyenda. Chilongu achi chagolikili Mulijuva lya kupumulila, ");
INSERT INTO ndj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","topi vakomi va Vayawudi vamuwombela yula mundu yalowuliwili, “Nalelu Lijuva lya kupumulila. Malawu vetu vakukanisha mundu yoyosi kupapa litefu mulijuva ali.” ");
INSERT INTO ndj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lakini mweni kavawombela, “Yula mundu yanowulili mweni ndi ang'ombilili, ‘Toli litefu lyaku, yendi.’ ” ");
INSERT INTO ndj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Vamudasha, “Ayu mundu yakuwombilili toli litefu lyaku yendi ghani?” ");
INSERT INTO ndj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lakini mundu yula amanyili ha kucha yula yamulowulili aveli ghani, kwanongwa kwaveli na vandu vatangalili na Yesu awukili kala. ");
INSERT INTO ndj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pambeli Yesu kamuwona mundu yula mugati ya nyumba ya Chapanga. Kamuwombela, “Pikanishi, ponopa kunana. Kotoo kugola kandi sambi, ili chikotoo kukufika chilongu chawafu munu.” ");
INSERT INTO ndj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pambeli mundu yula kayenda, kavawombela vakomi va Vayawudi kucha Yesu ndi yamulowulili. ");
INSERT INTO ndj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwanongwa Yesu agolili chindu achi mulijuva lya Kupumulila, Vayawudi vakandili kumuvipila. ");
INSERT INTO ndj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Topi Yesu kavawombela, “Tati wangu akugola chichuku majuva vosi, wuwula wula nenga ngudayiliwa goli chichuku nga Tati wangu.” ");
INSERT INTO ndj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwanongwa ya filongu afi, vakomi va Vayawudi vadayilagha kumuwulagha Yesu, kwanongwa ya kuvifya Lijuva lya Kupumulila weka hela ha, ila wuwula wula kwanongwa adetili Chapanga ndi Tati mundu nahawu ayigolili kalingana na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu kavawombela, “Nakaka nguvawombela, Mwana akuwesha ha kugola chindu weka hela. Akuwesha kugola chila chamuwona Tati mundu pagola weka, kwanongwa chochosi chagola Tati, wuwula wula Mwana wa Chapanga akugola. ");
INSERT INTO ndj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nongwa Tati akumtama Mwana na kamulangusha findu fyosi fyagola mweni. Kandi damulangushi findu fikomi kupita afi, mwavosi yumwi damwikang'aniki. ");
INSERT INTO ndj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kucha wula Tati pashukusha vasovili kuvawuyishila unofu, wuwula wula Mwana akuvagayila unofu vala yivavadayila. ");
INSERT INTO ndj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kandi Tati akumuhigha mundu yoyonda ha, lakini kamupa Mwana chichuku chosi cha kuhigha, ");
INSERT INTO ndj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili vandu vosi vamjumili Mwana kucha wula wuvamtundamila Tati. Mundu yoyosi yalema kumtundamila Mwana, akumlema Tati yamlayishili. ");
INSERT INTO ndj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nakaka nguvawombela, yapikana chilongu cha nenga na kumjumila yula yanayishili, dapati unofu wa jola. Dahighiwi ha, kwanongwa kachama kala njifwa na kayingila muunofu. ");
INSERT INTO ndj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nakaka nguvawombela, chipindi chikwisa, ponopa chifika kala, vandu vasovili davapikanili lishu lya Mwana wa Chapanga na vala vosi davalipikanishi, davayikali. ");
INSERT INTO ndj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kucha wula mweni Tati wavelili chikandilu cha unofu, wuwula wula kamugola Mwana waki kuva chikandilu cha unofu. ");
INSERT INTO ndj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wuwula wula kamupa uwesu wa kuhigha, kwanongwa mweni ndi Mwana wa Mundu. ");
INSERT INTO ndj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mkotoo kuyikang'anika filongu afi, kwanongwa dachiyisi chipindi, vandu vosi vasovili davapikanili lishu lyaki. ");
INSERT INTO ndj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Na veni davafumi musembi shawu. Vala yivagolili findu fya usangi davashukuki na kuva vanofu na vala vagolili wafu davashukuki na kuhighiwa. ");
INSERT INTO ndj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nenga mweni ng'weshi ha kugola chindu chochosi. Nenga nguhigha kucha wang'ombela Chapanga na highilu yangu ya nakaka. Ngugola ha kucha wudayilili nenga, ila kucha wadayilili yula yanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Pandiyijuma nimweni, utovileli wa nenga wuva nakaka ha. ");
INSERT INTO ndj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lakini kuna wingi yandovilela na nenga manya kucha kila chatovilela chiva nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yumwi mwavalayishili vandu kwa Yohani mbatisha na mweni avawombilili utovileli. ");
INSERT INTO ndj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nenga ngudayila ha utovileli wa mundu, ila ngudeta filongu afi ili mulowuliwi. ");
INSERT INTO ndj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohani aveli kucha luliku luyaka na kulangasha na yumwi Mwasekilili lwengi lwaki kwa chipindi chidokwa. ");
INSERT INTO ndj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nenga ndina utovileli mkomi pitu wula wutawuliwili na Yohani mbatisha. Kwanongwa chichuku shanyimbili Tati ndisimalili, fichuku figola fikulangusha kucha Tati ndi yanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tati, mweni yanayishili akundovelela. Yumwi mukalihela kupikanisha lishu lyaki wala mukalihela kuwona wushu waki chipindi chochosi. ");
INSERT INTO ndj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yumwi mukuchivika ha chilongu chaki mugati yenu, kwanongwa yumwi mukumjumila ha yula yalayishiwili na mweni. ");
INSERT INTO ndj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yumwi mkusoma Mayandiku Vang'alili kwanongwa mukuyihola kucha mugati yaki damupati unofu wa jola. Mayandiku vavava ndi yivandovilela! ");
INSERT INTO ndj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Lakini yumwi mukulema kwisa kwa nenga mupati unofu. ");
INSERT INTO ndj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ndadayilagha ha kuyanga ukomi kufuma kwa vandu. ");
INSERT INTO ndj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lakini manya kucha yumwi mumutama ha Chapanga mundima shenu. ");
INSERT INTO ndj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nenga nyisa kwa litawa lya Tati wangu, mumbokela ha. Lakini payiva mundu wingi akwisa kwa litawa lyaki mweni, yumwi damumupokeli. ");
INSERT INTO ndj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mukudayila kuyijuma mwaveni, wala mkusaka ha ukomi wa Chapanga weka hela! Ponopa damuweshi wuliwuli kujumila nenga? ");
INSERT INTO ndj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mkotoo kuyihola kucha nenga dandivagotoleli kwa Tati. Musa, yumwi yimushuvilileyi ndi davagotoleli. ");
INSERT INTO ndj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Leki nakaka mungamjumilili Musa, mungajumilili wuwowu na nengapa, nongwa Musa ayandikili milandu ya nenga. ");
INSERT INTO ndj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lakini leki mukujumila ha fila Musa fyayandikili, mukuwesha wuliwuli kujumila fila fideta nenga?” ");
INSERT INTO ndj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pambeli Yesu kajabuka lihiva lya Galilaya awu lihiva lya Tibeliya. ");
INSERT INTO ndj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lipinga likomi lya vandu lyamkovikelili kwanongwa vafiwonili filangushilu fyagolagha fya kuvalowola vatami. ");
INSERT INTO ndj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pambeli Yesu kakwela kuchidunda, kayikala pamu na vandundami vaki. ");
INSERT INTO ndj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lihungu lya Pasaka ya Vayawudi lyaveli samba lifika. ");
INSERT INTO ndj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu pawonili lipinga likomi lya vandu likumwisila, kamuwombela Filipu, “Koti tukuwesha kuhemela filivi fya kuvagayila vandu vosi ava?” ");
INSERT INTO ndj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu adashili naha ili amuteghi Filipu, kwanongwa mweni amanyili kucha dagoli wuliwuli. ");
INSERT INTO ndj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipu kamuyangula, “Dinali mya mbili hela dasikwili ha kuhemela mibumunda ya kukwila kila mundu.” ");
INSERT INTO ndj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mwanachuli yumu wa Yesu litawa lyaki Andeleya, mlongumundu Simoni Petili kamuwombela Yesu, ");
INSERT INTO ndj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Apa pana mwana kava na mibumunda muhanu na fisomba fivili. Lakini achi chindu ng'odu kwa vandu vatangalili nahawu!” ");
INSERT INTO ndj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu kavawombela vandundami vaki, “Muvawombeli vandu vayikali pasi.” Pahali pala pavelili na lugobi posi. Topi vandu vosi vayikala pasi. Valulumi weka mulipinga lila vavelili milongu mya muhanu. ");
INSERT INTO ndj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pambeli Yesu kayitola yila mibumunda, kamulumba Chapanga, kayimetula na kuvagayila vandu vosi vayikalili pala. Katola fisomba, kagola ngimu wuwula wula. ");
INSERT INTO ndj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Vandu pavayikutili kala, Yesu kavawombela vanachuli vaki, “Mukungashi filivi fisighalili chikotoo kuyaghamila chindu chochosi.” ");
INSERT INTO ndj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Topi vandundami vakungasha fisighalili, vamemesha fitandavala lilongu na fivili fya fibumunda fisighalili. ");
INSERT INTO ndj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Vandu pavawonili chilangushilu chagolili Yesu, vawomba, “Nakaka ayu ndi mbuyi yayisa pamlima.” ");
INSERT INTO ndj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu pamanyili kucha vandu vakudayila kumtola ghavi mutwa kwa liwovi, kawuka, kayenda kuchidunda weka yaki. ");
INSERT INTO ndj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mbungamihi payiyingileyi, vandundami vaki vayenda kulihiva. ");
INSERT INTO ndj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Vayipaka muwatu, vajabuki kumwambu ya lihiva vayendi Kapelinaumu. Lwisa lwayingilili kala, Yesu aveli akalihela kuvayisila. ");
INSERT INTO ndj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mulihiva kwavelili na majinga kwanongwa liyegha lyaveli likomi. ");
INSERT INTO ndj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Vanachuli vaki pavayendili ngombu kucha muhanu naha, vamuwona Yesu akuyendayenda mumbindi ya machi, akwisa pabehi na watu wula. Vatila munu. ");
INSERT INTO ndj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu kavawombela, “Nengapa! Mkotoo kutila!” ");
INSERT INTO ndj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pambeli vadayilili kumpaka muwatu wula, teputepu watu wuyipayika payipalu. ");
INSERT INTO ndj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chilawu yaki, vandu yivasighalili kula kumwambu ya lihiva vamanyili kucha kwavelili watu wumu hela pala. Vamanyili wuwula kucha Yesu kayipaka ha pamu na vandundami vaki, ila vandundami vaki vayendili weka hela. ");
INSERT INTO ndj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pambeli matu vamonga vafumili Tibeliya vafika pala vandu pavalili mibumunda, Bambu padadavili kala kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Topi vandu pavamanyili kucha Yesu pamu na vandundami vaki vawuka pala, vayipakili mumatu vawu, vayenda Kapelinaumu kumusaka Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Vandu pavamuwonili Yesu mwambu wingi wa lihiva, vamudasha, “Muwula, kufika ndili apa?” ");
INSERT INTO ndj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kavawombela, “Nakaka nguvawombela, mukunzaka kwanongwa mwawonili filangushilu figolili ha, ila kwanongwa mwalili mibumunda mwikuta. ");
INSERT INTO ndj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mkotoo kuyifwashila filivi yifiwola, ila muyifwashili filivi fya unofu wa jola. Mwana wa Mundu mweni Tati kamjumisha davapi chilivi achi.” ");
INSERT INTO ndj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Veni vamdasha, “Tugoli liki ili tuweshi kugola chila Chapanga chadayila tugoli?” ");
INSERT INTO ndj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kavayangula, “Achi ndi chindu Chapanga akudayila mugoli, mumujumili yula yamulayishili.” ");
INSERT INTO ndj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Vamudasha, “Dawugoli chilangushilu liki ili tuloli na tukujumili? Dawugoli liki? ");
INSERT INTO ndj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Vavaha vetu valya filivi fikemiwa mana kula kucheja, kucha wuyiyandikiwili Mumayandiku, ‘Avayikutishili mibumunda yifumili kumbindi kwa Chapanga.’ ” ");
INSERT INTO ndj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu kavawombela, “Nakaka nguvawombela, Musa ha yavapili filivi fila fya kumbindi kwa Chapanga. Ila Tati wangu ndi yavapa filivi fya nakaka fya kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwanongwa filivi fyatugayila Chapanga ndi mundu yula yayisa kufuma kumbindi na kuvagayila unofu vandu vaveli pamlima.” ");
INSERT INTO ndj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Vamuwombela, “Bambu, tugayili filivi afi majuva vosi.” ");
INSERT INTO ndj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu kavawombela, “Nenga ndi filivi fya unofu. Mundu yayisa kwa nenga dapikani njala kandi ha na mundu yajumila nenga dayumilwi hata padokwa. ");
INSERT INTO ndj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lakini kucha wundivawombilili, mung'ona ingava mukujumila ha. ");
INSERT INTO ndj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Vosi vanyimbili Tati davayisi kwa nenga na nenga dandimvingi ng'odu mundu yoyosi yayisa kwa nenga. ");
INSERT INTO ndj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwanongwa nyisa kufuma kumbindi kugola fila fidayila nenga ha, lakini kugola fyadayila yula yanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mweni yanayishili akudayila naha, ngotoo kumuyaghamisha hata yumu wa vala vanyimbili, lakini ndivashukushi vosi mulijuva lya mwishu. ");
INSERT INTO ndj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwanongwa chadayila Tati wa nenga achi, kila mundu yamulola Mwana na kumjumila daghavi na unofu wa jola na nenga dandimshukushi mulijuva lya mwishu.” ");
INSERT INTO ndj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Topi Vayawudi vakanda kung'ong'oleka nongwa Yesu adetili, “Nenga ndi filivi fifumili kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Vadeta, “Ayu Yesu mwana wa Yosefu nda? Tuvamanya tati mundu na Mamundu! Ponopa akuwesha wuli wuli kudeta kucha kafuma kumbindi?” ");
INSERT INTO ndj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu kavawombela, “Mukotoo kuying'ong'utekela. ");
INSERT INTO ndj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kwahela mundu yawesha kwisa kwa nenga ila kwa liwovi lya Tati yanayishili. Na yayisa kwa nenga dandimshukushi mundu ayu lijuva lya mwishu. ");
INSERT INTO ndj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Vambuyi vayandika naha, ‘Vandu vosi davawuliwi na Chapanga.’ Na mundu yoyosi yampikanisha Tati na kukamula mawuli vaki dayisi kwa nenga. ");
INSERT INTO ndj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kwahela mundu yamuwonili Tati, ila yula yafumili kwa Chapanga, mweni weka hela ndi yamuwonili Tati. ");
INSERT INTO ndj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nakaka nguvawombela, mundu yajumila nenga kana unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nenga ndi filivi fya Unofu. ");
INSERT INTO ndj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vavaha venu valili mana kula kucheja lakini vasovili. ");
INSERT INTO ndj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lakini afi ndi filivi fifumili kumbindi kwa Chapanga, mundu yoyosi yaghalya filivi afi dasovi ha. ");
INSERT INTO ndj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nenga ndi filivi fya unofu fisunukili kufuma kumbindi kwa Chapanga. Leki mundu yoyosi paghalya filivi afi, dayikali jola. Na filivi afi ndi mvili wa nenga wundiwutawula ili vandu va mlimawu vavi na Unofu.” ");
INSERT INTO ndj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Vayawudi vakandili kulimbana kwa maya veni kwa veni, “Mundu ayu daweshi wuli wuli kutugayila mvili waki tulyi?” ");
INSERT INTO ndj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu kavawombela, “Nakaka nguvawombela, pamulya ng'odu mvili wa Mwana wa Mundu na kulanda mwasi waki, damuupoti Unofu mugati yenu. ");
INSERT INTO ndj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mundu yoyosi yaghalya mvili wa nenga na kulanda mwasi wa nenga, dapati Unofu wa jola na nenga dandimshukushi mulijuva lya mwishu. ");
INSERT INTO ndj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwanongwa mvili wa nenga ndi filivi fya nakaka na mwasi wa nenga ndi chilandi cha nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mundu yoyosi yaghalya mvili wa nenga na kulanda mwasi wa nenga, akwikala mugati ya nenga na nenga nguyikala mugati ya mweni. ");
INSERT INTO ndj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kucha wula Tati waveli Mnofu wanayishili nenga na nenga ndina Unofu kwanongwa ya Tati. Wuwula wula mundu yaghalya mvili wa nenga daghavi na unofu kwanongwa ya nenga. ");
INSERT INTO ndj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Filivi afi fyasunukili kufuma kumbindi kwa Chapanga kucha fila ha fivalili vambuyi vetu kula kucheja na kusova. Lakini mundu yoyosi yaghalya filivi afi daghavi na unofu wa jola.” ");
INSERT INTO ndj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu adetili afi paghaveyi akuwula munyumba ya kudadavila aku Kapelinaumu. ");
INSERT INTO ndj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Vandu vatangalili yivamkovikelili pavapikanishili naha, vadeta, “Ayi milandu yidindala! Ghani yawesha kuyimanya?” ");
INSERT INTO ndj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu amanyili kucha vandundami vaveli vakung'ong'utekela chilongu achi, ngajila kumuwombela mundu. Topi kavadasha, “Chilongu achi chikuvagola muvi na chipwembwi? ");
INSERT INTO ndj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ponopa dayivi wuliwuli pamumuwona Mwana wa Mundu akuwuya kumbindi kula kwaghaveyi dahili? ");
INSERT INTO ndj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mfuki ndi yayegha unofu, liwovi lya mundu likujakwa chindu ha. Filongu findivawombilili ndi filongu fya Mfuki wa Chapanga yayegha Unofu. ");
INSERT INTO ndj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hata naha, vamu va yumwi vangajila kujumila.” Yesu adetili nawula kwanongwa amanyili tangila ngengi vala vangajila kumjumila na yula yadayila kumshengeta. ");
INSERT INTO ndj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pambeli Yesu kadeta, “Ndi nongwa ndadetili kucha kwahela mundu yawesha kwisa kwa nenga mbaka Tati amtangi.” ");
INSERT INTO ndj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwanongwa ya afi fyadetili, vala yivamkovikeleyi vatangalili vamuleka, vamukovikela kandi ha. ");
INSERT INTO ndj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Topi Yesu kavadasha vala vandundami vaki lilongu na vavili, “Wuli na yumwi mukudayila kuyiyendela?” ");
INSERT INTO ndj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petili kamuyangula, “Bambu, datuyendi kwa ghani? Yuwi kuna filongu fya unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ponopa tukujumila na tumanya kucha yuwi kuva Mng'alili yufumili kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu kavawombela, “Nenga ndi yindivashawulili yumwi lilongu na vavili? Lakini muyenu yumu Lijangavandu!” ");
INSERT INTO ndj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu adetli naha nongwa ya Yudasi, mwana wa Simoni Sikaliyoti, yumu wa vala vandundami lilongu na vavili. Pambeli Yuda ndi daamshengeti Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pambeli Yesu ayendili Galilaya, pafumila Yudeya nongwa Vayawudi vadayilili kumuwulagha. ");
INSERT INTO ndj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lihungu lya Vayawudi lya fidimililu lyaveli pabehi, ");
INSERT INTO ndj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ponopa valongu vaki vamuwombela, “Uwuki apa yendi Yudeya, ili vandundami vaku vakaloli mihilu yiwugola aku. ");
INSERT INTO ndj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kwahela mundu yadayila kumanyika na vandu ayifisi. Topi kwanongwa ukugola findu ngimu afi, wuyilangushi kwa vandu vosi vakuwoni.” ");
INSERT INTO ndj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nongwa hata valongu mundu vamjumila ha. ");
INSERT INTO ndj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu kavawombela, “Chipindi changu chifika ha, lakini chipindi chiva jola. ");
INSERT INTO ndj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Vandu va mlima vaweshi ha kuvanyekwa yumwi, lakini vakunyekwa nenga kwanongwa nguvatovilela findu fya wafu fivagola. ");
INSERT INTO ndj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yumwi muyendi kulihungu, nenga nguyenda ha kwanongwa chipindi changu chikali hela kufika.” ");
INSERT INTO ndj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pavawombilili kala naha, kayikala Galilaya. ");
INSERT INTO ndj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Valongu mundu pavayendili kala kula kulihungu, Yesu ayendili kula kulihungu wuwowu, lakini ayendili kwa chifisu ngajila kuyilangusha lipala hela. ");
INSERT INTO ndj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kula kulihungu Vakomi va Vayawudi vakamsakeyi pavayidasha, “Kava koti yula?” ");
INSERT INTO ndj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mulipinga lila kwavelili na lupwepu lukomi lwa mweni. Vamu vawomba, “Mweni mundu mnofu.” Vamu vayangula, “Ng'odu, akuvayaghamisha vandu.” ");
INSERT INTO ndj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lakini kwahela hata mundu yumu yamuwombilili pawelu, kwanongwa vayipwelishili vakomi va Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pambeli pagati ya lihungu lila, Yesu kayingila Munyumba ya Chapanga, kakanda kuwula. ");
INSERT INTO ndj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Topi vakomi va Vayawudi vajuluvala kunu pavadeta, “Mundu ayu kapata koti luhunja ngajila kuwuliwa kuchuli?” ");
INSERT INTO ndj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kavayangula, “Mawuli vawula va nenga ha, ila va yula yanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Leki mundu padayila kugola fila fyadayila Chapanga, damanyi mawuli vangu vakufuma kwa Chapanga awu ngudeta kwa uwesu wangu ndimweni. ");
INSERT INTO ndj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mundu yadeta kwa uwesu waki mweni akusaka ukomi waki mweni. Lakini yula yasaka lujumu lwa yula yamulayishili, ayu ndi muna unakaka na kavahela udesi wowosi. ");
INSERT INTO ndj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa avagayilili ng'odu Malawu? Hata naha kwahela hata yumu gati ya yumwi yavakamula Malawu. Ponopa chimudayilila kung'ulaghila chindu liki?” ");
INSERT INTO ndj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pala vandu vamyangula, “Kuna chinyamkela yuwi! Ghani yadayila kukuwulaya?” ");
INSERT INTO ndj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kavawombela, “Kuna muhilu wumu wugolili wuvagolili mwikang'aniki vosi yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Yumwi mukudumula jandu hata Lijuva lya kupumulila nongwa Musa avalayililili kwingila jandu nakaka dayivi kwa Musa ha, ila kwa vambuyi venu. ");
INSERT INTO ndj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Topi, leki mukuwesha kuvayingisha jandu vandu hata Lijuva lya Kupumulila, ili mukotoo kuvaleka Malawu va Chapanga vamupili Musa, nongwa liki mukungalalila kwa kumulowola mundu mulijuva lya Kupumulila? ");
INSERT INTO ndj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mukotoo kuhigha milandu panji hela, ila muhighi kwa unakaka.” ");
INSERT INTO ndj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Vandu vamu va Yelusalemu vawomba, “Ayu mundu yula yivamsaka vamuwulayi nda? ");
INSERT INTO ndj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mumloli ponopa akudeta pawelu hela, wala vakumuwombela chindu ha! Awu pamongapa vakomi naveni vamanya nakaka kucha ayu ndi Kilistu. ");
INSERT INTO ndj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lakini tumanya mahali mundu ayu pafuma. Kilistu payisa kwahela mundu damanyi mahali kwafumili.” ");
INSERT INTO ndj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Topi Yesu pawuleyi Munyumba ya Chapanga adetili naha kwa lishu likomi, “Yina yumwi mukuyijuma kucha mumanya na pafumili. Nyisa kwa liwovi lyangu nimweni ha, lakini yanayishili muna unakaka. Yumwi mumumanya ha, ");
INSERT INTO ndj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Lakini nenga ndimumanya kwanongwa ndafumili kwa mweni na mweni ndi yanayishili.” ");
INSERT INTO ndj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Topi vamusakili vamukamuli, lakini kwahela mundu yamukamulili kwanongwa chipindi chaki chafikili ha. ");
INSERT INTO ndj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Vandu vatangalili mulipinga lila vamujumilili mweni, pavadeta, “Kilistu payisa dagoli filangushilu fitangalili munu pitu mundu ayu?” ");
INSERT INTO ndj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafwalisayu vapikanila kung'ong'oleka mulipinga lya vandu kwa mundu yula, veni pamu na vatambika vakomi vavalayisha vamachonda vamukamuli Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Topi Yesu kacha, “Ngali na yumwi chipindi chidokwa hela, pambeli dang'uyi kwa mweni yanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Damunzaki lakini damung'oni ng'o, yumwi damufikili ha pala dandivi.” ");
INSERT INTO ndj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Vayawudi vayidasha veni kwa veni, “Ayu dayendi koti pangajila yufwi kumuwona? Dayendi kwa Vayawudi yivapwililikili Muugiliki na kuvawula Vagiliki? ");
INSERT INTO ndj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kana mana liki wadetili, Damunzaki lakini damung'oni ha na pala dandivi damuweshi ha kufika?” ");
INSERT INTO ndj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lijuva lya mwishu lya Lihungu lila lyaveli lijuva likomi lya Lihungu, Yesu kawoloka kudeta, kwa lishu likomi, “Mundu payumilwa, ayisi kwa nenga alandi. ");
INSERT INTO ndj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mundu yoyosi yajumila nenga, Kucha yivadeta Mayandiku Vang'alili, ‘Nyeni sha machi va Unofu dasimwayiki kufuma mugati ya ndima yaki’ ” ");
INSERT INTO ndj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu padeteyi naha, aveli akudeta chilongu cha Mfuki Mng'alili, yula vandu yivamveta kumuyanga. Mbaka chipindi chila, Mfuki avelili akalihela kwisa, kwanongwa Yesu aveli akalihela kujumiwa. ");
INSERT INTO ndj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Vandu vamonga mula mulipinga pavapikanishili filongu fila, vadeta, “Mundoyu nakaka ndi yula Mbuyi wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Vamu vadeta, “Ayu ndi Kilistu!” Lakini vamu vayidasha, “Yingaweshili wuli wuli Kilistu afumi Galilaya? ");
INSERT INTO ndj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mayandiku Vang'alili vadeta ng'odu kucha Kilistu dawoneki kufuma mulukolu lwa Mutwa Dawudi na mumbwani ya Betelehemu?” ");
INSERT INTO ndj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Topi vandu vakulekanila mula mulipinga kwanongwa ya Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vandu vamu vadayilagha kumuwopa, lakini kwa hela mundu yayeshili kumkamula. ");
INSERT INTO ndj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pambeli vala machonda vawuya kwa Vatambika vakomi pamu na Mafwalisayu, veni vavadasha machonda, “Nongwa liki Yesu mumuyegha ng'odu?” ");
INSERT INTO ndj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Vamachonda vayangula, “Kwahela mundu yawesha kulonga kucha ayu yavalonga!” ");
INSERT INTO ndj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafwalisayu vavadasha, “Wuli na yumwi wuwowu mujangiwa?” ");
INSERT INTO ndj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Ghani pagati ya vakomi vetu awu Mafwalisayu yamujumilili? ");
INSERT INTO ndj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lakini lipinga lyosi ali lya vandu vangajila kumanya Malawu va Chapanga vamupili Musa, lilapiwa.” ");
INSERT INTO ndj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemu, yula yamyendileyi Yesu paulongolu, avelili yumu wa Mafwalisayu avelili bahala. Kavawombela, ");
INSERT INTO ndj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kulingana na Malawu, tukuwesha ha kumuhigha mundu ngajila kumupikanisha tanila na kumanya fila fyagolili.” ");
INSERT INTO ndj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Veni vamuyangula, “Na yuwi wuwowu kufuma Galilaya? Kaloleshi uswanu mayandiku vang'alili dawuwoni kucha Galilaya kukufuma ha mbuyi.” ");
INSERT INTO ndj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pambeli kila mundu kawuya kayaki. ");
INSERT INTO ndj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pambeli vandu vosi vayendili kaya, Yesu ayendili kuchidunda cha miseyituni. ");
INSERT INTO ndj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chilawu yaki lumbutila kayenda kandi munyumba ya Chapanga. Vandu vosi vamuyendela, mweni kayikala akuvawula. ");
INSERT INTO ndj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Vawula va Malawu pamu na Mafwalisayu vamuyendela mdadala yumu yivamkamulili muuwoni. Vamuwolosha pagati ya veni. ");
INSERT INTO ndj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pambeli vamudasha Yesu, “Muwula, mdadala ayu tumkamula muuwoni. ");
INSERT INTO ndj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mumalawu va Chapanga vamupili Musa vatulayilili yufwi vatuwombela mdadala kuchaa ayu atovangiwi na miganga mbaka asovi. Ponopa yuwi ukucha wuli?” ");
INSERT INTO ndj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Vadetili naha kwa kumyesha, vapati chilongu cha kumuhigha. Lakini Yesu agondamili pasi, kayandika pasi na chala chaki. ");
INSERT INTO ndj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pavayendelili kumudasha, Yesu katandamuka kavawombela, “Mundu yangajila sambi kwa yumwi atoli liganga akandi kumtova.” ");
INSERT INTO ndj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pambeli kagondama kandi, akuyandika pasi. ");
INSERT INTO ndj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pavapikanishili nawula, vakanda kuwuka yumu yumu, valongulili vavaha. Yesu kasighala pamu na yula mdadala kawoloka bahala. ");
INSERT INTO ndj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu patandamukili kamudasha yula mdadala, “Vava koti vala vandu? Kwahela yakuhighili kuva muna nongwa?” ");
INSERT INTO ndj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yula mdadala kamyangula, “Bambu, kwahela hata yumu!” Yesu kadeta, “Hata nenga ngukuhigha ng'odu uyiyendeli, lakini ponopa ukotoo kugola kandi sambi.” ");
INSERT INTO ndj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu paywangili kandi na Vayawudi kavawombela, “Nenga lwengi lwa mlima. Yangovekela nenga dayendi yendi ng'odu mulwisa daghavi na lwengi lwa Unofu.” ");
INSERT INTO ndj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafwalisayu vamuwombela, “Yuwi ukuyitovelela umweni, topi, utovileli waku wuva nakaka ha.” ");
INSERT INTO ndj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu kavayangula, “Mani nguyitovilela nimweni utoveleli wa nenga wuva nakaka, wula nenga ngumanya kufumili na kunyenda. Lakini yumwi mumanya ng'odu kufumili awu kunyenda. ");
INSERT INTO ndj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yumwi mukuhigha milandu ya vandu, nenga ngumuhigha mundu ha. ");
INSERT INTO ndj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Hata pahigha, ngulamula fya maha, kwanongwa nenga ndiva weka hela ha, Tati yanayishili kava pamu na nenga. ");
INSERT INTO ndj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yiyandikwa Mumalawu venu utovileli wa vandu vavili wa nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nenga nguyitovilela ndimweni na mweni Tati yanyeghili akundovelela.” ");
INSERT INTO ndj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Veni vamudasha, “Tati waku kakoti?” Yesu kayangula, “Yumwi mumanya ng'odu nenga, wala Tati wangu mumumanya ha. Leki mungamanyili nenga, mungamumanyili wuwula na Tati wangu.” ");
INSERT INTO ndj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu kadeta filongu fila muchumba gati cha kuvikila sanduku lya mbiya paghaveyi akuwula Munyumba ya Chapanga. Kwahela mundu yamkamulili nongwa saa yaki yaveli yikali hela kufika. ");
INSERT INTO ndj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu kavawombela kandi, “Nenga nguyenda, damnzaki, damusovi mu sambi shenu kunyenda nenga yumwi damuweshi ng'odu kufika.” ");
INSERT INTO ndj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Vakomi va Vayawudi vayidasha, “Mani dayiwulayi? Kadeta, kwayenda datuweshi ng'odu kufika.” ");
INSERT INTO ndj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu kavayangula, “Yumwi va pasi, nenga wa kumbindi. Yumwi va mlima awu, nenga wa mlima awu ha. ");
INSERT INTO ndj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndivawombela damsovi mu sambi shenu. Damusovi mu sambi shenu leki mukujumila ng'odu kucha Nenga ndi Mweni.” ");
INSERT INTO ndj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Veni vamudasha, “Yuwi kuva ghani?” Yesu kavayangula, “Chilongu chichila chila ndivawombilili kufumila dayili! ");
INSERT INTO ndj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndiva na fitangalili fya kuvawombela na kuvahigha yumwi. Yula yanayishili kava nakaka na nenga nguwuwombela mlima filongu fimbikanishili kufuma kwa mweni.” ");
INSERT INTO ndj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Veni vamanyili ng'odu ngimu Yesu akuywanga milandu ya Tati mundu. ");
INSERT INTO ndj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Topi Yesu kadeta, “Pamumujuma kala Mwana wa Mundu, damumanyi kucha ‘Nenga ndi Mweni’, Ngugola findu fyosi kwa liwovi lyangu ha, ngudeta fila fyanayili Tati. ");
INSERT INTO ndj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yula yanayishili kavapamu na nenga, mweni kaneka weka hela ha, kwanongwa majuva vosi ngugola fila fyadayilili mweni.” ");
INSERT INTO ndj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mweni padeteyi afi vandu vatangalili vamjumilili. ");
INSERT INTO ndj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu kavawombela Vayawudi yivamjumilili, “Ngimu pamukombishela mawuli va nenga nakaka damuvi vandundami va nenga. ");
INSERT INTO ndj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Damuwumanyi unakaka na unakaka dawuvagoli mupekisuki.” ");
INSERT INTO ndj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Veni vamyangula, “Yufwi tuvaleli va Ibulahimu, twakali hela kuva vavanda va mundu yoyosi yula. Kuna mana liki paudeta, ‘Damuvi pekesu’?” ");
INSERT INTO ndj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu kavayangula, “Nakaka nguvawombela, mundu yoyosi yagola sambi kava mvanda wa sambi. ");
INSERT INTO ndj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mvanda akwikala ha pakaya majuva vosi, Mwana akwikala kaya majuva vosi. ");
INSERT INTO ndj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mwana pavavavika pekesu, damuvi pekesu nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Manya kucha yumwi uleli wa Ibulahimu, yumwi mkuyesha kung'ulaya kwanongwa mulema kupokela mawuli vangu. ");
INSERT INTO ndj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nenga nguvawombela fila fyanangushili Tati wangu, lakini yumwi mkugola fila fyavawombilili vatati venu.” ");
INSERT INTO ndj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Veni vamuyangula, “Yina tati wetu Ibulahimu!” Yesu kavayangula, “Leki yumwi mungaveli vana va Ibulahimu,” Yesu kayangula, “mungagolili fila fyagolili Ibulahimu. ");
INSERT INTO ndj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nenga nguvawombela nakaka fimbikanishili kufuma kwa Chapanga, ponopa mukunzaka mung'ulayi nenga. Ibulahimu agolili nga nahau ha! ");
INSERT INTO ndj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yumwi mkugola chichuku sha tati wenu.” Veni vamuwombela, “Yufwi tuwonekela muuwoni ha, tuva na Tati yumu hela ndi Chapanga. ‘Nakaka twavana vaki’” ");
INSERT INTO ndj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu kavawombela, “Kucha Chapanga angaveli Tati wenu nakaka, mungandamili, kwanongwa fuma kwa Chapanga ponopa ndiva apa. Nenga nyisa ndiyilata ndimweni ha, ila mweni ndi yanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wuliwuli mukufimanya ng'odu afi fideta? Ponopa mukulemwa kupikanisha unjagila wa nenga. ");
INSERT INTO ndj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yumwi tati wenu Lijangavandu, mkugola milandu yadayilili tati wenu. Kufumila pakwandi mweni avelili akuwulagha vandu. Kana chiganu ng'odu, padeta fya hela akudeta fifuma mumunda yaki mweni, kwa nogwa mweni mudesi na tati wa udesi. ");
INSERT INTO ndj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nenga nguwomba nakaka, lakini mkujumila ng'odu nenga. ");
INSERT INTO ndj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ghani wa yumwi kana utovelela kucha nenga ndiva na sambi? Nenga ngudeta nakaka, mbona yumwi mkujumila ng'odu nenga? ");
INSERT INTO ndj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yula yafumili kwa Chapanga, akupikanisha fya Chapanga, leki pamumpikanisha ng'odu kwanongwa yumwi va Chapanga ha.” ");
INSERT INTO ndj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Vayawudi vamdasha, “Yufwi tukudeta finofu ng'odu patudeta yuwi Msamaliya na yuwi kuva na chinyamkela?” ");
INSERT INTO ndj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kayangula, “Nenga ndivahela chinyamkela, nenga ngumutundamila Tati wangu na yumwi mukubedala nenga. ");
INSERT INTO ndj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nenga ngusaka ukomi ha, kwaveli mweni yasaka na kana luhighilu lwa nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nakaka nguvawombela: yakamula mawuli va nenga dasovi ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Vayawudi ndavawomba, “Ponopa tumanya kucha yuwi kuna chinyamkela! Ibulahimu kasova na vambuyi vasova, ponopa yuwi ukuwomba, mundu pakamula chilongu chaku dasovi ha jola. ");
INSERT INTO ndj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wuli ukwigola kuva mkomi pitu Tati wetu Ibulahimu yasovili? Na Vambuyi vetu vasova wuwula. Yuwi ukuyigola kwa ghani?” ");
INSERT INTO ndj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kavayangula, “Ukomi wangu ndimweni, chindu ha. Tati wangu, yumwi mukudeta ndi Tati wenu ndi yajuma nenga, ayu ndi Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hata yumwi mwamumanyili ha, nenga ndimumanya. Padeta ndimumanya ng'odu, dandivi ngudeta fya hela kucha yumwi, nenga ndimumanya na chilongu chaki nguchikamula. ");
INSERT INTO ndj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ibulahimu, tati wenu anemelili paliwonili lijuva lya kwisa nenga, mweni kasekelela.” ");
INSERT INTO ndj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Vayawudi vamuwombela, “Yuwi ukali hela kuva na myaka milongu muhanu ya kuyikala, yuwi kumuwona Ibulahimu?” ");
INSERT INTO ndj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu kavawombela, “Nguvawombela nakaka Ibulahimu akali kuwoneka, nenga navelili.” ");
INSERT INTO ndj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bahala pala vasola migonguveli vamtovi, lakini Yesu kayifisa, pambeli kafuma munyumba ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu papiteyi kamuwona mundu yumu, ngalimesu kufumila kuwoneka kwaki. ");
INSERT INTO ndj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vanachuli vaki vamudasha, “Muwula! Ghani yagolili sambi, Mundu ayu awu vala vamlelili ngalimesu.?” ");
INSERT INTO ndj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kayangula, “Ayu kagola ng'odu sambi na vala vamlelili vagola sambi ha, nongwa chichuku cha Chapanga chiwoneki kwa mweni. ");
INSERT INTO ndj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yikudayiliwa tugoli fichuku fya mweni yanyeyili nongwa ponopa pamusi na lumihi lukwisa mundu daweshi ng'odu kugola chichuku. ");
INSERT INTO ndj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pandiva mumlima awu, nenga lwengi lwa mlima.” ");
INSERT INTO ndj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pawombili nawula, katema mita pasi, kadaka na uganga kagola mitika, kamushagha mumesu mundu yula ngalimesu. ");
INSERT INTO ndj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kamuwombela, “Yendi kayipwembuli kuwushu mulitanda lya Siloamu.” Siloamu mana yaki, Vamlayishili. Kayenda kuyipwembula kuwushu, kawuya kunu palola. ");
INSERT INTO ndj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Vandu va pabehi na pala payikalagha na vandu vamumanyili dahili, vayidasha, “Ayu mundu yuyula yayikalagha kunu pavaluva vandu?” ");
INSERT INTO ndj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vamu vadeta, ayu mweni. Vamu vadeta, “Mweni ha, kayifwana na mweni.” Ponopa mweni kadeta, “Nenga ndi mweni yinuveyi.” ");
INSERT INTO ndj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Veni vamudasha, “Mesu vaku vafuwuka wuliwuli?” ");
INSERT INTO ndj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mweni kayangula, “Mundu yivamkema Yesu kagola mitika, kanshagha mumesu, kang'ombela nyendi ngayipwembuli kuwushu mulitanda lya Siloamu. Nyenda, ndiyipwembula kuwushu tepu nola.” ");
INSERT INTO ndj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Vamudasha, “Mundu ayu kava koti?” Kavayangula, “Nenga manya ha.” ");
INSERT INTO ndj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pambeli vamyegha mundu yula yaghaveyi ngalimesu kwa Mafwalisayu. ");
INSERT INTO ndj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesu lijuva lila lyagoleyi mitika kumgola mundu yula aloli, lyaveli Lijuva lya kupumulila. ");
INSERT INTO ndj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mafwalisayu vamudasha kandi, “Kuwesha wuliwuli kulola?” Kavayangula, “Kanshagha mitika kumesu, pambeli ndiyipwembula nola.” ");
INSERT INTO ndj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafwalisayu vamu vawomba, “Mundu ayu yagolili naha kafuma kwa Chapanga ha, kwanongwa kakamula ha Malawu va Lijuva lya kupumulila.” Vamonga vadeta, “Akuwesha wuliwuli mundu yavelili na sambi kugola filangushilu kucha afi?” Vamu vatapukili. ");
INSERT INTO ndj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mafwalisayu vamudasha kandi, “Yuwi ukuwomba yula ghani? Yakugolili uloli.” Mweni kavawombela, “Yula mbuyi.” ");
INSERT INTO ndj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Vakomi va Vayawudi vajumilili ng'odu kucha mundu ayu aveli akulola ha pakwandi, ponopa akulola, mbaka pavavakemili valeli vaki. ");
INSERT INTO ndj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Veni vavadasha, “Ayu mwana wenu mwamulelili ngajila kulola? Ponopa yiva wuli wuli akuwesha kulola?” ");
INSERT INTO ndj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Valeli vaki vayangula, “Tumanya kucha ayu mwana wetu, tumlela ngalimesu.” ");
INSERT INTO ndj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ponopa tumanya ha kucha kawesha wuliwuli kulola, yamgolili aloli tumumanya ha. Mumudashi, mweni kava kala mkomi, akuwesha kuwomba. ");
INSERT INTO ndj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Valeli vawombili nawula vavatilili vakomi va Vayawudi, veni valonganili mundu yoyosi yamjumilili Kilistu masiya vandu davamuvingi munyumba ya kudadavila. ");
INSERT INTO ndj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kwa nongwa ayi valeli vadeta, “Mumdashi, mweni kava kala mkomi.” ");
INSERT INTO ndj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Vamkema kandi yula yaghaveyi ngalimesu, vamuwombela, “Umupi ukomi Chapanga leki yuwi dawudeti nakaka! Yufwi tumumanya mundu ayu yakulowulili yuwi kana sambi.” ");
INSERT INTO ndj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kavayangula, “Mani kana sambi awu ng'odu, nenga manya ha. Chimanyili nenga chindu chimu hela kucha ngaveli ngalimesu ponopa ngulola!” ");
INSERT INTO ndj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Veni vamudasha kandi, “Kagola liki kwa yuwi? Kakufuwula wuliwuli mesu vaku?” ");
INSERT INTO ndj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kavayangula, “Ndivawombela kala mupikanisha ng'odu, kwanongwa liki mkudayila kupikanisha kandi? Yumwi wuwu mkudayila kuva vandundami vaki?” ");
INSERT INTO ndj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Veni vamkalalila, pavadeta, “Yuwi kwa mwanachuli vaki! Yufwi vandundami va Musa! ");
INSERT INTO ndj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tumanya kucha Chapanga amuwombilili Musa, lakini mundu yula yufwi tumanya ng'odu kwafumili.” ");
INSERT INTO ndj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mundu yula kavayangula, “Achi chiloja, yumwi mumanya ng'odu kwafumili, lakini ndi yafuwulili mesu vangu. ");
INSERT INTO ndj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yufwi tumanya Chapanga akuvapikanisha ha vala vaveli na sambi, akuvapikanisha vang'alili na vala vampikanisha mweni na kugola chavadayilili kugola. ");
INSERT INTO ndj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kufumila ukandi mlima kwa hela mundu, tupikanishili ngalimesu kufumila kuwoneka, kafuwuka mesu vaki. ");
INSERT INTO ndj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mundu ayu mani kafuma kwa Chapanga ng'odu, angaweshili ha kugola ngimu wagolili.” ");
INSERT INTO ndj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Veni vayangula naha, “Yuwi kuwonikela na kuleliwa mu sambi, wuliwuli yuwi ukutuwula yufwi?” Vamufumisha panji ya nyumba ya kudadavila. ");
INSERT INTO ndj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu apikanishili kucha vamvinga mundu yula panji. Pavatang'anili na mweni kamdasha, “Yuwi ukumjumila Mwana wa mundu?” ");
INSERT INTO ndj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mweni kadasha, “Ghani Bambu? Ung'ombeli nguwesha kumujumila!” ");
INSERT INTO ndj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu kadeta, “Kumuwona kala, mweni ayu ponopa ukuywanga nayu.” ");
INSERT INTO ndj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mundu yula kadeta, “Ngujumila Bambu.” Pambeli kamtundamila. ");
INSERT INTO ndj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu kadeta, “Nyisa mumlima awu kuhigha, ili vangalimesu valoli na vala yivalola vavi ngalimesu.” ");
INSERT INTO ndj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafwalisayu vamu vaveli pamu na Yesu, pavapikanishili chadetili, vamudasha, “Nakaka na yufwi ngalimesu?” ");
INSERT INTO ndj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu kavayangula, “Leki mungaveli vangalimesu, mungaveli na sambi ha, lakini ponopa mkudeta na mkulola, sambi muvanashu.” ");
INSERT INTO ndj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu avawombilili, “Nakaka nguvawombela, mundu yoyosi yayingila muligeleli lya fungami ngajila kupitila mumlyangu, lakini akwingilila pengi, ayu mwifi na mpoki. ");
INSERT INTO ndj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mundu yayingila kwa kupitila pamlyangu ayu nakaka ndi mdimi wa vafungami. ");
INSERT INTO ndj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mdima mlyangu akumfuwulila mundoyu na vafungami vakupikanisha lishu lyaki. Na mweni akuvakema vafungami vaki kwa matava vawu na kuvafumisha panji. ");
INSERT INTO ndj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mweni pavafumisha vafungami vosi panji, akutangila, vafungami vakumkovikela, nongwa valimanya lishu lyaki. ");
INSERT INTO ndj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Davamkovikeli ha mundu wingi, ila mhenja davamtuvi nongwa valimanya ha lishu lyaki.” ");
INSERT INTO ndj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu kavawombela chilangushilu achi, lakini veni vamanya ha kucha kana mana liki. ");
INSERT INTO ndj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pambeli Yesu kavawombela kandi, “Nakaka nguvawombela, nenga ndiva mumlyangu wa vafungami. ");
INSERT INTO ndj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Vala vamonga vosi yivanonguleli nenga ndi vefi na vapoki na vafungami vavapikanisha ng'odu. ");
INSERT INTO ndj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nenga ndi mlyangu. Mundu yoyosi yayingila kupitila kwa nenga dalowuliwi. Dayingili na kufuma kusaka filivi. ");
INSERT INTO ndj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwifi akwisa kwanongwa ya kuhija, kuwulagha na kuyananga. Nenga nyisa mpati unofu, kandi mukotoo kuyangilwa na chindu chochosi mungalilu yenu. ");
INSERT INTO ndj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nenga ndi msangi. Mdimi msangi akusova kwanongwa ya vafungami vaki. ");
INSERT INTO ndj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mundu wa ijala, mdimi ha, vafungami vaki ha, pamuwona chingekembi akwisa, akuvaleka vafungami akutuva, pambeli chingekembi akuvakamula vafungami na vakuyaghamila mudasi. ");
INSERT INTO ndj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mweni akwipwelesha chindu ha kwanongwa ya vafungami, mweni akuwesha kutuva nongwa mweni mundu wa ijala hela. ");
INSERT INTO ndj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nenga mdimi msangi. Nguvamanya vafungami vangu na veni vamanya nenga. ");
INSERT INTO ndj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kucha Tati wamanyili nenga na nenga ndimumanya Tati. Nenga ngusova kwanongwa ya vafungami vangu. ");
INSERT INTO ndj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ndiva nawu vafungami vamonga, veni va ligeleli ali ha. Na lasima dandivayeghi wuwula na lishu lyangu davalipikani, pambeli davavi lipinga limu na mdimi yumu. ");
INSERT INTO ndj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tati kandama, kwanongwa ayi ngusova pambeli mbati unofu kandi. ");
INSERT INTO ndj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kwahela mundu yang'ushila, ila nenga nguuwusha padayila nimweni, nenga ndiva na uwesu wa kuuwusha na kuuwuyishila kandi. Malawu ava yimbokilili kufuma kwa Tati wangu.” ");
INSERT INTO ndj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Luyingila kandi lushoshu Vayawudi kwa Vayawudi kwanongwa ya filongu afi. ");
INSERT INTO ndj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Vatangalili vawomba, “Kana chinyamkela, kandi kana lukwali! Wuli mukumpikanisha?” ");
INSERT INTO ndj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Vamu vawomba, “Filongu afi fya mundu munachinyamkela ha, Chinyamkela akuwesha kuvagola vandu vangalimesu mesu, valoli?” ");
INSERT INTO ndj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kula Yelusalemu kwaveli na lihungu lya kuyihadisha nyumba ya Chapanga Chipindi chila kwaveli na lupepu. ");
INSERT INTO ndj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu aveli akuyendayenda munyumba ya Chapanga, mumdamwa wa Solumoni. ");
INSERT INTO ndj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Topi Vayawudi vamshengeta Yesu, vamudasha, “Dautuleki muchipwembwi mbaka ndili? Tuwombeli kucha yuwi kuva Kilistu?” ");
INSERT INTO ndj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kavayangula, “Ndivatovilela, lakini mujumila ha. chichuku achi chigola kwa litawa lya Tati wangu ndi chikundovilela nenga. ");
INSERT INTO ndj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yumwi mukujumila ng'odu kwanongwa muva vafungami vangu ha. ");
INSERT INTO ndj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Vafungami vakupikana lishu lyangu, nenga ndivamanya, vala vangovikela. ");
INSERT INTO ndj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nenga nguvagayila unofu wa jola, veni davayaghamili ng'odu, kwahela mundu danyaghi muliwoku lyangu. ");
INSERT INTO ndj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tati wangu yanyimbili ava mkomi kupita vosi, kwahela mundu kandi yawesha kuvanyagha muliwoku lya Tati wa nenga. ");
INSERT INTO ndj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nenga na Tati, tuva yumu.” ");
INSERT INTO ndj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Vayawudi vasola miganga vamugumi. ");
INSERT INTO ndj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu kavawombela, “Ndivalangusha chichuku sitangalili kufuma kwa Tati. chichuku choti sivavagola yumwi mugumangi miganga?” ");
INSERT INTO ndj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Vayawudi vamuyangula, “Tukukuguma migonguveli kwanongwa ya chichuku chinofu ha, kwanongwa na ukumduka Chapanga! Ukuyigola kuva Chapanga na yuwi kwa mundu hela.” ");
INSERT INTO ndj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kavayangula, “Yiyandikiwa mumalawu venu, ‘Chapanga akudeta yumwi muva va Chapanga.’ ");
INSERT INTO ndj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chapanga kavakema vachapanga vala vagayiliwi chilongu chaki, yufwi tumanya kucha Mayandiku Vang'alili vakuwomba nakaka jola. ");
INSERT INTO ndj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mweni Tati yamgolili avi Mng'alili na kamulayisha mumlima, yumwi mukumuwombela, akumduka, nongwa adetili, Nenga ndi mwana wa Chapanga? ");
INSERT INTO ndj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mani ngugola fichuku fya Tati wangu ng'odu, topi mukotoo kujumila nenga. ");
INSERT INTO ndj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kumbi pandisigola, hata nenga pamujumila ng'odu, ngiba mufijumili fichuku fila figola nenga na kuwona kucha Tati kamugati ya nenga na nenga ndiva mugati ya mweni.” ");
INSERT INTO ndj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vakacheyi vamkamula lakini kasulubuka. ");
INSERT INTO ndj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu kayenda kandi kumwambu ya lweni Yoludani, pala Yohani mbatisha pabatisheyi mwanja mtasi, kayikala aku. ");
INSERT INTO ndj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Vandu vatangalili vamyendela vawomba, “Yohani mbatisha kagola mihilu yoyonda ha, kumbi fyosi fyadetili Yohani mbatisha filongu fyaki mundu ayu fyaveli nakaka.” ");
INSERT INTO ndj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Vatangalili vamjumilili Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mundu yumu yivamkema Lasalu, mweni kaya wa Betaniya, alwalili. Betaniya yaveli mlima wayikalagha Maliya pamu na Malita, vahaja mundu Lasalu ");
INSERT INTO ndj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ayu Maliya ndi mweni yamshaghili Bambu mafuta va kunungilila mumawulu na kuvapukuta na fwili shaki. Mhaja mundu Lasalu ndi yaveli akulwala. ");
INSERT INTO ndj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Topi vala vahaja mundu valayisha lulayilayi kwa Yesu, vadeta, “Bambu, yula ghanja waku yumtamili kalwala!” ");
INSERT INTO ndj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu papikanishili, kadeta, “Lasalu asovi kwa utami awu ha, lakini afi figoleka ili ukomi wa Chapanga wuwoneki kwa utami awu na mwana wa Chapanga na mweni ajumiwi.” ");
INSERT INTO ndj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu avatamili Malita na mhaja mundu na Lasalu. ");
INSERT INTO ndj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hata naha, papikanishili kucha Lasalu katakwa ayikalili majuva mavili kukula kula ngajila kuyenda kumlola. ");
INSERT INTO ndj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pambeli kavawombela vandundami vaki, “Tuyendi kandi Uyawudi!” ");
INSERT INTO ndj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Vala vandundami vamuwombela, “Muwula! Mwandi mwandi hela Vayawudi vakakusakeyi vakugumi na miganga kukula kula, yuwi ukudayila kuyenda kandi kuku?” ");
INSERT INTO ndj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kayangula, “Saa sha pamusi lilongu na mavili, duhu? Mundu payendayenda pamusi ayikwali ng'odu, nongwa akulola lwengi lwa mulima. ");
INSERT INTO ndj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mundu payendayenda pamihi dayikwali, nongwa kavahela lwengi.” ");
INSERT INTO ndj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu pamalilili kudeta naha, kavawombela, “Ghanja wetu, Lasalu kawonja, lakini nguyenda ngamyimushi.” ");
INSERT INTO ndj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Vanachuli vaki vamuwombela, “Bambu leki pawonja, akunana.” ");
INSERT INTO ndj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Veni vamanya kucha Yesu kawomba milandu ya kuwonja ng'onju, kumbi kawomba milandu ya njifwa ya Lasalu. ");
INSERT INTO ndj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu kavawombela ngatu hela, “Lasalu kasova, ");
INSERT INTO ndj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lakini nenga ngusekilela kwanongwa ya yumwi kucha ngaveli aku ha, ili muweshi kujumila. Ponopa tuyendi kwa Lasalu.” ");
INSERT INTO ndj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi yivamkema mambila kavawombela vandundami vamonga, “Tuyendi na yufwi tukasovi pamu na mweni!” ");
INSERT INTO ndj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu pafikili awonili Lasalu vamvikili kala musembi, majuva mchechi vapitili. ");
INSERT INTO ndj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Chijiji cha Betaniya chaveli pabehi na Yelusalemu, utali kucha kilomita ndatu. ");
INSERT INTO ndj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Vayawudi vatangalili vafikili kwa Malita na Maliya kuvakola mawoku kwa chivembu cha mhaja wawu. ");
INSERT INTO ndj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Malita papikanishili kucha Yesu akwisa, ayendili kumyanga, Maliya asighalili munyumba. ");
INSERT INTO ndj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malita kamuwombela Yesu, “Bambu, kucha ungaveli apa, mhaja wangu angasovili ha! ");
INSERT INTO ndj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lakini ponopa manya kucha fyofyosi fiwudayila kumluva Chapanga dakugayili.” ");
INSERT INTO ndj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu kamuwombela, “Mhaja waku dashukuki.” ");
INSERT INTO ndj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malita kamyangula, “Manya kucha dashukuki mulijuva lya kushukushiwa.” ");
INSERT INTO ndj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu kamuwombela, “Nenga ndi awu ushukushu na unofu. Yajumila nenga, hata pasova, dayikali kandi. ");
INSERT INTO ndj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na yula yayikala na pajumila nenga, dasovi ha jola, wuli! ukufijumila afi?” ");
INSERT INTO ndj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Malita kamuwombela, “Yina, Bambu! Nenga, ngujumila kucha yuwi ndi Kilistu, mwana wa Chapanga, yula dayisi mumlima.” ");
INSERT INTO ndj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Malita pamalilili kudeta fila, kayenda kumkema Maliya mkulu mundu, kamuwombela pambali, “muwula kava panji, akukukema.” ");
INSERT INTO ndj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mweni papikanishili, kalopu kamukovekela Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu aveli akali hela kuyingila muchijiji, aveli akali hela pahala pala pamuyangilili Malita. ");
INSERT INTO ndj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Vala Vayawudi yivaveli pamu na Maliya kayaki, vayisili pala pachivembu pavamuwonili akutandamuka kalopu na kufuma panji vamkovekelili. Vakacheyi akuyenda kusembi akalili. ");
INSERT INTO ndj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliya pafikili pala pavelili Yesu, pamuwonili kamuwila mumawulu, kamuwombela, “Bambu, kucha ungaveli baha mhaja wangu angafwili ha!” ");
INSERT INTO ndj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu pamuwonili Maliya akulila na vala Vayawudi vayilongushili pamu vakulila, limkola lihingili mundima. ");
INSERT INTO ndj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pambeli kavadasha, “Mumuvika koti?” Vamuyangula, “Bambu, wisi loli.” ");
INSERT INTO ndj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu kalila na misosi pwaa. ");
INSERT INTO ndj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ila Vayawudi vadeta, “Mloli ndambu yamtamili!” ");
INSERT INTO ndj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Vamu vawomba, “Nakaka! Ayu yamgolili yula ngalimesu aloli, aweshi ng'odu kumgola Lasalu akotoo kusova?” ");
INSERT INTO ndj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu yaveli na lusungu mundima yaki, kayenda kusembi. Sembi yeni yaveli mumbaku, yigubikiwa na ligonguveli. ");
INSERT INTO ndj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu kadeta, “Muliwushi ligonguveli ali!” Malita mhaja mundu na yula yasovili kamuwombela, “Bambu, ponopa akununga, kwanongwa kana majuva mchechi tangila asovi.” ");
INSERT INTO ndj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu kamuwombela, “Nenga ngakuwombilili du kucha pamuwujumila damuwuwoni ukomi wa Chapanga?” ");
INSERT INTO ndj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pambeli valiwusha lila ligonguveli. Yesu kalola kumbindi, kawomba, “Ngukuhongesha yuwi Tati nongwa ukumbikanisha. ");
INSERT INTO ndj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngumanya kucha ukumbikana myanja yosi, ng'omba naha kwanongwa ya vandu ava vaveli apa, vaweshi kujumila kucha yuwi ndi yiwunayishili.” ");
INSERT INTO ndj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pawombili naha, kakema kwa lishu likomi, “Lasalu! Fumi panji!” ");
INSERT INTO ndj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yula yaveli kasova kafuma panji, kunu aveli kana ligubiku mumawulu na mumawoku na kuwushu kawopiwa chitambala. Yesu kavawombela, “Mumuwopoli, mumleki ayiyendeli.” ");
INSERT INTO ndj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ponopa Vayawudi vatangalili vaveli pala pa Maliya pavalolili chindu chila chagolili Yesu, vamujumilili. ");
INSERT INTO ndj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Vamonga vayenda kwa Mafwalisayu vayegha milandu yila yagolili Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Vatambika vakomi na Mafwalisayu vayikalili pa chitemela vagola nongwa ngomi, pavawomba, “Tugoli liki? Mundu ayu akugola filangushilu fitangalili nendu! ");
INSERT INTO ndj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Patumleka hela vandu vosi davamjumili na veni Valoma davayisi kuyananga Nyumba Ngomi ya Chapanga wetu na mlima wetu!” ");
INSERT INTO ndj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pala mundu yumu yivamkemili Kayafa, aveli mkomi wa Vatambika mwaka wula, kavawombela, “Yumwi vapufi! ");
INSERT INTO ndj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yumwi mumanya ha ngiba mundu yumu asovi kwanongwa ya vandu, pitu vandu va Mlima wonda vasovi?” ");
INSERT INTO ndj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mweni adetili naha kwa kudayila mweni ha kwanongwa mweni aveli mtambika mkomi mwaka wula, topi atungili kucha Yesu dasovi kwanongwa ya vandu va mlima wa Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kwanongwa ya mweni weka hela ha, lakini avakungashili pamu vana va Chapanga yivayitapulili. ");
INSERT INTO ndj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kufuma lijuva lila vakomi va Vayawudi vagola milandu ya kumuwulagha Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kwanongwa vakacheyi vamkamuli Yesu, mweni katyanga kandi ha mumlima wa Vayawudi, kafuma pala, kayenda pabehi ya lunjenga, mumbwani ya Efelemu. Kayikala aku pamu na vandundami vaki. ");
INSERT INTO ndj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lihungu lya Vayawudi lya Pasaka lyaveli pabehi, vandu vatangalili vayenda Yelusalemu kwing'alisha kuliveta lihungu. ");
INSERT INTO ndj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Veni vavelili vakumsaka Yesu, pavayikungula munyumba ya Chapanga, vayidasha, “Kucha wuli? Yikuwoneka dayisi ng'odu mulihungu ali?” ");
INSERT INTO ndj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Vatambika vakomi pamu na Mafwalisayu valayishili kucha mundu yamanyili paveli Yesu avawombeli ili veni vakamukamuli. ");
INSERT INTO ndj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Majuva sita lihungu lya Pasaka likali, Yesu kayenda Betaniya kwayikaleyi Lasalu, mweni Yesu amshukushili kufuma munjifwa. ");
INSERT INTO ndj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kula vamgolela filivi fya lumihi, mweni Malita aveli akuvatandila. Lasalu aveli yumu wa vala vavelili pamu na Yesu pamesa vakulya. ");
INSERT INTO ndj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maliya atolili nusu lita ya mafuta va kunungilila va nadu vatawukili nendu, kamumwayila Yesu mumawulu, kampukuta na fwili shaki. Nyumba yosi yanungilili mafuta vala. ");
INSERT INTO ndj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yudasi Sikaliyoti yaveli yumu wa vandundami va Yesu, mweni damshengeti Yesu, kadeta, ");
INSERT INTO ndj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ngiba mafuta ava vangahemishili kwa migwala ijala ya myesi tisa na kuvapa migwala ayi vagaju?” ");
INSERT INTO ndj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Awombili nawula kwa kuvatama vagaju ha, kumbi aveli mwifi. Aveli mvika mbiya na fipindi fitangalili aveli akuhija mbiya mula mumuhaku. ");
INSERT INTO ndj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu kadeta, “Mkotoo kumfwasha mawu ayu! Mumuleki agoli kwa lijuva lyangu lya kusikiwa. ");
INSERT INTO ndj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vagaju damuvi pamu nawu jola, lakini damuvi na nenga jola ha.” ");
INSERT INTO ndj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Vayawudi vatangalili vapikanili kucha Yesu kava Betaniya. Vayendili kumlola Yesu hela ha wuwula wula vakamloli Lasalu yashukushiwili na Yesu kufuma munjifwa. ");
INSERT INTO ndj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Vatambika vakomi vagola njila ya kumuwulagha Lasalu wuwula. ");
INSERT INTO ndj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kwa nongwa ya Lasalu Vayawudi vatangalili vavalema vakomi vawu, vamjumila Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chilawu yaki, lipinga lya vandu lyayisili mulihungu lya Pasaka vapikanila Yesu kava munjila kwisa Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Vatola mitafya ya mikindu vayenda kumyanga, Pavalandusha kwa kuwomba, “Mumujumi Chapanga! Chapanga munemeli ayu yayisa kwa litawa lya Bambu. Chapanga munemeli mutwa wa Vayisilaeli.” ");
INSERT INTO ndj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu pambeli kayipaka ngwada wa chihongu kumuwongu, kucha wuvawombili Mayandiku vang'alili. ");
INSERT INTO ndj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ukotoo kutila mbwani ya Sayuni! Loli mutwa waku akwisa, Kayipaka ngwada wa chihongu!” ");
INSERT INTO ndj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Chipindi chila vandundami vaki vamanyili ha chilongu chila, lakini Yesu pajumiwili kala, vakumbukili chila chiyandikilwi kwa mweni na vandu vamgolela wuwula. ");
INSERT INTO ndj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lipinga lya vandu lyaveli pamu na Yesu pala pamkemeyi Lasalu kufuma musembi na kamshukusha kufuma munjifwa, vawombili milandu ya Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lipinga lila lya vandu lyayisili, nongwa vosi vapikanishili kucha Yesu agolili chilangushilu chila. ");
INSERT INTO ndj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafwalisayu vayiwombela, “Mkulola! Datuweshi kugola chindu ha! Mloli mlima wosi ukumkovekela.” ");
INSERT INTO ndj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kwaveli Vagiliki vamu wa vala vafikili Yelusalemu kumluva Chapanga mulijuva lila. ");
INSERT INTO ndj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Vala vamyendela Filipu, mwenikaya wa Betisayida kula Galilaya, vawomba, “Bambu, tukudayila kumlola Yesu.” ");
INSERT INTO ndj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipu kayenda, kamuwombela Andeleya, pambeli vosi vavili vayenda kumuwombela Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu kavawombela, “Saa ya kujumiwa Mwana wa Mundu yifika kala! ");
INSERT INTO ndj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nakaka nguvawombela, ngokwa ya mupunga yikusighala ngokwa hela hata payiponeka pasi pauganga pambeli yikusova. Mani payisova, yikulela fivelekwa fitangalili. ");
INSERT INTO ndj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Vala yivautama unofu wawu davawuyaghamishi na vala yivatila ngalilu yau mumlima awu davayangi unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yadayila kungimbanikila, angovekeli ili pala pandiva nenga na vandumindumi vangu vavi. Tati wangu damtundamili mundu ayu.” ");
INSERT INTO ndj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ndima yangu yikalala ponopa ng'ombi liki? Wuli ng'ombi, ‘Tati ukotoo kujumisha chipindi achi mikiwa nenga’? Lakini ayi ndi nongwa yinyisilili ili mbiti muchipindi achi kuteshiwa. ");
INSERT INTO ndj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tati, lijumi litawa lyaku.” Topi, lishu kufuma kumbindi kwa Chapanga lideta, “Nilijuma kala na danilijumi kandi.” ");
INSERT INTO ndj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lipinga lya vandu liwolukili pala lipikanila lishu lila, vamu vawomba, “Kudilima.” Vamu vawomba, “Makungu kaywanga na mweni!” ");
INSERT INTO ndj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lakini Yesu kavawombela, “Lishu ali lipikanika kwanongwa ya nenga ha, lishu ali lipikana kwanongwa ya yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hinapawu chipindi cha mlima awu kuhighiwa, mnakulongosha mlima awu dawushiwi. ");
INSERT INTO ndj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na nenga pabikuliwa kumbindi kwa Chapanga mumlima, dandivakweyi vandu vosi kwa nenga.” ");
INSERT INTO ndj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Adetili nawula kulangusha kucha dasovi kwa njifwa liki. ");
INSERT INTO ndj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Topi, lipinga lila limuyangula, “Yufwi tupikanila kufuma mumalawu vetu kucha Kilistu dayikali jola. Dauweshi wuli kuwomba nakaka Mwana wa mundu akudayila kunyasuliwa? Na mwana wa mundoyu ghani?” ");
INSERT INTO ndj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu kavawombela, “Lwengi luva pamu na yumwi kwa chipindi chitali ha. Muyendi yendi kukali na ngesha, ili lwisa lukotoo kuvagubika, kwanongwa yayendayenda mulwisa kamanya ng'odu kwayenda. ");
INSERT INTO ndj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pamuveyi na ngesha mujumili ili muva kala vana va lwengi.” Pamalilili kudeta filongu fila, Yesu kawuka kayifisa kutali na lipinga lila. ");
INSERT INTO ndj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu agolili mihilu yosi pavalola, lakini veni vamjumilili ha, ");
INSERT INTO ndj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ili filongu fya detili mbuyi wa Chapanga Isaya ndafiwoneka, “Bambu, ghani yajumilili chilongu chetu? Uwesu wa Bambu uwoneka kwa ghani?” ");
INSERT INTO ndj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Vawesha ha kujumila, kwanongwa Isaya kawomba kandi, ");
INSERT INTO ndj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Chapanga kawomba, dandivapofoli mesu vawu, kavapugha luhala lwawu vakotoo kulola kwa mesu vawu, na mahala vawu vakotoo kumanya vakotoo kung'alambukila nenga, kawomba Bambu, ng'weshi kuvagola vanani.” ");
INSERT INTO ndj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya ndakawomba filongu afi nongwa kaulola ukomi wa Yesu, kawomba milandu yaki. ");
INSERT INTO ndj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hata naha, vakomi va Vayawudi vatangalili ndavamjumila Yesu, lakini kwanongwa ya Mafwalisayu, vamuyitikila ng'odu pawelu pavatila davalekani na nyumba ya kudadavila ya Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vadayila ukomi wa vandu pitu kujumiwa na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pambeli Yesu kawomba kwa lishu likomi, “Mundu yajumila nenga, akujumila nenga hela ha, akumjumila na yula yanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yanola nenga akumlola yula yanayishili wuwula. ");
INSERT INTO ndj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nenga nyisa pamlima kucha lwengi, ili yoyosi yajumili nenga akotoo kuyikala mulwisa. ");
INSERT INTO ndj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yangajila kupikana filongu fya nenga, nenga ngumuhigha ha, nongwa nyisa pamlima kuhigha ha, nyisa kuulowola. ");
INSERT INTO ndj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yivanema nenga na kukamula ng'odu filongu fyangu vana yumu wakuvahigha. Filongu fila fyang'ombilili dafivi muhigha lijuva lya mwishu. ");
INSERT INTO ndj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ayi nakaka, kwanongwa nenga ng'omba kwa uwesu wa nimweni baha ng'odu, Tati yanayishili ndi mweni yanayishili ng'ombi liki na nywangi liki. ");
INSERT INTO ndj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nenga manya kucha lilawu lyaki likuyegha unofu wa jola. Nenga nguwomba fila Tati fyanayishili ng'ombi.” ");
INSERT INTO ndj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yaveli lijuva limu lya Lihungu likali hela kufika. Yesu kamanya kucha saa yaki ya kuwuka pamlima kuyenda kwa Tati yafikili. Avatamili vandu yivaveli vaki va pamlima majuva vosi, avatamili munu! ");
INSERT INTO ndj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu pamu na vandundami vaki vayikalili pamu vakulya filivi fya pamihi. Lijangavandu avikili kala mundima ya Yudasi mwana wa Simoni Sikaliyoti, hoshu ya kumushengeta Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu amanyili kucha Tati kamgayila findu fyosi mumawoku vaki na mweni kafuma kwa Chapanga na akuwuya kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesu kayisegha pafilivi, kakusa yingwa yaki, kayiwopa lukwindu muchiwunu. ");
INSERT INTO ndj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pambeli kataya machi mungwangu, kakanda kuvawofuva mawulu vandundami vaki kunu pavapukuta na yingwa yafwalili muchiwunu. ");
INSERT INTO ndj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kayenda paveli Simoni Petili, mweni kawomba, “Bambu yuwi ukung'ofua nenga mawulu?” ");
INSERT INTO ndj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kayangula, “Chila chigola ponopa kuchimanya ha, lakini daumanyi pambeli” ");
INSERT INTO ndj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petili kamuwombela, “Dauweshi kung'ofuwa nenga mawulu vangu hata kamu!” Yesu kamyangula, “Panguwofuva ng'odu dauvi Lighanja na nenga ha.” ");
INSERT INTO ndj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petili kamyangula Bambu, “Ng'ofuwi, mawulu hela ha pamu na mawoku vangu na mutwi.” ");
INSERT INTO ndj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu kamuwombela, “Yayovili, kang'ala kala, akudayila kuyova kandi ha ila kunava mawulu hela. Yumwi mung'ala kala ila yumu hela.” ");
INSERT INTO ndj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu amumanyili kala yula daamushengeti, ndi nongwa awombili naha, “Mwavosi yumwi mung'ala kala, ila yumu hela.” ");
INSERT INTO ndj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pavawofuwili kala mawulu, kakusumbula yingwa yaki, kayikala pamesa, kavawombela, “Mufimanya fyendivagolili? ");
INSERT INTO ndj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yumwi mukungema nenga Muwula na Bambu, yumwi mukuwomba nyanyi nongwa nenga mweni. ");
INSERT INTO ndj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nenga muwula na Bambu wenu ndivawofua yumwi mawulu na yumwi mukudayila muyiwofuvi mwaveni mawulu. ");
INSERT INTO ndj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ndiva gayila chilangushilu, yumwi mugoli kucha wugolili nenga. ");
INSERT INTO ndj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nakaka nguvawombela, vavanda vavi vakomi ha kwa vabambu vawu na vanjagila vavi vakomi ha kwa yula yavalayishili. ");
INSERT INTO ndj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mani muvamanya ava damuvi na ngiba pamugola. ");
INSERT INTO ndj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Afi fing'omba fya mwavosi yumwi ha, nenga ndiva manya vala ndivashawulili. Lakini Mayandiku yivayandikiwili yivawomba, ‘Yula yalili filivi pamu na nenga danshengeti.’ ");
INSERT INTO ndj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nenga ndivawombela filongu afi, fikali kufumbuka ponopa, fifumbuka muweshi kujumila kucha nenga ndi mweni. ");
INSERT INTO ndj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nakaka nguvawombela, yamupokela yula yindimulayishili akumbokela nenga na yula yambokela nenga akumpokela yula yanayishili.” ");
INSERT INTO ndj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu pawombili filongu fila, ndima yimutama nendu kadeta, “Nakaka nguvawombela muyenu yumu dashengeti!” ");
INSERT INTO ndj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Vandundami vayilola veni kwa veni, vamanya ha akumuwomba ghani. ");
INSERT INTO ndj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Paveli na ndundami yumu Yesu yamtamili aveli kayikala pambali yaki. ");
INSERT INTO ndj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petili akamukupisheyi kwa mawoku pawomba, “Mudashi akumudeta ghani?” ");
INSERT INTO ndj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ndundami yula kaselela pabehi na Yesu kamudasha, “Bambu ghani ayu?” ");
INSERT INTO ndj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu kayangula, “Yula yindimupa chipandi cha libumunda chinikishilili ndi mweni. Pambeli katola chipandi cha libumunda kalikishila, kamupa Yudasi mwana wa Simoni Sikaliyoti.” ");
INSERT INTO ndj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda patolili libumunda lila, tepu, Lijangavandu limwingila. Yesu kamuwombela, “Chiwudayila kugola goli kalopu.” ");
INSERT INTO ndj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kwa hela mundu yayikalili pamesa yamanyili kucha wuli kamuwombela wula. ");
INSERT INTO ndj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudasi aveli mkola mbiya, vamu vamanyili kucha Yesu akumuwombela mweni akahemeli findu fya lihungu awu kuvagayila vagaju findu. ");
INSERT INTO ndj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tepu hela Yuda payangili hela libumunda lila, kafuma panji. Ndayiva pamihi. ");
INSERT INTO ndj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda pawukili kala, Yesu kawomba, “Topi ukomi wa Mwana wa Mundu wukuwoneka, ponopa ukomi wa Chapanga akuwoneka kupitila mweni. ");
INSERT INTO ndj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kucha ukomi wa Chapanga ukuwoneka kupitila mweni, topi mweni Chapanga dagoli ukomi wa Mwana wa Mundu wuwoneki, tepu dagoli afi. ");
INSERT INTO ndj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Vana vangu dandivi na yumwi padokwa, damunzaki, kucha ndivawombilili Vayawudi, nguvawombela ponopa, ‘Kunyenda, damufiki ha.’ ");
INSERT INTO ndj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lilawu lya shonu nguvagayila, muyitami yumwi kwa yumwi, kucha ndivadayilili nenga, ponopa muyitami yumwi kwa yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Naha vandu vosi davamanyi kucha yumwi muva vandundami va nenga, mani mkuyitama yumwi kwa yumwi.” ");
INSERT INTO ndj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petili kamudasha, “Bambu, ukuyenda koti?” Yesu kamuyangula, “Kunyenda nenga dauweshi kungovekela ha. Dawungovikeli pambeli.” ");
INSERT INTO ndj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petili kadasha, “Bambu, wuli nenga dangweshi ng'odu kukukovikela ponopa? Nenga danyasi unofu wangu kwanongwa ya yuwi.” ");
INSERT INTO ndj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Pambeli Yesu kamyangula, “Nakaka yuwi daumalili unofu waku kwanongwa ya nenga? Nakaka nguvawombela kandi njowolu akali kuvika yuwi daunemi nenga myanja mitatu!” ");
INSERT INTO ndj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Mkotoo kuyipwelesha kunda yenu, leki mukumjumila Chapanga, mujumili na nenga. ");
INSERT INTO ndj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Munyumba ya Tati wangu muna fyumbagati fitangalili, kungaveli hela fwasi ya kuyikala ningavawombilili ha, nguyenda ngavatandili pa kuyikala. ");
INSERT INTO ndj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Topi pandivatandila kala pakwikala, danyisi kandi kuvatola ili pandiva nenga na yumwi muvi baha. ");
INSERT INTO ndj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yumwi mwiyimanya deha yinyendela aku kunyenda.” ");
INSERT INTO ndj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi kamudasha, “Bambu, yufwi tumanya ha kuwuyenda, ponopa datwimanyi wuli wuli deha?” ");
INSERT INTO ndj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu kayangula, “Nenga ndi nakaka na deha na unofu, kwa hela mundu yayenda kwa Tati ngajila kupitila kwa nenga. ");
INSERT INTO ndj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nongwa mungamanyili nenga, mungamumanyili na Tati wangu. Kukandila ponopa mumumanya na mumuwona kala.” ");
INSERT INTO ndj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu kamuwombela, “Bambu, yufwi tukudayila utulangushi Tati hela.” ");
INSERT INTO ndj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu kamuyangula, “Filipu, mumanya ng'odu nenga? Ndiyikala na yumwi majuva vatangalili. Yang'onili nenga kamuwona na Tati. Topi, nongwa liki mukudeta, ‘ndivalangushi Tati?’ ");
INSERT INTO ndj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yuwi ukujumila ng'odu kucha nenga ndiva mugati ya Tati na Tati kava mugati ya nenga?” Yesu kavawombela, ngudeta kwa liwovi lyangu ha, ila Tati yayikala mugati ya nenga ndi ya gola chichuku chaki. ");
INSERT INTO ndj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mujumili nenga padeta kucha ndiva mugati ya Tati na Tati kava mugati ya nenga. Leki mukujumila ng'odu nenga, mujumili kwanongwa ya fila figola. ");
INSERT INTO ndj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nakaka nguvawombela, yula ya jumila nenga, dagoli fichuku fila figola, dagoli findu fikomi kupita afi, kwanongwa nenga nguwuka nguyenda kwa Tati. ");
INSERT INTO ndj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nenga dagoli chochosi chimudayila kuluva kwa litawa lyangu, ili Tati ajumiwi kwa njila ya mwana. ");
INSERT INTO ndj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Leki pamuluva chindu chochosi kwa kutambula litawa lyangu, nenga dagoli. ");
INSERT INTO ndj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Leki mundama nenga, damukamuli Malawu vangu. ");
INSERT INTO ndj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na nenga dandimuluvi Tati, mweni avapi Mtangi wingi ayikali na yumwi jola. ");
INSERT INTO ndj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mweni ndi Mfuki wulangusha unakaka wa Chapanga, vandu va mlima awu davaweshi ha kumujumila kwanongwa vamuwona ha na vamumanya ha. Lakini yumwi mumumanya, kwanongwa kava na yumwi na akwikala mugati ya yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Danivaleki ng'odu kucha Valekwa, dandivawuyili kandi. ");
INSERT INTO ndj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Chisighala chipindi chidokwa vandu va mlima awu davang'oni kandi ha. Lakini yumwi damung'oni, kwanongwa nenga munofu na yumwi damuvi vanofu wuwula wula. ");
INSERT INTO ndj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lijuva palifika damumanyi kucha nenga ndiva mugati ya Tati wangu na yumwi muva mugati ya nenga na nenga ndiva mugati ya yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Vandu vakamula Malawu va nenga na kuvajumila, ava vakundama. Na Tati wangu davatami vala yivandama nenga na nenga dandivatami wuwula wula na nenga dandiyilangushi kwa veni.” ");
INSERT INTO ndj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda wingi Sikaliyoti ha, kamudasha, “Bambu, wuli wuli dawiyilangusha umweni kwa yufwi, ngajila kuyilangusha kwa vandu va mlima awu?” ");
INSERT INTO ndj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kamuyangula, “Yandama nenga dakamuli mawuli vangu. Tati wangu damutami, Tati pamu na nenga datuyingili mugati yaki na kuyikala. ");
INSERT INTO ndj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yandama ng'odu, akukamula ha filongu fyangu na filongu fimupikana padeta fikufuma kwa nenga ha, filongu fya Tati wangu yanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Afi ndi finivawombeleyi pandiyikaleyi na yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lakini Mtangi, ndi Mfuki Mng'alili, Tati damulayishi kwa litawa lyangu, davawuli findu fyosi, kuvakumbushila fyosi findivawombilili. ");
INSERT INTO ndj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nguvalekela kusika, nguvapa kusika kwa nenga. Kusika kundivavapa nenga kuva ng'odu kucha ngimu mlima wuvavapa yumwi. Mkotoo kuyipwelesha wala mukotoo kutila. ");
INSERT INTO ndj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mumbikanisha pandivawombilili kucha, ‘Nguyenda pambeli nguwuya kandi.’ Leki mungandamili mungasekilili kucha nguyenda kwa Tati, nongwa Tati mkomi pitu nenga. ");
INSERT INTO ndj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ndivawombela filongu afi ngengi, ili pafibwituka mujumili. ");
INSERT INTO ndj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Danywangi na yumwi filongu fitangalili ha, kwanongwa mtavala wa mlima awu akwisa, mweni kwa nenga kana liwovi ha, ");
INSERT INTO ndj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lakini ili mlima umanyi kucha ngumutama Tati na ngugola findu fyosi kucha mweni wanayishili. “Muwoloki, tuwuki apa. ");
INSERT INTO ndj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nenga ndi msabibu nakaka, Tati wangu mulimi. ");
INSERT INTO ndj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mweni akudumula litafi lingajila kulela fivelekwa na kuliyasa na akulihengelela lila litafi lilela ili lileli fivelekwa fitangalili. ");
INSERT INTO ndj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yumwi muva nyanyi kala kwanongwa mukamula chilongu chila chindivawombilili. ");
INSERT INTO ndj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Muyikali mugati ya nenga na nenga dandiyikali mugati ya yumwi. Litafi weka hela lileli ha fivelekwa mbaka livi mulibiki lyaki lya musabibu. Wuwula wula yumwi muleli ha fivelekwa ila pamuva mugati ya nenga. ");
INSERT INTO ndj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nenga ndiva lihadiki lya lisabibu na yumwi muva mitafyi, yiyikala mugati ya nenga na nenga nguyikala mugati yaki na akulela fivelekwa fitangalili, kwanongwa pangajila nenga mukuwesha ha kugola chindu. ");
INSERT INTO ndj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mumuleki mundu yayikala ng'odu mugati ya nenga, ayu akuva kucha litafi liyasiwili na kuyuma, mitafi yiyumili yikungiwa na kuyasiwa mumotu, dayilunguli nigu! ");
INSERT INTO ndj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Leki mkuyikala mugati ya nenga na filongu fyangu dafiyikali mugati ya yumwi, damuluvi chochosi chimudayila damugayiliwi. ");
INSERT INTO ndj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Leki pamulela fivelekwa fitangalili, Tati wangu dajumiwi nakaka damuvi vandundami vangu. ");
INSERT INTO ndj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kucha wula Tati pandamili nenga, wuwula wula nenga ndivatama yumwi, muyikali muwutami wa nenga. ");
INSERT INTO ndj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pamuvakamula Malawu vangu, yumwi damuyikali muwutami wangu, kucha nenga wundivakamulili Malawu va Tati wangu na nguyikala muwutami waki. ");
INSERT INTO ndj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ndavawombilili naha ili sekelelu yangu yivi mugati yenu na sekuseku yenu yimemi. ");
INSERT INTO ndj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lilawu lyangu ndi ali: muyitami yumwi kwa yumwi kucha nenga wundivatama yumwi ");
INSERT INTO ndj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kwahela mundu yaveli na utami kucha awu, wa kuuleka unofu waki kwanongwa ya vaghanja vaki. ");
INSERT INTO ndj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yumwi muva vaghanja vangu mani mkugola fila fyindivalayishili. ");
INSERT INTO ndj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dandivakemi ng'odu vandumindumi kandi, kwanongwa vandumindumi vamanya ng'odu fyagola bambu wawu. Lakini yumwi ndivakema vaghanja, kwanongwa fyosi findifipikanilili kwa Tati ndivawombela. ");
INSERT INTO ndj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yumwi munshawula nenga ng'odu, nenga ndivashawula yumwi na ndivalayisha yumwi, muyendi mukaleli nendu fivelekwa fya kuyikala. Na Tati davavapi chindu chochosi chimumuluva mulitawa lyangu. ");
INSERT INTO ndj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nguvawombela naha yumwi, muyitami yumwi kwa yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Leki vandu va mlima pavavakalalila yumwi, muyiholi kucha vangalalili nenga tanila. ");
INSERT INTO ndj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Leki mungaveli vandu va mlima awu, vangavatamili yumwi kucha veni. Lakini yumwi wa mlima awu ng'odu, nongwa nenga ndivashawula kufuma mumlima awu, kwanongwa ayi vandu va mlima awu vakuvakalalila yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muyiholi wundivawombilili kucha kwahela vavanda yivaveli vakomi kwa Bambu wawu. Leki vandeshili nenga, davavateshi na yumwi wuwula wula. Leki vavakamulili mawuli va nenga, davakamuli na va yumwi wuwula wula. ");
INSERT INTO ndj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lakini davavagoleli fyosi kwanongwa yumwi muva va nenga, veni vamanya ng'odu mweni yanyeghili. ");
INSERT INTO ndj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Leki ngayisili na kuwomba na veni ng'odu, vangaveli na sambi ng'odu, ponopa vavahela cha kuyitasha sambi shawu. ");
INSERT INTO ndj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yula yangalalila nenga akumkalalila Tati wangu wuwula wula. ");
INSERT INTO ndj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mani ngagolili ng'odu fichuku fila kwahela mundu angagolili na vangaveli na sambi ha. Ponopa vayiwona mihilu yigolili, lakini vangalalila nenga na Tati wangu. ");
INSERT INTO ndj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lakini fyosi afi fidayiliwa kugoleka ili Malawu vavi nakaka, ‘Vangalalila nenga ngajila nongwa.’ ");
INSERT INTO ndj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Leki payisa ayu Mtangi, yindivayeghela kufuma kwa Tati, ayu Yang'alili nakaka kufuma kwa Tati, mweni dandovileli nenga. ");
INSERT INTO ndj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na yumwi wuwula wula damundovileli nenga, kwanongwa tuva pamu kufumila pakwandi.” ");
INSERT INTO ndj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ndivawombela naha ili mukotoki kuleka ujumilu wenu. ");
INSERT INTO ndj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Davavavingi munyumba shawu sha Chapanga, chipindi chikwisa chila kila mundu yavawulaya daamanyi akumuwushila Chapanga litambiku. ");
INSERT INTO ndj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Vandu davagoli naha nongwa vamumanya ng'odu Tati na nenga. ");
INSERT INTO ndj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ndivawombela filongu afi, ili chipindi pachifika muvi na ngumbungumbu kucha ndivawombilili kala. ");
INSERT INTO ndj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ponopa nguyenda kwa mweni yanayishili, lakini kwahela mundu yadasha nguyenda koti. ");
INSERT INTO ndj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ndivawombela naha, mundima shenu mumema ligafugafu. ");
INSERT INTO ndj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lakini ndivawombela nakaka, finofu kwa yumwi nenga kuwuka, kwanongwa nenga pang'uka ng'odu, dayisi ha Mtangi, ila pang'uka, dandimulayishi kwa yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mweni payisa, davamanyishi vandu va pamlima milandu kucha vatoshangila milandu ya sambi na ugoleki na fiyilatili highilu ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Vatoshangila milandu ya sambi, kwanongwa vajumila ng'odu nenga, ");
INSERT INTO ndj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kwilata ugoleki kwanongwa nenga nguyenda kwa Tati, damung'oni kandi ha, ");
INSERT INTO ndj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","vatoshangila mumilandu ya kuhigha, nongwa Lijangavandu mkomi wa mlima awu kahighiwa kala. ");
INSERT INTO ndj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ngali na filongu fitangalili fya kuvawombela, lakini dafivi vitangalili munu kwa yumwi kufikamula fyosi. ");
INSERT INTO ndj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Topi payisa Mfuki mweni, ayu ndi yalangusha unakaka wa Chapanga, davalongoshi muunakaka wosi, mweni davawombeli kwa uwesu waki mweni lakini davawombeli fyapikanila na fila dafiyisi kuwulongolu. ");
INSERT INTO ndj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mweni dajumi nenga, nongwa datoli fyang'ombilili avawombeli yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fyosi fya Tati wangu fya nenga, ndi nongwa ndawombili Mfuki Mng'alili datoli fila fyindimugayilili avawombeli yumwi. ");
INSERT INTO ndj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Yikali chipindi chidokwa hela damung'oni ha, pambeli padokwa damung'oni.” ");
INSERT INTO ndj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Vandundami vaki vamu vayikanganikili, “Afi fya detili fina mana liki? Kutuwombela chisighala chipindi chidokwa datumuwoni ha na kudeta, ‘Samba kawuka, samba kawuya na akuyenda kwa Tati.’ ");
INSERT INTO ndj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Vasiyala vakwidasha, ‘Chilongu liki achi chawomba?’ Tumanya ha chawomba.” ");
INSERT INTO ndj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kamanya kucha vadayila kumdasha, topi kavawombela, “Chimwidasha liki kucha ng'omba, samba ndivaleka damung'oni ha pambeli samba mung'ona. ");
INSERT INTO ndj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nakaka nguvawombela, yumwi damulili kunu pamu yidedeka, topi, mlima dausekeleli, yumwi damukalali, kukalala kwa yumwi dakughalambuki cheleli buja. ");
INSERT INTO ndj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mdala palela, kana lihingili nongwa saa yaki yifika ya kulela, leki palela mwana, akwivasuwa lila lihingili lya kulela kwanongwa ya cheleli. ");
INSERT INTO ndj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na yumwi wuwula, muna lung'ong'u, lakini nenga dandang'aniki na yumwi kandi, yumwi damumemi cheleli buja mumunda shyenu, kwahela yawesha kuvawushila seku shyenu. ");
INSERT INTO ndj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mulijuva lila damungonyi chindu ng'odu. Nakaka nguvawombela, Tati wa nenga davagayili chila chimumluva kwa litawa lyangu. ");
INSERT INTO ndj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mbaka ponopa munuva ng'odu chindu chochosi mulitawa lyangu. Muluvi, damupati, kusekelela kwa yumwi kuvi jola. ");
INSERT INTO ndj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ng'omba kwa ng'ombelu ya kuyifwana na yumwi, kuvawombela milandu ayi. Saa yikwisa nenga danywangi kwa kuyifwana ha, dang'ombi lipala hela milandu ya Tati. ");
INSERT INTO ndj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mulijuva lila damuluvi kwa kupitila litawa lyangu, ngudeta ha kucha nenga dandivaluvili kwa Tati, ");
INSERT INTO ndj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tati mweni kavatama yumwi. Kavatama yumwi kwanongwa mundama nenga na mujumila kucha nenga fuma kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Fuma kwa Tati, nyisa mumlima, ponopa nguwuleka mlima nguwuya kwa Tati wangu.” ");
INSERT INTO ndj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pambeli vandundami vaki vamuwombela, “Ponopa ukuwomba lipala, ukudeta lipala ngajila chifisu mung'ombelu. ");
INSERT INTO ndj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tumanya kucha yuwi kumanya milandu yosi kwahela mundu wa kukudasha naha tujumila kucha yuwi kufuma kwa chapanga.” ");
INSERT INTO ndj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kavayangula, “Ponopa mukujumila? ");
INSERT INTO ndj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Dachisi chipindi na chiva kala, mwavosi damulekanili kila mundu na kaya yaki, damuneki weka, lakini nguva weka ha kwanongwa Tati wangu kava na nenga. ");
INSERT INTO ndj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ndivawombela naha ili yumwi muvi na kusika pamuva pamu na nenga. Vandu vamlima davavagoboli lakini mudindali! Mlima ndiwuwesha kala.” ");
INSERT INTO ndj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu pamalilili kuwomba naha, kalola kumbindi kunu pawomba, “Tati chipindi chiyisa. Uvagoli vandu vamujumi mwana waku, ili mwana waku akujumi. ");
INSERT INTO ndj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wamugayilili uwesu kupita vandu vosi, ili avagayili unofu wa jola vosi vala wamugayilili. ");
INSERT INTO ndj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Unofu wa jola ndi awu, kukumanya yuwi weka Chapanga wa nakaka na kumumanya Yesu Kilistu, yula yumulayishili. ");
INSERT INTO ndj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nenga ndiwulangusha ukomi waku apa pamlima, malila fichuku fiwunyimbili ndifigoli. ");
INSERT INTO ndj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tati! Unyimbi ukomi pawulongolu paku ponopa, ukomi wuwula wula ndaveli nawu pamu na yuwi chipindi mlima waveli wakali hela kuva. ");
INSERT INTO ndj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ndikugola umanyiki kwa vandu vala vawunyimbili mumlima. Vaveli vandu vaku na yuwi wanyimbili nenga. Vachikamula chilongu chaku, ");
INSERT INTO ndj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ponopa vamanya kucha fyosi fiwungayilili fifuma kwa yuwi. ");
INSERT INTO ndj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Topi filongu fiwungayilili ndivagayila veni na veni vafipokela. Nakaka vamanya kucha fuma kwa yuwi. Vajumila kucha yuwi kunayisha. ");
INSERT INTO ndj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nenga nguvadadavila vala, nguvadadavila ha vandu vosi va pamlima, nguvadadavila hela vala vawunyimbili, nongwa veni vandu va yuwi. ");
INSERT INTO ndj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Fyosi fimeli nafyu fya yuwi na fyosi fiwuveli nafyu fya nenga. Ukomi kupitila ava. ");
INSERT INTO ndj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nenga ndiva kandi mumlima ha, veni vakali mumlima. Na nenga ngwisa kwa yuwi. Tati Mng'alili, uvadimi vandu kwa liwovi lya litawa lyaku liwugayilili, ili vosi vavi yumu kucha yufwi wutuveli yumu. ");
INSERT INTO ndj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Pandiveyi na veni, ndivadima na kuvavika panofu kwa liwovi lya litawa lyaku, litawa liwunyimbili. Kwa hela hata yumu yayaghamilili ila yumu hela yula yalatiwili kuyaghamila ili Mayandiku vavi. ");
INSERT INTO ndj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ponopa ngwisa kwa yuwi, filongu afi nda detili chipindi ndaveli ngali ndiva pamlima, ili veni vavi na sekuseku lumemili mundima shawu. ");
INSERT INTO ndj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ndivagayila chilongu chaku na vandu va mlima awu vavakalalila nongwa veni va mlima awu ha, kucha nenga wa mlima awu ha. ");
INSERT INTO ndj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nenga ngudadava ha kucha uvawushi mumlima awu, lakini nguluva uvadimi na yula Mwafu. ");
INSERT INTO ndj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nenga wamlima awu ng'odu na veni wuwula wula wa mlima awu ha. ");
INSERT INTO ndj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uvagoli vavi vaku kwa nakaka yaku, chilongu chaku ndi nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kucha yuwi wuunayishili nenga mumlima, wuwula wula na nenga nguvalayisha veni mumlima. ");
INSERT INTO ndj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kwa nongwa ya veni, ndiyitawula nimweni kwa yuwi ili na veni wuvagoli kuva vaku nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nguvadadavila veni weka ha. Nguvadadavila na vala yivajumila nenga kwanongwa ya chilongu chawu. ");
INSERT INTO ndj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tati, ngudadava vosi vavi yumu, kucha yuwi wuveli mugati ya nenga na nenga mugati ya yuwi. Na veni vavi mugati ya yufwi, ili mlima ujumili kucha yuwi ndi wanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ndivagayila ukomi wula wuunyimbili nenga, ili vavi yumu kucha wula yufwi wutuveli yumu. ");
INSERT INTO ndj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nenga mugati ya veni na yuwi mugati ya nenga, vavi yumu nakaka, ili mlima umanyi kucha wanayishili na ukuvatama veni kucha wula wundamili nenga. ");
INSERT INTO ndj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tati, vala vaungayilili ngudayila vavi pamu na nenga kosi pandiva, vaweshi kuulola ukomi wa nenga, ukomi wuunyimbili kwanongwa wandamili chipindi mlima ukali hela kugoleka. ");
INSERT INTO ndj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tati goleki, Mlima wukumanya ng'odu, lakini nenga ngumanya na veni vamanya kucha yuwi wanayishili. ");
INSERT INTO ndj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ngukugola umanyiki kwa veni na danyendileli kugola nahawu, ili utami wuveli nawu kwa nenga wuvi na kwa veni, ili ndivi mugati yawu.” ");
INSERT INTO ndj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu pamalili kudadava, kawuka pamu na vandundami vaki vayenda kumwambu ya lweni Keduloni. Paveli na chiwunga cha mibiki kayingila mweni pamu na vandundami vaki. ");
INSERT INTO ndj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mweni Yudasi, yadayileyi kumushengeta Yesu, kapamanya pala, kula Yesu kwayendili na vandundami vaki. ");
INSERT INTO ndj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudasi kayenda kuchiwunga cha mibiki, aveli pamu na chipinga cha machonda, pamu na vandumindumi kufuma kwa vakomi va vatambika na Mafwalisayu, vayenda na lung'ali na niku pamu na fidumu. ");
INSERT INTO ndj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu kamanya kala fyosi dafimfumbukili, kawoloka paulongolu kavadasha, “Mkumsaka ghani?” ");
INSERT INTO ndj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Veni vayangula, “Yesu Mnasaleti” Yesu kavayangula, “Nenga ndi mweni.” Yudasi yamshengetili kawoloka pamu na vala. ");
INSERT INTO ndj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu pavawombilili, “Nenga ndi mweni” Vatatalikili kumbeli, vawa pasi. ");
INSERT INTO ndj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kavadasha kandi, “Mkumsaka ghani?” Vamyangula, “Yesu Mnasaleti.” ");
INSERT INTO ndj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu kavayangula kandi, “Ndiva wombela kala nenga ndi mweni. Leki mukunsaka nenga, muvaleki ava vayendi.” ");
INSERT INTO ndj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Awombili naha ili fyadetili fivi nakaka. “Tati vala vawungayilili ndimuyamishi hata yumu ha.” ");
INSERT INTO ndj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petili aveli na lipanga, kalifyangula, kamtova ndumindumi wa Mtambika mkomi, kamdumula lijeji lya kumlilu. Yula ndumindumi litawa lyaki Malikusi. ");
INSERT INTO ndj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pambeli Yesu kamuwombela Petili, “Wuyishi lipanga lyaku muhala! Ukudayila lwindi lwa kuteshiwa lwanyimbili Tati wangu ndilulandili ng'odu?” ");
INSERT INTO ndj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pambeli vala machonda na mkomi wau na vala vandumindumi va Vayawudi vamkamula Yesu, vamuwopa. ");
INSERT INTO ndj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Vamtola mbaka kwa Anasi. Anasi kava mkohanu mundu na Kayafa, yula yaveli mtambika mkomi mwaka wula. ");
INSERT INTO ndj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mweni Kayafa avagayilili vakomi va Vayawudi chilongu kucha ngiba, mundu yumu asovi kwanongwa ya vosi. ");
INSERT INTO ndj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petili na ndundami wingi vamkovekela Yesu. Ayu ndundami kamanyika nendu na mtambika mkomi, kayingila pamu na Yesu muwudamwa wa mtambika mkomi. ");
INSERT INTO ndj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petili paghaveyi panji ya mlyangu. Ndundami yumu yamanyikili na mtambika mkomi kafuma panji kumuwombela yula mdala wa pamlyangu amuyeghi Petili munyumba. ");
INSERT INTO ndj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mdala yula wa pamlyangu kamuwombela Petili, “Yuwi kuva ndundami yumu wa mundu yula?” Mweni kawomba, “Nenga ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kwavelili na lupepu, vandumindumi na vamachonda va boma vaveli vakosha motu wa makala vakuyota. Petili na mweni aveli vakuyota pamu. ");
INSERT INTO ndj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mtambika mkomi amdashili Yesu milandu ya vandundami vaki pamu na mawuli vaki. ");
INSERT INTO ndj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu kavayangula, “Nenga ng'omba na vandu va mlima awu lipala hela kwa kila mundu, mawuli vangu vosi ndivagola munyumba sha Chapanga na Nyumba ya kudadavila, pala Vayawudi vosi vakwikungula. Wala ng'omba chindu chochosi. Mulufisu ha. ");
INSERT INTO ndj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wuli mukudasha nenga? Mukavadashi vandu yivambikanishili nenga. Nakaka vamanya chila ching'ombili.” ");
INSERT INTO ndj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pawombili kala afi, ndumindumi yumu yawolukili pabehi na Yesu kamvanga mbandi kunu pawomba, “Wuli ukuwomba naha kwa mtambika mkomi?” ");
INSERT INTO ndj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu kavayangula, “Mani ng'omba wafu, unangushi wafu weni, mani ng'omba kwanongwa mukundovela liki?” ");
INSERT INTO ndj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pambeli Anasi kamuyegha Yesu akali kawopiwa kwa Kayafa mtambika mkomi. ");
INSERT INTO ndj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni Petili aveli kawoloka akuyota motu, vamdasha “Na yuwi kwa ndundami wa mundu yula ng'odu?” Petili kayangula, “Ng'odu, nenga ndili!” ");
INSERT INTO ndj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ndumindumi yumu wa mtambika mkomi na yula Simoni Petili amdumulili lijeji, kawomba, “Nenga ndikuwona ng'odu yuwi kula kuchiwunga cha mibiki?” ");
INSERT INTO ndj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petili kakana kandi, tepu njowolu kavika. ");
INSERT INTO ndj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pambeli pamalavila putiputi vamtola Yesu kufuma kwa Kayafa vamuyegha kunyumba ya mkomi wa mkowa wa Yudeya. Vakomi va Vayawudi vayingila ng'odu kwanongwa vakotoo kuva vandu va wafu ili vakotoo kulya lihungu lya Pasaka. ");
INSERT INTO ndj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Topi, Pilatu kafuma pangi kavadasha, “Mukumuhighila liki mundu ayu yimumuyeghili?” ");
INSERT INTO ndj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Vamuyangula, “Mani angaveli mwafu ng'odu tunga muyeghili kwa yuwi ha.” ");
INSERT INTO ndj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatu kavawombela, “Topi mumtoli yumwi mkamuhighi kwa Malawu venu.” Vayawudi vamuyangula, “Yufwi tuvahela uwesu wa kumuhigha njifwa mundu yoyosi.” ");
INSERT INTO ndj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ili chilongu cha wombili Yesu chigoleki kulangusha kucha dasovi wuli wuli. ");
INSERT INTO ndj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatu kayingila munyumba mwaveli Yesu, kamdasha, “Yuwi kwa mutwa wa Vayawudi?” ");
INSERT INTO ndj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kamuyangula, “Filongu afi fya umweni baha awu vakuwombela vandu?” ");
INSERT INTO ndj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatu kamuyangula, “Nenga ndiva Muyawudi? Vandu vaku na vatambika vakomi vakuyegha kwa nenga. Kugola liki?” ");
INSERT INTO ndj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu kawomba, “Wutwa wangu wa mlima awu ha, mani ungaveli wa mlima awu vandumindumi vangu vanganevanilili ngotoo kutayiwa mumawoku va Vayawudi. Topi wutwa wangu wa mahali pengi.” ");
INSERT INTO ndj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatu kamudasha, “Yuwi kuva mutwa?” Pambeli Yesu kamyangula, “Yuwi ukudeta nenga Mutwa. Ndawonikili na kwisa kumlima kwanongwa ayi, tudeti unakaka. Mundu yawutama unakaka, akumbikana nenga.” ");
INSERT INTO ndj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatu kamudasha, “Nakaka ndi liki?” Pawombili chilongu chila, kavafumbukila kandi Vayawudi padeta, “Nenga nguwona ng'odu wafu kwa mundu ayu. ");
INSERT INTO ndj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kwa yumwi kuna chishovi cha kumfuwulila yumu kufuma muchijaka chipindi cha Lihungu, ponopa nenga ndivafuwulili mutwa wa Vayawudi?” ");
INSERT INTO ndj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Vawuta kandi kwa lishu likomi, “Ayu ha, tukumdayila Balaba.” Balaba aveli mpoki kwa vandu. ");
INSERT INTO ndj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pambeli Pilatu kamuyegha Yesu vamutovi ndomondu. ");
INSERT INTO ndj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Veni vamachonda vapota likokoma lya misomi vamufwalisha Yesu kumutwi, kandi vamufwalisha yingwa ya wutwa, ");
INSERT INTO ndj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","vamyendela pavamuwombela, “Hasi, mutwa wa Vayawudi!” Vamutova mbandi. ");
INSERT INTO ndj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pambeli Pilatu kafuma kandi panji kavawombela, “Mumuloli mundu ayu yindimuyegha panji kwa yumwi mumanyi kucha nenga nguwuwona ha wafu wa mundu ayu.” ");
INSERT INTO ndj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu kafuma pangi, kafwala lila likokoma lya misomi na yingwa ya chiwutwa. Pilatu kavawombela, “Mumloli mundu ayu.” ");
INSERT INTO ndj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Vatambika vakomi pamu na vamachonda va Nyumba ya kudadavila pavamuwonili vadeta kwa lishu likomi, “Muvangilili mulupingika, muvangilili mulupingika!” Pilatu kavawombela, “Mumtoli mwaveni baha mumuvangilili mulupingika, nenga nguuwona ha wafu waki.” ");
INSERT INTO ndj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Vayawudi vamuyangula, “Yufwi tuva na Malawu vetu, mumalawu ava akudayilwa kusova, nongwa kayigola kucha mweni Mwana wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatu papikinili chilongu chila, katila nesu. ");
INSERT INTO ndj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kayingila kandi munyumba ya mkomi wa mkowa wa Yudeya, kamudasha Yesu, “Yuwi kufuma koti?” Yesu kamyangula ha. ");
INSERT INTO ndj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatu kamuwombela, “Yuwi ukudeta ng'odu na nenga? Kumanya ha kucha nenga ndiva na uwesu wa kukufuwulila awu kukuvangilila mulupingika?” ");
INSERT INTO ndj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kamyangula, “Yuwi ungaveli kwahela uwesu kwa nenga mani ungapatili ng'odu kufuma kumbindi kwa Chapanga. Topi mweni yangamulili kunyegha kwa yuwi kana sambi ngomi nendu.” ");
INSERT INTO ndj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Topi papikinili naha Pilatu akasakeyi njila ya kumlekesa Yesu, Vayawudi vamuwutila, “Mani pawumlekesela ayu, yuwi kuva lighanja ha na Mutwa wa Loma. Mundu mweni yayigola mutwa ayu akumvifya Mutwa wa Loma!” ");
INSERT INTO ndj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Topi, Pilatu pakapikinishili naha, kamfumisha Yesu panji, kayikala muchiti cha kuhighila, pala pavapakema Sakafu ya Migonguveli, kwa chibulaniya, “Gabata” ");
INSERT INTO ndj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yaveli pabehi na lijuva lya pasaka na mkengi waveli palundosi, lijuva lya kutanda Lihungu. Kavawombela Vayawudi, “Ayu mutwa wa yumwi” ");
INSERT INTO ndj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Vadetili kwa lishu likomi, “Muwulayi! Muwulayi! Muvangilili mulupingika!” Pilatu kavawombela, “Yumwi mudayila nenga ndimuvangililii mulupingika mutwa wa yumwi?” Vatambika vakomi vayangula, “Tuva hela Mutwa wingi ila mutwa wa Loma weka hela.” ");
INSERT INTO ndj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pambeli Pilatu kavagayila Yesu kwa veni vamuvangilili mulupingika. Topi, vamtola Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kafuma kunu katola lupingika lwaki mweni kayenda pala pavakema Lipava lya Mutwi. Pavapakemili Goligota kwa Chibulaniya. ");
INSERT INTO ndj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Vamuvangilila mulupingika kula na pavelili vandu vavili vavangiliwili mulupingika pamu na Yesu, yumu mwambu wa mlilu na wingi mwambu wa mkiyi. ");
INSERT INTO ndj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mweni Pilatu kayandika pachibawu kachivangilila pa lupingika, kayandika, “Yesu wa Nasaleti Mutwa wa Vayawudi.” ");
INSERT INTO ndj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Vayawudi vatangalili vasoma, nongwa pala Yesu pavamuvangilili mulupingika pavelili pabehi na mbwani kandi vayandika kwa Chibulaniya, Chilatini pamu na Chigiliki. ");
INSERT INTO ndj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Vatambika vakomi na Vayawudi vamuwombela Pilatu, “Ukotoo kuyandika mutwa wa Vayawudi, topi mundu ayu awombili mweni mutwa wa Vayawudi.” ");
INSERT INTO ndj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatu kavayangula, “Chinyandikili, nyandika.” ");
INSERT INTO ndj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Vala vamachonda pavamalilili kumuvangilila mulupingika Yesu, vatola yingwa shaki, vavaghana filepa mchechi, kila machonda chilepa chimu na lihabiti lingajila kusonewa vatolili. ");
INSERT INTO ndj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Vayiwombela veni, “Tukotoo kuyidemula, tuyigoleli do ili ghani atoli.” Chilongu achi chagolikili ili mayandiku vang'alili vavi, “Vavaghana yingwa shangu veni kwa veni. Vavaghana yingwa shangu kwa kugola do” Nahawu ndi wuvagolili vamachonda. ");
INSERT INTO ndj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pabehi na lupingika lwa Yesu vaveli vawoloka mawu wa Yesu na mkulumundu na Maliya mdala wa Kilopa, pamu na Maliya Magadalena. ");
INSERT INTO ndj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu pamuwonili mawu waki na ndundami yumu yamtamili kawoloka pabehi, kamuwombela mawu waki, “Mawu ayu mwana waku.” ");
INSERT INTO ndj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pambeli kamuwombela yula ndundami, “Ayu mawaku.” Kufuma pala ndundami yula kamtola mawu yula kayaki. ");
INSERT INTO ndj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pambeli Yesu kamanya kucha fyosi fyavelili kala, ili Mayandiku Mang'alili vavi, kadeta “Nguwona nyumilwa.” ");
INSERT INTO ndj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pala paveli na chindu, vataya siki pambeli vajabika lindelindeli vavika muluteti vamsofusha. ");
INSERT INTO ndj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Payangili yila siki, Yesu kadeta “Yipela.” Pambeli kagondamisha mutwi kasova. ");
INSERT INTO ndj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pambeli vakomi va Vayawudi vamuluva Pilatu avajumishi kugojola mawulu va vala vavangiliwili mulupingika na kusunusha fikongu fyawu pasi kufuma mulupingika. Vagolili naha kwanongwa yaveli lijuva lya Ijuma lyaveli lijuva lya kutandila Lijuva lya kupumulila na vadayilili ng'odu mivili ya vandu vala yikali kumbindi ya lupingika lijuva lila, kwanongwa Lijuva lila lyaveli Lijuva lya kupumulila. ");
INSERT INTO ndj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Machonda vayisa vamgojola miwulu wa kwaa na wingi yumu wa vala yavangiliwi mulupingika pabehi na Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pavayendili kwa Yesu vamuwona kasova kala, vamugojola ha mawulu, ");
INSERT INTO ndj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lakini machonda yumu amusomili na lisala mulubafu, tepu mwasi pamu na machi vamwayika. ");
INSERT INTO ndj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yula yalolili figolikili pala kawomba, ili na yumwi wuwowu mjumili. Chatovilelili chiva nakaka na amanyili kucha chadetili chiva nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Findu afi fyagolikili naha ili mayandiku vavi, “Kwahela lipava daligojulewi.” ");
INSERT INTO ndj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na kuna Mayandiku vengi kandi vakudeta “Davamloli mweni yivamsomili.” ");
INSERT INTO ndj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pambeli, Yosefu yafumili mumbwani ya Alimataya, kamuluva Pilatu kucha akuwesha kutola chikongu cha Yesu. Yosefu aveli ndundami wa Yesu, lakini amuluvili kwa lufisu kwanongwa avatilili Vayawudi. Pilatu kamuyangula ukuwesha kuutola, topi Yosefu kayenda katola chikongu. ");
INSERT INTO ndj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kayenda pamu na Nikodemu, yula yayendili kwa Yesu pamihi, kayegha mtela wuvakema manimani kahasha na udi. Fyosi fyaveli kucha chitandavala chimu na litingaja. ");
INSERT INTO ndj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Veni vawutola mvili wa Yesu, vawufwalisha ligubiku na kushagha vala mafuta va kunungilila kucha chishovi cha Vayawudi pavasika. ");
INSERT INTO ndj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Bahala pala pavamvangililili mulupingika mbaka kasova paveli na chiwunga na musembi ya ligangachuma yivasonguliwili kala, yingajila kusikiwa mundu. ");
INSERT INTO ndj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mula vawusika mvili wa Yesu, kucha mayandiku va Vayawudi, nongwa yila sembi yaveli pabehi. ");
INSERT INTO ndj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lijuva lya kupumulila lya kwaa lya juma, Maliya Magadalena putiputi kayenda kusembi, kaliwona ligangachuma liwushiwa pa sembi. ");
INSERT INTO ndj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Katuva mbilu kuyenda kwa Simoni Petili na ndundami yula Yesu amutamili, kavadetela, “Vamtola Bambu kufuma musembi. Tumanya ng'odu kuvamvikili!” ");
INSERT INTO ndj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petili pamu na ndundami yula vayenda kusembi. ");
INSERT INTO ndj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Vosi vavili vatuva mbilu, yula ndundami katuva mbilu nendu ya Petili. Kava wa kwaa kufika pa sembi. ");
INSERT INTO ndj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pagondamili kushungulila kasiwona yingwa siva pamu, lakini kayingila ng'odu musembi. ");
INSERT INTO ndj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pambeli kayisa Simoni Petili, kayingila musembi. Kasiwona yingwa shaveli pala, ");
INSERT INTO ndj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na chila chipandi cha yingwa chivamuwopilili Yesu kumutwi, chaveli chiyifufunga weka yaki pambali. ");
INSERT INTO ndj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pambeli yula ndundami wa kwaa kufika pala na mweni kayingila musembi. Mweni kalola kandi kajumila. ");
INSERT INTO ndj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Vamanyili ng'odu mayandiku yivawombili mweni dashukuki kufuma munjifwa. ");
INSERT INTO ndj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pambeli vandundami vala vawuya kaya. ");
INSERT INTO ndj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliya kawoloka kunu palila pala pasembi kunu kagondama pakashungulila musembi. ");
INSERT INTO ndj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kavawona makungu vavili vafwala yingwa sing'alili, vayikala pala pawonjili Yesu, yumu aveli kumutwi na yumonga aveli kumawulu. ");
INSERT INTO ndj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Veni vamudasha, “Mawu, ukulilila liki?” Kavayangula, “Vamuwusha Bambu wangu. Nenga manya ng'odu kuvamvikili.” ");
INSERT INTO ndj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pambeli kalola kumbali kamuwona Yesu kawoloka pala pambali, amanyili ng'odu kucha yula Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu kamuwombela, “Mau, wuli ukulila? Ukumusaka ghani?” Mau yula awombeyi yula mkola chitava chila. Kamuwombela, “Mani kumutola yuwi, ung'ombeli kumuvikili na nenga ndimuloli.” ");
INSERT INTO ndj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu kamuwombela, “Maliya!” Mweni kaghalambuka kamuwombela Chibulaniya, “Laboni” Mana yaki, muwula. ");
INSERT INTO ndj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu kamuwombela, “Ukotoo kungamula. Nongwa ngalihela kuwuya kwa Tati wangu. Ponopa yendi kwa valongu vangu kavawombeli nguwuya kwa mweni Tati wa yumwi. Kwa Chapanga wa nenga na vayumwi.” ");
INSERT INTO ndj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maliya Magadalena kayenda kwa vandundami va Yesu, kavawombela, ndimuwona Bambu, na kamuwombela fila fyawombiliwili. ");
INSERT INTO ndj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yaveli mbungamihi lijuva lya kupumulila na vandundami vayikungasha pamu milyangu yitatwa, vavatileyi Vayawudi, Yesu kayisa kawoloka pavaveli veni kawomba, “Kusika kuvi na yumwi.” ");
INSERT INTO ndj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pawombili naha, kavalangusha mawoku vaki na lubafu lwaki. Vandundami ndavava na cheleli buja pavamuwonili Bambu. ");
INSERT INTO ndj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kandi Yesu kawomba, “Kusika kuvi na yumwi! Kucha Tati anyeghili nenga, ponopa nguvalayisha yumwi.” ");
INSERT INTO ndj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pambeli kavapumulila Mfuki Mng'alili pawomba, “Mumuyangi Yang'alili. ");
INSERT INTO ndj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mani pamuvawushila vandu sambi, ava vawushilwa, pamuvawushila ng'odu, ava vawushilwa ha.” ");
INSERT INTO ndj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi yivamkema mambila pamu na vala lilongu na vavili aveli pamu na vamonga ha Yesu payisili. ");
INSERT INTO ndj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Vala vanachuli vamonga vamuwombela, “Tumuwona Bambu.” Tomasi kavawombela, “Pandiyiwona ng'odu milanga ya misumali mumawoku vaki na kugufya chala changu mumikovi yaki na kusanjika liwoku lyangu mulubafu lwaki, ngujumila ha.” ");
INSERT INTO ndj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pambeli payipitili juma yimu, vandundami vaki vaveli kandi munyumba pamu na Tomasi, kayisa kunu milyangu yitatiwa Yesu kawoloka pagati kawomba, “Kusika kuvi na yumwi” ");
INSERT INTO ndj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pambeli Yesu kamuwombela Tomasi, “Yeghi chala chaku tayi na uloli mawoku vangu, uyeghi na liwoku lyaku yingishi mulubafu lwangu. Ukotoo kuyipwelesha jumili.” ");
INSERT INTO ndj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi kamuyangula, “Bambu na Chapanga wangu.” ");
INSERT INTO ndj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu kamuwombela kandi, “Kwa nogwa kung'ona ukujumila. Luseku kwa vala yivajumila ngajila kung'ona nenga!” ");
INSERT INTO ndj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu kagola filangushilu fitangalili kwa vandundami vaki, yeni yiyandikiwa ha muchitabu achi. ");
INSERT INTO ndj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ayi yiyandikwa yumwi muweshi kujumila, kucha Yesu mweni Kilistu, mwana wa Chapanga, wula pamumjumila mweni damuvi na unofu kwa mweni. ");
INSERT INTO ndj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pambeli Yesu kawoneka kandi kwa vandundami vaki kulihiva lya Tibeliya. Yaveli naha: ");
INSERT INTO ndj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petili na Tomasi yiva mkema mambila na Natanieli yula yafumili Kana ya Galilaya na vana vavili va Sebidayu na vandundami vavili va Yesu vaveli pamu. ");
INSERT INTO ndj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petili kavawombela, “Nguyenda kulova vasomba.” Veni vawomba, “Yufwi datuyendi na yuwi.” Vayenda vayipaka muwatu, lakini pamihi posi vapata hata somba yumu ha. ");
INSERT INTO ndj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pamalavila lijuva palisosomokeyi, Yesu aveli muluwongu lwa lihiva, vandundami vamumanyili ha kucha ndi Yesu. ");
INSERT INTO ndj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pambeli Yesu kavadasha, “Vaghanja vangu muwomesha ng'odu hata somba yumu?” Vamuyangula, “Tupata ha.” ");
INSERT INTO ndj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kavawombela, “Muyashi lwafu mwambu wa mulilu wa watu, damuvapati vasomba.” Vategha, pambeli valemwa kukweghela lwafu muwatu, nongwa vawomeshili vasomba vatangalili. ");
INSERT INTO ndj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pambeli ndundami yula yatamiwili na Yesu kamuwombela Petili, “Yula ndi Bambu!” Simoni Petili papikanishili kucha yula ndi Bambu, kakuna yingwa yaki kayiwopela muchiwunu. Nongwa asighalili na sawu hela kayiyasila mumachi. ");
INSERT INTO ndj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Vandundami vasighalili muwatu vayisa kumwambu ya lihiva, kunu pavakweya lwafu lumemili vasomba. Vaveli patali ha na luwongu, paveli kucha mawulu milongu lilongu. ");
INSERT INTO ndj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pavafikili muluwongu, vawona motu wa makala, pambindi vavika vasomba pamu na mibumunda. ");
INSERT INTO ndj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu kavawombela, “Muyeyi vasomba vamu yimuvakamulili ponopa.” ");
INSERT INTO ndj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Petili kayipaka muwatu kakwegha lwafu luveli na vasomba mbwaya milongu na lilongu muhanu na vatatu. Vasomba vosi ava lakini lwafu lwademukili ha. ");
INSERT INTO ndj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu kavawombela, “Mwisi mulyi.” Kwahela ndundami yamudashili kucha, mweni ghani, kwanongwa vamanyili mweni Bambu. ");
INSERT INTO ndj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu katola libumunda kavagayila, pambeli atolili vasomba kagola nga wuwula. ");
INSERT INTO ndj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Awu waveli mwanja wa tatu wa Yesu kuvafumbukila vandundami vaki kufuma pashukukili. ");
INSERT INTO ndj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pavalili kala, Yesu kamuwombela Simoni Petili, “Simoni mwana wa Yohani, Wuli, yuwi ukundama nenga munu kupita voseva?” Kamyangula, “Yina Bambu, yuwi kumanya kucha ngukutama.” Yesu kamuwombela, “Dimi vanafungami vangu.” ");
INSERT INTO ndj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu kamuwombela kandi, “Simoni mwana wa Yohani, wuli, kundama?” Kamuyangula, “Yina Bambu, yuwi kumanya kucha ngukutama.” Yesu kamuwombela, “Dimi vafungami vangu.” ");
INSERT INTO ndj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mwanja wa tatu kamuwombela, “Simoni mwana wa Yohani, ukundama nenga?” Petili kakalala nongwa kamdasha myanja mitatu, “Yuwi ukundama nenga?” Mweni kamuwombela, “Bambu kumanya.” Yesu kawomba, “Dimi vafungami vangu. ");
INSERT INTO ndj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ngukuwombela nakaka, pawuveyi msongolu wayiwopili umweni yingwa yaku, wayendili kuwudayila umweni. Lakini paugogola dawuhololi mawoku vaku na mundu wingi akukuwopa yingwa yaku, pambeli akukuyegha kuungajila kudayila kuyenda.” ");
INSERT INTO ndj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu kawomba naha kulangusha kucha Petili dasovi munjifwa ya wuliwuli na kuyegha ukomi kwa Chapanga. Pambeli Yesu kamuwombela, “Ungovikeli!” ");
INSERT INTO ndj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petili kaghalambuka kamuwona ndumindumi yula yatamiwili na Yesu akuvakovikela, ndundami yula ndi mweni yamusaghamilili Yesu pavalyeyi, yula amudashili, “Bambu ghani akwisa akushengeti yuwi?” ");
INSERT INTO ndj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petili pamuwonili mweni, kamudasha Yesu, “Wuli mundu ayu?” ");
INSERT INTO ndj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu kamyangula, “Leki ngudayila mweni ayikali mbaka panyisa, achi chindu liki kwa yuwi? Yuwi ungovekeli nenga.” ");
INSERT INTO ndj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chilongu chila chilanduka kwa valongu kucha ndundami yula dasovi ha. Lakini Yesu kawomba ha kucha yula ndundami dasovi ng'odu, mweni kawomba kucha “Mani ngudayila mweni ayikali mbaka panyisa, achi chindu liki kwa yuwi?” ");
INSERT INTO ndj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yula ndundami ndi mweni yadetili na kuyandika milandu ayi. Tumanya kucha chatovilelili chavelili nakaka. ");
INSERT INTO ndj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kuna milandu yitangalili Yesu yagolili. Leki fingayandikiwili fyosi chimu chimu, nguyihola mlima wosi wungaveli kwahela fwasi ya kuvika fitabu.");
INSERT INTO ndj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mkomi Teofili, muchitabu cha kwaa ndayandikili milandu yosi Yesu yagolili na kuwula kukandila pakwandi ya chichuku chaki, ");
INSERT INTO ndj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mbaka lijuva lila patoliwili kumbindi. Paghaveyi akali kutoliwa kumbindi Mfuki Mng'alili amgolili avawulili vandundami yivashawulili ndambu ya kuyikala. ");
INSERT INTO ndj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Majuva milongu mchechi kufumila kusova kwa mweni avafumbukilili myanja yitangalili nakaka aveli mnofu. Vamuwonili, mweni aywangili nawu milandu ya wutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chipindi patang'anikeyi pamu na veni avawulili naha, “Mkotoo kuwuka Yelusalemu, mveteli tanila Mfuki Mng'alili ayu ndi fupu yajangili Tati, mwambikanishili kala pandimuhimulileyi. ");
INSERT INTO ndj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohani Mbatisha abatishili kwa machi, pavapita majuva madokwa yumwi damubatishwi kwa Mfuki Mng'alili.” ");
INSERT INTO ndj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Topi, vandundami pavatang'anikili pamu na Yesu, vamudashili, “Wuli Bambu, chipindi achi dauvapi kandi wutwa wula vandu va Isilaeli?” ");
INSERT INTO ndj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Lakini Yesu kavawombela, “Chipindi na majila va milandu ayi yiva muuwesu wa Tati wangu, ayi milandu yenu ha kumanya kucha dayivi ndili. ");
INSERT INTO ndj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lakini chipindi Mfuki Mng'alili pavavasunukilili yumwi, damupokeli liwovi damuvi vatovilela vangu mumbwani ya Yelusalemu na mumkowa wa Yudeya na Samaliya pamu na mumlima wosi.” ");
INSERT INTO ndj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Padetili kala afi, kunu pavamlola, atoliwili kumbindi, lifundi limfifa vakotoo kumuwona kandi. ");
INSERT INTO ndj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pavaveghi vakali vakalola kumbindi, paghaveyi akuyenda, tepu vandu vavili yivavelili vafwala yingwa sha mbuleteee vawolukili pabehi na veni. ");
INSERT INTO ndj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Vadeta, “Yumwi vandu va Galilaya! Wuli mukuwoloka kunu patoliwa kumbindi? Yesu ayu yatoliwili kufuma kwa yumwi na kuyenda kumbindi, dayisi kandi ndambu yiyeyi yimumuwonili patoliwa kumbindi.” ");
INSERT INTO ndj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pambeli vandundami vawuya Yelusalemu kufuma chidunda chivachikemili Miseyituni chaveli pabehi kucha kilumita yimu kufuma kumbwani. ");
INSERT INTO ndj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pavafikili kumbwani vayingilili chumbagati cha mugolofa veni vavelili vakwikala, aveli Petili na Yohani na Yakobi na Andeleya na Filipu na Tomasi na Batulumeyu na Mateyi na Yakobi mwana wa Alufayu na Simoni mlevangila mlima wa Vaisilaeli na Yuda mwana wa Yakobi. ");
INSERT INTO ndj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Voseva vayikungula pavadadava pamu na vadadala vamonga na Maliya mawaki Yesu pamu na vafwata mundu. ");
INSERT INTO ndj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mumajuva vala, Petili awolukili pagati ya vala valongu yivajumilili vayikungili, vosi vaveli vandu mya na milongu mivili, ");
INSERT INTO ndj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","kadeta, “Valongu vangu yimujumilili, yaveli nakaka lula lubali lwa Mayandiku Vang'alili luvi, lubali lwa Mfuki Mng'alili, kwa filongu fya Dawudi, atungili milandu ya Yudasi, yula yavalongushili vala vandu kumkamula Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda aveli yumu wa chipinga chetu, kwanongwa ashawuliwili ghavi mungimbaniku yetu.” ");
INSERT INTO ndj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mweni ahemilili chitava kwa sila mbiya shapatili kwa chindu chaki cha wafu, kawa pasi luu! Kabaluka, mitima yaki yisekimuka. ");
INSERT INTO ndj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kila mundu Muyelusalemu apikanishili milandu yila kwa luga yawu na vachikema chila chitava “Hakeli Dama.” Mana yaki, “Chitava cha Mwasi.” ");
INSERT INTO ndj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Topi, vayandika muchitabu cha Lumbombu: ‘Makalu vaki vasighala domu, mundu yoyosi akotoo kuyikala mugati yaki.’ Na yiyandikiwa: ‘Mundu wingi atoli fwasi yaki ya ngimbanikilu.’ ");
INSERT INTO ndj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Pambeli, mundu yumu wa vala yivaveli pamu na yufwi chipindi chosi Bambu Yesu paghaveyi mumwanja, ashawuliwi ghavi pamu na yufwi. ");
INSERT INTO ndj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ayu ghavi yumu wa vala yivayilongushili na yufwi tangila Yohani Mbatisha pabatishagha mbaka lijuva lila Yesu patoliwili kumbindi kufuma kwa yufwi. Ayu daghavi pamu na yufwi muutovileli wa kushukuka kwa Yesu.” ");
INSERT INTO ndj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Apa, vatambula matawa va vandu vavili, wa kwaa Yosefu vamkemaya Balisaba awu Yustu na yumonga Matia. ");
INSERT INTO ndj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pambeli vadadava: “Bambu, yuwi kumanya ndima sha vandu vosi. Topi, wutulangushili gati ya ava vavili yoti yumushawulili, ");
INSERT INTO ndj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ili atoli achi chichuku cha undundami yachilekili Yudasi yayendili kwakumanyili Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Vagola doo, yamponikilili Matia, mweni kayongeshwa kwa vala vandundami vamonga lilongu na yumu. ");
INSERT INTO ndj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lijuva lya Pendikosti palifikili, vosi vaveli vayikungula pamu. ");
INSERT INTO ndj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tepu, vapikanisha lishu kufuma kumbindi, lyaveli kucha liyegha likomi, limema munyumba yonda yivayikalili. ");
INSERT INTO ndj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pambeli, fifumbuka findu kucha myengi ya motu, yiivavili kutula kwa vandu vosi yivavelili mula. ");
INSERT INTO ndj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Vosi vamemishiwa Mfuki Mng'alili, vakanda kudeta detelu yingi kucha Mfuki Mng'alili wavagolili vadeti. ");
INSERT INTO ndj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aku Yelusalemu vavelili Vayawudi, vandu yivamjumili Chapanga, vafumili kila mlima. ");
INSERT INTO ndj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pavapikanishili lishu ali, lipinga likomi lya vandu liyikungasha. Vosi valilimuka nendu, pala kila mundu vavapikanishili pavadeta kila mundu cha kayaki mweni. ");
INSERT INTO ndj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Vajingwa na kuyikang'anika pavayiwombela, “Voseva venikaya va Galilaya yina ndaa? ");
INSERT INTO ndj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ponopa yikuva wuliwuli yufwi tukuvapikana kila mundu mukabila yetu? Yiva wuliwuli, vandu vosi tukuvapikana pavadeta kwa kabila shetu? ");
INSERT INTO ndj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vamonga gati ya yufwi, Vapalisi na Vamedi na Vaelamu na vamonga venikaya va Mesopotamia na Yudeya na Pondu na mkowa wa Asia, ");
INSERT INTO ndj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","na Fulugia na Pamfilia na Misili pamu na mwambu wa Libiya pabehi ya Kileni pamu na vahenja vamonga kufuma Loma, ");
INSERT INTO ndj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Vayawudi na vandu yivalowokili mudini ya Vayawudi, vamonga va Kileti na Vahalabu. Twavosi yufwi tukuvapikana pavadeta kwa kabila shetu milandu mikomi ya Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Vosi vayikanganika na kujuluvala kunu pavayidasha, “Ayi yiva na mana liki?” ");
INSERT INTO ndj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lakini vamonga vakavadanileyi pavadeta, “Vandu ava valovela difwayi!” ");
INSERT INTO ndj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petili awolukili pamu na vala lilongu na yumu, akandili kuvalandulila vandu kwa lishu likomi: “Valongu va Vayawudi na vosi yimwikala Yelusalemu, mupikanishi kwa finofu filongu fyangu. ");
INSERT INTO ndj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Vandu ava valovela ng'odu ngimu yimuyihola, mbona yiva malavila saa ndatu hela? ");
INSERT INTO ndj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nakaka milandu ayi yawombili Yoweli mbuyi wa Chapanga: ");
INSERT INTO ndj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Majuva vala va mwishu, Chapanga akudeta, dandivamwayili Mfuki wangu vandu vosi. Vasongolu na vahinja venu davatungi milandu yangu, vafijana venu davaluluti umbuyi wa Chapanga, vavaha venu davaloti milotu. ");
INSERT INTO ndj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hata kwa vandumindumi vangu valumi na vadala, danivamwayili Mfuki wangu majuva vala, na veni davatungi milandu yangu. ");
INSERT INTO ndj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Dagoli filangushilu kumbindi, na pasi pamlima danangushi filoja, dakuvi na mwasi na motu na lyosi tii, ");
INSERT INTO ndj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lijuva dalighalambuki lwisa, na mwesi dawubyuali kucha mwasi, paliveyi likali hela kufika lijuva lila likomi lya kwisa Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Apa, mundu yaluva kwa litawa lya Bambu dalowuliwi.’ ");
INSERT INTO ndj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Vayisilaeli, mpikanishi filongu afi! Yesu wa Nasaleti aveli mundu yalangushiwili kwa yufwi na Chapanga kwa mihilu na nangushilu, ya kuyikang'anika na ndambu Chapanga wavalangushili gati yenu kwa kupitila mweni, kucha wula wumumanyili. ");
INSERT INTO ndj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yaveli milandu ya Chapanga mweni, yayilatili kala, Yesu atayiwi mumawoku venu, mumuwulaghi kwa kuvalekela vandu va wafu vamuvangilili mulupingika. ");
INSERT INTO ndj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lakini Chapanga amshukushili munjifwa, kamlekesha kugoboliwa munjifwa kwanongwa akotoo kuwopiwa na njifwa. ");
INSERT INTO ndj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawudi awombili milandu yimwilatili mundu yula: ‘Ndamuwonili Bambu pawulongolu yangu chipindi chosi, kava na nenga mwambu wangu wa mlilu dandikanyiki ha. ");
INSERT INTO ndj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ndima yangu yikusekilela, kandi lulimi lulumbilila kwa cheleli, na njimba yangu dayiikali yikushuvilila, ");
INSERT INTO ndj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nongwa yuwi Chapanga dawuneki ng'odu nenga kumambi, wala kumlekishela mng'alili waku awoli. ");
INSERT INTO ndj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kunangusha deha sha unofu, yuwi dawumemeshi nenga cheleli pawuva pabehi na nenga.’ ");
INSERT INTO ndj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Valongu vangu, ngudayila kuvawombela finofu milandu yimupatili mbuyi wetu mkomi Dawudi. Mweni asovili, vamsika na sembi yaki yiva pakaya yetu mbaka nalelu. ");
INSERT INTO ndj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawudi aveli mbuyi wa Chapanga, yamanyili kucha Chapanga kamwilapila kucha yumu kufuma mulukolu lwaki dahali wutwa waki. ");
INSERT INTO ndj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawudi awonili kala milandu dagoli Chapanga kavawombela kushukuka kwa Kilistu Mkombola chipindi padetili: Vamleka ng'odu kumambi na mvili waki uwola ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chapanga amshukushili Yesu ayu munjifwa na yufwi twavosi ndi vatovilela va unakaka awu. ");
INSERT INTO ndj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mweni pakweshiwili kala na kuvikiwa mwambu wa mlilu, Chapanga katugayila Mfuki Mng'alili ndi ujangi wa Tati, ponopa Yesu katuyitila kala ayu Mfuki Mng'alili. Achi chimuchiwona na kupikana ponopa. ");
INSERT INTO ndj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mana Dawudi mweni, akwelili kumbindi ha, ila mweni adetili: ‘Bambu amuwombilili Bambu wangu: Uyikali mwambu wangu wa mlilu, ");
INSERT INTO ndj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mbaka ndivagoli vachimdwama vaku vavi kucha chigoda cha kuvikila mawulu vaku.’ ");
INSERT INTO ndj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Vandu vosi va Isilaeli nakaka vakudayiliwa vamanyi kucha ayu Yesu yivamuvangililili mulupingika, Chapanga amugolili Bambu na Kilistu.” ");
INSERT INTO ndj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Vandu pavapikanishili afi, fyavasomili mundima, vavadashili Petili na vala vandundami: “Valongu tugoli wuli wuli?” ");
INSERT INTO ndj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petili kayangula, “Mupomeli sambi shenu na mubatishiwi kwa litawa lya Yesu Kilistu ili kila mundu awushiwi sambi na mupokeli Mfuki Mng'alili ndi fupu. ");
INSERT INTO ndj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nongwa, ujangi waveli wa yumwi na vana venu, kwa vala vosi yivayikala kutali na kila mundu dakemiwi na Bambu wetu Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Avawombilili filongu fitangalili na kuvadedeka vandu pavawombela, “Mulowoki muchileli achi cha wafu.” ");
INSERT INTO ndj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Vandu vatangalili vajumilili filongu fyaki, vabatishiwa. Lijuva lila vayongishekili vandu alufu ndatu mulipinga lila. ");
INSERT INTO ndj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ava vosi vayiwulili kwa vandundami na tuwilumba pamu muulongu, kulya pamu na kudadava. ");
INSERT INTO ndj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mihilu na miwujawuja fitangalili fyagolikili na vandundami mbaka kila mundu awonili lyova. ");
INSERT INTO ndj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vala vajumilili vosi vaveli vayendilela kuva mahali pamu na findu fyawu fyaveli fya vosi. ");
INSERT INTO ndj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Vahemishili fitava na findu fyawu, pambeli vavaghanili mbiya kila mundu ndambu ya shida yaki. ");
INSERT INTO ndj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Majuva vosi vatanganikaya munyumba sha Chapanga. Lakini chipindi cha kulya, vatanganikaya munyumba shawu na valili filivi fyawu kwa cheleli na kushisha ndima. ");
INSERT INTO ndj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Vamujumili Chapanga, vatamiwili na vandu vosi. Kila lijuva Bambu avayongishili mulipinga lyawu vandu yivavelili vakulowuliwa. ");
INSERT INTO ndj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lijuva limu, saa tisa pamusi, Petili na Yohani vaveli vakuyenda kunyumba ya Chapanga, chipindi cha kudadava. ");
INSERT INTO ndj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kwaveli na mundu yaveli chikwavakwava kufumila kuwoneka. Topi vandu vaveli vakumpapa majuva vosi mbaka pamulyangu wa nyumba ya Chapanga wuvawukema, “Mlyangu wa Nyanyi” ili avaluvi vala yivayingila munyumba ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pavawonili Petili na Yohani pavayingila munyumba ya Chapanga, mweni avaluvili vamupi chindu. ");
INSERT INTO ndj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petili kamulola ngimu wamulolili Yohani pambeli Petili kamuwombela “Tuloli!” ");
INSERT INTO ndj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mweni kavaghalambukila pashuvilila kupata chindu kwa veni. ");
INSERT INTO ndj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pambeli Petili kamuwombela, “Nahela mbiya wala chumang'andu, lakini chila chimelili nachu dangugayili. Kwa litawa lya Yesu Kilistu wa Nasaleti, woloki yendiyendi!” ");
INSERT INTO ndj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pambeli, kamukamula liwoku lya mlilu, pamtanga kumtandamula bahala pala mawulu na matendi vaki vaveli na liwovi. ");
INSERT INTO ndj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kajumba, kawoloka kwa mawulu vaki kakanda kuyenda yenda. Pambeli kayingila munyumba ya Chapanga, pamu na veni payendayenda na kujumbanga kunu pamjuma Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Vandu vosi vaveli pala pavamuwonili payendayenda na kumjuma Chapanga, ");
INSERT INTO ndj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","vandu vamumanyili kucha yula ndi yayikalagha na kuluva pala pamlyangu wuvawukema “Mlyangu wa Nyanyi” wa nyumba ya Chapanga, veni vajinga nendu hata vakamanyeyi ha chindu liki chimgolili nawula. ");
INSERT INTO ndj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yula mundu aveli akali hela kavakamulila Petili na Yohani. Vandu vosi, pavajingweyi nendu, vakandili kutuvila muudamwa wuvawukema “Mdamwa wa Solumoni.” ");
INSERT INTO ndj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Topi, Petili pavawonili vandu vala vakujuluvala kavawombela, “Vayisilaeli, wuli mukuyikang'anika filongu afi? Wuli mukutufulutulila mesu kucha kwa liwovi lyetu awu uwesu wa yufwi wumugola mundu ayu ayendiyendi? ");
INSERT INTO ndj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chapanga wa Ibulahimu na wa Isaka na wa Yakobi pamu na wa vagogolu vetu na mweni Chapanga yamjuma Yesu ndumindumi waki. Mumkamula awulayiwi, yumwi mwamlemili hata yingaveli Pilatu angamlekishelili ghavi pekesu. ");
INSERT INTO ndj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Avelili Mng'alili na goleki lakini yumwi mwamulemili, mumudayila mundu yula yawulagha vandu alekisheliwi. ");
INSERT INTO ndj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mwamuwulayili yula yaveli chikandilu cha unofu, lakini Chapanga amshukushili munjifwa. Yufwi vatovilela wa afi. ");
INSERT INTO ndj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mukumuwona mundu ayu yimummanyili kalijumila litawa lya Yesu limgola ghavi na liwovi, litawa lya Yesu nakujumila kwaki kumgola anani nakaka, ngimu vosi yimumuwona. ");
INSERT INTO ndj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Hinapawu valongu vangu, manya kucha yumwi na vakomi venu mumgolela Yesu chindochi pangajila mwaveni kumanya kucha mukugola chindu liki. ");
INSERT INTO ndj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Chapanga agolili fila fya wombili kwa vambuyi vosi, yaveli Kilistu Mkombola dagobuliwi, ponopa ndi kagola chawombili. ");
INSERT INTO ndj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mupomeli sambi shenu mumuwuyili Chapanga, chipindi dachiyisi mweni davawushili sambi shenu, ");
INSERT INTO ndj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mgoli nahawu ili Bambu avapi chipindi cha kutayiwa munda kandi davayegheli yula Kilistu Mkombola amshawulili mweni, ayu ndi Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mweni asighali aku kumbindi mbaka payisa chipindi cha kukombola uswanu findu fyosi, ngimu Chapanga wadetili kupitila vambuyi vaki vang'alili vatangalili va dahili. ");
INSERT INTO ndj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nongwa Musa adetili, ‘Bambu Chapanga wenu davayegheli mbuyi kucha nenga mumlima wenu. Na yumwi damumpikanishi findu fyosi fyavawombela. ");
INSERT INTO ndj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mundu yoyosi yampikanisha ng'odu mbuyi ayu datapuliwi kutali na vandu va Chapanga na kuwulayiwa.’ ");
INSERT INTO ndj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Vambuyi vosi, kukandila Samweli na vala vayisili mumbeli, valandulili milandu yigoleka mumajuva ava. ");
INSERT INTO ndj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ujangi wa Chapanga wadetili kupitila vambuyi vaki kwanongwa ya yumwi. Wuwula wula mukuva pamu mulilaghanu Chapanga lyagolili na vagogolu venu ndi kwanongwa ya yumwi, chipindi Chapanga amuwombilili Ibulahimu, ‘Kwa njila ya fileli fyaku vandu va mlima davanemiliwi.’ ");
INSERT INTO ndj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Topi, Chapanga amshukushili ndumindumi waki kwanongwa ya yumwi, amulayishili avanemeli usangi kwa kumgola kila mundu aghalambuki asileki njila shaki sha wafu.” ");
INSERT INTO ndj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petili na Yohani pavaveghi vakali vakuvalandulila vandu yivayisili vatambika na vakomi va machonda va nyumba ya Chapanga pamu na Masadukayu. ");
INSERT INTO ndj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Vandu ava vakalalili munu kwanongwa vandundami ava vavelili vakulandula milandu ya kushukuka kwa Yesu, ayi dayilangushi nakaka kucha vandu vasovili davashukuki. ");
INSERT INTO ndj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Topi, vavakamula nongwa yaveli mbungamihi vavavikili muchijaka mbaka chilawu yaki. ");
INSERT INTO ndj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lakini vandu vatangalili yivapikanishili unjangila wula vawujumila na vavelili valulumi alufu muhanu. ");
INSERT INTO ndj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chilawu yaki, vakomi va Vayawudi, vagogolu na vawula va Malawu va Chapanga vamupili Musa vayikungili pamu aku Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Vatanganikili pamu na Anasi mtambika mkomi na Kayafa na Yohani na Alekisanda na vamonga vavelili va lukolu lwa Mtambika mkomi. ");
INSERT INTO ndj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pavavawolushili Petili na Yohani pawulongolu yawu, vavadashili, “Yumwi mugola chindu achi kwa liwovi liki awu kwa litawa lya ghani?” ");
INSERT INTO ndj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pala, Petili, aveli kamema Mfuki Mng'alili, kavawombela “Vakomi va vandu na vagogolu! ");
INSERT INTO ndj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mani payiva mukutudasha chila chilongu cha nyanyi chagoliwili yula mundu yavelili chikwavakwava na ndambu yalowuliwili, ");
INSERT INTO ndj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","yumwi na vandu vosi va Isilaeli mumanyi lelu mundu ayu awolukili uswanu nakaka kwa litawa lya Yesu Kilistu wa Nasaleti, mweni mumuvangilila mulupingika, Chapanga kamushukusha munjifwa. ");
INSERT INTO ndj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ayu ndi mweni chilongu cha nyanyi chadetili: ‘Ligonguveli mulilemili yumwi vajengi, ponopa liva ligonguweli likomi lya kujengela kwa yosi.’ ");
INSERT INTO ndj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ulowola datuupati kwa mundu wingi ha, kwanongwa mlima wosi Kwa hela litawa lingi Chapanga lyatugayilili likuwesha kutulowola.” ");
INSERT INTO ndj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Vakomi va chitemela, vakamanyeyi kucha Petili na Yohani vaveli vandu vangajila kuyenda kushuli na vaveli vandu vasihisihi hela, vayikanganikili ndambu ya nyangulilu yawu ya uhwadali. Vamanyili kucha vaveli pamu na Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lakini pavamuwonili yula mundu yivamlowulili Petili na Yohani vawoloka pamu na veni, vaweshili kudeta chindu ha. ");
INSERT INTO ndj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Vavalayishili vafumi panji ya chitemela, ili vakomi va chitemela vawombani kwa chifisu. ");
INSERT INTO ndj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Vakomi va chitemela vayidashili, “Tugoli wuli na vandu ava? Vandu vosi vayikala Yelusalemu vamanya muhilu awu wugolikili, yufwi tuweshi ng'odu kulema milandu ayi. ");
INSERT INTO ndj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lakini kugola milandu ayi yikotoo kukwila nesu kwa vandu, tuvakapushi vakotoo kulandula kwa mundu yoyosi litawa lya Yesu.” ");
INSERT INTO ndj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pambeli vavakema kandi munyumba, vavalayisha vakotoo kudeta na kuwula kwa litawa lya Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lakini Petili na Yohani vavayangula, “Mulamuli mwaveni choti chinofu tuvajumili yumwi awu Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwanongwa yufwi tuweshi ng'odu kuleka kudeta findu fila tufiwonili na kufipikanisha.” ");
INSERT INTO ndj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Vavaha va chitemela vavalakalila nendu, pambeli vavalekishela. Valemwa kuvapa asabu kwanongwa vandu vosi vaveli vakumjuma Chapanga kwanongwa ya chilongu achi. ");
INSERT INTO ndj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ayu mundu yagoliwili mihilu ya kulowuliwa aveli na myaka yasidili milongu mchechi. ");
INSERT INTO ndj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petili na Yohani pavavalekili vawuya kwa vayawu, vavahimulila fila fivawombili vatambika vakomi na vagogolu. ");
INSERT INTO ndj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Veni pavapikanishili filongu afi vajova pamu pavadadava kwa ndima yimu kwa Chapanga pavadeta, “Bambu, yuwi ugolili kumbindi na mlima, bahali na fyosi fivelili, ");
INSERT INTO ndj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","udetili kwa liwovi lya Mfuki Mng'alili mumlomu wa ndumindumi waku, mgogolu wetu Dawudi: Wuli vandu va mlima wosi vakwikalalila? Mbona vandu vagola milandu ya hela? ");
INSERT INTO ndj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Vatavala va mlima vayitanda kala, na vatavala vatanganikili pamu, kumlema Bambu mkombola yashauliwili. ");
INSERT INTO ndj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nakaka, Helodi na Ponsiu Pilatu na vandu va Isilaeli na vandu vangajila kuva Vayawudi vatanganikili mumbwani kumulimba Yesu ndumindumi Mng'alili amushaghili mafuta ghavi mkombola. ");
INSERT INTO ndj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Vagolili milandu yila wiyilatili kala dayigoleki kandi kwa uwesu na Udayilu waku. ");
INSERT INTO ndj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Deku, Bambu, uloli ndambu yivatukapusha ututangi vandumindumi vaku tulanduli chilongu chaku kwa chiganu. ");
INSERT INTO ndj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Woloshi liwoku lyaku ulowoli vandu tugoli filangushilu na filoja kwa litawa lya Yesu ndumindumi waku yang'alili.” ");
INSERT INTO ndj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pavamalili kudadava, pahala pala pavavelili vatanganikila patikanyika, vosi vaveli vamema Mfuki Mng'alili. Vosi vayendelela kutyanga pavalandula filongu fya Chapanga ngajila lyogha. ");
INSERT INTO ndj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Vosi yivamjumilili Chapanga vayiwonili vava moyu wumu na hoshu silinganili. Kwahela mundu yavelili na chindu achivikili chivi chaki weka, vavaghanili fila fivakamulili. ");
INSERT INTO ndj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Vandundami vatovilelili kwa liwovi likomi kushukuka kwa Bambu Yesu na Chapanga avapili usangi utangalili. ");
INSERT INTO ndj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kwahela mundu yapotili chindu, vamu yivaveli na fitava na nyumba shawu vahemesha vayegha mbiya sivapatili, ");
INSERT INTO ndj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mbiya asi shosi vavapili vandundami, vamgayilili kila mundu ndambu ya Udayilu waki. ");
INSERT INTO ndj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kwavelili Mlawi yumu, muwoneka wa Kupilu, litawa lyaki Yosefu, vandundami vaveli vakumukema Banabasi, mana yaki, “Mundu wa kuvakola mawoku vandu.” ");
INSERT INTO ndj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mweni wuwu aveli na chitava chaki pambeli kahemesha kandi katola mbiya sila, kavagayila vandundami. ");
INSERT INTO ndj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mundu yumu vamkemaya Ananiasi na mdala mundu Safila wuwula wula vahemishili chitava chawu. ");
INSERT INTO ndj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Lakini Ananiasi afisili mbiya simonga sivapatili na mdamundu amanyili. Mbiya sisighalili avagayilili vandundami. ");
INSERT INTO ndj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pambeli Petili kamudasha, “Ananiasi, kumleka Lijangavandu ayingili mumoyu waku kumujanga Mfuki Mng'alili kufisa mbiya simonga siupatili muchitava chila? ");
INSERT INTO ndj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pawuvelili ukali kuhemesha chitava chaveli chaku, pambeli pawuhemishili, mbiya sila shaveli sikali shaku. Wuli kandi kugola findu kucha afi? Kumjanga mundu ha, kumujanga Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiasi papikanishili naha kawa pasi, kasova. Vandu vosi yivapikanishili milandu ayi vatilili nendu. ");
INSERT INTO ndj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Vafijana vayisa, vagubika chikongu chaki, vachifumisha panji, vachisika. ");
INSERT INTO ndj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kucha masaa matatu pavapitili, mdala mundu ngajila kumanya chimfumbukili bambu mundu, kayingila mugati. ");
INSERT INTO ndj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petili amdashili, “Unongeli! Asi nakaka mbiya simupatili pamuhemishili chitava?” Mweni kamyangula, “Yina, sisesi.” ");
INSERT INTO ndj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pambeli Petili kamuwombela, “Kwaliki muyijanga kumuyesha Mfuki wa Bambu? Pikani! Vala vandu vayendili kumusika bambu waku, ponopa vava pamlyangu na davakutoli na yuwi wuwu.” ");
INSERT INTO ndj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tepu Safila kawila pamawulu va Petili, kasova. Vafijana vala pavayingilili vamuwona kasova kala, vamufumisha panji, vamsika pabehi na bambu mundu. ");
INSERT INTO ndj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chipwembwi chikomi chivakamula vandu vosi yivajumilili na vandu vala vosi yivapikanishili milandu ayi. ");
INSERT INTO ndj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Vandundami vagolili mihilu na miwujawuja yitangalili kwa vandu. Vajumilili vaveli vakutang'anikila pamu muudamwa wa Solumoni. ");
INSERT INTO ndj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mundu yangajila kujumila atilili kuva pamu na veni. Hata naha, vandu vamonga vangajila kuvajumila vavajuma. ");
INSERT INTO ndj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Vandu vatangalili vamjumilili Bambu, valumi na vadala vayongishekili mulipinga lyau. ");
INSERT INTO ndj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Vandu vavelili vakuyegha vatami mudeha vavawonjesha mufiwonjelu na mitefu ili pakapita livafiki lisisi lya Petili pambeli vanani. ");
INSERT INTO ndj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Vandu vatangalili vafumili mbwani shiveli pabehi ya Yelusalemu, yivavayeghili vatami vawu na vala yivaveli na finyamkela, vosi valowuliwa. ");
INSERT INTO ndj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pambeli, Mtambika Mkomi na vala vaveli lighanja muchipinga cha Masadukayu va pala, vavawonela weyi vandundami. ");
INSERT INTO ndj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Vavakamula vandundami, vavataya muchijaka. ");
INSERT INTO ndj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lakini pamihi makungu wa Bambu kavafuwulila milyangu ya chijaka, kavafumisha panji, kavawombela, ");
INSERT INTO ndj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Muyendi mukawoloki munyumba ya Chapanga, mkavawombeli vandu filongu fyosi fya unofu awu.” ");
INSERT INTO ndj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Vandundami vavayitikila, malavila puti vayingila munyumba ya Chapanga, vakandili kuwula. Mtambika mkomi na vavaha va Isilaeli vagolili chitemela, pambeli vavalayishila vandu vakavayeghi vala vandumindumi kufuma kuchijaka. ");
INSERT INTO ndj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lakini vala vandumindumi pavafikili kula vavawona ha mula muchijaka. Vawuya kuchitemela kuvawombela, ");
INSERT INTO ndj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tuwona chijaka chitatiwa milyangu yosi na machonda vakulolela milyangu. Lakini patufuwulili mugati tumuwona mundu ha!” ");
INSERT INTO ndj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mkomi wa machonda munyumba ya Chapanga na vatambika vakomi pavapikanishili milandu ayi vapatili lyogha. Vamanyili ng'odu chivafumbukili vandundami. ");
INSERT INTO ndj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pambeli mundu yumu ayisili, kuvawombela, “Mpikani! vala vandu muvatatilili muchijaka, ponopa vakuwula vandu munyumba ya Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mkomi wa machonda wa nyumba ya kudadavila pamu na vandu vaki vayendili munyumba ya Chapanga, kavayegha kuchitemela. Lakini vavakamulili kwa liwovi ha, nongwa vakavatileyi vandu vangavagumili migonguveli veni. ");
INSERT INTO ndj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pavavayeghili, vavawolosha pawulongolu ya chitemela. Mtambika mkomi avadashili, ");
INSERT INTO ndj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Twavakanishili nendu kuwula kwa litawa lya mundu ayu, ponopa mukwisha mawuli venu Yelusalemu yosi na mukuyilata kutugayila nongwa ya mwasi wa mundu ayu.” ");
INSERT INTO ndj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petili, pamu na vala vandundami vamonga, vayangula, “Yikutulata tumjumili Chapanga weka, lakini mundu tukumjumila ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yumwi mwamuwulayili Yesu kwa kumuvangilila mulupingika lakini Chapanga wa vagogolu venu amshukushili. ");
INSERT INTO ndj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Chapanga amgayilili fwasi ya wutwa kumbindi, kamvika mwambu waki wa mlilu, kava mutwa na Mlowola, kuvagola vandu va Isilaeli vasileki sambi shawu na vapomeliwi. ");
INSERT INTO ndj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yufwi ndi vatovilela va filongu afi. Chapanga avagayilili Mfuki Mng'alili ghavi mtovilela kwa vala yivamjumilili.” ");
INSERT INTO ndj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Vanjagila vosi va chila chitemela pavapikanishili afi, maya sivakwila, valamula kuvawulagha. ");
INSERT INTO ndj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lakini Mfwalisayu yumu vamukemeyi Gamalieli mweni avelili muwula wa Malawu va Chapanga vamupili Musa aveli na luhunja nendu kupita vandu vosi, kawoloka pawulongolu ya chitemela chila, kavawombela vala vandundami vavafumishi panji kwa chipindi chidokwa. ");
INSERT INTO ndj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pambeli kavawombela vala vanjagila va chitemela, “Vaisilaeli vayangu, muyivavali na chindu achi chimudayila kuvagolela vandu ava! ");
INSERT INTO ndj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dahili padokwa, afumbukili mundu yumu litawa lyaki Teuda, ayidumbeyi kucha mweni mundu yajumiliwi na vandu mya mchechi naha, vamukovekelili. Lakini vamuwulaghili, pambeli chipinga chaki chosi chimwaaluka pambeli chisova. ");
INSERT INTO ndj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pambeli kandi, chipindi chila cha kuvalangiwa vandu, afumbukili Yuda wa Galilaya. Na mweni avakweyili vandu vamukovekela, lakini wuwu vamuwulayili na vandu vaki vayangalukili. ");
INSERT INTO ndj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hinapawu nenga wuwu nguvawombela, muvaleki vandu ava mukotoo kuvagola chindu! Mana payiva milandu ayi ya vandu hela, dayiyamili yeni. ");
INSERT INTO ndj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lakini payiva milandu kufuma kwa Chapanga, damuwesi ng'odu kulimbana na veni, damuvi mukulimbana na Chapanga.” Topi, vamujumila. ");
INSERT INTO ndj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Vavakemili vala vandundami, vavadamula ndomondu na kuvakanisha vakotoo kuwula kandi kwa litawa lya Yesu, pambeli vavaleka vayendi. ");
INSERT INTO ndj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Vandundami vafumili panji ya chitemela kunu vamema cheleli, kwanongwa vaveli vataywa musoni kwa litawa lya Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Majuva vosi vayendilela kuwula na kulandula Chilongu cha Nyanyi cha Yesu munyumba sha Chapanga na mukaya sha vandu kucha Yesu ndi Kilistu yashauliwili. ");
INSERT INTO ndj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pambeli, vanachuli pavayongishekeyi, kwaveli na shoshu na ng'ong'u gati ya vangutungu na vala yivaywangeyi Chibulaniya. Vala Vahelinisti yivaywangeyi Chigiliki vakang'ong'utekileyi kucha vangalimlyangu vawu vakuvavasuwa kuvagayila fivayilata fya majuva vosi. ");
INSERT INTO ndj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Topi, vala vandundami lilongu na vavili vavakemili vanachuli vosi, vadeta, “Nyanyi ha kwa yufwi tuleki kuchilandula chilongu cha Chapanga na kukimbanikila uvaghi wa filivi. ");
INSERT INTO ndj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ponopa, valongu vangu, muvashawula vandu saba kwa yumwi yivavelili nyanyi, vamemili Mfuki na yivaveli na luhunja na yufwi datuvapikanisheyi veni. ");
INSERT INTO ndj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yufwi, chipindi chosi datukimbanikili kudadava na chichuku cha kulandula Chilongu cha Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chindochi chivanowesha vandu vosi. Vavashawula Stefwani, mundu yavelili na ujumilwa mkomi na kumema Mfuki Mng'alili. Kandi vavashawulili Filipu na Pulokolu na Nikanoli na Timona na Pamena pamu na Nikolayi wa Antiyokiya yavelili chipindi chimu aghalambukilili mudini ya Chiyawudi. ");
INSERT INTO ndj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Vavavika pawulongolu ya vandundami, vadadava na kuvavikila mawoku. ");
INSERT INTO ndj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Chilongu cha Chapanga chayongishekili nendu na vanachuli aku Yelusalemu vayongishekili kalopu na lipinga likomi lya vatambika vamjumilili Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Chapanga amusangilili Stefwani usangi ngenju, kamugayila liwovi likomi aveli akugola mihilu na miwujawuja kwa vandu. ");
INSERT INTO ndj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lakini vandu vamonga vayisili ili valimbani na Stefwani. Vamu va vandu ava vaveli va nyumba ya kudadavila yivayikemaya, “Nyumba ya kudadavila ya vandu yivavelili pekesu.” Vandova vafumili mlima wa Kileni na Alekisandilia na vamonga vafumili Kilikiya na mkowa wa Asia. ");
INSERT INTO ndj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lakini vaweshili ha kumulimba kwanongwa ya luhunja lwaki na kwanongwa ya yula Mfuki yamulongushili chipindi padeteyi. ");
INSERT INTO ndj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Topi, vavapili nganyanga vandu vamonga vadeti, “Vamupikanisha Stefwani padeta filongu fya kumjowola Musa na kumjowola Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwa chilongu achi vavajongishela vandu, vagogolu na vawula va Malawu va Chapanga vamupili Musa. Topi, vamwisila Stefwani, vamukamula na kumuyegha kuchitemela chikomi. ");
INSERT INTO ndj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Vavayeghili kuchitemela vatovilela va udesi veni vawombili, “Mundu ayu akuleka ha kupajowola mahali pang'alili na Malawu va Chapanga vamupili Musa. ");
INSERT INTO ndj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kwa nongwa twamupikanishili kala padeta kucha ayu Yesu wa Nasaleti dayanangi nendu nyumba ya kudadavila na kughalambula Malawu va Chapanga vamupili Musa vatuyangili kwa Musa.” ");
INSERT INTO ndj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Vandu vosi yivavelili mula muchitemela vamuwengulila mesu Stefwani, vamuwona wushu waki wuva kucha wa makungu. ");
INSERT INTO ndj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Topi, mtambika mkomi amudashili, “Wuli, milandu ayi yiva nakaka?” ");
INSERT INTO ndj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefwani amuyangulili, “Valongu vangu na vatati, mumbikanishi! Chapanga wa ukomi amubwitikili mgogolu wetu Ibulahimu paghaveyi kula Mesopotamia akali hela kuyenda kuyikala kula Halani. ");
INSERT INTO ndj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chapanga amuwombilili, ‘Wuki mumlima waku, valeki vandu vaku, uyendi mlima danikulangushi!’ ");
INSERT INTO ndj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ibulahimu ahamili mlima wa Kalidayu, kayenda kuyikala Halani. Pambeli tati wa Ibulahimu pasovili, Chapanga amuwushili Halani kayisa kuyikala mlima awu wumuyikala ponopa. ");
INSERT INTO ndj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chapanga amugayilili ng'odu hata chipandi chidokwa cha uganga chivi chaki kucha mbala yaki mumlima awu, hata naha vamujangili kumupa mlima wula wuvi waki na vana vaki, chipindi achi aveli akali na mwana ha. ");
INSERT INTO ndj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Chapanga amuwombilili naha, ‘Chileli chaku dawuchiyeghi kumlima wa wutwa va vandu vengi, aku davavagoli vavanda na kuvagolela milandu ya wafu kwa chipindi cha myaka mya mchechi. ");
INSERT INTO ndj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lakini nenga dandivahighi vandu ava yivavagola vavanda. Pambeli chileli chaku dachiyisi mulima wula kumjuma Chapanga bahapa.’ ");
INSERT INTO ndj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Chapanga kagola lilaghanu na mweni, topi, kamwingisha jandu ngimu chilangushilu chaki. Pambeli Ibulahimu amudumulili jandu mwana mundu Isaka pavapitili majuva nani kufuma awoneki. Isaka wuwula wula kamugolela Yakobi. Na mweni Yakobi kavagolela wuwula wula vala vanamundu lilongu na vavili veni vaveli vambuyi vetu. ");
INSERT INTO ndj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Vana va Yakobi vamuwonela weyi Yosefu, vamuhemesha Misili ghavi mvanda. Lakini Chapanga aveli pamu na mweni, ");
INSERT INTO ndj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kamulowosha mungondu shaki shosi. Chapanga amugayilili fupu na luhunja pawulongolu ya Fwalawu, mutwa wa Misili, mweni amuvikili ghavi mkomi wa mlima wa Misili na munyumba yaki ya wutwa. ");
INSERT INTO ndj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pambeli kwafumbukili njala ngomi mlima wosi wa Misili na Kanaani, yiyegha madaba makomi. Vagogolu vetu vaveli vahela chilivi chochosi. ");
INSERT INTO ndj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobi papikanishili filongu fila kucha aku Misili kwaveli na filivi, avalayishili vana vaki, ndi vagogolu vetu, vayendi Misili kwa mwanja wa kwaa. ");
INSERT INTO ndj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mwanja awu wa pili, Yosefu kayilangusha kwa valongu vaki na Fwalawu kavamanya valongu va Yosefu. ");
INSERT INTO ndj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosefu alayishili lulayi layi kwa tati mundu Yakobi na valongu vosi, tolitoli ya vandu yaveli milongu saba na muhanu, vayisi Misili. ");
INSERT INTO ndj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Topi Yakobi ayendili Misili, kula mweni na vanamundu vosi vasovili. ");
INSERT INTO ndj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Fikongu fyawu vafiyeghili mbaka Shekemu, vafisika musembi yahemilili Ibulahimu wa kabila lya Amoli kwa mbiya siutunga. ");
INSERT INTO ndj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Chipindi pachifikili Chapanga agoli chila chamjangili Ibulahimu na tolitoli ya vandu kula Misili yayongishekili kala na kuva ngomi munu. ");
INSERT INTO ndj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pambeli mutwa yumu yavelili kamumanya ng'odu Yosefu akandili kutavala aku Misili. ");
INSERT INTO ndj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Awugolilili vandu va mlima wetu umakuluhu, avagolilili findu fya wafu vagogolu vetu kwa kuvang'ang'anika vavaviki panji fyali fyawu fisovi. ");
INSERT INTO ndj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Musa awonikili chipindechi. Avelili mwana yamunowishili Chapanga. Aleliwili pakaya kwa chipindi cha myesi mitatu, ");
INSERT INTO ndj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na pafumishiwili panji awulaghiwi, kamwali wa Fwalawu amutolili, kamulela kucha mwana mundu. ");
INSERT INTO ndj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa awuliwili findu fyosi fya luhunja lwa Vamisili kava mundu yaveli na liwovi kwa filongu na kwa figoli. ");
INSERT INTO ndj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pafikishili myaka milongu muchechi alamulili kuvatyangila valongu vaki Vayisilaeli. ");
INSERT INTO ndj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aku amuwonili yumu wa vala vakumgolela fya wafu na Vamisili, kayenda kumukombola kandi kumuhombela lugotu kwa kumuwulagha yula Mumisili. ");
INSERT INTO ndj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Akacheyi Vayisilaeli vayaki vangamanyili kucha Chapanga angamutumili mweni avalowoli, lakini vamanyili nawula ha. ");
INSERT INTO ndj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chilawu yaki, avawonili Vayisilaeli vavili vakwiminya ayeshili kuvajovesha padeta, ‘Yumwi muva ulongu nongwa liki, mukuyigolela wafu mwaveni kwa mwaveni?’ ");
INSERT INTO ndj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yula yaghaveyi akumutova muyaki kamusukumula Musa pambali padeta: ‘Ndi yakuvikili yuwi kuva chilongosi na muhigha wetu? ");
INSERT INTO ndj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wuli, ukudayila kung'ulaya kucha wumuwulaghili Mumisili yula lichu?’ ");
INSERT INTO ndj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa papikanishili filongu fila, atuvili kayenda kuyikala mumlima wa Midiani aku apatili vana valumi vavili. ");
INSERT INTO ndj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Myaka milongu mchechi payifikili, makungu wa Bambu amufumbukili Musa kuchivala chivelili chikuyaka motu kucheja pabehi na chidunda cha Sinai. ");
INSERT INTO ndj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa kajinga munu kuwona chindu achi, kaselela pabehi ili ashungulili unofu, lakini apikanishili lishu lya Bambu: ");
INSERT INTO ndj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nenga Chapanga wa vambuyi vaku, Chapanga wa Ibulahimu wa Isaka wa Yakobi!’ Musa kabagama kwa lyogha na kayesha kandi ha kulembesha munu. ");
INSERT INTO ndj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bambu kamuwombela, ‘Wopoli mikobasi yaku kwanongwa pawuwolukili apa ndi mahali pang'alili. ");
INSERT INTO ndj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nakaka ndifiwona findu fya wafu fivagolili vandu vangu kula Misili. Mbikanisha chivembu chawu, nenga nyisa kuvakombola. Ponopa, dandikuyeghi Misili.’ ");
INSERT INTO ndj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ayu Musa ndi yula vandu va Isilaeli vamulemili pavadeteyi, ‘ghani yakuvikili yuwi kuva mlongosha na muhighi wetu?’ Kwa deha ya yula makungu yamufumbukilili kuchivala chikayakeyi motu, Chapanga kamulayisha ayu Musa ghavi mkomi na mukombola. ");
INSERT INTO ndj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mweni avalongushili vala vandu kufuma Misili kwa kugola mihilu na miwujawuja mulima wa Misili, kubahali ya Shamu na kucheja, chipindi cha myaka milongu mchechi. ");
INSERT INTO ndj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa mweni avawombilili Vayisilaeli, ‘Chapanga davashawulili mbuyi kucha nenga gati ya valongu venu vamonga.’ ");
INSERT INTO ndj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Vayisilaeli pavayikungashili kucheja, Musa avelili kula kucha munjagila pamu na vagogolu vetu na yula makungu aywangili nayu kuchidunda cha Sinai. Mweni yayangili filongu fitugayila unofu atugayili yufwi. ");
INSERT INTO ndj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lakini yuyu, vagogolu vetu valemili kumupikanisha, vamusukumulila pambali, vakadayileyi kuwuya Misili. ");
INSERT INTO ndj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Vamuwombilili Haluni, ‘Tugoleli vamulungu, vatulongoshi njila. Tumanya ng'odu fimupatili ayu Musa yatulongushili kufuma Misili.’ ");
INSERT INTO ndj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Vagola ling'omung'omu lya ngwada wa senga na kuchitambikila. Vachigolela lihungu chindu chivelili vagola kwa mawoku vawu veni. ");
INSERT INTO ndj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lakini Chapanga awukili pagati yawu, avalekili vajumi ndondwa sha kumbindi, kucha vayandikili muchitabu cha vambuyi va Chapanga, ‘Yumwi vandu va Isilaeli! Nenga ha mungayilili fupu na tambiku kwa myaka milongu mchechi kula kucheja! ");
INSERT INTO ndj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yumwi mwapapili libudi lya chapanga Moleki, na ndondwa ya kuwumba ya chapanga wenu Lefani. Ming'omung'omu yimuwumbili yeni mukuvajuma. Kwanongwa ayi, dandivayeyi mateka kutali kupita Babiloni!’ ");
INSERT INTO ndj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Kula kucheja vagogolu vetu vavelili na lila Libudi lya utovileli kucha Chapanga amulayishili Musa aligoli, ndambu yiyila yamulangushili Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pambeli valipokela lila Libudi lya Chapanga kufuma kwa vambuyi vawu. Valeli vetu chipindi cha Yoshua, pavawutolili mlima wula kufuma kwa vandu avawushili Chapanga ngimu yiva fikili. Pala vayikalili mbaka chipindi cha wutwa wa Dawudi. ");
INSERT INTO ndj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawudi atamwili na Chapanga, Dawudi amuluvili Chapanga amujengeli pakwikala mweni avelili Chapanga wa Yakobi. ");
INSERT INTO ndj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lakini Solumoni ndi yamujengilili Chapanga nyumba. ");
INSERT INTO ndj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Hata naha, Chapanga Mkomi akwikalagha ha munyumba shivajengili vandu, kucha mbuyi adetili. ");
INSERT INTO ndj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bambu kadeta, Kumbindi chigoda changu cha wutwa na mlima chigoda changu cha kuvikila mawulu. Nyumba ya wuli wuli damuweshi kujengela na koti dambumulileyi? ");
INSERT INTO ndj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nenga ndi yigolili findu fyosi afi ng'odu?’ ” ");
INSERT INTO ndj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pambeli Stefwani awombili, “Yumwi muveli na lukilu lukomi! Mundima na majeji venu mukupikanisha ng'odu unjagila wa Chapanga! Yumwi kucha vagogolu venu. Majuva vosi mkumulimba Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kwaveli mbuyi yoyosi yangajila kuteshiwa na vagogolu vawu? Vavawulayili ava avatumili Chapanga kulandula kwisa kwa yula goleki. Hinapawu, yumwi mumushengeta, mumuwulaya. ");
INSERT INTO ndj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yumwi muvapokela Malawu va Chapanga atuyeyilili makungu, lakini muvajumila ng'odu.” ");
INSERT INTO ndj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Vala vagogolu va chitemela pavapikanishili afi, vakalalili nendu, vakelichula minu kwa maya. ");
INSERT INTO ndj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lakini Stefwani aveli kamema Mfuki Mng'alili, kalola kumbindi, kawona ukomi wa Chapanga na Yesu kawoloka mwambu wa mlilu wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kadeta, “Mloli! Nguwona kumbindi kufuwuliwa na Mwana wa Mundu kawoloka mwambu wa mlilu wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pala, vandu vosi vavelili muchitemela chila, vawuteyi na kudika majeji vawu kwa mawoku vawu. Pambeli vamujumbila pamu vosi. ");
INSERT INTO ndj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Vamsukumulila panji ya mbwani, vamutova kwa miganga. Vala vavikili mikoti yawu kwa utovilela kwa kijana yumu litawa lyaki Sauli. ");
INSERT INTO ndj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pavaveli vakumtovanga kwa miganga Stefwani kayendelela kudadava naha, “Bambu Yesu, pokeli ufuki wangu!” ");
INSERT INTO ndj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Katundama, kalila kwa kulandula, “Bambu, ukotoo kuvavalangila sambi ayi.” Pamalilili kudeta naha, kasova. ");
INSERT INTO ndj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauli mweni awonili chindu achi cha kumuwulagha Stefwani chaveli chinofu. Majuva ava lipinga lya vandu yivamjumilili Kilistu lya Yelusalemu lyakandili kugoboliwa nendu. Yivajumilili vosi vatuvila kufijiji fya Yudeya na Samaliya ila vasiyalili vala vandundami hela. ");
INSERT INTO ndj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Vandu vasangi vamusikili Stefwani na kumugolela chivembu chikomi. ");
INSERT INTO ndj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Chipindi chichila chila, Sauli ayeshili kuvagobola lipinga lya vandu yivamjumilili Kilistu. Kayenda kaya mbaka kaya pakavafumisha panji vajumilili, valumi na vadala, kavataya muchijaka. ");
INSERT INTO ndj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Vamjumilili Chapanga kula kosi kwevatuvilili vayendili kulandula chilongu cha nyanyi. ");
INSERT INTO ndj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipu ayingilili mbwani ya Samaliya na kumulandula Kilistu Mkombola kwa venikaya va pala. ");
INSERT INTO ndj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Vandu vayisili kupikanisha unofu wa unjagila wula wa Filipu na kulola mihilu yila yagolagha. ");
INSERT INTO ndj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mana finyamkela fivafuma vandu vatangalili pavawuta kwa lishu likomi nawu vandu vatangalili vaveli vapombalili na vandevindevi valowukili. ");
INSERT INTO ndj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kwaveli na cheleli ngomi mumbwani yila. ");
INSERT INTO ndj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Topi, kwavelili mundu yumu vamukemaya Simoni, mweni aveli kagola kala uhavi waki mumbwani yila kwa chipindi chila, vandu va Samaliya vajingili, adetili kucha mweni mundu mkomi. ");
INSERT INTO ndj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Vandu vosi, vadokwa na vakomi, vamupikinishili finofu vakadeteyi, “Simoni kana liwovi lya Chapanga vakemili ‘Liwovi Likomi.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vandu vatangalili vampikanishili wula vavelili vajingwa kwa uhavi waki kwa chipindi chitali. ");
INSERT INTO ndj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lakini pavawujumilili unjagila wa Filipu wa chilongu cha nyanyi cha wutwa wa kumbindi kwa Chapanga na litawa lya Yesu Kilistu, vabatishilwi valumi na vadala. ");
INSERT INTO ndj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni nayu kajumila, pambeli pabatishiwi aveli akuyenda pamu na Filipu, ayikang'anikili nendu mihilu na miwujawuja yiveli yikugoleka. ");
INSERT INTO ndj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Vala vandundami vavelili kula Yelusalemu pavapikanishili kucha venikaya va Samaliya veni vapokela chilongu cha Chapanga, vavayegha aku Petili na Yohani. ");
INSERT INTO ndj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Veni pavayisili, vavadadavila vandu va Chapanga vamuyangi Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kwanongwa kwaveli kwahela hata muyawu yumu yasunukiwili na Mfuki Mng'alili, ila vabatishwa hela kwa litawa lyaki Bambu Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petili na Yohani vavavikila mawoku, vamupokela Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni pakawonili vandu vapokela Mfuki Mng'alili kwa kuvikilwa mawoku na vandundami, adayilili kuvagayila mbiya Petili na Yohani, kandi kadeta, ");
INSERT INTO ndj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Mungayili na nenga uwesu awu, mundu yoyosi panumuvikila mawoku vangu, apokeli Mfuki Mng'alili.” ");
INSERT INTO ndj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lakini Petili amuyangulili, “Uyaghamili pamu na mbiya shaku muyaghamili! Yuwi ukucha dauweshi kuhemela kwa mbiya usangi wa Chapanga! ");
INSERT INTO ndj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yuwi kwahela chindu mumilandu ayi, ngunda yaku ya nyanyi ng'odu kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hinapawu, pomeli ughalambuki uleki chiuyihola na umuluvi Bambu mweni akuwesha kukupomela chilongu achi chiwuyihola. ");
INSERT INTO ndj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Manya nakaka kumema nesu weyi na sambi sikutopela!” ");
INSERT INTO ndj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni kayangula, “Mudadavili kwa Bambu likotoo kumbata lya kumbata kwa afi fimudetili.” ");
INSERT INTO ndj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petili na Yohani pavahimulili kala na kulandula fyalayilili Bambu, vawuyili Yelusalemu. Pavaveghi vakuwuya vakalanduleyi milandu ya nyanyi mufijiji fitangalili fya Samaliya. ");
INSERT INTO ndj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Makungu wa Bambu amuwombilili Filipu, “Uyitandi uyendi kundenyeku kupitila deha yifuma Yelusalemu kuyenda Gaza.” Deha ayi vakutyangila ha. ");
INSERT INTO ndj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Topi, Filipu ayitandili kala, akandili mwanja. Chipindi chichila kwavelili na Mwisopiya yumu, ufisa mvika mbiya wa Muhumbu Kandake, mweni aveli ngali mdala. Avelili kayenda aku Yelusalemu kumudadavila Chapanga na chipindi achi aveli akuwuya kakwela mumbutuka ya kukwegha na chihongu. ");
INSERT INTO ndj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Paaveyi mumwanja, avelili akusoma chitabu cha mbuyi wa Chapanga Isaya. ");
INSERT INTO ndj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mfuki Mng'alili amuwombilili Filipu, “Yendi pabehi ya mbutuka ayi uyendi pamu.” ");
INSERT INTO ndj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipu kayenda mbilu, kampikanisha akusoma chitabu cha mbuyi wa Chapanga Isaya. Filipu kamudasha, “Afi fiwusoma fikuyingila muluhala lwaku?” ");
INSERT INTO ndj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kayangula, “Goli wuliwuli chinyingili ngajila mundu wa kunongosha?” Kamuluva Filipu akweni vayikali pamu na mweni. ");
INSERT INTO ndj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Chifungu cha mayandiku avelili akusoma ndi achi, “Kalongoshwa kucha fungami akuyenda kumsinja, na kucha wula mwana wa fungami panyamala kwa yula yamuketula miwaji, mweni akudawula ng'odu mlomu. ");
INSERT INTO ndj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Vamujohola na kumukaja haki. Ndi dahimulili chileli chaki? Mana unofu waki kawushiwa kumlima.” ");
INSERT INTO ndj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yula ngali mdala kamudasha Filipu, “Unongeli, mbuyi ayu filongu afi akadeteyi milandu liki, ndi milandu ya mweni awu ya mundu wingi?” ");
INSERT INTO ndj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Topi, Filipu akandili na Mayandiku Vang'alili, kamuwombela Chilongu cha Nyanyi cha Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pavaveyi mumwanja, vafikili pavelili na machi, yula ngali mdala adetili, “Loli, pavaveli machi ava, chindu liki chikunganisha ngotoo kubatishiwa?” ");
INSERT INTO ndj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipu kadeta, “Mani pawujumila kwa moyu waku wonda, ukuwesha kubatishiwa.” Kayangula, “Yina ngujumila Yesu Kilistu ndi mwana wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Topi kawolosha mbutuka, pambeli vasunuka vonda vavili vayenda mumachi, Filipu amubatishili. ");
INSERT INTO ndj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pavafumili mumachi, Mfuki wa Bambu kamubikula Filipu, yula ngali mdala kamuwona kandi ha. Topi kayendelela na mwanja kunu kava na cheleli buja. ");
INSERT INTO ndj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipu kayiwona kabwitukila mbwani ya Azotu, paaveyi akupita akalanduleyi Chilongu cha Nyanyi mumbwani shosi, mbaka pafikili Kayisalia. ");
INSERT INTO ndj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lakini Sauli, kayongesha kuvagola vandu vatili na kuvawulagha vandundami va Bambu, kamuyendela mtambika mkomi, ");
INSERT INTO ndj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","akamluveyi baluwa kufuma munyumba sha kudadavila sha Damasku, pakatanganika na vandu vamujumilili Chapanga mudeha valumi kwa vadala avakamuli avayeghi muchijaka aku Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tepu paaveyi mudeha, pabehi ya Damasku, lwengi kufuma kumbindi lumng'alikili kumshengeta mweni. ");
INSERT INTO ndj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kagua pasi, kapikana lishu likumuwombela “Sauli, Sauli! Wuli ukugobola nenga?” ");
INSERT INTO ndj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli kamudasha, “Bambu, Yuwi ghani?” Kamuyangula, “Nenga Yesu, yugobola. ");
INSERT INTO ndj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ponopa woloki, uyendi mumbwani, davakuwombeli chindu cha kugola.” ");
INSERT INTO ndj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Vala vandu yivaveli pamu na Sauli mumwanja vanyamalili jii, vakapikanisheyi lishu, lakini vamuwonili mundu ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli atandamukili pasi agubutulili mesu vaki kachiwona chindu ha, vamukamula liwoku vamlongosha mbaka Damasku. ");
INSERT INTO ndj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ayikalili majuva matatu ngajila kulola, kulanda na kulya chindu. ");
INSERT INTO ndj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Paaveyi Damasku ndundami yumu yivamkemili Ananiasi. Bambu amukemili mumilotu, “Ananiasi!” Kayangula, “Nengapa, Bambu.” ");
INSERT INTO ndj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bambu amuwombilili, “Woloki, uyendi deha yivayikema ‘Yiholukili,’ mbaka kaya ya Yuda, kuna mundu litawa lyaki Sauli, kafuma Talisu, mweni akumdadavila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Chapanga amulanushili kucha mundu yumu litawa lyaki Ananiasi, kayisa kumuvikila mawoku, aweshi kulola kandi.” ");
INSERT INTO ndj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiasi kayangula, “Bambu, mbikanisha filongu fya wafu fya mundu ayu kufuma kwa vandu vatangalili, kagola findu fitangalili kwa vang'alili vaku aku Yelusalemu, ");
INSERT INTO ndj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","kandi vatambika vakomi va Damasku vamjumisha avakamuli vonda yivakudadavila mulitawa lyaku.” ");
INSERT INTO ndj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lakini Bambu kamuwombela Ananiasi, “Uyendi, nongwa ayu ndimushawula andangi nenga kulilandula litawa lyangu limanyiki kwa vandu vangajila Vayawudi, vatwa na vandu va Isilaeli. ");
INSERT INTO ndj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kandi dandimulangushi ndambu dagoboleki kwanongwa ya litawa lyangu.” ");
INSERT INTO ndj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiasi ayendili munyumba yila, kayingila mugati mwavelili Sauli, pambeli kamuvikila mawoku, pakadeta, “Mlongu wangu Sauli, Bambu Yesu kanayila, yakufumbukilili mudeha pawuyiseyi apa, mweni yanyeyili nenga apa, akudayila uloli kandi na umemeshwi Mfuki Mng'alili.” ");
INSERT INTO ndj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tepu fiponeka kufuma mumesu vaki kucha mipati ya somba, kawesha kulola kandi. Kawoloka na kubatishiwa. ");
INSERT INTO ndj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pambeli kalya filivi, liwovi limuwuyila kandi. Sauli ayikalili Damasku na vanachuli vaki padokwa hela. ");
INSERT INTO ndj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tepu, kalongosha kulandula munyumba sha kudadavila kacha Yesu aveli Mwana wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Vosi vamupikanisheyi vajinga, pavayidasha, “Ayu yuyula yula ng'odu avawulayei vandu vosi vamujumilili Yesu aku Yelusalemu? Na mweni kayisa apa kayilata avakamuli vandu vosi ng'odu na avayeghi kwa vatambika vakomi va nyumba ya kudadavila.” ");
INSERT INTO ndj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauli ayongeshikili liwovi nendu, avagolili Vayawudi vavelili Damasku vayipwelishili, padeta ayu ndi Kilistu yaveli mkombola. ");
INSERT INTO ndj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pavapitili majuva vatangalili, Vayawudi vawombanila ndambu davamuwulaghi Sauli, ");
INSERT INTO ndj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","lakini Sauli amanyili chivayilatili. Pamusi na pamihi vakamulembeleleyi mumilyangu ya mbwani vamuwulaghi. ");
INSERT INTO ndj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pamihi vanachuli yivaveli pamu na Pauli vamtolili vamusunusha mulitandavala likomi kufuma mulilanga lya luviu lwa mbwani. ");
INSERT INTO ndj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli pafikili Yelusalemu, ayeshili kuyihasha na vandundami, vosi vakamutileyi, vajumilili ng'odu kucha nakaka kava ndundami. ");
INSERT INTO ndj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Banabasi amutolili, kamuyegha kwa vandundami, Sauli avawombilili ndambu atanganikili na Bambu mudeha, kandi Bambu aywangili na mweni na ndambu akalanduleyi litawa lya Yesu kula Damasku kwa liwovi. ");
INSERT INTO ndj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sauli ayikalili pamu na veni na kuyendayenda Yelusalemu yosi, palandula litawa lya Yesu ngajila lyova. ");
INSERT INTO ndj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Awombili palimbana na vangutungu va Vayawudi, lakini veni vasakeyi kumuwulagha. ");
INSERT INTO ndj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lakini valongu pavamanyili milandu ya kumuwulagha vamutolili mbaka mbwani ya Kayisalia, vamuleka ayendi Talisu. ");
INSERT INTO ndj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Topi, Vajumilwa vaveli vasika mu Yudeya yosi, Galilaya na Samaliya, Mfuki Mng'alili atangili kuyongesha lipinga lya vandu yivamjumilili Kilistu na vayikalili pavamtila Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petili pavatyangileyi mbembi shosi mumlima, mweni ayendili kwa vandu va Chapanga va aku Lida. ");
INSERT INTO ndj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Amuwonili mundu yumu aku, litawa lyaki Anea mundu ayu apombalili awonjili muchiwonjelu myaka minani. ");
INSERT INTO ndj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petili amuwombilili, “Anea, Yesu Kilistu kakulowola, wuki unyengi chiwonjelu chaku.” Tepu katandamuka. ");
INSERT INTO ndj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Vandu vosi vayikalaya Lida na Shaloni pavamuwonili Anea, vamuwuyilila Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ndumindumi yumu avelili Yopa, yivamkemeyi Tabita, mana yaki kucha “Mbalapi” yajumilili vamkemaya Dokasi kwa Chigiliki. Mdala ayu avelili kagola findu fitangalili fya nyanyi pamu na kuvatanga vagaju. ");
INSERT INTO ndj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chipindi chila mdala yula atamwili na kusova, vawofuwili chikongu chaki vachivikili muchumbagati cha mumbindi. ");
INSERT INTO ndj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa yavelili kutali nesu ha na Lida, vanachuli vapikanishili Petili kava kula, valayisha vandu vavili vamuyegheli unjagila, “Lopukeshi ukotoo kuhava!” ");
INSERT INTO ndj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petili kawuka kayilongosha na veni, pakafikili vamuyegha kuchumba cha mumbindi, vangalimlyangu vosi vawolukili pabehi yaki, vakalileyi na kumulangusha mihabiti na yingwa shasonili Dokasi chipindi paveli mnofu. ");
INSERT INTO ndj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petili kavafumisha panji vosi, katundama, kamdadava Chapanga, pambeli kaselela kuchikongu, kadeta, “Tabita yimuki.” Mweni kafumbula mesu vaki, amuwonili Petili kayimuka kayikala. ");
INSERT INTO ndj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kamkamula liwoku kawoloka, pambeli kavakema vamjumilili Yesu na vangalimlyangu kamuvika pawulongolu yawu, kava munofu. ");
INSERT INTO ndj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Milandu ayi yamanyikili mumbwani yosi ya Yopa, vandu vatangalili vamujumilili Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Topi, Petili ayikalili Yopa majuva vatangalili, kayaki mundu yumu, litawa lyaki Simoni, yagolagha findu fya ngwembi. ");
INSERT INTO ndj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kula Kayisalia pavelili mundu yumu, litawa lyaki Kolineli, mkomi wa machonda va Italiya yivayikemili, “Kombaniya ya Vaitalia.” ");
INSERT INTO ndj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Avelili mundu msangi, mweni na nyumba yaki yosi, akovekelagha Malawu va Chapanga vamupili Musa avelili akuvatanga vagaju na kumudadavila Chapanga majuva vosi. ");
INSERT INTO ndj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yavelili pamusi saa tisa, Chapanga amlangushili palola ngatu hela, makungu wa Chapanga, kamuyisila kumuwombela, “Kolineli!” ");
INSERT INTO ndj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolineli kamulolesha nesu makungu ayu kwa lyova, kadeta, “Kuna liki Bambu?” Makungu kamuyangula, “Chapanga kasiyanga dadavu shaku na fupu wala dakuvasiwi ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hinapawu, valayishi vandu Yopa, vakamukemi Simoni, litawa lyaki lingi Petili. ");
INSERT INTO ndj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mweni muhenja wa mundu yumu, litawa lyaki Simoni, mugola chichuku sha ngwembi, nyumba yaki ya muluwongu ya bahali.” ");
INSERT INTO ndj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yula makungu akaywangeyi nayu pawukili kala, Kolineli avakemili vagolafichuku vaki vavili va munyumba na machonda yumu yamumanyili Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pavawombilili kala findu fyosi fifumbukili, kavalayisha vayendi Yopa. ");
INSERT INTO ndj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chilawu yaki, pavaveghi mumwanja pabehi na mumbwani, Petili akwenili kulipaghali, kadadava kwa Chapanga, lijuva lyaveli palundosi. ");
INSERT INTO ndj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Njala yamutamili, akadayileyi chindu cha kulya, pavaveghi vakumutelekela, kashulula, ");
INSERT INTO ndj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","awonili kumbindi kufuwuka, chisunuka kucha yingwa ngomi, yikusunushwa pasi yikamuliwa na mbembi shaki mchechi. ");
INSERT INTO ndj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mugati yaki mwavelili vang'ongolu vosi vaveli na mawulu, vala vakwava na vambongu vawuluka kululanga. ");
INSERT INTO ndj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pambeli kapikana lishu limlongela, “Petili tandamuki, kawulayi wulyi.” ");
INSERT INTO ndj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lakini Petili kadeta, “Ng'odu Bambu! Ngali hela kulya chindu chiveli cha wafu.” ");
INSERT INTO ndj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lishu limuwombela kandi lideta, “Fyang'alishili Chapanga, kotoo kufikema fyawafu.” ");
INSERT INTO ndj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chindu achi chiyeleka mala ndatu, pambeli yila yingwa yiwuya kumbindi. ");
INSERT INTO ndj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petili aveli akunyumanyuma akwipwelesha mumunda yaki, milotu ayi ayiwonili yina mana liki, vala vandu avalayilili Kolineli, vakakonyesheleyi nyumba ya Simoni vawolukili pawulongolu ya mlyangu. ");
INSERT INTO ndj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Vakakemeyi panji kwa lishu likomi, “Kwaveli mhenja litawa lyaki Simoni Petili, akwikala amu?” ");
INSERT INTO ndj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petili aveli akwihola chila chalangushilwi na Chapanga, Mfuki Mng'alili kamuwombela, “Pikani! Pavaveli vandu vatatu vakukusaka. ");
INSERT INTO ndj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ulopukeshi, usunuki uwuki pamu na veni, kotoo kuva na hoshu, nenga ndivalayisha.” ");
INSERT INTO ndj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petili kasunuka pasi, kavawombela vandu vala, “Yumumsaka nengapa. Muyisa muyilata liki?” ");
INSERT INTO ndj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Veni vayangula, “Kolineli mkomi wa machonda katulayisha, vamuwombela mundu yaveli goleki yamujumila Chapanga, mweni mundu msangi kupita vandu vosi va mlima wa Vayawudi. Makungu kamuwombela atulayishi tuyisi tukuwombeli uyendi kayaki, apikanishi filongu fyaku dawumuwombeli.” ");
INSERT INTO ndj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petili kavalibushila munyumba vavi vahenja vaki vawonja pala. Chilawu yaki kawuka na vala pamu na vandu vamonga vamujumilili Bambu vayikalaya Yopa vamukovekelili. ");
INSERT INTO ndj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chilawu yaki vafikili Kayisalia. Kolineli avelili akumvetela Petili aveli na valongu mundu na vaghanja vaki va pabehi yivalalikili. ");
INSERT INTO ndj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petili payingileyi, Kolineli afumili panji kumuyanga, kamutundamila na kamugondamila Petili mbaka pasi. ");
INSERT INTO ndj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petili kamutandamusha, kadeta, “Woloki, nenga mundu hela kucha yuwi.” ");
INSERT INTO ndj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pakawombeyi nayu kunu vakwingila munyumba, kaliwona lipinga likomi lya vandu vayikungasha pamu. ");
INSERT INTO ndj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petili kavawombela, “Yumwi mumanya nendu mwiku kwa Malawu va Chapanga vamupili Musa mundu yavelili Muyawudi kuyihasha awu kuyityangila na vandu va milima yingi. Lakini Chapanga kanangusha ngotoo kumukema mundu yoyosi yapiyalili awu wa wafu. ");
INSERT INTO ndj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwa nongwa ayi, pamungemili jumila nyisa ngajila kususuvila, topi nguvadasha, chimungemilili nenga chindu liki?” ");
INSERT INTO ndj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolineli kadeta, “Majuva matatu vapitili, chipindi kucha achi, cha saa tisa mbungamihi, padadaveyi kwa Chapanga munyumba yangu, melili nimwona mundu kawoloka pawulongolu pangu, avelili na yingwa sing'alili. ");
INSERT INTO ndj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kadeta, ‘Kolineli! Chapanga kapikanisha pawudadava na fupu shaku dasivasuvi ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Valayishi vandu vayendi Yopa, vakamukemi Simoni Petili, akwikalagha mukaya ya Simoni mugola chichuku sha ngwembi yayikala muluwongu ya bahali.’ ");
INSERT INTO ndj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tepu, ndivalayisha vandu kwa yuwi, kugola nyanyi kwisa. Hinapawu twawosi twabaha pawulongolu ya Chapanga tukupikanisha filongu fyosi fyakulamulili Bambu.” ");
INSERT INTO ndj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petili akandili kudeta, “Nakaka ponopa manya Chapanga kavahela lushawu. ");
INSERT INTO ndj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mundu yoyosi yamjuma Chapanga na yaveli goleki, dajumiliwi na mweni. ");
INSERT INTO ndj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Chilongu achi chavayeghilili vana va Isilaeli kulandula Chilongu cha Nyanyi yichiyegha kusika kwa deha ya Yesu Kilistu ndi Bambu wa vonda. ");
INSERT INTO ndj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yumwi chindu achi muchimanya, chikwila mlima wosi wa Yudeya, kukandila Galilaya, unjagila walandulili kala Yohani Mbatisha. ");
INSERT INTO ndj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Milandu ya Yesu wa Nasaleti, Chapanga amushawulili amumemishili Mfuki Mng'alili na liwovi. Mweni kayenda kosi, pagola chichuku cha nyanyi kavalowola vosi yivaveli muliwovi lya Lijangavandu. Nongwa Chapanga aveli pamu na mweni. ");
INSERT INTO ndj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yufwi vatovilela va milandu yosi yagolili mumlima wa Uyawudi na Yelusalemu vamuwulaghili na kumutumbika mlupingika. ");
INSERT INTO ndj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Chapanga amushukushili mulijuva lya tatu tangila pasovili na kumugola awoneki, ");
INSERT INTO ndj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kwa vandu vonda ha, ila kwa vatovilela yivashawuliwili kala na Chapanga, yufwi yina, tulya na tulanda pamu na mweni pashukukili kufuma munjifwa. ");
INSERT INTO ndj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Katulayisha tuvalandulili vandu, pavawombela kucha Chapanga amshawulili Yesu kuvahigha yivaveli vanofu na yivasovili. ");
INSERT INTO ndj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Vambuyi va Chapanga vosi vakumuywangila, kucha mundu yoyosi yamujumila, kwa liwovi lya litawa lyaki dawushiwi sambi.” ");
INSERT INTO ndj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petili paghaveyi akali akudeta filongu afi, Chapanga kavasunushila Mfuki Mng'alili vandu vonda yivapikanisheyi unjagila waki. ");
INSERT INTO ndj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Vayawudi vajumilili yivayisili na Petili kufuma Yopa vajinga kuwona wuwula wula Chapanga kavamemesha vandu vangajila kuva Vayawudi Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nongwa vavapikanishili pavadeta ndambu yingajila kumanyika na kumujuma Chapanga. Petili kadasha, ");
INSERT INTO ndj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Vandu yivamupokilili Mfuki Mng'alili kucha yufwi, ghani daweshi kuvakanisha ava vakotoo kabatishiwa kwa machi?.” ");
INSERT INTO ndj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kalayisha vabatishiwi kwa litawa lya Yesu Kilistu. Pambeli vamuluvili Petili ayikali nawu kwa majuva madokwa. ");
INSERT INTO ndj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Vandundami na valongu vavelili Yudeya vapikanili kucha vandu vangajila kuva Vayawudi na veni vachiyangili chilongu cha Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Topi, Petili pawuyili Yelusalemu, Vayawudi vamjumilili vakadayileyi vandu vangajila kuva Vayawudi vayingishiwi jandu, ");
INSERT INTO ndj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","vakadeteyi, “Yuwi vayendili kuyikala kwa vandu vangajila jandu na kulya na veni!” ");
INSERT INTO ndj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petili akandili kuvawombela kwa chiganu chindu chigolikili kufumila pa kwandi, ");
INSERT INTO ndj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lijuva limu pandimudadavila Chapanga mbwani ya Yopa, ng'ona milotu, chindu kucha yingwa ngomi yiveli na mbembi mchechi yikusunushiwa kufuma kumbindi yiwoloka pawulongolu yangu. ");
INSERT INTO ndj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Panolili chindu chila mugati nivawona vang'ongolu va mkaya vaveli na mawulu mchechi na vang'ongolu va mudasi, vala vakwava na vambongu va kululanga. ");
INSERT INTO ndj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Pambeli mbikanila lishu likung'ombela, ‘Petili toli, uyendi ukavasinji, wuvalyi.’ ");
INSERT INTO ndj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lakini nenga nyangula, ‘Ng'odu Bambu! Mana chindu chamwiku awu chawafu chiweshi ng'odu kuyingila mumulomu wangu.’ ");
INSERT INTO ndj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lishu lila lyanyangulili kandi kufuma kumbindi, ‘Fyawumbili Chapanga kafigola fing'alili kotoo kufikema findu fyawafu.’ ");
INSERT INTO ndj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chindu achi chigoleka myanja mitatu, pambeli findu fyosi fibikuliwa kandi kumbindi. ");
INSERT INTO ndj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tepu, vandu vatatu vayisili pawulongolu ya nyumba yindiyikaleyi, valayishwa kufuma Kayisalia vayisi kwa nenga. ");
INSERT INTO ndj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mfuki Mng'alili kang'ombela nyendi na veni, ngotoo kuva na hoshu. Valongu ava sita yivajumilili tuyilongosha pamu kuyenda Kaisalea tuyingila munyumba ya Kolineli. ");
INSERT INTO ndj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mweni katuwombela ndambu amuwonili makungu yawolukili panyumba yaki na kumuwombela, ‘Valayishi vandu vayendi Yopa vakamukemi Simoni, litawa lyaki lingi Petili. ");
INSERT INTO ndj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Dakuwombeli filongu fyeni dafikulowoli yuwi na vandu vosi va kayaku.’ ");
INSERT INTO ndj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pangandeyi kudeta, Mfuki Mng'alili kavasunukila kucha patusunukilili yufwi pa kwandi. ");
INSERT INTO ndj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ngumbuka chilongu chadetili Bambu, ndambu adetili, ‘Yohani Mbatisha abatishili kwa machi, lakini yumwi damubatishwi kwa Mfuki Mng'alili.’ ");
INSERT INTO ndj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mani Chapanga kavapa veni fupu yiyila yila kucha yatugayilili yufwi patumujumila Bambu Yesu Kilistu, nenga ghani mbaka nyesi kumulimba Chapanga?” ");
INSERT INTO ndj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pavapikanishili filongu afi valeka kulimba vamujuma Chapanga, pavadeta, “Chapanga kavatanga Vangutungu vapomeli na vapati unofu!” ");
INSERT INTO ndj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Vala yivajumilili chipindi achi vapwililikili kwanongwa ya kugoboliwa na kuwulayiwa kwa Stefwani, vayendili mbaka Foiniki na Kupilu na Antiyokiya, pavalandula unjagila wula kwa Vayawudi weka hela. ");
INSERT INTO ndj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lakini yivajumilili vamonga vaveli vandu vafumili Kupilu na Kileni, veni pavafikili Antiyokiya valandulili Chilongu cha Nyanyi cha Bambu Yesu kwa vangutungu. ");
INSERT INTO ndj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Liwoku lya Bambu lyaveli pamu na veni, vandu vatangalili nendu vamujumilili na kumughalambukila Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Milandu ayi yapikanikili kwa lipinga lya vandu yivamjumilili Kilistu aku Yelusalemu, vamulayishili Banabasi ayendi mbaka Antiyokiya. ");
INSERT INTO ndj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pafikili kula awuwonili usangi wa Chapanga asekililili, avakuvilishili vandu vosi vayikali muujumilwa wa Bambu kwa ndima shawu shosi. ");
INSERT INTO ndj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasi aveli mundu msangi yamemili Mfuki Mng'alili na ujumilwa na vandu vatangalili vayongisheka na kumuwuyila Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pambeli, Banabasi kayenda Talisu kumusaka Sauli, ");
INSERT INTO ndj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pamuwonili kala kamuyegha Antiyokiya, vosi vavili kwa chipindi cha mwaka vayikalili pamu na lipinga lya vandu yivamjumilili Kilistu kunyumba ya Chapanga na pavawula lipinga likomi lya vandu. Kula Antiyokiya vavelili vandundami va kwaa kukanda kuvakema Vakilistu. ");
INSERT INTO ndj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Vayisili vambuyi vamu va Chapanga yivafumili Yelusalemu kuyenda Antiyokiya. ");
INSERT INTO ndj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Muyawu yumu litawa lyaki Agabasi, awolukili kadeta kwa Mfuki Mng'alili kucha dayiyisi njala ngomi mlima wosi awu. Yeni dayiyisi chipindi cha wutwa wa Kilawudiu. ");
INSERT INTO ndj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Vala vandundami, kila mundu ndambu yaweshili, avatangili vala yivamjumilili Kilistu yivayikaleyi Yudeya. ");
INSERT INTO ndj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Vagolili nawula, pambeli, vavayeghilili mbiya vagogolu va vandu va Chapanga kwa mawoku va Banabasi na Sauli. ");
INSERT INTO ndj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chipindi chichi, mutwa Helodi akandili kuvagobola lipinga lya vandu yivamjumilili Kilistu. ");
INSERT INTO ndj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Amuwulaghili Yakobi, mlongu waki Yohani kwa limayi likomi. ");
INSERT INTO ndj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Paawonili kavanowesha Vayawudi, kayenda kandi akamukamuli Petili. Majuva vala vavelili majuva va mibumunda. ");
INSERT INTO ndj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pavamukamulili kala, kamuvika muchijaka kamtaya mumawoku va fipinga mchechi fya machonda mchechi mchechi vamuloleli, Helodi akadayileyi chipindi cha Lihungu pachipita amfumishi na kumuhigha pawulongolu pa vandu. ");
INSERT INTO ndj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petili vamuvikili muchijaka, lipinga lya vandu yivamjumilili Kilistu vadadavili kwa Chapanga kwanongwa yaki kwa chiganu. ");
INSERT INTO ndj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chipindi Helodi padayileyi kumfumisha, pamii Petili avelili kawonja pagati ya machonda vavili, kawopiwa mingongola mivili ya chuma na machonda vamloleleyi pavayipokela pawulongulu ya chijaka. ");
INSERT INTO ndj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tepu makungu wa Bambu awolukili pala, lwengi lung'alika chumba chila, kamgufya Petili, pamuyimusha, padeta, “Ulopukeshi! Tandamuki!” Mingongola ya mumawoku yawopusokili. ");
INSERT INTO ndj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Makungu kamuwombela, “Uyiwopi lufunga, ufwali mikobasi yaku.” Petili agolili wuwula, makungu kadeta, “Fwali yingwa yaku ungovikeli.” ");
INSERT INTO ndj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petili amkovikelili makungu kufuma muchijaka, ngajila kumanya ndambu yagola makungu nakaka awu akulota hela. ");
INSERT INTO ndj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pavampitili mdima wa kwaa na wa pili, pambeli mlyangu wa chuma wa kuyingilila mumbwani, wafuukili weni. Vafuma panji, vapita deha yimu, tepu makungu kamuleka Petili. ");
INSERT INTO ndj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petili luhala palumuwuyilili, kadeta “Hinapawu manya nakaka kucha Chapanga amuyeghili makungu waki, kung'usha mumawoku va Helodi na Chila vakashuvilileyi mlima va Vayawudi.” ");
INSERT INTO ndj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pamanyili afi afikili kaya ya Maliya, mamundu Yohani Maliku, vandu vatangalili vavelili vatangana amu pavadadava kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petili akutili mulyangu, mgolafichuku wawu litawa lyaki Loda, ayisili kumpikanisha. ");
INSERT INTO ndj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pakamanyili lishu lila lya Petili, kwa cheleli kufuwula ha mlyangu, katuva mbilu kuyingila mugati kuvawombela kucha Petili kawoloka pamulyangu panji. ");
INSERT INTO ndj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Vamuwombela, “Kuna lukwali!” Lakini mweni ayendilili kudeta nakaka. Topi veni vadeta, “Ayu makungu waki.” ");
INSERT INTO ndj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petili kayendelela kukuta pamlyangu, pambeli vamufuwulila, vamuwona mweni, vayikanganikili. ");
INSERT INTO ndj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kavakupisha liwoku vanyamali, kavahimulila ndambu Bambu amufumishili muchijaka. Awombili, “Mukamuwombeli Yakobi na vala valongu filongu afi.” Pambeli afumili ayendili kwingi. ");
INSERT INTO ndj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pamalavila machonda vayishoshili, kucha chindu liki chimupatili Petili? ");
INSERT INTO ndj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helodi avalayishili machonda vamsaki lakini vamuwona ha, avawombilili machonda, pavamuwona ng'odu alayilili vawulayiwi. Pambeli Helodi afumili Yudeya kayenda Kayisalia ayikalili aku padokwa. ");
INSERT INTO ndj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helodi kavakalalila nesu vandu va Tilu na Sidoni, vamuyendela mweni. Vagola lighanja na Blastu, mweni aveli mlolela wa nyumba ya mutwa, veni vayendili kwa Helodi kuluva kuvi na kusika, kwanongwa mlima wawu wapatili filivi kufuma mlima wa mutwa. ");
INSERT INTO ndj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lijuva limu vayishawulili, Helodi afwalili yingwa sha wutwa, ayikalili muchigoda cha wutwa, akavalandulileyi vandu. ");
INSERT INTO ndj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Vandu vakavikeyi umatu, vakadeteyi, “Ali lishu lya mundu ha, lya Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tepu makungu wa Bambu kamuwisha Helodi pasi, kwanongwa kamtundamila ha Chapanga, wambi vamulya Helodi, kasova. ");
INSERT INTO ndj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Chipindi achi chilongu cha Chapanga chiyendelela kukwila na kukula. ");
INSERT INTO ndj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasi na Sauli, pavamalilili kala kulandula, vawuyili Yelusalemu, vamtola Yohani yivamkemili Maliku. ");
INSERT INTO ndj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lipinga lya vandu yivamjumilili Kilistu lya aku Antiyokiya munyumba ya Chapanga kwaveli na vambuyi na vawula, vamu vaveli, Banabasi na Simoni yivamkema Mtitu na Lukiu Mkileni na Manaeni ayikalili kwa Helodi kandi kwavelili na Sauli. ");
INSERT INTO ndj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pavamdadavileyi Bambu na kuyikaja kulya, Mfuki Mng'alili kadeta, “Mubawulili Banabasi na Sauli vavi na nenga mungimbaniku yila yindivakemilili.” ");
INSERT INTO ndj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pavamalili kuyikaja kulya na kudadava, vavavikila mawoku, vavaleka vayendi. ");
INSERT INTO ndj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mfuki Mng'alili avayeghili vandu ava vaselikilili mumbwani ya Seleukia, kufuma aku vapitili mubahali mbaka liwunguli lya Kupilu. ");
INSERT INTO ndj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pavaveghi Salami valandulili chilongu cha Chapanga munyumba sha kudadavila sha Vayawudi, veni vaveli pamu na Yohani Maliku avatangili mungimbaniku. ");
INSERT INTO ndj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pavapitili kala pagati ya lihunguli lyosi mbaka Pafu, vamuwonili mundu yumu muhavi Muyawudi yakemiwa Baliyesu, mbuyi wa udesi, ");
INSERT INTO ndj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mundu ayu avelili pamu na mkomi wa lila liwunguli Segiu Pauli, mundu yaveli na luhala munu. Mweni avakemili Banabasi na Sauli vayendi kayaki, akadayileyi kupikanisha chilongu cha Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lakini yula Elima, mhavi kucha wuvakemiwa kwa Chigiliki, akayesheyi kuvalimba kumugola ayu mkomi wa liwunguli akotoo kuujumila Ukilistu. ");
INSERT INTO ndj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Topi, Sauli yivamkemeyi wuwula Pauli, amemili Mfuki Mng'alili, amufulutulili mesu muhavi. ");
INSERT INTO ndj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Kawomba, “Yuwi mwana wa Lijangavandu. Yiumemili wafu wosi. Yuwi chimdwama wa chindu chiveli cha nakaka, kuva mjangi mudeha sha Bambu siholukili? ");
INSERT INTO ndj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Loli, liwoku lya Bambu dalikwisili ponopa, dawuvi ngalimesu na ukotoo kuliwona lijuva kwa chipindi.” Tepu, mesu va Elima vayingila lwisa, kashengeta shengeta akusaka mundu wa kumukamula liwoku na kumulongosha. ");
INSERT INTO ndj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yula mkomi, pawonili figolikili, kajumila, akajingeyi mawuli va Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pambeli Pauli na vamonga vawuka kwa watu mbaka Pafu, vafika Pagi, mbwani ya Pamfilia. Yohani Maliku kavaleka kawuya Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lakini veni vawukili Pagi, vafikili Antiyokiya, mbwani ya Pisidia, Lijuva lya Kupumulila vayendili munyumba ya kudadavila, vayikala. ");
INSERT INTO ndj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pambeli, pavasomili kala Malawu va Chapanga vamupili Musa na mumayandiku va vambuyi, vakomi va nyumba ya kudadavila valayilili mundu kayawu na kuvawombela, “Valongu, kucha pamuva na chindu cha nyanyi kuvawombela vandu ava, mudeti.” ");
INSERT INTO ndj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pauli kawoloka, kapunga liwoku, kadeta, “Yumwi valulumi Vayisilaeli na yumwi mumjumila Chapanga, mpikanishi. ");
INSERT INTO ndj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Chapanga wa Vayisilaeli, avashawulili vagogolu venu yivasovili, avagoli vavi mlima mkomi, pavaveghi vakwikala kucha vahenja mlima wa Misili, kwa liwovi lyaki avawushili, kavalongosha. ");
INSERT INTO ndj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kwa chipindi cha myaka kucha milongu mchechi avayiwunishilili kucheja. ");
INSERT INTO ndj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Payanangili kala makabila saba va Kanaani kavagayila wuvi mlima wawu wa mbala. ");
INSERT INTO ndj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kwa chipindi cha myaka miya mchechi na milongu muhanu, Chapanga avagayilili valamula wutwa mbaka chipindi cha mbuyi wa Chapanga Samweli. ");
INSERT INTO ndj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Pambeli valuva avagayili mutwa, Chapanga kavapa Sauli mwana wa Kisi, mundu wa kabila la Benjamini, kwa chipindi cha myaka milongu mchechi. ");
INSERT INTO ndj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pamuwushili kala Sauli, amugolili Dawudi ghavi mutwa wawu. Chapanga awombili, ndimuwona Dawudi mwana wa Yesi, ndi mundu yanowiliwa na ndima yangu, dagoli fyosi fidayilili kugola nenga. ");
INSERT INTO ndj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kufuma lukolu lwa Dawudi, Chapanga ngimu avajangili, kavayeghela Mlowola wa Isilaeli ayu ndi Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu paghaveyi akalihela kwisa, Yohani Mbatisha alandulili kala kwa vandu vosi va Isilaeli filongu fya ubatishu wa kupomela. ");
INSERT INTO ndj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohani mbatisha paghaveyi akumalila chichuku chaki, adetili, ‘Mukucha nenga ndi mkombola? Nenga ng'odu mumuveteli. Mumbikanishi! Mweni dayisi kumbeli ya nenga, nenga ngujakwa ha hata kuwopola ng'oyi sha mikobasi yaki.’ ");
INSERT INTO ndj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Valongu vangu, va lukolu lwa Ibulahimu, pamu na ava vayenu muveli nawu vamjumilili Chapanga, unjagila wa kulowoka ufika kwa yufwi. ");
INSERT INTO ndj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Vandu yivayikala Yelusalemu na vakomi vawu, vamumanyili ng'odu Yesu mkombola, wala filongu fya vambuyi fyavasoma Majuva va Kupumulila, hata naha vatolili filongu fya vambuyi figoleki nakaka kwanongwa ya kumuhigha. ");
INSERT INTO ndj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pavapotili nongwa ya kumuwulaghila, vamuluvili Pilatu amuhighi njifwa. ");
INSERT INTO ndj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pavagolili fyosi fimuyilatili mweni kufuma Mumayandiku, vamusunusha kufuma mulupingika, vamuvika kusembi. ");
INSERT INTO ndj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lakini Chapanga amushukushili munjifwa, ");
INSERT INTO ndj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","kwa majuva vatangalili ayilangushili kwa vala vayendili pamu na mweni kufuma Galilaya kuyenda Yelusalemu, ava ndi vatovilela vaki kwa vandu va Isilaeli. ");
INSERT INTO ndj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na yufwi tuyisa kuvayeghela chilongu cha nyanyi, chilongu chila Chapanga avajangili vambuyi vetu yivasovili. ");
INSERT INTO ndj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Chapanga katugolela chavalayili vambuyi vetu yufwi vaisukulu vawu, kwa kumshukusha Yesu kufuma munjifwa. Ngimu iyandikilwi Mulumbombu lwa Pili, ‘Yuwi mwana wangu, nenga lelu ndiva Tati waku.’ ");
INSERT INTO ndj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kandi mumilandu ya kumshukusha munjifwa, akotoo kuwuya na kuuleka mvili uwoli musembi, Chapanga awombili naha, ‘Damunyimbi nemusi sing'alili na sha nakaka shindimujangili Dawudi.’ ");
INSERT INTO ndj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mahali pamonga Mulumbombu pakuwomba, ‘Chapanga dawumleki ng'odu Mng'alili waku awoli.’ ");
INSERT INTO ndj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Lakini ayu aveli Dawudi ha yamalilili chadayilili Chapanga chipindi cha unofu waki, pambeli asovili, vamusikili pabehi na vagogolu vaki yivasovili, mvili waki wa wolili musembi. ");
INSERT INTO ndj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lakini yula, Chapanga yamushukushili munjifwa kawola ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Topi, valongu vangu mumanyi, kucha kwa njila ya Yesu unjagila wa kupomiliwa sambi ukulanduliwa kwa yumwi. ");
INSERT INTO ndj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kila mundu yamjumila Yesu kavahela nongwa. Na nongwa yaku yingahighiwili ha kwa ugoleki wa Chapanga vamupili Musa. ");
INSERT INTO ndj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Topi, muyivavali na milandu yivadetili vambuyi yikotoo kuvafumbukila yumwi. ");
INSERT INTO ndj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Vambuyi vadetili, ‘Mupikanishi, yumwi yimuvelili na mbedalu, mujingi muyaghamili! Kwanongwa chigola panopawu chipindi cha yumwi, chindu cheni damukijumili ng'odu hata mundu pakavawombela.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pauli na Banabasi pavafumeyi, munyumba ya Chapanga, vandu vavaluva vayisi kandi Lijuva lya Kupumulila lingi vavawombeli milandu ayi. ");
INSERT INTO ndj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Likungashu lila palipelili, Vayawudi na vandu vangajila kuva Vayawudi vatangalili vavelili vakukovikela deha ya kumkovikela Chapanga ya Chiyawudi vavakovikelili Pauli na Banabasi. Vandundami vaywangili na veni, vavakuvilishili vayendeleli kuyikala pavayidumba usangi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hata Lijuva lya Kupumulila liyisili, vandu vatangalili va mumbwani yosi vayikungashili kupikanisha chilongu cha Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Vayawudi pavawonili vandu vayikungasha, vamemili weyi, vafibedala filongu fyadetili Pauli na kumujowola. ");
INSERT INTO ndj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pauli na Banabasi vawombili kwa chiganu nendu vadeta, “Chilongu cha Chapanga chivi kwa yumwi tanila, lakini kwanongwa mwihigha mwaveni na mukudayiliwa kwikala jola, tukuvaleka tukuyenda kwa vandu va milima yingi. ");
INSERT INTO ndj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwa nongwa ayi Bambu katulayila naha, ‘Ngukuvika wuvi lwengi lwa milima, uvayegheli vandu va milima yosi ulowolu.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Vandu va milima yingi vasekilelili pavapikanishili chilongu chila, vajuma pavadeta, “Unjagila wa Bambu mnofu,” na vala yivavelili vashawuliwa kupata unofu wa jola, vamjumila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chilongu cha Bambu chikwila pala posi. ");
INSERT INTO ndj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lakini Vayawudi vavatumishila vadadala vatawukili va milima yingi yivamumanyili Chapanga na valulumi vatawukili va mbwani ayi. Vakandili kuvagobola Pauli na Banabasi, vavavinga kuvayikaleyi. ");
INSERT INTO ndj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Veni vavapundila lifu livelili mumawulu vawu kucha kuvakayika pambeli vayenda Ikoniu. ");
INSERT INTO ndj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Lakini vandundami yivavelili vamema cheleli na Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kula Ikoniu, milandu yavelili kucha kula Antiyokiya, Pauli na Banabasi vayendili munyumba ya kudadavila kwa Vayawudi vadetili kwa kugangamala mbaka Vayawudi na Vagiliki vajumila. ");
INSERT INTO ndj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lakini Vayawudi vamonga vangajila kujumila vavajongishela na kuvagola vandu vangajila kuva Vayawudi vaghalambuki kufuma vandu yivajumilili. ");
INSERT INTO ndj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pauli na Banabasi vayikalili nesu, vakadeteyi kwa chiganu chilongu cha Bambu na Bambu alangushili unakaka wa usangi waki kwa kuvagayila liwovi lya kugola mihilu na miwujawuja. ");
INSERT INTO ndj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Lakini vandu va mumbwani vabavikili, vamu vavelili mwambu wa Vayawudi na vamu mwambu wa vandundami. ");
INSERT INTO ndj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pambeli, vandu vamonga va milima yingi na Vayawudi, pamu na vakomi vawu, vayilatili kuvagolela wafu vandundami na kuvaguma migonguveli. ");
INSERT INTO ndj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Vandundami pavamanyili chindu achi, vatuvilili Lusta na Debi mbwani sha Lukaonia na milima ya pabehi, ");
INSERT INTO ndj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","aku vavelili vakulandula chilongu cha nyanyi. ");
INSERT INTO ndj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kwavelili mundu yumu aku Lusta kufumila awoneki aveli ndevindevi, akali hela kuyendayenda. ");
INSERT INTO ndj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mundu ayu ayikalili pampikana Pauli yalanduleyi. Pauli amlolili kwa chiganu, kamuwona kana ujumilwa akuwesha kulowoka, ");
INSERT INTO ndj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kalandula, “Woloki kwa mawulu vaku!” Yula mundu ndevindevi tepu katandamuka, akandili kuyendayenda. ");
INSERT INTO ndj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lipinga lya vandu pavawonili chagolili Pauli, vakandili kuvika umatu kwa kabila lya Chilukaonia, “Vamulungu vatusunukila kucha vandu.” ");
INSERT INTO ndj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Vamkema Banabasi Zeu na vamkemili Pauli Helimesi, kwanongwa mweni aveli mlandula mkomi. ");
INSERT INTO ndj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mtambika wa nyumba ya kudadavila ya chapanga Zeu awolukili panji ya mbwani, ayeghili likambaku lya senga na uluva pamlyangu wa kuyingilila mbwani, mweni pamu na lipinga lila lya vandu vakadayileyi vavatambikili Pauli na Banabasi. ");
INSERT INTO ndj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lakini vandundami Banabasi na Pauli, pavapikanishili milandu ayi, vademula yingwa shawu, vayenda mbilu vayingilili mulipinga lya vandu, padeta kwa lishu likomi, ");
INSERT INTO ndj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Wuli mwabambu mukugola afi? Yufwi tuva vandu kucha yumwi! Tukuvalandulila filongu fya nyanyi, ili mughalambuki na kuyileka milandu ayi ya wafu na mumghalambukili Chapanga yaveli munofu, yagolili kumbindi na pasi bahali na findu fyosi fivelili. ");
INSERT INTO ndj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pakwandi Chapanga avalekili vandu vagoli chila chivadayila veni. ");
INSERT INTO ndj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hata naha, Chapanga avalekili ng'odu kuyilangusha kwa kuvagolela findu fya nyanyi, kuvatonyela ndonya kufuma kumbindi na kuvagayila filivi mufitava kwa chipindi chichila, akuvayikutisha filivi na kuvagayila cheleli.” ");
INSERT INTO ndj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kwa filongu afi vavelili na chipindi chibalamili kuvakanisha vandu, vakotoo kuvatambikila. ");
INSERT INTO ndj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Vayawudi vamu vayisili kufuma Ikoniu na Antiyokiya mumlima wa Pisidia vavajongishela vandu vayihashi pamu na veni, vamuguma migonguveli Pauli na kumukuluwula mbaka panji ya mbwani vakacheyi kasova kala. ");
INSERT INTO ndj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lakini vandundami pavayikungashili na kumshengetela pambeli atandamukili, chilawu yaki kawuya kumbwani, mweni na Banabasi vayendili Debi. ");
INSERT INTO ndj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pauli na Banabasi pavalandulili kala filongu fya nyanyi aku Debi na vandu vatangalili vamjumilili Chapanga. Pambeli vawuyila Lusta na kutyangila Ikoniu pavayenda Antiyokiya yiveli Pisidia. ");
INSERT INTO ndj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Vavagolili vakamali vala vanachuli vala va mlima wula kandi vavataya munda vayikali muujumilwa wawu. Vavawulili, “Lasima tupitili mugoboleku sitangalili pambeli tuyingili muwutwa wa kumbindi kwa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Vashawulili vavaha kila mu lipinga lya vandu yivamjumilili Kilistu, kwa kudadava na kwikaja kulya, vavavika mumawoku va Bambu yivamjumilili. ");
INSERT INTO ndj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pavapitili mlima wa Pasidia, vafikili Pamfilia. ");
INSERT INTO ndj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pavalandulili unjagila wula kula Pagi, pambeli vayenda Atalia. ");
INSERT INTO ndj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kufuma aku vawuyili Antiyokiya muwatu pala pakwandi pavanemiliwi usangi wa Chapanga kwanongwa ya chichuku, chivamalilili kala. ");
INSERT INTO ndj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pavafikili aku Antiyokiya vagolili likungashu lya lipinga lya vandu yivamjumilili Kilistu pala, vavawombilili milandu yagolili Chapanga pamu na veni na ndambu avafuwulili vandu vangajila kuva Vayawudi kuyingila muujumilwa. ");
INSERT INTO ndj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Vayikalili chipindi chitali pamu na vala vandundami Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Topi, vandu vamonga vasunukili kufuma Yudeya kuyenda Antiyokiya vakandili kuvawula vala yivajumilili pavadeta, “Pamuyingila ng'odu jandu kucha Malawu va Chapanga vamupili Musa yivavadayila, muweshi ha kulowuliwa.” ");
INSERT INTO ndj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Chindu achi chayeghili malimbanu makomi, Pauli na Banabasi vaywangili nawu, vavalayila Pauli na Banabasi pamu na vandu vamu yivajumilili va yila nyumba ya kudadavila ya Antiyokiya vayendi Yelusalemu kavalola vandundami na vagogolu yivayilatili chilongu achi. ");
INSERT INTO ndj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Topi, lipinga lya vandu yivamjumilili Kilistu lyavatawulili, na veni pavaveghi vakupita Foiniki na Samaliya vavahimulili vandu ndambu vandu vangajila kuva Vayawudi pavamughalambukilili Chapanga. Filongu fila fyavagayilili cheleli vosi yivamjumilili. ");
INSERT INTO ndj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pavafikili Yelusalemu vayangiwa na lipinga lya vandu yivamjumilili Kilistu na vandundami na vagogolu, veni vavawombilili findu fyosi Chapanga fyavavagolilili veni. ");
INSERT INTO ndj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lakini yivajumilili vamu vavelili va chipinga cha Vafwalisayu vawolukili, pavadeta, “Vangutungu lasima vayingili jandu na kuvawombela vakombikeshi Malawu va Chapanga vamupili Musa.” ");
INSERT INTO ndj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Topi, vandundami na vavaha vatanganikili kwa chindu achi. ");
INSERT INTO ndj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pavalimbanili nendu, Petili awolukili, kadeta, “Valongu vangu, yumwi mumanya kucha dahili Chapanga ashawulili nenga gati ya yumwi kulandula Filongu fya Nyanyi kwa vandu vangajila kuva Vayawudi, vaweshi kupikana na kujumila. ");
INSERT INTO ndj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mweni Chapanga yamanyili chivayihola kila mundu, avagayilili Mfuki Mng'alili vandu vangajila kuva Vayawudi ili vajumili nakaka kucha watugayilili yufwi. ");
INSERT INTO ndj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Aveli kavahela lushawu gati ya yufwi na veni vang'alishili ndima shawu kwanongwa vamjumilili Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Topi, nongwa liki kumuyesha Chapanga nongwa liki mukuvapapisha vandundami misiwu misitu hata vagogolu vetu, vaweshili ng'odu kupapa misiwu ayi? ");
INSERT INTO ndj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yikotoo kuva naha, tujumila, yufwi datulowuliwi kwa usangi wa Yesu kucha veni.” ");
INSERT INTO ndj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Chipinga chosi chanyamalili jii, chikavapikanisheyi Banabasi na Pauli pavahimulila mihilu na miwujawuja Chapanga fyagolili vandu kupitila veni kwa vandu vangajila kuva Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pavamalili kudeta, Yakobi akandili kudeta, “Valongu vangu, mumbikanishi! ");
INSERT INTO ndj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni ahimulili ndambu Chapanga dahili wavagolilili vandu vangajila kuva Vayawudi, avatolili vandu kufuma veni vavi va mweni. ");
INSERT INTO ndj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Chilongu achi chiva ngimu filongu fya vambuyi, kucha mayandiku vang'alili wuvadeta, ");
INSERT INTO ndj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pafipela filongu afi dang'uyi, na kugola libudi lya Dawudi ndiliwoloshi kandi, dagoleshi pabowuyokili ndipagoli kandi na kuugola udindali kandi. ");
INSERT INTO ndj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Apa vandu va makabila vosi davayisi kwa nenga, vandu vangajila kuva Vayawudi vosi vandivakemili vavi va nenga, davamkovikeli Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kucha Bambu ndambu wadeta, agolili chilongu achi chimanyiki kufuma pakwandi.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobi kayendelela kudeta, “Mukotoo kuvagobola vandu vangajila kuva Vayawudi yivamughalambukilili Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ila tuvayegheli baluwa kuvawombela vakotoo kulya filivi fya wafu fivatambikilili milungu wa ming'omung'omu, vayilyepi na uwoni, vakotoo kulya vang'ongolu vaveli fibudu na vakotoo kulanda mwasi. ");
INSERT INTO ndj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nongwa kwa chipindi chitali Malawu va Chapanga vamupili Musa vavelili vakusomiwa munyumba sha kudadavila shosi majuva va kupumulila vosi na filongu fyaki filanduliwa mumbwani shosi.” ");
INSERT INTO ndj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Vandundami, vavaha na lipinga lya vandu yivamjumilili Kilistu lyonda valamula pamu mulipinga lyawu kuvalayisha Antiyokiya pamu na Pauli na Banabasi. Topi vamshawula Yuda wuwula vamkemaya Balisaba pamu na Sila. Vavelili vakuhishimiwa nendu na yivajumilili. ");
INSERT INTO ndj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Vavagayila baluwa ayi, “Yufwi vandundami na vavaha, valongu venu, tukuvajambusha yumwi valongu va milima yingi yimuvelili aku Antiyokiya na Siliya pamu na Kilikiya. ");
INSERT INTO ndj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tupikana kucha vandu vamonga yivafumili kwa yufwi vakuvaghasha na kuvayaghamisha kwa filongu fyawu. Lakini vagolili naha ngajila yufwi kuvajumisha. ");
INSERT INTO ndj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Yufwi tulamula kuvashawula vanjagila na kuvalayisha kwa yumwi valongu venu Banabasi na Pauli, ");
INSERT INTO ndj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","veni vajumila kusova kwanongwa ya litawa lya Bambu wetu Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kwa nongwa ayi tukuvalayisha Yuda na Sila vayisi kwa yumwi, veni davavawombeli afi fituyandikili. ");
INSERT INTO ndj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Topi Mfuki Mng'alili na yufwi yitumjumilili tukotoo kuvayitwika msiwu nendu ila fila fivelili fitalama: ");
INSERT INTO ndj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","mukotoo kulya filivi fitambikiwili ming'omung'omu na mukotoo kulanda mwasi na mukotoo kulya fibudu na muyilyepi na uwoni. Damuvi mkugola nyanyi kucha pamuyilyepa filongu afi. Mwikali nyanyi!” ");
INSERT INTO ndj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pavayitawulili kala, vala vandundami vayendili Antiyokiya kwavelili likungashu lya vala yivamjumilili Bambu, vavagayila baluwa yila. ");
INSERT INTO ndj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pavasomili baluwa yila, filongu fyaki sivadindasha ndima, vasekelela nendu. ");
INSERT INTO ndj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, vavelili vambuyi, vaywangili na valongu ava kwa chipindi chitali kuva sikisha moyu na kuvadindasha. ");
INSERT INTO ndj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kwa chipindi chivayikalili kula, valongu va Antiyokiya vavatawula pavaluvila kusika moyu. Pambeli vawuya kwa vala yivavalayishili. ");
INSERT INTO ndj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lakini Sila awonili ngiba asighali. ");
INSERT INTO ndj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pauli na Banabasi vayendili kuyikala Antiyokiya pavawula na kulandula chilongu cha Bambu, pamu na vandu vamonga vatangalili. ");
INSERT INTO ndj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Majuva pavapitili Pauli kamuwombela Banabasi, “Tuwuyi tukavatyangili valongu vetu mumbwani shosi situlandulili chilongu cha Bambu, vakuyendilela wuliwuli.” ");
INSERT INTO ndj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi akadayileyi kumtola Yohani Maliku ghavi pamu na veni, ");
INSERT INTO ndj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ila Pauli awoni nyanyi ng'odu kumtola Yohani Maliku kwanongwa avalekili kula Pamfilia, vayendili pamu ha mungimbaniku. ");
INSERT INTO ndj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Topi valimbanili veni kwa veni mbaka valekana deha. Banabasi amtolili Maliku vayipaka watu vayenda Kupilu. ");
INSERT INTO ndj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Lakini Pauli awukili na Sila, valongu va pala pavadadavilili kala vapati usangi wa Bambu, pambeli kawuka. ");
INSERT INTO ndj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Vapitili Siliya na Kilikiya kunu padindasha mipinga ya vandu yivamjumilili Kilistu. ");
INSERT INTO ndj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauli pafikili Debi na Lusta, kwayikaleyi mwanachuli yumu yivamkema Timotewu. Mawu waki aveli Muyawudi, lakini tati mundu Mugiliki. ");
INSERT INTO ndj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Vandu vamjumilili Bambu va Lusta na Ikoniu vamuhimulilili nyanyi Timotewu. ");
INSERT INTO ndj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauli amudayilili ayu ayendi nayu, kamtola kamudumula jandu kwanongwa Vayawudi vavelili mwambu wula, nongwa vosi vamanyili kucha tati mundu aveli Mugiliki. ");
INSERT INTO ndj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Topi pavavelili vakupita mumbwani yila, vavagayilili malaghililu vavikili vandundami na vavaha vavelili Yelusalemu, ili vasikamuli. ");
INSERT INTO ndj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Vandu yivamjumilili Kilistu vapatili liwovi kwa ujumilwa wula, vandu vayongishekili kila lijuva. ");
INSERT INTO ndj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pauli na vayaki vapitili mlima wa Fulugia na Galatiya, Mfuki Mng'alili avakanishili vakotoo kulandula chilongu chila mlima wa Asia. ");
INSERT INTO ndj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pavafikili kumbaka ya Misia vayeshili kuyenda Betaniya, lakini Mfuki Mng'alili wa Yesu kavajumisha ha. ");
INSERT INTO ndj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Vapitili Misia vasunukila Tiloa. ");
INSERT INTO ndj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pamihi Pauli alotili milotu, amuwonili mundu yumu wa Makedoniya kawoloka pala akumdedeka kumuwombela, “Jabuki, wisi Makedoniya wututangi.” ");
INSERT INTO ndj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Palotili kala milotu yila, twayitalishili kuyenda Makedoniya pangajila kukelwa kunu patumanya nakaka kucha Chapanga katukema tuvalandulili Chilongu cha Nyanyi. ");
INSERT INTO ndj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tufuma Tiloa, twayendili kwa watu mbaka Samotilaki na chilawu yaki tufika Neapoli. ");
INSERT INTO ndj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tufuma Neapoli twafikili Filipi, mbwani ya wilaya ya kwaa ya Makedoniya na wuwula wula vaveli pasi ya wutwa wa Loma. Twayikalili mbwani ayi majuva vautunga. ");
INSERT INTO ndj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mulijuva lya kupumulila twafumili panji ya mlyangu, tuyenda muluwongu lwa lweni, tukacheyi kuna mahali pa kudadavila Chapanga. Tuyikala, tuywanga na vadadala vatanganikili pala. ");
INSERT INTO ndj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mdadala yumu, mwenikaya wa Tiatila, litawa lyaki Lidia amujumagha Chapanga, mweni ahemishagha yingwa sitalamili, mweni aveli msangi, kapikana, mundima yaki yifuwuliwa na Bambu, vavika filongu fyawombeyi Pauli. ");
INSERT INTO ndj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hata pabatishiwi kala, mweni na vandu va munyumba yaki, katuluva, padeta, kucha muhigha ndiva msangi kwa Bambu, muyingili munyumba yangu muyikali. Katung'ang'anika. ");
INSERT INTO ndj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Patuveyi tukuyenda mahali pala pakudadavila, mvanda yumu mhinja yavelili akutunga atuwonili, avelili akuvalondulela valundamali vaki mbiya sitangalili kwa kutunga. ");
INSERT INTO ndj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Muhinja ayu kamukovekela Pauli na yufwi pawuta na kudeta, “Vandu ava ndi ndumindumi wa Chapanga avelili kumbindi, veni davavawuli ndambu ya kulowoka.” ");
INSERT INTO ndj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Agolili nawula kwa kila lijuva. Lakini Pauli yamunyekwili, kamghalambukila mhinja kamuwombela yula chinyamkela, “Ngukulayisha kwa litawa lya Yesu Kilistu, ufumi kwa mundu ayu!” Kamfuma chipindi chichila chila. ");
INSERT INTO ndj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Topi vabambu vaki pavawonili kucha chivashuvilileyi kupata mbiya chipela, vavakamula Pauli na Sila, vavakuluwulila pawelu kwa vakomi va mbwani. ");
INSERT INTO ndj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Vavatola mbaka kwa vahigha milandu, vadeta, “Vandu ava vakugola ndilingu mumbwani yetu na veni Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kandi vakuwula milandu yeni kwa yufwi vandu va Loma tukujumishwa ha kusijumila na kusikovekela.” ");
INSERT INTO ndj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Lipinga lya vandu vala vosi vavayendela na vala vahigha milandu vavawopusola yingwa shawu kwa liwovi, valayisha vavalatuli ndomondu. ");
INSERT INTO ndj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pavalatuwili nendu vavataya muchijaka, vavalayishila machonda va muchijaka vavadimi nesu. ");
INSERT INTO ndj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kwanongwa ya nayililu yila machonda avavikili muchumbagati cha mugati nendu ya chijaka kavawopa mawulu vawu mumingongola. ");
INSERT INTO ndj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mandandu Pauli na Sila vavelili vakudadava kwa Chapanga na kusomola mbombu sha kumjuma Chapanga, kunu vawopiwa vamonga vavelili vakuvapikanisha. ");
INSERT INTO ndj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tepu pavelili na chiyighayigha chikomi, mbaka chikandilu cha chijaka chitikanyika, tepu milyangu yifuwuka na mingongola yilekana. ");
INSERT INTO ndj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Yula mdimi wa chijaka kayimuka, kawona milyangu ya chijaka yifuwuka, akacheyi vala yivawopiwili vosi vatuva, kakwemula chimayi chaki, akadayileyi kwiwulagha. ");
INSERT INTO ndj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ila Pauli awutili kwa lishu likomi, “Ukotoo kuyiwulaya, twawosi tuva baha.” ");
INSERT INTO ndj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pamkemili kala mundu ayeghi luliku, yula machonda kajumbila mgati, kunu pabagama kwa lyogha, kavawila pamawulu va Pauli na Sila. ");
INSERT INTO ndj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pambeli kavayegha panji, kavadasha, “Bambu goli liki ili nowuliwi?” ");
INSERT INTO ndj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Vamuwombela, “Mjumili Bambu Yesu, yuwi dawulowoki pamu na yivaveli munyumba yaku.” ");
INSERT INTO ndj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Vamuwombela chilongu cha Bambu, mweni na vandu vosi yivavelili munyumba yaki. ");
INSERT INTO ndj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kavalalika chipindi chichila chila, yaveli pamihi, kavawofuwa filonda fyawu, pambeli mweni na vandu va munyumba yaki vabatishiwa chipindi chichila chila. ");
INSERT INTO ndj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pambeli kavatola Pauli na Sila kayaki, kavagayila filivi. Mweni na valongu vaki vosi vagola lihungu kwanongwa ayi ponopa vava vakumjumila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Chilawu yaki pamalavila, vahigha vavalayisha vakomi va machonda vawu pavadeta,, “Muvafumishi vandu ava vayiyendeli.” ");
INSERT INTO ndj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yula mdima chijaka kamuwombela Pauli filongu fila padeta, “Vahigha valayila vandu ili mufuwuliwi, topi ponopa mfumi panji, myiyendeli kwa kusika.” ");
INSERT INTO ndj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pauli kavawombela, “Kucha chindu liki? Ingava twavelihela mbatiwa, vatulatula ndomondu pawelu kunu yufwi vandu va Loma, pambeli vatutaya muchijaka, ponopa vakudayila kutufumisha kwa chifisu? Ng'odu, vayisi veni vatufumishi.” ");
INSERT INTO ndj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Vakomi va machonda vavawombela vahigha milandu ayi, veni vatilili pavapikanishili kucha vandu va Loma. ");
INSERT INTO ndj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Vayisa kuvaluva vapomeli na pavavafumishili mugati, vavaluvili vafumi mumbwani yila. ");
INSERT INTO ndj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pauli na Sila vafumili muchijaka, vayendili kaya kwa Lidia. Aku vatanganikili na vakilistu na vavasikisha moyu vayenda. ");
INSERT INTO ndj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kwa kupitila Amfipoli na Apolonia vafikili Tesaloniki, aku kwavelili nyumba ya kudadavila ya Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Na Pauli, ayilumbili pamu kucha wuyivelili chishovi, awombanili nawu kwa chipindi cha majuva va kupumulila matatu yivayilongushili, pasoma Mayandiku Vang'alili. ");
INSERT INTO ndj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ahimulili na kulangusha kucha alatiwili Kilistu kuteshiwa na kushukuka. Kavawombela, “Ayu Yesu yindivalandulila ndi Kilistu.” ");
INSERT INTO ndj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Vamonga vajumilili, vayilongosha na Pauli na Sila na Vagiliki vamumanyili Chapanga, vatangalili nesu na vahumbu vatangalili, vayihasha pamu nawu. ");
INSERT INTO ndj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lakini Vayawudi vawonili geli, vavatolili lipinga lya vandu kusoku vangali lusungu na vawafu, vagolili ndilingu mbwani, vavayendela vandu kunyumba ya Yasoni, vakadayileyi Pauli na Sila kuvayegha kwa vandu va mumbwani. ");
INSERT INTO ndj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pavapotili, vamkukusha Yasoni na valongu vaki vamonga kwa vakomi wa mumbwani, vakawuteyi vakadeteyi, “Vandu ava vaghalambulili mulima vosi, vayisa na mumbwani yetu.” ");
INSERT INTO ndj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Na Yasoni kavalibushila na ava vosi vakugola milandu yiveli yilinganila ng'odu na Malawu va Chapanga vamupili Musa va Kayisali, pavadeta kuna mutwa wingi, vakumkema Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwa filongu fila vakomi va mumbwani na lipinga lya vandu vapatili lyova. ");
INSERT INTO ndj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yivagolili Yasoni na vayaki vahombi mbiya, pambeli vavalekiselili vayendi. ");
INSERT INTO ndj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tepu valongu ava vavayeghili Pauli na Sila pamii mbaka Beleya. Veni pavafikili kula vayingilili munyumba ya kudadavila ya Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Vandu ava vavelili vanyanyi pitu vala va Tesaloniki, vapikanishili chila chilongu kwa moyu wosi na majuva vosi vayiwulili mayandiku, kulola kucha nakaka chavawombela Pauli na Sila. ");
INSERT INTO ndj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Topi, vandu vamonga vatangalili vajumilili na vadadala va Chigiliki vaveli na fyewu fikomi na wuwula valulumi. ");
INSERT INTO ndj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lakini, Vayawudi wa Tesaloniki pavamanyili kuva Pauli avelili akulandula chilongu cha Chapanga aku Beleya, vayendili aku, vakandili ndilingu na kuvatumisila lipinga lya vandu. ");
INSERT INTO ndj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Vala valongu vamuyeghili Pauli kumbwani lakini Sila na Timotewu vasiyalili Belea, ");
INSERT INTO ndj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Vala valongu vamuyeghili Pauli vayendili pamu nayu mbaka Ateni. Pambeli, vawuya pamu na yalayishili Pauli kuva Sila na Timotewu valopukesi vamukovikeli. ");
INSERT INTO ndj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pauli avelili akuvaveta Sila na Timotewu aku Ateni, mugati ya moyu waki akalalili nendu kuwona ndambu mbwani yila yamemili ming'omung'omu. ");
INSERT INTO ndj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Topi munyumba ya kudadavila awombanili na Vayawudi vamumanyili Chapanga na vala atanganikeyi nawu majuva vonda papiteyi mulipinga. ");
INSERT INTO ndj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Vamonga vakovikelili ndambu ya Epikulo na Stoiki valimbanili nayu. Vamonga vadetili “Akudayila kudeta liki ayu ndwangamlomu?” Wula Pauli avelili akulandula milandu ya Yesu na kushukuka, vamonga vadetili “Yikulangusha kucha ayu akulandula milandu ya vachapanga vahenja.” ");
INSERT INTO ndj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Vamtolili Pauli, vamuyegha Aleopagu, vadeta, “Tudayila kumanya chilongu achi chashonu uvelili ukutuwombela. ");
INSERT INTO ndj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Findu fimonga twapikanishili kwa majeji vetu fikuwoneka kucha miwujawuja kwa yufwi. Tungadayilili kumanya milandu ayi yina mana liki.” ");
INSERT INTO ndj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Venikaya va Ateni na vandu vamonga vayikalaya aku vavelili chipindi chawu chosi vakahimuleye na kupikanisha filongu fya shonu. ");
INSERT INTO ndj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Topi, Pauli awolukili pawulongolu pa chitemela cha Aleopagu, adetili: “Vandu va Ateni! Nguwona kuva yuwi, vandu mukukovekela deha ya kumukovikela Chapanga nendu. ");
INSERT INTO ndj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwa nongwa ayi pambiteyi aku na aku na kulola milandu ya kudadava kwenu, ng'ona fyalu fiyandikiwa filongu afi, ‘Kwa Chapanga yangajila kumanyika.’ Topi nenga kulandula milandu yaki, mweni avelili mkumjuma yula mungajila kumumanya. ");
INSERT INTO ndj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Chapanga yagolili mulima na findu fyosi fivelili, wula mweni ndi Bambu wa kumbindi na mlima, akwikalagha munyumba ya Chapanga yivajengili kwa mawoku ha, ");
INSERT INTO ndj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wala akutangiwa na mawoku va mundu ha, kucha akwilata chindu chochosi, nongwa mweni akuvagayilaya vonda unofu na Mfuki wa findu fyosi. ");
INSERT INTO ndj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mweni agolili kila mlima wa vandu vosi kufuma kwa mundu yumu, kuwesha kuyikala mlima wonda. ");
INSERT INTO ndj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Agolili nahawu, ili milima ayi yimukovikeli na kucha wula kwa kuyibunula, mbaka yamfikili. Lakini hata naha Chapanga kakutali ha kwa kila mundu. ");
INSERT INTO ndj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kucha adetili mundu yumu, Mugati yaki mweni, yufwi tukuyikala, tukuyiwesha na tuva baha! Kucha vasomola lumbombu vamonga vadetili, ‘Yufwi vana vaki.’ ");
INSERT INTO ndj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Topi payiva, yufwi vana va Chapanga, nyanyi ndili kuyihola Chapanga kucha chumang'andu, mbiya awu ligonguweli lya kusongola na kutayiwa malembu na mundu. ");
INSERT INTO ndj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Chapanga agolili kucha akulola ndili chipindi chila cha vandu vavelili vapufi lakini ponopa, akuvalayila vandu vosi kila mahali vapomeli. ");
INSERT INTO ndj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nongwa kavika lijuva davahighi vamulima kwa haki, kwa mundu yula amshawulili, mweni kavagayila vandu vosi vawoni nakaka chilongu achi kwa kumshukusha mundu ayu kufuma munjifwa!” ");
INSERT INTO ndj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pavampikanishili Pauli padeta chilongu cha kushukuka muchikongu, vamonga vasekili, vamonga vadetili, “Tukudayila kukupikanisha kandi chilongu achi!” ");
INSERT INTO ndj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pauli kavaleka, kafuma kuchitemela. ");
INSERT INTO ndj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lakini vandu vamonga vayilongushili pamu, vamjumilili Chapanga vavelili Dionisiu wa Aleopagu na mdadala yumu vakumkema Damali na vamonga. ");
INSERT INTO ndj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pambeli, Pauli awukili Ateni, kayenda Kolindu. ");
INSERT INTO ndj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Aku Kolindu, amuwonili Myawudi yumu vakumkemaya Akula, mlelwa wa Pontu. Akula pamu na mwehi waki yivamkema Piliska, vavelili vawuya kufuma Italiya lijuva lilila, kwanongwa ya Kayisali Kilawudiu avelili kalayisha Vayawudi vosi vawuki Loma. Pauli ayendili kuvalola. ");
INSERT INTO ndj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kwa nongwa veni vavelili vakugola mibudi kucha mweni, Pauli ayikalili nawu akugola chichuku. ");
INSERT INTO ndj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila lijuva lya kupumulila agolili maywangu munyumba ya kudadavila akayesheyi kuvakwegha Vayawudi na Vagiliki. ");
INSERT INTO ndj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timotewu pavafikili kufuma Makedoniya, Pauli atolili chipindi chaki chosi kulandula, kuvawombela Vayawudi kucha Yesu ndi Kilistu. ");
INSERT INTO ndj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Vamlimbili na kukanda kumjowola, kapunda yingwa shaki pawulongolu yawu padeta, “Pamuyaghamila mani mwaveni, nenga ndivahela mbatiwa yoyosi kwa chilongu achi. Kukandila ponopa dandivayendeli vandu va milima yingi.” ");
INSERT INTO ndj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Topi, afumili apa kayenda kwikala kaya kwa mundu yumu yamumanyili Chapanga vakumkema Titusi Yustu, mweni nyumba yaki yavelili pabehi na nyumba ya kudadavila. ");
INSERT INTO ndj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilispu, mkomi wa nyumba ya kudadavila, amujumilili Bambu mweni pamu na valongu vaki vosi. Vakolindu vatangalili vapikanishili unjagila awu vajumilili na kabatishiwa. ");
INSERT INTO ndj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lijuva limu pamihi, Bambu amuwombilili Pauli kwa milotu, “Kotoo kutila kulandula, yendileli kulandula ngajila kuwuya kumbeli. ");
INSERT INTO ndj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nenga dandivi pamu na yuwi, wala kwahela mundu dakugoboli na kukutesha, nongwa nenga ndiva na vandu vatangalili mbwani ayi.” ");
INSERT INTO ndj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kayikala aku chipindi cha mwaka wumu na myesi sita pavalagha chilongu cha Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Chipindi Galiu avelili mkomi wa Akaya, Vayawudi vamuhomkela pamu vamkamula Pauli, vamuyegha kuchitemela, ");
INSERT INTO ndj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","vakadeteyi, “Mundu ayu akuvakwegha vandu ili vamjumi Chapanga kucha valemili Malawu va Chapanga vamupili Musa.” ");
INSERT INTO ndj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Na Pauli padayileyi kudeta, Galiu kavawombela Vayawudi, “Mani chingavelili chilongu achi nakaka chawafu, yumwi Vayawudi yingavelili haki nenga kuvapikanisha. ");
INSERT INTO ndj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lakini leki yiva malimbu venu hela kuyilata filongu na matawa na Malawu va Chapanga vamupili Musa, mulamuli mwaveni. Nenga nema kucha muhigha wa filongu afi.” ");
INSERT INTO ndj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kavadagadaga vawuki pawulongolu ya chitemela. ");
INSERT INTO ndj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Veni vosi vamkamula Sositenesi, mkomi wa nyumba ya kudadavila, vamtovanga pawulongolu ya chitemela. Wala Galiu akafiwoneyi filongu afi chindu ha. ");
INSERT INTO ndj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pauli ayikalili vakali na vala yivajumilili kula Kolindu kwa majuva vatangalili. Pambeli avayitawulili, kayipaka muwatu kayenda Siliya pamu na Piliska na Akula. Aku Kenikilea amowili fwili shaki kwanongwa yapingili mweni. ");
INSERT INTO ndj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Vafikili Ifesu, Pauli avalekili pala Pilisikila na Akula pambeli Pauli ayendili munyumba ya kudadavila, vahimula na Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Vamuluvili ayikali nawu chipindi chitali nendu, lakini adayilili ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Paaveyi akuwuka kadeta, “Chapanga padayila danyisi kandi kwa yumwi.” Awukili Ifesu kwa watu. ");
INSERT INTO ndj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Meli yawolukili Kayisalia, Pauli ayendili Yelusalemu kulijambusha lila lipinga lya vandu limjumilili Kilistu, pambeli kayenda Antiyokiya. ");
INSERT INTO ndj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ayikalili aku chipindi chifupi, pambeli kayendelela na mwanja kupitila Galatiya na Fulugia kavataya moyu vanachuli vosi. ");
INSERT INTO ndj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Topi Muyawudi yumu, litawa lyaki Apolu, mlelwa wa Alekisandilia, afikili Ifesu, mundu ya manyili kuywanga, mweni amanyili unofu Mayandiku Vang'alili. ");
INSERT INTO ndj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mundu ayu avelili vamulagha deha ya Bambu na wula ndima yaki yaveli sakalamu, akandili kudeta na kuvalagha milandu minofu ya Yesu, mweni amanyili ubatishu wa Yohani mbatisha weka hela. ");
INSERT INTO ndj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Akandili kudeta kwa kugangamala munyumba ya kudadavila, hata Piliska na Akula pavampikanishili vamutolili kayawu, vamuhimulila deha ya Chapanga kwa chiganu nendu. ");
INSERT INTO ndj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Na padayilili kujabuka bahali kuyenda mbaka Akaya, valongu vamukuvilisha, vavayandikila vala vanachuli vamlaliki, mweni pafikili avatangili nesu vala vajumilili kala kwa usangi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nongwa avaweshili Vayawudi munu kwa vandu vosi, palangusha filongu fya Mayandiku va kucha Yesu ndi Kilistu. ");
INSERT INTO ndj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Chipindi Apolu avelili Kolindu, Pauli ayendili mwambu wa mlima wa fidunda, afikili Ifesu aku avawonili vanachuli vamu. ");
INSERT INTO ndj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Kavadasha, “Wuli mwapokilili Mfuki Mng'alili pamujumilili?” Vamuyangula, “Ng'odu hata twakalihela kupikanisha kucha kuna Mfuki Mng'alili.” ");
INSERT INTO ndj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kavadasha, “Ubatishu liki mwabatishiwili?” Vamuyangula, “Kwa ubatishu wa Yohani mbatisha.” ");
INSERT INTO ndj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pauli kadeta, “Yohani mbatisha abatishili kwa ubatishu wa kupomela, pavawombela vandu vamujumili mweni yula dayisi kumbeli yaki, ndi Yesu.” ");
INSERT INTO ndj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pavapikanishili afi, vabatishiwa kwa litawa lya Bambu Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pauli, pavavikilili kala mawoku vandu vala, Mfuki Mng'alili kavasunukila vala, vakanda kudeta kwa detelu henja na kulandula unjagila wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pavavalangiwili vaveli valulumi lilongu na vavili. ");
INSERT INTO ndj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kayingila munyumba ya kudadavila, kadeta kwa kugangamala kwa chipindi cha myesi mitatu, pawombana na vandu na kuvakwegha mumilandu ya wutwa wa kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lakini vamonga vaveli na lukilu, valema kujumila, vakanda kuywanga wafu kuyilata deha ya Bambu mulipinga lya vandu. Topi, Pauli kawuka kavaleka, kavatola pambali vanachuli vaki, pawombaneyi na vandu majuva vonda kubwalu ya mundu yumu litawa lyaki Tilanu. ");
INSERT INTO ndj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Milandu ayi yayendililili chipindi cha myaka mivili, hata Vayawudi na Vagiliki venikaya vonda va Asia valipikanishili chilongu cha Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chapanga agolili mihilu mikomi kwa kupitila Pauli. ");
INSERT INTO ndj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Vandu yivavelili vatami vatolili fitambala na yingwa sha chichuku sha Pauli vavayeghela vatami vawu pavagufyili matami vawu vawukili na finyamkela vavafuma. ");
INSERT INTO ndj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Vayawudi vamu yivavinga finyamkela vayelijili aku na aku pavayesha kutambula litawa lya Bambu Yesu kwa vala yivavelili na finyamkela, pavadeta, “Nguvawombela kwa litawa lya Yesu, yula Pauli yamlandula.” ");
INSERT INTO ndj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Vana saba va Sikewa, Mtambika mkomi wa Vayawudi, vavelili vamu wa vala yivagola nawula. ");
INSERT INTO ndj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lakini chinyamkela avayangulili, “Ndimumanya Yesu wuwowu ndimumanya Pauli, lakini yumwi mwavaghani?” ");
INSERT INTO ndj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pambeli yula mundu yaveli na chinyamkela kavajumbila nongwa avasidili liwovi. Na vala vana va Sikewa vatuvili kufuma nyumba yila chipula na vamema mivanga mumuvili yawu. ");
INSERT INTO ndj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kila mundu wa aku Ifesu, Muyawudi na Mugiliki vapikanishili filongu afi. Vonda valwangili, valijumilili litawa lya Bambu Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Vandu vatangalili vala yivajumilili Bambu vayihasha pamu, kudeta kwa vandu milandu yivagolili. ");
INSERT INTO ndj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Vamonga yivagolili milandu ya uhavi, vakungashili fitabu fyawu, vafinyanya motu, vandu vonda vafiwona. Kwa kukasha vaveli fikulinganila na mbiya migwala alufu milongu muhanu ya mbiya sha Malekani. ");
INSERT INTO ndj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kwa ndambu ayi chilongu cha Bambu lyakwilili kosi na kuva na liwovi nendu. ");
INSERT INTO ndj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Milandu ayi payipelili, Pauli alamulili kuyenda Yelusalemu kupitila Makedoniya na Akaya. Paghaveyi munjila adetili mundima yaki, “Pandiva kula, danyendi Loma.” ");
INSERT INTO ndj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kavalayisha vandu vavili vatangi vaki, veni vaveli Timotewu na Ilastu, vamlonguleli kuyenda Makedoniya na mweni asighalili Asia chipindi chitali. ");
INSERT INTO ndj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Chipindi achi kwafumbukili ndilingu ngomi aku Ifesu kwanongwa ya deha ya Bambu. ");
INSERT INTO ndj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kwaveli na mponda mbiya vamkemaya Demetiliu, mweni aveli na chichuku cha kusongola ming'omung'omu ya nyumba ya mlungu mdadala vamkemaya Alitemi. Mafundi vaki vamgolilili chichuku chapatili mbiya sitangalili. ");
INSERT INTO ndj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetiliu kavakungula ava pamu na vamonga vavelili na chichuku chichila, kadeta, “Yumwi valulumi, mumanya kucha ulundamali wa yufwi ukufuma muchichuku achi. ");
INSERT INTO ndj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ponopa mukulola na kupikanisha mwaveni milandu yagolili Pauli apa Ifesu hela ha, ila kosi Asia. Mweni kavagola vandu vaghalambuki na kujumila kucha milungu ayi yivagolili na vandu, ndi milungu ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","chichuku achi dachivi na litawa livipili. Ila chindu achi dachigoleki munyumba ya mlungu yivamkemaya mdala yaveli mkomi Alitemi, davalangiwi kucha chindu ha. Pambeli jumu shaki ayu sivelili Asia yonda na mlima wonda dasipeli!” ");
INSERT INTO ndj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pavapikanishili afi vakalala, vavika umatu, pavadeta, “Mkomi Alitemi wa Vaifesu!” ");
INSERT INTO ndj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mbwani yosi yamemili ndilingu, vatuva mbilu vayingila pavadingila, chipindi achi vavakang'ala Gayu na Alisitaku, venikaya va Makedoniya vaveli mumwanja pamu na Pauli. ");
INSERT INTO ndj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pauli padayileyi kuyingila pagati ya vandu, vanachuli vaki vamukanisha. ");
INSERT INTO ndj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Vakomi vamonga va Asia, vavelili vaghanja vaki, vavalayisha vandu vaki, pavamluva akotoo kuyenda kula kuvadingila misambu, dayivi ngondu kwa mweni. ");
INSERT INTO ndj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Chipindechi, vakawuteyi vamonga vavelili vakudeta chindu achi na vamonga chindu chila, yavelili ndilingu, mbaka lila likungashu lyatilingikili, mbaka vamonga vamanyila ha nongwa liki vayikungashili pamu. ");
INSERT INTO ndj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Topi Vayawudi vamugolili Alekisanda ayilangushi paulongolu, vandu vamu vayiholili ndi mweni. Topi Alekisanda kavapungila vandu liwoku, akadayileyi kuyitasha paulongolu ya lipinga lya vandu. ");
INSERT INTO ndj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lakini pavamanyili mweni ndi Muyawudi, vonda vawutila pamu kwa lishu limu, “Mkomi Alitemi wa Vaifesu!” Vayendelela kuwuta nawula masaa mavili. ");
INSERT INTO ndj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pambeli ndumindumi wa mbwani yila aweshili kuvagola vanyamali. Kavawombela, “Kila mundu wa Ifesu, kamanya kucha mweni ndi mdimi wa Vaifesu nyumba ya mlungu yivamkema Alitemi na mdimi wa lila ling'omung'omu liponikili kufuma kumbindi. ");
INSERT INTO ndj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kwahela mundu yalema milandu ayi. Topi munyamali, mukotoo kugola chindu chochosi ngajila kuyivavala. ");
INSERT INTO ndj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Muvayegha vandu ava, vangajila kuhija findu fya nyumba ngomi ya mlungu wetu mdadala awu kumjowola. ");
INSERT INTO ndj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Payiva Demetiliu na vagolafichuku vaki mani vana nongwa na vandu ava, kuchiveli chitemela na kwaveli vakomi va milima, vakuwesha kuvahigha. ");
INSERT INTO ndj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kucha muna milandu yingi, muyiyeghi kuchitemela cha milandu kucha ayi. ");
INSERT INTO ndj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwa findu figolikili nalelu, tungaweshili kuhighiwa kwanongwa tuyegha ndilingu. Kandi tuvahela cha kudeta nongwa liki tugola ndilingu mulipinga ali.” ");
INSERT INTO ndj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Padetili kala fila, kamalila likungashu. ");
INSERT INTO ndj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Milandu yila payipelili, Pauli avakemili pamu vala vanachuli, avakuvilishili kunda. Pambeli kavayitawula kawuka kayenda mbaka Makedoniya. ");
INSERT INTO ndj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Apitili milima yila akavakuvilisheyi ndima vandu kwa filongu fitangalili. Pambeli afikili Ugiliki. ");
INSERT INTO ndj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kweni ayikalili myesi mitatu. Payitandeyi mwanja wa Siliya, awonili kucha Vayawudi vavelili vakudayila kumgolela findu fya wafu, awonili awuyi kwa kupitila Makedoniya. ");
INSERT INTO ndj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Vandu ava vavelili vamkovekelili Pauli, Sopatu mwana wa Pilu kufuma Beleya na Alisitaku na Sekundusi na vandu va Tesaloniki na Gayu mundu wa Delibe na Timotewu pamu na Tukiku na Tilofimu vandu kufuma Asia. ");
INSERT INTO ndj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ila vandu vala vamlongulela kala vakamuvetileyi Tiloa. ");
INSERT INTO ndj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yufwi palipitili lijuva lya mibumunda yingajila simika, twayipakilili muwatu kufuma Filipi na mulijuva lya muhanu twafikili Tiloa. Aku twayikalili lijuma limu. ");
INSERT INTO ndj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lijuva lya kupumulila palumii vatanganikili kulya mibumunda yingajila kutayiwa simika, Pauli kayangwa na vandu mbaka pamandandu, kwanongwa akayilateyi kuwuka chilawu yaki. ");
INSERT INTO ndj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Chumbagati mutuvelili chaveli kumbindi, kwavelili niku sitangalili sikayakeyi pala patutang'anikeyi. ");
INSERT INTO ndj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Chijana yumu litawa lyaki Eutuku avelili kayikala padilisha chipindi Pauli akuyendelela kulandula. Eutuku akandili kusisila padokwa padokwa mbaka mbota simukamula, awili pasi kufuma kumbindi golofwa ya tatu. Vamusola asovili kala. ");
INSERT INTO ndj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pauli asunukili pasi, kagondama, kamukusikila na kudeta, “Mkotoo kuyipwelesha nongwa akali na unofu mugati yaki.” ");
INSERT INTO ndj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pambeli kakwela kandi kumbindi, kaketula libumunda, kalya. Kayendelela kulandula mbaka linyagogolu, pambeli kawuka. ");
INSERT INTO ndj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Vala vandu vamtolili yula msongolu mbaka kayaki aveli mnofu nakaka, vandu vadowoka dohoo. ");
INSERT INTO ndj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Yufwi twayipakilili muwatu twalongulili kuyenda Asu, kula tungamtolili Pauli, ndambu yalamulili mweni akadayileyi kufika kula kupitila kumlima. ");
INSERT INTO ndj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Topi, tutang'aniki nayu kula Asu, tumpakila muwatu, tuyenda Mituleni. ");
INSERT INTO ndj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kufuma aku twafikili Chiu chilawu yaki. Lijuva lya pili, twawolukili Samu na chilawu yaki twafikili Miletu. ");
INSERT INTO ndj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pauli avelili kayilata kuyendelela na mwanja kwa watu ngajila kupitila Ifesu ili akotoo kukelwa nendu aku Asia. Avelili akulopukesha kucha angaweshili kufika Yelusalemu kwa lihungu lya Pendikosti kucha yingaweshili. ");
INSERT INTO ndj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kufuma Miletu Pauli alayishili unjagila kwa vavaha va lipinga lya vandu yivamjumilili Kilistu va Ifesu vatanganiki na mweni. ");
INSERT INTO ndj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pavafikili vavaha avawombilili, “Mumanya ndambu yindiyikalili na yumwi majuva vosi kukandila lijuva lila lya kwaa pafikili mkowa wa Asia. ");
INSERT INTO ndj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mumanya ndambu yindimkimbanikilili Bambu kwa chigoyi chosi. Navelili muchipindi chidindalili kwa milandu ya ufyangu yivagolilili Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ndaweshili ng'odu kuyilyepa kuvalandulila chilongu chochosi cha kuvatanga, kuvalandulila pawelu na kaya shenu. ");
INSERT INTO ndj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ndivagayila unjagila Vayawudi na Vagiliki vapomeli sambi kwa Chapanga na kumjumila Bambu wetu Yesu. ");
INSERT INTO ndj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ponopa muloli, kunu pandimjumila Mfuki Mng'alili, ndiva mumwanja kuyenda Yelusalemu, manya ng'odu milandu dandang'aniki nayu kula. ");
INSERT INTO ndj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ila manya kucha Mfuki Mng'alili akungayika nenga mukila mbwani, kucha kuwopiwa na tabu fikumetela. ");
INSERT INTO ndj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lakini nenga chindu ha, ngiba goli chila chichuku chanyimbili Bambu Yesu malili nanduli milandu ya nyanyi ya usangi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Napitili kwa vayenu vamonga, vosi ndivalandulila wutwa wa kumbindi kwa Chapanga. Lakini ponopa manya kwahela hata mundu yumu dang'oni kandi. ");
INSERT INTO ndj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Topi nalelu nguvawombela kucha payaghamila muyenu yumu, mani mwaveni. ");
INSERT INTO ndj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nongwa ngangajila hata padokwa ha kuvawombela fyosi fyayilata Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mwivavali, mulidimi lipinga lila Mfuki Mng'alili lyavavikili yumwi muvi vadimi vaki. Mulidimi lipinga lya vandu yivamjumilili Kilistu, Chapanga avapatili kwa mwasi wa mwana mundu. ");
INSERT INTO ndj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Manya finofu munu kucha pambeli pang'uka nenga fingekembi vakali davavayanangi na davavi na lusungu ha na lipinga ali. ");
INSERT INTO ndj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hata vayenu vamu davafumbuki vandu davadeti milandu ya ufyangu ili kuvayaghamisha vandundami na kuvagola vavakovikeli veni hela. ");
INSERT INTO ndj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mloleyi kunu pamukumbuka kucha chipindi cha myaka mitatu majuva vosi ngutofya ha kuvakayika mwavosi kunu panila misosi pwaa. ");
INSERT INTO ndj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Topi, ponopa nguvavika mumawoku va Chapanga na kwa chilongu chaki cha usangi, mweni akuwesha kuvagola na kuvagayila mbala pamu na vala vonda yivaveli vaki. ");
INSERT INTO ndj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nenga ndavelili na luhujulu ha lwa mbiya na chumang'andu, wala yingwa sha mundu yoyonda. ");
INSERT INTO ndj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Yumwi mwaveni mumanya kucha gola chichuku kwa mawoku vangu ndimweni kuyipatila findu fyangu pamu na vayangu. ");
INSERT INTO ndj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kwa milandu yosi ndivalangusha kwa ngimbaniku ngomi na mukuwesha kuvatanga vasosuvafu na kukotoka kuyivasuwa filongu fya Bambu Yesu, ndambu yadetili, ‘Ngiba kutawula pitu kupokela.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pamalili kudeta afi katundama kadadava pamu na vosi. ");
INSERT INTO ndj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Vosi valila, vamkusikila Pauli na kamkola liwoku kumunonela. ");
INSERT INTO ndj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Vapatili lung'ong'u nesu kwa chilongu chavadetilili kucha davamuwoni kandi ha. Topi, vamyegha mbaka kuwatu. ");
INSERT INTO ndj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Patuyitawulili kala, twayipakili muwatu tuyenda mbaka Kosi. Chilawu yaki twafikili Lodi, kufuma aku twayendili mbaka Patala. ");
INSERT INTO ndj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kula twawuwonili watu wuvelili wukuyenda Foiniki, twipaka tuyenda. ");
INSERT INTO ndj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pambeli twafikili mahali paveli tukuwesha kuyiwona Kupilu, twapitilili kundamba yaki tulongosha kuchanya ya Siliya. Twawolukili mbwani ya Tilu vasunushi misiwu yivelili muwatu. ");
INSERT INTO ndj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kula tuvawona vandundami, tuyikala nawu majuva saba, veni vamuwombela Pauli kwa liwovi lya Mfuki Mng'alili akotoo kuyipakila kuyenda Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mbaka majuva vala pavafikili, twawukili na vandu vonda pamu na vadala vawu na vana vawu vatupelikeshili mbaka panji ya mbwani, tutundama muluwongu lwa bahali tudadava kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Patuyitawulili nawu, tuyipakila muwatu, veni vawuya kayawu. ");
INSERT INTO ndj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Yufwi twayendili Tilu mbaka Tolemaisi pala twavajambushili Vakilistu vayetu, twayikalili na veni lijuva limu. ");
INSERT INTO ndj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Chilawu yaki tuwuka tuyenda Kayisalia. Kula twayendili kayaki Filipu mulandula wa Chilongu cha Nyanyi. Mweni aveli yumu wa vala saba yivashawuliwili kula kukanisa lya vandu va Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Avelili na vana vadala mchechi yivavelili vakalihela kuhetiwa veni vavelili na chichuku cha kulandula unjagila wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Topi, twavelili tuyikala kula majuva vatangalili, mbuyi yumu litawa lyaki Agabasi afikili kufuma Yudeya. ");
INSERT INTO ndj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Atuyisilili katola lufunga lwa muchiwunu cha Pauli, kayikonga mawoku na mawulu, kadeta, “Mfuki Mng'alili kadeta naha, ‘Vayawudi kula Yelusalemu davamuwopi nahawu mundu yavelili na lufunga alu na damuhadiki kwa vangutungu va Vayawudi.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Topi patupikanishili afi, yufwi na vandu yivavelili mahali pala, twamuwombili Pauli akotoo kuyenda Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Lakini Pauli ayangulili, “Mukudayila kugola liki? Mukudayila kubalula mutwi nenga kwa misosi? Ndiva kala kuwopiwa muchijaka kula Yelusalemu weka hela ha, ila hata kusova kwanongwa ya Bambu Yesu.” ");
INSERT INTO ndj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Patulemwili kumudedeka twanyamalili, twadetili hela, “Chadayilili Bambu chigoleki!” ");
INSERT INTO ndj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Patuyikalili pala padokwa, twawopili misiwu ya mwanja, tuyendelela Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Vala vandundami vamonga va Kayisalia vayendili pamu na yufwi, vatuyegha kaya ya Mnasoni twavelili tukuyenda kuyikala pamu na mweni kwa chipindi. Mnasoni avelili mwenikaya wa Kupilu, avelili mkilistu kwa majuva vatangalili. ");
INSERT INTO ndj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patufikili Yelusalemu, Vakilistu kula vatuyangili nyanyi nendu. ");
INSERT INTO ndj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Chilawu yaki Pauli ayendili pamu na yufwi kumjambusha Yakobi na wuwowu vavaha vonda va vala Vakilistu yivavelili pamu. ");
INSERT INTO ndj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pambeli pavajambushili kala, Pauli avagotulilili milandu yosi yagolili Chapanga kwa vangutungu va Vayawudi kupitila undumindumi waki. ");
INSERT INTO ndj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pavapikanishili afi, vamjumila Chapanga, pambeli vamuwombela Pauli, “Mlongu, ukuwesha kuvawona Vayawudi Vakilistu ngenju ngenju vonda vana weyi nendu kwanongwa ya Malawu va Chapanga vamupili Musa. ");
INSERT INTO ndj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Veni vahimuliwa milandu yaku, kucha ukuvalagha Vayawudi vosi mumilima kumleka Musa, kuvawombela vakotoo kuvagola jandu vana vawu, wala kukovikela milandu yivashovililili. ");
INSERT INTO ndj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tugoli liki ponopa? Nakaka veni vapikanila kala kucha yuwi kwisa. ");
INSERT INTO ndj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Topi, goli ngimu yitukuwombela. Kuvaveli vandu mchechi yivavikili lilaghanu. ");
INSERT INTO ndj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wilumbi pamu na veni mudadawu ya kuying'alisha, kuhomba mbiya sidayiliwa, pambeli wuvamoghi fwili shawu. Topi vandu vonda davamanyi kucha filongu fila fivawombiliwili fiyilatili yuwi fyahela mana yoyonda na kucha umweni baha ukuyikala ngimu shaliya ya Malawu va Chapanga vamupili Musa wuvadeta. ");
INSERT INTO ndj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Lakini kwa milandu ya vandu va milima yosi yivamjumilili Kilistu tuvayandikila kala baluwa na highilu yetu, vakotoo kulya findu fyavatambikili ming'omung'omu ya kusongola na vakotoo kulanda mwasi na vakotoo kulya fibudu na vakotoo kugola uwoni.” ");
INSERT INTO ndj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Chilawu yaki Pauli avatolili vala vandu kagola dadava ya kwing'alisha pamu na veni. Pambeli kayingila Munyumba ya Chapanga kuvawombela kucha ndili dayivi mwishu wa kuying'alisha pamu na veni na matambiku davagoli kwa vandu vosi vala. ");
INSERT INTO ndj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Chipindi cha majuva saba pavaveghi samba vapela, Vayawudi yivavelili vakufuma mlima wa Asia vamuwonili Pauli munyumba ya Chapanga, vavatumishili lipinga lya vandu lyosi vawoni maya, vamukamula. ");
INSERT INTO ndj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Vawutili, “Yumwi valulumi Vayisilaeli! Mututangi. Mundu ayu yavawula vandu vosi kila mahali milandu yingajila kulinganila na mlima wetu na Malawu va Chapanga vamupili Musa na nyumba ayi ya Chapanga. Kandi, pawileka ayi, kavayingisha Vagiliki munyumba ya Chapanga, kapapighasha mahali apa pang'alili.” ");
INSERT INTO ndj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Vadetili naha nongwa vavelili vamuwona Tilofimu, Muifesu pamu na mweni kumbwani, vakacheyi Pauli kamuyingisha Munyumba ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kumbwani kosi kwakwilili ndilingu, vandu vayisili mbembu shonda, vamkamula Pauli, vamukukusha vamfumisha panji ya nyumba ya kudadavila na bahala pala milyangu ya nyumba ya kudadavila yitatiwa. ");
INSERT INTO ndj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Vayitandili kala kudayila kumuwulagha Pauli, lakini filongu fyamufikilili mkomi wa machonda wa Chilumi kucha Yelusalemu yosi yaveli yikwila ndilingu. ");
INSERT INTO ndj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kavatola machonda na vakomi vawu, kavayendela mbilu. Veni pavamuwonili mkomi va machonda na vamachonda vamleka Pauli kumtovanga. ");
INSERT INTO ndj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Pambeli mkomi wa machonda kaselela, kamkamula, kalayisha awopiwi kwa mingongola mivili, kadasha, “Ayu ghani? Na kagola chindu liki?” ");
INSERT INTO ndj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Vamonga mulipinga lila vakawuteyi vakadeteyi naha na vamonga naha. Mkomi wa machonda kalemwa kupata milandu ya nakaka kwanongwa ya umatu wula, kavalayisha vamuyeghi mugati ya luviwu. ");
INSERT INTO ndj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pauli pafikili mufikwelelu, machonda vawonili ngiba vamupapi kwanongwa ya ndilingu ya vandu. ");
INSERT INTO ndj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nongwa lipinga likomi lya vandu vamkovikelili na kuwuta, “Mumuwulayi!” ");
INSERT INTO ndj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pavamuyingisheyi muluviwu, Pauli aluvili kwa mkomi wa machonda padeta, “Nguwesha kukuwombela chindu?” Yula mkomi wa machonda kayangula, “Kumbi ukuwesha kuywanga Chigiliki! ");
INSERT INTO ndj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Yuwi yula Mumisili ndaa mwandi apa akandili ndilingu na kuvalongosha vatovilela elufu mchechi mbaka kucheja ng'odu!” ");
INSERT INTO ndj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pauli kayangula, “Nenga Muyawudi, ng'onekela Talisu kula Kilikiya, nenga mundu wa mbwani yimanyikili. Deku deku, ujumishi nywangi na vandu.” ");
INSERT INTO ndj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yula mkomi wa machonda kamjumisha. Pauli kawoloka muchikwenelu kavapungila liwoku vala vandu, pavanyamalili, akandili kuywanga nawu Chibulaniya. ");
INSERT INTO ndj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pauli adetili, “Yumwi valulumi, valongu vangu na vatati vangu, mumbikanishi, nguyitasha kwa yumwi ponopa.” ");
INSERT INTO ndj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pavapikanishili kucha akudeta nawu Chibulaniya vayendelela kunyamala. Pambeli kadeta, ");
INSERT INTO ndj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nenga mundu wa Vayawudi, ng'onikela aku Talisu mbwani ya Kilikiya, ila ngulila mbwani ayi, mumawulu va Gamalieli, vamanyili nyanyi Malawu va Chapanga vamupili Musa na va vambuyi vetu, ndayitawulili kwa ndima kwa Chapanga kucha yumwi vonda wumuvelili nalelu. ");
INSERT INTO ndj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ndivagobola na kuvawulagha vandu yivakovikeleyi njila ayi. Ndavakamulili valulumi na vadadala na kuvataya muchijaka. ");
INSERT INTO ndj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mtambika mkomi na vavaha va chitemela vosi vakutovilela chilongu achi. Veni vanyimbili baluwa vavayandikilili vala valongu vangu Vayawudi vavelili kula Damasku. Nyenda Damasku ili ndivakamuli vandu ava na kuvayegha mbaka Yelusalemu kunu vawopiwa ili vapati asabu.” ");
INSERT INTO ndj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Topi, pamelili mudeha pabehi ya Damasku, pamusi saa sita, ngesha ngomi kufuma kumbindi tepu yifumbuka yilangasha mbembu shosi. ");
INSERT INTO ndj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ndiva pasi, mbikanisha lishu paling'ombela, ‘Sauli Sauli! Wuli mbona ukugobola?’ ");
INSERT INTO ndj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nenga ndimudasha, ‘Bambu, yuwi ghani?’ Mweni kayangula. ‘Nenga Yesu wa Nasaleti. Ndi yiwugobola.’ ");
INSERT INTO ndj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Vala vayangu yivawonili yila ngesha, lakini vapikanishili ha lishu lya yula yaywangeyi na nenga. ");
INSERT INTO ndj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Topi, nenga ndimudasha, ‘Goli liki Bambu?’ Mweni Bambu kang'ombela, ‘Woloki, yendi Damasku na aku davakuwombeli fyosi fiwudayiliwa kugola.’ ");
INSERT INTO ndj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kwanongwa ya yila ngesha yaveli ngomi nola kandi ha, vala vayangu vanongosha kwa kungamula liwoku mbaka fika Damasku.” ");
INSERT INTO ndj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kula kwaveli na mundu yumu vamkemaya Ananiasi, aveli mundu yamumanyili Chapanga, akombikeshagha Malawu va Chapanga vamupili Musa na atundamiwili na Vayawudi yivavelili vakwiyikala Damasku. ");
INSERT INTO ndj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mweni ayisili kunola, kawoloka pabehi na nenga, kang'ombela, ‘Mlongu wangu Sauli! Loli kandi.’ Bahala pala nola kandi, ndimulola. ");
INSERT INTO ndj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Anania kadeta, ‘Chapanga wa vambuyi vetu kakushawula yuwi ili umanyi chadayila na kumuwona yula goleki na kulipikanisha lishu lifuma mumlomu yaki. ");
INSERT INTO ndj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nongwa dawuvi mtovilela waki kwa vandu vosi, kwa milandu ayi wuyiwonili na kupikanisha. ");
INSERT INTO ndj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Topi ponopa, ukuvetela liki? Woloki, ubatishiwi na uwushiwi sambi shaku na kulijumila litawa lyaki.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Pang'uyili kala Yelusalemu, padadaveyi munyumba ya Chapanga, ndalotili milotu. ");
INSERT INTO ndj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ndimuwona Chapanga, kang'ombela, ‘Lopukeshi wuki Yelusalemu, kwanongwa vandu va apa davajumili ng'odu pawuvatovilelili milandu ya nenga.’ ");
INSERT INTO ndj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nenga nyangula, ‘Bambu, ava vamanya kucha nenga ndavawopili na kuvatovanga vala yivakujumilili na ndayingilaya munyumba sha kudadavila shosi. ");
INSERT INTO ndj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na Stefwani mtovilela waku pawulayiwili, nenga ndavelili pabehi najumilili chilongu achi na kusidima yingwa shawu vala yivaveyi vakumuwulagha.’ ");
INSERT INTO ndj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mweni kang'ombela, ‘Yendi, nenga dandikulayishi uyendi kutali kwa vandu vangajila kuva Vayawudi.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Vampikanisha chilongu chila mbaka padetili nawula, lakini vawuta pavadeta, “Mumuwulayi! Nongwa akujakwa ng'odu kunana.” ");
INSERT INTO ndj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Vayendililili kudwelimuka kunu pavachihongwi chihongu mihabiti yawu na kutikula lifu kumbindi kwa maya, ");
INSERT INTO ndj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","yula mkomi wa machonda kalayisha vamuyeghi mugati ya luviwu lwa machonda, kadeta, mumulatuli ndomondu ili aweshi kumanya nongwa liki Vayawudi vakumuwutila. ");
INSERT INTO ndj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Pavamuwopili kala ili alatuliwi ndomondu, Pauli kamuwombela yula mkomi wa machonda yumu yawolukili pala, kadeta, “Wuli, Malawu vakujumisha kumulatula ndomondu mundu wa Loma ngajila kumuhigha?” ");
INSERT INTO ndj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yula mkomi wa machonda papikanishili afi, kamuwombela mkomi wawu, padeta, “Ukudayila kugola liki? Mundu ayu mwenikaya wa Loma!” ");
INSERT INTO ndj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Topi, mkomi wa machonda kamuyendela Pauli kamdasha, “Ung'ombeli, yuwi mundu wa Loma?” Pauli kamyangula, “Yina.” ");
INSERT INTO ndj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mkomi wa machonda kadeta, “Nenga wuwowu ndiva mundu wa Loma kwa kuhomba mahombu makomi.” Pauli kadeta, “Lakini nenga mundu wa Loma kwa kuwoneka.” ");
INSERT INTO ndj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Vala vandu yivavelili kala kwa kumudodosha Pauli vawukili. Hata yula mkomi wa machonda atilili pamanyili Pauli mundu wa Loma avelili vamuwopa na mingongola. ");
INSERT INTO ndj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Chilawu yaki, mkomi wa machonda akadayileyi kumanya vala Vayawudi chavadayileyi nakaka nongwa ya Pauli. Amuwoposolili Pauli lingongola, kalayisha vatambika vakomi na chitemela chosi vatang'ani. Pambeli kamuyegha Pauli, kamuwolosha pachitemela cha Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pauli akavaloleyi vala vaveli muchitemela, pambeli kakanda kudeta, “Valongu vangu, mbaka nalelu ndiyikala nyanyi ndambu yadayilili Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananiasi mtambika mkomi kavalayisha vala yivawolukili pabehi yaki vamtovi mbandi mumlomu. ");
INSERT INTO ndj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Topi Pauli kamuwombela, “Chapanga dakutovi yuwi mfyangu. Yuwi ukwikala ili kuhigha kucha wuvadeta Malawu va Chapanga vamupili Musa, lakini yuwi ukulayisha vandovi ngajila kukombikesha Malawu va Chapanga vamupili Musa?” ");
INSERT INTO ndj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Vala yivawolukili pabehi vadetili, “Wuli! Yuwi wukumjohola mtambika mkomi wa Chapanga!” ");
INSERT INTO ndj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pauli kadeta, “Valongu vangu ngamanyeyi ha kucha mweni mtambika mkomi, nongwa yiyandikiwa, ‘Ukotoo kumdetela ufyangu mtavala wa vandu vaku.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pauli pamanyili kucha lipinga limonga lya Masadukayu na lya pili lya Vafwalisayu, adetili kwa lishu likomi mugati ya chila chitemela, “Valongu vangu, nenga Mfwalisayu mwana wa Vafwalisayu, nenga vanyegha kuchitemela kwanongwa ngushuvilila kucha yivasovili davashukuki.” ");
INSERT INTO ndj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pamalili kudeta fila, pavelili malimbanu Vafwalisayu na Masadukayu, vavaghanika. ");
INSERT INTO ndj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nongwa Masadukayu vakudetaya kucha kwahela kushukuka wala makungu wala mfuki, ila Vafwalisayu vakujumila findu fyosi fitatu. ");
INSERT INTO ndj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pavelili na umatu diki. Vawula va Malawu va Chapanga vamupili Musa wa Vafwalisayu vawoloka na kudeta fyavawonili veni kwahilu, pavadeta, “Tuwona ng'odu chavifyili mundu ayu. Ila payiva mfuki awu makungu kadeta nayu liki?” ");
INSERT INTO ndj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Valeva ndewu ngomi, yula mkomi wa machonda ayipwelishili Pauli davamsatangi, kalayisha machonda vasunuki vakamtoli na kumuwuyisha mugati ya luviwu. ");
INSERT INTO ndj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Payifikili pamii, Bambu awolukili pabehi ya Pauli, katovilela, “Ugangamali! Kuvawombela milandu yangu apa Yelusalemu na aku Loma dawugoli wuwowu.” ");
INSERT INTO ndj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Chilawu yaki pamalavila, Vayawudi vatanganikili kwa lufisu. Vafingili, “Yufwi datuyikaji kulya na kulanda mbaka patumuwulayili kala Pauli.” ");
INSERT INTO ndj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Vandu vayongishekili milongu mchechi ndi yivafinga kugola wula. ");
INSERT INTO ndj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Veni vayenda kwa vatambika vakomi na vavaha, vadeta, “Tuyikaja kulya mbaka tumwulayi Pauli.” ");
INSERT INTO ndj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Topi, ponopa yumwi pamu na vavaha va chitemela mumuwombeli mkomi wa machonda amuyeghi pasi kwa yumwi, kucha mukudayila kumanya nendu milandu yaki na yufwi tuva kala kumuwulagha tanila ngajila kufika pabehi. ");
INSERT INTO ndj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mpwa mundu Pauli papikanishili filongu fila kayenda mugati ya luviwu, kamuwombela Pauli ndambu ya milandu ya vandu vadayilili kumuwulagha. ");
INSERT INTO ndj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Topi Pauli akemili machonda yumu, kamuwombela, “Umtoli mwananguta ayu umuyeghi kwa mkomi wa machonda, kana chindu cha kumuwombela.” ");
INSERT INTO ndj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Topi, machonda kamtola, kamyegha kwa mkomi wa machonda kamuwombela, “Pauli yula yawopiwili akangemili kanuva nguyegheli mwananguta ayu kwa yuwi kucha kana chindu cha kukuwombela.” ");
INSERT INTO ndj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yula mkomi wa machonda kamkamula liwoku vayisegha pambali, kamdasha kwa lufisu, “Kuna chilongu liki ukudayila kung'ombela?” ");
INSERT INTO ndj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kadeta, “Vayawudi vawombanila vakuluvi umuyeghi Pauli kuchitemela kunu pavayilyambishila kucha chitemela chikudayila kupata filongu fitangalili fimwilata mweni. ");
INSERT INTO ndj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Topi, yuwi ukotoo kujumila, kwanongwa vandu milongu mchechi na vamonga vamufukila, vafingana vakotoo kulya wala kulanda mbaka pavamuwulaghili kala, ponopa veni vava kala, vakukuvetela yuwi dawulamuli liki.” ");
INSERT INTO ndj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Topi yula mkomi wa machonda kamulayila akotoo kumuwombela mundu yoyosi kucha kanyeghela filongu afi, topi, kamuleka yula mwananguta ayendi. ");
INSERT INTO ndj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kavakema machonda vakomi vavili, kadeta, “Muvaviki ndemindemi vangandawu mya mbili vavi kala kuyenda Kayisalia na vangandawu yivakwela fwalasi milongu saba na va migoha mya mbili, vavi kala kuwuka kukali hela kufika saa tatu nalelu pamihi. ");
INSERT INTO ndj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mutandili fwalasi Pauli mumpaki na kumuyegha kungajila ndilingu kwa mkomi wa mkowa wa Yudeya yivamkema Filekisi.” ");
INSERT INTO ndj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Pambeli mkomi wa machonda kayandika baluwa naha, ");
INSERT INTO ndj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nenga Kilawudia Lisia ngukuyandikila yuwi muhishimiwa Filekisi, mkomi wa mkowa wa Yudeya. Hasi mkomi! ");
INSERT INTO ndj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mundu ayu vamukamulili Vayawudi, avelili padokwa vamuwulaghi, topi nyenda pamu na machonda ndimulowola pambikanishili kucha mweni aveli mundu wa Loma. ");
INSERT INTO ndj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nenga padayilili kumanya chindu liki chavadayileyi kumuhigha, nimusunusha na kumuvika pawulongolu ya chitemela. ");
INSERT INTO ndj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ng'ona kavahela nongwa yoyonda vamuhigha kwa Malawu vawu hela, wala kwa hela filongu fingi fya kumugola awulayiwi awu kumutaya muchijaka. ");
INSERT INTO ndj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pamanyili milandu ya kudayila kumuvikila ndilingu mundu ayu, tepu ndimuyegha kwa veni na nivalayila vala vamuhighili, vadeti milandu yaki kwa yuwi.” ");
INSERT INTO ndj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Topi, vala machonda vamutola Pauli kucha avalayilili, vamuyegha pamihi wuwula wula mbaka Ampatili. ");
INSERT INTO ndj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pamalavila machonda va mawulu vavaleka vala yivayipaka fwalasi vayendi pamu na veni, veni vawuya kukambi. ");
INSERT INTO ndj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Vala pavafikili Kayisalia, vamugayila bambu yila baluwa, vamuvika Pauli pawulongolu yaki. ");
INSERT INTO ndj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mweni payisomili kala, kavadasha Pauli aveli mundu wa mlima liki? Pavamuwombilili kucha aveli mundu wa Kilikiya, ");
INSERT INTO ndj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kadeta, “Dandikupikanishi yuwi pavayisa vala yivadayilili kukuhigha.” Kalayisha vamudimi Pauli munyumba ya mutwa Helodi. ");
INSERT INTO ndj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pavapitili majuva muhanu, mtambika mkomi Ananiasi, asunukili na vavaha vamonga pamu na mundu yavatanga vandu Malawu kuchitemela yivamukema Tetulu, veni vamuhimulilagha mkomi wa mkowa milandu ya Pauli. ");
INSERT INTO ndj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pauli akemiwili na Tetulu akandili kumuhigha, adetili naha, “Mkomi Filekisi, ulongoshi waku wa nyanyi wuyegha kusika nendu na magolikeshu va lasima vakugoliwa kwa unofu wa mlima wetu. ");
INSERT INTO ndj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Topi tukuchipokela chilongu achi kwa seku yonda na numbilu ngomi kwa yuwi Filekisi. ");
INSERT INTO ndj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lakini ngajila kutola chipindi chikomi munu, tukukuluva kwa usangi waku wutupikanishi padokwa. ");
INSERT INTO ndj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nongwa tumuwona mundu ayu kanyanyi ng'odu, mweni akukandishagha ndilingu gati ya Vayawudi kila mahali pamlimawu na wuwowu ndi mkomi wa chipinga cha Vanasaleti. ");
INSERT INTO ndj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kandi kayesha kuyiduka nyumba ya Chapanga, yufwi tumukamula. ");
INSERT INTO ndj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lakini Lisia mkomi wa machonda ayisili kumuwusha mumawoku vetu kwa liwovi. ");
INSERT INTO ndj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kavalayisha vala yivamuhighili vayisi kwa yuwi. Yuwi umdashi umweni dawupati milandu yosi yitumuhighila yufwi. ");
INSERT INTO ndj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Vayawudi na veni vamuhighili, vadeta, fyosi afi fyaveli nakaka.” ");
INSERT INTO ndj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Topi mkomi Filekisi kamujumisha Pauli adeti. Na mweni Pauli adetili, “Ngusekilela kuyitasha kwa yuwi manya yuwi kucha muhigha wa mlima awu kwa myaka yitangalili. ");
INSERT INTO ndj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ukuwesha kumanya vapita majuva lilongu na mavili hela ha, tangila nyendi Yelusalemu kumjuma Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Vayawudi vang'ona ng'odu pang'ombana na mundu yoyosi. Vang'onili ng'odu pandivatumishila vandu munyumba ya kudadavila, wala munyumba sha kudadavila shawu, wala mahali pengi mumbwanemu. ");
INSERT INTO ndj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Wala vaweshi ng'odu kutovilela fyavahighila nenga. ");
INSERT INTO ndj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Chijumila nenga kwa yuwi ndi achi: Nenga ngumujuma Chapanga wa vavaha vetu na nguyikala pangovikela deha yila veni vakwikema chipinga cha udesi. Ngufijumila filongu fyosi fyavayandikilili mufitabu fya Malawu va Chapanga vamupili Musa na vambuyi va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nenga ngumshuvilila Chapanga na veni vakumshuvilila wuwu, kucha vandu goleki na vawafu, davashukuki. ");
INSERT INTO ndj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Myanja yitangalili ngudayila kuva na ndima ya nyanyi kwa Chapanga na kwa vandu.” ");
INSERT INTO ndj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Pandiyikalili kutali kwa myaka yimonga, ng'uya Yelusalemu kuvayeghela yumwi mwayangu utangi na kutawula litambiku. ");
INSERT INTO ndj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Chipindi pagoleyi afi, ndi pavang'onili munyumba ya Chapanga, ndavelili pagolili kala yila dadavu ya kwing'alisha. Kwavelili kwahela lipinga lya vandu, wala ndilingu. ");
INSERT INTO ndj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lakini kwavelili Vayawudi vamonga kufuma Asia, ava vangavelili vavi apa kwa yuwi na kuyegha mahighu vawu mani leki vangavelili na chindu chochosi cha kudeta kwa nenga. ");
INSERT INTO ndj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Awu, wuvaleki ava yivavelili apa vadeti, chivawonili mifya chipindi pavang'olushili pachitemela chikomi, ");
INSERT INTO ndj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ila deta filongu afi hela, pang'olukili pawulongolu yawu, ‘Nalelu mukuhigha kwanongwa ya kudeta kucha yivasovili davashukuki.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filekisi mweni avelili kalimanya lipinga limkovikela Kilistu, asayikili filongu afi kavawombela, “Dahighi filongu afi chipindi Lisia mkomi wa machonda payisa apa.” ");
INSERT INTO ndj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pambeli kamulayila yula machonda yamuwopili Pauli muchijaka, ila vamupi upekesu padokwa na vaghanja vaki akotoo kuvakanisha kumuyeghela findu fyadayila. ");
INSERT INTO ndj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pavapitili majuva madokwa, Filekisi ayisili pamu na mdamundu Dilusila mweni aveli Muyawudi. Alayishili vamuyeghi Pauli, amupikanishili padeteyi milandu ya kumujumila Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lakini Pauli pakandeyi kudeta filongu fyaki fya milandu ya usangi na kuyisikisha padokwa na kwilata lijuva Chapanga davahighi vandu, Filekisi alwangili kayangula, “Ponopa yendi, nenga dandikukemi kandi pambata fwasi.” ");
INSERT INTO ndj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Chipindi chichila chila akashuvilileyi kupata swinda kwa Pauli, kwanongwa ayi amukemili myanja yitangalili paywanga na mweni. ");
INSERT INTO ndj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Myaka mivili payipitili, Polikiu Festu atavalili kufuma Filekisi, aveli mkomi wa mkowa. Kwanongwa Filekisi adayilagha kuyiwongola kwa Vayawudi, amlekili Pauli mumula mula muchijaka. ");
INSERT INTO ndj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Majuva matatu pavafikili kumukova, Festu afumili Kayisalia kayenda Yelusalemu. ");
INSERT INTO ndj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Vatambika vakomi pamu na vakomi va Vayawudi vamuwombilili filongu fivamuhighilili Pauli, vamudedeka Festu, ");
INSERT INTO ndj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","na kumdedeka atutangi mundoyu, ayeghiwi Yelusalemu, valya swinda ili vamukamuli na kumuwulagha mudeha. ");
INSERT INTO ndj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lakini Festu kayangula kucha, “Pauli dasighali muchijaka kula Kayisalia na nenga samba nyenda aku majuva vavava. ");
INSERT INTO ndj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Muvaleki vakomi venu vayendi aku pamu na nenga vakadeti fyavayihola kwa mundoyu leki kagola chindu chochosi cha wafu.” ");
INSERT INTO ndj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festu ayikalili na veni kwa majuva manani awu lilongu pambeli awuyili Kayisalia. Chilawu yaki ayendili kuchitemela, kalayisha Pauli ayeghiwi mugati ya chitemela. ");
INSERT INTO ndj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Chipindi Pauli pafikeyi, Vayawudi vavelili vafika kufuma Yelusalemu vamushengitela na kudeta uhighi utangalili wutawukili wungajila kuva nakaka. ");
INSERT INTO ndj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pauli adetili, “Nenga mifya chilongu cha Malawu va Chapanga vamupili Musa na va Vayawudi ha, wala cha nyumba ya kudadavila, wala cha Kayisali mutwa wa Loma.” ");
INSERT INTO ndj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Lakini Festu akadayileyi kuvatangila Vayawudi, kamuyangula Pauli kadeta, “Wuli, ukudayila kuyenda Yelusalemu, vakakuhighi kula kunu panukulola kwanongwa ya filongu afi?” ");
INSERT INTO ndj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pauli kadeta, “Nenga nguwoloka apa pawulongolu ya chitemela cha mutwa wa Loma, apa pandiyilatili kuhighiwa, kucha yuwi yiwumanyili nendu nenga mifya chilongu cha Vayawudi ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Topi payiva mifya Malawu, awu gola chindu cha kuhighiwa njifwa, nguluva ha kupomiliwa, ila kucha chindu chavahighila cha nakaka ng'odu, kwahela mundu yawesha kungamula. Ngiba ngahighiwi kuchitemela cha mutwa wa Loma.” ");
INSERT INTO ndj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Topi, Festu pamalilili kudeta na mundu va chitemela, kayangula, leki kudayila kuyenda kwa Kayisali! Topi dawuyendi kwa Kayisali. ");
INSERT INTO ndj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Majuva vamu pavapitili kala, mutwa Agilipa na Beliniki vafikili Kayisalia, kumjambusha Festu. ");
INSERT INTO ndj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Na pavayikalili kula majuva vatangalili, Festu kamuhimulila mutwa filongu fya Pauli, kadeta, “Kuna mundu yumu yalekiwili na Filekisi muchijaka. ");
INSERT INTO ndj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Panyendili Yelusalemu vatambika vakomi na vavaha va Vayawudi vang'ombela milandu yaki, vakadayileyi ndimuhighi njifwa. ");
INSERT INTO ndj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Lakini nenga ndavayangulili kucha chishovi cha vandu va Loma ha kumtawula ngajila kuhighiwa na vahighi vaki nju na kupata fwasi ya kuyitasha kwilata highu asi. ");
INSERT INTO ndj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Topi pavatang'anikili apa meta ha, ila lijuva lya pili ndiyikala muchigoda cha chitemela ndivalayisha vamuyeghi mundu yula. ");
INSERT INTO ndj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Na vala yivamuhighili pavawolukili vayegha filongu fingi fya wafu ha, kucha wundiyiholeyi, ");
INSERT INTO ndj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ila vavelili na minasha yitangalili yiilatili dadavilu yawu veni hela na milandu ya mundu yumu yakemiwa Yesu, yavelili kasova kala, lakini Pauli akamalili kudeta kucha munofu. ");
INSERT INTO ndj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nenga manya ha kucha ningapatili wuliwuli unakaka wa nongwa ayi, ndimudasha Pauli leki akudayila kuyenda Yelusalemu vakamuhighili aku filongu afi. ");
INSERT INTO ndj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lakini Pauli akaluveyi vakamuhighili kwa Kayisali, ndivalayila vamudimi mbaka pandimuyegha kwa mutwa wa Loma.” ");
INSERT INTO ndj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa kamuwombela Festu, “Nenga ngadayileyi wuwowu kumupikanisha mundu ayu.” Festu kayangula, “Dawumpikanishi chilawu.” ");
INSERT INTO ndj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Pamalavila Agilipa kayisa pamu na Beliniki pavayijuma na filumbi, vayingila pachitemela, pamu na machonda vakomi na vandu vakomi va mumbwani, Festu kalayila vakamuyeghi Pauli. ");
INSERT INTO ndj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festu kadeta, “Mutwa Agilipa na mwavosi yimuvelili pamu na yufwi, mumuwona mundu ayu, vandu va Wuyawudi vosi na aku Yelusalemu na apa wuwowu vadayila ndivatangi, vakawuteyi kucha akotoo kunana. ");
INSERT INTO ndj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Lakini nenga ngawoneyi kucha kagola chilongu cha kumugola ahighiwi njifwa ha na mweni padayileyi akamuhighi mutwa wa Loma, ngalamulili kumuyegha. ");
INSERT INTO ndj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Lakini bambu, nenga milandu yaki ndiva hela chilongu nakaka cha kumuyandikila. Topi, ndimuyegha pawulongolu yenu, kwa yuwi mutwa Agilipa, pawumudasha pambeli dambati chilongu cha kuyandika. ");
INSERT INTO ndj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwanongwa nguwona kwahela chindu cha mana kumuyegha muwopi ngajila kudeta nakaka chavifyili kwa mutwa wa Loma.” ");
INSERT INTO ndj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agilipa kamuwombela Pauli, “Ukuwesha kudeta filongu fyaku.” Apa Pauli awolushili liwoku lyaki kumbindi na kukanda kudeta, ");
INSERT INTO ndj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nguyiwona ngiba ndima yipwisuka, yuwi mutwa Agilipa nalelu nguhimula pawulongolu yaku, milandu yosi yivahighila Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kwanongwa ayi yuwi kumanya nendu chishovi cha Vayawudi na malimbanu vawu, ponopa ngukuluva wuyiwunishili umbikanishi.” ");
INSERT INTO ndj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Nongwa Vayawudi vosi vamanya ngalilu yangu tangila usongolu wangu, yavelili tangila pa kwandi kumlima wangu na aku Yelusalemu, ");
INSERT INTO ndj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Vamanyili nendu kukandila dahili na vakuwesha kutovilela, kucha ndaveli pakwandi ndayikalili kucha yumu wa chipinga chivelili na ujumilwa mkomi muujumilwa wetu, ndi chipinga cha Vafwalisayu. ");
INSERT INTO ndj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na ponopa nguwoloka apa highiwi kwanongwa ya kushuvilila jangi yavavapili vambuyi vetu vapatili kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Sheni siva jangi kwa makabila vetu lilongu na mbili vakulembelela kuyifikila, pavamujuma Chapanga nendu majuva vosi. Yuwi mutwa nenga dahighiwi na Vayawudi kwanongwa ya shuvililu ali! ");
INSERT INTO ndj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Yumwi yimuvelili apa nongwa liki mukuyihola yidindala kucha Chapanga akuvashukusha yivasovili?” ");
INSERT INTO ndj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Nakaka ndimweni ndiyiwona mundima yangu kucha gola findu fitangalili kulimba litawa lya Yesu wa Nasaleti. ");
INSERT INTO ndj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Filongu afi ndi figolili aku Yelusalemu. Nengapa weka ndi yimbatili uwesu kwa vatambika vakomi, ili ndivawopi muchijaka vandu vatangalili va Chapanga na veni vahighiwili kuwulaghiwa, ndagolili doo ya kujumila. ");
INSERT INTO ndj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Myanja yitangalili munyumba ya kudadavila shosi ndivalatula vandu na kuvang'ang'anika kumjowola Chapanga, ndivakalalila kucha ndaveli na lukwali, ndayigolili mkali hata mumbwani sha kuuhenja.” ");
INSERT INTO ndj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Topi, pandiveyi muchichuku ayi ngayendeyi Damasku, ndavelili na liwovi likomi vangayilili vatambika vakomi. ");
INSERT INTO ndj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Yuwi mutwa, pamelili mudeha yaveli lijuva lwa palundosi ng'ona ngesha kufuma kumbindi yapitili ngesha ya lijuva, yikamulikeyi nenga, pamu na vala yimelili nawu mbembu shosi. ");
INSERT INTO ndj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twawili pasi twavosi, mbikanisha lishu likudeta na nenga kwa Chibulaniya, ‘Sauli, Sauli! Nongwa liki ukugobola? Ukugobola kucha senga yadangula na liwulu lukweku lwa bambu waki.’ ");
INSERT INTO ndj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nenga dasha, ‘Bambu yuwi ghani?’ Na mweni Bambu kayangula, ‘Nenga Yesu, yiundesha. ");
INSERT INTO ndj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Topi chindu ha, ponopa tandamuki, woloki. Ndikufumbukila ili ndikugoli ndumindumi wangu na mtovileli. Dawuvawombeli vandu vamonga milandu yiwuyiwonili nalelu na yila yivelili yakali dandikulangushi. ");
INSERT INTO ndj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Dandikulowoshi kwa vandu va Isilaeli pamu na vandu vangajila kuva Vayawudi ngukulayishila kwa veni ponopa. ");
INSERT INTO ndj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Dawuvapwembuli mesu vawu na kuvagola vafumi mulwisa na kuyingila mungesha, vafumi muliwovi lya Lijangavandu na kumughalambukila Chapanga. Kwa ujumilwa wawu davaweshi kupomeliwa sambi shawu na kutola mahali pawu gati ya vala yivajumilili.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Mutwa Agilipa, topi nenga nemwa kuva na makuluhu kwa fila finangushiwili kufuma kumbindi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ila ndakandili kulandula kwa vandu va Damasku, pambeli kwa vala va Yelusalemu na mlima wosi wa Yudeya, kandi nyenda kwa vandu vangajila kuva Vayawudi. Ndivalayila vamughalambukili Chapanga na kulangusha kucha vapomela. ");
INSERT INTO ndj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwanongwa ayi Vayawudi vangamulili mugati ya nyumba ya Chapanga na vayeshili kung'ulaya. ");
INSERT INTO ndj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Topi Chapanga kandanga, mbaka nalelu ng'oloka uswanu nguvatovilela vosi vakomi na vadokwa. Fila fing'omba nenga ndi fila vambuyi va Chapanga na Musa vawombili dafiwoneki. ");
INSERT INTO ndj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Vadeta Kilistu agobuleki na mweni ghavi wa kwaa kushukuka munjifwa, ili alanduli kucha lwengi lwa ukombola lukuvang'alikila Vayawudi na vandu vangajila Vayawudi.” ");
INSERT INTO ndj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pauli pafikili apa mukuyitasha kwaki, Festu kalakala, “Pauli! Kuna lukwali! Kusoma koseku, kukutaya lukwali!” ");
INSERT INTO ndj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Lakini Pauli kadeta, “Mkomi Festu, Ndiva na lukwali ha. Ching'omba nenga chiva nakaka. ");
INSERT INTO ndj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Yuwi mutwa Agilipa kumanya milandu ayi, nongwa nguwesha kudeta ngajila lyova paulongolu yaku. Ndivahela lyogha kucha filongu afi fimanyika kwa yuwi nongwa chindu achi chigoleka pachifisu ha. ");
INSERT INTO ndj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mutwa Agilipa, wuli! Ukuvajumila vambuyi? Manya kucha yuwi ukuvajumila.” ");
INSERT INTO ndj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agilipa kamuyangula Pauli, “Ukwihola kucha kwa chipindi chidokwa hela dawugoli ndivi Mundu yindimjumilili Kilistu?” ");
INSERT INTO ndj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pauli kamuyangula, “Ngumuluva Chapanga kwa chipindi chidokwa awu chitali, yuwi weka hela ha, ila kwa vosi yivambikanisha nalelu vavi kucha nenga lakini ngajila mingongola.” ");
INSERT INTO ndj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mutwa Agilipa, mkomi wa mkoa, Beliniki na vala yivavelili pamu na mweni vawolukili. ");
INSERT INTO ndj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Pavawukili pala Agilipa na Festu vawombana, “Mundu ayu kagola chindu ha chimudayila kupata asabu ya kuwulayiwa awu kuwopiwa.” ");
INSERT INTO ndj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa awombili na Festu, mundu ayu angaweshili kulekisheliwa, leki angadayilili ng'odu kuyenda kwa Kayisali. ");
INSERT INTO ndj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Pavalamulili kuyenda mbaka Italiya, vamuvikili Pauli pamu na vandu vawopiwili pasi ya udimi wa Yuliu yavelili mkomi wa machonda, vavakemili, “Chipinga cha mutwa wa Loma.” ");
INSERT INTO ndj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Twayipakili watu wa Adilamitu wuvelili na mwanja wa kupitila kambi singi sha mkoa wa Asia, twakandili mwanja. Alisitaku, mwenikaya wa Makedoniya kufuma Tesaloniki, aveli pamu na yufwi. ");
INSERT INTO ndj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Chilawu yaki twafikili Sidoni. Yuliu amutangili nendu Pauli amujumishili kuyenda kuvalola vaghanja vaki, apati chadayilili. ");
INSERT INTO ndj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kufuma aku twapitili mumbalimbali ya Kupilu, kwanongwa liyegha lyatulimbili kuulongolu yetu. ");
INSERT INTO ndj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Pambeli twajabukili bahali ya Kilikiya na Pamfilia, tuwoloka Mila, mbwani ya Lukia. ");
INSERT INTO ndj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Apa yula machonda awonili watu wumu wa Alekisandilia uvelili ukuyenda Italiya, atupakilili. ");
INSERT INTO ndj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Twayendili mwanja mbolimboli kwa majuva vatangalili na yaveli mujibu kufika pabehi ya Nidu. Kwanongwa liyegha lyaveli likomi likutulimba, tuyenda ngajila kuwoloka tupitila mbembu ya Kileti pabehi ya kambi ya Salumoni, kweni kwaveli na liyegha lidokwa. ");
INSERT INTO ndj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twapitili mumbalimbali yaki kwa kudomba twafikili mahali pakemiwa “Kambi ya nyanyi,” pabehi ya mbwani ya Lesea. ");
INSERT INTO ndj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Chipindi chitali twayikalili pala na mwanja waveli mnofu ha kwanongwa yavelili yidindala kutyanga na watu, lijuva lya kuyikaja kulya lyaveli lipita kala, Pauli avadindashili ndima, ");
INSERT INTO ndj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mwavabambu, nguwona kucha mwanja awu dawuvi mnofu ha na misiwu dayidanganyiki pamu na watu hela ha, ila wuwowu hata yufwi tuva munjifwa.” ");
INSERT INTO ndj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lakini yula ofisa kampikana munu msola watu na muna watu pitu kumpikana Pauli. ");
INSERT INTO ndj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Na kwanongwa kambi yila yaveli nofu ha kuyikala chipindi chila cha lupepu, vandu vatangalili valuvili kuyendilela na mwanja, payiweshikana yifiki Foniki. Kucha pavawesha vafiki kambi ya Kileti na vayikali aku chipindi cha lupepu, yavelili mbembu ya Ughanji uhehi na Kuchanya uhehi. ");
INSERT INTO ndj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Topi, liyegha lidokwa kufuma kuvaghanji vakandili kupugha, veni vakacheyi chavayilateyi dachigoleki, vawopola watu vakanda mwanja vayenda mbaka pabehi ya Kileti. ");
INSERT INTO ndj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Tepu liyisa lingukumbi kufuma mwambu wa kundamba ya wuyighanji kuyenda kubahali, vakulikema “Liyegha lya ughanji.” ");
INSERT INTO ndj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Watu wabotiwili na lingukumbi na pawuweshili ngo'du kulimba, twawulekili usukumuliwi na lingukumbi. ");
INSERT INTO ndj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tulopukesha kupita pabehi na liwunguli lidokwa livalikema Kawuda, tuyesha kuukwegha watu wuvelili muwatu mkomi kwa kudomba. ");
INSERT INTO ndj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Pavaweshili kala, vayitanga kuuwopa watu kwa nyombu muwatu mkomi, veni vakatileyi kugwama mungema, veni vakukema, “Silati” vajabula midengi na vawuleka wula watu wuyendi na liwumbula. ");
INSERT INTO ndj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nongwa lila liwumbula lyavelili likutulimba nendu, lijuva lya pili vakanda kudanga misiwu yimonga mubahali. ");
INSERT INTO ndj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Lijuva lya tatu vadanga findu fya muwatu kwa mawoku vawu veni. ");
INSERT INTO ndj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Lijuva wala ndondwa shawonikili ng'odu kwa chipindi cha majuva vatangalili na liwumbula likomi litulimba, topi, tukashuvilileyi kandi ha kulowuliwa. ");
INSERT INTO ndj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Vavelili vayikala chipindi chitali ngajila kulya filivi, Pauli awolukili pagati yawu, kadeta, “Mwabambu, mungambikanishili nenga tungawukili ha kula Kileti na kupata tabu ayi na asala ayi. ");
INSERT INTO ndj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ponopa nguvawombela, muvi na ndima ngomi, nongwa kwahela hata mundu yumu gati ya yumwi dasovi, ila watu weka yaki dawuyaghamili. ");
INSERT INTO ndj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Lichu pamihi abwitukilili makungu wa Chapanga. Chapanga yula yavelili nenga mundu waki, ndi mweni yindimkimbanikila awolukili pabehi na nenga. ");
INSERT INTO ndj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Makungu kang'ombela, ‘Kotoo kutila Pauli, dawuyendi kuwoloka kwa Mutwa wa Loma, loli, Chapanga davakugayili vandu vonda yivaveli muwatu kwanongwa ya yuwi.’ ");
INSERT INTO ndj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Topi, yumwi mwavabambu, mukotoo kuyipwelesha, kwanongwa ngumujumila Chapanga, kucha dayivi wuwula kucha wang'ombilili. ");
INSERT INTO ndj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lakini datudangiwi muluwongu lwa liwunguli limoli.” ");
INSERT INTO ndj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Pamihi lijuva lya lilongu na mchechi, twavelili tukukukushiwa kunu na kunu mubahali ya Adiliya, payifikili mandandu vagola chichuku va muwatu vakacheyi kucha vava pabehi ya pamulima. ");
INSERT INTO ndj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Vakadayileyi kumanya utali wa machi kwa kudubushila luwoyi luveli lukongiwa chindu chisitapili, vapata utali wa mawoku milongu mchechi, pambeli vapima kandi vapata mawoku milongu mitatu. ");
INSERT INTO ndj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kwanongwa tutila ndula muupala, vadubushila myuma misitu mchechi kumbeli ya watu ili kupayika watu na vakadadaveyi kuchi kalopu. ");
INSERT INTO ndj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Vagolafichuku va muwatu vakadayileyi kutuva, vasunushili kala watu mdokwa mumachi, vakayilyambishileyi kudanga findu fisitu mumachi pawulongolu ya watu. ");
INSERT INTO ndj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lakini Pauli kamuwombela yula mkomi wa machonda na machonda vaki, “Kucha vagolafichuku ava va watu pavasighala ng'odu mugati ya watu, damulowuliwi ha.” ");
INSERT INTO ndj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Topi vala machonda vasidumula ngoyi siveli sikamulila wula watu mdokwa, vawuleka utoliwi na machi. ");
INSERT INTO ndj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Linyagogolu, Pauli avakuvilishili vonda valyi filivi kadeta, “Kwa majuva lilongu na mchechi mwaveli mukuyipwelesha na kuleka kulya, mkali hela kulya chindu. ");
INSERT INTO ndj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Topi, nguvaluva mulyi filivi nongwa mukudayila kunana. Kwanongwa hata lufwili lumu lwa mitwi yenu daluyaghamili ha.” ");
INSERT INTO ndj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pauli pamalili kudeta nawula, katola libumunda, kamulumba Chapanga pawulongolu ya vosi, kametula, kakanda kulya. ");
INSERT INTO ndj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Topi vonda vapata moyu na veni wuwu valya filivi. ");
INSERT INTO ndj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Twavelili vandu mya mbili na milongu saba na sita muwatu. ");
INSERT INTO ndj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kila mundu palili fivili vitangalili, vapungushili usitu muwatu vayasa fivelekwa mubahali. ");
INSERT INTO ndj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kukachi, vagolafichuku va watu vaweshili ha kuumanya mlima wula, ila vawonili lisopu, vakayiholili pavawesha vakapayiki pala. ");
INSERT INTO ndj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Vadumula sila ng'oyi sivakongileyi myuma misitu ya kuwolushela watu vasileka mubahali, topi vatola midengi ya kusolela watu ili vayendi kula kulisopu. ");
INSERT INTO ndj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lakini pawufikili pachimelu watu wagwamili. Mbembi ya kuulongolu yayingilili mulilundu lya muhanga, yikatikanyikeyi ha. Mbembi ya kumbeli ya watu yikakandeyi kumetuka mbiliwa mbiliwa kwa kubotiwa na liwovi lya majinga makomi. ");
INSERT INTO ndj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Machonda vakadayileyi kuvawulagha vafungwa vonda, vakatileyi davasuvili mbaka kumlima na kutuva. ");
INSERT INTO ndj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lakini yula mkomi wa machonda akadayileyi kumlowola Pauli, avakanishili vakotoo kugola nawula. Avalayishili vala vamanyili kusuvilila vajumbi kufuma muwatu na vasuvili mbaka kumwambu. ");
INSERT INTO ndj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Vamonga vavakovikeli pavayikamulila mimbalu awu mufipandi fya watu yimetukili. Nahawu ndi twawosi wutufikili kumlima vanofu. ");
INSERT INTO ndj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Patufikili kala kumlima, twamanyili lila liwunguli likukemiwa Malita. ");
INSERT INTO ndj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Venikaya va pala vaveli vasangi munu kwa yufwi. Ndonya yaveli yikukanda kutonya na kwavaveli na lupepu, topi vakoshili motu, vatulibushila. ");
INSERT INTO ndj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pauli asolili msiwu mdokwa wa ngilu avelili akusitaya pachikoshu, kwanongwa ya ukali wa motu wula, njoka afumili mungilu kamuluma Pauli muliwoku na kalemilela. ");
INSERT INTO ndj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Venikaya vala pala pavawonili njoka paning'ina muliwoku lya Pauli vayiwombela, “Ndina hoshu kucha mundoyu aveli kawulaya mundu. Hata leki kalowoka mubahali, lugotu lwa vamlungu dayimuleki ng'odu ayendileli kunana.” ");
INSERT INTO ndj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pauli kamupundila njoka yula mumotu na agobukili hata padokwa ha. ");
INSERT INTO ndj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Vala vandu vavelili vakashuvilileyi kucha angamemili awu bahala pala angawili na kusova. Pavavetili kwa chipindi chitali padokwa ngajila kuwona Pauli kagoliwa na chindu ng'odu, vaghalambula hoshu shawu kwa mweni, vadeta kucha mweni ndi chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Pabehi ya pala paveli na fitava fya mkomi wa liwunguli, litawa lyaki Pubiliu, mundoyu atulibushilili chilighanja, twaveli vahenja vaki kwa majuva matatu. ");
INSERT INTO ndj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Topi, tatimundu Pubiliu avelili kawonja pawulili, mtami, kana msusa na kupweka mwasi. Pauli ayingilili munyumba yaki, kadadava na kamuvikila mawoku vaki pambindi ya mtami, kamunanisha. ");
INSERT INTO ndj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Pachigolikili kala chindu chila, vatami vamonga yivavelili muliwunguli lila vayisa na vavagola vanani. ");
INSERT INTO ndj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Veni vatugayila fupu sitangalili na chipindi patukandili kandi mwanja, vapakishili findu fitudayilili muwatu. ");
INSERT INTO ndj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Payipitili myesi mitatu, twakandili kandi mwanja wetu muwatu wumu wa Alekisandilia wuvawukemaya, “Valongu mambila.” Watu wula wavelili upayikiwa muliwunguli lila chipindi chosi cha lupepu. ");
INSERT INTO ndj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kufuma kula twafikili mumbwani ya Silakusa, twayikalili apa kwa majuva matatu. ");
INSERT INTO ndj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kufuma kula Salakusa twashengitili mbaka tufika Legiu. Palipitili lijuva limu, liyegha lyakandili kupugha kufuma kuchanya na pavapitili majuva mavili twafikili kambi ya Potioli. ");
INSERT INTO ndj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kula twatang'anikili na Vakilistu vayetu, vatuluvili tuyikali nawu majuva saba nawula ndi wutufikili Loma. ");
INSERT INTO ndj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Vakilistu va kula Loma pavapikanishili milandu yetu, vayisili kutuyanga kusoku lya Apiu na mahali pavapakema, “Kumibudi Mitatu,” ya kulila na kuwonja. Pauli pavawonili amulumbili Chapanga, kasakapuka. ");
INSERT INTO ndj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Patuyingilili Loma, Pauli ajumishiwili kuyikala mweni weka yaki pamu na machonda yumu wa kumdima. ");
INSERT INTO ndj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pavapitili majuva matatu, Pauli avakemili vakomi va Vayawudi va mahali pala vatanganiki pamu, pavayikungashili, Pauli kavawombela, “Valongu vangu, nenga, ingava ndagolili ng'odu chindu cha wafu wala kulimba chishovi sha vavaha vetu, vang'opili muchijaka kula Yelusalemu na kuvikiwa mumawoku va vandu va Loma. ");
INSERT INTO ndj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Valoma pavadashili kala na kuwona ndivahela mbatiwa yoyonda, vakadayileyi kunekishela. ");
INSERT INTO ndj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lakini Vayawudi vamonga valimbili chindochi na nenga nuva milandu ayi yiyeghiwili kwa Mutwa wa Loma, ingava naveli na chindu ha cha kuvahigha vanamlima vayangu. ");
INSERT INTO ndj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Topi, kwanongwa ayi, nuva kutang'ana na kuywanga na yumwi, ng'opiwa mingongola ayi kwanongwa ya shuvililu lila lya Isilaeli.” ");
INSERT INTO ndj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Veni vamuwombela, “Yufwi tupata ha baluwa yoyonda yifumili Yudeya, wala kwahela mlongu yoyonda yafikili apa kuyegha chilongu cheni awu kudeta chochosi cha wafu chikwilatili yuwi. ");
INSERT INTO ndj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lakini tukuyihola yingavelili nyanyi tupikani kwa umweni filongu fivelili kumutwi yaku. Kwanongwa yufwi tumanya kucha chipinga achi chilimbiwa kosi.” ");
INSERT INTO ndj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Topi, vapangili na mweni lijuva lya kutang'ana na vandu vatangalili nendu vamutyangila kunyumba yayikalagha, kukandila pamalavila mbaka palumihi avahimulili na kuvavikila lipala wutwa wa kumbindi kwa Chapanga, akayesheyi kuvagola vajumili milandu ya Yesu kwa Malawu va Chapanga vamupili Musa na Mayandiku va Vambuyi va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Vandu vamonga vajumilili filongu fyaki, lakini vamonga vajumilili ng'odu. ");
INSERT INTO ndj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Topi, vaveli vavaghanika veni kwa veni. Pavaveghi vakuyenda, Pauli adetili chindu achi, “Nakaka fila Mfuki Mng'alili ndambu avawombilili vavaha venu kwa kupitila mbuyi wa Chapanga Isaya, ");
INSERT INTO ndj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","padeta, ‘Yendi kwa vandu ava ukavawombeli, kupikana damupikani, lakini damumanyi ha, kulola damuloli, lakini damuwoni ha. ");
INSERT INTO ndj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Nongwa mahala va vandu ava vapufika, vadiva majeji vawu, vagunya mesu vawu. Leki naha ng'odu, vangalolili kwa mesu vawu, vangapikanishili kwa majeji vawu. Vangamanyili kwa mahala vawu, na kung'alambukila akudeta Bambu, na nenga ningavalowulili.’ ” ");
INSERT INTO ndj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pambeli Pauli kadeta, “Topi, mumanyi unjagila wa Chapanga wa kulowola wuyeghiwa kwa vandu vangajila kuva Vayawudi. Veni davapikani!” ");
INSERT INTO ndj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Padetili kala afi, Vayawudi vawuka, pavalimbana munu veni kwa veni. Mayandiku ava vakuwoneka ha mufitabu fingi. ");
INSERT INTO ndj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kwa chipindi chonda cha myaka mivili ayikalili munyumba yapangili mweni na aveli akuvalibushila vosi yivafikili kumjambusha. ");
INSERT INTO ndj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Aveli akulandula wutwa wa kumbindi kwa Chapanga na kuvawula nendu milandu ya Bambu Yesu Kilistu, ngajila kutila na kwahela mundu yamukanishili.");
INSERT INTO ndj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nenga Pauli, mvanda wa Yesu Kilistu. Chapanga kasonyela kuva ndundami na kangema kulandula Chilongu chaki cha Nyanyi. ");
INSERT INTO ndj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Chilongu cha Nyanyi achi ndi chavajangili dahili vandu kupitila vambuyi vaki Mumayandiku Vang'alili. ");
INSERT INTO ndj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Achi Chilongu cha Nyanyi yichimwilata Mwana wa Chapanga, Bambu wetu Yesu Kilistu yawonikili kwa ndambu ya mvili, mulukolu lwa Dawudi, ");
INSERT INTO ndj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Kwa ushukushu, Mfuki Mng'alili amlangushili kwa liwovi kucha ayu Yesu Kilistu ndi Bambu Mwana wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kupitila mweni Chapanga atugayilili usangi tuvi vandundami kwa usangi wa Yesu Kilistu ili ndivalongoshi vandu va milima yosi vajumili na vakombikeshi. ");
INSERT INTO ndj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Yumwi wuwowu yimukemiwili muvi vandu va Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Na ponopa nguvayandikila mwavosi yumwi yimuvelili Loma yavatamili Chapanga na yimukemiwili kuva vang'alili vaki. Nguvaluvila usangi na kusika kufuma kwa Tati wetu Chapanga na Bambu wetu Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ngumulumba tanila Chapanga wangu kupitila Yesu Kilistu kwanongwa ya mwavosi yumwi, nongwa mlima wosi wupikanila ujumilwa wenu. ");
INSERT INTO ndj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Chapanga yindimkimbanikila kwa ndima yangu yosi kwa kulandula chilongu cha Nyanyi cha mwana waki, ndi mtovilela wa nenga kwa chila chinandula ndi nakaka. Mweni kamanya kucha nguvakumbuka, ");
INSERT INTO ndj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Chipindi chosi ngudadava. Ngumuluva Chapanga agoli nyisi kuvatyangila yumwi majuva vavava. ");
INSERT INTO ndj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kwanongwa ngudayila munu kuvawona yumwi, ili tuvaghani pamu na yumwi fupu ya chindima, ili mudindali. ");
INSERT INTO ndj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Chidayila kudeta ndi achi, twavosi yuwi na nenga twitangi muujumilwa kwa chipindi chimu, kila mundu kwa ujumilwa wa monga. ");
INSERT INTO ndj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Valongu vangu, ngudayila mumanyi, kucha myanja yitangalili ndadayilagha kuvatyangila yumwi, lakini kuna chindu chinimba. Ngadayileyi mbati vandu yivamkovikela Kilistu kufuma kwa yumwi kucha wundivapatili Vangutungu va Vayawudi vamonga. ");
INSERT INTO ndj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ndina nongwa kwa Vagiliki na vangutungu, yivapwembukili na vangajila kupwembuka, yivavelili na luhala na vangajila luhala. ");
INSERT INTO ndj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ponopa ngudayila munu kulandula Chilongu cha Nyanyi kwa yuwi yiwikala Loma. ");
INSERT INTO ndj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nguwona chindipa ha kulandula Chilongu cha Nyanyi, cheni ndi liwovi lya Chapanga yavalowola vandu vosi yivajumila. Yakwaa Vayawudi wuwula kwa Vagiliki. ");
INSERT INTO ndj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kwa ujumilwa Chilongu cha Nyanyi chikulangusha lipala hela ndambu Chapanga wavagola vandu kuva vasangi pawulongolu yaki, kukandila kwaa mbaka mbelu, ngimu wuyiyandikiwili. “Pambeli mundu dayigoli goleki kwa ujumilwa wa Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Maya va Chapanga kufuma kumbindi vasunukila uvifyi wawu na wafu wosi wa vandu yivawulimba unakaka. ");
INSERT INTO ndj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Chapanga davapi asabu, kwanongwa fyosi fidayileyi kumanyika kwilata Chapanga fiva lipala. Chapanga kafigola fivi lipala kwa veni. ");
INSERT INTO ndj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kukandila Chapanga palumbili mlima, uwesu waki wa jola na uchapanga waki, ukuwoneka kwa mesu kwa fila fyalumbili. Pambeli vandu davapati ha njila yoyosi ya kwitasha kwa chila chalumbili. ");
INSERT INTO ndj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Hata leki vamanya kuna Chapanga, vamujumili ha kucha mweni ndi Chapanga wala kumulumba, ila vayaghamilili muufyangu wawu na hoshu shawu sivelili na upufi sitayiwa chisi. ");
INSERT INTO ndj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Vakwijuma kucha vana luhunja kumbi vapufi. ");
INSERT INTO ndj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Valeka ukomi wa Chapanga yayikala jola, badili yaki vakovikela ukomi wa ming'omung'omu yivelili na chilangushilu cha vandu yivasova, vang'ongolu na vambongu na vang'ongolu yivakuluwuka. ");
INSERT INTO ndj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kwanongwa ya afi Chapanga avalekili mudobukelu sha ngunda shawu, vakovikeli wafu wawu, mbaka vayigolela milandu ya chindipa munjimba shawu veni kwa veni. ");
INSERT INTO ndj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Vawughalambulili unakaka wa Chapanga kuva udesi, vachigondamila chilumbi hela na kuchijuma badili ya Mulumbi yadayiliwa kujumiwa jola! Yina. ");
INSERT INTO ndj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Topi Chapanga avalekili vakovikeli dobukelu shawu sha chindipa. Hata vadadala valeka kutang'ana na valumi ngimu wuyivelili kukandila pamlima na vayifika veni kwa veni. ");
INSERT INTO ndj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Na valulumi na veni wuwowu vakuleka kugola ngimu Chapanga wavalumbili mlulumi na mdadala vakwidobukela valulumi kwa valulumi vakwigolela findu fya chindipa na kuyiyeghela veni asabu yidayiliwa kwa findu fyawu fya wafu. ");
INSERT INTO ndj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwanongwa vandu ava valemili kuva na Chapanga mumahala vawu, Chapanga avalekili vakovikeli mahala vawu vangajila kujakwa, vagoli fingajila kudayiliwa. ");
INSERT INTO ndj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Vamema kila chindu cha wafu, upoki, ubafu na ukwafyi. Vava na weyi, uwulaghi na ndewu na ujangi na natilu ya wafu na uhesi, ");
INSERT INTO ndj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","yivavelili na mbayishilu na yivamunyekwa Chapanga na vasugu na vangajila kukangajila na vavelili na chinyuku na yivagola findu fya wafu na vangajila kuvatundamila valeli vawu, ");
INSERT INTO ndj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","na vangajila luhunja na vangajila kugola jangi shawu na vangajila kuvatama valongu vawu na vangajila lusungu kwa vamonga. ");
INSERT INTO ndj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Na yivamanya nendu highilu ya Malawu va Chapanga, kucha yivadayiliwa njifwa. Kandi veni vagola afi hela ha, ila vakuvajuma vamonga kwa fila fivagola. ");
INSERT INTO ndj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Topi valongu vangu, damuweshi ng'odu kwitasha, yumwi yimuvahigha vayenu na chimuvahighila vayenu pambeli mukugola findu fifila fila fivagola mukwihigha mwaveni. ");
INSERT INTO ndj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tumanya kucha highilu ya Chapanga kwa vala yiva gola findu kucha afi ndi ya nakaka. ");
INSERT INTO ndj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Lakini yuwi ghanja yiwuvahigha vala yivagola findu fya wafu na yuwi ukugolagha wuwowu, wuli, ukwihola dawuyilyepi na highilu ya Chapanga? ");
INSERT INTO ndj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Awu pamonga ukuwubedala usangi waki mkomi na uwunilifu waki na luseku lwaki, ngajila kumanya kucha nakaka usangi waki Chapanga wukuwesha kukulongosha uweshi kupomela? ");
INSERT INTO ndj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Lakini kuva na udindalu na chinyuku cha ndima nahawu ukwiyandikila asabu kwa lijuva lila maya va Chapanga na highilu ya ugoleki dayiwoneki. ");
INSERT INTO ndj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Lijuva ali Chapanga damuhombi kila mundu ngimu wagolili. ");
INSERT INTO ndj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Vala yivakombikesha kugola fya usangi na kusaka ukomi na ndundamilu ya Chapanga na kungajila kusova, davapati unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Lakini vala vamonga yivavelili na milandu ya weka na vakulema findu finofu vakukovikela findu fya wafu, davawili chifuki na maya va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kugoboliwa na kutamika dakumpati mundu yoyosi yagola findu fya wafu. Dayivapati Vayawudi tanila pambeli Vagiliki wuwula. ");
INSERT INTO ndj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lakini Chapanga davapi ukomi na ndundamilu na kusika vala yivagola fya usangi. Vayawudi tanila pambeli Vagiliki wuwula. ");
INSERT INTO ndj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Nongwa Chapanga kana lushawu ha kwa mundu yoyosi. ");
INSERT INTO ndj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Vosi yivagola sambi davayaghamili hata leki vavamanya ng'odu Malawu. Na Vayawudi yivaveli na Malawu veni davahighiwi kwa Malawu vavava. ");
INSERT INTO ndj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Nongwa yiva ng'odu vala yivavapikana Malawu ndi vanyanyi ha pawushu ya Chapanga, ila vala yivakamula Malawu ndi davajumiliwi kuva goleki. ");
INSERT INTO ndj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kwa chilangushilu vangutungu va Vayawudi vavahela Malawu va Chapanga vamupili Musa, lakini kila pavagola fila Malawu yivadayila na kulongushiwa na natilu shawu, veni davavi chigelu cha Malawu hata leki vavamanya ha Malawu va Chapanga vamupili Musa. ");
INSERT INTO ndj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ngalilu yawu yikulangusha kucha Malawu vayandikiwa wuwowu mundima shawu. Ndima shawu sikulangusha wuwowu utovileli wa chilongu achi ndi nakaka, kwanongwa hoshu shawu chipindi chimonga sikuvahigha na chipindi chimonga sikuvakusikila. ");
INSERT INTO ndj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Topi, kwa Chilongu achi cha Nyanyi nenga nguchilandula, ndi dayivi chipindi Chapanga dahighi milandu ya chifisu ya vandu vosi kwa kupitila Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Yuwi wuli? Umweni ukuyikema Myawudi, ukukamula Malawu va Chapanga vamupili Musa na kwidumba kuva wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Kwa njila ya Malawu va Chapanga vamupili Musa ukumanya cha dayila Chapanga na ukuwesha kushawula milandu minofu, ");
INSERT INTO ndj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","yuwi nakaka ukwiwona kucha yavalongosha vangalimesu na ngesha ya vala yivavelili kuchisi, ");
INSERT INTO ndj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ukwiwona kucha muwula wa vapufi na vala vangajila kudindala. Kwanongwa yuwi kuna luhala na unakaka mumalawu. ");
INSERT INTO ndj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Topi yuwi ukuvawula vayaku, nongwa liki ukotoo kwiwula umweni? Ukuvalandulila vayaku vakotoo kuhija, lakini umweni ukuhija. ");
INSERT INTO ndj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ukudeta, “Mukotoo kugola uwoni,” kunu yuwi muwoni. Ukwinyekwa ming'omung'omu kunu yuwi ukuhija munyumba sha ming'omung'omu. ");
INSERT INTO ndj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ukudumba kucha kukamula Malawu va Chapanga, wuli, ukulola duhu kucha kwa kuvaleka Malawu vaki, ukumbedala Chapanga? ");
INSERT INTO ndj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kucha wula Mayandiku Vang'alili wuvadeta, “Vangutungu va Vayawudi, validuka litawa lya Chapanga kwanongwa yimugola yumwi Vayawudi!” ");
INSERT INTO ndj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kwingila jandu kwa yuwi dakuvi na mana pawuvakamula Malawu va Chapanga vamupili Musa. Lakini pawuvaleka Malawu, topi, ngiba ungayikalili ngajila kwingila jandu. ");
INSERT INTO ndj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Leki mundu yangajila kuva muyawudi paghava ngajila kwingila jandu pakombikesha Malawu va Chapanga vamupili Musa, ngiba angayikalili ngajila kwingila jandu. ");
INSERT INTO ndj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Vandu vangajila kwingila jandu davakuhighi yuwi Myawudi kucha pawuvaleka Malawu va Chapanga, hata leki kuva nawu mayandiku va Malawu na kwingila jandu, lakini veni vakuvakamula Malawu va Chapanga kunu vayingila ng'odu jandu. ");
INSERT INTO ndj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Tukuwesha ha kudeta, kucha mundu yawoneka kwa panji Myawudi ndi nakaka Myawudi. Mundu akuva Muyawudi ng'odu kwanongwa mweni kayingila jandu. ");
INSERT INTO ndj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Myawudi wa nakaka ndi yula yaveli Myawudi mundima, ngimu yula yayingilili jandu mundima. Achi ndi chichuku cha Mfuki wa Chapanga na chichuku cha mayandiku va Malawu ha. Mundu wa nahawu akujumiwa na vandu ha, ila akujumiwa na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Topi, Myawudi kana liki chamunu pitu vandu vamonga? Awu kwingila jandu kuna fwayida liki? ");
INSERT INTO ndj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Yina, kuna fwayida mwambu wosi. Yakwaa, Chapanga avapili Vayawudi lulayilayi lwaki. ");
INSERT INTO ndj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Lakini dayivi wuliwuli vandu vamu vangajila ujumilwa? Wuli chilongu achi dachiwushi ujumilwa wa Chapanga? ");
INSERT INTO ndj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ng'odu! Chapanga akusighala wa nakaka majuva vosi hata leki vandu vosi vafyangu. Kucha wula Mayandiku vang'alili wuvadeta, “Kila pawudeta, filongu fyaku fya ugoleki na muhighilu, yuwi ukuwesha” ");
INSERT INTO ndj_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Lakini payiva wafu wetu ukuwoneka kucha Chapanga goleki, datudeti liki? Wuli datudeti kucha kavahela haki patugayila asabu? Ng'odu, nguywanga kucha mundu. ");
INSERT INTO ndj_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Kwa ndambu ayi ha! Leki yingaveli nahawu, Chapanga angaweshili wuliwuli kuuhigha mlima? ");
INSERT INTO ndj_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Wuli nguhighiwa ndiva na sambi? “Nongwa ndivahela unakaka, chindu achi chikumugola Chapanga ghavi msangi munu na kumupa ukomi” ");
INSERT INTO ndj_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Yikulinganila na kudeta, tugoli fya wafu ili tupati fya usangi! Naha ndi vamonga wuvatujowulili na kutupayishila kucha tuvawula vandu nahawu. Davahighiwi ngimu wuvadayiliwa! ");
INSERT INTO ndj_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Tudeti liki? Wuli yufwi Vayawudi tuva vasangi pawushu ya Chapanga pitu vangutungu va Vayawudi? Hata padokwa! Kwanongwa nenga ng'ona kala mwanja mtasi, kucha Vayawudi na Vagiliki, vosi vapasi ya wutwa wa sambi. ");
INSERT INTO ndj_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ngimu wuvadeta mayandiku. “Kwahela hata yumu yavelili goleki, ");
INSERT INTO ndj_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","kwa hela mundu yamanyili, wala yamsaka Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Vosi vayaghamila vosi vavifya, kwahela yagola usangi, kwahela hata yumu. ");
INSERT INTO ndj_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Heleji shawu siva kucha sembi sivelili lipala, nimi shawu simema ujangi, mumulomu yawu mukufuma filongu fivelili na usungu kucha wa njoka. ");
INSERT INTO ndj_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Filongu fyawu fimema malapu makali. ");
INSERT INTO ndj_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Mawulu vawu vakutuvilila kuyita mwasi, ");
INSERT INTO ndj_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Kosi kuvayenda vakusaka njifwa na kugoboliwa, ");
INSERT INTO ndj_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Veni deha ya kusika vayimanya ha. ");
INSERT INTO ndj_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Pawushu yawu vakumtila ha Chapanga.” ");
INSERT INTO ndj_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ponopa tumanya kucha kila chindu chivelili Mumalawu chikuvawomba vandu yivaveli pasi ya Malawu vaweshi ng'odu ili vakotoo kuyilyambishila chindu na mlima wosi wuva pasi ya highilu ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nongwa kwahela mundu yagoliwa goleki pawulongolu ya Chapanga kwa kukamula Malawu. Chichuku cha Malawu kukulangushila hela mundu kucha kagola sambi. ");
INSERT INTO ndj_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lakini ponopa, ugoleki wa Chapanga yatugola vandu vasangi pawulongolu yaki yimanyika kala. Deha ayi yikwidumba Malawu kandi ha. Malawu va Chapanga vamupili Musa na mayandiku va vambuyi va Chapanga vakutovilela chindu achi. ");
INSERT INTO ndj_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Chapanga akuvagola vandu kuva vasangi pawulongolu yaki kwa deha ya ujumilwa wawu kwa Yesu Kilistu. Chapanga akugola nahawu kwa vosi yivajumila. Kwahela lushawu lolosi. ");
INSERT INTO ndj_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Vandu vosi vagola sambi na vayangiliwa ukomi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Lakini kwa fupu ya usangi wa Chapanga vandu vosi akuvagola kuva goleki pawulongolu ya Chapanga kwa deha ya Yesu Kilistu yavagombola. ");
INSERT INTO ndj_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Chapanga amtawulili Yesu ghavi litambiku, ili kwa mwasi waki, ghavi deha ya kuvawushila vandu sambi shawu kwa kumjumila mweni. Agolili nahawu ili alangushi kucha mweni goleki. Pakwandi Chapanga aveli akwiwunishila ngajila kulola sambi sha vandu. ");
INSERT INTO ndj_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Chipindi achi, ayitashili na sambi sha vandu ili alangushi ugoleki waki. Kwa ndambu ayi Chapanga mweni akulangusha kuva goleki na kumugola mundu yoyosi yivamjumila Yesu kuva goleki. ");
INSERT INTO ndj_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Topi, tukuwesha kuyidumbila liki? Kwahela! Nongwa liki? Wuli, kwanongwa ya kukola Malawu? Ng'odu! Ila kwanongwa tukujumila. ");
INSERT INTO ndj_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Chapanga akumgola mundu kuva goleki pawulongolu yaki kwa ujumilwa. Kwanongwa ha ya kukamula Malawu va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Awu, wuli, Chapanga wa Vayawudi weka yawu hela? Awu wa vandu va milima yosi wuwowu? Yina ndi Chapanga wa vangutungu va Vayawudi wuwowu. ");
INSERT INTO ndj_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Chapanga yumu hela, mweni davagoli Vayawudi kuva goleki kwa ujumilwa wawu na vangutungu va Vayawudi wuwowu kwa ujumilwa wawu. ");
INSERT INTO ndj_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Wuli, tukugola ujumilwa ughalambushi Malawu? Ng'odu, ila tukuvagayila Malawu vatalami nakamu. ");
INSERT INTO ndj_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Topi tudeti ndambu liki chimwilata tati wetu Ibulahimu? ");
INSERT INTO ndj_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kucha Ibulahimu agoliwili kuva goleki pawulongolu ya Chapanga kwanongwa ya chichuku chaki, topi, mweni kana chindu cha kuyidumbila lakini kwa Chapanga ha. ");
INSERT INTO ndj_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kwanongwa Mayandiku vang'alili vakudeta, “Ibulahimu amjumilili Chapanga. Kwanongwa ya ujumilwa waki Chapanga amgolili kuva goleki pawulongolu yaki.” ");
INSERT INTO ndj_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mgola chichuku akuhombiwa ijala yaki. Ijala yaki fupu ng'odu ila akudayiliwa kupokela chindu chiutunga. ");
INSERT INTO ndj_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Lakini vandu yivayidumbila ng'odu fivagolili veni, vakumjumila Chapanga yavapomela vawafu, topi, Chapanga akwilenga ujumilwa wa vandu ava, akuvagola kuva goleki pawulongolu yaki. ");
INSERT INTO ndj_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dawudi akudeta naha kwa seku ya yula mundu yanemiliwili na Chapanga kucha goleki ngajila kuyihola fila fyagolili. ");
INSERT INTO ndj_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Vanemiliwi vala yivapomiliwili wafu wawu, sambi shawu sigubikwa. ");
INSERT INTO ndj_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Anemiliwi mundu yula Bambu daasiviki ng'odu sambi shaki mungumbungumbu.” ");
INSERT INTO ndj_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ayi kwa vadumulili jandu weka hela, awu na kwa vala vangajila kudumula jandu? Kwa vala vangajila kwingila jandu wuwowu. Kwanongwa twadetili kala, “Ibulahimu ajumilili na mweni Chapanga kamunemela kucha goleki.” ");
INSERT INTO ndj_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Wuli, Ibulahimu ajumiliwili ngajila tanila kwingila jandu awu payingilili kala jandu? Ngajila tanila ya kwingila jandu payingilili kala ha. ");
INSERT INTO ndj_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ibulahimu ayingilili jandu pambeli, kwingila jandu kwavelili chilangushilu cha kucha Chapanga amujumilili kuva goleki kwanongwa ya ujumilwa waki waveli nawu akali kwingila jandu. Ponopa Ibulahimu kava tati wa vala vosi vangajila kwingila jandu, yivamujumila Chapanga vagoliwa kuva vagoleki. ");
INSERT INTO ndj_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Wuwula wula mweni ndi tati wa vala yivayingilili jandu, vala yivayingila jandu weka ha, ila vakwikovikela njila yiyila yila ya ujumilwa wa tati wetu Ibulahimu yakovikelili paghaveyi akali hela kwingila jandu. ");
INSERT INTO ndj_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Chapanga amjangili Ibulahimu na chileli chaki kucha mlimawu wungaveli wawu. Jangi yagolikili kwanongwa ya Ibulahimu kukamula Malawu ha, ila kwanongwa ya ujumilwa, mweni agoliwili kuva goleki pawulongolu ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Leki jangi ya Chapanga davapati vala weka yivakamula Malawu, topi, ujumilwa chindu ha na jangi ya Chapanga chindu ha. ");
INSERT INTO ndj_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Sambi yikuyegha chifuki cha Chapanga, lakini leki kwahela Malawu dawuweshi ha kugola sambi. ");
INSERT INTO ndj_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Vala yivaveli mujangi ayi vakwidumba ujumilwa, topi, jangi yikuva kwa usangi wa Chapanga hela na nakaka jangi yivayilata vosi, kwa vala yivakamula Malawu weka ha, ila na kwa vala yivavelili na ujumilwa kucha Ibulahimu. Mweni ndi tati wetu twavosi. ");
INSERT INTO ndj_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Mayandiku vang'alili vakudeta, “Nguvika wuvi tati wa milima yitangalili.” Jangi ayi ndi nakaka cha pawushu wa Chapanga yamujumilili Ibulahimu, Chapanga yavapa unofu yivasovili na alayilili findu fila fingajila kuva fivi. ");
INSERT INTO ndj_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ibulahimu ajumilili kunu kwavelili kungajila shuvililu na ndambu ayi kava tati wa milima yosi kucha Mayandiku Vang'alili wuvadeta, “Valeli vaku davavi vatangalili kucha ndondwa!” ");
INSERT INTO ndj_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Avelili mgogolu wa myaka mya naha, lakini ujumilwa waki wadohukili ha hata padokwa kunu ayiholili mvili waki kucha livawu likomoka na Sala mdala wa Ibulahimu aveli mbendi. ");
INSERT INTO ndj_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ibulahimu avelili na hoshu ha na yila jangi ya Chapanga, apatili liwovi kwanongwa ya ujumilwa wa Chapanga na amupili ukomi Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Amanyili nakaka kucha Chapanga akuwesha kugola fila fyavajangili. ");
INSERT INTO ndj_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ndi nongwa Chapanga amujumilili kucha goleki. ");
INSERT INTO ndj_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Pavadeta kucha, “Ajumiliwili kuva msangi” kwanongwa ya mweni weka yaki hela ha. ");
INSERT INTO ndj_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Chilongu achi chikutwilata na yufwi wuwowu yitumjumilili Chapanga yamushukushili Bambu wetu Yesu munjifwa. ");
INSERT INTO ndj_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Mweni atawuliwili awulayiwi kwanongwa ya sambi shetu, pambeli kashukushiwa nongwa atugoli yufwi tuvi vagoleki pawushu ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ponopa tugoliwa kuva vagoleki kwa ujumilwa, topi, tuva na kusika na Chapanga kwa njila ya Bambu wetu Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kwa ujumilwa wetu, mweni katuyegha munemusi ayi ya Chapanga ponopa tukwikala. Topi, tukusekilela shuvililu ayi yituvelinayu kuva pamu muukomi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Yina, afi weka ha, ila tukusekilela wuwowu mutabu tukumanya kucha yikutuyegha muuwunilifu, ");
INSERT INTO ndj_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","na kujumiliwa Chapanga ukutuyegha muujumilwa wa Chapanga na unakaka wukuyegha mushuvililu. ");
INSERT INTO ndj_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Shuvililu ayi yiweshi ha kutugola tulepisiwi, kwanongwa Chapanga katupungulila kala mundima shetu utami waki kwa deha ya Mfuki Mng'alili yatusangilili. ");
INSERT INTO ndj_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Patuveyi twahela mundu wa kututanga kuwuka mu sambi, chipindechi, Kilistu afwili kwanongwa ya yufwi vawafu. ");
INSERT INTO ndj_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Yipusuka ha kwa mundu kusova kwanongwa ya mundu yaveli goleki, pamongapa mundu akuwesha kusova kwanongwa ya mundu msangi. ");
INSERT INTO ndj_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lakini Chapanga katulangusha kucha katutama, kwanongwa patuveyi tukalihela mu sambi, Kilistu asovili kwanongwa ya yufwi. ");
INSERT INTO ndj_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kucha ponopa tugoliwa vagoleki kwa mwasi wa Kilistu nakaka nendu kucha datulowoki na maya va Chapanga kupitila mweni. ");
INSERT INTO ndj_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kwanongwa patuveyi tukali hela vachimdwama vaki, Chapanga atujovanishili na mweni kwa njifwa ya mwana mundu. Ponopa tujovanishiwa na mweni nakaka nendu datulowuliwi kwa unofu wa Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Afi hela ha, ila tukusekilela wuwu Muchapanga kwa deha ya Bambu wetu Yesu Kilistu yatugolili tujovi na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kupitila Adamu, sambi yayingilili mumlima, yeni yiyegha njifwa. Topi njifwa yikwila kwa vandu vosi, kwanongwa vosi vagola sambi. ");
INSERT INTO ndj_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Malawu pavaveghi vakali hela kwisa, sambi yavelili mumlima, lakini sambi yikuvikiwa mungumbungumbu ha ngajila Malawu. ");
INSERT INTO ndj_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Lakini kukandila chipindi cha Adamu mbaka cha Musa, njifwa yavatavalili na vala vangajila kugola sambi kucha yila ya Adamu, ya kumvifya Chapanga. Adamu avelili chilangushilu cha Kilistu yayisili pambeli. ");
INSERT INTO ndj_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lakini wafu wa Adamu wulinganila ha na usangi wa Chapanga. Kwanongwa, ngimu sambi ya mundu yumu yiyegha njifwa kwa vandu vosi, kwa utangi wa mundu yumu, ndi Yesu Kilistu, Chapanga kavayongishela vosi usangi na fupu shaki. ");
INSERT INTO ndj_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kuna kafwauti gati ya fupu ya Chapanga na sambi ya yula mundu yumu. Kwanongwa pagolili kala wafu mundu yumu yula, Chapanga amuhighili, lakini pavagolili wafu vandu vatangalili, Chapanga avapili fupu yaki kwa kuvagola vagoleki. ");
INSERT INTO ndj_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Nakaka kwa sambi ya mundu yumu njifwa yakandili kukwila kwanongwa ya mundu yumu ayu, lakini ndi nakaka nendu kucha chagolili yula mundu yumu, Yesu Kilistu ndi chinofu munu. Vosi yivapokela usangi na fupu ayi ya kugoliwa kuva goleki, davatavali muunofu kwa deha ya ayu yumu, ndi Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Topi livifyu lya mundu yumu yiyegha highilu kwa vandu vosi, wuwula wula usangi wa mundu yumu wuyegha ugoleki kwa vandu vosi na kuvapa unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Na kucha lukilu lwa mundu yumu vandu vatangalili vagoliwili vana sambi, wuwula wula kupikana kwa mundu yumu dakuvagoli vandu vatangalili vavi vagoleki pawulongolu ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Malawu vayisili, kugola findu fya wafu fiyongisheki, lakini sambi payiyongishekili, usangi wa Chapanga wayongishekili nendu. ");
INSERT INTO ndj_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Kucha wula sambi yikutavala kwa njifwa, wuwula wula usangi wukutavala kwa ugoleki wa Chapanga na kuyegha unofu wa jola kwa njila ya Bambu wetu, Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Topi tudeti liki? Wuli, tuyendileli kusighala mu sambi ili usangi wa Chapanga uyongisheki? ");
INSERT INTO ndj_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ng'odu! Yufwi mumilandu ya sambi tusova, datuyendileli wuliwuli kugola sambi? ");
INSERT INTO ndj_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nongwa mumanya kucha vosi yitubatishiwili tukwilumba na Yesu Kilistu, twabatishiwili na kwilumba munjifwa yaki. ");
INSERT INTO ndj_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Patubatishiwili mumachi tuva pamu na mweni munjifwa yaki, yavelili kucha tusikiwa pamu na mweni, ili Kilistu pashukushiwili kwa vasovili kwa chindu chikomi chagolili Tati na yufwi wuwowu twikali ngalilu ya shonu. ");
INSERT INTO ndj_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kwanongwa kucha yufwi twaveli twilumba na mweni munjifwa, wuwowu datuvi pamu na mweni kwa kushukushiwa kwa yivasovili kucha mweni. ");
INSERT INTO ndj_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tumanya kucha ngalilu yetu ya dahili yivangiliwa pamu na Kilistu munjifwa yaki, ili liwovi lya ngalilu ya mvili wuvelili na sambi uyanangiwi, tukotoo kuva kandi vavanda va sambi. ");
INSERT INTO ndj_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kwanongwa vandu yivasovili pamu na Kilistu, valekisheliwa mu sambi. ");
INSERT INTO ndj_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Topi, payiva tusova pamu na Kilistu, tukujumila kucha datwikali pamu na mweni. ");
INSERT INTO ndj_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kwanongwa tumanya kucha Kilistu kashukushiwa kala munjifwa, dasovi kandi ha. Njifwa dayimtavali kandi ha. ");
INSERT INTO ndj_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Topi, kwanongwa asovili mwanja wumu hela, sambi yivahela liwovi kandi kwa mweni, ponopa akwikala ngalilu yaki yimu na Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Wuwula wula yumwi mwiholi kucha musova kwanongwa ya sambi, lakini pamwikala kwa lighanja na Chapanga kwa njila ya Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ponopa, sambi yikotoo kututavala kandi njimba shenu yisisova na kusileka dobukelu shaki. ");
INSERT INTO ndj_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Topi mukotoo kuuleka mwambu wumu wa mvili waku wuvi kucha chindu cha kugolela sambi. Badili yaki, muyitawuli mwaveni kwa Chapanga kucha vandu yivashukushiwili munjifwa. Mutawuli fuki shenu shosi kwa Chapanga kwanongwa ya ugoleki. ");
INSERT INTO ndj_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Sambi dayivatavali kandi ha, nongwa muva pasi ya Malawu va Chapanga ha, ila pasi ya usangi wa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Topi, tudeti liki? Wuli, tugoli sambi kwanongwa tuvapasi ha ya Malawu, ila pasi ya usangi? Hata padokwa! ");
INSERT INTO ndj_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mumanya kucha pamwitawula mwaveni baha kucha vavanda na kumpikana tunga. Mukuva nakaka vavanda vaki mundu ayu awu vavanda va sambi yeni yitulongoshi munjifwa, awu tumjumili Chapanga atuviki tuvi goleki. ");
INSERT INTO ndj_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Hata leki dahili mwavelili vavanda va sambi, lakini ponopa ngumulumba Chapanga kucha kukombikesha ng'ulilu yiwupatili. ");
INSERT INTO ndj_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mwalowuliwili muuvanda wa sambi, muva vavanda va ugoleki. ");
INSERT INTO ndj_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Apa ngudeta ng'ombelu ya majuva vosi ya vandu kwanongwa ya usosuvafu wenu muuvanda. Ngimu wula chipindi chiwutunga mwakoliwili kukimbanikila wafu, wuwowu ponopa mukoliwa na ndima shenu mwaveni kukimbanikila ugoleki kwanongwa ya ung'alili. ");
INSERT INTO ndj_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Pamuveyi vavanda va sambi mwaveli kutali na ugoleki. ");
INSERT INTO ndj_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ponopa mwapatili fwayida liki majuva vala mufindu fila fimufiwonela chindipa ponopa? Na fwayida ya findu afi ndi njifwa! ");
INSERT INTO ndj_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Lakini ponopa mugombuliwa kala muuvanda wa sambi na muva vandumindumi va Chapanga, fwayida yimuveli nayu ponopa ndi ung'alili na kwa afi datupati unofu wa jola. ");
INSERT INTO ndj_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwanongwa ijala ya sambi ndi njifwa, lakini fupu yatawula Chapanga ndi unofu wa jola mukwilumba na Yesu Kilistu, Bambu wetu. ");
INSERT INTO ndj_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Valongu vangu, pangajila hoshu damufimanyi afi, kwanongwa nguvahimulila vandu yivamanyili Malawu. Malawu vakumtavala mundu chipindi chosi cha ngalilu. ");
INSERT INTO ndj_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kwa chilangushilu, mdadala yahetiwili akuwopiwa na Malawu chipindi chosi bambu mundu paghava akali mnofu, lakini bambu mundu pasova mdadala ayu akuwopiwa kandi ha na Malawu. ");
INSERT INTO ndj_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Topi mdadala ayu patyanga na mlulumi wingi chipindi bambu mundu akali hela mnofu, dakemiwi muwoni, lakini bambu mundu pasova daghavi pekesu mumalawu na pahetiwa na mlumi wingi akuva muwoni kandi ha. ");
INSERT INTO ndj_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Wuwula wula mwavalongu vangu, yumwi wuwowu musova kwa Malawu kwanongwa yumwi muva lubali lwa mvili wa Kilistu. Ponopa muva va mweni yashukushiliwi kwa yivasovili ili tuweshi kuveleka fivelekwa finofu kwanongwa ya Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nongwa patwikalagha chimvili hela, dobukelu ya kugola sambi yakuvilishiwili na Malawu, yagolili chichuku mumivili yetu na kubena fivelakwa fya njifwa. ");
INSERT INTO ndj_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Lakini ponopa tuva pekesu mufiwopu fya Malawu, kwanongwa tusova kwa chilongu chila chitugolili yufwi tuvi vavanda. Ponopa tukukimbanikila ngalilu ya shonu ya Mfuki Mng'alili, kwanongwa ha ya yila ngalilu ya dahili ya Malawu yiyandikiwili. ");
INSERT INTO ndj_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Wuli, topi tudeti kucha Malawu ndi sambi? Ng'odu! Lakini ngajila Malawu, nenga ningamanyili ng'odu sambi chindu liki. Leki Malawu vangadetili ng'odu, “Kotoo kudobukela,” ningamanyili ng'odu nongwa liki tukudobukela fya wafu. ");
INSERT INTO ndj_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kwa kukovikela lilawu ali, sambi yapatili wilyambi wa kuyimusha kila ndambu ya dobukelu sha wafu mugati yangu. Pangajila Malawu sambi ndi chindu chisovili. ");
INSERT INTO ndj_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Chipindi chimochi nenga ndaveli mnofu na ndayikalili kutali na Malawu, lakini Malawu pavesili, sambi yashukukili, ");
INSERT INTO ndj_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","na nenga ndasovili. Topi Malawu vayilateyi kuyegha unofu, kwa nenga vayegha njifwa. ");
INSERT INTO ndj_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nongwa, sambi yapatili fwasi yigayiliwili na Malawu ava, yijanga na kung'ulagha. ");
INSERT INTO ndj_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Topi, Malawu veni ndi vang'alili na amuli yeni ndi ng'alili, ndi ya ugoleki na nofu. ");
INSERT INTO ndj_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Wuli, chindu chinofu chiyegha njifwa? Ng'odu! Yiva naha, sambi yiyegha njifwa kupitila chindu chinofu. Topi, kwa njila ya lilawu, sambi yikulangushiwa kuva sambi munu. ");
INSERT INTO ndj_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tumanya kucha Malawu ndi va chimfuki, lakini nenga wa chimfuki ha, njuwusiwa kuva mvanda wa sambi. ");
INSERT INTO ndj_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Manya ha chigola, nongwa chila chidayila kugola ngugola ha, ila chila chindichinyekwa ndi ngugola. ");
INSERT INTO ndj_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Topi, payiva ngugola ng'odu ngimu wudayila, ayi yikumanyisha kucha vala Malawu va nyanyi. ");
INSERT INTO ndj_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Topi nenga ndimweni ha yigolili chindu achi, lakini sambi yivelili mugati yangu ndi yigola nenga goli. ");
INSERT INTO ndj_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Manya kucha kwahela chindu chinofu mugati ya nenga, ngimu ya wundu wangu. Kwanongwa, ngudayila kugola chindu cha nyanyi, lakini nguwesha ha kugola. ");
INSERT INTO ndj_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Badili ya kugola chila chindu chinofu chidayila, ngugola chila cha wafu chingajila kudayila nenga. ");
INSERT INTO ndj_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Topi, leki ngugola chila chidayila ng'odu nenga, ayi yikumanyika kucha nenga ha yigola afi, ila yila sambi yiveli mugati ya nenga ndi yikugola afi. ");
INSERT INTO ndj_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Topi manya kucha kuna chindu chikugola chichuku. Ngudayila kugola chindu chinofu, lakini nguyiwona kucha chila chiveli cha wafu ndi chishawula nenga. ");
INSERT INTO ndj_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Mugati nakamu ya ndima yangu ngusekilela kugola Malawu va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Lakini nguwona kuna chindu chikugola chichuku mukuvili yangu, yivalimbana na mahala vangu. Topi vakugola ndivi mvanda wa Malawu va sambi yivagola fichuku mukuvili yangu. ");
INSERT INTO ndj_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Pishu! Nenga mundu ningajila seku! Ghani danowoli nenga mumvili awu wa njifwa? ");
INSERT INTO ndj_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ngumulumba Chapanga yagola afi kwa deha ya Bambu wetu Yesu Kilistu! Ayi ndi ndambu ya nenga, kwa luhala lwangu ngukimbanikila Malawu va Chapanga, lakini kwa mvili wangu nguvakimbanikila Malawu va sambi. ");
INSERT INTO ndj_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ponopa kwahela highilu kwa vala mungalilu yawu vayilumba na Yesu Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kwa ndambu ya Malawu va Mfuki yayegha unofu kwa kuyilumba na Yesu Kilistu, vangombola mu Malawu va sambi yiyegha njifwa. ");
INSERT INTO ndj_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Chapanga agolili liki mumalawu vamupili Musa vawesha ha kugola kwanongwa ya usosuvafu wa chiwundu. Chapanga amulayishili mwana waki yaveli na mvili ngimu yufwi yituvelili na sambi, ili ayitashi na sambi na mweni ayu ayilapilili sambi. ");
INSERT INTO ndj_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Chapanga agolili nahawu ili Malawu vaweshi kukwila nakamu mugati ya yufwi yitwikala, ngimu ya liwovi lya chiwundu ha, ila ngimu ya liwovi lya Mfuki Mng'alili. ");
INSERT INTO ndj_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Nongwa vala yivayikala ngimu ya njimba wuyidayila vakulongushiwa na hoshu sha njimba. Lakini vala yivayikala kwa kwidumba Mfuki Mng'alili, vakulongushiwa na hoshu sha Mfuki. ");
INSERT INTO ndj_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Hoshu sha njimba sikuyegha njifwa, lakini hoshu sha Mfuki Mng'alili sikuyegha unofu na kusika. ");
INSERT INTO ndj_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kwanongwa yayikala na hoshu sha njimba ndi chimdwama wa Chapanga, akuvapikana ha Malawu va Chapanga, wala aweshi ha kupikana. ");
INSERT INTO ndj_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Vandu yivajumila kugola yifidayila njimba vaweshi ha kumunowesha Chapanga ");
INSERT INTO ndj_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Leki yumwi yimwikala pamukombikesha fila yifidayila mvili, na mukukovikela fya dayila Mfuki, leki Mfuki wa Chapanga akwikala mugati yenu. Yoyosi yangajila Mfuki wa Kilistu, ayu wa Kilistu ha. ");
INSERT INTO ndj_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Leki Kilistu paghava mugati yenu, hata leki njimba shenu sisova kwanongwa ya sambi, kwa yumwi Mfuki Mng'alili ndi unofu kwanongwa mugoliwa kuva goleki. ");
INSERT INTO ndj_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Payiva Mfuki wa Chapanga yamushukushili Yesu Kilistu munjifwa akwikala mugati ya yumwi, dalowoli njimba shenu sivelili munjifwa, dagoli nahawu kwa deha ya Mfuki yayikala mugati yenu. ");
INSERT INTO ndj_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Topi, valongu vangu, tukotoo kutavaliwa na njimba. ");
INSERT INTO ndj_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Leki pamwikala kukovikela ngimu wuyidayila njimba ya chiwundu nakaka damusovi. Lakini, kucha kwa deha ya Mfuki Mng'alili mukufiwulagha findu fyenu fya wafu fimugola, topi, damunani. ");
INSERT INTO ndj_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Vosi yivalongushiwa na Mfuki wa Chapanga ndi vana va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kwanongwa mwamuyangili ha mfuki muna kuvataya yumwi uvanda na kuvataya ungalimesu, ila mumuyanga Mfuki munakuvagola yumwi vana va Chapanga na kwa kupitila Mfuki Mng'alili ayu, yufwi tukumkema Chapanga “Tati” ");
INSERT INTO ndj_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Na Mfuki Mng'alili mweni akusitovilela ndima shetu kucha yufwi ndi vana va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Topi, kwanongwa yufwi vana va Chapanga, datupokeli na kuhala sangi shosi Chapanga shavavikilili vandu vaki na datuvi pamu mumbala ayi na Kilistu, ila patuva pamu mugobuleku na Kilistu, datuvi pamu wuwu muukomi waki. ");
INSERT INTO ndj_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nguwona kucha kugobuliwa kwa chipindechi cha ponopa chindu ha leki patulinganisha na wula ukomi dawuvi kwa yufwi. ");
INSERT INTO ndj_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Filumbi fyosi fikuvetela kwa dobukelu Chapanga avagubutulili vana vaki. ");
INSERT INTO ndj_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kwanongwa filumbi fyavikiwili muusosuvafu nakamu, kwa kudayila fyeni ha ila yaveli nahawu ngimu wadayila Chapanga. Hata naha tuva na shuvililu, ");
INSERT INTO ndj_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kwanongwa ayi lijuva limu filumbi dafilowuliwi muuvanda wa kuwola, ili fivi pamu muupekesu mkomi wa vana va Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kwanongwa tumanya kucha mbaka ponopa, filumbi fyosi fikughayanika kwa lihingili likomi ngimu ya mdala palela. ");
INSERT INTO ndj_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Filumbi afi weka ha, hata yufwi yituvelili na ayu Mfuki Mng'alili, yavelili wa kwaa mufupu sha Chapanga na yufwi wuwowu tukung'ong'uteka mugati yetu, patuvetela tugoliwi vana va Chapanga na njimba shetu sigombuliwi. ");
INSERT INTO ndj_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kwa shuvililu ayi yufwi tugombuliwa. Lakini shuvililu ayi kwa hela mana payiva yahela mana nongwa tukuyiwona yila shuvililu. Kwa nongwa ghani yashuvilila chila chachiwona kala? ");
INSERT INTO ndj_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Leki shuvililu yila yituvelili tukalihela kuyiwona, topi, tukuyivetela kwa uwunilifu. ");
INSERT INTO ndj_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Wuwula wula, Mfuki Mng'alili akututanga muusosuvafu wetu. Nongwa tumanya ha fitudayiliwa kuluva, lakini mweni Mfuki akutudadavila kwa Chapanga kwa lishu lya kung'ong'oleka lingajila chifwani. ");
INSERT INTO ndj_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Na mweni Chapanga yalola mbaka mugati ya ndima sha vandu, akumanya hoshu sha ayu Mfuki, kwanongwa Mfuki Mng'alili ayu akuvadadavila vandu va Chapanga ngimu wadayila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tumanya kucha, mufindu fyosi Chapanga fyagola fichuku fya nyanyi pamu na vosi yivamtama, ndi vala yavakemili kucha wayilatili mweni. ");
INSERT INTO ndj_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kwa nongwa ava yavashawulili kukandila pakwandi ndi yavatapulili ili vayifwani na mwana waki vavi vakwaa muvalongu vatangalili. ");
INSERT INTO ndj_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Topi, vala yivashawulili kala Chapanga ndi ava yavakemili, na ava avakemili ndi ava avagolili kuva goleki, na ava avagolili kuva goleki ndi ava vavelili pamu muujumu waki. ");
INSERT INTO ndj_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Muafi, tudeti liki? Leki Chapanga kava mwambu wetu, ghani yawesha kutulimba? ");
INSERT INTO ndj_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Chapanga kamukanisha ha mwana waki wa paweka, ila amtawulili kwanongwa ya twavosi yufwi. Leki kagoliwa nahawu, wuli, datusangili ng'odu findu fyosi finofu? ");
INSERT INTO ndj_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ghani davahighi vagoleki va Chapanga? Chapanga mweni akwivayitasha fivavifyili! ");
INSERT INTO ndj_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ghani davahighi? Kwahela! Nongwa Yesu Kilistu ndi yasovili, pambeli kashukuka kufuma kwa yivasovili na kayikala mwambu wa mlilu wa Chapanga. Mweni akutudadavila! ");
INSERT INTO ndj_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ghani yawesha kutubava na utami wa Kilistu? Wuli, tabu, awu siki, awu kuteshiwa awu njala, kusakaliwa, awu mgoha, kumbi liki njifwa? ");
INSERT INTO ndj_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kucha Mayandiku Vang'alili wuvadeta, Kwanongwa ya yuwi tukutuvilila njifwa pamusi na pamihi, “Tukugoliliwa kucha fungami wa kusinjiwa.” ");
INSERT INTO ndj_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Lakini mufindu afi fyosi, tupata uweshi mkomi kwa utangi waki mweni yatutamili. ");
INSERT INTO ndj_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Nongwa manya nakaka kucha kwahela chindu chiwesha kutubava na utami waki, wala njifwa, wala unofu, wala makungu, wala liwovi lingi lya kumbindi, wala yifibwituka ponopa afi, wala fila dafibwituki pambeli, wala amuli, ");
INSERT INTO ndj_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","wala mlima wa kumbindi, wala wa pasi chalamuku. Kwahela chilumbi chochosi dachiweshi kutubava na utami wa Chapanga mu Yesu Kilistu Bambu wetu. ");
INSERT INTO ndj_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ngudeta nakaka, ngudeta udesi ha ndiyilumba na Kilistu. Natilu yangu yikulongushiwa na Mfuki Mng'alili akung'ombela chilongu achi wuwowu. ");
INSERT INTO ndj_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Chidayila kudeta ndi achi, ndina lung'ongu lukomi na mundima mukuluma ngajila chifwani mundima yangu, ");
INSERT INTO ndj_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","kwanongwa ya valongu vangu yivavelili njimba na mwasi wangu! Leki yingavelili kwa fwayida yawu, ngadayilili kulapiliwa na kubaviwa na Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ava ndi vandu va Isilaeli Chapanga yavashawulili vavi vana vaki, vavapamu muukomi waki, kayilagha na veni vapokela Malawu vaki, udadawu wa nakaka na jangi shaki. ");
INSERT INTO ndj_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Veni ndi vayisukulu va vagogolu, mweni Kilistu, ndambu ya uwundu waki, wufuma mulukolu lwawu. Chapanga yatavala fyosi, ajumiwi jola! Yina. ");
INSERT INTO ndj_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Kucha ngudeta ngimu jangi ya Chapanga yighalambuka ha, nongwa vandu vosi va Isilaeli ndi yivashawuliwili na Chapanga ha. ");
INSERT INTO ndj_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Kucha valelwa vosi va Ibulahimu ndi vana va Chapanga nakaka ha. Ila, kucha wuvadeta mayandiku vang'alili, “Valelwa vaki davafumi kwa Isaka.” ");
INSERT INTO ndj_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Tukuwesha kudeta, vala yivawonikili chimvili ndi vana va Chapanga ha, ila vala yivawonikili kwa jangi ya Chapanga ndi davakemiwi vana vaki. ");
INSERT INTO ndj_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Nongwa jangi yeni ndi ayi, “Chipindi cheni dang'uyi na Sala dapati mwana mlumi.” ");
INSERT INTO ndj_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Kandi kucha afi weka hela ha, ila na Lebeka wuwowu dapati mambila kwa tati yumu, ndi Isaka mbuyi wetu. ");
INSERT INTO ndj_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Ili Chapanga awoneki kucha kana upekesu wa kushawula, hata vakalihela vala valongu kuwoneka na vakalihela kumanya chinofu na cha wafu, Lebeka awombiliwili kucha yula mwana soli damkimbanikili yula chambelu. Topi lushawu lwa Chapanga lukuva ngimu ya jangi yaki mweni, figoli fya mundu ha. ");
INSERT INTO ndj_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kucha Mayandiku Vang'alili wuvadeta, “Yakobi ndamtamili, lakini Isawu ndamunyekwili.” ");
INSERT INTO ndj_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Topi, tudeti liki? Wuli, Chapanga kalemwa haki? Ng'odu! ");
INSERT INTO ndj_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Nongwa amuwombilili Musa, “Dandimuwoneli lusungu mundu yoyosi yindimtama, dandimuwoneli lusungu mundu yoyosi yindimdayila.” ");
INSERT INTO ndj_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ponopa fyosi fikudayila lusungu lwa Chapanga, nguvilishilu ha awu ngimu wadayila mundu ha. ");
INSERT INTO ndj_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Nongwa Mayandiku Vang'alili vakudeta naha kwa Fwalawu, “Ndakugolili mutwa ili kwa deha ya yuwi, uwesu wangu wumanyiki na litawa lyangu lilanduliwi mlima wosi.” ");
INSERT INTO ndj_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Yiva nakaka kucha Chapanga akumuwonela lusungu yoyosi yadayila kuwoniwa lusungu na padayila kumgola mundu ghavi muchichuku akugola nahawu. ");
INSERT INTO ndj_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Pamongapa dawudashi, “Payiva filongu afi fiva nahawu, Chapanga akuwesha wuliwuli kulola uvifyi wa mundu? Ghani akuwesha kuvalimba matami vaki?” ");
INSERT INTO ndj_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Yuwi kuva ghani mbaka yeshi kumudasha Chapanga? Chiyungu chikuwesha kumudasha muwumbi waki: “Nongwa liki, kugola nahawu nenga?” ");
INSERT INTO ndj_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Muwumbi akuwesha kuugolela uganga ngimu wadayila mweni na kuwumba fiyungu fivili kwa uganga wuwula wula, chimu cha kugolela ndundamilu na chimonga cha kugolela findu fingajila ndundamilu. ");
INSERT INTO ndj_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nahawu ndi kucha wagolili Chapanga. Akadayileyi kulangusha chifuki chaki na kulangusha uwesu waki. Topi, aveli na seku ngomi pavavayiwunishila vala yavayilatili chifuki chaki, yivadayiliwili kuyanangiwa. ");
INSERT INTO ndj_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Wuwula akadayileyi kulangusha kutangala kwa ukomi waki watupungulili yufwi yituvelili natilu ya lusungu lwaki, yufwi yatutandili kala kuuyanga ukomi waki. ");
INSERT INTO ndj_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Nongwa yufwi ndi vala vaatukemili, gati ya Vayawudi weka ha ila wuwowu kufuma gati ya vangutungu va Vayawudi. ");
INSERT INTO ndj_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ayi yiva ngimu wuyideta muchitabu cha mbuyi wa Chapanga Hoseya, “Vala yivavelili ‘vandu vangu ng'odu’ dandivakemi, ‘Vandu vangu!’ Na yula yindimdayila ng'odu dandimkemi, ‘Mundu yindimtama’ ");
INSERT INTO ndj_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na pala pavawombiliwili, ‘Yumwi vangu ha’ apa davakemiwi, ‘Vana va Chapanga yavelili mnofu.’ ” ");
INSERT INTO ndj_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Na mbuyi wa Chapanga Isaya, akuvalandulila lishu likomi vandu va Isilaeli, “Hata leki chileli cha Isilaeli vatangala kucha muhanga wa muluwongu, vadokwa hela davalowuliwi, ");
INSERT INTO ndj_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","nongwa, Bambu dagoli yivi kalopu highilu yaki ya nakaka kwa mlima wosi.” ");
INSERT INTO ndj_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Kucha mbuyi wa Chapanga Isaya walongulili kudeta, “Kucha Bambu wa mangandawu angatulekishili ha vamu va chileli cha Isilaeli, tungavelili kala kucha wula Sodoma na Gomola.” Aku Chapanga avagwijushili na motu vandu vosi. ");
INSERT INTO ndj_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Topi tudeti liki? Vangutungu va Vayawudi vangajila kusaka ugoleki, vasangiliwa kuva vagoleki kwa deha ya ujumilwa, ");
INSERT INTO ndj_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","na Vayisilaeli yivavasakili Malawu va ugoleki, vapatili ha. ");
INSERT INTO ndj_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Nongwa liki? Kwanongwa vayidumbilili fivagolili badili ya kuyidumba ujumilwa. Vayikwalili pambindi ya ligonguveli lya kuyikwala ");
INSERT INTO ndj_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","kucha wuvadeta Mayandiku Vang'alili, “Loli, damiki ligonguveli aku Sayuni lyeni, dalivagoli vandu vayikwali vawi. Lakini yamujumila datayiwi soni ha!” ");
INSERT INTO ndj_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Valongu vangu, ndima yangu yikudayila Vayawudi vayangu vosi valowuliwi. Na nguvadadavila kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nguwesha kutovilela kwanongwa yawu kucha vana nguvilishu ya kumsaka Chapanga, lakini nguvilishu ayi yigoleka muumanyi wa nakaka ha. ");
INSERT INTO ndj_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nongwa vamanya ha ndambu ya Chapanga yavagola vandu vavi vagoleki na vayesha kukanda ndambu yawu veni na vayijumilili ha deha ayi ya Chapanga ya kuvagola vavi vagoleki. ");
INSERT INTO ndj_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Nongwa kwisa kwa Kilistu, Malawu avagolili vavi, ili vosi yivajumila vavi vagoleki. ");
INSERT INTO ndj_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mumilandu ya kuva goleki kwa kukombikesha Malawu, Musa ayandikili naha, “Mundu yagola yifidayila Malawu dayikali kwa ndambu ya fila fyagola.” ");
INSERT INTO ndj_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Mayandiku Vang'alili mumilandu ya kuva goleki kwa deha ya ujumilwa vakudeta naha, “Mukotoo kwidasha ghani dakweli mbaka kumbindi kwa Chapanga?” Ayi yina mana ya kumsunusha Yesu Kilistu pasi. ");
INSERT INTO ndj_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Yumwi damudashi ng'odu kucha, Kilistu dasunuki mbaka pasi ya mlima?” Ayi yina mana kumjabula Yesu kufuma kumambi. ");
INSERT INTO ndj_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Mayandiku Vang'alili vakudeta naha, “Lulayilayi alu lwa Chapanga luva pabehi na yuwi, luva pamulomu yaku na mundima yaku.” Na weni ndi chila chilongu cha ujumilwa wutuwulandula. ");
INSERT INTO ndj_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Leki pawudeta kwa mlomu waku kucha Yesu ndi Bambu na kujumila mundima yaku kucha Chapanga amushukushili kumambi, dawulowoki. ");
INSERT INTO ndj_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ujumili mundima yaku, ugoliwi goleki na kwa mlomu waku, deti ulowuliwi. ");
INSERT INTO ndj_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Mayandiku Vang'alili vakudeta, “Mundu yamjumila datayiwi soni ha.” ");
INSERT INTO ndj_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Chilongu achi chivahela lushawu kwa Vayawudi na Vagiliki. Bambu ndi Bambu wa vandu vosi na mweni msangi munu kwa yivamluva. ");
INSERT INTO ndj_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Kwanongwa Mayandiku Vang'alili vakudeta, “Mundu daamkemi Bambu ili amtangi alowuliwi.” ");
INSERT INTO ndj_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Topi, davamdavi wuliwuli leki vamjumilili ng'odu? Na davamdavi wuliwuli kunu vakalihela kupikana filongu fyaki? Kandi davapikani wuliwuli filongu fyaki leki kwahela mlandula? ");
INSERT INTO ndj_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Na vandu davalanduli wuliwuli leki kwahela mundu yavalayishili? Kucha wuvadeta Mayandiku Vang'alili. “Ndi chilongu chivayilili munu kwisa kwa vala yivalandula Chilongu cha Nyanyi!” ");
INSERT INTO ndj_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Lakini vosi vachiyanga ng'odu achi Chilongu cha Nyanyi. Mbuyi wa Chapanga Isaya adetili, “Bambu, ghani yalujumilili lulayilayi lwetu?” ");
INSERT INTO ndj_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Topi, ujumilwa wukufuma kwa kupikana unjagila na unjagila wukufuma mukulandula chilongu cha Kilistu. ");
INSERT INTO ndj_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Lakini ngudasha, Wuli, vapikana ng'odu unjagila awu? Yina, vawupikanilili, kucha Mayandiku Vang'alili wuvadeta. Lishu lyawu likwila mlima wosi, filongu fyawu fikwila mbaka mumbelu ya mlima. ");
INSERT INTO ndj_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Musa adashili kandi, wuli, yikuweshikana kucha vandu va Isilaeli vamumanyili ng'odu? “Dandivagoli vawoni weyi kwa vandu vangajila kuva vanamlima, dandivagoli muvi na maya kwa vandu va mlima wa vapufi.” ");
INSERT INTO ndj_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Kandi mbuyi wa Chapanga Isaya, adetili ngajila lyogha milandu ya Chapanga, “Vala vangajila kunzaka vambata, ndiyilangusha kwa vandu vangajila kudashikisha filongu fyangu.” ");
INSERT INTO ndj_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Lakini kwilata vandu va Isilaeli akudeta naha, “Pamusi posi ndaholushili mawoku vangu kuvayanga vandu vavifyi na vangajila kujumila.” ");
INSERT INTO ndj_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Topi, nguvadasha, wuli, Chapanga kavalema vandu vaki? Ngodu! Ndimweni baha Mwisilaeli, chileli cha Ibulahimu, kabila lya Benjamini. ");
INSERT INTO ndj_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Chapanga kavalema ng'odu vandu vaki yivavashawulili kukandila dahili. Mukukumbuka wuvadeta Mayandiku Vang'alili vamuyilatili mbuyi wa Chapanga Eliya paghaveyi akumung'ong'utekela Chapanga kwanongwa ya vandu va Isilaeli: ");
INSERT INTO ndj_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Bambu, vavawulagha vambuyi vaku na kubowola fyalu fyaku. Yisighalili nenga weka na veni vakudayila ha ndivi na unofu!” ");
INSERT INTO ndj_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Wuli, Chapanga amuyangulili liki? Amuwombilili, “Ndiyivikila vandu elufu saba vangajila kumujuma Baali.” ");
INSERT INTO ndj_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Topi, ayi ndi yaveli wuwu chipindi achi cha ponopa, kwaveli vandu vadokwa yivasighalili Chapanga avashawulili kwa usangi waki. ");
INSERT INTO ndj_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Leki yingavelili kwa usangi, yiva kwanongwa ya fivagola ha, pamongapa usangi wungaveli usangi kandi ha. ");
INSERT INTO ndj_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ponopa, wuli? Chindu chila vandu va Isilaeli chivachisakeyi vachipata ng'odu, lakini vosi yivashawuliwili vachipata. Vamonga vadindashiwa, ");
INSERT INTO ndj_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","kucha wuvadeta Mayandiku Vang'alili, “Chapanga kasigola ndima shawu kuva sisitapa, na mbaka nalelu vaweshi ha kulola kwa mesu vawu wala kupikana kwa majeji vawu.” ");
INSERT INTO ndj_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Na Dawudi kadeta, “Hungu shawu sivi mtambu wa kuvawomesha, vawi na kutovangiwa. ");
INSERT INTO ndj_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Mesu vawu vatayiwi chisi vakotoo kulola. Miwongu yawu yigongumbali kwa tabu sha majuva vosi!” ");
INSERT INTO ndj_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Topi, ngudasha, wuli Vayawudi vayikwala mbaka vayaghamila chalamuku? Ng'odu! Kwanongwa ya wafu wawu ugombola wuvayisila vangutungu va Vayawudi, ili Vayawudi vavawoneli weyi. ");
INSERT INTO ndj_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Vifyu sha Vayawudi sigola usangi mkomi wa mlima na kuyangila kwa usangi mkomi kwa Vangutungu va Vayawudi. Topi nakaka munu kucha unakaka wawu dawugoli usangi mkomi munu chipindi Vayisilaeli pavayikungasha vosi. ");
INSERT INTO ndj_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Topi, ponopa nguvawombela yumwi vangutungu va Vayawudi, kwanongwa nenga ndiva ndundami kwa vangutungu va Vayawudi, ngwidumba ngimbanikilu yangu, ");
INSERT INTO ndj_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ili ng'weshi kuvagola vanamlima vayangu vavawoneli weyi yumwi, ili ng'weshi kuvalowola vamu gati ya veni. ");
INSERT INTO ndj_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Nongwa kukaniwa kwawu kwagolili mlima wujovishiwa na Chapanga, dayivi wuliwuli chipindi pavajumiliwa na Chapanga? Yivasovili davashukuki! ");
INSERT INTO ndj_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Payiva chipandi cha kwaa cha libumunda chivikiwa nyanyi kwa kutawuliwa kwa Chapanga, libumunda lyosi livikiwa kala kwa kutawuliwa kwa Chapanga. Payiva mikigha ya mibiki yitawuliwa kwa Chapanga na mitafyi yaki wuwowu dayitawuliwi kwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Leki mitafyi yimu ya miseyituni yadumuliwili kula kuchiwunga na pala paliveyi liseyituni, litafyi limonga lya miseyituni dasi lyatuliwilili. Na yumwi vangutungu va Vayawudi ndi ali liseyituni dasi, ponopa mukuva pamu muliwovi na minwana ya miseyituni kuchiwunga. ");
INSERT INTO ndj_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Topi, mukotoo kuvabedala vala yivadumuliwili kucha mitafyi! Leki kuna cha kuyifunila, mukumbuki kucha yumwi ha yimugola mikigha, ila mikigha ndi yikuvagola yumwi. ");
INSERT INTO ndj_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Lakini dawudeti, “Mitafyi yadumuliwili ili nenga nduliwi mahali paki.” ");
INSERT INTO ndj_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Yina! Yadumuliwili kwanongwa yangajila ujumilwa, ila yuwi ukuwoloka kwa ujumilwa waku. Lakini kotoo kuyijuma ila mutili. ");
INSERT INTO ndj_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kwanongwa payiva Chapanga kavawonela lusungu ng'odu Vayawudi yivavelili kucha mitafyi pakwandi, wuli, ukucha dakuwoneli lusungu yuwi? ");
INSERT INTO ndj_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Loli, topi, ndambu Chapanga wavelili msangi na mkali. Mweni mkali kwa vala yivawili na msangi kwa yuwi pawuva ukuyendilela kuva muusangi waki leki naha ng'odu na yuwi ukudumuliwa wuwowu. ");
INSERT INTO ndj_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Na Vayawudi ngawuwowu, vangajila ujumilwa, davatuliliwi kandi, nongwa Chapanga kana uwesu wakuvatulila kandi. ");
INSERT INTO ndj_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Yumwi vangutungu va Vayawudi nakaka muva kucha mitafyi ya miseyituni dasi, lakini aku muwushiwa, mutuliliwa muchiwunga cha miseyituni mahali payumwi ha. Lakini, Vayawudi vava kucha mseyitumi kuchiwunga na dayivi chilongu chipusu munu kwaveni kutuliliwa kandi mulibiki lyawu lileli. ");
INSERT INTO ndj_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Valongu vangu, ngudayila mumanyi unakaka awu wufisikili mukotoo kwijuma. Umakuluhu wa Vayisilaeli wavelili wa chipindi hela, mbaka vangutungu va Vayawudi pavamfikila Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nahawu ndi mlima wosi wa Isilaeli dawulowuliwi, kucha Mayandiku Vang'alili wuvadeta. “Mkombola dayisi kufuma Sayuni, daawuwushi wafu wa chileli cha Yakobi. ");
INSERT INTO ndj_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Dagoli lilaghanu lyangu na veni chipindi pandisiwusha sambi shawu.” ");
INSERT INTO ndj_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kwanongwa vakuchilema Chilongu cha Nyanyi, Vayawudi vava vachimdwama va Chapanga, lakini fwayida yenu yumwi vangutungu va Vayawudi. Lakini, kwanongwa vashawuliwili vakali vaghanja va Chapanga kwanongwa ya vambuyi vawu. ");
INSERT INTO ndj_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Chapanga akughalambula ha hoshu shaki kwa vala yavashawulili na kuvapa fupu shaki. ");
INSERT INTO ndj_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Pakwandi yumwi mwamulekili Chapanga, lakini ponopa mupata lusungu lwaki kwanongwa veni vamuleka. ");
INSERT INTO ndj_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Wuwula wula kwa lusungu lwaki lumusangiliwili yumwi, Vayawudi vakumlema Chapanga ponopa ili na veni vapokeli lusungu lwa Chapanga. ");
INSERT INTO ndj_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kwanongwa Chapanga kavawopa vandu vosi muuvifyi wawu ili aweshi kuvawonela lusungu vosi. ");
INSERT INTO ndj_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ulundamali na luhunja na luhala lwa Chapanga lukomi munu! Sungu shaki sikulembisheka ha na deha shaki sikumanyika ha! Kucha wuvadeta Mayandiku Vang'alili. ");
INSERT INTO ndj_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Ghani yasimanyili hoshu sha Bambu? Ghani akuwesha kuva mjowesha waki? ");
INSERT INTO ndj_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Awu ghani yatawulili tanila chindu kwa Chapanga, hata aweshi kuhombiwa kandi chindu achi?” ");
INSERT INTO ndj_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kwanongwa findu fyosi filumbiwa na mweni, fyosi fiva kwa uwesu waki na kwanongwa yaki. Ukomi wuvi kwa mweni hata jola! Yina. ");
INSERT INTO ndj_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ponopa, valongu vangu, leki Chapanga ndi muna lusungu lutangalili, nguvawombela kwa ndima yosi, mutawuli njimba shenu kwa Chapanga kucha litambiku livelili na ling'alili na linowesha. Ayi ndi deha yenu nakaka ya kujuma. ");
INSERT INTO ndj_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Mukotoo kukombikesha ngalilu ya mlima awu. Chapanga agoli avaghalambuli mugati yenu kwa kusighalambula hoshu shenu. Apa ndi damuvamanyi matami va Chapanga na kumanya chilongu chinofu, chimunowesha na chikwilili. ");
INSERT INTO ndj_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kwa fupu ya usangi yanyimbili Chapanga, nguvawombela mwavosi yumwi, mukotoo kuyiwona kucha chindu chikomi munu pitu yimuvelili. Hoshu shenu sikotoo kuva ngomi kujumba chigelu cha ujumilwa ngimu Chapanga wakupili yuwi. ");
INSERT INTO ndj_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Mvili wuna fisingu fitangalili, kila chisingu na chichuku chaki. ");
INSERT INTO ndj_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Wuwula wula hata leki yufwi tutangala, tuva mvili wumu kwa kwilumba na Kilistu na mundu ndi chisingu cha muyaki. ");
INSERT INTO ndj_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","