﻿USE sofia;
DROP TABLE IF EXISTS sofia.ndh_vpl;
CREATE TABLE ndh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ndh_vpl WRITE;
INSERT INTO ndh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ishi ngamu isha chikolo icha Yeesu Kilisiti yuuyo akafuma mu chikolo icha malafyale uNdaabhiti na mu chikolo icha Abhulahamu. ");
INSERT INTO ndh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","UAbhulahamu akamupaapa uIsiyaka, uIsiyaka akamupaapa uYaakobhu, uYaakobhu akamupaapa uYuuta na bhoghwamwabho. ");
INSERT INTO ndh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","UYuuta akamupaapa uPeelesi nu Seela kwa Tamaali. UPeelesi akamupaapa uHesolooni, uHesolooni akamupaapa uAalamu, ");
INSERT INTO ndh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","uAalamu akamupaapa uAminandabhu, uAminandabhu akamupaapa uNaashoni, uNaashoni akamupaapa uSalumooni, ");
INSERT INTO ndh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","uSalumooni akamupaapa uBhoghwasi kwa Lahabhu, uBhoghwasi akamupaapa uOobheti kwa Luuti, uOobheti akamupaapa uYeese, ");
INSERT INTO ndh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","nu Yeese akamupaapa umalafyale uNdaabhiti. UNdaabhiti akamupaapa uSolomooni ku mukolo yuuyo akabha mukashi ghwa Uliiya, ");
INSERT INTO ndh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","uSolomooni akamupaapa uLehobhoghwamu, uLehobhoghwamu akamupaapa uAbhiya, uAbhiya akamupaapa uAasa, ");
INSERT INTO ndh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","uAasa akamupaapa uYoosefaati, uYoosefaati akamupaapa uYoolamu, uYoolamu akamupaapa uUsiiya, ");
INSERT INTO ndh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","uUsiiya akamupaapa uYootamu, uYootamu akamupaapa uAhasi, uAhasi akamupaapa uHesekiiya, ");
INSERT INTO ndh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","uHesekiiya akamupaapa uManaasi, uManaasi akamupaapa uAamoni, uAamoni akamupaapa uYosiiya. ");
INSERT INTO ndh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","UYosiiya akamupaapa uYekoniya na bhoghwamwabho ku kabhalilo kaako abhandu abha Bhaabheli bhakabhakolagha aBhaisilaeli nu kubhuuka nabho mu chiisu chaabho. ");
INSERT INTO ndh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Soona bhwo bhaabhuuka nabho ku Bhaabheli kula, uYekoniya akamupaapa uSheyalitiyeeli, uSheyalitiyeeli akamupaapa uSelubhabheli, ");
INSERT INTO ndh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","uSelubhabheli akamupaapa uAbhihuti, uAbhihuti akamupaapa uEliyaakimu, uEliyaakimu akamupaapa uAasoli, ");
INSERT INTO ndh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","uAasoli akamupaapa uSandoki, uSandoki akamupaapa uAakimu, uAakimu akamupaapa uEliyuti, ");
INSERT INTO ndh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","uEliyuti akamupaapa uEliyaaseli, uEliyaaseli akamupaapa uMaatani, uMaatani akamupaapa uYaakobhu. ");
INSERT INTO ndh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","UYaakobhu akamupaapa uYoosefu umulume ughwa Maliiya. UMaliiya ghwe yuuyo akamupaapa uYeesu yuuyo ghwi Mesiiya. ");
INSERT INTO ndh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Po ukufumila kwa Abhulahamu ukufika kwa malafyale uNdaabhiti kukabhaakwo ni mbaapo kalongo na inna (14). Soona ukufumila kwa Ndaabhiti ukufika ku kabhalilo kaako abhandu abha Bhaabheli bhakabhasaamyanga aBhaisilaeli ku chiisu chaabho, kukabhaakwo ni mbaapo inine kalongo na inna. Soona ukufumila ku kabhalilo kaako bhakabhasaamyanga ukufika ukupaapighwa ukwa Yeesu Kilisiti, kukabhaakwo ni mbaapo inine kalongo na inna. ");
INSERT INTO ndh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ukupaapighwa ukwa Yeesu Kilisiti kukabha ulu. Bhwo ungʼina yuuyo ingamu yaake ghwi Maliiya aashingilighwa nu Yoosefu, soona bhwo bhakaali ukweghana, uMaliiya akabhoneka ukuti ali pa bhungʼwamu bhuubhwo akabhwagha ku sila iya Mbepo uMwelu. ");
INSERT INTO ndh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","UYoosefu, umulume akabhombagha shiisho shibhaghiile pandaashi pa Chaala, loole atakalondagha ukuti amukoshe isoni uMaliiya. Po akiinongʼona ukumuleka ku bhushiifu. ");
INSERT INTO ndh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bhwo akwinongʼona isho, ughwandumi ughwa Malafyale akamwisila mu filoota. Ughwandumi yula akamubhuula akati, “Ghwe Yoosefu, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, manye ghwoghopaghe ukumwegha uMaliiya paapo ali pa bhungʼwamu bhuubhwo abhwaghite ku maka agha Mbepo uMwelu. ");
INSERT INTO ndh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Indiapaape umwana umuliisha, nuughwe indiumupe ingamu iya Yeesu, paapo indiakabhapokaghe abhandu bhaake ku mbiibhi shaabho.” ");
INSERT INTO ndh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Shooshi isho shikabhombighwa ulwo ukuti ishu lila libhombighwe liilyo uMalafyale uChaala akaliyugha ku sila iya musololi ghwake ukuti, ");
INSERT INTO ndh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Tesha! Umulindu yuuyo ataghonite naalumo nu muliisha, indiakabhe pa bhungʼwamu. Soona indiakapaape umwana umuliisha! Po indibhakamupe umwana uyo ingamu iya Manweli.” Po ilingaanio ilya ngamu iyo kwo kuti, “UChaala ali pamupeene nuutwe.” ");
INSERT INTO ndh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bhwo uYoosefu aalamusha, akabhomba isa muumwo ughwandumi ughwa Malafyale akamubhuulila, akamwegha uMaliiya ukubha mukashi. ");
INSERT INTO ndh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Loole uYoosefu atakamumanya uMaliiya ukufika akabhalilo aka kupaapa umwana. Po uYoosefu akamwita umwana uyo ingamu iya Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","UYeesu akapaapighwa mu kaaya aka Bheetelehemu, mu chiisu icha Yuteeya, ku kabhalilo kaako umalafyale uHelooti akalongoshanga. Po mu kabhalilo ako, mu kaaya aka Yelusaleemu mukabhoneka abhamanya ndoondwa bhaabho bhakafuma kuukwo isubha likufumila. ");
INSERT INTO ndh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Abhamanya ndoondwa bhala bhakabhuusha bhakati, “Kali, ali kuughu yuuyo apaapiighwe ukuti abhe ghwi Malafyale ughwa Bhayuuta? Tumeenye ukuti apaapiighwe paapo tulubhweni ulutoondwa lwake bhwo lukufumila kuukwo isubha likufumila. Po yo yiiyo nongwa iyi twisa pakumwipuuta.” ");
INSERT INTO ndh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Umalafyale uHelooti bhwo aapulika isho, inongwa isho shikamutamya ngaani mu ndumbula yaake pamupeene na bhandu bhooshi abha mu Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Po akabhabhungaania abhosongo abha bhapuuti bhooshi na bhamanyishi abha ndaghilo isha Moose, akabhabhuusha akati, “Kali, uMesiiya indiapaapighwe kuughu?” ");
INSERT INTO ndh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bhoope bhakamwamula bhakati, “Indiapaapighwe mu kaaya aka Bheetelehemu, mu chiisu icha Yuteeya. Paapo isho sho shiisho umusololi akasimba ukuti, ");
INSERT INTO ndh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nuughwe ghwe kaaya aka Bheetelehemu, ghwe uli mu chiisu icha Yuuta, utaa mufuyuke na kaakanandi mu bhulongoshi ubhwa chiisu icha Yuuta! Paapo mumwako mwo muumwo indimufume umulongoshi yuuyo indiakabhe muliishi ghwa bhandu bhangu abha Isilaeli.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Po uHelooti akabhiitisha abhamanya ndoondwa bhala ku bhushiifu ukuti bhiise bhamulingaanie ubhwanalooli akabhalilo kaako bhakalubhona ulutoondwa lula. ");
INSERT INTO ndh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pabhumalilo, akabhatuma ku Bheetelehemu, akabhabhuula akati, “Bhuuka mupeleeleshe akiisa ukufika paapo mwamanya kuukwo umwana uyo ali. Po linga mwamwagha, mwise muumbangile lubhilo ukuti nuune imbuuke pakumwipuuta.” ");
INSERT INTO ndh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bhwo abhamanya ndoondwa bhala bhaapulika amashu agha malafyale, bhakanyatuka. Ulutoondwa lula luulwo bhakalubhonagha kubhuyo kuukwo isubha likufumilagha, lukabhuukagha kundaashi yaabho, lukiima pamwanya paapo umwana yula akabha. ");
INSERT INTO ndh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bhwo bhaalubhona ulutoondwa lula, bhakasekela leka. ");
INSERT INTO ndh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Po bhakiingila mu nyumba, bhakamubhona umwana ali pamupeene nu ngʼina uMaliiya, bhakafughamila kukwake, bhakamwipuuta. Bhakasatula ififunda, bhakafumya isekeelesho ku mwana isa isahabhu, ifyakufuukisha ni nyemba isha kunuukila. ");
INSERT INTO ndh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pabhumalilo, uChaala akabhasoka mu filoota ukuti manye bhaghalukilaghe soona kwa Helooti. Po bhakaghaluka ku kaaya kaabho nu kughenda isila iyingi. ");
INSERT INTO ndh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bhwo abhamanya ndoondwa bhala bhaabhuuka, ughwandumi ughwa Malafyale akamubhonekela uYoosefu mu filoota, akamubhuula akati, “Lamusha, umweghe umwana nu ngʼina, mukindile ku chiisu icha Miisili. Paapo uHelooti indiakiise pakumulonda umwana uyo ukuti amughoghe. Po mushaale kula kula ukufika ku kabhalilo kaako indiingiise pakukubhuula.” ");
INSERT INTO ndh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Po uYoosefu akalamusha pabhushiku, akamwegha umwana nu ngʼina lubhilo, akakindila nabho ku Miisili kula, ");
INSERT INTO ndh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","akashaala kula kula ukufika bhwo uHelooti aafwa ukuti shibhombighwe shiisho uMalafyale akashiyugha ukughendela ku musololi ukuti, “Ingamwitisha umwana ghwangu ukufuma ku Miisili.” ");
INSERT INTO ndh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bhwo uHelooti aashaaghania ukuti abhamanya ndoondwa bhala bhaamushimbula, akakalala leka. Po akalaghila ukuti abhaana abhaliisha bhooshi ukwandila ku bhafyele ukufika ku bhaana abha fyinja fibhili, bhaghoghighwe, abha mu Bheetelehemu pamupeene na bha mu twaya utunine tuutwo tuli mulubhafu. Akabhomba ulwo ukukongana na kabhalilo kala kaako akabhuushanga ku bhamanya ndoondwa. ");
INSERT INTO ndh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Umwo mwo muumwo ishu likabhombighwa liilyo likayughighwa nu musololi uYelemiiya ukuti, ");
INSERT INTO ndh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Inguuto ingulu yikapulikighwa mu kaaya aka Laama. Bhwo uLaaheli ali pakubhalilila abhaana bhaake, soona atakulonda ukumusumbisha, paapo abhaana bhaake bhataliipo soona.” ");
INSERT INTO ndh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bhwo uHelooti aafwa, ughwandumi ughwa Malafyale akamubhonekela uYoosefu mu filoota soona ku Miisili kula, ");
INSERT INTO ndh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akamubhuula akati, “Lamusha, umweghe umwana nu ngʼina, ughaluke ku chiisu icha Isilaeli paapo bhala bhaabho bhakalondagha ukumughogha umwana uyo, bhafwile.” ");
INSERT INTO ndh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Po uYoosefu akanyatuka, akamwegha umwana nu ngʼina, bhakaghaluka ku chiisu icha Isilaeli. ");
INSERT INTO ndh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Loole bhwo aapulika ukuti uAlikelaabho ghwe yuuyo akulongosha ichiisu icha Yuteeya pa bhuyo ubhwa ghwise uHelooti, akooghopa ukubhuuka kula. Po bhwo aasokighwa mu filoota, akatiila nu kubhuuka mu chiisu icha Ghalilaayi, ");
INSERT INTO ndh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akafika nu kwikala mu kaaya aka Naasaleeti. Umwo mwo muumwo ishu likabhombighwa liilyo likayughighwa ku sila iya bhasololi ukuti, “Indiakiitishighwange Munaasaleeti.” ");
INSERT INTO ndh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu mashiku ghala, akabhaapo umundu yumo yuuyo ingamu yaake akabha ghwi Yoohani uMwoshi. Umundu uyo akabhonekagha mu lungalangala ulwa mu Yuteeya. Akalumbililagha akatingi, ");
INSERT INTO ndh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pindukagha nu kwilaata imbiibhi shiinyu, paapo ichitangalala icha kumwanya chipalamiile.” ");
INSERT INTO ndh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","UYoohani ghwe yuuyo akayughighwanga nu musololi uYesaaya ukuti, “Umundu yumo indiakayughaghe ku ishu ilya pamwanya ukufuma mu lungalangala akatingi, ‘Tendekeshanga isila iya Malafyale, gholoshanga muumwo indiakaghendaghe.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","UYoohani akafwalagha umwenda ghuughwo ghukasonighwa na meeya agha ngamila, akiipinyagha umukanda ughwa likwela mu musana ghwake. Soona akalyanga abhopaashi nu bhwuki ubhwa mu chitengele. ");
INSERT INTO ndh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abhandu bhakamwisilagha ukufuma mu kaaya aka Yelusaleemu, mu chiisu chooshi icha Yuteeya na mumbafu shooshi isha lusooko ulwa Yoolotani. ");
INSERT INTO ndh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bhakiilaatagha imbiibhi shaabho, ghwepe akabhooshanga mu lusooko ulwa Yoolotani. ");
INSERT INTO ndh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Loole bhwo uYoohani aatesha muumwo aBhafalisaayi na Bhasandukaayi bhakwisa ku bhwingi kukwake ukuti abhooshe, akabhabhuusha akati, “Mwe bhabhiibhi ungati njoka umwe! Kali, ghwini yuuyo abhasokite ukuti mulikindaghe ilyoyo ilya Chaala? ");
INSERT INTO ndh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bhombagha shiisho shikulangisha ukuti mupindukite nu kuti mwilaatite imbiibhi shiinyu shooshi. ");
INSERT INTO ndh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Manye mwifunaghe ukuti, ‘Usekulu ghwitu utwe ghwi Abhulahamu!’ Ingubhabhuula ukuti uChaala abhaghiile ukumupa uAbhulahamu abhaana ukufuma mu mayondo agha! ");
INSERT INTO ndh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","UChaala ali papiipi ukumulonga umundu ghweshi yuuyo atakubhomba imbombo inyiisa isa umundu yuuyo abhiikite isembe pi ikolo pi ikokwe ukuti lyoshi ikokwe liilyo litakwela iseke inyiisa, akulyomola nu kulitaagha mu mulilo. ");
INSERT INTO ndh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Une ingubhoosha na miishi ukulangisha ukuti mupindukite nu kwilaata imbiibhi shiinyu. Loole kunyuma kukwangu akwisa ughwa maka ukuunginda une. Soona indabhaghiile nu kupimba ifilato fyake. Umwene, ghwe yuuyo indiakabhooshange nu Mbepo uMwelu nu mulilo. ");
INSERT INTO ndh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Umwene indiakabhapaaghulanie abhiisa ukufuma mu bhatulanongwa isa muumwo umulimi akupeeta amapeeta ukufuma mu fyakwinula. Indiakabhabhungaanie abhiisa isa muumwo umulimi akubhungaania ifyakwinula nu kubhiika mu ighulu lyake. Indiakabhaponie abhatulanongwa mu mulilo ghuughwo ghutakushima naalumo isa muumwo umulimi akupemba amapeeta.” ");
INSERT INTO ndh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Po mu kabhalilo kala, uYeesu akafuma ku Ghalilaayi, akiisa kwa Yoohani ku lusooko ulwa Yoolotani ukuti uYoohani amwoshe. ");
INSERT INTO ndh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Loole uYoohani akaghela ukuti akaane, akamubhuusha uYeesu akati, “Po kali, shili bhuleele ukuti ughwe ghwise kukwangu? Une neene ingulondighwa ukwoshighwa nuughwe.” ");
INSERT INTO ndh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","UYeesu akamwamula akati, “Bhomba isho ulu, paapo tukulondighwa tubhombe isho shooshi shiisho uChaala akulonda.” Po uYoohani akiitika, akamwosha. ");
INSERT INTO ndh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bhwo uYeesu ooshighwa, akatiila ukufuma mu miishi. Nakalinga, tesha, kumwanya kukiighuka, akamubhona uMbepo ughwa Chaala akwika pamwanya papaake ungati ngunda. ");
INSERT INTO ndh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Po ishu ukufuma kumwanya likapulikighwa likati, “Uyu Mwana ghwangu umughanighwa, inguhobhoka naghwe.” ");
INSERT INTO ndh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Po uYeesu akalongoshighwa nu Mbepo uMwelu ukubhuuka ku lungalangala ukuti uSeetano amughele. ");
INSERT INTO ndh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","UYeesu akamala ukwo amashiku amalongo manna (40) pabhushiku na pamuusi bhwo iiyiimite ukulya ifindu. Po pabhumalilo, isala yikamubhabha. ");
INSERT INTO ndh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Po uSeetano akiisa pakumughela akati, “Linga ughwe ghwe Mwana ghwa Chaala nalooli, ghabhuule amayondo agha ghasanuke ukubha mikati.” ");
INSERT INTO ndh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","UYeesu akamwamula akati, “Tesha, shisimbiighwe mu Masimbo aMeelu ukuti, ‘Umundu atakubha mwumi ku nongwa iya kulya ifindu fyene, loole akubha mwumi ku ishu lyoshi liilyo likufuma mu mulomu ughwa Chaala.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Po uSeetano akabhuuka nu Yeesu mu kaaya aka Yelusaleemu, akamwimika pa kasonje aka Nyumba iya Chaala, ");
INSERT INTO ndh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akamubhuula akati, “Linga ughwe ghwe Mwana ghwa Chaala nalooli, iponia paase, paapo shisimbiighwe ukuti, ‘UChaala indiakabhatume abhandumi bhaake kukwako ukuti bhakupoke, manye utulundi twako twise twikome mu mayondo.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","UYeesu ghwepe akati, “Tesha, shisimbiighwe soona ukuti, ‘Manye umughelaghe uMalafyale, uChaala ghwako.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pabhumalilo, uSeetano akabhuuka nu Yeesu pamwanya ngaani pa kaghamba akatali, akamulangisha ubhunyafyale bhwoshi pamupeene nu bhukulumba bhwake, ");
INSERT INTO ndh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","akamubhuula akati, “Linga ghwafughamila nu kuunyiipuuta, indiingupe fyoshi ifi.” ");
INSERT INTO ndh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","UYeesu ghwepe akati, “Tiila panu, ghwe Seetano! Tesha, shisimbiighwe ukuti, ‘Mwipuutaghe uMalafyale uChaala ghwako, soona mubhombelaghe yuuyo mweneeshe.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Po uSeetano akamuleka uYeesu pala, nakalinga abhandumi abha Chaala bhakiisa pakumubhombela. ");
INSERT INTO ndh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Po bhwo uYeesu aapulika ukuti uYoohani uMwoshi bhamubhiikite mu nyumba iya bhapinyighwa, akatiila pala, akabhuuka ku chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Bhwo ali mu Ghalilaayi, uYeesu akatiila mu kaaya aka Naasaleeti nu kushaala mu kaaya aka Kapenabhumu. Kapenabhumu kaaya kaako kali kulubhafu ulwa sumbi ughwa Ghalilaayi, kulubhafu ulwa chiisu icha fikolo ifya Sabhulooni ni fya Nafutaali. ");
INSERT INTO ndh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Shikabhombighwa ulwo ukuti ishu lila libhombighwe liilyo uChaala akayugha ku sila iya musololi uYesaaya ukuti, ");
INSERT INTO ndh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ichiisu icha Sabhulooni ni cha Nafutaali, fili ku sila iya kubhuukila kwa sumbi, ku isiila ilya lusooko ulwa Yoolotani, ku Ghalilaayi kula kwo kuukwo bhakwikala abhandu abha fyisu ifinine. ");
INSERT INTO ndh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abhandu bhala bhaabho bhakwikala mu chiisi, bhabhubhweni ubhwelu ubhukulu, na bhaabho bhakwikala mu chiifuuni icha bhufwe, ubhwelu ubhwa pangeelo bhubhabhalishiishe.” ");
INSERT INTO ndh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ukufuma mu kabhalilo kala, uYeesu akaanda ukulumbilila akatingi, “Pindukagha nu kwilaata imbiibhi shiinyu, paapo ichitangalala icha kumwanya chipalamiile.” ");
INSERT INTO ndh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ishiku limo uYeesu akaghendagha kulubhafu kwa sumbi ughwa Ghalilaayi. Bhwo akughenda, akabhabhona abhalobha iswi bhabhili, uSiimoni yuuyo ingamu yaake akabha ghwi Peeteli nu munungʼuna uNdeleeya bhakuponia ifilepa mwa sumbi. ");
INSERT INTO ndh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","UYeesu akabhabhuula akati, “Isagha muungongaghe une! Nuune indiimbabhiike ukubha bhalobha bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Po nakalinga, bhakafileka ifilepa fyabho, bhakamukonga. ");
INSERT INTO ndh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bhwo uYeesu aaghenda pandaashi panandi, akabhabhona abhanamundu abhanine bhabhili, uYaakobhu nu munungʼuna uYoohani, abhaana abha Sebhetaayi. Abhanamundu abho bhakabha mu bhwato pamupeene nu ghwise, bhakatendekeshanga ifilepa fyabho. UYeesu akabhiitisha bhoope, ");
INSERT INTO ndh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nakalinga, bhakamuleka ughwise nu bhwato bhula, bhakamukonga uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","UYeesu akashunguulilagha mu chiisu chooshi icha Ghalilaayi. Akiingilagha mu masinaghoghi agha Bhayuuta, akabhamanyishanga abhandu, akalumbililagha iNongwa iNyiisa isha chitangalala icha kumwanya nu kubhaposha amabhine ghaabho ghooshi agha luko nu luko. ");
INSERT INTO ndh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Po inongwa shaake shikanyaama leka mu chiisu chooshi icha Siiliya. Abhandu bhakabhuuka na bhabhine bhooshi abha mabhine agha luko nu luko. Mu abho, bhakabhaamwo bhaabho bhakabhina leka, bhaabho bhakakolighwa ni mbepo imbiibhi na bhaabho bhakabha na kashilishi na bhalale. UYeesu akabhaposha abho bhooshi. ");
INSERT INTO ndh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Po abhandu abhingi leka bhakamukongagha ukufuma mu chiisu icha Ghalilaayi, mu Ndekapooli, mu Yelusaleemu, mu chiisu icha Yuteeya na mu isiila ilya lusooko ulwa Yoolotani. ");
INSERT INTO ndh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Po bhwo uYeesu aafibhona ifilundilo ifya bhandu fila, akakwela mu kaghamba, akiikala. Po bhwo iikala, abhamanyili bhaake bhakiisa kukwake, ");
INSERT INTO ndh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ghwepe akaanda ukubhamanyisha akati, ");
INSERT INTO ndh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bhasayighwa bhaabho bhapiina mu ndumbula, paapo ichitangalala icha kumwanya chaabho. ");
INSERT INTO ndh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bhasayighwa bhaabho bhali nu bhuswimaane, paapo uChaala indiakabhasubhaashe. ");
INSERT INTO ndh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bhasayighwa bhaabho bholoolo, paapo uChaala indiakabhape ichiisu chooshi. ");
INSERT INTO ndh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bhasayighwa bhaabho bhali ni sala ni nyoota ku shiisho shibhaghiile pandaashi pa Chaala, paapo uChaala indiakabhiikutishe. ");
INSERT INTO ndh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bhasayighwa bhaabho bhakubhapelela ichisa abhanine, paapo uChaala indiakabhapelele ichisa bhoope. ");
INSERT INTO ndh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bhasayighwa bhaabho bhali ni ndumbula yiiyo nyeelu, paapo indibhakamubhone uChaala. ");
INSERT INTO ndh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bhasayighwa bhaabho bhakufwania, paapo uChaala indiakabhiitishe ukubha bhaana bhaake. ");
INSERT INTO ndh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bhasayighwa bhaabho bhakufulashighwa ku nongwa iya kuti bhakubhomba shiisho shibhaghiile pandaashi pa Chaala, paapo ichitangalala icha kumwanya chaabho. ");
INSERT INTO ndh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Muli bhasayighwa linga abhandu bhakubhatuka, bhakubhafulasha nu kubhayughila ubhubhiibhi ubhwa luko nu luko ku nongwa yangu. ");
INSERT INTO ndh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sekelagha ngaani, paapo uChaala abhabhiikiile umufwalo umukulu kumwanya, paapo umwo mwo muumwo abhandu abho bhakabhabhombelagha abhasololi abha Chaala bhaabho bhakatangila mundaashi mumwinyu.” ");
INSERT INTO ndh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Umwe mwe mbeeya iya chiisu. Loole linga imbeeya yaakomanika, kali, chiliipo chiicho chibhaghiile ukubhughalusha ubhwisa bhwake soona? Yitabhaghiile ukubha nu bhwisa soona ku kandu kooshi kala, loole yikubha ya kukupula kuuse nu kukanyighwa na bhandu. ");
INSERT INTO ndh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Umwe mwe bhwelu ubhwa chiisu. Akaaya kaako kasengiighwe pamwanya pa kaghamba, katabhaghiile ukwififa. ");
INSERT INTO ndh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Soona, abhandu bhatakukosha inyaale nu kuyibhiika paase pa chitala, loole bhakuyibhiika pa chitalati ukuti yibhabhalilaghe bhooshi bhaabho bhali mu nyumba. ");
INSERT INTO ndh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bhubhuubhwo nu bhwelu bhwinyu bhukulondighwa bhubhalishange ku bhandu ukuti bhateshange imbombo shiinyu inyiisa, po bhamupaalaghe uGhuuso yuuyo ali kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Manye mwinongʼonaghe ukuti ingiisa ku nongwa iya kushitiisha indaghilo isha Moose, pamu shiisho shikayughighwanga na bhasololi. Nashiku! Indakiisa pakushitiisha, loole pakubhomba shooshi isa muumwo shikayughighwa. ");
INSERT INTO ndh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nalooli ingubhabhuula, ukufika akabhalilo kaako kumwanya ni chiisu indifikatiile, naalimo isimbo inandi ilya ndaghilo liilyo indilikatiile ukufika paapo shooshi indishikabhombighwe. ");
INSERT INTO ndh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mu ndaghilo isho, ghweshi yuuyo akulufuyula nalinga lulaghilo lumo ulunandi nu kuti abhamanyishe abhanine ukuti bhoope bhalufuuye, uyo ghwe yuuyo indiakayughighwe ukuti mukeke ku chitangalala icha kumwanya. Loole ghweshi yuuyo akushikonga nu kubhamanyisha abhanine ukuti bhoope bhabhombaghe ulwo, uyo, ghwe yuuyo indiakayughighwe ukuti ghwi songo ku chitangalala icha kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ingubhabhuula ukuti linga ubhwisa bhwinyu bhutakukinda ubhwa Bhafalisaayi nu bhwa bhamanyishi abha ndaghilo isha Moose, mutaamukiingile naalumo ku chitangalala icha kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mupulikite ukuti abhandu abha bhwila bhakabhuulighwa ukuti, ‘Manye ughoghaghe nu kuti umundu ghweshi yuuyo akumughogha umunine, akulondighwa alongighwe.’ ");
INSERT INTO ndh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Loole une ingubhabhuula ukuti umundu ghweshi yuuyo akumukalalila umunine, akulondighwa ukulongighwa. Soona, ghweshi yuuyo akumutuka umunine ukuti mukonyofu, akulondighwa alongighwe na bhalongi. Soona, ghweshi yuuyo akumutuka umunine ukuti mulema, akulondighwa ukutaaghighwa mu mulilo ughwa Yehanamu! ");
INSERT INTO ndh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Paapo linga kufumya ifyabhupe ku chighemo, loole ghwakumbuka ukuti uleghanite nu munyiinyu, ");
INSERT INTO ndh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ufileke ifyabhupe ifyo pandaashi pa chighemo, ubhuuke upulikane taashi nu munyiinyu yula. Po ghwise pakufumya ifyabhupe fyako ifyo. ");
INSERT INTO ndh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Soona linga kubhuuka pamupeene nu mulughu ghwako ku mulongi, ikaakila ukumusuuma ukuti mupulikane bhwo mukaali muli mu sila ukuti manye iise abhuuke nuughwe ku mulongi. Ghwepe umulongi uyo manye iise akubhiike mu tukono utwa mushikali ukuti upinyighwe mu nyumba iya bhapinyighwa. ");
INSERT INTO ndh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nalooli ingukubhuula, utaaukafume mu nyumba iya bhapinyighwa linga ukaali ukumaliisha ukuhomba indalama iya bhumalilo.” ");
INSERT INTO ndh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mupulikite ululaghilo luulwo lukuti, ‘Manye ubhange mushipani.’ ");
INSERT INTO ndh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Loole une ingubhabhuula ukuti umundu ghweshi yuuyo aamutesha umukolo ku sila iya kumunyonywa, akubha aashipana naghwe mu ndumbula yaake. ");
INSERT INTO ndh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Po linga ilyiso lyako ilya kumwisa likukusofya ukuti ubhombe imbiibhi, lifwombole nu kulitaagha. Paapo kiisa ukukasofya akambakaasha kamu aka mubhili ghwako, ukukinda ukuti umubhili ghwako ghwoshi ghutaaghighwe mu Yehanamu. ");
INSERT INTO ndh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Soona linga akakono kaako aka kumwisa kakukusofya ukuti ubhombe imbiibhi, katumule nu kukataagha. Paapo kiisa ukukasofya akambakaasha kamu aka mubhili ghwako, ukukinda ukuti umubhili ghwako ghwoshi ghutaaghighwe mu Yehanamu.” ");
INSERT INTO ndh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Soona mupulikite ululaghilo luulwo lukuti, ‘Umundu ghweshi yuuyo akumusoosha umukashi, amupe ukalata ughwa kusookana.’ ");
INSERT INTO ndh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Loole une ingubhabhuula ukuti umundu ghweshi yuuyo akumusoosha umukashi bhwo atamukolite ku bhushipani, akumubhiika umukashi ukubha mushipani. Soona, ghweshi yuuyo eegha umukolo yuuyo umulume akamusoosha, po ghwepe akushipana.” ");
INSERT INTO ndh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mupulikite ukuti abhandu abha bhwila bhakabhuulighwa ukuti, ‘Linga kuloolika pandaashi pa Malafyale, manye ukakomaniange soona. Loole ubhombaghe shooshi shiisho ghwaloolikagha.’ ");
INSERT INTO ndh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Loole une ingubhabhuula ukuti manye uloolikaghe lwoshi ukughendela ku ngamu iya kumwanya paapo cho chiicho chitengu icha Chaala. ");
INSERT INTO ndh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pamu manye uloolikaghe ku chiisu paapo po paapo uChaala akubhiika utulundi twake. Pamu manye uloolikaghe ku kaaya aka Yelusaleemu paapo ko kaako kaaya aka Malafyale uSongo, uChaala. ");
INSERT INTO ndh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Soona manye uloolikaghe na ku mutu ghwako paapo utabhaghiile ukusanusha nalinga kangʼwili kamu aka chingʼwili chaako ukubha keelu pamu katiitu. ");
INSERT INTO ndh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Linga mukwitika, mwitikaghe. Pamu linga mukukaana, mukaanaghe. Paapo shiisho shikwongela mu shooshi isho, shikufuma ku Mubhiibhi yula.” ");
INSERT INTO ndh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mupulikite ululaghilo luulwo lukuti, ‘Ilyiso ku lyiso ni lyino ku lyino.’ ");
INSERT INTO ndh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Loole une ingubhabhuula ukuti manye utaanishange ubhubhiibhi ku mundu yuuyo aakubhombela ubhubhiibhi. Loole linga umundu aakukoma ku lusaya ulwa kumwisa, musanushikishe nu lwa kushoomi. ");
INSERT INTO ndh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Soona linga umundu aakusitaaka ku nyango iya kwegha ishaati yaako, muleke eeghe ni ikoti lyako. ");
INSERT INTO ndh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Soona linga umundu akukufimbilisha ukupimba umushigho ghwake ukughufikisha ku kilomiita yimo, ughufikishe umushigho ughwo ku kilomiita shibhili. ");
INSERT INTO ndh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Soona linga umundu akukusuuma akandu, mupe. Soona linga umundu akulonda ukuti umukopele, manye umukaanilaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mupulikite soona ululaghilo luulwo lukuti, ‘Mughanaghe umunyiinyu,’ loole, ‘Mubhengaghe umulughu ghwako.’ ");
INSERT INTO ndh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Loole une ingubhabhuula ukuti bhaghanaghe abhalughu bhiinyu. Soona bhiipuutilaghe kwa Chaala bhooshi bhaabho bhakubhafulasha. ");
INSERT INTO ndh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Po apo indimubhange bhaana abha Ghuuso yuuyo ali kumwanya. Paapo umwene akubhalisha isubha ku bhandu abhiisa na ku bhatulanongwa. Soona akutimya ifula ku bhaabho bhagholofu pamupeene na ku bhaabho bhataa bhagholofu. ");
INSERT INTO ndh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Linga mukubhaghana bheene bhaabho bhabhaghanite umwe, kali, mukupokeela mufwalo ghuki? Kali, abhasongesha songo bhoope bhatakubhaghana bhaabho bhabhaghanite abheene? ");
INSERT INTO ndh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Soona linga mukubhalamuka abhanyiinyu bheene, kali, mukubha mwabhomba kooni aka kukindaapo? Kali, abhandu bhaabho bhatakumwitika uChaala bhoope bhatakubhomba isa bhubhuubhwo? ");
INSERT INTO ndh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Po mubhange bhagholofu isa muumwo uGhuuso yuuyo ali kumwanya mugholofu.” ");
INSERT INTO ndh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","UYeesu akeendelela ukuyugha akati, “Teshanga! Manye mubhombaghe inyiisa pandaashi pa bhandu ukuti bhabhabhone. Paapo linga mukubhomba ulwo, mutaamukapokeele umufwalo ukufuma kwa Ghuuso yuuyo ali kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Po bhwo mukubhaafwa abhapiina, manye mwifumushange ukuti mwilangishe isa muumwo abhongubhisania bhakubhombela mu masinaghoghi na mu sila ukuti abhandu bhabhapaalaghe. Nalooli ingubhabhuula, bhapokeelite ngaanila umufwalo ghwabho. ");
INSERT INTO ndh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Loole ughwe bhwo kubhaafwa abhapiina, akakono kaako aka kushoomi manye kamanyaghe shiisho akakono aka kumwisa kakubhomba, ");
INSERT INTO ndh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ukuti ubhutuuli bhwako bhubhange bhwa ku bhushiifu. Paapo uGhuuso yuuyo akuteshanga shiisho shikubhombighwa ku bhushiifu, indiakakuhombe.” ");
INSERT INTO ndh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","UYeesu akayugha soona akati, “Bhwo mukwipuuta kwa Chaala, manye mubhange ungati bhongubhisania. Paapo abheene bhiighanite ukwilangisha ku bhandu bhwo bhakwipuuta kwa Chaala mu masinaghoghi na mu sila indekaania ukuti abhandu bhabhapaalaghe. Nalooli ingubhabhuula, bhapokeelite ngaanila umufwalo ghwabho. ");
INSERT INTO ndh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Loole ughwe bhwo kwipuuta kwa Chaala, ghwingile ku ifungu nu kupinga ichiighi. Po ghwipuute ku Ghuuso yuuyo atakubhoneka. Po uGhuuso yuuyo akuteshanga shiisho shikubhombighwa ku bhushiifu, indiakakuhombe. ");
INSERT INTO ndh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Soona bhwo mukwipuuta kwa Chaala, manye muyughaghe amashu amingi ghaagho ghatakwafwa naakamu isa muumwo bhakubhomba abhandu bhaabho bhakwipuuta ku bhochaala. Paapo abheene bhakwinongʼona ukuti linga bhakubhomba ulwo, abhochaala bhaabho indibhabhapulike nu kubhaafwa shiisho bhakusuuma. ");
INSERT INTO ndh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Manye mwipuutaghe isa muumwo abheene bhakubhomba, paapo uGhuuso ameenye shiisho mukulonda na bhwo mukaali ukumusuuma. ");
INSERT INTO ndh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Po umwe mwipuutaghe kwa Chaala mutingi, ‘Taata ghwitu ughwa kumwanya, ingamu yaako yipaalighwe. Ichitangalala chaako chiise. ");
INSERT INTO ndh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ubhwighane bhwako bhubhombighwe pa chiisu panu, isa muumwo bhukubhombighwa kumwanya ukwo. ");
INSERT INTO ndh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utupe ifindu ifya kutuyiilana umuusughu. ");
INSERT INTO ndh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utuhobhokele ubhutulanongwa bhwitu, isa muumwo nuutwe tukubhahobhokela bhaabho bhakututulila inongwa. ");
INSERT INTO ndh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Manye utubhiike mu ngelo, loole utupoke ku Mubhiibhi yula. Paapo ubhunyafyale, amaka nu bhukulumba fyako bhwila na bhwila. Ameni.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","UYeesu akayugha soona akati, “Linga mukubhahobhokela abhanyiinyu ubhutulanongwa bhwabho, uGhuuso yuuyo ali kumwanya indiakabhahobhokele nuumwe ubhutulanongwa bhwinyu. ");
INSERT INTO ndh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Loole linga mutakubhahobhokela abhanyiinyu ubhutulanongwa bhwabho, uGhuuso yuuyo ali kumwanya ataaakabhahobhokele nuumwe ubhutulanongwa bhwinyu.” ");
INSERT INTO ndh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","UYeesu akayugha soona akati, “Bhwo mukwiyiima ukulya ifindu, ifyeni fyinyu manye filangishange ubhuswimaane isa muumwo abhongubhisania bhakubhombelagha. Paapo abheene bhakulangishanga ukuswimaana ifyeni fyabho ukuti abhandu bhabhabhone ukuti bhiiyiimite ukulya ifindu. Nalooli une ingubhabhuula, umufwalo ghwabho bhapokeelite ngaanila. ");
INSERT INTO ndh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Loole ughwe linga ghwiyiimite ukulya ifindu, upakalaghe inyemba ku mutu nu kusukusula ku maaso, ");
INSERT INTO ndh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ukuti abhandu manye bhamanyaghe ukuti ghwiyiimite ukulya ifindu. UGhuuso yuuyo atakubhoneka pabhwelu, ghwe yuuyo amanyaghe mwene. Po uGhuuso yuuyo akwendelela ukutesha shiisho shikubhombighwa ku bhushiifu, indiakakuhombe.” ");
INSERT INTO ndh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","UYeesu akayugha soona akati, “Manye musengulaghe ichuuma pa chiisu panu, paapo uluswa ni ngamwa fikukomanianga na paapo abhiifi bhakunyololagha nu kwibha. ");
INSERT INTO ndh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Loole sengulagha ichuuma chiinyu kumwanya kuukwo uluswa ni ngamwa fitakukomania na kuukwo abhiifi bhatakunyolola pamu ukwibha. ");
INSERT INTO ndh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Paapo kuukwo mukusengula ichuuma chiinyu, kwo kuukwo ni ndumbula shiinyu indishikabhange. ");
INSERT INTO ndh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Amaaso ghaako ghali ungati nyaale iya mubhili. Linga amaaso ghaako ghali akiisa, ubhaghiile ukutesha akiisa kooshi akandu. ");
INSERT INTO ndh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Loole linga ilyiso lyako libhofu, po umubhili ghwako ghwoshi ghukubha ni chiisi. Linga ubhwelu bhuubhwo bhuli mukati yaako bhwabha chiisi, po ichiisi chikubha chingi leka! ");
INSERT INTO ndh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ataliipo umubhombi yuuyo abhaghiile ukubhabhombela abhomalafyale bhabhili ku kabhalilo kamukeene. Paapo abhaghiile ukumughana umalafyale yumo nu kwifumya kukwake nu kumufuuya umunine. Mutabhaghiile ukumubhombela uChaala ni ndalama ku kabhalilo kamukeene!” ");
INSERT INTO ndh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","UYeesu akayugha soona akati, “Po ingubhabhuula, manye mupaashange ku sha bhwumi bhwinyu ukuti indimulyange kooni, indimungʼwange kooni pamu ukuti indimufwalaghe kooni. Kali, ubhwumi bhutali nu lughindiko ukukinda ifindu, nu mubhili ghwope ghutali nu lughindiko ukukinda imyenda? ");
INSERT INTO ndh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Teshanga utuyuni utwa kumwanya. Tutakubhyala, tutakwinula nu kusengula ifindu naafimo mu maghulu, loole poope uGhuuso yuuyo ali kumwanya, akutuliisha. Po kali, umwe mutali nu lughindiko ukukinda utuyuni utwo? ");
INSERT INTO ndh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kali, ghwini pakati papiinyu yuuyo abhaghiile ukwiyongelesha nalinga lishiku limo mu bhwumi bhwake ku sila iya kupaasha ku sha bhwumi? ");
INSERT INTO ndh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kali, kooni mukupaasha ku sha fiifyo indimufwalaghe? Teshanga ubhulenge ubhwa mu chiposo muumwo bhukumelela! Bhutakubhomba imbombo, soona bhutakwisonela imyenda. ");
INSERT INTO ndh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Loole ingubhabhuula ukuti nu malafyale uSolomooni mu bhukulumba bhwake bhwoshi atakafwalagha akiisa ungati bhulenge ubhwo! ");
INSERT INTO ndh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Po linga uChaala akughafwasha amaani agha mu chiposo ghaagho ghaliipo umuusughu loole ningeelo ghakutaaghighwa mu mulilo, kali, ataaakoongeleepo ukubhafwasha umwe, mwe bhandu abha lwitiko ulunandi? ");
INSERT INTO ndh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Po manye mutaamighwange ukuti, ‘Inditulyange kooni, inditungʼwange kooni pamu inditufwalaghe kooni.’ ");
INSERT INTO ndh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Paapo shooshi isho sho shiisho abhandu abha mu chiisu ichi bhaabho bhatamumeenye uChaala bhakwikaakila ukushilonda, loole uGhuuso yuuyo ali kumwanya ameenye akiisa ukuti mukushilonda shooshi isho. ");
INSERT INTO ndh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Loole umwe chilondaghe taashi ichitangalala icha Chaala nu kubhomba shiisho shibhaghiile pandaashi papaake, po ni finine fyoshi ifyo indiakabhoongeleshe. ");
INSERT INTO ndh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Po manye mupaashange ku sha ningeelo paapo isha ningeelo indishikiibhombe sheene. Lyoshi ishiku lili nu bhutolwe bhwake.” ");
INSERT INTO ndh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Po uYeesu akayugha akati, “Manye mumulongaghe umunyiinyu ukuti uChaala manye akabhalonge nuumwe. ");
INSERT INTO ndh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Paapo muumwo mukubhalonga abhandu abhanine, mwo muumwo uChaala indiakabhalonge nuumwe. Soona, ichipimilo chiicho mukubhapimila abhanine, cho chiicho uChaala indiakabhapimile nuumwe. ");
INSERT INTO ndh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Kali, kooni kutesha akapaato kaako kali mu lyiso ilya munyiinyu, loole utakutesha ichibhali icha likokwe chiicho chili mu lyiso lyako? ");
INSERT INTO ndh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Soona, kali, ubhaghiile bhuleele ukumubhuula umunyiinyu ukuti, ‘Isagha ingutiishe akapaato aka likokwe kaako kali mu lyiso lyako,’ bhwo mu lyiso lyako yughweghwe muli ni chibhali icha likokwe? ");
INSERT INTO ndh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ghwe ngubhisania ughwe! Tiisha taashi ichibhali icha likokwe chiicho chili mu lyiso lyako, po indiuteshe akiisa nu kutiisha akapaato kaako kali mu lyiso ilya munyiinyu! ");
INSERT INTO ndh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Manye mubhapange abhokabhwa ifindu fiifyo fya Chaala ukuti manye bhiise bhabhaghalabhukile nu kubhanyaapulania. Soona manye mushiponekeshange ingulubhe ifindu ifya mutengo ukuti manye shiise shifikanyanganie.” ");
INSERT INTO ndh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","UYeesu akayugha soona akati, “Suumagha kwa Chaala, ghwepe indiabhapange. Londagha ukufuma kwa Chaala, indimufyaghaghe. Ighushanga, ghwepe uChaala indiabhiighulilaghe ichiighi. ");
INSERT INTO ndh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Paapo umundu ghweshi yuuyo akusuuma, uChaala akumupa, ghweshi yuuyo akulonda, akufyagha. Soona, ghweshi yuuyo akwighusha, uChaala akumwighulila ichiighi. ");
INSERT INTO ndh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kali, ghwini pakati papiinyu yuuyo linga umwana ghwake aamusuuma umukati, akumupa iyondo? ");
INSERT INTO ndh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pamu kali, ghwini pakati papiinyu yuuyo linga umwana ghwake aamusuuma iswi, akumupa injoka? ");
INSERT INTO ndh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Po linga umwe, mwe muli bhabhiibhi mumeenye ukubhapa abhaana bhiinyu utundu utwisa, kali, uGhuuso yuuyo ali kumwanya ataaakoongeleepo ukubhapa inyiisa abhandu bhaabho bhakumusuuma? ");
INSERT INTO ndh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Po bhabhombelaghe abhandu abhanine isa muumwo mukulonda abheene bhabhabhombelaghe umwe. Paapo isho sho shiisho ndingaanio isha ndaghilo isha Moose ni fimanyisho ifya bhasololi.” ");
INSERT INTO ndh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Po uYeesu akayugha soona akati, “Ingilagha ukughendela pa mulyango umufinye paapo umulyango umupasamu ghukubhuuka ku lupyuto ulwa bhwila na bhwila, ni sila iya kubhuuka ukwo mbasamu leka. Soona, abhandu bhaabho bhakughenda umwo, bhingi. ");
INSERT INTO ndh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Loole umulyango ghuughwo ghukubhuuka ku bhwumi mufinye, ni sila iya kubhuukila ukwo finye, soona abhandu bhaabho bhakuyaagha, bhanandi.” ");
INSERT INTO ndh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","UYeesu akeendelela ukuyugha akati, “Mubhange maaso na bhasololi abha bhumyashi. Paapo bhwo bhakubhiisila, bhakwibhiikagha ukubha ungati bhonangʼooshi. Loole mu ndumbula shaabho bhakali ungati bhondekelakatu. ");
INSERT INTO ndh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Abhandu abho indimubhamanyaghe mu seke shaabho. Paapo abhandu bhatakwinula iseke isha misabhibhu mu makokwe agha myifwa. Soona bhatakwinula iseke isha mikuyu mu makokwe agha kapelekeeshi. ");
INSERT INTO ndh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Po ikokwe lyoshi ilyisa, likwela iseke inyiisa, loole ikokwe lyoshi ibhiibhi, likwela iseke imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Litaliipo ikokwe ilyisa liilyo likwela iseke imbiibhi. Soona naalimo ikokwe ibhiibhi liilyo likwela iseke inyiisa. ");
INSERT INTO ndh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ikokwe lyoshi liilyo litakwela iseke inyiisa, likutumulighwa nu kutaaghighwa mu mulilo. ");
INSERT INTO ndh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Po abhasololi abha bhumyashi abho, indimubhamanyaghe mu seke shaabho.” ");
INSERT INTO ndh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Po akeendelela ukumanyisha akati, “Bhataa bhandu bhooshi bhaabho bhakuyugha bhakuti, ‘Ghwe Malafyale, ghwe Malafyale,’ indibhakiingile ku chitangalala icha kumwanya. Loole umundu yuuyo akubhomba ubhwighane ubhwa Taata yuuyo ali kumwanya, uyo ghwe yuuyo indiakiingile. ");
INSERT INTO ndh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pi ishiku ilya bhulongi liilyo likwisa, abhandu abhingi indibhakaambulaghe bhakatingi, ‘Ghwe Malafyale, ghwe Malafyale! Kali, tutakasololagha ukubhombela ingamu yaako? Soona, kali, tutakashikiishanga imbepo imbiibhi nu kubhomba ifyika ifyingi ukubhombela ingamu yaako?’ ");
INSERT INTO ndh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Apo po paapo indiingabhabhuule pabhwelu indiingati, ‘Indabhameenye umwe shiku! Tiilaapo panu, mwe bhabhomba mbiibhi umwe!’ ” ");
INSERT INTO ndh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","UYeesu akayugha soona akati, “Po umundu ghweshi yuuyo akughapulika amashu ghangu nu kughabhombela imbombo, indiakabhe isa umundu ughwa mahala yuuyo akasenga inyumba yaake pa lyalabhwe. ");
INSERT INTO ndh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bhwo ifula inyingi yaatima, ulusooko lukiisula ngaani, ichikungu ichikali chikakuka nu kuyisungila inyumba yila. Poope inyumba yila yitakaghwa paase paapo ulwalilo lwake lukasengighwa pa lyalabhwe. ");
INSERT INTO ndh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Loole umundu ghweshi yuuyo akupulika shiisho inguyugha chishita kushibhombela imbombo, ali isa umundu umulema yuuyo akasenga inyumba yaake pa musanga chishita kubhiika ulwalilo ulwa maka. ");
INSERT INTO ndh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bhwo ifula yaatima, ulusooko lukiisula, ichikungu ichikali chikakuka nu kuyisungila inyumba yila, nakalinga yikaghwa paase nu kukomanika lwoshi.” ");
INSERT INTO ndh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bhwo uYeesu aamala ukuyugha amashu agho, ifilundilo ifya bhandu fila fikaswigha leka ni fimanyisho fyake. ");
INSERT INTO ndh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Paapo atakamanyishanga ungati bhamanyishi abha ndaghilo isha Moose, loole akamanyishanga ungati mundu yuuyo ali na maka. ");
INSERT INTO ndh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bhwo uYeesu iilomuka ku kaghamba kala, ichilundilo ichikulu icha bhandu chikamukonga. ");
INSERT INTO ndh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tesha, umundu yumo yuuyo akabha ni mbungo iya makete akabhuuka kwa Yeesu, akafughamila pandaashi papaake, akamusuuma akati, “Ghwe Malafyale, linga ghwighanite ubhaghiile ukuunyeelufya.” ");
INSERT INTO ndh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","UYeesu akagholosha akakono kaake, akamweghelesha umubhine yula, akamubhuula akati, “Niighanite, elupa!” Nakalinga, umundu yula akapola imbungo iya makete yila. ");
INSERT INTO ndh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","UYeesu akamusokeesha umundu yula akati, “Manye umubhuulaghe umundu naayumo inongwa ishi! Loole bhuuka ghwilangishe ku mupuuti, ufumye ifyabhupe ifya kupemba isa muumwo uMoose akalaghilila ukulangisha ukuti upolite.” ");
INSERT INTO ndh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bhwo uYeesu iingila mu kaaya aka Kapenabhumu, usongo yumo ughwa bhashikali akiisa pakusuuma ubhutuuli kwa Yeesu, akamubhuula ");
INSERT INTO ndh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akati, “Ghwe Malafyale, umubhombi ghwangu kukaaya alalite, akutaamighwa leka. Ingukusuuma ghwise umuposhe.” ");
INSERT INTO ndh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","UYeesu akamwamula akati, “Indiniise pakumuposha.” ");
INSERT INTO ndh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Loole usongo yula akamubhuula akati, “Nashiku Malafyale! Indaa mubhaghile ukuti ghwingile mu nyumba yangu. Yugha ishu lyene, umubhombi ghwangu indiapole. ");
INSERT INTO ndh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Paapo nuune indi paase pa bhosongo. Soona indi na bhashikali bhaabho bhali paase papangu. Linga naamubhuula yumo ukuti, ‘Bhuuka!’ nakalinga ghwepe akubhuuka. Soona linga naamubhuula umunine ukuti, ‘Isagha!’ nakalinga ghwepe akwisa. Nu mutumwa ghwangu muumwo ingumubhuulila, mwo muumwo akubhombela.” ");
INSERT INTO ndh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bhwo uYeesu aaghapulika amashu agho, akaswigha leka, akabhabhuula bhaabho bhakamukongagha akati, “Nalooli ingubhabhuula ukuti, indamubhweni naalumo umundu yuuyo ali nu lwitiko ulukulu isa ulu mu chiisu chooshi icha Isilaeli! ");
INSERT INTO ndh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ingubhabhuula ukuti abhandu abhingi indibhakafume kuukwo isubha likufumila na kuukwo isubha likukilila, indibhakiikale nu kulya pamupeene nu Abhulahamu, uIsiyaka nu Yaakobhu mu chitangalala icha kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Loole aBhaisilaeli abhingi bhaabho bhapaapiighwe ukuti bhabhange bha chitangalala icho, abho indibhakataaghighwe kuuse ku chiisi kuukwo indibhakalilaghe nu kushesheetusha amiino ku nongwa iya bhubhafu ubhukali.” ");
INSERT INTO ndh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Po uYeesu akamubhuula usongo yula akati, “Bhuukagha! Shibhe isa muumwo ulwitiko lwako lubheeliile.” Nakalinga, umubhombi ghwake yula akapola akabhalilo kala kala. ");
INSERT INTO ndh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","UYeesu akiingila mu nyumba iya Peeteli, akamwagha umwo ungʼinafyala ughwa Peeteli aghonite pa chitala, ali ni sekema. ");
INSERT INTO ndh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Po uYeesu akamukola akakono, nakalinga akapola isekema yila. Po akanyatuka nu kwanda ukumutendekeshekesha uYeesu ifindu. ");
INSERT INTO ndh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bhwo lyabha lya namasubha, bhakamwisila uYeesu na bhandu abhingi bhaabho bhakakolighwa ni mbepo imbiibhi. Ghwepe akashikiisha imbepo isho ku ishu lyake. Soona akabhaposha bhooshi bhaabho bhakabha bhabhine. ");
INSERT INTO ndh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Isho shikabhombighwa ukuti libhombighwe ishu lila liilyo likayughighwa nu musololi uYesaaya ukuti, “Akeegha ubhwonywa bhwitu nu kughapimba amabhine ghiitu.” ");
INSERT INTO ndh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bhwo uYeesu aatesha ukuti abhandu abhingi bhakumushunguulila, akabhalaghila abhamanyili bhaake ukuti bhalobhoke usumbi, bhabhuuke ku isiila. ");
INSERT INTO ndh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Po umumanyishi yumo ughwa ndaghilo isha Moose akapalamila kwa Yeesu, akamubhuula akati, “Ghwe Mumanyishi, indiingukongaghe kwoshi kuukwo kubhuuka.” ");
INSERT INTO ndh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","UYeesu akamwamula akati, “Abhombila bhali ni mbako nu tuyuni tuli ni fifumbo, loole uMwana ughwa Mundu atali na pa kughoneka umutu ghwake!” ");
INSERT INTO ndh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Po umumanyili umunine akamubhuula uYeesu akati, “Ghwe Malafyale, ingukusuuma ghuunyiitikishe imbuuke taashi pakumushiila utaata.” ");
INSERT INTO ndh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","UYeesu akamwamula akati, “Ughwe ingongaghe! Bhaleke abhafwe bhabhashiilaghe abhafwe bhaabho.” ");
INSERT INTO ndh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Po uYeesu akiingila mu bhwato na bhamanyili bhaake bhoope bhakamukonga mula mula. ");
INSERT INTO ndh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Po bhwo bhali mwa sumbi yula, nakalinga ichikungu ichikali leka chikiisa ni nguli shikaanda ukubhwifunika ubhwato. Loole uYeesu akabha apitiile. ");
INSERT INTO ndh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Po abhamanyili bhaake bhakiisa pakumulamusha, bhakakuuta bhakati, “Ghwe Malafyale ghwitu! Tupoke! Tukufwa!” ");
INSERT INTO ndh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ghwepe akati, “Kali, kooni mukwoghopa umwe mwe bha lwitiko ulunandi?” Po akiima, akachikemela ichikungu ichikali chila nu sumbi yula, kukabha myee lwoshi. ");
INSERT INTO ndh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abhamanyili bhaake bhakaswigha, bhakati, “Kali, mundu yuki uyu yuuyo ichikungu ichikali ni nguli isha mu nyanja fikumupulika?” ");
INSERT INTO ndh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bhwo uYeesu aalobhoka usumbi, akafika mu chiisu icha Bhaghataala. Akakomaana na bhandu bhabhili abha mbepo imbiibhi bhaabho bhakafuma ku mapumba. Abhandu abho bhakabha bhakali leka nu kuti naayumo umundu yuuyo akaghelagha ukughenda kuukwo bhali. ");
INSERT INTO ndh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Po bhakaywegha bhakati, “Ghwe Mwana ghwa Chaala, kali, tuli ni nongwa yiki nuughwe? Kali, ghwisile pakutufulasha bhwo akabhalilo kakaali?” ");
INSERT INTO ndh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pabhutaliipo, abhandu bhamu bhakaliishanga umutiimo umukulu ughwa ngulubhe. ");
INSERT INTO ndh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Po imbepo imbiibhi shila shikamusuuma uYeesu shikati, “Linga kutukiisha, ututume ku mutiimo umukulu ughwa ngulubhe ghula.” ");
INSERT INTO ndh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ghwepe akati, “Bhuukagha!” Po imbepo imbiibhi shikatiila mu bhandu bhala, shikabhuuka nu kwingila lubhilo mu ngulubhe shila. Nakalinga, ingulubhe shooshi shikiilomuka mwa sumbi nu kutwibha mula. ");
INSERT INTO ndh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abhaliishi abha ngulubhe bhwo bhaashibhona isho, bhakakindila mu kaaya akakulu. Bhakaanda ukubhalingaania abhandu shooshi shiisho shikabhombighwa ku bha mbepo imbiibhi bhala. ");
INSERT INTO ndh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Abhandu bhooshi abha mu kaaya kala, bhakakindila pamupeene kwa Yeesu. Po bhwo bhaamubhona, bhakamusuuma ngaani ukuti atiileemwo mu chiisu chaabho. ");
INSERT INTO ndh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","UYeesu akiingila mu bhwato, akalobhoka usumbi ughwa Ghalilaayi nu kughaluka mu kaaya kaake. ");
INSERT INTO ndh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Po abhandu bhamu bhakiisa kwa Yeesu nu mundu yuuyo akabha alalite, bhakamupimba pa bhulili. Bhwo uYeesu aatesha ulwitiko lwabho, akamubhuula umundu ughwa bhulale yula akati, “Ghwe mwana ghwangu, ikasha indumbula! Ghwahobhokelighwa imbiibhi shaako.” ");
INSERT INTO ndh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Po abhamanyishi bhamu abha ndaghilo isha Moose bhaabho bhakabhaapo pala, bhakiiyughaania mu ndumbula shaabho bhakati, “Tesha, umundu uyu akumufuyula uChaala!” ");
INSERT INTO ndh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Loole uYeesu akashimanya inyinongʼono shaabho, akabhabhuusha akati, “Kali, kooni mukwinongʼona amabhiibhi mu ndumbula shiinyu? ");
INSERT INTO ndh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Po kali, liliku liilyo lipepe ngaani? Kali, kwo kumubhuula ukuti, ‘Ghwahobhokelighwa imbiibhi shaako,’ pamu ukumubhuula ukuti, ‘Nyatuka, ghendagha’? ");
INSERT INTO ndh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Une ingulonda mumanye akiisa ukuti uMwana ughwa Mundu ali na maka agha kuhobhokela imbiibhi pa chiisu panu.” Po uYeesu akamubhuula umundu yula yuuyo akabha alalite akati, “Ghwe mwana ghwangu, ingukubhuula, iima! Pimba ubhulili bhwako, bhuukagha kukaaya kaako.” ");
INSERT INTO ndh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Po umundu yula akiima, akabhuuka kukaaya kaake. ");
INSERT INTO ndh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bhwo abhandu bhaabho bhakabha chilundilo ichikulu bhaashibhona isho, bhakooghopa leka. Bhakamupaala uChaala yuuyo akabhapa abhandu amaka isa agho. ");
INSERT INTO ndh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bhwo uYeesu aatiila pala, akamubhona umusongesha songo yumo yuuyo ingamu yaake ghwi Mataayi, iikiile mu nyumba muumwo akasongeshanga isongo. UYeesu akamubhuula akati, “Ghwe Mataayi, ingongaghe.” Nakalinga akanyatuka, akafileka fyoshi, akaanda ukumukonga uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Po uYeesu akabhuuka pakulya ifindu kukaaya aka Mataayi. Bhwo bhali mu nyumba mula, bhakiingila abhasongesha songo abhingi na bhatulanongwa bhamu, bhakiikala nu kulya pamupeene nu Yeesu na bhamanyili bhaake. ");
INSERT INTO ndh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bhwo aBhafalisaayi bhaashibhona isho, bhakabhabhuusha abhamanyili bhaake bhala bhakati, “Kali, kooni umumanyishi ghwinyu akulya pamupeene na bhasongesha songo na bhatulanongwa?” ");
INSERT INTO ndh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Loole bhwo uYeesu aapulika isho, akabhabhuula akati, “Abhandu bhaabho bhataa bhabhine bhatakumulonda umughanga, loole abhabhine bho bhaabho bhakumulonda umughanga! ");
INSERT INTO ndh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Po bhuuka mumanyile amalingaanio agha mashu agha, ‘Ingulonda ukuti mupelelanaghe ichisa ukukinda ukuufumikisha ifyabhupe.’ Paapo indakiisa pakubhiitisha abhandu bhaabho bhakubhomba shiisho shibhaghiile pandaashi pa Chaala, loole ingiisa pakubhiitisha abhandu bhaabho bhatulanongwa.” ");
INSERT INTO ndh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Po abhamanyili abha Yoohani bhakabhuuka kwa Yeesu, bhakamubhuusha bhakati, “Utwe na Bhafalisaayi tukwiyiima ukulya ifindu. Kali, kooni abhamanyili bhaako abheene bhatakwiyiima ukulya ifindu?” ");
INSERT INTO ndh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","UYeesu akabhaamula akati, “Abhandu bhaabho bhabhapaaliile ku bhweghi, kali, bhabhaghiile bhuleele ukuswimaana bhwo bhali pamupeene na yuuyo akwegha? Loole mu mashiku ghaagho ghakwisa, abhandu indibhakamutiishe yuuyo akwegha pakati pa bhaheesha bhaake. Po abhaheesha bhaake abho indibhakiiyiime ukulya ifindu. ");
INSERT INTO ndh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ataliipo umundu yuuyo akwegha ichilaka chiicho chipya ukuti achisoneelele ku mwenda umukuulu. Paapo ichilaka icho chikunyaapula umwenda ughwo ku nongwa iya kuti chisoniighwe ku mwenda umukuulu, na pala paapo pakunyaapuka pakwongelagha ngaani. ");
INSERT INTO ndh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Soona bhataliipo abhandu bhaabho bhakubhiika indifaayi imbya mu nyambi isha likwela ikuulu. Paapo linga bhaabhomba ulwo, indifaayi yila yikunyaapula inyambi, yikukupuka yooshi ni nyambi shoope shikukomanika. Loole abhandu bhakubhiika indifaayi imbya mu nyambi isha likwela ipya. Po fyoshi fibhili, inyambi isho ni ndifaayi iyo fikubha akiisa!” ");
INSERT INTO ndh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bhwo uYeesu akaali akuyugha na bhamanyili abha Yoohani, nakalinga, umulongoshi yumo akiisa, akafughamila pandaashi papaake ukulangisha ulughindiko, akamubhuula akati, “Umulindu ghwangu aafwa luluulu. Poope ingukusuuma tubhuuke umwegheleshe, ghwepe indiabhe mwumi soona.” ");
INSERT INTO ndh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Po uYeesu akanyatuka pamupeene na bhamanyili bhaake, bhakamukonga umulongoshi yula. ");
INSERT INTO ndh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tesha, mu kabhalilo kala kala umukolo yumo yuuyo akabha nu bhubhine ubhwa kufuma ibhanda ku fyinja kalongo na fibhili (12), akiisa kunyuma kwa Yeesu nu kweghelesha ku chipeto icha mwenda ghwake. ");
INSERT INTO ndh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Paapo akayugha mu ndumbula yaake akati, “Linga neegheleshaashe umwenda ghwake, indiimbole.” ");
INSERT INTO ndh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bhwo eeghelesha, nakalinga, uYeesu akasanuka kunyuma. Po bhwo aamubhona umukolo yula, akamubhuula akati, “Ghwe mulindu, ikasha indumbula, ghwapola ku nongwa iya kuti kuunyiitika une.” Nakalinga, umukolo yula akapola. ");
INSERT INTO ndh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bhwo uYeesu aafika mu nyumba iya mulongoshi yula, akabhaagha abhandu abhingi bhabhungaanite, bhali pakulila ifwa. Bhamu bhakakubhagha amalongi. ");
INSERT INTO ndh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","UYeesu akabhabhuula akati, “Mwe bhandu umwe, tiilaapo panu! Umulindu uyu atafwile, loole apitiileeshe!” Bhwo abhandu bhala bhaapulika ulwo, bhakamuseka uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Po akabhafumya kuuse, akiingila ku ifungu, akamukola akakono umulindu yula, ghwepe akanyatuka. ");
INSERT INTO ndh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Inongwa isho shikafumukwa mu chiisu chila chooshi. ");
INSERT INTO ndh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bhwo uYeesu aatiila pala, abhafwamaaso bhabhili bhakamukonga, bhakiitisha ku ishu ilya pamwanya bhakati, “Ghwe Malafyale, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, tukusuuma tupelele ichisa!” ");
INSERT INTO ndh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Po uYeesu akiingila mu nyumba, abhafwamaaso bhala bhakabhuuka kukwake. Po akabhabhuusha akati, “Kali, mukwitika ukuti imbaghiile ukubhaposha?” Bhakamwamula bhakati, “Inga, Malafyale! Tukwitika.” ");
INSERT INTO ndh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Po uYeesu akabheeghelesha amaaso ghaabho, akabhabhuula akati, “Shibhombighwe kukwinyu isa muumwo ulwitiko lwinyu lubheeliile.” ");
INSERT INTO ndh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nakalinga, amaaso ghaabho ghakiighuka. UYeesu akabhasokeesha ku maka akati, “Manye mumubhuulaghe umundu naayumo inongwa ishi!” ");
INSERT INTO ndh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Poope bhakabhuuka, bhakafumusha inongwa shaake mu chiisu chila chooshi. ");
INSERT INTO ndh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bhwo abhandu bhala bhaatiilaapo pala, abhanine bhakamwisila uYeesu nu mundu yumo yuuyo akabha akoliighwe ni mbepo imbiibhi yiiyo yikamupelela ubhwochinuunu. ");
INSERT INTO ndh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","UYeesu akayikiisha imbepo imbiibhi yila, nakalinga, umundu yula akaanda ukuyugha soona. Abhandu bhaabho bhakabhaapo pala bhakaswigha leka, bhakati, “Mu chiisu chooshi icha Isilaeli shitabhonekite naalumo isa shishiishi!” ");
INSERT INTO ndh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Loole aBhafalisaayi bhakayugha bhakati, “Tesha, akushikiisha imbepo imbiibhi ku maka agha songo ughwa mbepo imbiibhi!” ");
INSERT INTO ndh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Po uYeesu akaghendagha mu twaya utukulu twoshi na mu twaya utunandi. Pooshi paapo akaghendagha, akiingilagha mu masinaghoghi, akabhamanyishanga abhandu, akalumbililagha iNongwa iNyiisa isha chitangalala icha kumwanya nu kubhaposha amabhine ghaabho ghooshi agha luko nu luko. ");
INSERT INTO ndh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Po bhwo aafibhona ifilundilo ifya bhandu, akabhapelela ichisa. Paapo bhakataamighwanga, bhatakabha nu ghwa kubhaafwa, bhakabha ungati bhonangʼooshi bhaabho bhatali nu muliishi. ");
INSERT INTO ndh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Po akabhabhuula abhamanyili bhaake akati, “Ifyakwinula fyo fyingi leka, loole abhiinuli bhanandi. ");
INSERT INTO ndh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Po musuumaghe uMalafyale yuuyo mwene mughunda ukuti abhatume abhabhombi mu mughunda ghwake.” ");
INSERT INTO ndh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","UYeesu akabhiitisha abhamanyili bhaake kalongo na bhabhili, akabhapa amaka agha kushikiisha imbepo imbiibhi na gha kuposha amabhine ghooshi nu bhwonywa ubhwa luko nu luko. ");
INSERT INTO ndh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Po ingamu isha bhatumighwa kalongo na bhabhili abho sho ishi, ughwa bhwandilo ghwi Siimoni yuuyo uYeesu akamupa ingamu iya Peeteli nu munungʼuna uNdeleeya, uYaakobhu nu munungʼuna uYoohani, abhaana abha Sebhetaayi, ");
INSERT INTO ndh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","uFilipu, uBhatolomaayi, uToomasi, uMataayi umusongesha songo, uYaakobhu umwana ughwa Alufeeyo, uTandaayi, ");
INSERT INTO ndh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","uSiimoni uMukananaayi nu Yuuta Isikaliyooti, yuuyo pabhumalilo akiisa aamubhiika uYeesu mu tukono utwa bhalughu. ");
INSERT INTO ndh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","UYeesu akabhatuma kalongo na bhabhili abho, akabhalaghilila akati, “Manye mubhuukaghe ku bhandu bhaabho bhataa Bhayuuta, soona manye mukiingilaghe mu twaya twoshi utwa Samaliiya. ");
INSERT INTO ndh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Loole mubhuukaghe ku Bhaisilaeli bhaabho bhasobhite ungati bhonangʼooshi. ");
INSERT INTO ndh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Soona bhwo mukughenda mula, mulumbililaghe mutingi, ‘Ichitangalala icha kumwanya chipalamiile.’ ");
INSERT INTO ndh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bhaposhange abhabhine, bhashuushange abhafwe, bheelufyange bhaabho bhali ni mbungo iya makete nu kushikiisha imbepo imbiibhi. Paapo uChaala abhapiile pabhuubhu, nuumwe fumyanga pabhuubhu. ");
INSERT INTO ndh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Manye mweghaghe isahabhu, indalama pamu isalabhasha mu nyambi shiinyu. ");
INSERT INTO ndh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Manye mweghaghe inyambi, umwenda ughwa bhubhili ughwa kuchenjesania, ifilato pamu ingoomo isha kughendela. Paapo umubhombi akulondighwa ukupeeliighwa umufwalo ukufuma ku bhandu bhaabho akubhabhombela. ");
INSERT INTO ndh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Akaaya kooshi kaako indimukiingilaghe, kabhe kakulu pamu kanandi, mukamulondaghe umundu yuuyo mubhaghile ukubhapokeela umwe. Po mukiikalaghe kukwake ukufika ku kabhalilo kaako indimukatiilaghe. ");
INSERT INTO ndh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bhwo mukwingila mu nyumba, mukabhalamukaghe abhenekaaya ukuti bhabhange nu lutengaano. ");
INSERT INTO ndh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Po linga abhandu abha mu nyumba iyo bhabhaghile ukupokeela ulutengaano, po uChaala indiabhapange ulutengaano. Loole linga bhataa bhabhaghile, ulutengaano ulwo indilukabhaghalukile umwe. ");
INSERT INTO ndh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Linga umundu aaya akaana ukubhapokeela pamu ukubhapulikisha, po mukakungʼundaghe ulufumbi luulwo luli mu tulundi twinyu bhwo mukufumaamwo mu nyumba pamu mu kaaya kaake. ");
INSERT INTO ndh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nalooli ingubhabhuula, pi ishiku ilya bhulongi indishikabhe mbepe ku kaaya aka Sondoma na ka Ghomoola ukupona ubhulongi ukukinda akaaya kala!” ");
INSERT INTO ndh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mubhange maaso, ingubhatuma isa abhonangʼooshi pakati pa bhondekelakatu. Po mubhange bha mahala ungati njoka, soona mubhange bholoolo ungati ngunda. ");
INSERT INTO ndh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mubhange maaso na bhandu, paapo indibhakabhabhiikaghe mu mabhalaasa agha bhosongo, soona indibhakabhakomaghe mu masinaghoghi ghaabho. ");
INSERT INTO ndh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Indibhakabhuukaghe nuumwe pandaashi pa bhosongo abha chiisu na pandaashi pa bhomalafyale ku nongwa yangu ukuti mubhe bhakeeti pandaashi papaabho na pandaashi pa bhandu abha fyisu fyoshi. ");
INSERT INTO ndh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bhwo bhakubhuuka nuumwe ku bhosongo, manye mukapaashange ukuti indimukayughaghe kooni, pamu indimukayughaghe bhuleele. Paapo uChaala indiakabhape shiisho indimukayughaghe ku kabhalilo kala kala. ");
INSERT INTO ndh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Paapo mutaa mwemwe indimukayughaghe, loole ghwi Mbepo ughwa Ghuuso ghwe yuuyo indiakayughaghe mu ndumbula shiinyu. ");
INSERT INTO ndh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ku kabhalilo ako, umukulu indiakamubhiikaghe umunungʼuna ghwake mu tukono utwa bhalughu ukuti aghoghighwe. Soona, ughwise indiakamubhiikaghe umwana mu tukono utwa bhalughu ukuti aghoghighwe. Bhoope abhaana indibhakabhaleeyaghe abhapaapi bhaabho nu kubhaghogha. ");
INSERT INTO ndh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Abhandu bhooshi indibhakabhabhenge umwe ku nongwa iya ngamu yangu. Loole umundu yuuyo indiakabhe mukifu ukufika pabhumalilo ghwe yuuyo uChaala indiakamupoke. ");
INSERT INTO ndh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Linga bhaaya bhaabhabhombela akabhiibhi mu kaaya kamu bhwo mukulumbilila, po mukakindilaghe mu kaaya akanine. Nalooli ingubhabhuula, mutaamukamale ukughenda mu twaya twoshi utwa Isilaeli bhwo uMwana ughwa Mundu atiisile. ");
INSERT INTO ndh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Umumanyili ataa ghwi songo ukukinda umumanyishi ghwake. Soona, umutumwa ghwepe ataa ghwi songo ukukinda usongo ghwake. ");
INSERT INTO ndh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Umumanyili akulondighwa abhange isa umumanyishi ghwake nu mutumwa ghwepe isa usongo ghwake. Linga bhakuunyiitisha une ni songo ughwa nyumba ukuti nee Bhelisebhuli, kali, bhataabhakabhiitishe abhandu abha mu nyumba yaake ingamu imbiibhi ukukindaapo?” ");
INSERT INTO ndh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Po manye mubhooghopaghe abhandu abho. Paapo akandu kooshi kaako katali pabhwelu, indikakasetulighwe, soona kooshi kaako kafifiighwe, indikakabhiikighwe pabhwelu. ");
INSERT INTO ndh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Shooshi shiisho ingubhabhuula mu chiisi, indimukashiyughaghe pabhwelu. Soona shooshi shiisho mukushipulika ku bhushiifu isha chitangalala icha kumwanya, shilumbililaghe pabhwelu. ");
INSERT INTO ndh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Manye mubhooghopaghe bhaabho bhakughogha umubhili, loole bhatabhaghiile ukughogha indumbula. Mwoghopaghe uChaala mwene yuuyo abhaghiile ukupyuta umubhili pamupeene ni ndumbula mu mulilo ughwa bhwila na bhwila ughwa mu Yehanamu. ");
INSERT INTO ndh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kali, utubhelebheeswa tubhili tutakughulishighwa ku salabhasha yimoyeeneeshe? Poope kataliipo akabhelebheeswa naakamu mu tubhelebheeswa utwo kaako kakughwa paase chishita bhwighane ubhwa Ghuuso. ");
INSERT INTO ndh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Loole kulubhafu lwinyu, uChaala abhelengite ni chingʼwili icha mitu yiinyu. ");
INSERT INTO ndh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Po manye mwoghopaghe paapo umwe muli nu lughindiko ukukinda utubhelebheeswa utwo. ");
INSERT INTO ndh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Umundu ghweshi yuuyo akuunyiitika pandaashi pa bhandu, nuune indiingamwitike pandaashi pa Taata yuuyo ali kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Loole ghweshi yuuyo akuungaana pandaashi pa bhandu, nuune indiingamukaane pandaashi pa Taata yuuyo ali kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Manye mwinongʼonaghe ukuti niisile pa chiisu ichi ku nongwa iya kubhiika ulutengaano. Nashiku! Bhwo shitali. Loole niisile ku nongwa iya kupela ubhulwane. ");
INSERT INTO ndh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Paapo niisile ukuti umwana nu ghwise, umulindu nu ngʼina, umulaasagha nu ngʼinafyala manye bhapulikanaghe. ");
INSERT INTO ndh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Soona, abhalughu abha mundu indibhakabhe bhandu abha mu nyumba yaake. ");
INSERT INTO ndh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Umundu ghweshi yuuyo amughanite ughwise pamu ungʼina ukukinda ukuungana une, uyo ataambaghiile. Soona, ghweshi yuuyo amughanite umwana ghwake umuliisha pamu umukolo ukukinda ukuungana une, uyo ghwepe ataambaghiile. ");
INSERT INTO ndh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Umundu ghweshi yuuyo atakupimba ichikobhekano chaake nu kuungonga, ataambaghiile. ");
INSERT INTO ndh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Umundu ghweshi yuuyo ukulonda ukubhupoka ubhwumi bhwake, indiakabhusofye. Loole umundu yuuyo akubhusofya ubhwumi bhwake ku nongwa yangu, indiakabhwaghe ubhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Umundu ghweshi yuuyo akubhapokeela umwe, po akuumbokeela neene. Soona, ghweshi yuuyo akuumbokeela une, po akumupokeela na yula yuuyo aandumite une. ");
INSERT INTO ndh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ghweshi yuuyo akumupokeela umusololi ku nongwa iya kuti musololi, uChaala indiakamuhombe umufwalo isa ughwa musololi. Soona, ghweshi yuuyo akumupokeela umundu yuuyo mubhaghile pandaashi pa Chaala ku nongwa iya kuti mubhaghile, uChaala indiakamuhombe ghwepe uyo umufwalo isa ughwa mubhaghile. ");
INSERT INTO ndh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nalooli ingubhabhuula, umundu ghweshi yuuyo akumupa ichikombe icha miishi amapole yumo mu bhafuyuke abha ku nongwa iya kuti mumanyili ghwangu, uChaala indiakamuhombe umufwalo ghwake.” ");
INSERT INTO ndh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bhwo uYeesu aamala ukubhabhuula abhamanyili bhaake kalongo na bhabhili (12), akatiilaapo pala. Akabhuuka mu twaya utwa Ghalilaayi pakulumbilila nu kubhamanyisha abhandu ishu ilya Chaala. ");
INSERT INTO ndh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Bhwo uYoohani apinyiighwe mu nyumba iya bhapinyighwa, akapulika shiisho uKilisiti akashibhombagha. Po akabhatuma abhamanyili bhaake ");
INSERT INTO ndh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ukuti bhamubhuushe uYeesu ukuti, “Kali, ughwe ghwe yula yuuyo bhakasolola ukuti indiakiise pamu tumulindililaghe umunine?” ");
INSERT INTO ndh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","UYeesu akabhaamula akati, “Bhuuka mumubhuule uYoohani shooshi shiisho mwapulika na shiisho mwashibhona. ");
INSERT INTO ndh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Paapo bhaabho bhaali bhafwamaaso bhakutesha, bhaabho bhaali bhochikwefu bhakughenda, bhaabho bhaali ni mbungo iya makete bhapolite, bhaabho bhaali ni fipuli, bhakupulika, abhafwe bhakushuuka. Soona, abhapiina bhakupokeela iNongwa iNyiisa. ");
INSERT INTO ndh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","UChaala akumusaya umundu ghweshi yuuyo atakwilaamwa kukwangu.” ");
INSERT INTO ndh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bhwo abhamanyili abha Yoohani bhaatiila, uYeesu akaanda ukufilingaania ifilundilo ifya bhandu fila isha Yoohani uMwoshi akati, “Kali, mukabhuukagha pakutesha kooni ku lungalangala? Kali, mukabhuukagha pakumutesha umundu yuuyo akwitika shooshi isa ulutete luulwo ichikungu chikaluyungaanianga kwoshi kwoshi? Nashiku! ");
INSERT INTO ndh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Po kali, mukabhuukagha pakutesha kooni? Kali, mukabhuukagha pakumutesha umundu yuuyo afwalite imyenda iya mutengo umukulu? Pulikisha, abhandu bhaabho bhakufwala imyenda iya mutengo bhakwikala mu nyumba ingulu isha bhomalafyale. ");
INSERT INTO ndh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Po kali, mukabhuukagha pakutesha kooni? Kali, mukabhuukagha pakumutesha umusololi? Mwo muumwo, loole ingubhabhuula ukuti uYoohani akindite pa musololi. ");
INSERT INTO ndh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uyu ghwe yuuyo inongwa shaake shisimbiighwe mu Masimbo aMeelu ukuti, ‘Tesha, ingumutuma ughwandumi ghwangu mundaashi yaako yuuyo indiakatendekeshe isila yaako.’ ");
INSERT INTO ndh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nalooli ingubhabhuula, mu bhandu bhooshi bhaabho bhapaapiighwe na bhakolo, atabhonekite naayumo ukubha ghwa pamwanya ukumukinda uYoohani uMwoshi. Loole umundu yuuyo mufuyuke ku chitangalala icha kumwanya, ghwe yuuyo ghwa pamwanya ukumukinda umwene. ");
INSERT INTO ndh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ukwandila amashiku ghaagho uYoohani uMwoshi akalumbililagha ukufika umuusughu, ichitangalala icha kumwanya chili pa bhwite. Abhandu abha maka, bhakughela ukuchilwila ku maka ukuti bhachaaghe. ");
INSERT INTO ndh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Paapo bhwo uYoohani akaali ukwisa, abhasololi na shiisho shikasimbighwa mu ndaghilo isha Moose shikasololagha shiisho indishikabhoneke akabhalilo aka. ");
INSERT INTO ndh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Po linga mukwitika ubhusololi bhwabho, uYoohani ghwe yuuyo ghwi Eliiya yula yuuyo akayughighwanga ukuti indiakiise. ");
INSERT INTO ndh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Umundu ghweshi yuuyo ali ni fyufwo, apulikaghe. ");
INSERT INTO ndh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kali, abhandu abha mbaapo iyi imbagheleshe na kooni? Bhagheliile na bhaana bhaabho bhakwikala pa munaalo nu kubhiitisha abhanine bhakuti, ");
INSERT INTO ndh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Twabhakomiile ilongi, loole mutaalebhiile! Twabhiimbiile inyimbo isha bhuswimaane, loole mutaalilite!’ ");
INSERT INTO ndh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Bhubhuubhwo bhwo uYoohani iisa kukwinyu, atakulya pamu atakungʼwa, abhandu bhakatingi, ‘Umundu uyu akoliighwe ni mbepo imbiibhi.’ ");
INSERT INTO ndh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bhwo uMwana ughwa Mundu iisa kukwinyu, akulya nu kungʼwa, abheene bhakati, ‘Tesha! Umundu uyu mupafu soona ghwi chingʼwelo, mumanyani ghwa bhasongesha songo na bhatulanongwa!’ Loole amahala agha Chaala ghakubhoneka ukubha gha nalooli ku mbombo isha bhandu bhaake.” ");
INSERT INTO ndh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Po uYeesu akaanda ukubhakemela abhandu abha mu twaya tuutwo akabhombaamwo ifyika ifyingi ku nongwa iya kuti abhandu abho bhatakapinduka ukufuma ku mbiibhi shaabho akati, ");
INSERT INTO ndh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Lwinyu mwe bhandu abha kaaya aka Kolasiini! Lwinyu mwe bhandu abha kaaya aka Bheetisayita! Paapo ifyika fiifyo ingafibhombagha kukwinyu, linga ingafibhombagha mu kaaya aka Tiilo na mu ka Sindoni, abhandu abha twaya utwo ngali bhakafwala amaghunila nu kupakala ilyoto ukulangisha ukupinduka ukufuma ku mbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Loole ingubhabhuula ukuti pi ishiku ilya bhulongi umwe indimukapokeele ulufundo ulukulu ukukinda akaaya aka Tiilo na ka Sindoni. ");
INSERT INTO ndh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nuumwe mwe bhandu abha kaaya aka Kapenabhumu, kali, mukwinongʼona ukuti uChaala indiakabhakweshe ukufika kumwanya? Nashiku! UChaala indiakabhiilomushe ukufika ku bhushuuka. Paapo linga ifyika fiifyo fikabhombighwanga kukwinyu, fikabhombighwanga na mu kaaya aka Sondoma, po akaaya ako ngali kaliikwo ukufika umuusughu. ");
INSERT INTO ndh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Loole ingubhabhuula ukuti pi ishiku ilya bhulongi umwe indimukapokeele ulufundo ulukulu ukukinda akaaya aka Sondoma.” ");
INSERT INTO ndh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ku kabhalilo kala uYeesu akati, “Ghwe Taata, ghwe Malafyale ghwa kumwanya na pa chiisu panu, ingukupaalisha paapo imbombo ishi ukabhafifa abhandu abha mahala na bhamanyi, loole ukashibhiika pabhwelu ku bhandu bhaabho bhakwiyiisha ungati bhaana abhakeke. ");
INSERT INTO ndh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nalooli, ghwe Taata, umwo mwo muumwo ukiighanila. ");
INSERT INTO ndh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“UTaata aambiile fyoshi. Naayumo umundu yuuyo amumeenye uMwana, loole uTaata mwene. Soona naayumo umundu yuuyo amumeenye uTaata, loole uMwana mwene nu mundu ghweshi yuuyo uMwana akwighana ukumulangisha uTaata kukwake. ");
INSERT INTO ndh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Isagha kukwangu mweshi mwe mukutaamighwa nu kupimba imishigho imingʼwamu, nuune indiingabhape ubhutuusho. ");
INSERT INTO ndh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ipinyagha iniila yangu, mumanyilaghe kukwangu ukufika paapo indiingabhaafwe ukubha nu lutengaano mu ndumbula shiinyu. Paapo une indi mwoloolo soona indi ghwa kwiyiisha. ");
INSERT INTO ndh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iniila yangu mbepe ukupimba nu mushigho ghwangu ghwope mupepe.” ");
INSERT INTO ndh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mu kabhalilo kala, uYeesu na bhamanyili bhaake bhakaghendagha mu sila yiiyo yikaghenda pakati pa mighunda, likabha lishiku ilya Sabhati. Bhwo bhakughenda, bhakiipulika isala. Po bhakaanda ukuposola ifisaasali nu kwanda ukulya iseke shaake. ");
INSERT INTO ndh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Loole bhwo aBhafalisaayi bhaashibhona isho, bhakamubhuusha uYeesu bhakati, “Kali, kooni abhamanyili bhaako bhakubhomba shiisho indaghilo isha Moose shitakwitikisha ukubhomba pi ishiku ilya Sabhati?” ");
INSERT INTO ndh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","UYeesu akabhabhuusha akati, “Kali, mutabhelengite mu Masimbo aMeelu muumwo uNdaabhiti na bhanine bhakabhombela bhwo isala yaabhabhabha? ");
INSERT INTO ndh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","UNdaabhiti akiingila mu Nyumba iya Chaala. Po akalya imikati yiiyo yikabhiikighwa pandaashi pa Chaala. Naayumo umundu yuuyo akiitikishighwanga ukulya imikati yila, loole abhapuuti bheene. Loole uNdaabhiti akeegha nu kulya imikati yila, ghwepe akabhapa abhanine, bhakalya pamupeene. ");
INSERT INTO ndh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pamu kali, mutabhelengite mu ndaghilo isha Moose ukuti pamupeene nu kuti abhapuuti abha mu Nyumba iya Chaala bhakukomanianga indaghilo pi ishiku ilya Sabhati, poope uChaala atakubhabhelengela ukuti bhakubhomba akabhiibhi? ");
INSERT INTO ndh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Loole ingubhabhuula umwe ukuti panu aliipo yuuyo ghwi songo ukukinda iNyumba iya Chaala. ");
INSERT INTO ndh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Linga mwaghameenye amalingaanio agha Mashu aMeelu ghaagho ghakuti, ‘Ingulonda ukuti mupelelanaghe ichisa ukukinda ukuufumikisha ifyabhupe,’ ngali mutakubhalonga abhandu bhaabho bhatali ni nongwa naayimo. ");
INSERT INTO ndh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Paapo uMwana ughwa Mundu ali na maka na pi ishiku ilya Sabhati.” ");
INSERT INTO ndh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","UYeesu akatiila pala, akabhuuka nu kwingila mu sinaghoghi yimo. ");
INSERT INTO ndh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mu sinaghoghi mula, akabhaamwo umundu yumo yuuyo akabha na kakono akalale. Bhakabhaamwo soona na Bhafalisaayi bhaabho bhakalondagha ukumughela uYeesu ukuti bhamusitaake. Po bhakamubhuusha bhakati, “Kali, indaghilo isha Moose shikwitikisha ukumuposha umundu pi ishiku ilya Sabhati?” ");
INSERT INTO ndh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","UYeesu akabhaamula, akabhabhuusha akati, “Kali, mundu yuki pakati papiinyu yuuyo linga unangʼooshi ghwake aaghwila mu bhwina pi ishiku ilya Sabhati, atakubhuuka nakalinga nu kumughuusa pi ishiku ilyo? ");
INSERT INTO ndh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kali, umundu atali nu lughindiko ngaani ukukinda unangʼooshi? Ku nongwa iyo, indaghilo isha Moose shikwitikisha ukubhomba inyiisa pi ishiku ilya Sabhati.” ");
INSERT INTO ndh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Po uYeesu akamubhuula umundu yula yuuyo akabha na kakono kaako kalalite akati, “Gholosha akakono kaako.” Ghwepe akagholosha, nakalinga kakapola nu kubha isa akanine. ");
INSERT INTO ndh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Loole aBhafalisaayi bhala bhakafuma kuuse nu kuyughisania muumwo bhabhaghiile ukumughoghela uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bhwo uYeesu aashaaghania ukuti aBhafalisaayi bhakuyughisania isha kumughogha, akatiilaapo pala. Po abhandu abhingi bhakamukonga, ghwepe akabhaposha bhooshi bhaabho bhakabha bhabhine. ");
INSERT INTO ndh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Loole akabhakaanisha ku maka ngaani ukuti manye bhamufumushange ku bhandu. ");
INSERT INTO ndh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","UYeesu akayugha ulwo ukuti shibhombighwe shiisho umusololi uYesaaya akasimba mu Masimbo aMeelu ukuti, ");
INSERT INTO ndh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Tesha, uyu ghwe yuuyo mubhombi ghwangu yuuyo imusalite, mughanighwa ghwangu, yuuyo akuyihobhosha indumbula yangu. Indiingamubhiike uMbepo ghwangu pamwanya papaake, ukuti afumushange ubhwanalooli bhwangu ku fyisu fyoshi. ");
INSERT INTO ndh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ataaakakaanikanaghe na bhandu pamu ataaakayweghaghe nabho. Soona naayumo umundu yuuyo indiakapulikaghe ishu lyake mu sila. ");
INSERT INTO ndh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ataaakaluposole ulutete luulwo lughombaanite, ataaakabhushimye ubhutambi bhuubhwo bhukufuuka ilyoshi, pabhumalilo indiakabhubhiike ubhwanalooli ubhwa Chaala ukupoota. ");
INSERT INTO ndh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Soona, abhandu abha fyisu fyoshi, indibhakasubhaalilaghe ingamu yaake.” ");
INSERT INTO ndh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Po abhandu bhamu bhakiisa kwa Yeesu nu mundu yumo yuuyo akabha akoliighwe ni mbepo imbiibhi. Imbepo yila yikamupelela ubhufwamaaso nu bhwochinuunu. UYeesu akamuposha umundu yula, ghwepe akaanda ukuyugha nu kutesha soona. ");
INSERT INTO ndh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Abhandu bhooshi bhakaswigha nu kubhuusania bheene-bheene bhakati, “Kali, uyu abhaghiile ukubha Mwana ghwa malafyale uNdaabhiti?” ");
INSERT INTO ndh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Loole bhwo aBhafalisaayi bhaapulika isho, bhakati, “Umundu uyu akushikiisha imbepo imbiibhi ku maka agha Bhelisebhuli, usongo ughwa mbepo imbiibhi.” ");
INSERT INTO ndh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Bhwo uYeesu aashimanya shiisho bhakiinongʼonagha, akabhabhuula akati, “Linga abhandu abha bhunyafyale bhumobhwene bhaayabhanika, po ubhunyafyale ubhwo bhutabhaghiile ukwendelela. Soona linga abhandu abha kaaya kamukeene pamu inyumba yimoyeene bhaayabhanika, po bhakunyambaana. ");
INSERT INTO ndh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ghwepe uSeetano linga akumukiisha uSeetano, ubhunyafyale bhwake bhukubha bhwayabhanika. Kali, po ubhunyafyale bhwake bhubhaghiile bhwendelele bhuleele? ");
INSERT INTO ndh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Linga mukuti une ingushikiisha imbepo imbiibhi ku maka agha Bhelisebhuli, po kali, abhakongi bhiinyu bhakushikiisha ku maka agha ghwini? Ku nongwa iyo, abho bho bhaabho indibhakabhalongaghe umwe. ");
INSERT INTO ndh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Loole linga ingushikiisha imbepo imbiibhi ku maka agha Mbepo ughwa Chaala, po ichitangalala icha Chaala chibhiisiile umwe. ");
INSERT INTO ndh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ataliipo umundu yuuyo abhaghiile ukwingila mu nyumba iya mundu ughwa maka nu kwegha utundu twake chishita kumupinya taashi. Loole linga aamupinya taashi umundu ughwa maka yula, po abhaghiile ukwegha utundu twake. ");
INSERT INTO ndh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Umundu ghweshi yuuyo atali pamupeene nuune, akuungaanika une. Soona, ghweshi yuuyo atakubhungaania abhandu pamupeene nuune nu kubhabhiika kwa Chaala, akunyambaania. ");
INSERT INTO ndh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ku nongwa iyo ingubhabhuula ukuti uChaala indiakabhahobhokele abhandu imbiibhi shaabho shooshi nu kumufuyula kwabho, loole ataaakabhahobhokele abhandu linga bhakumufuyula uMbepo uMwelu. ");
INSERT INTO ndh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Soona, uChaala indiakabhahobhokele abhandu bhaabho bhakumufuyula uMwana ughwa Mundu, loole ataaakabhahobhokele abhandu bhala bhaabho bhakumufuyula uMbepo uMwelu mu kabhalilo aka pamu kaako kakwisa.” ");
INSERT INTO ndh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Linga ghwalibhombelela ikokwe akiisa, iseke shaake shikubha nyiisa, soona linga ghwalibhombelela ikokwe akabhiibhi, iseke shaake shikubha mbiibhi. Ubhaghiile ukulimanya ikokwe muumwo libheeliile ku seke shiisho likwela. ");
INSERT INTO ndh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwe chikolo icha njoka umwe! Kali, mubhaghiile bhuleele ukuyugha amashu amiisa bhwo muli bhabhiibhi? Paapo umundu akushiyugha shiisho shiiswile mu ndumbula yaake. ");
INSERT INTO ndh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Umundu umwisa akuyugha shiisho nyiisa ukufuma mu ndumbula yaake inyiisa, loole umundu umubhiibhi akuyugha shiisho mbiibhi ukufuma mu ndumbula yaake imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Loole ingubhabhuula umwe ukuti pi ishiku ilya bhulongi, abhandu indibhakalingaanie amashu ghaagho bhakayughagha mwalwe mwalwe. ");
INSERT INTO ndh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Paapo uChaala indiakakubhelengele ukubha mugholofu ku mashu ghaako amiisa pamu indiakakulonge ukubha ni nongwa ku mashu ghaako amabhiibhi.” ");
INSERT INTO ndh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Po aBhafalisaayi bhamu na bhamanyishi abha ndaghilo isha Moose bhakamubhuula uYeesu bhakati, “Ghwe Mumanyishi, tukulonda ubhombe ichiika ukulangisha ukuti ufumite kwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","UYeesu akabhaamula akati, “Abhandu abhabhiibhi na bhashipani abha kabhalilo aka bhakulonda ichiika! Indaaimbabhombele ichiika naachimo, loole ichiika cheene chiicho uChaala akachibhomba ku musololi uYoona. ");
INSERT INTO ndh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Paapo isa muumwo uYoona akiikala amashiku matatu mu lufukwe ulwa iswi ingulu pabhushiku na pamuusi, bhubhuubhwo uMwana ughwa Mundu indiakiikale amashiku matatu mu ipumba pabhushiku na pamuusi. ");
INSERT INTO ndh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pi ishiku ilya bhulongi abhandu abha mu kaaya aka Ninaabhi indibhakiime pamupeene na bhandu abha mbaapo iyi nu kubhalonga ukubha bhatulanongwa. Paapo abheene bhakapinduka nu kwilaata imbiibhi shaabho bhwo bhaapulika uYoona akulumbilila ishu ilya Chaala. Loole ingubhabhuula umwe ukuti aliipo yumo panu yuuyo mughindikighwa ukukinda uYoona. ");
INSERT INTO ndh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pi ishiku ilya bhulongi umalafyale umukolo ughwa chiisu icha Sheebha indiakiime nu kubhalonga abhandu abha mbaapo iyi ukuti bhatulanongwa. Paapo umwene akafuma ku chiisu icha kubhutali ukuti iise apulikishe ifimanyisho ifya mahala ifya malafyale uSolomooni. Loole ingubhabhuula umwe ukuti aliipo yumo panu yuuyo mughindikighwa ukukinda uSolomooni.” ");
INSERT INTO ndh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","UYeesu akeendelela ukuyugha akati, “Linga imbepo imbiibhi yaafuma mu mundu, yikushunguulila-shunguulila paapo patali na miishi bhwo yikulonda ubhuyo ubhwa kutuusha, loole yitakubhwagha. ");
INSERT INTO ndh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Po imbepo imbiibhi yila yikuti, ‘Indiingaluke mu nyumba yangu muumwo ingafuma.’ Linga yaafika mula, yikwagha inyumba yila yili bhwashi, mbyaghile soona yitendekeshiighwe akiisa. ");
INSERT INTO ndh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Po yikubhuuka pakusheegha imbepo imbiibhi inine ihaano na shibhili (7) shiisho mbiibhi ukukinda iyeene. Imbepo shooshi isho shikwingila mu mundu uyo, shikushaala mula mula. Po ubhughone ubhwa mundu uyo ubhwa bhumalilo bhukubha bhubhiibhi ukukinda ubhwa bhwandilo. Umwo mwo muumwo indishikabheele na ku bhandu abha mbaapo imbiibhi iyi.” ");
INSERT INTO ndh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bhwo uYeesu akaali ali pakuyugha ni chilundilo icha bhandu, mu kabhalilo kala kala ungʼina na bhoghwamwabho bhakiisa nu kwima kuuse, bhakalondagha ukuyugha naghwe. ");
INSERT INTO ndh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Po umundu yumo akamubhuula akati, “Ghwe Yeesu, unyoko na bhoghwamwinyu bhiimite kuuse, bhakulonda ukuyugha nuughwe.” ");
INSERT INTO ndh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Loole uYeesu akamwamula nu kumubhuusha akati, “Kali, umaayi ghwe ghwini? Kali, abhoghwamwitu bho bhooni?” ");
INSERT INTO ndh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Po akasonda akakono ku bhamanyili bhaake akati, “Tesha, umaayi na bhoghwamwitu! ");
INSERT INTO ndh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Paapo umundu ghweshi yuuyo akulipulika ishu ilya Chaala, uTaata ghwangu yuuyo ali kumwanya nu kulibhombela imbombo, uyo ghwe yuuyo ghwi ghwamwitu, mulumbu ghwangu soona ghwi maayi ughwa nalooli.” ");
INSERT INTO ndh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pi ishiku lila lila, uYeesu akatiila mu nyumba yila, akaya iikala ku chiseese kwa sumbi. ");
INSERT INTO ndh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ifilundilo ifyingi ifya bhandu fikiisa nu kubhungaana paapo uYeesu akabha, po umwene akakwela mu bhwato nu kwikala mula mula. Abhandu bhala bhakashaala bhiimite ku chiseese kwa sumbi. ");
INSERT INTO ndh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Po uYeesu akabhabhuula amashu amingi ku sila iya kubhombela ififwanikisho akati, “Umulimi yumo akabhuuka pakupesa imbeyu shaake. ");
INSERT INTO ndh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bhwo ali pakupesa, imbeyu shimo shikaghwa mu sila, utuyuni tukiisa nu kushilya. ");
INSERT INTO ndh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Imbeyu inine shikaghwa pi ilongwi liilyo likabha ni lyalabhwe paase. Imbeyu isho shikamela lubhilo. Loole ku nongwa iya kuti ilongwi likabha linandi pamwanya, ");
INSERT INTO ndh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","bhwo akamu kaabhala, imbeyu isho shikafwoka nu kwuma ku nongwa iya kuti imishu yaake yikabha pamwanyaashe. ");
INSERT INTO ndh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbeyu inine shikaghwa pakati pa myifwa. Bhwo imbeyu shila shaanda ukukula, imyifwa yoope yikakula lubhilo nu kushishighila imbeyu. ");
INSERT INTO ndh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Imbeyu inine shikaghwa pi ilongwi ilyisa. Po bhwo shaaghoma, shimo shikeela iseke imya yimo (100), inine shikeela amalongo mahaano na limo (60) ni nine shikeela amalongo matatu (30). ");
INSERT INTO ndh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Umundu ghweshi yuuyo ali ni fyufwo, apulikishange nu kushaaghania!” ");
INSERT INTO ndh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abhamanyili abha Yeesu bhakiisa nu kumubhuusha bhakati, “Kali, kooni kubhombela ififwanikisho linga kuyugha na bhandu?” ");
INSERT INTO ndh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Akabhaamula akati, “UChaala abhasetuliile umwe ukushimanya isha ku bhushiifu isha chitangalala chaake, loole abheene atabhabhaghishiishe ukushimanya shooshi isho. ");
INSERT INTO ndh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Paapo umundu yuuyo akufipulika ifimanyisho fyangu nu kufyaghania, uChaala akumwafwa nu kumwongela ukushaaghania ngaani. Loole yuuyo atakufipulika nu kufyaghania, uChaala akumupoka na kanandi kaako akukaaghania. ");
INSERT INTO ndh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yo yiiyo nongwa iyi ingubhombela ififwanikisho linga inguyugha nabho, paapo bhakushitesha shiisho ingubhomba, loole bhatakushibhona, bhakushipulika shiisho inguyugha, loole bhatakushaaghania. ");
INSERT INTO ndh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ishi shikubhombighwa kukwabho ukuti shibhoneke shiisho umusololi uYesaaya akasimba ukuti, ‘Ukupulika indimukapulikaghe, loole mutaamukashaaghaniange. Ukutesha indimukateshange, loole mutaamukashibhonaghe. ");
INSERT INTO ndh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ku nongwa iya kuti indumbula isha bhandu abha ngafu, bhashindiile ifyufwo fyabho, bhashishiilite amaaso ghaabho, ukuti amaaso ghaabho manye ghateshange, ifyufwo fyabho manye fipulikaghe ni ndumbula shaabho manye shishaaghaniange, manye bhakapinduke ukuti imbapoke.’ ");
INSERT INTO ndh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Loole uChaala abhasayite umwe, paapo amaaso ghiinyu ghakutesha ni fyufwo fyinyu fikupulika. ");
INSERT INTO ndh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nalooli ingubhabhuula ukuti bhakabhaapo abhasololi na bhagholofu abhingi bhaabho bhakanyonywanga ukushibhona shiisho mukushibhona umwe, loole bhatakashibhonagha. Bhakanyonywanga ukupulika shiisho mukushipulika umwe, loole bhatakashipulikagha.” ");
INSERT INTO ndh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Po umwe pulikisha ilingaanio ilya chifwanikisho icha mupesa mbeyu icho. ");
INSERT INTO ndh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Umundu ghweshi yuuyo akulipulika ishu ilya Chaala loole atakulyaghania, uMubhiibhi yula akwisa nu kulinyaghula ishu liilyo uChaala alibhyalite mu ndumbula yaake. Umundu uyo agheliile ni mbeyu yiiyo yikaghwa mu sila. ");
INSERT INTO ndh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Imbeyu shiisho shikaghwa pi ilongwi liilyo likabha ni lyalabhwe paase, shigheliile nu mundu yuuyo akupulika ishu ilya Chaala, nakalinga akulipokeela ku lusekelo. ");
INSERT INTO ndh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Loole ku nongwa iya kuti ataa ni mishu mukati yaake, ishu ilyo likubhaamwo ku kabhalilo akapimbaashe. Linga indamyo pamu ukutaamighwa kwamwagha ku nongwa iya lishu ilya Chaala, nakalinga akulileka. ");
INSERT INTO ndh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Imbeyu shiisho shikaghwa pakati pa myifwa, shigheliile nu mundu yuuyo akupulika ishu ilya Chaala. Loole ku nongwa iya kwinongʼona ngaani isha mu chiisu ichi pamu ukushimbulighwa ni finyonywa ifya bhukabhi pamu ukubha nu tundu utwingi, fyoshi ifyo fikulishighila ishu ukuti manye lipaapaghe iseke. ");
INSERT INTO ndh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Loole imbeyu shila shiisho shikaghwa pi ilongwi ilyisa, shigheliile nu mundu yuuyo akulipulika ishu ilya Chaala nu kulyaghania. Umundu uyo ghwe yuuyo akupaapa iseke shimo imya yimo (100), inine amalongo mahaano na limo (60) ni nine amalongo matatu (30).” ");
INSERT INTO ndh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","UYeesu akabhabhuula ichifwanikisho ichinine akati, “Ichitangalala icha kumwanya chigheliile nu mundu yuuyo akapesa imbeyu inyiisa mu mughunda ghwake. ");
INSERT INTO ndh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Loole bhwo abhandu bhooshi bhaapitila, umulughu ghwake akiisa aabhyala ichiposo mu ngano, po akabhuuka. ");
INSERT INTO ndh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bhwo ingano iyo yaamela nu kwanda ukwela iseke, ichiposo chila choope chikamela. ");
INSERT INTO ndh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Abhabhombi abha mwene mughunda bhakiisa pakumubhuusha bhakati, ‘Ghwe malafyale, tumeenye ukuti ukapesa imbeyu inyiisa mu mughunda ghwako, kali, po ichiposo chila chifumite kuughu?’ ");
INSERT INTO ndh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Akabhaamula akati, ‘Umulughu ghwe yuuyo abhombite ishi.’ Abhabhombi bhaake bhakamubhuusha bhakati, ‘Kali, kulonda tuye twipe?’ ");
INSERT INTO ndh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ghwepe akati, ‘Nashiku, manye mwipaghe paapo linga mukwipa ichiposo, mubhaghiile mwipe pamupeene ni ngano. ");
INSERT INTO ndh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Fileke fyoshi fikulaghe pamupeene ukufika mu kabhalilo aka kwinula. Mu kabhalilo ako, indiingabhabhuule abhiinuli ukuti bhabhungaanie taashi ichiposo nu kuchipinya mu ngosa ukuti bhachipembe. Loole ingano bhayibhungaanie nu kuyisengula mu ighulu lyangu.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","UYeesu akabhabhuula ichifwanikisho ichinine akati, “Ichitangalala icha kumwanya chigheliile ni mbeyu inandi iya nambamba yiiyo umundu akeegha nu kupesa mu mughunda ghwake. ");
INSERT INTO ndh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imbeyu iyi nandi leka ukukinda imbeyu inine shooshi, loole linga yaamela nu kukula po yikubha ngulu ukukinda imbeyu shooshi isha libhogha shiisho shili mu chibheela. Imbeyu iyo yikubha ungati likokwe ikulu liilyo utuyuni tukwisa nu kutenga ififumbo mu tusamba twake.” ");
INSERT INTO ndh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","UYeesu akayugha ichifwanikisho ichinine akati, “Ichitangalala icha kumwanya chigheliile ni nyambo inandi yiiyo umukolo yumo akeegha nu kwongaania nu bhufu ubhwingi ubhwa kuyiilana utupombo tutatu. Pabhumalilo, inyambo inandi yila yikalulisha ubhufu bhwoshi bhula.” ");
INSERT INTO ndh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","UYeesu akachibhuulagha ichilundilo icha bhandu isho shooshi ukubhombela ififwanikisho. Atakayughagha naalimo kukwabho chishita kubhombela ichifwanikisho. ");
INSERT INTO ndh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Isho shikabhombighwa ukuti ishu lila libhombighwe liilyo umusololi akayugha ukuti, “Indiingayughaghe ku bhandu ku sila iya kubhombela ififwanikisho. Indiingabhabhuulaghe shiisho shiififite ukufuma muumwo uChaala akapelela ichiisu.” ");
INSERT INTO ndh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Po uYeesu akachilagha ichilundilo icha bhandu chila, akiingila mu nyumba. Abhamanyili bhaake bhakiisa, bhakamubhuula bhakati, “Tulingaanie ilingaanio ilya chifwanikisho icha chiposo chila chiicho chikabha mu mughunda.” ");
INSERT INTO ndh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","UYeesu akabhaamula akati, “Umundu yula yuuyo akapesa imbeyu inyiisa agheliile nu Mwana ughwa Mundu. ");
INSERT INTO ndh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Umughunda ghula ghugheliile ni chiisu, imbeyu inyiisa shila shigheliile na bhandu abha chitangalala icha Chaala ni chiposo chila chigheliile na bhandu abha Mubhiibhi yula. ");
INSERT INTO ndh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Umulughu yuuyo akiisa pakupesa ichiposo agheliile nu Mubhiibhi yula. Ukwinula kugheliile ni ishiku ilya bhumalilo ilya bhulongi ubhwa chiisu. Abhiinuli bhagheliile na bhandumi abha Chaala. ");
INSERT INTO ndh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Isa muumwo abhabhombi abha mu mughunda indibhakiipe nu kupemba ichiposo mu mulilo, mwo muumwo indishikabheele pi ishiku ilya bhumalilo ilya bhulongi ubhwa chiisu. ");
INSERT INTO ndh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","UMwana ughwa Mundu indiakabhatume abhandumi bhaake ukuti bhabhabhungaanie ukufuma ku chitangalala chaake abhandu bhooshi bhaabho bhakubhasofya abhanine ukuti bhabhombe imbiibhi na bhatulanongwa bhooshi. ");
INSERT INTO ndh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Abhandumi abho indibhakabhataaghe abhandu bhooshi abho mu mulilo ughwa bhwila na bhwila ughwa Yehanamu muumwo indibhakalilaghe nu kushesheetusha amiino ku nongwa iya bhubhafu ubhukali. ");
INSERT INTO ndh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Po abhandu bhooshi bhaabho bhabhaghile pandaashi pa Chaala, indibhakaakaghe ungati lisubha ku chitangalala chaake. Umundu ghweshi yuuyo ali ni fyufwo, apulikishange nu kushaaghania!” ");
INSERT INTO ndh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ichitangalala icha kumwanya chigheliile na kandu aka mutengo umukulu kaako kakafifighwa mu mughunda. Bhwo umundu yumo aakaagha, akakafifa soona. Po ku lusekelo, akabhuuka nu kughulisha ifindu fyoshi fiifyo akabha nafyo, akaghula umughunda ghula. ");
INSERT INTO ndh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Soona, ichitangalala icha kumwanya chigheliile nu muchulushi yumo yuuyo akabhuuka pakulonda iyondo ilya mutengo umukulu ngaani. ");
INSERT INTO ndh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bhwo aalyagha iyondo limo ilya mutengo umukulu ngaani, akabhuuka nu kughulisha ifindu fyoshi fiifyo akabha nafyo, akiisa, akalighula.” ");
INSERT INTO ndh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Soona, ichitangalala icha kumwanya chigheliile ni chilepa chiicho abhalobha iswi bhakachiponia mwa sumbi. Bhwo bhaachiponia, ichilepa chila chikakola iswi isha luko nu luko. ");
INSERT INTO ndh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bhwo ichilepa chila chiisula, abhalobha iswi bhakachighuusila ku chiseese kwa sumbi. Po bhakiikala paase nu kubhungaania iswi inyiisa mu fipombo, loole bhakashitaagha iswi imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Umwo mwo muumwo indishikabheele pi ishiku ilya bhulongi ubhwa chiisu. Abhandumi abha Chaala indibhakiise nu kubhapaaghulania abhandu abhatulanongwa mu bhaabho bhabhaghile pandaashi pa Chaala. ");
INSERT INTO ndh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Abhandumi abho indibhakabhataaghe abhatulanongwa mu mulilo ughwa bhwila na bhwila ughwa Yehanamu muumwo indibhakalilaghe nu kushesheetusha amiino ku nongwa iya bhubhafu ubhukali.” ");
INSERT INTO ndh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","UYeesu akabhabhuusha abhamanyili bhaake akati, “Kali, mwashaaghania shooshi isho naabhabhuula?” Bhoope bhakamwamula bhakati, “Twashaaghania.” ");
INSERT INTO ndh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ghwepe akabhaamula akati, “Po umumanyishi ghweshi ughwa ndaghilo isha Moose yuuyo akubha mumanyili mu chitangalala icha kumwanya, agheliile nu mwene nyumba yuuyo akufumya mu chuuma chaake ifindu ifipya ni fikuulu.” ");
INSERT INTO ndh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bhwo uYeesu aamala ukuyugha ififwanikisho ifyo, akatiilaapo pala. ");
INSERT INTO ndh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bhwo aafika ku kaaya kuukwo akakulilagha, akaanda ukubhamanyisha abhandu mu sinaghoghi yaabho. Abhandu bhala bhakaswigha nu kubhuusania bhakati, “Kali, umundu uyu aghaaghite kuughu amahala agha na maka agha kubhomba ifyika ifi? ");
INSERT INTO ndh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kali, uyu ataa mwana ghwa mupulula matapwa? Kali, ungʼina ataa ghwi Maliiya? Kali, ataa ghwi ghwamwabho ughwa Yaakobhu, uYoosefu, uSiimoni nu Yuuta? ");
INSERT INTO ndh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kali, abhalumbu bhaake bhataa bho bhala tukwikala pamupeene nabho? Po kali, ashaaghite kuughu shooshi ishi?” ");
INSERT INTO ndh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Po abhandu bhakiikinya nu kushita kumwitika. Loole uYeesu akabhabhuula akati, “Abhandu bhakumughindika umusololi kwoshi kula, loole abha mu chiisu chaake na bha mu nyumba yaake bhatakumughindika.” ");
INSERT INTO ndh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ku nongwa iya kuti abhandu bhala bhatakamwitika, uYeesu atakabhomba ifyika ifyingi kula. ");
INSERT INTO ndh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mu kabhalilo kala umalafyale uHelooti akapulika shiisho uYeesu akashibhombagha. ");
INSERT INTO ndh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Po akabhabhuula abhabhombi bhaake akati, “Uyo ghwi Yoohani uMwoshi yuuyo ashuukite. Yo yiiyo nongwa iyi ali na maka agha kubhomba ifyika.” ");
INSERT INTO ndh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","UHelooti akayugha ulwo paapo akabha amukolite uYoohani, akamupinya nu kumubhiika mu nyumba iya bhapinyighwa. Akamupinya ku nongwa iya kumwegha uHelotiiya yuuyo akabha mukashi ughwa Filipu, umunungʼuna ghwake. ");
INSERT INTO ndh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Paapo uYoohani akamubhuulagha uHelooti akatingi, “Indaghilo isha Moose shitakwitikisha ukumwegha umukashi ughwa munungʼuna ghwako.” ");
INSERT INTO ndh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Po uHelooti akalondagha isila iya kumughogha uYoohani, loole akooghopagha abhandu ku nongwa iya kuti bhakamwitikagha uYoohani ukubha musololi. ");
INSERT INTO ndh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bhwo lyafika ishiku ilya kukumbuka ukupaapighwa ukwa malafyale uHelooti, umulindu ughwa Helotiiya akalebhela pandaashi pa bhaheesha. ");
INSERT INTO ndh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bhwo aalebhela, uHelooti akahobhoka leka nu kufinga ukumupa umulindu yula kooshi kaako abhaghiile ukumusuuma. ");
INSERT INTO ndh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ku nongwa iya kusongighwa nu ngʼina, umulindu yula akamubhuula uHelooti akati, “Ingusuuma ghuumbe umutu ughwa Yoohani uMwoshi mu isiniya.” ");
INSERT INTO ndh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Umalafyale akaswimaana leka, loole ku nongwa iya kuloolika ukwo pandaashi pa bhaheesha bhala, akalaghila ukuti bhamupe umulindu yula. ");
INSERT INTO ndh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Po uHelooti akamutuma umundu yumo yuuyo akabhuuka nu kumuputula uYoohani umutu mu nyumba iya bhapinyighwa. ");
INSERT INTO ndh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Umundu yula akiisa nu mutu ughwa Yoohani mu isiniya nu kumupa umulindu yula, ghwepe akamupa ungʼina. ");
INSERT INTO ndh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pabhumalilo, abhamanyili abha Yoohani bhakabhuuka pakughwegha umufimba nu kughushiila mu ipumba. Po bhakabhuuka pakumulingaania uYeesu shooshi shiisho shikabhoneka. ");
INSERT INTO ndh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bhwo uYeesu aapulika shooshi isho, akatiila pala nu bhwato nu kubhuuka pabhushiifu. Loole bhwo abhandu bhaapulika, bhakaghenda nu tulundi ukufuma mu twaya twabho, bhakamukonga uYeesu kuukwo akabha. ");
INSERT INTO ndh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Po bhwo iika mu bhwato, akachibhona ichilundilo ichikulu icha bhandu, akabhapelela ichisa nu kubhaposha abhabhine bhaabho. ");
INSERT INTO ndh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bhwo lyabha lya namasubha, abhamanyili bhaake bhakiisa nu kumubhuula uYeesu bhakati, “Panu tuli patali nu twaya utwa bhandu, ubhushiku bhwapalamila. Bhalaghe abhandu abha ukuti bhabhuuke pakughula ifindu mu twaya utunandi tuutwo tuli papiipi.” ");
INSERT INTO ndh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","UYeesu akabhaamula akati, “Bhatakulondighwa ukubhuuka. Umwe, bhape ifindu abhandu abha.” ");
INSERT INTO ndh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bhoope bhakamwamula bhakati, “Tuli ni mikati mihaano ni iswi shibhili.” ");
INSERT INTO ndh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","UYeesu akabhabhuula akati, “Isagha nafyo kukwangu.” ");
INSERT INTO ndh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Po akabhalaghila abhandu bhala ukuti bhiikale pa chiposo. Akeegha imikati mihaano yila ni iswi shibhili shila, akatesha kumwanya, akapaalisha kwa Chaala. Po akayibheghulania, akabhapa abhamanyili bhaake, bhoope bhakabhayabhila abhandu. ");
INSERT INTO ndh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Abhandu bhooshi bhakalya nu kwikuta. Po bhwo bhaalya, abhamanyili bhaake bhakabhungaania utubhululusha utwa mikati ni iswi shila nu kwisusha utupombo kalongo na tubhili (12). ");
INSERT INTO ndh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Abhandu bhaabho bhakalya imikati yila, bhakabha abhaliisha abhoelufu bhahaano chishita kubhelenga abhakolo na bhaana. ");
INSERT INTO ndh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nakalinga, uYeesu akabhalaghila abhamanyili bhaake ukuti bhiingile mu bhwato, bhatangile ukubhuuka ku isiila ilya sumbi bhwo akuchilagha ichilundilo icha bhandu. ");
INSERT INTO ndh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bhwo aachilagha ichilundilo icha bhandu chila, uYeesu akakwela mwene pa kaghamba, pabhushiifu ukuti iipuute kwa Chaala. Bhwo lyafika ilya namasubha, akabha akaali ali pa kaghamba mwene. ");
INSERT INTO ndh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mu kabhalilo ako ubhwato bhukabha bhwafika pakati pa sumbi, loole inguli shikabhukomagha paapo ichikungu chikabhukukilagha. ");
INSERT INTO ndh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Bhwo ubhushiku bhwapalamila ukucha, uYeesu akabhuuka ku bhamanyili bhaake bhwo akughenda pamwanya pa sumbi. ");
INSERT INTO ndh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Loole bhwo abhamanyili bhaake bhaamubhona uYeesu akughenda pamwanya pa sumbi, bhakooghopa ngaani, bhakakuuta inguuto bhakati, “Mushuuka!” ");
INSERT INTO ndh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nakalinga, uYeesu akabhabhuula akati, “Ikasha indumbula, neene. Manye mwoghopaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","UPeeteli akamwamula akati, “Ghwe Malafyale, linga ghweghwe nalooli, imbuule ukuti niise paapo uli bhwo ingughenda pamwanya pa miishi.” ");
INSERT INTO ndh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","UYeesu akamwamula akati, “Isagha.” Po uPeeteli akiika mu bhwato bhula, akaanda ukughenda pamwanya pa miishi ukubhuuka kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Loole bhwo aachibhona ichikungu ichikali, uPeeteli akooghopa leka, akaanda ukutwibha mu miishi. Po akaanda ukukoma ulwama akati, “Ghwe Malafyale, imboke!” ");
INSERT INTO ndh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nakalinga, uYeesu akagholosha akakono, akamukola, akamubhuula akati, “Ghwe ghwa lwitiko ulunandi, kali, kwilaamwa kooni?” ");
INSERT INTO ndh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bhwo uYeesu nu Peeteli bhiingila mu bhwato, ichikungu chila chikabhoteela. ");
INSERT INTO ndh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Po abhamanyili bhaabho bhakabha mu bhwato, bhakamwipuuta uYeesu bhakati, “Nalooli, ughwe ghwe Mwana ghwa Chaala!” ");
INSERT INTO ndh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bhwo uYeesu na bhamanyili bhaake bhaalobhoka usumbi ughwa Ghalilaayi, bhakafika mu chiisu icha Ghenesaleeti. ");
INSERT INTO ndh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bhwo abhandu abha mu chiisu chila bhaamanya ukuti ghwi Yeesu, bhakafumusha inongwa shaake mumbafu shooshi. Po abhandu bhakiisa na bhabhine bhooshi kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bhoope bhakamusuuma uYeesu ukuti abhiitikishe abhabhine bheeghelesheeshe ku chipeto icha mwenda ghwake. Po abhabhine bhooshi bhaabho bhakeeghelesha, bhakapola. ");
INSERT INTO ndh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Po aBhafalisaayi bhamu na bhamanyishi abha ndaghilo isha Moose bhakiisa ukufuma mu kaaya aka Yelusaleemu. Bhakabhuuka kwa Yeesu, bhakamubhuusha bhakati, ");
INSERT INTO ndh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kali, kooni abhamanyili bhaako bhatakukonga inyiiho shiisho abhosekulu bhiitu bhakatulekela? Abheene bhakulya ifindu chishita kusukusula utukono twabho ukukongana ni nyiiho isho!” ");
INSERT INTO ndh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","UYeesu akabhaamula, akabhabhuusha akati, “Kali, kooni nuumwe mutakukongagha indaghilo isha Chaala ku nongwa iya kukonga inyiiho shiinyu? ");
INSERT INTO ndh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Paapo uChaala akati, ‘Bhaghindikaghe ughuuso nu nyoko.’ Soona akati, ‘Ghweshi yuuyo akumutuka ughwise pamu ungʼina, akulondighwa ukughoghighwa.’ ");
INSERT INTO ndh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Loole umwe mukuyugha ukuti umundu akwitikishighwa ukumubhuula ughwise pamu ungʼina ukuti, ‘Utundu tuutwo ngali naakwafwa, naafumya kwa Chaala.’ ");
INSERT INTO ndh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Po mukuyugha ukuti umundu atakulondighwa ukumughindika ughwise pamu ungʼina. Ukwo kwo kuukwo kulifuyula ishu ilya Chaala ku sila iya kukonga inyiiho shiinyu. ");
INSERT INTO ndh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwe bhongubhisania umwe! Shila shiisho umusololi uYesaaya akasolola ku nongwa yiinyu sha nalooli paapo akati, ");
INSERT INTO ndh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Abhandu abha bhakuungindika ku mashu gheene, loole indumbula shaabho shili kubhutali nuune. ");
INSERT INTO ndh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ukuunyiipuuta kwabho kwa pabhubhuushe! Paapo bhakumanyishanga ifimanyisho fiifyo ndaghilo sha bhandu.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Po uYeesu akachiitisha ichilundilo icha bhandu, akachibhuula akati, “Pulikishanga akiisa nu kushaaghania! ");
INSERT INTO ndh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Fitaa findu fiifyo fikwingila mu mulomu, fyo fiifyo fikumubhiika umundu ukubha munyali. Loole amashu ghaagho ghakufuma mu mulomu, gho ghaagho ghakumubhiika umundu ukubha munyali.” ");
INSERT INTO ndh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Po abhamanyili bhaake bhakabhuuka kwa Yeesu, bhakamubhuusha bhakati, “Ghwe Mumanyishi, kali, umeenye ukuti bhwo aBhafalisaayi bhaapulika amashu ghala ghwayughagha, bhaakaleele leka?” ");
INSERT INTO ndh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","UYeesu akaamula akati, “UTaata ghwangu yuuyo ali kumwanya indiakamupyute ghweshi umundu yuuyo akumanyisha shiisho umwene atakalaghila. ");
INSERT INTO ndh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bhaleke, paapo abho bhalongoshi abhafwamaaso bhaabho bhakubhalongosha abhafwamaaso abhanine! Linga umufwamaaso akumulongosha umufwamaaso umunine, bhooshi bhabhili bhakughwila mu mbanga!” ");
INSERT INTO ndh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Loole uPeeteli akamubhuula akati, “Ghwe Mumanyishi, tukukusuuma utwilulile ichifwanikisho icho ghwayugha ukuti ifindu fitakumubhiika umundu ukubha munyali.” ");
INSERT INTO ndh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","UYeesu akabhaamula akati, “Kali, nuumwe mukaali mutakushaaghania? ");
INSERT INTO ndh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kali, mutameenye ukuti kooshi kaako kakwingila mu mulomu, kakwingila mu mala agha mundu, po pabhumalilo akukafumya ukubhuuka kwa syenje? ");
INSERT INTO ndh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Loole kooshi kaako kakufuma mu mulomu ughwa mundu, kakufuma mu ndumbula yaake. Ako ko kaako kakumubhiika umundu ukubha munyali. ");
INSERT INTO ndh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Paapo mu ndumbula iya mundu mwo muumwo mukufuma inyinongʼono imbiibhi, ubhughoghi, ubhushipani, ubhwifi, ubhukeeti ubhwa bhumyashi na maheelu. ");
INSERT INTO ndh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Shooshi isho sho shiisho shikumubhiika umundu ukubha munyali. Loole umundu atabhaghiile ukubha munyali ku nongwa iya kuti akulya chishita kusukusula utukono.” ");
INSERT INTO ndh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","UYeesu akatiila pala, akabhuuka kumbafu isha kaaya aka Tiilo na ka Sindoni. ");
INSERT INTO ndh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Po umukolo yumo uMukananaayi yuuyo akiikalagha ukwo, akiisa kwa Yeesu, akiitisha ku ishu ilya pamwanya akati, “Ghwe Malafyale, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, imbelele ichisa! Umulindu ghwangu akoliighwe leka ni mbepo imbiibhi.” ");
INSERT INTO ndh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Loole uYeesu atakaamula naalimo. Pabhumalilo, abhamanyili bhaake bhakiisa nu kumusuuma bhakati, “Ghwe Mumanyishi, tukukusuuma umubhuule umukolo uyu atiileepo, paapo akuywegha kunyuma kukwitu.” ");
INSERT INTO ndh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","UYeesu akabhaamula akati, “UChaala akaanduma pakubhapoka aBhaisilaeli bhaabho bhali ungati bhonangʼooshi bhaabho bhasobhite.” ");
INSERT INTO ndh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Loole umukolo yula akiisa, akafughamila pandaashi pa Yeesu, akamusuuma akati, “Ghwe Malafyale, ingukusuuma ghuunyaafwe!” ");
INSERT INTO ndh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","UYeesu akamwamula umukolo yula akati, “Kataa kiisa ukwegha ifindu ifya bhaana nu kubhaponekesha abhokabhwa.” ");
INSERT INTO ndh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Umukolo yula akati, “Nalooli Malafyale, loole na bhokabhwa bhoope bhakulya utubhululusha tuutwo tukughwa paase ukufuma pa meesa isha bhosongo bhaabho.” ");
INSERT INTO ndh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","UYeesu akamwamula akati, “Ghwe mukolo ughwe, uli nu lwitiko ulukulu leka! Indishibhe isa muumwo kulondela.” Nakalinga, umulindu yula akapola. ");
INSERT INTO ndh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","UYeesu akatiila pabhuyo bhula, akabhuuka ukughendela kulubhafu ulwa sumbi ughwa Ghalilaayi. Po akakwela pa kaghamba nu kwikala kula kula. ");
INSERT INTO ndh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Abhandu abhingi leka bhakabhuuka kwa Yeesu, bhakabhuuka na bhochikwefu, abhafwamaaso, abhalemale, abhochinuunu na bhabhine abhanine abhingi. Abhandu abhingi bhala bhakabhabhiika abhabhine pa tulundi utwa Yeesu, ghwepe akabhaposha. ");
INSERT INTO ndh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Abhandu bhala bhakaswigha leka bhwo bhakubhabhona abhochinuunu bhakuyugha, abhalemale na bhochikwefu bhakughenda bhwo bhagholokite na bhafwamaaso bhakutesha. Po bhakaanda ukumupaala uChaala yuuyo aBhaisilaeli bhakumwipuuta. ");
INSERT INTO ndh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Po uYeesu akabhiitisha abhamanyili bhaake, akabhabhuula akati, “Ingubhapelela ichisa abhandu abha ku nongwa iya kuti twikala nabho amashiku matatu bhatali ni findu. Indakulonda imbalaghe ukuti bhabhuukaghe mu twaya twabho bhwo bhali ni sala, indibhashilike mu sila paapo abhandu bhamu bhafumite kubhutali.” ");
INSERT INTO ndh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abhamanyili bhaake bhala bhakamubhuusha bhakati, “Ghwe Mumanyishi, kali, tubhaghiile ukufyagha kuughu ifindu ifya kubhayiilania abhandu bhooshi abha? Paapo pabhuyo panu patali nu twaya utwa bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","UYeesu akabhabhuusha akati, “Kali, muli ni mikati milinga?” Bhakamwamula bhakati, “Tuli ni mikati mihaano na mibhili (7) nu tuswi tumo tunandiishe.” ");
INSERT INTO ndh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Po uYeesu akabhalaghila abhandu bhooshi ukuti bhiikale paase. ");
INSERT INTO ndh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akeegha imikati mihaano na mibhili yila nu tuswi tula, akapaalisha kwa Chaala, akabheghulania, akabhapa abhamanyili bhaake, bhoope abhamanyili bhakabhayabhila abhandu bhala. ");
INSERT INTO ndh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Abhandu bhooshi bhala bhakalya, bhakiikuta. Po bhwo abhamanyili bhaabhungaania utubhululusha, bhakiisusha utupombo tuhaano na tubhili (7). ");
INSERT INTO ndh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Po abhandu bhaabho bhakalya ifindu fila bhakabhaamwo abhaliisha abhoelufu bhanna chishita kubhelenga abhakolo na bhaana. ");
INSERT INTO ndh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Po uYeesu akabhalagha abhandu bhala nu kwingila mu bhwato, akabhuuka mu kaaya aka Maghandani. ");
INSERT INTO ndh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Po aBhafalisaayi na Bhasandukaayi bhamu bhakiisa kwa Yeesu, bhakamughela ukuti abhombe ichiika ukulangisha ukuti atumiighwe nu Chaala. ");
INSERT INTO ndh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","UYeesu akabhaamula akati, “Linga lyafika namasubha, mukuyugha mukuti, ‘Ningeelo indikukache akiisa paapo kumwanya kwelupite.’ ");
INSERT INTO ndh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Loole ku kabhalilo aka pangeelo mukuyugha mukuti, ‘Umuusughu ifula indiyitime paapo kumwanya kwaghimba soona kuli na mabhingu.’ Mwe bhongubhisania umwe! Mumeenye ukusolola isha tubhalilo ku sila iya kutesha muumwo kumwanya kubheeliile. Po kali, shili bhuleele mutabhaghiile ukufyaghania ifimanyisho ifya tubhalilo utu? ");
INSERT INTO ndh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Abhandu abhabhiibhi na bhashipani abha kabhalilo aka bhakulonda ichiika. Indaaingabhalangishe ichiika naachimo, loole chila chila icha kwa Yoona.” Po uYeesu akabhaleka, akatiila. ");
INSERT INTO ndh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bhwo abhamanyili abha Yeesu bhaalobhoka usumbi, bhakiibhwa ukwegha imikati. ");
INSERT INTO ndh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","UYeesu akabhabhuula akati, “Mubhange maaso ni nyambo iya Bhafalisaayi na Bhasandukaayi.” ");
INSERT INTO ndh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abhamanyili bhala bhakaanda ukuyughisania bheene-bheene bhakati, “Akuyugha bhubhuubhwo paapo tuteeghite imikati.” ");
INSERT INTO ndh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","UYeesu akashaaghania shooshi isho, akabhabhuula akati, “Mwe bhandu abha lwitiko ulunandi umwe! Kali, nongwa yiki mukuyughisania mwibheene-bheene ukuti mutali ni mikati? ");
INSERT INTO ndh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kali, mukaali mutakushaaghania? Kali, mukaali mutakukumbuka muumwo abhandu abhoelufu bhahaano (5,000) bhala bhakiikuta imikati mihaano yila? Kali, mukiisusha utupombo tulinga utwa tubhululusha? ");
INSERT INTO ndh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pamu imikati mihaano na mibhili (7) yila yiiyo ingabheghulania nu kubhapa abhandu abhoelufu bhanna (4,000) bhala, kali, mukabhungaania utupombo tulinga? ");
INSERT INTO ndh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kali, mutakushaaghania bhuleele ukuti isho shiisho naayughagha shitaa sha mikati? Po mubhange maaso ni nyambo iya Bhafalisaayi na Bhasandukaayi.” ");
INSERT INTO ndh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Po abhamanyili bhaake bhakashaaghania ukuti atakayughagha isha nyambo iya kululisha imikati, loole isha fimanyisho ifya bhumyashi ifya Bhafalisaayi na Bhasandukaayi. ");
INSERT INTO ndh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bhwo uYeesu aafika kumbafu isha Kayisaaliya-Filipi, akabhabhuusha abhamanyili bhaake akati, “Kali, abhandu bhakumuyugha uMwana ughwa Mundu ukuti ghwini?” ");
INSERT INTO ndh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhakamwamula bhakati, “Bhamu bhakumuyugha ukuti ghwi Yoohani uMwoshi, abhanine bhakumuyugha ukuti ghwi Eliiya na bhanine bhakumuyugha ukuti ghwi Yelemiiya pamu ghwe yumo mu bhasololi.” ");
INSERT INTO ndh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","UYeesu akabhabhuusha soona akati, “Kali, umwe mukuti une nee ghwini?” ");
INSERT INTO ndh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","USiimoni Peeteli akamwamula akati, “Ughwe ghwe Mesiiya, uMwana ghwa Chaala yuuyo mwumi.” ");
INSERT INTO ndh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","UYeesu akamubhuula akati, “Ghwe Siimoni, mwana ughwa Yoona, uli musayighwa paapo ataliipo umundu yuuyo aakusetulila isho, loole uTaata yuuyo ali kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Une ingukubhuula ukuti ughwe, ghwe Peeteli, soona pamwanya pa lyalabhwe ili po paapo indiingasenge ichipanga changu na maka agha bhufwe ghataaghakachipoote naalumo. ");
INSERT INTO ndh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nuune indiingupe ifungulilo isha chitangalala icha kumwanya ukuti shooshi shiisho ghwashipinya mu ngamu yangu pa chiisu panu, uChaala ghwepe akushipinya kumwanya. Soona shooshi shiisho ghwashaabhula mu ngamu yangu pa chiisu panu, uChaala ghwepe akushaabhula kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Po uYeesu akabhakaanisha abhamanyili bhaake bhala ukuti manye bhamubhuulaghe umundu naayumo ukuti umwene ghwi Mesiiya. ");
INSERT INTO ndh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ukwandila akabhalilo ako, uYeesu akaanda ukubhalingaania abhamanyili bhaake pabhwelu ukuti shikulondighwa abhuuke ku Yelusaleemu nu kushaagha indamyo inyingi ku bhosongo abha Bhayuuta, ku bhosongo abha bhapuuti na ku bhamanyishi abha ndaghilo isha Moose nu kughoghighwa. Loole indiakashuuke pi ishiku ilya bhutatu. ");
INSERT INTO ndh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Po uPeeteli akabhuuka naghwe palubhafu, akaanda ukumukemela akati, “Nashiku Malafyale, isho shitabhaghiile ukukwagha.” ");
INSERT INTO ndh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Loole uYeesu akamusanukila uPeeteli, akamubhuula akati, “Tiila kukwangu ghwe Seetano! Manye ghuushighilaghe ukubhomba ubhwighane ubhwa Chaala. Paapo utakwinongʼona shiisho sha Chaala, loole kwinongʼona shiisho sha bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Umundu ghweshi yuuyo akulonda ukuungonga, iikaane mwene, apimbaghe ichikobhekano chaake, aangongaghe. ");
INSERT INTO ndh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Paapo umundu yuuyo akulonda ukubhupoka ubhwumi bhwake, indiakabhusofye. Loole umundu yuuyo akubhufumya ubhwumi bhwake ku nongwa yangu, indiakabhwaghe ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kali, umundu indiakakabhe kooni linga aabhwagha ubhukabhi bhwoshi ubhwa pa chiisu nu kubhusofya ubhwumi bhwake? Pamu kali, umundu abhaghiile ukufumya kooni pa bhuyo ubhwa bhwumi bhwake? ");
INSERT INTO ndh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Paapo uMwana ughwa Mundu indiakiise pamupeene na bhandumi bhaake ku bhukulumba ubhwa Taata ghwake. Po indiakamuhombe umundu ghweshi ukukongana ni mbombo shaake. ");
INSERT INTO ndh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nalooli ingubhabhuula, bhaliipo bhamu panu bhaabho bhataabhakafwe bhwo bhakaali ukumubhona uMwana ughwa Mundu bhwo akwisa ni chitangalala chaake.” ");
INSERT INTO ndh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bhwo ghaakinda amashiku mahaano na limo (6), uYeesu akamwegha uPeeteli, uYaakobhu nu Yoohani umunungʼuna ughwa Yaakobhu. Akakwela nabho pa kaghamba akatali ngaani, pabhuyo ubhushiifu. ");
INSERT INTO ndh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Po bhwo bhali pala, uYeesu akasanuka icheeni pandaashi papaabho. Icheeni chaake chikangʼangʼagha ungati lisubha ni myenda yaake yikabha myelu leka isa ubhwelu ubhwa lisubha. ");
INSERT INTO ndh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nakalinga bhakabhoneka uMoose nu Eliiya bhakuyugha naghwe. ");
INSERT INTO ndh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Po uPeeteli akamubhuula uYeesu akati, “Ghwe Malafyale, kiisa ukuti utwe tubhe panu panu. Linga ghwitikisha, indiisenge panu ifitembe fitatu. Chimo chibhe chaako, ichinine chibhe cha Moose ni chinine chibhe cha Eliiya.” ");
INSERT INTO ndh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bhwo uPeeteli akaali ali pakuyugha, tesha, ibhingu liilyo likungʼangʼa likiisa nu kubhiifunikila. Po ishu likapulikighwa ukufuma mu ibhingu lila likati, “Uyu ghwe yuuyo Mwana ghwangu umughanighwa yuuyo inguhobhoka naghwe, mupulikaghe!” ");
INSERT INTO ndh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bhwo abhamanyili bhaake bhala bhaapulika isho, bhakooghopa leka, bhakaghwa paase nu kwishighila ifyeni fyabho. ");
INSERT INTO ndh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","UYeesu akapalamila papiipi, akabheeghelesha, akabhabhuula akati, “Iima, manye mwoghopaghe!” ");
INSERT INTO ndh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bhwo bhiinula amaaso ghaabho, bhakamubhona uYeesu aashaala mweneeshe. ");
INSERT INTO ndh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Po bhwo bhakwilomuka pa kaghamba kala, uYeesu akabhalaghilila akati, “Manye mumubhuulaghe umundu naayumo shooshi shiisho mwashibhona ukufika paapo uMwana ughwa Mundu indiakashuuke.” ");
INSERT INTO ndh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abhamanyili bhala bhakamubhuusha bhakati, “Kali, nongwa yiki abhamanyishi abha ndaghilo isha Moose bhakuti uEliiya akulondighwa atangile taashi ukwisa bhwo uKilisiti akaali?” ");
INSERT INTO ndh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","UYeesu akabhaamula akati, “Nalooli, uEliiya akulondighwa ukwisa taashi ukuti iise atendekeshe imbombo shooshi. ");
INSERT INTO ndh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Loole ingubhabhuula ukuti uEliiya iisile, abhandu bhatakamumanyagha, bhakamubhombela akabhiibhi. Bhubhuubhwo, uMwana ughwa Mundu akuya pakubhombelighwa akabhiibhi na bhandu abho.” ");
INSERT INTO ndh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Po abhamanyili bhala bhakamanya ukuti uYeesu akayughagha nongwa isha Yoohani uMwoshi. ");
INSERT INTO ndh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bhwo uYeesu na bhamanyili bhaake bhaafika paapo pakabha ni chilundilo icha bhandu, umundu yumo akabhuuka kwa Yeesu, akafughamila pandaashi papaake. ");
INSERT INTO ndh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Akamubhuula uYeesu akati, “Ghwe Malafyale, ingusuuma umupelele ichisa umwana ghwangu paapo ali nu bhubhine ubhwa linyiki. Ubhubhine ubhwo, bhukumutamyanga leka. Akabhalilo akingi akughwanga mu mulilo na mu miishi. ");
INSERT INTO ndh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niisile naghwe ku bhamanyili bhaako ukuti bhayikiishe imbepo imbiibhi iyo, loole bhapooshitwe.” ");
INSERT INTO ndh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","UYeesu akabhaamula akati, “Mwe bhandu abha kabhalilo aka mwe mutakwitika, mwe musobhite. Kali, indiniikale nuumwe nu kukibha ukufika liighi? Isagha naghwe umwana uyo kukwangu!” ");
INSERT INTO ndh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bhwo bhiisa naghwe, uYeesu akayikemela imbepo imbiibhi yila, yoope yikafuma nu mwana yula akapola akabhalilo kala kala. ");
INSERT INTO ndh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Po abhamanyili abha Yeesu bhakamwisila pabhuyo ubhushiifu, bhakamubhuusha bhakati, “Kali, kooni utwe twapooshitwe ukuyikiisha imbepo imbiibhi yila?” ");
INSERT INTO ndh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ghwepe akabhaamula akati, “Ku nongwa iya kuti ulwitiko lwinyu lunandi. Nalooli ingubhabhuula, linga muli nu lwitiko ulunandi isa akabheyu aka nambamba, indimukabhuule akaghamba aka ukuti, ‘Tiilaapo panu, ubhuuke pala,’ koope indikatiile. Po naakamu akandu kaako indimukapootwange.  ");
INSERT INTO ndh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pamupeene ni isho, imbepo imbiibhi iya luko ulwo mutabhaghiile ukuyikiisha, loole kwene ku sila iya kwipuuta kwa Chaala nu kwiyiima ukulya ifindu.” ");
INSERT INTO ndh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bhwo uYeesu ali pamupeene na bhamanyili bhaake mu Ghalilaayi, akabhabhuula akati, “UMwana ughwa Mundu akuya pakubhiikighwa mu tukono utwa bhalughu ");
INSERT INTO ndh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nu kughoghighwa. Po pi ishiku ilya bhutatu, uChaala indiakamushuushe.” Bhwo abhamanyili bhaake bhaapulika isho, bhakaswimaana leka. ");
INSERT INTO ndh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Bhwo uYeesu na bhamanyili bhaake bhaafika mu Kapenabhumu, abhandu bhamu bhaabho bhakasongeshanga isongo iya kubhombela mu Nyumba iya Chaala, bhakiisa kwa Peeteli. Bhakamubhuusha bhakati, “Kali, umumanyishi ghwinyu ghwepe akusongagha isongo iya mu Nyumba iya Chaala?” ");
INSERT INTO ndh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","UPeeteli akabhaamula akati, “Mwo muumwo, akusongagha.” Po akiingila mu nyumba. Loole bhwo uPeeteli akaali ukuyugha limo, uYeesu akaanda ukumubhuusha akati, “Ghwe Siimoni, kali, ughwe kutesha bhuleele? Kali, abhomalafyale abha mu chiisu ichi bhakusongesha isongo ku bhandu bhaabho pamu ku bhandu abhanine?” ");
INSERT INTO ndh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","UPeeteli akaamula akati, “Bhakusongesha ku bhandu abhanine.” UYeesu akamubhuula akati, “Linga mwo muumwo, po bhabhahobhokiile abhandu bhaabho ukusonga isongo. ");
INSERT INTO ndh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Loole ukuti manye tubhakalalishe abhandu abha, bhuuka uponie akashikulo mwa sumbi. Po iswi yiiyo ghwayikola kubhwandilo, uyaasamye umulomu, indiuyaaghe indalama mukati. Po uyeeghe indalama iyo ukuti uye usonge isongo yangu ni yaako.” ");
INSERT INTO ndh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ku kabhalilo kala abhamanyili bhakabhuuka kwa Yeesu, bhakamubhuusha bhakati, “Kali, ghwini yuuyo indiabhe ghwi songo ukukinda abhanine bhooshi mu chitangalala icha kumwanya?” ");
INSERT INTO ndh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","UYeesu akamwitisha umwana umukeke, akamwimika pakati papaabho, ");
INSERT INTO ndh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","akabhabhuula akati, “Nalooli ingubhabhuula, linga mutakupinduka nu kubha ungati bhaana abhakeke, mutaamukiingile shiku ku chitangalala icha kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Po umundu ghweshi yuuyo akwiyiisha ungati mwana umukeke uyu, uyo ghwe yuuyo indiakabhe ghwi songo ku chitangalala icha kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Soona, umundu ghweshi yuuyo akumupokeela umwana umukeke yuuyo ali ungati uyu mu ngamu yangu, po akuumbokeela neene.” ");
INSERT INTO ndh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Loole linga aliipo umundu yuuyo akumusofya yumo mu bhafuyuke abha bhaabho bhakuunyiitika une, kaali kiisa kukwake ukumupinyiilila ulwala ulukulu mu shingo nu kumutaagha mu chishibha ichitali icha mu nyanja. ");
INSERT INTO ndh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Lwinyu mwe bhandu mwe bha pa chiisu ichi ku nongwa iya shiisho shikubhapelela abhandu ukubhomba imbiibhi! Ingelo sho indishiseeshe, loole lwake umundu yuuyo akushipela ingelo isho! ");
INSERT INTO ndh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Linga akakono kaako pamu akalundi kaako kakukusofya ukuti ubhombe imbiibhi, katumule nu kukataagha kubhutali. Paapo kiisa ghwingile mu bhwumi ubhwa bhwila na bhwila bhwo uli nu bhulemale, ukukinda ukubha nu tukono twoshi tubhili pamu utulundi twoshi tubhili nu kutaaghighwa mu mulilo ughwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Soona linga ilyiso lyako likukusofya ukuti ubhombe imbiibhi, lifwombole nu kulitaagha kubhutali! Paapo kiisa ghwingile mu bhwumi ubhwa bhwila na bhwila bhwo uli ni lyiso limolyene, ukukinda ukubha na maaso ghooshi mabhili nu kutaaghighwa mu mulilo ughwa bhwila na bhwila ughwa mu Yehanamu.” ");
INSERT INTO ndh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mubhange maaso, manye mumufuyulaghe yumo mu bhiitiki abha! Paapo ingubhabhuula ukuti abhandumi bhaabho abha kumwanya akabhalilo kooshi bhali pandaashi pa Taata yuuyo ali kumwanya.  ");
INSERT INTO ndh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Paapo uMwana ughwa Mundu akiisa mu chiisu ukuti abhapoke bhaabho bhasobhite. ");
INSERT INTO ndh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kali, mukwinongʼona bhuleele? Linga umundu ali na bhonangʼooshi imya yimo (100), aamanya ukuti unangʼooshi yumo mu bhonangʼooshi bhala aasobha, kali, akubhomba kooni? Kali, atakubhaleka taashi abhonangʼooshi amalongo mahaano na manna, bhahaano na bhanna (99) bhala mu tughamba nu kubhuuka pakumulonda unangʼooshi yula yuuyo asobhite? ");
INSERT INTO ndh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nalooli ingubhabhuula, linga aamwagha, akuhobhoka leka ku nongwa iya nangʼooshi yumoywene yula ukukinda abhonangʼooshi amalongo mahaano na manna, bhahaano na bhanna bhala bhaabho bhataasobhite. ");
INSERT INTO ndh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bhubhuubhwo, uTaata ghwinyu yuuyo ali kumwanya atakulonda ukuti yumo mu bhakeke abha asobhe.” ");
INSERT INTO ndh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Linga umwitiki umunyiinyu aakutulila inongwa, bhuuka umusoke bhwo muli bhabhiliishe. Linga aakupulika, po bhwo ghwamwagha soona umwitiki umunyiinyu. ");
INSERT INTO ndh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Loole linga ataakupulika, bhuuka umweghe umundu umunine yumo pamu abhandu bhabhili ukuti ‘bhabheepo abhakeeti bhabhili pamu bhatatu abha kushimikisha kooshi akandu.’ ");
INSERT INTO ndh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Linga ataabhapulika abho bhoope, bhuuka pakuchibhuula ichipanga. Linga ataachipulika ni chipanga, po mumubhelengelaghe isa muumwo mubhaghiile ukumubhelengela yuuyo ataa mwitiki pamu yuuyo musongesha songo.” ");
INSERT INTO ndh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nalooli ingubhabhuula, shooshi shiisho mukushipinya mu ngamu yangu pa chiisu panu, uChaala ghwepe akushipinya kumwanya. Soona shooshi shiisho mukushaabhula mu ngamu yangu pa chiisu panu, uChaala ghwepe akushaabhula kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ingubhabhuula soona ukuti linga bhabhili pakati papiinyu bhiitikana pa chiisu panu ku shiisho bhakusuuma, uTaata yuuyo ali kumwanya indiakabhabhombele isho. ");
INSERT INTO ndh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Paapo linga bhaliipo abhandu bhabhili pamu bhatatu bhaabho bhabhungaanite ku ngamu yangu, nuune ingubhaapo pamupeene nabho.” ");
INSERT INTO ndh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Po uPeeteli akabhuuka kwa Yeesu, akamubhuusha akati, “Ghwe Malafyale, linga umwitiki umunyiitu aandulila inongwa, kali, ingulondighwa imuhobhokele kalinga? Kali, kahaano na kabhili (7)?” ");
INSERT INTO ndh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","UYeesu akamwamula akati, “Indakukubhuula ukuti kahaano na kabhiliishe, loole umuhobhokelaghe umunyiinyu akabhalilo kooshi mu bhwumi bhwako chishita kubhelenga. ");
INSERT INTO ndh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ku nongwa iyo ichitangalala icha kumwanya chibhaghiile ukughelela ni chifwanikisho icha malafyale yumo yuuyo akalondagha ukubhomba imbelengelo isha bhabhombi bhaake. ");
INSERT INTO ndh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bhwo umalafyale aanda ukubhelenga, abhashikali bhaake bhakiisa nu mubhombi yumo pandaashi papaake yuuyo akamelelighwanga italanta abhoelufu kalongo (10,000). ");
INSERT INTO ndh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Umubhombi uyo akapootwa ukuhomba indalama shiisho akamelelighwanga. Po umalafyale akabhalaghila abhashikali bhaake ukuti bhamughulishe umwene nu mukashi, abhaana bhaake pamupeene nu tundu twoshi tuutwo akabha natwo ukuti amuhombe. ");
INSERT INTO ndh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Po umubhombi yula akafughamila pandaashi pa malafyale, akamusuuma akati, ‘Ingusuuma ghuundindilile panandi, indiinguhombe utundu twako twoshi.’ ");
INSERT INTO ndh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Umalafyale yula akamupelela ichisa umubhombi ghwake, akamuhobhokela tula tuutwo akamelelighwanga, akamwitikisha ukuti abhuukaghe, ghwepe akafuma. ");
INSERT INTO ndh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bhwo aafuma kuuse, akakomaana nu mubhombi umunine yuuyo akamukopela indinaali imya yimo (100). Nakalinga akamupiita ku imilo, akamubhuula akati, ‘Ihombe tuutwo ingakukopela.’ ");
INSERT INTO ndh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Umubhombi umunine yula akafughamila pandaashi yaake, akamusuuma akati, ‘Ghuundindilile panandi, indiinguhombe utundu twako.’ ");
INSERT INTO ndh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Loole umwene akakaana, akabhuuka pakumupinya umunine yula mu nyumba iya bhapinyighwa ukufika ku kabhalilo kaako indiakahombe utundu utwo. ");
INSERT INTO ndh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Bhwo abhabhombi abhanine bhaashibhona isho, bhakafulala leka mu ndumbula shaabho. Po bhakabhuuka kwa malafyale ghwabho nu kumulingaania shooshi shiisho shikabhombighwa. ");
INSERT INTO ndh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Po umalafyale akamwitisha umubhombi yula, akamubhuula akati, ‘Ghwe mubhombi umubhiibhi ughwe! Tesha, bhwo ghwasuuma ukuti inguhobhokele fiifyo ingakumelelagha, ingakuhobhokela shooshi isho! ");
INSERT INTO ndh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kali, nuughwe utakulondighwa ukumupelela ichisa umubhombi umunyiinyu yula isa muumwo nuune naakupeliile ichisa ughwe?’ ");
INSERT INTO ndh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Po umalafyale yula akakalala leka, akabhalaghila abhashikali bhaake ukuti bhamukole nu kumuponia mu nyumba iya bhapinyighwa ukufika ku kabhalilo kaako indiakahombe ifindu fyoshi.” ");
INSERT INTO ndh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pabhumalilo, uYeesu akayugha akati, “UTaata yuuyo ali kumwanya indiakabhabhombele nuumwe isa bhubhuubhwo linga mutabhaghiile ukumuhobhokela umwitiki umunyiinyu ku ndumbula shiinyu shooshi.” ");
INSERT INTO ndh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bhwo uYeesu aamala ukuyugha amashu agho, akatiila mu Ghalilaayi, akaghendela kulubhafu ku chiisu chiicho chili ku isiila ilya lusooko ulwa Yoolotani, ukubhuuka mu chiisu icha Yuteeya. ");
INSERT INTO ndh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Po abhandu abhingi bhakamukonga, ghwepe akabhaposha bhooshi bhaabho bhakabha bhabhine. ");
INSERT INTO ndh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Po aBhafalisaayi bhamu bhakiisa kwa Yeesu, ukuti bhamughele, bhakamubhuusha bhakati, “Kali, indaghilo isha Moose shikwitikisha umulume ukumusoosha umukashi ku nongwa yooshi yila?” ");
INSERT INTO ndh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","UYeesu akabhaamula, akabhabhuusha akati, “Kali, mukaali mutabhelengite mu Masimbo aMeelu ukuti ukufuma kubhwandilo ubhwa kupelighwa ichiisu ‘uChaala akapela umuliisha nu mukolo’? ");
INSERT INTO ndh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Akati, ‘Yo yiiyo nongwa iyi umuliisha indiakamuleke ughwise nu ngʼina, po indiakakamandane nu mukashi, abhandu bhabhili abho indibhakabhe mubhili ghumoghwene.’ ");
INSERT INTO ndh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Po bhoope bhatakubha bhabhili soona, loole bhakubha mubhili ghumoghwene. Po chiicho uChaala achikamandaniishe, manye umundu achilekaaniange.” ");
INSERT INTO ndh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ABhafalisaayi bhala bhakamubhuusha soona bhakati, “Linga ishi sha nalooli, po kali, nongwa yiki uMoose akiitikisha mu ndaghilo ukuti umuliisha amupange umukashi ukalata ughwa kusookana nu kumuleka?” ");
INSERT INTO ndh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","UYeesu akabhaamula akati, “UMoose akabhiitikisha ukuti mubhalekaghe abhakashi bhiinyu ku nongwa iya kuti indumbula shiinyu ngafu, loole ukufuma kubhwandilo ubhwa bhupeli, shitakabha ulwo. ");
INSERT INTO ndh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ingubhabhuula ukuti umundu ghweshi yuuyo akumusoosha umukashi bhwo umukolo uyo ataa mushipani nu kwegha umukolo umunine, akubhomba ubhushipani. Ghwepe yuuyo akumwegha umukolo yuuyo bhamusooshiishe, akubhomba ubhushipani.” ");
INSERT INTO ndh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Po abhamanyili bhaake bhakamubhuula bhakati, “Linga bhwo shili ulwo ku mulume nu mukashi, po kiisa ukushita kwegha!” ");
INSERT INTO ndh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","UYeesu akabhaamula akati, “Bhataa bhandu bhooshi bhaabho bhabhaghiile ukulipokeela ishu ili, loole bhala bheene bhaabho uChaala abhabhaghishiishe ukulipokeela. ");
INSERT INTO ndh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Paapo abhandu bhamu bhatakwegha ku nongwa iya kuti bhakapaapighwa bhaghumba. Abhanine bhatakwegha ku nongwa iya kuti abhandu bhakabhapanja ukuti manye bhapaapaghe. Bhaliipo na bhanine bhaabho bhatakwegha ku nongwa iya chitangalala icha kumwanya. Umundu ghweshi yuuyo abhaghiile ukulipokeela ishu ili, alipokeelaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Abhandu bhamu bhakiisa na bhaana abhakeke kwa Yeesu ukuti abhabhiikile utukono pa mitu yaabho nu kubhiipuutila kwa Chaala. Loole abhamanyili bhaake bhakabhakemela abhandu bhala. ");
INSERT INTO ndh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Loole uYeesu akabhabhuula akati, “Bhaleke abhaana abhakeke bhiisaghe kukwangu, manye mubhakaanishange. Paapo ichitangalala icha kumwanya cha bhandu bhooshi bhaabho bhali ungati bhaana abha.” ");
INSERT INTO ndh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Po uYeesu akabhabhiikila utukono pa mitu yaabho, akabhasaya nu kutiilaapo pabhuyo bhula. ");
INSERT INTO ndh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Po umundu yumo akiisa kwa Yeesu, akamubhuusha akati, “Ghwe Mumanyishi mwisa, kali, imbombe kooni akiisa ukuti imbwaghe ubhwumi ubhwa bhwila na bhwila?” ");
INSERT INTO ndh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","UYeesu akamwamula akati, “Kali, kooni kuyugha isha kubha mwisa? Tesha, uChaala mwene ghwe yuuyo mwisa! Loole linga kulonda ukubhwagha ubhwumi ubhwa bhwila na bhwila, shikongaghe indaghilo isha Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Umulumyana yula akamubhuusha akati, “Kali, indaghilo isho sho shiliku?” Po uYeesu akamwamula akati, “Manye ughoghaghe, manye ubhange mushipani, manye ghwibhaghe, manye uyughaghe ubhumyashi, ");
INSERT INTO ndh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ubhaghindikaghe ughuuso nu nyoko,” soona, “Mughanaghe umunyiinyu isa muumwo ghwiyiighanite yughweghwe.” ");
INSERT INTO ndh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Umulumyana yula akati, “Indaghilo shooshi isho ishikongite. Kali, kooni kaako kashaalite kaako indabhombite?” ");
INSERT INTO ndh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","UYeesu akamubhuula akati, “Linga kulonda ukubha mugholofu, bhuuka ughulishe fyoshi fiifyo uli nafyo, indalama shiisho ghwashaagha, ubhape abhapiina. Linga ghwabhomba ulwo, indiukabhe ghwibhiikila ichuuma kumwanya, po isagha, ghuungongaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bhwo umulumyana yula aapulika isho, akatiila pala bhwo aswimaanite paapo akabha ni chuuma chingi leka. ");
INSERT INTO ndh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Nalooli ingubhabhuula, indikakabhe kapala leka umukabhi ukwingila mu chitangalala icha kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ingubhabhuula soona ukuti kupepe ingamila ukufumisania pa kaashi aka sindaano, ukukinda umukabhi ukwingila mu chitangalala icha Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bhwo abhamanyili bhala bhaapulika isho, bhakaswigha leka, bhakamubhuusha bhakati, “Po linga bhwo shili, kali, ghwini yuuyo abhaghiile ukupokighwa?” ");
INSERT INTO ndh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","UYeesu akabhatesha, akabhabhuula akati, “Nalooli isho shitabhaghiile ukubhombighwa ku bhandu, loole kwa Chaala shooshi shibhaghiile ukubhombighwa.” ");
INSERT INTO ndh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","UPeeteli akamubhuusha akati, “Tesha, utwe tufilekite fyoshi, tukukongite. Kali, inditukakabhe kooni?” ");
INSERT INTO ndh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","UYeesu akabhaamula akati, “Nalooli ingubhabhuula, bhwo uMwana ughwa Mundu iikiile pa chitengu chaake icha bhukulumba mu chiisu ichipya, po nuumwe indimukiikale pa fitengu kalongo na fibhili (12) bhwo mukufilonga ifikolo kalongo na fibhili (12) ifya Isilaeli. ");
INSERT INTO ndh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Po umundu ghweshi yuuyo ayilekite inyumba, abhakulu, abhalumbu, ughwise, ungʼina, abhaana pamu imighunda ku nongwa yangu, indiakapokeele imya yimo (100) mu tundu twoshi. Soona indiakabhwaghe ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Loole abhandu abhingi bhaabho bhakughindikighwa akabhalilo aka, bhataabhakaghindikighwe akabhalilo kaako kakwisa. Soona, abhandu bhaabho bhatakughindikighwa akabhalilo aka, indibhakaghindikighwe akabhalilo kaako kakwisa.” ");
INSERT INTO ndh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","UYeesu akeendelela ukuyugha akati, “Ichitangalala icha kumwanya chigheliile nu mwene mughunda yuuyo akafuma kuuse pangeelo nakafwelelema pakubhalonda abhabhombi abha kubhomba imbombo mu mughunda ghwake ughwa misabhibhu. ");
INSERT INTO ndh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bhwo aabhaagha, umwene mughunda akiitikana nabho ukumuhomba ghweshi umundu umufwalo ughwa lishiku limo, po akabhatuma ku mughunda ghwake. ");
INSERT INTO ndh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Po bhwo lyafika mu sala iya bhutatu pangeelo (3:00), akafuma kuuse soona, akabhabhona abhandu abhanine bhiimite pa munaalo chishita mbombo. ");
INSERT INTO ndh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akabhabhuula akati, ‘Nuumwe bhuuka pakubhomba imbombo mu mughunda ghwangu. Nuune indiniise imbahombe mweshi isa muumwo shikulondighwa.’ ");
INSERT INTO ndh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bhoope bhakabhuuka. Po bhwo isubha lyabha pamutu (6:00) na bhwo lyafika mu sala iya bhuhaano na inna (9:00), akafuma kuuse soona, akabhiingisha abhandu abhanine mu mughunda ghwake ghula. ");
INSERT INTO ndh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bhwo lyabha lya namasubha (11:00), akafuma kuuse soona, akabhabhona abhandu abhanine bhaabho bhiimite pa munaalo. Akabhabhuusha akati, ‘Kali, kooni mwimite panu ishiku lyoshi chishita mbombo?’ ");
INSERT INTO ndh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bhoope bhakamwamula bhakati, ‘Ku nongwa iya kuti naayumo umundu yuuyo atubhiikite pa mbombo.’ Umwene akabhabhuula akati, ‘Nuumwe bhuuka pakubhomba imbombo mu mughunda ghwangu isa muumwo abhanyiinyu bhali pakubhomba.’ ");
INSERT INTO ndh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Bhwo ichiisi chaaghwa, umwene mughunda yula akamubhuula yuuyo akiimilila imbombo yaake akati, ‘Bhiitishe abhabhombi bhooshi ukuti ubhahombe umufwalo ghwabho. Bhwo kubhahomba, ghwande na bhabhombi bhaabho bhiisile kubhumalilo nu kumalila ku bhaabho bhiisile kubhwandilo.’ ");
INSERT INTO ndh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Po abhabhombi bhala bhaabho bhakiisa namasubha, bhakiisa nu kupokeela indalama iya kuyiilana nu mufwalo ughwa lishiku limolyene. ");
INSERT INTO ndh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bhwo abhabhombi bhala bhaabho bhakiisa kubhwandilo bhiisa, bhakasubhaalila ukupokeela ukwongelaapo ukukinda abhanine bhaabho bhakiisa kubhumalilo. Loole umundu ghweshi akahombighwa indalama iya kuyiilana nu mufwalo ughwa lishiku limolyene. ");
INSERT INTO ndh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Po bhwo bhaashipokeela, bhakaanda ukwilumbuusha ku mwene mughunda bhakati, ");
INSERT INTO ndh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Abhandu bhala bhaabhomba imbombo ku sala yimoyeeneeshe, po kali, shili bhuleele ghwatughelesha nabho bhwo utwe twayibhomba imbombo ingafu leka ishiku lyoshi?’ ");
INSERT INTO ndh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Umwene mughunda yula akamwamula yumo mu bhandu bhala akati, ‘Ghwe mumanyani ghwangu, indaakushimbula naakamu. Kali, tutapulikanite ukuti indiubhombe imbombo ku ndalama iya kuyiilana nu mufwalo ughwa lishiku limolyene? ");
INSERT INTO ndh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eegha indalama yaako iyi, tiilaapo panu! Une indumwile ukumuhomba umundu uyu ughwa kubhumalilo umufwalo ghuughwo ghugheliile nu ghwako. ");
INSERT INTO ndh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kali, indakwitikishighwa ukubhombela ifindu fyangu isa muumwo niighaniile? Pamu kali, uli nu lwibhuno paapo indi mupe leka ku bhangi?’ ” ");
INSERT INTO ndh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","UYeesu akayugha soona akati, “Po abhandu abhingi bhaabho bhataabhakaghindikighwe akabhalilo kaako kakwisa, bho bhaabho bhakughindikighwa akabhalilo aka. Soona, abhandu bhaabho bhatakughindikighwa akabhalilo aka, indibhakaghindikighwe akabhalilo kaako kakwisa.” ");
INSERT INTO ndh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bhwo uYeesu ali mu sila akukwela ukubhuuka ku Yelusaleemu, akabheegha pabhushiifu abhamanyili bhaake kalongo na bhabhili (12), akabhabhuula akati, ");
INSERT INTO ndh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tesha, ulu tukukwela ukubhuuka ku Yelusaleemu. Bhwo tuli ukwo, uMwana ughwa Mundu akuya pakubhiikighwa mu tukono utwa bhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose, bhoope indibhakamulonge ukuti aghoghighwe. ");
INSERT INTO ndh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pabhumalilo, indibhakamubhiike mu tukono utwa bhaabho bhataa Bhayuuta ukuti bhamwangalile, bhamukome ni fikoti nu kumukomeela pa chikobhekano. Loole pi ishiku ilya bhutatu, indiakashuuke.” ");
INSERT INTO ndh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Po umukashi ughwa Sebhetaayi akabhuuka na bhaana bhaake, akafughamila pandaashi pa Yeesu nu kusuuma ubhutuuli. ");
INSERT INTO ndh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","UYeesu akamubhuusha akati, “Kali, kulonda ingubhombele kooni?” Ghwepe akamwamula akati, “Bhwo ghwanda ukulongosha, ingusuuma ubhiitikishe abhaana bhangu bhabhili abha ukuti yumo akiikale ku kakono kaako aka kumwisa, umunine ku kakono kaako aka kushoomi mu chitangalala chaako.” ");
INSERT INTO ndh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","UYeesu akaamula akati, “Mutashimeenye shiisho mukusuuma. Kali, mubhaghiile ukungʼwela ichikombe icha ndamyo chiicho inguya pakungʼwela?” Bhakamwamula bhakati, “Tubhaghiile.” ");
INSERT INTO ndh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","UYeesu akabhabhuula akati, “Nalooli ichikombe chiicho inguya pakungʼwela indimungʼwele, loole yitaa mbombo yangu ukubhiitikisha ukuti yumo iikale ku kakono kangu aka kumwisa, umunine ku kakono kangu aka kushoomi. Ubhuyo ubhwo indibhakabhwaghe abhandu bhaabho uChaala abhabhiikiile ngaanila.” ");
INSERT INTO ndh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bhwo abhamanyili abhanine kalongo (10) bhala bhaapulika isho, bhakabhakalalila abhanamundu bhabhili bhala. ");
INSERT INTO ndh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Po uYeesu akabhiitisha bhooshi pamupeene, akabhabhuula akati, “Mumeenye ukuti pa chiisu panu, bhala bhaabho bhalongoshi, bhakubhalaghila abhandu bhaabho ku maka, soona bhakubhabhombesha ngaani abhandu abho. ");
INSERT INTO ndh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Loole manye shibhange ulwo kukwinyu. Umundu ghweshi yuuyo akulonda ukubha ghwi songo pakati papiinyu, akulondighwa abhe mubhombi ghwinyu. ");
INSERT INTO ndh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Soona, umundu ghweshi yuuyo akulonda ukubha ghwa pamwanya pakati papiinyu, abhange mutumwa ghwinyu. ");
INSERT INTO ndh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Isa muumwo uMwana ughwa Mundu atakiisa ukuti abhandu bhamubhombelaghe, loole akiisa ukuti abhabhombelaghe abhandu nu kubhufumya ubhwumi bhwake ukuti abhapoke abhandu abhingi.” ");
INSERT INTO ndh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","UYeesu na bhamanyili bhaake bhakafika mu kaaya akakulu aka Yeeliko. Po bhakatiila mu kaaya kala ni chilundilo ichikulu icha bhandu chikamukongagha. ");
INSERT INTO ndh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Abhafwamaaso bhamu bhabhili bhakiikala kulubhafu ku sila yiiyo uYeesu akaghendagha. Po bhwo bhaapulika ukuti ghwi Yeesu akughenda, bhakiitisha ku ishu ilya pamwanya bhakati, “Ghwe Malafyale, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, tukusuuma tupelele ichisa!” ");
INSERT INTO ndh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ichilundilo icha bhandu bhala chikabhakemela ukuti bhasumbe, loole abheene bhakeendelelagha ukwitisha bhakati, “Ghwe Malafyale, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, tupelele ichisa!” ");
INSERT INTO ndh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","UYeesu akiima, akabhiitisha nu kubhabhuusha akati, “Kali, mukulonda imbabhombele kooni?” ");
INSERT INTO ndh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Po abhafwamaaso bhala bhakamwamula bhakati, “Ghwe Malafyale, tukulonda ughaposhe amaaso ghiitu ukuti ghateshange.” ");
INSERT INTO ndh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Po uYeesu akabhapelela ichisa, akabheeghelesha amaaso ghaabho. Nakalinga, amaaso ghaabho ghala ghakapola nu kwanda ukutesha, pabhumalilo, bhakamukonga uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","UYeesu na bhamanyili bhaake bhakapalamila mu kaaya aka Yelusaleemu, bhakafika mu kaaya aka Bheetifaaghe ku kaghamba aka Mishunguti. Po uYeesu akabhatuma abhamanyili bhaake bhabhili ");
INSERT INTO ndh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akabhabhuula akati, “Bhuuka mu kaaya kala kaako kali mundaashi mumwinyu, bhwo mwingila, nakalinga indimuyibhone imbunda ni nyaana yaake shipinyiighwe. Po mushaabhule, mwise nasho kukwangu. ");
INSERT INTO ndh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Linga umundu yumo akubhabhuusha isha mbunda isho, mwise mumwamulaghe mutingi, ‘UMalafyale akushilonda,’ ghwepe indiabhiitikishe ukwisa nasho.” ");
INSERT INTO ndh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ishi shooshi shikabhombighwa ulwo ukuti libhombighwe ishu lila liilyo likayughighwa nu musololi uSakaliiya ukuti, ");
INSERT INTO ndh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bhabhuule abhandu abha mu kaaya aka Siyooni ukuti, ‘Tesha, uMalafyale ghwinyu akwisa kukwinyu, mwoloolo, akwisa bhwo iitoghite pa mbunda. Soona, imbunda iyo nyaanaashe.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Po abhamanyili bhala bhakabhuuka nu kubhomba isa muumwo uYeesu akabhalaghilila. ");
INSERT INTO ndh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Po bhwo bhiisa kwa Yeesu ni mbunda yila pamupeene ni nyaana yaake, bhakaalisha imyenda yaabho yimo pamwanya pa mbunda, po uYeesu akiikala pamwanya. ");
INSERT INTO ndh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ichilundilo ichikulu leka icha bhandu chikaalisha imyenda yaabho mu sila na bhanine bhakatema utusamba utwa makokwe nu kwalisha mu sila. ");
INSERT INTO ndh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abhandu bhala bhaabho bhakatangila kundaashi na bhaabho bhakakongagha kunyuma kwa Yeesu, bhakayugha ku ishu ilya pamwanya bhakati, “Apaalighwange uChaala ku nongwa iya mwana yuuyo akufuma mu chikolo icha malafyale uNdaabhiti! Asayighwange yuuyo akwisa mu ngamu iya Malafyale! Apaalighwange uChaala kumwanya!” ");
INSERT INTO ndh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bhwo uYeesu iingila mu kaaya aka Yelusaleemu, akaaya kooshi kakafulungana leka. Abhandu bhakaanda ukubhuusania bheene-bheene bhakatingi, “Kali, ghwini uyu?” ");
INSERT INTO ndh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Abhandu bhooshi bhala bhakaamula bhakati, “Uyu ghwi Yeesu, musololi yula ughwa mu kaaya aka Naasaleeti, mu chiisu icha Ghalilaayi.” ");
INSERT INTO ndh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Po uYeesu akiingila mu lupaso ulwa Nyumba iya Chaala. Bhwo iingila, akabhaagha nu kubhakiisha bhooshi bhaabho bhakaghulishanga nu kughula utundu mu lupaso ulwa Nyumba iya Chaala. Akashipindulania imeesa isha bhandu bhaabho bhakafunjagha indalama nu kupindulania ifitengu ifya bhandu bhaabho bhakaghulishanga ingunda. ");
INSERT INTO ndh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","UYeesu akabhabhuula akati, “Shisimbiighwe mu Masimbo aMeelu, uChaala akuti, ‘Inyumba yangu indiyikabhe nyumba iya nyipuuto.’ Loole umwe muyibhiikite ukubha mbako iya bhapoka ifya bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Po bhwo uYeesu ali mu lupaso ulwa Nyumba iya Chaala, abhafwamaaso na bhochikwefu bhakiisa kukwake, ghwepe akabhaposha. ");
INSERT INTO ndh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Loole bhwo abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose bhaafibhona ifyika ifya kuswighisha fiifyo uYeesu akafibhomba, soona bhwo bhaapulika abhaana bhakuyugha ku ishu ilya pamwanya mu lupaso ulwa Nyumba iya Chaala bhakuti, “Apaalighwange yuuyo akufuma mu chikolo icha malafyale uNdaabhiti,” bhakakalala leka. ");
INSERT INTO ndh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhakamubhuusha uYeesu bhakati, “Kali, kupulika muumwo abhaana abha bhakuyughila?” UYeesu akabhaamula akati, “Ingupulika. Kali, mutabhelengite amashu agha ghasimbiighwe mu Masimbo aMeelu ukuti, ‘Mu mashu agha bhaana abhakeke na mu gha bhafyele, mwo muumwo utendekeshiishe imbaalo’?” ");
INSERT INTO ndh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","UYeesu akabhaleka abhandu bhala, akabhuuka pakughona mu kaaya aka Bheetaniya. ");
INSERT INTO ndh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bhwo uYeesu akughaluka ku Yelusaleemu pangeelo, isala yikamubhabha. ");
INSERT INTO ndh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Po akalibhona ikokwe ilya mukuyu limo kulubhafu ku sila, akapalamila papiipi, akaagha litali ni seke naashimo, loole lili na maani gheene. Po akalibhuula ikokwe lila akati, “Ghwe likokwe ughwe, ukwandila umuusughu ukufika pabhumalilo, manye ghwelaghe soona iseke!” Nakalinga, ikokwe lila likuuma lyoshi. ");
INSERT INTO ndh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bhwo abhamanyili abha Yeesu bhaashibhona isho, bhakaswigha leka, bhakamubhuusha bhakati, “Kali, shili bhuleele ikokwe ili lyuma nakalinga?” ");
INSERT INTO ndh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","UYeesu akabhaamula akati, “Nalooli ingubhabhuula, linga muli nu lwitiko chishita kwilaamwa, nuumwe mubhaghiile ukushibhomba isa shiisho shaabhombighwa ku ikokwe ili. Soona mutaamukabhombe ishi sheeneeshe, loole linga mwakabhuula akaghamba aka ukuti, ‘Ipuka uye ghwiponie mu nyanja,’ shoope indishikabhombighwe. ");
INSERT INTO ndh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Linga muli nu lwitiko, shooshi shiisho indimusuumaghe kwa Chaala bhwo mukwipuuta, indimupokeelaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","UYeesu akiingila soona mu lupaso ulwa Nyumba iya Chaala. Po bhwo ali pakumanyisha, abhosongo abha bhapuuti na bhosongo abha Bhayuuta bhakabhuuka pakumubhuusha bhakati, “Kali, ishi shiisho kushibhomba, kushibhomba ku maka agha ghwini? Kali, ghwini yuuyo akupiile amaka agho?” ");
INSERT INTO ndh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","UYeesu akabhaamula akati, “Nuune indiimbabhuushe ishu limo. Po linga mwanyaamula ilyo, nuune indiimbabhuule ukuti ingubhomba shooshi isho ku maka agha ghwini. ");
INSERT INTO ndh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kali, amaka agha Yoohani agha kwosha abhandu ghakafuma kuughu? Kali, ghakafuma kwa Chaala pamu ghakafuma ku bhandu?” Po bhakayughisania bheene-bheene bhakati, “Linga twamwamula ukuti ghakafuma kwa Chaala, indiatubhuushe ukuti, ‘Po kali, kooni mutakamwitikagha?’ ");
INSERT INTO ndh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Soona linga twamwamula ukuti ghakafuma ku bhandu, tukwoghopa ichilundilo icha bhandu ichi. Paapo bhooshi bhali nu bhwanalooli ukuti uYoohani akabha musololi ughwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Po bhakamwamula bhakati, “Tutameenye kuukwo amaka agho ghakafuma.” Ghwepe uYeesu akabhabhuula akati, “Nuune indakubhabhuula ukuti ingubhomba shooshi ishi ku maka agha ghwini.” ");
INSERT INTO ndh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","UYeesu akayugha soona akati, “Kali, umwe mukutesha bhuleele isha chifwanikisho ichi? Akabhaakwo umundu yumo yuuyo akabha na bhaana abhaliisha bhabhili. Akabhuuka ku mwana ughwa bhwandilo, akamubhuula akati, ‘Ghwe mwana ghwangu, bhuuka pakubhomba imbombo mu mughunda ghwangu umuusughu.’ ");
INSERT INTO ndh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Umwana yula akamwamula akati, ‘Indakubhuuka.’ Loole pakataashi akasanusha inyinongʼono shaake, akabhuuka pakubhomba. ");
INSERT INTO ndh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Po ughwise yula akabhuuka ku mwana ghwake ughwa bhubhili nu kumubhuula isa umunine yula. Ghwepe akamwamula akati, ‘Indiimbuuke taata.’ Loole atakabhuuka. ");
INSERT INTO ndh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kali, mu bhabhili bhala, ghwini yuuyo akabhomba isa muumwo ughwise akalondelagha?” Abhosongo abha bhapuuti na bhosongo abha Bhayuuta bhala bhakamwamula bhakati, “Yula ughwa bhwandilo.” Po uYeesu akabhabhuula akati, “Nalooli ingubhabhuula, abhasongesha songo na bhomalaya indibhakabhatangile ukwingila ku chitangalala icha Chaala. ");
INSERT INTO ndh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Paapo uYoohani akiisa kukwinyu ukuti abhalangishe isila iya bhugholofu, nuumwe mutakamwitika. Loole abhasongesha songo na bhomalaya bhakamwitika. Poope umwe bhwo mwashibhona shooshi isho, mutakiilaata ku mbiibhi shiinyu nu kumwitika.” ");
INSERT INTO ndh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","UYeesu akeendelela ukuyugha akati, “Pulikishanga ichifwanikisho ichinine. Akabhaapo umulimi yumo yuuyo akalima umughunda ghwake nu kubhyala imisabhibhu. Akashunguusha ulubhagha, akakumba pakati ubhwina ubhwa kukamila imisabhibhu, soona akasenga akasonje aka kwima pamwanya abhalindilili. Pabhumalilo, akabhabhiika abhalimi mu mughunda ghula ukuti linga bhaaya bhiinula iseke bhakayabhane. Po akachuula. ");
INSERT INTO ndh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Bhwo kaafika akabhalilo aka kwinula, akabhatuma abhabhombi bhaake ku bhalimi bhala ukuti bhaye bhamweghele iseke shiisho shikabha shaake. ");
INSERT INTO ndh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Loole abhalimi bhala bhakabhakola abhabhombi bhala, yumo bhakamukoma, umunine bhakamughogha nu munine bhakamukoma na mayondo. ");
INSERT INTO ndh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Umundu yula akabhatuma soona abhabhombi abhanine bhaabho bhakabha bhingi ukukinda bhaabho akabhatuma kubhwandilo. Abhalimi bhala bhakabhabhombela akabhiibhi abhabhombi bhala isa muumwo bhakabhabhombela abha bhwandilo. ");
INSERT INTO ndh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pabhumalilo, akamutuma umwana ghwake akati, ‘Uyu mwana ghwangu, umwene indibhamughindike.’ ");
INSERT INTO ndh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Loole bhwo abhalimi bhala bhaamubhona umwana yula, bhakayughisania bheene-bheene bhakati, ‘Yula, ghwe yuuyo indiakiingile ichilingo pa bhuyo ubhwa ghwise. Isagha tumughoghe ukuti ichilingo chaake chibhe chiitu.’ ");
INSERT INTO ndh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Po bhakamukola, bhakamufumya kuuse ku mughunda, bhakamughogha. ");
INSERT INTO ndh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Po linga umwene mughunda yula akuya kughaluka, kali, indiakabhombe kooni ku bhalimi bhala?” ");
INSERT INTO ndh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Abheene bhakamwamula bhakati, “Indiakabhapyute abhabhiibhi bhala, soona umughunda ghwake ghula indiakabhape abhalimi abhanine bhaabho indibhakamuhombe iseke shiisho shaake ku kabhalilo kaake.” ");
INSERT INTO ndh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Po uYeesu akabhabhuusha soona akati, “Kali, mutabhelengite shiisho shisimbiighwe mu Masimbo aMeelu? Shisimbiighwe ukuti, ‘Iyondo liilyo abhasenga nyumba bhakalikaana, lyo liilyo lyabha liyondo ikulu ilya kukola pa nguto iya lwalilo ulwa nyumba. UMalafyale uChaala ghwe yuuyo alibhombite ilyo, lyope lya kuswighisha kukwitu.’ ");
INSERT INTO ndh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ku nongwa iyi, ingubhabhuula ukuti uChaala indiakachitiishe ichitangalala chaake kukwinyu nu kufipa ifyisu ifinine fiifyo indifikapaape iseke shaake. ");
INSERT INTO ndh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Po umundu ghweshi yuuyo aaya aaghwila pi iyondo ilyo, indiakaposongane. Soona, ghweshi yuuyo indilikamughwile, indilikamutiisanie-tiisanie.” ");
INSERT INTO ndh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bhwo aBhafalisaayi na bhosongo abha bhapuuti bhaapulika ififwanikisho ifya Yeesu, bhakamanya ukuti fikubhayugha bho bhaabho. ");
INSERT INTO ndh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Po bhakalonda isila iya kumukola, loole bhakooghopa ichilundilo icha bhandu paapo abheene bhakamumanya uYeesu ukubha musololi. ");
INSERT INTO ndh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","UYeesu akabhamanyisha soona aBhafalisaayi na bhosongo abha bhapuuti mu fifwanikisho ifinine akati, ");
INSERT INTO ndh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ichitangalala icha kumwanya chigheliile nu malafyale yumo yuuyo akatendekesha ubhweghi ubhwa mwana ghwake. ");
INSERT INTO ndh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Umalafyale yula akabhatuma abhabhombi bhaake pakubhiitisha bhaabho akabhapaalila ukuti bhiise ku bhweghi, loole abheene bhakakaana ukwisa. ");
INSERT INTO ndh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Po akabhatuma soona abhabhombi abhanine, akabhabhuula akati, ‘Bhuuka mubhabhuule bhala bhaabho ingabhapaalila ukuti, “Indendekeshiishe ifindu fyoshi ifya bhweghi. Naaghogha ingʼombe shangu shiisho sheelite leka. Isagha ku bhweghi.” ’ ");
INSERT INTO ndh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Loole abheene bhatakasaaghilaakwo. Bhakabhuuka ku mbombo shaabho, yumo akabhuuka ku mughunda ghwake, umunine pakuchulusha. ");
INSERT INTO ndh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Abhanine bhakabhakola abhabhombi bhaake bhala, bhakabhakoma leka nu kubhaghogha. ");
INSERT INTO ndh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Po bhwo umalafyale yula aapulika shiisho shaabhombighwa ku bhabhombi bhaake, akakalala leka. Akabhatuma abhashikali bhaake bhakaya bhaabhaghogha abhaghoghi bhala nu kupembania akaaya kaabho. ");
INSERT INTO ndh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Po umalafyale yula akabhabhuula abhabhombi bhaake akati, ‘Ifindu ifya bhweghi fitendekeshiighwe, loole bhala bhaabho ingabhapaalila bhatakabha bhabhaghile ukwisa. ");
INSERT INTO ndh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Po ulu bhuuka mu sila indekaania, mubhabhuule bhooshi bhaabho mwakomaana nabho ukuti bhiise ku bhweghi.’ ");
INSERT INTO ndh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Abhabhombi bhala bhakabhuuka mu sila indekaania. Bhakiisa na bhandu bhooshi bhaabho bhakakomaanagha nabho, abhabhiibhi na bhiisa. Po abhaheesha bhakiisula mu nyumba iya bhweghi. ");
INSERT INTO ndh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Loole bhwo umalafyale yula iingila mu nyumba yila ukuti abhateshe abhaheesha, akamubhona mula umundu yumo yuuyo atakafwala imyenda iya bhweghi. ");
INSERT INTO ndh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Akamubhuusha akati, ‘Ghwe mumanyani ughwe, kali, ghwingiile bhuleele muno bhwo utafwalite imyenda iya pa bhweghi?’ Loole umundu yula shikamwima amiishi. ");
INSERT INTO ndh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Po umalafyale yula akabhabhuula abhabhombi bhaake akati, ‘Mupinye umundu uyu utulundi nu tukono nu kumutaagha kuuse ku chiisi, kuukwo indialilaghe nu kushesheetusha amiino ku nongwa iya bhubhafu ubhukali.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Po uYeesu akamaliisha ukuyugha akati, “UChaala akubhiitisha abhandu abhingi ukwingila ku chitangalala chaake, loole bhanandi bhaabho abhasalite ukwingila.” ");
INSERT INTO ndh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Po aBhafalisaayi bhakatiilaapo pala, bhakabhuuka pakuyughisania muumwo bhabhaghiile ukumutegha uYeesu ku mashu ghaake. ");
INSERT INTO ndh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Po bhakabhatuma kwa Yeesu abhamanyili bhaabho pamupeene na bhakongi abha malafyale uHelooti uAntipa, bhakabhuuka, bhakamubhuusha bhakati, “Ghwe Mumanyishi, tumeenye ukuti ughwe ghwe mundu ghwa nalooli nu kuti kumanyisha isila iya Chaala mu bhwanalooli. Soona utakumwoghopa umundu naayumo yuuyo ali ni mbombo iya pamwanya. ");
INSERT INTO ndh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Po tubhuule muumwo kushibhonela. Kali, indaghilo isha Moose shikutwitikisha ukusonga isongo kwa Kayisaali pamu nashiku?” ");
INSERT INTO ndh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Loole uYeesu akayimanya inyango yaabho imbiibhi, akabhaamula, akabhabhuusha akati, “Mwe bhongubhisania umwe, kali, kooni mukuungela? ");
INSERT INTO ndh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Indangishe isalabhasha yiiyo mukusongagha isongo.” Bhoope bhakiisa kukwake ni salabhasha iya ndinaali yimo. ");
INSERT INTO ndh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Po uYeesu akabhabhuusha akati, “Kali, chaani ichifwani ichi nu bhusimbe ubhu pa salabhasha iyi?” ");
INSERT INTO ndh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Abheene bhakamwamula bhakati, “Ichifwani nu bhusimbe, fya malafyale uKayisaali.” UYeesu akabhabhuula akati, “Po mupange uKayisaali fiifyo fya Kayisaali, soona mupange uChaala fiifyo fya Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bhwo bhaapulika ukwamula ukwa Yeesu, bhakaswigha leka. Po bhakamuleka pala pala, bhakatiilaapo. ");
INSERT INTO ndh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pi ishiku lila lila, aBhasandukaayi bhamu bhakabhuuka kwa Yeesu. ABhasandukaayi bhakiitikagha ukuti uChaala ataaakabhashuushe abhandu. Po bhamu bhakamubhuula uYeesu bhakati, ");
INSERT INTO ndh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ghwe Mumanyishi, uMoose akatulaghila mu ndaghilo ukuti linga umundu aafwa nu kumuleka umukashi chishita kupaapa umwana, shikwitikishighwa ughwamwabho ukumwingila ichilingo umufwile uyo ukuti amupaapile umwana ughwa kwendelesha ingamu iya yuuyo afwile. ");
INSERT INTO ndh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mu kabhalilo kamu, pakabhaapo abhanamundu bhahaano na bhabhili (7). Ughwa bhwandilo akeegha umukolo nu kufwa chishita kupaapa umwana. Po ughwamwabho ughwa bhubhili akamwingila ichilingo umukolo umufwile yula. ");
INSERT INTO ndh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ughwamwabho yula ghwepe akafwa chishita kupaapa umwana. Shikabhombighwa bhubhuubhwo na ku ghwa bhutatu ukufika ku ghwa bhuhaano na bhabhili, bhooshi bhakafwa chishita kupaapa umwana. ");
INSERT INTO ndh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Po pabhumalilo umukolo umufwile yula ghwepe akafwa. ");
INSERT INTO ndh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Po tubhuule, kali, pi ishiku lila liilyo uChaala indiakabhashuushange abhafwe bhooshi, umukolo yula indiakabhe mukashi ghwani? Paapo akeeghighwa na bhaliisha bhooshi bhahaano na bhabhili!” ");
INSERT INTO ndh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","UYeesu akabhaamula akati, “Mukusobha leka ku nongwa iya kuti mutashimeenye shiisho shisimbiighwe mu Masimbo aMeelu, soona mutaghameenye amaka agha Chaala muumwo ghabheeliile. ");
INSERT INTO ndh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Paapo bhwo abhafwe bhaashuuka, indibhakabhange ungati bhandumi abha Chaala bhaabho bhali kumwanya, bhaabho bhatakwegha pamu ukweghighwa. ");
INSERT INTO ndh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Loole ku sha kushuuka abhafwe, kali, mutabhelengite mu Masimbo aMeelu muumwo uChaala akabhabhuulila? Paapo akayugha akati, ");
INSERT INTO ndh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Une nee Chaala yuuyo uAbhulahamu, uIsiyaka nu Yaakobhu bhakaanyiipuutagha.’ Po abhandu bhaabho bhafwe bhatakumwipuuta uChaala, loole abhandu bhaabho bhuumi bho bhaabho bhakumwipuuta!” ");
INSERT INTO ndh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bhwo ifilundilo ifya bhandu bhaapulika isho, bhakaswigha leka ku fimanyisho fyake. ");
INSERT INTO ndh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bhwo aBhafalisaayi bhaapulika ukuti uYeesu aabhapoota aBhasandukaayi mu njugha, bhakabhungaana pamupeene nu kubhuuka kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yumo mu Bhafalisaayi bhala yuuyo akabha mumanyishi ughwa ndaghilo isha Moose, akaghela ukumutegha uYeesu, akamubhuusha akati, ");
INSERT INTO ndh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ghwe Mumanyishi, kali, ululaghilo luliku luulwo lukulu ukukinda indaghilo inine shooshi?” ");
INSERT INTO ndh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","UYeesu akamwamula akati, “Mughanaghe uMalafyale uChaala ghwako ku ndumbula yaako yooshi, ku nyinongʼono shaako shooshi na ku mahala ghaako ghooshi. ");
INSERT INTO ndh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ululaghilo ulu lwo luulwo lukulu ukukinda indaghilo inine shooshi, soona lwo luulwo lwa bhwandilo ukuti utwe tukongaghe. ");
INSERT INTO ndh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ululaghilo ulwa bhubhili luulwo lugheliile nu lwa bhwandilo, lwope lukuti, ‘Mughanaghe umunyiinyu isa muumwo ghwiyiighanite yughweghwe.’ ");
INSERT INTO ndh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Indaghilo shooshi isha Moose ni fimanyisho ifya bhasololi fikusubhaalila indaghilo shibhili ishi.” ");
INSERT INTO ndh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bhwo aBhafalisaayi bhala bhakaali bhabhungaanite pamupeene pala, uYeesu akabhabhuusha akati, ");
INSERT INTO ndh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kali, mukwinongʼona bhuleele isha Mesiiya yuuyo Mupoki? Kali, mwana ghwani?” Bhakamwamula bhakati, “Mwana ghwa malafyale uNdaabhiti.” ");
INSERT INTO ndh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","UYeesu akabhabhuusha akati, “Linga isho sha nalooli, kali, nongwa yiki yiiyo uNdaabhiti bhwo akulongoshighwa nu Mbepo ughwa Chaala, akamwitisha uKilisiti ukuti Malafyale? Paapo uNdaabhiti akati, ");
INSERT INTO ndh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘UMalafyale uChaala akamubhuula uMalafyale ghwangu akati, “Ikala ku kakono kangu aka kumwisa, ukufika paapo indiingabhabhiike abhalughu bhaako paase pa tulundi twako.” ’ ");
INSERT INTO ndh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Linga uNdaabhiti akamwitisha uKilisiti ukuti Malafyale, po kali, uKilisiti abhaghiile bhuleele ukubha mwana ghwake?” ");
INSERT INTO ndh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Naayumo umundu yuuyo akamwamula limo uYeesu. Soona ukufuma akabhalilo kala naayumo umundu yuuyo akasulwa ukumubhuusha uYeesu amabhuusho amanine. ");
INSERT INTO ndh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Po uYeesu akafibhuula ifilundilo ifya bhandu fila na bhamanyili bhaake akati, ");
INSERT INTO ndh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abhamanyishi abha ndaghilo isha Moose na Bhafalisaayi bhali na maka agha kubhamanyisha abhandu indaghilo isha Moose. ");
INSERT INTO ndh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Po shikolaghe nu kushibhombela shooshi shiisho bhakubhabhuula. Loole manye mushikongaghe imbombo shaabho, paapo abheene bhatakubhomba nu kushikonga shooshi shiisho bhakumanyisha. ");
INSERT INTO ndh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Abheene bhakupinya imishigho imingʼwamu nu kubhapimbisha abhandu mu fipungo na mu mitu yaabho, loole bhatakulonda ukugholosha nalinga kaana aka kakono kaabho ukuti bhayipimbe. ");
INSERT INTO ndh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Soona bhakubhomba shooshi isho ukuti bhiilangishe ku bhandu. Paapo bhakufwalagha pa cheeni akabhokoshi aka ndaghilo na mu tukono ifibhali ifya likwela ifikulu ukukinda abhanine. Soona bhakwongelesha ifipeto ifya myenda yaabho iya lwipuuto ukukinda abhanine. ");
INSERT INTO ndh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pi ishiku ilya lusekelo, bhiighanite ukwikala pa fitengu ifya bhaheesha abhaghindikighwa. Soona bhiighanite ukwikala pa fitengu ifya lughindiko ifya mundaashi mu masinaghoghi ghaabho. ");
INSERT INTO ndh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Soona bhiighanite leka ukuti abhandu bhabhalamukaghe ku lughindiko mu minaalo nu kuti bhabhiitishange bhatingi, ‘Ghwe Mumanyishi.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Soona akayugha akati, “Loole umwe manye mwitikaghe linga bhakubhiitisha bhakuti, ‘Ghwe Mumanyishi!’ Paapo muli nu mumanyishi yumoyweneeshe nuumwe mweshi muli bhakongi bhangu. ");
INSERT INTO ndh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Soona manye mumwitishange umundu naayumo mutingi, ‘Ghwe taata’ pa chiisu panu, paapo muli nu Taata ghwinyu yumoyweneeshe yuuyo ali kumwanya. ");
INSERT INTO ndh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Soona manye mwitikaghe linga abhandu bhakubhiitisha umwe bhakuti, ‘Mwe bhalongoshi,’ paapo muli nu Mulongoshi yumoyweneeshe yuuyo ghwi Mesiiya. ");
INSERT INTO ndh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Umundu ghweshi yuuyo akulonda ukubha mulongoshi ghwinyu, abhange ghwa kwiyiisha nu kubhabhombela abhanine. ");
INSERT INTO ndh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Paapo umundu ghweshi yuuyo akwikwesha mwene ukubha ghwi songo, uChaala indiakamwishe paase. Loole umundu ghweshi yuuyo akwiyiisha, uChaala indiakamukweshe ukubha ghwi songo.” ");
INSERT INTO ndh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","UYeesu akeendelela ukuyugha akati, “Lwinyu mwe bhamanyishi abha ndaghilo isha Moose na mwe Bhafalisaayi, mwe bhongubhisania umwe! Paapo mukubhashighila abhandu ukwingila ku chitangalala icha kumwanya. Ku nongwa iyo umwe yumwemwe mutakwingilaamwo, soona mukubhashighila abhandu bhooshi bhaabho bhakulonda ukwingila.  ");
INSERT INTO ndh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Lwinyu mwe bhamanyishi abha ndaghilo isha Moose na mwe Bhafalisaayi, mwe bhongubhisania umwe! Paapo mukwipuutagha kwa Chaala inyipuuto indali leka ukuti mwilangishe ku bhandu, loole kuno mukupoka ifyuma ni nyumba isha bhakolo abhafwile. Pi ishiku ilya bhulongi, uChaala indiakabhape ulufundo ulukulu. ");
INSERT INTO ndh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Lwinyu mwe bhamanyishi abha ndaghilo isha Moose na mwe Bhafalisaayi, mwe bhongubhisania umwe! Paapo mukushunguulila leka mu chiisu ichikafu nu kulobhoka usumbi ukuti mumupindule umundu yuuyo ataa Muyuuta ukubha Muyuuta. Loole linga mwamupindula umundu uyo, mukumupela ukubha mubhomba mbiibhi ukubhakinda umwe. ");
INSERT INTO ndh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Lwinyu mwe bhalongoshi mwe muli isa abhafwamaaso umwe! Paapo mukubhamanyisha abhandu mukuti, ‘Linga umundu akuloolika ku Nyumba iya Chaala, shitaa mbala. Loole linga akuloolika ku sahabhu yiiyo yili mu Nyumba iya Chaala, umundu uyu akulondighwa abhombe isa muumwo aloolikite.’ ");
INSERT INTO ndh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwe muli isa abhafwamaaso abhakonyofu umwe! Kali, kooni kaako ka pamwanya ukukinda akanine? Kali, sahabhu iyo yiiyo yili mu Nyumba iya Chaala, pamu Nyumba ya Chaala yiiyo yikuyipela isahabhu ukubha nyeelu? ");
INSERT INTO ndh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Soona mukubhamanyisha abhandu mukuti, ‘Linga umundu akuloolika ku chighemo icha mu Nyumba iya Chaala, isho shitaa mbala. Loole linga akuloolika ku fyakupemba fiifyo fili pa chighemo, umundu uyo akulondighwa abhombe isa muumwo aloolikite.’ ");
INSERT INTO ndh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwe muli isa abhafwamaaso umwe! Kali, kooni kaako ka pamwanya ukukinda akanine? Kali, fyakupemba ifyo pamu chighemo chila chiicho chikufipela ifyakupemba ukubha fyelu? ");
INSERT INTO ndh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Po linga umundu akuloolika ku chighemo icha mu Nyumba iya Chaala, akuloolika na ku findu fyoshi fiifyo fili pamwanya pa chighemo. ");
INSERT INTO ndh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Umundu ghweshi yuuyo akuloolika ku Nyumba iya Chaala, akuloolika ku Nyumba iyo na kwa Chaala yuuyo akwikala mu Nyumba iyo. ");
INSERT INTO ndh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ghwepe umundu yuuyo akuloolika kumwanya, akuloolika ku chitengu icha Chaala na kwa Chaala yuuyo akwikala pa chitengu icho. ");
INSERT INTO ndh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Lwinyu mwe bhamanyishi abha ndaghilo isha Moose na mwe Bhafalisaayi, mwe bhongubhisania umwe! Paapo mukufumya ilongo kwa Chaala utundu utunandi isa inyungu, imbisaali nu bhuusambiya. Loole mukukaana ukushibhomba imbombo ingulu isa ukubhomba inyiisa, ukubha ni chisa nu kubha nu lwitiko. Po mukulondighwa ukuti mushibhombaghe shooshi ingulu pamupeene ni nandi. ");
INSERT INTO ndh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwe bhalongoshi mwe muli ungati bhafwamaaso umwe! Paapo mukusuuya imbwele mu fyakungʼwa fyinyu, loole mukumila ingamila! ");
INSERT INTO ndh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Lwinyu mwe bhamanyishi abha ndaghilo isha Moose na mwe Bhafalisaayi, mwe bhongubhisania umwe! Paapo muli ungati bhandu bhaabho bhakusuka ichikombe ni saghani kuuse kwene, loole mukati mwiswile ubhunyali ubhwa luko nu luko. Bhubhuubhwo, umwe mukwilangisha ku bhandu ukubha bhiisa, loole mu ndumbula shiinyu mwiswile ubhubhiibhi ubhwa luko nu luko. ");
INSERT INTO ndh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mwe Bhafalisaayi, mwe muli isa abhafwamaaso umwe! Pinduka taashi ukufuma ku mbiibhi shiisho shili mu ndumbula shiinyu isa ukusuka ubhunyali bhuubhwo bhuli mukati mu chikombe na mu saghani. Po indimubhe bheelu isa muumwo ichikombe ni saghani fikubha fyelu linga ghwafisuka mukati. ");
INSERT INTO ndh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Lwinyu mwe bhamanyishi abha ndaghilo isha Moose na mwe Bhafalisaayi, mwe bhongubhisania umwe! Paapo muli isa amapumba ghaagho bhakushingula ipanya, ghaagho ghakubhoneka akiisa kuuse, loole mukati ghiiswile amafupa agha bhandu abhafwe nu bhunyali ubhwa luko nu luko. ");
INSERT INTO ndh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bhubhuubhwo, nuumwe kuuse mukubhoneka ku bhandu ukuti mukubhomba shiisho shibhaghiile pandaashi pa Chaala, loole ubhwanalooli bhwa kuti mukati mu ndumbula shiinyu mwiswile ubhwongubhisania nu kushita kukonga indaghilo. ");
INSERT INTO ndh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Lwinyu mwe bhamanyishi abha ndaghilo isha Moose na mwe Bhafalisaayi, mwe bhongubhisania umwe! Paapo mukusenga amapumba agha bhasololi abha Chaala nu kughalabhania akiisa amapumba agha bhagholofu. ");
INSERT INTO ndh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Po mukuyugha mukuti, ‘Linga utwe tukabhangaakwo ku tubhalilo tuutwo abhosekulu bhiitu bhakabha bhuumi, ngali tutakaafwana nabho ukubhaghogha abhasololi abha Chaala.’ ");
INSERT INTO ndh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ukuyugha ulwo, mukushimikisha ukuti nuumwe muli bhabhiibhi ungati bhosekulu bhiinyu bhala bhaabho bhakabhaghogha abhasololi abha Chaala! ");
INSERT INTO ndh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Po maliisha ubhubhiibhi bhula bhuubhwo abhosekulu bhiinyu bhakabhwandisha! ");
INSERT INTO ndh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mwe muli ungati njoka umwe na mwe muli isa abhaana abha njoka umwe! Kali, indimukapone bhuleele ubhulongi ubhwa Chaala linga abhataagha mu mulilo ughwa bhwila na bhwila ughwa Yehanamu? ");
INSERT INTO ndh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ku nongwa iyo indiimbatume kukwinyu abhasololi, abhandu abha mahala na bhamanyishi ukuti umwe mupinduke ukufuma ku mbiibhi shiinyu. Loole bhamu mu bhandu abho, indimukabhaghoghaghe nu kubhakomeela pa chikobhekano. Abhanine indimukabhakomaghe ni fikoti pa lukomaano lwinyu na bhanine indimukabhakongeshange ukufuma akaaya kamu ukufika akaaya akanine nu kubhafulasha. ");
INSERT INTO ndh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yo yiiyo nongwa iyi uChaala indiakabhalonge umwe ku nongwa iya kubhaghogha abhabhaghile bhooshi, ukwandila muumwo uKayini akamughogha uAabheli yuuyo atakabha ni nongwa naayimo ukufika ukughoghighwa ukwa Sakaliiya yuuyo akabha mwana ghwa Bhalakiiya. Abhosekulu bhiinyu bhakamughogha uSakaliiya pakati pa Nyumba iya Chaala ni chighemo. ");
INSERT INTO ndh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nalooli ingubhabhuula uChaala indiakabhalonge abhandu abha kabhalilo aka ku mbiibhi shooshi shiisho bhaashibhombite.” ");
INSERT INTO ndh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Po uYeesu akati, “Mwe bhandu abha mu Yelusaleemu umwe, mwe bhandu abha mu Yelusaleemu umwe! Mukubhaghogha abhasololi nu kubhakoma na mayondo abhandu bhala bhaabho uChaala abhatumite kukwinyu. Mu tubhalilo utwingi ingalondagha ukubhabhungaania umwe isa muumwo inguku yikubhungaanikisha utwana twake mu fipapande fyake, loole mutakalondagha! ");
INSERT INTO ndh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tesha, uChaala indiakabhaleke umwe nu kuyileka inyumba yiinyu ukubha chisaami. ");
INSERT INTO ndh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Paapo ingubhabhuula ukuti mutaamukaambone soona ukufika paapo indimukayughe ukuti, ‘Asayighwange yuuyo akwisa mu ngamu iya Malafyale uChaala!’ ” ");
INSERT INTO ndh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","UYeesu akatiila nu kufumaamwo mu lupaso ulwa Nyumba iya Chaala. Bhwo akughenda, abhamanyili bhaake bhakamwisila ukuti bhamulangishe ubhusengi ubhwa Nyumba iya Chaala ni nyumba inine shiisho shikayishunguulila. ");
INSERT INTO ndh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Loole uYeesu akabhabhuusha akati, “Kali, mukushibhona shooshi ishi? Nalooli ingubhabhuula, naalimo iyondo liilyo indilikashaale pamwanya pi inine. Loole amayondo ghooshi agho, indighakapongolighwe!” ");
INSERT INTO ndh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Po uYeesu akabhuuka pa kaghamba aka Mishunguti nu kwikala pala. Bhwo iikala, abhamanyili bhaake bhakabhuuka kukwake bhwo ali mwene, bhakamubhuusha bhakati, “Ghwe Mumanyishi, tubhuule, kali, indishikabhoneke liighi shooshi isho? Soona, kali, kooni kaako indikakatulangishe ukwisa kwako nu bhumalilo ubhwa chiisu?” ");
INSERT INTO ndh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","UYeesu akabhaamula akati, “Mubhange maaso, manye umundu naayumo abhashimbulaghe! ");
INSERT INTO ndh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Paapo indibhakiise abhandu abhingi nu kubhombela ingamu yangu, bhakatingi, ‘Une nee Mesiiya!’ Bhoope indibhakabhashimbulaghe abhandu abhingi. ");
INSERT INTO ndh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ku kabhalilo ako indimukapulikaghe inongwa isha bhwite nu kuyugha-yugha isha bhwite. Manye mukapaashange ku nongwa iya kuti isho shikulondighwa shibhoneke, loole ubhumalilo ubhwene bhukaali bhukwisa. ");
INSERT INTO ndh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ichiisu chimo indichikalwange ni chiisu ichinine nu bhunyafyale bhumo indibhukalwange nu bhunyafyale ubhunine. Isala nu tuyingiyingi indifikabhonekaghe mu fyisu ifyingi. ");
INSERT INTO ndh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Isho shooshi indishikabhe isa ubhwandilo ubhwa bhubhafu linga umukolo akupaapa. ");
INSERT INTO ndh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mu kabhalilo ako, abhandu abha fyisu fyoshi indibhakabhabhenge, indibhakabhakolaghe, indibhakabhafulashange nu kubhaghogha ku nongwa iya ngamu yangu. ");
INSERT INTO ndh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Po abhandu abhingi indibhakalekaghe ukuungonga une. Indibhakabhiikanaghe mu tukono utwa bhalughu nu kubhengana bheene-bheene. ");
INSERT INTO ndh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mu kabhalilo ako, indibhakabhonekaghe abhasololi abhingi abha bhumyashi nu kubhashimbula abhandu abhingi. ");
INSERT INTO ndh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Soona, ku nongwa iya kuti imbiibhi indishikabhe shaabhaala ngaani, abhandu abhingi indibhakaleke ukubhaghana abhanine. ");
INSERT INTO ndh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Loole umundu yuuyo indiakabhe mukifu ukufika pabhumalilo, ghwe yuuyo uChaala indiakamupoke. ");
INSERT INTO ndh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Soona, iNongwa iNyiisa isha chitangalala icha kumwanya indishikalumbililighwe ku chiisu chooshi ukuti bhubhe bhukeeti ku bhandu bhooshi. Po ku kabhalilo ako ubhumalilo ubhwa chiisu indibhukiisaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ku kabhalilo ako indimukachibhone ‘ichindu chiicho chikuywelula nu kukomania,’ chiimite Pabhuyo uBhwelu paapo chitakulondighwa ukubha. Ichindu icho cho chiicho chikayughighwa nu musololi uNdaniyeeli. (Umundu ghweshi yuuyo akubhelenga amashu agha, ashaaghaniange muumwo ghakulingaanikisha.) ");
INSERT INTO ndh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Po abhandu bhooshi bhaabho bhakwikala mu chiisu icha Yuteeya, bhakakindilaghe mu tughamba. ");
INSERT INTO ndh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ghwepe umundu yuuyo indiakabhe akwelite pa kasale pa nyumba, manye akiikaghe ukuti eeghe utundu twake. ");
INSERT INTO ndh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bhubhuubhwo, umundu ghweshi yuuyo indiakabhe ku mughunda, manye akaghalukaghe kunyuma pakwegha umwenda ghwake. ");
INSERT INTO ndh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lwabho abhakolo bhaabho indibhakabhe pa bhungʼwamu na bhaabho indibhakabhe bhakwongesha ku mashiku agho! ");
INSERT INTO ndh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Po ipuutagha kwa Chaala ukuti ukukinda kwinyu manye kukabhange ku kabhalilo akabhiibhi aka mbepo ingali pamu pi ishiku ilya Sabhati. ");
INSERT INTO ndh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Paapo akabhalilo ako, indikakabhe ni ndamyo ingulu ngaani shiisho shitabhonekite naalumo ukwandila muumwo uChaala akapelela ichiisu ukufika umuusughu. Soona, indamyo isho shitaashikabhoneke naalumo. ");
INSERT INTO ndh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Linga uChaala atakaghapungushanga amashiku agho, po ngali naayumo umundu yuuyo indiakapone. Loole ku nongwa iya bhasalighwa bhaake, uChaala indiakaghapungushe amashiku agho. ");
INSERT INTO ndh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Po mu kabhalilo ako, linga umundu akubhabhuula akuti, ‘Tesha, uMesiiya ali panu,’ pamu, ‘Ali kula,’ manye mukiitikaghe. ");
INSERT INTO ndh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Paapo indibhakiise abhandu bhaabho indibhakayughaghe ubhumyashi ukuti bhokilisiti nu kuti bhasololi. Indibhakabhombaghe ifyika ifikulu ifya kuswighisha ukuti bhabhashimbule abhasalighwa abha Chaala. ");
INSERT INTO ndh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mubhange maaso paapo naabhabhuula ngaanila inongwa isho bhwo shikaali ukubhoneka. ");
INSERT INTO ndh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Po linga abhandu bhakubhabhuula bhakuti, ‘Tesha, uMesiiya ali ku lungalangala kula!’ Manye mukabhuukaghe pakutesha. Pamu bhakubhabhuula bhakuti, ‘Tesha, ali mu nyumba muno!’ Manye mukabhiitikaghe. ");
INSERT INTO ndh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Paapo ukwisa ukwa Mwana ughwa Mundu indikukabhe kwa kunyomosha isa muumwo akalabhi kakumwekukila kuukwo isubha likufumila ukufika kuukwo likukilila. ");
INSERT INTO ndh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ukwisa kwangu indikukabhoneke pabhwelu ku ghweshi umundu isa muumwo linga umundu aabhabhona abhonangʼoma bhabhungaanite pamupeene, akumanya ukuti pabhuyo bhula pali nu mubhili umufwe.” ");
INSERT INTO ndh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nakalinga bhwo amashiku agha ndamyo agho ghaakinda, ‘UChaala indiakalisanushe isubha ukubha chiisi, umweshi ghutaaghukabhalaghe, soona ni ndoondwa shoope indishikaghwe paase ukufuma kumwanya. UChaala indiakatuyungaanie utundu twoshi utwa kumwanya.’ ");
INSERT INTO ndh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Mu kabhalilo ako ichilangisho icha Mwana ughwa Mundu indichikabhoneke kumwanya na bhandu abha fyisu fyoshi indibhakaande ukulila ku lutende. Abhandu bhooshi abho indibhakamubhone bhwo akwisa mu mabhingu bhwo ali na maka nu bhukulumba ubhukulu. ");
INSERT INTO ndh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Po indiakabhatume abhandumi bhaake bhwo bhakupuuta amalongi ukuti bhabhabhungaanie abhasalighwa bhaake bhooshi ukufuma mumbafu shooshi, ukufuma kubhumalilo bhumo ubhwa kumwanya ukufika kubhumalilo ubhunine.” ");
INSERT INTO ndh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","UYeesu akeendelela ukuyugha akati, “Manyilagha ukufuma ku ikokwe ilya mukuyu. Paapo linga utusamba twake twanda ukutulula amaani, po mukumanya ukuti akabhalilo aka fula kaapalamila. ");
INSERT INTO ndh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bhubhuubhwo, nuumwe linga mukushibhona shooshi isho shikubhombighwa, po mukamanye ukuti ukwisa kwake kuli papiipi. ");
INSERT INTO ndh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nalooli ingubhabhuula, imbaapo iyi yitaayikakinde bhwo ishi shooshi shitabhonekite. ");
INSERT INTO ndh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kumwanya ni chiisu indifikakinde, loole amashu ghangu indigheendelele ukubhaapo bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Loole ku sha lishiku lila na kabhalilo kala, naayumo umundu yuuyo ashimeenye, bhabhe bhandumi abha kumwanya pamu uMwana, loole uTaata uChaala mwene. ");
INSERT INTO ndh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Paapo ukwisa soona ukwa Mwana ughwa Mundu indikukabhe isa muumwo shikabheela ku mashiku agha Nooghwa. ");
INSERT INTO ndh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Paapo mu mashiku agha Nooghwa ghala bhwo ifula imbiibhi yikaali ukwisa, abhandu bhakalyanga nu kungʼwa, bhakeeghagha nu kweghighwa ukufika ishiku lila liilyo uNooghwa akiingila mu ngalabha. ");
INSERT INTO ndh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Abhandu abho bhatakamanya naakamu ukuti kooni indikakabhoneke ukufika paapo ifula imbiibhi yikiisa nu kubhaghogha bhooshi. Umwo mwo muumwo indishikabheele bhwo uMwana ughwa Mundu akwisa soona pa chiisu panu. ");
INSERT INTO ndh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mu kabhalilo ako abhandu bhabhili indibhakabhe mu mughunda, umwene indiakamweghe lubhilo yumo nu kumuleka umunine. ");
INSERT INTO ndh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Soona, bhoope abhakolo bhabhili indibhakashange pamupeene pa lwala, indiakamweghe lubhilo yumo nu kumuleka umunine. ");
INSERT INTO ndh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Po mubhange maaso paapo mutalimeenye ishiku ilyo liilyo uMalafyale ghwinyu indiakiise. ");
INSERT INTO ndh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Loole mushaaghaniange akiisa ukuti linga umwene nyumba akamanyagha akabhalilo kaako umwifi akwisila, po abhaghiile aghone maaso ukuti umwifi manye iise apongole inyumba nu kwibha utundu twake. ");
INSERT INTO ndh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ku nongwa iyi nuumwe itendekeshanga akabhalilo kooshi paapo uMwana ughwa Mundu indiakiise mu kabhalilo kaako mutaasubhaaliile.” ");
INSERT INTO ndh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","UYeesu akabhabhuusha abhamanyili bhaake akati, “Po kali, ghwini yuuyo mubhombi umusubhaalilighwa soona ghwa mahala yuuyo usongo ghwake amubhiikite ukubha mwimilili ughwa bhabhombi abhanine mu nyumba yaake ukuti abhapange ifindu ku kabhalilo kaako kakulondighwa? ");
INSERT INTO ndh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Musayighwa umubhombi uyo yuuyo linga usongo ghwake akughaluka kuukwo aachuuliile, akumwagha akubhomba shiisho akamulaghila ukuti abhombaghe. ");
INSERT INTO ndh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nalooli ingubhabhuula, usongo ghwake indiakamukweshe pa mbombo ukuti abhe mwimilili ughwa tundu twake twoshi tuutwo ali natwo. ");
INSERT INTO ndh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Loole linga umubhombi umubhiibhi uyo, iinongʼona mu ndumbula yaake akuti, ‘Usongo ghwangu indiakaabhe ukughaluka,’ ");
INSERT INTO ndh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","akwanda ukubhakoma abhabhombi abhanine, ukulya nu kungʼwa pamupeene na bhochingʼwelo. ");
INSERT INTO ndh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Po usongo ghwake indiakaghaluke pi ishiku na mu kabhalilo kaako umubhombi ghwake ataasubhaaliile. ");
INSERT INTO ndh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Po usongo uyo indiakamupe ulufundo ulukulu nu kumutaagha pabhuyo bhuubhwo abhongubhisania bhali. Pabhuyo apo po paapo abhandu abho indibhakalilaghe nu kushesheetusha amiino ku nongwa iya bhubhafu ubhukali.” ");
INSERT INTO ndh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Po uYeesu akabhabhuula abhamanyili bhaake ichifwanikisho ichinine akati, “Ku kabhalilo ako, ichitangalala icha kumwanya indichikaghelele nu lusekelo ulwa bhweghi, luulwo bhakabhaapo abhalindu kalongo bhaabho bhakeegha inyaale shaabho nu kubhuuka pakumupokeela yuuyo akwegha. ");
INSERT INTO ndh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Abhalindu bhahaano mu abho kalongo, bhakabha bha mahala, loole abhanine bhahaano bhakabha bhakonyofu. ");
INSERT INTO ndh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abhakonyofu bhahaano bhala, bhakeegha inyaale shaabho chishita kwegha na mafuta amanine agha kwongelesha. ");
INSERT INTO ndh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Loole abha mahala bhahaano bhala bhakeegha inyaale shaabho pamupeene na mafuta mu supa agha kwongelesha. ");
INSERT INTO ndh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bhwo yuuyo akwegha aakaabha ukwisa, utulo tukabhakola abhalindu bhala bhooshi nu kupitila. ");
INSERT INTO ndh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Loole pabhushiku pakati, abhandu bhakiitisha bhakati, ‘Tesha, yuuyo akwegha akwisa! Fumagha, tubhuuke pakumupokeela.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nakalinga, abhalindu bhala bhooshi bhakalamusha nu kushitendekesha inyaale shaabho. ");
INSERT INTO ndh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Abhalindu abhakonyofu bhahaano bhala bhakabhabhuula abha mahala bhakati, ‘Tukusuuma mutwafwe amafuta ghamu ku nongwa iya kuti inyaale shiitu shikushima.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Loole abha mahala bhala bhakabhaamula bhakati, ‘Nashiku! Tutabhaghiile ukubhaafwa, paapo amafuta ghaagho tuli nagho, ghatabhaghiile ukutuyiilania na kaakanandi utwe pamupeene nuumwe. Kaali kiisa ukuti mubhuuke kuukwo bhakughulisha ukuti mwighulile yumwemwe.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Po abhakonyofu bhala bhakanyatuka ukubhuuka pakughula amafuta. Bhwo bhakubhuuka, yuuyo akwegha akiisa. Abhalindu abha mahala bhala bhaabho bhakabha bhiitendekeshiishe, bhakiingila pamupeene naghwe mu nyumba muumwo ubhweghi bhukabhombighwanga. Po umundu yumo akapinga ichiighi. ");
INSERT INTO ndh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pabhumalilo abhakonyofu bhala bhoope bhakaghaluka nu kwagha ichiighi chipinge. Po bhakiima kuuse nu kwitisha bhakati, ‘Ghwe malafyale, tukusuuma utwighulile ichiighi!’ ");
INSERT INTO ndh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Loole yuuyo akwegha akabhaamula akati, ‘Nalooli ingubhabhuula, indabhameenye umwe!’ ” ");
INSERT INTO ndh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","UYeesu akabhabhuula abhamanyili bhaake akati, “Po mubhange maaso paapo mutalimeenye ishiku pamu akabhalilo kaako uMwana ughwa Mundu indiakaghalukaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","UYeesu akeendelela ukuyugha ichifwanikisho ichinine akati, “Soona, ichitangalala icha kumwanya indichikaghelele nu mundu yuuyo akachuula. Bhwo akaali ukuchuula, akabhiitisha abhabhombi bhaake nu kubhapa ichuuma chaake ukuti ghweshi umundu achibhombelaghe imbombo. ");
INSERT INTO ndh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akamupa ghweshi umubhombi ukukongana na maka ghaake. Akamupa umubhombi ughwa kwanda italanta ihaano, ughwa bhubhili italanta shibhili nu ghwa bhutatu akamupa italanta yimo, po akachuula. ");
INSERT INTO ndh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Nakalinga, umubhombi yuuyo usongo ghwake akamupa italanta ihaano, akabhuuka nasho ku bhuchulushi nu kukabha imbya inine ihaano. ");
INSERT INTO ndh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bhubhuubhwo, umubhombi yula yuuyo usongo ghwake akamupa italanta shibhili, akabhuuka nasho ku bhuchulushi nu kukabha imbya inine shibhili. ");
INSERT INTO ndh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Loole umubhombi yula yuuyo usongo ghwake akamupa italanta yimo, akaya aakumba ichibhwina nu kuyishiila italanta yila. ");
INSERT INTO ndh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bhwo akabhalilo akatali kaakinda, usongo ghwabho akaghaluka kuukwo akachuulila. Po akabhiitisha abhabhombi bhaake bhala ukuti bhamulingaanie muumwo bhakachibhombela ichuuma chaake. ");
INSERT INTO ndh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Umubhombi yula yuuyo akapokeela italanta ihaano, akiisa ni talanta imbya ihaano inine nu kumubhuula usongo ghwake akati, ‘Ghwe songo, ukaamba italanta ihaano ukuti ishibhombelaghe imbombo, tesha, naakabha italanta imbya ihaano inine ishi.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Usongo ghwake yula akamubhuula akati, ‘Ghwabhomba akiisa leka. Ughwe ghwe mubhombi umwisa soona musubhaalilighwa! Paapo ghwali musubhaalilighwa ku tundu utunandi tuutwo ingakupa, ulu indiingubhiike ukubha mwimilili ughwa tundu utwingi. Isagha tusekele pamupeene.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Umubhombi yula yuuyo akapokeela italanta shibhili, ghwepe akiisa ni talanta imbya shibhili inine nu kumubhuula usongo ghwake akati, ‘Ghwe songo, ukaamba italanta shibhili ukuti ishibhombelaghe imbombo, tesha, naakabha italanta imbya shibhili inine ishi.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Usongo ghwake akamubhuula akati, ‘Ghwabhomba akiisa leka. Ughwe ghwe mubhombi mwisa soona musubhaalilighwa! Paapo ghwali musubhaalilighwa ku finandi fiifyo ingakupa, ulu indiingubhiike ukubha mwimilili ughwa findu ifyingi. Isagha tusekele pamupeene.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Loole umubhombi yula yuuyo akapokeela italanta yimo, akiisa nu kumubhuula usongo ghwake akati, ‘Ghwe songo, ingamanya ukuti ughwe ghwe mukafu leka. Ughwe uli ungati mundu yuuyo akwinula paapo atakabhyala nu kubhungaania paapo atakanyambaania. ");
INSERT INTO ndh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ingooghopa ukuyisofya italanta yaako, po ingabhuuka pakuyishiila mu ilongwi. Ulu, eegha italanta yaako iyi.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Usongo ghwake akamwamula akati, ‘Ughwe ghwe mubhombi mubhiibhi soona ghwe mukata! Linga ukamanya ukuti une ingwinula paapo indakabhyala, soona ingubhungaania paapo indakanyambaania, ");
INSERT INTO ndh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","po kali, kooni utakaambiikilagha italanta yangu ku bhachulushi ukuti bhwo ingughaluka niise neeghe italanta yangu pamupeene ni sha pamwanya?’ ");
INSERT INTO ndh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Po usongo ghwake akalaghila akati, ‘Eegha italanta iyo, mupe umubhombi yula yuuyo ali ni talanta kalongo (10).’ ");
INSERT INTO ndh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Paapo umundu ghweshi yuuyo akukabhombela akiisa kaako ali nako, uChaala indiakamwongeleshe akanine, loole umundu ghweshi yuuyo atakukabhombela akiisa kaako ali nako, uChaala indiakamupoke na kala kaako ali nako. ");
INSERT INTO ndh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Umubhombi uyu ataa musubhaalilighwa, mutaaghe kuuse ku chiisi kuukwo indiakalilaghe nu kushesheetusha amiino ku nongwa iya bhubhafu ubhukali.” ");
INSERT INTO ndh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","UYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “Bhwo uMwana ughwa Mundu iisa mu bhukulumba bhwake pamupeene na bhandumi abheelu bhooshi, po indiakiikale pa chitengu chaake icha bhukulumba. ");
INSERT INTO ndh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abhandu ukufuma mu fyisu fyoshi indibhakabhungaane pandaashi papaake. Ghwepe indiakabhapaaghulanie isa muumwo umuliishi akupaaghulanikisha abhonangʼooshi ukufuma mu mbushi. ");
INSERT INTO ndh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Isa muumwo umuliishi akubhabhiika abhonangʼooshi kulubhafu lwake ulwa kumwisa ni mbushi kulubhafu lwake ulwa kushoomi, bhubhuubhwo, ghwepe uMwana ghwa Mundu indiakabhabhiike abhagholofu kulubhafu lwake ulwa kumwisa, na bhatulanongwa kulubhafu lwake ulwa kushoomi. ");
INSERT INTO ndh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Po uMalafyale indiakabhabhuule abhandu bhala bhaabho bhali kulubhafu lwake ulwa kumwisa indiakati, ‘Isagha, umwe mwe uTaata abhasayite. Ingilagha mu chitangalala chiicho uChaala akabhatendekeshekesha ngaanila bhwo akupela ichiisu. ");
INSERT INTO ndh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Paapo bhwo isala yikuumbabha, mukaamba ifindu, bhwo inyoota yiingolite, mukaamba amiishi agha kungʼwa, soona bhwo indi muheesha, mukaambokeela mu nyumba shiinyu. ");
INSERT INTO ndh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bhwo indali ni myenda, mukaamba imyenda iya kufwala. Bhwo indi mubhine, mukiisa pakuumbinia. Bhwo imbinyiighwe mu nyumba iya bhapinyighwa, mukiisa pakuundesha.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Po abhagholofu indibhakamwamule bhakati, ‘Ghwe Malafyale, kali, kabhalilo kaki kaako tukakubhona bhwo isala yikukubhabha tukakupa ifindu? Pamu kali, kabhalilo kaki kaako tukakubhona bhwo inyoota yikukolite nuutwe tukakupa amiishi agha kungʼwa? ");
INSERT INTO ndh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Soona, kali, kabhalilo kaki kaako bhwo uli muheesha tukakupokeela mu nyumba shiitu? Pamu kali, kabhalilo kaki kaako bhwo utali ni myenda tukakufwasha imyenda? ");
INSERT INTO ndh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Soona, kali, kabhalilo kaki kaako bhwo uli mubhine tukakubhinia, pamu bhwo upinyiighwe mu nyumba iya bhapinyighwa tukiisa pakukutesha?’ ");
INSERT INTO ndh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Po uMalafyale indiakabhaamule indiakati, ‘Nalooli ingubhabhuula, kooshi kaako mukamubhombelagha umufuyuke yumo mu bhiitiki bhangu abha, po mukaambombelagha neene.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Po indiakabhabhuule bhala bhaabho bhali kulubhafu lwake ulwa kushoomi indiakati, ‘Tiilaapo panu umwe mwe uChaala abhaghunite! Bhuukagha mu mulilo ughwa bhwila na bhwila ghuughwo uChaala atendekeshiishe ku nongwa iya Seetano na bhandumi bhaake. ");
INSERT INTO ndh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Paapo bhwo isala yikuumbabha, mutakaamba ifindu, bhwo inyoota yiingolite, mutakaamba amiishi agha kungʼwa. ");
INSERT INTO ndh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Bhwo indi muheesha, mutakaambokeela mu nyumba shiinyu. Bhwo indali ni myenda, mutakaamba imyenda iya kufwala. Soona bhwo indi mubhine, mutakiisa pakuumbinia pamu bhwo imbinyiighwe mu nyumba iya bhapinyighwa, mutakiisa pakuundesha.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Po bhoope bhaabho bhali ku kakono kaake aka kushoomi indibhakamwamule indibhakati, ‘Ghwe Malafyale, kali, kabhalilo kaki kaako isala yikakubhabha, pamu inyoota yikakukola, pamu ukabha muheesha, pamu utakabha ni myenda, pamu ukabha mubhine, pamu ukabha mu nyumba iya bhapinyighwa, nuutwe tutakakwafwa?’ ");
INSERT INTO ndh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ghwepe indiakabhaamule indiakati, ‘Nalooli ingubhabhuula, shooshi shiisho mutakamwafwanga umushita kubhaghila yumo mu bhiitiki bhangu abha, po mutakaanyaafwanga neene.’ ");
INSERT INTO ndh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Po abhatulanongwa bhala indibhakatiile nu kubhuuka ku bhulongi ubhwa bhwila na bhwila. Loole bhala bhaabho bhagholofu, indibhakiingile mu bhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bhwo uYeesu aamala ukuyugha amashu agho ghooshi, akabhabhuula abhamanyili bhaake akati, ");
INSERT INTO ndh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Isa muumwo mushimanyiile, bhwo amashiku mabhili ghaakinda, inditubhe ni chaaka icha Pasaka. UMwana ughwa Mundu indiabhiikighwe mu tukono utwa bhalughu ukuti aghoghighwe pa chikobhekano.” ");
INSERT INTO ndh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Po mu kabhalilo ako, abhosongo abha bhapuuti na bhosongo abha Bhayuuta bhakabhungaana mu nyumba ingulu iya mupuuti usongo yuuyo ingamu yaake akabha ghwi Kayaafa. ");
INSERT INTO ndh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bhakayughisania ukumukola uYeesu ku bhushiifu ukuti bhamughoghe. ");
INSERT INTO ndh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Loole bhakayughisania bhakati, “Manye tushibhombe ishi pi ishiku ilya chaaka icha Pasaka ukuti abhandu manye bhiise bhabhombe inyakanyaaka.” ");
INSERT INTO ndh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Po uYeesu akabhuuka mu kaaya aka Bheetaniya nu kwikala mu nyumba iya Siimoni yuuyo kubhwandilo akabha ni mbungo iya makete. ");
INSERT INTO ndh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Po bhwo uYeesu iikiile ali pakulya, umukolo yumo akiisa kukwake ni supa inandi iya nyemba isha kunuukila isha mutengo umukulu ngaani nu kumusululila uYeesu pa mutu ukulangisha ulughindiko. ");
INSERT INTO ndh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bhwo abhamanyili bhaake bhaashibhona isho, bhakakalala leka mu ndumbula shaabho bhakati, “Kali, kooni umukolo uyu akukomania inyemba isha mutengo isho? ");
INSERT INTO ndh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kaali kiisa inyemba ishi ukushighulisha ku ndalama inyingi leka nu kubhapa abhapiina!” ");
INSERT INTO ndh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","UYeesu akashaaghania shiisho bhakiinongʼonagha, akabhabhuusha akati, “Kali, kooni kaako mukumutamya umukolo uyu? Umwene aambombela shiisho nyiisa leka. ");
INSERT INTO ndh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Paapo abhapiina bhali pamupeene nuumwe amashiku ghooshi, loole une indaaimbe pamupeene nuumwe akabhalilo kooshi. ");
INSERT INTO ndh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Umukolo uyu aasululila inyemba ishi ukuti aandendekeshe pi ishiku ilya kushiilighwa kwangu. ");
INSERT INTO ndh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nalooli ingubhabhuula, pooshi paapo iNongwa iNyiisa indishikalumbililighwange mu chiisu chooshi, inyiisa isho shiisho umukolo uyu aambombela, indishikayughighwange ukuti abhandu bhamukumbukaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Po uYuuta Isikaliyooti yuuyo ghwe yumo mu bhamanyili kalongo na bhabhili (12) bhala, akabhuuka ku bhosongo abha bhapuuti, ");
INSERT INTO ndh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akabhabhuusha akati, “Kali, indimukaahombe kooni linga niisa naghwe kukwinyu?” Po bhakamuhomba ifibhali ifya indalama amalongo matatu (30). ");
INSERT INTO ndh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ukwandila akabhalilo kala bhwo bhaamuhomba, uYuuta Isikaliyooti akaanda ukulonda isila iya kumubhiika uYeesu mu tukono twabho. ");
INSERT INTO ndh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pi ishiku ilya kwanda ilya chaaka icha Mikati iMishita Kulula, abhamanyili abha Yeesu bhakiisa kukwake, bhakamubhuusha bhakati, “Kali, pooki paapo kulonda tukutendekeshekeshe ichaaka icha Pasaka?” ");
INSERT INTO ndh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","UYeesu akabhaamula akati, “Bhuuka mu kaaya aka Yelusaleemu ku mundu yumo nu kumubhuula ukuti, uMumanyishi aatutuma, akuti, ‘Akabhalilo kangu kapalamiile. Une na bhamanyili bhangu inditulye ifindu ifya Pasaka mu nyumba yaako.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Abhamanyili bhala bhakabhuuka nu kubhomba shooshi isa muumwo uYeesu akabhalaghila, bhakatendekesha ifindu ifya Pasaka. ");
INSERT INTO ndh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bhwo lyabha lya namasubha, uYeesu na bhamanyili bhaake kalongo na bhabhili bhakiikala pakulya ifindu. ");
INSERT INTO ndh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bhwo bhali pakulya, uYeesu akabhabhuula akati, “Nalooli ingubhabhuula, umunyiinyu yumo indiaambiike mu tukono utwa bhalughu.” ");
INSERT INTO ndh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abhamanyili bhaake bhakaswimaana leka, po yumo yumo akaanda ukumubhuusha akati, “Ghwe Malafyale, kali, neene?” ");
INSERT INTO ndh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","UYeesu akaamula akati, “Umundu yula yuuyo aasaasila mu kabhigha pamupeene nuune, ghwe yuuyo indiaambiike mu tukono utwa bhalughu. ");
INSERT INTO ndh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","UMwana ughwa Mundu akuya pakughoghighwa isa muumwo shisimbiighwe mu Masimbo aMeelu. Loole lwake umundu yuuyo akuya pakumubhiika uMwana ughwa Mundu mu tukono utwa bhalughu. Kaali kiisa kukwake linga umundu uyo atakapaapighwanga!” ");
INSERT INTO ndh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Po uYuuta yuuyo akamubhiika uYeesu mu tukono utwa bhalughu, ghwepe akabhuusha akati, “Ghwe Mumanyishi, kali, neene?” UYeesu akamwamula akati, “Ghweghwe ghwayugha.” ");
INSERT INTO ndh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bhwo bhali pakulya, uYeesu akeegha umukati, akapaalisha kwa Chaala, akaghubheghulania, akabhapa abhamanyili bhaake, akabhabhuula akati, “Eegha nu kulya umukati, ughu ghwo ghuughwo mubhili ghwangu.” ");
INSERT INTO ndh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akeegha ichikombe chiicho chikabha ni ndifaayi, akapaalisha kwa Chaala, akabhapa, akabhabhuula akati, “Eegha nu kungʼwa indifaayi iyi mweshi. ");
INSERT INTO ndh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Paapo ili lyo liilyo libhanda lyangu ilya lwitikano liilyo likukupuka ku nongwa iya bhandu abhingi ukuti uChaala abhahobhokele imbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ingubhabhuula ukuti indaaingangʼwe soona indifaayi ukufika pi ishiku liilyo indiingangʼwe indifaayi imbya pamupeene nuumwe mu chitangalala icha Taata.” ");
INSERT INTO ndh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","UYeesu na bhamanyili bhaake bhwo bhiimba inyimbo, po bhakatiila nu kubhuuka ku kaghamba aka Mishunguti. ");
INSERT INTO ndh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Ubhushiku ubhwa muusughu, umwe mweshi indimuunginde nu kuundeka. Paapo shisimbiighwe mu Masimbo aMeelu ukuti, ‘UChaala indiakamughoghe umuliishi ughwa bhonangʼooshi, nu mutiimo ughwa bhonangʼooshi indighukanyambaane.’ ");
INSERT INTO ndh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Loole bhwo naashuuka, indiingabhatangile ukubhuuka ku Ghalilaayi.” ");
INSERT INTO ndh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Po uPeeteli akamubhuula uYeesu akati, “Nalinga bhooshi bhaakuleka, une indaaingakuleke naalumo!” ");
INSERT INTO ndh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","UYeesu akamwamula akati, “Nalooli ingukubhuula, ubhushiku ubhwa muusughu bhwo ubhiisa akaali ukubhika, indiubhe ghwangaana katatu ukuti utaameenye.” ");
INSERT INTO ndh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","UPeeteli akamwamula akati, “Nalinga shikulondighwa ukuti ifwe pamupeene nuughwe, une indaaingakuleke naalumo!” Abhamanyili abhanine bhoope bhakayugha isa bhubhuubhwo. ");
INSERT INTO ndh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Po uYeesu akabhuuka na bhamanyili bhaake mu chibheela chiicho ingamu yaake bhakatingi, Ghetiseemani, akabhabhuula akati, “Mwikale taashi panu bhwo ingubhuuka kula pakwipuuta kwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akabheegha uPeeteli pamupeene na bhaana bhabhili abhaliisha abha Sebhetaayi, akaanda ukuswimaana nu kulabha-labha ngaani mu ndumbula yaake. ");
INSERT INTO ndh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Po akabhabhuula akati, “Indi nu bhuswimaane ubhukulu ngaani mu ndumbula yangu ubhwa kuumbelela ukufwa. Po mwikale panu, mubhe maaso, manye mupitilaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Akabhiyila pandaashi panandi, akiitaagha paase, akiipuuta kwa Chaala akati, “Ghwe Taata, linga shiitikagha, ingukusuuma manye ushiitikishe kukwangu indamyo ingulu ishi! Manye ubhombe isa muumwo ingulondela, loole ubhombe isa muumwo kulondela.” ");
INSERT INTO ndh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Po uYeesu akaghaluka paapo akabhaleka abhamanyili bhaake, akabhaagha bhapitiile. Akamubhuusha uPeeteli akati, “Kali, mwapootwa ukubha maaso pamupeene nuune nalinga kabhalilo aka sala yimoyeeneeshe? ");
INSERT INTO ndh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mubhange maaso, soona mwipuutaghe kwa Chaala ukuti ingelo manye shibhapoote. Indumbula shiinyu shikulonda ukubhomba inyiisa, loole mutali na maka.” ");
INSERT INTO ndh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","UYeesu akabhaleka soona nu kubhuuka ulwa bhubhili pakwipuuta kwa Chaala akati, “Ghwe Taata, linga indamyo ingulu ishi shitabhaghiile ukutiila kukwangu, po ubhombe isa muumwo kulondela.” ");
INSERT INTO ndh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Po bhwo aaghaluka paapo abhamanyili bhaake bhakabha, akabhaagha bhapitiile soona, paapo amaaso ghaabho ghakabha ghali nu tulo. ");
INSERT INTO ndh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","UYeesu akabhaleka soona, akabhuuka pakwipuuta kwa Chaala ulwa bhutatu, akaghalukila ukuyugha amashu ghala ghala. ");
INSERT INTO ndh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Po bhwo aaghaluka soona paapo bhali, akabhabhuusha akati, “Kali, kooni mukwendelela ukupitila? Tesha, akabhalilo kaafika kaako uMwana ughwa Mundu akuya pakubhiikighwa mu tukono utwa bhatulanongwa. ");
INSERT INTO ndh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lamusha! Tubhuuke. Tesha, yula yuuyo akwisa pakuumbiika mu tukono utwa bhalughu, aapalamila!” ");
INSERT INTO ndh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bhwo uYeesu akaali akuyugha, uYuuta yuuyo ghwe yumo mu bhamanyili bhaake kalongo na bhabhili (12) bhala, akiisa pamupeene ni chilundilo ichikulu icha bhandu bhaabho bhakabha ni mipanga ni nduughu. Abhandu abho bhakabha bhatumiighwe na bhosongo abha bhapuuti na bhosongo abha Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","UYuuta akatanga taashi ukubhalingaania ichilangisho abhandu bhala akati, “Umundu yuuyo naamulamuka ku sila iya kumwofwa, ghwe yuuyo mwise mumukolaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nakalinga, uYuuta akabhuuka kwa Yeesu, akamubhuusha akati, “Ghwe Mumanyishi, kali, ghwalinda bhuleele?” Po akamwofwa. ");
INSERT INTO ndh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","UYeesu akamwamula akati, “Ghwe mumanyani, shibhombe shiisho ghwisiile.” Po abhandu bhala bhakamukola uYeesu nu kumupinya. ");
INSERT INTO ndh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Po yumo mu bhaabho bhakabha pamupeene nu Yeesu, akafyutula lubhilo umumaaghi umutali ughwa bhwite, akapuupa ichuufwo icha mutumwa ughwa mupuuti usongo. ");
INSERT INTO ndh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Loole uYeesu akamubhuula akati, “Ghalusha umumaaghi ughwo mu nyambi yaake, paapo bhaabho bhakukola imimaaghi, bhoope indibhakaghoghighwe ku mimaaghi iyo! ");
INSERT INTO ndh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kali, mutameenye ukuti imbaghiile ukusuuma ubhutuuli kwa Taata, ghwepe nakalinga abhaghiile ukuundumila abhandumi bhaake ukukinda ifibhughutila ifikulu kalongo na fibhili (12)? ");
INSERT INTO ndh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kali, linga naabhomba ulwo, po shibhaghiile shibhombighwe bhuleele shiisho shisimbiighwe mu Masimbo aMeelu ukuti mwo muumwo shibheeliile?” ");
INSERT INTO ndh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Po uYeesu akabhabhuusha abhandu bhala akati, “Kali, mwisile ni mipanga ni nduughu pakuungola une ungati indi mundu yuuyo akuyikaanika isilikali? Amashiku ghooshi niikalagha nuumwe, naamanyishanga mu lupaso ulwa Nyumba iya Chaala, loole mutaangolagha. ");
INSERT INTO ndh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Loole shooshi ishi shaabhoneka ulu ukuti shibhombighwe shiisho abhasololi bhakasimba mu Masimbo aMeelu.” Po abhamanyili bhaake bhooshi bhakamuleka nu kukinda. ");
INSERT INTO ndh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Po ichilundilo ichikulu icha bhandu bhala bhakamukola uYeesu nu kubhuuka naghwe kwa Kayaafa, umupuuti usongo kuukwo bhakabhungaana abhamanyishi abha ndaghilo isha Moose na bhosongo abha Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","UPeeteli akamukongagha uYeesu pabhutaliipo ukufika pa lupaso ulwa nyumba iya mupuuti usongo. Po akiingila mukati, akiikala pamupeene na bhalindilili ukuti ateshe muumwo inongwa iya Yeesu indiyishilile. ");
INSERT INTO ndh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Abhosongo abha bhapuuti bhala ni Ibhalaasa lyoshi ilya Bhayuuta, bhakaanda ukulonda ubhukeeti ubhwa bhumyashi ubhwa kumusitaakila uYeesu ukuti aghoghighwe. ");
INSERT INTO ndh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Loole bhatakabhwagha ubhukeeti naabhumo pamupeene nu kuti bhakiisa abhakeeti abha bhumyashi abhingi. Pabhumalilo, abhandu bhabhili bhakiisa bhakati, ");
INSERT INTO ndh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Umundu uyu akati, ‘Imbaghiile ukuyipongolania iNyumba iya Chaala nu kuyisenga soona ku mashiku matatu.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Po umupuuti usongo akiima, akamubhuusha uYeesu akati, “Kali, utakwamula ni ishu naalimo ukukongana na shiisho abhandu abha bhakukusitaakila ughwe?” ");
INSERT INTO ndh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Loole uYeesu akasumbaashe. Po umupuuti usongo yula akamubhuula soona akati, “Ingukubhuula mu ngamu iya Chaala yuuyo mwumi, tubhuule bhwo kuloolika, linga ughwe ghwe Mesiiya, uMwana ughwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","UYeesu akamwamula akati, “Ghweghwe ghwayugha. Loole ingubhabhuula mweshi ukuti ukwandila ulu indimukamubhone uMwana ughwa Mundu bhwo iikiile ku kakono aka kumwisa aka Chaala ughwa Maka Ghooshi. Soona indimukamubhone bhwo akwisa mu mabhingu ukufuma kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Po bhwo umupuuti usongo aapulika amashu agho, akaghunyaapulania umuselekesha ghwake akati, “Mwamupulika, aamufuyula uChaala! Po kali, ulu mukulonda soona abhakeeti? Mwapulika yumwemwe ukufuyula kwake! ");
INSERT INTO ndh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Po kali, umwe mukwinongʼona kooni?” Bhakamwamula bhakati, “Akulondighwa aghoghighwe!” ");
INSERT INTO ndh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Po bhakaanda ukumufwilila amati uYeesu ku maaso nu kumukoma ni mbuli. Abhanine bhakamukoma na mapi ");
INSERT INTO ndh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nu kumubhuula bhakatingi, “Ghwe Mesiiya, solola, kali, ghwini yuuyo aakukoma?” ");
INSERT INTO ndh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Po mu kabhalilo kala kala uPeeteli akabha iikiile kuuse ku lupaso. Po umubhombi yumo umulindu akapalamila kwa Peeteli, akamubhuula akati, “Nuughwe ghwali pamupeene nu Yeesu ughwa mu Ghalilaayi.” ");
INSERT INTO ndh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","UPeeteli akakaana pandaashi pa bhala bhooshi akati, “Indashimeenye isho shiisho kushiyugha!” ");
INSERT INTO ndh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Po akatiila pala, akabhuuka kuuse ku mulyango ughwa lupaso. Umubhombi umunine umulindu akamubhona, akabhabhuula abhandu bhaabho bhakabhaapo pala akati, “Umundu uyu aali pamupeene nu Yeesu ughwa mu Naasaleeti.” ");
INSERT INTO ndh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","UPeeteli akakaana soona nu kuloolika akati, “Indamumeenye umundu uyo!” ");
INSERT INTO ndh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Bhwo akabhalilo kaakinda panandi, abhandu bhala bhaabho bhakiima pala, bhakapalamila kwa Peeteli, bhakamubhuula bhakati, “Nalooli nuughwe ghwe yumo mu bhamanyili abho paapo nu lulimi lwako lukulangisha pabhwelu ukuti ufumite ku Ghalilaayi!” ");
INSERT INTO ndh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","UPeeteli akaanda ukwighuna nu kuloolika akati, “Indamumeenye umundu uyo!” Nakalinga, ubhiisa akabhika. ");
INSERT INTO ndh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Po uPeeteli akakumbuka amashu ghala ghaagho uYeesu akamubhuula akati, “Bhwo ubhiisa akaali ukubhika, indiubhe ghwangaana katatu.” Po akafuma kuuse nu kulila ku bhuswimaane ubhukulu. ");
INSERT INTO ndh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bhwo bhwacha pangeelo, abhosongo abha bhapuuti pamupeene na bhosongo abha Bhayuuta bhakayughisania isha kumusitaaka uYeesu ukuti aghoghighwe. ");
INSERT INTO ndh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bhakamupinya, bhakabhuuka naghwe kwa songo ghwabho uMulooma yuuyo ingamu yaake akabha ghwi Pilaati. ");
INSERT INTO ndh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Po uYuuta yula yuuyo akamubhiika uYeesu mu tukono utwa bhalughu, bhwo aatesha ukuti uYeesu aalongighwa ukuti aghoghighwe, akiipulika akabhiibhi. Akeegha isalabhasha isha ndalama amalongo matatu (30) shila nu kushighalusha ku bhosongo abha bhapuuti na bhosongo abha Bhayuuta bhala. ");
INSERT INTO ndh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akabhabhuula akati, “Naatula inongwa pakumubhiika mu tukono twinyu umundu umushita nongwa naayimo.” Loole abheene bhakati, “Isho shitakutwafwa utwe soona, shaako ghwimwene.” ");
INSERT INTO ndh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Po uYuuta akashitaagha isalabhasha shila mu lupaso ulwa Nyumba iya Chaala, akatiila, akabhuuka pakwipinyiilila. ");
INSERT INTO ndh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Abhosongo abha bhapuuti bhakasebha isalabhasha shila, bhakayugha bhakati, “Indaghilo isha Moose shitakwitikisha ukwongaania indalama ishi ni sha mu Nyumba iya Chaala paapo shaahombiighwe ukuti umundu aghoghighwe.” ");
INSERT INTO ndh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Po bhakayughisania nu kutumula ukwegha indalama shila nu kughulila umughunda ughwa mumata ngumbe ukuti bhaabhashiilagheemwo abhaheesha. ");
INSERT INTO ndh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yo yiiyo nongwa umughunda ughwo ingamu yaake bhakuti Mughunda ughwa Libhanda ukufika umuusughu. ");
INSERT INTO ndh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Umwo mwo muumwo ishu likabhombighwa liilyo umusololi uYelemiiya akasimba ukuti, “Bhakeegha isalabhasha isha ndalama amalongo matatu, umutengo ghuughwo aBhaisilaeli bhakiitikana. ");
INSERT INTO ndh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bhakaghulila umughunda ughwa mumata ngumbe isa muumwo uMalafyale akaandaghilila.” ");
INSERT INTO ndh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Po uYeesu akiima pandaashi pa mulongoshi uMulooma. Umulongoshi yula akamubhuusha akati, “Kali, ughwe ghwe Malafyale ughwa Bhayuuta?” UYeesu akamwamula akati, “Ughwe ghweghwe ghwayugha.” ");
INSERT INTO ndh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Po abhosongo abha bhapuuti na bhosongo abha Bhayuuta bhala bhakaanda ukumusitaaka uYeesu, loole umwene atakabhaamula naalimo. ");
INSERT INTO ndh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Po uPilaati akamubhuusha akati, “Kali, utakushipulika isho shooshi shiisho bhakukusitaaka?” ");
INSERT INTO ndh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Loole uYeesu atakaamula ishu naalimo. Po uPilaati akaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bhwilaashe pa chaaka icha Pasaka, umulongoshi uyo akabha nu lwiho ulwa kumwabhula umupinyighwa yumo yuuyo abhandu bhakiighanagha. ");
INSERT INTO ndh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Po akabhalilo kala kaako uYeesu akabha pandaashi pa Pilaati, akabhaapo umupinyighwa yumo yuuyo ingamu yaake akabha ghwi Bhalabha. Umupinyighwa uyo akafumukwa leka ku nongwa iya mbiibhi shiisho akabhombagha. ");
INSERT INTO ndh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Po bhwo abhandu bhaabhungaana, uPilaati akabhabhuusha akati, “Kali, ghwini yuuyo mukulonda imbaabhulile mu bhapinyighwa bhabhili abha? Kali, mukulonda imbaabhulile uBhalabha pamu uYeesu yuuyo abhandu bhakumwitisha ukuti ghwi Mesiiya?” ");
INSERT INTO ndh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","UPilaati akabhabhuusha ulwo paapo akamanya ukuti abhosongo abha Bhayuuta bhiisile nu Yeesu kukwake ku nongwa iya lwibhuno. ");
INSERT INTO ndh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bhwo uPilaati iikala pa chitengu chaake icha bhulongi, umukashi akamutumila indumi akati, “Manye umubhombelaghe ibhiibhi naalimo umundu uyo umushita nongwa, paapo naataamighwa leka pabhushiku mu filoota ku nongwa yaake.” ");
INSERT INTO ndh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Loole abhosongo abha bhapuuti na bhosongo abhanine abha Bhayuuta bhakabhasongelesha abhandu ukuti bhamusuume uPilaati abhaabhulile uBhalabha nu kumulonga uYeesu ukuti aghoghighwe. ");
INSERT INTO ndh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","UPilaati akabhabhuusha soona akati, “Kali, ghwini yuuyo mukulonda imbaabhulile mu bhapinyighwa bhabhili abha?” Bhakamwamula bhakati, “Tukulonda utwabhulile uBhalabha.” ");
INSERT INTO ndh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","UPilaati akabhabhuusha soona akati, “Kali, ulu imbombe kooni nu Yeesu yuuyo bhakumwitisha ukuti ghwi Mesiiya?” Abhandu bhooshi bhakaywegha bhakati, “Mukomeele pa chikobhekano!” ");
INSERT INTO ndh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","UPilaati akabhabhuusha soona akati, “Kali, atulite nongwa yiki?” Loole abheene bhakoongelaghaashe ukuywegha bhakatingi, “Mukomeele pa chikobhekano!” ");
INSERT INTO ndh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bhwo uPilaati aamanya ukuti atabhaghiile ukusanusha inyinongʼono isha bhandu bhala nu kuti bhaanda inyakanyaaka, akeegha amiishi nu kusukusula utukono twake pandaashi papaabho ukulangisha ukuti ataa ni nongwa naayimo. Po akabhabhuula akati, “Indaa ni nongwa naayimo ku mundu umugholofu uyu. Ishi shili mu tukono twinyu yumwemwe!” ");
INSERT INTO ndh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Abhandu bhooshi bhakamwamula bhakati, “Inongwa iya kumughogha uYeesu iyo yibhange yiitu na bhaana bhiitu!” ");
INSERT INTO ndh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Po uPilaati akabhaabhulila uBhalabha isa muumwo bhakamusuumila, loole akabhalaghila abhashikali bhaake ukuti bhamukome uYeesu ni fikoti, soona bhamukomeele pa chikobhekano. ");
INSERT INTO ndh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Po abhashikali abha mulongoshi uMulooma bhala, bhakamwegha uYeesu nu kubhuuka naghwe mu nyumba ingulu yiiyo umulongoshi akiikalagha. Bhakabhabhungaania abhashikali abhanine bhooshi nu kumushunguulila uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhakamufuula uYeesu imyenda yaake nu kumufwasha umuselekesha umukesamu. ");
INSERT INTO ndh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bhakanienga ingigha iya myifwa, bhakamufwasha ku mutu nu kuyibhiika ingoomo ku kakono kaake aka kumwisa ukuti abhonekaghe ungati ghwi malafyale. Bhakafughamila pandaashi papaake ungati bhakumwipuuta nu kwanda ukumwangalila ku lufuuyo bhakatingi, “Ghwaghona, ghwe Malafyale ghwa Bhayuuta!” ");
INSERT INTO ndh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Po bhakaanda ukumufwilila amati uYeesu, bhakeegha ingoomo yila ku kakono kaake nu kumukoma-koma nayo ku mutu. ");
INSERT INTO ndh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bhwo abhashikali abho bhaamala ukumwangalila, bhakamufuula umuselekesha ghula nu kumufwasha imyenda yaake soona. Po bhakabhuuka naghwe pakumukomeela pa chikobhekano. ");
INSERT INTO ndh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bhwo uYeesu na bhashikali bhakufuma mu kaaya aka Yelusaleemu, bhakamwagha mu sila umundu yumo yuuyo ingamu yaake akabha ghwi Siimoni ukufuma mu kaaya aka Kileene. Abhashikali abho bhakamufimbilisha ukupimba ichikobhekano icha Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pabhumalilo, bhakafika nu Yeesu pabhuyo paapo bhakatingi Gholighoota, kwo kuti, “Bhuyo ubhwa Mungʼooso ughwa Mutu.” ");
INSERT INTO ndh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Po bhakamupa uYeesu indifaayi yiiyo bhakoongaania nu mukota umukali ukuti manye apulikaghe ubhubhafu. Loole bhwo aaghonja, akakaana ukungʼwa. ");
INSERT INTO ndh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bhwo bhaamukomeela pa chikobhekano, bhakayabhana imyenda yaake ku sila iya kuyikomela ikuula, ukuti shibhoneke shiisho shisimbiighwe nu musololi ukuti, “Bhakayabhana imyenda yangu, nu kughukomela ikuula umuselekesha ghwangu.” ");
INSERT INTO ndh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Po bhakiikala pala pala ukuti bhamulindilile. ");
INSERT INTO ndh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pamwanya pa mutu ghwake, bhakabhiika amasimbo agha kumusitaaka ghaagho ghakasimbighwa ukuti, ");
INSERT INTO ndh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Po abhashikali bhakabhakomeela abhapoka ifya bhandu bhabhili pamupeene nu Yeesu, yumo ku kakono aka kumwisa nu munine ku kakono aka kushoomi. ");
INSERT INTO ndh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Abhandu bhaabho bhakaghendagha pala, bhakapukushanga imitu yaabho nu kumutuka, ");
INSERT INTO ndh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","bhakatingi, “Ehee! Ughwe ghwayughagha ukuti ubhaghiile ukupongola iNyumba iya Chaala nu kusenga ku mashiku matatu, po linga ghwe Mwana ghwa Chaala, ipoka ghwimwene, iika pa chikobhekano!” ");
INSERT INTO ndh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bhubhuubhwo, abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose pamupeene na bhosongo abha Bhayuuta bhoope bhakamwobhelagha uYeesu ");
INSERT INTO ndh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","bhakatingi, “Akabha mwengo ukubhapoka abhanine, loole atabhaghiile ukwipoka mwene! Linga nalooli ghwi Malafyale ughwa Bhaisilaeli, iike pa chikobhekano, po nuutwe inditumwitike. ");
INSERT INTO ndh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Umwene akumusubhaalila uChaala, po uChaala amupoke ulu linga amughanite paapo akayughagha akatingi, ‘Une nee Mwana ughwa Chaala.’ ” ");
INSERT INTO ndh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bhoope abhapoka ifya bhandu bhaabho bhakakomeelighwa pamupeene nu Yeesu, bhakamutukagha isa muumwo abhanine bhakamutukagha. ");
INSERT INTO ndh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ukwandila bhwo isubha lyafika pamutu (6:00) ukufika mu sala iya bhuhaano na inna (9:00), ichiisi chikaghwa ichiisu chooshi. ");
INSERT INTO ndh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mu kabhalilo ako, uYeesu akakuuta ku ishu ilya pamwanya nu kwitisha akati, “Elooyi! Elooyi! Lama sabhakitani?” Isanusho ilya mashu agho kwo kuti, “Ghwe Chaala ghwangu! Ghwe Chaala ghwangu! Kali, kooni ghuundekite?” ");
INSERT INTO ndh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bhwo abhandu bhamu bhaabho bhakiima pala bhaamupulika uYeesu, bhakati, “Uyu akumwitisha umusololi uEliiya.” ");
INSERT INTO ndh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nakalinga, yumo mu bhashikali akakinda lubhilo, akiisa nu musapa, akaghuyubhika mu ndifaayi ingali, akaghubhiika umusapa ghula ku ilaashi, akamupa uYeesu ukuti angʼwe. ");
INSERT INTO ndh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Loole abhashikali abhanine bhakayugha bhakati, “Leka, manye umupange indifaayi iyo paapo tukulonda tuteshe linga umusololi uEliiya indiiise pakumupoka!” ");
INSERT INTO ndh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Po uYeesu akakuuta ku ishu ilya pamwanya, akafwa. ");
INSERT INTO ndh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nakalinga, ipasiya liilyo likabha mu Nyumba iya Chaala likanyaapuka imbafu shibhili ukufuma kumwanya ukufika paase. UChaala akapela akayingiyingi akakulu kaako kakapela amaalabhwe ukubhaluka. ");
INSERT INTO ndh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Amapumba ghakiighuka ni mibhili imyingi iya bhagholofu bhaabho bhakafwa yikashuuka nu kufuma mu mapumba. ");
INSERT INTO ndh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bhwo bhaafuma mu mapumba, bhakalindilila ukufika paapo uYeesu akashuukagha, po bhakiingila mu kaaya akeelu aka Yelusaleemu nu kubhabhonekela abhandu abhingi. ");
INSERT INTO ndh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bhwo usongo ughwa bhashikali pamupeene na bhala bhaabho bhakamulindililagha uYeesu bhaakabhona akayingiyingi ni nine shooshi shiisho shikabhoneka, bhakooghopa leka, bhakayugha bhakati, “Nalooli, umundu uyu aali Mwana ghwa Chaala!” ");
INSERT INTO ndh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Po bhakabhaapo na bhakolo abhingi pala bhaabho bhakamukongagha uYeesu ukufuma mu chiisu icha Ghalilaayi nu kumubhombela. Abhakolo bhala bhakiima pabhutali nu kutesha shooshi shiisho shikabhombighwanga. ");
INSERT INTO ndh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Abhakolo abho bhakabha bho abha: uMaliiya ughwa kufuma mu kaaya aka Maghatala, uMaliiya ungʼina ughwa Yaakobhu nu Yoosefu, nu mukashi ughwa Sebhetaayi. ");
INSERT INTO ndh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bhwo lyabha lya namasubha, akiisa umumanyili yumo ughwa Yeesu yuuyo ingamu yaake ghwi Yoosefu. Umundu uyo akabha mukabhi yuuyo akafuma mu kaaya aka Alimataayi. ");
INSERT INTO ndh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","UYoosefu akabhuuka kwa Pilaati nu kusuuma umufimba ughwa Yeesu. Po uPilaati akabhalaghila abhashikali bhaake ukuti bhamupe umufimba ghula. ");
INSERT INTO ndh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","UYoosefu akabhuuka, akaghwegha umufimba ghula nu kughuniembetelela nu mwenda umwelu. ");
INSERT INTO ndh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Akaghubhiika umufimba mu ipumba lyake ipya ilya mbako liilyo likabha likumbile ngaanila pa lyalabhwe. Po akalibhungunia iyondo ikulu ku mulyango ughwa lipumba lila nu kutiilaapo. ");
INSERT INTO ndh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mu kabhalilo ako, uMaliiya ukufuma mu kaaya aka Maghatala nu Maliiya umunine yula, bhakiikala pala bhwo bhakulitesha ipumba. ");
INSERT INTO ndh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ishiku ilya ningeelo yaake liilyo likabha lishiku lya Sabhati, abhosongo abha bhapuuti na Bhafalisaayi bhakabhungaana kwa Pilaati. ");
INSERT INTO ndh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Po bhakamubhuula bhakati, “Ghwe malafyale, tukukumbuka ukuti bhwo umumyashi yula mwumi, akayugha akati, ‘Indiingashuuke pi ishiku ilya bhutatu.’ ");
INSERT INTO ndh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Po tukusuuma ubhalaghile abhashikali bhaako bhalilindililaghe ipumba ukufika pi ishiku ilya bhutatu. Linga utaabhiika abha kulilindilila, abhamanyili bhaake bhabhaghiile ukwisa pakughwibha umufimba ghwake nu kubhashimbula abhandu ukuti ashuukite. Linga isho shaabhombighwa, ubhumyashi ubhwo indibhukabhe bhubhiibhi ngaani ukukinda ubhwa bhwandilo.” ");
INSERT INTO ndh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","UPilaati akabhaamula akati, “Bheeghe abhashikali. Bhuuka ku ipumba nu kulilindilila ku maka ghiinyu ghooshi.” ");
INSERT INTO ndh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Po bhakabhuuka ku ipumba, bhakabhiika ichindindo pi iyondo ukuti naayumo umundu ughwa kulibhungunia. Pabhumalilo, abhalongoshi bhala bhakabhaleka abhashikali pala ukuti bhalilindililaghe ipumba. ");
INSERT INTO ndh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Po ishiku ilya Sabhati likakinda. Pangeelo ngaani bhwo kukaali ukucha pi ishiku ilya Pamulungu, uMaliiya ughwa kufuma mu kaaya aka Maghatala pamupeene nu Maliiya umunine bhakabhuuka pakutesha ipumba lila. ");
INSERT INTO ndh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tesha, akayingiyingi akakulu kakaghenda. Ughwandumi ughwa Malafyale uChaala akiilomuka ukufuma kumwanya, akapalamila pi ipumba, akalibhungunia iyondo lila kulubhafu nu kulyikalila. ");
INSERT INTO ndh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Icheeni icha ghwandumi uyo chikangʼangʼagha ungati bhwelu ubhwa kalabhi ni myenda yaake yikabha myelu leka. ");
INSERT INTO ndh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bhwo abhashikali bhala bhaashibhona isho, bhakatetema nu kwoghopa leka, bhakaghwa paase nu kubha ungati bhafwile. ");
INSERT INTO ndh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Loole ughwandumi uyo akabhabhuula abhakolo bhala akati, “Manye mwoghopaghe! Imeenye ukuti mwisa pakumulonda uYeesu yuuyo bhaamukomeelite pa chikobhekano. ");
INSERT INTO ndh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ataliipo panu, ashuukite isa muumwo akabhabhuulila. Isagha mupateshe paapo bhaamughonekite. ");
INSERT INTO ndh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Po bhuuka lubhilo, mubhabhuule abhamanyili bhaake ukuti, ‘Ashuukite nu kuti abhatangiile ukubhuuka mu chiisu icha Ghalilaayi. Ukwo kwo kuukwo indimukamwaghe.’ Manye mwibhwange shiisho naabhabhuula!” ");
INSERT INTO ndh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Po abhakolo bhala bhakatiila lubhilo pi ipumba ku bhwogha nu lusekelo ulukulu. Bhakakinda ukubhuuka pakubhapangila abhamanyili abha Yeesu isa muumwo ughwandumi yula akabhabhuulila. ");
INSERT INTO ndh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Po bhwo bhakubhuuka pakubhapangila abhamanyili bhaake, tesha, uYeesu akakomaana na bhakolo bhala, akabhabhuula akati, “Mwaghona!” Po bhakafughamila kwa Yeesu, bhakamwipuuta ku sila iya kumukola utulundi twake. ");
INSERT INTO ndh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Po uYeesu akabhabhuula akati, “Manye mwoghopaghe. Bhuukagha mubhabhuule abhamanyili bhangu bhabhuukaghe ku Ghalilaayi kuukwo indibhakaanyaaghe.” ");
INSERT INTO ndh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Po bhwo abhakolo bhala bhali mu sila bhakughenda, bhamu mu bhashikali bhaabho bhakalindililagha ipumba ilya Yeesu bhakatiila nu kubhuuka mu kaaya aka Yelusaleemu. Bhakafika nu kubhalingaania abhosongo abha bhapuuti shooshi shiisho shikabhombighwa. ");
INSERT INTO ndh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Po abhosongo abha bhapuuti bhala bhakakomaana pamupeene na bhosongo abha Bhayuuta, bhakayughisania nu kutumula ukubhabheka indalama inyingi abhashikali bhala. ");
INSERT INTO ndh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bhakabhabhuula bhakati, “Linga umundu yumo akubhabhuusha ku shiisho shaabhombighwa mukatingi, ‘Abhamanyili abha Yeesu bhiisile bhaaghwibha umufimba ghwake pabhushiku bhwo tupitiile.’ ");
INSERT INTO ndh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Linga uPilaati aapulika isho, inditukayughe naghwe ukuti manye mwingile mu ndamyo.” ");
INSERT INTO ndh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Po abhashikali bhakapokeela indalama shila nu kuyugha ku bhandu isa muumwo abhalongoshi abha Bhayuuta bhakabhabhuulila. Inongwa isho shikafumukwa leka ku Bhayuuta, soona bhakaali bhakupangilana nu muusughu. ");
INSERT INTO ndh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abhamanyili abha Yeesu kalongo na yumo (11) bhakabhuuka mu Ghalilaayi ku kaghamba kuukwo uYeesu akabhalaghilila. ");
INSERT INTO ndh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bhwo bhaamubhona, bhakamwipuuta, loole bhamu mu bhamanyili abho bhakiilaamwa ukuti ghwi Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Po uYeesu akapalamila, akabhabhuula abhamanyili bhaake akati, “UChaala aambiile amaka ghooshi agha kumwanya na gha pa chiisu. ");
INSERT INTO ndh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Po bhuukagha ku bhandu bhooshi nu kubhapela ukubha bhamanyili bhangu. Mukabhombaghe ulwo ku sila iya kumwosha ghweshi umundu mu ngamu iya Taata uChaala, iya Mwana ni ya Mbepo uMwelu. ");
INSERT INTO ndh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mukabhamanyishange ukushikonga shooshi shiisho naabhalaghila umwe. Nuune indiimbange pamupeene nuumwe akabhalilo kooshi ukufika kubhumalilo ubhwa chiisu.”");
INSERT INTO ndh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ubhwandilo ubhwa Nongwa iNyiisa isha Yeesu Kilisiti uMwana ughwa Chaala bhwo ubhu. ");
INSERT INTO ndh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Inongwa ishi shikabhoneka isa muumwo shikasimbighwa mwa kalata ughwa musololi uYesaaya, uChaala akuti, “Tesha, ingumutuma ughwandumi ghwangu mundaashi yaako yuuyo indiakatendekeshe isila yaako.” ");
INSERT INTO ndh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Umundu akwitisha mu lungalangala akuti, ‘Tendekeshanga isila iya Malafyale, gholoshanga muumwo indiakaghendaghe.’ ” ");
INSERT INTO ndh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ughwandumi uyo akabha ghwi Yoohani uMwoshi. Akabhoneka mu lungalangala, akalumbililagha ukuti abhandu bhooshi bhiilaataghe imbiibhi nu kwoshighwa ukuti uChaala abhahobhokele imbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Po abhandu abhingi ukufuma mu kaaya aka Yelusaleemu na mu chiisu chooshi icha Yuteeya bhakabhuukagha kwa Yoohani. Bhakiilaatagha imbiibhi shaabho, ghwepe akabhooshanga mu lusooko ulwa Yoolotani. ");
INSERT INTO ndh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","UYoohani akafwalagha umwenda ghuughwo ghukasonighwa na meeya agha ngamila, akiipinyagha umukanda ughwa likwela mu musana ghwake. Soona akalyanga abhopaashi nu bhwuki ubhwa mu chitengele. ");
INSERT INTO ndh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Akalumbililagha ku bhandu akatingi, “Kunyuma kukwangu akwisa umundu ughwa maka ukuunginda une, yuuyo indabhaghiile ukubha mubhombi ghwake, soona indabhaghiile ukufulama nu kusatula utughoye utwa filato fyake. ");
INSERT INTO ndh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Une ingubhoosha na miishi gheene, loole umwene indiakabhooshange nu Mbepo uMwelu.” ");
INSERT INTO ndh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ku kabhalilo kala kala uYeesu akiisa ukufuma ku kaaya aka Naasaleeti iya mu chiisu icha Ghalilaayi, akabhuuka nu kumwagha uYoohani mula. Po uYoohani akamwosha mu lusooko ulwa Yoolotani. ");
INSERT INTO ndh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bhwo uYeesu akutiila ukufuma mu miishi, nakalinga akaagha kumwanya kwighuka, akamubhona uMbepo ughwa Chaala akwika pamwanya papaake ungati ngunda. ");
INSERT INTO ndh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Po ishu ukufuma kumwanya likapulikighwa likati, “Ughwe ghwe Mwana ghwangu umughanighwa, inguhobhoka nuughwe.” ");
INSERT INTO ndh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nakalinga, uMbepo ughwa Chaala akamulongosha uYeesu ukubhuuka ku lungalangala. ");
INSERT INTO ndh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","UYeesu akiikala kula kula amashiku amalongo manna (40) ukuti uSeetano amughele. Mu mashiku agho, akiikalagha pamupeene ni fikanu, soona abhandumi abha Chaala bhakiisa nu kumubhombela. ");
INSERT INTO ndh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","UYoohani akapinyighwa mu nyumba iya bhapinyighwa. Bhwo aapinyighwa, uYeesu akabhuuka mu chiisu icha Ghalilaayi, akalumbililagha iNongwa iNyiisa iya Chaala, ");
INSERT INTO ndh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","akatingi, “Akabhalilo kafikite, ichitangalala icha Chaala chipalamiile. Pindukagha nu kwilaata imbiibhi shiinyu nu kuyiitika iNongwa iNyiisa iya Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ishiku limo uYeesu akaghendagha kulubhafu kwa sumbi ughwa Ghalilaayi. Bhwo akughenda, akabhabhona abhalobha iswi bhabhili bhaabho bhakabha ghwi Siimoni nu munungʼuna uNdeleeya bhakuponia ifilepa mwa sumbi. ");
INSERT INTO ndh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Po uYeesu akabhiitisha akati, “Isagha muungongaghe une! Nuune indiimbabhiike ukubha bhalobha bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Po nakalinga, bhakafileka ifilepa fyabho, bhakamukonga. ");
INSERT INTO ndh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","UYeesu akaghenda pandaashi panandi pamupeene na bhamanyili bhaake bhabhili abho, akabhabhona abhandu bhabhili, uYaakobhu nu munungʼuna uYoohani, abhaana abha Sebhetaayi. Abhaana abho bhakabha mu bhwato, bhakatendekeshanga ifilepa fyabho. ");
INSERT INTO ndh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Akabhiitisha ukuti bhamukongaghe nu kubha bhamanyili bhaake. Po bhakamuleka ughwise mu bhwato pamupeene na bhabhombi nu kwanda ukumukonga uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","UYeesu na bhamanyili bhaake bhakabhuuka nu kufika mu kaaya aka Kapenabhumu. Bhwo lyafika ishiku ilya Sabhati, uYeesu akiingila mu sinaghoghi nu kwanda ukumanyisha. ");
INSERT INTO ndh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Abhandu bhooshi bhakaswigha leka ni fimanyisho fyake, paapo atakamanyishanga ungati bhamanyishi abha ndaghilo isha Moose, loole akamanyishanga ungati mundu yuuyo ali na maka. ");
INSERT INTO ndh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mu sinaghoghi mula, akabhaamwo umundu yumo yuuyo akakolighwa ni mbepo imbiibhi. Umundu uyo, akakuuta ku ishu ilya pamwanya ");
INSERT INTO ndh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akati, “Ghwe Yeesu ughwa kufuma ku Naasaleeti! Kali, tuli bhuki tweshi? Kali, ghwisile pakutupyuta? Naakumanya ukuti ughwe ghwe Mwelu ghwe ufumite kwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Loole uYeesu akayikemela imbepo imbiibhi yila akati, “Ghwe mbepo imbiibhi ughwe, sumba! Fumaamwo mu mundu uyu.” ");
INSERT INTO ndh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Po imbepo imbiibhi yila yikamuyungaania ku maka umundu yula, yikakuuta ku ishu ilya pamwanya nu kutiilaamwo mu mundu yula. ");
INSERT INTO ndh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Abhandu bhooshi bhakaswigha nu kubhuusania bheene-bheene bhakati, “Kali, mbombo shiki ishi shiisho tukushibhona? Kali, fimanyisho ifipya? Paapo umundu uyu akumanyisha ku maka, soona ali na maka agha kushilaghila ni mbepo imbiibhi, shoope shikumupulika!” ");
INSERT INTO ndh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Inongwa isha Yeesu shikafumukwa lubhilo mu twaya twoshi utwa mu chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nakalinga, uYeesu na bhamanyili bhaake, uYaakobhu, uYoohani, uSiimoni nu Ndeleeya bhakafumaamwo mu sinaghoghi nu kwingila mu nyumba iya Siimoni nu Ndeleeya. ");
INSERT INTO ndh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ungʼinafyala ughwa Siimoni akabha aghonite pa chitala ku nongwa iya sekema, po bhakamupangila uYeesu isha sekema yaake. ");
INSERT INTO ndh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Po uYeesu akapalamila papiipi, akamukola akakono nu kumwinula. Nakalinga, umukolo yula akapola isekema yila. Po akanyatuka nu kwanda ukumutendekeshekesha uYeesu ifindu. ");
INSERT INTO ndh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bhwo lyabha lya namasubha, abhandu bhakiisa kukwake na bhabhine abhingi na bhaabho bhakabha ni mbepo imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Po abhandu abhingi abha mu kaaya aka Kapenabhumu kala, bhakabhungaana pa mulyango ughwa nyumba iya Siimoni yila. ");
INSERT INTO ndh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","UYeesu akabhaposha abhandu abhingi bhaabho bhakabha na mabhine amingi nu kushikiisha imbepo imbiibhi inyingi, loole atakashiitikisha imbepo shila ukuyugha, paapo shikabha shimumeenye ukuti umwene Mwana ghwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ishiku ilya ningeelo pangeelo ngaani bhwo kukaali ukucha, uYeesu akatiila nu kubhuuka pabhuyo ubhushiifu, akaanda ukwipuuta. ");
INSERT INTO ndh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bhwo uSiimoni na bhanine bhaagha uYeesu ataliimwo mu nyumba yila, bhakabhuuka pakumulonda. ");
INSERT INTO ndh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bhwo bhaamwagha, bhakamubhuula bhakati, “Ghwe Mumanyishi, abhandu abhingi ngaani bhakukulonda.” ");
INSERT INTO ndh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Umwene akabhabhuula akati, “Tubhuuke ku bhandu abha mu twaya utunine tuutwo tuli papiipi na kaaya aka, ukuti kwope inje indumbilile iNongwa iNyiisa paapo iyi yo yiiyo mbombo niisile pakuyibhomba.” ");
INSERT INTO ndh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Po akabhuuka nu kughenda mu twaya twoshi utwa mu Ghalilaayi nu kulumbilila mu masinaghoghi ghaabho nu kushikiisha imbepo imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Po umundu yumo yuuyo akabha ni mbungo iya makete, akabhuuka kwa Yeesu, akafughamila pandaashi papaake nu kumusuuma akati, “Ghwe Malafyale, linga ghwighanite, ubhaghiile ukuunyeelufya.” ");
INSERT INTO ndh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ichisa chikamukola uYeesu, akagholosha akakono kaake, akamweghelesha, akati, “Niighanite, elupa.” ");
INSERT INTO ndh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nakalinga, imbungo iya makete yila yikatiila, umundu yula akeelupa. ");
INSERT INTO ndh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Po uYeesu akamubhuula ukuti abhuukaghe lubhilo nu kumusoka ku maka akati, ");
INSERT INTO ndh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Manye umubhuulaghe umundu naayumo. Loole bhuuka ghwilangishe ku mupuuti nu kufumya ifyabhupe ifya kupemba isa muumwo uMoose akalaghilila ukulangisha ukuti upolite.” ");
INSERT INTO ndh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Loole umundu yula atakasumba, akabhuuka nu kwanda ukufumusha pooshi pala paapo akabhuukagha inongwa isha muumwo uYeesu akamuposha. Ku nongwa iya nongwa isho, uYeesu akapootwa ukwingila pabhwelu mu kaaya kooshi kala. Loole akiikala kuuse kuukwo kutakabha na bhandu. Poope abhandu bhakiisagha kukwake ukufuma imbafu shooshi. ");
INSERT INTO ndh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bhwo amashiku manandi ghaakinda, uYeesu akabhuuka nu kwingila soona mu kaaya aka Kapenabhumu. Bhwo aafika, abhakaaya bhakapulika ukuti uYeesu aliimwo mu kaaya ako. ");
INSERT INTO ndh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Po bhakabhungaana, bhakiisula mu nyumba muumwo uYeesu akabhaamwo, bhutakashaala ubhuyo naabhumo ubhwa kwingilila pa mulyango. Mu kabhalilo ako, uYeesu akalumbililagha ishu ilya Chaala kukwabho. ");
INSERT INTO ndh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bhwo ali pakulumbilila, abhandu bhamu bhanna bhakiisa kwa Yeesu nu mundu yuuyo akabha alalite bhwo bhamupimbite. ");
INSERT INTO ndh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Abhandu abho bhatakabhwagha ubhuyo ubhwa kwingilila pa mulyango ukuti bhamwingishe nu kumubhiika umubhine uyo kwa Yeesu ku nongwa iya kuti abhandu bhakabha bhingi leka. Po bhakakwela nu mubhine yula pa kasale pa nyumba nu kunyolola pa kasale paapo uYeesu akabha nu kumwilomusha mu bhulili bhuubhwo akaghonela. ");
INSERT INTO ndh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bhwo uYeesu aatesha ulwitiko lwabho, akamubhuula umundu ughwa bhulale yula akati, “Ghwe mwana ghwangu, ghwahobhokelighwa imbiibhi shaako.” ");
INSERT INTO ndh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Abhamanyishi abha ndaghilo isha Moose bhamu bhakabhaamwo mu nyumba yila. Bhwo bhaapulika uYeesu aayugha inongwa isho, bhakiinongʼona mu ndumbula shaabho bhakati, ");
INSERT INTO ndh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Pulikisha! Kali, kooni umundu uyu akuyugha ulwo? Akumufuyula uChaala! Ataliipo umundu ughwa kuhobhokela imbiibhi, loole uChaala mwene.” ");
INSERT INTO ndh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nakalinga uYeesu akashaaghania shila shiisho bhakiinongʼonagha mu ndumbula shaabho, akabhabhuusha akati, “Kali, kooni mukwinongʼona isho mu ndumbula shiinyu? ");
INSERT INTO ndh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kali, liliku liilyo lipepe ngaani, ukumubhuula ughwa bhulale ukuti, ‘Ghwahobhokelighwa imbiibhi shaako,’ pamu ukumubhuula ukuti, ‘Nyatuka, pimba ubhulili bhwako, ghendagha’? ");
INSERT INTO ndh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Loole indiimuposhe umundu uyu ukuti mumanye ukuti uMwana ughwa Mundu ali na maka mu chiisu ichi ukuhobhokela imbiibhi.” Po akamubhuula umundu ughwa bhulale yula akati, ");
INSERT INTO ndh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ghwe mwana ghwangu, ingukubhuula, nyatuka, pimba ubhulili bhwako, bhuukagha kukaaya kaako.” ");
INSERT INTO ndh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nakalinga, umundu yula akanyatuka, akapimba ubhulili bhwake nu kufumaamwo mu nyumba yila bhwo abhandu bhooshi bhakutesha. Abhandu bhooshi bhakaswigha nu kumupaala uChaala bhakati, “Tutashibhweniimwo naalumo isa shishiishi.” ");
INSERT INTO ndh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","UYeesu akatiila nu kubhuuka soona kulubhafu kwa sumbi ughwa Ghalilaayi. Abhandu abhingi bhakabhuuka kukwake, ghwepe akaanda ukubhamanyisha. ");
INSERT INTO ndh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","UYeesu akatiilaapo pabhuyo bhula nu kubhuuka kulubhafu kwa sumbi. Bhwo akughenda, akamubhona uLaabhi, umwana ughwa Alufeeyo, yuuyo akabha musongesha songo, iikiile mu nyumba muumwo akasongeshanga isongo. UYeesu akamubhuula akati, “Ghwe Laabhi, ingongaghe.” Nakalinga, uLaabhi akanyatuka, akafileka fyoshi, akaanda ukumukonga uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","UYeesu na bhamanyili bhaake bhakabhuuka pakulya ifindu kukaaya aka Laabhi. Abhasongesha songo abhingi na bhatulanongwa abhingi bhaabho bhakamukongagha uYeesu bhakalyanga pamupeene nabho. ");
INSERT INTO ndh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Abhamanyishi abha ndaghilo isha Moose bhaabho bhakabha Bhafalisaayi, bhakabhaapo pala. Bhwo bhaamubhona uYeesu akulya na bhasongesha songo na bhatulanongwa, bhakabhabhuusha abhamanyili bhaake bhakati, “Kali, kooni uYeesu akulya pamupeene na bhasongesha songo na bhatulanongwa?” ");
INSERT INTO ndh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bhwo uYeesu aapulika amashu ghaabho, akabhaamula akati, “Abhandu bhaabho bhataa bhabhine bhatakumulonda umughanga, loole abhabhine bho bhaabho bhakumulonda umughanga. Indakiisa pakubhiitisha abhandu bhaabho bhakubhomba shiisho shibhaghiile pandaashi pa Chaala, loole ingiisa pakubhiitisha abhandu bhaabho bhatulanongwa.” ");
INSERT INTO ndh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lukabha lwiho ulwa bhamanyili abha Yoohani na bha Bhafalisaayi ukwiyiima ukulya ifindu mu tubhalilo tumo. Po ishiku limo abhandu bhamu bhakiisa kwa Yeesu, bhakamubhuusha bhakati, “Kali, kooni abhamanyili abha Yoohani na bha Bhafalisaayi bhakwiyiima ukulya ifindu, loole abhamanyili bhaako bhatakwiyiima ukulya ifindu?” ");
INSERT INTO ndh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","UYeesu akabhaamula akati, “Linga yuuyo akwegha ali pamupeene na bhaabho bhabhapaaliile ku bhweghi, kali, bhabhaghiile bhuleele ukwiyiima ukulya ifindu? Akabhalilo kooshi kaako yuuyo akwegha ali pamupeene nabho, bhatabhaghiile ukwiyiima ukulya ifindu. ");
INSERT INTO ndh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Loole mu mashiku ghaagho ghakwisa, abhandu indibhakamutiishe yuuyo akwegha, po abhaheesha bhaake abho indibhakiiyiime ukulya ifindu. ");
INSERT INTO ndh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ataliipo umundu yuuyo akusona ichilaka ichipya pa mwenda umukuulu. Paapo ichilaka ichipya chibhaghiile ukulekaana nu mwenda umukuulu ghula. Ghwope umwenda umukuulu ghula ghubhaghiile ukunyaapuka ngaani. ");
INSERT INTO ndh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Soona ataliipo umundu yuuyo akubhiika indifaayi imbya mu nyambi isha likwela ikuulu. Paapo linga aabhomba ulwo, indifaayi yila yikunyaapula inyambi, yikukupuka yooshi ni nyambi shoope shikukomanika. Loole indifaayi indeta bhakuyibhiika mu nyambi isha likwela ipya.” ");
INSERT INTO ndh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ishiku limo ilya Sabhati, uYeesu na bhamanyili bhaake bhakaghendagha mu sila yiiyo yikaghenda pakati pa mighunda iya ngano. Bhwo bhakughenda mu mighunda yila, abhamanyili bhaake bhakaanda ukuposola ifisaasali ifya ngano nu kwanda ukulya iseke shaake. ");
INSERT INTO ndh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ABhafalisaayi bhamu bhaabho bhakabhaapo pala, bhakabhabhona abhamanyili abha Yeesu shiisho bhakabhombagha, bhakamubhuusha uYeesu bhakati, “Kali, kooni abhamanyili bhaako bhakubhomba shiisho indaghilo isha Moose shitakwitikisha ukubhomba pi ishiku ilya Sabhati?” ");
INSERT INTO ndh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","UYeesu akabhabhuusha akati, “Kali, mutabhelengite mu Masimbo aMeelu muumwo uNdaabhiti na bhanine bhakabhombela bhwo isala yaabhabhabha? ");
INSERT INTO ndh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pa kabhalilo kala umupuuti usongo akabha ghwi Abhiyatali. UNdaabhiti akafika nu kwingila mu Nyumba iya Chaala nu kwegha imikati yiiyo yikabhiikighwa pandaashi pa Chaala. Naayumo umundu yuuyo indaghilo isha Moose shikamwitikishanga ukulya imikati yila, loole abhapuuti bheene. Loole uNdaabhiti akeegha nu kulya imikati yila, ghwepe akabhapa abhanine, bhakalya pamupeene.” ");
INSERT INTO ndh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Akeendelela ukuyugha akati, “Abhandu bhatakapelighwa ku nongwa iya lishiku ilya Sabhati, loole ishiku ilya Sabhati likapelighwa ku nongwa iya bhandu. ");
INSERT INTO ndh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ku nongwa iyi, uMwana ughwa Mundu ali na maka na pi ishiku ilya Sabhati.” ");
INSERT INTO ndh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ishiku inine ilya Sabhati, uYeesu akiingila mu sinaghoghi yimo. Mu sinaghoghi mula, akabhaamwo umundu yumo yuuyo akabha na kakono akalale. ");
INSERT INTO ndh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Soona mu sinaghoghi mula, bhakabhaamwo aBhafalisaayi bhaabho bhakamufwimagha uYeesu ukuti bhateshe linga indiamuposhe umundu yumo pi ishiku ilya Sabhati. Bhakabhomba ulwo, ukuti bhayaaghe isila iya kumusitaaka. ");
INSERT INTO ndh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","UYeesu akamulaghila umundu ughwa kakono akalale yula akati, “Ghwe mumanyani ghwangu, nyatuka, iima pakati pa bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Po uYeesu akabhabhuusha aBhafalisaayi bhala akati, “Kali, liliku liilyo indaghilo isha Moose shikwitikisha ukubhomba pi ishiku ilya Sabhati? Kali, ukubhomba inyiisa pamu ukubhomba imbiibhi? Kali, ukubhupoka ubhwumi pamu ukubhughogha?” Loole abheene bhakasumbaashe. ");
INSERT INTO ndh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","UYeesu akabhatesha ku lyoyo, soona akaswimaana ku nongwa iya bhukafu ubhwa ndumbula shaabho. Po akamubhuula umundu yula akati, “Ghwe mumanyani ghwangu, gholosha akakono kaako.” Ghwepe akagholosha akakono akalale kala, kakapola lwoshi. ");
INSERT INTO ndh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nakalinga, aBhafalisaayi bhakafuma kuuse nu kubhuuka ku bhakongi abha malafyale uHelooti uAntipa ukuti bhayughisanie muumwo bhabhaghiile ukumughoghela uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Po uYeesu na bhamanyili bhaake bhakatiilaapo pabhuyo bhula, bhakabhuuka kwa sumbi ughwa Ghalilaayi. Ichilundilo ichikulu icha bhandu ukufuma mu chiisu icha Yuteeya chikamukongagha. ");
INSERT INTO ndh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bhwo abhandu abhingi ngaani bhaapulika shiisho uYeesu akashibhombagha, bhakaanda ukwisa kukwake ukufuma mu kaaya aka Yelusaleemu, mu chiisu icha Yuteeya ni cha Itumeeya. Abhanine bhakafumagha mubhuyo ubhunine ukufuma ku isiila ilya lusooko ulwa Yoolotani na mumbafu shooshi isha mu twaya utwa Tiilo nu twa Sindoni. ");
INSERT INTO ndh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ku nongwa iya chilundilo ichikulu icha bhandu, uYeesu akabhabhuula abhamanyili bhaake ukuti bhamubhiikile ubhwato papiipi ukuti abhandu abhingi manye bhamufinyaghe bhwo akumanyisha. ");
INSERT INTO ndh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","UYeesu akabhaposha abhandu abhingi bhaabho bhakabha bhabhine. Yo yiiyo nongwa iyi abhabhine bhooshi bhakafinyanagha nu kubhuuka kukwake ukuti bhamwegheleshe. ");
INSERT INTO ndh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Akabhalilo kooshi ako abhandu bhaabho bhakabha ni mbepo imbiibhi bhwo bhaamubhona uYeesu, bhakaghwanga pandaashi papaake nu kukuuta ku ishu ilya pamwanya bhakatingi, “Ughwe ghwe Mwana ughwa Chaala!” ");
INSERT INTO ndh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Loole umwene akabhakaanisha ku maka ngaani ukuti manye bhamufumushange ku bhandu. ");
INSERT INTO ndh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Po uYeesu akakwela pa kaghamba, akabhiitisha abhandu bhaabho akabhalondagha, bhoope bhakabhuuka paapo akabha. ");
INSERT INTO ndh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Akabhasala abhandu kalongo na bhabhili, akabhapa ingamu ukubha bhatumighwa ukuti bhabhange pamupeene naghwe nu kuti abhatumaghe pakulumbilila. ");
INSERT INTO ndh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Soona akabhapa amaka agha kushikiisha imbepo imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Abhandu bhaabho akabhasala bho abha: uSiimoni yuuyo uYeesu akamupa ingamu iya Peeteli, ");
INSERT INTO ndh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","uYaakobhu umwana ughwa Sebhetaayi nu Yoohani umunungʼuna ughwa Yaakobhu, bhaabho uYeesu akabhapa ingamu iya Bhobhaneeghe, kwo kuti, “Bhaana bha Kughilima.” ");
INSERT INTO ndh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Soona akabhiitisha uNdeleeya, uFilipu, uBhatolomaayi, uMataayi, uToomasi, uYaakobhu umwana ughwa Alufeeyo, uTandaayi, uSiimoni uMukananaayi ");
INSERT INTO ndh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nu Yuuta Isikaliyooti yuuyo pabhumalilo akamubhiika uYeesu mu tukono utwa bhalughu. ");
INSERT INTO ndh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Po uYeesu na bhamanyili bhaake bhakaghaluka ku kaaya kuukwo bhakiikalagha. Akabhalilo ako ichilundilo icha bhandu chikabhungaana soona. Ku nongwa iya chilundilo icho, uYeesu na bhamanyili bhaake bhakapootwa nu kulya ifindu paapo bhakabhabhombelagha abhandu abho. ");
INSERT INTO ndh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bhwo abhakamu bhaake bhaapulika shiisho uYeesu akashibhombagha, bhakabhuuka pakumwegha, paapo bhakiinongʼona ukuti ali ni chighili. ");
INSERT INTO ndh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Abhamanyishi abha ndaghilo isha Moose ukufuma mu kaaya aka Yelusaleemu bhaabho bhakabhaapo pala, bhakayugha bhakati, “UYeesu akoliighwe nu Bhelisebhuli yuuyo ghwi songo ughwa mbepo imbiibhi. Soona akushikiisha imbepo imbiibhi ukubhombela amaka agha songo uyo.” ");
INSERT INTO ndh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Po uYeesu akabhiitisha abhandu bhala, akabhabhuusha ku fifwanikisho akati, “Kali, uSeetano abhaghiile bhuleele ukwikiisha? ");
INSERT INTO ndh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Linga abhandu abha bhunyafyale bhumobhwene bhaayabhanika, po ubhunyafyale ubhwo bhutabhaghiile ukwendelela. ");
INSERT INTO ndh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bhubhuubhwo, linga abhandu abha nyumba yimoyeene bhakulwa, inyumba iyo yitabhaghiile ukwendelela. ");
INSERT INTO ndh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Linga uSeetano nu bhunyafyale bhwake bhakulwa bheene-bheene, ubhunyafyale ubhwo bhutabhaghiile ukwendelela, bhwope bhukushila. ");
INSERT INTO ndh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ataliipo umundu yuuyo abhaghiile ukwingila mu nyumba iya mundu ughwa maka nu kwegha utundu twake linga ataamupinya taashi. Loole linga aatanga taashi ukumupinya umundu ughwa maka yula, po abhaghiile ukwegha utundu twake. ");
INSERT INTO ndh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nalooli ingubhabhuula ukuti linga abhandu bhakubhafuyula abhanine nu kubhomba imbiibhi, uChaala indiakabhahobhokele imbiibhi shaabho shooshi. ");
INSERT INTO ndh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Loole umundu ghweshi yuuyo akumufuyula uMbepo uMwelu, ataaakahobhokelighwe naalumo. Umundu uyo ghwe yuuyo indiakabhe ni mbiibhi iyo bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","UYeesu akayugha ulwo paapo bhakamuyughagha ukuti akoliighwe ni mbepo imbiibhi, loole umwene akashikiishanga imbepo imbiibhi ku maka agha Mbepo uMwelu. ");
INSERT INTO ndh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ungʼina ughwa Yeesu na bhoghwamwabho bhakiisa nu kwima kuuse ku nyumba yiiyo uYeesu akabhaamwo. Po bhakamutuma umundu ukuti amwitishe uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Abhandu abhingi bhakiikala nu kumushunguulila uYeesu. Po bhakamubhuula bhakati, “Ghwe Yeesu, unyoko na bhoghwamwinyu bhiimite kuuse, bhakukulonda.” ");
INSERT INTO ndh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","UYeesu akabhaamula akati, “Kali, umaayi na bhoghwamwitu bho bhooni?” ");
INSERT INTO ndh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Akabhatesha abhandu bhala bhaabho bhakiikala papiipi naghwe, akabhabhuula akati, “Tesha, umaayi na bhoghwamwitu bho abha! ");
INSERT INTO ndh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Umundu ghweshi yuuyo akulipulika ishu ilya Chaala nu kulibhombela imbombo, uyo ghwe yuuyo ghwi ghwamwitu, mulumbu ghwangu soona ghwi maayi ughwa nalooli.” ");
INSERT INTO ndh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ishiku inine uYeesu akabhuuka soona kulubhafu kwa sumbi nu kwanda ukubhamanyisha abhandu. Ku nongwa iya chilundilo ichikulu icha bhandu bhaabho bhakamushunguulila, akakwela mu bhwato nu kwikala mula mula ukuti abhwaghe ubhuyo ubhwa kubhamanyisha. Loole abhandu bhooshi bhakiikala pa chiisu ichikafu kulubhafu kwa sumbi. ");
INSERT INTO ndh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","UYeesu akamanyishanga inongwa inyingi ku sila iya fifwanikisho akatingi, ");
INSERT INTO ndh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Umulimi yumo akabhuuka pakupesa imbeyu. ");
INSERT INTO ndh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bhwo ali pakupesa, imbeyu shimo shikaghwa mu sila, utuyuni tukiisa nu kulya. ");
INSERT INTO ndh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Imbeyu inine shikaghwa pi ilongwi liilyo likabha ni lyalabhwe paase. Imbeyu isho shikamela lubhilo. Loole ku nongwa iya kuti ilongwi likabha linandi pamwanya, ");
INSERT INTO ndh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","bhwo akamu kaabhala, imbeyu isho shikafwoka nu kwuma ku nongwa iya kuti imishu yaake yikabha pamwanyaashe. ");
INSERT INTO ndh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Imbeyu inine shikaghwa pakati pa myifwa. Bhwo imbeyu shila shaanda ukukula, imyifwa yoope yikakula lubhilo nu kushishighila imbeyu. Ku nongwa iya kuti imyifwa yikashipuuta imbeyu shila, shitakeela iseke naashimo. ");
INSERT INTO ndh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Imbeyu inine shikaghwa pi ilongwi ilyisa. Imbeyu isho shikamela, shikakula nu kwela iseke inyingi. Imbeyu shimo, shikeela iseke amalongo matatu (30). Inine, iseke amalongo mahaano na limo (60), ni nine iseke imya yimo (100).” ");
INSERT INTO ndh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Po uYeesu akabhabhuula abhandu bhala akati, “Umundu yuuyo ali ni fyufwo, apulikishange nu kushaaghania.” ");
INSERT INTO ndh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Bhwo ichilundilo icha bhandu chila chaatiila, uYeesu akashaala pamupeene na bhamanyili bhaake na bhandu abhanine bhaabho bhakamukongagha. Po bhakamubhuusha isha fifwanikisho fila. ");
INSERT INTO ndh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Umwene akabhaamula akati, “UChaala abhasetuliile umwe inongwa isha ku bhushiifu isha chitangalala chaake. Loole abhandu abhanine bhala bhaabho bhatakuungonga, indiimbamanyishange ku sila iya fifwanikisho, ");
INSERT INTO ndh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ukuti shibhombighwe shiisho shisimbiighwe mu Masimbo aMeelu ukuti, ‘Indibhateshange loole bhataabhashibhonaghe. Indibhapulikaghe loole bhataabhashaaghaniange, ukuti manye bhakapinduke nu kuhobhokelighwa.’ ” ");
INSERT INTO ndh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Po uYeesu akabhabhuusha abhamanyili bhaake akati, “Kali, linga nuumwe mutakuchaaghania ichifwanikisho ichi, po mubhaghiile bhuleele ukufyaghania ififwanikisho ifinine? ");
INSERT INTO ndh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Umulimi yula yuuyo akapesagha imbeyu agheliile nu mundu yuuyo akulumbilila ishu ilya Chaala ku bhandu. ");
INSERT INTO ndh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abhandu bhamu bhagheliile ni mbeyu shila shiisho shikaghwa mu sila. Abhandu abho bho bhala bhakupulika ishu ilya Chaala nu kulibhiika mu ndumbula shaabho, loole nakalinga uSeetano akwisa nu kulitiisha ishu ilyo. ");
INSERT INTO ndh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Abhandu abhanine bhagheliile ni mbeyu shila shiisho shikaghwa pi ilongwi liilyo likabha ni lyalabhwe paase. Abhandu abho bho bhala bhakupulika ishu ilya Chaala, nakalinga bhakulipokeela lubhilo ku lusekelo. ");
INSERT INTO ndh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Loole ishu litakwikalaamwo nu kukola akiisa mu ndumbula shaabho, po likwikala ku kabhalilo akapimbaashe isa imishu iya mbeyu isho. Linga indamyo inyingi shaabhaagha ku nongwa iya kulipokeela ishu ilyo, abhandu abho bhakuleka ukulyitika. ");
INSERT INTO ndh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abhandu abhanine bhagheliile ni mbeyu shila shiisho shikaghwa pakati pa myifwa. Abhandu abho bho bhala bhaabho bhakupulika ishu. ");
INSERT INTO ndh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Loole ku nongwa iya kwinongʼona ngaani isha mu chiisu ichi pamu ukushimbulighwa ni finyonywa ifya bhukabhi pamu ukubha nu tundu utwingi, shooshi isho shikulishighila ishu ukuti manye lipaapaghe iseke. ");
INSERT INTO ndh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Loole abhandu abhanine bhagheliile ni mbeyu shila shiisho shikaghwa pi ilongwi ilyisa. Abhandu abho bho bhala bhaabho bhakupulika ishu nu kulipokeela, lyope ishu likwela iseke mu ndumbula shaabho. Umundu yumo akupaapa iseke amalongo matatu (30), umunine akupaapa iseke amalongo mahaano na limo (60) nu munine akupaapa iseke imya yimo (100).” ");
INSERT INTO ndh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","UYeesu akeendelela ukubhabhuula abhandu, akabhabhuusha akati, “Kali, ghwini yuuyo akukosha inyaale nu kuyiifunikila ni chipombo pamu akuyibhiika paase pa chitala? Kali, atakuyikosha nu kuyibhiika pamwanya pa chitalati ukuti yibhalishange kwoshi? ");
INSERT INTO ndh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Akandu kooshi kaako katali pabhwelu, indikakasetulighwe, bhubhuubhwo akandu kooshi kaako kafifiighwe, indikakabhiikighwe pabhwelu. ");
INSERT INTO ndh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Umundu yuuyo ali ni fyufwo, apulikishange nu kushaaghania.” ");
INSERT INTO ndh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","UYeesu akabhabhuula soona akati, “Pulikishanga akiisa shiisho ingubhabhuula. Paapo ichipimilo chiicho mukubhapimila abhanine, cho chiicho uChaala indiakabhapimile nuumwe nu kwongelaapo. ");
INSERT INTO ndh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Paapo umundu yuuyo akufipulika ifimanyisho fyangu nu kufyaghania, uChaala akumwafwa ukushaaghania ngaani. Loole yuuyo atakufipulika nu kufyaghania, uChaala akumupoka na kanandi kaako akukaaghania.” ");
INSERT INTO ndh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","UYeesu akabhabhuula ichifwanikisho ichinine akati, “Ichitangalala icha Chaala chili ulu. Umundu yumo akapesa imbeyu mu mughunda ghwake. ");
INSERT INTO ndh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bhwo aapesa, akaghona utulo pabhushiku. Ishiku ilya ningeelo pangeelo bhwo aalamusha, akaagha imbeyu shila shimelite nu kukula, loole umulimi atakumanya muumwo imbeyu shikumelela nu kukula. ");
INSERT INTO ndh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ilongwi lyene lyo liilyo likushimesha imbeyu, imbeyu iyo yikutulula ilyani iteta, chikukonga ichisaasali, pabhumalilo yikwela iseke mu chisaasali. ");
INSERT INTO ndh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bhwo akabhalilo aka kwinula kaafika, umundu akwegha ichakwinulila nu kubhuuka pakwinula.” ");
INSERT INTO ndh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","UYeesu akeendelela ukuyugha akati, “Kali, indiifwanikishe ichitangalala icha Chaala na kandu akanine kaliku? Pamu kali, indiimbombele ichifwanikisho ichinine chiliku? ");
INSERT INTO ndh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ichitangalala icha Chaala chigheliile ni seke isha nambamba shiisho nandi ukukinda iseke shooshi shiisho abhandu bhakubhyala mu mighunda. ");
INSERT INTO ndh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Loole linga bhaabhyala, akaseke aka nambamba kakumela, kakukula nu kubha kakulu ukukinda amakokwe agha mbeyu shooshi isha libhogha. Utusamba utwa likokwe ilya nambamba uyo tukubha tukulu. Utuyuni twope tubhaghiile ukutenga ififumbo mu tusamba utwo.” ");
INSERT INTO ndh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","UYeesu akabhamanyishanga mu fifwanikisho ifyingi isa ifyo ukukongana na muumwo bhakapulikilagha nu kushaaghania. ");
INSERT INTO ndh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Umwene atakabhamanyishanga chishita kubhombela ififwanikisho. Loole akabhalilo kaako akabhanga pamupeene na bhamanyili bhaake ku bhushiifu, akabhalingaanianga shooshi pabhwelu. ");
INSERT INTO ndh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ishiku lila lila bhwo lyabha lya namasubha, uYeesu akabhabhuula abhamanyili bhaake akati, “Isagha tulobhoke usumbi, tuye ku isiila.” ");
INSERT INTO ndh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Po bhakachileka ichilundilo icha bhandu. Abhamanyili bhaake bhakiingila mu bhwato muumwo uYeesu akabha. Abhandu abhanine bhakiingila mu maato amanine nu kulongosania pamupeene nabho. ");
INSERT INTO ndh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nakalinga, ichikungu chikiisa na maka, inguli shikaanda ukubhukoma-koma ubhwato bhula na miishi ghakaanda ukwisula mu bhwato. ");
INSERT INTO ndh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Akabhalilo ako uYeesu akabha aghonite kunyuma ku bhwato nu kupitila bhwo abhiikite umutu ghwake pa chiinulilo. Po abhamanyili bhaake bhakamulamusha nu kumubhuusha bhakati, “Ghwe Mumanyishi! Kali, utakusaaghilaapo ukuti tukuya pakufwa?” ");
INSERT INTO ndh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","UYeesu akalamusha nu kuchikemela ichikungu chila, akashilaghila inguli isha mwa sumbi akati, “Mwe nguli umwe, sumba! Mubhe myee!” Po inguli shikasumba, kukabhoteela, kukabha myee. ");
INSERT INTO ndh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Po uYeesu akabhabhuusha abhamanyili bhaake akati, “Kali, kooni mukwoghopa leka? Kali, nu ulu mukaali mutali nu lwitiko?” ");
INSERT INTO ndh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Abhamanyili bhaake bhakooghopa leka, bhakabhuusania bheene-bheene bhakati, “Kali, ghwini uyu yuuyo ichikungu ni nguli isha mu nyanja, fikumupulika?” ");
INSERT INTO ndh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","UYeesu na bhamanyili bhaake bhakalobhoka nu kufika ku isiila inine ilya sumbi ughwa Ghalilaayi, mu chiisu icha Bhaghelaasi. ");
INSERT INTO ndh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bhwo uYeesu iika mu bhwato, nakalinga umundu yumo yuuyo akakolighwa ni mbepo imbiibhi, akafuma ku mapumba nu kubhuuka pakukomaana nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Umundu uyo akiikalagha ku mapumba. Akabha na maka leka, atakabhaapo umundu naayumo ughwa kumupinya nalinga kwo kubhombela iminyololo. ");
INSERT INTO ndh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Utubhalilo utwingi bhakamupinyagha ni mbingu ni minyololo, poope akalatulanianga fyoshi. Soona atakabhaapo umundu naayumo ughwa maka agha kumupoota. ");
INSERT INTO ndh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Amashiku ghooshi pamuusi na pabhushiku, umundu ughwa mbepo yula akashunguulilagha ku mapumba na mu tughamba, akayweghagha leka, soona akiibheghanianga na mayondo. ");
INSERT INTO ndh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bhwo aamubhona uYeesu pabhutali, akamukindilila nu kufughamila pandaashi papaake. ");
INSERT INTO ndh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Bhwo uYeesu aamubhona, akayibhuula imbepo imbiibhi yila akati, “Ghwe mbepo imbiibhi ughwe, tiilaamwo mu mundu uyu!” Imbepo yila yikakuuta ku ishu ilya pamwanya yikati, “Ghwe Yeesu, Mwana ghwa Chaala Yuuyo Ali Pamwanya Ngaani, kali, indi ni nongwa yiki nuughwe? Ingukusuuma mu ngamu iya Chaala, manye ghuufulashange.” ");
INSERT INTO ndh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","UYeesu akayibhuusha akati, “Kali, ingamu yaako ghwe ghwini?” Imbepo yila yikamwamula yikati, “Ingamu yangu nee Leghiyooni, kwo kuti, tuli bhingi.” ");
INSERT INTO ndh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Po imbepo imbiibhi yila yikamusuuma ngaani uYeesu ukuti manye ashikiishange mu chiisu chila. ");
INSERT INTO ndh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bhwo isho shikubhombighwa, pabhutali panandi ghukabhaapo umutiimo umukulu ughwa ngulubhe shiisho shikalyanga mu bhwilomuka ubhwa kaghamba. ");
INSERT INTO ndh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Po imbepo imbiibhi shila shikamusuuma uYeesu shikati, “Tukukusuuma utwitikishe twingile mu ngulubhe shila.” ");
INSERT INTO ndh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Po uYeesu akashiitikisha. Imbepo imbiibhi shila shikatiilaamwo mu mundu yula nu kuya kwingila mu mutiimo ughwa ngulubhe shila. Umutiimo ghula ghukabha ni ngulubhe abhoelufu bhabhili (2,000). Ingulubhe shila shikakinda lubhilo mu bhwilomuka nu kughwila mwa sumbi nu kufwa shooshi. ");
INSERT INTO ndh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abhaliishi abha ngulubhe bhaabho bhakabhaapo pala, bhakakinda ukubhuuka mu twaya utukulu nu kushunguulila mu twaya utunandi ukulingaania shooshi shiisho bhakashibhona. Bhwo abhandu bhaapulika, bhakiisa pakutesha shiisho shikabhoneka. ");
INSERT INTO ndh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bhwo bhaafika kwa Yeesu, abhandu bhala bhakamwagha umundu yula yuuyo akabha aakoliighwe ni mbepo imbiibhi iikiile, afwalite imyenda, ali na mahala ghaake ghooshi, po bhakooghopa leka. ");
INSERT INTO ndh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Po abhandu bhaabho bhakabhaapo nu kushibhona shooshi isho, bhakabhapangila abhandu abhanine shiisho shikabhoneka ku mundu yuuyo akabha aakoliighwe ni mbepo imbiibhi pamupeene ni nongwa isha ngulubhe shila. ");
INSERT INTO ndh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Po abhakaaya bhakamusuuma uYeesu ukuti atiileemwo mu chiisu chaabho. ");
INSERT INTO ndh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bhwo akwingila mu bhwato, umundu yula yuuyo akakolighwa ni mbepo imbiibhi akamusuuma ukuti abhuukaghe pamupeene naghwe. ");
INSERT INTO ndh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","UYeesu atakamwitikisha ukubhuuka pamupeene naghwe, loole akamubhuula akati, “Bhuuka ku kaaya kaako na ku bhakamu bhaako, uye ubhabhuule imbombo shooshi shiisho uMalafyale uChaala aakubhombela na muumwo aakupelela ichisa.” ");
INSERT INTO ndh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Po umundu yula akabhuuka ku kaaya kaake na mu Ndekapooli, kwo kuti, “Utwaya kalongo (10),” nu kwanda ukufumusha imbombo ingulu shooshi shiisho uYeesu akamubhombela. Po abhandu bhooshi bhaabho bhakamupulikishanga, bhakaswighagha. ");
INSERT INTO ndh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","UYeesu na bhamanyili bhaake bhakiingila mu bhwato nu kulobhoka soona usumbi ukubhuuka ku isiila inine. Bhwo bhaafika ku isiila, ichilundilo ichikulu icha bhandu chikamushunguulila bhwo ali kulubhafu kwa sumbi. ");
INSERT INTO ndh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Po akiisa pala umundu yumo yuuyo ingamu yaake akabha ghwi Yayilo. UYayilo akabha ghwe yumo mu bhalongoshi abha sinaghoghi. Bhwo aamubhona uYeesu, akiiponia pa tulundi twake. ");
INSERT INTO ndh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akamusuuma uYeesu ngaani akati, “Ghwe Malafyale, umwana ghwangu umulindu mubhine leka, ali papiipi ukufwa. Ingukusuuma ghwise ubhiike utukono twako pamwanya papaake ukuti apole nu kwendelela ukubha mwumi.” ");
INSERT INTO ndh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Po uYeesu akaanda ukubhuuka pamupeene nu Yayilo kukaaya kaake. Ichilundilo ichikulu icha bhandu chikamukongagha nu kumufinya imbafu shooshi. ");
INSERT INTO ndh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mu chilundilo icho, akabhaamwo umukolo yumo yuuyo akabha nu bhubhine ubhwa kufuma ibhanda ku fyinja kalongo na fibhili (12). ");
INSERT INTO ndh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Umukolo yula akabha aataamighwa leka ku nongwa iya kubheeta ku bhaghanga abhingi nu kutaagha ichuuma chaake chooshi. Pamupeene nu kubhomba ulwo, poope ubhubhine bhwake bhutakapolagha, loole bhukoongelagha ukukinda kubhwandilo. ");
INSERT INTO ndh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Umukolo yula akabha apulikite inongwa isha Yeesu, po akaanda ukuselengania ichilundilo icha bhandu ukuti eegheleshe umwenda ughwa Yeesu kunyuma, ");
INSERT INTO ndh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","paapo akayugha mwene mu ndumbula yaake akati, “Linga naaghwegheleshaashe umwenda ghwake indiimbole.” ");
INSERT INTO ndh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Po bhwo eeghelesha, nakalinga ibhanda likuuma. Po umukolo yula akiibhona mu mubhili ghwake ukuti aapola. ");
INSERT INTO ndh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nakalinga, uYeesu akamanya ukuti amaka ghamu ghaatiila mu mubhili ghwake. Po akasanuka, akabhuusha akati, “Kali, ghwini yuuyo eeghelesha imyenda yangu?” ");
INSERT INTO ndh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abhamanyili bhaake bhakamwamula bhakati, “Ghwe Mumanyishi, nuughwe kuchibhona ichilundilo icha bhandu abhingi abha muumwo tukufinyana! Kali, tubhaghiile bhuleele ukumanya ukuti ghwini aakweghelesha?” ");
INSERT INTO ndh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Loole uYeesu akakelengania kuno na kuno ukuti amubhone yuuyo aamweghelesha. ");
INSERT INTO ndh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Umukolo yula akashaaghania ukuti abhandu indibhashimanye ukuti ghwe yuuyo amwegheleshiishe, akooghopa leka nu kubha nu lutende. Po akabhuuka nu kufughamila pandaashi pa Yeesu nu kuyugha ubhwanalooli bhwoshi. ");
INSERT INTO ndh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","UYeesu akamubhuula akati, “Ghwe mulindu, ghwapola ku nongwa iya kuti kuunyiitika une. Bhuukagha ku lutengaano, ghwapola ubhubhine bhwako.” ");
INSERT INTO ndh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bhwo uYeesu akaali ali pakuyugha, bhakiisa abhandu ukufuma kukaaya aka Yayilo, bhakamubhuula bhakati, “Ghwe songo, umwana ghwako umulindu aatuleka. Po manye ghwendelelaghe ukumutamya umumanyishi.” ");
INSERT INTO ndh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Loole bhwo uYeesu aabhapulika abhandu bhala akati, “Manye upaashange, endelelagha ukuunyiitika.” ");
INSERT INTO ndh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","UYeesu atakamwitikisha umundu naayumo ukukongana nabho, loole mwene uPeeteli, uYaakobhu nu Yoohani ughwamwabho ughwa Yaakobhu. ");
INSERT INTO ndh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bhwo bhaafika pakaaya aka songo yula, uYeesu akapulika umuywegho ughwa bhandu bhaabho bhakalilagha ku bhuswimaane ubhukulu. ");
INSERT INTO ndh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Po uYeesu akiingila mu nyumba nu kubhuusha akati, “Kali, kooni mukuywegha nu kulila? Umulindu uyu atafwile, loole apitiileeshe.” ");
INSERT INTO ndh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Loole abheene bhakamuseka nu kumufuuya uYeesu. Po uYeesu akabhafumya bhooshi kuuse, akamwegha ughwise nu ngʼina ughwa mulindu yula na bhamanyili bhaake, bhakiingila mu nyumba muumwo umulindu yula akabha. ");
INSERT INTO ndh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Po uYeesu akamukola akakono umulindu yula nu kumubhuula akati, “Talita kumi,” kwo kuti, “Mulindu, ingukubhuula, nyatuka.” ");
INSERT INTO ndh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nakalinga, umulindu yula akiima, akaanda ukughenda. Umulindu yula akabha ni fyinja kalongo na fibhili (12). Bhwo shaabhoneka shooshi isho, abhapaapi bhaake na bhandu bhaabho bhakabhaapo pala bhakaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Po uYeesu akabhakaanisha ngaani ukuti manye bhamubhuulaghe umundu naayumo, soona akabhabhuula ukuti bhamupe umulindu yula ifindu ukuti alye. ");
INSERT INTO ndh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","UYeesu na bhamanyili bhaake bhakatiilaapo pabhuyo bhula nu kubhuuka mu kaaya aka Naasaleeti kuukwo akakulilagha. ");
INSERT INTO ndh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bhwo ishiku ilya Sabhati lyafika, uYeesu akiingila mu sinaghoghi, akaanda ukumanyisha. Abhandu abhingi bhaabho bhakamupulikishanga, bhakaswigha leka, bhakabhuusha bhakati, “Kali, umundu uyu afyaghite kuughu ifimanyisho ifi? Kali, ghwini yuuyo amupiile amahala agha? Kali, abhaghiile bhuleele ukubhomba ifyika ifya kuswighisha ifi? ");
INSERT INTO ndh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kali, uyu ataa mupulula matapwa, umwana ughwa Maliiya na bhanungʼuna bhaake bhataa ghwi Yaakobhu, uYoose, uYuuta nu Siimoni? Kali, bhataa bhalumbu bhaake abha tukwikala nabho papiitu panu?” Po abhandu bhakiikinya nu kushita kumwitika. ");
INSERT INTO ndh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","UYeesu akabhabhuula akati, “Umusololi akughindikighwa na bhandu pooshi pala, loole atakughindikighwa na bhandu abha mu chiisu chaake, abhakamu bhaake na bha mu nyumba yaake.” ");
INSERT INTO ndh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","UYeesu atakabhomba ichiika naachimo kukwabho, loole akabhabhiikila utukono abhabhine bhanandi nu kubhaposha. ");
INSERT INTO ndh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","UYeesu akaswigha leka ku nongwa iya kushita kumwitika. Po akafuma mu kaaya aka Naasaleeti, akabhuuka nu kwanda ukushunguulila-shunguulila mu twaya utunandi utwa mupiipi nu kumanyisha abhandu. ");
INSERT INTO ndh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","UYeesu akabhiitisha abhamanyili bhaake kalongo na bhabhili (12) ukuti abhatume bhabhili bhabhili. Akabhapa amaka agha kukiisha imbepo imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akabhalaghila akati, “Manye mweghaghe naachimo ku nongwa iya sila yiinyu. Soona manye mweghaghe ifindu, inyambi pamu indalama mu ngobha shiinyu, loole mweghe ingoomo iya kughendela. ");
INSERT INTO ndh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Soona fwala ifilato, loole manye mweghaghe umwenda ughwa bhubhili ughwa kuchenjesania.” ");
INSERT INTO ndh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Akeendelela ukubhabhuula akati, “Mu kaaya kooshi kaako bhaaya bhaabhapokeela mu nyumba shaabho, mukiikalaghe mumuumwo ukufika paapo mukuya kutiila mu kaaya ako. ");
INSERT INTO ndh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Loole mu kaaya kooshi kaako bhaaya bhaakaana ukubhapokeela nu kubhapulikisha, linga mukuya kutiila mu kaaya ako, mukakungʼundaghe ulufumbi ulwa mu tulundi twinyu. Ukubhomba ulwo indibhukabhe bhukeeti ukuti uChaala indiakabhalonge ku nongwa iya kushita kwitika iNongwa iNyiisa.” ");
INSERT INTO ndh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Po abhamanyili bhakatiila nu kwanda ukulumbilila ku bhandu ukuti bhapinduke nu kushileka imbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Soona bhakashikiishanga imbepo imbiibhi inyingi, bhakabhapakagha inyemba abhabhine abhingi, bhoope bhakapolagha. ");
INSERT INTO ndh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Umalafyale uHelooti ghwepe akapulika imbombo isha Yeesu, paapo ingamu iya Yeesu yikafumukwa pooshi. Po akayugha akati, “Uyu ghwi Yoohani uMwoshi yuuyo ashuukite. Yo yiiyo nongwa iyi ali na maka agha kubhomba ifyika ifi.” ");
INSERT INTO ndh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Abhandu abhanine bhakatingi, “Umundu uyu musololi uEliiya.” Loole abhanine bhakatingi, “Uyu musololi ungati bhasololi abha bhwila bhala.” ");
INSERT INTO ndh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Loole umalafyale uHelooti bhwo aapulika, akati, “Uyu ghwi Yoohani uMwoshi yuuyo ingamuputula umutu, ghwe yuuyo ashuukite.” ");
INSERT INTO ndh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kubhwandilo uHelooti akamwegha uHelotiiya yuuyo akabha mukashi ughwa munungʼuna ghwake uFilipu. Po uYoohani uMwoshi akamubhuula uHelooti akati, “Indaghilo isha Moose shitakwitikisha ukumwegha umukashi ughwa munungʼuna ghwako.” UHelooti akatuma abhandu ukuti bhamukole uYoohani nu kumupinya mu nyumba iya bhapinyighwa ku nongwa iya Helotiiya. ");
INSERT INTO ndh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Po uHelotiiya akamubhenga uYoohani, akaanda ukumufwima ukuti amughoghe, loole akapootwanga. ");
INSERT INTO ndh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Akapootwanga ukumughogha ku nongwa iya kuti uHelooti akamushighililagha uYoohani paapo akamanya ukuti mundu mugholofu soona mwelu. UHelooti akiighana ukumupulikisha uYoohani, loole linga aamupulikisha, akaswimaanagha leka. ");
INSERT INTO ndh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kubhumalilo, uHelotiiya akayaagha isila iya kumughogha uYoohani. Ishiku ilya lusekelo ilya kupaapighwa ukwa malafyale uHelooti likafika. Po akaghiitisha amafumu ghaake ghaagho ghakamwafwanga, abhosongo abha bhashikali bhooshi na bhalongoshi abha mu chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Po umulindu ughwa Helotiiya akiingila nu kulebhela pandaashi papaabho, akamuhobhosha uHelooti na bhaheesha bhaake. Umalafyale uHelooti akamubhuula umulindu yula akati, “Ghwe mulindu, isuume une chooshi chiicho kulonda, nuune indiingupe.” ");
INSERT INTO ndh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Soona akaloolika akati, “Chooshi chiicho kulonda ghuusuume, nuune indiingupe, nalinga ghwasuuma ubhunyafyale bhwangu, indiinguyabhile pakati.” ");
INSERT INTO ndh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Po umulindu yula akafuma kuuse, akamubhuusha uHelotiiya ungʼina akati, “Ghwe maayi, kali, isuume kooni?” Ungʼina akamwamula akati, “Suuma umutu ughwa Yoohani uMwoshi.” ");
INSERT INTO ndh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Umulindu akaghaluka lubhilo kwa malafyale, akamusuuma akati, “Ingusuuma luluulu umutu ughwa Yoohani uMwoshi mu isiniya.” ");
INSERT INTO ndh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Umalafyale akaswimaana leka, loole ku nongwa iya kuloolika kwake na ku nongwa iya bhaheesha bhaake bhaabho akalyanga nabho, atakalondagha ukumukaanila. ");
INSERT INTO ndh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Po umalafyale akamulaghila ku maka umushikali yumo ukuti abhuuke, aputule umutu ughwa Yoohani nu kwisa naghwo. Umushikali akabhuuka mu nyumba iya bhapinyighwa nu kuputula umutu ughwa Yoohani. ");
INSERT INTO ndh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Umushikali yula akiisa nu mutu mu isiniya, akamupa umulindu, ghwepe umulindu akamupa ungʼina. ");
INSERT INTO ndh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bhwo abhamanyili abha Yoohani bhaapulika inongwa isho, bhakabhuuka nu kughwegha umubhili ughwa Yoohani nu kughushiila mu ipumba. ");
INSERT INTO ndh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Abhatumighwa bhala bhakaghaluka nu kubhungaana pandaashi pa Yeesu, bhakamubhuula shooshi shiisho bhakashibhombagha nu kumanyisha. ");
INSERT INTO ndh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ku nongwa iya bhandu abhingi bhaabho bhakiisagha nu kutiila, uYeesu na bhamanyili bhaake bhakapootwa akabhalilo aka kulya ifindu. Po uYeesu akabhabhuula akati, “Tubhuuke twiyeekele, tutuushe panandi.” ");
INSERT INTO ndh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Po bhakatiila pabhuyo pala, bhakiingila mu bhwato nu kubhuuka pabhuyo paapo patakabha na bhandu. ");
INSERT INTO ndh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Loole bhwo bhakubhuuka, abhandu abhingi bhakabhabhona nu kubhamanya. Po abhandu abhingi bhala ukufuma mu twaya twoshi, bhakakinda nu kubhatangila ukufika pabhuyo paapo uYeesu na bhamanyili bhaake bhakabhuukagha. ");
INSERT INTO ndh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bhwo uYeesu iika mu bhwato, akachibhona ichilundilo ichikulu icha bhandu. Akabhapelela ichisa ku nongwa iya kuti bhakabhoneka ungati bhonangʼooshi bhaabho bhatali nu muliishi. Po akaanda ukubhamanyisha inongwa inyingi. ");
INSERT INTO ndh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bhwo akabhalilo aka pamuusi kaakinda, abhamanyili bhaake bhakabhuuka kwa Yeesu, bhakamubhuula bhakati, “Ghwe Mumanyishi, pabhuyo panu patali nu twaya utwa bhandu, ulu ubhushiku bhwapalamila. ");
INSERT INTO ndh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tukukusuuma ubhalaghe abhandu ukuti bhabhuukaghe mu mighunda na mu twaya utunandi utwa mupiipi ukuti bhaye bhaghule ifindu.” ");
INSERT INTO ndh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Loole uYeesu akabhabhuula akati, “Umwe, bhape ifindu abhandu abha.” Abhamanyili bhakamubhuusha bhakati, “Kali, tubhuuke ni ndinaali imya shibhili (200) pakughula imikati iya kubhaliisha abhandu abhingi abha?” ");
INSERT INTO ndh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","UYeesu akabhabhuusha akati, “Kali, muli ni mikati milinga? Bhuuka muteshe.” Bhwo bhaatesha, bhakati, “Tuli ni mikati mihaano ni iswi shibhili.” ");
INSERT INTO ndh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Po uYeesu akabhalaghila abhamanyili bhaake ukuti bhabhabhuule abhandu bhooshi bhiikale mu fibhughutila pa chiposo. ");
INSERT INTO ndh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Abhandu bhala bhakiikala mu fibhughutila. Ifibhughutila fimo fikabha na bhandu imya yimo (100), ifinine fikabha na bhandu amalongo mahaano (50). ");
INSERT INTO ndh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Po uYeesu akeegha imikati mihaano yila ni iswi shibhili shila, akatesha kumwanya, akapaalisha kwa Chaala, akabheghulania imikati, akabhapa abhamanyili bhaake ukuti bhabhayabhile abhandu. Bhakabhayabhila abhandu bhooshi bhala iswi shibhili shila. ");
INSERT INTO ndh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Abhandu bhooshi bhakalya nu kwikuta. ");
INSERT INTO ndh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Po bhwo bhaalya, abhamanyili bhaake bhakabhungaania utubhululusha utwa mikati ni iswi shila nu kwisusha utupombo kalongo na tubhili (12). ");
INSERT INTO ndh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Abhandu bhaabho bhakalya imikati yila bhakabha abhaliisha abhoelufu bhahaano. ");
INSERT INTO ndh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nakalinga, uYeesu akabhalaghila abhamanyili bhaake ukuti bhiingile mu bhwato, bhatangile ukubhuuka ku kaaya aka Bheetisayita, ku isiila kwa sumbi bhwo umwene akuchilagha ichilundilo icha bhandu. ");
INSERT INTO ndh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bhwo aabhalagha abhandu, akabhuuka pa kaghamba pakwipuuta kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bhwo lyabha lya namasubha, ubhwato bhukabha pakati pa sumbi, loole uYeesu akabha mwene pa chiisu ichikafu. ");
INSERT INTO ndh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Po akabhabhona abhamanyili bhaake bhakutaamighwa ukufugha ubhwato paapo ichikungu chikabhaghalushanga kunyuma. Bhwo ubhushiku bhwapalamila ukucha, uYeesu akabhuuka ku bhamanyili bhaake bhwo akughenda pamwanya pa sumbi, akabhonekagha ungati akulonda ukubhapululila. ");
INSERT INTO ndh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Loole bhwo bhaamubhona uYeesu akughenda pamwanya pa miishi, bhakiinongʼonagha ukuti mushuuka, bhakakuuta inguuto. ");
INSERT INTO ndh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ku nongwa iya kuti bhooshi bhakamubhona, bhakooghopa ngaani. Nakalinga, uYeesu akayugha nabho akati, “Ikashanga, neene, manye mwoghopaghe.” ");
INSERT INTO ndh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Po uYeesu akiingila mu bhwato muumwo abhamanyili bhakabha, ichikungu chila chikabhoteela. Abhamanyili bhakaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Abheene bhakapootwa ukushaaghania isha chiika icha mikati yila paapo indumbula shaabho shikabha ngafu. ");
INSERT INTO ndh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bhwo uYeesu na bhamanyili bhaake bhaalobhoka usumbi ughwa Ghalilaayi, bhakafika ku chiisu icha Ghenesaleeti, bhakabhupinya ubhwato ku chiseese ukuti manye bhughendaghe. ");
INSERT INTO ndh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bhwo bhakufuma mu bhwato, nakalinga abhandu bhakamumanya uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bhakabhuuka lubhilo mu chiisu chila chooshi, bhakaanda ukubhapimba abhabhine bhaabho pa matembelo nu kubhuuka nabho pabhuyo pooshi paapo bhakapulikagha ukuti uYeesu akabhaapo. ");
INSERT INTO ndh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pooshi paapo uYeesu akabhuukagha mu twaya utunandi nu tukulu, abhandu bhakabhabhiikagha abhabhine mu minaalo. Bhakamusuumagha ukuti bhamwegheleshe nalinga chipeto icha mwenda ghwake. Abhabhine bhooshi bhaabho bhakeegheleshanga ichipeto icha mwenda ghwake, bhakapolagha. ");
INSERT INTO ndh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ishiku limo aBhafalisaayi bhamu na bhamanyishi abha ndaghilo isha Moose bhakiisa ukufuma mu kaaya aka Yelusaleemu nu kubhungaana pandaashi pa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bhakabhabhona abhamanyili bhaake bhamu bhaabho bhakalyanga ifindu nu tukono utunyali. ");
INSERT INTO ndh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Paapo aBhafalisaayi na Bhayuuta abhanine bhooshi bhatakulya ifindu chishita kusukusula akiisa ukukongana ni nyiiho isha bhosekulu bhaabho. ");
INSERT INTO ndh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Soona linga bhaafuma ku munaalo, bhakutanga taashi ukwiyeelufya umubhili ghwoshi, po bhalyange ifindu. Shiliipo ni nyiiho inine shiisho bhakashipokeela ukufuma ku kabhalilo aka kunyuma isa isha kusuka ifikombe, isefulila ni filiilo ifya kupiiyila. ");
INSERT INTO ndh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Po aBhafalisaayi na bhamanyishi abha ndaghilo isha Moose bhakamubhuusha uYeesu bhakati, “Ghwe Mumanyishi, kali, kooni abhamanyili bhaako bhatakukonga inyiiho isha bhosekulu bhiitu, loole bhakulya ifindu nu tukono utunyali?” ");
INSERT INTO ndh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","UYeesu akabhaamula akati, “Mwe bhongubhisania umwe! Umusololi uYesaaya akabha ghwa nalooli ukusimba inongwa shiinyu umwe paapo akasolola akati, uChaala akuti, ‘Abhandu abha bhakuungindika ku mashu gheene, loole indumbula shaabho shili kubhutali nuune. ");
INSERT INTO ndh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ukuunyiipuuta kwabho kwa pabhubhuushe! Paapo bhakumanyishanga ifimanyisho fiifyo ndaghilo sha bhandu.’ ” ");
INSERT INTO ndh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","UYeesu akeendelela ukubhabhuula akati, “Umwe mukushileka indaghilo isha Chaala, loole mukushikola inyiiho isha bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","UYeesu akoongela ukuyugha akati, “Umwe mukubhombela isila inyingi ukushikaana indaghilo isha Chaala ukuti mushikole inyiiho shiinyu. ");
INSERT INTO ndh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Paapo uMoose akalaghila akati, ‘Mughindikaghe ughuuso nu nyoko,’ soona akati, ‘Umundu yuuyo akumutuka ughwise pamu ungʼina akulondighwa ukughoghighwa.’ ");
INSERT INTO ndh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Loole umwe mukubhamanyisha abhandu mukuti, kiisaashe linga umundu akumubhuula ughwise pamu ungʼina ukuti, ‘Utundu utu ngali naakwafwa, loole twabha Kolobhani,’ kwo kuti, ‘Fya kumupa uChaala.’ ");
INSERT INTO ndh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Po ku sila iya fimanyisho fyinyu ifyo, mukumukaanisha umundu ukuti manye amwafwange ughwise pamu ungʼina. ");
INSERT INTO ndh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ku sila iya kushikola inyiiho shiinyu kwo kulifuyula ishu ilya Chaala, soona mukubhomba inyingi isha luko ulwo.” ");
INSERT INTO ndh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","UYeesu akachiitisha soona ichilundilo icha bhandu, akachibhuula akati, “Mwe bhandu mweshi umwe, pulikishanga akiisa nu kushaaghania. ");
INSERT INTO ndh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Naakamu akandu kaako kakwingila mukati mu mundu ukufuma kuuse kaako kabhaghiile ukumupelela umundu ukubha munyali. Loole akandu kaako kakufuma mu ndumbula, ko kaako kakumupelela umundu ukubha munyali.  ");
INSERT INTO ndh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Umundu yuuyo ali ni fyufwo, apulikaghe nu kushaaghania.” ");
INSERT INTO ndh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Po uYeesu akatiilaapo pabhuyo bhula, akachileka ichilundilo icha bhandu nu kwingila mu nyumba yimo. Bhwo bhali mu nyumba yila, abhamanyili bhaake bhakamubhuusha uYeesu isha chifwanikisho chila. ");
INSERT INTO ndh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Umwene akabhabhuusha akati, “Kali, nuumwe mutakushaaghania? Kali, mutameenye ukuti akandu kaako kakwingila mukati mu mundu ukufuma kuuse katabhaghiile ukumupelela umundu ukubha munyali? ");
INSERT INTO ndh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Paapo akandu ako, katakwingila mukati mu ndumbula, loole kakwingila mukati mu mala ghaake, pakataashi kakufuma ukubhuuka kwa syenje.” Ku bhuyughi ubhwo, uYeesu akiitikishanga ukuti umundu abhaghiile ukulya ifindu fyoshi. ");
INSERT INTO ndh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","UYeesu akoongela ukuyugha akati, “Akandu kaako kakufuma mu ndumbula, ko kaako kakumubhiika umundu ukubha munyali. ");
INSERT INTO ndh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Paapo mukati mu ndumbula iya mundu mwo muumwo shikufuma inyinongʼono imbiibhi, ubhushipani, ");
INSERT INTO ndh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ubhwifi, ubhughoghi, akabhini, ifinyonywa ifibhiibhi, ubhulwe, ulwibhuno, ubhupafu, amaheelu, amatingo nu bhukonyofu. ");
INSERT INTO ndh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Imbiibhi shooshi isho shiisho shikufuma mu ndumbula sho shiisho shikumupelela umundu ukubha munyali.” ");
INSERT INTO ndh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Po uYeesu akatiilaapo pabhuyo bhula, akabhuuka mu twaya utwa mu Tiilo na mu Sindoni nu kwingila mu nyumba yimo. Umwene atakalondagha ukuti umundu naayumo amanye ukuti aliipo pabhuyo bhula, loole poope abhandu bhakamanya. ");
INSERT INTO ndh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Umukolo yumo yuuyo umwana ghwake umulindu akabha ni mbepo imbiibhi, akapulika inongwa isha Yeesu. Bhwo aapulika, nakalinga, umukolo yula akiisa nu kufughamila pandaashi pa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Umukolo yula atakabha Muyuuta, loole akabha mukaaya ughwa mu chiisu icha Silofoyiniki. Po akamusuuma ukuti ayikiishe imbepo imbiibhi mu mulindu yula. ");
INSERT INTO ndh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","UYeesu akamubhuula akati, “Bhaleke taashi abhaana bhiikute, paapo kataa kiisa ukwegha ifindu ifya bhaana nu kubhaponekesha abhokabhwa.” ");
INSERT INTO ndh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Loole umukolo yula akamwamula akati, “Nalooli Malafyale, loole na bhokabhwa bhaabho bhali paase pa meesa, bhoope bhakulya utubhululusha tuutwo tukughwa paase.” ");
INSERT INTO ndh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","UYeesu akamwamula akati, “Ku nongwa iya lishu lyako ilyo, bhuukagha. Imbepo imbiibhi yaatiila mu mwana ghwako.” ");
INSERT INTO ndh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Po akabhuuka kukaaya kaake, akamwagha umwana aghonite pa chitala, imbepo imbiibhi yila yitiilite. ");
INSERT INTO ndh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Po uYeesu akatiilaamwo mu kaaya aka Tiilo akaghendela ku Sindoni na mu Ndekapooli, kwo kuti, “Utwaya kalongo (10),” akafika kwa sumbi ughwa Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Po abhandu bhamu bhakiisa nu mundu yumo yuuyo akabha ghwa fipuli soona akabha ghwi chinuunu. Bhakamusuuma uYeesu ukuti amubhiikile utukono nu kumuposha. ");
INSERT INTO ndh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","UYeesu akatiilaapo naghwe nu kubha pabhushiifu pabhutali ni chilundilo icha bhandu. Po akafwilila amati pa tukono twake, akamweghelesha ululimi nu kubhiika utwana utwa tukono mu fyufwo fyake. ");
INSERT INTO ndh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Po uYeesu akatesha kumwanya, akeesheela ku maka, akamubhuula akati, “Efata!” Kwo kuti, “Ighuka.” ");
INSERT INTO ndh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Po ifyufwo fyake fikiighuka nu lulimi lwake lukaabhuka, akaanda ukugholosha ukuyugha. ");
INSERT INTO ndh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","UYeesu akabhalaghilila ukuti manye bhamubhuulaghe umundu naayumo, loole poope bhakeendelela ukufumusha. ");
INSERT INTO ndh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Abhandu bhakaswigha ngaani bhakati, “Aabhomba shooshi akiisa, aabhaafwa abha fipuli ukupulika na bhochinuunu ukuyugha.” ");
INSERT INTO ndh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Akabhalilo kala kala, abhandu abhingi bhakabhungaana pakumupulikisha uYeesu. Abhandu abho bhatakabha ni findu. UYeesu akabhiitisha abhamanyili bhaake akabhabhuula akati, ");
INSERT INTO ndh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ingubhapelela ichisa abhandu abha ku nongwa iya kuti twikala nabho amashiku matatu, loole bhatali ni findu. ");
INSERT INTO ndh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nuune linga naabhalagha ukuti bhabhuukaghe mu twaya twabho bhwo bhali ni sala, indibhashilike mu sila paapo abhandu bhamu bhafumite kubhutali.” ");
INSERT INTO ndh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abhamanyili bhaake bhakamubhuusha uYeesu bhakati, “Kali, tubhaghiile ukufyagha kuughu ifindu ifya kubhayiilania abhandu bhooshi abha? Paapo pabhuyo panu patali nu twaya utwa bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Loole uYeesu akabhabhuusha akati, “Kali, muli nayo imikati milinga?” Bhakamwamula bhakati, “Tuli nayo imikati mihaano na mibhili (7).” ");
INSERT INTO ndh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Po uYeesu akabhalaghila abhandu ukuti bhiikale paase. Akeegha imikati mihaano na mibhili yila, akapaalisha kwa Chaala, akabheghulania imikati, akabhapa abhamanyili bhaake ukuti bhabhayabhile abhandu, bhoope bhakabhayabhila abhandu. ");
INSERT INTO ndh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Soona, abhamanyili bhakabha ni iswi nandiishe. Po uYeesu akapaalisha kwa Chaala, akabhalaghila ukuti bhabhayabhile abhandu. ");
INSERT INTO ndh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Abhandu bhala bhakalya, bhakiikuta. Abhamanyili abha Yeesu bhakabhungaania utubhululusha utwa mikati, bhakiisusha utupombo tuhaano na tubhili (7). ");
INSERT INTO ndh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Abhandu bhaabho bhakalya, bhakabha abhoelufu bhanna. Po uYeesu akabhalagha abhandu bhooshi abha lukomaano. ");
INSERT INTO ndh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nakalinga akiingila mu bhwato pamupeene na bhamanyili bhaake, bhakabhuuka kulubhafu ulwa kaaya aka Ndalimanuuta. ");
INSERT INTO ndh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Po aBhafalisaayi bhakiisa, bhakaanda ukuyughisania nu Yeesu. Abheene bhakamughelagha ukuti abhombe ichiika ukulangisha ukuti atumiighwe nu Chaala. ");
INSERT INTO ndh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","UYeesu akaswimaana mu ndumbula yaake akati, “Kali, kooni abhandu abha kabhalilo aka bhakulonda ichiika? Nalooli, ingubhabhuula ukuti indaaingabhabhombele ichiika naachimo abhandu abha.” ");
INSERT INTO ndh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","UYeesu akabhaleka abhandu, akiingila mu bhwato pamupeene na bhamanyili bhaake, bhakalobhoka usumbi nu kubhuuka ku isiila ilingi. ");
INSERT INTO ndh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abhamanyili bhaake bhakiibhwa ukwegha imikati, loole mu bhwato bhakabha nu mukati ghumoghweneeshe. ");
INSERT INTO ndh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","UYeesu akabhasoka akati, “Mubhange maaso ngaani ni nyambo iya Bhafalisaayi ni ya Helooti.” ");
INSERT INTO ndh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Po bhakayughisania bheene-bheene bhakati, “Akuyugha bhubhuubhwo paapo tutali ni mikati.” ");
INSERT INTO ndh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","UYeesu akashaaghania shiisho bhakayughisanianga, akabhabhuusha akati, “Kali, kooni mukuyughisania ukuti mutali ni mikati? Kali, mukaali mutameenye nu kushaaghania? Kali, indumbula shiinyu shikaali ngafu? ");
INSERT INTO ndh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Amaaso muli nagho, kali, kooni mutakutesha? Ifyufwo muli nafyo, kali, kooni mutakupulika? Kali, mutakukumbuka ");
INSERT INTO ndh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","akabhalilo kala kaako ingabheghulania imikati mihaano nu kubhapa abhandu abhoelufu bhahaano (5,000)? Kali, mukabhungaania utupombo tulinga utwa tubhululusha utwa mikati?” Abheene bhakamwamula bhakati, “Utupombo kalongo na tubhili (12).” ");
INSERT INTO ndh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Akabhabhuusha soona akati, “Kali, imikati mihaano na mibhili yila yiiyo ingabheghulania nu kubhapa abhandu abhoelufu bhanna (4,000), kali, mukabhungaania utupombo tulinga?” Bhakamwamula bhakati, “Tukabhungaania utupombo tuhaano na tubhili (7).” ");
INSERT INTO ndh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","UYeesu akabhabhuusha akati, “Kali, poope mukaali mutakushaaghania?” ");
INSERT INTO ndh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","UYeesu na bhamanyili bhaake bhakafika mu kaaya aka Bheetisayita. Po abhandu bhamu bhakiisa naghwe umundu yumo yuuyo akabha mufwamaaso, bhakamusuuma uYeesu ukuti amwegheleshe nu kumuposha. ");
INSERT INTO ndh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","UYeesu akamukola akakono, akamwegha, akabhuuka naghwe kuuse ku kaaya kala. Po akamufwilila amati mu maaso nu kumubhiikila utukono, akamubhuusha akati, “Kali, ubhaghiile ukutesha akandu kamu?” ");
INSERT INTO ndh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Umufwamaaso yula akakelengania, akamwamula akati, “Ingubhabhona abhandu bhaabho bhakughenda, bhagheliile na makokwe.” ");
INSERT INTO ndh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","UYeesu akabhiika soona utukono twake pa maaso agha mundu yula. Umundu yula akalatula amaaso ghaake ngaani, po akapola, akaanda ukutesha akiisa akandu kooshi. ");
INSERT INTO ndh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Po uYeesu akamubhuula ukuti abhwelaghe kukaaya kaake, loole akamulaghilila akati, “Manye ughendelaghe mu kaaya.” ");
INSERT INTO ndh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Po uYeesu na bhamanyili bhaake bhakabhuuka mu twaya utunandi tuutwo tukabha mulubhafu mu Kayisaaliya-Filipi. Bhwo bhakughenda mu sila, uYeesu akabhabhuusha abhamanyili bhaake akati, “Kali, abhandu bhakuunjugha une bhakuti nee ghwini?” ");
INSERT INTO ndh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhakamwamula bhakati, “Abhandu bhamu bhakuti ughwe ghwe Yoohani uMwoshi, abhanine bhakuti ughwe ghwe Eliiya umusololi na bhanine bhakuti ughwe ghwe yumo mu bhasololi.” ");
INSERT INTO ndh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","UYeesu akabhabhuusha akati, “Kali, umwe mukuti une nee ghwini?” UPeeteli akamwamula akati, “Ughwe ghwe Mesiiya.” ");
INSERT INTO ndh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Po uYeesu akabhasoka ukuti manye bhamubhuulaghe umundu naayumo ukuti ghwi Kilisiti. ");
INSERT INTO ndh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Po uYeesu akaanda ukubhamanyisha abhamanyili bhaake akati, “UMwana ughwa Mundu akulondighwa ukushaagha indamyo inyingi, ukukaanighwa na bhosongo abha Bhayuuta, abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose nu kughoghighwa. Soona akulondighwa ukushuuka pi ishiku ilya bhutatu.” ");
INSERT INTO ndh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","UYeesu akabhabhuula shooshi isho pabhwelu chishita kufinda. Po uPeeteli akamwegha uYeesu nu kubhuuka naghwe palubhafu, akaanda ukumukemela. ");
INSERT INTO ndh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Loole uYeesu akasanuka, akabhatesha abhamanyili bhaake, akamukemela uPeeteli akati, “Tiila kukwangu ghwe Seetano! Paapo utakwinongʼona shiisho sha Chaala, loole kwinongʼona shiisho sha bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Po uYeesu akachiitisha ichilundilo icha bhandu pamupeene na bhamanyili bhaake, akabhabhuula akati, “Umundu ghweshi yuuyo akulonda ukuungonga, iikaane mwene, apimbaghe ichikobhekano chaake, aangongaghe. ");
INSERT INTO ndh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Paapo umundu yuuyo akulonda ukubhupoka ubhwumi bhwake, indiakabhupyute. Loole umundu yuuyo akubhufumya ubhwumi bhwake ku nongwa yangu na ku nongwa iya Nongwa iNyiisa isha Chaala, indiakabhwaghe ubhwumi bhwake ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kali, umundu abhaghiile ukukabha kooni linga aabhwagha ubhukabhi bhwoshi ubhwa pa chiisu nu kusofya ubhwumi bhwake? ");
INSERT INTO ndh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pamu, kali, umundu abhaghiile ukufumya kooni pa bhuyo ubhwa bhwumi bhwake? ");
INSERT INTO ndh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Paapo linga umundu akufwa isoni ukuunyiitika une na mashu ghangu akabhalilo aka kaako abhandu bhakubhomba ubhushipani ni mbiibhi, uMwana ughwa Mundu indiakamufwile isoni bhwo akwisa nu bhukulumba ubhwa Taata ghwake pamupeene na bhandumi abheelu.” ");
INSERT INTO ndh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","UYeesu akabhabhuula abhamanyili bhaake akati, “Nalooli ingubhabhuula, bhaliipo bhamu panu bhaabho bhataabhakafwe bhwo bhakaali ukuchibhona ichitangalala icha Chaala bhwo chikwisa na maka.” ");
INSERT INTO ndh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bhwo amashiku mahaano na limo (6) ghaakinda, uYeesu akabheegha uPeeteli, uYaakobhu nu Yoohani, akakwela nabho pa kaghamba akatali ukuti bhabhe pabhushiifu bheene. Bhwo bhali pala, uYeesu akasanuka icheeni pandaashi papaabho. ");
INSERT INTO ndh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Imyenda yaake yikangʼangʼagha ngaani, yikabha myelu leka ukukinda muumwo umundu umusuki pa chiisu ichi abhaghiile ukuyeelufya. ");
INSERT INTO ndh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nakalinga bhakabhoneka uEliiya nu Moose bhaabho bhakayughagha nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bhwo uPeeteli aashibhona shooshi isho, akamubhuula uYeesu akati, “Ghwe Mumanyishi, kaali kiisa ukuti utwe tubhe panu panu. Twitikishe ukuti tusenge ifitembe fitatu, chimo chibhe chaako, ichinine chibhe cha Moose ni chinine chibhe cha Eliiya.” ");
INSERT INTO ndh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","UPeeteli akayugha amashu agho ku nongwa iya kuti atakamanya shiisho akuyugha paapo umwene pamupeene na bhanine bhakabha nu bhwogha leka. ");
INSERT INTO ndh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Po likiisa ibhingu nu kubhiifunikila. Ishu likapulikighwa ukufuma mu ibhingu lila likati, “Uyu ghwe yuuyo Mwana ghwangu umughanighwa, mupulikaghe!” ");
INSERT INTO ndh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nakalinga, abhamanyili bhala bhakatesha soona, bhatakamubhona umundu umunine, loole uYeesu mwene pamupeene nabho. ");
INSERT INTO ndh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bhwo bhakwilomuka mu kaghamba, uYeesu akabhakaanisha ukuti manye bhamubhuulaghe umundu naayumo shiisho bhaashibhona ukufika paapo uMwana ughwa Mundu indiakashuuke. ");
INSERT INTO ndh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Po abhamanyili bhaake bhakalipokeela ishu lila nu kulisengula, loole bhakaanda ukubhuusania bheene-bheene bhakati, “Kali, ukushuuka ukwo kwo kuti kooni?” ");
INSERT INTO ndh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Po bhakamubhuusha uYeesu bhakati, “Kali, nongwa yiki yiiyo abhamanyishi abha ndaghilo isha Moose bhakuti uEliiya akulondighwa atangile taashi ukwisa bhwo uKilisiti akaali?” ");
INSERT INTO ndh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","UYeesu akabhaamula akati, “Nalooli, uEliiya akulondighwa ukwisa taashi pakutendekesha shooshi. Linga bhwo shili, po kali, kooni shisimbiighwe mu Masimbo aMeelu ukuti uMwana ughwa Mundu indiakashaaghe indamyo inyingi nu kuti abhandu abhingi indibhakamukaane? ");
INSERT INTO ndh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Loole ingubhabhuula ukuti uEliiya iisile, abhandu bhakamubhombela akabhiibhi isa muumwo shisimbiighwe mu Masimbo aMeelu ukumuyugha umwene.” ");
INSERT INTO ndh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bhwo uYeesu na bhamanyili bhatatu bhala bhaafika pa bhamanyili abhanine, bhakachibhona ichilundilo ichikulu icha bhandu chiicho chikabhashunguulila. Abhamanyishi bhamu abha ndaghilo isha Moose bhakayughisanianga na bhamanyili bhala. ");
INSERT INTO ndh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nakalinga bhwo ichilundilo icha bhandu chaamubhona uYeesu, bhooshi bhakaswigha leka, bhakamukindilila ukuti bhamulamuke. ");
INSERT INTO ndh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","UYeesu akabhabhuusha akati, “Kali, mukukaanikana kooni nabho?” ");
INSERT INTO ndh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Umundu yumo mu chilundilo chila akamubhuula akati, “Ghwe Mumanyishi, niisile nu mwana ghwangu kukwako ukuti umuposhe, akoliighwe ni mbepo imbiibhi yiiyo yimupelite ukubha ghwi chinuunu. ");
INSERT INTO ndh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Akabhalilo kooshi linga yaamukola, yikumughwishanga paase, umwana uyu akufumagha indotofulo mu mulomu, akulumanianga amiino nu kwuma umubhili ghwoshi. Imbasuumite abhamanyili bhaako ukuti bhayikiishe imbepo imbiibhi iyo, loole bhapooshitwe.” ");
INSERT INTO ndh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Po uYeesu akabhaamula akati, “Mwe bhandu abha kabhalilo aka mwe mutakwitika, kali, indiniikale nuumwe nu kukibha ukufika liighi? Isagha naghwe umwana uyo kukwangu.” ");
INSERT INTO ndh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhakiisa naghwe kukwake. Nakalinga bhwo imbepo imbiibhi yila yaamubhona uYeesu, yikamughwisha paase, umwana yula akaanda ukwinionga-nionga. Indotofulo shikaanda ukufuma ku mulomu ghwake. ");
INSERT INTO ndh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","UYeesu akamubhuusha ughwise ughwa mwana yula akati, “Kali, umwana uyu aandite ukutaamighwa liighi?” Ughwise akamwamula akati, “Umwana uyu, aandite ukutaamighwa ukwanda bhwo mukeke. ");
INSERT INTO ndh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Akabhalilo akingi imbepo iyo yikumughwishanga mu mulilo lumo mu miishi ukuti yimughoghe. Po linga ubhaghiile ukubhomba shimo, tupelele ichisa nu kutwafwa.” ");
INSERT INTO ndh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","UYeesu akamubhuusha akati, “Kali, kooni kuyugha ukuti, ‘linga ubhaghiile’? Akandu kooshi kabhaghiile ukubhombighwa kukwake yuuyo akwitika.” ");
INSERT INTO ndh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nakalinga, ughwise ughwa mwana yula akayugha ku ishu ilya pamwanya akati, “Ingwitika! Loole ulwitiko lwangu lunandi, inyaafwe ukuti niitike ngaani.” ");
INSERT INTO ndh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bhwo uYeesu aagha ukuti ichilundilo icha bhandu chikwongela ukubhaala, akayikemela imbepo imbiibhi yila akati, “Ghwe mbepo imbiibhi ughwe, ghwe umupelite umwana uyu ukubha ghwi chinuunu soona ukubha ni fipuli, ingukulaghila ukuti fuma mu mwana uyu, manye ukamwingilaghe soona!” ");
INSERT INTO ndh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Po imbepo imbiibhi yila yikakuuta ngaani, yikamughwisha paase, yikamupelela ukwinionga-nionga ku maka nu kutiilaamwo. Umwana yula akabhonekagha ungati mufwe na bhandu abhingi bhakaanda ukuyugha ukuti, “Aafwa!” ");
INSERT INTO ndh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Loole uYeesu akamukola akakono umwana yula, akamwinula, ghwepe akiima. ");
INSERT INTO ndh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Po bhwo uYeesu na bhamanyili bhaake bhali bheene mu nyumba muumwo bhakiikalagha, abhamanyili bhaake bhakamubhuusha bhakati, “Kali, kooni utwe twapooshitwe ukuyikiisha imbepo imbiibhi yila?” ");
INSERT INTO ndh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","UYeesu akabhaamula akati, “Imbepo imbiibhi iya luko ulu yitabhaghiile ukutiila bhunobhunooshe, loole ku sila iya nyipuuto.” ");
INSERT INTO ndh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Po uYeesu na bhamanyili bhaake bhakatiilaapo pabhuyo bhula, bhakabhuuka ukughendela mu chiisu icha Ghalilaayi. UYeesu atakiighana ukuti umundu amanye paapo akabha. ");
INSERT INTO ndh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Akabhomba ulwo ku nongwa iya kuti akabhamanyishanga abhamanyili bhaake. Akabhabhuulagha akatingi, “UMwana ughwa Mundu akuya pakubhiikighwa mu tukono utwa bhalughu, bhoope indibhakamughoghe. Loole indiakashuuke pi ishiku ilya bhutatu.” ");
INSERT INTO ndh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Loole abhamanyili bhaake bhatakalyaghania ishu lila liilyo akaliyughagha, bhakooghopa ukumubhuusha. ");
INSERT INTO ndh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Po uYeesu na bhamanyili bhaake bhakafika mu Kapenabhumu nu kwingila mu nyumba yimo. Bhwo bhali mu nyumba yila, uYeesu akabhabhuusha abhamanyili bhaake akati, “Kali, mwakaanikanagha kooni mu sila?” ");
INSERT INTO ndh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Loole abhamanyili bhaake bhakasumbaashe paapo mu sila bhakakaanikanagha bheene-bheene ukuti mu bhamanyili abho ghwini yuuyo ghwi songo ukukinda bhooshi. ");
INSERT INTO ndh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","UYeesu akiikala paase ukuti aande ukumanyisha. Akabhiitisha abhamanyili bhaake bhooshi kalongo na bhabhili (12), akabhabhuula akati, “Umundu ghweshi yuuyo akulonda ukubha ghwi songo ukukinda abhanine bhooshi, akulondighwa iiyiishe nu kubha mubhombi ughwa bhooshi.” ");
INSERT INTO ndh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Po akamwegha umwana umukeke, akamwimika pakati papaabho, akamupakata. Po akabhabhuula akati, ");
INSERT INTO ndh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Umundu ghweshi yuuyo akumupokeela umwana yumo umukeke isa uyu mu ngamu yangu, akuumbokeela neene. Soona, umundu yuuyo akuumbokeela une, akumupokeela nu Taata yuuyo aandumite.” ");
INSERT INTO ndh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","UYoohani akamubhuula uYeesu akati, “Ghwe Mumanyishi, twamubhweni umundu yumo yuuyo aashikiishanga imbepo imbiibhi ukubhombela ingamu yaako, nuutwe twamukaanishiishe ku nongwa iya kuti atali pamupeene nuutwe.” ");
INSERT INTO ndh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Loole uYeesu akayugha akati, “Manye mumukaanishange ku nongwa iya kuti ataliipo umundu naayumo yuuyo abhaghiile ukubhomba ifyika ukubhombela ingamu yangu, soona umundu yuyuuyo anjughe kabhiibhi. ");
INSERT INTO ndh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Paapo umundu yuuyo atakukaanikana nuutwe, ali kulubhafu lwitu. ");
INSERT INTO ndh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nalooli ingubhabhuula umwe, linga umundu yumo aabhapa umwe nalinga miishi agha kungʼwa mu chikombe ku nongwa iya kuti umwe mwe bhakongi bha Kilisiti, uChaala indiakamuhombe umufwalo ghwake.” ");
INSERT INTO ndh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","UYeesu akeendelela ukuyugha akati, “Linga umundu yumo akumusofya yumo mu bhakeke abha bhaabho bhakuunyiitika une ukuti abhombe imbiibhi, kaali kiisa kukwake ukumupinyiilila ulwala ulukulu mu shingo umundu uyo nu kumutaagha mu chishibha ichitali icha mu nyanja. ");
INSERT INTO ndh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Linga akakono kaako kakukusofya ukuti ubhombe imbiibhi, katumule! Paapo kiisa ghwingile mu bhwumi ubhwa bhwila na bhwila bhwo uli na kakono kamukeene ukukinda ukubha nu tukono tubhili nu kwingila mu mulilo ughwa mu Yehanamu ghuughwo ghutakushima naalumo.  ");
INSERT INTO ndh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Umwo mwo mubhuyo muumwo ifwingili shitakufwa, soona nu mulilo ghutakushima. ");
INSERT INTO ndh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Linga akalundi kaako kakukusofya ukuti ubhombe imbiibhi, katumule! Paapo kiisa ghwingile mu bhwumi ubhwa bhwila na bhwila na kalundi kamukeene ukukinda ukubha nu tulundi twoshi tubhili nu kutaaghighwa mu mulilo ughwa mu Yehanamu ghuughwo ghutakushima naalumo.  ");
INSERT INTO ndh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Umwo mwo mubhuyo muumwo ifwingili shitakufwa, nu mulilo ghwope ghutakushima. ");
INSERT INTO ndh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Linga ilyiso lyako likukusofya ukuti ubhombe imbiibhi, lifwombole. Paapo kiisa ghwingile mu chitangalala icha Chaala ni lyiso limo ukukinda ukuti ubhe na maaso ghooshi mabhili nu kutaaghighwa mu mulilo ughwa mu Yehanamu ghuughwo ghutakushima naalumo. ");
INSERT INTO ndh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Umwo mwo mubhuyo muumwo ifwingili shitakufwa nu mulilo ghutakushima naalumo. ");
INSERT INTO ndh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Umundu ghweshi yuuyo akumupulika uChaala, indiakamwelufye ukubhombela umulilo isa muumwo abhandu bhakeelufyanga ifyabhupe fyabho ukubhombela imbeeya. ");
INSERT INTO ndh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Imbeeya nyiisa. Kali, linga yaakomanika, indimubhiikeemwo kooni ukuti yikole soona? Nuumwe mubhange ni mbeeya yiiyo yikukola, soona mwikalaghe nu lutengaano mwibheene-bheene.” ");
INSERT INTO ndh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Po uYeesu na bhamanyili bhaake bhakatiila mu kaaya aka Kapenabhumu, bhakaghendela ku chiisu chiicho chili ku isiila ilya lusooko ulwa Yoolotani nu kubhuuka mu chiisu icha Yuteeya. Kwoshi kuukwo uYeesu akabhuukagha, ichilundilo icha bhandu chikabhungaanagha nu kumukonga, ghwepe akabhamanyishanga isa muumwo akiisubhila ukubhomba. ");
INSERT INTO ndh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ABhafalisaayi bhamu bhakiisa kwa Yeesu ukuti bhamughele, bhakamubhuusha bhakati, “Kali, indaghilo isha Moose shikwitikisha umulume ukumusoosha umukashi ku nongwa yooshi yila?” ");
INSERT INTO ndh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","UYeesu akabhaamula akati, “Kali, uMoose akabhalaghila kooni ku sha kalata ughwa kusookana?” ");
INSERT INTO ndh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Abheene bhakamwamula bhakati, “UMoose akiitikisha ukuti umulume abhaghiile ukumusimbila umukashi ukalata ughwa kusookana nu kumuleka.” ");
INSERT INTO ndh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","UYeesu akabhaamula akati, “UMoose akabhasimbila ululaghilo ulwo abhosekulu bhiinyu pamupeene nuumwe ku nongwa iya kuti indumbula shiinyu ngafu. ");
INSERT INTO ndh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Loole ukufuma kubhwandilo ubhwa kupelighwa ichiisu, ‘UChaala akapela umuliisha nu mukolo.’ ");
INSERT INTO ndh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ku nongwa iyo, umuliisha indiakamuleke ughwise nu ngʼina, indiakakamandane nu mukashi. ");
INSERT INTO ndh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Umulume nu mukashi indibhakabhe mubhili ghumoghwene. Po abhandu bhabhili abho bhatakubha bhabhili soona, loole bhakubha mubhili ghumoghwene. ");
INSERT INTO ndh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Po umuliisha nu mukolo bhaabho uChaala abhakamandaniishe, manye umundu abhalekaaniange.” ");
INSERT INTO ndh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bhwo bhaaghaluka mu nyumba yiiyo bhakiikalagha, abhamanyili bhaake bhakamubhuusha soona uYeesu isha kusookana. ");
INSERT INTO ndh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","UYeesu akabhaamula akati, “Umundu ghweshi yuuyo akumusoosha umukashi nu kwegha umukolo umunine, akubhomba ubhushipani. ");
INSERT INTO ndh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Soona, umukolo yuuyo aasooka ku mulume nu kweghighwa nu muliisha umunine, ghwepe akubhomba ubhushipani.” ");
INSERT INTO ndh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Po abhandu bhamu bhakiisa na bhaana abhakeke kwa Yeesu ukuti abheegheleshe pa mitu yaabho nu kubhasaya, loole abhamanyili bhaake bhakabhakemela abhandu bhala. ");
INSERT INTO ndh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bhwo uYeesu aashibhona isho, akakalala. Akabhabhuula abhamanyili bhaake akati, “Bhaleke abhaana abhakeke bhiisaghe kukwangu, manye mubhakaanishange. Paapo ichitangalala icha Chaala cha bhandu bhooshi bhaabho bhali ungati bhaana abha. ");
INSERT INTO ndh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nalooli ingubhabhuula, umundu ghweshi yuuyo atakuchipokeela ichitangalala icha Chaala ungati mwana umukeke uyu, ataaakiingile shiku mu chitangalala icho.” ");
INSERT INTO ndh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Po uYeesu akabheegha abhaana nu kubhapakata, akabhabhiikila utukono pa mitu yaabho nu kubhasaya. ");
INSERT INTO ndh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bhwo uYeesu na bhamanyili bhaake bhali mu sila, umundu yumo akamukindilila uYeesu, akafughamila pandaashi papaake nu kumubhuusha akati, “Ghwe Mumanyishi umwisa, kali, imbombe kooni ukuti imbwaghe ubhwumi ubhwa bhwila na bhwila?” ");
INSERT INTO ndh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","UYeesu akamwamula akati, “Kali, kooni kuunjugha une ukubha mwisa? Ataliipo umundu naayumo yuuyo mwisa, loole uChaala mwene. ");
INSERT INTO ndh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ughwe ushimeenye indaghilo shiisho shikuti, ‘Manye ughoghaghe, manye ushipanaghe, manye ghwibhaghe, manye ubhange mukeeti ughwa bhumyashi, manye ushimbulaghe nu kuti umughindikaghe ughuuso nu nyoko.’ ” ");
INSERT INTO ndh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Umundu yula akayugha akati, “Ghwe Mumanyishi, une ishikongite indaghilo shooshi isho ukufuma ubhukeke bhwangu.” ");
INSERT INTO ndh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Po uYeesu akamutesha ku ndumbula iya lughano, akamubhuula akati, “Kashaalite akandu kamukeene kukwako. Bhuuka ughulishe twoshi tuutwo uli natwo. Indalama shiisho ghwashaagha, ubhape abhapiina. Linga ghwabhomba ulwo, indiukabhe ghwibhiikila ichuuma kumwanya. Po isagha ghuungongaghe.” ");
INSERT INTO ndh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bhwo umundu yula aapulika inongwa isho, akaghibha pa maaso, akatiilaapo bhwo aswimaanite paapo akabha ni chuuma ichingi leka. ");
INSERT INTO ndh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","UYeesu akakelengania kuno na kuno, akabhabhuula abhamanyili bhaake akati, “Kupala leka abhakabhi ukwingila mu chitangalala icha Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abhamanyili bhaake bhakaswigha leka ku mashu ghaake. UYeesu akabhabhuula soona akati, “Mwe bhaana bhangu, kupala leka abhakabhi ukwingila mu chitangalala icha Chaala! ");
INSERT INTO ndh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kupepe ngaani ingamila ukufumisania pa kaashi aka sindaano, ukukinda umukabhi ukwingila mu chitangalala icha Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Abhamanyili bhaake bhakaswigha leka, bhakaanda ukubhuusania bheene-bheene bhakati, “Po linga bhwo shili, kali, ghwini yuuyo abhaghiile ukupokighwa?” ");
INSERT INTO ndh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","UYeesu akabhatesha, akabhabhuula akati, “Shiisho shitabhaghiile ukubhombighwa ku bhandu, kwa Chaala shitali ulwo, paapo kukwake shooshi shibhaghiile ukubhombighwa.” ");
INSERT INTO ndh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Po uPeeteli akamubhuusha uYeesu akati, “Ghwe Mumanyishi, kali, ishi shili bhuleele kukwitu? Paapo utwe tufilekite fyoshi fiifyo twali nafyo nu kukukonga ughwe!” ");
INSERT INTO ndh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","UYeesu akamwamula akati, “Nalooli ingubhabhuula umwe, umundu ghweshi yuuyo ayilekite inyumba, abhakulu, abhalumbu, ungʼina, ughwise, abhaana pamu imighunda ku nongwa yangu na ku nongwa iya Nongwa iNyiisa, ");
INSERT INTO ndh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","indiakapokeele imya yimo (100) mu tundu twoshi utwo mu kabhalilo aka, inyumba, abhakulu, abhalumbu, abhongʼina, abhaana ni mighunda. Loole pamupeene ni isho, indiakapokeele ni ndamyo inyingi. Soona indiakapokeele ubhwumi ubhwa bhwila na bhwila akabhalilo kaako kakwisa. ");
INSERT INTO ndh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Loole abhandu abhingi bhaabho bhakughindikighwa akabhalilo aka, bhataabhakaghindikighwe akabhalilo kaako kakwisa. Soona, abhandu bhaabho bhatakughindikighwa akabhalilo aka, indibhakaghindikighwe akabhalilo kaako kakwisa.” ");
INSERT INTO ndh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","UYeesu na bhamanyili bhaake kalongo na bhabhili (12) bhala, bhakakwelagha ukubhuuka ku Yelusaleemu. Bhwo bhali mu sila, uYeesu akabha mundaashi mumwabho. Abhamanyili bhaake bhakaswighagha, bhoope abhandu abhanine bhaabho bhakamukongagha, bhakooghopa. Po uYeesu akabhiitisha soona palubhafu kalongo na bhabhili bhala nu kwanda ukubhabhuula shiisho indishimwaghe. ");
INSERT INTO ndh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akabhabhuula akati, “Pulikisha imbabhuule! Ulu, tukukwela ukubhuuka ku Yelusaleemu. Bhwo tuli ukwo, uMwana ughwa Mundu indiabhiikighwe mu tukono utwa bhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose, bhoope indibhakamulonge ukuti aghoghighwe nu kumubhiika mu tukono utwa bhandu bhaabho bhataa Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bhoope indibhakamwangalile nu kumufwilila amati, indibhakamukome ni fikoti nu kumughogha. Loole indiakashuuke pi ishiku ilya bhutatu.” ");
INSERT INTO ndh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","UYaakobhu nu Yoohani bhaabho bhakabha bhaana abha Sebhetaayi, bhakabhuuka kwa Yeesu bhakayugha bhakati, “Ghwe Mumanyishi, tukusuuma utubhombele liilyo tukulonda.” ");
INSERT INTO ndh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","UYeesu akabhabhuusha akati, “Kali, mukulonda imbabhombele kooni?” ");
INSERT INTO ndh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Abheene bhakamwamula bhakati, “Bhwo ghwanda ukulongosha, tukusuuma utwitikishe tukabhe pamupeene nuughwe, yumo akiikale ku kakono kaako aka kumwisa, umunine ku kakono kaako aka kushoomi mu chitangalala chaako.” ");
INSERT INTO ndh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Po uYeesu akabhabhuula akati, “Mutashimeenye shiisho mukusuuma. Kali, mubhaghiile ukungʼwela ichikombe icha ndamyo chiicho inguya pakungʼwela pamu mubhaghiile ukwoshighwa ulwosho ulwa bhufwe luulwo inguya pakwoshighwa?” ");
INSERT INTO ndh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhakamwamula bhakati, “Tubhaghiile.” UYeesu akabhabhuula akati, “Nalooli, ichikombe chiicho inguya pakungʼwela indimungʼwele, soona nu lwosho luulwo inguya pakwoshighwa indimwoshighwe. ");
INSERT INTO ndh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Loole yitaa mbombo yangu ukubhiitikisha ukuti yumo iikale ku kakono kangu aka kumwisa, umunine ku kakono kangu aka kushoomi. Ubhuyo ubhwo indibhakabhwaghe abhandu bhaabho uChaala abhabhiikiile ngaanila.” ");
INSERT INTO ndh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bhwo abhamanyili abhanine kalongo (10) bhala bhaapulika ukusuuma kwabho, bhakamukalalila uYaakobhu nu Yoohani. ");
INSERT INTO ndh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Po uYeesu akabhiitisha abhamanyili bhooshi, akabhabhuula akati, “Mumeenye ukuti pa chiisu panu, bhala bhaabho bhakubhelengelighwa ukubha bhalongoshi, bhakubhalaghila abhandu bhaabho ku maka, soona bhakubhabhombesha ngaani abhandu abho. ");
INSERT INTO ndh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Loole manye shibhange ulwo kukwinyu. Paapo umundu ghweshi yuuyo akulonda ukubha ghwi songo pakati papiinyu, akulondighwa abhange mubhombi ghwinyu. ");
INSERT INTO ndh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Soona, umundu ghweshi yuuyo akulonda ukubha ghwa pamwanya pakati papiinyu, akulondighwa abhange mutumwa ghwinyu mweshi. ");
INSERT INTO ndh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Paapo uMwana ughwa Mundu atakiisa ukuti abhandu bhamubhombelaghe, loole akiisa ukuti abhabhombelaghe abhandu nu kubhufumya ubhwumi bhwake ukuti abhapoke abhandu abhingi.” ");
INSERT INTO ndh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bhwo isho shaakinda, uYeesu na bhamanyili bhaake bhakafika mu kaaya aka Yeeliko. Po bhakatiila mu kaaya ako pamupeene ni chilundilo ichikulu icha bhandu. Mu sila yiiyo bhakaghendagha, akiikala kulubhafu umufwamaaso umusuumilishi yuuyo ingamu yaake akabha ghwi Bhaatimaayi, kwo kuti, “Umwana ughwa Timaayi.” ");
INSERT INTO ndh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bhwo uBhaatimaayi aapulika ukuti ghwi Yeesu ughwa ku Naasaleeti akughenda, akaanda ukwitisha ku ishu ilya pamwanya akati, “Ghwe Yeesu, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, ingukusuuma ghuumbelele ichisa!” ");
INSERT INTO ndh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abhandu abhingi bhakamukemela ukuti asumbe, loole umwene akoongelaghaashe ukwitisha ku ishu ilya pamwanya akati, “Ghwe Yeesu, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, ingukusuuma ghuumbelele ichisa!” ");
INSERT INTO ndh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Po uYeesu akiima, akayugha akati, “Mwitishe.” Bhoope bhakamwitisha umufwamaaso yula, bhakamubhuula bhakati, “Ikasha indumbula! Iima. UYeesu akukwitisha.” ");
INSERT INTO ndh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ghwepe akalitaagha ikoti lyake, akiima lubhilo, akabhuuka kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","UYeesu akamubhuusha akati, “Kali, kulonda ingubhombele kooni?” Umufwamaaso yula akamwamula akati, “Ghwe Mumanyishi, ingulonda ukuti indeshange.” ");
INSERT INTO ndh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","UYeesu akamubhuula akati, “Bhuukagha, ulwitiko lwako lwakuposha.” Nakalinga, umufwamaaso yula akaanda ukutesha, po akaanda ukumukonga uYeesu mu sila. ");
INSERT INTO ndh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bhwo uYeesu na bhamanyili bhaake bhaapalamila mu kaaya aka Yelusaleemu, bhakafika mu kaaya aka Bheetifaaghe na ka Bheetaniya, utwaya tuutwo tuli kupiipi na kaghamba aka Mishunguti. Po uYeesu akabhatuma bhabhili mu bhamanyili bhaake, ");
INSERT INTO ndh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akabhabhuula akati, “Bhuukagha mu kaaya kaako kali mundaashi mumwinyu. Bhwo mukwingila mu kaaya ako, indimuyaaghe inyaana iya mbunda yipinyiighwe, yiiyo umundu naayumo itoghiteepo. Yaabhule, isagha nayo. ");
INSERT INTO ndh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Linga umundu akubhabhuushikisha akuti, ‘Kali, kooni mukubhomba ishi?’ Mumwamule ukuti, ‘UMalafyale akuyilonda, indiayighalushe soona panu.’ ” ");
INSERT INTO ndh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Po bhakabhuuka, bhakayaagha inyaana iya mbunda yila pa musebho, yipinyiighwe pa mulyango ughwa nyumba, bhakayaabhula. ");
INSERT INTO ndh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Abhandu bhamu bhaabho bhakabha bhiimite pala pala, bhakabhabhuusha bhakati, “Kali, kooni mukuyaabhula inyaana iya mbunda?” ");
INSERT INTO ndh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Po abhamanyili bhala bhakabhabhuula isa muumwo uYeesu akabhabhuulila, bhoope bhakabhiitikisha ukubhuuka nayo. ");
INSERT INTO ndh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhakabhuuka ni nyaana iya mbunda yila kwa Yeesu. Bhwo bhaafika, bhakaalisha imyenda yaabho pamwanya pa mbunda, po uYeesu akiikala pamwanya. ");
INSERT INTO ndh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Abhandu abhingi bhakaalisha imyenda yaabho yimo mu sila, abhanine bhakaalisha utusamba utwa makokwe tuutwo bhakatema mu mighunda. ");
INSERT INTO ndh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abhandu bhooshi bhaabho bhakamutangila uYeesu na bhaabho bhakamukongagha, bhakayugha ku ishu ilya pamwanya bhakati, “Apaalighwange uChaala! Asayighwange yuuyo akwisa mu ngamu iya Malafyale! ");
INSERT INTO ndh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bhusayiighwe ubhunyafyale ubhwa taata ghwitu uNdaabhiti bhuubhwo bhukwisa. Apaalighwange uChaala kumwanya!” ");
INSERT INTO ndh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Po uYeesu akafika mu kaaya aka Yelusaleemu nu kwingila mu lupaso ulwa Nyumba iya Chaala. Bhwo iingila, akatesha utundu twoshi imbafu shooshi. Loole ku nongwa iya kuti likabha lya namasubha, akatiila nu kughaluka mu Bheetaniya pamupeene na bhamanyili bhaake kalongo na bhabhili (12). ");
INSERT INTO ndh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ishiku ilya ningeelo bhwo uYeesu na bhamanyili bhaake bhakutiilaamwo mu Bheetaniya, isala yikamubhabha uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Po akatesha kubhutali, akalibhona ikokwe ilya mukuyu lili na maani amingi. Akabhuuka papiipi ukuti ateshe linga lili ni seke shimo. Bhwo aafika papiipi, akaagha litali ni seke naashimo, loole amaani gheene paapo katakabha kabhalilo aka kwela iseke. ");
INSERT INTO ndh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Po akalibhuula ikokwe lila akati, “Ghwe likokwe ughwe, ukwandila umuusughu ukufika pabhumalilo, manye ghwelaghe soona iseke.” Bhoope abhamanyili bhaake bhakapulika bhwo uYeesu akuyugha amashu agho. ");
INSERT INTO ndh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","UYeesu na bhamanyili bhaake bhakafika mu Yelusaleemu. Po uYeesu akiingila mu lupaso ulwa Nyumba iya Chaala nu kwanda ukubhakiisha abhandu bhaabho bhakaghulishanga nu kughula utundu. Akashipindulania imeesa isha bhandu bhaabho bhakafunjagha indalama nu kupindulania ifitengu ifya bhandu bhaabho bhakaghulishanga ingunda. ");
INSERT INTO ndh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Soona atakamwitikisha umundu naayumo ukuti eeghe ichiliilo chimo mu fiifyo bhakaghulishanga ukughendela pa lupaso ulwa Nyumba iya Chaala. ");
INSERT INTO ndh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Po akabhamanyisha, akabhabhuusha akati, “Kali, mutameenye ukuti shisimbiighwe mu Masimbo aMeelu, uChaala akuti, ‘Inyumba yangu indiyikabhe nyumba iya nyipuuto ku fyisu fyoshi’? Loole umwe muyibhiikite ukubha mbako iya bhapoka ifya bhandu.” ");
INSERT INTO ndh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bhwo abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose bhaapulika isho, bhakaanda ukulonda isila iya kumughogha. Loole bhakooghopagha leka ku nongwa iya kuti abhandu bhooshi bhakaswighagha ku fimanyisho fyake. ");
INSERT INTO ndh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bhwo lyafika ilya namasubha, uYeesu na bhamanyili bhaake bhakatiilaamwo mu kaaya kala. ");
INSERT INTO ndh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Bhwo bhwacha pangeelo, uYeesu na bhamanyili bhaake bhwo bhakubhuuka ku Yelusaleemu, bhakalibhona ikokwe ilya mukuyu lila lyumite lyoshi ukufuma pi ikolo. ");
INSERT INTO ndh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","UPeeteli akakumbuka amashu agha Yeesu agha kulighuna ikokwe ilyo, akamubhuula akati, “Ghwe Mumanyishi, tesha, ikokwe liilyo ghwalighunite, lyumite lyoshi!” ");
INSERT INTO ndh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","UYeesu akabhaamula akati, “Mwitikaghe uChaala. ");
INSERT INTO ndh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nalooli ingubhabhuula ukuti umundu ghweshi yuuyo akwitika mu ndumbula yaake chishita kwilaamwa ukuti shiisho akuyugha shikubhombighwa, abhaghiile ukukabhuula akaghamba aka ukuti, ‘Ipuka uye ghwiponie mu nyanja,’ isho, indishibhombighwe. ");
INSERT INTO ndh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Po ingubhabhuula, kooshi kaako mukusuuma bhwo mukwipuuta, mwitikaghe ukuti nalooli indimukapokeele, koope indikabhe kiinyu. ");
INSERT INTO ndh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nuumwe bhwo mukwipuuta, mumuhobhokelaghe umundu ghweshi yuuyo abhatuliile inongwa, ghwepe uGhuuso yuuyo ali kumwanya indiabhahobhokelaghe nuumwe inongwa shiinyu.  ");
INSERT INTO ndh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Loole linga umwe mutakubhahobhokela abhanyiinyu inongwa shaabho, ghwepe uGhuuso yuuyo ali kumwanya ataaakabhahobhokele nuumwe inongwa shiinyu.” ");
INSERT INTO ndh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","UYeesu na bhamanyili bhaake bhakafika soona mu Yelusaleemu. Bhwo uYeesu akughenda mu lupaso ulwa Nyumba iya Chaala, abhosongo abha bhapuuti, abhamanyishi abha ndaghilo isha Moose na bhosongo abhanine bhakabhuuka kukwake. ");
INSERT INTO ndh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bhakamubhuusha bhakati, “Kali, shooshi isho kushibhomba, kushibhomba ku maka agha ghwini? Kali, ghwini yuuyo akupiile amaka agha kubhomba shooshi isho?” ");
INSERT INTO ndh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Loole uYeesu akabhaamula akati, “Nuune indiimbabhuushe ibhuusho limo. Linga mwanyaamula, po nuune indiimbabhuule ukuti ingubhomba shooshi isho ku maka agha ghwini. ");
INSERT INTO ndh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kali, amaka agha Yoohani agha kwosha abhandu ghakafuma kwa Chaala pamu ghakafuma ku bhandu? Inyaamule.” ");
INSERT INTO ndh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Po abheene bhakayughisania bheene-bheene bhakati, “Linga twayugha ukuti, ‘Amaka ghaake ghakafuma kwa Chaala,’ po indiatubhuushe ukuti, ‘Kali, kooni mutakamwitikagha?’ ");
INSERT INTO ndh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Soona linga twayugha ukuti, ‘Amaka ghaake ghakafuma ku bhandu,’ po abhandu indibhatukalalile.” Abheene bhakooghopagha ichilundilo icha bhandu ku nongwa iya kuti abhandu bhooshi bhakiitikagha ukuti uYoohani akabha musololi ughwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Po bhakamwamula uYeesu bhakati, “Tutameenye kuukwo amaka agho ghakafuma.” Ghwepe uYeesu akabhabhuula akati, “Nuune indakubhabhuula ukuti ingubhomba shooshi ishi ku maka agha ghwini.” ");
INSERT INTO ndh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Po uYeesu akaanda ukuyugha na bhalongoshi abha Bhayuuta ku fifwanikisho akati, “Akabhaapo umulimi yumo yuuyo akalima umughunda ghwake nu kubhyala imisabhibhu. Akashunguusha ulubhagha nu kukumba pakati ubhwina ubhwa kukamila imisabhibhu, akasenga akasonje aka kwima pamwanya abhalindilili. Pabhumalilo, akabhabhiika abhalimi mu mughunda ghula ukuti linga bhaaya bhiinula iseke bhakayabhane. Po akachuula. ");
INSERT INTO ndh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Bhwo kaafika akabhalilo aka kwinula imisabhibhu, akamutuma umubhombi yumo ku bhalimi bhala ukuti amweghele iseke isha misabhibhu shiisho shikabha shaake. ");
INSERT INTO ndh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Loole abhalimi bhala bhakamukola umubhombi yula, bhakamukoma nu kumukiisha tukono twene. ");
INSERT INTO ndh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akamutuma soona umubhombi umunine kukwabho, ghwepe bhakamufulasha ku mutu nu kumubhombela akabhiibhi. ");
INSERT INTO ndh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akamutuma soona umubhombi umunine, umubhombi uyo, bhakamughogha. Akabhatuma abhanine abhingi, bhamu bhakabhakoma na bhanine bhakabhaghogha. ");
INSERT INTO ndh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Po akashaala naghwe yumoyweneeshe yuuyo akabha mwana ghwake umughanighwa. Po akamutuma ku bhalimi bhala, akayugha akati, ‘Indibhamughindike umwana ghwangu.’ ");
INSERT INTO ndh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Loole abhalimi bhala bhakayughisania bheene-bheene bhakati, ‘Uyu ghwe yuuyo indiakiingile ichilingo pa bhuyo ubhwa ghwise. Po isagha tumughoghe ukuti ichilingo chaake chibhe chiitu.’ ");
INSERT INTO ndh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Po bhakamukola, bhakamughogha nu kumutaagha kuuse ku mughunda ghula. ");
INSERT INTO ndh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Kali, mukwinongʼona ukuti umwene mughunda yula indiakabhombe kooni ku bhalimi bhala? Indiakiise nu kubhapyuta abhalimi bhala, soona indiakabhape abhalimi abhanine umughunda ghula. ");
INSERT INTO ndh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kali, umwe mutabhelengite ishi mu Masimbo aMeelu? ‘Iyondo liilyo abhasenga nyumba bhakalikaana, lyo liilyo lyabha liyondo ikulu ilya kukola pa nguto iya lwalilo ulwa nyumba. ");
INSERT INTO ndh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","UMalafyale uChaala ghwe yuuyo alibhombite ilyo, lyope lya kuswighisha kukwitu.’ ” ");
INSERT INTO ndh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Abhosongo abha bhapuuti, abhamanyishi abha ndaghilo isha Moose na bhosongo abhanine bhala bhakamanya ukuti ichifwanikisho icho chikubhayugha bho bhaabho. Po bhakalonda isila iya kumukola, loole bhakooghopa ichilundilo icha bhandu, bhakamuleka pala pala nu kutiilaapo. ");
INSERT INTO ndh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Po abhalongoshi abha Bhayuuta bhakabhatuma aBhafalisaayi na bhakongi bhamu abha Helooti uAntipa kwa Yeesu ukuti bhamuteghe ku mashu ghaake. ");
INSERT INTO ndh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bhwo bhaafika, bhakamubhuula bhakati, “Ghwe Mumanyishi, tumeenye ukuti ughwe ghwe mundu ghwa nalooli, ghwe kuyugha isha nalooli, soona utakumwoghopa umundu naayumo. Utakumwoghopa nu mundu yuuyo ali pa mbombo iya pamwanya, loole kumanyisha isila iya Chaala mu bhwanalooli. Kali, indaghilo isha Moose shikutwitikisha ukusonga isongo kwa Kayisaali, pamu nashiku? ");
INSERT INTO ndh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kali, tusongaghe pamu manye tusongaghe?” Loole uYeesu akabhwaghania ubhwongubhisania bhwabho, po akabhabhuusha akati, “Kali, kooni mukuungela? Imbe isalabhasha iya ndinaali indeshe.” ");
INSERT INTO ndh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bhwo bhaamulangisha, akabhabhuusha akati, “Kali, chaani ichifwani ichi nu bhusimbe ubhu bhuli pa salabhasha iyi?” Abheene bhakamwamula bhakati, “Fya malafyale uKayisaali.” ");
INSERT INTO ndh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Po uYeesu akabhabhuula akati, “Mupange uKayisaali fiifyo fya Kayisaali, soona mupange uChaala fiifyo fya Chaala.” Po abheene bhakamuswigha leka. ");
INSERT INTO ndh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ABhasandukaayi bhandu bhaabho bhakiitikagha ukuti uChaala ataaakabhashuushe abhandu. Ishiku limo bhakabhuuka kwa Yeesu, bhakamubhuusha bhakati, ");
INSERT INTO ndh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ghwe Mumanyishi, uMoose akatulaghila mu ndaghilo akati, ‘Linga umundu aafwa nu kumuleka umukashi chishita kupaapa umwana, ughwamwabho akulondighwa ukumwingila ichilingo umufwile uyo ukuti amupaapile umwana ughwa kwendelesha ingamu iya yuuyo afwile.’ ");
INSERT INTO ndh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Po kukabha na bhoghwamwabho bhahaano na bhabhili (7). Ughwa kwanda akeegha umukolo, umuliisha uyo akafwa chishita kupaapa umwana nu mukolo uyo. ");
INSERT INTO ndh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ughwamwabho ughwa bhubhili akamwingila ichilingo umukolo umufwile yula, ghwepe akafwa chishita kupaapa umwana nu mukolo uyo, nu ghwa bhutatu ghwepe isa bhubhuubhwo. ");
INSERT INTO ndh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bhooshi bhahaano na bhabhili bhakamwegha nu kufwa, bhatakamuleka umukolo yula nu mwana naayumo. Kubhumalilo, umukolo umufwile yula ghwepe akafwa. ");
INSERT INTO ndh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Po tubhuule, kali, pi ishiku lila liilyo uChaala indiakabhashuushange abhafwe bhooshi, umukolo yula indiakabhe mukashi ghwani? Paapo akeeghighwa na bhaliisha bhooshi bhahaano na bhabhili!” ");
INSERT INTO ndh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","UYeesu akabhaamula akati, “Mukusobha leka ku nongwa iya kuti mutashimeenye shiisho shisimbiighwe mu Masimbo aMeelu, soona mutaghameenye amaka agha Chaala muumwo ghabheeliile. ");
INSERT INTO ndh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Paapo bhwo abhafwe bhaashuuka, indibhakabhange ungati bhandumi abha Chaala bhaabho bhali kumwanya, bhaabho bhatakwegha pamu ukweghighwa. ");
INSERT INTO ndh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kali, ku sha kushuuka abhafwe, mutabhelengite mwa kalata ughwa Moose muumwo uChaala akayugha nu Moose pa katengele kaako kakaakagha umulilo? UChaala akamubhuula uMoose akati, ‘Une nee Chaala yuuyo uAbhulahamu, uIsiyaka nu Yaakobhu bhakaanyiipuutagha.’ ");
INSERT INTO ndh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Po abhandu bhaabho bhafwe bhatakumwipuuta uChaala, loole bhaabho bhuumi bho bhaabho bhakumwipuuta. Umwe mukusobha leka.” ");
INSERT INTO ndh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Po umumanyishi yumo ughwa ndaghilo isha Moose akafika, akapulika bhwo bhali pakukaanikana naghwe. Bhwo aagha uYeesu aabhaamula aBhasandukaayi akiisa, akamubhuusha akati, “Ghwe Mumanyishi, kali, mu ndaghilo shooshi, luliku luulwo lukulu?” ");
INSERT INTO ndh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","UYeesu akamwamula akati, “Ululaghilo luulwo lukulu lwo ulu lukuti, ‘Pulikagha mwe bhandu bha chiisu icha Isilaeli! UMalafyale uChaala ghwitu ghwe yuuyo ghwi Malafyale mwene. ");
INSERT INTO ndh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mughanaghe uMalafyale uChaala ghwako ku ndumbula yaako yooshi, ku nyinongʼono shaako shooshi, ku mahala ghaako ghooshi na ku maka ghaako ghooshi.’ ");
INSERT INTO ndh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Soona, ululaghilo luulwo lukukonga lwo ulu lukuti, ‘Mughanaghe umunyiinyu isa muumwo ghwiyiighanite yughweghwe.’ Lutaliipo ululaghilo luulwo lukulu ukushikinda ishi.” ");
INSERT INTO ndh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Po umumanyishi ughwa ndaghilo isha Moose yula akamubhuula akati, “Nalooli Mumanyishi! Ghwayugha ubhwanalooli ukuti uChaala ali yumoywene, soona ataliipo uChaala umunine loole umwene. ");
INSERT INTO ndh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kiisa ngaani ukumughana uChaala ku ndumbula yaako yooshi, ku mahala ghaako ghooshi na ku maka ghaako ghooshi, soona ukumughana umunyiinyu isa muumwo ghwiyiighanite yughweghwe. Ukubhomba isho kubhaghile ngaani ukukinda ukufumya ifinyamaana ifya kupemba ni fyabhupe ifinine.” ");
INSERT INTO ndh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Bhwo uYeesu aatesha ukuti umundu yula aamwamula ku mahala ngaani, akamubhuula akati, “Ughwe utali kubhutali ni chitangalala icha kumwanya.” Bhwo isho shaakinda, naayumo umundu yuuyo akasulwa ukumubhuusha soona. ");
INSERT INTO ndh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","UYeesu akeendelela ukubhamanyisha abhandu mu lupaso ulwa Nyumba iya Chaala. Po akabhabhuusha akati, “Kali, mukushaaghania bhuleele linga abhamanyishi abha ndaghilo isha Moose bhakumanyisha ukuti uMesiiya Mwana ghwa malafyale uNdaabhiti? ");
INSERT INTO ndh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Paapo uNdaabhiti bhwo uMbepo uMwelu akumulongosha akasimba akati, ‘UMalafyale uChaala akamubhuula uMalafyale ghwangu akati, “Ikala ku kakono kangu aka kumwisa, ukufika paapo indiingabhabhiike abhalughu bhaako paase pa tulundi twako.” ’ ");
INSERT INTO ndh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Linga uNdaabhiti yuyuuyo akamwitisha uKilisiti ukuti ghwi Malafyale ghwake, po kali, uKilisiti abhaghiile bhuleele ukubha mwana ghwake?” Ichilundilo ichikulu icha bhandu chikamupulikishanga ku lusekelo. ");
INSERT INTO ndh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mu fimanyisho fyake, uYeesu akabhabhuulagha abhandu akatingi, “Mubhange maaso na bhamanyishi abha ndaghilo isha Moose! Paapo abheene bhiighanite ukughenda-ghenda bhwo bhafwalite imiselekesha imitali, soona bhiighanite ukuti abhandu bhabhalamukaghe ku lughindiko mu minaalo. ");
INSERT INTO ndh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Abheene bhiighanite ukwikala pa fitengu ifya pandaashi mu masinaghoghi. Soona pi ishiku ilya lusekelo, abheene bhiighanite ukwikala pa fitengu ifya bhaheesha abhaghindikighwa. ");
INSERT INTO ndh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Loole bhakupokagha ifyuma ni nyumba isha bhakolo abhafwile, soona bhakwipuutagha kwa Chaala inyipuuto indali ukuti bhiilangishe ku bhandu ukuti bhakubhomba inyiisa! Ku nongwa iyo, uChaala indiakabhape abhandu abho ulufundo ulukulu.” ");
INSERT INTO ndh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Bhwo uYeesu akaali ali mu lupaso ulwa Nyumba iya Chaala, akiikala nu kutesha ku ibhokoshi ilya kufumikisha ifyabhupe. Akateshanga bhwo abhandu bhakufumya nu kubhiika ifyabhupe fyabho mu ibhokoshi lila. Abhakabhi abhingi bhakafumya indalama inyingi. ");
INSERT INTO ndh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Po akiisa umukolo yumo umufwile umupiina, akafumya isalabhasha shibhili. ");
INSERT INTO ndh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Po uYeesu akabhiitisha abhamanyili bhaake, akabhabhuula akati, “Nalooli une ingubhabhuula ukuti, umukolo umufwile umupiina uyu, aafumya indalama inyingi mu ibhokoshi ukubhapoota bhooshi bhala bhaabho bhaafumyanga indalama shaabho. ");
INSERT INTO ndh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Paapo abhandu bhala bhaafumya ifyabhupe fiifyo fyashaalagha ukufuma mu bhukabhi bhwabho. Loole umukolo uyu pamupeene nu kuti mupiina, poope aafumya indalama shaake shooshi shiisho sha kumwafwa mu bhwumi bhwake.” ");
INSERT INTO ndh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bhwo aabhamanyisha abhandu bhala, uYeesu na bhamanyili bhaake bhakafuma mu lupaso ulwa Nyumba iya Chaala. Bhwo bhakufuma kuuse, umumanyili ghwake yumo akamubhuula akati, “Ghwe Mumanyishi, tesha, amayondo amakulu agha nu bhusengi ubhwisa ubhu muumwo bhukuswighisha!” ");
INSERT INTO ndh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","UYeesu akamwamula, akamubhuusha akati, “Kali, kutesha ubhusengi ubhukulu ubhwa kuswighisha ubhu? Nalooli ingubhabhuula, naalimo iyondo liilyo indilikashaale pamwanya pi inine. Loole amayondo ghooshi agho, indighakapongolighwe!” ");
INSERT INTO ndh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","UYeesu na bhamanyili bhaake bhakafika nu kwikala pa kaghamba aka Mishunguti ukutesha iNyumba iya Chaala. Bhwo bhali pala, uPeeteli, uYaakobhu, uYoohani nu Ndeleeya bhakamubhuusha uYeesu bhwo bhiiyeekiile, bhakati, ");
INSERT INTO ndh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ghwe Mumanyishi, tubhuule, kali, indishikabhoneke liighi shooshi isho? Soona, kali, chilangisho chiki chiicho indichikatulangishe ukuti shaapalamila ukubhoneka?” ");
INSERT INTO ndh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Po uYeesu akaanda ukubhabhuula akati, “Mubhange maaso, manye umundu naayumo abhashimbulaghe. ");
INSERT INTO ndh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Paapo indibhakiise abhandu abhingi nu kubhombela ingamu yangu, bhakatingi, ‘Une nee Mesiiya.’ Bhoope indibhakabhashimbulaghe abhandu abhingi. ");
INSERT INTO ndh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Linga mukuya kupulika isha bhwite mubhuyo ubhwingi, manye mukapaashange. Nalooli, isho shooshi shikulondighwa shibhoneke, loole ubhumalilo ubhwene bhukaali bhukwisa. ");
INSERT INTO ndh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ichiisu chimo indichikalwange ni chiisu ichinine nu bhunyafyale bhumo indibhukalwange nu bhunyafyale ubhunine. Utuyingiyingi ni sala indifikabhonekaghe mu fyisu ifyingi. Isho shooshi indishikabhe isa ubhwandilo ubhwa bhubhafu linga umukolo akupaapa. ");
INSERT INTO ndh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Loole umwe mubhange maaso. Paapo abhandu indibhakabhuukaghe nuumwe mu mabhalaasa nu kubhakoma bhwo muli mu masinaghoghi. Indibhakabhuukaghe nuumwe pandaashi pa bhalongoshi na ku bhomalafyale ku nongwa yangu ukuti mubhe bhakeeti bhangu kukwabho. ");
INSERT INTO ndh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bhwo ubhumalilo bhukaali ukwisa, iNongwa iNyiisa isha Chaala shikulondighwa shilumbililighwe taashi ku fyisu fyoshi. ");
INSERT INTO ndh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Linga bhaabhakola nu kubhapinya nu kubhuuka nuumwe mu mabhalaasa, manye mukapaashange ukuti indimukayughaghe kooni, pamu indimukayughaghe bhuleele. Loole kashiyughaghe shiisho indimukapokeelaghe ukufuma kwa Chaala akabhalilo kala kala. Paapo mutaa mwemwe indimukayughaghe, loole ghwi Mbepo uMwelu ghwe yuuyo indiakayughaghe ukughendela kukwinyu. ");
INSERT INTO ndh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ku kabhalilo ako, umukulu indiakamubhiikaghe umunungʼuna ghwake mu tukono utwa bhalughu ukuti aghoghighwe. Soona, ughwise indiakamubhiikaghe umwana mu tukono utwa bhalughu ukuti aghoghighwe. Bhoope abhaana indibhakabhaleeyaghe abhapaapi bhaabho nu kubhaghogha. ");
INSERT INTO ndh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Abhandu bhooshi indibhakabhabhenge umwe ku nongwa iya ngamu yangu. Loole umundu yuuyo indiakabhe mukifu ukufika pabhumalilo, ghwe yuuyo uChaala indiakamupoke.” ");
INSERT INTO ndh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Bhwo mwachibhona ‘ichindu chiicho chikuywelula nu kukomania,’ chiimite Pabhuyo uBhwelu paapo chitakulondighwa ukubha, (yuuyo akubhelenga ashaaghaniange muumwo shikulingaanikisha). Po abhandu bhooshi bhaabho bhakwikala mu chiisu icha Yuteeya bhakakindilaghe mu tughamba. ");
INSERT INTO ndh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ghwepe umundu yuuyo ali pa kasale pa nyumba, manye iikaghe pamu iingilaghe mu nyumba ukuti eeghe chimo. ");
INSERT INTO ndh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Umundu yuuyo ali ku mughunda, manye akaghalukaghe kunyuma pakwegha umwenda ghwake. ");
INSERT INTO ndh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lwabho abhakolo bhaabho indibhakabhe pa bhungʼwamu na bhaabho indibhakabhe bhakwongesha ku mashiku agho! ");
INSERT INTO ndh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Po ipuutagha kwa Chaala ukuti ishi manye shikabhoneke akabhalilo aka mbepo ingali. ");
INSERT INTO ndh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Paapo akabhalilo ako, indikakabhe ni ndamyo ingulu ngaani shiisho shitabhonekite naalumo ukwandila muumwo uChaala akapelela ichiisu ukufika umuusughu. Soona, indamyo isho shitaashikabhoneke naalumo. ");
INSERT INTO ndh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Linga uMalafyale atakaghapungushanga amashiku agho, po ngali naayumo umundu yuuyo indiakapone. Loole ku nongwa iya bhasalighwa bhaake, uMalafyale indiakaghapungushe amashiku agho. ");
INSERT INTO ndh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mu kabhalilo ako, linga umundu akubhabhuula akuti, ‘Tesha, uMesiiya ali panu,’ pamu, ‘Ali kula,’ manye mukiitikaghe. ");
INSERT INTO ndh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Paapo indibhakiise abhandu bhaabho indibhakayughaghe ubhumyashi ukuti bhokilisiti nu kuti bhasololi, indibhakabhombaghe ifyika ifya kuswighisha ukuti bhabhashimbule abhasalighwa abha Chaala. ");
INSERT INTO ndh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Loole umwe mubhange maaso, paapo naabhabhuula ngaanila inongwa shooshi isho bhwo shikaali ukubhoneka.” ");
INSERT INTO ndh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Loole bhwo indamyo isho shaakinda, ‘Isubha indilikasanuke ukubha chiisi, umweshi ghutaaghukabhalaghe, ");
INSERT INTO ndh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","soona ni ndoondwa shoope indishikaghwe paase ukufuma kumwanya. UChaala indiakatuyungaanie utundu twoshi utwa kumwanya.’ ");
INSERT INTO ndh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Apo po paapo indibhakamubhone uMwana ughwa Mundu akwisa mu mabhingu bhwo ali na maka amingi nu bhukulumba. ");
INSERT INTO ndh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Po indiakabhatume abhandumi bhaake ukuti bhabhabhungaanie abhasalighwa bhooshi ukufuma mumbafu shooshi, ukufuma kubhumalilo ubhwa chiisu ukufika kubhumalilo ubhwa kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ulu manyilagha ukufuma ku ikokwe ilya mukuyu. Linga utusamba twake twanda ukutulula amaani, po mukumanya ukuti akabhalilo aka fula kaapalamila. ");
INSERT INTO ndh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bhubhuubhwo, nuumwe linga mukushibhona shooshi isho shikubhombighwa, po mukamanye ukuti ukwisa kwake kuli papiipi. ");
INSERT INTO ndh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nalooli ingubhabhuula, imbaapo iyi yitaayikakinde bhwo ishi shooshi shitabhonekite. ");
INSERT INTO ndh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kumwanya ni chiisu indifikakinde, loole amashu ghangu indigheendelele ukubhaapo bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Loole ku sha lishiku lila na kabhalilo kala, naayumo umundu yuuyo ashimeenye, bhabhe bhandumi abha kumwanya pamu uMwana, loole uTaata uChaala. ");
INSERT INTO ndh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Teshanga soona mubhange maaso! Paapo mutameenye ukuti akabhalilo ako kakwisa liighi. ");
INSERT INTO ndh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ukwisa kwake kugheliile ni chifwanikisho icha mundu yuuyo akuchuula nu kubhalekela indaghilo abhabhombi bhaake, uyu ni mbombo yaake, uyu ni yaake. Po akumulaghila umulindilili ughwa pa mulyango ukuti abhange maaso. ");
INSERT INTO ndh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Po mubhange maaso paapo mutameenye ukuti umwene nyumba akughaluka liighi, lumo indilikabhe lya namasubha, lumo pabhushiku pakati, lumo bhwo ubhiisa aabhika pamu pangeelo bhwo bhwacha. ");
INSERT INTO ndh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mubhange maaso ukuti linga akwisa ku sila iya kunyomosha, manye akaaghe mupitiile. ");
INSERT INTO ndh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ishi shiisho ingubhabhuula umwe, ingubhabhuula na bhandu bhooshi ukuti mubhange maaso!” ");
INSERT INTO ndh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ghakabha ghaashaala amashiku mabhiliishe ukwanda ichaaka icha Pasaka ni cha Mikati iMishita Kulula. Po abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose, bhakalondagha isila iya kumukola uYeesu ku bhushiifu nu kumughogha. ");
INSERT INTO ndh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Paapo bhakayughisania bhakati, “Manye tumukolaghe akabhalilo aka pa chaaka paapo abhandu bhabhaghiile ukubhomba inyakanyaaka.” ");
INSERT INTO ndh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Akabhalilo ako uYeesu akabha mu Bheetaniya mu nyumba iya Siimoni yuuyo kubhwandilo akabha ni mbungo iya makete. Po bhwo uYeesu iikiile ali pakulya, umukolo yumo akiisa kukwake ni supa inandi iya nyemba isha kunuukila isha mutengo umukulu ngaani. Po akayimenyula kumwanya isupa yila nu kumusululila inyemba uYeesu pa mutu ghwake. ");
INSERT INTO ndh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Abhandu bhamu bhaabho bhakabhaamwo mu nyumba yila bhakakalala, bhakiiyughaania bheene-bheene bhakati, “Tesha! Kali, kooni umukolo uyu akukomania inyemba ishi? ");
INSERT INTO ndh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Paapo inyemba ishi shaabhaghiile ukughulishighwa indalama indinaali imya shitatu (300) nu kubhapa abhapiina.” Bhakaanda ukumukemela umukolo yula. ");
INSERT INTO ndh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Loole uYeesu akati, “Muleke, kali, kooni kaako mukumutamya? Umwene aambombela inyiisa. ");
INSERT INTO ndh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abhapiina muli nabho akabhalilo kooshi, mubhaghiile ukubhabhombela inyiisa amashiku ghooshi, loole une indaaimbe nuumwe akabhalilo kooshi. ");
INSERT INTO ndh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Umwene aabhomba shiisho abhaghiile, aaghupaka umubhili ghwangu inyemba ingaanila ukuti aghutendekeshe ukushiilighwa. ");
INSERT INTO ndh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nalooli ingubhabhuula, pooshi paapo iNongwa iNyiisa indishikalumbililighwange mu chiisu chooshi, inyiisa isho shiisho umukolo uyu aambombela, indishikayughighwange ukuti abhandu bhamukumbukaghe.” ");
INSERT INTO ndh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Po uYuuta Isikaliyooti yuuyo ghwe yumo mu bhamanyili kalongo na bhabhili (12) bhala, akabhuuka ku bhosongo abha bhapuuti ukuti abhaafwe muumwo bhabhaghiile ukumukola uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bhoope bhwo bhaapulika amashu agha Yuuta Isikaliyooti, bhakahobhoka leka, bhakafinga ukumupa indalama. Po akaanda ukulonda isila iya kumubhiika uYeesu mu tukono twabho. ");
INSERT INTO ndh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ishiku ilya kwanda ilya chaaka icha Mikati iMishita Kulula, likafika. Bhwo bhaaghogha akonangʼooshi aka Pasaka, abhamanyili abha Yeesu bhakamubhuusha bhakati, “Kali, pooki paapo kulonda tukutendekeshekeshe ichaaka icha Pasaka?” ");
INSERT INTO ndh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Po uYeesu akabhatuma bhabhili ukufuma mu bhamanyili bhaake akati, “Bhuukagha mu Yelusaleemu, bhwo mwafika, indimukomaane nu muliisha yumo apimbite ingumbe iya miishi. Po mukongaghe, ");
INSERT INTO ndh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ukufika mu nyumba yiiyo akuya pakwingila. Po mumubhuule umwene nyumba muti, ‘UMumanyishi akubhuusha akuti, kali, chili kuughu ichipindwa icha bhaheesha? Paapo ingulonda ukulya ifindu ifya Pasaka pamupeene na bhamanyili bhangu.’ ");
INSERT INTO ndh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ghwepe umwene nyumba indiabhalangishe ichipindwa ichikulu icha pamwanya mu nyumba ingelesanie chiicho chitendekeshiighwe akiisa, umwo mwo muumwo mukatutendekeshekeshe ifindu.” ");
INSERT INTO ndh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abhamanyili bhakanyatuka ukubhuuka mu kaaya akakulu kala, bhakashaagha shooshi isa muumwo uYeesu akabhabhuula, po bhakatendekesha ifindu ifya Pasaka. ");
INSERT INTO ndh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bhwo lyabha lya namasubha, uYeesu na bhamanyili bhaake kalongo na bhabhili bhakafika nu kwikala mu nyumba yila. ");
INSERT INTO ndh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bhwo bhali pakulya pamupeene, uYeesu akabhabhuula akati, “Nalooli ingubhabhuula, umunyiinyu yumo yuuyo akulya pamupeene nuune, indiaambiike mu tukono utwa bhalughu.” ");
INSERT INTO ndh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Abhamanyili bhaake bhakaanda ukuswimaana, po yumo yumo akaanda ukumubhuusha uYeesu akati, “Kali, neene?” ");
INSERT INTO ndh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Akabhaamula akati, “Yumo pakati papiinyu, yuuyo akusaasila umukati pamupeene nuune mu kabhigha, ghwe yuuyo indiaambiike mu tukono utwa bhalughu. ");
INSERT INTO ndh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Paapo uMwana ughwa Mundu akuya pakughoghighwa isa muumwo shisimbiighwe mu Masimbo aMeelu. Loole lwake umundu yuuyo akuya pakumubhiika uMwana ughwa Mundu mu tukono utwa bhalughu. Kaali kiisa kukwake linga umundu uyo atakapaapighwanga.” ");
INSERT INTO ndh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bhwo bhali pakulya, uYeesu akeegha umukati, akapaalisha kwa Chaala, akaghubheghulania, akabhapa abhamanyili bhaake akati, “Eegha nu kulya umukati, ughu ghwo ghuughwo mubhili ghwangu.” ");
INSERT INTO ndh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Po akeegha ichikombe chiicho chikabha ni ndifaayi, akapaalisha kwa Chaala, akabhapa, bhoope bhakangʼwela bhooshi ichikombe chila chila. ");
INSERT INTO ndh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akabhabhuula akati, “Ili lyo liilyo libhanda lyangu ilya lwitikano liilyo likukupuka ku nongwa iya bhandu abhingi. ");
INSERT INTO ndh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nalooli ingubhabhuula inguti, indaaingangʼwe soona indifaayi ukufika pi ishiku liilyo indiingangʼwe indifaayi imbya mu chitangalala icha Chaala.” ");
INSERT INTO ndh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","UYeesu na bhamanyili bhaake bhwo bhiimba inyimbo, po bhakatiila nu kubhuuka ku kaghamba aka Mishunguti. ");
INSERT INTO ndh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","UYeesu akabhabhuula abhamanyili bhaake akati, “Umwe mweshi indimuunginde nu kuundeka. Paapo shisimbiighwe mu Masimbo aMeelu ukuti, ‘Indiingamukome umuliishi ughwa bhonangʼooshi, na bhonangʼooshi indibhakanyambaane.’ ");
INSERT INTO ndh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Loole bhwo naashuuka, indiingabhatangile ukubhuuka ku Ghalilaayi.” ");
INSERT INTO ndh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Loole umwene uPeeteli akamubhuula akati, “Nalinga bhooshi bhaakuleka, une indaaingakuleke naalumo.” ");
INSERT INTO ndh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","UYeesu akamwamula akati, “Nalooli ingukubhuula, umuusughu pabhushiku bhwo ubhiisa akaali ukubhika kabhili, indiubhe ghwangaana katatu.” ");
INSERT INTO ndh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Loole uPeeteli akashimikisha akati, “Nalinga shikulondighwa ukuti ifwe pamupeene nuughwe, une indaaingakuleke naalumo.” Abhamanyili bhooshi bhoope bhakayugha isa bhubhuubhwo. ");
INSERT INTO ndh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Po uYeesu na bhamanyili bhaake bhakafika mu chibheela chiicho ingamu yaake bhakatingi, Ghetiseemani. UYeesu akabhabhuula abhamanyili bhaake akati, “Mwikale panu bhwo une ingwipuuta.” ");
INSERT INTO ndh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Po akabheegha palubhafu uPeeteli, uYaakobhu nu Yoohani, akaanda ukuswimaana ngaani mu ndumbula yaake nu kulabha-labha. ");
INSERT INTO ndh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akabhabhuula akati, “Indi nu bhuswimaane ubhukulu ngaani mu ndumbula yangu ubhwa kuumbelela ukufwa. Po mwikale panu, mubhe maaso, manye mupitilaghe.” ");
INSERT INTO ndh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akabhiyila pandaashi panandi, akiitaagha paase, akiipuuta ukuti linga shiitikagha akabhalilo aka ndamyo ako manye kamwaghe. ");
INSERT INTO ndh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akayugha akati, “Ghwe Taata ghwangu, kukwako shooshi shibhaghiile ukubhombighwa, ingusuuma manye ushiitikishe kukwangu indamyo ingulu ishi! Manye ubhombe isa muumwo ingulondela, loole ubhombe isa muumwo kulondela.” ");
INSERT INTO ndh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Po akaghaluka ukubhuuka ku bhamanyili bhaake bhatatu bhala, akabhaagha bhapitiile. Akamubhuusha uPeeteli akati, “Ghwe Siimoni, kali, upitiile? Kali, ghwapootwa ukubha maaso nalinga kabhalilo akapimbaashe?” ");
INSERT INTO ndh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Soona akabhabhuula akati, “Mubhange maaso, soona mwipuutaghe ukuti ingelo manye shibhapoote. Indumbula shiinyu shikulonda ukubhomba inyiisa, loole mutali na maka.” ");
INSERT INTO ndh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Akabhuuka soona pakwipuuta nu kughalukila inyipuuto shila shila. ");
INSERT INTO ndh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Akaghaluka ku bhamanyili bhaake, akabhaagha bhapitiile soona, paapo amaaso ghaabho ghakabha ghali nu tulo. Akabhakemela, bhoope bhatakamanya ilya kumwamula. ");
INSERT INTO ndh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bhwo aabhiisila ulwa bhutatu ukufuma pakwipuuta, akabhabhuusha akati, “Kali, kooni mukwendelela ukupitila? Mwapitila kaaya! Tesha, akabhalilo kaafika kaako uMwana ughwa Mundu akuya pakubhiikighwa mu tukono utwa bhatulanongwa. ");
INSERT INTO ndh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lamusha! Tubhuuke. Tesha, yula yuuyo akwisa pakuumbiika mu tukono utwa bhalughu, aapalamila.” ");
INSERT INTO ndh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bhwo uYeesu akaali akuyugha, uYuuta yuuyo ghwe yumo mu bhamanyili kalongo na bhabhili (12) bhala, akiisa pamupeene ni chilundilo icha bhandu bhaabho bhakabha ni mipanga ni nduughu. Abhandu abho bhakabha bhatumiighwe na bhosongo abha bhapuuti, abhamanyishi abha ndaghilo isha Moose na bhosongo abha Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","UYuuta akatanga taashi ukubhalingaania ichilangisho abhandu bhala akati, “Umundu yuuyo naamulamuka ku sila iya kumwofwa, ghwe yuuyo mwise mumukolaghe nu kubhuuka naghwe bhwo mukumulindilila.” ");
INSERT INTO ndh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bhwo uYuuta aafikaashe, nakalinga, akabhuuka kwa Yeesu akati, “Ghwe Mumanyishi!” Po akamwofwa bhwo akumulamuka. ");
INSERT INTO ndh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Po abhandu bhala, bhakamukola uYeesu ku maka. ");
INSERT INTO ndh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Umumanyili yumo mu bhamanyili abha Yeesu bhaabho bhakabhaapo pabhuyo bhula, akafyutula lubhilo umumaaghi umutali ughwa bhwite, akapuupa ichuufwo icha mutumwa ughwa mupuuti usongo. ");
INSERT INTO ndh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","UYeesu akabhabhuusha akati, “Kali, mwisile ni mipanga ni nduughu pakuungola une ungati indi mundu yuuyo akuyikaanika isilikali? ");
INSERT INTO ndh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Amashiku ghooshi naabhanga pamupeene nuumwe, naamanyishanga mu lupaso ulwa Nyumba iya Chaala loole mutaangolagha. Loole mukuungola ulu ukuti imbombo ishi shibhe isa muumwo shisimbiighwe mu Masimbo aMeelu.” ");
INSERT INTO ndh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Po abhamanyili bhaake bhooshi bhakamuleka nu kukinda. ");
INSERT INTO ndh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Akabhaapo umulumyana yumo yuuyo akamukongagha uYeesu, akafwala igholole. Bhakaghela ukuti bhamukole ");
INSERT INTO ndh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","loole akapoota, akalileka igholole nu kukinda bhwo ali chitali. ");
INSERT INTO ndh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Po bhakabhuuka nu Yeesu kukaaya aka mupuuti usongo kuukwo abhosongo abha bhapuuti bhooshi na bhosongo abha Bhayuuta na bhamanyishi abha ndaghilo isha Moose bhakabha bhabhungaanite. ");
INSERT INTO ndh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","UPeeteli akamukongagha uYeesu pabhutaliipo, akiingila mu lupaso ulwa nyumba iya mupuuti usongo. Po akiikala pamupeene na bhalindilili, akootagha umulilo. ");
INSERT INTO ndh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abhosongo abha bhapuuti bhala ni Ibhalaasa lyoshi ilya Bhayuuta, bhakaanda ukulonda ubhukeeti ubhwa kumusitaakila uYeesu ukuti aghoghighwe, loole bhatakabhwagha ubhukeeti naabhumo. ");
INSERT INTO ndh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Abhandu abhingi bhakaanda ukumuyughila uYeesu ubhukeeti ubhwa bhumyashi, loole ubhukeeti bhwabho bhukaleghanagha. ");
INSERT INTO ndh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Po abhandu bhamu bhakiima nu kwanda ukumuyughila ubhukeeti ubhwa bhumyashi bhakati, ");
INSERT INTO ndh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tukamupulika umundu uyu bhwo akuti, ‘Une indiingapongolanie iNyumba iya Chaala iyi yiiyo yisengiighwe na bhandu. Po ku mashiku matatu, indiingasenge inine yiiyo yitakusengighwa na bhandu.’ ” ");
INSERT INTO ndh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Loole poope ubhukeeti ubhwa bhandu bhala bhukaleghanagha. ");
INSERT INTO ndh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Po umupuuti usongo akiima pandaashi pa bhandu bhala, akamubhuusha uYeesu akati, “Kali, utakwamula ni ishu naalimo ukukongana na shiisho abhandu abha bhakukusitaakila ughwe?” ");
INSERT INTO ndh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Loole uYeesu akasumbaashe chishita kwamula naalimo. Umupuuti usongo akamubhuusha soona akati, “Kali, ughwe ghwe Mesiiya, uMwana ughwa Chaala uMughindikighwa?” ");
INSERT INTO ndh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Po uYeesu akamwamula akati, “Une neene, indimukamubhone uMwana ughwa Mundu bhwo iikiile ku kakono aka kumwisa aka Chaala ughwa Maka Ghooshi. Soona indimukamubhone bhwo akwisa mu mabhingu ukufuma kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Po umupuuti usongo akaghunyaapulania umuselekesha ghwake, akabhuusha akati, “Kali, ulu tukulonda soona abhakeeti? ");
INSERT INTO ndh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ulu, mweshi mwapulika ukufuyula kwake! Kali, umwe mukwinongʼona kooni?” Bhooshi bhakatumula ukuti ali ni nongwa, aghoghighwe. ");
INSERT INTO ndh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Po bhamu bhakaanda ukumufwilila amati, bhakamwifunika ku maaso, bhakamukoma ni mbuli nu kumubhuusha bhakatingi, “Solola, kali, ghwini yuuyo aakukoma?” Bhoope abhalindilili bhakamwegha nu kumukoma na mapi. ");
INSERT INTO ndh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bhwo uPeeteli ali mu lupaso lula, akiisa umubhombi yumo umulindu ughwa mupuuti usongo. ");
INSERT INTO ndh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bhwo aamubhona uPeeteli akwota umulilo, akamutesha ngaani nu kumubhuula akati, “Nuughwe ghwali nu Yeesu ughwa mu Naasaleeti.” ");
INSERT INTO ndh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Loole uPeeteli akakaana akati, “Indamumeenye, soona indakushaaghania shiisho kuyugha.” UPeeteli akanyatuka ukubhuuka pakwikala ku mulyango ughwa lupaso. Po mu kabhalilo ako, ubhiisa akabhika. ");
INSERT INTO ndh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bhwo umubhombi yula aamubhona soona uPeeteli, akaanda ukubhabhuula abhandu bhooshi bhaabho bhakabhaapo pala akati, “Umundu uyu ghwepe ghwe yumo mu bhamanyili.” ");
INSERT INTO ndh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Loole uPeeteli akakaana soona. Bhwo kaakinda akabhalilo akapimba, abhandu bhaabho bhakiima pala bhakamubhuula uPeeteli bhakati, “Nalooli ughwe ghwe yumo mu bhamanyili paapo ughwe uli Mughalilaayi.” ");
INSERT INTO ndh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","UPeeteli akaanda ukwighuna nu kuloolika akati, “Une indamumeenye umundu uyu yuuyo mukumuyugha.” ");
INSERT INTO ndh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nakalinga, ubhiisa akabhika ulwa bhubhili. Po uPeeteli akakumbuka amashu ghaagho uYeesu akamubhuula akati, “Bhwo ubhiisa akaali ukubhika ulwa bhubhili, indiubhe ghwangaana katatu.” Po uPeeteli akaanda ukulila ngaani ku bhuswimaane. ");
INSERT INTO ndh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bhwo bhwacha pangeelo ngaani, abhosongo abha bhapuuti pamupeene na bhosongo abha Bhayuuta na bhamanyishi abha ndaghilo isha Moose ni Ibhalaasa lyoshi ilya Bhayuuta bhakayughisania isha kumusitaaka uYeesu. Po bhakamupinya, bhakamwegha nu kubhuuka naghwe kwa songo ughwa Bhalooma, yuuyo ingamu yaake akabha ghwi Pilaati. ");
INSERT INTO ndh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","UPilaati akamubhuusha uYeesu akati, “Kali, ughwe ghwe Malafyale ughwa Bhayuuta?” UYeesu akamwamula akati, “Ughwe ghweghwe ghwayugha.” ");
INSERT INTO ndh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Abhosongo abha bhapuuti bhakamusitaaka uYeesu inongwa inyingi. ");
INSERT INTO ndh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","UPilaati akamubhuusha soona uYeesu akati, “Kali, ughwe utakwamula naalimo? Tesha, bhakukusitaaka inongwa inyingi!” ");
INSERT INTO ndh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Loole uYeesu atakaamula naalimo, po uPilaati akaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bhwilaashe pa chaaka icha Pasaka, uPilaati akabha nu lwiho ulwa kumwabhula umupinyighwa yumo mu nyumba iya bhapinyighwa yuuyo abhandu bhakiighanagha. ");
INSERT INTO ndh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Po akabhaapo umundu yumo yuuyo ingamu yaake akabha ghwi Bhalabha yuuyo akapinyighwa mu nyumba iya bhapinyighwa pamupeene na bhanine. Bhakabhapinya ku nongwa iya kuti bhakabhaghogha abhashikali abha silikali iya Looma. ");
INSERT INTO ndh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mu kabhalilo kala kala bhwo uYeesu ali pandaashi pa Pilaati, abhandu abhingi bhakabhuuka kwa Pilaati nu kumusuuma ukuti amwabhule umupinyighwa yumo isa muumwo akubhombelagha ukukongana nu lwiho lwake. ");
INSERT INTO ndh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","UPilaati akabhabhuusha akati, “Kali, mukulonda imwabhule uMalafyale uyu ughwa Bhayuuta?” ");
INSERT INTO ndh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Akayugha ulwo paapo akamanya ukuti abhosongo abha bhapuuti bhiisile nu Yeesu kukwake ku nongwa iya lwibhuno. ");
INSERT INTO ndh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Loole abhosongo abha bhapuuti bhakabhasongelesha abhandu ukuti bhamusuume uPilaati amwabhule uBhalabha pa bhuyo ubhwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","UPilaati akabhabhuusha soona akati, “Kali, ulu imbombe kooni nu mundu uyu yuuyo mukumwitisha ukuti ghwi Malafyale ughwa Bhayuuta?” ");
INSERT INTO ndh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Abhandu bhooshi bhakaywegha ngaani bhakati, “Mukomeele pa chikobhekano!” ");
INSERT INTO ndh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","UPilaati akabhabhuusha akati, “Kali, atulite nongwa yiki?” Loole abheene bhakoongelaghaashe ukuywegha ngaani bhakatingi, “Mukomeele pa chikobhekano!” ");
INSERT INTO ndh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ku nongwa iya kuti uPilaati akalondagha ukuchihobhosha ichilundilo icha bhandu, po akamwabhula uBhalabha ukufuma mu nyumba iya bhapinyighwa. Po akabhalaghila abhashikali bhaake ukuti bhamukome uYeesu ni fikoti, soona bhamukomeele pa chikobhekano. ");
INSERT INTO ndh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Po abhashikali bhakamwegha uYeesu nu kumwingisha mu lupaso ulwa nyumba iya Pilaati. Po bhakabhabhungaania abhashikali bhooshi abha Looma bhaabho bhakabhaapo pala. ");
INSERT INTO ndh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhakamufwasha umwenda ughwa langi iya mandongomela, bhakaluka ingigha iya myifwa nu kumufwasha ku mutu ukuti abhonekaghe ukubha ungati ghwi malafyale. ");
INSERT INTO ndh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhakaanda ukumulamuka ku lufuuyo bhakati, “Ghwaghona, ghwe Malafyale ghwa Bhayuuta!” ");
INSERT INTO ndh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Po bhakamukoma pa mutu ni ilaashi, bhakamufwilila amati, bhakafughamilagha nu kumubhungulukila ku sila iya kumwangalila. ");
INSERT INTO ndh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bhwo bhaamala ukumwangalila, bhakamufuula umuselekesha ughwa mandongomela ghula nu kumufwasha imyenda yaake, bhakabhuuka naghwe pakumukomeela pa chikobhekano. ");
INSERT INTO ndh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bhwo bhali mu sila, bhakakomaana nu mundu yumo yuuyo ingamu yaake akabha ghwi Siimoni ukufuma mu kaaya aka Kileene yuuyo akafumagha kulubhafu ulwa mighunda, akabhuukagha mu kaaya akakulu. Umwene akabha ghwi ghwise ghwa Alekisanda nu Luufo. Po abhashikali bhakamufimbilisha ukuti apimbe ichikobhekano icha Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Po bhakabhuuka nu Yeesu pabhuyo bhula bhuubhwo bhakatingi Gholighoota, kwo kuti, “Bhuyo ubhwa Mungʼooso ughwa Mutu.” ");
INSERT INTO ndh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bhakamupa indifaayi ingali yiiyo bhakoongaania nu mukota ghuughwo bhakuti manemane ukuti manye apulikaghe ubhubhafu, loole umwene akakaana ukungʼwa. ");
INSERT INTO ndh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Po abhashikali bhakamukomeela uYeesu pa chikobhekano. Bhwo bhaamukomeela, bhakayabhana imyenda yaake ku sila iya kuyikomela ikuula ukuti yibhe yaani. ");
INSERT INTO ndh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Akabhalilo kaako bhakamukomeelagha uYeesu pa chikobhekano, kakabha ka pangeelo mu sala iya bhutatu (3:00). ");
INSERT INTO ndh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bhakasimba amasimbo agha kumusitaaka pamwanya pa chikobhekano ghaagho ghakatingi, ");
INSERT INTO ndh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bhakamukomeela uYeesu pa chikobhekano pamupeene na bhapoka ifya bhandu bhabhili, yumo ku kakono aka kumwisa nu munine ku kakono aka kushoomi.  ");
INSERT INTO ndh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Shooshi isho shikabhoneka isa muumwo shisimbiighwe mu Masimbo aMeelu ukuti, “Akabhelengelighwa pamupeene na bhatulanongwa.” ");
INSERT INTO ndh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Abhandu bhaabho bhakaghendagha pala, bhakapukushanga imitu yaabho nu kumutuka, bhakatingi, “Ehee! Ughwe ghwayughagha ukuti ubhaghiile ukupongola iNyumba iya Chaala nu kusenga ku mashiku matatu, ");
INSERT INTO ndh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","po ulu ipoka ghwimwene. Iika pa chikobhekano!” ");
INSERT INTO ndh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bhoope abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose bhakamwobhelagha bhakatingi, “Akabha mwengo ukubhapoka abhandu abhanine, loole atabhaghiile ukwipoka mwene! ");
INSERT INTO ndh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","UMesiiya, uMalafyale ughwa chiisu icha Isilaeli, iike pa chikobhekano ukuti tuteshe nu kumwitika!” Bhoope bhaabho bhakakomeelighwa pamupeene naghwe bhakamutukagha. ");
INSERT INTO ndh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Po ukwandila bhwo isubha lyafika pamutu (6:00) ukufika mu sala iya bhuhaano na inna (9:00), ichiisi chikaghwa ichiisu chooshi. ");
INSERT INTO ndh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mu kabhalilo ako, uYeesu akakuuta ku ishu ilya pamwanya nu kwitisha akati, “Elooyi! Elooyi! Lama sabhakitani?” Isanusho ilya mashu agho kwo kuti, “Ghwe Chaala ghwangu! Ghwe Chaala ghwangu! Kali, kooni ghuundekite?” ");
INSERT INTO ndh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abhandu bhamu bhaabho bhakiima pala bhwo bhaapulika amashu agho, bhakati, “Pulikisha! Akumwitisha umusololi uEliiya.” ");
INSERT INTO ndh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Po umushikali yumo akakinda nu kuyubhika umusapa mu ndifaayi ingali, akaghubhiika ku ilaashi, akamupa uYeesu ukuti angʼwe. Po umundu yula akati, “Muleke, indituteshe linga uEliiya indiiise amwishe pa chikobhekano apo!” ");
INSERT INTO ndh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Po uYeesu akakuuta ku ishu ilya pamwanya, akeesheela ku maka nu kufwa. ");
INSERT INTO ndh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Po ipasiya liilyo likabha mu Nyumba iya Chaala likanyaapuka imbafu shibhili ukufuma kumwanya ukufika paase. ");
INSERT INTO ndh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Usongo yumo ughwa bhashikali akabha iimite mundaashi mwa Yeesu. Bhwo aamubhona uYeesu bhwo akufwa, akayugha akati, “Nalooli umundu uyu aali Mwana ghwa Chaala!” ");
INSERT INTO ndh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bhakabhaapo na bhakolo bhaabho bhakateshanga ku bhutaliishe. Abhakolo abho bhakabha bho abha: uMaliiya ughwa kufuma mu kaaya aka Maghatala, uSalome nu Maliiya ungʼina ughwa Yaakobhu umukeke nu Yoose. ");
INSERT INTO ndh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abhakolo abho bhakamukongagha nu kumubhombela uYeesu bhwo ali mu Ghalilaayi. Bhakabhaapo na bhakolo abhanine abhingi bhaabho bhakiisa naghwe mu Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ishiku lila liilyo uYeesu akafwanga likabha lishiku lya Pabhuhaano liilyo likabha lya kwitendekesha ku nongwa iya Sabhati. ");
INSERT INTO ndh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Bhwo kaafika akabhalilo aka namasubha, akiisa uYoosefu ughwa mu kaaya aka Alimataayi yuuyo akabha mundu ughwa Libhalaasa ilya Bhayuuta, soona akabha mughindikighwa leka. Ghwepe akalindililagha ukwisa ukwa chitangalala icha Chaala. Akiikasha nu kubhuuka kwa Pilaati pakumusuuma ukuti amupe umufimba ughwa Yeesu ukuti aye aghushiile. ");
INSERT INTO ndh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","UPilaati akaswigha leka ukupulika ukuti uYeesu aafwa ku kabhalilo akapimbaashe. Po akamwitisha usongo yumo ughwa bhashikali ukuti ashimikishe linga nalooli uYeesu afwile akabhalilo kaako kaakinda. ");
INSERT INTO ndh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bhwo usongo yula aamubhuula uPilaati ukuti nalooli uYeesu afwile, po akamwitikisha uYoosefu ukuti aghweghe umufimba ughwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Po uYoosefu akaghula umwenda umwelu ughwa kumushiilila, akaghwilomusha umufimba ukufuma pa chikobhekano, akaghuniembetelela nu mwenda umwelu ghula. Akaghubhiika mu ipumba liilyo likabha likumbile ngaanila pa lyalabhwe. Po akalibhungunia iyondo ikulu ku mulyango ughwa lipumba lila. ");
INSERT INTO ndh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","UMaliiya ughwa mu kaaya aka Maghatala nu Maliiya ungʼina ughwa Yoose bhakapabhona paapo bhakamughoneka uYeesu. ");
INSERT INTO ndh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Akabhalilo aka namasubha bhwo iSabhati yaashila, uMaliiya ughwa mu kaaya aka Maghatala, uSalome nu Maliiya ungʼina ughwa Yaakobhu bhakaghula inyemba shiisho shikanuukilagha akiisa ukuti bhaye bhaghupake umubhili ughwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pangeelo ngaani pi ishiku ilya Pamulungu, bhakalaabhila ukubhuuka ku ipumba bhwo isubha likusopa. ");
INSERT INTO ndh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bhwo bhali mu sila, bhakaanda ukubhuusania bheene-bheene ukuti, “Kali, ghwini yuuyo indiaye atubhungunikishe iyondo lila pa mulyango ughwa pi ipumba?” ");
INSERT INTO ndh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bhakayugha ulwo ku nongwa iya kuti iyondo lila likabha likulu leka. Loole bhwo bhakutesha pi ipumba, bhakaagha iyondo libhungunie. ");
INSERT INTO ndh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bhwo bhiingila mukati mu ipumba, bhakamwagha umulumyana yumo afwalite umwenda umwelu, iikiile kulubhafu ulwa ku kakono aka kumwisa. Po abhakolo bhala bhakaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Umulumyana yula akabhabhuula akati, “Manye muswighaghe. Mukumulonda uYeesu ughwa mu Naasaleeti yuuyo bhaamukomeelite. Ataliimwo muno! Ashuukite! Isagha mupateshe paapo bhaamughonekite. ");
INSERT INTO ndh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Po bhuukagha, mubhabhuule abhamanyili bhaake pamupeene nu Peeteli ukuti, abhatangiile ukubhuuka mu chiisu icha Ghalilaayi. Ukwo kwo kuukwo indimukamwaghe isa muumwo akabhabhuulila.” ");
INSERT INTO ndh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Po bhakatiila lubhilo lubhilo pi ipumba pala paapo bhakatetemagha ku nongwa iya bhwogha ni chiswigho. Bhatakamubhuula umundu naayumo inongwa ishi paapo bhakooghopagha leka.  ");
INSERT INTO ndh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pi ishiku ilya Pamulungu pangeelo bhwo uYeesu aashuuka, akiilangisha taashi kwa Maliiya ughwa mu Maghatala yuuyo uYeesu akashikiisha imbepo imbiibhi ihaano na shibhili (7) amashiku agha kunyuma. ");
INSERT INTO ndh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Po uMaliiya ukufuma mu kaaya aka Maghatala akabhuuka pakubhalingaania bhala bhaabho bhakabhanga pamupeene nu Yeesu nu kubhaagha bhali pa ifwa bhakulila. ");
INSERT INTO ndh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Loole bhwo bhaapulika ukuti uYeesu mwumi nu kuti ghwepe uMaliiya ughwa mu Maghatala aamubhona, bhatakiitika na kaakanandi. ");
INSERT INTO ndh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bhwo isho shaakinda, abhakongi bhabhili bhakafuma ku Yelusaleemu, bhakabhuukagha ku mighunda. UYeesu akabhabhonekela abhakongi abho, loole abheene bhatakamumanya paapo akasanuka icheeni nu kubha ungati mundu munine. ");
INSERT INTO ndh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bhoope bhakaghaluka ku Yelusaleemu pakubhabhuula abhanine, poope bhatakiitika. ");
INSERT INTO ndh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pabhumalilo uYeesu akabhabhonekela abhamanyili kalongo na yumo (11) bhwo bhali pakulya. Akabhakemela ngaani ku nongwa iya kushita kwitika kwabho nu bhukafu ubhwa ndumbula shaabho, paapo bhatakabhiitika bhaabho bhakamubhona bhwo aashuuka. ");
INSERT INTO ndh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Po akabhalaghila akati, “Bhuukagha mu chiisu chooshi, mukalumbililaghe iNongwa iNyiisa iya Chaala ku bhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Umundu ghweshi yuuyo akwitika nu kwoshighwa, indiakapokighwe, loole yuuyo akukaana ukwitika, indiakalongighwe. ");
INSERT INTO ndh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ifyika fyoshi ifi indifikabhombighwange na bhandu bhaabho bhiitikite, indibhakashikiishange imbepo imbiibhi mu ngamu yangu nu kuyugha injugha imbya. ");
INSERT INTO ndh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Linga bhaakola injoka pamu ukungʼwa umukota ghuughwo ghukughogha, bhataabhakabhinaghe pamu ukufwa. Linga bhaabhabhiikila utukono abhabhine, abhabhine abho indibhakapolaghe.” ");
INSERT INTO ndh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bhwo uMalafyale uYeesu aayugha na bhamanyili bhaake bhala, akeeghighwa ukubhuuka kumwanya, akiikala ku kakono aka kumwisa aka Chaala. ");
INSERT INTO ndh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abhamanyili bhaake bhakabhuuka pakulumbilila pooshi pala. UMalafyale uYeesu akabhombagha imbombo pamupeene nabho nu kushimikisha iNongwa iNyiisa isha Chaala mu fyika fiifyo fikabhombighwanga nabho.");
INSERT INTO ndh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ghwe mughindikighwa Tiyofiilo, abhandu abhingi bhaghelite ukusimba inongwa isha mbombo shiisho uChaala ashibhombite pakati papiitu. ");
INSERT INTO ndh_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bhakashisimba shooshi isa muumwo bhakatupangilagha bhala bhaabho bhakashibhona ukufuma kubhwandilo ubhwa bhwumi ubhwa Yeesu Kilisiti pa chiisu ichi, soona bhakamubhombela uChaala ku sila iya kubhabhuula abhandu ishu lyake. ");
INSERT INTO ndh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Bhwo naabhuushikisha ku bhandu nu kubhwagha ubhwanalooli ubhwa nongwa shooshi isha Yeesu ukufuma kubhwandilo, po naagha kiisa ukuti nuune ingusimbile ughwe Tiyofiilo shooshi ku lubhaatiko ulwisa. ");
INSERT INTO ndh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ingukusimbila ishi ukuti ubhumanye ubhwanalooli ubhwa nongwa shooshi isha Yeesu Kilisiti shiisho abhandu bhakakumanyishanga. ");
INSERT INTO ndh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bhwo umalafyale uHelooti akaali akulongosha ichiisu icha Yuteeya, akabhaakwo umupuuti yumo yuuyo ingamu yaake akabha ghwi Sakaliiya. USakaliiya akafumagha mu chibhughutila icha bhapuuti icha Abhiya. USakaliiya akabha nu mukashi yuuyo ingamu yaake akabha ghwi Lisabheeti. ULisabheeti akafumagha mu chikolo icha mupuuti uAaloni. ");
INSERT INTO ndh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","USakaliiya nu mukashi uLisabheeti bhooshi bhakabhombagha shiisho shibhaghiile pandaashi pa Malafyale uChaala ku nongwa iya kuti bhakashibhombelagha imbombo akiisa indaghilo shaake shooshi isa muumwo akabhalaghilila. ");
INSERT INTO ndh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Loole abhandu abha bhatakabha nu mwana naayumo ku nongwa iya kuti uLisabheeti akabha mughumba, soona bhooshi bhabhili bhakabha bhaghome leka. ");
INSERT INTO ndh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Po ishiku limo bhwo akabhalilo kaafika aka chibhughutila icha bhapuuti icha Sakaliiya ukubhomba imbombo yaabho, uSakaliiya ghwe yuuyo akabha pa mbombo mu Nyumba iya Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ukukongana nu lwiho lwabho, abhapuuti bhakamusala uSakaliiya ku sila iya kukoma ikuula ukuti iingile mu Nyumba iya Chaala, aye apembe ubhubhani pa chighemo. ");
INSERT INTO ndh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bhwo uSakaliiya ali pakupemba ubhubhani ubhwo mu Nyumba iya Chaala, ichilundilo ichikulu icha bhandu chiicho chikabha mu lupaso ulwa Nyumba iya Chaala chikiipuutagha. ");
INSERT INTO ndh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Po mu kabhalilo ako, ughwandumi ughwa Malafyale uChaala akamusetukila uSakaliiya. Ughwandumi uyo akiima kulubhafu ulwa kumwisa ulwa chighemo chila. ");
INSERT INTO ndh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Bhwo uSakaliiya aamubhona ughwandumi yula, akanyomoka leka nu kubha nu bhwogha ubhukulu. ");
INSERT INTO ndh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Loole ughwandumi yula akamubhuula akati, “Ghwe Sakaliiya, manye ghwoghopaghe, paapo uChaala aapulika inyipuuto shaako. Umukashi ghwako indiabhe pa bhungʼwamu nu kukupaapila umwana umuliisha yuuyo indiukamwite ingamu iya Yoohani. ");
INSERT INTO ndh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nuughwe indiukabhe nu lusekelo ulukulu leka, soona abhandu abhanine abhingi indibhakasekele leka bhwo aapaapighwa. ");
INSERT INTO ndh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Paapo uMalafyale uChaala indiakamubhiike umwana uyo ukubha ghwi songo. Ku nongwa iyo, ataaakangʼwange indifaayi ni fyakungʼwa ifinine fiifyo fikughaasha. UMbepo uMwelu indiakabhange pamupeene naghwe ukwandila akabhalilo kaako ali mu lufukwe ulwa ngʼina. ");
INSERT INTO ndh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ku sila iya fimanyisho ifya mwana uyo, aBhaisilaeli abhingi indibhakiilaataghe imbiibhi shaabho nu kumwitika soona uMalafyale uChaala ghwabho. ");
INSERT INTO ndh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Umwene indiakabhe ghwandumi ukufuma kwa Chaala, indiakalongoshighwange nu Mbepo uMwelu nu kubha na maka isa uEliiya. Indiakabhafwaniange abhapaapi na bhaana bhaabho. Indiakabhapelaghe abhandu ukuti bhabhe bhagholofu nu kubhatendekesha ukumupokeela uMalafyale bhwo akwisa.” ");
INSERT INTO ndh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Po uSakaliiya akamubhuusha ughwandumi akati, “Kali, indiimanye bhuleele ukuti shiisho ghwayugha indishibhombighwe nalooli? Naayugha ulwo ku nongwa iya kuti une nu mukashi ghwangu tughomite leka, tutabhaghiile ukupaapa nu mwana.” ");
INSERT INTO ndh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ughwandumi akamwamula uSakaliiya akati, “Ingamu yangu une nee Ghabhiliyeeli, nee ingumubhombelagha uChaala pandaashi papaake akabhalilo kooshi. UChaala ghwe yuuyo aandumite pakuyugha nuughwe nu kukubhuula inongwa inyiisa ishi. ");
INSERT INTO ndh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pulikisha, ku nongwa iya kuti utiitika shiisho naakubhuula, indiubhe ghwe chinuunu ukufika pi ishiku liilyo umwana indiakapaapighwange. Loole shiisho naakubhuula, indishikabhoneke ukubha sha nalooli mu kabhalilo kaako uChaala abhaatikite.” ");
INSERT INTO ndh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mu kabhalilo ako, abhandu bhala bhaabho bhakabha mu lupaso ulwa Nyumba iya Chaala bhwo bhakumulindilila uSakaliiya, bhakaswigha leka ku nongwa iya kuti akiikala akabhalilo akatali mu Nyumba iya Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bhwo uSakaliiya aafuma kuuse, akabhalingaaniaashe ukubhombela akakono kaake ku nongwa iya kuti akapootwa ukuyugha nabho. Po abheene bhakamanya ukuti shiliikwo shiisho uChaala aamusetulila bhwo ali mu nyumba iyo. ");
INSERT INTO ndh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bhwo amashiku ghaake agha kubhomba imbombo isha bhupuuti ghaashila, uSakaliiya akaghaluka kukaaya kaake. ");
INSERT INTO ndh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bhwo akabhalilo kaakinda, umukashi ughwa Sakaliiya akabha pa bhungʼwamu. Ku nongwa iya kubha pa bhungʼwamu ubhwo, uLisabheeti akiimama mu nyumba yaabho imyeshi mihaano chishita kubhoneka ku bhandu. ");
INSERT INTO ndh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Po uLisabheeti akiiyughaania mwene mu ndumbula yaake akati, “Tesha! UMalafyale uChaala aambelela ichisa nu kuunyaafwa une ukuti imbe pa bhungʼwamu. Ku sila iyo, aandiishikisha isoni pandaashi pa bhandu.” ");
INSERT INTO ndh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bhwo uLisabheeti aabha pa bhungʼwamu ubhwa myeshi mihaano na ghumo (6), uChaala akamutuma ughwandumi ghwake uGhabhiliyeeli mu chiisu icha Ghalilaayi, mu kaaya aka Naasaleeti. ");
INSERT INTO ndh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","UChaala akamutuma ku mulindu yumo yuuyo ingamu yaake akabha ghwi Maliiya, yuuyo akabha ataghonite naalumo nu muliisha. Umulindu uyo akashingilighwa nu mundu yumo yuuyo ingamu yaake akabha ghwi Yoosefu. UYoosefu uyo akafumagha mu chikolo icha malafyale uNdaabhiti. ");
INSERT INTO ndh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bhwo ughwandumi aafika paapo uMaliiya akabha, akamulamuka akati, “Ghwe Maliiya, ubhange nu lusekelo mu ndumbula yaako paapo uMalafyale uChaala aakusaya. UMalafyale ali pamupeene nuughwe.” ");
INSERT INTO ndh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Bhwo uMaliiya aapulika amashu agho, akanyomoka leka nu kwoghopa, akiibhuusha mu ndumbula yaake akati, “Kali, ukulamuka ukwa luko ulwo kwo kuti kooni?” ");
INSERT INTO ndh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Loole ughwandumi akamubhuula akati, “Ghwe Maliiya, manye ghwoghopaghe ku nongwa iya kuti uChaala aakusala ughwe ku bhwighane bhwake ukuti akusaye. ");
INSERT INTO ndh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tesha, indiubhe pa bhungʼwamu, indiukapaape umwana umuliisha yuuyo indiukamupe ingamu iya Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","UChaala indiakamubhiike umwana uyo ukubha ghwi songo, soona abhandu indibhakamwitishange ukuti Mwana ghwa Chaala Yuuyo Ali Pamwanya Ngaani ukukinda utundu twoshi. UMalafyale uChaala indiakamubhiike ukubha ghwi malafyale isa muumwo akamubhiika usekulu ghwake umalafyale uNdaabhiti. ");
INSERT INTO ndh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Indiakabhalongoshange abhandu ukufuma mu chikolo icha Yaakobhu bhwila na bhwila nu kuti ubhunyafyale bhwake indibhukabhange bhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Po uMaliiya akamubhuusha ughwandumi yula akati, “Kali, isho shibhaghiile ukubhombighwa bhuleele bhwo une indaghonite naalumo nu muliisha?” ");
INSERT INTO ndh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ughwandumi yula akamwamula akati, “Isho indishikabhombighwe ku maka agha Mbepo uMwelu yuuyo indiakiise kukwako na maka agha Chaala Yuuyo Ali Pamwanya Ngaani indighakakubhiike ukubha pa bhungʼwamu. Ku nongwa iyo, umwana yuuyo akuya pakupaapighwa, indiakabhe mwelu na bhandu indibhakamwitishange ukuti Mwana ghwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Pulikisha! Umukamu ghwako uLisabheeti ghwepe ali pa bhungʼwamu ubhwa mwana umuliisha pamupeene nu kuti aghomite leka. Abhandu bhakamuyughagha ukuti mughumba, loole ulu ali pa bhungʼwamu ubhwa myeshi mihaano na ghumo! ");
INSERT INTO ndh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Shooshi isho naayugha indishibhombighwe ku nongwa iya kuti uChaala abhaghiile ukushibhomba shooshi.” ");
INSERT INTO ndh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Po uMaliiya akamwamula akati, “Tesha, une nee mubhombi ughwa Malafyale, ingusuuma shibhombighwe kukwangu isa muumwo ghwayughila.” Pabhumalilo ughwandumi yula akatiilaapo pabhuyo bhula nu kumuleka uMaliiya. ");
INSERT INTO ndh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bhwo amashiku manandi ghaakinda, uMaliiya akatiila nu kubhuuka lubhilo ku kaaya kamu kaako kakabha mu chiisu icha tughamba utwa Yuuta. ");
INSERT INTO ndh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bhwo aafika pakaaya aka Sakaliiya, uMaliiya akiingila mu nyumba, akamwagha uLisabheeti, akamulamuka. ");
INSERT INTO ndh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nakalinga bhwo uLisabheeti aapulika ukulamuka ukwa Maliiya kula, umwana akanyeela-nyeela mu lufukwe ulwa Lisabheeti ukulangisha ulusekelo. Po amaka agha Mbepo uMwelu ghakamwisila uLisabheeti. ");
INSERT INTO ndh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Po uLisabheeti akayugha ku ishu ilya pamwanya, akamubhuula uMaliiya akati, “UChaala akusayite ughwe ukukinda abhakolo bhooshi, soona amusayite nu mwana yuuyo indiukapaape. ");
INSERT INTO ndh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kali, nongwa yiki ishi shikubhoneka kukwangu ukuti ungʼina ughwa Malafyale ghwangu iise kukwangu? ");
INSERT INTO ndh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Paapo nakalinga bhwo naapulika ukulamuka kwako, umwana yuuyo ali mu lufukwe lwangu aanyeela-nyeela ku lusekelo. ");
INSERT INTO ndh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","UMalafyale uChaala akusayite ku nongwa iya kuti ghwitikite ukuti indiashibhombe shooshi shiisho ayughite kukwako.” ");
INSERT INTO ndh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Po ghwepe uMaliiya akayugha akati, “Ingumupaala uMalafyale uChaala ku ndumbula yangu yooshi. ");
INSERT INTO ndh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Indumbula yangu yili nu lusekelo ku nongwa iya kuti uChaala ghwe yuuyo akuumboka une, ");
INSERT INTO ndh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ku nongwa iya kuti aambelela ichisa nu kuunyaafwa une ni mubhombi ghwake. Tesha, ukwandila ulu, abhandu bhooshi abha mbaapo isha chikolo ni chikolo indibhakayughaghe ukuti uChaala aasayite. ");
INSERT INTO ndh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Paapo uGhwa Maka aambombela imbombo ingulu leka isha kuswighisha, ingamu yaake mwelu. ");
INSERT INTO ndh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Akulangisha ichisa chaake ukufuma imbaapo yimo ukufika inine ku bhandu bhooshi bhaabho bhakumughindika. ");
INSERT INTO ndh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aabhalangisha abhandu ukuti ali na maka leka, ku sila iya kubhanyambaania bhooshi bhaabho bhali na miifuno. ");
INSERT INTO ndh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abhiishiishe abhomalafyale ukufuma pa fitengu fyabho, loole abhakweshiishe abhandu bhaabho bhakwiyiisha. ");
INSERT INTO ndh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abhapiile ifindu ifyisa abhandu bhaabho bhali ni sala, loole abhakishiishe tukono twene abhandu bhooshi bhaabho bhakabhi. ");
INSERT INTO ndh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Abhaafwishe abhandu bhaake aBhaisilaeli bhaabho bhakumubhombela, paapo akumbukite ulwitikano lwake ulwa kulangisha ichisa chaake akabhalilo kooshi. ");
INSERT INTO ndh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Akumbukite ukulangisha ichisa chaake bhwila na bhwila isa muumwo akayughila kwa Abhulahamu na ku fikolo fyake fyoshi.” ");
INSERT INTO ndh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Po uMaliiya akiikala pamupeene nu Lisabheeti imyeshi mitatu, pabhumalilo akaghaluka nu kubhuuka kukaaya kaake. ");
INSERT INTO ndh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bhwo akabhalilo kaafika aka Lisabheeti ukupaapa, akapaapa umwana umuliisha. ");
INSERT INTO ndh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Po bhwo abhapalamani na bhoghwamwabho bhaapulika ukuti uMalafyale uChaala aamupelela ichisa ichikulu, bhakasekela pamupeene naghwe. ");
INSERT INTO ndh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bhwo umwana aafikisha amashiku mahaano na matatu (8), abhapalamani na bhoghwamwabho bhakiisa pakutesha muumwo bhakumukwesulila umwana ukukongana nu lwiho lwabho. Soona bhakalondagha ukumupa umwana ingamu iya ghwise, iya Sakaliiya. ");
INSERT INTO ndh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Loole uLisabheeti akakaana, akabhabhuula akati, “Nashiku, ingamu yaake indiabhe ghwi Yoohani.” ");
INSERT INTO ndh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Abheene bhakamubhuusha bhakati, “Tesha, ataliipo umundu naayumo mu chikolo chaako ughwa ngamu iyo!” ");
INSERT INTO ndh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Po bhakamubhuusha nu Sakaliiya ku sila iya kumwimikila akakono ukuti bhamanye muumwo umwene akalondelagha ukumwita ingamu umwana ghwake. ");
INSERT INTO ndh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","USakaliiya akabhasuuma ukuti bhamupe ichitapwa icha kusimbaapo. Bhwo bhaamupa, uSakaliiya akasimba ulu, “Ingamu yaake ghwi Yoohani.” Bhwo abhandu bhooshi bhaashibhona shiisho ughwise akasimba, bhakaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nakalinga, uChaala akamwighula uSakaliiya umulomu nu lulimi lwake, ghwepe akaanda ukuyugha soona nu kumupaala uChaala. ");
INSERT INTO ndh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Po abhapalamani bhooshi bhakakolighwa nu bhwogha na bhandu bhakashiyughagha inongwa isho mu chiisu chooshi icha tughamba utwa Yuteeya. ");
INSERT INTO ndh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ghweshi umundu yuuyo akashipulika inongwa isho, akaanda ukwinongʼona mu ndumbula yaake nu kwibhuusha akati, “Kali, umwana uyu indiabhe mundu ghwa luko luki?” Bhakiinongʼonagha ulwo paapo bhakamanya ukuti amaka agha Malafyale uChaala ghaali pamupeene nu mwana uyo. ");
INSERT INTO ndh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Po bhwo uSakaliiya aanda ukuyugha soona, amaka agha Mbepo uMwelu ghakamwisila, ghwepe akaanda ukusolola akati, ");
INSERT INTO ndh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Apaalighwange uMalafyale uChaala, yuuyo abhandu abha Isilaeli bhakumwipuuta, ku nongwa iya kuti iisile ku bhandu bhaake nu kubhapoka. ");
INSERT INTO ndh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ghwepe atutumiile uMupoki ughwa Maka, yuuyo afumite mu chikolo icha malafyale uNdaabhiti, umubhombi ghwake. ");
INSERT INTO ndh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","UChaala akabhomba ulwo isa muumwo akayughila ukughendelela ku bhasololi bhaake abheelu abha bhwila. ");
INSERT INTO ndh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Indiakatupoke ukufuma ku maka agha bhalughu bhiitu bhooshi bhaabho bhakutukalalila. ");
INSERT INTO ndh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Abhombite ulwo ukulangisha ichisa chaake ku bhosekulu bhiitu nu kukumbuka ulwitikano lwake ulwelu luulwo akiitikana nabho. ");
INSERT INTO ndh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ulwo lwitikano luulwo uChaala akiitikana nu sekulu ghwitu uAbhulahamu. ");
INSERT INTO ndh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Akiitikana naghwe ukuti indiakatupoke ukufuma ku maka agha bhalughu bhiitu. Ku sila iyo, inditumwipuutaghe uChaala chishita bhwogha ");
INSERT INTO ndh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","bhwo tukubhomba shiisho shibhaghiile pandaashi papaake ni sha nalooli mu mashiku ghiitu ghooshi agha bhwumi bhwitu. ");
INSERT INTO ndh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ghwe mwana ghwangu, uChaala Yuuyo Ali Pamwanya Ngaani ukukinda utundu twoshi indiakubhiike ughwe ukubha musololi ghwake, paapo indiukatangile ukubhuuka pakutendekesha isila ku nongwa iya kwisa ukwa Malafyale. ");
INSERT INTO ndh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Indiubhabhuule abhandu bhaake ukuti uChaala indiabhapoke ku sila iya kubhahobhokela imbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","UChaala ghwitu akubhomba ulwo ku nongwa iya kuti ali ni chisa leka kukwitu. Indiakiise kukwitu ukufuma kumwanya isa muumwo isubha likubhalisha pangeelo, ");
INSERT INTO ndh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ukubhabhalisha abhandu bhaabho bhakwikala mu chiifuuni icha bhufwe, na bhooshi bhaabho bhakwoghopa ukufwa. Indiabhombe ulwo ku sila iya kutulongosha nu kutulindilila, ukuti twikalaghe ku lutengaano nu Chaala.” ");
INSERT INTO ndh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Po bhwo uYoohani akwendelela ukukula umubhili, uMbepo uMwelu akeendelela ukumupa amaka. Po akabhuuka nu kwikala mu lungalangala ukufika akabhalilo kaako akabhoneka pabhwelu ku Bhaisilaeli nu kwanda ukulumbilila kukwabho. ");
INSERT INTO ndh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mu mashiku ghala bhwo uYoohani aapaapighwa, uKayisaali yuuyo ingamu yaake akabha ghwi Aghuusito ghwe yuuyo akalongoshanga ichiisu icha Looma. UAghuusito akalaghila ukuti abhandu bhooshi bhaabho bhakiikalagha mu chiisu chooshi icha Looma, bhasimbighwe ingamu nu kubhabhelengighwa. ");
INSERT INTO ndh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ukusimbighwa ingamu nu kubhelengighwa ukwa bhandu ukwo kukabha kwa bhwandilo mu chiisu icha Looma bhwo uKileniyo akulongosha ichiisu icha Siiliya. ");
INSERT INTO ndh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Po abhandu bhooshi bhakaghaluka nu kubhuuka ku twaya utwa chikolo chaabho ukuti bhaye bhasimbighwe ingamu shaabho nu kubhelengighwa. ");
INSERT INTO ndh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Po ghwepe uYoosefu akatiila mu kaaya aka Naasaleeti kaako kali mu chiisu icha Ghalilaayi nu kubhuuka mu kaaya aka Bheetelehemu kaako kali mu chiisu icha Yuteeya muumwo umalafyale uNdaabhiti akapaapighwa. Ku nongwa iya kuti uYoosefu akafumila mu chikolo icha Ndaabhiti, yo yiiyo nongwa iyi akabhuuka ku Bheetelehemu pakusimbisha. ");
INSERT INTO ndh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","UYoosefu akabhuuka pakusimbighwa nu kubhelengighwa pamupeene nu Maliiya yuuyo akamushingila. Akabhalilo ako, uMaliiya akabha pa bhungʼwamu. ");
INSERT INTO ndh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bhwo bhali mu Bheetelehemu, akabhalilo kakafika aka Maliiya ukupaapa. ");
INSERT INTO ndh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Akapaapa umwana ghwake umuliisha, ukatoote, akamuniembetelela ni myenda nu kumughoneka mu chitiighi icha kuliishikisha ingʼombe. UMaliiya akabhomba ulwo ku nongwa iya kuti bhutakabhaamwo ubhuyo ubhwa kughona abheene mu nyumba isha bhaheesha. ");
INSERT INTO ndh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mu kabhalilo kala kala, bhakabhaapo abhaliishi bhamu abha bhonangʼooshi bhaabho bhakaliishanga ku chiposo kupiipi na kaaya aka Bheetelehemu. Abhaliishi abho bhakalindililagha abhonangʼooshi bhaabho pa kabhalilo aka pabhushiku. ");
INSERT INTO ndh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nakalinga, ughwandumi ughwa Malafyale akabhasetukila nu bhwelu ubhukulu ukufuma kwa Chaala bhukabhabhalila imbafu shooshi. Bhakaanda ukwoghopa leka. ");
INSERT INTO ndh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Loole ughwandumi akabhabhuula akati, “Pulikisha, manye mwoghopaghe, paapo niisa kukwinyu pakubhabhuula inongwa inyiisa iya lusekelo ulukulu yiiyo indiyibhahobhoshe abhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Umwana aapaapighwa umuusughu mu kaaya aka Bheetelehemu kaako uNdaabhiti akafumila. Umwana uyo indiakabhapokaghe abhandu bhooshi ukufuma ku mbiibhi shaabho, umwene ghwi Mesiiya, ghwi Malafyale. ");
INSERT INTO ndh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ichi cho chiicho chilangisho kukwinyu ukuti shiisho inguyugha sha nalooli, indimumwaghe umwana umufyele bhamuniembeteliile ni myenda, bhamughonekite mu chitiighi icha kuliishikisha ingʼombe.” ");
INSERT INTO ndh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nakalinga, ichilundilo ichikulu icha bhandumi chikiisa ukufuma kumwanya nu kwongaana pamupeene nu ghwandumi umunine yula, bhakamupaala uChaala bhakati, ");
INSERT INTO ndh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Apaalighwange uChaala yuuyo ali kumwanya, ulutengaano lubhange mu chiisu ku bhandu bhaabho uChaala abhapeliile ichisa.” ");
INSERT INTO ndh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bhwo abhandumi bhaatiila nu kubhuuka kumwanya, abhaliishi abha bhonangʼooshi bhala bhakayughisania bheene-bheene bhakati, “Tubhuuke luluulu ku kaaya aka Bheetelehemu ukuti tuye tuteshe shiisho shaabhombighwa shiisho uMalafyale aatubhuula ukughendela ku ghwandumi ghwake.” ");
INSERT INTO ndh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Po bhakabhuuka lubhilo ku Bheetelehemu kula. Bhwo bhaafika, bhakabhaagha uMaliiya nu Yoosefu, nu mwana umufyele aghonite mu chitiighi icha kuliishikisha ingʼombe. ");
INSERT INTO ndh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bhwo bhaamubhona umwana, bhakamubhuula ghweshi umundu inongwa shiisho ughwandumi akabhabhuula ku sha mwana uyo. ");
INSERT INTO ndh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Po abhandu bhooshi bhaabho bhakapulika inongwa shiisho abhaliishi bhala bhakabhabhuula, bhakaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Loole uMaliiya akashibhiika shooshi ishi mu ndumbula yaake nu kwendelela ukushiinongʼona. ");
INSERT INTO ndh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pabhumalilo, abhaliishi bhala bhakaghaluka kuukwo abhonangʼooshi bhaabho bhakabha bhwo bhakumupaala ngaani uChaala ku nongwa iya kuti shooshi shiisho bhakashipulika nu kushibhona, shikabhombighwa isa muumwo ughwandumi akabhabhuulila. ");
INSERT INTO ndh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bhwo umwana aafikisha amashiku mahaano na matatu (8) ukufuma muumwo akapaapighwa, bhakamukwesula nu kumupa ingamu iya Yeesu. Ingamu iyi yo yiiyo ughwandumi akamupa na bhwo ungʼina akaali ukubha pa bhungʼwamu. ");
INSERT INTO ndh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bhwo akabhalilo kaafika aka Maliiya ukwiyeelufya isa muumwo uChaala akalaghila mu ndaghilo isha Moose, uYoosefu nu Maliiya bhakamwegha umwana nu kubhuuka naghwe ku kaaya aka Yelusaleemu pakumubhiika pandaashi pa Malafyale uChaala ");
INSERT INTO ndh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","isa muumwo shisimbiighwe mu ndaghilo isha Moose ukuti, “Ghweshi umwana umuliisha ukatoote, akubha ghwa Malafyale uChaala.” ");
INSERT INTO ndh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Soona bhakabhuuka ku Yelusaleemu pakufumya ifyabhupe isa muumwo uMalafyale akamulaghilila uMoose mu ndaghilo shaake akati, “Indimukafumyange ingunda shibhili pamu utwana tubhili utwa ngunda.” ");
INSERT INTO ndh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mu kabhalilo ako, akabhaapo umundu yumo yuuyo ingamu yaake akabha ghwi Simiyooni yuuyo akiikalagha mu kaaya aka Yelusaleemu. USimiyooni akabhombagha shiisho shibhaghiile pandaashi pa Chaala nu kushibhombela imbombo indaghilo shaake. Ku fyinja ifyingi, uSimiyooni akalindililagha ukuti uChaala amutume uMesiiya ukwisa pakubhasubhaasha nu kubhapoka aBhaisilaeli. Soona, uSimiyooni akalongoshighwanga nu Mbepo uMwelu. ");
INSERT INTO ndh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","UMbepo uMwelu akamubhuula ukuti ataaakafwe bhwo akaali ukumubhona uMesiiya ukufuma kwa Malafyale. ");
INSERT INTO ndh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","UMbepo uMwelu akamulongosha uSimiyooni ukwingila mu lupaso ulwa Nyumba iya Chaala bhwo uYoosefu nu Maliiya bhiisa nu mwana uYeesu ukuti bhamubhiike pandaashi pa Chaala ukukongana ni ndaghilo isha Moose. ");
INSERT INTO ndh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Po abhapaapi bhaake bhakamupa uSimiyooni umwana, ghwepe akamupokeela mu tukono twake nu kumupaala uChaala akati, ");
INSERT INTO ndh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ghwe Malafyale ghwangu, ingukusuuma ghuunyiitikishe une ni mubhombi ghwako ukuti ifwe bhwo indi nu lutengaano, isa muumwo ukayughila. ");
INSERT INTO ndh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Paapo naamubhona na maaso ghangu yuneene uMupoki yuuyo afumite kukwako, ");
INSERT INTO ndh_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yuuyo umutumite pakubhapoka abhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Umwene ali ungati bhwelu ubhwa kulangisha ubhwanalooli bhwako ku bhandu bhooshi bhaabho bhataa Bhayuuta, soona ukughendela kukwake, abhandu bhaako aBhaisilaeli indibhaghindikighwange.” ");
INSERT INTO ndh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bhwo abhapaapi abha Yeesu bhaapulika shiisho uSimiyooni akashiyughagha isha mwana ghwabho, bhakaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Po uSimiyooni akabhasaya abhapaapi abha Yeesu nu kumubhuula uMaliiya akati, “Pulikisha, uChaala amusalite umwana uyu ukuti abhandu abhingi mu chiisu icha Isilaeli bhakayabhanikaghe. Abhandu bhooshi bhaabho indibhakamwitike, uChaala indiakabhasaye nu kubhapoka, loole bhooshi bhaabho bhataabhakamwitike, uChaala indiakabhalonge. Umwana uyu indiabhe ungati chilangisho chiicho chikubhalangisha abhandu ukubhuuka kwa Chaala, loole abhandu abhingi indibhakamukaanaghe. ");
INSERT INTO ndh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Soona, uChaala amusalite ukuti ashibhiikaghe pabhwelu inyinongʼono shiisho bhakwinongʼona mu ndumbula shaabho. Loole linga abhandu bhakumukaana, isho indishikakupelele ughwe ubhubhafu ubhukulu leka isa ubhubhafu ubhwa mumaaghi umutali ughwa bhwite linga ghukuyilasa indumbula yaako.” ");
INSERT INTO ndh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Soona mu lupaso ulwa Nyumba iya Chaala, akabhaamwo nu musololi umukolo yumo yuuyo ingamu yaake akabha ghwi Hana. Ughwise ughwa Hana akabha ghwi Faanweli yuuyo akafumagha mu chikolo icha Aasheli. UHana akabha mukolo umughome leka ughwa fyinja amalongo mahaano na matatu na finna (84). UHana akeeghighwa nu kwikala nu mulume ifyinja fihaano na fibhiliishe (7), po umulume akafwa. ");
INSERT INTO ndh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bhwo uHana mufwile, akiikalagha akabhalilo kooshi mu lupaso ulwa Nyumba iya Chaala muumwo akamwipuutagha uChaala pabhushiku na pamuusi. Soona, uHana akiiyiimagha ukulya ifindu akabhalilo kooshi bhwo akwipuuta kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bhwo uSimiyooni ali pakuyugha nu Yoosefu nu Maliiya mu lupaso ulwa Nyumba iya Chaala, uHana akiingila nu kwanda ukumupaala uChaala ku nongwa iya mwana uYeesu. Soona akeendelela ukushiyugha inongwa isha mwana uyo ku bhandu bhooshi bhaabho bhakabhaamwo mula, bhaabho bhakamulindililagha uMupoki ukwisa nu kubhapoka abhandu abha mu chiisu chooshi icha Isilaeli. ");
INSERT INTO ndh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bhwo uYoosefu nu Maliiya bhaamala ukushibhomba shooshi isa muumwo uMalafyale uChaala akabhalaghilila mu ndaghilo isha Moose, bhakamwegha uYeesu nu kughaluka mu kaaya kaabho aka Naasaleeti mu chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mu kaaya ako mwo muumwo uYeesu akeendelela ukukula umubhili nu kubha na maka na mahala amingi ku nongwa iya kuti uChaala akamughana nu kumusaya. ");
INSERT INTO ndh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Abhapaapi abha Yeesu bhakabha nu lwiho ulwa kubhuuka ku kaaya aka Yelusaleemu chooshi ichinja pakusekelela ichaaka icha Pasaka. ");
INSERT INTO ndh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bhwo uYeesu aabha ni fyinja kalongo na fibhili (12), umwene pamupeene na bhapaapi bhaake bhakakwela ukubhuuka ku Yelusaleemu pakusekelela ichaaka icha Pasaka ukukongana nu lwiho lwabho. ");
INSERT INTO ndh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Po bhwo bhaamala ukusekelela ichaaka, abhapaapi abha Yeesu na bhandu abhanine bhakatiila nu kughaluka mu twaya twabho. Loole uYeesu akashaala mu kaaya aka Yelusaleemu chishita Yoosefu pamu uMaliiya ukumanya ukuti bhatakabha pamupeene naghwe. ");
INSERT INTO ndh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bhwo abhapaapi bhaake bhakughaluka, bhakiinongʼonagha ukuti uYeesu akabha pamupeene na bhandu abhanine bhaabho bhakaghendagha pamupeene mu sila. Loole bhwo bhaaghenda isila iya lishiku limo chishita kumubhona, bhakaanda ukumulonda ku bhakamu na ku bhamanyani bhaabho. ");
INSERT INTO ndh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ku nongwa iya kuti abhapaapi bhaake bhakamulonda chishita kumwagha, pabhumalilo bhakaghaluka ukubhuuka ku Yelusaleemu bhwo bhakwendelela ukumulonda. ");
INSERT INTO ndh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pi ishiku ilya bhutatu, abhapaapi bhaake bhakamwagha uYeesu ali mu lupaso ulwa Nyumba iya Chaala, iikiile pakati pa bhamanyishi abha ndaghilo isha Moose, akubhapulikisha nu kubhabhuusha amabhuusho. ");
INSERT INTO ndh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Abhandu bhooshi bhaabho bhakamupulikishanga, bhakaswigha leka ku nongwa iya mahala ghaake na muumwo akaamulilagha akiisa shiisho bhakamubhuushanga. ");
INSERT INTO ndh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bhwo abhapaapi bhaake bhaamwagha, bhakaswigha leka. Po ungʼina akamubhuusha uYeesu akati, “Ghwe mwana ghwangu, kali, kooni ghwatubhombela utwe ulwo? Pulikisha, une nu ghuuso twalabha leka ukukulonda paapo twapaashanga leka.” ");
INSERT INTO ndh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Po uYeesu akabhaamula akati, “Ghwe maayi, kali, kooni mwandondagha? Kali, mutaameenye ukuti une ingulondighwa ukubha mu nyumba iya Taata uChaala?” ");
INSERT INTO ndh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Loole abhapaapi bhaake bhatakashaaghania shiisho uYeesu akabhabhuulagha. ");
INSERT INTO ndh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Po uYeesu akiilomuka nu kubhuuka pamupeene na bhapaapi bhaake ku kaaya aka Naasaleeti, ghwepe akeendelela ukubhapulika abhapaapi bhaake akabhalilo kooshi. Loole ungʼina akashibhiika shooshi isho mu ndumbula yaake nu kwendelela ukushiinongʼona. ");
INSERT INTO ndh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Po uYeesu akeendelela ukukula umubhili nu kubha na mahala. UChaala na bhandu bhakeendelela ukumughana. ");
INSERT INTO ndh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mu chinja icha kalongo na fihaano (15) bhwo uKayisaali uTibheeliyo akulongosha ichiisu icha Looma, bhakabha bhasaliighwe uPontiyo Pilaati ukulongosha ichiisu icha Yuteeya, umalafyale uHelooti ukulongosha ichiisu icha Ghalilaayi, uFilipu umukulu ughwa Helooti ukulongosha ichiisu icha Ituleeya ni cha Tulakoniiti nu Lisaniya ukulongosha ichiisu icha Abhileene, ");
INSERT INTO ndh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","soona uAnasi nu Kayaafa bhakabha bhosongo abha bhapuuti. Mu kabhalilo ako, uChaala akayugha nu Yoohani, umwana ughwa Sakaliiya yuuyo akiikalagha mu lungalangala. ");
INSERT INTO ndh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Po uYoohani akabhuuka mumbafu shooshi shiisho shikabha papiipi nu lusooko ulwa Yoolotani, akalumbililagha ku bhandu ukuti bhiilaataghe imbiibhi nu kwoshighwa ukuti uChaala abhahobhokele imbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isho shikabhoneka isa muumwo umusololi uYesaaya akasimba ukuti, “Umundu yumo indiakayughaghe ku ishu ilya pamwanya ukufuma mu lungalangala akatingi, ‘Tendekeshanga isila iya Malafyale, gholoshanga muumwo indiakaghendaghe. ");
INSERT INTO ndh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yooshi indebheela indiyikashiilighwe, kooshi akaghamba ni chighamba indifikabhe ndebheela. Gholoshanga isila shooshi shiisho shiniongaanite, nu kupalania isila shooshi shiisho shili ni fibhwina. ");
INSERT INTO ndh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Po ghweshi umundu indiakabhwaghe ubhupoki ukufuma kwa Chaala.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Po uYoohani akabhabhuulagha abhandu abhingi bhaabho bhakiisagha kukwake ukuti abhooshe, akatingi, “Mwe bhabhiibhi ungati njoka umwe! Kali, ghwini yuuyo abhasokite ukuti mulikindaghe ilyoyo ilya Chaala? ");
INSERT INTO ndh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bhombagha shiisho shikulangisha ukuti mupindukite nu kuti mwilaatite imbiibhi shiinyu shooshi. Manye mwifunaghe ukuti, ‘Usekulu ghwitu utwe ghwi Abhulahamu.’ Ingubhabhuula ukuti uChaala abhaghiile ukumupa uAbhulahamu abhaana ukufuma mu mayondo agha! ");
INSERT INTO ndh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","UChaala ali papiipi ukumulonga umundu ghweshi yuuyo atakubhomba imbombo inyiisa isa umundu yuuyo abhiikite isembe pi ikolo pi ikokwe, ukuti lyoshi ikokwe liilyo litakwela iseke inyiisa, akulyomola nu kulitaagha mu mulilo.” ");
INSERT INTO ndh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Po bhwo abhandu abhingi bhala bhaapulika, bhakaanda ukumubhuusha bhakati, “Kali, tubhombe kooni ukulangisha ukuti twilaatite imbiibhi shiitu?” ");
INSERT INTO ndh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","UYoohani akabhaamula akati, “Umundu ghweshi yuuyo ali ni myenda mibhili iya kufwala, amuyabhile ghumo umundu yula yuuyo atali naghwo, ghwepe umundu yuuyo ali ni findu, amuyabhile fimo umundu yula yuuyo atali nafyo.” ");
INSERT INTO ndh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abhasongesha songo bhamu bhaabho bhakabhuuka ukuti uYoohani abhooshe bhoope, bhakamubhuusha bhakati, “Ghwe Mumanyishi, kali, nuutwe tubhombe kooni ukulangisha ukuti twilaatite imbiibhi shiitu?” ");
INSERT INTO ndh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","UYoohani akabhaamula akati, “Manye mubhasongeshange abhandu isongo iya pamwanya ukukinda yiiyo isilikali yibhalaghiile ukusongesha.” ");
INSERT INTO ndh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Po abhashikali bhamu bhoope bhakamubhuusha uYoohani bhakati, “Kali, nuutwe tubhombe kooni?” Ghwepe akabhaamula akati, “Manye mweghaghe indalama isha bhandu ku maka, soona manye mubhayughilaghe ubhumyashi abhandu ukuti mushaaghe indalama, loole mwiyiilaniange nu mufwalo ghwinyu.” ");
INSERT INTO ndh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ku mashiku agho abhandu bhakabha bhakulindilila ukwisa ukwa Mesiiya. Ku nongwa iyo, abhandu bhala bhakaanda ukwinongʼona ukuti lumo uYoohani ghwe yuuyo ghwi Mesiiya. ");
INSERT INTO ndh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Po uYoohani akabhaamula bhooshi akati, “Une ingubhoosha umwe na miishi, loole akwisa umundu ughwa maka ukuunginda une, yuuyo indabhaghiile ukubha mubhombi ghwake, soona indabhaghiile ukufulama nu kusatula utughoye utwa filato fyake. Uyo ghwe yuuyo indiakabhooshange umwe nu Mbepo uMwelu nu mulilo. ");
INSERT INTO ndh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Umwene indiakabhapaaghulanie abhiisa ukufuma mu bhatulanongwa isa muumwo umulimi akupeeta amapeeta ukufuma mu fyakwinula. Indiakabhabhungaanie abhiisa isa muumwo umulimi akubhungaania ifyakwinula nu kubhiika mu ighulu lyake. Indiakabhaponie abhatulanongwa mu mulilo ghuughwo ghutakushima naalumo isa muumwo umulimi akupemba amapeeta.” ");
INSERT INTO ndh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Po uYoohani akashiyugha ni nine inyingi ukubhasoka abhandu ukuti bhiilaataghe imbiibhi shaabho bhwo akulumbilila kukwabho iNongwa iNyiisa. ");
INSERT INTO ndh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Soona, uYoohani akamukemela umalafyale uHelooti ku nongwa iya kumwegha uHelotiiya yuuyo akabha mukashi ghwa Filipu, umunungʼuna ghwake na ku nongwa iya mbiibhi inyingi shooshi shiisho uHelooti akashibhombagha. ");
INSERT INTO ndh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Po uHelooti akoongelesha ubhubhiibhi ubhunine ku mbiibhi shaake inyingi ku sila iya kubhalaghila abhashikali bhaake ukuti bhamukole uYoohani nu kumupinya mu nyumba iya bhapinyighwa. ");
INSERT INTO ndh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Akabhalilo kala kaako uYoohani akabhooshanga abhandu, akamwosha nu Yeesu. Po uYeesu akaanda ukwipuuta kwa Chaala. Bhwo ali pakwipuuta, kumwanya kukiighuka. ");
INSERT INTO ndh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","UMbepo uMwelu akiika pamwanya papaake ungati ngunda. Po ishu ukufuma kumwanya likapulikighwa likati, “Ughwe ghwe Mwana ghwangu umughanighwa, inguhobhoka nuughwe.” ");
INSERT INTO ndh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","UYeesu akabha ni fyinja amalongo matatu (30) bhwo aanda imbombo yaake iya kulumbilila ku bhandu. Abhandu bhakiinongʼonagha ukuti uYeesu akabha mwana ghwa Yoosefu yuuyo akabha mwana ghwa Eeli. ");
INSERT INTO ndh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","UEeli akabha mwana ghwa Mataati, uMataati akabha mwana ghwa Laabhi, uLaabhi akabha mwana ghwa Meeliki, uMeeliki akabha mwana ghwa Yanaayi, uYanaayi akabha mwana ghwa Yoosefu. ");
INSERT INTO ndh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","UYoosefu akabha mwana ghwa Matatiiya, uMatatiiya akabha mwana ghwa Aamosi, uAamosi akabha mwana ghwa Nahuumu, uNahuumu akabha mwana ghwa Heesili, uHeesili akabha mwana ghwa Nangaayi. ");
INSERT INTO ndh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","UNangaayi akabha mwana ghwa Maati, uMaati akabha mwana ghwa Matatiiya, uMatatiiya akabha mwana ghwa Semeyiini, uSemeyiini akabha mwana ghwa Yooseki, uYooseki akabha mwana ghwa Yoota. ");
INSERT INTO ndh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","UYoota akabha mwana ghwa Yohanaani, uYohanaani akabha mwana ghwa Leesa, uLeesa akabha mwana ghwa Selubhabheli, uSelubhabheli akabha mwana ghwa Sheyalitiyeeli, uSheyalitiyeeli akabha mwana ghwa Neeli. ");
INSERT INTO ndh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","UNeeli akabha mwana ghwa Meeliki, uMeeliki akabha mwana ghwa Andi, uAndi akabha mwana ghwa Koosamu, uKoosamu akabha mwana ghwa Elimaatamu, uElimaatamu akabha mwana ghwa Eeli. ");
INSERT INTO ndh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","UEeli akabha mwana ghwa Yooshwa, uYooshwa akabha mwana ghwa Eliyeeseli, uEliyeeseli akabha mwana ghwa Yoolimu, uYoolimu akabha mwana ghwa Mataati, uMataati akabha mwana ghwa Laabhi. ");
INSERT INTO ndh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ULaabhi akabha mwana ghwa Simiyooni, uSimiyooni akabha mwana ghwa Yuuta, uYuuta akabha mwana ghwa Yoosefu, uYoosefu akabha mwana ghwa Yoonamu, uYoonamu akabha mwana ghwa Eliyaakimu. ");
INSERT INTO ndh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","UEliyaakimu akabha mwana ghwa Meleeya, uMeleeya akabha mwana ghwa Meena, uMeena akabha mwana ghwa Mataata, uMataata akabha mwana ghwa Naatani, uNaatani akabha mwana ghwa Ndaabhiti. ");
INSERT INTO ndh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","UNdaabhiti akabha mwana ghwa Yeese, uYeese akabha mwana ghwa Oobheti, uOobheti akabha mwana ghwa Bhoghwasi, uBhoghwasi akabha mwana ghwa Salumooni, uSalumooni akabha mwana ghwa Naashoni. ");
INSERT INTO ndh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","UNaashoni akabha mwana ghwa Aminandabhu, uAminandabhu akabha mwana ghwa Aalamu, uAalamu akabha mwana ghwa Hesolooni, uHesolooni akabha mwana ghwa Peelesi, uPeelesi akabha mwana ghwa Yuuta. ");
INSERT INTO ndh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","UYuuta akabha mwana ghwa Yaakobhu, uYaakobhu akabha mwana ghwa Isiyaka, uIsiyaka akabha mwana ghwa Abhulahamu, uAbhulahamu akabha mwana ghwa Teela, uTeela akabha mwana ghwa Nahooli. ");
INSERT INTO ndh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","UNahooli akabha mwana ghwa Selughi, uSelughi akabha mwana ghwa Leebhu, uLeebhu akabha mwana ghwa Peleeghi, uPeleeghi akabha mwana ghwa Eebheli, uEebheli akabha mwana ghwa Saala. ");
INSERT INTO ndh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","USaala akabha mwana ghwa Keenani, uKeenani akabha mwana ghwa Alufakisaati, uAlufakisaati akabha mwana ghwa Sheemu, uSheemu akabha mwana ghwa Nooghwa, uNooghwa akabha mwana ghwa Laameki. ");
INSERT INTO ndh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ULaameki akabha mwana ghwa Metuseela, uMetuseela akabha mwana ghwa Eenoki, uEenoki akabha mwana ghwa Yaleeti, uYaleeti akabha mwana ghwa Mahalaleeli, uMahalaleeli akabha mwana ghwa Keenani. ");
INSERT INTO ndh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","UKeenani akabha mwana ghwa Eenoshi, uEenoshi akabha mwana ghwa Seeti, uSeeti akabha mwana ghwa Aatamu. UAatamu akabha mwana ghwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bhwo uYeesu ooshighwa, akatiila mu lusooko ulwa Yoolotani nu Mbepo uMwelu akamulongosha ukufika mu lungalangala. ");
INSERT INTO ndh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Bhwo uYeesu ali mu lungalangala, uSeetano akabhuuka nu kumughela ku mashiku amalongo manna (40). UYeesu atakalyanga naakamu ku mashiku ghooshi agho. Po bhwo amashiku agho ghaakinda, isala yikamubhabha. ");
INSERT INTO ndh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ku nongwa iyo, uSeetano akamubhuula uYeesu akati, “Linga ughwe ghwe Mwana ghwa Chaala nalooli, libhuule iyondo ili lisanuke ukubha mukati.” ");
INSERT INTO ndh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Loole uYeesu akamwamula akati, “Nashiku, paapo shisimbiighwe mu Masimbo aMeelu ukuti, ‘Umundu atakubha mwumi ku nongwa iya kulya ifindu fyene.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Po uSeetano akabhuuka nu Yeesu pabhuyo ubhwa pamwanya ngaani, akamulangisha ubhunyafyale bhwoshi pamupeene nu bhukulumba bhwake ku kabhalilo akapimbaashe. ");
INSERT INTO ndh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Po akamubhuula uYeesu akati, “Une indiingupe amaka agha kulongosha ubhunyafyale nu bhukulumba bhwake, nuune imbaghiile ukumupa umundu ghweshi yula ku bhwighane bhwangu. ");
INSERT INTO ndh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Po linga ubhaghiile ukuufughamila nu kuunyiipuuta, indiingupe fyoshi ifi ukuti fibhe fyako.” ");
INSERT INTO ndh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","UYeesu akamwamula uSeetano akati, “Shisimbiighwe mu Masimbo aMeelu ukuti, ‘Mwipuutaghe uMalafyale uChaala ghwako, soona mubhombelaghe yuuyo mweneeshe.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Po uSeetano akamulongosha uYeesu ukubhuuka mu kaaya aka Yelusaleemu. Bhwo bhaafika, akamwimika pa kasonje aka Nyumba iya Chaala, akamubhuula akati, “Linga ughwe ghwe Mwana ghwa Chaala nalooli, iponia paase, ");
INSERT INTO ndh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","paapo shisimbiighwe ukuti, ‘UChaala indiakabhatume abhandumi bhaake kukwako ukuti bhakulindilile manye ufulale.’ ");
INSERT INTO ndh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Soona shisimbiighwe ukuti, ‘UChaala indiakabhatume abhandumi bhaake kukwako ukuti bhakupoke, manye utulundi twako twise twikome mu mayondo.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Loole uYeesu akamwamula uSeetano akati, “Shisimbiighwe mu Masimbo aMeelu ukuti, ‘Manye umughelaghe uMalafyale uChaala ghwako.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bhwo aamala ukumughela uYeesu mu sila shooshi isho, uSeetano akamuleka taashi ukufika akabhalilo akanine. ");
INSERT INTO ndh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Po uYeesu akaghaluka ukufuma mu lungalangala, akabhuuka mu chiisu icha Ghalilaayi bhwo uMbepo uMwelu akumulongosha. Inongwa shaake shikamanyikwa mu chiisu chooshi icho. ");
INSERT INTO ndh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Po akaanda ukumanyisha iNongwa iNyiisa mu masinaghoghi ghaabho. Abhandu bhooshi bhaabho bhakamupulikishanga, bhakamupaalagha. ");
INSERT INTO ndh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Po uYeesu akabhuuka mu kaaya aka Naasaleeti muumwo akakulilagha. Pi ishiku ilya Sabhati, akiingila mu sinaghoghi isa muumwo ulwiho lwake lukabheela. Bhwo iingila, akiima ukuti abhelenge aMasimbo aMeelu. ");
INSERT INTO ndh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Po umubhombi yumo akamupa uYeesu ukalata yuuyo akabha na mashu ghaagho ghakasimbighwa nu musololi uYesaaya. UYeesu akiifunula nu kubhelenga amashu ghaagho ghasimbiighwe ukuti, ");
INSERT INTO ndh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“UMbepo ughwa Malafyale akuundongosha ku nongwa iya kuti uChaala aasalite une pakubhalumbilila abhapiina iNongwa iNyiisa. Aandumite pakufumusha ukuti umwene indiabhaabhule bhaabho bhapinyiighwe nu kubhaposha abhafwamaaso ukuti bhateshange. Aandumite pakubhapoka bhooshi bhaabho abhandu bhakubhabhonela. ");
INSERT INTO ndh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Soona aandumite pakufumusha ukuti akabhalilo kaafika kaako indialangishe ichisa chaake ku bhandu.” ");
INSERT INTO ndh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bhwo uYeesu aabhelenga amashu agho, akakupika ukalata yula, akamughalushikisha umubhombi ughwa mu sinaghoghi, akiikala ukuti aande ukubhamanyisha abhandu. Po abhandu bhooshi bhaabho bhakabhaamwo mu sinaghoghi mula, bhakategheelesha ifyufwo fyabho ukuti bhamupulikishe. ");
INSERT INTO ndh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Po uYeesu akaanda ukubhabhuula abhandu bhala akati, “Amashu ghaagho mwapulika bhwo ingughabhelenga mu Masimbo aMeelu, ghaabhombighwa umuusughu.” ");
INSERT INTO ndh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Abhandu bhooshi bhaabho bhakabhaamwo mu sinaghoghi mula, bhakamupaalagha uYeesu nu kughaswigha amashu ghaake amiisa ghaagho akayughagha. Po bhakabhuusania bheene-bheene bhakati, “Kali, umundu uyu ataa mwana ghwa Yoosefu?” ");
INSERT INTO ndh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Po uYeesu akabhabhuula akati, “Indi nu bhwanalooli ukuti mukulonda ukuumbuula ubhuyughi bhuubhwo bhukuti, ‘Ghwe mughanga, iposha yughweghwe!’ Soona indimuyughe ukuti, ‘Imbombo shiisho tupulikite ukuti ukashibhombagha mu kaaya aka Kapenabhumu, shibhombe na mu kaaya kaako aka.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","UYeesu akeendelela ukuyugha akati, “Nalooli ingubhabhuula, umusololi atakughindikighwa na bhandu abha mu chiisu chaake. ");
INSERT INTO ndh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Loole ingubhabhuula ubhwanalooli ukuti bhakabhaakwo abhakolo abhafwile abhingi mu chiisu icha Isilaeli, mu kabhalilo kaako umusololi ughwa Chaala uEliiya akabha mwumi. Ku kabhalilo ako, ifula yitakatima ku fyinja fitatu ni myeshi mihaano na ghumo (6). Ku nongwa iyo, isala ingulu yikaghwa mu chiisu chooshi icha Isilaeli. ");
INSERT INTO ndh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Poope uChaala atakamutuma umusololi uEliiya pakumwafwa umukolo yumo mu bhakolo abhafwile bhala, loole akamutuma pakumwafwa umukolo yumo umufwile yuuyo atakabha Mwisilaeli yuuyo akiikalagha mu kaaya aka Saleeputa, mu chiisu icha Sindoni. ");
INSERT INTO ndh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Soona bhakabhaakwo abhandu abhingi bhaabho bhakabha ni mbungo iya makete mu chiisu icha Isilaeli mu kabhalilo kaako umusololi uEliisha akabha mwumi. Poope uChaala atakamuposha naayumo mu bhabhine bhala, loole akamuposha mwene uNaamani yuuyo atakabha Mwisilaeli, yuuyo akafumagha mu chiisu icha Siiliya.” ");
INSERT INTO ndh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bhwo abhandu bhooshi bhaabho bhakabha mu sinaghoghi mula bhaapulika amashu agho, bhakakalala leka. ");
INSERT INTO ndh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Po bhakiima, bhakamukola uYeesu nu kumufumya mu kaaya aka Naasaleeti. Po bhakamwegha nu kubhuuka naghwe pamwanya pa chighamba paapo akaaya kaabho kakasengighwa ukuti bhamuponie ukufuma pamwanya ukufika paase. ");
INSERT INTO ndh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Loole uYeesu akaghenda pakati pa chilundilo icha bhandu bhooshi bhala, akabhaleka nu kubhuuka. ");
INSERT INTO ndh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Po uYeesu akatiila mu kaaya aka Naasaleeti, akiilomuka nu kubhuuka mu kaaya aka Kapenabhumu kaako kali mu chiisu icha Ghalilaayi. Pi ishiku ilya Sabhati, uYeesu akiingila mu sinaghoghi nu kwanda ukubhamanyisha abhandu. ");
INSERT INTO ndh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Abhandu bhakaswighagha leka ni fimanyisho fyake ku nongwa iya kuti fikabha na maka. ");
INSERT INTO ndh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mu sinaghoghi mula, akabhaamwo umundu yumo yuuyo akakolighwa ni mbepo imbiibhi. Umundu uyo akakuuta ku ishu ilya pamwanya akati, ");
INSERT INTO ndh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ghwe Yeesu ughwa kufuma ku Naasaleeti! Kali, tuli bhuki tweshi? Kali, ghwisile pakutupyuta? Naakumanya ukuti ughwe ghwe Mwelu ghwe ufumite kwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Loole uYeesu akayikemela imbepo imbiibhi yila akati, “Ghwe mbepo imbiibhi ughwe, sumba! Fumaamwo mu mundu uyu!” Po imbepo imbiibhi yila yikamughwisha umundu yula pandaashi papaabho bhwo ghweshi umundu akutesha, yikafuma chishita kumufulasha. ");
INSERT INTO ndh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Abhandu bhooshi bhaabho bhakabhaapo pala, bhakaswigha leka nu kuyughisania bheene-bheene bhakati, “Ifimanyisho ifya mundu uyu fya kuswighisha leka! Paapo umundu uyu akushilaghila imbepo imbiibhi ku maka ukuti shifume, shoope shikufuma!” ");
INSERT INTO ndh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Inongwa isha Yeesu shikamanyikwa mu twaya twoshi utwa chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","UYeesu akafuma mu sinaghoghi, akabhuuka nu kwingila mu nyumba iya Siimoni Peeteli. Bhwo iingila, akamwagha ungʼinafyala ughwa Siimoni akoliighwe ni sekema ingali. Po bhakamusuuma uYeesu ukuti amuposhe. ");
INSERT INTO ndh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Po uYeesu akiima papiipi nu mubhine, akayikemela isekema yila. Bhwo aayikemela, umubhine yula akapola. Po akanyatuka nu kwanda ukumutendekeshekesha uYeesu ifindu. ");
INSERT INTO ndh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bhwo isubha likushiliilika, abhandu bhooshi bhaabho bhakabha na bhabhine abha luko nu luko, bhakabhuuka nabho kwa Yeesu. Bhwo bhaafika nabho kukwake, uYeesu akamuposhanga ghweshi umubhine ku sila iya kumubhiikila utukono pamwanya papaake. ");
INSERT INTO ndh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Soona akashikiishanga imbepo imbiibhi, shoope shikafumagha mu bhandu abhingi bhwo shikuywegha shikuti, “Ughwe ghwe Mwana ghwa Chaala!” Loole uYeesu akashikemela nu kushikaanisha ukuti manye sheendelelaghe ukumuyugha ku nongwa iya kuti shikamumanya ukuti ghwi Mesiiya. ");
INSERT INTO ndh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ishiku ilya ningeelo lyake bhwo bhwacha pangeelo, uYeesu akatiila muumwo akiikalagha nu kubhuuka pabhuyo ubhushiifu. Po ichilundilo icha bhandu chikaanda ukumulonda nu kumwagha paapo akabha. Bhwo bhaamwagha, bhakaghela ukumushighila ukuti manye atiilaghe nu kubhaleka. ");
INSERT INTO ndh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Loole umwene akabhabhuula akati, “Ingulondighwa ukulumbilila iNongwa iNyiisa isha chitangalala icha Chaala mu twaya utunine paapo imbombo iyi yo yiiyo uChaala akaanduma ukuti injibhombaghe.” ");
INSERT INTO ndh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Po akabhuuka mu twaya utwa mu chiisu icha Ghalilaayi, akeendelela ukulumbilila iNongwa iNyiisa mu masinaghoghi ghaabho. ");
INSERT INTO ndh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ishiku limo uYeesu akiima ku chiseese kwa sumbi ughwa Ghenesaleeti. Abhandu abhingi bhakiisa nu kubhungaana kupiipi kukwake ukuti bhapulikishe bhwo akumanyisha ishu ilya Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Po uYeesu akaghabhona amaato mabhili ghali ku chiseese kwa sumbi ghaagho abhalobha iswi bhakaghaleka bhwo bhali pakusuka ifilepa fyabho. ");
INSERT INTO ndh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","UYeesu akiingila mu bhwato bhumo bhuubhwo bhukabha bhwa Siimoni. Bhwo iingila, akamusuuma uSiimoni ukuti abhubhiyishe panandi mukati mwa sumbi. Bhwo uSiimoni aabhubhiyisha ubhwato bhula, uYeesu akiikala mukati, akaanda akuchimanyisha ichilundilo icha bhandu. ");
INSERT INTO ndh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bhwo uYeesu aamala ukumanyisha, akamubhuula uSiimoni akati, “Ghwe Siimoni, bhuuka nu bhwato pa chishibha ichitali, ponia ifilepa fyinyu ukuti mulobhe iswi shimo.” ");
INSERT INTO ndh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Po uSiimoni akamwamula akati, “Ghwe Malafyale, twayibhomba imbombo ingafu iyo ubhushiku bhwoshi, tutaalobha iswi naayimo, loole ku nongwa iya kuti ghweghwe ghwayugha, po indiimbonie ifilepa.” ");
INSERT INTO ndh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","USiimoni na bhanine bhakaponia ifilepa fyabho pa chishibha ichitali. Bhwo bhaaponia, bhakakola iswi inyingi leka ni filepa fyabho fikaanda ukukonoka. ");
INSERT INTO ndh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Po bhakabhiitisha abhanine bhaabho bhakabha mu bhwato ubhunine ukuti bhabhuuke pakubhaafwa. Abhanine bhala bhakabhuuka, bhooshi pamupeene bhakiisusha iswi na maato ghooshi mabhili ghakaanda ukutwibha. ");
INSERT INTO ndh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bhwo uSiimoni Peeteli aashibhona isho, akafughamila mundaashi mwa Yeesu, akayugha akati, “Ghwe Malafyale, ingukusuuma utiile kukwangu ku nongwa iya kuti une nee mutulanongwa.” ");
INSERT INTO ndh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","UPeeteli akayugha ulwo ku nongwa iya kuti umwene pamupeene na bhanine bhooshi bhakaswigha leka bhwo bhaalobha iswi inyingi. ");
INSERT INTO ndh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","USiimoni akabhombagha imbombo iya kulobha iswi pamupeene na bhaana bhabhili abha Sebhetaayi bhaabho ingamu shaabho ghwi Yaakobhu nu Yoohani. Bhoope bhakaswigha leka ku nongwa iya iswi inyingi shiisho bhakalobha. UYeesu akamubhuula uSiimoni akati, “Manye ghwoghopaghe, ukwandila umuusughu indiubhe mulobha bhandu.” ");
INSERT INTO ndh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Po bhakabhuuka na maato ghaabho ku chiseese kwa sumbi, bhakafileka fyoshi kula kula, bhakaanda ukumukonga uYeesu. ");
INSERT INTO ndh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ishiku limo uYeesu akiingila mu kaaya kamu. Mu kaaya ako akabhaamwo umundu yumo yuuyo akabha ni mbungo iya makete umubhili ghwoshi. Bhwo umundu uyo aamubhona uYeesu, akabhuuka nu kufughamila pandaashi papaake, akamusuuma akati, “Ghwe Malafyale, linga ghwighanite ubhaghiile ukuunyeelufya.” ");
INSERT INTO ndh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Po uYeesu akagholosha akakono kaake, akamweghelesha umubhine yula, akamubhuula akati, “Niighanite, elupa!” Nakalinga, umundu yula akapola, imbungo iya makete yila yikatiila mu mundu yula. ");
INSERT INTO ndh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Po uYeesu akamulaghila umundu yula akati, “Manye umubhuulaghe umundu naayumo inongwa ishi. Loole bhuuka ghwilangishe ku mupuuti nu kufumya ifyabhupe ifya kupemba isa muumwo uMoose akalaghilila ukulangisha ukuti upolite.” ");
INSERT INTO ndh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pamupeene nu kuti uYeesu akamulaghila umundu uyo ukuti manye afumushange inongwa shaake ku bhandu, poope shikoongelagha ukumanyikwa mumbafu shooshi. Ku nongwa iyo, abhandu abhingi bhakaanda ukubhungaana ukuti bhamupulikishe uYeesu nu kuti abhaposhe amabhine ghaabho. ");
INSERT INTO ndh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Loole mu tubhalilo utwingi uYeesu akiiyeemagha mwene pabhuyo ubhushiifu nu kwipuuta kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ishiku limo uYeesu akabhamanyishanga abhandu ishu ilya Chaala mu nyumba yimo. Mu bhandu abho bhakabhaamwo aBhafalisaayi na bhamanyishi abha ndaghilo isha Moose ukufuma mu twaya twoshi utwa mu chiisu icha Ghalilaayi, icha Yuteeya na mu kaaya aka Yelusaleemu. Amaka agha Malafyale uChaala ghakabha pamupeene nu Yeesu bhwo akubhaposha abhabhine. ");
INSERT INTO ndh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Po bhwo uYeesu ali pakumanyisha mu nyumba mula, abhandu bhamu bhakiisa kwa Yeesu nu mundu yuuyo akabha alalite, aghonite pa bhulili. Bhwo bhaafika, bhakaghela ukumwingisha mu nyumba yila ukuti bhamubhiike paapo uYeesu akabha. ");
INSERT INTO ndh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Loole bhakapootwa ukumwingisha umubhine yula ku nongwa iya kuti abhandu bhakabha bhingi leka. Po bhakakwela nu mubhine yula pa kasale, bhakanyolola ubhwashi. Bhwo bhaanyolola, bhakamwilomusha umubhine mu bhulili nu kumufikisha pakati pa bhandu paapo uYeesu akabha. ");
INSERT INTO ndh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bhwo uYeesu aatesha ulwitiko lwabho, akamubhuula umubhine yula akati, “Ghwe mumanyani ghwangu, naakuhobhokela imbiibhi shaako.” ");
INSERT INTO ndh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bhwo aBhafalisaayi na bhamanyishi abha ndaghilo isha Moose bhaapulika muumwo uYeesu akayughila, bhakaanda ukubhuusania bheene-bheene bhakati, “Kali, mundu yuki uyu yuuyo akumufuyula uChaala? Ataliipo umundu naayumo yuuyo abhaghiile ukubhahobhokela abhandu imbiibhi shaabho, loole uChaala mwene.” ");
INSERT INTO ndh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Loole uYeesu akashaaghania inyinongʼono shaabho. Po akabhabhuusha akati, “Kali, kooni mukwinongʼona isho mu ndumbula shiinyu? ");
INSERT INTO ndh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kali, liliku liilyo lipepe, ukumubhuula ughwa bhulale ukuti, ‘Ghwahobhokelighwa imbiibhi shaako,’ pamu ukumubhuula ukuti, ‘Nyatuka, ghendagha’? ");
INSERT INTO ndh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ingulonda mumanye ukuti uMwana ughwa Mundu ali na maka mu chiisu ichi ukuhobhokela imbiibhi.” Po akamubhuula umundu ughwa bhulale yula akati, “Ghwe mwana ghwangu, ingukubhuula, nyatuka, pimba ubhulili bhwako, bhuukagha kukaaya kaako.” ");
INSERT INTO ndh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nakalinga, umundu yula akapola nu kwima bhwo abhandu bhooshi bhaabho bhakabhaapo pala bhakutesha, akapimba ubhulili bhwake nu kubhuuka kukaaya kaake bhwo akumupaala uChaala. ");
INSERT INTO ndh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Abhandu bhooshi bhakaswigha leka nu kumupaala uChaala. Bhakooghopa leka nu kughaswigha amaka agha Chaala muumwo ghabheeliile, bhakayugha bhakati, “Umuusughu twachibhona ichiika icha kuswighisha!” ");
INSERT INTO ndh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bhwo isho shaakinda, uYeesu akatiila pabhuyo bhula. Bhwo akubhuuka, akamubhona umusongesha songo yumo yuuyo ingamu yaake akabha ghwi Laabhi. ULaabhi akabha iikiile mu nyumba muumwo akasongeshanga isongo. Po uYeesu akamubhuula akati, “Ghwe Laabhi, ingongaghe.” ");
INSERT INTO ndh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nakalinga, uLaabhi akanyatuka, akafileka fyoshi, akaanda ukumukonga uYeesu. ");
INSERT INTO ndh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Po uLaabhi akamutendekeshekesha uYeesu ifindu mu nyumba yaake. Mu nyumba yila, chikabhaamwo ichilundilo ichikulu icha bhasongesha songo na bhandu abhanine abhingi bhaabho bhakalyanga pamupeene nu Yeesu na bhamanyili bhaake. ");
INSERT INTO ndh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Loole aBhafalisaayi na bhamanyishi abha ndaghilo isha Moose bhakaanda ukwibhuniisha ku bhamanyili abha Yeesu bhakati, “Kali, kooni mukulya nu kungʼwa pamupeene na bhasongesha songo na bhatulanongwa?” ");
INSERT INTO ndh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bhwo uYeesu aapulika ukwibhuniisha kwabho, akabhaamula akati, “Abhandu bhaabho bhataa bhabhine, bhatakumulonda umughanga, loole abhabhine bho bhaabho bhakumulonda umughanga. ");
INSERT INTO ndh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Une indakiisa pa chiisu ichi pakubhiitisha abhandu bhaabho bhakubhomba shiisho shibhaghiile pandaashi pa Chaala, loole ingiisa pakubhiitisha bhaabho bhatulanongwa ukuti bhiilaate imbiibhi shaabho.” ");
INSERT INTO ndh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Po abhandu bhala bhakamubhuula uYeesu bhakati, “Abhamanyili abha Yoohani na bha Bhafalisaayi bhali nu lwiho ulwa kwiyiima ukulya ifindu amashiku ghamu linga bhakwipuuta kwa Chaala. Loole abhamanyili bhaako abheene bhakwendelela ukulya nu kungʼwa amashiku ghooshi!” ");
INSERT INTO ndh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Loole uYeesu akabhaamula akati, “Mutabhaghiile ukubhakaanisha ukulya ifindu abhandu bhaabho bhabhapaaliile ku bhweghi linga bhali pamupeene na yuuyo akwegha. ");
INSERT INTO ndh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Loole mu mashiku ghaagho ghakwisa, abhandu indibhakamutiishe yuuyo akwegha pakati pa bhaheesha bhaake. Po abhaheesha abho indibhakiiyiime ukulya ifindu ku kabhalilo ako.” ");
INSERT INTO ndh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","UYeesu akabhabhuula soona abhandu bhala mu chifwanikisho akati, “Ataliipo umundu yuuyo akunyaapula ichilaka ukufuma ku mwenda umupya nu kuchisoneelela ku mwenda umukuulu. Linga aabhomba ulwo, akubha aanyaapula umwenda umupya nu kughukomania, ni chilaka chila choope chitakughelela nu mwenda umukuulu. ");
INSERT INTO ndh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Soona ataliipo umundu yuuyo akubhiika indifaayi imbya mu nyambi isha likwela ikuulu. Paapo linga aabhomba ulwo, indifaayi yila yikunyaapula inyambi, yikukupuka yooshi ni nyambi shoope shikukomanika. ");
INSERT INTO ndh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Loole abhandu bhakubhiika indifaayi imbya mu nyambi isha likwela ipya. ");
INSERT INTO ndh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Soona ataliipo umundu yuuyo linga aangʼwa indifaayi inguulu akulondagha ukungʼwa imbya, paapo akuti, ‘Indifaayi inguulu nyiisa ukukinda indifaayi imbya.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ishiku limo ilya Sabhati, uYeesu na bhamanyili bhaake bhakaghendagha mu sila yiiyo yikaghenda pakati pa mighunda. Bhwo bhakughenda, abhamanyili bhaake bhakaanda ukuposola ifisaasali, bhakafifikisanianga nu tukono twabho nu kwanda ukulya iseke shaake. ");
INSERT INTO ndh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bhwo aBhafalisaayi bhamu bhaabhabhona abhamanyili bhala, bhakabhabhuusha bhakati, “Kali, kooni mukubhomba shiisho indaghilo isha Moose shitakwitikisha ukubhomba pi ishiku ilya Sabhati?” ");
INSERT INTO ndh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Po uYeesu akabhabhuusha akati, “Kali, mutabhelengite mu Masimbo aMeelu muumwo uNdaabhiti na bhanine bhakabhombela bhwo isala yaabhabhabha? ");
INSERT INTO ndh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Akiingila mu Nyumba iya Chaala, akeegha imikati yiiyo yikabhiikighwa pandaashi pa Chaala. Naayumo umundu yuuyo indaghilo isha Moose shikamwitikishanga ukulya imikati yila, loole abhapuuti bheene. Loole uNdaabhiti akeegha imikati iyo, akalya, akabhapa na bhanine bhoope bhakalya.” ");
INSERT INTO ndh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Po uYeesu akabhabhuula akati, “UMwana ughwa Mundu ali na maka na pi ishiku ilya Sabhati.” ");
INSERT INTO ndh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pi ishiku inine ilya Sabhati, uYeesu akiingila mu sinaghoghi nu kwanda ukubhamanyisha abhandu. Mu sinaghoghi mula, akabhaamwo umundu yumo yuuyo akakono kaake aka kumwisa kakabha kalalite. ");
INSERT INTO ndh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Soona bhakabhaamwo na Bhafalisaayi na bhamanyishi abha ndaghilo isha Moose bhaabho bhakalondagha isila iya kumusitaaka uYeesu. Po bhakamutendeelagha uYeesu ukuti bhateshe linga indiamuposhe umundu yula pi ishiku ilya Sabhati. ");
INSERT INTO ndh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Loole uYeesu akashimanya inyinongʼono shaabho. Po akamubhuula umundu ughwa kakono akalale yula akati, “Ghwe mumanyani ghwangu, nyatuka, iima pakati pa bhandu.” Po umundu yula akanyatuka nu kwima pandaashi papaabho. ");
INSERT INTO ndh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Po uYeesu akabhabhuusha akati, “Ingubhabhuusha umwe, kali, liliku liilyo indaghilo isha Moose shikwitikisha ukubhomba pi ishiku ilya Sabhati? Kali, ukubhomba inyiisa pamu ukubhomba imbiibhi? Kali, ukubhupoka ubhwumi pamu ukubhughogha?” ");
INSERT INTO ndh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bhwo uYeesu aabhabhuusha ibhuusho ilyo, akabhatesha abhandu bhooshi, akamubhuula ughwa kakono akalale yula akati, “Ghwe mumanyani ghwangu, gholosha akakono kaako.” Ghwepe akagholosha, nakalinga akakono kaake kakapola lwoshi. ");
INSERT INTO ndh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Loole abheene bhakakalala leka, bhakaanda ukuyughisania bheene-bheene ukuti bhamubhombele kooni uYeesu. ");
INSERT INTO ndh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ishiku limo uYeesu akabhuuka ku kaghamba pakwipuuta. Akaghoneesha bhwo akwipuuta kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bhwo bhwacha pangeelo, uYeesu akabhiitisha abhamanyili bhaake. Mu bhamanyili abho, akabhasala kalongo na bhabhili (12), akabhapa ingamu ukubha bhatumighwa. ");
INSERT INTO ndh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Po ingamu isha bhatumighwa kalongo na bhabhili abho sho ishi, uSiimoni yuuyo uYeesu akamupa ingamu iya Peeteli nu munungʼuna uNdeleeya, uYaakobhu, uYoohani, uFilipu, uBhatolomaayi, ");
INSERT INTO ndh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","uMataayi, uToomasi, uYaakobhu umwana ughwa Alufeeyo, uSiimoni uMulwila Chiisu, ");
INSERT INTO ndh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","uYuuta umwana ughwa Yaakobhu nu Yuuta Isikaliyooti, yuuyo pabhumalilo akiisa aamubhiika uYeesu mu tukono utwa bhalughu. ");
INSERT INTO ndh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","UYeesu pamupeene na bhamanyili bhaake bhakiilomuka ukufuma ku kaghamba nu kwima pa ndebheela yimo. Pabhuyo bhula pakabha ni chilundilo ichikulu icha bhamanyili bhaake pamupeene ni chilundilo ichikulu icha bhandu. Abhandu abho bhakafuma mumbafu shooshi isha chiisu icha Yuteeya, mu kaaya aka Yelusaleemu na mumbafu isha twaya utwa Tiilo nu twa Sindoni tuutwo tuli kulubhafu ku nyanja iya Menditelaaniya. ");
INSERT INTO ndh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Abhandu abho bhakiisa pakumupulikisha uYeesu nu kuti abhaposhe amabhine ghaabho. Soona akabhaposhanga na bhandu bhaabho bhakataamighwanga ni mbepo imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ichilundilo chooshi icha bhandu bhaabho bhakabhaapo pala chikalondagha ukumupalamaasha uYeesu ku nongwa iya kuti amaka ukufuma mu mubhili ghwake ghakamuposhanga umundu ghweshi yuuyo akamupalamaashanga. ");
INSERT INTO ndh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Po uYeesu akabhatesha abhamanyili bhaake, akaanda ukubhamanyisha akati, “Muli bhasayighwa umwe mwe mukwibhona ukubha bhapiina, paapo ichitangalala icha Chaala chiinyu. ");
INSERT INTO ndh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Muli bhasayighwa umwe mwe mukwipulika isala ulu, paapo uChaala indiakabhiikutishe. Muli bhasayighwa umwe mwe mukulila ulu, paapo indimukasekaghe. ");
INSERT INTO ndh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Muli bhasayighwa linga abhandu bhakubhakalalila, bhakubhapaaghula, bhakubhatuka nu kubhayugha ukuti mwe bhatulanongwa, ku nongwa iya kuti mumwitikite uMwana ughwa Mundu.” ");
INSERT INTO ndh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","UYeesu akeendelela ukuyugha akati, “Linga isho shikubhombighwa kukwinyu, sekelagha nu kunyeela-nyeela paapo uChaala abhabhiikiile umufwalo umukulu kumwanya. Umwo mwo muumwo na bhosekulu bhaabho, bhakabhabhombelagha abhasololi abha Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Loole lwinyu umwe mwe muli bhakabhi ulu, paapo mupokeelite ngaanila ulusekelo lwinyu. ");
INSERT INTO ndh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Lwinyu umwe mwe mwikutite ulu, paapo indimukiipulikaghe isala. Lwinyu umwe mwe mukuseka ulu, paapo indimukalilaghe. ");
INSERT INTO ndh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Lwinyu umwe mwe abhandu bhooshi bhakubhapaala, paapo umwo mwo muumwo abhosekulu bhaabho, bhakabhapaalagha abhasololi abha bhumyashi.” ");
INSERT INTO ndh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","UYeesu akeendelela ukuyugha akati, “Loole ingubhabhuula umwe mwe mukuumbulikisha, bhaghanaghe abhalughu bhiinyu. Bhabhombelaghe inyiisa abhandu bhaabho bhakubhakalalila. ");
INSERT INTO ndh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Soona bhiipuutilaghe abhandu bhooshi bhaabho bhakubhaghuna umwe ukuti uChaala abhasaye. Bhiipuutilaghe kwa Chaala bhala bhaabho bhakubhabhombela akabhiibhi. ");
INSERT INTO ndh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Linga umundu aakukoma ku lusaya lumo, sanuka ukuti akukome na ku lusaya ulunine. Soona linga umundu aapoka ikoti lyako, muleke eeghe ni shaati. ");
INSERT INTO ndh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Linga umundu akukusuuma akandu, mupe. Soona linga umundu aapoka ku maka utundu twako, manye umumelelaghe ukuti akughalushikishe. ");
INSERT INTO ndh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bhabhombelaghe abhandu abhanine isa muumwo mukulonda abheene bhabhabhombelaghe umwe. ");
INSERT INTO ndh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Linga mukubhaghana bheene bhaabho bhabhaghanite umwe, uChaala atabhaghiile ukubhapaala ku shiisho mukubhomba, paapo na bhatulanongwa bhakubhaghana bhaabho bhabhaghanite. ");
INSERT INTO ndh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Soona linga mukubhabhombela inyiisa bheene bhaabho bhakubhabhombela inyiisa umwe, uChaala atabhaghiile ukubhapaala ku shiisho mukubhomba, paapo na bhatulanongwa bhoope bhakubhomba isa bhubhuubhwo. ");
INSERT INTO ndh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Linga mukubhakopela bheene bhaabho mumeenye ukuti indibhakabhahombe, uChaala atabhaghiile ukubhapaala ku shiisho mukubhomba ku nongwa iya kuti na bhatulanongwa bhakubhakopelagha abhatulanongwa abhanine, paapo bhameenye ukuti indibhakabhahombe utundu twabho twoshi. ");
INSERT INTO ndh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Loole ingubhabhuula umwe ukuti bhaghanaghe abhalughu bhiinyu nu kubhabhombela inyiisa. Bhakopelaghe chishita kusubhaalila ukuti indibhakabhaghalushikishe kaako mwabhakopiile. Linga mukubhomba isho, uChaala indiakabhahombe umufwalo umukulu. Soona indimukabhe bhaana bha Chaala Yuuyo Ali Pamwanya Ngaani ku nongwa iya kuti umwene mwisa ku bhaabho bhatakumupaalisha na ku bhatulanongwa. ");
INSERT INTO ndh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bhapelelaghe ichisa abhandu bhooshi isa muumwo uGhuuso yuuyo ali kumwanya akubhapelela ichisa abhandu bhooshi.” ");
INSERT INTO ndh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Po uYeesu akeendelela ukumanyisha akati, “Manye mumulongaghe umundu umunine ukuti uChaala manye akabhalonge nuumwe. Manye mumuyughaghe akabhiibhi umundu umunine ukuti uChaala manye akabhayughe akabhiibhi nuumwe. Bhahobhokelaghe abhanyiinyu imbiibhi shaabho ukuti uChaala akabhahobhokele nuumwe imbiibhi shiinyu. ");
INSERT INTO ndh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bhapange abhandu utundu tuutwo bhakulonda ku chipimilo ichiisa chiicho utundu twiswile, tukanyile soona tukukupuka. Paapo ichipimilo chiicho mukubhapimila abhanine, cho chiicho uChaala indiakabhapimile nuumwe.” ");
INSERT INTO ndh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","UYeesu akabhabhuula soona mu chifwanikisho akati, “Kali, umundu umufwamaaso abhaghiile ukumulongosha umufwamaaso umunine? Kali, linga akumulongosha, bhatabhaghiile ukughwila mu mbanga bhooshi bhabhili? ");
INSERT INTO ndh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Umumanyili ataa ghwi songo ukukinda umumanyishi ghwake. Loole umumanyili yuuyo aamanyila nu kumala shooshi shiisho umumanyishi ghwake aamumanyishanga, abhaghiile ukubha isa umumanyishi ghwake. ");
INSERT INTO ndh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kali, kooni kutesha akapaato kaako kali mu lyiso ilya munyiinyu, loole utakutesha ichibhali icha likokwe chiicho chili mu lyiso lyako? ");
INSERT INTO ndh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Soona, kali, ubhaghiile bhuleele ukumubhuula umunyiinyu ukuti, ‘Ghwe ghwamwitu, isagha ingutiishe akapaato aka likokwe kaako kali mu lyiso lyako,’ bhwo mu lyiso lyako yughweghwe muli ni chibhali icha likokwe? Ghwe ngubhisania ughwe! Tiisha taashi ichibhali icha likokwe chiicho chili mu lyiso lyako, po indiuteshe akiisa nu kutiisha akapaato kaako kali mu lyiso ilya munyiinyu.” ");
INSERT INTO ndh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Po uYeesu akeendelela ukuchimanyisha ichilundilo icha bhandu chila akati, “Litaliipo ikokwe ilyisa liilyo libhaghiile ukwela iseke imbiibhi, soona litaliipo ikokwe ibhiibhi liilyo libhaghiile ukwela iseke inyiisa. ");
INSERT INTO ndh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Lyoshi ikokwe likumanyikwa ku seke shaake shiisho likwela. Soona, abhandu bhatabhaghiile ukwinula iseke isha likokwe ilya mukuyu pamu isha musabhibhu ukufuma mu myifwa. ");
INSERT INTO ndh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bhubhuubhwo nu mundu umwisa akuyugha shiisho nyiisa ukufuma mu ndumbula yaake inyiisa, loole umundu umubhiibhi akuyugha shiisho mbiibhi ukufuma mu ndumbula yaake imbiibhi. Paapo umundu akushiyugha shiisho shiiswile mu ndumbula yaake.” ");
INSERT INTO ndh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Po uYeesu akachibhuusha ichilundilo chiicho chikamupulikishanga akati, “Kali, kooni mukuunyiitisha mukuti, ‘Ghwe Malafyale, ghwe Malafyale,’ loole mutakubhomba shiisho ingubhabhuula? ");
INSERT INTO ndh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Indiimbalingaanie muumwo abheeliile umundu ghweshi yuuyo akwisa kukwangu, akushipulika nu kushibhombela imbombo shiisho inguyugha. ");
INSERT INTO ndh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Umundu uyo ali isa umundu yuuyo akasengagha inyumba yaake. Bhwo akwanda ukusenga inyumba iyo, akakumba ulwalilo ukufika paase ngaani pa lyalabhwe. Po akasenga ulwalilo ulwa nyumba yaake ukufuma pa lyalabhwe. Bhwo ifula inyingi yaatima, ulusooko lukiisula ngaani, lukabhuuka nu kuyisungila inyumba yila, loole yitakaleghela na kaakanandi ku nongwa iya kuti ulwalilo lwake lukabha lwa maka. ");
INSERT INTO ndh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Loole umundu ghweshi yuuyo akupulika shiisho inguyugha chishita kushibhombela imbombo, ali isa umundu yuuyo akasenga inyumba yaake pa musanga chishita kubhiika ulwalilo ulwa maka. Bhwo ulusooko lwisula, lukabhuuka ku maka nu kuyisungila inyumba yila, nakalinga inyumba yila yikaghwa nu kukomanika lwoshi.” ");
INSERT INTO ndh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bhwo uYeesu aamala ukubhamanyisha abhandu shooshi isho, akabhuuka nu kwingila mu kaaya aka Kapenabhumu. ");
INSERT INTO ndh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mu kaaya aka Kapenabhumu ako, akabhaamwo usongo yumo ughwa bhashikali yuuyo akabha nu mutumwa ghwake yuuyo akamughana leka. Umutumwa yula akabha mubhine leka nu kuti akabha papiipi nu kufwa. ");
INSERT INTO ndh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bhwo usongo ughwa bhashikali yula aapulika inongwa isha Yeesu, akabhatuma abhosongo bhamu abha Bhayuuta ukuti bhaye bhamusuume uYeesu ukuti iise nu kumuposha umutumwa ghwake. ");
INSERT INTO ndh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Po abhosongo bhala bhakabhuuka kuukwo uYeesu akabha. Bhwo bhaafika, bhakamwagha uYeesu, bhakamusuuma ngaani ukuti abhuuke amuposhe umutumwa yula bhakati, “Ghwe Malafyale, tukukusuuma, tubhuuke umupelele ichisa nu kumwafwa usongo yula ku shiisho akukusuuma. ");
INSERT INTO ndh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Umundu uyo mwisa leka ku nongwa iya kuti abhaghanite leka abhandu bhiitu aBhaisilaeli, soona ghwe yuuyo aatusengiile isinaghoghi yiitu.” ");
INSERT INTO ndh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Po uYeesu akiitika nu kwanda ukubhuuka ku nyumba iya songo yula pamupeene na bhosongo abha Bhayuuta bhala. Loole bhwo bhali papiipi ukufika ku nyumba yila, usongo ughwa bhashikali yula akabhatuma abhamanyani bhaake kwa Yeesu ukuti bhamubhuule ukuti, “Ghwe Malafyale, manye ghwilabhaashange ukwisa ku nyumba yangu ku nongwa iya kuti une indaa mubhaghile ukuti ughwe ghwingile mu nyumba yangu. ");
INSERT INTO ndh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yo yiiyo nongwa iyi niibhweni ukuti indaa mubhaghile nu kwisa pakukomaana nuughwe. Loole ingukusuuma uyughe ishu lyene ukufuma kubhutali nu mutumwa ghwangu indiapole. ");
INSERT INTO ndh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Paapo nuune indi paase pa bhosongo. Soona indi na bhashikali bhaabho bhali paase papangu. Linga naamubhuula yumo ukuti, ‘Bhuuka!’ Nakalinga, ghwepe akubhuuka. Soona ingumubhuula umunine ukuti, ‘Isagha!’ Nakalinga, ghwepe akwisa. Nu mutumwa ghwangu muumwo ingumubhuulila, mwo muumwo akubhombela.” ");
INSERT INTO ndh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bhwo uYeesu aaghapulika amashu agho, akaswigha leka. Po akachisanukila ichilundilo icha bhandu chiicho chikamukongagha, akachibhuula akati, “Ingubhabhuula ukuti, mu chiisu chooshi icha Isilaeli, indamubhweni naalumo umundu yuuyo ali nu lwitiko ulukulu isa ulu!” ");
INSERT INTO ndh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bhwo abhamanyani abha songo ughwa bhashikali bhaaghaluka mu nyumba iya songo yula, bhakamwagha umutumwa yula yuuyo kubhwandilo akabha mubhine leka, apolite, mwisaashe. ");
INSERT INTO ndh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pi ishiku liilyo likakongagha, uYeesu na bhamanyili bhaake bhakabhuuka mu kaaya aka Nayini ni chilundilo ichikulu icha bhandu chikamukongagha. ");
INSERT INTO ndh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bhwo bhaapalamila ukufika pa mulyango umukulu ughwa kaaya kala, tesha, bhakakomaana na bhandu bhamu bhaabho bhakapimba umufimba ughwa mwana umulumyana mu ibhokoshi, bhakubhuuka pakushiila. Umwana umufwe yula akabha mwene kwa ngʼina yuuyo akabha mufwile. Abhandu abhingi ukufuma mu kaaya kala bhakabha pamupeene nu mukolo yula. ");
INSERT INTO ndh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bhwo uMalafyale aamubhona umukolo umufwile yula, akamupelela ichisa, akamubhuula akati, “Ghwe maayi, manye ulilaghe.” ");
INSERT INTO ndh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","UYeesu akabhiyila pi ibhokoshi, akalipalamaasha, po abhandu bhaabho bhakapimba ibhokoshi lila bhakiima. UYeesu akamubhuula umufwe yula akati, “Ghwe mulumyana ughwe! Ingukubhuula, lamusha!” ");
INSERT INTO ndh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nakalinga, umulumyana yula yuuyo aafwile akashuuka, akiikala, akaanda ukuyugha. Po uYeesu akamupa ungʼina umwana yula. ");
INSERT INTO ndh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bhwo abhandu bhala bhaashibhona isho, bhakooghopa leka, bhakaanda ukumupaala uChaala bhakati, “UChaala amutumite umusololi usongo kukwitu! UChaala iisile pakutwafwa utwe!” ");
INSERT INTO ndh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Po inongwa isha Yeesu isho shikafumukwa leka mu chiisu chooshi icha Yuteeya na mu fyisu fyoshi ifya papiipi. ");
INSERT INTO ndh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bhwo uYoohani uMwoshi akaali ali mu nyumba iya bhapinyighwa, abhamanyili bhaake bhakabhuuka nu kumubhuula shooshi shiisho uYeesu akashibhombagha. Po uYoohani akabhiitisha abhamanyili bhabhili mu bhamanyili bhaake. ");
INSERT INTO ndh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bhwo bhiisa kukwake, akabhatuma kwa Yeesu ukuti bhamubhuushe ukuti, “Kali, ughwe ghwe Kilisiti yula yuuyo bhakasolola ukuti indiakiise pamu tumulindililaghe umunine?” ");
INSERT INTO ndh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bhwo abhamanyili bhabhili bhala bhaafika kwa Yeesu, bhakamubhuusha bhakati, “UYoohani uMwoshi aatutuma kukwako tukubhuushe ukuti, ‘Kali, ughwe ghwe Kilisiti yula yuuyo bhakasolola ukuti indiakiise pamu tumulindililaghe umunine?’ ” ");
INSERT INTO ndh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mu kabhalilo kala kala abhamanyili bhabhili bhala bhakatesha muumwo uYeesu akabhaposhanga abhandu abhingi bhaabho bhakabha bhabhine, akabhaposhanga na bhaabho bhakabha ni mbepo imbiibhi, soona akabhaposhanga abhandu abhingi bhaabho bhakabha bhafwamaaso. ");
INSERT INTO ndh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Po uYeesu akabhaamula abhamanyili bhala akati, “Bhuuka mumubhuule uYoohani shooshi shiisho mwashibhona na shiisho mwashipulika. Paapo bhaabho bhaali bhafwamaaso bhakutesha, bhaabho bhaali bhochikwefu bhakughenda, bhaabho bhaali ni mbungo iya makete bhapolite, bhaabho bhaali ni fipuli bhakupulika na bhafwe bhakushuuka. Soona, abhapiina bhakupokeela iNongwa iNyiisa. ");
INSERT INTO ndh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Soona mumubhuule ukuti, ‘UChaala akumusaya umundu ghweshi yuuyo atakwilaamwa kukwangu.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bhwo abhamanyili abha Yoohani bhaatiila, uYeesu akaanda ukufilingaania ifilundilo ifya bhandu fila isha Yoohani uMwoshi akati, “Kali, mukabhuukagha pakutesha kooni ku lungalangala? Kali, mukabhuukagha pakumutesha umundu yuuyo akwitika shooshi isa ulutete luulwo ichikungu chikaluyungaanianga kwoshi kwoshi? Nashiku. ");
INSERT INTO ndh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Po kali, mukabhuukagha pakutesha kooni? Kali, mukabhuukagha pakumutesha umundu yuuyo afwalite imyenda iya mutengo umukulu? Pulikisha, abhandu bhaabho bhakufwala imyenda iya mutengo umukulu na bhaabho bhakwikala pabhwisa, bhakwikala mu nyumba ingulu isha bhomalafyale! ");
INSERT INTO ndh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Po kali, mukabhuukagha pakutesha kooni? Kali, mukabhuukagha pakumutesha umusololi? Mwo muumwo, loole ingubhabhuula ukuti uYoohani akindite pa musololi. ");
INSERT INTO ndh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Uyu ghwe yuuyo inongwa shaake shisimbiighwe mu Masimbo aMeelu ukuti, ‘Tesha, ingumutuma ughwandumi ghwangu mundaashi yaako yuuyo indiakatendekeshe isila yaako.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","UYeesu akayugha soona akati, “Nalooli ingubhabhuula, mu bhandu bhooshi bhaabho bhapaapiighwe na bhakolo, atabhonekite naayumo ukubha ghwa pamwanya ukumukinda uYoohani uMwoshi. Loole umundu yuuyo mufuyuke ku chitangalala icha Chaala, ghwe yuuyo ghwa pamwanya ukumukinda umwene.” ");
INSERT INTO ndh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Po bhwo abhandu bhooshi pamupeene na bhasongesha songo bhaamupulika uYeesu akuyugha inongwa isha Yoohani, bhakiitika ukuti shiisho uChaala akalaghila sha nalooli ku nongwa iya kuti uYoohani ghwe yuuyo akabhoosha. ");
INSERT INTO ndh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Loole aBhafalisaayi na bhamanyishi abha ndaghilo isha Moose bhakakaana shiisho uChaala akalondagha ukuti bhabhombaghe ku nongwa iya kuti bhakakaana ukwoshighwa nu Yoohani. ");
INSERT INTO ndh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","UYeesu akeendelela ukuyugha akati, “Kali, imbagheleshe na kooni abhandu abha mbaapo iyi? Kali, bhagheliile na kooni? ");
INSERT INTO ndh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Abhandu abha mbaapo iyi bhagheliile na bhaana bhaabho bhakwikala pa munaalo nu kwitisania bheene-bheene bhakuti, ‘Twabhakomiile ilongi, loole mutaalebhiile. Twabhiimbiile inyimbo isha bhuswimaane, loole mutaalilite!’ ");
INSERT INTO ndh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Inguyugha ulu ku nongwa iya kuti bhwo uYoohani uMwoshi iisa kukwinyu, atakulya umukati pamu atakungʼwa indifaayi, mukakaana ukumupulikisha paapo mukayughagha mukatingi, ‘Umundu uyu akoliighwe ni mbepo imbiibhi.’ ");
INSERT INTO ndh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Bhubhuubhwo, bhwo uMwana ughwa Mundu iisa kukwinyu akulya umukati nu kungʼwa indifaayi, mukukaana ukumupulikisha paapo mukuyugha ukuti, ‘Tesha! Umundu uyu mupafu soona ghwi chingʼwelo, mumanyani ghwa bhasongesha songo na bhatulanongwa!’ ");
INSERT INTO ndh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Loole pamupeene ni isho shiisho mukuyugha, amahala agha Chaala ghakubhoneka ukubha gha nalooli ku mbombo isha bhandu bhaake bhooshi bhaabho bhakubhomba shiisho shibhaghiile pandaashi papaake.” ");
INSERT INTO ndh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Akabhaakwo uMufalisaayi yumo yuuyo ingamu yaake akabha ghwi Siimoni. Ishiku limo uMufalisaayi uyo akamupaalila uYeesu ukuti abhuuke kukaaya kaake alye ifindu. Po uYeesu akabhuuka kukaaya aka Mufalisaayi yula. Bhwo aafika, akiingila mu nyumba nu kwanda ukulya ifindu. ");
INSERT INTO ndh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mu kaaya kala, akabhaamwo umukolo yumo yuuyo akabha mutulanongwa. Bhwo umukolo yula aapulika ukuti uYeesu ali pakulya mu nyumba iya Mufalisaayi yula, akeegha inyemba isha kunuukila isha mutengo umukulu ngaani nu kubhuuka kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bhwo umukolo yula aafika, akiima papiipi nu tulundi utwa Yeesu. Akaanda ukulila na maashooshi ghaake ghakaanda ukutoonyela pa tulundi utwa Yeesu. Po akaanda ukughapuupula amaashooshi ghala ni chingʼwili chaake nu kutupaka utulundi inyemba isha kunuukila ukulangisha ulughindiko. ");
INSERT INTO ndh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Po bhwo uMufalisaayi yula yuuyo akamupaalila uYeesu aashibhona shiisho shikabhombighwa, akiiyughaania mwene mu ndumbula yaake akati, “Linga umundu uyu akabhanga musololi nalooli, ngali aamumanya umukolo yuuyo akumupalamaasha ukuti ghwini nu kuti ali bhuleele. Soona ngali aamanya ukuti umukolo uyu mutulanongwa.” ");
INSERT INTO ndh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Bhwo uYeesu aamanya shiisho uSiimoni akiinongʼonagha mu ndumbula yaake, akamubhuula akati, “Ghwe Siimoni, indi ni sha kuyugha nuughwe.” Ghwepe akaamula akati, “Ghwe Mumanyishi, ingukusuuma ghuumbuule.” ");
INSERT INTO ndh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Po uYeesu akamubhuula ichifwanikisho chimo akati, “Bhakabhaakwo abhandu bhamu bhabhili bhaabho bhakakopa indalama ku mundu yumo. Yumo akakopa indinaali imya ihaano (500) nu munine akakopa indinaali amalongo mahaano (50). ");
INSERT INTO ndh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bhwo abhandu bhabhili bhala bhaapootwa ukumughalushikisha indalama shaake yuuyo akabhakopela, umwene ndalama yula akabhahobhokela indalama shila bhooshi bhabhili chishita kubhamelela soona. Kali, mu bhandu bhabhili abho bhaabho bhakakopa indalama, ghwini yuuyo indiamughane nu kumupaalisha ngaani umundu yula yuuyo akabhakopela indalama?” ");
INSERT INTO ndh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","USiimoni akamwamula akati, “Une ingwinongʼona ukuti mundu yula yuuyo umwene ndalama akamuhobhokela indalama inyingi ghwe yuuyo indiamughane nu kumupaalisha ngaani.” Po uYeesu akamubhuula akati, “Ghwe Siimoni, ghwayugha ubhwanalooli.” ");
INSERT INTO ndh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Po uYeesu akasanuka nu kumutesha umukolo yula, akamubhuula uSiimoni akati, “Ghwe Siimoni, kali, ghwamubhona umukolo uyu shiisho aabhomba? Bhwo niingila mu nyumba yaako, ughwe utaambiile na miishi agha kusuka utulundi twangu, loole umukolo uyu aasuka utulundi twangu na maashooshi ghaake nu kuumbuupula ni chingʼwili chaake. ");
INSERT INTO ndh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bhwo kuundamuka, utaafipite, loole umukolo uyu atakulita ukuufipa utulundi twangu ukwandila akabhalilo kaako niingiile mu nyumba iyi. ");
INSERT INTO ndh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Soona utaambakite inyemba pa mutu ukulangisha ulughindiko, loole umukolo uyu aambaka utulundi twangu ni nyemba isha kunuukila isho. ");
INSERT INTO ndh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ku nongwa iyo, ingukubhuula ukuti naamuhobhokela umukolo uyu imbiibhi shaake shiisho shaali nyingi, paapo aalangisha ulughano ulukulu kukwangu nu kuungindika. Loole umundu yuuyo ingumuhobhokela panandi imbiibhi shaake, umundu uyo akulangisha ulughano lwake panandi.” ");
INSERT INTO ndh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Po uYeesu akamubhuula umukolo yula akati, “Ghwe mulindu, naakuhobhokela imbiibhi shaako shooshi.” ");
INSERT INTO ndh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Po bhwo abhandu abhanine bhaabho bhakalyanga pamupeene nu Yeesu bhaapulika amashu agha Yeesu, bhakaanda ukubhuusania bheene-bheene bhakati, “Kali, ghwini umundu uyu yuuyo ghwepe akuhobhokela abhandu imbiibhi shaabho?” ");
INSERT INTO ndh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Po uYeesu akamubhuula soona umukolo yula akati, “Ghwe mulindu, ghwapokighwa ku nongwa iya kuunyiitika une. Ulu bhuukagha kukaaya kaako nu lutengaano ukufuma kwa Chaala!” ");
INSERT INTO ndh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bhwo isho shaakinda, uYeesu akashunguulilagha mu twaya utukulu nu twaya utunandi, akalumbililagha iNongwa iNyiisa isha chitangalala icha Chaala. Abhamanyili bhaake kalongo na bhabhili (12) bhakabhuuka pamupeene naghwe. ");
INSERT INTO ndh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Soona, abhakolo bhamu bhoope bhakashunguulilagha pamupeene nu Yeesu. Abhakolo abho bho bhaabho uYeesu akabhaposha amabhine ghaabho na bhaabho akashikiisha imbepo imbiibhi ukufuma mukati mumwabho. Mu bhakolo abho, akabhaamwo uMaliiya ughwa mu kaaya aka Maghatala yuuyo uYeesu akashikiisha imbepo imbiibhi ihaano na shibhili (7) ukufuma mukati mumwake. ");
INSERT INTO ndh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ghwepe uYoohana yuuyo akabha mukashi ghwa Kuusa, akabhaamwo mu bhakolo abho. UKuusa akabha mwimilili ughwa tundu utwa malafyale uHelooti. Soona akabhaamwo nu mukolo yumo yuuyo ingamu yaake akabha ghwi Susaana na bhakolo abhanine abhingi. Abhakolo bhooshi abho bhakiifumyanga utundu twabho ku nongwa iya kubhaafwa uYeesu na bhamanyili bhaake. ");
INSERT INTO ndh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ishiku limo ichilundilo ichikulu icha bhandu chikabhungaana na bhandu abhingi ukufuma mu twaya utwingi bhakabhuuka kwa Yeesu. Po uYeesu akayugha nabho ku sila iya kubhombela ichifwanikisho, akabhabhuula akati, ");
INSERT INTO ndh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Umulimi yumo akabhuuka pakupesa imbeyu shaake. Bhwo ali pakupesa, imbeyu shimo shikaghwa mu sila. Abhandu bhakashikanyagha imbeyu isho nu tuyuni tukiisa nu kushilya. ");
INSERT INTO ndh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Imbeyu inine shikaghwa pi ilongwi liilyo likabha ni lyalabhwe paase. Bhwo shaanda ukumela, shikaanda ukuuma ku nongwa iya kuti imishu yaake yikabha pamwanyaashe. ");
INSERT INTO ndh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Imbeyu inine shikaghwa pakati pa myifwa. Bhwo imbeyu shaanda ukukula, imyifwa yila yikakula pamupeene ni mbeyu shila, po imyifwa yikashipuuta imbeyu shila. ");
INSERT INTO ndh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Loole imbeyu inine shikaghwa pi ilongwi ilyisa. Bhwo shaamela nu kukula, shikeela iseke imya yimo (100).” Bhwo uYeesu aamala ukuyugha isho, akayugha ku ishu ilya pamwanya akati, “Umundu ghweshi yuuyo ali ni fyufwo, apulikishange nu kushaaghania!” ");
INSERT INTO ndh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Po abhamanyili bhaake bhakaanda ukumubhuusha uYeesu bhakati, “Kali, ichifwanikisho icha mulimi yuuyo akapesagha imbeyu chikulingaania kooni?” ");
INSERT INTO ndh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ghwepe akabhaamula akati, “UChaala abhasetuliile umwe ukushimanya isha ku bhushiifu isha chitangalala chaake, loole ingubhabhuula abhangi isha ku bhushiifu isho ku sila iya fifwanikisho ukuti shibhombighwe shiisho shisimbiighwe mu Masimbo aMeelu ukuti, ‘Pamupeene nu kuti bhakutesha, manye bhashibhonaghe nu kushimanya. Pamupeene nu kuti bhakupulika, manye bhashaaghaniange.’ ");
INSERT INTO ndh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Po ilingaanio ilya chifwanikisho icho kwo kuti, imbeyu shili ungati lishu liilyo likufuma kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imbeyu shiisho shikaghwa mu sila shili ungati bhandu bhaabho bhakupulika ishu ilya Chaala. Loole uSeetano akwisa nu kulitiisha ishu ilyo mu ndumbula shaabho ukuti manye bhiise bhiitike nu kupokighwa. ");
INSERT INTO ndh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Imbeyu shiisho shikaghwa pi ilongwi liilyo likabha ni lyalabhwe paase, shili ungati bhandu bhaabho bhakupulika ishu ilya Chaala nu kulipokeela ku lusekelo, loole abhandu abho bhatakulibhiika ishu ilyo mu ndumbula shaabho. Paapo bhakwitika ku kabhalilo akapimbaashe, loole linga ingelo shaabhaagha, bhakuleka ukulyitika ishu ilyo. ");
INSERT INTO ndh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Imbeyu shiisho shikaghwa pakati pa myifwa shili ungati bhandu bhaabho bhakupulika ishu ilya Chaala. Loole ku nongwa iya kutaamighwa ni nyinongʼono isha bhukabhi ni finyonywa ifinine ifya chiisu fiifyo bhakuhobhoka nafyo mu bhwumi bhwabho, shooshi isho shikubhashighila ukubhomba shiisho shibhaghiile pandaashi pa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Loole imbeyu shiisho shikaghwa pi ilongwi ilyisa, shili ungati bhandu bhaabho bhakupulika ishu ilya Chaala nu kulipokeela akiisa mu ndumbula shaabho, nu kwendelela ukulyitika nu kubhomba shiisho bhwighane bhwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Po uYeesu akeendelela ukuyugha akati, “Ataliipo umundu yuuyo akukosha inyaale nu kuyiifunikila ni chipombo pamu ukuyibhiika paase pa chitala. Loole akuyibhiika pa chitalati ukuti linga abhandu bhakwingila, bhabhubhonaghe ubhwelu. ");
INSERT INTO ndh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bhubhuubhwo, akandu kaako katali pabhwelu, indikakasetulighwe, soona kooshi kaako kafifiighwe, indikakabhiikighwe pabhwelu. ");
INSERT INTO ndh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Po pulikishanga akiisa shiisho ingumanyisha, paapo umundu yuuyo akufipulika ifimanyisho fyangu nu kufyaghania, uChaala akumwafwa ukushaaghania ngaani. Loole yuuyo atakufipulika nu kufyaghania, uChaala akumupoka na kanandi kaako akukaaghania.” ");
INSERT INTO ndh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Akabhalilo kamu bhwo uYeesu ali pakuchimanyisha ichilundilo icha bhandu, ungʼina pamupeene na bhoghwamwabho bhakabhuuka kukwake ukuti bhakomaane naghwe, loole bhakapootwa ukupalamila kukwake ku nongwa iya kuti ichilundilo ichikulu icha bhandu chikamushunguulila. ");
INSERT INTO ndh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Umundu yumo ukufuma mu chilundilo chila akabhuuka kwa Yeesu, akamubhuula akati, “Ghwe Yeesu, unyoko na bhoghwamwinyu bhiimite kuuse, bhakulonda ukukomaana nuughwe.” ");
INSERT INTO ndh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","UYeesu akachibhuula ichilundilo icha bhandu akati, “Umundu ghweshi yuuyo akulipulika ishu ilya Chaala nu kulibhombela imbombo, uyo ghwe yuuyo ghwi ghwamwitu, soona ghwi maayi ughwa nalooli.” ");
INSERT INTO ndh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ishiku limo bhwo uYeesu iingila mu bhwato pamupeene na bhamanyili bhaake, akabhabhuula akati, “Isagha tulobhoke ku isiila ilingi ilya sumbi.” Po bhakaanda ukulobhoka usumbi yula. ");
INSERT INTO ndh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bhwo bhakwendelela ukulobhoka, uYeesu akapitila. Bhwo aapitila, ichikungu ichikali chikaanda ukukuka na miishi ghakaanda ukwisula mu bhwato, bhakabha papiipi ukutwibha. ");
INSERT INTO ndh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Po abhamanyili bhakabhuuka kwa Yeesu, bhakamulamusha, bhakiitisha ku ishu ilya pamwanya bhakati, “Ghwe Songo ghwitu! Ghwe Songo ghwitu! Tukufwa!” Po uYeesu akalamusha, akiima, akachikemela ichikungu ni nguli ukuti fisumbe. Po ichikungu ni nguli fikasumba, kukabha myee! ");
INSERT INTO ndh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Po uYeesu akabhabhuusha abhamanyili bhaake akati, “Kali, ulwitiko lwinyu luli kuughu?” Abhamanyili bhaake bhakooghopa leka nu kuswigha, bhakabhuusania bheene-bheene bhakati, “Kali, ghwini uyu yuuyo akuchikemela ni chikungu ichikali ni nguli fyope fikumupulika?” ");
INSERT INTO ndh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","UYeesu na bhamanyili bhaake bhakalobhoka usumbi nu kufika mu chiisu icha Bhaghelaasi chiicho chili kupiipi ni chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bhwo uYeesu iika mu bhwato nu kufika ku chiisu ichikafu, umundu yumo ukufuma mu chiisu icho yuuyo akabha ni mbepo imbiibhi, akabhuuka kwa Yeesu. Umundu uyo akaghendagha chitali amashiku amingi, soona atakiikalagha mu nyumba, loole akiikalagha ku mapumba. ");
INSERT INTO ndh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bhwo umundu ughwa mbepo imbiibhi yula aamubhona uYeesu, akaywegha ku ishu ilya pamwanya, akiiponia pandaashi pa Yeesu ukulangisha ulughindiko, imbepo imbiibhi yila yikakuuta ku ishu ilya pamwanya yikati, “Ghwe Yeesu, Mwana ghwa Chaala Yuuyo Ali Pamwanya Ngaani, kali, indi ni nongwa yiki nuughwe? Ingusuuma manye ghuufulashange.” ");
INSERT INTO ndh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Imbepo imbiibhi yila yikayugha ulwo ku nongwa iya kuti uYeesu akabha aayikemela ukuti yifume mu mundu yula. Imbepo imbiibhi iyo yikamulongoshanga umundu uyo utubhalilo utwingi. Abhandu bhakamupinyagha umundu uyo ni minyololo ni mbingu mu tukono na mu tulundi ukuti manye apootaghe, loole poope akakonolanianga iminyololo ni mbingu, ni mbepo imbiibhi yikabhuukagha naghwe ku lungalangala. ");
INSERT INTO ndh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Po uYeesu akayibhuusha akati, “Kali, ingamu yaako ghwe ghwini?” Imbepo yila yikamwamula yikati, “Ingamu yangu nee Leghiyooni, kwo kuti, tuli bhingi.” ");
INSERT INTO ndh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Imbepo imbiibhi yila yikamusuuma ngaani uYeesu ukuti manye ashitume ku bhwina ubhwa bhoseetano. ");
INSERT INTO ndh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Papiipi nu bhuyo bhula, pakabhaapo nu mutiimo umukulu ughwa ngulubhe shiisho shikalyanga kulubhafu ku kaghamba. Po imbepo imbiibhi shila shikamusuuma uYeesu ukuti ashiitikishe shiingile mu ngulubhe shila. Ghwepe uYeesu akashiitikisha. ");
INSERT INTO ndh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Imbepo imbiibhi shila shikafuma mu mundu yula nu kwingila mu ngulubhe shila. Po ingulubhe shooshi shikiilomuka mwa sumbi nu kutwibha mula. ");
INSERT INTO ndh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bhwo abhaliishi abha ngulubhe bhaashibhona shiisho shaabhombighwa, bhakooghopa leka nu kukinda lubhilo ukubhuuka pakubhabhuula inongwa isho abhandu abha mu kaaya akakulu na mu twaya utunandi tuutwo tuli kupiipi na kaaya ako. ");
INSERT INTO ndh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Po bhwo abhandu bhaapulika inongwa isho, bhakabhuuka pakutesha shiisho shikabhoneka. Bhwo bhaafika paapo uYeesu akabha, bhakamubhona umundu yuuyo uYeesu amutiishiishe imbepo imbiibhi iikiile pa tulundi utwa Yeesu, afwalite akiisa, ali na mahala ghooshi, po bhakooghopa leka. ");
INSERT INTO ndh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abhandu bhaabho bhakashibhona shiisho shikabhombighwa, bhakabhabhuula abhandu abhanine muumwo uYeesu akamuposha umundu yuuyo akakolighwa ni mbepo imbiibhi inyingi. ");
INSERT INTO ndh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Po abhandu abhingi ukufuma mu chiisu icha Bhaghelaasi bhakamusuuma uYeesu ukuti atiile mu chiisu chaabho ku nongwa iya kuti bhakabha nu bhwogha ubhukulu. Po uYeesu akiingila mu bhwato, akatiila nu kubhuuka kulubhafu ulunine. ");
INSERT INTO ndh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bhwo uYeesu akutiilaapo pala, umundu yula yuuyo uYeesu akamufumya imbepo imbiibhi, akamusuuma ukuti abhuukaghe pamupeene naghwe. Loole uYeesu atakamwitikisha, akamubhuula akati, ");
INSERT INTO ndh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ghaluka kukaaya kaako uye ufumushe ku bhandu shooshi shiisho uChaala aakubhombela.” Po umundu yula akatiila pala, akabhuuka mu kaaya kooshi nu kufumusha ku bhandu shooshi shiisho uYeesu akamubhombela. ");
INSERT INTO ndh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bhwo uYeesu aaghaluka ku isiila inine ilya sumbi, ichilundilo icha bhandu chiicho chikamulindililagha, chikamupokeela ku lusekelo. ");
INSERT INTO ndh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mu kabhalilo kala kala umundu yumo yuuyo ingamu yaake akabha ghwi Yayilo, umulongoshi ughwa sinaghoghi, akabhuuka nu kwiponia pa tulundi utwa Yeesu ukulangisha ulughindiko, akamusuuma ukuti abhuuke kukaaya kaake. ");
INSERT INTO ndh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","UYayilo akabhomba ulwo ku nongwa iya kuti umwana ghwake umulindu yuuyo akabha mweneeshe, ughwa fyinja kalongo na fibhili (12), akabha mubhine leka, akabha papiipi nu kufwa. Po uYeesu akaanda ukubhuuka kukaaya aka Yayilo. Bhwo ali mu sila, ichilundilo icha bhandu chiicho chikamushunguulila, chikamufinyagha imbafu shooshi. ");
INSERT INTO ndh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mu chilundilo icho, akabhaamwo umukolo yumo yuuyo akabha nu bhubhine ubhwa kufuma ibhanda ku fyinja kalongo na fibhili. Umukolo uyo akamala ichuuma chaake chooshi ukubhahomba abhaghanga, poope naayumo yuuyo akamuposha ubhubhine bhwake. ");
INSERT INTO ndh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Po umukolo yula akabhuuka kunyuma kwa Yeesu, akeeghelesha ichipeto icha mwenda ghwake, nakalinga akapola ubhubhine bhwake. ");
INSERT INTO ndh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Po uYeesu akachibhuusha ichilundilo icha bhandu chila akati, “Kali, ghwini yuuyo aanyeeghelesha?” Abhandu bhooshi bhakakaana. Po uPeeteli akamubhuula uYeesu akati, “Ghwe Malafyale, abhandu bhingi bhaabho bhakukweghelesha ku nongwa iya kuti bhakushunguuliile soona bhakukufinya imbafu shooshi!” ");
INSERT INTO ndh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Loole uYeesu akaamula akati, “Umundu yumo aanyeeghelesha paapo niipulika ukuti amaka ghamu ghaatiila mu mubhili ghwangu.” ");
INSERT INTO ndh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bhwo umukolo yula aamanya ukuti atabhaghiile ukwimama soona, akabhuuka kwa Yeesu bhwo akutetema ku nongwa iya kwoghopa. Po akabhuuka nu kufughamila pandaashi pa Yeesu, akalingaania pandaashi pa bhandu bhooshi inongwa yiiyo yikamupelela ukumupalamaasha na muumwo akapolela nakalinga. ");
INSERT INTO ndh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","UYeesu akamubhuula akati, “Ghwe mulindu, ghwapola ku nongwa iya kuti kuunyiitika une. Bhuukagha kukaaya kaako ku lutengaano.” ");
INSERT INTO ndh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bhwo uYeesu akaali ali pakuyugha, umundu yumo akiisa ukufuma kukaaya aka Yayilo, umulongoshi ughwa sinaghoghi, akamubhuula uYayilo akati, “Ghwe songo, umwana ghwako umulindu aatuleka! Manye ghwendelelaghe ukumutamya uMumanyishi.” ");
INSERT INTO ndh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Loole bhwo uYeesu aamupulika umundu yula, akamubhuula uYayilo akati, “Ghwe Yayilo, manye ghwoghopaghe, endelelagha ukuunyiitika. Umwana ghwako umulindu indiapole.” ");
INSERT INTO ndh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bhwo uYeesu aafika pakaaya aka Yayilo, akabhakaanisha abhandu abhanine ukwingila pamupeene naghwe mu nyumba, loole akamwitikisha uPeeteli, uYoohani, uYaakobhu na bhapaapi abha mulindu yula. ");
INSERT INTO ndh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Abhandu bhooshi bhaabho bhakabhaamwo mu nyumba mula bhakalilagha nu kwikungʼunda ukulangisha ubhuswimaane ku nongwa iya bhufwe ubhwa mulindu yula. Loole uYeesu akabhabhuula abhandu abho akati, “Manye mulilaghe paapo umulindu uyu atafwile loole apitiileeshe!” ");
INSERT INTO ndh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Loole abhandu bhala bhakamusekela ku lufuuyo uYeesu paapo abheene bhakamanya ukuti umulindu yula afwile. ");
INSERT INTO ndh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Po uYeesu akabhuuka paapo umulindu yula akabha, akamukola akakono kaake, akamwitisha ku ishu ilya pamwanya akati, “Ghwe mulindu, lamusha!” ");
INSERT INTO ndh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nakalinga, umulindu yula akashuuka, akiima. Po uYeesu akalaghila ukuti bhamupe umulindu yula ifindu ukuti alye. ");
INSERT INTO ndh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bhwo shaabhoneka shooshi isho, abhapaapi bhaake bhakaswigha leka, loole uYeesu akabhakaanisha ukuti manye bhamubhuulaghe umundu naayumo shiisho shaabhombighwa. ");
INSERT INTO ndh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","UYeesu akabhiitisha abhamanyili bhaake kalongo na bhabhili. Bhwo bhiisa, akabhapa amaka agha kushikiisha imbepo imbiibhi shooshi nu kubhaposha abhandu bhaabho bhakabha bhabhine. ");
INSERT INTO ndh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Po akabhatuma abhamanyili abho ukuti bhabhuuke ku bhandu pakulumbilila inongwa isha chitangalala icha Chaala nu kubhaposha bhaabho bhakabha bhabhine. ");
INSERT INTO ndh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bhwo bhakaali ukubhuuka, uYeesu akabhalaghila akati, “Bhwo mukubhuuka, manye mweghaghe naakamu. Manye mweghaghe ingoomo iya kughendela, inyambi, ifindu pamu indalama. Soona manye mweghaghe umwenda ughwa bhubhili ughwa kuchenjesania. ");
INSERT INTO ndh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mu kaaya kooshi kaako bhaaya bhaabhapokeela mu nyumba shaabho, mukiikalaghe mula mula ukufika paapo indimukatiilaghe mu kaaya ako. ");
INSERT INTO ndh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Loole linga abhandu bhaaya bhaakaana ukubhapokeela mu kaaya kaabho, mukatiilagheemwo mu kaaya ako nu kukungʼunda ulufumbi luulwo luli mu tulundi twinyu, ukuti bhubhe bhukeeti ubhwa kubhasoka ukuti uChaala indiakabhalonge, paapo bhaakaana ukuyiitika indumi yaake.” ");
INSERT INTO ndh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Po abhamanyili bhala bhakatiila nu kubhuuka mu kaaya akanandi kamu ukufika akaaya akanandi akanine, bhakalumbililagha ku bhandu iNongwa iNyiisa isha chitangalala icha Chaala nu kubhaposha bhaabho bhakabha bhabhine kwoshi kuukwo bhakabhuukagha. ");
INSERT INTO ndh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Umalafyale uHelooti yuuyo akabha mulongoshi ughwa chiisu icha Ghalilaayi akapulika imbombo shooshi shiisho uYeesu akabhombagha. Bhwo inongwa isho shaamwagha, uHelooti akayubhana leka ku nongwa iya kuti abhandu bhamu bhakatingi uYoohani uMwoshi ashuukite. ");
INSERT INTO ndh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Abhandu abhanine bhakatingi, “Umundu uyu musololi uEliiya yuuyo asetukite soona.” Abhanine bhakatingi, “Umundu uyu ghwe yumo mu bhasololi abha bhwila yuuyo ashuukite.” ");
INSERT INTO ndh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Loole uHelooti akayugha akati, “Une ingamuputula uYoohani uMwoshi umutu, kali, ghwini uyu yuuyo ingwendelela ukupulika ukuti akubhomba imbombo isha kuswighisha isho?” Ku nongwa iyo, uHelooti akanyonywanga leka ukukomaana nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Abhatumighwa bhala bhakaghaluka kuukwo uYeesu akabhatuma pakulumbilila nu kubhaposha abhabhine, bhakamupangila shooshi shiisho bhakabhombagha. Po uYeesu akabheegha nu kubhuuka pamupeene nabho pabhushiifu kupiipi na kaaya aka Bheetisayita. ");
INSERT INTO ndh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Loole ifilundilo ifya bhandu fikamanya kuukwo uYeesu na bhamanyili bhaake bhakabhuukagha, po fikamukonga. UYeesu akabhapokeela abhandu abhingi abho nu kwanda ukubhamanyisha inongwa isha chitangalala icha Chaala nu kubhaposha bhaabho bhakabha bhabhine. ");
INSERT INTO ndh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bhwo lyabha lya namasubha, abhamanyili bhaake kalongo na bhabhili (12) bhakabhuuka kukwake, bhakamubhuula bhakati, “Ghwe Mumanyishi, tukukusuuma ubhalaghe abhandu abha ukuti bhabhuuke mu twaya utunandi tuutwo tuli papiipi na mu mighunda ukuti bhaye bhaghule ifindu nu kulonda ubhughono, paapo panu tuli patali nu twaya utwa bhandu.” ");
INSERT INTO ndh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Loole uYeesu akabhaamula akati, “Umwe, bhape ifindu abhandu abha.” Abheene bhakamwamula bhakati, “Utwe tuli ni mikati mihaano ni iswi shibhiliishe. Kali, kulonda utwe tubhuuke pakughula ifindu ifya kubhayiilania abhandu bhooshi abha?” ");
INSERT INTO ndh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Abhamanyili bhaake bhakayugha ulwo ku nongwa iya kuti pabhuyo bhula, bhakabhaapo abhaliisha abhoelufu bhahaano. Po uYeesu akabhabhuula abhamanyili bhaake akati, “Bhabhuule abhandu bhiikale paase mu fibhughutila nu kuti chooshi ichibhughutila chibhe na bhandu amalongo mahaano (50).” ");
INSERT INTO ndh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Po abhamanyili bhakabhabhuula abhandu isa muumwo uYeesu akabhabhuulila. Abhandu bhooshi bhakiikala paase mu fibhughutila. ");
INSERT INTO ndh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Po uYeesu akeegha imikati mihaano yila ni iswi shibhili shila, akatesha kumwanya, akapaalisha kwa Chaala. Bhwo aapaalisha, akabheghulania imikati yila ni iswi shila, akabhapa abhamanyili bhaake, bhoope bhakabhayabhila abhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Abhandu bhooshi bhakalya nu kwikuta. Po bhwo bhaalya, abhamanyili bhaake bhakabhungaania utubhululusha utwa mikati ni iswi shila nu kwisusha utupombo kalongo na tubhili (12). ");
INSERT INTO ndh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ishiku limo uYeesu akabhuuka pabhuyo ubhushiifu ukuti iipuute kwa Chaala. Abhamanyili bhaake bhakabha papiipi naghwe bhwo akwipuuta. Bhwo uYeesu aamala ukwipuuta, akabhabhuusha abhamanyili bhaake akati, “Kali, ifilundilo ifya bhandu fikuunjugha une ukuti nee ghwini?” ");
INSERT INTO ndh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Abheene bhakamwamula bhakati, “Abhandu bhamu bhakukuyugha ughwe ukuti ghwe Yoohani uMwoshi, abhanine bhakuti ughwe ghwe musololi uEliiya na bhanine bhakuti ughwe ghwe yumo mu bhasololi abha bhwila yuuyo ashuukite.” ");
INSERT INTO ndh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Po uYeesu akabhabhuusha abheene akati, “Kali, umwe mukuti une nee ghwini?” UPeeteli akamwamula akati, “Ughwe ghwe Mesiiya ukufuma kwa Chaala!” ");
INSERT INTO ndh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","UYeesu akabhasoka nu kubhakaanisha abhamanyili bhaake ukuti manye bhamubhuulaghe umundu naayumo inongwa isho. ");
INSERT INTO ndh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Po uYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “UMwana ughwa Mundu akulondighwa ukushaagha indamyo inyingi, ukukaanighwa na bhosongo abha Bhayuuta, abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose nu kughoghighwa. Loole indiakashuuke pi ishiku ilya bhutatu.” ");
INSERT INTO ndh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Po uYeesu akabhabhuula abhandu bhooshi akati, “Umundu ghweshi yuuyo akulonda ukuungonga, iikaane mwene, apimbaghe ichikobhekano chaake lyoshi ishiku, aangongaghe. ");
INSERT INTO ndh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Paapo umundu ghweshi yuuyo akulonda ukubhupoka ubhwumi bhwake mwene, indiabhupyute. Loole umundu yuuyo akubhufumya ubhwumi bhwake ku nongwa yangu, uyo ghwe yuuyo indiabhupoke. ");
INSERT INTO ndh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kali, umundu akukabha kooni linga aabhwagha ubhukabhi bhwoshi ubhwa pa chiisu ichi, loole aabhusofya ubhwumi bhwake? ");
INSERT INTO ndh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ku nongwa iyo, umundu ghweshi yuuyo akufwa isoni ukuunyiitika une na mashu ghangu, uMwana ughwa Mundu indiakamufwile isoni bhwo akwisa nu bhukulumba ubhwa Taata ghwake pamupeene na bhandumi abheelu. ");
INSERT INTO ndh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nalooli ingubhabhuula, bhaliipo abhandu bhamu bhaabho bhiimite panu bhaabho bhataabhakafwe bhwo bhakaali ukuchibhona ichitangalala icha Chaala.” ");
INSERT INTO ndh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bhwo amashiku mahaano na matatu (8) ghaakinda ukufuma bhwo uYeesu aayugha amashu agho, akamwegha uPeeteli, uYoohani nu Yaakobhu, akakwela pamupeene nabho pa kaghamba pakwipuuta kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bhwo uYeesu ali pakwipuuta, icheeni chaake chikasanuka, imyenda yaake yikabha myelu nu kungʼangʼa ngaani. ");
INSERT INTO ndh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nakalinga bhakabhoneka abhandu bhabhili, uMoose nu Eliiya bhakuyugha naghwe. ");
INSERT INTO ndh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bhoope bhakabhonekagha mu bhukulumba, bhakayughagha nu Yeesu isha kumaliisha ubhwighane ubhwa Chaala ku sila iya kufwa mu kaaya aka Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mu kabhalilo ako, uPeeteli na bhanine bhakashumbeelagha. Loole bhwo bhaalamusha, bhakamubhona uYeesu akungʼangʼa mu bhukulumba, soona bhakabhabhona abhandu bhabhili bhiimite pamupeene naghwe. ");
INSERT INTO ndh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bhwo uMoose nu Eliiya bhaanda pakutiila, uPeeteli akamubhuula uYeesu akati, “Ghwe Songo, kiisa ukuti utwe twikalaghe panu panu. Po ingusuuma tusenge ifitembe fitatu, chimo chibhe chaako, ichinine chibhe cha Moose ni chinine chibhe cha Eliiya.” Loole uPeeteli atakamanya shiisho akayughagha. ");
INSERT INTO ndh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bhwo uPeeteli akaali ali pakuyugha, tesha, ibhingu likiisa nu kubhiifunikila. Po abhamanyili abha Yeesu bhakooghopa bhwo ibhingu lila lyabhiifunika. ");
INSERT INTO ndh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Po ishu likapulikighwa ukufuma mu ibhingu likati, “Uyu ghwe yuuyo Mwana ghwangu umusalighwa yuuyo imusalite, mupulikaghe!” ");
INSERT INTO ndh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bhwo uChaala aamala ukuyugha, abhamanyili bhala bhakamubhona uYeesu ali mwene. Po bhakashibhiika inongwa isho mu ndumbula shaabho nu kuti mu mashiku ghala bhatakamubhuula umundu naayumo shiisho bhakashibhona nu kushipulika pa kaghamba kala. ");
INSERT INTO ndh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ishiku liilyo likakongagha, bhwo uYeesu na bhamanyili bhatatu bhala bhiilomuka ukufuma pa kaghamba kala, ichilundilo ichikulu icha bhandu chikiisa pakukomaana nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Po umundu yumo ukufuma mu chilundilo icha bhandu bhala akiitisha ku ishu ilya pamwanya akati, “Ghwe Mumanyishi, ingukusuuma umupelele ichisa nu kumuposha umwana ghwangu ku nongwa iya kuti ghwe yuuyo mwana ghwangu mweneeshe yuuyo indi naghwe. ");
INSERT INTO ndh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Imbepo imbiibhi yikumulongoshanga akabhalilo kooshi, po yikumupelelagha umulumyana ukuti ayweghaghe ngaani. Soona yikumughwishanga paase ku maka nu kwanda ukufuma indotofulo ku mulomu. Imbepo imbiibhi iyo yitakumulekeshanga naalumo, loole yikumufulashanga akabhiibhi leka. ");
INSERT INTO ndh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Imbasuumite abhamanyili bhaako ukuti bhayikiishe imbepo imbiibhi iyo, loole bhapooshitwe.” ");
INSERT INTO ndh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","UYeesu akabhaamula akati, “Mwe bhandu abha kabhalilo aka mwe mutakwitika, mwe musobhite. Kali, indiniikale nuumwe nu kukibha ukufika liighi? Isagha panu nu mwana ghwako uyo!” ");
INSERT INTO ndh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bhwo ughwise akubhuuka nu mwana ghwake yula kwa Yeesu, imbepo imbiibhi yila yikamughwisha paase nu kumuyungaania ku maka. Loole uYeesu akayikemela imbepo imbiibhi yila, akamuposha umwana yula nu kumughalusha kwa ghwise. ");
INSERT INTO ndh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Abhandu bhooshi bhakaswigha leka pakughabhona amaka amakulu agha Chaala. Bhwo abhandu bhala bhakaali bhakuswigha shooshi shiisho uYeesu akashibhombagha, uYeesu akabhabhuula abhamanyili bhaake akati, ");
INSERT INTO ndh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pulikishanga akiisa ishi shiisho inguya pakubhabhuula! UMwana ughwa Mundu akuya pakubhiikighwa mu tukono utwa bhalughu.” ");
INSERT INTO ndh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Loole abhamanyili bhaake bhatakashaaghania shiisho uYeesu akayughagha ku nongwa iya kuti isanusho lyake likafifighwa kukwabho ukuti manye bhashaaghaniange. Soona bhakooghopagha ukumubhuusha uYeesu ukuti abhalingaanie isanusho lyake. ");
INSERT INTO ndh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ishiku limo abhamanyili abha Yeesu bhakaanda ukukaanikana bheene-bheene ukuti pakati papaabho ghwini yuuyo indiabhe ghwi songo ukukinda abhanine bhooshi. ");
INSERT INTO ndh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Loole uYeesu akashimanya inyinongʼono shiisho bhakiinongʼonagha mu ndumbula shaabho. Po akamwegha umwana umukeke nu kumwimika papiipi naghwe. ");
INSERT INTO ndh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Po akabhabhuula abhamanyili bhaake akati, “Umundu ghweshi yuuyo akumupokeela umwana umukeke isa uyu ku nongwa yangu, akuumbokeela neene. Soona, umundu ghweshi yuuyo akuumbokeela une, po akumupokeela nu Chaala yuuyo aandumite. Paapo umundu ghweshi yuuyo akwiyiisha pakati papiinyu mweshi isa umwana umukeke uyu, ghwe yuuyo ghwi songo.” ");
INSERT INTO ndh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bhwo uYoohani aamupulika uYeesu shiisho akayughagha, akamubhuula akati, “Ghwe Mumanyishi, twamubhweni umundu yumo yuuyo aashikiishanga imbepo imbiibhi ukubhombela ingamu yaako, nuutwe twamukaanishiishe ku nongwa iya kuti atali pamupeene nuutwe.” ");
INSERT INTO ndh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Loole uYeesu akamwamula akati, “Manye mumukaanishange paapo umundu ghweshi yuuyo atakubhakaanika umwe, ali kulubhafu lwinyu.” ");
INSERT INTO ndh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bhwo akabhalilo kaapalamila aka Chaala ukumwegha uYeesu nu kubhuuka naghwe kumwanya, uYeesu akatumula ukubhuuka mu kaaya aka Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Po akabhatuma abhandu bhamu bhatangile mundaashi ukubhuuka mu kaaya kamu aka mu chiisu icha Samaliiya pakutendekesha ubhuyo ubhwa kutuusha uYeesu pamupeene na bhaabho akabha nabho. ");
INSERT INTO ndh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Loole ku nongwa iya kuti uYeesu akabhuukagha ku Yelusaleemu, aBhasamaliiya bhakakaana ukumupokeela ukuti iikale mu kaaya kaabho. ");
INSERT INTO ndh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bhwo abhamanyili bhaake uYaakobhu nu Yoohani bhaapulika ukuti aBhasamaliiya bhaakaana ukubhapokeela mu kaaya kaabho, bhakakalala leka, bhakamubhuusha uYeesu bhakati, “Ghwe Malafyale, kali, kulonda tumusuume uChaala atume umulilo ghwike ukufuma kumwanya ukuti ghubhapembanie abhandu bhooshi isa muumwo umusololi uEliiya akabhombela ku bhandu bhamu?” ");
INSERT INTO ndh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Loole uYeesu akabhasanukila nu kubhakemela. Akabhabhuula akati, “Mutameenye ukuti mukulondighwa ukubha ni nyinongʼono isha luko luki. ");
INSERT INTO ndh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Paapo uMwana ughwa Mundu atakiisa pakubhapyuta abhandu loole pakubhapoka.” Po uYeesu na bhamanyili bhaake bhakatiila nu kubhuuka mu kaaya akanandi akanine. ");
INSERT INTO ndh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ishiku limo bhwo uYeesu na bhamanyili bhaake bhakughenda mu sila, umundu yumo akamubhuula uYeesu akati, “Ghwe Malafyale, indiingukongaghe kwoshi kuukwo kubhuuka!” ");
INSERT INTO ndh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","UYeesu akamwamula akati, “Abhombila bhali ni mbako nu tuyuni tuli ni fifumbo, loole uMwana ughwa Mundu atali na pa kughoneka umutu ghwake!” ");
INSERT INTO ndh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","UYeesu akamubhuula umundu umunine akati, “Ghwe mundu ughwe, ingongaghe!” Umundu yula akamwamula akati, “Ghwe Malafyale, ingukusuuma ghuunyiitikishe imbuuke taashi pakumushiila utaata.” ");
INSERT INTO ndh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Loole uYeesu akamwamula akati, “Bhaleke abhafwe bhabhashiilaghe abhafwe bhaabho. Loole ughwe bhuukagha pakufumusha inongwa isha chitangalala icha Chaala ku bhandu.” ");
INSERT INTO ndh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Umundu umunine akamubhuula uYeesu akati, “Ghwe Malafyale, une indiingukongaghe, loole ingukusuuma ghuunyiitikishe imbuuke taashi kukaaya ukuti inje imbalaghe abhakamu bhangu.” ");
INSERT INTO ndh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","UYeesu akamubhuula akati, “Linga umundu aanda ukulima ni ngʼombe, loole akusanusha kunyuma, uyo atabhaghiile ukubha mubhombi mu chitangalala icha Chaala.” ");
INSERT INTO ndh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bhwo isho shaakinda, uMalafyale uYeesu akabhasala abhamanyili abhanine amalongo mahaano na mabhili na bhabhili. Akabhasala abhamanyili abho nu kubhatuma bhabhili bhabhili ukuti bhatangile ukubhuuka mu twaya na mumbafu shooshi muumwo akabhaatika ukubhuuka yuuyo mwene. ");
INSERT INTO ndh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bhwo bhakaali ukubhuuka, uYeesu akabhabhuula akati, “Ifyakwinula fyo fyingi leka, loole abhiinuli bhanandi. Po musuumaghe uMalafyale yuuyo mwene mughunda ukuti abhatume abhabhombi mu mughunda ghwake. ");
INSERT INTO ndh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ulu bhuukagha. Loole mubhange maaso, mumanye ukuti ingubhatuma isa abhonangʼooshi pakati pa bhondekelakatu! ");
INSERT INTO ndh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bhwo mukubhuuka manye mweghaghe inyambi iya ndalama, ichoola pamu ifilato ifya kuchenjesania. Linga mukubhalamuka abhandu mu sila, manye mweghaghe akabhalilo akatali. ");
INSERT INTO ndh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Soona linga mwingila mu nyumba iya mundu, mukatangaghe taashi ukulamuka mukatingi, ‘UChaala abhapange ulutengaano mwe bhandu mwe muli mu nyumba iyi.’ ");
INSERT INTO ndh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Linga umundu yuuyo mubhaghile ukupokeela ulutengaano aliimwo mu nyumba iyo, po uChaala indiamupange ulutengaano. Loole linga umundu uyo ataliimwo mu nyumba iyo, ulutengaano ulwo indilukabhaghalukile umwe. ");
INSERT INTO ndh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mukiikalaghe mu nyumba yiiyo bhaabhapokeela, mukalyange nu kungʼwa fiifyo indibhakabhapange paapo umubhombi akulondighwa ukupeeliighwa umufwalo ukufuma ku bhandu bhaabho akubhabhombela. Manye mukasaamaghe-saamaghe ukufuma inyumba yimo ukubhuuka inine. ");
INSERT INTO ndh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Linga mwaya mwingila mu kaaya kaako abhenekaaya bhaabhapokeela, mukalyange ifindu fyoshi fiifyo indibhakabhapange.” ");
INSERT INTO ndh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","UYeesu akeendelela pakubhalingaania abhamanyili bhaake akati, “Abhabhine bhaabho indimukabhaaghaghe mu kaaya kaako bhaabhapokeela, mukabhaposhange amabhine ghaabho soona mukabhabhuulaghe ukuti, ‘Ichitangalala icha Chaala chipalamiile kukwinyu.’ ");
INSERT INTO ndh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Loole linga mwaya mwingila mu kaaya kaako abhenekaaya bhataabhapokeela, bhwo mukufumaamwo, mukayughaghe mukatingi, ");
INSERT INTO ndh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Inditubhakungʼundile nu lufumbi ulwa mu kaaya kiinyu luulwo luli mu tulundi twitu ukuti bhubhe bhukeeti kukwinyu. Loole pamupeene nu kuti mukutukaana utwe, mumanye ukuti ichitangalala icha Chaala chipalamiile kukwinyu.’ ");
INSERT INTO ndh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ingubhabhuula ukuti pi ishiku ilya bhulongi, indishikabhe mbepe ku kaaya aka Sondoma ukupona ubhulongi ukukinda akaaya ako!” ");
INSERT INTO ndh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","UYeesu akeendelela ukuyugha akati, “Lwinyu mwe bhandu abha kaaya aka Kolasiini! Lwinyu mwe bhandu abha kaaya aka Bheetisayita! Paapo ifyika fiifyo ingafibhombagha kukwinyu, linga ingafibhombagha mu kaaya aka Tiilo na mu ka Sindoni, abhandu abha twaya utwo ngali bhakafwala amaghunila nu kupakala ilyoto ukulangisha ukuti bhaapinduka nu kwilaata imbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Loole pi ishiku ilya bhulongi umwe indimukapokeele ulufundo ulukulu ukukinda akaaya aka Tiilo na ka Sindoni. ");
INSERT INTO ndh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nuumwe mwe bhandu abha kaaya aka Kapenabhumu, kali, mukwinongʼona ukuti uChaala indiakabhakweshe ukufika kumwanya? Nashiku! UChaala indiakabhiilomushe ukufika ku bhushuuka.” ");
INSERT INTO ndh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Umundu ghweshi yuuyo akubhapulika umwe, akuumbulika neene. Umundu yuuyo akubhakaana umwe, akuungaana neene. Soona, umundu ghweshi yuuyo akuungaana une, akumukaana yula yuuyo aandumite une.” ");
INSERT INTO ndh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Po abhamanyili amalongo mahaano na mabhili na bhabhili (72) bhala bhakaghaluka ku lusekelo ukufuma kuukwo uYeesu akabhatuma. Bhwo bhaafika kwa Yeesu, bhakamupangila bhakati, “Ghwe Malafyale, bhwo twashikiisha imbepo imbiibhi ukubhombela ingamu yaako, shoope shaatupulikagha!” ");
INSERT INTO ndh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","UYeesu akabhabhuula akati, “Naamubhweni uSeetano bhwo akughwa ukufuma kumwanya isa muumwo akalabhi kakughwa ukufuma kumwanya. ");
INSERT INTO ndh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tesha, naabhapa amaka agha kukanya injoka na bhongoonya. Soona naabhapa amaka agha kughapoota amaka ghooshi agha mulughu ghwinyu uSeetano. Kataliipo soona akandu aka kubhafulasha umwe. ");
INSERT INTO ndh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Manye musekelaghe ku nongwa iya kuti imbepo imbiibhi shaabhapulikagha, loole sekelagha paapo uChaala asimbite ingamu shiinyu mwa kalata ghwake yuuyo ali kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mu kabhalilo kala kala, uMbepo uMwelu akamupa uYeesu ukusekela ngaani mu ndumbula yaake, po akayugha akati, “Ghwe Taata, ghwe Malafyale ghwa kumwanya na pa chiisu panu, ingukupaalisha paapo imbombo ishi ukabhafifa abhandu abha mahala na bhamanyi, loole ukashibhiika pabhwelu ku bhandu bhaabho bhali ungati bhaana abhakeke. Nalooli, ghwe Taata, umwo mwo muumwo ukiighanila.” ");
INSERT INTO ndh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","UYeesu akayugha soona akati, “UTaata aambiile fyoshi. Naayumo umundu yuuyo amumeenye uMwana, loole uTaata mwene. Soona naayumo umundu yuuyo amumeenye uTaata, loole uMwana mwene nu mundu ghweshi yuuyo uMwana akwighana ukumulangisha uTaata kukwake.” ");
INSERT INTO ndh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Po uYeesu akabhabhuula abhamanyili bhaake bhwo bhali bheene akati, “UChaala abhasayite umwe paapo mukushibhona ishi na maaso ghiinyu. ");
INSERT INTO ndh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nalooli ingubhabhuula ukuti bhakabhaapo abhasololi na bhomalafyale abhingi bhaabho bhakanyonywanga ukushibhona shiisho mukushibhona umwe, loole bhatakashibhonagha. Soona bhakanyonywanga ukupulika shiisho mukushipulika umwe, loole bhatakashipulikagha.” ");
INSERT INTO ndh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Po umumanyishi yumo ughwa ndaghilo isha Moose akiisa kwa Yeesu nu kumubhuusha ku sila iya kumughela akati, “Ghwe Mumanyishi, kali, imbombe kooni ukuti imbwaghe ubhwumi ubhwa bhwila na bhwila?” ");
INSERT INTO ndh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","UYeesu akamubhuusha akati, “Kali, indaghilo isha Chaala shikukulaghila ukuti ubhombaghe kooni? Kali, kushaaghania shiliku mu ndaghilo isho?” ");
INSERT INTO ndh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Umwene akamwamula akati, “Indaghilo isha Chaala shikutulaghila ukuti, ‘Mughanaghe uMalafyale uChaala ghwako ku ndumbula yaako yooshi, ku nyinongʼono shaako shooshi, ku maka ghaako ghooshi na ku mahala ghaako ghooshi.’ Soona shikutulaghila ukuti, ‘Mughanaghe umunyiinyu isa muumwo ghwiyiighanite yughweghwe.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","UYeesu akamubhuula akati, “Ghwamula akiisa leka! Linga kushibhombela imbombo indaghilo shooshi isho, uChaala indiakupe ubhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Loole ku nongwa iya kuti umumanyishi ughwa ndaghilo isha Moose yula akalondagha ukwilangisha ukuti mundu mwisa, akamubhuusha soona uYeesu akati, “Kali, umunyangu ghwe ghwini?” ");
INSERT INTO ndh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","UYeesu akamwamula ku sila iya chifwanikisho akati, “Akabhaakwo umundu yumo yuuyo akachuulagha ukufuma mu kaaya aka Yelusaleemu nu kwilomuka ukubhuuka mu kaaya aka Yeeliko. Bhwo ali mu sila akughenda, abhapoka ifya bhandu bhakamwisila nu kumukola, bhakamufuula imyenda, bhakamukoma ngaani nu kumuleka bhwo ali papiipi nu kufwa. ");
INSERT INTO ndh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ku lusako ulwisa, umupuuti yumo yuuyo akachuulagha, akaghendela isila yila yila. Bhwo aamubhona umundu yula yuuyo abhapoka ifya bhandu bhakamukoma, akaghenda kulubhafu, akamuleka pala pala chishita kumwafwa. ");
INSERT INTO ndh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bhwo akabhalilo akapimba kaakinda, umundu umunine ukufuma mu chikolo icha Laabhi ghwepe akachuulagha ukughendela isila yila yila. Bhwo aafika pala nu kumubhona umundu yuuyo abhapoka ifya bhandu bhakamukoma, ghwepe akaghenda kulubhafu nu kumuleka pala pala chishita kumwafwa. ");
INSERT INTO ndh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Loole bhwo akabhalilo kaakindaapo, umundu yumo uMusamaliiya ghwepe akachuulagha ukughendela isila yila yila. Bhwo aamubhona umundu yula yuuyo abhapoka ifya bhandu bhakamukoma, akamupelela ichisa ngaani. ");
INSERT INTO ndh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Po akabhiyila papiipi, akamusuka ifilonda fyake ukubhombela indifaayi ni nyemba isha mishunguti nu kumupinya. Po akamwegha, akamukwesha pa mbunda yaake, akabhuuka naghwe mu nyumba iya bhaheesha, akaanda ukumubhinia. ");
INSERT INTO ndh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Ishiku liilyo likakongagha uMusamaliiya yula akeegha indinaali shibhili, akamupa umwimilili ughwa nyumba iya bhaheesha, akamubhuula akati, ‘Ingukusuuma umubhiniange umundu uyu. Linga ghwabhombela indinaali inyingi ukukinda isho shiisho naakupa, indiingakughalushikishe bhwo ingughaluka.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bhwo uYeesu aamala ukulingaania ichifwanikisho icho, akamubhuusha umumanyishi ughwa ndaghilo isha Moose yula akati, “Kali, mu bhandu bhatatu abho, ghwini yuuyo kwinongʼona ukuti akabha munyaake ughwa nalooli ughwa mundu yuuyo abhapoka ifya bhandu bhakamukoma?” ");
INSERT INTO ndh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Umwene akamwamula akati, “Umunyaake ughwa nalooli ghwe yula yuuyo akamupelela ichisa.” Po uYeesu akamubhuula akati, “Nuughwe bhuuka ubhabhombelaghe abhandu bhooshi isa bhubhuubhwo.” ");
INSERT INTO ndh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Akabhalilo kamu uYeesu na bhamanyili bhaake bhakachuulagha ukubhuuka ku Yelusaleemu. Bhwo bhakubhuuka, bhakafika mu kaaya kamu. Mu kaaya ako akiikalagha umukolo yumo yuuyo ingamu yaake akabha ghwi Maalita. Po uMaalita akamupokeela uYeesu mu nyumba yaake ukuti alye ifindu. ");
INSERT INTO ndh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","UMaalita akabha nu munungʼuna yuuyo ingamu yaake akabha ghwi Maliiya. Bhwo uYeesu iingila nu kwikala mu nyumba iyo, uMaliiya akabhuuka nu kwikala papiipi nu Yeesu, akapulikishanga shiisho akayughagha. ");
INSERT INTO ndh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Loole uMaalita akiikolaania ni mbombo inyingi. Po akabhuuka kwa Yeesu, akamubhuusha akati, “Ghwe Malafyale, kali, utakusaaghilaakwo ukuti umunungʼuna ghwangu aandekite ingubhomba imbombo nimwene? Ingukusuuma umubhuule iise aanyaafwe.” ");
INSERT INTO ndh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Loole uMalafyale uYeesu akamwamula akati, “Ghwe Maalita, ghwe Maalita, kali, kooni kulabha nu kwikolaania ni mbombo inyingi? ");
INSERT INTO ndh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Loole kaliipo akandu kamukeeneeshe kaako kakulondighwa nalooli ukuti ghwikolanie nako. Umwene uMaliiya aasala akandu akiisa kaako naayumo umundu yuuyo indiakamupoke.” ");
INSERT INTO ndh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ishiku limo uYeesu akabha pabhuyo bhumo akiipuutagha kwa Chaala. Bhwo aamala ukwipuuta, umumanyili ghwake yumo mu bhamanyili bhaake akamusuuma akati, “Ghwe Malafyale, tukukusuuma utumanyishe ukwipuuta kwa Chaala isa muumwo uYoohani akabhamanyisha abhamanyili bhaake.” ");
INSERT INTO ndh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","UYeesu akabhabhuula akati, “Linga mukwipuuta kwa Chaala mutingi, ‘Taata ghwitu ughwa kumwanya, ingamu yaako yipaalighwe. Ichitangalala chaako chiise. Ubhwighane bhwako bhubhombighwe pa chiisu panu, isa muumwo bhukubhombighwa kumwanya ukwo. ");
INSERT INTO ndh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utupe ifindu ifya kutuyiilana umuusughu. ");
INSERT INTO ndh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utuhobhokele ubhutulanongwa bhwitu, isa muumwo nuutwe tukumuhobhokela ghweshi yuuyo akututulila inongwa. Manye utubhiike mu ngelo, loole utupoke ku Mubhiibhi yula.’ ");
INSERT INTO ndh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","“Kali, ghwini pakati papiinyu yuuyo ali nu mumanyani ghwake, yuuyo akubhuuka kukwake pabhushiku pakati pakumusuuma ukuti amwafwe ifindu? ");
INSERT INTO ndh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Bhwo aafika, akumubhuula akuti, ‘Umumanyani ghwangu yuuyo akuchuula, iisa kukwangu pakuundamuka, loole indali ni findu ifya kumupa.’ ");
INSERT INTO ndh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Po umumanyani uyo akumwamula akuti, ‘Manye ghuundamyange! Ulu twapinga ichiighi! Soona, une na bha mu nyumba yangu tughonite. Indabhaghiile ukunyatuka ukuti ingwafwe fiifyo kulonda.’ ");
INSERT INTO ndh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nalooli ingubhabhuula, umundu uyo atabhaghiile ukulamusha nu kukupa ifindu ifyo ku nongwa iya kuti ughwe ghwe mumanyani ghwake, loole indialamushe nu kukupa ifindu ifyo ku nongwa iya kuti kwendelela ukumusuuma. ");
INSERT INTO ndh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Po ingubhabhuula ukuti, suumagha kwa Chaala, ghwepe indiabhapange. Londagha ukufuma kwa Chaala, ghwepe indiabhaafwange ukufyagha. Ighushanga, ghwepe uChaala indiabhiighulilaghe ichiighi. ");
INSERT INTO ndh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Paapo umundu ghweshi yuuyo akusuuma, uChaala akumupa, ghweshi yuuyo akulonda, uChaala akumwafwa ukufyagha. Soona, ghweshi yuuyo akwighusha, uChaala akumwighulila ichiighi. ");
INSERT INTO ndh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kali, ghwini pakati papiinyu yuuyo linga umwana ghwake aamusuuma iswi, akumupa injoka? ");
INSERT INTO ndh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pamu kali, ghwini pakati papiinyu linga umwana aamusuuma iighe, akumupa ungoonya? ");
INSERT INTO ndh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Po linga umwe mwe muli bhabhiibhi mumeenye ukubhapa abhaana bhiinyu utundu utwisa, kali, uGhuuso yuuyo ali kumwanya ataaakoongeleepo ukubhapa uMbepo uMwelu abhandu bhaabho bhakumusuuma?” ");
INSERT INTO ndh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ishiku limo uYeesu akayikiishanga imbepo imbiibhi yiiyo yikamupelela umundu yumo ubhwochinuunu. Bhwo imbepo imbiibhi yila yaafuma, po umundu yula akaanda ukuyugha. Ichilundilo icha bhandu bhaabho bhakabhaapo pala bhakaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Loole bhamu pakati papaabho bhakayugha bhakati, “Umundu uyu akushikiisha imbepo imbiibhi ku maka agha Bhelisebhuli, usongo ughwa mbepo imbiibhi!” ");
INSERT INTO ndh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abhanine bhakamughelagha uYeesu ukuti abhombe ichiika ukulangisha ukuti afumite kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Loole bhwo uYeesu aashimanya inyinongʼono shaabho, akabhabhuula akati, “Linga abhandu abha bhunyafyale bhumobhwene bhaayabhanika, po ubhunyafyale ubhwo bhutabhaghiile ukwendelela. Bhubhuubhwo, linga abhandu abha mu nyumba yimoyeene bhaakindana, inyumba iyo yikukomanika. ");
INSERT INTO ndh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Linga uSeetano akulwa nu bhunyafyale bhwake, kali, ubhunyafyale ubhwo bhubhaghiile bhwendelele bhuleele? Ingubhabhuusha isho paapo mukuti une ingushikiisha imbepo imbiibhi ku maka agha Bhelisebhuli. ");
INSERT INTO ndh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Linga mukuti une ingushikiisha imbepo imbiibhi ku maka agha Bhelisebhuli, po kali, abhakongi bhiinyu bhakushikiisha ku maka agha ghwini? Ku nongwa iyo, abho bho bhaabho indibhakabhalongaghe umwe. ");
INSERT INTO ndh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Loole linga ingushikiisha imbepo imbiibhi ku maka agha Chaala, po mumanye ukuti ichitangalala icha Chaala chibhiisiile umwe! ");
INSERT INTO ndh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Linga umundu ughwa maka akuyilindilila inyumba yaake ni filwilo ifya maka, ataliipo umundu naayumo yuuyo abhaghiile ukwegha utundu twake. ");
INSERT INTO ndh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Loole linga iisa yuuyo ali na maka ukumukinda umwene, aamwingilila nu kumupoota, po akupoka ifilwilo fyake fyoshi fiifyo aasubhaalilagha, akwegha utundu twoshi tuutwo aali natwo nu kubhayabhila abhamanyani bhaake. ");
INSERT INTO ndh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Umundu ghweshi yuuyo atali pamupeene nuune, akuungaanika une. Soona, ghweshi yuuyo atakubhungaania abhandu pamupeene nuune nu kubhabhiika kwa Chaala, akunyambaania.” ");
INSERT INTO ndh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","UYeesu akeendelela ukuyugha akati, “Linga imbepo imbiibhi yaafuma mu mundu, yikushunguulila-shunguulila pabhuyo paapo patali na miishi bhwo yikulonda ubhuyo ubhwa kutuusha. Loole linga yitabhwagha, yikuti, ‘Indiingaluke mu nyumba yangu muumwo ingafuma.’ ");
INSERT INTO ndh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Linga yaafika mula, yikwagha inyumba mbyaghile soona yitendekeshiighwe akiisa. ");
INSERT INTO ndh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Po yikubhuuka pakusheegha imbepo imbiibhi inine ihaano na shibhili (7) shiisho mbiibhi ukukinda iyeene. Imbepo shooshi isho shikwingila mu mundu uyo, shikushaala mula mula. Po ubhughone ubhwa mundu uyo ubhwa bhumalilo bhukubha bhubhiibhi ukukinda ubhwa bhwandilo.” ");
INSERT INTO ndh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bhwo uYeesu ali pakuyugha isho, umukolo yumo ukufuma mu chilundilo icha bhandu chila, akayugha ku ishu ilya pamwanya akati, “UChaala amusayite umukolo yuuyo akakupaapa nu kukwongesha!” ");
INSERT INTO ndh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","UYeesu akaamula akati, “Mwo muumwo, loole uChaala abhasayite ukwongelaapo abhandu bhaabho bhakulipulika ishu lyake nu kulibhombela imbombo.” ");
INSERT INTO ndh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bhwo abhandu bhakwongela ukubhungaana, uYeesu akayugha akati, “Abhandu abha kabhalilo aka, bhandu bhabhiibhi. Bhandu bhaabho bhakulonda indangishe ichiika. Une indaaingabhalangishe ichiika naachimo, loole chila cheene chiicho uChaala akachibhomba ku musololi uYoona. ");
INSERT INTO ndh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Isa muumwo uYoona akabha chilangisho ku bhandu abha kaaya aka Ninaabhi, bhubhuubhwo, uMwana ughwa Mundu indiakabhe chilangisho ku bhandu abha mbaapo iyi. ");
INSERT INTO ndh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Pi ishiku ilya bhulongi, umalafyale umukolo ughwa chiisu icha Sheebha indiakiime nu kubhalonga abhandu abha mbaapo iyi ukuti bhatulanongwa. Paapo umwene akafuma ku chiisu icha kubhutali ukuti iise apulikishe ifimanyisho ifya mahala ifya malafyale uSolomooni. Loole ingubhabhuula umwe ukuti aliipo yumo panu yuuyo mughindikighwa ukukinda uSolomooni. ");
INSERT INTO ndh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pi ishiku ilya bhulongi, abhandu abha mu kaaya aka Ninaabhi indibhakiime pamupeene na bhandu abha mbaapo iyi nu kubhalonga ukubha bhatulanongwa. Paapo abheene bhakapinduka nu kwilaata imbiibhi shaabho bhwo bhaapulika uYoona akulumbilila ishu ilya Chaala. Loole ingubhabhuula umwe ukuti aliipo yumo panu yuuyo mughindikighwa ukukinda uYoona.” ");
INSERT INTO ndh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","UYeesu akeendelela ukuyugha akati, “Ataliipo umundu yuuyo linga aakosha inyaale, akuyibhiika paapo pashiifu pamu akuyiifunikila ni chipombo. Loole akuyibhiika pa chitalati ukuti linga abhandu bhakwingila, bhabhubhonaghe ubhwelu bhwake. ");
INSERT INTO ndh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Amaaso ghaako ghali ungati nyaale iya mubhili. Linga amaaso ghaako ghali akiisa, ubhaghiile ukutesha akiisa kooshi akandu. Loole linga amaaso ghaako ghafwile, utabhaghiile ukutesha akandu naakamu paapo kubha ungati uli mu chiisi. ");
INSERT INTO ndh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Po ubhange maaso ukuti ubhwelu bhuubhwo bhuliimwo mukati mumwako manye bhubhange chiisi! ");
INSERT INTO ndh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Linga umubhili ghwako ghwoshi ghuli mu bhwelu nu kuti naakamu kaako kali mu chiisi, po umubhili ghwoshi ghukubha nu bhwelu isa muumwo inyaale yikukubhalishanga nu bhwelu bhwake.” ");
INSERT INTO ndh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bhwo uYeesu aamala ukuyugha amashu agho, uMufalisaayi yumo akamupaalila ukuti abhuuke kukaaya kukwake pakulya ifindu. Po uYeesu akabhuuka, akiingila mu nyumba yaake, akiikala nu kulya ifindu. ");
INSERT INTO ndh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bhwo uMufalisaayi yula aamubhona uYeesu akulya ifindu chishita kusukusula taashi utukono ukukongana nu lwiho lwabho, akaswigha leka. ");
INSERT INTO ndh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Po uMalafyale uYeesu akamubhuula akati, “Mwe Bhafalisaayi umwe, muli ungati bhandu bhaabho bhakusuka ichikombe ni saghani kuuse kwene, loole mukati mwiswile ubhunyali ubhwa luko nu luko. Bhubhuubhwo, umwe mukwilangisha ku bhandu ukubha bhiisa, loole mu ndumbula shiinyu mwiswile ubhupafu nu bhubhiibhi ubhwa luko nu luko. ");
INSERT INTO ndh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwe bhalema umwe! Kali, mutameenye ukuti uChaala yuuyo akabhapela imibhili yiinyu iya kuuse ghwe yuuyo akabhapela na mukati? ");
INSERT INTO ndh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Loole bhaafwange abhapiina ku ndumbula shiinyu shooshi utundu tuutwo muli natwo chishita kwifuna, po indimubhange bheelu lwoshi, kuuse na mu ndumbula shiinyu. ");
INSERT INTO ndh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Lwinyu mwe Bhafalisaayi umwe! Paapo mukufumya ilongo kwa Chaala utundu utunandi isa inyungu, unambamba na mabhogha amanine agha mu chibheela, loole mukukaana ukushibhomba imbombo ingulu isa ukubhomba inyiisa nu kumughana uChaala. Mumanye ukuti uChaala akulonda ukuti mushibhombaghe shooshi ingulu pamupeene ni nandi. ");
INSERT INTO ndh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Lwinyu mwe Bhafalisaayi umwe! Paapo mwighanite leka ukwikala pa fitengu ifya bhaghindikighwa ifya mundaashi mu masinaghoghi. Soona mwighanite ukuti abhandu bhabhalamukaghe ku lughindiko mu minaalo. ");
INSERT INTO ndh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Lwinyu! Paapo umwe muli isa amapumba ghaagho ghatakubhoneka akiisa, ghaagho abhandu bhakughenda pamwanya chishita kumanya ukuti pali na mapumba.” ");
INSERT INTO ndh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Po umumanyishi yumo mu bhamanyishi abha ndaghilo isha Moose yuuyo akabhaapo pala, akamubhuula uYeesu akati, “Ghwe Mumanyishi, amashu agho kubhayugha aBhafalisaayi, kututuka nuutwe twe bhamanyishi abha ndaghilo.” ");
INSERT INTO ndh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","UYeesu akamwamula akati, “Lwinyu nuumwe mwe bhamanyishi abha ndaghilo isha Moose! Paapo mukubhapimbisha abhandu imishigho imingʼwamu iya ndaghilo yiiyo bhatabhaghiile ukupimba, loole umwe yumwemwe mutakughela ukugholosha nalinga kaana aka tukono twinyu ukuti mubhaafwe ukupimba! ");
INSERT INTO ndh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Lwinyu! Paapo mukusenga amapumba agha bhasololi abha Chaala bhaabho abhosekulu bhiinyu bhakabhaghogha! ");
INSERT INTO ndh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Linga mukubhomba ulwo, mukushimikisha ukuti mukwitikana na shiisho abhosekulu bhiinyu bhakashibhomba paapo abheene bhakabhaghogha abhasololi abha Chaala nuumwe mukusenga amapumba ghaabho! ");
INSERT INTO ndh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yo yiiyo nongwa iyi uChaala ughwa mahala akayugha akati, ‘Indiingabhatume kukwabho abhasololi na bhatumighwa, loole bhamu indibhakabhaghoghaghe, abhanine indibhakabhafulashange.’ ");
INSERT INTO ndh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Po uChaala indiakabhalonge abhandu abha kabhalilo aka ku nongwa iya kubhaghogha abhasololi bhaake ukufuma muumwo akapelela ichiisu. ");
INSERT INTO ndh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Indiakabhalonge ukufuma akabhalilo kaako bhakamughoghagha uAabheli ukufika akabhalilo kaako bhakamughoghagha uSakaliiya pakati pa Nyumba iya Chaala ni chighemo. Nalooli ingubhabhuula, uChaala indiakabhalonge abhandu abha kabhalilo aka ku nongwa iya kubhaghogha abhandu bhooshi abho. ");
INSERT INTO ndh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Lwinyu mwe bhamanyishi abha ndaghilo isha Moose! Paapo mufifite ifungulilo iya kwighulila umulyango ukuti abhandu bhiingilaghe nu kumumanya uChaala. Soona, umwe yumwemwe mukukaana ukwingila nu kuti mukubhashighila abhandu bhooshi bhaabho bhakulonda ukwingila.” ");
INSERT INTO ndh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bhwo uYeesu aamala ukuyugha amashu agho, akafumaamwo mu nyumba iya Mufalisaayi yula. Bhwo akutiilaapo pa kaaya kala, aBhafalisaayi na bhamanyishi abha ndaghilo isha Moose bhakabha bhakali leka kwa Yeesu. Po bhakaanda ukumuyweghelela ku lyoyo nu kumubhuusha amabhuusho amingi. ");
INSERT INTO ndh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bhakabhombagha shooshi isho ku nongwa iya kumuteghela uYeesu ukuti lumo indiayughe amashu ghamu amabhiibhi ukuti bhayaaghe isila iya kumukola nu kumusitaaka. ");
INSERT INTO ndh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mu kabhalilo kala kala, ichilundilo icha bhandu abhoelufu na bhoelufu bhakabhungaana pakumupulikisha uYeesu. Abhandu abho bhakabha bhingi ngaani ukufika paapo bhakaanda ukukanyana bheene-bheene bhwo bhakubhiyila kwa Yeesu. Po uYeesu akaanda ukuyugha taashi na bhamanyili bhaake akati, “Mubhange maaso nu bhwongubhisania ubhwa Bhafalisaayi, bhuubhwo bhukusaata ungati nyambo. ");
INSERT INTO ndh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Paapo akandu kaako katali pabhwelu, indikakasetulighwe, soona kooshi kaako kafifiighwe, indikakabhiikighwe pabhwelu. ");
INSERT INTO ndh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Po shooshi shiisho mukashiyugha ku chiisi, abhandu indibhakashipulikaghe pabhwelu. Soona shooshi shiisho mukuteketa ku ifungu bhwo ifyighi fipinge, indibhakashifumushange pabhwelu.” ");
INSERT INTO ndh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","UYeesu akeendelela ukuyugha akati, “Mwe bhamanyani bhangu, ingubhabhuula ukuti manye mubhooghopaghe abhandu bhaabho bhakughogha umubhili. Bhwo bhaaghogha umubhili, kataliipo akandu akanine kaako bhabhaghiile ukubhomba. ");
INSERT INTO ndh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Loole indiimbabhuule yuuyo mukulondighwa mumwoghopaghe. Mwoghopaghe uChaala, paapo umwene linga aamughogha umundu, ali na maka agha kumutaagha mu mulilo ughwa bhwila na bhwila ughwa mu Yehanamu. Nalooli ingubhabhuula, uyo ghwe yuuyo mwoghopaghe. ");
INSERT INTO ndh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kali, utubhelebheeswa tuhaano tutakughulishighwa ku salabhasha shibhiliishe? Poope uChaala atakukiibhwa naakamu mu tubhelebheeswa utwo. ");
INSERT INTO ndh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Loole kulubhafu lwinyu, uChaala abhelengite ni chingʼwili icha mitu yiinyu. Po manye mwoghopaghe paapo umwe muli nu lughindiko ukukinda utubhelebheeswa utwo.” ");
INSERT INTO ndh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","UYeesu akeendelela soona ukuyugha akati, “Nalooli ingubhabhuula, umundu ghweshi yuuyo akuunyiitika pandaashi pa bhandu, uMwana ughwa Mundu indiakamwitike pandaashi pa bhandumi abha Chaala ukuti mukongi ghwake. ");
INSERT INTO ndh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Loole umundu ghweshi yuuyo akuungaana pandaashi pa bhandu, nuune indiingamukaane pandaashi pa bhandumi abha Chaala ukuti mukongi ghwangu. ");
INSERT INTO ndh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Soona ingubhabhuula ukuti uChaala indiakamuhobhokele umundu ghweshi yuuyo akumufuyula uMwana ughwa Mundu, loole ataaakamuhobhokele umundu ghweshi yuuyo akumufuuya uMbepo uMwelu. ");
INSERT INTO ndh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Linga abhandu bhakuya kubhuuka nuumwe mu masinaghoghi nu kubhasitaaka pandaashi pa bhosongo na pa bhalongoshi, manye mukapaashange ukuti indimukayughaghe kooni pamu indimukayughaghe bhuleele. ");
INSERT INTO ndh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Paapo uMbepo uMwelu indiakabhamanyishange mu kabhalilo kala kala shiisho indimukayughaghe.” ");
INSERT INTO ndh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Po umundu yumo ukufuma mu chilundilo chiicho chikamupulikishanga uYeesu, akamubhuula uYeesu akati, “Ghwe Mumanyishi, ingukusuuma umubhuule umukulu ghwangu ukuti tuyabhane ifyuma ifya chilingo fiifyo utaata akatulekela bhwo aafwa.” ");
INSERT INTO ndh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Loole uYeesu akamwamula akati, “Ghwe mundu ughwe, kali, ghwini yuuyo aambiikite une ukubha ghwa kulongania inongwa shiinyu nu kuyabhania utundu twinyu utwa chilingo?” ");
INSERT INTO ndh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Po uYeesu akabhabhuula akati, “Mubhange maaso ni finyonywa ifya luko nu luko, paapo ubhwumi ubhwa mundu bhutakusubhaalila ubhwingi ubhwa chuuma chiicho umundu ali nacho.” ");
INSERT INTO ndh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Po akabhabhuula ichifwanikisho ichi akati, “Akabhaakwo umundu yumo umukabhi yuuyo akabha nu mughunda ghwake. Umundu uyo akabhyala imbeyu mu mughunda ughwo, imbeyu isho shikeela leka. ");
INSERT INTO ndh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Po akiinongʼona nu kwibhuusha mu ndumbula yaake akati, ‘Kali, imbombe kooni? Paapo indali nu bhuyo ubhunine ubhwa kusengula ifindu fyangu.’ ");
INSERT INTO ndh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Po akati, ‘Indiimbombe ulu, indiimbongolanie amaghulu ghangu amanandi amakuulu nu kusenga amanine amapya ghaagho makulu ngaani. Umwo mwo muumwo indiisengule ifindu fyangu fyoshi nu tundu twangu utunine. ");
INSERT INTO ndh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Linga naabhomba ulwo, po indiingayiibhuule indumbula yangu indiingati, “Ghwe ndumbula yangu, tesha, uli natwo utundu utwingi, utwisa, utwa kukwafwa ku fyinja ifyingi fiifyo fikwisa. Ulu po tuushanga, lyanga, ngʼwanga nu kusekela.” ’ ");
INSERT INTO ndh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Loole uChaala akamubhuula umukabhi yula akati, ‘Ghwe mulema ughwe! Umuusughu pabhushiku indiufwe! Kali, utundu twoshi tuutwo ghwasengula inditubhe twani?’ ” ");
INSERT INTO ndh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pabhumalilo uYeesu akayugha akati, “Umwo mwo muumwo indishikabheele ku mundu ghweshi yuuyo akwilundikila ubhukabhi bhwake mwene pa chiisu ichi, loole atakubhomba shiisho shibhaghiile pandaashi pa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Manye mupaashange ku sha bhwumi bhwinyu ukuti indimulyange kooni pamu indimufwalaghe kooni. ");
INSERT INTO ndh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Paapo ubhwumi bhuli nu lughindiko ukukinda ifindu, nu mubhili ghwope ghuli nu lughindiko ukukinda imyenda. ");
INSERT INTO ndh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Manyilagha ukufuma ku bhonangʼoma! Pamupeene nu kuti bhatakubhyala pamu bhatakwinula, bhatali na maghulu nu bhuyo ubhwa kusengula ifindu fyabho, poope uChaala akubhaliisha. Po kali, umwe mutali nu lughindiko ukukinda utuyuni utwo? ");
INSERT INTO ndh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kali, ghwini pakati papiinyu yuuyo abhaghiile ukwiyongelesha nalinga lishiku limo mu bhwumi bhwake ku sila iya kupaasha ku sha bhwumi? ");
INSERT INTO ndh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kali, linga mutabhaghiile ukubhomba na kandu akanandi isa ako, po kooni mukubha nu bhwogha ku mbombo inine? ");
INSERT INTO ndh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Teshanga ubhulenge ubhwa mu chiposo muumwo bhukumelela! Bhutakubhomba imbombo, soona bhutakwisonela imyenda. Loole ingubhabhuula ukuti nu malafyale uSolomooni mu bhukulumba bhwake bhwoshi atakafwalagha akiisa ungati bhulenge ubhwo! ");
INSERT INTO ndh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Linga uChaala akughafwasha amaani agha mu chiposo ghaagho ghaliipo umuusughu loole ningeelo ghakutaaghighwa mu mulilo, kali, ataaakoongeleepo ukubhafwasha umwe mwe bhandu abha lwitiko ulunandi? ");
INSERT INTO ndh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Po manye mutaamighwange ukuti, ‘Indimulyange kooni pamu indimungʼwange kooni.’ ");
INSERT INTO ndh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Paapo shooshi isho sho shiisho abhandu abha mu chiisu ichi bhaabho bhatamumeenye uChaala bhakwikaakila ukushilonda, loole uGhuuso ameenye akiisa ukuti mukushilonda shooshi isho. ");
INSERT INTO ndh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Loole umwe chilondaghe taashi ichitangalala chaake, po ni finine fyoshi ifyo indiakabhoongeleshe.” ");
INSERT INTO ndh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","UYeesu akeendelela ukuyugha akati, “Manye mwoghopaghe umwe mwe muli chibhughutila ichinandi. Paapo uChaala uGhuuso abhaghanite umwe ukuti abhalongoshange mu bhunyafyale bhwake. ");
INSERT INTO ndh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ghulisha utundu twinyu nu kubhapa abhapiina indalama. Ukubhomba ulwo kwo kuukwo kwibhiikila ichuuma mu nyambi isha kumwanya shiisho shitakukomanika, soona shitakunyaapuka naalumo. Paapo kumwanya umwifi atabhaghiile ukwibha nu luswa lwope lutabhaghiile ukuchikomania. ");
INSERT INTO ndh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Paapo kuukwo mukusengula ichuuma chiinyu, kwo kuukwo ni ndumbula shiinyu indishikabhange.” ");
INSERT INTO ndh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","UYeesu akeendelela ukuyugha akati, “Itendekeshanga akabhalilo kooshi ukubhomba imbombo iya Chaala ni nyaale shiinyu shaakaghe. ");
INSERT INTO ndh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mubhange isa abhabhombi bhaabho bhakumulindilila usongo ghwabho aghaluke ukufuma ku bhweghi ukuti linga iisa nu kwighusha pa mulyango, bhamwighulile mu kabhalilo kala kala. ");
INSERT INTO ndh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bhasayighwa abhabhombi bhaabho linga usongo ghwabho akwisa, indiakabhaaghe bhali maaso. Nalooli ingubhabhuula, indiakiitendekeshe ukubhabhombela abhabhombi abho nu kubhiikasha paase ukuti bhalye ifindu. ");
INSERT INTO ndh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bhasayighwa abhabhombi abho bhaabho nalinga usongo ghwabho akwisa akabhalilo aka pabhushiku pakati pamu linga bhukucha, indiakabhaaghe bhali maaso. ");
INSERT INTO ndh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Loole mushaaghaniange akiisa ukuti linga umwene nyumba akamanyagha akabhalilo kaako umwifi akwisila, po abhaghiile aghone maaso ukuti umwifi manye iise apongole inyumba nu kwibha utundu twake. ");
INSERT INTO ndh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Po nuumwe itendekeshanga akabhalilo kooshi paapo uMwana ughwa Mundu indiakiise mu kabhalilo kaako mutaasubhaaliile.” ");
INSERT INTO ndh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Po uPeeteli akamubhuusha uYeesu akati, “Ghwe Malafyale, kali, ichifwanikisho icho ghwayugha, ghwatubhuulagha utwe twibheene pamu ghwabhabhuulagha abhandu bhooshi?” ");
INSERT INTO ndh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","UMalafyale uYeesu akamwamula akati, “Kali, ghwini yuuyo mwimilili musubhaalilighwa soona ghwa mahala, yuuyo usongo ghwake amubhiikite ukubha mwimilili ughwa bhabhombi abhanine mu nyumba yaake ukuti abhapange ifindu ku kabhalilo kaako kakulondighwa? ");
INSERT INTO ndh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Musayighwa umubhombi uyo yuuyo linga usongo ghwake akughaluka kuukwo aachuuliile, akumwagha akubhomba shiisho akamulaghila ukuti abhombaghe. ");
INSERT INTO ndh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nalooli ingubhabhuula, usongo ghwake indiakamukweshe pa mbombo ukuti abhe mwimilili ughwa tundu twake twoshi tuutwo ali natwo. ");
INSERT INTO ndh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Loole linga umubhombi uyo iinongʼona mu ndumbula yaake akuti, ‘Usongo ghwangu indiakaabhe ukughaluka.’ Po akwanda ukubhakoma abhabhombi abhanine. Akwanda ukulya, ukungʼwa nu kughaala. ");
INSERT INTO ndh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Usongo ghwake indiakaghaluke pi ishiku na mu kabhalilo kaako umubhombi ghwake ataasubhaaliile. Bhwo usongo uyo aaghaluka, indiakamupe ulufundo ulukulu nu kumutaagha umubhombi uyo pabhuyo bhuubhwo bhali bhaabho bhatakwitika. ");
INSERT INTO ndh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Umubhombi yuuyo ashimeenye shiisho usongo ghwake akulonda loole atakwitendekesha ukushibhomba isa muumwo shikulondighwa, usongo ghwake indiakamukome leka umubhombi uyo. ");
INSERT INTO ndh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Loole umubhombi yuuyo atashimeenye shiisho usongo ghwake akulonda, linga aabhomba kabhiibhi, usongo ghwake indiakamukome kanandi. Bhubhuubhwo uChaala indiakamumelele ifyingi umundu ghweshi yuuyo akamupa ifyingi, soona indiakamumelele ifyingi ngaani umundu ghweshi yuuyo akamubhiika ukubha mwimilili ughwa fyingi ngaani.” ");
INSERT INTO ndh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","UYeesu akeendelela ukuyugha akati, “Une niisile pakukosha umulilo pa chiisu ichi. Kaali kiisa linga umulilo ughwo ghwali ghukwaka ulu! ");
INSERT INTO ndh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Loole indi ni ndamyo shiisho ingulondighwa ukushaagha, soona indineendelele ukutaamighwa ukufika paapo indamyo isho indishikashilaghe. ");
INSERT INTO ndh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kali, mukwinongʼona ukuti niisile pa chiisu ichi ku nongwa iya kubhiika ulutengaano? Nashiku! Bhwo shitali. Loole ingubhabhuula ukuti niisile ku nongwa iya kupela ubhulwane. ");
INSERT INTO ndh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ukufuma umuusughu, mu nyumba muumwo bhaliimwo abhandu bhahaano indibhayabhanikaghe. Abhandu bhatatu indibhabhange nu bhulughu na bhandu bhabhili. Bhoope abhandu bhabhili abho indibhabhange nu bhulughu na bhandu bhatatu ku nongwa yangu. ");
INSERT INTO ndh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ughwise ataaapulikanaghe nu mwana umulumyana, nu mwana ghwepe ataaapulikanaghe nu ghwise. Ungʼina ataaapulikanaghe nu mwana umulindu, ghwepe umwana umulindu uyo ataaapulikanaghe nu ngʼina. Ungʼinafyala ataaapulikanaghe nu mulaasagha, ghwepe umulaasagha ataaapulikanaghe nu ngʼinafyala.” ");
INSERT INTO ndh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","UYeesu akachibhuula soona ichilundilo icha bhandu chila akati, “Linga mwaghabhona amabhingu amatiitu ghakubhungaana kuukwo isubha likukilila, mukuyugha mukuti, ‘Ifula indiyitime umuusughu,’ nalooli yoope yikutima. ");
INSERT INTO ndh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Soona linga mwachibhona ichikungu chikukuka ukufuma kulubhafu ulwa kutulundi, mukuyugha mukuti, ‘Umuusughu indikubhe nu muufuku leka,’ nalooli ghwope ghukubhaakwo. ");
INSERT INTO ndh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwe bhongubhisania umwe! Mumeenye ukusolola isha tubhalilo ku sila iya kutesha muumwo ichiisu na kumwanya fibheeliile. Kali, po shili bhuleele mukupootwa ukushaaghania shiisho shikubhombighwa akabhalilo aka?” ");
INSERT INTO ndh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","UYeesu akachibhuusha ichilundilo icha bhandu chila akati, “Kali, kooni mutakutumula yumwemwe shiisho sha nalooli ukuti mushibhombaghe? ");
INSERT INTO ndh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Linga kubhuuka pamupeene nu mulughu ghwako ku mulongi, ikaakila ukumusuuma ukuti mupulikane bhwo mukaali muli mu sila. Linga utaabhomba ulwo, indiakabhuuke nuughwe ku mulongi. Po umulongi indiakakulonge ukuti ghwe musobhi nu kukubhiika mu tukono utwa mushikali. Umushikali uyo indiakakukole nu kukwingisha ku maka mu nyumba iya bhapinyighwa. ");
INSERT INTO ndh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nalooli ingukubhuula, utaaukafume mu nyumba iya bhapinyighwa linga ukaali ukumaliisha ukuhomba indalama iya bhumalilo.” ");
INSERT INTO ndh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mu kabhalilo kala, abhandu bhamu bhaabho bhakamupulikishanga uYeesu bhakamubhuula inongwa isha Pilaati yuuyo akalaghila ukubhaghogha aBhaghalilaayi bhamu nu kwongaania ibhanda lyabho mu fyabhupe fyabho fiifyo bhakafumyanga kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","UYeesu akabhabhuusha akati, “Kali, umwe mukwinongʼona ukuti aBhaghalilaayi abho bhaabho bhakafwa ku sila iyo bhakabha bhatulanongwa leka ukukinda aBhaghalilaayi abhanine bhooshi? ");
INSERT INTO ndh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nashiku! Loole ingubhabhuula, linga mutakupinduka nu kwilaata imbiibhi shiinyu kwa Chaala, nuumwe indimukafwe mweshi! ");
INSERT INTO ndh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pamu, kali, mukwinongʼona ukuti abhandu abhanine kalongo, bhahaano na bhatatu (18) bhala bhaabho akasonje aka mu Siloghwamu kakabhaghwila nu kubhaghogha bhakabha bhatulanongwa leka ukukinda abhandu abhanine bhooshi bhaabho bhakiikalagha mu kaaya aka Yelusaleemu? ");
INSERT INTO ndh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nashiku! Loole ingubhabhuula, linga mutakupinduka nu kwilaata imbiibhi shiinyu kwa Chaala, nuumwe indimukafwe mweshi!” ");
INSERT INTO ndh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Po uYeesu akabhabhuula abhandu bhala ichifwanikisho ichi akati, “Akabhaakwo umundu yumo yuuyo akabhyala ikokwe ilya mukuyu mu mughunda ghwake ughwa misabhibhu. Bhwo akabhalilo kaafika aka likokwe ilyo ukwela iseke, umundu yula akabhuukagha ukuti atungule iseke shimo, loole atakalwaghagha uluseke naalumo. ");
INSERT INTO ndh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Po umundu yula akamubhuula umubhombi ghwake ughwa mughunda akati, ‘Tesha! Niisagha mu mughunda ku fyinja fitatu ukuti indungule iseke ukufuma mu ikokwe ili, loole indaashaaghagha iseke naashimo! Ulu, ghukende paapo ghukumala ubhufunde ubhwa lilongwi ilya mu mughunda!’ ");
INSERT INTO ndh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Loole umubhombi yula akamwamula akati, ‘Ghwe songo, ingukusuuma ughuleke soona ku chinja chimo ukuti mu kabhalilo ako ingutekelele nu kubhiikila isaakwi. ");
INSERT INTO ndh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Linga ghwela iseke ku chinja chiicho chikwisa, indikakabhe kiisa! Loole linga ghuteela iseke, po ukaandaghile ukuti ingukende.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ishiku limo ilya Sabhati, uYeesu akamanyishanga abhandu mu sinaghoghi yimo. ");
INSERT INTO ndh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mu sinaghoghi yila, akabhaamwo umukolo yumo yuuyo akalongoshighwanga ni mbepo imbiibhi yiiyo yikamupelela ukubha mulemale ku fyinja kalongo, fihaano na fitatu (18). Umukolo uyo akaghombaana umwongoloolo. Ku nongwa iyo, akapootwanga ukwigholosha mwene. ");
INSERT INTO ndh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bhwo uYeesu aamubhona, akamwitisha ukuti abhuuke kukwake. Bhwo umukolo yula aafika, uYeesu akamubhuula akati, “Ghwe maayi, ghwapola ubhubhine bhwako!” ");
INSERT INTO ndh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","UYeesu akabhiika utukono twake pa mwongoloolo ughwa mukolo yula, nakalinga akagholoka umwongoloolo ghwake. Po akaanda ukumupaala uChaala. ");
INSERT INTO ndh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Loole usongo ughwa sinaghoghi akakalala ku nongwa iya kuti uYeesu akamuposha umukolo yula pi ishiku ilya Sabhati. Po usongo yula akabhabhuula abhandu abhingi bhaabho bhakabhaapo pala akati, “Umulungu ghumo ghuli na mashiku mahaano na limo (6) ghaagho umundu abhaghiile ukubhomba imbombo. Umundu ghweshi akwitikishighwa ukwisa nu kupola mu mashiku agho, loole atakwitikishighwa pi ishiku iya Sabhati!” ");
INSERT INTO ndh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Loole uMalafyale uYeesu akamwamula usongo yula akati, “Mwe bhongubhisania umwe! Umwe mweshi mukubhomba imbombo pi ishiku ilya Sabhati. Paapo pi ishiku ilyo mukushaabhulagha ingʼombe pamu imbunda shiinyu mu chibhagha nu kubhuuka nasho kuukwo amiishi ghali ukuti shingʼwe. ");
INSERT INTO ndh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Umukolo uyu yuuyo afumite mu chikolo icha Abhulahamu, uSeetano aamupinyite nu kumutamya ku fyinja kalongo, fihaano na fitatu. Kali, shitaamubhaghiile umwene ukwabhulighwa ukufuma mu ndamyo isho na pi ishiku ilya Sabhati?” ");
INSERT INTO ndh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bhwo uYeesu aayugha isho, isoni shikabhakola abhalughu bhaake bhooshi. Loole abhandu abhanine bhooshi bhaabho bhakabhaapo pala bhakasekela leka ku nongwa iya mbombo ingulu isha kuswighisha shiisho uYeesu akashibhombagha. ");
INSERT INTO ndh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Po uYeesu akachibhuusha ichilundilo icha bhandu akati, “Kali, ichitangalala icha Chaala chigheliile na kooni? Kali, injigheleshe na kooni? ");
INSERT INTO ndh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ichitangalala icha Chaala chili ungati kaseke akanandi ngaani aka nambamba kaako umundu akeegha nu kupesa mu mughunda ghwake. Akaseke ako kakamela, kakakula nu kubha likokwe ikulu liilyo utuyuni tukiisa nu kusenga ififumbo mu tusamba twake.” ");
INSERT INTO ndh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","UYeesu akabhuusha soona akati, “Kali, injigheleshe na kooni ichitangalala icha Chaala? ");
INSERT INTO ndh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ichitangalala icha Chaala chigheliile ni nyambo inandi yiiyo umukolo yumo akeegha nu kwongaania nu bhufu ubhwingi ubhwa kuyiilana utupombo tutatu. Pabhumalilo, inyambo inandi yila yikalulisha ubhufu bhwoshi bhula.” ");
INSERT INTO ndh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bhwo uYeesu akubhuuka ku Yelusaleemu, akeendelelagha ukubhamanyisha abhandu abha mu twaya utukulu na mu twaya utunandi tuutwo akaghendaghaamwo. ");
INSERT INTO ndh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Umundu yumo akamubhuusha uYeesu akati, “Ghwe Malafyale, kali, uChaala indiakabhapoke abhandu bhanandiishe?” ");
INSERT INTO ndh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","UYeesu akamwamula akati, “Isila iya kwingila ku chitangalala icha Chaala yili ungati mundu yuuyo akwingila pa mulyango umufinye. Ku nongwa iyo, ikaakilagha ukwingila ku mulyango umufinye ughwo. Nalooli ingubhabhuula, abhandu abhingi indibhakalondaghe ukwingila, loole indibhakapootwe. ");
INSERT INTO ndh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Akabhalilo kakwisa kaako umwene nyumba indiakapinge ichiighi. Po indimukiime kuuse nu kwanda ukwighusha nu kusuuma ukuti, ‘Ghwe malafyale, tukukusuuma utwighulile ichiighi!’ Loole umwene nyumba indiakabhaamule indiakati, ‘Indabhameenye umwe, soona indameenye kuukwo mukufuma!’ ");
INSERT INTO ndh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Po nuumwe indimukaande ukuyugha mukatingi, ‘Utumeenye leka utwe, paapo tukalyanga nu kungʼwa pamupeene nuughwe! Soona, ughwe ukatumanyishanga mu twaya twitu!’ ");
INSERT INTO ndh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Loole umwene indiakabhaamule soona akati, ‘Nalooli indabhameenye umwe, soona indameenye kuukwo mukufuma! Tiila kukwangu umwe mweshi mwe bhatulanongwa!’ ” ");
INSERT INTO ndh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Po uYeesu akeendelela ukuyugha akati, “Indimukamubhone uAbhulahamu, uIsiyaka, uYaakobhu na bhasololi bhooshi bhwo bhali mu chitangalala icha Chaala. Loole umwe indimukataaghighwe kuuse kuukwo indimukalilaghe nu kushesheetusha amiino ku nongwa iya bhubhafu ubhukali! ");
INSERT INTO ndh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Soona, abhandu abhingi bhaabho bhataa Bhayuuta indibhakiisaghe ukufuma kuukwo isubha likufumila, kuukwo likukilila, kumutu na kutulundi. Abhandu abho indibhakiikale nu kulya bhwo bhali mu chitangalala icha Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Pulikisha! Abhandu abhingi bhaabho bhataabhakaghindikighwe akabhalilo kaako kakwisa, bho bhaabho bhakughindikighwa akabhalilo aka. Soona, abhandu bhaabho bhatakughindikighwa akabhalilo aka, indibhakaghindikighwe akabhalilo kaako kakwisa.” ");
INSERT INTO ndh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mu kabhalilo kala kala, aBhafalisaayi bhamu bhakabhuuka kwa Yeesu, bhakamusoka bhakati, “Tiilaapo panu, bhuukagha pabhuyo ubhunine ku nongwa iya kuti uHelooti akulonda ukukughogha.” ");
INSERT INTO ndh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Loole uYeesu akabhaamula akati, “Bhuuka mumubhuule uHelooti yuuyo ali ungati ghwi mbila ukuti, ‘Pulikisha! Indineendelele ukushikiisha imbepo imbiibhi nu kuposha abhandu bhaabho bhabhine ku kabhalilo akapimba. Po pi ishiku ilya bhutatu, indiingamaliishe inyango yangu. ");
INSERT INTO ndh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ku sila yooshi yila, une ingulondighwa ukwendelela ukubhuuka ku Yelusaleemu umuusughu na ningeelo nu kufika ukulinda ningeelo. Ku nongwa iya kuti umusololi atakulondighwa ukufwila ubhuyo ubhunine, loole ku Yelusaleemu!’ ");
INSERT INTO ndh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mwe bhandu abha mu Yelusaleemu umwe, mwe bhandu abha mu Yelusaleemu umwe! Mukubhaghogha abhasololi nu kubhakoma na mayondo abhandu bhala bhaabho uChaala abhatumite kukwinyu. Mu tubhalilo utwingi ingalondagha ukubhabhungaania umwe isa muumwo inguku yikubhungaanikisha utwana twake mu fipapande fyake, loole mutakalondagha. ");
INSERT INTO ndh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tesha, uChaala indiakabhaleke umwe nu kuyileka inyumba yiinyu ukubha chisaami! Nalooli ingubhabhuula, mutaamukaambone soona ukufika paapo indimukayughe ukuti, ‘Asayighwange yuuyo akwisa mu ngamu iya Malafyale uChaala.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pi ishiku limo ilya Sabhati, uYeesu akabhuuka pakulya ifindu mu nyumba iya mulongoshi yumo ughwa Bhafalisaayi. Bhwo ali mu nyumba mula, abhandu bhaabho bhakabhaamwo bhakamutendeelagha leka ukuti bhateshe shiisho indiashibhombe pi ishiku ilyo. ");
INSERT INTO ndh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pandaashi pa Yeesu akabhaapo umundu yumo yuuyo akabha nu bhubhine ubhwa kwisula umubhili ghwoshi. ");
INSERT INTO ndh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Po uYeesu akabhabhuusha aBhafalisaayi na bhamanyishi abha ndaghilo isha Moose bhaabho bhakabhaapo pala akati, “Kali, indaghilo isha Moose shikwitikisha ukumuposha umubhine pi ishiku ilya Sabhati?” ");
INSERT INTO ndh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Loole abheene bhatakamwamula naalimo. Po uYeesu akamupalamaasha mundu yula, akamuposha nu kumwitikisha ukuti abhuukaghe kukaaya kaake. ");
INSERT INTO ndh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Po uYeesu akabhabhuusha akati, “Kali, ghwini pakati papiinyu yuuyo linga umwana ghwake pamu ingʼombe yaake yaaghwila mu bhwina pi ishiku ilya Sabhati atakubhuuka nakalinga nu kuyighuusa pi ishiku ilyo?” ");
INSERT INTO ndh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Loole abheene bhatakamwamula naalimo uYeesu. ");
INSERT INTO ndh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Po uYeesu akabhateshanga abhaheesha bhamu bhaabho bhakabhapaalila pa findu muumwo bhakiisalilagha bheene ifitengu ifya lughindiko. Bhwo aashibhona isho, akabhabhuula ichifwanikisho chimo akati, ");
INSERT INTO ndh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Linga umundu akupaaliile ku bhweghi, manye ghwisalilaghe ghwimwene ifitengu fiifyo abhandu abhaghindikighwa bhakwikalilagha. Manye ubhombaghe ulwo ku nongwa iya kuti lumo bhamupaaliile umundu umunine umughindikighwa ukukukinda ughwe. ");
INSERT INTO ndh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Po umundu yuuyo abhapaaliile umwe mweshi indiakiise nu kukubhuula ughwe akati, ‘Ingusuuma utiile pa chitengu ichi ghwikaliile ukuti umundu uyu iikaleepo.’ Po indiukasuuke leka ku bhandu bhooshi nu kwanda ukutiila ukubhuuka pakwikala ku chitengu icha kunyuma chiicho chitaa cha lughindiko. ");
INSERT INTO ndh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Loole linga umundu akupaaliile ku bhweghi, sala nu kwikala pa chitengu chiicho bhakwikalagha abhandu bhaabho bhataa bhaghindikighwa ukuti linga akwisa yuuyo akupaaliile, akubhuule ukuti, ‘Ghwe mumanyani ghwangu, tiilaapo panu, isagha ghwikale pabhuyo ubhu bhuubhwo bhakwikalagha abhandu bhaabho bhaghindikighwa.’ Ku sila iyo, abhandu bhooshi bhaabho bhakulya pamupeene nuughwe indibhamanye ukuti umundu yuuyo akupaaliile, aakughindika. ");
INSERT INTO ndh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Paapo umundu ghweshi yuuyo akwikwesha mwene ukubha ghwi songo, uChaala indiakamwishe, loole umundu ghweshi yuuyo akwiyiisha, uChaala indiakamukweshe.” ");
INSERT INTO ndh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Po uYeesu akamubhuula umundu yula yuuyo akamupaalila akati, “Linga kubhapaalila abhandu pakulya ifindu ifya pamuusi pamu ifya namasubha, manye ubhapaalilaghe abhamanyani bhaako, pamu abhoghwamwinyu, pamu abhakamu bhaako, pamu abhapalamani bhaako bhaabho bhakabhi. Paapo linga ghwabhomba ulwo, bhoope indibhakakupaalile kukwabho ukuti yibhe sila ya kukuhomba shila shiisho ukabhabhombela. ");
INSERT INTO ndh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Loole linga kubhapaalila abhandu pakulya ifindu, bhapaalilaghe abhapiina, abhalemale na bhafwamaaso. ");
INSERT INTO ndh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Linga ghwabhomba ulwo, po uChaala indiakusaye ku nongwa iya kuti abhandu isa abho bhatabhaghiile ukukupaalila ukuti bhakuhombe ku shila shiisho ukabhabhombela. Po uChaala ghwe yuuyo indiakakuhombe bhwo aabhashuusha abhandu bhooshi bhaabho bhakabhombagha shiisho shibhaghiile pandaashi papaake.” ");
INSERT INTO ndh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Umundu yumo mu bhala bhaabho bhakalyanga ifindu pamupeene nu Yeesu, akashipulika shooshi shiisho uYeesu akashiyughagha. Po akamubhuula uYeesu akati, “UChaala amusayite umundu ghweshi yuuyo indiakalye ifindu mu chitangalala chaake!” ");
INSERT INTO ndh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Loole uYeesu akamwamula ku sila iya kubhombela ichifwanikisho akati, “Akabhaapo umundu yumo yuuyo akatendekesha ifindu ifya pa lusekelo ulukulu. Umundu uyo akabhapaalila abhandu abhingi ukwisa ku lusekelo ulwo. ");
INSERT INTO ndh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bhwo akabhalilo aka kwanda ulusekelo kaafika, umundu yula akamutuma umubhombi ghwake pakubhabhuula abhandu bhooshi bhaabho akabhapaalila ukuti, ‘Ulu isagha ku lusekelo paapo naatendekesha kooshi akandu!’ ");
INSERT INTO ndh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Loole abhandu bhooshi bhaabho akabhapaalila, bhakaanda yumo yumo ukukaana ukuti bhatakubhuuka ku lusekelo ulwo. Umundu ughwa bhwandilo akamubhuula umubhombi yula akati, ‘Ingulite umughunda, ingulondighwa imbuuke pakughutesha. Po ingukusuuma ghuuhobhokele paapo indaaniise ku lusekelo.’ ");
INSERT INTO ndh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Umundu ughwa bhubhili akamubhuula akati, ‘Ingulite abhokambaku kalongo (10) abha kulimila, lwoshi ulu inguya pakubhaghela ukuti indeshe muumwo bhakubhombela imbombo. Po ingukusuuma ghuuhobhokele paapo indaaniise ku lusekelo.’ ");
INSERT INTO ndh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Po ghwepe umundu ughwa bhutatu akamubhuula akati, ‘Naafuma pakwegha umukolo, ku nongwa iyo, indaaniise ku lusekelo.’ ");
INSERT INTO ndh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Po umubhombi yula akaghaluka kwa songo ghwake nu kumubhuula shooshi shiisho abhandu bhala bhakamubhuula. Bhwo usongo yula aapulika ukuti abhandu bhooshi bhaabho aabhapaaliile bhatakwisa ku lusekelo, akakalala leka. Po akamulaghila umubhombi ghwake akati, ‘Bhuuka lubhilo mu musebho na mu tusila utwa mu kaaya aka ukuti linga ghwabhaagha abhapiina, abhochikwefu, abhafwamaaso na bhalemale ghwise nabho pa lusekelo panu.’ ");
INSERT INTO ndh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Umubhombi yula akabhuuka nu kubhomba isa muumwo usongo ghwake akamulaghila. Po akaghaluka nu kumubhuula usongo ghwake akati, ‘Ghwe songo, naabhomba shooshi shiisho ghuundaghiile, loole ubhuyo bhukaali bhuliimwo mu nyumba iya lusekelo.’ ");
INSERT INTO ndh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Po usongo yula akamubhuula umubhombi ghwake akati, ‘Bhuuka mu tusila na mu misebho imikulu yiiyo yili kuuse ku kaaya aka, yugha nabho ku maka abhandu bhooshi bhaabho ghwabhaagha ukuti bhiise ku lusekelo ukuti inyumba yangu yiisule abhaheesha. ");
INSERT INTO ndh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nalooli ingubhabhuula umwe, indaaingamwitikishe umundu naayumo mu bhandu bhala bhaabho naabhapaaliile kubhwandilo ukwingila mu nyumba yiiyo indendekeshiishe ifindu ifya lusekelo!’ ” ");
INSERT INTO ndh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Akabhalilo kamu ifilundilo ifikulu ifya bhandu bhakaghendagha pamupeene nu Yeesu. Bhwo bhakughenda, uYeesu akasanusha kunyuma, akabhabhuula abhandu bhala akati, ");
INSERT INTO ndh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Umundu ghweshi yuuyo akulonda ukuungonga, akulondighwa ukuungana une ukukinda muumwo amughaniile ughwise, ungʼina, umukashi, abhaana bhaake, abhakulu bhaake na bhalumbu bhaake. Soona akulondighwa ukuungana une ukukinda muumwo abhughaniile ubhwumi bhwake. ");
INSERT INTO ndh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Umundu ghweshi yuuyo atakupimba ichikobhekano chaake nu kuungonga, atabhaghiile ukubha mumanyili ghwangu. ");
INSERT INTO ndh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Linga umundu yumo pakati papiinyu akulonda ukusenga inyumba iya mutengo umukulu, kali, atakwikala paase taashi nu kwinongʼona utundu twoshi tuutwo tukulondighwa ukusengela inyumba nu kutesha linga ali ni ndalama isha kuyiilana ukumaliisha inyumba iyo? ");
INSERT INTO ndh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Paapo linga aasenga ulwalilo lwene, loole aapootwa ukumaliisha ukusenga inyumba yooshi, po umundu ghweshi yuuyo akuyibhona, akwanda ukumwobhela, ");
INSERT INTO ndh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","akuti, ‘Umundu uyu aandite ukusenga inyumba, loole apooshitwe ukumaliisha!’ ");
INSERT INTO ndh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Soona linga umalafyale yumo akulonda ukulwa ubhwite nu malafyale umunine, kali, atakwikala paase taashi nu kwinongʼona linga abhashikali bhaake abhoelufu kalongo (10,000) bhabhaghiile ukulwa ubhwite nu malafyale umunine yuuyo ali na bhashikali abhoelufu amalongo mabhili (20,000)? ");
INSERT INTO ndh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Linga aamanya ukuti abhashikali bhaake indibhapootwe, umalafyale uyo akubhatuma lubhilo abhandumi bhaake kwa malafyale umunine yula bhwo akaali ali kubhutali ukuti bhapulikane manye bheendelelaghe pakulwa ubhwite. ");
INSERT INTO ndh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bhubhuubhwo, umundu ghweshi pakati papiinyu yuuyo atakutuleka utundu twoshi tuutwo ali natwo, atabhaghiile ukubha mumanyili ghwangu.” ");
INSERT INTO ndh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","UYeesu akeendelela ukuyugha akati, “Imbeeya nyiisa leka. Loole linga imbeeya yaakomanika, kali, chiliipo chiicho chibhaghiile ukubhughalusha ubhwisa bhwake soona? ");
INSERT INTO ndh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Imbeeya isa iyo yitali ni mbombo naayimo ku ilongwi pamu ku bhufunde, loole abhandu bhakuyeegha nu kuyitaagha. Umundu ghweshi yuuyo ali ni fyufwo, apulikishange nu kushaaghania!” ");
INSERT INTO ndh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ishiku limo abhasongesha songo abhingi na bhatulanongwa bhamu bhakabhungaanagha ukuti bhamupulikishe uYeesu. ");
INSERT INTO ndh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Loole aBhafalisaayi na bhamanyishi abha ndaghilo isha Moose bhakaanda ukwibhuniisha bhakati, “Tesha, umundu uyu akubhapokeela abhatulanongwa soona akulya pamupeene nabho!” ");
INSERT INTO ndh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Po uYeesu akabhabhuula ichifwanikisho ichi akati, ");
INSERT INTO ndh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Linga umundu yumo pakati papiinyu ali na bhonangʼooshi imya yimo (100), aamanya ukuti unangʼooshi yumo mu bhonangʼooshi bhala aasobha, kali, akubhomba kooni? Kali, atakubhaleka taashi abhonangʼooshi amalongo mahaano na manna, bhahaano na bhanna (99) bhala ku lungalangala nu kubhuuka pakumulonda unangʼooshi yula yuuyo asobhite ukufika paapo akumwagha? ");
INSERT INTO ndh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Po bhwo aamwagha, akusekela leka nu kwanda ukumupimba pa fipungo ");
INSERT INTO ndh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nu kughaluka naghwe kukaaya kaake. Linga aafika pakaaya, po akubhiitisha abhamanyani na bhapalamani bhaake, akubhabhuula ukuti, ‘Sekelagha pamupeene nuune ku nongwa iya kuti naamwagha unangʼooshi ghwangu yuuyo aasobhite.’ ");
INSERT INTO ndh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ingubhabhuula umwe, bhubhuubhwo uChaala na bhandumi bhaake kumwanya kula indibhakasekele ngaani ku nongwa iya mutulanongwa yumoywene yuuyo akupinduka nu kwilaata imbiibhi shaake ukukinda abhandu amalongo mahaano na manna, bhahaano na bhanna bhaabho bhakwibhona ukuti bhagholofu nu kuti bhatakulondighwa ukwilaata imbiibhi shaabho.” ");
INSERT INTO ndh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","UYeesu akeendelela ukuyugha akati, “Pamu, linga umukolo yumo ali ni salabhasha kalongo (10), po isalabhasha yimo yaasobha, kali, akubhomba kooni? Kali, atakukosha inyaale nu kupyaghila inyumba yooshi nu kuyilonda ku maka ukufika paapo akuyaagha? ");
INSERT INTO ndh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Po linga aayaagha, akubhiitisha abhamanyani na bhapalamani bhaake, akubhabhuula ukuti, ‘Sekelagha pamupeene nuune ku nongwa iya kuti naayaagha isalabhasha yangu yiiyo yaasobhite.’ ");
INSERT INTO ndh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ingubhabhuula umwe, umwo mwo muumwo uChaala na bhandumi bhaake indibhakasekele ngaani ku nongwa iya mutulanongwa yumoywene yuuyo akupinduka nu kwilaata imbiibhi shaake.” ");
INSERT INTO ndh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","UYeesu akeendelela ukuyugha akati, “Akabhaapo umundu yumo yuuyo akabha na bhaana bhaake abhaliisha bhabhili. ");
INSERT INTO ndh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ishiku limo umwana umukeke yula akabhuuka kwa ghwise, akamubhuula akati, ‘Ghwe taata, ingusuuma ghuumbe ichuuma chiicho cha chilingo changu.’ Po ughwise akamuyabhila ghweshi umwana ichuuma chaake. ");
INSERT INTO ndh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Bhwo amashiku manandi ghaakinda, umwana umukeke yula akabhungaania utundu twake twoshi, akatiila pakaaya nu kubhuuka ku chiisu icha kubhutali. Bhwo aafika kula, akaanda ukuchibhombela mwalwe ichuuma chaake nu kumala chooshi. ");
INSERT INTO ndh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Loole bhwo aamala ichuuma chooshi chiicho akabha nacho, isala ingali yikaghwa mu chiisu chila chooshi. Po umwana yula atakabha ni ndalama naashimo pamu ifindu. ");
INSERT INTO ndh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Po akabhuuka ku mundu yumo ughwa mu chiisu chila pakusuuma imbombo. Umundu yula akabhuuka naghwe ku mughunda ghwake nu kumupa imbombo iya kuliisha ingulubhe shaake. ");
INSERT INTO ndh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ku nongwa iya kuti akabha ni sala, umulumyana yula akanyonywanga ukulya na makambi ghaagho ingulubhe shikalyanga, paapo atakabhaapo umundu naayumo ughwa kumupa ifindu. ");
INSERT INTO ndh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Pabhumalilo, akiinongʼona mu ndumbula yaake akati, ‘Tesha, abhabhombi bhooshi abha taata bhakulya nu kufileka, loole une ingufwa kuno ku nongwa iya sala! ");
INSERT INTO ndh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Po indiindiile panu nu kubhuuka kwa taata. Linga naafika, indiingamubhuule ukuti, “Ghwe taata, naamutulila inongwa uChaala, soona naakutulila inongwa nuughwe. ");
INSERT INTO ndh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Indaa mubhaghile soona ukubha mwana ghwako. Imbiike ukuti imbe ungati yumo mu bhabhombi bhaako.” ’ ");
INSERT INTO ndh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Po akatiila nu kughaluka kwa ghwise. “Bhwo umwana yula aapalamila ukufika pakaaya, ughwise akamubhona kubhutali, akamupelela ichisa. Akakinda lubhilo nu kumulamuka umwana ghwake ku sila iya kumwofwa. ");
INSERT INTO ndh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Po umwana yula akamubhuula ughwise akati, ‘Ghwe taata, naamutulila inongwa uChaala yuuyo ali kumwanya, soona naakutulila inongwa nuughwe. Indaa mubhaghile soona ukubha mwana ghwako.’ ");
INSERT INTO ndh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Loole ughwise akabhiitisha abhabhombi bhaake, akabhalaghila akati, ‘Isagha lubhilo nu muselekesha umwisa ngaani ukuti mumufwashe umwana ghwangu, soona mufwashe ni ikoosa mu kakono kaake ni filato mu tulundi. ");
INSERT INTO ndh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bhuuka mweghe ingwata yiiyo yikulite nu kuyighogha. Linga mwaghogha, mupiiye inyama ukuti tulye nu kusekelela. ");
INSERT INTO ndh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Naayugha ulwo ku nongwa iya kuti umwana ghwangu yuuyo ingiinongʼonagha ukuti afwile, loole ulu mwumi, yuuyo aasobhite, loole ulu aaghaluka!’ Po abhabhombi bhala bhakabhomba isa muumwo akabhalaghilila. Pabhumalilo, bhakaanda ukusekela. ");
INSERT INTO ndh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mu kabhalilo ako bhwo shooshi isho shikubhombighwa, umwana ghwake usongo akabha ali ku mughunda. Bhwo akughaluka ukufuma ku mughunda nu kupalamila kupiipi ni nyumba iya ghwise, akapulika abhandu bhakwimba inyimbo nu kulebhela. ");
INSERT INTO ndh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akamwitisha yumo mu bhabhombi abha ghwise. Bhwo umubhombi iisa, umwana usongo yula akamubhuusha akati, ‘Kali, kooni kaafika pakaaya apo?’ ");
INSERT INTO ndh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Umubhombi yula akamwamula akati, ‘Umunungʼuna ghwako aaghaluka kuukwo aali, nu ghuuso aalaghila ukuti yighoghighwe ingwata yila yiiyo yikulite ku nongwa iya lusekelo paapo umwana ghwake aaghaluka bhwo mwumi soona mukafuushe.’ ");
INSERT INTO ndh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Loole bhwo umwana usongo yula aapulika isho, akakalala, akakaana ukwingila mu nyumba muumwo bhakasekelagha. Po ughwise akafuma kuuse, akaanda ukumupyelesha umwana ghwake nu kumusuuma ukuti iingile mu nyumba. ");
INSERT INTO ndh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Loole umwene akamwamula ughwise akati, ‘Ghwe taata, pulikisha! Ku fyinja ifyingi naakubhombelagha imbombo shooshi pakaaya panu ungati mubhombi, soona akabhalilo kooshi naabhombagha shooshi shiisho ghwandaghilagha ukuti imbombe! Loole pamupeene na shooshi isho, utaambiile naakamu nalinga nyaana iya mbushi ukuti indye nu kusekela pamupeene na bhamanyani bhangu. ");
INSERT INTO ndh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Loole bhwo iisa umwana ghwako uyu yuuyo aachibhombiile akabhiibhi ichuuma chaako pamupeene na bhomalaya, ulaghiile ukuti yighoghighwe ingwata yiiyo yikulite!’ ");
INSERT INTO ndh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ughwise akamwamula akati, ‘Ghwe mwana ghwangu, ughwe uli nuune amashiku ghooshi nu tundu twoshi tuutwo indi natwo, nuughwe twako. ");
INSERT INTO ndh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ulu twalondighwanga ukuhobhoka nu kubhiika ulusekelo ku nongwa iya kuti umunungʼuna ghwako yuuyo ingiinongʼonagha ukuti afwile, loole ulu mwumi, yuuyo aasobhite, loole ulu aaghaluka!’ ” ");
INSERT INTO ndh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Po uYeesu akabhabhuula soona abhamanyili bhaake akati, “Akabhaakwo umukabhi yumo yuuyo akabha nu mwimilili ughwa chuuma chaake. Ishiku limo umukabhi uyo akapulika ukuti umwimilili ghwake uyo akabhombelagha akabhiibhi ichuuma chaake. ");
INSERT INTO ndh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Po umukabhi yula akamwitisha umwimilili yula. Bhwo iisa, akamubhuusha akati, ‘Kali, sha nalooli shiisho ingupulika abhandu bhakukuyugha ughwe? Indangishe imbelengelo isha muumwo ukabhiile na muumwo ubhombiile ichuuma changu, paapo utaaghwendelele ukubha mwimilili ughwa chuuma changu soona.’ ");
INSERT INTO ndh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Po umwimilili yula akiibhuusha mu ndumbula yaake akati, ‘Kali, imbombe kooni? Usongo ghwangu indiaangiishe pa mbombo yangu. Une indabhaghiile ukulima paapo amaka ghangu mapepe, soona ingufwa isoni ukubha musuumilishi. ");
INSERT INTO ndh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naamanya muumwo indiimbombe ukuti linga usongo ghwangu aangiisha pa mbombo, abhandu bhakaambokeelaghe mu nyumba shaabho.’ ");
INSERT INTO ndh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Po umwimilili yula akabhiitisha abhandu bhooshi bhaabho usongo ghwake akabhamelelagha. Bhwo bhiisa, akamubhuusha ughwa bhwandilo akati, ‘Kali, usongo ghwangu akukumelela iliita shilinga isha nyemba isha mishunguti?’ ");
INSERT INTO ndh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Akamwamula akati, ‘Usongo ghwako akuumelela amalebhe imya shibhili (200) agha mafuta agha nyemba isha mishunguti.’ Po umwimilili akamubhuula akati, ‘Eegha lubhilo ukalata uyu yuuyo fisimbiighwe fiifyo usongo ghwangu akukumelela, simba ukuti akukumelela amalebhe imya yimo (100).’ ");
INSERT INTO ndh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Umwimilili yula akamubhuusha umundu ughwa bhubhili akati, ‘Kali, nuughwe usongo ghwangu akukumelela amaghunila malinga agha ngano?’ Umwene akamwamula akati, ‘Usongo ghwako akuumelela amaghunila imya yimo (100) agha ngano.’ Umwimilili yula akamubhuula akati, ‘Eegha ukalata uyu yuuyo fisimbiighwe fiifyo usongo ghwangu akukumelela, simba ukuti akukumelela amaghunila amalongo mahaano na matatu (80).’ ");
INSERT INTO ndh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Bhwo umukabhi yula aapulika isho, akamupaala leka umwimilili ghwake ku nongwa iya bhuchefu bhwake. Umwo mwo muumwo abhandu bhaabho bhatakumwitika uChaala mu chiisu ichi bhachefu leka linga bhakubhomba imbombo shaabho ukukinda bhaabho bhakumwitika uChaala.” ");
INSERT INTO ndh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","UYeesu akeendelela ukuyugha akati, “Nalooli ingubhabhuula, bhombelagha ichuuma icha pa chiisu panu ukubhaafwa abhandu abhapootwe ukuti bhakabhe bhamanyani bhiinyu. Ku sila iyo, linga ichuuma icho chaashila, indibhakabhapokeele ku bhwikalo ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Umundu ghweshi yuuyo musubhaalilighwa ku tundu utunandi, akubha musubhaalilighwa na ku tundu utwingi. Loole umundu ghweshi yuuyo ataa musubhaalilighwa ku tundu utunandi, atakubha musubhaalilighwa na ku tundu utwingi. ");
INSERT INTO ndh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Po linga umwe mutaa bhasubhaalilighwa ukuchibhombela ichuuma icha pa chiisu panu, kali, ghwini yuuyo abhaghiile ukubhapa ichuuma icha nalooli? ");
INSERT INTO ndh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Soona linga umwe mutaa bhasubhaalilighwa ukuchibhombela ichuuma icha mundu umunine, kali, ghwini yuuyo abhaghiile ukubhapa ichuuma ichiinyu yumwemwe? ");
INSERT INTO ndh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ataliipo umubhombi yuuyo abhaghiile ukubhabhombela abhomalafyale bhabhili ku kabhalilo kamukeene. Paapo abhaghiile ukumughana umalafyale yumo nu kwifumya kukwake nu kumufuuya umunine. Mutabhaghiile ukumubhombela uChaala ni ndalama ku kabhalilo kamukeene!” ");
INSERT INTO ndh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pabhuyo bhula pakabhaapo na Bhafalisaayi bhamu. Abheene bhakashighana leka indalama. Po bhwo bhaapulika uYeesu akuyugha isho, bhakamusekela ku lufuuyo. ");
INSERT INTO ndh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Po uYeesu akabhabhuula akati, “Umwe mukwibhiika ukubha bhandu bhaabho bhakubhomba shiisho shibhaghiile pandaashi pa bhandu, loole uChaala ameenye shiisho shiliimwo mu ndumbula shiinyu. Paapo utundu tula tuutwo abhandu bhakutughindika ngaani, uChaala akutubhona utundu utwo ukubha mikooko.” ");
INSERT INTO ndh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","UYeesu akeendelela ukuyugha akati, “Indaghilo isha Moose na Masimbo aMeelu agha bhasololi fikabhalongoshanga abhandu ukufika mu kabhalilo kaako uYoohani uMwoshi akiisagha pakulumbilila ishu ilya Chaala. Ukwandila mu kabhalilo ako, iNongwa iNyiisa isha chitangalala icha Chaala shikulumbililighwa. Po ghweshi umundu akwingila ku maka mu chitangalala icho. ");
INSERT INTO ndh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Loole kupepe ngaani kumwanya ni chiisu ukutiila ukukinda isimbo limo ukutiila mu ndaghilo isha Chaala. ");
INSERT INTO ndh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Umundu ghweshi yuuyo akumusoosha umukashi nu kwegha umukolo umunine, akushipana. Soona, umundu ghweshi yuuyo akumwegha umukolo yuuyo asookite, akushipana.” ");
INSERT INTO ndh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","UYeesu akeendelela ukuyugha akati, “Akabhaakwo umundu yumo umukabhi. Umundu uyo akafwalagha imyenda iya mandongomela iya mutengo ni myenda iminine imyisa iya mutengo umukulu. Soona akabhiikagha ulusekelo mu nyumba yaake lyoshi ishiku nu kupiiya ifindu ifya mutengo umukulu. ");
INSERT INTO ndh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pa mulyango umukulu ughwa nyumba yaake pakabhaapo umundu yumo yuuyo ingamu yaake akabha ghwi Laasalo. ULaasalo akabha mupiina leka, soona akabha ni filonda umubhili ghwoshi. ");
INSERT INTO ndh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ku nongwa iya bhupiina, uLaasalo akanyonyangwa ukulya utubhululusha utwa findu tuutwo tukaghwanga paase ukufuma pa meesa yiiyo umukabhi yula akalilaghaapo. Soona na bhokabhwa bhakabhuukagha kwa Laasalo nu kumumyanda ifilonda fyake. ");
INSERT INTO ndh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ishiku limo uLaasalo akafwa. Bhwo aafwa, abhandumi abha Chaala bhakamwegha, bhakabhuuka naghwe nu kumubhiika mu tukono utwa Abhulahamu. Po umundu umukabhi yula ghwepe akafwa. Bhwo aafwa, abhandu bhakabhuuka pakumushiila. ");
INSERT INTO ndh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Po umukabhi yula akafika ku bhushuuka, akaanda ukutaamighwa leka. Bhwo ali pakutaamighwa, akatesha nu kumubhona uAbhulahamu pabhutali, soona akamubhona nu Laasalo ali papiipi nu Abhulahamu. ");
INSERT INTO ndh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Po umukabhi yula akiitisha ku ishu ilya pamwanya akati, ‘Ghwe taata Abhulahamu, ingukusuuma ghuumbelele ichisa, soona ingukusuuma umutume uLaasalo ukuti ayubhike akaana aka kakono kaake mu miishi, iise aposhe ululimi lwangu ku nongwa iya kuti indi pakutaamighwa leka mu mulilo ughu.’ ");
INSERT INTO ndh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Loole uAbhulahamu akamwamula akati, ‘Ghwe mwana ghwangu, kumbuka ukuti akabhalilo kaako ukabha pa chiisu, ukatwaghagha utundu twoshi utwisa tuutwo ukatulondagha, loole uLaasalo akatwaghagha utubhiibhi. Loole ku kabhalilo aka, uLaasalo ali pa lusekelo ulukulu, nuughwe uli pa ndamyo ingulu. ");
INSERT INTO ndh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pamupeene ni isho, pakati papiitu nuumwe yibhiikiighwe imbanga ingulu yiiyo ndali leka ukuti abhandu bhaabho bhakulonda ukulobhoka ukufuma kukwitu nu kwisa kukwinyu, bhapootwange. Soona ukuti abhandu bhaabho bhakulonda ukulobhoka ukufuma kukwinyu nu kwisa kukwitu, bhapootwange.’ ");
INSERT INTO ndh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Umundu yula yuuyo akabha mukabhi akamusuuma uAbhulahamu akati, ‘Ghwe taata, linga bhwo shili, po ingukusuuma umutume uLaasalo abhuuke kukaaya kwa taata, ");
INSERT INTO ndh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","paapo indi nabho abhoghwamwitu bhahaano. Linga aabhaagha, abhasoke, bhashileke imbiibhi shaabho ukuti bhoope manye bhakiise pabhuyo ubhwa ndamyo ingulu ubhu.’ ");
INSERT INTO ndh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Loole uAbhulahamu akamwamula akati, ‘Nashiku, indabhaghiile ukubhomba ulwo paapo abhoghwamwinyu bhaghapulikite amashu ghaagho ghasimbiighwe mu bhokalata abha Moose na bha bhasololi abha Chaala. Po bhashikongaghe shiisho shisimbiighwe mu bhokalata abho.’ ");
INSERT INTO ndh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Umundu yula akayugha soona akati, ‘Nashiku taata Abhulahamu! Loole linga umundu aafuma ku bhafwe, aabhuuka pakubhasoka, po indibhapinduke nu kwilaata nu kushileka imbiibhi shaabho.’ ");
INSERT INTO ndh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","UAbhulahamu akamwamula akati, ‘Linga bhatakushiitika shiisho shisimbiighwe mu bhokalata abha Moose na bha bhasololi abha Chaala, nalinga umundu ashuuke, abhuuke pakubhasoka, poope bhatabhaghiile ukwilaata imbiibhi shaabho.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Ingelo shiisho shikubhapelela abhandu ukubhomba imbiibhi shiliipo amashiku ghooshi, loole lwake umundu yuuyo akushipela ingelo isho! ");
INSERT INTO ndh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kaali kiisa ku mundu uyo ukumupinyiilila ulwala ulukulu mu shingo nu kumutaagha mu chishibha ichitali icha mu nyanja ukukinda ukumusofya yumo mu bhakeke abha bhaabho bhakuunyiitika une ukuti abhombe imbiibhi. ");
INSERT INTO ndh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Po mubhange maaso. Linga umwitiki umunyiinyu aakutulila inongwa, musoke. Linga akusuuma ukuti umuhobhokele, muhobhokele. ");
INSERT INTO ndh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nalinga aakutulila inongwa kahaano na kabhili (7) ku ishiku limo, linga akwisa kukwako kahaano na kabhili ku ishiku akuti, ‘Ingukusuuma ghuuhobhokele,’ nuughwe endelelagha ukumuhobhokela!” ");
INSERT INTO ndh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Po abhatumighwa bhakamubhuula uMalafyale uYeesu bhakati, “Ghwe Malafyale, tukukusuuma utwongeleshe ulwitiko!” ");
INSERT INTO ndh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","UMalafyale akabhaamula akati, “Linga mwali nu lwitiko ulunandi isa akabheyu aka nambamba, po ngali mwalibhuula ikokwe ilya mukuyu ughu ukuti, ‘Ipuka, bhuuka ghwibhyale mu nyanja!’ Lyope ngali lyabhapulika.” ");
INSERT INTO ndh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","UYeesu akeendelela ukuyugha akati, “Linga umundu yumo pakati papiinyu ali nu mubhombi yuuyo akulima umughunda pamu akuliisha abhonangʼooshi, kali, linga umubhombi uyo aaghaluka ukufuma ku mbombo yaake, umundu uyo abhaghiile ukumubhuula ukuti, ‘Ghwe mubhombi ghwangu, isagha lubhilo, ikala panu, ulye ifindu’? ");
INSERT INTO ndh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nashiku, atabhaghiile ukuyugha isa ulwo! Loole abhaghiile ukuyugha ukuti, ‘Ghwe mubhombi ghwangu, tendekesha ifindu indye, soona itendekeshanga ukuumbombela ukufika paapo indiimale pakulya nu kungʼwa. Linga naamala, po nuughwe indighwande pakulya nu kungʼwa.’ ");
INSERT INTO ndh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Linga umubhombi aabhomba shooshi isho, kali, usongo ghwake abhaghiile amupaalishe ukuti, ‘Ghwe mubhombi ghwangu, ingupaalisha paapo ghwabhomba imbombo shooshi shiisho ingulaghiile ukuti ubhombe’? Nashiku! ");
INSERT INTO ndh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ishi bhwo shibhange na kukwinyu, linga mwamala ukubhomba shooshi shiisho uChaala abhalaghiile, po muyughaghe mutingi, ‘Utwe twe bhabhombiishe abhashita kubhaghila, twabhomba sheene shila shiisho twalondighwanga ukushibhomba.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","UYeesu akachuulagha ukubhuuka mu kaaya aka Yelusaleemu. Bhwo akuchuula, akaghendela mu mupaka ughwa chiisu icha Samaliiya ni cha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bhwo akwingila mu kaaya akanandi kamu, akakomaana na bhandu kalongo bhaabho bhakabha ni mbungo iya makete. Abhandu bhala bhakiima pabhutali nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Po bhakamwitisha ku ishu ilya pamwanya bhakati, “Ghwe Yeesu, ghwe Malafyale, tukusuuma utupelele ichisa!” ");
INSERT INTO ndh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bhwo uYeesu aabhabhona abhabhine bhala, akabhabhuula akati, “Bhuuka mwilangishe ku bhapuuti.” Bhwo bhali mu sila bhakubhuuka, bhakapola imbungo yaabho. ");
INSERT INTO ndh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Po umundu yumo pakati papaabho yuuyo akafumagha mu chiisu icha Samaliiya bhwo iibhona ukuti aapola, akaghaluka lubhilo kwa Yeesu bhwo akumupaala uChaala ku ishu ilya pamwanya. ");
INSERT INTO ndh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bhwo aafika, akafughamila pa tulundi utwa Yeesu bhwo akumupaalisha. ");
INSERT INTO ndh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Po uYeesu akabhuusha akati, “Kali, indabhaposhiishe abhandu kalongo? Kali, abhanine bhahaano na bhanna (9) bhala bhali kuughu? ");
INSERT INTO ndh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kali, ataliipo naayumo yuuyo aaghaluka pakumupaalisha uChaala, loole umuheesha uyu mwene?” ");
INSERT INTO ndh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Po uYeesu akamubhuula umundu yula akati, “Iima, bhuukagha, uChaala aakuposha ku nongwa iya kwitika kwako.” ");
INSERT INTO ndh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ishiku limo aBhafalisaayi bhakamubhuusha uYeesu bhakati, “Kali, ichitangalala icha Chaala indichikiise liighi?” UYeesu akabhaamula akati, “Ichitangalala icha Chaala chitakwisa ku sila iya kutesha ifilangisho fimo. ");
INSERT INTO ndh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Soona ataliipo umundu yuuyo indiakayughe ukuti, ‘Tesha! Ichitangalala icha Chaala chili panu!’ pamu, ‘Chili kula!’ Paapo ubhwanalooli bhwa kuti ichitangalala icha Chaala chili pakati papiinyu.” ");
INSERT INTO ndh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Amashiku indighakiise ghaagho indimukanyonywange ukulibhona nalinga lishiku limo ilya kwisa soona ukwa Mwana ughwa Mundu, loole mutaamukalibhone. ");
INSERT INTO ndh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Abhandu indibhakabhabhuulaghe bhakatingi, ‘Tesha, uMesiiya yula pala!’ pamu, ‘Uyu panu!’ Loole umwe manye mukabhiitikaghe pamu ukubhakonga. ");
INSERT INTO ndh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Paapo ukwisa ukwa Mwana ughwa Mundu indikukabhe kwa kunyomosha isa muumwo akalabhi kakumwekukila kumwanya ukufuma kulubhafu lumo ukufika kulubhafu ulunine. ");
INSERT INTO ndh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Loole bhwo isho shikaali ukubhoneka, abhandu abha kabhalilo aka indibhakamukaane nu kumufulasha ku sila inyingi uMwana ughwa Mundu. ");
INSERT INTO ndh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Isa muumwo shikabheela ku mashiku agha Nooghwa, mwo muumwo indishikabhe ku mashiku agha kwisa soona ukwa Mwana ughwa Mundu. ");
INSERT INTO ndh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mu mashiku agha Nooghwa ghala, abhandu bhakalyanga nu kungʼwa, bhakeeghagha nu kweghighwa ukufika ishiku lila liilyo uNooghwa akiingila mu ngalabha. Po ifula imbiibhi yikatima, amiishi ghakiisula ichiisu chooshi nu kubhaghogha abhandu bhooshi bhaabho bhakabha kuuse ku ngalabha. ");
INSERT INTO ndh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Soona indishikabhe isa muumwo shikabheela mu kabhalilo aka Looti yuuyo akiikalagha mu kaaya aka Sondoma. Mu kabhalilo ako, abhandu bhakalyanga nu kungʼwa, bhakaghulagha nu kughulisha, bhakabhyalagha nu kusenga. ");
INSERT INTO ndh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Loole pi ishiku lila lila liilyo uLooti akatiilagha mu kaaya aka Sondoma, uChaala akapela umulilo umukali ghuughwo ghukiilomuka ungati fula ukufuma kumwanya nu kubhaghogha abhandu bhooshi mu kaaya kala. ");
INSERT INTO ndh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Umwo mwo muumwo indishikabheele na pi ishiku lila bhwo uMwana ughwa Mundu akwisa soona pa chiisu panu. ");
INSERT INTO ndh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pi ishiku ilyo, umundu ghweshi yuuyo indiakabhe akwelite pa kasale pa nyumba, manye akiikaghe ukuti eeghe utundu twake tuutwo tuli mu nyumba. Bhubhuubhwo, umundu ghweshi yuuyo indiakabhe ku mughunda, manye akaghalukaghe kunyuma ukuti eeghe kamu. ");
INSERT INTO ndh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Manyilagha ku shiisho shikamwagha umukashi ughwa Looti bhwo aashifuuya shiisho uChaala akalaghila. ");
INSERT INTO ndh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Umundu ghweshi yuuyo akulonda ukubhupoka ubhwumi bhwake mwene, indiabhupyute. Loole umundu yuuyo akubhufumya ubhwumi bhwake ku nongwa yangu, uyo ghwe yuuyo indiabhupoke. ");
INSERT INTO ndh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nalooli ingubhabhuula, mu kabhalilo ako, abhandu bhabhili indibhakabhe bhaghonite pa chitala chimocheene, uChaala indiakamweghe lubhilo yumo nu kumuleka umunine. ");
INSERT INTO ndh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Abhakolo bhabhili indibhakashange pamupeene pa lwala, uChaala indiakamweghe lubhilo yumo nu kumuleka umunine.  ");
INSERT INTO ndh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Abhandu bhabhili indibhakabhombaghe imbombo pamupeene mu mughunda, uChaala indiakamweghe lubhilo yumo nu kumuleka umunine.” ");
INSERT INTO ndh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bhwo uYeesu aayugha isho, abhamanyili bhaake bhakamubhuusha bhakati, “Ghwe Malafyale, kali, isho shiisho ghwayugha indishikabhombighwe kuughu?” UYeesu akabhaamula mu chiili akati, “Pabhuyo paapo pali nu mubhili umufwe, po paapo abhonangʼoma bhakubhungaanagha pamupeene.” ");
INSERT INTO ndh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Po uYeesu akabhamanyisha abhamanyili bhaake ku sila iya chifwanikisho ukulangisha ukuti bhakulondighwa bhamwipuutaghe uChaala amashiku ghooshi chishita kulita. ");
INSERT INTO ndh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akabhabhuula akati, “Akabhaakwo umulongi yumo mu kaaya kamu. Umulongi uyo atakamughindikagha uChaala, soona atakasaaghilaghaakwo isha kubhaafwa abhanine. ");
INSERT INTO ndh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mu kaaya kala kala, akabhaamwo nu mukolo yumo umufwile. Umukolo uyo akabhuukagha ku mulongi mu tubhalilo utwingi nu kumusuuma akatingi, ‘Ingukusuuma ghuunyaafwe ukutumula mu bhwanalooli inongwa yiiyo tukulongana nu mulughu ghwangu.’ ");
INSERT INTO ndh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Amashiku amingi ghakakinda bhwo umulongi yula akukaana ukumwafwa umukolo umufwile yula. Pabhumalilo, umulongi yula akiiyughaania mwene mu ndumbula yaake akati, ‘Pamupeene nu kuti une indakumughindika uChaala, soona indakusaaghilaakwo isha kubhaafwa abhandu abhanine, ");
INSERT INTO ndh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","loole ku nongwa iya kuti umukolo umufwile uyu akuundamyanga leka, indiindonge inongwa yaake ukuti manye eendelelaghe ukuundamya soona.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Po uMalafyale uYeesu akabhabhuula abhamanyili bhaake akati, “Inongʼona akiisa muumwo umulongi umubhiibhi yula aayughiile! ");
INSERT INTO ndh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kali, uChaala atabhaghiile ukubhaafwa abhasalighwa bhaake bhaabho bhakumwipuuta pamuusi na pabhushiku? Kali, abhaghiile ukukaabha ukubhaafwa? ");
INSERT INTO ndh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nalooli ingubhabhuula, uChaala indiakabhabhombele lubhilo abhandu bhaake mu bhwanalooli. Linga uMwana ughwa Mundu akuya kughaluka, kali, indiakabhaaghe abhandu bhaabho bhakumwitika pa chiisu ichi?” ");
INSERT INTO ndh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Po uYeesu akabhabhuula ichifwanikisho bhoope abhandu bhaabho bhakiibhonagha ukuti bhakubhomba shiisho shibhaghiile pandaashi pa Chaala nu kubhafuuya abhanine akati, ");
INSERT INTO ndh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Abhandu bhamu bhabhili bhakabhuuka pakwipuuta mu Nyumba iya Chaala. Mu bhandu abho, yumo akabha Mufalisaayi, umunine akabha musongesha songo. ");
INSERT INTO ndh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bhwo uMufalisaayi yula iingila mu lupaso ulwa Nyumba iya Chaala, akiima, akiipuuta mu ndumbula yaake akati, ‘Ghwe Chaala, ingukupaalisha ku nongwa iya kuti une indaa isa abhandu abhanine bhaabho bhakupoka ifya bhandu, abhabhomba mbiibhi, abhashipani pamu isa umusongesha songo uyu. ");
INSERT INTO ndh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Une ingwiyiimagha ukulya ifindu kabhili ku mulungu ghumo. Soona ingukufumikishanga ilongo ukufuma mu tundu twoshi tuutwo ingukabha.’ ");
INSERT INTO ndh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Loole umusongesha songo yula akiima pabhutali chishita kutesha kumwanya, akafulamila icheeni chaake paase ukulangisha ubhuswimaane, akiipuuta kwa Chaala akati, ‘Ghwe Chaala, ingukusuuma ghuumbelele ichisa, une nee mutulanongwa.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Po uYeesu akayugha akati, “Nalooli ingubhabhuula, umusongesha songo yula akaghaluka kukaaya kaake bhwo uChaala amuhobhokiile imbiibhi shaake shooshi ukumukinda uMufalisaayi yula. Paapo umundu ghweshi yuuyo akwikwesha mwene ukubha ghwi songo, uChaala indiakamwishe paase. Loole umundu ghweshi yuuyo akwiyiisha, uChaala indiakamukweshe ukubha ghwi songo.” ");
INSERT INTO ndh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ishiku limo abhandu bhamu bhakabhuuka na bhaana abhakeke kwa Yeesu ukuti abheegheleshe nu kubhasaya. Bhwo abhamanyili abha Yeesu bhaabhabhona abhandu abho, bhakabhakemela ukuti manye bhabhuukaghe na bhaana abhakeke kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Loole uYeesu akabhiitisha abhaana ukuti bhabhuuke kukwake, akati, “Bhaleke abhaana abhakeke bhiisaghe kukwangu, manye mubhakaanishange, paapo ichitangalala icha Chaala cha bhandu bhaabho bhali ungati bhaana abha. ");
INSERT INTO ndh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nalooli ingubhabhuula, umundu ghweshi yuuyo atakuchipokeela ichitangalala icha Chaala ungati mwana umukeke uyu, ataaakiingile shiku mu chitangalala icho.” ");
INSERT INTO ndh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Umulongoshi yumo ughwa Bhayuuta akamubhuusha uYeesu akati, “Ghwe Mumanyishi umwisa, kali, imbombe kooni ukuti imbwaghe ubhwumi ubhwa bhwila na bhwila?” ");
INSERT INTO ndh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","UYeesu akamwamula akati, “Kali, kooni kuunjugha une ukubha mwisa? Ataliipo umundu naayumo yuuyo mwisa, loole uChaala mwene. ");
INSERT INTO ndh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ughwe ushimeenye indaghilo shiisho shikuti, ‘Manye ushipanaghe, manye ughoghaghe, manye ghwibhaghe, manye ubhange mukeeti ughwa bhumyashi nu kuti umughindikaghe ughuuso nu nyoko.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Umundu yula akamwamula uYeesu akati, “Indaghilo shooshi isho ishikongite ukufuma mu bhukeke bhwangu.” ");
INSERT INTO ndh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bhwo uYeesu aapulika isho, akamubhuula akati, “Kashaalite akandu kamukeene kukwako. Bhuuka ughulishe utundu twoshi tuutwo uli natwo, indalama shiisho ghwashaagha, ubhayabhile abhapiina. Linga ghwabhomba ulwo, indiukabhe ghwibhiikila ichuuma kumwanya, po isagha ghuungongaghe.” ");
INSERT INTO ndh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Loole bhwo umundu yula aapulika isho, akaswimaana leka paapo akabha mukabhi leka. ");
INSERT INTO ndh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Bhwo uYeesu aamubhona ukuti aaswimaana ulwo, akayugha akati, “Kapala leka abhakabhi ukwingila mu chitangalala icha Chaala! ");
INSERT INTO ndh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kupepe ingamila ukufumisania pa kaashi aka sindaano ukukinda umukabhi ukwingila mu chitangalala icha Chaala!” ");
INSERT INTO ndh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bhwo abhandu bhaabho bhakabhaapo pala bhaapulika amashu agha Yeesu, bhakaswigha leka, bhakayugha bhakati, “Po linga bhwo shili, kali, ghwini yuuyo abhaghiile ukupokighwa?” ");
INSERT INTO ndh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","UYeesu akabhaamula akati, “Shiisho abhandu bhakupootwa ukushibhomba ku maka ghaabho, uChaala akushibhomba.” ");
INSERT INTO ndh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Po uPeeteli akamubhuusha uYeesu akati, “Kali, ishi shili bhuleele kukwitu? Paapo utwe tufilekite fyoshi fiifyo twali nafyo nu kukukonga ughwe!” ");
INSERT INTO ndh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","UYeesu akabhaamula akati, “Nalooli ingubhabhuula, umundu ghweshi yuuyo ayilekite inyumba yaake, umukashi, abhoghwamwabho, abhapaapi pamu abhaana ku nongwa iya chitangalala icha Chaala, ");
INSERT INTO ndh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","indiapokeele utundu imya yimo (100) mu tundu twoshi mu kabhalilo aka, soona akabhalilo kaako kakwisa, indiakapokeele ubhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Po uYeesu akabheegha abhamanyili bhaake kalongo na bhabhili (12) bhala, akabhuuka nabho pabhushiifu, akabhabhuula akati, “Tesha, ulu tukukwela ukubhuuka ku Yelusaleemu. Bhwo tuli ukwo, shooshi shiisho abhasololi abha Chaala bhakasimba ukumuyugha uMwana ughwa Mundu, shikuya pakubhombighwa. ");
INSERT INTO ndh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Paapo indibhakamubhiike mu tukono utwa bhandu bhaabho bhataa Bhayuuta, bhoope indibhakamwangalile, indibhakamutuke nu kumufwilila amati. ");
INSERT INTO ndh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Soona indibhakamukome ni fikoti nu kumughogha, loole pi ishiku ilya bhutatu, indiakashuuke.” ");
INSERT INTO ndh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Loole abhamanyili bhaake bhatakashaaghania shiisho akabhabhuulagha ku nongwa iya kuti shikafifighwa kukwabho. Po bhatakashaaghania shiisho uYeesu akayughagha. ");
INSERT INTO ndh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bhwo uYeesu ni chilundilo icha bhandu bhaabho bhakamukongagha bhaapalamila ukufika mu kaaya aka Yeeliko, umufwamaaso yumo akiikala kulubhafu ku sila, akasuumilishanga ku bhandu ukuti bhamwafwe. ");
INSERT INTO ndh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bhwo umufwamaaso yula aapulika umuywegho ughwa chilundilo icha bhandu bhaabho bhakaghendagha kupiipi, akabhuusha akati, “Kali, kuli na kooni ukwo ingupulika umuywegho ughwa bhandu?” ");
INSERT INTO ndh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bhakamwamula bhakati, “Ghwi Yeesu ughwa kufuma mu kaaya aka Naasaleeti akughenda.” ");
INSERT INTO ndh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Po umufwamaaso yula akayugha ku ishu ilya pamwanya akati, “Ghwe Yeesu, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, ingukusuuma ghuumbelele ichisa!” ");
INSERT INTO ndh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abhandu bhaabho bhakatangila mundaashi mwa Yeesu bhakamukemela umufwamaaso yula ukuti asumbe. Loole umwene akoongela ukuyugha ku ishu ilya pamwanya akati, “Ghwe Yeesu, ghwe ufumite mu chikolo icha malafyale uNdaabhiti, ingukusuuma ghuumbelele ichisa!” ");
INSERT INTO ndh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bhwo uYeesu aamupulika umufwamaaso yula akumwitisha, akiima, akabhalaghila abhandu bhamu ukuti bhamweghe nu kubhuuka naghwe kukwake. Bhwo bhaapalamila nu mufwamaaso yula, uYeesu akamubhuusha akati, ");
INSERT INTO ndh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ghwe mundu ughwe, kali, kulonda ingubhombele kooni?” Umufwamaaso yula akamwamula uYeesu akati, “Ghwe Malafyale, ingukusuuma ghuumboshe amaaso ghangu ukuti indeshange.” ");
INSERT INTO ndh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","UYeesu akamubhuula akati, “Aanda ukutesha! Ghwapola ku nongwa iya kwitika kwako.” ");
INSERT INTO ndh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nakalinga, umufwamaaso yula akaanda ukutesha. Po akaanda ukumukonga uYeesu bhwo akumupaala uChaala. Bhwo abhandu bhooshi bhaashibhona isho, bhoope bhakamupaala uChaala. ");
INSERT INTO ndh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Po uYeesu akiingila mu kaaya aka Yeeliko, akaghendela mu sila isha kaaya ako bhwo akubhuuka ku Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mu kaaya ako, akiikalaghaamwo umundu yumo yuuyo ingamu yaake akabha ghwi Sakaayi. USakaayi akabha ghwi songo ughwa bhasongesha songo, soona akabha mukabhi. ");
INSERT INTO ndh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","USakaayi akalondagha ukumutesha uYeesu ukuti ali bhuleele, loole akapootwanga ukumubhona ku nongwa iya kuti akabha mupimba, soona ichilundilo ichikulu icha bhandu chikamushunguulila uYeesu. ");
INSERT INTO ndh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Po akakinda lubhilo mundaashi mu chilundilo icha bhandu chila, akakwela mu ikokwe ilya mukuyu ukuti amubhone uYeesu bhwo akughenda pabhuyo bhula. ");
INSERT INTO ndh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bhwo uYeesu aafika pi ikokwe lila, akatesha kumwanya ku ikokwe, akamubhona uSakaayi, akamubhuula akati, “Ghwe Sakaayi, iika lubhilo mu ikokwe! Paapo ingulonda ukwingila nu kwikala mu nyumba yaako umuusughu.” ");
INSERT INTO ndh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","USakaayi akiika lubhilo mu ikokwe lila, akabhuuka nu Yeesu kukaaya kaake, akamupokeela ku lusekelo. ");
INSERT INTO ndh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Loole bhwo abhandu bhooshi bhaabho bhakabhaapo pala bhaamubhona uYeesu akwingila mu nyumba iya Sakaayi, bhakaanda ukwibhuniisha bhakati, “Tesha, uYeesu aabhuuka nu kwingila mu nyumba iya mundu yuuyo mutulanongwa!” ");
INSERT INTO ndh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Po uSakaayi akiima, akamubhuula uMalafyale uYeesu akati, “Ghwe Malafyale! Pulikisha, indiinjabhanie utundu twangu mu fibhughutila fibhili ukuti imbape abhapiina ichibhughutila chimo, soona linga neeghite akandu kamu ku mundu ghweshi yula ku sila iya kumushimbula, indiimughalushikishe kanna.” ");
INSERT INTO ndh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","UYeesu akamubhuula akati, “Umuusughu, ubhupoki bhwisa mu nyumba yaake ku nongwa iya kuti ghwepe afumite mu chikolo icha Abhulahamu. ");
INSERT INTO ndh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Paapo uMwana ughwa Mundu iisile pakubhalonda abhandu bhooshi bhaabho bhatulanongwa nu kubhapoka.” ");
INSERT INTO ndh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bhwo abhandu bhakaali bhakupulikisha isho, uYeesu akeendelela ukubhabhuula ichifwanikisho ku nongwa iya kuti akabha aapalamila ukufika ku Yelusaleemu, soona ku nongwa iya kuti abhandu bhakiinongʼonagha ukuti ichitangalala icha Chaala chikayanga pakwisa mu kabhalilo akapimba kaako kakiisagha. ");
INSERT INTO ndh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Po uYeesu akabhabhuula ichifwanikisho akati, “Akabhaapo umundu yumo yuuyo akafumagha mu chikolo icha bhunyafyale. Umundu uyo akachuula nu kubhuuka ku chiisu icha kubhutali ukuti apokeele amaka agha kubha ghwi malafyale nu kughaluka pakulongosha ichiisu chaake. ");
INSERT INTO ndh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bhwo akaali ukunyatuka, akabhiitisha abhabhombi bhaake kalongo (10) mu bhabhombi bhaake. Bhwo bhiisa, umundu yula akamupa ghweshi umubhombi indalama, akabhabhuula akati, ‘Eegha indalama ishi nu kushibhombela imbombo ku sila iya bhuchulushi ukuti shipaapaghe ukufika paapo indiingaghalukaghe.’ Po umundu yula akachuula. ");
INSERT INTO ndh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Loole abhandu bhamu abha kufuma mu chiisu chaake bhakamukalalilagha umundu yula. Po bhakabhatuma abhanine ku chiisu icha kubhutali chila pakuyugha ukuti, ‘Tutakumulonda umundu uyu ukuti abhe ghwi malafyale ghwitu!’ ");
INSERT INTO ndh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pamupeene nu kuti bhakayugha ulwo, poope akapokeela amaka agha kubha ghwi malafyale. Po umundu yula akaghaluka, akabhiitisha abhabhombi bhaake bhala bhaabho akabhapa indalama ukuti amanye muumwo ghweshi umubhombi akabhiile. ");
INSERT INTO ndh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Po umubhombi ughwa kwanda akiisa nu kumubhuula usongo ghwake akati, ‘Ghwe songo, ukukongana ni ndalama shiisho ukaamba, naashibhombela imbombo ku bhuchulushi, naakabha indalama inine imbya kalongo (10).’ ");
INSERT INTO ndh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Usongo ghwake yula akamubhuula akati, ‘Ghwabhomba akiisa leka, ughwe ghwe mubhombi umwisa. Paapo ghwali musubhaalilighwa ku tundu utunandi tuutwo ingakupa, ulu ingukupa amaka agha kulongosha utwaya kalongo.’ ");
INSERT INTO ndh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Umubhombi ughwa bhubhili akiisa nu kumubhuula usongo ghwake akati, ‘Ghwe songo, ukukongana ni ndalama shiisho ukaamba, naashibhombela imbombo ku bhuchulushi, naakabha indalama inine imbya ihaano.’ ");
INSERT INTO ndh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Usongo ghwake yula akamubhuula ghwepe akati, ‘Nuughwe ghwabhomba akiisa leka, ulu ingukupa amaka agha kulongosha utwaya tuhaano.’ ");
INSERT INTO ndh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Po umubhombi umunine akiisa nu kumubhuula usongo ghwake akati, ‘Ghwe songo, tesha, indalama shaako shiisho ukaamba, eegha ishi panu. Ingashisengula indalama ishi ku sila iya kushipinya ku chenda ukuti manye shisobhe. ");
INSERT INTO ndh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ingabhomba ulwo ku nongwa iya kuti ingakwoghopagha paapo ughwe ghwe mundu yuuyo utali ni chisa. Kwegha fiifyo fitaa fyako, soona isa muumwo umundu akwinula fiifyo ataalimite, bhubhuubhwo, nuughwe kukabha utundu tuutwo umundu umunine aabhomba.’ ");
INSERT INTO ndh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Usongo ghwake akamubhuula akati, ‘Ghwe mubhombi umubhiibhi ughwe! Indiingulonge ku mashu ghaako ghaagho ghwayugha. Linga ghwameenye ukuti une nee mundu nee indali ni chisa, ingwegha utundu tuutwo tutaa twangu, soona ingukabha utundu tuutwo umundu umunine abhombite, ");
INSERT INTO ndh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kali, kooni utakaambiikilagha indalama isho ku bhachulushi ukuti bhwo ingughaluka niise neeghe indalama shangu pamupeene ni sha pamwanya?’ ");
INSERT INTO ndh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Po usongo yula akabhalaghila abhandu bhaabho bhakiima pala akati, ‘Eegha indalama isho, mupe umubhombi uyo yuuyo akabhite indalama inine imbya kalongo.’ ");
INSERT INTO ndh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bhoope bhakamubhuula bhakati, ‘Ghwe songo, tesha, umubhombi uyo ali nasho indalama kalongo!’ ");
INSERT INTO ndh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Usongo yula akabhaamula akati, ‘Ingubhabhuula umwe ukuti umundu ghweshi yuuyo akukabhombela akiisa kaako ali nako, uChaala indiakamwongeleshe akanine, loole umundu ghweshi yuuyo atakukabhombela akiisa kaako ali nako, uChaala indiakamupoke na kala kaako ali nako. ");
INSERT INTO ndh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pamupeene ni isho, isagha na bhalughu bhangu abho bhaabho bhatakalondagha ukuti une imbe nee malafyale ghwabho, bhaghoghe bhwo ingutesha!’ ” ");
INSERT INTO ndh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bhwo uYeesu aayugha isho, akeendelela ukukwela ukubhuuka ku Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bhwo aapalamila ukufika mu kaaya aka Bheetifaaghe na ka Bheetaniya, utwaya tuutwo tuli kupiipi na kaghamba aka Mishunguti, uYeesu akabhatuma abhamanyili bhaake bhabhili, ");
INSERT INTO ndh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akabhabhuula akati, “Bhuuka mu kaaya kaako kali mundaashi mumwinyu. Bhwo mukwingila mu kaaya ako, indimuyaaghe inyaana iya mbunda yipinyiighwe, yiiyo umundu naayumo itoghiteepo. Muyaabhule, mwisaghe nayo panu. ");
INSERT INTO ndh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Linga umundu yumo akubhabhuusha akuti, ‘Kali, kooni mukuyaabhula inyaana iya mbunda iyi?’ Mwise mumwamulaghe mutingi, ‘UMalafyale akuyilonda.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Po abhamanyili bhala bhakabhuuka nu kushaagha shooshi shili isa muumwo uYeesu akabhabhuulila. ");
INSERT INTO ndh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bhwo bhakuyaabhula inyaana iya mbunda yila, abheene mbunda bhakabhabhuusha abhamanyili bhala bhakati, “Kali, kooni mukuyaabhula inyaana iya mbunda iyi?” ");
INSERT INTO ndh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Abhamanyili bhala bhakabhaamula bhakati, “UMalafyale akuyilonda.” ");
INSERT INTO ndh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Po bhakabhuuka ni nyaana iya mbunda yila kwa Yeesu. Bhakaalisha imyenda yaabho pamwanya pa mbunda, bhakamukwesha uYeesu pamwanya. ");
INSERT INTO ndh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bhwo uYeesu iitoghite pa nyaana iya mbunda ukubhuuka ku Yelusaleemu, abhandu bhakaanda ukwalisha imyenda yaabho mu sila. ");
INSERT INTO ndh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bhwo uYeesu aapalamila ukufika ku bhwilomuka ubhwa kaghamba aka Mishunguti, ichilundilo chooshi icha bhamanyili bhaake bhakahobhoka leka nu kwanda ukumupaala uChaala ku nongwa iya fyika fyoshi fiifyo bhakafibhonagha bhwo uYeesu akubhomba. ");
INSERT INTO ndh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bhakamupaala leka bhakati, “Asayighwange uMalafyale yuuyo akwisa mu ngamu iya Malafyale uChaala. Abhandu bhooshi bhabhange nu lutengaano nu Chaala! Apaalighwange uChaala kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bhwo aBhafalisaayi bhamu bhaabho bhakabhaamwo mu chilundilo icha bhandu chila bhaapulika isho, bhakamubhuula uYeesu bhakati, “Ghwe Mumanyishi, bhasumbishe abhamanyili bhaako ukuti bhaleke ukushiyugha isho!” ");
INSERT INTO ndh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Loole uYeesu akabhaamula akati, “Ingubhabhuula umwe ukuti linga abhamanyili bhangu bhaasumba, amayondo indighambaalaghe!” ");
INSERT INTO ndh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bhwo uYeesu aapalamila ukufika mu kaaya aka Yelusaleemu nu kukabhona akaaya ako, akaswimaana leka nu kwanda ukulila. ");
INSERT INTO ndh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Akalila akati, “Mwe bhandu abha mu Yelusaleemu umwe, kaali kiisa kukwinyu umuusughu ukuti mumanye isila yiiyo yikubhapelela ulutengaano. Loole ulu mutabhaghiile ukuyimanya. ");
INSERT INTO ndh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Paapo akabhalilo kakwisa kaako abhalughu bhiinyu indibhakasenge nu kushunguusha ulubhumba ulwa maka mu kaaya kiinyu kooshi ukuti manye umundu naayumo akafumaghe pamu ukwingila. ");
INSERT INTO ndh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Indibhakabhaghoghe umwe mweshi nu kupongolania akaaya kiinyu kooshi. Indibhakabhombe ulwo ku nongwa iya kuti mukakaana ukukamanya akabhalilo kaako uChaala akiisa pakubhapoka umwe!” ");
INSERT INTO ndh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Po uYeesu akiingila mu lupaso ulwa Nyumba iya Chaala. Bhwo iingila, akabhaagha nu kubhakiisha abhandu bhooshi bhaabho bhakabhombagha ubhuchulushi. ");
INSERT INTO ndh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","UYeesu akabhabhuula akati, “Shisimbiighwe mu Masimbo aMeelu, uChaala akuti, ‘Inyumba yangu indiyikabhe nyumba iya nyipuuto.’ Loole umwe muyibhiikite ukubha mbako iya bhapoka ifya bhandu.” ");
INSERT INTO ndh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bhwo isho shaakinda, uYeesu akamanyishanga abhandu lyoshi ishiku mu lupaso ulwa Nyumba iya Chaala. Loole abhosongo abha bhapuuti, abhamanyishi abha ndaghilo isha Moose pamupeene na bhalongoshi abha Bhayuuta bhakaanda ukulonda isila iya kumughogha uYeesu. ");
INSERT INTO ndh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Loole bhakapootwa ukuyaagha isila ku nongwa iya kuti abhandu bhooshi bhakiighanagha ukumupulikisha uYeesu shiisho akamanyishanga. ");
INSERT INTO ndh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ishiku limo uYeesu akabhamanyishanga abhandu mu lupaso ulwa Nyumba iya Chaala nu kulumbilila iNongwa iNyiisa. Po abhosongo abha bhapuuti, abhamanyishi abha ndaghilo isha Moose na bhosongo abha Bhayuuta bhakabhuuka kukwake. ");
INSERT INTO ndh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bhwo bhaafika, bhakamubhuusha bhakati, “Tubhuule, kali, kubhomba shooshi ishi ku maka agha ghwini? Kali, ghwini yuuyo akupiile amaka agho?” ");
INSERT INTO ndh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","UYeesu akabhaamula akati, “Nuune indiimbabhuushe ibhuusho limo, nuumwe muunyaamule. ");
INSERT INTO ndh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kali, amaka agha Yoohani agha kwosha abhandu, ghakafuma kwa Chaala pamu ghakafuma ku bhandu?” ");
INSERT INTO ndh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Po bhakayughisania bheene-bheene bhakati, “Linga twamwamula ukuti ghakafuma kwa Chaala, indiatubhuushe ukuti, ‘Po kali, kooni mutakamwitikagha?’ ");
INSERT INTO ndh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Soona linga twamwamula ukuti ghakafuma ku bhandu, po abhandu bhooshi abha indibhatukome na mayondo ku nongwa iya kuti bhakwitika ukuti uYoohani akabha musololi ughwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Po bhakamwamula bhakati, “Tutameenye kuukwo amaka agho ghakafuma.” ");
INSERT INTO ndh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ghwepe uYeesu akabhabhuula akati, “Nuune indakubhabhuula ukuti ingubhomba shooshi ishi ku maka agha ghwini.” ");
INSERT INTO ndh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Po uYeesu akaanda ukubhabhuula abhandu ichifwanikisho ichi akati, “Akabhaapo umulimi yumo yuuyo akalima umughunda ghwake nu kubhyala imisabhibhu. Bhwo aabhyala, akabhabhiika abhalimi mu mughunda ghula ukuti linga bhaaya bhiinula iseke bhakayabhane. Pabhumalilo, akachuula ukubhuuka ku chiisu ichinine kuukwo akiikala ifyinja ifyingi. ");
INSERT INTO ndh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bhwo kaafika akabhalilo aka kwinula, akamutuma umubhombi yumo ku bhalimi bhala ukuti amweghele iseke shiisho shikabha shaake. Loole bhwo umubhombi yula aafika pa mughunda ghula, abhalimi bhala bhakamukoma nu kumukiisha tukono twene. ");
INSERT INTO ndh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bhwo umubhombi yula aamubhuula umwene mughunda shiisho shikabhombighwa, akamutuma umubhombi umunine. Loole abhalimi bhala bhakamukoma ghwepe nu kumubhombela shiisho shitakulondighwa nu kumukiisha chishita kumupa naakamu. ");
INSERT INTO ndh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Umwene mughunda yula akamutuma umubhombi ughwa bhutatu. Loole abhalimi bhala bhakamufulasha ghwepe nu kumutaagha kuuse ku mughunda. ");
INSERT INTO ndh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Po umwene mughunda yula akiibhuusha mwene mu ndumbula yaake akati, ‘Kali, imbombe kooni ulu? Indiimutume kukwabho umwana ghwangu yuuyo imughanite! Lumo umwene indibhamughindike.’ ");
INSERT INTO ndh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Po umwana ghwake akabhuuka. Loole bhwo abhalimi bhala bhaamubhona umwana yula, bhakayughisania bheene-bheene bhakati, ‘Uyu ghwe yuuyo indiakiingile ichilingo pa bhuyo ubhwa ghwise. Isagha tumughoghe ukuti ichilingo chaake chibhe chiitu.’ ");
INSERT INTO ndh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bhwo aafika, abhalimi bhala bhakamukola, bhakamufumya kuuse ku mughunda, bhakamughogha.” Po uYeesu akabhabhuusha akati, “Kali, mukwinongʼona ukuti umwene mughunda yula indiakabhombe kooni ku bhalimi bhala? ");
INSERT INTO ndh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Indiakiise nu kubhapyuta abhalimi bhala, soona indiakabhape abhalimi abhanine umughunda ghula!” Bhwo abhandu bhala bhaapulika amashu agho, bhakayugha bhakati, “UChaala ashikaanishe isho ukuti manye shibhombighwe.” ");
INSERT INTO ndh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Loole uYeesu akabhatesha, akabhabhuusha akati, “Kali, mutabhelengite shiisho shisimbiighwe mu Masimbo aMeelu? Shisimbiighwe ukuti, ‘Iyondo liilyo abhasenga nyumba bhakalikaana, lyo liilyo lyabha liyondo ikulu ilya kukola pa nguto iya lwalilo ulwa nyumba.’ ");
INSERT INTO ndh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Po umundu ghweshi yuuyo aaya aaghwila pi iyondo ilyo, indiakaposongane. Soona, umundu ghweshi yuuyo indilikamughwile, indilikamutiisanie-tiisanie.” ");
INSERT INTO ndh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Abhamanyishi abha ndaghilo isha Moose na bhosongo abha bhapuuti bhakamanya ukuti uYeesu akabhayughagha bho bhaabho mu chifwanikisho icho. Po bhakalonda isila iya kumukola, loole bhatakamukola paapo bhakooghopa ichilundilo icha bhandu. ");
INSERT INTO ndh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bhwo isho shaakinda, abhalongoshi abho bhakaanda ukumukongeesha uYeesu. Bhakabhatuma abhapeleeleshi bhamu kukwake ukuti bhatendelaghe shiisho uYeesu akashibhombagha. Bhakabhomba ulwo ukuti bhayaaghe isila iya kumuteghela ku mashu ghaake ukuti bhamukole nu kubhuuka naghwe kwa songo ughwa silikali iya Looma ughwa mu kaaya ako. ");
INSERT INTO ndh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Po abhandu bhala bhaabho bhakatumighwa, bhakamubhuusha uYeesu ku sila iya kumupeleelesha bhakati, “Ghwe Mumanyishi, tumeenye ukuti ughwe kuyugha nu kumanyisha shiisho sha nalooli, soona utakumwoghopa umundu naayumo yuuyo ali ni mbombo iya pamwanya, loole kumanyisha isila iya Chaala mu bhwanalooli. ");
INSERT INTO ndh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kali, indaghilo isha Moose shikutwitikisha ukusonga isongo kwa Kayisaali pamu nashiku?” ");
INSERT INTO ndh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Loole uYeesu akamanya ukuti bhakughela ukumutegha, akabhabhuula akati, ");
INSERT INTO ndh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Indangishe isalabhasha iya ndinaali.” Bhoope bhakamulangisha. Po uYeesu akabhabhuusha akati, “Kali, chaani ichifwani nu bhusimbe ubhu bhuli pa salabhasha iyi?” Abheene bhakamwamula bhakati, “Fya malafyale uKayisaali.” ");
INSERT INTO ndh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Po uYeesu akabhabhuula akati, “Po mupange uKayisaali fiifyo fya Kayisaali, soona mupange uChaala fiifyo fya Chaala.” ");
INSERT INTO ndh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Abhandu bhala bhakapootwa isila iya kumukola ku nongwa iya mashu ghaagho akaghayugha pandaashi pa bhandu, bhakaswigha leka muumwo uYeesu akabhaamulila. Po bhakasumbaashe. ");
INSERT INTO ndh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ABhasandukaayi bhandu bhaabho bhakiitikagha ukuti uChaala ataaakabhashuushe abhandu. Ishiku limo bhakabhuuka kwa Yeesu, bhakamubhuusha bhakati, ");
INSERT INTO ndh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ghwe Mumanyishi, uMoose akatusimbila mu ndaghilo ukuti linga umundu aafwa nu kumuleka umukashi chishita kupaapa umwana, shikwitikishighwa ughwamwabho ukumwingila ichilingo umufwile uyo ukuti amupaapile umwana ughwa kwendelesha ingamu iya yuuyo afwile. ");
INSERT INTO ndh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Po mu kabhalilo kamu, bhakabhaapo abhaliisha abhanamundu bhahaano na bhabhili (7). Umuliisha ughwa bhwandilo akeegha umukolo, loole akafwa chishita kupaapa abhaana. ");
INSERT INTO ndh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Umuliisha ughwa bhubhili akamwingila ichilingo umufwile yula, loole ghwepe akafwa chishita kupaapa umwana, ");
INSERT INTO ndh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","po umuliisha ughwa bhutatu akamwingila ichilingo umufwile yula, ghwepe akafwa chishita kupaapa umwana. Abhaliisha abhanamundu bhala bhooshi bhahaano na bhabhili isa bhubhuubhwo, loole bhooshi bhakafwa chishita kupaapa abhaana. ");
INSERT INTO ndh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pabhumalilo, umukolo umufwile yula ghwepe akafwa. ");
INSERT INTO ndh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Po tubhuule, kali, pi ishiku lila liilyo uChaala indiakabhashuushange abhafwe bhooshi, umukolo yula indiakabhe mukashi ghwani? Paapo akeeghighwa na bhaliisha bhooshi bhahaano na bhabhili!” ");
INSERT INTO ndh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","UYeesu akabhaamula akati, “Abhandu abha mu chiisu ichi bhakwegha nu kweghighwa. ");
INSERT INTO ndh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Loole abhandu bhaabho uChaala abhabhelengiile ukuti bhabhaghile ukubhwagha ubhuyo mu chiisu ichipya chila bhwo bhaashuuka, abheene bhataabhakeeghaghe pamu bhataabhakeeghighwange. ");
INSERT INTO ndh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pamupeene ni isho, abhandu abho bhataabhakafwe soona ku nongwa iya kuti indibhakabhe ungati bhandumi abha Chaala. Soona, abheene bhaana bha Chaala ku nongwa iya kuti indiakabhashuushe. ");
INSERT INTO ndh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Loole nu Moose ghwepe akashimikisha pa katengele kaako kakaakagha, ukuti abhafwe indibhakashuuke. Paapo akamwitisha uMalafyale ukuti ghwi ‘Chaala yuuyo uAbhulahamu, uIsiyaka nu Yaakobhu bhakamwipuutagha.’ ");
INSERT INTO ndh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Po abhandu bhaabho bhafwe bhatakumwipuuta uChaala, loole abhandu bhaabho bhuumi bho bhaabho bhakumwipuuta, paapo kukwake abhandu bhooshi bhuumi.” ");
INSERT INTO ndh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Po abhamanyishi bhamu abha ndaghilo isha Moose bhakayugha bhakati, “Ghwe Mumanyishi, ghwamula akiisa!” ");
INSERT INTO ndh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bhwo isho shaakinda, naayumo umundu yuuyo akasulwa ukumubhuusha shimo soona. ");
INSERT INTO ndh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Po uYeesu akabhabhuusha abhandu bhaabho bhakamupulikishanga akati, “Kali, kooni abhandu bhakuyugha bhakuti uMesiiya Mwana ghwa malafyale uNdaabhiti? ");
INSERT INTO ndh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Paapo uNdaabhiti akati, ‘UMalafyale uChaala akamubhuula uMalafyale ghwangu, “Ikala ku kakono kangu aka kumwisa, ");
INSERT INTO ndh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ukufika paapo indiingabhabhiike abhalughu bhaako paase pa tulundi twako.” ’ ");
INSERT INTO ndh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Linga uNdaabhiti akamwitisha uKilisiti ukuti Malafyale, po kali, uKilisiti abhaghiile bhuleele ukubha mwana ghwake?” ");
INSERT INTO ndh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bhwo abhandu bhooshi bhali pakupulikisha, uYeesu akabhabhuula abhamanyili bhaake akati, ");
INSERT INTO ndh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mubhange maaso na bhamanyishi abha ndaghilo isha Moose! Paapo bhiighanite leka ukughenda bhwo bhafwalite imiselekesha imitali ukuti abhandu bhabhalamukaghe ku lughindiko mu minaalo. Linga bhali mu masinaghoghi ghaabho, abheene bhiighanite ukwikala pa fitengu ifya lughindiko ifya mundaashi. Soona pi ishiku ilya lusekelo, abheene bhiighanite ukwikala pa fitengu ifya bhaheesha abhaghindikighwa. ");
INSERT INTO ndh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Abhandu abho bhakupokagha ifyuma ni nyumba isha bhakolo abhafwile! Soona bhakwipuutagha kwa Chaala inyipuuto indali ukuti bhiilangishe ku bhandu ukuti bhakubhomba inyiisa. Ku nongwa iyo, uChaala indiakabhape abhandu abho ulufundo ulukulu.” ");
INSERT INTO ndh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bhwo uYeesu na bhamanyili bhaake bhakaali bhali mu lupaso ulwa Nyumba iya Chaala, uYeesu akabhabhona abhakabhi bhakufumya ifyabhupe fyabho nu kubhiika mu ibhokoshi ilya kusengulila indalama. ");
INSERT INTO ndh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Soona akamubhona umukolo yumo umufwile umupiina, akufumya nu kubhiika isalabhasha shibhili mu ibhokoshi lila. ");
INSERT INTO ndh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Nalooli ingubhabhuula, umukolo umufwile umupiina uyu, aafumya indalama inyingi ukukinda abhandu abhanine bhooshi. ");
INSERT INTO ndh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Paapo abhanine bhala bhaafumya ifyabhupe fiifyo fyashaalagha ukufuma mu bhukabhi bhwabho. Loole umukolo uyu pamupeene nu kuti mupiina, poope aafumya indalama shaake shooshi shiisho sha kumwafwa mu bhwumi bhwake!” ");
INSERT INTO ndh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Abhamanyili bhamu abha Yeesu bhakaanda ukuyugha isha Nyumba iya Chaala muumwo yikasengighwa ku mayondo amiisa pamupeene nu tundu utwa mutengo tuutwo abhandu bhakafumyanga kwa Chaala. Po uYeesu akabhabhuula akati, ");
INSERT INTO ndh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Akabhalilo kakwisa kaako twoshi utu mukutubhona panu, naalimo iyondo liilyo indilikashaale pamwanya pi iyondo inine. Loole amayondo ghooshi agho, indighakapongolighwe!” ");
INSERT INTO ndh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Po abhamanyili bhaake bhakamubhuusha uYeesu bhakati, “Ghwe Mumanyishi, tubhuule, kali, indishikabhoneke liighi shooshi isho? Soona, kali, chilangisho chiki chiicho indichikatulangishe ukuti shaapalamila ukubhoneka?” ");
INSERT INTO ndh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","UYeesu akabhaamula akati, “Mubhange maaso ukuti manye mukashimbulighwe! Paapo indibhakiise abhandu abhingi nu kubhombela ingamu yangu, bhakatingi, ‘Une nee Mesiiya.’ Soona indibhakatingi, ‘Akabhalilo kali papiipi!’ Po manye mukabhakongaghe abhandu abho! ");
INSERT INTO ndh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Loole linga mukupulika inongwa isha bhwite na bhandu ukulwa bheene-bheene mu chiisu chaabho, manye mukapaashange. Paapo shooshi isho shikulondighwa ukubhoneka taashi, loole ubhumalilo ubhwene bhukaali bhukwisa.” ");
INSERT INTO ndh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Po uYeesu akeendelela ukubhabhuula akati, “Ichiisu chimo indichikalwange ni chiisu ichinine nu bhunyafyale bhumo indibhukalwange nu bhunyafyale ubhunine. ");
INSERT INTO ndh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Indikukabhange nu tuyingiyingi utukulu, isala ingali na mabhine agha kusambukila mumbafu shooshi isha chiisu. Soona indishikabhonekaghe inyingi isha kwoghofya ni fyika ifikulu ukufuma kumwanya. ");
INSERT INTO ndh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Loole bhwo shooshi isho shikaali ukubhoneka, abhandu indibhakabhakolaghe umwe nu kubhafulasha. Indibhakabhuukaghe nuumwe pakubhalonga ku bhosongo abha masinaghoghi nu kubhapinya mu nyumba isha bhapinyighwa. Soona indibhakabhuukaghe nuumwe ku bhomalafyale na ku bhalongoshi bhaabho ukuti mulongighwe ku nongwa iya kuti umwe mwe bhamanyili bhangu. ");
INSERT INTO ndh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ku sila iyo, indimukabhe na kabhalilo akiisa aka kuushimikisha une kukwabho. ");
INSERT INTO ndh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Loole manye mupaashange ukuti indimukayughaghe kooni ukuti mwitetele. ");
INSERT INTO ndh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Paapo une indiingabhape amashu na mahala ghaagho abhalughu bhiinyu indibhakapootwe ukwamula pamu ukubhakaanika shiisho indimukayughaghe. ");
INSERT INTO ndh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Abhapaapi bhiinyu, abhoghwamwinyu na bhamanyani bhiinyu indibhakabhabhiikaghe umwe mu tukono utwa bhalughu, bhoope abhalughu indibhakabhaghoghaghe bhamu pakati papiinyu. ");
INSERT INTO ndh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Abhandu bhooshi indibhakabhabhenge umwe ku nongwa iya ngamu yangu. ");
INSERT INTO ndh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Loole naakamu nalinga kangʼwili aka ku mitu yiinyu kaako indikakasobhe. ");
INSERT INTO ndh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Linga mwakibha indamyo shooshi isho, indimukabhwaghe ubhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","UYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “Loole linga mwaya mwabhabhona abhashikali abha bhwite bhaakashunguulila akaaya aka Yelusaleemu, po mukamanyaghe ukuti akabhalilo aka kupongolighwa akaaya ako kali papiipi. ");
INSERT INTO ndh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Po mu kabhalilo ako, abhandu bhaabho bhakwikala mu chiisu icha Yuteeya, bhakakindilaghe mu tughamba, bhaabho bhakwikala mu kaaya aka Yelusaleemu, bhakafumaghe kuuse nu kukinda, na bhaabho bhakwikala mu twaya utunandi, manye bhakaghalukaghe mu kaaya akakulu. ");
INSERT INTO ndh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Paapo amashiku agho indighakabhe mashiku agha ndamyo ukuti shibhombighwe shooshi shiisho shisimbiighwe mu Masimbo aMeelu. ");
INSERT INTO ndh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Lwabho abhakolo bhaabho indibhakabhe pa bhungʼwamu na bhaabho indibhakabhe bhakwongesha ku mashiku agho! Paapo abhandu indibhakataamighwe leka mu chiisu chooshi nu Chaala indiakabhalonge ku lyoyo abhandu abho. ");
INSERT INTO ndh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Abhandu abhingi mu bhandu abho indibhakaghoghighwe bhwo bhali ku bhwite na bhanine indibhakabhakole nu kubheegha ukubha bhatumwa mu fyisu fyoshi. Soona, abhandu bhaabho bhataa Bhayuuta indibhakakanye mu kaaya aka Yelusaleemu ukufika paapo akabhalilo kaabho aka kulongosha indikakashile.” ");
INSERT INTO ndh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","UYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “Bhwo isho shaakinda, indifikabhonekaghe ifyika ifya kuswighisha ku isubha, ku mweshi na ku ndoondwa. Mu fyisu ifyingi ifya pa chiisu ichi abhandu indibhakooghopaghe nu kufulughana imitu yaabho bhwo bhakuyibhona inyanja yikuughila pamupeene ni nguli ingulu. ");
INSERT INTO ndh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abhandu abhingi indibhakashilikaghe ku nongwa iya bhwogha ku shiisho indishikabhonekaghe mu chiisu chooshi, paapo uChaala indiakatuyungaanie utundu twoshi utwa kumwanya. ");
INSERT INTO ndh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Po mu kabhalilo ako indibhakamubhone uMwana ughwa Mundu akwisa mu mabhingu bhwo ali na maka amingi nu bhukulumba ubhukulu. ");
INSERT INTO ndh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Linga shooshi isho shaanda ukubhombighwa, mukabhange nu lusuubhilo nu lusekelo ku nongwa iya kuti shooshi isho shikulangisha ukuti uChaala ali papiipi ukubhapoka!” ");
INSERT INTO ndh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Po uYeesu akabhabhuula abhamanyili bhaake ichifwanikisho ichi akati, “Teshanga ikokwe ilya mukuyu na makokwe amanine ghooshi. ");
INSERT INTO ndh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Linga ghaanda ukutulula amaani, ghweshi umundu abhaghiile ukutesha nu kumanya ukuti akabhalilo aka fula kaapalamila. ");
INSERT INTO ndh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bhubhuubhwo bhwo shili na kukwinyu, linga mukushibhona shooshi isho shikubhombighwa, mukamanye ukuti ichitangalala icha Chaala chili papiipi. ");
INSERT INTO ndh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nalooli ingubhabhuula, imbaapo iyi yitaayikakinde bhwo ishi shooshi shitabhonekite. ");
INSERT INTO ndh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kumwanya ni chiisu indifikakinde, loole amashu ghangu indigheendelele ukubhaapo bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Po uYeesu akamaliisha ukubhabhuula abhamanyili bhaake akati, “Mubhange maaso ukuti manye mukolighwange ni finyonywa ifibhiibhi, ukughaala pamu inyinongʼono isha bhwumi bhwinyu. Linga mukushibhomba isho, ishiku ilya bhumalilo lila indilikabhiisile ku sila iya kunyomosha isa muumwo akapingo kakukola ichikanu ku sila iya kunyomosha. ");
INSERT INTO ndh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Isa muumwo akapingo kakukolela ichikanu, bhubhuubhwo ishiku ilyo indilikabhiisile abhandu bhooshi abha mu chiisu chooshi. ");
INSERT INTO ndh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Po mubhange maaso akabhalilo kooshi nu kwipuuta kwa Chaala, ukuti abhapange amaka agha kupona ku shooshi shiisho indishikabhonekaghe nu kuti mubhange na maka agha kwima mundaashi mu Mwana ughwa Mundu.” ");
INSERT INTO ndh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mu mashiku agho pamuusi, uYeesu akamanyishanga abhandu mu lupaso ulwa Nyumba iya Chaala, loole pabhushiku akabhuukagha pakughona ku kaghamba aka Mishunguti. ");
INSERT INTO ndh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Po abhandu abhingi bhakalamushanga pangeelo lyoshi ishiku nu kubhuuka mu lupaso ulwa Nyumba iya Chaala ukuti bhamupulikishe uYeesu. ");
INSERT INTO ndh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Akabhalilo aka Bhayuuta aka kusekelela ichaaka icha Mikati iMishita Kulula chiicho bhakatingi Pasaka, kakabha kaapalamila. ");
INSERT INTO ndh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Abhosongo abha bhapuuti pamupeene na bhamanyishi abha ndaghilo isha Moose, bhakalondagha isila iya kumughogha uYeesu ku bhushiifu ku nongwa iya kuti bhakabhooghopagha abhandu. ");
INSERT INTO ndh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Po uSeetano akamwingila umundu yumo yuuyo ingamu yaake akabha ghwi Yuuta yuuyo bhakatingi Isikaliyooti. Umundu uyo akabha ghwe yumo mu bhamanyili abha Yeesu kalongo na bhabhili (12). ");
INSERT INTO ndh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","UYuuta akabhuuka ku bhosongo abha bhapuuti na ku bhosongo abha bhashikali bhaabho bhakalindililagha iNyumba iya Chaala. Akayughisania nabho muumwo abhaghiile ukumubhiika uYeesu mu tukono twabho. ");
INSERT INTO ndh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Abhosongo abho bhakasekela leka nu kwitikana ukumuhomba uYuuta Isikaliyooti indalama. ");
INSERT INTO ndh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","UYuuta Isikaliyooti akiitika, po akaanda ukulonda akabhalilo akiisa aka kumubhiika uYeesu mu tukono utwa bhalughu bhwo ichilundilo icha bhandu chitaliipo. ");
INSERT INTO ndh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ishiku ilya chaaka icha Mikati iMishita Kulula likafika. Ishiku ilyo lyo liilyo abhandu bhakughoghagha abhonangʼooshi bhaabho ku nongwa iya kusekelela ichaaka icha Pasaka. ");
INSERT INTO ndh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Po uYeesu akabhatuma uPeeteli nu Yoohani, akabhabhuula akati, “Bhuuka mututendekeshekeshe ifindu ifya Pasaka.” ");
INSERT INTO ndh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Abheene bhakamubhuusha bhakati, “Ghwe Malafyale, kali, kulonda tubhuuke tutendekeshe kuughu?” ");
INSERT INTO ndh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Umwene akabhabhuula akati, “Pulikisha, bhuuka nu kwingila mu kaaya aka Yelusaleemu. Linga mwingila, indimukomaane nu muliisha yumo yuuyo apimbite ingumbe iya miishi. Po mumukongaghe ukufika inyumba yiiyo indiingilaghe. ");
INSERT INTO ndh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nuumwe mwise mumubhuushe umwene nyumba iyo muti, ‘UMumanyishi akubhuusha akuti, “Kali, chili kuughu ichipindwa icha bhaheesha muumwo indiindye ifindu ifya Pasaka pamupeene na bhamanyili bhangu?” ’ ");
INSERT INTO ndh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Umundu uyo indiabhalangishe ichipindwa ichikulu chiicho chili mu nyumba ingelesanie, chiicho chitendekeshiighwe akiisa. Umwo mwo muumwo mukatutendekeshekeshe ifindu.” ");
INSERT INTO ndh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Po abhamanyili bhala bhakabhuuka nu kufika mu kaaya aka Yelusaleemu. Bhwo bhaafika, shikabhombighwa isa muumwo uYeesu akabhabhuulila. Po bhakatendekesha ifindu ifya Pasaka. ");
INSERT INTO ndh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bhwo akabhalilo aka kulya kaafika, uYeesu akiikala pakulya ifindu pamupeene na bhatumighwa bhaake. ");
INSERT INTO ndh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Po akabhabhuula akati, “Naanyonywa leka ukulya ifindu ifya Pasaka pamupeene nuumwe bhwo indamyo shikaali ukuunyaagha. ");
INSERT INTO ndh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Paapo ingubhabhuula, indaaingalye soona ifindu ifya Pasaka ukufika paapo ichitangalala icha Chaala indichikiise.” ");
INSERT INTO ndh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Po uYeesu akeegha ichikombe chiicho chikabha ni ndifaayi, akapaalisha kwa Chaala, akabhabhuula abhamanyili bhaake akati, “Koogho, ngʼwanga mweshi. ");
INSERT INTO ndh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nalooli ingubhabhuula, ukufuma umuusughu indaaingangʼwe soona indifaayi ukufika paapo ichitangalala icha Chaala indichikiise.” ");
INSERT INTO ndh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Po akeegha umukati, akapaalisha kwa Chaala, akaghubheghulania, akabhapa, akabhabhuula akati, “Ughu ghwo ghuughwo mubhili ghwangu ghuughwo ingughutiisha ku nongwa yiinyu. Endelelagha ukulya umukati ughu isa bhuno bhuno ukuti muungumbukaghe.” ");
INSERT INTO ndh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bhubhuubhwo bhwo bhaalya, uYeesu akeegha ichikombe chiicho chikabha ni ndifaayi, akapaalisha kwa Chaala, akabhapa, akabhabhuula akati, “Ichikombe ichi chikulangisha ulwitikano ulupya luulwo uChaala indiitikane na bhandu bhaake ku sila iya libhanda lyangu liilyo likuya pakukupuka. ");
INSERT INTO ndh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Loole mumanye ukuti umundu yuuyo akulonda ukuumbiika mu tukono utwa bhalughu ali pakulya pamupeene nuune. ");
INSERT INTO ndh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Paapo uMwana ughwa Mundu akuya pakughoghighwa isa muumwo uChaala abhaatikiile. Loole lwake umundu uyo yuuyo akuya pakumubhiika mu tukono utwa bhalughu!” ");
INSERT INTO ndh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Po abhamanyili bhaake bhakaanda ukubhuusania bheene-bheene bhakati, “Kali, ghwini pakati papiitu yuuyo abhaghiile ukubhomba isho?” ");
INSERT INTO ndh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Akabhalilo kamu abhamanyili abha Yeesu bhakaanda ukukaanikana bheene-bheene ukuti pakati papaabho ghwini akubhoneka ukubha ghwi songo ukukinda abhanine bhooshi. ");
INSERT INTO ndh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Po uYeesu akabhabhuula akati, “Abhomalafyale abha pa chiisu panu bhakubhalongosha abhandu bhaabho ku maka, soona bhala bhaabho bhali na maka kukwabho, bhakwiyugha ukuti, ‘Bhatuuli abha bhandu.’ ");
INSERT INTO ndh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Loole manye shibhange ulwo kukwinyu. Umundu ghweshi yuuyo ghwi songo pakati papiinyu, uyo akulondighwa iibhiikaghe ukubha mukeke. Ghwepe yuuyo akulongosha abhandu, abhange mubhombi ghwa bhooshi. ");
INSERT INTO ndh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kali, ghwini ghwi songo? Kali, ghwe yula akwikala nu kulya ifindu pa meesa pamu ghwe yula akubhabhombela abhanine? Kali, ataa ghwe yula akwikala nu kulya ifindu pa meesa? Loole une indi pakati papiinyu isa umundu yuuyo akubhabhombela abhandu abhanine. ");
INSERT INTO ndh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Umwe mwemwe mwali pamupeene nuune akabhalilo kooshi bhwo ingughelighwa. ");
INSERT INTO ndh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nuune ingubhapa amaka agha kulongosha abhandu pamupeene nuune mu chitangalala icha Chaala isa muumwo uTaata aambiile amaka agha kulongosha. ");
INSERT INTO ndh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Indiimbombe ulwo ukuti mukiikalaghe nu kulya pamupeene nuune ku chitangalala changu. Soona indimukiikalaghe pa fitengu ifya bhomalafyale bhwo mukufilonga ifikolo kalongo na fibhili (12) ifya Isilaeli.” ");
INSERT INTO ndh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Po uYeesu akamubhuula uPeeteli akati, “Ghwe Siimoni, ghwe Siimoni! Pulikisha, uSeetano asuumite kwa Chaala amwitikishe ukuti abhapeete umwe mweshi isa muumwo umulimi akupeetela ingano. ");
INSERT INTO ndh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Loole une ingwipuutiile kwa Chaala ughwe Siimoni ukuti ghwendelelaghe ukuunyiitika. Po linga ghwilaata imbiibhi shaako nu kuungalukila une, ukabhakashange abhiitiki abhanyiinyu.” ");
INSERT INTO ndh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","USiimoni akamwamula uYeesu akati, “Ghwe Malafyale, une niifumyishe ukubhuuka pamupeene nuughwe pakupinyighwa mu nyumba iya bhapinyighwa, soona niifumyishe ukufwa pamupeene nuughwe.” ");
INSERT INTO ndh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","UYeesu akamwamula akati, “Ghwe Peeteli, ingukubhuula, ubhushiku ubhwa muusughu bhwo ubhiisa akaali ukubhika, indiubhe ghwangaana katatu ukuti utaameenye.” ");
INSERT INTO ndh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bhwo akabhalilo kaakindaapo uYeesu akabhabhuusha abhamanyili bhaake akati, “Bhwo naabhatuma pakulumbilila iNongwa iNyiisa chishita nyambi iya ndalama, pamu chishita choola, pamu ifilato, kali, mwasobheliighwe kamu?” Bhakamwamula bhakati, “Nashiku Malafyale, tutaasobheliighwe naakamu.” ");
INSERT INTO ndh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Po uYeesu akabhabhuula akati, “Loole ulu umundu ghweshi yuuyo ali ni nyambi iya ndalama pamu ichoola, akulondighwa eeghe. Soona, ghwepe yuuyo atali nu mumaaghi umutali ughwa bhwite, akulondighwa aghulishe umwenda ghumo ukuti aghule umumaaghi ughwo. ");
INSERT INTO ndh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Paapo isho shiisho shisimbiighwe mu Masimbo aMeelu ukuti, ‘Akabhelengelighwa pamupeene na bhatulanongwa.’ Isho shikasimbighwa ukuunjugha une. Shoope indishibhombighwe kukwangu, soona shili papiipi ukubhombighwa.” ");
INSERT INTO ndh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Abhamanyili bhaake bhakamubhuula bhakati, “Ghwe Malafyale! Tesha, panu tuli nayo imimaaghi imitali iya bhwite mibhili.” UYeesu akabhaamula akati, “Shaaya, manye mwendelelaghe soona ukuyugha inongwa isha mimaaghi.” ");
INSERT INTO ndh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Po uYeesu akatiila mu kaaya aka Yelusaleemu, akabhuuka ku kaghamba aka Mishunguti isa muumwo akayiilo kaake kakabha. Bhoope abhamanyili bhaake bhakamukonga. ");
INSERT INTO ndh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bhwo bhaafika ku kaghamba kala, uYeesu akabhabhuula abhamanyili bhaake akati, “Ipuutagha kwa Chaala ukuti abhape amaka agha kushipoota ingelo.” ");
INSERT INTO ndh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Po akabhaleka pala pala, akabhiyila pandaashi panandi, ubhutali isa ubhwa mundu ukulasa iyondo. Akafughamila, akiipuuta kwa Chaala akati, ");
INSERT INTO ndh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ghwe Taata, linga bhwighane bhwako, ingukusuuma manye ushiitikishe kukwangu indamyo ingulu ishi! Manye ubhombe isa muumwo ingulondela, loole ubhombe isa muumwo kulondela.”  ");
INSERT INTO ndh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Po ughwandumi ukufuma kumwanya akamwisila uYeesu, akaanda ukumukasha. ");
INSERT INTO ndh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Bhwo ali mu bhuswimaane ubhukulu, uYeesu akeendelela ukwipuuta ngaani. Bhwo akwipuuta, amaafuku ghaake ghakaghwanga paase ungati matoonyeshi agha libhanda. ");
INSERT INTO ndh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bhwo iipuuta, akaghaluka ukubhuuka paapo akabhaleka abhamanyili bhaake, akabhaagha bhapitiile ku nongwa iya kuti bhakabha nu bhuswimaane. ");
INSERT INTO ndh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Po akabhabhuusha akati, “Kali, kooni mupitiile? Lamusha! Ipuutagha kwa Chaala ukuti abhape amaka agha kushipoota ingelo.” ");
INSERT INTO ndh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Bhwo uYeesu akaali akuyugha na bhamanyili bhaake, ichilundilo ichikulu icha bhandu bhaabho bhakalongoshighwanga nu Yuuta chikiisa. UYuuta uyo akabha ghwe yumo mu bhamanyili kalongo na bhabhili (12) abha Yeesu. Po akapalamila kwa Yeesu ukuti amulamuke ku sila iya kumwofwa. ");
INSERT INTO ndh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","UYeesu akamubhuusha akati, “Ghwe Yuuta! Kali, kumubhiika uMwana ughwa Mundu mu tukono utwa bhalughu ku sila iya kumwofwa?” ");
INSERT INTO ndh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bhwo abhamanyili abha Yeesu bhaashibhona shiisho shikuya pakubhombighwa, bhakamubhuusha uYeesu bhakati, “Ghwe Malafyale, kali, tubhapuupanie abhandu abha ni mimaaghi yiitu?” ");
INSERT INTO ndh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Po umumanyili yumo akafyutula lubhilo umumaaghi umutali ughwa bhwite, akapuupa ichuufwo icha kumwisa icha mutumwa ughwa mupuuti usongo. ");
INSERT INTO ndh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Loole uYeesu akayugha akati, “Leka! Manye ghwendelelaghe ukubhomba isho.” Po uYeesu akapalamaasha ichuufwo icha mutumwa yula, akamuposha. ");
INSERT INTO ndh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Po uYeesu akabhabhuusha abhosongo abha bhapuuti, abhosongo abha bhalindilili abha Nyumba iya Chaala pamupeene na bhosongo abha Bhayuuta akati, “Kali, kooni mukwisa kukwangu ni mipanga ni nduughu ungati mukwisa pakumukola umundu yuuyo akuyikaanika isilikali? ");
INSERT INTO ndh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Amashiku ghooshi ghaagho naabhanga pamupeene nuumwe mu lupaso ulwa Nyumba iya Chaala, mutaangolagha! Loole aka kabhalilo kiinyu aka kuungola bhwo amaka agha Seetano ghali pa mbombo.” ");
INSERT INTO ndh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Po bhakamukola uYeesu, bhakabhuuka naghwe ku nyumba iya mupuuti usongo. Loole uPeeteli akabhakongagha kunyuma pabhutali. ");
INSERT INTO ndh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bhwo bhaafika nu Yeesu ku nyumba iya mupuuti usongo, bhakapemba umulilo pakati pa lupaso, bhakiikala nu kwanda ukwota. UPeeteli ghwepe akabhuuka, akiikala pamupeene nabho. ");
INSERT INTO ndh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Umubhombi yumo umulindu akamubhona uPeeteli bhwo iikiile ali pakwota umulilo. Po akamushoolola uPeeteli, akayugha akati, “Umundu uyu aali pamupeene nu Yeesu.” ");
INSERT INTO ndh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Loole uPeeteli akakaana akati, “Ghwe mulindu ughwe! Une indamumeenye umundu uyo!” ");
INSERT INTO ndh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bhwo akabhalilo akapimba kaakinda, umundu umunine akamubhona uPeeteli, ghwepe akayugha akati, “Nuughwe ghwe yumo mu bhamanyili bhaake.” Loole uPeeteli akamwamula akati, “Ghwe mundu ughwe, une indaa neene!” ");
INSERT INTO ndh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bhwo iisala yimo yaakinda, umundu umunine soona akashimikisha ukuyugha akati, “Nalooli, umundu uyu aali pamupeene nu Yeesu paapo ghwepe akufuma mu chiisu icha Ghalilaayi!” ");
INSERT INTO ndh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Loole uPeeteli akamwamula akati, “Ghwe mundu ughwe! Une indashimeenye isho kuyugha!” Mu kabhalilo kala kala bhwo uPeeteli ali pakuyugha, ubhiisa akabhika. ");
INSERT INTO ndh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","UMalafyale uYeesu akasanusha kunyuma, akamutesha uPeeteli. Po uPeeteli akakumbuka amashu ghala ghaagho uMalafyale akamubhuula akati, “Umuusughu bhwo ubhiisa akaali ukubhika, indiubhe ghwangaana katatu.” ");
INSERT INTO ndh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Po akafuma kuuse, akaanda ukulila ngaani ku bhuswimaane. ");
INSERT INTO ndh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Abhandu bhaabho bhakamulindililagha uYeesu bhakaanda ukumwangalila nu kumukoma. ");
INSERT INTO ndh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bhakamwifunika ni chenda ku maaso, bhakamubhuusha bhakati, “Solola! Kali, ghwini yuuyo aakukoma?” ");
INSERT INTO ndh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Po bhakeendelela ukumutuka amaheelu amingi. ");
INSERT INTO ndh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bhwo bhwacha pangeelo, abhosongo abha Bhayuuta, abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose, bhakabhungaana pamupeene mu Ibhalaasa. Po abhashikali bhakabhuuka nu Yeesu pandaashi papaabho. ");
INSERT INTO ndh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bhwo uYeesu iimite pandaashi papaabho, bhakamubhuusha bhakati, “Tubhuule! Kali, ughwe ghwe Mesiiya?” Loole uYeesu akabhaamula akati, “Nalinga naabhabhuula, poope mutabhaghiile ukuunyiitika. ");
INSERT INTO ndh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Soona linga naabhabhuusha, mutabhaghiile ukuunyaamula. ");
INSERT INTO ndh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Loole ukwandila mu kabhalilo akapimba kaako kakwisa, uMwana ughwa Mundu indiikalaghe ku kakono aka kumwisa aka Chaala ughwa Maka Ghooshi.” ");
INSERT INTO ndh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Abhandu bhooshi bhakamubhuusha bhakati, “Kali, ughwe ghwe Mwana ghwa Chaala?” UYeesu akabhaamula akati, “Mwemwe mwayugha ukuti une neene.” ");
INSERT INTO ndh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Po abhalongoshi bhala bhakayugha bhakati, “Kali, tukulonda ubhukeeti bhuki soona? Paapo yutwetwe twapulika shiisho aayugha.” ");
INSERT INTO ndh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Po ichilundilo chooshi icha bhandu bhakanyatuka, bhakamwegha uYeesu nu kubhuuka naghwe kwa Pilaati usongo ughwa chiisu. ");
INSERT INTO ndh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bhwo bhaafika, bhakaanda ukumusitaaka uYeesu bhakati, “Ghwe songo, umundu uyu twamwaghite bhwo akumanyisha shiisho shikubhasofya abhandu bhiitu, akubhakaanisha ukuti manye bhasongaghe isongo kwa Kayisaali. Soona akwiyugha ukuti umwene ghwi Mesiiya, soona akuti ghwi Malafyale.” ");
INSERT INTO ndh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","UPilaati akamubhuusha uYeesu akati, “Kali, ughwe ghwe Malafyale ughwa Bhayuuta?” UYeesu akamwamula akati, “Ghweghwe ghwayugha.” ");
INSERT INTO ndh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Po uPilaati akabhabhuula abhosongo abha bhapuuti pamupeene ni chilundilo icha bhandu akati, “Indakuyaagha inongwa yiiyo mukumusitaaka umundu uyu.” ");
INSERT INTO ndh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Abhandu bhala bhakeendelela ukuyugha bhakati, “Umundu uyu akubhasongelesha abhandu ku sila iya fimanyisho fyake mu chiisu chooshi icha Yuteeya. Akaanda ukumanyisha mu chiisu icha Ghalilaayi, po ulu ali ku Yelusaleemu kuno.” ");
INSERT INTO ndh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bhwo uPilaati aapulika isho, akabhabhuusha akati, “Kali, umundu uyu afumite ku chiisu icha Ghalilaayi?” ");
INSERT INTO ndh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Po bhakamwamula bhakati, “Mwo muumwo, umundu uyu afumite ku chiisu icha Ghalilaayi.” Bhwo uPilaati aamanya ukuti uYeesu afumite ku chiisu icha Ghalilaayi chiicho umalafyale uHelooti akalongoshanga, akalaghila ukuti bhabhuuke naghwe kwa Helooti yuuyo mu kabhalilo ako ghwepe akabha mu kaaya aka Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bhwo uHelooti aamubhona uYeesu, akasekela leka paapo ku mashiku amingi akabha apulikite inongwa shaake. Soona akanyonywanga ukuti iibhonele yuuyo bhwo uYeesu akubhomba ifyika. ");
INSERT INTO ndh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Po uHelooti akamubhuusha uYeesu amabhuusho amingi, loole umwene atakaamula naalimo. ");
INSERT INTO ndh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abhosongo abha bhapuuti na bhamanyishi abha ndaghilo isha Moose bhakiima nu kumusitaaka uYeesu ku maka ngaani. ");
INSERT INTO ndh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Po uHelooti na bhashikali bhaake bhakaanda ukumusuusha nu kumwangalila uYeesu. Bhakamufwasha umwenda ghuughwo ghukangʼangʼagha ukuti abhonekaghe ungati ghwi malafyale, bhakabhuuka naghwe soona kwa Pilaati. ");
INSERT INTO ndh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","UHelooti nu Pilaati bhaabho bhakabha bhalughu ukufuma kunyuma, bhakamanyana ishiku ilyo. ");
INSERT INTO ndh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bhwo bhaafika nu Yeesu soona kwa Pilaati, uPilaati akabhabhungaania abhosongo abha bhapuuti, abhalongoshi abha Bhayuuta pamupeene na bhandu abhanine. ");
INSERT INTO ndh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Akabhabhuula akati, “Mwisa nu mundu uyu kukwangu paapo mukuti akubhamanyisha abhandu ukuti bhayikaanikaghe isilikali iya Looma. Bhwo naamubhuusha mundaashi mumwinyu, une indaayaagha inongwa naayimo kukwake. ");
INSERT INTO ndh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ghwepe uHelooti ataayaagha inongwa naayimo ku mundu uyu, yo yiiyo nongwa aamughalusha kukwangu. Isa muumwo mukushibhonela, umundu uyu atabhombite naashimo shiisho shikumupelela ukuti aghoghighwe. ");
INSERT INTO ndh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Po indiindaghile ukuti akomighwe ni fikoti nu kumwabhula ukuti abhuukaghe.”  ");
INSERT INTO ndh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","UPilaati akayugha ulwo ku nongwa iya kuti lukabha lwiho lwake ukubhaabhulila abhandu umupinyighwa yumo pa kabhalilo aka chaaka icha Pasaka. ");
INSERT INTO ndh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Loole abhandu bhooshi bhala bhakaywegha bhakati, “Mughoghe umundu uyo! Twabhulile uBhalabha!” ");
INSERT INTO ndh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","UBhalabha akapinyighwa mu nyumba iya bhapinyighwa ku nongwa iya kuyikaanika isilikali iya Looma nu kughogha abhandu. ");
INSERT INTO ndh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ku nongwa iya kuti uPilaati akalondagha ukumwabhula uYeesu, po akayugha soona na bhandu bhala. ");
INSERT INTO ndh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Loole abheene bhakoongela ukuywegha bhakati, “Mukomeele pa chikobhekano! Mukomeele pa chikobhekano!” ");
INSERT INTO ndh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","UPilaati akayugha nabho soona ulwa bhutatu akati, “Kali, umundu uyu atulite nongwa yiki? Une indakuyaagha inongwa naayimo kukwake yiiyo yibhaghiile ukumupelela ukuti aghoghighwe. Ku kabhalilo aka indiindaghile ukuti akomighwe ni fikoti nu kumwabhula.” ");
INSERT INTO ndh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Loole abhandu bhala bhakeendelela ukuywegha ngaani ukuti uYeesu akomeelighwe pa chikobhekano. Pabhumalilo umuywegho ghwabho ghukapoota. ");
INSERT INTO ndh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Po uPilaati akatumula ukumulonga uYeesu ukuti aghoghighwe isa muumwo bhakalondelagha. ");
INSERT INTO ndh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akabhaabhulila uBhalabha yuuyo akapinyighwa ku nongwa iya kuyikaanika isilikali nu kughogha abhandu. Po akamubhiika uYeesu mu tukono twabho ukuti bhamubhombele isa muumwo bhakalondelagha. ");
INSERT INTO ndh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bhwo abhashikali bhakubhuuka pakumukomeela uYeesu pa chikobhekano, bhakakomaana nu mundu yumo yuuyo ingamu yaake akabha ghwi Siimoni ukufuma mu kaaya aka Kileene. Akafuma ku mighunda, akabhuukagha mu kaaya aka Yelusaleemu. Po abhashikali bhakamukola uSiimoni, bhakamupimbisha ichikobhekano icha Yeesu. Bhakamufimbilisha ukuti akongaghe nacho kunyuma kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ichilundilo ichikulu icha bhandu chikamukongagha uYeesu. Mu chilundilo icho, bhakabhaamwo abhakolo bhaabho bhakamulililagha. ");
INSERT INTO ndh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","UYeesu akasanusha kunyuma, akabhabhuula akati, “Mwe bhakolo abha mu Yelusaleemu, manye mundililaghe une, loole lilagha ku nongwa yiinyu na bhaana bhiinyu! ");
INSERT INTO ndh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Paapo akabhalilo kakwisa kaako abhandu indibhakayughaghe bhakatingi, ‘Bhasayighwa abhakolo bhaabho bhatapaapiteemwo naalumo soona bhatoongeshisheemwo naalumo!’ ");
INSERT INTO ndh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mu kabhalilo ako, ‘Abhandu indibhakatubhuulaghe utughamba bhakatingi, “Tughwile!” Soona indibhakatingi, “Tushiile.” ’ ");
INSERT INTO ndh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Kali, linga bhakubhomba ishi ku ikokwe ibhisi, po indishikabhe bhuleele ku ikokwe liilyo lyumite?” ");
INSERT INTO ndh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mu chilundilo chila bhakabhaamwo abhandu abhanine bhabhili bhaabho bhakabha ni nongwa. Abhashikali bhakabheegha abhandu abho pamupeene nu Yeesu ukuti bhaye bhabhakomeele bhoope pa chikobhekano. ");
INSERT INTO ndh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bhwo bhaafika pabhuyo bhuubhwo bhakatingi Mungʼooso ughwa Mutu, abhashikali bhakamukomeela uYeesu pa chikobhekano. Bhakamukomeela pamupeene na bhapoka ifya bhandu bhabhili bhala pa fikobhekano, yumo kulubhafu ulwa kumwisa kwa Yeesu nu munine kulubhafu ulwa kushoomi. ");
INSERT INTO ndh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","UYeesu akiipuuta akati, “Ghwe Taata, ingukusuuma ubhahobhokele, paapo bhatashimeenye shiisho bhakubhomba.” Po abhashikali bhakeegha imyenda yaake, bhakayabhana ku sila iya kuyikomela ikuula ukuti yibhe yaani. ");
INSERT INTO ndh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abhandu bhaabho bhakiima papiipi nu bhuyo bhula, bhakateshanga shiisho bhakamubhombelagha uYeesu. Abhalongoshi abha Bhayuuta bhakamwobhelagha uYeesu bhakatingi, “Akabha mwengo ukubhapoka abhandu abhanine, po iipoke mwene linga umwene ghwi Mesiiya yuuyo uChaala amusalite!” ");
INSERT INTO ndh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abhashikali bhoope bhakamwangalila uYeesu, bhakabhuuka kukwake, bhakamupa indifaayi ingali ukuti angʼwe. ");
INSERT INTO ndh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bhakamubhuula bhakati, “Linga nalooli ghwe Malafyale ughwa Bhayuuta, ipoka ghwimwene!” ");
INSERT INTO ndh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pamwanya pa chikobhekano icha Yeesu pakasimbighwa amasimbo agha, ");
INSERT INTO ndh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Po yumo mu bhapoka ifya bhandu bhabhili bhala bhaabho bhakakomeelighwa pa chikobhekano pamupeene nu Yeesu, akamutuka uYeesu akati, “Kali, ughwe utaa ghwe Mesiiya? Ipoka yughweghwe, tupoke nuutwe!” ");
INSERT INTO ndh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Loole umunine akamukemela akati, “Kali, ughwe utakumwoghopa uChaala? Tesha, une nuughwe twalongighwa isa umwene! ");
INSERT INTO ndh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Utwe twalongighwa mu bhwanalooli ukukongana na shiisho tushibhombite. Loole umundu uyu atatulite inongwa naayimo.” ");
INSERT INTO ndh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Po akamusuuma uYeesu akati, “Ghwe Yeesu, ingukusuuma, ukaangumbuke nu kuumbelela ichisa linga ghwaya ghwabha ghwe Malafyale.” ");
INSERT INTO ndh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","UYeesu akamwamula akati, “Nalooli ingukubhuula, umuusughu indiubhe pamupeene nuune mu Palandiiso.” ");
INSERT INTO ndh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ukwandila bhwo isubha lyafika pamutu (6:00) ukufika mu sala iya bhuhaano na inna (9:00), ichiisi chikaghwa ichiisu chooshi ");
INSERT INTO ndh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ku nongwa iya kuti isubha likaleka ukubhalisha. Ipasiya liilyo likabha mu Nyumba iya Chaala, likanyaapuka imbafu shibhili. ");
INSERT INTO ndh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Po uYeesu akakuuta ku ishu ilya pamwanya akati, “Ghwe Taata! Ingubhubhiika ubhwumi bhwangu mu tukono twako.” Bhwo aayugha amashu agho, akafwa. ");
INSERT INTO ndh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bhwo usongo ughwa bhashikali yula aashibhona shiisho shikabhoneka, akamupaalisha uChaala akati, “Nalooli, umundu uyu ataali ni nongwa naayimo!” ");
INSERT INTO ndh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bhwo abhandu bhooshi bhaabho bhakabha bhabhungaanite pala bhaashibhona shiisho shikabhoneka, bhakaanda ukwikungʼunda ukulangisha ubhuswimaane nu kughaluka mu twaya twabho. ");
INSERT INTO ndh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Loole abhandu bhooshi bhaabho bhakamumanya uYeesu pamupeene na bhakolo bhaabho bhakamukongagha ukufuma ku Ghalilaayi bhakiima pabhutali panandi, bhakateshanga shiisho shikabhombighwanga. ");
INSERT INTO ndh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Akabhaapo umundu yumo yuuyo ingamu yaake akabha ghwi Yoosefu. Umundu uyo akabha ghwe yumo mu bhandu abha Libhalaasa ilya Bhayuuta. Akabha mundu mwisa soona ghwanalooli. ");
INSERT INTO ndh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Umundu uyo, akafumagha mu kaaya aka Alimataayi mu chiisu icha Bhayuuta. Akasubhaalilagha ngaani ukwisa ukwa chitangalala icha Chaala (umwene atakiitikana na bhanine ku shiisho bhakatumula ukuti uYeesu aghoghighwe). ");
INSERT INTO ndh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Po uYoosefu akabhuuka kwa Pilaati, akamusuuma ukuti amwitikishe aghweghe umufimba ughwa Yeesu nu kughushiila. ");
INSERT INTO ndh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bhwo uPilaati aamwitikisha, uYoosefu akabhuuka, akaghwegha umufimba ughwa Yeesu pa chikobhekano, akaghuniembetelela nu mwenda umwelu. Po akaghubhiika mu ipumba liilyo likabha likumbile ngaanila pa lyalabhwe. Ipumba ilyo likabha lipya liilyo bhatakamushiilaamwo umundu naayumo. ");
INSERT INTO ndh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Shooshi isho shikabhombighwa pi ishiku ilya Pabhuhaano, liilyo likabha lya kwitendekesha ku sha Sabhati yiiyo yikabha papiipi ukwanda. ");
INSERT INTO ndh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Abhakolo bhaabho bhakiisa pamupeene nu Yeesu ukufuma ku Ghalilaayi, bhakamukonga uYoosefu, bhakalibhona ipumba, soona bhakatesha na muumwo bhakaghubhiikila umufimba ughwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Po bhakaghaluka mu kaaya aka Yelusaleemu, bhakatendekesha inyemba isha lunuushi ulwisa nu mukota ughwa kughupaka umufimba ughwa Yeesu ukuti manye ghukomanikaghe. Loole bhakatuusha pi ishiku ilya Sabhati isa muumwo indaghilo isha Moose shikabhalaghilagha. ");
INSERT INTO ndh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ishiku ilya Pamulungu kubhuche, abhakolo bhala bhaabho bhakafuma nu Yeesu ku Ghalilaayi, bhakalaabhila ukubhuuka ku ipumba. Bhakeegha inyemba isha lunuushi ulwisa nu mukota fiifyo bhakabha bhatendekeshiishe ku nongwa iya kuya pakughupaka umufimba ughwa Yeesu ukuti manye ghukomanikaghe. ");
INSERT INTO ndh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bhwo bhaafika pi ipumba, bhakaagha iyondo liilyo bhakiifunikila ku mulyango libhungunie, lili kulubhafu ku ipumba. ");
INSERT INTO ndh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Loole bhwo bhiingila mukati mu ipumba, bhakaagha umufimba ughwa Malafyale uYeesu ghutaliimwo. ");
INSERT INTO ndh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bhwo abhakolo bhala bhali pakuswigha shiisho bhakashaagha, nakalinga bhakabhabhona abhandu bhabhili abhaliisha bhiimite papiipi nabho. Abhandu abho bhakafwala imyenda imyelu yiiyo yikangʼangʼagha leka. ");
INSERT INTO ndh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Abhakolo abho bhakooghopa leka nu kufulamila ifyeni fyabho paase. Po abhandu bhala bhakabhabhuusha bhakati, “Kali, kooni mukumulonda mu ipumba umundu yuuyo mwumi? ");
INSERT INTO ndh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ataliipo panu! Ashuukite! Kumbuka amashu ghaagho akabhabhuula bhwo akaali ali pamupeene nuumwe ku Ghalilaayi ukuti, ");
INSERT INTO ndh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Shikulondighwa ukuti uMwana ughwa Mundu abhiikighwe mu tukono utwa bhandu abhatulanongwa, akomeelighwe pa chikobhekano nu kuti pi ishiku ilya bhutatu indiakashuuke.’ ” ");
INSERT INTO ndh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Po abhakolo abho bhakakumbuka amashu agha Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Po bhakafuma pi ipumba, bhakabhuuka ku Yelusaleemu pakubhapangila abhamanyili abha Yeesu kalongo na yumo (11) pamupeene na bhanine bhooshi inongwa shooshi isho. ");
INSERT INTO ndh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Abhakolo bhaabho bhakabhuuka ku ipumba bhakabha ghwi Maliiya ukufuma mu kaaya aka Maghatala, uYoohana, uMaliiya ungʼina ughwa Yaakobhu na bhakolo abhanine bhaabho bhakabha pamupeene nabho. ");
INSERT INTO ndh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bhwo abhatumighwa bhaashipulika inongwa isho, bhakashibhona ukubha sha bhukonyofu. Po bhatakabhiitika abhakolo bhala. ");
INSERT INTO ndh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Loole uPeeteli akiima, akakinda lubhilo ukubhuuka ku ipumba. Bhwo aafika, akalingisha mu ipumba, akaghubhona umwenda umwelu ghwene ghuughwo bhakamushiilila uYeesu. Akatiila pala, akaghaluka kuukwo akafuma bhwo akuswigha ku shiisho shikabhoneka. ");
INSERT INTO ndh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pi ishiku ilya Pamulungu lila lila, abhamanyili bhabhili bhamu abha Yeesu bhakachuulagha ukubhuuka mu kaaya kaako ingamu yaake bhakatingi Emaabhu. Akaaya ako kali ikilomiita kalongo na yimo (11) ukufuma mu kaaya aka Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bhwo abhamanyili abho bhakughenda mu sila, bhakayughisanianga bheene-bheene ku shooshi shiisho shikabhoneka. ");
INSERT INTO ndh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bhwo bhakwendelela ukuyughisania inongwa isho, uYeesu yuuyo akiisa nu kwanda ukughenda pamupeene nabho mu sila. ");
INSERT INTO ndh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Abhamanyili abho bhakamubhona uYeesu na maaso ghaabho, loole uChaala akabhapela ukuti manye bhamumanyaghe ukuti ghwi Yeesu. ");
INSERT INTO ndh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","UYeesu akabhabhuusha akati, “Kali, mukuyughisania sha kooni bhwo mukughenda mu sila?” Bhoope bhakiima bhwo ifyeni fyabho fiswimaanite. ");
INSERT INTO ndh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yumo pakati papaabho yuuyo ingamu yaake akabha ghwi Kiliyoopa, akamubhuusha uYeesu akati, “Kali, ughwe ghwimwene ghweghwe uli muheesha mu bhandu bhooshi abha mu kaaya aka Yelusaleemu? Soona, kali, ghweghwe ghwimwene utashimeenye shiisho shibhonekite mu kaaya ako amashiku manandi ghaagho ghaakindagha?” ");
INSERT INTO ndh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","UYeesu akabhabhuusha akati, “Kali, shooni shiisho shibhonekite mu kaaya ako?” Abheene bhakamwamula bhakati, “Sho shila shaabhonekite kwa Yeesu ughwa kufuma mu kaaya aka Naasaleeti. Umundu uyo aali musololi ghwa Chaala, aali na maka ku shiisho aayughagha, na ku mbombo shaake shiisho aabhombagha mundaashi mwa Chaala na mundaashi mu bhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Loole abhosongo abha bhapuuti na bhalongoshi bhiitu abhanine, bhaamusitaakite kwa songo ughwa silikali iya Looma ukuti alongighwe ukughoghighwa. Po bhaamukomeelite pa chikobhekano. ");
INSERT INTO ndh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Uyo ghwe yuuyo twamusubhaalilagha ukuti indiabhapoke aBhaisilaeli ukufuma ku bhalughu bhaabho. Umuusughu lishiku lya bhutatu ukufuma ishiku liilyo bhaamughoghite. ");
INSERT INTO ndh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Soona, abhakolo bhamu mu chibhughutila chiitu bhaatunyomosha. Bhalabhiile pangeelo umuusughu ukubhuuka ku ipumba, ");
INSERT INTO ndh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","loole bhwo bhaafika, bhataghwaghite umufimba ughwa Yeesu. Bhaghalukite nu kwisa pakutubhuula ukuti abhandumi bhabhasetukiile nu kubhabhuula ukuti uYeesu mwumi. ");
INSERT INTO ndh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Po abhanyiitu bhamu mu chibhughutila chiitu bhabhuukite ku ipumba nu kwibhonela isa muumwo abhakolo bhala bhayughiile, bhoope bhataghwaghite umufimba ughwa Yeesu.” ");
INSERT INTO ndh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Po uYeesu akabhabhuula akati, “Umwe mwe bhalema! Kali, kooni kukafu umwe ukushiitika shooshi shiisho shikayughighwa na bhasololi? ");
INSERT INTO ndh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kali, shitaamubhaghiile uMesiiya ukushaagha indamyo shooshi isho bhwo akaali ukwingila ku bhukulumba bhwake?” ");
INSERT INTO ndh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Po akaanda ukubhalingaania inongwa shooshi shiisho shikasimbighwa mu Masimbo aMeelu ukumuyugha umwene. Akabhalingaania ukwandila abhokalata abha Moose ukufika abhokalata abha bhasololi bhooshi abhanine. ");
INSERT INTO ndh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bhwo bhaapalamila ukufika mu kaaya kaako bhakabhuukagha, uYeesu akabha ungati akupululila ukubhuuka mundaashi. ");
INSERT INTO ndh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Loole abheene bhakamusuuma ngaani bhakati, “Tukukusuuma ghwikale pamupeene nuutwe! Paapo ulu isubha lyakila, ubhushiku bhwanda ukughubha.” Po uYeesu akiitika, akiingila mu nyumba, akiikala pamupeene nabho. ");
INSERT INTO ndh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Po akaanda ukulya ifindu pamupeene nabho, akeegha umukati, akamupaalisha uChaala, akaghubheghulania nu kubhapa. ");
INSERT INTO ndh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mu kabhalilo kala kala, uChaala akabhapela ukushaaghania nu kumumanya ukuti ghwi Yeesu. Loole umwene akashebheluka nakalinga pa maaso papaabho. ");
INSERT INTO ndh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Po bhakabhuusania bheene-bheene bhakati, “Kali, indumbula shiitu shitaali nu lusekelo ulukulu bhwo akutulingaania mu sila shiisho shili mu Masimbo aMeelu?” ");
INSERT INTO ndh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Po bhakanyatuka mu kabhalilo kala kala ukubhuuka ku Yelusaleemu. Bhwo bhaafika, bhakabhaagha abhamanyili abha Yeesu kalongo na yumo (11) na bhala bhaabho bhakabha pamupeene nabho, bhabhungaanite, ");
INSERT INTO ndh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bhali pakulingaania bhakuti, “Nalooli, uMalafyale ashuukite! Aamusetukila uSiimoni!” ");
INSERT INTO ndh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Po abhamanyili bhabhili bhala bhoope bhakabhapangila shooshi shiisho shikabhaagha mu sila, na muumwo bhakamumanyila uYeesu bhwo akubheghulania umukati nu kubhapa. ");
INSERT INTO ndh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bhwo abhamanyili abha Yeesu bhakwendelela ukupangilana inongwa isho, uYeesu yuuyo akabhasetukila, akiima pakati papaabho, akabhabhuula akati, “UChaala abhapange ulutengaano mu ndumbula shiinyu!” ");
INSERT INTO ndh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Abhamanyili bhaake bhakanyomoka nu kwoghopa ngaani paapo bhakiinongʼonagha ukuti bhaamubhona umushuuka. ");
INSERT INTO ndh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Loole uYeesu akabhabhuusha akati, “Kali, kooni mukwoghopa? Kali, kooni mukwilaamwa mu ndumbula shiinyu? ");
INSERT INTO ndh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Teshanga utukono nu tulundi twangu mumanye ukuti neene. Imbalamaashe ukuti mubhe nu bhwanalooli, paapo umushuuka atali nu mubhili na mafupa. Loole une indi nafyo isa muumwo mukuumbonela.” ");
INSERT INTO ndh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bhwo uYeesu aamala ukubhabhuula isho, akabhalangisha ifilonda ifya mu tukono na tulundi twake. ");
INSERT INTO ndh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Abhamanyili bhaake bhakapootwa ukumwitika ukuti nalooli ghwi Yeesu ku nongwa iya kusekela nu kuswigha. Bhwo bhakaali bhakusekela nu kuswigha, uYeesu akabhabhuusha akati, “Kali, muli ni findu fimo fiifyo mubhaghiile ukuumba ukuti indye?” ");
INSERT INTO ndh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Po abhamanyili bhaake bhakamupa ichibhali icha iswi yiiyo bhakoocha. ");
INSERT INTO ndh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ghwepe akapokeela nu kulya mundaashi mumwabho. ");
INSERT INTO ndh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Po akabhabhuula akati, “Ishi sho shiisho ingabhabhuula bhwo ingaali indi pamupeene nuumwe. Ingabhabhuula ukuti shooshi shiisho shisimbiighwe ukuunjugha une mu ndaghilo isha Moose, mu bhokalata abha bhasololi abha Chaala na mu Sabhuli shikulondighwa shibhombighwe.” ");
INSERT INTO ndh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Po akabhiighula amahala ghaabho ukuti bhaande ukushaaghania shiisho shisimbiighwe mu Masimbo aMeelu. ");
INSERT INTO ndh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akabhabhuula akati, “Shisimbiighwe mu Masimbo aMeelu ukuti uMesiiya indiakataamighwe nu kufwa. Loole indiakashuuke pi ishiku ilya bhutatu. ");
INSERT INTO ndh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Soona shisimbiighwe ukuti mu ngamu yaake mwo muumwo abhandu bhooshi ukwandila mu Yelusaleemu, indibhakalumbililighwange ukuti bhiilaataghe imbiibhi shaabho ukuti uChaala abhahobhokele. ");
INSERT INTO ndh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Umwe mwabha bhakeeti bha ishi shiisho shaabhombighwa ukuti mubhabhuulaghe na bhandu abhanine. ");
INSERT INTO ndh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Pulikisha! Indiimutume kukwinyu uMbepo uMwelu isa muumwo uTaata akafinga. Ulu mwikale taashi mu Yelusaleemu muno muno ukufika paapo indimukapokeele amaka ukufuma kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bhwo uYeesu aayugha amashu agho, akabheegha abhamanyili bhaake nu kubhuuka nabho kupiipi na kaaya aka Bheetaniya. Bhwo bhaafika, akiimika utukono twake kumwanya, akabhasaya. ");
INSERT INTO ndh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Bhwo ali pakubhasaya, akabhaleka, akeeghighwa ukubhuuka kumwanya. ");
INSERT INTO ndh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Po abhamanyili bhaake bhakamwipuuta nu kughaluka ukubhuuka ku Yelusaleemu bhwo bhali nu lusekelo ulukulu. ");
INSERT INTO ndh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Akabhalilo kooshi bhakiikalagha mu lupaso ulwa Nyumba iya Chaala, bhakamupaalagha uChaala.");
INSERT INTO ndh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bhwo uChaala akupela ichiisu kubhwandilo, Ishu akabha aliikwo. Ishu uyo akabha pamupeene nu Chaala. Ghwepe Ishu uyo akabha ghwi Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ukufuma kubhwandilo Ishu uyo akabhanga pamupeene nu Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","UChaala akatupela utundu twoshi ukughendela ku Ishu uyo. Atakapela akandu naakamu chishita kubhombela Ishu. ");
INSERT INTO ndh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ishu uyo ghwe yuuyo akabha bhwandilo ubhwa bhwumi. Po ubhwumi ubhwo bhukiisa nu bhwelu ku bhandu. ");
INSERT INTO ndh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ubhwelu ubhwo bhukwendelela ukukosha mu chiisi, ni chiisi choope chitakubhupoota. ");
INSERT INTO ndh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","UChaala akamutuma umundu yumo yuuyo ingamu yaake akabha ghwi Yoohani. ");
INSERT INTO ndh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","UYoohani akiisa ukuti abhe mukeeti ughwa kubhulingaania ubhwelu ubhwo ku bhandu ukuti bhooshi bhamwitike yuuyo bhwelu. ");
INSERT INTO ndh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","UYoohani atakabha bhwelu, loole akiisa pakubhalingaania abhandu isha bhwelu ubhwo. ");
INSERT INTO ndh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","UYeesu Kilisiti bhwelu bhwa nalooli yuuyo akiisa mu chiisu ichi pakubhaafwa abhandu ukuti bhashibhonaghe shiisho shili mu chiisi. ");
INSERT INTO ndh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ishu uyo akabhaamwo mu chiisu. UChaala akapela ichiisu ukughendela kukwake, loole abhandu abha mu chiisu bhatakamumanya. ");
INSERT INTO ndh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akiisa ku bhandu abha kukwake, loole bhatakamupokeela. ");
INSERT INTO ndh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Loole abhandu bhooshi bhaabho bhakamupokeela nu kumwitika, akabhapa amaka agha kubha bhaana bha Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ukubha bhaana bha Chaala ukwo, kutaa kwo kupaapighwa ku sila iya kukomaana umukolo nu muliisha pamu ku finyonywa ifya mubhili pamu ku bhwighane ubhwa mundu yumo, loole uChaala ghwe yuuyo akabhapela ukubha bhaana bhaake. ");
INSERT INTO ndh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Po Ishu uyo akiisa aabha mundu, ghwepe akiikala pamupeene nuutwe. Nuutwe tukabhubhona ubhukulumba bhwake, ubhukulumba ubhwa Mwana yuuyo ali mwene ukufuma kwa Chaala uGhwise, ali ni chisa ichingi nu bhwanalooli kukwitu. ");
INSERT INTO ndh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","UYoohani akabhabhuula abhandu inongwa isha mundu uyo, akayugha ku ishu ilya pamwanya akati, “Uyu ghwe yuuyo ingabhabhuulagha inongwa shaake ingatingi, ‘Indiakiise umundu yumo kunyuma kukwangu yuuyo ghwi songo ukuunginda une paapo akabha mwumi bhwo une ingaali ukupaapighwa.’ ” ");
INSERT INTO ndh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ku nongwa iya chisa nu bhwanalooli bhwake, uChaala atusayite nu kwongelaapo. ");
INSERT INTO ndh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Paapo uChaala akabhapa abhandu indaghilo shaake ku sila iya Moose, loole akalangisha ichisa nu bhwanalooli bhwake ku sila iya Yeesu Kilisiti. ");
INSERT INTO ndh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Naayumo umundu yuuyo amubhweni uChaala, loole uMwana ghwake mwene, yuuyo ghwepe ghwi Chaala. Uyo yuuyo ali papiipi nu Ghwise, ghwe yuuyo amulangishiishe uChaala kukwitu. ");
INSERT INTO ndh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ishiku limo abhalongoshi abha Bhayuuta bhakabhatuma abhapuuti na Bhalaabhi ukufuma ku Yelusaleemu pakumubhuusha uYoohani uMwoshi ukuti umwene ghwini. ");
INSERT INTO ndh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","UYoohani akiitika pabhwelu, akayugha akati, “Une indaa nee Mesiiya.” ");
INSERT INTO ndh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bhakamubhuusha bhakati, “Po kali, ughwe ghwe ghwini? Kali, ghwe musololi uEliiya?” UYoohani akabhaamula akati, “Nashiku, indaa nee Eliiya.” Abheene bhakamubhuusha soona bhakati, “Kali, ghwe musololi umunine yuuyo tukumulindilila ukuti akwisa ukufuma kwa Chaala?” UYoohani akabhaamula akati, “Nashiku, indaa neene.” ");
INSERT INTO ndh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bhakamubhuusha soona bhakati, “Po tubhuule ukuti tuye tubhabhuule bhala bhaabho bhatutumite, kali, ughwe ghwe ghwini? Soona, kali, ughwe kwiyugha ukuti ghwe ghwini?” ");
INSERT INTO ndh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","UYoohani akabhaamula ukukongana na mashu ghaagho ghasimbiighwe mwa kalata ughwa musololi uYesaaya akati, “Une nee mundu yuuyo ingubhalumbilila abhandu mu lungalangala inguti, ‘Gholoshanga isila iya Malafyale uChaala.’ ” ");
INSERT INTO ndh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Po abhandu bhala bhaabho aBhafalisaayi bhakabhatuma kwa Yoohani, ");
INSERT INTO ndh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","bhakamubhuusha bhakati, “Linga ughwe utaa ghwe Mesiiya, pamu utaa ghwe musololi uEliiya, pamu utaa ghwe musololi umunine yuuyo tukumulindilila ukwisa ukufuma kwa Chaala, po kali, ughaaghite kuughu amaka agha kwosha abhandu?” ");
INSERT INTO ndh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","UYoohani akabhaamula akati, “Une ingubhoosha na miishi, loole pakati papiinyu iimite yuuyo umwe mutamumeenye. ");
INSERT INTO ndh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Uyo yuuyo akwisa kunyuma kukwangu, indaa mubhaghile ukubha mubhombi ghwake ughwa kusatula utughoye utwa filato fyake.” ");
INSERT INTO ndh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Shooshi isho shikabhombighwa mu kaaya aka Bheetaniya, ku isiila inine ilya lusooko ulwa Yoolotani kuukwo uYoohani akooshanga abhandu. ");
INSERT INTO ndh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ishiku liilyo likakongagha, uYoohani akamubhona uYeesu akwisa kukwake. Akabhabhuula abhandu bhaabho bhakabhaapo pala akati, “Tesha, umundu uyo yuuyo akwisa ghwe yuuyo uChaala amutumite pakufwa ungati Konangʼooshi ukuti abhahobhokele imbiibhi abhandu abha mu chiisu ichi! ");
INSERT INTO ndh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uyu ghwe yuuyo ingabhabhuulagha inongwa shaake ingatingi, ‘Indiakiise umundu yumo kunyuma kukwangu yuuyo ghwi songo ukuunginda une paapo akabha mwumi bhwo une ingaali ukupaapighwa.’ ");
INSERT INTO ndh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nuune indakamumanya, loole ingiisa pakubhoosha abhandu na miishi ukuti abhandu abha Isilaeli bhamumanye.” ");
INSERT INTO ndh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Po uYoohani akeendelela ukubhalingaania soona abhandu shiisho akashibhona akati, “Ingamubhona uMbepo ughwa Chaala ukufuma kumwanya yuuyo akiika ungati ngunda nu kwima pamwanya papaake. ");
INSERT INTO ndh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Poope indakamumanya, loole uChaala yuuyo akaanduma ukwosha abhandu na miishi ghwe yuuyo akaambuula akati, ‘Linga ghwamubhona umundu yuuyo uMbepo ghwangu ukufuma kumwanya akwika pamwanya papaake, ghwe yuuyo indiakabhooshange abhandu nu Mbepo uMwelu.’ ");
INSERT INTO ndh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nuune ishibhweni, soona ingushimikisha ukuti uyo Mwana ghwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pi ishiku inine liilyo likakongagha, uYoohani uMwoshi akiima soona ku isiila lila lila ilya lusooko ulwa Yoolotani pamupeene na bhamanyili bhaake bhabhili. ");
INSERT INTO ndh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","UYoohani akamubhona uYeesu akughenda kupiipi nabho. Bhwo aamubhona, akabhabhuula abhamanyili bhaake akati, “Tesha, umundu uyo yuuyo akwisa, ghwe yuuyo uChaala amutumite pakufwa ungati Konangʼooshi.” ");
INSERT INTO ndh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bhwo abhamanyili bhaake bhabhili bhaamupulika uYoohani akuyugha amashu agho, bhakatumula ukumukonga uYeesu. ");
INSERT INTO ndh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Po uYeesu akasanusha kunyuma, akabhabhona abhamanyili abho bhwo bhakumukonga. Akabhabhuusha akati, “Kali, mukulonda kooni?” Bhoope bhakamwamula bhakati, “Ghwe Laabhi (kwo kuti, Mumanyishi), kali, kwikala kuughu?” ");
INSERT INTO ndh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","UYeesu akabhaamula akati, “Isagha, nuumwe indimupabhone paapo ingwikala.” Po bhakamukonga nu kupabhona paapo akiikalagha. Bhakiikala pamupeene naghwe ishiku lyoshi ukufika namasubha (10:00). ");
INSERT INTO ndh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Umumanyili yumo mu bhamanyili bhabhili bhala bhaabho bhakapulika bhwo uYoohani akuyugha nu kumukonga uYeesu akabha ghwi Ndeleeya, ughwamwabho ughwa Siimoni Peeteli. ");
INSERT INTO ndh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","UNdeleeya akabhuuka taashi pakumulonda ughwamwabho uSiimoni Peeteli. Bhwo aamwagha, akamubhuula akati, “Twamubhona uMesiiya!” Ingamu inine ilya Mesiiya kwo kuti, “Kilisiti.” ");
INSERT INTO ndh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Po uNdeleeya akiisa nu Siimoni kwa Yeesu. Ghwepe uYeesu akamutesha uSiimoni, akamubhuula akati, “Ughwe ghwe Siimoni umwana ughwa Yoohani. Ukwandila ulu, ingamu yaako indiubhe ghwe Keefa,” kwo kuti, “Peeteli” pamu “Lyalabhwe.” ");
INSERT INTO ndh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ishiku ilya ningeelo yaake, uYeesu akatumula ukubhuuka ku chiisu icha Ghalilaayi. Bhwo aafika, akamwagha uFilipu, akamubhuula akati, “Ghwe Filipu, isagha ghuungongaghe.” ");
INSERT INTO ndh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","UFilipu akafumagha mu kaaya aka Bheetisayita kaako uNdeleeya nu Peeteli bhakiikalagha. ");
INSERT INTO ndh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","UFilipu akabhuuka nu kumwagha uNataniyeeli, akamubhuula akati, “Twamubhona umundu yula yuuyo uMoose akasimba inongwa shaake mwa kalata ughwa ndaghilo na yuuyo abhasololi bhoope bhakasimba inongwa shaake. Umundu uyo ghwi Yeesu yuuyo akufuma mu kaaya aka Naasaleeti, umwana ughwa Yoosefu.” ");
INSERT INTO ndh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Loole uNataniyeeli akamubhuusha uFilipu akati, “Kali, kandu kaki aka kwafwa kaako kabhaghiile ukufuma mu kaaya akanandi aka Naasaleeti?” UFilipu akamwamula akati, “Isagha ghwibhonele yughweghwe.” Po uNataniyeeli akabhuuka pamupeene nu Filipu kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bhwo uYeesu aamubhona uNataniyeeli akwisa kukwake, akabhabhuula abhamanyili bhaake inongwa isha Nataniyeeli akati, “Tesha, umundu uyo yuuyo akwisa, Mwisilaeli ughwa nalooli yuuyo atayughiteemwo ubhumyashi naalumo.” ");
INSERT INTO ndh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","UNataniyeeli akamubhuusha uYeesu akati, “Ghwe malafyale, kali, ghwamanya bhuleele une?” UYeesu akamwamula akati, “Na bhwo uFilipu akaali ukwisa pakukwitisha, une ingabha ingubhweni bhwo ghwikiile pi ikokwe ilya mukuyu.” ");
INSERT INTO ndh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Po uNataniyeeli akamwamula akati, “Ghwe Mumanyishi, ulu naamanya ukuti ughwe ghwe Mwana ghwa Chaala! Ughwe ghwe Malafyale ughwa chiisu icha Isilaeli!” ");
INSERT INTO ndh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","UYeesu akamwamula nu kumubhuusha akati, “Kali, kwitika ku nongwa iya kuti naakubhuula ukuti ingakubhona bhwo ghwikiile pi ikokwe ilya mukuyu? Indiushibhone inine ingulu ngaani isha kuswighisha ukukinda ishi!” ");
INSERT INTO ndh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","UYeesu akeendelela ukuyugha akati, “Nalooli ingubhabhuula, indikakiise akabhalilo kaako indimukakubhone kumwanya kukwighuka, abhandumi abha Chaala indibhakakwelaghe nu kwika ukughendela ku sila iya Mwana ughwa Mundu isa muumwo uYaakobhu akatesha kubhwandilo.” ");
INSERT INTO ndh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Po pi ishiku ilya bhutatu, pakabhaakwo nu lusekelo ulwa bhweghi bhuubhwo bhukabhombighwa mu kaaya aka Kana, mu chiisu icha Ghalilaayi. Ku bhweghi ubhwo, akabhaakwo nu ngʼina ughwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","UYeesu na bhamanyili bhaake bhoope bhakabhaakwo ku bhweghi ubhwo isa muumwo bhakabhapaalila. ");
INSERT INTO ndh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bhwo abhaheesha abha bhweghi bhaangʼwa indifaayi yooshi, ungʼina ughwa Yeesu akamubhuula umwana ghwake akati, “Ghwe mwana ghwangu, abhaheesha bhaamala indifaayi.” ");
INSERT INTO ndh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","UYeesu akamwamula ungʼina akati, “Ghwe maayi, kali, kooni kuyugha isho kukwangu? Akabhalilo aka kubhomba imbombo yangu kakaali katafikite.” ");
INSERT INTO ndh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Po ungʼina akabhabhuula abhabhombi akati, “Bhombagha shooshi shiisho umwana ghwangu akubhabhuula ukuti mubhombe.” ");
INSERT INTO ndh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Po pabhuyo bhula, pakabhaapo ni ngumbe ihaano na yimo (6) shiisho shikatendekeshighwa na mayondo. ABhayuuta bhakabhombelagha ingumbe isho ukubhiikila amiishi agha kwiyeelufya ukukongana ni nyiiho shaabho. Ingumbe yimo yikiisulagha amalebhe mabhili pamu matatu agha miishi. ");
INSERT INTO ndh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","UYeesu akabhabhuula abhabhombi bhala akati, “Eegha amiishi nu kwisusha mu ngumbe isho.” Bhoope bhakeegha amiishi nu kwisusha mu ngumbe shila ukufika pamwanya. ");
INSERT INTO ndh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Po uYeesu akabhabhuula akati, “Teka amiishi ghamu muye mumupe usongo ughwa lusekelo ulwa bhweghi.” Bhoope bhakateka amiishi nu kubhuuka pakumupa usongo yula. ");
INSERT INTO ndh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Usongo ughwa bhweghi yula akangʼwa amiishi ghala ghaagho uYeesu akabha aghasanushiishe ukubha ndifaayi. Umwene atakamanya kuukwo indifaayi yila yikafuma, loole abhabhombi bhaabho bhakateka amiishi bhakamanya kuukwo yikafuma. Po akamwitisha yuuyo akeeghagha umukolo. ");
INSERT INTO ndh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Bhwo iisa, usongo yula akamubhuula akati, “Umundu ghweshi kubhwandilo akutendekeshanga indifaayi yiiyo nyiisa, loole bhwo abhandu bhaangʼwa nu kwikuta, kubhumalilo akwisagha ni ndifaayi yiiyo yitali nu mutengo. Loole ughwe usengwile indifaayi yila yiiyo nyiisa ukufika ulu!” ");
INSERT INTO ndh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","UYeesu akabhomba ichiika ichi chiicho chikabha cha bhwandilo mu kaaya aka Kana, mu chiisu icha Ghalilaayi. Ku sila iyi uYeesu akalangisha ubhukulumba bhwake ku bhandu. Ku nongwa iyo, abhamanyili bhaake bhakamwitika. ");
INSERT INTO ndh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bhwo ulusekelo ulwa bhweghi lwashila, uYeesu akiilomuka ukubhuuka ku kaaya aka Kapenabhumu nu ngʼina, abhoghwamwabho pamupeene na bhamanyili bhaake. Bhakiikala ukwo amashiku manandi. ");
INSERT INTO ndh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Bhwo akabhalilo aka chaaka icha Pasaka iya Bhayuuta kaapalamila, uYeesu akakwela ukubhuuka ku Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Po akiingila mu lupaso ulwa Nyumba iya Chaala. Bhwo iingila, akabhaagha abhachulushi bhaabho bhakaghulishanga ingʼombe, abhonangʼooshi ni ngunda, ifindu fiifyo fikabha fyabhupe kwa Chaala. Soona akabhaagha abhandu bhaabho bhakiikala pa meesa shaabho bhwo bhakufunja indalama shiisho shikalondighwanga mu Nyumba iya Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Bhwo uYeesu aashibhona isho, akatendekesha ichikoti icha ngoye, akabhakiisha abhachulushi bhooshi pamupeene ni ngʼombe na bhonangʼooshi ukufuma mu lupaso ulwa Nyumba iya Chaala. Akashinyambaania isalabhasha isha bhafunja ndalama nu kushighalabhulania imeesa shaabho. ");
INSERT INTO ndh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Po uYeesu akabhalaghila abhandu bhala bhaabho bhakaghulishanga ingunda akati, “Shitiishe ingunda ishi panu. Manye muyibhiikaghe inyumba iya Taata ukubha nyumba iya kubhombela ubhuchulushi.” ");
INSERT INTO ndh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bhwo abhamanyili bhaake bhaapulika ulwo, bhakakumbuka amashu ghaagho ghasimbiighwe mu Masimbo aMeelu ukuti uKilisiti akayugha kwa Chaala akati, “Ku nongwa iya kuti injighanite inyumba yaako, po abhandu indibhangoghe.” ");
INSERT INTO ndh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Po bhwo abhalongoshi abha Bhayuuta bhaashibhona shiisho uYeesu aabhomba, bhakamubhuusha bhakati, “Kali, indiubhombe chiika chiki ukulangisha ukuti uli na maka agha kushibhomba ishi?” ");
INSERT INTO ndh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","UYeesu akabhaamula akati, “Pongolania iNyumba iya Chaala iyi, nuune indiinjisenge soona ku mashiku matatu.” ");
INSERT INTO ndh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Po bhakamwamula bhakati, “Abhasengi bhakabhomba imbombo iya kusenga iNyumba iya Chaala iyi ku fyinja amalongo manna, fihaano na chimo (46). Po kali, ughwe ubhaghiile ukuyisenga bhuleele soona inyumba iyi ku mashiku matatuushe?” ");
INSERT INTO ndh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Loole umwene atakayughagha isha Nyumba iya Chaala, loole akayughagha isha mubhili ghwake. ");
INSERT INTO ndh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Po bhwo uYeesu aashuuka, abhamanyili bhaake bhakakumbuka amashu ghaagho akayugha. Ku sila iyi, bhakaghiitika amashu ghaagho ghasimbiighwe mu Masimbo aMeelu na shooshi shiisho uYeesu akashiyughagha. ");
INSERT INTO ndh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bhwo uYeesu ali ku Yelusaleemu ku lusekelo ulwa chaaka icha Pasaka, abhandu abhingi bhakamwitika ku nongwa iya kuti bhakafibhona ifyika ifyingi fiifyo akafibhombagha. ");
INSERT INTO ndh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Loole uYeesu atakabhiitika ku nongwa iya kuti akashimanya shiisho shikabha mu ndumbula isha bhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","UYeesu atakalondagha umundu naayumo ughwa kumulingaania shiisho abhandu abhanine bhakiinongʼonagha ku nongwa iya kuti akashimanya shooshi shiisho shikabha mu ndumbula isha bhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kukabhaakwo umulongoshi yumo uMuyuuta ukufuma mu chibhughutila icha Bhafalisaayi yuuyo ingamu yaake akabha ghwi Nikondeemu. ");
INSERT INTO ndh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ishiku limo pabhushiku, uNikondeemu akabhuuka kuukwo uYeesu akabha, akamubhuula akati, “Ghwe Mumanyishi, tumeenye ukuti ughwe ghwe mumanyishi ghwe uChaala akutumite, paapo ataliipo umundu naayumo yuuyo abhaghiile ukubhomba ifyika fiifyo kufibhomba linga uChaala atali pamupeene naghwe.” ");
INSERT INTO ndh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","UYeesu akamwamula akati, “Nalooli ingukubhuula, ataliipo umundu yuuyo abhaghiile ukwingila mu chitangalala icha Chaala linga atapaapiighwe ulwa bhubhili.” ");
INSERT INTO ndh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","UNikondeemu akamubhuusha uYeesu akati, “Kali, umundu umughome abhaghiile ukupaapighwa bhuleele ulwa bhubhili? Kali, abhaghiile ukwingila soona mu lufukwe ulwa ngʼina ukuti apaapighwe?” ");
INSERT INTO ndh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","UYeesu akamwamula akati, “Nalooli ingukubhuula, ataliipo umundu yuuyo abhaghiile ukwingila mu chitangalala icha Chaala linga atapaapiighwe ku miishi na ku sila iya Mbepo ughwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Umundu akupaapighwa nu mubhili ukufuma ku bhapaapi bhaake, loole akupokeela ubhwumi ubhupya ukufuma kwa Mbepo ughwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Manye uswighaghe shiisho naakubhuula ukuti, ‘Kulondighwa upaapighwe taashi ulwa bhubhili.’ ");
INSERT INTO ndh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Imbepo yikukuka ukubhuuka kwoshi kuukwo yiighana. Nuughwe ubhaghiile ukupulika ukupuuta kwake, loole utakumanya kuukwo yikufumila na kuukwo yikubhuukila. Ishi bhwo shili na ku mundu ghweshi yuuyo apaapiighwe ku sila iya Mbepo ughwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","UNikondeemu akamubhuusha uYeesu akati, “Kali, umundu abhaghiile ukupaapighwa bhuleele ku sila iya Mbepo ughwa Chaala?” ");
INSERT INTO ndh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","UYeesu akamwamula akati, “Ughwe ghwe mumanyishi umughindikighwa ughwa bhandu abha chiisu icha Isilaeli, kali, utashimeenye shooshi ishi? ");
INSERT INTO ndh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nalooli ingukubhuula, utwe tukubhabhuula umwe shooshi shiisho tushimeenye nu kubhalingaania shooshi shiisho tushibhweni, loole umwe mutakwitika shiisho tukubhabhuula. ");
INSERT INTO ndh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bhwo naabhabhuula shiisho shikubhombighwa pa chiisu ichi umwe mutakwitika, po kali, mubhaghiile ukwitika bhuleele linga ingubhabhuula shiisho shikubhombighwa kumwanya? ");
INSERT INTO ndh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ataliipo umundu naayumo yuuyo abhuukite lumo kumwanya, loole uMwana ughwa Mundu yuuyo akiisa ukufuma kumwanya. ");
INSERT INTO ndh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Isa muumwo uMoose akachikweshekesha ichifwani icha njoka yiiyo yikatendekeshighwa ni shabha ukuti abhapoke aBhaisilaeli bhwo bhali mu lungalangala, ghwepe uMwana ughwa Mundu akulondighwa ukuti bhakamukweshe pa chikobhekano, ");
INSERT INTO ndh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ukuti abhape ubhwumi ubhwa bhwila na bhwila abhandu bhaabho bhakumwitika. ");
INSERT INTO ndh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","UChaala akabhaghana abhandu abha mu chiisu ichi, yo yiiyo nongwa iyi akamufumya uMwana ghwake yuuyo ali mwene, ukuti umundu ghweshi yuuyo akumwitika manye asobhaghe, loole abhwaghe ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","UChaala atakamutuma uMwana ghwake pakubhalonga abhandu abha mu chiisu ichi, loole akamutuma pakubhapoka. ");
INSERT INTO ndh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“UChaala atakubhalonga abhandu bhooshi bhaabho bhakumwitika umwene, loole bhalongiighwe ngaanila abhandu bhooshi bhaabho bhatakumwitika uMwana ghwake yuuyo ali mwene. ");
INSERT INTO ndh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ubhu bhwo bhuubhwo bhulongi ukuti umwene akiisa pa chiisu ichi ungati bhwelu, loole abhandu bhakachighana ichiisi ukukinda ukubhughana ubhwelu ubhwo paapo imbombo shaabho shikabha mbiibhi. ");
INSERT INTO ndh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Abhandu bhooshi bhaabho bhakubhomba imbiibhi bhakubhukalalila ubhwelu ubhwo, soona bhatakulonda ukubhuuka kukwake yuuyo ali ungati bhwelu, paapo bhakwoghopa ukuti manye ashibhiike pabhwelu imbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Loole abhandu bhooshi bhaabho bhakubhomba inyiisa bhakubhuuka kukwake yuuyo ali ungati bhwelu. Bhakubhuuka kukwake ukuti bhooshi bhamanye ukuti shooshi shikubhombighwa ku maka agha Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bhwo isho shaakinda, uYeesu na bhamanyili bhaake bhakatiila mu kaaya aka Yelusaleemu nu kubhuuka mu chiisu icha Yuteeya. Bhakiikala ku kabhalilo kamu mu chiisu icho nu kubhoosha abhandu. ");
INSERT INTO ndh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mu kabhalilo kala kala, uYoohani uMwoshi ghwepe akabhooshanga abhandu mu kaaya aka Ayinooni kupiipi na kaaya aka Saleemu ku nongwa iya kuti kukabha na miishi amingi. Abhandu bhakabhuukagha kukwake ukuti abhooshe. ");
INSERT INTO ndh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","UYoohani uMwoshi akabhombagha imbombo iyo bhwo uHelooti akaali ukumukola nu kumubhiika mu nyumba iya bhapinyighwa. ");
INSERT INTO ndh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ishiku limo abhamanyili abha Yoohani uMwoshi bhamu bhakaanda ukukaanikana nu Muyuuta yumo ku sha lwiho ulwa kwiyeelufya ukubha mwelu. ");
INSERT INTO ndh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Po bhakabhuuka kwa Yoohani uMwoshi, bhakamubhuula bhakati, “Ghwe Mumanyishi, umundu yuuyo ukabha naghwe ku isiila ilya lusooko ulwa Yoolotani, yuuyo ukatulingaaniapo ni nongwa shaake, ulu ali pakubhoosha abhandu na bhandu bhooshi bhakubhuuka kukwake.” ");
INSERT INTO ndh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","UYoohani akabhaamula akati, “Umundu atabhaghiile ukukaagha akandu linga uChaala atamupiile. ");
INSERT INTO ndh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Umwe mwe bhakeeti bhangu ku shiisho ingayugha ukuti, ‘Une indaa nee Mesiiya,’ loole uChaala akaanduma ukuti indangile mundaashi mumwake pakubhabhuula abhandu ukuti akwisa. ");
INSERT INTO ndh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Umulindu yuuyo akweghighwa, akulondighwa ukubhuuka ku muliisha yuuyo akumwegha. Une indi isa umumanyani ughwa mundu yuuyo akwegha, yuuyo akwima kulubhafu kukwake nu kuhobhoka bhwo akupulika ishu ilya yuuyo akwegha. Bhubhuubhwo, nuune inguhobhoka leka paapo abhandu bhakubhuuka kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Shikulondighwa uYeesu abhange ghwi songo ngaani, loole une imbange munandi ngaani. ");
INSERT INTO ndh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“UYeesu yuuyo afumite kumwanya ali na maka ukukinda abhandu bhooshi, loole umwene yuuyo ghwa pa chiisu ichi, ashimeenye nu kushiyugha shiisho shikubhoneka pa chiisu ichi. Yo yiiyo nongwa iyi uyo yuuyo afumite kumwanya ghwe yuuyo ali na maka ukukinda abhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","UYeesu akulingaania shiisho ashibhweni nu kushipulika ukufuma kumwanya, loole bhandu bhanandiishe bhaabho bhakwitika ukuti shiisho akuyugha sha nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Abhandu bhooshi bhaabho bhakuyiitika indumi iya Yeesu, bhakushimikisha ukuti shiisho uChaala akuyugha sha nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","UChaala akamutuma uMwana ghwake ukuti ayughaghe amashu ghaagho amutumite pakuyugha paapo amupiile uMbepo uMwelu chishita chipimilo. ");
INSERT INTO ndh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","UChaala amughanite uMwana ghwake, soona amupiile amaka agha kulongosha utundu twoshi. ");
INSERT INTO ndh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Umundu ghweshi yuuyo akumwitika uYeesu, ali nu bhwumi ubhwa bhwila na bhwila, loole umundu ghweshi yuuyo akumukaana uYeesu, atali nu bhwumi ubhwa bhwila na bhwila paapo uChaala akwendelela ukumukalalila.” ");
INSERT INTO ndh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Po aBhafalisaayi bhakapulika ukuti uYeesu akubhoosha nu kubhaagha abhamanyili abhingi ukukinda uYoohani uMwoshi. ");
INSERT INTO ndh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ubhwanalooli bhwa kuti ataa ghwi Yeesu yuuyo akabhooshanga abhandu, loole bhamanyili bhaake bho bhaabho bhakabhooshanga. ");
INSERT INTO ndh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bhwo uYeesu aamanya ukuti inongwa isho shaafumukwa, umwene pamupeene na bhamanyili bhaake bhakatiilaamwo mu chiisu icha Yuteeya nu kubhuuka soona mu chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bhwo bhakubhuuka mu Ghalilaayi, uYeesu na bhamanyili bhaake bhakalondighwanga ukughendela mu chiisu icha Samaliiya. ");
INSERT INTO ndh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Po bhakafika mu chiisu icha Samaliiya, mu kaaya kaako bhakatingi Sikaali. Akaaya aka kakabha papiipi nu mughunda ghuughwo uYaakobhu akamupa umwana, uYoosefu. ");
INSERT INTO ndh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","UYaakobhu akakumba ichishima icha miishi mu mughunda ughwo ifyinja ifyingi ifya kunyuma. Ku nongwa iya bhulite ubhwa kughenda isila indali, uYeesu akiikala kulubhafu ku chishima icho ukuti atuushe. Isubha likabha lyafika pamutu (6:00). ");
INSERT INTO ndh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Po umukolo yumo uMusamaliiya akiisa ukuti asembe amiishi mu chishima chila. Bhwo uYeesu aamubhona, akamubhuula akati, “Ghwe nandembwa, ingusuuma amiishi ghamu agha kungʼwa.” ");
INSERT INTO ndh_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ku kabhalilo ako uYeesu akabha mwene paapo abhamanyili bhaake bhakabha bhaabhuuka mu kaaya pakughula ifindu. ");
INSERT INTO ndh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Po umukolo uMusamaliiya yula akamwamula uYeesu akati, “Kali, shili bhuleele ukuti ughwe ghwe Muyuuta usuumaghe amiishi kukwangu une ni Musamaliiya?” Umukolo uyo akayugha ulwo paapo aBhayuuta na Bhasamaliiya bhatakaliilagha mu kabhigha kamukeene. ");
INSERT INTO ndh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","UYeesu akamwamula akati, “Linga ghwameenye chiicho uChaala akulonda ukukupa nu kuti ghwini uyu akukusuuma amiishi ghamu agha kungʼwa, ngali ghwasuuma une, nuune ngali naakupa amiishi ghaagho ghakubhapa abhandu ubhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Umukolo yula akamwamula uYeesu akati, “Ghwe Malafyale, ughwe utali nu lughoye pamu ichiliilo icha kusembela amiishi, soona ichishima ichi chitali leka, po kali, indiughaaghe kuughu amiishi agho ghaagho ghakubhapa abhandu ubhwumi? ");
INSERT INTO ndh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kali, kwibhona ukubha ghwe songo ngaani ukumukinda usekulu ghwitu uYaakobhu yuuyo akatupa ichishima icha miishi ichi chiicho akangʼwanga na bhaana bhaake pamupeene ni finyamaana fyake ifya kusughighwa?” ");
INSERT INTO ndh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Po uYeesu akamwamula akati, “Umundu ghweshi yuuyo akungʼwa amiishi ghaagho ghakufuma mu chishima ichi, akwipulika inyoota soona. ");
INSERT INTO ndh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Loole umundu ghweshi yuuyo akungʼwa amiishi ghaagho une ingumupa, ataaakiipulike inyoota soona. Amiishi ghaagho une ingumupa, indighakabhe isa akashima aka miishi mukati mumwake kaako katakupwa naalumo nu kuti indighakamupe ubhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Po umukolo yula akamusuuma uYeesu akati, “Ghwe Malafyale, ingukusuuma ghuumbe amiishi ghaagho kughayugha ukuti manye niipulikaghe inyoota soona nu kuti indeke ukwisa pakusemba amiishi soona mu chishima ichi!” ");
INSERT INTO ndh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","UYeesu akamwamula akati, “Ghwe nandembwa, bhuuka umwitishe umulume ghwako ghwise naghwe panu.” ");
INSERT INTO ndh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Umukolo yula akamwamula akati, “Une indeeghiighwe.” UYeesu akamwamula akati, “Ghwayugha ubhwanalooli ukuti uteeghiighwe! ");
INSERT INTO ndh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Paapo ghweghighwa na bhaliisha bhahaano ukufika ulu, ghwepe umuliisha yuuyo kwikala naghwe ulu, ataa mulume ghwako.” ");
INSERT INTO ndh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Umukolo yula akamwamula uYeesu akati, “Ghwe Malafyale, naamanya ukuti ughwe ghwe musololi ukufuma kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Abhosekulu bhiitu bhakamwipuutagha uChaala mu kaghamba aka Ghelisimu aka, loole umwe mwe Bhayuuta mukuti tubhuukaghe pakumwipuuta uChaala ku Yelusaleemu. Kali, ubhwanalooli bhwo bhuliku?” ");
INSERT INTO ndh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","UYeesu akamwamula akati, “Ghwe nandembwa, itika ukuti shiisho inguyugha sha nalooli, akabhalilo kakwisa kaako mutaamukamwipuutaghe uTaata mu kaghamba aka pamu mu Nyumba iya Chaala iya ku Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Umwe mwe Bhasamaliiya mukumwipuutagha uChaala yuuyo mutamumeenye, loole utwe twe Bhayuuta tukumwipuutagha uChaala yuuyo tumumeenye paapo indiakabhapoke abhandu ukughendela ku Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Akabhalilo kakwisa, soona kiisile kaako abhandu bhaabho bhakumwipuuta uChaala nalooli indibhakamwipuutaghe ni ndumbula shaabho shooshi isa muumwo uMbepo uMwelu akubhalongosha na mu bhwanalooli bhwoshi. Paapo uChaala akubhalonda abhandu bhaabho bhakumwipuuta ku sila iyo. ");
INSERT INTO ndh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","UChaala ghwi Mbepo, abhandu bhaabho bhakumwipuuta, bhakulondighwa ukuti bhamwipuutaghe ni ndumbula shaabho shooshi isa muumwo uMbepo akubhalongosha na mu bhwanalooli bhwoshi.” ");
INSERT INTO ndh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Umukolo yula akamwamula uYeesu akati, “Imeenye ukuti uMesiiya yuuyo ghwi Kilisiti akwisa, soona imeenye ukuti linga iisa, indiakatulingaanie shooshi shiisho bhwighane bhwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Po uYeesu akamwamula akati, “Une nee inguyugha nuughwe, nee Kilisiti.” ");
INSERT INTO ndh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mu kabhalilo ako, abhamanyili bhaake bhakaghaluka ukufuma kuukwo bhakaya pakughula ifindu. Bhwo bhaafika, bhakaswigha leka bhwo bhakumwagha uYeesu akuyugha nu mukolo. Loole naayumo umumanyili yuuyo akamubhuusha uYeesu ukuti, “Kali, kulonda kooni kukwake?” Pamu ukuti, “Kali, kooni kuyugha naghwe?” ");
INSERT INTO ndh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Umukolo yula akayileka ingumbe yaake iya miishi pala pala, akabhuuka mu kaaya aka Sikaali. Bhwo aafika, akabhabhuula abhandu akati, ");
INSERT INTO ndh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tubhuuke mumuteshe umundu yuuyo aambuulite shooshi shiisho naashibhombagha. Kali, umundu uyo abhaghiile ukubha ghwi Mesiiya yuuyo tukumusubhaalila ukuti akwisa?” ");
INSERT INTO ndh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Po bhwo abhandu bhaapulika isho, bhakafuma mu kaaya ako nu kwanda ukubhuuka kuukwo uYeesu akabha. ");
INSERT INTO ndh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mu kabhalilo kala kala bhwo abhandu bhala bhakubhuuka kwa Yeesu, abhamanyili bhaake bhakamusuumagha bhakatingi, “Ghwe Mumanyishi, tukukusuuma ulye ifindu fimo fiifyo twafuma pakughula.” ");
INSERT INTO ndh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Loole umwene akabhaamula akati, “Une indi ni findu ifinine fiifyo umwe mutafimeenye.” ");
INSERT INTO ndh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Po abhamanyili bhaake bhakaanda ukubhuusania bheene-bheene bhakati, “Kali, aliikwo umundu yumo yuuyo iisile nu kumupa ifindu bhwo tutaliipo?” ");
INSERT INTO ndh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","UYeesu akabhaamula akati, “Ifindu fyangu une kwo kubhomba ubhwighane ubhwa Chaala nu kumaliisha imbombo yiiyo akaanduma pakuyibhomba. ");
INSERT INTO ndh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Umwe mukuyughagha mukutingi, ‘Yaashaala imyeshi minnaashe ukufika akabhalilo aka mwinulo.’ Loole une ingubhabhuula ukuti tesha akiisa mu mighunda, umwinulo ghwafika ukuti abhandu bhiinule. ");
INSERT INTO ndh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","UChaala indiakabhahombe umufwalo abhandu bhooshi bhaabho bhakwinula mu mughunda. Ku nongwa iya mbombo yaabho, abhandu indibhakabhwaghe ubhwumi ubhwa bhwila na bhwila. Po umundu ghweshi yuuyo akubhyala na yuuyo akwinula, bhooshi indibhakasekele pamupeene. ");
INSERT INTO ndh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ubhuyughi ubhu bhuubhwo bhukuti, ‘Umundu yumo akubhyala imbeyu nu munine akwinula,’ bhwa nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ingabhatuma umwe mu mughunda pakwinula fiifyo mutakabhyala. Abhandu abhanine bhakabhomba imbombo yooshi ingafu. Ku nongwa iyo, umwe mukusekelela iseke shaabho.” ");
INSERT INTO ndh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ABhasamaliiya abhingi ukufuma mu kaaya aka Sikaali kala bhakamwitika uYeesu ku nongwa iya kuti bhakapulika shiisho umukolo yula akayugha akati, “Umundu uyo aambuulite shooshi shiisho naashibhombagha.” ");
INSERT INTO ndh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Po bhwo aBhasamaliiya bhala bhaafika paapo uYeesu akabha, bhakamusuuma ukuti iikale pamupeene nabho, manye abhuukaghe. Ghwepe akiitika, umwene pamupeene na bhamanyili bhaake bhakiikala mu kaaya ako ku mashiku mabhili. ");
INSERT INTO ndh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mu kabhalilo ako, abhandu abhingi ngaani bhakamwitika ku nongwa iya shiisho akashiyughagha. ");
INSERT INTO ndh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Abhandu abho bhakamubhuula umukolo yula bhakati, “Tutakumwitika uYeesu ulu ku nongwa iya shiisho ghwatubhuulite sheene, loole tukumwitika ku nongwa iya kuti twapulika yutwetwe shiisho akuyugha. Ku nongwa iyo, twamanya ukuti nalooli umundu uyu ghwe yuuyo Mupoki ughwa chiisu.” ");
INSERT INTO ndh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bhwo amashiku mabhili ghaakinda, uYeesu na bhamanyili bhaake bhakatiila mu kaaya aka Sikaali nu kubhuuka mu chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Paapo uYeesu akabha ayughite ku bhamanyili bhaake ukuti umusololi atakughindikighwa na bhandu abha mu chiisu chaake. ");
INSERT INTO ndh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Abhandu abha mu chiisu icha Ghalilaayi bhakabhuuka ku chaaka icha Pasaka ku Yelusaleemu. Bhoope bhakashibhona shooshi shiisho uYeesu akashibhombagha. Ku nongwa iyo, bhwo uYeesu aafika mu Ghalilaayi, abhenekaaya bhakamupokeela akiisa. ");
INSERT INTO ndh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Po uYeesu akabhuuka soona mu kaaya aka Kana kaako kali mu chiisu icha Ghalilaayi. Mu kaaya ako mwo muumwo akasanusha amiishi ukubha ndifaayi. Akabhaamwo umulongoshi yumo ughwa silikali mu kaaya aka Kapenabhumu yuuyo umwana ghwake umulumyana akabha mubhine. ");
INSERT INTO ndh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Umulongoshi uyo akapulika ukuti uYeesu iisile soona mu Ghalilaayi ukufumila mu chiisu icha Yuteeya. Bhwo aapulika, akabhuuka kwa Yeesu nu kumusuuma ukuti abhuuke ku kaaya aka Kapenabhumu pakumuposha umwana ghwake yuuyo akabha papiipi nu kufwa. ");
INSERT INTO ndh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","UYeesu akamwamula umulongoshi yula akati, “Mwe bhandu umwe, kali, mutabhaghiile ukuunyiitika chishita kufibhona ifyika ifikulu?” ");
INSERT INTO ndh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Umulongoshi akamwamula uYeesu akati, “Ghwe Malafyale, ingukusuuma, tubhuuke umuposhe umwana ghwangu bhwo akaali ukufwa.” ");
INSERT INTO ndh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Loole uYeesu akamwamula akati, “Bhwelagha, umwana ghwako aapola.” Umulongoshi yula akalyitika ishu liilyo uYeesu akamubhuula, po akaanda ukubhwela kukaaya kukwake. ");
INSERT INTO ndh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bhwo umulongoshi yula ali mu sila akughenda, akakomaana na bhabhombi bhaake. Bhoope bhakamubhuula bhakati, “Umwana ghwako apolite, mukafuushe.” ");
INSERT INTO ndh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Po akabhabhuusha abhabhombi bhaake akati, “Kali, aandite ukupola ukwandila liighi?” Abheene bhakamwamula bhakati, “Aapolite ukwandila mumasubha pamuusi, mu sala iya bhuhaano na shibhili (7:00).” ");
INSERT INTO ndh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Po ughwise ughwa mulumyana yula akashaaghania ukuti, umwana ghwake aapolite ukwandila mu kabhalilo kala kalaashe kaako uYeesu aamubhuulite ukuti, “Umwana ghwako aapola.” Po umulongoshi yula pamupeene na bha mu nyumba yaake yooshi bhakamwitika uYeesu. ");
INSERT INTO ndh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ichi chikabha chiika icha bhubhili chiicho uYeesu akachibhomba mu chiisu icha Ghalilaayi bhwo aafuma mu chiisu icha Yuteeya. ");
INSERT INTO ndh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bhwo isho shaakinda, uYeesu akaghaluka ukubhuuka mu kaaya aka Yelusaleemu pakusekelela ichaaka icha Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mu kaaya ako, mukabhaamwo nu mulyango umukulu ghuughwo ingamu yaake bhakatingi Mulyango ughwa Bhonangʼooshi. Kupiipi nu mulyango ughwo pakabhaapo ni chishibha chiicho mu njugha iya Chihibhuli bhakatingi Bheetisata. Soona pakabhaapo na mabhalaasa mahaano ghaagho ghakabha ni mbanda. Amabhalaasa agho ghakachishunguulila ichishibha ichikulu icho. ");
INSERT INTO ndh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pa chiifuuni icha mabhalaasa agho, bhakaghonagha kupiipi ni chishibha abhabhine abhingi isa abhafwamaaso, abhochikwefu na bhalale bhwo bhakulindilila ukuti amiishi ghafulughanike. ");
INSERT INTO ndh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Paapo ughwandumi akiilomukagha akabhalilo kamu nu kufulughania amiishi. Po umubhine yuuyo akabhanga ghwa kwanda ukwingila mu miishi, akapolagha ubhubhine bhwoshi bhuubhwo akabha nabhwo. ");
INSERT INTO ndh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pa chishibha chila akabhaapo umundu yumo yuuyo akabha mubhine ku fyinja amalongo matatu, fihaano na fitatu (38). ");
INSERT INTO ndh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Po uYeesu akamubhona aghonite pala nu kumanya ukuti umundu yula mubhine ku kabhalilo akatali, akamubhuusha akati, “Kali, ughwe kulonda ukupola?” ");
INSERT INTO ndh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Umubhine yula akamwamula uYeesu akati, “Ghwe Malafyale, naayumo umundu ughwa kuunyaafwa ukuumbiika mu chishibha linga amiishi ghaafulughanika. Paapo linga ingulonda ukwingila mu chishibha, umundu umunine akutangila mundaashi mumwangu.” ");
INSERT INTO ndh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Po uYeesu akamubhuula umubhine yula akati, “Ghwe mwana ghwangu, iima, pimba ubhulili bhwako, bhuukagha.” ");
INSERT INTO ndh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nakalinga, umundu yula akapola ubhubhine bhwake, akapimba ubhulili bhwake, akaanda ukubhuuka. UYeesu akamuposha umundu uyo pi ishiku ilya Sabhati liilyo likabha lishiku lya kutuusha ku Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Po abhalongoshi abha Bhayuuta bhakamubhuula umundu yula yuuyo uYeesu akamuposha bhakati, “Umuusughu lishiku lya Sabhati liilyo lya kutuusha. Ku nongwa iyo indaghilo isha Moose shitakwitikisha umundu ukubhomba imbombo isa iya kupimba ubhulili.” ");
INSERT INTO ndh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Loole umundu yula akabhaamula akati, “Umundu yuuyo aamboshiishe ghwe yuuyo aambuulite ukuti imbimbe ubhulili nu kuti ingendaghe.” ");
INSERT INTO ndh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Po abhalongoshi bhala bhakamubhuusha bhakati, “Kali, ghwini yuuyo akubhuulite ukuti upimbe ubhulili nu kuti ughendaghe?” ");
INSERT INTO ndh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Loole umundu yula atakayimanya ingamu iya mundu yuuyo akamuposha ku nongwa iya kuti uYeesu akabha aatiila pa chilundilo icha bhandu chiicho chikabhaapo pala. ");
INSERT INTO ndh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ishiku lila lila bhwo akabhalilo kaakinda panandi, uYeesu akabhuuka nu kumwagha umundu yula mu lupaso ulwa Nyumba iya Chaala, akamusoka akati, “Pulikisha, ulu ghwapola. Manye ghwendelelaghe ukubhomba imbiibhi soona, paapo linga kwendelela ukubhomba imbiibhi, indiukalabhe ukwongelaapo ukukinda muumwo ghwalabhiile kubhwandilo.” ");
INSERT INTO ndh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Umundu yula akamuleka uYeesu nu kughaluka pakubhabhuula abhalongoshi abha Bhayuuta ukuti ingamu iya mundu yuuyo aamuposhiishe ghwi Yeesu. ");
INSERT INTO ndh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Po abhalongoshi abha Bhayuuta bhakaanda ukumutamya uYeesu ku nongwa iya kuti akabhaposhanga abhandu pi ishiku ilya Sabhati. ");
INSERT INTO ndh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Loole uYeesu akabhabhuula akati, “UChaala, uTaata akwendelela ukubhomba imbombo iya kubhaafwa abhandu akabhalilo kooshi ukufika umuusughu. Ku nongwa iyo, nuune ingwendelela ukuyibhomba imbombo iyo na pi ishiku ilya Sabhati.” ");
INSERT INTO ndh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ku nongwa iyo, abhalongoshi abha Bhayuuta bhakaanda ukulonda ku maka isila iya kumughogha uYeesu. Bhakalondagha ukumughogha paapo bhakatingi umwene atakashighindikagha indaghilo isha lishiku ilya Sabhati liilyo likabha lya kutuusha, soona akatingi uChaala ghwi Ghwise. Po ku sila iyo, uYeesu akiibhiika ukuti umwene agheliile nu Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","UYeesu akabhabhuula abhalongoshi bhala akati, “Nalooli ingubhabhuula, une ni Mwana ghwa Chaala indabhaghiile ukubhomba naakamu ku maka ghangu nimwene. Une ingubhomba shila sheene shiisho ingushibhona uTaata akubhomba, soona shooshi shiisho uTaata akubhomba, sho shiisho nuune ni Mwana ghwake ingubhomba. ");
INSERT INTO ndh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","UTaata aanganite une, yo yiiyo nongwa iyi akuundangisha imbombo shooshi shiisho akushibhomba, soona indiandangishe muumwo indiimbombaghe ifyika ifikulu ukukinda ukubhaposha abhandu, nuumwe indimuswighaghe. ");
INSERT INTO ndh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Isa muumwo uTaata akubhashuusha abhandu abhafwe nu kubhapa ubhwumi ubhwa bhwila na bhwila, bhubhuubhwo nuune ni Mwana ghwake ingumupa ubhwumi umundu ghweshi yuuyo niighanite. ");
INSERT INTO ndh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","UTaata atakumulonga umundu naayumo, loole amupiile uMwana ghwake amaka agha kubhalonga abhandu bhooshi. ");
INSERT INTO ndh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ku sila iyo, abhandu bhooshi indibhamughindike uMwana isa muumwo bhakumughindika uTaata. Umundu ghweshi yuuyo atakumughindika uMwana, po atakumughindika uTaata yuuyo aamutumite. ");
INSERT INTO ndh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nalooli ingubhabhuula, abhandu bhooshi bhaabho bhakughapulika amashu ghangu nu kumwitika uChaala yuuyo aandumite, bhali nu bhwumi ubhwa bhwila na bhwila. Indaaingabhalonge ku mbiibhi shaabho shiisho bhashibhombite, paapo bhalobhokite ukufuma ku bhufwe nu kwingila ku bhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nalooli ingubhabhuula, akabhalilo kakwisa, soona kafikite kaako abhafwe indibhapulike shiisho uMwana ughwa Chaala akuyugha. Po bhooshi bhaabho bhakupulika nu kwitika indibhakabhe nu bhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Isa muumwo uTaata ali na maka agha kumupa umundu ubhwumi ubhwa bhwila na bhwila, bhubhuubhwo akamupa uMwana amaka agha kubhapa abhandu ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Soona akamupa amaka agha kubhalonga abhandu ku nongwa iya kuti umwene Mwana ughwa Mundu. ");
INSERT INTO ndh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Manye muswighaghe amashu agho, paapo indikakiise akabhalilo kaako abhafwe bhooshi indibhakamupulike bhwo akubhiitisha. ");
INSERT INTO ndh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Abhafwe abho indibhakafume mu mapumba ghaabho. Bhooshi bhaabho bhakabhombagha imbombo inyiisa, uChaala indiakabhashuushe nu kubhapa ubhwumi ubhwa bhwila na bhwila. Loole bhooshi bhaabho bhakabhombagha imbiibhi, uChaala indiakabhashuushe ukuti bhalongighwe.” ");
INSERT INTO ndh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","UYeesu akeendelela ukubhabhuula abhalongoshi abha Bhayuuta akati, “Une indabhaghiile ukubhomba naakamu ku maka ghangu nimwene. Akabhalilo kooshi ingubhalonga abhandu ukukongana na muumwo uTaata akuumbuulila. Po linga ingumulonga umundu ghweshi, ubhulongi bhwangu bhwa nalooli paapo indakubhomba shiisho niighanite une, loole ingubhomba shiisho bhwighane bhwa Taata yuuyo aandumite. ");
INSERT INTO ndh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Linga ingubhabhuula umwe inongwa shangu yuneene, mutabhaghiile ukwitika ukuti shiisho inguyugha sha nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Loole uTaata ghwepe akushiyugha inongwa shangu kukwinyu, nuune imeenye ukuti shooshi shiisho akuunjugha une sha nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Umwe mukabhatuma abhandumi kwa Yoohani uMwoshi ukuti bhamubhuushikishe, ghwepe akaanjughagha une kukwinyu shiisho shikabha sha nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Une indakusubhaalila shiisho abhandu bhakuunjugha, loole ingubhabhuula shooshi isho ukuti muunyiitike nu kuti uChaala abhapoke ukufuma ku mbiibhi shiinyu. ");
INSERT INTO ndh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","UYoohani uMwoshi akalangisha ubhwanalooli kukwinyu isa muumwo inyaale yikubhalisha ubhwelu mu chiisi, nuumwe mukabhusekelela ubhwelu ubhwo ku kabhalilo akapimba. ");
INSERT INTO ndh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Loole imbombo shiisho ingubhomba shikuushimikisha muumwo imbeeliile nalooli, soona shikindite ngaani ku shiisho uYoohani akaashimikishanga une kukwinyu. Paapo imbombo shiisho uTaata akaamba ukuti ishibhombaghe sho shiisho shikulangisha ukuti uChaala, uTaata ghwe yuuyo aandumite. ");
INSERT INTO ndh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ghwepe uTaata yuuyo aandumite une, aashimikishiishe une kukwinyu. Umwe mutalipulikite naalumo ishu lyake pamu mutamubhweni naalumo muumwo abheeliile. ");
INSERT INTO ndh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mukukaana ukughabhiika amashu agha Chaala mu ndumbula shiinyu ku nongwa iya kuti mutakuunyiitika une nee uChaala aandumite kukwinyu. ");
INSERT INTO ndh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mukwikaakila ukubhelenga ku maka aMasimbo aMeelu ku nongwa iya kuti mukwinongʼona ukuti ku sila iyo mubhaghiile ukubhwagha ubhwumi ubhwa bhwila na bhwila. AMasimbo aMeelu ghoope ghakuushimikisha une. ");
INSERT INTO ndh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Loole mukukaana ukwisa kukwangu ukuti imbape ubhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","UYeesu akeendelela ukuyugha akati, “Indakusubhaalila imbaalo ukufuma ku bhandu, ");
INSERT INTO ndh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","loole imbameenye umwe muumwo mubheeliile ukuti mutali nu lughano ukufuma kwa Chaala mu ndumbula shiinyu. ");
INSERT INTO ndh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Une niisile ku ngamu iya Taata, loole mukukaana ukuumbokeela. Linga umundu umunine akwisa ku ngamu yaake mwene indimumwitike nu kumupokeela. ");
INSERT INTO ndh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kali, mubhaghiile ukuunyiitika bhuleele une bhwo mwighanite ukughindikana bheene-bheene, loole mutakwikaakila ukulonda ulughindiko luulwo lukufuma kwa Chaala mwene? ");
INSERT INTO ndh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Manye mwinongʼonaghe ukuti indiingabhasitaake kwa Taata ukuti mutakaanyiitikagha, nashiku, loole uMoose ghwe yuuyo indiakabhasitaake kwa Taata paapo ghwe yuuyo mumusubhaaliile. ");
INSERT INTO ndh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Linga nalooli mukamwitikagha uMoose ku shiisho akabhabhuulagha, po ngali muunyiitikite nuune paapo uMoose ghwe yuuyo akasimba inongwa shiisho shikuushimikisha une. ");
INSERT INTO ndh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kali, linga mutakwitika shiisho uMoose akasimba, po mubhaghiile ukwitika bhuleele shiisho inguyugha?” ");
INSERT INTO ndh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bhwo isho shaakinda, uYeesu na bhamanyili bhaake bhakaghaluka ku Ghalilaayi, bhakalobhoka nu kubhuuka ku isiila inine ilya sumbi ughwa Ghalilaayi yuuyo ingamu inine ghwi Tibheeliya. ");
INSERT INTO ndh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ichilundilo ichikulu icha bhandu chikamukongagha uYeesu ku nongwa iya kuti bhakafibhonagha ifyika fiifyo akafibhombagha ku bhandu abhabhine. ");
INSERT INTO ndh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Po bhwo bhaalobhoka usumbi, uYeesu na bhamanyili bhaake bhakakwela ku kaghamba nu kwikala pamupeene. ");
INSERT INTO ndh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Akabhalilo ako, ichaaka icha Pasaka iya Bhayuuta chikabha chipalamiile. ");
INSERT INTO ndh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bhwo uYeesu akaali ali ku kaghamba, akatesha nu kuchibhona ichilundilo ichikulu icha bhandu chiicho chikiisagha kukwake. Po akamubhuusha uFilipu akati, “Ghwe Filipu, kali, tubhaghiile ukughula kuughu imikati iya kubhaliisha abhandu bhooshi abha?” ");
INSERT INTO ndh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","UYeesu akamubhuusha uFilipu ulwo ukuti amughele, loole ubhwanalooli bhwa kuti umwene akabha ameenye muumwo abhaghiile ukubhomba ukuti afyaghe ifindu. ");
INSERT INTO ndh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","UFilipu akamwamula akati, “Nalinga tubhaghiile ukughula imikati iya ndinaali imya shibhili (200), poope fitabhaghiile ukubhayiilania abhandu abha ukuti ghweshi umundu apokeele finandi paapo bhingi lukulu.” ");
INSERT INTO ndh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Umumanyili umunine ughwa Yeesu, uNdeleeya, yuuyo akabha ghwi ghwamwabho ghwa Siimoni Peeteli, akamwamula uYeesu akati, ");
INSERT INTO ndh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ghwe Malafyale, aliipo umulumyana yumo panu yuuyo ali ni mikati mihaano iya shayili ni iswi shibhili inandi. Kali, ifindu ifinandi isa ifi fibhaghiile ukuchiyiilania ichilundilo chooshi ichi?” ");
INSERT INTO ndh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Po uYeesu akabhabhuula abhamanyili bhaake akati, “Bhabhuule abhandu bhiikale paase.” Pabhuyo bhula pakabhaapo ni chiposo ichingi. Po abhamanyili bhaake bhakabhabhuula abhandu bhala, bhoope bhakiikala paase bhooshi. Mu chilundilo chila, abhandu bhaabho bhakiikala bhakabha abhaliisha abhoelufu bhahaano (5,000). Mu chilundilo icho bhakabhaamwo abhakolo na bhaana, loole bhakabhabhelengagha abhaliisha bheene. ");
INSERT INTO ndh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Po uYeesu akeegha imikati yila, akapaalisha kwa Chaala. Bhwo aapaalisha, akabhayabhila abhandu bhooshi bhaabho bhakabhaapo pala. Po uYeesu akeegha ni iswi shila, akapaalisha kwa Chaala. Bhwo aapaalisha, akabhayabhila abhandu bhala. Abhandu bhooshi bhakalya nu kwikuta isa muumwo bhakalondelagha. ");
INSERT INTO ndh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bhwo abhandu bhooshi bhiikuta, uYeesu akabhabhuula abhamanyili bhaake akati, “Bhungaania utubhululusha utwa findu tuutwo twashaala ukuti manye kakomanike naakamu.” ");
INSERT INTO ndh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Po bhakabhungaania ifindu fyoshi fiifyo fikashaala ukufuma mu mikati mihaano iya shayili ni iswi shibhili nu kwisusha utupombo kalongo na tubhili (12). ");
INSERT INTO ndh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bhwo abhandu bhala bhaachibhona ichiika chiicho uYeesu akachibhomba, bhakayugha bhakati, “Nalooli umundu uyu musololi ukufuma kwa Chaala yuuyo tukasubhaalilagha ukuti akwisa mu chiisu ichi.” ");
INSERT INTO ndh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","UYeesu akamanya ukuti abhandu bhala bhakulonda ukumukola ukuti bhamubhiike abhe ghwi Malafyale ghwabho ku maka, loole umwene akatiila nu kubhuuka pakwikala mwene ku kaghamba. ");
INSERT INTO ndh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bhwo lyabha lya namasubha, abhamanyili abha Yeesu bhakiilomuka ukubhuuka kwa sumbi ughwa Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bhwo bhaafika, bhakiingila mu bhwato nu kwanda ukulobhoka usumbi ukubhuuka ku kaaya aka Kapenabhumu. Mu kabhalilo ako, ichiisi chikabha chaaghwa nu kuti uYeesu akabha akaali ukubha pamupeene nabho. ");
INSERT INTO ndh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Po inguli ingulu shikaanda ukubhukoma ubhwato ku nongwa iya chikungu chiicho chikakukagha mwa sumbi yula. ");
INSERT INTO ndh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bhwo abhamanyili abha Yeesu bhaafugha ubhwato ikilomiita ihaano pamu ihaano na yimo (6) ukufuma ku chiseese kwa sumbi, bhakamubhona uYeesu akughenda pamwanya pa miishi, akupalamila ku bhwato, po bhakooghopa leka. ");
INSERT INTO ndh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Loole uYeesu akabhabhuula akati, “Neene, manye mwoghopaghe!” ");
INSERT INTO ndh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Po bhakalondagha ukumupokeela uYeesu ukuti iingile mu bhwato, loole ubhwato bhukafika nakalinga ku chiisu ichikafu kuukwo bhakabhuukagha. ");
INSERT INTO ndh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ishiku liilyo likakongagha, ichilundilo icha bhandu bhaabho bhakashaala ku isiila inine ilya sumbi ughwa Ghalilaayi, bhakamanya ukuti bhukabhaapo ubhwato bhumobhweneeshe kula. Soona bhakamanya ukuti uYeesu atakiingila mu bhwato pamupeene na bhamanyili bhaake, loole abhamanyili bhala bhakabhuuka bheene mu bhwato bhula. ");
INSERT INTO ndh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Po abhandu bhamu bhakiisa na maato amanine ukufuma mu kaaya aka Tibheeliya nu kufika paapo ichilundilo icha bhandu bhakalya imikati bhwo uYeesu aamupaalisha uChaala. ");
INSERT INTO ndh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bhwo ichilundilo icha bhandu bhala bhaashaaghania ukuti uYeesu na bhamanyili bhaake bhataliipo pala, bhakiingila mu maato ghala nu kubhuuka ku kaaya aka Kapenabhumu pakumulonda uYeesu. ");
INSERT INTO ndh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bhwo abhandu bhala bhaamwagha uYeesu ku isiila inine ilya sumbi ughwa Ghalilaayi, bhakamubhuusha bhakati, “Ghwe Mumanyishi, kali, ghwisile liighi kuno?” ");
INSERT INTO ndh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","UYeesu akabhaamula akati, “Nalooli ingubhabhuula, imeenye ukuti mutakuundonda ku nongwa iya kuti mwafyaghaniishe ifyika fiifyo naabhombite, loole mukuundonda ku nongwa iya kuti naabhapiile imikati nuumwe mwaliile nu kwikuta. ");
INSERT INTO ndh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Manye mubhombelaghe imbombo ifindu fiifyo fikukomanika, loole bhombelagha imbombo ifindu fiifyo fikubhapa abhandu ubhwumi ubhwa bhwila na bhwila fiifyo uMwana ughwa Mundu indiabhape. Paapo umwene ghwe yuuyo uChaala amupiile amaka agha kubhomba ulwo.” ");
INSERT INTO ndh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Po abheene bhakamubhuusha bhakati, “Kali, tubhombe kooni ukuti tushibhombaghe imbombo shiisho uChaala akulonda?” ");
INSERT INTO ndh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ghwepe uYeesu akabhaamula akati, “Imbombo yiiyo uChaala akulonda ukuti muyibhombaghe ya kuti muunyiitikaghe une nee aandumite kukwinyu ukufuma kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bhakamubhuusha bhakati, “Kali, indiubhombe chiika chiki ukuti tuchibhone nu kwitika ukuti nalooli ufumite kumwanya? Kali, indiubhombe kooni? ");
INSERT INTO ndh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Abhosekulu bhiitu bhakalya ifindu ichikolo icha mana bhwo bhali mu lungalangala isa muumwo shisimbiighwe mu Masimbo aMeelu ukuti, ‘UMoose akabhapa umukati ukufuma kumwanya ukuti bhalye.’ ” ");
INSERT INTO ndh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Po uYeesu akabhabhuula akati, “Nalooli ingubhabhuula, ataa ghwi Moose yuuyo akabhapa abhosekulu bhiinyu ifindu ukufuma kumwanya, loole uTaata ghwe yuuyo akubhapa umwe ifindu ifya nalooli ukufuma kumwanya. ");
INSERT INTO ndh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Paapo ifindu ifya nalooli neene nee uChaala aandumite ukufuma kumwanya ukuti imbape ubhwumi ubhwa bhwila na bhwila abhandu bhaabho bhali mu chiisu ichi.” ");
INSERT INTO ndh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Po bhakamwamula bhakati, “Ghwe Malafyale, tukusuuma utupange ifindu ifya chikolo icho amashiku ghooshi.” ");
INSERT INTO ndh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","UYeesu akabhaamula akati, “Une nee findu fiifyo fikubhapa abhandu ubhwumi ubhwa bhwila na bhwila. Umundu ghweshi yuuyo akwisa kukwangu nu kuunyiitika, ataaakapulike naalumo isala ni nyoota. ");
INSERT INTO ndh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Loole une ingabhabhuula ukuti pamupeene nu kuti mufibhweni ifyika fiifyo ifibhombite, poope mukaali mutakuunyiitika. ");
INSERT INTO ndh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abhandu bhooshi bhaabho uTaata akuumba, indibhiise kukwangu nu kuunyiitika, nuune indaaingamukaane umundu ghweshi yuuyo akwisa kukwangu. ");
INSERT INTO ndh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Paapo une ingiisa ukufuma kumwanya ukuti imbombaghe shiisho bhwighane bhwa Taata yuuyo aandumite. Indakiisa ukuti imbombaghe shiisho bhwighane bhwangu. ");
INSERT INTO ndh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Soona bhwighane bhwa Taata yuuyo aandumite ukuti manye imusofye naayumo mu bhala bhaabho aambiile, loole imbashuushe bhabhe bhuumi pi ishiku ilya bhumalilo ilya bhulongi ubhwa chiisu. ");
INSERT INTO ndh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Paapo uTaata akulonda ukuti abhandu bhooshi bhaabho bhakushaaghania ukuti une nee Mwana ghwake nu kuunyiitika, bhabhange nu bhwumi ubhwa bhwila na bhwila. Nuune indiingabhashuushe soona pi ishiku ilya bhumalilo ilya bhulongi ubhwa chiisu.” ");
INSERT INTO ndh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Po aBhayuuta bhakaanda ukwibhuniisha ku nongwa iya kuti uYeesu akati, “Une nee mukati ghuughwo uChaala atumite ukufuma kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhakabhuusania bheene-bheene bhakati, “Kali, umundu uyu ataa ghwi Yeesu, umwana ughwa Yoosefu yuuyo tubhameenye na bhapaapi bhaake bhooshi? Po kali, abhaghiile bhuleele ukuyugha ukuti, ‘Ifumite kumwanya’?” ");
INSERT INTO ndh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","UYeesu akabhaamula akati, “Leka ukwibhuniisha mwibheene-bheene. ");
INSERT INTO ndh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Naayumo umundu yuuyo abhaghiile ukwisa kukwangu linga uTaata yuuyo aandumite atamulongoshiishe. Nuune indiingamushuushe soona pi ishiku ilya bhumalilo ilya bhulongi ubhwa chiisu. ");
INSERT INTO ndh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Paapo abhasololi bhakasimba mu bhokalata bhaabho ukuti, ‘UChaala indiakabhamanyishe abhandu bhooshi.’ Po umundu ghweshi yuuyo akupulikisha nu kumanyila ukufuma kwa Taata, umundu uyo akwisa kukwangu nu kuunyiitika une. ");
INSERT INTO ndh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Naayumo umundu yuuyo amubhweni uChaala uTaata, loole une nimwene neene imubhweni paapo ifumite kukwake. ");
INSERT INTO ndh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nalooli ingubhabhuula, umundu ghweshi yuuyo akuunyiitika une, ali nu bhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Une nee findu fiifyo fikubhapa abhandu ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pamupeene nu kuti abhosekulu bhiinyu bhakalya ifindu ichikolo icha mana bhwo bhali mu lungalangala, poope bhakafwa isa abhandu abhanine. ");
INSERT INTO ndh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Loole panu filiipo ifindu fiifyo fifumite kwa Chaala. Linga umundu aalya ifindu ifyo, ataaakafwe naalumo. ");
INSERT INTO ndh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Une nee findu ukufuma kumwanya fiifyo fikubhapa abhandu ubhwumi. Umundu ghweshi yuuyo akulya ifindu ifi, indiabhange nu bhwumi ubhwa bhwila na bhwila. Ifindu ifi mubhili ghwangu ghuughwo indiingutiishe ku bhandu abha chiisu ichi ukuti bhabhange nu bhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Po aBhayuuta bhakaanda ukukaanikana bheene-bheene nu kubhuusania bhakati, “Kali, umundu uyu abhaghiile bhuleele ukutupa umubhili ghwake ukuti tughulye?” ");
INSERT INTO ndh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Loole uYeesu akabhabhuula akati, “Nalooli ingubhabhuula, linga mutakulya umubhili nu kungʼwa ibhanda ilya Mwana ughwa Mundu, mutaamubhange nu bhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Umundu ghweshi yuuyo akulya umubhili ghwangu nu kungʼwa ibhanda lyangu ali nu bhwumi ubhwa bhwila na bhwila, nuune indiingamushuushe soona pi ishiku ilya bhumalilo ilya bhulongi ubhwa chiisu. ");
INSERT INTO ndh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Paapo umubhili ghwangu findu ifya nalooli ni ibhanda lyangu chakungʼwa icha nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Umundu ghweshi yuuyo akulya umubhili ghwangu nu kungʼwa ibhanda lyangu, indieendelelaghe ukwikala pamupeene nuune, nuune indineendelelaghe ukwikala pamupeene naghwe. ");
INSERT INTO ndh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Isa muumwo uTaata yuuyo aandumite une mwumi, nuune nee mwumi ku nongwa iya Taata. Bhubhuubhwo, umundu ghweshi yuuyo akuundya une, indiabhange mwumi ku nongwa yangu. ");
INSERT INTO ndh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Po une nee findu fiifyo fyilomukite paase ukufuma kumwanya. Ifindu ifi fitagheliile ni findu fiifyo abhosekulu bhiinyu bhakalya, poope bhakafwa. Loole umundu ghweshi yuuyo akulya ifindu ifi, indiabhange nu bhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","UYeesu akashiyugha isho bhwo ali pakumanyisha mu sinaghoghi ku kaaya aka Kapenabhumu kula. ");
INSERT INTO ndh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bhwo bhaamupulika akuyugha isho, abhingi mu bhamanyili bhaake bhakayughisania bheene-bheene bhakati, “Ifimanyisho ifi fikafu leka! Kali, ghwini yuuyo abhaghiile ukufyitika?” ");
INSERT INTO ndh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bhwo uYeesu aashaaghania ukuti abhamanyili bhaake bhakwibhuniisha ku shiisho ayughite, akabhabhuusha akati, “Kali, linga ifimanyisho ifi fikubhapela umwe ukuti muleke ukuunyiitika, ");
INSERT INTO ndh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","po indishikabhe bhuleele linga mukumubhona uMwana ughwa Mundu akukwela ukubhuuka kumwanya kuukwo akabha kubhwandilo? ");
INSERT INTO ndh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","UMbepo ughwa Chaala ghwe yuuyo akubhapa abhandu ubhwumi ubhwa bhwila na bhwila. Umundu atabhaghiile ukubhomba naakamu ku maka ghaake mwene. Amashu ghaagho naabhabhuula ghakufuma kwa Mbepo uMwelu, soona gho ghaagho uMbepo uMwelu akughabhombela ukubhapa abhandu ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Loole bhaliipo bhamu pakati papiinyu bhaabho bhakukaana ukuunyiitika.” UYeesu akayugha ulwo paapo akamanya ukwandila kubhwandilo ukuti bhooni bhaabho indibhakaane ukumwitika, nu kuti ghwini yuuyo indiamubhiike mu tukono utwa bhalughu. ");
INSERT INTO ndh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Po akeendelela ukuyugha akati, “Yo yiiyo nongwa iyo naabhabhuula ukuti naayumo umundu yuuyo abhaghiile ukwisa kukwangu linga uTaata yuuyo aandumite atamulongoshiishe.” ");
INSERT INTO ndh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ukufuma akabhalilo kala bhwo uYeesu aayugha amashu agho, abhingi mu bhamanyili bhaake bhakamuleka nu kushita kumukonga soona. ");
INSERT INTO ndh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Po uYeesu akabhabhuusha kalongo na bhabhili (12) bhala akati, “Kali, nuumwe mukulonda ukuundeka?” ");
INSERT INTO ndh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","USiimoni Peeteli akamwamula akati, “Ghwe Malafyale, kali, ghwini umunine yuuyo tubhaghiile ukubhuuka kukwake? Ughwe ghwimwene uli na mashu ghaagho ghakutupa ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Utwe tukwitika, soona tumeenye ukuti ughwe ghwe Mwelu ghwe ufumite kwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Po uYeesu akabhabhuula akati, “Ingabhasala umwe kalongo na bhabhili ukubha bhamanyili bhangu, loole yumo pakati papiinyu akulongoshighwa nu Seetano.” ");
INSERT INTO ndh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Panu uYeesu akamuyughagha ghwi Yuuta, umwana ughwa Siimoni Isikaliyooti. Uyo ghwe yuuyo akabhuukagha pakumubhiika uYeesu mu tukono utwa bhalughu pamupeene nu kuti akabha ghwe yumo mu bhamanyili kalongo na bhabhili bhala. ");
INSERT INTO ndh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Po bhwo isho shaakinda, uYeesu akaanda ukushunguulila mu twaya utwa mu chiisu icha Ghalilaayi. Atakalondagha ukushunguulila mu chiisu icha Yuteeya ku nongwa iya kuti abhalongoshi abha Bhayuuta bhaabho bhakabha mu chiisu icho, bhakalondagha ukumughogha. ");
INSERT INTO ndh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Akabhalilo aka chaaka icha Fitembe icha Bhayuuta kakabha kaapalamila. ");
INSERT INTO ndh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Po abhanungʼuna abha Yeesu bhakamubhuula bhakati, “Tiilaapo panu, ubhuuke ku Yuteeya ukuti abhamanyili bhaako bhaye bhafibhone ifyika fiifyo kubhomba. ");
INSERT INTO ndh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Umundu atakubhombagha imbombo shaake ku bhushiifu linga akulonda ukufumukwa ku bhandu. Linga nalooli ubhaghiile ukubhomba shooshi ishi, po ilangisha ku bhandu bhooshi abha pa chiisu ichi ukuti bhakumanye.” ");
INSERT INTO ndh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Abhanungʼuna bhaake bhakayugha ulwo paapo bhoope bhatakamwitikagha uYeesu ukuti ghwi Kilisiti. ");
INSERT INTO ndh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Po uYeesu akabhaamula akati, “Akabhalilo kangu une aka kubhuuka kakaali katafikite, loole umwe mubhaghiile ukubhuuka akabhalilo kooshi. ");
INSERT INTO ndh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Abhandu abha mu chiisu ichi bhatabhaghiile ukubhakalalila umwe, loole bhakuungalalila une paapo ingubhabhuula ukuti shiisho bhakushibhomba mbiibhi. ");
INSERT INTO ndh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kwelagha mwibheene ukubhuuka ku Yelusaleemu pakusekelela ichaaka. Une indakubhuuka ku chaaka ichi paapo akabhalilo kangu kakaali ukufika.” ");
INSERT INTO ndh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bhwo uYeesu aayugha isho, akashaala mu chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Loole bhwo abhanungʼuna abha Yeesu bhaabhuuka ku Yelusaleemu pakusekelela ichaaka, uYeesu ghwepe akakwela ukubhuuka ku Yelusaleemu loole chishita kwilangisha pabhwelu. ");
INSERT INTO ndh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Po bhwo bhali pa chaaka, abhalongoshi abha Bhayuuta bhakamulondagha uYeesu. Bhakabhabhuusha abhandu bhaabho bhakabhaapo pala bhakati, “Kali, ali kuughu umundu uyo yuuyo bhakumwitisha bhakuti ghwi Yeesu?” ");
INSERT INTO ndh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Abhandu abhingi ukufuma mu chilundilo chila bhakakaanikanagha ku nongwa iya Yeesu. Bhamu bhakatingi uYeesu mundu mwisa, loole abhanine bhakatingi uYeesu mundu yuuyo akubhashimbula abhandu. ");
INSERT INTO ndh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Po naayumo umundu yuuyo akamuyughagha uYeesu pabhwelu ku nongwa iya kubhooghopa abhalongoshi abha Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bhwo amashiku agha kusekelela ichaaka icha Fitembe icho ghaafika pakati, uYeesu akabhuuka, akiingila mu lupaso ulwa Nyumba iya Chaala nu kwanda ukubhamanyisha abhandu. ");
INSERT INTO ndh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Po abhalongoshi abha Bhayuuta bhakaswigha nu kwanda ukuyughisania bheene-bheene bhakati, “Kali, umundu uyu abhaghiile ukushimanya bhuleele shooshi isho bhwo atamanyiile naalumo ku bhamanyi abha ndaghilo?” ");
INSERT INTO ndh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Po uYeesu akabhaamula akati, “Ifimanyisho fiifyo ingumanyisha fitaa fyangu, loole fikufuma kwa Chaala yuuyo akaanduma kukwinyu. ");
INSERT INTO ndh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Umundu ghweshi yuuyo akulonda ukubhomba shiisho uChaala iighanite, indiashaaghanie ukuti ifimanyisho ifi fifumite kwa Chaala pamu inguyugha ku maka ghangu. ");
INSERT INTO ndh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Umundu ghweshi yuuyo akuyugha ku maka ghaake, akwilondela ubhukulumba bhwake mwene. Loole yuuyo akulonda ubhukulumba ubhwa yula yuuyo amutumite, akuyugha bhwanalooli, bhutaa bhumyashi. ");
INSERT INTO ndh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mushimeenye ukuti pamupeene nu kuti uMoose akabhapa abhosekulu bhiinyu indaghilo isha Chaala ukuti mushikongaghe, loole poope naayumo umundu pakati papiinyu yuuyo akushikonga indaghilo isho. Po kali, kooni mukulonda isila iya kuungogha?” ");
INSERT INTO ndh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bhwo uYeesu aayugha isho, ichilundilo icha bhandu chikamwamula chikati, “Ughwe ukoliighwe ni mbepo imbiibhi! Kali, ghwini yuuyo akulonda ukukughogha?” ");
INSERT INTO ndh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","UYeesu akabhaamula akati, “Naabhombite ichiika chimo pi ishiku ilya Sabhati, umwe mweshi mwanyomokite nu kukalala. ");
INSERT INTO ndh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","UMoose akabhalaghila umwe ukubhakwesula abhaana bhiinyu abhaliisha. Ataa ghwi Moose yuuyo akaandisha ulwiho ulwa kukwesula, loole bhosekulu bhiinyu. Ulu umwe mukubhakwesula abhaana bhiinyu abhaliisha na pi ishiku ilya Sabhati. ");
INSERT INTO ndh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Linga mukubhakwesula abhaana bhiinyu abhaliisha na pi ishiku ilya Sabhati ukuti mukongaghe indaghilo shiisho uMoose akabhapa, po kali, kooni mukuungalalila une ku nongwa iya kumuposha umundu pi ishiku ilya Sabhati? ");
INSERT INTO ndh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Manye mumulongaghe umundu ukuti mutulanongwa ku nongwa iya shiisho shikubhoneka kuuse, loole mumulongaghe umundu ukukongana na shiisho sha nalooli pandaashi pa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Po abhandu bhamu bhaabho bhakiikalagha mu kaaya aka Yelusaleemu bhakaanda ukubhuusania bheene-bheene bhakati, “Kali, umundu uyu ataa ghwi Yeesu yuuyo abhalongoshi bhakulonda ukumughogha? ");
INSERT INTO ndh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tesha, ulu akuyugha pabhweluushe, poope abheene bhatakumubhuula naalimo! Kali, abhalongoshi bhabhaghiile ukubha bhashimeenye nalooli ukuti uYeesu ghwe yuuyo ghwi Kilisiti? ");
INSERT INTO ndh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Loole utwe tumumeenye umundu uyu kuukwo akufuma. Linga uKilisiti akwisa, naayumo umundu yuuyo indiakamanye kuukwo akufumila.” ");
INSERT INTO ndh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bhwo uYeesu ali pakumanyisha mu lupaso ulwa Nyumba iya Chaala, akayugha ku ishu ilya pamwanya akati, “Nalooli muumeenye une, soona mumeenye na kuukwo ifumite. Une indakiisa ku maka ghangu, loole uChaala yuuyo aandumite ghwe yuuyo ghwa nalooli, nuumwe mutamumeenye. ");
INSERT INTO ndh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Une imumeenye uChaala paapo ifumite kukwake, soona ghwe yuuyo aandumite kukwinyu.” ");
INSERT INTO ndh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bhwo abhalongoshi bhala bhaapulika isho, bhakalonda isila iya kumukola, loole atakabhaapo umundu yuuyo akasulwa ukumukola ku nongwa iya kuti akabhalilo kaake kakabha kakaali ukufika. ");
INSERT INTO ndh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Loole abhandu abhingi bhaabho bhakabha mu chilundilo chila bhakamwitika uYeesu, bhakabhuusha bhakati, “Kali, linga uMesiiya aaya iisa, indiakabhombe ifyika ifyingi ukukinda fiifyo umundu uyu aafibhomba?” ");
INSERT INTO ndh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bhwo aBhafalisaayi bhaachipulika ichilundilo icha bhandu bhakuteketa ku sha Yeesu, abheene pamupeene na bhosongo abha bhapuuti bhakabhatuma abhalindilili abha Nyumba iya Chaala ukuti bhamukole. ");
INSERT INTO ndh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Po uYeesu akabhabhuula abhandu bhala akati, “Indiimbe pamupeene nuumwe ku kabhalilo akapimbaashe bhwo ingaali ukughaluka ukubhuuka kukwake yuuyo akaanduma. ");
INSERT INTO ndh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Indimukaandondaghe, loole mutaamukaanyaaghaghe, soona mutabhaghiile ukwisa kuukwo indiingabhe.” ");
INSERT INTO ndh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Po abhalongoshi bhala bhakabhuusania bheene-bheene bhakati, “Kali, umundu uyu indiabhuuke kuughu kuukwo utwe tutabhaghiile ukumwagha? Kali, indiabhuuke ku Bhayuuta bhaabho bhanyambaanite mu twaya utwa bhaabho bhataa Bhayuuta nu kubhamanyisha? ");
INSERT INTO ndh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kali, akulonda ukutubhuula sha kooni ku mashu ghaake agha akuti, ‘Indimukaandondaghe, loole mutaamukaanyaaghaghe, soona mutabhaghiile ukwisa kuukwo indiingabhe’?” ");
INSERT INTO ndh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pi ishiku ilya bhumalilo ilya chaaka icha Fitembe, uYeesu akiima mu lupaso ulwa Nyumba iya Chaala, akayugha ku ishu ilya pamwanya nu kubhabhuula abhandu akati, “Umundu ghweshi yuuyo akwipulika inyoota, po iise kukwangu nuune indiimupe amiishi ghaagho ghakumupa ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Umundu ghweshi yuuyo akwisa pakungʼwa nu kuunyiitika une, indiakabhe isa muumwo shisimbiighwe mu Masimbo aMeelu ukuti, ‘Isooko isha miishi ghaagho ghakubhapa abhandu ubhwumi ubhwa bhwila na bhwila indishikafumaghe mu ndumbula yaake.’ ” ");
INSERT INTO ndh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","UYeesu akayughagha isooko isha miishi ukumulingaania uMbepo ughwa Chaala yuuyo bhooshi bhaabho bhakamwitika uYeesu, bhakabhuukagha pakumupokeela. Ku kabhalilo ako, uChaala akabha akaali ukumutuma uMbepo ghwake kukwabho ku nongwa iya kuti uChaala akabha akaali ukumupa ubhukulumba uYeesu. ");
INSERT INTO ndh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bhwo abhandu bhamu bhaabho bhakabha mu chilundilo chila bhaapulika amashu agho, bhakaanda ukuyugha bhakati, “Nalooli umundu uyu musololi.” ");
INSERT INTO ndh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Abhandu abhanine bhakati, “Umundu uyu ghwi Mesiiya.” Loole abhanine bhakati, “Nashiku, umundu uyu ataa ghwi Mesiiya, paapo uMesiiya atabhaghiile ukufuma mu chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Paapo shisimbiighwe mu Masimbo aMeelu ukuti uMesiiya indiakafume mu chikolo icha malafyale uNdaabhiti nu kuti indiakapaapighwe mu kaaya aka Bheetelehemu, akaaya kaako umalafyale uNdaabhiti akiikalagha.” ");
INSERT INTO ndh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Po abhandu bhakayabhanika ku nongwa iya Yeesu. ");
INSERT INTO ndh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bhamu bhakalondagha ukumukola uYeesu, loole naayumo umundu yuuyo akasulwa ukumweghelesha. ");
INSERT INTO ndh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pabhumalilo abhalindilili abha Nyumba iya Chaala bhala bhakaghaluka ku bhosongo abha bhapuuti na ku bha Bhafalisaayi bhaabho bhakabhatuma. Bhwo bhaaghaluka chishita kumukola uYeesu, abhalongoshi abha Bhayuuta bhakabhabhuusha abhalindilili bhala bhakati, “Kali, kooni mutaamukolagha uYeesu nu kwisa naghwe?” ");
INSERT INTO ndh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Abhalindilili bhala bhakabhaamula abhalongoshi bhaabho bhakati, “Twapooshitwe ukumukola ku nongwa iya kuti ataliipo umundu yuuyo akuyugha ku maka isa muumwo umundu yula akuyughila.” ");
INSERT INTO ndh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ABhafalisaayi bhakabhabhuusha bhakati, “Kali, uYeesu aabhashimbula nuumwe? ");
INSERT INTO ndh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kali, aliipo umulongoshi yumo pamu uMufalisaayi yumo yuuyo amwitikite uYeesu? ");
INSERT INTO ndh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Loole ichilundilo icha bhandu bhaabho bhakumwitika uYeesu bho bhala bhatashimeenye indaghilo isha Moose. Ku nongwa iyo, uChaala abhaghunite abhandu abho.” ");
INSERT INTO ndh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Po uNikondeemu, yumo mu bhalongoshi abha Bhafalisaayi, yuuyo akabhuuka ishiku limo pabhushiku kwa Yeesu akabhalilo aka kunyuma, akabhabhuusha abhanine akati, ");
INSERT INTO ndh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kali, indaghilo isha Moose shikutwitikisha ukumulonga umundu linga tutaamupulikisha taashi nu kushaaghania shiisho akubhomba?” ");
INSERT INTO ndh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Abheene bhakamwamula uNikondeemu bhakati, “Kali, nuughwe ufumite mu Ghalilaayi? Bhuuka ubhelenge soona akiisa aMasimbo aMeelu, po nuughwe indiushaaghanie ukuti naayumo umusololi yuuyo abhaghiile ukufuma mu chiisu icha Ghalilaayi.” ");
INSERT INTO ndh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Po abhandu bhooshi bhakaghaluka mu twaya twabho. Loole uYeesu akatiila mu lupaso ulwa Nyumba iya Chaala nu kubhuuka ku kaghamba aka Mishunguti. ");
INSERT INTO ndh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bhwo bhwacha pangeelo, uYeesu akabhuuka soona nu kwingila mu lupaso ulwa Nyumba iya Chaala. Abhandu bhooshi bhakabhuuka kukwake, po akiikala nu kwanda ukubhamanyisha. ");
INSERT INTO ndh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bhwo uYeesu ali pakumanyisha, abhamanyishi abha ndaghilo isha Moose na Bhafalisaayi bhakabhuuka kukwake nu mukolo yumo yuuyo akakolighwa mu bhushipani nu kumwimika pakati papaabho. ");
INSERT INTO ndh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Po bhakamubhuula uYeesu bhakati, “Ghwe Mumanyishi, umukolo uyu akoliighwe bhwo ali pakushipana. ");
INSERT INTO ndh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ukukongana ni ndaghilo isha Moose, uMoose akatulaghila ukumughogha umukolo ughwa luko ulu ku sila iya kumukoma na mayondo. Kali, ughwe kuti kooni?” ");
INSERT INTO ndh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Abheene bhakamubhuusha ulwo uYeesu ukuti bhamuteghele nu kuyaagha isila iya kumusitaakila. Loole bhwo uYeesu akaali atabhaamwile naalimo, akafulamila paase, akasimba pi ilongwi na kakono kaake. ");
INSERT INTO ndh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bhwo bhakwendelela ukumubhuusha, po uYeesu akiima, akabhaamula akati, “Linga aliipo yumo pakati papiinyu yuuyo atatuliteemwo inongwa naalumo, po abhe ghwa kwanda ukumukoma ni iyondo umukolo uyu.” ");
INSERT INTO ndh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Po uYeesu akafulamila paase soona nu kusimba pi ilongwi. ");
INSERT INTO ndh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bhwo bhaapulika isho, bhakaanda ukutiilaapo yumo yumo, ukwandila abhosongo ukufika abhalumyana. Pabhumalilo uYeesu akashaala mwene nu mukolo yuuyo akiima mundaashi mumwake. ");
INSERT INTO ndh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Po uYeesu akiima nu kumubhuusha umukolo yula akati, “Ghwe maayi, kali, bhali kuughu abhandu bhaabho bhakukusitaaka? Kali, ataliipo naayumo yuuyo aashaala ukuti akulonge?” ");
INSERT INTO ndh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Umukolo yula akamwamula akati, “Ghwe Malafyale, ataliipo naayumo.” Po uYeesu akamubhuula umukolo yula akati, “Nuune indakukulonga. Bhuukagha, loole ukwandila ulu, manye ubhombaghe imbiibhi soona.” ");
INSERT INTO ndh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Po uYeesu akeendelela ukuyugha soona ku Bhafalisaayi akati, “Une indi ungati bhwelu ku bhandu bhaabho bhali mu chiisu. Umundu ghweshi yuuyo akuungonga une, ataaaghendaghe mu chiisi naalumo, loole indiabhange nu bhwelu bhuubhwo bhukupela ubhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ABhafalisaayi bhakamubhuula uYeesu bhakati, “Ughwe kwiyughila ghwimwene chishita umundu umunine ukushishimikisha shiisho kushiyugha. Ku nongwa iyo, shiisho kushiyugha shitakutukola naakamu.” ");
INSERT INTO ndh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","UYeesu akabhaamula akati, “Nalinga ingwiyughila yuneene, shiisho inguyugha sha nalooli paapo imeenye kuukwo ingafuma, soona imeenye na kuukwo ingubhuuka. Loole umwe mutameenye kuukwo ingafuma pamu kuukwo ingubhuuka. ");
INSERT INTO ndh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Umwe mukuundonga une ukubhombela ifipimilo ifya bhandu, loole une indakumulonga umundu naayumo. ");
INSERT INTO ndh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Loole linga une ingumulonga umundu, ingumulonga mu bhwanalooli paapo indakubha nimwene, loole ingubha nu Taata yuuyo akaanduma. ");
INSERT INTO ndh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mu ndaghilo shiinyu shiisho uMoose akabhapa shisimbiighwe ukuti, ‘Ubhukeeti ubhwa bhandu bhabhili bhukwitikishighwa ukuti bhwanalooli.’ ");
INSERT INTO ndh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ku sila iyi, une ingwiyughila yuneene nu Taata yuuyo akaanduma ghwe yuuyo mukeeti ghwangu.” ");
INSERT INTO ndh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Po aBhafalisaayi bhakamubhuusha uYeesu bhakati, “Kali, ughuuso ali kuughu?” UYeesu akabhaamula akati, “Mutaameenye une pamu uTaata. Linga mwamanyagha une ukuti nee ghwini, po ngali mumumeenye nu Taata.” ");
INSERT INTO ndh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","UYeesu akayugha shooshi isho bhwo ali pakumanyisha mu lupaso ulwa Nyumba iya Chaala pabhuyo bhuubhwo bhakasengulagha amabhokoshi agha ndalama. Loole naayumo umundu yuuyo akamukola paapo akabhalilo kaake kakabha kakaali ukufika. ");
INSERT INTO ndh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Po uYeesu akabhabhuula soona aBhafalisaayi bhala akati, “Une ingubhuuka, umwe indimukaandondaghe, loole indimukafwile mu mbiibhi shiinyu. Umwe mutabhaghiile ukwisa kuukwo une ingubhuuka.” ");
INSERT INTO ndh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Po bhakaanda ukubhuusania bheene-bheene bhakati, “Kali, akubhuuka pakwighogha? Kali, yo yiiyo nongwa iyi akuti, ‘Umwe mutabhaghiile ukwisa kuukwo une ingubhuuka’?” ");
INSERT INTO ndh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","UYeesu akeendelela ukubhabhuula akati, “Umwe mufumite paase panu, loole une ifumite kumwanya. Umwe mwe bha pa chiisu ichi, loole une indaa nee ghwa pa chiisu ichi. ");
INSERT INTO ndh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Po ingubhabhuula ukuti indimukafwile mu mbiibhi shiinyu. Paapo linga mutakuunyiitika ukuti une neene, indimukafwile mu mbiibhi shiinyu.” ");
INSERT INTO ndh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Po bhakamubhuusha uYeesu bhakati, “Tubhuule ubhwanalooli, kali, ughwe ghwe ghwini?” UYeesu akabhaamula akati, “Une neene isa muumwo imbabhuuliile ukufuma kubhwandilo. ");
INSERT INTO ndh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Indi nasho inyingi isha kubhayugha ni sha kubhalonga umwe, loole indaaimbombe ulwo. Paapo yuuyo akaanduma akuyugha ubhwanalooli, po nuune ingubhabhuula abhandu abha mu chiisu ichi inongwa shila sheene shiisho ishipulikite ukufuma kukwake.” ");
INSERT INTO ndh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Abheene bhatakashaaghania ukuti uYeesu akayughagha nabho ku sha Ghwise ughwa kumwanya. ");
INSERT INTO ndh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Po uYeesu akabhaamula akati, “Linga mwaya mwamukwesha uMwana ughwa Mundu pa chikobhekano ukuti mumughoghe, po indimukamanye ukuti une neene uChaala akaanduma. Soona indimukamanye ukuti shooshi shiisho ingubhomba, indakubhomba ku maka ghangu, loole ingushiyugha shiisho uTaata aamanyishiishe. ");
INSERT INTO ndh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","UChaala yuuyo akaanduma ali pamupeene nuune, ataandekite nimwene paapo akabhalilo kooshi ingushibhomba shiisho shikumuhobhosha.” ");
INSERT INTO ndh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bhwo uYeesu ali pakuyugha isho, abhandu abhingi bhakamwitika. ");
INSERT INTO ndh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Po uYeesu akabhabhuula aBhayuuta bhala bhaabho bhakamwitika akati, “Linga mukushibhombela shiisho ingubhamanyisha, po indimubhange bhamanyili bhangu nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Soona indimubhumanyaghe ubhwanalooli bhuubhwo bhukufuma kwa Chaala. Po ku sila iya bhwanalooli ubhwo, uChaala indiabhabhiikaghe ukubha bhaabhuke.” ");
INSERT INTO ndh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bhoope bhakamubhuusha bhakati, “Utwe tuli bhiisukulu bha Abhulahamu. Tutabhombiteemwo naalumo ku mundu ungati bhatumwa. Kali, kooni kuyugha ukuti utwe inditubhe bhaabhuke?” ");
INSERT INTO ndh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","UYeesu akabhaamula akati, “Nalooli ingubhabhuula, umundu ghweshi yuuyo akwendelela ukubhomba imbiibhi, akushibhombela imbiibhi ungati mutumwa. ");
INSERT INTO ndh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Umutumwa atakwikala mu nyumba iya songo ghwake amashiku ghooshi, loole umwana ughwa songo, uyo ghwe yuuyo akushaala mu nyumba amashiku ghooshi. ");
INSERT INTO ndh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Po linga une ni Mwana ughwa Chaala naabhaabhula ku mbiibhi shiinyu, mutaamukabhange bhatumwa soona, loole indimukabhange bhaabhuke nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Imeenye ukuti umwe muli bhiisukulu bha Abhulahamu, loole mukulonda isila iya kuungogha une ku nongwa iya kuti mukukaana ukushiitika shiisho ingubhamanyisha. ");
INSERT INTO ndh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Une ingubhabhuula inongwa shiisho ishibhweni ukufuma kwa Taata, loole umwe mukushibhomba shiisho ughuuso abhamanyishiishe.” ");
INSERT INTO ndh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bhoope bhakamwamula uYeesu bhakati, “Utwe twe bhiisukulu bha Abhulahamu.” UYeesu akabhaamula akati, “Linga nalooli mwe bhiisukulu bha Abhulahamu, po ngali mukushibhomba shiisho uAbhulahamu akabhombagha. ");
INSERT INTO ndh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Loole ulu mukulonda isila iya kuungogha une pamupeene nu kuti naabhabhuula ubhwanalooli bhuubhwo naapulikite ukufuma kwa Chaala. UAbhulahamu atakabhomba isa shiisho umwe mukulonda ukuumbombela. ");
INSERT INTO ndh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Imbombo shiisho mukushibhomba shikufuma kwa ghuuso umunine yuuyo ataa ghwi Abhulahamu.” ABhayuuta bhala bhakamwamula uYeesu bhakati, “Utwe tutaa twe bhosoosi, loole uChaala mwene ghwe yuuyo ghwi Taata.” ");
INSERT INTO ndh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","UYeesu akabhaamula akati, “Linga uChaala akabhanga ghwi Ghuuso, po ngali muunganite paapo une ingafuma kwa Chaala loole ulu indi pa chiisu. Une indakiisa ku nongwa iya bhwighane bhwangu, loole ku nongwa iya bhwighane ubhwa Chaala yuuyo akaanduma. ");
INSERT INTO ndh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kali, kooni mutakushaaghania shiisho inguyugha? Ishi shili ulu ku nongwa iya kuti mutakulonda ukushiitika shiisho ingubhamanyisha. ");
INSERT INTO ndh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Umwe muli isa ughuuso uSeetano, nuumwe mukulonda ukubhomba shiisho ughuuso akushilonda. USeetano mughoghi ukufuma muumwo uChaala akapelela ichiisu, soona atakulonda ukubhumanya ubhwanalooli ku nongwa iya kuti ubhwanalooli bhutaliimwo mu ndumbula yaake. Linga uSeetano akuyugha ubhumyashi, ako ko kaako kayiilo kaake paapo umwene mumyashi soona ghwe yuuyo bhwandilo ubhwa bhumyashi bhwoshi. ");
INSERT INTO ndh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Loole ku nongwa iya kuti une ingubhabhuula shiisho sha nalooli ukufuma kwa Chaala, yo yiiyo nongwa iyi mutakuunyiitika. ");
INSERT INTO ndh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kali, ghwini pakati papiinyu yuuyo abhaghiile ukushimikisha ukuti une nee mutulanongwa? Linga shiisho ingubhabhuula sha nalooli ukufuma kwa Chaala, po kali, kooni mutakuunyiitika? ");
INSERT INTO ndh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Umundu ghweshi yuuyo ghwa Chaala, akushikonga shiisho uChaala akuyugha. Loole umwe mutakushipulika nu kushikonga shiisho uChaala akuyugha ku nongwa iya kuti umwe mutaa bhandu bhaake.” ");
INSERT INTO ndh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ABhayuuta bhakamubhuusha uYeesu bhakati, “Kali, tutakuyugha bhwanalooli linga tukuti ughwe ghwe Musamaliiya nu kuti ukoliighwe ni mbepo imbiibhi?” ");
INSERT INTO ndh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","UYeesu akabhaamula akati, “Une indakoliighwe ni mbepo imbiibhi. Une ingumughindika uTaata, loole umwe mukuufuyula. ");
INSERT INTO ndh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Indakulonda ukuti abhandu bhaambaalaghe. Aliipo yuuyo akulonda ukuti abhandu bhaambaalaghe une, soona ghwe yuuyo indiakabhe mulongi ughwa nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nalooli ingubhabhuula, umundu ghweshi yuuyo akushibhombela imbombo shiisho ingumanyisha, ataaakafwe naalumo.” ");
INSERT INTO ndh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Po aBhayuuta bhakamubhuula uYeesu bhakati, “Ulu twamanya ukuti ughwe ukoliighwe ni mbepo imbiibhi! UAbhulahamu na bhasololi abha Chaala bhakafwa, loole ughwe kuti, ‘Umundu ghweshi yuuyo akushibhombela imbombo shiisho ingumanyisha, ataaakafwe naalumo.’ ");
INSERT INTO ndh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kali, ughwe kwibhiika ukubha ghwe songo ukukinda usekulu ghwitu uAbhulahamu yuuyo akafwa? Abhasololi abha Chaala bhoope bhakafwa. Kali, ughwe kwibhiika ukubha ghwe ghwini?” ");
INSERT INTO ndh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","UYeesu akabhaamula akati, “Linga ingwilondela ulughindiko yuneene, ulughindiko ulwo lutali ni mbombo naayimo. Loole uTaata yuuyo umwe mukuti ghwi Chaala ghwinyu, ghwe yuuyo akuungindika une. ");
INSERT INTO ndh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Poope mukaali mutamumeenye uChaala, loole une imumeenye. Linga inguyugha ukuti indamumeenye uChaala, po bhwo nee mumyashi isa muumwo umwe mukuti mumumeenye. Loole une imumeenye uChaala, soona ingushikonga shiisho akuyugha. ");
INSERT INTO ndh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Usekulu ghwinyu uAbhulahamu akasekela leka ku nongwa iya kwinongʼona ukuti akabhone akabhalilo kangu aka kwisa pa chiisu panu, ghwepe akakabhona, akasekela leka.” ");
INSERT INTO ndh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Po aBhayuuta bhakamubhuusha uYeesu bhakati, “Ughwe ukaali utafikishiishe ni fyinja amalongo mahaano (50), po kali, ukamubhona bhuleele uAbhulahamu?” ");
INSERT INTO ndh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","UYeesu akabhaamula akati, “Nalooli ingubhabhuula, une ingabha mwumi bhwo uAbhulahamu akaali ukupaapighwa.” ");
INSERT INTO ndh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bhwo aBhayuuta bhaapulika isho, bhakasebha amayondo ukuti bhamukome nagho nu kumughogha, loole uYeesu akiimama nu kufumaamwo mu lupaso ulwa Nyumba iya Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Po ishiku limo bhwo uYeesu akughenda pamupeene na bhamanyili bhaake, akamubhona umundu yumo yuuyo akabha mufwamaaso ukufuma muumwo akapaapighwa. ");
INSERT INTO ndh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abhamanyili bhaake bhakamubhuusha bhakati, “Ghwe Mumanyishi, kali, kooni umundu uyu akapaapighwa mufwamaaso? Kali, nongwa ya kuti akatula inongwa pamu bhapaapi bhaake bhakatula inongwa?” ");
INSERT INTO ndh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","UYeesu akabhaamula akati, “Ubhufwamaaso bhwake bhutakiisa ku nongwa iya kuti akatula inongwa pamu abhapaapi bhaake bhakatula inongwa. Loole akapaapighwa mufwamaaso ukuti amaka agha Chaala ghabhoneke ku bhandu mu bhwumi bhwake. ");
INSERT INTO ndh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tukulondighwa ukubhomba imbombo isha Chaala yuuyo aandumite bhwo pakaali po pamuusi. Ubhushiku bhukwisa bhuubhwo naayumo umundu yuuyo abhaghiile ukubhomba imbombo. ");
INSERT INTO ndh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bhwo ingaali indi pa chiisu ichi, une indi ungati bhwelu ku bhandu bhaabho bhali mu chiisu ichi.” ");
INSERT INTO ndh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bhwo uYeesu aayugha isho, akafwila amati pi ilongwi, akoongaania ilongwi na mati, akamusheema mu maaso umufwamaaso yula. ");
INSERT INTO ndh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Po akamubhuula umufwamaaso yula akati, “Bhuuka usukusule ku maaso mu chishibha icha Siloghwamu.” Isanusho ilya Siloghwamu kwo kuti, “Yuuyo atumiighwe.” Po umufwamaaso akabhuuka, akasukusula ku maaso, akaghaluka kukaaya kaake bhwo akutesha. ");
INSERT INTO ndh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Po abhapalamani bhaake na bhanine bhaabho bhakamubhonagha kubhwandilo bhwo akusuumilisha, bhakabhuusania bheene-bheene bhakati, “Kali, umundu uyu ataa ghwe yula akiikalagha nu kusuumilisha?” ");
INSERT INTO ndh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bhamu bhakati, “Umundu uyu ghwe yuuyo.” Abhanine bhakati, “Umundu uyu ataa ghwe yuuyo, loole akoliine naghwe leka.” Loole umwene akabhabhuula akati, “Mwo muumwo, une neene ingabha mufwamaaso kubhwandilo.” ");
INSERT INTO ndh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Po bhakamubhuusha bhakati, “Linga ghweghwe nalooli, po kali, amaaso ghaako ghaandite ukutesha bhuleele?” ");
INSERT INTO ndh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Umwene akabhaamula akati, “Umundu yumo yuuyo ingamu yaake ghwi Yeesu, aafwilite amati ghaake pi ilongwi, oongaaniishe ni ilongwi, aasheemite mu maaso ghangu. Po aambuulite aatiile, ‘Bhuuka usukusule ku maaso mu chishibha icha Siloghwamu.’ Po naabhuukite, naasukuswile, naandite ukutesha.” ");
INSERT INTO ndh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Po bhakamubhuusha bhakati, “Kali, umundu uyo ali kuughu?” Ghwepe akabhaamula akati, “Une indameenye kuukwo ali.” ");
INSERT INTO ndh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Po abhandu bhala bhakamwegha umundu yula yuuyo akabha mufwamaaso kubhwandilo nu kubhuuka naghwe ku Bhafalisaayi. ");
INSERT INTO ndh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ishiku liilyo uYeesu akatendekesha imbonda nu kumuposha umufwamaaso yula likabha lya Sabhati. ");
INSERT INTO ndh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Po aBhafalisaayi bhoope bhakamubhuusha umundu yula bhakati, “Kali, amaaso ghaako ghaandite ukutesha bhuleele?” Akabhaamula akati, “Umundu yumo aasheemite imbonda mu maaso, naasukuswile, naandite ukutesha.” ");
INSERT INTO ndh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Po aBhafalisaayi bhamu bhakati, “Umundu uyo atafumite kwa Chaala paapo atakukonga indaghilo isha Sabhati liilyo lishiku lya kutuusha.” Loole abhanine bhakati, “Kali, shibhaghiile bhuleele ku mundu yuuyo mutulanongwa ukubhomba ifyika ifyo?” Po bhakayabhanika bheene-bheene. ");
INSERT INTO ndh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Po aBhafalisaayi bhakamubhuusha soona bhakati, “Kali, kumubhona bhuleele umundu uyo yuuyo aakuposhiishe amaaso ghaako?” Umwene akabhaamula akati, “Une ingumubhona umundu uyo ukubha musololi ghwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Abhalongoshi abha Bhayuuta poope bhatakiitikagha ukuti umundu uyo akapaapighwa mufwamaaso kubhwandilo nu kuti ulu akutesha ukufika paapo bhakabhiitisha abhapaapi bhaake. ");
INSERT INTO ndh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bhwo abhapaapi bhaake bhaafika, abhalongoshi bhala bhakabhabhuusha bhakati, “Kali, umundu uyu mwana ghwinyu? Linga bhwo shili, kali, mukushimikisha ukuti akapaapighwa mufwamaaso? Linga bhwo shili, po kali, amaaso ghaake ghaandite ukutesha bhuleele?” ");
INSERT INTO ndh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Po abhapaapi bhaake bhakabhaamula bhakati, “Utwe tumeenye ukuti uyu mwana ghwitu nalooli, soona tukushimikisha ukuti akapaapighwa mufwamaaso. ");
INSERT INTO ndh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Loole tutameenye muumwo aandiile pakutesha, soona tutamumeenye nu mundu yuuyo aamuposhiishe amaaso ghaake. Mubhuushe yuuyo, paapo mundu ghwi songo, abhaghiile ukuyugha yuuyo mwene.” ");
INSERT INTO ndh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abhapaapi bhaake bhakayugha ulwo ku nongwa iya kuti bhakabhooghopagha abhalongoshi abha Bhayuuta, paapo aBhayuuta bhakiitikana ukuti umundu ghweshi yuuyo akwitika ukuti uYeesu ghwi Mesiiya, bhakumukiisha mu sinaghoghi. ");
INSERT INTO ndh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yo yiiyo nongwa iyi abhapaapi bhaake bhakati, “Mubhuushe yuuyo, paapo mundu ghwi songo, abhaghiile ukuyugha yuuyo mwene.” ");
INSERT INTO ndh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Po abhalongoshi abha Bhayuuta bhakamwitisha ulwa bhubhili umundu yuuyo akabha mufwamaaso kubhwandilo, bhakamubhuula bhakati, “Loolika kwa Chaala ukuti indiuyughe ubhwanalooli! Utwe tumeenye ukuti umundu uyo yuuyo aakuposhiishe mutulanongwa.” ");
INSERT INTO ndh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Po umundu yula akabhaamula akati, “Une indameenye ukuti umundu uyo mutulanongwa, loole imeenye limolyeneeshe ukuti naali mufwamaaso, loole ulu ingutesha.” ");
INSERT INTO ndh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Po bhakamubhuusha bhakati, “Kali, umundu uyo aabhombite bhuleele pakukuposha amaaso ghaako?” ");
INSERT INTO ndh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Umwene akabhaamula akati, “Une naabhabhuulite muumwo aambombiile, loole mutaalondagha ukwitika shiisho naayughite. Po kali, kooni mukulonda imbabhuule soona? Kali, nuumwe mukulonda ukubha bhamanyili bhaake?” ");
INSERT INTO ndh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Po abheene bhakamutuka bhakati, “Yughweghwe ghwe mumanyili ghwake, loole utwe twe bhamanyili bha Moose. ");
INSERT INTO ndh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tumeenye ukuti uChaala akayugha nu Moose, loole umundu uyo tutameenye na kuukwo afumite.” ");
INSERT INTO ndh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Akabhaamula akati, “Une inguswigha leka! Umwe mutameenye kuukwo afumite, loole umwene aamboshiishe amaaso ghangu! ");
INSERT INTO ndh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tumeenye ukuti uChaala atakushipulika inyipuuto isha bhatulanongwa, loole akumupulika umundu ghweshi yuuyo akumughindika nu kubhomba ukukongana nu bhwighane bhwake. ");
INSERT INTO ndh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ukwandila muumwo uChaala akapelela ichiisu, tutapulikiteemwo naalumo ukuti umundu akumuposha amaaso umundu yuuyo apaapiighwe mufwamaaso. ");
INSERT INTO ndh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Linga umundu uyo atakafumagha kwa Chaala, po ngali atabhombite isho.” ");
INSERT INTO ndh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Abheene bhakamwamula bhakati, “Ughwe ukapaapighwa nu kusungighwa ungati mutulanongwa. Kali, ubhaghiile ukutumanyisha bhuleele utwe?” Po bhakamukiisha ukufuma mu sinaghoghi. ");
INSERT INTO ndh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bhwo uYeesu aapulika ukuti abhalongoshi abha Bhayuuta bhaamukiisha umundu yula ukufuma mu sinaghoghi, akabhuuka pakumulonda. Bhwo aamwagha, akamubhuusha akati, “Kali, kumwitika uMwana ughwa Mundu?” ");
INSERT INTO ndh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Umundu yula akamwamula akati, “Ghwe Malafyale, kali, uMwana ughwa Mundu ghwe ghwini ukuti imwitikaghe?” ");
INSERT INTO ndh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","UYeesu akamwamula akati, “Ughwe umubhweni, soona uyu ghwe yuuyo akuyugha nuughwe.” ");
INSERT INTO ndh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Umundu yula akayugha akati, “Ingukwitika, Malafyale.” Po akafughamila pandaashi pa Yeesu nu kumwipuuta. ");
INSERT INTO ndh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Po uYeesu akayugha akati, “Une ingiisa pa chiisu ichi pakubhalonga abhandu ukuti bhaabho bhafwamaaso bhateshange, loole bhala bhaabho bhakwibhona ukuti bhakutesha, bhabhange bhafwamaaso.” ");
INSERT INTO ndh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Po bhwo aBhafalisaayi bhamu bhaabho bhakabhaapo pala bhaamupulika uYeesu akuyugha isho, bhakamubhuusha bhakati, “Kali, nuutwe twe bhafwamaaso?” ");
INSERT INTO ndh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","UYeesu akabhaamula akati, “Linga mwali bhafwamaaso ngali mutali ni mbiibhi, loole ulu mukuti, ‘Tukutesha,’ bhwo mutakutesha, uChaala ataaakabhahobhokele imbiibhi shiinyu.” ");
INSERT INTO ndh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","UYeesu akeendelela ukuyugha akati, “Nalooli ingubhabhuula, umundu ghweshi yuuyo atakwingilila pa mulyango ughwa chibhagha icha bhonangʼooshi, loole akukwela pa chibhagha pabhuyo ubhunine, umundu uyo mwifi soona mughoghi. ");
INSERT INTO ndh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Loole umundu yuuyo akwingilila pa mulyango ughwa chibhagha, uyo ghwe yuuyo muliishi ghwa bhonangʼooshi. ");
INSERT INTO ndh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Umulindilili ughwa chibhagha akumwighulila ichiighi umuliishi ughwa bhonangʼooshi uyo. Ghwepe umuliishi akwanda ukumwitisha ghweshi unangʼooshi ingamu yaake nu kubhalongosha ukufuma kuuse. ");
INSERT INTO ndh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Linga aabhafumya kuuse, akutangila mundaashi mu bhonangʼooshi ukuti aye abhaliishe, bhoope bhakumukongagha paapo bhalimeenye ishu lyake. ");
INSERT INTO ndh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Abhonangʼooshi bhatabhaghiile ukumukonga umundu umuheesha, loole bhakumukinda ku nongwa iya kuti bhatalimeenye ishu lyake.” ");
INSERT INTO ndh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","UYeesu akabhabhuula aBhafalisaayi ichifwanikisho ichi, loole abheene bhatakashaaghania shiisho akabhabhuulagha. ");
INSERT INTO ndh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Po uYeesu akabhabhuula soona akati, “Nalooli ingubhabhuula, une indi ungati mulyango ghuughwo abhonangʼooshi bhakwingilila mu chibhagha. ");
INSERT INTO ndh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhooshi bhaabho bhakiisa nu kwibhiika ukubha bhaliishi abha bhonangʼooshi bhwo une ingaali ukwisa, abho bhakabha bhiifi soona bhapoka ifya bhandu, loole abhonangʼooshi bhatakabhapulikishanga. ");
INSERT INTO ndh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Une indi ungati mulyango ghuughwo abhonangʼooshi bhakwingilila mu chibhagha. Unangʼooshi ghweshi yuuyo akwingila mu chibhagha ukughendela kukwangu, indiakapokighwe, soona indiakabhe mwabhuke ukwingila nu kufuma ukuti ayaaghe indeka inyiisa. ");
INSERT INTO ndh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Umwifi akwisa mu chibhagha ku nyango iya kwibha abhonangʼooshi, ukubhaghogha nu kukomania. Loole une niisile ukuti bhabhange nu bhwumi, soona bhabhange nabhwo ubhwingi. ");
INSERT INTO ndh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Une indi ungati muliishi umwisa yuuyo iifumyishe ukufwa ku nongwa iya kubhapoka abhonangʼooshi bhaake. ");
INSERT INTO ndh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Umundu ughwa chibhalula yuuyo ataa muliishi ghwa bhonangʼooshi, soona abhonangʼooshi bhataa bhaake, linga aamubhona undekelakatu akwisa, akukinda nu kubhaleka abhonangʼooshi bheene. Po undekelakatu akubhakola abhonangʼooshi bhamu na bhanine bhakunyambaana. ");
INSERT INTO ndh_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Umundu ughwa chibhalula yula akukinda nu kubhaleka abhonangʼooshi paapo ameenye ukuti bhataa bhaake. ");
INSERT INTO ndh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Une nee muliishi umwisa. Imbameenye akiisa abhonangʼooshi bhangu, bhoope bhaameenye. ");
INSERT INTO ndh_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Isa muumwo uTaata aameenye une, nuune imumeenye, bhubhuubhwo nuune niifumyishe ukufwa ku nongwa iya kubhapoka abhonangʼooshi bhangu. ");
INSERT INTO ndh_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Une indi na bhonangʼooshi abhanine bhaabho bhataliimwo mu chibhagha ichi, bhoope ingulondighwa niise nabho. Abhonangʼooshi abho, bhoope indibhakalimanye ishu lyangu. Ku sila iyo, indighukabhe mutiimo ghumoghwene ghuughwo indighukabhe nu muliishi yumoywene. ");
INSERT INTO ndh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“UTaata aanganite paapo niifumyishe ukufwa ku nongwa iya bhandu, loole indiingabhe mwumi soona. ");
INSERT INTO ndh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Naayumo umundu yuuyo abhaghiile ukuungogha linga une indiitikishiishe. Une neene niifumyishe ukuti ingoghighwe. Une indi na maka agha kwitikisha ukuti ingoghighwe soona indi na maka agha kubha mwumi soona. Paapo umwo mwo muumwo uTaata aandaghiile ukuti imbombaghe.” ");
INSERT INTO ndh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bhwo bhaapulika amashu agho, aBhayuuta bhakaleghana soona mu njugha pakati papaabho. ");
INSERT INTO ndh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Abhingi mu Bhayuuta abho bhakayugha bhakati, “Uyu ali ni mbepo imbiibhi yiiyo yimupeliile ichifunde. Ku nongwa iyo, manye mumupulikishange.” ");
INSERT INTO ndh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Loole abhanine bhakayugha bhakati, “Umundu yuuyo ali ni mbepo imbiibhi atabhaghiile ukuyugha amashu agho, soona imbepo imbiibhi yitabhaghiile ukumupela umufwamaaso ukuti ateshange!” ");
INSERT INTO ndh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Po akabhalilo aka lusekelo ulwa Bhayuuta ulwa kukumbuka ukuyisaya iNyumba iya Chaala ulwa bhubhili kakafika ku Yelusaleemu kula. Akabhalilo ako kakabha ka mbepo. ");
INSERT INTO ndh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mu kabhalilo ako, uYeesu akashunguulilagha mu lupaso ulwa Nyumba iya Chaala mu ibhalaasa liilyo bhakatingi Libhalaasa lya Solomooni. ");
INSERT INTO ndh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bhwo aBhayuuta bhamu bhaamubhona uYeesu, bhakamushunguulila nu kwendelela ukumubhuusha bhakati, “Kali, indiututamye mu ndumbula shiitu ukufika liighi? Linga nalooli ughwe ghwe Mesiiya, tubhuule pabhwelu.” ");
INSERT INTO ndh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Loole uYeesu akabhaamula akati, “Une imbabhuulite ukuti nee ghwini, loole umwe mukukaana ukuunyiitika. Ifyika fiifyo ingubhomba ku maka agha Taata fyo fiifyo fikulangisha ukuti une nee ghwini. ");
INSERT INTO ndh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Loole mukukaana ukufyitika ni fyika ku nongwa iya kuti umwe mutaa bha chibhughutila icha bhonangʼooshi bhangu. ");
INSERT INTO ndh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Abhonangʼooshi bhangu bhalimeenye ishu lyangu. Une imbameenye akiisa, bhoope bhakuungonga. ");
INSERT INTO ndh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Une ingubhapa ubhwumi ubhwa bhwila na bhwila, bhoope bhataabhakasobheemwo naalumo. Soona ataliipo umundu yuuyo abhaghiile ukubhapoka ku maka ukufuma mu tukono twangu. ");
INSERT INTO ndh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ku nongwa iya kuti uTaata yuuyo aambiile abho ali na maka ukukinda bhooshi, po ataliipo umundu yuuyo abhaghiile ukubhapoka mu tukono twake. ");
INSERT INTO ndh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Une nu Taata tuli pamupeene.” ");
INSERT INTO ndh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Po bhwo aBhayuuta bhamu bhaapulika isho, bhakaanda ukusebha amayondo soona ukuti bhamukome nu kumughogha uYeesu. ");
INSERT INTO ndh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Loole uYeesu akabhabhuula akati, “Naabhalangisha imbombo ingulu inyiisa ukubhombela amaka agha Taata. Kali, chiika chiki chiicho chikubhapela umwe ukuti muungome na mayondo?” ");
INSERT INTO ndh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ABhayuuta bhakamwamula bhakati, “Tutakulonda ukukukoma na mayondo ku nongwa iya kuti ubhombite ifyika ifikulu, loole ku nongwa iya kuti kumufuyula uChaala. Paapo ughwe kwiyugha ukuti ghwe Chaala bhwo ghwe munduushe ungati bhandu abhanine!” ");
INSERT INTO ndh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","UYeesu akabhaamula akati, “Kali, shitasimbiighwe mu bhokalata bhiinyu abha ndaghilo ukuti uChaala akati, ‘Umwe mwe bhochaala’? ");
INSERT INTO ndh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Shisimbiighwe mu Masimbo aMeelu ukuti abhandu bhaabho bhakayipokeela indumi iya Chaala, uChaala akabhiitishanga ukubha bhochaala. Nuutwe tumeenye ukuti shiisho shisimbiighwe mu Masimbo aMeelu sha nalooli amashiku ghooshi. ");
INSERT INTO ndh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kali, kooni mukuyugha ukuti une ingumufuyula uChaala paapo inguti, ‘Une nee Mwana ghwa Chaala’? UTaata ghwe yuuyo aasalite nu kuunduma pa chiisu ichi. ");
INSERT INTO ndh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Linga indakubhomba imbombo isha Taata shiisho akushibhomba, po manye muunyiitikaghe. ");
INSERT INTO ndh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Loole linga ingushibhomba imbombo shiisho uTaata akushibhomba, nalinga mutakushiitika shiisho inguyugha, po shiitikaghe imbombo isho. Ku sila iyo, po indimumanye ukuti uTaata ali pamupeene nuune, nuune indi pamupeene nu Taata.” ");
INSERT INTO ndh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Po bhwo aBhayuuta bhamu bhaapulika isho, bhakalondagha ukumukola soona, loole uYeesu akatyelemuka mu tukono twabho. ");
INSERT INTO ndh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Po uYeesu akabhuuka soona ku isiila ilya lusooko ulwa Yoolotani, akafika paapo uYoohani akooshanga kubhwandilo, akiikala ukwo ku mashiku manandi. ");
INSERT INTO ndh_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bhwo uYeesu akaali ali kula kula, abhandu abhingi bhakamwisila nu kuyugha bhakati, “UYoohani atakabhomba ichiika naachimo, loole inongwa isha Yeesu shooshi shiisho akashiyughagha, sha nalooli.” ");
INSERT INTO ndh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Po abhandu abhingi bhaabho bhakabhaapo pala bhakamwitika uYeesu. ");
INSERT INTO ndh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Akabhaakwo umundu yumo yuuyo ingamu yaake akabha ghwi Laasalo. ULaasalo akabha mubhine. Umundu uyo akiikalagha mu kaaya aka Bheetaniya pamupeene na bhalumbu bhaake uMaliiya nu Maalita. ");
INSERT INTO ndh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","UMaliiya uyo yuuyo umukulu ghwake uLaasalo akabha mubhine, ghwe yuuyo akamusululila uMalafyale inyemba isha kunuukila nu kumupuupula ulufumbi mu tulundi ni chingʼwili chaake. ");
INSERT INTO ndh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Po uMaliiya nu Maalita bhakatuma indumi kwa Yeesu bhakati, “Ghwe Malafyale, tukukubhuula ukuti umumanyani ghwako uLaasalo mubhine.” ");
INSERT INTO ndh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bhwo uYeesu aapokeela indumi iyo, akayugha akati, “Ubhubhine ubhwo bhutaa bhwa kumughogha uLaasalo, loole bhwa kulangisha ubhukulumba ubhwa Chaala nu kuti une ni Mwana ghwake imbaalighwange na bhandu ukughendela ubhubhine ubhwo.” ");
INSERT INTO ndh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","UYeesu akabhasaaghilagha leka uMaalita na bhoghwamwabho uMaliiya nu Laasalo. ");
INSERT INTO ndh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bhwo uYeesu aapulika ukuti uLaasalo mubhine, amashiku mabhili ghakakinda bhwo akaali ali pabhuyo bhula bhula paapo akabha. ");
INSERT INTO ndh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Po bhwo amashiku mabhili agho ghaakinda, uYeesu akabhabhuula abhamanyili bhaake akati, “Tubhuuke soona mu chiisu icha Yuteeya.” ");
INSERT INTO ndh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abhamanyili bhaake bhakamwamula bhakati, “Ghwe Mumanyishi, luluulushe abhalongoshi abha Bhayuuta bhaalondagha ukukukoma na mayondo ukuti ufwe, kali, kooni kulonda ukubhuuka soona ku Yuteeya?” ");
INSERT INTO ndh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","UYeesu akabhaamula akati, “Kali, umuusi ghutali ni isala kalongo na shibhili (12)? Linga umundu akughenda mu kabhalilo ako, atabhaghiile ukwipuutula akalundi kaake paapo ubhwelu bhukumwafwa ukutesha utundu twoshi utwa pa chiisu ichi. ");
INSERT INTO ndh_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Loole umundu yuuyo akughenda pabhushiku, abhaghiile ukwipuutula paapo ubhwelu ubhwa kumwafwa ukutesha akiisa bhutaliipo.” ");
INSERT INTO ndh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bhwo uYeesu aayugha isho, akeendelela ukubhabhuula abhamanyili bhaake akati, “Umumanyani ghwitu uLaasalo apitiile, loole indiimbuuke pakumulamusha.” ");
INSERT INTO ndh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Po abhamanyili bhaake bhakamwamula bhakati, “Ghwe Malafyale, linga apitiile, indialamushe nu kupola.” ");
INSERT INTO ndh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","UYeesu panu akayughagha ukuti uLaasalo aafwa, loole abhamanyili bhaake bhakiinongʼonagha ukuti akayughagha ukuti uLaasalo aghonite utulo. ");
INSERT INTO ndh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Po uYeesu akabhabhuula pabhwelu abhamanyili bhaake akati, “ULaasalo aafwa. ");
INSERT INTO ndh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Loole une naasekela ku nongwa yiinyu paapo indaaliikwo bhwo uLaasalo akufwa ukuti muunyiitike ngaani. Po isagha, tubhuuke kukwake.” ");
INSERT INTO ndh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Umumanyili yumo uToomasi yuuyo bhakamwitishanga ingamu iya Mbasa, akabhabhuula abhamanyili abhanine akati, “Tubhuuke nuutwe ukuti tuye tufwe pamupeene nu Yeesu.” ");
INSERT INTO ndh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Po bhwo uYeesu aafika mu chiisu icha Yuteeya mu kaaya aka Bheetaniya, akaagha uLaasalo aamala amashiku manna mu ipumba ukufuma muumwo bhakamushiilila. ");
INSERT INTO ndh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Akaaya aka Bheetaniya kakabha isa ikilomiita shitatuushe ukufuma mu kaaya aka Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ABhayuuta abhingi ukufuma mu chiisu icha Yuteeya bhakabha bhiisile ku Bheetaniya pakubhasubhaasha uMaalita nu Maliiya ku nongwa iya kufwilighwa nu mukulu ghwabho uLaasalo. ");
INSERT INTO ndh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bhwo abhandu bhaamubhuula uMaalita ukuti uYeesu ali mu sila akwisa, akafuma kuuse nu kubhuuka pakumupokeela, loole uMaliiya akashaala mu nyumba. ");
INSERT INTO ndh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Bhwo uMaalita aakomaana nu Yeesu, akamubhuula akati, “Ghwe Malafyale, linga ukabhangaapo panu, umukulu ghwangu ngali atafwile. ");
INSERT INTO ndh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Loole poope imeenye ukuti uChaala indiakupe kooshi kaako indiumusuume.” ");
INSERT INTO ndh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Po uYeesu akamwamula uMaalita akati, “Umukulu ghwako uLaasalo indiashuuke nu kubha mwumi soona.” ");
INSERT INTO ndh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","UMaalita akamwamula uYeesu akati, “Ghwe Malafyale, ishimeenye ukuti indiakashuuke nu kubha mwumi soona pi ishiku ilya bhumalilo ubhwa chiisu ichi, ishiku liilyo uChaala indiakabhashuushe abhafwe bhooshi.” ");
INSERT INTO ndh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","UYeesu akamwamula uMaalita akati, “Une neene ingubhashuusha abhandu ukuti bhabhe bhuumi soona. Umundu ghweshi yuuyo akuunyiitika une nalinga afwe pa chiisu ichi, indieendelelaghe ukubha mwumi. ");
INSERT INTO ndh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ghwepe umundu yuuyo mwumi, soona akuunyiitika une ataaakafwe naalumo. Ghwe Maalita, kali, kushiitika isho naayugha?” ");
INSERT INTO ndh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","UMaalita akamwamula uYeesu akati, “Nalooli Malafyale, niitika ukuti ughwe ghwe Mesiiya, uMwana ughwa Chaala, ghweghwe twakulindililagha ukuti kwisa pa chiisu ichi ukufuma kwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bhwo uMaalita aayugha nu Yeesu, akabhuuka kukaaya kaabho. Bhwo aafika, akamwitisha umunungʼuna ghwake uMaliiya ku bhushiifu, akamubhuula akati, “UMumanyishi ghwitu ali kula, akukwitisha.” ");
INSERT INTO ndh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bhwo uMaliiya aapulika isho, akanyatuka lubhilo nu kubhuuka kuukwo uYeesu akabha. ");
INSERT INTO ndh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","UYeesu akabha akaali atiingiile mu kaaya aka Bheetaniya, loole akabha ali pabhuyo paapo uMaalita akaya aamupokeela. ");
INSERT INTO ndh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bhwo abhandu bhala bhaabho bhakamusubhaashanga uMaliiya mu nyumba bhaamubhona akunyatuka nu kufuma kuuse, po bhakaanda ukumukonga paapo bhakiinongʼonagha ukuti uMaliiya aabhuuka ku ipumba kula pakulila. ");
INSERT INTO ndh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bhwo uMaliiya aafika pabhuyo paapo uYeesu akabha, akafughamila mu tulundi twake bhwo akulila, akamubhuula akati, “Ghwe Malafyale, linga ukabhangaapo panu, umukulu ghwangu ngali atafwile.” ");
INSERT INTO ndh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Po bhwo uYeesu aamubhona uMaliiya akulila na Bhayuuta bhaabho bhiisa naghwe bhoope bhakulila, akalabha leka mu ndumbula yaake. ");
INSERT INTO ndh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Po uYeesu akabhabhuusha akati, “Kali, mwamushiilite kuughu uLaasalo?” Bhakamwamula bhakati, “Ghwe Malafyale, tubhuuke tukulangishe paapo twamushiilite.” ");
INSERT INTO ndh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","UYeesu akalila. ");
INSERT INTO ndh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Po aBhayuuta abho bhaabho bhakiisa ku ifwa bhakayugha bhakati, “Tesha muumwo uYeesu aamughaniile uLaasalo!” ");
INSERT INTO ndh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Loole bhamu bhakayugha bhakati, “Umundu uyu ghwe yuuyo akamuposha umufwamaaso ukuti ateshange, po kali, kooni ataabhombagha shimo ukuti uLaasalo manye afwe?” ");
INSERT INTO ndh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bhwo uYeesu akaali akulabha soona mu ndumbula yaake, akafika pi ipumba paapo bhakamushiila uLaasalo. Ipumba lila likabha mbako liilyo bhakalyifunikila ni iyondo ikulu ku mulyango. ");
INSERT INTO ndh_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","UYeesu akabhabhuula abhandu bhaabho bhakabhaapo pala akati, “Libhungunie iyondo ilyo ku mulyango.” UMaalita akamwamula uYeesu akati, “Ghwe Malafyale, ku kabhalilo aka umufimba ghwake indighwande ukunuuka paapo ghaakinda amashiku manna ukufuma muumwo twamushiiliile.” ");
INSERT INTO ndh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","UYeesu akamwamula uMaalita akati, “Une ingubhuulite ukuti linga kwitika, indiughabhone amaka amakulu agha Chaala muumwo ghabheeliile.” ");
INSERT INTO ndh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Po abhandu bhaabho bhakabhaapo pala, bhakalibhungunia iyondo lila liilyo likabha ku mulyango. UYeesu akatesha kumwanya, akiipuuta kwa Chaala akati, “Ghwe Taata, ingukupaalisha paapo ghwashipokeela inyipuuto shangu. ");
INSERT INTO ndh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Imeenye ukuti linga ingukusuuma, kuumbulikagha akabhalilo kooshi, loole inguyugha ishi ku nongwa iya chilundilo icha bhandu abha bhaliipo panu ukuti bhiitike ukuti ghweghwe ghuundumite.” ");
INSERT INTO ndh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bhwo uYeesu aayugha isho, akiitisha ku ishu ilya pamwanya akati, “Ghwe Laasalo, fuma kuuse!” ");
INSERT INTO ndh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Po uLaasalo yuuyo aafwile, akafuma mu ipumba bhwo utulundi nu tukono twake tuniembetelele nu mwenda ghuughwo bhakamushiilila. Soona akabha ni chitambaala chiicho bhakamwifunika ku maaso. UYeesu akabhabhuula abhandu bhala akati, “Mwabhule imyenda iyo nu kumuleka abhuukaghe.” ");
INSERT INTO ndh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bhwo aBhayuuta abhingi bhaabho bhakiisa pakumusubhaasha uMaliiya bhaashibhona shiisho uYeesu akashibhomba, bhakamwitika. ");
INSERT INTO ndh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Loole aBhayuuta bhamu bhakabhuuka ku Bhafalisaayi nu kubhabhuula shiisho uYeesu akashibhomba. ");
INSERT INTO ndh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Po abhosongo abha bhapuuti na Bhafalisaayi bhakabhungaana pa lukomaano ulwa Libhalaasa ilya Bhayuuta, bhakabhuusania bheene-bheene bhakati, “Kali, tubhombe kooni? Paapo umundu uyu akubhomba ifyika ifyingi. ");
INSERT INTO ndh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Linga twamulekaashe ukuti abhombaghe ifyika ifyo, abhandu bhooshi indibhamwitike ukuti ghwi Kilisiti. Linga bhaamwitika nu kumukonga, aBhalooma indibhiise pakukomania ichiisu chiitu ni Nyumba iya Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Po yumo mu bhosongo abho yuuyo ingamu yaake akabha ghwi Kayaafa, yuuyo akabha mupuuti usongo ichinja icho, akayugha akati, “Umwe mutashimeenye shiisho mukuyugha! ");
INSERT INTO ndh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kali, mutakumanya ukuti kaali kiisa ukuti umundu yumo afwe ku nongwa iya bhandu bhooshi ukukinda ukuti ichiisu chooshi chipyutighwe?” ");
INSERT INTO ndh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","UKayaafa atakayugha isho ku bhwighane bhwake mwene. Loole ku nongwa iya kuti akabha mupuuti usongo mu chinja icho, akasololagha ukuti uYeesu indiafwe ku nongwa iya Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Soona, uYeesu ataaafwe ku nongwa iya Bhayuuta bheene, loole na ku nongwa iya kubhabhungaania abhandu abha Chaala bhaabho bhanyambaanite ukuti bhabhange pamupeene. ");
INSERT INTO ndh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Po ukufuma ishiku ilyo, abhalongoshi abha Bhayuuta bhakaanda ukwinongʼona isila iya kumughogha uYeesu. ");
INSERT INTO ndh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ku nongwa iyo, uYeesu akaleka ukughenda pabhwelu mu kaaya aka Yuteeya, po akatiila nu kubhuuka kupiipi nu lungalangala, mu kaaya aka Efulayimu nu kwikala kula kula pamupeene na bhamanyili bhaake. ");
INSERT INTO ndh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ichaaka icha Bhayuuta icha Pasaka chikabha chaapalamila. Po abhandu abhingi bhakafuma mu twaya twabho ukubhuuka ku Yelusaleemu ukuti bhiiyeelufye bhwo ichaaka chikaali ukufika. ");
INSERT INTO ndh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Po bhakeendelela ukumulonda uYeesu. Bhwo bhabhungaanite pamupeene mu lupaso ulwa Nyumba iya Chaala, bhakaanda ukubhuusania bheene-bheene bhakati, “Kali, umwe mukwinongʼona bhuleele? Kali, umundu uyo indiiise ku chaaka pamu ataaiise?” ");
INSERT INTO ndh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Abhosongo abha bhapuuti na Bhafalisaayi bhakabha bhalaghiile ukuti umundu ghweshi yuuyo aamanya kuukwo uYeesu ali, abhuuke nu kubhabhuula ukuti bhamukole. ");
INSERT INTO ndh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bhwo amashiku mahaano na limo (6) ghaashaala ukufika pa chaaka icha Pasaka, uYeesu akabhuuka soona mu Bheetaniya, akaaya kaako akamushuusha uLaasalo. ");
INSERT INTO ndh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Po abhamanyani bhamu abha Yeesu bhakamutendekeshekesha ifindu ifya namasubha, uMaalita ghwe yuuyo akabhabhombelagha. ULaasalo akabha ghwe yumo mu bhaabho bhakalyanga ifindu pa meesa pamupeene nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Po uMaliiya akeegha isupa iya nyemba isha kunuukila isha mutengo umukulu ngaani, akamusululila uYeesu pa tulundi twake nu kutupuupula ni chingʼwili chaake. Inyumba yooshi yikiisula ulunuushi ulwa nyemba shila. ");
INSERT INTO ndh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Loole yumo mu bhamanyili bhaake, uYuuta Isikaliyooti, yuuyo akayanga pakumubhiika uYeesu mu tukono utwa bhalughu, akayugha akati, ");
INSERT INTO ndh_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kaali kiisa ukughulisha inyemba isho ku ndinaali imya shitatu (300) nu kubhapa abhapiina.” ");
INSERT INTO ndh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","UYuuta atakayugha ulwo ku nongwa iya kubhasaaghila abhapiina, loole akayugha ulwo ku nongwa iya kuti akabha mwifi. Umwene ghwe yuuyo akasengulagha inyambi iya ndalama nu kuti akabhalilo akingi akeeghagha indalama mwene nu kushibhombela. ");
INSERT INTO ndh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Po uYeesu akamwamula uYuuta akati, “Muleke! Manye mumutamyange umukolo uyu. Umwene akaghula inyemba isho ukuti ashisengule ukufika pi ishiku liilyo indiingashiilighwe. ");
INSERT INTO ndh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Abhapiina bhali pamupeene nuumwe amashiku ghooshi, loole une indaaimbe pamupeene nuumwe amashiku ghooshi.” ");
INSERT INTO ndh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Po bhwo abhandu abhingi bhaapulika ukuti uYeesu ali mu kaaya aka Bheetaniya, bhakabhuuka pakumutesha uYeesu pamupeene nu Laasalo yuuyo uYeesu akamushuusha. ");
INSERT INTO ndh_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Po abhosongo abha bhapuuti bhakalonda isila iya kumughogha nu Laasalo. ");
INSERT INTO ndh_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Paapo ukukongana ni nongwa isha kushuuka ukwa Laasalo, aBhayuuta abhingi bhakabhalekagha abhalongoshi bhaabho, bhakabhuukagha kwa Yeesu nu kumwitika. ");
INSERT INTO ndh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ishiku liilyo likakongagha, ichilundilo ichikulu icha bhandu chiicho chikiisagha pakusekelela ichaaka icha Pasaka chikapulika ukuti uYeesu akabha mu sila ukwisa mu Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Po bhakeegha utusamba utwa mitende, bhakafuma ukubhuuka pakumupokeela uYeesu. Bhakaanda ukukoolela bhakati, “Apaalighwange uChaala! Asayighwange yuuyo akwisa mu ngamu iya Malafyale! Asayighwange uMalafyale ughwa Isilaeli!” ");
INSERT INTO ndh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Po uYeesu akayaagha inyaana iya mbunda, akiitogha pamwanya isa muumwo shisimbiighwe mu Masimbo aMeelu ukumuyugha umwene ukuti, ");
INSERT INTO ndh_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mwe bhandu abha kaaya aka Siyooni, manye mwoghopaghe! Tesha, uMalafyale ghwinyu akwisa, iitoghite pamwanya pa nyaana iya mbunda!” ");
INSERT INTO ndh_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ku kabhalilo ako, abhamanyili abha Yeesu bhatakashaaghania isho. Loole bhwo uChaala aamushuusha uYeesu ku sila iya kuswighisha, po bhakakumbuka ukuti isho shikabha shisimbiighwe ku nongwa yaake nu kuti abhandu bhakabha bhamubhombiile ulwo. ");
INSERT INTO ndh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Po abhandu abhingi bhaabho bhakabha pamupeene nu Yeesu bhwo akumwitisha uLaasalo ukufuma mu ipumba nu kumushuusha, bhakabhalingaanianga abhandu shiisho bhakashibhona nu kupulika. ");
INSERT INTO ndh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Abhandu abho ukufuma mu Yelusaleemu bhakabhuuka pakumupokeela uYeesu ku nongwa iya kuti bhakapulika isha chiika chiicho akachibhomba. ");
INSERT INTO ndh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bhwo aBhafalisaayi bhaatesha muumwo abhandu abhingi bhakamupokeelela uYeesu, bhakabhuusania bheene-bheene bhakati, “Kali, mwatesha? Tutali ni mbombo naayimo! Tesha! Abhandu bhooshi bhakumukonga yuuyo.” ");
INSERT INTO ndh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mu bhandu bhaabho bhakabhuuka ku Yelusaleemu pakumwipuuta uChaala akabhalilo aka chaaka icha Pasaka, bhakabhaapo na bhamu bhaabho bhataa Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Abhandu abho bhakabhuuka kwa Filipu yuuyo akafumagha mu kaaya aka Bheetisayita mu chiisu icha Ghalilaayi, bhakamusuuma bhakati, “Ghwe songo, tukusuuma tuyughe nu Yeesu.” ");
INSERT INTO ndh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","UFilipu akabhuuka pakumubhuula uNdeleeya shiisho abhandu bhala bhakasuuma. Po uFilipu nu Ndeleeya bhakabhuuka kwa Yeesu nu kumupangila shooshi. ");
INSERT INTO ndh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","UYeesu akabhaamula akati, “Akabhalilo kaafika aka Chaala ukulangisha ubhukulumba ubhwa nalooli ubhwa Mwana ughwa Mundu. ");
INSERT INTO ndh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nalooli ingubhabhuula, linga akaseke aka ngano kataashiilighwa pi ilongwi, katabhaghiile ukumela, loole linga kaashiilighwa, kakumela nu kwela iseke inyingi. ");
INSERT INTO ndh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Umundu ghweshi yuuyo akulonda ukubhupoka ubhwumi bhwake, indiakabhupyute. Loole umundu ghweshi yuuyo akubhusofya ubhwumi bhwake pa chiisu ichi ku nongwa yangu, indiakabhwaghe ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Umundu ghweshi yuuyo akuumbombela une, akulondighwa aangongaghe. Ku sila iyo umundu uyo yuuyo mubhombi ghwangu indiakabhange pamupeene nuune kuukwo indiingabhange. UTaata indiakamughindike umundu ghweshi yuuyo akuumbombela une. ");
INSERT INTO ndh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ulu naanda ukulabha leka mu ndumbula yangu. Indakumanya isha kuyugha, ‘Kali, indi ghwe Taata, ingukusuuma ghuumboke mu kabhalilo aka ndamyo aka?’ Nashiku, indabhaghiile ukusuuma ulwo paapo niisile pa chiisu ichi pakutaamighwa nu kufwa. ");
INSERT INTO ndh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ghwe Taata Chaala, ingukusuuma ulangishe amaka ghaako ku bhandu.” Po uChaala akayugha ukufuma kumwanya akati, “Ghwe Mwana ghwangu, naabhalangisha abhandu amaka ghangu, soona indineendelele ukubhalangisha.” ");
INSERT INTO ndh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Po bhwo ichilundilo icha bhandu bhaabho bhakabhaapo pala bhaapulika ishu ukufuma kumwanya, bhamu bhakati, “Ifula yaapaya,” abhanine bhakati, “Ughwandumi ughwa Chaala aayughagha nu Yeesu.” ");
INSERT INTO ndh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Loole uYeesu akabhabhuula abhandu bhala akati, “Ishu liilyo mwalipulikagha ukufuma kumwanya litaali lya kuunyaafwa une, loole lyali lya kubhaafwa umwe. ");
INSERT INTO ndh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ulu kaafika akabhalilo aka Chaala ukubhalonga abhandu abha mu chiisu ichi. Ulu kaafika akabhalilo aka Chaala ukumukiisha uSeetano yuuyo mulongoshi ghwa chiisu ichi. ");
INSERT INTO ndh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bhwo bhaangwesha pa chikobhekano ukufuma pa chiisu, indiingabhakuuse abhandu bhooshi ukwisa kukwangu nu kuunyiitika.” ");
INSERT INTO ndh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","UYeesu akayugha ulwo ukulangisha muumwo indiakafwile pa chikobhekano. ");
INSERT INTO ndh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Po ichilundilo icha bhandu chikamwamula uYeesu chikati, “Tubhelengite mu Masimbo aMeelu ukuti uMesiiya indiakabhange mwumi bhwila na bhwila. Po kali, kuyugha bhuleele ukuti abhandu indibhakamukweshe uMwana ughwa Mundu pa chikobhekano? Kali, uMwana ughwa Mundu uyo ghwe ghwini?” ");
INSERT INTO ndh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","UYeesu akabhabhuula akati, “Ubhwelu indibhubhe pamupeene nuumwe ku kabhalilo akapimbaashe. Endelelagha ukughenda mu bhwelu ubhwo bhwo bhukaali bhuliipo ukuti ichiisi manye chibhapoote, paapo umundu yuuyo akughenda mu chiisi, atakumanya kuukwo akubhuuka. ");
INSERT INTO ndh_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Po mwitikaghe yuuyo bhwelu bhwo akaali ali pamupeene nuumwe ukuti mubhange bhandu bhaabho bhakwikala mu bhwelu.” Bhwo uYeesu aayugha amashu agho, akachileka ichilundilo chila, akabhuuka nu kwimama. ");
INSERT INTO ndh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pamupeene nu kuti uYeesu akabhomba ifyika ifyingi pandaashi papaabho, poope abhandu abhingi bhatakamwitika ukuti ghwi Kilisiti. ");
INSERT INTO ndh_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bhatakamwitika ukuti amashu ghaagho umusololi uYesaaya akayugha, ghabhe gha nalooli. Umwene akati, “Ghwe Malafyale Chaala, kali, ghwini yuuyo akayiitika indumi yiitu? Soona, kali, uMalafyale amulangishiishe ghwini amaka ghaake?” ");
INSERT INTO ndh_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bhatakamwitika ku nongwa iya kuti uChaala akayugha ukughendela ku musololi uYesaaya akati, ");
INSERT INTO ndh_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Aghoghite amaaso ghaabho ukuti manye bhateshange, abhalungaaniishe amahala ghaabho ukuti manye bhashaaghaniange shiisho abhabhombiile. Ingabhomba ulwo ukuti manye bhakaghaluke kukwangu ukuti imbaposhe.” ");
INSERT INTO ndh_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","UYesaaya akamuyughagha ghwi Yeesu panu ku nongwa iya kuti akabhubhona ubhukulumba bhwake. ");
INSERT INTO ndh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pamupeene nu kuti abhalongoshi abhingi abha Bhayuuta bhakamwitika uYeesu, poope bhatakayughagha pabhwelu ukuti bhamwitikite ku nongwa iya kubhooghopa aBhafalisaayi ukubhakiisha mu sinaghoghi. ");
INSERT INTO ndh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Abhalongoshi abho bhakiighanagha leka ukuti abhandu bhabhapaalaghe ukukinda ukuti uChaala abhapaalaghe. ");
INSERT INTO ndh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Po uYeesu akayugha ku ishu ilya pamwanya akati, “Umundu yuuyo akuunyiitika une, atakuunyiitika neneeshe, loole akumwitika na yula yuuyo aandumite. ");
INSERT INTO ndh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Umundu ghweshi yuuyo akuumbona une, akumubhona na yuuyo aandumite. ");
INSERT INTO ndh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Une niisile mu chiisu ichi ungati bhwelu ukuti abhandu bhateshange. Po abhandu bhooshi bhaabho bhakuunyiitika, manye bheendelelaghe ukwikala mu chiisi. ");
INSERT INTO ndh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Umundu yuuyo akughapulika amashu ghangu loole atakughabhombela imbombo, indaaingamulonge paapo indakiisa pa chiisu ichi pakubhalonga abhandu, loole ingiisa pakubhapoka. ");
INSERT INTO ndh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bhubhuubhwo, umundu ghweshi yuuyo akuungaana une pamupeene na mashu ghangu indiakalongighwe. UChaala ghwe yuuyo indiakamulonge pi ishiku ilya bhumalilo ubhwa chiisu ukukongana na mashu ghaagho injughite. ");
INSERT INTO ndh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Paapo indayughite ku maka ghangu yuneene, loole uTaata yuuyo aandumite ghwe yuuyo aandaghiile ukuyugha sheene shiisho ingulondighwa ukuyugha. ");
INSERT INTO ndh_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Soona ishimeenye ukuti indaghilo shiisho alaghiile shikubhapa abhandu ubhwumi ubhwa bhwila na bhwila. Po nuune inguyugha sheene shiisho uTaata aandaghiile ukushiyugha.” ");
INSERT INTO ndh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Po bhwo ishiku ilya chaaka icha Pasaka likaali ukufika, uYeesu akamanya ukuti akabhalilo kaake kaafika aka kutiila pa chiisu ichi nu kubhuuka kwa Ghwise. Akabhalilo kooshi akabhaghanagha abhandu bhaake bhooshi bhaabho bhakamwitikagha pa chiisu ichi, soona akeendelela ukubhaghana ukufika kubhumalilo. ");
INSERT INTO ndh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bhwo lyabha lya namasubha, uYeesu na bhamanyili bhaake bhakiikala nu kulya ifindu pamupeene. USeetano akabha iingiile mu ndumbula iya Yuuta ukuti amubhiike uYeesu mu tukono utwa bhalughu. UYuuta akabha mwana ghwa Siimoni Isikaliyooti. ");
INSERT INTO ndh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","UYeesu akamanya ukuti uGhwise akamupa amaka agha kutulongosha utundu twoshi, soona akamanya ukuti akafuma kwa Chaala nu kuti indiaghaluke kwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Po uYeesu akaleka ukulya, akiima, akafuula ikoti lyake, akeegha ichitambaala nu kwipinya mu musana. ");
INSERT INTO ndh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akeegha ikalayi nu kubhiika amiishi. Po akaanda ukubhasukusha utulundi abhamanyili bhaake nu kutupuupula ni chitambaala chiicho akiipinya. ");
INSERT INTO ndh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bhwo uYeesu aafika paapo uSiimoni Peeteli akabha, uPeeteli akamubhuusha akati, “Ghwe Malafyale, kali, kulonda ghuusukushe utulundi twangu une?” ");
INSERT INTO ndh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","UYeesu akamwamula akati, “Ughwe utameenye liilyo une ingulibhomba ulu, loole indiulimanye pakataashi.” ");
INSERT INTO ndh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","UPeeteli akamubhuula akati, “Utabhaghiile ukuusukusha shiku utulundi twangu.” UYeesu akamwamula akati, “Linga indaakusukusha ughwe, utabhaghiile ukubha pamupeene nuune soona.” ");
INSERT INTO ndh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Po uSiimoni Peeteli akamwamula akati, “Ghwe Malafyale, linga bhwo shili, po manye ghuusukushe utulundi twene, loole ghuusukushe nu tukono twangu pamupeene nu mutu.” ");
INSERT INTO ndh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","UYeesu akamwamula akati, “Umundu ghweshi yuuyo ooghite umubhili ghwoshi, mwelu lwoshi. Ku sila iyo atakulondighwa ukwogha soona umubhili ghwoshi, loole ukusukusula mu tulundiishe. Umwe mwe bheelu, loole yumo pakati papiinyu ataa mwelu.” ");
INSERT INTO ndh_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ku nongwa iya kuti uYeesu akabha amumeenye umundu yuuyo indiamubhiike mu tukono utwa bhalughu, yo yiiyo nongwa iyi akayugha akati, “Yumo pakati papiinyu ataa mwelu.” ");
INSERT INTO ndh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bhwo uYeesu aamala ukubhasukusha utulundi abhamanyili bhaake, akafwala ikoti lyake, akaghaluka soona paapo akiikala pa findu nu kubhabhuusha abhamanyili bhaake akati, “Kali, mwashaaghania isho shiisho naabhabhombela umwe? ");
INSERT INTO ndh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Umwe mukuunyiitisha une mukuti Mumanyishi soona mukuti Malafyale, nuumwe mukuyugha bhwanalooli paapo une nee Mumanyishi ghwinyu soona nee Malafyale ghwinyu. ");
INSERT INTO ndh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ku nongwa iya kuti une ni Mumanyishi ghwinyu soona ni Malafyale ghwinyu naabhasukusha umwe utulundi twinyu, bhubhuubhwo nuumwe mukulondighwa musukusaniange utulundi mwibheene-bheene. ");
INSERT INTO ndh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naabhalangisha ichifwanikisho muumwo naabhombelagha ukuti nuumwe mubhombelanaghe mwibheene-bheene isa muumwo naabhabhombelagha umwe. ");
INSERT INTO ndh_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nalooli ingubhabhuula, umutumwa ataa ghwi songo ukukinda usongo ghwake, soona umutumighwa ataa ghwi songo ukukinda yuuyo amutumite. ");
INSERT INTO ndh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ku nongwa iya kuti mwashimanya shooshi isho, po uChaala indiabhasaye linga mukushibhombela imbombo.” ");
INSERT INTO ndh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Po uYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “Indakuyugha shooshi isho kukwinyu mweshi paapo imbameenye ukufuma kubhwandilo abhandu bhaabho imbasalite ukubha bhamanyili bhangu. Loole naayugha isho ukuti shibhombighwe shiisho shisimbiighwe mu Masimbo aMeelu ukuti, ‘Umumanyani ghwangu yuuyo akalya ifindu pamupeene nuune, aasanuka ukubha mulughu ghwangu.’ ");
INSERT INTO ndh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ingubhabhuula shooshi isho ulu bhwo shikaali ukubhoneka ukuti linga shaabhoneka, indimukiitike ukuti nalooli une nee Kilisiti. ");
INSERT INTO ndh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nalooli ingubhabhuula, umundu ghweshi yuuyo akumupokeela yuuyo imutumite, akuumbokeela neene, ghwepe yuuyo akuumbokeela une, akumupokeela uTaata yuuyo aandumite.” ");
INSERT INTO ndh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bhwo uYeesu aayugha isho, akalabha leka mu ndumbula yaake, akayugha pabhwelu akati, “Nalooli ingubhabhuula, umunyiinyu yumo indiaambiike mu tukono utwa bhalughu.” ");
INSERT INTO ndh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Po abhamanyili bhaake bhakaanda ukutesania bheene-bheene paapo bhatakamanya naakamu ukuti akumuyugha ghwini. ");
INSERT INTO ndh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pakabhaapo nu mumanyili yumo mu bhamanyili bhaake yuuyo uYeesu akamughana leka. Umwene akiikala papiipi nu Yeesu bhwo ali pakulya. ");
INSERT INTO ndh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Po uSiimoni Peeteli akamukopesha umumanyili uyo, akamubhuula akati, “Mubhuushe uYeesu ukuti, kali, akumuyugha ghwini pakati papiitu?” ");
INSERT INTO ndh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Po umumanyili yula bhwo akaali iikiile papiipi nu Yeesu, akabhiyisha umutu ghwake kupiipi kwa Yeesu, akamubhuusha akati, “Ghwe Malafyale, kali, ghwini pakati papiitu yuuyo indiakubhiike mu tukono utwa bhalughu?” ");
INSERT INTO ndh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","UYeesu akamwamula akati, “Ghwe yula yuuyo indiimupe ichibhali icha mukati linga naasaasila mu kabhigha.” Po uYeesu akeegha ichibhali icha mukati, akasaasila mu kabhigha, akamupa uYuuta Isikaliyooti, umwana ughwa Siimoni. ");
INSERT INTO ndh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bhwo uYuuta aapokeela ichibhali icha mukati icho, nakalinga, uSeetano akamwingila. Po uYeesu akamubhuula uYuuta akati, “Ghwe Yuuta, shibhombe lubhilo shiisho kulonda ukushibhomba!” ");
INSERT INTO ndh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Loole naayumo umundu mu bhala bhaabho bhakalyanga pala yuuyo akashaaghania ukuti kooni uYeesu akamubhuulagha uYuuta ulwo. ");
INSERT INTO ndh_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ku nongwa iya kuti uYuuta ghwe yuuyo akasengulagha inyambi iya ndalama, bhamu mu bhamanyili bhaake bhakiinongʼonagha ukuti uYeesu akamubhuulagha uYuuta ukuti aye aghule fiifyo fikalondighwanga pa chaaka. Abhanine bhakiinongʼonagha ukuti uYeesu akamulaghilagha uYuuta ukubhapa indalama shimo abhapiina. ");
INSERT INTO ndh_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Po bhwo uYuuta aapokeela ichibhali icha mukati icho, nakalinga akafuma kuuse. Akabhalilo ako bhukabha bhushiku. ");
INSERT INTO ndh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Po bhwo uYuuta aafuma kuuse, uYeesu akabhabhuula abhamanyili bhaake akati, “Ulu ubhukulumba ubhwa Mwana ughwa Mundu bhukuya pakubhoneka pabhwelu, soona indiabhulangishe ubhukulumba ubhwa Chaala muumwo bhubheeliile. ");
INSERT INTO ndh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Po linga aabhalangisha ubhukulumba ubhwa Chaala muumwo bhubheeliile, ghwepe uChaala indiabhalangishe abhandu ubhukulumba ubhwa Mwana ughwa Mundu, soona indiabhombe ulwo luluulu. ");
INSERT INTO ndh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mwe bhaana bhangu, indiimbe pamupeene nuumwe ku kabhalilo akapimbaashe. Isa muumwo ingabhabhuulila abhalongoshi abha Bhayuuta, bhubhuubhwo ingubhabhuula nuumwe ulu ukuti indimuundondaghe, loole mutaamuunyaaghaghe ku nongwa iya kuti kuukwo une ingubhuuka, umwe mutabhaghiile ukubhuuka. ");
INSERT INTO ndh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Loole ulu ingubhapa ululaghilo ulupya, ingubhalaghila ukuti, ‘Mughananaghe mwibheene-bheene isa muumwo une imbaghaniile umwe, bhubhuubhwo nuumwe mughananaghe bheene-bheene.’ ");
INSERT INTO ndh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Linga mukughanana mwibheene-bheene, po abhandu bhooshi indibhamanye ukuti umwe mwe bhamanyili bhangu.” ");
INSERT INTO ndh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Po uSiimoni Peeteli akamubhuusha uYeesu akati, “Ghwe Malafyale, kali, kubhuuka kuughu?” UYeesu akamwamula akati, “Ingubhuuka kuukwo ughwe utabhaghiile ukuungonga ulu, loole indighuungonge pakataashi.” ");
INSERT INTO ndh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","UPeeteli akamubhuusha akati, “Ghwe Malafyale, kali, ku nongwa yiki une indabhaghiile ukukukonga ulu? Une niifumyishe ubhwumi bhwangu ukufwa ku nongwa yaako!” ");
INSERT INTO ndh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","UYeesu akamwamula, akamubhuusha akati, “Ghwe Peeteli, kali, nalooli ghwifumyishe ubhwumi bhwako ukufwa ku nongwa yangu? Nalooli ingukubhuula, bhwo ubhiisa akaali ukubhika, indiubhe ghwangaana une katatu ukuti utaameenye.” ");
INSERT INTO ndh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Po uYeesu akeendelela ukubhamanyisha abhamanyili bhaake akati, “Manye mulabhaghe mu ndumbula shiinyu. Mwitikaghe uChaala, soona nyiitikaghe nuune. ");
INSERT INTO ndh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mu nyumba iya Taata muli nu bhwikalo ubhwingi. Linga shitaali ulwo, ngali imbabhuulite. Ulu ingubhuuka pakubhatendekeshekesha ubhwikalo. ");
INSERT INTO ndh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Linga naaya naabhatendekeshekesha ubhwikalo, indiingiise soona pakubheegha ukuti pabhuyo paapo indiingabhe, nuumwe indimukabhe pala pala pamupeene nuune. ");
INSERT INTO ndh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nuumwe muyimeenye isila yiiyo yikulongosha kubhuyo kuukwo ingubhuuka.” ");
INSERT INTO ndh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","UToomasi yuuyo ghwe yumo mu bhamanyili abha Yeesu akamubhuusha akati, “Ghwe Malafyale, utwe tutameenye kubhuyo kuukwo kubhuuka. Kali, po tubhaghiile bhuleele ukuyimanya isila?” ");
INSERT INTO ndh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","UYeesu akaamula akati, “Une nee sila, nee bhwanalooli soona nee bhwumi. Ataliipo umundu naayumo yuuyo abhaghiile ukwisa kwa Taata linga atakughendela kukwangu. ");
INSERT INTO ndh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Linga mwameenye une, po ngali mumumeenye nu Taata. Ukwanda umuusughu, mumumeenye uTaata soona mumubhweni.” ");
INSERT INTO ndh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","UFilipu yuuyo ghwe yumo mu bhamanyili bhaake, akamubhuula akati, “Ghwe Malafyale, tukukusuuma utulangishe uGhuuso. Linga ghwatulangisha, bhwo ghwamala shooshi.” ");
INSERT INTO ndh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","UYeesu akamwamula akati, “Ghwe Filipu, niikala nuumwe akabhalilo akatali kooshi ako, kali, poope ukaali utaameenye une? Umundu ghweshi yuuyo aambweni une, amubhweni nu Taata. Po kali, kooni kuumbuusha ukuti, ‘Tulangishe uGhuuso’? ");
INSERT INTO ndh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kali, utakwitika ukuti uTaata ali pamupeene nuune, nuune indi pamupeene nu Taata? Amashu ghaagho ingubhabhuula ghatakufuma mu nyinongʼono shangu, loole ghakufuma kwa Taata yuuyo ali pamupeene nuune. ");
INSERT INTO ndh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Itikagha shiisho inguyugha ukuti uTaata ali pamupeene nuune. Loole linga mutakwitika ku nongwa iya shiisho inguyugha, po itikagha ku nongwa iya fyika fiifyo ingufibhomba. ");
INSERT INTO ndh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nalooli ingubhabhuula, umundu ghweshi yuuyo akuunyiitika une ku nongwa iya fyika fiifyo ingufibhomba, ghwepe indiakafibhombaghe. Soona indiakafibhombaghe ni fikulu ukukinda ifi ingufibhomba ku nongwa iya kuti ingubhuuka kwa Taata. ");
INSERT INTO ndh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Linga mukusuuma akandu kooshi ukughendela ku ngamu yangu, nuune indiingabhombe isa muumwo mukusuumila. Ku sila iyo, indiingabhulangishe ubhukulumba ubhwa Taata muumwo bhubheeliile. ");
INSERT INTO ndh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Linga mukuusuuma une akandu kooshi ukughendela ku ngamu yangu, indiingabhombe isa muumwo mukuusuumila.” ");
INSERT INTO ndh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","UYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “Linga muunganite, indimubhombaghe imbombo shooshi shiisho naabhalaghiile ukuti mushibhombaghe. ");
INSERT INTO ndh_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Po nuune indiimusuume uTaata ukuti abhatumile uMbepo uMwelu ughwa kubhaafwa yuuyo ataaakabhaleke naalumo. ");
INSERT INTO ndh_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","UMbepo uMwelu uyo ghwe yuuyo indiabhasetulile abhandu ubhwanalooli ubhwa Chaala muumwo bhubheeliile. Abhandu bhooshi abha mu chiisu bhaabho bhatakuunyiitika une, bhatabhaghiile ukumupokeela uMbepo ughwa nalooli ughwa Chaala ku nongwa iya kuti bhatabhaghiile ukumubhona pamu ukumumanya. Loole umwe mumumeenye paapo akwikala pamupeene nuumwe ghwepe akwikala mu ndumbula shiinyu. ");
INSERT INTO ndh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Indaaimbaleke mwibheene mu chiisu ichi isa abhaana abhafwile, loole indiingiise soona kukwinyu. ");
INSERT INTO ndh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kaashaala akabhalilo kapimba kaako abhandu abha mu chiisu ichi bhaabho bhatakuunyiitika, bhataabhakaambone soona. Loole umwe indimukaambone. Ku nongwa iya kuti une indiingabhe mwumi soona, nuumwe indimubhange bhuumi. ");
INSERT INTO ndh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pi ishiku lila, indimukamanye ukuti uTaata ali pamupeene nuune, nuune indi pamupeene nu Taata, soona une indi pamupeene nuumwe. ");
INSERT INTO ndh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Umundu ghweshi yuuyo ashimeenye nu kushibhombela imbombo shiisho ingulaghila, umundu uyo aanganite nalooli. Ghwepe umundu ghweshi yuuyo aanganite une, uTaata indiamughanaghe, po nuune indiingiisetule kukwake.” ");
INSERT INTO ndh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Po uYuuta yuuyo ataa ghwi Yuuta Isikaliyooti, akamubhuusha uYeesu akati, “Ghwe Malafyale, kali, shili bhuleele ukuti indiukiisetule kukwitu muumwo ubheeliile, loole utaaukiisetule isa bhubhuubhwo ku bhandu abha mu chiisu ichi bhaabho bhatakukwitika?” ");
INSERT INTO ndh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","UYeesu akamwamula akati, “Umundu ghweshi yuuyo aanganite une, indiashibhombelaghe imbombo shiisho ingumulaghila. Ku sila iyo, uTaata indiamughane umundu uyo. Po une nu Taata inditukiise kukwake, soona inditukiikalaghe pamupeene naghwe. ");
INSERT INTO ndh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Loole umundu ghweshi yuuyo ataanganite une, atakushibhombela imbombo shiisho ingulaghila. Amashu ghaagho ingubhabhuula ghatakufuma mu nyinongʼono shangu, loole ghakufuma kwa Taata yuuyo aandumite kukwinyu. ");
INSERT INTO ndh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Naabhabhuula shooshi isho bhwo ingaali ingwikala pamupeene nuumwe. ");
INSERT INTO ndh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Loole uTaata indiakamutume kukwinyu uMbepo uMwelu ughwa kubhaafwa ku maka ghangu yuuyo indiakabhamanyishange nu kubhakumbusha shooshi shiisho ingabhamanyishanga bhwo indi pamupeene nuumwe. ");
INSERT INTO ndh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Bhwo ingutiila, indiimbape ulutengaano lwangu mu ndumbula shiinyu. Une ingubhapa ulutengaano luulwo lutali isa lula luulwo lukufuma ku bhandu abha mu chiisu ichi bhaabho bhatakuunyiitika. Manye mulabhaghe mu ndumbula shiinyu soona manye mwoghopaghe naakamu. ");
INSERT INTO ndh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mupulikite shiisho naabhabhuulagha naatingi, ‘Ingubhuuka, loole indiingiise soona kukwinyu.’ Linga nalooli mwanganite, ngali mukuhobhoka ukupulika ukuti ingubhuuka kwa Taata paapo uTaata ghwe yuuyo ghwi songo ukuunginda une. ");
INSERT INTO ndh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ingubhabhuula shooshi isho ulu bhwo shikaali ukubhoneka ukuti linga shaaya shaabhoneka, indimukiitike ukuti shiisho ingayughagha sha nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Indabhaghiile ukuyugha nuumwe ku kabhalilo akatali paapo uSeetano yuuyo ghwi songo ughwa chiisu ichi, akwisa pakuungola. Loole atali na maka kukwangu. ");
INSERT INTO ndh_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ingushibhomba shooshi ishi isa muumwo uTaata akaandaghilila ukuti abhandu abha chiisu ichi bhamanye ukuti imughanite. Ulu, nyatuka ukuti tutiileepo panu.” ");
INSERT INTO ndh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Po uYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “Une indi ungati musabhibhu ughwa nalooli ghuughwo ghukwela iseke inyiisa, uTaata ali ungati mulimi. ");
INSERT INTO ndh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Akasamba kooshi kaako kamelite mu musabhibhu linga katakwela iseke, uTaata akukakenda. Loole akasamba kaako kakwela iseke, uTaata akukapalundila ukuti koongelaghe ukupaapa. ");
INSERT INTO ndh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Umwe muli ungati tusamba tuutwo tukwela iseke, mwe bheelu ku nongwa iya kuti mufyitikite ifimanyisho fiifyo naabhamanyishiishe. ");
INSERT INTO ndh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Endelelagha ukubha pamupeene nuune, nuune indineendelelaghe ukubha pamupeene nuumwe. Mutabhaghiile ukubhomba shiisho shikumuhobhosha uChaala chishita kubha pamupeene nuune, isa muumwo akasamba katabhaghiile ukwela iseke keene chishita kukoleelela ku musabhibhu. ");
INSERT INTO ndh_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Une indi ungati musabhibhu, umwe muli ungati tusamba. Umundu yuuyo akubha pamupeene nuune akabhalilo kooshi, nuune ingubha pamupeene naghwe akabhalilo kooshi, uyo indiapaapaghe iseke inyingi, paapo mutabhaghiile ukubhomba shiisho shibhaghiile pandaashi pa Chaala chishita kubha pamupeene nuune. ");
INSERT INTO ndh_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Umundu ghweshi yuuyo atali pamupeene nuune, uChaala akumutaaghila kuuse isa paapo umulimi akukataagha kuuse akasamba kaako katakwela iseke ukufika paapo kakwuma. Linga kuuma, abhandu bhakukasebha nu kukaponia mu mulilo. ");
INSERT INTO ndh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Linga mukubha pamupeene nuune akabhalilo kooshi nu kushibhombela imbombo shiisho ingubhalaghila, po mubhaghiile ukusuuma kwa Taata kooshi kaako mukulonda, ghwepe indiabhapange ukukongana na muumwo mukulondela. ");
INSERT INTO ndh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Linga mukupaapa iseke inyingi, umwe mwe bhamanyili bhangu abha nalooli. Ku sila iyo, indimubhulangishange ubhukulumba ubhwa Taata ku bhandu. ");
INSERT INTO ndh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Isa muumwo uTaata aanganiile une, umwo mwo muumwo nuune naabhaghaniile umwe. Po endelelagha ukubha pamupeene nuune ukuti mulwaghaghe ulughano ukufuma kukwangu. ");
INSERT INTO ndh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Linga mukubhomba shiisho ingubhalaghila ukuti mubhombaghe, indimulwaghaghe ulughano ukufuma kukwangu isa paapo une ingubhomba shiisho uTaata aandaghiile ukuti ishibhombaghe nu kwendelela ukulwagha ulughano lwake. ");
INSERT INTO ndh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Naabhabhuula shooshi isho ukuti mwendelelaghe ukubha nu lusekelo mu ndumbula shiinyu isa muumwo nuune ingwendelela ukubha nu lusekelo mu ndumbula yangu. ");
INSERT INTO ndh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ululaghilo lwangu luulwo ingubhapa umwe lwo ulu, ‘Ghananagha mwibheene-bheene isa muumwo ingwendelela ukubhaghana umwe.’ ");
INSERT INTO ndh_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ataliipo umundu yuuyo abhaghiile ukulangisha ulughano ulukulu ukukinda ulughano ulwa mundu yuuyo akwitika ukufwa ku nongwa iya bhamanyani bhaake. ");
INSERT INTO ndh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Linga mukubhomba shiisho imbalaghiile ukuti mushibhombaghe, indimubhange bhamanyani bhangu bha papiipi. ");
INSERT INTO ndh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ukufuma ulu indaaimbiitishange soona umwe ukubha bhatumwa bhangu ku nongwa iya kuti umutumwa atakumanya shiisho usongo ghwake akubhomba. Loole indiimbiitishange umwe ukubha bhamanyani bhangu paapo naabhabhuula shooshi shiisho ingafuma nasho kwa Taata. ");
INSERT INTO ndh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mutaa mwemwe mukaasala une, loole neene ingabhasala umwe ukubha bhamanyili bhangu ukuti mupaapaghe iseke shiisho shitakushila naalumo. Po kooshi kaako mukumusuuma uTaata ukughendela ku ngamu yangu, ghwepe indiabhapange. ");
INSERT INTO ndh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Po ingubhalaghila, ghananagha mwibheene-bheene.” ");
INSERT INTO ndh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","UYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “Linga abhandu abha mu chiisu ichi bhakubhakalalila umwe, mumanyaghe ukuti bhakaanda ukuungalalila taashi une. ");
INSERT INTO ndh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Linga mwali bhandu bha mu chiisu ichi, po abhandu abha mu chiisu ngali bhabhaghanite isa muumwo bhakughanana bheene-bheene. Loole umwe mutaa bha mu chiisu ichi paapo neene imbasalite ukufuma mu chiisu ichi, yo yiiyo nongwa iyi abhandu abha mu chiisu ichi bhakubhakalalila. ");
INSERT INTO ndh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Manye mwibhwange shiisho ingabhabhuula ukuti, ‘Umutumwa ataa ghwi songo ukukinda usongo ghwake.’ Linga bhakaafulasha une, indibhakabhafulashe nuumwe. Linga bhakufyitika ifimanyisho fyangu, indibhafyitike ni fyinyu. ");
INSERT INTO ndh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Loole indibhakabhabhombelaghe shooshi isho ku nongwa iya kuti umwe muli bhakongi bhangu na ku nongwa iya kuti bhatamumeenye yuuyo akaanduma. ");
INSERT INTO ndh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Linga indakiisagha nu kuyugha nabho, po ngali bhatali ni nongwa. Loole paapo ingiisa nu kuyugha nabho, po bhatabhaghiile ukuyugha ukuti bhatakamanyagha ukuti shiisho bhakabhombagha mbiibhi. ");
INSERT INTO ndh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Umundu ghweshi yuuyo akuungalalila une, amanye ukuti akumukalalila nu Taata. ");
INSERT INTO ndh_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Linga indakafibhombagha kukwabho ifyika ifikulu fiifyo naayumo umundu umunine yuuyo afibhombiteemwo, po ngali bhatali ni mbiibhi. Loole ulu bhashibhweni shooshi shiisho ingashibhombagha, poope bhakaali bhakuungalalila une nu Taata. ");
INSERT INTO ndh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ishi shibhombiighwe ukuti amashu ghaagho ghasimbiighwe mu Masimbo aMeelu ghabhombighwe, paapo ghasimbiighwe ukuti, ‘Bhakaangalalila chishita nongwa naayimo.’ ");
INSERT INTO ndh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Indiingamutume uMbepo uMwelu ughwa kubhaafwa ukufuma kwa Chaala. Linga iisa, indiakalingaaniange ubhwanalooli bhwangu. ");
INSERT INTO ndh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Soona, nuumwe indimukabhalingaaniange abhandu abhangi ubhwanalooli bhwangu paapo mwali pamupeene nuune ukufuma kubhwandilo.” ");
INSERT INTO ndh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","UYeesu akeendelela ukuyugha na bhamanyili bhaake akati, “Naabhabhuula shooshi ishi ukuti nalinga shikuya kubhoneka, manye mukanyomokaghe nu kuleka ukuunyiitika. ");
INSERT INTO ndh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Loole abhandu indibhakabhakiishange umwe mu masinaghoghi ghaabho. Soona, akabhalilo kakwisa kaako abhandu bhaabho bhakubhaghogha umwe, indibhakiinongʼonaghe ukuti ku sila iyo bhali pakubhomba imbombo iya Chaala. ");
INSERT INTO ndh_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Abhandu abho indibhakabhabhombelaghe ulwo ku nongwa iya kuti bhatamumeenye uTaata, soona bhataameenye nuune. ");
INSERT INTO ndh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Loole naabhabhuula isho ukuti linga akabhalilo kaabho aka kushibhomba isho kaafika, mukakumbukaghe ukuti ingabhabhuula. Indakabhabhuula shooshi isho ukwandila paapo mukabha bhamanyili bhangu ku nongwa iya kuti ingabha pamupeene nuumwe.” ");
INSERT INTO ndh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Loole ulu ingughaluka ukubhuuka kwa Taata yuuyo akaanduma kukwinyu. Ataliipo naayumo pakati papiinyu ughwa kuumbuusha ukuti, ‘Kali, kubhuuka kuughu?’ ");
INSERT INTO ndh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mwaswimaana mu ndumbula shiinyu paapo naabhabhuula ukuti ingughaluka ukubhuuka kwa Taata. ");
INSERT INTO ndh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ingubhabhuula ubhwanalooli, kiisa kukwinyu ukuti une imbuuke kwa Taata, paapo linga indaabhuuka, uMbepo uMwelu ughwa kubhaafwa atabhaghiile ukwisa. Loole linga naabhuuka, indiingamutume uMbepo kukwinyu. ");
INSERT INTO ndh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bhwo uMbepo iisa, indiakabhashimikishe abhandu abha mu chiisu ichi ukuti imbiibhi yo yiliku, ubhwanalooli bhwo bhuliku nu kuti ubhulongi ubhwa Chaala bhwo bhuliku. ");
INSERT INTO ndh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","UMbepo uMwelu indiakalangishe pabhwelu ukuti abhandu bhatulanongwa paapo bhatakuunyiitika une. ");
INSERT INTO ndh_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Indiakalangishe pabhwelu kukwabho ukuti une ingubhomba shiisho shibhaghiile pandaashi pa Chaala paapo ingughaluka ukubhuuka kwa Taata nu kuti mutaamukaambone soona. ");
INSERT INTO ndh_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Indiakabhalangishe pabhwelu ukuti uChaala indiakabhalonge paapo amulongite uSeetano yuuyo ghwi songo ughwa bhatulanongwa bhooshi abha mu chiisu ichi. ");
INSERT INTO ndh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ingaali indi nasho nyingi isha kubhabhuula, loole ulu mutabhaghiile ukushaaghania shiisho ingubhabhuula. ");
INSERT INTO ndh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Linga uMbepo ughwa nalooli iisa kukwinyu, indiakabhalongoshange ukubhumanya ubhwanalooli bhwoshi ukufuma kwa Chaala. Ataaakayughaghe ku maka ghaake mwene, loole indiakayughaghe shiisho indiakashipulikaghe nu kubhabhuula shiisho indishikabhonekaghe mundaashi mumwinyu. ");
INSERT INTO ndh_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","UMbepo uyo indiakaangindikaghe une paapo indiakabhabhuulaghe shooshi shiisho indiakapokeelaghe ukufuma kukwangu. ");
INSERT INTO ndh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Utundu twoshi tuutwo uTaata ali natwo twangu. Yo yiiyo nongwa iyi naayugha ukuti uMbepo uyo indiakabhabhuulaghe shooshi shiisho indiakapokeelaghe ukufuma kukwangu.” ");
INSERT INTO ndh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","UYeesu akeendelela ukubhabhuula abhamanyili bhaake akati, “Kaashaala akabhalilo kapimba mutaamuumbonaghe, soona kaashaala akabhalilo kapimba indimuumbonaghe soona.” ");
INSERT INTO ndh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Po abhamanyili bhaake bhamu bhakabhuusania bheene-bheene bhakati, “Kali, kwo kuti kooni apa akuti, ‘Kaashaala akabhalilo kapimba mutaamuumbonaghe, soona kaashaala akabhalilo kapimba indimuumbonaghe soona,’ nu kuti, ‘Ingughaluka ukubhuuka kwa Taata’?” ");
INSERT INTO ndh_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Po abhamanyili bhala bhakeendelela ukubhuusania bheene-bheene bhakati, “Kali, kwo kuti kooni ‘akabhalilo kapimba’? Utwe tutakushaaghania isho shiisho akuyugha.” ");
INSERT INTO ndh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","UYeesu akashaaghania ukuti abhamanyili bhala bhakulonda ukumubhuusha ku shiisho aayugha, po akabhabhuusha akati, “Kali, mukubhuusania bheene-bheene ku shiisho naayugha naati, ‘Kaashaala akabhalilo kapimba mutaamuumbonaghe, soona kaashaala akabhalilo kapimba indimuumbonaghe soona’? ");
INSERT INTO ndh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nalooli ingubhabhuula, umwe indimukalilaghe nu kuswimaana, loole abhandu abha mu chiisu ichi indibhakasekelaghe. Indimukaswimaane ku kabhalilo akapimba, loole ubhuswimaane bhwinyu indibhukasanuke ukubha lusekelo. ");
INSERT INTO ndh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Linga umukolo akuya pakupaapa, akubha nu bhuswimaane paapo akabhalilo aka bhubhafu kaafika. Loole linga aapaapa, atakukumbuka soona ubhubhafu ubhwo ku nongwa iya lusekelo ukuti umwana aapaapighwa mu chiisu. ");
INSERT INTO ndh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bhubhuubhwo nuumwe muli nu bhuswimaane ku kabhalilo aka, loole ingwisa soona kukwinyu, po indimukabhe nu lusekelo mu ndumbula shiinyu. Naayumo umundu yuuyo indiakalutiishe ulusekelo ulwo ukufuma mu ndumbula shiinyu. ");
INSERT INTO ndh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Linga akabhalilo ako kaafika, mutaamukaasuumaghe naakamu. Nalooli ingubhabhuula, kooshi kaako mukumusuuma uTaata ukughendela ku ngamu yangu, ghwepe indiabhapange. ");
INSERT INTO ndh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ukufika ulu mutasuumite naakamu kwa Chaala ukughendela ku ngamu yangu. Suumagha kwa Chaala ghwepe indiabhapange. Ku sila iyo indimubhange nu lusekelo ulukulu mu ndumbula shiinyu.” ");
INSERT INTO ndh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","UYeesu akamaliisha ukubhabhuula abhamanyili bhaake akati, “Naabhabhuula shooshi isho ku sila iya fifwanikisho. Akabhalilo kakwisa kaako indaaingayughaghe nuumwe ku sila iya fifwanikisho, loole indiingabhabhuulaghe pabhwelu isha Taata. ");
INSERT INTO ndh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mu kabhalilo ako, indimukasuumaghe kwa Chaala ukubhombela ingamu yangu. Indakuyugha ukuti indiingabhasuumilaghe kwa Taata, nashiku, loole indimukasuumaghe yumwemwe. ");
INSERT INTO ndh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Umwene uTaata abhaghanite umwe ku nongwa iya kuti umwe muunganite une, soona mwitikite ukuti ingafuma kwa Taata. ");
INSERT INTO ndh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Une ingiisa mu chiisu ichi ukufuma kwa Taata, loole ulu ingutiila mu chiisu ichi nu kughaluka kwa Taata.” ");
INSERT INTO ndh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Po abhamanyili bhaake bhakamubhuula bhakati, “Ghwe Mumanyishi, ulu ghwanda ukuyugha nuutwe pabhwelu chishita kubhombela ififwanikisho! ");
INSERT INTO ndh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ulu twashaaghania ukuti ughwe ushimeenye shooshi, soona utakulonda umundu akubhuushange shimo. Isho sho shiisho shaatupelela ukuti twitike ukuti ughwe ukafuma kwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","UYeesu akabhabhuusha abhamanyili bhaake akati, “Kali, po mwanda ukwitika ulu? ");
INSERT INTO ndh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Akabhalilo kaapalamila soona kali papiipi leka, kaako umwe mweshi indimunyambaane. Ghweshi umundu indiabhuukaghe uyu kukwake uyu kukwake nu kuundeka nimwene. Loole indaaimbe nimwene paapo uTaata ali pamupeene nuune akabhalilo kooshi. ");
INSERT INTO ndh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mwe bhaghanighwa, naabhabhuula shooshi isho ukuti mubhange nu lutengaano mu ndumbula shiinyu paapo muunyiitikite une. Mu chiisu ichi indimushaaghaghe indamyo ni ngelo inyingi, loole manye mupaashange paapo une ingapootite amaka amabhiibhi agha mu chiisu ichi.” ");
INSERT INTO ndh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bhwo uYeesu aamala ukuyugha na bhamanyili bhaake shooshi isho, akatesha kumwanya, akiipuuta kwa Chaala akati, “Ghwe Taata, akabhalilo kangu kaafika. Ingukusuuma ubhalangishe abhandu ubhukulumba bhuubhwo ghuumbiile une ni Mwana ghwako ukuti nuune imbalangishe ubhukulumba bhwako muumwo bhubheeliile. ");
INSERT INTO ndh_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Paapo ukaamba amaka agha kulongosha abhandu bhooshi ukuti bhaabho bhakuunyiitika, imbape ubhwumi ubhwa bhwila na bhwila. ");
INSERT INTO ndh_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ubhwumi ubhwa bhwila na bhwila bhwo ubhu, abhandu bhakumanye ughwe ukuti ghweghwe ghwe Chaala ghwa nalooli, soona bhaamanye nuune ni Yeesu Kilisiti nee ukaanduma kukwabho. ");
INSERT INTO ndh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Une naalangisha ubhukulumba bhwako ku bhandu ku sila iya kumaliisha imbombo yooshi yiiyo ukaanduma pakubhomba pa chiisu ichi. ");
INSERT INTO ndh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ghwe Taata, ingukusuuma ulangishe ubhukulumba bhwako kukwangu bhuubhwo ingabha nabhwo bhwo tuli pamupeene, na bhwo ukaali ukupela ichiisu.” ");
INSERT INTO ndh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","UYeesu akeendelela ukwipuuta akati, “Ghwe Taata, ukaamba abhandu abha ukufuma mu chiisu ichi ukuti bhabhe bhamanyili bhangu, nuune naabhamanyisha muumwo ughwe ubheeliile. Bhoope bhaako, soona bhashibhombite shooshi shiisho ukabhalaghila ukuti bhabhombaghe. ");
INSERT INTO ndh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ulu bhaamanya ukuti utundu twoshi tuutwo ukaamba, tufumite kukwako. ");
INSERT INTO ndh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Paapo imbabhuulite shooshi shiisho ukaandaghila ukuti imbabhuule, bhoope bhashipokeelite, bhameenye nalooli ukuti ifumite kukwako, soona bhiitikite ukuti ghweghwe ukaanduma. ");
INSERT INTO ndh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ingubhiipuutila bhooshi bhaabho ukabhabhiika ukubha bhamanyili bhangu ku nongwa iya kuti bhandu bhaako. Indakubhiipuutila abhandu abha mu chiisu ichi bhaabho bhatakuunyiitika une. ");
INSERT INTO ndh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Abhandu bhooshi bhaabho bhangu, nuughwe bhaako, soona abhandu bhooshi bhaabho bhaako, nuune bhangu. Abhandu bhaabhubhona ubhukulumba bhwangu muumwo bhubheeliile ukughendela kukwabho. ");
INSERT INTO ndh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mu kabhalilo akapimba kaako kakwisa, une indiindiile mu chiisu ichi ukuti niise kukwako, loole abheene indibheendelelaghe ukubha mu chiisu ichi. Ghwe Taata, ghwe Mwelu, ingukusuuma ubhalindililaghe ku maka ghaako ghaagho ghuumbiile ukuti bhabhange pamupeene isa muumwo une nuughwe tuli pamupeene. ");
INSERT INTO ndh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bhwo ingwikala pamupeene nabho pa chiisu ichi, ingabhalindililagha ku maka ghaako ghaagho ghuumbiile. Une ingabhasungagha akiisa nu kuti atakabhaapo naayumo yuuyo akasobha, loole mwene yula yuuyo shikasimbighwa ukuti ghwa kufwa, ukuti shibhombighwe shiisho shisimbiighwe mu Masimbo aMeelu. ");
INSERT INTO ndh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ghwe Taata, ulu indi mu sila ukwisa kukwako. Une naabhabhuula shooshi isho abhamanyili bhangu bhwo ingaali ingwikala pamupeene nabho pa chiisu ichi ukuti bhabhange nu lusekelo ngaani mu ndumbula shaabho isa muumwo une indi nu lusekelo. ");
INSERT INTO ndh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Imbabhuulite abhamanyili bhangu amashu ghaagho ukaandaghila ukuti imbabhuule. Loole abhandu bhaabho bhakukukaana ughwe bhabhabhengite abhamanyili bhangu, ku nongwa iya kuti bhatali ungati bhandu bhaabho bhakukukaana ughwe, isa muumwo une indali ungati bhandu bhaabho bhakukukaana ughwe. ");
INSERT INTO ndh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ghwe Taata, indakusuuma ukuti ubhatiishe abhamanyili bhangu mu chiisu ichi, loole ingusuuma ukuti ubhapokaghe ku Mubhiibhi yula. ");
INSERT INTO ndh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Abhamanyili bhangu bhatali ungati bhandu abha mu chiisu ichi isa muumwo une indali ghwa mu chiisu ichi. ");
INSERT INTO ndh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ghwe Taata, ingukusuuma ubhabhiike ukubha bhandu bhaako lwoshi ku bhwanalooli bhwako paapo ishu lyako lyo liilyo bhwanalooli. ");
INSERT INTO ndh_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Isa muumwo ukaanduma une mu chiisu pakubhomba imbombo yaako, bhubhuubhwo nuune naabhatuma mu chiisu pakubhomba imbombo yaako. ");
INSERT INTO ndh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ingwifumya ukukubhombela ughwe ku nongwa yaabho ukuti bhoope bhiifumye kukwako ku sila iya mashu ghaako ghaagho gha nalooli.” ");
INSERT INTO ndh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","UYeesu akeendelela ukwipuuta akati, “Indakubhiipuutila abhamanyili bhangu bheene, loole ingubhiipuutila na bhanine bhaabho indibhaanyiitike ku nongwa iya shiisho abhamanyili bhangu bhakumanyisha. ");
INSERT INTO ndh_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ghwe Taata, ingukusuuma ubhabhiike bhooshi bhabhange pamupeene isa muumwo une nuughwe tuli pamupeene. Ingubhasuumila bhabhange pamupeene nuutwe ukuti abhandu bhaabho bhatakuunyiitika, bhiitike ukuti ghweghwe ukaanduma. ");
INSERT INTO ndh_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ubhukulumba bhuubhwo ukaamba, nuune imbapiile abhamanyili bhangu ukuti bhabhange pamupeene isa muumwo une nuughwe tuli pamupeene. ");
INSERT INTO ndh_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Isa muumwo une indi pamupeene nabho, nuughwe uli pamupeene nuune, bhubhuubhwo ingubhiipuutila bhoope bhabhange pamupeene ukuti abhandu bhaabho bhatakuunyiitika bhamanye ukuti ghweghwe ukaanduma. Soona bhamanye ukuti ubhaghanite isa muumwo ghuunganiile une. ");
INSERT INTO ndh_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ghwe Taata, ingunyonywa ukuti abhamanyili bhaabho ukaamba bhabhange pamupeene nuune kwoshi kuukwo indiimbange ukuti bhateshe ubhukulumba bhuubhwo ukaamba. Ukabhomba ulwo ku nongwa iya kuti ukaangana na bhwo ukaali ukupela ichiisu. ");
INSERT INTO ndh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ghwe Taata, ghwe ghwanalooli, pamupeene nu kuti abhandu bhaabho bhatakuunyiitika bhatakumeenye, une ingumeenye na bhamanyili bhangu bhameenye ukuti ghweghwe ukaanduma. ");
INSERT INTO ndh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nuune naabhamanyisha muumwo ughwe ubheeliile, soona indineendelelaghe ukubhomba ulwo ukuti bhaghananaghe bheene-bheene isa muumwo ghuunganiile une nu kuti imbange pamupeene nabho.” ");
INSERT INTO ndh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bhwo uYeesu aamala ukwipuuta, akatiila na bhamanyili bhaake nu kulobhoka ichisooko icha Kinduloni nu kwingila mu chibheela icha makokwe agha mishunguti chiicho chikabhaapo pabhuyo bhula. ");
INSERT INTO ndh_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Po uYuuta yuuyo akayanga pakumubhiika uYeesu mu tukono utwa bhalughu, akachimanya ichibheela icho paapo uYeesu na bhamanyili bhaake bhakiisubhila ukubhuuka mu chibheela icho mu tubhalilo utwingi. ");
INSERT INTO ndh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Po uYuuta akachilongosha ichilundilo icha bhashikali na bhabhombi bhamu bhaabho bhakatumighwa na bhosongo abha bhapuuti na Bhafalisaayi ukubhuuka mu chibheela icho. Bhwo bhakubhuuka, bhakapimba inyaale, ifikooka ni filwilo ifya bhwite. ");
INSERT INTO ndh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","UYeesu akabha ameenye shooshi shiisho indishibhombighwe kukwake. Po akatiila pakati pa bhamanyili bhaake, akiilangisha pabhwelu pa chilundilo chila, akabhabhuusha akati, “Kali, mukumulonda ghwini?” ");
INSERT INTO ndh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bhoope bhakamwamula bhakati, “Tukumulonda uYeesu yuuyo akufuma mu kaaya aka Naasaleeti.” UYeesu akabhaamula akati, “Une nee Yeesu yuuyo mukumulonda.” Mu kabhalilo ako, uYuuta yuuyo akayanga pakumubhiika uYeesu mu tukono utwa bhalughu akabha iimite pamupeene ni chilundilo icha bhashikali bhala. ");
INSERT INTO ndh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Po bhwo uYeesu aabhabhuula ukuti, “Une nee Yeesu yuuyo mukumulonda,” abhashikali bhala bhakaghalukila kunyuma nu kughwa paase. ");
INSERT INTO ndh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bhwo bhaanyatuka, uYeesu akabhabhuusha soona akati, “Kali, mukumulonda ghwini?” Abheene bhakamwamula bhakati, “Tukumulonda uYeesu yuuyo akufuma mu kaaya aka Naasaleeti.” ");
INSERT INTO ndh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","UYeesu akabhabhuula akati, “Naabhabhuula ukuti une nee Yeesu yuuyo mukumulonda. Linga mukuundonda neene nimwene, po bhiitikishe abhamanyili bhangu abha bhabhuukaghe.” ");
INSERT INTO ndh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","UYeesu akayugha ulwo ukuti shibhombighwe shiisho akashiyugha kubhwandilo akati, “Ghwe Taata, ingabhasunga akiisa nu kuti indakamusofya naayumo mu bhala bhaabho ukaamba.” ");
INSERT INTO ndh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","USiimoni Peeteli akabha nu mumaaghi umutali ughwa bhwite, po akaghufyutula nu kupuupa ichuufwo icha kumwisa icha mutumwa ughwa mupuuti usongo. Umutumwa uyo ingamu yaake akabha ghwi Malikoosi. ");
INSERT INTO ndh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Loole uYeesu akamulaghila uPeeteli akati, “Ghwe Peeteli, ghalusha umumaaghi ghwako ughwo mu nyambi yaake. Kali, utameenye ukuti ingulondighwa ukutaamighwa isa muumwo uTaata abhaatikiile ukuti indaamighwe?” ");
INSERT INTO ndh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Po usongo ughwa bhashikali pamupeene ni chilundilo icha bhashikali na bhabhombi bhala bhaabho bhakatumighwa na Bhayuuta, bhakamukola uYeesu nu kumupinya. ");
INSERT INTO ndh_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Po bhakabhuuka taashi naghwe kwa Anasi. UAnasi akabha ghwi ghwisefyala ughwa Kayaafa. UKayaafa akabha mupuuti usongo mu kabhalilo ako. ");
INSERT INTO ndh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ku mashiku agha kunyuma, uKayaafa ghwe yuuyo akabhabhuula abhalongoshi abha Bhayuuta akati, “Kaali kiisa ukuti umundu yumo afwe ku nongwa iya bhandu abhingi.” ");
INSERT INTO ndh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bhwo bhakubhuuka nu Yeesu kwa Anasi, uSiimoni Peeteli nu mumanyili umunine bhakakongagha kunyuma. Umumanyili umunine yula yuuyo umupuuti usongo akamumanya akabhuuka pamupeene nu Yeesu mu lupaso ulwa nyumba iya mupuuti usongo. ");
INSERT INTO ndh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Loole uPeeteli akiima kuuse ku mulyango umukulu. Po umumanyili umunine yula yuuyo umupuuti usongo akamumanya, akafuma kuuse nu kuyugha nu mulindu yuuyo akabha mulindilili ughwa pa mulyango umukulu. Bhwo aayugha nu mulindu yula, akamwitikisha uPeeteli ukwingila mu lupaso. ");
INSERT INTO ndh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Po umulindu yula yuuyo akabha mulindilili ughwa pa mulyango ghula akamubhuusha uPeeteli akati, “Kali, nuughwe ghwe yumo mu bhamanyili abha mundu uyo?” UPeeteli akamwamula akati, “Nashiku, indaa neene.” ");
INSERT INTO ndh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ku nongwa iya kuti kukabha ni mbepo, abhatumwa na bhabhombi bhakootagha umulilo ghuughwo bhakapembela amalasha. Ghwepe uPeeteli akiima pamupeene nabho, akootagha umulilo. ");
INSERT INTO ndh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Po umupuuti usongo akamubhuusha uYeesu isha bhamanyili bhaake ni sha fimanyisho fyake. ");
INSERT INTO ndh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","UYeesu akamwamula akati, “Akabhalilo kooshi naayughagha ku bhandu bhooshi pabhwelu, naamanyishanga abhandu mu sinaghoghi na mu lupaso ulwa Nyumba iya Chaala muumwo aBhayuuta abhingi bhaakomaanagha pamupeene. Naamanyishanga ifimanyisho fyangu fyoshi pabhwelu. ");
INSERT INTO ndh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Po kali, kooni kuumbuusha une? Kali, kooni utakubhabhuusha abhandu bhaabho bhakaambulikishanga bhwo ingumanyisha? Paapo abheene bhashimeenye shiisho ingayughagha nu kumanyisha.” ");
INSERT INTO ndh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bhwo uYeesu aamala ukuyugha isho, umubhombi yumo yuuyo akiima kupiipi kukwake, akamukoma uYeesu ku maaso ni ipi nu kumubhuusha uYeesu akati, “Kali, kumwamula bhuleele ulwo umupuuti usongo?” ");
INSERT INTO ndh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","UYeesu akamwamula akati, “Linga naayugha kabhiibhi, yugha ubhubhiibhi bhwangu. Loole linga naayugha ubhwanalooli, po kali, kooni ghwangoma?” ");
INSERT INTO ndh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Po bhwo uYeesu akaali apinyiighwe, uAnasi akabhalaghila abhashikali ukumwegha uYeesu nu kubhuuka naghwe ku mupuuti usongo, uKayaafa. ");
INSERT INTO ndh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Po bhwo uSiimoni Peeteli akaali ali pakwota umulilo, abhandu bhamu bhaabho bhakabhaapo pala bhakamubhuusha bhakati, “Kali, nuughwe ghwe yumo mu bhamanyili abha mundu yula?” UPeeteli akakaana akati, “Nashiku, indaa neene.” ");
INSERT INTO ndh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Loole yumo mu bhatumwa abha mupuuti usongo, yuuyo akabha mukamu ghwa mundu yula yuuyo uPeeteli akamupuupa ichuufwo, akamumanya uPeeteli. Po akamubhuusha akati, “Kali, utaa ghweghwe naakubhweni uli pamupeene nu Yeesu mu chibheela?” ");
INSERT INTO ndh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","UPeeteli akakaana soona akati, “Indaa neene.” Po nakalinga ubhiisa akabhika. ");
INSERT INTO ndh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Po bhwo bhwacha pangeelo, abhalongoshi abha Bhayuuta bhakamwegha uYeesu ukufuma kwa Kayaafa nu kubhuuka naghwe ku nyumba ingulu, kuukwo usongo uMulooma akiikalagha. Loole aBhayuuta bhatakiingila mu nyumba ingulu iyo, ku nongwa iya kwoghopa ukuti manye bhanyale nu kushita kulya ifindu ifya chaaka icha Pasaka. ");
INSERT INTO ndh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Po uPilaati akafuma kuuse nu kubhuuka kuukwo abhalongoshi abha Bhayuuta bhakabha, akabhabhuusha akati, “Kali, umundu uyu atulite nongwa yiki yiiyo mukumusitaakila?” ");
INSERT INTO ndh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Abheene bhakamwamula bhakati, “Linga umundu uyu atakabhanga ni nongwa, ngali tutiisa naghwe kukwako.” ");
INSERT INTO ndh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","UPilaati akabhabhuula akati, “Po yumwemwe mweghe, bhuukagha naghwe ukuti muye mumulonge ukukongana ni ndaghilo shiinyu.” Loole abheene bhakamwamula bhakati, “Isilikali iya Looma yitakutwikitisha ukumulonga umundu ghweshi ku sila iya kughogha.” ");
INSERT INTO ndh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Isho shikabhombighwa ulwo ukuti shiisho uYeesu akashiyugha shibhombighwe ukulangisha muumwo indiakafwile. ");
INSERT INTO ndh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Po bhwo uPilaati aapulika isho, akiingila soona mu nyumba ingulu, akabhalaghila abhashikali ukuti bhiise nu Yeesu kukwake. Bhwo bhaafika naghwe, uPilaati akamubhuusha uYeesu akati, “Kali, ughwe ghwe Malafyale ughwa Bhayuuta?” ");
INSERT INTO ndh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Loole uYeesu akamwamula akati, “Kali, isho kuumbuusha shikufuma mu nyinongʼono shaako pamu abhandu abhanine bhakubhuulite inongwa shangu?” ");
INSERT INTO ndh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","UPilaati akamwamula akati, “Kali, une nee Muyuuta? Abhandu abha kufuma ku chiisu chaako pamupeene na bhosongo abha bhapuuti bho bhaabho bhiisa nuughwe kukwangu ukuti ingulonge. Kali, utulite nongwa yiki?” ");
INSERT INTO ndh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","UYeesu akamwamula akati, “Ubhunyafyale bhwangu bhutaa bhwa chiisu ichi. Linga bhukabhanga bhwa chiisu ichi, po abhamanyili bhangu ngali bhaandwiliile ukuti manye imbiikighwe mu tukono utwa bhalongoshi abha Bhayuuta. Loole ubhunyafyale bhwangu bhutaa bhwa chiisu ichi.” ");
INSERT INTO ndh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Po uPilaati akamubhuusha akati, “Kali, ughwe ghwe malafyale?” UYeesu akamwamula akati, “Ghweghwe ghwayugha ukuti une nee malafyale. Une ingapaapighwa pa chiisu ichi ukuti imbamanyishe abhandu ubhwanalooli. Umundu ghweshi yuuyo akuunyiitika une, akushibhombela imbombo shiisho inguyugha.” ");
INSERT INTO ndh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","UPilaati akamubhuusha akati, “Kali, ubhwanalooli kwo kuti kooni?” Bhwo aayugha isho, uPilaati akafuma soona kuuse pamupeene nu Yeesu, akabhabhuula abhalongoshi abha Bhayuuta bhala akati, “Une indaayaagha inongwa naayimo ukufuma ku mundu uyu. ");
INSERT INTO ndh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Loole muli nu lwiho ulwa kuusuuma ukuti imbaabhulile umupinyighwa yumo mu kabhalilo aka chaaka icha Pasaka chooshi ichinja. Kali, mukulonda imbaabhulile uMalafyale ughwa Bhayuuta?” ");
INSERT INTO ndh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Loole abhandu bhooshi bhakaywegha bhakati, “Nashiku! Manye utwabhulilaghe umundu uyo, loole twabhulile uBhalabha.” UBhalabha akabha mu nyumba iya bhapinyighwa akabhalilo kala ku nongwa iya kuyikaanika isilikali iya Looma. ");
INSERT INTO ndh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Po uPilaati akabhalaghila abhashikali bhaake ukuti bhamweghe uYeesu nu kumukoma ni fikoti. ");
INSERT INTO ndh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abhashikali bhakanienga ingigha iya myifwa nu kumufwasha uYeesu ku mutu. Soona bhakamufwasha umuselekesha ughwa langi iya mandongomela ukuti ghubhonekaghe ungati ghwa malafyale. ");
INSERT INTO ndh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bhakabhuukagha mundaashi mumwake nu kumulamuka bhakatingi, “Ghwaghona, ghwe Malafyale ghwa Bhayuuta!” Bhakamukomagha na mapi. ");
INSERT INTO ndh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","UPilaati akafuma kuuse soona, akachibhuula ichilundilo icha bhandu bhala akati, “Pulikisha, indiimufumye kuuse kukwinyu umundu uyu mumanye ukuti indaayaagha inongwa naayimo kukwake.” ");
INSERT INTO ndh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Po bhakamufumya uYeesu kuuse bhwo afwalite ingigha iya myifwa nu muselekesha ughwa mandongomela. UPilaati akachibhuula ichilundilo icha bhandu bhala akati, “Tesha, umundu yuuyo mukumusitaaka uyu panu.” ");
INSERT INTO ndh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bhwo abhosongo abha bhapuuti na bhabhombi abha Nyumba iya Chaala bhaamubhona uYeesu, bhakaywegha bhakati, “Mukomeele pa chikobhekano! Mukomeele pa chikobhekano!” Po uPilaati akabhabhuula akati, “Mweghe yumwemwe muye mumukomeele pa chikobhekano, paapo une indaayaagha inongwa naayimo kukwake.” ");
INSERT INTO ndh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Abhalongoshi abha Bhayuuta bhakamwamula uPilaati bhakati, “Utwe tuli nu lulaghilo luulwo lukuti linga umundu aamufuyula uChaala, akulondighwa aghoghighwe. Po ukukongana nu lulaghilo ulwo, umwene akulondighwa aghoghighwe paapo akwiyughagha ukuti umwene Mwana ghwa Chaala.” ");
INSERT INTO ndh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bhwo uPilaati aaghapulika amashu agho, akoongela ukwoghopa leka. ");
INSERT INTO ndh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Po akiingila soona nu Yeesu mu nyumba yaake ingulu, akamubhuusha akati, “Ghwe mundu ughwe, kali, ufumite kuughu?” Loole uYeesu atakamwamula naalimo. ");
INSERT INTO ndh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Po uPilaati akamubhuusha akati, “Kali, kooni utakuunyaamula? Kali, utameenye ukuti une indi na maka agha kukwabhula, soona indi na maka agha kukukomeela pa chikobhekano?” ");
INSERT INTO ndh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","UYeesu akamwamula uPilaati akati, “Uli na maka agha kubhalaghila abhandu ukuti bhaangomeele pa chikobhekano ku nongwa iya kuti uChaala akupiile amaka agho. Loole umundu yula yuuyo aambiikite mu tukono twako, ali ni mbiibhi ingulu ngaani ukukinda imbiibhi yaako.” ");
INSERT INTO ndh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bhwo uPilaati aapulika isho, akaghela ukulonda isila iya kumwabhula uYeesu, loole abhalongoshi abha Bhayuuta bhakoongela ukuywegha bhakati, “Linga ghwamwabhula umundu uyo, po utaa mumanyani ghwa Kayisaali. Umundu ghweshi yuuyo akwibhiika ukuti ghwi malafyale, akumukaanika ghwi Kayisaali.” ");
INSERT INTO ndh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bhwo uPilaati aapulika amashu agho, akafuma soona kuuse nu Yeesu, akabhuuka nu kwikala pa chitengu icha bhulongi, ubhuyo bhuubhwo ingamu yaake bhakatingi, “Lwalilo lwa Mayondo,” ingamu iyi mu Chihibhuli kwo kuti, “Ghabhata.” ");
INSERT INTO ndh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kakabha kabhalilo aka pamuusi bhwo isubha lyafika pamutu (6:00), ishiku ilya kwitendekesha ichaaka icha Pasaka. UPilaati akabhabhuula aBhayuuta akati, “Tesha, umalafyale ghwinyu uyu panu!” ");
INSERT INTO ndh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Abheene bhakaywegha bhakati, “Mughoghe! Mughoghe! Mukomeele pa chikobhekano!” UPilaati akabhabhuusha akati, “Kali, mukulonda imukomeele pa chikobhekano umalafyale ghwinyu?” Abhosongo abha bhapuuti bhakamwamula uPilaati bhakati, “Utwe tutali nu malafyale umunine, loole mwene uKayisaali!” ");
INSERT INTO ndh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Po pabhumalilo uPilaati akamubhiika uYeesu mu tukono twabho ukuti bhamukomeele pa chikobhekano. Po abhashikali bhakamwegha uYeesu nu kubhuuka naghwe. ");
INSERT INTO ndh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ghwepe akapimba ichikobhekano chaake, akafuma kuuse nu kubhuuka pabhuyo bhuubhwo mu njugha iya Chihibhuli bhakatingi Gholighoota, kwo kuti, “Bhuyo ubhwa Mungʼooso ughwa Mutu.” ");
INSERT INTO ndh_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bhwo bhaafika pala, abhashikali bhakamukomeela uYeesu pa chikobhekano. Bhakamukomeela uYeesu pa chikobhekano pamupeene na bhandu bhabhili. Yumo kulubhafu ulwa kumwisa nu munine kulubhafu ulwa kushoomi, uYeesu akabha pakati. ");
INSERT INTO ndh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","UPilaati akalaghila ukuti amasimbo ghasimbighwe nu kubhiikighwa pamwanya pa chikobhekano icha Yeesu. Amasimbo agho ghakasimbighwa ukuti, ");
INSERT INTO ndh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Amashu agho ghakasimbighwa mu njugha iya Chihibhuli, iya Chilatiini ni ya Chighiliki. Pabhuyo ubhwo paapo bhakamukomeela uYeesu pa chikobhekano, pakabha papiipi na kaaya aka Yelusaleemu. Ku sila iyo aBhayuuta abhingi bhakaghabhelengagha amashu agho. ");
INSERT INTO ndh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Po abhosongo abha bhapuuti bhakamubhuula uPilaati bhakati, “Manye usimbaghe, ‘Uyu ghwi Malafyale ughwa Bhayuuta,’ loole simba, ‘Umundu uyu akayugha akati, Une nee Malafyale ughwa Bhayuuta.’ ” ");
INSERT INTO ndh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","UPilaati akabhaamula akati, “Shiisho naalaghila ukuti shisimbighwe, shishaale bhubhuubhwo isa muumwo shaasimbighwa.” ");
INSERT INTO ndh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bhwo abhashikali bhaamukomeela uYeesu pa chikobhekano, bhakeegha imyenda yaake nu kuyiyabhania mu fibhughutila finna. Ghweshi umushikali akeegha ichibhughutila ichaake. Soona bhakeegha nu muselekesha ghwake ghuughwo ghutakasonighwa, loole ghukalukighwa ukufuma kumwanya ukufika paase. ");
INSERT INTO ndh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Po bhakayughisania bheene-bheene bhakati, “Manye tughunyaapulaghe umuselekesha ughu, loole tughukomele ikuula ukuti ghubhe ghwani.” Isho shikabhombighwa ukuti shibhoneke shiisho shisimbiighwe mu Masimbo aMeelu ukuti, “Bhakayabhana imyenda yangu, nu kughukomela ikuula umuselekesha ghwangu.” Umwo mwo muumwo abhashikali bhakabhombela. ");
INSERT INTO ndh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bhakabhaapo abhakolo bhamu bhanna bhaabho bhakiima papiipi ni chikobhekano icha Yeesu. Abhakolo abho bhakabha bho abha: ungʼina ughwa Yeesu, ungʼina umukeke ughwa Yeesu, uMaliiya umukashi ughwa Kiliyoopa nu Maliiya ughwa kufuma mu kaaya aka Maghatala. ");
INSERT INTO ndh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Umumanyili yuuyo uYeesu akamughana, ghwepe akiima pala pala, kupiipi nu ngʼina ughwa Yeesu. Bhwo uYeesu aabhabhona akati, “Ghwe maayi, mubhiike umumanyili ghwangu uyo ukubha ungati mwana ghwako.” ");
INSERT INTO ndh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Soona akamubhuula umumanyili yula akati, “Ghwe mumanyili, mubhiike umaayi uyo ukubha ungati ghwi nyoko.” Po ukwandila akabhalilo kala kala umumanyili yula akamwegha ungʼina ghwa Yeesu nu kwikala naghwe kukaaya kaake. ");
INSERT INTO ndh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ku kabhalilo ako uYeesu akamanya ukuti aamaliisha ukubhomba imbombo yaake. Po ukuti shibhombighwe shiisho shikasimbighwa mu Masimbo aMeelu, akayugha akati, “Ingwipulika inyoota.” ");
INSERT INTO ndh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pabhuyo bhula bhula pakabhaapo ni chiliilo chiicho bhakiisushaamwo indifaayi ingali. Po bhakeegha umusapa nu kughuyubhika mu ndifaayi iyo, bhakaghubhiika ku ilaashi nu kumubhiika uYeesu ku mulomu. ");
INSERT INTO ndh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bhwo uYeesu aafipa indifaayi iyo, akayugha akati, “Naamaliisha imbombo yangu!” Po akasulika umutu ghwake paase, akafwa. ");
INSERT INTO ndh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Likabha lishiku ilya Pabhuhaano liilyo aBhayuuta bhakiitendekeshanga ku nongwa iya lishiku ilya Sabhati liilyo likakongagha. Abhalongoshi abha Bhayuuta bhatakalondagha imifimba ukushaala pa fikobhekano pi ishiku ilya Sabhati paapo likabha lishiku likulu. Po bhakabhuuka kwa Pilaati, bhakamusuuma ukuti abhiitikishe bhaye bhaposole utulundi utwa bhandu bhaabho bhakabhakomeela nu kuyitiisha imifimba yaabho pa fikobhekano. ");
INSERT INTO ndh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Po abhashikali bhakabhuuka, bhakamuposola utulundi umundu ughwa kwanda nu ghwa bhubhili bhaabho bhakabhakomeela pamupeene nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Loole bhwo bhakubhuuka kwa Yeesu, bhakaagha afwile, po bhatakamuposola utulundi twake. ");
INSERT INTO ndh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Umushikali yumo akamulasa uYeesu ni ngwegho pa lubhafu. Bhwo aamulasa, ibhanda na miishi fikafuma. ");
INSERT INTO ndh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Inongwa ishi shikasimbighwa nu mundu yuuyo akashibhonagha shiisho shikabhombighwanga nu kuti shiisho akushiyugha sha nalooli. Soona, ghwepe ameenye ukuti shiisho akushiyugha sha nalooli. Po akushiyugha ishi ukuti nuumwe mwitike. ");
INSERT INTO ndh_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Isho shikabhombighwa ukuti shibhoneke shiisho shikasimbighwa mu Masimbo aMeelu ukuti, “Naayumo umundu yuuyo indiakaliposole ifupa lyake nalinga limo.” ");
INSERT INTO ndh_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Soona shisimbiighwe mu Masimbo aMeelu, pabhuyo ubhunine ukuti, “Indibhakamuteshange yula yuuyo bhakamulasa ni ngwegho.” ");
INSERT INTO ndh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bhwo isho shaakinda, akiisa umundu yumo yuuyo ingamu yaake akabha ghwi Yoosefu. Umundu uyo akafumagha mu kaaya aka Alimataayi. Umwene akabha mukongi ughwa Yeesu (ku bhushiifu ku nongwa iya kuti akabhooghopagha abhalongoshi abha Bhayuuta). Akabhuuka kwa Pilaati, akamusuuma ukuti amwitikishe aghweghe umufimba ughwa Yeesu nu kughushiila. Po uPilaati akamwitikisha, ghwepe uYoosefu akabhuuka nu kughutiisha umufimba ghula. ");
INSERT INTO ndh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Po uNikondeemu yuuyo akabhalilo kamu akabhuuka kwa Yeesu pabhushiku, akiisa ni nyemba isha lunuushi ulwisa shiisho shikabha ikiilo amalongo matatu (30). ");
INSERT INTO ndh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Po bhwo abhandu bhabhili abho bhaaghwegha umufimba ughwa Yeesu, bhakaghuniembetelela nu mwenda umwelu nu kughupaka inyemba isha lunuushi ulwisa shila ukukongana nu lwiho ulwa Bhayuuta linga bhakubhashiila abhandu. ");
INSERT INTO ndh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pabhuyo paapo bhakamukomeela uYeesu pakabhaapo ni chibheela. Mu chibheela mula mukabhaamwo ni ipumba ipya liilyo bhatakamushiilaamwo umundu naayumo. ");
INSERT INTO ndh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ku nongwa iya kuti likabha lishiku ilya kwitendekesha ku sha Sabhati, po bhakaghubhiika umufimba ughwa Yeesu mu ipumba lila paapo likabha papiipi. ");
INSERT INTO ndh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kubhuche bhwo kukaali ukulekaana pi ishiku ilya Pamulungu, uMaliiya ughwa kufuma mu kaaya aka Maghatala akabhuuka ku ipumba ilya Yeesu. Pa mulyango ughwa lipumba lila bhakiifunikilaapo iyondo ikulu, loole bhwo uMaliiya aafika, akaagha iyondo lila libhungunie. ");
INSERT INTO ndh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Po akatiila pala, akakinda lubhilo ukubhuuka kwa Siimoni Peeteli na ku mumanyili yula yuuyo uYeesu akamughana. Bhwo aafika, akabhabhuula akati, “Abhandu bhamu bhaghutiishiishe umufimba ughwa Malafyale ghwitu mu ipumba, soona tutameenye kuukwo bhaghubhiikite!” ");
INSERT INTO ndh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","UPeeteli nu mumanyili umunine yula bhakanyatuka nu kubhuuka ku ipumba. ");
INSERT INTO ndh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhooshi bhabhili bhakakindagha bhwo bhakubhuuka, loole umumanyili umunine yula akoongelaapo ukukinda ukumupoota uPeeteli nu kutala ukufika pi ipumba. ");
INSERT INTO ndh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Bhwo aafika, akafulama, akalingisha mu ipumba nu kughubhona umwenda ghuughwo bhakamushiilila uYeesu, loole atakiingilaamwo mu ipumba. ");
INSERT INTO ndh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Po uSiimoni Peeteli ghwepe akafika pala, loole umwene akiingila mu ipumba nu kughwagha umwenda ghuughwo bhakamushiilila uYeesu. ");
INSERT INTO ndh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Akachaagha ni chitambaala chiicho bhakamupinya uYeesu ku mutu. Ichitambaala icho chitakabha pamupeene nu mwenda ghuughwo bhakamushiilila uYeesu, loole chikabha chipeteke, soona chikabha cheene kulubhafu. ");
INSERT INTO ndh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Po umumanyili umunine yula yuuyo akatala ukufika pala ghwepe akiingila mu ipumba, akatesha, akashimikisha nu kwitika. ");
INSERT INTO ndh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Loole ukufika ku kabhalilo ako, abhamanyili abha Yeesu bhakabha bhakaali ukughaaghania aMasimbo aMeelu ukuti uYeesu akulondighwa ukushuuka. ");
INSERT INTO ndh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Po abhamanyili abho bhakaghaluka ukubhuuka kuukwo bhakiikalagha. ");
INSERT INTO ndh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bhwo abhamanyili abho bhaaghaluka, uMaliiya ughwa kufuma mu kaaya aka Maghatala akashaala nu kwima kuuse ku ipumba, akalilagha. Bhwo ali pakulila, akafulama nu kulingisha mu ipumba. ");
INSERT INTO ndh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bhwo aalingisha, akabhabhona abhandumi bhabhili bhaabho bhakafwala imyenda imyelu, bhiikiile paapo bhakaghulambalika umufimba ughwa Yeesu. Ughwandumi yumo akiikala ku mutu nu munine akiikala ku tulundi. ");
INSERT INTO ndh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Abhandumi abho bhakamubhuusha bhakati, “Ghwe maayi, kali, kooni kulila?” Ghwepe akabhaamula akati, “Ingulila ku nongwa iya kuti abhandu bhamu bhaghutiishiishe umufimba ughwa Malafyale ghwangu, soona indakumanya na kuukwo bhaghubhiikite!” ");
INSERT INTO ndh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bhwo uMaliiya aayugha isho, akasanusha kunyuma, akamubhona umundu yumo iimite pala pala. Umundu uyo akabha ghwi Yeesu, loole uMaliiya atakamumanyagha. ");
INSERT INTO ndh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","UYeesu akamubhuusha akati, “Ghwe maayi, kali, kooni kulila? Kali, kumulonda ghwini?” UMaliiya akiinongʼonagha ukuti umundu yula akabha mubhombi ughwa mu chibheela, po akamwamula akati, “Ghwe songo, linga ghweghwe ughutishiishe umufimba ughwa Yeesu, ingukusuuma ghuumbuule kuukwo ughubhiikite, nuune indiimbuuke pakughwegha.” ");
INSERT INTO ndh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","UYeesu akamwitisha ingamu yaake akati, “Ghwe Maliiya!” Po uMaliiya akasanusha kunyuma nu kumubhona uYeesu, akayugha mu njugha iya Chihibhuli akati, “Labhooni!” ingamu iyi kwo kuti, “Mumanyishi.” ");
INSERT INTO ndh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","UYeesu akamubhuula uMaliiya akati, “Leka, manye ghuungolaghe paapo ingaali indabhuukite kumwanya kwa Taata. Loole bhuuka ubhabhuule abhamanyili bhangu ukuti ingubhuuka kumwanya kwa Taata yuuyo ghwi Ghuuso ghwinyu, kwa Chaala ghwangu yuuyo ghwi Chaala ghwinyu.” ");
INSERT INTO ndh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Po uMaliiya ukufuma mu kaaya aka Maghatala akabhuuka ku bhamanyili abha Yeesu. Bhwo aafika, akabhaagha, akabhabhuula akati, “Tesha, une naamubhona uMalafyale uYeesu!” Po akabhalingaania shooshi shiisho uYeesu akamulaghila. ");
INSERT INTO ndh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pi ishiku lila lila ilya Pamulungu namasubha, abhamanyili abha Yeesu bhakabha bhabhungaanite mu nyumba yimo nu kupinga ifyighi ku nongwa iya kubhooghopa abhalongoshi abha Bhayuuta. Bhwo ifyighi fikaali fipinge, nakalinga, uYeesu akasetuka pabhwelu nu kwima pakati pa bhamanyili bhaake, akabhalamuka akati, “UChaala abhapange ulutengaano mu ndumbula shiinyu.” ");
INSERT INTO ndh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bhwo aayugha amashu agho, akabhalangisha abhamanyili bhaake ifilonda ifya mu tukono na chiicho chikabha pa lubhafu papaake. Bhwo abhamanyili bhaamubhona uMalafyale uYeesu, bhakasekela leka. ");
INSERT INTO ndh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","UYeesu akabhalamuka soona akati, “UChaala abhapange ulutengaano mu ndumbula shiinyu. Isa muumwo uChaala akaanduma une pa chiisu ichi, bhubhuubhwo nuune ingubhatuma umwe pa chiisu ichi.” ");
INSERT INTO ndh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bhwo uYeesu aayugha amashu agho, akabhapuutila ilyughi, akabhabhuula akati, “Pokeela uMbepo uMwelu mu ndumbula shiinyu. ");
INSERT INTO ndh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Linga mukubhahobhokela abhandu imbiibhi shaabho, uChaala ghwepe akubhahobhokela imbiibhi shaabho. Loole linga mutakubhahobhokela imbiibhi shaabho, uChaala ghwepe atakubhahobhokela imbiibhi shaabho.” ");
INSERT INTO ndh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Umumanyili yumo mu bhamanyili abha Yeesu yuuyo ingamu yaake akabha ghwi Toomasi, yuuyo bhakamwitishanga ingamu iya Mbasa, atakabha pamupeene na bhamanyili abhanine bhwo uYeesu akubhasetukila. ");
INSERT INTO ndh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Po abhamanyili abhanine bhala bhakamubhuula bhakati, “Utwe twamubhona uMalafyale uYeesu.” Loole umwene akabhaamula akati, “Une indabhaghiile ukwitika ukuti nalooli mwamubhona uMalafyale uYeesu linga indaaghabhona taashi amabhala agha misumali mu tukono twake na pa lubhafu papaake nu kumweghelesha nu twana utwa tukono twangu.” ");
INSERT INTO ndh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bhwo umulungu ghumo ghwakinda, abhamanyili abha Yeesu bhakabhungaana pamupeene soona mu nyumba yila. Ishiku ilyo nu Toomasi akabha pamupeene nabho. Ifyighi fikabha fipinge, nakalinga, uYeesu akasetuka pabhwelu, akiima pakati papaabho, akabhalamuka akati, “UChaala abhapange ulutengaano mu ndumbula shiinyu.” ");
INSERT INTO ndh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Po akamubhuula uToomasi akati, “Ghwe Toomasi, isagha ghwegheleshe na kaana aka kakono kaako pa fikufi fyangu. Soona isagha ghwegheleshe na kakono kaako pa lubhafu papangu. Manye ghwendelelaghe ukushita kwitika, loole itikagha.” ");
INSERT INTO ndh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","UToomasi akamwamula uYeesu akati, “Ughwe ghwe Malafyale ghwangu, soona ghwe Chaala ghwangu!” ");
INSERT INTO ndh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","UYeesu akamwamula akati, “Kali, ghwitika ku nongwa iya kuti ghwambona? UChaala abhasayite abhandu bhaabho bhaanyiitikite pamupeene nu kuti bhataambweni.” ");
INSERT INTO ndh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","UYeesu akabhomba ifyika ifinine ifyingi pandaashi pa bhamanyili bhaake fiifyo fitasimbiighwe mwa kalata uyu. ");
INSERT INTO ndh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ishi shisimbiighwe ukuti mwitike ukuti uYeesu ghwi Mesiiya, Mwana ghwa Chaala nu kuti ku sila iya kumwitika, mubhwaghaghe ubhwumi ubhwa bhwila na bhwila ku maka ghaake. ");
INSERT INTO ndh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bhwo isho shaakinda, uYeesu akabhasetukila soona abhamanyili bhaake kulubhafu kwa sumbi ughwa Tibheeliya, mu chiisu icha Ghalilaayi. ");
INSERT INTO ndh_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ishiku limo uSiimoni Peeteli, uToomasi yuuyo bhakamwitishanga ingamu iya Mbasa, uNataniyeeli yuuyo akafumagha mu kaaya aka Kana kaako kali mu Ghalilaayi, abhaana bhabhili abha Sebhetaayi na bhamanyili abhanine bhabhili bhakabha pamupeene. ");
INSERT INTO ndh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","USiimoni Peeteli akabhabhuula abhanine akati, “Naabhuuka pakulobha iswi.” Bhoope bhakamwamula bhakati, “Nuutwe inditubhuuke pamupeene nuughwe pakulobha iswi.” Po bhakabhuuka, bhakakwela mu bhwato, bhakalobha iswi ubhushiku bhwoshi, loole bhatakayaagha ni iswi naayimo. ");
INSERT INTO ndh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bhwo kukulekaana, uYeesu akiima ku chiseese kwa sumbi, loole abhamanyili bhaake bhatakamumanyagha ukuti ghwi Yeesu. ");
INSERT INTO ndh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Po uYeesu akabhiitisha, akabhabhuusha akati, “Mwe bhamanyani bhangu, kali, mwashaagha iswi shimo?” Abheene bhakamwamula bhakati, “Nashiku, tutaashaagha iswi naashimo.” ");
INSERT INTO ndh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","UYeesu akabhabhuula akati, “Ponia ichilepa kulubhafu ulwa kumwisa ulwa bhwato, nuumwe indimushaaghe iswi.” Po bhakaponia ichilepa mwa sumbi, loole bhakapootwa ukuchighuusa ku nongwa iya kushaagha iswi inyingi leka. ");
INSERT INTO ndh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Umumanyili yula yuuyo uYeesu akamughana akamubhuula uSiimoni Peeteli akati, “Umundu uyu ghwi Malafyale uYeesu!” Bhwo uSiimoni Peeteli aapulika ukuti ghwi Malafyale, akafwala umwenda ghwake ghuughwo akafuula bhwo aanda ukulobha iswi, akiiponia mwa sumbi yula. ");
INSERT INTO ndh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Abhamanyili abhanine bhala bhakabhuuka ku chiseese nu bhwato bhwo bhakughuusa ichilepa chiicho chikiisula iswi. Bhatakabha kubhutali na ku chiseese, loole bhakabha amatambo imya yimoyeeneeshe (100). ");
INSERT INTO ndh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bhwo bhaafika ku chiseese, bhakaagha umulilo ughwa malasha ghupembiighwe. Pamwanya pa mulilo ghula pakabha ni iswi nu mukati. ");
INSERT INTO ndh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","UYeesu akabhabhuula abhamanyili bhaake akati, “Isagha panu ni iswi shimo shiisho mwalobha.” ");
INSERT INTO ndh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Po uSiimoni Peeteli akiingila mu bhwato, akachighuusila ku chiseese ichilepa chila chiicho chikiisula iswi. Mu chilepa mula shikabhaamwo iswi ingulu imya yimo, amalongo mahaano na shitatu (153). Pamupeene nu kuti iswi shikabha nyingi leka, poope ichilepa chitakakonoka. ");
INSERT INTO ndh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","UYeesu akabhabhuula abhamanyili bhaake akati, “Isagha mulye ifindu ifya pangeelo.” Atakabhaapo umumanyili yuuyo akaghela ukumubhuusha ukuti, “Kali, ughwe ghwe ghwini?” Paapo bhakamanya ukuti ghwi Malafyale. ");
INSERT INTO ndh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","UYeesu akabhuuka nu kwegha umukati, akabhapa abhamanyili bhaake. Soona akeegha shoope iswi nu kubhomba isa bhubhuubhwo. ");
INSERT INTO ndh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ulwo lukabha lwa bhutatu uYeesu ukubhasetukila abhamanyili bhaake bhwo uChaala aamushuusha. ");
INSERT INTO ndh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bhwo bhaalya, uYeesu akamubhuusha uSiimoni Peeteli akati, “Ghwe Siimoni mwana ghwa Yoohani, kali, ghuunganite une leka ukukinda muumwo bhaanganiile abhanyaako abha?” UPeeteli akamwamula akati, “Mwo muumwo Malafyale, ughwe ushimeenye ukuti ingughanite.” UYeesu akamubhuula akati, “Sungagha akiisa abhandu bhangu bhaabho bhali isa abhonangʼooshi.” ");
INSERT INTO ndh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","UYeesu akamubhuusha uPeeteli ulwa bhubhili akati, “Ghwe Siimoni mwana ghwa Yoohani, kali, ghuunganite?” UPeeteli akamwamula akati, “Mwo muumwo Malafyale, ughwe ushimeenye ukuti ingughanite.” UYeesu akamubhuula uPeeteli akati, “Sungagha akiisa abhandu bhangu bhaabho bhali isa abhonangʼooshi.” ");
INSERT INTO ndh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akamubhuusha ulwa bhutatu akati, “Ghwe Siimoni mwana ghwa Yoohani, kali, ghuunganite?” Po uPeeteli akaswimaana paapo uYeesu akamubhuusha ulwa bhutatu ukuti, “Kali, ghuunganite?” Akamwamula akati, “Ghwe Malafyale, ughwe ushimeenye shooshi. Ushimeenye ukuti ingughanite.” UYeesu akamubhuula akati, “Sungagha akiisa abhandu bhangu bhaabho bhali isa abhonangʼooshi. ");
INSERT INTO ndh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nalooli ingukubhuula, bhwo ghwe mulumyana, ukiisubhila ukwifwasha imyenda yaako ghwimwene nu kubhuuka kwoshi kuukwo ukalondagha. Loole linga ghwaya ghwaghoma, indiukagholoshange utukono twako, umundu umunine indiakakufwashange imyenda yaako nu kubhuuka nuughwe kuukwo utiighanite ukubhuuka.” ");
INSERT INTO ndh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","UYeesu akayugha ulwo ukulangisha isila yiiyo uPeeteli indiakafwile ukuti amughindike uChaala. Bhwo uYeesu aayugha amashu agho, akamubhuula uPeeteli akati, “Ingongaghe.” ");
INSERT INTO ndh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Po uPeeteli akasanusha kunyuma, akamubhona umumanyili yuuyo uYeesu akamughana, akubhakonga. Umumanyili uyo ghwe yula yuuyo akiikala kupiipi nu Yeesu bhwo bhali pakulya ifindu ifya namasubha. Soona, ghwe yula yuuyo akamubhuusha uYeesu akati, “Ghwe Malafyale, kali, ghwini yuuyo indiakubhiike mu tukono utwa bhalughu?” ");
INSERT INTO ndh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Po bhwo uPeeteli aamubhona umumanyili yula, akamubhuusha uYeesu akati, “Ghwe Malafyale, kali, kooni kaako indikakabhoneke ku mumanyili uyo?” ");
INSERT INTO ndh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","UYeesu akamwamula uPeeteli akati, “Linga ingulonda ukuti abhange mwumi ukufika akabhalilo kaako indiingaghalukaghe, kali, kooni isho shikukutamya mu ndumbula yaako? Ughwe ingongaghe.” ");
INSERT INTO ndh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ku nongwa iya mashu agho ghaagho uYeesu akayugha, abhamanyili abhingi bhakiinongʼonagha ukuti umumanyili uyo ataaakafwe naalumo. Loole uYeesu atakamubhuulagha umumanyili uyo ukuti ataaakafwe naalumo, loole akati, “Linga ingulonda ukuti abhange mwumi ukufika akabhalilo kaako indiingaghalukaghe, kali, kooni isho shikukutamya mu ndumbula yaako?” ");
INSERT INTO ndh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Umumanyili uyo ghwe yuuyo akashishimikisha ishi nu kushisimba. Nuutwe tumeenye ukuti shiisho ashiyughite sha nalooli. ");
INSERT INTO ndh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Shiliipo imbombo inine inyingi shiisho uYeesu akashibhombagha, loole shitakasimbighwa. Linga shooshi shikasimbighwanga, ingwinongʼona ukuti ichiisu ngali chitali nu bhuyo ubhwa kusengula abhokalata bhooshi abho.");
INSERT INTO ndh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ghwe mughindikighwa Tiyofiilo, mwa kalata ghwangu ughwa bhwandilo yula ughwa Luuka ingasimba shooshi shiisho uYeesu akabhombagha na shiisho akamanyishanga ukwandila kubhwandilo, ");
INSERT INTO ndh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ukufika ishiku liilyo akeeghighwa ku chiika ukubhuuka kumwanya. Bhwo akaali ukubhaleka abhatumighwa bhaake bhaabho akabhasala, akabhabhuula ukughendela ku sila iya Mbepo uMwelu muumwo indibhakabhombele imbombo. ");
INSERT INTO ndh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ku kabhalilo aka mashiku amalongo manna (40) ukwandila bhwo aashuuka, akabhasetukila abhatumighwa bhala utubhalilo utwingi, akiilangisha pabhwelu ukuti umwene mwumi. Soona akamanyishanga inongwa isha chitangalala icha Chaala. ");
INSERT INTO ndh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ishiku limo bhwo uYeesu ali pakulya pamupeene na bhamanyili bhaake, akabhalaghila akati, “Manye mutiilaghe mu kaaya aka Yelusaleemu, loole mwikale muno muno ukufika paapo uTaata akuya pakubhapa ulusekeelesho ulwa Mbepo uMwelu isa muumwo akafinga. Ulufingo ulwo lwo luulwo mwambulikagha bhwo inguyugha inongwa shaake. ");
INSERT INTO ndh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","UYoohani akabhooshanga abhandu na miishi, loole bhwo amashiku manandi ghaakinda, umwe indimukooshighwange nu Mbepo uMwelu.” ");
INSERT INTO ndh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bhwo abhatumighwa bhaabhungaana pamupeene nu Yeesu, bhakaanda ukumubhuusha bhakati, “Ghwe Malafyale, kali, aka ko kabhalilo kaako kubhaghalushikisha aBhaisilaeli ubhunyafyale bhwabho?” ");
INSERT INTO ndh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Umwene akabhaamula akati, “Yitaa mbombo yiinyu ukumanya amashiku pamu utubhalilo tuutwo uTaata atubhaatikite ku maka ghaake mwene. ");
INSERT INTO ndh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Loole indimukapokeele amaka linga uMbepo uMwelu iisa kukwinyu, nuumwe indimukabhe bhakeeti bhangu mu kaaya aka Yelusaleemu, mu chiisu chooshi icha Yuteeya, icha Samaliiya nu kufika kuukwo ichiisu chooshi chishiliile.” ");
INSERT INTO ndh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bhwo uYeesu aamala ukuyugha isho, akeeghighwa ukubhuuka kumwanya bhwo bhakutesha. Ibhingu likamwifunika, bhatakamubhona soona. ");
INSERT INTO ndh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bhwo bhakaali bhakutesha kumwanya bhwo uYeesu akubhuuka, nakalinga abhaliisha bhabhili bhaabho bhakafwala imyenda imyelu bhakiima papiipi nabho. ");
INSERT INTO ndh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bhakabhabhuusha bhakati, “Mwe bhandu abha Ghalilaayi umwe, kali, kooni mwimite panu nu kutesha kumwanya? UYeesu uyo yuuyo uChaala aamwegha ukufuma kukwinyu nu kubhuuka naghwe kumwanya, indiakiise soona ku sila isa yiyiiyo yiiyo mwamubhona bhwo akubhuuka kumwanya.” ");
INSERT INTO ndh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Po abhatumighwa bhala bhakaghaluka ukubhuuka ku Yelusaleemu ukufuma ku kaghamba kaako bhakatingi kaghamba aka Mishunguti kaako kakabha ikilomiita yimo ukufuma mu kaaya aka Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bhwo bhiingila mu kaaya ako, bhakabhuuka mu nyumba ingelesanie muumwo bhakiikalagha. Ingamu isha bhatumighwa abho sho ishi: uPeeteli, uYoohani, uYaakobhu, uNdeleeya, uFilipu, uToomasi, uBhatolomaayi, uMataayi, uYaakobhu umwana ughwa Alufeeyo, uSiimoni uMulwila Chiisu nu Yuuta umwana ughwa Yaakobhu. ");
INSERT INTO ndh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Abhatumighwa bhooshi abha bhakabhungaana pamupeene ukwipuuta kwa Chaala. Mu bhatumighwa abho, bhakabhaamwo na bhakolo bhamu pamupeene nu Maliiya ungʼina ughwa Yeesu na bhoghwamwabho. ");
INSERT INTO ndh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ishiku limo abhiitiki abha Yeesu bhaabho bhakabha imya yimo na malongo mabhili (120) bhakabhungaana pamupeene. Po uPeeteli akiima pakati papaabho, ");
INSERT INTO ndh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","akabhabhuula akati, “Mwe bhiitiki bhanyiitu, kubhwandilo uMbepo uMwelu akamulongosha umalafyale uNdaabhiti ukusolola isha Yuuta yuuyo akabhalongosha abhandu bhala bhaabho bhakamukola uYeesu. Po ulu shooshi isho shikulondighwa shibhombighwe isa muumwo shikasimbighwa mu Masimbo aMeelu. ");
INSERT INTO ndh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","UYuuta akabha ghwe yumo mu chibhughutila chiitu paapo ghwepe akasalighwa ukuti tubhombaghe imbombo iyi pamupeene naghwe.” ");
INSERT INTO ndh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Po uYuuta akaghula umughunda ghumo ukubhombela indalama shila shiisho akashaagha ku sila imbiibhi iya kwitika ukumubhiika uYeesu mu tukono utwa bhalughu. Bhwo ali mu mughunda ghula, uYuuta akaghwa ku maka, ulufukwe lwake lukapunda na mala ghooshi ghakafumila kuuse, akafwa. ");
INSERT INTO ndh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Abhandu bhooshi bhaabho bhakiikalagha mu kaaya aka Yelusaleemu bhakapulika inongwa isha bhufwe ubhwa Yuuta. Ku nongwa iyo, bhakaghwita umughunda ghula mu njugha yaabho iya Chialamu Akelindama, kwo kuti, “Mughunda ughwa Libhanda.” ");
INSERT INTO ndh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","UPeeteli akeendelela ukuyugha akati, “Shisimbiighwe mwa kalata ughwa Sabhuli ukuti, ‘Inyumba yaake yibhe chisaami, manye abheepo umundu ughwa kwikala umwo.’ “Soona shisimbiighwe ukuti, ‘Umundu umunine akulondighwa abhombaghe imbombo yaake.’ ");
INSERT INTO ndh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Po tukulondighwa tumusale umundu umunine ughwa kumupyanila uYuuta. Umundu uyo akulondighwa abhe ghwe yumo mu bhandu bhala bhaabho bhakabha pamupeene nuutwe akabhalilo kaako tukaghendagha pamupeene nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Soona tumusale umundu yuuyo akabha pamupeene nuutwe ukufuma akabhalilo kaako uYoohani akamwoshanga uYeesu ukufika ishiku liilyo akeeghighwanga ukubhuuka kumwanya. Umundu uyo indiashimikishange ku bhandu abhanine ukuti uMalafyale ghwitu uYeesu Kilisiti ashuukite.” ");
INSERT INTO ndh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Po abhiitiki bhala bhakiitikana na shiisho uPeeteli akayugha, bhakasala ingamu isha bhandu bhabhili. Ughwa kwanda akabha ghwi Yoosefu yuuyo bhakamwitishanga ingamu iya Bhalisabha pamu Yuusito nu ghwa bhubhili akabha ghwi Maatiyaasi. ");
INSERT INTO ndh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Po bhakiipuuta kwa Chaala bhakati, “Ghwe Malafyale, ughwe ushimeenye shooshi shiisho shili mu ndumbula isha bhandu bhooshi. Tukukusuuma utulangishe mu bhandu bhabhili abha yuuyo ghwamusala, ");
INSERT INTO ndh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ukuti apyanile pa mbombo iya bhutumighwa iya Yuuta yuuyo akafwa nu kubhuuka kuukwo kumubhaghiile.” ");
INSERT INTO ndh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Po bhakabhasala ku sila iya kubhakomela ikuula abhandu bhabhili bhala, ikuula yikamughwila uMaatiyaasi. Pabhumalilo abhiitiki bhala bhakamubhelengela uMaatiyaasi ukubha mutumighwa pamupeene na bhatumighwa abhanine kalongo na yumo (11) bhala. ");
INSERT INTO ndh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bhwo ishiku ilya chaaka icha Pentekositi lyafika, abhiitiki bhooshi bhakabha bhabhungaanite pamupeene mu nyumba yimo. ");
INSERT INTO ndh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bhwo bhali mu nyumba yila, nakalinga ishu liilyo likabha ungati chikungu icha maka chikukuka likapulikighwa ukufuma kumwanya. Abhandu bhooshi bhaabho bhakabhaamwo mu nyumba yila bhakapulika ishu lila. ");
INSERT INTO ndh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Abhandu abho bhakatubhona utundu tumo tuutwo tukabha ungati mbeseese isha mulilo shiisho shikayabhanika nu kumughwila ghweshi umundu yuuyo akabhaapo pala. ");
INSERT INTO ndh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Po uMbepo uMwelu akabhiisila abhandu bhooshi bhala nu kwikala mu ndumbula shaabho. Abhandu bhala bhakaanda ukuyugha injugha inine shiisho bhatakamanyilaamwo naalumo isa muumwo uMbepo uMwelu akabhabhaghisha. ");
INSERT INTO ndh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mu kabhalilo ako, mu kaaya aka Yelusaleemu bhakabhaamwo aBhayuuta abhingi bhaabho bhakamwipuutagha uChaala. ABhayuuta abho bhakafumagha mu fyisu ifyingi muumwo bhakanyambaanila. ");
INSERT INTO ndh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bhwo bhaapulika ishu lila, ichilundilo ichikulu icha bhandu chikabhungaana pamupeene, chikaswigha leka ku nongwa iya kuti ghweshi umundu akabhapulikagha abhiitiki bhwo bhakuyugha mu njugha yaake. ");
INSERT INTO ndh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bhakaanda ukuswigha leka nu kubhuusania bheene-bheene bhakati, “Pulikisha! Kali, abhandu bhooshi abha bhaabho bhakuyugha injugha shiitu bhatafumite mu chiisu icha Ghalilaayi? ");
INSERT INTO ndh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Po kali, shili bhuleele ukuti ghweshi umundu pakati papiitu akubhapulika abhandu abho bhwo bhakuyugha mu njugha shiitu? ");
INSERT INTO ndh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pakati papiitu bhaliipo abhandu bhaabho bhafumite mu chiisu icha Palaati, Mendiya, Elaami ni cha Mesopotaamiya. Abhanine bhafumite mu chiisu icha Yuteeya, Kapandookiya, Ponto ni cha Aasiya. ");
INSERT INTO ndh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Abhanine bhafumite mu chiisu icha Filighiya, Pamufiiliya ni cha Miisili. Soona, abhanine bhafumite kulubhafu ulwa fyisu ifya Limbiya fiifyo fili kupiipi na kaaya aka Kileene na bhanine bhafumite mu chiisu icha Looma. Mu bhandu abho, bhaliimwo aBhayuuta na bhaabho bhapindukiile ku Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Soona, abhanine bhafumite mu chiisu icha Kileete ni cha Alambiya, poope tweshi tukubhapulika abhandu abha bhwo bhakuyugha mu njugha shiitu imbombo ingulu shiisho uChaala aashibhomba.” ");
INSERT INTO ndh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Abhandu bhooshi bhakaswigha leka. Po bhamu bhakeendelela ukubhuusania bheene-bheene bhakati, “Kali, shooshi ishi kwo kuti kooni?” ");
INSERT INTO ndh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Loole abhanine bhakaanda ukubhasekela bhakati, “Abhandu abha bhaghaalite ubhwalwa!” ");
INSERT INTO ndh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Po uPeeteli akiima pandaashi pamupeene na bhatumighwa abhanine kalongo na yumo (11), akayugha ku ishu ilya pamwanya, akabhabhuula abhandu bhala akati, “Mwe Bhayuuta bhanyiitu, nuumwe mweshi mwe mukwikala mu kaaya aka Yelusaleemu, imbulikishange akiisa mweshi paapo indiimbalingaanie shiisho shikubhombighwa. ");
INSERT INTO ndh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nalooli ingubhabhuula, abhandu abha bhataghaalite ubhwalwa isa muumwo mukwinongʼonela ku nongwa iya kuti ulu po pangeelo mu sala iya bhutatu (3:00).” ");
INSERT INTO ndh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ubhwanalooli bhwa kuti ishi shiisho mukushibhona nu kushipulika shikasimbighwa nu musololi uYooheli akabhalilo aka kunyuma, umwene akasimba akati, ");
INSERT INTO ndh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“UChaala akuti, ‘Ku mashiku agha bhumalilo, indiingabhape uMbepo ghwangu abhandu bhooshi. Ku sila iyo, abhaana bhiinyu abhalumyana na bhalindu indibhakasololaghe, abhalumyana bhiinyu indibhakafibhonaghe ifisetuka ukufuma kukwangu na bhosongo indibhakalootaghe ifiloota ukufuma kukwangu. ");
INSERT INTO ndh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Soona ku mashiku agho, indiingabhape uMbepo ghwangu abhabhombi bhangu abhaliisha na bhakolo ukuti bhoope bhakasololaghe. ");
INSERT INTO ndh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Indiingabhombe isha kuswighisha kumwanya nu kubhomba ifyika pa chiisu ichi. Indikukabhe ni ibhanda ilyingi pa chiisu, soona indikukabhe nu mulilo ghuughwo indighukapele ilyoshi ishisha. ");
INSERT INTO ndh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Indiingalisanushe isubha ukubha chiisi, soona indiingaghusanushe umweshi ukubha mukesamu ungati libhanda. Isho shooshi indishikabhoneke bhwo ishiku ikulu ilya kuswighisha ilya Malafyale uChaala likaali ukwisa. ");
INSERT INTO ndh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Umundu ghweshi yuuyo akumwitisha uMalafyale, indiapokighwe.’ ” ");
INSERT INTO ndh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","UPeeteli akeendelela ukuyugha akati, “Mwe Bhaisilaeli bhanyiitu, imbulikishange shiisho ingubhabhuula! Bhwo uYeesu yuuyo akafumagha mu kaaya aka Naasaleeti akwikala nuumwe, uChaala akamulangisha kukwinyu ku sila iya kumupa amaka agha kubhomba ifyika ifyingi ifya kuswighisha fiifyo fikalangishanga ukuti afumite kukwake. Nuumwe mumeenye ukuti ishi sha nalooli. ");
INSERT INTO ndh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ukukongana nu lubhaatiko lwake, uChaala akiitikisha ukuti uYeesu abhiikighwe mu tukono twinyu. Nuumwe mukamughogha ku sila iya kumukomeela pa chikobhekano ukubhombela utukono utwa bhandu bhaabho bhatakushikonga indaghilo isha Chaala. ");
INSERT INTO ndh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Loole uChaala akamwabhula ku maka agha bhufwe nu kumushuusha ku nongwa iya kuti shitakabhaghila ukuti ubhufwe bhubhe na maka kwa Yeesu. ");
INSERT INTO ndh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Paapo umalafyale uNdaabhiti akasimba inongwa shaake akati, ‘Ingamubhona uMalafyale uChaala ali papiipi nuune akabhalilo kooshi. Ku nongwa iya kuti ali pamupeene nuune, indabhaghiile ukubhooghopa abhandu bhaabho bhakulonda ukuufulasha. ");
INSERT INTO ndh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ku nongwa iyo, indumbula yangu yihobhokite leka, soona ingukupaala ku lusekelo ughwe Chaala ghwangu. Ingwendelela ukukusubhaalila ukuti indiukaambiike ukubha mwumi soona, ");
INSERT INTO ndh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","paapo utaaukiitikishe ukuti une ishaale ku bhushuuka. Soona utaaukaghuleke umubhili ughwa Mwelu ghwako ghubhole. ");
INSERT INTO ndh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ghwandangisha isila yiiyo yikubhuuka ku bhwumi. Indighuuhobhoshe leka ku nongwa iya kuti indiubhange pamupeene nuune akabhalilo kooshi.’ ” ");
INSERT INTO ndh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","UPeeteli akeendelela ukuyugha akati, “Mwe bhoghwamwitu, Bhaisilaeli, ingulonda imbabhuule pabhwelu ukuti usekulu ghwitu uNdaabhiti akafwa nu kushiilighwa, ni ipumba lyake liliipo panu ukufika umuusughu. ");
INSERT INTO ndh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Loole tumeenye ukuti uNdaabhiti akabha musololi, soona akamanya ukuti uChaala akiitikana naghwe ukwitikana ukwa maka ukuti indiakamubhiike umundu yumo ukufuma mu chikolo chaake yuuyo indiakabhe ghwi malafyale isa yuuyo. ");
INSERT INTO ndh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","UNdaabhiti akashimanya isha mundaashi shiisho uChaala akashibhaatika ukushibhomba. Yo yiiyo nongwa iyi akayugha ukuti uChaala indiakamushuushe soona uMesiiya, nu kuti, ‘UChaala ataaakiitikishe ukuti uMesiiya ashaale ku bhushuuka nu kuti umubhili ghwake ghutaaghukabhole.’ ” ");
INSERT INTO ndh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“UChaala akamushuusha umundu uyu uYeesu, nuutwe twe bhakeeti ku shooshi isho. ");
INSERT INTO ndh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bhwo uYeesu aashuuka, uChaala akamukwesha kumwanya nu kumubhiika pabhuyo ubhwa lughindiko ku kakono kaake aka kumwisa. UChaala uGhwise akamupa uYeesu uMbepo uMwelu isa muumwo akafinga. Po uYeesu akamutuma uMbepo uMwelu uyo ukwikala pamupeene nuutwe nu kuti ghwe yuuyo aashilangisha isho shooshi shiisho mukushibhona nu kushipulika. ");
INSERT INTO ndh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tweshi tumeenye ukuti uNdaabhiti atakiiyughagha yuuyo panu ku nongwa iya kuti atakakwela ukubhuuka kumwanya isa uYeesu, loole umwene akayugha akati, ‘UMalafyale uChaala akamubhuula uMalafyale ghwangu akati, “Ikala kakono kangu aka kumwisa, ");
INSERT INTO ndh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ukufika paapo indiingabhabhiike abhalughu bhaako paase pa tulundi twako.” ’ ” ");
INSERT INTO ndh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","UPeeteli akayugha akati, “Po mwe bhandu mweshi abha mu chiisu icha Isilaeli, mumanye ubhwanalooli ukuti uYeesu yuuyo mukamukomeela pa chikobhekano, uyo ghwe yuuyo uChaala amubhiikite ukubha ghwi Malafyale soona ghwi Mesiiya.” ");
INSERT INTO ndh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bhwo abhandu bhala bhaapulika amashu agha Peeteli, amashu ghala ghakabhalasa mu ndumbula shaabho, bhakaanda ukumubhuusha uPeeteli na bhatumighwa abhanine bhakati, “Mwe bhoghwamwitu, kali, tubhombe kooni?” ");
INSERT INTO ndh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","UPeeteli akabhaamula akati, “Ghweshi umundu akulondighwa ukupinduka nu kwilaata imbiibhi shaake nu kwoshighwa mu ngamu iya Yeesu Kilisiti ukuti uChaala abhahobhokele imbiibhi shiinyu nu kubhapa uMbepo uMwelu. ");
INSERT INTO ndh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Paapo uChaala akabhiika ulwitikano ulu ku nongwa yiinyu na bhaana bhiinyu, soona ku nongwa iya bhandu abhanine bhala bhaabho bhali kubhutali. UMalafyale uChaala ghwitu indiakabhape uMbepo ghwake abhandu bhooshi bhaabho indiakabhasale ukubha bhandu bhaake.” ");
INSERT INTO ndh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Po uPeeteli akabhasoka ku mashu amanine amingi nu kwendelela ukubhasuuma abhandu bhala akati, “Musuumaghe uChaala ukuti abhapoke ku mbaapo imbiibhi iyi.” ");
INSERT INTO ndh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Po abhandu bhala bhooshi bhaabho bhakaghiitika amashu agha Peeteli, bhakooshighwa. Pi ishiku lila abhandu abhapya bhaabho bhakiitika ukubha bhiitiki abha Yeesu Kilisiti bhakabha abhoelufu bhatatu (3,000). ");
INSERT INTO ndh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abhiitiki abhapya abho bhakeendelela ukupulikisha nu kufibhombela imbombo ifimanyisho ifya bhatumighwa, bhakakomaanagha pamupeene na bhiitiki abhanine. Soona bhakalyanga ifindu pamupeene nu kwipuuta kwa Chaala pamupeene. ");
INSERT INTO ndh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Abhandu bhooshi bhakaanda ukumughindika uChaala ngaani ku nongwa iya kuti akabhapanga abhatumighwa amaka agha kubhomba ifyika ifikulu ngaani. ");
INSERT INTO ndh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abhiitiki bhooshi bhakeendelela ukubha kandu kamukeene nu kubhombela pamupeene utundu twoshi tuutwo bhakabha natwo. ");
INSERT INTO ndh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Soona utubhalilo utwingi bhakaghulishanga ifyuma fyabho nu tundu twoshi tuutwo bhakabha natwo, indalama shiisho bhakashaaghagha, bhakamupanga ghweshi umundu ukukongana na muumwo akalondelagha. ");
INSERT INTO ndh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Amashiku ghooshi bhakeendelelagha ukukomaana pamupeene mu lupaso ulwa Nyumba iya Chaala. Bhakabheghulanianga umukati pamupeene mu nyumba shaabho, bhakalyanga ifindu pamupeene ku lusekelo na ku ndumbula iya kwiyiisha, ");
INSERT INTO ndh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","bhakamupaalagha uChaala nu kubhahobhosha abhandu bhooshi. Lyoshi ishiku uMalafyale uYeesu akoongeleshanga ku chibhughutila chaabho ukubhiingisha abhandu abhapya bhala bhaabho bhakapokighwanga. ");
INSERT INTO ndh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ishiku limo uPeeteli nu Yoohani bhakakwelagha ukubhuuka mu lupaso ulwa Nyumba iya Chaala pakwipuuta bhwo lyafika mu sala iya bhuhaano na inna (9:00). ");
INSERT INTO ndh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mu kaaya kala akabhaamwo umundu yumo yuuyo akabha ghwi chikwefu ukufuma ukupaapighwa kwake. Mu tubhalilo utwingi abhandu bhamu bhakamupimbagha umundu uyo, bhakamubhiikagha pa mulyango umukulu ughwa lupaso ulwa Nyumba iya Chaala ghuughwo bhakatingi Mulyango Mwisa. Pa mulyango ughwo po paapo uchikwefu uyo akasuumilishanga indalama ku mundu ghweshi yuuyo akiingilagha nu kufuma mu Nyumba iyo. ");
INSERT INTO ndh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bhwo uchikwefu yula aabhabhona uPeeteli nu Yoohani bhakwingila mu lupaso ulwa Nyumba iya Chaala yila, akabhasuuma ukuti bhamupe indalama shimo. ");
INSERT INTO ndh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","UPeeteli nu Yoohani bhakamulubhaalila ku maka. Po uPeeteli akamubhuula uchikwefu yula akati, “Ghwe mundu ughwe, tuteshange utwe!” ");
INSERT INTO ndh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Po umundu yula akaanda ukubhatesha bhwo akusubhaalila ukuti indibhamupe indalama shimo. ");
INSERT INTO ndh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Loole uPeeteli akamubhuula uchikwefu yula akati, “Une indali ni ndalama pamu isahabhu, loole kaako indi nako ko kaako indiingupe. Mu ngamu iya Yeesu Kilisiti ughwa kufuma mu kaaya aka Naasaleeti, ingukubhuula, nyatuka, ghendagha!” ");
INSERT INTO ndh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Po uPeeteli akamukola akakono aka kumwisa umundu yula, akamwimika, nakalinga umundu yula akapola ubhulemale bhuubhwo akabha nabhwo, utulundi twake tukabha na maka. ");
INSERT INTO ndh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Po akanyeela nu kwima, akaanda ukughenda yuuyo mwene. Akiingila mu lupaso ulwa Nyumba iya Chaala pamupeene nu Peeteli nu Yoohani, akaghendagha nu kunyeela-nyeela bhwo akumupaala uChaala. ");
INSERT INTO ndh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abhandu bhooshi bhaabho bhakabhaamwo mu lupaso ulwa Nyumba iya Chaala yila bhakamubhona umundu uyo bhwo akughenda nu tulundi twake mwene, akumupaala uChaala. ");
INSERT INTO ndh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bhwo bhaamumanya ukuti umundu uyo ghwe yuuyo akiikalagha nu kusuumilisha pa mulyango ughwa Nyumba iya Chaala ghuughwo bhakatingi Mulyango Mwisa, bhakaswigha leka ku shiisho shikabhombighwa kukwake. ");
INSERT INTO ndh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mu kabhalilo ako, umundu yula yuuyo akapola ubhulemale bhwake akabhakongagha uPeeteli nu Yoohani. Abhandu bhooshi bhakaswighagha leka, bhakaanda ukubhakindilila uPeeteli nu Yoohani ukufika pi ibhalaasa liilyo bhakatingi Libhalaasa ilya Solomooni. ");
INSERT INTO ndh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bhwo uPeeteli aabhabhona abhandu bhaabho bhakabha bhabhungaanite, akabhabhuula akati, “Mwe bhandu abha Isilaeli, kali, kooni mukuswigha ishi shiisho shaabhoneka? Kali, kooni mukutulubhaalila ku maka? Kali, mukwinongʼona ukuti twamuposha umundu uyu ku maka ghiitu, pamu ku nongwa iya kuti utwe tukubhomba inyiisa pandaashi pa Chaala? ");
INSERT INTO ndh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","UChaala yuuyo abhosekulu bhiitu uAbhulahamu, uIsiyaka nu Yaakobhu bhakamwipuutagha, ghwe yuuyo akamupa ubhukulumba uYeesu, uMubhombi ghwake. Loole mukamubhiika mu tukono utwa bhalughu ukuti bhamughoghe. Umwe mukamukaana uYeesu pandaashi pa Pilaati pamupeene nu kuti uPilaati akalondagha ukuti amwabhule. ");
INSERT INTO ndh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Umwe mukamukaana uMwelu uyo yuuyo akabhalilo kooshi akabhombagha shiisho shibhaghiile pandaashi pa Chaala, loole mukamusuuma uPilaati ukuti amwabhule umundu yula yuuyo akabha mughoghi. ");
INSERT INTO ndh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mukamughogha uYeesu yuuyo Mupeli ughwa bhwumi, loole uChaala akamushuusha. Nuutwe twe bhakeeti abha kushuuka kwake. ");
INSERT INTO ndh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ku nongwa iya kwitika kwitu mu ngamu iya Yeesu, umundu uyu yuuyo mukumubhona soona mumumeenye, aabha na maka soona. Ukughendela mu ngamu iyo nu kumwitika umwene kwo kuukwo kwamuposha umundu uyu lwoshi isa muumwo mwibhonela yumwemwe. ");
INSERT INTO ndh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mwe bhoghwamwitu, Bhaisilaeli, imeenye ukuti shila shooshi shiisho umwe pamupeene na bhalongoshi bhiinyu mukamubhombela uYeesu, mukabhomba ulwo ku nongwa iya kushita kumanya kwinyu. ");
INSERT INTO ndh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Loole ku sila iyi uChaala ashibhombite shila shiisho akashiyugha ukughendela ku bhasololi bhaake bhooshi ukuti indibhakamufulashe uMesiiya. ");
INSERT INTO ndh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Po pindukagha nu kwilaata imbiibhi shiinyu nu kuyiitika indumi ukufuma kwa Chaala ukuti abhahobhokele imbiibhi shiinyu shooshi. ");
INSERT INTO ndh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Soona, uMalafyale uChaala indiabhaafwe ku sila iya kumutuma kukwinyu uKilisiti uYeesu yula yuuyo akabhasalila umwe ukufuma kubhwandilo. ");
INSERT INTO ndh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","UYeesu akulondighwa ashaale kumwanya ukufika akabhalilo kaako uChaala indiakatupele utundu twoshi tuutwo akatupela ukubha tupya isa muumwo akafinga ukughendela ku bhasololi bhaake abheelu abha bhwila. ");
INSERT INTO ndh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yo yiiyo nongwa iyi umusololi uMoose akayugha akati, ‘UMalafyale uChaala ghwinyu indiakabhasalile umusololi ukufuma pakati papiinyu yuuyo indiakabhe isa neene. Amashu ghooshi ghaagho umusololi ghwake uyo indiakabhabhuulaghe, mukamupulikaghe. ");
INSERT INTO ndh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Umundu ghweshi yuuyo ataaakamupulikishange umusololi uyo, uChaala indiakamutiishe lwoshi ukufuma mu chibhughutila icha bhandu bhaake nu kumupyuta.’ ");
INSERT INTO ndh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Imbombo shooshi shiisho shikubhoneka ku mashiku agha, sho shiisho abhasololi abha Chaala bhakasolola ukwandila akabhalilo kaako uSamweli akasololagha ukufika akabhalilo kaako abhasololi abhanine bhooshi bhakasololagha. ");
INSERT INTO ndh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Inongwa shila shiisho uChaala akashiyugha ukughendela ku bhasololi bhaake abho, sho shiisho umwe mukushipokeela isa muumwo uChaala akiitikana na bhosekulu bhiinyu bhwo akumubhuula uAbhulahamu akuti, ‘Ukughendela mu chikolo chaako, indiingabhasaye abhandu abha fikolo fyoshi ifya pa chiisu panu.’ ” ");
INSERT INTO ndh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","UPeeteli akamaliisha ukuyugha akati, “Yo yiiyo nongwa iyi bhwo uChaala aamutuma uMubhombi ghwake uYeesu pa chiisu ichi, akamutuma taashi kukwinyu ukuti abhasaye umwe mweshi ku sila iya kubhaafwa umwe ukushileka imbiibhi shiinyu nu kwanda ukubhomba shiisho shibhaghiile pandaashi papaake.” ");
INSERT INTO ndh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mu lupaso ulwa Nyumba iya Chaala muumwo uPeeteli nu Yoohani bhakayughagha na bhandu, bhakabhaamwo abhapuuti bhamu, umushikali usongo ughwa bhalindilili abha Nyumba iya Chaala na Bhasandukaayi bhamu. Abhandu abho bhakiisa kwa Peeteli nu Yoohani bhwo bhakaali bhali pakuyugha na bhandu. ");
INSERT INTO ndh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Abhalongoshi abha Bhayuuta abho bhakakalala leka ku nongwa iya kuti uPeeteli nu Yoohani bhakabhamanyishanga abhandu isha Yeesu nu kuti uChaala indiakabhashuushe abhandu isa muumwo akamushuusha uYeesu. ");
INSERT INTO ndh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Po bhakabhakola uPeeteli nu Yoohani, bhakabhapinya mu nyumba iya bhapinyighwa ukufika pangeelo ku nongwa iya kuti likabha lyafika namasubha. ");
INSERT INTO ndh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Loole abhandu abhingi bhaabho bhakashipulika shiisho uPeeteli nu Yoohani bhakamanyishanga, bhakashiitika. Abhaliisha bheene bhaabho bhakamwitika uYeesu bhakabha abhoelufu bhahaano (5,000). ");
INSERT INTO ndh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ishiku liilyo likakongagha, abhalongoshi na bhosongo abha Bhayuuta na bhamanyishi abha ndaghilo isha Moose bhakabhungaana mu kaaya aka Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pi Ibhalaasa ilyo, akabhaapo uAnasi yuuyo akabha mupuuti usongo, uKayaafa, uYoohani, uAlekisanda na bhandu abhanine bhaabho bhakafumagha mu chikolo icha mupuuti usongo. ");
INSERT INTO ndh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Po bhwo bhaabhungaana, bhakalaghila abhashikali ukuti bhiise nu Peeteli nu Yoohani nu kubhiimika pandaashi papaabho, bhakabhabhuusha bhakati, “Kali, ghwini yuuyo abhapiile amaka agha kumuposha uchikwefu uyu? Soona, kali, ghwini yuuyo abhiitikishiishe ukushibhomba isho?” ");
INSERT INTO ndh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Po bhwo uPeeteli akulongoshighwa nu Mbepo uMwelu, akabhabhuusha akati, “Mwe bhalongoshi na mwe bhosongo abha bhandu abha Isilaeli, ");
INSERT INTO ndh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kali, mukutubhuusha umuusughu ku nongwa iya kuti twamubhombela inyiisa uchikwefu uyu? Kali, mukulonda ukumanya muumwo uchikwefu uyu aapoliile? ");
INSERT INTO ndh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Po umwe mweshi na bhandu abha chiisu icha Isilaeli mumanye ukuti umundu uyu yuuyo iimite mundaashi mumwinyu, aapolite ukughendela mu ngamu iya Yeesu Kilisiti ughwa mu Naasaleeti yuuyo umwe mukamukomeela pa chikobhekano, loole uChaala akamushuusha. ");
INSERT INTO ndh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","UYeesu ghwe yuuyo inongwa shaake shisimbiighwe mu Masimbo aMeelu ukumuyugha umwene ukuti, ‘Iyondo liilyo umwe mwe bhasenga nyumba mukalikaana, lyo liilyo lyabha liyondo ikulu ilya kukola pa nguto iya lwalilo ulwa nyumba.’ ");
INSERT INTO ndh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Ataliipo umundu umunine yuuyo abhaghiile ukutupoka utwe ukukinda uYeesu. Paapo yitaliipo ingamu inine pa chiisu ichi yiiyo yibhaghiile ukutupoka ukufuma mu mbiibhi shiitu.” ");
INSERT INTO ndh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bhwo abhalongoshi na bhosongo bhala bhaabhabhona uPeeteli nu Yoohani bhakubhaamula chishita kubhooghopa nu kuti bhatakabha bhamanyi ngaani abha ndaghilo isha Bhayuuta, bhakaswigha leka. Ku nongwa iyo, abhalongoshi na bhosongo bhala bhakashaaghania ukuti uPeeteli nu Yoohani bhakabha pamupeene nu Yeesu. ");
INSERT INTO ndh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Loole bhwo abhalongoshi na bhosongo bhala bhaamubhona umundu yula yuuyo akabha ghwi chikwefu kubhwandilo iimite pamupeene nu Peeteli nu Yoohani, bhatakayugha naalimo ilya kubhakaanika. ");
INSERT INTO ndh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Po bhakalaghila ukuti bhafume kuuse ku Ibhalaasa ilya Bhayuuta. Bhwo bhaafuma, abhalongoshi bhala bhakaanda ukuyughisania bheene-bheene, ");
INSERT INTO ndh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","bhakabhuusania bhakati, “Kali, tubhombe kooni na bhandu abha? Tesha, abhandu bhooshi bhaabho bhakwikala mu kaaya aka Yelusaleemu muno bhameenye ukuti abhandu abha bhaabhombite ichiika ichikulu chiicho tutabhaghiile ukuyugha ukuti bhatachibhombite. ");
INSERT INTO ndh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Loole ukuti tushighile lwoshi inongwa ishi manye sheendelelaghe ukufumukwa ku bhandu, tubhasoke abhandu abha ukuti manye bhayughaghe soona nu mundu ghweshi yula mu ngamu iya Yeesu.” ");
INSERT INTO ndh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Po abhalongoshi na bhosongo bhala bhakabhiitisha soona uPeeteli nu Yoohani, bhakabhakaanisha ku maka bhakati, “Muleke ukushiyugha inongwa isha Yeesu soona nu kubhamanyisha abhandu mu ngamu yaake.” ");
INSERT INTO ndh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Loole uPeeteli nu Yoohani bhakabhaamula bhakati, “Mwe bhosongo, tumula yumwemwe, kali, shibhaghiile pandaashi pa Chaala ukuti tubhaghindikaghe umwe ukukinda ukumughindika uChaala? ");
INSERT INTO ndh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Paapo tutabhaghiile ukuleka ukushiyugha shila shiisho tukashibhona nu kushipulika.” ");
INSERT INTO ndh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Po abhalongoshi na bhosongo bhala bhakapootwa ukuyaagha isila iya kubhafunda uPeeteli nu Yoohani ku nongwa iya kuti abhandu bhooshi bhakamupaalagha uChaala ku chiika chiicho bhakachibhomba ku mundu yula yuuyo akabha ghwi chikwefu. Po bhakabhasoka ngaani uPeeteli nu Yoohani, bhakabhiitikisha ukuti bhabhuukaghe. ");
INSERT INTO ndh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Umundu yula yuuyo akapola ubhwochikwefu bhwake ku sila iya chiika akabha ni fyinja amalongo manna (40) nu kwongela. ");
INSERT INTO ndh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bhwo abhosongo abha Bhayuuta bhaabhaabhula ukufuma mu nyumba iya bhapinyighwa, uPeeteli nu Yoohani bhakabhuuka ku bhiitiki abhanine nu kubhapangila amashu ghooshi ghaagho abhosongo abha bhapuuti na bhosongo abha Bhayuuta bhakabhabhuula. ");
INSERT INTO ndh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bhwo abhiitiki bhala bhaapulika amashu agho, bhakiitikana pamupeene ukumusuuma uChaala bhakati, “Ghwe Malafyale, ghweghwe ukapela kumwanya, ichiisu, inyanja nu tundu twoshi tuutwo tuliimwo. ");
INSERT INTO ndh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ghweghwe ukayugha ukughendela kwa sekulu ghwitu uNdaabhiti umubhombi ghwako bhwo akulongoshighwa nu Mbepo uMwelu ukati, ‘Kali, kooni abhandu abha fyisu ifinine bhakaleele leka? Soona, kali, kooni abhandu bhakwinongʼona ukubhomba imbiibhi? ");
INSERT INTO ndh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abhomalafyale bhaabho bhakulongosha ichiisu ichi bhiitendekeshiishe ukuti bhamukaane uMalafyale nu Mesiiya ghwake yuuyo amusalite.’ ” ");
INSERT INTO ndh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Abhiitiki bhala bhakeendelela ukwipuuta bhakati, “Isho sho shiisho shibhonekite nalooli. Umalafyale uHelooti nu Pontiyo Pilaati bhabhungaanite mu kaaya aka Yelusaleemu aka pamupeene na Bhaisilaeli na bhandu abha kufuma ifyisu ifinine ukuti bhamukaane uYeesu uMubhombi ghwako yuuyo ukamusala ukuti abhe ghwi Mesiiya. ");
INSERT INTO ndh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Abheene bhakakomaana pamupeene ukuti bhashibhombe shiisho ukashibhaatika nu kutumula ku maka ghaako na ku bhwighane bhwako ukufuma kubhwandilo. ");
INSERT INTO ndh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ghwe Malafyale, tesha muumwo bhakutwoghofya akabhalilo aka! Tukukusuuma utwafwe twe bhabhombi bhaako ukuti tulumbililaghe ishu lyako na maka ghooshi chishita kwoghopa. ");
INSERT INTO ndh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tukukusuuma utupe amaka ghaako agha kubhaposha abhandu, utwafwe ukuti tubhombaghe ifyika ifya luko nu luko ukughendela mu ngamu iya Yeesu uMubhombi ghwako yuuyo akabhalilo kooshi akubhomba shiisho shibhaghiile pandaashi papaako.” ");
INSERT INTO ndh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bhwo abhandu abho bhaamala ukwipuuta kwa Chaala, pabhuyo paapo bhakabha pakayingiya. UMbepo uMwelu akabhiisila bhooshi, po bhakaanda ukulumbilila ishu ilya Chaala chishita kwoghopa. ");
INSERT INTO ndh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Abhiitiki bhooshi abha Yeesu bhakabha ni ndumbula yimoyeene ni nyinongʼono shaabho shikabha pamupeene. Atakabhaapo umundu naayumo yuuyo akatingi utundu tuutwo ali natwo twake mwene, loole bhakabhombelagha utundu twabho twoshi pamupeene. ");
INSERT INTO ndh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abhatumighwa abha Yeesu bhakayughagha nu kushimikisha ku maka ukuti uMalafyale uYeesu ashuukite. UChaala akabhasaya leka bhooshi. ");
INSERT INTO ndh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Atakabhaapo umundu naayumo mu chibhughutila chaabho yuuyo akasobhelighwanga paapo bhala bhaabho bhakabha ni mighunda pamu inyumba bhakaghulishanga. ");
INSERT INTO ndh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Linga bhaaghulisha, indalama shiisho bhakakabhagha, bhakabhapanga abhatumighwa abha Yeesu, bhoope bhakamuyabhilagha ghweshi umundu ukukongana nu kusobhelighwa kwake. ");
INSERT INTO ndh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Akabhaakwo umundu yumo yuuyo akafumagha mu chikolo icha Laabhi. Ingamu yaake akabha ghwi Yoosefu. Umundu uyo akafumagha mu chiisu icha Kiipulo. Abhatumighwa abha Yeesu bhakamwitishanga ingamu iya Bhalinabha. Ingamu iyi mu njugha iya Chihibhuli kwo kuti, umundu yuuyo akubhakashanga abhanine. ");
INSERT INTO ndh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","UBhalinabha ghwepe akaghulisha umughunda ghwake, indalama shiisho akakabha, akabhuuka nu kubhapa abhatumighwa abha Yeesu. ");
INSERT INTO ndh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Akabhaakwo umundu yumo yuuyo ingamu yaake akabha ghwi Naniiya. UNaniiya akabha nu mukashi yuuyo ingamu yaake akabha ghwi Safila. Abhandu abha bhakabha nu mughunda ghwabho ghumo. Ishiku limo bhoope bhakaghulisha umughunda ghwabho ughwo. ");
INSERT INTO ndh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Loole bhwo bhaaghulisha, uNaniiya akafifa indalama shimo nu mukashi akamanya shooshi shiisho umulume akashibhomba. Po uNaniiya akeegha indalama shiisho shikashaala nu kubhuuka pakubhiika ku bhatumighwa abha Yeesu nu kubhashimbula ukuti shili shooshi. ");
INSERT INTO ndh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Po uPeeteli akamubhuusha uNaniiya akati, “Ghwe Naniiya, kali, kooni umwitikishiishe uSeetano ukuti akulongoshange, ukuti umushimbule uMbepo uMwelu ku sila iya kufifa indalama, shimo shiisho ghwashaaghite bhwo ghwaghulisha umughunda ghwako? ");
INSERT INTO ndh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bhwo ukaali ukughulisha umughunda ughwo, kali, ghutaali ghwako? Na bhwo ghwaghulisha umughunda ughwo, kali, indalama shitaali shaako nu kuti ghwabhaghiile ukushibhombela isa muumwo ghwighaniile? Po kali, kooni ghwinongʼonite mu ndumbula yaako ukushibhomba isho? Ku nongwa iyo, umanye ukuti utaabhashimbula abhandu bheene, loole ghwamushimbula nu Chaala.” ");
INSERT INTO ndh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bhwo uNaniiya aapulika amashu agho, nakalinga akaghwa paase bhwo afwile. Po abhandu bhooshi bhaabho bhakapulika inongwa isho, bhakooghopa leka. ");
INSERT INTO ndh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Po abhalumyana bhamu bhakiisa, bhakaghuniembetelela umufimba nu mwenda, bhakaghupimba nu kubhuuka pakughushiila. ");
INSERT INTO ndh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bhwo iisala shitatu shaakinda, umukashi ughwa Naniiya akiingila mu nyumba yiiyo uPeeteli akabha, loole chishita kumanya shiisho shikabhombighwa ku mulume. ");
INSERT INTO ndh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","UPeeteli akamulangisha uSafila indalama shiisho umulume akiisa nasho kukwake, akamubhuusha akati, “Ghwe Safila, imbuule, kali, ishi ndalama shooshi shiisho mukapokeela nu mulume ghwako bhwo mwaghulisha umughunda ghwinyu?” Umwene akamwamula akati, “Mwo muumwo, ishi ndalama shooshi shiisho tukapokeela.” ");
INSERT INTO ndh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Po uPeeteli akamubhuusha akati, “Kali, kooni mukiitikana nu mulume ghwako ukumughela uMbepo uMwelu? Ulu pulikisha! Abhalumyana bhaabho bhaamushiila umulume ghwako, lwoshi ulu bhali papiipi pa mulyango, bhakwisa pakughupimba umufimba ghwako nu kubhuuka pakughushiila ghwope.” ");
INSERT INTO ndh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nakalinga, uSafila akaghwa pa tulundi utwa Peeteli bhwo afwile. Bhwo abhalumyana bhala bhaaghaluka, bhakiingila nu kumwagha uSafila ghwepe afwile. Po bhakaghupimba umufimba ghwake, bhakabhuuka nu kughushiila papiipi ni ipumba ilya mulume. ");
INSERT INTO ndh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Po ubhwogha ubhukulu bhukabhakola abhiitiki bhooshi mu kaaya aka Yelusaleemu pamupeene na bhandu abhanine bhaabho bhakapulika inongwa isho. ");
INSERT INTO ndh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Abhatumighwa bhakabhombagha ifyika ifyingi ifya kuswighisha ku bhandu fiifyo fikalangishanga amaka agha Chaala. Bhoope abhiitiki bhooshi bhakakomaanagha pamupeene kooshi akabhalilo ku ndumbula yimoyeene mu Ibhalaasa ilya Solomooni. ");
INSERT INTO ndh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pamupeene nu kuti abhandu bhaabho bhakabha bhatamwitikite uYeesu bhakabhaghindikagha leka abhiitiki, poope atakabhaapo umundu naayumo yuuyo akaghela ukwongaana pamupeene nabho, ku nongwa iya kwoghopa ku shiisho shikabhaagha uNaniiya nu Safila. ");
INSERT INTO ndh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Loole abhaliisha na bhakolo abhingi bhakaanda ukumwitika uMalafyale uYeesu nu kwongaana pamupeene ni chibhughutila icha bhiitiki abhanine. ");
INSERT INTO ndh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ku nongwa iya kuti abhatumighwa bhakabhombagha ifyika ifya kuswighisha, abhandu bhakabhapimbagha abhabhine pa matembelo na pa malili nu kubhabhiika palubhafu pa sila ukuti linga uPeeteli akughenda kupiipi kukwabho, ukaasheeshe ghwake abhaaghe abhabhine abho ukuti bhapole. ");
INSERT INTO ndh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Soona, abhandu abhingi ukufuma mu twaya utunandi tuutwo tukabha kupiipi na kaaya aka Yelusaleemu bhakabhuukagha na bhabhine na bhandu bhaabho bhakakolighwa ni mbepo imbiibhi, bhooshi bhakapolagha. ");
INSERT INTO ndh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Po umupuuti usongo, pamupeene na bhanine bhooshi abha kufuma mu chibhughutila icha Bhasandukaayi, bhakabha nu lwibhuno leka ku nongwa iya bhatumighwa abha Yeesu. ");
INSERT INTO ndh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Po bhakabhalaghila abhashikali ukuti bhabhakole abhatumighwa bhala. Bhoope bhakabhakola nu kubhapinya mu nyumba iya bhapinyighwa. ");
INSERT INTO ndh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Loole pa kabhalilo aka pabhushiku, ughwandumi ughwa Malafyale uChaala akiisa nu kwighula ifyighi ifikulu ifya nyumba iya bhapinyighwa yila, akabhafumya kuuse abhatumighwa bhala, akabhabhuula akati, ");
INSERT INTO ndh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Bhuuka mwime mu lupaso ulwa Nyumba iya Chaala nu kwendelela ukubhabhuula abhandu amashu ghooshi agha bhwumi ubhwa bhwila na bhwila.” ");
INSERT INTO ndh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bhwo bhaapulika isho, abhatumighwa bhakabhuuka nu kwingila mu lupaso ulwa Nyumba iya Chaala nu kwanda ukumanyisha. Mu kabhalilo ako, umupuuti usongo, pamupeene na bhala bhaabho akabha nabho, bhakabhungaana nu kwitisha ulukomaano ulwa bhosongo bhooshi abha Libhalaasa ilya Bhayuuta. Po bhakabhatuma abhalindilili bhamu abha Nyumba iya Chaala ukuti bhabhuuke, bhabhaabhule abhatumighwa mu nyumba iya bhapinyighwa nu kwisa nabho kukwabho. ");
INSERT INTO ndh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Loole bhwo abhalindilili bhala bhiingila mu nyumba iya bhapinyighwa yila, bhakaagha abhatumighwa bhala bhataliimwo. Po bhakaghaluka ku bhosongo bhaabho, bhakabhabhuula bhakati, ");
INSERT INTO ndh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Bhwo twafika pa nyumba iya bhapinyighwa, twagha ifyighi fyoshi fipingiighwe akiisa, soona twabhaagha abhalindilili bhiimite pa fyighi ifyo bhakulindilila, loole bhwo twighula ifyighi ifyo, tutaamwagha umundu naayumo.” ");
INSERT INTO ndh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bhwo usongo ughwa bhalindilili abha Nyumba iya Chaala na bhosongo abha bhapuuti bhaapulika isho, bhakaswigha leka nu kubhuusania bheene-bheene bhakati, “Kali, ishi indishibhe bhuleele?” ");
INSERT INTO ndh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Po umundu yumo akiisa, akabhabhuula akati, “Mwe bhosongo, pulikisha! Abhandu bhaabho mwabhapinyite mu nyumba iya bhapinyighwa bhali mu lupaso ulwa Nyumba iya Chaala, bhakumanyisha abhandu!” ");
INSERT INTO ndh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nakalinga, usongo ughwa bhalindilili yula, pamupeene na bhashikali bhamu, bhakabhuuka kuukwo abhatumighwa bhakabha, bhakabhakola abhatumighwa bhala nu kwisa nabho ku Ibhalaasa ilya Bhayuuta. Loole bhakabhakola chishita kubhombela amaka, paapo bhakabhooghopagha abhandu ukuti manye bhabhaghoghe ku sila iya kubhakoma na mayondo. ");
INSERT INTO ndh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bhwo bhiisa nabho, bhakabhalaghila ukuti bhiime pandaashi pi Ibhalaasa. Po umupuuti usongo akaanda ukubhabhuusha akati, ");
INSERT INTO ndh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Mwe bhandu umwe, kali, tutaabhasokite ku maka ukuti manye mubhamanyishange abhandu ukubhombela ingamu iya Yeesu? Loole umwe mukwendelela ukufumusha ifimanyisho fyake mu kaaya kooshi aka Yelusaleemu, soona mukulonda ukutubhiika utwe ukuti twetwe twapelite ukuti umundu uyo afwe!” ");
INSERT INTO ndh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","UPeeteli na bhatumighwa abhanine bhakamwamula bhakati, “Tukulondighwa ukumupulika uChaala ukukinda ukubhapulika abhandu. ");
INSERT INTO ndh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Umwe mukamughogha uYeesu ku sila iya kumukomeela pa chikobhekano, loole uChaala yuuyo abhosekulu bhiitu bhakamwipuutagha akamushuusha. ");
INSERT INTO ndh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","UChaala akamughindika ngaani uYeesu ku sila iya kumubhiika ku kakono kaake aka kumwisa ukubha Mulongoshi soona Mupoki. UChaala akabhomba ulwo ukuti abhaafwe abhandu abha Isilaeli bhiilaate nu kuti abhahobhokele imbiibhi shaabho. ");
INSERT INTO ndh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nuutwe twe bhakeeti abha shooshi isho nu Mbepo uMwelu yuuyo uChaala amutumite ku bhandu bhaabho bhakumupulika, ghwepe akushishimikisha isho.” ");
INSERT INTO ndh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bhwo abhosongo abha Libhalaasa bhala bhaapulika amashu agho, bhakakalala leka mu ndumbula shaabho, bhakaanda ukulonda isila iya kubhaghogha abhatumighwa bhala. ");
INSERT INTO ndh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Loole mu bhosongo bhala, akabhaamwo uMufalisaayi yumo yuuyo ingamu yaake akabha ghwi Ngamaliyeeli. UNgamaliyeeli akabha mumanyishi ughwa ndaghilo isha Moose yuuyo abhandu bhooshi bhakamughindikagha leka. Umwene akiima pandaashi pi Ibhalaasa, akabhalaghila abhalindilili abha Nyumba iya Chaala ukuti bhabhafumye kuuse abhatumighwa ku kabhalilo akapimba. ");
INSERT INTO ndh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Po bhwo bhaabhafumya kuuse, uNgamaliyeeli akabhabhuula abhosongo abhanine bhala akati, “Mwe bhandu abha Isilaeli umwe, inongʼona akiisa taashi ku isho shiisho mukulonda ukubhabhombela abhandu abha. ");
INSERT INTO ndh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Paapo mukumbuke ukuti ku mashiku agha kunyuma, akabhaapo umundu yumo yuuyo ingamu yaake akabha ghwi Tebhunda. UTebhunda uyo akiifunagha leka ukuti umwene mundu mufumukwe nu kukuusa abhandu imya inna (400) bhaabho bhakamukongagha. Loole pabhumalilo, uTebhunda akaghoghighwa, po abhandu bhala bhooshi bhaabho bhakamukongagha, bhakanyambaana ni chibhughutila chaake chooshi chikashilila pala pala. ");
INSERT INTO ndh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bhwo isho shaakinda, akabhoneka umundu yumo ukufuma mu chiisu icha Ghalilaayi yuuyo ingamu yaake akabha ghwi Yuuta. UYuuta akafumukwa leka akabhalilo kaako isilikali iya Looma yikabhelengagha abhandu ichiisu chooshi. UYuuta uyo akakuusa abhandu abhingi leka, bhakaanda ukumukonga. Loole pabhumalilo, ghwepe akaghoghighwa, po abhandu bhooshi bhala bhaabho bhakamukongagha, bhoope bhakanyambaana. ");
INSERT INTO ndh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Po ukukongana ni nongwa iya bhatumighwa abha Yeesu abho, ingubhasuuma, manye mubhafulashange, loole bhaabhule, bhaleke bhabhuukaghe. Inguyugha ulu ku nongwa iya kuti linga isho bhakubhomba shifumite ku bhandu, bhataabhafike pabhutali, indibhapootwe. ");
INSERT INTO ndh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Loole linga shifumite kwa Chaala, mutabhaghiile ukubhashighila paapo indimwise mwaghe mukulwa nu Chaala.” Abhosongo abha Libhalaasa bhala bhakiitikana na mashu agha Ngamaliyeeli. ");
INSERT INTO ndh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Po bhakalaghila ukuti abhatumighwa bhiingile soona mu Ibhalaasa nu kubhakoma ni fikoti. Po bhakabhasoka soona ku maka abhatumighwa bhala ukuti manye bheendelelaghe ukuyugha soona ku bhandu ukughendela ku ngamu iya Yeesu. Pabhumalilo, bhakabhaabhula nu kubhiitikisha ukuti bhabhuukaghe. ");
INSERT INTO ndh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Po abhatumighwa bhala bhakafuma mu Ibhalaasa lila bhwo bhali nu lusekelo ulukulu leka paapo uChaala akabhabhaghisha ukuti bhataamighwe ku nongwa iya ngamu iya Yeesu. ");
INSERT INTO ndh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lyoshi ishiku, abhatumighwa bhakabhuukagha mu lupaso ulwa Nyumba iya Chaala na mu nyumba isha bhandu bhooshi, bhakeendelelagha ukumanyisha nu kulumbilila iNongwa iNyiisa ukuti uYeesu ghwi Mesiiya. ");
INSERT INTO ndh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu mashiku ghala, abhandu abhingi bhaabho bhakamwitikagha uYeesu bhakoongelagha ukubhaala. Po bhala bhaabho bhakayughagha iChighiliki bhakiilumbuushanga ukuti lyoshi ishiku bhala bhaabho bhakayughagha iChihibhuli bhatakabhayabhilagha akiisa ifindu abhakolo abhafwile bhaabho bhakayughagha iChighiliki. ");
INSERT INTO ndh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Po abhatumighwa kalongo na bhabhili (12) bhala bhakabhabhungaania abhiitiki bhooshi bhala pamupeene, bhakabhabhuula bhakati, “Kataa kiisa ukuti utwe tuleke ukulumbilila ishu ilya Chaala nu kwanda ukubhomba imbombo iya kubhayabhila ifindu abhandu. ");
INSERT INTO ndh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mwe bhiitiki bhanyiitu, tukubhasuuma musale abhaliisha bhahaano na bhabhili pakati papiinyu bhaabho bhali na kayiilo akiisa, bhaabho mubhameenye ukuti bhakulongoshighwa nu Mbepo uMwelu, soona bhali na mahala. Abhaliisha abho bho bhaabho inditubhape imbombo iya kuyabhania ifindu ku bhandu. ");
INSERT INTO ndh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ku sila iyo, nuutwe inditwendelelaghe ukubhombela akabhalilo kooshi ukwipuuta kwa Chaala, ukulumbilila nu kumanyisha ishu lyake.” ");
INSERT INTO ndh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bhwo bhaapulika amashu agho, abhiitiki bhooshi bhakahobhoka nu kwitikana na mashu agha bhatumighwa. Po bhakamusala umundu yumo yuuyo ingamu yaake akabha ghwi Siteefani. USiteefani akabha mundu yuuyo akamwitikagha uChaala ku maka, soona akalongoshighwanga nu Mbepo uMwelu. Soona bhakamusala uFilipu, uPolokolaasi, uNikanooli, uTiimoni, uPalimenaasi nu Nikolaasi. UNikolaasi akafumagha mu kaaya aka Antiyokiya, umwene akapindukila ku Bhayuuta bhwo akaali ukumwitika uKilisiti. ");
INSERT INTO ndh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bhwo bhaabhasala abhaliisha bhahaano na bhabhili bhala, bhakabhuuka nabho mundaashi mu bhatumighwa. Po abhatumighwa bhala bhakabhiipuutila kwa Chaala, bhakabhabhiikila utukono ukuti uChaala abhasaye. ");
INSERT INTO ndh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Po abhiitiki bhakeendelela ukufumusha ishu ilya Chaala ku bhandu abhingi. Ku sila iyo, abhandu abhingi mu kaaya aka Yelusaleemu bhaabho bhakamwitikagha uYeesu bhakoongelagha ukubhaala ngaani. Mu bhandu abho, abhapuuti abhingi bhakamwitika uYeesu. ");
INSERT INTO ndh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","UChaala akeendelela ukumupelela ichisa uSiteefani nu kumupa amaka agha kubhomba ifyika ifikulu ku bhandu. ");
INSERT INTO ndh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Loole abhandu bhamu bhakaanda ukumukaanika uSiteefani. Mu bhandu abho, bhamu bhakabha Bhayuuta bhaabho bhakafumagha mu sinaghoghi yiiyo bhakatingi Sinaghoghi iya Bhandu aBhaabhuke. ABhayuuta abho bhakafumagha mu chiisu icha Kileene na mu Alekisandiliya, abhanine bhakafumagha mu chiisu icha Kilikiya na mu Aasiya. Abhandu abho bhakaanda ukukaanikana nu Siteefani, ");
INSERT INTO ndh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","loole bhakapootwa ku nongwa iya kuti uMbepo ughwa Chaala akamulongoshanga uSiteefani ukuyugha amashu agha mahala. ");
INSERT INTO ndh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Po bhakabhabheka indalama abhandu bhamu ku bhushiifu ukuti bhayughe ku bhandu abhanine bhati, “Tumupulikite uSiteefani bhwo akuyugha amashu agha kumutuka uMoose nu Chaala.” ");
INSERT INTO ndh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ku sila iyo, bhakabhasongelesha aBhayuuta abhanine, abhosongo bhaabho pamupeene na bhamanyishi abha ndaghilo isha Moose. Po bhakamukola uSiteefani nu kubhuuka naghwe ku Ibhalaasa ilya bhosongo abha Bhayuuta. ");
INSERT INTO ndh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Soona bhakiisa na bhakeeti bhamu abha bhumyashi bhaabho bhakayugha bhakati, “Umundu uyu akwendelela ukuyugha akabhiibhi isha Nyumba iya Chaala iyi ni sha ndaghilo isha Moose. ");
INSERT INTO ndh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Paapo tumupulikite bhwo akuyugha akuti uYeesu uyo ughwa kufuma mu kaaya aka Naasaleeti indiayipongolanie iNyumba iya Chaala iyi, soona indiabhamanyishange abhandu ukushikonga inyiiho inine nu kushileka inyiiho shooshi shila shiisho uMoose akabhapa abhosekulu bhiitu.” ");
INSERT INTO ndh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abhandu bhooshi bhaabho bhakabhaamwo mu Ibhalaasa lila, bhakaanda ukumulubhaalila ku maka uSiteefani, nu kuchibhona icheeni chaake chiicho chikangʼangʼagha ungati cheeni icha ghwandumi ughwa Chaala. ");
INSERT INTO ndh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Po umupuuti usongo akamubhuusha uSiteefani akati, “Kali, ishi shiisho bhakukusitaaka sha nalooli?” ");
INSERT INTO ndh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","USiteefani akabhaamula akati, “Mwe bhoghwamwitu na bhotaata, ingubhasuuma muumbulikishe. UChaala uMwene Bhukulumba akamusetukila usekulu ghwitu uAbhulahamu mu chiisu icha Mesopotaamiya bhwo akaali ukusaamila mu chiisu icha Haalani. ");
INSERT INTO ndh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Bhwo aamusetukila, akamubhuula akati, ‘Ghwe Abhulahamu, tiilaamwo mu chiisu ichi, bhaleke muno muno abhakamu bhaako, bhuuka ku chiisu chiicho indiingulangishe.’ ");
INSERT INTO ndh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Po uAbhulahamu akatiila mu chiisu icha Bhakalindaayi, akabhuuka nu kwikala mu chiisu icha Haalani. UChaala akamubhuula uAbhulahamu ukuti atiileemwo mu chiisu icha Haalani nu kwisa mu chiisu ichi chiicho umwe nuune tukwikala. ");
INSERT INTO ndh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","UChaala atakamupa uAbhulahamu umughunda naaghumo mu chiisu ichi nalinga litambo limolyene, loole akafinga ukumupa ichiisu ichi ukubha chaake umwene pamupeene na bha chikolo chaake pamupeene nu kuti mu kabhalilo ako atakabha nu mwana naayumo. ");
INSERT INTO ndh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","UChaala akamubhuula uAbhulahamu akati, ‘Ghwe Abhulahamu, abhandu abha kufuma mu chikolo chaako indibhakabhe bhaheesha mu chiisu icha bhandu abhanine. Abhenekaaya abha chiisu icho indibhakabhabhiike ukubha bhatumwa bhaabho, indibhakabhabhombele akabhiibhi ku kabhalilo aka fyinja imya inna (400). ");
INSERT INTO ndh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Loole une indiingabhalonge abhandu bhala bhaabho indibhakabhabhiike ukubha bhatumwa bhaabho. Pabhumalilo, indiingabhatiishe abhandu abha mu chikolo chaako ukufuma mu chiisu chila ukuti bhiise pakuunyiipuuta mu chiisu ichi.’ ");
INSERT INTO ndh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Po uChaala akiitikana nu Abhulahamu, akamulaghila ukumukwesula ghweshi umwana umuliisha ukufuma mu nyumba yaake. Po bhwo uIsiyaka aapaapighwa, uAbhulahamu akamukwesula bhwo ghaafika amashiku mahaano na matatu (8). Bhubhuubhwo, bhwo uIsiyaka amupaapa uYaakobhu, akamukwesula ghwepe. Pabhumalilo uYaakobhu akapaapa abhaana bhaake kalongo na bhabhili (12) nu kubhakwesula. Abho bho bhaabho bhosekulu bhiitu. ");
INSERT INTO ndh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Abhosekulu bhiitu abho bhakamwibhunagha ughwamwabho uYoosefu, po bhakamughulisha ukuti abhe mutumwa mu chiisu icha Miisili. Loole uChaala akabhanga pamupeene nu Yoosefu, ");
INSERT INTO ndh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","akamupokagha ku ndamyo shooshi shiisho shikamwaghagha. Soona akamupa uYoosefu amahala ghaagho ghakamupelela, ukuti uFalaabho umalafyale ughwa chiisu icha Miisili amughane, nu kumusala ukubha mulongoshi ughwa chiisu chooshi icha Miisili ni nyumba ingulu iya bhunyafyale. ");
INSERT INTO ndh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Po akabhalilo kamu isala ingali yikaghwa mu chiisu chooshi icha Miisili pamupeene na mu kaaya aka Kaanani. Isala ingali iyo yikabhapelela abhandu indamyo ingulu ngaani. Abhosekulu bhiitu bhoope bhatakabha ni findu. ");
INSERT INTO ndh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Loole bhwo uYaakobhu aapulika ukuti ifindu filiikwo ku chiisu icha Miisili, akabhatuma ulwa kwanda ku chiisu icho abhaana bhaake bhaabho bhosekulu bhiitu ukuti bhaye bhaghule ifindu fimo. ");
INSERT INTO ndh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bhwo bhaabhuuka ulwa bhubhili pakughula ifindu ku chiisu icho, uYoosefu akiilingaania ku bhakulu bhaake ku nongwa iya kuti bhatakamumanya akabhalilo kala kaako bhakabhuuka ulwa kwanda. Mu kabhalilo ako abhandu bhakamubhuula uFalaabho isha bhakulu abha Yoosefu, ghwepe akabhamanya. ");
INSERT INTO ndh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Po uYoosefu akatuma indumi kwa ghwise uYaakobhu ukuti abhuuke ku chiisu icha Miisili pamupeene na bhandu bhaake bhooshi abha mu nyumba yaake. Mu kabhalilo ako abhandu abha mu nyumba iya Yaakobhu bhakabha amalongo mahaano na mabhili na bhahaano (75). ");
INSERT INTO ndh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Po bhwo uYaakobhu aapulika isho, akabhuuka pamupeene na bha mu nyumba yaake pakwikala mu chiisu icha Miisili muumwo umwene pamupeene na bhosekulu bhiitu bhakafwa. ");
INSERT INTO ndh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Loole imifimba yaabho bhakayeegha, bhakayighalusha ku chiisu chaabho mu kaaya aka Sheekemu. Bhwo bhaafika, bhakayishiila mu ipumba liilyo uAbhulahamu akaghula ku bhaana abha mundu yumo yuuyo ingamu yaake akabha ghwi Hamooli. ");
INSERT INTO ndh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Bhwo akabhalilo kaapalamila aka Chaala ukushibhomba shiisho akafinga kwa Abhulahamu, abhosekulu bhiitu bhakeendelela ukubhaala nu kubha bhingi ngaani mu chiisu icha Miisili. ");
INSERT INTO ndh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Po umalafyale umunine yuuyo atakamanya naashimo isha Yoosefu, akaanda ukulongosha ichiisu icha Miisili. ");
INSERT INTO ndh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Umalafyale uyo akaanda ukubhabhombela akabhiibhi abhosekulu bhiitu. Akabhalaghila ku maka ukuti bhabhataaghaghe abhaana bhaabho abhafyele ukuti bhafwe. ");
INSERT INTO ndh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mu kabhalilo ako, akapaapighwa umwana yumo yuuyo ingamu yaake akabha ghwi Moose. Umwana uyo akabha mwisa leka pandaashi pa Chaala. Abhapaapi bhaake bhakamusungagha ku sila iya kumufifa mu nyumba yaabho ku kabhalilo aka myeshi mitatu. ");
INSERT INTO ndh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bhwo bhaapootwa ukumufifa, bhakamubhiika mu chipombo, bhakamufumya kuuse nu kumubhiika mu lusooko. Umwana umulindu ughwa Falaabho akamwagha, akamwegha nu kwanda ukumusunga ungati mwana ghwake. ");
INSERT INTO ndh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","UMoose akamanyila amahala ghooshi agha Bhamiisili, soona akayughagha nu kubhomba imbombo ku maka. ");
INSERT INTO ndh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Bhwo uMoose aabha ni fyinja amalongo manna (40), akatumula ukubhuuka pakubhalamuka abhandu bhaake aBhaisilaeli. ");
INSERT INTO ndh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Bhwo aafika, akamubhona uMumiisili yumo akumukoma uMwisilaeli chishita nongwa naayimo. Po uMoose akamwafwa uMwisilaeli yula, akamukoma uMumiisili nu kumughogha. ");
INSERT INTO ndh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","UMoose akiinongʼonagha ukuti aBhaisilaeli abhanine bhakashaaghanianga ukuti uChaala indiabhapoke ukughendela kukwake, loole abheene bhatakashaaghanianga. ");
INSERT INTO ndh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ishiku liilyo likakongagha, uMoose akabhabhona aBhaisilaeli bhabhili bhali pakulwa. Akaghela ukubhafwania akati, ‘Umwe mwe bhanamundu, kali, kooni mukulwa bheene-bheene?’ ");
INSERT INTO ndh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Loole umundu yula yuuyo akamufulashanga uMwisilaeli umunine akamusungila uMoose, akamubhuusha akati, ‘Kali, ghwini yuuyo akubhiikite ughwe ukuti ubhe mulongoshi nu kuti ubhe mulongi ghwitu? ");
INSERT INTO ndh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kali, kulonda ukuungogha isa muumwo ghwamughoghiile uMumiisili yula mumasubha?’ ");
INSERT INTO ndh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Bhwo uMoose aapulika amashu agho, akooghopa leka, akakindila ku chiisu icha Mindiyani, akiikala ku chiisu icho ungati muheesha, akeegha umukolo nu kupaapa abhaana abhaliisha bhabhili. ");
INSERT INTO ndh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Bhwo ifyinja amalongo manna fyakinda, ughwandumi ughwa Chaala akamusetukila uMoose mu katengele kaako kakaakagha bhwo ali mu lungalangala, kupiipi na kaghamba kaako ingamu yaake bhakatingi Sinaayi. ");
INSERT INTO ndh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","UMoose akaswigha leka ukushibhona isho. Po akabhiyila papiipi ukuti ateshe, loole uChaala akamubhuula akati, ");
INSERT INTO ndh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ghwe Moose, une nee Chaala ughwa bhosekulu bhaako, nee Chaala yuuyo uAbhulahamu, uIsiyaka nu Yaakobhu bhakaanyiipuutagha!’ Po uMoose akaanda ukutetema ku nongwa iya bhwogha, atakasulwa ukukatesha soona akatengele kala kaako kakaakagha. ");
INSERT INTO ndh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","UMalafyale uChaala akamubhuula uMoose akati, ‘Ghwe Moose, fuula ifilato fiifyo ufwalite paapo pabhuyo apo ghwimite peelu. ");
INSERT INTO ndh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nalooli naashibhona indamyo ingulu shiisho abhandu bhangu bhakushaagha mu chiisu icha Miisili. Naapulika ukulila kwabho, po niisa ukuti imbaabhule ukufuma mu bhutumwa. Po ulu ingukutuma ubhuuke ku chiisu icha Miisili chila.’ ” ");
INSERT INTO ndh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","USiteefani akeendelela ukulingaania akati, “UMoose uyo ghwe yuuyo abhosekulu bhiitu bhakamukaana, bhakamubhuusha bhakati, ‘Kali, ghwini yuuyo akubhiikite ughwe ukuti ubhe mulongoshi nu kuti ubhe mulongi ghwitu?’ Uyo ghwe yuuyo uChaala akamutuma ukuti abhe mulongoshi, nu kuti abhe mupoki ghwabho, ukughendela ku ghwandumi yula yuuyo akamusetukila mu katengele kaako kakaakagha. ");
INSERT INTO ndh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","UMoose ghwe yuuyo akabhalongosha aBhaisilaeli ukufuma mu chiisu icha Miisili bhwo aabhomba ifyika ifyingi mu chiisu chila, mu nyanja iya Shaamu na mu lungalangala ku fyinja amalongo manna. ");
INSERT INTO ndh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Uyo ghwe yuuyo akabhabhuula aBhaisilaeli akati, ‘UMalafyale uChaala ghwinyu indiakabhasalile umusololi ukufuma pakati papiinyu yuuyo indiakabhe isa neene. Mupulikishange umwene.’ ");
INSERT INTO ndh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","UMoose ghwe yuuyo akabha pamupeene na Bhaisilaeli bhaabho bhakabhungaana mu lungalangala, ghwe yuuyo akabha pamupeene na bhosekulu bhiitu nu ghwandumi ughwa Chaala yuuyo akayughagha naghwe ku kaghamba aka Sinaayi, soona ghwe yuuyo akapokeela amashu ghaagho ghakubhapa abhandu ubhwumi ukuti atupe utwe. ");
INSERT INTO ndh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Loole abhosekulu bhiitu bhakakaana ukumupulikisha uMoose, bhakaanda ukunyonywa mu ndumbula shaabho ukuti bhaghaluke ku chiisu icha Miisili. ");
INSERT INTO ndh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bhwo uMoose akaali ali ku kaghamba aka Sinaayi, abhosekulu bhiitu bhakamubhuula uAaloni yuuyo akabha munungʼuna ughwa Moose bhakati, ‘Ghwe Aaloni, tukusuuma ututendekeshekeshe abhochaala bhaabho indibhatulongoshange mu sila paapo tutakushimanya shiisho shaamwagha uMoose yuuyo akatutiisha ukufuma mu chiisu icha Miisili!’ ");
INSERT INTO ndh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Po bhakatendekesha uchaala yuuyo akabhonekagha ungati ngwata, bhakaghoghagha ifinyamaana ukuti bhamwipuutaghe nu kubhiika ulusekelo ukulangisha ulughindiko kwa chaala yuuyo bhakatendekesha nu tukono twabho. ");
INSERT INTO ndh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Po uChaala akabhakalalila leka nu kubhakaana, ku nongwa iyo bhakaanda ukwipuuta ku isubha, ku mweshi na ku ndoondwa isa muumwo abhasololi abha Chaala bhasimbiile mu bhokalata bhaabho ukuti, ‘Mwe Bhaisilaeli umwe, kali, mukiikemeeshanga ukuti muufumishikishe ifyabhupe akabhalilo kaako mukabha mu lungalangala ku fyinja amalongo manna? Nashiku! ");
INSERT INTO ndh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Umwe mukapimbagha itembe ilya chaala uMooleki, mukapimbagha nu lutoondwa ulwa chaala ghwinyu uLeefani, mukatendekesha abhochaala abho ukuti mubhiipuutaghe. Ku nongwa iyo, indiingabhasaamikishe ku chiisu icha kubhutali, ukukinda akaaya aka Bhaabheli!’ ” ");
INSERT INTO ndh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","USiteefani akeendelela ukuyugha akati, “Bhwo abhosekulu bhiitu bhali mu lungalangala, bhakamwipuutagha uChaala mu itembe liilyo likalangishanga ukuti akabhanga pamupeene nabho. Bhoope bhakatendekesha itembe isa muumwo uChaala akamulaghilila uMoose. ");
INSERT INTO ndh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ifyinja fiifyo fikakongagha, abhosekulu bhiitu bhakeendelela ukupokelesania ukupimba itembe lila bhwo bhakulongoshighwa nu Yooshwa. Bhakalipimba bhwo bhaachipoka ichiisu ukufuma ku bhandu bhaabho uChaala akabhakiisha ku maka mundaashi mumwabho. Itembe lila likashaala mu chiisu icha Kaanani ukufika mu kabhalilo kaako umalafyale uNdaabhiti akaandagha ukulongosha ichiisu icha Isilaeli. ");
INSERT INTO ndh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Umalafyale uNdaabhiti akapokeela isayo ukufuma kwa Chaala, ghwepe akamusuuma ukuti amusengele inyumba uChaala yuuyo uYaakobhu akamwipuutagha. ");
INSERT INTO ndh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Loole uSolomooni umwana ghwake ghwe yuuyo akiisa aamusengela inyumba uChaala. ");
INSERT INTO ndh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Loole uChaala Yuuyo Ali Pamwanya Ngaani atakwikala mu nyumba shiisho abhandu bhasengite isa muumwo umusololi ughwa Chaala akayugha akati, ");
INSERT INTO ndh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘UChaala akuti, “Kumwanya kwo kuukwo chitengu changu icha bhunyafyale, ichiisu bhuyo bhuubhwo utulundi twangu tukukanyagha. Kali, nyumba iya chikolo chiki yiiyo mubhaghiile ukuusengela? Kali, pooki paapo indiindushange? ");
INSERT INTO ndh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kali, indaa neene nee indupelite utundu twoshi utwa kumwanya nu twa pa chiisu?” ’ ” ");
INSERT INTO ndh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","USiteefani akeendelela ukuyugha akati, “Umwe imitu yiinyu mikafu! Indumbula shiinyu ni fyufwo fyinyu fili ungati fya bhandu bhaabho bhataa Bhayuuta. Amashiku ghooshi umwe mukukaanagha ukumupulika uMbepo uMwelu isa muumwo abhosekulu bhiinyu bhakabhombelagha. ");
INSERT INTO ndh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kali, musololi yuki mu bhasololi abha Chaala yuuyo abhosekulu bhiinyu bhatakamubhombela akabhiibhi? Tesha, bhakabhaghoghagha na bhasololi bhaabho bhakasololagha isha kwisa ukwa Mubhombi uMugholofu ughwa Chaala. Uyo ghwe yuuyo umwe mwamubhiikite mu tukono utwa bhalughu nu kumughogha! ");
INSERT INTO ndh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Umwe, mwemwe mukapokeela indaghilo isha Chaala ukughendela ku bhandumi bhaake, loole mukakaana ukushikonga.” ");
INSERT INTO ndh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bhwo abhalongoshi abha Bhayuuta bhala bhaapulika amashu ghaagho uSiteefani akayughagha, bhakakalala leka mu ndumbula shaabho, bhakashesheetusha amiino ghaabho ku nongwa iya lyoyo. ");
INSERT INTO ndh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Loole bhwo uSiteefani akulongoshighwa nu Mbepo uMwelu, akatesha kumwanya, akabhubhona ubhukulumba ubhwa Chaala, akamubhona nu Yeesu iimite ku kakono aka kumwisa aka Chaala. ");
INSERT INTO ndh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Po akayugha akati, “Tesha, ingukubhona kumwanya kwighuka, uMwana ughwa Mundu iimite ku kakono aka kumwisa aka Chaala!” ");
INSERT INTO ndh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Po abhalongoshi abha Bhayuuta bhala bhakaywegha ku ishu ilya pamwanya, bhakashindila ifyufwo fyabho ukuti manye bheendelelaghe ukumupulikisha uSiteefani, nakalinga bhooshi pamupeene bhakamunyeelela. ");
INSERT INTO ndh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Po bhakamufumya kuuse ku kaaya aka Yelusaleemu, bhakaanda ukumukoma na mayondo ukuti bhamughoghe. Abhakeeti bhala bhaabho bhakayugha isha bhumyashi bhakafuula taashi imyenda yaabho ukuti manye yibhashighilaghe bhwo bhakumukoma na mayondo. Bhakeegha imyenda yila, bhakayibhiika pa tulundi utwa mulumyana yumo yuuyo ingamu yaake akabha ghwi Saabhuli ukuti ayilindililaghe. ");
INSERT INTO ndh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bhwo bhakwendelela ukumukoma, uSiteefani akiipuuta akati, “Ghwe Malafyale Yeesu, ingwibhiika mu tukono twako.” ");
INSERT INTO ndh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Po akafughamila, akalila ku ishu ilya pamwanya akati, “Ghwe Malafyale, ingukusuuma ubhahobhokele abhandu abha ku mbiibhi yaabho iyi.” Bhwo uSiteefani aayugha amashu agho, akafwa. ");
INSERT INTO ndh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Mu bhandu bhaabho bhakiitikana ukumughogha uSiteefani, uSaabhuli akabha pamupeene nabho. Loole abhandu bhamu abhagholofu bhakaswimaana leka nu kubhuuka pakumushiila. Ishiku lila lila liilyo bhakamughogha uSiteefani, abhiitiki abha chipanga icha Yelusaleemu bhakaanda ukushaagha indamyo ingulu. Po abhiitiki bhamu bhakanyambaana ukubhuuka mubhuyo ubhunine ubhwa kaaya aka Yuteeya na ka Samaliiya, loole abhatumighwa abha Yeesu abheene bhakashaala mu Yelusaleemu. ");
INSERT INTO ndh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mu kabhalilo ako uSaabhuli akaanda ukuchifulasha ichipanga, akiingilagha mu nyumba isha bhandu, akabhaghuusagha ku maka abhiitiki abhaliisha na bhakolo, akabhapinyagha mu nyumba iya bhapinyighwa. ");
INSERT INTO ndh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abhiitiki bhala bhaabho bhakanyambaana ku nongwa iya ndamyo ingulu, bhakalumbililagha iNongwa iNyiisa ku bhandu kwoshi kuukwo bhakabhuukagha. ");
INSERT INTO ndh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","UFilipu yuuyo akabha ghwe yumo mu bhiitiki abha Yeesu bhaabho bhakanyambaana, umwene akiilomuka ukubhuuka mu kaaya kamu aka chiisu icha Samaliiya kuukwo akeendelela ukulumbilila iNongwa iNyiisa isha Yeesu Kilisiti. ");
INSERT INTO ndh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bhwo abhandu bhaapulika amashu agha Filipu nu kufibhona ifyika ifikulu fiifyo akafibhombagha, bhooshi pamupeene bhakamupulikishanga akiisa, ");
INSERT INTO ndh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","paapo akashikiishanga imbepo imbiibhi shiisho shikabhalongoshanga abhandu abhingi, shoope shikafumagha bhwo shikuywegha. Soona akabhaposhanga abhandu abhingi bhaabho bhakalala ulubhafu lumo na bhochikwefu. ");
INSERT INTO ndh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Po abhandu abha mu kaaya ako bhakabha nu lusekelo ulukulu. ");
INSERT INTO ndh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mu kaaya aka Samaliiya ako, akabhaamwo umundu yumo yuuyo ingamu yaake akabha ghwi Siimoni. USiimoni akabhombagha ubhuloshi ku kabhalilo akatali. Umwene akeendelela ukubhaswighisha aBhasamaliiya bhooshi ku bhuloshi bhwake nu kwifuna ukuti umwene ghwa pamwanya leka. ");
INSERT INTO ndh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Abhandu bhooshi ukwandila abhakeke ukufika abhosongo bhakamupulikishanga ku maka, bhakayughagha bhakatingi, “Umundu uyu ghwe yuuyo maka agha Chaala ghaagho bhakuti, ‘AMaka aMakulu.’ ” ");
INSERT INTO ndh_vpl VALUES ("AC8_11","074_8_11","ACT","8","