﻿USE sofia;
DROP TABLE IF EXISTS sofia.ndg_vpl;
CREATE TABLE ndg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ndg_vpl WRITE;
INSERT INTO ndg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kitabu cha lukolo lwa Yesu Kristo mwana wa Daudi, mwana wa Ibrahimu, ");
INSERT INTO ndg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahimu abile tate ba Isaka, ni Isaka tate bake Yakobo, ni Yakobo tate ba Yuda ni nuna bake. ");
INSERT INTO ndg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda abile tate ba Peresi ni Sera kwa Tamari, Peresi tate ba Hezeroni, ni Hezeroni tate ba Ramu. ");
INSERT INTO ndg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu abile tate ba Aminadabu, Aminadabu tate ba Nashoni, ni Nashoni tate ba Salimoni, ");
INSERT INTO ndg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni abile tate ba Boazi kwa Rahabu, Boazi tate ba Obedi kwa Ruth, Obedi tate ba Yese, ");
INSERT INTO ndg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese abile tate ba mpwalume Daudi, Daudi abile tate ba Sulemani kwa nnyumbo wa Uria. ");
INSERT INTO ndg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemani abile tate ba Rehoboamu, Rehoboamu tate ba Abiya, Abiya tate ba Asa. ");
INSERT INTO ndg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa abile tate ba Yehishafati tate ba Yoramu, ni Yoramu tate ba Uzia. ");
INSERT INTO ndg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia abile tate ba Yothamu, Yothamu tate ba Ahazi, Ahazi tate ba Hezekia. ");
INSERT INTO ndg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia abile tate ba Manase, Manase baba ba Amoni ni Amoni tate ba Yosia. ");
INSERT INTO ndg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia abile tate ba Yekonia ni kaka bake wakati pabatolilwe yenda Babeli. ");
INSERT INTO ndg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ni baada ya tolelwa yenda Babeli, Yekonia abile tate ba Shatieli abile babu bake ni Zarubabeli. ");
INSERT INTO ndg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubabeli abile tate ba Abiudi, Abiudi tate ba Eliakimu, ni Eliakimu tate ba Azori, ");
INSERT INTO ndg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori abile tate ba Zadoki, Zadoki tate ba akimu, ni Akimu baba ba Eliudi. ");
INSERT INTO ndg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi abile tate ba Eliaza, Eliaza tate ba Matani ni Matani tate ba Yakobo. ");
INSERT INTO ndg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo abile tate ba Yusufu nsengo wa Mariamu, ambaye kwa Yembe Yesu abelekilwe, ywa kemwa Kristo. ");
INSERT INTO ndg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ibelei yoti tangu Ibrahimu hadi Daudi yabile ibelei komi ni ncheche, kuoma Daudi hadi kutoliwa yenda Babeli ibelei komi ni ncheche, ni kuoma kutoliwa yenda Babeli mpaka Kristo yabile ibelei komi ni ncheche. ");
INSERT INTO ndg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Belekwa kwa Yesu Kristo kwabile nyonyo, Mao bake, Mariamu, achumbilwe ni Yusufu, lakini babi bado gonja pamope, abonekine kubi ni ndumbo kwa uwezo ba Roho mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nchengo bake, Yusufu, abile mundu wa Nnongo apendi kwaa kumpeya oni. Amweni anneka kwa siri. ");
INSERT INTO ndg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pabilekagawaza kunani makowe ago, Malaika ba Ngwana ampili mundoto, kakoya, “Yusufu mwana wa Daudi, kana uyogope kuntola Mariamu kuba nnyumbo bako, kwa sababu ndumbo abi nayo ni kwa uweza wa Roho mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Alowa beleka mwana nnalome ni walowa kunkema lina lyake Yesu, kati apala kubalopwa bandu bake kuoma musambi zabe.” ");
INSERT INTO ndg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ngoti yega yapitike kamirisha chelo sabakilwe kwa ndela ya manabii, kakoya, ");
INSERT INTO ndg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Lola, bikira apatola ndumbo ni beleka mwana nnalome, ni akemwa lina lyake Imanueli maana yake, “Nnongo pamope natwenga.” ");
INSERT INTO ndg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu atiyumuka kuoma mulugono ni panga kati malaika wa Ngwana akoite nga atikumpotwa kati nnyumbo bake. ");
INSERT INTO ndg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Palyo, agonjike kwaa nakwe mpaka paapapite mwana wake nnalome akemilwe lina lyake Yesu. ");
INSERT INTO ndg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Baada ta Yesu, belekwa mu Bethlehemu ya Uyahudi plyo pa utawala ba mpwalume Herode bandu asomi buka kubwani ya kutalu baisile Yerusalemu kaakoya, ");
INSERT INTO ndg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ywabile kwaa'ko ywabelekilwe mpwalume Ayahudi? twabweni itondwa yabile mashariki yitu tuisi kumwabudu. ");
INSERT INTO ndg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Palyo mpwalume Herode payowine atiyogopa, ni Yerusalemu yote pamope ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herode nga akusanya boti apendo ba makuhani ni baandishi ba bandu, kaalokiya, “Kristo abelekwa kwako?” ");
INSERT INTO ndg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kaba koya, “ku'Bethlehemu ya Ayahudi, mana nyon nga yaandikilwe ni manabii, ");
INSERT INTO ndg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ni wenga Bethlehemu, mu, nchi ya ya Yuda, nchunu kwaa nnonge ya iongozi ba Yuda. kwa kuwa kuoma kwako wabile mtawala ywalowa kuwachunga bandu bango ba Israeli.” ");
INSERT INTO ndg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herode kabakema balo asomi kwa siri ni kabakoya muda gani hasa itondwa ipala bonekana. ");
INSERT INTO ndg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Abatumite ku Bethlehemu, kakoya, “muyende mbolembole mukalaluye muda hasa mwana ywa abelekilwe. Palyo mwalowa m'bona, muniletei habari ili mwanja ni nenga niweche isa ni kumwabudu.” ");
INSERT INTO ndg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Paba myowine mpwalume, bayei ni mwanja wabe, ni tondwa lelo waibweni ngolo ni yatikuwalongoya mpakanpaluyemi kunani ya mwana pabelekwile. ");
INSERT INTO ndg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Palyo paibweni tondwa, bapulaike muno. ");
INSERT INTO ndg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bajingii nnyumba ni bamweni mwana ywa belekilwe ni Mariamu mao bake, batikunolekea ni kunnoba. Baundwi misigo yabe ni kumpeya zawadi ya dhahabu, uvumba ni manemane. ");
INSERT INTO ndg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nnongo atikubaonya mu'ndoto kana bapite kwa Herode, ila babuye kwa ndela yenge. ");
INSERT INTO ndg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baada ya kuoma, malaika ba Ngwana ampiye Yusufu mundoto ni kukoya,'Uluka, umpotwe mwana ni mao bake ni m'butukie Misri. Mutame kwoo mpaka pana mmakiya, mwanja Herode apala mwana amulage. ");
INSERT INTO ndg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kilo Yusufu atiyumuka ni kupotwa mwana ni mao bake ni kabutukya Misri. ");
INSERT INTO ndg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Atami kwoo mpaka Herode awile. Alee litimii lelo likowe lya longei Ngwana pitya kwa anabii, “kuoma Misri ni kemite mwana wango.” ");
INSERT INTO ndg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Boka po Herode pabweni asomi batikonga, atikasirika sana. Alangi kwabulaga bana boti alalome bababile Bethlehemu miaka ibele mpaka pae yake kuoma muda ng'ulo wa akikishe na asomi. ");
INSERT INTO ndg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Palyo ngalitimii likowe lya alongei mukano wa nabii Yeremia, ");
INSERT INTO ndg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lilobe lyayowinike Rmah, kilelo sa lobola muno, Raheli kalelya bana bake, ni akani kumpembelya, mana bawile.” ");
INSERT INTO ndg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herode pawile, linga malaika wa Ngwana atikumpitya Yusufu mu ndoto kaakoya, ");
INSERT INTO ndg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Uluka untole mwana ni mao bake, ni myende mu'nnema ba'Aisraeli kwa maana babau palenge byomi wa mwana bawile.” ");
INSERT INTO ndg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufu kayumuka ngampotwa mwana pamope ni mao bake, kaisa kunnema wa Israel. ");
INSERT INTO ndg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lakini payowine panga Arikelau abile katawala Yuda badala ta tate bake Herode. endeyogopa yenda kwao. Baada ya Nnongo kukalipwa kwa lota, atibuka yenda kunnema wa Galilaya. ");
INSERT INTO ndg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ni ayei tama kunnema woo waukemelwa Nazareti. Alee lenga lilimi likowe lyalongei kwa ndela ya manabii, panga alowa kemelwa Mnazareti. ");
INSERT INTO ndg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Palyo machiba ago Yohana mbatizaji atiisa kuhubiri kupongoti ya Yuda kakoya, ");
INSERT INTO ndg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mulobe samaha mana utawala wa Nnongo ubi karibu.” ");
INSERT INTO ndg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Maana ayoo nga mmaite manabii Isay kakoya, “Lilobe lyamundu buka kupongoti, mwibika tayari ndela ya Ngwana, mumugoloye mwalowa peta. ");
INSERT INTO ndg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nambeambe Yohana aweti manyoya ga ngamia ni nkanda wa likenga nkibuno chake chakulya chake chaimapai nni busi wa mmwitu. ");
INSERT INTO ndg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Boka po Yerusalemu, Yuda yote, ni lieneo lyoti lyalitindiyete libendo lya Yordani bayei kachake. ");
INSERT INTO ndg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bayendage batizilwa mulibende lya Yordani kuno bakitubu sambi zabe. ");
INSERT INTO ndg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ila paabweni mafarisayo ni Masadukayo banyansima kabankengama kwabe kupala batizwa, kabakokiya, “Mwenga mwa lukolo lya nng'ambo ywabile sumu nyai nyai ywakwelike mwitile gadhabu yaisa? ");
INSERT INTO ndg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mupambike matunda gagalendine ni toba. ");
INSERT INTO ndg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kana muwaze ni longela nkati yinu,'Tubile ni Ibrahimu kati tate bitu.' Kwa kuwa nenda kuwakokiya Nnongo awesa kutondobekeya Ibrahimu bana kuoma mu'maliwe aga. ");
INSERT INTO ndg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Libengo tayari liyomwike bekelwa mu, mikega ya mikongo. Ni nkongo wawakotoka kwaa pambika matunda ganoike kutema ni kuteikuliwa pa mwoto. ");
INSERT INTO ndg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nindakuwabatiza mu'mache kwaajili ya tubu, Lakini ywembe ywaicha nchogo yangu kulo nenga ni nchene ni nenga ngwesa kwaa hata kwipotwa ilatu yake, ywembe alowa kwabatiza kwa Roho Mtakatifu ni kwa mwoto. ");
INSERT INTO ndg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ni kipepeto sake kibii muluboko lwake pwaya sana lubanja lyake ni kumba ngano yake muligala. Lakini atinie makapi mo mwoto wainika kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesu kaisa kuoma Galilaya mpaka lubendo Yordani abatizwile ni Yohana. ");
INSERT INTO ndg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lakini Yohana apalage kana kakoya, “Nenga nipalikwa nibatizilwe ni wenga, ni wenga kaicha kachango?” ");
INSERT INTO ndg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu kayangwa ni kukoya, Uyeketi ibe nyonyo saa yeno, kwa sababu ipalikwa timiza haki yoti.”kisha Yohana atiyeketya. ");
INSERT INTO ndg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Baada yabatizilya, mara Yesu apitike mmache, linga, kunani kwatiyogopa kayake ni amweni Roho ya Nnongo kuuluka kwa mfano wa nngunda ngaloa pantwe wake. ");
INSERT INTO ndg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lola, lilobe latiboka kumaunde ni kukoya, “Ayo nga mwana wango nimpendile muno.” ");
INSERT INTO ndg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Boka po Yesu ngapelekelwa ni Roho mpaka kupongoti lenga ajaribiwe ni nchela. ");
INSERT INTO ndg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Atabike masoba arobaini mutwekati ni kilo ngaibona njala. ");
INSERT INTO ndg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nchela atimwichilya ni kunkokiya, “Mana itei wenga wa mwana wa Nnongo, ugabakiye maliwe aga gapangite nkate.” ");
INSERT INTO ndg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lakini Yesu kan'yangwa ni kunkokiya, “Itiandikwa,'Mundu kana atama kwa nkate kichake, ila kwa kila likowe lyapita munkano wa Nnongo.'” ");
INSERT INTO ndg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Boka po nchela ampelekile kunnema mtakatifu ni kunbeka kunani muno ya kuliyengo lya hekalu, ");
INSERT INTO ndg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ni kunkoya, “Mana itei wenga wa mwana wa Nnongo, witomboye pae, maana itiandikwa,'Alowa kwalazimisha malaika bake pake pakupoke,' ni 'kuku kakatuya kwa maboko gabe, linga wakana kobala lungolo lwake muliwe.” ");
INSERT INTO ndg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kaakoya, “Kae iandikilwe, kana un'geye Ngwana Nnongo bako.” ");
INSERT INTO ndg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Boka po nchela ngamputwike yendya mahali pa kunani muno ngamnaya utawala wote wa dunia ni ikowe yake yoti. ");
INSERT INTO ndg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kakoya, “Nalowa kukupeya ilebe yoti yino mana unisujudu ni kuniabudu.” ");
INSERT INTO ndg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Boka po Yesu kankoya, “boka uyende wa nchela! Mana iandikilwe,'Ipalikwa kumwabudu Ngwana Nnongo bako, ni umtumikie yembe kichake.'” ");
INSERT INTO ndg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nchela anlekite, nga linga, malaika ngaisa kunyangatia. ");
INSERT INTO ndg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu nga yowine panga Yohana ateboyolwa, atiboka mpaka Galilaya. ");
INSERT INTO ndg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Abokite Nazareti yenda ni kutama Karperanaumu, yaibile papipi ni bahari ya Galilaya, mpakani mwa lijimbo lya Zabuloni ni Naftali. ");
INSERT INTO ndg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ayee yapiti lenga litimii chelo chalongei nabii Isaya, ");
INSERT INTO ndg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ku nnema wa Zabuloni ni nnema wa Naftali yendelya kubari, kwiye ya Yordani, Galilaya ya bamataifa! ");
INSERT INTO ndg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bandu babatami mulubendo baubweni mbwega wananchima, ni balo batami pamwili wa kiwo, kunani ya mbwega yatikuwaangazia.” ");
INSERT INTO ndg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuoma muda woo Yesu atumbwi hubiri kakoya, “mutubu, mana utawala wa kunani ulegelile.” ");
INSERT INTO ndg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Abile atyanga mbwega ya bahari ya Galilaya, amweni apendo abele, Simoni ywa kemela Petro, ni Andrea kaka bake, kabatengwa mbelete yabe mubahari, mana babile avuvi ba omba. ");
INSERT INTO ndg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu kaakoya, “Muiche munikengame, nilowa kuwapeya uvuvi wa bandu.” ");
INSERT INTO ndg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nga bailekite belele yabe ni kumkengama. ");
INSERT INTO ndg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu abile kayendelya kuoma abweni apendo benge, Yakobo mwana wa Zebedayo, ni Yohana kaka bake babile mungalaba pamope ni tate babe Zebedayo kaba sokota mbelele yabe, Nga akema, ");
INSERT INTO ndg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ni mara jimo baileka ngalaba ni tate babe ni bembe kabankengama. ");
INSERT INTO ndg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ayei karibia Galilaya yoti, kapundisha mumasinagogi gabe kahubiri Injili ya utawala, ni kuponya kila matamwe ga bandu. ");
INSERT INTO ndg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Habari yake yayowanike Siria yoti, ni bandu kabaleta balo boti atamwe, bababile ni malazi goti ni minya, bababile ni moka, ni bene kiundaundani bababile lemile. Yesu kabaponiya. ");
INSERT INTO ndg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","kipenga sa bandu bati kunkengama kuoma Galilaya ni Dekapoli, ni Yerusalemu ni Uyahudi ni kuoma ng'ambo ya Yordani. ");
INSERT INTO ndg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu paakibweni kipenga sa bandu, atiboka ayei pakitumbi, paatami pae, banapunzi bake baichi kichake. ");
INSERT INTO ndg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nga yowa nkano wake kapundisha, kakoya, ");
INSERT INTO ndg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Heri bababile akeba ba Roho maana utawala wa Nnongo wabe. ");
INSERT INTO ndg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Heri balo bene huzuni, mana batafarijiwa. ");
INSERT INTO ndg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Heri bene upole, mana balowa kurithi nchi. ");
INSERT INTO ndg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Heri bene njala ni kui ya haki, mana bapala yukutilwa. ");
INSERT INTO ndg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Heri bene rehema mana abo bapala pata Rehema. ");
INSERT INTO ndg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Heri bene mwoyo sapi mana walowa kum'bona Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Heri bapatanishi ba haki, maana abo balowa kemelwa bana ba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Heri balo babateswa kwaajili ya haki, maana upwalume wa Nnongo ni wabe. ");
INSERT INTO ndg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Heri mwenga mwamutukanilwa ni bandu ni kuwatesa, au kubakokeya kila ubaya kachinu kwa ubocho kwa mwanja nenga. ");
INSERT INTO ndg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mupulaike ni luluta, maana thawabu yinu ni ngolo kunani kumaunde. Kwa kuwa nga bandu gaba-apangite manabii bababile kabla yinu. ");
INSERT INTO ndg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mwenga mwa mwinyo wa dunia. Lakini kati mwinyo uaribike, olowa pangika kitiwi ubenanoga kwake kae? Iwezekana kwaa ube ni radha ili kujita panja ni kulebata ni agolo ga bandu. ");
INSERT INTO ndg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mwenga mwa mbwega wa dunia. Nnema wauchengilwe pakitombe wiyobeya kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bandu bawasha kwaa taa ni kwibeka pae ya kindanda, ila kunani, ni ywembe yenda kuwamulikya boti nkati ya nyumba. ");
INSERT INTO ndg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ni mbwega winu umulike nnongi ya bandu linga bagabone matendo gananoga ni kumsifu tate binu ywaabile kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kana muwase niichi kuibulaga saliya wala manabii, niichile kwaa kuiharibu ila kwitimiza. ");
INSERT INTO ndg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kwakweli nindakuwakoya nyoo mpaka maunde ni dunia yate pita mtupo yodi wala nukuta jimo ya saliya yayalowa kuoma musaliya mpaka po kila kilebe kiyomwile timia. ");
INSERT INTO ndg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eyo yeyote ywatekwana amri njunu yimo nkati ya amri yee nikuwapudisha benge panga nyoo alowa kemelwa nchunu mu'utawala wa kumaunde. Lakini ywoywoti ywaikamwa ni kuipudisha alowa kemelwa nkolo mu'utawala wa kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kwa maana nabakokiya ukweli winu mana mukotwike kwazidi baandishi ni mafarisayo, kwa vyovyoti mwabile mwajingya nkati ya ufalme wa kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Muyowine yabakiyilye zamani panga, “kana ubulage” ni ywoywoti ywa bulaga abi pae ya hukumu.' ");
INSERT INTO ndg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lakini nendakuwakokiya ywoywoti ywanchukiya nnongowe apalikwa ukumilwa. Ni ywoywoti ywammakiya nnongowe panga, wenga wa mundu wangefaika! apangika kwa ballaza, Ni ywoywoti ywabaya wenga wa nyinga apalikwa ni mwoto wa jehanamu. ");
INSERT INTO ndg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Eyo mana kopiya sadaka yako nnonge ya Nnongo ni kankombokiya panga winakikowe nnongogo. ");
INSERT INTO ndg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Uwileke sadaka nnonge ya madhabahu, ni ukamwe ndela yako. Ukapatane wete nnongo'wo, ni boka po uiche kuitola sadaka yako. ");
INSERT INTO ndg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Upembele ni mshitaki wako upesi, uwineke mundela kamuyenda mahakamani, kinyime chake alowa kupeleka kwa hakimu ni kukutaikulya muligereza. ");
INSERT INTO ndg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Muamini nendakuwamakiya, walowa lekelwa kwa mpaka ulepe senti ya mwisho yalongelwa. ");
INSERT INTO ndg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Muyowine yaiikokiywe panga, “Kaa ube ni malaya.” ");
INSERT INTO ndg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lakini neda kuwakokiya ywoywoti ywa nnolekeya nnwawa kwa kutamaniya ayomwile gonja nakwe mwoyo wake. ");
INSERT INTO ndg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na mana itei liyo lyako lya kummaliyo lyenda kuobeya, ulitolwe ulitaikwe kutalu ni wenga. Kwasababu bora kiungo chimo cha payega yako kiobe kuliko yega yako yoti watakulikwe jehaamu. ");
INSERT INTO ndg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na mana itei luboko lwako lwa kummaliyo lyenda kukosea, walukate ni kulutaikwa kutalu ni wenga. mana bora kiungo chako chimo cha payega yako kiobe kuliko yega nzima taikulilwa jehanamu. ");
INSERT INTO ndg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Itibakijilwa kae, jwalowa kuneka nnyumbowe ampei hati ya talaka' ");
INSERT INTO ndg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lakini nenda kuwakokiya, ywoywoti jwa nneka nnyumbowe, ila kwa abari ya umalaya, apanga mmalaya, i ywoywoti ywa nkobeka baada ya peyelwa taraka enda zini. ");
INSERT INTO ndg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kai muyowine batibakijilwa balo azamai,'kana mulape kwa ubocho, umtumikiye Ngwana lapa kwako' ");
INSERT INTO ndg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ila nenda kuwakokiya, kana mulape hata pasene, au kwa maunde, kwasababu kuezi ya Nnongo; ");
INSERT INTO ndg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Wala kwa dunia, maana ngabeka magolo gake, aokwa Yerusalem, maana ni nema mpwalume nkolo. ");
INSERT INTO ndg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wala kana walape kwa mtwe wako, mana uweza kwa kulupanga lunywili limo panga luua u lupili. ");
INSERT INTO ndg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ila makowe ginu gabe, “Kweli, kweli, kana, kana,'mana ywa yongeya makowe gabuka kwa nchela. ");
INSERT INTO ndg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Muyowine ikokiywe panga, “Liyo kwa liyo, ni lino kwa lino.' ");
INSERT INTO ndg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lakini nenda kuwakokiya, kana mwasindane nchochi, lakini mundu akukombile ligomo lya mmaliyo wangalambukiye ni lenge. ");
INSERT INTO ndg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ni mundu ywa lowa kukushitaki ni kuitola nganju yako, unneki ni likoti. ");
INSERT INTO ndg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ni mundu ywa kulazimisha yenda maili jimo wayende nakwe ibele. ");
INSERT INTO ndg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ywa kuloba wampei, ni ywapala kukopa kana untile. ");
INSERT INTO ndg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Muyowine panga ikokiywe,'umpende jirani bako ni umchukie adui bako.' ");
INSERT INTO ndg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lakini nenga nendakuwakokiya, mwapende adui binu mwalobii mwisi, ");
INSERT INTO ndg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","linga mupange mwabana batate binu bababile kumaunde, maana jwembe amulikya lisoba lyake abaya ni bema, ulaenda niya kwa bandu boti bene haki ni bange haki. ");
INSERT INTO ndg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mana mene mwapendi babapendile mwenga mupata thawabu gani? Hata bai! ni bembe bapanga kwaa nyoo? ");
INSERT INTO ndg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kae mana mwapendi alongo binu bai, mupanga namani cha zaidi? Hata bandu bageaminiye bapanga kwaago? ");
INSERT INTO ndg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bai mwenga mwalowa panga mwatakatifu, kati tate binu ba kumaunde mwababile atakatifu. ");
INSERT INTO ndg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kana upange makowe ganoite kwa bandu linga ubonekane, wapata kwaa thawabu buka kwa Tate abile kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kwaiyo mana kopiya kana upage ndoti na kuipuna mwene kati nanfiki babapanga mumasinagogi gabe ni mumitaa, linga panga bandu balumbe, kweli nenda kuakokiya, bayowine pokya thawabu yabe. ");
INSERT INTO ndg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lakini wenga mana kopiya, liboko lyako lya mashoto kunkeya lwa mmalyo kana lutange chakipanga. ");
INSERT INTO ndg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","linga panga zawadi yako ipijilwe kwa siri, ni Tate bako babakubona kwa siri alowa kukupeya zawadi yake ipiyilwa kwa siri. ");
INSERT INTO ndg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","paupanga, kana ube kati wa nnafiki, maana bapendike yema ni loba 'mumasinagogi ni mulukona, linga panga babonekane ni bandumkweli nenda kuakokiya bapokite thawabu yabe. ");
INSERT INTO ndg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lakini wenga, mana ulobie, kuyingii mu, chumba, ujigale nnango, ni ulobe kwa mwanja tate bako ywa abile musiri, Nga Tate bako ywaaibona siri alowa kupeya thawabu yako. ");
INSERT INTO ndg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na paaloba, kana ukeme kwaa marudio kati ya apanga amataifa, kwasababu bawasa panga balowa kwayowa kwa mwanza makowe gabe gana nchima. ");
INSERT INTO ndg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kwa eyo, kana mube kati bembe, mana Tate bako atangite ywagapala hata balo waloba kwake. ");
INSERT INTO ndg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kwa eyo, mulobe nyonyo, “Tate bitu waubile kumaunde, lina lyako litukuzwe. ");
INSERT INTO ndg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Upwalume wako uiche, champendile kipangilwe hapa pakilambo kati kwo kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utupei lino nkate witu wa kila lisoba. ");
INSERT INTO ndg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utusamee madeni yitu, kati twenga twatuwasamee wadeni witu. ");
INSERT INTO ndg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kana utupei majaribu, lakini utulopwe ni yulu nchela. ");
INSERT INTO ndg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","mana itei mwalowa kwasamiya kwa makosa gabe, Ni Tate bako ywabile kumaunde apala kwasamee mwenga. ");
INSERT INTO ndg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lakini yaibile muwasamee kwaa makosa gabe, Tate binu awasamee kwaa makosa yinu ni mwenga. ");
INSERT INTO ndg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Zaidi ya yoti, mana autabike, kana ubonekane kuminyo kwati kekenaa kati anafiki mwabapaga, mana benda kekenala kuminyo yabe linga bababonikine ni bandu, panga batabike. Kweli niaalokiya, bayomwite pokya thawabu yabe. ");
INSERT INTO ndg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lakini wenga, mana utabike, upakile mauta mutwe wako ni uuluwe kuminyo. ");
INSERT INTO ndg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nyoo watanganikwa kwaa ni bandu panga utabike, ila Tate bako ywabile musiri, alowa kupeya thawabu yako. ");
INSERT INTO ndg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kna ubeke akiba mukilambo, mabongo ni kutu yalowa alibiya, ni bai tekwana ni jiba. ");
INSERT INTO ndg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Itunzie akiba yako mwene kumaunde, hakwo mabongo wala kutu ialabiya kwaa ni mwii aweza kwaa tekwana ni jiba. ");
INSERT INTO ndg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mana akiba yako paibile, ni mwoyo bako nga walowa baa. ");
INSERT INTO ndg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Liyo nga taa ya payega, kwa eyo, mana itei liyo lyako likoto, yega yoti walowa panga ni bwega. ");
INSERT INTO ndg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lakini mana liyo lyene libou, yega yako yoti, iba twelya lybendo totoro. Kwa eyo, mana itei bweya waubile nkati yake lubendo hasa, lubendo lukolo kiasi gani! ");
INSERT INTO ndg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ntopo hata yumo ywaweza kwatumikya ngwana abele, mana alowa kunchukiya yumo ni umpenda ywenge, au alowa tama kwa yumo ni kunzalau ywenge, mwaweza kwaa kuntumikya Nnongo ni mali. ");
INSERT INTO ndg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kwa eyo nendakukokiya, kana mube ni masaka husi maisha gako, panga mwalwaa namani ni mwawala namani. ");
INSERT INTO ndg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lola iyuni ya kunani, bapanda kwaa, bauna kwaa, ni kana bakusanye ni kutunza mughala, lakini Tate binu ywaabile kumaunde ubalisha. Namani mwenga mwa thamani kwaa kuliko iyuni? ");
INSERT INTO ndg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nyai nkati yinu ywaisumbukiya ywa enda weza kwiyongeya miaka ya maisha gake? ");
INSERT INTO ndg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mwanja namani mukonda mashaka husu mawalo? muwase maloba ga mumigunda, mwaganawili. Gapanga kwaa lyengo ni gaweza kwiwalika. ");
INSERT INTO ndg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bado niakokiya, hata Sulemani wakati wa utawala wake awalikwe kwa kati ga mulobe. ");
INSERT INTO ndg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mana itei Nnongo agawalika manyei mu'ng'unda ni gatama kwaa miaka yananchima malao baika kagataikulya kumwoto, tubwe kwa kitiwi mwalowa kumwalika mwenga, mwenga mwabile ni imani njene? ");
INSERT INTO ndg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tubwe kana bube ni mashaka kamukoya,'mwakolongwa tulolya namani?'Au “Twalowa nywaa kele?” au twalowa waa ngobo gani?” ");
INSERT INTO ndg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mana amataifa nembe bapala makowe aga, ni Tate binu ywa kumaunde atangite panga mwenda gapala goo. ");
INSERT INTO ndg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lakini wete mupale utawala wake ni kweli wake ni ago goti mwalowa peyelwa. ");
INSERT INTO ndg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kwa eyo, kana ubeke shaka kwaajili ya malabo, mana malabo yaisumbukya yene. Kila lisoba lyalengani kwa litatizo lyake lyene. ");
INSERT INTO ndg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kana uhukumu, ni wenga walowa hukumilwa. ");
INSERT INTO ndg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwa hukumu yalowa kubahukumu benge, ni wenga walowa hukumilwa. Kwa kipimo sa upimite ni wenga walowa pemelwa chechelo. ");
INSERT INTO ndg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mwanja namani ulolekipande cha kibile muliyo lya nnongowo, lakini utanga kwaa lipekete lya libile muliyo lyako? ");
INSERT INTO ndg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Uweza buli baya kwa nongowo, linda nikubuye kipande sa kibile muliyo lya nongowo, wakati wabile ni lipekete mu'liyo lyako? ");
INSERT INTO ndg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wannafiki wenga, “wete uboye lipekete lyalibile muliyo lyako, ngauweza kuliboa kinanoga ni kummoya nongowo lyalibile muliyo lya nnongowo. ");
INSERT INTO ndg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kana uwapei mbwa chakulya kitakatifu, ni kana wataikuli magombe kilebe cha thamani nnonge yabe. Mana balowa kuitahabikya ni kwi lebata kwa magolo, ni kai bakugalambukya wenga ni kukupalangwana ipande ipande. ");
INSERT INTO ndg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Loba, ni wenga walowa pata, Upate ni wenga walowa kwibonapanga. Upinge hodi, ni wenga wapala yogolelwa. ");
INSERT INTO ndg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ywoywoti ywa loba, upokya. Ni ywoywoti ywabisha hodi, apala yogolelwa, ");
INSERT INTO ndg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Au abile mundu nkati yinu ywabile, mwana wake anobite kipande sa nkate apala mpei liwe? ");
INSERT INTO ndg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au maa anobite omab, ni ywembe apala mpeya lingambo? ");
INSERT INTO ndg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kwa eyo, mana itei mwenga mwabaya mutangite kuwapea wana winu zawadi inogite, je kiasi gani kwa Tate ywabile kumaunde apala kuwapea ilebe inanoga balo bannobite? ");
INSERT INTO ndg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kwasababu eyo, waupala pangilwa ni bandu benge ni wenga wapayi nyonyonyo mana ayee sheria ni manabii. ");
INSERT INTO ndg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mjingi kwo pitya niyango wabana, Mana nnyango nkolo ni ndela ngolo yeyenda kuobi, ni bandu babapeta ndela yoo bananchima. ");
INSERT INTO ndg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nnyango watibana, nnyango wabana ni ndela yeeyenda kuukoti achunu baweza kuibona. ");
INSERT INTO ndg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Muiazari ni manabii baubocho, balowaicha bawati likengo lya ngondolo, lakini kumbe kibwa mwitu akale. ");
INSERT INTO ndg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kwa matokeo gabe mwalowa kuwataba, je bandu baweza una matunda gaanoga muichongoma, au tini mukongo wa mbaruti? ");
INSERT INTO ndg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kwa nyoo bai, kila mkongo unanoga upambika matunda gananoga, lakini mkongo mmaya upambika matunda ganoite kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mkongo unanoga uweza kwaa pambika matunda yanoite kwaa, ata mkongo unanyata uweza kwa pambika matunda gananoga. ");
INSERT INTO ndg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila mkongo waupambika kwaa matunda yanoite walowa taikwa mu mwoto. ");
INSERT INTO ndg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nga nyo, mwalowa kwatanga bokana ni matunda gabe. ");
INSERT INTO ndg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Si kila mundu ywanikema nenga,'Ngwana, Ngwana,' alowa jingya mu upwalume wa kumaunde, ila yolo ywapanga gagapendike Tate bangu ba kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bandu bananchima banibakiya lisoba lyo,'Ngwana, Ngwana, twapiyete kwa unabii kwa lina lyako, tukemile kwa masetani kwa lina lyako ni lina lyako twapagite makowe makolo?' ");
INSERT INTO ndg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nga niakokiya wazi,'Niatangite kwaa mwenga! muboke kachango, mwamupanga sambi!' ");
INSERT INTO ndg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kwa eyo, kila yumo ywayowa maneno gango ni kugatii alowa landana ni mundu mwene lunda ywachengite nyumba yake paliwe. ");
INSERT INTO ndg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ulatiniya machegatitwelyana na mbonga ya tiputa nyumba yoo lakini wawezike kwa bomoka maana ya chengilwa paliwe. ");
INSERT INTO ndg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Namundu jwa liyowa likowe iyango alitikwako aliwapangitwa katimundu ngalunda jwachungite nyumba yake palwangi. ");
INSERT INTO ndg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ulatisa mafuliko gatiicha mbonga yatipukatya na kwikobwa nyumba yoo! ngobomoka na alibika sana. ");
INSERT INTO ndg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wakati yesu payomwi longule makowe gaa bandu batigasangala mapundisho gake. ");
INSERT INTO ndg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mana apundishike katimundu mwene utawala sio kati waandishi babe ");
INSERT INTO ndg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ysu pauluka buka pakitombe bandu banyansima batikuukengama. ");
INSERT INTO ndg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lola mwene ukoma atikukilikitya nnonge yake kabaya.”Nngwana mana uwezike uniponeye. ");
INSERT INTO ndg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ngamkwamwa na liboko lwake kabaya “mbala ube wankoti,” popopo ngapona ukoma wake. ");
INSERT INTO ndg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu kankokeya, “lola kene wamakiye munelu jwo jwote. Uyende ukailaye kwa makuwani na upiye sadaka kati Musa mwalagile, lenga na bembe bakatange” ");
INSERT INTO ndg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu paikite kaperanaumu jemedari atei ni kunnobia, ");
INSERT INTO ndg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kabaya, “Nngwana, mtumishi wango atigonja kasango alipooza na andaminya sana. ");
INSERT INTO ndg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu ngammakiya, “nalowaicha na kumponeya.” ");
INSERT INTO ndg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jemedari kanyangwa na kummakiya, “Ngwana nega najwa thamani kwaa hatawiche nojingya nnyumba yango ulongele likowe tuu na mtumwa wango alowapona. ");
INSERT INTO ndg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mana nenga wa mundu wa mwene utawala na nibii na askari pae yangu mana nibaite wenga ayo yenda na kayenda na wenga isa aicha na kwa tumishi wango panga nyoo nanjwembe panga! ");
INSERT INTO ndg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu payowine nyoo atashangala sana na kwabakiya balo baba nkengamage kweli nendakumakiya napata kwa kumona mundu mwene imanikati yoo Muisrael. ");
INSERT INTO ndg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nendakumakiya baingi balowaisa buka kubwani na kubara balowa tama pameza pamope na Abrahamu, Isaka na Yakobo mu utawala wa kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lakini bana ba ufalme balowa taikulilwa mulubendo lwa panja nga kwaba na kulelo na tauna mino. ");
INSERT INTO ndg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu ngamakiya jemedari yenda kati mwoyo mwi aminiya naipangi lwe nyo kachako namtumishi aponi muda wowowo ");
INSERT INTO ndg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wakati Yesu paaikite kunyumba ya Petro, amweni mao bake nyumbowe Petro agonjike kaminya homa. ");
INSERT INTO ndg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu kankamwa ni luboko lwake, ni homa yake gainneka. Ngayumuka kaba muhudumia. ");
INSERT INTO ndg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Piikite kitamunyo, bandu banletike Yesu bandu banyansima bene nsela. Kaabuya nsela ni kuaponiya atamwe. ");
INSERT INTO ndg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kwa jinsi yee gatimii galo gagabakiyilwa ni Isaya nabii, “Ywembe mwene agapotwi matamwe gitu ni apotwi malasi gitu.” ");
INSERT INTO ndg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kae Yesu pabweni kipenga sa bandu kiyengetike, atikwaelekeza ya yenda upande wenge wa bahari ya Galilaya. ");
INSERT INTO ndg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngaa mwandishi aisa kasake ni kunkokeya, “Mwalimu, mbala kukukengama kwokwote kwawapalayenda.” ");
INSERT INTO ndg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kakoya, “mkunge abi ni lembwa, nakiyuni sakunani ayi ni iyumba, lakini mwana wa Adamu ntopo pandu pogonjeka ntwe wake.” ");
INSERT INTO ndg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mwanapunzi ywenge kankokeya, “Ngwana, umbei rusa wete ngasike Tate bango,” ");
INSERT INTO ndg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lakini Yesu kaankokeya, “Ungengame, waleke wafu basikane bene” ");
INSERT INTO ndg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu payingii mungalaba, anapunzi bake, batikunkengama molo mungalaba. ");
INSERT INTO ndg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Linga lyapitike limbonga mubahari yene, mpaka ngalaba yaiwekelekwa. Lakini Yesu agonjike. ");
INSERT INTO ndg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Anapunzi bake kabayenga kunyumuya kababaya, “Ngwanautulopwe twenga, twenda waa!” ");
INSERT INTO ndg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu kaakokeya, “mwanja namani muyogopa, mwenga mwabene imani njene?” Ngayumuka ni kukalipya limbonga lya mubahari. Ngapautulia liki, ");
INSERT INTO ndg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Analome kabasangala ngababaya, “Ayu mundu ywa aina gani, ata mbonga ya mubahari yenda kumtii yembe?” ");
INSERT INTO ndg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wakati Yesu pabiliye lenge wa nnema wa Magadala, alalomea abele batawalilwe ni nsela batikwembana nakwe. Babokage mumakaburi ni babile ni vulugu muno, ata apeta ndela bawesa kwaa peta ndela yoo. ");
INSERT INTO ndg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lenga, batikemelana ni koya, “Twinamani cha panga kachako, wa mwana wa Nnongo? Uichi kututesa ata wakati witu wangaisa?” ");
INSERT INTO ndg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pabile ni likundi likolo lya ngobe kabalepolya manyei, babile kwa kutalu, ");
INSERT INTO ndg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","nsela ngabakemelya kabakoya, “Mana kautuamuru tuboke utupeleke kulikundi lya ngobe.” ");
INSERT INTO ndg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu kaakokeya, “Muyende!” nsela kababoka yenda kwa ngobe. Ngalinga, likundi lyoti galilela buka kukitombe ni yendya mubahari ni lyoti lyaweli mmache. ");
INSERT INTO ndg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Alalome kabasangala ngobe batitila, Napabayei mjini batikuwabakiya yoti gagapitile, hata cha ubendi upepo. ");
INSERT INTO ndg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lola, mji woti wati icha kwembana ni Yesu. Paba mweni, batikunnoba abuke mukowa wabe. ");
INSERT INTO ndg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kayingya mungalaba, ngaloka kaika mukijiji chenge cha atamage. ");
INSERT INTO ndg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lola, kabannetya mundu ywa pozike agonjike paligodolo. paaibweni imani yabe, Yesu kankokeya ywa mundu apoozike, “Mwanawango, ube ni puraha, dhambi yako usameilwe.” ");
INSERT INTO ndg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lola, baadhi ya baalimu ba saliya bende bakiyana bene kwa bene, “Mundu yoo enda kupulu” ");
INSERT INTO ndg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu atangite mawazo gabe ni kabaya, “Mwanja namani muwaza mabaya mumwoyo winu? ");
INSERT INTO ndg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Cha'ako chakibii rahisi baya, “sambi yako isameilwe!” au baya, “Yema uyende” ");
INSERT INTO ndg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lakini mutange panga mwana wa Adamu abile nao uwezo wo samiya sambi...”Abayite goo kwa yolo ywapoozike, “Yema, uputwe ligodolo lyako, ni uyende kasako.” ");
INSERT INTO ndg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ni yolo mundu kayema kaboka yenda kachake. ");
INSERT INTO ndg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kipenga sa bandu kapabweni agoo, batisangala ni kunsifu Nnongo, ywa apeilea uwezo uwo bandu. ");
INSERT INTO ndg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ni Yesu paabile kapeta kuoma koo, amweni mundu ywakemelwa lina lyake Mathayo, ywa abile tama palo paakusanyle kodi. Niywembe kankokeya, “ngengame nenga” Ni ywembe atiyema ni kunkengama. ");
INSERT INTO ndg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ni Yesu patamile kulya chakulya cha kiloo nkati ya nyumba, baisi bakusanyile kodi bananyansima ni bandu baovu balya chakulya pamope ni Yesu ni anapunzi bake. ");
INSERT INTO ndg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nga Mafarisayo pamweni ago, kabakokeya anafunzi, “Mwanja namani mwalimu winu alye chakulya pamope ni bakusanya kodi ni bandu abaya?” ");
INSERT INTO ndg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu paayowine ago abayite, “Bandu bababile ni afya nzuri bapalike kwaa nng'anga, ila balo babile atamwe. ");
INSERT INTO ndg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yatikuwapasa muyende mkajipunze maana yake, “Mbendike rehema ni dhabihu kwaa.” kwa mana niisile, kwa balo babile ni haki kwaa kutubu, ila kwa balo babile ni sambi. ");
INSERT INTO ndg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nga anapunzi ba Yohana baisi kachake ni kukoya, “Mwanja namani twenga na mafarisayo twatabite, lakini anapunzi bako atabite kwaa?” ");
INSERT INTO ndg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kabakokeya, babaindikiya ndowa baweza huzunika wakati mwene ndowa abile pamope nakwe? Lakini lisoba lyaisa ambalo Ngwana ndowa alowa boka ngabalowa taba. ");
INSERT INTO ndg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ntopo mundu ywa beka ipande ya ngobo ya ayambe mu ngobo ya ayambe kwaa, kiraka salowa papwanilwa buka mu ngobo ni mwepopwaniko nkolo wa pita. ");
INSERT INTO ndg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ntopo bandu babayeya wembe mmabau mu chombo cha wembe kwele, bene bapanga, likengelya popwanika, wembe walowa penganika ni likengo lwalowa popwanika. Badala yake babeka wembe wayambe mulikengo lya ayambe ni vyoti vyabile vikoto. ");
INSERT INTO ndg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Palyo Yesu kabakokeya makowe ago, linga, afisa atiicha ngampingya magoti nnonge yake, ni ywembe kabaya, “Mwana wango atiwaa nambeyambe, lakini wiche unobii ni ywembe atama kai. ");
INSERT INTO ndg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu ngayema ni kunkengama ni anapunzi bake. ");
INSERT INTO ndg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Linga nwawa ywabile kapita mwai kwa kyaka komi niibele, atiicha papipi ni Yesu kakamwa mu'lipindo lya ngobo yake. ");
INSERT INTO ndg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwasababu atibaya, “Mana niikamwi ngobo yake, nalowa pona.” ");
INSERT INTO ndg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu kagalambuka kummakiya, “Mwinja, line na mwoyo, imani yako itekuponeya,” Ni muda wowo mwale atipona. ");
INSERT INTO ndg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu paikite mu'nyumba ya afisa, nembe abweni akombwa talumbeta ni kipenga sa bandu sakibile kikombwa likoti. ");
INSERT INTO ndg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ni ywembe kabaya, “Mbukange pani, mana nwawa awile kwaa ila atigonja, Lakini balo bandu batiheka ni kumgeya. ");
INSERT INTO ndg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na balo badu pabapitike panja, ni ywembe ajingii kuchumba ni kunkamwa luboko ni mwale ngayumuka. ");
INSERT INTO ndg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ni habari yee yatiyowanika nnema woti. ");
INSERT INTO ndg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nga Yesu kapeta buka palo, alalome abele ipofu bati kunkengama. Kabankema ni kunkokeya, “mwana wa Daudi, utuponyee” ");
INSERT INTO ndg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Palyo Yesu aikite panyumba balo ipofu baisi kachake, Yesu ngabakiya, “Mwendaaminiya panga nenda weza panga?” kabankokeya “Eloo, Ngwana.” ");
INSERT INTO ndg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nga Yesu kakamwa minyo yabe ni baya, “Naipangilwe nyoo kwinu kati mwaaminikwe” ");
INSERT INTO ndg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na minyo gabe kabagauywa, Yesu ngabakiya ni kuakokeya, “Lenga mundu ywoywote kana atange kuhusu likowe lee.” ");
INSERT INTO ndg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lakini bandu abele batibuka na tangaza habari yee sehemu yoti ya nnema. ");
INSERT INTO ndg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tubwe abo alalome abele pababile kabayenda kachabe, linga, mundu yumo bubu ywaabii na nchela banetike kwa Yesu. ");
INSERT INTO ndg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Na nchela pagamoi yolo mundu bubu ngatumbwa longela. Kipenga sa bandu satumbwa sangala ni baya, Ayee inawa kwaa pitya mu'Israel. ");
INSERT INTO ndg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lakini Mafarisayo babile kababya, “Kwa mpendo wa nchela, abenga masetani.” ");
INSERT INTO ndg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu atetindiya mjini mpaka mwijiji. Ni ywembe kayendelya pundisha mumasinagogi. Kahubiri Injili ni upwalume, na poneya atamwe ga kila aina ni udhaifu wa aina yoti. ");
INSERT INTO ndg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bandu pabamweni, nembe abeki kiya, mana batisumbuka mwoyo. Babile kati ngondolo yange nchungaji. ");
INSERT INTO ndg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ni ywembe kaakokeya anapunzi bake.”Mauno ni yananchima, ila apanga kachi ni achene. ");
INSERT INTO ndg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nga eyo munobe Ngwana wa mauno, linga apeleke apanga kachi mu'mauno gake.” ");
INSERT INTO ndg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu akemite anapunzi bake komi ni ibele pamope ni kwapeya ngupu kunani ya nsela achapu, kwabendya ni kwabenga kila aina ya malasi goti ni matamwe. ");
INSERT INTO ndg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Maina ga mitume komi ni ibele nga aga. Lya kwanza Simeoni(ywakemelwa Petro), ni Andrea kaka bake, Yakobo mwana wa Zebedayo, ni Yohana kaka bake: ");
INSERT INTO ndg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philipo, ni Bartelemayo, Thomaso, ni Mathayo, ntoza kodi, Yakobo mwana ba Alfayo, ni Tadeo, ");
INSERT INTO ndg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni mkananayo, ni Yuda Iskariote, ywa ansalitiye. ");
INSERT INTO ndg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Haba komi ni ibele Yesu atikubatuma. Ni ywembe atibaelekeza kabaya, “Kana muyende seemu yabatama amataifa ni kana muyjingii mumji wa asamalia. ");
INSERT INTO ndg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Badala yake, mwayendeli kwa ngondolo babaobite ba nyumba ya Israel. ");
INSERT INTO ndg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ni mana kamuyenda, muhubiri ni kubaya, upwalume wa Nnongo waisa.' ");
INSERT INTO ndg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mwaponye atamwe, mwayoye babawile, mwaponeye bene ukoma ni kugabenga nsela. Mupeyilwe bure, mwapeye bure. ");
INSERT INTO ndg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kana mtole dhahabu, almasi, ao shaba mu'pochi yinu. ");
INSERT INTO ndg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kana mwaputwe mpuko nkati ya safari yinu, ao ngobo ya ngalabwa, ilatu au fimbo, kwa sababu mpanga kazi apalikwa alepelwe. ");
INSERT INTO ndg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mji wowoti ao ijijicha mujingii, mumpale ywa aminike mtame palo kachake pamwapala buka. ");
INSERT INTO ndg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ni nyumba yamwalowa jingya mwailobi, ");
INSERT INTO ndg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mana itei nyumba yastahili, amani yinu ibaki palyo, lakini kati nyumba istahili kwaa, amani yinu imuyangani ni mwenga mwabuka. ");
INSERT INTO ndg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na kwa balo babakotoka kumpokya mwenga na kulipekaniya kwa likowe lino, mana kamubuka munyumba au pamji woo, muikung'unde hata vumbi ya kulwayo yinu. ");
INSERT INTO ndg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kweli nenda kuakokeya, bora mwabapumiliye bandu ba Sodoma na Gomora lisoba lya ukumilwa kuliko nnema woo. ");
INSERT INTO ndg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Linga niatuma kati ngondolo nkati ya mabwa mwitu, nga eyo mube mwamutangite na mwapolw kati ngambo, namube apole kati ngunda. ");
INSERT INTO ndg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mube aangalifu ni bandu, balowa kushitakya ni balowa kumkombwa mu'masinagogi. ");
INSERT INTO ndg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ni mwalowa potwa nnonge ya akolo ni afalme kwaajili yango, kati ashuhuda kwabe ni mataifa. ");
INSERT INTO ndg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pabalowa kunshutumu, kana mube ni mashaka kinamani chabakokeya, kwa kuwa kilebe sa longela mwalowa pewa wakati woo. ");
INSERT INTO ndg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwa kuwa mwenga kwaa mwawalowa koya, ila Roho ba Tate binu ywabile longela nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Alongo balowa bulangana, tate ni mwana wake. Bana balowa inuka kunani ya azazi bao, ni kwabulaga. ");
INSERT INTO ndg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ni mwenga mwalowa chukilwa na kila mundu kwamwanja ya lina lyango. Lakini ywoywoti ywalowa pumuliya mpaka mwisho mundu ywo alowa okoka. ");
INSERT INTO ndg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pabalowa kuntesa pamuji goo mwatili wenge, kweli nenda kuakokeya, mwaiyomwa kwa milema ya Israel bila mwana wa Adamu buya. ");
INSERT INTO ndg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ilengani kwaa mwanapunzi kana abe nkolo kuliko mwalimu wake, wala mmanda ywabile kunani ya Ngwana wake. ");
INSERT INTO ndg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mana itei bankemite Ngwana wa nyumba Belzabuli, mwenga si muno balowa kuwageya ni nyumba yake! ");
INSERT INTO ndg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","nga nyo bai kana muyogope, mana ntopo chachakotoka ba chapala, ni ntopo chabaijile sasakotoka bonekana. ");
INSERT INTO ndg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chalo chaniakokeya mulubendo, mukibaye pabweya, ni chalo chamukiyowa mbolembole mmasikio yinu, mwakitanga kunani ya nyumba. ");
INSERT INTO ndg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kana muyogope balo bababulaga yega lakini baweza kwa bulaga roho. Ila, mwayogope yolo ywaweza bulaga yega ni roho kwipeleka kuzimu. ");
INSERT INTO ndg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Je kasuku abele bapemeya kwa senti njene? Hata nyoo ntopo ywaweza tomboka pae bila Tate binu kufahamu. ");
INSERT INTO ndg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lakini ata nywili yimo ibalangilwe. ");
INSERT INTO ndg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kana mube ni mashaka, mana mube ni thamani kuliko kasuku bananchima. ");
INSERT INTO ndg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kwa eyo, kila mundu ywalowa kuniyeketya nnonge ya bandu, na nee nalowa kun'yetya nnonge ya Tate bango ywabile kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na ywangana nnonge ya bandu, na nee nalowa kunkana nnonge ya Tate bango ywabile kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kana muwase panga niletike amani mukilambo, ila lipanga. ");
INSERT INTO ndg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Maana niisi kumpanga mundu bayumanie ni akina tate bake, ni mwenye na mao bake, ni mkamwana ni mao bake nchengowe. ");
INSERT INTO ndg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ni adui ywa mundu ywa nyumba yake. ");
INSERT INTO ndg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Na ywalowa kuwapenda mao ni tate muno kuliko nenga abwaika kwaa na ywapenda mwana wake nnalome au mwana wake nnwawa ne aywo abwaka kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ywembe ywa kotoka putwa msalaba wake ni kunikengama abwaika kwaa. Ywa lowapala maisha agaopeya. ");
INSERT INTO ndg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Lakini ywalowa abeya maisha kwaajili yango alowa kugapata. ");
INSERT INTO ndg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ywalowa kunikaribisha mwenga anikaribisha nenga, ni ywanikaribisha nenga akaribisha jwembe ywaniletike nenga. ");
INSERT INTO ndg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ni ywembe ywalowa kunkaribisha nabii kwa mwanja nabii alowa pokya sawabu ya nabii. Ni ywoywoti ywankaribisha mwene haki kwa mwanja mwene haki alowa pata sawabu ya mundu wa haki. ");
INSERT INTO ndg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ywoyoti ywalowa kumpeya kati bana baa, angalau kikombe cha mache go nywaa maimu, kwa mwanja anapunzi bango, kweli nenda kuwamakiya, ywembe aweza kwa kosa kwandela yoyoti sawabu yake.” ");
INSERT INTO ndg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Baada ya Yesu yomwa kwaeleza anapunzi bake komi ni ibele atibuka pae yopundisha ni hubiri munuji yabe. ");
INSERT INTO ndg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ni Yohana atabilwe payowine mwapangage Kristo, atumite banapunzi bake, ");
INSERT INTO ndg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bakannokiya, “Wenga nga ywaapala icha, au kwi ni ywenge ywatunnenda?” ");
INSERT INTO ndg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kaayagwa ni kukoya, “Muyende kum'bakiya Yohana gamgabona ni galo gamugayowa. ");
INSERT INTO ndg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ipofu bandalola, iwete banda yenda, akoma banda pona, babakotokage yowa benda yowa kae, bandu babawile benda yoka kae, ni anyonge bahubiyilwe likowe linanoga. ");
INSERT INTO ndg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ni abarikiwa ywa kotoka kuniboniya masaka. ");
INSERT INTO ndg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ni bandu pababoi, Yesu ngatumbwa longela ni bandu kuhusu Yohana, “Kinamani chamwaiyei kukilinga kupongote mbonga ya yalendemiye linyei? ");
INSERT INTO ndg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lakini kinamani mwauei kukibona mundu ywaweti mangobo laini? Kwakweli, balo babawala ngobo laini batama munyumba, ni zaidi ya nabii. ");
INSERT INTO ndg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lakini mwatiboka lolekeya namani nabii? nga nyo nendakuwamakiya, na zaidi ya nabii. ");
INSERT INTO ndg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ayoo nga yolo ywaandikilwe, linga nitume talisi wango nnonge ya kuminyo yako, ywembe ngalima ndela yake. ");
INSERT INTO ndg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nenga niakokiya ukweli, kati ya bababelekwi ni nwawa btopo ywabile nkoto kuliko Yohana Mbatizaji. Lakini ywembe nchini mu utawala wa kumaunde nga nkolo kuliko ywembe. ");
INSERT INTO ndg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Buka masoba ga Yohana mbatizaji mpaka leno utawala wa kumaunde upatikana kwa ngupu ni bandu babile ni ngupu, batola kwa ngupu. ");
INSERT INTO ndg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwa mwanja manabii ni saliya, batitabiri mpaka wakati wa Yohana. ");
INSERT INTO ndg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni mana itei mpala yeketya, yembe nga Eliya ywa palaisa. ");
INSERT INTO ndg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ywa abi ni makutu gayowa na ayowe. ");
INSERT INTO ndg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nikilinganishe ni namani kibeleki cheno? mfano wa bana babang'anda sokoni, babatama na kemelyana. ");
INSERT INTO ndg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ni kukoya, 'Twakombwi zomarimwainike kwaa, Twatilombola, mwaleikwaa.' ");
INSERT INTO ndg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Maana Yohana atiicha bila lya nkate wala nywaa divai, ni mubayage,'Aii na nchela.' ");
INSERT INTO ndg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa Adamu atiisa kalya no ywaa na mumaya ni kumila na nepi, mbwiga labe akusanga ushuru na bene sambii, lakini hekima itanganikwa kwa matendo gake.” ");
INSERT INTO ndg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu atumbwi kuakalipiya miji yayabile miyendo yake michapu, mana babile bado tubu. ");
INSERT INTO ndg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ole wako, Kolazini, Ole wake Bethesaida kati matendo makolo gakapangika Tiro i Sidoni galo gagapangike pano, bapale tubu zamani kwo wala mabuniya na pakala lingu. ");
INSERT INTO ndg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lakini kwaloba bana pumulia Tiro na Sidoni masoba gahukumu kuliko kasabe. ");
INSERT INTO ndg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Wenga Kapernaum, ukita tondobelwa mpaka kumaunde? Ntopo walowa ulujilwa mpaka pai kuzimu. Kati kwa Sodoma kulwe pangika makowe makolo, kati mwagapangilwe kachabe, ilwepanga mpaka leno. ");
INSERT INTO ndg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ila nibaya, kachako yalowa baa rahisi kwa nnema wa Sodoma pumulia lisoba lya hukumu kuliko wenga. ");
INSERT INTO ndg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Muda woo yesu atibaya, nenda kulumba, mwenga mwa Tate, Ngwana wa kumaunde ni nnema, kwa mwanja waijite makowe gaa bene hekima na akili, na kwayogolya bange lunda, kati bana achunu. ");
INSERT INTO ndg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tate kwa kuwa mwapendesilwe nyoo pa minyo yinu. ");
INSERT INTO ndg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Makowe goti galekilwe kachango buka kwa Tate. Nantopo ywantangite mwana ila Tate, na ntopo ywantangite Tate ila mwana na ywoywoti ywampendi mwana kunnagilya. ");
INSERT INTO ndg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Muiche kwango, mwenga mwa boti mwamuangaika na mwamulemewa na igombo inatopa, ni nenga nipala mpomoli. ");
INSERT INTO ndg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mube ni akili ni mwiyegane buka kachango, mana nibii ni lwongo na nampole wa mwoyo ni mwalowa pata pumulya na nafsi yinu. ");
INSERT INTO ndg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwa mana nila yango ibii laini ni igombo yango nj'oyou. ");
INSERT INTO ndg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lichoba lya sabato Yesu kapeta karibu ni mung'unda, anapunzi bake babile ni njala gabatekwa makasi no lyaa. ");
INSERT INTO ndg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lakini Mafarisayo pabagabweni goo, nga bammakiya Yesu aalagiye anapunzi bake baitekwana saliya bapanga lsoba lyange lusilwa lisoba lya Sabato.” ");
INSERT INTO ndg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lakini Yesu ngaabakiya, “Munasoma kwa Daudi mwapangite wakati wabile na njala, bamope na bandu babile pamope nabo? ");
INSERT INTO ndg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mwayingii nyumba ya Nnongo no lyaa mikate ya madhabahu, na yabile kwaa alali kachake kwi na balo babile nabo, ila alali kwaa makuhani? ");
INSERT INTO ndg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bado munasoma kwa kuhusu saliya, panga lisoba luya sabato Makuhani gati ya hekalu kwichapuya sabato, lakini ntopo ywa sitakiya? ");
INSERT INTO ndg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lakini nilongela kachinu panga ywabile nkolo kuliko hekalu abile pano. ");
INSERT INTO ndg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","taanga ayee ina maana gani, nipala loba na sio sadaka, mpele kwa hukumu kwa benge makosa. ");
INSERT INTO ndg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mana mwana wa Adamu nga Ngwana wa sabato. ");
INSERT INTO ndg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu gabuka palo gayenda kuhekalu lyabe, linga kwabi na mundu mlemafu wa luboko Mafarisayo ngaba naluya Yesu, kababaya, ");
INSERT INTO ndg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","“Je, halali kumponeya lisoba lya sabato?”Lenga bapate kusitakiwa kwopanga sambi. ");
INSERT INTO ndg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu kaakokiya, “Nyai kato yinu, abile ni ngondolo yumo, ni aywoo ngondolo atumbuki mulembwa lisoba lya sabato, ywakotoka kunapwa? ");
INSERT INTO ndg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Je, kilebe chaako cha thamani, bora kunopwa mundu kuliko ngondolo! kwa eyo alali bai panga mema lisoba lya sabato.” ");
INSERT INTO ndg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu kankokeya ywa mundu, “ngalowa luboko lwako”Ngalugoloya, ngalupona, kati lololwenge. ");
INSERT INTO ndg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lakini Mafarisayo ngabapita panja kabapanga ndela ya kumulaga. ");
INSERT INTO ndg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu patangite mpango woo atiboka. Bandu banyansima batikunkengama, nga aponea bote. ");
INSERT INTO ndg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Abakiye kana babakiye bandu akanatanganikilwa kwa bananchima, ");
INSERT INTO ndg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","panga ilimi yolo kweli, yabaite nabii Isaya, kaba ");
INSERT INTO ndg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Linga, mtumishi wango ywanichewile, ywanimpendile, kwa ywembe mwoyo wango utikumpenda. Nalowa beka Roho yango kunani yake, na alowa tangaza hukumu kwa mataifa. ");
INSERT INTO ndg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aangaika kwaa wala lela kwa ngupu; aimiya kwa utambi wa upiya lyoi, mpaka pateta hukumu no shida. ");
INSERT INTO ndg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kana auna tete lyalichubulilwa, kana aime tambi yoyoti wauluka lioi. ");
INSERT INTO ndg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na mataifa balowa bana ujasili kwa lina lyake. ");
INSERT INTO ndg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mundu pilani ngaminya na bubu, ywalobi moka banetike kwa Yesu. Ngamponiye, pamope ni mundu bubu pona na kipofu bona; ");
INSERT INTO ndg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bandu boti batisangala no baya, iweza wezekana mundu yoo mwana wa Daudi?” ");
INSERT INTO ndg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lakini Mafarisayo pabayowine husu maujiza agoo, batibaya, “Ayo mundu aboya kwa masetani kwa ngupu yake mwene ila kwa Baheburi, mpendo wa masetani. ");
INSERT INTO ndg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Lakini Yesu agatangite gabaweza na kwabakiya, “Kila utawala wautalanganike wene walowa alabika kwaa, na kila nyumba yayalowa lalanganika bene yayema kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mana itei nchela alowa kumoya nchela, inda kipenga muakili yake mwene. ");
INSERT INTO ndg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kwa kitiwi utawala wake walowa yema? Na mana itei niboya nchelakwa ngupu ya Belizabuli, babafata mwenga babuya nchela kwa ndela ya kele? kwa ndela ya balowa ba akimu winu. ");
INSERT INTO ndg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na mana kanibuya nchela kwa ndela ya Roho wa Nnongo, bai utawala wa Nnongo uichile kachinu. ");
INSERT INTO ndg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ni aweza buri yingwa nyumba ya mwene ngupu najiba, bila kutaba mwene ngufu wete? Ngaweza yiba ilebe yake buka nkati ya nyumba. ");
INSERT INTO ndg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ywoywoti ywakotwike baa nanee enda kunitaukya, na ywa kutoka kumba pamope na nee enda palagana. ");
INSERT INTO ndg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwa eyo nibaya kachinu, kila sambi na kufulu bandu alowa kwa samiya, lakini kukufulu Roho Mtakatifu asamiya kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na ywoywoti ywalowa baya likowe kinyume sa mwana wa Adamu, alowa kusamiwa. Lakini ywolongela kinchogo sa Roho Mtakatifu aywo basamwa kwaa, kwa utawala ngo wala wauicha. ");
INSERT INTO ndg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ao upange mkongo panga unanoga na litundu lyake linanoga, kwasababu nkonga utanganikwa mutunda gake. ");
INSERT INTO ndg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwenga, wa lukolo lwa ng'ambo, mwenga mwabaya muweza longela makowe gananoga? Kwasababu mikano ilongela buka mumwoyo. ");
INSERT INTO ndg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu nzuri muakiba inanoga ya mwoyo wake gapita gananoga, na mundu mwou mu'akiba ou ya mwoyo wake, ipita kilebe kinayangata. ");
INSERT INTO ndg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nenda kuwamakiya panga lisoba lya ukumu bandu balowapiya hesabu ya kila likowe lyange mana lyabalongelage. ");
INSERT INTO ndg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwa kuwa kwa makowe gako walowa balangilwa haki na kwa makowe gako walowa hukumilwa.” ");
INSERT INTO ndg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mwisho baazi ya aandishi ni Mafarisayo ngaban'yangwa Yesu kababaya, “Mwalimu twapendi kubona ishara kachako.” ");
INSERT INTO ndg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lakini Yesu atikwayangwa ni kuakokeya, “kibelekwi kinoite kwaa ni sa umalaya kipala ishara lakini ntopo ishara yailwapila kachako ila yulo ya nabii Yona. ");
INSERT INTO ndg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kati nabii Yona mwaatami mundumbo lya omba nkolo kwa masoba gatatu kilo ni mutwekati, nga nyoo mwana wa Adam alowa tama nkati ya mwoyo wa bwee kwa muda wa masoba gatatu kilo ni mutwekati. ");
INSERT INTO ndg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bandu baninawi balowa yema nnonge ya hukumu pamope ni ubelekwi wa bandu aba na balowa hukumilwa kwasababu batiloba kwa makaburi ga Yona, linga mundu nkolo kuliko Yona abile pano. ");
INSERT INTO ndg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Malkia wa kusini alowa katuka pa hukumu pamope ni bandu ba mmelekwoogu na kwa hukumu. Aisi boka mwiso wa dunia icha pekaniya hekima ya Selemani, na linga, mundu fulani nkolo kuliko Selemani abile pano. ");
INSERT INTO ndg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nchela pamoka mundu, apeta pange mmache kapala pompomolya, ila mana akotwike kupabona. ");
INSERT INTO ndg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mwisho baya mbala buyangana kunyumba yango kwa mboi. mana aikoli yumo nyumba isafishilwe na ibi tayari. ");
INSERT INTO ndg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Alowa kelebuka na kwaleta benge roho njapu saba bababile abaya sana kuliko ywembe isa tama bote palo. Na hali yake baa mbaya kuliko ya mwanzo. Ngamwalowa panga kwa ubelekwi wono mwou. ");
INSERT INTO ndg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wakati Yesu kalongela umati linga mabake na akinanunabe bayemi panja, kabampala.” ");
INSERT INTO ndg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mundu yumo atikummakiya, “linga maobako na akinanunango bayemi panja, bapala longela na wenga.” ");
INSERT INTO ndg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lakini Yesu kayangwa ni kuakokeya ywaammakiye mao bango nyai? Ni anuna bango aki'nyai? ");
INSERT INTO ndg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nga alangwa anapunzi bake nobaya, “Linga, aba nga mao ni anuna bango! ");
INSERT INTO ndg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mana ywoywoti ywagapanga gabapendi Tate bango ywaabile kumaunde, mundu ywo nga nongo wango mno bwango na mao bango.” ");
INSERT INTO ndg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kwa masoba ago Yesu atiboka kaya ni tama bwega ya bahari. ");
INSERT INTO ndg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kipenga sabandu satikusanyika kwa kutindiya, ajingi kati ya ngalaba natama nkati yake likundi lyoti lyayema kwiye ya bahari. ");
INSERT INTO ndg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Boka po Yesu alonngela makowe gananchima kwa mifano, Atibaya, linga, mpandi ayei pana. ");
INSERT INTO ndg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wakati kapanda mbeyu yenge yatumbuki bwega ywa ndela na iyuni bati kuichonywa. ");
INSERT INTO ndg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mbeyu yenge yatomboki paliwe, napembe ando waichene, nayabalike lakini kwo kosekana ukando wakoikwa. ");
INSERT INTO ndg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nalimu palubai watiyoma mana yabile kwa na ndandai no yoma. ");
INSERT INTO ndg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu yenge yatomboki kumimimwa. Mikongo yene mimimwa yatikolaa na kwiingilya. ");
INSERT INTO ndg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mbeyu yenge yatomboki paukando wananoga na pambika matunda, yenge mia jomo, yenge sitini na yenge thelathini. ");
INSERT INTO ndg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ywa abii ni makutu ayowe. ");
INSERT INTO ndg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anapunzi bake bateisa na kummakiya Yesu, “mwanja namani ulongela na kipenga sa bandu kwa mifano?” ");
INSERT INTO ndg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kayangwa ni kuakokeya, “Mupeyilwe upendeleo wo tanga siri ya upwalume wa kumaunde, ila kachabe banapeyelwa kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lakini ywoywoti ywabile nacho, ywembe alowa yongekelwa muno, na alowa pata faida ngolo, ila ywaabile kwaa kilebe hata chelo kichunu chaabile nacho alowa pokonyolwa. ");
INSERT INTO ndg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kwa eyo nilongela nabo kwa mifano kwa mwanja kwale babone, kana baibone kweli. Na ingawa bayowa kana bayuwe wala tanga. ");
INSERT INTO ndg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Unabii wa Isaka utimile kachabe, ngolo wa baite “Yowa mwalowa yowa, lakini mwaelewa kwa, bona mwalowa bona lakini mwatanga kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Na mumimwoyo ya bandu ibii mulubendo nonopa yowa na bawiliwiti minyo yabe, kana baweze bona kwaa minyo yabe, ao yowa kwa makutu gabe au tanga kwa mioyo yabe, bapele kunigalambukwa kae, na mbele kwaponea.' ");
INSERT INTO ndg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ila minyo ginu gatibalikilwa, mwaya genda bona, na makutu ginu mwanja genda yowa. ");
INSERT INTO ndg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kweli nenda kuamakiya manabii bananchima na bandu bene haki babile na hamu ya kugabona makowe galo gamugabona, na bawezike kwaa kugabona. Batitamaniya kugayowa makowe galo gamugayowa bagayowine kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tubwe mupekani mfano wa mpandi. ");
INSERT INTO ndg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wakati ywoyoti ywalowa yowa likowe lya utawala na kana atitange, nga nchela icha kukitola chakiyomwile pandikwa mumwoyo nkati wake. Hayee nga mbeyu yaipandile mbwenga ya ndela. ");
INSERT INTO ndg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ywembe ywapandike mumaliwe nga yolo ywaliyowine likowe na kulipokya upesi kwo pulaika. ");
INSERT INTO ndg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bado ntopo ndandai nkati yake, nopumuliya kwa muda mwipi matatizo ao mateso pagapita kwa mwanza likowe kwikobala ghafla. ");
INSERT INTO ndg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ywa pandikwe mumimwa, ayu nga yolo ywaliyowine likowe lakini maangaiko ga dunia no kongana ni utajiri kulingilya lelo likowe lya kana pambika matunda. ");
INSERT INTO ndg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ywa apandilwe pa ukando unanoga, nga yolo ywaliyowine likowe ni kulitanga. Hyo nga ywapambike matunda no yendelya pambika limo zaidi ya mara mia, yenge sitini, yenge thelathini.” ");
INSERT INTO ndg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu apei mfano wenge, kabaya. Utawala wa kumaunde ulandanishwe ni mundu jwapandike mbeyu inanoga mung'unda wake. ");
INSERT INTO ndg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lakini bandu pabapabagonjike, mbii wake nembe atiicha panda manyei nkati yangano ngakabuka kachake. ");
INSERT INTO ndg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Baadae ngano paibalike no pweka, na manyei nembe gatipweka nagembe. ");
INSERT INTO ndg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na atumishi ba mwene nng'unda batiicha nakummakiya, Ngwana, hupandike kwa mbeyu inanoga mung'unda wako? Ibikitiwi kwi na manyei? ");
INSERT INTO ndg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nga bakiya, mbii ngapangite nyoo, Atumishi gabammakiya, “Tugatupwe” ");
INSERT INTO ndg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mwene ng'unda ngabaya, “hata, pamwalowa tupwa manyei mwalowa tupwa ni ngano. ");
INSERT INTO ndg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mugaleke gakue pamope mpaka wakati wouna, wakati wo una nalowa kwabakiya babauna, “Wete mugatupwe manyei mugatabe makenda makenda ni kugayocha mwoto, na mwikusanyi ngano mulighala lyango. ");
INSERT INTO ndg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Boka po Yesu abakiye mfano wenge. “Upwalume wa kumaunde ulandine na mbeyu ndebele nayo mundu atikwitola na kwipamda mung'unda wake. ");
INSERT INTO ndg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbeyu ye njene sana kuliko mbeyu yenge yoti. Lakini mana ikoi lopokwa kulliko yoti mubustani, pana kati nkongo, mpaka kiyuni chenge iyumba mundambe yake. ");
INSERT INTO ndg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nga kaabakiya mfano wenge kai, “Upwalume wa kumaunde ubi kati mandibale ngalo gatweti mnwawa no yangabana ipemo itatu kwa bwembe mpaka ilole. ");
INSERT INTO ndg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aga goti Yesu atiabakiya nkati ya kipenga sa bandu petya mifano. Na bila mifano abatei kwa kilebe chochote kachabe. ");
INSERT INTO ndg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ayee ywabi na mana panga gote gabalongei manabii gaweze timya, palyo pabaite, naliwa yuwa nkano wango kwa mifano. Nalowa longela makowe galo iyilwe boka mumisingi ya dunia. ");
INSERT INTO ndg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mwisho Yesu kakileka sa kipenga sa bandu buya kaya, Anapunzi bake batikunyendelya ni kummakiya, “Utuyongoli mfano wa manyei ya kumigunda.” ");
INSERT INTO ndg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kayangwa ni ukoya, “Ywapanda mbeyu inanoga nga mwana wa Adamu. ");
INSERT INTO ndg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mng'unda nga dunia, mbeyu inanoga, aba nga bana ba utawala, Na manyei nga bana ba yolo nnau na kibii sakipandike nchela. ");
INSERT INTO ndg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na mauno ni mwisho wa dunia, babauna nga malaika. ");
INSERT INTO ndg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kati mwagabile kusanyilwa ni yoselwa mwoto, Nyo ngawabaa mwisho wa dunia. ");
INSERT INTO ndg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa Adamu alowa kwatuma malaika bake, ni kubaleta mu upwalume wake ni makowe gati gagasababilwe ni sambi ni balo babapanga makosa. ");
INSERT INTO ndg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Balowa kwataikwa boti mulitanuli lya mwoto, na akwo kwalowa bana kilelo na tauna mino. ");
INSERT INTO ndg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na bandu bene haki bamelemetya, kati lisoba mu utawala wa Tate bake. Ywembe ywabii na makutu ni ayowe. ");
INSERT INTO ndg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Upwalume wa kumaunde ubi kati akiba yabaiyembi mung'unda. Mundu atikuibona na kwiiya. Katika pulaika kwake ngayende pemeya kila cha bile nacho na kuupema ng'unda. ");
INSERT INTO ndg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kae Upwalume wa kumaunde ubi kati mundu jwapanga biashara ywapala madini gene thamani. ");
INSERT INTO ndg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Paibweni yelo yene thamani, ayei bene ya kila kilebe abile nacho ni akapemia. ");
INSERT INTO ndg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Upwalume wa kumaunde kati lupelele lwalubile kati ya bahari, no panga lukumba iumbe ya kila aina. ");
INSERT INTO ndg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Palutweti lupelele baluhuti bwega. mwisho batanganite pae ngabakulya ilebe yoti kati ya chombo lakini yango thamani baitaikuli kutalu. ");
INSERT INTO ndg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Yalowa baa nyonyonyo wakati wa mwisho wa dunia malaika balowa icha na kwabangana bandu abaya boka nkati ya bandu azuri. ");
INSERT INTO ndg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ni kwataikwa mulitanuli lya mwoto, kwalowabana ilelo no saga mino. ");
INSERT INTO ndg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mutangite makowe goti aga? Anapunzi kabayangwa, “Elo”, ");
INSERT INTO ndg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Boka po Yesu kabakokeya, “Kila mwandishi ywabile mwanapunzi wango wa utawala alandana ni mwene nyumba jwapiya mu'akiba yake ilebe yaayambe ni ya zamani.' ");
INSERT INTO ndg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ikawa Yesu payomwoi mifano eyo yoti, atiboka pandupo. ");
INSERT INTO ndg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ni Yesu paikite pa nkoa wake apundisha bandu mu'sinagogi. Mwisho wake bende shangala no baya, “Kwako kwagapatike mapundisho gaa miujiza yee? ");
INSERT INTO ndg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mundu yoo nga yolo mwana wa selemala? Mariamu nga mao bake kwaa? nongo bake kwaa Yakobo, Yusuph, Simoni ni Yuda? ");
INSERT INTO ndg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ni alombo bake tubi nabo papano? Bai mundu yolo apeilwe kwako aga goti?” ");
INSERT INTO ndg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Batichukya. Lakini Yesu atikuakokeya, “Nabii akosa kwaa heshima isipo kuwa kachake na panema wake. ");
INSERT INTO ndg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Apangite kwaa miujiza yananchima maana bamwamini kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Muda woo Herode ayowine habari kuhusu Yesu. ");
INSERT INTO ndg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Atikuakokeya atumishi bake, “Ayoo nga Yohana mbatizaji atiyoka boka mukiwo. Na yelo ngupu ibii kunani yake.” ");
INSERT INTO ndg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Maana Herode abile amoywite Yohana atabite na kuntaikwa muligereza kwa mwaa ya Herodia, nnyumbowe Filipo kaka bake. ");
INSERT INTO ndg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwa kuwa Yohana atikuakokeya, “Alali kwaa kuntola ywembe panga nyumbowe.” ");
INSERT INTO ndg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herode apala kumulaga lakini ayogwipe bandu kwa mwanja bamweni Yohana panga nabii. ");
INSERT INTO ndg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lakini lisoba lya abelekwile Herode paliikite mwanja wa Herode atiina pakatikati ya bandu ni kumpulaisa Herode. ");
INSERT INTO ndg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kwa yangwa ahadi yake kwo lapa panga alowa kumpeya chochote chalowa luba. ");
INSERT INTO ndg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Baada ya kushauriwa ni mao bake, atibaya, “Nenga unipei ntwe wa Yohana mbatizaji mukikombe.” ");
INSERT INTO ndg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mpwalume atisikitika kwa chalobite mwanja wake, lakini kwa kilapo chake, na mwanja bote babanile pachakulya pamope abaite panga ipangike. ");
INSERT INTO ndg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ayei tolelwa Yohana mbatizaji muligereza. ");
INSERT INTO ndg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Lenga akatilwe ntwe wake ni kubeka musinia ni kumpeya yolo mwanja na kupeleka kwa mao bake. ");
INSERT INTO ndg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ni anapunzi bake batiicha kupotwa yeya yake ni yendya kusika, baadaye bayei kummakiya Yesu. ");
INSERT INTO ndg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ni ywembe Yesu payowine goo, ngaitenga buka pandu palo ngayenda nkati ya mashua kayende pandu paki yake. Ni kipenga sabandu pabatangite paile batekunkengama kwa magolo buka mjini. ");
INSERT INTO ndg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mwisho Yesu atiicha nnonge yabe abweni kipenga kikolo sa bandu. Aboni huruma ni kuwaponea matamwe yabe. ");
INSERT INTO ndg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Paiikite kitamunyo anapunzi bake batiisa no baya, “Yeno nga sehemu ya lijangwa, na lisoba lipitike. Ukipei ruhusa kipenga cheno cha bandu bayende kijijini bakapemi chakulya. ");
INSERT INTO ndg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ngaabakiya, “Ntopo haja yojenda kachake mwapei mwenga chakulya.” ");
INSERT INTO ndg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ngaammakiya, “Pano tubile ni mikate mitano ni omba abele bai.” ");
INSERT INTO ndg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu ngabaya, “Mwilete kachangu.” ");
INSERT INTO ndg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nga Yesu kaabakiya mwabakiye bandu batame pae pamanyei. Katola mikate mitano ni omba abele. Kalinga kunani kumaunde, ngabariki no metwa na mikate ngaapeya anapunzi bake. Anapunzi ngabapeya kipenga sa bandu. ");
INSERT INTO ndg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ngabalya bote noyukuta. Boka po ngabatondwa ipande yoti ya chakulya na batweliye itondo komi ni ibele. ");
INSERT INTO ndg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Balo babalile karibu alalume elfu tano bila kwa balanga alwawa ni bana. ");
INSERT INTO ndg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ngaabakiya anapunzi bayingi mumashua, wakati woo ywembe nga alanga kipenga kaboka kachake. ");
INSERT INTO ndg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Baada ya kwalaga umati yenda kachake, aobwike kukitombe yoloba kichake. Wakati pachabile kitamunyo abile kwo kichake. ");
INSERT INTO ndg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lakini muda woo ngalaba yabile pakatikati ya bahari kebembeya kwa mwanja ya mawimbi, kwani mbonga yabi ngale. ");
INSERT INTO ndg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kilo cha kungoko Yesu abi karibu naika, katyanga nnani ya mache. ");
INSERT INTO ndg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Anapunzi bake pabamweniu katyanga kunani ya mache, batiyogopa no baya, “Kinamani” ngabakemelya kwo yogopa. ");
INSERT INTO ndg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu ngaabakiya mara jimo, ngabaya, “Mwikaze! nganenga! Kana muyogope.” ");
INSERT INTO ndg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petro kannyangwa ni kummakiya, “Ngwana mana itei wenga, uniruhusu niiche kwoo nnani ya mache.” ");
INSERT INTO ndg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu kannyangwa ni kummakiya, “Icha.” Petro ngapita nkati ya mashua nga tyanga nnani ya mache kuyenda kwa Yesu. ");
INSERT INTO ndg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lakini Petro pakayabweni mawimbi, atiyogopa, ngatubwa zama pae, ngapakema, “Ngwana, unilopwe.” ");
INSERT INTO ndg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Upesi Yesu ngaatabwa luboko lwake nga ntondobeya Petro, ni kummakiya, “Wenga imani yako njene. Mwanja namani wabi ni masaka?” ");
INSERT INTO ndg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na Yesu ni Petro bayingi mungalaba, ni mbonga ya kotwikupuma. ");
INSERT INTO ndg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Anapunzi mungalaba ngabamwabudu Yesu no baya, “Kweli wenga wa mwana wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bapayomwile loka, baikite pannema wa Genesareti. ");
INSERT INTO ndg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ni bandu pa eneo lyoo pabatangite Yesu, batibakiyana kila sehemu ya bwega ni kwaleta atamwe woti. ");
INSERT INTO ndg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Batikunnoba muno kuwa bakamwe ngobo yake, ni bengi balo bakamwi ngobo yake baponyike matamwe yabe. ");
INSERT INTO ndg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nga mafarisayo ni baandishi baisi kwa Yesu buka Yerusalemu, no baya, ");
INSERT INTO ndg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mwanja namani anapunzi bako babomwa makowe ga apendo? Mana bauluwa kwa maboko gabe mana kaba lyaa chakulya.” ");
INSERT INTO ndg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kaayangwa ni kwabakiya, “Ni mwenga namani mwibomwa saliya ya Ngwana kwa sababu ya apendo winu? ");
INSERT INTO ndg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mana Nnongo atibaya,'Mwaeshimu tate bako ni mao bako, ni ywalongela ngananyata kwa tate bako ni mao bako, alowa waa.' ");
INSERT INTO ndg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lakini mwenga mubaya,'Kila ywaammakiya tate bake ni mao bake,'”Kila msaada walowa kupata uboka kachango sayeno zawadi buka kwa Nnongo,'” ");
INSERT INTO ndg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Mundu yo ntopo sababu ya kwamuishimu tate bake. Kwa aina yee mwitekwaniye likowe lya Nnongo kwa sababu ya masilai ginu. ");
INSERT INTO ndg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwe mwalau, kweli kati Isaya mwabaite husu mwenga pabaite, ");
INSERT INTO ndg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Bandu baa baniheshimu kwaa nenga kwa mikano yabe, lakini mioyo yabe ibii kutalu na nee. ");
INSERT INTO ndg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Baniloba bure kwa mwanja bapundisha mapundisho gabalangi bandu.'” ");
INSERT INTO ndg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nga likema likundi ni kwabakiya, “mubekani ni mutange- ");
INSERT INTO ndg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ntopo klebe chakiyingya munkano wa mundu chakinyeya mundu uchapu. Ila chakipita munkano, hacho gakinyenya mundu uchapu.” ");
INSERT INTO ndg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nga anapunzi bake ngabayendelya no baya, ngabalongela ni Yesu, “Je!, utangite mafarisayo pabayowine lelo likowe litikwalumiya?” ");
INSERT INTO ndg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu kayangwa ni kwabakiya, “Kila mtombo wa kotwike panda lalebango ba mbinguni aupandike kwaa walowa luputwa. ");
INSERT INTO ndg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mwaleke kichabe, bembe viongozi bange minyo, Ni mundu ngeminyo mana kampeka ngeminyo aupandike nyine bote abele batumbukya mulembwa.” ");
INSERT INTO ndg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro kayangwa ni kummakiya Yesu, “Utubakiye twenga maana ya mfano goo. ");
INSERT INTO ndg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kayangwa, “Na mwenga mnelewite kwaa?” ");
INSERT INTO ndg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mwenga mwabona kwaa kila chakiyenda mukano kipetya nndumbo na yenda kulindi? ");
INSERT INTO ndg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lakini ilebe yoti yaipita mukano ipita nkati ya mwoyo. Ngainyenya uchapu. ");
INSERT INTO ndg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwa mwanja mumwoyo ipita mawazo mabaya, bulaga, umalaya, usalati, bwii, umbeya, ubocho ni matukangano. ");
INSERT INTO ndg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aga nga makowe gaganyenya mundu uchapu lakini lya bila uluwa maboko kumpanga kwaa mundu uchapu.” ");
INSERT INTO ndg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu ngaboka pandu palo kayenda kutalu yenda upande wa Tiro na Sidoni. ");
INSERT INTO ndg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Linga aichi nnwawa ywakanani buka upande woo ngakemelya kabaya, Unihurumiye, Ngwana, Wa mwana wa Daudi, mwinja wango ateswa muno ni nchela.” ");
INSERT INTO ndg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lakini Yesu anyangwi kwaa kikowe, anapunzi bake kabaisa ni kunnoba, kakabaya, “Mumoye ayende kachake, mana atupangyandoti.” ");
INSERT INTO ndg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kayangwa ni kuabakiya, Nitumilwe kwaa kwamundu ywoywoti ila kwa ngondolo babaobite ba munyumba ya Israel.” ");
INSERT INTO ndg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lakini atiicha no lita nnonge yake, ngabaya “Ngwana uniyangatiye” ");
INSERT INTO ndg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ati kunyangwa no baya, “Inogite kwa tola chakulya cha bana na kwataikulya mabwa,” ");
INSERT INTO ndg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ngabaya, “sawa, Ngwana, hata nyoo mabwaa achene lyaa chakulya chakitomboka pameza ya ngwana wabe.” ");
INSERT INTO ndg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nga Yesu kayangwa no baya, “Nwawa, imani yako ngolo. Naipangilwe kachako kati ya ywapala.”Ni mwinja wake ngapona kwa muda wo. ");
INSERT INTO ndg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu atiboka mahali palo ni yenda karibu ni bahari ya Galilaya. Boaka po ayei pakitombe no tama kwoo. ");
INSERT INTO ndg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kipenga kikolo sa bandu chayei kachake, ni kunelya iwete, bangeminyo, mabubu, babalemile na benge, bababile atamwe baabekete pama ngologa Yesu lenga aponeye. ");
INSERT INTO ndg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ni kipenga satisangala pabamweni mabubu kabalongela, ilema kababa akoto, iwete kabayenda na bangeminyo kabalola. Batikumsifu Nnongo wa Israel. ");
INSERT INTO ndg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ngaakema anapunzi bake kaakokeya, “Nikiboni huuruma chelo kipenga cha bandu, kwa mana chabile na nenga masoba gatatu bila lya kilebe chochoti. Niwesa kwaa kwalaga bayende bila lyaa, bakana induka mundela.” ");
INSERT INTO ndg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Anapunzi bake, kabammakiya, “Kwaako kwatuweza pata mikate yanyansima na pano papongote yo yukuta umati nkolo kiasi cheno? ");
INSERT INTO ndg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu kaakokeya, “Mubile na mikate ilenga? kabayanywa, “saba ni omba achene.” ");
INSERT INTO ndg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu ngabakiya mwabakiye bandu batame pae. ");
INSERT INTO ndg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Atweti yelo mikate saba na balo omba achene ni baada ya shukuru, ngaimetwana na kwapeya anapunzi bake. Anapunzi bake ngabapeya bandu. ");
INSERT INTO ndg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bandu boti kabalya ni yukuta, ngaba kusanya ipande ya kulya yai igalile ipande ipande, yalweli itondo saba. ");
INSERT INTO ndg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Boti bababile analome elfu ncheche bila alwawa na bana. ");
INSERT INTO ndg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Boka po Yesu kaalangya bayende kachabe ni kujingya mungalaba ni yenda sehemu ya Magadani. ");
INSERT INTO ndg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafarisayo ni masadukayo batikun'yendya Yesu ni kun'geya apange ishara boka kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lakini Yesu kabayangwa ni kuabakiya “Pakibile kitamunyo mubaya panga hali ya upepo sapi, kwa mana kunani kwakongolwike. ");
INSERT INTO ndg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na kindai mwenda baya, Hali ya upepo leno inanoga kwa kuwa kunani kukele na maunde ngati wekelya kunani kwoti! Mwenda kutanga mwakubile kunani, lakini muweza kwaa tanga ishara ya nyakati. ");
INSERT INTO ndg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kibeleko kichapu ni cha umalaya kipala ishara, lakini ntopo ishara yeyoti yailowa peyelwa, isipokuwa yelo ya Yona, boka po Yesu kabaleka ni kuyenda kachake. ");
INSERT INTO ndg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Anapunzi baisi upande wana ibele, lakini balibalile potw a mikate. ");
INSERT INTO ndg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu kaabakiya, “Mwitahazari ni mube makini no kwo lola mafarisayo ni masadukayo.” ");
INSERT INTO ndg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Anapunzi ngabalaluyana na kababaya, “Kwa mwanja tupotwi kwaa mikate.” ");
INSERT INTO ndg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu atangite sabawasa no baya, mwenga mwabene imani njene, mwanja namani muwasike no bakiyana kati yinu no baya panga kwa mwanja tupotwi kwaa mikate? ");
INSERT INTO ndg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Je mutanga kwaa au muna kombokya kwaa yelo mikate mitano kwa bandu elfu tano, ni itondo ilenga muikusanyile? ");
INSERT INTO ndg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Au mikate saba kwa bandu elfu ncheche, ni itono ilenga yamwaputwike? ");
INSERT INTO ndg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ibile kitiwi panga munatanga kwaa yopanga nabile nilongela na mwenga kunani ya mikate? mwilendele na mwiazali na lola kwa mafarisayo ni masadukayo.” ");
INSERT INTO ndg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ngabatubwa tanga panga kumbe abakiya kwa husu kuazari ni mikate yai loi, ila kwiazari na mapundisho ga mafarisayo na masadukayo. ");
INSERT INTO ndg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wakati Yesu paikite ku'Kaisaria ya Filipi kaalaluya anapunzi bake kabaya, “Bandu bakoya mwana wa mundu nga nyai? ");
INSERT INTO ndg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kababaya, wenge wakukema Yohana mbatizaji, benge bakukema wa Eliya, ni benge, bakukema Yeremia, au wa nabii yumo wa manabii. ");
INSERT INTO ndg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kaabakiya, ni mwenga mwanikema nenga na nyai? ");
INSERT INTO ndg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petro kabaya, “wenga wa Kristo mwana wa Nnongo ywa bii nkoto.” ");
INSERT INTO ndg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kan'yangwa ni kunkokeya, “Utibarikilwa wenga wa Simoni Bar Yona, kwa mana miyai ni nyama yongolike ale, ila Tate bango ywaabile kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na nenga nendakubakiya panga wenga wa Petro, ni kunani ya liwe linalowa kulichenga likanisa lyango. Milwango ya kuzimu yalishinda kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nikupeya wenga funguo ya utawala wa kumaunde. Chochoti ukipangite mu'dunia chatapilwa hata kumaunde, ni chochote chawalowa kukiyowa mu'dunia chalowa yongolewa ni kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Boka po Yesu kababakiya anapunzi bake kana mwam'bakiye mundu ywoywoti panga ywembe ni Kristo. ");
INSERT INTO ndg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Boka muda woo Yesu atumbwi kuwabakiya panga lazima ayende Yerusalemu, yoteselwa na kwa makowe ganansima mumaboko ga apindo ni apindo ga makuhani ni aandishi, bulangilwa ni yoka lisoba lyene tatu. ");
INSERT INTO ndg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesu kamtola Petro pambwega na kumkalipya kummakiya, “Likowe le libekutalu na wenga, Ngwana, hale kana libiti kachako. ");
INSERT INTO ndg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lakini Yesu atigalambuka ni kummakiya Petro, ubuyangane nchogo yangu nchela! wenga wa kibo kachango, kwa kuwa ujali kwaa makowe ga Nnongo, ila makowe ga bandu.” ");
INSERT INTO ndg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Boka po Yesu kaabakiya anapunzi bake, “Mana mundu ywoywoti ywapala kunikengama nenga, lazima aikane mwene, aupotwe msalaba wake, ni anikengame. ");
INSERT INTO ndg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwasababu ywapala kugaokoa maisha gake alowa gaobeya, na kwa ywoywoti ywa abeya maisha gake kwa ajili yango alowa galamiya. ");
INSERT INTO ndg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Je! faida gani ywalowa ipata mundu mana aipatike dunia yoti lakini aobiye maisha gake? ");
INSERT INTO ndg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwa maana mwana wa Adamu alowa icha mu'utukufu wa Tate bake na malaika bake na Ywembe alowa kunepa kila mundu lengana na matendo gake. ");
INSERT INTO ndg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kweli nenda kummakiya baazi yinu mwamuyemi paa, mwalowa paya kwa kiwo mpaka pabamwona mwana wa Adamu kaicha mu utawala wake. ");
INSERT INTO ndg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lisoba lya sita Yesu atikuwatola pamope ni ywembe Petro, Yakobo, ni Yohana nnunawe, kaatola mpaka kunani ya kitombe kilacho. ");
INSERT INTO ndg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Atibadilishwa nnonge yabe. Kuminyo yake kwatimelemeta kati lisoba ni ngobo yake yabonekine yamelemetya kati bweya. ");
INSERT INTO ndg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Linga halo bapitike Musa ni Eliya, kalongela nakwe. ");
INSERT INTO ndg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petro kayangwa ni kummakiya Yesu, “Ngwana, bora kachitu twenga tube pano. Mana upendile, twalowa chenga pano ibanda itatu-chimo chako, chimo cha Musa ni chenge cha Eliya.” ");
INSERT INTO ndg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wakati kabalongela, linga liunde lyuu lyatikwawekelya, na linga ngalipita lilobe buka muliunde kai baya, “Ayoo nga mwana wanga ywanimpendile na ywembe mumpekani.” ");
INSERT INTO ndg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Anapunzi bake pabayowine ago, ngabatula baye wakukama ni batiyogopa muno. ");
INSERT INTO ndg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Boka po Yesu klaisa kuwakamwa ni kuabakiya, “Katukange wala kana muyogope.” ");
INSERT INTO ndg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kabakakatuka kabalolekeya kunani lakini bamweni kwaa mundu ila Yesu kichake. ");
INSERT INTO ndg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Napabile kabauluka kukitombe, Yesu kaalangya, “Kana mwabaye husu mwamugabweni mpaka mwana wa Adamu kayoka boka mu kiwo. ");
INSERT INTO ndg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","“Anapunzi bake batikunaluya, kababaya, “Mwanja namani aandishi babaya panga Eliya alowa isa wete? ");
INSERT INTO ndg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kayangwa kuabakiya, Eliya alowa isa kweli na alowa buyanganiya makowe goti. ");
INSERT INTO ndg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lakini biamakiya mwenga, Eliya ayomwile icha, lakini bamtangite kwaa-Badala yake, bampangii makowe ngabapala bembe. Nga nyo mwana wa Adamu alowa teseka kwa maboko gabe.” ");
INSERT INTO ndg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nga anapunzi bake batangite panga alongelange habari ya Yohana mbatizaji. ");
INSERT INTO ndg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Paikite pa kipenga sa bandu, mundu yumo atikuwayendelya, apigite magoti nnonge yake, ni kummakiya, ");
INSERT INTO ndg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ngwana, umonii lwongo mwana wango, maana abi ni kyunda unda no teswa muno mana mara ganansima atombokya mumwoto au mumase. ");
INSERT INTO ndg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nanetike kwa anapunzi bako, lakini bawezike kwaa kumponeya. ");
INSERT INTO ndg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kayangwa, “Mwenga mwaubelei wange aminiya na chakiaribike, nilowa tama namwenga hata bakibawi? nnete hapa kwango.” ");
INSERT INTO ndg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu atikumkemya nchela nga mmoka munchembe aponi buka saa yelo. ");
INSERT INTO ndg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ni anapunzi banyendeli Yesu kwa siri ni kunnaluya, “Mwanja namani twenga tushindwe kumponeya? ");
INSERT INTO ndg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kaabakiya, “Kwasababu ya imani yinu njene. Kweli nenda kuwamakiya, mana mwa baa na imani hata njene kati nombo ya mbeyu ya haradari mwalowa kukibaya kitombe cheno, boka apa na uyende kolo, na wembe walowa ama chalowabaa kwa kilebe chachalowa shindikana kachinu. ");
INSERT INTO ndg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Muzingatie: makowe ga mstari wa 21 “lakini aina yee ya nchela awezekana kwaa boka, ila kwa loba na funga” gabonekana kwaa ukurasa wa zamni) ");
INSERT INTO ndg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wakati pabile bado Galilaya, Yesu kabakiya anapunzi bake, “mwana wa Adamu alowa yeyelwa maboko ga bandu. ");
INSERT INTO ndg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nalowa kumulaga, na lisoba lineitatu ayoka.”anapunzi batihuzunika muno. ");
INSERT INTO ndg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na pabaikite Kapernaumu, bandu babakusanya kodi ya nusu shekeri kaban'yendelya Petro no baya, Je mwalimu winu endalipa kodi ya nusu shekeli? ");
INSERT INTO ndg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kabaya, Yesu kalongela na Petro wete no baya, uwacha namani Simoni? afalme ba dunia, pokya kodi au ushuru buka kwa nyai? Kwa balo babatawala buka kwa ageni? ");
INSERT INTO ndg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Wakati Petro pabaite, “buka kwa ageni” Yesu kammakiya, kwahiyo atawaliwa batiboyelwa kulepi. ");
INSERT INTO ndg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lakini kana tuwapange atoza ushuru kabapanga sambi, yenda kubari, taikulya ndoano na unopwe yulo omba ywalowa isa ywa kwanza wanyamiye kano wake, walowa kwibona shekeri jimo. witole na akapei atoza ushuru kwa ajili yango na wenga. ");
INSERT INTO ndg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","muda woo anapunzi bake batiicha kwa Yesu ni kummakiya, “Nyai ywabile nkolo mu'utawala wa kumaunde?” ");
INSERT INTO ndg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu kaankema mwana nchunu kammeka nkati yabe, ");
INSERT INTO ndg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","No baya, “Kweli nenda kuamakiya, mana mukotwike tubu no panga kati mwabana alele muweza kwaa jingya mu utawala wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kwa eyo woywote ywalowa kuuluya kati mwana mnele, mundu kati ywo nga nkolo mu'utawala wa kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ni mundu ywoywoti ywalowa kumpokya mwana mnele kwa lina lyango anipokya nenga. ");
INSERT INTO ndg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lakini ywoywoti ywasababisha jumo kati ya alele aba babaniaminiya asi, yalowa panga bora kwa mundu ywp liwe likolo lyo sangya likatabilwa paingo yake ni, tumbukilwa mu'bahari. ");
INSERT INTO ndg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ole kwa dunia kwasababu kunumiya! kwa mana ntopo namna kwa wakati wo icha, lakini ole kachake kwa mundu yolo wakati woo yaicha kwaajili yake! ");
INSERT INTO ndg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kati luboko lwako lutikusababisha kukwazika, ukate ni utaikwe kutalu ni wenga bora kachako wenga jingya muuzima ubile ntopo luboko au kilema, kuliko taikulikwa mumwoto wa machoba gangunganikwa ubile na maboko goti na magolo goti. ");
INSERT INTO ndg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Liyo lyako mana likukoseyite, ulitupwe na ulitaikwe kutalu ni wenga. Bora kachako wenga ujingii mu uzima na liyo limo, kuliko taikuliwa kumwoto wa masoba yangeyomoka ubile ni minyo yoti. ");
INSERT INTO ndg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Linga panga kana mwazarau jumo ywa achene baa kwa mana nenda kuwamakiya panga kumaunde kwii na malaika bembe masoba goti, kaba ulolekeya kuminyo kwa Tate bango ywabile kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Muwaza namani? Mana itei mundu abi na ngondolo mia jimo yumo aobe, Je! aweza kwaleka tisini na tisa ya kitombe na yenda kwapala yolo yumo ywaobite? ");
INSERT INTO ndg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na mana amweni, kweli nenda kuwamakiya, alowa kumpulaikya kutiloo tisini na tisa babakotwike obe. ");
INSERT INTO ndg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nga nyo mapenzi kwaa ga Tate binu ywa kumaunde panga kati ya yumo ywa achene ba baobe. ");
INSERT INTO ndg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mana nongo wako akukoseite, uyende, ukanobe akusami abile kichake. Mana akuyowine wapanga ukelebwiye nnongo'wo. ");
INSERT INTO ndg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lakini mana akuyowine kwaa, wapotwe alongo benge abele au atatu mana kwa mikano ya ashahidi abele au atatu kila likowe liweza yomoka. ");
INSERT INTO ndg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na mana asalawile kukupekaniya, ulibakiye li'kanisa likowe lyoo, mana asalawite kae kulipekaniya likanisa, bai na abe kati mundu wa dunia na ywalonga ushuru. ");
INSERT INTO ndg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kweli nenda kuamakiya, chachatabilwa mu'dunia na kumaunde kilabilwe na chochote chachayongoyelwe mu'dunia na kumaunde kiyongolike. ");
INSERT INTO ndg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kae nenda kuamakiya panga bandu kati yinu mana bayeketyaniye kunani ya kikowe lyolyote mu'dunia kabaloba, halyo ");
INSERT INTO ndg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tate bango ba kunani alowa panga. Kwa mwanja abele au atatu mana bakusawike pamope kwa lina lyangi, Ne nibi pakati kati yabe. ");
INSERT INTO ndg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na Petro kaisa na kummakiya Yesu, “Ngwana, mara ilenga nongo wango mana anikoseite na nenga nimsami? Hata mara saba? ");
INSERT INTO ndg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kammakiya, “Nikubakiya kwa mara saba, lakini hata sabaini mara saba. ");
INSERT INTO ndg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwa mwanza nyo utawala wa kumaunde ni sawa na tawala pulani ywapalage lekebisha esabu buka kwa atumwa bake. ");
INSERT INTO ndg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Paatumbwi lekebisha esabu, mtumwa yumo batikunnetya kachake na ywembe alonge lwage talanta elfu komi. ");
INSERT INTO ndg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mana abile nacho kwaa Cleopata, Ngwana wake alangi apemeyelwe, nyumbowe bana bake na kila kilebe chabile nacho, na alepe. ");
INSERT INTO ndg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nga aywo mmanda ngalabukya, apiyite magoti nnongi yake kabaya, “Ngwana unipumiliye nenga, nalowa kukulepa kila kilebe'. ");
INSERT INTO ndg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nga aywo Ngwana wa mmanda ywo, mana abina uruma, atikunneka na kusamwa deni lyo ");
INSERT INTO ndg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Lakini mmanda ywo atiboka na kumpata mmanda yumo katika amanda benge, ywa nnongage dinari mia. Atikumwuta, na kunkaba pa'ingo, na kumakiya, “Unilepe chanikulenga.' ");
INSERT INTO ndg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lakini yolo mmanda ywenge atikukilikitya ni kunnoba muno, kabaya, “Unipumiliye, nalowa kukulepa.” ");
INSERT INTO ndg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lakini mmanda ywa kwanza atikana. Badala yake ayei kuntaba kuligereza, paka palepa deni lyake. ");
INSERT INTO ndg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pababweni amanda wenge chelo chakipangite. Batikasirika muno Batiisa ni kummakiya Ngwana wabe kila kilebe chakipitike. ");
INSERT INTO ndg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Boka po ngwana wa atmanda yolo ankemite, ni kummakiya,'wenga wa mmanda mmaya, nitikusamya wenga lideni lyako lyoti kwa mwanja wati niloba muno. ");
INSERT INTO ndg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ywabile ni wenga ukaba na huruma kwa mmanda nyino kati nenga mwanikuhurumiye wenga? ");
INSERT INTO ndg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ngwana wake atikasirika muno ni kwapeya askari watesa mpaka apalepa lideni lyake. ");
INSERT INTO ndg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Eyo nga Tate bango ba kumaunde ngabalowa panga, manaite nkolikwe samyana mwalongo sika kwa mwoyo winu”. ");
INSERT INTO ndg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yapiti wakati Yesu payomwi makowe go, ayei Galilaya na ayei kupaka wa Yudea nnonge ya libende lya Jordani. ");
INSERT INTO ndg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kipenga kikolo chatimkengama, na atikwaponiya kwo. ");
INSERT INTO ndg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafarisayo gabauyendelya, kabampaya, kabammakiya, “Je halali mundu kunneka nyumbowe kwa sababu yoyoti? ");
INSERT INTO ndg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kayangwa ni kwaabakiya, “Musomite kwaa, panga ywembe ywaumbite hapo pakwanza aumbite nnalome ni nwawa? ");
INSERT INTO ndg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na kae kabaya,'Kwasababu ya nnalome alowa kunneka Tate bake ni mao bake no longela na nyumbowe, ni abele balowa ba mundu yumo?' ");
INSERT INTO ndg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kwahi abele kwaa kae, Ba chalumbine Nnongo, mundu yoyoti kana atenganishe.” ");
INSERT INTO ndg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ngabamakiya, “Tubwe mwanza mani Musa atubakiye tupiye hati ya talaka na kunneka?” ");
INSERT INTO ndg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ngabakiya, kwa sababu ya nonopa kwinu kwa mwoyo Musa atikuarusu kwaleka akina yumbo binu, lakini boka zamani yabinyo kwa. ");
INSERT INTO ndg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nenda kumakiya, jwalowa kunneka nyumbowe, ila kwa mwanza amalaya na katola ywenge, enda zini. Nalome ywalowa kutola nwawa ywalekilwe endazini.” ");
INSERT INTO ndg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Anapunzi kabammakiya Yesu, “manaibile nyoo kwanalome ni nyumbowe, bora kutoka tolakwe”. ");
INSERT INTO ndg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lakini Yesu kaabakiya, “Mundu kwaa ywaweza tama kichake, ila kwa balo babapeyilwe. ");
INSERT INTO ndg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwasababu babile benembende bababelekwile buka ya mao babe. Ni kae kwi na bene mbende babaipangile kwa sababu ya utawala wa kumaunde ywaweza pokwa mapundisho ga na agapoki.” ");
INSERT INTO ndg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Alafu baneti baadhi ya bana achene linga abeki maboko kunani yabe na kwalolya, lakini anapunzi bake bende kwakerebuya. ");
INSERT INTO ndg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ila Yesu atikwabakiya, “Mwaleke bana achene, wala kana mwakanikiye icha kachango, kwamana utawala wa kumaunde ni wa bandu kati baa. ");
INSERT INTO ndg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ni ywembe nga abekya maboko gake kunani yabe, na mwisho ngaboka palo. ");
INSERT INTO ndg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Linga mundu yumo kaisa kwa Yesu na kumakiya, mwalimu kikowe gani kinanoga champalikwa panga linga nipate jingya kukoto wa wange yomoka? ");
INSERT INTO ndg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu ngamakiya, mwanja namani unilaluya kila begani kinanoga? kwi na yumo bai ywabile mwema lakini mana upendi kupata ukoto, mwikamwe saliya ya Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yolo mundu nganaluya, saliya yako? Yesu ngabaya, kana usalau, kana wabe malaya, kana wabe mwii, kana walongela ubocho. ");
INSERT INTO ndg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Uwaeshimu Tate bako na mao bako, na upende jilani wako kati mwawipendi wa mwene.” ");
INSERT INTO ndg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mundu yolo ngammakiya,'Makowe goti nigakamwile. Bado nipalikwa kinamani? ");
INSERT INTO ndg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu ngamakiya, mana kupala ube wa mkamilifu, yenda, ukapemeye yobile nayo, nawapei maskini, na walowa baa na akiba ya kumaunde. Alafu wiche unikengame.” ");
INSERT INTO ndg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lakini kijana yolo payowe galo gamakiye, atiboka kwo uzunika, kwa mwanja abi na mali yanansima. ");
INSERT INTO ndg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kae nenda kaamakiya anapunzi bake, “Kweli nenda kuamakiya, ngumu kwa mundu tajiri jingya, mu'utawala wa kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kae nenda kuamakiya, rahisi ngamiya petta palembwa lya sindano kuliko tajiri jingya mu utawala wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Anapunzi pabayowine ago, batisangala muno no baya, “Nyai le ywapala okoka?” ");
INSERT INTO ndg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu atikwalinga no baya, kwa alyo liwezekanika kwaa, lakini kwa Nnongo goti gendawezekana.” ");
INSERT INTO ndg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petro nganyangwana kumakiya, linga twilei yoti na kukukengama wenga, kilebe gani chatulowa kukipata?” ");
INSERT INTO ndg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kayangwa, “Kweli nenda kuwamakiyanga, ywembe ywanikengama nenga, mubelei wayambe wakati mwana wa Adamu palowa tama pakitengo cha utawala cha utukufu wake, na mwenga mwabembe mwalowa tama paitengo kumi na ibele ya enzi, kwahukumu makabila komi ni ibele ya Israeli. ");
INSERT INTO ndg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kila mundu yumo ywailei nyumba, kaka, mnombowe Tate bake mao bake, bana na mingunda kwa ajili ya lina lyango, alowa wapokiya mara mia na kurithi ukoto wangeyomoka. ");
INSERT INTO ndg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lakini baingi bababile bakwanza balowa bamwisho, na bababile bamwisho baba ba kwanza. ");
INSERT INTO ndg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kwa maana utawala wa kumaunde ufanine na ywautawala ng'unda, ywayumwika kindae na mapema linga apeleke ibarua kung'unda wake wa mizabibu. ");
INSERT INTO ndg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Baada ya yoyeketyana nabo dinari jimo kwa kuwa, abayite bayende kung'unda wake wa mizabibu. ");
INSERT INTO ndg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ayuin kae baada ya masaa gatatu ni abweni apanga kazi benge bayemi bila kazi karibu na soko. ");
INSERT INTO ndg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ngabakiya na mwenga muyende kung'unda wango wa mizabibu na chochoti chakibi alali nalowa kunepa.”Nga nyo bayei panga kazi.” ");
INSERT INTO ndg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ayei kae baada ya masaa sita, ni kae katika masaa tisa, apangite nyonyonyo. ");
INSERT INTO ndg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mara yenge kai majira ya saa komi ni jimo atiyenda ni kwakokeya bandu benge bayemi bila kazi ya Atikwabakiya, “Mwanja namani muyei paa bila panga kazi lisoba lizima? ");
INSERT INTO ndg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kabankokeya, kwa sababu ntopo mundu ywoywoti ywatuajiri. Akabakokeya, “mwenga kae muyende katika ng'unda wa mizabibu.' ");
INSERT INTO ndg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","kitamunyo, mwenye ng'unda wa mizabibu asimamizi bake, wakeme apanga kazi walepe mishahara utubwa wa mwisho mpaka wa kwanza. ");
INSERT INTO ndg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pabaisi babayei saa komi ni jimo, kila mundu apeyilwe dinari. ");
INSERT INTO ndg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pabaisi apanga kazi ba kwanza bawasage balowapala yanansima lakini bapoki kila mundu dinari jimo. ");
INSERT INTO ndg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Baada ya pokya kila mundu malepo gake, batikunlalamikya mwene ng'unda. ");
INSERT INTO ndg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kababaya 'haba apanga kazi bamwisho batumi lisaa limo bai yabapangite kazi, lakini walupitae Katitwe twenga tupotwi mizigo nzma na lumia na liumu. ");
INSERT INTO ndg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lakini mwene ng'unda kayangwa nikummakiya yumo nkati yabe,'Wa bwiga wango, mbangite kwaa likowelibaya. Je! Tuyeketyanikwe kwaa na nenga panga dinari yimo? ");
INSERT INTO ndg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Upoki chelo chakibile halali yako ni uyende kachako. Puraha yango kwa apeya aba anapunzi babayei mwisho sawasawa ni wenga. ");
INSERT INTO ndg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Je kana ibi haki kwango panga chelo chanikipala na mali yango? Au liyo lyako lilau kwa mwanza nenga na mwema? ");
INSERT INTO ndg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nga nyo wa mwisho aba wa kwanza ni wa kwanza abi wa mwisho.” ");
INSERT INTO ndg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu pabile kaboka kuyenda Yerusalemu apotwi ni anapunzi bake komi ni ibele pambwega, ni mundela kabakokeya, ");
INSERT INTO ndg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Linga tuyenda Yerusalemu, ni mwana wa Adamu alowa abilwa mmoko ga akolo ba makuhani na baandishi. Balowa kumwukumu kiwo. ");
INSERT INTO ndg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na balowa kumpiya kwa bandu ba mataifa ili kun'geya, kunkombwa ni kunikongeara. Lakini baada ya masoba gatatu alowa yoka.” ");
INSERT INTO ndg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ni mao bake Zebedayo aichi kwa Yesu na bana bake. Atikilitika nnonge yake ni kunnoba kilebe boka kichake. ");
INSERT INTO ndg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu kaankokeya, “Upala namani?” kaamakiya “Ulazimishe panga aba bana bango abele batame, yumo atame liboko lya kummalyo ni ywenge luboko lwako lwa kukeya mu'utawala wako.' ");
INSERT INTO ndg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lakini Yesu kayangwa ni kubaya, “Ulangite kwaa chaukiloba. Je wenda weza kukinywelya kikombe saniweza nywelya nenga?” Ngababaya, “Twenda weza.” ");
INSERT INTO ndg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kabaakokeya, kikombe chango hakika mwalowa kukinywelya. Ila tama luboko lwangu lwa kumalyo ni tama luboko lwango lwa kukeya kazi yangu nenga kwaa, ila balo babayomwile changulilwa ni Tate bango.” ");
INSERT INTO ndg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Anapunzi benge komi pabayowine ago, bati chukya muno kwa bana balo abele. ");
INSERT INTO ndg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lakini Yesu atikuwakema bene nakwabakiya “Mutangite panga atawala ba mataifa kwa kwalazimisha, ni apendo babe kwitimiza mamlaka kunani yabe. ");
INSERT INTO ndg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakini kana ipange nyoo kachinu. Badala yake, ywoywote ywapala panga mpindo pa nkati jinu lazima abe mtumishi winu. ");
INSERT INTO ndg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ni ywalowa panga ywa kwanza kati yinu lazima abe mtumishi winu. ");
INSERT INTO ndg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kati mwabi Mwana wa Adamu aichi kwaa kutumikilwa, ila tumika na kupiya mwomi wake panga ukombozi kwa bingi.” ");
INSERT INTO ndg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wakati kaba buka Yeriko, kipenga kikolo sa bandu chatikuwakengama. ");
INSERT INTO ndg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bababweni ipofu abele batami bwega ya ndela. Pababweni Yesu endapita, batikemelya no baya, “Ngwana, Mwana wa Daudi, utuponeye.” ");
INSERT INTO ndg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lakini kipenga satikwabendya, na kwabakiya mukotoke, hata nyo, batikemelya lilobe likolo no baya, “Ngwana, Mwana wa Daudi, utuponeye.” ");
INSERT INTO ndg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mwisho Yesu atiyema atikwakema ni kwalalaya, “Mupala niatende namani?” ");
INSERT INTO ndg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kabankokeya, “Ngwana tupala tubone.” ");
INSERT INTO ndg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bai Yesu, kaumiya mwoyo wa huruma, kagakunywa minyo gabe, sa yoyo, kabalolekeya kabankengama. ");
INSERT INTO ndg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ni anapunzi bake baikite karibu ni Yerusalemu na bayei mpaka Bethfag, kukitombe sa mizeituni, Boka po Yesu ngatumite anapunzi bake abele, ");
INSERT INTO ndg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kabakokeya, “Muyende kukijiji cha kibii nnonge, na mwalowa kummona mwana wa mbonda bantabite palo, mukamwunde na kuniletya. ");
INSERT INTO ndg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mundu mana kanaluya mwammakiye,'Ngwana indakumpala' ni mundu ywo alowa kunneka na mwuiche nakwe.” ");
INSERT INTO ndg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Likowe lyoo lyapiti lyalibaite nabii lazima litimye. Kabakokeya, ");
INSERT INTO ndg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mum'bakiye mwale Sayuni. linga, mpwalume wako endaicha kachinu, mnyenyekevu na ampoki mwana wa mbonda, mwana wa mbonda mnele. ");
INSERT INTO ndg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mwisho anapunzi bati buka no panga kati Yesu mwalangile. ");
INSERT INTO ndg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Baneti mbonda na mwana wake, no tandika ngobo na Yesu ngampokya. ");
INSERT INTO ndg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bingi nkati ya bandu balandike ngobo yabe mundela na benge batekwi matawi ga mikongo no tandika mundela. ");
INSERT INTO ndg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kipenga satilongolya Yesu na babamwindikiyae kabayoba, kabaya, “Hosana Mwana wa Daudi umebarikiwa ywaisa kwa lina lya Ngwana. Hosana kunani muno. ");
INSERT INTO ndg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu paikite Yerusalemu, mji woti watishtuka no baya, “Hayo wa nyai?” ");
INSERT INTO ndg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kipenga chayangwa, “Hayo nga Yesu nabii, boka Nazareti ya Galilaya.” ");
INSERT INTO ndg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na mwisho Yesu ajingii mu'nyumba ya ibada ya Nnongo. Atikwapiya panja bote bababile kabapema no mpemeya mu'hekalu. Nga nokwa meza yabang'andae kamali na itengo ya babapemeyange ngunda. ");
INSERT INTO ndg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kabakokeya, “Yaandikilwe, nyumba yango yalowa kemelwa ya maombi. Lakini mwenga mwipangite lipango lya anyang'anyi.” ");
INSERT INTO ndg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Boka po ipofu ni ilema batikumwisilya muhekalu, ni ywembe atikwaponiya. ");
INSERT INTO ndg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ila apindo ba makuhani na aandishi pababweni maajabu agapangite, na pabayowine bana kabapanga ndoti muhekalu na kubaya, “Hosana mwana wa Daudi,” batikasirika muno. ");
INSERT INTO ndg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Batikumakiya, “Uyowine chabakibaya haba bandu?” Yesu ngabakiya, “Elo! Lakini muna wai kwaa soma, buka munkano wa aba bana na bana alele baba yonga benda sifu kinanoga?” ");
INSERT INTO ndg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Boka po Yesu atikwaleka no yenda panja ya nnema akwo Bethania na agonjike kwokwo kwo. ");
INSERT INTO ndg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kindae kabuyangana, boka mjini, abweni njala. ");
INSERT INTO ndg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Abweni mtini bwega ya ndela. Atikuuyendea, lakini alibweni kwa litunda nnani yake ila makapi, atikuubakiya, “Buka lino kana wapambike kae.” na mtini wene watiyoma. ");
INSERT INTO ndg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Anapunzi pababweni, batishangala no baya, “Ibi kitiwi mkongo utiyoma mara jimo? ");
INSERT INTO ndg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kayangwa no kwabakiya, “kweli nenda kwamakiya, mana mubile na imani bila mashaka, mwalowa panga zaidi ya nkongo, mwalowa kukibakiya kitombe chelo kiboke kikatumbuki mu'bahari, ni yalowa pangilwa. ");
INSERT INTO ndg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Chochote cha mwaloba kwo salya, mana muaminile mwalowa pakya.” ");
INSERT INTO ndg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu paikite muhekalu, apindo ba makuhani ni apindo babandu batikunyendelya wakati kapundisha na kunnaluya, “Kwa ngupu gani upanga makowe aga? Na nyai ywakupei mamlaka ago? ");
INSERT INTO ndg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kayangwa ni kuamakiya, Na nenga mbala kwanaluya linga liswali limo. Mana mwalowa kunibakiya, ni nenga nilowa kuwabakiya ni kwa ngupu ilenga nipangite makowe aga. ");
INSERT INTO ndg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“Ubatixo wa Yohana waboka kumaunde au kwa bandu?”Kabakokeyana bene, kababaya, mana tubaye uboka kumaunde,'apala kutumakiya kwanini tuuaminite kwaa?' ");
INSERT INTO ndg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lakini mana tubayite,'uboka kwa bandu,'twalowa yogopa kipenga sa bandu, mana bote bamweni Yohana kati nabii.” ");
INSERT INTO ndg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Boka po batikunkengama Yesu bakibaya, “Tutangite kwa” kabakokeya, “wala nenga niamakiya kwaa ngupu gani nipanga makowe aga. ");
INSERT INTO ndg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Lakini muwaza namani? Mundu mwene bana abele. Kayenda kwa yumo ni kummakiya,'Mwana wango, nenda ukapange kazi kung'unda wa mizabibu. ");
INSERT INTO ndg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lino mwana kayangwa no baya,'niyenda kwaa.' Lakini baadae atibadilisha mawazo gake ni kuyenda. ");
INSERT INTO ndg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na mundu yo ayei kea mwana wake ywana ibele ni kumakiya kati ywa kwanza. Mwana ayo kayangwa na kummakiya, nilowa yenda ngwana,' lakini ayendike kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ywaako kati ya aba abele ywapangite chakipendike tate bake? Kababaya, mwana wa kwanza.” Yesu kabakokeya, “kweli nenda kuamakiya baba kusanya ushuru ni amalaya balowa jingya mu'utawala wa Nnongo bila mwenga jingya. ");
INSERT INTO ndg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwa mana Yohana aichile kwinu kwa ndela inyookile, lakini mwenga mwangana mwamini, wakati babakusanya ushuru ni amalya batikumwamini. Na mwenga, pamubweni aga gapangite, muweza kwaa kutubu ili badae mwamini. ");
INSERT INTO ndg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mupekani mpwano wenge. Pabile ni mundu mwene lieneo likolo lya bwe. Apandike mzabibu pawaegelile, atumite baadhi ya apanga kazi bake kwa balo akulima ba mizabibu yotola mizabibu yake. ");
INSERT INTO ndg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wakati wa mizabibu ikaribu na kwiuna, atumite atumishi kwa akulima wa mizabibu yotola mizabibu yake. ");
INSERT INTO ndg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lakini akulima ba zabibu ngabatola balo atumishi bake batikumkombwa yumo, batikum'bulaga ywenge, ni yumo bamkombwi ni maliwe. ");
INSERT INTO ndg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kwa mara yenge, mmiliki atumite atumishi benge, banansima zaidi ya balo bakwanza lakini akulima wa mizabibu bapangite kati balo ba kwanza. ");
INSERT INTO ndg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Baada ya ago ngwana yolo atumite mwana wake, kabaya, “kwasababu ywa mwana wango balowa kumweshimu.” ");
INSERT INTO ndg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ila akulima ba mizabibu pabamweni kijana yolo, kababakiyana, “Hayo nga mrith, muiche, tumulage ni kumiliki urithi.' ");
INSERT INTO ndg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kabampotwa, kabantaikulya panja ya ng'unda wa mizabibu ni kummulaga. ");
INSERT INTO ndg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Je! mwene ng'unda wa mizabibu paalowa icha, alowa kwapanga buli akulima ba miabibu?” ");
INSERT INTO ndg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Atikwabakiya, “alowa kwabomwana hobo bandu abya kwandela inanyata muno na mwisho alowa kukodisha ng'unda wa mizabibu kwa akulima bingi payalowa kelya.” ");
INSERT INTO ndg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu kabakokeya, “Munasoma kwa maandiko, liwe lyabalikani aandishi libile liwe likolo lya papembe Alii lyapitike kwa Ngwana sangala paminyo gitu?' ");
INSERT INTO ndg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nga nyoo nganimakiya, utawala wa Nnongo ulowa boloywa buka kachinu na peyelwa mataifa genge gaga jali malunda gake. ");
INSERT INTO ndg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ywoywoti ywalowa tomboka kunani ya liwe lyo alowa tekwanika ipande ipande na kwaywoywoti lyalya mtombokya, lyalwa kumtimba.” ");
INSERT INTO ndg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Akolo ba makuhani na mafarisayo pabayowine mifano yake batangite alongelya bembe. ");
INSERT INTO ndg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lakini kila pabapalage kummoywa bakiyogopage kipenga, kwa mwanja bamonage kati nabii. ");
INSERT INTO ndg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu atilongela nabo kae kwa mipwano. kabaya, ");
INSERT INTO ndg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Upwalume wa kumaunde ulandine na utawala ywa andaite shughuli ya ndoa ya mwana wake. ");
INSERT INTO ndg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Atumite atumwa bake kwakaribisha babakokwile isa kusherehe ya ndoa, lakini baisi kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mpwalume atumite kae amanda wenge, kabakiya, “Mwabakiye babakokilye linga nitayarishe chakulya, Fahali ni ngombe wango ywa nenipe batikuchinja, na ikowe yote ibi tayari, muiche kushughuli ya ndoa.” ");
INSERT INTO ndg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakini bandu abo baisi kwaa kwa muda wabakemilwe. Benge bakelebuka kumigonda yabe, ni benge bayei kubiashara yabe. ");
INSERT INTO ndg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Benge bagalambuki amanda ba pwalume na kwa tania na kwaula ngobo. ");
INSERT INTO ndg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lakini mpwalume atikasirika. Atumite lijeshi lyake, atikwabulaga balo bababulage ayabe na kutiniya nnema wabe kwa mwoto. ");
INSERT INTO ndg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Alafu abakiye atumwa bake, “Ndowa ibii tayari, lakini banakokite bafaika kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kwa eyo muyende pamalekano ga ndela ngolo, mukakoke bandu benge, kadiri yaiwezekana baise mu sherehe ya ndoa.” ");
INSERT INTO ndg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Atumishi kabayenda kundela ngolo na kwa karibisha bandu bote bababweni, azuri na abaya. Eyo ukumbi wa ndoa watweli ageni. ");
INSERT INTO ndg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Lakini mpwalume payingile kuwaloalageni, amweni mundu yumo aweti kwaa sare ya ndoa! ");
INSERT INTO ndg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mpwalume atikunaluya, “Mbwiga, uwezike kwaa jingya mono muukumbi bila sare ya ndoa?' Nga mundu ywo ayangwi kwaa kikowe chochote. ");
INSERT INTO ndg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nga mpalume kaabakiya atumishi bake, “Muntabe mundu ywoo maboko gake na magolo ni mukantaikwe panja kulubendo, akwo kwaba ni kilelo ni tauniya mino. ");
INSERT INTO ndg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kwa mwanja bandu banyansima bandakemelwa, lakini ateule ni achene.” ");
INSERT INTO ndg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nga mafarisayo watiboka no panga njama ya kummoywa Yesu mu'makowe gake mwene. ");
INSERT INTO ndg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nga pabatumite anapunzi gabe pamope ni Maherode. Na batikummakiya Yesu, “Mwalimu twatangite wenga wa mundu wa kweli, no panga pundisha ga apala Nnongo, kwa kweli utangite kwaa mawazo ga mundu ywenge na ubonekana kwa kwayogopa bandu. ");
INSERT INTO ndg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kwa eyo utubakiye uwasa kele? Je, ifaike kisalia lepa kodi kwa Kaisari au ifaike kwaa? ");
INSERT INTO ndg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu atangite ubaya wabe, kabaya, “Mwanja namani mwanigeya, mwe mwa'anafiki? ");
INSERT INTO ndg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Munilage mabanje yamutumya lepa kodi.” Ngabannetya dinari. ");
INSERT INTO ndg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu kalaluya, kuminyo na lina lee lya nyai?” ");
INSERT INTO ndg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kaban'yangwa, “Ga Kaisari.” Nga Yesu kaabakiya, “Mumpei Kaisari ilebe ya ibile yake na ga Nnongo mumpei Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pabayowine nyoo batisangala, mwisho batikuneka no yenda kachabe. ");
INSERT INTO ndg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lisoba limo baadhi ya Mafarisayo baisi kwa Yesu, balo bababaya ntopo yoka mu kiwo. Ngabannaluya, ");
INSERT INTO ndg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","kabakoya, “Mwalimu, Musa abayite mana itei mundu awile bila papa mwana, Nunawe amukiye nwawa yo apate mwana oywo nkowe. ");
INSERT INTO ndg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Babile alongo saba, wa kwanza atikobeka na mwiso atiwaa bila beleka mwana. Nganekya nunawe yolo nwawa. ");
INSERT INTO ndg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ni yolo nunawe ni ywembe atiwaa nembe apangite nyonyonyo na kae yolo wa itatu, yabile nyonyo mpaka yolo wa saba. ");
INSERT INTO ndg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Baada yo panga nyo bote yolo mwana nembe atiwaa. ");
INSERT INTO ndg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wakati wa yoka aywo nwawa alowa panga wa nyai kati ya alongo balo saba? kwa mwanja bote batikunkobeka.” ");
INSERT INTO ndg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Lakini Yesu atikwayangwa ni kwakokeya, “Mwenda kosea, kwa mwanja mutangite kwaa maandiko wala ngupu ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwa mwanja wakati wa yoka, bandu bakobeka kwaa wala kobekwa. Ila bandu baba kati malaika ba kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakini husu kuyoka kwa bandu munawai kwaa soma chelo cha longei kachinu, kabaya, ");
INSERT INTO ndg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nenga na Nnongo wa Ibrahimu, Nnongo ea Isaka, Nnongo wa Yakobo? Nnongo nga Nnongo kwaa wa bandu bawile, Ila Nnongo wa akoto.” ");
INSERT INTO ndg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wakati kipenga pabayowine agoo, batisangala mapundisho gake. ");
INSERT INTO ndg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lakini Mafarisayo pabayowine panga Yesu atikwatuliza masadukayo batiikusanya bene kwa bene. ");
INSERT INTO ndg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yumo, abi mwana saliya, analwiye liswali kwa kumgeya. ");
INSERT INTO ndg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mwalimu, amri yaako yaibi ngolo kuliko yoti yaibi musaliya?” ");
INSERT INTO ndg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kanyangwa, “Lazima umpende umpende Ngwana kwa mwoyo wako woti, kwa roho yako yoti ni kwa malango gako goti. ");
INSERT INTO ndg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aye nga amri ngolo ya kwanza. ");
INSERT INTO ndg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ni inainele ilandana na yoyoyo, lazima kumpenda jirani bako kati waipendi wa mwene. ");
INSERT INTO ndg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Saliya yoti na manabii bayemi mu amri yee ibele. ");
INSERT INTO ndg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na mafarisayo babile bado papalo palo pabakusanyike pamope, Yesu alalwiye liswali. ");
INSERT INTO ndg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Kabaya, “Je! mwawaza kele husu Kristo? ywembe mwana wa nyai? na bembe ngabayangwa, “Mwana wa Daudi.” ");
INSERT INTO ndg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kayangwa, “kwa namna yaako Daudi kwa mwoyo ankema Ngwana, kabaya ");
INSERT INTO ndg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ngwana atikumakiya Ngwana wango, “Tama kuluboko lwako lwa mmalyo, mpaka panalowa kwapanga adui bako babekelwe pae ya magolo gako”? ");
INSERT INTO ndg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mana itei Daudi ankema Kristo “Nngwana”, kwa kitiwi alowa baa mwana wake?” ");
INSERT INTO ndg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ntopo ywawezike yangwa, likowe kae na ntopo ywa thubutu kunaluya kae liswali buka lisoba lyoo ni yendelya. ");
INSERT INTO ndg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Baadae alongei ni kipenga sa bandu na anapunzi bake, kabaya, ");
INSERT INTO ndg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Aandishi na Mafarisayo batami kiteo sa Musa. ");
INSERT INTO ndg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kwa eyo chochote cha wakipanga, mupange kono kamwachunguza. Lakini kana mujingi mumatendo gabe, mana bembe watabwa na makowe gananchima na bembe bapanga kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","5","Kweli, bembe bataba igombo mikulu nayo tapa kwipotwa, na kwa tweka bandu mmapamba gabe. Lakini bene baweza kwaa egeya lukonji kwipotwa. Gabapanga goti, bagabanga linga babone bandu. Kwa mwanja bembe bapanwa masanduku gabe no yongeya ukolo wa mapindo ga ngobo yabe. ");
INSERT INTO ndg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bembe pena tama sehemu ya kifahari pashughuli na paitengo ga heshima kati ya Musinagogi, ");
INSERT INTO ndg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na panga habari kwa heshima makowe gakusoko, na kemelwa “Walimu” na bandu. ");
INSERT INTO ndg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakini mwanga mulakilwa kwa kemelwa 'Mwalimu”, kwa mwanja babile nakwe mwalimu yumo, na mwenga mwabile mwalongo. ");
INSERT INTO ndg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kana mube mundu ywoywote pano padunia kuwa tate binu, kwa kuwa mubi ni Tate yumo, ywabile kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wala kana mwakemelwe 'Mwalimu', kwa kuwa mubi ni Mwalimu yumo, ywaa ni Kristo. ");
INSERT INTO ndg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ila ywabi nkolo kati yinu alowa baa mtumishi winu. ");
INSERT INTO ndg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kila ywa itondobeya alowa uluyilwa. Na ywoywote ywalowa kwiuluya alowa tondobelwa. ");
INSERT INTO ndg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ila ole winu waandishi na Mafarisayo, mwanafiki! mwayigalya bandu utawala wa kumaunde. Mwenga muweza kwaa jingya, na hamwaruhusu kwaa babapala jingya bayingi. ");
INSERT INTO ndg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Uzingatie: mstari ba 14 ubonekana kwaa mukitab bora cha samani. Baadhi ya itabu iyongeya mistari go baada ya mstari wa 12. mstari wa 14, Ole winu aandishi na Mafarisayo mwaanafiki mana mwamila babawelikwe na akii niasengo babe) ");
INSERT INTO ndg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ole winu aandishi na Mafarisayo mwanafiki! muloka kwiye ya bahari na ika kumpanga mundu yumo aamini galo gamapundisho, napapanga kati mwenga, mupanga mara ibele mwana wa mwoto ni kati mwabene mwamubile. ");
INSERT INTO ndg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ole winu iongozi ipofu, mwenga mwa mubaya, ywoywote ywalapa kwa hekalu kilebe kwaa. Lakini ywa alapa dhahabu ya kulihekalu, atabilwe ni kiapo sake. ");
INSERT INTO ndg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwa bandu ipofu apumbafu, chako kikulo kuliko chenge, dhahabu au hekalu ambalo latiweka wakfu dhahabu kwa Nnongo? ");
INSERT INTO ndg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na ywoywote ywa lapa kwa madhabahu, kilebe kwaa ila ywalapa kwa sadaka yaibile kunani yake, alabilwe na kilapo chake. ");
INSERT INTO ndg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwenga mwabandu ipofu, chhako kikolo chaiweza wekelwa wakfu sadaka yaipiyilwa kwa Nnongo? ");
INSERT INTO ndg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kwa eyo, ywembe ywalapa kwa madhabahu alapa kwa yoo na kwailebe yote yaibile kunani yake. ");
INSERT INTO ndg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na ywembe ywalapa kwa hekalu, alapa kwa ywo ywatama kati yake. ");
INSERT INTO ndg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ni ywembe ywalapa kwa kumaunde, alapa kwa iteo ya kipwalume cha Nnongo na kwa ywembe ywa tama kati yake. ");
INSERT INTO ndg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ole winu aandishi ni mafarisayo, mwaanafiki! Kwa mwanja mulepa zaka kwa bizali, mnaanaa ni likolo, lakini mgaleka makowe makolo ga saliya-haki, rehema na imani. Lakini aga mupalikwaa mugapange, na kugaleka kwaa genge bila kugapanga. ");
INSERT INTO ndg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwa iongozi ipofu, mwenga mwamulopwa ilulu njenenjene lakini mumila ngamia. ");
INSERT INTO ndg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ole winu, aandishi na mafarisayo, mwanafiki, kwa mwanja mngolwa panga ya kikombe na panja ya kyani, lakini nkati mutweli dhuluma na bakwa na kiasi. ");
INSERT INTO ndg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mwenga mwa mafarisayo mwange minyo, mugolwe wete nkati ya kikombe na nkati ya kyani, lenga na panja nembe pabe pasafi. ");
INSERT INTO ndg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ole winu, aandishi ni mafarisayo, mwanafikib, kwa mwanja mulandana na makabwi gagabapakiye chokaa, nagembe kwa panja kagamelemetya, lakini yupa yake yeni yene sambi na njapu. ");
INSERT INTO ndg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nyo nyonyo, ni mwenga kwa panja mwabonekine mwabene haki nnongi ya banu, lakini nkati mutweli unafiki ni udhalimu. ");
INSERT INTO ndg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ole winu, aandishi ni mafarisayo, mwanafiki! kwa mwanja muchenga makaburi ya manabii na kugapamba makaburi ga bene haki. ");
INSERT INTO ndg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mwenga mubaya, mana tukata tama wakati wa haki ni tate bitu, tulwe kotoka shiriki pamope nabo pengana damu ya kimanabii. ");
INSERT INTO ndg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kwa eyo mwibaya mwabene panga mwenga mwabana ba abo bababulinge kimanabii. ");
INSERT INTO ndg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kai mwenga mukamilisha tweleya sehemu yostahili sambi sa tate binu. ");
INSERT INTO ndg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mwenga mwaking, ambo, mwabana ba abaya kwandela gani mulowa kosana ni Jehanamu? ");
INSERT INTO ndg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kwa eyo, mulolekeye, nenda kwatuma kachinu manabii bene hekima, na aandishi. Benge mwalowa kuwabulaga ni kwa nyonga, ni benge mwalowa kuwakombwa nkati ya Masinagogi ginu ni kwa bene boka nnema go mpaka nnema go. wenge. ");
INSERT INTO ndg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mwisho wake yalowa pilya kachinu mwai yote ya bene haki yaipenganike mu dunia, boka mwai ya Habili mwene haki mpaka mwai ya Zakaria mwana wa Barakiya, ywa mumulige kati ya patakatifu ni madhabahu. ");
INSERT INTO ndg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kweli, nenda kuwamakiya, makowe aga gote galowa peta kibeleko chelo. ");
INSERT INTO ndg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalemu, Yerusalemu, wenga wawabulaga manabii ni kwokombwa maliwe balo babatumilwe kachako! Mara ilenga ni kumbite bana bako! pamope kati ngoko mwayubatya bana bake nkati ya mapapayo gake, lakini uyeketi kwaa! ");
INSERT INTO ndg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lola! nyumba yako igali ni ukeba. ");
INSERT INTO ndg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ni nenga nenda kubakiya, buka saa yeno no yendelya wambona kwaa, mpaka pawalowa baya, Abarikilwe ywembe ywaicha kwa lina lya Ngwana.” ");
INSERT INTO ndg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu atiboka muhekalu kayenda kachake. Anapunzi bake kabayendelya ni kunangwa majumba ga hekalu. ");
INSERT INTO ndg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lakini atikwayangwa ni kuabakiya, “Je! mugabona kwaa makowe gote? kweli nenda kuwamakiya, ntopo liwe lyalyalowa igala lingelekine na lenge lyalyo kotoka bomoyelwa.” ");
INSERT INTO ndg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na paatami pa kitombe cha mizeituni, anapunzi bake batekunyendelya ku faragha no baya, “Utubakiye, makowe gagapitya pakibawi? KInamani chachapanga dalili ya buya kwako na mwisho wa dunia? ");
INSERT INTO ndg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kayangwa ni kubaya, “Mube mwatulivu panga kana aiche mundu kumwobeya. ");
INSERT INTO ndg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwa kuwa baingi balowa icha kwa lina lyango. Balowa baya nenga na Kristo, nabalowa kwa obeya banyansima. ");
INSERT INTO ndg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mwalowa yowa ngonda na habari ya ngondo. Mulinge kana mube ni masaka. kwa kuwa makowe aga galowa petya, lakini mwisho ubile bado. ");
INSERT INTO ndg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kwa kuwa litaifa lyalowa kombwana ni lyenge, na pwalume hayo ayumana ni upwalume. Paba ni njala na matetemeko ga nnema muma'eneo mbalembale. ");
INSERT INTO ndg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lakini makowe ago gote nga mwanzo wa uchungu wo beleka. ");
INSERT INTO ndg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nga walowa kwapotwa kwaajii yo kwatesa ni kwabulaga. Mwalowa chukilwa ni mataifa gote kwa sababu ya lina lyango. ");
INSERT INTO ndg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ni banansima balowa kobala na salitiana na chukyana bene kwa bene. ");
INSERT INTO ndg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Manabii banansima baubocho baicha ni kuabocholiya baingi. ");
INSERT INTO ndg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwa mwanza ubaya waba wananchima, pendana kwa bandu kwopola. ");
INSERT INTO ndg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lakini ywapumiia mpaka mwisho alowa okoka. ");
INSERT INTO ndg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yeno Injili ya upwalume yalowa hubiriwa mu kilambo choti panga uushahidi kwa mataifa gote, Hapo nga ulo mwisho wa icha. ");
INSERT INTO ndg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kwa eyo pamwaubweni ubou wouharibifu, lyalabayitwe ni nabii Danieli liyemi pandu patakatifu (ywosoma atange), ");
INSERT INTO ndg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nga balo babile Yuda bayende mu'itombe. ");
INSERT INTO ndg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nga ywabile nnani ya nyumba auluke kwaa pae kutola kilebe chochote buka nkati ya nyumba. ");
INSERT INTO ndg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nga ywabile kung'unda kana abuyangane kuisa tola ngobo yake. ");
INSERT INTO ndg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lakini naasikitikya bene bana na babayongea wakati woo. ");
INSERT INTO ndg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mulobe butuka kwinu kana kube wakati wa mbepo, wala lisoba lya sabato. ");
INSERT INTO ndg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwasababu kwabaa dhiki ngolo, ayo inapilya kwa buka umbilwa dunia mpaka saayeno na wala yapitya kwa kae. ");
INSERT INTO ndg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ikapangage machoba gakakotoka pungoyelwa, ntopo mundu ywapele okoka. Lakini kwa mwanja atente, masoba go galowa pongoyelwa. ");
INSERT INTO ndg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kae mana itei mundu ywoywoti alowa kumakiya 'lola, Kristo abi pa! au 'Kristo abi kulo, kana mwaamini makowe go. ");
INSERT INTO ndg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwa sababu Makristo ga ubocho ni manabii ga ubocho walowa icha na kulaya ishara ngolo na maajabu, kwa kusudi lya kwaobeya, yawezekana na hata kwa babachaulilwe. ");
INSERT INTO ndg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mulole, nitikwatahazarisha kabla makowe go pitya. ");
INSERT INTO ndg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kwa eyo, mana bammakiya, “Kristo abikupongote, kana mwayende kwo kupongote. au lolekeya, abile nkati ya nyumba, kana mwamini ago. ");
INSERT INTO ndg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kati njai paimulika kebuka mashariki no mulika mpaka magharibi, ngayopanga isa kwa mwana wa Adamu. ");
INSERT INTO ndg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Popote ubile mzoga, apo ngaba twelwana tai. ");
INSERT INTO ndg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Lakini baada ya dhiki ngolo ya lisoba lyo, lisoba lya banalubendo, mwei wabakwa na bweya wake, ndondwa yalowa tomboka buka kunani na ngupu ya kumaunde yalowa tikiswa. ");
INSERT INTO ndg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nga ishara ya Mwana wa Adamu yalowa bonekana kumaunde, na makabila yoti ya dunia yalowa lombola. Balowa kunoma mwana wa Adamu kaicha mumaunde ya kunani kwa ngupu ya utukufu nkolo. ");
INSERT INTO ndg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Alowa kwatuma malaika bake kwa lilobe likolo lya tarumbeta, nabembe balowa kwa kubya pamope ateule bake buka ipande ncheche ya kilambo, buka kumwisho wa kilambo mpaka mwisho. ");
INSERT INTO ndg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mwiyanganee lisomo buka munkongo mtini. Pamwibona ndambe keipuka kagabita makapi, mutangite panga mpenja wenda icha. ");
INSERT INTO ndg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na yo kai, pamwagabona makowe gote mpalikwa tanga panga aegelile, karibu abi paniango. ");
INSERT INTO ndg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kweli nenda kuwamakiya, mmelekwogo ubeta kwaa, hata makowe ga ngote galowa pitya. ");
INSERT INTO ndg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mbingu ni nnema walowa peta, lakini maneno yango yapeta kwaa kamwe. ");
INSERT INTO ndg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Lakini husu lisoba lyoo ni saa ntopo mundu atangite hata malaika ba kumaunde, wala mwana ila Tate kichake. ");
INSERT INTO ndg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kati mwayabile wakati wa Nuhu, nga mwaba wakati wa buya mwana wa Adamu. ");
INSERT INTO ndg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwa mwanja masoba ago kabla ya gharika bandu babile kabalyaa no nyaa, kaba kobekana konda mpaka lisoba lelo lyajingii Nuhu musafina, ");
INSERT INTO ndg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","na batangite kwaa kilebe chochote mpaka garika paisile na kwakumba bote nga mwayaba icha kwa mwana wa Adamu. ");
INSERT INTO ndg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nga bandunabele baba kung'unda-yumo alowa tolelwa ni ywenge kalekelwa. ");
INSERT INTO ndg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Anwawa abele balowa bakusangi pamope yumo atolelwa ni ywenge kalekwa. ");
INSERT INTO ndg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kwa eyo, mube mminyo kwa mwanja mutangite kwaa lisoba gani lwabuya Ngwana witu. ");
INSERT INTO ndg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lakini mutangite panga, ipangite mwene nyumba akatanga saa ilenga mwii apala icha, apelekeleka na alowe yeketya kwa nyumba yake bamomwe. ");
INSERT INTO ndg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwa eyo, mupalikwa ba tayari, kwo panga mwana wa Adamu alowa isa kwa masaa ga mukotwike tanga. ");
INSERT INTO ndg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tubwe nyai ywabii mwaminifu, mmanda mwene lunda, ywapeyilwe madaraka na Ngwana kwa babile munyumba yake, linga apei chakulya kwa muda wofaika? ");
INSERT INTO ndg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Atibarikiwa mmanda ywoo, aywo Ngwana wake alowa kukolya kapanga nyoo papala buya. ");
INSERT INTO ndg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kweli nenda kuwamakiya Ngwana na alowa kum'beka kunani ya kila kilebe cha kibii chake. ");
INSERT INTO ndg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lakini mana itei mmanda mmaya kabaya pamwoyo wake,'Ngwana wango atiselewa. ");
INSERT INTO ndg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nga tubwa kwakombwa atumishi bake benge, na kalya na kalobya wembe, ");
INSERT INTO ndg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ngwana wake mmanda ywoo palowa isha lisoba lyakotwike tanga, na saa yakotwike tanga. ");
INSERT INTO ndg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ngwana wake alowa kunketani ipande ibele ni kummeka nafasi yimo na anafiki na kwaba na kilelo no taunya mino. ");
INSERT INTO ndg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nga upwalume wa kumaunde ulandine ni aija komi babapotwi taa yabe no boka yenda kupokya ngwana arusi. ");
INSERT INTO ndg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Atano nkati yane babile apumbafu ni atano benge babi bene lunda. ");
INSERT INTO ndg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Balo ainja apumbafu bapotwi taa yabe, bapotwi kwaa mauta. ");
INSERT INTO ndg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bali balo atano aelevu bapotwi taa ni mauta. ");
INSERT INTO ndg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tubwe wakati ngwana arusi pacheliye icha, bote lwatweti lungono no gonjanga. ");
INSERT INTO ndg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lakini kilo cha kungoko kwabi na ndoti, linga, ngwana arusi, mupangite panja mukampoki'. ");
INSERT INTO ndg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nga abo bainja bote bayumwike no washa taa yabe. ");
INSERT INTO ndg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Balo apumbafu baabakiye balo bene lunda, Mutupongoli mauta ginu mwanja taa yitu yenda imika'. ");
INSERT INTO ndg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini balo bene lunda batikwayangwa na kwabakiya,'Ngatulengani twa bene ilabu yende dukani mukapeme kiasi kwaajili yinu. ");
INSERT INTO ndg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wakati kabayenda pema, ngwana arusi kaicha, na bote babile tayari bayei nakwe muukumbi wa sherehe ya arusi, na nianga watiyigalwa. ");
INSERT INTO ndg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Baadae balo ainja wenge pia kababuyangana na kababaya,'Ngwana, ngwana, utuyogoli.' ");
INSERT INTO ndg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lakini atikwayangwa ni kuwabakiya,'kweli nenda kwamakiya, nenga niatangite kwaa mwenga.' ");
INSERT INTO ndg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kwa eyo mulinge, mana mutangite kwaa lisoba au saa. ");
INSERT INTO ndg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kwa kuwa kati mundu ywa yei nema wa kutalu. Akemite atumwa bake ni kwapeya utajiri wake. ");
INSERT INTO ndg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yumo wabe ampei talanta tano, ywenge ampei talanta ibele, ni yolo ywenge ampei talanta yimo. Kla mundu apeyilwe lengana na uwezo wake, na yolo tajiri atiboka mwanja wake. ");
INSERT INTO ndg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mapema yolo apeyilwe talanta tano ayei kwizungusha, no kwizalisha talanta zenge tano. ");
INSERT INTO ndg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nyonyonyo yolo apeyilwe talanta ibele, atizalisha zenge ibele. ");
INSERT INTO ndg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini yolo mmanda apeyilwe talanta yimo, ayei kachake, ayei kwiebya lembwa na kwikulya ela ya ngwana wake. ");
INSERT INTO ndg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Na baada ya masoba peta, ngwana wa amanda abo atibuya nabalanga hesabu nabo. ");
INSERT INTO ndg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yolo mmanda ywapeyilwe talanta tano kaisa ni kumpeya talanta zenge tano, kabaya,'Ngwana, unipeile talanta tano. Linga, nipatike faida yenge tano.' ");
INSERT INTO ndg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ngwana wake atikummakiya,'Sapi sana, wa mmanda wananoga na uaminike! ubile na uaminifu kwa ilebe njene. Nilowa kukupeya utawala kwa ilebe yanansima. Ujingii mupuraha ya Ngwana wako.' ");
INSERT INTO ndg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mmanda ywa apoki talanta ibele kaisa ni kubaya,'Ngwana, unipeyile talanta ibele, linga nipatike faida ya talanta zenge ibele. ");
INSERT INTO ndg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ngwana wake kammakiya,'Hongera, mmanda unoyite ni mwaminifu! Ubile mwaminifu kwa ilebe njene. Nipala kukupeya madaraka kunani ya ilebe yote. Jingya mupuraha ya ngwana wako.' ");
INSERT INTO ndg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Baadae yolo mmanda ywapoki talanta yimo nembe kaisa no baya,'Ngwana, nikutangite panga wenga wa mundu wa nkale, uuna pange panda. ");
INSERT INTO ndg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nenga natiyogopa, natiyenda kasango no iya talanta yako pae. Linga, ubile nayo pano yelo yaibile yako.' ");
INSERT INTO ndg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lakini ngwana wake kayangwa no baya,'wenga, wa mmanda muou ni nzembe, watangite panga niuna pandu panikotwike panda no una pange lema. ");
INSERT INTO ndg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bola ngabeka talanta yango kwa bandu ba benki, ni wakati wa kubuya kwango mbaitepokya talanta yango pamope ni faida. ");
INSERT INTO ndg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tubwe mumpokonye ayo talanta ni mumpei yolo mundu ywabile na talanta komi. ");
INSERT INTO ndg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kila mundu ywabile nacho, alowa yongelekwa hata kwotweleya muno. Lakini ywange ba nacho alowa pokonyolwa. ");
INSERT INTO ndg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Muntaikwe panja palubendo aywo mtumwa ywange faika, nakwo kwabana kilelo no sagamino. ");
INSERT INTO ndg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wakati mwana wa Adamu paisa mu'utukufu wake na malaika bote pamope na bembe, ngatama pakitengo chake cha utukufu. ");
INSERT INTO ndg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mataifa gote balowa kusanyilwa nnonge yake, najwembe alowa kwabawa bandu, kati mchungaji mwabawa bwii na ngondolo. ");
INSERT INTO ndg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Alowa kwabeka ngondolo luboko lwake lwakumalyo, ila mwii alowa kwabeka luboko lwa kukeya. ");
INSERT INTO ndg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Alapu mpwalume alowa kwabakiya balo bababile luboko lwake lwakumalyo,'Mwise, mwamubakilwe na Tate bangu ba kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwa mwanja nabile ni njala mwanipei chakulya, nabi na ng'eni mwatikunkaribisha; ");
INSERT INTO ndg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nabi na bula na mwambei ngobo; nabile nangonjwa mwatinitunza. Nabile natabilwe ni munilekite.' ");
INSERT INTO ndg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nga bene haki kabannyangwa ni kummakiya,'Ngwana, lisomangani lyatubweni wi njala, na kukupeya chakulya? au ubi na nyota tukupei mase? ");
INSERT INTO ndg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na lisoba ngani tukubweni wiwang'eni, na twatikukaribisha? Au ubi na bula tukupei ngobo? ");
INSERT INTO ndg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na lisoba gani twakubweni watamwe, au utabilwe, twaisi kukulola. ");
INSERT INTO ndg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na mpwalume alowa kwayangwa na kwabakiya,'Kweli nenda kuamakiya, cha mupangite pano kwa yumo wa nongo bango achunu, mwanipangii nenga.' ");
INSERT INTO ndg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nga alowa kwabakiya balo bababile luboko lwake lwakunkeya,'Mubokange kachango, mwamulanilwe, muyende kumwoto wange yomoka wautayarishwe kwaajili ya nchela na malaika bake. ");
INSERT INTO ndg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwa mwanja nabi na njala mwambei kwa chakulya; nabi na nyota mwabei kwa mache gonywa. ");
INSERT INTO ndg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nabi na ng'eni mwangalibishwe kwaa; nabi na bula mwambei kwaa ngobo, nabi naatamwe na natitabilwa, lakini mwaisi kwa kunilola! ");
INSERT INTO ndg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nga nabo nembe balowa kun'yangwa na kumakiya,'Ngwana lisoba gani tukubweni ubile na njala au ubile na nyota au wang'eni, au ubile bula au ubi waatamwe, au utabilwe, na tukuhudumiye kwaa? ");
INSERT INTO ndg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mwisho alowa kwayangwa na kwabakiya, kweli nenda kumakiya, chelo chamukotwike kwapangya jumo ywa balo bana, mwambaki kwa nenga. ");
INSERT INTO ndg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aba balowa yenda katika adhabu yangeyomoka ila bene haki katika uzima wange yomoka. ");
INSERT INTO ndg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wakati Yesu ayomwi longela malongelo goti, abakiye anapunzi bake, ");
INSERT INTO ndg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mutangite baada ya masoba gabele kwalowa baa na lisoba lya pasaka, na mwana wa Adamu apiyilwa linga bakongele.” ");
INSERT INTO ndg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Baada ya bakuu ba makuhani ni apindo ba bandu bakwembanike pamope mu'ukumbi wa kuhani nkolo, ywakemelwage Kayafa. ");
INSERT INTO ndg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kwa pamope bapangite mpango wa kumoywa Yesu kwa siri na kumulaga. ");
INSERT INTO ndg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mana batibaya, kana ipangike lisoba lya sikukuu, yakana yoka puyo kwa baadhi ya bandu.” ");
INSERT INTO ndg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wakati Yesu paabile Bethania mu'nyumba ya Simoni ywabile nkoma, ");
INSERT INTO ndg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","pagoloki pameza, nnwawa yumo aisi kachake abile apotwi kikoba chakibile na mauta ga garama ngolo, aijitii mu mutwe wake. ");
INSERT INTO ndg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lakini anapunzi bake bapakibweni kitendo choo, batichukya muno no baya, mwanja namani upangite nyoo. ");
INSERT INTO ndg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aga tulowe weza pemeya kwa kiasi kikolo na kwapeya maskini.” ");
INSERT INTO ndg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Lakini Yesu ayomwile tanga lee, ngababakiya, “Mwanza na matusuluya nnwawa yoo? kwa kuwa apangite kilebe kinanoga kasango. ");
INSERT INTO ndg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Maskini mubile nabo kila lisoba, lakini mutama kwaa na nenga kila lisoba. ");
INSERT INTO ndg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kwa mwanza panijili maula payega yango, apangite nyo kwa mwanza ya kunisika kwango. ");
INSERT INTO ndg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kweli nenda kwamakiya, popote payahubiliwa injili pakilambo chote, kitendo cha kipangite ayo nnwawa, chalowa pangilwa kwa mwaya kombokya.” ");
INSERT INTO ndg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nga yumo nkati ya balo komi ni ibele, ywakemelwa Yuda Iskariote, ayei kwa apindo ba makuhani, ");
INSERT INTO ndg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","no baya, “Mwalowa mbeya namani mana ninangile?” Ngaba mpemwa Yuda ipande thelathini ya mbanje. ");
INSERT INTO ndg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Buka muda wo apalange nafasi ya kwalangya. ");
INSERT INTO ndg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hata lisoba lya kwanza lya mikate yange lola, anapunzi banyendeli Yesu na kumakiya, “Kwaako kupala tukutayarishie ulye chakulya cha Pasaka?” ");
INSERT INTO ndg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ngabakiya, “Muyende mjini kwa mundu fulani na mumakiye, mwalimu abaya, “Muda wango uyomwike. Nicha yomolya pasaka pamope ni anapunzi bango munyumba yako.”” ");
INSERT INTO ndg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Anapunzi gabapanga kati Yesu mwalangile, batayarishe chakulya cha Pasaka. ");
INSERT INTO ndg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pasaka iikite kitamunyo, atami lya chakulya pamope na anapunzi bake balo komi ni ibele. ");
INSERT INTO ndg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pabile kabalya chakulya, atibaya, “Kweli nenda kwabakiya panga pakatikati yinu yumo apala kunisaliti. ");
INSERT INTO ndg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Batihuzunika muno, na kila yumo ande kunaluya, “Nenga buli kwa, Ngwana?” ");
INSERT INTO ndg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kayangwa, aywo ywasanja pamope na nenga mubakuri ngalowa kunisaliti. ");
INSERT INTO ndg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Adamu endabuka, kati mwaiandikilwe. Ila ole wake mundu ywasaliti mwana wa Adamu! Yanogite bora mundu ywo akakotoka belekwa.” ");
INSERT INTO ndg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda ywapala kusaliti atibaya, “Je, nenga mwalimu?” Yesu kammakiya, “Ngawenga wolongela.” ");
INSERT INTO ndg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pababile kaba lya chakulya, Yesu autweli nkate, atikubariki, na metwana. Apei anapunzi bake no baya, “Mutole, mulye. Aye yega yango.” ");
INSERT INTO ndg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ngatola kikombe no shukuru, ngapeya no baya, Munye mwabote mukikombe chee. ");
INSERT INTO ndg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kwa mwanja aye maiyango yo lagano kwango, yaipenganika kwa sababu banansima kwa kwasamiya sambi. ");
INSERT INTO ndg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lakini nenda kuamakiya, nanywali kae matunda ya zabibu go, ata lisoba lelo lyana lowanywa pamope namwee ku'utawala wa Tate bango.” ");
INSERT INTO ndg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Payomwile yemba mwambo, batiboka yenda kukitombe cha mizeituni. ");
INSERT INTO ndg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Boka po Yesu atikwabakiya, “Kilo cheno mwabote walowa kwikobala kwa mwanja nenge, kwasababu itiandikilwa, Nalowa kukombwa mchungaji na ngondolo bakikundi basambalalika. ");
INSERT INTO ndg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakini baada yo yoka kwango, nalowa longolya yenda Galilaya.” ");
INSERT INTO ndg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lakini Petro atikummakiya, “Hata mana itei bote bakukani kwa mwanja ya makowe gagalowa kupata, Nenga nikukana kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kannyangwa, “Kweli nenda kuabakiya, kilo cheno ngoko nanome anabeka kwaa, alowa kunikana mara itatu.” ");
INSERT INTO ndg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro ngamakiya, hata mana itei waa na wenga, nikukana kwaa.”Na anapunzi bake benge bote babaite nyonyonyo. ");
INSERT INTO ndg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Baadae Yesu ayei nabo pandu papakemelwa. Gethsemane atikwabakiya anapunzi bake, “Mutame paa wakati paniyenda loba apo.” ");
INSERT INTO ndg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Apotwi Petro na bana abele ba Zebedayo ngatumbwa huzunika na sikitika. ");
INSERT INTO ndg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Boka po atikwabakiya, “Roho yango yenda minya muno, hata kiasi cho waa. Mwiigale papamukeshe loba nanee.” ");
INSERT INTO ndg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ayei nnonge pachene, kalola pae wa kukama, no loba, Tate bango, mana kewezekana, kikombe sekinipele, kana ipange kati mwanipala nenga, ila kati mwamupata mwee.” ");
INSERT INTO ndg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ngayendeya anapunzi kakolya bangonjike lugono, ngamakiya Petro, mwanja namani ukotwike keleka pamope na nee kwa lisaa limo? ");
INSERT INTO ndg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mukeleke mulobe linga kana uyingii mumajaribu. Roho ibile radhi bai, lakini yega ibii zaipu.” ");
INSERT INTO ndg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Atiboka kae mara yene ibele yoloba, “Tate bango, mana itei likowe lee ngwesa kwaa kulikwepa na lazima nikinyweli kikombe chee, mwamupendi mwenga itimii,” ");
INSERT INTO ndg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kaabuya kae aisi kwakolya bagonjike lugono, mana minyo gabe gabi matopau. ");
INSERT INTO ndg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ngabakiya kae kaboka ngayengda loba mara yenge itatu kabaya makowe gagalo. ");
INSERT INTO ndg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Baadae Yesu ayendeli anapunzi bake nakwabakiya, “Bado mugonjike na pomolya? Mulinge saa iegelile, mwana wa Adamu endasa litiwa mmokoya bene sambi. ");
INSERT INTO ndg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Muyumuke tuboke. Mulinge yolo ywapala kunisaliti aegelite.” ");
INSERT INTO ndg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wakati abibalo kalongela, Yuda yumo kati ya balo komi ni ibele, atiisa. kipenga sa bandu chatiisa nabo, kaliboka kwa apindo ba makuhani na apindo ba bandu. Baisi na mapanga na ndolonga. ");
INSERT INTO ndg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na mundu ywakusudie Yesu ampei ishara, atibaya, yoloywa nannoniya ngaywo. Mwamoywe.” ");
INSERT INTO ndg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mra ngaisa kwa Yesu no baya, “Salamu, mwalimu!”Nakunnoniya. ");
INSERT INTO ndg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu ngammakiya, “Webwiga lyango, Ulipange lelo lya likuletike,” Ngabaisa kumoywa Yesu na maboko gabe. ");
INSERT INTO ndg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lola, mundu yumo ywabile pamope ni Yesu, ngasolomwa kyembe na kumkombwa mmanda wa ntumwa nkolo na kukata likutu lyake. ");
INSERT INTO ndg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nga Yesu kaamakiya, “kelebuya lipanga lyako mulupata lwake. Kwa mwanza bote babatumya lipanga balowa polota kwa lipanga. ");
INSERT INTO ndg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Muwasa panga ngwesa kwaa kwakema Tate bango, naywembe alowezekunilumya majeshi zaidi ya komi ni ibele ba malaika? ");
INSERT INTO ndg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lakini kwa kitiwi gagaandikilwe gaweza timya, aga ngagapalikwa gapiti?” ");
INSERT INTO ndg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wakati woo Yesu kakikoya chelo kipenga sa bandu, “Mbona mwisi na mapanga na mandolonga kuniboywa kati na mwii? Kila lisoba natami muhekalu kanipundisa, mwaniboywi kwaa! ");
INSERT INTO ndg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lakini aga gote gapangike lenga maandiko ya manabii gatimii.” Nga anapunzi bake kabanneka ni kabatila. ");
INSERT INTO ndg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Balo babamoywile Yesu bampeike kwaa Kayfa, kuhani nkolo, pandu pabakusanyike aandishi na apindo babile bakusanyilwe pamope. ");
INSERT INTO ndg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lakini Petro atikukengama msongo kwakutalu mpaka mukumbi wa kuhani nkolo. Ajingii munyumba notama pamope na alinzi akibone chakilowa pangila. ");
INSERT INTO ndg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bai apindo amakuhani na baraza lyote babile kabapala ushaidi wa ubocho kwa Yesu, lenga bate kumulaga. ");
INSERT INTO ndg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ijapo bapitike mashahidi banansima, lakini bapatike kwa sababu. Ila baadae mashaidi abele bati kwipiya nnonge ");
INSERT INTO ndg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","no baya, “Mundu yo atibaya “Ngwesa kulibomwana hekalu lya Nnongo na kuchenga kwa masoba gatatu.” ");
INSERT INTO ndg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kuhani nkolo kayema ni kunaluya, “Huweza kwaa yangwa? Hababakushitakya namani wenga?” ");
INSERT INTO ndg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini Yesu atami liki. Kuhani kulo ngamakiya, “Kati Nnongo mwabile, nenda kulasimisha utubakiye, panga wenga wa Kristo, wa mwana wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kayangwa, “Wenga wa mwene ubaite likowe lyo. Lakini enakubakiya, boka sayeno no yendelya wamona mwana wa Adamu atami kuluboko lwa mmalyo lwene ngupu, na kaida mu maunde ga kunani.” ");
INSERT INTO ndg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nga kuhani nkolo kalendwana ngobo yake no baya, Atikupuru! Je, tupala kae ushahidi wakele? Linge, tayari muyowine kakufuru. ");
INSERT INTO ndg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Je! muwaza namani? Ngabayangwa no baya.”Ipalikwa awee.” ");
INSERT INTO ndg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ngaba mwuniya mata kuminya na kukombwa makofi kwa maboko gabe, ");
INSERT INTO ndg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","no baya, ututabilie wenga wa Kristo. Naiywa kukombwile?” ");
INSERT INTO ndg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wakati wo Petro atami panja kuhukumbi, amanda alwawa batikunnyendelya no baya, “Wenga wabi pamope ni Yesu wa Galilaya. ");
INSERT INTO ndg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lakini atikana nnonge yabote, ngabaya nee nitangite kwaa chaakibaya.” ");
INSERT INTO ndg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Payei pannango, mmanda ywenge nwawa atikumona na kwabakiya bababile apo,'Mundu yoo nembe abile pamope ni Yesu wa Nazareti. ");
INSERT INTO ndg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ngankana kae kwa kulapa, “Nenga nintangite kwaa mundu yolo.” ");
INSERT INTO ndg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Muda mwipi baadae, balobabayemi karibu, batiyenda yolongela ni Petro, kwa kweli wenga wipamope nakwe, kwa mana hata longela kwako kwenda yowanika. ");
INSERT INTO ndg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nga tumbwa lapangwa no lapa,'Nenga nitangite kwa mundu yoo,” Mara ngoko kabeka. ");
INSERT INTO ndg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petro kakombokya makowe gamakiye Yesu. Pai panga kabla ngoko anabeka kwaa walowa nikana mara itatu. Ngapita panja kono kalela. ");
INSERT INTO ndg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pabaikite kindae, akolo bote ba Makuhani ni apindo ba bandu babile ni njama kwaajili ya Yesu linga bamulage. ");
INSERT INTO ndg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Batikuntaba, batikunongoya, na kumwikiya kwa liwali Pirato. ");
INSERT INTO ndg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Boka po wakati Yuda, ywabile atikunsaliti, amweni panga Yesu bayomwile kumwukumu, atijuta no kelebuya ipande thelathini ya mbanje kwa akolo ba makuhani na apindo, ");
INSERT INTO ndg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","no baya, “Nipangite sambi kwa kwisaliti mwai yange makosa.” Ngaban'yangwa, “Twena ituhusu namani? ugalinge ago wa mwene.” ");
INSERT INTO ndg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Boka po kaitakulya pae yelo ipande thelathini ya mbanje muhekalu, kabuka kachake kwikongela mwene. ");
INSERT INTO ndg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nkolo wa Makuhani atikuitola yelo ipande thelathini ya mbanje no baya, “Halali kwaa kwibeka mbanje yeno mu'hazina, mana yabile garama ya mwai.” ");
INSERT INTO ndg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Batikujadilyana kwa pamope batikwitola yelo ipande thelathini ya mbanje batumi kupema mgunda wosikiya ageni. ");
INSERT INTO ndg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kwasababu yelo mgunda woo walowa kemelwa, “Mgunda wa mwai” mpaka leno. ");
INSERT INTO ndg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Linga lelo likowe lyaalongei nabii Yeremia latimii, kabaya, “Batwelile ipande thelathini ya mbanje, garama yaipangilwe ni bandu ba Israel kwaajili yake, ");
INSERT INTO ndg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ni baatumi kwa mgunda wa mfinyanzi, kati Ngwana mwaanibakiye.” ");
INSERT INTO ndg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nga Yesu ban'yemike nnonge ya liwali, na liwali atikunaluya, “Wenga wa mpwalume wa Ayahudi?” Yesu kayangwa, “Wenga wabaya nyoo.” ");
INSERT INTO ndg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lakini pabansitaki akolo ba Makuhanini apindo, ayangwi kwaa kilebe chochote. ");
INSERT INTO ndg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Boka po Pilato kammakiya, “Uyowine kwaa masitaka goti kunani yako? ");
INSERT INTO ndg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lakini anyangwi kwaa hata likowe limo, liwali atisangala muno. ");
INSERT INTO ndg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yabile mu'sikukuu kati yabile desturi ya liwali kunyogolya mtabilwe yumo ywabachalwa no kipenga sa bandu. ");
INSERT INTO ndg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Muda woo abile mtabilwa sugu lina lyake Baraba. ");
INSERT INTO ndg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tubwe pabakwembine pamope, Pilato atikwalaluya, Nyai ywamupala ninyogoli kwa hiyali yinu?”Baraba au Yesu ywaikema Kristo. ");
INSERT INTO ndg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwa mana atangite panga bammoywe kwa kunchukya. ");
INSERT INTO ndg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Patami pakitego chake cha hukumu, nyumbowe atumite neno kabaya, “Kana upange likowe lyolyote kwa mundu ywange hatia. Mana nititeseka muno mundoto ya leno kwa mwanja ywembe.” ");
INSERT INTO ndg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tumbwe akolo ba Makuhani ni apindo, batikwakingindwa bandu bannobe Baraba, na Yesu bamulage. ");
INSERT INTO ndg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Liwali atikwalaluya, “Kati ya haba abele ywako nin'yogolii?” Ngababaya, “Baraba.” ");
INSERT INTO ndg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kaabakiya nipange kele kwa Yesu ywakemelwa Kristo?” Bote kabanyangwa, “Anyongelwe.” ");
INSERT INTO ndg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ni ywembe kabaya, “mwanja namani, kosa gani lyaapangite?”Ngabatondobiye lilobe kabakemelya, “Anyongolwe.” ");
INSERT INTO ndg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kwa eyo wakati Pilato paibweni aweza kwaa panga kikowe chochote, ila furugu yende tumba, atweti mache auluwi maboko gake noge yabe, no baya, “Nenga ntopo atiya kwa mundu yoo ywange likosa. Mugalinge gaa mwabene.” ");
INSERT INTO ndg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bandu bote kababaya, “Mwai yake ibe kun ani yitu na bana bitu.” ");
INSERT INTO ndg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Boka po anyogoli Baraba kasabe, lakini akombwi ni mjeredi Yesu atikwapeya kwabe bayende kusulubilwa. ");
INSERT INTO ndg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ni askari ba liwali kabantola Yesu mpaka Praitorio na likundi lya maaskari bote batikusanyika. ");
INSERT INTO ndg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kabamwulike ngobo yake na kungwalika likanju lya rangi ngele. ");
INSERT INTO ndg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Boka po ngabatengeneza lukamba lyene mimimwa ni kulibeka nnani ya ntwe wake, ni kubonikiya nai muluboko lyake lwa kumalyo. Bapigite magoti nnongi yake kaban'geya, kababaya, “Twenda kusalimu, Mpwalumea Ayahudi?” ");
INSERT INTO ndg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ngaba muniya mata, ngatola nainkabankombwa mutwe. ");
INSERT INTO ndg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Muda kabayendelya kunkebei gaba mwula ngobo yake, nganongoya yenda kukongela. ");
INSERT INTO ndg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pabapitike panja, bamweni mundu yumo boka Krene lina lyake Simeoni, batikunlasimisha alongwane nabo lenga atweti nsalaba wake. ");
INSERT INTO ndg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pabaikite pandu papakemelwage Goligotha, mana yake, “semu yalipakala lya ntwe.” ");
INSERT INTO ndg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kabampei siki yayengabanike ni nongo aywe. lakini paipayite nywele kwaa. ");
INSERT INTO ndg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Muda kabansulubisha, bangine ngobo yake kwa kwipigya kura. ");
INSERT INTO ndg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na batitama ni kunnola. ");
INSERT INTO ndg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nnani ya ntwe wake paandikilwe gastakilwe kangasomeka, “Ayo nga Yesu, mpwalume Ayahudi.” ");
INSERT INTO ndg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Anyang'anyi abele batikwakongela pamope ni ywembe, yumo upande wa kumalyo ni ywembe wa kunkeya. ");
INSERT INTO ndg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Balo bababile kabapeta palobende kaban'geya, kabatikisa mitwe gabe, ");
INSERT INTO ndg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","no baya, “Wenga wa upalange kulibomwana hekalu ni kulichenga kwa masoba gatatu, “Wilopwe wa mwene! Mana itei wa mwana wa Nnongo, uuluke pae uboke mu'nsalaba!” ");
INSERT INTO ndg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kati ya hali yeyelo akolo ba makuhani babile bakin'geya, pamope ni baandishi ni apindo, no baya, ");
INSERT INTO ndg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Aokowile banansima, lakini aweza kwaa kwilopwa mwene. Jwembe mpwalume Ayahudi. Auluke pae boka munsalaba, nga twamwamini. ");
INSERT INTO ndg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Atikuntumaini Nnongo, leka Nnongo anopwe nambi yambe mana kapala, kwa mwanja atibaya Nenga na mwana wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na balo anyang'anyi babauyongilwe pamope ni ywembe balongei makowe gakun'geya. ");
INSERT INTO ndg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Buka saa sita kwabi ni lubendo nnema wote mpaka saa tisa. ");
INSERT INTO ndg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Payaiikite saa tisa, Yesu kalela kwa lilobe likolo, “Eloi, Eloi, lama thabakithan?” mana yake Nnongo wango, Nnongo wango, mbona wenda nileka?” ");
INSERT INTO ndg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wakati woo baadhi yabe babile bayemi palo kababekaniya, kababaya, “Ankema Eliya.” ");
INSERT INTO ndg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mara jimo yumo ywabe atibutuka yotola sifongo kwitweleya kinyo kikale, ngabaibeka nnani ya nkongo ni kumpeya anywe. ");
INSERT INTO ndg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nababaigalile kabakiya, “Muneke kichake, lulole panga Eliya apala isa kunopwa.” ");
INSERT INTO ndg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Boka po Yesu atilela kae kwalilobe likolo na awile. ");
INSERT INTO ndg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Linga, pazia lya hekalu ngalipapwanike ipande ibele boka kunani mpaka pae. Ni nnema watilendema na miamba yatipapwanika ipande. ");
INSERT INTO ndg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Makaburi ngayongoka, na yega ya atakatifu banansima babaginjike kabayoka buka mu kiwo. ");
INSERT INTO ndg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Batipita mumakaburi baada ya kuyoka kwabe, kabayingii mu mji mpeletau, batibonekana na bandu banyansima. ");
INSERT INTO ndg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bai yolo akida ni balo bababile kabannola Yesu babweni lilendemo ni makowe goti yapangike palo, batiyogopa muno no baya, “Kweli ayo abile mwana wa Nnongo.' ");
INSERT INTO ndg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Alwawa banansima babankengime Yesu boka Galilaya linga kumudumia babile palo kabanlolekeya boka kutalu. ");
INSERT INTO ndg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nkati yabe abile Mariamu magdarena, Mariamu mao bake Yakobo na Joseph, na mao bake Zebedayo. ");
INSERT INTO ndg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Paikite kitamunyo, aichi mundu tajiri boka Arimathayo, lina lyake Yusufu, nembe kae ywabile mwanapunzi wa Yesu. ");
INSERT INTO ndg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Anyendeli Pilato kunnoba bwega wa Yesu, Pilato atilagya apeyelwe. ");
INSERT INTO ndg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu apeyilwe bwega ni aubilingile ni ngobo ya sufi inoyite, ");
INSERT INTO ndg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ayei kusika mulikaburi lya yambe lyake atikulichonga muliwe. Ngaimbiliya liwe likolo ngaliwekelya pannyango wa likaburi kaboka kachake. ");
INSERT INTO ndg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariamu magdarena ni Mariamu yolo ywenge babile palo, watitama kabalolekeya kulo kulikaburi. ");
INSERT INTO ndg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lisoba lyenge lyabile lya maandalio, akolo ba makuhani na Mafarisayo batikwembana pamope kwa Pilato. ");
INSERT INTO ndg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kabammakiya, “Ngwana, tukomboki panga wakati yolo mmocho abile nkoti, atibaya,'Baada ya masoba ga tatu alowa yoka kae,' ");
INSERT INTO ndg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwa eyo ulangi panga likaburi bakalilende libesalama mpaka masoba gatatu, Yalowa wezekana, anapunzi bake baweza kun'yiba no baya kwa bandu, atiyoka boka mu kiwo! no ubocho wa mwisho walowa mbaya kuliko wa kwanza. ");
INSERT INTO ndg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kaayangwa, “Mutole alinzi. Muyende mkapange kati mwa muweza. ");
INSERT INTO ndg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ngabatiyenda no kulipanga likaburi panga salama liwe balikombwi muhuri na kubeka alinzi. ");
INSERT INTO ndg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Paikite kitamunyo cha lisoba lya sabato, liumu lyabile liyomoka, kuyenda lisoba lya kwanza lya wiki, Mariamu magdalena, ni yolo Mariamu ywenge batiisa kulilolekeya likaburi. ");
INSERT INTO ndg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Linga pabile ni lilendemo ngolo, kwa kuwa malaika ba Ngwana atiuluka ni kulimbilingiya lelo liwe, ni kulitamya. ");
INSERT INTO ndg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sura yake yatimelemetya kati umeme, ni ngobo gake gabile gai'uu kati theluji. ");
INSERT INTO ndg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Balo alinzi kabayogopa muno no panga kati batiwaa. ");
INSERT INTO ndg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yolo malaika kaabakiya balo alwawa kabaya, “Kana muyogope kwa mana nitangite sa mukipala Yesu, ywasulubilwe. ");
INSERT INTO ndg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Abile kwaa pano, ayokile kati mwaamakiye, Muiche mulole pandu agonjike. ");
INSERT INTO ndg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Muyende upesi mukaabakiye anapunzi bake,'Ayokile boka mu kiwo, linga alongwiye Galilaya akwo ngamwalowa kumona.'Linga nenga niamakiye.” ");
INSERT INTO ndg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Balo alwawa boti baboite palo palikaburi upesi babile ni hofu ni puraha ngolo, ni kababutuka kwabakiya anapunzi bake. ");
INSERT INTO ndg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Linga Yesu kakolyana nabo no baya, “Salamu.”balo alwawa batiisa kunkamwa magolo gake, na kumwabudu. ");
INSERT INTO ndg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu kaabakiya, “Kana muyogope, muyende mukaabakiye alongo bango balongoli Galilaya. Akwo banibona. ");
INSERT INTO ndg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wakati balo alwawa babile kabayenda na baadhi ya alinzi bayei mjini no kuabakiya akolo ba Makuhani makowe goti gabile gapangike. ");
INSERT INTO ndg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na makuhani pababile bakwembine ni apindo na kulijadili likowe lee pamope na bembe, papiyite mbanje yanansima kwapeya balo alinzi, ");
INSERT INTO ndg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","no kwabakiya, kana mwabakiye bandu panga, anapunzi bake Yesu baisi kilo kujiba bwega wa Yesu wakati twenga tugonjike.' ");
INSERT INTO ndg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Abali yee mana itei kwa liwali, twanga twenga twalowa nshawishi na kumoya mwenga mashaka goti.” ");
INSERT INTO ndg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kwa eyo balo askari kabaipokya yelo mbanje na panga kati mwababakiywe. Habari yee yatitangazilwa muno kwa Ayahudi na baaminiya nyoo mpaka leno. ");
INSERT INTO ndg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lakini balo mitume komi ni jimo bayei Galilaya, palo pakitombe payomwi kwabakiya. ");
INSERT INTO ndg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na bembe pabamweni, batikumwabudu, ila baadhi yabe babile ni mashaka. ");
INSERT INTO ndg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu aisile kasabe kabakokeya no baya, “Nipeyilwe mamlaka goti ga kilambo na kumaunde. ");
INSERT INTO ndg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kwa eyo muyende mukabapange mataifa goti kuba anapunzi bango. mukaabatize kwa lina lya Tate, na lya mwana, na lya Roho mpeletau. ");
INSERT INTO ndg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Muapundishe kugatii makowe goti ganibaamuru, Na linga, nenga nibile pamope ni mwenga masoba goti, mpaka mwisho wa dunia. ");
INSERT INTO ndg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gono mwanzo wa Injili ya Yesu Kirisitu, mwana wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kati mwaiandikwe ni nabii Isaya, Lola nandokubatuma asenga bango kulonge yinu, yumo apetwaa ndela yako. ");
INSERT INTO ndg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lukalanga wa mundu kakema mpongote, yomolyae ndela Bwana; boneyaye ndela yake”. ");
INSERT INTO ndg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana ateisa, kabaatiza mpongote ni kuyegana ubatizo wa toba ku mzamaa wa sambi. ");
INSERT INTO ndg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nnema nzima wa Sudea ni bandu bake ba Yerusalemu bayei kwake. Bai kababatizwa ni ywembe mulupondo Yordan, kabaungamana masambi gabe. ");
INSERT INTO ndg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana awalage ngobo ya mayunzu ga ngamia ni nkibuno mkwisi was likengo, na alyage busi wa mwitu. ");
INSERT INTO ndg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Atelongela ni ukoya, “Abi yumo Ando isa kuoma nee, abi ni ngupu kuliko nee, nipwaa kwa ha Lita pae kuundua ilatu yake. ");
INSERT INTO ndg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nenga niabatza kwa Mase, Ywembe abatiza mwenga kwa roho mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yaomi lisiku eyo Yesu aisi kuoma Nazareti ya Galilaya, na atebatizwa ni roho mulupondo Yordani. ");
INSERT INTO ndg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu yaagakatwike kuoma mmase abweni kunani kusalanike pala ni roho kauluka pae kunaniyake kati ngunda. ");
INSERT INTO ndg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ni lukalanga waomi kunani, “wenga wa manango mpendwa. Nandopulaika muno ni wenga”. ");
INSERT INTO ndg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Mara yimo roho atikunnasimisa ayende mpongote. Aabii mpongote lisiku arobaini, kagiywa ni nsela. Ai pamwepe ni igongoro ya mmwitu, ni malaika kabanlola. ");
INSERT INTO ndg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tubwe kumona kuboyolwa kwa Yohana, Yesu aaisi Galilaya katangasa Injili ya Nnongo, ");
INSERT INTO ndg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kaakoya “muda uike, ni upwalume wa Nnongo uisi. Mubuye kwa Nnongo ni muamini mwinjili. ");
INSERT INTO ndg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ni kaapeta mmbwega ya mbwani ya bahari ya Galilaya, kaammona Simoni ni Andrea alongo bake Simoni kabataga mbelele yabe mmase, kwakuba baisi aubaji. ");
INSERT INTO ndg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu abalogoli “muise, mungote, na niatenda aubaji ba bandu”. ");
INSERT INTO ndg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mara yimo baalei mbelele ni kunkota. ");
INSERT INTO ndg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wakati Yesu ayei kutalu kasunu, ni kaammona Yakobo mwana wake Zebedayo ni YohanaNnunage, bai nngalaba kabapota mbelele. ");
INSERT INTO ndg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","mara kabaakema ni bembe kabanleka tate babe nngalaba ni atenda kasi benge, kabankota. ");
INSERT INTO ndg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Apobaike Kaperaniamu lisiku ya sabato, Yesu kayingya mulisinagogi ni kuyegana. ");
INSERT INTO ndg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Batekanganya liyegano lyake kwa yelyo abi kayegana kati mundu abi ni upwalume na ayendana kwa ni aandishi menge. ");
INSERT INTO ndg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Muda gogo kwabi ni mundu mulisinagogi labe abi no nsela na ateguta. ");
INSERT INTO ndg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kaakoya “tubi ni selosa utenda nimwenga, Yesu wa Nazareti? uisikutuangamisa? Nandokututaga nyai wenga. Wenga wantakatifu yikayako kwa Nnongo!” ");
INSERT INTO ndg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu kaankopokya nsela ni kukoya “Nyamala ni uboke nkati yake!” ");
INSERT INTO ndg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ni roho njapu kantomboya pae ni kupita kalele kwa liyobe la kunani. ");
INSERT INTO ndg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nibandu bote batekanganya eyo kabalokiyana kila yumo, “Seno kele? liyegano lyaayambe libiniupwalume? Ni nsela kunkota ago akoya!” ");
INSERT INTO ndg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nimayegeyo kuhusu ywembe mara yimo yalitawala kila nsengo nnema nsima wa Galilaya ");
INSERT INTO ndg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mara yimo baada ya kupita kunza ya Lisinagogi, Baayingi ukaya kwa Simoni ni Andrea bai ni Yakobo ni Yohana. ");
INSERT INTO ndg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sasa akibe alwawa Simoni abiagonzike kabinya homa, mara yimo kabankokeya Yesu ubinye wake. ");
INSERT INTO ndg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Eyo kaisa, kankamwa luboko, Ni kunkagatuya, homa yaboi muyega yake ni utumbwa uudumya. ");
INSERT INTO ndg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kitamunyo eyo lisoba liwile Abinye bote baaletikwe kwake, au babi Ni nsela kumutwe. ");
INSERT INTO ndg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nnema nsima baikonzike pamwepe pa nlyango. ");
INSERT INTO ndg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Atealagwa Abinye banyansima mabinye mbalembale ni kupiya nsela(mahoka) banyansima, aakani mahoka kulongela maana batekuntanga. ");
INSERT INTO ndg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Aayumwike bwamba muno lubendo lukatama; aaboi ni kuyenda pandu abonekane kwa Ni mundu na kayopa oko. ");
INSERT INTO ndg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni ni bote baipamwepe ni ywembe baankotike. ");
INSERT INTO ndg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Baammweni ni kunkokeya “kila yumo andokupala”. ");
INSERT INTO ndg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Atekubabakiya, “Tuboke kundukwenge, kunza ya gono nnema, ili niwese ulongela ni uko iyeya. Ndio mwalongo was kuisa pano. ");
INSERT INTO ndg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayei kapeta Galilaya yote, kalongela mmasinagogi yabe Ni kukemea mahoka. ");
INSERT INTO ndg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kaisa mundu yumo abi ni ukoma. Abi kampembela; aatengwi majua ni kunkokeya”Mana kaupala tenda nibe na nkoto”. ");
INSERT INTO ndg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","San'yingikiya, Yesu katondobeya luboko lwake ni kunkamwa kankokeya, “nipala ubebwise”. ");
INSERT INTO ndg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mara yimo ukoma waamboi, katenda kuba bwiso. ");
INSERT INTO ndg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu atekunkopokya kwa ukale Ni kumbakiya ayende marayimo. ");
INSERT INTO ndg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Atekumbakiya, “kanaukoye liyaulyo kwa yeyoteywa, lakini boka ukajibineye kwa kuhani, Ni upiye dhabibu kwa utakaso Musa atelagiya, katiusaidi kwabe.” ");
INSERT INTO ndg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ateboka Ni kutumbwa kumbakiya kila yumo nikukoya liyaulyo muno hata Yesu awesome kwa lelo kuyingya pannema kwa uhuru. Eyo atami pandu pakiiyo ni bandu baisi kuoma kila nnema. ");
INSERT INTO ndg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Aabwi Kaperiniam baada ya siku nsunu, yayowine abiukaya. ");
INSERT INTO ndg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bandu banyansima muno bakusanyike batwelile mpaka pa nlyangoPai ntopo nafasi lelo, ni Yesu kabakokeya. ");
INSERT INTO ndg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Baadhi ya bandu baisi banletike mundu atetomboloka; bandu bane batekumpotwa. ");
INSERT INTO ndg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wakati basindikwe kumuegelya mwalo baibandu banyansima, baboiye lipala kunani palyo aabile, baapeninye lusase ni mundu mminye agonzike mumo. ");
INSERT INTO ndg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Apo abweni Imani yabe, Yesu kambakiya ywa mundu atombolwike, “manango, sambi sako zisameiwe.” ");
INSERT INTO ndg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aandishi benge balyo baatami palyo kabailokiya mmiyo yabe. ");
INSERT INTO ndg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Awesa buli mundu oyo kulongela iyeya? Andokupulu! Nyai awesa kusami sambi Mana Nnongo kwa bai yikayake?” ");
INSERT INTO ndg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu aatangike kumoyo wake eso bawasake bembe bene. Kabaakokeya, “mwalo wakele muwasa eyo mwiuba yinu? ");
INSERT INTO ndg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lipi litopike muno kulongela kwa mundu atombolwike, masambi gake gasameiwe au kukoya kagatuka, tola lusase lwako ni utyange? ");
INSERT INTO ndg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lakini bapate utanga kuba mwana wake Adamu abiniupwalume wa kusamii masambi pano padunia, ankokiye ywa atombolwike. ");
INSERT INTO ndg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nikukokeya wenga, yinuka tola ndanga yako, ni uyende ukasako.” ");
INSERT INTO ndg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kaakagatuka ni kutola ndanga yake, ni kupita panza bandu bote bapalyo kabakanganya na kabampaya Nnongo utukufu, tubi tunawai kwaa kubona kilebe kati Seno. ");
INSERT INTO ndg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ayei kumbwega ya ziwa, nibandu banyansima, boote balyo kabayegana. ");
INSERT INTO ndg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ya kaapeta kaammona lawi mwana wake Alfayo atami palyopakuya kodi na kaankoke ya “Ngota” kayinuka Ni kunkota. ");
INSERT INTO ndg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Palyo Yesu kalya kilalyo ukasake Lawi, Atola kodi bingi Ni bandu bene sambi bai kabalya ni Yesu ni benepunzi bake, kwa kuba bai bingi Ni bembe kabankota. ");
INSERT INTO ndg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wakati baandishi, amafarisayo, baabweni Yesu kalya ni bandu bene sambi ni atola kodi, kabaabakiya benepunzi bake”mwalo wakele alya ni atola kodi ni bene sambi?” ");
INSERT INTO ndg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Palyo Yesu aayowine kabaabakiya”bandu bene afya mwiyega yabe bampala kwa nng'anga, bandu Abinye yika yabe ndio bapala. Niisikwa kuakema bandu bene haki, lakini bandu bene sambi.” ");
INSERT INTO ndg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Benepunzi ba Yohana ni Amafarisayo baikabataba. Nibandu benge baisi kwake ni kunkokeya”mwalo wakile benepunzi ba Yohana ni Amafarisayo bando taba? Lakini benepunzi bako bataba kwaa? ");
INSERT INTO ndg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kabaakokeya “Je balyo bayei kuharusi bawesa kutaba mana ntolaji abipamwepe Ni bembe? Ntolaji mana abipamwepe ni bembe bawesa kwaa utaba. ");
INSERT INTO ndg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lakini lisiku ya kulonge ntolaji mana aboiywe kwabe, mulisiku eyo ni bembe bataba. ");
INSERT INTO ndg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ntopo Mundu wa usona kipande sa ngobo yayambe mulinzenga. eso kilaka kitama kwaa kipita bai omo mulinzenga. Ni kubeka mpapuko wa kuakala. ");
INSERT INTO ndg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ntopo Mundu wa kuyeya Divai yayambe Nviriba ya samani, vinginevyo Divai ya Tula iriba Ni vyote ibele Divai ni iriba ya oba. Beka divai yayambe mu iriba yayambe.” ");
INSERT INTO ndg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mulisiku ya sabato Yesu aapite mmigonda, Ni benepunzi bake baatumbwi kutola makondi ga ngano. ");
INSERT INTO ndg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ni mafarisayo bambakiye “Lola mwalo wakele batenda Kati iyeya kilebe Seno kiyendanakwaa ni sheria ya lisiku ya sabato?” ");
INSERT INTO ndg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kabaakokeya, “msomike kwa sa atei Daudi palyo aabile Ni njara-ywembe pamwepe ni bandu bake baipamwepe ni ywembe? ");
INSERT INTO ndg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yelyo ayei munymba ya Nnongo wakati Abathari aabikuhani Nkolo Ni kulya mkate wabikulonge-yabi kiogo ni sheria kwa mundu yeyote kulya isipokua kuhani-kabapaya Ni balyo aipamwepe nabo?” ");
INSERT INTO ndg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu akoiye”sabato batei mwalo was mundu, na mundu kwaa mwalo was sabato. ");
INSERT INTO ndg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Eyo mwana wa Adamu ni Bwana, eyo kwa sabato. ");
INSERT INTO ndg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ni iyeya ayingi nnyumba ya Lisinagogi ni omo abimundu abi Ni luboko lutombolwike. ");
INSERT INTO ndg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bandu benge baikabankota kwa karibu kulola atamponya lisiku ya sabato ili basitaki. ");
INSERT INTO ndg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","yesu kankokeya mundu mwene luboko lutombolwike”kagatuka ni uyeme, kati yabandu bano.” ");
INSERT INTO ndg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","kisha kabakokeya bandu, “je ni halali kutwnda liyaulyo linoike lisiku ya sabato au kutenda yasio ya haki, kulopwa maisha gabandu au kubulaga? lakini batami poloi. ");
INSERT INTO ndg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","kaabalola kwa hasira, kahuzunika mwalo wakunonopa iuba yabe, Ni kankokeya yeah mundu “Tondobeya luboko lwako.”katondobeya ni Yesu kaamponya luboko lwake. ");
INSERT INTO ndg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mafarisayo bayei panza kabatenda nzama Ni maherode dhidi yake ili bambulage. ");
INSERT INTO ndg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kisha Yesu, pamwepe ni benepunzi bake bayei baharini, ni bndu banyansima kabankota kabapeta Galilaya ni Uyahudi. ");
INSERT INTO ndg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ni kuoma Yeruselemu ni kuoma Idumaya ni kulonge ya Yorodani ni jirani ya Tiro na Sidoni, bandubanyansima, ya kuyowa eso akitei kila mundu aisi kwake. ");
INSERT INTO ndg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nakabankokeya benepunzi bake kuandaa ngalaba nzunu mwalo wake, mwalo was kipenga za bandu, kana baise kumpuma. ");
INSERT INTO ndg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kuba atekubalagwa bandubanyansima, lenga kilamundu jwabi Ni mateso abinishauku ya kuika palyo aabile ankamwe. ");
INSERT INTO ndg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Palyo roho achafu bambweni, baatombwike pae kulonge yake kaba lela ni kukoya “Wenga was mwana wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kabaaking'india kanabatende atanganike. ");
INSERT INTO ndg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aayei kunani ya kitombe, kabayenda kwake. ");
INSERT INTO ndg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kabatalanganya komi ni ibile (kabaakema mitume), ili babe pamwepe ni awese kubatuma kuhubiri. ");
INSERT INTO ndg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ni kuba ni mamlaka ya kupiya mahoka. ");
INSERT INTO ndg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na kaababagwa komi ni ibele: Simoni, kaampaya Lina lyango Petro, ");
INSERT INTO ndg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo mwana wa Zebedayo, ni Yohana nnunawake Yakobo, aampai lina lya Bonagesi, abo ni bana ba Ngurumo, ");
INSERT INTO ndg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ni Andrea, Filipo, Bartholomayo, Mathayo, Tomaso, Yakobo mwana wa Alfayo, Thadayo, Simoni Mkananayo, ");
INSERT INTO ndg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Iskariote, ambaye aankana ");
INSERT INTO ndg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kisha ayei ukaya, ni bandu banyansima bayei pamwepe, hata balyo bawesa kwaa kulyaa mkate. ");
INSERT INTO ndg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Alongo bake bayowine habari eyo, kabayenda kumboywa, kabakoya”agolwike malango.” ");
INSERT INTO ndg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aandishi baisi kuoma Yerusalemu kabakoya, “Amepagawa na Beelzebuli,” na, “kwa ntawala was nsela ampiye nsela.” ");
INSERT INTO ndg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu aakemike ukasake ni kulongela nabo kwa mifano, “ya nsela awesa kumpiya nsela? ");
INSERT INTO ndg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kama upwalume ubaganike wene, upwalme ogo uwesa kwaa kuyema. ");
INSERT INTO ndg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mananyumba ibaganike yene, nyumba eyo iwesa kwaa kuyema. ");
INSERT INTO ndg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kati nsela akagatuka kiogo sake mwene ni kubaganika, awesa kwaa kuyema ni aba aike mwisho wake. ");
INSERT INTO ndg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Lakini ntopo hata yumo awesa kuyingya nnyumba ya mundu mwene ngupu kuyiba ilebe yake bila ya kuntaba mwene ngupu wete, kisha kutola ilebe yote ya nnyumba. ");
INSERT INTO ndg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","kweli nando kuwakokeya, sambi sote za bana Baadam zitasamehewa, pamwepe nikufulueyo balongela. ");
INSERT INTO ndg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mundu yeyote ywa ankufuru Roho ntakatifu asamehewa kwa, bali abiniatia ya sambi za milele. ");
INSERT INTO ndg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu akoiye yenu mwalo bayi kabalongela “abini Roho nchafu” ");
INSERT INTO ndg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kisha mao bake anuna bake baisi nikuyema panza, kabankokeya mundu ankeme. ");
INSERT INTO ndg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bandu banyansima bayii karibu yake batame kabankokeya “mao bako ni anuna bako babii panza, bakupala wenga”. ");
INSERT INTO ndg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kaayangwa “nyai mao bango ni anuna bango? ");
INSERT INTO ndg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kabaalola balio batami bantetelike, kakoya “lola bano ni mao bango ni anuna bango! ");
INSERT INTO ndg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yeyote atenda mapenzi ya Nnongo, mundu woyo ni nlongo wango, nnombwango, ni mao bango. ");
INSERT INTO ndg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Lelo katumbwa kuyegana mbwega ya bahari. Ni bandu banyansima baisi ni kunteteleka, kayingya nngalaba mmase nikutama, bando boote bayii pa mbwega kuyumo. ");
INSERT INTO ndg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na kaba yegana mayaulio ganyansima kwa mifano, na kaakoya kwabe kwa amyegano gake. ");
INSERT INTO ndg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","pekayeni, mpanzi ayeyi kupanda. ");
INSERT INTO ndg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yakapanda mbegu yenge yatumbwike munndela, ni iyuni baisi kabasonywa. ");
INSERT INTO ndg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbegu yenge yatumbwike kumiamba, ntopo ukando wanyansima. Mara za yomike, mwalo ntopo ukando wanyansima. ");
INSERT INTO ndg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yakupita bai lisoba, zayomike, mwalo zai ntopo mikega. ");
INSERT INTO ndg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbegu yenge yatumbwike mumiiba. Miiba yakoi nikuiteteleka, na ibelike kwa kilebe. ");
INSERT INTO ndg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mbegu yenge yatumbwike pa ukando unoike na yaabelike matunda palioka zikola nikuyongeyeka, yenge yabelike mara thelathini zaidi, ni yenge sitini zaidi, ni yenge mara mia”. ");
INSERT INTO ndg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kaakoya, “ywa bini makutu yakuyowa na ayowe”. ");
INSERT INTO ndg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu palyo aiyika yake, balyo karibu yake ni balyo komi ni ibele kaba nlokiya kuhusu mifano. ");
INSERT INTO ndg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kaakokeya kwabe, kwinu mpatike siri ya ufalume wa Nnongo. lakini baapanza kila kilebe ni mifano. ");
INSERT INTO ndg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ili kabalola, ndiyo ulola, lakini babona kwaa, kwaeyo hapo bayowa ndiyo uyowa, lakini batanga kwaa amasivyo batendebuka ni Nnongo angaliwasamehe.” ");
INSERT INTO ndg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kaakokeya kwabe “je ntangike kwa mfano gono? muwesa buli kutanga mifano yenge? ");
INSERT INTO ndg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mpandi alipanda neno. ");
INSERT INTO ndg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Benge ni balyo baatumbwike mmbwega ya ndela palyolyaulyo laapandikwe. Hapo bayowine, mara nsera kaaisa ni kulitola lya ulyo lipandikwe nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ni benge balyo bapandikwe kunani ya miamba, j ambao, apo baliyowa liyanlyo, ulitola kwa haraka ni kupulai. ");
INSERT INTO ndg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","na ntopo mikega nkati yabe lakini huvumilia kwa muda mfupi. Halafu tabu na usumbufu apo viisa kwa sababu ya liyanlyo, mara hujikwaa. ");
INSERT INTO ndg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ni benge balyo bapandikwe mmiba. wanalisikia nlieyaulyo, ");
INSERT INTO ndg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Lakini masumbufu ya lunia, udanganyifu, mali, na tamaa za mambo genge, hubayingia na kulisonga liyaulyo, na linashindwa kuzaa matunda. ");
INSERT INTO ndg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kubi ni balyo bapandikwe kulukando lunogine. Bando kuliyowa liyaulyo na kulipokea na kuzaa matunda: baadhi thelathini, ni baadhi sitini, ni baadhi mia yimo”. ");
INSERT INTO ndg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu kabakookeya “je muletage mnyumba ni kubeka pae ya kitongo, au pae ya lusase? Huileta nnyumba na kuibeka kunani ya kiango. ");
INSERT INTO ndg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kwa kuwa ntopo kilebe sa kuiya ambacho kitanganika kwaa, na ntopo siri ya kuitanga kila mundu. ");
INSERT INTO ndg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Oyo abini makutu ya uyowa, na ayowe!” ");
INSERT INTO ndg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kabaakokeya m'be makini kwa eso mukiyowa kwa kuwa kipimo mpimacho, ndicho mtachopimiwa, na itaongezwa kwinu. ");
INSERT INTO ndg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwa kuwa ywembe abinaso, atapokeya zaidi, ni yalyo ntopo kilebe, kuoma kwake vyatolwa ni vile abinavyo”. ");
INSERT INTO ndg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kakoya, upalume wa Nnongo bate kuufananisha ni mundu apandike mbegu kuukando. ");
INSERT INTO ndg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aagonzike kilo ni kuyumuka bwamba, mbegu ya mei ni kukola, japo atangike kwaa uko yaomi. ");
INSERT INTO ndg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dunia hupiya mbegu yene, kwanza majini, halafu maua, halafu mbegu zilizokomaa. ");
INSERT INTO ndg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Apo mbegu ipile hupeleka mundu kwa sababu mavuno gaike. ");
INSERT INTO ndg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na kaakoya tuufananishe upwalume wa Nnongo ni kilebe gani, au tutumia mpwano wa kele kuuelezea? ");
INSERT INTO ndg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kati mbegu ya haradali, ambapo yapandikwe nzunu muno kuliko mbegu zote mudunia. ");
INSERT INTO ndg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hata, wakati ipandikwe, iba ngolo muno kuliko mitela yenge mubustani, na iba ni matambe makolo hata iyuni wakunani kusenga iyota yabe mmwilili. ");
INSERT INTO ndg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kwa mipwano yanyansima ateyegana ni kukaya liyaulyo kwabe, kwa eyo batangike, ");
INSERT INTO ndg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Na aakokiye kwaa bila mipwano. Lakini apo abiyila yake, kaakokeya kila kilebe benefunzi bake. ");
INSERT INTO ndg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lisiku iyo, kitamunyo kaakaya kwabe, “Tuyende uko upande wa nyaibele”. ");
INSERT INTO ndg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eyo kabaleka bandu banyausia, kabantola Yesu, muda huo abinngalaba. Ngalaba yenge yabipamwepe ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na upepo nkale wate uma ni dhoruba ni mase kayayingiya mungalaba ni ngalaba yabi itolile. ");
INSERT INTO ndg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mwene Yesu abi mulishetri, agonzike kumuto. Kabannyumuya, kabakoya, “mwalimu ustuka kwaa twee twando waa?” ");
INSERT INTO ndg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kayumuka, kaukaya upepo na kaikokeya bahari itolii ipolee”, upepo walei kupuka, na kwa bii poloi. ");
INSERT INTO ndg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","kaoya kwabe, “mwalowa kele mwando yogopa?”je nke bado ntopo ni imani? ");
INSERT INTO ndg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bayingi ni hofu ngolo nkati yabe na kabakoyana bene kwa bene, “Yuno nyai lelo, upepo ni mase gando kun'yogopa? ");
INSERT INTO ndg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Baisi upande wenge wa bahari, munkoa wa Gerasi. ");
INSERT INTO ndg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Palyo Yesu kapita nngalaba, mundu mwenye mminya lilalo aisi kuoma mmakaburi. ");
INSERT INTO ndg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","undu oyo atami kumakaburi. ntopo mundu wakunkato ya zaidi, ntopo hata kwa minyororo. ");
INSERT INTO ndg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Atabikwe minyololo siku yanyansima. Aukutwi nyororo ni pingu zatekwike. Ntopo hata yumo abi na ngupu ya kunsinda. ");
INSERT INTO ndg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","kilo ni mutwe nkati abi kumakaburi ni mmilema, kalela ni kuipapwana mwene ni mawe. ");
INSERT INTO ndg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Palyo ambweni Yesu kutalu kumbutukia, ni kuinama kulonge yake. ");
INSERT INTO ndg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Klela kwa sauti ngolo, “upala nkutendii kele, Yesu, mwana wa Nnongo wa kunani muno? Nando kusihi kwa mwene Nnongo, kana unitese”. ");
INSERT INTO ndg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kwa kuwa ate kunkokeya, nkote mundu oyo, wenga roho nchafu”. ");
INSERT INTO ndg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kanlokiya, “wenga lina lyako wanyai?” Ni ywembe kan'yangwa, “lina lyango Legion, mwalo tubi twabingi”. ");
INSERT INTO ndg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kan'yopa tena na tena kana abapeleke kunnza ya mkoa. ");
INSERT INTO ndg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ngobe banyansiba kabaliswa kunani ya nnema, ");
INSERT INTO ndg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kaban'yopa kabakoya, “Tutume kwa ngobe, tuyingi nkati yabe”. ");
INSERT INTO ndg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hivyo kabaelekeya, roho wachafu abobapai kaba yingia nkati ya ngobe, kababutukia pae ya nnema mpaka baharini, karibu ngobe elfu niibele batumbukii mmase. ");
INSERT INTO ndg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bale babi kabaasubga babutwike kuyenda kupiya taarifa ya sakipi kulyo kunnema. bandu banyansima bapi kuyenda kulola eso kipite. ");
INSERT INTO ndg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Baise kwa Yesu na kum'bona mundu asanganikiwe ni nsela abi nilijeshi atami pae, awaliywe, na abi kuhali yake ya samani ni bembe kaba yogopa. ");
INSERT INTO ndg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Balwo babweni eso kipite kwa mundu asanganikiwe ni nsela kabakokeya eso kipite kwabe ni ngobe iyeya. ");
INSERT INTO ndg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ni bembe kabankokeya aboke kumkoa wabe. ");
INSERT INTO ndg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kayingiya nngalaba, mundu abi ni nsela kumutwe kaampala baboke bote pamwepe ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kakana kuboka nake, lakini kambakiya yenda akasako na kwa bandu bako, na ubakokeye aakutendii Nngwana ni rehma akupayi. ");
INSERT INTO ndg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eyo aboi ni kutumbua kutangaza mambo makolo ayatei Yesu kwake Dekapoli, kila mundu ate kunganya. ");
INSERT INTO ndg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wakati Yesu alokike tena upande wanyaibele, nngalaba, bandu banyansima baisi kunteteleka abi mmbwega ya bahari. ");
INSERT INTO ndg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na yumo kiongozi wa sinagogi akemwa Yairo, aisi, ya kummona, atomwokia mmagolo. ");
INSERT INTO ndg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kampembeya Ni kumpembeya, kakoya “manango nnwawa mbeyambe awaa” Nandokuyopa uise ubeke maboko gako kana awee ni apone. ");
INSERT INTO ndg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eyomaboi pamwepe ni bandu banyansima kabaakota karibu kabanteteleka. ");
INSERT INTO ndg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kwabi ni nnwawa damu yake yapii kwa miaka kumi ni ibele. ");
INSERT INTO ndg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Akundike masaka muno pae ya ang'anga banyansima aatomii kila kilebe abinaso, Ata eyo apatike kwaa nafuu kati ate yongeya bai. ");
INSERT INTO ndg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ayowine habari kuhusu Yesu, eyo aisi Ni kiogo yake kantyanga nkipenga say bandu, kakamua ngobo yake. ");
INSERT INTO ndg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kwa kuwa akoiye “mana ngamuibile ngobo yake napona. ");
INSERT INTO ndg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","kunkamuwa bai, damu yalei kupita, na yowine yega yake yaponi aboi mmasaka. ");
INSERT INTO ndg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","da go go Yesu atangake nkati yake mwene ngupu yampii. kaatendebuka kolyo ni kolyo nkipenga asa bandu kaalokiya, “nyai angamwi ngobo yango?” ");
INSERT INTO ndg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Benepunzi bake kabankokeya, “ubona kipenga seno kikutetelike, ukoya nyai atekukamwa?” ");
INSERT INTO ndg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu aloi kono ni kono kulola nyai atei yeno. ");
INSERT INTO ndg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nnwawa atangike eso kipii, ateyogopa ni kulendema. Aisi nikutomboloka kulonge yake nikunkokeya kila kilebe. ");
INSERT INTO ndg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kankokeya, “we nnwawa imani yako ikutei ube wa nkoto. yenda kwa amani ni mabinye gako gaboka. ");
INSERT INTO ndg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kalongela, baisi bandu kuoma kwa kiongozi wa sinagogi, kabakoya, “Mwana'go nnwawa awile. Mwalwakele kulyendelya kunkundiya masaka mwalimu?” ");
INSERT INTO ndg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu ayowine eso bakikoyage kam'bakiya kiongozi wa masinagogi “Kan n'yogope mwamini bai”. ");
INSERT INTO ndg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Akani kulongwana ni mundu ywenge isipokuwa Petro, Yakobo, ni Yohana, nnunage Yakobo. ");
INSERT INTO ndg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Baisi ukaya kw3a kiongo wa sinagogi ni ywembe am'bwenikiya, kulela muno ni kuomboleza. ");
INSERT INTO ndg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Apo ayingi ukaya kabakokeya, mwalwakele mwando nung'unika ni kulela? mwana ana waa kwaa agonzike”. ");
INSERT INTO ndg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kabamuheka, ywembe kaba mpiya panza kabantola tate mundu ni mao mundu ni balyo bai pamwepe ni ywembwe, kabayingia nnyumba omo abii mwana. ");
INSERT INTO ndg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Katola luboko lwa mwana ni kunkokeya, “Talitha koum.” ambayo ni kukoya.” ");
INSERT INTO ndg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ghafla mwana mwenza yumuka” Mwana ayumwike ni utyanga (kubaa abi ni miaka komi ni ibele). ni gafla kabayingiwa ni nkanganyo nkolo. ");
INSERT INTO ndg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kabaamulu kwa ngupu ngolo ntopo mundu yeyote kupaswa kulitanga liyaulyo. Na kabakokeya bampaye kilalyo mwana mwenza. ");
INSERT INTO ndg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na kaaboka palyo ni kuyenda ukaasabe, ni benefunzi bake kabankota. ");
INSERT INTO ndg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabato kuika, katumbwa kuyegana mmasinagogi. Bandu banyansima paban'yowa na kabakanganya. Kabakoya agapatike kwako gano mafundisho? “Hekima gani yeno bampayi? “Atenda buli miujiza kati gano mumaboko gake?” ");
INSERT INTO ndg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yono si ywa fundi selemala mwana'ge Mariamu nlongo wabe Yakobo, Yose, Yuda ni Simoni? Alombo bake si batama papano ni twenga?” Na bapulaiswe kwaa ni Yesu. ");
INSERT INTO ndg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu abakokeya nabii akosa kwaa heshima, ispokuwa pansengo wake, ni baadhi ya alon go bake ni munyumba yake.” ");
INSERT INTO ndg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Awesike kwa kutenda miujiza hapo, ila kaabeka maboko kwa mminye asunu kubaponiya. ");
INSERT INTO ndg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Atekanganywa mwalwakele bakotoka kwamini kwabe. kaayenda misengo yapambwega nipalyo nikuyegana. ");
INSERT INTO ndg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kaakema balyo benefunzi komi ni ibele katumbuwa kubatuma abele abele, kabapaya ngupu kunani ya nsela, ");
INSERT INTO ndg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ni kuwakokeya kana bapotwe kilebe ila lukongoso bai. Kna batole nkate, nkwisi, wala pwela pakitondo; ");
INSERT INTO ndg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lakini bawale ilatu, na sio nganzu ibele. ");
INSERT INTO ndg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na kaakeya nnyumba eyo muilingiya kana mpite mpaka uboka. ");
INSERT INTO ndg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nnema wowote mana bakani kubapokiya ni ku8bapekanya, muboke apo, ni mupate liu mumagolo ginu, ibe usaidi kwabe.” ");
INSERT INTO ndg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ni bembe kabayenda ni kuwakoya bandu babuye kwa Nnongo ni bstubu masambi gabe. ");
INSERT INTO ndg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Baabengike nsela banyansima, kabapaka mauta abinye kabapona. ");
INSERT INTO ndg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mpwalume Herode ayowine ago, kuba liina lya Yesu lyatanganike muno. Benge kabakoya “Yohana mbatizaji ayokike, mwalo ogo ngupu ya miujiza itenda kasi nkati yake”. ");
INSERT INTO ndg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Benge nkati yabe kabakoya “yono ni Eliya” Benge kabakoya, “yono nabii kati balyo manabii basamani.” ");
INSERT INTO ndg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herode ayowine kakoya, “Yohana ywa ninkatike mutwe ayokike.” ");
INSERT INTO ndg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mwene Herode atelagiya Yohyana aboyolwe nikutabwa gerezani mwalwa Herodia (nyumbo wa mwasage Philipo) mwalo ywembwe abi nnyumbowe(amtweti). ");
INSERT INTO ndg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kwa maana Yohana atekunkokweya Herode, “si halali kuntola nnyumbo wa mwasago”. ");
INSERT INTO ndg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodia atumbwi kunchukia ni kupala kum'bualaga lakinin awesike kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Maana Herode ate kunnyogopa Yohana; atangike kwamba ni mundu mwene abi ni haki ni ntakatifu, kanneka salama. Palyo ayendelile kumpekanya ahuzunike muno, lakini apulaike kumpekanya. ");
INSERT INTO ndg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Palyo iike wakati mwafaka wa kubelekwa Herode kabaandaliya maofisa bake kalamu ni makamanda ni viongozi wa Galilaya. ");
INSERT INTO ndg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwana nwawa wa Hrode kayingiya ni kuina kulonge yabe, kampulaisa Herode ni ageni batami kabalya kilalyo sa kitamunyo. Mpwealume kankokeya ywa mwenza, “niyope sosote sa upala nami nakupaya.” ");
INSERT INTO ndg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kalapiya na kukoya, sosote sa waniyopa, na kupaya, hata mana nnusu ya upwalume wango.” ");
INSERT INTO ndg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kapita panza kannokiya mao bake, “niyope kele?” Kaankokeya, “Mutwe wa Yohana m'batizaji.” ");
INSERT INTO ndg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mara yimo kwa Mpwalume nikunkeya, “nipala mutwe wa Yohana m'batizaji musahani.” ");
INSERT INTO ndg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mpwalume atesikitishwa muno, lakini mwalowa kilapo ni ugeni awesike kwaa kukana sa ayopike ywa mwanza. ");
INSERT INTO ndg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mpwalume kabatuma asikali kati ya balyo alinzi bake ni kubalagiya bayende kunnetia mutwe wa Yohana. Mlinzi ayei kunkata mutwe aii kifungoni. ");
INSERT INTO ndg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kaleta mutwe wabii musahani ni kumpeya ywa muenza ni muenza ni ywembe kumpeya mao bake. ");
INSERT INTO ndg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Anafunzi bake kabayowa, kabayenda kuntola mwili wake kabayenda kuusika mmakaburi. ");
INSERT INTO ndg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mitume, bakusanyike kulonge ya Yesu, kabankokeya yote agabatei ni ago kabayegana. ");
INSERT INTO ndg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Naye kababakiya, “muise mwabenge pandu pa kiiyo, tupomoli kwa muda” bandu banyansima baisi ni kuboka, hata bapatike kwaa kulya. ");
INSERT INTO ndg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kaba kwela ngalaba kabayenda pandu pafaragha yika yabe. ");
INSERT INTO ndg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lakini bababweni kababoka ni benge baatangike kwa pamwepe babatwike ni magolo nnemausima, Ni bembe baike kabla yabe. ");
INSERT INTO ndg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kuika pwani babweni kipenga sa bandu, kababonia kiya, mana babi kati ngondo bakosike nsuka. Ni katumbwa kubayegana mambo ganmyansima. ");
INSERT INTO ndg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Muda yaugendelile benepunzi baisi kabankokeya, “pano mahala pa faragha ni m uda uyendelil. ");
INSERT INTO ndg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ubalage bayende ijiji ya jirani balkapemi kilalyo.” ");
INSERT INTO ndg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kabayangwa kakoya.”mwapeyi mwenga kilalyo.”Kabankokeya “Tuwesa kuyenda kupema mikate yenyen thamani ya dinari mia ibele ni kuapayaa balye? ");
INSERT INTO ndg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kabakokeya,'m'bi ni mikate ilenga? yendaye mkalole.” palyo bapatike kaba mwalya “Mikate mitano ni omba abele.” ");
INSERT INTO ndg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kabaakokeya bandu batami ipungu ipungu kunani ya manyei mabee. ");
INSERT INTO ndg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kabaataminya ipungu ipungu ya bandu mia kwa hamsini. ");
INSERT INTO ndg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Katola mikate mitano ni omba abele, ni kulola kunani, kaibariki kuapaya benepunzi babeke kulongeya ipungu ni kubagana omba kwa bandu bote. ");
INSERT INTO ndg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kabalya bote ni kuyukuta. ");
INSERT INTO ndg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kabakusanya ipande ya mikate ya iigile kuitwelya itondo komi ni ibele, ni ipande ya omba pia. ");
INSERT INTO ndg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ni bai analome elfu tano balii mikate. ");
INSERT INTO ndg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kabaakokeya bakwele mmashua bayende kundo kwenge, hadi Bethsaida, wakati ywembe kabalaga makutano. ");
INSERT INTO ndg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Palyo baboi ayei ukiogolo kuyopa. ");
INSERT INTO ndg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kitamunyo, mashua yabe yaii katikati ya bahari, nin ywembe aiyika nchi kavu. ");
INSERT INTO ndg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kabaabona kabakunda masaka kupiga kasia mwalo upepo wainkale. Karibu ya bwamba kabakata, ");
INSERT INTO ndg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lakini kabatyanga kunani ya mmase, na apaikuwapeta. Palyo bamweni katyanga kunani ya mase kabayingiwa ni masaka balongwage misimu kabaguta. ");
INSERT INTO ndg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kwasababu bamweni kabatwelya masaka, mara kabaakokeye 'mube majasiri.”nenga. kana m'be ni masaka” ");
INSERT INTO ndg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kayingia mmashua, ni upepo kautolya, ni bembe kaba nkanganya muno. ");
INSERT INTO ndg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Eyo batangite kwa maana ya ile mikate, malango gabe gabii masunu. ");
INSERT INTO ndg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Balokike upande wanyaibele, baike nnema wa Genesareti mashua yayei nanga. ");
INSERT INTO ndg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kupita kunza ya mashua, kabantanga. ");
INSERT INTO ndg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kababutuka mkoa nsima kutangaza, kabatumbua kubaleta abinye mmasela palyo bayowine andoisa. ");
INSERT INTO ndg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Palyo ayingii ukijiji, mjin au nnema, abinye bababei pa'lisoko ni kaban'yopa bakamwe lipendo lya ngobo yake awatei, ni bate balyo bakamwile baponi. ");
INSERT INTO ndg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafarisayo ni baandisi baumi Yerusarem bakusanyikekunteteleka ywembe. ");
INSERT INTO ndg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ababweni banapunzi bake kabalya mikate ni makoko najisi, maisukike kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafarisayo ni mayahudi balya kwaa mpaka basuke maboko gabe bwiso. ");
INSERT INTO ndg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","(Mafarisayo kababuya kuoma kusoko, balya kwa mpaka bayonge wete ni kubi sheria yenge bando kuikota kati ya kusuka ikombe, iteleko, igombo ya shaba ni viti ya matuma wakali waulya kilalyo). ");
INSERT INTO ndg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","mafarisayo ni aandishi kabanlokiya Yesu, “Walowa kele benepunzi bako batenda kwaa kati ya matendo agoi, balya mikate bila ya kuagua maboko?” ");
INSERT INTO ndg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ywembe kabaakokeya, “Isaya atabirike bwiso mwenga mwaboso. Kaandika 'Wandu aba banieshimu pankanwa bai, miyo gabe ibikutaru ni nee. ");
INSERT INTO ndg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Banitendi ibada ya uboso, bayegana sheria ya bandu kati mapokeo yabe.' ");
INSERT INTO ndg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Muileki sheria ya Nnongo ni kukamuliya kandende kandende sheria ya bandu. ");
INSERT INTO ndg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kakoya kwabe,'Muikani amrin ya Nnongo kwa urai mpate kuyendelya ni tamaduni zenu. ");
INSERT INTO ndg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa alongei m'baeshimu tatee ni mao binu nin ywembe akaiye mabou ya tate bake ni mao bake hakika ba waaa” ");
INSERT INTO ndg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lakini mwendakoya, mundu kakoya kwa tate ba ao mao bake, “sosote sa mpokea kuoma kwango ni hazina ya Hekalu,”'(kakoya kwamba iomi kwa Nnongo.' ");
INSERT INTO ndg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Eyo unnekeya kwa kutenda kilebe sosote sa mwalo wa tate au mao bake. ");
INSERT INTO ndg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Muisarawa amri ya Nnongo, mutenda mila yinu, Ni menge ganyansima kati ayo mutenda.” ");
INSERT INTO ndg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kabakema kabakusanyika ni kabakokeya “mumbekanyi nee, mwabote na mundange. ");
INSERT INTO ndg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kilebe sosote kuoma kunza kinsapwa kwa mundu, Bali sa kimpita mundu ndicho kiwesa kunsapwa mundu. ");
INSERT INTO ndg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(kombokiya: mstari gono, “mana mundu yeyote abi ni makutu ga kupekanya, na ayowe” Ntopo kwenye nakala ya samani). ");
INSERT INTO ndg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu abalei pakipenga ni kuyingia ukaya, benepunzi bake kabanlokiya kuhusu mpwano ogo. ");
INSERT INTO ndg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu kakoya, “ni mwenga nke balo kutanga? mbona kwaa sa kin'yingia mundu kinsapwa kwaa, ");
INSERT INTO ndg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mwalo kiwesa kwaa kuyingiya kwimoyo, lakini kiyingiya ndumbo yake ni kupita kuyenda kumwitu. kwa mayegeyo gano Yesu ate ilalyo yote kuba halali. ");
INSERT INTO ndg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kakoya,'sakimpita mundu ndicho kinsapuaso, ");
INSERT INTO ndg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwakuwa kioma nkati ya mundu, ni kunza ya moyo, kupita mawazo maovu, uzinzi, bwii, kubulaga, ");
INSERT INTO ndg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Kubelenya, tamaa mbaya, maovu, bwii, ni ujinga. ");
INSERT INTO ndg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Maovu gano gote gaoma nkati, galyo gansapuwa mundu.” ");
INSERT INTO ndg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ayumwike ni kuboka palyo ni kuyenda mkoani Tiro ni Sidoni. Ayingii nnyumba na atekana mundu kutanga kati abi apo, lakini werekine kwaa kumuuya. ");
INSERT INTO ndg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lakini gafla nnwawa abii ni mwana nsunu abi ni nsela ayowine habari yake kaisa ni kutomboka mmagolo gake. ");
INSERT INTO ndg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nwawa ayo ai Myunani, likabila la Kifoeniki kun'yopa ni kumpembela ambenge nsela ai kumutwe ya kaenza kake. ");
INSERT INTO ndg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu kankokeya ywa nnwawa, “balekee bana balye wete, mwilo kutoa nkate wa bana kunlekelya mbwa.' ");
INSERT INTO ndg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nnwawa kamyangwa nikukoya,'Eena Amwenye mbwa pae ya meza kulya maigala ya kilalyo sa bana.” ");
INSERT INTO ndg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kankokeya, “Mwalo ukoiye iyeya ubi huru kuyenda pensela ampii muenza wako.” ");
INSERT INTO ndg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nnwawa abui ukaya ni kum'bona muenza wake agonzike palusase, ni nsela ampii. ");
INSERT INTO ndg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu apii kuinza ya mkoa wa Tiro ni kupeta Siodoni kuyenda bahari ya Galilayampaka kumbwega ya Dikapolisi. ");
INSERT INTO ndg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ni kabannetya mundu mbogoso na abiawesa kwaa longela bwiso, kabampembela Yrsu abeke luboko kunani yake. ");
INSERT INTO ndg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","kampiya kunza ya kipenga kwa siri, ni nngozi yake mmakutu, ni baada ya kuunamata, kakamwa lulimi lwake. ");
INSERT INTO ndg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kaalola kunani kumbengo, kapomwa kunkokeya “Efata” Eyo kukoya “Talauka.” ");
INSERT INTO ndg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Muda gogolyo makutu gayowike, ni sa sa satabike lulimi sa pimwanike na kaalongela bwiso. ");
INSERT INTO ndg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kabaakokeya kana bankokeye mundu yoyote, ila kila ya akanikeye, bembe kabazidi kulongela ni kukoya kwa bandu. ");
INSERT INTO ndg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hakika batekanganywa ni kukoya, “Atei kila kilebe bwiso atei mbogoso kuyowa ni mbubu kulongela. ");
INSERT INTO ndg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","siku yeno, bai bandu banyansima, bai ntopo kilalyo. Yesu kabaakema benepunzi bake kabaakokeya, ");
INSERT INTO ndg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Nibonia kiya bandu aba, bai ni nenga pamwepe lisiku lya itatu na atopo kilalyo. ");
INSERT INTO ndg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mana niatawinye bayende ukasabe bazimia mundela mwalowa njala, benge baomi kutalu muno. ");
INSERT INTO ndg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Benepunzi bake kaban'yangwa, tupata kwako mikate yanyansima ya kuyukuta bandu abo bote paeneo leno lilekine? ");
INSERT INTO ndg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","kabaalokiya “m'bi ni ipanga ilengaya mikate? kabakoya “Saba”. ");
INSERT INTO ndg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kabaakokeya bandu bote batame pae. Kaaitola mikate Saba, kaanshukuru Nnongo ni kuitekwana. Kabapeya benepunzi bake baibeke kulongo yabe ni bembe kaabaibeka kulonge ya balyo bandu batami. ");
INSERT INTO ndg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pia aini omba asunu asunu kidogo, baada ya kushukuru kabaakokeya benepunzi bake baapaye ni aba iyeya. ");
INSERT INTO ndg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kabalya ni kuyukuta. Ni kaba konza ya ipande ");
INSERT INTO ndg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","iigile itondo ikolo saba. Bakalibile bandu elfu ina. Na kabaleka bayende. ");
INSERT INTO ndg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kuyingya mmashua Ni benepunzi bake, kabayenda ukanda wa Dalmanuta. ");
INSERT INTO ndg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafarisayo kabapita kunza Ni kutumbua ni ywembe. Bapala abapaye ishara kuoma kwa ");
INSERT INTO ndg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nnongo, kwa kumgeya. Katafakari muno kumoyo kakoya, “Mwalowa kele kibelei seno kipala ishala? Niakokeya mwenga kweli ntopo ishala ipita kwa kibelei seno.” ");
INSERT INTO ndg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kabaleka, kuyingya mmashua, kaboka kuyenda upande wenge. ");
INSERT INTO ndg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Benepunzi bayebwike kutola mikate, bai ni kipande kimo said mmashua. Kabakaya ni kuakokeya, ");
INSERT INTO ndg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","M'be Ni minyo muiluile ni chachu ya farisayo ni chachu ya Herode. ");
INSERT INTO ndg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Benepunzi kabakayana bene kwa bene, “mwalo twatopo mikate.” ");
INSERT INTO ndg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu kalitanga leno, kabaakokeya “Mwalowa kele mukayana mwalo wa kutobaa mikate? bado mutangikwe kwaa? ntangike kwaa? mioyo yenu ibi yoyolo? ");
INSERT INTO ndg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","M'bi Ni minyo, m'bona kwaa? m'bi Ni makutu, muyowa kwaa? mukombokiya kwaa? ");
INSERT INTO ndg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nabagine mikate mitano kwa bandu elfu tano mwatweti itondi ilenga itwelii ipande ya mikate? kaban'yangwa “komi ni ibele.” ");
INSERT INTO ndg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Palyo nabagine mikate Saba kwa bandu elfu ina, mwatweti itondo ilenga? ");
INSERT INTO ndg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kabakaya “Saba” Kabaakokeya nke bado kutanga? ");
INSERT INTO ndg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kabaisa Bethsaida, bandu apo banletike mundu ndolo kwa Yesu, kabampembela Yesu ankamwe. ");
INSERT INTO ndg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu kankamwa ywa mundu ndolo, ni kunlongoya konza ya kijiji. Palyo aunike mata kunani ya minyo gake ni katondobeya luboko kunani yake, kunnokiya ubona sosote? ");
INSERT INTO ndg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aloi kunani Ni kukoya, “Nibona bandu kati mikongo ityanga.” ");
INSERT INTO ndg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kaatondobeya tena maboko kunani ya minyo gake, mundu ywa kagumukwa minyo gake, abweni tena kila kilebe bwiso. ");
INSERT INTO ndg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu kanneka ayende ukaya ni kunkokeya “kana uyingii mjini.” ");
INSERT INTO ndg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu kaboka Ni benepunzi bake kuyenda ijiji ya Kaiseria ya Filipi. Mundela kabaalokiya benepunzi “Bandu bakoya nee nyai?”. ");
INSERT INTO ndg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kaban'yangwa kabakoya “Yohana mbatizaji.” Benge bakoya “Eliya” Ni benge, “Yumo ba Nabii.” ");
INSERT INTO ndg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kabaalokiya, “mwenga mukoya nenga nyai?” Petro kankokeya, “wenga wa Kirisitu.” ");
INSERT INTO ndg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu kabakotoya kana bamwali mundu kuhusu ywembe. ");
INSERT INTO ndg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kaumba kuwayegana kuba mwana wa Adamu lazima akunde masaka kwa mambo mengi, na bankana iongozi ni akolo la makuhani, ni aandishi, na abulagwa, ni baada ya siku tatu ayoka. ");
INSERT INTO ndg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Akoiye gano kunza. Petro kantola pambene ni kutumbua kunkaya. ");
INSERT INTO ndg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu atendebwike ni kualola benepunzi bake ni ni kunkoya Petro nikukoya “peta ukuogo sango nsela uyogopa kwaa mambo ya Nnongo isipokuwa mao ga bandu.” ");
INSERT INTO ndg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kisha kabakema bandu banyansima pamope ni benepunzi bake, ni kuubaalya, “mana kubi ni mundu apala kunikota, aikane mwene, atole msalaba wake na angote. ");
INSERT INTO ndg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ywa apala kuyaokoa maisha gake, agataga na gwaagataga maisha gake mwalowa nee ni mwalowa injili atayaokoa. ");
INSERT INTO ndg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Insaidia kele mundu, kuba ni ulimwengu wote, na kisha kuba ni asara ya maisha gake gote? ");
INSERT INTO ndg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mundu awesa kupiya kele badala ya maisha yake. ");
INSERT INTO ndg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yeyote anibonia oi ni muyaulio gango kwa kubelei seno sa uzinzi na kibelei sa bene sambi, mwana wa Adamu ambonia oni palyo aisa pa apwalume wa Tate bamwepe ni malaika atakatifu. ");
INSERT INTO ndg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na akoiye kwabe “Hakika ni kaya winu, nkati yino kana bandu bayemi pano bawakina mpaka baabone upwalume wa Nnongo kauisa kwa ngupu. ");
INSERT INTO ndg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ni baada ya siku ya sita Yesu abatweti Petro, Yakobo ni Yohana pamope ni ywembe pannema, yika yabe. Katumbua kubadilika kulonge yabe. ");
INSERT INTO ndg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ngobo yake yatumbuani kung'aa muno, maupe muno, maupe kuliko mng'arishaji gwengi pano duniani. ");
INSERT INTO ndg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eliya ni Musa kabapita kulonge yabe, na kabalongela ni Yesu. ");
INSERT INTO ndg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petro kayangwa kunkokeya Yesu, “Mwalimu, mwema twenga kuba pano, ni tusenge ibada itatu, kimo sako, kimo sa Musa, ni senge sa Eliya.” ");
INSERT INTO ndg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Mwalo atangike kwaa sakukoya, bateyogopa muno) ");
INSERT INTO ndg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Liunge kalipitia ni kubagubika. Sauti saipita kuliunde kaikoya “Yono banangu mpendwa, mumpikanyi ywembe. ");
INSERT INTO ndg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gafla palyo baibalola, baambweni kwa yeyote pamwepe ni bembe, baambweni Yesu bai. ");
INSERT INTO ndg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Palyo kabaaliuka kuoma akitombe, kabaakini kiya kumwalithia mundu yoyote galyo bagabweni mpaka mwana wa Adamu kayoka kuoma kwa bandu bawile. ");
INSERT INTO ndg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kabatunza mambo yabe bene. Lakini kabalokiyana bene kwa bene maana yake kele “kuyoka kuoma kwa bandu bawile. ");
INSERT INTO ndg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kabanlokiya Yesu, “Mwalowa kele aandishi ukoya lazima Eliya aise kwanza?” ");
INSERT INTO ndg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kaabakiya, “Eliya aisa kutoka ilebe yote. Mwalowa kele iandikwe mwana wa Adamu aakunda masaka ganyansima ni bandu kunkana?” ");
INSERT INTO ndg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Niabakiya Eliya atangike, na baantei ya bapendike, kati ya maandiko gakoya kwake. ");
INSERT INTO ndg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kubaya kwa benepunzi, baabweni bandu banyansima batetelike ni Masadukayo bai kaba bishana. ");
INSERT INTO ndg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kummona bai, kipenda sote sate kanganya ni kumbutia kumsalimia. ");
INSERT INTO ndg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kabaanlokiya benepunzi bake, mbishana nao kelee? ");
INSERT INTO ndg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yumo mwa mukipenga kayangwaa, “Mwalimu nanlekite manango kwako, aii ni nsela atei kana alongele, ");
INSERT INTO ndg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Na kumtenda alendeme ni kuntomboya pae, ni kupita litutuma munkanwa na kutauna mino ni kung'ong'onala. Nayopite benepunzi bako bampiye nsela lakini bawesike kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kabayangwaa, “Kilebe kisicho amini na tama nimwee kwa muda gani? Natoliana nimwee mpaka lini? Nneteni kwango. ");
INSERT INTO ndg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kbanneta mwanage, nsela paamweni Yesu, kan'yeya kulendema. Mwisembe katomboka pae ni kupita litutuma munkanwa. ");
INSERT INTO ndg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu kankokiya tate bake, “ubinyo ubi kwa muda gani? tate kabayangwa” tangu unangota. ");
INSERT INTO ndg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mara yenge atombokeya kwa moto au mmase, n kujaribu kumpoteya. Kama uwesa panga sosote ya tuboniekiya utuyangate.” ");
INSERT INTO ndg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu kankokeya “Mana ubi tayari? Kila kilebe sando wesekana kwa ywe aminiye.” ");
INSERT INTO ndg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tate ya mwana kalela ni kukoya, “Nando amini niyangate kuto kuamini kwango.” ");
INSERT INTO ndg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Palyo Yesu abweni kipenga sa bandu kakibutukiya kwabe, kaankopokia nsela ni kukoya, wenga nsela mbubu ni mbogoso, nando kubakiya nneke, kana uyingii keake lelo. ");
INSERT INTO ndg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kalela kwa lukalanga ni kuntaabiya mwana ni nsela kaaboka. Mwana abonike kati atewaa. Bingi kabakoya “Awile,” ");
INSERT INTO ndg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesu kan'tola ni luboko kan'yinua, ni mwana kayema. ");
INSERT INTO ndg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","lyo Yesu ayingii nnyumba, benepunzi bake kabanlokiya faragha, “mwalowa kele tuwesike kwaa kumpiya?” ");
INSERT INTO ndg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kabakiya “Kati iyeya apita kwa ila kwa mayopeyo.” ");
INSERT INTO ndg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bapii palyo kupitya Galilaya, Aakani kutanga mundu yeyote yaa kutanga palyo babile. ");
INSERT INTO ndg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mwalo abikabayengana benepunzi bake. Kabanakokeya mwana wa Adamu aikiywa mmaboko ga bandu, na bambulaga, palyo abi awile, atama siku tatu ayoka tena.” ");
INSERT INTO ndg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lakini baatangike kwaa mayegeyo gano na bayogwipe kunnkiya. ");
INSERT INTO ndg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ndipo baike Karperinaumu. Palyo bai nnyumba kabalokiya “mwalongelage kele mwamundela? ");
INSERT INTO ndg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bayangwi kwaa batami poloi. baikababishana mundela nyai aimpendo muno. ");
INSERT INTO ndg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aatami pae kabakema komi ni ibele pamwepe, na kalongela nabo “Ywa apala kwa wa kwanza ni lazima abe wa mwisho ni mtumishi wa bote. ");
INSERT INTO ndg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kantola mwana nnangota kambeka kati yabe. Kantola mmaboko gake kakoya. ");
INSERT INTO ndg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ywa ampokeyae mwana kati ay o kwa lina lyango, pia anipokile ni nee, na mana abi mundu amenpokea, ambokya kwaa nee bai, niywa andumike. ");
INSERT INTO ndg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana kankokeya, “Mwalimu twammweni mundu kapiya nsela kwa lina lyako tukankotaya, mwalo atubengeya kwaa” ");
INSERT INTO ndg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu kakoya, “kana munkataya, mwalo ntopo atenda kasi nglo kwa lina lyango na baadae akoye lina ulyo linoike kwaa kwango.” ");
INSERT INTO ndg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ywa atupenga kwaa bai ai pamwepe ni twenga. ");
INSERT INTO ndg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ywa akupaya kikombe sa mase ga kunywaa mwalo abi ni Kirisitu, nando kubakiya, Ataga kwaa thawabu yake. ");
INSERT INTO ndg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ywa abakosya bana anangota balyo bangota nee, yai bwiso kutabwa libwe la kusagia paingo ni kutangwa baharini. ");
INSERT INTO ndg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mana luboko lwako utei kwa bwiso ulukeng'ende, nantali kuyingi pankoto bila lubko kuliko kuyingia pahukumu ni maboko gako gote. Kumoto “uimika kwaa” ");
INSERT INTO ndg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Itange mistari yeno, “Pandu punza bawakwa ni moto uimika kwaa.” Ntopo nnakala za kale) ");
INSERT INTO ndg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mana lugolo lwako litei kwa bwiso, lukeng'ende. Ni bwiso kuyingi kuukoto ni nkilema, kuliko kulagena kuhukumu ni magolo mabele. ");
INSERT INTO ndg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Itange mistari gono, pandu punza bawakwaa ni moto uimika kwaa”ntopo mu nakala za kale) ");
INSERT INTO ndg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mana liyo lyako litei kwa bwiso lipiye. Bwiso kuyingia kuufalme wa Nnongo ni liyo limo, kuliko kuba ni minyo mabele kutagwa kuzimu. ");
INSERT INTO ndg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Pandu pabi ni punza banga waa, no moto wangaimika. ");
INSERT INTO ndg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kwa kubaa kila mundu akolezwa mni moto. ");
INSERT INTO ndg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mwinyo unoike, mana mwinyo utagike ladha yake watenda buli kubukiya ladha yake? Mube ni mwinyo nkati yinu mwabene, ni mube ni amani kila yumo. ");
INSERT INTO ndg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu aboi ni kuyenda mkoa wa Uyahudi ni eneo la kulonge ya lupondo Yordani, ni makutano bambengeiye, kabayegana tena, kati ya ibii kawaida yake kutenda. ");
INSERT INTO ndg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ni Mafarisayo baisi kun'geya, kabanlokiya “ni bwiso nnalome kunneka nyumbo wake?” ");
INSERT INTO ndg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kabayangwa, “Musa abakokiye buli?” ");
INSERT INTO ndg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kabakoya “Musa aloywi kuandika seti sa kurekana ni kumbenga nnwawa.” ");
INSERT INTO ndg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Mwalowa kunonopa mioyo yinu ndio maana aliwaandikia yino sheria. Yesu kabakokeya. ");
INSERT INTO ndg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Kuoma mwanzo wa uumbaji,'Nnongo aumbike nnwawa ni nnalome.' ");
INSERT INTO ndg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nnalome kabaleka tate ni mao bake ni kuungana ni ayumbo bake, ");
INSERT INTO ndg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ni abo abele babamwili gumo, baba ubili kwaa lelo, bali mwili gumo. ");
INSERT INTO ndg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Eso akitei Nnongo kuba simo kanaaakibangane.” ");
INSERT INTO ndg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wakati bai nnyumba benepunzi bake kabaanlokiya kuhusu leno. ");
INSERT INTO ndg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kabaakokiya, “Ywa anneka nnyumbo wee ni kutola nnwawa wenge, enda libekenya. ");
INSERT INTO ndg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nnwawa ni ywembe mana anneki nsengo wake ni kutolwa ni nnalome ywenge, atenda libelenga.” ");
INSERT INTO ndg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ni bembe kaba nnetia banababe anangota abakamwee, lakini benepunzi kabaakalikiya. ");
INSERT INTO ndg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu palyo atangike apulaike kwaa kabaakokeya, “Alekeya bana basunu baise kwango na kana m'bakanikiye, kati bano upwalume wa Nnongo ni wabe. ");
INSERT INTO ndg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kweli nando kuwalokiya, ywa atami kupokya upwalume wa Nnongo kati mwana nnangota hakika ayingia kwaa kumpwalume wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kaatola bana mmaboko bake kaabariki kaabekya maboko kunani yabe. ");
INSERT INTO ndg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Katumbua mwenza wake mundu yumo kambotokiya ni kupiga mayuwa kulonge yake, kanlokiya “mwalimu mwema, ndendebuli niweze kurithi ukoto wa milele?” ");
INSERT INTO ndg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kakoya “mwalowa kele ungema mwema? Ntopo aliye mwema ila Nnongo yika yake. ");
INSERT INTO ndg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uzitangike amri: Kana ubulage, kana ubelenye, kana ubulage, kana uboswee, kana ukoye uboso, uba eshimu tate ni mao bako.” ");
INSERT INTO ndg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mundu ywa kakoya, “mwalimu gono gote ni gatei tangu nge mwinsembe.” ");
INSERT INTO ndg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kanlola ni kumpenda, kankokiya, “Upongwa kilebe kimo. Inapaswa usuluse ilebe yote ubinayo na ubagane akeba, na ubani azina kumbengo. Ndipo uise ungote. ");
INSERT INTO ndg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Akatike tamaa kwa mayegeyo gano, aboi kauzunika, kwa kubaa aii ni mali ganyansima. ");
INSERT INTO ndg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu aloi kulyo ni kolyo kababakiya benepunzi bake, “buli ni kunonopa matajiri kuyingii kuupwalume wa Nnongo! ");
INSERT INTO ndg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Benepunzi batekanganya gano mayaulio. Yesu kabaakokeya yeya, “Bana kunonopa kunonopa kuyingi kupwalume wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nantali Ngamia kuyingia mukipole sa sindano kuliko tajiri kuyingi kuupwalume wa Nnongo! ");
INSERT INTO ndg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Batekanganya muno kabakoya, “Eyo nyai ataokoka” ");
INSERT INTO ndg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu kabalola ni kukoya, “kwa bandu iwesekana kwaa, lakini sio kwa Nnongo. Kwa Nnongo gote gando wesekan.” ");
INSERT INTO ndg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petro katumbua kulongela naye, “lola tulei gote na ttukubengeiye we.” ");
INSERT INTO ndg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu kakoya, “ukweli niakokiya mwenga ntopo alei nyumba, mwasage alombo bake, mao bake, tate bake, bana bake, bwee, mwalo wa nee ni mwalo wa Injili, ");
INSERT INTO ndg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ambaye apokeya kwa mara mia zaidi ya sasa pano Duniani, nsengo, mwasa, nnombo, mao. bana, ni bwee, kwa masaka ni ulimwengu uisaa, ukoto wa milele. ");
INSERT INTO ndg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bingi ba kwanza baba ba mwiso ni balyo ba mwisho baba ba kwanza.” ");
INSERT INTO ndg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mundela kabayenda Yerusalem, Yesu abi kulonge yabe. Benepunzi batekanganya ni balyo ai kabaa kota ukyogo kaba yogopa. Yesu kabapinya pambwega balyo komi ni ibele na kutumbwa kuakokeya eso sa mpitia mbeyambe. ");
INSERT INTO ndg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Lola, tuyenda mpaka Yerusalem, ni mwana wa Adamu aikinywa kwaa makuhani akolo ni aandishi. Wataukumu awee ni kumpiya kwa bandu ba mataifa. ");
INSERT INTO ndg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Watamdhihaki, bamuunia mata, bampumunda fimbo na kumbulaga. Lakini lisiku nyaitatu ayoka.” ");
INSERT INTO ndg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo ni Yohana, bana ba Zebedayo, baisi kwake ni kukoya, “Mwalimu tukupala ututtendi sosote sa tukuyopa.” ");
INSERT INTO ndg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kabaakokeya, “mpala niatendi kele? ");
INSERT INTO ndg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kabakoya “Tupala kutama mwenga nkeya.” ");
INSERT INTO ndg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu kayangwa, mtangite kwa eso muyopa. muwesa kunywa kikombo eso nannywea nenga au kustahamili ubatizo ago napatizana? ");
INSERT INTO ndg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kabankokeya “Twando wesa” Yesu kabakokeya, “kikombe eso na nywea mtakinywea. Ni ubatizo ambao kwabe nmebatizwa, mtastahili. ");
INSERT INTO ndg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ywa atama kuluboko lwango lwa mmulyo au luboko lwango lwa nkeya nenga kwa wa upiya, kwa balyo ukasabe bayomwile kuandaa.” ");
INSERT INTO ndg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Balyo benepunzi benge komi ya bayowine gano, kabatumbwa kuakasirikia Yakobo ni Yohana. ");
INSERT INTO ndg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu kabakema ni kukoya, “mwandotanga balyo badhaniwa kuba atawala wa bandu ba mataifa huwatawala, Ni bandu babe mashuhuri huwaonyesha mamlaka kunani yabe.” ");
INSERT INTO ndg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lakini upaswa kwaa kuba eno nkati yinu. ywa aba mpendo kati yinu lazima atumikii, ");
INSERT INTO ndg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ni ywa aba wakwanza nkati yinu ni lazima abe mmanda wa bote. ");
INSERT INTO ndg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mwalo mwana wa Adamu aisi kwa kutunukiwa bali aisi kutumika, ni kuyaoiya maisha gake kwa faida ya bingi.” ");
INSERT INTO ndg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","wakaja Yeriko. Palyo kaboka Yeriko ni benepunzi bake ni kipenga sa nyansima, Mwana wa Timayo, Batimayo, kipofu myopaji, atami mmbwega ya ndela. ");
INSERT INTO ndg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Palyo ayomi kuba Yesu Mnazareti katumbua kupiya lukalanga kakoya, “Yesu mwana wa DaudiYesu nibonee kiya. ");
INSERT INTO ndg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bingi kabankoya wa ndolo, kabankokeya anyamale. Lakini kalela kwa sauti ngolo, Mwana wa Daudi nibone kiya!' ");
INSERT INTO ndg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kayema ni kukoya akemwe. Kabakoya, baa ngangale! Yinuka! Yesu ando kukema.” ");
INSERT INTO ndg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kalitaga pambwega likoti lyake kabutuka kuyenda kwa Yesu. ");
INSERT INTO ndg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu kan'yangwa ni kukoya, “upala nikutendi kele?” Ywa nnalome ndolo kayangwa, “mwalimu nipala kubona.” ");
INSERT INTO ndg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu kambakiya, Yenda, imani yakuponinye.”papo hapo kagagumukuka, ni kunkota Yesu mu ndela. ");
INSERT INTO ndg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wakati ogo baisi Yerusarem, kalibu ya Besthfage ni Bethania, pakitombe sa mizeituni, Yesu atumike abele kati ya balyo benepunzi bake ");
INSERT INTO ndg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ni kuakokeya “Muyende ukijiji sa kibii kalibu ni twee. mana muujingile omo, mwammona mwana mbonda, ambaye anakwelwa kwaa. Mtabaye na munnete kwango. ");
INSERT INTO ndg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mana api mundu kubalokiya mwalowa kele ntenda iyeya? Mbakiyaye Bwana ando kumpala na ambukiya pano.” ");
INSERT INTO ndg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bayei ni kummona mwana mbonda kunza ya mlango kwenye mtaa wa palai ni membe kabaamuundua. ");
INSERT INTO ndg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ni bandu bai bayemi palyo na kabaakokeya “Mutenda kele kumbundua mwana mbonda oyo?” ");
INSERT INTO ndg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kabaakokeya katu ya abalogoli Yesu, ni bandu kabaaleka ayende. ");
INSERT INTO ndg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Benepunzi abele banletike mwana mbonda kwa Yesu na kabatandika ngobo yabe kunani ili Yesu awese kukwela. ");
INSERT INTO ndg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bandi banyaansima kabatandika ngobo yabe mundela ni benge batandike matambe galyo batekwi mmigonda. ");
INSERT INTO ndg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Balyo bayei kulonge yake ni balyo bankotike kaba guta “Hosana! Abarikiwe aisa kwa lina lya Bwana.” ");
INSERT INTO ndg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ubarikiwe upwalume ogo uisa watate bitu Daudi! Hosana kwa aliye kunani. ");
INSERT INTO ndg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ndipo Yesu ayingii Yerusalem na ayei hekaluni na aloi kila kilebe. Muda wa yei, ayei Bethania pamwepe ni komi ni ibele. ");
INSERT INTO ndg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lisiku lya nyaibele, palyo kabakuya kuoma Bethania, abi ni njara. ");
INSERT INTO ndg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Abweni ntela wa kumwitu ubi ni manyei kutalu ayei kulola kama kubi ni kilebe mwa nnani. ");
INSERT INTO ndg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kankokeya, “Ntopo wa ulya matunda kuoma kwako lelo.” Benepunzi bake bayowine. ");
INSERT INTO ndg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Baisi Yerusalem ni ywembe kayingia muhekalu katumbua kubapiya panza asalusaji ni anunuzi muhekalu. Kagalwa mesa za wabadilishaji pwela ni vitu vya asulusa ngunda. ");
INSERT INTO ndg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kakanikiya kwa mundu yeyote kupotwa kilebe sosote muhekalu sa kisalulwage. ");
INSERT INTO ndg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kabayegana ni kukoya, “je iandikwe kwaa, nyumba yango yakemwa nyumba ya sala kwa mataifa gote? lakini mutei lipango lya anyang'anyi.” ");
INSERT INTO ndg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Makuhani akolo ni aandishi bayowine ga akoyage, ni bembe kabapala ndela ya kum'bulaga. Hata hivyo bayogwipe mwalo bandu banyansima batekanganywa ni mapundisho gake. ");
INSERT INTO ndg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kila pa yaike kitamunyo baboi mjini. ");
INSERT INTO ndg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kabatyanga bwamba, baabweni ntela wa mmwitu uyomike mpaka mikega gake yake. ");
INSERT INTO ndg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro kakombokya ni kukoya “Rabi lola, ntela wa mmwitu wa ulaanike uyomi.” ");
INSERT INTO ndg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kabayangwa, mube ni imani kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Amini nando kuwakoya kila ywa akikokeyue kitombe seno,'Boka na ukaitage wa mwene baharini mana kana ntopo masaka kumoyo wake lakini abi ni imani sa akoiye sapitya, Eyo ndivyo Nnongo atenda. ");
INSERT INTO ndg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eyo nendo kuwabakiya kila kilebe sa muyopa ni kulokiya kwa ajiri yake, amini ni mpokile navyo vya ba vinu. ");
INSERT INTO ndg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wakati wa kuyema ni kuyopa, mnapaswa kusamehe sambi naso dhidi ya mundu ywenge, ili Tate binu bambinguni abasameeni mwenga mukosa yinu. ");
INSERT INTO ndg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Zingatia: mstari uno, Lakini msipo samehe tate binu wa mbinguni ni ywembe hata wasamehe masambi ginu. ntopo mu mistari ga kale) ");
INSERT INTO ndg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Baisi Yerusalem kwa mara yenge. Yesu katyanga hekaluni, Makuhani akolo, aandishi ni agoi baisi kwake. ");
INSERT INTO ndg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kabankokeya, kwa mamlaga gani utenda iyeya?” Nyai akupei mamlaka ya kutenda gano?” ");
INSERT INTO ndg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kabakokeya, naalokiya swali limo. Nikokeyage nani naakokeya nitenda gano kwa mamlaka ga nyai. ");
INSERT INTO ndg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Je, ubatizo wa Yohana wa omi mbinguni au wapii kwa bandu? Niyangwaye.” ");
INSERT INTO ndg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kabajadiliana bene kwa bene kabashindana ni kukoya “mana tukoiye kuoma mbinguni, akoya mwalowa kele hamkumuamini? ");
INSERT INTO ndg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mana twakoya kuomba kwa bandu,... “Bayogwipe bandu, mwalo bote bakoyage Yohana abi nabii. ");
INSERT INTO ndg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kabam'yangwa Yesu ni kukoya, “Tutangike kwaa” Yesu kabakokeya, “wala nenga nabakiya kwaa kwa mamlaka gani nitenda gano. ");
INSERT INTO ndg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu katumbua kuayegana kwa mifano. Kakoya mundu apandike nngonda wa mizabibu, kuliteteleya lubego na kuemba likinga la kusudikia mvinyo. kasema mnara na kaupangisha nngonda wa zabibu kwa alemi wa zabibu kaboka kutalu. ");
INSERT INTO ndg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Palyo muda uike, amtumike mtumishi kwa alemi ba zabibu kupokya matunda kuoma kumigonda ya zabibu. ");
INSERT INTO ndg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kaba m'boywa, kabampumunda, na kabam'benga bila ya kumpaya kilebe. ");
INSERT INTO ndg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kantuma kwabe ntumishi ywenge, kabampumunda kumutwe ni kuntendeya mambo ya oni. ");
INSERT INTO ndg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bado kantuma ywenge yeya, ni yono yumo kabambulaga. Na benge kabantenda mahoba kati aga. Kaba ankombwa benge kaaam'bulaga. ");
INSERT INTO ndg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aigile mundu yumo wa kuntuma mwana mpendwa. Ni ywembe awi wa mwisho kutumwa kwabe. Kakoya “Watamsheshim mwanango.” ");
INSERT INTO ndg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lakini wapangaji kabakoyana bene kwa bene “Yono ndie mrithi. Isaye, tum'bulage ni mrithi wa ba witu.” ");
INSERT INTO ndg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kaba n'yola, kaba m'bulaga ni kuntaga kunza ya nngonda wa mizabibu. ");
INSERT INTO ndg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kwa eyo, atenda kele mwene n'ngonda wa mizabibu? Aisa ni kubaangamiza alemi ba mizabibu na kuapaya benge n'gonda wa zabibu. ");
INSERT INTO ndg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Msomike kwaa andiko elo? Libwe ambalo ajenzi balikani, libi libwe la kumbwega. ");
INSERT INTO ndg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Leno lapii kwa Bwana, na lakukanganya kumminyo gitu. ");
INSERT INTO ndg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bapai kunkamwa Yesu, lakini baypgwipe kipenga sa bandu, batangike kuba aabakiye mfano wa kilebe soo. Eyo kabanneka kaba boka. ");
INSERT INTO ndg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kabatuma mafarisayo ni Maherodia ili kuntega kwa mayegeyo. ");
INSERT INTO ndg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Palyo baike, kabankokeya, “Mwalimu, tutangike ukani mayegeyo gegote ni upendelya kwaa bandu. Uyengana ndela ya Nnongo bwiso. Je, inoike kulepa kodi kwa kaisari au la? Je tulepe au tukotoke?” ");
INSERT INTO ndg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu kabayangwa uboso wabe nikuakokeya, “Mwalowa kele mwando n'geya? Mbayaye Dinari ni ilole.” ");
INSERT INTO ndg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kabaleta yimo kwa Yesu, kabaakokeya ni sura ya nyai ni gano maandishi ga nyai? kabakoya “Ya kaisari.”Kabakokeya ");
INSERT INTO ndg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu kabakokeya, mpayaye kaisari ilebe ya kaisari ni Nnongo ilebe ya Nnongo.”Kabankanganya. ");
INSERT INTO ndg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kisha Masadukayo, bakoyae ntopo mfufuo, kaban'yendelelya. kabannokiya, kabakoya, ");
INSERT INTO ndg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mwalimu Musa atuandikie kuba, mana mundu awile ni kunleka nnwawa kiogo yake, lakini alei kwa nwawa, mundu kantola wa nnwawa wa nlongoe, ni kuipatia bana mwalo wa nlongoe. ");
INSERT INTO ndg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kwai ni alongo saba, wakwanza atweti nnwawa kawaa, alei kwa bana, ");
INSERT INTO ndg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wa nya ibele kantola ni ywembe kawaa, alei kwaa bana. Na wanyaitatu iyeya. ");
INSERT INTO ndg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ni wasaba awile bila yakuleka bana. mwisho ywa nnwawa ni ywembe kawaa. ");
INSERT INTO ndg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wakati wa ufufuo, kabayoka tena. Je, aba nyumbo wa nyai? Balyo alongo saba bote bai nyumbo wabe. ");
INSERT INTO ndg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kabakokeya, “Je hii mwalo ntebosolwa, mwalo ntangike kwaa maandiko wa ngupu ya Nnongo?” ");
INSERT INTO ndg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wakati wa kuyoka kubaa kuoma kuwaa, batola kwaa wala kuyingiya malisengele, baba kati malaika wa mbinguni. ");
INSERT INTO ndg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kuhusu kuyoka kuoma bandu bawile, msomike kwaa kitabu sa Musa, muhabari za kichaka, Ya Nnongo akoya ni kunkokeya, Nenga Nnongo wa Abrahimu, ni Nnongo wa Isaka, ni Nnongo wa Yakobo?' ");
INSERT INTO ndg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ywembe Nnongo kwa wa bandu bawile, bali Nnongo wa akoto. Ni kunza kunza mpotile.” ");
INSERT INTO ndg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mwandisi yumo aisi ni kugayowa malongelo ago abweni; Yesu ayangwi bwiso. Kanlokiya “Je ni amri gani iliyo ya muhimu muno kuliko yenge?” ");
INSERT INTO ndg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kayangwa, “ya muhimu yeno, “Yekanya, Israel Nnongo witu, Bwana yumo bai. ");
INSERT INTO ndg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Umpende Nnongo wako kwa moyo wako gote, kwa roho yako yote, kwa malango gako gote, ni kwa ngupu yako yote.' ");
INSERT INTO ndg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Amri ya nyaibele yeno, “Mpende jirani kati ya uipenda ya uipenda wa mwene.” Ntopo yenge ngolo kupita yeno. ` ");
INSERT INTO ndg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","mwandishi kakoya, “bwiso mwalimu ukoya kweli kuba Nnongo yumo bai na ntopo ywenge zaidi yake. ");
INSERT INTO ndg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kumpenda ywembe kwa moyo gote, kwa malango gote, ni kwa ngupu zako zote ni kumpenda jirani yako kati mwene, ni muhimu kuliko mapitio ni dhabuhu za kuteketeza. ");
INSERT INTO ndg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Palyo Yesu abweni apiiye jibu la busara, kaankokeya “Wenga hauko kutalu ni upwalume wa Nnongo” kuoma hapo ntopo hata yumo annokiye Yesu swali lolote. ");
INSERT INTO ndg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ni Yesu kayangwa, wakati apundisha mu hekalu, kakoya, “je, baandishi hukoya kuwa Kristo ni mwana wa Daudi? ");
INSERT INTO ndg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwene muroho mtakatifu, akoiye, “Bwana akoiye kwaa bwana wango, tama kuluboko lwango lwa mmayo, mpaka niatei maadui wako kuba pae ya magolo gako.' ");
INSERT INTO ndg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mwene Daudi ankema Kristo,'Bwana' Je, ni mwana wa Daudi buli? Na bandu banyansima bampekanyi kwa Pulaa. ");
INSERT INTO ndg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mmayegano gake Yesu kakoya, Ntame kutalu ni aandishi bapenda alyanga ni nganzi ndaso ni kusali miano kwenye masoko. ");
INSERT INTO ndg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ni kutama mukiti sa akolo mmasinagogi na musiku kuu mwa pandu pa akolo. ");
INSERT INTO ndg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pia balya mmisengo ya ajane ni kuyopa mayopo malaso ili bandu bababone. Bano bandu bapokya hukumu ngolo. ");
INSERT INTO ndg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kisha Yesu atami pae pambwega ya lisanduku la sadaka nkati ya eneo la hekalu, ai kalola bandu kabayeya pwela yabe musanduku. Matajiri bingi babei pwela ya nsima. ");
INSERT INTO ndg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kisha nnwawa mjane nkeba kayeya ipande ibele thamani ya senti. ");
INSERT INTO ndg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kabakema benepunzi bake ni kuakokeya, “Amini nandokubakiya yono mjane ayeyi kiasi kikolo muno ya balyo bote bapiye mulisanduku la sadaka. ");
INSERT INTO ndg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bingi bapiiye kuoma ni ukolo wa kipato sabe. Lakini yonooo nnwawa mjane, kuoma ni ukeba wake ayeyi pwela yote ya utumi mmaisha gake.' ");
INSERT INTO ndg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu katyanga kuoma Hekaluni, mwenepunzi yumo kanlokiya, “Mwalimu lola malibe gano gakukanganya ni masengo!” ");
INSERT INTO ndg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","kam'bakiya, “Wandobona masengo gano makolo? Ntopo hata libwe limo laingia kunani ya lyenge la tomboywa kwa pae.” ");
INSERT INTO ndg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ni ywembe palyo atami kunani ya kitombe sa mizaituni ukiogo ya Hekalu, Petro, Yakobo, Yohana ni Andrea kabanlokiya kwa siri,” ");
INSERT INTO ndg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tubakiye gano mambo gaba lini? kele dalili ya upitia gano?” ");
INSERT INTO ndg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu katumbwa kuwabakiya, “mbe makini mundu kana aba potosha. ");
INSERT INTO ndg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bingi baisa kwa lina lyango kabakoya,'Ndiye Nenga' nawatawa potosha bingi. ");
INSERT INTO ndg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Palyo mwayowa vita ni mayegeyo ya vita, kanamyogope, mambo gano gapitya bai, lakini kuke bado kuika mwisho. ");
INSERT INTO ndg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Taifa lainuka kiogo ni taifa lyenge, ni upwalume ni upwalume wenge, pabaa ni malendemo ni njara, Gono mwanzo wa utungu. ");
INSERT INTO ndg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mbe minyo, Mwapelekwa mabarazani, na mwapengwa mmasinagogi, mwayemekwa kulonge ya utawala ni ya upwalume mwalo wa nee. Kati usaidi kwabe. ");
INSERT INTO ndg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Injili lazima wete ihubiriwekumataifa gote. ");
INSERT INTO ndg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Palyo baaboywa ni kuakabidhi, kana myogope kwa selo mwakikoya, nkati ya muda gogo, mwapaywa sa kukoya, mwaba kwa mwenga mwalongela bali Roho mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nongo atanshitaki nnongo kubulaga, tate ni mwanage. Bana baakana tate ");
INSERT INTO ndg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","babe ni kusababisha babulagwe. Mwakanwa ni kila mundu mwalo wa lina lyango. Lakini ywa atama mpaka mwisho aokoka. ");
INSERT INTO ndg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mana mubweni chukizi lya uharibifu liyemi palyo lipaliwe kwa kuyema (asomaye ni atange) ndipo balyo bai kwa Yuda babutukiye ukitombe, ");
INSERT INTO ndg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ywa abi kunani ya nyumba kana aluke pae ya nyumba na kana atole kilebe sosote sa kibi kunza, ");
INSERT INTO ndg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ni ywa abi mugonda kana abuye kuisa kutola ngobo yake. ");
INSERT INTO ndg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lakini ole wabe alwawa bene tumbo ni balyo alwawa bai ni bana kabayonga eyo lisiku! ");
INSERT INTO ndg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Muyope kana ipitye lisiku ya umande. ");
INSERT INTO ndg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Paba ni masaka makolo iyo lisiku, ambayo ganopitya kwa tangu Nnongo aumbike Dunia. Mpaka mbeyambe ya inapitya kwaa na ipitya kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mpaka Bwana palyo apongoya siku, ntopo yega yaokoka, lakini mwalowa atende, abo asagula, apongoya namba za siku. ");
INSERT INTO ndg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wakati huo mana mundu yeyote kabaakokeya, lola, Kristo abi pano! au 'Lola abi palyo!' kana mwamini. ");
INSERT INTO ndg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Akriso wa ubocho ni anabii ba ubocho bapitya ni kupiya ishara ya maajabu. ili bababosolwe, Yamkini hata wateule. ");
INSERT INTO ndg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","M'be minyo! Nialogolile gano gote kabla ya wakati. ");
INSERT INTO ndg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Baada ya matabiyo ya siku eyo, lisoba layeyelwa lubendo, mwei wapiya kwa wanga wake. ");
INSERT INTO ndg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ndondwa ya tomboka kuoma kunani ni ngupu eyo ibi kunani ya lendema. ");
INSERT INTO ndg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Apo bamwona mwana wa Adamu kaisa kuma unde kwa ngupu ngolo ni utukufu. ");
INSERT INTO ndg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aatuma malaika bake ni kuakusanya pamwepe ateule bake kuoma mbande ngoto ina za Dunia, kuoma mbande ngolo ina za Dunia, kuoma mwisho wa bwee mpaka mwisho wa maunde. ");
INSERT INTO ndg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Muntela jifunzeni, kati litambe ya lipiya ni kubeka manyei gake, ndipo mwatanga kuba kiangazi kibi karibu. ");
INSERT INTO ndg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ndivyo mwabona mambo gano kagapitya, mulange abi karibu, ya nlango. ");
INSERT INTO ndg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kweli, nabakiya, seno kibelei kipeta kwa kutalu kabla mambo gano ganapitya. ");
INSERT INTO ndg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maunde ni bwee wapeta lakini mayaulyo gango gapeta kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kuhusu eyo lisiku au saa, ntopo oyo atanga, hata malaika wa kunani, wala Mwana, ila Tate. ");
INSERT INTO ndg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","M'be minyo lola, mwalo ntangike kwaa muda gani yapitya. ");
INSERT INTO ndg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ni kati mundu ayenda safari: kaleka nsengo wake, ni kumbeka mbanda wake kuba ntawala wa nsengo, kila mundu ni kazi yake. Ni kum'bakiya mlinzi kutama minyo. ");
INSERT INTO ndg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","kwaiyo m'be minyo! kwani mtangike kwaa mwene nsengo lisiku gani ubuya ukasake, ya wezekana kitamunyo, kiloo, palyo nzogolo abeka, au bwamba. ");
INSERT INTO ndg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mana aisi gafla, kana akubone ugonzike. ");
INSERT INTO ndg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Eso nikubakiya wenga ni m'bakiya kila mundu: kana mgonza. ");
INSERT INTO ndg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yabi siku ya nyaibele bai baada ya lisiku ya Pasaka ni mikate yangayeyelwa nzaso. Makuhani akolo ni baandishi bai kabapala namna ya kum'boywa Yesu kwa hila ni kum'bulaga. ");
INSERT INTO ndg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kwa kuwa bakoiye, “wakati gono kwa wa sikukuu, bandu kana baise kutenda gasia”. ");
INSERT INTO ndg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Palyo Yesu abi Bethaia kaasake Simoni mkoma, kayenda pameza, nnwawa yumo kaisa ni chupa ya marashi ya nardo ya pwela ngolo muno, katula ni kuyitiya kumutwe wake. ");
INSERT INTO ndg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pai benge bakasilike, bate kokeyana bene kwa bene kabakoya”sa upotevu gono? ");
INSERT INTO ndg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Manukato gano gabi kusulusa zaidi ya dinari mia tatu kabapaywa akeba.”Nibembe kabankoya. ");
INSERT INTO ndg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu kakoya 'Nnekaye yika yake. Munkundiya kele masaka? Alei kilebe kinoke kwangu. ");
INSERT INTO ndg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kila lisiku akeba m'binabo, muda wowote wa mana mupenda kuatendya ganoike atendyaye. Lakini muba kwa minee muda wote. ");
INSERT INTO ndg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Atei sa akiwesike aipakiye yega yango mauta kwaajili ya masiko. ");
INSERT INTO ndg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kweli niabakiya, kila pandu injili apo ihubiriwa Dunia nzima, sa akitei nnwawa yono salongelwa kwa ukombokeyo wake. ");
INSERT INTO ndg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuda Iskariote, yomo kati ya balyo komi ni ibele ayei kwa makuhani akolo ili apa kuapaya. ");
INSERT INTO ndg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Akuhani akolo palyo bayowine iyeyo, bate pulai ni kuahidi kumpaya pwela. Katumbua kupala nafasi ya kumkabidhi kwabe. ");
INSERT INTO ndg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","lisiku ya kwanza ya mkate wanga yeyelwa nzaso palyo bapiiye mwana ngondolo wa pasaka, benepunzi bake kabankokeya, “Upala tuyende kwako tukaandae ili upate kulya kilalyo sa Pasaka?” ");
INSERT INTO ndg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kabatuma benepunzi bake abele kikualokiya, “Yendaye mjini mwabonagana ni nnalome apotwi kibenga. Munkengame. ");
INSERT INTO ndg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nyumba ayingya, nkotaye na nlokiyaye mwenye nsengo ogo “Mwalimu alokiye,” Kibii kwaa chumba cha ageni pandu nalya pasaka ni benepunzi bango?” ");
INSERT INTO ndg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aobonenya kyumba sa kunani kikolo kibii ni samani kibii yayari. Tendaye maandalizi kwa ajili yitu palyo.” ");
INSERT INTO ndg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Benepunzi baboi kabayenda mjini babweni kila kilebe kati ya babakiywe, kabatengeneya kilalyo sa Pasaka. ");
INSERT INTO ndg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wakati yai kitamwinyo, aisi ni balyo komi ni ibele. ");
INSERT INTO ndg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kabaikaribia meza ni kulya, Yesu kakoya, “kweli nando kuabakiya, yumo kati yinu alya pamwepe ni nee angana.” ");
INSERT INTO ndg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bote kaba sikitika, yumo yumo kabankokeya “Balatu nenga kwaa?” ");
INSERT INTO ndg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu kayangwa ni kuakokiya, yumo kati ya komi ni ibele nkati yinu, yumo mbeyambe ayeya ndonge mubakuli pamwepe ni nee. ");
INSERT INTO ndg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kwa kuwa mwana wa Adamu ayenda kati aya maandiko gakoya kunani yake. Lakiniole wake mundu ywa kupitya ywembe mwana wa Adamu aakanwa! Yai bwiso muno kana aibelikwe kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kabalyaa, Yesu katola mkate, kaubariki ni kuutekwa. Kapaya kakoya, “Tolaye, yeno yega yango.” ");
INSERT INTO ndg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Katola kikombe, akashukuru, ni kwapaya ni bote kabanywaa. ");
INSERT INTO ndg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kabaakokeya, “yeno damu yango ya agano, damu iyitikayo mwalo wa bingi. ");
INSERT INTO ndg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kweli niakokeya, ninywa kwaa lelo mukibelei seno sa lizabibuy mpaka lisiku ya ninywaa ya ayambe kwa upwalume wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Palyo bayomwile kuyemba wimbo, bayei kuya katika kunnema wa Mizeituni. ");
INSERT INTO ndg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu kabakokeya, “Mwenga mwabote mwatama kutalu mwalo wa nee, mwalo iteandikwa,'nankombwa mchungaji ni ngondolo batawanyika.' ");
INSERT INTO ndg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lakini baada ya kuyoka kwango, naalongoylya kulonge yinu Galilaya.” ");
INSERT INTO ndg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petro kam'bakiya, “Hata mana bote bakulei nee nikuleka kwaa.” ");
INSERT INTO ndg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu kam'bakiya “kweli nikubakiya, kilo yeno kabla nzigolo anabeka malaibele, wangana mara tatu” ");
INSERT INTO ndg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lakini Petro akoiye “Nibi tayari kuwaa pamwepe ni wee, nikukana kwaa.”bote bapiiye ahadi yeyelo. ");
INSERT INTO ndg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Baisi kulieneo likemwage Gethsemane, ni Yesu kabaakokeya benepunzi bake “tameni pano wakati nasali.” ");
INSERT INTO ndg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kabatola Petro, Yakobo ni yohana pamwepe ni ywembe katumbua kuhuzunika ni kukunda masaka muno. ");
INSERT INTO ndg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kabaakokeya, “Nafsi yango ibii ni huzuni muno, hata kuwaa mtame pano kana mugonze.” ");
INSERT INTO ndg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu ayei kulonge kidogo katomboka pae, kayopa, mana iwezekana saa yeno ingemuepuka.” ");
INSERT INTO ndg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akoiye “Aba Tate kila kilebe kwako sando wezekana niboyee seno kikombe. Lakini kwa mapenzi gango kwaa bali kwa mapenzi gako.” ");
INSERT INTO ndg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aabui ni kuabona baginzike, ni kankokeya Petro, Simoni, ugonzike? uwesike kwaa kutama minyo hata saa yimo? ");
INSERT INTO ndg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kana mugonze ni muyope kana muise kuyingya kwenye majaribu. Hakika Roho abi radhi lakini yega dhaifu.” ");
INSERT INTO ndg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ayei tena kuyopa, na atumile yayegeyo gagalyo. ");
INSERT INTO ndg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aisi tena kababon bagonzike, minyo gabe gai gatopike, batangike kwaa kele sa kumualya. ");
INSERT INTO ndg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aisi mara ya nyaitatu ni kuabakiya “mke mkagonza ni kupomolya? Ilengani muda uike. Lola mwana wa Adamu bankana mmaboko mwa bene sambi. ");
INSERT INTO ndg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yumukaye, tuboke lola ywa angana abi karibu.” ");
INSERT INTO ndg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Palyo kalongela bai, Yuda, yumo wa balyo komi ni ibele, aike, ni kipenga sa bandu kuoma kwa makuhani akolo, aandishi ni agoi bai ni mapanga ni ipeke peke mmoko. ");
INSERT INTO ndg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Msaliti apayi ishara ywa nambusu ngaywembe mboywaye mumpeleke pae ya ulinzi.” ");
INSERT INTO ndg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda kuika bai kayenda kwa Yesu ni kukoya “mwalimu” kam'busu. ");
INSERT INTO ndg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kaban'yeya pae ya ulinzi ni kum'boywa. ");
INSERT INTO ndg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yumo kati yabe ayemi karibu yake kapiya upanga wake ni kumpumunda ni kumkata likutu mtumishi wa kahani nkolo. ");
INSERT INTO ndg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu kabaakokeya “muisi kuniboywa ni mapanga, mapekepeke kati kingongolo? ");
INSERT INTO ndg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wakati kila lisiku nibii na mwenga kanipundisha hekaluni, muniboywi kwaa. leno mulitei ili maandiko yatimie. ");
INSERT INTO ndg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Balyo bote bai ni Yesu banlei ni kubutuka. ");
INSERT INTO ndg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","mwisembe yumo kankota, abii aweti shuka bai aigubike kunteteleka, kabankamwaa. ");
INSERT INTO ndg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kapolonyoka kaleka suka ni kubutuka utopo. ");
INSERT INTO ndg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kabanlongoya Yesu kwa kuhani nkolo. Palyo bakusanyike makuhani akolo bote, agoi, ni aandishi. ");
INSERT INTO ndg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro ni ywembe kankota Yesu kwa kutalu, kuyenda kulua ya kuhani nkolo. Atami pamwepe ni alinzi, bai karibu ni moto kabayota kupala lyoto. ");
INSERT INTO ndg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Muda ogo makuhani akolo ni ni baraza lote baika bapala ushaidi kuhusu Yesu ili bapate kum'bulaga. lakini baaupatike kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kuba bandu bingi baletike ushuhuda wa uboso dhidi yake, lakini ushahidi wabe upwanine kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Benge kabayema ni kupiya ushaidi wa ubosho dhidi yake, kabakoya, ");
INSERT INTO ndg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Twan'yowine kukoya, nilipimwanane leno liekalu lisengikwe nimaboko.” ");
INSERT INTO ndg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","lakini ushaidi wabe upwanine kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kuhani akolo ayemi katikati yabe ni kunlokiya Yesu “Je wantopo saugwaa? bandu aba bakoya kele kwako?” ");
INSERT INTO ndg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aatami poloi ayangwi kwea kilebe. Kuhani nkolo kanlokiya tena “wenga wa kristo, mwana wa m'barikiwa?” ");
INSERT INTO ndg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu kakoya “Nenga oyo. Na ummona mwana wa Adam atami lumoko wa mmulyo wa ngupu kaisaa ni maunde ya mbinguni.” ");
INSERT INTO ndg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kuhani nkolo apapwile ngobo yake ni kukoya “Je bado tukapala mashaidi? ");
INSERT INTO ndg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Muyowine kupulu. Muamua kele? bote bate muhukumu kati mundu wakuwaa. ");
INSERT INTO ndg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Benge kabatumbwa kumuunia mata ni kumgubika kuminyo ni kumkombwa ni kunkokeya, “Tabiri!” Maafisa kaba mpotya ni kumpumunda. ");
INSERT INTO ndg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petro bado abi pae kuyeto, mtumishi yumo muenza wa kuhani nkolo kaisa kwake. ");
INSERT INTO ndg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kammona Petro palyo ayemi kayota moti, kanlokiya kwa kumsogelea kisha kakoya, ni wenga wabi ni mnazareti Yesu.” ");
INSERT INTO ndg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lakini kakana, kakoya, nenga kwaa wala ndangike kwaa eso ukoya” Kapita kayenda kunza kuyeto ");
INSERT INTO ndg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Lakini ntumishi nnwawa amweni palyo ayemi katumbwa kuwakokeya balyo bai bayemi palyo “Mundu oyo babalyo!” ");
INSERT INTO ndg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lakini kakana tena. baada balyo bai bayemi palyo bai kabankokeya Petro “Balatu wenga babalyo maana wenga wa Galilaya”. ");
INSERT INTO ndg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Katumbwa kuibeka mwene pae ya laana ni kulapa, “Nitangike kwa mundu oyo munkoya”. ");
INSERT INTO ndg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nzogolo kabeka tena mara ya nyaibele. Petro kakombokeya mayegeyo ya Yesu aam'bakiye “Wangana mara tatu, kabla nzogolo ana beka mara ibele. Katomboka pae ni kulela. ");
INSERT INTO ndg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bwamba muno akolo ba makuhani bakusanyika pamwepe ni agoi ni aandishi ni baraza zima la agoi. Kabantaba Yesu ni kumpeleka kwa Pilato. kanlokiya, “Wenga wa mpwalume wa wayahudi? ");
INSERT INTO ndg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","kayangwa, “wenga ukoiye eyo”. ");
INSERT INTO ndg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Akolo ba makuhani kabakoya mashitaka mengi kuhusu Yesu. ");
INSERT INTO ndg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato kanlokiya tena, “uyangwa kwaa sosote? ubona kwaa eyo kushitaki kwa mayaalo mengi? ");
INSERT INTO ndg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lakini Yesu an'yangwa kwa Pilato, ni eyo yate kunkanganya. ");
INSERT INTO ndg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kwa kawaida lisiku ya sikukuuu kunlekeya mfungwa yumo, mfungwa ywa an'yopike. ");
INSERT INTO ndg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kwaii waharifu muligereza, miongoni mwa abele gaji bateasi kabatumikia makosa yabe. Abi mundu yumo akemmwa Baraba. ");
INSERT INTO ndg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bandu banyansima kabaisa kwa pilato ni kun'yopa atende kati ya atei uko nkyogo. ");
INSERT INTO ndg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato kayangwa ni kukoya, “mupala nia ndulye mpwalume wa wayahudi?” ");
INSERT INTO ndg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Aatangike bwiu wa aakolo ba makuhani kum'boywa ni kumpeleka kwake. ");
INSERT INTO ndg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Akolo ba makuhani basosile sa kipenga sa bandu kuguta ni kukoya alekwe Baraba badala yake. ");
INSERT INTO ndg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato kayangwa tena ni kukoya, “Nintende kele mpwalume wa wayahudi?” ");
INSERT INTO ndg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kabaguta lelo “msulubishe” ");
INSERT INTO ndg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato kakoya “atei libaya gani? bayongiye kuguta ni kukoya msulubishe” ");
INSERT INTO ndg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato kaba apulaisha kanlekeya Baraba. Kaamkombwa Yesu mjeredi kisha kampiya ili asulubiwe. ");
INSERT INTO ndg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Askari kabanlongoya mpaka mulua (wa ubi nkati ya kambi) bakusanyike pamwepe ni kikosi cha askari. ");
INSERT INTO ndg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kabam'waliya Yesu ngazu ya zambarau, kaba pota taji ya miiba kaba mwaliya. ");
INSERT INTO ndg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kabatumbwa kumueka ni kukoya “salam mpwalume wa wayahudi!” ");
INSERT INTO ndg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kabankombwa kumutwe ni milai ni kumuuniya mata kaba beka mayua yabe pae kwa kumheshim. ");
INSERT INTO ndg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kabayomwa kumdhihaki, kaba muule ya kanzu ya zambarau ni kumwaliya ngobo yake, kabampiya panza kuyenda kumsulubisha. ");
INSERT INTO ndg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kabamlazimisha mpeta ndela kun'gangata abi kuoma kumiginda kayingiya mjini akemwage Simoni mkerene (Tate bake Iskanda ni Rufo); kabanlazimisha kupotwa msalaba wa Yesu. ");
INSERT INTO ndg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Askari kabampeleka Yesu pandu pakemwa Goligotha (maana ya tafsiri yeno ni pandu paliupa l lundoi). ");
INSERT INTO ndg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kabampya mvinyo uangabinwe ni manemane lakini anywi kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kabamsulubisha ni kunagana ngobo yake kaba paga kula luamua eso apata kila askari. ");
INSERT INTO ndg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yabi saa tatu bwamba palyo bate kumsulubu. ");
INSERT INTO ndg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kababeka lubao kunani kabaandika shitaka “Mpwalume wa Wayahudi.” ");
INSERT INTO ndg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kaba msulubisha ni majambazi abele, yumo luboko wa mmulyo ni yumo luboko lwa nkeya wake. ");
INSERT INTO ndg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Balyo kabapeta bai kabantukana, kaba iniya mutwe ni kukoya, “Aha! wenga wa kupi mwana lihekalu ni kusenga kwa sikutatu, ");
INSERT INTO ndg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jiokoe wa mwene ni uuluke pae viboye apa pamsalaba. ");
INSERT INTO ndg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","kati iyeya akolo ba makuhani wakimdhihaki kabakoyana pamwepe ni aandishi ni kukoya, “Aokwile benge lakini mwene ashindikewe kuiokwa. ");
INSERT INTO ndg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristo mpwalume wa Israel uluka pae kuoma msalabani, ili tupate kubona ni kuamini “ni balyo basulubiwe pamwepe walimdhihaki. ");
INSERT INTO ndg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kuika saa sita, lubendo lwa isi nnema nzima paka saa tisa. ");
INSERT INTO ndg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Muda wa saa tisa Yesu kaguta kwa sauti ngolo, eloi, eloi lamasabaktane? yabini maana ya “Nnongo wango, Nnongo wango mwalowa kele kunileka? ");
INSERT INTO ndg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Balyo bayemi kuyowa eyo kaba koya “lola, ankema Eliya”. ");
INSERT INTO ndg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mundu yumo kabutuka ni kuyenda kutola siki ni kuibeka musiponchi ni kubeka kunani ya malai ni kumpaya ili anywee. mundu yumo kakoya “lenda tubone oyo Eliya aise kumuuluya pae. ");
INSERT INTO ndg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","kisha Yesu kalela kwa sauti ngolo kawaa. ");
INSERT INTO ndg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pazia ya hekalu labaganike ipande ibele kuoma kunani mpala pae. ");
INSERT INTO ndg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ofisa yumo ayemi kaegenda kwa Yesu ya kummona wawile ya abile kakoya “kweli yono mundu abi mwan wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Baii alwawa kutalu kabalola. nkati yabe ai Mariamu Magdarena, Mariam (mao bake Yakobo mnunage Yose) ni Salome. ");
INSERT INTO ndg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kwa Galilaya bankotike ni kuntumikia ni alwawa wa benge bingi, pia alongwaniye mpaka Yerusalem. ");
INSERT INTO ndg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kuika kitamwinyo, kwa kuwa yabii lisiku ya maandalio ya sabato, ");
INSERT INTO ndg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Palyo kaisa Yusufu wa Arimathaya, aii nyumbo wa baraza mundu wa heshima anageutarajia upwalume wa Nnongo. Kayenda kwa Pilato ni kuyopa mmwili wa Yesu. ");
INSERT INTO ndg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato kakanganya kuba Yesu tayari awile, kankema ywa afisa ni kunnokiya kama Yesu awile. ");
INSERT INTO ndg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Palyo apatike uhakika kuoma kwa afisa kwamba Yesu awile, kankokeya Yusufu akautole yega. ");
INSERT INTO ndg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu apemike sanda kaamualaga kuoma msalabani, kantola ni sanda ni kumbeka muli kaburi liyembikwe kummwamba kisha kalibeka libwe kunlango wa kaburi. ");
INSERT INTO ndg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariam Magdalena ni Mariamu mao bake Yose babweni pandu pa Yesu asikikwe. ");
INSERT INTO ndg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Palyo sabato iyomwike, Mariam Magdalena ni Mariamu mao bake Yakobo ni Salome, bapemike manukato ganoike, ili baise kupakaya mauta yega wa Yesu kwaajili ya kunsika. ");
INSERT INTO ndg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Meke, bwamba lisiku ya kwanza ya juma, bayeyi kuli kaburi palyo lisoba lipii. ");
INSERT INTO ndg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kabakoyana bene kwa bene, “Nyai aalipiya libwe mwalo watwee ili tuyingii muli kabuli?” ");
INSERT INTO ndg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ya kulola, kuba mmona mundu kalipiya libwe, labi likolo muno. ");
INSERT INTO ndg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kabayingiya mulikaburi ni kummona mwinsembe aweti joho leupe atami mmalyo, kabakaganywa. ");
INSERT INTO ndg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kabaakokeya kana n'yope, mumpala Yesu, wa Nazarethi aliye sulubiwa ayokike! ntopo pano lola palyo baibambei. ");
INSERT INTO ndg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yendaye mkaabakiye benepunzi bake ni Petro kuba alongolile Galilaya, mwammona ako kati yaa abakiye”. ");
INSERT INTO ndg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Baaaboi ni kubutuka kuoma kulikaburi kabalendema ni kukanganya. Bakoiye kwa kilebe kwa mundu yeyote ywa mwalo bale yogopa muno. ");
INSERT INTO ndg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","mapema lisiku ya kwanza ya juma, baada ya kuyoka, ampitii kwanza Mariam Magdalena. Kuoma kwake kumpiya nsela saba. ");
INSERT INTO ndg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aaboi ni kuakokeya balyo bai pamwepe ni ywembe palyo kaba huzunika ni kupiya moli. ");
INSERT INTO ndg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bayowine kuba nkoto ni abonekine nagye lakini bamwaminike kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","kuoma hapo, kaitokeya kwa namna yenge kwa benge abele kabatyanga kuoma kati ya nchi. ");
INSERT INTO ndg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bayei ni kuakokeya benepunzi benge baingile lakini baaminike kwaa. ");
INSERT INTO ndg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yesu kapita kwa balyo komi ni yimo bai baegami meza, nikabakoya kwa kutoamini kwabe ni kunonopa kwabe kwa mayo, mwalo hawa kuwaamini balyo babweni baada ya kuyoka kuoma kwa wafu. ");
INSERT INTO ndg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kabaakokeya “Eyendaye mkahubiri injili Dunia nsima na kwa ilebe yoti. ");
INSERT INTO ndg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ywaa aamini ni kubatizwa aokolewa, ni ywa aamini kwaa aahukumiwa. ");
INSERT INTO ndg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ishara yeno ya yendana ni balyo bote waamonio. Kwa lina lyango bapiya nsela. kabakoya kwa lugha ya ayambe. ");
INSERT INTO ndg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kabakamwa nyoka kwa maboko gabe, hata mana banyii kilebe sosote sa kufisha kiadhuru kwaa. baabeka maboko kwaa abinye, ni benmbe babaakoto.” ");
INSERT INTO ndg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Baada ya Bwana kukoya nabo, katolwa kunani mbinguni na atami luboko lwa mmulyo wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Benepunzi baboi ni kuyenda kuhubiri kila pandu, Bwana katenda nabo kazi ni kuthibitisha liyaulyo kwa miujiza ni ishara kaikota. ");
INSERT INTO ndg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bananchima batikujitahidi beka katika mpangilio malongelo usu makowe ambago gabatimizike nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kati gabatupeile twenga, ambago tangu nkiogo nga masaidi wa minyo ni apangachi wa barua. ");
INSERT INTO ndg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na nenga kai, baada ya chunguza kwa lingulya chanzo cha makowe aga goti boka nkiogo-nibweni nzuri kwango kae kukuandikya katika mpangilio wake mheshimiwa muno Theofilo. ");
INSERT INTO ndg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Linga wete uwese tanga ukweli wa makowe gaupundishilwe. ");
INSERT INTO ndg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Katika machoba ga Herode, mfalme wa Yudea, pabi ni mchungaji fulani akemelwa Zekaria, wa lukolo lwa Abiya. Nnyumbowe apitike kwa ainja ba Haruni, ni lina lyake amelwae Elizabeti. ");
INSERT INTO ndg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Boti babi ni haki nnonge ya Nnongo, batyangite bila lawama katika amri yoti ni malagano ga Ngwana. ");
INSERT INTO ndg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lakini babile ni mwana, kitumbu cha Elizabeti abi n'gumba, ni kipindi chii babi agoi muno. ");
INSERT INTO ndg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tumbwe yapitike Zakaria abi mu uwepe wa Nnongo, kayendelya na lyengo lya kiuchungaji katika utaratibu wa zamu yake. ");
INSERT INTO ndg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lingana na desturi ya chawa achungaji ywako ywapala huduma, bachawii kwa kura jingya mu kanisa lya Ngwana ni apetutuya ubani. ");
INSERT INTO ndg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Likundi lyoti lya bandu bende lola panja wakati wa tutuya ubani. ");
INSERT INTO ndg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tumbwe malaika wa Ngwana atikumpitya ni kuyema upande wa mmalyo wa madhabahu ga tulukia. ");
INSERT INTO ndg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaria atiyogopa pamweni; hofu yatikuntumbukya. ");
INSERT INTO ndg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lakini malaika amakiye, “kana uyogope Zakaria kwasababu luba kwako kuyuanike. nnyumbowo Elizabeti akupapya mwana, lina lyake wankema Yohana. ");
INSERT INTO ndg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Upapanga ni puraha ni changamka, ni banambone bapapulaikya belekwa kwake. Kwa kuwa apanga nkolo, nnonge ya minyo ga Ngwana. ");
INSERT INTO ndg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hanywa kwaa wembe ni apanga atwilile Roho mpeletau tangu ndumbo ya mao bake. ");
INSERT INTO ndg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na bandu banambone ba Israel bapakun'galambukya Ngwana Nnongo wabe. ");
INSERT INTO ndg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ayenda nnonge ya kuminyo kwa Ngwana katika mwoyo ni ngupu ya Eliya. Apanga nyaa linga buyanganiya mioyo ya tate kwa bana linga bangali panga bayende katika hekima ya bene haki. Apanga nya kuabuka tayari Ngwana bandu ambabo babaandalilwe kwaajili yake.” ");
INSERT INTO ndg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria amakiye malaika, “Ngawecha kwa tanga aga? Kwasababu nenga na n'goi na nyumbo wangu miaka yake yanambone muno.” ");
INSERT INTO ndg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaika atiyangwa na kummakiya, “Nenga na Gabrieli, ambaye niyima nnongi ya Nnongo. Natitumilwa kukubakia, kukuletya habari yino nzuri. ");
INSERT INTO ndg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na linga walongela kwaa, watama chichi, wawecha kwaa longela mpaka lichoba lilo gapapita makowe aga. Hayii kwasababu washindwi ubilya maneno gango ambago gapatimya kwa wakati waupalikwa.” ");
INSERT INTO ndg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tumbwe bandu babanendaye Zakaria. Batichangala kwamba atumiaye muda wanambone mulikanisa. ");
INSERT INTO ndg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lakini papitike panja hawechike kwaa longela nabo. Batangite apatike maono pabile mulikanisa ayendelyae tangya na na alongei kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yapitike lichoba lya huduma yake yomoka aboi buyangana kachake. ");
INSERT INTO ndg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Baada ya Zakaria buyangana kachake boka kuhuduma yake mukanisa, nnyumbo wake abi ni ndumbo. Na ywembe aboi kwaa boka munyumba yake muda wa miei mitano. Abaite, ");
INSERT INTO ndg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Alii nga alipangite Ngwana apangi kwangu panilingite kwa upendeleo linga abuye oni yangu nnonge ya bandu.” ");
INSERT INTO ndg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nambiyambi katika mwei wa sita wa ndumbo ya Elizabeti, Nnongo amakiye malaika Gabrieli yenda nnema wa Galilaya walikemelwa Nazareti, ");
INSERT INTO ndg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kwa bikra ywabile akobikwe na nnalome ambaye lina lyake labile Yusufu, Ywembe abile ywa lukolo lwa Daudi na Lina lya bikra aywo labile Mariamu. ");
INSERT INTO ndg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aichi kwake na baya, “Salamu, wenga waupokile nnema ngolo! ywaakupendile Ngwana.” ");
INSERT INTO ndg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Lakini malongelo ga malaika gatikunyangabana na haelewite kwaa kwanamani malaika alongei salaamu yii ya ajabu kwake. ");
INSERT INTO ndg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaika ammakiye, “Kana uyogope, Mariamu, maana upatike nema boka kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Linga wapotwa ndumbo katika litumbo lyako na wapapa mwana. Na wenga upakunkema lina lyake 'Yesu'. ");
INSERT INTO ndg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Apanga nkolo na akemelwa mwana ywabile kunani muno, Ngwana Nnongo ampeya iteo ya enzi ya Daudi tate bake. ");
INSERT INTO ndg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Atatawala katika lukolo lwa Yakobo milele ni ufalme wapanga kwaa na mwisho. ");
INSERT INTO ndg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariamu ammakiye malaika, lino lyapita kwa namna gani, kwa maana nagonja kwa ni nnalome yeyoti? ");
INSERT INTO ndg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika kayangwa na kummakiya, “Roho mpeletau akuichila kunani yako, na ngupu ywa ywabile kunani muno yaicha kunani yako. Kwa nyoo, mpeletau ywa belekwa akemelwa Ngwana wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Linga nongo wako Elizabeti ai ni ndumbo wa mwana katika umri wa ugoi wake. Wuno nga mwei wa sita kwake, ambae bakemae n'gumba. ");
INSERT INTO ndg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ntopo lya lishindikana kwa Nnongo” ");
INSERT INTO ndg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariamu ngabaya, “Linga, Nenga na mpangakachi nnwawa wa Ngwana. Leka ibe nyo kwangu sawasawa ni malongelo gako,” Boka po malaika nga nnekite. ");
INSERT INTO ndg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ndipo katika machuba go Mariamu ngaaboi ni yenda upesi katika ilambo ya itumbi, ilambo ya Yudea. ");
INSERT INTO ndg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ayei pa nnyumba ya Zakaria ni kuntaka hali Elizabeti. ");
INSERT INTO ndg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tumbwe yapitike pa yoine salamu ya Mariamu, mwana ndumbo yake atiguluka, ni Elizabeti atwilile Roho mpeletau. ");
INSERT INTO ndg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Apiyite lilobe lyake ni kabaya kwa lilobe likolo, ““Ubarikiwe wenga muno katika alwawa, ni mwana ywa bile mndumbo yako atibarikiwa. ");
INSERT INTO ndg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na ipangite kitiwi kwangu, mao wa Ngwana wango yapalikwe aiche kwangu? ");
INSERT INTO ndg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kwa kuwa linga, paliyuanike mmachikilo gangu lilobe lya abari, mwana ndumbo yangu atighuluka kwa puraa. ");
INSERT INTO ndg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ni abarikiwe nwawa yulo ambaye aaminile wapita ukamilifu wa makowe galo ghabikiilwe boka kwa Ngwana.” ");
INSERT INTO ndg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariamu abayite mwoyo wango unnuba Ngwana, ");
INSERT INTO ndg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ni roho yango upulaikwe katika Nnongo mwokozi wango. ");
INSERT INTO ndg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwa maana alingite hali yango ya pae ya mpanga kachi wake nnwawa. Linga, tangu nambiyambi katika babaelekwa boti bapakunikema wanibarikiwe. ");
INSERT INTO ndg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kwa maana wembe ywan'gwechike apangite makoe makulu kwangu, na lina lyake ni lipeletau. ");
INSERT INTO ndg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Rehema yake yatitama buka kizazi hata kizazi kwa balo babamheshimu ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ailangi ngupu kwa luboko lwake; atikuapalagana balo ambao bendekuipuna kunani ya mawacho ga mioyo yabe. ");
INSERT INTO ndg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Atikuaeleya pae bana ba afalme boka katika iteo yabe ya enzi na kuakakatuya kunani babale hali yabe pae. ");
INSERT INTO ndg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Atikubayutuya bene njala kwa ilebe inanoga, bali matajiri atiabenga maboko ga bure. ");
INSERT INTO ndg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Apiite msaada kwa Israel mtumishi wake, linga kumbukiya rehema. ");
INSERT INTO ndg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(Kati cha longei kwa tati bitu) kwa Abraham ni lukolo lwake milele.” ");
INSERT INTO ndg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariamu atami na Elizabeti yatimi miei itatu nga abuyangine kachake. ");
INSERT INTO ndg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tumbwe wakati watimile kwa Elizabeti papa mwana wake akombwike mwana nnalome. ");
INSERT INTO ndg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Majirani bake na alongela bayoine jinsi Ngwana mwaikuyite rehema kwake, na batipulaika pamope ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tumbwe lyapitike lichoba lya nane baichi kumwina mwana. Yapalikwe kumkema lina lyake, “Zakaria”, kwa kuzingatia lina lya tati bake, ");
INSERT INTO ndg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Lakini mao bake ayangwi ni kubaya, nyonyo kwaa, atikemelwa Yohana.” ");
INSERT INTO ndg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bammakiye ntopo hata yumo katika alongo ywa kemelwa lina lelo.” ");
INSERT INTO ndg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bampangii ishara tati bake ashilia ywembe apalike lina akemelwa nyai. ");
INSERT INTO ndg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tati bake apalikwa kibao cha andikiya, na andika “lina lyake Yohana.” boti balichangala leno. ");
INSERT INTO ndg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Gafula nkano wake watiyughulikwa na lulimi lwake lwapangite ulu. Atilongela ni kunnumba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Woga watikuwachilya boti babatami karibu ni bembe. ");
INSERT INTO ndg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Makowe choti cha itumbi ya Yudea. Na boti babayowine batikugatunza mumioyo yabe, babayite, “mwana yu wa namna gani? kwasababu luboko lwa Ngwana wabile pamope ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tate bake Zakaria atwilile ni Roho mpeletau na piya unabii, abayite, ");
INSERT INTO ndg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Alumbilwe Ngwana, Nnongo wa Israel, kwa sababu atikusaidia na shughulikiya wokovu kwa bandu bake. ");
INSERT INTO ndg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atikakatulile mbembe ya wokovu katika, nyumba mpanga kachi wake Daudi, boka nkati mwa lukolo mwa mpanga kachi wake Daudi, ");
INSERT INTO ndg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kati cha bayite kwa nkano wa manabii bake bababile katika wakati kunchogo. ");
INSERT INTO ndg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Atukombwa boka kwa adui bitu na boka mwaboko mwa boti babachukya. ");
INSERT INTO ndg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Apangite nyaa langiya rehema kwa tati bitu, na kumbukya lilagano lyake takatifu. ");
INSERT INTO ndg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kilapo cha kibayite kwa Abrahamu tati bitu. ");
INSERT INTO ndg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Atilapa thibitisha kwamba ywawechekana kumtumikiya ywembe bila yogopa, baada ya kombolelwa boka katika maboko ga adui bitu. ");
INSERT INTO ndg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Katika utakatifu na haki nnonge ya machuba gitu goti. ");
INSERT INTO ndg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","E'lo, na wenga wa mwana, makemelwa nabii ywa ywabile kunani muno, kwa kuwa wayendelya nnongi ya kuminyo ya Nwana linga kumwandaliya ndila, kubaandaa bandu kwaajili ya icha kwake. ");
INSERT INTO ndg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kubafahamisha bandu bake kwamba, bakombolelwa kwa ndila ya kuaminiya dhambi yabe. ");
INSERT INTO ndg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Lino lipapita kwa sababu ya lwongulwa Nnongo witu, ");
INSERT INTO ndg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kuamulikya kwabe babatama mulubindu na katika kiwili cha mauti, Apanga nyoo kugalongoya maghulu gitu katika ndila ya amani.” ");
INSERT INTO ndg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tumbwe yulo mwana atikula na panga mwene ngupu mu mwoyo na atami mmwitu mpaka machuba gapitike kwa Israel. ");
INSERT INTO ndg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","nambeambe katika lichoba liyo, yatibonekana kwamba kaisari Agusto apiite agizo kumuelekeza kwamba itolekwe sensa ya bandubaatama mulunia. ");
INSERT INTO ndg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yeno yabile ni sensa ya kwanza yaipangilwe muda Krenio abile gavana wa Siria. ");
INSERT INTO ndg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","nyoo kila yumo atiyenda mjini kwayenda yakuandikisha sensa. ");
INSERT INTO ndg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Niywembe Yusufu atiboka kae katika mji wa Nazaleti kwa Galilaya na atisafiri Yudea kwa mji wa Bethlehemu, utangilikwa kati mji wa Daudi, kwa sababu atepitiya lukoloo lwa Daudi. ");
INSERT INTO ndg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Atiyenda kwa kujiandikicha pamope na Mariamu, ywembe abile kobeka na abile pekaniliya mwana. ");
INSERT INTO ndg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nambeyambe atikuipya kwamba, pabile kolo muda wake wa papa mwana utimile. ");
INSERT INTO ndg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Apapite mwana nnalome, mmbeleko wake wa kwanza, atikumbilingia ngobo muyega atikumlendelana mbepo mwana. Boka po atikumbeka kwenye liholilyalelya inyama, kwasababu yabile ntopo nafasi kwenye nyumba ya wageni. ");
INSERT INTO ndg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Katika eneo lelo, babile bachungaji mmigunda batilendanga kipenga sa ngondolo wabe kilo. ");
INSERT INTO ndg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ghafla, malaika wa Ngwana atibonekana, na utukufu wa Ngwana uting'ara kubatindiya, ni babile na hofu muno. ");
INSERT INTO ndg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ndipo malaika atikuwabakia “Lana muyogope”kwa sababu natikubaletya habari njema ambayo ipala kululetya puraha ngolo kwa bandu boti. ");
INSERT INTO ndg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Leno mwokozi atibelekwa kwaajili yinu mjini mwa Daudi! ywembe nga Kristu Ngwana! ");
INSERT INTO ndg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yeno nga ishara ambayo tupeilwe, mpala kumkolia mwana atitabilwa ngobo ni atigonja ku'liholi lya lelilya inyama.” ");
INSERT INTO ndg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ghafla kwabile na jeshi likolo lya kumaundebatiungana na malaika hago batikumsifu Nnongo, batibaya, “ ");
INSERT INTO ndg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Utukufu kwa Nnongo ywa abile kunani muno, ni amani ibi mukilambo kwa boti bapendezwa nae.” ");
INSERT INTO ndg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yabile kwamba malaika payomwike boka yenda kumaunde, bachungaji batibakiana bene kwa bene, “tuyende na mbeyambe kolo Bethlehemu, na tukannole cheno kilebe ambacho kitibonekana, ambacho Ngwana atitubakia.” ");
INSERT INTO ndg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Batiyombeteka kolo, na batikunkoliya Mariamu na Yusufu, bamweni mwana atigonja ku'holi la, lelya inyama. ");
INSERT INTO ndg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na bapamweni nyoo, batekuwabakiya bandu celo chabakibweni batibakilwa chakimhusu mwana. ");
INSERT INTO ndg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Boti babayowine habari yeno batishangara na chelo chabalongei na bachungaji. ");
INSERT INTO ndg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lakini Mariamu atiyendelea fikiri husu gooti yayomwike kuyapekaniya, atikuyatunza mwoyoni mwake. ");
INSERT INTO ndg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bachungaji babuyangite batikumtukuza na kumsifu Nnongo kwaajili ya kila kilebe chabakipekani na kukibona, kama tu yaibile inenwa kwabe. ");
INSERT INTO ndg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Payeikite lichiba lya nane na yabile ni muda wa ina mwana, batikumkema lina Yesu, lina lapeilwe na yolo malaika kabla ya kundumbo inatunga kwaa ndumbo. ");
INSERT INTO ndg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mazao yagapalikwa ya utakaso zapitike, lingana na sakiya ya Musa, Yusufu na Mariamu bampotwike kulihekalu kolyo Yerusalemu kum'beka nnonge ya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kati yaiandikilwe katika saliya ya Ngwana, “kila nnalome yayogowa ndumbo ndumbo apala kemelwa ywapiitwe wakfu kwa Ngwana.” ");
INSERT INTO ndg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Balo nyanyanya baichile piya sadaka lengana na chelo chakibailwe katika saliya ya Ngwana, “Jozi ya ngunda ama mabunda mabele ya ngunda.” ");
INSERT INTO ndg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Linga, pabile na mundu katika Yerusalem ambaye lina lyake abile akemelwa Simeoni. mundu ywa abi na haki na mcha Nnongo. Ywembe abile atilenda kwaajili ya mfariji wa Israel, na Roho mpeletau abi kunani yake. ");
INSERT INTO ndg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Yabile iyomwike tunuliwa kwa ywembe ywa Roho mpeletau kwomba ywembe apala waa kaa kabya ya kum'mona Kristob wa Ngwana. ");
INSERT INTO ndg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","lichoba limo aichile nkati ya hekalu, ationgozwa na Roho mpeletau, ambapo azazi batikunleta mwana, Yesu, kumpangia galo yapalikwe kawaida ya saliya. ");
INSERT INTO ndg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ndipo Simeoni atipokiya kwaluboko lwake, na atikumsifu Nnongo nabaya, ");
INSERT INTO ndg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nambeyambe ruhusa mtumishi wako ayende kwa amani Ngwana, lengana na Neno lyako. ");
INSERT INTO ndg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwa kuwa minyo gango yabwe ni wokovu wako, ");
INSERT INTO ndg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ambao utibonekana kwa minyo ya bandu boti. ");
INSERT INTO ndg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ywembe ni nuru kwaajili ya ufunuo kwa bamataifa na utukufu wa bandu baisraeli.” ");
INSERT INTO ndg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tate na mao ba mwana batishangala kwa makowe ambayo atilongela kunani yake. ");
INSERT INTO ndg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ndipo Simeoni atikuwabariki na baya kwa Mariamu mao bake, “pekaniya kwa makini! mwana yo atakuwa sababu ya obiya na okoka kwa bandu benge katika Israel na ni ishara ambayo bandu benge bataikana. ");
INSERT INTO ndg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Pia ni upanga wapala kuchoma nafsi yako na mwene, ili kwamba mawaso ya mioyo ya benge yatangike.” ");
INSERT INTO ndg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nabii nnwawa akemelwa Ana pia abile mulihekalu. ywembe abile nwawa wa Fanueli boka likabila lya Asheri. Abii na miaka yanambone muno. Naye atitama na nchengowe kwa miaka saba baada ya kobekwa. ");
INSERT INTO ndg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Na ndipo abii mjane kwa miaka themanini na ncheche. Naye abile kwaa boka muhekalu na abile atiyendelea kumuabudu Nnongo pamope na taba roba, kilo na mutwekati. ");
INSERT INTO ndg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na kwa muda woo, aichile palo pabile natumbwa shukuru Nnongo, nalongela husu mwana kwa kila mundu ambaye abile akilenda ukombozi wa Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pabayomwile kila kile chawapalike panga lingana na saliya ya Ngwana, batibuya Galilaya, mjini kwabe, Nazareti. ");
INSERT INTO ndg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana atikola, na abii na ngupu, atiyongezeka katika hekima, na neema ya Nnongo yabile kunani yake. ");
INSERT INTO ndg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wazazi bake kila mwaka batiyenda Yerusalem kwaajili ya sikukuu ya Pasaka. ");
INSERT INTO ndg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pabile na umri wa miaka komi na ibele, batiyenda kae muda mwafaka kidesturi kwaajili ya sikukuu. ");
INSERT INTO ndg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baada ya bakia machoba goti kwaajili ya sikukuu, batumbwile buyangana kunyumba. lakini nnalome Yesu atiigala nnchogo mwolo Yerusalem na wazazi bake batangite kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Batangite kwamba abile mu'kipenga cha babile nabo musafari, batibutuka safari ya lichoba limo, ndipo batumbwile kumpala miongoni mwa anunange na marafiki wabe. ");
INSERT INTO ndg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pabashindwile kumpala, batibuya Yerusalem na tumbwa kumpala. ");
INSERT INTO ndg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Itibonekana kwamba baada ya lichoba lya itatu, batikumpata hekaluni, abi atitama katikati ya baalimu, akibapekania na kuwalokiya maswali. ");
INSERT INTO ndg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Boti bayowine batishangala na ufahamu wake na majibu gake. ");
INSERT INTO ndg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pmweni, batishangala, mao bake atikumkumbatia, mwanango, namani cha ututendeite nyaa? Pekani, tate boka na nee tutikupala kwa wasiwasi nkolo.” ");
INSERT INTO ndg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Atikuwabakia,'kitumbwe namani kunipala? mwatangite kwaa kwamba lazima nibii ku'nnyumba ya Tate bangu? ");
INSERT INTO ndg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lakini baelewite kwaa namani chamaanisha kwa maneno galo. ");
INSERT INTO ndg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ndipo ayeii pamope nao mpaka kaya Nazareti na abile mtii kwabe. Mao bake abekite makowe goti moyoni mwake. ");
INSERT INTO ndg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Lakini Yesu atiendelea kola katika hekima na kimo, na azidite pendwa na Nnongo na bandu. ");
INSERT INTO ndg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nambeambe katika mwaka wa komi na tano na utawala wa kaisari Tiberia, wakati Pontio Pilato abile gavana wa uyahudi, Herode abile nkolo wa nkoa wa Galilaya, na Filipo nnuna wake abile nkolo wa nkoa wa Iturea na Trakoniti, na Lisania abile nkolo wa nkoa wa Abilene. ");
INSERT INTO ndg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na wakati wa kuhani nkolo wa Anasi na Kyafa, Neno lya Nnongo lamuichile Yohana mwana wa Zakaria, mulijangwa. ");
INSERT INTO ndg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Atisafiri katika mikoa yoti atizunguka libende Yordani, akihubiri ubatizo wa toba kwaajili ya msamaha wa sambi. ");
INSERT INTO ndg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kati yaiandikilwe katika kitabu cha maneno ga Isaya nabii, “lilobe lya mundu abili kumwitu, 'Mutengeneze tayari ndela ya Ngwana, mugatengeneze mapito gake yangyookile. ");
INSERT INTO ndg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila libende litwelia, kila kitombe nakitombe vipala sawazishwa, ndela yaipindile ipala nyookile, na ndela yabii na mashimo yapala lainishilwe. ");
INSERT INTO ndg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bandu boti bapala kuubona wokovu wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohana atikuwabakiya makutano makolo ya bandu bamwichite bapate kubatizwa na ywembe, “Mwenga ubeleko wa mng'ambo bene sumu, nyai ywaboonile kaibutuka ghadhabu yaicha? ");
INSERT INTO ndg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mubeleke matunda yagaendana na toba, na kana mutumbwe baya nkati yinu, “Tubile nakwe Ibrahimu ambae nga tate bitu; kwa sababu mndakuwabakiya kwamba, Nnongo andawecha kumkakatuliya Ibrahimu bana hata bokana maliwe haga. ");
INSERT INTO ndg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tayari libao labekitwe kwenye ndandai ya mkongo, nga nyoo, kila mkongo waulebeka kwaa matunda mema, wapalakatwa ni kutinya mu'mwoto. ");
INSERT INTO ndg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Boka po bandu katika makutano atikolya akibaya, “nambeambe tupala tupange kitiwi?” ");
INSERT INTO ndg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Atijibu na kuwabakiya, “kati mundu abii na kanzu ibele apalikwa apiye nganzu imo kwa ywenge ambaye ntopo kabisa, na ambaye abi na chakulya na apange nyonyoo.” ");
INSERT INTO ndg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Boka po baadhi ya batoza ushuru baichile pia batizwa, na batikummakia, “mwalimu, tupalikwa panga namani? ");
INSERT INTO ndg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Atikuabakiya, “Kana mkumbe mbange zaidi kuliko chapalikwa kumba.” ");
INSERT INTO ndg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Baadhi ya maaskari batikumlokiya bakibaya, “Na twenga je? tupalikwa tupange namani? Atikuabakiya, “Kna mtole mbanje kwa mundu yoyote kwa ngupu, na kana mumuhukumu mundu yoyoti kwa ubocho. mulidhike na mishahara yinu” ");
INSERT INTO ndg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nambeambe, kwa kuwa bandu babile na shauku ya kumlenda Kristo ywapala icha, kila yumo abile aandawacha mu'mwoyo wake husu Yohana kati ywembe ndiye Kristo. ");
INSERT INTO ndg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana akayangwa na kubabakiya, “Nenga nakuwabatiza mwenga kea mache, lakini kubii ni yumo ywaicha ambaye abi na ngupy kuliko nee, na nistahili kwaa hata taba kamba yee ilatu yake. Apakwa batiza mwenga kwa Roho Mpeletau na kwa mwoto. ");
INSERT INTO ndg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pepeto lyake libi muluboko lwake ili kusafisha kunanoga uwanda wake wake wa pepetya ngano na kuikumba ngano muligolo lyake. Lakini, apala kuyateketeza maakapi kwa mwoto uwecha kwa imika. ");
INSERT INTO ndg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa maono genge ganambone, atihubiri habari njema kwa bandu. ");
INSERT INTO ndg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohana atikunkemeya pia Herode nkolo wa nkoa wa kwa kum'tola Herodia, nnyumbowe na nnuna wake ni kwa malau yenge ganambone ambayo Herode ayapangite. ");
INSERT INTO ndg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lakini baada yake Herode apangite lilau lyenge libaya muno, Amtabike Yohana muligereza. ");
INSERT INTO ndg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Boka po yatipita kwamba, muda bandu bote babile bakibatizwa ni Yohana, na ywembe Yesu atibatizwa pia. muda abile akiloba, maunde yatiyogoka. ");
INSERT INTO ndg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Roho mpeletau atiiuluka mnani yake kwa mfani wa kiwili kati ngunda, muda wowo lilobe latiicha boka kumaunde yatibaya, “Wenga nga mwana wango wanikupendile. Napendezwile muno ni wenga.” ");
INSERT INTO ndg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nambeambe Yesu mwene, atumbwike pundisha, abile ni umri wapata miaka thelathini. Abile ni mwana (kati ya idhanilwe) ywa Tusufu, mwana wa Eli, ");
INSERT INTO ndg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mwana wa Mathali, mwana wa Lawi, mwana wa Melki, mwana wa Yana, mwana wa Yusufu, ");
INSERT INTO ndg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mwana wa Matathua, mwana wa Amosi, mwana wa Nahumu, mwana wa Esli, mwana wa Nagai, ");
INSERT INTO ndg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana wa Maati, mwana wa Matathia, mwana wa Semeini, mwana wa Yyusufu, mwana wa Yuda. ");
INSERT INTO ndg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mwana wa Yoanani, mwana wa Resa, mwana wa Zerubabeli, mwana wa Shealtieli, mwana wa Neri, ");
INSERT INTO ndg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana wa Melki, mwana wa Adi, mwana wa Kosamu, mwana wa Elmadamu, mwana wa Eri, ");
INSERT INTO ndg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana wa Yoshua, mwana wa Eliezeri, mwana wa Yorimu, mwana wa Matathi, mwana wa Lawi, ");
INSERT INTO ndg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwana wa Simeoni, mwana wa Yuda, mwana wa Yusufu, mwana wa Yonamu, mwana wa Eliyakimu, ");
INSERT INTO ndg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwana wa Melea, mwana wa Mena, mwana wa Matatha, mwana wa Daudi, ");
INSERT INTO ndg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana wa Yese, mwana wa Obedi, mwana wa Boazi, mwana wa Salmoni, mwana wa Nashoni, ");
INSERT INTO ndg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwana wa Abinadabu, mwana wa Hesroni, mwana wa Peresi, mwana wa Yuda, ");
INSERT INTO ndg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana wa Yakobo, mwana wa Isaka, mwana wa Ibrahimu, mwana wa Tera, mwana wa Nahori, ");
INSERT INTO ndg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana wa Seruig, mwana wa Ragau, mwana wa Pelegi, mwana wa Eberi, mwana wa Sala, ");
INSERT INTO ndg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwana wa Kenani, mwana wa Arfaksadi, mwana wa Shemu, mwana wa Nuhu, ");
INSERT INTO ndg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana wa Lameki, mwana wa Methusela, mwana wa Henoko, mwana wa Yeredi, mwana wa Mahalalei, mwana wa Kenani, ");
INSERT INTO ndg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana wa Enoshi, mwana wa Sethi, mwana wa Adam, mwana wa Mungu. ");
INSERT INTO ndg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Boka po, Yesu abile atwalilwe Roho Mpeletau, atibuya boka kubende Jordani, ni ationgozwa ni Roho mu'lijangwa ");
INSERT INTO ndg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","kwa machoba arobaini, ni kwoo atijaribiwa ni nchela. Muda woo alile kwaa chochote, ni mwishowe wa muda uno ayiisile njala. ");
INSERT INTO ndg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nchela atikum'bakia, “kama wenga ywa mwana wa Nnongo, liamuru liwe leno lipangite nkate.” ");
INSERT INTO ndg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu kaayangwa, itiandikwa; mundu atama kwaa nkate kichake.” ");
INSERT INTO ndg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Boka po nchela atikumuongoza kunani kwenye kilele sa kitombe, na atikumlaya falme yoti pakilambo kwa muda mfupi. ");
INSERT INTO ndg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nchela atikum'bakiya, “Nipala kukupatia mamlaka ya tawala falme yeno yoti pamope na fahari yake. Niwecha kukupanga nya kwa sababu nyoti nitikabidhiwa kwango niitawale na nindawecha kumpeya yoyoti nimpalae kumpeya. ");
INSERT INTO ndg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kwa nyo, kati unda niaminia na kuniabudu, vitu vino vyooti vipala panga vyako.” ");
INSERT INTO ndg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Lakini Yesu kan'yangwa ni kummakiya, “iandikilwe,” Lazima umwabudu Ngwana Nnongo wako, ni lazima umtumikie ywembe kichake.” ");
INSERT INTO ndg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Baadaye nchela atikumuangoza Yesu hadi ku'Yerusalem ni kum'beka sehem ya kunani kabisa ya jengo lya hekalu ni kum'bakia, “Kati wenga ni mwana wa Nnongo, ujitombwe pae boka pano. ");
INSERT INTO ndg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Kwasababu iandikilwe “Apala lagiya malaika bake bakutunze ni kukulenda, ");
INSERT INTO ndg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na bapala kukukakatuya kunani muluboko lyake ili kwamba kana ulumi magolo gako kunani ya liwe.” ");
INSERT INTO ndg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu atikumjibu akim'bakia, “Itinenwa, “kana umjaribu Ngwana Nnongo wako.” ");
INSERT INTO ndg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nchela payomwile kumjaribu Yesu atiboka ni kumleka hadi muda wenge. ");
INSERT INTO ndg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Boka po Yesu atibuya Galilaya kwa ngupu za Roho, ni habari kumhusu ywembe zitienea ni sambaa katika mikoa yapapipi yoti. ");
INSERT INTO ndg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Atifundisha katika masinagogi yabe, ni kila yumo atikumsifu. ");
INSERT INTO ndg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lichoba limo ayei Nazareti, mji ambao atilekwa na kla. Kati cha ibile desturi yake atijingya ku'lisinagogi lichoba lya sabato, ni atiyema soma liandiko. ");
INSERT INTO ndg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Atikabidhiwa gombo lya nabii Isaya nyoo, atiundwa gombo na pala sehemu yaiandikilwe, ");
INSERT INTO ndg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Roho wa Ngwana ywa mnani yango, keasababu anijeile mauta hubiri habari njema kwa maskini. Atikunituma tangaza uhuru kwa wafungwa ni panga bababona kwaa wecha bona kae kubabeka huru balo baba kandamizwa, ");
INSERT INTO ndg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tangaza mwaka ambao Ngwana apala laga wema wake.” ");
INSERT INTO ndg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Boka po po akalitaba gombo, atikumrudishia kiongozi wa sinagogi, ni tama pae minyo ya bandu boti babile mu'lisinagogi bati kumlinga yembe. ");
INSERT INTO ndg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Atumbwile longela nakwe akibaya, “Leno andiko lino litimile mmasikio yinu. ");
INSERT INTO ndg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kila yumo palo atishuhudia chelo cha kibaite, Yesu, ni benge miongoni mwabe batishangala na maneno ga hekima gagabile bokya katika nkano wake, Babile bakibaya, yono ni kijana tu wa Yusufu, nyonyo kwa?” ");
INSERT INTO ndg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu atikubabakiya, “hakika mpala baya methal ino kwango nee,'”N'ganga jiponye mwene, choti chatuyowine panga Kapernaumu, mukipange pano kae kukaya kwinu.'” ");
INSERT INTO ndg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kae abayite, “hakika nindakuwabakiya mwenga, ndopo nabii angayeketilwa kachake.” ");
INSERT INTO ndg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lakini nindakuwabakiya mwenga kweli kwamba kwabile ni bawelikwe banambone Israel katika kipindi sa Eliya, muda kunani paitabilwe ntopo na ula kwa miaka itatu ni nusu, muda kwabile ni ndele ngolo pa'kilambo choti. ");
INSERT INTO ndg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lakini Eliya atumwile kwa yeyote yumo kwabe, lakini kwa mjane yumo ywa tamile Sarepta papipii ni mjo wa Sidoni. ");
INSERT INTO ndg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pia kwabile ni hakomo banambone Israel katika kipinda sa Elisha nabii, lakini ntopo hata yumowabe yapomwile isipokuwa Naamani mundu wa Siria. ");
INSERT INTO ndg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bandu boti nkati ya sinagogi batwele ni gadhabu payowine haga goti. ");
INSERT INTO ndg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Batiyema ni batikunchukuma panja ya mji, ni kumwongocha mpaka mu'mbwegu ya kitombe sa mji ambapo mji wabe wachengitwe kunani yake, ili waweche kumtomboya pae. ");
INSERT INTO ndg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lakini apitile salama nkati yabe ni yendya zake. ");
INSERT INTO ndg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Boka po atiyelya Kapernaumu, katika mji wa Galilaya. Sabato yimo abile atifundisha bandu nkati ya sinagogi. ");
INSERT INTO ndg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Batishangala ni mapundisho gake, kwasababu atifundisha kwa mamlaka. ");
INSERT INTO ndg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nambeambe lichoba liyo nkati a sinagogi, kwabile ni mundu abile ni roho nchafu wa nchela, ni atilela kwa lilobe la kunani, ");
INSERT INTO ndg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tubi ni namani nakwe, Yesu wa Nazareti? Uichile kutuyomwa? Nitangite wenga wa nyai! Wenga wa mpeetau wa Nnongo!” ");
INSERT INTO ndg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu atikumkemeya nchela buya, “ukotoke liki, ni u'mboke mundu yuno! Nchela yolo atikumtaikwa mundu yolo pae nkati yabe, atikum'boka yolo mundu bila ya kumsababishia maumivu gogoti. ");
INSERT INTO ndg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bandu boti batishangala, ni endelea kulongela kikowe chelo kila yumo nanyine, batibaya, “ni makowe ga aina gani haga?”Atikubaamuru roho bachapu kwa mamlaka ni ngupu ni bapala boka. ");
INSERT INTO ndg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nga nyo, habari kunani ya esu itienea katika makowe gabazunguka mkoa wono. ");
INSERT INTO ndg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Boka po Yesu atiboka katika mji wolo ni atijingia katika nyumba ya Simoni. Nambeambe, mao bake mkwe ni Simoni abile andaminya homa kali, ni batikumsihi kwa niaba yake. ");
INSERT INTO ndg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nga nyo, Yesu atiegelelya, atikemea ile homa ni itikumleka ghafla atiyema ni tumbwa kubatumikiya. ");
INSERT INTO ndg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Liumu laitimbweli yima, bandu katika batimletea Yesu kila yumo ywabile atama ni maradhi ya aina ganambone abekite luboko lwake kunani ya kila mtamwe ni atikubaponya boti. ");
INSERT INTO ndg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ni nchela kae yatikuwapiya banambone wabe bakilela kwa malobe ni baya, “wenga ni mwana wa Nnongo! Yesu atikuwakemeia mashetani ni atikubaruhusu balongele, kwa sababu batitanga kwamba ywembe abile ni kristo. ");
INSERT INTO ndg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Muda pauyomwike, ayei eneo labile ntopo mundu. Makutano ga bandu babile bakimpala na icha katika eneo lya abile. Batijaribu kunkanikiya kana ayende kulipire nakwe. ");
INSERT INTO ndg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lakini atikuwabakiya, “Lazima pia nihubiri habari inanoga ya ufalme wa Nnongo katika miji yenge yanambone, kwa kuwa yeno nga sababu nititumwa pano. ");
INSERT INTO ndg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","“Boka po atiyendelea hubiri nkati ya masinagogi katika uyahudi woti. ");
INSERT INTO ndg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Basi yabonekine muda bandu batikusanyika ni kumzunguka Yesu nipekaniya neno lya Nnongo, ambapo abile atiyema mmbwega ya zia Genesareti. ");
INSERT INTO ndg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Abweni mashua ibele ziyeile nanga mmbwega ya ziwa. Wavuvi babile bakiolwa nyavu yabe. ");
INSERT INTO ndg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu atijingya katika yimo kati ya yelo mashua, ambayo yabile ya Simoni na kumloba aibeke mumache malite pachunu ni payo. Boka po atitama na pundisha bokya ku'mmashua. ");
INSERT INTO ndg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Longela, kum'bakiya Simoni, “ipeleke mashua yako nkati ya kilindi sa mache nauluya lupelel lwako ili kuuwa omba.” ");
INSERT INTO ndg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni kan'yangwa ni kubaya, “Nwana tupangite kachi kilo choti, ni tupatile kwaa kilebe, lakini kwa neno lyako nipala uruya lipelele. ");
INSERT INTO ndg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Palo bapangite nyaa batikusanya kiasi kikolo sa omba ni lupelele lyabe lipala katika. ");
INSERT INTO ndg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nga nyo, batikubaashiria aine mumashua yenge lenga waiche ni kubayangatia. Baichile twelia mashua zoti, kiasi kwamba tumbwa zama mu mumache. ");
INSERT INTO ndg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lakini Simoni Petro, paabweni nyaa, atitomboka mu'magoti ya Yesu ni kubaya, “Boka kwangu kwasababu nenga ni mundu mwenye sambi Ngwana.” ");
INSERT INTO ndg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kwasababiu atishangala, ni goti babile pamope naye, kwa uvuvi wa omab watikupanga. ");
INSERT INTO ndg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lino latikuwajumuisha Yakobo ni Yohana bana ba Zebedayo, ambao babile bashirika ba Simoni. Ni Yesu kam'bakiya Simoni, “Kana uyogope, kewa sababu tumbwa nambeambe na yendeleya utavua bandu” ");
INSERT INTO ndg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Payomwile leta mashua yake payomo, batileka kila kilebe ni kunkengama ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","yabonekine kwamba pabile katika mji umo, mundu abile atwelile ukoma abile kwoo. Muda pamweni Yesu atombwike inamisha inamisha uso wake mpaka pae ni loba, baya, “Ngwana mana undapala, wecha kunitakasa,” ");
INSERT INTO ndg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Boka po Yesu atinyoosha luboko lwake ni kumkumkamwa, baya “mbala takasika” Ni saa yeyelo ukoma utikumleka. ");
INSERT INTO ndg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","“Atikumlagiya kana um'bakiye mundu yoyoti, lakini atikum'bakiya “yenda zako, ni ukajilaye kwa makuhani ni upiye sadaka ya utakaso wako, sawasawa ni chelo Musa chakiamuru, kwa ushuhuda wako.” ");
INSERT INTO ndg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lakini habari husu ywembe yatienea kwa kulipite zaidi, ni umati nkolo wa bandu icha pamope kumpekaniya akipundisa na ponya magonjwa yabe. ");
INSERT INTO ndg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lakini mara kwa mara atikuitenga faraga ni loba. ");
INSERT INTO ndg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yabonikine lichoba limo kati ya machoba haga abile akipundisha, ni babile mafarisayo ni baalimu ba sheria batitama poo amabao baichile boka vijiji vya nambone tofauti katika mikoa ga Galilaya ni Yudea, ni pia boka katika miji ya Yerusalem. Ngupu ya Ngwana yabile pamope ni ywembe kuponya. ");
INSERT INTO ndg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bandu kadhaa baichile, batikumpotwa mundu kwenye likoi ywapooza, na batipala ndela ya jingya nkati ili kum'gonjea pae nnonge ya Yesu. ");
INSERT INTO ndg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bapatike kwaa ndela ya kujingya nkati ya bandu kwasababu ya umati, nga nyo babwike kunani ya paa lya lya nyumba kumhuluya yelo mundu pae pitia vigae, kuna ni kikai iyake mkati ya mundu, mnonge kabisa ya yesu. ");
INSERT INTO ndg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Atilinga imani yabe yesu abaite Rafiki, dhambi zako utisamehe. ");
INSERT INTO ndg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Baandishi na matatisayo batibwilehoji liyo baya, “'gono ni nyai galongela kufuru? ni nyai yawecha samehee dhambi ila mnongo kichake yembe'” ");
INSERT INTO ndg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Lakini yesu, atitambwa namani cha bakifikitia, atikubajibu na kuwabakya, kitumbwe namani mndalokiana hili mioyo mwinu. ");
INSERT INTO ndg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chako ni rahisi baya “Dhambi yako isameilwa ama baga gema nautwange”. ");
INSERT INTO ndg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Lakini matange ya kwamba mwana wa Adam abile nakwe mamlaka mukilambo ya kusamehe dhambi, nindakuwabakia wenga, uyumuke, utole likai lyako na ugende kachake.” ");
INSERT INTO ndg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Muda wowo atiyumuka nnonge yabe ni tola likai lyako labile atigonjeliya. Boaka po buya kachake akimtukuza Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kila yumo atishangala na batikumtukuza Nnongo. Batwelite na hofu bakibaya, “tubweni makowe gasiyo ga kawaida leno.” ");
INSERT INTO ndg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Baada ya makowe haga bonekana, Yesu atiboka kwoo ni amweni mtoza ushuru akemelwa Lawi atumite eneo la kusanya kodi. Atikum'bakiya.”Unikengame.” ");
INSERT INTO ndg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nga nyo Lawi atikakatuka na kumikengama, atileka kila kilebe munnchogo. ");
INSERT INTO ndg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Boka po Lawi atiandaa kachake karamu ngolo kwa ajili ya Yesu. Bababile batoza ushuru benge kolo ni bandu banambone babatamile mezani bakilya pamope naye. ");
INSERT INTO ndg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lakini mafarisayo ni baandishi bao babile banda nung'unika banapunzi, baya, “Kwa nini mlya ni nywaa na batoza ushuru pamope na bandu benge bene zambi?” ");
INSERT INTO ndg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kabayangwa, “bandu bako katika afya njema bapala kwaa tabibu, ili balo tu babaminyanga abo bandakubapala mhitaji muno. ");
INSERT INTO ndg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Niichile kwaaa kubakema bandu bene haki bapalika tabu, bali kubakema bene sambi bapale tubu.” ");
INSERT INTO ndg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Atikuwabakiya banapunzi ba Yohana mara ganambone utaba ni loba ni banapunzi ba mafarisayo nakwe bapanga nya nyoo. Lakini banapunzi bako alya ni nywaa. ");
INSERT INTO ndg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu atikuwabakiya, “indawezekana mundu yoyoti panga hudhuria lichengele lya Ngwana atesi taba muda Ngwana arusi bado yu pamope nakwe? ");
INSERT INTO ndg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lakini lichoba lindaicha muda Ngwana arusi patolekwa kwao, katika lichoba lya bapala taba,” ");
INSERT INTO ndg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Boka po Yesu atilongela kae kwabe kwa mifano, kwa mifano.”ntopo ywa popwana kipande sa ngobo boka kwenye nganju ya nambeambe na tamiya kurekebisha nganju la zamani, kati apanga nyo, apopwana ngobo ya ayambe, ni kipande cha ngobo boka munganju yanambeambe kitaika kwa tumika na ngobo ya nganju ya kunchogo. ");
INSERT INTO ndg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","pia ndopo mundu ambae abeka divai yayambe mu'vibega vikukuu, kati apanga nyo, divai yayambe ingepapwana chelo kiombo ni divai penganika, ni kibeka na alibika. ");
INSERT INTO ndg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lakini divai yayambe lazima bekwa mu'kibega chayambe. ");
INSERT INTO ndg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ni ntopo mundu ywa baada nywaa divai ya nnchogo, apala yayaambe kwasababu abaya, “Ya nnchogo ni bora.” ");
INSERT INTO ndg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu abile atipeta mu, migunda ya nafaka ni banapunzi bake babile bakitombwanga masuke, bakabasungwanga kati ya luboko lwake bandaliya nafaka. ");
INSERT INTO ndg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lakini baadhi ya mafarisayo batibaya, “namani upanga kikowe ambacho halali kwaa kisheria kukipanga lichoba lya sabato”? ");
INSERT INTO ndg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu atikubajibu, akibaya, “muwaite kwaa soma chelo Daudi chakipangite pabile ni njala, ywembe ni banarome bababile pamope nakwe. ");
INSERT INTO ndg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Atiyenda mu'nyumba ya Nnongo, ni atolite libumunda litakatifu na liya baadhi, ni kuiboya baadhi kwa bandu bababile nakwe lyaa, hatakama ibile halali kwa makuhani lyaa.” ");
INSERT INTO ndg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Boka po atikuwabakiya, “mwana wa Adamu ni Ngwana wa sabato.” ");
INSERT INTO ndg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Yabonekine mu'sabato yenge kwamba atiyenda nkati ya sinagogi ni kubapundisha bandu kwa pabile ni mundu ambaye luboko lwake lwa mmaliyo watipooza. ");
INSERT INTO ndg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Baandishi ni mafarisayo babile banda kunlinga kwa makini bona kati anyeponya mundu lichoba lya sabato, ili wecha pata sababu ya kumshitaki kwa panga likosa. ");
INSERT INTO ndg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lakini atangite namna cha fikiria na baya kwa mundu ywabile atipooza luboko uyumuka uyema pana kati ya kila yumo.” Nga nyo yolo mundu atikakatuka ni yema palo. ");
INSERT INTO ndg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu atibaya kwabe, “ninda kuwalokiya mwenga ni halali lichoba lya sabato panga mema au panga madharau, kuokoa maisha amakuyaaribu, Boka po atikubalinga boti ni kum'bakiya yolo mundu. ");
INSERT INTO ndg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","“Nyoosha luboko lwako,” Apangite nyaa, ni luboko lwake labile litinyooka. ");
INSERT INTO ndg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lakini batwelile ni hasira, batilongela bene kwa bene husu namani chapaswa apange kwa Yesu. ");
INSERT INTO ndg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yatibonekana machoba ago kwamba atiyenda pakitombe loba, Aatiyendeleya kilo yoti loba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Paibile bwamba, atikubakema benepunzi bake kwake, ni atikuwachawa komi ni ibele kati yabe, ambao pia atikubakema, “Mitume” ");
INSERT INTO ndg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Majina ya balo mitume yabile Simoni, (ywa pia atikumkema Petro) ni Andrea nnuna wake, Yakobo, Yohana, Filipo, Bartolomayo, ");
INSERT INTO ndg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathayo, Tomaso ni Yakobo mwana wa Alfayo, Simoni ywa akemwa Zelote, ");
INSERT INTO ndg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana wa Yakobo ni Yuda Iskariote, ywa abile msaliti. ");
INSERT INTO ndg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Boka po Yesu atitelemka pamope nakwe boka mukitombe ni yema mahali palibende. Benepunzi bakr banyansima babile kwo pamope ni bandu benge banyansima boka Uyahudi ni Yerusalem ni boka mbwani ya Tiro na Sidoni. Baichile kumpekanya ni ponywa magonjwa yabe. ");
INSERT INTO ndg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bandu babile bandasumbuliwa ni nchela bachapu batiponywa pia. ");
INSERT INTO ndg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kila yumo kwenye lyoo kusanyiko atijaribu kumkamwa kwa sababu ngupu ya uponyaji yabile bonekana nkati yake, ni atikubaponya boti. ");
INSERT INTO ndg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Boka po atikubalinga benepunzi bake, ni baya, “mtibarikiwa mwenga mwa m'bile maskini, kwa maana ufalme wa Nnongo ni winu. ");
INSERT INTO ndg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mtibarikiwa mwenga mwabile ni njala nambeambe, kwa maana mpala yukuta. Mtibarikiwa mwenga mwamlela nambeambe kwa maana mpala eka. ");
INSERT INTO ndg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mtibarikiwa mwenga ambao bandu bapala kubachukianga ni kubatenga ni kubashutumu mwenga kwamba mwa'ovu, kwa ajili ya mwana wa Adamu. ");
INSERT INTO ndg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pulaini katika lichoba lyoo ni goloka goloka kwa pulaha, kwa sababu hakika mpala pata thawabu ngolo kumaunde, kwa maana tate bao batikubatenda nyonyonyoo mananbii. ");
INSERT INTO ndg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lakini ole winu mwabile matajili kwa maana myomwile pata faraja yinu. ");
INSERT INTO ndg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ole winu mwabile yukwita nambeambe! kwa mana mpala bona njala baalaye, Ole winu mwamueka nambeambe mpala lomboleza ni lela baalae. ");
INSERT INTO ndg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ole winu mwapala lumbwa ni bandu boti! kwa mana tate bao atikubatenda manabii wa ubocho nyonyonyo. ");
INSERT INTO ndg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Lakini nibaya kwinu mwenga mwamunipekaniya, mwapende adui zenu ni kupanga mema kwa babawachukiya. ");
INSERT INTO ndg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mubabariki balo babalaani mwenga ni mubalobii balo babaoneya. ");
INSERT INTO ndg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kwa ywembe ywa akukombwa shavu limo, mgalauliye ni lya ibelr. Kati mundu akupokonyile jyoho lyako kanamchibi na nganzu. ");
INSERT INTO ndg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mbei kila ywa akuloba. Kati mundu akupokonyile kilebe ni mali yako, kana umrobe akubuyanganiye. ");
INSERT INTO ndg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kati ubapendavyo bandu babatendii, ni mwenga mubatendi nyonyonyo. ");
INSERT INTO ndg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kati mkiwapenda bandu baba mpendanga mwenga tu, eyo ni thawabu ya namani kwinu” kwa maana hata bene dhambi huwapenda balo babapendile. ");
INSERT INTO ndg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kati mwatendi mema balo bawatendi wema ni mwenga, eyo nga thawabu gani kwinu? kwa mana hata ywabile ni sambi apanga nyoo. ");
INSERT INTO ndg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kati mwatikunkopesha ilebe kwa bandu mwabile mutegemie kwamba balowa kubabuyanganikiya, eyo nga thawabu gani kwinu? Mana hata balo babile ni sambi balowa kopesha benge sambi benge, ni tegemya pokya kiasi chechelo kae. ");
INSERT INTO ndg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lakini mwapende adui zenu ni mwatendei mema. Mubakopeshe ni mhofie kwaa kuhusu kubuyanganikiwa, ni thawabu yinu ipalika kuba ngolo. Mpalikwa kuba bana ba Ywabile kunani, kwa mana ywembe mwene nga mwema kwa bandu babile kwaa ni shukrani ni baovu. ");
INSERT INTO ndg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mube ni huruma, kati Tate binu ywabile ni huruma. ");
INSERT INTO ndg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kana mhukumu, mwenga muhukumilwa kwaa. Kana mulaani, ni mwenga mulaanilwa kwaa. Musamei benge, ni mwenga mwalowa sameelwa. ");
INSERT INTO ndg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mwapei benge, mwenga mwalowa peilwa. Kiasi sa ukarimu-chakisindililwe, sukwasukwa ni mwagilwa-mwagilwa mumagoti yinu. Kwamana kwa kipimo chochote mwakitumile pemya, kipimo chechelo chapanga tumilwa kubapemya ni mwenga. ");
INSERT INTO ndg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Boka po kabamakiya kwa mpwano kae, “Je mundu ywange bona aweza kumwongoza kipofu ywenge? Kati atipanga nyoo, bai boti balowa tombokya mulimbwa, je kana batumbukii? ");
INSERT INTO ndg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwanapunzi aweza kwaa kuba nkolo kuliko mwalimu wake, lakini kila mundu kaayomwa pundishwa kwa ukamilifu alowa kati mwalimu bake. ");
INSERT INTO ndg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mwanja namani bai mwakilola kibanzi nkati ya liyo lya nongo wo, ni wabile ni boriti nkati ya liyo lyako uilola kwaa? ");
INSERT INTO ndg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Waweza kwaa kummakiya nongowo, Nongo wango kiboywe ibanzi mu'liyo lyako, “wenga ulola kwaa boriti yaibile muliyo lyako wa mwene, Nga ubona inanoga kumoywa kibanzi mu'liyo lya nongo bako. ");
INSERT INTO ndg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kwamana ntopo nkongo unoyite upambike matunda ganoite kwaa, wala ntopo nkongo unoyite kwaa upambika matunda ganoite. ");
INSERT INTO ndg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kwa mana kila nkongo bandu uyowanika kwa matunda gake. Kwamana bandu bachuma kwaa tini boka mu'miba, wala kana bachuma zabibu boka mu'michongoma. ");
INSERT INTO ndg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mundu mwema mu'hazina njema ya mwoyo wake kumoywa galyo mema, ni mundu mwou mu'hazina mbou ya mwoyo wake umoywa galyo maou. Kwamana ntwe wake ubaya galo gaujazike mwoyo wake. ");
INSERT INTO ndg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kwa namani mwanikema,'Ngwana, Ngwana, na balo muyatendi kwaa galo ganiabakiya? ");
INSERT INTO ndg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","KIla mundu ywanikengama nenga ni kugayowa makoweni kugatendii kazi, nalowa kwaonesha ywabile. ");
INSERT INTO ndg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Atilandana ni mundu ywachenga nyumba yake, ywa chimba pae muno, ni kuchenga msingi ba nyumba nnani ya mwamba imara. Mafuriko gaisile, maporomoko ga mase, gaikombwile nyumba, lakini yaweza kwaa kwitikisa, kwa mana yabile ichengwite vizuri. ");
INSERT INTO ndg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lakini ywoywoti ywaliyowa neno lyango no kulitii kwaa, mpwano wake ywa mundu ywachengite nyumba nnani ya mbwega pabile kwaa ni msingi, mto wauilukie kwa ngupu, nyumba yelo yapatike maangamizi makolo. ");
INSERT INTO ndg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Baada ya Yesu yomwa kila kilebe chabile kakibaya kwa bandu babampekaniyage, ajingii Karpenaumu. ");
INSERT INTO ndg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mmanda pulani ywa akida, ywabile ywa thamani muno kake, abile ntamwe muno ni abile karibu na waa. ");
INSERT INTO ndg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lakini ayowine usu Yesu, yolo akida antumite kiongozi wa kiyahudi, kunnoba aiche kunkombwa mmanda wake linga kanaawe. ");
INSERT INTO ndg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pabaikite papipi ni Yesu, batikunnoba kweli ni baya, “andastahili upalikwa panga nya kwaajili yake, ");
INSERT INTO ndg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kwasababu andakulipenda taifa litu, ni ywanjengite sinagogi kwaajili yitu.” ");
INSERT INTO ndg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu ayendeli ni safari yake pamope nakwe, lakini kabla anaika kwaa kuutalu ni nnyumba, afisa yumo aatumite mambwiga bake longela nakwe, “Ngwana, kana uuchoshe wa mwene kwasababu ya nenga nistahili kwa wenga jingya mu dari yangu. ");
INSERT INTO ndg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kwasababu yino nifikilie kwa hata nenga namwene panga nenda pwaika icha kwako, lakini ubaye lineno tu ni mmanda wango apapona. ");
INSERT INTO ndg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwani nenga na mundu wanibile pa mamlaka na nibii ni askari pae yango, abaya kwa yuu 'Yenda” ni andayenda, ni kwa ywenge 'Icha” ni andaicha ni mtumishi wango “upange nyaa” ni ywembe andapanga. ");
INSERT INTO ndg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu payowine haga atichangala ni kubagalambukiya makutano bababile kabankengama ni baya, “Nindawabakiya hata mu'Isreali, nabona kwa mundu mwene imani kolo kati yolo. ");
INSERT INTO ndg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Boka po balo babatumilwe babuyangine kaya ni kunkolya mtumishi abile nkoto. ");
INSERT INTO ndg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pulani baada ya haga, yapitike kuwa Yesu ende safiri yenda kilambo che nge chakemelwa Naini. Benepunzi bake bayeyi pamope nakwe bakengimine na bandu banyansima. ");
INSERT INTO ndg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Paikite papipii ni nnyango wa kilambo linga, mundu ywa wile abile apotwilwe ni nga mwana yumo kwa mao ywake. ywabile mnomelanga, ni umati wa akilishi buka pa kilambo bai pamope ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pamweni Ngwana atikumwegeleya kwa rwangu muno husu ywembe ni kummakia “kana ulile” ");
INSERT INTO ndg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nga egelya nnonge ni kukungwa lijeneza bababutulile maiti ni balo babaputwike batiyimaaa ngaabaya “wenga wa kijana uyumuke.” ");
INSERT INTO ndg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ywa awile ngakakatuka ni tama kitako ni tumbwa longela. Boka po Yesu kampea ywa mwana kwa mao bake. ");
INSERT INTO ndg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Boka po hofu ibajingile boti, bayendeli kumtukuza Nnongo bende baya “Nabii nkolo alikakatulwa nkati yitu” ni “Nnongo alingite bandu bake.” ");
INSERT INTO ndg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hayii habari inanoga ya Yesu yatienea Yudea yoti ni kwa mikoa yoti ya jirani. ");
INSERT INTO ndg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Benepunzi ba Yohana bammakiye mambo goti haga. ");
INSERT INTO ndg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ndipo Yohana ngaa ankema abeli nkati ya Benepunzi bake ni kubatuma kwa Ngwana baya “wenga yulo ywa icha, au kuna mundu ywenge tumnende? ");
INSERT INTO ndg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bapaikite karibu ni Yesu aba payite Yohana mbatizaji atitumite kwako baya, “wenga nga yolo au kui na mundu ywenge tumnende? ");
INSERT INTO ndg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kwa wakati woo aaponyike bandu banyansima buka nkati ya matamwe ni mateso, buka kwa nchela, ni kwa bandu ipofu apeile bona. ");
INSERT INTO ndg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu ayangwine baya kwabe, “Baada ya n'yei kwa mwokite mkammakiye Yohana chamkibweni ni kukiyoa. Babile ipofu bapokya bona ni iwete banda tyanga, bene ukoma banda pona, iziwi banda yoa, babawile banda yuka ni panga akolo kai, bangali ni kilebe aabakiya habari inanoga. ");
INSERT INTO ndg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ni mundu ywaleka kwaa kuniamini nenga kwa sababu ya matendo gango abalikilwe.” ");
INSERT INTO ndg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Baada ya balo babatumilwe ni Yohana buyangana kwaba bukite Yesu nga tumbwe longela na bandu husu Yohana, “Mwayei panja bona namani, nnai wautikatika ni mchunga? ");
INSERT INTO ndg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Lakini mwayei panja bona namani, mundu ywa weti vizuri? linga bandu balo babawala ngubo ya kifalme ni ishi maisha ga staree babile bene nafasi ya kifalme. ");
INSERT INTO ndg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lakini nn'yenda panja bona namani, Nabii? Elo, nenda baya kwinu na muno kuliko nabii. ");
INSERT INTO ndg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Uyu ngaba ywaandikilwe, linga nenda kutuma mjumbe wango nnongi ya minyo yinu, ywapala andaa ndila kwaajili yango, ");
INSERT INTO ndg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mbayaa kwinu, kati ya balo bababelekwile ni nnwawa, ntopo nkolo kati Yohana, lakini mundu ywangali muhimu muno nga ywaa lama ni Nnongo mahali pabile ywembe, apanga nkolo kuliko Yohana.” ");
INSERT INTO ndg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ni bandu boti pabayowine haga pamope ni babatosage ushuru, batitangaza Nnongo nga mwene haki. Babile kati yabe babatizilwe kwa ubatizo wa Yohana. ");
INSERT INTO ndg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lakini mafarisayo ni bataalamu ba saliya ya kiyahudi amabbo babatizilwe ni ywembe batikana hekima ya Nnongo kwaajili yabe bene. ");
INSERT INTO ndg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kai mbaweza linganisha mwenga ni namani bandu ba kizazi cheno? Bai kitiwi? ");
INSERT INTO ndg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Balingana ni bana babang'anda pasoko, babatama ni kemana yumo baada ya ywenge kababaya,'tuliyula filimbi kwaajili yinu, ni mng'andike kwaa, twatilombola mlelite kwaa.” ");
INSERT INTO ndg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana mbatizaji aichile alile kwaa nkate wala anywile kwa lilogwa, ni mmayite, “Aina mashetani. ");
INSERT INTO ndg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana wa mundu aichile alile ni ywa ni mmayite linga aina choyo ni nnevi, limbwiga ni babatosa ushuru ni bene sambi. ");
INSERT INTO ndg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lakini hekima bakwipwile kuwa ibile ni haki kwa bana bake boti.” ");
INSERT INTO ndg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yumo ywa balo, afarisayo anobite ayende akalye nakwe. Baada ya Yesu jingya munyumba ya mafarisayo, alindikii meza linga alye. ");
INSERT INTO ndg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Linga abi na nnwawa katika kilambo chilo abi ni sambi. Akwipwile kuwa atamii kwa farisayo, alelike chupa ya mauta gananungya. ");
INSERT INTO ndg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ayemi nchungu yake karibu ni maghulu gake kuno kalela. Kae atumbwi tepengaya maghulu kwa nywili ya mutwe wakeni kuipakalaya mauta gananungya. ");
INSERT INTO ndg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ni yulo farisayo ywa nkokiti Yesu pamweni nyoo, awechike mwene abayite, mana mundu yuu apanga nabii, apendaga hayu nyai ni nnwawa wa namna gani ywa mkunywa, ya panga mwene sambi. ");
INSERT INTO ndg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu atin'yangwa ni kum'makiya, “Simoni nibiina kikowe cha kukubakiya.” Abayite, “kibaye bai mwalimu” ");
INSERT INTO ndg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu abayite, “pabii ni alongelwa abile ba kopite kwa mundu yumo. Yumo abi kadaiwa dinari mia tano ni wene ibele adaiwa dinari hamsini. ");
INSERT INTO ndg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ni pabile ntopo ela ya kunnepa atikuwasameya boti. Tubwe ywakuywa mpenda muno? ");
INSERT INTO ndg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni ati kunn'yangwa “mbona ywa nyansima. Yesu amakiya uukumu sawasawa.” ");
INSERT INTO ndg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu nga ngalabukya mnwawa ni baya kwa Simoni, “Wandamwona uyu nnwawa. Nijingii munyumba yako. Umbei kwaa machi kwa ajili ya magulu gangu, lakini huyu, kwa morii gake ateoengiye magulu gangu ni kugafula kwa nywili yake. ");
INSERT INTO ndg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Huninonii kwaa, lakini ywembe, tangu panjiyite muno alekite kwaa kuninoniya magulu gangu. ");
INSERT INTO ndg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Huipakiye kwaa magulu gangu mauta, lakini aipakiye magulu gangu mauta gananungya. ");
INSERT INTO ndg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwa jambo lee, nenda kubakia kwamba abe ni sambi zanyansima ni ninsamilie muno, ni kai atipenda muno, lakini ywasamehelwa pachini apendike pachini tu.” ");
INSERT INTO ndg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Baadaye aamakiye nnwawa, “sambi yako ichamiilwe.” ");
INSERT INTO ndg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Balo babatami pameza pamope nakwe ngabatumbwa longela bene kwa bene, “Aywa nyai mpaka ansamii sambi?” ");
INSERT INTO ndg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ni Yesu amakiye nnwawa imani yako ikukombwile, Uyende kwa amani.” ");
INSERT INTO ndg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yapilike mundu mwipi kwemba Yesu tumbwe miyanya katika ilambo ni lilyambo mbalimbali, kahubiri ni tangaza habari inanoga ya Nnongo ni balo komi ni abele bayihi pamope nakwe, ");
INSERT INTO ndg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nyonyo alwawa fulani babaponike boka kwa nchela ni matamwe maingi, abile Mariamu ywakemelwa Magdalena ambaye ywaminyike nchela saba. ");
INSERT INTO ndg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana nyumbowe kuza meneja wa Herode, Susana, ni alwawa banyansima, babapiyite mali yabe kwaajili yabe bene. ");
INSERT INTO ndg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ni baada ya bandu banyansima kwembana pamope babile bandu boka ilambo yenge, atilongela nabo kwa tumiya mifano. ");
INSERT INTO ndg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mpandii ayei panda mbeyu, papandage baadhi ya mbeyu yatombokii mbwega ya ndila batikuilebata pae ya magolo ni iyuni batikuichonwa. ");
INSERT INTO ndg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mbeyu yenge yatumbwike pa ukando wabile maliwe ni paibalike miche yatiyama sababu pabile kwaa ni machi. ");
INSERT INTO ndg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mbeyu yewnge yatumbwike pene mikongo yabile mimimwa, nayo mikongo yatiyuma pamope ni yilo mbeyu ni yatikuibana. ");
INSERT INTO ndg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Lakini mbeyu yenge yatumbwike pa ukando waupwaika ni yatipambika yakulya mara mia zaidi. Baada ya Yesu kubaya makowe haga, atibaya, “Ywabile ni makutu ni ayowine” ");
INSERT INTO ndg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kaia benepunzi bake batikunnokiya maana ya mpwano uno, ");
INSERT INTO ndg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu atikuwabakiya, “mpeilwe upendeleo wa kwipwa siri ya ufalme wa Nnongo, lakini bandu benge papundishwa bai kwa mifano, linga kwamba, “mana babweni kana babone, ni mana bayowine kana baelewe.” ");
INSERT INTO ndg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na yii nga maana ya mpwano wono, mbeyu nga neno lya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeyu ya itumbwike mumbwega ya ndila nga balo bandu babali yowa lineno, ni baadaye nnau nchela ulitola kulipu boka mumwoyo, linga kana kwaa amini no kombolelwa. ");
INSERT INTO ndg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ni yilo yatumbwike pa maliwe nga bandu balo babaliyowa neno ni kulipokya kwa pulaha lakini ndandai yeyete, baaminiya muda mwipi, ni wakati taabu banda tumbuka. ");
INSERT INTO ndg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ni mbeyu yilo yaitumbwike pa mimimwa nga bandu babayuwa lineno, lakini wanapoendelea kukua yandakuibana maisha ni utajiri ni uzuri wa maisha ga ni bapapa kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Likini yelo itumbwike pa mbwega unanoga nga ywaa baada ya yowa neno bandu balo anyenyekevu ni mwoyo inanoga, baada ya kuliyowa neno ulikamuliya ni libaa salama ni papa matunda ya uvumilivu. ");
INSERT INTO ndg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sasa ntopo hata yumo ywa washa taa ni kuipunika kwa bakuli au kuibeka pae ya kindanda, badala ya kuibeka panani linga kila mundu ywa jingiya apate kuibona. ");
INSERT INTO ndg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kwa kuwa ntopo chakipala iyilwa, au chochote chakibile siri ambacho chakipala tanganikwa kwaa chakibaa pa mbweya. ");
INSERT INTO ndg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kwa nyo ube makini pau pikaniya, kwa sababu ywa bile nacho, bapa kunn'yongeyekea zaidi, lakini yolo ywa ngali nacho hata chelo kichini cha abile nacho kapatola.” ");
INSERT INTO ndg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Baadaye mao bake Yesu ni anunabe batiicha kwake bamkaribie kwaa kwasababu ya bandu banyansima, ");
INSERT INTO ndg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ni boti batikummakiya, “Mabako ni anunabo bai palo bapala kukubona wenga. ");
INSERT INTO ndg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lakini, Yesu kaayangwa ni kubaya, “Mao bangu ni anuna bangu ni balo babalipikaniya neno lya Nnongo ni kulitii. ");
INSERT INTO ndg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yapitike lichoba limo kati ya machoba galo Yesu ni benepunzi bake baubwike mu'ngalaba, ni kuabakiya, “tuloke mpaka kwiya.”baandaite ngalaba yabe. ");
INSERT INTO ndg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lakini pabatumbwi boka, Yesu agonjike lugono, ni dhoruba ngolo yabile ni mbepo, ni ngalaba yabe itumbwe twilya machi ni bai katika hatari ngolo muno. ");
INSERT INTO ndg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Baadaye baichi benepunzi bake kun'yumuya, kababaya, “Ngwana nkolo! Ngwaba nkolo! tui karibu ni waa! Ngayumuka ni kubendya nchunga ni mawimbi ga machi nga tulia ni panga ni utulivu. ");
INSERT INTO ndg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nga abakiya, “imani yinu ii kwako?” Batiyogopa, Batichangala, balongei kila mundu na nyine, “Ywa nyai, kiasi kwamba amrisha mbepo ni machi tuliya?” ");
INSERT INTO ndg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Baikite pa kilambo cha Garasini yaibile upande wa nchogo wa Galilaya. ");
INSERT INTO ndg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu paulwite ni libata pae, mundu pulani boka mukilambo, akwembine nakwe, kwa muda mwingi abii awalae kwaa ngobo, ni atamae kwaa munnyumba, lakini atamae mumakaburi. ");
INSERT INTO ndg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pamweni Yesu alei kwa lilobe, ni tumbuka pae nnonge yake kwa lilobe likolo andebaya, nipangite kilebe gani kwako, Yesu mwana wa Nnongo ywabile kunani? Nenda kuloba kana upwati nenga. ");
INSERT INTO ndg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu ngaa amrisha munneke mundu yulwa nchela kwa mara yanambone ganda uboka hata mana bamtabike nyororo ni kumana bandu kunendela anda kutwana ni yenda ni nchela mpaka mulijangwa. ");
INSERT INTO ndg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu annokiye, “lina lyako nyai?”ayangwi baya, “Legion” Kwamaana tubi ni nchela banambone gajingii kwake. ");
INSERT INTO ndg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Baayendelii kunnoba kana utubakiye tuyende mulimbwa. ");
INSERT INTO ndg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Likundi lya ngobe labile kalilya pa kitumbi, banobiye aruhusu bakajingii kwa balo ngobe. Ni atibaruhusu panga nyoo. ");
INSERT INTO ndg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kwa nyoo balo nchela babutukeye kwi yolo mundu ni jingya kwa balo ngobe ni lilo likundi latibutuka pano pakitumbi mpaka kulibwawa ni tumbukya moo. ");
INSERT INTO ndg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Balo bandu bababile kabaleleya balo ngobe pakabweni chakipitile, bati butuka pia taarifa palo pakilambo ni sehemu yenge yaii tindiya palo. ");
INSERT INTO ndg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bandu pabayowine hago batiyenda bona chakipiite, ni baichi kwa Yesu bamweni mundu ambaye nchela gatikumuka, abile aweli vizuri ni mwene akili timamu, atami pa magulu ga Yesu, ni batiyogopa. ");
INSERT INTO ndg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nga mundu yumo ywa gabweni atumbwi kuachimuliya benge jinsi hayo mundu wabile kaganongoya nchela mwaponike. ");
INSERT INTO ndg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bandu boti ba nkoa wa Ageres ni maeneo gake gagalindia banobite Yesu aboke kwasababu babii ni uwaoga nkolo muno. Ni ajingile mungalaba ku uruka. ");
INSERT INTO ndg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mundu yolo ywabokwile ni nchela atikunsihi Yesu yenda nakwe, lakini Yesu atikumbakiya ayende no baya, ");
INSERT INTO ndg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ubuye mu nyumba yako ni ubalange galo goti ambayo Nnongo apangite kwa wenga. Ayo mundu kaboka, kuitangaza poti mu ijiji ni goti ambago Yesu kapanga kwanembe. ");
INSERT INTO ndg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ni Yesu kabuya, kipenga sa bandu satikunkaribisha, kwa mana boti babile batikusubiri. ");
INSERT INTO ndg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Linga kaisa mundu yumo ywakemelwa Yairo nga yumo nkati ya atawala mu'sinagogi. Yairo katomboka pa'magolo ga Yesu ni kumnoba muno ayende munyumba yake, ");
INSERT INTO ndg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwa mana abile ni mwana nnwawa yumo bai, ywabile ni miaka komi ni ibele, ni abile nkati ya hali yo waa. Paabile kayenda, kipenga sa bandu satikunkengama ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nnwawa yumo ywatokwa ni mwai kwa myaka komi ni ibele abile palo ni atumile mbanje yoti kwa aganga, lakini ntopo ywamponyile hata yumo, ");
INSERT INTO ndg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","kaisa kunchogo ya Yesu ni kukamwa lipindo lya ngobo yake, ni ghafla mwai yaachile kum'moka. ");
INSERT INTO ndg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu kabaya, “Nyai ywanikamwile?” Pabakanikiye bote, Petro kabaya, Ngwana nkolo, kipenga sa bandu kabansukuma ni kunzonga.” ");
INSERT INTO ndg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lakini Yesu kabaya, “Mundu yumo anikamwile, mana naiyowa ngupu yatiboka kwango.” ");
INSERT INTO ndg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ywa nnwawa paabweni yabile aweza kwaa kificha chaapangite, katumbwa lendema, katomboka pae nnongi ya Yesu katangaza nnongi ya bandu bote sababu yai panga ankamwe ni aponywile saa yeyelo. ");
INSERT INTO ndg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Boka po kabaya kwanembe, “Nwawa, imani yako ikupangite ube nzima. Yenda kwa Amani.” ");
INSERT INTO ndg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Paabile yendelya kubaya, mundu yumo kaisa boka munyumba ya ntawala ywa li'sinagogi, kabaya, “Nwawa wako atiwaa. Kana usumbuke mwalimu.” ");
INSERT INTO ndg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lakini Yesu pabaayowine nyoo, kannyangwa, “Kana uyogope. Amini kae, ni alowa lopolwa.” ");
INSERT INTO ndg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kayingya mu ayo nyumba, aruhusu kwaa mundu yeyote kujingii pamope niywembe, ila Petro, Yohana ni Yakobo, tate ba nwawa, ni mao bake. ");
INSERT INTO ndg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Muda bandu bote babile bakiomboleza ni kumoywa lilobe kwaajili yake, lakini kabaya, “Kna mumpangii ndoti, awile kwaa, lakini agonjike kae. ");
INSERT INTO ndg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Lakini batikunheka kwa kundharau, batiyowa kuba awile. ");
INSERT INTO ndg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lakini ywembe, kankamwa luboko yolo nnwawa, ni kunkema kwa lilobe, kabaya, Mwana, uluka” ");
INSERT INTO ndg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","roho yake yankerebukye, ni kauluka saa yeyelo. Atikwaamuru kuwa, apeilwe kilebe pulani ili alye. ");
INSERT INTO ndg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Azazi bake batishangala, lakini atikwaamuru kana bammakii mundu chabile chapangilwe. ");
INSERT INTO ndg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Atibakema balo komi ni ibele pamopeiatikuwapea uwezo ni mamlaka kunani ya nchela goti ni kubaponya atamwe. ");
INSERT INTO ndg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Atikubatuma bayende kuhubiri ufalme wa Nnongo ni kubaponya atamwe. ");
INSERT INTO ndg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Atikuwabakiya “kana mtole chochote kwa ajili ya safariyinu wala fimbo, wala mkoba, walankate, wala mbanje, wala kana mtole nganju ibele. ");
INSERT INTO ndg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mukaya yoyoti mwa mujingia, mutame poo mpaka mwampala bokanga mahala poo. ");
INSERT INTO ndg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kwa balo babapokeite kwaa, pampala boka mji woo, mukungutange vumbi mumagolo yinu kwa ushuhuda kunani yabe.” ");
INSERT INTO ndg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Batiboka yenda peta muijiji, bakitangaza habari inanoga ni kuponya bandu kila mahali. ");
INSERT INTO ndg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herode mtawala atiyowa goti yagabonekine atitaabika muno, kwa sababu yayowanike ni baadhi kwamba Yohana mbatizaji atifufuka bok mu'kiwo, ");
INSERT INTO ndg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ni baadhi kwamba Eliya apitike ni kwabenge kwamba yumo kati ya manabii wa kunchogo atiuluka boka mu'kiwo kae. ");
INSERT INTO ndg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herode atibaya, “atikunchinja Yohana, lakini yono nyai kwabe yaniyowa habari gake? Ni Herrode atipala ndila ya kum'bona Yesu. ");
INSERT INTO ndg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wakati papabuyangine balo babalagilwe, batikum'bakiya kila kilebe cha bakipangite. Atikubatola pamope ni ywembe, Atiyenda kichake katika mji waukemelwa Bethsadia. ");
INSERT INTO ndg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lakini bandu banyansima batiyowa kuhusu lino batikumkengama, ni kuwakaribisha ni atilongela nabo kuhusu ufalme wa Nnongo, ni atikubaponya balo babapala. ");
INSERT INTO ndg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lichoba palitumbwile yomoka, balo komi ni ibele batiyenda kwake ni baya, “Batawanye bandu banyansima bayende katika ijiji ya papii ni mjini bakapalange papalya ni chakulya, kwa sababu tubile eneo lya mmwitu.” ");
INSERT INTO ndg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lakini atikuwabakiya, “mwanga mubapei kile chalya.” Batibaya, “ntopo zaidi ya ipande itano ya nkate ni omba abele, papola tukapeme chakulya kwa ajili ya bandu aba banyansima.” ");
INSERT INTO ndg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pabile ni analome elfu tano palo. Atikuwabakiya anapunzi bake, “batamange pae katika makundi ya bandu hamsini kwa kila kundi. ");
INSERT INTO ndg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kwa nyoo batipanga nyo ni bandu batitama pae. ");
INSERT INTO ndg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Atitola mikate itano ni omba abele ni linga kumaunde, atikuibariki, ni kuimetwa katika ipande ipande, atikuwapa banapunzi bake linga waibeke nnonge ya bandu. ");
INSERT INTO ndg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Boti batilya ni yukuta, ni ipande ya chakulya vyaigile vyatilokotwa ni tweliya ikapu komi ni ibele. ");
INSERT INTO ndg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nayo ibile kwamba, palobile kichake, benepunzi bake babile pamope ni ywembe, ni atikuwalokya baya, “bandu ubaya nenga ni nyai?” ");
INSERT INTO ndg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bayangwa, ni baya, “Yohana mbatizaji, lakini benge ubaya Eliya, ni benge ubaya yumo wa manabii wa nyakati za kunchogo atiuluka kae boka mu'kiwo.” ");
INSERT INTO ndg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Atikuwa bakya, “Lakini mwenga mubaya nenga na nyai? Petro kayangwa nikubaya, “Kristo boka kwa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Lakini kwa kubakeleboya, Yesu kabaeleza kutobaya kwa yeyoti kunani ya lino, ");
INSERT INTO ndg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Atibaya kwamba mwana wa Adamu lachima bantese kwa makowe yanamboneni kunkana ni apendo ni makuhani bakolo ni baandishi, ni atauwa, ni lichoba lya tatu apauluka boka mu'kiwo. ");
INSERT INTO ndg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Atikuwabakiya boti, “kati mundu yeyotri apala kunikengama, lachima aikane mwenr, atole msalaba wake kila lichoba, ni anikengame. ");
INSERT INTO ndg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yeyoti ywa jaribu okowa maisha gake apala obiya, lakini yoyoti obiya maisha gake kwa faida yango, apala okoka. ");
INSERT INTO ndg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Je kipala kufaidia namani mwanadamu, muite apalike ulimwengu woti, lakini obiya au apatike asara ya nafsi yake? ");
INSERT INTO ndg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Lini yoyoti ywa nibonia oni nee ni maneno gango, kwa ywembe mwana wa Adamu atikum'bonea oni paabile ni nkati ya utukufu wake, ni utukufu wa Tate ni malaika batakatifu. ");
INSERT INTO ndg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lakini natikuwabakiya ukweli, kui ni baadhi yinu batiyemanyanga, abata baonjike kwaa kiwompaka bauone ufalme wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yapitike katika machoba nane baada ya Yesu baya maneno gaa kwamba atikubatola pamope ni ywembe Petro, Yohana ni Yakobo, batioboka kitombe loba. ");
INSERT INTO ndg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ni pabile katika loba, bonekana kwa kuminyo yake kutibadilika, ni nganju yake yabile nyeupe ni ng'ara. ");
INSERT INTO ndg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ni lola, babilr analome abele batilongela nakwe babile Musa ni Eliya. ");
INSERT INTO ndg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Babonekine katika utukufu. Batilongela kuhusu boka kwake, kikowe chakalibila timiza Yerusalem. ");
INSERT INTO ndg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nambeambe Petro ni balo babile pamope kwee babile batiyemanga pamope nakwe. ");
INSERT INTO ndg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yapitike kwamba pabile bakibokanga kwa Yesu, Petro atikum'bakiya, “Ngwana ni vizuri kwitu tama pano ni itupasa tengeneza makazi ya bandu atatu. Tengeneza limo kwaajili yako, limo kwaajili ya Musa, ni jimo kwaajili ya Eliya, Aelewite kwa chalongeite. ");
INSERT INTO ndg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Patilongela aga, laichile liunde ni latikuwayobeka; ni batoyogopa pamweni batindilwe ni liunde. ");
INSERT INTO ndg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lilobe lya pitike kumaunde baya, “hayoo nga mwana wango mteule. Mumpekani ywembe.” ");
INSERT INTO ndg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lilobe palikotwike, Yesu abile kichake. Batamile chichii, ni katika machiba galo babakiye kwaa yeyoti chochoti. ");
INSERT INTO ndg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Lichoba lenge, baada ya boka pakitombe, bandu banyansima batikwembana nakwe. ");
INSERT INTO ndg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lola, nnalome boka mu'bandu atilela kwa lilobe, baya, “Mwalimu nindaloba ulinge mwana wango, mana ni mwana wango wa pekee. ");
INSERT INTO ndg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ubweni nchela hunkwamwa, ni mara ukombwa ndoti, ni kae umpanga changanyikiwa ni boywa pou mu'nkano, Nayo uboka kwa shida, na pia andaminya muno. ");
INSERT INTO ndg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Natikuwasihi benepunzi bako kuikemia iboke, lakini bawesike kwaa.” ");
INSERT INTO ndg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kayangwa nikubaya, “Enyi kizazi cha kiamini kwaa ni chakiobile, mpaka namwe toleana namwe? M, leti mwana wako pano.” ");
INSERT INTO ndg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kijana ywaichile, roho chapu itntombwa paeni kumtikisa kwa pujo lakini Yesu atikemea yelo roho njapu, atikumponya ywa nnalome, ni kunkabidhi kwa tate bake. ");
INSERT INTO ndg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Boti batishangala ni ukolo wa Nnongo. Lakini pawabile batishangala boti kwa makowe goti yagatendite, baya kwa benepunzi bake, ");
INSERT INTO ndg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Maneno yatame mmakutu ginu, kwa kuwa mwana wa Adamu atitolewa muluboko lwa bandu.” ");
INSERT INTO ndg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lakini baelewite kwaa maana ya maneno ago, ni atihiya mminyo gabe, linga kana baelewe batiyogopa kumlokiya kuhusu neno lelo. ");
INSERT INTO ndg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Boka po mgogolo utumbwike nkati yabe kunani ya namani apala panga nkolo. ");
INSERT INTO ndg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lakini Yesu paatambwile chabalokiana munyoya yabe atikumtola mwana nchunu, ni kum'beka upande wake, ");
INSERT INTO ndg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ni kubaya, “Kati mundu yeyoti ywampokeite mwana nchunu kati yono kwa lina lyango, anipokeite nee, ni yeyoti ywanipokeite nee, ampokeite ywaanitumile, kwa kuwa abile nchunu kati yinu nga nkolo.” ");
INSERT INTO ndg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana kayangwa ni kubaya, “Ngwana twamweni mundu akibenga moka kwa lna lyako ni tutikunkanikia kwa sababu akengamana kwaa ni twee.” ");
INSERT INTO ndg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lakini Yesu atikum'bakiya, “kana munknikiye, kwa kuwa ywa abile kwaa kinyume ni mwenga ni wa kwinu.” ");
INSERT INTO ndg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yapitike kwamba, lingana na machoba yagabile karibu ni machoba gake ga yenda kumaunde, kwa uimara aelekezite minyo gake Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Atumite ajumbe nnonge yake, nabo batiyenda ni jingiya katika ijiji ya Asamaria linga bantayarishie mahali. ");
INSERT INTO ndg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lakini bandu bakwe bampokeite kwaa, kwa sababu abile atielekeza minyo gake Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Benepunzi bake Yakobo ni Yohana palibweni leno, batibaya, “Ngwana upala tuamuru mwoto uhuluke pae boka kumaunde ubatiniye?” ");
INSERT INTO ndg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lakini atibagalambukiya nikubakanikiya. ");
INSERT INTO ndg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Boka po batiyenda ijiji chenge. ");
INSERT INTO ndg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pababile bakiyenda, katika ndela yabe, mundu yumo atikuwabakiya, “Nipala kukukengama kokoti kwa uyenda.” ");
INSERT INTO ndg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu atikum'bakiya, “mbweha bana mayembwa, iyuni wa anga bana itundu, lakini mwana wa Adamu hana pa beka mutwe bake.” ");
INSERT INTO ndg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ndipo atikum'bakiya mundu ywenge, “Nikengame.” Lakini ywembe atibaya, “Ngwana, uniruhusu kwanza niyende nikamchike tate bango,” ");
INSERT INTO ndg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lakini ywembe atikum'bakiya, “mubaleke wafu bachikane wafu bene, lakini wenga uyende utangaze ufalme wa Nnongo kila mahali.” ");
INSERT INTO ndg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pia mundu ywenge atibaya, “Nipala kukukengama, Ngwana, lakini uniruhusu kwanza nikawalage bababile kachango.” ");
INSERT INTO ndg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Lakini Yesu atikuwabakiya ntopo mundu, yajea luboko lwake lemana linga mchogo ywafaika kwa ufalme wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Baada ya makowe ago, Ngwana atichawa benge sabini na kubatuma abele abele bamlongoli katika mji ni enea atilitarajia yenda. ");
INSERT INTO ndg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Atikuwabakiya, “Mauno ni ganambone, lakini wapanga kazi ni achache. Hivyo basi mulobe Ngwana wa mauno, ili kwamba atumeatume haraka apanga kazi katika mauno gake. ");
INSERT INTO ndg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Muyende katika miji, Mulole, nindakubatuma kati ngondolo katika mapwa mwitu. ");
INSERT INTO ndg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kana mpotwe mfuko wa mbanje, wala mikoba ya usafiri, wala ilatu, wala kana musalimii yeyoti mundela. ");
INSERT INTO ndg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Katika nyumba yeyoti mwamujingile, kwanza mubaye, “Amani ibii katika nyumba yinu.' ");
INSERT INTO ndg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kati mundu wa amani abile palo, amani yinu ipala igala kunani yake, lakini kama sivyo, ipala buya kwinu. ");
INSERT INTO ndg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Muigale katika nyumba yoo, mulye ni munywangange chabakipya, kwa maana mwapanga kazi astahili mchaala wake, Kana muhame boka kunyumba yoo yenda yenge. ");
INSERT INTO ndg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mji wowote wa'mujingile, ni kubapokya mulye chochoti chakibekwa nnonge yinu, ");
INSERT INTO ndg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ni mponyange atamwe bababile mwoo. Mubaye kwabe,'ufalme wa Nnongo uichile karibu yinu' ");
INSERT INTO ndg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lakini katika mji wowti wa mwamujingiya na bangana kuwapokiya, muyende panja katika ndela ni baya, ");
INSERT INTO ndg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Hata vumbi lya mji uno lalinata magolo mwitu tunalikung'unda dhidi yinu! lakini mtambwange leno, Ufalme wa Nnongo utikaribia.' ");
INSERT INTO ndg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nindakuwabakiya kwamba lichoba lya hukumu yopanga ni uvumilivu zaidi kwa Sodoma kuliko mji wuno. ");
INSERT INTO ndg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ole wako Korazini, Ole wako Bethsaida! Kati kachi ngolo yaipangite nkati yako ingalipangika Tiro ni Sidoni, Bangalitubu zamani kweli, bakitama nkati ya magolo ga magunia ni majivu. ");
INSERT INTO ndg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lakini ipala istaimilivu zaidi ya machoba ga hukumu kwa Tiro ni Sidoni zaidi yinu. ");
INSERT INTO ndg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Wenga Kapernaumu, ufikiri kakatuliwa mpaka kumaunde? Ntopo, upala uluka pae mpaka kuzimu. ");
INSERT INTO ndg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ywa abapekania mwee anipekania nee, ni yeyoti abakana anikana nee, na yeyoti ywanikana nee ankana ywa anitumile.” ");
INSERT INTO ndg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Balo sabini batibuya kwa puraha, baya, “Ngwana hata moka watupekania kwa liina lyako” ");
INSERT INTO ndg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu atikuwabakiya, “Nambweni nchela akitomboka boka kumaunde kati radi. ");
INSERT INTO ndg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lola, nitakuwapea mamlaka ya lebata mngambo ni nge, ni ngupu yoti ya adui, ni ntopo chochoti kwa ndela yeyoti chakipala kubadhuru mwenga. ");
INSERT INTO ndg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hata nyoo kana mupulaike tu katika leno, kwamba roho indabatii, lakini mpulaike zaidi kwamba malina yinu yaandikilwe kumaunde.” ");
INSERT INTO ndg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Katika muda wowolo atipulai sana katika Roho mpeletau, ni kubaya, “Nindakusifu wenga Tate, Ngwana wa kumaunde ni kilambo, kwa sababu upangite makowe aga boka kwa bene hekima ni akili, ni kuyaumukwa kwa babapundishwe kwaa, kati bana achunu. Ndio Tate, kwa kuwa yapendezite katika minyo gako.” ");
INSERT INTO ndg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kila kilebe kitikabidhiwa kwango ni Tate bango, ni ntopo ywatanga Tate ni nyai ila mwana, ni yeyoti ywatamani mwana kuyaumukwa kwake.” ");
INSERT INTO ndg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Atikuwagalambukia anapunzi bake baya faragani, “woti barikiwa bababona haga ambayo mwenga mwagabona. ");
INSERT INTO ndg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ninda kuwabakiya mwenga, kwamba anambone ni afalme batitamani bona makowe mwamuyabona, ni wayabweni kwaa, niyowa mwamuyowa mwenga, ni bayowine kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lola mwalimu pulani wa saliya ya Kiyahudi atiyema ni kumjaribu, baya, “Mwalimu nipange namani niurithi ukoti wangayomoka?” ");
INSERT INTO ndg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu atikum'bakiya, “Itiandikwa namani katika saliya? Indachomeka kitiwi?” ");
INSERT INTO ndg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kayangwa ni kubaya, “Utampenda Ngwana Nnongo wako kwa mwoyo wako wpti, kwa roho yako yoti, kwa ngupu yako yoti, ni kwa malango gako goti, ni jirani yak kati nafsi yako mwene.” ");
INSERT INTO ndg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kabaya, “Uyangite kwa usahihi, panga nyoo ni upala tama.” ");
INSERT INTO ndg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lakini mwalimu, atitamani kujibalangia haki mwene, atikum'bakiya Yesu, “ni jirani yango ni nyai?” ");
INSERT INTO ndg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu kayaangwa ni kubaya, “Mundu pulani abile uluka boka Yerusalem yenda Yeriko. Atitomboka kati ya anyang'anyi, batolite mali yake, ni kumkombwa ni kumleka karibu ya waa. ");
INSERT INTO ndg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kwa bahati kuhani pulani atiuluka kwa ndela yoo, pamweni atipita upande wenge. ");
INSERT INTO ndg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nyonyonyo mlawi pia, paikite mahali palo ni kumwona apitike upande wenge. ");
INSERT INTO ndg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lakini Msamaria yumo, atisafiri, apitike palo pabile mundu yolo pamweni apatike huruma. ");
INSERT INTO ndg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Atikumkaribia ni kumtaba ilonda yake, ni kumpenganikia mauta ya divai kunani yake. Nakum'beka kunani ya mnyama wake, ni kumpeleka katika nyumba ya angeni ni kumuhudumia. ");
INSERT INTO ndg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lichoba lenge atitola dinari ibele, ni kumpeya mmiliki wa nyumba ya angeni ni kum'bakiya,'muhudumie ni chochoti cha ziada chautumia, mbalepa panibuya.' ");
INSERT INTO ndg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","37","Ni ywako kati ya haba atatu, yafikiri, abile i jirani kwake ywembe ywatombwike kati ya anyang'anyi?” Mwalimu atibaya, “Ni yolo alaite huruma kwake.” Yesu atikum'bakiya, “Uyende ni upange nyonyoo.” ");
INSERT INTO ndg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mbeambe pabasafiri batijingya katika ijiji pulani, ni nnwawa yumo lina lyake Martha atikumkaribisha kunyumba yake. ");
INSERT INTO ndg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Abile ni dada bake akemwa Mariamu, yatamile pamagolo ya Ngwana ni pekania neno lyake. ");
INSERT INTO ndg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lakini Martha atikuipeya shughuli yanambone za anda chakulya. Atiyenda kwa Yesu, ni baya, “Ngwana, ujali kwa kwamba dada bango atinilekiya nihudumiye kichango. Hivyo basi ubakiyeaiche kuniyangatiya.” ");
INSERT INTO ndg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lakini Ngwana atiyangwa ni kum'bakiya, Martha, martha, unachumbuka kunani ya makowe yanambone, ");
INSERT INTO ndg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Lakini ni kikowe chimo tu chema, Mariamu atichawa kilicho chema, ambacho hakitaondolewa boka kwake.” ");
INSERT INTO ndg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yapatike wakati yesu pabile kaloba sehemu fulani yuma wabanafunzi bake atikuwabakia “Ngwana utupundishe twenga loba kati yehona cha bafumbike anafunzi bake”. ");
INSERT INTO ndg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu atikuwabakiya, pampalasali, mubaye, tate, lina lyako lifukuzwe, ufalme wako uiche. ");
INSERT INTO ndg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utapei mkate witu wakila lichobo. ");
INSERT INTO ndg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utasamii makasagitu, kati twenga chatu wasania bahatukosea boti, kana utujeilii mmajalibu. ");
INSERT INTO ndg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu atikuwabakiya “Nyai kwinu ya abile na timbwiga yapalakunyendelia kilo na nakumakia mbwigai yango uniachime mikate itatu. ");
INSERT INTO ndg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kwa sababu mbwigali yango haichile na mbeambeno boka safari nanenga ndopo chakumwandaliya. ");
INSERT INTO ndg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nayolo yabile mkati atiyangwa, kanauniangishe mumnyongo tayari ujigalilwe na bana banga pamope nanenga tugonjike pakindanda. Ngwechalii ya yumuka na kukupewa wenga mikate. ");
INSERT INTO ndg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nindakuwabakia kikowe ayumukali na kukupea mikate kati wenga wambwigati yake kwasababu yendeliya kukomboliya oli bila oni, apalayumukali na kukupie ipande yanambone ya mikate lingana na mahitaji yake. ");
INSERT INTO ndg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Manenga mndakuwabakia mulobange na mwenga mpalapata mupalange na mwenga mpalatatu mukombwange oli na mwenga mpalayongolekwa. ");
INSERT INTO ndg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwa kuwa kila mundu yaloba apalapokiya na kila mundu yapala apapata na kila mundu yakombwa odi, mnyango apayogolekwa. ");
INSERT INTO ndg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tate ywakwo kati yinu, mwana wake mana alobite omba, ampeya mngambo badala yake? ");
INSERT INTO ndg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Au kunnoba lipinga kampeya kipelele badala yake? ");
INSERT INTO ndg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kwa nyo, mwenga mwabile alau mutangite kuwapea bana binu kuwapea zawadi yaibile inanoga, muno kwaa Tate binu wa kumaunde apala kuwapea Roho Mpeletau balo babamnoba?” ");
INSERT INTO ndg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Baadaye Yesu abile kaakemiya nchela, ni mundu ywabile ni nchela abile ni bubu. Pabile nchela gam'boi, mundu yolo awechite longela. Bandu banyansima batishangala muno. ");
INSERT INTO ndg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lakini bandu benge batibaya, “hayo aboya nchela kwa Beelzebul, nkolo wa nchela. ");
INSERT INTO ndg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Benge batiyangwa ni kumpala abalage ishara boka kumaunde. ");
INSERT INTO ndg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lakini Yesu atiyatambua mawaso gabe ni kuwabakiya, “kila ufalme waubaganika ya panga ukeba, ni nyumba yaibaganike yalwatomboka. ");
INSERT INTO ndg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kati nchela atibaganika, ufalme wake upala yama kitiwi? Kwa sababu mubaya apiya moka kwa Belzebuli ");
INSERT INTO ndg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kati nee nipiya mokoka kwa Belzebuli, Je ainu baboya moka kwa ndela gani, Kwasababu yeno, babo bapala kuwa ukumu mwenga. ");
INSERT INTO ndg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lakini, kati meite niboya moka kwa lakonji lwa Nnongo uwichile. ");
INSERT INTO ndg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mundu ywabile ni ngupu yabile ni silaha kalendela nyumba yake, ilebe yake ipalal tama salama. ");
INSERT INTO ndg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lakini kumvamia ni mundu ywabile ni ngupu zaidi, yolo mundu mwene ngupu nakumpokonywa silaha yake, natola mali yake yoti. ");
INSERT INTO ndg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ywembe ywabile pamope ni nee abile kinyume ni nee, ni ywembe yayangabana kwaa pamope ni nee utawanyisha. ");
INSERT INTO ndg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ncheka nchapu pammoka mundu, ayenda ni pala sehemu pagamile ntopo mache lenga apomoli. ");
INSERT INTO ndg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Papanga akosite, ubaya, nipala buya kwa mboi. Papala buya nabona nyumba ipambilwe ni itama vizuri. ");
INSERT INTO ndg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nga nyo paba buyangine nakoliya nyumba itipyailwa ni itami vizuri. Huyenda pala moka genge saba balio baovu zaidi kuliko ywembe mwene ni kubaleta baichange tama sehemu yelo. Ni hali ya mundu ywoo upanga m'baya kuliko ywabile mara ya kwanza. ");
INSERT INTO ndg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yapitike kwamba pabaite maneno goo, nnwawa pulani akombwililobe lyake zaidi ya boti pamkutano wa bandu ni baya, “litibarikiwa ndumbo lalikupapite ni mabele yauyongite.” ");
INSERT INTO ndg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lakini ywembe atibaya, mutibarikiwa mwamupekaniya neno lya Nnongo ni kulitunza. ");
INSERT INTO ndg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","wakati bandu banyansima batikusanyika ni yongeyeka, Yesu atumbwile baya, “Kizazi cheno ni kizazi cha maovu. Upala ishara ni ntopo ishara yabapeilwa zaidi ya yelo ishara ya Yona. ");
INSERT INTO ndg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Maana kati Yona abile ni ishara kwa bandu ba Ninawi, nga nyo ni mwana wa Adamu apala baa ishara kwa kizazi cheno. ");
INSERT INTO ndg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Malkia wa kusini ayimaa lichuba lya hukumu ni bandu ba lubeleko linu ni kubahukumu bembe kwani ywembe apitike mwisho wa kilambo linga aiche apikani hekima ya Solomoni, ni hapo abile nkolo kuliko Solomoni. ");
INSERT INTO ndg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bandu ba Ninawi bayimaa katika hukumu pamope ni bandu ba lubeleko luu lichoba lya hukumu bakikuhukumu, kwani bembe batitubu kwa mahubiri ga Yona, ni linga, hapa abii nkolo kuliko Yona. ");
INSERT INTO ndg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ntopo mundu yoyoti, ywa washa taa ni kuibuka sehemu pae yene libindu yangali bonekana au pae ya kitondo, ila washa ni kuibika panani ya kilee lnga kila mundu ywa jingya aweche bona bwea. ");
INSERT INTO ndg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lio lyako ni taa ya yiga, lio lyake mana lizuri basi yiga yake yoti yabaa mumbwea. Lakini lio lyako mana libile libaya basi yiga yako yoti waba mulubindu. ");
INSERT INTO ndg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kwa nyo, muhiadhili linga bwea wa ibile nkati yinu kana ujihilwa libindu. ");
INSERT INTO ndg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kwa nyo, kati yiga yoti ibile mubwega, ni ntopo sehemu yaibile mulubindo, basi yiga yako wabaa sawa ni taa yaiyaka ni piya bwega kwinu.” ");
INSERT INTO ndg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Paywomwile longela, Farisayo atikunkoka akalye chakulya kachake, naye Yesu ajingii nkati ni ba pamope nabo. ");
INSERT INTO ndg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ni mafarisayo batichangala kwa kuwa haulugwi kwa kwanza kabla ya chakulya cha kitamuyo. ");
INSERT INTO ndg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lakini Ngwana awabakiye, “mwenga Mafarisayo mughulwa ikombo panja ni makaburi, lakini nkati yinu mutwi kwaa tamaa ni ulau. ");
INSERT INTO ndg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwenga mwa bandu mwangali lunda buli ywembe ywaubile panja aumbite kwaa ni ngati kae? ");
INSERT INTO ndg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","mwapei masikini gagabile nkati, ni ikoe yoti yapanga safi kwinu. ");
INSERT INTO ndg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lakini ole winu Mafarisayo, kwani mpiya zako ya mnanaa ni ndebele ni kila aina ya mboga ya bustani. Lakini mlekite makoe ga haki ni kumpenda Nnongo, bila leka panga ginge kae. ");
INSERT INTO ndg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ole winu Mafarisayo, kwa kuwa mpendi tama katika itego ya nnongi mu sinagogi na lamukilwa salamu ya heshima mmusoko. ");
INSERT INTO ndg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ole winu, mulandana ni makaburi gangali ni alama ambago bandu utyanga panani yake bila tanga.” ");
INSERT INTO ndg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mwalimu yumo ywa saliya ya Kiyahudi anyangusi ni kumakiya, Mwalimu chaukibaya chenda kutuuzi kayetwenga.” ");
INSERT INTO ndg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu abayite, “Ole winu, baalimu ba shaliya! kwani muapea bandu michigo mikulu yangali kuiwecha kuiputwa, lakini mwenga mkunywa kwaa michigo yoo hata kwa lukonji lumo. ");
INSERT INTO ndg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ole winu, kwasababu mchenga ni bika kumbukumbu mu makaburi ga manabii amababo mjenga kumbukumbu katika makabuli ga manabii ambabo bababulige ni bukubinu. ");
INSERT INTO ndg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nga nyo mwenga muchimulya yitityana na kachi yabapangite babubinu kwa sababu kweli bawile manabii ambabo mjenga kumbukumbu katika makaburi gabe. ");
INSERT INTO ndg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwasababu ya kae hekima ya Nnongo ibaya, “Mbakuatuma manabii ni mitume nabo bapakuatesa ni kuabulaga baadhi yabe. ");
INSERT INTO ndg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Lubeleko lu lwa wajibika kwa damu ya manabii babawile tangu tumbwa kwa kilambo. ");
INSERT INTO ndg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Buka damu ya Abeli hadi damu ya Zakaria, ywa wile katikati ya madhabahu ni patakatifu. Ndiyo niwabakiya mwenga, lubeleko lu chawajibika. ");
INSERT INTO ndg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ole winu balimu ba saliya ya Kiyahudi, kwa sababu mtweti funguo ya lunda; mwenga mwabene mujingya kwaa, ni balo babapala jingya mwanda kuwa chibya.” ");
INSERT INTO ndg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Baada ya Yesu buka palo baandishi ni Mafarisayo batikumpinga ni ntau nakwe husu makowe maingi. ");
INSERT INTO ndg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kubapaya akole kwa maneno gake. ");
INSERT INTO ndg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kwa wakati wo maelfu ganambone gabandu balikusangika pamoja kiasi cha tumbwa libatana atumbwi bayana banafunzi bake muhidhali na chachu ya mafarisayo ambayo nga unafiki. ");
INSERT INTO ndg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Na pabali na siri yai iyilwe ambayo ya umukulilwalii wala jambo laliiyilwe ambalo latangani kwali. ");
INSERT INTO ndg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na lyolyoi laumbayit palibindu layanika pabwega. Na gogota gamubajite munachikilo nkati ya yumba yinu ya nkati yamuyigile gatangazwa panani ya nyumba. ");
INSERT INTO ndg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nenda kuabakia mabwiga lyangu kana mwayoghope balu bababulagayiga na mtupu kile chingi chabakipanga. ");
INSERT INTO ndg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lakini ni palakuabula ywakunyogopa. mungogope yulu ambaye baada ya bulaga aina ngupu ya kukutailya jehanamu elo nendakuabakia mwenga munyogopenywo. ");
INSERT INTO ndg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Je shomoro batano bapimiali shilingi ibele? hata ivyo mtupu hata yamo ywabapala kumbalya mbele ya Nnongu. ");
INSERT INTO ndg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lakini mtange kuwa nywili ya mumitwee yinu itibalangwilwa kana muyogope. mwenga muina thamani ngulu kuliko shomoro baingi. ");
INSERT INTO ndg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ninda kuabakia, ywaniyikitiya nenga nninge ya bandu, mwana wa Adamu anyiyikitya nnonge ya malaika na Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lakini ywoywoti ywanikana nnonge ya bandu ni ywembe akanikiya nnongi ya malaika ba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ywoywoti nywabaya lineno kunani ya mwana wa Adamu, asamehelwa, lakini ywoywoti ywa mkufuru Roho mpeletau, asamehelwa kwaa, ");
INSERT INTO ndg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bapampeleka nnongi ya wakolo ba masinagogi, atawala, ni bene mamlka, kana muyogope husu namna ya longela katika kuitetea au kile cha baya, ");
INSERT INTO ndg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwa kuwa Roho Mpeletau ampundisha namani mwampala baya kwa wakati woo,” ");
INSERT INTO ndg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundu yumo katika likusanyiko ammakiye, mwalimu, umakiye nnunangu ampei sehemu ya urithi wango,” ");
INSERT INTO ndg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu an'yangwi, ni nyai ywa nibikite panga namwamuzi ni wanipatanisha kati yinu? ");
INSERT INTO ndg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nga aabakiya, muiadhari ni kila namna ya tamaa, kwa sababu ukto wa mundu ubile kwaa katika wingwa ilibe yabile nayo.” ");
INSERT INTO ndg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu aabakiye mfano, kabaya, nng'unda wa mundu yumo tajiri yatipambika muno. ");
INSERT INTO ndg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ni atikuilokiya nkati yake, kabaya, mbange namani kwani ntopo mahali pabika yakya yango? ");
INSERT INTO ndg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ngabaya mbapanga nyaa, mbatekwana magolo gango machunu ni chenga balibile likolo ni kuibika yakulya yango yoti ni ile yenge. ");
INSERT INTO ndg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Naibakiya nafsi yango, “Nafsi, uibekii akii ya ile yanambone kwa miaka yanambone upumuli, ulye, unywee ni ustalee.” ");
INSERT INTO ndg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lakini Nongo ammakiye, wenga mundu mpumbavu, kiloo cha lino tupala mwoyo buka kwako, ni ilee yoti yaniandaite yapanga ya nyai? ");
INSERT INTO ndg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nga yapanga kwa kila mundu ywa ibekya mali ni kuitayalisha kwaajili ya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu aabakiye benepuzi bake, kwa nyo nenda kuwabakiya kana muyogope husu maisha yinu ya kwale mwa lyaa namani au husu yega yinu mwa wala namani. ");
INSERT INTO ndg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","kwa kuwa maisha nga muno kuliko chakulya, ni yega muno kuliko ngobo. ");
INSERT INTO ndg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Muilinge iyuni ya angani, balima kwaa wala bauna kwaa. Ntopo chumba wa lighulo lya bikya, lakini Tati bitu anda kuwaleleya mwenga bora kwaa kuliko iyuni! ");
INSERT INTO ndg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ywako nkati yinu ambaye ywaisumbua awesa yongeya dhiraa imo katika maisha gake? ");
INSERT INTO ndg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mana basi mngwecha kwaa panga hacho kichunu chakibile rahisi kwa namani kuisumbwa hago genge? ");
INSERT INTO ndg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mugalinge maluba mwagakula. Gapanga kwaa kazi wala gapota kwaa. Lakini nenda kuwabakia hata Suleimani katika utukufu bake boti ban'gwalike kwaa kati yimo yapo haga. ");
INSERT INTO ndg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mana Nnongo ugawalika vizuri maakapi ga mmendi, ambago leno gabile, ni malau ugataikwa pa mwoto. Buli mwenga muno kwaa aweza kun'gwalika? mwenga imani njunu! ");
INSERT INTO ndg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kana msumbukii husu mwa lyaa namani au mwa nywa namani wala kana m'be ni hofu. ");
INSERT INTO ndg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwa kuwa mataifa goti ga kilambo basumbukiya mambo gabe. Ni Tati binu atangite kuwa mpala ago. ");
INSERT INTO ndg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lakini muupale ufalme wake kwanza, ni ago genge anyongekeya. ");
INSERT INTO ndg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kana muyogope mwenge mwa likundi lichini kwasababu Tati binu apulaikya kwapea ufalme. ");
INSERT INTO ndg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mupimeye mali yinu mukaapeiimaskini, muhipangii mifuko yangali yomoka hazina ya kunani yanga yomoka, sehemu ambayo baii bakalibia kwaa wala nondo aweza kwaa alibu. ");
INSERT INTO ndg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwa kuwa paibile hazina yako, nga mwoyo wako paupabaa. ");
INSERT INTO ndg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ngobo yinu ndachi ibe itabilwe kwa nkanda, ni taa yinu muhakikishe kuwa kaiyendelya yakaa. ");
INSERT INTO ndg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ni m'be kati bandu babannolekea Ngwana wabe buka kusheree ya ndoa, linga mana aichile ni kumbwa ulibawecha kunyughulya nniyango kwa haraka. ");
INSERT INTO ndg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Batibarikiwa balu atumishi ambao Ngwana aakolya bai minyo. Hakika atabaa ngobo yake ndacho kwa nkanda alafuatawika pae kwa chakulya, ni kubahudumia. ");
INSERT INTO ndg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kati Ngwana aaicha kwa zamu yeneibele ya lindela lya kilo, au hata zamu yene itatu ya lindela, ni kunkolya wabiile tayari, yabaa heri kwa abo atumishi. ");
INSERT INTO ndg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","zaidi ya ago mutange linga, kati ngwana mwene nyumba akatangage saa ambayo mwii andaicha, apeilekali nyumba yake tekwana. ");
INSERT INTO ndg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mube tayari kai kwani mutangite kwaa ni wakati gani mwana wa Adamu abuyangana. ");
INSERT INTO ndg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petro abayite, “Ngwana, utubakia twenga mfano yii, au umakiya kila mundu? ");
INSERT INTO ndg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ngwana amm'bakiye, nyai mwanda mwaminifu au mwene hekima ambaye ngwana wake amika panani ya abanda benge lenga abagane chakulya chabe kwa wakati wapalikwa? ");
INSERT INTO ndg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Atibarikiwa mmanda yolo ambaye bwana wake mana aichile ukolya kapanga galo ganagile. ");
INSERT INTO ndg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hakika nindakuwabakiya mwenga ya kuwa ami'ka manani ya mali yake yoti. ");
INSERT INTO ndg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lakini mmanda yolo mana abayite pa mwoyo wake,'bwana wango achia buya, nga nyoo ngatumbwa kuangumbwa abanda alalume ni alwawa alafu atumbwa lyaa, nywaa ni lobya. ");
INSERT INTO ndg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bwana wake yolo mmanda aicha katika lichuba yanga kwaa kuitegemea ni lisaa langa kwaa kulitanga, ywembe ankata ipande ipande ni kummeka katika sehemu imo ni banga kwaa aaminifu.' ");
INSERT INTO ndg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mmanda ywa yowa mapenzi ga bwana wake, aindaite kwaa wala apangite sawa sawa ni penda kwake, akumbulwa iboko iingi. ");
INSERT INTO ndg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lakini mmanda ywa tangite kwaa mwapendi bwana wake, lakini apangite gagapalikwa adhabu, angumbulwa iboko njunu. kwa kuwa ywembe ywa peilwe yanambone, apalongelwa buka kwake ni ywembe ywaaminilwe kwa yanambone, kwake alongelwa yanambone muno. ");
INSERT INTO ndg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Niichile koya mwoto mukilambo ni nenda tamaniya ibe inda yaka, ");
INSERT INTO ndg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lakini nina ubatizo ambao mbabatizwa, ni nina kyoto mpaka paukamilika. ");
INSERT INTO ndg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Buli mufikilia kuwa niichi leta amani mukilambo? Nyoli, ninda kuwabakiya, badala yake niletite mutalanganike. ");
INSERT INTO ndg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tangu nambeambe ni yendelya paba, ni bandu batano. Katika nyumba yimo babaganike, ni atatu kinyume ni abele abele bapanga kinyume ni atatu. ");
INSERT INTO ndg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Babaganika, tati apanga kinyume ni mwana wake, ni mwana ni mwana apanga kinyume ni tate bake, Mao apanga kinyume ni mwana wake, ni mwana apanga kinyume ni mabake, mwile apanga kinyume ni mkwano, ni mkwano apanga kinyume ni mabake. ");
INSERT INTO ndg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ende kuabakia makutano kae, pa mona maunde kugapita kundondi, mwaya wakati wa ula wandaicha, ni nga chai bile. ");
INSERT INTO ndg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ni mchunga wa kusimana uvumilite mmaya paba ni lyoto likali, ni nga chai baa. ");
INSERT INTO ndg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwenga mwa lau, muweza tafsiri mmoneka wa kilambo ni kunani, lakini iba buli nngwecha kwaa tafsiri wakati waubile? ");
INSERT INTO ndg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ni kwa namani kila yumo kana alipambanue lali la kweli kwake kulipanga wakati pa bi ni nafsi ya panga nyo? ");
INSERT INTO ndg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Maana mana uyihi ni ywakushitakiya nnongi ya hakimu, uitahidi patana na ywa kushitakya mungali balo mundela kana akupeleke kwa hakimu, ni hakimu akupeleki kwa afisa akutaikwa muligereza. ");
INSERT INTO ndg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ninda kuwabakiya wapita mwo adi ulepite mpaka lusenti lwa mwisho. ");
INSERT INTO ndg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ni wakati wowow pabile ni baadhi ya bandu babamtaarifu husu Agalilaya ambabo Pilato atikuabulaga ni yangabana damu yabe ni sadaka yabe. ");
INSERT INTO ndg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu atiyangwa ni kuabakiya, buli mukita kuwa Agalilaya abo babi dhambi kuliko Agalilaya bengi boti nga maana bapatilwe ni mabaya go? ");
INSERT INTO ndg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nyoo kwaa, nenda kuabakiya, lakini mana mutubu kwaa, ni mwenga mpaangamia nyonyo. ");
INSERT INTO ndg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au balo bandu komi ni nane katika Siloamu ambabo nnara watitumbuka ni waa nkati bembe babi bene dhambi muno kuliko bandu katika Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nyoo kwaa, ninga nibaya, mana ntubu kwaa, mwenga mwaboti mwa angania kae. ");
INSERT INTO ndg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu aabakiye mfano woo, mundu yumo abile ni mtini utipandilwa katika nn'gunda wake ni ayei pala matunda nnani yake lakini hapatike kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aamakiye ywa atunza nng'unda, linga kwa miaka itatu nitiicha ni paya pala matunda muntini we lakini mbatike kwaa. uukate, kwani ulete uhalibifu wa bui? ");
INSERT INTO ndg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ywatunza nng'unda ayangwi ni baya uleke mwaka wono linga ni niukulugii ni kubikya mbolea panani yake. ");
INSERT INTO ndg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mana upambike matunda mwaka wauicha ya panga vizuri, lakini mana upambike kwaa, waukate!” ");
INSERT INTO ndg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tumbwe Yesu endefundisha katika yumo nkati ga masinagogi wakati wa sabato. ");
INSERT INTO ndg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Linga abile mao yumo ambaye kwa miaka komi ni mitano abile ni roho nchapu ywa udhaifu, ni ywembe abile atipinda ni ntopo uwezo kabisa wa yima. ");
INSERT INTO ndg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu atikumona, atikumkema amakiye “Mao, ubekilwe huru bukana na udhaifu wako.” ");
INSERT INTO ndg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Abekite maboko gake kunani yake, ni mara yiga yake yatikuinyosha ni atikuntunza Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lakini nkolo wa Sinagogi atikachilika kwa sababu Yesu atikumponya lichuba lya sabato. Nga nyo ntawala ayangwi abakiye makutano, “kui na machoba sita ambago lazima panga kachi. Muiche kuaponya basi, katika lichuba lya sabato kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bwana ayangwi na baya, “mwanafiki! ntopo kila yumo winu unyaghulya mbunda ywako au ngombe buka kyungulu ni kuaongoza kumpeleka nywa lichuba lya sabato? ");
INSERT INTO ndg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nga nyo kae mwana wa Abrahamu, ambaye nchela atikuntaba kwa miaka komi ni minane, buli kipalikwe kwaa kifungo chake kana kiyoghulekwe lichuba lya sabato?” ");
INSERT INTO ndg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pabile kabaya maneno aga, balo boti batikumpinga bamweni oni, bali makutano boti ba bengi batishangilia kwaajili ya makowe ga ajabu gagapangite. ");
INSERT INTO ndg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu abayite, “Ufalme wa Nnongo ulandana ni namani, ni niweza linganisha ni namani? ");
INSERT INTO ndg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ni kati mbeyu ya haradari ya itweti mundu yumo ni kuipanda munng'unda wake, ni kulaa panga mkongo nkolo ni iyuni ya kunani chenga ijumba yabe katika sambi yake. ");
INSERT INTO ndg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kae abayite niulandaniye ni namani ufalme wa Nnongo? ");
INSERT INTO ndg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ni kati chachu ambayo mnwawa uitola ni kuiyangabana muilengo itatu ya bwembe hata umuka.” ");
INSERT INTO ndg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu atyanga kwaa kila mji ni kila kijiji kayenda Yerusalemu ni kuapundisha. ");
INSERT INTO ndg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu yumo alokiye, “Ngwana, ni bandu achunu bai babakolelwa? hivyo atiabakiya, ");
INSERT INTO ndg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Muitaidi jingya pitya nnyango nchunu, kwasababu baingi bapaya ni bawecha kwaa jingya. ");
INSERT INTO ndg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mara baada ya mwene nyumba yima ni jigala mnyango, basi mwayima panja ni kumbwa uli paniyango ni baya, “Ngwana, Ngwana, Utuyungulii ywembe ayangwa ni kuabakiya, nibatangite kwaa mwenga wala kwa mmoka. ");
INSERT INTO ndg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nga mwa baya, “Twalile ni nywa nnongi yako ni wenga watipundisha katika mitaa yitu.' ");
INSERT INTO ndg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lakini ywembe an'yangwa, nenda kuabakiya, nibatangite kwaa, kwa mmoka, muboke kwango, mwenga mwa moanga malau! ");
INSERT INTO ndg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Papanga ni kilio ni saga mino wakati mwababona Abrahamu, Isaka, Yakobo ni manabii boti katika ufalme wa Nnongo, lakini mwenga mwabene mutaikulilwe panja. ");
INSERT INTO ndg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Baicha boka mashariki, magharibi, kaskazini, ni kusini, ni pumulya katika meza ya chakulya cha kitamunyo katika ufalme wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ni utange alee, wa mwisho nga wa kwanza ni wa kwanza apanga wa mwisho.” ");
INSERT INTO ndg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Muda nchunu baadaye, baadhi ya mafarisayo batiicha ni kummakiya, “Uyende ni ubuke paa kwa sababu Herode apala kukubulaga.” ");
INSERT INTO ndg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu abayite, “muyende mukammakiye yolo kibweya, linga, nigabinga moka ni kuaponya lino ni malau, ni lichuba lya itatu naitimiza lyengo lyango. ");
INSERT INTO ndg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Katika ali yoyoti, ni muhimu kwaajili yango yendelya lino, malau ni lichuba laliicha, kwa vile ikubalike kwaa kumulaga nabii kulipau ni Yerusalem. ");
INSERT INTO ndg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalemu, Yerusalemu, nyai ywa abulaga manabii ni kuakumbwa maliwe balo babatumilwe kwinu. Mara ilenga mbala kubakusanya bana binu kati nguku mwa akusanya bana bake pai ya mapapaya gake lakini mwalipalike kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","LInga nyumba yako ilekilwe, ni nee nendakuwabakia mngwecha kwaa kum'bona hata pampala baya Abarikiwe anywo ywa icha kwa lina lya Ngwana.” ");
INSERT INTO ndg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yapitike lochoba lya sabato, pabile kayenda kachake kwa yumo ywa kiongozi wa Mafarisayo lya nkate, nabo babile kabachunguza kwa karibu. ");
INSERT INTO ndg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Linga palo nnongi yake pabile mundu ambaye asuliwae ni iumbe. ");
INSERT INTO ndg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu aalokiye ataalamu ba saliya ya Ayahudi ni Mafarisayo, “Buli, ni alali kumponya lichuba lya sabato au bulii? ");
INSERT INTO ndg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lakini bembe babi chichi kwa hiyo Yesu atikumkamwa, nikumponya ni kumruhusu ayende zake. ");
INSERT INTO ndg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ni ywembe aabakiye, nyai kati yinu ambaye aii na mwana au ngombe atumbukii pa luchii lichuba lya sabato amuuta panja mara yimo?” ");
INSERT INTO ndg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bembe babi ni uwezo kwaa wa pia jibu kewa mambo ago. ");
INSERT INTO ndg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu pakwipilwe kwamba bachawii itii ya heshima, abakiye mfano, Ngabakiya, ");
INSERT INTO ndg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Wakati pankokelwa ni mundu kundoa kana utume katika nafasi ya heshima kwasababu iwezekana akokilwe mundu ambaye mwene heshima muno kuliko wenga. ");
INSERT INTO ndg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wakati mundu ywa mkokite mwenga mwaabele paaicha akubakia wenga, “upiyee mundu yo nafasi yako” ni kwa oni watumbwa tola nafasi ya kumwisho. ");
INSERT INTO ndg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lakini wenga mana ukokilwe, uyende ukatame nafasi ya mwisho, linga wakati yulo ywa kukokite manaaichile awecha kukubakiya wenga, “Mbwiga, uyende nnongi, zaidi,” apo wabaa utieshimika nnongi ya boti bautaminabo pameza. ");
INSERT INTO ndg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","kwa maana kila ywa ikwiya bapakumuuluya ni nywaa iuluya bapa kunkwiya.' ");
INSERT INTO ndg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu kae aabakiye mundu ywankokite, papia chakulya cha mutwe kati au cha kitamwiyo, kana uakoke mabwigalyo au alongo au anunabo au majirani bako matajiri, linga kwamba bembe kana kukoke wenga kwa pata malipo. ");
INSERT INTO ndg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Badala yake, paunga sheree wakoke masikini, ilema, iwete ni ipofu. ");
INSERT INTO ndg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ni wenga wabarikiwa, kwa sababu bawecha kwaa kukulipaa. Kwa maana walipilwa katika ufufuo wa bene haki.” ");
INSERT INTO ndg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wakati umo wa balo babatami mezani pamope ni Yesu, payowine ago, ni ywembe aamakiye, Atibarikiwa yolo ywa lyaa nkate katika ufalme wa Nnongo!” ");
INSERT INTO ndg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lakini Yesu aamakiye mundu yumo aandayite sheree ngolo akokite bandu baingi. ");
INSERT INTO ndg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wakati sheree paibile tayari, amtumite mmanda wake kuabakia balo babakokilwe, muiche, kwa sababu ile yoti ibekilwe tayari ");
INSERT INTO ndg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Boti batumbwi luba radhi, ywa kwanza aamakiye mpanga kachi, mbinike nng'unda, lazima niyende nikalibone tafadhali unisamee,' ");
INSERT INTO ndg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ni ywenge abayite mbimike jozi tano ya ngombe ni nenga niyenda kuwapaya. Tafadhali uniwie radhi.' ");
INSERT INTO ndg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ni mundu ywenge kabaya, “nikobike nnwawa, kwa nyoo ngwecha kwaa icha.' ");
INSERT INTO ndg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mmanda kabuya ni kummakiya ngwana wake makowe ago, ngwana mwene nyumba atikasirika atikummakiya mmanda wake, Yenda uoesi mumitaa uichochoro ya mji ukabatole kwango maskini, ilema, ipofu ni babalemile.” ");
INSERT INTO ndg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mmanda ngabaya, nwana hago gaulagya gapangilwe ni hata nambiambi balo kui na nafasi. ");
INSERT INTO ndg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ngwana ngamakiya mmanda, yenda katika ndela ngalu ni muichocholo bandu ni ubalazimishe bandu bajingii, linga nyumba yango itwetii. ");
INSERT INTO ndg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwa maana nenda kuwa bakiya, katika balo babakokilwe ba kwanza ntopo ywapaya sheree yango.' ");
INSERT INTO ndg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nambeambe bandu banyansima babile kabayenda nakwe pamope agalambwike ni aabakiye, ");
INSERT INTO ndg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mana mundu kaicha kwango ni amchukya kwaa tate bake, mao bake, nnyumbo we, bana bake, anunabe, alalome ni alwawa ndio, ni hata maisha gake awecha kwaa panga mwanapunzi bango. ");
INSERT INTO ndg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mundu ywaapotwa kwaa msalaba wake ni icha ichungu yango hawecha kwaa panga mwanapunzi bango. ");
INSERT INTO ndg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Maana nyai nkati yinu, ambaye atamaniya chenga nnara hatamaa kwa akadilii galamaa kwa mahesabu kati ai na chilo chakipala linga alikamilishe lyo? ");
INSERT INTO ndg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vinginevyo baada ya bika nsingi ni chindwa yomolya, boti bababweni batumbwa kum'dhihaki. ");
INSERT INTO ndg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kabaya, mundu yu alumbwi chenga wakati ntopo ngupu ya yomolya. ");
INSERT INTO ndg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Au mfalme ywako mana kaapala yenda, kumbwana ni mfalme ywenge katika vita ambae hatama kwaa pae kwanza ni tola ushauli usu mana awecha, pamope ni bandu elfu komii kumbwana ni mfalme ywenge kaicha usu ywembe ni bandu elfu ishirini? ");
INSERT INTO ndg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ni mana nyoo kwaa, wakati jeshi lya bengi balo li kutalu utuma mjumbe pala masharti ga amani. ");
INSERT INTO ndg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kwa nyoo basi yoyoti kati yinu ambaye haaleka kwaa yoti yabile nayo, hawecha kwaa, panga mwanapunzi bango. ");
INSERT INTO ndg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Mwinyo ni nzuri, lakini iobiye ladha yake, panga kitiwe panga kai mwinyo kae? Ntopo matumizi kwa bui au hata kwa mbolea undataikwa kutalu. Ywabile na makutu, ni ayowe.” ");
INSERT INTO ndg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bai batoza ushuru boti ni benge bene sambi baichile kwa Yesu ni kumpekania. ");
INSERT INTO ndg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafarisayo ni baandishi batinung'unika kababaya, mundu yoo hubakaribisha bene sambi ni lya nabo.” ");
INSERT INTO ndg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu kabaya mfano wono kwabe, kabaya, ");
INSERT INTO ndg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nyai kwinu, kati abi ni ngondolo mia jimo ni mei teo anobite yumo kati yabo, apala kuwaleka balo tisini na tisa mupongote, ni ayende kumpala yolo ywanobite mpaka kumbona? ");
INSERT INTO ndg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ni ywewmbe maite mpatike umbeka mulipamba lyake ni pulaika. ");
INSERT INTO ndg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Paika kunyumba, ubakema mbwiga kwa yango ni jirani yake nakuwabakiya mupurahi pamope ni nee, kwa kuwa nimpatike ngondolo ywango ywaobite.' ");
INSERT INTO ndg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nindakuwabakia nyonyonyo kupabaa ni puraha kumaunde kwaajili ya mwene sambi yumo yatubu, zaidi ya bene haki tisini na tisa babile ntopo hoha ya tubu. ");
INSERT INTO ndg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Au kuna nnwawa gani ywabile ni sarafu komi za mbanje, payaobite ni sarafu jimo, hapa washa taa ni pyaya nyumba ni kuipala kwa bidii hadi kuipata? ");
INSERT INTO ndg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ni paibona hubakema mbwiga kwaa yake majirani bake kuwabakia mpurahi pamope ni nee, kwa kuwa niipatike sarafu yango yaniobite. ");
INSERT INTO ndg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hata nyoo nindakuwabakiya ibile puraha nnonge ya malaika wa Nnongo kwaajili ya mwene sambi yumo tubu.” ");
INSERT INTO ndg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ni Yesu atibaya, “mundu yumo abile ni bana abele ");
INSERT INTO ndg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yolo nchunu atikum'bakiya tate bake, tate unipei sehemu ya mali yango yoti kuirithi. Nga atibagana mali yake kati yabo. ");
INSERT INTO ndg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Machoba ganambone kwaa yolo nchunu atokusanya vyoti anavyomiliki naboka kilambo cha mbale, na kwoo atitapanya mbanje yake, kwa pema ilebe yaipalite kwaa, na tapanya mbanje yake kwa anasa, ");
INSERT INTO ndg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Naye pabweni ayomwile tumiya yoti njala kolo itiyingya pakilambo chelo nayembe atumbwile panga abi na uhitaji. ");
INSERT INTO ndg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Atiyenda ni kuajiri mwene kwa yumo wa raia wa kilambo chelo, ni yembe atikumpeleka kumng'unda wake lisha magobe. ");
INSERT INTO ndg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ni atitamani kuishibisha kwa maakapi yabalile kwa sababu ntopo mundu ywampei kilebe chochoti cha lya. ");
INSERT INTO ndg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ila yolo mwana nchunu patambwile mwoyoni mwake, abaite ni atumishi alenga wa tate bango bana chakulya chanambone cha tosha ni nenga nibile pano, ni waa na njala! ");
INSERT INTO ndg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nipala boka ni yenda kwa tate bango, ni umbakiya, “Tate nikosite kunani ya maunde ni nnongi ya minyo gako. ");
INSERT INTO ndg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nistahilli kwaa kemelwa mwana wako kae, unipange kati yumo wa atumwa bako.” ");
INSERT INTO ndg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ndipo atiboka ni yenda kwa tate bake, pabile angaliu palipite napatate bake amweni akiya ayei lubela ni kumkumbatiya ni kumnoniya. Yolo mwana atikum'bakiya, ");
INSERT INTO ndg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Tate nikosite kunani ya maunde ni nnonge ya minyo gako nistaili kwaa kemelwa mwana wako.' ");
INSERT INTO ndg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yolo tate atikuwabakiya atumishi bake,'mulileti upesi nganju ya ibile bora, mukamuwalike mujei ni pete mu'ingonji ni ilatu mumagolo. ");
INSERT INTO ndg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Boka po munileti ndama yolo yanonite nakumchinja uliye ni kupurai. ");
INSERT INTO ndg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwa kuwa mwana wango atiwaa naywembe abi hai. Ati oba nakwe atibonekana batumbwile shangilia. ");
INSERT INTO ndg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Bai yolo mwana wake mpendo abile kumngunda. Pabayowine ni karibia kunyumba ayowine malobe ya nyambo ni ng'anda. ");
INSERT INTO ndg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Amkemite mtumishi yumo nakumlokiya makowe gano maana yake namani” ");
INSERT INTO ndg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mtumishi akam'bakiya mnunako haichile ni tate bako atikumchinjia ndama yanenipe kwasababu atibuya salama,' ");
INSERT INTO ndg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwana mpendo atikasirika akani jingiya nkati ni tate bake apitike panja kumpembeya. ");
INSERT INTO ndg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ila atikuyangwa tate bake baya, “lola nenga nitikutumikiya miaka yanambone, wala nikosite kwaa amri yako, lakini unipei kwaa mwana mbui lenga niweche sherekea ni rafiki zango. ");
INSERT INTO ndg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lakini paichile yono mwana wako watapakinye mali yako yoti pamope ni makahaba atikunchinjia ndama yanenipe. ");
INSERT INTO ndg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tate akabakiya,'mwana wango, wenga u pamope ni nenga kila machoba goti ni vyoti yanibile vyo vyako wenga. ");
INSERT INTO ndg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ila yapangite vyema kwitu kumpangiya sherehe ni purai, yono mbwiga wako atiwaa, nanambeambe abi nkoti, ni atioba ni ywembe apatikine.” ");
INSERT INTO ndg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu atibabakiya kae benepunzi bake, “Pabile ni mundu yumo tajiri abile ni meneja, ni apeilwe habari ya kwamba meneja yono atapanya mali yake. ");
INSERT INTO ndg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nga nyoo tajiri atikumkema, nikum'bakiya, “nga namani yeni yaniipekania kunani yako? Upiye hesabu ya umeneja wako, kwa kuwa uwecha kwaa panga wameneja kae.” ");
INSERT INTO ndg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yolo meneja atibaya kumoyo wake, nipala panga namani, mana ngwana wango anikonyie kazi yango ya umeneja? Ntopo ngupu ywa lema, ni loba loba nibona oni. ");
INSERT INTO ndg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nilitangite lanipala panga lenga panipoyelwa kukazi yango ya uwakili bandu banikaribishe kunyumba yabe. ");
INSERT INTO ndg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nga nyoo wakili atikubakema adeni wa ngwana wake kila yumo akam'bakiye wa kwanza,'udaiwa kiasi gani ni ngwana wango?' ");
INSERT INTO ndg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Atibaya ipimo mia jimo ya mauta akambakiya 'utole upesi hati yako utame upesi uyandike hamsini.' ");
INSERT INTO ndg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Boka po atim'bakiya ywenge ni wenga udaiwa kiasi gani? 'atibaya 'ipimo mia jimo vya bwembe wa ngano, akam'bakiya,'utole hati yako uyandike themanini.' ");
INSERT INTO ndg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yolo ngwana atikumsifu meneja dhalimu cha pangite kwa weleu, kwa kuwa bana ba'kilambo wono ni werevu wanambone nashughulika kwa ung'anga ni bandu baupande wabe kuliko bababile bona banuru. ");
INSERT INTO ndg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ni nenga nindakuwabakiya muipange ambwiga kwa mali ya udhalimu lenga baikosike babakaribishe katika makao ga milele. ");
INSERT INTO ndg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ywa abiile mwaminifu katika lalibile lichunu muno upanga uaminifu katika likolo, ni abile dhalimu katika kichunu muno na katika kikolo pia. ");
INSERT INTO ndg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mana mwenga mpangile kwaa uaminifu katika mali ya udhalimu ni ywako apalakukuamini katika mali ya kweli? ");
INSERT INTO ndg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na mana mwabile kwaa baaminifu katika tumia mali ya mundu ywenge nyai ywapala kuwapea yaibile ya kwinu bene? ");
INSERT INTO ndg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ntopo mtumishi ywaweza tumikia ngwana wanaibele, kwa maamna apala kumchukia yumo ni kumpenda ywenge, ama apala chikamana ni yolo ni kumdharau hayo. Hawesa kwaa kumtumikia Nnongo ni mali.” ");
INSERT INTO ndg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bai Mafarisayo, bababile apenda mbanje bayowine ago goti ni chalawa. ");
INSERT INTO ndg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ni atiabakiya, “mwenga mwamuipunia haki nnonge ya bandu, lakini Nnongo aitangite mioyo yinu, kwa kuwa latitumikite kwa bandu upanga chukizo nnonge ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Saliya na manabii vyabile mpaka Yohana paichile. Boka wakati wolo, habari njema ya ufalme wa Nnongo utitangazwa, ni kila mundu upaya jingya kwa ngupu. ");
INSERT INTO ndg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lakini ni rahisi ka kumaunde ni pakilambo viboke kuliko hata herufi yimo ya saliyakosekana. ");
INSERT INTO ndg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kila ywanneka nnyumbowe ni kobeka nnwawa ywenge azini, nayomkobeka ywembe ywalekwite ni nchengowe azini. ");
INSERT INTO ndg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pabile ni mundu yumo tajiri awalite ngobo za rangi ya zambarau ni kitani safi ni abile atipurai kila lichoba utajiri wake nkolo. ");
INSERT INTO ndg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ni maskini yumo lina lyake Lazaro abekitwe muligeti lyake, ni ana ilonda. ");
INSERT INTO ndg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ni ywembe atitamani yukuta kwa makombo yatambwike katika meza ya yolo tajiri hata mapwa waichile ni kumlambata ilonda yake. ");
INSERT INTO ndg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ikawa yolo maskini awile ni tolekwa ni malaika mpaka pakiuba cha Ibrahimu. Yolo tajiri pia awile nachikwa. ");
INSERT INTO ndg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ni kolo kumambe abile kumateso aobwile minyo gake ni kum'bona Ibrahimu kuutalu ni Lazalo pakiuba chake. ");
INSERT INTO ndg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Atilela ni kubaya, Tate Ibrahimu, unihurumie unlei Lazaro achuye ncha ya lukonji lwake mumache, auburudishe ulimi wango, kwa sababu nindateswa katika mwoto wono. ");
INSERT INTO ndg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Lakini ibrahimu abayite, “mwana wango ukumbuke ya kwamba katika maisha yako utipokiya makowe yako mema, ni Lazaro nyo apatike mabaya. Ila nambeyambe abile pano anafarijiwa ni wenga unalumia. ");
INSERT INTO ndg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ni zaidi ya ago, kubekitwe liembwa likolo ni lilacho kati yitu, lengo balo bapala boka kono icha kwoo kana bawechange wala bandu wa kwinu kana baloke icha kwitu.” ");
INSERT INTO ndg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yolo tajiri abayite,'nindakuloba tate Ibrahimu, kwamba umtume kunyumba ya tate bango. ");
INSERT INTO ndg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwa kuwa nibile nabo anunango atano linga abaonye, kwa hofu kwamba nabo baicha mahali pano nateseka.' ");
INSERT INTO ndg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Lakini Ibrahimu abayite, “babile Musa ni manabii babapekani bao. ");
INSERT INTO ndg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yolo tajiri atibaya, “nyoo kwaa, tate Ibrahimu, lakini mana ayendile mundu boka kono kwa wafu bapala tubu.' ");
INSERT INTO ndg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Lakini Ibrahimu atikum'bakiya,'kana bakani kuwa pekania Musa ni manabii bapala shawishika kwaa ni mundu hata mana atiuluka boka mu'kiwo. ");
INSERT INTO ndg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu atikuwabakiya benepunzi bake, “makowe yagasababisha bandu bapange sambi hana budi pitya, lakini ole winu mundu ywasababisha! ");
INSERT INTO ndg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bora panga nyoo mana mundu yoo atitabilwa liwe lanatopa lya yagio paingo ni kumtaika mu'bahari, kuliko kumpanga yumo wa haba achunu atenda sambi. ");
INSERT INTO ndg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Muilindange, mana nnongo wako atikukosea umketeboye, ni ywembe akitubu umsamehe. ");
INSERT INTO ndg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mana akukoseite mara saba kwa lichoba limo ni mara saba kwa lichoba limo aichile kwako baya,'nindatubu,'umsamee” ");
INSERT INTO ndg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mitume bak batikum'bakiya Ngwana, “utuyongekee imani yitu,” ");
INSERT INTO ndg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ngwana abayite, “mana mwabile na imani kati punje ya haradari, mwawezite kuubakiya nkongo wono wa munene, kuutapwa ni ukabolike mubahari, nakwe ungebatii. ");
INSERT INTO ndg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lakini nyai kati yinu, abile ni mtumishi ywalema mng'unda wake ama ywachunga ngondolo, apala kum'bakiya pabuya kung'unda, uwiche haraka ni keti uliye chakulya. ");
INSERT INTO ndg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Je apala kum'bakiya,'uniandalie chakulya nilye, ni uitabe mkanda ni unitumikie mpaka paniyomwa lya na nywaa. Badala ya poo apala lya na nywaa? ");
INSERT INTO ndg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hapakumshukuru mtumishi ywoo kwasababu atimizite galo abakilwe? ");
INSERT INTO ndg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nyonyonyo ni mwenga mana mupangite yaniwalagile mubaye twenga tu atumishi tustahili kwaa, tupangite tu galo gatupasayo panga.' ");
INSERT INTO ndg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yatikuwapitya kwamba pabile safarini yenda Yerusalemu, atipita mpakani mwa Samaria ni Galilaya. ");
INSERT INTO ndg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pajingile pakijiji chimo, kwoo atikoliana ni bandu komi bababile ni ukoma, atiyema kuutalu. ");
INSERT INTO ndg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Batondobiye lilobe baya, “Yesu Ngwana hutuhurumiye.” ");
INSERT INTO ndg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pababweni atikuwabakiya, “Muyende mukailaye kwa makuhani,” nabo pababile andayenda batitakasika. ");
INSERT INTO ndg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumo wabe pabweni kwamba aponi, atibuya kwa lilobe likolo atikumsifu Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Atikilikita mumagolo ya Yesu atikushukuru, yembe abile Msamaria. ");
INSERT INTO ndg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu kayangwa, kabaya, “Je batakasike kwaa boti komi? babile kwako balo benge tisa? ");
INSERT INTO ndg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ntopo hata yumo ywabonekine buya lenga kumtukuza Nnongo, bali yono mgeni? ");
INSERT INTO ndg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ammakiye, “Ukatuke ni uyende zako imani yako ikuponyile.” ");
INSERT INTO ndg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palokiye ni Mafarisayo ufalme wa Nnongohiucha lichoba lyako? Yesu atibaya, “Ufalme wa Nnongo kilebe cha wezekana kwaa bonekana. ");
INSERT INTO ndg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wala, bandu bapala baya kwaa, “mulinge pano! ama, mulinge kolo! kwa maana ufalme wa Nnongo ubile nkati yinu” ");
INSERT INTO ndg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu atikuwabakiya anapunzi bamke, wakati upalaika ambapo mpala tamani kuibona yumo la lichoba la mwana wa Adamu, lakini mupala kulibona kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wapala kum'bakiya, mulinge, kolo! mulinge pano!' Lakini kana muyende linga, wala kubakengama. ");
INSERT INTO ndg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kati umeme wa njai umulikao katika anga tumbulia upande umo hadi wenge. Nga nyoo hata mwana wa Adamu aba nyo katika lichoba lyake. ");
INSERT INTO ndg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakini kwanza impasa teseka katika makowe yanambone ni kumkana ni kizazi cheno. ");
INSERT INTO ndg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kati yalibile lichoba lya Nuhu, ngaipalanga katika lichoba lya mwana wa Adamu. ");
INSERT INTO ndg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Walile, na nywaa, bakikobeka ni konda mpaka lichoba lelo ambalo Nuhu pajingie katika safina ni mafuriko paichile ni kubaangamiza boti. ");
INSERT INTO ndg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nga chaibile katika lichoba lya Ruthu, babile nywaa, pema ni pemeya, lema ni chenga. ");
INSERT INTO ndg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lakini lichoba lelo latu paboi Sodoma, wanyei ula wa moto ni kiberiti boka kumaunde ni kubaangamiza boti. ");
INSERT INTO ndg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nga nyo yaipala panga lichoba lelo lya mwana wa Adamu paumukulwa. ");
INSERT INTO ndg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lichoba liyo kana umruhusu ywabile mudari ya nyumba auluka tola bidhaa yake nkati ya nyumba. Ni kana umruhusu ywabile kumnguta buya kaya. ");
INSERT INTO ndg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mkumbukiya mnyumbowe Ruthu. ");
INSERT INTO ndg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yeyoti ywapala kuyalopya maisha gake apala kuya abiya, lakini yeyoti yayaobiya maisha gake apala kugalopwa. ");
INSERT INTO ndg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","36","Nindakuwabakiya, kilo cheno kupabaa ni bandu abile katika kindanda chimo, yumo apala tolekwa, ni yenge apala lekwa. Pulabaa ni anwawa abele bandaaga nafaka pamope, yumo apala tolekwa ni yenge lekwa.” ");
INSERT INTO ndg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bannobiye, “Wapi Nnongo?” Kaayangwa, “Palo pabile mzoga, ndipo tai kabakusanyika pamope.” ");
INSERT INTO ndg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Boka po atikuwabakiya mfano wa namna babapali kwa loba daima, ni kana bakate tamaa. ");
INSERT INTO ndg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Atibaya,'Pabile ni hakimu katika mji fulani, ambaye atimwogopa kwaa Nnongo ni kubaheshimu bandu. ");
INSERT INTO ndg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Panile ni mjane katika jiji lyo, nayemba atiyenda mara nyingi, abaya, uniyangatiye pata haki dhidi ya mpinzani wango.' ");
INSERT INTO ndg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa muda mrefu abi tayari kwaa kumyangatia, lakini baada ya muda atibaya kumoyo bake,'ingawa nenga nimyogopa kwaa Nnongo ama kubaeshimu bandu, ");
INSERT INTO ndg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lakini kwa lale yono mjane andakunichumbwa nipala kumnyangatia pata haki yake, kana iche nichosha kwa kuniichilia mara kwa mara.” ");
INSERT INTO ndg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Boka po Ngwana abaite,'mpekani chabaite hayo hakimu dhalimu. ");
INSERT INTO ndg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Je Nnongo apaleta kwaa haki kwa bateule haki kwa bateule bake babaleliya mumtwekati ni kitamunyo? Je ywembe apala baa mwaminifu kwabe? ");
INSERT INTO ndg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ninda kuwabakiya kwamba apaleta haki kwabo upesi. Lakini wakati mwana wa Adamu paicha, Je apala kolya imani mukilambo?' ");
INSERT INTO ndg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ngapa abakiya mfano wono kwa baadhi ya bandu babakuibona bene baa na haki ni kubacharawa bandu benge, ");
INSERT INTO ndg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Bandu abele baabwike yenda mulihekalu sali, yumo mfarisayo ywenge mtola ushuru. ");
INSERT INTO ndg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisayo atiyema kaloba makowe haga kunani yake mwene,'Nnongo, nindakushukuru kwa vile nenga si kati bandu benge ambao ni nianyang, anyi, bandu basio wadilifu, azinzi, ama kati yono mtoza ushuru. ");
INSERT INTO ndg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nindataba mara ibele kila wiki. Nipiya zaka katika mapato yoti yaniyapata. ");
INSERT INTO ndg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lakini yolo mtoza ushuru, atiyema kuutalu, bila yawecha kakatuya minyo gake kumaunde, atikopwa kiuba chake nabaya, “Nnongo, nirehemu nenga mwene sambi. ");
INSERT INTO ndg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nindakuwabakiya, “Mundu yolo atibuya kaya abi atibalangilwa haki kuliko yolo ywenge, kwa sababu kila ywa ikweza apala uluywa, lakini kila mundu ywa nyenyekeya apala kakatuliwa. ");
INSERT INTO ndg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bandu batimletia bana babe achanga, linga aweze kubakamua, lakini anapunzi bake pababweni ni galo, Batibakanikiya. ");
INSERT INTO ndg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lakini Yesu atikubakema ni kubaya, “Mubaleke bana achunu baichange kwango nee, wala kanamubakanikii. Maana ufalme wa Nnongo ni wa banda kati abo. ");
INSERT INTO ndg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Amin, nindakuwabakiya, mundu yeyoti ywapokeite kwaa ufalme wa Nnongo kati mwana ni dhahili apala jingya kwaa.' ");
INSERT INTO ndg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mtawala yumo atikumlokiya, akibaya,'Mwalimu mwema, nipange namani lenga niurithi ukoti wanga yomoka?' ");
INSERT INTO ndg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu atikum'bakiya,'kitumbwe namani kunikema mwema? Ntopo mundu ywabile mwema, ila Nnongo kichake. ");
INSERT INTO ndg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Uzitangite amri-kana uzini, kana ujibe, kana ubulage, kana ubaye ubocho, ubaheshimu tate ni mao bako. ");
INSERT INTO ndg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yolo mtawala atibaya,'makowe aga goti nikuyakamwa panibile kijana.' ");
INSERT INTO ndg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu payowine ago ammakiye, “utipongokiwe ni kikowe chimo, lachima upeyeme vyoti vya ubi navyo ni ubagane kwa maskini, ni mwenga upala baa ni hazina kumaunde, boka po uiche, unikengame.' ");
INSERT INTO ndg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lakini tajiri payowine ago, atiuzunika muno kwa sababu abile tajiri wanambone. ");
INSERT INTO ndg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Boka po Yesu, amweni pauzunike muno atibaya,'Jinsi gani yaipalanga mgumu kwa matajiri jingya katika ufalme wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Maana ni rahisi muno kwa ngamya petamu, liembwa lya sindano, kuliko tajiri jingya mu'ufalme wa Nnongo.' ");
INSERT INTO ndg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Balo babayowine ago, batibaya,'nganyi bai, ywawecha lokolelwa?' ");
INSERT INTO ndg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kayangwa,'makowe yagawecha kanika kwaa kwa mundu kwa Nnongo yanda wechekana.” ");
INSERT INTO ndg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petro kabaya,'Naam. twenga tutileka kila kilebe ni kukukengama wenga.' ");
INSERT INTO ndg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Boka po Yesu atikuwabakiya, Amin, nindakuwabakiya kwamba ntopo mundu yailei nyumba ama nnyumbowe, ama anunage, ama alongowe ana bana, kwa ajili ya ufalme wa Nnongo, ");
INSERT INTO ndg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ywembe ywapokiya ganambone zaidi mu'kilambo cheno, ni mu'kilambo chaicha, ukoti wangayomoka.' ");
INSERT INTO ndg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Baada yakubakusanya balo komi ni ibele, atikuwabakiya,'lola, tupala panda yenda Yerusalemu, ni makowe yoti yatiyandikwa ni manabii husu mwana wa Adamu yapata timiya. ");
INSERT INTO ndg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwa maana apajeilwa mumaboko ga bandu bamataifa ni apatendelwa dhihaka ni pyata, ni kumtemiya mmate. ");
INSERT INTO ndg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Baada ya kumkombwa iboko kum'bulaga ni lichoba lya tatu apauluka.' ");
INSERT INTO ndg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Baelewite kwaa, makowe aga, ni neno labile liiywa kwabe, ni baelewite kwaa, makowe yabaite. ");
INSERT INTO ndg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yabile Yesu karibia Yeriko, mundu yumo kipofu abile atamite mbwega ya ndela kaloba msaada, ");
INSERT INTO ndg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Payowine bandu banyansima bapeta atilokya namani chakipitike? ");
INSERT INTO ndg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Batikum'bakiya kwamba Yesu mwana wa Nazareti andapeta. ");
INSERT INTO ndg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nga yolo kipofu atilela kwa lilobe, nabaya, Yesu, mwana wa Daudi, unirehemu.' ");
INSERT INTO ndg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Balo bababile kabatwanga batikumkalipiya yolo kipofu, nakum'bakiya ndooti, lakini yembe atizidi lela kwa lilobe mwana wa Daudi, unirehemu. ");
INSERT INTO ndg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu kayema niamuru mundu yolo aletwe kwake boka po yolo kipofu atikuyogeliya, Yesu atikunlokiya. ");
INSERT INTO ndg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Upala nikupangiye namani?' Atibaya,'Ngwana, nipala bona.' ");
INSERT INTO ndg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu atikum'bakiya,'upate bona. Imani yako ikuponyile.' ");
INSERT INTO ndg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mara yeyelo apatike bona, akamkengama Yesu atimtukuza Nnongo pabamweni lelo, bandu boti batikumsifu Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu atijingya ni peta katikati ya Yeriko. ");
INSERT INTO ndg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Napo pabile ni mundu yumo akemelwa Zakayo, ywembe abile nkolo wa watoza ushuru kae mundu tajiri. ");
INSERT INTO ndg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Abile kapaya kubona Yesu ni mundu wa namna gani, lakini awezite kwaa kum'bona kwasababu ya bandu banyanisima, kwa kuwa abile mwipi wa kimo. ");
INSERT INTO ndg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nga nyo, atilongoliya lubelo nnonge ya bandu, anaoboka kunanin ya mkuyu lenga aweche kum'bona, kwasababu Yesu atikaribiya pita kundela yelo. ");
INSERT INTO ndg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wakati Yesu paikite mahali palo, atilinga kunani ni kum'bakiya, Zakayo, uluka upesi, maana leno ni lachima shinda kunyumba yako! ");
INSERT INTO ndg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Apangite haraka, uluka ni kumkaribisha kwa puraha. ");
INSERT INTO ndg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bandu boti pababweni galo, batilalamika, nabaya,'Ayei kutembelia mundu mwene sambi.' ");
INSERT INTO ndg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayo atiyema nakum'bakiya Ngwana, lola Ngwana nusu ya mali yango nibapeya maskini, ni ikiwa nimpokonyite mundu yeyoti kilebe, mnakumkeboliya mara ncheche.' ");
INSERT INTO ndg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu atikum'bakiya,'leno wokovu uikite katika nyumba yeno, kwa sababu yembe ni mwana wa Ibrahimu. ");
INSERT INTO ndg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwa maana mwana wa mundu aichile pala ni lopwa bandu babaobite.' ");
INSERT INTO ndg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pabayowine aga, atiyendeliya longela ni piya mfano, kwa sababu abii papii ni Yerusalemu anabo batangite ya kuwa ufalme wa nnonge wabile papipi na bonekana mara jimo. ");
INSERT INTO ndg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nga atikuwabakiya,'afisa yumo atiyenda kukilambo chakulipite lenga pokiya ufalme ni boka po buya. ");
INSERT INTO ndg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Atikubakema atumishi bake komi, nakubapeya mafungu komi, nakuabakiya, mukapangie biashara mpaka panibuya! ");
INSERT INTO ndg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lakini bananchi bake batikasirika ni kwa nyoo batilagiya ajumbe bayende, kumkengama ni buya,'atakiwa kwaa mundu yono kututawala,' ");
INSERT INTO ndg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pabile pabuite kaya baada ya pangilwa mpwalme, atiamuru balo atumishi abapeile mbanje bakemelwa kwake, apate tanga faida gani yabaipatike kwa panga biashara. ");
INSERT INTO ndg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wa kwanza aichile, nabaya, Ngwana, fungu lyako lipangite mafungu komi zaidi, ");
INSERT INTO ndg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yolo afisa atikum'bakiya, vema, wa mmanda mwema, kwasababu wabile mwaminifu katika kikowe kichunu, upala panga ni madaraka kunani ya miji komi.' ");
INSERT INTO ndg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wa na ibele, abaite, Ngwana, fungu lyako lipangite mafungu matano.' ");
INSERT INTO ndg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","yolo afisa atikumbakiya,'tola mamlaka ga kunani ya miji itano.' ");
INSERT INTO ndg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ni ywenge aichile, ni baya,'Ngwana yeno pano, banje yako, naibekite salama katika kitambala. ");
INSERT INTO ndg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kwa maana natiyogopa kwa sababu, wenga nga mundu nkale, undaboya chelo cha ukibekite ni una chaupandike kwaa.' ");
INSERT INTO ndg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","hayo afisa atikum'bakiya, kwa maneno yako mwene, nipala kumhukumu, ewe mtumishi mbaya, watangite nenga na mundu nkale, nitola chani bekite kwaa ni una chanipandike kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bai mbona wabekite kwaa mbanje yango katika benki, lenga paniboya nitole pamope ni faida? ");
INSERT INTO ndg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Afisa atikubabakiya bandu bababile batiyema hapo,'munyang, anye alyo lifungu ni kumpeya yolo mwene mafungu komi. ");
INSERT INTO ndg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bakam'bakiya,'Ngwana, yembe abi na mafungu komi.' ");
INSERT INTO ndg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nindakuwabakiya kila mundu ywabile nacho apala peilwa zaidi, lakini ntopo, hata kiche kilebe abile nacho kipala tolekwa. ");
INSERT INTO ndg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Lakini aba maadui bango, babakani nipange mpwalume wabe, baletwe pano ni kuba bulaga nnonge yango.” ");
INSERT INTO ndg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Baada ya baya gano, atiyendeleya nnonge panda yenda Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pabile pakaribie Bethfage ni Bethania, papipi ni kitombe cha mizeituni, atikubatuma anapunzi bake abele, ");
INSERT INTO ndg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Atibaya,'Muyende katika ijiji ya jirani, pamujingya, mpala kumkoliya mwana mbunda anapandilwa kwaa balo, muyogoli, mumleti kwango. ");
INSERT INTO ndg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kati mundu abalokiye, “Mbona mundakumyogoliya” mubaye, “Ngwana andakumpala”. ");
INSERT INTO ndg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Balo babalagilwe batiyenda nakum'bona mwana mbonda kati Yesu chabakiye. ");
INSERT INTO ndg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Babile banda kumyogoliya mwana mbonda wamiliki baka wabakiya,'kitumbwe namani munda kumyogoliya mwana mbunda yono? ");
INSERT INTO ndg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Batibaya, “Ngwana andakumpala.” ");
INSERT INTO ndg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bai, batikumpelekia Yesu, batikumtandika ngobo yabe kunani ya mwana mbonda ni bakamoboya Yesu kunani yake. ");
INSERT INTO ndg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pabile kayenda bandu batitandza mavazi yabe mundela. ");
INSERT INTO ndg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pabile anatelemka pakitombe sa mizeituni, jumuiya yoti ya benepunzi bake batumbwile shangiliya ni kumtukuza Nnongo kwa lilobe likolo, kwa sababu ya makowe makolo bayabweni. ");
INSERT INTO ndg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Batibaya, “nga yembe mbarikiwa mpwalume yaichile kwa lina Ngwana! Amani kumaunde, ni utukufu kunani!' ");
INSERT INTO ndg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Baadhi ya Mafarisayo katika makutano batikum'bakiya, mwalimu, ubanyamazishe benepunzi bako. ");
INSERT INTO ndg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kayangwa ni kubaya, “nindakuwabakiya, kati haba batituliya, maliwe yapala kombwa malobe.' ");
INSERT INTO ndg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu paaukaribiye mji atiuleliya. ");
INSERT INTO ndg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Atibaya, “Laiti mwatangite hata wenga, katika lichoba lino makowe gagaleta amani! lakini nambeambe yatiya mminyo pako. ");
INSERT INTO ndg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwa kuwa lichoba lindaicha ambapo adui bako apala chenga boma papipi ni wenga, ni kukutindiya ni kukukandamiza boka kila upande. ");
INSERT INTO ndg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bapala kutomboya pae wenga na bana bako. bapala kukuleka kwaa hata liwe limo kunani ya jenge, kwa sababu upala tambwa kwaa wakati Nnongo pabile kapaya kukulopwa!' ");
INSERT INTO ndg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu ajingile muhekalu, atumbwi kuwabenganga balo babile bakipemeya, ");
INSERT INTO ndg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Atikuwabakiya, “Itiandikwa, nyumba yango ipala panga numba ya sala, lakini mwenga muipangite kuwa likolo lya anyang'anyi.' ");
INSERT INTO ndg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kwa nyoo, Yesu abile atipundisha kila lichoba muhekalu, Makuhani akolo ni Alimu ba saliya ni iongozi ba bandu bapalite kumuhukumu. ");
INSERT INTO ndg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lakini wawezite kwaa pata ndela ya panga nyoo, kwa sababu bandu boti babile bakimpekaniya kwa makini. ");
INSERT INTO ndg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lyabile lichoba limo, Yesu abile akipundisha bandu Muhekalu ni hubiri Injili, Makuhani ni Baalimu basheria batikunyendelia pamope ni apendo. Batilongela, bakim'bakiya, ");
INSERT INTO ndg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'Utubakiye ni kwa mamlaka yaa'ko upanga makowe aga? Ama ni nyai agwa ywakupei mamlaka aga?” ");
INSERT INTO ndg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ni ywembe kayangwa, nakuwabakiya,'na nenga nipala kuwalokiya swali, Munibakiye ");
INSERT INTO ndg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ubatizo wa Yohana, Je wabokite kumaunde ama kwa bandu? ");
INSERT INTO ndg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lakini batijadiliana bene kwa bene, nabaya,'Mana tubaite, ubokite kumaunde, apala kutulokiya, bai mbona mumwamini kwaa?' ");
INSERT INTO ndg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ni mana tubaite, uboka kwa bandu, bandu boti pano bapala kutukombwa na maliwe, maana boti baamini kwamba Yohana abile nabii.' ");
INSERT INTO ndg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bai, batiyangwa ya kwamba batangite kwaa kwaibokite, ");
INSERT INTO ndg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu atikuwabakiya, “Wala nenga niwabakiya kwaa mwenga ni kwa mamlaka yaa'ko nipanga makowe aga.” ");
INSERT INTO ndg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Atikuwabakiya bandu mfano wono, “Mundu yumo atipanda nng'unda wa mizabibu, nakulikodisha kwa akolema wa mizabibu, ni yenda kukilambo chenge kwa muda mrefu. ");
INSERT INTO ndg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kwa muda waupangilwe, atatikumlayagi mmanda kwa akolema ba mizabibu, kwamba wampei sehemu ya matunda ya nng'unda wa mizabibu, lakini akolema ba mizabibu batikumkombwa, nakum'buyanganiya maboko yabure. ");
INSERT INTO ndg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Boka po amtumite kae mmanda ywenge na ywaa batikumkombwa, kumpangia ubaya ni kum'buyanganiya maboko yabule. ");
INSERT INTO ndg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Atumilwe kae mmanda wa itatu ni haywo kunnimiya ni kumtaikwa panja. ");
INSERT INTO ndg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nga nyo ngwana wa nng'unda abaite,'Nipange namani? Nipala kumtuma mwana wango mpendwa. Labda bapala kumweshimu.' ");
INSERT INTO ndg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lakini akulima ba mizabibu pamweni, batijadiliana bene kwa bene bakibaya,'haywa nga mrithi, tum'bulage, lenga urithi wake upange witu.' ");
INSERT INTO ndg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bampiite panja na nng'unda wa mizabibu na kum'bulaga, Je ngwana shamba apala kuwapanga namani? ");
INSERT INTO ndg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Apala yenda kubaangamiza akolema ba mizabibu, ni kubapea bengr nng'unda, wolo”. 'nabo pabayowine ago, babaite,'Nnongo aakani' ");
INSERT INTO ndg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lakini Yesu atikuwalola, na baya, Je andiko leno libii na maana yaa'ko? 'lwe labalikani achengi, lipangite liwe la kumbwega? ");
INSERT INTO ndg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kila mundu ywatomboka kunani ya liwe lyoo, atekwanika ipande ipande, lakini yolo latimtombokeya, lendakumlebata ");
INSERT INTO ndg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hivyo Aandishi ni akolo ba Makuhani bapali tendelaya kumboya wakati wowowo, batangite abaite mfano wolo dhidi yabe, lakini babayogopile bandu. ");
INSERT INTO ndg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Balingite kwa makini, nakubatuma apelelezi baipangite kuwa bandu ba haki, lenga bapate likosa kwa hotuba yake, lenga nakumpeleka kwa atawala na bene mamlaka. ");
INSERT INTO ndg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nabo balokite, bakibaya, “mwalimu, tutangite kwamba ubaya na kupundisha makowe ga kweli na shawishi kwaa ni mundu yeyoti, lakini wenga ufundisha kwelu husu ndela ya Nnong. ");
INSERT INTO ndg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Je, ni halali kwetu lepa kodi kwa Kaisari, ama la? ");
INSERT INTO ndg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lakini Yesu atangite mtego wabe, atikuwabakiya, ");
INSERT INTO ndg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Munilage dinari, Minyo ni chapa ya nyai ibile kunani yake? batibaya!”Ya Kaisari.” ");
INSERT INTO ndg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ni ywembe akawabakiya, Bai, mumpei ya Kaisari yagabile yake Kaisari, ni Nnongo yagabile ya Nnongo.' ");
INSERT INTO ndg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aandishi ni akolo ba Makuhani balilendapo uwezo wa kosoa chelo chakibaite nnonge ya bandu, batishangala majibu gake babaite kwaa kilebe. ");
INSERT INTO ndg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Baadhi ya Masukayo bayendeli, balo babaya ntopo ufufuo, ");
INSERT INTO ndg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bakamlokiya, bakibaya,'mwalimu, Musa atikutuyandikiya kwamba mana mundu awelikwe na munage mwene nnyumbowe ntopo mwana bai apalikwa kumtola nnyumbowe nunage ni yenda papa nakwe kwaajili ya kaka bake. ");
INSERT INTO ndg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pabile ni alongo saba wa kwanza atikobeka, na waa bila leka mwana, ");
INSERT INTO ndg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ni ywana ibele pia. ");
INSERT INTO ndg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ywa tatu atikumtola nyanya, nganyonyo boti saba balekite kwaa mwana ni waa. ");
INSERT INTO ndg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Baadaye ni yolo nnwawa ati waa. ");
INSERT INTO ndg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Katika ufufuo, apala panga nyumbo wa nyai? maana boti saba batikumkobeka.' ");
INSERT INTO ndg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu atikuwabakiya, “bana ba kilambo cheno ukobeka na konda. ");
INSERT INTO ndg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Lakini balo babastaili pokiya ufufuo wa kiwo ni jingya muukoti wangayomoka bakobeka kwaa wala kondelwa. ");
INSERT INTO ndg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wala bawecha kwaa waa kae, kwa sababu bala baa sawaswa ni malaika na ni bana ba Nnongo, bana ba ufufuo. ");
INSERT INTO ndg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lakini hayo wafu banafufuliwa, hata Musa atilaya mahali katika habari ya mmwitu, palo atikumkema Ngwana kati Nnongo wa Ibrahimu ni Nngongo wa Isaka ni Nnongo wa Yakobo. ");
INSERT INTO ndg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nambeambe, yembe Nnongo kwaa wa wafu bali wa wabile akoti, kwa sababu boti hiushi kwa ywembe.” ");
INSERT INTO ndg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Baadhi ya baalimu ba sheria batiyangwa, “Mwalimu, uyangwite vema.' ");
INSERT INTO ndg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bateyhubutu kwaa kumlokiya liswali lyenge zaidi. ");
INSERT INTO ndg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu atikuwabakiya,'ki vyaa'ko bandu babaya kwamba Kristo ni mwana wa Daudi? ");
INSERT INTO ndg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maana Daudi mwene abaya katika Zaburi: Ngwana atikumbakiya Ngwana wango: utamae luboko lwa mmaliyo, ");
INSERT INTO ndg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka nibabeke adui zako baye ya magolo gako.' ");
INSERT INTO ndg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daudi amkema Kristo 'Ngwana', bai yapanga kitiwi mwana wa Daudi?” ");
INSERT INTO ndg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bandu boti bababile kabampekaniya batikumbakiya anapunzi bake, ");
INSERT INTO ndg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Jihadhalini ni Aandishi, apenda tanga bawalite mavazi maracho, ni apenda salamu maalumu musoko ni iteo ya heshima Mumasinagogi, ni maeneo ya heshima mukaramu. ");
INSERT INTO ndg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Habo kae uliya munyumba ya ajane, ni kuipanga bandasali, sala ndacho. Haba bapala pokiya hukumu ngolo zaidi.' ");
INSERT INTO ndg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesun atilinga am'bweni analome matajiri, bababile kababika zawadi yabe mu akiba. ");
INSERT INTO ndg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Amweni ywa wilikwe yumo maskini kabika senti yake ibele. ");
INSERT INTO ndg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nga nyo ngabaya kweli wendakuwabakia, hayu ngwelekwa maskini abika yanambone kuliko benge boti. ");
INSERT INTO ndg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Haba boti bapiyite bayi zawadi buka katika yanambone yababile nayo, lakini hayu n'gwelekwa katika umaskini wake, apiyite mbanje yoti yabile nayo kwaajili ya lama kwake,” ");
INSERT INTO ndg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wakati wenge pababile kababaya usu hekalu, namna mwalibile litipambilwe na maliwe yananoga ni matoleo atibaya, ");
INSERT INTO ndg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kwa habari ya makowe aga mwamugabona, machuba gaicha ambayo ntopo liwe limo ambalo lalekelwa panani ya liwe lyinge ambalo lya bomolelwa kaa,” ");
INSERT INTO ndg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nga nyoo, batikunnokia babayite, “Mwalimu, makowe aga gapita lichuba gani? namani yabaa ishara kwamba aga makowe gai karibu pitya. ");
INSERT INTO ndg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ayangwi, “Mube aangalifu kwamba kana mukongelwe, kwa sababu baingi baicha kwa lina lyangu, kababaya Nenga nga naywembe, ni muda utikaribia.'kana muakengame. ");
INSERT INTO ndg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mana muyowine vita ni vurugu vurugu kana mwayogope, kwa sababu aga makowe agapiti kwanza lakini mwisho wapitya kwaa upesi.” ");
INSERT INTO ndg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kai ababakiye, Taifa lakakatuka kumbwana ni taifa lenge, ufalme ni ufalme wenge. ");
INSERT INTO ndg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pabaa ni malendemo makulu, ni njala ni tauni katika maeneo mbalembale bapaa matukio yatisha ni ishara yatisha buka kumaunde. ");
INSERT INTO ndg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lakoni kabla makowe aga goti, babika maboko gabe panani yinuni kubatesa kubapelekanga mu'masinagogi ni mumagereza, kunneta nnongi ya ufalme ni bene mamlaka kwasababu ya lina lyangu. ");
INSERT INTO ndg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ayii ipakunyoghulyanga mwenga nafasi kwa ushuhuda winu. ");
INSERT INTO ndg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kwaiyo muamue mumyoyo yinu aandaa kwaa kwinu mapema, ");
INSERT INTO ndg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwasababu nampea maneno aga hekima, ambago adui zinu boti bawecha kwaa kuipinga au kuikana. ");
INSERT INTO ndg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Lakini mwa kanilwa kae ni azazi binu anunabinu, alongo binu ni mabwiga ni bapakumulaga baadhi yinu. ");
INSERT INTO ndg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mwatolelwa ni kila yumo kwa sababu ya lina lyangu. ");
INSERT INTO ndg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lakini ntopo hata unywi kwaa umo wa mitwe yinu waupala oba. ");
INSERT INTO ndg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Katika vumilia mwaipanga nafsi yinu. ");
INSERT INTO ndg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pampala bona Yerusalemu baitindiike majeshi, basi mutange kwamba ualibifu wake ukalibiye. ");
INSERT INTO ndg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hapo balo babile Yudea babutukii muitumbii, ni balo bababile pakatikati ya jiji babuke, ni kana mwaleke bababile muijiji jingya. ");
INSERT INTO ndg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mana aga nga machuba ga kisasi, linga kwamba makowe goti gagaandikilwe gapate timya. ");
INSERT INTO ndg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ole kwa balo bene ndumbo ni kwa balo babayongeya katika machuba aga! kwa maana pabaa ni tabu nkolo muilambo ni nyongo kwa bandu haba. ");
INSERT INTO ndg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ni batumbuka kwa ncha ya lipanga na batolelwa mateka kwa mataifa goti, ni Yerusalemu yalibatilwa ni bandu ba mataifa, mpaka wakati wa bandu ba mataifa paupala timilika. ");
INSERT INTO ndg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yapanga ni ishara katika liumu, mwei ni ndondwa. Ni katika ilambo papabaa ni dhiki ya mataifa, katika kata tamaa bukana lilobe lya habari ni mawimbi. ");
INSERT INTO ndg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Panga ni bandu kabainduka kwa yogopa ni katika tarajia mambo gagapita duniani. Kwa maana ngupu ya mbingu ya tikwa tikwa. ");
INSERT INTO ndg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nga bamona mwana wa Adamu kaicha kumaunde katika ngupu ni utikufu mkulu. ");
INSERT INTO ndg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lakini makowe aga gapatumbwa pitya muyimee mukakatuye mitwe yinu kwa sababu kombolelwa kwinu kwanda egelwa karibu.” ");
INSERT INTO ndg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu aabakiye kwa mfano, “Muulinge mtini, ni mikongo yoti. ");
INSERT INTO ndg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Paiipuka, mwenda kuiboniya mwabene ni tanga kwamba mpenja tayari ui karibu. ");
INSERT INTO ndg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nyonyo, pamona makowe aga kagapitya mwenga mutange ya kuwa ufalme wa Nnongo utikaribiya. ");
INSERT INTO ndg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kweli, nenda kuwabakiya, ubeleko wuno wapeta kwaa, mpaka mambo aga goti mpaka gapita kwaa. ");
INSERT INTO ndg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kumaunde ni kilambo gapeta, lakini maneno gangu gapita kwaa kabisa. ");
INSERT INTO ndg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Lkini muilinge mwa bene linga kwamba mioyo ginu kana yalemewa ni ufisadi, ulevi, ni mahangaiko ga maisha aga. Kwa sababu lilo lichoba yabaichilya gafula. ");
INSERT INTO ndg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kati ntego, kwa sababu yabaa kwa kila yumo ywaishi katika kuminyo ya kilambo choti. ");
INSERT INTO ndg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lakini mube tayari wakati woti, mulobe kwamba mwaba imara ya kutosha kugaepuka aga goti pagapita, na yima nnongi ya mwana wa Adamu.” ");
INSERT INTO ndg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nga nyo wakati wa mutwekati abile kafundisha muhekalu ni kiloo apitike panja ni yenda keleka katika kitumbi chakikemelwa cha Mizeituni. ");
INSERT INTO ndg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bandu boti bamwichi kwaa kindai na mapema linga kumpikaniya nkati ya hekalu. ");
INSERT INTO ndg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Basi sikuuu ya nkate yangali yiyilwa lola yabile ikaribiye, ambago ikemelwa Pasaka. ");
INSERT INTO ndg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Makuhani akolo ni aandishi bati jadiliana namna ya kumulaga Yesu, kwa sababu baayogwipe bandu. ");
INSERT INTO ndg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nchela ajingii nkati ya Yuda Iskariote, yumo ba balu benepunzi komi ni abele. ");
INSERT INTO ndg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda ayei jadiliana ni akolo ba Mkuhani namna ambavyo abakabizi Yesu kwabe. ");
INSERT INTO ndg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Batipulaika ni yikityana kumpea mbanje. ");
INSERT INTO ndg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ywembe atiyikitya, ni apalae nafasi ya kuakamukiya Yesu kwabe kulipau ni likundi lya bandu. ");
INSERT INTO ndg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lichuba lya mikate yangali yiyilwa lula yaikite, ambapo ngondolo wa Pasaka lazima apiyilwe. ");
INSERT INTO ndg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu awatumite Petro ni Yohana abayite, “Muyende mukatualie chakulya cha Pasaka linga tuiche tulyee.” ");
INSERT INTO ndg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Banokiye “kwako upala tugapangi ago maandalizi?” ");
INSERT INTO ndg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ayangwi, mupikani, pampala jingya mjini mnalome ambaye apotwi kibega sa mase akolyana namwe. Munkingame pene nyumba ambayo ajingya. ");
INSERT INTO ndg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Boka po mummakiye bwana wa nyumba, “Mwalimu akubakiya, ki kwako chumba cha ageni, mahali ambapo nalya pasaka ni benepunzi bango?” ");
INSERT INTO ndg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aalangya chumba cha ghorofa ambacho kibile tayari, mupange maandalizi mwoo. ");
INSERT INTO ndg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nga nyo bayei, ni kolya kila kilebe kati mwabayite, Nga andaa chakulya cha Pasaka. ");
INSERT INTO ndg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Muda pauikite atamii ni balo mitume. ");
INSERT INTO ndg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nga aabakiya nina umu ngolo ya lya sikukuu yii ya Pasaka ni mwenga kabla ya teselwa kwango. ");
INSERT INTO ndg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwa maana nenda kuwabakiya nilya kae mpaka paipatimizwa katika ufalme wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Boka po Yesu atitola kikombe, napayomwile shukuru, ngabaya mutole chei ni mmagane mwenga kwa mwenga. ");
INSERT INTO ndg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kwa maana nenda kuwabakiya ninywaa kwaa kae mzao wa mzabibu, mpaka ufalme wa Nnongo paupalaicha.” ");
INSERT INTO ndg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nga atola nkate ni payomwile shukuru ngaumetwa nkate ni kuapeya ngabaya yinu nga ambayo upiyilwe kwa ajili yinu, mupange nyaa kwa kunikumbukya nenga. ");
INSERT INTO ndg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Atweti kikombe nyonyo baada ya chakulya cha kiloo abayite, “kikombe chii nga lilagano lya yambe. Katika damu yango ambayo ipenganike kwaajili yinu. ");
INSERT INTO ndg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lakini mulinge, Yulo ywanisaliti abile pamope namwe pameza. ");
INSERT INTO ndg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kwa maana mwana wa Adamu wa kweli ayenda zake kati mwaamulikwe. Lakini ole kwa mundu yulo ambaye pitya ywembe mwana wa Adamu asalitiwa!” ");
INSERT INTO ndg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Batumbwi lokiana bene kwa bene nyai miongoni mwabe ywa panga jambo leno. ");
INSERT INTO ndg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kisha wapitike ntau katikati yabe kwamba ni nyai ywatu kitya panga jambo lino. ");
INSERT INTO ndg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aabakiye, “Afalme ba bandu ba mataifa baina ubwana usu bembe, na balo bene mamlaka usu bembe, bakemelwa aheshimiwa atawala. ");
INSERT INTO ndg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lakini ipalikwa kwaa kabisa nyaa kwinu mwenga. Badala yake, lika yulo ambaye nga nkolo kati yinu abe kati nchini. Ni yolo ambaye nga wa muhimu muno abe kati ywatumukya. ");
INSERT INTO ndg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kwasababu ywaku nkolo, yolo ywatama pameza au yolo ywatumika? Buli yolo kwaa ywatama pameza? Ni nenga balo ni kati yinu ywa tumika. ");
INSERT INTO ndg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","30","Lakini mwenga nga ambao muyendelya na nee katika majaribu yango. Nenda kuwapea mwenga ufalme kati nyalo Tati pambeile nenga ufalme, Kwamba mupale lya na nywa pameza yango kwene ufalme wango. Ni mwatamaa kwene iti ya enzi kamuhi hukumu kabila komi ni ibele ya Israeli. ");
INSERT INTO ndg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simoni, Simoni, utange kwamba, nchela alobite abatweti ni abapepete kati ngano. ");
INSERT INTO ndg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lakini natiloba kwaajili yawenga, kuwa imani yako kana ishindilwe. Baada ya ubi ukelebukye kae, waimarishe alongo bako.” ");
INSERT INTO ndg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petro kammakiya, “Ngwana, nibile tayari yendya ni wenga mu'rigereza ni hata nkati ya kiwo,” ");
INSERT INTO ndg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu kanyangwa, “Nakubakiya, Petro, nkoko awikile kwaa lino, kabla ya wenga kunikana mara tatu kati unitangite nenga.” ");
INSERT INTO ndg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Boka po Yesu ngaamakiye, “Niwapelekile mwenga bila mfuko, itondo cha chakulya, au ilatu, je mwapungukilwe ni milebe? Kabayangwa “Ntopo” ");
INSERT INTO ndg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Boka po atikwabakiya, “Lakini, kila ywabile ni mfuko, ni autole pamope ni itondo ya chakulya. Yolo ywabile kwaa ni kyembe impalike auze nganju yake na apeme limo. ");
INSERT INTO ndg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwa mana nendakwabakiya, gote gaandikilwe nnani yango lazima gapangilwe,'Na atolelwa kati mundu ywavunja torati.' Kwa mana chelo chatabililwe nnani yangu chalowa timizwa.” ");
INSERT INTO ndg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Boka po kababaya, “Ngwana. lola! Pabile ni panga ibele pano.”Na atikwabakiwa “Yatosha.” ");
INSERT INTO ndg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Baada ya chakulya sa kitamunyo, Yesu ayei, kati yabile panga kila muda, kayenda kukitombe sa Mizeituni, ni anapunzi bake kabakangama. ");
INSERT INTO ndg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pabaikite, atikwamakiya,'Mulobe kwambe kana muyingii mu'majaribu.” ");
INSERT INTO ndg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ayei mbale ni anapunzi kati patomboka liwe laulwilwe, kapiga magoti ni kuloba, ");
INSERT INTO ndg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","kabaya, “Tate, mana upala, ukiboi chelo kikombe. Lakini kati nipala kwaa nenga, lakini mapenzi gako gapangike.” ");
INSERT INTO ndg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Boka po malaika boka kumaunde atikuntokiya, kampeya ngupu. ");
INSERT INTO ndg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pabile nkati ya minya, kaloba kwa dhati muno, ni liyasho lyake libile kati matone akolo ga mwai yatombwike pae. ");
INSERT INTO ndg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Palo akelebuke boka kuloba kwake, atiisa kwa anapunzi bake, ni kaakuta bagonzike kwa kuwa babile ni huzuni yabe. ");
INSERT INTO ndg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","na kabanaluya, “mwanja namani mwagonzike? Mukelebuke mulobe, kuba kana muyingii mu'majaribu.” ");
INSERT INTO ndg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wakati babile bado batilongela, llinga, kipenga kikolo sa bandu satibuya, ni Yuda, yumo ywa mitume komi ni ibele abile nabo kabaongoza. Kabuya karibu ni Yesu ili kunnoniya, ");
INSERT INTO ndg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","lakini Yesu kammakiya, “Yuda, je watikunsaliti Mwana wa Adamu kwa kunnoniya?” ");
INSERT INTO ndg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wakati balo babile karibu ni Yesu kabalola ago gapangike, kababaya, “Ngwana, je twakombwe kwa kyembe?” ");
INSERT INTO ndg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Boka po yumo kankombwa mmanda ba makuhani akolo, atikunkata likutu lyake la kummalyo. ");
INSERT INTO ndg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu kabaya, “yayosha, ni kankamwa likutu lyake ni kumponiya. ");
INSERT INTO ndg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu kabaya kwa kuhani nkolo, ni kwa akolo ba hekalu, na kwa apindo baisile kinchogo yake, “Je mwaisile kati mwaisi kupambana ni mwii, ni marungu ni mapanga? ");
INSERT INTO ndg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nabile pamope ni mwenga masoba gote mu'hekalu, muwekite kwaa maboko ginu nnani yango. Lakini yeno nga saa yako, ni mamlaka ga lubendo.” ");
INSERT INTO ndg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kabantaba, ni kunkengama, kabanneta mu'nyumba ya kuhani nkolo. Lakini Petro atikuakengama kwa mbale. ");
INSERT INTO ndg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baada ya kuba bawashile mwoto mu'wolo uwanda wa ndani ni pabaikite batami pae pamope, Petro abile nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mmanda yumo nnawa amweni Petro atami mu'bwee ubuyite mu mwoto, kanlola ni kummakiya, “Ayoo mundu abile pamope ni ywembe.” ");
INSERT INTO ndg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lakini Petro kankana, kabaya, “wa nnwawa, nenga nintangite kwaa.” ");
INSERT INTO ndg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Baada ya muda nchunu, mundu ywenge amweni no baya, “Wenga kae ni yumo nkati yabe.” Ila Petro kannyangwa, “Wa nnalome, nenga kwaa.” ");
INSERT INTO ndg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bada ya kati lisaa limo, nnalome yumo atikwasisitiza kabaya, “Kweli kabisa ayoo mundu abile pamope ni ywembe, maana nga Mgalilaya. ");
INSERT INTO ndg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lakini Petro kabaya, “Nnalome ndangite kwaa lya ulibaya.” ni mara wakati atilongela, ngoko ngaabeka. ");
INSERT INTO ndg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kakelebuka, Ngwana kanlola Petro. Ni Petro akombokii neno lya Ngwana, palo atikumbakiya, “Kabla jogolo ngaweka leno, walowa kunikana nenga mara itatu.” ");
INSERT INTO ndg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kayenda panja, Petro kalela kwa minya muno. ");
INSERT INTO ndg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Boka po balo analome babile bakinlinda Yesu, kaban'geya ni kunkombwa. ");
INSERT INTO ndg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Baada ya kumfunika minyo, kabannaluya, kabakoya, “Tabiri! Nyai ywakukombwile? ");
INSERT INTO ndg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kabalongela makowe yenge ganansima nchogo sa Yesu ni kumkupuru ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Paikite kindae, apindo ga bandu bakusanyite pamoper, akolo ba makuhani ni baandishi. Batikumpeleka nnonge ya Baraza, ");
INSERT INTO ndg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","kababaya, “Kati wenga wa Kristo, tubakiye.”Lakini ywembe kaamakiya, “Mana niamakiye, muniamini kwaa, ");
INSERT INTO ndg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na kati natikuanaluya muyangwa kwaa.” ");
INSERT INTO ndg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lakini boka saa yino ni yendelya, Mwana wa Adamu abile atami luboko lwa mmalyo wa ngupu ya Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bote kababaya, “Kwa eyo wenga wa Mwana wa Nnongo?” Ni Yesu kaayangwa, “Mwenga mwabaya nga nenga.” ");
INSERT INTO ndg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kababaya, “Mwanja namani kae tupala ushahidi? Kwamana twenga twabene tuyowine boka mu'nkano wake mwene.” ");
INSERT INTO ndg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kipenga soti sayemi, kabampeleka Yesu nnongi ya Pilato. ");
INSERT INTO ndg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kabatumbwa kunshutumu, kababaya, “Twankutike mundu yolo atilipotosha taifa litu, kwa kuabakiya bandu baneke kutoa kodi kwa kaisari, no baya kuwa ywembe mwene nga Kristo, Mpwalume.” ");
INSERT INTO ndg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato kannaluya, no baya, “Je wenga nga mpwalume ba Ayahudi? Ni Yesu kanyangwa no baya, “Wenga wabaya nyoo.” ");
INSERT INTO ndg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato kammakiya kuhani nkolo ni kipenga sa bandu.”Nibona kwaa likosa lya mundu yolo.” ");
INSERT INTO ndg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lakini balo batikunsisitiza, kababaya, “Abile akiachochea bandu, atikwapundisha mu'Uyahudi woti, boka Galilaya ni saa yeno abile pano.” ");
INSERT INTO ndg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato ayowine ago, kayangwa kati mundu ywoo ni a'Galilaya? ");
INSERT INTO ndg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pabaatangite kuwa abile pae ya utawala wa Herode, atikumpeleka Yesu kwa Herode, ywabile niywembe ywabile Yerusalemu kwa masoba ago. ");
INSERT INTO ndg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herode paamweni Yesu, atipulaika muno kwamana apalike kumwona kwa masoba ganansima. Ayowine habari za ywembe, ni atamaniye kubona yumo ywamuujiza wapangilwe ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herode kannaluya Yesu kwa maneno ganansima, lakini Yesu kannyangwa kwaa chochote. ");
INSERT INTO ndg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Makuhani akolo pamope ni baandishi bayemi kwa ukali kabanshitaki. ");
INSERT INTO ndg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herode pamope nia askari bake, kabantukana ni kun'geya, ni kummwika ngobo nzuri, boka po atikunrudisha Yesu kwa Pilato. ");
INSERT INTO ndg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herode ni Pilato babile mbwiga boka lisoba lelo, (kabla ya ago babile maadui) ");
INSERT INTO ndg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato kabakema pamope makuhani akolo ni atawala ni kipenga sa bandu, ");
INSERT INTO ndg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kabaakokeya, “Mwaniletii mundu yoo kati mundu ywaongoza bandu bapange abaya, no linga, baada ya kuba ninnaluye nnonge yinu, nibona kwaa likosa kwa mundu yoo husu makowe gote ambago mwenga mwamshitaki ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hapana, Herode kwaa, mana ambuyanganiye kwitu, ni linga ntopo chochote chaakipangite chaastahili adhabu ya waa. ");
INSERT INTO ndg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kwa eyo npala kumwadhibu ni kunneka. ");
INSERT INTO ndg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Pilato atiwajibika kunneka mfungwa yuno kwa Ayahudi wakati wa sikukuu) ");
INSERT INTO ndg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lakini bote bakombwi lilobe lyampamo, bakibaya, “Mmulage yoo, ni kunneka Baraba!” ");
INSERT INTO ndg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba abile mundu ywatabilwe mu'ligereza kwa sababu ya ubou pulani nkati ya ijiji na kubulaga. ");
INSERT INTO ndg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato kaabakiya kae, atamaniye kunneka Yesu. ");
INSERT INTO ndg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lakini bembe bakombwi lilobe, babaya, “Mmulage, mmulage.” ");
INSERT INTO ndg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kabanaluya kwa mara ye itatu, “mwanja namani, mundu yoo, apangite baya lya namani? mbatike kwaa likosa lyastahili adhabu yo kiwo kwa ywembe. Kwa eyo mana niyomwile kumwadhibu nalowa kunneka.” ");
INSERT INTO ndg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lakini kabasisitiza kwa lilobe lya kunani, baloba asulubilwe. Ni lilobe lyao lyatikunshawishi Pilato. ");
INSERT INTO ndg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nga nyo Pilato atiamua kuwapeya kati kabapala. ");
INSERT INTO ndg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kanneka yolo ywampala ywabile atabilwe kwa kupanga ghasia ni kubulaga. Lakini atikuntoa Yesu kati kabapala bembe. ");
INSERT INTO ndg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pabannyongoli no yendya, bakwembine ni mundu yumo ywakemilwe Simoni ba Ukirene, kaboka mu'kilambo, kabampeya msalaba apotwi, kunkengama Yesu. ");
INSERT INTO ndg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kipenga kikolo sa bandu, ni annwawa babile batihuzunika no kwomboleza kwaajili ya ywembe, babile batikunkengama. ");
INSERT INTO ndg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lakini atikubakelebukia, Yesu no kuabakiya,'Mwannwawa ba Yerusalemu, kana mulele kwaajili yango, ila mulele kwaajili yinu bene ni kwaajili ya bana binu. ");
INSERT INTO ndg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Linga, masoba gaisa ambazo balowa baya, “Watibarikilwa balyo agumba ni ndumbo yange beleka, ni mabele yangenyonyesha. ");
INSERT INTO ndg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nga kabatumbwa kuikokeya itombe, “Mututombokii,'na itombe,'Itufunike.' ");
INSERT INTO ndg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mana kati bapangite makowe aga kwa nkongo mbichi, ipalika kwaa wo'ubile nkavu?” ");
INSERT INTO ndg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Analome wenge, aharibifu abele, batipelekwa pamope ni ywembe ili kababulagilwe. ");
INSERT INTO ndg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pabaikite mahali pakemelwage Livufu lya ntwe, nga kabansulubisha pamope ni balo aharibifu, yumo upande wa kummalyo ni ywenge upande wenge. ");
INSERT INTO ndg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu kabaya, “Tate, ubasamei, kwa mana payowa kwaa bapanga namani.”Bembe bapiyite kura, kutaikulya nganju yake. ");
INSERT INTO ndg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bandu babile bayemi kabalola ni atawala kaban'geya, kababaya, “Uwalopolile benge. Nga ujilopwe wa mwene, kati wenga wa Kristo wa Nnongo, uchaulilwe.” ");
INSERT INTO ndg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ni akari kabandharau, kabankaribia ywembe ni kumpea siki, ");
INSERT INTO ndg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kababaya, “Kati wenga wa Mpwalume ba Ayahudi jilopwe wa mwene.” ");
INSERT INTO ndg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pabile ni alama nnani yake yaiyandikilwe, “AYOO NGA MPWALUME AYAHUDI.” ");
INSERT INTO ndg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumo nkati ya baarifu balo basulubilwe atikuntukana kabaya, “Wenga wa Kristo kwaa? jilopwe wa mwene ni twenga” ");
INSERT INTO ndg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lakini yolo ywenge kayan'yangwa, atikunkemya no baya, “Je wenga wamwishimu kwaa Nnongo, ni ywembe ubile mu'hukumu yeyelo? ");
INSERT INTO ndg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Twenga twabile pano kwa haki, kwa mana twenga twapoki chelo twastahili kwaajili ya makowe yitu. Lakini mundu yoo apangite kwaa chochote kibaya.” ");
INSERT INTO ndg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Atiyongeyekeya, “Yesu nikumbuke nenga mana uyingii mu'upwalume wako.” ");
INSERT INTO ndg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu kaankokeya, “Amini nendakumakiya, leno walowa tama pamope ni nenga mu'Paradiso.” ");
INSERT INTO ndg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Muda woo yabile karibu lisaa lya sita, libendo lyaisa nnani ya nchi yote mpaka saa yo tisa, ");
INSERT INTO ndg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bwee wa liumu wateyima. Boka po pazia lya mu'hekalu latipapwanika nkati boka kunani. ");
INSERT INTO ndg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kalela kwa lilobe likolo, “Tate umaboko gako nibeka roho yango,” baada yabaya nyoo, awile. ");
INSERT INTO ndg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Muda woo akida abweni galo gatendike atikuntukuza Nnongo kabaya, “Hakika ayoo abile mundu mwene haki.” ");
INSERT INTO ndg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wakati woo kipenga sa bandu balo bayei mpamo shuhudia makowe gapangilwe, babuyangine kabakombwa ifua yabe. ");
INSERT INTO ndg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lakini mbwiga bake, ni alwawa balo bankengame boka Galilaya, bayemite kwa mbale kabalola makowe ago. ");
INSERT INTO ndg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Linga pabile ni mundu ywakemelwa Ysufu, ywabile yumo wa baraza, mundu nzuri ni mwene haki, ");
INSERT INTO ndg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(abile akubaliana kwaa ni maamuzi au makowe ago), boka Armathaya, ijiji sa Uyahudi, wabile utisubiri upwalume wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mundu yoo, akwembine ni Pilato, kaloba atole bwega wa Yesu. ");
INSERT INTO ndg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kantombwa, ni kumwalisha sanda, ni kam'beka mu, likaburi lyabile lyatichongwa mu'liwe, lyabile ntopo mundu asikilwe nkati yake. ");
INSERT INTO ndg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lyabile lisiku lya maandalizi, ni sabato yabile karibu. ");
INSERT INTO ndg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Alwawa, baisile nakwe boka Galilaya, batikunkengama, ni babweni likaburi ni mwanja bwega wake waugonjike. ");
INSERT INTO ndg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kababuyangana ni tumbwa andaa manukato ni marashi. Boka po lisiku lya sabato kabapunzika lingana na saliya. ");
INSERT INTO ndg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mapema muno lisiku lya kwanza laya wiki, baisile mu'likaburi, kabaleta manukato yalowa kumwandaliya. ");
INSERT INTO ndg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kabalola liwe latigalambulilwa mbali ni likaburi. ");
INSERT INTO ndg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kabayingii nkati, lakini baukwembite kwaa bwega wa Ngwana Yesu. ");
INSERT INTO ndg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yapangite kwamba, wakati kabasangala kuhusu chelo, ghafla, bandu abele bayemi nkati yabe bawalike ngobo ga'ng'ara muno. ");
INSERT INTO ndg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Alwawa babile ni hofu muno ni kabaunika minyo gabe pae, kababakiya balo alwawa, “Mwanja namani mwampala yolo ywabile nkoti nkati ya babile mu'kiwo? ");
INSERT INTO ndg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Abile kwaa pano, ila atiyoka! mkumbukye chelo akibaya ni mwenga mu'Galilaya, ");
INSERT INTO ndg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","kabaya kwamba Mwana wa Adamu lazima alekwilwe mu'maboko ga bandu babile ni sambi ni asulubilwe, ni siku ye itatu, alowa yoka kae.” ");
INSERT INTO ndg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Balo alwawa bakomboki maneno gake, ");
INSERT INTO ndg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","na kababuyangana boka mulikaburi na kabakokeya makowe aga goti balo komi ni yimo benge bote. ");
INSERT INTO ndg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bai Maria Magdalena, Joana, Maria mao ba Yakobo, ni alwawa wenge mpamo batitangaza makowe aga kwa mitume. ");
INSERT INTO ndg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lakini abari yee yatibonekine kati mzaha tu kwa mitume, ni kababaamini kwaa balo alwawa. ");
INSERT INTO ndg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hata nyoo Petro atiyumuka kuyendya mulikaburi, na chungulya ni kulola nkati yake, abweni sanda kichake. Petro kaboka kuyenda munyumba yake, atishangala chelo chabile chakipangike. ");
INSERT INTO ndg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Linga, abele nkati yabe babile kabayenda lisoba lyoo muijiji chimo chakemelwa Emmau, chabile maili sitini boka Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kabajadiliana bene kwa bene kuhusu makowe goti gapangite. ");
INSERT INTO ndg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yapetike kwamba, wakati babile bakijadiliana ni kunaluyana bene maswali, Yesu kaisa karibu kabakengama nakwe. ");
INSERT INTO ndg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lakini minyo gabe kabanlola kwaa y6ange kuntambwa ywembe. ");
INSERT INTO ndg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu kabakokeya, “Namani ambacho mwenga abele mwatilongela kamuyenda?” Bayemi palo kababonekine babile ni huzuni. ");
INSERT INTO ndg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yumo kati yabe, lina lyake Cleopa, kayangwa, “Je wenga wa nyai mwene pano Yerusalemu uyowine kwaa makowe gapangike masoba aga?” ");
INSERT INTO ndg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu kammakiya, “Makowe gani?” Kabanyangwa, “Makowe husu Yesu ywa Nazareti, ywabile nabii, muweza mu'matendo ni maneno nnongi ya Nnongo ni bandu bote. ");
INSERT INTO ndg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ni kwa namna ambayo akolo ba Makuhani ni Iongozi bitu banlekile hukumilwa kiwo ni kunsulubisha. ");
INSERT INTO ndg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Lakini twatitamani kwamba ywembe nga atikuibeka huru Israeli. Eloo, mbale ni aga goti, muda ni lisoba lya tatu boka makowe aga gapangilwe. ");
INSERT INTO ndg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lakini pia, baadhi ya alwawa boka mu'likundi litu batitushangaza, baada yo yenda mulikaburi kindai ni mapema. ");
INSERT INTO ndg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kabaukosite bwega wake, kababuya, kababaya kwamba babweni malaika babayite yu nkoti. ");
INSERT INTO ndg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Baadhi ya analome ambao babile mpamo natwenga kabayenda mulikaburi, ni kukuta ni kati balo alwawa kababaya. Lakini bamweni kwaa ywembe.” ");
INSERT INTO ndg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu kaabakiya, “Mwenga mwa bandu bajinga ni mubile ni mioyo mizito ya kuamini yote ambago manabii babayite! ");
INSERT INTO ndg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Je ipalike kwaa lazima Yesu kuteseka kwa makowe aga, ni kuyingya mu'utukupu wake?” ");
INSERT INTO ndg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Boka kwa Musa ni manabii woti, Yesu atikwatafsiriya makowe gamuhusu ywembe mu'maandiki yote. ");
INSERT INTO ndg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Batikaribia chelo ijiji, huko kababile kabayenda, Yesu kapanga kati kwamba atiyendelya nnonge. ");
INSERT INTO ndg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lakini kabanlazimisha, kababaya, “Tama pamope nitwenga, mana ielekile mukitamunyo na lisoba lya kati lyaishile.”Nga nyo Yesu kayingi yenda tama nakwe. ");
INSERT INTO ndg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yaipangite kwamba, muda atama nakwe kalya, atitola nkate, atiubariki, ni kuutekwana, kawapea. ");
INSERT INTO ndg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Boka po minyo gabe ngabakelebeka, kabantanga, ni kaboka gafla nnongi ya minyo gabe. ");
INSERT INTO ndg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kabalongela bene kwa bene, mu'atilongela natwenga mundela, muda atiyogolya maandiko?” ");
INSERT INTO ndg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kabanyanyuka saa yeyelo, ni kubuyangana Yerusalemu. Kabakwembana balo komi ni jimo kabakusanyilwe mpamo, ni balo babile mpamo nakwe, ");
INSERT INTO ndg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kababaya, “Ngwana atiyoka kwelikweli, ni kanlokiya Simoni.” ");
INSERT INTO ndg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nga nyoo kabamakiya makowe gapangilwe mundela, na namna Yesu atikujidhihirisha kwabe ni kuutekwana nkate. ");
INSERT INTO ndg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Muda kabalongela makowe ago, Yesu mwene ayemi nkati yabe, ni kammakiya, “Amani ibile kwinu.” ");
INSERT INTO ndg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lakini batiyogopa ni kuba ni hofu ngolo, ni kabawaza kwamba baibweni roho. ");
INSERT INTO ndg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu kabakokeya, kwa mwanja namani mwatifazaika? ");
INSERT INTO ndg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mwanja namani maswali gayoka mumyoyo yinu? Mulinge maboko gangu ni magolo gango, kwamba nenga namwene. Muniguse ni mulole. kwa mana roho yabile kwaa ni mifupa wala nyama, kati mwanibweni nenga nibile.” ");
INSERT INTO ndg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ayomwile baya nyoo, atikwabonikiya maboko gake ni magolo gabe. ");
INSERT INTO ndg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pababile bado ni puraika yayanganikilwe ni yange aminiya, ni kushangala, Yesu kabakokiya, “Je mubile ni kilebe chochoti chakulya?” ");
INSERT INTO ndg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kabampei ipande ya nkate ni omba asomwile. ");
INSERT INTO ndg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesu katola, ni kulya nnongi yabe. ");
INSERT INTO ndg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Atikum'bakiya, “Nabile ni mwenga, natikuabakiyanga kuwa goti gaandikilwe mu saliya ya Musa ni manabii ni Zaburi lazima gapangike. ");
INSERT INTO ndg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Boka po kabayogoli malango gabe, kuwa baweze kugaelewa maandiko. ");
INSERT INTO ndg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kaabakiya, “Kuwa iandikilwe, Kristo lazima ateseke, ni kuyoka kae boka mu'kiwo lisoba lya itatu. ");
INSERT INTO ndg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na Toba ni msamaha wa sambi lazima ihubirilwe kwa lina lyake kwa mataifa gote, boka Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ni mwenga mwamashahidi ga makowea ga. ");
INSERT INTO ndg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mulinge niakuapeya ahadi ga Tate bango nnani yinu. Lakini mwisubiri pano muijiji, mpaka palo mwamuwalikwa ngupu boka kunani. ");
INSERT INTO ndg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu kabakengama panja mpaka pabakaribie Bethania. Atiinua maboko gake kunani, ni kuabariki. ");
INSERT INTO ndg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Yapangite kuwa, muda waabile atikwabariki, atikuaneka ni kutolelwa kuamaunde. ");
INSERT INTO ndg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bai kabamwabudu, ni kubuya Yerusalemu ni puraha ngolo. ");
INSERT INTO ndg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kabayendelya tama muhekalu, kabambariki Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kiogo sa kale pabile ni neno, ni ywa neno abile pamope ni Nnongo, nga ywa Neno abile Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aywoo, Neno, palyo kinchogo abile pamope ni Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ilebe yoti gatipangilwa petya ywembe, mana ntopo ywembe chalowa pangika kwaa hata kilebe chimo. ");
INSERT INTO ndg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nkati yake ngaubile ukoti, ni wolo ukoti wabile bweya ya bandu boti. ");
INSERT INTO ndg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bweya yating'ala mulubendo, wala lubendo lwaloweza kwaa kwiima. ");
INSERT INTO ndg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pabile ni mundu ywatumilwe kuoma kwa Nnongo, lina lyake akemelwa Yohana. ");
INSERT INTO ndg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ywaisile kati shaidi woshuhudia husu yelo bweya, ili bote baweze amini petya ywembe. ");
INSERT INTO ndg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana abile kwaa yelo bweya, ila aisile ili shuhudia husu yelo bweya. ");
INSERT INTO ndg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Eyo yabile bweya ya kweli yabile yaisa mu'dunia niyembe yampea bweya kila yumo. ");
INSERT INTO ndg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Abile mu'dunia, ni dunia iumbilwe petya ywembe, ni dunia yantangite kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aisile kwa ilebe yake, ni bandu bake bampokya kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ila kwa balo baingi babampokile, balo baamini lina lyake, kwa balo kabapeya haki ya kuwa bana ba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bababelekilwe, kwa mwai kwaa, wala kwa mapenzi ga yega, wala kwa mapenzi ga mundu, ila kwa Nnongo mwene. ");
INSERT INTO ndg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ni ywembe Neno apangilwe yega ni tama nkati yitu, tuubweni utukufu wake, kati utukufu wa mundu kichake wa kipekee ywabile kuoma kwa Tate, atwelile neema ni kweli. ");
INSERT INTO ndg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana atishuhudia husu ywembe, ni akoiye kwa lilobe kabaya, “Ayoo nga ywembe nimmakiye habari yake nibayite, “Yolo ywaisa baada yango nga nkolo kuliko nenga, kwa maana abile kabla yango.” ");
INSERT INTO ndg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kwa mana kuoma mu'utimilifu wake, twenga twaboti, twapoki bure ipawa baada ya ipawa. ");
INSERT INTO ndg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwa mana saliya yatiisa petya Musa. Neema ni kweli yaisile petya Yesu Kristu. ");
INSERT INTO ndg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ntopo mundu ywamwonile Nnongo muda wowoti. Mundu pekee ywabile nga Nnongo, abile mu'kifua sa Tate, apangite ywembe ayowanike. ");
INSERT INTO ndg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Awoo nga ushuhuda ba Yohana palyo makuhani ni alawi bantumilwe kwake ni Ayahudi kubamwuliza.”Wenga wa nyai?” ");
INSERT INTO ndg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bila kusitasita ni kakana kwaa, ila kaayangwa, “Nenga na Kristo kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eyo kabannokiya, “kwa eyo wenga wanyai? wenga wa Eliya?” Kabaya, “Nenga kwaa” Kababaya, “Wenga wa nabii?” Kayangwa, “Hapana.” ");
INSERT INTO ndg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Boka po kabammakiya, “Wenga wa nyai, ili tubapei jibu balo batutumile?” Kabaujishuhudie kwaa wenga wa mwene?” ");
INSERT INTO ndg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kabaya, “Nenga nga lilobe lyake ywabile mmwitu:'Mwinyoshe ndela ya Ngwana,'kati nabii Isaya abayite.” ");
INSERT INTO ndg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bai pabile ni bandu batumilwe palyo kuoma kwa Mafarisayo. Kabannobiya no baya, ");
INSERT INTO ndg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Kwa mwanja namani wabatiza bai kati wenga wa Kristo kwaa wala Eliya wala nabii?” ");
INSERT INTO ndg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana kaayangwa kabaya, “Nabatiza kwa mase, Hata nyoo, nkati yinu atiyema mundu muntangite kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aywoo nga aisa baada yango, Nenga nastahili kwaa kuilegeza gidamu ya ilatu yake.” ");
INSERT INTO ndg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Makowe aga gapangike Bethania, ng'ambo ya Yordani, pandu Yohana abile atibabatiza bandu. ");
INSERT INTO ndg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lisoba lya naibele Yohana amweni Yesu aisa kwake kabaya, “Linga mwana ngondolo wa Nnongo ywaitola sambi ya dunia! ");
INSERT INTO ndg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aywoo nga ywembe ywa nilongela makowe gake natibaya, “Ywembe ywaisa kunchogo kwango nga nkolo kuliko nenga, kwa mana abile kabla yango.' ");
INSERT INTO ndg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hata nenga nintangite kwaa ywembe, lakini ipangilwe nyoo ili aitambulishe mu'Israeli, naisile kwabatiza kwa mase.” ");
INSERT INTO ndg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohana atishuhudia, “Namweni Roho kuoma kumaunde mpwano wa ua, ni abile nnani yake. ");
INSERT INTO ndg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nenga nintangite kwaa lakini ywembe ywanitumile ili niabatize kwa mase anibakiye,'yolo ywabile lola Roho kauluka no tama nnani yake, Aywoo nga aabatiza kwa Roho Mtakatifu.' ");
INSERT INTO ndg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Namweni na kumshuhudia yolo nga Mwana wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kae lisoba lyanaibele Yohana ayemi pamope ni anapunzi bake abele, ");
INSERT INTO ndg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","bamweni Yesu katyanga ni Yohana kabaya, “Linga mwana ngondolo wa Nnongo!” ");
INSERT INTO ndg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Anapunzi abele kaban'yowa Yohana kabaya aga kaban'yangwa Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kae Yesu atikelebuka ni kuabona anapunzi balo bakinkengama, ni kabammakiya, “Mwapala namani? Kaban'yangwa, “Rabbi, (maana yake 'mwalimu,' utama kwaako?” ");
INSERT INTO ndg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kaabakiya, “Muiche na mubweni, “Boka po kabayenda ni kubona pandu abile akitama, batitama pamope naywembe lisoba lelo, kwa mana ibile kati saa komi. ");
INSERT INTO ndg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yumo nkati ya balo abele kaban'yowa Yohana kalongela ni boka po kankengama Yesu abile Andrea, nnuna wake Simoni Petro. ");
INSERT INTO ndg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Amweni nnongo bake Simoni ni kummakiya, “Tumweni masihi” (maana yake Kristo) ");
INSERT INTO ndg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Atikunneta kwa Yesu. Yesu atikunlola ni kubaya, “Wenga wa Simoni mwana wa Yohana “wakemilwe Kefa,” (maana yake 'Petro') ");
INSERT INTO ndg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lisoba lya isile palyo Yesu kabapala kuboka kuyendya Galilaya, ampatike Filipo no kum'bakiya, “Ngengame nenga.” ");
INSERT INTO ndg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo ywabile mwenyeji wa Bethsaida mji wa Andrea ni Petro. ");
INSERT INTO ndg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo ampatike Nathanaeli ni kummakiya, Tuweni yolo ywaandikilwe habari zake mu saliya ya manabii. Yesu mwana wa Yusufu, kuoma Nazareti. ");
INSERT INTO ndg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanieli kammakiya, “Je kilebe kinoite chalowa boka Nazareti?” Filipo kammakiya, Uiche ni ubone.” ");
INSERT INTO ndg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu amweni Nathanieli kaisa kwake nobaya, “Linga, mwisaeli ywa kweli abile kwaa ni ubocho nkati yake! ");
INSERT INTO ndg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanieli kammakiya “Unitangite kwaa nenga?” Yesu kayangwa ni kummakiya, “Kabla Filipo akukema kwaa paubile pae ya mtini, natikubona.” ");
INSERT INTO ndg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanieli kayangwa, “Rabbi wenga wa mwana wa Nnongo! wenga wa mpwalume wa Israeli”! ");
INSERT INTO ndg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu kayangwa ni kummakiya, kwa mana nikumakiye,'natikubona pae ya mtini' je waamini? walowa bona makowe makolo kuliko aga.” ");
INSERT INTO ndg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu kabaya, Amini amini naabakiya mwalowa kubona maunde gayongolilwe, ni kubona malaika kabaoboka ni uluka nnani ya mwana wa Adamu.” ");
INSERT INTO ndg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Baada ya lisoba lya itatu, pabile ni arusi kolyo Kana ya Galilaya ni mao bake Yesu abile kolyo. ");
INSERT INTO ndg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu ni anapunzi bake babile kabakokwa mu'arusi. ");
INSERT INTO ndg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Palyo gayomwi divai, mao bake yesu kammakiya, “Babile kwaa ni divai.” ");
INSERT INTO ndg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu kanyangwa, “Nwawa yoo inihusu namani nenga? muda wango nenga bado timiya.” ");
INSERT INTO ndg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mao bake kaamakiya atumishi, “Mupange chochote chaamakiye.” ");
INSERT INTO ndg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bai pabile ni mitungi sita ya maliwe palo yatibekwa kwaajili ya tawadha mu'sikukuu ya Ayahudi, kila limo lyabile ni ujazo wa nzio ibele itatu. ");
INSERT INTO ndg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu kaamakiya, “Mutweleye mase mumitungi ya maliwe.” Kabatweliya mpaka nnani. ");
INSERT INTO ndg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Boka po kaabakiya balo atumishi, “Mutole kiasi nambeambe ni mwipeleki kwa mhudumu nkolo ywa mesa.” Bapangite kati kabalagilwa. ");
INSERT INTO ndg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ywa mhudumu nkolo paagayite galo mase gabile gagapangilwe divai, ila atangite kwaa chapangilwe (Lakini atumishi baletike mase batangite goti gapangike). Boka po kankema ngwana arusi ni ");
INSERT INTO ndg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kummakiya, “Kila yumo huanza ni divai inoyite ni baada ya nyaa nga kubapea divai inoite kwaa. Lakini wenga utikwitunza divai inoite mpaka nambeambe. ");
INSERT INTO ndg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Muujiza woo wa Kana ya Galialaya, wabile nga mwanzo ya ishara ya miujiza yaaipangite Yesu, atikuupunua utukufu wake, nga banapunzi bake kabamwamini. ");
INSERT INTO ndg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Baada ya yee, Yesu, mao bake, alongo bake ni anapunzi bake kabayenda mu nnema wa Kapernaum ni tama kwoo kwa masoba gachene. ");
INSERT INTO ndg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Bai Pasaka ya Bayahudi yabile itikaribia, kwa eyo Yesu kayenda Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kababweni bandu kabapemea ng'ombe, ngondolo ni ngunda nkati ya Hekalu. Ni badilishana mbanje babile batama nkati ya Hekalu. ");
INSERT INTO ndg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu apangite mjeredi waubile ni ifundo, ababoite boti babile mu'lihekalu, mpamo ni ng'ombe ni ngondolo. Katomboya mbanje ya baabadili mbanje ni kuipindua mesa yabe. ");
INSERT INTO ndg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kwa bapemea ngunda kaamakiya, “Muiboye ilebe yee kutalu ni pano, muleke kwipanga nyumba ya Tate bangu kati pandu palisoko.” ");
INSERT INTO ndg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Anapunzi bake kabakombokya panga yabile iandikilwe, “Bwigu wa nyumba yako upani lyaa.” ");
INSERT INTO ndg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Akolo ba Kiyahudi kabayangwa, kabammakiya, Ni saliya gani ywalowa kwiobenekeya kwa mana ugapanga makowe aga?” ");
INSERT INTO ndg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kabayangwa, mlitekwane Hekalu lee ni nenga nalowa kulichenga baada ya masoba atatu.” ");
INSERT INTO ndg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Boka po akolo ba Ayahudi kababaya, “Itigarimu miaka arobaini na sita kulichenga hekalu lee ni wenga wabaya upala kulichenga kwa masoba gatatu? ");
INSERT INTO ndg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ila, ywembe abayite hekalu kamaanisha yega yake. ");
INSERT INTO ndg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Baadae baada ya kuyoka kwake mu kiwo, anapunzi bake kabakombokya kuwa abayite nyoo, kabaamini maandiko ni longelo lee lyabayilwe tayari ni Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bai paabile Yerusalemu muda wa Pasaka, muda wa sikukuu bandu baingi batiamini lina lyake, bapabweni ishara ga miujiza aipangite. ");
INSERT INTO ndg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lakini Yesu abile kwaa ni imani nabo mana abatangite bandu boti. ");
INSERT INTO ndg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Atimuhitaji kwaa mundu yoyoti kummakiya husu ya babile bandu kwa mana atangite chabile nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Abile Farisayo ywakemilwe lina lyake Nikodemo, yumo ya ajumbe ba baraza lya Ayahudi. ");
INSERT INTO ndg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mundu yoo atin'yendya Ngwana Yesu kilo ni kummakiya”Rabi, tutangite kuwa u mwalimu kuoma kwa Nnongo, kwa mana ntopo mundu ywaweza panga ishara zeno zoti abile pamope ni Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu kayangwa, “Amini, amini, mundu aweza kwaa jingya mu'upwalume wa Nnongo mana abelekwile kwaa mara ya ibele.” ");
INSERT INTO ndg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo kabaya, “Mundu awesa kinamani belekwa muda abile mpindo? Aweza kwaa jingya mu'ndumbo lya mao bake mara ya na'ibele ni belekwa, je ywaweza? ");
INSERT INTO ndg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kan'yangwa, “Amini amini mundu ywa abelekwile kwaa mu'mase ni kwa Roho, aweza kwaa jingya mu'upwalume wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Chabile belekwa ni yega nga yega, na chabelekwile ni Roho nga roho. ");
INSERT INTO ndg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kana ushangae kwa mana natikukumakiya,'lazima kubelekwa mara ya ibele.' ");
INSERT INTO ndg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mbepo ipuma popoti paupendile ni lilobe lyake mwaiyowa, lakini mtangite kwaa pa'ubokile wala kwouyenda. Nga ibile hali ya kila ywabelekwile ni Roho. ");
INSERT INTO ndg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo kayangwa, no baya, “Makowe aga gapangika kinamani? ");
INSERT INTO ndg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kannyangwa, “Wenga wa mwalimu wa Israeli, hata ugatangite kwaa makowe aga? ");
INSERT INTO ndg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Amini, amini nakumakiya, chelo tukiyowine twaishuhudia kwa chelo twakibweni. Lakini upokea kwaa ushuhuda witu. ");
INSERT INTO ndg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kati niabakiye makowe ya pano pa'nnema ni mwamini kwaa, muwesa kinamani kuamini kati natikuabakiya makowe ga kumaunde? ");
INSERT INTO ndg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mana ntopo ywapanda nnani kuoma kumaunde ila ywembe ywauluka, mwana wa Adamu. ");
INSERT INTO ndg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kati Musa mwaankakatuye nngambo mulijangwa, nyonyo Mwana wa Adamu lazima akakatuyilwe, ");
INSERT INTO ndg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ili bote balowa kumwamini bapate ukoti wangayomoka. ");
INSERT INTO ndg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwa mana nga namna yee Nnongo aipendile dunia, kam'boywa mwana wake wa pekee, ili mundu yeyoti ywamwamini kana aangamiye ila abe ni ukoti wangayomoka. ");
INSERT INTO ndg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwa mana Nnongo amtumite kwaa mwana wake mu dunia ili kuihukumu dunia ila dunia ilopolewe pitya ywembe. ");
INSERT INTO ndg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ywamwamini ywembe alowa hukumilwa kwaa. Ywembe ywange mwamini tayari atihukumilwa kwa mana aliamini kwaa lina lya Mwana pekee ywa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ayee nga sababu ya hukumu, ya panga bweya uisile mu'ulimwengu, Lakini bandu kabapenda muno libendo kwa mana makowe gabe gabile mabou. ");
INSERT INTO ndg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","kila mundu ywapanga mabou uitola bweya wala aisa kwaa mu'bweya ili makowe gake gabonekane kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lakini, ywembe ywapanga kweli uisa mu'bweya ili makowe gake gabonekane gapangilwe kwa eshima ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Baada ya aga, Yesu pamope ni anapunzi bake batiyenda mu'nnema ya Yudea. Kolyo kabatumia muda pamope nabo ni abile atiabatiza. ");
INSERT INTO ndg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nambeambe Yohana abile atikwabatiza kolyo Ainea papipi ni Salim maana pabile ni mase ganansima palyo. ");
INSERT INTO ndg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kwa mana Yohana abile atabilwe kwa muligereza. ");
INSERT INTO ndg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pabile papangilwe mabishano nkati ya anapunzi ba Yohana na Myahudi husu sikukuu ya utakaso. ");
INSERT INTO ndg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kabayenda kwa Yohana kabammakiya, “Rabi, ywembe waubile niywembe ng'ambo ya mto Yordani, ywembe ywashuhudia habari yake, linga, aabatiza ni bote bayenda kunkengama.” ");
INSERT INTO ndg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana kayangwa mundu aweza kwaa pokya kilebe chochote ila kati ywapeilwe kuoma kumaunde. ");
INSERT INTO ndg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mwenga mwabene mwatishuhudia kuwa nabayite kuwa,'nenga kwaa Kristo,'badala yake nabayite,'Nitumilwe nnonge yake.' ");
INSERT INTO ndg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ywembe ywabile ni bibi arusi nga ngwana arusi. Nambeambe mbwiga wa ngwana arusi, ywayema ni kuyowa upulaiya muno kwa sababu ya lilobe lya ngwana arusi. Ayee nga puraha yango ya itimilike. ");
INSERT INTO ndg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Apalikwa yongeya, ni nenga nipalikwa pongwa. ");
INSERT INTO ndg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ywembe ywaboka kunani, abile nnani ya yoti. Ywembe ywabile ba ulimwengu abaka mu'ulimwengu. Ywembe ywaboka kumaunde abile nnani ya goti. ");
INSERT INTO ndg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ywembe ushuhudia galo agabweni ni kugayowa, lakini ntopo ywapokya ushuhuda bake. ");
INSERT INTO ndg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ywembe ywapokya ushuhuda bake atihakikisha kuwa Nnongo nga mkweli. ");
INSERT INTO ndg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kwa mana yolo ywatumilwe ni Nnongo ulongela maneno ga Nnongo. kwa mana ampeya kwaa mu'kipimo. ");
INSERT INTO ndg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tate umpenda mwana ni kumpeya ilebe yoti mumaboko gake. ");
INSERT INTO ndg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ywembe ywaaminiye mwana abile ni ukoti wanga yomoka, lakini kwa ywembe ywa mweshimu kwaa mwana aubweni kwaa ukoti, ila ghadhabu ya Nnongo ubile nnani yake. ");
INSERT INTO ndg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu atangite kuwa Mafarisayo bayowine kuwa Yesu abile abafundisha ni kuabatiza zaidi ya Yohana. ");
INSERT INTO ndg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ila Yesu mwene abatiza kwaa ila banapunzi bake), ");
INSERT INTO ndg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aboi Yudea no yenda Galilaya. ");
INSERT INTO ndg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ibile muhimu peta Samalia. ");
INSERT INTO ndg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Paikite mu. nnema wa Samaria, wakemelwa Sikari, papipi ni lieneo lya Yakobo atikumpea mwana wake Yusufu. ");
INSERT INTO ndg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ni kiembwa cha Yakobo chabile palyo. Yesu achokite kwaajili ya safari ni kutama papipi ni kiembwa. Ubile muda wa mutwekati. ");
INSERT INTO ndg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nwawa Msamalia aisile kutola mase, ni Yesu kammakiya, “Unipei mase niywee.” ");
INSERT INTO ndg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kwa kuwa anapunzi bake babile batiyenda mjini kupemea chakulya. ");
INSERT INTO ndg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yolo nnwawa atikummakiya, “Ipalika namani wenga wa Myahudi, kunloba nenga Msamaria, kilebe cha nywaa?” Kwa mana Ayahudi kabachangamana kwaa ni Asamalia. ");
INSERT INTO ndg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kannyangwa, “mana utangite karama ya Nnongo, ni yolo ywakumakiye “Mbei mase,' ywalowa kunnoba, ni kukupeya mase ga ukoti.” ");
INSERT INTO ndg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nwawa kayangwa, “Ngwana ubile kwaa ni ndoo yochotya, ni kilose sabile kirefu. Walowa kugapata wapi mase ga ukoti? ");
INSERT INTO ndg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Je wenga nga nkolo, kuliko tate bitu Yakobo, ywatupeile kiembwa, ni ywembe mwene ni bana bake pamope ni mifugo yake banywea mase ga kisima chino?” ");
INSERT INTO ndg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu kanyangwa, “Yeyoti ywanyaa mase aga alowa pata kiu kae? ");
INSERT INTO ndg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","lakini ywembe ywa nywaa mase ganipea nenga alowa pata kwaa kiu kae. Badala yake mase ganimpeya yapangika chemchem yaibubujika hata milele.” ");
INSERT INTO ndg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yolo nnwawa kammakiya, “Ngwana, naloba ago mase ili kana niipate kiu, ili kana niangaike kuisa pano kutola mase.” ");
INSERT INTO ndg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu kammakiya, “Uyende ukankeme nchengo wako.” ");
INSERT INTO ndg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nwawa kammakiya, “Nibile kwaa ni nchengo.” Yesu kanyangwa, “Ubayite sapi,'Nibile kwaa ni nchengo,' ");
INSERT INTO ndg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mana ubile ni analome atano, ni yumo ywabile naye nambeambe ni nchengo wako kwaa. Katika lelo ubayite ukweli!” ");
INSERT INTO ndg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nwawa kammakiya, “Ngwana nabweni kuwa wenga wa nabii. ");
INSERT INTO ndg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tate bitu babile bakiabudu mu'kitombe chelo. Lakini mwenga mwabaya ya kuwa Yerusalemu nga pandu ambapo bandu bapaswa kuabudu.” ");
INSERT INTO ndg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu kanyangwa, “Nwawa, niamini, muda uisile mwalowa abudu kwaa Tate mu'kitombe chelo au Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwenga bandu mwakiabudu kilebe chamukitangite kwaa, lakini twenga twaabudu chelo twakitangite, kwa mana wokovu uboka kwa Ayahudi.” ");
INSERT INTO ndg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Hata nyoo, muda waisa, ni mbeambe ubile pano, muda balo baabudu kweli balowa kumwabudu Tate atikuwapala bandu wa aina yee kupangika bandu babile bamwabudu. ");
INSERT INTO ndg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nnongo ni Roho, ni balo bamwabudu bapalikwa kumwabudu kwa roho ni kweli.” ");
INSERT INTO ndg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nnwawa kammakiya, “Nitangite kuwa Masihi anaisa, (Ywakemelwa Kristo). Aywo mana aisile alowa kutubakiya yoti.” ");
INSERT INTO ndg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu kammakiya, “Nenga ubayite ninenga nga ywembe.” ");
INSERT INTO ndg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Muda woo anapunzi bake babuyangine. Nabo batishangala kwa namani abile kaalongela ni nwawa, lakini ntopo ywathubutu kunnobia, “Upala namani?” au “Kwa mwanja namani ulongela ni ywembe?” ");
INSERT INTO ndg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yolo nnwawa aulekite mtungi wake ni kuyenda mjini kuamakiya bandu, ");
INSERT INTO ndg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Muise kunlola mundu ywanibakiye makowe gangu yoti ganipangite, je yawezekana kuwa nga Kristo?” ");
INSERT INTO ndg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Baboi mjini ni kuisa kwake. ");
INSERT INTO ndg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Muda wa mutwe kati anapunzi bake batikunnoba kababaya, “Rabi ulye chakulya.” ");
INSERT INTO ndg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lakini ywembe kaabakiya, “Nenga nibile ni chakulya mukitangite kwaa mwenga,” ");
INSERT INTO ndg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Anapunzi bake kabakokeyana, ntopo ywaletike kilebe chochote kulya,” je baletike? ");
INSERT INTO ndg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu kaamakiya, “Chakulya chango ni kugapanga mapenzi gake ywembe ywanitumile ni kwitimiza kazi yake. ");
INSERT INTO ndg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Je mulongela kwaa,'Bado miezi itano ni mauno gapangika tayari?' Naabakiya mulinge migunda yabile tayari kwa mauno. ");
INSERT INTO ndg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ywembe ywauna upokya mishahara ni kukusanya matunda kwaajili ya ukoto angeyomoka, ili ywembe apandae ni ywembe ywauna bapuraike mpamo. ");
INSERT INTO ndg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwa mana lilongelo lee ni lya kweli,'Yumo ywapanda ni ywenge auna.' ");
INSERT INTO ndg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Natikwatuma una chabile mwakihangaikia kwaa. Benge bapangite kasi ni mwenga mujingya mu'puraha ya kasi yabe.” ");
INSERT INTO ndg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Asamaria baingi mu'mji wolo batimwamini kwa taarifa ya yolo nnwawa ywabile atishuhudia.”Ywanibakiye makowe goti yanigapangite.” ");
INSERT INTO ndg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nyoo Asamaria baisile kunnoba atame pamope nabo ni katama kwao kwa masoba abele. ");
INSERT INTO ndg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ni baingi muno batikumwanini pitya neno lyake. ");
INSERT INTO ndg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bammakiye yolo nnwawa, “Tutiamini kwa maneno gako kwaa kae, kwa mana twenga twabene tuyowine, nambeambe tuyowine kuwa hakika ywembe nga mwokozi wa ulimwengu.” ");
INSERT INTO ndg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Baada ya masoba ago abele, atiboka ni kuyenda Galilaya. ");
INSERT INTO ndg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwa mama ywembe mwene abile atitangaza kuwa nabii abile kwaa ni heshima mu'nnema wake mwene. ");
INSERT INTO ndg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Paaisile kuoma Galilaya, Agalilaya batikumpokya. Babile babweni makowe goti agapangite Yerusalemu mu'sikukuu, kwa mana na bembe babile mu'sikukuu. ");
INSERT INTO ndg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aisile kae Kana ya Galilaya kolo atigabadilisha mase kuwa divai. Pabile ni ofisa mwana wake abile mtamwe kolyo Kapernaumu. ");
INSERT INTO ndg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Payowine kuwa Yesu aboi Yudea ni yenda Galilaya, kayenda kwa Yesu ni kumsihi auluke kumlopwa mwana wake, ywabile karibu ya kiwo. ");
INSERT INTO ndg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nga Yesu kammakiya, “Mwenga pamwaibweni kwaa ishara ni maajabu muweza kwaa aminiya. ");
INSERT INTO ndg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kiongozi kabaya, “Ngwana uluka pae kabla mwana wangu kuwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu kammakiya, “Uyende mwana wako ni nkoto.” Yolo mundu aaminiya neno lyalibayite Yesu ni yenda zake. ");
INSERT INTO ndg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Paabile auluka, amanda bake kabampokya ni kummakiya mwana wake abile nkoto. ");
INSERT INTO ndg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kaalaluya ni muda gani aupatike ukoto. Kabannyangwa, “Jana muda wa saa saba homa yanlekite.” ");
INSERT INTO ndg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nga tate bake atangite kuwa ni muda wowolo Yesu abayite, “Mwana wako nga nkoto.” Nyoo ywembe ni familiya yake baaminiye. ");
INSERT INTO ndg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ayee yabile nga ishara yana ibele yapangite Yesu palo aboite Yudea yendya Galilaya. ");
INSERT INTO ndg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Baadae pabile ni sikukuu ya Ayahudi, ni Yesu aboi kuyenda Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kolyo Yerusalemu pabile ni birika pa'nnyango wa ngondolo, lyabile likemelwa kwa lugha ya Baebrania Bethzatha, nalo lyabile ni matao matano. ");
INSERT INTO ndg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Idadi ngolo ya atamwe babile, ipofu, iwete, au babile batipooza babile bagonjite mu'matao ago. (Uzingatie: Maneno ga mstari wa 3 kabaonekana kwaa mu'nakala inoite ya kale. “Batikugasubiri mase kutibuliwa.”) ");
INSERT INTO ndg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kwa hakika muda fulani malaika auluka nkati ya Ngwana ni kuyatibua mase. Kwa nyoo. yolo ywabile wa kwanza kujingya nkati yake baada ya mase kutibuliwa apangilwe nkoti bokana na chochote chabile kintabile kwa muda woo. ");
INSERT INTO ndg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ni mundu yumo ywabile ntamwe kwa miaka thelathini na minane abile nkati ya matao. ");
INSERT INTO ndg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu paamweni agonjike nkati ya matao ni baada ya kutanga kuwa agonjike kwa muda mrefu Yesu kammakiya, “Je wapala kuwa nkoto.” ");
INSERT INTO ndg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yolo ntamwe kannyangwa, “Ngwana nabile kwaa na mundu, wa kunibeka mu'birika muda yabile yatitibulilwa. Muda kabanijaribu jingya mundu ywenge atikuntangulia.” ");
INSERT INTO ndg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu aamkiye, “Uluka ulipotwe litandiko lyako na uyende.” ");
INSERT INTO ndg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mara yolo mundu aponywile, alitweti kindanda sake no yenda. Lelo labibe lisoba lya sabato. ");
INSERT INTO ndg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nga Ayahudi bammakiuye, yolo mundu ywaponywile, “leno ni lisoba lya sabato, ni halalli kwaa kupotwa litandiko lyako.” ");
INSERT INTO ndg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kayangwa, ywembe ywaniponyile animakiye, “Tola litandiko lyako no uyende.” ");
INSERT INTO ndg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kabanlaluya, “Nyai ywakumakiye,'tola litandiko lyako no uyende.” ");
INSERT INTO ndg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ingawa, yolo ywaponywile antangite kwaa mana Yesu aboi kwa siri. Kwa mana pabile ni bandu banyansima. ");
INSERT INTO ndg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Baada ya ago Yesu amkolile yolo mundu mu'lihekalu ni kummakiya, “Linga upangite nkoto! kana upange sambi kae kana likupate likowe libaya muno.” ");
INSERT INTO ndg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mundu yolo kayenda ni kuamakiya Ayahudi kuwa Yesu nga amponyile. ");
INSERT INTO ndg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwa mwanja wa makowe ago Ayahudi bantesike Yesu, kwa mana apangite makowe aga lisoba lya sabato. ");
INSERT INTO ndg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu kaamakiya, “Tate bango apanga kazi nambeambea ni nenga napanga kazi.” ");
INSERT INTO ndg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwa sababu yee Ayahudi kabampala muno ili kumulaga yapanga kwaa kae atekwile Sabato, ila kwa kunkema Nnongo Tate bake, kuipanga abile sawa ni Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu kabayangwa, “Amini, amini, mwana aweza kwaa panga ilebe yeyoti ila chelo amweni Tate bake apangite, kwa mana chochote Tate akipangite nga mwana akipanga. ");
INSERT INTO ndg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwa kuwa Tate ampenda mwana, ni kunlolekeya kila kilebe akipangite ni kunlolekea makowe makolo kuliko aga ili muzidi shangala. ");
INSERT INTO ndg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kwa kuwa kati Tate atikwafufua bandu mu kiwo ni kuwapea ukoto, nga mwana umpeya yeyote ywampendae. ");
INSERT INTO ndg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kwa kuwa Tate amuhukumu kwaa yeyote, ila umpeya mwana hukumu yoti ");
INSERT INTO ndg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili kwamba boti bamweshimu Mwana kati yo panga Mwana atikumweshimu Tate. Ywembe ywamuheshimu kwaa Mwana amuheshimu kwaa ni Tate ywantumite. ");
INSERT INTO ndg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Amini, amini, ywembe ywaliyowine neno lyango ni kuliaminiya abile ni ukoto wangayomoka ni aukumilwa kwaa. Badala yake, atipeta boka mu'kiwo no jingya mu'ukoto. ");
INSERT INTO ndg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Amini, amini, naabakiya muda waisa nambeambe ubile ambapo bandu ba mu'kiwo balowa kuiyowa sauti ya Mwana wa Nnongo, ni boti baiyowine walowa tama. ");
INSERT INTO ndg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kwa mana kati Tate abile ni ukoto nkati yake mwene, ");
INSERT INTO ndg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","pia ampei Mwana kuwa ni ukoto nkati yake, Tate ampei mwana mamlaka ili ahukumu kwa kuwa ni Mwana wa Adamu. ");
INSERT INTO ndg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kana mshangae lelo, kwa mana muda waisa ambao bandu bote baabile mu'makaburi walowa kuliyowa lilobe lyake ");
INSERT INTO ndg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nabo baboite panja: kwa balo bapangite mema kwa ufufuo wa ukoto, na balo bapangite mabaya kwa ufufuo wa hukumu. ");
INSERT INTO ndg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Naweza kwaa kupanga chochote boka kwango mwene. Kati niyowine, nga nalowa kuhukumu na hukumu yango ni ya haki kwa mana nipalike kwaa mapenzi yango, ila mapenzi yake ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kati ya panga nishuhudia mwene, ushuhuda wango wabile kwaa wa kweli. ");
INSERT INTO ndg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kwabile ni ywenge ywanishuhudia nenga na nitangite kwa hakika kuwa ushuhuda waaushudie ni wa kweli. ");
INSERT INTO ndg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mumtumile kwa Yohana ni ywembe atikwashuhudia kweli. ");
INSERT INTO ndg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hata nyoo, ushuhuda waniupokeile uboka kwaa ka mundu. Niabaya aga ili muweze kulopolelwa. ");
INSERT INTO ndg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana abile taa yaiyaka na ng'ara, na mwabile tayari kuipuraia kwa muda nkolo bweya yake. ");
INSERT INTO ndg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ushuhuda wanibile nao ni nkolo kuliko wolo wa Yohana kwa kasi ambazo Tate anipei kuikamilisha, izo kazi nizipangite kwa ushuhuda kuwa Tate anitumile. ");
INSERT INTO ndg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tate ywanitumile ywembe mwene atikwashuhudia kuhusu nenga. Muyowine kwaa lilobe lyake wala kubonekeya liumbo lyake wakati wowote. ");
INSERT INTO ndg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ntopo neno lyake nkati yinu kwa mana mumwaminiye kwaa ywembe ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mugachunguza maandiko mkidhani mwabile ni ukoto wangeyomoka nkati yake, na maandiko ago yaashuhudia habari yango na ");
INSERT INTO ndg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","mukani kuisa kwango ili mpate ukoto wangeyomoka. ");
INSERT INTO ndg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nenga nipokya kwaa sifa boka kwa bandu. ");
INSERT INTO ndg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lakini nitangite kuwa ntopo upendo wa Nnongo yinu mwenga mwabene. ");
INSERT INTO ndg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nenga niisile kwa lina lya Tate bango, muweza kwaa kunipokya. Kati ywenge aisa kwa lina lyake mwalowa kumpokya. ");
INSERT INTO ndg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Je muweza kwaa kuamini mwenga ambao mpala kwaa sifa iboka kwa Nnongo wa pekee? ");
INSERT INTO ndg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kana muwaze nenga nitabashitaki nnonge ya Tate. Ywaabashitakiya mwenga ni Musa, ambaye mwenga mubekite matumaini yinu kwake. ");
INSERT INTO ndg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kati mwatikumwamini Musa, mwalowa kuniamini nenga kwa kuwa ywembe aandikile habari zangu nenga. ");
INSERT INTO ndg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Muyaamini kwaa maandiko gake, mwaweza kwaa kugaamini maneno yango? ");
INSERT INTO ndg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","baada ya makowe aga, Yesu kayenda kwiye ya bahari ya Galilaya, pia ukemwa bahari ya Tiberia. ");
INSERT INTO ndg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kipenga kikolo sa bandu satikunkengama kwa mana babweni ishara azipangite kwa babile atamwe. ");
INSERT INTO ndg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu aobwike nnani hadi upande wa nnani ya kitombe ni tama kwoo ni anapenzi bake. ");
INSERT INTO ndg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Ni Pasaka, Sikukuu ya Ayahudi yabile imekaribia) ");
INSERT INTO ndg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu paatondobiyea minyo gake nnani kubona kipenga kikolo sa bandu waisa kwake, kammakiya Filipo.”Tuyende kwaako kupemea mikate ili haba pandu baweze lyaa?” ");
INSERT INTO ndg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Lakini Yesu kalongela aga kwa Filipo kwa kumgeya kwa mana ywembe atangite chakukipanga). ");
INSERT INTO ndg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo kanyangwa, “Hata mikate ya garamia dinari mia ibele itosha kwaa hata kila yumo lya kipande kichunu.” ");
INSERT INTO ndg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrea yumo ywa anapunzi bake nnongowe Simoni Petro kammakiya ");
INSERT INTO ndg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Yesu, “pabile ni nnalome pano abile na mikate mitano ni omba abele, lakini yafaa namani kwa bandu banyansima namna yee?” ");
INSERT INTO ndg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu kaabakiya, “Muamakiye batami pae” (pabile ni manyei yanansima pandu palo). Pabile ni analome kati elfu tano batami pae. ");
INSERT INTO ndg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu kaitola yelo mikate mitani kashukuru ni kubagea balo babile batami. Nyo nyonyo kabagawia ni omba kadri yabapala. ");
INSERT INTO ndg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bandu pabayukwite, atikuamakiya anapunzi bake, “Mwikusanye ipande ya mabaki, yalekwile ili kana kipotee chochote.” ");
INSERT INTO ndg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bai kabakusanya ni kuijaza itondo komi ni ibele, ipande ya mikate mitano ya shahiri-ipande yalekwile ni balo babile lyaa. ");
INSERT INTO ndg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Boka po bandu kababweni ishara yee yaaipangite kababaya, “Kweli yolo nga yolo nabii ywaisa mu'ulimwengu.” ");
INSERT INTO ndg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu paatangite kuwa bapala kuntaba ili bampange kuwa mfalme wabe, atikuitenga, kae na kuyenda pakitombe ywembe kichake. ");
INSERT INTO ndg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Paiikite kitamwinyo, anapunzi bake batiuluka yenda mu'bahari. ");
INSERT INTO ndg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bateobuka mu'ngalaba ni babile kabaloka yenda Kapernaumu. (Libendo lyabile lajingya ni Yesu abile bado kaisa kwabe) ");
INSERT INTO ndg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","muda wowo pabile ni upepo mkale uisile, ni bahari yaibile itisapuka. ");
INSERT INTO ndg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Anapunzi bake babile bakombwile makasia kati ishirini na tano au thelathini, bamweni Yesu ayenda kunani ya bahari kuikaribia ngalaba, ni kuogopa. ");
INSERT INTO ndg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lakini kaamakiya, “Ni nenga! kana muyogope.” ");
INSERT INTO ndg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kae babile tayari kumpotwa mu'ngalaba, ni mata ngalaba yaikite mu'nnema wabile kabayenda. ");
INSERT INTO ndg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lisoba lya naibele, kipenga sa bandu sayemi upande wa bahari sabweni kuwa ntopo ngalaba yenge ila wolo ambao Yesu ni anapunzi bake babile baupandile kwaa lakini anapunzi bake baboi bembe. ");
INSERT INTO ndg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Ingawa, pabile ni baadhi ya ngalaba yabokite Tiberia papipi ni pandu palyaa mikate baada ya Ngwana kutoa shukrani). ");
INSERT INTO ndg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wakati bandu batangite kuwa ni Yesu kwaa wala anapunzi bake babile kolyo, bembe baobite mu'ngalaba ni kuyenda Kapernaumu kunkengama Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Baada ya kumpata upande wenge wa bahari kabanlaluya, “rabi uisile lini kuno?” ");
INSERT INTO ndg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kabayangwa, kaamakiya, Amini, amini, mwalowa kunipala nenga, kwamana muibweni ishara, ila kwa mana mulya mikate na kuyukwita. ");
INSERT INTO ndg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Muleke kukipangia kazi chakulya chaharibika, ila mkipangie kazi chakula cha haribika kwaa hata milele chelo ambacho mwana wa Adamu awapeya, kwa kuwa Nnongo Tate aubekite muhuri nnani yake.” ");
INSERT INTO ndg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Boka po kabammakiya, “Tupange namani ili kuzipanga kazi za Nnongo? ");
INSERT INTO ndg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kayangwa, “Ayee nga kazi ya Nnongo: mmwamini ywembe ywaatumite.” ");
INSERT INTO ndg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Atikwabakiya, “Ni ishara yaako walowa kwipanga, ili twaweza kuibona ni kuiaminiya? Walowa panga namani? ");
INSERT INTO ndg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tate bitu walya manna mu'lijangwa, kati yabile yaandikwile, “Atikwapeya mikate boka kumaunde ili balyee.” ");
INSERT INTO ndg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu kanyangwa, “Amini, amini, Musa kwaa ywaawapeya mkate boka kumaunde, ila Tate bango nga awapeile mkate boka kumaunde. ");
INSERT INTO ndg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwa kuwa mkate wa Nnongo nga wolo uulukile boka kumaunde ni kuupata ukoto mu'ulimwengu. ");
INSERT INTO ndg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kammakiya,'Ngwana utupeye woo mkate wote.” ");
INSERT INTO ndg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu aamakiye, “Nenga nga mkate wa ukoto, ywembe ywaisa kwango apatike kwaa njala ni ywembe ywaniaminiye aibweni kwaa kiu kamwe.” ");
INSERT INTO ndg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ingawa natikuabakiya kuwa, muibweni, na bado muamini kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bote ambao Tate anipeile balowa isa kwango, ni yeyote ywaisa kwango nalowa kuntaikwa panja. ");
INSERT INTO ndg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwa kuwa natiuluka boka kumaunde, kwaajili ya panga kwaa mapenzi yango, ila mapenzi yake ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nga aga nga mapenzi gake ywanitumile, kana nimpoteze hata yumo wa balo anipeile, ila nalowa kubafufua lisoba lya mwisho. ");
INSERT INTO ndg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","kwa mana aga nga mapenzi ga Tate bango, kuwa yeyote ywanlolekeya Mwana ni kumwamini apate ukoto wanga yomoka; ni nenga nalowa kubafufua lisoba lya mwisho. ");
INSERT INTO ndg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ayahudi kabanung'unika kuhusu ywembe kwa mana abayite, “Nenga nga mkate uboka kumaunde.” ");
INSERT INTO ndg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kababaya, “Ayo Yesu kwaa mwana wa Yusufu, ywabile tate bake ni mao bake twawatangite? Ipalikwa namani nambeambe abayite,'Natiuluka kuoma kumaunde?” ");
INSERT INTO ndg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu kaayangwa, kaabakiya, “Kana mnung'unike nkati yinu mwabene. ");
INSERT INTO ndg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ntopo mundu ywaisa bila potwa na Tate bango ywanitumile, ni nenga nalowa kumfufua lisoba lya mwisho. ");
INSERT INTO ndg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kwa kuwa iandikilwe mu'manabii,'balowa pundishwa ni Nnongo.' Kila ywayowine ni kuipundisha kuoma kwa Tate, uisa kwango. ");
INSERT INTO ndg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ntopo mundu ywamweni Tate, ila ywembe ywaisa boka kwa Nnongo-amweni Tate. ");
INSERT INTO ndg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Amini, amini ywembe aaminiye abile ni ukoto wange yomoka. ");
INSERT INTO ndg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nenga nga mkate wa ukoto. ");
INSERT INTO ndg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tate binu kabalya manna mu'lijangwa, no waa. ");
INSERT INTO ndg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Awoo nga mkate uboite kuoma kumaunde, ili mundu aulye ipande yake ili kana abulagilwe. ");
INSERT INTO ndg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nenga nga mkate watama wabile uulukite kuoma kumaunde. Kati mundu yoyote ywaalya ipande ya mkate woo, alowa tama milele. Mkate waniuboile nga yega yango kwaajili ya ukoto wa Ulimwengu.” ");
INSERT INTO ndg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayahudi kabakasirika bene kwa bene ni kuanza bishana no baya, “Mundu yolo aweza kinamani kutupeya yega yake tuulye?” ");
INSERT INTO ndg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Boka po Yesu kaamakiya, “Amini amini, mana muuliye kwaa yega ya mwana wa Adamu ni kuinywea mwai yake, kana mubile kwaa ni ukoto nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yeyote ywalyaa yega yango ni kwinywea mwai wango abile ni ukoto wangeyomoka, ni nenga nalowa kumfufua lisoba lya mwisho. ");
INSERT INTO ndg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwa kuwa yega yango ni chakulya cha kweli, ni mwai wango ni kinywaji cha kweli. ");
INSERT INTO ndg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ywembe ywaulyaa yega yango ni kwinywea mwai yango aloa tama nkati yango, ni nenga nkati yake. ");
INSERT INTO ndg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kati Tate ywabile ni ukoto ywanitumile, na kati nenga niishivyo kwa sababu ya Tate, ni ywembe pia atama kwa sababu yango. ");
INSERT INTO ndg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Awoo nga mkate uboite kuoma kumaunde, kati yabile tate balye kababulagilwa. Ywembe ywaulyaa mkate woo alowa tama milele. ");
INSERT INTO ndg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu abayite makowe aga nkati ya sinagogi abile akipundisha kolyo Kapernaumu. ");
INSERT INTO ndg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bengi ba anapunzi bake kabayowine aga, kababaya, “Alee lipundisho gumu nyai ywaweza kulipokya?” ");
INSERT INTO ndg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu kwasababu atangite ya kuwa anapunzi bake babile batikulinung'unikya likowe lee, Kaamakiya je likowe lee lyatikuwakwaza? ");
INSERT INTO ndg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ipangika buli pabamweni mwana wa Adamu atiuluka kuoma kwaabile kabla? ");
INSERT INTO ndg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Roho nga ayeya ukoto. Yega ufaidi kwaa kilebe chochote. Maneno yaniyabayite kwinu nga roho nga ni ukoto. ");
INSERT INTO ndg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bado kwabile na bandu kati yinu baaminiye kwaa. kwasababu Yesu atangite tangu mwanzo yolo ywabile aweza kwaa kuaminiya ni ywembe ywamsalitiye. ");
INSERT INTO ndg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kam'bakiya, ni kwa sababu yee nikubakiyange kwamba ntopo mundu ywaweza kuisa kwango ibile kwaa apeilwe ni Tate.” ");
INSERT INTO ndg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Baada ya aga anapunzi bake baibgi batibuyangana nnchogo ni batikengamana nakwe kwaa kae. ");
INSERT INTO ndg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu kaamakiya balo komi na ibele, “Je ni mwenga mwapala kuboka?” ");
INSERT INTO ndg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petro kannyangwa, “Ngwana tuyende kwa nyai kwani wenga ubile ni maneno ga ukoto wangeyomoka, ");
INSERT INTO ndg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ni twatuaminiya ni kuyowa kuwa wenga nga Mtakatifu wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu kaamakiya, “Je nenga niwachawile kwaa mwenga, ni yumo winu nga ibilisi? ");
INSERT INTO ndg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nambeambe abile kalongela kuhusu Yuda, mwana wa Simoni Iskariote, kwa kuwa abile ni ywembe abile yumo wa balo komi ni ibele, ywabile ywamsalitie Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Na baada ya makowe aga Yesu atisafiri mu'Galilaya, kwa sababu apendile kwaa kuyenda Uyahudi kwa sababu Bayahudi babile bakipanga mipango ya kummulaga. ");
INSERT INTO ndg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nambeambe sikukuu ya Ayahudi, sikukuu ya vibanda, yabile papipi. ");
INSERT INTO ndg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nga alongo bake batikummakiya, “Uboke pandu hapa uyende Uyahudi, ili kwamba anapunzi bako nyonyonyo bayabone makowe uyapangayo. ");
INSERT INTO ndg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ntopo ywapanga lolote kwa siri iwapo ywembe mwene apala kutangikana wazi. Iwapo upanga makowe aga, ujibonekeye wamwene kwa ulimwengu.” ");
INSERT INTO ndg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hata nnongo bake bamwaminiye kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nga Yesu kammakiya, “Muda wango uikite kwaa bado, lakini muda winu kila mana ubile tayari. ");
INSERT INTO ndg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ulimwengu waweza kwaa kubachukiya mwenga, ila wanichukiya nenga kwa kuwa niashuhudia kuwa makowe gake ni mabou. ");
INSERT INTO ndg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mubokange kuyenda mu'sikukuu: nenga niyenda kwaa mu'sikukuu yee kwa sababu muda wangu ukamilika bado.” ");
INSERT INTO ndg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Baada ya kulongela makowe ago kwabe, atami Galilaya. ");
INSERT INTO ndg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hata nyoo, nongo bake pababile mu'sikukuu, nga ni ywembe atiyenda, sio kwa wazi bali kwa siri. ");
INSERT INTO ndg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayahudi pabile pakimpala mu'sikukuu no baya, “Abile kwaako?” ");
INSERT INTO ndg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pabile ni malongelo ganyansima nkati ya makutano nnani yake. Benge batibaya, “Ni mundu mwema,” Benge babayite, “Hapana, uwapotosha bandu.” ");
INSERT INTO ndg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hata nyoo ntopo ywalongela wazi nnani yake kwa kuwaogopa Ayahudi. ");
INSERT INTO ndg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Muda wa sikukuu waikite katikati, Yesu kayenda mu'hekalu ni kuanza kupundisha. ");
INSERT INTO ndg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayahudi babile batishangala no kubaya, “Kwa jinsi yanamani mundu yee ayatangite makowe ganyansima? Asoma kwaa kamwe.” ");
INSERT INTO ndg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kabayangwa ni kuamakiya, “Mapundisho gango nga yango kwaa, ila ni ya yolo ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Iwapo yeyote ywapenda panga mapenzi gake ywembe, atangite kuhusu mapundisho aga, kati yatiboka kwa Nnongo, au kati nialongela kuoma kwango mwene. ");
INSERT INTO ndg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kila ywalongela yaboite kwake mwene upala utukufu wake, ila kila yaa aupala utukufu wake ywembe ywamtumile, mundu yoo nga wa kweli, ni nkati yake ntopo kutenda ubou. ");
INSERT INTO ndg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa awapeile kwaa mwenga saliya? Lakini ntopo hata yumo nkati yinu ywaipangite saliya. Mwanja namani mwapala kunibualaga? ");
INSERT INTO ndg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bandu kabannyangwa, “Ubile ni nchela, nyai ywapala kukubulaga? ");
INSERT INTO ndg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kayangwa ni kuamakiya, nipangite kazi yimo, ni mwenga mwabote mwatishangala kwa sababu ya yelo kazi. ");
INSERT INTO ndg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa atikuwapea mwenga tohara (iboite kwaa boka kwa Musa, ila yelo yaboite kwa tate), ni nkati ya Sabato mwastahili mundu. ");
INSERT INTO ndg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mana abile mundu ywapokya tohara mu'siku ya Sabato ili saliya ya Musa itekwanike, kwa mwanja namani mwanikasirikya nenga kwa sababu nimpangite mundu kuwa nkoto kabisa mu'sabato? ");
INSERT INTO ndg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kana mhukumu lengana na mwonekano, ila muhukumu kwa haki. ");
INSERT INTO ndg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Baadhi yabe baboka Yerusalemu kababaya, “Yolo kwaaa wampala kummulaga? ");
INSERT INTO ndg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","No linga, alongela waziwazi, nga balongela kwaa chochote nnani yake. Iwezekana kwaa ibile kwamba atawala batangite kweli kuwa ayoo nga Kristo, yawezana batangite? ");
INSERT INTO ndg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Twayowine kuwa mundu yolo aboka kwaako. Kristo paaisa, hata nyoo, ntopo ywatangite abokakwaako. ");
INSERT INTO ndg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu abile akombwa lilobe lyake mu'hekalu, kapundisha no baya, “Mwenga mwabote mtangite paniboka. Niisile kwaa kwa nafasi yango, ila ywembe ywanitumile nga wa kweli, na muntangite kwaa ywembe. ");
INSERT INTO ndg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nintangite ywembe kwa mana niboka kwake nga anitumite.” ");
INSERT INTO ndg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Babile kabajaribu kuntaba, lakini ntopo hata yumo ywauluwa luboko lwake nnani yake kwa kuwa saa yake yabile bado iikite. ");
INSERT INTO ndg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hata nyoo, baingi mu'bandu baaminiya. Kababaya, “Kristo paaisile, alowa panga ishara zanyansima kuliko za azipangite mundu yolo?” ");
INSERT INTO ndg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafarisayo babayowine bandu kabalongela bembe makowe aga husu Yesu, ni akolo ba makuhani ni Mafarisayo watikubatuma maafisa ili kuntaba. ");
INSERT INTO ndg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Palyo Yesu kabaya, “Bado kwabile ni muda nchunu nabile pamope ni mwenga, ni baadae nalowa boka kuyenda kwake ywembe ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mwalowa kunipala ila munibweni kwaa; kolyo kaniyenda, muweza kwaa kuisa. ");
INSERT INTO ndg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kwa nyo Ayahudi kabalongela bene kwa bene, “Mundu yoo ayenda kwaako ambako twaweza kwaa kummona? Ayenda kwa batawanyike nkati ya Ayunani ni kubapundisha Ayunani? ");
INSERT INTO ndg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ni neno lyaako lee alibayite,'Mwalowa kunipala wala mwanibweni kwaa, kolyo niyenda muweza kwaa kuisa?” ");
INSERT INTO ndg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nambeambe mu'lisiku lya mwisho, lisoba likolo lya sikukuu, Yesu ayemi kakombwa lilobe, kabaya, “Mana itei yeyote abile na kiu, aise kwango anywe. ");
INSERT INTO ndg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ywembe ywaniaminiye nenga, kati maandiko gabayite, kuoma nkati yake yatitiririka mito ya mase ya ukoto. ");
INSERT INTO ndg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lakini abayite aga kuhusu Roho, ywabile wao watikumwamini walowa kumpoteza; Roho abile bado tolewa kwa sababu Yesu abile atukuzwa kwaa bado. ");
INSERT INTO ndg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Baadhi ya bandu, pabayowine maneno aga, babayite, “Kweli yolo ni nabii.” ");
INSERT INTO ndg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Benge babayite, “Ayoo nga Kristo.” Lakini benge babayite, “Kristo aweza kwaa boka Galilaya? ");
INSERT INTO ndg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Maandiko gabayite kwaa kuwa Kristo aboka mu'lukolo lwa Daudi ni kuoma Bethlehemu, kijiji ambacho Daudi abile? ");
INSERT INTO ndg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nyo, patiuluka mgawanyiko nkati ya bandu kwa ajili yake. ");
INSERT INTO ndg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Benge nkati yabe balowa kuntaba, lakini ntopo ywauluwa maboko gake nnani yake. ");
INSERT INTO ndg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nga balo maofisa kababuyangine kwa akolo ba makuhani ni mafarisayo, nabo wakaakokeya, “Kwa mwanja namani munletike kwaa? ");
INSERT INTO ndg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Maofisa kaayangwa, “Ntopo mundu ywaweza longela kati yolo kabla.” ");
INSERT INTO ndg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nga mafarisayo kabayangwa, “Ni mwenga pia mwatipotoshwa? ");
INSERT INTO ndg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kwabile ni yoyoti nkati ya atawala amwaminiye, au yeyote wa Mafarisayo? ");
INSERT INTO ndg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ila aba bandu baitangite kwaa saliya-balaanilwe.” ");
INSERT INTO ndg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo kaabakiya (ywembe atikunyendea Yesu zamani, abile yumo ywa Mafarisayo), ");
INSERT INTO ndg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Je saliya yitu yaweza kumhukumu mundu ila abile atikusikilizwa kwanza ni kuyowa chaakipangite? ");
INSERT INTO ndg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kabanyangwa ni kummakiya, “Ni wenga uboka Galilaya? Tafuta ni ubone kwamba ntopo nabii ywaboka Galilaya.” ");
INSERT INTO ndg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1"," Yesu aboi mu'kitombe sa Mizeituni. ");
INSERT INTO ndg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bwamba aisa mu'lihekalu, ni bandu bote kabankengama, atami na kubapundisha. ");
INSERT INTO ndg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Baandishi ni Mafarisayo kabannetya Nwawa ywaatabilwe mu'kitendo sa'umalaya. Kabamweka nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nga kabammakiya Yesu, “Mwalimu, nnwawa yolo atabilwe mu'umalaya, paabile apanga umalaya. ");
INSERT INTO ndg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nambeambe, mu'saliya ya Musa atituamuru kuwapondanga maliwe bandu kati aba, ubaya namani nnani yake? ");
INSERT INTO ndg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kabagabaya aga ili kuntegeya ili bapate likowe lya kumshitaki, lakini Yesu kainama ni kuandika pae pa'bui kwa kidole sake. ");
INSERT INTO ndg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pabayendelea kunnaluya, ayemi ni kuabakiya, “Ywembe abile kwaa ni sambi nkati yinu, abile wa kwanza kumpondanga maliwe.” ");
INSERT INTO ndg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ainamite kae pae, atiandika mu'dunia kwa kidole chake. ");
INSERT INTO ndg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kabayowine ago, batiboka yumo baada ya ywenge, kuanzia ywabile mpindo. Mwisho Yesu alekilwe kichake, pamope ni yolo nnwawa ywabile nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu ayemite ni kummakiya “Nnwawa, balo bakushitakiya babile kwaako? Ntopo hata yumo ywakuhukumu? ");
INSERT INTO ndg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kabaya, “Ntopo hata yumo Ngwana.” Yesu kabaya, “Hata nenga nalowa kukuhukumu kwaa, uyende mundela yako; kuanzia nambeambino ni kuyendelea kana upange sambi kae.” ");
INSERT INTO ndg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu kalongela na bandu kae kabaya, “Nenga na mbeya ba ulimwengu; ywembe ywanikengamite atyanga kwaa mulibendo ila abile ni ukoto,” ");
INSERT INTO ndg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafarisayo kabammakiya, “Wajishuhudia wa mwene, ushuhuda wako nga wa kweli kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Y6esu kaayangwa ni kuwamakiya, “Hata kati nalowa kujishuhudia mwene, ushuhuda wango ni kweli. Nitangite pandu nibokite ni kolyo kaniyenda, lakin i mwenga mutangite kwaa pandu nibokite au kolyo kaniyenda. ");
INSERT INTO ndg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mwenga mwatihukumu mu'yega; nenga nahukumu kwaa yeyote. ");
INSERT INTO ndg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nenga hata mana nihukumule, hukumu yango ni kweli kwa sababu nabile kwaa kichango, nibile pamope ni Tate ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Eloo, na mu'saliya yinu iandikilwe kuwa ushuhuda wa bandu abele ni kweli. ");
INSERT INTO ndg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nenga nga nishuhudiae, ni Tate ywanitumile atikunshuhudia.” ");
INSERT INTO ndg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bakammakiya, “Tate bako abile kwaako?” Yesu kayangwa, “Nenga mwanitangite kwaa nenga, mana munitangike nenga, mwalowa kuntanga ni Tate bango kae.” ");
INSERT INTO ndg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Abaya maneno aga abile papipi ni hazina abile atifundisha mu'lihekalu, na ntopo hata yumo ywantabile kwa sababu saa yake ibile bado iikite. ");
INSERT INTO ndg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bai kammakiya kae, “Niyenda zangu; mwalowa kunipala na mwatiwaa mu'sambi yinu. Kolyo kwaniyenda, mwaweza kwaa kuisa.” ");
INSERT INTO ndg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayahudi kababaya, “Alowa tanga mwene, ywembe ywabile akibaya,'kolyo kaniyenda muweza kwaa kuisa'?” ");
INSERT INTO ndg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu kaamakiya, “Mwaboka pae, nenga niboka kunani. Mwenga ni ba Ulimwengu; nenga na wa ulimwengu kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kwa eyo, natikuwabakiya kuwa nalowa waa mu'sambi yinu. Vinginevyo mwaminiya kuwa NENGA NGA, mwalowa waa mu'sambi yinu.” ");
INSERT INTO ndg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kwa eyo kabammakiya, “Wenga wa nyai?” Yesu kaamakiya, galo ganiabakiya tangu mwanzo. ");
INSERT INTO ndg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nabile ni makowe ganansima gakulongela ni kuhukumu nnani yinu. Hata nyoo, ywembe ywanitumile ni wa kweli; ni makowe nigayowine kuoma kwake, makowe aga niabaya kwa ulimwengu.” ");
INSERT INTO ndg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kabamwelewa kwaa kuwa abile kalongela nabo kuhusu Tate. ");
INSERT INTO ndg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu kabaya, “Pamwalowa kumwinua kunanu Mwana wa Mundu, nga mwalowa tanga NENGA NGA, ni kwamba nipangite kwaa lolote kwa nafsi yango. Kati Tate ywanipundisha, nalowa longela makowe aga. ");
INSERT INTO ndg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ywembe ywanitumile abile pamope ni ywembe, na ywembe anilekite kichango, kwani kila mara napanga galo gabampendeza.” ");
INSERT INTO ndg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Palyo Yesu abaya makowe aga, baingi batikumwaminiya. ");
INSERT INTO ndg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu kabaya kwa balo Ayahudi baaminiye, “Mana ibile mwatama mu'neno lyango, nga mubile anapunzi bango kweli, ");
INSERT INTO ndg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mwenga mwalowa kuitanga kweli, ni kweli yalowa kwabeka huru.” ");
INSERT INTO ndg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kabanyangwa, “Twenga twa ubeleko wa Ibrahimu ni kamwe tuwaike kwaa pae ya utmumwa wa yeyote; wabaya kwaa, “Twalowa bekwa huru?” ");
INSERT INTO ndg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu kaayangwa, “Amini, amini, naamakiya, kila ywapanga sambi ni mmanda wa sambi. ");
INSERT INTO ndg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mmanda atama kwaa munyumba wakati wote; mwana hudumu masoba yote. ");
INSERT INTO ndg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kwa eyo, mana itei Mwana abekilwe huru, mwalowa pangika huru kweli kabisa.” ");
INSERT INTO ndg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nitangite kwamba mwenga ni ubeleko wa Ibrahimu; mwanipala kunibulaga kwa sababu neno lyango labile kwaa ni nafasi nkati yinu, ");
INSERT INTO ndg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nalongela makowe ambayo niyabweni pamope ni Tate bango, ni mwenga nyonyonyo mwapanga makowe ambayo mwagayowine kuoma kwa tate yinu.” ");
INSERT INTO ndg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kbanyangwa ni kummakiya, “Tate yitu nga Ibrahimu.”Yesu kaamakiya, kati mwabile ni bana ba Ibrahimu, mwalowa panga kazi ya Ibrahimu. ");
INSERT INTO ndg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hata nambeambe mwalowa pala kunibulaga, mundu ywabakiye ukweli kuwa nayowine kuoma kwa Nnongo. Abrahamu apangite kwaa ayee.” ");
INSERT INTO ndg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwapanga kazi ya tate yinu.”Kabammakiya, Tubelekwile kwaa mu'umalaya, tubile ni Tate yumo Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu kammakiya, “Mana itei Nnongo nga Tate yinu, mnipendile nenga, kwa maana niboite kwa Nnongo; wala niisile kwaa kwa nafsi yango, ila ywembe ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kwa namani mwelewa kwaa maneno yango? Kwa sababu muweza kwaa vumiliya kugayowa maneno yango. ");
INSERT INTO ndg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mwenga ni wa tate yinu, nchela, nga mpala kuipanga tamaa ya tate yinu. Abile ywamulaga tangu mwanzo ni aweza kwaa kuyema mu'ukweli kwa mana kweli yabile kwaa nkati yake. Kabalongela ubocho, alongela kuoma kwa asili yake kwa sababu ni mmocho nga tate ba ubocho. ");
INSERT INTO ndg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nambeambe, kwa sababu nibayile yaibile kweli, muniamini kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ywa nyai nkati yinu ywanishuhudia kuwa nibile ni sambi? mana itei nibile yaibile kweli, kwa mwanja namani mwaniamini kwaa? ");
INSERT INTO ndg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ywembe ywabile wa Nnongo hugayowa maneno ga Nnongo; Mwenga muyayowine kwaa kwa mana mwenga mwa wa Nnongo kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayahudi kabanyangwa ni kummakiya, twabaya kwaa kweli kuwa wenga wa Msamaria na ubile ni nchela?” ");
INSERT INTO ndg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kayangwa, nibile kwaa ni pepo; lakini namweshimu Tate bango, ni mwenga mwaniheshimu kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nipala kwaa utukufu wango; kwabile yumo ywapala ni hukumu. ");
INSERT INTO ndg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Amini, amini, nakubakiya, ywabile yeyote ywalikamua neno lyango, akibweni kwaa kiwo kamwe.” ");
INSERT INTO ndg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayahudi kabammakiya, “Nambeambe tutangite kuwa ubile ni nchela. Abrahamu ni manabii kabawaa, lakini wabaya,'Mana itei mundu alikamwile neno lyango, aonjile kwaa kiwo.' ");
INSERT INTO ndg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wenga nkolo kwaa kuliko tate bitu Abrahamu ywati waa? Manabii pia bawile. Wenga ujipanga kuwa wa nyai?” ");
INSERT INTO ndg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kanyangwa, “Mana itei nalowa kuitukuza mwene, utukufu wango ni bure; Tate bango ywanitukuza-yolo mwamum'bayite kuwa ni Nnongo winu. ");
INSERT INTO ndg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mwenga mwamyowa kwaa ywembe, lakini nenga namyowa ywembe. Mana itei nibayite,'nimtangite kwaa,' nalowa pangilwa kati mwenga, nambocho. Hata nyoo, nimtangite na maneno yake nigakamwile. ");
INSERT INTO ndg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tate yinu Ibrahimu atishangilia yatikulibona lisoba lyango, aibweni na atipulaika.” ");
INSERT INTO ndg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayahudi kabammakiya, “Uikite kwaa umri wa miaka hamsini bado, ni wenga umweni Ibrahimu?” ");
INSERT INTO ndg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu kammakiya, “Amini, amini, nakumakiya, kabla Abrahamu abelekwile kwaa. NENGA NIBILE.” ");
INSERT INTO ndg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nga kabalokota maliwe bapala kumpumunda, lakini Yesu atikuificha ni kuboka panja ya hekalu. ");
INSERT INTO ndg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Palyo, kati Yesu kapeta, amweni mundu ipofu tangu kubelekwa kwake. ");
INSERT INTO ndg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Anapunzi bake kabannaluya, “Rabi, nyai ywapangite sambi, mundu yoo au wazazi bake, hata abelekwile ipofu?” ");
INSERT INTO ndg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kannyangwa, “Ayoo mundu kwaa wala azazi bake bapangite sambi, ila kazi ya Nnongo ipalikwe kuyogoliwa petya kwake. ");
INSERT INTO ndg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yatupasa kupangakazi zake ywembe ywanitumile muda bado ni mutwekati. Kilo chaisa wakati wabile ntopo ywaweza panga kazi. ");
INSERT INTO ndg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Wakati wanibile mu'ulimwengu, nenga na bweya ya ulimwengu.” ");
INSERT INTO ndg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Baada ya Yesu baya maneno aga, alitema pa nnema, apangite litope lya mate, ni kumpaka yolo mundu kuminyo lile litope. ");
INSERT INTO ndg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kammakiya, uyende kuoga mu'lose lya Siloamu(ititafsirilwa kati 'ywaatumilwe').”Kwa eyo mundu yoo atiyenda, ni kunawa ni kubuyangana, atibona. ");
INSERT INTO ndg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Majirani wa mundu yoo ni balo bamweni mwanzo kati mwambaji kababaya, Je! ayoo nga yolo kwaa mundu ywabile atama na loba?” Benge kababaya, “Ni ywembe.” ");
INSERT INTO ndg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na benge babaya “yolo kwaa, ila afanana ni ywembe.”Lakini ywembe abaya, “Ni nenga.” ");
INSERT INTO ndg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kabammakiya, “Nambeambe minyo gako gayongolilwa namani?” ");
INSERT INTO ndg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kayangwa, mundu ywakemelwa Yesu apangite litope ni kulibeka mu minyo gango ni kunibakiya, “Yenda Siloamu unawe.” Kwa eyo natiyenda, ninawite, nga nipalike kubona kae,” ");
INSERT INTO ndg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kamammakiya “Abile kwaako?” Kayangwa, “Ndangite kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kabampeleka mundu yolo ywabile ipofu kwa Mafarisayo. ");
INSERT INTO ndg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lyabile lisoba lya Sabato palyo Yesu apangite litope ni kun'yongolya minyo gake. ");
INSERT INTO ndg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nga kae Mafarisayo kabannaluya apatike kinamani bona. Kaamakiya, “Abekite litope mu'minyo gango, ninawite, nambeambea naweza bona.” ");
INSERT INTO ndg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Baadhi ya Mafarisayo kababaya, “Mundu yoo abokite kwaa kwa Nnongo kwa mana aikamwi Sabato.” Benge babayite, “Iwezekana kinamani mundu ywabile ni sambi kupanga ishara kati yee?” Kwa eyo kwabile na mgawanyiko nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nga kabannaluya yolo ipofu kae, “Ubaya kele nnani yake kwa sababu akuyongoli minyo gako?” Ipofu kabaya, “Ni nabii.” ");
INSERT INTO ndg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hata muda woo Ayahudi bamwamini kwaa kuwa abile ipofu ni ywembe apatike bona mpaka kabakema azazi bake ywembe ywapatike kubona. ");
INSERT INTO ndg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kabaanaluya azazi, Je, ayoo nga mwana winu mwamubaya abelekwile ipofu? aweza kinamani kubona?” ");
INSERT INTO ndg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nga azazi bake kabanyangwa, “Tutangite kuwa ayoo ni mwana witu na kuwa abelekwile ipofu. ");
INSERT INTO ndg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kinamani nambeambe atibona, tutangite kwaa, ni ywembe an'yongoliya minyo gake, tuntangite kwaa, Munnaluye mwene, Ni mundu nkolo. Aeza kuielezea mwene.” ");
INSERT INTO ndg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Azazi bake babayite makowe aga, kwa kuwa batiyogopa Ayahudi. Kwa mana Ayahudi babile batikubaliana kuwa, mana itei yoyote ywabaya kuwa Yesu nga Kristo, alowa tengwa mu'sinagogi. ");
INSERT INTO ndg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kwa sababu yee, azazi bake kababaya, “Ni mundu nkolo, munnaluye mwene.” ");
INSERT INTO ndg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kwa eyo kwa mara ya na'ibele, kabankema mundu yoo ywabile ipofu ni kummakiya, Umpei Nnongo utukufu. Tutangite kuwa mundu yoo nga mwene sambi.” ");
INSERT INTO ndg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yolo mundu kaayangwa, “Mana abile ni sambi, nenga nitangite kwaa. Kilebe chimo nikitangite: nabile ipofu, nambeambe nabona.” ");
INSERT INTO ndg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nga kabammakiya, “Akupangie namani? Agayongoli kinamani minyo gako?” ");
INSERT INTO ndg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kanyangwa, “Niabakiye tayari, ni mwenga muyowine kwaa! Kwa namani mpala kuyowa kae? Mwenga mpala kwaa kuwa anapunzi bake kae, kele? ");
INSERT INTO ndg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Batikuntukana no baya, “Wenga nga mwanapunzi bake, lakini twenga ni anapunzi ba Musa. ");
INSERT INTO ndg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tutangite kuwa Nnongo atilongela ni Musa, lakini kwa yolo, tutangite kwaa abokite kwaako. ");
INSERT INTO ndg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yolo mundu kaayangwa ni kuabakiya, “Kwa namani, lee nga likowe lya kushangaza, kuwa mutangite kwaa aboka kwako, na bado aniyongolii minyo gango. ");
INSERT INTO ndg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tutangite kuwa Nnongo aasikilizi kwaa babile ni sambi, lakini mana itei yeyote atikumwabudu Nnongo ni kugapanga mapenzi gake, Nnongo unsikiliza. ");
INSERT INTO ndg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tangu mwanzo wa ulimwengu iyowanika kwaa kuwa kwabile mundu ywa ayongoli mino ga mundu ywa abelekwile ipofu. ");
INSERT INTO ndg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mana itei mundu yoo aboka kwaa kwa Nnongo, kana apange chocho.” ");
INSERT INTO ndg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kabanyangwa no kummakiya, “Ubelekwile ipofu mu'sambi kabisa, na wenga waloa kutupundisha twenga?” Nga kabampukuza kuoma mu'lisinagogi. ");
INSERT INTO ndg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ayowine kuwa batikumwondoa mu'lisinagogi. Ampatike ni kummakiya, “wenda kumwamini Mwana wa mundu?” ");
INSERT INTO ndg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kanyangwa no baya, “Ni nyai, Ngwana, ili ni nenga nipate kumwaminiya?” ");
INSERT INTO ndg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu kammakiya, “Umweni, ni ywembe ywalongela naye nga ywembe.” ");
INSERT INTO ndg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yolo mundu kabaya, “Ngwana, Naamini,” Nga akamsujudia. ");
INSERT INTO ndg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu kabaya, “Kwa hukumu niisile mu'ulimwengu woo ili balo babweni kwaa bapate kubona na balo balo babweni bawe Ipofu.” ");
INSERT INTO ndg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Baadhi ya Mafarisayo babile pamope ni ywembe bayowine maneno ago ni kunnaluya, “Na twenga kae ni ipofu?” ");
INSERT INTO ndg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu kaamakiya, “Kati mutangite ipofu, mwabile kwaa ni sambi. Hata nyoo, nambeambe mwabaya,'Tubweni sambi yinu itamile.” ");
INSERT INTO ndg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Amini, amini naabakiya, yolo ywajingya kwa petya nnango wa zizi lya ngondolo, lakini ywapanda kwa ndela yenge, mundu yoo ni mwii na nnyang'anyi. ");
INSERT INTO ndg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ywembe ywajingii munnango ni ywabachunga wa ngondolo. ");
INSERT INTO ndg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kwa mlinzi wa nnango un'yongolya. Ngondolo kabaliyowa lilobe lyake ni kubakema ngondolo bake kwa maina yabe ni kuaboywa panja. ");
INSERT INTO ndg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Palyo aaboywa panja abo babile bake, utama nnonge yabe, ni ngondolo unkengama, kwa sababu balitangite lilobe lyake. ");
INSERT INTO ndg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bankengamile kwaa ageni lakini badala yake kabamwepuka, kwa kuwa balitangite kwaa lilobe lya ageni.” ");
INSERT INTO ndg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu atibaya kwa mpwano woo kwabe, lakini bayatangite kwaa makowe aga yabile atikugabaya kwabe. ");
INSERT INTO ndg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu kalongela nakwe kae, “Amini, amini, naamakiya, Nenga na nnango wa ngondolo. ");
INSERT INTO ndg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Boti bapitike nnonge yango babile anyang'anyi, lakini ngondolo kabayowine kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nenga na nnango. Yeyote ywajingya petya kwango, atilopolelwa; alowa jingya ndani ni kuboka, ni ywembe ywaipatia malisho. ");
INSERT INTO ndg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwii aisi kwaa bila jiba, na kubulaga. Niisile ili kwamba bapate ukoto ni bawe nabo wanansima. ");
INSERT INTO ndg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nenga na mchungaji mwema. Mchunga mwema uuboywa ukoto wake kwa ajili ya ngondolo. ");
INSERT INTO ndg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mmanda ywaajililwe, nga mchungaji kwaa, ywabile ngondolo nga mali yake kwaa, ugabona mabwaa mwitu kabaisa na hubaleka ni kubatila balo ngondolo. ");
INSERT INTO ndg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na mabwaa mwitu ubataba ni kubatawanya. Utila kwa sababu ni mmanda wa ajililwa na abajali kwaa ngondolo. ");
INSERT INTO ndg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nenga na mchungaji mwema, na niatangite babile wango, nabo babile wango wanitangite nenga. ");
INSERT INTO ndg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tate anitangite, ni nenga nintangite Tate, nenga nalowa kuuboywa ukoto wango kwa ajili ya ngondolo. ");
INSERT INTO ndg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nabile ni ngondolo wenge wabile mulizizi lee. Balo pia, ipalikwa kubaleta, nabo balowa kuliyowa lilobe lyango ili kuwa kubile ni likundi limo na mchungaji yumo. ");
INSERT INTO ndg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ayee nga sababu Tate anipenda: Niuboywe ukoto wango alafu niutole kae. ");
INSERT INTO ndg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ntopo ywautolae kuoma kwango, lakini nenga nauboywa mwene. Nibile na mamlaka ya kuuboywa, na nibile na mamlaka ya kuutola kae. Natilipokya liagano lee boka kwa Tate.” ");
INSERT INTO ndg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mgawanyiko kae uboka nkati ya Ayahudi kwa sababu ya maneno aga. ");
INSERT INTO ndg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Benge babayite, “Abile ni nchela na abile ni uchizi. Kwa namani mwati kunyowanikiya?” ");
INSERT INTO ndg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Benge babayite, “Aga ni mano kwaa ga mundu ywapagawile ni nchela. Nchela lyaweza kwaa yogoliya minyo ga ipofu?” ");
INSERT INTO ndg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nga yabuya Sikukuu ya kuibeka wakfu Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Wabile muda wa mbepo, ni Yesu abile akityanga mu'lihekalu mu'ukumbi ba Selemani. ");
INSERT INTO ndg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bayahudi kabamzunguka na kummakiya, “Mpaka lini alowa kutubeka mu'mashaka? Kati wenga ni Kristo, tubakiye wazi. ");
INSERT INTO ndg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kanyangwa, “Niamakiye lakini muaminiye kwaa. Kazi nizipangite kwa lina lya Tate bango, zatikushuhudia nnani yango. ");
INSERT INTO ndg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Hata nyo muamini kwaa kwa mana mwenga mwa ngondolo wango kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngondolo wango baliyowa lilobe lyango; Naatanga, nabo banikengama nenga. ");
INSERT INTO ndg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Niapeya ukoto wanga yomoka; balowa bulagwa kwaa kamwe, na ntopo hata yumo ywalowa kubatola mu'maboko gango. ");
INSERT INTO ndg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tate bango, ywanipeile, abo, ni nkolo kuliko wenge wote, na ntopo hata yumo ywabile ni uwezo wa kubatola kuoma mumaboko ga Tate. ");
INSERT INTO ndg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nenga na Tate yumo kae. ");
INSERT INTO ndg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kabapotwa maliwe ili kumpondanga kae. ");
INSERT INTO ndg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu kaayangwa, “Niabonekiya kazi yanansima inoite kuoma kwa Tate. Kwa kazi ipi nkati ya yake mwalowa kunikombwa ni maliwe?” ");
INSERT INTO ndg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayahudi kabanyangwa, “Twakukombwa kwaa ni maliwe kwa kazi yeyote inoite, lakini kwa kupulu, kwa mana wenga, wa mundu, uyipanga kuwa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kaayangwa, “Iandikilwe kwaa mu'saliya yinu,'Nibayite, “Mwenga mwa nnongo?” ");
INSERT INTO ndg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mana itei abakemite nnongo. kwa balo babile ni Neno lya Nnongo latikuwaisilya(na maandiko gaweza kwaa tekwanika). ");
INSERT INTO ndg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mwabaya nnani ya yolo ywabile Tate ywamboyile ni kuntuma mu'ulimwengu,'Wenda kupuru', Kwa sababu nibaite,'Nenga na mwana wa Nnongo?' ");
INSERT INTO ndg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Mana itei nipanga kwaa kazi ya Tate bango, muniaminiya kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Hata nyo, mana itei niipanga, hata mana muniaminiya kwaa, muiaminiye kazi ili muweze kuitanga ni kuyowa kuwa Tate abile nkati yango ni nenga nibile nkati ya Tate.” ");
INSERT INTO ndg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kabajaribu kae kuntaba Yesu, lakini atiyenda boka mu'maboko gabe. ");
INSERT INTO ndg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu kayenda zake kae nngambo ya Yordani pandu ambapo Yohana abile atikuabatiza kwanza, ni kutama kwoo. ");
INSERT INTO ndg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bandu baingi kabaisa kwa Yesu. Batiyendelya kubaya, “Yohana apangite kwaa ishara yeyote, lakini makowe yote ayabayite Yohana nnani ya aywoo mundu nga ga kweli.” ");
INSERT INTO ndg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bandu banyansima batikuwamini Yesu kae. ");
INSERT INTO ndg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mundu yumo lina lyake Lazaro ywabile nng'onjwa. Abokite Bethania, ijiji sa Mariamu na dada yake Martha. ");
INSERT INTO ndg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Abile ni Mariamu yolo ywampakile Ngwana Marhamu ni kumputa magolo gake kwa nywili yake, ywabile nnongowe Lazaro ywabile ni nng'onjwa. ");
INSERT INTO ndg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nga dada bake aba batumile ujumbe kwa Yesu ni kubaya, “Ngwana, umlinge yolo ywampendile andaminya.” ");
INSERT INTO ndg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu pabayowa abayite, “Utamwe woo ni wa kiwo kwaa, lakini, badala yake ni kwa ajili ya utukufu wa Nnongo ili kuwa Mwana wa Nnongo apate kutukuzwa pitya utamwe woo.” ");
INSERT INTO ndg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ampendile Martha ni dada bake Lazaro. ");
INSERT INTO ndg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Paayowine kuwa Lazaro ni ntamwe, Yesu atami masoba ibele mahali paabile. ");
INSERT INTO ndg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nga baada ya lee atikuabakiya anapunzi bake, “Tuyende kae uyahudini.” ");
INSERT INTO ndg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Banapunzi kabammakiya, “Rabi, ayahudi babile bakijaribu kukukombwab ni maliwe, ni wenga upala buyangana kwoo kae?” ");
INSERT INTO ndg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kaayangwa, “Mutwekati wabile ni masaa komi ni ibele? Mundu ywaatyanga mutwekati aweza kwaa kuikwala, kwa mana abona kwa bweya lya mutwekati. ");
INSERT INTO ndg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Hata nyoo, mana itei atyanga kilo, alowa kuikwala mana bweya yabile kwaa nkati yake.” ");
INSERT INTO ndg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu abayite makowe aga, ni baada ya makowe aga, kaabakiya, “Rafiki yitu Lazalo agonjike, lakini nayenda ili nipate kumuuluya kuoma mu'lugono.” ");
INSERT INTO ndg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nga anapunzi bake kabankokeya, “Ngwana, kati agonjike, alowa yumuka. ");
INSERT INTO ndg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Muda woo Yesu atilongela habari ya kiwo sa Lazaro, lakini balo batangite alongela nnani ya kugonja lugono. ");
INSERT INTO ndg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nga Yesu kaamakiya wazi, kuwa “Lazaro awile. ");
INSERT INTO ndg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nibile ni puraha kwa ajili yinu, kwamba nibile kwaa kolyo ili mpate aminiya. Tuyende kwake.” ");
INSERT INTO ndg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Bai Tomaso ywakemelwa Pacha, aamakiye anafunzi benge, “Ni twenga tuyende kuwaa mpamo ni Yesu.” ");
INSERT INTO ndg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wakati Yesu aisile, akutike Lazaro tayari abile mu'likaburi lisoba lya nchenche. ");
INSERT INTO ndg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ni Bethania ibile papipi ni Yerusalemu kati kilomita arobaini na tano. ");
INSERT INTO ndg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Baingi nkati ya Ayahudi baisile kwa Martha ni Mariamu kuafariji kwa ajili ya nongo wabe. ");
INSERT INTO ndg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nga Martha ayowine kuwa Yesu andaisa, atiyenda kukwembana naye, lakini Mariamu atiyendelea kutama munyumba. ");
INSERT INTO ndg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha kammakiya Yesu, “Ngwana kati wabile pano, kaka yango alowa waa. ");
INSERT INTO ndg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Hata nambeambe, nitangite kuwa lolote lya ulilobite boka kwa Nnongo, atakupeya.” ");
INSERT INTO ndg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu kammakiya kaka bako alowa yoka kae.” ");
INSERT INTO ndg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha kammakiya, nitangite kuwa alowa yoka mu'ufufuo lisoba lya mwisho.” ");
INSERT INTO ndg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu kammakiya, “Nenga na ufufuo na ukoto; ywembe ywaaminiye, ingawa alowa waa, ywabile nkoto atama; ");
INSERT INTO ndg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ni ywembe ywatama ni kuniaminiya nenga alowa waa kwaa, Uliaminiye lee?” ");
INSERT INTO ndg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Kammakiya, “Eloo, Ngwana naaminiya kwamba wenga ni Kriso, Mwana wa Nnongo, ywembe ywaisa mu'ulimwengu.” ");
INSERT INTO ndg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Paayomwile baya lee, atiyenda kunkema dada yake Mariamu mu'faragha. Kabaya, “Mwalimu abile pano na akukema.” ");
INSERT INTO ndg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariamu paayowine aga, kauluka upesi no yendya kwa Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","NI yesu paabile bado jingya mu'ijiji, ila abile bado pandu pa akwembine ni Martha. ");
INSERT INTO ndg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nga Ayahudi babile ni Mariamu mu'nyumba na balo babile bakimfariji, pabamweni kauluka upesi ni kuboka panja, kabankengama, bayowine kuwa ayenda kulikaburu ili alele kwoo. ");
INSERT INTO ndg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nga Mariamu, paaikite palyo Yesu abile amweni ni, kutomboka pae ya magolo gake ni kummakiya, “Ngwana, kati wabile pano, nongo wango alowa waa kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu paamweni atilela, ni Ayahudi waisile pamope naye wabile wakilela kae, atiomboleza mu'roho ni kufadhaika; ");
INSERT INTO ndg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kabaya, “Mumgonjike kwaako? Kabammakiya, Ngwana, uise ulole. ");
INSERT INTO ndg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu kalela. ");
INSERT INTO ndg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ayahudi babaya, “Lola yaampendile Lazaro!” ");
INSERT INTO ndg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lakini benge kati yabe babayite, “yolo kwaa, mundu abayongoli minyo ga yolo ywabile ipofu, aweza kwaa kumpanga mundu yoo awile kwaa?” ");
INSERT INTO ndg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nga Yesu, abile akiomboleza mu'nafsi yake kae, kayenda mu'likaburi. Nambeambe labile lipango, na liwe libekilwe nnani yake. ");
INSERT INTO ndg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu kabaya, “Muliboywe liwe.” Martha, dada bake Lazaro, ywembe ywaawile, ammakiye Yesu, “Ngwana, kwa muda woo, yega yake wabile umioza, kwa sababu abile mu'kiwo kwa masoba ncheche.” ");
INSERT INTO ndg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu kaammakiya, “Nenga nikumakiye kwaa ya kuwa, mana uniaminiye, walowa bona utukufu wa Nnongo?” ");
INSERT INTO ndg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kwa eyo batikuliboywa liwe. Yesu atiuluwa minyo gake kunani no baya, “Tate, niakushukuru kwa mana wenda kuniyowa. ");
INSERT INTO ndg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nitangite kuwa unaniyowa mara yoti, lakini nga kwasababu ya bandu bayemi kunizunguka kuwa nialongela aga, ili kwamba bapate kuamini kuwa wenga unitumile. ");
INSERT INTO ndg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Baada ya kubaya nyoo, atilela kwa lilobe likolo, “Lazaro, boka panja!” ");
INSERT INTO ndg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mundu ywabile mu'kiwo abokite panja atabilwe maboko na magolo kwa sanda za kuyikia, na minyo wake utabilwe ni kitambaa,” Yesu kaamakiya, “Mumpunguwe ni kunleka ayende.” ");
INSERT INTO ndg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ayahudi banyansima baisile kwa Mariamu ni kubona Yesu chaakipangite, batikumwaminiya, ");
INSERT INTO ndg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lakini baadhi yabe batiyenda kwa Mafarisayo ni kuamakiya makowe agapangite Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nga akolo ba Makuhani ni Mafarisayo kabakusanyika pamope mu'libaraza no baya, “Tupange namani? Mundu ywoo apanga ishara zanyansima. ");
INSERT INTO ndg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mana itei tunlekite nyoo kichake, bote balowa kumwaaminiya; Arumi walowa isa ni kutola yoti mahali yitu ni litaifa litu.” ");
INSERT INTO ndg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hata nyoo, mundu yumo nkati yabe, Kayafa, ywabile kuhani nkolo mwaka woo, kaamakiya, “Mutangite kwaa chochote kabisa. ");
INSERT INTO ndg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Muwasa kwaa kuwa ipalikwa faa kwa ajili yinu kuwa mundu yumo apangika kuwaa kwa ajili ya bandu kuliko litaifa lyoti angamiya.” ");
INSERT INTO ndg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Agabaya aga kwa sababu yake mwene, badala yake, kwa kuwa abile ni kuhani nkolo mwaka wolo, atitabiri kuwaYesu alowa waa kwa ajili ya litaifa; ");
INSERT INTO ndg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ni kwa taifa kwaa kichake, ila Yesu apatike nyonyonyo kubakusanya bana ba Nnongo babile batitawanyika sehemu mbale mbale. ");
INSERT INTO ndg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kwa eyo kuoma lisoba lee ni kuyendelya kabapanga namna ya kum'bulaga Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yesu atyanga kwaa wazi wazi nkati ya Ayahudi, ila atiboka palyo no yenda nnema yabile papipi ni lijangwa mu'ijiji ikemelwa Efraimu. Atami palo ni anapunzi. ");
INSERT INTO ndg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pasaka ya Ayahudi yabile papipi, na banansima batiyenda Yersalemu panja ya mji kabla ya Pasaka ili bapate kuitakasa bene. ");
INSERT INTO ndg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Babile bakinkengama Yesu, ni kulongela kila yumo babile bayemite mu'lihekalu, “Muwasa namani? kuwa alowa isa kwaa mu'sikukuu?” ");
INSERT INTO ndg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wakati woo akolo ba makuhani ni Mafarisayo babile batiboya amri kuwa mana itei yumo atangite paabile Yesu, apalikwa kubapea taarifa ili bapate kuntaba. ");
INSERT INTO ndg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Siku sita kabla ya Pasaka, Yesu kayenda Bethani kwa abile Lazaro, ywembe ywabile atikumfufua boka mu kiwo. ");
INSERT INTO ndg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bai kabamwandalia chakulya cha kitamwinyo, ni Martha atikuntumikya, wakati woo Lazaro abile yumo wa balo batamile mu'chakulya pamope ni Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Boka po Mariamu atitola rati ya manukato gapangitwe kwa nardo safi, yabile ya thamani ngolo, atikumpaka Yesu mumagolo, ni kunputa magolo kwa nywili yake; nyumba yoti yatinungya harufu ya galo manukato. ");
INSERT INTO ndg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuda Iskariote, yumo ywa balo anapunzi bake, ywabile nga ywaamsaliti Yesu, kabaya, ");
INSERT INTO ndg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwa mwanja namani manukato aga gapemewa kwa dinari mia tatu ni kuapeya maskini?” ");
INSERT INTO ndg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ni ywembe ywabaya ago, nga kwa kubahurumia kwaa maskini, ila kwa sababu abile mwii: ywembe nga ywakamwile mpuko wa mbanje ni abile atitola baadhi ya ibekwile moo kwa ajili yake mwene. ");
INSERT INTO ndg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu abayite, “Nleke abeke chaabile nacho kwa ajili ya lisoba lya masiko yango. ");
INSERT INTO ndg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Maskini mwabile nabo masoba yoti; lakini mwatama kwaa ni nenga masoba yoti.” ");
INSERT INTO ndg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bai kipenga kikolo sa ayahudi bayowine kuwa Yesu abile kwoo, nabo baisile, kwa ajili ya Yesu, ili bamlole ni Lazaro ywamfufue Yesu kuoma mu'kiwo. ");
INSERT INTO ndg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Na akolo wa Makuhani kabapanga shauri ili wamukage Lazaro; ");
INSERT INTO ndg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mana kwa ajili yake banyansima mu'uyahudi batiyenda na kumwaminiya Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na lisoba lya ibele kipenga kikolo sa bandu saisile mu'sikukuu. Kabaypwine kuwa Yesu andaisa Yerusalemu, ");
INSERT INTO ndg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kabatola matawi ya nkowa wa ntende ni kuoma panja kuyenda kumlaki ni kukombwa lilobe, “Hosana! Atibarikiwa ywembe ywaisa kwa lina lya Ngwana, Mpwalume wa Israeli.” ");
INSERT INTO ndg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu ampatike mwana mponda ni kumpanda: kati yaiandikilwe, ");
INSERT INTO ndg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kana uyogope, binti Sayuni; linga. Mpwalume bako andaisa, atikumpanda mwana mbonda.” ");
INSERT INTO ndg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Anapunzi bake baelewite kwaa makowe aga apo kwanza; lakini Yesu paatukuzwe, nga kabakombokya ya kuwa makowe aga gatiandikilwa ywembe na ya kuwa bapangite makowe aga kwake. ");
INSERT INTO ndg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bai lelo likundi lya bandu babile pamope ni Yesu wakati paakemile Lazaro kuoma mu'likaburi, kabashuhudia kwa wenge. ");
INSERT INTO ndg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Na yabile kwa sababu yee kuwa likundi lya bandu baisile kumlaki kwa sababu bayowine kuwa aipangite ishara yee. ");
INSERT INTO ndg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafarisayo kababakiyana bene kwa bene, “Linga nambeambe muweza kwaa kupanga lolote; linga ulimwengu uyendike kwake.” ");
INSERT INTO ndg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nambeambe baadhi ya Ayunani babile nkati ya balo babile batiyenda ku'sikukuu. ");
INSERT INTO ndg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aba kabamwendea Filipo, ywabile aboka Bethsaida ya Galilaya, kabanloba bakibaya, “Ngwana, twenga twatamaniya kumwona Yesu.” ");
INSERT INTO ndg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo kayenda kummakiya Andrea; Andrea ni Filipo kabayenda kummakiya Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu kaayangwa ni kubaya, “Saa iikite kwa ajili ya mwana wa Adamu kutukuzwa. ");
INSERT INTO ndg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Amini, amini, naabakiya, chembe ya ngano mana itei itomboka kwaa mu'nnema na waa, utama nyonyonyoo kichake; ila mana itiwaa, ipambika matunda ganyansima. ");
INSERT INTO ndg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ywembe ywaupenda uhai wake alowa kuupoteza; ila ywembe ywauchukyanga uhai wake mu'ulimwengu woo alowa kuusalimisha hata ukoto wange yomoka. ");
INSERT INTO ndg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mundu yoyote ywanitumikiya nenga, na anikengame, nenga panibile, nga na mmanda wango apalikwa kuwa. Mundu yeyote ywanitumikiya, Tate alowa kumweshimu. ");
INSERT INTO ndg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Nambeambe roho yango itifadhaika; nenga nabaya kinamani?'Tate unilopwe mu'saa yee?' Lakini ni kwa kusudi lee niikite saa yee. ");
INSERT INTO ndg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tate, ulitukuze lina lyako,” Boka po lilobe liisile kuboka kumaunde no baya, “Natikulitukuza na nenga natikulitukuza kae.” ");
INSERT INTO ndg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bai bandu bayemite papipi ni ywembe kabayowa ni kubaya kuwa kwabile ni ngurumo. Wenge watibaya, “Malaika atilongela na ywembe.” ");
INSERT INTO ndg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu kaayangwa no baya, “Lilobe lee lyaisilee kwaa kwa ajili yango, ila kwa ajili yinu. ");
INSERT INTO ndg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nambeambe hukumu ya ulimwengu woo ibile: Nambeambe nkolo wa ulimwengu woo alowa tekwanilwa panja. ");
INSERT INTO ndg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na nenga mana niinuliwe nnani ya nnema, nalowa kuwavuta woti kwango.” ");
INSERT INTO ndg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Atibaya nyoo akibabonekeya aina ya kiwo alowa waa. ");
INSERT INTO ndg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bandu kabanyangwa, “Twenga tuyowine mu'saliya ya kuwa Kristo alowa tama hata milele. Ni wenga wabaya kinamani, “Mwana wa Adamu lazima ainulilwe kunani? Ayoo mwana wa Adamu ywa nyai?” ");
INSERT INTO ndg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Bai Yesu kaamakiya, “Bweya ibile pamope ni mwenga muda nchunu. Muyendeli maadamu mubile ni bweya, ili libendo kana liise kwaa kubaweza. Ywembe ywayenda mu'libendo atangite kwaa paaayenda. ");
INSERT INTO ndg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mwabile mu'bweya, muiamini bweya yee ili mpate kuwa bana ba bweya.” Yesu kaabaya aga na boka poo kayenda kuificha kna bamweni. ");
INSERT INTO ndg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ingawa Yesu apangite ishara zanyansima namna yee nnonge yabe, bado bamwaminiye kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ili litimye neno lya nabii Isaya, abayite: “Ngwana, ywa nyai ywa sadiki habari yitu? Ni luboko lwa Ngwana atifunulilwa nyai?” ");
INSERT INTO ndg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nga sababu bembe baaminiye kwaa, maana Isaya abayite kae, ");
INSERT INTO ndg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Atikwapanga ipofu mu minyo yabe, na aipangite mioyo yabe migumu, ili bamweni kwaa mu'minyo yabe ni kuyatanga kwa mioyo yabe, ni kabalopolelwa ni nenga kuwaponya.” ");
INSERT INTO ndg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya abayite maneno ago kwa kuwa aubweni utukufu wa Yesu ni atilongela habari zake. ");
INSERT INTO ndg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Lakini hata akolo banansima batikumwamini Yesu; ila kwa sababu ya Mafarisayo, kabakiri kwaa ili kana batengwe na lisinagogi. ");
INSERT INTO ndg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bapendike sifa za bandu kuliko sifa zibokite kwa Nnongo ");
INSERT INTO ndg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu kakombwa lilobe no baya, “Ywembe ywaaniminiye nenga, aniaminiye kwaa nenga kichangu ila ni ywembe ywanitumile nenga. ");
INSERT INTO ndg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ni ywembe ywaanibona nenga ambona ni ywembe ywaanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nenga niisile kati bweya ya ulimwengu ila kila mundu ywaniaminiye nenga atame kwaa mu'libendo. ");
INSERT INTO ndg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mana itei mundu ywoywoti ywaayowine maneno yango lakini kana agakamwe, nenga nalowa kumhukumu; mana niisile kwaa kuhukumu ulimwengu ila kuulopwa ulimwengu. ");
INSERT INTO ndg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yeyote ywanipala kwaa nenga kana ayakubali maneno yango, abile ni ywamuhukumu: neno lee nalibayite nga lalowa kumhukumu lisoba lya mwisho. ");
INSERT INTO ndg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mana nenga nabaya kwaa kwa nafsi yango kae. Ila ni Tate ywanipeleki, ywembe mwene ywanitumile kugabaya yanilongela. ");
INSERT INTO ndg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nenga nitangite ya kuwa liagizo lyake ni ukoto wangeyomoka; bai ayoo niyabayite nenga-kati Tate anibakiye, nga nenga nibayite kwabe.” ");
INSERT INTO ndg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nambeambe kabla ya sikukuu ya Pasaka, kwa kuwa Yesu atangite kuwa saa yake iikite ambayo ataboka mu'dunia yee kuyenda kwa Tate, abile atikuwapenda bandu bake ambao wabile mu'dunia, awapendike muno. ");
INSERT INTO ndg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na nchela abile atibekwa tayari mu'mwoyo wa Yuda Iskariote, mwana wa Simoni, kumsaliti Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu atangite kuwa Tate abekite ilebe yoti mu'maboko yake ni kuwa abokite kwa Nnongo ni abile atiyenda kae kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Atiuluka mu'chakulya ni kuitandaza pae ngobo yake ya panja. Boka po katola litaulo na kuitaba mwene. ");
INSERT INTO ndg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Boka po kabeka mase mu'libakuli ni katumbwa kuwa osha magolo anapunzi bake ni kuiputa ni litaulo lyabile ajitabile mwene. ");
INSERT INTO ndg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kaisa kwa Simoni Petro, ni Petro kammakiya, “Ngwana, upala kuniosha magolo gango?” ");
INSERT INTO ndg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kannyangwa ni kummakiya, “Ulitangite kwaa nambeambe lanilipangite, lakini walowa yowa baadae.” ");
INSERT INTO ndg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petro kammakiya, “Uweza kwaa kuniosha magolo gango kamwe,” Yesu kannyangwa, “Mana itei nalowa kukuosha kwaa, kana ubile ni mahali pamope na nee.” ");
INSERT INTO ndg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petro kammakiya, “Ngwana, kana unioshe magolo gango kichake, ila pia maboko ni ntwe wango.” ");
INSERT INTO ndg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu kaabakiya, “Yeyote ywabile ayomwi kuoga aitaji kuoga kae ila magolo gake, ni ywabile safi yega yake yoti, mwenga mwabile safi, lakini mwenga kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kwa mana Yesu atangite ywa apala kumsaliti; yee nga sababu abayite, mwote kwaa mwabile safi.” ");
INSERT INTO ndg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wakati Yesu abile atikuwabonikiya magolo gabe ni paaikite tola ngobo yake ni tama kae, atikwabakia, “Je Mutangite chelo chabile niapangia mwenga? ");
INSERT INTO ndg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mwanikema nenga, “Mwalimu” ni Ngwana yee mwabaya kweli, maana nibile nyoo. ");
INSERT INTO ndg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mana itei nenga Ngwana na Mwalimu, natiwaosha magolo yinu, mwenga pia iapalikwa kuwaosha wenge magolo yinu, mwenga pia iapalikwa kuaosha benge magolo. ");
INSERT INTO ndg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kwa kuwa natikuwapeya mpwano ili kuwa mwenga kae mpange kati nenga nipangite kwinu. ");
INSERT INTO ndg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Amini, amini, naabakiya, mmanda nga nkolo kwaa kuliko ngwana wake; wala yolo ywabile atumilwe ni nkolo kuliko yolo abile mmanda. ");
INSERT INTO ndg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mana itei uyayowine makowe aga, ubarikilwe kugapanga. ");
INSERT INTO ndg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nabaya kwaa kuhusu mwenga mwa bote, kwa kuwa naatanga balo ambao niachawile-ila nabaya aga ili kuwa maandiko gaweze kutimia:'Ywembe ywa lyaa mkate wango atikuniinua isigino sake.' ");
INSERT INTO ndg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Niabakiye lee nambeambe kabla ipangite nyoo ili kwamba mana lipangike, muweze kuaminiya kuwa nenga nga YWEMBE. ");
INSERT INTO ndg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Amini, amini, naabakiya, ywanipokyange nenga upokya ywabile nimtumile, ni yolo anipokyange nenga umpokya yolo ywanitumile nenga.” ");
INSERT INTO ndg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Palyo Yesu abayite aga, atisumbuka muno mu'nafsi gake, atishuhudia no baya, “Amini, amini, niabakiya kuwa yumo winu alowa kunisaliti.” ");
INSERT INTO ndg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Anapunzi bake kabalokiana, kabashangala ni kwa ajili ya nyai ywalongela. ");
INSERT INTO ndg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pabile mu'meza, yumo wa anapunzi bake yatiegama pakifua sa'Yesu yolo ywampendile Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petro annobiye mwanapunzi yoo no baya, “Tubakie ni yupi ywabile kwake ywamlongela.” ");
INSERT INTO ndg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mwanapunzi yolo ywabile egama pa'kifua sa Yesu na kam'bakiya, “Ngwana, ywa nyai?” ");
INSERT INTO ndg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Boka po Yesu kanyangwa, “Ni kwake yolo nipalae chovya ipande ya mikate ni kumpeya.” Nga nyoo paabile chovya mkate, atikumpeya Yuda mwana wa Simoni Iskariote. ");
INSERT INTO ndg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na baada ya mkate, nchela atikun'jingya. Boka po Yesu kammakiya, “chelo chabile ukipala kukipanga ukipange upesi.” ");
INSERT INTO ndg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nambeambe ntopo mundu mu'meza ywatangite sababu ya Yesu kubaya likowe lee kwake. ");
INSERT INTO ndg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Baadhi yabe balidhani kuwa, kwa sababu Yuda akamwile mfuko wa mbanje, Yesu kammakiya, “Upemeye ilebe twavipala kwa ajili ya sikukuu,” au kwamba apalikwa kuboywa ilebe kwa maskini. ");
INSERT INTO ndg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Baada ya Yuda kutola mkate, atiboka panja haraka mana ibile kilo. ");
INSERT INTO ndg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Palyo Yuda paabile atiboka, Yesu abayite, “Nambeambe mwana wa Adamu atitukuzwa, ni Nnongo atitukuzwa nkati yake. ");
INSERT INTO ndg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nnongo atikumtukuza mu'ywembe mwene, ni alowa kumtukuza upesi. ");
INSERT INTO ndg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bana achunu, nabile pamope ni mwenga kitambo kichunu. Mwanipala, ni kati natikuabakia Ayahudi.'Paniyenda, muweza kwaa kuisa.'nambeambe niabakiya mwenga, pia. ");
INSERT INTO ndg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Natikuwapea amri yambeambe, kwamba mupendane; kati nenga nabile natikuapenda mwenga, nyonyonyo mwenga pia iapalikwa kupendana mwenga kwa mwenga. ");
INSERT INTO ndg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kwa ajili ya lee bandu kabayowa kuwa mwenga mwa anapunzi bango, mana itei mwabile ni upendo kwa kila yumo ni ywenge.” ");
INSERT INTO ndg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petro kammakiya, “Ngwana, uyenda kwaako?” Yesu kaanyangwa, “Pandu natiboka nambeambe uweza kwaa kunikengama, lakini mwalowa kunikengama baadae.” ");
INSERT INTO ndg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro atikumbakiya, “Ngwana, kwa mwanja namani nikukengame kwaa hata nambeambe? Nenga nalowa kugaboywa maisha gango kwaajili yako.” ");
INSERT INTO ndg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu kanyangwa, “Je walowa kugaboywa maisha yako kwaajili yango? Amini amini niakubakiya, jogoo abeka kwaa kabla kunikanikya kwaa nenga mara tatu.” ");
INSERT INTO ndg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kana uuruhusu mwoyo wako kuwa mu'mahangaiko. Umwaminiya Nnongo niaminiye ni nenga. ");
INSERT INTO ndg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mu'nyumba ya Tate bango kwabile na makazi ganansima ya tama; kati yaibile kwaa nyoo, nabile natikwaminiya, kwa mwanja nayenda kuandalia pandu kwa ajili yako. ");
INSERT INTO ndg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kati nalowa yenda ni kuaandalia mahali, nalowa isa kae kuwa karibisha kwango, ili palyo nanibile ni mwenga mube mpamo ni nenga. ");
INSERT INTO ndg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mutangite ndela ya pandu nilowa boka.” ");
INSERT INTO ndg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaso ammakiye Yesu, “Ngwana, tutangite kwaa mahali pa tuyenda; Je! Twaweza kuitanga ndela? ");
INSERT INTO ndg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu kammakiya, “Nenga na ndela, kweli, ni ukoto; ntopo ywaweza kuisa kwa Tate bila pitya kwango. ");
INSERT INTO ndg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kati mwamunitangite nenga, mwalowa kuntanga ni Tate bango pia; nambeambe ni kuyendelya mwani tanga na mumbwenile ywembe.” ");
INSERT INTO ndg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo atikum'bakiya Yesu, “Ngwana, na eyo yaliwa kupangika yatutosha.” ");
INSERT INTO ndg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu kammakiya, “Niisile kwaa pamope ni mwenga kwa muda mrefu, ni bado unitangite kwaa nenga, Filipo? Yeyote ywanibweni nenga mweni Tate; mwanja namani wabaya,'Tubonekeye Tate'? ");
INSERT INTO ndg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Muaminiye kwaa kuwa nenga nibile nkati ya yango? Maneno yanilongela kwinu nigabaya kwaa mu'makusudi gango mwene; badala yake, ni Tate ywatama nkati yango ywapangite kazi yake. ");
INSERT INTO ndg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Niaminiye nenga, kuwa nibile nkati ya Tate, ni Tate abile nkati yango, kadhalika niamini nenga kwa sababu ya kazi yango. ");
INSERT INTO ndg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Amini, amini, niabakiya, ywembe ywaniaminiye, nenga yaniipangite, alowa kuipanga kazi yee kae; na napanga kazi ngolo kwasababu nalowa kuyenda kwa Tate. ");
INSERT INTO ndg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chochote cha mukiloba mu'lina lyango, nalowa kulipanga ili Tate aweze tukuzwa nkati ya mwana. ");
INSERT INTO ndg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kati mwamuloba kilebe chochote mu'lina lyango, alee nilowa kulipanga. ");
INSERT INTO ndg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kati mwamunipendile, mwalowa kuikamwa amri yango. ");
INSERT INTO ndg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na nalowa kumloba Tate, Ni ywembe alowa kuapeya Msaidizi ywenge ili kuwa aweze kuwa pamope ni mwenga milele, ");
INSERT INTO ndg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Roho wa kweli. Ulimwengu uweza kwaa kumpokya ywembe kwa sababu mumweni kwaa, au atama pamope ni mwenga abile nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Naaleka kwaa peke yinu; Nalowa isa kwinu. ");
INSERT INTO ndg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kwa muda nchunu, ulimwengu unibonikeya kwaa kae, lakini mwenga mwanibweni. Kwa sababu natama, ni mwenga mwalowa tama kae. ");
INSERT INTO ndg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nkati ya lisoba lee mwaatanga kuwa nenga nibile nkati ya Tate, na kuwa mwenga mwabile nkati yinu, na kuwa nenga nibile nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yeyote ywaikamwile amri yango ni kuipanga, nga yumo ywanipenda nee; ni ywanipenda nenga alowa pendwa ni Tate bango, na nalowa kumpenda na nalowa kuibonekeya nenga mwene kwake.” ");
INSERT INTO ndg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda (Iskariote kwaa) kammakiya Yesu, “Ngwana, Je! chalopangika kinamani ili kuibonekeya wa mwene kwitu na ni kwa ulimwengu kwaa? ");
INSERT INTO ndg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kanyangwa ni kumbakiya, “Kati yeyote ywanipendae, alowa kulikamwa neno lyangi, Tate bango alowa kumpenda, ni tuisa kwake ni kupanga makao yitu pamope ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yeyote ywanipendi kwaa nenga, akamwi kwaa aneno yango. Neno lyabile mwaliyowa lyango kwaa ila lya Tate ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Niabayite makowe aga kwinu, wakati bado natama nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Hata nyoo, Mfariji, Roho Mpeletau, ywabile Tate alowa kumtuma kwa lina lyango, alowa kuapundisha makowe yoti na alowa kuapanga mumkombokii yoti yaniabaya kwinu. ");
INSERT INTO ndg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Amani niapeya amani yango mwenga. Niapeya kwaa lee kati ulimwengu uboywite. Kana muipange moyo yinu kuwa ni mahangaiko, ni woga. ");
INSERT INTO ndg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Muiyowine yee niabakiya,'Nalowa kuyenda zango, na nalowa isa kwinu.'Kati mwamunipendile nenga, mwabile ni puraha kwa sababu nayenda kwa Tate, kwa kuwa Tate nga nkolo kuliko nenga. ");
INSERT INTO ndg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nambeambe niamakiyange kabla ipangike ili kwamba, wakati yaipangike, muweze kuaminiya. ");
INSERT INTO ndg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nilongela kwaa ni nenga maneno yanyansima, kwa kuwa nkolo wa dunia yee ywaisa. Ywembe abile kwaa ni likakala nnani yango, ");
INSERT INTO ndg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lakini ili kwamba ulimwengu upate kuyowa kuwa nampena Tate, nenga napanga ywaniagizile Tate, kati ywanipeile amri. Muinue, ni tuboke mahali pano. ");
INSERT INTO ndg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nenga na mzabibu wa wolo kweli, na tate bango nga mkulima wa mzabibu. ");
INSERT INTO ndg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila tawi nkati yango lyabile lipambika kwa matunda, ni kulisafisha kila tawi lyabile ulibeleka tunda uliondoa ili kuwa liweze kubeleka muno. ");
INSERT INTO ndg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mwenga tayari mwabile safi kwa sababu ya ujumbe wabile niamakiye tayari. Mtame nkati yango, na nenga nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kati tawi lya liweza kwaa kupambika kichake ilamana ubile mu'mzabibu, kadhalika ni mwenga, mana mutami kwaa nkati yango. ");
INSERT INTO ndg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nenga na mzabibu; mwenga mwa matawi. Ywadumiye nkati yango ni nenga nkati yake, mundu ywoo alowa pambika matunda ganyansima, kwa mana bila nenga muweza kwaa panga likowe lolote. ");
INSERT INTO ndg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mana itei mundu atama kwaa nkati yango, alowa tombokelwa kati tawi ni kukauka; bandu ugakusanya matawi ni kugaboywa mu'mwoto, ni teketea. ");
INSERT INTO ndg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mana itei mwadumu nkati yango, na kati maneno yango yatidumu nkati yinu, mulobe lolote mwamulipala, ni nenga mwalowa pangilwa. ");
INSERT INTO ndg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mu'lee tate bango atitukuzwa, kwamba mwapambika matunda yanyansima ni kuwa ni anapunzi bango. ");
INSERT INTO ndg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kati tate bango ywanipendile nenga pia niapendike mwenga; mudumu mu'lipendo lyango. ");
INSERT INTO ndg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mana itei mwaikamwa amri yango, mwalowa dumu mu'lipendo lyango kati niikamwile amri ya tate bango na kudumu mu'lipendo lyake. ");
INSERT INTO ndg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Niabayite makowe aga kwinu ili kuwa puraha yango ibe nkati yinu ili puraha yinu ipangike kuwa timilifu. ");
INSERT INTO ndg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ayee nga amri yango, kuwa mpendane bene kwa bene kati yaniwapendile mwenga. ");
INSERT INTO ndg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ntopo mundu ywabile ni upendo nkolo kuliko woo, kuwa agaboywe maisha gake kwa ajili ya mbwiga bake. ");
INSERT INTO ndg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mwenga mwa mbwiga bango mwalowa panga goti yaniamakiaye nenga. ");
INSERT INTO ndg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Niakema kwaa amanda ajui chelo chaapangite Ngwana wake. Niakemile mwenga mambwiga, kwa sababu niamakie makowe yoti yabile niayowine kuoma kwa Tate. ");
INSERT INTO ndg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Munichawa kwaa nenga, ila nenga niachawile mwenga ni kuabeka muyende pambika matunda, ni litunda linu lipate tama. Ibile nyoo ili chochote cha mukiloba kwa Tate kwa lina lyango, alowa kuwapeya. ");
INSERT INTO ndg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Makowe aga niaagize mwenga, kuwa mpendane kila mundu ni ywenge. ");
INSERT INTO ndg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kati ulimwengu utabachukia, mtange kuwa unichukiite nenga kabla kubachukia mwenga. ");
INSERT INTO ndg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kati mwabile ba ulimwengu, ulimwengu ulowa kubapenda kati wa kwao. Lakini kwa kuwa mwenga mwa ulimwengu kwaa ni kwa kuwa niachawile kuoma mu'ulimwengu ni kwa ajili yee ulimwengu ubachukyanga. ");
INSERT INTO ndg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mulikombokyange neno lyaniamakiye, “Mmanda nga nkolo kwaa kuliko ngwana wake,'Mana itei balinitesa nenga, walowa kubatesa ni mwenga; kati batikulikamwa neno lyango, bangelikamwa ni lya kwinu. ");
INSERT INTO ndg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mubapangiye makowe aga yoti kwaajili ya lina lyango kwa kuwa muntangite kwaa yolo ywanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mana niisile kwaa ni kuamakiya, bapangite kwaa sambi; lakini nambeambe babile ni udhuru kwa ambi yabe. ");
INSERT INTO ndg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ywanichukyange nenga umchukiya ni Tate. ");
INSERT INTO ndg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mana itei nipangite kwaa kazi nkati ya bembe ambayo ntopo yumo ywaipanga, babile kwaa ni sambi, lakini nambeambe bapangite yoti yanaibele babweni na batinichukyanga nenga ni Tate bango. ");
INSERT INTO ndg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Alee lipangite ili neno litimye ambalo liandikilwe mu'saliya yabe:'Banichukyanga nenga bila sababu.' ");
INSERT INTO ndg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Muda mfariji atiisa, ywabilenimtumile kwinu kuoma kwa Tate, ayee nga, Roho wa kweli, ywabile abokile kwa Tate, alowa kunishuhudia. ");
INSERT INTO ndg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mwenga mwanishuhudia kwa sababu nibile pamope ni nenga tangu mwanzo. ");
INSERT INTO ndg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Niabakie makowe aga ili muweze kwaa kukwazwa. ");
INSERT INTO ndg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Walowa kuwaboywa panja ya sinagogi; hakika saa inda isa yabile kila ywaababulaga alowa waza kuwa apanga kazi inoite kwa ajili ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Balowa kuapangia makowe aga kwa sababu bantangite kwaa Tate wala banitangite kwaa nenga. ");
INSERT INTO ndg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Niabakiye makowe aga ili muda mana uikite wa pangika aga, mwaweza kugakombokya ni namani niabakiye muwese wabe. Niabakie kwaa makowe aga boka mwanzo kwa mana nabile pamope ni mwenga. ");
INSERT INTO ndg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ingawa, nambeambe niyenda kwa yolo ywanitumile; lakini ntopo nkati yinu ywanilaluye, “Uyenda kwaako?” ");
INSERT INTO ndg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwa mana nilongela maneno aga kwinu, uzuni ubile mioyoni mwinu. ");
INSERT INTO ndg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Hata nyoo, naabakiya ukweli; inoyite kwinu mana niboi; kwa kuwa mana niyei kwaa, mfariji aisa kwaa kwinu; lakini mana niyei nalowa kuntuma kwinu. ");
INSERT INTO ndg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mana aisile, aywoo mfariji alowa kuuthibitishia ulimwengu kuhusu sambi, kuhusu haki na husiana na hukumu. ");
INSERT INTO ndg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Husiana na sambi, kwa kuwa baniaminiya kwaa nenga, ");
INSERT INTO ndg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","husiana na haki, kwa kuwa niyenda kwa Tate, na munibona kwaa kae; ");
INSERT INTO ndg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","na husiana na hukumu kwa kuwa nkolo wa ulimwengu woo ahukumilwe. ");
INSERT INTO ndg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nabile na yanyansima kuabakiya, lakini mwalowa kugaelewa kwaa nambeambe, ");
INSERT INTO ndg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lakini, ywembe, Roho wa kweli, mana aisile, alowa kuayongolya mu'ukweli woti; kwa kuwa alongela kwaa kwaajili yake mwene; lakini yoyote ywagayowine, atagabaya makowe ago; ni kugadhihirisha kwinu makowe gaisa. ");
INSERT INTO ndg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ywembe alowa kunitukuza nenga, kwa kuwa alowa kugatola makowe gangu ni kugatangaza kwinu. ");
INSERT INTO ndg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ilebe yoti yaabile nayo Tate ni yango; kwa eyo, nibayite kuwa Roho alowa tola makowe gango ni kugadhihirisha kwinu. ");
INSERT INTO ndg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Bado muda mwipi, mwalowa kunibona kwaa kae, ni baada ya muda mwipi kae, mwalowa kunibona. ");
INSERT INTO ndg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Baadhi ya anapunzi bake kabakokeyana, “Namani atubakiya, “muda mwipi, mwalowa kunibona kae,'na boka po, muda mwipi mwalowa kunibonekeya,'ni kwa kuwa niyenda kwa Tate? ");
INSERT INTO ndg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kwa eyo kababaya, “Ni kilebe gani akibaya,'Bado muda mwipi'? Tutangite kwaa abaya buli.” ");
INSERT INTO ndg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu abweni kuwa bapala kunnaluya, ni ywembe kaabakiya, “Mwailaluya bene kuhusu lee, lyanilibayite,'Bado muda mwipi, munibonekeya kwaa kae; na baada ya muda mwipi mwalowa kunibona'? ");
INSERT INTO ndg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Amini, amini, naabakiya, mwalowa lela ni kulomboleza, lakini ulimwengu walowa puraikia, mwapangilwa kuwa ni huzuni lakini huzuni yinu yalowa galambuka kuwa puraha. ");
INSERT INTO ndg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mwanamke apangilwa kuwa ni huzuni paabile ni uchungu kwa kuwa muda wo beleka uikite; lakini mana abelekile mwana, akombokya kwaa matamwe kwa sababu ya puraha yake kuwa mwana abelekwile mudunia. ");
INSERT INTO ndg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mwenga kae mwabile ni huzuni nambeambe, lakini nalowa kuabona kae; ni mioyo yinu yalowa puraika na ntopo ywaweza kuiboywa puraha yinu. ");
INSERT INTO ndg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Lisoba lyoo mwanilaluya kwaa maswali, Amini. amini, naabakiya, Mukiloba lolote kwa Tate, awapea kwa lina lyango. ");
INSERT INTO ndg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mpaka nambeambe mulobote kwaa lolote kwa lina lyango, mulobe, ni mwenga mwapokya ili puraha yinu ibe kamili. ");
INSERT INTO ndg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nilongela ni mwenga kwa lugha iyowanika kwaa, lakini saa yaisa ambapo nilongela kwaa kwa lugha ieleweka kwaa lakini badala yake nitaamakiya wazi wazi husu Tate. ");
INSERT INTO ndg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lisoba loo mwalowa loba kwa lina lyango, na niabakiya kwaa kuwa nalowa loba kwa Tate kwa ajili yinu; ");
INSERT INTO ndg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kwa kuwa Tate mwene abapendike mwenga kwa kuwa munipendike nenga ni kwa kuwa muaaminiya kuwa niboka kwa Tate. ");
INSERT INTO ndg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nibokite kwa Tate ni kuisa ku'ulimwengu; kae; naboka mu'ulimwengu na kuyenda kwa Tate.” ");
INSERT INTO ndg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Anapunzi bake kabammakiya, “Linga, nambeambe ulongela wazi wazi na utumii kwaa mafumbo. ");
INSERT INTO ndg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nambeambe tutangite kuwa utangite makowe yote, na umpala kwaa mundu yeyote akulaluye maswali. Kwa kuwa lee twaliaminiya kuwa laboka kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kaayangwa, “Nambeambe mwaniaminiya?” ");
INSERT INTO ndg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Linga, saa yaisa, nga hakika iikite, ambapo mwalowa tawanyika kila yumo ni kwabe mwalowa kunileka mwene. Lakini nibile kwaa kichango kwa sababu Tate abile ni nenga. ");
INSERT INTO ndg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Naabakiya makowea aga ili mube ni amani nkati yango. Mu'dunia mwabile ni matatizo, lakini muipeye mwoyo, niushindile ulimwengu. ");
INSERT INTO ndg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu agabayite makowea aga; boka po atiuluya minyo gake kuelekea kumaunde no baya, “Tate saa iikite; umtukuze mwana wako ili ni mwana ni ywembe akutukuze wenga ");
INSERT INTO ndg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kati yaumpeile mamlaka nnani ya yoti yabile ni yega ili abapeye ukoto wangeyomoka balo bote umpeile. ");
INSERT INTO ndg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Awoo nga ukoto wange yomoka: kuwa bakuyowe wenga, Nnongo wa kweli ni wa pekee, ni ywembe ywaumtumile, Yesu Kristo. ");
INSERT INTO ndg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Natikutukuza pano pa'dunia, ni kuiyomwa kazi yaunipeile niipange. ");
INSERT INTO ndg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nambeambe, Tate, untukuze nenga pamope ni wenga wa mwene kwa utukufu wolo wanibile nao pamope ni wenga kabla ya ulimwengu umbilwa. ");
INSERT INTO ndg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Natilifunua lina lyako kwa bandu baunipeile pano pa'dunia. Babile bandu bako; lakini unipeile nenga. nabo balikamwile neno lyako. ");
INSERT INTO ndg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nambeambe batangite kuwa kila kilebe chaunipeile nenga chabokite kwako, ");
INSERT INTO ndg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kwa maneno yaunipeile nenga-niapeile bembe maneno ago. Banipokile na kweli patangite kuwa nenga niboka kwako, na baaminiya kuwa wenga nga ywaanitumile. ");
INSERT INTO ndg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nialobya bembe. Niulobya kwaa ulimwengu ila balo unipeile kwa kuwa bembe ni bako. ");
INSERT INTO ndg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ilebe yoti yaibile yango ni yako, ni ilebe ya ubile nayo wenga ni yango, nenga nalowa tukuzwa kwa ilebe yoo. ");
INSERT INTO ndg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nenga nibile kwaa kae mu'ulimwengu, nenga nambeambe naisa kwako. Tate mtakatifu, ubatunze kwa lina lyako lelo lyaunipeile ile bembe bawe ni umoja, kati nenga na wenga tubile ni umoja. ");
INSERT INTO ndg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Panibile ni bembe, natikubalinda kwa lina lya unipeile; Natikualinda, ni ntopo hata yumo wabe apoteile ila ywa mwana wa upoteu, ili kuwa maandiko gatimye. ");
INSERT INTO ndg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nambeambe naisa kwako; lakini nabaya aga mu'ulimwengu ili puraha yango itimiye mu'ulimwengu nkati yabe wabene. ");
INSERT INTO ndg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niwapeile neno lyako; ulimwengu utikuwachukiya kwa sababu bembe ni ba'ulimwengu kwaa, kati nenga nibile kwaa wa ulimwengu. ");
INSERT INTO ndg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nialobya kwaa uaboywe mu'ulimwengu ila ubalinde ni yolo mwou. ");
INSERT INTO ndg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bembe ni ba dunia kwaa kati nenga nibile kwaa wa ulimwengu. ");
INSERT INTO ndg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uwabeke wakfu kwako mwene mu'kweli, neno lyako nga kweli. ");
INSERT INTO ndg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Unitumile nenga mu'ulimwengu, ni nenga niatumite mu'ulimwengu. ");
INSERT INTO ndg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kwa ajili ya bembe nenga mwene naitoa kwako ili ni bembe wajitoe kwawenga kwa yelo kweli. ");
INSERT INTO ndg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ni aba kae kwaa nialobya, ila ni balo baloa aminiya petya neno lya bembe. ");
INSERT INTO ndg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ili nibembe bawe ni umoja, kati wenga Tate, ubile nkati yango. Nialobya ili ni bembe kae baweze kuwa nkati yitu ili ulimwengu uweze aminiya kuwa wenga nga ywaunitumile. ");
INSERT INTO ndg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Utukufu wolo wa unipeile nenga-niapeile bembe, ili baweze kuwa ni umoja, kati twenga ya tubile ni umoja. ");
INSERT INTO ndg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nenga nkati ya bembe, wenga nkati yango. ili baweze kukamilishwa mu'umoja; ili ulimwengu utange kuwa hakika wenga nga ywaunitumile, ni kuapenda kati wenga waunipendile, nenga. ");
INSERT INTO ndg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tate, chelo cha unipeile nenga-Natamaniya ni bembe kae baweze kuwa pamope ni nenga mahali panibile ili baweze kuubona utukufu wango, wolo waunipeile: kwa kuwa wenga unipendile nenga kabla ya umbilwa kwa misingi ya ulimwengu. ");
INSERT INTO ndg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tate waubile ni haki, ulimwengu ukutangite kwaa wenga, lakini nenga nikutangite wenga, na batangite kuwa unitumile. ");
INSERT INTO ndg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nilipangite lina lyako liyowanike kwabe, na nalowa kulipanga liyowanike ili lelo lipendo lyaunipendile nenga liweze kuwa nkati ya bembe, ni nenga niweze kuwa nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu paayomwile kubaya maneno aga, abokite ni anapunzi bake kuyenda likonde lya Kidron, ambako kwabile ni bustani, ambako ywembe ni anapunzi bake bajingya nkati yake. ");
INSERT INTO ndg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nambeambe yolo Yuda, ywapala kunsaliti, ni ywembe atangite eneo lee, mana Yesu abile akiyenda eneo lee mara kadhaa paabile ni anapunzi bake. ");
INSERT INTO ndg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ni ywembe Yuda, baada kuwa apatike likundi lya askari ni maofisa boka kwa akolo ba makuhani, kababuya babile ni taa, kurunzi ni silaha. ");
INSERT INTO ndg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ni ywembe Yesu, abile atangite kila kilebe chabile kipangika nnani yake, aitokeza nnonge yabe ni kuayangwa, “Nyai mwampala? ");
INSERT INTO ndg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ni bembe kabanyangwa, “Yesu ywanazarethi” Yesu kaabakiya, “Nenga nga ywembe” Ni Yuda kansaliti, abile ayemi pamope ni balo askari. ");
INSERT INTO ndg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kwa eyo paabakiye, “Nenga nga ywembe” kabarudi kunchogo ni kutomboka pae. ");
INSERT INTO ndg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kaalaluya kae, “Nyai ywa mwampala? Ni bembe kabanyangwa kae “Yesu ywanazareth.” ");
INSERT INTO ndg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu kaayabngwa, “Niabakiye kuwa Nenga nga ywembe; kwa eyo kati mwamunipala nenga, mubaleke aba benge bayende. ");
INSERT INTO ndg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aga gabile nyoo ili lelo neno litimye, palo paabayite;”Nkati yabe baunipeile, nampoteza kwaa hata yumo.” ");
INSERT INTO ndg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nga Simoni Petro, ywabile ni lipanga, kauputa ni kunkata likutu la kummalyo mmanda wa Kuhani nkolo. Na lina lyake mmanda yolo libile Malko. ");
INSERT INTO ndg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu kambakiya Petro, “Beka lipanga lyako mu'ala yake. Mwanja namani nikinywee kwa kikombe chelo chaanipeile Tate?” ");
INSERT INTO ndg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Bai lelo likundi lya askari ni ajemedari, ni atumishi ba Ayahudi, bankamwile Yesu ni kuntaba. ");
INSERT INTO ndg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ni bembe kabamwongoza kwanza mpaka kwa Anasi, mana ywembe abile mkwe wa Kayafa, ywabile Kuhani nkolo kwa mwaka woo. ");
INSERT INTO ndg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nambeambe Kayafa nga ywaapeile ushauri Ayahudi ya kuwa impalika mundu yumo awee kwa ajili ya bandu. ");
INSERT INTO ndg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petro ankengamite Yesu, na nyonyonyo mwanapunzi ywenge. Ni mwanapunzi yolo ywabile atangitwe ni kuhani nkolo, ni ywembe kajingya pamope ni Yesu mu'libehewa lya kuhani nkolo; ");
INSERT INTO ndg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Lakini Petro abile ayemi panja ya nnango. Bai yolo mwanapunzi ywabile antangite kuhani nkolo, abokite panja kuyenda longela ni nwawa mmanda ywabile akilinda nnango ili petro ajingii mu'nyumba. ");
INSERT INTO ndg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Bai yolo kijakazi ywabile akilinda nnango, kammakiya Petro, “Je wenga yumo kwaa wa afuasi ba yolo mundu?” Ni ywembe kabaya, “Nenga kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na balo atumishi ni akolo babile bayemi mahali palo; bakokite mwoto kwa mana, pabile ni mbepo, ni nyoo babile bakilota mwoto ili kupata lyoto. Ni ywembe Petro abile nabo, akilota mwoto abile ayemile. ");
INSERT INTO ndg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kuhani nkolo annaluya Yesu nnani ya anapunzi bake ni mapundisho gake. ");
INSERT INTO ndg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu kanyangwa, “Niubakiye waziwazi ulimwengu; nenga natiipundisha mara kwa mara mu'masinagogi ni mu'lihekalu mahali ambapo Ayahudi bakusanyike. Nenga nilongela kwaan lolote mu'siri. ");
INSERT INTO ndg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kwa namani mwatikunilaluya? Mualaluye balo baniyowine nnani ya chalo chanikibayite. Aba bandu batangite makowe yaniabakiye. ");
INSERT INTO ndg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu kaayomwile kubaya nyoo, yumo ywa akolo ayemile ni unkombwa Yesu kwa luboko lwake ni kubaya, “Je, eyo nga ikupasa kunyangwa kuhani nkolo?” ");
INSERT INTO ndg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ni yesu kanyangwa, “mana nilongela likowe lolote linoite kwaa upangike shahidi kwa ajili ya ubou, na mana niyangwite ya inoite mwanja namani kunikombwa? ");
INSERT INTO ndg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nga Anasi kampeleka Yesu kwa Kayafa kuhani nkolo paabile atabilwe. ");
INSERT INTO ndg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nambeambe Simoni Petro abile ayemi akiipasha lyoto. Balo bandu kabammakiya.”Je wenga kae yumo kwaa wa anapunzi bake?” Akani kabaya “Nenga kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yumo wa amanda ba kuhani nkolo, ywabile nongowe yolo nnalume ambe Petro ankatile likutu lyake, kabaya, “Je wenga kwaa ywanim'bonile ni ywembe kolo ku'bustani.” ");
INSERT INTO ndg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petro akani kae, ni mara jogolo kabeka. ");
INSERT INTO ndg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Boka po kabantola Yesu boka kwa Kayafa mpaka kwa Praitorio. Ibile bwamba ni mapema. Bembe bene bajingya kwaa Praitorio ili kana baise najisika ni kuilya pasaka. ");
INSERT INTO ndg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kwa eyo Pilato kaayendea ni kubaya.”Ni lishitaka lyaako lyamuhusu mundu ywoo?” ");
INSERT INTO ndg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kabanyangwa ni kummakiya, “Kati ayoo mundu abile kwaa mpanga mabou, tumletike kwaa kwako.” ");
INSERT INTO ndg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato kaabakiya, “Muntole ni mwenga wene, mukamuhukumu lingana na saliya yinu.” Ni bembe Ayahudi kabammakiya, “Saliya ituruhusu kwaa twenga kum'bulaga mundu ywoywoti.” ");
INSERT INTO ndg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Babayite aga ili neno lya Yesu litimii, neno lyabile alibayite nnani ya aina ya kiwo chake. ");
INSERT INTO ndg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bai Pilato kayingya kae Praitorio kankema Yesu; kammakiya, “Je wenga wa mpwalume wa Ayahudi?” ");
INSERT INTO ndg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kanyangwa, Je wenga unilaluya swali lee kwa sababu upala yowa au kwasababu benge wakutumile kuninaluya nenga?” ");
INSERT INTO ndg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ni ywembe Pilato kanyangwa, “Nenga na Myahudi kwaa, au namani? Taifa lyako na kuhani nkolo nga bakuletike kwango; wenga upangite namani? ");
INSERT INTO ndg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu kanyangwa, “Upwalume wango ni wa ulimwengu wolo kwaa, kati upwalume wango ubile ni pandu mu'ulimwengu amanda wango bangenipigania ili niboyilwe kwaa mu'Ayahudi. Kwa kweli upwalume wango uboka kwa pano” Bai ");
INSERT INTO ndg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato kammakiya, “Je wenga wa mpwalume?” Yesu kanyangwa, “wenga nga wabaya kuwa nenga na mpwalume, kwa sababu yee nenga nibelekwile ni kwa sababu yee nenga niisile mu'ulimwengu ili nipangike kuwa shahidi wa yelo kweli. Yeyote ywaabile wa yelo kweli uliyowanikia lilobe lyango. ");
INSERT INTO ndg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato kammakiya, “Kweli ni namani?” Ni ywembe paayomwile baya aga kayenda kwa Ayahudi ni kuabakiya, “Nilibonya kwaa likosa lyolyote kwa mundu yolo. ");
INSERT INTO ndg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mwenga mwabile ni utamaduni wanipanga nimpungulie mtabilwa yumo muda wa Pasaka. Je mupala nimpungulie mpwalume Ayahudi” ");
INSERT INTO ndg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Boka po bakomwa lilobe kababaya, ayoo kwaa, umpunguli Baraba.”Ni ywembe Baraba abile mwii. ");
INSERT INTO ndg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bai Pilato atikumtola ni kumkombwa. ");
INSERT INTO ndg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Balo askari kabasokota miimwa ni kulichenga litaji. Baibeka nnani ya ntwe wa Yesu ni kun'walisha livazi lya rangi ya dhambarau. ");
INSERT INTO ndg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kabaisa ni kubaya, “Wenga mpwalume wa Ayahudi! ni boka po kunkombwa kwa maboko yabe. ");
INSERT INTO ndg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato kaboka panja ni kuabakiya bandu, “Linga nialetya mundu yoo kwinu ili mutange kuwa nenga niiboniya kwaa hatia yoyote nkati yake.” ");
INSERT INTO ndg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kwa eyo Yesu kaboka panja; abile atiwala litaji lya miimwa ni ngobo ya zambarau. Pilato kammakiya, Mulinge mundu uyu pano! ");
INSERT INTO ndg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kwa eyo muda kuhani nkolo ni akolo pabamweni Yesu, kabakombwa lilobe no baya, “Mmulage, mmulage.” Pilato kaamakiya “Muntole mwenga mwabene mukammulage, kwa kuwa nenga niibweni kwaa hatia nkati yake. ");
INSERT INTO ndg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayahudi kabanyangwa Pilato, “Twenga twabile ni saliya, ni kwa saliya eyo impalika kuwaa kwa sababu ywembe aipangite kuwa mwana wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato paayowine maneno aga ayogopile muno, ");
INSERT INTO ndg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","kayingya Praitorio kae ni kummakiya Yesu, “Wenga uboka kwako? Hata nyo, Yesu anyangwa kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Boka po Pilato kammakiya, “Je wenga ulongela kwaa ni nenga? Je, wenga utangite kwaa kuwa nenga nabile ni mamlaka ga kukuyongoli ni mamlaka ga kukusulubisha?” ");
INSERT INTO ndg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kanyangwa, “Mana ubile kwaa ni likakala dhidi yango kati upeyelwa kwaa boka kunani. Kwa eyo, mundu ywanibokite kwako abile ni sambi ngolo.” ");
INSERT INTO ndg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bokana na lijibu lee, Pilato apala kunneka huru, lkini Ayahudi akombwile lilobe kabaya, “Kati unneka huru baai wenga wa rafiki kwaa ba Kaisari: Kila ywapangaye kuwa upwalume ubaya kunchogo ya Kaisari.” ");
INSERT INTO ndg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato paayowine maneno aga, kamnetya Yesu panja boka atama mu'itego sa hukumu mahali palo payowanike kati sakafu, lakini kwa Kiebrania Gabatha. ");
INSERT INTO ndg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lisoba lya maandalizi lya mashaka yaiikite, pabile muda wa saa ya sita. Pilato aabakiya Ayahudi, “Mulinge mpwalume winu ayoo pano!” ");
INSERT INTO ndg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kabakombwa ndoti, “Mboywe, mboywe, mmulage!” Pilato kaabakiya, “Je, nimmulage mpwalume winu?” N i ywembe kuhani nkolo kayangwa, “Twenga twabile kwaa ni mpwalume ila Kaisari.” ");
INSERT INTO ndg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nga Pilato abapeile Yesu ili bam'bulage. ");
INSERT INTO ndg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ni bembe kabantoloa Yesu, ni ywembe kaboka, abile autweti msalaba wake mwene mpaka ku'lieneo lyakemelwa Fuvu lya ntwe, kwa kiebrania ukemwa Golgotha. ");
INSERT INTO ndg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nga kabamsulubisha Yesu, pamope ni yweme analomea bele, yumo upande wa kummalyo ni ywenge upange wenge, ni Yesu nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Boka po Pilato atiandika alama ni kuibeka nnani ya msalaba. Palyo paandikilwe: YESU YWANAZARETH, MPWALUME AYAHUDI. ");
INSERT INTO ndg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Baingi ba Ayahudi baisomite alama yee mana mahali palyo paasubilishwe Yesu pabile papipi ni mji. Alama yee iandikilwe kwa Kiebrania, kwa Kirumi ni kwa Kiyunani. ");
INSERT INTO ndg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Boka poo akolo ba makuhani ba'Ayahudi kabammakiya Pilato, “Kana uandike,'Mpwalume wa Ayahudi; ila ywembe abayite nenga na mfalme wa Ayahudi.” ");
INSERT INTO ndg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ni ywembe Pilato kanyangwa, “Yaniiandikiye niiandikyange.” ");
INSERT INTO ndg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Baada ya askari kum'bulaga Yesu, kabantola ngobo gake ni kuagawa mu'mafungu ncheche, kila askari lifingu limo, nyonyonyo ni nganju, Nambeambe yelo nganju yabile kwaa itishonwa ila yabile ipumilwe yote boka kunani. ");
INSERT INTO ndg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Boka po kabakokeyana bene kwa bene, “Kana tuipapue ila tuipigiye kura ili kubona yabi ya nyai.” Lee lapangite ili lelo liandiko litimye, lelo lyabaya kabagawana ngobo yango, ni nganju yangu waipigiya kura. ");
INSERT INTO ndg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Askari bapangite makowe aga. Mao bake Yesu, dada wa mao bake, Mariamu nnyumbo bake Kleopa ni Mariamu Magdalena-anwawa aba babile bayemile papipi ni msalaba wa Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu paamweni mao bake pamope ni yolo mwanapunzi bake ywampendile bayemite papipi, kamakiya mao bake, “Nwawa, linga, lola mwana wako ayoo pano!” ");
INSERT INTO ndg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Boka po kammakiya yolo mwanapunzi, “Linga, aywoo pano mao bako.”Boka saa yee yolo mwanapunzi kamtoloa kuyenda munyumba yake. ");
INSERT INTO ndg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Baada ya lelo, Yesu abile atangite kuwa yote yayomwike ili kugatimiza maandiko, kabaya, “Nabona kiu.” ");
INSERT INTO ndg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Iombo yaibile imejaa Siki chabile kibekilwe palyo, kwa eyo bakabeka sifongo yaijaile siki nnani ya ufito wa hisopo, kabambekeya mu'nkanwa wake. ");
INSERT INTO ndg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ni ywembe Yesu aionjile yoo, kabaya, “Iyomwike.” Boka po kaiinamisha ntwe wake, ni kumpeya roho yake. ");
INSERT INTO ndg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kwa kuwa ibile ni muda wa maandalio, na kwa kuwa yega ipalikwa kwaa kubaki nnani ya msalaba muda wa sabato(kwa mana Sabato yabile siku ya muhimu), Ayahudi bamloba Pilato kuwa magolo gake balo babile batisulubishwa itekwanike, ni kuwa yega yabe itombolewe pae. ");
INSERT INTO ndg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nga askari bapaisile ni kugatekwana magolo ga bandu ba kwanza na wa ibele ywabile atisulubiwa pamope ni Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pamuikile Yesu, batimkuta tayari ywabile tayari atiwaa, kwa eyo kabatekwana kwaa magolo gake. ");
INSERT INTO ndg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Hata nyo, yumo wa askari atikunchoma Yesu mu'ubavu wake kwa mkuki, ni mara kababoka mase ni damu. ");
INSERT INTO ndg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni ywembe ywalibonekeya lee aboite ushuhuda, ni ushuhuda bake ni wa kweli. Ywembe ywatangite kuwa chaakibaya ni cha kweli ili mwenga muamini kae. ");
INSERT INTO ndg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Makowe aga gapangite ili litimye lelo lineno lyalibayite lipate timya, “Ntopo hata wake yumo wautekwanike.” ");
INSERT INTO ndg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kae liandiko lyenge gabaya, “Balowa kulinga ywembe ywamchomile.” ");
INSERT INTO ndg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Baada ya makowe aga Yusufu wa Arimathaya, kwa kuwa abile mwanapunzi wa Yesu, lakini kwa siri kwa kuaogopa Ayahudi, atikunloba Pilato kuwa autole yega wa Yesu. Ni ywembe Pilato kampeya Ruhusa. Kwa eyo Yusufu kaisa kuuboywa yega wa Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ni ywembe Nikodemo ywabile hapo awali atikunkengama Yesu kilo ni ywembe kaisa. Ywembe aaletike mchanganyiko wa manemane ni udi, yapata uzito wa ratili mia jimo. ");
INSERT INTO ndg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kwa eyo kabautola yega wa Yesu bautabile mu'sanda ya kitani pamope ni galo manukato, kati yaibile desturi ya ayahudi muda wa kusika. ");
INSERT INTO ndg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mahali ambapo Yesu atisulubilwa pabile ni bustani; nkati ya yelo bustani pabile ni likaburi lyaayambe ambalo ntopo mundu ywabile amewai kusikwa mu likaburi lee. ");
INSERT INTO ndg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bai kwa kuwa yabile ni lisoba lya maandalio kwa Ayahudi, ni kwa nyonyonyo likaburi lyalibile papipi, bai kabam'beka Yesu nkati yake. ");
INSERT INTO ndg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Bwamba lisoba lya kwanza lya wiki, kubele bado ni libendo, Mariamu Magdalena aisile mu'likaburi; abweni liwe lationdolewa pa'libaburi. ");
INSERT INTO ndg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kwa eyo katiila mbio kuyenda ka Simoni Petro ni kwa yolo mwanapunzi ywenge ywampendli Yesu, boka po kaabakiya, “Batikuntola Ngwana mu'likaburi, ni twenga tutangite kwaa palyo ban'gonjike. ");
INSERT INTO ndg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petro ni yolo mwanapunzi ywenge babokite, kuyenda palikabuli. ");
INSERT INTO ndg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bote batitila mpamo; yolo mwanapunzi ywenge atitila kwa kasi muno zaidi ya Petro nakuika mulikaburi wa kwanza. ");
INSERT INTO ndg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","kayema ni kulola mu'likaburi; abweni yelo sanda ya kitani igonjike, lakini ajingya kwaa mulikaburi. ");
INSERT INTO ndg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petro ni ywembe kaisa ni kuyingya nkati ya likaburi. Abweni yelo sanda ya kitani igonjike pae ");
INSERT INTO ndg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ni yelo leso yabile mu'ntwe wake yabile kwaa pamope ni sanda ila yabile igonjike pembeni kichake. ");
INSERT INTO ndg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nga yolo mwanapunzi ywenge ni ywembe paajingii nkati ya likaburi; abweni ni aminiya. ");
INSERT INTO ndg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kwa kuwa mpaka muda woo watangite kwaa maandiko kuwa ipalikwe kuwa Yesu ayoke kae mu'kiwo. ");
INSERT INTO ndg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Boka po anapunzi bayei kae kichabe. ");
INSERT INTO ndg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hata nyoo, Mariamu abile ayemi palikaburi atilela, kaayendeleya kulela ayemite ni kulolekeya mu'likaburi. ");
INSERT INTO ndg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Abweni malaika abele waibe ni sura nyeupe batami yumo pa'ntwe ni yumo mumagolo palyo agonjike Yesu. Ni bembe kaamakiya, “Nwawa, kwa mwanja namani walela?” ");
INSERT INTO ndg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ni ywembe kammakiya, “Kwa sababu batikuntola Ngwana wango, nenga nitangite kwaa bam'bekite kwaako. ");
INSERT INTO ndg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Paayomwile kubaya ago, atikelebuka ni ambweni Yesu abile atiyema. Lakini atangite kwaa kati ayoo abile Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","nI Yesu kam'bakiya, “Mao, kwa mwanja namani ulela? Umpala nyai?” Ni ywembe huku akidhani kuwa ni mtunza bustani kamakiya, “Ngwana, kati wenga utikuntola, nimakiyange umbekite kwaako, ni nenga nalowa kuntola.” ");
INSERT INTO ndg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu kammakiya, “Mariamu.” Ni ywembe atikelebuka ni kummakiya kwa Kiaramu, “Raboni,” ayee nga kubaya, “Mwalimu.” ");
INSERT INTO ndg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu kammakiya, “Kana unikamwe, mana bado niboka kwaa kuyenda kwa tate; ila uyende kwa alongo bango ni kuabakiya kuwa nalowa boka kuyenda kwa Tate yango ambae pia nga Tate winu.” ");
INSERT INTO ndg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariamu Magdalena kaisa kuabakiya anapunzi, “Nimweni Ngwana,” na kuwa ambakiye makowe aga. ");
INSERT INTO ndg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Paiikite kitamwinyo, lisoba lee, lisoba lya kwanza lya wiki, ni nnango wabile utabikwe palo babapunzi babile kabahofia Ayahudi, Yesu aisile ni kuyema nkati yabe ni kuabakiya, “Amani ibe kwinu,” ");
INSERT INTO ndg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Paayomwile baya nyoo atikuwabonekeya maboko yake ni ubau wake. Ni anapunzi pabamweni Ngwana batipurai. ");
INSERT INTO ndg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Boka po Yesu kavamakiya kae, “Amani ibe ni mwenga. Kati ya Tate ywanitumile nenga, nyonyonyo nenga naatuma mwenga.” ");
INSERT INTO ndg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yesu paayomwile kubaya nyoo, atikubavuvia ni kuabakiya, Mumpoki Roho Mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yeyote ywaamsamehe sambi, batisamehelwa; ni balo mwalowa kuwa punguliya balowa pungulilwa.” ");
INSERT INTO ndg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomaso, yumo wa balo komi ni ibele, ywakemelwa Didimas, abile kwaa ni anapunzi benge pa Yesu aisile. ");
INSERT INTO ndg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Balo anapunzi benge bammakiye baadae, “Tumweni Ngwana.” Ni ywembe kaabakiya, “Mana nibweni kwaa alama za misumari mu'maboko gake, na kubeka idole yango mu'alama, ni kuweka maboko gango mu'ubau wake naaminiya kwaa.” ");
INSERT INTO ndg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Baada ya masoba ncheche anapunzi bake babile mu'nyumba kae, ni Thomaso abile mpamo nabo. Muda woo nnango utabilwe Yesu ayemi nkati yabe. No baya, “Amani ibe kwinu.” ");
INSERT INTO ndg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Boka po kammakiya thomaso, beka kidole sako ni ubone maboko gango; wala kana ube wauaminiya kwaa ila uaminiye.” ");
INSERT INTO ndg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ni ywembe Thomaso kanyangwa ni kummakiya, “Ngwana wango ni Nnongo wango.” ");
INSERT INTO ndg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu kammakiya, kwa kuwa unibweni, uaminiya. Batibarikiwa balo baaminiya, bila kunibonekeya. ");
INSERT INTO ndg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu apangite ishara zanyansima nnonge ya anapunzi bake, zabile zaandikwa kwaa mu kitabu chino; ");
INSERT INTO ndg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ila za ziandikilwe ili muweze aminiya kuwa Yesu nga Kristo, mwana wa Nnongo, na kwamba muwe ni ukoto mu'lina lyake. ");
INSERT INTO ndg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Baada ya makowe ago Yesu atikuidhihirisha kae kwa anapunzi bake mu'Bahari ya Tiberia; ayee nga aidhihirisha mwene: ");
INSERT INTO ndg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petro abile pamope ni Thomaso ywakemelwa Didimas, Nathanieli kana ya Galilaya, bana ba Zebedayo ni anapunzi wenge abele ba Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petro kaabakiya, “Nenga niyenda kuvua omba.” Nabo kabammakiya, “Twenga, lae twayenda ni wenga.” Kabayenda ni kujingya mu'ngalaba, lakini kilo chee boti bapatike kwaa chochote, ");
INSERT INTO ndg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bwamba paakite, Yesu ayemite ufukweni, nabo anapunzi batangite kwaa kuwa abile Yesu. ");
INSERT INTO ndg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Boka po Yesu kaabakiya”Ainja, mwabile ni chochote chakulya?” Ni bembe kanyangwa, “Hapana.” ");
INSERT INTO ndg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kaabakiya, “Muuluye wavu upande wa kummalyo wa ngalaba, ni mwenga mwalowa pata kiasi.' Kwa eyo kabauluya wavu ni bembe aweza kwaa kulivuta kae kwa kuwa yabile ni omba wanyansima. ");
INSERT INTO ndg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Bai yolo mwanapunzi ywabile ampendile Yesu kammakiya Petro, “Ni Ngwana.” Ni ywembe Simoni Petro paayowine kuwa ni Ngwana, kaitaba nganju yake(maana abile awala kwaa inoite), Boka po kaitosa mubahari. ");
INSERT INTO ndg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Balo anapunzi bake baisa mu'ngalaba (mana babile kwaa kutalu ni pwani, yapata mita mia jimo boka ufukweni), ni bembe babile bakivuta nyavu zabile zitopii omba. ");
INSERT INTO ndg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Paikite ufukweni, babweni mwoto wa mkala palo nnani yake pabile ni samaki mpamo ni nkate. ");
INSERT INTO ndg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu kaamakiya, “Munnete baadhi ya omba mwamuapatike nambeambe.” ");
INSERT INTO ndg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Bai Simoni Petro atipanda ni kuutola wavu waubile utopii omba akolo, kiasi cha omba 153; japo babile banyansima, ila wavu upapwanike kwaa. ");
INSERT INTO ndg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu kaamakiya, “Muiche mpate kipungwa nkanwa.” Ntopo hata yumo wa anapunzi bake ywathubutu kunnaluya, “Wenga wa nyai?” Batangite kuwa abile Ngwana. ");
INSERT INTO ndg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu kaisa, katola wolo nkate, ni kuapeya, apangite nyonyonyo ni kwa balo omba. ");
INSERT INTO ndg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ayee yaibile mara ya itatu kwa Yesu kuidhihirisha kwa anapunzi bake baada ya boka mu'kiwo. ");
INSERT INTO ndg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Baada ya kuwa batabilwe mikanwa yabe, Yesu kammakiya Simoni Petro, “Simoni mwana wa Yohana je, wanipenda nenga kuliko aba?” Petro kayangwa, “Eloo, Ngwana; Wenga utangite kuwa nenga nakupenga.” Yesu kammakiya, “Balishe wana ngondolo wango.” ");
INSERT INTO ndg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kamakiya mara ya ibele, “Simoni mwana wa Yona, je wanipenda?” Petro kammakiya, “Eloo, Ngwana; wenga utangite kuwa nakupenda.” Yesu kammakiya, “Sunga ngondolo wango.” ");
INSERT INTO ndg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kamakiya kae mara ye itatu, “Simoni mwana wa Yohana, je wanipenda?” Ni ywembe Petro atihuzunika kwa yaammakiye mara ya itatu, “Je wenga wanipenda? Ni ywembe kammakiya, Wenga utangite yote; utangite kuwa nakupenda.”Yesu kammakiya. Ubalishe ngondolo bango. ");
INSERT INTO ndg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Amini amini nakubakiya, paubile muinja ulizoea kuwala ngobo mwene na kuyenda kokote paupala yenda; lakini mana ubile mpindo, walowa nyoosha maboko gako, ni ywenge alowa kukuwalisha ngobo ni kukupeleka upalike kwaa kuyenda.” ");
INSERT INTO ndg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu kabaya nyoo ili kubonekeya ni aina gani ya kiwo ambacho Petro alowa kumtukuza Nnongo. Baada ya kugabaya ago, ammakiye Petro, “Nikengame.” ");
INSERT INTO ndg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petro atikelebuka ni amweni yolo mwanapunzi ywapendilwe ni Yesu atikubakengama-Ayoo nga abile atikuiegemeza mu'kifua sa Yesu wakati wa chakulya cha kitamwinyo ni kunnaluya, “Ngwana, ywa nyai ywapala kukusaliti? ");
INSERT INTO ndg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petro amweni ni kunnaluya Yesu, Ngwana ayoo mundu apanga namani? ");
INSERT INTO ndg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu kanyangwa”Mana nipala abaki mpaka paniisile, lyakuhusu namani?” Nikengame.” ");
INSERT INTO ndg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kwa eyo habari yee ibayilwe nkati ya balo alongo, kuwa mwanapunzi yoo awaa kwaa. Lakini Yesu ammakiya kwaa Petro kuwa mwanapunzi yoo awaa kwaa, “Kati nipala ywembe atame mpaka paniisile yakuhusu namani?” ");
INSERT INTO ndg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ayee nga mwanapunzi ywatoa ushuhuda wa makowe agna nga ywaa aandikile makowe aga, ni tutangite kuwa ushuhuda wake ni kweli, ");
INSERT INTO ndg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kwabile ni makowe yenge yanansima yaapangite Yesu. Kati kila limo mana liandikilwe, ulimwengu wote utosha kwaa kuibeka vitabu vya viandikilwe makowe gake. ");
INSERT INTO ndg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kitabu cha kwaembo nikiandikie, Thefili, kanibaya goti Yesu atumbwi kugapanga na pundisha, ");
INSERT INTO ndg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka lisoba ambayo ywembe atipokelewa kunani. Ayee yabile payapitike amri pitya kwa Roho mtakatifu kwa mitume bayomwile kuwachawaa. ");
INSERT INTO ndg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Baada ya teswa kwake, Jwembe abonekine panga aikoti nathibitika kwanansima kaishuhudia. Kwa masoba arobaini abonekine kasabe na alongela likowe lya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Napabakwembine nabo pamope nabo, abakiye kana babuke Yerusalemu, ila balende kwa ajili ya ahadi ya Tate, bembe, batibaya, “Mwayowine boka kwango ");
INSERT INTO ndg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","panga Yohana alibatiza kabisa kwa mase, lakini ywabatizwa kwa Roho Mtakatifu katika masoba aga machunu.” ");
INSERT INTO ndg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Napabakwembine pamope batikwinaluya, “Ngwana muda go ngawa kelebukeya Israel ufalme?” ");
INSERT INTO ndg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jwembe atikwabakia, lyengo lino mwangali tanga majira ambayo Tate atikusudia kwa mamlaka gake mwene.” ");
INSERT INTO ndg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lakini mwapokya ngupu, wakati walowa icha Roho Mtakatifu kunani yinu na mwenga mwalowa panga masaidi bango mwabote mu'Yerusalemu na Uyahudi yoti na Samalia mpaka mwiso wa nchi.” ");
INSERT INTO ndg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ngwana Yesu payomwile longela goo, pababile kabalolekeya kunani, ywembe apotwilile nnani, na liunde lyatikumwekelya bamweni likae kwa minyo gabe. ");
INSERT INTO ndg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Wakati kabalolekeya kunani kayenda gapula, Bandu abele bayemi pakatikati yabe baweti mangobo mauu. ");
INSERT INTO ndg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Batibaya, “Mwenga mwabandu ba Galilaya, mwanja namani muyema pa kumlolekeya kumaunde?” Ayoo Yesu ywangulwike kunani, alowa buyangana nyonyo kati mwamumweni kayenda kunani. ");
INSERT INTO ndg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ngababuyangana Yerusalemu boka pa kitombe sa Mizeituni, ambao ubile papipi ni Yerusalemu, mwendo wa lisoba lya Sabato. ");
INSERT INTO ndg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pabaikite bayei mughorofa mwabatamage. Na bembe ni Petro, Yohana, Yakobo, Andrea, Filipo, Thomaso, Batholomayo, Mathayo, Yakobo mwana wa Alfayo, Simoni Zelote na Yuda mwana wa Yakobo. ");
INSERT INTO ndg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Boti babile mpamo kati mundu yumo, kwa juhudi babile batiyendelya katika maombi pamope na ago babile anwawa, Mariamu mao gake Yesu, na anja bake. ");
INSERT INTO ndg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Katika masoba ago Petro ayemi katikati ya alongo, kati bandu 120, abaya, ");
INSERT INTO ndg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Alongo, ibile lazima panga maandiko gatimizwe, ambapo zamani Roho Mtakatifu abaya kwa nkanwa wa Daudi husiana na Yuda, ambaye abaelekeza balo bankamwile Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mana ywembe abile yumo witu na apeyilwe lifungu lyake na faida ya ayee huduma.” ");
INSERT INTO ndg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Nambeambe yoo apemite lieneo kichelo chapeyilwe kwa ubaya wake atitumbuka alongwiye ntwee, yega yatipapwanika matumbu panja gatipekanika. ");
INSERT INTO ndg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bote babatamaye Yerusalemu bayowine kuhusu likowe lee, na lieneo lyoo balikemite kwa lugha yabe “Akeldama” ango ni “ngunda wa myai.”) ");
INSERT INTO ndg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Mu kitabu sa Zaburi iandikilwe,” Lenda lenda lieneo lyake ube hame na kana iruhusiwe hata yumo tama palo,'na 'Ruhusa mundu ywenge aitole nafasi ya utawala.' ");
INSERT INTO ndg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ayoo nga muhimu, kwa eyo, yumo wa alalome ambao batiambatana natwenga wakati Ngwana Yesu aboi na kujingya kati yitu, ");
INSERT INTO ndg_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tumbwile mu'ubatizo wa Yohana mpaka lisoba lelo lyapotwilwe kunani, lazima abe shahidi ba ufunuo pamope ni twenga. ");
INSERT INTO ndg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","“Babekite nnongi yabe analome abele, Yusufu ywakemelwa Barnaba, ambae ywakemelwa Yusto na Mathia. ");
INSERT INTO ndg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bembe balobite kababaya, “Wenga, Ngwana, uitangite mioyo ya bandu bote, nga nyoo beka mbolika ywaako kati ya abele aba abachawile ");
INSERT INTO ndg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kuitola nafasi katika huduma na utume, ambayo Yuda apangite ubou na yendya mahali pake.” ");
INSERT INTO ndg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bapigite kura kwa ajili yabe, na kura yatimwangukia Mathia ywabile atibalangilwa pamope na balo mitume komi na jimo. ");
INSERT INTO ndg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Paikite lisoba lya Pentekoste, bote babile pamope sehemu imo. ");
INSERT INTO ndg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ghafla lyapitike limbonga boka kunani kati mbepo kale, ngautweliya nyumba yote mwababile batami. ");
INSERT INTO ndg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hapo kabapitya lulimi, kati lulimi lwa mwoto zatigawanyika, ibile nnani yabe kila yumo wabe. ");
INSERT INTO ndg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bembe bote batwelilwe na Roho Mtakatifu na batumbwile baya kwa lugha yenge, kati yelo Roho atibajalia longela. ");
INSERT INTO ndg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Babile Ayahudi babatamage Yerusalemu bandu ba Nnongo, boka kila litaifa pae ya kumaunde. ");
INSERT INTO ndg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nundumo paziwowanike, likundi lya bandu liisile pamope na babile ni wasiwasi kwa sababu kila mundu bayowine bakilongela kwa lugha yake mwene. ");
INSERT INTO ndg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Batisangala muno, bembe kababaya, “Kweli aba bote balongela Baagalilaya kwaa? ");
INSERT INTO ndg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kwa mwanja namani twayowine, kila yumo katika lugha tubelekilwe nayo? ");
INSERT INTO ndg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Waparthia na Bamedi na Baelamu, na bembe batama Mesopotamia, Uyahudi, na Kapadokia, na katika Ponto na Asia, ");
INSERT INTO ndg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","katika Frigia, Pamfilia, katika Misri, na sehemu ya Libya hata Kirene, na ageni boka Rumi, ");
INSERT INTO ndg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayahudi na baongofu, Bakrete na Baarabu, twayowa bakilongela katika lugha yitu kuhusu kazi ya uweza wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bote babile batishangala na tatanishwa; balongela bembe, “Ayee ibile na maana gani?” ");
INSERT INTO ndg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lakini benge batidhihaki kababaya, “Aba banywile mvinyo wa ayambe.” ");
INSERT INTO ndg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lakini Petro ayemi pamope na balo komi na jimo, ngabendya kaabakiya, “Bandu ba Yudea na bote mwatama pano Yerusalemu, lee liyowanike kwinu, muliyowe kwa makini maneno gango. ");
INSERT INTO ndg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bandu aga batangite kwaa kati yamugawaza, kwa sababu ayee nga bwamba wa saa tatu. ");
INSERT INTO ndg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lakini lee libile latilongelwa pitya kwa nabii Yoeli. ");
INSERT INTO ndg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yalowa katika masoba ga mwisho, Nnongo abaya, napengana Roho bango kwa bandu bote. Bana binu na alombo binu balowa piya unabii, anchembe binu balola maono, na apindo binu walowa lota ndoto. ");
INSERT INTO ndg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nyonyonyo nnani ya batumishi bango ba kale katika masoba ago, naapekaniya Roho wango, bembe balowa tabiri. ");
INSERT INTO ndg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nalowa kuwabonekeya maajabu nnani ya'anga na ishara pae ya dunia, myai, mwoto na mapundisho ga lyoi. ");
INSERT INTO ndg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Liumu lalowa badilishwa na kuwa libendo na mwei kuwa myai, kabla kuisa kwa lisoba likolo na ya ajabu ya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yalowa pangika ya kwanza kila yumo ywabile alikema lina lya Ngwana alowa lopolelwa.' ");
INSERT INTO ndg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bandu ba Israeli, mugayowe maneno aga: Yesu wa Nazareti, mundu ywathibitishwa na Nnongo kwinu kwa matendo ga uweza na maajabu, na ishara ambazo Nnongo pitya ywembe katikati yinu, mana mwenga mwabene mutangite. ");
INSERT INTO ndg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kwa sababu ya mpango waukusidiwa tangu mwanzo, na maarif ga Nnongo apiyilwe na mwenga, kwa maboko ga bandu baarifu, mwatikunsulubisha na kumulaga. ");
INSERT INTO ndg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ywabile Nnongo atikundondobeya, aboyele uchungu wa kiwo chake, kwa sababu iwezekana kwaa kwake kumilikiwa nabo. ");
INSERT INTO ndg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nga nyo Daudi abaya kuhusu ywembe, “Nimweni Ngwana daima nnongi ya minyo bango, ywembe abile luboko lwangi lwa mmaliyo nga nyoo bai nasogezwa kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwa eyo mwoyo wango ubile na puraha na lulimi lwango watipuraishwa. Yega yango kae walowa tama katika ujasiri. ");
INSERT INTO ndg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Uileka kwaa nafsi yango iyende kuzimu, wala uruhusu kwaa Mtakatifu wako kubona uozo. ");
INSERT INTO ndg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wenga utijidhihirisha kwango ndela ya ukoto, walowa nipanga nijae puraha nnongi ya minyo gako.' ");
INSERT INTO ndg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mwalongo, naweza longela kwinu kwa ujasiri kuhusu tate bitu Daudi, ywembe awile na sikwa, na kaburi lyake libile pamope ni twenga hata nambeambe. ");
INSERT INTO ndg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nga nyo abile nabii na atangite kuwa Nnongo atilapa kwa kilapo sake, panga alowa beka yumo katika ubeleki wake katika iteo sa enzi. ");
INSERT INTO ndg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Alibweni lee mapema, na abayite kuhusu ufufuo wa Kristo,'wala abile alekwa kwaa kuzimu ");
INSERT INTO ndg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ayoo Yesu-Nnongo atimfufua, ambaye twenga twabote ni mashahida. ");
INSERT INTO ndg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kwa eyo, abile atiinulilwa katika luboko lwa kummalyo ba Nnongo, na abile atimpokya ahadi ya Roho Mtakatifu boka kwa Tate, Ywembe atimimina ahadi yee, ambaye mwenga mwabona na kuyowa. ");
INSERT INTO ndg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mana Daudi angolwike kwaa yendya kumaunde, lakini abaya,'NGWANA abaya kwa Ngwana wango. ");
INSERT INTO ndg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“Tama luboko lwango lwa kummalyo, mpaka panibapanga maadui bako kigoda kwa ajili ya magolo gako. ");
INSERT INTO ndg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kwa eyo nymba yote ya Israeli na itange kwa hakika panga Nnongo abapangite ywembe kuwa Ngwana na Kristo, yolo Yesu ambaye mwatimsulubisha.” ");
INSERT INTO ndg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pabayowine nyoo, basonywi katika mioyo yabe, kabammakiya Petro na mitume yenge, “Mwalongo, tupange namani?” ");
INSERT INTO ndg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Na Petro kaabakiya, “Muipange toba na Mbatizwe, kila yumo winu, katika lina lya Yesu Kristo kwa ajili ya msamaha wa sambi yinu, na mwalowa pokya zawadi ya Roho Mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mana kwinu ni ahadi na kwa bana binu na kwa balo bote babile kutalu, bandu banyansima kwa kadri Ngwana Nnongo witu paakema.” ");
INSERT INTO ndg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa maneno ganyansima ashuhudia na kubasihi, “Muilopwe boka katika ibeleko yee kiovu.” ");
INSERT INTO ndg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nga kabapokii maneno gake na kaabatiza, hapo kabaongezeka katika lisoba lee kati nafsi elfu tatu. ");
INSERT INTO ndg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kabayendelya katika mapundisho ya mitume na ushirikiano, katika kuumega mkate na katika maombi. ");
INSERT INTO ndg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hofu yaisa nnani ya kila nafsi, na maajabu ganyansima na ishara zapangika pitya mitume. ");
INSERT INTO ndg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bote baaminiya babile pamope na kuwa na ilebe yabembe pamope, ");
INSERT INTO ndg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","na bapemeya ilebe na milki yabe na kugawanya kwa bote lingana na hitaji lya kila yumo. ");
INSERT INTO ndg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nga nyoo lisoba baada ya lisoba kabayendelea babile na lengo limo katika hekalu, na batiumega mkate mu'nyumba, na batishiriki chakulya kwa puraha na unyenyekevu wa mwoyo; ");
INSERT INTO ndg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Batimsifu Nnongo na babile na kibali na bandu bote. Ngwana atibaongeza lisoba kwa lisoba ambao babile batilopolwa. ");
INSERT INTO ndg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pita na Yohana babile banaelekya katika hekalu muda wa maombi, saa tisa. ");
INSERT INTO ndg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mundu fulani, kiwete tangu belekwa, abile alibebwa kila masoba na abile agonjike katika nnango wa hekalu akemwa mzuri, ili aweze kuloba sadaka boka kwa bandu babile bakielezwa mu'lihekalu. ");
INSERT INTO ndg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Abweni Petro na Yohana batikaribia kujingya mu'lihekalu, alobite sadaka. ");
INSERT INTO ndg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petro atimkazia minyo, pamope na Yohana, abayite, “Tulole twenga.” ");
INSERT INTO ndg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kiwete ngamlolekeya, atazamiya kupokya kilebe fulani boka kwa bembe. ");
INSERT INTO ndg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lakini Petro kabaya, “fedha na dhahabu nenga nibile kwaa, lakini chelo nibile nacho naitoa kwako. Katika lina lya Yesu Kristo wa Nazareti, utyane.” ");
INSERT INTO ndg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petro nga nkamwa kwaluboko lwake lwa mmalyo, na kunkakatuya nnani: mara jimo magolo gake na vifundo vya mifupa gake vyapatike ngupu. ");
INSERT INTO ndg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Karuka kunani, mundu iwete ayemi na tumbwa tyanga; kajingya mu'lihekalu pamope na Petro na Yohana, atyanga na kuruka, na kumsifu Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bandu bote bamweni katyanga na kumsifu Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kabayowa panga abile ni yolo mundu ambaye abile atama kaloba sadaka mu'nnango mzuri wa hekalu; batishangala muno na kustaajabu kwa sababu ya chelo chaboka kwake. ");
INSERT INTO ndg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Namna abile abakamwile Petro na Yohana, bandu bote kwa pamope kabatila mu'ukumbi ukemwa wa Sulemani, batishangala muno. ");
INSERT INTO ndg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petro paaibweni lee, ywembe kabayangwa bandu, “Mwenga bandu ba Israeli, kwa mwanja namani mwatishangala? Kwa mwanja namni mugaelekeza minyo yinu kwitu, kati panga tumpangite yolo atyange kwa nguvu yitu bene au uchaji witu?” ");
INSERT INTO ndg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mungu wa Ibrahimu, na wa Isaka, na wa Yakobo, Nnongo wa Tate yitu, atimtukuza mmanda wake Yesu. Ayoo nga ambaye mwenga mwampeya na kumkamwa nnongi ya minyo wa Pilato, japo ywembe abile atiamua kumleka huru. ");
INSERT INTO ndg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mumkanikiya Mtakatifu na ywabile na haki, na badala yake mkataka muuaji alekwe huru. ");
INSERT INTO ndg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mwenga mwatimbulaga Mpwalume wa ukoto, ambaye Nnongo atimfufua boka kwa bandu ba kiwo-Twenga ni mashahidi ba lee. ");
INSERT INTO ndg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nambeambe, kwa imani katika lina lyake, mundu yoo ambaye mwamweni na kuyowa, apangite kuwa na nguvu. Imani ambayo yapitya kwa Yesu impeya ywembe afya yee kamilifu, nnongi yinu mwenga mwabote. ");
INSERT INTO ndg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nambeambe, mwalongo, nitangite panga mupangite katika ujinga, nga nyoo bapangite viongozi winu. ");
INSERT INTO ndg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lakini makowe ambayo Nnongo atiabakiya mapema kwa mikanwa ya manabii yote, panga yolo Kristo atateseka, nambeambe atiyatimiza. ");
INSERT INTO ndg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kwa eyo, mutubu na mkerebuke, ili panga sambi yinu iweze kuondolewa kabisa, kusudi iise nyakati za kuburudika bokana na uwepo wa Ngwana; ");
INSERT INTO ndg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","na panga aweze kumtuma Kristo ambaye achawilwe kwa ajili yinu, Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ywembe ywabile ambae lazima kumaunde impokee mpaka muda wa kukerebuliwa kwa ilebe yote, ambayo Nnongo atilongela zamani za kale kwa mikanwa ya manabii batakatifu. ");
INSERT INTO ndg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hakika Musa abaya, “Ngwana Nnongo alowa inua nabii kati nenga boka katika alongo binu, Mwalowa yowa kila kilebe ambacho alowaabakiya mwenga. ");
INSERT INTO ndg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yalowa tokya panga kila mundu ywabile ayowine kwaa nabii yolo alowa bulagwa kabisa aboke kati ya bandu.' ");
INSERT INTO ndg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nga nyoo, manabii bote boka Samweli na balo baliofuata baada yake, balongela na kutangaza masoba aga. ");
INSERT INTO ndg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mwenga mwa bana ba manabii na ba liagano ambalo Nnongo alipangite pamope na apindo, kati yaabayite kwa Ibrahimu,'Katika, mbeyu yako familia yote ya dunia yalowa barikiwa, ");
INSERT INTO ndg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Baada ya Nnongo kuntondobiya mtumishi bake, atintuma kwinu kwanza, ili awabariki mwenga kwa kerebuka boka katika ubou winu.” ");
INSERT INTO ndg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Muda Petro na Yohana babile kabalongela na bandu, makuhani na mlinzi wa lihekalu na masadukayo batibayendea. ");
INSERT INTO ndg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Babile bateuzika muno kwa sababu Petro na Yohana babile kabapundisha bandu kuhusu Yesu na tangaza nnani ya fufuka kwake boka mu'kiwo. ");
INSERT INTO ndg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Baatabile na kuwabeka muligereza mpaka bwamba watifuata, mana tayari ibile kitamwinyo. ");
INSERT INTO ndg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lakini bandu banyansima bayowine ujumbe batiaminiya; na idadi ya analome babile baaminiya batikadiliwa kuwa elfu tano. ");
INSERT INTO ndg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Paiikite bwamba lisoba lyanyaibele, panga akolo babe, apindo na baandishi, pamope batikusanyika Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi kuhani nkolo abile, na Kayafa, na Yohana, na Iskanda, na bote babile na alongo ba kuhani nkolo. ");
INSERT INTO ndg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Paababile kabambeka Petro na Yohana katikati yabe, kabannaluya, “Kwa uwezo gani, au kwa lina lya nyai mupangite lee?” ");
INSERT INTO ndg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petro, abile atwelile Roho Mtakatifu, kaabakiya, “Mwenga akolo wa bandu, na apindo, ");
INSERT INTO ndg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kati twenga lisoba lya lino mwatulobya kuhusu tendo linoite lalipangwa na mundu yolo nng'onjwa-kwa namna gani mundu apangilwe nkoto? ");
INSERT INTO ndg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ebu liyowanike lelo kwinu na kwa bandu bote katika Israeli, panga kwa lina lya Yesu Kristo wa Nnazareti, ywabile mwatimsulubisha, ywabile Nnongo atimfufua boka mu kiwo, ni kwa ndela yake panga mundu yolo ayemi pano nnongi yinu abile na afya. ");
INSERT INTO ndg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu Kristo nga liwe ambalo mwenga ajenzi mwatilizarau, lakini ambalo lipangilwe kuwa liwe kolo lya mbembeni. ");
INSERT INTO ndg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ntopo wokovu katika mwingine awaye yote. Kwa mana ntopo lina lyenge pae ya kumaunde bapeyilwe bandu, ambalo kwa lelo twaweza lopolelwa.” ");
INSERT INTO ndg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pababweni ujasiri wa Petro na Yohana, na batigundua panga babile ni bandu bakawaida babile kwaa na elimu, batishangala, kabafahamu panga Petro na Yohana babile pamope na Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kwa sababu bamweni yolo mundu ywaponywa ayemi pamope nabembe, babile kwaa na kilebe cha baya dhidi ya lee. ");
INSERT INTO ndg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lakini pababile bayomwile kubaamuru mitume babutuke nnongi ya likutano lwa baraza, kabalongela bene kwa bene. ");
INSERT INTO ndg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Babaya, tuwapange namani bandu aba? Ni kweli panga muujiza wa ajabu baupangite pitya bembe wayowanika na kila yumo ywatama Yerusalemu; twaweza kwaa kulikana lee. ");
INSERT INTO ndg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lakini, ila panga likowe lee lienee kwaa nkati ya bandu, ebu tuwakanye kana balongele kae kwa mundu yeyote kwa lina lee. ");
INSERT INTO ndg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Baakemite Petro na Yohana nkati na kubaamuru kamwe kana balongele wala pundisha kwa lina lya Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lakini Petro na Yohana bayaangwa na kuabakiya, “Mana ni sahihi kuminyo pa Nnongo kuwaheshimu mwenga kuliko Nnongo, muhukumu mwabene. ");
INSERT INTO ndg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Maana twenga twaweza kwaa kuleka kugalongela makowe ambayo tugabweni na kugayowa.” ");
INSERT INTO ndg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Baada ya kubakanikiya muno Petro na Yohana, batibaleka bayende. Baweza kwaa kupata sababu yoyote ya kubaadhibu, kwa sababu bandu bote babile kabamsifu Nnongo kwa chelo chabile kipangilwe. ");
INSERT INTO ndg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mundu ywabile apoki muujiza wa uponyaji apatike kuwa na umri zaidi ya myaka arobaini. ");
INSERT INTO ndg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Baada ya kubaleka huru, Petro na Yohana babile kwa bandu babe na kuwabakiya yote ambayo makuhani akolo na apindo baamakiyange. ");
INSERT INTO ndg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pabayowine, bakombwile lilobe lyabe pamope kwa Nnongo no baya.”Ngwana, wenga waumbile maunde na dunia na bahari na kila kilebe kibile nkati yake, ");
INSERT INTO ndg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wenga ambaye, kwa Roho Mtakatifu, kwa nkano wa tate bitu Daudi, mtumishi bako, abaya, “Kwa mwanja namani bandu ba mataifa bapangite ghasia, na bandu bawaza makowe gafaika kwaa? ");
INSERT INTO ndg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bapwalume ba dunia bajipanga pamope, na atawala batikusanyika pamope dhidi ya Ngwana na dhidi ya masihi bake.” ");
INSERT INTO ndg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hakika, bote Herode na Pontio Pilato na bandu ba mataifa na bandu ba Israeli, batikusanyika kwa pamope katika mji woo dhidi ya mtumishi wako mtakatifu Yesu, ambaye watimpaka mafuta. ");
INSERT INTO ndg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Batikusanyika pamope kupanga gote ambayo luboko lwako na mapenzi gako gatiyaamuru tangu awali kabla gapangika kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nambeambe, Ngwana, ugalinge matisho yabe, na ukawajalie atumishi wako kulongela neno lyako kwa ujasiri wote. Ili ");
INSERT INTO ndg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","panga pauunyosha luboko lwako kuponya, ishara na maajabu iweze baka pitya lina lya mtumishi wako mtakatifu Yesu.” ");
INSERT INTO ndg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pabayomwile kuloba, eneo ambalo batikusanyika kwa pamope lyatitakaswa, na bote batijazwa na Roho mtakatifu, na balongela neno lya Nnongo kwa ujasili. ");
INSERT INTO ndg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Idadi ngolo ya bandu baaminiya babile na mwoyo umo na roho jimo: na ntopo hata yumo wabembe ywabaya panga chochote chaakimiliki kibile chae mwene; badala yake babile na ilebe yote shirika. ");
INSERT INTO ndg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kwa nguvu kolo mitume babile bakiutangaza ushuhuda wabe kuhusu ufufuo wa Ngwana Yesu, na neema ngolo yaibile nnani yabe yote. ");
INSERT INTO ndg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Pabile kwaa na mundu yoyote nkati yabembe ywapungukiwa na mahitaji, kwa sababu bandu bote babile na hati ya viwanja au nyumba, baipemeya na kuleta mbanje ya ilebe yaibile yatipemewa ");
INSERT INTO ndg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kuibeka pae ya magolo ga mitume, Na mgawanyo upangilwe kwa kila muumini, lengana na kila yumo ywabile na lihitaji. ");
INSERT INTO ndg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusufu, mlawi, mundu boka Kipro, apeyilwe lina lya Barnamasi na mitume (ayoo yatitafsiriwa, ni mwana wa faraja? ");
INSERT INTO ndg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Abile na ngunda, atilipemeya na kailetya mbanje, kaibeka pae ya magolo ga mitume. ");
INSERT INTO ndg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nga nyoo, mundu yumo ywakemelwa Anania, na Safira nyumbo wake, bapemei sehemu ya mali, ");
INSERT INTO ndg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na kuificha sehemu ya mbanje yakupemeya (Nnyumbo bake atangite), na kaletya sehemu yenge na kuibeka mumagolo ga mitume. ");
INSERT INTO ndg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lakini Petro kabaya, “Anania, kwa mwanja namani nchela atiutweliya mwoyo wako kubaya ubocho kwa Roho Mtakatifu na kuficha sehemu ya mali ya nngunda? ");
INSERT INTO ndg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Palyo paibile ipemewa kwaa, ibile kwaa mali yako? Na baada ya kupemea, ibile kwaa pae ya uamuzi wako? Ipangike namani uwaze likowe lee mumwoyo wako? Upanga ubocho kwa mwanadamu kwaa, ila upangia ubocho Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Katika kuyowa maneno aga, Anania atombwike pae na kukata roho. Na hofo ngolo iisile kwa bote bayowine lee. ");
INSERT INTO ndg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Amisembe baisile nnongi na kuntia mu'sanda, na kumpeleka panja na kumsika. ");
INSERT INTO ndg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Baada ya masaa matatu, nnyumbo wake ajingii mulihekalu, atangite kwaa chakipangike. ");
INSERT INTO ndg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petro kamakiya, “Nibakie, mana mupemii ngunda kwa thamani yelo.” Kabaya, “Eloo, kwa thamani yelo.” ");
INSERT INTO ndg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petro kammakia, “Ipangika kwaa panga mwapatana kwa pamope kumjaribu Roho wa Ngwana? Linga, magolo ga balo batinsika nchengo bako ibile pannango, na balowa kukutola na kukupeleka panja,” ");
INSERT INTO ndg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ghafla atomboki pa magolo ga Petro, kakata roho, na balo amisembe baisile mu'nyumba batinkuta awile. Kabantola ni kumpeleka panja, ni kunsika papipi ni nchengo wake. ");
INSERT INTO ndg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hofu ngolo iisile nnani ya likanisa zima, na nnani ya bote bayowine makowea ga. ");
INSERT INTO ndg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ishara za nyansima na maajabu gapangilwe nkati ya bandu pitya maboko ga mitume, Babile pamope katika ukumbi wa Sulemani. ");
INSERT INTO ndg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Lakini, ntopo mundu ywenge tofauti ywabile na ujasiri wa kuambatana nabo; hata nyo, bapeilwe heshima ya kunani ya bandu. ");
INSERT INTO ndg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na pia, baamini banyansima batiyongekea kwa Ngwana, idadi ngolo ya analome ni anwawa, ");
INSERT INTO ndg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","kiasi panga hata baapotwi atamwe mu'mitaa, na kuagonjekea mu'indanda na mu'makochi, ili panga Petro mana itei apeta, kivuli chake kiweze kuashukia nnani yabe. ");
INSERT INTO ndg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Muda woo, idadi ngolo ya bandu baisile bako mumiji yaizunguka Yerusalem, kabaleta atamwe na bote babile na nchela achapu, na bote bapatike ukoto. ");
INSERT INTO ndg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lakini kuhani nkolo atiinuka, na bote babile pamope niywembe (bandu ba dhehebu la Masadukayo): na batwelilwe wivu. ");
INSERT INTO ndg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kabanyoosha maboko gabe kuwakamwa mitume na kuwabeka mu'ligereza lya jumla. ");
INSERT INTO ndg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na muda wa kilo malaika wa Ngwana kafungua nnango wa ligereza na kuakengama panja no baya, ");
INSERT INTO ndg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Muyende, muyemi mulihekalu na kuwabakia bandu maneno yote ya ukoto wolo.” ");
INSERT INTO ndg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kabayowine lee, bajingii mulihekalu muda wa pambazuka na kuapundisha. Lakini, kuhani nkolo aisile na bote babile ni ywembe, na kulikema libaraza lyote kwa mpamo, na apindo bote ba bandu ba Israeli, na kuatuma mu'ligereza ili kualeta mitume. ");
INSERT INTO ndg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lakini batumishi batiyenda, waakuta kwaa muligereza, bakerebuka na kutoa taarifa. ");
INSERT INTO ndg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tulibweni ligereza litabilwe salama, na alinzi bayemi pannyango, lakini patuliyongoli, tummweni kwaa mundu mu'ligereza.” ");
INSERT INTO ndg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nambeambe wakati jemedari wa lihekalu na makuhani akolo pabayowine maneno aga, shaka ngolo ibajingii kwa ajili yabembe bawaza likowe lee lipangika namani. ");
INSERT INTO ndg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Boka poo aisile na kuamakiya, “Bandu babile mu'ligereza bayemi mu'lihekalu na bapundisha bandu.” ");
INSERT INTO ndg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jemedari kayenda pamope na batumishi, na kualeta, lakini bila panga vurugu, kwa sababu batibayogopa bandu baweza kuwakombwa kwa maliwe. ");
INSERT INTO ndg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bayomwile kubaleta, bayemi nnongi ya libaraza. Kuhani nkolo kaanaluya ");
INSERT INTO ndg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","kabaya, “Twatibaamuru kana mpundishe kwa lina lee, na bado muitweli Yerusalemu kwa lipundisho linu, na tamaniya kuleta myai ya mundu ayoo nnani yitu.” ");
INSERT INTO ndg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Lakini Petro na mitume bayangwa, “Lazima tumheshimu Nnongo kuliko bandu. ");
INSERT INTO ndg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nnongo wa Tate bitu atimfufua Yesu, ywa mwatimbulaga, kwa kuntundika nnani ya nkongo. ");
INSERT INTO ndg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nnongo atintukuza mu'luboko lwake lwa mmaliyo, na kumpanga kuwa nkolo na nkochopoli, kutoa toba kwa Israeli, na msamaha wa sambi. ");
INSERT INTO ndg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Twenga ni mashahidi wa makowe aga, na Roho Mtakatifu, ambaye Nnongo atimtoa kwa balo bamweshimia,” ");
INSERT INTO ndg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bajumbe ba baraza bayowine nyoo, babile na hasira bapala kuwabulaga mitume. ");
INSERT INTO ndg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lakini farisayo ywakemelwa Gamalieli, mwalimu wa saliya, ywaheshimiwa na bandu bote, ayemi na kuamuru mitume babekwa panja kwa muda mwipi. ");
INSERT INTO ndg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Boka poo kaamakiya, “Analome ba Israeli, mube makini muno na chelo chamukipendekeza kubapangia bandu aba. ");
INSERT INTO ndg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kwa sababu, zamani yaipeta, Theuda aliinuka na kujidai kuwa nkolo, na idadi ya bandu, bapata mia ncheche batinkengama. Awile, na bote babile batimweshimia batawanyika na kupotea. ");
INSERT INTO ndg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Baada ya mundu yoo, Yuda Mgalilaya, aliinuka masoba gakuandikisha sensa, kaavuta bandu banyansima kunchogo kwake. Ni ywembe atipotea na balo babile bakimweshimiya batitawanyika. ");
INSERT INTO ndg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nambeambe naabakiya, mujiepushe na bandu aba na mubaleke bene, kwa sababu, mana mpango woo au kazi yee ni ya bandu yalowa tupwa. ");
INSERT INTO ndg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lakini mana ni ya Nnongo, mwaweza kwaa kuwazuia; mwaweza kujikuta hata mwampinga Nnongo.”Nga nyo, batishawishika na maneno gake. ");
INSERT INTO ndg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Boka po, baakema mitume mu'nyumba na kubakombwa na kubaamuru kana balongele kwa lina lya Yesu, na batibaleka bayebde zao. ");
INSERT INTO ndg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Batiboka nnongi ya libaraza bapuraika kwa sababu batibalangilwa kuwa wastahili teseka na hesjimiwa kwaa kwa ajili ya Lina lee. ");
INSERT INTO ndg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kwa eyo, kila lisoba, mu'lihekalu na boka nyumba hadi nyumba bayenda kupundisha na hubiri Yesu kuwa ni Masihi. ");
INSERT INTO ndg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nambeambe katika masoba yee, muda idadi ya anapunzi ibile iyongekeya, lalamiko lya Ayahudi wa Kiyunani liytumbwi dhidi ya Baebrania, kwa sababu bajane babe babile bsahaulika katika mgao wa kila lisoba lya chakulya. ");
INSERT INTO ndg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mitume komi ni ibele balikema likusanyiko lyote lya anapunzi na baya, “Ibile kwaa sahihi kwitu kulileka neno lya Nnongo na kuhudumia mezani. ");
INSERT INTO ndg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kwa eyo, mwalongo, muchawe, analome saba, boka nkati yinu, bandu banoite, batwelile Roho na hekima, ambao twaweza kubakabidhi huduma yee. ");
INSERT INTO ndg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na twenga, twatendea daima katika kuloba na katika huduma ya neno.” ");
INSERT INTO ndg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hotuba yabe yatiupendeza mkutano wote. Nga nyo, wakamchawa Stephano, mundu ywatwelile imani na Roho mtakatifu, na Filipo, Prokoro, Nikanori, Timoni, Paemena, na Nikolao, mwangofu boka Antiokia. ");
INSERT INTO ndg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Baumini batileta bandu aba nnongi ya mitume, baalobya na baadae kuabekya maboko gabe. ");
INSERT INTO ndg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nga nyo neno lya Nnongo lyatienea; na idadi ya anapunzi ilizidi yongekeya kolyo Yerusalemu; na idadi ngolo ya makuhani baiheshimiya imani. ");
INSERT INTO ndg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephano, ywatwelile neema na ngupu, abile akipanga maajabu na ishara ngolo nkati ya bandu. ");
INSERT INTO ndg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lakini apo bainuka baadhi ya bandu afuasi ba Sinagogi lya Mahuru, na lya Bakirene na lya Baeskanderia, na baadhi boka Kilikia na Asia. Bandu aba babile bakilongela na Stephano. ");
INSERT INTO ndg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lakini, baweza kwaa shindana na hekima na Roho ambayo Stephano abile akitumia katika longela. ");
INSERT INTO ndg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Boka po batiashawishi baadhi ya bandu kwa siri no baya, “Tuyowine Stephano kalongela maneno ga kufuru dhidi ya Musa na dhidi ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Batibashuhudia bandu, apindo, na baandishi, na kuyenda kwa Stephano, wantabile na kunneta nnongi ya libaraza ");
INSERT INTO ndg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","batibaleta mashahidi ba ubocho, babaya, “mundu yoo akani kuleka longela mabaya dhidi ya eneo lee takatifu na saliya. ");
INSERT INTO ndg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mana tumyowine kabaya panga ayoo Yesu wa Nazareti alowa kuharibu mahali hapa na kuibadili desturi tuliyokabodhiwa na Musa,” ");
INSERT INTO ndg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kila yumo ywabile katika libaraza, kaelezea minyo yake kunlolekea Stephano, na bembe baubweni minyo gake ubile kati minyo ga malaika. ");
INSERT INTO ndg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kuhani nkolo kabaya, “makowe aga ni ya kweli?” ");
INSERT INTO ndg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephano kabaya, “Mwalongo na atate bango, muiniyowine nenga: Nnongo wa utukufu atimtokea tate yitu Abrahamu muda paabile Mesopotamia, kabla atama kwaa Harani,' ");
INSERT INTO ndg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","kammakiya,'Boka katika nchi yako na alongo bako na uyende katika nchi yanilowa kukubonekeya.' ");
INSERT INTO ndg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Boka po kaboka katika nchi ya Ukaldayo atama Harani, boka poo, baada ya tate bake kuwaa, Nnongo kamleta mu'nchi yee, batama nambeambe. ");
INSERT INTO ndg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ampeya kwaa chochote kati urithi wake, pabile kwaa na sehemu hata ya kubeka magolo. Lakini Abrahamu atiahidiwa hata kabla apata kwaa mwana kuwa apeyelwa nchi kati miliki yake na ubeleki wake. ");
INSERT INTO ndg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nnongo alongela ni ywembe, panga abeleki bake batame katika nchi ya ugeni, na panga wenyeji wa kolyo wapanga kuwa atumwa wabe na kuwapanga vibaya kwa muda wa miaka mia ncheche. ");
INSERT INTO ndg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Na Nnongo kabaya, nalowa kulihukumu taifa ambalo labapanga mateka, na baada ya hapo balowa boka na kuniabudu katika sehemu yee,' ");
INSERT INTO ndg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na kampeya Abrahamu liagano lya tohara, nga nyo Abrahamu abile tate ba Yakobo, na Yakobo abile tate ba apindo bitu komi na ibele. ");
INSERT INTO ndg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Mababu bitu bamwonea wivu Yusufu bampemea katika nchi ya Misri, na Nnongo abile pamope ni ywembe, ");
INSERT INTO ndg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","na kanlopwa katika mateso gake, na kumpeya fadhili na hekima nnongi ya Farao mpwalume wa Misri. Farao ampangite abe ntawala nnani ya Misri na nnani ya Nyumba yake yote. ");
INSERT INTO ndg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Bai babile na njala kolo na mateso ganyansima katika nchi ya Misri na Kanani, na tate bitu bapata kwaa chakulya. ");
INSERT INTO ndg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lakini Yakobo paayowine kubile nafaka Misri, atibatuma tate bitu kwa mara ya kwanza. ");
INSERT INTO ndg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Katika safari ya ibele Yusufu akajionyesha kwa alongo bake, familia ya Yusufu yayowanike kwa Farao. ");
INSERT INTO ndg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu aatumite alongo bake kwenda kummakiya Yakobo tate babe aise Misri, pamope na alongo bake, jumla ya bandu bote ni sabini na tano. ");
INSERT INTO ndg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nga nyo Yakobo aisile Misri; boka po awile ywembe pamope na apindo bitu. ");
INSERT INTO ndg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Batitolelwa hata Shekemu na kusikwa katika kaburi ambalo Abrahamu apemi kwa ipande ya mbanje boka kwa bana ba Hamoni kolyo Shekemu. ");
INSERT INTO ndg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Muda wa yelo ahadi ambayo Nnongo amwahidie Abrahamu paubile papipi, bandu batiyongekeya kolyo Misri, ");
INSERT INTO ndg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","muda wo aliinuka mpwalume ywenge nnani ya Misri, mpwalume ywatangite kuhusu Yusufu. ");
INSERT INTO ndg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ayoo mpwalume ywenge alongela ubocho kwa bandu bitu na kuwapanga mabaya tate bitu, na kuwatupa bana babe achanga ili atame kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Katika kipindi chelo Musa abelekilwe; abile mzuri nnongi ya Nnongo, atilelewa miei itatu katika nyumba ya tate bake. ");
INSERT INTO ndg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Muda alipotupwa, binti Farao atimtola na kunleta kati mwana wake. ");
INSERT INTO ndg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa atipundisa mapundisho yoti ya Kimisri; abile na ngupu katika maneno na matendo. ");
INSERT INTO ndg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Lakini baada ya timiya miaka arobaini, iisole katika mwoyo wake kuatembelea alongo bake, bana ba Israeli. ");
INSERT INTO ndg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pamweni Mwisraeli apangiwa mabaya, Musa atimtetea na lipiza kisasi kwa ywamwonea kwa kunkombwa ywa Mmisri: ");
INSERT INTO ndg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","atangite kuwa alongo bake batangite panga Nnongo awalopwa kwa maboko gake, lakini batangite kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lisoba lya nyaibele kayenda kwa baadhi ya Baisraeli babile bakombwana; na jaribia kuapatanisha, kabaya, “Mangwana, mwenga ni alongo; mbona mwakoseana mwenga kwa mwenga? ");
INSERT INTO ndg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lakini ywamkosea jirani yake atimsukuma kutalu, no baya,'Nyai apanga mtawala na muhukumu witu? ");
INSERT INTO ndg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wenga upala kunibulaga, kati yaumulaga yolo Mmisri jana?” ");
INSERT INTO ndg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa katila baada ya kuyowa nyoo; abile mgeni katika nchi ya Midiani, ambayo abile tate wa bana abele. ");
INSERT INTO ndg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Baada ya miaka arobaini pitya malaika akamtokea katika lijangwa lya kitombe sa Sinai, katika mwali wa mwoto mu'kichaka. ");
INSERT INTO ndg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa aubweni mwoto, atishangala na kustaajabia chelo cha akibona, na paatijaribu kuisogelea ili kukilola, lilobe lya Ngwana limuisile no baya, ");
INSERT INTO ndg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Nenga na Nnongo wa tate bako, Nnongo wa Abrahamu, na wa Isaka, na wa Yakobo.'Musa atilendema na athubutu kwaa kulola. ");
INSERT INTO ndg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ngwana kammakiya,'Ula ilatu yako, sehemu pauyemi ni mahali patakatifu. ");
INSERT INTO ndg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Niabweni mateso ga bandu bango babile Misri; Niyowine kuugua kwao, nenga natiuluka ili nialopwe; nambeambe uise, nalowa kukutuma wenga Misri. ");
INSERT INTO ndg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ayoo Musa ambaye ywatimkanikiya, wakati balongela,'nyai kakupanga kuwa mtawala na mwamuzi witu?' abile nga ywembe Nnongo alimtuma abe mtawala na mkochopoli. Nnongo atimtuma kwa maboko ga malaika ambaye atiboka nnongi ya Musa mmwitu. ");
INSERT INTO ndg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa atibakengama boka Misri baada ya kupanga miujiza na ishara katika Misri na katika bahari ya Shamu, na katika lijangwa kwa kipindi cha miaka arobaini. ");
INSERT INTO ndg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa nga yolo ywaamakiye bandu ba Misri kuwa,'Nnongo abapeya nabii boka nkati ya alongo binu, nabii kati nenga.' ");
INSERT INTO ndg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ayoo ni mundu ywabile katika mkutano mu'lijangwa na malaika ywalongela ni ywembe katika kitombe sa Sinai. Ayoo nga mundu ambye abile na tate bitu, ayoo nga mutu ywalipokya neno libile likoto na kutupea twenga. ");
INSERT INTO ndg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ayoo nga mundu ambae tate bitu bakani kumweshimu; batimsukuma mbale, na katika mioyo yabe batikerebukia ");
INSERT INTO ndg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Misri. Katika kipindi chelo bammakiya Haruni, “tupangie nnongo yakutukengama, Ayoo Musa, abile atukengama boka katika nchi ya Misri, tuyowine kwaa sampatike. ");
INSERT INTO ndg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ayoo bampangite ndama kwa masoba ago na kutoa sadaka kwa eyo sanamu na bapuraika kwa sababu ya kazi ya maboko gabe. ");
INSERT INTO ndg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lakini Nnongo atibakerebuya na kuapeya baabudu tondwa ya kumaunde, mama yaiandikilwe mu'itabu sa manabii, “Je Mwanitolea nenga sadaka ya banyama mwamuachinja mulijangwa kwa muda wa miaka arobaini, nyumba ya Israeli? ");
INSERT INTO ndg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Muliyeketya lihema lya kutania lya Moleki na tondwa ya nnongo refani, na picha muichengite na kuwaabudu bembe: na nalowa kuapeleka kutalu muno ya Babeli.' ");
INSERT INTO ndg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tate bitu babile na hema ya kwembana ya ushuhuda mulijangwa, kati Nnongo yaabaamuru paalongela na Musa, panga aichenga kwa mfano wa wolo uubweni. ");
INSERT INTO ndg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ayee ni hema ambalo tate bitu, kwa muda wabe, watiletwa katika nchi na Joshua. Ayee ipangika muda pajingii kumiliki taifa ambalo Nnongo atibafukuza kabla ya uwepo wa tate bitu. Ayee ibile nyoo mpaka masoba ga Daudi. ");
INSERT INTO ndg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ywabile apatike kibali muminyo ga Nnongo,'na kaloba kutafuta makao kwa Nnongo wa Yakobo. ");
INSERT INTO ndg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lakini Selemani atimchengea nyumba ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Hata nyoo ywabile kunani mu'nyumba ichengwile kwa maboko; ayee ni kati nabii abayite, ");
INSERT INTO ndg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kumaunde ni iteo chango cha enzi, na dunia ni sehemu ya beka magolo gango. Nyumba ya aina gani yamuichengite? abaya Ngwana: au ni wapi sehemu yango ya kupomoli? ");
INSERT INTO ndg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Maboko gango kwaa gapangite ayee ilebe yote?' ");
INSERT INTO ndg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Mwenga mwa bandu mubile na ingo ngumu mwatahiriwa kwaa mioyo na makutu, kila mara mwampinga Roho Mtakatifu,' mwapanga kati tate bitu bapangite. ");
INSERT INTO ndg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ni nabii gani katika manabii ambaye tate tate binu bamtesa kwaa? Baabulaga manabii gote batitokea kabla ya ujio wa Yumo mwenye Haki,'nambeambe mubile asaliti na bauaji bake kae, ");
INSERT INTO ndg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwenga mwa bandu mupokya saliya yelo yatiagizwa na malaika lakini muikamwa kwaa.” ");
INSERT INTO ndg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Boka po ajumbe ba baraza payowine makowe aga, batichomwa mu'mioyo yabe, kabamsagia meno Stephano. ");
INSERT INTO ndg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lakini ywembe, abile atwelilwe Roho Mtakatifu, alolekeya kumaunde kwa makini na aubweni utukufu wa Nnongo,'na amweni Yesu ayemi luboko lwa kummalyo lwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stephano kabaya, “Linga nibweni kumaunde zatiyongoliwa, na Mwana wa Adamu ayemi luboka lwa kummaliyo lwa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lakini ajumbe ba libaraza bakombwa ndoti kwa sauti lya kunani, wakaziba makutu yabe, kabantila pamope, ");
INSERT INTO ndg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","kabantupa panja ya mji na kunkombwa maliwe: na mashahidi baula ngobo yabe ya panja na kuibeka pae papipi na magolo ga kijana akemelwa Sauli. ");
INSERT INTO ndg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pabankombwile maliwe Stephano, ayendelea kunkema Ngwana nobaya, “Ngwana Yesu, pokya roho yango,” ");
INSERT INTO ndg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kapiga magoti na kukema kwa lilobe likolo, “Ngwana, ubasamehe sambi yee,” Paalongela nyoo, akakata roho. ");
INSERT INTO ndg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauli abile mu'makubaliano ya kiwo chake, lisoba lee nga atumbwile kuwatesa kinyume cha likanisa lyalibile Yerusalemu; na baaminio bote batawanyika katika majigambo ga Yudea na Samaria, ila mitume. ");
INSERT INTO ndg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bandu bacha'Nnongo balimsika Stephano na kupanga maombolezo makolo nnani yake. ");
INSERT INTO ndg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lakini Sauli atilidhuru muno likanisa. Ayenda mu'nyumba kwa nyumba na kubaburuza panja anwawa na analome, na kuwabeka muligereza. ");
INSERT INTO ndg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Baaminio ambao babile batitawanyika bado balihubili neno. ");
INSERT INTO ndg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo atiuluka katika mji wa Samaria na kuntangaza Kristo kolyo. ");
INSERT INTO ndg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Baada ya bandu kugayowa na kubona ishara azipangite Filipo; babekite umakini nnani yake chalo chaakibaya. ");
INSERT INTO ndg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Boka po bandu banyansima bayowine, nchela achafu bakibatoka bandu huku wakilela kwa lilobe likolo, na benge batipooza na iwete baponile. ");
INSERT INTO ndg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na pabile na puraha ngolo katika mji. ");
INSERT INTO ndg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lakini pabile na mundu yumo katika mji wolo lina lyake Simon, ambaye akipanga bwabe, ambao atiutumya kubashangaza bandu ba litaifa lya Samaria, muda abaya kuwa ywembe ni mundu wa muhimu. ");
INSERT INTO ndg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Basamalia bote tangu nchunu hata mkolo kamsikiliza; babaya;”mundu yolo ni yelo ngupu ya Nnongo ambaye ni kolo.” ");
INSERT INTO ndg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bamsikiliza, kwa maana atibashangaza muda mrefu kwa bwabe wake. ");
INSERT INTO ndg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lakini muda pabaaminiya kuwa Filipo ahubiri nnani ya ufalme wa Nnongo na nnani ya lina lya Yesu Kristo, batiabatiza, analome kwa alwawa. ");
INSERT INTO ndg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na Simoni mwene aaminiya, baada ya kubatizwa, aliendelea kuwa na Filipo; abweni ishara na miujiza yaibile ikipangika, atishangala. ");
INSERT INTO ndg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mundu mitume ba Yerusalemu bayowine kuwa Samaria yapokya neno lya Nnongo, baatuma Petro na Yohana. ");
INSERT INTO ndg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Muda babile bauluka kabalobya; panga wamokee Roho Mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mpaka muda woo, Roho Mtakatifu abile amshukia kwaa hata yumo wabe; babile batibatizwa kwa lina lya Ngwana Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petro na Yohana baabekeya maboko, na bembe bampokya Roho Mtakatifu ");
INSERT INTO ndg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Muda Simoni abweni Roho Mtakatifu atitolewa pitya kuwekewa maboko na mitume; apala kuwapeya mbanje, ");
INSERT INTO ndg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kabaya, “Munipei ayee ngupu, ili kila ywanimbekya maboko apokee Roho Mtakatifu.” ");
INSERT INTO ndg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lakini Petro ammakiye; mbanje yako pamope na wenga ipotee kutalu, kwa sababu utangite kuwa karama ya Nnongo yapatikana kwa mbanje. ");
INSERT INTO ndg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ubile kwaa na sehemu katika likowe lee, kwa sababu mwoyo wako ni mnyoofu kwaa nnongi ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nga nyo bai tubu maovu yako na kunloba Nnongo labda walowa samehewa fikra ya mwoyo wako. ");
INSERT INTO ndg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwa maana nibona ubile katika sumu ya uchungu na kifungo cha sambi.” ");
INSERT INTO ndg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni kanyangwa na kubaya, Munlobe Ngwana kwa ajili yango, kwa mana makowe gote yamuyabaya yaweza pangika kwango. ");
INSERT INTO ndg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Muda Petro na Yohana babile batishuhudia na kuhubiri neno lya Ngwana, batikerebuka Yerusalemu kwa ndela yoo; batihubiri injili katika vijiji vyanyansima vya Basamaria. ");
INSERT INTO ndg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bai malaika ba Ngwana kalongela na Filipo no baya, “Angza na uyende kusini katika ndela ya'iyenda pae ya Yerusalemu kuelekea Gaza.” (Ndela yee ibile katika lijangwa). ");
INSERT INTO ndg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kaangaza na yenda. Linga, pabile na mundu wa Ethiopia, towashi abile na mamlaka kolo pae ya kandase; malkia ba Ethiopia. Ywatibekwa nnani ya hazina yake yote, ni ywembe abile ayenda Yerusalemu kuabudu. ");
INSERT INTO ndg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Abile akerebuka atami mu'gari yake kasoma chuo cha nabii Isaya. ");
INSERT INTO ndg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Roho kalongela na Filipo, “Sogea papipi na gari lee ukengamane nalo. ");
INSERT INTO ndg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","“Nga nyo Filipo kayenda mbio, atimsika kasoma katika chuo cha nabii Isaya, kabaya, Je utangite cha ukisomile?” ");
INSERT INTO ndg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Muethiopia kabaya, “Naweza kinamani bila ongozwa na mundu?” Kamsihi Filipo apande garini na atami pamope ni ywembe. ");
INSERT INTO ndg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nambeambe lifungu lya maandiko lyalibile atilisoma Muethiopia ni lee; Ationgozwa kati ngondolo kuyenda machinjioni chinjwa; na mana ngondolo atinyamaza kimya, afungua kwaa nkano wake: ");
INSERT INTO ndg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kwa huzunikiya kwake hukumu yake itiondolewa: Nyai ywaeleza kizazi chake? maisha yake yationdolewa katika nchi.” ");
INSERT INTO ndg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ayoo towashi kannaluya Filipo, no baya, “Nakuloba, ni nabii yupi ambaye ilongelwa habari yake, ni kuhusu ywembe, au za mundu ywenge”? ");
INSERT INTO ndg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo atumbwi kulongela, atumbwile kwa liandiko lee la Isaya kumhubiria habari ya Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Babile mundela, baika pabile na mase,'towashi kabaya, “Linga, pabile na mase pano namani chakengama nibatizwe kwaa?” ");
INSERT INTO ndg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","maneno aga, “Nga nyo Muethopia kanyangwa “naaminiya panga Yesu Kristo ni Mwana wa Nnongo,” gabile kwaa mu'maandiko ga kale) nga Muethiopia kaamuru gari lisimame. ");
INSERT INTO ndg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Batiyenda nkati ya maji, pamope Filipo na towashi, Filipo kambatiza. ");
INSERT INTO ndg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Muda babokite mu'mase, Roho wa Ngwana yatimpeleka Filipo kutalu; towashi amweni kwaa, kayenda mu'ndela yake kashangilia. ");
INSERT INTO ndg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Lakini Filipo katokea Azoto. Apeta katika nkoa wolo kuhubiri injili katika miji yote mpaka paaikite Kaisaria. ");
INSERT INTO ndg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lakini Sauli, kayendelea longela vitishi hata kwa kiwo cha banapunzi ba Ngwana, atiyenda kwa kuhani nkolo ");
INSERT INTO ndg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na kunnaba barua kwa ajili ya Masinagogi kolyo Dameski, ili panga mana ampatike mundu ywabile katika ndela yelo, awe nnalome au nnwawa, abatabe na kubaleta Yerusalem. ");
INSERT INTO ndg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Paabile katika safari, ipangite kuwa paakaribie Dameski, gafla utimwangazia kotekote bweya boka kumaunde,' ");
INSERT INTO ndg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ni ywembe atomboka pae na ayowine lilobe lambakiye, “Sauli, Sauli, mbona wanitesa nenga?” ");
INSERT INTO ndg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli kayangwa, Wenga wa nyai Ngwana? Ngwana kabaya, “Nenga ni Yesu waniudhi. ");
INSERT INTO ndg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lakini inuka, jingya mjini, wenga walowa bakilwa ya upalikwa kuyapanga. ");
INSERT INTO ndg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Balo bandu batisafiiri pamope na Sauli batami kimya, kabayowa lilobe ila bamweni kwaa mundu. ");
INSERT INTO ndg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli atiinuka katika nnema na paayongoli minyo gake, aweza kwaa bona kilebe, kabankamwa luboko bannetike Dameski. ");
INSERT INTO ndg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kwa masoba atatu abweni kwaa, alya kwaa wala anywa kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Abile mwanapunzi Dameski lina lyake Anania, Ngwana alongela nae katika maono, “Anania.” No baya, “Linga, nibile pano, Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Ngwana kammakiya, Inuka uyende zako katika mtaa waukemelwa Nyofu, na katika nyumba ya Yuda na ukannaluye mundu boka Tarso ywakemelwa Sauli; mana angali aloba: ");
INSERT INTO ndg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Na amweni katika maono mundu lina lyake Anania kajingya na kumbekya maboko nnani yake ila panga aweze kubona. ");
INSERT INTO ndg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Lakini Anania kanyangwa, “Ngwana, niyowine habari za mundu yoo kwa bandu banyansima, kwa kiasi gani abatendea mabaya batakatifu na kolyo Yerusalemu; ");
INSERT INTO ndg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pano abile na mamlaka boka kwa kuhani nkolo kuntaba kila yumo ywalikema lina lyako. ");
INSERT INTO ndg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lakini Ngwana kammakiya, “Uyende, mana ywembe ni chombo kiteule sango, alitole lina lyango nnongi ya Mataifa na apwalume na bana ba Israeli. ");
INSERT INTO ndg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Maana nalowa kuwabonekeya yabile ganyansima yaapalikwa kuteswa kwa ajili ya lina lyango.” ");
INSERT INTO ndg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania kayenda, ajingii mu'nyumba; Kambekeya maboko kabaya, ndugu Sauli, Ngwana Yesu, ywakutokya katika ndela paubile waisa, anitumile upate kubona kae na utolilwe na Roho Mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Gafla vyatomboka ilebe kati magamba, apatike kubona, ayemi, akabatizwa; kalyaa chakulya na kupata ngupu, ");
INSERT INTO ndg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Atami pamope na banapunzi bake kolyo Dameski kwa masoba ganyansima. ");
INSERT INTO ndg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Muda wowolo kantangaza Yesu katika masinagogi, kabaya panga ywembe ni Ngwana wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na bote bayowine batishangala no baya, “Abile mundu yolo kwaa ywaatibaharibu bote balikemile lina lee kolyo Yerusalemu? Na pano kaisa kwa kusudi lya kuwafunga na kuwapeleka kwa makuhani,” ");
INSERT INTO ndg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lakini Sauli atiwezeshwa hubiri na kubapanga Bayahudi batami Dameski basanganyikilwe na kuthibitisha ya kuwa ayoo nga Kristo. ");
INSERT INTO ndg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Baada ya masoba ganansima, Bayahudi bapanga shauri pamope ili wamulage. ");
INSERT INTO ndg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lakini mpango wabe utiyowanika na Sauli. Kabamvizia pannango mutwekati na kilo bapate kumulaga. ");
INSERT INTO ndg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lakini banapunzi bake kabantola kilo na kunshusha pitya ukutani, kabanneta pae mu'kitondo. ");
INSERT INTO ndg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na sauli paaikite Yerusalemu, atijaribu kujiunga na banapunzi lakini babile bakimwogopa, basadiki kwaa kuwa ywembe ni mwanapunzi. ");
INSERT INTO ndg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Lakini Barnaba kantola na kumpeleka kwa mitume, na aabakiye jinsi Sauli yaamweni Ngwana mu'ndela na Ngwana yaa alongela nakwe, na jinsi Sauli atihubiri kwa ujasiri kwa lina lya Yesu kolyo Dameski. ");
INSERT INTO ndg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Atikwembana nabembe kabajingya na boka Yerusalemu, abaya kwa ujasiri kwa lina lya Ngwana Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kabalongela na Ayahudi wa Kiyunani lakini batijaribu mara kwa mara kumulaga. ");
INSERT INTO ndg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Muda palitangite likowe lee, kabantola mpaka Kaisaria, na batimpeleka ayende Tarso. ");
INSERT INTO ndg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Bai likanisa lyote katika Uyahudi, Galilaya na Samaria, libile na amani, lichengwite, na tyanga katika hofu ya Ngwana na faraja ya Roho Mtakatifu, likanisa latikuwa na yongekeya idadi ya bandu. ");
INSERT INTO ndg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Boka po itokii Petro paabile kazunguka zunguka pande zote za mkoa, akabateremkia baumini batama katika mji wa Lida. ");
INSERT INTO ndg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Amweni kolyo mundu yumo lina lyake Ainea, mundu yolo abile pakindanda myaka nane; mana abile atipooza. ");
INSERT INTO ndg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petro kammakiya, “Ainea, Yesu Kristo akuponye; amka ni uyitandikiye kindanda sako.” mara atiamka. ");
INSERT INTO ndg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na bandu bote batami Lida na Sharoni pabamweni mundu yolo, batimkerebukya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pabile na mwanapunzi Yafa akemelwa Tabitha, ambalo mana yake “Dorcas” Ayoo nnwawa atwelilwe kazi inoite na matendo ga rehema aipangite kwa maskini. ");
INSERT INTO ndg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yatipangika katika masoba ago abile ntamwe na awile, pabamsafisha, no kumpandisha chumba cha kunani na kumgonjekea. ");
INSERT INTO ndg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kwa namna Lida abile papipi na Yafa, banapunzi bayowine panga Petro abile kolyo, batibatuma bandu abele kwake, kabamsihi, “Uise kwitu bila kuchelewa.” ");
INSERT INTO ndg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petro atiamka na kaboka pamope nabembe. Paaikite, bannetike katika chumba cha kunani. Na ajane bote bayemi papipi niywembe niywembe kabalela, bakinlolekeya koti na ngobo ambazo Dorcas atibashonea muda abile pamope nabo. ");
INSERT INTO ndg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro kabatoa bote panja ya nyumba, kapiga magoti na kuloba, boka po, atiukerebukya yega, “Tabitha, amka.” Ayongoli minyo gake na paamweni Petro atami pae. ");
INSERT INTO ndg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Boka po ampeya luboko lwake na kumwinua, na paabakema baamini na bajane, atibakabidhi kwabe abile nkoto. ");
INSERT INTO ndg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Likowe lee liyowanike Yafa yote, na bandu banyansima bamwaminiya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ipangite Petro atama masoba ganyansima Yafa pamope na mundu ywakemelwa Simoni, ywatengeneza ngozi. ");
INSERT INTO ndg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pabile na mundu pulani katika mji wa Kaisaria, lina lyake akemelwa Kornelio, abile nkolo wa kikosi sa Baitalia. ");
INSERT INTO ndg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Abile ancha Nnongo na atimwabudu Nnongo na nyumba yake yoti; atitoa mbanje yanansima kwa Ayahudi na aloba kwa Nnongo masoba gote. ");
INSERT INTO ndg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Muda wa saa tisa ya mutwekati, abweni maono malaika wa Nnongo kambakiya, “Kornelio! ");
INSERT INTO ndg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelio kamlolekeya malaika na abile na hofu ngolo muno kabaya “Ayee nga namani nkolo?” Malaika kammakiya Maombi ni sadaka yako kwa maskini zimepanda nnani kati kumbukumbu mu'uwepo wa Nnongo.” ");
INSERT INTO ndg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nambeambe ubatume bandu yendya mji wa Yafa kunneta mundu yumo ywakemelwa Simoni ywabile ukemelwa Petro. ");
INSERT INTO ndg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Atama na nchenga ngozi ywakemelwa Simoni ambaye nyumba yake ibile kando ya bahari.” ");
INSERT INTO ndg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Baada ya malaika ywabaya ni ywembe kuboka, Kornelio abakema batumishi ba mu'nyumba yaker abele, na askari ywatimwabudu Nnongo kati ya askari babile bamtumikya. ");
INSERT INTO ndg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornelio kaabakiya gote yapangike na kabatuma Yafa. ");
INSERT INTO ndg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lisoba lya nyaibele saa sita babile mundela na babile papipi na mji, Petro kapanda nnani mu'dari loba. ");
INSERT INTO ndg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na abile na njala na apala kilebe cha kulya, lakini muda bandu bateleka chakulya, kabonekeya maono, ");
INSERT INTO ndg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Abweni anga liyongoliwe na chombo chatiuluka na kilebe fulani kati ngobo kolo yatiuluka pae pa'nnema katika kona zote ncheche. ");
INSERT INTO ndg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nkati yake pabile na aina yoti ya anyama babile na magolo ncheche na batambaa nnani ya nnema, na iyuni ba angani. ");
INSERT INTO ndg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Lilobe lyabaya kwake, “amka, Petro chinja na ulyee.” ");
INSERT INTO ndg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lakini Petro kabaya “nga nyoo kwaa, Ngwana kwa sababu nalowa lyaa kwaa kilebe chochte kinajisi na kichapu. ");
INSERT INTO ndg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lakini lilobe lyaisa kwake kae kwa mara yana ibele “Chaakitakasa Nnongo kana ukikeme najisi wala kichafu.” ");
INSERT INTO ndg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ayee ipangika mara tatu, na chelo chombo chatitolwa kae angani. ");
INSERT INTO ndg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Palyo petro abile katika hali ya changanyikiwa nnani ya ago maono yatimaanisha namani, Linga bandu batumilwe na Kornelio bayemi nnongi ya ");
INSERT INTO ndg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","nnango, kannaluya ndela ya kuyenda mu'nyumba. Bakema na kunnaluya mana Simoni ywakemelwa Petro atama palo. ");
INSERT INTO ndg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Muda woo Petro abile awasa nnani ya ago maono, Roho kabaya na ywembe, “Linga bandu atatu bakupala. ");
INSERT INTO ndg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Amka na uuluke pae na uyende nakwe. Uyogope kwaa yenda nabembe, kwa mana niatumile.” ");
INSERT INTO ndg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petro atiuluka pae kwao na baya “Nenga nga yolo mwamumpala. kwa mwanja namani muisile?” ");
INSERT INTO ndg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Babaya, “Akida yumo lina lyake Kornelio, mundu wa haki na hupenda kumwabudu Nnongo, na bandu ubaya vema katika litaifa lyote lya Ayahudi, abakilwe na malaika ba Nnongo kututuma twenga ili kuyenda mu'nyumba yake, ili ayowe ujumbe boka kwako.” ");
INSERT INTO ndg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petro kabakaribisha jingya mu'nyumba na tama pamope nakwe. Bwamba ya lisoba lyanaibele atiyumuka kayenda pamope nakwe, na alongo achache boka Yafa batikengamana naywembe. ");
INSERT INTO ndg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Baikite Kaisalia lisoba lyanaibele. Na Kornelio abile atibalenda abakema pamope alongo bake na mbwiga bake ba karibu. ");
INSERT INTO ndg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petro pajingii mu'nyumba, Kornelio atikumlaki na kuinama mpaka pae mu'magolo gake kwa kumweshimu. ");
INSERT INTO ndg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lakini Petro kamwinua no baya “Yema; nenga namwene na mundu kae.” ");
INSERT INTO ndg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Palyo Petro atilongela naywembe, atiyenda mu'nyumba kaakuta bandu batikusanyika pamope. ");
INSERT INTO ndg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kaamakiya, “Mwenga mwabene mutangite panga ibile kwaa saliya ya kiyahudi shirikiana na tembeleana na mundu ywabile kwaa wa taifa lee. Lakini Nnongo kanibonekeya nenga kuwa nipalika kwaa kumwita mundu yeyote najisi au mchafu. ");
INSERT INTO ndg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nga nyoo niisile bila kubisha, panitumilwe kwa ajili yelo. Kwa eyo naanaluya kwa mwanja namani mwatumilwe kwa ajili yango?” ");
INSERT INTO ndg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelio kabaya, “Masoba ncheche ganchogo bka leno, muda kati wolo nibile naloba muda wa saa tisa mutwekati mu'nyumba yango: Nibweni nnongi yango mundu ayemi abile na ngobo nyuepe, ");
INSERT INTO ndg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kanibakiya “Kornelio maombi gako gatiyowanika na Nnongo, na sadaka zako kwa maskini zibile kati ukumbusho nnongi ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kwa eyo batume bandu Yafa na bankeme mundu yumo ywakemelwa Simoni aise kwako, ambaye ukemwa Petro, ambaye atama kwa ywachenga ngozi yumo ywakemelwa Simon ambae nyumba yake ibile pembeni ya libahari. ");
INSERT INTO ndg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Zingatia mtari wolo, “Ni ywembe paaisa alowa baya nimwenga” ubile kwaa mu'maandiko ga kale. ");
INSERT INTO ndg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petro ayongoli nkano wake no baya, “Kweli, naaminiya kuwa Nnongo aweza kwaa kuwa na upendeleo. ");
INSERT INTO ndg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Badala yake, kila taifa mundu yeyote ywamwabudia na kupanga matendo ga haki anakubalika kwake. ");
INSERT INTO ndg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Uutangite ujumbe ulioutoa kwa bandu ba Israeli. abile akitangaza habari njema ya amani pitya Yesu Kristo ywabile ni Ngwana wa bote. ");
INSERT INTO ndg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","mwenga mwabene mutangite tukio lyalipangite, ambalo lipangite Yudea yote na litumbwile Galilaya, baada ya ubatizo ambao Yohana atiutangaza. ");
INSERT INTO ndg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","likowe lyalibile linamuhusu Yesu Kristo jinsi Nnongo atimtia mauta kwa Roho Mtakatifu na kwa nguvu. Apangite mema na kuponya bote bateswile na ibilisi, kwa mana Nnongo abile pamope naywembe. ");
INSERT INTO ndg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Twenga ni mashaidi ba makowe yote yaapangite katika nchi ya Uyahudi na katika Yerusalemu-ayoo ni Yesu ywamulaga na kuntundika mu'nkongo. ");
INSERT INTO ndg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ayoo mundu Nnongo atikumfufua lisoba lya tatu na kumpeya kuyowanika. ");
INSERT INTO ndg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kwa bandu bote kwaa, lakini twenga twabene, twalya naywembe na nywaa niywembe baada ya kufufuka boka mu kiwo. ");
INSERT INTO ndg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atituagiza kuhubiri kwa bandu na kushuhudia kuwa ayoo nga Nnongo ywamchawile kuwa mwamuzi wa babile akoto na babile mu'kiwo. ");
INSERT INTO ndg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Katika ywembe manabii bote bashuhudie, ili panga kila ywaaminiye katika ywembe alowa pokya msamaha wa sambi pitya lina lyake. ");
INSERT INTO ndg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Palyo Petro kayendelya longela nyoo, Roho Mtakatifu kaatweliya bote babile bauyowine ujumbe wake. ");
INSERT INTO ndg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bandu balo bahusika na likundi lya baaminiya babile atahiriwa-balo bote baisile na Petro-batishangala, kwa sababu ya karama ya Roho Mtakatifu ywatimwagwa kwa mataifa. ");
INSERT INTO ndg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwa kuwa bayowine aba bamataifa balongela kwa lugha yenge na kumwabudu Nnongo. Petro kayangwa, ");
INSERT INTO ndg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Abile mundu yoyote ywaweza kuzuia maji ili bandu babatizwe kwaa. Bandu aba batimpokya Roho Mtakatifu kati twenga?” ");
INSERT INTO ndg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nga kabaamuru babatize kwa lina lya Yesu Kristo. Baadaye banobite atame nabo kwa masoba kadhaa. ");
INSERT INTO ndg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mitume na alongo balo babile kolyo Yudea bayowine kuwa bataifa batilipokya neno lya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Petro paisile kolyo Yerusalemu, lelo likundi lya bandu batitairiwa batumbwi kumkosoa, Kababaya, ");
INSERT INTO ndg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Utikengamana na bandu batairiwa kwaa na kulya nabo!” ");
INSERT INTO ndg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lakini Petro atumbwi kulielezea likowe kwa kina; kabaya, ");
INSERT INTO ndg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nibile naloba katika mji wa Yafa, na kubona maono ya chombo chauluka pae kati ngobo kolo yatiuluka boka kumaunde katika pembe zake zote ncheche. Chatiuluka kwango. ");
INSERT INTO ndg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Natikilola na kukiwasa nnani yake. Nabweni anyama babile na magolo ncheche batami katika nchi, na anyama ba kumwitu na anyama batambaabo na iyuni ba angani. ");
INSERT INTO ndg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Boka po niyowine lilobe lyabaya nanenga, “Amka, Petro, chinja na ulye!” ");
INSERT INTO ndg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nibayite, “Nyoo kwaa, Ngwana, nkanwa wango ujingya kwaa kilebe chochote kibile kwaa kitakatifu au kichafu” ");
INSERT INTO ndg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lakini lilobe lyayangwa kae boka kumaunde, chelo Nnongo chaakitangaza kuwa ni safi, kana ukikeme najisi. ");
INSERT INTO ndg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ayee yaboka mara tatu, na kila kilebe chatolwa kumaunde kae. ");
INSERT INTO ndg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Linga, muda woo bandu atatu babile bayemi nnongi ya nyumba yelo mwatubile; batumwile boka Kaisaria kuisa kwango. ");
INSERT INTO ndg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roho anibakiye kuyenda nabembe, na kana nitofautiane nabo, Aba analome sita bayenda pamope na nenga na tuyende mu'nyumba ya mundu yumo. ");
INSERT INTO ndg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ywatubakiye nyoo paamweni malaika ayemi mu'nyumba yake kabaya, “Nitume Yafa kunneta Simoni ambaye lina lyake lyenge ni Petro, ");
INSERT INTO ndg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Alowa baya ujumbe kwako katika wolo alowa lopolelwa na nyumba yako yote.” ");
INSERT INTO ndg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Panitumbwile longela nabembe, Roho Mtakatifu kaisa nnani yabe kati yaatiisa kwitu mwanzo. ");
INSERT INTO ndg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nakombokya maneno ga Ngwana, yaayabaite, “Yohana atibatiza kwa mase; lakini mwalowa batizwa katika Roho Mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mana Nnongo atupea zawadi kati ya atupei twenga patuaminiya katika Ngwana Yesu Kristo, nenga na nyai, panga naweza kumpinga Nnongo? ");
INSERT INTO ndg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pabayowine makowe aga, barudisha kwaa, ila batimsifu Nnongo no baya, “Nnongo atiitoa toba kwa ajili ya mataifa kae” ");
INSERT INTO ndg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bai baamini ambao mateso gatumbwile mu'kiwo cha Stephano batitawanyika boka Yerusalemu-baaminia aba batiyenda mbale, hadi ku'mpaka ba Foinike, Kipro na Antiokia. Baabakiya ujumbe kuhusu Yesu kichake ka bayahudi na ywenge kwaa yoyote. ");
INSERT INTO ndg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lakini baadhi yabe ni bandu boka Kipro na Krene, baisile Antiokia no baya na ayunani na kumhubiri Ngwana Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na luboko lwa Ngwana libile pamope nabembe, na bandu banyansima baaminiya na kumkerebukya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Habari yabe ziikite mu'makutu ga likanisa lya Yerusalemu: na kabantuma Barnaba ayende mpaka Antiokia. ");
INSERT INTO ndg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Paaisile na bona karama ya Nnongo atipuraika; abatia mwoyo bote kubaki na Ngwana katika mioyo yabe. ");
INSERT INTO ndg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kwa mana abile mundu mwema na atwelile Roho Mtakatifu na imani ya bandu banyansima batoyongekeya katika Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Baadae Barnaba atiyenda Tarso kumbonekeya Sauli. ");
INSERT INTO ndg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Paampatike, kanneta Antiokia. ipalike kwa mwaka mzima kabakusanyika pamope na likanisa na kubafundisha bandu banyansima. Na banafunzi bakemelwa bakristo kwa mara ya kwanza kolyo Antiokia. ");
INSERT INTO ndg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na atika masoba aga manabii batiuluka boka Yerusalemu mpaka Antiokia. ");
INSERT INTO ndg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yumo wabe ni Agabo lyalibile lina lyake, ayemi atiashiriwa na Roho panga njala ngolo yalowa tokea mu'ulimwengu wote. Ayee ipangike wakati wa masoba ga Klaudio. ");
INSERT INTO ndg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kwa eyo, banafunzi, kila yumo abile atifanikiwa, baliamua kupeleka misaada kwa ndugu babile Uyahudi. ");
INSERT INTO ndg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bapangite nyoo; Baituma pesa kwa luboko lwa Barnaba na Sauli. ");
INSERT INTO ndg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wakati huo mpwalume Herode kanyosha luboko lwake kwa baadhi ya balo baboka mu'likusanyiko ili kubatesa. ");
INSERT INTO ndg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kamulaga Yakobo nongo wake Yohana kwa upanga. ");
INSERT INTO ndg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Baada ya kubona kuwa yawapendeza Ayahudi, kamkamwa na Petro kae. Ayee ibile muda wa mikate ibile kwaa na chachu. ");
INSERT INTO ndg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Paamkamwile, kambeka muligereza na kubeka vikosi ncheche vya askari ili kumlinda, abile akitarajia kumpeleka kwa bandu baada ya Pasaka. ");
INSERT INTO ndg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petro abekwa mu'ligereza, lakini maombi kapangwa kwa bidii na kusanyiko kwa ajili yake kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Lisoba kabla Herode kuyenda kumtoa, Kilo yee Petro abile agonjike katikati ya maaskari abele, abile atabilwe na nyororo yanaibele, na balinzi nnongi ya nnango babile bakililinda ligereza. ");
INSERT INTO ndg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Linga, malaika wa Ngwana gafla atimtokya na bweya uting'ara mu'ligereza. Kankombwa Petro mu ubau na kumwamsha kabaya, “Amka haraka,” Nga nyororo yabile atabilwe nayo itomboka boka mu'maboko gake. ");
INSERT INTO ndg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaika kambakiya, “Uwale ngobo zako na uwale ilatu yako.” Petro kapanga nyoo. Malaika kambakiya, “Uwale ngobo yako ni unikengame.” ");
INSERT INTO ndg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petro kankengama Malaika na katoka panja. Aaminiya kwaaa chakipangilwe na malaika mana ni cha kweli. Atangite panga abona maono. ");
INSERT INTO ndg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Baada ya pitya mu'lindo lya kwanza na lya ibele, baikite pa'nnango nkolo wa chuma wa jingya mjini, lyatifunguka lyene kwa ajili yabe. Babokite panja na kuuluka mu'mitaa, mara Malaika annekite. ");
INSERT INTO ndg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petro paajitangite, kabaya, “Nambeambe naaminiya kuwa Ngwana amtumile Malaika bake ili kuntoa katika maboko ga Herode, na kwa matarajio ga bandu bote na Uyahudi,” ");
INSERT INTO ndg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Baada ya kugatanga aga, kaisa mu'nyumba ya Mariamu mao bake Yohana ambaye ni Marko, Bakristo banyansima batikwembana nakunloba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Paatibisha pa'nnango wa kizuizi, mtumishi yumo nwawa ywakemelwa Roda atiisa na kufungua. ");
INSERT INTO ndg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Paatangite kuwa ni lilobe lya Petro, kwa puraha kashindwa kufungua nnango; badala yake atibutuka mu'chumba; kubajulisha kuwa Petro ayemi nnongi ya Nnango. ");
INSERT INTO ndg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nga nyo, kababaya kwake, “Wenga wa mwendawazimu” lakini atikazia kuwa kweli ni ywembe. Babaya “Ayoo ni malaika bake.” ");
INSERT INTO ndg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Lakini Petro kayendelea kombwa odi, kabamfungua nnango, bamweni na kushangala muno. Petro kaanyamazisha kwa maboko kimya kimya na kuwabakiya namna Ngwana atimtoa boka mu'ligereza. kabaya, ");
INSERT INTO ndg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","“Mubajulishe makowe aga Yakobo na alongo bake.”Boka po atiboka no yenda sehemu yenge. ");
INSERT INTO ndg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Paiikite mutwekati, pabile na huzuni ngolo kati ya askari, husiana na chakipangite kwa Petro. ");
INSERT INTO ndg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","baada ya Herode kumpala na amweni kwaa kaanaluya balinzi na atiamuru baabulage. Kayenda na kuboka Uyahudi mpaka Kaisaria na tama kolyo. ");
INSERT INTO ndg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herode abile na hasira nnani ya bandu ba Tiro na Sidoni. Bayenda pamope kwake. Babile na urafiki na Blasto msaidizi ba Mpwalume, ili abasaidie. Boka po batiloba amani, kwa mana nchi yabe ipokile chakulya boka mu'nchi ya mpwalume. ");
INSERT INTO ndg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lisoba lyalikusudiwa Herode abile kawala ngobo ya kipwalume na tama mu'iteo chake cha kipwalume, na kabahutubia. ");
INSERT INTO ndg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bandu bakombwa ndoti, “Ayee nga lilobe lya nnongo wala lya mundu kwaa!” ");
INSERT INTO ndg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mara ghafla Malaika ankombwile, kwa mana ampeya kwaa Nnongo utukufu; kaminya ndumbo na awile. ");
INSERT INTO ndg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lakini neno lya Nnongo likakua na lyatisambaa. ");
INSERT INTO ndg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Baada ya Barnaba na Sauli kamilisha huduma yabe babokite kolyo na kerebukya Yerusalemu, kabantola na Yohana ambaye lina lyake lyaubeleki ni Marko. ");
INSERT INTO ndg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nambeambe katika likanisa lya Antiokia, pabile na baadhi ya manabii na baalimu. Babile Barnaba, Simeoni(ywakemwa Nigeri). Lukio ba Kirene, Manaeni (nongowe abile wa myai kwaa Herode kiongozi wa mkoa), na Sauli. ");
INSERT INTO ndg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pababile bakimwabudu Ngwana na kufunga, Roho Mtakatifu kabaya, “Munitengee pembeni Barnaba na Sauli, baipange kazi yaanibakemule kuipanga.” ");
INSERT INTO ndg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Baada ya likanisa kufunga, kuloba na kubeka maboko gabe nnani ya bandu aba, batibaleka bayende. ");
INSERT INTO ndg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kwa eyo Barnaba na Sauli batimweshimu Roho Mtakatifu na batiuluka kuelekea Seleukia; boka kolyo balisafiri mu'bahari kuyenda kisiwa cha Kipro. ");
INSERT INTO ndg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pababile katika mji ba Salami, batilitangaza neno lya Nnongo mu'masinagogi ga Ayahudi. Babile pamope ni Yohana Marko kati msaidizi wabe. ");
INSERT INTO ndg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pabayenda mu'kisiwa chote mpaka Pafo, bakwembine na mundu fulani mwaabe, Myahudi nabii wa ubocho, ambaye lina lyake lyabile Bar Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mwaabe yolo atishirikiana na Liwali Sergio Paulus, ywabile mundu ywaabile na malango. Mundu yolo atibaarika Barnaba na Sauli, kwa mana atipala kuliyowa neno lya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lakini Elima “yolo mwaabe” (alee nga lina lyake lyatitafsiriwa) atibapinga; ajaribie kumgeuza yolo liwali aboke mu'imani. ");
INSERT INTO ndg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lakini Sauli ywakemwa Paulo, abile atijazwa na Roho Mtakatifu, kamtumbulya minyo ");
INSERT INTO ndg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","no baya “Wenga wa mwana wa ibilisi, utwelilwe na aina zote za udanganyifu na udhaifu. Wenga ni adui wa kila aina ya haki. Ukoma kwaa kuzigeuza ndela za Ngwana, zazinyoka, je walowa weza? ");
INSERT INTO ndg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nambeambe linga, luboko lwa Ngwana libile nnani yako, na upangika ipofu. Walowa libonekeya kwaa liumu kwa muda”mara yimo ukungu na libendo lyatomboka nnani ya Elimas; atumbwi zunguka palyo aaloba bandu bamwongoze kwa kunkamwa luboko. ");
INSERT INTO ndg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Baada ya liwali kubona chakipangike, aaminiya, kwa mana atishangala kwa mapundisho kuhusu Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nambeambe Paulo na mbwiga bake batisafiri mu'mase boka Pafo na baikite Perge katika Pamfilia. Lakini Yohana abalekite na kukerebuka Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paulo ni mbwiga wake batisafiri na baikite Antiokia ya Pisidia. Kolyo batiyenda mu'lisinagogi lisoba lya Sabato na tama pae. ");
INSERT INTO ndg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Baada ya kuisoma saliya ya manabii, viongozi ba lisinagogi batumite ujumbe kababaya, “Alongo, mana mubile na ujumbe wa kutia mwoyo bandu pano, muubaye” ");
INSERT INTO ndg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kwa eyo Paulo kayema na kubapungia luboko; kabaya, “Analome ba Israeli na mwenga mwamuheshimia Nnongo, sikilizeni. ");
INSERT INTO ndg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nnongo wa aba bandu ba Israeli awachawi tate bitu na kuwapanga bandu banyansima batami katika nchi Misri, na kwa luboko lwake kuinuliwa na kubakengama panja yake. ");
INSERT INTO ndg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kwa miaka arobaini atibavumilia mu'lijangwa. ");
INSERT INTO ndg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Baada ya kugaharibia mataifa saba katika nchi ya Kaanani, abapeya bandu bitu nchi yabe kwa urithi. ");
INSERT INTO ndg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Matendo aga gote gapangike zaidi ya miaka mia ncheche na hamsini. Baada ya ilebe yelo yote, Nnongo abapeile baamuzi mpaka Samweli nabii. ");
INSERT INTO ndg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Baada ya aga, bandu batinloba mpwalume, nga nyoo Nnongo abapea Sauli mwana wa Kishi, mundu wa likabila lya Benjamini, kuwa mpwalume kwa miaka arobaini. ");
INSERT INTO ndg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Boka po baada ya Nnongo kumwondoa mpwalume, atimwinua Daudi kuwa mplwalume wabe. Ibile ni kuhusu Daudi panga Nnongo kabaya, “Nimpatike Daudi mwana wa Yese kiwa mundu ywaapendezwaye na mwoyo wango; ambaye alowa panga kila kilebe chanikipendile.' ");
INSERT INTO ndg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Boka mu'ukoo ba mundu yolo Nnongo atiiletya Israeli mkochopoli, Yesu, kati yaatiahidi kupanga. ");
INSERT INTO ndg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Alee litumbwile pangika, kabla ya Yesu kuisa, Yohana kwanza atitangaza ubatizo wa toba kwa bandu bote ba Israeli. ");
INSERT INTO ndg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ni ywembe Yohana paabile atimaliza kazi yake, abayite,'Mwawaza nenga na nyai? nenga na yolo kwaa. Lakini muisikilize, yolo ywaisa kunchogo yango, nastahili kwaa hata legeza ilatu ya magolo gake.' ");
INSERT INTO ndg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Alongo, bana ba ukolo ba Abrahamu, na balo ambao kati yinu mwamwabudu Nnongo, ni kwa ajili yitu panga ujumbe woo wa ukombozi utumilwe. ");
INSERT INTO ndg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kwa balo batama Yerusalemu, ba batawala babe, bantangite kwa kwa uhalisia, na wala bautangite kwaa ujumbe ba manabii abao husomwa kila Sabato; kwa eyo batiutimiza ujumbe wa manabii kwa kumhukumu kiwo Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Japokuwa bapatike kwaa sababu inoite kwa kiwo nkati yake, batinloba Pilato amulage. ");
INSERT INTO ndg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Payomwile makowe gote yaandikilwe kuhusu ywembe, batiuuluya yega yake boka mu'nkongo na kagonja mu'likaburi. ");
INSERT INTO ndg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lakini Nnongo atimfufua boka kwa bandu ba kiwo. ");
INSERT INTO ndg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Atibonekana kwa masoba ganyansima kwa balo bayenda pamope ni ywembe boka Galilaya yenda Yerusalemu. Bandu aba nambeambe nga mashaidi ba bandu. ");
INSERT INTO ndg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nga nyo twaletya habari njema kuhusu ahadi yawapeilwe apindo bitu. ");
INSERT INTO ndg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nnongo abekite ahadi yee kwitu, bana babe, katika lee atimfufua Yesu na kukerebuka kae katika ukoto. Alee liandikilwe kae katika Zaburi ya pili;'Wenga mwana wango, leno nibile Tate bako' ");
INSERT INTO ndg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kuhusu ukweli ni panga atimfufua boka mu'kiwo ili panga yega yake uharibike kwaa, atilongela nyoo:'Nalowa kukupeya utakatifu na baraza halisi za Daudi' ");
INSERT INTO ndg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ayee nga sababu abaya katika Zaburi yenge,'Huruhusu kwaa mtakatifuwako kuubonekeya uozo.” ");
INSERT INTO ndg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kwa mana baada ya Daudi tumikiya mapenzi ga Nnongo katika ubeleki wake, agonjike, atigonja pamope na tate bake, na aubweni uharibifu, ");
INSERT INTO ndg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lakini ywafufuliwe na Nnongo aubweni kwaa uharibifu. ");
INSERT INTO ndg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nga nyoo iyowanike kwinu, alongo, pitya mundu yolo, msamaha wa sambi watihubiriwa. ");
INSERT INTO ndg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kwa ywembe kila aminiye abalangilwa haki na makowe yote ambayo saliya ya Musa yawapeya kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nga nyo bai mube baangalifu panga kilebe saakilongela manabii kana kiboke kwinu. ");
INSERT INTO ndg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Linga, mwenga mubile na dharau, na mwamushangala na kuangamiya; kwa mana napanga kazi katika masoba yinu, Kazi ambayo mwaweza kwaa kuiamnia, hata mana mundu alowa kubaeleza.” ");
INSERT INTO ndg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Muda Paulo na Barnaba babokite, bandu baalobite balongele maneno aga lisoba lya Sabato yenge. ");
INSERT INTO ndg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Muda mkutano wa lisinagogi pauyomwile thabiti batibakengama Paulo na Barnaba, ambao batilongela nabo na babahimiza bayendelee katika neema ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabato yenge, karibu mji mzima watikwembana kulisikiliza lineno lya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bayahudi paababweni makutano, batolilwe ni wivu na longela maneno yagapinga ilebe yatilongelwa na Paulo na kuntukana. ");
INSERT INTO ndg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Lakini Paulo na Barnaba batilongela kwa ujasiri no baya, “Ibile muhimu panga neno lya Nnongo lilongelwa kwanza kwinu. Kwa mana mwatilisukumiya kutalu boka kwinu nakuibona kuwa mwastahili kwaa ukoto wangayomoka, mulinge twalowakerebukya Mataifa. ");
INSERT INTO ndg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kati ambavyo Ngwana atituamuru, kabaya,'Niabekite mwenga kati bweya kwa bandu ba mataifa, panga mlete wokovu kwa pande zote za dunia.” ");
INSERT INTO ndg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mataifa pabayowine lee, batipuraika na kulisifu neno lya Ngwana. Baingi batichauliwa kwa ukoto wangayomoka baliaminia. ");
INSERT INTO ndg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Neno lya Ngwana lilienea nchi yote. ");
INSERT INTO ndg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lakini Ayahudi batibasihi baliojitoa na anwawa muhimu, na viongozi wa mji. Aga yalichochea mateso dhidi ya Paulo na Barnaba na baliatupa panja ya mipaka ya mji. ");
INSERT INTO ndg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Lakini Paulo na Barnaba batikung'uta vumbi lya magolo gabe. Boka po batiyenda katika mji wa Ikonia. ");
INSERT INTO ndg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na banafunzi batweliwe na furaha pamope na Roho Mtakatifu. ");
INSERT INTO ndg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ipalikwa katika Ikonia panga Paulo na Barnaba bajingii mpamo katika lisinagogi lya Ayahudi balongela namna ambayo likundi likolo lya bandu Ayahudi na Bayunani. ");
INSERT INTO ndg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lakini Ayahudi baheshima kwaa balibachochea akili bamataifa na kuwapanga kuwa dhidi ya alongo. ");
INSERT INTO ndg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kwa eyo batama kolyo kwa muda mrefu, balongela kwa ujasiri kwa nguvu ya Ngwana, huku akitoa uthibitisho nnani ya ujumbe wa neema yake. Apangite nyoo kwa kutoa ishara na maajabu vipangwe kwa maboko ga Paulo na Barnaba. ");
INSERT INTO ndg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Lakini eneo likolo lya mji lyatigawanyika: baadhi ya bandu babile pamope na Ayahudi, na benge babile pamope na mitume. ");
INSERT INTO ndg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Muda bamataifa na Ayahudi bajaribia kubashawishi viongozi wabe kubatendea vibaya na kubakombwa maliwe Paulo na Barnaba. ");
INSERT INTO ndg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","batangite lee na kubutukya katika miji ya Likaonia, Listra na Derbe, na maeneo yatilizunguka eneo lee. ");
INSERT INTO ndg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","na kolyo batihubiri injili. ");
INSERT INTO ndg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na kolyo Listra pabile na mundu yumo ywatama, abile kwaa na ngupu mumagolo gake, kilema boka mundu lya mao bake, ywatyanga kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mundu yolo amyowine Paulo paalongela. Paulo atumbwi minyo na kubona panga abile na imani ya kupona. ");
INSERT INTO ndg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nga nyoo abayote kwake kwa lilobe lya nnani, “Yema kwa magolo gako,” Ni yolo mundu attiruka kunani na atumbwile tyanga. ");
INSERT INTO ndg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kipenga sa bandu pakibweni saakipangite Paulo, batiinua lilobe lao, kababaya katika lahaja ya Kilikaonio, “nongo itituulukia kwa namna ya mundu.” ");
INSERT INTO ndg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bamkemile Barnaba “Zeu” na Paulo “Herme” kwa mana abile nkolo wa kulongela. ");
INSERT INTO ndg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kuhani wa Zeu, ywabile lihekalu lyake libile panja ya mji, aletike fahari lya ng'ombe na mtungo wa maua mpaka pa'nnango wa mji na kipenga sa bandu bapala kutoa sadaka. ");
INSERT INTO ndg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lakimi mitume, Barnaba na Paulo, payowine lee, batirarua ngobo yao na kwa haraka batiyenda panja mu'kipenga sa bandu, batilela ");
INSERT INTO ndg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","no baya, “Mwenga mwa bandu, kwa mwanja namani mugapanga makowe aga? Na twenga twaabandu kae tubile na hisia kati mwenga. Twaaletea habari njema, panga mukerebuke boka mu'ilebe yoo ifaika kwaa na kumkerebukiya Nnongo ywabile nkoto, ywaiumbile mbingu, dunia na bahari na kila kilebe kibile nkati yake. ");
INSERT INTO ndg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Katika nyakati ya nchogo, atibaruhusu mataifa kutyanga katika ndela zao bembe. ");
INSERT INTO ndg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","akini bado, aondoa kwaa bila shahidi, katika lee apangite vizuri na kuwapeya uula boka kumaunde na nyakati za mazao, abatweloe mioyo yinu kwa chakulya na puraha” ");
INSERT INTO ndg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hata kwa maneno aga, Paulo na Barnaba kwa shida batikikanikia kipenga sa bandu kubatolea sadaka. ");
INSERT INTO ndg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lakini baadhi ya Ayahudi boka Antiokia na Ikonio baisile kubashawishi bandu. Bamkombwile maliwe Paulo na kumburuta hadi panja ya mji, bakidhani awile. ");
INSERT INTO ndg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Hata nyoo banafunzi babile bayemi papipi naywembe, aliamka, nabajingii mjini. Lisoba lya nyaibele, atiyenda Derbe na Barnaba. ");
INSERT INTO ndg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Baada ya kufundisha injili katika mji wolo na kuwapanga banafunzi banyansima, batikerebukya Listra, mpaka Ikoniamu, na mpaka Antiokia. ");
INSERT INTO ndg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Batiyendelya kuimarisha nafsi ya banafunzi na kubatia mwoyo kuyendelya katika imani, kabaya.”Lazima tuyingii katika ufalme wa Nnongo kwa pitya mateso ganyansima.” ");
INSERT INTO ndg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paabanchawile kwa ajili yao apindo ba kila likuanyiko lya baaminio, na babile batiloba na kufunga, batikuakabithi kwa Ngwana, ambae bembe batikumwaminiya. ");
INSERT INTO ndg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Boka po baptya ku'Pisidia, pabaikite Pamfilia. ");
INSERT INTO ndg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Muda balongela maneno katika Perga, batiuluka kuyenda Atalia. ");
INSERT INTO ndg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Boka kolyo batipanda Antiokia ambako babile bamejitoa kwa neema ya Nnongo kwa ajili ya kazi ambayo nambeambe babile watiikamilisha. ");
INSERT INTO ndg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pabaikite Antiokia, na kulikusanya likusanyiko lya mpamo, batitoa taarifa ya makowe ambayo Nnongo agapangite kwa bandu ba mataifa. ");
INSERT INTO ndg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Batitama kwa muda mrefu na banafunzi. ");
INSERT INTO ndg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bandu fulani batiuluka boka Uyahudi na kuwafundisha alongo, babaya, “mana mwatairiwa kwaa kati destruri ya Musa, mwaweza kwa lopolelwa.” ");
INSERT INTO ndg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Muda Paulo na Barnaba babile na mapambano na mjadala pamope nao, alongo batiamua panga Paulo, Barnaba, na benge kadhaa bayende Yerusalem kwa mitume na apindo kwa ajili ya swali lee. ");
INSERT INTO ndg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kwa eyo kutumwa kwao na likanisa, bapetya Foinike na Samaria batitangaza kukerebukya nia kwa mataifa. Baletike puraha kolo kwa alongo bote, ");
INSERT INTO ndg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Baisile Yerusale, batikaribishwa na likanisa na mitume na apindo, na batiwasilisha taarifa ya makowe gote ambayo Nnongo apangite pamope na bembe. ");
INSERT INTO ndg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lakini bandu fulani batiaminia, babile katika likundi lya Mafarisayo, bayemite nobaya, “ni muhimu kubatahiri na kubaamuru baikamwe sheria ya Musa.” ");
INSERT INTO ndg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nga nyo mitume na apindo bayemi pamope kulifikiria swala lee. ");
INSERT INTO ndg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Baada ya malongelo ago marefu, Petro ayemi na kulongela kwao, “Alongo mutangite panga kitambo kinoite cha peta Nnongo apangite lichagu kati yinu, panga kwa nkano wango Mataifa baliyowe neno lya injili, na aminia. ");
INSERT INTO ndg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nnongo, ywautangite mwoyo, atishuhudia kwabe, abapeya Roho mtakatifu, kati ya apangite kwitu. ");
INSERT INTO ndg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","na atuchengya kwa utofauti kati yitu ni bembe, aipangite mioyo yabe safi kwa imani. ");
INSERT INTO ndg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kwa eyo kwa namani mwamjaribu Nnongo panga muibeke nira nnani ya ingo ya banafunzi ambayo hata tate bitu wala twenga twaweza kwa kustamili? ");
INSERT INTO ndg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lakini twaaminiya panga twalowa lopolelwa kwa neema ya Ngwana Yesu, kati ya babile. ");
INSERT INTO ndg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Likusanyiko lyote lyatinyamaza pababile bakimsikiliza Barnaba na Paulo pababile bakitoa taarifa ya ishara na maajabu ambayo Nnongo apangite pamope nabo kati ya bandu ba mataifa. ");
INSERT INTO ndg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pabalekite longela, Yakobo kayangwa nobaya, “Alongo munisikilize. ");
INSERT INTO ndg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni atielezea jinsi kwanza Nnongo kwa neema atibasaidia Mataifa ili panga ajipatie boka kwao bandu kwa ajili ya lina lyake. ");
INSERT INTO ndg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Maneno ga manabii yanakubaliana na lee kati lyaliandikilwe. ");
INSERT INTO ndg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Baada ya makowe aga nalowa kerebukya na kulichenga kae lihema lya Daudi, lyalitombokya pae; na nalowa kuiinua na kuhuisha uharibifu wake, ");
INSERT INTO ndg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ili panga bandu balo batisalia bampale Ngwana, pamope na bandu ba mataifa bakemilwe kwa lina lyango.' ");
INSERT INTO ndg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nga nyo alongela Ngwana ywapangite makowe aga yayowanike tangu enzi ya zamani. ");
INSERT INTO ndg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nga nyoo bai, ushauri wangu ni, panga kana tuwapeye shida bandu ba mataifa bamkerebukia Nnongo; ");
INSERT INTO ndg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lakini tuandike kwabe panga bajiepushe mable na uharibu ba sanamu, tamaa za uasherati, na nyongeza, na myai. ");
INSERT INTO ndg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Boka ibeleki ga apindo babile bandu katika kila mji wahubiria na kumsoma Musa katika masinagogi kila Sabato.” ");
INSERT INTO ndg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kwa eyo itibonekana kuwa yatibapendeza mitume na apindo, pamope na likanisa lyote, kuchawa Yuda ywakemelwa Barsaba na Silas, babile viongozi ba likanisa, na kubatuma Antiokia pamope na Paulo na Barnaba. ");
INSERT INTO ndg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Batiandika nyoo, “Mitume, apindo na alongo, kwa alongo ba Mataifa babile Antiokia, Shamu na Kilikia, salamu ");
INSERT INTO ndg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tuyowine panga bandu fulani ambao batibapatia kwaa amri yee, baboka kwitu na watibataabisha kwa afundisho galetayo shida mu'nafsi yinu. ");
INSERT INTO ndg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kwa eyo ibonekana vyema kwitu twabote kuchawa bandu na kubatuma kwinu pamope na apendwa witu Barnaba na Paulo, ");
INSERT INTO ndg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bandu babile bahatarisha maisha yabe kwa ajili ya lina lya Ngwana Yesu Kristo. ");
INSERT INTO ndg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kwa eyo twatimtuma Yuda na Sila, balowa kuwabakiya makowe hago ago. ");
INSERT INTO ndg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kwa kuwa itibonekana vyema kwa Roho Mtakatifu na kwitu, kubeka kwaa nnani yinu mzigo nkolo kuliko makowe aga gabile ya lazima: ");
INSERT INTO ndg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","panga mkerebuke boka mu'ilebe yatitolewa kwa sanamu, myai, ilebe ya kunyonga, na umalaya. Mana mwalowa jibeka kutalu na ayee, ipalika vyema kwinu. Kwa heri.” ");
INSERT INTO ndg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nga nyo bai, pabatawanyishwa, batiuluka Antiokia; baada ya kukusanya likusanyiko mpamo, batiwasilisha barua. ");
INSERT INTO ndg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pababile baisoma, batipuraika kwa sababu ya kutiwa mwoyo. ");
INSERT INTO ndg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, na manabii balibatia mwoyo alongo kwa maneno ganyansima na kubapeya ngupu. ");
INSERT INTO ndg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Baada ta tama kwa muda fulani kolyo, batibatawanyisha kwa amani boka kwa alongo kwa balo babatumile. ");
INSERT INTO ndg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Lakini ibonekana vyema Sila kubaki kolyo) ");
INSERT INTO ndg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Lakini Paulo na benge batami Antiokia pamope na benge bengi, ambapo batifundisha na kuhubiri neno lya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Baada ya masoba kadhaa Paulo kambakiya Barnaba, “Tukerebukyange nambeambe na kubatembelea alongo katika kila mji twalihubiri neno lya Ngwana, na kuabona babile namani. ");
INSERT INTO ndg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba apala kuntola Yohana pamope ni bembe ywakemwa Marko. ");
INSERT INTO ndg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lakini Paulo kawaza kuwa inoite kwaa kuntola Marko, ywaalekite Pamfilia na ayendelea nabo kwaa katika kazi. ");
INSERT INTO ndg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pabile na mabishano makolo kwa eyo batitengana, na Barnaba atintola Marko na kusafiri kwa meli mpaka Kipro, ");
INSERT INTO ndg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Lakini Paulo atimchawa Sila na kuboka, baada ya kukabidhiwa na alongo katika neema ya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Na atiyenda pitya Shamu na Kilikia, atiimarisha makanisa. ");
INSERT INTO ndg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo paaisile Derbe na Lystra; linga, palo pabile na mwanafunzi ywakemelwa Timotheo, ni muinja ywabelekwile na mao wa Kiyahudi ambaye ni muumini na tate bake ni Mgirki. ");
INSERT INTO ndg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bandu ba Listra na Ikonio batimshuhudia vizuri. ");
INSERT INTO ndg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo atimpala ili asafiri niywembe, nga nyo atimtola na kumtahiri kwa sababu ya Bayahudi babile kolyo mana baote bantangite kuwa tate bake ni Mgiriki. ");
INSERT INTO ndg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","5","Pabayenda bapetya katika miji na kutoa maagizo kwa makanisa ili kugatii maagizo ayo yaandikilwe na mitume na apindo kolyo Yerusalemu. Nga nyo makanisa yatiimarishwa katika imani na baamini bationgezeka kwa idadi kila lisoba. ");
INSERT INTO ndg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo na mwenzake batiyenda Firigia na Galatia, mana Roho wa Nnongo atibakanikia kuhubiri neno kolyo katika jimbo lya Asia. ");
INSERT INTO ndg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pabakaribia Misia, batijaribu yenda Bithinia, lakini Roho wa Yesu atibakanikia. ");
INSERT INTO ndg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kwa eyo bapeta Misia baisa mpaka Mji wa Troa. ");
INSERT INTO ndg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Maono gatimtokya Paulo kilo, pabile na mundu ba Makedonia ayemi, akimkema no baya, “Muise mtusaidie huku Makedonia.” ");
INSERT INTO ndg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo paabweni maono mara twatijiandaa kuyenda, Makedonia, atangite panga Nnongo atukemle kuyenda kubahubiria injili. ");
INSERT INTO ndg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nga nyoo tubokite boka Troa, kuyenda moja kwa moja Samothrake, na lisoba lyanyaibele tuikite mji wa Neapoli. ");
INSERT INTO ndg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Boka hapo twatiyenda Filipi ambao ni yumo wa ga Makedonia, mji muhimu katika wilaya na utawala wa Kirumi na twatitama masoba kadhaa. ");
INSERT INTO ndg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lisoba lya Sabato, twatiyenda panja ya nnango kwa ndela ya mto, sehemu ambayo twatidhani pabile na mahali pakupanga maombi. Twatitama pae na longela na alwawa baisile mpamo. ");
INSERT INTO ndg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nwawa yumo ywakemelwa Lidia, ywapemeya zambarau, boka katika mji wa Tiatira, ywatimwabudu Nnongo, atitusikiliza. Ngwana atimfungua mwoyo wake na kubeka maanani maneno yabayilwe na Paulo. ");
INSERT INTO ndg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Baada ya batizwa, ywembe na nyumba yake yote, balitusihi akibaya, “kati mwamunibweni kuwa nenga na mwaminifu katika Ngwana, bai nawasihi mujingii na tama kwango.”Atitusihi muno. ");
INSERT INTO ndg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ipalike panga, patubile twayenda mahali kuloba, nwawa yumo ywabile na nchela lya utambuzi atikwembana natwenga. Atimletea ngwana wake faida yanyansima kwa kubashiri. ");
INSERT INTO ndg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nwawa yolo atimkengama Paulo pamope na twenga, akombwa ndoti no baya “Haba alalome ni batumishi ba Nnongo ywabile nkolo, watibatangazia mwenga habari ya wokovu.” ");
INSERT INTO ndg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Apangite nyoo kwa masoba ganyansima, lakini Paulo abile amekasirishwa na likowe loo, atikerebuka kunchogo na kummakiya nchela, “Nakubakiya kwa lina lya Yesu uboke nkati yake.” Ni ywembe atiboka ma kunleka mara jimo. ");
INSERT INTO ndg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Angwana bake pabamweni ya kuwa litumaini lya faida yabe latibutuka, batimkamwa Paulo na Sila na kubaburuza kulisoko nnongi yababile na mamlaka. ");
INSERT INTO ndg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","pabaikilwe kwa mahakimu, babaya, “Aba alalome ni Ayahudi na batipanga ghasia ngolo katika mji witu. ");
INSERT INTO ndg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bafundisha makowe ambayo nga saliya kwaa twenga kugapokya wala kugakengama kati Arumi.” ");
INSERT INTO ndg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kipenga chatiinuka nchogo ya Paulo na Sila, mahakimu batirarua ngobo zao na kubavua na kubaamuru babakombwe bakora. ");
INSERT INTO ndg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Baada ya kubakombwa bakora zanyansima batibatupa muligereza na kumuamuru askari ba ligereza kubalinda vyema. ");
INSERT INTO ndg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Baada ya kupokya amri yee, askari wa ligereza atibatupa katika chumba cha nkati ya ligereza na kubataba magolo gabe katika sehemu yaatibahifadhi. ");
INSERT INTO ndg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Muda wa kilo ya manane, Paulo na Sila babile batiloba na kuimba nyimbo za kunsifu Nnongo, huku afungwa benge bakibasikiliza. ");
INSERT INTO ndg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ghafa patitokya lilendemo kolo na misingi ya ligereza yatitikisika, nnango wa ligereza watifunguka, na minyororo ya bafungwa bote yatilegezwa. ");
INSERT INTO ndg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mlinzi wa ligereza atiamka boka mulugona na kubona milango yote ya ligereza yatifunguka: nga nyo atitola upanga wake mana apala kujibulaga kwa sababu atangite kuwa afungwa bote batitorka, ");
INSERT INTO ndg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lakini, Paulo kakombwa ndoti kwa lilobe likolo, kabaya “Kana ujidhuru kwa mana twabote tubile mahali pano.” ");
INSERT INTO ndg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mlinzi wa ligereza aloba taa iletwe na kujingya nkati ya ligereza kwa haraka, atirendema na kuogopa, atitomboka pae ya Paulo na Sila, ");
INSERT INTO ndg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","na kubatoa panja ya ligereza nobaya, “Waheshimiwa, nipange namani ili nipate kuokoka?” ");
INSERT INTO ndg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na bembe bammakiya, “Muamini Ngwana Yesu niwenga walowa kuokkoka pamope na nyumba yako.” ");
INSERT INTO ndg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Batilongela neno lya Ngwana kwake, pamope na bandu bote ba nyumba yake, ");
INSERT INTO ndg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mlinzi wa ligereza atibatola kilo yelo na kuwaosha sehemu baumile, ywembe pamope na bandu ba munyumba yake batibatiza mara. ");
INSERT INTO ndg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Atibaleta Paulo na Sila mu'nyumba yake na kubaandalia chakulya. Ni ywembe abile na puraha kolo pamope na bandu ba mu'nyumba yake kwa sababu balimwamini Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Paiikite mutwekati, mahakimu batituma ujumbe kwa yolo mlinzi ba ligereza bakibaya, “Baruhusu balo bandu bayende,” ");
INSERT INTO ndg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mlinzi wa ligereza kammakiya Paulo nnani ya maneno ago ga kuwa, “Mahakimu batituma ujumbe niruhusu mwondoke: nga nyoo muboke panja na muyende kwa amani.” ");
INSERT INTO ndg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lakini Paulo ammakiye, “Balitukombwa hadharani, bandu ambao ni Arumi bila kutuhukumu na batiamua kututupa mu'ligereza; alafu nambeambe bapala kututoa kwa siri? Ntopo, yawezekana kwaa, bembe babene baise kututoa mahali pano.” ");
INSERT INTO ndg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Balinzi batibajulisha mahakimu nnani ya maneno ago, mahakimu batiyogopa muno palo batangite kuwa Paulo na Sila ni Arumi. ");
INSERT INTO ndg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mahakimu baisile na kuwasihi baboke, na batibatoa panja ya ligereza, batibaloba Paulo na Sila batoke panja ya mji wabembe. ");
INSERT INTO ndg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kwa eyo Paulo na Sila batiboka panja ya ligereza baisa mu'nyumba ya Lidia. Paulo na Sila pababweni alongo, batibatia mwoyo na boka po batiboka katika mji woo. ");
INSERT INTO ndg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Muda bapeta katika niji ya Amfipoli na Apolonia, baisile mpaka mji wa Thesalonike ambao pabile na sinagogi lya Ayahudi. ");
INSERT INTO ndg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Mana yaibile kawaida ya Paulo, ateyenda kwao, na kwa muda wa masoba matatu ga Sabato atijadiliana nabo nnani ya maandiko. ");
INSERT INTO ndg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Abile akibafungulia maandiko na kubaelekeza kuwa, impalike Kristo ateseke na boka po atifufuka kae na boka kwa bandu ba kiwo. Atiamakiya, “Yolo Yesu ywaniabakiye habari yake nga Kristo” ");
INSERT INTO ndg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Baadhi ya Ayahudi batishawishika na kukengama na Paulo na Sila, pamope na Agiliki achaNnongo, alwawa banyansima baongofu na likundi likolo lya bandu. ");
INSERT INTO ndg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lakini baadhi ya Ayahudi baaminiya kwaa, batwelile na bwiu, batiyenda kusoko na kubatola baadhi ya bandu baovu, batikusanya kipenga sa bandu pamope, na kusababisha ghasia mjini, boka po batiivamia nyumba ya Jason, bapala kubakamwa Paulo na Sila ili kubaleta nnongi ya bandu. ");
INSERT INTO ndg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Lakini batiwakosa, bankamwile Yasoni na baadhi ya alongo benge na kubapeleka nnongi ya maofisa ba mji, bakombwa ndoti, “Aba analome batiupimdua ulimwengu baikite mpaka huku pia, ");
INSERT INTO ndg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Analome aha batikaribishwa na Yasoni batiiharibia saliya ya Kaisaria, babaya pabile na mpwalume ywenge ywakemelwa Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kipenga sa bandu na maofisa ba mji pabayowine makowe ago, bajingii na wasiwasi. ");
INSERT INTO ndg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Badala ya kuwa bayomwile kutola mbanje ya thamani ya ulinzi boka kwa Yasoni na benge, batibaachia bayende. ");
INSERT INTO ndg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kilo chelo alongo batintuma Paulo na Sila Beroya. Na balipofika kolyo batiyenda katika lisinagogi lya Ayahudi. ");
INSERT INTO ndg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bandu balo babile na uwerevu nkolo kuliko balo bandu ba Thesalonike, kwa sababu babile na utayari wa kulipokya neno kwa ajili yabe, na kuchunguza maandiko kila lisoba ili kuona mana maneno galongelwa nga yabile kati yayabile. ");
INSERT INTO ndg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kwa eyo baingi babe batiamini, babile na anwawa babile na ushawishi nkolo ba Kigiriki na analome banyansima. ");
INSERT INTO ndg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lakini Ayahudi na Thesalonike pabatigundua panga Paulo anatangaza neno lya Nnongo kolyo Beroya, batiyenda kolyo na kuchochea na boka po kuanzisha ghasia kwa bandu. ");
INSERT INTO ndg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kwa haraka, alongo batimpeleka Paulo kwa ndela ya ziwa, Lakini Sila na Timotheo babaki kolyo. ");
INSERT INTO ndg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Balo alongo batimpeleka Paulo batiyenda niywembe hadi Athene, banlekite Paulo kolyo, batipokya maagizo boka kwake kuwa, Sila na Timotheo baise kwa haraka yaiwezekana. ");
INSERT INTO ndg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Na muda akibalenda kolyo Athene, roho yake itikasirishwa nkati yake kwa namna yaaubweni mji utwelilwe sanamu zanyansima. ");
INSERT INTO ndg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nga nyoo atilongela katika sinagogi na Ayahudi balo batincha Nnongo na kwa balo akwembine nabo kila lisoba mu'soko. ");
INSERT INTO ndg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Lakini baadhi ya Banafalsafa ba Baepikureo na Wetoiko batibakabili. Benge babaya, “Namani chaakilongela yolo mlongelaji nchunu? Benge babaya, “Ibonekana atihubiri habari ya nnongo mgeni,” kwa sababu ahubiria habari ya Yesu na ufufuo. ");
INSERT INTO ndg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kabantola Paulo na kunneta Areopago, babaya, “Twaweza yowa aga mafundisho mapya yaugalongela? ");
INSERT INTO ndg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kwa mana waletya makowe gayambe katika makutu yitu. Kwa eyo twapala kugatanga makowe yabile ba maana gani?” ");
INSERT INTO ndg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Na bandu bote ba Athene pamope na ageni babile kwao, utumia muda wao katika longela na kusikiliza nnani ya likowe lya ayambe. ");
INSERT INTO ndg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kwa eyo Paulo ayemi nkati ya bandu ba Areopago no baya, “Mwenga mwa bandu, naboa kuwa mwenga mwa bandu ba dini kwa kila namna, ");
INSERT INTO ndg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwani katika pitya kwango na kulola ilebe yinu ya kuabudu, niabweni maneno yatiandikwa katika jimo ya madhabahu yinu, labaya, “KWA NNONGO YWAJULIKANA KWAA,” Nga nyo bai, yolo mwamumwabudia bila tanga, ywamwajulisha mwenga. ");
INSERT INTO ndg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nnongo ywaiumbile dunia na kila kilebe chabile nkati, kwa mana ni Ngwana wa kumaunde na nchi, aweza kwaa tama mu'mahekalu gachengwile na maboko. ");
INSERT INTO ndg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Na utmikiwa kwaa na maboko ga bandu kati panga wahitaji kilebe kwabe, kwani ywembe mwene awapeya bandu na pumzi na ilebe yenge yote. ");
INSERT INTO ndg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Pitya mundu yumo, apangite mataifa gote ya bandu batama nnani ya minyo ga dunia, na atibabekya muda na mipaka katika maeneo batama. ");
INSERT INTO ndg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kwa eyo, baloba kumpala Nnongo, na yamkini bamfikie na kumpata, na kwa uhakika abile kwaa mbale na kila yumo witu. ");
INSERT INTO ndg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kwake twatama, twatyanga na kuwa na ukoto witu, mana chelo mtunzi winu yumo wa shairi alongela 'tubile abelekwi bake'. ");
INSERT INTO ndg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kwa eyo, mana itei twenga nin abelekwi ba Nnongo, twapalikwa kwaa kufikiri kuwa uungu ni kati dhahabu, au shaba, au maliwe, sanamu yaichongwa kwa ustadi na malango ga bandu. ");
INSERT INTO ndg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kwa eyo, Nnongo atinyamaza muda wolo wa ulalo, lakini nambeambe atiamuru bandu bote kila mahali bapate kutubu. ");
INSERT INTO ndg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ayee nga sababu atibeka lisoba lyapala kuihukumu dunia kwa haki kwa mundu ywabile atimchawa. Nnongo atitoa uhakika wa mundu yolo kwa kila mundu kolyo atiyoka boka mu'kiwo. ");
INSERT INTO ndg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Na bandu ba Athene bayowine habari ya kufufuliwa kwa bandu ba kiwo, baadhi yao batimdhihaki Paulo, ila benge babaya, “Twalowa kukuyowa kae kwa habari ya likowe lee” ");
INSERT INTO ndg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Baada ya hapo, Paulo atibaleka. ");
INSERT INTO ndg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lakini baadhi ya bandu batikengamana niywembe baaminiya, na Dionisio Mwareopago, na Nwawa akemelwa Damari na ywenge pamope nabembe. ");
INSERT INTO ndg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Baada ya makowe ago, Paulo ayei Athene kuyenda Korintho. ");
INSERT INTO ndg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kolyo atimpata Myahudi ywakemelwa Akwila mundu wa likabila lya Ponto, ywembe na nyumbo wake ywakemelwa Prisila baisile boka kolyo Italia, kwa sababu Klaudia atiamuru Ayahudi bote bayende Roma; Paulo aisa kwao; ");
INSERT INTO ndg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulo atami na kupanga kazi nabembe mana ywembe apanga kazi yatilingana na bembe. Bembe babile na achenga mahema. ");
INSERT INTO ndg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paulo alongela nao mu'lisinagogi kila lisoba lya Sabato. Atibashawishi Ayahudi pamope na Bagiriki. ");
INSERT INTO ndg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lakini Sila na Timotheo pabaisile boka Makedonia, Paulo atisukumwa na Roho kubashuhudia Ayahudi kuwa Yesu nga Kristo. ");
INSERT INTO ndg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Muda Ayahudi batimpinga na kumdhihaki, nga nyo Paulo atikung'uta ngobo yake nnongi yabe, na kubamakiya, “Myai yinu na ibe nnani ya ntwe yinu bene; Nenga nibile kwaa na hatia. Boka nambeambe na kuendelea, nabayendea Mataifa.” ");
INSERT INTO ndg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nga nyo atiyenda kuboka pale kayenda mu'nyumba ya Tiro Yusto, Mundu ywamudu Nnongo. Nyumba yake ibile papipi na lisinagogi. ");
INSERT INTO ndg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispo, kiongozo ba lisinagogi pamope na bandu ba nnyumba yake bamwaminiya Ngwana. Bandu banyansima ba Korintho bamyowine Paulo akilongela batiaminiya na kubatizwa. ");
INSERT INTO ndg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ngana kalongela na Paulo kilo kwa ndela ya maono, “Kana uyogope, lakini ulongele na kana unyamae. ");
INSERT INTO ndg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Mana nenga nibile pamope na wenga, na ntopo ywalowa jaribu kukudhuru, mana nibile na bandu banyansima katika mji wolo. ");
INSERT INTO ndg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulo atama kwoo kwa muda wa mwaka na miei sita atifundisha neno lya Nnongo nkati yabe. ");
INSERT INTO ndg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lakini Galio paapangilwe mtawala wa Akaya, Bayahudi bayemi pamope kunchogo na Paulo na kumpeleka nnongi ya iteo sa hukumu, ");
INSERT INTO ndg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","babaya, “Mundu yolo ubashawishi bandu bamwabudu Nnongo kinchogo na saliya.” ");
INSERT INTO ndg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Muda Paulo abile apala kubaya, Galio kaabakiya Ayahudi, “Mwenga mwa Ayahudi, mana ibile ni likosa au uhalifu, ibile halali kubashuhulikia. ");
INSERT INTO ndg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lakini kwa sababu ni maswali, yabile nnani ya maneno na maina, na saliya yinu, bai muhukumu mwenga mwabene. Nenga natamaniya kwaa pangika hakimu kwa habari ya makowe ayo.” ");
INSERT INTO ndg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galio atibaamuru baboke nnongi ya iteo sa hukumu. ");
INSERT INTO ndg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nga nyo bantabile Sosthene, kiongozi ba lisinagogi, bankombwile nnongi ya iteo sa hukumu. Lakini Galio ajali kwaa bakipangite. ");
INSERT INTO ndg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo baada ya tama palo kwa muda mrefu, abalekite alongo na kuyenda kwa meli Siria pamope na Prisila na Akwila. Kabla ya boka bandarini, atinyoa nywili yake mana abile atilapa kuwa Mnadhiri. ");
INSERT INTO ndg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pabaikite Efeso, Paulo amlekite Prisila na Akwila palo, lakini ywembe mwene ajingii mu'lisinagogi na kulongela na Ayahudi. ");
INSERT INTO ndg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bammakiye Paulo atame nabembe kwa muda mrefu, ni ywembe akani. ");
INSERT INTO ndg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lakini atiboka kwao, kaabakiya, “Nalowaakerebukiya kae kwinu, mana itei ni mapenzi ya Nnongo.”Baada ya hapo, ayei kwa meli boka Efeso. ");
INSERT INTO ndg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paulo paaikite Kaisaria, atipanda no yenda likanisa lya Yerusalemu, boka po atiuluka pae kwa likanisa lya Antiokia. ");
INSERT INTO ndg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Baada ya tama kwa muda kolyo, Paulo ayei pitya maeneo ga Galatia na Frigia na kubapeya mwoyo banapunzi bote. ");
INSERT INTO ndg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Myahudi yumo ywakemelwa Apolo, aisileb Efeso. Abile na ufasaha katika kulongela na hodari katika maandiko. ");
INSERT INTO ndg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolo abile ameelekezwa katika mafundisho ga Ngwana. Kwa namna abile na bidii katika roho, alongela na kubafundisha kwa usahihi makowe yanayomuhusu Yesu, ila atangite tu ubatizo wa Yohana. ");
INSERT INTO ndg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolo atumbwi longela kwa ujasiri katika hekalu. Lakini Prisila na Akwila pabamyowine, bapangite urafiki niywembe na kumweleza nnani ya ndela ya Nnongo kwa usahihi. ");
INSERT INTO ndg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Paatamaniya kuboka kuyenda Akaya, alongo bampeya mwoyo na kubaandikiya barua banafunzi babile Akaya ili bapate kumpokya. Paaisile, kwa neema atibasaidia muno balo baaminiya. ");
INSERT INTO ndg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kwa nguvu yake na maarifa. Apolo alibazidi Ayahudi hadharani atibonekeya pitya maandiko yakuwa Yesu nga Kristo. ");
INSERT INTO ndg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mana itei panga Apolo abile Korintho, Paulo apeta nyanda za nnani na aikite katika mji wa Efeso, na akwembine na banafunzi bake badhaa. ");
INSERT INTO ndg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paulo kaamakiya, “Je, mwatimpokya Roho mtakatifu pamuaminiya?” Bammakiya, “Hapana, twaweza kwaa kuyowa nnani ya Roho Mtakatifu.” ");
INSERT INTO ndg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo kabaya, “Nambeambe mwenga mwabatizwa kinamani?” Babaya, Katika ubatizo wa Yohana.” ");
INSERT INTO ndg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bai Paulo kaayangwa, “Yohana alibatiza kwa ubatizo wa toba. Kaabakiya balo bandu panga bapalikwa kumwamini yolo ywaisa baada yake, yaanu, Yesu.” ");
INSERT INTO ndg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bandu bayowine habari yee, batibatizwa kwa lina lya Ngwana Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ipangike Paulo paabekite maboko gake nnani yabe, Roho Mtakatifu kaisa nnani yabe na batumbwile longela kwa lugha na kutabiri. ");
INSERT INTO ndg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jumla ya bembe babile analome komi ni ibele. ");
INSERT INTO ndg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo atiyenda katika lisinagogi kalongela kwa ujasiri muda wa miezi mitatu. Abile akiongoza kalongela na kuwavuta bandu kuhusu makowe yanayohusu ufalme wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lakini Ayahudi benge babile makaidi na basalitia kwaa, batumbwile baya mabaya kuhusu ndela ya Kristo nnongi ya kipenga sa bandu. Bai Paulo aliachana na bembe na kubatenga baaminio kutalu na bembe. Ywembe atumbwile longela kila lisoba katika ukumbi wa Tirano. ");
INSERT INTO ndg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ayee itiyendelea kwa miaka ibele, kwa eyo bote babile batama katika Asia baliyowine neno lya Ngwana, bote Bayahudi na Bayunani. ");
INSERT INTO ndg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nnongo abile akipanga matendo makolo kwa maboko ga Paulo, ");
INSERT INTO ndg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","panga hata atamwe bapatike ukoto, na kubabutua roho achafu, muda batitola leso na ngobo zazibokite mu'yega ya Paulo. ");
INSERT INTO ndg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Lakini pabile na Ayahudi batipunga mbepo bakisafiri pitya lieneo lee, batilitumya lina lya Yesu kwa ajili ya matumizi yabe bene. Bakiabakiya balo babile na nchela achafu; Babaya, “Nabaamuru mboke kwa lina lya Yesu ywamuhubiria Paulo” ");
INSERT INTO ndg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bapangite aga babile bana saba ba kuhani Nkolo ba Kiyahudi, Skewa. ");
INSERT INTO ndg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Roho achafu bayangwa, “Uesu nimtangite, na Paulo nimtangite, lakini mwenga mwa nyai?” ");
INSERT INTO ndg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yolo roho nchafu nkati ya mundu atiabutukia bapunga nchela na atibashinda nguvu na kuakombwa. Nga batibutuka boka yolo nyumba baile atopo na jeruhiwa. ");
INSERT INTO ndg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Likowe lee lyatiyowanika kwa bote. Ayahudi na Bayunani, ambao batami kolyo Efeso. Babile na hofu muno, na lina lya Ngwana lyatizidi kuheshimiwa. ");
INSERT INTO ndg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Pia, baingi ba baumini baisile na bakaungama na batidhihirisha matendo mabaya bayapangite. ");
INSERT INTO ndg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Baingi babile bapanga uganga batikusanya itabu yabe, batiitiniya mwoto nnongi ya kila mundu. Muda wabe batilangilwa thamani ya ilebe yoo, ibile ipande hamsini elfu ya mbanje. ");
INSERT INTO ndg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nga nyo Neno lya Ngwana lyatienea kwa upana muno katika nguvu. ");
INSERT INTO ndg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Baada ya Paulo kamilisha huduma yake kolyo Efeso, Roho atimwongoza kuyenda Yerusalemu pitya Makedonia na Akaya; Kabaya, “Baada ya tama kolyo, ipalikwa kuibona Rumi kae.” ");
INSERT INTO ndg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Paulo atibatuma Makedonia banfunzi bake abele, Timotheo na Erasto, ambao babile batimsaidia. Lakini ywembe mwene atitama Asia kwa muda. ");
INSERT INTO ndg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Muda woo itipangika ghasia ngolo kolyo EFeso kuhusu yelo ndela. ");
INSERT INTO ndg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sonara yumo lina lyake Demetrio, ywachenga sanamu ya mbanje ya nongo Diana, aletike biashara ngolo kwa mafundi. ");
INSERT INTO ndg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nga nyo atibakusanya, mafundi ba kazi yee nobaya, “Baheshimiwa, mutangite panga katika biashara yee twenga twapata mbanje yanyansima. ");
INSERT INTO ndg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mwalola na muyowine panga, twenga kwaa pano Efeso, ila karibia Asia yoti, ayoo Paulo atibashawishi na kubakerebuya bandu banyansima. Abaya panga ntopo nnongo ambayo ichengwa kwa maboko. ");
INSERT INTO ndg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na ibile kwaa hatari panga biashara yitu yalowa itajika kwaa kae, lakini pia na lihekalu lya nnongo nyumbo ywabile nkolo Diana aweza tolwa kwa mana abile kwaa na maana. Kae aweza kupoteza ukolo wake, ywembe ambae Asia na dunia yatimwabudu.” ");
INSERT INTO ndg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pabayowine aga, batwelilwe na hasira na bakombwa ndoti, babaya, “Diana wa Efeso ni nkolo.” ");
INSERT INTO ndg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mji woti utwelile ghasia, na bandu batibutuka pamope nkati ya ukumbi wa michezo, baakamwa basafiri na Paulo, Gayo na Aristariko, babokite Mekedonia. ");
INSERT INTO ndg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo apala kujingya katika kipenga sa bandu, lakini banafunzi batimzuia. ");
INSERT INTO ndg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pia, baadhi ya maafisa ba mkoa wa Asia ambao babile mambwiga bake batimpelekea ujumbe kwa nguvu kunnoba kana ajingii kayika ukumbi ba michezo. ");
INSERT INTO ndg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Baadhi ya bandu babile babaya kilebe chelo na benge likowe lelo, kwa sababu kipenga sa bandu satichanganyika. Baingi babe baweza kwaa hata kuyowa kwa mwanja namani baisile pamope. ");
INSERT INTO ndg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bayahudi bannetike Iskanda panja ya kipenga sa bandu na kumbeka nnani nnongi ya bandu. Iskanda aboite ishara kwa luboko lwake kutoa maelezo kwa bandu. ");
INSERT INTO ndg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lakini batilitambua kuwa ywembe ni Myahudi, bote baikombwa ndoti kwa likowe limo kwa muda wa masaa ibele, “Diana nga nkolo ba Efeso.” ");
INSERT INTO ndg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Baada ya karani ba mji kukinyamazisha kipenga sa bandu, abaya,'Mwenga mwaalalome ba Efeso, ywa nyai ywatangite kwaa panga mji ba Efeso ni mtunza wa lihekalu lya Diana nkolo na yelo picha yatitomboka boka kumaunde? ");
INSERT INTO ndg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kubona bai panga makowe aga yawezekana kwaa, tupalika kuwa na utulivu na kana mupange chochote kwa haraka. ");
INSERT INTO ndg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kwa mana mwaakema bandu aba pano mahakamani ambao ni anyang'anyi kwaa ba lihekalu wala babile kwaa kumkufuru nongo witu nyumbo. ");
INSERT INTO ndg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kwa eyo, mana Demetrio na mafundi babile pamope niywembe babile na mashitaka nnani ya mundu yeyote, mahakama ibile wazi na maliwali babile. Na baletwe nnongi ya lishauri. ");
INSERT INTO ndg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Lakini mana wenga upala chochote kuhusu makowe genge, yalowa shughulukiwa katika kiako halali. ");
INSERT INTO ndg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwa kweli tubile katika hatari ya tuhumiwa kuhusu ghasia ya lisoba lee. Ntopo sababu ya machafuko aga, na tubile kwaa na uwezo wa kugaelezea. ");
INSERT INTO ndg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Baada ya kubaya aga, atibatawanya bandu. ");
INSERT INTO ndg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Baada ya ghasia kuyomoka, Paulo alibakema banafunzi na kupeya mwoyo. Boka po atibaaga na kuboka kuyenda Makedonia. ");
INSERT INTO ndg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Niywembe paapeta mikoa yee na abile akibapeya mioyo baumini, kajingya Yunani. ");
INSERT INTO ndg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Baada ya ywembe kuwa palo kwa muda wa miei itatu, njama zichengwite dhidi yake na Ayahudi paabile atikaribia kusafifiri kwa ndela ya bahari elekya Shamu, ayee atiazimia kerebuka pitya Makedonia. ");
INSERT INTO ndg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bakengamana na ywembe mpaka Asia babile Sopatro, mwana wa Pirho boka Berea; Aristariko na Sekundo, bote boka baamini ba Thesalonike; Gayo ba Derbe; Timotheo; Tikiko na Trofimo boka Asia. ");
INSERT INTO ndg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Lakini bandu aba bayomwile tangulia na babile batulenda kolyo Troa. ");
INSERT INTO ndg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","kwa ndela ya Bahari boka Filipi baada ya masoba ga mikate yaibekwa kwaa chachu, na katika masoba matano tuikite kolyo Troa. Tutama kolyo kwa masoba saba. ");
INSERT INTO ndg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hata lisoba lya kwanza lya wiki, patubile twatikwembana pamope ili kuutekwa mkate, Paulo atilongela na Baamini. Abile akiwza kuboka malabo yake, nga nyo atiendelea longela mpaka kilo ya manane. ");
INSERT INTO ndg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Pabile na taa zanyansima katika chumba cha nnani ambapo tubile twatikwembana pamope. ");
INSERT INTO ndg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Katika lidirisha abile atami muinja yumo lina lyake Utiko, ywabile na lugono likolo. Hata Paulo paabile akilongela kwa muda mrefu, muinja yolo, agonjike, atitomboka pae boka lighorofa lya tatu na atilokotwa abile tayari awile. ");
INSERT INTO ndg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lakini Paulo atiuluka pae, atijinyoosha ywembe mwene nnani yake, atimkumbatia. Katika baya, “Kana mkate tamaa, kwa kuwa abile nkoto.” ");
INSERT INTO ndg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Boka po atipanda kae kulighorofa na atiutekwana mkate, no lyaa. Baada ya longela kwa muda mrefu mpaka lyamba, atiboka. ");
INSERT INTO ndg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bannetike yolo muinja abile nkoto batifarijika muno. ");
INSERT INTO ndg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Twenga twabene twatitangulia nnongi ya Paulo kwa meli na yenda Aso, ambapo twenga tulipanga kuntola Paulo kolyo. Ayee nga ywembe mwene ywapala kupanga, kwa mana atipanga yenda pitya nnema nkavu. ");
INSERT INTO ndg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Paatuikite twenga kolyo Aso, twatimtola mu'meli kuyenda Mitilene. ");
INSERT INTO ndg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Boka po twenga twatitweka kolyo na lisoba lyanyaibele tuikite upande wanyaibele wa kisiwa cha Kio. Lisoba lyanyaibele, tuikite kisiwa cha Samo, na malabo take tuikite mji wa Mileto. ");
INSERT INTO ndg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kwa mana, Paulo abile atiamua safiri pitya Efeso, ili panga kana atumie muda wowote katika Asia; kwa mana abile na haraka ya kuwai Yerusalemu kwa ajili ya sikukuu ya Pentekoste, mana yawezekana ywembe kupanga nyoo. ");
INSERT INTO ndg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Boka Mileto atibatuma bandu mpaka Efeso na kubakema apindo ba likanisa. ");
INSERT INTO ndg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Paaikite kwake, kammakiya, mwenga mwabene mutangite tangu lisoba lya kwanza panikanyaga hapa Asia, jinsi ya nibile kwinu muda wote. ");
INSERT INTO ndg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Namtumikya Ngwana kwa unyenyekevu wote na kwa machozi, na ");
INSERT INTO ndg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","mateso yanipatike nenga kwa hila za Ayahudi. Mutangite namna ambayo naizuia kutangaza kwinu ilibe chochote ambacho kibile muhimu, na namna nenga natibafundisha waziwazi na kuyenda nyumba kwa nyumba. ");
INSERT INTO ndg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mutangfite namna nenga mayendelya kubaonya Ayahudi na Ayunani nnani ya toba kwa Nnongo na imani katika Ngwana witu Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nambeambe, muilinge, nibile namtii Roho Mtakatifu kuelekea Yerusalemu, niyatangite kwaa makowe ambayo yanipangikie nenga kolyo, ");
INSERT INTO ndg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ila kwa mana Roho Mtakatifu unishuhudia nenga katika kila mji no baya panga minyororo na mateso nga nyoo vyatinilenda. ");
INSERT INTO ndg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lakini nenga nafikiria kwaa panga maisha yangu ni kwa yeyote ya thamani kwango, ili niweze kuyomwa mwendo wango na huduma yanipeyilwe boka kwa Ngwana Yesu, kuishuhudia injili ya nema ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nmabeambe, linga, nitangite panga wote, nkati ya balo baniyendike kuhubiri Ufalme, mwanibona kwaa minyo kae. ");
INSERT INTO ndg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kwa eyo nabashuhudia leno yee, panga nibile kwaa na hatia ya myai ya mundu yeyote. ");
INSERT INTO ndg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwa mana naizuia kwaa kubatangazia mapenzi yoti ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kwa eyo muwe baangalifu nnani yinu mwenga mwabene, na nnani ya likundi lolote ambalo Roho Mtakatifu atiabeka mwenga kuwa waangalizi. Mube aangalifu kulichunga likusanyiko lya Ngwana, ambalo atilipemya kwa myai yake mwene. ");
INSERT INTO ndg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nitangite panga baada ya kuboka kwango, mapwa ba mwitu akale balowa jingya nkati yinu, na baliwa kulihurimya kwaa likundi. ");
INSERT INTO ndg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nitangite panga hata nkati yinu mwabene baadhi ya bandu baisa no baya makowe mabou, ili kuwavuta banafunzi babakengame bembe. ");
INSERT INTO ndg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kwa eyo mutame minyo. Mukombokye panga kwa miaka mitatu naweza kwaa kuleka kuwafundisha kila yumo winu kwa machozi kilo ni mutwekati. ");
INSERT INTO ndg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nambeambe nenga nawakabidhi kwa Nnongo, na kwa neno lya neema yake laweza kuachenga na kuwapea urithi pamope nabo bote batiwekwa wakfu kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Natamaniya kwaa mbanje, dhahabu, au ngobo. ");
INSERT INTO ndg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mutangite mwenga mwabene panga maboko aga inipeya mahitaji yango mwene na mahitaji ya balo babile pamope ni nenga. ");
INSERT INTO ndg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Katika makowe yote naapeya mfano wa namna mupalikwa kuwasaidia anyonge kwa kuipanga kazi, na namna mupalikwa kukombokya maneno ya Ngwana Yesu, maneno ambayo ywembe mwene abayite: “Ni heri kutoa kuliko pokya.” ");
INSERT INTO ndg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Baada ya kubaya namna yee, apiyite magoti na kuloba pamope na bembe. ");
INSERT INTO ndg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bote batilela muno na kumtombokya Paulo paingo na kumbusu. ");
INSERT INTO ndg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Batihuzunika muno ya yote kwa mana ya chelo bambonekeya kwaa kuminyo pake kae. Boka po batimsindikiza Mumerikebu. ");
INSERT INTO ndg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Muda tubile twatilekana nabo, na twatisafiri mubahari, tuiikite moja kwa moja pa'mji wa Kosi, na malabo yake tuikite mji wa Rodo, na boka kolyo tuikite mji wa Ptara. ");
INSERT INTO ndg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Tupatike meli yayoka kuyenda Foinike, twatisafiri na meli yoo. ");
INSERT INTO ndg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Patuikite nnongi ya kisiwa cha Kipro, tuilekite upande wa mashoto, tuikite mpaka Siria, twaitosa nanga katika mji wa Tiro, kwa mana kolyo nga meli yatipakulilwa lishehena lyake. ");
INSERT INTO ndg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Baada ya kuabona banafunzi, twatama masoba saba. Banafunzi aba bammakiya Paulo pitya kwa Roho panga ywembe kana ayende Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Hata patuitimize masoba ago, twenga twatiboka kuyenda zetu. Bote pamope, na alwawa babe na bana babe, batitusindikiza katika ndela yitu mpaka patuboi panja ya mji. Boka po twatipiga magoti pwani, na kuloba, twatiagana kila yumo. ");
INSERT INTO ndg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Twapanda mu'meli, na bembe batikerebuka kae munyumba yabe. ");
INSERT INTO ndg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Patuyomwile safari yitu boka Tiro, tuikite Tolemai. Palo tuasimamii alongo, na tama nabo kwa lisoba limo. ");
INSERT INTO ndg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","9","Malabo yake tubokite kuyenda Kaisaria. Twenga tujingii munyumba ya Filipo, muhubiri wa injili, ywabile yumo wa balo saba, ni twenga tutami pamope naye. Mundu yolo abile na alombo ncheche makikra ambao baritabiri. ");
INSERT INTO ndg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Baada ya tama kwa masoba kadhaa, atiuluka boka Uyahudi nabii yumo ywa kemelwa Agabo. ");
INSERT INTO ndg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ywembe atiisa kwitu na atiutola mkanda wa Paulo. kwa huo atiyataba magolo na maboko gake mwene nobaya, “Roho Mtakatifu abaya nyoo,” “Bayahudi ba Yerusalemu balowa kuntaba mundu ywamilikiya mkando wolo, nibembe balowa kunkabidhi mumaboko ga bandu ba mataifa.” ");
INSERT INTO ndg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patuyowine makowe aga, twenga na bandu babile atama mahali palo twatimsihi Paulo kana ayende Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nga Paulo kayangwa, “Mupanga kele, mwalela na kunivunja mwoyo wango? Kwa mana nibile tayari, kufungwa kwaa kae, lakini pia bulagwa kolyo Yerusalemu kwa ajili ya lina lya Ngwana Yesu.” ");
INSERT INTO ndg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kwa mana Paulo apala kwaa kushawishiwa, tulekite no baya, “Bai mapenzi ya Ngwana yapangike.” ");
INSERT INTO ndg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Baada ya masoba aga, tutolile mifuko yitu na kupanda kuyenda Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Baadhi ya banafunzi boka Kaisaria pia batikengamana na twenga. Batinneta mundu yumo ywakemelwa Mnasoni, mundu wa Kipro, mwanafunzi wa zamani, ambaye tutami naye. ");
INSERT INTO ndg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patuikite Yerusalemu, alongo balitukaribisha kwa puraha. ");
INSERT INTO ndg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Malabo yake Paulo atiyenda pamope na twenga kwa Yakobo, na apindo bote babile poo. ");
INSERT INTO ndg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Baada ya kuwasalimu, alibapeya taarifa yimo baada ya yenge ya makowe ambayo Nnongo apangite nkati ya mataifa kwopitya huduma yake. ");
INSERT INTO ndg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Muda bayowine ago, batimsifu Nnongo, na kummakiya, “Ubweni, alongo, kubile na maelfu ilenga baaminiya nkati ya Ayahudi. Bembe bote babile na nia ya kuikamwa saliya. ");
INSERT INTO ndg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Babakilwe kuhusu wenga, panga wafundisha Ayahudi batama kati ya mataifa kunleka Musa, na panga uwabakiye kana baatahiri bana babe, na kana baipange desturi ya zamani. ");
INSERT INTO ndg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tupalikwa panga namani? Bila shaka balowa yowa kuwa weka uisile. ");
INSERT INTO ndg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nga nyo upange chelo ambacho twenga twakubakiya nambeambe: tubile na bandu ncheche ambao batiweka nadhiri. ");
INSERT INTO ndg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Watole bandu aba na ujitakase mwene pamope nabembe, na uwalipiye gharama yabo, ili waweze kunyoa ntwe wabe. Nga nyoo kila yumo apate kuyowa panga makowe gaamakiwe kuhusu wenga ni ubocho. Balowa kujifunza panga wenga kae uikengama saliya. ");
INSERT INTO ndg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Lakini kwa habari ya mataifa ambao babile baumini, twaandikiye na kutoa maagizo panga bapalikwa kujiepusha na ilebe vyatitolewa dhabihu kwa sanamu, na myai, bokana na chelo chakinyongwa, na bajiepushe na umalaya.” ");
INSERT INTO ndg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nga nyo, Paulo atibatola analome na lisoba lya nyaibele, atijitakasa mwene pamope nabembe, na kujingya mu'hekalu, kutangaza kipindi cha masoba ya kujitakasa, mpaka sadaka yatolewa kwa ajili ya kila yumo wao. ");
INSERT INTO ndg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Masoba ago saba payakaribie yomoka, baadhi ya Bayahudi boka Asia bamweni Paulo mu'lihekalu, na makutano batikasirika, na kunnyoshea maboko. ");
INSERT INTO ndg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Babile bakikombwa ndoti, “Bandu ba Israeli, mutusaidie. Ayoo nga yolo mundu ywafundisha bandu kila mahali makowe ambayo ni kunchogo na bandu, saliya, na mahali pano. Pia atibaleta Ayunani katika lihekalu na kupanajisi mahali pano patakatifu.” ");
INSERT INTO ndg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kwa mana mwanzo babile bamweni Trofimo Muefeso abile pamope niywembe mjini, na bembe patangite panga Paulo annetike mulihekalu. ");
INSERT INTO ndg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mji wote ubile na taharuki, na bandu babutuka pamope ni kunkamwa Paulo. Patintoa panja ya lihekalu, na nnango mara itabilwe. ");
INSERT INTO ndg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pababile bakijaribu kummulaga, habari iikite kwa nkolo wa jeshi lya alinzi kuwa Yerusalemu yote ibile itwelilwe ghasia. ");
INSERT INTO ndg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mara iyo atibatola askari na jemedari atikibutukia kipenga sa bandu. Muda bandu bamweni nkolo ba jeshi na askari atimkaribia na kunkamwa Paulo. ");
INSERT INTO ndg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Boka po nkolo wa jeshi atiamuru atabwe minyororo ibele. Kannaluya wenga wa nyai na upangite kele. ");
INSERT INTO ndg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Baadhi ya bandu katika kipenga babile batipayuka kilebe cheno benge chelo. Kwa mana jemedari aweza kwaa kuwamakiya chochote kwa sababu ya yelo ndoti, atiamuri Paulo aletwe mkati ya ngome. ");
INSERT INTO ndg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bai paakite mu'ngazi, atitolewa na askari kwa sababu za kipenga sa bandu. ");
INSERT INTO ndg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Maana kipenga sa bandu batikengamana na yendelea kukombwa ndoti, “muntole yolo!” ");
INSERT INTO ndg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paulo paabile atiletwa nkati ya ngome, atimmakiya nkolo wa jeshi, “Naweza kukumakiya kilebe?” Yolo nkolo wa jeshi kabaya, “Je walongela kiyunani? ");
INSERT INTO ndg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Je wenga wa Mmisri ambaye awali utiongoza uasi na kubatola magaidi elfu ncheche mmwitu?” ");
INSERT INTO ndg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo kabaya, “Nenga na Myahudi, boka mji wa Tarso ya Kilikia. Nenga ni raia wa mji maarufu. Naaloba, mniruhusu nilongele na bandu.” ");
INSERT INTO ndg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Muda jemedari ampeya ruhusa, Paulo ayemi pa'ngazi na kutoa ishara kwa bandu kwa luboko lwake. Muda woo pabile na ukimya muno, akalongela nabo kwa Kiebrania. kabaya. ");
INSERT INTO ndg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Alongo na tate bango, muupekanie utetezi wango wanalowa kuupanga kwinu nambea, mbe.” ");
INSERT INTO ndg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kipenga sa bandu pakiyowine Paulo akilongela nabo kiebrania, batinyamaza. Kabaya. ");
INSERT INTO ndg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nenga na myahudi, nibelekwile mji wa Tarso eneo lya Kilikia, ila niipatike elimu katika mji wolo, mu'magolo ga Gamalieli. Natifundishwa lingana na ndela sahihi ya saliya ya tate bitu. Nenga nibile na bidii ya Nnongo, kati mwenga mwabote mwamubile leno. ");
INSERT INTO ndg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Natibatesa kwa ndela yee mpaka kubulagwa, natibakamwa analome na alwawa na kubatupa mu'ligereza. ");
INSERT INTO ndg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hata kuhani nkolo na apindo bote baweza kutoa ushahidi panga natipokya barua boka kwabe kwa ajili ya alongo babile Dameski, kwango nenga kusafiri kuyenda kolyo. Ibile nialete bandu Yerusalemu kwa ndela yee ili batabilwe no adhibiwa. ");
INSERT INTO ndg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Itokea panga panibile nikisafiri no karibia Dameski, majira ya mutwekati ghafla bweya nkolo uisile boka kumaunde natumbwa kuniangaza. ");
INSERT INTO ndg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Natitomboka pae na kupekaniya lilobe lyabaya,'Sauli, Sauli kwa mwanja namani waniudhi?' ");
INSERT INTO ndg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nkayangwa,'wenga wa nyai, Ngwana?' Kanibakiya,'Nenga na Yesu Mnazareti, ambaye wenga waniudhi.' ");
INSERT INTO ndg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Balo babile na nenga baibweni bweya, ila bayowine kwa lilobe lya yolo ywalongela na nenga. ");
INSERT INTO ndg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nikabaya,'Nipange namani, Ngwana?' Ngwana kanibakiya,'Yema na ujingye Dameski; kolyo walowa bakiwa kila kilebe chaupalikwa kukipanga.' ");
INSERT INTO ndg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Naweza kwaa kubona kwa mana ya mwangaza wa bweya wolo, bga nibokite Dameski kwa kuongozwa na maboko ga balo babile na nenga. ");
INSERT INTO ndg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kolyo natikwembana na mundu ywakemelwa Anania, ywabile mundu ywaikamwa saliya na mwene kuheshimika nnongi ya Bayahudi bote batami kolyo. ");
INSERT INTO ndg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kaisa kwango, na ayemi nnongi yango, no baya,'nongo wango Sauli, upate kuona.'Kwa muda wowolo natibona. ");
INSERT INTO ndg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Akabaya,'Nnongo wa tate yitu atikuchawa wenga upate kugatanga mapenzi gake, kumwona yolo ywabile na haki, na kuiyowa lilobe yaiboka mu'nkanwa wake. ");
INSERT INTO ndg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwa mana walowa pangika shahidi kwake kwa bandu bote nnani ya uyabonekeya na kugapekaniya. ");
INSERT INTO ndg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bai nambeambe kwa namani wasubiri? Amka, ubatizwe, ukaoshe dhambi yako, ukilikema lina lyake.' ");
INSERT INTO ndg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Baada ya kukerebuka Yerusalemu, na panibile nikisali nkati ya lihekalu, ikatokea panga nipeilwe maono. ");
INSERT INTO ndg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Namweni kanibakiya,'Hima na utoke Yerusalemu haraka, kwa sababu balowa kuuyeketya kwaa ushuhuda wako kuhusu nenga.' ");
INSERT INTO ndg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nikabaya,'Ngwana, bembe bene batangite kuwa natibafunga muligereza na kuwakombwa balo baaminiya katika lisinagogi. ");
INSERT INTO ndg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na myai ya Stephano shahidi wako yatimwagwa, Nenga pia nibile nayemile papipi na kuyeketya na nibile nalinda ngobo ya balo babile bakimulaga.' ");
INSERT INTO ndg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Lakini atinibakiya, “Uyende kwa sababu nenga nalowa kukutuma uyende mbale kwa bandu ba mataifa.”' ");
INSERT INTO ndg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bandu batinruhusu alongele nnani ya neno lee. Lakini badae patilipaza lilobe no baya, mwondoe mundu yolo katika nnema”kwa sababu ni sahihi kwaa atame.” ");
INSERT INTO ndg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Pababile bakipaza lilobe, na kutupa ngobo yabe na kutupa mavumbi nnani, ");
INSERT INTO ndg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","jemedari nkolo atiamuru Paulo aletwe mu'ngome. Atiamuru analuywe huku akikombwa mijeredi, ili ywembe mwene atange kwa namani babile babile bakikombwa ndoti ya naman yelo. ");
INSERT INTO ndg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Hata pababile batimfunga kwa kamba, Paulo ammakiye yolo akida ywayemile papipi ni ywembe, “Je! ni haki kwinu kunkombwa ywabile Mrumi na bado ahukumilwa kwaa?” ");
INSERT INTO ndg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yolo akida paayowine maneno aga, kayenda kwa jemedari nkolo na kummakiya, abaya, “Upala kupanga namani? Kwa maana mundu yolo mrumi.” ");
INSERT INTO ndg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Jemedari nkolo kaisa na kummakiya, “Nibakiye, je wenga ni raia ba Rumi?” Paulo kabaya, “Eloo.” ");
INSERT INTO ndg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Jemedari kayangwa, “Kwo pitya kiasi kikoro cha pesa nga nilipata uraia.” Lakini Paulo kammakiya, “Nenga na mrumi wa kubelekwa.” ");
INSERT INTO ndg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bai balo babile tayari kuyenda kumuuliza kuboka na kumwacha wakati wowolo. Na jemedari niywembe atiyogopa, paayowine kuwa Paulo ni Mrumi, na kwa sababu amtabile ");
INSERT INTO ndg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lisoba lyanyaibele, jemedari nkolo apala kutanga ukweli kuhusu mashtaka ga Bayahudi dhidi ya Paulo. Nga nyoo atimfungua vifungo vyake ni kuamuru akolo ba makuhani na baraza lyote bakwembane. Kanneta Paulo pae, ni kumbeka katikati yabe. ");
INSERT INTO ndg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo kaalolekea moja kwa moja bandu ba libaraza no baya, “Mwaongo bango, natitama nnongi ya Nnongo kwa dhamira inoite hadi leno.” ");
INSERT INTO ndg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kuhani nkolo Anania atiamuru balo bayemi papipi ni ywembe bankombwe munkano wake. ");
INSERT INTO ndg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nga nyo Paulo kammakiya, “Nnongo alowa kukukombwa wenga, ukutwa watipakwa chokaa. Uyemi utinihukumu kwa saliya, ni ywembe waamuru nikombwe kunchogo na saliya?” ");
INSERT INTO ndg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Balo babile bayemi papipi ni ywembe babaya, “Nga nyoo wamtukangana kuhani nkolo wa Nnongo?” ");
INSERT INTO ndg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo kabaya”mwalongo bango, nenga, nitangite kwaa panga yolo ni kuhani nkolo. Kwamana iandikwile, walowa longela vibaya nnani ya mtawala wa bandu bako.” ");
INSERT INTO ndg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo paabweni panga upande umo wa libaraza ni Masadukayo na benge Mafarisayo, kapaza lilobe no baya, “alongo bango, nenga na Mfarisayo, mwana wa Mfarisayo. Ni kwa sababu yee nategemea kwa ujasiri ufufuo wa bandu ba kiwo natihukumilwa nabo.” ");
INSERT INTO ndg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Paabaya nyoo, malumbano makolo yapangite kati ya Mafarisayo na Masadukayo, na mkutano utibaganyika. ");
INSERT INTO ndg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mana Masadukayo ubaya ntopo ufufuo, na malaika wala ntopo roho, ila Mafarisayo ubaya aga gote gabile. ");
INSERT INTO ndg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ghasiua ngolo yatitokea na baadhi ya baandishi babile upande wa Mafarisayo bayemi na kujadili, babaya, “tubweni kwaa chochote kibaya dhidi ya mundu yolo. Namani mana roho au malaika alongela na ywembe?” ");
INSERT INTO ndg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Muda pabile na hoja ngolo, nkolo wa majeshi ayogope panga Paulo alowa papuliwa ipande ipande na bembe, nga nyo atiamuru anajeshi bauluke pae na kuntola kwa nguvu boka kwa ajumbe ba libaraza, na kunneta katika ngome. ");
INSERT INTO ndg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kilo yanyaibele Ngwana ayemi karibu ni ywembe no baya, “Kana uyogope, kwa kuwa wanishuhudia katika Yerusalemu, nga nyo walowa panga ushahidi katika Roma kae.” ");
INSERT INTO ndg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Paikite bwamba, baadhi ya Ayahudi bapangite liagano na kukema laana nnani yabembe bene: babaya panga balyaa kwaa wala nywaa chochote mpaka pabambulaga Paulo. ");
INSERT INTO ndg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Pabile na bandu zaidi ya arobaini ambao bapangite njama yee. ");
INSERT INTO ndg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bayenda kwa akolo ba makuhani na apindo no baya, “Tujibekite bene katika lana kolo, tukyee kwaa chochote mpaka tumulage Paulo. ");
INSERT INTO ndg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nga nyo nambeambe, libaraza lyatimmakiya jemedari nkolo annete kwinu, kati panga mwaiamua kesi yake kwa usahihi. Kwitu tubile kwaa tayari kumulaga kabla aisa pano.” ");
INSERT INTO ndg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lakini mwana wa dada bake na Paulo ayowine pabile na njama, atiyenda kajingya ndani ya ngome na kummakiya Paulo. ");
INSERT INTO ndg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paulo kankema akida yumo kabaya, “Mtole muinja yolo kwa jemedari, maana abile na neno lya kummakiya. ");
INSERT INTO ndg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Bai akida kantola yolo kijana ni kumpeleka kwa jemedari nkolo kammakiya, “Paulo yolo ywatabilwe anikemile kapala nikuletee kijana yoo kwako. Abile na neno lya kummakiya.” ");
INSERT INTO ndg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yolo jemedari nkolo kamkamwa kwa maboko kajitenga ni ywembe kando, na kunnaluya, “Ni kilebe gani ywapala kunibakiya?” ");
INSERT INTO ndg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yolo kijana kabaya, “Bayahudi bampatike kukuloba unnete Paulo malao katika libaraza kati panga wapala kupata habari yake kwa usahihi muno. ");
INSERT INTO ndg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bai wenga kana ukubali mana bandu zaidi ya arobaini bamvizia. Batijifunga kwa laana, balyee kwaa wala nywaa mpaka palo bambulaga. Hata nambeambe babile tayari, bakilinda kibari boka kwako.” ");
INSERT INTO ndg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Bai yolo jemedari nkolo annekite kijana ayende zake, baada ya kumwagiza “kana ubakiye mundu yeyote panga umeniarifu aga.” ");
INSERT INTO ndg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Abakema maakida abele kabaya batayarishe askari mia ibele kabaya na askari apanda farasi sabini, na babile na mikuki mia ibele, mwalowa boka zamu ya tatu ya kilo. ");
INSERT INTO ndg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kaabakiya kubeka banyama tayari ambaye Paulo alowa kuntuma na kuntola salama kwa Feliki Gavana. ");
INSERT INTO ndg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Atiandika batua kwa namna yee, ");
INSERT INTO ndg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudio Lisia kwa Liwali mtukufu Feliki, salamu. ");
INSERT INTO ndg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mundu yolo akamwile na bayahudi babile karibu kumulaga, nga po nayenda pamope na kikosi cha askari na kumwokoa, paniipatike habari ya kuwa ywembe ni raia wa kirumi. ");
INSERT INTO ndg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nipala kutanga kwa namani watimshitakia, nga nyo natimpeleka katika libaraza. ");
INSERT INTO ndg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nibweni panga abile ameshitakiwa kwa ajili ya maswali ga saliya yabe, wala ashitakiwa kwaa kwa neno lolote lyastahilia kubulagwa. ");
INSERT INTO ndg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Boka po itangike kwango panga pabile na njama dhidi yake, nga nyo kwa haraka natimtuma kwako, na kubaagiza wamshitakia balete mashitaka dhidi yake nnongi yako. Batiagana. ");
INSERT INTO ndg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bai balo askari bakatii amri: batimtola Paulo bakampeleka hata Antipatri kilo. ");
INSERT INTO ndg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lisoba lyanyaibele, maaskari banyansima baalekite baloa apanda farasi bayende pamope ni ywembe, na bembe batikerebuka zao katika ngome. ");
INSERT INTO ndg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Na bapanda farasi pabaikite Kaisaria, na kumpeya liwali yelo barua, wambekite Paulo nnongi yake. ");
INSERT INTO ndg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ni ywembe liwali paaisomile barua, kannaluya Paulo atiboka jimbo gani; paatangite panga ni mubdu wa Kilikia, ");
INSERT INTO ndg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kabaya, “Nalowa kukupekania wenga pabaisile balo bakushitakiya,” atiamuru abekwe katika ikulu ya Herode. ");
INSERT INTO ndg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Baada ya masoba matano. Anania kuhani nkolo, baadhi ya apindo na msemaji yumo ywakemelwa Tertulo, bayenda palo. Bandu aba banetike mashitaka dhidi ya Paulo kwa Gavana. ");
INSERT INTO ndg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulo paayemi nnongi ya Gavana, Tertulo atumbwile kunshitaki no baya kwa gavana, “Kwa sababu yako tubile na amani kolo; na kwa maono yako yatileta mageuzi yanoite katika litaifa lyetu; ");
INSERT INTO ndg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bai kwa shukrani yote twapokya kila kilebe chaakipangite, Wasalam mheshimiwa Feliki. ");
INSERT INTO ndg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lakini kana nikuchoshe muno, nakusihi ugapekanie maneno machunu kwa fadhili yako. ");
INSERT INTO ndg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kwa maana tumpatike mundu yolo nkorofi, na ywasababisha Ayahudi bote kuiasi dunia. Kae ni kiongozi wa madhehebu ya Wanazorayo. ");
INSERT INTO ndg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ukinnaluya Paulo kuhusu makowe aga, hata waweza kujifunza ni kilebe gani twamshitakia.” ");
INSERT INTO ndg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Bayahudi nabo batimshitaki Paulo, babaya panga makowe gabile kweli. ");
INSERT INTO ndg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Liwali paampungia luboko ili Paulo alongele, Paulo kayangwa, “Nitangite panga kwa miaka yanyansima ubile mwamuzi wa litaifa lee, na nibile na furaha kujieleza mwene kwako. ");
INSERT INTO ndg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Waweza kuhakikisha kuwa yayomwike kwaa masoba zaidi ya komi ni ibele boka panatipanda kuyenda kuabudu Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Na banikwembine katika lihekalu, nabisha kwaa na mundu yoyote, na nipangite kwaa fujo katika mkutano, wala katika masinagogi wala nkati ya mji; ");
INSERT INTO ndg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","na wala baweza kwaa kuhakikisha kwako mashitaka wanayoyashitaki dhidi yango. ");
INSERT INTO ndg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ila nakiri lelo kwako, ya panga kwa ndela yelo ambayo dhehebu, kwa ndela yeyelo natimtumikia Nnongo wa tate bitu. Nenga na mwaminifu kwa yote yabile katika saliya na maandiko ya manabii. ");
INSERT INTO ndg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nibile na ujasiri wowolo kwa Nnongo ambao hata abo nao batilenda, kuisa kwa ufufuo wa bandu ba kiwo, kwa bote bene haki na babile kwaa na haki kae; ");
INSERT INTO ndg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","na kwa lee, napanga kazi ili niwe na dhamira ibile kwaa na hatia nnongi ya Nngongo na nnongi ya bandu pitya makowe gote. ");
INSERT INTO ndg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Nambeambe baada ya miaka ganyansima niisile kuleta msaada kwa litaifa lyango na zawadi ya fedha. ");
INSERT INTO ndg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nipangite nyoo, Bayahudi fulani ba Asia banikwembine nkati ya sherehe ya utakaso ndani ya lihekalu, bila likundi lya bandu wala ghasia. ");
INSERT INTO ndg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bandu aba ambao ipalikwe kuwapo nnongi yako nambeambe na babaye chelo wakibona nnani yango kati babile na neno lolote. ");
INSERT INTO ndg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Au bandu aba bene babaye ni likosa gani balibweni kwango paniyemite nnongi ya libaraza lya kiyahudi; ");
INSERT INTO ndg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ila kwa ajili ya kilebe chimo nikibayite kwa lilobe paniyemi katikati yao,'ni kwa sababu ya ufufuo ba bandu ba mu'kiwo mwenga mwanihukumu.” ");
INSERT INTO ndg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliki abile atitaarifiwa vizuri kuhusu ndela, na atiuahirisha mkutano, Kabaya, “Lisia jemedari paaisa pae boka Yerusalemu nitatoa maamuzi dhidi ya mashitaka yinu.” ");
INSERT INTO ndg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nga nyo atiamuru akida amlinde Paulo, ila abe na nafasi na hata abile kwaa mundu bakiwakanikiya marafiki bake bamsaidie wala bamtembelee kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Baada ya masoba kadhaa, Feliki atikerebukia na Drusila nyumbowe ywabile Myahudi, atimtuma kumwita Paulo na akibapekania boka kwake habari za imani nkati ya Kristo Yesu. ");
INSERT INTO ndg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ila Paulo paabile akijadiliana naywembe kuhusu haki, kuwa na kiasi na hukumu yaisile, Feliki akapata hofu kayangwa, “uyende kutalu kwa nambeambe, ila nikipata muda kae, nalowa kukukema.” ");
INSERT INTO ndg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Muda wowolo, atitegemea panga Paulo ampeya mbanje kwa eyo amkemile mara zanyansima akilongela naywembe. ");
INSERT INTO ndg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ila miaka ibele yapeta, Porkion Festo abile Liwai baada ya Feliki, ila Feliki atipala kujipendekeza kwa Bayahudi, nga nyo atinleka Paulo pae ya uangalizi. ");
INSERT INTO ndg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nga Festo ajingii mu'jimbo lee na baada ya masoba matatu kayenda boka Kaisaria mpaka Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kuhani nkolo na Bayahudi mashuhuri bannetike mashitaka dhidi ya Paulo kwa Festo, na batilongela kwa nguvu kwa Festo. ");
INSERT INTO ndg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Na bannobia Festo fadhili nnani ya habari za Paulo apate kunkema Yerusalemu ili bapate kumulaga mundela. ");
INSERT INTO ndg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lakini Festo kaayangwa panga abile mfungwa katika Kaisaria, na panga ywembe mwene alowa kerebuka kolyo haraka. ");
INSERT INTO ndg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Abaya “Kwa eyo, balo ambao baweza, waweza kuyenda kolyo ni twenga. Mana kibile kilebe kibaya kwa mundu yolo, mpalikwa kunshitakia.” ");
INSERT INTO ndg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Baada ya tama masoba nane au komi zaidi, atikerebuka Kaiaria. Na lisoba lyanyaibele atami katika iteo cha hukumu na kuamuru Paulo aletwe kwake. ");
INSERT INTO ndg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paaikite, Ayahudi boka Yerusalemu bayemi papipi, batoa mashitaka ganyansima mazito ambayo baweza kwaa kugathibitisha. ");
INSERT INTO ndg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo atijitetea no baya,'ni nnani kwaa ya lina lya Ayahudi, nnani kwaa ya lihekalu, na nnani kwaa ya Kaisari, nipangite mabaya.' ");
INSERT INTO ndg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Lakini Petro apala kujipendekeza kwa Ayahudi, na nyoo kayangwa Paulo kwa baya,'Je, upala kuyenda Yerusalemu na hukumilwa na nenga kuhusu makowe aga huko?' ");
INSERT INTO ndg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo kabaya,'Nayema nnongi ya iteo cha hukumu cha Kaisari ambapo nipalikwa hukumilwa. Nawakosea kwaa Ayahudi, kati wenga utangite vema. ");
INSERT INTO ndg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Mana itei nimekosa na mana nipangite chastahilia kiwo, nikanikiya kwaa kubulagwa. Lakini mana mashitaka gabe ni kilebe kwaa, ntopo mundu ywaweza kunikabidhi kwao. Nannoba Kaisari.' ");
INSERT INTO ndg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Baada Festo kulongela na libaraza kayangwa, “unnoba Kaisari, walowa yenda kwa Kaisari.” ");
INSERT INTO ndg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Baada ya masoba kadhaa, mpwalume Agripa na Barnike baikite Kaisara kupanga ziara rasmi kwa Festo. ");
INSERT INTO ndg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Baada ya tama hapo kwa masoba ganyansima, Festo atiwasilisha kesi ya Paulo kwa Mpwalume, Kabaya,'Mundu yumo alekitwe pano na Feliki kati mfungwa. ");
INSERT INTO ndg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Panibile Yerusalemu makuhani akolo na apindo ba Ayahudi bannetike mashitaka nnani ya mundu yolo kwango, na bembe banaluya nnani ya hukumu yake. ");
INSERT INTO ndg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kwa lee nenga naayangite panga ni desturi kwaa ya Aroma kumtoa mundu kwa upendeleo badala yake, mtuhumiwa apalikwa kuwa na nafasi ya kugakabili bashitaki bake na kujitetea nnani ya tuhuma zake. ");
INSERT INTO ndg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kwa eyo pabaisile pamope pano. niweza kwaa subiri, lakini lisoba lyake lyanyaibele natama pa iteo cha hukumu na kuamuru mundu yolo aletwe ndabi. ");
INSERT INTO ndg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Muda bashitaki bake bayemi na kunshitaki, nilifikiri panga ntopo mashitaka makolo gabile nnani yake. ");
INSERT INTO ndg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Badala yake, babile na mabishano fulani pamope ni ywembe kuhusu dini yao na kuhusu Yesu ambaye ywaawile, lakini Paulo abaya kuwa abile nkoto. ");
INSERT INTO ndg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nibile nitangite kwaa namna ya kuchunguza likowe lee, na ninnaluye mana alowa yenda Yerusalemu kuhukumilwa nnani ya makowe aga. ");
INSERT INTO ndg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lakini Paulo paakemelwa abekwe pae ya ulinzi kwa ajili ya uamuzi wa Mpwalume, niliamuru abekwe hata panimpelekeye kwa Kaisari.' ");
INSERT INTO ndg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa atilongela na Festo, “nipala yenda nanenga kumpekania mundu yolo.” Festo kabaya, “walowa mpekania malabo.” ");
INSERT INTO ndg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Malao yake, Aripa na Bernike baikite na sherehe yanyansima; baikite katika ukumbi na maafisa ba majeshi, na bandu mashuhuri ba mji. Na Festo alipotoa amri, bannete Paulo kwao, Paulo aisile kwao. ");
INSERT INTO ndg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo kabaya, “Mpwalume Agripa, na bandu bote ambao mubile pano pamope natwee, mwalolekeya mundu yolo; jumuiya yote ya Ayahudi kolyo Yerusalemu na pano bapala nibashauri, na bembe bakombwa ndoti kwango panga kana atame. ");
INSERT INTO ndg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nibweni panga apangite kwaa lolote lyastahili bulagwa; lakini kwa sababu ");
INSERT INTO ndg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","akemelwa na Mpwalume, niliamua kumpeleka kwake. Lakini nibile ntopo kilebe cha kuandika kwa Mpwalume. Kwa sababu yee, ninnetike kwako, hasa kwako wenga, Mpwalume Agripa, ili nipate kuwa na kilebe sa kuandika kuhusu kesi. ");
INSERT INTO ndg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwa mana nibweni ibile kwaa na maana kumpeleka mfungwa na bila kugabona mashitaka yanayomkabili. ");
INSERT INTO ndg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Nga nyo, Agripa kammakiya Paulo,'Unaruhusiwa kujitetea.'Nga nyo Paulo kanyosha luboko lwake akajitetea nyoo. ");
INSERT INTO ndg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Najibonekeya mwenye furaha, Mpwalume Agripa, ili kupanga kesi yango nnongi yako leno dhidi ya mashitaka yoti ya Ayahudi. ");
INSERT INTO ndg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Hasa, kwa mana wenga ni mtaalamu wa desturi za Ayahudi na maswali. Nga nyo naloba unipekaniye kwa uvumilivu. ");
INSERT INTO ndg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kweli, Ayahudi bote batangite namna natama tangu uinja wango katika litaifa lyango kolyo Yerusalemu. ");
INSERT INTO ndg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Banitangite tangu mwanzo na bapalikwa kuyeketya panga natama kati Mfarisayo, dhehebu lyalibile msimamo mkale katika dini yetu. ");
INSERT INTO ndg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nambeambe niyemi pano nihukumiwe kwa sababu nenga natiilinga ahadi ambayo Nnongo apangite na tate bitu. ");
INSERT INTO ndg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ayee nga ahadi ambayo makabila yitu komi na ibele yatumaini pokya kati bamwabudu Nnongo kwa bidii kilo na mutwekati. Ni kwa ajili ya litumaini lee, mpwalume Agripa, panga Ayahudi banishitaki. ");
INSERT INTO ndg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kwa mwanja namani yeyote kati yinu anafikiri ni ajabu panga Nnongo hufufua bandu ba kiwo? ");
INSERT INTO ndg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Muda umo niikite mwene panga nipangite makowe ganansima dhidi ya lina lya Yesu wa Nazareti. ");
INSERT INTO ndg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nipangite aga katika Yerusalemu; Naatabike baamini banyansima muligereza, na nibile na mamlaka boka kwa akolo ba makuhani kupanga nyoo; na muda wa babulagwa, nipigire kura nnani yao. ");
INSERT INTO ndg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mara yanansima natiwaadhibu katika masinagogi yote na nilijaribu kuwapanga baikane imani yao. Nibile na hasira muno nnani yao na natiabutukiya hata katika miji ya ugenini. ");
INSERT INTO ndg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Muda panibile napanga aga, niyenda Dameski, nibile na mamlaka na maagizo boka kwa makuhani akolo, ");
INSERT INTO ndg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","nibile mundela muda wa mutwekati, Mpwalume, nibweni mwanga boka kumaunde ubile mkale kuliko liumu na lyating'ara kutuzunguka nenga na bandu batisafiri pamope na nenga. ");
INSERT INTO ndg_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twenga twabote twatitomboka pae, niyowine lilobe lyatibaya na nenga ikabaya katika lugha ya kiebrania,'Sauli, Sauli kwa mwanja namani wanitesa? Ni vigumu kwako kuukombwa teke mchokoo. ");
INSERT INTO ndg_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nga nikabaya,'Wenga wa nyai, Ngwana?' Ngwana kayangwa,'Nenga na Yesu ambaye wanitesa. ");
INSERT INTO ndg_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nambeambe inuka uyemi kwa magolo gako; sababu kwa likusudi lee nenga natibonekana kwako, natikuchawa kuwa mtumishi na shahidi nnani ya makowe ambayo utangite kuhusu nenga nambeambe na makowe nalowa kukubonekeya baadae; ");
INSERT INTO ndg_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","na Nalowa kukulopwa boka kwa bandu ba bandu ba mataifa ambapo nakutuma, ");
INSERT INTO ndg_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kufungua minyo yabe na kubatoa mulibendo kuyenda mu'bweya na boka mu'nguvu ya nchela nakunkerebukiya Nnongo, ili bapate pokya boka kwa Nnongo msamaha ba sambi na urithi ambao niwepeya balo banibatengile kwa imani yaibile kwango. ");
INSERT INTO ndg_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Nga nyo mpwalume Agripa, naweza kwaa kuasi maono ga kumaunde, ");
INSERT INTO ndg_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","lakini, kwa balo babile katika Dameski kwanza, na boka po Yerusalemu na nchi yote ya Yudea, na pia kwa bandu ba mataifa yenge, natihubiri panga batubu na kunkerebukia Nnongo, bapange matendo yastahiliya toba. ");
INSERT INTO ndg_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa mana eyo Ayahudi bakamwile mulihekalu, bakajaribu kunibulaga. ");
INSERT INTO ndg_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nnongo amenisaidia mpaka nambeambe, nga nyo nayema na kushuhudia kwa bandu ba kawaida na kwa balo akolo nnani ya yalo ambayo manabii na Musa bagabaya yalowa pangika na vingine kwaa; ");
INSERT INTO ndg_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Panga Kristo lazima alowa teseka na alowa wa kwanza kufufuka boka mu'kiwo na kutangaza bweya kwa Ayahudi na bandu bamataifa. ");
INSERT INTO ndg_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo paayomwile kujitetea, Festo abaya kwa lilobe likolo,'Paulo wenga wa mwenda wazimu! masomo gako gakupangite uwe mwendawazimu. ");
INSERT INTO ndg_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Lakini Paulo kabaya, Nenga na mwendawazimu kwaa, mheshimiwa Festo; lakini kwa ujasiri nabaya maneno ga ukweli mtupu. ");
INSERT INTO ndg_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kwa mana mpwalume atangite kuhusu makowe aga; nga nyo, nilongela kwa uhuru kwake, kwa mana nibile na uhakika panga ntopo lolote lyalifichika kwake; kwa mana lee lipangikwa kwaa pembeni. ");
INSERT INTO ndg_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Je, ubaaminiya manabii, mpwalume Agripa? Nitangite panga uaminiya.' ");
INSERT INTO ndg_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa kammakiya Paulo,'kwa muda mwipi waweza kunishawishi nenga na kunipanga Mkristo? ");
INSERT INTO ndg_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo kabaya, “Nannoba Nnongo panga, kwa muda mwipi au mrefu, wenga kwaa, ila pia bote mwamuniyowine leno, mupangike kati nenga, lakini bila yelo minyororo ya muligereza.” ");
INSERT INTO ndg_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nga nyo mpwalume ayemi, na liwali, na Bernike kae, na balo babile batama pamope nao. ");
INSERT INTO ndg_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Batiboka ukumbini, walilongela bembe kwa bembe no baya,'Mundu yolo astahili kwaa kiwo wala kifungo'. ");
INSERT INTO ndg_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa kammakiya Festo, “mundu yolo aweza kubekwa huru mana aikanikiya rufani kwa Kaisari.” ");
INSERT INTO ndg_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Paiamuliwe panga tupalikwa tunasafiri kwa mase kuyenda Italia, watimkabidhi Paulo na afungwa benge kwa afisa yumo wa jeshi lya Kiroma ywakemelwa Julio, wa Kikosi cha Agustani. ");
INSERT INTO ndg_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tukapanda meli boka Adrmitamu, ambayo ibile itisafiri kandokando ya pwani ya Asia. Nga nyo tujingii mubahari. Aristaka boka Thesalonike ya Makedonia kayenda pamope natwee. ");
INSERT INTO ndg_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lisoba lya nyaibele tuikite katika mji wa Sidoni, ambapo Julio atimpangia kwa ukarimu na atibaruhusu kuyenda kwa rafiki zake kupokya ukarimu wabe. ");
INSERT INTO ndg_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Boka po twayenda mu'bahari tukasafiri kuzunguka kisiwa cha Kipto ambacho kibile kimeukinga mbepo, kwa mana mbepo ubile ukitukabili. ");
INSERT INTO ndg_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Baada ya kuwa tumesafiri katika mase yabile papipi na Kilikia na Pamfilia, twaisa Mira, mji wa Lisia. ");
INSERT INTO ndg_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Palo yolo afisa wa jeshi lya Kiroma, akaikuta meli boka Alexandria ambayo ibile itisafiri kuelekea Italia. Akatupandisha ndani yake. ");
INSERT INTO ndg_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Baada ya kusafiri mbolembole kwa masoba ganyansima na hatimaye tuikite kwa taabu karibu na Kinidas, mbepo waruhusu kwaa kae kuelekea ndela yoo, nga nyoo tukasafiri kandokando ya kivuli cha Krete tukiukenga mbepo, mkabala na Salmone. ");
INSERT INTO ndg_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twatisafiri kandokando ya pwani kwa ugumu, mpaka tuikite mahali pakemelwa Fari Haveni ambayo ibile papipi na mji wa Lasi. ");
INSERT INTO ndg_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tutweti muda mwingi muno, na muda wa mfungo wa Ayahudi ubile umepita pia, nambeambe ibile ni hatari kuyendelea kusafiri. Nga nyo Paulo atitukanikiya, ");
INSERT INTO ndg_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","no baya, “Alalome nibweni safari ambayo twapala kuitola ywalowa kuwa na madhara na hasara yanyansima, ni kwamizigo kichake kwaa na meli, lakini pia maisha yitu.” ");
INSERT INTO ndg_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lakini afisa yumo wa jeshi la Kiroma atimpekaniya muno ngwana wake na mmiliki wa meli, kuliko makowe ambayo galongelwa na Paulo. ");
INSERT INTO ndg_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kwa sababu bandari ibile kwaa sehemu rahisi tama kipindi sa mbepo, mabaharia banyansima batisauri tusafiri boka palo, ili kwa namna yoyote tukiweza kuika mji wa Foinike, tutame palo kipindi sa mbepo, Foinike ni bandari kolyo Krete, na itilinga kaskazini na kusini mashariki. ");
INSERT INTO ndg_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mbepo ya kusini pautumbwile kuvuma mbolembole, mabaharia bapatike chelo ambacho babile bakihitaji. Bating'oa nanga na kusafiri kandokando ya Krete papipi na pwani. ");
INSERT INTO ndg_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lakini baada ya muda mwipi mbepo nkali, waukemelwa wa kaskazini mashariki, utumbwile kutukombwa boka ng'ambo ya kisiwa. ");
INSERT INTO ndg_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Muda meli yatilemewa na kushindwa kuikabili mbepo, twatikubaliana na hali yee, tukasafiri nao. ");
INSERT INTO ndg_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tukabutuka pitya wolo upande ubile utiukenga mbepo wa kisiwa kikemelwa Kauda; na kwa taabu muno twatifanikiwa kuuokoa mtumbwi. ");
INSERT INTO ndg_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Baada ya kuwa tumeivuta, balitumia kamba kuifunga meli. Batiyogopa panga tungeweza kuyenda katika eneo lya mchanga wanyansima wa Syiti, nga nyo batiulua nanga na batiendeshwa kandokando. ");
INSERT INTO ndg_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Tukombwile kwa nguvu muno na dhoruba, nga nyo lisoba lyanyaibele mabaharia batumbwile kutupa miziogo boka mu'meli. ");
INSERT INTO ndg_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Lisoba lya tatu, mabaharia batumbwile kuyatoa mase kwa maboko gabe bene. ");
INSERT INTO ndg_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Muda ambao liumu na ndondwa yatuangazia kwaa masoba ganyansima, bado dhoruba ngolo itukombwile, na matumaini panga twalowa lopolelwa yatiboka. ");
INSERT INTO ndg_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Baada ya kuwa batiyenda muda mrefu bila chakulya, nga Paulo ayemi katikati ya mabaharia kabaya, “Alalome, mpalikwa kunipekaniya, na kana tuiboite nanga boka Krete, ili kupata madhara aga na hasara. ");
INSERT INTO ndg_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nambeambe naafariji panga mube na mwoyo, kwa sababu pabile kwaa na upotevu wa maisha kati yinu, ila hasara ya meli. ");
INSERT INTO ndg_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kwa mana kilo chakipitike malaika wa Nnongo, ambaye yolo Nnongo nenga ni wake, na ambaye namwabudia kae-malaika bake ayemi pembeni yango ");
INSERT INTO ndg_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","no baya, “Kana uyogope Paulo. Lazima uyemi nnongi ya Kaisari, linga, Nnongo katika wema wake akupeile aba bote ambao wasafiri pamope nawenga. ");
INSERT INTO ndg_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nga nyo, alalome, mujipe mwoyo, kwa sababu namwaminiya Nnongo, panga ipalika kati yaanibakiye. ");
INSERT INTO ndg_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lakini lazima tuumie kwa kukombwa katika baadhi ya visiwa.” ");
INSERT INTO ndg_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Pauikite kilo ya komi na ncheche, patubile tukiyendeshwa kolyo na kolyo mu'bahari ya Adratik, kati kilo ya manane nyoo, mabaharia batifikiri panga batikaribia nchi kavu. ");
INSERT INTO ndg_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Balitumia milio kupima kina cha mase na kupata mita thelathini na sita, baada ya muda mwipi bapema bapatike mita ishirini na saba. ");
INSERT INTO ndg_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Batiyogopa kwanza twaweza kugonga miamba, nha nyo bakaulua nanga ncheche boka katika sehemu ya kuwekea nanga no kuloba panga bwamba uise mapema. ");
INSERT INTO ndg_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Balo mabaharia batiipala namna ya kuitelekeza yelo meli na balizishusha majini boti njunu na kulopwa maisha, na bapangite kuwa wanatupa nanga boka sehemu ya nnongi ya boti. ");
INSERT INTO ndg_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lakini Paulo kambakiya yolo askari wa jeshi la Kiroma na balo askari, “Muweza kwaa kuilopwa ila aba bandu babakia mu'meli.” ");
INSERT INTO ndg_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Boka po balo askari bakatike kamba na yelo boti ilekitwe itolwe na mase. ");
INSERT INTO ndg_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Muda mwanga wa bwamba paubile utijitokeza, Paulo atibasihi bote angalau balyee kisunu. Kabaya, “Ayee nga lisoba lya komi na ncheche mwalenda bila kulyaa, mwalyaa kwaa kilebe. ");
INSERT INTO ndg_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nga nyo nawasihi mtole chakulya kisunu, kwa sababu yee ni kwaajili ya tama kwinu; na ntopo hata nywili yimo ya ntwe winu yalowa potea. ");
INSERT INTO ndg_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Paayomwile baya nyoo, atitola mkate na kumshukuru Nnongo nnongi ya minyo ga kila mundu. Boka po kaetekwana mkate no tumbwa lyaa. ");
INSERT INTO ndg_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Boka po bote batiwa mwoyo na bembe batola chakulya. ");
INSERT INTO ndg_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tubile bandu 276 nkati ya meli. ");
INSERT INTO ndg_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Paayomwile lyaa pakayukwita, baipangite meli nyepesi kwa kutupa ngano nkati ya mase. ");
INSERT INTO ndg_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Paibile mutwekati, paibweni kwaa nchi kavu, lakini babweni sehemu ya nchi kavu yaijingya mumase yaibile na mchanga wanyansima. batilongela kati baweza kuiendesha meli kuelekea palo. ");
INSERT INTO ndg_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nga nyoo batizilegeza nanga bazilekite mumase. Katika muda wowolo batizilegeza kamba za tanga na kuiinua sehemu ya nnongi kuelekea katika mbepo, nga nyo batielekea katika iyo sehemu yabile na mchanga wanyansima. ");
INSERT INTO ndg_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lakini baisile mahali ambapo mikondo ibele ya mase itikwembana, na meli ikaelekya mchangani. Na yelo sehemu ya nnongi ikakwama palo na iweza kwaa boka, lakini sehemu ya mbele uya meli itumbwile kutekwanika kwa sababu ya ukale wa mawimbi. ");
INSERT INTO ndg_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mpango wa balo askari ubile ni kuwabulaga wafungwa, ili panga ntopo ywaweza ogelea na kutoroka. ");
INSERT INTO ndg_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lakini yolo askari wa jeshi la Kiroma apala kumwokoa Paulo, nga nyo akausimamisha mpango wabe; na akaamuru balo ambao baweza kuogelea baruke boka melini kwanza bayende nchi kavu. ");
INSERT INTO ndg_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Boka po alalome benge balowa kunkengama, benge nnani ya ipande ya mbao na benge nnani ya ilebe yenge boka mu'meli. Kwa ndela yee ipangike panga bote twalowa ika salama nchi kavu. ");
INSERT INTO ndg_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Patuikite salama, tutangite panga kisiwa kikemelwa Malta. ");
INSERT INTO ndg_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bandu batama poo ni balo patupeya ukarimu wa kawaida wa kwaa, ila baliwasha mwoto na kutukaribisha twabote, kwa sababu ya ula na mbepo yaibile itiendelea. ");
INSERT INTO ndg_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Lakini Paulo paabile atikusanya mzigo wa anju na kuubeka pamwoto, nng'ambo nchunu ywabile na sumu aboka mu'yelo anju kwa sababu ya lelo lijoto, na akajizungusha mu'maboko gake. ");
INSERT INTO ndg_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bandu wenyeji wa palo pabamweni yolo mnyama atining'ia boka mu'maboko gake, babaya bene kwa bene, “Mundu yolo hakika ni muuaji ambaye aboka mulibahari, lakini haki haimuruhusu tama.” ");
INSERT INTO ndg_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lakini ywembe atintupia yolo mnyama katika mwoto na apata kwaa madhara yoyote. ");
INSERT INTO ndg_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bembe batimgojea avimbe kwa homa au atomboke gafla na kubulagika. Lakini baada ya kunlolekeya kwa muda mrefu na kubona panga ntopo likowe ambalo ni lakwaida kwaa kwake, balibadilisha malango yabe no baya abile nongo. ");
INSERT INTO ndg_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Bai mahali palo papipi pabile na bui ambayo ubile mali ya nkolo wa kisiwa, mundu ywakemelwa Pablio. Atitukaribisha na kutukarimu kwa masoba atatu. ");
INSERT INTO ndg_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ipalike panga tate ba Pablio abile na homa na ugonjwa wa kuhara. Na Paulo pmwendea, akiloba, kabeka maboko nnani yake, na kumponya. ");
INSERT INTO ndg_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Baada ya lee pangika, bandu benge palo pakisiwa baabile atamwe batiyenda na kuponelwa. ");
INSERT INTO ndg_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bandu batimuheshimu kwa heshima yanyansima. Tubile twatijiandaa kusafiri, batupeya yelo twahitajia. ");
INSERT INTO ndg_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Baada ya miei itatu, twatisafiri nkati ya meli ya iskanda ambayo ibile imepigwa mbepo kolyo pakisiwa, ambayo viongozi wake babile alongo abele mapacha. ");
INSERT INTO ndg_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Baada ya kuwa twatua katika mji wa Sirakusa, twatama kolyo masoba atatu. ");
INSERT INTO ndg_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Iapangike palo twatisafiri katika mji wa Regio. Baada ya lisoba limo mbepo wa kusini uboite ghafla, na baada ya masoba abele tuikite katika mji wa Putoli. ");
INSERT INTO ndg_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kolyo twatikwembana baadhi ya alongo na twatikaribishwa na tama nao kwa masoba saba. Kwa ndela yee tuisile Rumi. ");
INSERT INTO ndg_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Boka kolyo balo alongo, baada ya kuwa wayowine habari zetu, baisile kutupokya kolyo kulisoko lya Apias na Hotel tatu. Paulo paabweni balo alongo atimshukuru Nnongo kajipea ujasiri. ");
INSERT INTO ndg_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Patujingii Roma, Paulo atiruhusiwa tama kichake pamope na yolo askari ywabile akinlinda. ");
INSERT INTO ndg_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Bai ibile baada ya masoba atatu Paulo atibakema pamope balo alalome babile viongozi kati ya Ayahudi. Pabaisile pamope, abaya kwao, “Alongo, pamope na panga nipangite kosa lolote kwa bandu aba au panga kinchogo na taratibu za apindo bitu batuyongolya, natitolewa kati mfungwa boka Yerusalemu mpaka katika maboko ga Arumi. ");
INSERT INTO ndg_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Baada ya kunnaluya, batamaniya kunileka huru, kwa sababu kwabile ntopo sababu kwango nenga yastahili adhabu ya kiwo. ");
INSERT INTO ndg_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lakini balo Ayahudi pabalongela kinyume cha shauku yabe, nililazimika kukata rufaa kwa Kaisaria, ila ibile kwaa kati panga naleta mashitaka nnani ya litaifa lyango. ");
INSERT INTO ndg_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kwa sababu ya kukata kwango rufaa, nga nyo, niloba kubabona na longela namwenga. Kwa sababu ya chelo ambacho Israeli abile na ujasiri nacho, nitabilwe na kifungo chee. ");
INSERT INTO ndg_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Boka po bammakiya, “Twapokya kwaa barua boka Yudea kuhusu wenga, wala ntopo nongo ywaisa na kutoa taarifa au baya neno lolote linoite kwaa nnani ya wenga. ");
INSERT INTO ndg_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lakini twapala kuyowa boka kwako wawaza namani kuhusu lee likundi lya bandu aba, kwa sababu iyowanike kwetu panga lalongela kinyume kila mahali.” ");
INSERT INTO ndg_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Pababile batitenga lisoba kwa ajili yake, bandu banyansima baisa mahali paabile atama. Kabaya lelo likowe kwao na kushuhudia kuhusu ufalme wa Nnongo. Atijaribu kubashawishi kuhusu Yesu, kwa namna zote ibele boka katika saliya ya Musa na boka kwa manabii, toka bwamba mpaka kitamwinyo. ");
INSERT INTO ndg_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Baadhi ya bembe batishawishika kuhusu makowe yalo yabayilwe, na benge baaminiya kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Pabatishindwa yeketyana bene kwa bene, batiboka baada ya Paulo kulibaya likowe lee limo, “Roho Mtakatifu abaya vyema pitya Isaya nabii kwa tate bitu, ");
INSERT INTO ndg_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Abaya,'Yenda kwa bandu aba ubaye, “Kwa makutu yinu mwalowa sikia, lakini mupekania kwaa; na kwa minyo yinu mwalowa lola lakini mutangite kwaa. ");
INSERT INTO ndg_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kwaajili ya mioyo ya bandu aba ibile dhaifu, makutu gabe gapekanie kwa taabu, watifunga minyo yabe; ili panga kana patange kwa minyo yabe, na kupekania kwa makutu gabe, na kutanga kwa mioyo yabe, na kerebuka kae, na nalowa kubaponya.” ");
INSERT INTO ndg_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Kwa eyo mpalikwa kutanga panga awoo wokovu wa Nnongo utipelekwa kwa bandu ba Mataifa, na balowa kuwapekania.” ");
INSERT INTO ndg_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pulo atami mu'nyumba yake ya kupanga kwa miaka yote ibele, na atibakaribisha bote baisile kwake. ");
INSERT INTO ndg_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Abile akihubiri ufalme wa Nnongo na abile akifundisha makowe nnani ya Ngwana Yesu Kristo kwa ujasiri wote. Ntopo ywankanikiya. ");
INSERT INTO ndg_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paulo Tarisi waYesu Kirisitu, ywakemilwe panga mtumishi ywa bagulilwe mwanja likewe lya Nnungu. ");
INSERT INTO ndg_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Alinga likowe lyalibaite zamani pityabkwa manabii bake mumaandiko matakatifu. ");
INSERT INTO ndg_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Yaihusu mwana wake lwabelekwimulukolo lwa Daudi kwafano wa yenga. ");
INSERT INTO ndg_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ywembe atangasilwe mwana wa Nnungu kwa ngupu ya Roho mtakatifu kwa ufunuo wa wafu Yesu Kirisitu Ngwana witu. ");
INSERT INTO ndg_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Pitia kwa ywembe tupejyilwe upendeleo na utumisi kwa utii wa aminia nkati ya bandu boti, kwa mwanja yalimo lyake. ");
INSERT INTO ndg_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nkati ya bandu'bo na mwenga kai mukemilwe mwa ba Yesu Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Barua ye jinu mwa botimwabubile Rumi, mwa mupendilwe na Nnungu, mwa mukemilwe panga mwabandu mwa atakatifu. Neena ibe kasinu, na amani buka kwa Nnungu Tate bitu na Ngwana Yesu Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Wite, nenda kusukuru Nnungu wangu nkati ya Yesu Kirisitu kwaajli jyinu mwaboti, mana aminia kwinu kwenda hubililwamulunia lwote. ");
INSERT INTO ndg_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Na Nnongo ga shaidi wango, na ywembe ngamtumika kwa mwoyo wango nkati ya Injili ya mwana wake na mwanidumu kutabwa. ");
INSERT INTO ndg_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","saa yote nenda loba nkati ya loba kwango kwandela yeyote mwiso wake nipate fanikiwa saa yeno kwa mapendo ga Nnongo kwa isa kasino. ");
INSERT INTO ndg_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","mana napenda kumona, lenga nani-nipate kupeya mwenga baadhi ya karama ya mwoyo, mbate kwaimaimalisha. ");
INSERT INTO ndg_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mana nipendi kunipeya mwoyo pamoja pamope na mwee, kwandela ya imani kwa kilammoja winu, jinuna yango. ");
INSERT INTO ndg_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Tubwe mwalongo, nipendeli nkewe tangu nyanya, Malaya na chima nende kusulya Isa kasinu, Lakini natikani kilwa mpalimo. Hivi napendiba na matunda kachino Kati mwaibile kwa bandu ba mataifa. ");
INSERT INTO ndg_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nilongelwa na Wayunani na ageni na bembe, mwerufu nalo. ");
INSERT INTO ndg_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","kwa-nyo, kwopenda kwang'o, nenga nimitayari kwilonga Injili kasinu mwenga mubile kwo Roma. ");
INSERT INTO ndg_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Maana niboni ya kwako oni Injili, Mana uwezo was Nnongo woleta wokopu kwa kill jwa-aminiya, kwakene myahudi wete na kwa bembe Myunani. ");
INSERT INTO ndg_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Mana haki ya Nnongo ibiwazi buka imani hata Imani, Kati mwaba-andike, “Mwene haki atama kwa Imani”. ");
INSERT INTO ndg_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Mana ukale was Nnongo ubi wazi baka kunani juyaasi na sambi yoti ya bandu, nayo kwandela ya udhalimu kwi-ibiya kweli. ");
INSERT INTO ndg_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Sababu yayee, ngote ngange za tanga nikilwa juu ya Nnongo kasabi wazi na Nnongo abakiye. ");
INSERT INTO ndg_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Mana mambo gake kewe ngabonekane kinanoga, angabiki tiwazi buka umbilwa kwa Dunia ngena tanganikwa ilebe pilya kwa ilebe ya umbilwe. mambo gani uwezo wake wangaliyomoka na wa-asili ya Nnongo. namatokeo gake, bandu ba tupu lyo baya. ");
INSERT INTO ndg_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Asababu yayee, ingawa batabgite kuhusu Nnongo Bantu kinelili jwembe Kati Nnongo, Wala bampelili shukurani. kichongo chake babile apumbapu mumawazo gabe, na mioyo yabeyene ulalo na yayeyilwe lubendo ");
INSERT INTO ndg_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","baikemite panga beelevu, kumbe bai alalo. ");
INSERT INTO ndg_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bangalabwi utukufu was Nnongo jwa kotoka alabika kwa mfano was kuminyo ya Mundu jwa alabika, na ya kiyuni, na ya ki-inyama bene magulu mane, na yaiumbe yetambala. ");
INSERT INTO ndg_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","kwa-nyo Nnongo alikwaleka baikengame tamaniya kwa mioyo yabeyene kwo-usapu, kwayinga yabe yo fezeheka Kati yabe. ");
INSERT INTO ndg_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Na bembe ngabalabwile kweli ya Nnongo-baubuso Naga abudu na kwitumikiya iumbe badala ya mwuumbaji na jwembe gasifilwa milele. Amina. ");
INSERT INTO ndg_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","kwa sababu Yee, Nnongo atikwa leka baikote tamaa yabe ya oni, mana alwawa babe bakulei tumya kwa zamani kwa chill Cha kibile chachoguza zamani. ");
INSERT INTO ndg_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Nagembe kaie, alalume nembe bagalei matumizi gabe ga zamani kwa alwawa na ngalambu kwa na bene kwa bene. Habaa babile analome babapate na alalome ayabe ambayo gabile Lili na boobapejyilwe azabu yayastaili-lii oba kwabe. ");
INSERT INTO ndg_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","sababu bati kana bana Nnongo muhufahamu wabe aliwaleka bakote lunda lwabe lwange faika bapange ikowe ngalonga faika. ");
INSERT INTO ndg_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","batweli na zuluma boti, tamaniya na ubaya batweli being, bulangana, bulwe, ubochobocho, na kusulya ubaya. ");
INSERT INTO ndg_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","kaibembe abai benda kopekeana, hata apindo babe ebayowa lii. ");
INSERT INTO ndg_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bembe hata tunda ntupo, hata ba-aminika lii, upendo wa samani ntupu. hata huruma ntupu. ");
INSERT INTO ndg_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Batabgite kanuni ya Nnongo bandu babapanga makowe go bapalikwa waa, Ila sio babapanga bai, hata babayeketyana na balobaba panga makowe gaa. ");
INSERT INTO ndg_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kwa-iyo ntupu uzuru, wenga woukumu, Mana bukana galugo mwukumu jwenge with ya hatia was mwene. Kwamana wenga wauukumu upanga ikowe yeyeluyelu. ");
INSERT INTO ndg_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ila tutangite ukumu ya Nnongo ya kweli kwa bandu babapanga makowe Kati goo. ");
INSERT INTO ndg_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ila wenga uwasilii, wenga waukumu balo babapanga makowe kati gaa ingawa wenga na wenga wendapanga makowe gogogo. Je walama na ukumu ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Au uwasa nchini sana juu ya wananchima wa wema wake, chelewa kwa adhabu yake, napumilia kwake? Je utangitelii wema wake ukupanga wiyendeli toba? ");
INSERT INTO ndg_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ila kwa nonopa kwa mwoyo wako na kwa mwoyo wako waukotoka tubu wibekya wa mwene akiba ya ukali kwa lisoba lilo lya ukumu, yani, lisoba lilo lya ufunuo wa ukumu ya kweli ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Jwembe alowa kunnepa kila mundu kipemo sawa na gagapangage. ");
INSERT INTO ndg_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Na balo bembe kwa usafi wa tenda kwabe kunanoga bapalike lumbilwa, heshimilwa na kotoka haribika, alowa kwapeya ukoto wangeyomoka. ");
INSERT INTO ndg_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Lakini kwa balo baimi, babakotoka kutii ukweli ila bailii dhuluma, nyango na ukale walowa isa. ");
INSERT INTO ndg_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Nnongo alowaleta dhiki na shida kwa kila nafsi ya mundu jwapangite sambi, bakwanza Ayahudi na Ayunani nembe. ");
INSERT INTO ndg_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lakini lumbilwa, heshima na amani yalowa isa kwa kila mundu ywapanga wema, wakwanja Myahudi nembe. ");
INSERT INTO ndg_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Mana ntupu pendeyelwa kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Mana kati mwebile bananchima babakosike bila salia balowa aba obabila seliya, na kati benge bananchima babakosike lengana na seliya balowa ukumilwa kwa seliya. ");
INSERT INTO ndg_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Mana sio babayowene seliya nga kwa panga bene hakinonge ya Nnongo, Ila babaipanga seliya nga babalangilwa haki. ");
INSERT INTO ndg_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Mana bandu baluniani, babakotwike bas na seliya, bapanga kwa asili ya mambo ga seliya, bembe, babi kwa seliya mioyo yabe, ingawa bembe ntupu seliya. ");
INSERT INTO ndg_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Kwa-lii babo enekana matendo gagapalikwe kwa wajibu wa wa seliya baandike nkati mumioyo yabe. Zamiri yabe nembe yenda kwashuudia benabe, na mawazo gabe bene au genda kwashitakya au'ngalendela bene. ");
INSERT INTO ndg_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","na kai kwa Nnongo. Haha gapita masoba ambayo Nnongo alowa kwiiukumu sili ya bandu boti sawasawa na injili yango, kwa ndela ya Yesu Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Tunkoye mwikoga mwa-Ayahudi, mwamutani kalimu seliya uopuli kwa kuisifu Kati ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","tungatangite mapenzi gake, Nolinga ikowe ambayo yetotautiana nayo, bada yolangilwa na seliya. ");
INSERT INTO ndg_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Natubaye witi wina ujasili panga wenga wamwene wa korongosi wa bange minyo, bweya kwa balo bababile mulubindo, ");
INSERT INTO ndg_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","wawasaisha alalo, mwalimu wa bana, nanyinyo ubile nayo museliya kati mwi ilimu na kweli. ");
INSERT INTO ndg_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Wenga bai, waumwukumu jwenge, Je, wifundisha wa mwene? wenga wa uhubiri kutokajiba, wenga ujiba lili? ");
INSERT INTO ndg_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Wenga wauba kana mube mwamalaya, je, wenga wa malaya-lii? wenga wawichukya sanamu, je ujiba mu nyumba ya Nnongo? ");
INSERT INTO ndg_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Wenga wawiluma mu seliya, je hufedheesha lili Nnongo kwa kwitenda kana seliya? ");
INSERT INTO ndg_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Mana “lina lya Nnongo lyenda fedheheshwa kali ya bandu bange aminiya jinu,” kati mwabaandike. ");
INSERT INTO ndg_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kwa inilwa likombe kwenda faika mene kotii seliya, lakini wenga Mana ubile kawi kana seliya, Inilwa kwako kulowa pangilwa ntupu inilwa. ");
INSERT INTO ndg_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Bai, banaibile, mundu jwenge inilwa kayendelwa kuikamwa mwaipalikwa seliya, je, kotoka kwake inilwa kwaputolwalii panga ainilwe? ");
INSERT INTO ndg_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Na jwembe jwaibado inilwa kwa asili alowa lii kuku-ukumu mana utimisite seliya? haye kwa sababu ubi na maandiko gaga andikilwe na likombe lakini bado wikana seliya! ");
INSERT INTO ndg_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Mana jwembe Myahudi jwabele kwa hali ya panja, Wala inilwa sio kwapanja bailii. ");
INSERT INTO ndg_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Lakini jwembe Myahudi jwabile jwankate, nalikombe lya mwoyo, mumoyo, sio mumaandiko lii, sifilwa kwa mundu kwa nyoibukana lii na bandu Ila kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Hivi ni faiga gani ya bile nayo Myahudi? Na faida likokombi namani? ");
INSERT INTO ndg_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Inogite kwa kila ndela, Awali ya goti, Ayahudi bapejilwe ufunuo buka kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Lakini, ibikiliwi kubina Ayahudi benge ntupu imani? Je, kotoka aminiya kwabe aminiya kwa Nnongo ba ubocho? ");
INSERT INTO ndg_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ntupu, badala yake, uneke Nnongo abonekane nkweli, hataitei kila mundu mmocho kati mweandikilwe, “uwese baurekana panga wa mwene haki. Mumakowe gako nawawezeshinda mewe kojingya muhukumuni”. ");
INSERT INTO ndg_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Lakini mana ibile dhambi jitu walowa bonekana haki ya Nnongo, Tubaye buli? Nnongo mdhalimu Lili papiya ukale wake, je abile nyoo? Nilongela bukana na mantiki ya kimundu. ");
INSERT INTO ndg_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ntupu, Ibinyoli kwa ndela gani basi Nnongo alu ukumu lunia? ");
INSERT INTO ndg_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Namana itei kweli ya Nnongo pitya umubuchu wango piya lumbilwa kwananchima kwajili yake, mwanja namani nibii bado Kani hukumilwa kati na mwene dhambi? ");
INSERT INTO ndg_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Mwanja namani kana tubaye, kati mwa batukopiye na kati benge mwabathibilisha panga twenda longela, “Tupange dhambi linga gananoga gaise”? Ukumilwa kwabe sawasawa. ");
INSERT INTO ndg_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kinamani kai? Twitetee twabene? Ntupu kabisa. Kwasababu twabene tayari tutikwalaumu Ayahudi na Ayunani boti mpamo, panga babii pae ya dhambi. ");
INSERT INTO ndg_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Haye kati mweandikilwe: “Ntupu mwene haki hata yumo. ");
INSERT INTO ndg_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ntupu mundu ywa tangite. Ntupu mundu jwa mpala Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Boti bagalambwike. Bembe kwa pamope babile Ntupu maana. Ntupu ywa panga wema, kabisa, hata yumo. ");
INSERT INTO ndg_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Makolomelo gabe kati likabuli lyange kulya. Milimi yabe itikombiya. Sumu ya ng'ambo ibii pae ya maboko gabe. ");
INSERT INTO ndg_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Mikano gabe ilweli laana na uchungu. ");
INSERT INTO ndg_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Magulu Gabe gai na lubele yo pengana mwai. ");
INSERT INTO ndg_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ubau na mateso gabi mundela gabe. ");
INSERT INTO ndg_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Bandu baa batangite lii ndela ya amani. ");
INSERT INTO ndg_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ntupu kunyogopa Nnongo nnongeya minyo Gabe”. ");
INSERT INTO ndg_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Pano lelo tutangite kumbe chochote seliya chakilongela ilongela na balo bababile pai ya seliya. Lenga kila nkano banine, na lunga lunia yoti tuwajibike kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ajii ni kwasababu ntupu mwili wawabalangilwa haki kwa kwipanga matendo ga seliya nnunge ya minyo gake. Mana pitya seliya isa kwitanga dhambi. ");
INSERT INTO ndg_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ila bila seliya, haki ya Nnongo itanganikwa lii. Tabakijilwe kwa seliya ya manabii, ");
INSERT INTO ndg_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","iyo ni, haki ya Nnongo pitya kwa imani ya Yesu Kirisitu kwa balo boti babaaminiya. Mana ntupu tofauti. ");
INSERT INTO ndg_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Kwasababu boti bapangite dhambi na pungukilwa na balaka ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Babalangilwe na haki bule kwa neema yake kwa ndila yakombolelwa na Kirisitu Yesu. ");
INSERT INTO ndg_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Kwa mana Nnongo alikupiya Kirisitu Yesu satupatanise kwa ndela ya imani kwa myai yake. Ampiyite Kirisitu kati usaidi wa haki yake, kwasababu kutulekelea dhambi yepite ");
INSERT INTO ndg_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","katika pumiliya kwake. Aga gati pitya lenga bonekana balangilwa kwa haki, mundu ywoywete kwasababu ya imani kwa Yesu. ");
INSERT INTO ndg_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","kubii kwa'ko basi kwilumba? Batibagana. Kwa misingi gani? misingi ga matendo? Hata, ila kwa singi was imani. ");
INSERT INTO ndg_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Tumbwe tuyomolwa nyanya mundu abalangilwa haki kwa imani bila makowe ga seliya. ");
INSERT INTO ndg_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Au Nnongo ni Nnongo Ayahudi bai? je jwembe si Nnongo wabandu bange aminiya na bembe? Ngamwebile, Nabange aminiya na bembe Nnongo wabe. ");
INSERT INTO ndg_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Mana ibi kweli Nnongo yumo, alowa kwabalangwa ya haki nababa inilwe likambi kwa imani, na bange inilwa kwa ndela ya imani. ");
INSERT INTO ndg_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Au twenga twibadilisha seliya kwa imani? Ata! nchogo ya ago, twenga twikong'ondya seliya. ");
INSERT INTO ndg_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tulowa longela namani kai panga Abraham, Tate bitu kwa ndela yenga, Apatikine? ");
INSERT INTO ndg_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kwa Mana manaitei Abraham abalangilwe haki kwa matendo apeba na sababu ya kulumba, ila sio nnonge ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kwani maandiko gabaya buli?”Abraham amwamini Nnongo, na abalangilwe panga abi na haki”. ");
INSERT INTO ndg_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Tumbwe kwa mundu jwa pangage lyengo, libilwa kwake kwa ubaya lili kwa bule ila ni haki yake. ");
INSERT INTO ndg_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ila kwa mundu jwange panga lyengo ila amwombilwa jwembe amalangwa haki jwa bile Lili mcha Nnongo, imani yake mundu jwo ibalangilwe panga ibi na haki. ");
INSERT INTO ndg_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Daudi na jwembe alongela kuhusu baraka kwa mundu ambae Nnongo amalanga haki bila matendo. ");
INSERT INTO ndg_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Akojike, “Babalikilwe balo masambi gabe basamiilwe na bembe nembe ubaya wabe utiwikejelwa. ");
INSERT INTO ndg_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Atibalikilwa mundu julo ambae Nnongo amalangwa lili na dhambi. ");
INSERT INTO ndg_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Buli baraka yii ibii'kwaajili ya bandu babainilwe bai, au na babakotwike inilwa? mana twenda longela, “Kwa Abraham aminia kwake yabalangilwe panga haki”. ");
INSERT INTO ndg_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ivi twabalangilwe kitiwi? Wakati Abraham ainilwe au bado inilwa? Yabilelii ainilwe, Ila abi bado inilwa. ");
INSERT INTO ndg_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abraham apoki alama ya likombe. Agogo wabile muhuri yelo haki ya imani abile nayo tayari kabla ana inilwa-lii. Matokeo gake ga alama aye abalangilwe panga Tate ba bahamini, hata bange inilwa kwinama panga hakinga yabalangilwa. ");
INSERT INTO ndg_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ayiee inamana Abraham bampangite tate ba torati sio bainama babainilwe bai, ila hata balo babakotwike kwikote njayo lati bitu Abraham. Nayee nga imani yabile nayo kwa bange inilwa. ");
INSERT INTO ndg_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Mana yabile-lii kwa seliya kwamba ahadi ipiyilwe kwa Abraham na kwa lukolo lwake, ahadi panga barithi lunia. Ilaa yapitya mu haki ya imani. ");
INSERT INTO ndg_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Mana itei mana ya panga balo ba seliya ga'barithi, imani ibile ya bule, Na mwatu aidile ingalabwike. ");
INSERT INTO ndg_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Mana seliya ileta ukale, lakini palo panga seliya ntupu. napabile kotoka utii. ");
INSERT INTO ndg_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Kwasababu yeipitya kwa imani, linga ibe kwa neema. Matokeo gake, ahadi ibii dhaili kwa lukolo lwote, Na lukolo lokisabe ngabatangite seliya bai-lii, ila na balo ba imani ya Abraham. Mana jwembe Tate bitu twa boti. ");
INSERT INTO ndg_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kati mwaiandikilwe, “Nikupangite panga tate ba nnema goti”. Abraham abile nkati ya upeo wa julo jwa aminile, yani, Nnongo jwapeya maiti ukoto na kugayeya makowe gaga kotwike bali ngagaweze baa. ");
INSERT INTO ndg_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Licha ya ali yoti ya panjaa, Abraham kwojasili aliaminiya Nnongo kwa machoba gagaisa. Ndomana abile tati ba mataifa ganansima. bokana silo sakilongelikwe “Ngamwalowa baa lukolo lwako. ");
INSERT INTO ndg_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Jwembe abile-lii mpungufu muimani. Abraham ayeketi panga kuwa jenga yake mwene iyomwile was abile na miaka karibu mia jimo. Kaibile na hali yowa ya ndumbo ya Sara. ");
INSERT INTO ndg_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Lakini mwanja mwa mwaidi Nnongo, ........ ");
INSERT INTO ndg_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Atangite yo panga che'lo cha mwaidi, Nnongo kaiabi na uwezo wo kamilisha. ");
INSERT INTO ndg_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Naji nembe yabalalangilwe kasake panga haki. ");
INSERT INTO ndg_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Naandikilwa soon kwa faida yake bai. ");
INSERT INTO ndg_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Yaandikilwe kwa faida jitu twenga. Kwabakilwe balangilwa, Twenga twatuaminiya nkati ya jwembe jwa mfufuwite Nngwana witu Yesu buka mukiwo. ");
INSERT INTO ndg_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ajo nga yolo jwapijilwe kwa mwanja ga makosa gitu na kunyonya lenga tupate balangilwa kwa haki. ");
INSERT INTO ndg_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Kwasababu tubalangilwe na haki kwandela ya imani, twina amani na Nnongo kwa ndela ya Nngwana witu Yesu Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kwopitya jwembe twenga na twabembe tupatike tusa kwa ndela ya imani kwa huruma ye ambayo nkati yaka twenda jima. Twenda pulahi mujasili watupeya Nnongo kwa ajili wakati wengi, ujasili ambao twasiriki mu utukufu wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ale bai-lii, lakini twalowa pulaika mu mateso ngitu. Tutangite teseka nga kubeleka pumilia. ");
INSERT INTO ndg_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Puliya nga kubeleka jeketelwa, najiketelwa beleka ujasili kwa ajili ya woti wenge. ");
INSERT INTO ndg_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ujasili ango ukukatisha lii tamaa, kwa mwanja upendo wa Nnongo upange ni kemu mioyo jitu pitya kwa roho mtakatifu jwa pijilwe kasitu. ");
INSERT INTO ndg_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Palwa bile tutuwesalii, kwa muda wake Kirisitu ati'waa kwaajili ya wokovu. ");
INSERT INTO ndg_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Yalowa bangumu yumo kwaajili ya mundu mwene haki. Ibinyonyo, mara yenge mundu alweza thubutu was kwa ya mundu mwema. ");
INSERT INTO ndg_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lakini Nnongo atu akikishi upendo wake mwene kasitu, mwanja patwabile bado twabene dhambi, Kirisitu ati'waa kwaajili yitu twenga. ");
INSERT INTO ndg_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Nazaidi ya goti, nambiyambi tubalangilwe haki kwa mai yake, twalowa pona buka mu nyongo ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Mana, wakati wa twabile twa madui, twapatanisilwe na Nnongo kwa ndila ya kiwo sa mwana wake, na Sana, baada ya panga tupatanisilwe, twalowa lopolwa kwa maisha gake. ");
INSERT INTO ndg_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Nganyo bai-lii, ila kai tupulaika na nkati ya Nnongo pitya kwa Nngwana witu Yesu Kirisitu, kwo pitya ywembe ambaye siku yeno tupokile upatanisho-goo. ");
INSERT INTO ndg_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nganyo lelo, mana pitya kwa mundu yumo dhambi ya jingi mu dunia, kwa ndela yee kiwo cha jingi kwa ndela ya dhambi. Na kiwo chatienea kwa bandu bote maana boti bapangite dhambi. ");
INSERT INTO ndg_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kwa kuwa mpaka seliya, dhambi yabile mu dunia, lakini dhambi ibalangilwa-lii Mana ntupu seliya. ");
INSERT INTO ndg_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Hata nyoo, kiwo chalawalike buka Adam mpaka Musa, hata kunani ya balo babakotwike panga dhambi kati kwa kanitii Adam, na ywenbe ga mfano wa ywalowa. ");
INSERT INTO ndg_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lakini hata nyoo, zawadi yabule si kati likosa. Mana itei kwalikosa lwajumo bananchima batiwa, zaidi sana urumu ya Nnongo na zawadi kwa uruma mundu yumo, Yesu Kirisitu, itizidi yongezeka kwananchima. ");
INSERT INTO ndg_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kwasababu siyo panga gayulo jwapangite dhambi. Lakini kwa penda kwananchima, ukumu ya dhambi yatiisa kwa mwanza kosa kwa mundu yumo, ila kwa upande wenge kipawa chabule chakibukana balangilwa haki saisii baada gamakosa gananchima. ");
INSERT INTO ndg_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kwa maana, mana itei kwalikosa lya mundu yumo, kiwo chatawalike pitwa kwayumo saidi sana balo baba uruma yananchima pamope na kipawa cha haki balowa tawala pitya maisha ga yumo, Yesu Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nyanyo basi, mana itei pitya kwa likosa limo bandu boti icha kuukumu, kwapitya kwa kitendo chio cha haki kwaisile balangilwa kwa haki ya maisa ya bandu boti. ");
INSERT INTO ndg_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Mana kwo pitya kotoka lii kwa mundu yumo bananchima balangilwe bene sambi, kwa nyo pitya kwa utii wa mundu yumo aingi balangilwe bene haki. ");
INSERT INTO ndg_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Lakini seliya yayingi pajimo, lenga likosa-lii wesa landala. Lakini bandu pebisambi yananchima, uruma yatiyongeyeka muno. ");
INSERT INTO ndg_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Aye yapiyilwe lenga wite, Kati sambi mwetalite mukiwo, ngamwebile hata uruma yenda weza tawala pitya mu haki kwasababu gage yomoka pitya kwa Yesu Kirisitu Nngwana witu. ");
INSERT INTO ndg_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tubaye buli? Tuyendeli musambi lenga uruma iyongeseke? ");
INSERT INTO ndg_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ata. twenga twatuwile musambi, tulowa wesa buli Kai tama mo? ");
INSERT INTO ndg_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Mutangite Lili balo baba batisilwe nkati ya Kirisitu babatizwi mumaiti gake? ");
INSERT INTO ndg_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Twabile twasikilwa pamope na jwembe pitya mu utizo mukiwo. Ayee yapangilwe linga Kati Kirisitu mwajumwike buka mukiwo pitya mu utukufu wa Tate, lenga na twenga tuweze tyanga mu wayambie wa maisa. ");
INSERT INTO ndg_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Mana mana-tuunganisilwe pamope na jwembe katika mfano wa kiwo sake, tuunganisilwe mu ufufuo wake. ");
INSERT INTO ndg_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Twenga tutangite nyonyo, umundu witu wa zamani wati sulubiswa pamope na jwembe lenga yega ya sambi ualibikwe. Aye yabu nkati lenga wite kana tuyende lii batwa utumwa ba sambi. ");
INSERT INTO ndg_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Jwembe ywabile apangilwe mwene haki lingana sambi. ");
INSERT INTO ndg_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Lakini mana tuwile pamope na Kirisitu, tuaminiya panga twalowa tama na jwembe kai. ");
INSERT INTO ndg_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Tutangite panga Kirisitu atijifufulilwa buka mukiwo, na jwembe maiti-lii. Kiwo kitawala lili kae. ");
INSERT INTO ndg_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Mana kwa abari ya kiwo chabwile mu sambi, awhile mara jimo kwaajili ya boti, hata nyoo maisa gatama, atama kwajili ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Kwa ndela yoo, na mwenga na mwemupalikwa kwibalanga muwile katika sambi, ila mwakoto kwa Nnongo nkati ya Kirisitu Yesu. ");
INSERT INTO ndg_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kwasababu yo kana uyeketi sambi itawale payega yako lenga uweze kwitii tamaa zake. ");
INSERT INTO ndg_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kene wapiye seme ya yenga yako musambi kati yombo yange haki, ila wipiye wamwene kwa Nnongo, kati bababile akoto buka mukiwo. Namwipeye sehemu ya yenga jinu kati yombo ya haki kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Kana mwileke sambi itawale kwa kuwa mubili paie ya seliya, ila pae ya uruma. ");
INSERT INTO ndg_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Kinamanile? Tupange sambi kwa sababu tubuli-lii pae ya seliya, ila pae ya uruma? Ataa. ");
INSERT INTO ndg_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mutangitelili panga kwake jwembe jwa ipiya mwene Kati atumishi jwembe ngamupanga mtumisi wake jwo, jwembe ngamupalikwa kumtii? Ayee kweli hata kwa mwenga mwatumwa a'sambi yaipelekya kukiwo, kutumwa wautii waukepeleka ku haki. ");
INSERT INTO ndg_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Lakini tushukuru Nnongo! Kwa kuwa mwabi mwatumwa ba sambi, lakini muyomwile tii buka kumwoyo kati mapundiso ga mpokile. ");
INSERT INTO ndg_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mupangilwa uru buka mu sambi na mutangite mwatumwa ba haki. ");
INSERT INTO ndg_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ninalongela kati na mundu kwasababu ya mapungufu nga miili yinu. Kwa mana kati mwebile mwamwipiyele iungo ya yenga jino, ba mwatumwa wa haki kwa takasika. ");
INSERT INTO ndg_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Kwa kuwa mwapoki atumwa ba sambi, mwabile uru kutolu na haki. ");
INSERT INTO ndg_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Kwa muda woo, mwabile na litunda gani kwa makowe na kwa saa yeno mwibona oni kwa ago? Kwasababu matokeo ga makowe ago ni kiwo. ");
INSERT INTO ndg_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Lakini kwa saa yeno mupangilwe uru kutolu na sambi na mupangike mwa atumwa kwa Nnongo, mubi na litunda kwa ajili ya utakaso. Buka ukoto wangeyomoka. ");
INSERT INTO ndg_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwasababu msaala wa sambi ni kiwo, ila sawadi ya bure ya Nnongo ni bwomi wangeyomoka kwa Kirisitu Nngwana witu. ");
INSERT INTO ndg_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Au mutangite kwako, (kwa kuwa nikoya na babatangite seliya), kwa kuwa seliya itawala mundu yes bile mwomi? ");
INSERT INTO ndg_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Mana ajwo nwawa jwakondeke atabilwe na seliya kwa another nchengowe mana abile nkoti, ili mene ayomwike mene awile, alowa panga mutabilwe ya seliya ya ndoa. ");
INSERT INTO ndg_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Tumbwe kae, wakati about asengo babe babi aomi, mene itei atama na nalume jwembe akemelwa mmalaya. Ila mene abo asengo babe bawile, nai lusa kwa seliya, hapo apangali mmalaya, mene itei akonda kwa nnalume ywenge. ");
INSERT INTO ndg_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","kwa-nyo, mwalongo bango, mwapangilwe maiti kwa seliya kwa ndila ya yega ya Kirisitu. Ibile nyoo lenga mupale unganishwa na jwenge kwa ywembe jwa fufuliwe buka kiwo lenga tuweze ku-papya Nnongo matunda. ");
INSERT INTO ndg_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Mana patwabile haya payiga nkati ya mwili, tamaa ya sambi yatijumukilwa muiungo yoti kwa ndila ya seliya na kwipapya maiti matunda. ");
INSERT INTO ndg_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ila saa yeno tuyong'olilwe buku mu seliya. Tuweli mulo hali yayatupingite. Lenga twenga tupate tumika mu hali yayambe ya Roho, nasi hali ya zamani ya andiko. ");
INSERT INTO ndg_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Tulongele buli? seliya sambi? Ataa, Alanyo, mbele kwitangalii sambi, ila kwa ndela ya seliya. Kwa kuwa mbele tangalii tamaniya bila seliya ika kotoka baya, “Uneutamani”. ");
INSERT INTO ndg_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Lakini sambi yapatike nafasi kwa yelu amri ni takatifu ya haki na ukoto. ");
INSERT INTO ndg_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Nanenga nabi na koti hapo zamani bila seliya, lakini payaichi yelu amri, sambi yapatike ngupu, na nenga nganawile. ");
INSERT INTO ndg_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Yelo amri ye peleleta ukoto yatigalambuka yabi kiwo kasango. ");
INSERT INTO ndg_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kwa mana sambi yapatike nafasi kwa yelu amri na yatigonga pitya mulo mu'amri yatimbulaga. ");
INSERT INTO ndg_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Kumbe seliya takatifu, na yelo amri nembe takatifu, ya haki, na ukoto. ");
INSERT INTO ndg_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kumbe iyo ya ibele ya ukoto yabile ya kiwo kasango nenga kana ibe nyoo kabisa. Lakini sambi, yabonekine panga sambi hasa pitya kwa yalo njema, yaileta kiwo ngati yango. Ayee yabile pitya kwa yelo amri, sambi kene ya pange mbaya muno. ");
INSERT INTO ndg_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Mana tutangite panga seliya tubwa kwake ni ya mwoyo, lakini nenga na mundu wa payenga, mpemejilwe pa'e ya utumwa wa sambi. ");
INSERT INTO ndg_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mana lanilipanga nilitangite-lii kabisa, mana lelo lyanipendile kulipanga-kwako na lyanichukya, nganilipanga. ");
INSERT INTO ndg_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Lakini mana nilipangite lelo lyanikotwike kulipenda, seliya yenda kuniyeketya yo panga seliya ni nkoto. ");
INSERT INTO ndg_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ila nenga lili nafsi yango yanipangalyo, ila yelo sambi yaitama nkati yango. ");
INSERT INTO ndg_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Kwa Mana ndangite nkati yango, yani, nkati ya payenga yango, litama kwako likowe linanoga. kwa kuwa tamaniya kwa linanoga ibi kati yango, ila nipanga-lii. ");
INSERT INTO ndg_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kwa maana lelo linanoga lyanilipendile nilipanga kwako, ila lelo libaya lyangotwike kulipenda ngalyo ndenda. ");
INSERT INTO ndg_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Tubwe Mana kandenda lelo lyangotwike kulipenda si nenga kiyango nganipanga, kumbe yelo sambi yango yaitama nkati yango. ");
INSERT INTO ndg_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ndangite ibile haki ngati yango yaipala panga lyalibile lizuri, lakini ubaya ubile nkati yango. ");
INSERT INTO ndg_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Mana Nenda kuipulaikya seliya ya Nnongo kwa mundu jwa nkati. ");
INSERT INTO ndg_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Lakini mbona tofauti nkati ya viungo ya yega yango. Ingawa kwina ngonda juyo kanuni ya yambi na mulunda lyango. ");
INSERT INTO ndg_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Need na mundu wene uruma! nyai jwaweza kunilopwa yega ya kiwo? ");
INSERT INTO ndg_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Lakini ni shukuru Nnongo na Yesu Kirisitu Nngwana witu! Nga-nyo. Nenga na mwene kwa akili yango nitumikiya seliya ya Nnongo. Ila kwa yenga nitumikiya kanuni ya sambi. ");
INSERT INTO ndg_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Tumbwe lelo tupu azabu nkati ta bababile nkati ya Kirisitu Yesu. ");
INSERT INTO ndg_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kwasababu kanuni ya Roho ni wankoto waubile katika Kirisitu Yesu inipangite nenga ba uru kutalu na kanuni ya sambi na kiwo. ");
INSERT INTO ndg_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mana kila sasasindwi seliya panga Mana Yabilelii na ngupu mu yega, Nnongo apangite. Atumite wana wake wakiyake kwa mfano wa yega ya sambi na kwi-ukumu sambi kwa yega. ");
INSERT INTO ndg_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Apangite nyoo langwa kwa seliya gatimu nkati jitu tenga twatujenda bila fuata makowe gamuyega, Ila kwa kotea makowe ga Roho. ");
INSERT INTO ndg_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Baba-ikoteya yega waza kwabe makowe ga yenga, lakini ywa ifuata Roho bagawaza ga mwoyo. ");
INSERT INTO ndg_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Sababu kusudi lya yega ni kiwo, ila nia ya Roho ni ukoto na amani. ");
INSERT INTO ndg_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Hayeye kwasababu niya ya yega adui wa Nnongo, sababu itilili seliya ya Nnongo, wataiweza kwa eshimu. ");
INSERT INTO ndg_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Balo baufuata yega baweza kwa kumpendeza Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Hata nyo, paba bamuyega ila mumwoyo mana itei kweli mu Roho wa Nnongo tama nkati jino. Lakini mundu mana ntupu Roho wa Kirisitu jwembe jwake kwako. ");
INSERT INTO ndg_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Mana Kirisitu abi nkati yino yega iwile kwa ikowe ya sambi ila mwoyo ubi nkoti kwa ikowe ya haki. ");
INSERT INTO ndg_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Mene itei Roho wa yolo jwa mfufuwite Yesu buka mu kiwo atama nkati yinu, jwembe jwa mfufuwite Yesu buka mukiwo alowa kwipeya yega yinu ya kiwo ukoto kwa ndela ya Roho wake, jwa tama nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nga nyo bai, mwalongo bangu, twenga tubi na deni, lakini kwa yega kwa tutame kati mwaipendi yega. ");
INSERT INTO ndg_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Maana mana itei tama kaa ndela ya yega, mwikalibu yo'waa, lakini kwa Roho mugayebeya makowe ga yega, namwenga mwalama. ");
INSERT INTO ndg_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Mana Kati benge bananchima babe ongozwa na Roho wa Nnongo, haba bana ba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Mana mupoki kwa mwoyo wa utumwa kai hata muyogope. Badala yake, mupoki mwoyo wa panga mwabene, kwako twondolela, “Abba, Tati!” ");
INSERT INTO ndg_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Roho mwene enda kutuakikishia nanyine Roho yito yo panga twenga twabana ba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Mana itei kweli twalowa teswa na jwembe lenga tupate lumbilwa pamope na jwembe. ");
INSERT INTO ndg_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Kwa kuwa indabalangilwa mateso ya wakati ngo panga ntupu kilebe nikifananise na utukupu wa wwbonekana kasitu. ");
INSERT INTO ndg_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Mana iumbe yoti yenda tazamia kwa tamania kwananchima bonekana kwa mwana wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Mana umba na kwembe pangite pae ya ubocho, sio kwa penda mwene, Ila kwa sababu yake jwembe jwa itiisike, Na muli tumaini. ");
INSERT INTO ndg_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Uumbaji wene na wembe wapikitwa uru na buyelwa mu utumwa wo alibika, na kujingiya mu'uru wa utukupu wa bana ba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Tutangite panga umbilwa na wembe wenda minya na teswa kwo minya pamope hata leno. ");
INSERT INTO ndg_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Nga nyo bai-lii, ila twabene twatubi twa milembo ya Roho- twenga twabembe twenda minya mu nafsi yitu, katulenda pangilwa twa bana, yani kombolelwa kwa yega yitu. ");
INSERT INTO ndg_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kwa tegemea kwo twati okoyelwa. Lakini satukilandage sabonekine ntupu chatukilendage mana nyai jwakilenda chakibonekana? ");
INSERT INTO ndg_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ila makatukilenda kilebe cha tukotoka kukibona ntupu saburi. ");
INSERT INTO ndg_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ila nanyonyo-nyo, Roho nembe kutuyangatia kwo dhaifu witu. mana tumanyi lii yupo kati mwaipangilwa, lakini Roho mwene kutulobya kwo minya uweza lii atabaya. ");
INSERT INTO ndg_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Naywembe kwilingulya mioyo na kwitanga akili ya Roho, ywembe loba kwaniaba ya baba aminile, lengana na mapenzi ga Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Natwenga tutangite panga bote babampendi Nnongo, jwembe tenda kila kilebe pamo na wema, kwa balo babakemilwe kwa likusudi lyake. ");
INSERT INTO ndg_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Mana balo boti bapangite buka zamani, atikwa sawa buka zamani afananisa na mwana wake, lengo jwembe Abe mwelewa kwanza nkati ya alongo baingi. ");
INSERT INTO ndg_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Na balo basawile buka zamani, na bembe akemite, na balo bakemilwe, habo abatangite bai na haki. Na balo babalangilwe muhak, na bembe atikwalumba. ");
INSERT INTO ndg_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Tubaye buli kuhusu ikowe yee? Nnongo Mana abile upande witu, nyai jwa ba kunani jitu? ");
INSERT INTO ndg_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Jwembe jwa kotwike kuneka mwana wake mwene ila atikumpiya kwa ajili yitu twenga twaboti alowa kosa buli kutukilimia na makowe goti pamoja na jwembe? ");
INSERT INTO ndg_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Nyai awesa kuwasitaki ateule wa Nnongo? Nnongo mwene kwaesabia haki. ");
INSERT INTO ndg_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Nyai jwalowa kumwukumu adhabu? Kirisitu Yesu nga jwawile kwaajili yinu, na zaidi ya goo, jwembe nembe atiyolelwa. Enda tawala pamope na Nnongo na pandu pa heshima, na kai ngatulobya twenga. ");
INSERT INTO ndg_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nyai jwaweza kutubuya mupendo wa Kirisitu? Sikikwa, au utumwa, au tesekwo, au njala, au bula, au hatari, au lipanga? ");
INSERT INTO ndg_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kati mwaiandikilwe “Kwa faida yako ni minya lisoba lyoti kutwa. Twabalangilwe nkati ngondolo jwo chinjilwa.” ");
INSERT INTO ndg_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Katika ikowe yee yoti twenga twashindi nkati ya jwembe jwatupendile. ");
INSERT INTO ndg_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Mana niyomwile kongeka panga at ntuwi, wala ukoto, wala malaika, wala utawala, wala ilebe yaibile, wala ilebe yai isa wala ngupu, ");
INSERT INTO ndg_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Wala yaibi kunani, Wala gagabile pae wala kyumbe sengi chote, kiweza-kwa kutubangania no upendo wa Nnongo, jwembe nga Kirisitu Yesu Nngwana witu. ");
INSERT INTO ndg_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Nilongela kweli nkati Kirisitu. Nilingela lii uboso, na dhamiri yango hushudia pamo na nee nkati Roho Mtakatifu, ");
INSERT INTO ndg_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Kuwa kwina huzuni ngolo na minya kwangekotoka nkati ya mwoyo wango. ");
INSERT INTO ndg_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Mbeletamaniya nenga na mwene laaniwa na benge lwa ekutalu na Kirisitu kwasababu ya alongo bango, balo baubile nabo pamope kwa payiga. ");
INSERT INTO ndg_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Bembe ni Baisraeli. Baba bi na ali ya pangika bana, wa utukufu wa malagano, na sawadi ya seliya, kunnoba Nnongo, na ahadi. ");
INSERT INTO ndg_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Bembe bati longolwa bembe Kirisitu ati icha kwa heshima kuwala mwili goo-na jwembe ni Nnongo wa yoti. na jwembe alumbilwe bila yomoka. Amina. ");
INSERT INTO ndg_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Lakini si ahadi ya Nnongo itishindwa timya. Mana sio kila mundu jwabile Israel ga Mwisrael halisi. ");
INSERT INTO ndg_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Lili hata kibelekwi wa Abraham ni baba bake halisi. Ila, “pitya kwa Isaka lukolo walowa kemelwa.” ");
INSERT INTO ndg_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ibi nyanya, bana ba yega si bana ba Nnongo. ila bana ba twahadi babonekana ba kati lukolo. ");
INSERT INTO ndg_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Mana ale ga likowe lya ahadi: Muda wa majira go nalowa icha, na Sara apeyelwa mwana.” ");
INSERT INTO ndg_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ngaale bai, lakini baada ya Rebeka jingya ndumbo kwa mundu jumo, Isaka tate bitu- ");
INSERT INTO ndg_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","“Kwamba bana babi bado bana belekwa kwoko na aina panga lili lyolyote linanoga aulibaya, lenga likusudi lya Nnongo lengana na chawa liyeme, wala kwa makowe lili. ");
INSERT INTO ndg_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Ila kwasababu gayule jwa kemilwe. Jabaite, “Nkolo atumikia nnuna.” ");
INSERT INTO ndg_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kati mwaiandikilwe: “Yakobo nampendike Ila Esau nimpendikwo.” ");
INSERT INTO ndg_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Bai lelo tukoyekwa? Je kwinaiba kwa Nnongo? Ata. ");
INSERT INTO ndg_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Mana alongei na Musa, “naba na samaha kwa jolo jwa nasamya, naba na uruma kwa jolo jwa namulumiya”. ");
INSERT INTO ndg_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Kwa-nyo, sio kwasababu ya jwembe jwa pala, sio kwasababu ya jwembe jwa tila, lakini kwa mwanza Nnongo, ngabi uruma ");
INSERT INTO ndg_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Mana maandiko longela kwa Farao, “likusudi-lee malum natikundobeya, lengo nikulaye ngupu yango kasako, lenga Lina lyango balitangaze panepa wote”. ");
INSERT INTO ndg_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Nganyo bai, Nnongo abi na uruma kwo jwojwote jwa mpendile, na jwapala kupenda, humpanga kuwa kiburi. ");
INSERT INTO ndg_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Mwiso wabaya kasango, “mwanja namani bado kalibona likosa? jwaa'ko jwabile sawasawa na mwapendi jwembe? ");
INSERT INTO ndg_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Chachongo chake, mundu wenga wauyangwa kina chogo cha Nnongo? Kwanda wezekana cha kiukulikwe, longela kwa jwa mwikwile, mwanza namani uniukwi nyoo?” ");
INSERT INTO ndg_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Tutangite kwa jwa ukwa aina haki kwa kitope lengeneza kikowe kwa mwa tumizi gapendi mwene. ");
INSERT INTO ndg_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Buli Nnongo, jwabi tayali jwo laya ukali wake napanga ngupu yake tanganikwa, atistaili kwa pumiliya wa lengana yombo yaibelikwe kwa kwitiniya? ");
INSERT INTO ndg_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","buli mana waipangite yananchima lenga wilaye yananchima kwa utukufu wake juu ya yombo ya uruma ya yomwile kibika kwaajili ya utukufu? ");
INSERT INTO ndg_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","buli mene apangite nakanchime na twenga twatukemite, siyo buka kwa ayahudi bai, ila buka na amataifa? ");
INSERT INTO ndg_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kat mwabaite Hosea: nalowa kwakema bandu bango baba bile lii bandu bango, na jwaa nipendile jwa abile adui jwango. ");
INSERT INTO ndg_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Nayalowa ba palo pababaite kasabe, mwenga mwabangu bango kwa hopo bolowa ukemelwa mwabana ba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaya andalela juu ya Israel “Kati isabu ya bana ba Israel ipeleke ba kati mwangi ya kubali, yalowaba kati linena babaokolewa. ");
INSERT INTO ndg_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Mana Nngwana alowa kulipotwa likewe lyake kwa nnema, mapena na kwatulia. ");
INSERT INTO ndg_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Maana kati Isaya alongei hapo zamani panga Nngwana wa majeshi atuleki kwako lukolo kwaajili yitu, tulwe panga kati Sodoma na Gomola. ");
INSERT INTO ndg_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Tukoya lwaku oti, bandu ba mataifa bababkotwike pala haki, pabapatike haki, haki kwaaminiya. ");
INSERT INTO ndg_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Lakini Israel jwa ipalae seliya ya haki, haipatike kwa. ");
INSERT INTO ndg_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","mwanja namani? sababu baibalikwe kwa kwa imani, ila kwo tenda, bati kwikobola muliwe. ");
INSERT INTO ndg_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Kati mwaiandikiwe “lollekeya, niligonjike liwe liwe la kwikobala, lya sayuni na mwamba wa kosea jwembe jwa aminiya muhe hapata kwa oni”. ");
INSERT INTO ndg_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","mwalongo, niya yamoyo wangu na mwaniluba kwa Nnongo kwa ajiyabe, kwaajili ya wokovu wabe. ");
INSERT INTO ndg_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Mana nabakya panga bai na bidii kwa Nnongo, ila sio kwa ajili yo tanga. ");
INSERT INTO ndg_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kwa kuwa matangite lii haki ya Nnongo, na bapala haki yabe bene, babile lii ati bahaki ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kwakuwa Kirisitu ndo timwa kwa seliya kwa ajili ya haki ya kila mundu jwa aminiya. ");
INSERT INTO ndg_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musa aandike yaihsu haki ya isa buka ku seliya “mundu jwa panga haki yaseliya alowa tama kwa haki yee” ");
INSERT INTO ndg_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Lakini haki ya bukana na imani ilongela nyoo “kana ulongele mumwoyo wako nyaijwa nguluka jenda kunani? (aye kumwuluya Kirisitu pae) ");
INSERT INTO ndg_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Na kana ubaye nyai jwa uluka mulebwa?” (aye nga kupeleka Kirisitu kunani buka mu kiwo) ");
INSERT INTO ndg_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","lakini ilongela namani? likowe libii karibu na wenga, mukano na mumwoyo wako.”ale likowe lya imani, ngatu litangaza. ");
INSERT INTO ndg_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Mana itei kwa mukane wako unyeketeya Yesu yopanga ni Nngwana, nakumwaminiya mu mwoyo wako panga Nnongo ati kufufua buka mukiwo, walowa okoka. ");
INSERT INTO ndg_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","sababu kwa mwoyo mundu aminiya na pata haki na kano yeketya na pata okoka. ");
INSERT INTO ndg_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Kuba liandiko likoya, “Kila jwaaminiya hapatulioni” ");
INSERT INTO ndg_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Mana ntupu tafauti kati ya Myahudi wala Myunani mana Nngwana yoyo yonga Nngwana wa bote, nintajiri wa bote bankemao. ");
INSERT INTO ndg_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Kubaa kila mundu ywa nkema lina lya Amwenye ataokolewa. ");
INSERT INTO ndg_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","kwa kitiwi benda weza kukema jwembe jwa bakotwike kumwaminiya? na kwakitiwi baweza amini kwa jwembe na banan-nyowa kwa nabalowa yowa buli bila kwa hubiri? ");
INSERT INTO ndg_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Na kwa kitiwi baweza hubiriwa, bila tumilwa kati mwaba andike jinsi gani mwanga ngolwike magulu gabalo ga batangaza likowe lya mema. ");
INSERT INTO ndg_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ila boti bana yowa lii Injili. Kwasababu Isaya abaite Nngwana nyaijwa yowine ujumbe witu?” ");
INSERT INTO ndg_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","kwa hiyo imani iicha bada yo yowa, na yowa kwa likowe lya Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Lakini nenda longela, je bana yowa kwa? Ena kwa hakika sana lelobe lyabe lipelike panja munema wete” ");
INSERT INTO ndg_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Zaid ya yoti, nenda longela “je Israel batangite kwa? na Musa andalongela nalowa kwa chokosa kwa yeya bwigu kwa bandu bababile taifa lyangetanganikwa. ");
INSERT INTO ndg_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Na Isaya ni jasiri sana enda longela napatikine na balo ba banipalike kwaa. ");
INSERT INTO ndg_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Lakini Israel koya “masoba goti na yopite maboko lango kwa babakotoka yogopa na kwa bandu agumu” ");
INSERT INTO ndg_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Bai nilongela, buli, Nnongo atikwa kana bandu boti? hata pasene mana nanenga na Muisreal wa lukolo lwa Ibrahimu wa kabila ya Benyamini. ");
INSERT INTO ndg_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nnongo hakanikwa bandu bake, batangite buka samani, je? mutangite kwa liandiko likoya buli usu jyo Eliya, jinsi mwampembelike Nnongo kuhusu Israel? ");
INSERT INTO ndg_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Nngwana babulige kinabii bako, na batibomwa madhabau gako. Nenga kiyango ngani igalile, na bembe bapala bwomi wango.” ");
INSERT INTO ndg_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Na lijibu lya nnongo likoya buli kayako?”nitebeka kwaajili yango bandu elfu saba babakotoka kunkilikitya Baali”. ");
INSERT INTO ndg_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nga ata nyoo, masiku yeno babile baba igalile sabato ya sawo wa uruma. ");
INSERT INTO ndg_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Lakini mana ibii kwa uruma, twenga le kupendelwa. kichongo chanyo uruma yabakai uruma. ");
INSERT INTO ndg_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Namani kae basi? likowe ambalo Israel abile kalipala aina kipata kwa alababa cahaulilwe ngabakipatike, na benge bayejilwe lubendo. ");
INSERT INTO ndg_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Nakati mwaiandikikilwe, Nnongo apei mwoyo wo pwindala, minyo lenga kene balole na masikio kene bayowe, mpaka lino. ");
INSERT INTO ndg_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Nembe Daudi enda baya, “wileke meza yabe ibe lupelele, ntego, pandu pokubala, na poleya kisase sabe. ");
INSERT INTO ndg_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Waleke minyo gembe gambe na lubendo linga kene babone ukapindeya migonga sayote” ");
INSERT INTO ndg_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Bai nenda longela, je/bakobile mpatulapai? kana ibenyo, badala yake, kwoshindwa kwabe wokovuwikite kwa amataifa, lenga bene kwa yeya bwingu. ");
INSERT INTO ndg_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Mana itei shindwa kwabe kasabe utajiri wa Dunia na mana hasara yabe utajili wa mataifa, wikiasi gani zaidi yaba ukamilifu kasabe. ");
INSERT INTO ndg_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Na saa yino nalonngela na mwenga bandu ba mataifa kwa sababu ni bii mtume wa mataifa ngenge nipuniya uduma yango. ");
INSERT INTO ndg_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Lakini mbala kwa yeya bwigu baba bile yega jino na nenga kwale tulowa kwalopwa baadhi yabe. ");
INSERT INTO ndg_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Mana kanilwa kwabe ni ridhiana na Dunia pokelelwa kwabe kwalowa isa bili ila bwomi buka mu kiwo? ");
INSERT INTO ndg_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Mana matunda ga kwanza akiba, ngamwebile kwa litongi lya bwembe mana ndandai akiba, ndambi nembe kazalika. ");
INSERT INTO ndg_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Lakini mana itei badhi ya ndambi itikatibwa kati wenga, lutambe mwitu lwa mzeituni, lwati pandikiswa nkati yake, na mana watishiriki pamope na bembe katika mundandai ya utajiri wa mzeituni, ");
INSERT INTO ndg_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Kana wilumbe ju ndambi. Ila mene kawilumba, wenga liwa winyangata ndandai, ila ndandai ikuyagate wenga. ");
INSERT INTO ndg_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Bai lwalongela, “ndambi yatitemelwa lenga nipate pandikizwa mukipeto”. ");
INSERT INTO ndg_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ayo kweli sababu yokotoka aminiya kwabe bati lemelwa, lakini wenga wayeni imara kwasababu ya imani yako. kana wiwase wamwene kwa aliya kunani sana ila uyogope. ");
INSERT INTO ndg_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Mana manaitei Nnongo mene ailekalii ndambi ya asili, huku urumiya lii na wenga. ");
INSERT INTO ndg_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Linga wete, mayenda gana noga na ukaliwa Nnongo kwo pande ngumo, ukale waisi kwa Ayahudi ngabembe batitumbuka. Ila kwo upande wenge, uluma ya Nnongo lwisa kunani yako, mene waigala mu wema wake. malayenge wenga na wenga alowa kukana kutalu. ");
INSERT INTO ndg_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Na kai, mana bayendelelwa kwa mwo kutoka aminiya kwambe. Balowa pandikizwa kai mana Nnongo abile nowo uwezo wopandikiza kai. ");
INSERT INTO ndg_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mana manaitei mwenga mwati temelwa panja kwa uliokwa zamani mzeituni wa mwitu, na chachungu cha zamani mwati pandikizwa mu mzaituni wabe bene. ");
INSERT INTO ndg_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Mana mwalongo nipendi kwa kene mutange, usikakana na siri yee. lenga wete kene mwabe na isima nkati ya wasa kwinu mwabene. Siri yeye ni kuwa nonopa kupitike Israel, mpaka kamilika kwa mataifa pwa kwagapala isa. ");
INSERT INTO ndg_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nanyo Israel bote baokoka, kati mweandikilwe, “buka Sayuni alowaisa jwa kutulopwa. Alowa kubuya ubaya buka kwa Yakobo. ");
INSERT INTO ndg_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Na ate alelya panga lilagano lyango pamope na bembe muda panalowa kwibuya zambi yabe”. ");
INSERT INTO ndg_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","kwo upade wenge husu injili, benda kasirika kwaajili yinu. Kwo upande wenge buka na kuchawa kwa Nnongo, batipendelwa kwa mwanza ya kibokulo. ");
INSERT INTO ndg_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kwa kuwa sawali ya kemelwa na Nnongo igalambuka kwako. ");
INSERT INTO ndg_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Kwa mana hapo zamani mwate kunkana nnongo, ila nambe yambe mujogoprte rehma sababu ya asi kwabe. ");
INSERT INTO ndg_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Kwa anda yoyo-yo, tubwe aba Ayahudi batiasi. Chakipitike kumbe buka na huruma ya muyaliwite mwenga bendo weza kai pokya rehema. ");
INSERT INTO ndg_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Mana Nnongo atabite bandu bote muasi, lenga awese kubahurumia bote. ");
INSERT INTO ndg_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Jinsi mwebile ngolo utajili na hekima na malipwa ga nnongo! Ichunguzika kwako ukumu yake, na ndela ya ichunguzika kwako! ");
INSERT INTO ndg_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Mana nyai lwaitangite liwazo lwa Nngwana? au nyai lwabile shauli wake? ");
INSERT INTO ndg_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Au nyai lwabijwa kwanza kupeya kilebe Nnongo, lenga alepelwe kai? ");
INSERT INTO ndg_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kwa mana buka kayake, nakwa ndela yake ya kasake, ilebe yoti ibile kasake ube utukufu wange yomoka. Amina. ");
INSERT INTO ndg_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Kwa nyo nenda kunoba, mwalongo, kwa huruma yake Nnongo, mwipiyi yega yinu ibe sadaka yebi ngoto, yepeletike, yaiyeketya Nnongo, Aye nga ibada yinu yene mana. ");
INSERT INTO ndg_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Wala kene mupwatise na muna ya lunia yii, ila mugalambuke kwopangilwa mwayambe niya jino. Mupange nyoo mupate tanga pulaika kwa Nnongo gaga bile mazuri, ga kupulaisa na gabi kamili. ");
INSERT INTO ndg_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Mana nendo koya. kwa sababu ya uruma ya anipeyilwe, panga kila mundu ambae abile nkati yinu apalikwa kwa wasa sana usu juu ya mwene kuliko mwapalikwa wasa. Ila apalikwa wasa kwa hekima, katu mwaibile Nnongo apei kala yumo kiasi pulani cha aminiya. ");
INSERT INTO ndg_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kwa kuwa twina iungo ya nannchima mu yega jimo, ila sio iungo yoti i na lyengo limo. ");
INSERT INTO ndg_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Nga nyonyo, twenga twotubi bingi twi mundu yumo nkati ya Kirisitu, na iungo kila simo na nyine. ");
INSERT INTO ndg_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Twii na makalama gana nchima kwa kati urumo mwa mupeyilwe mana itei kalama ya mundu ni unabii, na ipangilwe kwa kadili ya aminiya kwake. ");
INSERT INTO ndg_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Mene itei kalama ga mundu ga huduma na atumike. mana itei jwenge aina kalama ga pundisa bai apundise. ");
INSERT INTO ndg_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Mana itei mungu jwenge kalama gake faliji, bai afaliji, Mana itei kalama ga mundu piya, apange nyo kwa karimu, mana itei mundu jwenge kalama gake ongosa, na ayendeli kwa uangalifu. mana itei mundu jwenge bonekana na huruma na iyendeli kwa pulaika. ");
INSERT INTO ndg_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Penda kana kube na ubocho, muchukii ubou, mukamwe gagabi gananoga. ");
INSERT INTO ndg_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Husu pendana alongo, mupendane mwabene na mwabene husu isima, mwisimiane wene kwa wene. ");
INSERT INTO ndg_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Husu bidii, kene mulegeleke wamubile nawo husu roho mube na hamu husu Nngwana, mutumikie. ");
INSERT INTO ndg_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Mupalaike mu ujasili wa mubile nawo husu masoba gagaisa. Muba na lenda kwa matatiso ngino musinde loba. ");
INSERT INTO ndg_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Musiliki muga basikikwe baamini. Mupale ndela yanachima ya bonekana ukarimu. ");
INSERT INTO ndg_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Mwarobi baraka boti babatesa mwenga, mwabariki wala kene mwalaani. ");
INSERT INTO ndg_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Mupulai pamope na babapulaika, mulele pamope na babalela. ");
INSERT INTO ndg_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Mube na nia yimo mwenga kwa mwenga. kana muwase kwa kwipuna, mwayeketi bandu ba hali ya pae. Kene mube na hekima kwa mawaso yinu mwabene. ");
INSERT INTO ndg_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Kana mwanepe mundu ywoywote ubaya kwa ubaya. Mupange makowe gananoga paminyo ga bandu boti. ");
INSERT INTO ndg_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Mene ke wezekana, kati mwaibikilwe kayino mube na amani na bandu boti. ");
INSERT INTO ndg_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Wopendilwe, kamwilepi kisasi mwabene ila mwipeye nyongo ya Nnongo. mana itiandikilwa “kisasi chango, nenga nalowa lepa, alongei Nngwana”. ");
INSERT INTO ndg_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ila mmaya wako abi na njala, unise. Mana abi na nyota, mpei mache kwa mwanza mana apangite nyoo, ukalya makaa ga mwoto mu nde wake. ");
INSERT INTO ndg_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Kana ushindwe na ubaya, ila ubaya ushindwe kwa wema. ");
INSERT INTO ndg_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","kila nafsi ibe na utii kwa bene madalaka ga kunani, mana utupu utawala ila uboi kwa Nnongo. Nasilikali yebile aibekite Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Nga jwa penga selekali hajwo apenga amri ya Nnongo; na balo babapinga balowa pokya ukumu juu ya be bene. ");
INSERT INTO ndg_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","sababu atawala si botisa kwa babapanga gananoga-lii, ila babatenda mabaya. je utamaniya kotoka selekali/ upange gagabile mazuri na walowa lumbilwa kwa goo. ");
INSERT INTO ndg_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Nembe kumtumikia Nnongo, wenga kwa ajili ya wema, Ila mana wapanga bila likosa kwa sababu mtumwa wa Nnongo, kunepa kisasi cha ukali kunani ya jule jwa panga mabaya. ");
INSERT INTO ndg_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Nganyo ipalikwa utii, siyo tu kwa mwanja ukale, ila kai sabau ya dhamili. ");
INSERT INTO ndg_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Aye nembe go lipa kodi. Na bembe utawala ni batumilwe na Nnongo, na bembe benda yendelya panga likowe lee. ");
INSERT INTO ndg_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Munepe kila mundu jwa mdai: kodi jwa takilwa kodi, ushuru jwa pala usuru, kumnyogopa jwa palikwa yopelwe, heshima jwa palikwa heshimilwa. ");
INSERT INTO ndg_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Kana mdaiwe kilebe sosote sa na mundu, ila mpendane bene ni bene. kuba ywembe ate kumpenda jirani yake atekamilisha seliya. ");
INSERT INTO ndg_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Kwa kuwa wapanga kwa umalaya wabulagakwa wajibu kwa, watamaniya kwa, na mana kwi na amri tenye nembe, iyanga banike mumakowe ga, walowa kupenda jirani jwako wa mwene. ");
INSERT INTO ndg_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Upendo umega kwa jirani wa mundu kwa nyoo, upendo ngai kamilishe seliya. ");
INSERT INTO ndg_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","sababu ya yee, mutangite muda, kwamba tayari muda wa buka mulugono, mana wokovu witu ubi karibu sana ya watu ngolu patwa ami mwanzo. ");
INSERT INTO ndg_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Kilo kitiyendely a na mutwekati kwi karibu na tugabike pabwega atenda ga mulobendo, natuwale silaha ya papyeya. ");
INSERT INTO ndg_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","tuyende bila kosea, kati mubweya, kene kwa masikukuu ga madhambi no lobya. Na kana tuyende kumalaya na tamaniya yaikotoka keleboyelwa, na kwileka pitina na bwingu. ");
INSERT INTO ndg_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ila tuwa mwale Nngwana Yesu KIrisitu, na twileke nafsi kwa ajili ya yega, kwa tamaniya kwake. ");
INSERT INTO ndg_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Mumpoki jwembe jwabinele katika aminiya, bila piya ukumu husu tubwa kwake. ");
INSERT INTO ndg_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Mundu yumo atiaminiya juyolya chochoti, na jwenge jwa binnele alya mboga bai. ");
INSERT INTO ndg_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Mundu jwa alya kila kilebe kene wasalawe yulyu jwa kotoka lya kila kilebe. Na jwembe jwa lya lii kila kilebe kene amuhukumu jwe jwa lya kila kilebe mana Nnongo ayomwile kwipokya. ");
INSERT INTO ndg_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Wenga wa nyai, wenga wa hukumu mtumwa wa mtawala mundu jwenge? nnonge ya Nngwana wake panga yema au tumbuka. lakini alowa kuntukuya, mana Nngwana inda wesa kupanga ayeme. ");
INSERT INTO ndg_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Mundu yumo kuithamini lisiku limo kuliko yenge, jwenge kwithamini siku yoti sawasawa. Hebu kila mundu aishawishi muakili yake mwene. ");
INSERT INTO ndg_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Jwembe ywa kamwa lisoba, alikamwa kwandela ya awana. Na kwa yolo jwalya alya kwa sababu ya Nngwana. Na jwembe nembe piya sukuru kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Mana ntopo jwa tama kwa nafsi yake, na ntupu jwa waa kwajili yake mwene. ");
INSERT INTO ndg_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Mana itei twenda lama tulama kwa ajili ya Nngwana. Mana ibii Katu waa, tuwaa mwalo wa Amwenye. Mana ibii katuishi Ni ku'waa mali ya Amwenye. ");
INSERT INTO ndg_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kwasababu kwalikudi ale Kirisitu atiwa na alowa tama kae, linga abe Nngwana wa bote babawile babatama. ");
INSERT INTO ndg_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Ila wenga mwanja namani mwukumu Nnongo? utage twenga twabote twalowa yema Nnongo go? utage twenga twabote twalowa yema nnonge ya kitego cha ukumilwa cha Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Mana iandikiwe, kati mwanitama “galongula Nngwana “kachango nenga kila lingoti lya ngilikilya, na kila lulimilwa numba Nnongo”. ");
INSERT INTO ndg_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Tumbe kila yumo alowa piya hesabu yake mwene kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Kwa nyo kana tuyende lii kae ukumwana, ila badala yake tuamwe nyonyo. Ntupu jwa beka kikobala au tengo kwa nongo we. ");
INSERT INTO ndg_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ndangite na nitishawika kwa Nngwana Yesu, panga ntupo kilebe cha kibi kichapu ni kwa jwembe tu jwa wasa kila kilebe usapu kwa sababu kasake usapu. ");
INSERT INTO ndg_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Mana itei sababu ya chakulya nongo go alowa huzunika, utyanga lii kwopendana kanaumualabiye kwa chakulya sako mundu kwa ajili yake Kirisitu ati waa. ");
INSERT INTO ndg_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Hivyo kana mulusu yendo nginu gana nnoga gasababise bandu kwa tania. ");
INSERT INTO ndg_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","kwa sababu utawala wa Nnongo si kwa ajili ya chakulya na nywa, ila kwa ajili ya haki, amani, pulaika pulaika na Roho mpeletau. ");
INSERT INTO ndg_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Mana jumbe jwa mtumikiya Kirisitu kwa hali ye anyeketile Nnongo kwa bandu banyeketile. ");
INSERT INTO ndg_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Nga nyo bai, tubwate makowe ga Imani na makowe ga kusenga mundu na bembeke. ");
INSERT INTO ndg_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","kana wa alabiye lyengo lya Nnongo kwa mwanja chakulya. Ilebe yote kweli nnjap, ila mbaya kwa mundu yolo jwa lya na kupanga jwembe kwikobala. ");
INSERT INTO ndg_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Bola kotoka lya nyama, wala nywa wembe, wala chocho chalowa Nnongo wanga kubala. ");
INSERT INTO ndg_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","hiye imani malumu yabile nayo, ukati yako wa mwene na Nnongo. Utibalikilwa yolo jwa i ukumu mwene mu chelo cha kiyeketya. ");
INSERT INTO ndg_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Jwa bi na masaka ayomwile ukumilwa mwene kalya, sababu itokana kwa aminiya na sosote cha kikotwike aminiya ni sambi. ");
INSERT INTO ndg_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Tubwe twenga twabi na ngupu tupalikwe kuputwa udhaifi wa babile adhaifu, na tupali kwali kwipendekeza mwabene. ");
INSERT INTO ndg_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Kila jumo ampendi jirani jwake kwani likowe linanoga, kwania ya chenga. ");
INSERT INTO ndg_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kwani hata Kirisitu haipendi lii mwene. Badala yake, yabi kati yaiandikilwe, “matukano gabalo gamakutukine ganipatike nenga. ");
INSERT INTO ndg_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Kwa chochote cha andikilwe kutubakiya, kwo husu lyaa kwopetya pumulia na petya kupeya mwoyo na mwandiki na ujasili. ");
INSERT INTO ndg_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Tumbwe na Nnongo jwo pumulia na kuyeya mwoyo apiba na lenga kwa kila yumo lengana Yesu Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Awese pnga nyoo kwa nia jimo muwese kunemba kwa nkano ngumo Nnongo na Tate ba Nngwana witu Yesu Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Nga nyo mukalibishe kila jumo, kati Kirisitu mwapokile, kwa utukufu wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","mwanja namani Kirisitu apangilwe mtumwa wa likombe kwa lenge lya ukweli wa Nnongo. Apangite lenga awese thibitisha aidiyayabakilwe kwa akina tati, ");
INSERT INTO ndg_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Na kwa mataifa kunumba Nnongo kwa uruma yake kati mwabaandike, “nga nyo nipia sifa kayako kati ya mataifa na yembesifa kwa lina lyake”. ");
INSERT INTO ndg_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Kae yenda baya, “mupulaike mwenga mwa bandu mwa mataifa pamope na bandu bake” ");
INSERT INTO ndg_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Na kai, munnumbe Nngwana, mwenga mwa mataifa gote, leka bandu ba mataifa bati munumbe jwembe”. ");
INSERT INTO ndg_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Na Isaya alonga, kulowa ba kike cha Yese, na yumo jwa katuka tawala mataifa. Mataifa balowa kutumainiya jwembe”. ");
INSERT INTO ndg_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Tubwe Nnongo watu tumaini alweleye pula yoti na amani kwo aminiya, lenga muwese yongekelwa aminiya. Kwa ngupu ya Roho mpeletau. ");
INSERT INTO ndg_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ata nenga na jwembe, muni utike namwe, mwalongo bango, nitishawisika panga, mwenga mwabenemmejazwa na wema, mejazwa na mataifa goti. Mutinishawishi panga, mwenga mwenda wesa ata imizana kila jumo na nnyine. ");
INSERT INTO ndg_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ila niandika kwo ujasili sana kachinu husu ikowe fulani lenga kunkombokeye kae, sababu ya kipawa chanipejilwe na Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Kipawa ache chabile lenga niwese bana tumwa wa Yesu Kirisitu jwatumilwe kwa amataifa, kwipiya kati kuhani wa injili ya Nnongo. Mbele wesa panga nyo lenga kwipiya kwango kwa mataifa kube kuyeketilwe, ibekilwe bwega na Nnongo kwa ndela ya Roho mpeletau. ");
INSERT INTO ndg_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Hivi pura yango ibi na Kirisitu Yesu na katika makowe ga Nnongo. ");
INSERT INTO ndg_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Kwani gwesa kwapaya longela lyolyoti ila kwa Kirisitu ati kamilisha petya kasangu tii kwa mataifa. Aga makowe gatimile. ");
INSERT INTO ndg_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Kwa makowe na panga, kwa ngupu ya dalili na maajabu, na kwa ngupu ya Roho mpeletau. Aye yabile lenga buka YErusalemu, ndindikiya kutalu kati mwalibile niwese kwiputolya panja kwa timiya injili ya Kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Kwa ndela yee, lengo lyangu libile kwitangaza injili, lakini sio patanganikwe Kirisitu atanganikwe kwa lina, lenga wete kana ngwese senga singiwa mundu jwenge. ");
INSERT INTO ndg_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Kati mwa ba andike kwa jwembe “Jwembe ntupu abali yake aichile balowa kumona na lalu babakotweke kumona, na balo baba kotwike kunyowa balowa kutanga. ");
INSERT INTO ndg_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Kwa nyo nabile kai nitizuiliwa mala yananchima icha kachinu. ");
INSERT INTO ndg_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Lakini leno, ntupu kai semu yeyote mumikoa, nanende tamaniya kwa iaka yana nchima icha kajino. ");
INSERT INTO ndg_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","hivo mara goti mana nijei Hispania, ndegemea kumona mana nipetile, na wesa pelekelwa ndela yango na mwenga, bada ya pulaikya shiriki na mwe kwa wakati. ");
INSERT INTO ndg_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Lakini niyei Yerusalem kwa udumia aminia. ");
INSERT INTO ndg_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","mana yati kwapendeza bandu makedonia na akaya panga nchango malum kwa masikini nkati yake bahamini ba Yerusalem. ");
INSERT INTO ndg_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ayo yabile kwa penda kwabe, na kweli babile wadeni babe. Mana mana itei mataifa bati shiriki makowe gabe ga imani, benda longelwa na bembe nembe kwa yangatia cha bapongokiwe kwa ilebe. ");
INSERT INTO ndg_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Nga nyo muda wanikamilise haye noba. kila kilibe litundale kachabe, nenga nalowayenda mundela na mwenga na nenga Hispania. ");
INSERT INTO ndg_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ndangite panga wakati wanaicha kachinu naicha kwo kamilika na barikilwa na kirisitu. ");
INSERT INTO ndg_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Tubwe nenda kunnoba, mwalongo mwa bwana witu Yesu Kirisitu, nakwopenda wa Roho, mushiriki pamope na nenga mulubya kwinu kwa Nnongokwasababu yango. ");
INSERT INTO ndg_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Mulobe na'nee nipate lopolwa buka kasabe baba kani yeketya Yudea, na uduma yango akwo Yerusalem iwese pokolelwa na baba aminile. ");
INSERT INTO ndg_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Mulobe panga niche kachinu kwo pulaika kwo petya mapenzi ga Nnongo, na niwese ba pamope na mwee, pata mpomolya. ");
INSERT INTO ndg_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Na nnongo wa amani abe pamope na mwenga mwabote. Amina. ");
INSERT INTO ndg_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Nine katachinu fiba mnombo wito na tumishi wa kanisa lyabilekenkrea, ");
INSERT INTO ndg_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","lenga wete mwaweza kupokya nakati gwana mupange nyo mu kicho cha dhamani cha baba-aminite na mayeme pamote najwembe kwa likowe lyolyoti lyabalipala, maana jwembe mwene abi mwadumu wa bamachima na kwa ajili yango na mwene. ");
INSERT INTO ndg_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Salamu yake Priska na Akila bapanga lyengo pamote na nenga nti ya Kristo Yesu. ");
INSERT INTO ndg_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Ago kwa maisha gango batigaharisha maisa gabebene. Nipiya sukulani kabase, nanengabaikwa, ilana Makanisa gote ga-amataifa. ");
INSERT INTO ndg_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Mulisalimu kanisa lyalibile kachino, musalimie Epanieto npendwa wango, jwembe mwele wa Kristo akwo Asia. ");
INSERT INTO ndg_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Musalimu Mariamu jwapangite lyengo kwa Kanisa kwa ajili jino. ");
INSERT INTO ndg_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Musalimie Androniko na Yunia, alongobango na-atabilwa twaboti na nenga. Wa muhimu pamope na mitume, ngabo nabembe batilongalya kutanga Kristo kabla yangone. ");
INSERT INTO ndg_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Musalimie Ampliato, jwanipendile nkati ya gwana. ");
INSERT INTO ndg_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Musalimie Urbano, mpanga kasi nyango nkiya Kristo na Stakis npendwa wango. ");
INSERT INTO ndg_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Musalimu Apele, jwa yuketilwe katika Kristo, Mwasalimu bote ba-babile mu nyumba ya Aristobulo. ");
INSERT INTO ndg_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Msalimu Heroditoni, nongo wango, muwasalie bote ba-babile mu nyumba ya Narkiso, baba-bile mu nyumba ya Gwana. ");
INSERT INTO ndg_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Musalimie Trifaina na Trifosa, baba-panga lyungo kwo kasana kwa Gwana. Muwasalimu ");
INSERT INTO ndg_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Muwasalimu Persisi jwani npendile, nembe apangite lyengo sana kwa Gwana. Muwasalimie Rufo, jwachaulilwe kati Gubwana na maa-bakena bango. ");
INSERT INTO ndg_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Muwasalimu Asinkrito, Frego, Herme, Paroba, Herma na alongobote baba-bile pamope. ");
INSERT INTO ndg_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Munisalimie Filologo na Yulia, Nerea na lalabake, na OLipa, na bamini boti baba-bile pamope, ");
INSERT INTO ndg_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Munisalimie kilayumo kwa busu takatifu. Makanisa gote katika Kristo ngunda kusalimu. ");
INSERT INTO ndg_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Tubwe nendakunoba, Mwalongo, Mukufikilie ku-usu ya-bo-baba-sababisa N-gawanyiko na ipingamizi. Bagunda kuchongu na mapundiso na gamupundisilwe, Mwagalambuke mwabuke akwo kwabe. ");
INSERT INTO ndg_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Mana bandu katibo-batumikia kwa Kristo Gwana, ila matumbo gabe bene. Kwo longula kwabe terebu pongesana kwa uboso bekonga myoyo ya baba-bile kwa na atia. ");
INSERT INTO ndg_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Kwa Liano watiikwinu mumwikya kila jumo. Kwanyo, nipulaike mwanjamwe, ila nipala mwemube na busala mubehali inanoga, nakotokabana halia nnongiya ubaya. ");
INSERT INTO ndg_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Nnongo wa amani achelewa kwa kumwangamiza chula pai ua lwayo lwinu. Uruma ya Gwana witu Yesu Kristo ibe-pamoja na mwenga. ");
INSERT INTO ndg_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timotheo, mpanga lyengo pamope na nenga, enda kusalimu, na Lukio, Yosini na Sospeter, alongabango. ");
INSERT INTO ndg_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Nenga, Terto, wanuandika ujumbe go nundakusalimu kwa Linalya Gwana. ");
INSERT INTO ndg_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Goya, jwa -nitunjike na kwa likanisa lyote lyenda kusalimu, Erasto, mbeka akiba wa mji, enda kwa salimu, Pamopena kwarto jwai nongo. ");
INSERT INTO ndg_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","(Uruma ya Gwana Yesu Kristo itame namwe. Amina ");
INSERT INTO ndg_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Sayino kwake jwembe jwebinauwezo kupanga muyeme na injili na mapundisho ga Yesu Kristo tigana na funulijwa kwa sili ya yaiji liwe kwa wakati wamachima. ");
INSERT INTO ndg_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Kwo kwi-ti-imani pamope na mataifa ngote. ");
INSERT INTO ndg_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Kwa Nnongo kiyake mwewe hekima, pulya Yesu Kristo, kubena lumbilwa kwangaliyo moka. Amina ");
INSERT INTO ndg_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Paulo ywakemilwe ni Kristo pangika Mtume kwa mapenzi ga Nnongo, ni Sosthene nnuna witu. ");
INSERT INTO ndg_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Kwa likanisa lya Nnongo lyalibile Korintho, kwa balo ambabo babekilwe wakfu mu Yesu Kristo, babakemilwe panga bandu atakatifu twaandikya kae balo boti babakema lina lya Ngwana witu Yesu Kristo mahali palo, Ngwana wabe ni witu. ");
INSERT INTO ndg_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Neema na amani ibe kwinu buka kwa Nnongo tate bitu ni Ngwana witu Yesu Kristo. ");
INSERT INTO ndg_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Masoba gote nimsukuru Nnongo wango kwa ajili yinu, kwa sababu ya neema ya Nnongo ywabile awapeile Yesu Kristo. ");
INSERT INTO ndg_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Abapangite kuwa matajiri mu'kila ndela, katika longela pamope maarifa gake. ");
INSERT INTO ndg_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Abapangite matajiri, kati ushuhuda kuhusu Kristo wautithibitisha kuwa kweli nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Kwa eyo ipungwa kwaa karama ya kiroho, kati samubile na kilulu so kuulinda ufunuo wa Ngwana witu Yesu Kristo. ");
INSERT INTO ndg_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Alowa kumwimarisha mwenga mpaka mwisho, ili kana mukaumilwe lisoba lya Ngwana witu Yesu Kristo. ");
INSERT INTO ndg_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Nnongo ni mwaminifu ywabile abakemile mwenga mu'ushirika wa mwana wake, Yesu Kristo Ngwana witu. ");
INSERT INTO ndg_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Nambeambe niasihi mwainja ni numbwango, pitya lina lya Ngwana witu Yesu Kristo, panga mwabote muyikityange, ni panga kana kube ni banganika nkati yinu. Niasihi muungane pamope mu'nia jimo. ");
INSERT INTO ndg_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Mana bandu ba nyumba ya Kloe batumakiye kuwa kubile ni banganika nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Nibile na mana yee: Kila yumo abaya “nenga na ywaa Paulo”, au “nenga ni ywaa Apolo,” au nenga nI ba Kefa” au “nenga ni wa Kristo.” ");
INSERT INTO ndg_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Je! Kristo atebanganika? Je Paulo atisulubilwa kwaajili yinu? Je! mwatibatizwa kwa lina lya Paulo? ");
INSERT INTO ndg_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Nenda kumshukuru Nnongo kuwa nimbatiliza kwaa yeyete, ila Krispo ni Gayo. ");
INSERT INTO ndg_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Yee yabile panga ntopo ywoywoti aweza baya mwabatizwa kwa lina lyango. ");
INSERT INTO ndg_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Pia natekuabatiza ba nyumba ya Sephania. Zaidi ya palo, nitangite kwaa kati nambatiza mundu ywenge yeyote). ");
INSERT INTO ndg_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kwa kuwa, Kristo antumile kwaa batiza ila ubili injili. Antumile longela kwa maneno ga ekima ya kimundu, ili panga ngupu ya msalaba wa Kristo kana ubuke. ");
INSERT INTO ndg_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kwa kuwa ujumbe wa msalaba ni upuuzi kwa balo batiwaa. Lakini kwa balo ambabo Nnongo atikwalopwa, ni ngupu ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Kwa kuwa iandikilwe, “Nalowa kuiharibu hekima ya ywabile ni busara. Nalowa kuuharibu ufahamu wa babile ni malango.” ");
INSERT INTO ndg_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Abile kwako mundu ywabile ni busara? ywabile kwako ywabile ni elimu? ywabile kwako ywabaya nga mshawishi wa dunia yee? Je Nnongo aigalambwile kwaa hekima ya dunia yee no pangika ulalo? ");
INSERT INTO ndg_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Buka dunia ipangika mu'hekima yake intangite kwaa Nnongo, impendeza kwaa Nnongo mu'ulalo wabe wa hubiri ili kubalopwa balo baaminiya. ");
INSERT INTO ndg_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Kwa Ayahudi kulokiya ishara ya miujiza ni kwa Ayunani upala hekima. ");
INSERT INTO ndg_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Lakini tumuhubiri Kristo ywaatisulubilwa, ywabile kikwazo kwa Ayahudi na nga ulalo kwa Ayunani. ");
INSERT INTO ndg_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Lakini kwa balo babakemile ni Nnongo, Ayahudi ni Ayunani, twamuhubiri Kristo kati ngupu ni hekima ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Kwa kuwa ulalo wa Nnongo wabile ni hekima kuliko ya bandu, ni udhaifu wa Nnongo wabile ni ngupu kuliko ya bandu. ");
INSERT INTO ndg_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Lola wito wa Nnongo nnani yinu, ainja ni nnumbwa ngo. Ni baingi kwaa nkati yinu mwabile ni hekima mu'viwango vya bandu. Ni baingi kwa nkati yinu mwabile ni ngupu. baingi kwaa nkati yinu mubelekwi mu ukolo. ");
INSERT INTO ndg_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Lakini Nnongo asawile ile ya kilalo ya dunia ili kwiaibisha yabile ni hekima. Nnongo asawile sa'kinyatike mu'dunia kukiabisha sa kibile ni ngupu. ");
INSERT INTO ndg_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Nnongo asawile chelo cha hali ya pae ni chabile chakisalaulilwe mu'dunia. Asawile ata ilebe ambayo yabalangilwe kwaa pangika ilebe, kwa kuipanga ilebe kwaa yabile ni yhamani. ");
INSERT INTO ndg_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Apangite nyoo ili kana abe yeyote ywabile ni sababu ya kuipunia nnonge yake. ");
INSERT INTO ndg_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Kwa sababu ya chelo chaakipangite Nnongo, nambeambe mubile nkati ya Kristo Yesu, ywabile apangike hekima kwa ajili yinu kuoma kwa Nnongo. Abile nga haki yitu, utakatifu ni ukombozi. ");
INSERT INTO ndg_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Kati matokeo, kati liandiko lyatibaya, “Ywaisipu, aisipu mu'Nngwana.” ");
INSERT INTO ndg_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Paniisile kwinu ainja ni akinalumbwango, niisile kwaa ni maneno ga usawishi ni hekima kati mwanilongela kweli yaiilwe kuhusu Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Niiamuile nitange kwaa sosote panibile nkati yinu ila Yesu Kristo, ni ywembe ywasulubilwe. ");
INSERT INTO ndg_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Nibile ni mwenga mu'udhaifu, ni mu'hofu, ni mu'lendema muno. ");
INSERT INTO ndg_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ni ujumbe wango nolongela kwango kwabile kwaa mu'longela ushawishi ni hekima. Badala yake, yabile mu'kumdhihirisha Roho ni ya ngupu, ");
INSERT INTO ndg_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ili panga imani yinu ibe kwaa mu'hekima ya bandu, ila mu'ngupu ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Nambeambe twendalongela hekima nkati ya bandu apindo, lakini hekima kwaa ya dunia yee, au ya utawala wa muda woo, ambao wapeta. ");
INSERT INTO ndg_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Badala yake, twalongela hekima ya Nnongo mu'ukweli wabonekana kwaa, hekima ibonekana kwaa ambayo Nnongo aisawile kabla ya muda wa utukufu witu. ");
INSERT INTO ndg_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ntopo ywoywote ywa atawala ba muda woo ywatangite hekima yee, Kati waitangite mu'muda golwa, kana bansulubishe Ngwana wa utukufu. ");
INSERT INTO ndg_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Lakini kati yaiandikilwe, “Makowe yabile ntopo minyo yagabona, ntopo likutu lyagayowa, malango gawasa kwaa, makowe ambayo Nnongo atikuyaandaa kwa ajili ya balo bampendile ywembe. ");
INSERT INTO ndg_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Aga nga makowe amabayo Nnongo atigaumwa petya kwa Roho, kwa mana Roho uchunguza kila kilebe, hata makowe gabile nkati ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Kwa kuwa nyai ywatangite malango ga mundu, ila Roho ya mundu nkati yake? Nga nyo kae, ntopo ywatangite makowe ga nkati ya Nnongo, ila Roho wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Lakini tupoki kwaa roho ya dunia, lakini roho ywabilke aboka kwa Nnongo, ili tuwese tanga kwa uhuru wa makowe aga tupeilwe ni Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Twabaya makowe aga kwa maneno, ambayo Roho utupundisha. Roho ugatafsiri maneno ga kiroho kwa hekima ya kiroho. ");
INSERT INTO ndg_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Mundu ywabile kwaa wa roho apokii kwaa makowe ambayo ni ya Roho wa Nnongo, kwa kuwa ago nga upuuzi kwake. Aweza kwaa kugatanga kwa sababu yatangika kwa roho. ");
INSERT INTO ndg_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Kwa yolo wa kiroho huhukumu makowe yote. Lakini huhukumilwa ni wenge. ");
INSERT INTO ndg_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“Ywa nyai ywaweza kuyatanga malongo ga Ngwana, ambae ywaweza kumpundisha ywembe?” Lakini twabile ni malango ga Kristo ");
INSERT INTO ndg_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","NI nenga, ainja ni alombo bango, nibayite kwaa ninenga kati bandu bakiroho, lakini kati ni bandu ba yega. Katu ni bana bachunu mu'Kristo. ");
INSERT INTO ndg_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Nibanyweishe maziwa na nyama kwaa, ka mana mubile kwaa tayari kwa lyaa nyama. Na hata nambeambe mubile kwaa tayari. ");
INSERT INTO ndg_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Kwa kuwa mwenga bado ba yega. Kwa kuwa bwiu ni majiuno yatibinekana nkati yinu. Je mutama kwaa lingana na yega, ni je, mutyanga kwaa kati kawaida ya bandu? ");
INSERT INTO ndg_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Kwa mana yumo abaya, “Namkengama Paulo” Ywenge ubaya, “Nampala Apolo,” mutama kwaa kati bandu? ");
INSERT INTO ndg_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Apolo ywa nyai? na Paulo ywa nyai? Amanda ba yolo ywamwaminiye, kwa kila ambaye Ngwana ampeile lijukumu. ");
INSERT INTO ndg_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Nenga nipandike, Apolo abeka mase, lakini Nnongo kaikuza. ");
INSERT INTO ndg_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Kwa eyo, ywabile kwaa panda wala ywabeka mase abile ni chochote. Lakini Nnongo ywaikuzile. ");
INSERT INTO ndg_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Nambeambe ywapandae ni ywabeka mase bote ni sawa, ni kila yumo alowa pata ujira wake lingana na kazi yake. ");
INSERT INTO ndg_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Kwa kuwa twenga twa atendaji ba Nnongo, mwenga mwa bustani ya Nnongo, nyumba ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Bokana na neema ya Nnongo yanipeilwe kati mjenzi nkolo, naubekite msingi, ni ywenge ywachengite nnani yake. Lakini mundu abe makini jinsi ywachenga nnani yake. ");
INSERT INTO ndg_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","kwa kuwa ntopo ywenge ywaweza chenga msingi wenge zaidi ya uchengwite, ambao ni Yesu. ");
INSERT INTO ndg_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Nambeambe, kati yumo winu achenga nnani yake kwa dhahabu, mbanje ya thamani, nkongo, manyei, au manyei, ");
INSERT INTO ndg_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Kazi yake iyowanike, kwa bweya wa mutwekati walowa dhihirika. Kwa kuwa yalowa dhihirika ni mwoto. Mwoto walowa jaribu ubora wa kazi ya kila yumo apangite. ");
INSERT INTO ndg_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Kati chochote mundu ywachengite chalowa tama, ywembe alowa pata zawadi. ");
INSERT INTO ndg_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Lakini kati kazi ya mundu yatitinia kwa mwoto, alowa pata hasara. Lakini ywembe mwene alowa lopolelwa, kati yakuepuka ni mwoto. ");
INSERT INTO ndg_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Mutangite kwaa kuwa mwenga ni lihekalu lya Nnongo ni kwamba Roho wa Nnongo atama nkati yinu? ");
INSERT INTO ndg_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Kati mundu ywaliharibu lihekalu lya Nnongo, Nnongo alowa kumwaribu mundu yoo. Kwa mana lihekalu lya Nnongo ni litakatifu, nga nyoo ni mwenga. ");
INSERT INTO ndg_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Mundu alongele ubocho kwaa mwene, kati yeyote nkati mwinu anadhani abile ni hekima mu'nyakati zino, ube kati “mlalo” nga apalikwa kuwa na hekima. ");
INSERT INTO ndg_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Kwa kuwa hekima ya dunia yee ni ulalo nnonge ya Nnongo, kwa kuwa iandikilwe, “Hubanasa babile ni hekima kwa hila zabe.” ");
INSERT INTO ndg_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ni kae “Ngwana atangite malango ga babile ni busara ni ubatili.” ");
INSERT INTO ndg_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Nga nyo mundu aipunie kwaa bandu! kwa mana ilebe yote ni yinu. ");
INSERT INTO ndg_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Kati ni Paulo, au Apolo, au Kefa, au dunia, au maisha, au kiwo, au ilebe yaibile, au yalowa tama. Yote ni yinu, ");
INSERT INTO ndg_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ni mwenga ni ba Kristo na Kristo ni ba Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Ayee nga mundu ywatubalanga twenga, kati amanda ba Kristo ni mawakili ba siri ya kweli ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Katika lee, chakipalikwa kwa uwakili ni kwamba bawe ba kutumainiya. ");
INSERT INTO ndg_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Lakini kwango nenga ni kilebe kichunu muno kuwa nendahukumilwa ni mwenga au hukumu ya bandu, kwa kuwa naihukumu kwaa nenga na mwene. ");
INSERT INTO ndg_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Naihukumu kwaa nenga na mwene, ayee ibile kwaa na mana kuwa nenga na mwene haki. Ila Ngwana nga anihukumuye. ");
INSERT INTO ndg_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Kwa eyo, kana muipale hukumu nnani ya lolote kabla ya muda, kabla ya kuisa Ngwana. Alowa kubaleta mu'bweya makowe gaabile mu'libendo ni kuipunua kusudi ya mwoyo. Nga kila yumo apokya sifa yake kwa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Nambeambe, ainja ni alombo bango, nenga namwene na Apolo niitumi kanuni yee kwa ajili yinu, ili kuoma kwitu mwaweza kuipunza maana ya baya, “Uyende kwaa zaidi ya yaiandikilwe.” Ayee nga kuwa ntopo yumo winu ywaipunia nnani ya ywenge. ");
INSERT INTO ndg_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Maana ywa nyai ywabona tofauti nkati yinu ni ywenge. Ni namani chaubile nacho chaukipokya bure? Kati uyomwa pokya bure kwa namani mwaipunya kati mwapanga kwaa nyoo? ");
INSERT INTO ndg_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Tayari mubile ni yoti mpala! Tayari mwabile ni utajiri! Mtumbwa tawala ni kwamba mwamiliki zaidi yitu twenga! Kweli, napala umiliki mwema ili kwamba tumiliki pamope ni mwenga. ");
INSERT INTO ndg_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Kwa eyo nawasa Nnongo atubekite twenga twa mitume kati kutubonesha wa mwisho mu'mistari ya maandamano ni kati bandu bahukumilwe ku'waa. Twabile kati tamasha kwa ulimwengu, kwa malaika ni kwa anadamu. ");
INSERT INTO ndg_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Twenga twaalalo kwa ajili ya Kristo, lakini mwenga mwa mubile ni hekima mu'Kristo. Tu anyonge, lakini mwenga mwabile ni ngupu. Mwaheshimilwa, lakini twenga twadharauliwa. ");
INSERT INTO ndg_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Hata saa ino twabile ni njala ni kiu, tubile kwaa ni ngobo, tubile ni mapigo, ni kae ntopo makazi. ");
INSERT INTO ndg_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Twapanga kazi kwa bidii, kwa maboko yitu wene. Mana tudharaulilwe, twabariki. Muda tubile ni mateso, tugapumiliea. ");
INSERT INTO ndg_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Mana tutukanganwe, tugarudishe kwa upole. Tubile, ni bado twabalangilwa kuwa kati tukanilwa ni dunia ni uchapu kwa makowe gote. ");
INSERT INTO ndg_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Niandika kwaa makowe aga kuaaibisha mwenga, lakini kuarudi mwenga kati bana bango waniwapendile. ");
INSERT INTO ndg_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Hata kati mwabile ni baalimu komi elfu mu'Kristo mwabile kwaa ni tate baingi. Kwa kuwa nabile tate yinu mu'Yesu Kristo petya injili. ");
INSERT INTO ndg_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Naasihi munigeye nenga. ");
INSERT INTO ndg_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Ayee nga sababu nimtumile kwinu Timotheo, mpendwa wango ni mwana mwaminifu mu'Ngwana. Alowa kuakombokya ndela yango mu'Kristo, kati yaniapundisha kila mahali na kila likanisa. ");
INSERT INTO ndg_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Nambeambe baadhi yinu kabajisifu, batenda kati nalowa isa kwaa kwinu. ");
INSERT INTO ndg_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Lakini nendaisa kwinu kitambo, kati Ngwana atipenda. Nga nalowa kuitanga maneno yabe kwaa balo bajisifu, lakini nalowa kuibona ngupu yabe. ");
INSERT INTO ndg_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Kwa kuwa upwalume wa Nnongo ubile kwaa mu'maneno ila katika ngupu. ");
INSERT INTO ndg_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","mupala namani? Niise kwinu ni fimbo au kwa upendo ni katika roho ya upole? ");
INSERT INTO ndg_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Tuyowine taarifa kuwa kwabile ni umalaya nkati yinu, aina ya umalaya ambayo ibile kwaa hata nkati ya bandu wa Mataifa. Tubile ni taarifa kuwa yumo winu gonja ni nyumbo wa tate bake. ");
INSERT INTO ndg_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Mwenga mwaisifu! Badala ya huzunika? Yolo ywapangite nyoo apalikwa kuondolewa nkati yinu. ");
INSERT INTO ndg_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Ingawa nabile pamope ni mwenga kwa yega lakini nibile ni mwenga kiroho, niyomwile kumhukumu ywembe ywapangite nyoo, kati yaibile. ");
INSERT INTO ndg_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Mana mukengamite pamope kati lina lya Ngwana witu Yesu, ni roho yango ibile palyo kati kwa ngupu ya Ngwana witu Yesu, niyomwile kunhukumu mundu yoo. ");
INSERT INTO ndg_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Niyomwile kunkabidhi mundu yolo kwa nchela ili yega yake iharibiwe, ili roho yake iweze kulopolelwa mu'lisoba lya Ngwana. ");
INSERT INTO ndg_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Maipuno yinu nga ilebe inoite kwaa. Mutangite kwaa chachu njene uharibu donge zima? ");
INSERT INTO ndg_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Muisapishe mwenga mwene chachu ya kunchogo, ili mube donge lyayambe, ili mube nkate wauchakachuliwa kwaa. Kwa kuwa, Kristo, Mwana Ngondolo witu wa pasaka ayomwi kuchinja. ");
INSERT INTO ndg_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Kwa eyo tusherehekee karamu ni achachu kwaa ya kinchogo, chachu ya tabia mbaya ni abou. Badala yake, tushehekee ni nkate ubekelwa kwaa chachu ba unyenyekevu ni kweli. ");
INSERT INTO ndg_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Niiandikile mu'barua yango kuwa kana muichangabane ni amalaya. ");
INSERT INTO ndg_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Nibile kwaa ni maana ya bamalaya ba dunia yee, au na babile ni tamaa au anyang'anyi au abudia sanamu kwa tama kutalu ni bembe, bai ipalikwa mtoke mudunia. ");
INSERT INTO ndg_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Lakini nambeambe naandikia kana muyangabane na yoyote ywakemelwa muinja ni alombo mu'Kristo, lakini atama katika umalaya ywabile ni mwene kutamani, au nnyang'anyi, au mwaabudu sanamu, au atukangana au alevi. Wala mulye kwaa ni ywembe mundu wa namna yee. ");
INSERT INTO ndg_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Kwa eyo naiuluya kinamani kubahukumu balio mkati ya likanisa? ");
INSERT INTO ndg_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Lakini Nnongo enda hukumu babile panja.”Umboywe mundu mwovu nkati yinu” ");
INSERT INTO ndg_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Yumo winu mana abile ni tatizo na ywenge, ni ywenge atithubutu kuyenda ku'mahakama ya babile kwa na haki kuliko nnongi ya baaminiya? ");
INSERT INTO ndg_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Mutangite kwaa kuwa baumini walowa kuuhukumu ulimwengu? Ni kati mwenga mwalowa hukumu ulimwengu. muweza kwaa amuliya makowe gabile kwaa ni muhimu? ");
INSERT INTO ndg_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Mutangite kwaa kuwa twalowa kubahukumu malaika? Kwa kiasi gani zaidi, twaweza amua makowe ya maisha aga? ");
INSERT INTO ndg_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Kati twaweza hukumu makowe ga maisha aga, kwa mwanja namani mwathubutu peleka mashitaka nnongi ya bayemile kwaa mulikanisa? ");
INSERT INTO ndg_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Nilongela aga kwa aibu yinu. Ntopo ywabile ni busara nkati yinu wa kutosha beka makowe sawa kati ya alongo ni alongo? ");
INSERT INTO ndg_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Lakini kati ya ibile nambeambe, mwaminiya yumo uyenda mu'mahakama dhidi ya muumini ywenge, ni mashitaka ago ubekwa nnongi ya hakimu ywange aminiya! ");
INSERT INTO ndg_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Ukweli ni kuwa kubile ni matatizo nkati ya Bakristo yatetike usumbufu tayari kwinu. Kwa mwanja namani muteseke kwaa ni ganoite kwaa? Kwa mwanja muyeketya ubocho? ");
INSERT INTO ndg_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Lakini mwapangite ubou ni kuabocholia wenge, ni habo nga aija ni alombo binu! ");
INSERT INTO ndg_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Mutangite kwaa kuwa babile kwaa ni haki balowa kuurithi kwaa upwalume wa Nnongo? Kana muaminiye ubocho. Baasherati, baabudu sanamu, amalaya, afiraji, alawiti, ");
INSERT INTO ndg_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","mwii, bachoyo, balevi, anyang'anyi, batukangana-ntopo kati yabe ywalowa kuurithi upwalume wa Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Ni bembe babile baadhi yibe ni mwenga. Lakini mmoyomwike takasilwa tengwa kwa Nnongo lakini mpangilwe haki nnongi ya Nnongo pitya lina lya Ngwana Yesu Kristo na kwa Roho wa Nnongo witu. ");
INSERT INTO ndg_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","“Ilebe yoti ni halali kwango, “lakini kila kilebe kwaa chabile ni faida.”Ilebe yoti ni halali kwango, “lakini nalowa tawaliwa kwaa ni chimo nkati yake. ");
INSERT INTO ndg_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","“Chakulya ni kwa ajili ya ndumbo, ni ndumbo ni kwa ajili ya chakulya,” lakini Nnongo alowa kuvipotwa vyoti. Yega uumbilwe kwaa kwa ajili ya ukahaba, badala yake, yega ni kwa ajili ya Ngwana, ni Ngwana alowa uhudumia yega. ");
INSERT INTO ndg_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Nnongo atemfufua Ngwana ni twenga kae alowa kutufufua kwa ngupu yake. ");
INSERT INTO ndg_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Mutangite kwaa kuwa yega yabile ni muunganiko ni Kristo? Mwaweza kuitola iungo ya Kristo ni kuyenda kuiunganisha ni kahaba? Iwezekana kwaa! ");
INSERT INTO ndg_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Mutangite kwaa kuwa ywaungana ni kahaba abile yega yimo ni ywembe? Kati andiko lya libaya, “Abele balowa kuwa yega yimo.” ");
INSERT INTO ndg_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Lakini ywa ungana ni Ngwana alowa pangika roho yimo pamope ni ywembe.” ");
INSERT INTO ndg_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Muutile umalaya! Kila sambi ya aipanga mundu ibile panja na yega yake. Lakini umalaya, mundu upanga sambi dhidi ya yega yake mwene. ");
INSERT INTO ndg_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Mutangite kwaa kuwa yega yinu ni lihekalu lya Roho Mtakatifu. Ywatama nkati yinu, yolo ywamupeilwe kuoma kwa Nnongo? mutangite kwaa kuwa mwenga kwaa mwabene? ");
INSERT INTO ndg_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Kwa mupemewa kwa thamani. Kwa eyo muntukuze Nnongo kwa yega yinu. ");
INSERT INTO ndg_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Kuhusu makowe aga mwamuniandikiye: Kwabile ni muda ambapo unoite nnalome kana agonje ni nyumbo wake. ");
INSERT INTO ndg_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Lakini kwa sababu ya majaribu ganyansima ga umalaya kila nnalome abe ni nyumbowe, ni kila mwanamke abe ni nchengowe. ");
INSERT INTO ndg_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Nchebgo apalikwa kumpeya nnyumbo haki yake ya ndoa, ni nyonyonyo nyumbo kwa nchengowe. ");
INSERT INTO ndg_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Nyumbo kwaa abile na mamlaka nnani ya yega yake, ni nchengo. Na nyonyonyo, nchengo ni ywembe abile kwaa ni mamlaka nnani ya yega yake, ila nnyumbo abile nayo. ");
INSERT INTO ndg_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Kana munyimane kwaa mana mugonjike mpamo, ila mana muyeketyana kwa muda pulani. Mupange nyoo ili kupata muda wa kuloba. Boka po mwaweza rudiana kae pamope, ili nchela kana abajaribu kwa kukosa kiasi. ");
INSERT INTO ndg_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Lakini nilongela makowe aga kwa hiari ni kwa amri kwaa. ");
INSERT INTO ndg_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Natamaniya kila yumo abe kati nenga yanibile. Lakini kila yumo abile ni karama yake kuoma kwa Nnongo. Ayoo abile ni karama yee, ni yolo abile ni karama yenge. ");
INSERT INTO ndg_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Kwa balo baolewa kwaa ni ajane nabaya kuwa inanoga kwabe kati bakibaki bila kobekwa, kati yanibile nenga. ");
INSERT INTO ndg_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Lakini kati baweza kwaa kuizuia, bapalikwa kobekwa. Kwa mana heri kwabe kobekwa kuliko beka tamaa. ");
INSERT INTO ndg_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Nambeambe kwa balo bakobekwile niapeya amri, nenga kwaa ila Ngwana.”Nnyumbo kana atengane ni nchengo bake.” ");
INSERT INTO ndg_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Lakini kati aitenga boka kwa nchengo wake, atame bila kobekwa au apatane ni nchengowe. Ni “nchengo kana ampeye talaka nnyumbo bake.” ");
INSERT INTO ndg_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Lakini kwa benge, nalongela nenga, Ngwana kwaa kuwa kati nongo yoyote abile ni nnyumbo ywaaminiya kwaa ni aridhika tama naywembe, apalikwa kwaa kunneka. ");
INSERT INTO ndg_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Kati nnwawa abile ni nchengo ywaaminiya kwaa, ni mana atiridhika tama niywembe, kana anneke. ");
INSERT INTO ndg_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Kwa nchengo ywange aminiya alowa takasika kwa sababu ya imani ya nnyumbo bake. Ni nnwawa ywange aminiya alowa takasilwa kwa sababu ya nchengo ywaaminiya. Ila bana winu wapalika pangilwa safi kwaa, lakini kwa kweli batitakasilwa. ");
INSERT INTO ndg_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Lakini mpenzi ywange aminiya mana abokite ni ayende. Kwa namna yee, muinja au nnombo atabilwa kwaa ni iapo yabe. Nnongo atukemile tutame kwa amani. ");
INSERT INTO ndg_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Utanga namani mana nnwawa, panga waweza kunnopwa nchengowo? Au utanga namani kati nnalome, panga waweza kunnopwa nnyumbowo? ");
INSERT INTO ndg_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Kila yumo atama maisha kati Ngwana yaatuchawile, kila yumo kati Nnongo yaabakemile bembe. Awoo nga mwongozo wango kwa makanisa goti. ");
INSERT INTO ndg_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Abile ywabile atitahiriwe paakemilwe amini? Kana ajaribu kuboywa alama ya tohara yake. Abile yeyote ywakemelwa mu'imani atairiwa kwaa? Apalikwa kwaa tairiwa. ");
INSERT INTO ndg_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Kwa lee aidha atitairiwa wala ywabile kwaa tairiwa ntopo matatizo. Chabile ni matatizi ni kuitii amri ya Nnongo. ");
INSERT INTO ndg_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Kila yumo abaki mu'wito kati yaabile akemilwe ni Nnongo kuaminiya. ");
INSERT INTO ndg_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Ubile mmanda muda Nnongo akukemile? Kana ujali kuhusu lee. Lakini mana waweza kuwa huru, panga nyoo. ");
INSERT INTO ndg_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Kwa yumo ywakemilwe ni Ngwana kati mmanda ni mundu huru katika Ngwana. Kati yelo, yumo ywabile huru paakemilwe amiya na pangika mmanda wa Kristo. ");
INSERT INTO ndg_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Muyomwile pemewa kwa thamani, nga nyoo kana mube amanda ba bandu. ");
INSERT INTO ndg_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Ainja ni alombo bango, katika maisha yoyote kila yumo witu patukemilwe aminiya, tutame nyonyonyo. ");
INSERT INTO ndg_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Nambeambe, balo bote ambao bange kobeka kamwe, nibile kwaa ni amri boka kwa Ngwana. Lakini niapeya mawazo gango kati yanibile. Kwa huruma ya Ngwana, zazibile aminilwa. ");
INSERT INTO ndg_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Kwa eyo, nawaza nyoo kwa sababu ya usumbufu, ni vyema nnalome abaki kati ya abile. ");
INSERT INTO ndg_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Utabilwe kwa nnwawa ni kiapo sa ndoa? Kana uupale uhuru boka kwa yoo. Ubile ni uhuru boka kwa nnyumbo au ukobekwa kwaa. Kana umpale nnyumbo. ");
INSERT INTO ndg_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Lakini mana ukobike, upanga kwaa sambi. Na mana nnwawa akobekwa kwaa mana akobekwe, apangite kwa sambi. Bado balo bakobekane bapata masumbufu ga aina mbalembale. Ni nenga nataka nibaepushie ago. ");
INSERT INTO ndg_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Lakini nabaya nyoo, ainja ni alombo bango, muda ni mwipi. Tangu nambeambe ni kuyendelya, balo babile ni anyumbo babe batame kati babile nabo kaa. ");
INSERT INTO ndg_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Bote babile ni huzuni baipanga kati babile kwaa ni huzuni, na bote bapuraike, mana babile ni puaraika, na bote bapemile kilebe chochote, mana hawakumiliki chochote. ");
INSERT INTO ndg_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Ni bote baishughulisha ni ulimwengu, bawe kati batishughulika kwaa nakwe. Kwa mana mitindo ya dunia iikite mwisho wake. ");
INSERT INTO ndg_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Napala mube huru kwa masumbufu yoti. Nnalome ywakobeka kwaa ywajisuhulisha na ilebe yaimhusu Ngwana, namna ya kumpendeza ywembe. ");
INSERT INTO ndg_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Lakini nnalome ywakobike ujihusisha na makowe ga dunia, namna ya kumpendeza nnyumbo bake, ");
INSERT INTO ndg_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","atigawanyika. Nwawa ywakobekwa kwaa au bikra ujihusisha ni ilebe ya Ngwana, namna yee uitenga mu'yega na katika roho. Lakini nnwawa ywakobekwile hujiusisha kuhusu ilebe ya dunia, nmana ya kumpuraisha nchengo wake. ");
INSERT INTO ndg_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Nabaya nyoo kwa faida yinu mwabene, na naubeka kwaa mtego kwinu. Nabaya nyoo kwa kuwa ni haki. ili kwamba mwaweza kuibeka wakfu kwa Ngwana bila kikwazo sosote. ");
INSERT INTO ndg_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Lakini mana mundu aweza kwaa kumetendea kwa heshima mwana mwali wake, kwa sababu ya hisia yake zabile ni ngupu muno, leka akobekane ni ywembe kati apendavyo. ");
INSERT INTO ndg_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Lakini mana apangite maamuzi ya kobeka kwaa, ni ntopo haja ya lazima, ni mana aweza kuitawala hamu yake, alowa panga inoite kati ankobeka kwaa. ");
INSERT INTO ndg_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Nga nyoo, ywamkobeka mwana mwale wake apanga inoite, ni yeyote ywachawa kobeka kwaa apanga inoite muno. ");
INSERT INTO ndg_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Nwawa atabilwa ni nchengo wake w